﻿USE sofia;
DROP TABLE IF EXISTS sofia.cavNT_vpl;
CREATE TABLE cavNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cavNT_vpl WRITE;
INSERT INTO cavNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo jucuareque micuana cuejaya. David eque ejuracanaque tu jucuare. David bacue Abraham equeque. Riya cuanaque ri Jesucristoja baba cuana jucuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham tu Isaacja etataque jucuare. Isaac bacue Jacobja etataque. Jacob tu Judája, tuatsehuequi cuanaja jadya etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá tu Fares, Zara jadyaja etataque jucuare. (Tatseja ecuaquedya tu Tamar jucuare). Fares tu Esromja etataque jucuare. Esrom bacue Aramja etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram tu Aminadabja etataque jucuare. Aminadab bacue Naasónja etataque. Naasón tu Salmónja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón bacue Boozja etataque. (Boozja ecuaquetu Rahab jucuare). Booz tu Obedja etataque jucuare. (Obedja ecuaque tu Rut jucuare). Obed tu Isaíja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí tu ecuari Davidja etataque jucuare. David tu Salomónja etataque jucuare. (Salomónja ecuaque tu Betsabé jucuare, Urías yanumeja ehuaneque jucuareque). ");
INSERT INTO cavNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón tu Roboamja etataque jucuare. Roboam bacue Abiasja etataque. Abiás tu Asaja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa bacue Josafatja etataque. Josafat tu Joramja etataque jucuare. Joram bacue Uziasja etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías tu Jotamja etataque jucuare. Jotam bacue Acazja etataque. Acaz tu Ezequiasja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías bacue Manasésja etataque jucuare. Manasés bacue Amónja etataque. Amón tu Josiasja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías bacue Jeconiasja, tuatsehuequi cuanaja etataque jucuare. (Babiloniaju tuna erisi dujutanacuare, jetiama umae tunaja ata cuana tsehue). ");
INSERT INTO cavNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jeconías tu Salatielja etataque jucuare. Salatiel bacue Zorobabelja etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel tu Abiudja etataque jucuare. Abiud bacue Eliaquimja etataque jucuare. Eliaquim tu Azorja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor bacue Sadocja etataque. Sadoc tu Aquimja etataque jucuare. Aquim bacue Eliudja etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tu Eleazarja etataque jucuare. Eleazar bacue Matánja etataque jucuare. Matán tu Jacobja etataque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob bacue Joséja etataque. José tu María tsehue caquemiticuare. Riyaque epunadya tu Jesúsja ecuaque jucuare. Riyaque Jesúsdya tuque ecuana “Mesías” bacani jadya aya, “Yusuja Emepeque” jadique. ");
INSERT INTO cavNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Riya cuanaqueri Mesiásja ebaba cuanaque jucuare. Abraham equeque David tu anicuare peadya tunca pushi earacana ebaba cuanaque. David equeque ecuanaja baba cuana Babiloniaju dujutanacuare patya tujatu anicuare peadya tunca pushi earacana nucadya. Tuna dujutanacuare patya equeque tuque cuinanacuare eque tuna anicuare peadya tunca pushi earacana nucadya. ");
INSERT INTO cavNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cuatsabiji micuana aya Jesucristo eje bucha cuinanae cuita jucuareque. Tuja ecuaque Mariatu José tsehue caquemiti ishuque jucuare. Tatse caquemitima jariju, Joséja jipema jariju cuitadyatu carecani isaqui jucuare Yusuja Espirituja casa eque. ");
INSERT INTO cavNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josétu Yusuja cacuatsashati eque anicara juhua. Jadya tibudya tujatu carecani isaqui baatsu, jacacara acuare. Jadya ama bucha tuja tuatsehue canerecabati aniya tibu, tujatu etehua tyau acara acuare quirica tatse cajacati ishuque, dutyaja yacuaju bahue ameretsu tuque ebisuturau tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tumeque inime tupuqui ayaque tahuitsutu barepa juque Yusu tsahuaquira isaracuare tahuiju: —José, miquemi David eque ejuracanaque. Arepa María carecani isaqui ama bucha, jabama tu ni ejeque ecuitaja buchique. Tuja ebacua ecarecaniju badeyaque tu Yusuja Espíritu equeque. Bisuume tuque micue etareju duju ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Deca nana piji tujatu cuinanaya. JESUS tuja ebacani paju. (Riyaque ebacani tu “INAJACAMEREQUIQUE” jadique). Jadya bacanietu juya, tuque tuja cuanaque inajacamerequi jubuque tibu, tunaja jucha cuana apupashaqui jubuque tibu, —jadyatu barepa juque Yusu tsahuaquira José acuare tahuiju. ");
INSERT INTO cavNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Berutu quisarati cuejaqui eque Yusura cuejacuare eje bucha judadiyaque: “Epuna deca jipemaquetu carecani isaqui jubuque. Cuinanabuque tujatu ebacua. EMANUEL bacanitu jubuque” (‘YUSU ECUANA TSEHUE’ jadique), jadyatu Yusura quisarati acuare beru. Jesucristo cuinanahuajutu tura quisarati iyahua eque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tahuiyaque cabatietitsutu José barepa juque Yusu tsahuaquira cuejahua equedya jucuare. Caquemiticuaredya ecatse María tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tumetu arepa caquemitihua ama bucha Joséra jabahuishacuare ama tuja ebacua cuinanaya tupu. Ebacua nana cuinanahuajutu Joséra JESUS bacanidya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes ecuanaja yahua naruqui jucuare patyatu Jesús cuinanacuare Belén bacani epu eje ariju ama. Riyaque eputu Judea yahuaju jucuare. Tuequedyatu junacuare Jerusalénju ecuita cuana dyaque bahue cuanaque ijeti cuinanaya queja amaca aniya cuanaque. Tuna tuna purari cuana riyaque yahuaju eje bucha judadiyaque bahue juishu cabahuityatiyaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tuhua junatitsu tunajatu bacaduranaticuare: —¿Are, eje queja ri israelita cuanaja ecuari judadiyaque cuinanachineque? Ijeti cuinanaya queja amaca tuque ecuana bachine purari, amena cuinanachine jadique adeba ishuque. Rehua ecuana jehua tuque pureama ara, —jadya tunajatu anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes enaruquique tunara eje buchique bacadurayaque bahue juatsu tujatu bape inime tupucuare, tuque cuaredadiqui juyaque bucha baatsu. Tumebaedya Jerusalénju cuanara enaruquique iyacuaquepa cuinanachine jadya bacatsu, eje bucha adebataqui ama bape bape jutidya tunajatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Herodesratu ihuaramerecuare pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque jadya. Tuna junatihuaju tuna Herodesra bacaduracuare: —¿Eju Yusuja Emepeque cuinanadadiya? jadyatu Yusu equeque quisarati cuejaqui cuanara cuejacuare, —jadya tujatu ecana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tunaratu quemitsacuare: —Belénju patu cuinanabuque. Belénju Judea yahuaju patu cuinanabuque. Miqueas Yusu equeque quisarati cuejaquiratu beru huenecuare: ");
INSERT INTO cavNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Belén tu epu eje arique ama yahua ecuanaja ebaba Judá tyatanacuareque. Aniyatu peya epu dyaque arida cuanaque. Jadya ama buchatu tumeque epu piji dyaque emuique judadiya, tuhua enaruquique dyaque inime metseque cuinanabuque tibu. Israel eque ejuracana cuanaque ecue cuanaque tujatu ecana narudadibuque”, jadyatu ehuene Yusuja quisarati, —jadyatu jucuare israelita cuanaja huaraji cuana. ");
INSERT INTO cavNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jadique bahue juatsutu Herodesra dyaque bahue cuanaque tuna cuita camadya ihuaramerecuare. Junatihuaju tujatu ecana bacaduratsacuare: —¿Ejeque huecacatu purari ejitaju jumetse juchine micuanara ique bacadurahuaque? ");
INSERT INTO cavNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tunara cuejahuaju tujatu ecana cuadishacuare. —Necuacue Belénju. Ita nebaticue. Pana bau neaticue tumeque ebacua nana. Dadititsu reequedya nejuetinucacue. Necuejaeticue ique. Era dyadi pureamadya paati, —jadyatu Herodes jucuare, ai muicara aatsu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Herodesra jadya ahuajutu ecuita cuana cuanucacuare. Purari, ijeti cuinanaya queja amaca ejitaju juhuaquetu tunaja yacua queja ajequenanucacuare tuna eju cuita juti ishu bahue juishu. Ebacua nana aniya dyaque junatitsutu purari netinaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Purari tuhua netihua baatsutu ecuita cuana dyaque pureama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Etareju tuna nubicuare. Etareju nubinatitsu tunajatu ebacua nana banaticuare ecuaque María tsehue. Ebacua nanaja yacuaju tuna chichucata junaticuare tuque muiyaque. Jadya juatsu tunajatu caju caca cuana pacashacuare. Pacashatsu tunajatu ebacua nana tyacuare tuja ishu bechine cuanaque. Tyacuare tunajatu oro, tumebaedya beta acuimadi bapebapeque ijimedaque tsuje aridaque, “incienso”, “mirra” jadya bacani. ");
INSERT INTO cavNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ebacua nana amena muihuaju tuna Yusura tahuiju cuejacuare dirunucayaque Herodes aniya eque ama dirunuca ishu. Jadya tibudya tuna Jerusalén eque ama cuetidirunucacuare tunaja yahuaju dirunucayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Purari cuana eje buchique bahue cuanaque dirunucahuajutu barepa juque Yusu tsahuaquira tahuiju José cabamereti ishu acuare Yusuja quisarati cueja ishu. —Isaranaya mique era. Netitsuracue. Cabajejeticue. Huanaquerecue ebacua nana Egiptoju tuja ecuaque tsehue. Tuhuadya anidirucue jari, era mique micue yahuaju dirunuca ishu cuejaya tupu. Herodesratu sareya ebacua nana iye ishu, —jadyatu José barepa juque quisarati cuejaquira cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jadya cuejahuajutu José netitsuracuare. Tumeque meta cuitadyatu José, ebacua nana, ecuaque jadya tsehue huanacuare Egiptoju. ");
INSERT INTO cavNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tuhua tuna anidirucuare Herodes majuya tupu. “Egipto juque tuque ecue Ebacua ihuarahua”, jadya patu jucuare Yusu tuja quisarati cuejaqui eque. Tumetu ebacua nana Egipto juque juetinucahuaju, Yusura quisarati acuare bae cuitadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Dyaque bahue cuanaque Jerusalén eque ama judirunucahuajutu Herodes dyaque ecahuaiti cuita jucuare, tunara ijahue ahua bucha cabatitsu. Cuadishacuaretu tuja sudaru cuana Belénju. —Neiyetillaticue dutya ebacua deca nana cuana tsuneedya cuinana cuana eque, beta mara tupu cuanaque. Neiyecue Belénju aniya cuanaque camadya ama, tumebaedya epu japadama aniya cuanaque, —jadya tuna Herodesra acuare. Jadya tujatu ecana amerecuare, dyaque bahue cuanara beta maratu butseeju tumeque purari amena ejitaju jucuareque, jadya acuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jeremías Yusu equeque quisarati cuejaquira patu icuenetadya cuejacuare tumebae cuitadya judadibuqueque: ");
INSERT INTO cavNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramáju taa peya inime, paa tsuri jadya bacataqui jubuque. Raquel tu tuja ebacua cuanaque jiteque pabuque. Ni aija isaratsu casaturataquimatu paya tuja ebacua cuanaque jiteque, dutya iyetillatahua tibu”, jadyatu Jeremiasra beru yuequedya huenecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes majuhuajutu Yusura cuadishacuare barepa juque etsahuaquique Egiptoju. Tahuijutu José queja cabameretinucacuare. Isaracuare tuja tuque: ");
INSERT INTO cavNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Netitsuracue. Yudijidya dirunucacue micue yahuaju nucadya ebacua piji, ecuaque tsehue Israelju. Herodes, peya cuana, ebacua nana iyecara jucuare cuanaque tuna amena majuchine, —jadyatu quisarati bepujira acuare José. ");
INSERT INTO cavNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jadya ahuajutu José netitsuracuare. Dirunucacuare Israelju ebacua piji tsehue, ecuaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Dirunucatsu tujatu bacacuare quisarati. Arepa Herodes majucuare ama bucha, tuja ebacuaque Arquelao etataque cuarequi enaruquique. Jadya bacatsutu José bajida jucuare Judeaju dirunuca ishu, Arquelaora dyadi ebacua piji iyecara anucaya bucha baatsu. Tahuijutu Yusura cuejacuare tuna eju diru ishu. Jadya tibudyatu dirucuare ebacua piji, ecuaque jadya tsehue Belénju ama. Galilea yahuaju tuna dirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tuhua judirutsu tuna anidirucuare epu Nazaret bacaniju. Icuene Yusu equeque quisarati cuejaqui cuanara patu cuejacuare: “Yusuja Emepequetu nazareno bacani jubuque” jadya. Jadya eque tuna Nazaretju anidiruhuaju, tunara icueneta cueja acuare bae cuitadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tsunuda juatsutu Yusuja quisarati cueja puji ejitaju jucuare Judea yahuaju epu japadama anitaya cuanaju. Tumeque ecuitatu Juan Ecuita Cuana Utsaquique bacani jucuare, ecuita cuana utsayaque junenicuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tura tuna cuejacuejanicuare: —Necacuareticue inime, Yusuja micuanaja jucha cuana apupasha ishu. Tsunutaya amatu Yusuja Emepeque ejitaju juishu. Ejetsunue amadyatu tumeque enaruqui jutibune ishuque, —jadya tuna Juanra cuejacuejanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Beru yuequedya Yusu equeque quisarati cuejaquique Isaiasratu huenecuare: “Quisarati cuejatu jubuque ejeque cuana tsecada eje uma piji anitaya cuana queja. ‘Nequihuaticue, Ecuana Cuatsashaquique junayaju ishu. Jidamaque neajacacue. Jida tuyu nejucue, ediji benubenuque etuyune ejuu bucha’”. Juan tu Isaiasra jadya acuare, tsecada anitaya cuanaju quisarati cueja judadiya jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanratu jutucuare camello tsaru etarique etataque ejutuqui eaque, baya ecuita cuanadya jutidya cajututiya bucha. Ebiti patsa quinida ejicui tsehuedya jutidyatu ecaquereti jucuare. Tsei ebari, huaja jadya tujatu araaranicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jetiama epu cuanajuratu quisaratiyaju ijacabacati bahue jucuare. Jerusalénju cuanaque tuna tuhua cuacuare. Judea yahuaju peya epu cuana juque, Jordán cueri japadama anicuare cuanaque, jadya tuna cuabahue jucuare Juan quisarati cueja juyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tura quisarati cuejayaju bacatsu, —Yuneridya ecuana jucha arida, —jadya tuna cacuejaticuare. Jadya tuna cacuejatihuaju tuna Juanra utsacuare Jordán cueriju. ");
INSERT INTO cavNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","8","Juanratu jetiama fariseo cuana, saduceo cuana jadya batsacuare tuaqueja cutsameretira cuayaju. Batsatsu tujatu ecana atsacuare: —Cutsameretimaquedya necabamereticue inime cacuaretihuaque, cajuchaticarama juyaque jadya. Bacua cuana yachi tiruyaju eje buchadya huanacara ejuu bucha micuana juya. Cutsameretitsu Yusura enerecaturauque ehuanau bucha tuque micuanaja inime juya. Jadya ama tuque. ");
INSERT INTO cavNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Abraham eque ejuracanaque tibu, ecuana Yusura nerecaturabuque ama”, jadya micuanaja inime paju ama. Dyaque inime metseque juishuque ama tu Abraham eque ejuracanaque. Cuejaya micuana era. Yusujatu aniya casa riyaque tumu cuana Abraham eque ejuracanaque amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Micuana micuana acui cacacati baecuaque bucha. Acui cacacati baecuaque tu jacha tsehue cuere, pahua jadya aishuque. Jadya micuana Yusura abuque, micuana inime cacuaretiyaque ama juatsu. Acui cuere bahuera eau bucha tura micuana abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Era tuna utsaya ena tsehue, jucha cuana aniyaque caadebatitsu inime cacuaretihua cuanaque. Tsunutaya amatu peya junayaque. Tujatu dyaque casa aniya, ecue bucha ama. Tuque baatsu ique ni aishuquedya jutidya; mere puji tuja patrón tsehue beta tupu ama ejuu bucha jutidya ique. Tume junayara micuana Yusuja Espíritu tyanaya, tujaque jadique adebataqui juishu. Tuaqueja catyaticarama juya cuanaque tujatu nerecaturabuque ijahuaja etiquiju. ");
INSERT INTO cavNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ecuita trigo iruru, tsaje jadya aishuque buchique tu Junayaque. Turatu tuja cuanaque nityasicuanabuque tunaja ishu cuita emajacaju, ecuita trigo etareju equiyatiu bucha. Tuja ama cuanaque bacuetu ijehuebuque nerecatura ishu etiqui ticu baecuaju, trigo tsaque epahuata bucha, —jadya tuna Juanra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Tumetu Jesús jecuare Galilea juque, Jordán cueri japadama Juan quisarati cueja juyaju, Juan queja cutsameretira. ");
INSERT INTO cavNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tuque jutihuajutu Juanra utsacarama acuare, Jesús tuque buchique ama baya tibu. —Micue di taa ique utsataqui. Mique equeque di taa tu Yusuja Espíritu eaqueja jutaqui. ¿Eje bucha juatsu jatsumi jeya eaqueja enaju cutsameretira? —jadyatu Juanra Jesús atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesusratu quemitsacuare: —Iyacua jadidya jutidya paju. Yusura amereyaque tuque yatseja ataqui, —jadya tujatu acuare. Jadya tura ahuaju, en aatsutu Juanra utsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Utsahuajutu Jesús ena juque cuinanacuare. Ena juque cuinanayajutu barepa pacashatanacuare. Bacuaretu Yusuja Espíritu huei jiuque tuque dyaque buteyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tume tujatu barepa juque etsuri bacacuare. Yume tucuetu jucuare tuja Etataque Yusu. —Riyaque rique ecue Ebacua dyaque iyuhuedaque. Ique dyaque pureama juya tuatsehue, —jadyatu Yusu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tuequedyatu Yusuja Espiritura Jesús dujucuare japada peya queja amaca anitaya amaju, Satanásja nime adeba ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Pushi tunca huecaca, pushi tunca meta jadyatu arama jucuare. Jadya juatsutu amena aracara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Satanasratu Jesús jipecuare, cajuchatishacara aatsu. —Yusuja Ebacuaquepa mique, jadyami juya. Jutaquiju riyaque tumu pan cacueyatishacue, —jadyatu Satanásra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusratu quemitsacuare: —¡Aama! ¡Aya ama tuque era! Ehuene tu Yusuja quisarati: “Earaqui tsehue jipidya amatu Yusura ecuita cuana anishaya. Tumebaedyatu Yusuja dutya cacuatsashati eque anitaqui”, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jadya juatsutu Satanásra Jesús, Jerusalén bacani epu aridaju dujucuare. Dujutsu tujatu tsuraquerecuare Yusuja etare camahua barudaju. ");
INSERT INTO cavNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—Putitanacue reeque. Yuneridya ni mi Yusuja Ebacuaque, tumemi ujeda ecatiu ama, Yusuja quisarati jadya ehuene tibu: “Yusuratu cuadishaya barepa juque tuque tsahuaqui cuanaque mique naru ishu, mique pacacayaju inatsa ishu, mique ni riya piji buchique ujeda cati ishu ama, tumura ehuachiju ujeda eauju” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesusratu acuare: —¡Aama! ¡Aya ama tuque era! Tumebaedya tu Yusuja quisarati ehuene: “Nime adebaume Yusu” jadya, —jadyatu Jesúsra Satanás acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tumetu Satanásra Jesús dujunucacuare emata dyaque barudaque matina. Tuequeradya tujatu bamerecuare dutya epu cuana riyaque yahua juque. Tumeque epu cuanaju dutya ai jida pijique aniya cuanaque tujatu bamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—Mira ique chichucata juatsu muiyaju, tume mique etyau dutya riya cuanaque, —jadyatu Satanásra Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—¡Aijama, Ijahua! ¡Micue yacuaju ique chichucata junime ama! Ehuene tu Yusuja quisarati: “Mique Cuatsashaquique Yusu camadya muicue. Tura cuatsashaya eque peadya camadya jucue” jadya. Dirucue rehuaque, Satanás, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tura jadya ahuajutu Satanásra jacacuare. Tumetu Yusu tsahuaqui cuanaque butecuare barepa juque Jesús tsahua, casatura jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Ecuita Cuana Utsaquique patu etare apudaju eishatana jucuare. Jadya bahue juatsutu Jesús Galileaju cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Anidirucuaretu Capernaumju, Nazaretju ama. Capernaum tu bei jiruru jucuare, ecuanaja ebaba ecatse Zabulón, Naftalí jadyaja yahua jucuareju. ");
INSERT INTO cavNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jadyatu jucuare, Isaías Yusu equeque quisarati cuejaquira icuenetadya quisarati acuare eque juya tibu: ");
INSERT INTO cavNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","16","“Pureamatu jubuque Zabulón, Naftalí ecatseja yahua jucuareju aniya cuanaque. Galileaju tuna aniya, Jordán cueriju ijeti nubiya queja amaca. Israelita ama cuanaque aniya japadama tuna aniya. Icuene tunajatu adebahua ama Yusuja quisarati. Eje buchadya jucara, huenanaya jadya tuna juhua, maju tsehue bajida juatsu. Tunaratu adebabuque Yusu. Enime casatura tuna jubuque”. ");
INSERT INTO cavNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tuequedyatu Jesús Yusuja quisarati cueja catibuticuare. —Necacuareticue inime. Yusu queja necatyaticue. Yusujatu adebamerehuie tuja Emepeque. Ejetsunue ama tu tuque enaruqui jutibune ishuque, —jadya tuna Jesúsra cuejacuejanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesústu Galilea bei jiruru eque dirucuare. Diruyara tujatu badirucuare beta jae puji ecatse. Peadyatu jucuare Simón. (Peya ebacani tujatu jucuare Pedro.) Peyatu jucuare Andrés, Simón tsehuequique. Jae deru ishuque enaju mare tatse jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesúsra tatse isaradirucuare: —Nejecue. Eatsehue nejunenicue. Metse metse jae puji ecatse. Iyacua metse era ecuita cuana Yusu adeba mere ishuque amereya, —jadya tatse Jesúsra adirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tumeque ura cuitadya tatse jae deru ishuque shanaquenatsu junenitibunecuare Jesús tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Cuabacanucatsu tujatu banucacuare beta ecuita ecatse. Jucuaretu Santiago, Santiago tsehuequique Juan jadya, Zebedeoja ebacuaque ecatse. Cuaba aridaju tatse juanicuare etataque tsehue, jae deru ishu cuanaque sipiani juyaque. Jesúsra tatse ihuaracuare tuatsehue juneni ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tura ihuarayaju bacatsu tatsejatu shanaquenacuare tatsera ai ayaque. Cuinanacuare tatse cuaba arida juque, etataque isaraquenatsu. Jadya juatsu tatse Jesús tsehue junenitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesústu junenicuare Galileaju dutya epu cuanaju. Nubi bahuetu jucuare caradati ishuque etare cuanaju, tuna bahuitya ishu. Nubitsu tujatu ecana cueja bahue jucuare quisarati jidaque. —Tata ecana, Yusura micuana tujaque amerecara aya; tura micuana narucara aya, —jadya tujatu ecana abahue jucuare. Chachanecuaretu ujejeda cuanaque, ejeque ujejedya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesús eje bucha juyaque tuna bahue juterecuare dutya Siria yahuaju aniya cuanaque. Tuque epuju judiruhuajutu ecuita cuanara dujubarecuare ujejeda cuanaque, tuja ecana chachane ishu. Dujubarecuare tunajatu ai ujera juya cuanaque, ijahua cuanara quijahuatishaya cuanaque, manu arida cuanaque, bucucutaquima cuanaque jadya. Jadya chachaneetu Jesúsra acuare bape bape ujeje tsehue cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jetie ecuitara amatu tupujudya anenicuare. Jecuare tuna Galilea juque, Peadya Tunca Epu Cuana juque, Jerusalén juque, Judea yahua cuana juque, Jordán cueri yueque macare aniya cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ecuita jetieque ama tuaqueja jutiya baatsutu Jesús tsuracuare emataju tura mepehua cuana tsehue. Tuque anibutehuajutu tura mepehua cuanaque caradaticuare tuque peque, tuja ecana bahuitya ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jadya bahuityae tujatu ecana atibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Dyaque jida taa tuna taca caadebati Yusu pureamaturayaque ama juya cuanaque, tuja tsahua ishu tunaja tuque saretaquique. Pusha ama cuitadya tuna Yusura naruya, baya jadya aya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Dyaque jida taa cajuchatitsu peya inime juya cuanaque. Arepa ecana peya inime, paya jadya juya ama bucha tuna Yusura nime casaturaya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Dyaque jida taa eje bucha cabatitsu abacata juya cuanaque. Tuna tuna Yusu jaque. Tura tuna tyaya dutya jidaque tura tyaana ahua cuanaque, Yusu dutya naruqui juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Dyaque jida taa Yusura amereya eque jucara ebari juya cuanaque, ecuana aracara, ijicara ejuu bucha Yusura cuatsashaya eque jucara ebari juya cuanaque. Yusura tuna tsahuaya tura amereya eque juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Dyaque jida taa peya cuana tsehue canerecabati aniya cuanaque. Yusujatu tuna tsehue canerecabati aniya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Dyaque jida taa Yusu pureamatura cuita camadya inime tupu juya cuanaque, ai riyaque yahua juque ama. Tunaratu badirubuque tuaqueja judirutsu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Dyaque jida taa ecahuaiti cuanaque jida inime bajeje, tsahua jadya juya cuanaque. Yusura tuna ‘Ecue ebacua rena’ jadya aya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Dyaque jida taa Yusuja biji eque juyaju jidama ataya cuanaque. Arepa ecana iyacua nerecada ataya ama bucha, pusha ama cuitadya tuna Yusura naruya, baya jadya aya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Dyaque jida taa micuana peya cuanara ijillahuanaya cuanaque, peya cuanara jidama aya cuanaque, yuneriju ama jadya micuana jadya ataya cuanaque. Arepa micuana jadya nerecada juya ama bucha, Yusura micuana narujacaya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Pureama nejujacaume. Necanimehuallatiume, barepaju Yusura dyaque jidaque tyatsabuqueque adebatsu. Micuana camadya ama micuana jadya canerecatie juya. Jadya nerecaturaedya tunajatu acuare beru yuequedya Yusu equeque quisarati cuejaqui cuanaque, Yusuja biji eque tuna aniya baatsu, —jadya tujatu ecana bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesúsra tuna bahuityanucacuare: —Banu ecuanaja ara ishuque cayuamatimaque etsumeu bucha, jadidya micuana Yusura tsumebuque ecue quisarati cueja ishu, dutya ecayuamatitereu tibu. Banuja ni, banu huaja etereu, aijamatu ni eje bucha banuqui amerenuca ishuque. Jidamatu ni aishu buchique. Ecuita cuanaja tapapasha ishutu ijehuetaqui etsecueju. Tumebaedya micuana micuana ni era cuatsashaya eque jujacaya, tume micuana ni aishu ejuu, Yusuja yacua juque ijehue ishuque jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Micuana equetu peya cuanara Yusu adebabuque. Udera apudaju eudau buchadyatu micuanara ecuita cuanaja inime huecashaya Yusu adeba ishu. Era micuana mepehua dutyara bayaju ique mere ishu, ai etehua ama, epu ebarucueque dutyara epetau bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Udetu tuchatanaya caju ducu tehua ishu ama, apuda ducu hueca ishu, etareju dutya pana peta aishu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tumebaedya tuque micuanaja Yusu meretaqui, etehua mere ama. Micuana dutyara petayaju micuana era cuatsashaya eque jutaqui, peya cuanaja micuana jida juyaque baatsu, micuanaja Tata Yusu barepa juque pureama aishu, —jadya tuna Jesúsra bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesúsra tuna bahuityanucacuare: —Paju ama micuanaja inime: “Jesús amena junahua tibutu Moisésra cuatsashahuaque amena iyataqui, Yusu equeque quisarati cuejaqui cuanara cuejahuaque tumebaedya”, jadya micuanaja inime paju ama. Ique jehua tume cuanaque aputashara ama; eje buchique cuita pana adebamerera jehua. ");
INSERT INTO cavNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yuneri cuitadya micuana cuejaya. Barepa, yahua jadya aniya jari tuputu ni ejeque cacuatsashati cuaretanaya ama ni apupashatanaya. Cacuatsashati cuana Yusura iyahua eque micuana anitaqui dutya tura eje bucha judadi ishuque inime iyahuaque judaditereya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Inime ni micuanaja juya: “Arepa Yusura amerehuaque ama bucha, aishuque cuita ama rique. Aniya ama riyaque cacuatsashati eque”, tume micuana dyaque jetiedyaque jubuque Yusu enaruqui juhuaju. Dyaque jidamadyatu judadibuque cuatsashaya eque ama ani ishuque bahuityaqui cuanaque. Jadya ama bucha Yusura cuatsashaya eque ni micuana aniya, peya cuana ni micuana cuatsashaya eque ani ishuque bahuityaya, tume micuana Yusu enaruqui juhuaju dyaque inime metseque jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Fariseo cuanara, cacuatsashati bahuityaqui cuanara jadyatu jidaque ayadya, ecuita cuanaja sumi ishu cuita camadya. Yusu queja ni micuana judirucara juya, ataqui tuque micuanaja jidaque Yusu pureamatura ishu, ecuita cuana pureamatura ishuque camadya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Micuanajatu ebacadya ecuanaja baba cuana bahuityatanacuareque: ‘Nequiyetiume. Ejeque quiyetiyaquetu dujutaya huarajija yacuaju, nerecatura, iye jadya ata ishu’. ");
INSERT INTO cavNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Era micuana cacuatsashati iyacuaque bahuityaya. Yurameta ujeu peya cuana tsehue necabatiume. Ejeque cahuaitiyaquetu Yusura quiyeti puji bucha nerecaturae eau. Ejeque cahuaitiyaquetu huarajija yacuaju edujutanau nerecatura ishu. Ejeque quijillahuanatiyaquetu edujutanau huaraji cuana ecasitatiju, nerecaturamereta ishu. Ejera ni peya aya, ‘Inimema, miquemi dyaque jidama’, tudya jutidyatu ijahuaja etiquiju ejudiruu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Netsunutaume peya tsehue inime bajeje ishu. Peya micuanara cahuaitishahuaque ura, jadya ama juatsu eje bucha ahuaque adebayaque ura inime nebajejeticue, arepa micuanara Yusuja etareju tuque pureama aya ama bucha, arepa micuanara behuaque Yusu tyahuie ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Tuhuadya micuanara tyaishu dujuyaque neiyacue jari. Icuene necuacue jari micuanaja ai inime aniya queja. Jida nebajejeticue jari inime tuatsehue. Amena jida inime bajejetitsu, necuanucacue Yusuja etareju, micuanara tyacara ahuaque amena netyaticue. ");
INSERT INTO cavNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ejera ni micuana huaraji queja cuejaya, dujucara ni tunara micuana aya, huaraji queja junatimaradya icuene jida inime nebajejecue. Icuenedya ni micuana inime ebajejeu ama, tume tunara micuana edujuu huaraji dyaque aridaja eaniquiju. Dujuhuaju micuana huarajira policía cuana queja edujumereu. Tume tunara micuana etare apudaju eishau. ");
INSERT INTO cavNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tuhua tunara micuana enityamereu, huarajira tsujebacayaque tsujetyatillaya tupu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesúsra tuna bahuityanucacuare: —Ebacadya tuque micuanaja beruque cacuatsashati: “Nejabaume epuna micuana tsehue caquemitimaque”. ");
INSERT INTO cavNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Era micuana cacuatsashati iyacuaque bahuityaya. Micuanaja caquemitiqueremaque jaba ishuque inime tupuqui neaume. Ejera tuja caquemitiqueremaque jabacaraque inime tupuqui ayaquetu jabahua bucha nerecaturae cuitadya Yusura aya. Arepa jabama ama bucha, Yusuratu ecajuchati baya, tumeque epuna jabacaraque inime tupuqui ahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Nejacacue cajuchaticaraque. Petaya ni micuana micuanaja petataquique ama, nehuicacue micuanaja yatuca cajuchatimaradya. Huicatsu neijehuecue, jidamaque petatsu ebijiseriu tibu. Cajuchatiajeyadya jutidya ni micuana, tume micuana ijahuaja etiquiju ijehuetanabuque. Dyaque jidatu Yusu queja atuca pidya camadya judirutaqui, ijahuaja etiquiju atuca beta enubidiruuque. ");
INSERT INTO cavNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Emetucu tsehue ni micuana ai jabataquimaque jabacara aya, necatubuticue cajuchatimaquedya. Catubutitsu neijehuecue, emetucu tsehue ecajuchatiu tibu. Cajuchatiajeyadya jutidya ni micuana, tume micuana ijahuaja etiquiju ijehuetanabuque. Dyaque jidatu metucu pidya camadya Yusu queja judirutaqui, metucu betaque ijahuaja etiquiju enubidiruuque. ");
INSERT INTO cavNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ebacadya tuque micuanaja beruque cacuatsashati: ‘Epuna ecaquemitiquerequetu ijehuetaquidya. Jacacara ni micuana aya, neinamerecue quirica eje bucha juatsu micuanara jacayaque cuejayque’. ");
INSERT INTO cavNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Era micuana cacuatsashati iyacuaque bahuityaya. Nequijehuetiume micuanaja huane tsehue. Eje bucha baatsu cuita camadya micuanaja huane jacataquique, micuanaja huane peya tsehue jarayaju daditsu cuita camadya. Epuna ni micuanara jacahuaju peya tsehue caquemitiya, tumetu epunara, deca iyacuara jadya Yusu cahuaitishaya, peyaja tsehue cajipetihua tibu, —jadya tujatu ecana bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesúsra tuna bahuityanucacuare: —Ebacadya tuque micuanaja beruque cacuatsashati: “Quejenemereticara ni micuana juya quisarati ahuaque, ‘Yusu bahue’ jadya nejucue. Micuanara aana ahua equedya nejucue”. ");
INSERT INTO cavNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Era micuana cacuatsashati iyacuaque bahuityaya. “Yusu bahue” jadya quisarati neaume. Micuanara ni yunerique quisarati ajacaya ama, tumetu aijamadya quejenemereti ishu, Yusu bacani huesa ishu. “Barepaju aniyaquetu bahue que yuneri quisaratiyaque”, jadya quisarati neaume. Yusu tuque micuana bacani huesaya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","“Riyaque yahua iyaquiquetu bahue ique yuneri quisaratiyaque”, jadya nejuume. Yusu tuque micuana bacani huesaya. “Jerusalénju aniyaquetu bahue ique pusha pusha ama juyaque”, jadya nejuume. Yusu tuque micuana bacani huesaya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","“Ique yuneri ama quisaratiyaque juatsu ique papajata”, jadya neaume quisarati. Ecuanara ni tu eje bucha cacuaretishae ama etsaru pajada, sehueda jadya ni peadya etsaru buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ai ni micuana aana aya, neacue quisarati barema. Aana ama ni micuana ai aya, neaume. Micuanara quisarati aya equedya neacue, “Yusu bahue” jadya tsehue ama. Quisarati ejenemerecara ebarique tu Satanás jaque jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ebacadya tuque micuanaja beruque cacuatsashati: ‘Ejera jidama ayaju etsuje nejucue. Ejera ni peya yatucaju ujeda aya, yatucajudyatu peya paanuca. Ejera ni peyaja etse jupuya, tuja etse dyaditu pajupunucadya’. ");
INSERT INTO cavNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Era micuana cacuatsashati iyacuaque bahuityaya. Ejera jidama ayaju, etsuje jucara nejuume. Jida tsehue jutidya nebacue. Ejera bahuapajayaque juatsu, peya ebahua eque necatimerenucacue. ");
INSERT INTO cavNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ejera ni micuana huaraji queja cueja ishu dujuya, huarajira ni micuana aya, ‘Mique jidamapa ejuu jadya cuejaquique micue camisa tyacue’, camisa camadya ama tyacue. Micue chompa tyanucacuedya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ejera ni micuana tura abuyaque casada tsehue japadama dujumereya, japada tuque tsahuayaque nedujucue. ");
INSERT INTO cavNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ejera ai bacayaquedya netyacue. Ejera ni micuana ai masadama tyanuca ishu bacaya, netyacue, —jadya tujatu ecana bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesúsra tuna bahuityanucacuare: —Ebacadya tuque micuanaja cacuatsashati beruque: “Iyuhueda nebacue micuana iyuhueda baqui cuanaque camadya. Micuana ujeu baqui cuanaque ujeu nebacue”. ");
INSERT INTO cavNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Era micuana cacuatsashati iyacuaque bahuityaya. Iyuhueda nebacue micuana ujeu baqui cuanaque. Micuana jidama quisarati tsehue apuji cuanaque jida nebacue. Yusu queja nebacabacacue micuana ijillahuana, jidama aqui cuanaja ishu. “Jida jucue ique ujeu, jidama jadya aqui cuana tsehue”, jadya Yusu neacue. ");
INSERT INTO cavNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Yusu tu jida dutya tsehue. Micuanara peya cuana jida tsehue bayaju, micuana ejitaju juya yuneri cuitadya micuana Etata Yusu barepaju aniya jaque. Turatu ijeti hueca cuinanashahuecacaya jidama cuanaja ishu, jida cuanaja ishu jadya. Nei bacue jida, jidama jadya cuanaja jida ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Inime micuanaja paju ama: “Yusura ecuana tyabuque jidaque, ecuana iyuhueda baqui cuanaque camadya ecuanara iyuhueda bayaju”. Butsee jidama juya cuanaratu iyuhueda baya tuna iyuhueda baqui cuanaque. Butsee huarajija ishu chipiru sitaqui cuanaque tuna jadya juya. ");
INSERT INTO cavNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Micuanara ni jida batsaya micuana iyuhueda baqui cuanaque cuita camadya, “Ecuana ecuana peya cuana bucha dyaque jida”, jadya micuanaja inime paju ama. Butsee Yusu adeba baecua cuanajatu tuna iyuhueda baqui cuanaque jida batsa bahue. ");
INSERT INTO cavNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Dutya tsehue jida anicara nejucue. Micuanaja Tata barepa juque bae nejucue. Jida tsehue nebacue peadya peadya ecuita cuana, —jadya tuna Jesúsra bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesúsra tuna bahuityanucacuare: —Tsahuaya ni micuana peya cuana, netsahuacuedya peya cuana queja capetamereti ishu ama. Dutyara bayaju ni micuana aya, peya cuanara micuana sumiya. Jadya ama bucha micuanaja Tata barepajura micuana tyabuque ama ni ai jidaque peya tsahuahua tsuje. ");
INSERT INTO cavNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Jadya tibudya nerecada cuanaque tsahuatsu, necasumitiume ai tyaatsu; Yusu adebaquipa ejuu jadya juya cuanaque bucha nejuume. Nerecada cuanaque tsahuatsu tuna cacuejatiya dutya queja tunara jidaque mere ahuaque, caradati ishuque etare cuanaju, edijiju juneniyaque jadya. Ecuita cuanaja jida baishu jutidya tuna jadya juya. Ecuita cuana ni tu tunaja ishu jida quisaratiya, Yusu bacue aijama. Riyaque yahuaju camadya tunajatu jidaque inime baya. Yusura tuna jidaque tyadadibuque ama ni riya piji buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nerecada cuanaque tsahuatsu necacuejatiume ni eje quejadya jutidya. Ni ejeque micuanaja iyuhueda queja necacuejatiume. ");
INSERT INTO cavNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ejeque cuejamaque neacue. Micuanaja Tata dutya petaquiratu baya eje bucha micuana juyaque. Tura micuana jida juya baatsu dyaque jidaque tyabuque, —jadya tujatu ecana bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesúsra tuna bahuityanucacuare: —Micuana Yusu tsehue quisaratiyaque, ecuita cuanaja sumi ishu jutidya nequisaratiume; Yusu adebaquipa ejuu jadya juya cuanaque bucha nejuume. Tunaratu dutya bahue amerecara aya tuna Yusu tsehue quisaratiyaque. Jadya tibudya tuna Yusu tsehue quisarati neti bahue caradati ishuque etare cuanaju, ejudya jutidya ecuita cuanaja peta ishu. Ecuita cuana camadyatu tunaja ishu jida quisaratiya, Yusu bacue aijama. Riyaque yahuaju camadya tuna tyatanaya tuna jida pureama juishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Era micuana bahuityaya. Arepa Yusu tsehue quisarati ishu casitatitaqui ama bucha, jida nucadyatu yatse taca Yusu tsehue quisarati ishu. Jadya juyaque nenubicue eju aira buchique sicacaturaya amaju. Nubitsu etsecue necateriticue. Micuanaja Tata Yusu tu tuhuadya micuana tsehue. Nequisaraticue tuatsehue. Turatu adebayadya micuanara inime tupuyaque. Turatu bacayadya micuana tacara tuque cuejayaque. Tura micuana jida juya baatsu, dyaque jidaque tyadadiya. ");
INSERT INTO cavNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Yusu tsehue quisaratiyaque, tumeque quisaratidya jutidya atinuca atinuca neaume; Yusu adebaquipa ejuu jadya juya cuanaque bucha nejuume. Tunajatu inime juya, quisarati ahuaquedya atinuca atinuca ayaju Yusura bacaya bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tuna bae nejuume. Yusu tuque micuanaja Tata. Turatu berudya adebahua micuanara ai sareyaque, micuanaja bacamajudya. Jadya tibudya tuque micuanaja tumeque quisarati atinuca atinuca ataqui ama. ");
INSERT INTO cavNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jadya Yusu tsehue quisaratiyaque nequisaraticue: ‘Ecuanaja Etata barepaju aniyaque, muiba ishuque mique. Adebaya mique ecuana juchama nerique. ");
INSERT INTO cavNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Pajuetihuisha huecaca micue ecuana naru ishuque. Barepaju micue inime dutya juya bucha, tumebaedya paju dutya rehua riyaque yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Tyacue ecuana riyaque huecaca ara ishuque ecuanara sareyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Apupashacue ecuanaja jucha cuana. Ecuana peya cuanara jidama ayaque nime aputaya bucha, jadidya ecuanaja ecuana jidama juya cuanaque apupashacue. ");
INSERT INTO cavNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Satanásra cajuchatishacara ayaju, ecuana tsahuacue, ecuana ecajuchatiuju. Miquemi enaruqui. Miquemi dutya casa tsehueque. Miquemi eje tupu mui, pureama jadya ajaca ishuque ama. Jadidya paju’, jadya neacue Yusu tsehue quisaratiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Micuanaja Tata barepajura tuque micuanaja apupashaya micuanara jidama ahuaque, micuanara, micuana jidama aquique nerecabayaque juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Micuanara ni peya nerecabaya ama, tume tuque micuanaja Tatara dyadi apupashaya amadya micuanaja jucha cuana, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesúsra tuna bahuityanucacuare: —Yusu mui ishu arama quibetiyaque, micuana jadya juyaque ni eje quejadya jutidya necaadebameretiume. Yusu adebaquipa ejuu jadya juya cuanaque juya bae nejuume. Tunaratu dutya bahue amerecara aya tuna arama quibetiyaque. Peya inime tuna jubahue. Ramusu pahua muru tsehue ecana ebutsequiniju capepati bahue. Ecuita cuana camadyatu tunaja ishu jida quisaratiya, Yusu bacue aijama. Riyaque yahuaju camadya tuna tyatanaya tuna jida pureama juishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Micuana Yusu mui ishu arama quibetiyaque, pureama nejucue. Necajibururuticue. Cajibururutitsu necalluticue jida, micuana arama quibetiyaque peya cuanara eadebauju. ");
INSERT INTO cavNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Micuanaja Tata tu micuana tsehue. Tuquetu bahue dutya eje bucha micuana juyaque. Tura micuana jida pureama juishuque tyabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Nequiyatiajeume chipiru, riyaque yahuaju ai tsuje arida cuanaque. Micuana rehuaque quiyatiyaquetu muju cuanara eyuamaturau. Eaputatereu jutidya tuque micuanaja. Chiri puji cuanaratu echiriu. Tume tuque micuanaja aijama ejuu ni ai buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nequiyaticue Yusuja yacuaju micuana pureama juishuque. Micuana yuqueja quiyatiajeyaquetu cayuamati baecua. Mujuratu araya ama. Jitsu baecua tuque. Chiritanaya ama tuque; ni tu yuamaturaya rapara. ");
INSERT INTO cavNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tupujacaya ama tuque ecuana inime ecuanaja iyuhueda cuanaque quiyatihuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Yatuca tsehue ademe ecuana capetatiya. Capetatitsu ecuana canarutiya ai muda cuanaju. Yatuca ecatse jidaju ecuana jidadya anitaqui. ");
INSERT INTO cavNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yatuca ecatse jidamaju, ecuana ecanarutiu amadya muda cuanaju. Era micuana cuejayaque tu hueca buchique. Ecue yana equedya ama ni micuana aniya, tume micuana apudaju juneniyaque cuji juhuaque bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ni ejera buchiquetu emereu ama beta patrón ecatse. Jadya jucara juyaque juatsu, tuque micuana, peya ujeu, peya bacue iyuhueda jadya jutidya ebau. Peyatu nijuta ducuta jadya tsehue emereu, peya bacue merecarama tsehue. Eje bucha anie ni micuana juma Yusuja biji eque, micuanaja ishu cuita camadya chipiru radanitya jadya juatsu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesúsra tuna bahuityanucacuare: —Cuejaya micuana era. Netsapeume inime: “¿Ai dyadi rique araya, ijiya? ¿Ai dyadi rique jutuya?” jadya. Yusura micuana iyahua tibu, yuneri cuitadya micuana tura tyadadiya micuanaja aijamaque ara ishuque, jutu ishuque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Neadebacue upati huiri cuana. Tunaratu inime tsapeya ama tunara sareya tsehue. Tuna tuna cuhuatiya ama ni cahuesatiya ama ara ishuque. Aijama tunajatu ni eju tunaja earaqui iya ishuque. Jadya ama bucha tuna micuanaja Tata barepajura tyaya ara ishuque. Tujaque micuana. Micuana tura micuana dyaque iyuhueda baya, upati huiri cuana bucha ama. Yuneri cuitadya tura micuana tyaya micuanara ara ishuque sareyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ni ejeradya jutidyatu tuja maju ishuque ura juetihuaju tuja ani erirunucau ama. ");
INSERT INTO cavNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Micuanajatu tsapetaqui ama inime jutu ishu cuana tsehue. Nebacuedya yachiju shasha cuana eje bucha danee juyaque. Tunaratu jidama ama inime baya jutu ishu cuana tsehue. Mere ecana juya ama chipiru jiteque, ni ecana taritariya. Jadya ama bucha tuna Yusura jida piji amereya. ");
INSERT INTO cavNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomón tu jucuare ecuari dyaque jida tsehue cajututitsu jida piji. Jadya ama bucha shasha cuana yachi juquetu dyaque jida piji, Salomónra ejutuqui dyaque jidaque jutucuare bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Shasha yachi juquetu tsunuda ama juya. Tumeque huecaca camadya tu jida piji; peya huecaca bacue eijehue ejuu etiquiju. Yusura yachi juque shasha cuana dyaque jida piji amereya tibu, yuneridya tura micuana tyayadya micuanara jutu ishu sareyaque. Micuanaratu tura naruyaque ejeneya ama, arepa tuque micuana upati jeta aqui cuanaque, shasha cuana jadya naruyaju baya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Yusura tura iyahuaque naruya tibu, inime netsapeume: ‘¿Ai dyadi tuque ecuana araya? ¿Ai tuque ecuana ijiya?’ jadya ama juatsu ‘¿Ai dyadi tuque ecuana jutuya?’ ");
INSERT INTO cavNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yusu adeba baecua cuanaque tuna tumeque inime tupu tsehue jutidya juneniya. Micuana jadya inime tupu tsehue nejuneniume. Micuanaja taa tu aniya Etata Yusu barepa juque, micuanara ai ara ishuque, jutu ishuque jadya sareyaque tyaquique. ");
INSERT INTO cavNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pana catyati nejucue Yusu queja, tuja micuana naru ishu. Eje buchadya tuque pureamaturacara ayaque anicara nejucue. Jadya anie ni micuana juya, tume tura micuana tyaya dutya micuanara sareya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Netsapeume inime huecacape eje bucha juya tsehue. Dutya huecacatu aniya eje buchique inime, masada, inime tupu jadya. Inime tsapequi neaume eje buchique inime cuetimaque jari. Baecua micuana eje bucha judadiyaque. Tume cuanaque inime tupuqui aatsu, eje bucha inime tsapema anie ni micuana juma, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesúsra tuna bahuityanucacuare: —Peya jidama juyaque cueja nejuume, Yusura micuana dyadi jidama juyaju ebau tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Micuanara peya cuana baya bucha baedya micuana Yusura eau. Micuana ni peya cuana ai tyaishu inijeda juya, tumetu Yusu dyadi inijedadya juya micuana jidaque tyaishu. Micuanara ni tyacara tsehue tupuya ai tyayaque, tume micuana Yusura dyaque jidaque tyaajeyadya jutidya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jesusratu cuatsabiji cuejacuare tuna bahuityayaque: —Micuanaja cuitadya yatucaju acui tibu ebari aniyaque juatsu, ¿eje bucha juatsu jatsu tuque micuana peyaja yatuca juque aijara piji quemicara aya? ");
INSERT INTO cavNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Micuanaja cuitadya yatucaju acui tibu aniyaque caadebatiyaque ama, ¿tume tuque micuana peya eje bucha juatsu jadya eau: “Aijara tuque micue yatucaju aniya. Paquemi micue era”, jadya eau? ");
INSERT INTO cavNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Ebaupa, ai jadique micuana shuhui buchique! Icuene micuana cuitadya yatuca juque acui tibu necaquemiticue. Caquemititsu tuque micuana ebau jida peyaja aijara yatuca juque quemi ishu, —jadya tuna Jesúsra acuare. (Riya tsehue tujatu ecana bahuityacuare: Neadebacue micuanaja jucha. Adebatsu neajacacue, peyaja ishu jidama quisaratimaque.) ");
INSERT INTO cavNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jesúsra tuna bahuityanucacuare: —Aniyatu Yusuja quisarati tsehue tsaya cuanaque. Chapa mureda buchique tuna jipeyaju cacaruticaraque. Cuchi cuana buchique jutidya tuna. Tapapasha, asicatura jadya jutidya tunajatu aya peya cuanara tyayaque. Casada tsehue ecana quisarati bacamerecara neaume tunara bacacarama ayaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesúsra tuna bahuityanucacuare: —Nebacabacajacaume Yusu queja. Tyayadya tura micuana. Nebacajacaume ai sareyaque. Yusura micuana dadimereya. Canimehuallatima neihuacue, micuanara ai Yusu bacahuaque tura tyaya tupu. Tyayadya tura micuana. Etareju nubicara juatsu etare metsera pacashaya tupu eihuau bucha ihuae neacue. ");
INSERT INTO cavNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ejera bacajacayaque ama tujatu tyayadya. Ejera sareyaratu dadiyadya. Ejera canimehuallatima ihuayaratu bayadya tura bacahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","10","¿Micue bacuara pan bacayaju ni taa mi tumu jutidya etyau ara ishu? ¿Micue bacuara jae bacayaju ni taa mi bacua jutidya etyau ara ishu? ¡Ni ejeque etataqueratu tura bayaque jadya eau ama! ");
INSERT INTO cavNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Butsee micuana jidamaradya tuque micuana micuanara baya cuana jidaque tyaya. Yutsumadya Yusu barepa juque micuana dutya tyaquique, dyaque jidaque micuanara bacayaju tura micuana tyayadya. ");
INSERT INTO cavNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Peya cuana queja necabamereticue tunara eje bucha bacara aya eque. Jadya tibudya tuna dyadi jida tsehuedya nebacue. Riyaquedyatu Moisésra, Yusu equeque quisarati cuejaqui cuanara jadya bahuityacuare, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesúsra tuna bahuityanucacuare: —Eaqueja necatyaticue Yusu queja judiru ishu. Eje uma tuna jadya jucarama juya. Tunaja biji eque ecana anijacacarama juya. Tunadya tuna etsecue quinida eque nubiya buchique; ediji quinida eque ajeyaque buchique tuna. Ijahuaja etiquiju tuna judirubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Masabaya micuana Yusu pureamatura ishu, micuana cuita camadya capureamaturatijacacarama juya tibu. Eje uma ama tuna Yusu camadya pureamatura juya cuanaque. Tunadya tuna etsecue quinidama eque nubiya buchique; ediji ibeda eque ajeya buchique tuna. Tunadya tuna Yusu queja judirubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Necanaruticue pusha pusha arida cuana tsehue, Yusuja quisaratipa ecuejau jadya juya cuana tsehue. Quisaratiyaju bacatsu tuque micuana ecana micuana tsahuara jehuaque buchadya ebau. Pana yuamatura cuitadya tunara micuana eau, micuanara bacayaque juatsu. Uhuisha bucha cuita jida datse tuna jucara juya, iba bucha jidamaque jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Micuanaratu eadebaudya ejeque pusha pusha arida cuanaque tuna eje bucha juyaju baatsu. Ecacaju petatsudyatu adebataqui acui. Abarijutu uva caca ecuinanau ama. Higotu acuija ducu edaneu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jadidyatu dutya acui jidaque jida cacacatiya. Acui amena rarayaquetu jida amadya cacacatiya. ");
INSERT INTO cavNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Acui jidajatu juya amadya ecaca jidama arataquimaque. Acui arataquimajatu juya amadya ecaca arataquique. ");
INSERT INTO cavNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","20","Tumebae adebaedya tuque micuana eau ejeque jidama bahuitya bahuitya pujique tuna eje bucha juya baatsu. Tuna tuna judiruya ama eju Yusu adebaqui cuanaque judiruyaju. Ijahuaja etiquiju tuna ishatanabuque, acui ecaca arataquimaque eata bucha cuere, pahua jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Aniyatu umae ecuiquepa jadya juya cuanaque. ‘Miquemi Ecuana Cuatsashaquique’, jadya datse tunara aya. Jadya ama bucha tuna Yusu queja judirubuque ama, ecue Etata barepaju aniyaja biji eque ama anihua tibu. Tuja biji eque aniyaque cuita camadyatu tuaqueja judirubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tere ishuque huecaca juetihuaju camadyatu Yusu adebaquipa ejuu jadya juya cuanara abuque: ‘Ecuana Cuatsashaquique, ecuanaratu Yusuja quisarati cuejahua micue ebacaniju. Micue ebacaniju tuque ecuana ijahua cuanara quijahuatishaya cuanaque ijahua cuana ijehuecuinahua. Micue ebacaniju tuque ecuana ahua ni ejeque ecuitaja ataquique ama’, jadya tunara abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Era tuna quemitsabuque: ‘A, aijama. Ecuique ama micuana. Adebaya ama micuana era. Nenetisicuacue ique pequeque, micuana micuana jidama juhua cuanaque’, jadya tuna abuque, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","27","Jesúsra tuna cuejanucacuare: —Anicuaretu beta ecuita etare caticuareque ecatse. Icuenequetu inime adebabada, bahue jadya jucuare. Purucuaretu deda. Tumu ebari dyaque yahua pajidaju tujatu dudu cuana puchacuare ni eje tupu bucucunuca ishu ama. Peya bacue inimema jucuare. Mejijiju jutidya etare caticuare. Nei ebari juatsu cueri cuana pesitanaterecuare. Cuejipa casadara etare ecatse aeticuare. Icueneque etare pujija eaque casada neticuare. Rihuicuare ama, dudu cuana yahua pajidaju casada epucha tibu. Peyara etare acuareque bacue rihuicuare. Pana aputatere jucuare. “Era bahuityayaque bacatsu era amereya eque juya cuanaque tuna yahua pajidaju etare caticuare buchique. Tuna tuna ni eje tupu yuamaturatana ishuque ama. Era amereya eque ama juya cuanaque bacue mejijiju etare caticuare buchique. Tuna tuna pana aputatere jubuque, —jadyatu Jesúsra ecuita cuana cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesús quisaratiyaque abacatanahuajutu ecuita jetieque ama anajacatacuare tura bahuityayaque bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jadya tuna jucuare: —Pana adeba taa tu aya eje buchique quisarati ayaque. Cacuatsashati cuejanuca cuejanuca jadya amatu juya, ecuana bahuityaqui cuanaque bucha ama taa, —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús bahuitya bahuityayaque emata juque butehuajutu ecuita jetiera ama tupujudya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tumetu ecuita pusese sehuera rami ririshayara jipeticuare. Jipetitsu tujatu Jesús tuja yacuaju chichucata juatsu isaratsacuare: —Ique Cuatsashaquique, chachanecara aatsu taa mira ecue ujeje aniyaque echachaneu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tura jadya ayajutu Jesúsra jabacuare. —Chachaneyadya mique era, —jadyatu Jesúsra acuare. Jadya aya tsunumeetu pusese aputacuare tuja ecuita juque. Chachadya tu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—Cuejacueja camadya aume ni ejequedya jutidya mique eje bucha chachae juhuaque. Aticue Moisésra amerehua equedya. Riyata cuau cuitadya jucue pae queja, tuja mique pana adeba atsa ishu, “Chachadya rique,” jadya tuja aishu. Cadujuticue Moisésra amerehua equedya riyaque ujeje chacha eju cuanaja Yusu tyabahueque. Jadya juatsutu ecuita cuana bahue juya mique amena chachaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesústu Capernaumju junaticuare. Junatihuajutu huaraji cien sudaru cuana cuatsashaquique Roma juque ecuadishara jipeticuare Jesús. Tume tujatu Jesús jipeticuare tuaqueja canerecati ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Ique Cuatsashaquique, ique merequique tuque ecue ujejeda ecue etareju. Jarayadya tuque. Bucucutaqui amatu juya. Dyaque nerecadatu juya, —jadyatu sudaru cuana cuatsashaquira acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesusratu quemitsacuare: —Cuayadya ique. Chachanetiyadya tuque era, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Eratu adebayadya mira ecue etareju cuamara echachaneuque, Ique Cuatsashaquique. Cuatsashacue. Tuquetu chachadya juya. Ique israelita ama. Bahuedya ique micue cacuatsashati eque mique ecue etareju nubitaquique ama. ");
INSERT INTO cavNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ique ecue huaraji cuanara cuatsashayaju yana equedya jubahue. Era dyaditu sudaru cuana cuatsashayadya. Era ecue sudaru cuadishayaju, masadamadyatu cuaya. Peya ni era ihuaraya, masadamadyatu jeya. Era ni ecue mere puji, “Acue jeeque” jadya aya, masadamadya tujatu aya. Ique bahuedya micue casa aniyaque ique merequique chachane ishu, —jadyatu huarajira acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jadya bacatsutu Jesúsra ecuita bape bacuare tuja quejeneti baatsu. Jadya baatsu tujatu tuque tupuju cuaya cuanaque cuejacuare: —Riyaque Romajura taa dyaque ejene neri aya era tuja tuque merequique echachaneuque. Pusha amadya aijamatu ni ejeque ecue ata israelita ique dyaque ejenequique. ");
INSERT INTO cavNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nebacacue taa era cuejayaque. Eje uma israelita ama cuanaque tuna Yusu huaraji dyaque aridaque aniyaju judirubuque. Dutya quejaque tuna tuhua jubuque. Ijeti cuinanaya queja amacaque, ijeti nubiya queja amacaque jadya tuna caradatibuque. Caradatitsu tuna Abraham, Isaac, Jacob jadya tsehue araarapeedya jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ecue ata israelita cuanajatu anihua emajaca Yusuja quisarati baca ishu. Jadya ama bucha tuna dutya jujeri Yusu queja judirubuque ama, eaqueja catyatiya ama tibu. Apudaju tuna ijehuetanabuque. Ijahuaja etiquiju tuna judirubuque. Tuhua tuna dyaque payaque, etse tari jubuque, dyaque canerecatiya cabatitsu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tuequedyatu Jesúsra isaranucacuare sudaru cuanaja huaraji: —Dirucue micue etareju. Miratu ejenehua era ujejedaque japada equera chachaneyaque. Mique merequiquetu amena chacha, —jadyatu Jesúsra acuare sudaru cuanaja huaraji. Tumetu mere puji tumeque ura cuitadya yuqueja chacha jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesústu Pedroja etareju cuacuare. Tuhua junatitsu tujatu banaticuare Pedroja ehuanequeja ecuaque dyaquene cuita baara juyaque jarayaju. ");
INSERT INTO cavNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Junatitsutu Jesúsra emetucuju jabanaticuare. Jabanatihuajutu baarara ajacacuare. Tumetu netitsuratsu earaqui jucuare Jesús, tura mepehua cuanaque jadya mihua ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Amena ijeti nubihuaju tunajatu becuare Jesús queja ijahua cuanara quijahuatishaya cuanaque, peya ujeje tsehue cuanaque jadya. Tura tuna quisarati tsehuedya jutidya ijahua cuanara quijahuatishaya cuanaque quijahuatishajacacuare, tumebaedya peya ujejequi cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tura jadya ahuajutu jucuare. Isaías Yusu equeque quisarati cuejaquira beru cuejacuare bae cuitadyatu judadicuare: “Tura cuitadya ecuana chachanecuare ujejedaque. Secacuare tura ecuanaja uje cuana”. ");
INSERT INTO cavNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ecuita cuana jetiama caradatiya baatsutu Jesúsra tura mepehua cuanaque jadya acuare: —Necarequetira bei yueque macare, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Cacuatsashati bahuityaquiratu Jesús jipeticuare. —Ebahuityaquique, ique junenicara juya miatsehue eju mique cuayaju, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—Dyaque masada tuque. Equique chapa cuanajatu aniya cani; upati cuanaja bacue eja. IQUE ECUITAja bacue aijama etare tahui ishuque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Peya tuque ijacabacaquiratu acuare: —Ecuatsashaquique, icuene tuque ecue etata narutaqui tuque majuya tupu. Tuque majuhuaju, papatsu piisi miatsehue juneniya. Ihuacue jari ique, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—A, aijama. Iyacuadya eatsehue junenicue. Ique adebaya ama cuanaque tuna emaju cuanaque bucha. Tunara inime tsapequi paa ai riyaque yahuaju cuanaque, emaju cuanaque papaya tupu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jadya juatsutu Jesús cuaba ebariju anibutecuare tura mepehua cuana tsehue. Anibutetsu tuna carequeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bei riqueyaquetu Jesús tahuicuare. Tuna eje tupu ajehuaju amatu muya jutidya cuejipa casadaque jueticuare. Cuejipa juetitsutu ena pacura cuaba ebari nudyajeri nudyajeri acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jadya baatsutu tura mepehua cuanara Jesús bushishaticuare. —¡Ecuana Cuatsashaquique, chachanecue ecuana! ¡Rumutanaya ecuana! ¡Ena pacura ecuana nudyaya! —jadya tunajatu acuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—¿Eje bucha juatsu jatsu micuana bajida juya? Ejeneya ama jaridya tuque micuana ecue micuana naru ishu casa aniyaque. Jadya juatsutu Jesús netitsuracuare. Netitsuratsu tujatu acuare cuejipa enapacu jadya: —¡Tume tupu camadya! ¡Neticue! —jadya tujatu acuare. Tura jadya aya tsehuedyatu cuejipa neticuare. Dutyatu pana abacatana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jadya baatsu tuna eanajacata jucuare. Cabacaduratibarecuare ecana: —¡Ai ecuita dyadi ri riyaque! Cuejipa, enapacu jadya taa tuja yana equedya juya, —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Chamacama tuna jaratsuradirucuare Gadaraju aniya cuana queja bei yueque macare. Jaratsuradiruhuajutu beta ecuita ecatsera Jesús jipeticuare. Ijahua cuanara quijahuatishayaque tatse jucuare. Emaju cuanaque eisha cani cuana juque tatse jecuare. Dyaque emuba tatse jucuare. Ni ejequedya jutidyatu tumeque ediji eque juneni bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesús baatsu tatsejatu quiquetsacuare: —¿Ai jitequemi jeya yatse queja, Jesús Yusuja Ebacuaque? Bacuedya jutidya yatse. Huecaca juetima jariju cuitami jeya yatse nerecaturara, —jadya tatsejatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tueque eje japa amatu cuchi cuana jetiama araaranibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","—Riyaque ecuita ecatse quijahuatishajaca ishu, mira ecuana cuinanashayaque juatsu, ecuana panubi cuchi cuanaju, —jadyatu ijahua cuanara acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—Nenubicue taa, —jadya tuna Jesúsra acuare. Tumetu ijahua cuanara quijahuatishajacacuare tumeque ecuita ecatse. Tatse quejaque cuinanatsu tuna cuchi cuanaju nubibarecuare. Dutya cuchi cuana ijahuaqui cuanaque tuna tsajajayaque pacacadirucuare bei tihuesu baruda eque. Beiju pacacatsu tuna huiditerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Cuchi cuana naru juya cuanaratu bacuare jadya juyaju. Ejecutana tuna tsajajaterecuare epu ebariju. Tuhua judirutsu tuna cuatsabiji adirucuare dutya eje bucha juhuaque, ijahua cuanara quijahuatishayaque ecatse eje bucha quijahuatijacae juhuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jadya bahue juatsutu dutya jujeri ecuita cuana tumeque epu juque cuacuare Jesús queja. Batitsu tunajatu aticuare: —Dirucue rehuaque, —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jadya juatsutu Jesús nubicuare cuaba ebariju, bei yueque macare carequeti ishu, tuja epuju judiru ishu. Judirucuaretu Capernaumju, tuque aniqui epuju. ");
INSERT INTO cavNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tsunuda juatsu ama cuitadyatu ecuita cuanara dujucuare ecuita ajebaecuaque tuaqueja. Tumeque ecuitatu jaracuare ujejeda cuanaque huesa ishuju. Ujejedaque dujuqui cuanara Jesúsra ajebaecuaque eajeshauque ejeneyaque adebatsu tujatu jadya ajebaecuaque acuare: —Cacasaticue, tata. Micue jucha cuana tu amena eapupasha, —jadyatu Jesúsra acuare ajebaecuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jadya juyajutu cacuatsashati bahuityaqui tuhua jucuare cuanara jadya inime tupucuare: —Riyaqueri Yusu tsehue beta tupu cabatiya. Yusu tujatu ijillahuanaya. Ni ejeradya jutidyatu jucha cuana eapupashau, Yusura peadya camadya, —jadya tunajatu inime tupubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesústu bahuedya jucuare tunara eje bucha inime tupuyaque. —¿Eje bucha juatsu tuque micuana jadya inime tupuya: “Yusu tujatu ijillahuanaya” jadya? Jida ama tuque micuana inime tupuya. ");
INSERT INTO cavNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Era ni aje baecuaque eau: “Micue jucha cuana tu eapupasha” jadya, eadebau ama tuque micuana ecue casa aniyaque, eapupasha, apupashama jadique ejitaju ama tibu. Era ni eau: “Netitsuracue. Ajecue”, tumeque ura cuitadya tuque micuana eadebau ecue casa aniyaque, ajebaecuaque juneniyaju baya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tuque juneniya baatsu micuana bahue juya ecue tumebaedya riyaque yahuaju jucha cuana apupasha ishu casa aniyaque, —jadya tujatu ecana acuare. Tumetu Jesúsra acuare ajebaecuaque: —Netitsuracue. Piruricue micue jara ishuque. Dirucue micue etareju, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jadya ahuaju cuitatu ecuita netitsuratsu tuja etareju dirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ecuita jetiama capetatiya cuanaquetu jadya baatsu anajacatacuare. Pureama tuna Yusu acuare. —¡Dyaque jida, casada taa Yusu! Riyaque ecuita Jesús tujatu tyahua casa ujejeda cuanaque chachane ishu, tumebaedya jucha cuana apupasha ishu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ecuita ajebaecuaque ajeshatsutu Jesús dirucuare tuhuaque. Diruyara tura ique badirucuare Roma juque enaruquija ishu chipiru tsuje bacayaque juaniyaju. Ique Mateo bacani. Ique enaruquija ishu chipiru tsuje baca puji jucuare. Tuhuadya tura isaracuare: —Eatsehue junenicue, —jadya Jesúsra acuare. Jadya ahuaju netitsuratsu Jesús tsehue junenitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ejetsunue juatsu amatu Jesús ecue etareju araaraapunacuare tura mepehua cuana tsehue. Tuhuatu jucuaredya enaruquija ishu chipiru tsuje bacaqui cuanaque, umae bijidamadurataya cuanaque jadya. Dutya ecuana mesaju Jesús tsehue araaracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tume ecuana fariseo cuanara bacuare. Baatsu tunajatu acuare tura icuene mepehua cuanaque: —Riyaque ecuita cuana ri bijidamadurataya cuanaque. Micuana Bahuityaquiquetu araarataqui ama enaruquija ishu chipiru tsuje sitaqui cuana tsehue, tumebaedya peya jucha arida cuana tsehue, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesúsra tuna quisaratiyaju bacacuare. —Chacha cuanaratu sareya ama casamati puji. Ujejeda cuanara camadyatu sareya. ");
INSERT INTO cavNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Jadya tu ehuene Yusuja quisarati: “Dyaque jida micuana quiyuhue batsati aqui amerecara aya, ique uu cuana iyetsu tyaishuque bucha ama”. Jida inime netupudirucue tume ehueneju, pana adeba aishu. Juchama bucha cabatiya cuanaque sarera ama jehua. Ique jehua jucha arida cabatiya cuanaque jiteque, tuna inime cacuaretisha ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jadya juatsutu Juan Ecuita Cuana Utsaqui tsehue junenicuare cuanara Jesús jipeticuare. Jipetsu tunajatu bacaduracuare: —Ecuana ecuana arama quibeti bahue, Yusu muiyaque cabamereti ishu. Tumebaedyatu fariseo cuana jadidya juya. Mira mepehua cuanaque bacue arama quibeti baecua. ¿Eje bucha juatsu? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesúsra tuna quemitsacuare: —Caquemitiyaju cuaishu ecueja cuanaque tuna peya inime juya ama caquemitihuaque tuna tsehueju. Tuna quejaque dujutanahuaju piisi tuna arama quibetiya. Tumebaedyatu ecue cuanaque; ique cuanucahuaju piisidya tuna arama quibetiya. ");
INSERT INTO cavNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Ni ejeratu camisa siri sipiya eraca iyacua tsehue. Jadya ayaque juatsutu nacatatsu eraca iyacuaque dyurutanatsu camisa siri echajatanau. Chajatanayaque juatsutu camisa beru juhua bucha dyaque jidama ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tumebaedyatu ishataqui ama tupari sasana ishuque sura siri cuitaju. Tupari sasanayaratu epututashau sura siri. Tumetu eaputau sura, tupari jadya. Jadya tibudyatu tupari sasana ishuque sura jida iyacuaju ishataqui. Tumetu jidadya juya. Aputaya ama tupari ni sura, —jadya tujatu ecana acuare. (Riyaque cuatsabiji tsehue tuna Jesúsra bahuityacuare. Eje bucha anitaqui amatu beru inime israelita cuanara bahuityacuare eque, iyacuaque tura cuitadya bahuityaya eque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús jadya quisaratiyajutu peadya ecuanaja huarajira jipeticuare. Jipetitsutu Jesúsja yacuaju nuyucuare. Isaracuare tuja tuque: —Nerecabacue ique. Ecue ebacujunatu iyacua cuitadya majuhua. Mira camadyatu enityatsuranucau. Mique ecue etareju cuaatsu mira jabatsu camadyatu chacha enetitsuranucau, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jadya ahuajutu Jesús cuacuare tuatsehue. Ecuana dyadi Jesúsra mepehua cuanaque ecuana cuacuaredya tatse tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ecuana huarajija etareju cuaya tsunumeetu epunara Jesús etibene eque jipeticuare. Ujejedaquetu epuna jucuare. Peadya tunca beta earacana maratu amena nerecada, ujejeda jucuare. Ebacuatare tujatu jidama jucuare; ami tujatu jucuaredya jutidya. Jipetitsu tujatu jabacuare Jesúsja unaju ebebacuaju ehuejitaque. ");
INSERT INTO cavNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tujatu inime jucuare: “Tura jutuyaque jabatsu chacha juya” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tibene bajiyu aatsutu Jesúsra bacuare epuna. Isaracuare tuja tuque: —Cacasaticue, mama. Chachami juhua, mira era chachaneyaque pana ejene ahua tibu, —jadya tujatu acuare. Tura jadya aya tsehuedyatu chacha jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Junaticuare ecuana huarajija etareju. Junatitsu tuque ecuana tuhua cuanaque sicacada juyaju bacanaticuare. Dudududu puji cuanara emajuque papati ishuque duduyaju ecuana bacanaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesusratu tuhua cuanaque acuare: —Necuinanacue rehuaque. Dyaque peya inimetu jutaqui ama. Tumeque ebacujuna piji tu majuma. Tahuiya jutidya tuque, —jadya tuna Jesúsra acuare. Jadya bacatsutu ecuita cuanara ijaribacuare, tunara yuneri cuitadya emaju bahua tibu. Ecanajetijacatu ebacujuna piji jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesúsra tuna cuinanashacuare. Tuna cuinanashatsutu nubiticuare ebacujuna piji emajuque jarayaju. Emetucuju tujatu ebacujuna piji emajuque inanaticuare. Inayajutu ebacujuna piji chacha netitsuracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Dutya tuque amaca aniya cuanaque tuna bahue jubarecuare Jesúsra emajuque chacha nityatsuranucahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús tuhuaque cuinanayajutu beta shuhuique ecatse tupujudya quiqueajecuare. —¡Jesús, miquemi Yusuja Emepeque, David eque ejuracanaque! ¡Nerecabacue taa yatse! —jadya tatsejatu quique eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Etareju nubinatihuajutu shuhui ecatsera jipeticuare. Tatsera jipetihuaju tujatu ecatse bacaduracuare: —¿Ejeneyadya metse era ecapetishauque? —Jejee, Yatse Cuatsashaquique. Ejeneyadya tuque yatse mira jadya eauque, —jadya tatsejatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jadya aatsu tatse Jesúsra yatucaju jabacuare. —Metsera era capetatishayaque ejeneya tibu, capetatiyadya metse, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tura jadya aya tsehue cuitadya tatse jida capetaticuare. Jadya aatsu tatse Jesúsra cuatsashacuare tatse cacuejati ishu ama: —Necuejaume ni ejequedya jutidya metse eje bucha capetatie juhuaque, —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tuhuaque cuinanatsu piji cuitadya tatsejatu cuatsabiji acuare dutya tumeque emajacaju Jesúsra tatse eje bucha ahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Tatse cuinanaquenayajutu ecuita cuanara becuare ujejedaque. Tumeque ecuitatu quisarati baecuaque jucuare; ijahuara jadya amereyaquetu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tumetu Jesusra quisarati baecuaque ijahua queja jacamerecuare. Jacamerehuajutu ecuita quisaratitibunecuare. Quisaratiya bacatsutu tuhua jucuare cuanaque anajacatacuare. —¡Bama rique ecuanaja riyaque yahua Israelju riyaque ecuita buchique! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jadya baatsutu fariseo cuanaja juticuare ama inimeju Jesúsra Yusuja casa tsehue jadya ayaque. —Satanás ijahua cuana cuatsashaquique tu tuatsehue. Jadya tibudya tujatu casa aniya ijahua cuana ijehuecuina ishu, —jadya tuna jucuare tuna camadya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesústu junenicuare dutya epu cuanaju, tumebaedya japada epu achaacha cuanaju. Bahuityajacacuare ama tujatu ecana caradati ishuque etare cuanaju, epu tura cuajiya cuanaju jadya. Jidaque quisarati tujatu cuejacuare, Yusura eje bucha narue adadiyaque. Dutya ujeje tsehue ujejeda juya cuanaque tujatu chachane bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Bacuaretu ecuita jetiamaque. Nerecada, ecapeya inimeti jadya tujatu ecana bacuare. Uhuisha cuana aija naruquima juneniyaque bucha tujatu ecana bacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","38","Jesúsra ecuana acuare: —Riyaque ecuita cuana ri trigo amena ejahuane buchique. Aniya jari tuna jetiama Yusuja quisarati bacama cuanaque. Eje uma ama tu quisarati tsapequi cuanaque. Nebacacue Yusu. Pacuadishatu jetiama ecue quisarati cueja ishu cuanaque. Tee metsera mere puji cuana trigo racara ecuadishau bucha, jadidyatu Yusura tuja cuanaque cuadishaya tuna tuaqueja catyatishamere ishu, —jadya ecuana Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesúsra ecuana sitacuare ecuana peadya tunca beta earacana tura mepehua cuanaque. —Ijahua cuana ijehuecuina ishu micuana tyaya casa. Tumebaedya micuana cuatsashaya ejeque ujeje, eje bucha ujeje tsehue cuanaque chachane ishu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ecuana ecuadisha cuanaque ecuana peadya tunca beta earacana jucuare. Simón (Icuene ebacaniju atanahuaque; peya ebacani tujatu “Pedro” jucuare.) Andrés (Simón tsehuequique) Santiago Juan (Santiago tsehuequique; tatse tatse jucuare Zebedeoja ebacuaque ecatse.) ");
INSERT INTO cavNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe Bartolomé Tomás Mateo (Ique icuene jucuare enaruquija chipiru sitaquique.) Santiago (Alfeoja ebacuaque) Tadeo ");
INSERT INTO cavNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón (Tuquetu Roma juque enaruquique bijidamaduraqui juyaque jucuare.) Judas Iscariote (Jesús inamerequi judadicuareque) ");
INSERT INTO cavNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ecuana tura mere amerehuaju cuama jariju ecuana Jesúsra cuejacuare: —Necuaume israelita ama cuana aniya queja amaca ni samaritano cuana aniya epu cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Necuejaticue Yusuja quisarati ecuanaja ata israelita cuana camadya. Tuna tuna uhuisha cuana eaputa buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Necuejacue ecana, amena tu japadama huecaca Yusura dutya narudadiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nechachaneticue ujejeda cuanaque. Nenityatsuraticue emaju cuanaque. Nechachaneticue ujeje dyaque jidamara biti ririshaya cuanaque. Ijahua cuanara quijahuatishaya cuanaja ijahua cuana necuinanashaticue. Era micuana tsujema tyaya riyaque casa cachachaneti ishuque. Jadya tibudya micuanara netsujebacaume ujejeda cuanaque chachanetsu. ");
INSERT INTO cavNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","“Micuanara tsahuatiya cuanaradya micuana tsujema tyatsaya micuanara ai sareya cuanaque, micuana Yusuja mere juyaque baatsu. Jadya tibudya necadujutiume chipiru ni peya ai etsujequi tsehue cacuaretiquere ishuque. Asicada juatsu catacati ishu jutu ishuque necadujutiume. Zapato jutuyaque cuita camadya necadujuticue. Necadujutiume shitara ni sari. Dutya micuanara sareyaquedya micuana tyataya. ");
INSERT INTO cavNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ejeque epuju junatitsu banatimetseque etareju nenubinaticue etare metsera jida batsayaju camadya. Tuhuadya neanicue tuja etareju peya epuju dirunucaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nubinatitsu tumeque etareju aniya cuanaque neisaranaticue. ‘Yusura inime tsapema neamerecue’, jadya ecana neanaticue. ");
INSERT INTO cavNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tumeque etareju cuanara ni micuana jida batsaya, micuanara cuejayaque ni tuna jida tsehue bacaya, tume tuna jida inime tsapema juya micuanara isaranatihua baedya. Jidama ni tunara micuana batsaya, micuanara cuejayaque ni tuna bacacarama aya, tume ecana pureama ni inime tsapema jadya paju ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tunara micuana batsacarama ayaju, micuanara cuejayaque bacacarama ayaju, masadama necuinanacue tuhuaque. Cuinanayaque neitataquenacue muru micuanaja ehuachi juque, ‘Aine yatse micuana tsehue juma’, jadya tuna ayaque. Tunadya tuna inime metse, Yusuja quisarati bacacarama ahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tere huecaca juetihuaju tuna Yusura dyaque nerecaturabuque tuja quisarati bacacarama juya cuanaque. Sodomaju, Gomorraju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha tuna tumeque huecaca juetihuaju dyaque ama canerecatibuque, micuanara quisarati cuejayaque bacacarama ahua cuanaque bucha ama, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesúsra ecuana bahuityanucacuare: —Pana ijacabaca neacue. Cuadishaya micuana ecue quisarati cuejara. Cacuarehuanaticara nejuume, arepa tunara micuana jidama aya ama bucha. Micuana micuana uhuisha iba cuana ducu buchique. Jida inime netupucue micuana ai jutiyaju. Cuejayaque ecana necuejacue jida inime tsehue, yana ujeda ujeda tsehue ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Necanaruticue. Ecuita jidama cuanara micuana huaraji cuana queja inamerebuque. Catsacatsa tunara micuana amerebuque caradati ishuque etare cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Dujubuque tunara micuana enaruqui cuanaja yacuaju, ecuari cuanaja yacuaju eaqueja ecatyati baatsu. Tume tuque micuanaja emajaca anibuque ique eje buchique tuna cueja ishu, israelita cuana tumebaedya israelita ama cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huaraji cuanaja yacuaju dujutayaju jidama inime nebaume quicueneti ishu quisarati aishu, ni eje bucha cuejae aishu. Quisarati ishuque ura juetihuaju, Yusura micuana huecashabuque micuana eje bucha quisaratie juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Micuanara inime tupuya eque ama micuana quisaratibuque; micuanaja Tataja Espiritura inime tupumereya eque micuana quisaratibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Ecue cuanaque tuna tunaja etareju cuanara cuitadya ijahue ijahue abuque. Iyemere ishu tunajatu huaraji cuana queja inamerebuque. Tuna tsehuequi cuanara cuitadya tuna huaraji cuana queja inamerebuque. Etata cuanaqueratu ebacua cuanaque cuitadya inamerebuque, ebacua cuanaquera bacue etata cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Dutya jujerira micuana ujeu babuque, eaqueja ecatyati baatsu. Tereya tupu ejeque eaqueja nimee jujacayaque ama camadyatu Yusu queja judirubuque ni eje tupu tuque jacanuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tunara ecue cuanaque baatsu nerecaturaya cabatitsu, nehuanacue peya epuju ecue quisarati cuejara. IQUE ECUITA junanucabuque, micuanara dutya ecuanaja ata israelita cuana ecue quisarati cuejatillama jarijudya. ");
INSERT INTO cavNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ique tunara baya bae, baedya tunara micuana abuque. Ejeque cabahuityatiyaquetu tuque bahuityaquique bucha emui ama jubuque. Mere puji bacue tuja patrón bucha mui bae ama atabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Cabahuityatiyaque tunajatu tuque bahuityaquique bucha baedya abuque. Mere puji tunajatu tuja patrón bucha baedya abuque. Iquepa Satanás, jadya tunara ijillahuanahua. Ecue inime tunara micuana micuana dyadi ijillahuanayadya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","27","Jesúsra ecuana bahuityanucacuare: —Bajida nejuume ecuita cuanara eje bucha eauju. Dutya era etehua cueja ahuaque micuanara dutyaja ijacaju necuejacue. Dutya era bahuityahuaque micuanara peya cuana pana adebamere neacue. Dutya etehuaquetu ejitaju judadiya. Dutya ibedaquetu adebataqui judadiya. ");
INSERT INTO cavNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nemubaume micuana iyecara juya cuanaque. Arepa tunara micuana eiyeu ama bucha, aijama tunajatu casa ni ejeque ijahuaja etiquiju nudya ishu. Nemubacue Yusu camadya. Tuja peadya camadyatu casa aniya quiyeti ishu, tumebaedya ijahuaja etiquiju ejeque nudya ishu. Tura cuatsashaya eque nejucue, arepa micuana ecuita cuanara jidama aya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Yusuratu naruya dutya ai aniyaque. Upati huiri cuanatu tsujequi cuitaque ama. Beta chaitu catyati atanaya ficha patya cuesi tsuje piji. Jadya ama bucha tuna ecuanaja Etatara naruya, tunaja maju ishuque huecaca iyahuaque juetiya tupu, tuna emaju yahuaju pacacaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yusuratu adebaya dutya eje bucha micuana judadiyaque. Turatu adebaya dutya, eje uma micuanaja iyucaju etsaru aniyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jutaquijudya bajida nejuume. Pusha ama cuitadya micuana Yusura naruya. Upati huiri cuana naruya bucha, dyaque jida tura micuana narujacaya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ejeque ni ecuita cuanaja yacuaju ‘Jesús jaque ique’ jadya cacuejatiya, eratu ecue Etata barepajuja yacuaju ‘Ecuique tume’ jadidya abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ejeque ni ecuita cuanaja yacuaju ‘Ique Jesús jaque ama’ jadya cacuejatiya, era dyaditu ecue Etata barepajuja yacuaju ‘Ecuique ama tume’ jadidya abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“¿Micuanaja ni tu inime juya, ique junahua baatsu dutya inime jidama cuanaque, cati jadya amena terehua bucha? Jadya ama tuque. Ique adeba baecua cuanaque tuna ecue cuana tsehue cahuaititsu catibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Micuana eaqueja catyatihua tibu, micuana micuanaja etareju cuanara cuitadya ujeu babuque. Ebacua cuanaqueratu etata cuanaque ujeu babuque. Ebacujuna cuanaqueratu ecua cuanaque ujeu babuque. Ebacuaque jahuane cuanaratu yahuiqueja ecua cuanaque ujeu babuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Arepa micuanaja etareju cuanaquedya iyuhueda ebau ama bucha, ique dyaque iyuhueda nebacue, tuna iyuhueda baya bucha iyuhuee ama; paanidya datse micuanaja tata, cuaa, bacua, bacujuna, ejeque micuanaja iyuhuedaque. Ejeque ecuita jutidya ni micuanaja dyaque iyuhueda, ique iyuhueda ebauque, tume micuana ecue jutaqui ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ecue yana equedya nejucue, arepa micuana canerecati, maju jadya jutaqui ama bucha, curusuju etata ejuu bucha. Ique jiteque iyetacara juyaju, iyetacarama juyaquetu ecue jutaqui ama. ");
INSERT INTO cavNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Micuana ni catehuatiya eaqueja ecatyatique eiyetauju, ejetsunue ama micuana anibuque. Tume micuana majutsu ni eje tupu Yusu queja judirubuque ama. Micuana ni ique jiteque ejenetsu jadya iyetaya, tume micuana Yusu quejadya anisiribuque, arepa micuanaja ecuita ririya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Ejera ni micuana jida batsaya, tumebaedya tunara ique jida batsaya. Ejera ni ique jida batsaya, tumebaedya tunajatu ecue Etata Ique Cuadishaquique jida batsaya. ");
INSERT INTO cavNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Yusuja quisarati cueja juya cuanaque tuna jidaque tyatanabuque. Yusuja quisarati cueja juya cuanaque jida batsaqui cuanaque tuna tyatanabuquedya jidaque, tuna tyatanabuqueque nucadya. Ecuita jida cuanaque tuna jidaque tyatanabuque. Tuna jida batsaqui cuanaque tuna tumeque jidaque nucadya tyatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Micuanara ni ecue cuanaque tsahuaya, babuquedya tuque micuana dyaque jidaque, arepa micuanara dyaque jetiedya cuanaque tsahuaya ama bucha. Arepa tuna ena cuana pijidya jutidya iji ishu tyaya ama bucha micuana Yusura tsujetyabuquedya, —jadya ecuana Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesúsra ecuana peadya tunca beta earacana tume cuanaque cueja ishuque bahuitya amena ahuaju ecuana dutyadya Jesús tsehue cuacuare tuhuaque, tuja quisarati cueja, bahuitya jadyara tumeque yahua epu cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Ecuita Cuana Utsaquiquetu amena etare apudaju erisi neticuare. Tuhuaquedyatu bahue jucuare Jesús ai juyaque. Jadya bacatsu tujatu tura mepehua cuanaque cuadishacuare Jesús queja. ");
INSERT INTO cavNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Tuhua junatitsu tunajatu bacaduracuare Jesús, Juanra bacaduramerehuaque: —¿Midyami Mesías, Yusuja Emepeque rehua junataquique? ¿Ihuaya jari ni taa ecuana peya? —jadyatu Juanra cuadishahua cuanara Jesús bacaduraticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesúsra tuna quemitsacuare: —Micuanaratu bacahuadya era ai cuejayaque. Bahuadya micuanara ique ujejeda cuanaque chachane juyaju. Dirunucatsu Juan necuejadirucue micuanara bahuaque, bacahuaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Necuejacue era shuhui cuanaque capetatishayaque; rudurudu cuanaque rena jida ajeshaya; pusesera ririshaya cuanaque rena chachaneya; isahue cuanaque rena quijacabacatishaya; emaju cuanaque rena nityatsuranucaya; nerecada cuanaque rena Yusu queja judiru ishuque quisarati cuejaya. ");
INSERT INTO cavNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dyaque jida paju ique dyaque adebaquique, eaqueja nimee jujacayaque ama jadya, —jadyatu Jesúsra Juan cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jadya cuejahuaju tuna dirunucacuare. Tuna diruhuajutu Jesúsra cuejatibunecuare Juan eje buchique: —Jetiama micuana cuachine yachiju Juanra cuejayaque ijacabacara. ¿Ai tuque micuana batichine tuhua? Micuanaratu adebahuadya Juanra ejenecara, ejenecarama jadya ama Yusuja quisarati ahuaque. Shita cuejijira peya queja huanati, peya queja huanati eau bucha ama tuque. ");
INSERT INTO cavNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Bacaduranucaya micuana era. ¿Eje buchique ecuita batiya bucha tuque micuanaja inime juchine? Bahuedya micuana, tuque ejutuqui jida piji tsehue ama ecajututique. Ejutuqui jida piji tsehue ecajututi cuanaque tuna chipiruda cuanaja, ecuari cuanaja etareju aniya. ");
INSERT INTO cavNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bacaduranucaya micuana era. ¿Ai bucha adebatsu tuque micuana batichine? ¿Yusu equeque cuitadya quisarati cuejaquique ni taa tuque micuana batichine? Pusha amadya Juan tu Yusu equeque cuitadya quisarati cuejaquique. Yusuratu tuque mepecuare israelita cuana quisarati cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jadya tu Yusuja quisarati ehuene: “Cuadishabuque tuque mique cuadishama jariju ique merequique. Turatu ecuita cuana bajejebuque, tunaja mira quisarati cuejadadibuqueque bacatibune ishu”. Juan tu Yusuja quisarati cuejaquique. ");
INSERT INTO cavNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Riyaque micuana cuejaya. Juan Ecuita Cuana Utsaquiratu quisarati cuejahua dyaque saretanayaque, beru yuequedya quisarati cueja puji cuanara cuejahua buchique ama. Jadya ama bucha iyacua ecue cuanara cuejayaque tu dyaque jidaque, Juanra cuejacuare buchique ama. Jadidya tuque, arepa micuanara ecue cuanaque jetiedya, aishuque ama jadya baya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Juanja cuejama jarijutu ni ejera buchique cuejahua ama, inime cacuaretiya cuanaque iyacua eque Yusu queja eje bucha judirue juishuque. Iyacuatu era cuejaajenucaya tura quisarati cuejahuaque nucadya. Cuejayaju bacatsutu eje umadya pureama tsehue Yusu queja catyatiya. Casada dyaidama cuanaque pureama tsehue ijahue aya tupu ecatiu bucha, jadidya tuna pureama tsehue eaqueja catyatiya. ");
INSERT INTO cavNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","14","Moisésra, Yusu equeque quisarati cuejaquique cuanara jadyatu cuejacuare ejeque huecaca Yusura iyacua inime eque narutibuneyaque. Ejeque cuanapa Elías Yusu equeque quisarati cuejaquique junabuque, Yusuja Emepeque junama jarijudya. Juan tu tumeque Elías buchique, arepa micuanara ejenecarama ahua ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Micuana quijacabati aqui juatsu, nebacacue. ");
INSERT INTO cavNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“¿Ai baetu iyacua aniya cuanaque? ¿Ai tsehue beta tupu jadya tuna eau? Tuna tuna peya cuanara cuejaya eque jucarama juya. Ebacua cuana ijahue juya bucha jutidya tuna, peya ebacua cuanara ijahue aquerecara ayaju ijahue jucarama juya bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Yusura tuaqueja judiru ishuque quisarati cuejamereyaju bacatsu, pureama nejucue’, jadya ayaju bacatsu, tuna pureama jucarama juya. ‘Peya inime micuanaja jucha cuana aniyaque caadebatitsu nejucue’, jadya ayaju bacatsu, tuna peya inime jucarama juya. Ebacua cuana tuna tsehue tupu cuanara rauta duduyaju ijahue jucarama ejuu bucha tuna. Ebacua cuana tuna tsehue tupu cuanara peya inimeque jeru ayaju pacarama ejuu bucha tuna. ");
INSERT INTO cavNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Iyacua tunara yatse bijidamadurahua Juan, ique jadya. Juantu anicuare quibeti neri juyaque, ecuita cuana tsehue araara, ijiiji jadya juyaque ama. Tuque jadya juya baatsutu ecuita cuanara ahua, tuquepa equijahuati, jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tuequedya IQUE ECUITA junahua. Ique bacue earaqui ara, uva nacaca esasanashaque iji jadya juya ecuita cuana tsehue. Ique jadya juya baatsu tunara dajicada, nijuqui arida jadya aya. Iquepa ecuita cuanara bijidamaduraya cuanaja ecare; tumebaedya iquepa enaruquija ishu chipiru sitaqui cuana tsehue casitatiya, jadya tunara aya. Era, Juanra jadya ayaque baatsutu ejitaju yatse betadya Yusura bahue amereya eque juyaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Corazín, Betsaida, Capernaum epu cuanajutu Jesúsra acuare jetiama ni ejeque ecuitaja ataquique ama Yusuja casa bamereyaque. Arepa tuhua aniya cuanara tura ayaque bacuare ama bucha, cacuareticarama tuna inime jucuare. Jadya tibu tuna Jesúsra nereda atibunecuare: ");
INSERT INTO cavNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Dyaque nerecada micuana jubuque, micuana Corazínju, Betsaidaju jadya aniya cuanaque! Tiro, Sidón jadyaju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha, baquena ni tuna juquena juhua Yusuja casa era micuana iyacua bamereyaque, cacuaretiquena tuna inime juquena jucuare. Jutuquena tunajatu jucuare ejutuqui sehuedaque, ai tiru, muru tsehue iyucaju casehueti jadya, inime cacuaretihua jadya ata ishu. Micuana micuana cacuaretihua ama inime, arepa era Yusuja casa tsehuedya ayaju bahua ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Riyaque micuana cuejaya. Ejeque huecaca Yusura jidama cuanaque nerecaturadadiyaju; tura micuana dyaque nerecaturabuque; Tiroju, Sidónju cuanaque jucuare dyaque tura micuana nerecaturabuque. Micuanajatu anicuare emajaca ecue casa baishu. Tunaja baishuque aijama jucuare tibu micuana tuna bucha dyaque micuana nerecada jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Micuana Capernaumju aniya cuanaque, jida bucha datse micuana cabatiya. Dyaque inime metseque bucha datse micuana cabatiya. Barepaju etsurashatau bucha datse micuana cabatiya. Ijahuaja etiquiju jutidya micuana nudyatabuque. Sodomaju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha baquena ni tuna Yusuja casa juquena juhua iyacua micuana era bamereyaque, cacuaretiquena tuna inime juquena jucuare. Pana aputashatana ama tunajatu epu juquena jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Riyaque micuana cuejaya. Tere huecaca juetihuaju micuana Yusura dyaque nerecaturabuque. Sodomaju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha tuna tumeque huecaca juetihuaju, dyaque ama canerecatibuque, micuanara quisarati cuejayaque bacacarama ahua cuanaque bucha ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesús tuja Etataque barepaju tsehue quisaraticuare: —Tata, miquemi barepa, yahua jadya aniyaque metseque. Bahue, inimequi bucha cabatiya cuana queja ecabameretiuquemi, mique eje buchique adebacara, bahue jucara ebari juya cuana queja cabameretihua. Yusurupai mique aya, mique jadya juhua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jadidya tu juya, mira jadya amerehua tibu, Tata, —jadyatu Jesúsra acuare Etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jadya juatsu tujatu isaranucacuare tuhua cuanaque: —Ecue Etatara ique mepehua tuque cuarequi rehua ecuita cuana ejitaju amere ishu. Ecue Etatara peadya camadya ique pana adeba aya. Ique tuja Ebacuaque. Era cuita camadya tuque ecue Etata pana adeba aya. Tumebaedyatu adebaya era adebamerehua cuanara. ");
INSERT INTO cavNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Yanacana cuita micuana cacasatiya ecuita cuanaja cacuatsashati eque anitsu Yusu queja judiru ishu. Ai bicueda cuitaque abutsu ereme ejuu bucha micuana. Eaqueja necatyaticue. Era micuana secaya micuana inime tsapemere, bajitura jadya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Catsahuamereti ishu ique neacue micuana remeshaquique buchique dujuquere ishu. Ique eque necabahuityaticue Yusu queja judiru, tuja biji eque ani jadya juishuque. Ique jida, casumiti baecuaque. Eaqueja catyatitsu micuana ecabutique quiyabutyatitsu canajaraya bucha ecabatiu. ");
INSERT INTO cavNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Casaturaya micuana era, era amereyaque micuanaja aishu. Dyaque jida inime tsapema micuana amereya. Era micuanara bicuedaque abuyaque jatada tsehue ecuareu bucha tuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tume patyatu Jesús cueticuare euhua cuana eque canajara huecacaju. Aridatu trigo euhuaque jucuare ejahuane, amena racataqui. Ecuana tura mepehua cuanaque ecuana tuhuadya jucuare tuatsehue. Aracara ecuana jucuare. Aracara juatsu tuque ecuana trigo esa sepitsu etsucaca mucuajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Umae fariseo cuanara baatsu tunajatu Jesús cuejacuare: —Mira mepehua cuanaquetu Moisésra cuatsashacuare eque ama juya. Meredya tuna juya etsucaca cuana sepi, mucu jadya juyaque. Meretu jutabaecua canajara huecacaju, —jadya tunajatu cuejacuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesúsra tuna quemitsacuare: —Neadebacue ecuanaja ebaba David emuique jucuareque. Tuque, tuatsehue cuaya cuanaque jadya tuna aracara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Davidtu Yusuja etareju nubicuare. Nubitsu tujatu Yusuja ishu eiyaque pan cuana inacuare. Inatsu tujatu aracuare. Arepa tuja, tuatsehue cuaya cuanaja jadya arataquima paju ama bucha tuna aracuare, pae cuanaja cuita camadya arataquique. Jadya ama buchatu Yusu cahuaitishacuare ama, tumeque pan aratsu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ni dyaditu pae cuanara Yusu cahuaitishaya canajara huecacaju Yusuja etareju mere juyara, arepa Moisésja cacuatsashati eque mere huecaca ama paju ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Era cuejayaque pana ijacabaca neacue. Yusuja etareju mere juya cuanajatu canajara aijama canajara huecacaju, dyaque di taa tu ecue cuanaque canajaraya amadya. ");
INSERT INTO cavNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ehuene tu Yusura quisarati acuareque: “Dyaque jida micuana quiyuhue batsati aqui amerecara aya, ique uu cuana iyetsu tyaishuque bucha ama” jadya. Micuanaratu adebataqui ama baya eje buchique jadique quisarati. Adebaquena ni micuana juquena juhua, tume tuque micuana eje bucha jumaque ecajuchati mique jadya aquena ama juhua. ");
INSERT INTO cavNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","IQUE ECUITAjatu aniya cacuatsashati canajara huecacaju ai juishuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jadya juatsutu Jesús tuhua caradati ishuque etareju nubinucacuare. Canajara huecacajutu jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ecuita emetucu majuquetu tuhua jucuare, tumebaedya Jesús ujeu baqui cuanaque. Tunaratu dadicara acuare Jesús eje bucha ejuuque tuque jidama aishu. Jadya tibu tunajatu bacaduracuare jadya: —¿Chachanetaquidyatu ujejeda cuanaque canajara huecacaju? ");
INSERT INTO cavNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesúsra tuna quemitsacuare: —Meredya tu uu caniju pacacahuaque cuinanasha. Jadya ama bucha ejeja ni micuanaja cani dedaju uhuisha epacacau canajara huecacaju, ecuinanashaudya tuque micuanara, arepa ecuanaja cacuatsashati eque tumeque huecaca mere jutabaecua ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Ecuita tu dyaque inime metseque uhuisha bucha ama! Jadya tibutu ecuitaja ishu jidaque ataquidya canajara huecacaju, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Tumetu Jesúsra ecuita emetucu majuque isaracuare: —Rirucue micue ebi, —jadya tujatu acuare. Ebi riruya tsehuedya cuitadya tujatu emetucu chacha jucuare peya emetucu bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jadya baatsutu fariseo cuana cuinanaquenacuare. Tuequedya tunajatu inime bajejetibunecuare Jesús iye ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Tunara iyecara ayaque caadebatitsutu Jesús tuhuaque dirucuare. Jetiama ecuitaratu tupujudya acuare. Jesusratu chachanecuare dutya ujejeda cuanaque ecuita jetiama ducuque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Cuatsashacuare tujatu ecana: —Necuejaume ni ejeque buchique era eje bucha ahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Berutu Isaías Yusu equeque quisarati cuejaquira icueneta cueja acuare Yusuja Emepeque junatsu eje bucha judadiyaque. Jesús jadya juhuajutu, tura cuejacuare bae cuitadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Riyaque ri ique merequique, ecue Emepeque. Iyuhueda tuque ecue. Ique dyaque pureama tuatsehue juya. Ecue Espiritutu tuatsehue jubuque. Ique Merequiratu dutya queja aniya cuanaque cuejabuque ecue yatucaju jida, tuyu juishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Quicueneticaramatu jubuque. Quiquebuque ama tujatu peyaja icuenena ishu. Junenibuque amatu epu quini eque quicueneti tsahua ishuque sare juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ecapeya inimetique, casadamaque jadyatu shita penuque buchique aishu ama buchique. Jadya ama buchatu ecue Emepera casaturadadiya ecasatereque. Eaqueja pana catyati juma cuanaque tuna tsahuabuque, eaqueja nimeedya jutidya juaje ishu. Arepa ecana shita penuque bucha paju ama bucha, arepa ecana ude ticuhuieque hueca bucha paju ama bucha, era tuna casaturabuque dutya tere huecaca juetishayaju tuyu aya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Dutya queja aniya cuanaque tuna tuaqueja catyatibuque”, jadyatu Yusu jucuare beru tuja quisarati puji Isaías eque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jesús queja tunajatu dujucuare ecuita ijahua cuanara quijahuatishayaque, shuhuique quisarati baecuaque jadya ijahua cuanara amereyaque. Jesusratu capetatisha, quisaratisha jadya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jadya baatsutu dutya ecuita cuana anajacatacuare. Cabacaduratitibunecuare ecana: —¿Jesús ni tu David eque ejuracanaque, Yusura cuadisha ana acuareque ecuana jida inimeju cuinana ishu junabuque jadique? —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo cuanatu tuna jadya bacatsu jadya jucuare: —¡Aama! Beelzebú ijahua cuana cuatsashaquique tu tuatsehue. Jadya tibudya tujatu casa aniya ijahua cuana ijehuecuina ishu, —jadya tuna jucuare. (Beelzebú taa tu Satanás bacani nucadya). ");
INSERT INTO cavNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesusratu adebacuare tunara eje bucha inime tupuyaque. —Jadique juatsu taa tu Satanás tuta tacadya jutidya pana cayuamaturati ejuu. Yahuaju dutya aniya cuanaque ni ecajaquetibareu cuarepe cuarepe tuna cama cati ishu, tuna camadya jutidya tuna ecatillatiu. Epuju cuanaque ni ecajaquetibareu cati ishu, tumebaedya tuna ecayuamatiu; tumebaedyatu ejuu etareju cuanaque tuna cama catiyaque juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Era ni Satanásja casa tsehue ijahua cuana eijehuecuinau, tume taa tu Satanás tuja cuana tsehuedya jutidya ecatiu. Tumetu ni ejeque ijahuadya jutidya tura cuatsashaya eque ejuu ama. Satanásja casa tsehue ama tuque ijahua cuana ijehuecuinaya. ");
INSERT INTO cavNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Micuanara ique aya, Beelzebúja casa tsehuepa ijahua cuana ijehuecuinaya jadya. Micuanara ni ejeneya era Beelzebúja casa tsehue ijahua cuana ijehuecuinaya, jutaquiju ¿aija casa tsehue jatsutu ijehuecuinaya micuana tsehue juneniya cuanara? Micuanara Yusuja casa tsehue tunara ijehuecuinayaque ejeneya tibu, neejenecue era dyadi Yusuja casa tsehuedya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yusuja Espiritura ique casa tyaya ijahua cuana ijehuecuina ishu. Jadya tibudya tuque micuanaja inime jutaqui “Riyaquedya ri Yusuja Emepeque”, idya micuanara ihuacuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ijahua cuana ijehuecuina ishutu icuene cuita tuna cuatsashaquique Satanás dutya tuja casa secataqui, ecuita dyaque casadaque tuja ai seca ishu icueneta risi ataqui bucha. Ejeque casa secamaja etarejutu eje bucha nubitaqui ama tuja ai aniyaque seca ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ejeque ecue ishu jidama quisaratiyaquetu ique ujeuque. Ique tsahua baecuara ique jidama aya. Tumequetu era mepeyaque dacashaajeya buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Jadya tibudya micuana riyaque cuejaya. Yusuratu jidama quisarati aya cuanaja jucha cuana eapupashau, eje bucha cajuchatie juya cuanaja. Jadya ama bucha Yusuja Espirituja ishu jidama quisarati aya cuanaja jucha tujatu apupasha nime ama. ");
INSERT INTO cavNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yusuratu IQUE ECUITAja ishu quisarati jidama ayaja jucha cuana eapupashau. Jadya ama bucha tujatu jucha cuana apupashabuque ama tuja Espirituja ishu cuita jidama quisarati aya cuanaja. Ejeque jadya quisaratiyaquetu dyaque nerecada jubuque riyaque yahuaju, tumebaedya majutsu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesusratu isaranucacuare fariseo cuana: —Acui ni jidaque, jidadya tujatu ecaca. Acui ni jidamaque, jidamadya tujatu ecaca. Dutya acuitu adebataqui ecacaju. (Riyaque quisarati tsehue tuna Jesúsra huecashacara acuare. Ejeque eje bucha juya equetu adebataqui eje buchique ecuita jadique). ");
INSERT INTO cavNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","“Micuana micuana jii jii ama bacua bucha. Micuanadya micuana jidama; jadya tibu micuana jida quisaratitaqui ama cabatiya. Educuju ecuanaja inime tupu aniyaquedya tuque ecuanaja quisarati abahue. ");
INSERT INTO cavNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ecuita jidaquetu jidadya quisaratiya, jidaque inime tuja educuju aniya tibu. Ecuita jidamaque bacue jidama quisaratiya, jidamaque inime tuja educuju aniya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Era micuana riyaque cuejaya. Yusuja yacuaju inime bajeje ishu netititsu tuhua, micuana eje bucha juhuaque dutya cacuejatibuque eje bucha juatsu micuanara quisarati jidamaque ahua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Micuanara cuitadya quisarati ahua eque micuana Yusura jidama jadya abuque. Micuanaja quisaratijudya micuana eje buchique cabameretiya. Jida ni micuana quisarati ahua, ‘Jida mique baya’, jadya micuana Yusura abuque. Jidama micuana quisarati ahuaju bacue, ‘Ecajuchati mique baya’, jadya micuana Yusura abuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tumetu umae fariseo cuanara, cacuatsashati bahuityaqui cuanara jadya jipeticuare Jesús. Jipetsu tunajatu isaracuare: —Ebahuityaquique, acue ai bapeque inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu, —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesúsra tuna quemitsacuare: —Micuana micuana jidama inime cadujutiya cuanaque. Yusu micuana iyuhueda bajacahua ni micuana tuja yana equedya juya. ‘Acue ai inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu’, jadya micuana juya. Aya ama tuque era. Jonás jucuareque cuita camadya micuana huecashaya. ");
INSERT INTO cavNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tuquetu jae ebarija ecarecani ducu jucuare quimisha huecaca, quimisha meta jadya, Yusura jae queja mejijiju pushamereya tupu. IQUE ECUITA tumebaedya quimisha huecaca, quimisha meta jadya emaju jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jadya juatsu Jonás cuacuare Niniveju Yusuja quisarati cuejara. Cuejayaju bacatsutu tuhua cuanaque inime cacuareticuare. Ique Jonás bucha dyaque inime metseque. Jadya ama bucha micuana bacacarama aya era bahuityayaque. Tumetu tumeque huecaca Yusura dutya eje bucha judadibuqueque cuejabareyaju, Niniveju anicuare cuanara micuana pana cueja abuque Yusuja yacuaju: “Dyaque ecana pacanerecati Jesús yahuaju anicuare patya tura cuejayaque bacacarama jucuare cuanaque”. ");
INSERT INTO cavNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Beru yuquejanetu ecuari epuna Sabá juque beni diji queja anicuareque jecuare dyaque japadaque Salomón dyaque inimequija quisarati bacara. Ique Salomón bucha dyaque inime metseque. Jadya ama bucha micuana era cuejayaque bacacarama aya. Jadya tibudyatu tere ishuque huecaca juetihuaju, Yusura ecuita cuana tuna eje bucha jubuqueque cuejabareyaju tumeque ecuari epunaradya micuana pana cueja abuque Yusuja yacuaju: “Dyaque ecana pacanerecati Jesús yahuaju aniya patya tura cuejayaque bacacarama jucuare cuanaque”, jadya tuna tumeque epunara Yusuja yacuaju cuejabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tuhua cuanaque tuna Jesúsra cuejanucacuare: —Anicuaretu ijahua tura quijahuatishaya quejaque ecuinanaque. Tumeque ijahuatu junenicuare anitaya ama cuanaju ani ishuque sare juyaque. Dadicuare amatu eju ani ishuque. Dadima aatsu tujatu jadya inime tupucuare: ");
INSERT INTO cavNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Padirunuca ique eju ique cuinanashatahuaju. Tuatsehue camadya ique eaninucau” jadya. Tumeque ecuita queja judirunucatsu tujatu badirucuare ni ejeque ijahua tsehue ama, etare ejabu jida, ebajeje bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jida baatsutu tumeque ijahuara peya ijahua cuana sareticuare. Pacarucu ijahua cuana, tuque bucha dyaque jidama cuanaque tujatu daditicuare. Daditsu tujatu ecana beticuare. Juetinucatsu tunajatu dutyara quijahuatishanuc acuare tumeque nerecadaque ecuita. Jadya juetu ecuita juya tuque icuene juhua bucha dyaque jidama. Tumebaedya micuana iyacua nerecada juya bucha dyaque nerecada jubuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús quisarati netiyajutu juticuare ecuaque, tuatsehuequi cuanaque jadya. Ecuita jetiama tibu tuna etsecueju netinaticuare. Quisaraticara datse tuna jucuare tuatsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tumetu ejera cuana Jesús cuejaticuare: —Micue cuaa, micue miatsehuequi cuanaque jadya rena etsecueju. Miatsehuepa tuna quisaraticara juya, —jadya tujatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","—Tumeque epuna tuque ecue ecuaa; tume cuanaque tuna ecue eatsehuequi cuanaque. Jadya ama bucha tuque ecue aniya peya ecue iyuhueda cuanaque, —jadyatu Jesúsra acuare tuhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tume tura ecuana imetacuare tura mepehua cuanaque. —Riya cuanaque rique ecue iyuhueda cuanaque. Riya cuanaque rena ecue ecuaa buchique, ecue eatsehuequi cuana buchique jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iyuhueda tuna baya ecue Etata barepaju aniyaja inime eque juya cuanaque. Tunadya tuna ecue ecuaa, ecue eatsehuequi cuanaque bucha bae ayaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tumeque huecacatu Jesús cuinanacuare etare juque. Cuinanatsutu aninaticuare bei jiruru tuhua cuanaque bahuitya. ");
INSERT INTO cavNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Masadamatu caradatinucacuare jetiama ecuita cuana. Tuna majacama cuita baatsutu Jesús cuabaju nubitsu anibutecuare. Mejiji equera tunajatu bacacuare tuque quisaratiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Cuatsabiji eque tujatu ecana bahuityacuare, yunerique adebamere ishu. —Anicuaretu ecuita. Cuacuaretu tuja teeju uhuauhuara. ");
INSERT INTO cavNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tura uhuaajeyaquetu umae pacacacuare edijiju, yahua pajidaju. Uhuayaque etsucaca yahuaju huiruhuaquetu upati huiri cuanara anibutetsu mucutillacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Peya etsucaca cuanatu pacacacuare yahua macana dedamaju. Yahua macanamaque dedama tibutu huijatsu danecuare ama, masadama buraracuare ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ijetija uqueratu iyecuare euhua cuanaque, etiri yahua nacadaju ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Umae bacue pacacacuare acui tiri, acuija jadya jetiama ducu. Acuija cuana danetsu tujatu trigo euhuaque ehuija cuanaque iyetillacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Umae etsucaca cuanatu pacacacuare yahua jidaju. Cacacaticuare umada. Tee mere pujiratu jetiama huesacuare tuhua euhuaque. Umae esa cuanajutu cien tsucaca jucuare. Peya esa cuanajutu shucuta tunca tsucaca jucuare. Peya esa cuanaju jucuare quimisha tunca tsucaca. Jadyatu jucuare teeju euhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","“Quijacabacati aqui juatsu, nebacacue, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tume tuque ecuana tura mepehua cuanara jipeticuare. Jipetitsu tuque ecuana acuare: —Ecuita cuana bahuityayaque tuquemi ecana cuatsabiji cuana eque bahuityaya. ¿Eje bucha juatsu tuquemi ecana jadya bahuityaya? —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesúsra ecuana quemitsacuare: —Yusura micuana pana adebamere acara aya tura tuja cuanaque naruyaju eje bucha juyaque. Peya cuana jadya cuejae eauque, tuna cuatsabiji cuana eque jutidya cuejaya jari, pana huecasha cuita ayaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ejeja ai aniyajatu dyaquedya ai aniajeya. Ejeque aiqui bucha cabatiyaquetu, aimaquedya jutidya. Tuja aniyaque piji tujatu aputatereya. ");
INSERT INTO cavNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jadya tibudya tuna cuejaya cuatsabiji cuana eque, tunara era bahuityayaque pana adeba eauju. Tunaratu era ayaque baya. Tume tuna baatsu bama jiu juya. Bacatsu tuna bahuityahua ama jiu juya, arepa bacahua ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Berutu Isaías, Yusu equeque quisarati cuejaquique, jadyatu judadiya jadya jucuare. Tumetu iyacua tuequedya juya. “Micuanaratu bacabuquedya. Adebataqui ama tuque micuana babuque. Tume tuque micuana adebataqui ama babuque micuara petayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Micuanaja Yusu adeba ishuque tuque micuanaja aishu ama cuita jubuque caadebati ishu. Bacabuque datse micuana Yusuja quisarati. Ijaca cani ecatse ehuijitutana bucha jutidya micuana jubuque. Yatuca ecatse etumu bucha jutidya micuana jubuque. Jadya tibudya tuque micuana adebabuque ama micuanaja yatuca tsehue bayaque, ni micuanara micuanaja ijaca tsehue bacayaque. Micuanaratu adebabuque ama, ni micuana inime cacuareticara jubuque, eaqueja catyatitsu eaqueja judiru ishu”. ");
INSERT INTO cavNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Isaiasra béru huenecuareque quisarati aatsu ecuana Jesúsra cuejanucacuare: —Micuana micuana dyaque jida, pureama, micuanaja yatuca tsehue bayaque micuana pana adeba aya tibu, micuanaja ijaca tsehue bacayaque micuana pana ejene aya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Neadebacue riyaque. Beru yuequedyatu Yusu equeque quisarati cuejaqui cuanara, tumebaedya ecuita tuyu cuanara jadya bacara ebari acuare ecue casa micuanara iyacua bayaque. Bacacara ebari tuna acuare ecue quisarati iyacua micuanara bacayaque. Jadya ama bucha tunaja anihua ama emajaca baishu ni baca ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Pana ijacabaca neacue. Pana cueja micuana aya uhuauhua puji cuatsabiji equeque eje buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Umaetu Yusura naruyaju eje buchique quisarati bacatsu masadama nime aputaya, Satanásra masadama pana nime aputashamere aya tibu. Tuna tuna ediji pajidaque buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Umaeratu ejetsunue ishu ama pureama tsehue Yusuja quisarati bacaya. Nerecada juya cabatitsu tuna ejenejacaya. Quisarati ejenehua baatsu jidama atayaju, masadama tuna ejenejacaya, pana adeba aya ama tibu. Tuna tuna yahua macana dedamaque buchique. Huijahua cuanaquetu macana quini danetsu tsunuda ama juya, etiri dedama tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Umaera Yusuja quisarati bacaya cuanaratu ejenejacaya, riyaque yahuaju cuanaquedya jutidya dyaque inime tsapequi aya tibu. Tunajatu inime juya chipiru dyaque umada anitsu camadya pureama ejuu bucha. Chipiru dyaque iyuhueda baatsu tuna tunadya jutidya ijahue catiya. Jadya juatsu tuna Yusu muijacaya. Tuna tuna yahua acuija quinique buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Umae cuana Yusuja quisarati bacaqui juya cuanaratu adebaajeyadya jutidya. Tuna eje bucha anieju tuna ejitaju Yusuja biji eque aniyaque. Umae cuana tunajatu tsahuaya eaqueja catyati ishu. Tunadya tuna esaju jetiama etsucaca juhuaque bucha, cien, shucuta tunca, quimisha tunca jadya catyatihuaque buchique, —jadya tuna Jesúsra acuare tuhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jadya juatsu tuna Jesúsra bahuityanucacuare: —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. Nebacacue riyaque cuatsabiji. Jucuare tu ecuita. Cuacuaretu tuja teeju trigo uhuara. Uhuatsutu dirunucacuare tuja etareju. ");
INSERT INTO cavNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tumetu meta tuque, dutya tuja etareju aniya cuana tsehue tahuiyaju, nubicuare tuja teeju tee metseque ujeu baquique. Uhuacuaretu tumeque teeju nucadya peya etsucaca. Etsucaca euhua cuanaque huijatsutu trigo bae cuitadya jucuare. Ecaca bacue tuja arataqui ama jucuare. Trigo jiuque tsucaca uhuatsutu dirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Uhuahuajutu dutya euhua cuanaque huijacuare trigo neri, trigo jiuque jadya. Cacacatihuaju piisi amena esaju baatsutu teeju mere juya cuanara chamacama adebacuare dutya tumeque teeju huijahuaque trigoque ama. ");
INSERT INTO cavNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jadya baatsu tuna emechiqui queja cuacuare. “Tata, miratu uhuachine teeju trigo neri. Jetiama cuitatu huijachine trigo ducu trigo jiuque. ¿Airatu uhuachine tume jidamaque huijachineque?” jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tee metsequetu jucuare: “Ecue inimetu ejeque ique ujeu baquira uhuachine”, jadya tuna emechiquira acuare. “¿Mutsumerecara mira ecuana aya trigo jiuque?” jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Paju ani. Mutsuyaque tuque micuana emutsuu trigo neri. ");
INSERT INTO cavNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Panetidya jutidya ecuanara racaya tupu. Trigo raca ishuque huecaca juetihuaju piisi tuque mere puji cuana jadya abuque: ‘Icuene nemutsucue trigo jiuque. Mutsutsu nequerebarecue. Jadya aatsu nepahuacue. Jadya bajejee dutya aatsu piisi neracacue trigo. Racatsu neiyacue ecue trigo iyaquiju’”, jadyatu acuare emechiquira mere puji cuana, —jadya tuna Jesúsra cuejacuare. (Jadiquetu Jesúsra cuatsabiji eque huecashacuare, arepa ecuana riyaque yahuaju yuhua cama aniya ama bucha, ejeque huecaca Yusuja cuanaque Yusuja ama cuanaque jadya cajaquetibuqueque.) ");
INSERT INTO cavNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesúsra tuna bahuityanucacuare peya cuatsabiji eque bahuityayaque. —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. Adebayadya micuana mostaza caca, teeju euhuataque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Achaachaque piji, bataqui nerique ama. Jadya ama buchatu buraratsu, huijatsu danetsu dyaque arida juya, teeju peya euhua cuanaque bucha ama. Tuja yaa cuanajudyatu upati huiri cuana eja catiya, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra jadique huecashacuare. Arepa catibutiyaque eje uma piji tuaqueja catyatiya ama bucha, tuequedya tuna riya piji, riya piji jetiama catyatiajeya.) ");
INSERT INTO cavNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tumebaedya tujatu ecana riyaque cuatsabiji eque bahuityanucacuare: —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. Epunatu pan ejuu. Eiyautu riya piji levadura. Quimisha equiniqui medidaju tujatu harina ehuauu. Tumeque riya piji levaduraradyatu dutya esaca huauhuaju emujashau, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tujatu ecana jadique huecashacara acuare. Levadurara dutya esaca mujashaya bucha, jadidyatu tuja quisarati dutya queja cuejatanabuque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesusratu ecuita jetiamaque cuatsabiji eque cama bahuityacuare. Cuatsabijima tujatu ecana bahuityacuare ama. Pana adebamere ama tujatu ecana cuatsabiji eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jadya juetu jucuare Yusu equeque quisarati cuejaquira acuareque: “Cuatsabiji eque tuna bahuityabuque. Yusura yahua iyahua equeque etehuaque tuque quisarati abuque”, jadya patu Yusu equeque quisarati quejaquira huenecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jadya juatsutu Jesúsra camadya ishu isaracuare tuhua aniya cuanaque. Tuna isaratsutu ecuana tsehue etareju dirucuare. Tume tuque ecuana jipetinucacuare. —Ecuana peya cuana tsehueju mira ecuana cuatsabiji cuejahua trigo ducu trigo jiuque uhuacuareque. ¿Ai mira ecuana bahuityacara aya tumeque cuatsabiji eque? —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesúsra ecuana quemitsacuare: —IDYA ECUITA tee metse buchique, trigo neri uhuaquique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Yahua tu tee buchique. Dutya ecue neri cuanaque tuna trigo neri cuana buchique. Satanásja cuanaque tuna trigo jiuque ehuijaque buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Satanás tu trigo jiuque uhuaquique buchique. Mere puji cuanara teeju euhuaque jahuanehuaju huesahuaju jucuareque tu yahua tereyaju judadibuqueque buchique. Tume teeju euhuaque huesa puji cuana tu barepaju Yusu tsahuaqui cuanaque jadique. ");
INSERT INTO cavNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Trigo huesaqui cuanara trigo jiuque trigo ducuque cuitubutsu pahuacuareque jadiquetu yahua tereyaju judadibuqueque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Tumeque huecaca ique enaruqui juatsu tuque ique barepaju tsahuaqui cuanaque cuadishabuque, dutya jidama juhua cuanaque sita ishu, dutya peya cuana jidama amerequi juhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tume cuanaque tuna ijahuaja etiquiju ijehuetanabuque. Tuhua tuna payaque dutya etse tari jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tumetu adebataqui jubuque eje cuanaque Yusura amereya eque cuita juhuaque. Jidama cuana ducuque tuna cuinanabuque, barepa asicadaque cuetiyaju ijeti epujetanau bucha. Tuna tuna tuhua Etataque Yusu huaraji arida queja judirubuque. “Micuana quijabacati aqui juatsu, nebacacue, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesúsra ecuana bahuityanucacuare: —Bahue micuana amerecara aya eje bucha micuana Yusura naruyaque. Riyaque cuatsabiji micuana cuejaya. Jucuare patu ecuita. Yahua puru juyaque tujatu dadicuare dyaque tsuje aridaque etehuaque. Daditsutu dyaque pureama jucuare. Tuja yahua juque ama tujatu dadicuare. Jadya tibudya tujatu tuhua nucadya papanucacuare. Tehuanucatsu patu dirucuare, tuja dutya ai aniyaque catyati ara, dyaque umada chipiru anitsu tumeque yahua quemi ishu. Quemicuaredya tura, —jadya ecuana Jesúsra cuejacuare. (Riyaque cuatsabiji eque tuna Jesúsra huecashacara acuare. Tuja juishuque patu dyaque saretanayaque. Eje buchadya tujaque jucara ebari tsehue ecuana tuja ishu jutaqui.) ");
INSERT INTO cavNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Bahuityanucacuare ecuana Jesúsra: —Bahue micuana amerecara anucaya eje bucha micuana amena Yusura naruyaque. Anicuaretu catyati puji tumu dyaque tiquidaque tsuje aridaque perla bacani sare juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Jadya juyajutu ejera cuana bamerecuare tumu dyaque tiquidaque tsuje aridaque. Dutya tuja ai aniyaque catyati caticuare tumu quemi ishu. Quemicuaredya tura, —jadya tura ecuana cuejacuare. (Riyaque cuatsabiji eque tuna Jesúsra huecashacara acuare tuja juishuque patu dutya ai dyaque tsuje arida cuanaque buchique.) ");
INSERT INTO cavNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesúsra ecuana bahuityanucacuare: —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. Riyaque cuatsabiji micuana cuejaya. Ecuita cuanaratu marecuare jae deruquique enaju. Derucuare tuna jae bape bape cuanaque earataque, arata baecuaque jadya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jae deruquique jequehuajutu jae puji cuanara repecuare mejijiju. Tuhuadya tuna jae earataque, arata baecuaque jadya mepe juanibarecuare. Jae earata cuanaque tunajatu jitiju ishacuare. Arata baecua cuanaque tunajatu ijehuebarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jadidyatu jubuque tere ishuque huecaca juetihuaju. Barepa juque Yusu tsahuaqui cuanaque tuna jebuque ecuita Yusuja ama cuanaque, ecuita Yusuja cuanaque ducuque mepera. ");
INSERT INTO cavNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Jidama cuanaque tunajatu ijehuebuque ijahuaja etiquiju. Tuhua tuna pajacabuque ama. Dyaque nerecada tuna jubuque. Ujera tuna etse tari amerebuque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Tume ecuana Jesúsra bacaduracuare: —¿Jutiyadya micuanaja inimeju era cuejahuaque? —Jejee, Ecuana Cuatsashaquique. Jutiyadya tuque ecuanaja inimeju, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tura ecuana acuare: —Dyaque jida tu cacuatsashati bahuityaqui cuanaque eaqueja catyati ishu. Jadya juatsu tunajatu chamacama pana cueja eau beruque inime equeque, iyacua equeque jadique. Ecuita dutya tuja aniyaque tsumequi buchique tuna, iyacuaque, beruque jadya tsumeya bucha tuja etareju cuanaja jida ishu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tume cuanaque cuatsabiji atillatsutu Jesús dirunucacuare tuhuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cuacuaretu Nazaretju, tuque catemuticuareju. Caradati ishuque etareju tujatu ecana bahuityacuare. Anajacatacuaretu tuhua casitaticuare cuanaque. Bacuare tuna tura Yusuja casa tsehue aya cuanaque. —Riyaque ecuita taa dyaque inimequi quisarati ishu. ¿Eju jatsuri riyaque jadya quisarati cabahuityatihua? ¿Eje bucha ae jatsu rejari eau ejeque ecuitara ayaque ama? ");
INSERT INTO cavNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nanadaju ecuanara bacuareque taa riya. ¿Riyaquedya ama jatsu ri Joséja ebacuaque, mesa, caju cuana pujija ebacuaque? ¿Mariaja ebacuaque di taa riya? ¿Riyaque di taa ri Santiago, José, Simón, Judas jadyaja eujique? ");
INSERT INTO cavNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tuja enuu cuanaque tupuju cuanaque taa rena ecuanaja epujudya aniya. ¿Tume jatsuri eje bucha juatsu dyaque quisarati bahue? —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tunara nanada equedya bahua tibu, tunajatu ejenecarama acuare tuque Mesías, Yusuja Emepeque jadique. Jadya tibudya tunajatu bacacarama acuare tura bahuityayaque. Jesúsra tuna acuare: —Quisarati dyaque jida cuanaque cuejaqui cuanaque tuna dutya queja jida batsataya, tunaja epuju cuanara cuita bacue aijama. Dutyara tuna pana ijacabaca aya, tunaja ata cuanara bacue aijama, —jadyatu Jesúsra acuare Nazaretju cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tuhua tuja epuju cuita tujatu anericuare ama ai ejeque ecuitaja ataquique ama, tuhua cuanaque tuaqueja catyaticarama jucuare baatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tume patyatu Herodes Galilea naruquique jucuare. Bacacuaretu Jesús ai juyaque, eje bucha juyaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—Tumeque Jesústu baya ecuita ama. Juan Ecuita Cuana Utsaquique emajuque cacuitatitsu netitsuranucachineque tume. Jadya tibudyatu Jesúsja casa aniya ejeque ecuitaja ataquique ama aishu, —jadyatu Herodesra acuare tuque merequi cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodestu pana bahuedya jucuare Juan emajuque, tura cuitadya iyemerechine tibu. Iyacua micuana Juan eje bucha iyetanae jucuareque cuejaya. Herodesratu Juan inamerecuare. Inameretsu tujatu etare apudaju ishamerecuare. Etare apudaju tujatu ishamerecuare Herodías pureamatura ishu. Tumeque epuna tujatu ejuque jahuane jucuare, tuatsehuequique Felipeja ehuaneque. Tumeque epunaratu Felipe jacacuare, Herodes tsehue anicara juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Eje uma cuejadyatu Juanra acuare Herodes: “Caquemititaqui amami micue miatsehuequija ehuaneque tsehue”, jadyapa tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jadya tibudya tujatu Juan iyecara acuare. Jadya ama bucha tujatu inime tupucuare: “Juan eiyemereu; tume taa tu ecuita cuana eatsehue ecahuaitiu. Tunaratu ejeneya Juan Yusuja quisarati cuejaquique”. Ecuita cuana mubatsu tujatu Juan risimeretsu ishamerecuare jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herodesja cuinana huecaca camaratsurutiyaque chine ishutu Herodiasja ebacujunaque ihuarahua cuanaja yacuaju ijahue jucuare. Jadya tuque ijahue juyaju baatsutu Herodesra bijisericuare tuja ijahue. ");
INSERT INTO cavNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tuque tuja biji ijahue juya baatsu tujatu epuna ehue ebari acuare: —Bacacue ique ai mira bijida bayaque. Etyaudya mique era. Yusura ique panerecatura, era mique tyaana ayaque tyayaque ama juatsu, —jadyatu Herodesra epuna ehue ebari acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ecuaquera ana cuejahuajutu epuna ehue ebarira Herodes bacacuare: —Iyemerecue Juan Ecuita Cuana Utsaquique. Piti tubumeretsu, tuja iyuca pejaju iyatsu, ique inamerecue. Riyaque mique bacaya, —jadyapa tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jadya ahuajutu Herodes dyaque peya inime jucuare. Jadya ama bucha tujatu ataquidya jucuare, tura quisarati ahuaque tuatsehue chine juya cuanaja ijacaju jadya juhua tibu, “Yusura ique panerecatura, era tyaana ahuaque tyayaque ama juatsu”. Jadya tibu tujatu cuatsashacuare tuja sudaru cuana: ");
INSERT INTO cavNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","—Necuacue etare apudaju. Juan Ecuita Cuana Utsaquique nepititubuticue, —jadyapa tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tume tuna cuatsashatahua equedya jucuare. Jadya aatsu tunajatu Juanja iyuca pejaju iyatsu epuna ehue ebari tyaeticuare. Tunara tyaetihuaju tujatu ecuaque inamereticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jadya juhuaque bahue juatsutu Juanra mepehua cuanara emajuque queticuare. Dujutsu tuna ishaticuare caniju. Jadya aatsu tunajatu cuejaticuare Jesús, Juan eje bucha juhuaque. (Herodesratu dutya tume cuanaque inime tupuqui acuare. Jadya tibudya tujatu Jesús, Juan Ecuita Cuana Utsaquique chacha enetitsuranucaque bucha bacuare.) ");
INSERT INTO cavNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan Ecuita Cuana Utsaquique majuchineque bahue juatsutu Jesús tuhuaque cuacuare cuaba eque peya queja amaca ecuana tsehue cuita camadya. Ecuita cuanaratu badadicuare eje queja amaca cuayaque. Badaditsu tuna cuacuare tunaja epu cuana juque yahua eque tuaqueja juti ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Cuaba juque cuinanayaratu Jesúsra bacuare jetiama ecuita tuque ihua juyaju. Jadya baatsu tujatu ecana nerecada banaticuare. Chachanecuaretu ujejeda cuanaque tunara dujuya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Amena ijeti nubihuie ecuana tura mepehua cuanara jipeticuare. —Amena taa ri chinehua. Rehuari aijama ni eju buchique ara ishu cuanaque quemi ishuque. Isaracue ecuita cuana. Padiru ecana epu cuanaju, eje queja tuna japadama aniyaju. Pacabacatidiru ecana ara ishu cuanaque, —jadya tuque ecuana aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—Cuadishaya ama tuna era. Micuanaradya ecana nemihuacue, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—Rehua rique ecuanaja aniya pishica pan, beta jae jadya piji camadya, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Nebecue requeja, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tume tujatu ecuita cuana iyabutyamerecuare tuhua tuna netibareyaju cuitadya. Jadya juatsu tujatu inaticuare pishica pan, beta jae jadya. Inatsu tujatu barepa Yusu aniya queja petacuare. Petayaquetu jucuare: —Yusurupai mique aya, Tata, mira ecuana riyaque ara ishuque tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai au jadya aatsu tujatu pan cuana cuesibarecuare. Jadya aatsu tura ecuana tyabarecuare, ecuita cuana ecuanaja tyabare ishu. Tura ecuana tyabareya tupu tujatu jetiama umanashacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Dutya tuna araaracuare, pana jeque juya tupu. Amena jadya juhuaju tuque ecuana jequeshabarecuare peadya tunca beta earacana jiti arida cuanaque pan tunara arabishahua cuana tsehue, jae jadya tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jetieque ama tuna araaracuare. Pishica mil deca cuana tuna araaracuare; epuna cuana, ebacua piji cuana jadya piyebamaque. ");
INSERT INTO cavNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tume ecuana Jesúsra jadya acuare: —Neanibutecue cuabaju. Necarequeticue bei yueque macare. Tumidya micuana adadiya ecuita cuana isaratsu, —jadya tura ecuana acuare. Tura jadya ahuaju ecuana cuabaju anibutecuare. Anibute jadya juatsu ecuana carequeticuare, Jesús ecuita jetiamaque isara juya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Amena ecuita cuana cuadisha ishu isaratsutu Jesús tsuracuare emata baruda cuita amaju Yusu tsehue quisarati ishu. Apunaya tupudyatu tuhua jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ecuana ecuana bei patya patya juajecuare. Ena pacutu cuaba queja catsatana catsatana jucuare, cuejijira ecuana acuatsuruya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Amena huecaca japadara tacure quique pidya juhuaju ecuana Jesúsra jipedirunucacuare ena dyaque eque ajeajeyara. ");
INSERT INTO cavNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesús ena dyaque eque ajeajeyaju batsatsu ecuana dyaque bajida jucuare. Bajida juatsu ecuana jadya jucuare: —¡Ita nebacue! ¡Yatanana tume! —jadya ecuana quique eque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesúsra ecuana yume quiquedya acuare: —¡Bajida nejuume! ¡Idya ique! ¡Casada nejucue! ");
INSERT INTO cavNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pedroratu acuare: —Ecuana Cuatsashaquique, midya ni taa mique, ique dyadi ajeshacuedya ena dyaque eque mique netiya tupu, —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Jecue taa, —jadyatu Jesúsra acuare. Jadya ayajutu Pedro butecuare cuaba juque. Butetsutu ena dyaque eque ajequenacuare Jesús netiya queja. ");
INSERT INTO cavNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Cuejijira bucucushaya cabatitsutu bajida jucuare. Tumetu ajeyaque nubiajecuare. —¡Ecuana Cuatsashaquique, chachanecue ique! —jadyatu Pedro quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tumeque ura cuitadyatu Jesúsra ebi rirutsu inaticuare. —Ejenehua ama tuquemi era cuejipa casada juque echachaneuque, ena pacu juque jadya. ¿Eje bucha juatsu tuquemi ejenehua ama era echachaneuque? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tatse cuabaju tsurahuajutu cuejiji neticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Tume ecuana cuaba ducu anicuare cuanaque chichucata jucuare Jesúsja yacuaju tuque muiyaque. —¡Pusha ama cuitadya mi Yusuja Ebacuaque! —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Bei riquetsu ecuana Genesaret yahuaju jaratsuranaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tuhua aniya cuanaratu Jesús adebatsacuare. Masadama tunajatu tsapecuare quisarati tuque junatiyaque tumeque epuju. Jetiama ecuitatu peya cuejati peya cuejati jadya jucuare tunaja ujejeda cuanaque Jesús queja duju ishu, tuja ecana chachane ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Canerecaticuare tuna tuaqueja: —Cajabamereticue taa ujejeda cuana queja micue una cuatsa cuana pijidya jutidya, tuna chacha juishu, —jadya tunajatu Jesús acuare. Dutya ejeque tuja una jabaqui jucuare cuanaque tuna pana chacha jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Umae fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya tuna juticuare Jerusalén juque. Junatitsu tunajatu Jesús jipeticuare. Jipetitsu tunajatu bacaduracuare: ");
INSERT INTO cavNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Mira mepehua cuanaquetu ecuanaja baba cuanaja bahue eque ama juya. Araara ishutu micue cuanaque emetucu cutsatiya ama ecuanaja bahue eque. ¿Eje bucha juatsu? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tura tuna quemitsacuare: —Arepa micuana peya cuanapa jidama juya jadya aya ama bucha, dutya amadya tuque micuana aya Yusura amerehuaque. Micuanaja bahue cuana eque cuitadya jutidya juyaque tuque micuana Yusura amereyaque aya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Moisés equetu Yusura cuatsashacuare béru: “Muibacue micue tata, micue cuaa jadya”. Tumebaedyatu jucuare: “Paiyetana ejeque etataqueja ishu, ecuaqueja ishu jidama quisarati ayaque”. ");
INSERT INTO cavNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Micuanaratu cuarehua riyaque cacuatsashati. Tume micuana, micuanaja tata nerecada cuanara catsahuamereti ishu bacayaju, jubahue: “Tsahuataqui ama mique ecue, amena ecue dutya ai aniyaque amena Yusu etya tibu”. ");
INSERT INTO cavNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ejera jadya quisarati ayaquetu tuja etataque, tuja ecuaque tsahuataqui ama, jadya tuque micuanaja cuatsasha bahue. Jadya apupashae tuque micuana Yusura cuatsashahuaque aya, micuana cuejatahua cuana equedya jutidya juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yusu adebaquipa ejuu, jadya micuana juya, ai yuneri ama. Isaías Yusu equeque quisarati cuejaquiratu micuana jadya ayaque huenecuare jadya: ");
INSERT INTO cavNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Riyaque ecuita cuanara muiya tunaja quisarati tsehue camadya. Jadya ama bucha tuna eje bucha juya eque ejitaju ecue cuanaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yanacana cuita tunara tunaja bahue cuana eque muiya. Tunara bahuityayaquetu ecuita cuanara inime tupuyaquedya jutidya”, jadyatu Yusu jucuare Isaías eque, —jadyatu Jesúsra acuare fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tumetu Jesúsra ihuaracuare ecuita cuana tuhua eje uma netiya cuanaque. —Pana baca neacue. ");
INSERT INTO cavNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ecuitara ai arayaratu ecuita cajuchatishaya ama. Micuanaja ducuta inime jidamaque cuinanayaratu cajuchatishaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tume tuque ecuana tura mepehua cuanara jipeticuare. —¿Bahuedyami fariseo cuana mira quisarati jadya ayaju cahuaitiyaque? —jadya tuque ecuana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—Ecue Etata barepajuja ama cuanaque tuna pana aputashatana jubuque, acui tirita mutsu eau bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Nebacaume tunaja quisarati. Arepa tuna Yusuja quisarati pana adeba ama aya ama bucha tunajatu peya cuana bahuityacara aya. Shuhuique ecatsedya jutidya ecaaquerenitiu buchique tuna. Shuhuira ni peya shuhuique eaquereniu, betadya tatse caniju epacacadiruu. Tumebae cuitadya tuna; yanacana cuita tuna peya cuana Yusu adebamerecara juya. Tunara, ni peyara jadyatu Yusu adebabuque ama, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jadya ayajutu Pedrora Jesús jipetitsu isaraticuare. —Arepa ecuanaja cacuatsashati eque ai arata baecuaque aniya ama bucha, mira bacue ecuana cuejahua ai araya tsehuepa ecuana cajuchatiya ama jadya. Pana cueja ecuana acue, —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—Arepa micuana eatsehue juneniya ama bucha, tuque micuana adebaya ama jari micuana era eje buchique bahuityacara ayaque. Ni ejeque earaquira micuana cajuchatishaya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Earaqui tu ecuanaja ecuita casatura ishuquedya jutidya. Dutya earaqui ecuatsa eque nubiyaquetu ecare canijudya jutidya judiruya. Tuhuaquedyatu cuinanaya. ");
INSERT INTO cavNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Educu juquetu ecuitaja juetiya cajuchati ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tuhuaquedyatu riya cuanaque jidama cuanaque, bijiseri, au jadya cuanaque juetiya: jidama inime tupucara cuanaque, quiyeticaraque, peya tsehue ecaquemitique jaraquerecaraque, chiri jucaraque, pusha pusha jucaraque, quijillahuanaticaraque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Dutya riya cuanaratu ecuita cajuchatishaya. Yusuratu asicabaya riya cuanaque. Araaraya ni micuana emetucu cuana cutsatimaque fariseo cuana cutsatiya bucha, jadya cuana tsehue micuana cajuchatiya ama ni riya piji buchique, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesústu cuanucacuare tuhuaque. Tumetu cuacuare Tiro, Sidón jadya queja amaca. ");
INSERT INTO cavNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Epuna israelitara amatu jipeticuare. Tumeque epunatu jucuare israelita ama cuana eque ejuracanaque ecuanaja baba cuana Canaánju anidiruma jariju anicuareque. Jipetsu tujatu quiquecuare: —Ique Cuatsashaquique, midyami David eque ejuracanaque. Nerecabacue ique. Ijehuecuinacue ijahua cuana ecue ebacujuna juque, —jadyatu epunara aticuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Isaraya ama buchatu Jesús diruajecuaredya jutidya. Epuna bacue quiqueajecuaredya jutidya. Bacacarama ecuana acuare. —Cuejacue tumeque epuna. Padiru. Ecuana tupujutu quiquebeya. Bacahuillahua tuque ecuana amena, —jadya tuque ecuana Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—Ecuanaja ata israelita cuana tuna uhuisha cuji eju buchique. Yusura ique cuadishahua tuna tsahua ishu, israelita ama cuanaque tsahua ishu ama, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Epuna bacue Jesúsja yacuaju junatitsu nuyunaticuare. —Tsahuacue ique, Ique Cuatsashaquique, —jadya tujatu anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—Adebayami quisarati: “Jidama tu ebacua cuana earaqui secatsu chapa cuana tyau” jadique, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Jejee, Ique Cuatsashaquique. Jadya ama buchatu chapa cuanara arayadya enimetsequera araarayaque mesa juque pacacashayaque, —jadyatu epunara acuare. (Jadya quisarati tsehue tujatu acuare. Tumebaedyatu israelita ama cuanaque Jesús queja ecatyatiudya.) ");
INSERT INTO cavNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—Yuneri cuitadya tuquemi pana ejene aya era micue bacujuna juque ijahua cuana eijehuecuinauque. Ayadya tuque era mira bacahua eque, —jadyatu Jesúsra acuare. Tumeque ura cuitadyatu ebacujunaque quijahuatijacacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesústu tuhuaque dirunucatsu cueticuare Galilea bei jiruru eque. Tuequedyatu tsuracuare emataju. Tsuratsutu tuhuadya anibutecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jetiamatu ecuita cuana tuaqueja juticuare. Dujucuare tuna aje jidama cuanaque, shuhui cuanaque, ebi jidama cuanaque, quisarati baecua cuanaque, umada peya ujeje tsehue cuanaque jadya. Jesús anibutehua peque tunajatu iyabareticuare. Chachanecuaredya tujatu ecana. ");
INSERT INTO cavNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Quisarati baecua cuanaque tuna quisaraticuare. Ebi jidama cuanaquetu chacha jucuare. Ajebaecua cuanaque tuna ajecuare. Shuhui cuanaque tuna capetaticuare. Dutya riya cuanaque baatsutu ecuita cuana anajacatacuare. Pureama tuna Yusu atibunecuare: —Dyaque casada, jida jadya taa Yusu, Yusu israelita cuanara muiyaque, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tume ecuana Jesúsra ihuaracuare isara ishu: —Nerecada taa rique ecuita cuana arama baatsu baya, riya barepa tibene equeque taa rena ique ijacabaca juyaque. Amena taa renajari aijama ara ishuque. Cuadishacarama taa rena aramaque aya tunaja etare cuanaju. Edijiju taa rena emajudiruu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—¿Eje bucha dadie jatsu tuque ecuana eau earaqui ecuita jetiamaja ishu, rehua ni ejeque buchique anitayaju ama? —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesúsra ecuana bacaduracuare: —¿Eje uma pan micuanaja aniya? —Pacarucu piji camadya, eje uma cuana piji jae, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tuequedya tujatu iyabutyamerecuare ecuita cuana. ");
INSERT INTO cavNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yahuaju iyabutyameretsu tujatu inacuare pacarucu pan, jae piji jadya. —Yusurupai mique aya, Tata, mira ecuana riyaque earaqui tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai aatsu, tujatu pan cuesibarecuare. Cuesibaretsu umanashatsu tura ecuana tyabarecuare. Tudya tuque ecuana tyabarecuare ecuita cuana. ");
INSERT INTO cavNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Dutya tuna araaracuare jequeya tupu. Araara amena juatsu tuque ecuana jequeshabarecuare pacarucu jiti arida cuanaque pan cuesi cuana anidadihua tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jetieque ama tuna araaracuare. Pushi mil deca cuana tuna araaracuare, epuna cuana, ebacua cuana jadya piyebamaque. ");
INSERT INTO cavNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jadya juatsu tujatu ecuita cuana amena isaracuare. Tuna isaratsutu anibutedirucuare cuabaju, Magadán queja amaca diru ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo cuanara, saduceo cuanara jadyaratu baticuare Jesús. Sarecuare tunajatu eje bucha eque jidama aishu. Tume tunajatu Jesús acuare: —Acue ecuanaja yatucaju ai bapeque inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu, —jadya tunajatu acuare, arepa tuna tuque Yusu equeque junahuaque ejenecarama acuare ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesusratu adebacuaredya tunara inime tupuyaque. Jadya tibu tujatu ecana acuare: —Barepa asicada cuanaque baatsu tuque micuana pana adeba abahue eje bucha huecaca juyaque, nei juya, juyaque ama jadique. Chinequeja piji ni jacua pude juya, tume micuana jubahue “Metajudyatu jida juya huecaca”. Micuanara quisarati ahua bae cuitadyatu juya. ");
INSERT INTO cavNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Apudajudya barepa jidama nei jucara juyaju, huani ducu ijeti riya piji baatsu micuana jubahue: “Iyacuari nei juya” jadya. Tumetu micuanara quisarati ahua equedya juya. Yusuratu jetiama ahua ique tuaquejaque junahuaque adebamere ishuque. Micuanaradya jutidyatu adebahua ama, arepa micuana huecaca cuana eje buchique adeba bahue ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Micuana micuana jidama inime cadujutiya cuanaque. Yusu micuana iyuhueda bajacahua, ni micuana tuja yana equedya juya. “Acue ai inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu”, jadya micuanara aya. Aya ama tuque era, ni aidya jutidya. Jonás jucuareque cuita camadya micuana huecashaya, —jadya tujatu ecana acuare. Jadya isarae aatsu tujatu ecana shanaquenacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nime aputacuare ecuana bei yueque macare cuayaque pan cadujuti ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tuhua ecuana Jesúsra acuare: —Necanaruticue bacue fariseo cuanaja, saduceo cuanaja jadya levadura tsehue, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ecuanaratu adebacuare ama eje buchique tura ecuana jadya ayaque. Jadya ecuana ecuana cama quisaraticuare: —Ecuana pan nime aputahua baatsu tura ecuana jadya quisarati tsehue aya, —jadya ecuana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesusratu adebacuaredya ecuanara inime tupuyaque. —¿Eje bucha juatsu micuana pan beishu nime aputahuaju era nereda aya bucha cabatiya? ¡Ejeneya ama tuque micuana era micuanaja ai aijama juyaque etyauque! ");
INSERT INTO cavNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¡Adebaya ama jari cuitadya tuque micuana era micuanara ai sareyaque etyauque! Pishica pan era pishica mil ecuitaja ishu tupu amerechine patya ¿eje uma jiti tuque micuana jequeshachine pan arabishahua cuana tsehue? ¿Adebaya ama jatsu micuanara? ");
INSERT INTO cavNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Pacarucu pan umanashatsu era pushi mil ecuita aramerechineque, ¿eje uma jiti tuque micuana jequeshachine anidadichine cuana tsehue? ¿Nime aputachine cuitadya ni taa micuana era jadya achineque? ");
INSERT INTO cavNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Era adebaya ama eje bucha juatsu micuanara levadura jadya ayaque bape cueyane jutidya ayaque. Yudijidya tuque quisarati anucaya. Necanaruticue bacue fariseo cuanaja, saduceo cuanaja levadura tsehue, —jadya ecuana Jesúsra anucacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Chamacama ecuana adebacuare fariseo cuanara, saduceo cuanara jadya bahuityayaque jadya tura ayaque. “Levadura tsehue canarutitaquique ama”, tujatu jadya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesústu cuacuare Cesarea Filipo epu ebari japadama anitaya cuana queja. Cuayara tura ecuana bacaduranaticuare: —¿Eje buchatu ecuita cuanara ecue ishu inime tupuya? ");
INSERT INTO cavNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ecuanaratu quemitsacuare: —Umae cuanarami aya Juan Ecuita Cuana Utsaquique emajuque enetitsuranucaque jadya. Peya cuanarami Elías jadya aya. Peya cuanarami Jeremías jadya aya. Peya cuanarami ejeque cuana Yusu equeque quisarati cuejaquique baba cuana anicuare patyaque jadya aya, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—¿Micuanara bacue, ique ai jadya aya? —jadya ecuana Jesúsra bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—Miquemi Mesías, Yusuja Emepeque. Miquemi Yusu Chachaja Ebacuaque, —jadyatu Simón Pedrora Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—Jadidya ique. Yusura jida amerecue, Simón Jonásja ebacuaque. Ni ejeque maju aquira amami adebamerehua riyaque. Ecue Etata barepajurami adebamerehua. ");
INSERT INTO cavNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Miquemi Pedro. (Micue ebacani tu “Tumu aija bucucushataquimaque” jadique). Mira quisarati ahuarami ejitaju amerehua mique eaqueja catyatihuaque. Cuadishaya mique ecue quisarati cueja ishu, ecue cuanaque ique dyaque jida adebamere ishu. Aija aputashataqui ama, ni yuamaturataqui amatu eaqueja catyatiya cuanaque. Ni ejeque Satanásja ecuadishara tuna eyuamaturau ama. ");
INSERT INTO cavNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Erami casa tyaya Yusura naruyaju judiru ishuque cueja ishu. Era etsecue pacasha ishu yahue etyau bucha tuque. Mira riyaque yahuaju “Jucha metse” jadya ayaquetu Yusura barepaju “Jucha metse” jadidya abuque. Mira riyaque yahuaju “Jucha metse ama” jadya ayaquetu Yusura barepaju “Jucha metse” jadya amadya abuque —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Tume ecuana Jesúsra acuare: —Necuejaume jari ni ejeque buchique ique Mesiasque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tumeque huecaca equetu Jesús cacuejatitibunecuare ecuana tura mepehua cuana queja tuque eje bucha judadiyaque. —Eje tupu cuaya Jerusalénju. Emuiba cuanara, pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadya dyaque nerecaturadadiya. Iyemeredadiya tunara ique. Quimisha huecaca juatsu netitsuranucaya, —jadya tura ecuana cuejatibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pedroratu ejenecuare ama Yusuja Emepeque jadya ejudadiuque. Jadya tibudya tujatu peya queja ihuara acuare. Ecuana peya queja jacameretsu piji tujatu Jesús nereda atibunecuare: —Jadya quisarati aume. Yusura iyuhue batsacue mique, mira cuejahua bae judadi ishu ama, Ecuana Cuatsashaquique. ¡Arequemi jadya ejudadiu ama! —jadyatu Pedrora Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesusratu huareretsu Pedro jadya acuare: —Satanástu mique eque quisaratiya. Maju aqui cuana jaque jutidya tuquemi inime tupuya, Yusu jaque ama. Bacacarama tuque aya mique eque Satanás ama amara cuejayaque, —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tume tura ecuana tura mepehua cuanaque isaracuare: —Micuana eatsehue junenicara juyaque juatsu, era cuatsashaya eque neanicue, micuanaja biji eque juneniyaque nime aputatsu, arepa micuana canerecati, maju jadya jutaqui ama bucha, curusuju etata ejuu bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Micuana ni catehuatiya eaqueja ecatyatique eiyetauju, ejetsunue ama micuana anibuque. Tume micuana majubuque ni eje tupu Yusu queja judiru ishu ama. Micuana ni eaqueja catyatihua baatsu iyetaya, Yusu tsehue micuana anisiribuque, arepa micuanaja ecuita ririya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ecuita ni ijahuaja etiquiju judirubuque, ni aishu buchique tujatu jida juhua ama riyaque yahuaju tuja dutya ai anihuaque. Ni aishu buchiquetu jida ama dyaque chipiruda juishu, majudaditsu dutyadya shanadadiya tibu. Aijamatu ni ai buchique micuanara maju ishu ama etsujetyauque. ");
INSERT INTO cavNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ejeque huecaca IQUE ECUITA junanucabuque. Barepaju Yusu tsahuaqui cuanara tajibebuque. Ique junanucayajutu dutyara babuque ecue Etataja casa. Tsujetyanabuque tuna peadya peadya eje bucha anie tuna juhua eque. Era amereya eque juya cuanaque tuna jida tsehue babuque. Era amereya eque juya ama cuanaque tuna jidama abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Umae micuana rehuaque majuhuishaya ama, dutya era ecue casa tsehue narutibuneyaque badadiya tupu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Shucuta huecaca juatsutu Jesúsra dujucuare emata barudaju Pedro, Santiago, Juan jadya. (Juan tu Santiago tsehuequique jucuare). ");
INSERT INTO cavNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tuhuadyatu tunara petayaju cabapeticuare. Tuja ebutsequinitu tiquida jucuare, ijeti bucha. Tuja unatu pajada, huecada dyaque tiquida jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Masadaque amatu Moisés yanume, Elías yanume jadya ejitaju jucuare. Tume tatse Jesús tsehue quisaratinacuare. Tuatsehue cuacuare cuanaratu bacacuare quisaratiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jadya baatsutu Pedrora Jesús acuare: —Ecuana Cuatsashaquique, dyaque jida taa ecuana rehua. Micue jadya inimeque juatsu taa ecuana eau quimisha erere, peadya micue ishu, peya Moisésja ishu, peya bacue Eliasja ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro quisaratiya jarijudya tuna huani tiquidara dunutillacuare. Tume tunajatu bacacuare huani ducuque Yusu jadya quisaratiyaju: —Riyaque rique ecue Ebacua dyaque iyuhuedaque. Dyaque pureama ishu rique aya. Nebacajacaume. Eje bucha tura cuejaya eque nejucue, —jadya tuna Yusura acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jesús tsehue cuahua cuanaque tuna jadya bacatsu dyaque bajida jucuare. Jadya tibu tunajatu chichucata juatsu remetsu ebutsequini tsehue yahua tseracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tume tuna Jesúsra jipetitsu isaraticuare: —Nenetitsuracue. Bajida nejuume. ");
INSERT INTO cavNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Bajiyunucatsu tunajatu banucacuare ama Moisés, Elías jadya, Jesús camadya. ");
INSERT INTO cavNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Emata juque buteajeyara tuna Jesúsra cuatsashacuare: —Necuejahuishaume jari ni ejeque buchique micuanara eje bucha bahuaque. IQUE ECUITA majuhuaque, chacha netitsuranucahuaju piisi ecana necuejacue, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tuatsehue cuahua cuanaratu Jesús bacaduracuare: —¿Eje bucha juatsutu cacuatsashati bahuityaqui cuanara Eliaspa icuene junabuque, Mesías junama jariju, jadya aya? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tura tuna quemitsacuare: —Tunara bahuityayaque tu yuneridya. Eliastu icuene junabuque. Turadyatu dutya bajejenabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pusha amadya micuana cuejaya. Elías buchiquetu amena junahuadya. Dutya jujerira tunajatu adebacuare ama. Eijacabacauque tunajatu ijahue ijahue acuare, tunara acara aya eque. Ique tunara tumebaedya abuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tura jadya quisarati ayajutu tuatsehue cuahua cuanaja inime juticuare Juan Ecuita Cuana Utsaquiquedya Mesías junamaju junataqui jucuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Emata juque tuna butecuare. Jetiama ecuitara ihuayajutu Jesús judirucuare. Jesús, quimisha tuatsehue cuahua cuanaque jadya tuna ecuita cuanara ihuayaju judirucuare. Tumetu peadya ecuitara Jesús jipeticuare. Tumetu chichucata jucuare tuja yacuaju tuaqueja canerecatiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ique Cuatsashaquique, nerecabacue ecue ebacua. Manu tuque ecue juya. Dyaque nerecadatu juya. Eje uma rihuitu eju etiquiju, jadya ama juatsu ena dedaju. ");
INSERT INTO cavNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Riya behua mira mepehua cuana queja ijahua cuana ijehuecuinamere ishu datse. Ijehuecuinataqui ama tunajatu bahua, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jadya bacatsutu Jesúsra acuare tuhua jucuare cuanaque: —¡Micuana micuana quejeneti baecua, cuejataqui ama jadya! Arepa micuana era ayaju bahua ama bucha, adebaya ama jaridya tuque micuana Yusuja casa. ¿Eje tupu cuita micuana eiduu? Nebecue requeja ebacua piji —jadya tuna Jesúsra acuare tuhua jucuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Behuajutu Jesúsra nereda acuare ijahua ebacua piji quijahuatishaquique: —Cuinanacue riyaque ebacua piji quejaque, —jadya tujatu acuare ijahua. Nereda aatsu tujatu cuinanashacuare. Tumeque ura cuitadyatu ebacua piji quijahuatijacacuare, ni eje tupu jadya quijahuatinuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jadya juatsu tuque ecuana Jesús tsehue camadya cabatitsu bacaduracuare: —¿Eje bucha juatsu tuque ecuana ijehuecuinataqui ama bahua tumeque ijahua ebacua piji yuamaturaquique? —jadya tuque ecuana acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—Ijehuecuinataqui ama tuque micuana tumeque ijahua bahua, era ijahua cuana ijehuecuina ishuque casa tyahuaque ejeneneriya ama tibu. Micuanara ni ejenequena juhua, paju riya piji cuana; ni aidya jutidya tuque micuana ataquima ama ebau. Emata ni micuana eau: “Netisicuacue”, enetisicuaudya tuque, era casa tyahuaque ejenehuaque juatsu. Mostaza caca achaacha piji; jadya ama buchatu baruda mostaza acui daneya. Tumebaedya riya piji cuana ni micuanaja eaniu quejeneti, eaudya tuque micuana ai ataquima buchique. ");
INSERT INTO cavNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Micuanara ni Yusu bacaya tuja riyaque casa tyaishu, arama ni micuana equibetiu, eaudya tuque micuana riyaque. Aijamatu peya eje bucha eque aishuque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea yahua queja dutya juneni juyaque jari ecuana Jesúsra cueja beta acuare tuque eje bucha judadiyaque. —Ejera cuana tsetatsu inameredadiya IQUE ECUITA. Inameretsu tura ique iyecara juya cuana queja iyemeredadiyadya. ");
INSERT INTO cavNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Iyedadiya tunara ique. Iyehuaju quimisha huecaca juatsu netitsuranucaya, —jadyatu cacuejaticuare. Jesús iyetanadadiyaque cacuejatiyaju bacatsu ecuana dyaque capeya inimeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesús ecuana tsehue Capernaumju juetihuajutu Yusuja etareju mere juya cuanaque jecuare. Tuna tuna chipiru ecuanaja tyabahueque Yusuja etareju ai quemi, tsujetya jadya aishuque sitaqui cuanaque jucuare. Pedro jipetsu tunajatu bacaduracuare: —¿Tsujetyayadyatu chipiru tsehue Micuana Bahuityaquira Yusuja etareju tsujetya ishuque? ");
INSERT INTO cavNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedrora tuna quemitsacuare: —Jejee, tsujetyayadya tuja tuque, —jadyatu Pedro jucuare. Pedrotu Jesús etareju netiyaju nubiticuare. Nubitihuajutu Pedroja isarama jariju cuitadya Jesúsra isaratsacuare: —Riyaque yahuaju ecuatsashaqui cuanara peya yahuaju cuanaque ijahue aatsu ¿eje cuanaque tunajatu chipiru bacaya tuna naruquija ishu? ¿Tunaja yahuajuquedya jutidya tuna bacaya, tunara catiju ijahue ahuaque ni taa? ¿Eje buchami adebaya, Pedro? ");
INSERT INTO cavNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Catiju ijahue ahuaquedya, —jadyatu Pedrora acuare. Jesústu quisaratinucacuare: —Tuyudyami juya. Tunaja yahuaju cuanajatu tsujetyataqui ama ni riya piji buchique. Jutaquiju, ique Yusuja Ebacuaque juya tibu, ecuetu tsujetyataqui amadya tunara Yusuja etareju ishuque ique tsujebacayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jadya ama bucha tuque tsujetyayadya, tuna ecahuaitiu tibu. Cuacue beiju. Huica mutya juticue. Tinutinu metse juyaquedya acue. Jaeja ecuatsajudya tuquemi chipiru dadiya. Tumeque chipiru tu tupu tunara ique tsujebacayaque tsujetya ishu, tumebaedya micue. Jae juque quemitsu, dujucue Yusuja etareju. Tsujetyaticue yatseja tunara tsujebacayaque, —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Tume patya tuque ecuana Jesúsra mepehua cuanara jipetitsu bacaduracuare: —¿Ejeque ecuana dyaque inime metseque jubuque, mique enaruqui judadihuaju ecuana dyadi mique tsahuaqui juatsu? —jadya tuque ecuana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tume tujatu ihuaracuare ebacua piji tuhua netiya baatsu. Ihuaratsu tujatu nityacuare ecuana patya. ");
INSERT INTO cavNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—Riyaque micuana era cuejayaque ri yunerique. Peadya peadya micuana micuana taca casumiti jutaqui ama. Inime metseque ama bucha micuana jutaqui, riyaque ebacua piji bucha. Jadya juyaque juatsu camadya micuana judirubuque eju Yusura naruyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ejeque dutyaja jetiedyaque cabatiyaque, riyaque ebacua piji bucha dyaque jetiedyaque, tumequetu dyaque emui jubuque Yusura dutya naruyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Micuanarani ecue cuanaque jida tsehue baya, arepa riyaque ebacua piji bucha paju ama bucha, idya datse micuanara jida tsehue baya, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesúsra ecuana bahuityanucacuare: —Ejera riyaque ebacua piji bucha cuanaque cajuchatishayaquetu Yusura dyaque nerecaturabuque. Dyaque jidatu majutaqui juhua ejeque cajuchatishamaquedya. Dyaque jidatu peya cajuchatishaquique tumu ebari epitiju risitsu bei dyaque dedaju ijehuetaqui juhua. ");
INSERT INTO cavNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dutyatu riyaque yahuaju cuanaque nerecada juya, peya eje buchadya cajuchatishacara jadya juya cuanaque aniya tibu. Majuma jari tuputu ecuita cajuchaticara jujacaya ama. ¡Dyaquetu nerecada jubuque peya eje buchadya cajuchatishacara juya cuanaque! ");
INSERT INTO cavNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Emetucu tsehue ni micuana cajuchaticara juya, necatubuticue cajuchatimaquedya, jidamaque acara ayaque micuanaja aishu ama. Cuacara ni micuana juya eju micuana cuataqui amaju, cajuchatimaquedya ehuachi necatubuticue eju micuana cuacara juyaju cuaishu ama. Nejacacue cajuchaticaraque. Dyaque jidadyatu bipidya, rudurudu Yusu queja judirutaqui, bibeta, huachi beta jadya ijahuaja etiquiju enubidiruuque, etiqui ticu baecuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Micuanaja petataquimaque ni micuana petacara aya, necahuicaticue yatuca cajuchatimaquedya, jidamaque peta ishu ama. Nejacacue cajuchaticaraque. Dyaque jidatu Yusu queja judirutaqui atuca pidya camadya, ijahuaja etiquiju atuca beta enubidiruuque, etiqui ticu baecuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nebijidamaduraume eaqueja ecatyatique ai ama jipenee juya cuanaque. Etata barepajuquetu bahue tuna ai juyaque. Barepa juque quisarati bepuji cuanaquetu tuna tsahuaqui cuanaque Yusuja yacua juque netisicuayaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ique riyaque yahuaju junahua Yusu adeba baecua cuanaque, uhuisha cuji eju bucha cuanaque inajacamerera. ");
INSERT INTO cavNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Cuejaya micuana riyaque cuatsabiji piji micuana pana huecasha aishu. Peadya ecuitaja cien uhuisha eaniu. Peadya tuja cuji ejuu. ¿Eje buchatu tumeque ecuita ejuu? Eshanau jari di taa tujatu puscurucu tunca puscurucu earacana taracaju. Eishautu eju aija eje bucha ataqui amaju. Jadya shanatsutu pereu amadya ecuau uhuisha cuji ejuque sarera. ");
INSERT INTO cavNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Esareudya tujatu dadiya tupu. Daditsutu pureama eau dadihuaque, aputama cuanaque pureama eau bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Uhuisha naruquira ni peadya uhuisha aputashacarama eau bucha, tumebaedya micuanaja Tata barepajura micuana ijahuaja etiquiju nudyacarama aya, ni ejeque eaqueja ecatyatique ai ama jipenee juya cuanaque, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesúsra ecuana bahuityanucacuare: —Ejera ni micuana jidama aya, tuta tacaju neisaraticue. Nehuecashacue tuque jidama juhuaque. Bacaya ni tura micuana micuanara cuejayaju, cacuejatiyadyatu micuana jidama ahuaque, tume tura micuana jidadya carenenucaya. ");
INSERT INTO cavNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Tura ni micuana bacacarama aya, adebacarama ni tu aya tuque cajuchatihuaque, necuejacue peadya, jadya ama juatsu beta eaqueja ecatyatique, cajuchatihuaque isarara micuana tsehue cuaishu. Micuana tsehue inime bajejera cuaya ecatsera neredadya paati. Tatseradya paba micuana tumeque inime bajeje ishu cacasatihuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tumeque ecuitara ni bacacarama aya micuana tsehue cuayaque ecatse, tume necuejacue ecue cuanaque casitatihuaju. Dutya ecana necuejacue. Tunara cajuchatihuaque paihuara, peya cuana tsehue casitatishatsu dutyaja yacuaju nereda aishu. Tura ni bacacarama cuitadya cuejayaque aya, tume amena bijidamadurayaque ebau bucha bae neacue. Yusu adeba baecua cuanaque, jadya ama juatsu enaruquija ishu chipiru sitaqui cuana bucha bae neacue ecajuchatique inime cacuareticarama juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Micuanara riyaque yahuaju ‘Jucha metse’ jadya ayaquetu Yusura barepaju ‘Jucha metse’ jadidya aya. Micuanara riyaque yahuaju ‘Jucha metse ama’ jadya ayaquetu Yusura barepaju ‘Jucha metse’ jadya amadya aya. ");
INSERT INTO cavNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Micuana riyaque yahuaju aniya cuanaque ni micuana casitatiya inime jidamaque bajeje ishu paju beta piji, betaja tupu ni metseja inime Yusu bacayaque, tyadadiyadya tura metse. ");
INSERT INTO cavNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ejudya jutidya micuana ecasitatiu beta, jadya ama juatsu quimisha eatsehue quisarati ishu, ique tuhuadya micuana tsehue, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jadya bacatsutu Pedrora jipetitsu bacaduracuare: —Ejera ique jidama ajacaya amaju, ¿eje uma nerecaba tuque eau tume ique jidama aquique? ¿Pacarucu nerecaba ni taa tu tupudya? —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusratu quemitsacuare: —¡Aijama! ¡Tupu ama tuque! Tura jidama ayaju nerecabajacaumedya; pushi cientos puscurucu tunca nerecabadya acue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jesúsra ecuana bahuityanucacuare: —Cuejaya micuana riyaque cuatsabiji Yusura dutya naruyaju eje buchique micuana bahue juishu. Jucuaretu ecuari. Tumeque ecuaritu tuque merequi cuanaja manu bajeje jucara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tuque jadya juyaju tunajatu ecana becuare tuaqueja peadya beu, peadya beu. Becuare tuna tuaqueja manuqui nerique. Eje bucha piyebatilla tupu ama jujeri tujatu manu tuatsehue anicuare. Eje uma millones tujatu manu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tumeque mere pujijatu aijama chipiru jucuare tuja manu tsujetyatilla ishu. Tura ai tsehue tsujetyataqui ama bayajutu ecuarira acuare: “Catyati mique aya, micue huane, micue bacua cuana jadya tsehue. Casada micuana mere jutaqui. Dutya chipiru micuanara inayaque micuanara tyaajeya dutya micuanara manu tsujetyatillaya tupu”, jadyatu ecuarira acuare ecuita manu metseque. ");
INSERT INTO cavNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jadya ayajutu ecuita manuquique tuja yacuaju chichucata juatsu canerecaticuare: “Nerecabacue ique, Ique Cuatsashaquique. Cahuaitiume. Ihuacue jari. Tsujetyatillayadya mique era”, jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ecuariratu nerecabatsu tuja manu apupashacuare. Apupashatsu tujatu tuaqueja manuqui juhua bucha nime ama bacuare. Pana inajaca tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Tumeque ecuita ecuarija yacua juque cuinanatsu tujatu tsurutsacuare peya tuja ecare, tuaqueja eje uma piji manu aniyaque. Erumuju inatsatsu tujatu rumupuditsu iyecara acuare. ‘Iyacua cuita tsujetyacue micue manu eaqueja aniyaque’ jadyatu ecuita ecuarira manu apupashahuara tuja ecare atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tuja ecaretu tuja yacuaju chichucata juatsu canerecaticuare tuaqueja: ‘Ihuabacanucacue jari taa ique. Tsujetyayadya taa mique era’ jadyatu manuquira acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tura bacue ihuacarama acuare. Inameretsu tujatu etare apudaju ishamerecuare, tura manu piji tsujetyaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Etare apudaju nubihuaja ata cuanatu peya inime cuita jucuare. Jadya tibu tunajatu ecuari cuejaticuare, tura peya jadya ahua baatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Tumetu ecuarira tumeque ura cuitadya ihuaramerecuare tura manu apupashahuaque. Ihuaratsutu ecuarira acuare: ‘¡Miquemi dyaque jidama! ¡Cuejataquima mique! Era tuque micue manu jetieque ama apupashahua mique eaqueja canerecatiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jida tsehue tuquemi micue ecare nerecabataqui ahua, era mique nerecabahua bucha’ jadyatu ecuarira acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Dyaque cuita cahuaititsutu ecuarira etare apudaju ishamerecuare. Eterinetiya cuanaque naruqui cuanaque tujatu acuare: ‘Ijahue ijahuemeree neacue tura dutya tsujetyaya tupu’. Jadyatu jucuare tuja ecare manu apupashacarama acuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Jadidya micuana ecue Etata barepajura abuque micuanara yuneri cuitadya micuana jidama aquique nerecabayaque ama juatsu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jadique cueja amena aatsutu Jesús dirucuare Galilea yahua juque. Judea yahuajutu cuacuare Jordán cueri yueque macare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jetiama ecuitaratu tupujudya acuare. Jesusratu chachanecuare ujejeda cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tumetu umae fariseo cuanara jipeticuare. Quisaratishatsu tunajatu pusha pusha tsehue jidama amerecara datse acuare. Bacaduraticuare tunaja tuque: —¿Ecuanaja ehuane amena bijidama baatsu, ijehuetaquidya tuque ecuanaja? —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—Eisara micuanaja Yusuja quisarati. Adebayadya tuque micuanara tuhua eje bucha ehueneque. Jadya tu ehuene: “Yusuratu yuequedyadya iyacuare deca, epuna jadya carequi juishu”. ");
INSERT INTO cavNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tumebaedya tu ehuene: “Jadya tibudyatu decaja jacataqui etataque, ecuaque, carequi juatsu. Caquemitihuaju tatse Yusura baya peadya camadya bucha”. ");
INSERT INTO cavNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jadya tibu tatse amena beta ama, peadya camadya. Yusura cuitadya casitatishahua tibu, tujatu ecatse peadya camadya bucha baya. Jadya tibudya tatse ni ejeque ecuitaja buchique cajacatishataqui ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tumetu fariseo cuanara bacaduranucacuare: —Miquemi bahuedya Moisésra cuatsashahuaque. “Ijehuecara ni micuana aya micuanaja huane, neinamerecue quirica eje bucha juatsu micuanara ijehueyaque cuejayaque. Inameretsu micuanaja huane neijehuecue”, jadya tujatu huenecuare béru. ¿Eje bucha juatsu jatsutu Moisésra huenecuare ehuaneque tsehue cajacatitaquique, cajacatitaquique ama inime aniya ama bucha? —jadya tunajatu bacaduracuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—Moisesratu adebacuaredya Yusuja cuanaque ama Yusuja biji eque ama anicara juyaque, tunaja biji equedya jutidya. Jadya tibudya tujatu huenecuare ecaquemitique cajacatitaquique. Jadya ama buchatu Yusura yuequedyadya inime iyahua ecaquemitique cajacati ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Era micuana cuejaya. Eje bucha juatsu cuita camadya micuanaja huane ijehuetaquique, micuanaja huane peya tsehue jarayaju daditsu cuta camadya. Micuanarar ani micuanaja huane ijehueya eje bucha juatsu pijidya jutidya, jadya juatsu micuana peya tsehue caquemitiya, Yusu tuque micuana cahuaitishaya. Tuja yatucaju tuque micuaanaja icueneque epuna huane neri jaridya, ai tupujuque ama, —jadyatu Jesúsra fariseo cuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ecuana tura mepehua cuanara tuque ecuana acuare: —Caquemititsu eje bucha cajacatitaquima juya tibu, jutaquiju taa ecuana caquemitima siri didya jutaqui, —jadya tuque ecuana acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesúsra ecuana quemitsacuare: —Dutya ama micuana caquemitima siri eaniu. Yusura jadya ani ishu casa tyahuaque cuita camadyatu jadya anie ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bape bape inime equetu peadya peadya deca cuana huanema. Umaetu ai jidamaquedya cuinanaya. Jadya juatsudya tuna cabacuati baecua. Jadya tibu tuna caquemitiya ama. Peya cuana bacue cabacuatiya ama, peyara ujeda eje bucha ahuaju. Peya cuana bacue carequi jucarama juya, Yusu mere juyaju aija buchique pere ishu ama. Caquemitima paani Yusura jadya ani ishu casa tyahua cuanaque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tumetu umae ebacua cuana etata cuanaquera Jesús queja dujubarecuare. —Emetucu micue iyacue ebacua cuanaja iyuca dyaque. Bacacue ecana Yusu queja, tuja ecana jida naru ishu, —jadya tunajatu Jesús acuare. Ecuanara tuna jadya baatsu, nereda jutidya atsabarecuare ebacua cuana tsehue cuacuare cuanaque: —Nepereume Jesús, —jadya tuque ecuana ecana atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ecuana jadya quisaratiyaju ecuana Jesúsra acuare: —Pajedya ebacua cuana eaqueja. Necuadishaume ecana eaquejaque. Esiri cuanaque camadya ama, tumebaedya tuna dyadi tuna Yusu jaquedya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tuna dyaque ebi rirutsu tujatu peadya peadyaja iyuca dyaque emetucu iyabarecuare, Yusu tuna tsehue jadique adeba ishu. Jadya amena au jadya juatsutu tuhuaque dirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Peya huecacatu Jesús ecuitara batitsu bacaduraticuare: —Jidaque Ebahuityaquique, ¿ai mere tuque jidaque eau, Yusu queja judiru ishu ni eje tupu tuque jaca ishu ama? —jadya tujatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusratu quemitsacuare: —¿Adebayadyami eje buchique quisarati ahuaque? ¿Eje bucha juatsu mira “Jidaque Ebahuityaquique” jadya aya? Yusu peadya camadya tu jidaque. Jutaquiju, Yusu queja judirucara juatsu, Yusura cuatsashaya eque jucue, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Ejeque cacuatsashati cuana eque jutaqui? —jadyatu ecuitara bacaduracuare. —Quiyeti puji juume. Peyaja ehuaneque micuique bucha aniquere aume. Chiri juume. Ni ejeque buchique pusha pusha aume. ");
INSERT INTO cavNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Muibacue mique baquique, mique susuquique jadya. Iyuhue tsehue bacue peya cuana. Mique cuitadya iyuhueda cabatiya bucha, iyuhuee peya bacue, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Dutya riya cuanaque cacuatsashati cuana tuque muibacuare nanada equeradya. ¿Ai tuque ecue peya bataqui ama Yusu queja judiru ishu? —jadyatu ecuitara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jadya bacatsutu Jesúsra jadya acuare: —Yusura amerecara aya eque jucara juyaque juatsu, dutya micue aniya cuanaque catyati aticue. Catyati aatsu tyabarecue chipiru nerecada cuanaque. Dutya micue ai catyati aatsu, juetinucacue eaqueja, eatsehue juneni ishu. Eaqueja ni mi ecatyatiu, tume tuque micue eaniu Yusuja cuanaja ishu tuja barepaju aniyaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jadya ayaju bacatsutu ecuita dyaque peya inime dirucuare, tuja dyaque jetiama aniyaque catyati acarama aya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tumeque ecuita yuneridya tuatsehue junenicarama juyaque adebatsu ecuana Jesúsra acuare: —Yuneri cuitadya micuana riyaque cuejaya. Jetiama ai aniya cuanaratu dyaque ibeda, masada baya eaqueja pana catyati juishu, Yusura dutya naruyaju judirutaqui juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yudijidya cuejanuca micuana aya. Cahuayutu etsucuija cani eque eje bucha cuetitaqui ama. Tumebaedya tuna tunaja ai aniyara eje bucha judirutaqui ama amereya Yusu queja, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jadya bacatsu tuque ecuana bape bacacuare. —Chipiruqui cuanaque ni Satanás quejaque quinajacameretitaqui ama cabatiya, ¿ejeque jatsutu tuaquejaque equinajacameretiu? —jadya ecuana cabacaduratibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesúsra ecuana petacuare. Petatsu tura ecuana quemitsacuare: —Ecuita ni tu tuta taca eje bucha quinajacameretie juma Satanás quejaque. Yusura peadya camadya tuna einjacamereu. Yusuja ishutu aijama ai ataquimaque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jadya bacatsutu Pedrora acuare: —Ecuana ecuana dutya cashanatihua miatsehue juneni ishu. ¿Ai tuque ecuana inabuque? —jadyatu Pedrora Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Pusha amadya micuana cuejaya. Juetibuquetu huecaca dutya era iyacuaneyaque. Ique huaraji dyaque aridaque jubuque. Ique ecue eaniqui muidaju anibutebuque dutya ecuita peadya peadya eje bucha judadiyaque cueja ishu. Micuana micuana ique muitaya bucha muitaedya jubuque, peadya tunca beta earacana eaniqui cuanaju anibutehuaju. Micuanaratu narubuque peadya tunca beta earacana cuare cuanaque Israel eque ejuracana cuanaque. Peadya peadya micuanaja eaniquijuradya tuque micuana ecana narubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Micuana ni cashanatiya dutya micuanaja ai aniyaque eatsehue juneni ishu, Yusura micuana tyaya dutya micuanara riyaque yahuaju sareyaque. Tura micuana tyaya micuanara sareya tupu dyaquedya jetiama, cien tyau bucha dyaque jetiama. Micuana ni etare cashanatiya, tura micuana tyaya eju ani ishuque. Cashanatiya ni micuana micuana tsehuequique epuna, deca cuana, micuanaja tata, micuanaja cuaa, micuanaja bacua cuana, tura micuana peya cuana queja iyuhue tsehue narumereya tunaja ata neri bucha. Cashanatiya ni micuana micuanaja tee cuana, tura micuana tyaya dutya micuanara ara ishu sareya cuanaque. Micuana majuhuaju tura micuana barepaju tuatsehue anishasiribuque ni eje tupu tuque jaca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iyacua dyaque inime metse cabatiya cuanaque tuna inime metse ama jubuque. Iyacua jetiedya inime metse ama cabatiya cuanaque bacue dyaque inime metse cabatibuque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Bahuityanucacuare ecuana Jesúsra: —Cuejaya micuana riyaque cuatsabiji Yusura dutya naruyaju eje buchique micuana bahue juishu. Anicuaretu ecuita uva tee ebari metseque. Apudajudya cuitatu mere puji cuana sarera cuacuare, tuja uva ejahuaneque pitu ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mere puji cuana daditsu tujatu ecana acuare: “Jida micuana tsujetyaya, peadya huecacaque mereja etsujequidya micuana tsujetyaya”. Tunaratu jidadya bacuare peadya huecacaja etsujequidya tsujetyayaju. Jadya etsujequi bajejetsu tujatu ecana cuadishacuare teeju merera. ");
INSERT INTO cavNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Quimisha ura juatsu, las nueve ura tupu dyanetu cuanucacuare mere puji cuana sarera. Plaza eque cuetiyaratu eje uma ecuita tsurucuare mere sare juneniya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Isaracuaretu ecana: “Micuana dyadi necuacuedya ecue teeju uva ejahuaneque pitura. Jida micuana tsujetyaya”, jadya tuna tee metsera acuare. Jadya ahuaju tuna merera cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Barepatyatu cuanucacuare mere puji cuana sarera. Las tres chinequeja dyanetu cuanucacuare mere puji cuana sarera. Tsurutsu tujatu ecana cuadishacuare tuja teeju merera. “Jida micuana tsujetyaya”, jadya tujatu ecana acuare. Jadya ahuaju tuna merera cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Las cinco chinequeja pijitu cuanucacuare. Plaza eque cuetinucayara tujatu ecana tsurunucacuare ecuita merema juneniya cuanaque. Banucatsu tujatu ecana jadya acuare: “¿Ai micuana juya rehua dutya huecaca merema?” ");
INSERT INTO cavNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ni aira buchique ecuana mere ishu isaraya ama tibu”, jadya tunajatu quemitsacuare. “Jutaquiju ecue teeju mere nejuticue. Era micuana tsujetyaya jida”, jadya tuna tee metsera acuare. Jadya ahuaju tuna teeju cuacuare merera. ");
INSERT INTO cavNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Amena ijeti nubihuie, las seis chinequeja cuana tujatu acuare tuja mayuruma: ‘Ihuaracue mere puji cuana tsujetya ishu. Tsujetyatibunecue ecana tupuju mere catibutihua cuana eque. Icuene cuita mere catibutihua cuanaque tupuju tsujetyacue’ jadya tujatu mayuruma acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tumetu las cinco chinequeja mere catibuticuare cuanaque casitaticuare mere juhuaque tsujetyata ishu. Inacuare tuna peadya huecacaque mere etsujequidya. ");
INSERT INTO cavNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jadya tujatu ecana tsujetyaajecuare mere juhua cuanaque peadya huecacaque mere tsujedya. Amena chamacama judirunucacuare icuene las seis apudajudya mere catibutihua cuanaque tsujetya. Tunaja datsetu inime jucuare: ‘Peadya huecacaque mere dyaquedya tura ecuana tsujetyaya’. Jadya ama bucha tunajatu peadya huecacaque mere etsujequi piji cuita camadya inacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Etsujequi baatsu tuna tee metse tsehue cahuaiticuare jipenee. ");
INSERT INTO cavNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Jidama mira ecuana tsujetyahua. Tupuju mere catibutihua cuanaque tuna peadya ura pijidya mere juhua. Ecuana bacue peadya huecaca yuta mere juhua ijeti uquedaju. Jadya ama bucha mira ecuana tuna tsehue dutya tupu tsujetyae ahua’ jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tee metseratu bacacuare tuna quisaratiyaju. Tume tujatu acuare peadya, etsujequi baatsu quisaratihuaque: ‘Tata, jidadya mique tsujetyaya. ¿Adebaya ama jatsumi peadya huecacaque mere etsujequi tsujetya ishu yatseja quisarati juhuaque? ");
INSERT INTO cavNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","15","Ique bahue ecue chipiru tsehue ai juyaque. Era ni tsujetyacara aya dutya tupu las cinco chinequeja mere catibutihua cuanaque, las seis apudajudya mere catibutihua cuana tsehue, ni riya piji buchique micuana jidama ama tsujetyaya. ¿Mique ni mi cahuaitiya ique jida juya baatsu? Jeedya micue etsujequi. Dirucue’ jadyatu tee metsera acuare tumeque ecuita. Jadyatu jucuare teeju mere jucuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Jadya equedyatu tupuju cuanaque icuene; icuene cuanaque bacue tupuju, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesúsra ecuana Jerusalén diji eque cuayaque tura mepehua cuanaque peya queja amaca duju acuare, tuque eje bucha juyaque cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Micuana micuana bahuedya Jerusalénju ique cuayaque. Neadebacue bacue ique eje bucha judadiyaque era cuejahuaque. Pae cuanaja huaraji cuana queja, cacuatsashati bahuityaqui cuana queja tunara inamereya. Tunara ique aya “Paiyetanadya” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Israelita ama cuana queja tunara inamereya. Ijahue ijahue tunara aya. Ebi tsehue au, catsacatsa jadya tunara aya. Tataya tunara curusuju ique maju ishu. Quimisha huecaca majutsu chacha netitsuranucaya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Tumetu Zebedeoja ehuanequera jipeticuare ebacuaque ecatse tsehue, Santiago, Juan jadya tsehue. Tuja yacuajutu chichucata jucuare, tuaqueja canerecatiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesusratu epuna bacaduracuare: —¿Ai micue? —Mique dutya naruqui jutibuneyaque, ecue ebacua ecatse bacanishacue miatsehue enaruqui iyuca juishu. Emuita eanicuareju ecatse iyabutyacue, peadya micue jida eque amaca, peya bacue jani eque amaca jadya. Miatsehue muitapeedya ecatse paju, —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Santiago, Juan jadya ecatse jipetinucatsu tujatu ecatse isaratinucacuare: —Metse metse baecua eje buchique metseja cuaara bacayaque. Ique dyaque canerecatiyaque tu patsedaque ebuijiu buchique. ¿Ique canerecatiya bucha canerecatie metse ejuudya? —Eiduudya tuque yatsera, —jadya tatsejatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—Pusha amadya metse cuejaya. Canerecatibuquedya metse, ique canerecatiya bucha. Jadya ama bucha ecuetu aijama cueja ishu ejeque ecue jida eque amaca, jani eque amaca jadya iyabutya ishu, eatsehue enaruqui juishu. Ecue Etatara camadyatu mepebuque tuhua iyabutya ishu, —jadyatu Jesúsra acuare Santiago, Juan ecatse. ");
INSERT INTO cavNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tume ecuana, Santiago, Juan ecatsera bacayaque bacatsu, cahuaiticuare tatse tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesúsra ecuana dutya tuaqueja ihuaracuare. —Yahua juque huaraji cuanara tuna cuatsashaya, emechiquira cuatsashaya bucha. Casada cuanaratu jetiedya cuanaque casada tsehue cuatsashaya equedya amereya. ");
INSERT INTO cavNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Micuana micuana jadya jutaqui ama. Peya queja ni micuana camuimereticara juya, tunadya tuque micuanaja tsahuataqui. ");
INSERT INTO cavNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ejeque muitacara juyaque juatsu, necacasaticue peya cuana pureamatura ishu, micuana cuita camadya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ique juya bae nejucue. Ique junahua riyaque yahuaju peya cuana tsahua ishu, tunaja ique tsahua ishu ama. Tuna jiteque maju ishu, eaqueja catyatihuaju tuna Ijahua quejaque inajacamere ishu ique junahua, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ecuana Jericó juque cuinanayajutu Jesús jetiama ecuitara tupujudya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tuhuatu beta ecuita shuhuique ecatse juanicuare ediji jiruru. Jesús cuetiyaque bacatsu tatse quiquecuare: —¡Ecuana Cuatsashaquique, miquemi Yusuja Emepeque, David eque ejuracanaque! ¡Nerecabacue taa yatse! —jadya tatsejatu quique eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ecuita cuanara tatse nereda acuare tatse abacasha ishu. Tatse bacue jadya ayaju dyaque jebuda quiquecuare: —¡Ecuana Cuatsashaquique, miquemi Yusuja Emepeque! ¡David eque ejuracanaque mique! ¡Nerecabacue taa yatse! —jadya tatse quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tatse juaniya tuyu junatitsutu Jesús netinaticuare. Ihuaratsu tujatu ecatse bacaduracuare: —¿Eje bucha metse eaqueja catimerecara juya? —jadya tujatu ecatse bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—Ecuana Cuatsashaquique, capetatishanucacue yatse, —jadya tatsejatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jadya juyaju tatse Jesúsra nerecada bacuare. Jabacuare tujatu ecatse yatucaju. Tura jadya aya tsehuedya cuita tatse capetaticuare. Capetatitsu tatse Jesús tsehue junenicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Junaticuare ecuana Betfagé epuju, Jerusalén piji dyane. Emata baruda cuita ama Olivo Acui Quini bacaniju ecuana junaticuare. Junatitsutu Jesúsra icueneta cuadisha acuare beta tura mepehuaque ecatse. ");
INSERT INTO cavNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Ecuanaja yacua tuyu epu achaachaju necuacue. Tuhua junatitsu tuque metse banatiya burra erisique netiyaju. Tuatsehuedya tujatu ebacua ehue ebarique. Nepisuticue. Pisutsu ecue nebecue. ");
INSERT INTO cavNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ejera ni metse aya: “¿Aishu tuque metse pisuya”?, “Ecuana Cuatsashaquiratu sareya. Masadama tujatu cuadishanucaya”, jadya neacue, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yuequedyadyatu Yusu equeque quisarati cuejaquira icueneta cueja acuare, jadyatu judadiya jadique. Jesús burro dyaque eque Jerusalénju (Sión bacanidya tume) judiruhuajutu beru cuejatanacuare baedya jucuare: ");
INSERT INTO cavNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Necuejacue Sionju aniya cuanaque: ‘Micuanaja ecuaritu micuana queja junaya. Micuana catiju ijahue ara amatu junaya. Burro dyaque equetu junaya. Uu cabuti ishuque jabacua dyaque equetu junaya’”, jadyatu Yusu equeque quisarati cuejaquique béru jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jesúsra cuadishahuaju, tura amerehua equedya tatsejatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yaratupu juatsu tatsejatu burra, burra jabacua jadya dujucuare Jesús queja. Judiruqueretsu tatsejatu tatsera jutuya tsehue titecuare. Tatsera bajeje amena ahuajutu Jesúsra isaanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesúsra isaanihuaju tunajatu jetiama tuhua cuanara tunaja jutu ishu cuanaque pijabarecuare edijiju, tuque muiyaque. Peya cuanaratu ejaqui cuana huanabarecuare edijiju, tuque muiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jesús icuene, tupuju jadya cuaya cuanaquetu quiquetibunecuare: —¡Hosana! ¡Miquemi dyaque emuique ecuanaja Ecuari! ¡David eque ejuracanaque mique! ¡Jida paju Yusuja ebacaniju jeyaque! ¡Arida, dyaque casada jadyatu Yusu barepajuque! —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tuequedyatu Jesús junaticuare Jerusalénju. Tuque junatihuaju tuna dutya tumeque epuju cuanaque capuriticuare. —¿Ai ri riyaque? —jadya tuna cabacaduratibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ecuita jetieque ama tuatsehue junatihuara tuna quemitsacuare: —¡Jesús riya! ¡Yusu equeque quisarati cuejaquique riya! ¡Galilea yahua juque epu Nazaret juque riya! —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jadya juu jadya juatsutu Jesús Yusuja etareju nubidirucuare. Nubitsutu dyaque cahuaiticuare, tuhua eje bucha juyaque baatsu. Jadya tibudya tujatu ecana etsecueju pana ijehuecuinatilla acuare catyati puji cuana, bacabaca puji cuana jadya. Tipacatillacuare tujatu chipiru cuarequi juya cuanaja mesa cuana. Huei catyati juya cuanaja ani ishu cuanaquetu tumebaedya tipacabarecuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Cuinanashayaque tujatu ecana jadya acuare: —Yusuja quisarati tu jadya ehuene: “‘Ecue etare tu eatsehue quisarati ishuque etare bacani’ jadyatu Yusu beru jucuare”. Jadya ama bucha tuque micuana chiri puji cuana catehua ishuque cani bucha jutidya amereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tuhua Yusuja etarejutu shuhui cuanara, rudurudu cuanara jadya Jesús jipeticuare. Jipetihuaju tujatu ecana chachanecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadyatu bacuare Jesúsra shuhui cuanaque, rudurudu cuanaque jadya chachaneyaju. Bacacuare tunajatu ebacua cuana quiqueyaju: —Jesús, miquemi dyaque emuique! ¡David eque ejuracanaque mique! Jadya bacatsu tuna cahuaiticuare dyáque. ");
INSERT INTO cavNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—¿Bacayami ecana quiqueyaju? ¿Eje bucha juatsu tuquemi ecana jadya quiqueyaju bacayadya jutidya? —jadya tunajatu Jesús bacaduracuare. —Jejee, bacaya tuque era. Yuneridya tuque micuanaja eisara Yusuja quisarati ehueneque: “Miquemi emui jubuque ebacua achaacha cuanaja, ebacua atsuju cuanaja. Jeru eque tunarami pureama abuque”, jadya tu ehuene Yusuja quisarati. ");
INSERT INTO cavNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jadya aatsu tujatu ecana shanaquenacuare. Yudijidya dirunucatu jucuare Betaniaju, tahuiti ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Apudajudya Jerusalén epu queja diruyaquetu Jesús aracara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Bacuaretu acui higuera ediji jiruru. Baatsu tujatu jipeticuare, cacaqui bucha baatsu, ecaca tuja ejaqui cuana tsehue cuinanae jipenee juya tibu. Bacuare amatu ni peadya ecaca buchique ecuiju, ejaqui camadya. Jadya baatsutu Jesúsra quisarati tyacuare higuera: —¡Cacacatinucanime ama mique! —jadya tujatu acuare. Tura jadya aya tsehuedya cuitadyatu higuera masadama raracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Acui rarahua baatsu ecuana tura mepehua cuanaque anajacatacuare. —¡Masadama cuitari higuera rarahua! —jadya ecuana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—¿Eje bucha juatsu micuana anajacataya? Yuneridya ni micuana ejeneya era ecue casa tyahuaque, ejenecara ejenecarama jadya ama ni micuana eau, era higuera ahua baeque cuita camadya ama tuque micuana eau. Aidya jutidya tuque micuana eau, arepa ai ibedaque paju ama bucha. Riyaque uhua cuemusu micuana eau: “Anisicuacue tuhuaque. Cueri cuanaja ecuaqueju pacacacue”. Amereya equedyatu ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yusu tsehue quisaratiyaque, ai ni micuana ebacau, tyayadya tura micuana, ejenecara ejenecarama jadya ayaque ama juatsu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tumetu Jesús dirunucatsu Yusuja etareju nubidirucuare. Tuhua tuque bahuitya bahuityayajutu pae cuanaja huaraji cuanara, israelita cuanaja emuiba cuanara jadya jipeticuare. Jipetitsu tunajatu bacaduracuare: —¿Airami ejeque ecuitaja ataquique ama aishu cuatsashahua? ¿Aija casa tsehue tuquemi jadya aya? —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesúsra tuna quemitsacuare: —Era micuana tumebaedya bacaduraya. Quemitsaya ni micuanara ique, tume micuana cuejaya aira cuatsashahuaju era riya cuanaque ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Airatu Juan cuatsashacuare ecuita cuana utsa ishu? ¿Yusura, ecuita cuanara ni taa? Nequemitsacue ique, —jadya tuna Jesúsra bacaduracuare. Tume tuna, tuna cama quisaraticuare: —¿Eje bucha tuque ecuana equemitsau? “Yusuradyatu cuatsashacuare”, jadya ni ecuana eau, tume tura ecuana ebacadurau: “¿Eje bucha juatsu jatsu tuque micuana Juanra cuejacuareque ejenecuare ama?” jadya tura ecuana eau. ");
INSERT INTO cavNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Ecuita cuanaja ecuadishaquedya jutidyatu jucuare”, jadya ni ecuana eau, tumetu dutya jujeri ecuita cuana ecahuaitiu ecuana tsehue. Juan tunajatu Yusu equeque quisarati cuejaquique bucha adebaya, —jadya tuna cacuejaticuare. Ecuita cuana mubatsu tunajatu Jesús quemitsacarama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Chamacama tunajatu quemitsacuare: —Baecua ecuana aira Juan ecuita cuana utsa ishu cuatsashacuareque, —jadya tunajatu Jesús acuare. —Jutaquiju micuana era cuejaya amadya aira ique ecuitaja ataquique ama aishu cuatsashahuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Bahuityanucacuaretu Jesúsra pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque jadya: —Cuejaya micuana cuatsabiji piji. ¿Ai era bahuityacara aya bucha tuque micuanaja inime juya? Peadya ecuitajatu anicuare beta ebacuaque. Peadya tujatu ebacuaque acuare: “Cuacue teeju merera, deca. Uva ejahuaneque pituticue”, jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Aijama, tata. Cuacarama juya merera”, jadya tujatu etataque quemitsacuare. Yara tupu junenitsu eje bucha inime tuputsutu merera cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Peadya icuene jadya isarae aatsutu etataquera peya isaratinucacuare: “Cuacue teeju merera, deca. Uva ejahuaneque pituticue”, jadya tujatu acuare. Turatu quemitsacuare: “A, pacua taa, tata. Mere pajuti”, jadya tujatu etataque acuare. Jadya ama buchatu cuacuare ama merera. Jadyatu ehue ebari ecatse jucuare, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jadya cuejatsu tuna Jesúsra bacaduracuare: —¿Ejera tatsejatu etataqueja yana acuare? —Inime cacuaretitsu merera cuacuarera, —jadya tunajatu quemitsacuare. —Micuanara bijidamaduraya cuanaque tuna Yusu jaque judadibareya; micuana jida bucha cabatiya cuanaque micuana Yusu jaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Ecuita Cuana Utsaquiquetu junahua micuana Yusuja biji eque ani bahuitya ishu. Bacacarama micuana tura cuejayaque ahua. Micuanara bijidamaduraya cuanara bacue tuja quisarati bacacuare. Tume Roma juque enaruquija ishu chipiru sitaqui cuanaque, tumebaedya epuna decadeca arida cuanaque jadya tuna inime cacuareticuare. Arepa micuana tuna inime cacuaretihuaque baya ama bucha micuana inime cacuareticarama juya, Yusura cuejahua eque ani ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Bahuityanucacuare tuna Jesúsra: —Nebacacue riyaque peya cuatsabiji micuana bahue ishu. Peadya ecuitajatu tee aridaque anicuare. Tee aatsutu uva uhuamerecuare. Taracanemerecuare tura. Amerecuaretu uva jahuanehuaju pitutsu nacaca tisi ishuque. Amerecuaretu etare piji barudaque, tueque tsuratsu, dutya queja naru ishu. Umae ecuita cuana queja tujatu tee narumerecuare. Tura tuna acuare: “Micuanara ni ecue tee naruya, tume ecuana uva jahuanehuaju cajaquetiya micuana tsehue”. Tuna tuna endya jucuare. Tume cuanaque bajejetsutu emechiqui cuacuare japada peya yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Uva jahuane mara juetihuaju tujatu tuque merequi cuanaque cuadishacuare tee naruqui cuana queja. “Necuacue ecue teeju mere juya cuana queja. Necuejaticue ecana; pacuadisha tuna ecue ishuque uva epituque”, jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jadya ahuaju tuna cuacuare. Jutihuaju tuna tee naruqui cuanara inatsacuare. Peadya tuna catsacatsa acuare. Peya tuna iyecuare. Peya tuna tumu tsehue acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jadya juhua bacatsutu emechiquira umae tuque merequi cuanaque cuadishanucacuare. Tee naruqui cuanara icueneque atsahua baedya jutidya tuna atsanucacuare dutyadya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Datse juatsu tujatu ebacuaque neri cuadishacuare. ‘Riyaque renajari eje bucha ama atsaya. Ecue ebacua neri tibu, tunajatu muibatsaya’ jadya datse tujatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ebacuaquera jipeajeyajutu tee naruqui cuanaque jadya jucuare tuna cama: ‘Riyaquedyari tee metseja ebacuaque neri. Eje tupu etataque majuhuajuri riyaquedya tee metse judadiya. Neiyetsara. Ecuanadya emechiqui nejura’ jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Inatsacuare tunara. Inatsatsu tuna tee juque cuinanashacuare. Cuinanashatsu tuna iyecuare. Jadyatu tee naruqui cuanaque jucuare, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tumetu Jesúsra bacaduracuare tuque quisaratiyaju bacaqui cuanaque: —¿Eje buchatu anabuque tee naruqui cuanaque emechiquira? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tuhua cuanaratu quemitsacuare: —Iyemerenabuquedya tujatu nerecabatsu ama tumeque ecuita jidama cuanaque. Peyadya tujatu mere puji cuana sarenabuque tee naru ishu. Tume iyacua cuanaratu tyabuque dutya uva cuana tee metseque jaquetsu, —jadya tunajatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesúsra tuna anucacuare: —Neadebacue riyaque Yusuja quisarati ehueneque. Adebayadya tuque era micuanaja riyaque quisarati eje uma isara eaque: “Tumu etare puji cuanara tsumecarama acuarequetu tumu dyaque saretanayaque judadicuare. Ecuana Cuatsashaquiratu dyaque saretanayaque amerecuare. Riyaque jadya baatsu, ecuana dyaque pureama juya”, jadya tu ehuene. ");
INSERT INTO cavNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Jadya tibudya micuana cuejaya riyaque. Micuanara ique bijidamadurahua tibutu Yusuja quisarati israelita ama cuanaque quisarati cuejatanabuque. Tuna tuna eaqueja catyatibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Idya tumeque tumu etare puji cuanaja ebijidamaduraque buchique. Ique bijidamaduraquiquetu yuamaturatanabuque. Ejeque era nerecaturayaquetu pana yuamaturatana jubuque, ejeque tumu ebarira tyanatsu pana jemi muru eamereu bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Riyaque quisarati bacatsutu pae cuanaja huaraji cuana, tumebaedya fariseo cuana jadya cahuaiticuare, tunara cuitadya Jesús bijidamadurahuaque caadebatitsu, mere puji cuanara tee metseja ebacuaque bijidamadurahua bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eje buchadya iyecara datse tunajatu acuare. Jadya ama bucha “Iyacua ni ecuana einau, tumetu ecuita cuana ecuana tsehue ecahuaitiu, tunara Jesúsra Yusuja quisarati cuejayaque ejeneya tibu”, jadya tunajatu inime jucuare. Ecuita cuana mubatsu tunajatu Jesús inacuare ama tumeque ura cuitadya. ");
INSERT INTO cavNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesúsra tuna bahuityatibunenucacuare. Cuejacuare tujatu ecana cuatsabiji tuna bahuitya ishu: ");
INSERT INTO cavNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Cuejaya micuana riyaque cuatsabiji Yusura dutya naruyaju eje buchique micuana bahue juishu. Anicuare tu ecuari. Dyaque arida chinetu jucuare tuja ebacuaque caquemitiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ihuaramerecuare tujatu ecana jetiama chine ishu. Earaqui amena juhuaju tujatu cuadishacuare tuque merequi cuanaque tuja ecueja cuanaque ihuarara. Cuejatahua ama bucha ecana cuacarama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yaratupu juatsutu peya tuque merequi cuanaque cuadishanucacuare. “Necuejatinucacue eihuara cuanaque; ebajarara ecana paje. Patsunuta ama ecana. ‘Iyetanahuari huaca, uu etseri cuinasha cuanaque. Eramiri jinahua amena. Dutyari amena ebajeje’ jadya necuejaticue eihuara cuanaque”. ");
INSERT INTO cavNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tura jadya ayaju tuna cuanucacuare ecueja cuanaque ihuarara. Eihuara cuanaque tuna jubarecuare: “Aijama, cuaya ama ique chinera”. Peadyatu cuahua teeju. Peya bacue cuahua tuja ai catyatira. ");
INSERT INTO cavNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Peya cuanara bacue ecuari merequi cuanaque inatsacuare. Inatsatsu tunajatu iyeya tupu miririshacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jadya juhuajutu ecuari dyáque cahuaiticuare. Tuja sudaru cuana cuadishatsu tujatu iyemerecuare quiyeti puji cuana. Epu pahua jadya tujatu amerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tumetu ecuarira tuque merequi cuanaque jadya acuare: ‘Dutyatu amena ebajeje carisitihuaju chine juishu. Era cuejamerehua cuanaque tuna jecarama juhua. Paje ama taa ecana. ");
INSERT INTO cavNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Necuacue ediji arida cuana eque. Ejeque tsuruyaquedya jutidya ecana necuejacue; chine juyaju tunara pabana’ jadyatu ecuarira acuare tuque merequi cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tura jadya ayaju tuna yana equedya cuacuare. Cuacuare ecana ediji cuana eque. Dutya jecara juyaque tunajatu becuare chine juishu, jidama cuanaque, tumebaedya jida cuanaque jadya. Tume tujatu ecana tyamerecuare caquemitiyaque chine juishu jutu ishuque cuita camadya. Jadya jequeetu etare jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Yaratupu juatsutu ecuari nubiticuare junahua cuanaque isarara. Nubitsu tujatu bacuare peadya ecuita caquemititayaju tarepe ishuque ejutuqui tsehue ama. ");
INSERT INTO cavNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tume tujatu isaraticuare: ‘Miquemi caquemititayaju tarepe ishuque ejutuqui tsehue ama ecajututi. ¿Eje bucha juatsu?’ jadya tujatu bacaduracuare tumeque. Ecuitaratu quemitsacuare ama. ");
INSERT INTO cavNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Tumetu ecuarira acuare eihuara cuanaque bau juya cuanaque: ‘Nerisicue ehuachiju, emetucuju jadya. Etsecue apuda ducu neijehueticue. Tuhua dyaque canerecatiyaque etse tari paju’ jadya tuna ecuarira acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jadyatu caquemitiyaju chine ishu jucuare. Chine ishu juchine bucha, jadidyatu Yusu enaruqui juhuaju jubuque. Arepa jetiama tuja eihuaraque ama bucha, eje uma ama tuna tuaqueja judirubuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jadya cuejayaque bacatsutu fariseo cuana dirucuare. Jesús jidama aishuque inime bajeje tuna jucuare. “Jidama nequisaratishara, huaraji cuana queja duju ishu”, jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jadya eque tunajatu tuna tsehue juneni puji cuana cuadishacuare, tumebaedya Herodes tsehue juneni puji cuana Jesús tsehue quisarati ishu. Cuadishahua cuanaque jutitsu tunajatu Jesús aticuare fariseo cuanara bacaduramerehuaque: —Ebahuityaquique, ecuana ecuana bahue mique jida, tuyuque. Miratu bahuityaya Yusuja inime eque ani ishuque, ni ejeque buchique mubatsu ama. Micue ishutu ecuita cuana dutya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Cuejacue dyadi ecuana mira inime tupuyaque. ¿Ecuanaja cacuatsashati eque tuque ecuanaja ecuana naruquique Roma juque tsujetyataqui, tsujetyataqui ama ni taa? —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesusratu adebacuaredya tunara jidama inime tupuya tsehue jadya bacaduratiyaque. —Jidadya batacara datse micuana juya, ai jidaque ama. Micuanara ijahue acara aya, jadya cabacadurati tsehue, babi pujira armadilla nityatsu ai cuanubi eamereu bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Nebamerecue ique ficha enaruquija chipiru tuque tsujetya ishuque. Papeta era, —jadya tujatu ecana acuare. Jadya ahuaju tunajatu queticuare peadya ficha “denario” bacani Roma juque enaruquique tsujetya ishuque chipiru. ");
INSERT INTO cavNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Petatsu tuna Jesúsra bacaduracuare: —¿Aija ebutsequini ri riyaque fichaju eiya? ¿Aija ebacani ri rehua ehuene? ");
INSERT INTO cavNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Enaruqui muidaque César bacani jaque tume, —jadya tunajatu quemitsacuare. —Jutaquiju netyacue enaruquique César tuque tyaishuquedya. Yusu netyacue Yusuja ishuquedya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Anajacatacuare tuna tuque jadya caquemitsatiyaju bacatsu. Jadya juatsu tuna cuinanatsu dirubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Tumeque huecaca nucadyatu saduceo cuanara Jesús baticuare. Tunaradyatu ejenecuare ama emaju cuanaque netitsuranucayaque. Junatitsu tunajatu Jesús isaranaticuare: ");
INSERT INTO cavNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Ebahuityaquique, Moisésra taa tu riyaque cuatsashacuare: “Ejeque ecuita ni majuya cabacuatimaque, tuatsehuequiquetu caquemitinucataqui eahuemaju tsehue, tuatsehue cabacuati ishu, icueneque ebacua emajuja ebacuaque bucha ishu”, jadyatu Moisésra cacuatsashati huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Riyaque cuatsabiji mique ecuana aya; ijariba ishuque jutidya tu ecuita emajuque chacha netitsuranucaya jadique. Anicuaretu ecuitaja pacarucu ebacua cuanaque. Icueneque ebacuaquetu caquemiticuare. Huanequi juu jadya juatsutu majucuare bacuamaque. Majuhuajutu ejuque beta ishuque caquemitinucacuare eahuemaju tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Beta ishuque tumebaedya majunucacuaredya bacuamaque. Quimisha ishuque ejuquetu caquemitinucacuare eahuemaju tsehue. Tumebaedyatu junucacuare. Bacuamaquedyatu majunucacuare. Jadya ecana jubarecuare; pacarucudyatu tumeque epuna tsehue cama ecana caquemititsu majuetibecuare bacuamaque tere. ");
INSERT INTO cavNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tumeque nerecadaque epunatu pacarucu ahuee juhuaque majucuaredya, yahue cuanaque majuterehuaju. Jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Ecuanarami bacaduraya riyaque. Yuneridya ni majuya cuanaque chacha netitsuranucabuque, ¿ejeja ehuanequetu jubuque chacha netitsuranucatsu, riyaque yahuaju tuque pacarucu ahuee juhua tibu? —jadya tunajatu Jesús bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesúsra tuna quemitsacuare: —Micuana micuana cuji juya. Micuanaratu adebaya ama Yusuja quisarati ehueneque, ni Yusura eauque. ");
INSERT INTO cavNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Emaju cuanaque netitsuranucatsu tuna caquemitinucabuque ama. Barepaju Yusu tsahuaqui cuanaque tuna caquemiti baecua. Jadidya tu emaju cuanaque; netitsuratsu tuna caquemitinucabuque amadya. ");
INSERT INTO cavNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Yuneridyatu emaju cuanaque chacha netitsuranucabuque. Pusha ama cuitadya tuque micuana eje uma isara ahua Yusuja quisarati ehueneque adebayaque ama: “Ique Yusu Abraham, Isaac, Jacob jadyara iyacua muiyaque”. Chacha cuanara cuita camadya Yusu emuiu tibu, yuneridyatu Abraham, Isaac, Jacob jadya ecana enetitsura. Yusu tu chacha cuanara muiyaque, emaju cuanara ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ecuita cuanatu anajacatacuare jadya caquemitsatiya bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Fariseo cuanatu, Jesúsra saduceo cuana abacashahua jadya bahue juatsu casitaticuare, Jesús eje bucha jidama acara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Peadya fariseo cacuatsashati bahuityaquiquetu tuna tsehuedya jucuare. Turatu Jesús bacaduracuare, cabacadurati eque ijahue acara aatsu datse: ");
INSERT INTO cavNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Ebahuityaquique, aniyatu jetiama cacuatsashati cuana ecuanaja cacuatsashatiju ehueneque. ¿Ejeque cacuatsashatira cuatsashaya eque cuita ecuana jutaqui? —jadya tujatu Jesús bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesusratu quemitsacuare: —“Iyuhueda bacue ducuta Yusu Mique Cuatsashaquique. Yusu iyuhueda bacue ducuta, dutya micue cabijiseriti tsehue Yusu pureamaturacue, dutya micue inime tupu tsehue, dutya micue casa tsehue”. ");
INSERT INTO cavNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Riyaque cacuatsashatiratu dutya cacuatsashati cuana sabutillaya. Riyaque cacuatsashatira cuatsashaya eque cuita micuana jutaqui. ");
INSERT INTO cavNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Beta ishuquetu tumebae cuita nucadya: “Iyuhue tsehue bacue peya cuana; mique cuitadya iyuhueda cabatiya bucha iyuhuee peya bacue”. ");
INSERT INTO cavNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Riya beta cacuatsashati ecatsera cuatsashaya eque ni micuana aniya, tumemi Moisésra, Yusu equeque quisarati cuejaqui cuanara jadya bahuityacuare equedya juya, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo cuanatu tuhuadya ecasitati jucuare jari. ");
INSERT INTO cavNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesúsra tuna bacaduracuare: —¿Eje bucha micuana adebaya Mesías? ¿Ejeque ecuita eque ejuracanaquedya jutidya ni taa tume? —jadya tujatu ecana acuare. Tunaratu quemitsacuare: —Ecuanaja ebaba David emui eque ejuracanaquedya jutidya tume, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—David cuitadyatu bahue jucuare Mesías ecuita camadya ama jubuqueque, ecuita cuana bucha dyaque inimequique, Yusuja Espiritura huecashayaju, “Ique Cuatsashaquique” jadya isarae acuare tibu, Micuana micuana bahuedya Davidra quisarati jadya acuareque: ");
INSERT INTO cavNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Yusuratu Ique Cuatsashaquique jadya cuejacuare: ‘Anibutecue ecue jida eque amaca muita ishu, era mique ujeu baqui cuanaque dutya ijahue atillaya tupu, Ique Cuatsashaquique’” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Davidradyatu Mesías ‘Ique Cuatsashaquique’ jadya acuare, arepa tueque ejuracanaque ama bucha. Yuneri cuitadyatu Mesías ecuita jutidya ama ejuu; ecuita cuana bucha dyaque inimequiquedya tume, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jadya bacatsutu ni ejera buchique quemitsataqui ama bacuare, dutya ecana tuque yuneri quisaratihuaque bahue tibu. Tumeque huecaca equetu ni ejera bacaduranucacuare ama tuque jidama acara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Tuequedya ecuana tura mepehua cuanaque ecuana Jesúsra isaracuare, tumebaedya ecuita cuana tuhua jucuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Fariseo cuanaja, cacuatsashati bahuityaqui cuanaja mere tu Moisesra cuatsashahuaque cueja. ");
INSERT INTO cavNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Jadya tibudya nebacacue tunara amereyaju. Dutya tunara cuatsashaya equedya nejucue. Jadya ama bucha tuna aniya bae neaniume. Arepa jida bahuityaya ama bucha tuna jidama aniya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Tunajatu peya cuana cuatsasha bahue eje bucha anie juishuque; ai tuna cuitadya tunara bahuityaya eque aniyaque ama. Tsahuaya ama tuna peya jida Yusuja biji eque ani ishu. Cacuatsashatiya camadya ecana. Abu ishuque dyaque bicueda eje bucha abutaquimaque peya abumere ishuque bajejequi buchique tuna. Tunara cuitadyatu ni ai buchique abucarama aya, ni tuna peya abuquerecara aya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Dutya tunara ayaquetu peya cuanaja peta ishuque jutidya, peya cuanaja sumi ishu. Ecuanaja bahue eque tunajatu Yusuja quisarati huene bahue ebiti eje junuju ama equetiju carisiti ishu, ebiju jadya. Quiniquinisi tunaja ebiju, equetiju jadya erisi cuanaque. Dyaque junudaque tuna unaju huesiruyaque jutuya, peya cuana queja Yusu adebaqui jadya cabamereti ishu datse. ");
INSERT INTO cavNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Chine cuana ishu araaratayaju cuaatsu tuna emuita cuanaja eaniqui cuanaju cama tuna eaniqui metsene juya. Caradati ishuque etareju cuaatsu tuna muida cuanaque anibahueju anibutetiya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ediji cuanaju juneniyaju tuna dyaque muida tsehue isaratacara juya. “Ebahuityaquique” jadya tuna isaratacara juya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Micuana jadya nejuume. Peya cuana dyaque inimeju bucha necabatiume. Peya cuana queja ‘Ebahuityaquique’ jadya catimerecara ebari nejuume. Ique camadya Micuana Bahuityaquique, ni ejeque buchique micuana dyaque inimeju ama; micuana tsehuequi cuanaque buchique micuana dutya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Nemuiume muita ishu ama cuanaque. “Ecuanaja Etata Emuique” jadya ebacani eque neisaraume micuanaja tata ama cuanaque. Peadya camadya tuque micuanaja Tata aniya, barepaju aniyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Micuana cuita camadya ecuatsashaquique bucha necabatiume. Ique Ecuatsashaquique. Ique Yusuja Emepeque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ejeque ni micuana dyaque inime metseque cabatiya, tumejadyatu peya cuana tsahuataqui iyuhue tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yusuratu dyaque inime metse cabatiyaque aishu ama amereya. Aishuque ama cabatiyaquetu dyaque inime metse Yusura amereya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Tuequedya tujatu fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya isaratibunecuare: —¡Nerecapane micuana, cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya ai jidaque ama! Dyaque nerecada micuana jubuque, micuanara peya cuana Yusu queja ecatyati cuanaque eaqueja nimee amerejacaya tibu. Micuanaratu era iyacua bahuityaya cuanaque bijidamaduraneri ahua. Tumebaedya micuanara peya cuana queja ijacabacamerecarama aya. Micuana micuana etsecue yahue tsehue teriqui buchique, micuana cuitadya nubi ishu ama ni peya cuana nubi ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya ai jidaque ama! Arepa micuana eahuemaju cuanaque tsahuaya bucha cabatiya ama bucha, yuneri cuitadya micuana eahuemaju nerecada cuanaque tunaja ai aniya cuanaque secatillaya, tuna tunaja etare juque cuitadya ijehuecuinaya tupu. Yusu tsehue quisaratiyaque micuana tsunuda quisarati bahue dutyaja ijacaju, tuna queja ‘Yusu adebaqui cuita rena’ jadya catimere ishu datse. Jadya tibudya micuana Yusura dyaque nerecaturabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya, ai jidaque ama! Japada micuana cuabahue, muda cuana eque micuana cueti bahue, peya cuana micuanara ejeneya bucha ejenemerera. Amena tunara, tunaja beruque quejeneti cuana iyatsu, micuanara ejeneya bae ejenetsu, tuna icuene juhua bucha dyaque jidama, micuana bucha dyaque jidama. Micuana tsehue judirupeedya tuna ijahuaja etiquiju jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Nerecapane micuana shuhuique bucha cuanaque! Arepa micuana Yusuja quisarati bahuityacara aya ama bucha, micuanara cuitadyatu pana adeba ama aya. Jadya tibudya tuque micuanaja bahuitya bahue: ‘Baretaqui amatu micuanara quisarati ayaque, Yusuja etareju ai oro ea cuanaque bacani huesayaque juatsu. Baretaquidyatu quisarati Yusuja etare bacani huesayaque juatsu. Micuanaja ishu tu oro Yusuja etare ducuque dyaque emuique, Yusuja etare bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Micuana micuana inimema! Shuhuique bucha cuanaque micuana. Yusuja etaretu dyaque saretanayaque, tumeque etareju aniya buchique ama. Tuhua oro ea cuanaque tu Yusuja cuanaque, tuja etare ducu tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tumebaedya tuque micuanaja bahuitya bahue: ‘Baretaqui amatu micuanara quisarati ayaque, Yusu tyayaque bacani huesayaque juatsu. Baretaquidyatu quisarati tyayaque iyaquique mesa bacani huesayaque juatsu’. ");
INSERT INTO cavNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Micuana micuana inimema, shuhuique bucha cuanaque! Mesa Yusu jaque juya tibu, tumeque mesa tu dyaque emuique, uu, upati cuana jadya micuanara Yusu tyayaque mesaju iyaya cuanaque bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bijidamaduraya ni micuana mesa, tumebaedya tuque micuana bijidamadurayadya mesa dyaque aniyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Bijidamaduraya ni micuana Yusuja etare, tumebaedya tuque micuana bijidamadurayadya Yusu tuhua cabameretiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Bijidamaduraya ni micuana barepa, jutaquiju taa tuque micuana bijidamadurayadya Yusuja eaniqui, Yusu cuitadya jadya, tuque tuhuadya aniya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya, ai jidaque ama! Arepa micuana cacuatsashati cuana aishuque ama jipenee eque juya ama bucha, cacuatsashati dyaque inime metse eque micuana aniya ama. Micuanajatu Yusu tyabahue cacuatsashatira casada tsehue tyamereyaque camadya. Acuihuija ijimeda cuanaque “anis”, “comino” jadya bacani micuanaja etare taracaju euhua cuanaque tuque micuanaja tyabahue. Jadya ama bucha tuque micuana jida, tuyu tsehue ama baya peya cuana. Nereca baya ama micuanara ecana. Micuanara aana ayaque tuque micuana aya ama. Pusha amadya tuque micuanaja Yusu tyataqui cacuatsashati eque casada tsehue tyataquique. Jadya ama buchatu dyaque saretanaya jida, tuyu peya cuana tsehue ani ishu, tuna canerecabati tsehue baishu, micuanara aana ayaque aishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Shuhuique cama micuana caaquerenitiya. Micuanaratu quibeti tsehue aya aishuque ama, dyaque ataquique micuana peya queja iya aya. Canecu juque ena ijiyaque dii ebuijiuju equemiu bucha, tumeque piji buijicaramaque, cahuayu ebari ebuijiu bucha tuque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya, ai jidaque ama! Arepa micuana ecuitaju asicadaque jida catillaticara juya ama buchatu Yusura micuanaja inime ducuta asicada baya. Bijiserijacaya ama micuana chipiru, micuana cuita camadya capureamaturati ishu. Chiri micuana juajeyadya jutidya ai bijiseriyaque cadaditi ishu. Yusuratu tume cuanaque dyaque asicada baya. Micuana micuana canecu, peja jadya dyaque camadya eutsaque bucha, educuju asicadaque utsama. ");
INSERT INTO cavNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo cuana, micuana micuana shuhui cuana buchique. Icuene cuita necajuchatijacacue, Yusuja biji eque ani ishu. Jadya anie juyaju micuana Yusura jida asicadama baya, canucu dyaque, educuju jadya pana utsa eaque bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jidadya batacara datse micuana juya, ai jidaque ama! Micuana micuana emajuja uhuacuare pajada tsehue dyaque epepaque bucha. Petatsutu emaju cuanaja uhuacuare cuana jida piji. Educuju bacue emajuja etsau cuana erami jadya eririque jirutaquimaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jadya micuana juya. Quisaratiyaju bacatsu micuana ecuita cuanara ecuita jida cuanaque bucha baya. Educuju micuanaja inime tupu bacue micuanaja jidama. Micuana cabameretiya bucha ama micuana. ");
INSERT INTO cavNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya! ¡Jida bucha datse micuana cabamereticara juya, ai jidaque ama! Bérutu micuanaja baba cuanara iyecuare Yusu equeque quisarati cuejaqui cuanaque, peya jida cuanaque jadya. Iyacua tuque micuana micuanaja baba cuanara iyecuare cuanaja uhuacuare cuana, tunaja cueya cueya cuana mui ishu jida piji bajejeya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","‘Ecuana beru yuequedya anicuareque juatsu, ecuanaja baba cuana juhua eque ama ecuana juquena juhua. Iyequena ama ecuana juquena juhua Yusu equeque quisarati cuejaqui cuanaque’ jadya micuana jubahue. ");
INSERT INTO cavNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jadya quisarati eque micuana amena ejitaju juya micuanaja baba cuanaja inime cadujutiyaque. Micuana cuitadya micuana Yusu equeque quisarati cuejaqui cuanaque iyequi cuanaque jucuare bae juya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Micuanaratu aajeya jaridya micuanaja baba cuanara jidamaque tibunecuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Micuana micuana jii jii ama, bacua ujedaque bucha! ¡Micuanaja baba cuana baedya micuana juya! Tunaja inime jari cuitadya micuana cadujutiya jari. Yuneri cuitadya micuana ijahuaja etiquiju canerecatibuque; eje bucha huanataqui ama micuana jadya canerecati ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Era tuque micuanaja cuadishabuque ique equeque quisarati cuejaqui cuanaque. Cuadishabuque tuque micuanaja ecue quisarati pana adeba aya cuanaque. Cuadishabuque tuque micuanaja ecue quisarati pana bahuitya abahue cuanaque. Ijacabacacarama tuque micuana abuque. Eje uma tuque micuana ecana iyebuque, curusuju tatatsu. Peya cuana tuque micuana miririshabuque etare caradati ishu cuanaju. Peya cuana tuque micuana nerecada abuque, peya epu cuana juque huanashayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Nerecaturatabuque micuana ecue cuanaque jidama ahuaju camadya ama, tumebaedya micuanaja baba cuanara béru yuequedya ecuita jida cuanaque iyecuare tibu. Dutya iyetacuare tibu Abel equeque, Zacarías tupu micuana jucha metse. Zacarías, Berequíasja ebacuaquetu Yusuja etareju iyetanacuare, Muida Cuitaque Ama, mesa tumu eaque Yusu tyaya cuanaque iya ishuque patya majaca. ");
INSERT INTO cavNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pusha amadya micuana cuejaya. Micuana iyacua aniya cuanaque micuana nerecada atabuque Yusu dutya merequi cuanaque iyetacuareja inime, —jadyatu Jesúsra acuare fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jadya quisarati amena aatsutu Jesúsra quisarati acuare Jerusalénju aniya cuanaja ishu. Tuna cuitadya baatsu quisarati aya buchatu jucuare, arepa tuna tuhua ama jucuare ama bucha. —Micuana Jerusalénju aniya cuanaque, micuanaja epu ebarijutu Yusu equeque quisarati cuejaqui cuanaque tumu tsehue iyetajacama jucuare. Eje uma narucara ebari datse micuana ahua. Tacure jabacua cuana ecuaquera yajapara emaque ishatsu enaruu bucha, narue datse micuana acara ahua. Micuanajatu ecue jadya narue aishu bijidama juhua. Dutya jujeri micuana eaqueja catyaticarama juhua. ");
INSERT INTO cavNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nebacacue. Yusuratu tuja epu ebari narujacabuque, tumebaedya tuhua anibuque cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Banucabuque ama micuanara ique, “Jida paju Yusuja ebacaniju junayaque”, dutya israelita cuana jadya judadiya tupu, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yusuja etare juque cuinanayara, ecuana Jesúsra mepehua cuanara tuque ecuana isaracuare: —¡Ecuana Bahuityaquique, petacue! Dyaque jida piji taa Yusuja etare, tumebaedya dutya ai ea cuanaque etare tsecue cuanaju, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—Pusha amadya. Jida pijidya tuque ecuana petaya. Jadya ama buchatu Yusuja etare, etsecueju dutya ai ea cuanaque pana rihuishatanatere jubuque. Anibuque amatu tumu ecadyaqueti. Dutya tumu etare enityatsuraquetu yahuaju tere jubuque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jadya juatsu ecuana cuanucacuare uhua cuemusu Olivo Acui Quini bacaniju. Cuayaquetu Jesús anibutenaticuare. Anibutehuaju tuque ecuana isaracuare: —Cuejacue ecuana. ¿Eje tuputu jadya judadiya? ¿Aiju ecuana caadebatibuque mique junanucayaque, yahua tereyaque huecaca japadamaque jadya? —jadya tuque ecuana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—Nimequi tsehue nequihuaticue. Ijahue necatimereume. ");
INSERT INTO cavNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ique junanucahuie tuna jetiama junabuque iquepa ejuu jadya juya cuanaque. “Idya Mesías, Yusuja “Emepeque”, jadya tuna jetiama junabuque. Jetiamara tuna ejenebuque. Ijahue tuna atabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dutya quejaquedya jutidya tuna catibuque. Japadama tuque micuana ecana catiyaju bacabuque. Tumebaedya tuque micuana ecana japadapa catiya jadya bacabuque. Jadya bacatsu “Masadamatu tere juetiya”, jadya micuanaja inime paju ama. Dutya tume cuanaquetu jadya jubuque icuene. Tere ishuque ama jari tume. ");
INSERT INTO cavNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Riyaque yahuaju cuanaque tuna peya yahuaju cuana tsehue catibuque. Anape cuanaquetu catibuque peya anae cuana tsehue. Eje uma epu cuanaju tuna dyaque mije jubuque. Bucucubuquetu yahua dutya queja. ");
INSERT INTO cavNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jadya cuana judadiyaquetu canerecati catibutiyaque jutidya. Ecue cuanaque tuna dyaque canerecatibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Tume tunara micuana tunaja biji ijahue ijahue abuque. Dutya jujerira micuana ujeu babuque, eaqueja ecatyati baatsu. Iyebuque tunara micuana. ");
INSERT INTO cavNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Eje uma tuna eaqueja nimee jujacabuque, ecue ama cuanaque aniya bucha anie junuca ishu. Ujeu tuna cabatibuque. Yurameta ijahue quinatibare juatsu tuna ujeu cabatitsu huaraji cuana queja quinameretibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jetiamatu cuinanabuque pusha pusha arida cuanaque, Yusuja quisaratipa ecuejau jadya juya cuanaque. Dyaque ijahue tunajatu ecuita cuana abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Dyaque cuita canerecati juetihuaju tuna dutya jujeri yurameta iyuhueda cabatijacabuque. Etiqui riya piji ticuajeya bucha tunajatu iyuhue tereajebuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ejeque tereya tupu eatsehue nime aputayaque ama camadyatu Yusu queja judirubuque, ni eje tupu tuque jacanuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Dutya quejatu riyaque yahuaju quisarati tsapetanabuque Yusura dutya naruyaque, dutyaja ecue quisarati adeba ishu. Dutya queja Yusuja quisarati cuejatanahuaju ique chamacama junanucabuque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jesúsra ecuana cuejanucacuare: —Ejitajutu dyaque jidama cuitaque judadibuque, “Ecuita Cuana Bajituraquique” bacani. Tumequedyatu Yusu equeque quisarati cuejaqui Danielra béru huenecuareque. Tuquetu ejitaju jubuque Yusuja etareju. Tumequepa amena juetihua jadya bacatsutu Yusuja quisarati ehueneque pana adeba aya cuanara adebabuque masadama eje bucha judadiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ecuita Cuana Bajituraquique Jerusalénju juetihua jadya bacatsutu Judea yahuaju cuanaque huanataqui emata cuanaju catehua juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Muya jutidyatu Ecuita Cuana Bajituraquique juetibuque. Jadya tibudya tuna etare ebarucue ecamahua jepeda cuana juque ai inaquenama butetaqui huana ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Teeju mere juya cuanaque tuna judirunucataqui ama tunaja etareju. Tuequedya tuna huanataqui. Nubitinucataqui ama tuna tunaja caramati ishuque jiteque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Dyaque nerecadatu jubuque epuna maqui cuanaque, bacua nanaqui cuanaque jadya. Tuna tuna eje bucha huanataqui ama ebajarara cabatibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Nebacabacacue Yusu queja, micuana huanayaque huecaca cuejipa, nei, jadya ama juatsu canajara huecacaju micuana huanayaque huecaca ejuetiuju. ");
INSERT INTO cavNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ecuita Cuana Bajituraquique ejitaju juhuajutu dyaque canerecati ishuque anibuque. Ni eje tuputu jadya canerecati anihua ama Yusura yahua iyahua equeque tumeque huecaca judadibuque bucha. Ecuita Cuana Bajituraquique ijehuetanahuajutu aninucabuque ama jadique canerecati ni eje tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Dyaquetu Yusura iyuhueda baya tuja cuanaque, tura mepehua cuanaque. Jadya tibudyatu Yusura tumeque huecaca canerecati ishuque jununushabuque ama. Tura ni jadya ama eau, ni aira buchiquetu eiduu ama; ni ejequetu chacha ejuu ama. ");
INSERT INTO cavNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Aira cuejatsu ama micuana ique junanucahuaque bahue jubuque. Jadya tibudya ejera ‘Mesiastu junanucahua. Ecuanaja epujudya rique’ jadya ayaju, neejeneume. Ejera ni micuana aya: ‘Mesiastu junanucahua. Peya epuju tuque’ neejeneume. ");
INSERT INTO cavNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tume cuanaque huecaca juetihuaju tuna jetiama pusha pusha jubuque: ‘Ique Mesías, Yusuja Emepeque’ jadya ama juatsu ‘Ique Yusuja quisarati cueja ishuque cuita camadya’ jadya. Abuque tunajatu inimeradya jutidya ecuitaja ataquique ama. Eje uma tunajatu ecana ijahue abuque. Dutya tunajatu ecana cujishabuque. Yusuja cuanaque neri neri tunajatu ecana ijahue acara ebari abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Jida nebacacue. Icuenetadya micuana cuejahua riyaque, micuana ijahue eatauju. ");
INSERT INTO cavNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jadya tibudya, ejera jadya cuejayaju: ‘Mesiastu junanucahua. Yuqueja tuque’ neejeneume. Necuaume ique sarera tuhua. Cuejaya ni tunara micuana; ‘Mesiastu junanucahua. Rehuadyari catehua juya’ neejeneume. ");
INSERT INTO cavNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","IQUE ECUITA eje tupu junanucayaju, dutyaradya babuque. Dutyajadyatu babahue pupipupiyaque ijeti cuinanaya queja, ijeti nubiya queja; jadidya ique dutyara babuque junanucayaju. ");
INSERT INTO cavNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Eju ai emajuque ririyajutu jamani cuana caradatiya aija cuejatsu ama. Tumebaedyatu jubuque ique junanucayaju. Dutya tuna bahue jubuque, aija cuejatsu ama, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesúsra ecuana bahuityanucacuare: —Masadama huecaca cuana nerecada juishuque cuetiajeyaju cuitadyatu ijeti apunabuque. Baditu huecadama jubuque. Purari cuanatu barepa juque pacacabuque. Barepaju casada aniya cuanaque tuna piririterebuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ique masadama junanucayaque adeba ishuquetu barepaju ejitaju jubuque. Dutya yahuaju cuanaratu babuque. Baatsu tuna dyaque bajida juatsu pabuque. Tuequedya tunara IQUE ECUITA junanucayaju batsabuque. Ecue dyaque casa tsehue junanucabuque. Cabameretibuque ique eje bucha muitaeque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Meyamerebuque tuque jebuda barepa juque meya ishuque. Cuadishabuque tuque barepaju ique tsahuaqui cuanaque, ecue cuanaque dutya yahua queja aniya cuanaque sita ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Anibuquetu ique masadama junanucayaque adeba ishuque, masadama nei mara catibutinucayaque adeba ishuque aniya bucha. Ita taa acui higuera bacani neadebacue. Yaa cuana catapananatiyaju baatsu, micuana bahue amena nei mara catibutiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tumebaedya micuana dutya riya cuanaque era cuejahua cuanaque juajeya baatsu, bahuedya micuana jubuque yahua amena terehuieque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pusha amadya micuana cuejaya. Dutya riya cuanaquetu judadibuque iyacua ecuita cuana aniyaque majuma jarijudya. ");
INSERT INTO cavNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Arepa barepa, yahua jadya pana cuaretana jubuque ama bucha, dutya micuana era cuejahua cuanaquetu cuaretanatsu ama jadya judadibuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Yusu ecue Etata peadya camadyatu bahue ejeque huecaca ique junanucayaque. Tuque peadya camadyatu bahue huecadajuni, jadya ama juatsu meta eje tupu ique junanucayaque. Ni ejeque ecuitaratu adebaya ama. Ni ejeque barepaju Yusu tsahuaquiratu adebaya ama. Arepa ique Yusuja Ebacuaque ama bucha, eratu adebaya amadya. ");
INSERT INTO cavNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Noé anicuare patya, tuque cuaba ebariju nubima jarijutu ecuita jidama cuanaque anicuare; ni ecana Yusura nerecaturayaju canerecati ishu equihuati jucuare. Jadidyatu jubuque ique junanucahuie. Ecuita cuanatu jidamadya jutidya anibuque, Yusura eje bucha ayaque quihuatima. ");
INSERT INTO cavNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Beru tume patya, ena eque teretama jarijutu ecuita cuana anicuare tuna anietibehua buchadya jutidya. Araaraya; ijiijiya; huanequi juya; ebacujuna cuanaque, ebacua cuanaque caquemiti ishuque inime bajeje jadya anie tuna jucuare Noé cuaba ebariju nubicuare tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Muya jutidyatu ena shumaumaque ama jueticuare, tunara ihuayaju ama. Dutya tuna huiditerecuare. Jadidyatu jubuque ique junanucahuie. Ecuita cuanaratu adebabuque ama eje tupu ique junanucayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Tumeque huecaca ique junanucayajutu ecue cuanaque enityasicua jubuque ecue ama cuana ducuque. Beta ecuita teeju cuinetse mere ejuu. Ecuiquetu Yusu queja dujutanabuque. Peya bacue shanatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Beta epuna tuhua cuinetse eerieriu. Ecuiquetu dujutanabuque Yusu queja. Peya bacue shanatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Jadya tibudya nequihuaticue. Neihuajacaume ique junanucayaque, ai micuana bahue batune eje tupu Micuana Cuatsashaquique junanucayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ni ejeque etare metsequetu bahue ama ejeque ura chiri puji ejutiuque. Junayaque bahueque juatsutu ecabati ejuu, chiri puji etareju chiri ejutiuque naru. ");
INSERT INTO cavNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Micuana dyadi equihuatidya nejucue ique batsa ishu. Muya jutidya micuana eanau, ejeque huecaca ique junanucayaque baecua juya tibu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesúsra ecuana bahuityanucacuare: —Neihuacue ique, mayuruma jidara tuja patrón iyuhuedaque juetiyaque eihuau bucha. Mere puji yana equedya juyaquetu jida, inimequique. Micuanaja pana adeba aishu micuana cuejaya riyaque. Anicuaretu mayuruma. Tuja patronratu shanacuare tuque juneniya tupu tuja etareju cuanaque naru ishu. “Dutya huecaca ecana ara ishu cuanaque tyacue”, jadya patu tuja patrónra aquenacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Tumeque mayuruma ni amerehua eque juya, peya cuana ni tu narujacaya ama, dyaque pureamatu jubuque tuja patrón juetihuaju. ");
INSERT INTO cavNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Pusha amadya micuana cuejaya. Tura tuja patrónja mere puji cuana jida naruhua tibu tujatu dutya tuja ai aniya cuanaque narumereya. ");
INSERT INTO cavNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Mayuruma ni cuejataquima, amerehua eque amadyatu juya. Turani jadya inime tupuya: ‘Ecue patróntu juetihuishaya ama’ jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Amena jadya juatsu tujatu peya mere puji cuana nerecaturaya; ijahue ijahue jutidyatu ecana aya. Chine mere, araara, nijuqui arida cuana tsehue ijiijiya jadya tsehue jutidyatu ecana aniquereya, tuja mere ataqui ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Tumetu tuja patrón juetiya ni tuque quihuatiyaju, ni tuque juetinucayaque ura bahueju. ");
INSERT INTO cavNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jadya baetitsutu tuja patrónra catsacatsa, ijehue jadya aetiya tuja etare juque. Riyaque mayuruma baetu Yusuja cuanaquepa ejuu jadya juya cuanaque tuja yacua juque ijehuetanabuque. Tuhua ijahuaja etiquiju tuna dyaque canerecatiyaque, payaque etse tari jubuque, —jadya ecuana Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra bahue amerecara acuare tuque iyuhueda baqui cuanara ihuayaque; tuque iyuhuedama baqui cuanara bacue ihuaya ama jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jesúsra ecuana bahuityanucacuare: —Cuejaya micuana riyaque cuatsabiji Yusura naruyaju eje buchique micuana bahue juishu. Caquemitiyaque chinetu anicuare. Caquemitiyaja iyuhueda cuanaque tuna etsecueju neticuare tuque junayaque ihua juyaque. Peadya tunca epuna ehue ebari tuna jucuare. Peadya peadyajadya tunajatu lamparina anicuare etseri tsehue ejequeshaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","4","Pishica tuna inime adebabadaque jucuare. Icuenetadya tunajatu lamparina etseri tsehue jequeshacuare. Tumebaedya ecana botillaju etseri cadujuticuare, terehuaju lamparina jequeshanuca ishu, caquemitiyaque etsunutauque adebatsu. Pishicadya tuna inimema jucuare. Cadujuticuare ama ecana etseri lamparina urahuaju jequeshanuca ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Peadya tunca epuna ehue ebari cuana tuna tahuira jetiedya ahuaju tahuicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tume tuna metapatya quique eque aira cuana bushishacuare. “¡Jehuatu amena caquemitiyaque! ¡Netsurutsacue!” jadyatu ejeque cuana quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Dutyatu epuna ehue ebari cuana netitsuracuare. Tume tuna lamparina cabajejetitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yara tupu juatsutu pishica inimema cuanara adebacuare tunaja lamparina jequesha ishu etseri aijamaque. “Riya piji ecuana etseri netyacue. Ticuya tuque ecuanaja lamparina”, jadya tunajatu inime adebabada cuanaque acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Tunaratu quemitsacuare: “Aama. Aijama tuque ecuanaja etseri micuana tyaishu. Necuacue tunara catyati ayaju. Nequemiticue micuanaja”, jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jadya ahuaju tuna cuacuare etseri quemira. Tuna etseri bacara cuaya tsunumeedyatu huanequi juyaque junaticuare. Epuna ehue ebari equihuati jucuare cuanaque tuna tuatsehue nubipee jucuare, carisitihuaque chine juyaju. Nubitsu tunajatu etsecue tericuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Yara tupu juatsutu peya pishica epuna ehue ebari cuana juetinucacuare. “Nudyacue ecuana”, jadya tuna quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tura tuna pana teri ea eque quemitsacuare: “Aijama. Adebaya ama micuana era. Nedirucue”, jadya tuna caquemitiyara acuare. Jadyatu jucuare peadya tunca epuna ehue ebari cuana, —jadya ecuana Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—Nequihuaticue, ai micuana ique ejeque huecaca junanucayaque bahue batu. Baecua micuana huecadaju, jadya ama juatsu meta jadya ique junanucayaque, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jesúsra ecuana bahuityanucacuare: —Cuejaya micuana riyaque cuatsabiji Yusura dutya naruyaju eje buchique micuana bahue juishu. Anicuaretu ecuita chipirudaque. Peya yahuaju cuacaraquetu jucuare. Ihuaracuare tujatu tuque merequi cuanaque. Ihuaratsu tujatu ecana acuare: “Ique juneniya jari tupu jida nenarucue tumeque chipiru peadya peadyaja ishu era micuana tyabareyaque. Neumanashacue”, jadya tujatu peadya peadya cama mere puji cuana abarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Dutya tupu ama tujatu ecana chipiru tyabarecuare. Peadya tujatu tyacuare pishica mil chipiru, peya bacue beta mil, peya bacue peadya mil. Tyabarecuaretu ecana tunaja umanashataqui tupu adebatsu. Tuna chipiru tyabaretsutu cuacuare japada. ");
INSERT INTO cavNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Pishica mil tyatanahuaquetu meredya jucuare chipiru tsehue. Chipiru tsehue jida mere juatsu tujatu tuja patrónra chipiru tyahuaque beta tupu amerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Beta mil tyatanahuaquetu meredya jucuare chipiru tsehue. Chipiru tsehue jida mere juatsu tujatu tuja patrónra tyahuaque beta tupu amerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mil tyatanahuaquetu tuja patrónra amereya eque ama jucuare. Dirutsu tujatu tuja patrónja chipiru yahua puru jadya aatsu papacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Eje uma badi juatsutu juetinucacuare tunaja patrón tuna queja. Ihuarabarecuare tujatu chipiru tyaquenacuare cuanaque. Bahuetu jucara jucuare tunara chipiru eje bucha acuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Icuenetu juticuare pishica mil chipiru tyatanacuareque. Tyatsacuaretu tuja patrón pishica mil chipiru tuja cuare tyanuca aishuque, tura pishica mil mere aatsu umanashacuare tsehuedya. ‘Ique mira tyacuare pishica mil chipiru. Jeedya micue, peya pishica mil tsehue, era mere juatsu umanashacuareque’ jadya tujatu tuja patrón acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Jida. Jidaque ecuita yana equedya juhuaque mique. Miratu pana tsume ahua era riya piji tyacuareque. Tume mique tyaya mere dyaque muidaque. Eatsehue pureama jupeedyami juya ecue jidaque aniya tsehue’ jadyatu tuja patrónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tuequedyatu jutinucacuare beta mil chipiru tyatanacuareque. ‘Ique mira tyacuare beta mil. Jeedya micue, peya beta mil tsehue, era mere juatsu umanashacuareque’ jadya tujatu tuja patrón acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Jida. Jidaque ecuita yana equedya juhuaque mique. Miratu pana tsume ahua era riya piji tyacuareque. Tume mique tyaya mere dyaque muidaque. Eatsehue pureama jupeedyami juya ecue jidaque aniya tsehue”, jadyatu tuja patrónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Tupujutu jutinucacuare mil chipiru tyatanacuareque. Junatitsutu anaticuare tuja patrón: ‘Ique bahue micue peya cuana tsehue canerecabati aijamaque. Ique taa bahuedya jucuare mira ecue riya piji aniyaque secanucabuqueque. Arepa ecuanaradya tee cuana uhuahua ama bucha, miratu huesamereya micue ishu cuita camadya. Arepa ecuanara iruruya ama bucha, dutyadya tu micue etsucaca cuana quiniquique jequesha ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jadya tibu bajida jucuare, mira era aputashahuaju cuana jidama eauju. Bajida juatsu tuque micue chipiru yahua purutsu papatsu tehuacuare. Jeedya micue ique mira tyacuareque’ jadya tujatu tuja patrón acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘¡Cuejahuanataquima! ¡Dyaini! Iyacuami bahue juya. Era camadyapa tsumehua dutya ecue ishu camadya micuanara uhuahuaque. Erapa ecue etsucaca iya ishuju iyahua dutya micuanara iruruhua cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jadya mira ejeneya tibu taa tuquemi dujuquena cuana dyadi juquena jucuare chipiru umanashaqui cuana queja. Tume taa tuque junanucatsu equeminau mil chipiru tumeque umanashaqui cuana queja tyacuareque juatsu. Tume tuque ecue chipiru eumana tsehue inapee aquena juhua’ jadyatu tuja patrónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Isaracuare tujatu tuhua jucuare cuanaque: ‘Nesecacue chipiru tumeque mere puji cuejataquimaque. Netyacue peadya tunca mil umanashaqui juhuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ejeja aniyaquetu dyaque tyatanabuque. Tuja aniyaque dyaquedyatu tyatanabuque. Ejera ni jidama tsumeya tuque tyatahuaque, secatabuquedya tuque, arepa riya piji tuja aniya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Riyaque mere pujiratu tuque tyatahuaque jida ama tsumehua. Apuda ducu neijehuecue. Tuhua dyaque canerecatiyaque payaque etse tari paju’ jadyatu tuja patrónra acuare tuhua jucuare cuanaque. Jadyatu jucuare mere puji cuana chipiru tyatacuare cuanaque, —jadya ecuana Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra huecashacuare, Yusu ecuanaja dutya casa tsehue meretaquique tura ecuana casa tyaya tsehue.) ");
INSERT INTO cavNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesúsra ecuana bahuityanucacuare: —IQUE ECUITA junanucatsu, huaraji dyaque aridaque bucha junanucabuque. Barepaju ique tsahuaqui cuana tsehue junanucabuque. Junanucatsu anibutebuque dyaque emui judadiyaju, ique Yusura tuque cuarequi enaruquique jadya ishu cuatsashahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Cuadishabuque tuque barepaju ique tsahuaqui cuanaque dutya ecuita dutya yahua juque, epu cuana juque sitabare ishu. Uhuisha naruquira uhuisha cuana, cabra cuana ducuque ejaquebareu buchatu era ecue cuanaque jaquebuquedya ecuique ama ducu cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Iyabuque tuque ecue cuanaque jida eque amaca, eaniqui muidaju tunaja tuna muitaqui juishu. Ecue ama cuanaque tuque iyabuque jani eque amaca, ecue cuanaque pana jacamere aishu. ");
INSERT INTO cavNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ecue jida eque amaca cuanaque tuna abuque: “Nejecue eatsehue. Ecue Etata Yusura micuana dyaque jidaque tyabuque cuanaque micuana tyaya, yahua iyatanahua eque era ecue cuanaque tyaana ahuaque. Nebaeticue era micuanaja ishu bajejeeticuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aracara juyaju micuanara tyahua ara ishuque. Ijicara juyaju, micuanara tyahua iji ishuque. Ique tarema juneniyaju, micuanara nudyahua micuanaja etareju. ");
INSERT INTO cavNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jutuquima juneniyaju micuanara tyahua jutu ishuque. Ujejeda juyaju micuanara cuajitihua chachanecara aatsu. Etare apudaju netiyaju baatsu micuanara batihua ique nime casatura ishu”, jadya tuna era abuque ecue cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Tume era jadya ayaju tuyu jucuare cuanara quemitsabuque: “Ecuana Cuatsashaquique, caadebatiya ama taa ecuana eje tupu mique ecuana arama, ijima jadya baatsu mira ai sareyaque tyahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Caadebatiya ama ecuana eje tupu mique tarema bucha juneniyaju etareju nudyahuaque, ni eje tupu mique jutuquima baatsu tyahuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Caadebatiya ama ecuana eje tupu mique ujejeda baatsu ni etare apudaju baatsu mique ecuana tsahuacara aatsu batihuaque”, jadya tunara abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Era tuna quemitsabuque: “Pusha amadya cuejayadya micuana era. Micuanaratu ecue cuanaque tyahua tunaja ai aijama cuanaque. Micuanaratu tsahuahua ecue eatsehuequi cuanaque buchique. Ejera dyaque jetiedya buchique tsahuahuaque, idya cuitadya tura tsahuahua”, jadya tuna abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Tuequedya tuque ecue cuanaque ama abuque: ‘¡Japada nejucue cuejahuanataquima cuana! Nenubidirucue ijahuaja, tuque tsahuaqui cuanaja jadya ishu etiqui eiyaju. Tuhua micuana canerecatijacanime ama. ");
INSERT INTO cavNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ique aracaraque juneniyaju micuanara tyahua ama ara ishuque. Ijicaraque juneniyaju micuanara tyahua ama iji ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ique tarema bucha juneniyaju micuanara nudyahua ama micuanaja etareju. Jutuquima baatsu micuanara tyahua ama jutu ishuque. Ique ujejedaju etare apudaju netiya baatsu micuanara batihua ama ique nime casatura ishu’ jadya tuna era abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Era jadya ayaju tunara jadya abuque: ‘Ecuana Cuatsashaquique, ¿eje tupu jatsu mique ecuana tsahuacarama acuare? ¿Eje tupu jatsu mique ecuana arama ijima, tarema, jutuquima, ujejeda, etare apudaju jadya baatsu tsahuacuare ama?’ jadya tunara abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Era tuna quemitsabuque: ‘Pusha amadya cuejaya micuana era. Micuanaratu ecue cuanaque, ecue eatsehuequi cuanaque buchique tsahuahua ama ni dyaque jetiedya bucha cuanaque. Tuna tsahuahua ama tibu, idya micuanara tsahuahua ama’ jadya tuna abuque. ");
INSERT INTO cavNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jadya cuanaque tuna canerecati ishuju nubidirubuque ni eje tupu cuinana ishu ama. Yusuja biji eque juya cuanaque tuna Yusuja yacuaju judirubuque ni eje tupu tuque jaca ishu ama —jadya tura ecuana cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jadya cueja amena aatsu tura ecuana tura mepehua cuanaque cuejanucacuare: ");
INSERT INTO cavNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Micuana micuana bahuedya metajudya tibene Pascua chine juyaque. Riyaque chine ishudya ique ujeu baqui juya cuanara inamereya curusuju tatamere ishu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesúsra ecuana isaraya jarijutu pae cuanaja huaraji cuanara, israelita cuana emuiba cuanara jadya inime tupucuare eje bucha iyemere Jesús aishuque. Casitaticuare tuna Caifás pae dyaque muidaja etareju. ");
INSERT INTO cavNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tuhua tunajatu Jesús iye ishu, tseta inamere aishu inime bajejecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—Neinamerera ama Pascua chine ishu cuita, ecuita cuana ecapuritishau tibu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesústu Betaniaju jucuare Simónja etareju. Icuenetu tumeque ecuita erami ririshaqui ujeje tsehue jucuare. Jadya tibudya tunajatu “Leproso” jadya isarae acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Chineju araarayajutu Jesús epunara jipeticuare botilla caca alabastro eaque ina jadya. Tumeque botilla cacatu etseri ijimeda tsehue ejequeshaque jucuare, dyaque tsuje aridaque. Jesús mesaju juaniyajutu epunara etseri ijimedaque tuja iyucaju juraticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Epunara jadya aya baatsu ecuana Jesúsra mepehua cuanaque cahuaiticuare. —Nepetacue tura etseri dyaque tsuje aridaque ijehueneyaju. Ni aishu buchiquetu jida ama jadya ijehuenetsu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Catyati ni tu aquena juhua etseri ijimedaque, umada tujatu chipiru inaquena juhua. Jetiamatu nerecada cuanaque etsahuauque chipiru inatsu, —jadya ecuana jucuare ecuana cama. ");
INSERT INTO cavNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ecuana quisaratiyaju bacatsu ecuana Jesúsra ecuana acuare: —¿Eje bucha juatsu jatsu tuque micuana tumeque quisarati tsehue aya? Tura ique jadya ahuaquetu dyaque jidaque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Micuana ducutu jujacaya amadya nerecada cuanaque, ique bacue aijama. Ique micuana tsehue junenisiriya ama. ");
INSERT INTO cavNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tura ecue ecuitaju etseri ijimedaque jurahuaquetu ique iyetahuaju papata ishuque, tura jadya ahua. ");
INSERT INTO cavNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pusha amadya micuana cuejaya. Riyaque epunara jadya ahuaque tuna dutya yahuaju bahue jubuque, eju ecue quisarati jidaque cuejatanayaju, ecuita cuanaja tuque adeba ishu, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tumetu Judas Iscariote, Jesúsra mepehuaque, cuacuare pae cuanaja huaraji cuana queja. Junatitsu tujatu ecana isaranaticuare: ");
INSERT INTO cavNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—¿Eje uma micuanara tsujetyaya, era micuana Jesús inamereyaju? —jadya tujatu ecana bacaduraticuare. —Quimisha tunca chipiru. —Eratu aya tumeque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tumeque huecaca equeratu Judasra Jesús eje bucha inamere aishuque sarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jueticuaretu icueneque huecaca Pascua chine ecuanaja pan levaduramaque ara bahueque huecaca. Tumeque huecaca tuque ecuana Jesús jipetitsu bacaduracuare: —¿Ejumi bajejemerecara aya riyaque chineju Pascua ishu araara ishu? —jadya tuque ecuana aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tura ecuana quemitsacuare: —Jerusalénju nebajejeticue. Eisaradya tuque ecue ecuita tuja etareju araara ishu. Necuacue. Necuejaticuedya tumeque ecuita: “Ecuana Bahuityaquiquetu jeya. Amena patu ura japadama tuque iyetayaque. Junaya patu micue etareju Pascua juyaque chineju araarara tura mepehua cuana tsehue”. Jadya necuejaticue, —jadya tura ecuana amerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesúsra cuatsashahua equedya ecuana jucuare. Tuhuadya tuque ecuana bajejecuare Pascua juyaque chineju ara ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Amena apunahuajutu Jesús ecuana tura mepehua cuana tsehue mesaju anibutecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Araarayara ecuana Jesúsra isaracuare: —Peadyara micuanara ique ujeu baqui cuana queja inamereya, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jadya ayaju ecuana peya inime jucuare. Peadya peadyara tuque ecuana bacadurabarecuare: —¿Era ni taa, Ecuana Cuatsashaquique? —jadya tuque ecuana abarecuare dutyara. ");
INSERT INTO cavNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—Eatsehue peadya pejaju araarayara pan mullayara inamereya. ");
INSERT INTO cavNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bérutu Yusu equeque quisarati cueja puji cuanara huenecuare ecuita jidama cuanara ique iyebuqueque. Tunaja quisarati ehuene equedyatu juya. ¡Dyaque nerecadatu jubuque ique ujeu baqui cuana queja inamerequi juyaque! Dyaque jida taa tu tumeque ecuita ecuaquera ejitaju aquena ama juhua, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jadya bacatsutu Judas tuque inamerequi juyara acuare: —Ique Cuatsashaquique, ¿era ni taa mi jadya amereya? —Jejee, mira quisarati aya equedya, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Araarayaquetu Jesúsra pan inacuare. Pan inatsu tujatu —Yusurupai mique aya, Tata, —jadya Yusu acuare. Yusurupai jadya aatsu tujatu pan cuesicuare. Cuesitsu tura ecuana tuatsehue anibareya cuanaque tyabarecuare. —Nearacue. Riyaque pan rique ecue ecuita, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tuequedya tujatu canecu juque uva nacaca esasanashaque inanucacuare. Canecu inatsu, —Yusurupai mique aya, Tata, —jadyatu Yusu acuare. Yusurupai aatsu tura ecuana sadatsu inamerebarecuare. —Neijicue jeeque canecu juque uva nacaca esasanashaque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Riyaque rique ecue ami, micuana jiteque quijehuetiyaque. Jetiama tuna eaqueja catyatibuque, tunaja jucha cuana tillatana ishu. Ique ecue ami quijehuetitsu majuhuajutu Yusura iyaya iyacuaque inime tuaqueja judiru ishuque. Ique majuhuaju piisitu riyaque inime yunerinetanaya. ");
INSERT INTO cavNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Riyaque micuana cuejaya. Ni eje tupu tuque riyaque yahuaju Pascua chine micuana tsehue anucaya ama; ijinucanime ama tuque ecue uva nacaca esasanashaque. Jadya ama buchatu tumeque huecaca, era dutya naruyaque huecaca juetihuaju piisi tuque ijibuque micuana tsehue iyacuaque eijiqui, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Chineju araara amena juatsu tuque ecuana Yusu pureama aishuque jeru acuare. Jeru amena juatsu ecuana cuacuare uhua cuemusu “Olivo Acui Quini” bacaniju. ");
INSERT INTO cavNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tuhua ecuana Jesúsra isaranucacuare: —Riyaque meta micuanara era ijahue ahua bucha cabatitsu jacatillaya. Yusuja quisarati tu ehuene: “Tuna aquereniquiquetu iyetanabuque. Dutya tura aquerenihua cuanaque tuna tsapetanabuque, uhuisha cuana naruquique iyetanahuaju etsapetanau bucha”. ");
INSERT INTO cavNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Emajuque netitsuranucatsu icuenetadya cuaya Galileaju, tuhua micuana tsehue catsurutinuca ishu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jadya juyajutu Pedrora acuare: —Arepa dutyara jacatillaya ama bucha, ecuemi jacanime ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—Pusha amadya mique aya. Riyaque meta, tacure quiquehuiemi catehuati quimisha juya. “Adebaya ama tuque era”, jadya aquimisha mira aya, —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—¡A, aijama! Mique adebaya ama jiu junime ama ique. Miatsehue iyepeedya datse tunara paa. “Tujaque ama ique” jadya junime ama ique, —jadyatu Pedrora Jesús acuare. —Mique adebaya ama jiu junime ama ique, —jadya tuque ecuana abarecuare, Pedrora aya baedya. ");
INSERT INTO cavNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tumetu Jesús junaticuare ecuana tura mepehua cuana tsehue Getsemaní bacani emajacaju. Tuhua junatitsu tura ecuana anaticuare: —Rehuadya neanibutecue, ique ecue Etata tsehue quisaratiya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jadya juatsu tujatu dujucuare Pedro, Zebedeoja ebacuaque ecatse jadya. Cuacuare tuna ecuana japada cuita ama. Dyaque peya inime, niju huenanada, eje buchadya jucara jadyatu cabatiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—Dyaque peya inime taa cabatiya. Idutaqui ama jipenee cuita taa rique baya. Rehuadya neanicue. Ecabati nejucue. Netahuiume, —jadyatu Jesúsra acuare Pedro, Santiago, Juan jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jadya tuna aatsutu Jesús cuacuare eje japa cuita amadya. Cuaatsutu chichucata junaticuare, yahua queja huipuchitana. Jadya juatsutu Yusu tsehue quisaraticuare: —Tata, riya ique nerecada jutaquique tu ai patseda buchique. Canerecatitaquique ama juatsu taa ecanerecatiu ama. Ebacau datse mique era, ique canerecati ishu ama. Jadya ama bucha ecue biji eque ama paju. Micue biji eque paju, —jadyatu Jesúsra acuare tuja Etataque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jadya juatsutu cuanucacuare quimisha tura dujuhua cuana queja. Cuaatsu tujatu ecana tahuijarabareyaju baticuare. Isaranaticuaretu Pedro: —¿Eje bucha eatsehue ecabati jupee jutaqui ama micuana yaratupu cuana cabatihua, ni peadya ura cuana? ");
INSERT INTO cavNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Necabaticue. Netahuiume. Nebacabacacue Yusu queja, micuana Satanásra ique jacamerecara ayaju, micuanaja idu ishu. Micuanaja tacatu aijama casa Ijahuara cajuchatishacara ayaju casada juishu, arepa micuanara jacacarama aya ama bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Cuabeta ishutu Jesús cuacuare tuque cuahuaju nucadya, Yusu tsehue quisaratira: —Tata, canerecatitaquique ama juatsu taa ique ataya bae eatau ama. Jadya ama bucha ecue biji eque ama paju. Micue biji eque paju, —jadya ati beta tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jadya juatsutu cuanucacuare tura quimisha dujuhua cuana queja. Cuanucatsu tujatu ecana tahuijarabareyaju batinucacuare. Busataqui ama cuita tunajatu yatuca bacuare tahuicara juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Tuna shanatsutu cuaquimisha ishu cuanucacuare Yusu tsehue quisaratira. Tuque quisaratihua baedyatu quisaratitinucacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jadya juatsutu cuanucacuare tura dujuhua cuana queja. —¿Canajaraya jari cuitadya micuana? ¿Tahuiya jari cuitadya ni taa micuana? Amenatu ura juetihua IQUE ECUITA tunara jucha arida cuana queja inamereyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Nenetitsuracue. Nedirura. Amenatu jehua ique ujeu cuana queja inamerequi juyaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús quisaratiya jarijutu Judas junaticuare, tura mepehuaquedya datse. Ecuita jetiama tsehuetu cuacuare. Cuchiru tsehue, acui tsehue jadya tuna junaticuare. Pae cuanaja huaraji cuanara, israelita cuana emuiba cuanara jadya tuna cuadishacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Junatima jariradya tuna Judasra cuejanaticuare: “Era dyahuanatiyaque, tudya tume. Risitsu, nedujucue”, jadyapa tujatu ecana junatimaradya anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Junatitsu tujatu Jesús jipeticuare: —Banuchi, Ebahuityaquique. Jadya aatsu tujatu Jesús dyahuanaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tura jadya ayajutu Jesúsra isaracuare jadya: —Acuedya mira ai acara aya eque, era mepehuaque, —jadyatu Jesúsra acuare. Jesús dyahuahua baatsutu Judas tsehue cuahua cuanara jipetitsu inaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jesúsra mepehuaratu cuchiru baeque baina juque juputsu pae dyaque muidaque merequique ijaca pejucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—Cuchiru tsehue icuenecara aume. Ishacue micue cuchiru bainaju. Miratu adebayadya quisarati: “Cuchiru tsehue quiyetiyaquetu cuchiru tsehuedya iyetabuque” jadique. ");
INSERT INTO cavNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Sareya ama tuque era micue ique icuene ishu. Eratu Etata ebacaudya peadya tunca beta earacana cuare barepaju Yusu tsahuaqui cuanaque ique icuenena ishu. Masadamadya tujatu ecana ecuadishau. Jadya ama bucha bacaya ama tuque era. ");
INSERT INTO cavNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ehuenedya tu Yusuja quisarati ique nerecada judadiyaque. ¿Eje bucha judadie jatsutu ejuu, jadya judadi ishuque era barepa juque etsahuaqui cuana ique tsahuana ishu bacahuaju? —jadyatu Jesúsra acuare ecuita ijaca pejuquique. ");
INSERT INTO cavNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Tuequedya tujatu isaracuare ecuita cuana jetiamaque: —Micuana micuana jehua cuchiru tsehue, acui tsehue jadya ique inara, chiri puji inara ejeu bucha. Anichinedya tuque micuanaja emajaca ejudya jutidya ique ina ishu cuchiruma, acuima. Dutya huecaca taa ique Yusuja etareju Yusuja quisarati bahuitya juchine. ¿Tume micuanara eje bucha juatsu inachine ama tuhua? ");
INSERT INTO cavNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Riya ique atayaqueri juya Yusu equeque quisarati cuejaqui cuanara cuejacuareque, Yusuja quisaratiju ehuene bae cuitadya, —jadya tuna Jesúsra acuare. Tuque quisaratiya tsunumeedya ecuana Jesúsra mepehua cuanaque huanaterecuare. Jacacuare ecuana Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús inaqui cuanaratu Jesús dujucuare Caifás, pae dyaque muidaja etareju. Tuhuatu ecasitati jucuare cacuatsashati bahuityaqui cuanaque, tumebaedya israelita cuana emuiba cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Tumetu Pedrora tunara Jesús dujuyaju japa tupuaje acuare. Cuacuaretu pae dyaque muidaja etare tsecue tupu. Etare tsecue junatitsutu sudaru cuana tsehue aninaticuare, eje bucha tuna Jesús ayaque petacara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Huaraji cuana tuhua ecasitati jucuare cuanaratu tyacara acuare Roma juque huaraji, tuque iyemere ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jadya ama bucha tunajatu dadicuare ama eje bucha eque jidama cueja ishu. Jetiama tuhua jucuare cuanaratu pusha pusha tsehue jidamapa ejuu jadya acuare. Daditaqui ama tunajatu bacuare dutyara tupu tuque jidama ejuque. Eje uma quisaratiyaju baca jadya aatsu tatse beta netitsuranucacuare quisarati ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Yatseratu Jesús jadya quisaratiyaju bacachine: “Eratu Yusuja etare rihuishatsu puririsha jadya aatsu, quimisha huecacaju enityatsuranucau”, jadyari juchine, —jadyatu ecuita ecatse jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tatse jadya juyaju bacatsutu pae dyaque muidaque netitsuracuare. Turatu Jesús bacaduracuare: —Bacahuadyami ecatse micue ishu quisaratiyaju. ¿Caquemitsatiya ama cuitadya mique? ¿Jadidyami quisaratichine, jadya ama ni taa? ");
INSERT INTO cavNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesústu caquemitsaticuare ama. Yudijidyatu pae dyaque muidara bacaduranucacuare: —Yusu aniyara mique quisaratiyaque bacayaque adebatsu, tuyudya cacuejaticue. ¿Midyami Mesías, Yusuja Ebacuaque, aijama ni taa? ");
INSERT INTO cavNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—Jejee, Mesiasdya ique; Yusuja Ebacuaque ique. Tumebaedya mique cuejaya. Ejeque huecaca micuanara ique babuque Yusuja jida eque amaca eaniqui muidaju aniyaju. Tumebaedya micuanara babuque barepa huani ducu eque junanucayaju, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jadya quisaratiyaju bacatsutu pae dyaque muidaque cahuaiticuare. Cahuaititsutu una cachajaticuare, dyaque cuita ecahuaitique ejitaju juishu. —Riyaque ecuitarari Yusu cahuaitishaya tuja quisarati tsehue. Sareya ama tuque ecuana peyaja riyaque jidama juchineque cueja ishu. Micuanaratu bacahuadya tura quisarati jidamaque ayaju. ");
INSERT INTO cavNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Eje bucha micuana amerecara aya? ¿Iyemerecara, iyemerecarama ni taa? —jadya tujatu acuare peya huaraji cuana. —Jucha metse tuque. Pamajudya, —jadya tuna caquemitsaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jadya aatsu tunajatu ebutsequiniju ecuedira acuare. Miricuare tunara. Peya cuanaratu bahuapajacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Yuneridya ni mi Mesías, Yusuja Emepeque, caadebaticue. ¿Aira taa mi bahuapajahua? —jadya tunajatu ijahue ayaquedya jutidya acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Jadya juya tsunumeetu Pedro etare tsecue juanicuare. Juaniyajutu epuna mere pujira jipeticuare. —Miquemi Jesús Galileaju tsehue junenihuaquedya, —jadyatu Pedro epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedrotu dutya tuhua cuanaja ijacaju catehuaticuare. —¡Aijama, mama! ¡Adebaya ama tuque era! ¿Ejeque cuana taa tuquemi jadya aya? —jadyatu Pedro caquemitsaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Tuequedyatu etare tsecue enubitaquiju netidirunucacuare. Tuhua junetiyajutu peya epuna mere pujira banucacuare. Baatsu tujatu anucacuare: —Riyaque ecuita ri Jesús Nazaretju tsehue junenihuaquedya, —jadya tujatu acuare tuhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—¡Aijama, mama! ¡Adebaya ama tuque era! Yusu bahue ique yuneri quisaratiya, —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Yaratupu juatsutu tuhua cuanara jipeticuare. —Yuneri cuitadyami mique Jesús tsehue junenihuaquedya. Micue quisarati tu Galileaju aniya cuanaja quisarati cuitadya, —jadya tunajatu Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tunara jadya ayajutu Pedro caquemitsaticuare: —¡Aijama! ¡Adebaya ama tuque tumeque ecuita! Yusu bahue ique yuneri quisaratiya. Ique yuneri ama juyaque juatsu, Yusura panerecatura, —jadya tuna Pedrora acuare. Tuque jadya quisaratiyaju cuitatu tacure quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jadya juyajutu Pedro huecatanacuare. Caadebaticuaretu Jesúsra jadya cuejachineque: “Tacure quiquehuie mira tehua quimisha aya. ‘Adebaya ama tuque era’ jadya mira aquimisha aya”. Jadique adebatsutu Pedro tsajaja cuinana juatsu paa ebari jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Apudajudya tunajatu dutya pae cuanaja huaraji cuanara, israelita emuiba cuanara jadya inime bajejecuare Jesús iyemere ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Erisi tunajatu Pilato Roma juque enaruqui cuarequi queja dujumerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas tuque inamerequique juhuaratu bacuare tunara Pilato queja iye ishu dujumereyaju. Jadya baatsu tujatu jidama inime jucuare tura inime ahuaque caadebatitsu. Dyaque peya inime tsehuetu cuacuare israelita emuiba cuana queja, pae cuanaja huaraji cuana queja jadya, quimisha tunca chipiru tunara tsujetyahuaque yudijidya tyanucara. ");
INSERT INTO cavNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Cajuchatihua ique, era ecuita jidaque eje buchique ama iye ishu inamerehua tibu, —jadya tuna Judasra aticuare. —Tyanucaume ecuana riyaque chipiru. Ecuana ama ecuana inime metse. Miaquejadyatu tumeque inime, —jadya tunajatu atsacuare Judas. ");
INSERT INTO cavNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jadya atsayajutu Judasra tuhuadya Yusuja etareju chipiru marecuare. Tuhuaque cuinanatsutu capitirisititsu quiyeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Pae cuanaja huaraji cuanaratu chipiru huesacuare yahuaju mare ijehue ahuaque. —Riyaque chipiru tsehue tuque ecuana iyemere ishuque tsujetyahua. Jadya tibu tuque ecuanaja iyataqui ama Yusu tyayaque cajaju. Ecuanaja cacuatsashati equetu en ataqui ama, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yaratupu juatsu tunajatu inime bajejecuare israelita ama cuanaque majuyaju papa ishuque yahua quemi ishu. Tumeque chipiru tsehue tunajatu quemicuare mechi jaba puji cuanara sura ishu mechi quemiyaque yahua. ");
INSERT INTO cavNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Riya cama jaridyatu tumeque emajaca emaju cuanaque papa ishuque “Quiyeti pujija chipiru tsehue equemique emajaca” bacani. ");
INSERT INTO cavNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jadya equetu Jeremías Yusu equeque quisarati cuejaquira icueneta cueja acuare bae cuitadya judadicuare. Tura patu huenecuare: “Inacuare tunajatu quimisha tunca chipiru metal eaque. Riyaque etsujequi tu Israel eque ejuracana cuanara iyacuareque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tumeque chipiru tsehue tunajatu yahua quemicuare mechi jaba puji queja, Ecuana Cuatsashaquira cuatsashahua eque”, jadya patu Jeremiasra huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesústu Pilato Roma juque enaruquique cuarequija yacuaju netiticuare. —¿Midyami israelita cuanaja ecuari? —jadyatu bacaduracuare Pilatora. —Jejee, mira aya equedya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Pae cuanaja huaraji cuanara, tumebaedya israelita emuiba cuanara jadyatu Pilato cuejacuare eje bucha juatsu tuna Jesús tuaqueja dujuyaque. Jesústu tunara pusha pusha cuejayaju caquemitsaticuare ama. ");
INSERT INTO cavNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—¿Bacaya amami ecana micue ishu dutya jidamaque quisarati ayaju? ¿Eje bucha juatsu tuquemi ecana quemitsaya ama? —jadyatu Pilatora Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusratu quemitsacuare ama ni peadya quisarati tsehue. Jadya baatsutu enaruquique anajacatacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Dutya maratu Pilatoja bahue jucuare Pascua chine ishu etare apudaju erisi netiyaque inajaca, ecuita cuanara peadya ejeque inajacamerecara ayaque camadya. ");
INSERT INTO cavNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tume patyatu erisi neticuare ecuita etare apudaju dutyara adebayaque Jesús Barrabás bacani. ");
INSERT INTO cavNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Jetiamatu ecuita cuana apudajudya Pilatoja etare tsecue casitaticuare. Pilatora tuna bacaduracuare: —¿Ejeque micuanara inajacamerecara aya? ¿Barrabás, Jesús “Mesías” jadya catiyaque ni taa? —jadya tujatu ecana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Turatu adebacuaredya ecuita cuanara ama Jesús ujeu bayaque, tunaja huaraji cuanara camadya. Bahuedyatu jucuare jishatsu huaraji cuanara Jesús inamerehuaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato ecuita cuanara quemitsayaque ihua juyajutu ehuanequera cuejamerecuare: —Iyemereume bacue mira Jesús tuyuque. Eratu dyaque jidama inime ishu baya. Tahui ique juchine tuatsehue dyaque jidama, —jadya tujatu yahuique cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jadya ama buchatu pae cuanaja huaraji cuanara, israelita emuiba cuanara jadya ecuita cuana acuare: —Dyaque jidatu Barrabás inajacataqui, Jesús bacue iye. Jadya necuejacue Pilato tura bacaduranucayaju, —jadya tunajatu ecuita jetieque ama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yara tupu juatsu tuna Pilatora bacaduranucacuare: —¿Ejeque micuanara inajacamerecara aya? —¡Barrabás! —jadya tuna caquemitsaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—¿Tume ique ai juya Jesús tsehue? ¿Ai ique juya tunara Mesías bacani jadya aya tsehue? —jadya tujatu ecana bacaduracuare. —¡Curusuju tatamerecue! ¡Tuhua pamaju! ");
INSERT INTO cavNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Eje bucha juatsu? ¿Ai tujatu jidama achine? —jadya tuna Pilatora acuare. Abacatanacuare ama tuna quiqueyaque: —¡Curusuju tatamerecue maju ishu! ");
INSERT INTO cavNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatoratu adebacuaredya inime eje bucha cuarenucataquique ama. “Ique ni tunaja biji eque ama ejuu, tume tuna dyaque sicacadadya jutidya ecahuaitiu eatsehue”, jadya tujatu inime jucuare. Tume tujatu jadya bahue juatsu bañadoraju ena quetimerecuare. Emetucutu cutsaticuare ecuita jetiamara bayaju, tuque amapa inime metse jadya cabamereti ishu. —Ique ama inime metse riyaque ecuita iyetanayaju. Micuanadya micuana inime metse, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dutya tuna caquemitsaticuare: —Ecuana inime metse paju. Tumebaedya ecuana eque juracanaya cuanaque inime metsedya paju, —jadya tuna quique eque jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jadya bacatsutu Pilatora inajacamerecuare Barrabás. Tuequedya tujatu Jesús menajetyacuare sudaru Romaju cuanaque, tunaja catsacatsa, curusuju tata jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Icuene tunajatu dujucuare Pilatoja etareju, tuja sudaru cuana tahui ishuque etareju. Dutya sudaru cuana capiretishatsu tunajatu tuna patya nityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ijahue ayaquedya jutidya tunajatu ecuari edujuta bucha dujue acuare. Dyaque jutuyaque tacatsu tunajatu jutumerecuare una sehuesahuauque, ecuari arida cuanaja ejutuqui tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Iyucaju tunajatu jutumerecuare cunu sahua cuija epicaque, acui sari jida eque amaca inamere jadya. Tuque jadya aatsu tuna tuja yacuaju chichucata jucuare, tuque ijahue ayaque. —¡Emuita paju israelita cuanaja ecuari muidaque! —jadya tuna jucuare tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ecuedira tuna acuare. Acui secatsu tuna tuatsehuedya iyucaju acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jadya ijahue ijahue amena aatsu tunajatu tacanucacuare una sehuesahuauque, tujaque cuita una jutumerenuca ishu. Jadya aatsu tunajatu curusuju tata ishu dujucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Epu ebari juque cuinanayara tunajatu tsurutsacuare ecuita Cirene juque, Simón bacani. Casada tsehue tunajatu curusu mapemerecuare Jesús tatatana ishu juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jadya junatie tuna jucuare Gólgota bacani emajacaju. Tumequetu jucuare uhua cuemusu, emaju iyuca baeque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tuhua tunajatu Jesús ijimerecara acuare uva nacaca esasanashaque patseda tsehue eujaque, ecuita uje cuana ujejarasha ishu. Riya piji chibatsutu Jesúsra ijicarama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jadya aatsu tunajatu curusuju tatacuare. Curusuju amena tatatanahuaju tuna dadu ijahue jucuare, Jesúsra jutuhua cuanaque ejeja ejeja juyaque tuna cama cajaquetibare ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jadya juatsu tunajatu petaanibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Anibutema jarira tunajatu tauraju ehueneque shuracuare ebarucue tuja iyuca dyaque. Taurajutu ehuene jucuare eje bucha juatsu Jesús curusuju tatatanahuaque bahue amere ishuque. “Riyaque ri Jesús, israelita cuanaja ecuari”, jadyatu ehuene jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Tumebaedya tunajatu beta ecuita casada tsehue ai secaquique ecatse curusuju tatacuare, Jesúsja jida eque amaca, peya jani eque amaca jadya. ");
INSERT INTO cavNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Tueque cuetiya cuanaratu ijaribacuare iyuca huinu huinu tsehue tuque asicaba, bijidamadura jadya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Miquemi dyaque casada cabatichine Yusuja etare rihuisha ishu. Quimisha huecaca juatsupa nityatsuranucaya, jadyami juchine. Yuneridya ni micue casa aniya, quinajacamereticue mita taca. Yuneri ni mi Yusu jabacua, butecue curusu juque, —jadyatu ecuita cuanara acuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadya tunajatu ijillahuanacuare. Tumebaedyatu israelita emuiba cuanara ijaribacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Peya cuana inajacamere ishupa tuja casa aniya. Tumetu tuta taca quinajacameretitaqui ama cabatiya. Tuque patu ecuanaja ecuari, jadyatu juchine. Yuneridya ni jadya, pabute curusu juque. Curusu juque ni buteya, tume tuque ecuana ejeneya tuque Mesiasque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tura ecuana cuejachine, tuquepa Yusu Jabacua, tuquepa Yusu queja nimee camadya Yusuja naru ishu. Yuneridya ni jadya, Yusura curusu juque pabutya. Painajacamere tura, —jadyatu israelita cuanaja huaraji cuana jucuare tuna cama. ");
INSERT INTO cavNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chiri aridaque ecatse tuatsehue curusuju tatatanacuareratu ijillahuananucacuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tumetu tumeque chinequeja, barepatya eque las tres chinequeja dutya yahua apunaterecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Las tres chinequeja dyanetu Jesús jebuda quiquecuare: —Elí, Elí, ¿lema sabactani? (“Ecue Etata Yusu, ¿eje bucha juatsu mira jacahua?” jadique) —jadyatu quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Eje uma tuhua neticuare cuanaratu bacacuare. Elías tura ihuaraya bucha jutidya tunajatu bacacuare. —Elías béru Yusu equeque quisarati cuejaquique jucuareque tujatu ihuaraya, tuque tsahuana ishu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jadya Jesús quiqueyaju bacatsutu eraca pucaca jiteque tsajajaajecuare. Mullaticuare tujatu uva nacaca esasanashaque patsedaju. Mullatsu tujatu acui barudaju risitsu nityatsuratsu ecuatsaju jipemerecuare tuja susu ishu datse. ");
INSERT INTO cavNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","—Jadya aume. Nebara, ejepa Eliasra junatsu butyanaya curusu juque, —jadyatu peya cuana jucuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tumetu Jesús quique pidya casada juatsu, amena ishu canajeti pidya juatsu majucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tuque majuyajudyatu Yusuja etare juque junuda eshuraque Dyaque Muidaque penequique chajatanacuare ebarucue eque emaque queja. Yahuatu bucucucuare. Tumu ebari cuanatu buribarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Emaju cani cuanatu pacashatanacuare. Yusu queja ecatyati cuanaque emaju cuanaque tuna jetiama chacha netitsuranucacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Emaju cani ducuque tuna cuinanacuare. Jesús emajuque netitsurahuaju tuna cuacuare Jerusalénju. Tuhua tunajatu jetiamara bacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Cien sudaru cuana cuatsashaquique Jesús naru juyaratu bacuare yahua bucucuyaju, dutya eje bucha juyaju. Tumebaedya umae cuana tuhua neticuare cuanara bacuaredya. Jadya juya baatsu tuna dyaque bajida jucuare. —Pusha ama cuitadya tucueri riyaque ecuita Yusuja Ebacuaque juhua, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tuhuatu jetiama epuna cuana neticuare japada eque capetatiya cuanaque. Jesús Galileaju cuaya patya equetu tumeque epuna cuana tuatsehue junenicuare, tuque tsahua juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jucuare tuna María Magdalaju aniyaque; María, Santiago, José jadya ecatseja ecuaque; Zebedeoja ebacuaque ecatseja ecuaque; tumebaedya peya epuna cuana. ");
INSERT INTO cavNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Apunayajutu jecuare ecuita chipirudaque José bacani, Arimatea bacani epuju aniyaque. Arepa israelita cuanaja huaraji juya ama bucha tuquetu Jesús queja ecatyatique jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilato queja cuaatsu tujatu bacaticuare: —¿Ebutyamereu ama mira Jesús curusuju emaju badeyaque? Paishati caniju, —jadya tujatu Pilato aticuare. Bacatihuajutu Pilatora acuare: —Butyameretsu emaju papa ishu cani epuruju ishaticue. ");
INSERT INTO cavNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Tura jadya ayaju tujatu butyamereticuare. Butyameretsu tujatu piruricuare sahuana iyacua tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ishaticuare tujatu tumu cani jadya ishu eaju, tsumemaju. Tumeque canitu jucuare Joséja cuita yahuajudya. Jesús emajuque ishatsu tujatu etsecue tachimerecuare tumu ebari tsehue. Tachimere jadya aatsu tujatu shanacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdala juque, peya María jadya tatse cani queja acua juanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Canajara huecaca cabajejeti ishuque huecaca cuetihuaju, amena ijeti nubihuaju apunahuajutu pae cuanaja huaraji cuana, fariseo cuana jadya cuacuare Pilato tsehue quisaratira. ");
INSERT INTO cavNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Ecuana Naruquique, tume pusha pusha aridaque tuque ecuana adebaya tuque chacha jarira tura quisarati achineque, quimisha huecaca emajuquepa netitsuranucaya jadya juchineque. ");
INSERT INTO cavNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jadya tibu narumerecue cani tsecue quimisha huecaca tupu, Jesúsra mepehua cuanara emajuque meta echiritiuju, emajuque tuna etehua queti eauju. “Majuchinequetu chacha netitsuranucachine”, jadya tuna pusha pusha ejuu. Jadya juhuajutu ecuita cuanara eejeneu Jesús chachaque nuca. Tunaratu eejeneu tuque Mesiasque. Tumetu dyaquedya ejuu, majuchinequepa chacha netitsuranucachine jadique ejenetsu, —jadya tunajatu Pilato aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—Jida, jadidya paju. Tumidya peadya cuare sudaru cuana. Jutaquiju pana narumere neaticue emaju cani, jadya micuanara adebaya bae ejuu tibu, —jadya tuna Pilatora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jadya ahuaju tuna dirucuare. Pana narumereti tuna emaju cani acuare. Tumu tsecue tunajatu pana tachi acuare, ejera epacashauque adeba ishu. Jadya juatsu tunajatu sudaru cuana enaruqui nityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Canajara huecaca cuetihuaju, semana catibutiyaque dumicu huecacayajutu María Magdala juque, peya María jadya tatse cuahuecacacuare Jesús emajuque tumu cani epuruju tunara ishachineque cuajira. ");
INSERT INTO cavNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Casadatu yahua bucucucuare. Barepaju Yusu tsahuaquique buteyajutu jadya jucuare. Junacuaretu emaju caniju. Tuhua junatsu tujatu tumu ebari bucucushanacuare. Cani tsecue tumu penequique tujatu nityasicuacuare. Tumu nityasicuatsutu tumeque tumu dyaquedya juanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Pupipupiya bucha huecaetu jucuare. Tuja unatu dyáque pajada jucuare, ai pajada cuanaque dyaque pajada, huapeje bucha pajae. ");
INSERT INTO cavNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jadya baatsutu sudaru cuana tadadacuare, bajida juatsu. Emaju bucha tuna rihuitsu yahuaju jarabarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Tumetu barepa juque Yusu tsahuaquira epuna cuana bajida juya cuanaque isaracuare: —Nejecutanaume. Jesús, Nazaret juque, curusuju tatatanachineque sare micuana juya. ");
INSERT INTO cavNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rehua ama rique. Chachatu netitsuranucahua, tuque cacuejatinichine baedya. Nepetanacue tunara ishachineju, yuneri tuque rehua aijamaque bahue juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Petatsu ebajarara nedirunucacue. Tura mepehua cuanaque necuejadirucue: “Majuchineque patu chacha nuca. Tuque patu icuenetadya cuaya Galileaju. Tuhuadyapa tura micuana ihuatiya. Tuhuadyapa tuque micuana batiya”, jadya ecana necuejadiruhuisacue, —jadya tatse barepaju Yusu tsahuaquira cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jadya ayajutu epuna ecatse masadama emaju cani juque dirunucacuare. Bajida, peya inime tuputsu bacue pureama jadya tatse jucuare. Tsajaja cama tatse ecuana Jesúsra mepehua cuanaque cuejara dirunucacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tatse diruyaju tatse Jesúsra cabamereti ishu atsacuare. Isaratsacuare tujatu ecatse: —Ban día, mama ecatse, —jadya tujatu ecatse isaratsacuare. Tueque cuitadya tatse rihuitsu chichucata jucuare. Chichucata juatsu tatsejatu pureama acuare ehuasiju macacatsu. ");
INSERT INTO cavNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Bajida nejuume. Necuejaticue ecue cuanaque; pacua ecana Galileaju. Tuhua ecuana pacatsuruti, —jadyatu Jesúsra acuare epuna ecatse. ");
INSERT INTO cavNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Epuna ecatse ecuana cuejara cuaya tsunumeetu emaju cani naru juya cuanaque dirucuare epuju. Pae cuanaja huaraji cuana dutya eje bucha juhuaque cuejara tuna cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Riyaque pae cuanatu cuacuare peya israelita cuanaja huaraji cuana tsehue quisaratira. Inime tunajatu bajejecuare narunaruya cuanaque chipiru tsehue tsujetya ishu, tuna pusha pusha juishu. Tsujetyatsu tunajatu ecana acuare: ");
INSERT INTO cavNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—Ejera ni micuana bacaduraya emaju caniju eje bucha juhuaque, “Meta ecuana tahuiyajutu Jesúsra mepehua cuanaque emaju caniju junahua. Junatsu tunajatu Jesús emajuque chirinahua”, jadya necacuejaticue. ");
INSERT INTO cavNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Roma juque ecuari cuarequique ni bahue juya micuanara quisarati ayaque, bajida nejuume. Tura ni micuana cahuaititsu iyecara aya, micuana tahuihua baatsu, ecuanara micuana tachiya, tura enerecaturauju, —jadyatu pae cuanaja huaraji cuanara cuejacuare sudaru cuana emaju cani naruqui juhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Tumetu sudaru cuanara inatsacuaredya etsujequi. Chipiru inatsu tuna cuejatahua equedya jucuare. Cuejatibunecuare tuna ecuanaja ata cuana ducu tumeque pusha pusha. Riya camatu ecuanaja ata cuanara riyaque pusha pusha ejeneya jaridya. ");
INSERT INTO cavNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jadya juatsu ecuana Jesúsra mepehua cuanaque cuacuare Galilea emataju Jesúsra catsurutiquere ana ahuajudya. ");
INSERT INTO cavNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús baatsu tuque ecuana pureama acuare, arepa ecuana umaera ejenecarama acuare ama bucha tuque Jesúsque. ");
INSERT INTO cavNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Tume ecuana Jesúsra jipeticuare. —Yusura ique dutya naru ishu cuatsashahua, barepa juque, yahua juque jadya naru ishu. ");
INSERT INTO cavNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Necuacue dutya yahuaju aniya cuana queja. Necuejaticue ecana jidaque quisarati, eaqueja ecana pacatyati, ecue juishu. Neutsaticue ecana, tuna Etata jaque, Ebacuaque jaque, Espíritu jaque jadya ejitaju juishu. ");
INSERT INTO cavNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Era micuana cuejahua eje bucha era cuatsashaya eque juishuque. Nebahuityaticue ecana tuna era amereya eque juishu. Jida bahue nejucue riyaque. Ecue micuana jaca nime ama. Narujacaya amadya micuana era, ique junanucaya tupu, —jadya ecuana Jesúsra acuare. Riya tupu camadya micuana cuejahua. Mateo");
INSERT INTO cavNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Cuejaya micuana era Jesucristo Yusuja Ebacuaque eje buchique. ");
INSERT INTO cavNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Béru yuequedya Yusu equeque quisarati cuejaquique Isaiasratu huenecuare eje bucha judadiyaque: “Cuadishabuque tuque mique cuadishama jariju ique merequique. Turatu ecuita cuana bajejebuque, tunaja mira quisarati cuejabuqueque baca ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Quisarati cuejatu jubuque ejeque cuana tsecada eje uma piji anitaya cuana queja. ‘Nequihuaticue, Ecuana Cuatsashaquique junayaju ishu. Jidamaque neajacacue. Jida tuyu nejucue, ediji benubenuque etuyune ejuu bucha’”, jadyatu Yusura Isaías eque quisarati acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tsunuda eje uma mara juatsutu Juan tsecada eje uma piji anitaya cuana queja Yusuja quisarati cueja jucuare. Tuaqueja jutiyaque ecuita cuana tujatu cuejatsabarecuare: —Necacuareticue inime, Yusuja micuanaja jucha cuana apupasha ishu. Necutsamereticue yuneridya inime cacuaretihua jadique adebataqui juishu, —jadya tujatu ecana cueja bahue jucuare. Tuna inime cacuaretihuaju tujatu ecana utsa bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jetiama Jerusalén epu ebariju aniya cuanaratu quisaratiyaju bacaticuare. Tumebaedya Judea yahuaju dutya queja aniya cuanara quisaratiyaju ijacabacaticuaredya. Tura quisarati cuejayaju bacatsu, —Yuneridya ecuana jucha arida cuanaque, —jadya tuna cacuejaticuare. Jadya tuna cacuejatihuaju tuna Juanra utsacuare Jordán cueriju. ");
INSERT INTO cavNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanratu jutucuare camello tsaru etarique etataque ejutuqui eaque, baya ecuita cuanadya jutidya cajututiya bucha. Ebiti patsa quinida ejicui tsehuedya jutidya tu ecaquereti jucuare. Tsei ebari, huaja jadya tujatu araaranicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ecuita cuana isarayaque tujatu jadya abahue jucuare: —Tsunutaya amatu peya junayaque. Tujatu dyaque casa aniya, ecue bucha ama. Tuque baatsu ique ni aishuquedya jutidya; mere puji tuja patrón tsehue beta tupu ama ejuu bucha jutidya ique. ");
INSERT INTO cavNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Era micuana utsaya ena tsehue, inime cacuaretihua jadique adebataqui juishu. Tume junayara micuana Yusuja Espíritu tyanaya, tujaque jadique adebataqui juishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Juan ecuita cuana utsa jucuare patyatu Jesús jecuare Nazaret juque. Tumeque eputu Galilea yahuaju jucuare. Tuque jutihuajutu Juanra Jordán cueriju utsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Tuque ena juque cuinanayaju cuitatu Jesúsra bacuare barepa pacashatanayaju. Bacuaretu Yusuja Espíritu huei jiuque tuque dyaque buteyaju. ");
INSERT INTO cavNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tume tujatu barepa juque etsuri bacacuare. Yume tucuetu jucuare tuja Etataque Yusu. —Mique mique ecue Ebacua dyaque iyuhuedaque. Ique dyaque pureama juya miatsehue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jadya juu jadya juatsutu Yusuja Espiritura Jesús dujucuare japada peya queja amaca anitaya amaju. ");
INSERT INTO cavNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Pushi tunca huecacatu tuhua juticuare. Tuhuatu jetiama cuanubi mureda cuanaque anicuare. Tuhuadyatu Satanásra cajuchatishacara ebari datse acuare. Jadya juhuajutu Yusu tsahuaqui cuanaque butecuare barepa juque Jesús tsahua, casatura jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ecuarira Juan etare apudaju ishamerehuajutu Jesús Galileaju cuacuare Yusuja jidaque quisarati cuejara. ");
INSERT INTO cavNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Cuejacuare tujatu ecana: —Necacuareticue inime. Yusu queja necatyaticue, tuja quisarati jidaque ejenetsu. Juetihuatu huecaca. Yusujatu adebamerehuie tuja Emepeque, —jadya tujatu ecana cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesústu Galilea bei jiruru eque dirucuare. Diruyara tujatu badirucuare beta jae puji ecatse. Peadyatu Simon jucuare, peya bacue Simón tsehuequiquedya Andrés. Jae deru ishuque enaju mare tatse jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesúsra tatse isaradirucuare: —Nejecue. Eatsehue nejunenicue. Metse metse jae puji ecatse. Iyacua metse era ecuita cuana Yusu adeba mere ishuque amereya, —jadya tatse Jesúsra adirucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Tumeque ura cuitadya tatse jae deru ishuque shanaquenatsu junenitibunecuare Jesús tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Cuabacanucatsu tujatu banucacuare beta ecuita ecatse. Jucuaretu Santiago, Santiago tsehuequique Juan jadya, Zebedeoja ebacuaque ecatse. Cuaba aridaju tatse juanicuare, jae deru ishu cuanaque sipiani juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesúsra tatse ihuaracuare, tuatsehue juneni ishu. Tura ihuarayaju bacatsu tatsejatu shanaquenacuare etataque Zebedeo cuabaju tuja mere puji cuana tsehue. Cuinanacuare tatse cuaba arida juque, etataque isaraquenatsu. Jadya juatsu tatse Jesús tsehue junenitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Judirucuare tuna Capernaum epuju. Canajara huecacajutu Jesús nubicuare caradati ishuque etareju. Nubititsutu catibuticuare tuna bahuitya. ");
INSERT INTO cavNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Anajacatacuare tuna tura bahuityayaque bacatsu, huaraji equisaratiu bucha quisaratie juya bacatsu. Bahuityacuare tujatu ecana cacuatsashati bahuityaquira bahuityaya bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Anicuaretu tumeque etareju ecuita ijahua cuanara quijahuatishayaque. Tuque quijahuatishaquiquedya jutidyatu ecuita eque quiquecuare: ");
INSERT INTO cavNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Ai jitequemi jeya ecuana queja, Jesús Nazaret juque? ¿Ecuana aputasharami jeya? Adebaya mique ecuanara. Miquemi juchama. Yusu quejaquemi jehua, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesusratu tumeque ijahua nereda acuare: —¡Abacata jucue! ¡Iyacua cuita cuinanacue riyaque ecuita quejaque! —jadyatu Jesúsra acuare ijahua ecuita quijahuatishaquique. ");
INSERT INTO cavNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jadya quisarati aatsutu ijahuara ecuita tadadashatilla, yahua catsaqui amere jadya acuare. Manu amere, jebuda quiqueshatilla, cuinana jadyatu tuaquejaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Dutya tuque petaqui jucuare cuanaque tuna jecutanacuare. Cabacaduratibarecuare tuna: —¿Eje buchique ri riyaque? ¡Eje buchique rejari iyacuaque bahuityaya! Huaraji equisaratiu bucha rejari quisarati. Aniya taa tuja casa ijahua cuana cuatsasha ishu. Tuna bacue tuequedya juya tura amereya equedya, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Masadama cuitatu tumeque jadya juyaque tsapetanacuare dutya Galilea yahuaju. Tumeque yahuaju cuanaque tuna dutya bahue jucuare Jesús jadya juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Caradati ishuque etare juque cuinanatsutu Jesús cuacuare Santiago, Juan jadya tsehue. Cuacuare tuna Simón, Andrés jadyaja etareju. ");
INSERT INTO cavNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simónja ehuanequeja ecuaquetu dyaquene cuita, baara juyaque jaracuare. Cuejatsacuare tunajatu Jesús, tumeque epuna ujejeda jarayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jadya bacatsutu Jesúsra jipeticuare. Jipetitsu tujatu emetucuju jabanaticuare. Emetucuju jabatsu tujatu iyatsuracuare. Tumeque ura cuitadyatu baara juyaque chacha jucuare. Tumetu netitsuratsu earaqui jucuare Jesús, tura mepehua cuanaque jadya mihua ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Amena ijeti nubihuaju, apupuyajutu ecuita cuanara becuare Jesús queja ujejeda cuanaque umada ujeje tsehue cuanaque, tumebaedya ijahua cuanara quijahuatishaya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Dutya epu jujeri tuna casitaticuare etsecueju, Jesúsra eje bucha ayaque petacara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesusratu chachanebarecuare umada bape bape ujeje tsehue cuanaque. Tumebaedyatu ijahua cuanara quijahuatishaya cuanaja ijahua cuana cuinanashacuare. Quisaratishacarama tujatu ijahua cuana acuare, ecuita cuanara tuque Mesiasque eadebauju. ");
INSERT INTO cavNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Huecacama jarijutu Jesús netitsurahuecacacuare. Epu juquetu cuacuare Yusu tsehue quisaratira tuta taca piji. ");
INSERT INTO cavNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Umae peya cuana Simón tsehue mepetapee jucuare cuanaratu Jesús sareticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesús tunajatu Etataque tsehue quisaratiyaju baticuare. Quisaratijacahuaju tunajatu cuejacuare: —Dutyara tunarami sareya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesúsra tuna acuare: —Caadebatiyadya ique tunara sareyaque. Jadya ama bucha necuara peya queja amaca epu cuana japadamaju Yusuja quisarati cuejara. Jadya ishudya ique Capernaum juque cuinanahua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Tumetu Jesús junenicuare dutya Galileaju, caradati ishuque etare cuanaju Yusuja quisarati cueja juyaque, tumebaedya ijahua cuanara quijahuatishaya cuanaque chachane. ");
INSERT INTO cavNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jesús peya queja amaca juneniyajutu ecuita pusese sehuera rami ririshayara jipeticuare. Tume tujatu Jesús tuja yacuaju chichucata juatsu isaratsacuare: —Chachanecara aatsu taa mira ecue ujeje aniyaque echachaneu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nerecada baatsutu Jesúsra jabacuare. —Chachaneyadya mique era, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jadya aya tsunumeetu pusese aputacuare tuja ecuita juque. Chachadya tu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ecuita diruma jarijutu Jesúsra nereda bucha cuejae acuare: ");
INSERT INTO cavNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Bacacue era cuejayaju. Cuejacueja camadya aume ni ejequedya jutidya mique eje bucha chachae juhuaque. Riyata cuau cuitadya jucue pae queja, tuja mique pana adeba atsa ishu, “Chachadya rique” jadya tuja aishu. Cadujuticue Moisésra amerehua equedya riyaque ujeje chacha eju cuanaja Yusu tyabahueque. Jadya juatsutu ecuita cuana bahue juya mique amena chachaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jadya ahuajutu ecuita dirucuare. Arepa Jesúsra cuejamerecarama ahua ama bucha, tujatu ecana cuejaajecuare tuque Jesúsra chachanehuaque. Jetiama ecuitara bape baatsu petacara ayajutu Jesús epu arida cuanaju cuataqui ama cabaticuare. Epu japada tsecada anitaya quejatu junenicuare. Dutya queja aniya cuanaratu Jesús baticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Eje uma huecaca cuana juatsutu Jesús yudijidya judirunuca jucuare Capernaumju. Masadamatu ecuita cuana bahue jucuare tuque tuhua etarejuque judiruhuaque. ");
INSERT INTO cavNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Umadatu ecuita cuana caradatinucacuare tuhua. Aijamatu jucuare emajaca educuju ni etsecueju, umada caradatihua tibu. Tuhua tuna tura Yusuja quisarati cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Tuque quisarati cueja juya tsunumeetu pushi ecuita junaticuare, ebadequi baeju ajebaecuaque duju juyaque. Jadya iyabutyamaquedya jutidya tunajatu ajebaecua queja Jesús jipemerecara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Jipetaqui ama tunajatu Jesús bacuare, ecuita jetiama tibu. Amena eje bucha nubitaqui ama cabatitsu, tuna tsuracuare ebarucue etare dyaque. Tsuratsu tunajatu etare ebarucue jepedaque huetsacuare, Jesús netiya tuyu. Huetsatsu tunajatu ajebaecuaque butyacuare ebadequi baeju misa tsehue tisunetsu. ");
INSERT INTO cavNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ajebaecuaque dujuqui cuanara Jesúsra ajebaecuaque eajeshauque ejeneyaque adebatsu tujatu jadya ajebaecuaque acuare: —Micue jucha cuana tu amena eapupasha, tata, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Cacuatsashati bahuityaqui cuanaque tuna tuhuadya etareju jucuare. Jadya quisaratiyaju bacatsu tunajatu inime tupucuare: ");
INSERT INTO cavNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Eje bucha juatsuri riyaque ecuita jadya quisaratiya? Yusu tujatu ijillahuanaya. ¡Ni ejeradya jutidyatu jucha cuana eapupashau, Yusura peadya camadya! —jadya tunajatu inime tupubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesústu bahuedya jucuare tunara eje bucha inime tupuyaque. —¿Eje bucha juatsu tuque micuana jadya inime tupuya: “Yusu tujatu ijillahuanaya” jadya? Jida ama tuque micuana inime tupuya. ");
INSERT INTO cavNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Era ni ajebaecuaque eau: “Micue jucha cuana tu eapupasha” jadya, eadebau ama tuque micuana ecue casa aniyaque, eapupasha, apupashama jadique ejitaju ama tibu. Era ni eau: “Netitsuracue. Piruricue micue jara ishuque. Ajecue”, tumeque ura cuitadya tuque micuana eadebau ecue casa aniyaque, ajebaecuaque juneniyaju baya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tuque juneniya baatsu micuana bahue juya ecue tumebaedya riyaque yahuaju jucha cuana apupasha ishu casa aniyaque, —jadya tujatu ecana acuare. Tumetu Jesúsra acuare ajebaecuaque: ");
INSERT INTO cavNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Netitsuracue. Piruricue micue jara ishuque. Dirucue micue etareju, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jadya ahuaju cuitatu ecuita netitsuracuare. Tuja jara ishuque piruritsu, huesatsutu cuinanaquenacuare tuhuaque dutyara petayaju. Dutya tuna anajacatacuare. Pureama tuna Yusu acuare: —¡Dyaque jida, casada taa Yusu! ¡Bama taa rique ecuanaja jadya cuanaque! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jadya junucatsutu Jesús cuanucacuare bei jiruru eque. Jetiama ecuitaratu jipetinucacuare. Tume tujatu ecana bahuityacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cuetiyara tujatu bacuare Leví, Roma juque enaruquija ishu chipiru tsuje bacayaque juaniyaju. Levítu Alfeoja ebacuaque jucuare. Isaranati jadya aatsu tujatu acuare: —Eatsehue junenicue, —jadyatu Jesúsra acuare. Jadya ahuaju netitsuratsutu Jesús tsehue junenitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ejetsunue juatsu amatu Jesús Levíja etareju araaraapunacuare, tura mepehua cuana tsehue. Tuhuatu jucuaredya enaruquija ishu chipiru tsuje bacaqui cuanaque, umae bijidamadurataya cuanaque jadya. Tuhuadya tuna jetiama mesaju Jesús tsehue araaracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cacuatsashati bahuityaqui cuanara, fariseo cuanara jadyara tunajatu bacuare eje bucha juyaque. Bacuare tuna Jesús tunara ecuita cuana ujeu baya cuana tsehue araarayaju. Jadya baatsu tunajatu acuare Jesúsra mepehua cuanaque: —Riyaque ecuita ri bijidamadurataya cuanaque. Micuana Bahuityaquiquetu araarataqui ama enaruquija ishu chipiru tsuje sitaqui cuana tsehue, tumebaedya peya jucha arida cuana tsehue, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesúsra tuna quisaratiyaju bacacuare. —Chacha cuanaratu sareya ama casamati puji. Ujejeda cuanara camadyatu sareya. Juchama bucha cabatiya cuanaque sarera ama jehua. Ique jehua jucha arida cabatiya cuanaque jiteque, tuna inime cacuaretisha ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juan Ecuita Cuana Utsaqui tsehue junenicuare cuanaque, fariseo cuana tsehue junenicuare cuanaque jadya tuna arama quibeti bahue jucuare, Yusu muiyaque cabamereti ishu. Jadya tuna arama quibetiyajutu, umae ecuita cuana Jesús queja cuacuare. Jutitsu tunajatu bacaduracuare: —Juan tsehue juneniya cuanaqueri arama quibetiya Yusu muiyaque cabamereti ishu. Tumebaedya fariseo cuana tsehue juneniya cuanaque jadidya ecana juya. Mira mepehua cuanaque bacue arama quibeti baecua. ¿Eje bucha juatsu? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Jesúsra tuna quemitsacuare: —Caquemitiyaju cuaishu ecueja cuanaque tuna arama quibetiya ama caquemitihuaque tuna tsehueju. Tuna quejaque dujutanahuaju piisi tuna arama quibetiya. Tumebaedyatu ecue cuanaque; ique cuanucahuaju piisidya tuna arama quibetiya. ");
INSERT INTO cavNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ni ejeratu camisa siri sipiya eraca iyacua tsehue. Jadya ayaque juatsutu nacatatsu eraca iyacuaque dyurutanatsu camisa siri echajatanau. Chajatanayaque juatsutu camisa beru juhua bucha dyaque jidama ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tumebaedyatu ishataqui ama tupari sasana ishuque sura siri cuitaju. Tupari sasanayaratu epututashau sura siri. Tumetu eaputau sura, tupari jadya. Jadya tibudyatu tupari sasana ishuque sura jida iyacuaju ishataqui, —jadya tujatu ecana acuare. (Riyaque cuatsabiji tsehue tuna Jesúsra bahuityacuare. Eje bucha anitaqui amatu beru inime israelita cuanara bahuityacuare eque, iyacuaque tura cuitadya bahuityaya eque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Tume patyatu Jesús cueticuare euhua cuana eque canajara huecacaju. Aridatu trigo euhuaque jucuare ejahuane, amena racataqui. Jesúsra mepehua cuanaratu cuetiyaradya jutidya trigo esa sepitsu etsucaca mucuajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Umae fariseo cuanara baatsu tunajatu Jesús cuejacuare: —Mira mepehua cuanaquetu Moisésra cuatsashacuare eque ama juya. Meredya tuna juya etsucaca cuana sepi, mucu jadya juyaque. Meretu jutabaecua canajara huecacaju, —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesúsra tuna quemitsacuare: —Neadebacue ecuanaja ebaba David emuique jucuareque. Tuque, tuatsehue cuaya cuanaque jadya tuna aracara jucuare. Aijama tunaja ara ishuque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tume patya, Abiatar pae dyaque muidaque jucuare patyatu David nubicuare Yusuja etareju. Nubitsu tujatu Yusuja ishu eiyaque pan cuana inacuare. Inatsu tujatu aracuare. Tumebaedyatu tyacuare tuatsehue cuaya cuanaque. Arepa tuja, tuatsehue cuaya cuanaja jadya arataquima paju ama bucha tuna aracuare, pae cuanaja cuita camadya arataquique. Jadya ama buchatu Yusu cahuaitishacuare ama, tumeque pan aratsu. ");
INSERT INTO cavNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Icuene cuitatu Yusura ecuita cuana iyahua. Tuequedyatu iyahua semanaju peadya huecaca tuna canajara ishu. Canajara huecaca icuene au, ecuita cuana au jadya amatu Yusura acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","IQUE ECUITAjatu aniya cacuatsashati canajara huecacaju ai juishuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jadya juatsutu Jesús caradati ishuque etareju nubinucacuare. Canajara huecacajutu jadya jucuare. Ecuita emetucu majuquetu tuhua jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tumebaedyatu tuhua jucuare Jesús ujeu baqui cuanaque. Tunaratu Jesús jidama inime tupu tsehue petacuare. “Tura ni canajara huecacaju riyaque emetucu majuque chachaneya, tume tuque ecuana huaraji cuana queja cuejatiyadya”, jadya tunajatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Tumetu Jesúsra isaracuare ecuita emetucu majuque: —Netitsuracue. Netinacue requeja tuna patya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Netitsurahuajutu Jesúsra tuhua cuanaque bacaduracuare: —Ecuanaja cacuatsashati eque ¿canajara huecacaju tuque ecuanaja jidaque ataqui, jidamaque ni taa? ¿Ejeque majutaqui baatsu echachaneudya tuque ecuanara, “Pamaju” jadya ni taa ecuana eau? ¿Eje bucha micuana inime tupuya? —jadya tujatu ecana acuare. Tura jadya ahuaju tuna caquemitsaticuare ama. ");
INSERT INTO cavNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Tumetu Jesús tuna tsehue ecahuaiti jucuare. Jadya ama buchatu peya inime jucuare, tuna inime cacuareticarama juya baatsu. —Rirucue micue ebi, —jadya tujatu acuare ecuita. Jadya ayajutu ecuitara rirucuare ebi. Tura ebi riruya tsehuedya cuitadya tujatu emetucu chacha jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jadya juya baatsutu fariseo cuana cuinanaquenacuare. Cuinanatsu tuna enaruqui Herodes tsehue juneniya cuana tsehue quisaratira cuacuare. Bajejetibunecuare tuna inime Jesús iye ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesústu cuacuare tura mepehua cuana tsehue bei jiruru queja. Umada ecuita Galileaju aniya cuanaratu tajicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jecuare tuna Judea yahua juque, Jerusalén juque jadya. Idumea juque ecana junacuaredya, tumebaedya Jordán cueri yueque macare cuanaque. Tiro, Sidón yahua cuana juque tuna junacuaredya. Jadya eque tuna dutya quejaque tuque eje bucha juyaque bahue juatsu jebarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ecuita cuana jetiama baatsutu Jesúsra acuare tura mepehua cuanaque: —Nequeticue cuaba requeja, ecuita cuanara ique naiishayaque juatsu tuhua anibute ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Tura icuene ujejeda cuanaque chachanechineque adebatsutu jetiama ujejeda cuanaque tuaqueja cajabamereticara juatsu quitushati quitushati tsehue cuacuare. Cajabameretitsu cuanadya jutidya tuna cachachanemereticara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ijahua cuanara quijahuatishaya cuanaquetu tuque baatsu quiqueyaque nuyucuare tuja yacuaju: —¡Midyami Yusuja Ebacuaque! ");
INSERT INTO cavNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jadya juhuaju tuna Jesúsra nereda bucha cuejae acuare: —Jadya dutyaja ijacaju nequisaratiume, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jadya juu jadya juatsutu Jesús tsuracuare emataju. Tuequeradya tujatu ihuaracuare tuatsehue juneniya cuanaque. Tuhuadya tuna caradaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tuhuadya tujatu ecana mepecuare peadya tunca beta earacana. —Eatsehue nejunenicue era eje bucha ayaque cabahuityati ishu. “Jesúsja Ecuadisha cuanaque” jadya bacani eque neadebatacue. Ecue quisarati cuejara micuana cuadishaya. ");
INSERT INTO cavNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tyaya micuana casa ijahua cuana ijehuecuina ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Peadya tunca beta earacana tura ebacaniju abarecuare cuanaque tuna jucuare: Simón (Jesúsra tujatu peya ebacani iyacuare “Pedro”.) ");
INSERT INTO cavNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago Juan (Santiago tsehuequique; tatse tatse jucuare Zebedeoja ebacuaque ecatse. Tatsedya tatse “Boanerges” bacani jucuare, “Tiriti baeque ecatse” jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés Felipe Bartolomé Mateo Tomás Santiago (Alfeoja ebacuaque) Tadeo Simón (Tuquetu Roma juque enaruquique bijidamaduraqui juyaque jucuare.) ");
INSERT INTO cavNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote (Jesús inamerequi judadicuareque) Jadya tuna jucuare tura mepecuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jadya juatsutu Jesús tura mepehua cuana tsehue nubidirucuare etareju. Jesús judirunucahuaque bahue juatsutu jetiama ecuita cuacuare tuaqueja. Jesúsja, tura mepehua cuanaja jadya tunajatu aijama emajaca jucuare ni araara ishu cuanadya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jadya bahue juatsutu Jesúsja ata cuana jecuare tuque jiteque, quijahuatiyapa jadya bacatsu datse. ");
INSERT INTO cavNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tuhuatu umae cacuatsashati bahuityaqui cuanaque jucuare Jerusalén juque junahua cuanaque. —Beelzebú, ijahua cuana cuatsashaquique tu tuatsehue. Jadya tibudya tujatu casa aniya ijahua cuana ijehuecuina ishu, —jadya tuna jucuare. (Beelzebú taa tu Satanás bacani nucadya.) ");
INSERT INTO cavNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tumidya tuna Jesúsra ihuaracuare. Ihuaratsu tujatu ecana cuejacuare: —Beelzebúja casa eque ama tuque aya. Tuja casa eque ni eau, tume taa tu Satanás tuta tacadya jutidya pana cayuamaturati ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ita taa nebacacue. Yahuaju dutya aniya cuanaque ni ecajaquetibareu cuarepe cuarepe tuna cama cati ishu, tuna camadya jutidya tuna ecatillatiu. ");
INSERT INTO cavNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Peadya etareju aniya cuanaque ujeu cabatitsu, ecajaquetibarequetu catillatiya. Tsapetanatereya. Ebacua cuanaquera tuna etata cuanaque muibajacaya. ");
INSERT INTO cavNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Era ni Satanásja casa tsehue ijahua cuana eijehuecuinau, tume taa tu Satanás tuja ijahua cuana ducuque peadya tsehue ecatiu. Tumetu ejeque ijahuadya jutidya tura cuatsashaya eque ejuu ama. ");
INSERT INTO cavNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ijahua cuana ijehuecuina ishutu icuene cuita tuna cuatsashaquique Satanás dutya tuja casa secataqui, ecuita dyaque casadaque tuja ai seca ishu icueneta risi ataqui bucha. Ejeque casa secamaja etarejutu eje bucha nubitaqui ama tuja ai aniyaque seca ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yusuratu jidama quisarati aya cuanaja jucha cuana eapupashau, eje bucha cajuchatie juya cuanaja. ");
INSERT INTO cavNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jadya ama bucha Yusuja Espirituja ishu jidama quisarati aya cuanaja jucha tujatu apupasha nime ama. Apupashaya ama tibutu Yusura nerecaturajacabuque ama tumeque jucha tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesúsra tuna jadya acuare, tuna cuejayaque. Yusuja Espíritu tsehue tujatu ijahua cuana ijehuecuinaya jadya eauquetu tunara Ijahuaja casa tsehue bucha bacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesús quisarati netiyajutu junaticuare ecuaque, tuatsehuequi cuanque jadya. Ecuita jetiama tibu tuna etsecueju netinaticuare. Tuequeradya tunajatu ihuaramerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jetiama tuna anibarecuare educuju Jesús peque. —Micue cuaa, micue miatsehuequi cuanaque jadya rena etsecueju. Miatsehuepa tuna quisaraticara juya, —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—Tumeque epuna tuque ecue ecuaa; tume cuanaque tuna ecue eatsehuequi cuanaque. Jadya ama bucha tuque ecue aniya peya ecue iyuhueda cuanaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jadya quisarati aatsutu Jesúsra educuju anibareya cuanaque petabarecuare. —Nebacacue. Riya cuanaque rique ecue iyuhueda cuanaque. Riya cuanaque rena ecue ecuaa buchique, ecue eatsehuequi cuanaque buchique jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iyuhueda tuna baya Yusuja inime eque juya cuanaque. Tunadya tuna ecue ecuaa, ecue eatsehuequi cuanaque bucha bae ayaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yudijidya catibutitu junucacuare Jesús ecuita cuana bahuitya bei jiruru. Masadamatu caradatinucacuare jetiama ecuita cuana. Tuna majacama cuita baatsutu Jesús cuabaju nubitsu anibutecuare. Mejiji equera tunajatu bacacuare tuque quisaratiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Cuatsabiji eque tujatu ecana bahuityacuare, yunerique adebamere ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Nebacacue riyaque cuatsabiji. Anicuaretu ecuita. Cuacuaretu tuja teeju uhuauhuara. ");
INSERT INTO cavNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tura uhuaajeyaquetu umae pacacacuare edijiju yahua pajidaju. Uhuayaque etsucaca yahuaju huiruhuaquetu upati huiri cuanara anibutetsu mucutillacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Peya etsucaca cuanatu pacacacuare yahua macana dedamaju. Yahua macanamaque dedama tibutu huijatsu danecuare ama, masadama buraracuare ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ijetija uqueratu iyecuare euhua cuanaque, etiri yahua nacadaju ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Umae bacue pacacacuare acui tiri, acuija jadya jetiama ducu. Acuija cuana danetsu tujatu trigo euhuaque ehuija cuanaque iyetillacuare. Jadya eque tujatu jucuare ama ni peadya etsucaca. ");
INSERT INTO cavNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Umae etsucaca cuanatu pacacacuare yahua jidaju. Cacacaticuare umada. Tee mere pujiratu jetiama huesacuare tuhua euhuaque. Umae esa cuanajatu quimisha tunca tsucaca jucuare. Peya esa cuanajutu shucuta tunca tsucaca jucuare. Peya esa cuanaju jucuare cien tsucaca. Jadyatu jucuare teeju euhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","“Quijacabacati aqui juatsu, nebacacue, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Tuequedyatu dutya jujeri ecuita cuana cuinanaterecuare. Jesúsra mepehua cuanara, peya cuana cuinanahuishacuare ama cuanara jadyatu Jesús bacaduracuare: —¿Eje buchique ri riyaque cuatsabiji? ¿Ai mira ecuana bahuityacara aya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesúsra tuna quemitsacuare: —Yusura micuana pana adebamere acara aya tura tuja cuanaque naruyaju eje bucha juyaque. Peya cuana jadya cuejae eauque, tuna cuatsabiji cuana eque jutidya cuejaya jari, pana huecasha cuita ayaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Tunaratu era ayaque baya. Tume tuna baatsu bama jiu juya. Bacatsu tuna bahuityahua ama jiu juya, arepa bacahua ama bucha. Adebayaque juatsu tuna inime ecacuaretiu. Tuna inime cacuaretiyaque juatsu tunajatu Yusura jucha cuana eapupashau, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesúsra tuna bahuityanucacuare: —Micuanara ni riyaque cuatsabiji uhuahua puji equeque bacaya ama, ¿eje bucha adebae jatsu tuque micuana peya cuatsabiji cuana eau? ");
INSERT INTO cavNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pana cueja micuana aya era bahuityahuaque. Uhuauhua puji tu Yusuja quisarati cuejaquique. ");
INSERT INTO cavNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Umaetu Yusura naruyaju eje buchique quisarati bacatsu masadama nime aputaya, Satanásra masadama pana nime aputashamere aya tibu. Tuna tuna ediji pajidaque buchique. ");
INSERT INTO cavNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Umaeratu ejetsunue ishu ama pureama tsehue Yusuja quisarati bacaya. Nerecada juya cabatitsu tuna ejenejacaya. Quisarati ejenehua baatsu jidama atayaju, masadama tuna ejenejacaya, pana adeba aya ama tibu. Tuna tuna yahua macana dedamaque buchique. Huijahua cuanaquetu macana quini danetsu tsunuda ama juya, etiri dedama tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Umaera Yusuja quisarati bacaya cuanaratu ejenejacaya, riyaque yahuaju cuanaquedya jutidya dyaque inime tsapequi aya tibu. Tunajatu inime juya chipiru dyaque umada anitsu cuita camadya dyaque pureama ejuu bucha. Chipiru dyaque iyuhueda baatsu tuna tunadya jutidya ijahue catiya. Dutya tuna tunaja bijida cuanaque camadya inime tupuqui aya. Jadya juatsu tuna Yusu muijacaya. Tuja quisarati tuna ejenejacaya. Tuna tuna yahua acuija quinique buchique. ");
INSERT INTO cavNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Umae cuana Yusuja quisarati bacaqui juya cuanaratu adebaajeyadya jutidya. Tuna eje bucha anieju tuna ejitaju Yusuja biji eque aniyaque. Umae cuana tunajatu tsahuaya eaqueja catyati ishu. Tunadya tuna esaju jetiama etsucaca juhuaque bucha, quimisha tunca, shucuta tunca, cien jadya cacacatihuaque buchique, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesúsra tuna bahuityanucacuare: —Ude tuchatsu tuque ecuana tehuaya ama caju ducu ni eperere emaque. Etehuauque tuque ecuana iyaya ebarucue dutya queja uda ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dutya etehuaquetu ejitaju judadiya. Dutya ibedaquetu adebataqui judadiya. Yusura micuana bahue ameredadiya eje bucha jue tujaque juishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Micuana quijacabacati aqui juatsu, nebacacue. ");
INSERT INTO cavNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","“Pana baca neacue era cuejayaque. Era cuejayaque bacatsu micuanara eje bucha adebae aya eque neanicue. Micuana ni micuanara adebaya eque aniajeya, Yusura micuana adebamereajeyadya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ejeja ai aniyajatu dyaquedya ai aniajeya. Ejeque ai aniya bucha cabatiyaque, aimaquedya jutidya, tuja aniya cabatiyaque tujatu aputatereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesúsra tuna bahuityanucacuare: —Cuejaya micuana riyaque cuatsabiji, Yusura naruyaju eje buchique micuana bahue juishu. Ecuitara tuja tee euhuau. ");
INSERT INTO cavNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tee uhua, jadya juatsu peya mere ecatinucau. Huecadaju mere, meta bacue tahui jadya. Tuque jadya juyajutu uhuachine cuanaque buraratsu huijatsu daneya. Yusura eje bucha iyahua equetu uhuaya cuanaque buraraya, ecuitara eje bucha ayaju ama. ");
INSERT INTO cavNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Yahua ni jida, icuene cuitatu huijaya uhuahuaque. Tuequedyatu danetsu amena catsatiya. Tuequedyatu etsucaca esaju cacueyatiajeya jahuaneya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ecaca jahuanehuajutu tee mere pujira racaya, raca raca ishuque huecaca juetihua tibu, —jadya tuna Jesúsra cuejacuare. (Riyaque quisarati tsehuetu Jesúsra bahuityacara aya riyaque: yuneridya ni ecuana ejeneya tura bahuityayaque, ecuanaja bahue cuana, inime tupu cuanatu cuaretanaya, ecaca uhuahuaque huijatsu, ecaca huesaya tupu cuaretanaajeya bucha.) ");
INSERT INTO cavNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesúsra tuna bahuityanucacuare peya cuatsabiji eque bahuityayaque: —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. Jadya tibudya micuana cuejaya riyaque cuatsabiji. ");
INSERT INTO cavNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Adebayadya micuana mostaza caca, teeju euhuataque. Achaachaque piji, bataqui nerique ama. ");
INSERT INTO cavNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jadya ama buchatu buraratsu, huijatsu, danetsu dyaque arida juya, teeju peya euhua cuanaque bucha ama. Yaa cuana tujatu junuda, arida juya. Tumeque yaa cuanajudyatu upati huiri cuana eja catiya, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra jadique huecashacuare. Arepa catibutiyaque eje uma piji tuaqueja catyatiajeya ama bucha, tuquedya tuna riya piji, riya piji jetiama catyatiajeya.) ");
INSERT INTO cavNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cuatsabiji equetu Jesúsra ecuita cuana Yusuja quisarati bahuityacuare. Tura cuejayaju adebataquima baya cuanaque tujatu cuatsabiji equedya jutidya bahuityacuare. Cuejayaju adebaya cuanaque tujatu ecana dyaquedya pana cueja acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ecuita jetiamaque bahuityayaque tujata ecana cuatsabiji eque cama bahuityacuare. Tura mepehua cuana tsehueju tuna Jesúsra pana cueja acuare cuatsabiji eque bahuityayaque eje buchique jadique. ");
INSERT INTO cavNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Apupuyajutu Jesúsra acuare tura mepehua cuanaque: —Bei yueque macare necarequetira. ");
INSERT INTO cavNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tume tunajatu isaraquenacuare ecuita cuana. Jesús patu ecuita cuana tsehue quisaratitibunehuaque yume anidya cuabaju jucuare. Ecuita cuana isara amena aatsu tuna, tuna dyadi anibutecuaredya cuaba ducu. Dujucuare tuna Jesús yueque macare. Umae ecuita cuana tumebaedya peya cuaba cuana eque carequeticuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Tuna carequetiyajutu muya jutidya cuejipa casadaque jueticuare. Cuejipa juetitsutu ena pacura cuaba ebariju ena ishacuare. Jadya tibutu ena pacura cuaba nudyajeri nudyajeri acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesústu tahuicuare cuaba tibu queja, iyuca icuquiju. Rumutanaya bucha cabatitsutu tura mepehua cuanara Jesús bushishaticuare. —Ecuana Naruquique, ¿miratu jidama ama cuitadya inime baya, ena pacura nudyatsu ecuana ehuiditereuju? ");
INSERT INTO cavNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tunara jadya ayajutu Jesús netitsuracuare. Netitsuratsu tujatu acuare cuejipa, ena pacu jadya: —¡Tume tupu camadya! ¡Neticue! —jadya tujatu acuare. Tura jadya aya tsehue cuitadyatu cuejipa neticuare. Dutyatu pana abacatana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jadya juatsutu Jesúsra acuare tura mepehua cuanaque: —¿Eje bucha juatsu micuana bajida cuita juhua? ¿Eje bucha juatsu micuana eatsehue nime aputahua? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tuna bacue dyaque eanajacata jucuare. Bajida ecana jucuare. Tuna taca tuna jadya jutibunecuare: —¡Ai ecuita dyadi ri riyaque! ¡Cuejipa, ena pacu jadya taa tuja yana equedya juya! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Chamacama tuna jaratsuradirucuare Gerasaju aniya cuana queja, bei yueque macare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Amena Jesús cuaba juque cuinanahuajutu ecuita ijahua cuanara quijahuatishayara jipeticuare. Emaju cuanaque eisha cani cuana juquetu jecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Tucuanajutu anicuare, ijahua cuanara quijahuatishaya tibu. Naru ishutu ecuita cuanara eje uma risi datse abahue jucuare ehuachiju, ebi ecatseju jadya cadena tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ijahua cuanaja casa tsehue tujatu cadena metal eaque riya piji riya piji tibibishajacama acuare. Ni ejera buchiquetu inataqui ama bacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Huecada tupu, meta tupu jadyatu emaju cuanaque eisha cuana patya queja, emata cuana queja jadya junenicuare. Tuque amacatu quiqueterenicuare. Tumu cuana tsehuetu ujeda ujeda caticatinicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tumetu Jesús japada equera batsatsu, tuaqueja tsajajaajecuare. Tsajajaajetsutu chichucata jucuare tuja yacuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Jadya ayajutu Jesús quisaraticuare: —Necuinanacue tumeque ecuita quejaque, ijahua cuana, —jadya tujatu ecana acuare. Jadya ayajutu ecuita quiquecuare: —¿Ai jitequemi jeya eaqueja, Jesús Yusu barepajuja Ebacuaque? Nerecabacue ique. Nerecaturaume taa ique, —jadyatu equijahuatira Jesús acuare jebuda quique eque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jadya quiqueyajutu Jesúsra bacaduracuare ecuita: —¿Ai bacani mique? —Ique Umadaque bacani, ecuana dyaque umada tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Cuinanashaume taa ecuana rehuaque, —jadyatu ijahua cuana caquemitsaticuare ecuitaja quisarati eque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tuhuatu jetiama cuchi cuana araaranibarecuare emata jiruru. ");
INSERT INTO cavNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ijahua cuanaratu Jesús acuare: —Panubi ecuana cuchi cuanaju, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—Nenubicue taa, —jadya tuna Jesúsra acuare. Tumetu ijahua cuanara quijahuatishajacacuare tumeque ecuita. Tuaquejaque cuinanatsu tuna cuchi cuanaju nubibarecuare. Jetiamatu cuchi cuana jucuare; beta mil cuchi cuana ni tuna jucuare. Dutya cuchi cuana ijahuaqui cuanaque tuna tsajajayaque pacacadirucuare bei tihuesu baruda eque. Beiju pacacatsu tuna huiditerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Cuchi cuana naru juya cuanaratu bacuare jadya juyaju. Ejecutana tuna tsajajaterecuare epu ebariju. Cuetiyara tunajatu epu cuana juque cuejabarecuare tuhua eje bucha juhuaque. Epu ebariju judirutsu tunajatu tumeque quisarati nucadya tsapedirunucacuare. Tunara cuejayaque bacatsutu ecuita cuana cuabarecuare eje bucha juhuaque petara. ");
INSERT INTO cavNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Junaticuare tuna Jesús queja. Tuhua junatitsu tunajatu banaticuare ecuita equijahuati juhuaque tuhua juaniyaju. Ecajututi, tuja jida inime tsehue, equijahuatijaca jadya tunajatu banaticuare. Jadya banatitsu tuna dyaque cuita eanajacata jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jesúsra equijahuatija ijahua cuana ijehuecuinayaju baqui jucuare cuanaratu peya cuana cuejacuare eje bucha juhuaque. Tunara tuna cuejacuare Jesúsra eje bucha cuinanashae tumeque ecuita juque ijahua cuana tuque quijahuatishaquique ahuaque. Tumebaedya tuna cuejatsacuare cuchi cuana equijahuati cuanaque beiju pacacateretsu huiditerehuaque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jadya bacatsu tunajatu Jesús acuare: —Dirucue rehuaque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Tunara jadya ayajutu Jesús anibutecuare cuabaju. Cuabaju anibuteyajutu ecuita equijahuatijacara Jesús acuare: —Ique miatsehue junenicara juya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—Aijama. Rehuadya anicue. Dirunucacue micue ata cuana queja. Cuejadirucue ecana Mique Cuatsashaquira micue ishu dutya ahua cuanaque. Cuejadirucue ecana era mique jida iyuhue tsehue bahuaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Tura jadya ahuajutu ecuita dirucuare. Dirutsu tujatu ecana dutya cuejaajecuare Decápolis epu cuana juque, tuque Jesúsra eje bucha ahua cuanaque. Dutya tuna anajacatacuare tumeque quisarati bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesústu tura mepehua cuana tsehue cuaba eque carequetinucacuare bei yueque macare. Judiruhuajutu jetiama ecuita cuana jutinucacuare tuaqueja bei jiruru. ");
INSERT INTO cavNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tuna tsehue quisaratiyajutu ecuita Jairo bacanira jipeticuare. Tuquetu caradati ishuque etare juque inime metseque jucuare. Jesús banatitsutu nuyunaticuare tuja yacuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Isaracuare tuja tuque: —Nerecabacue ique. Ecue ebacujunatu majuhuie cuita. Mique jiteque ique jehua. Necua ecue etareju. Jabaticue micue emetucu tsehue. Jabatsu chachaneticue, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tura jadya ahuajutu Jesús cuacuare Jairo tsehue. Umada ecuita cuanaratu tupujudya ayaque naiishacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tumeque ecuita cuana ducudyatu jucuare epuna ujejedaque. Peadya tunca beta earacana maratu amena nerecada, ujejeda jucuare. Ebacuatare tujatu jidama jucuare; ami tujatu jucuaredya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Eje uma casamati bahue cuana quejatu casamamereticuare datse. Dutya tuja chipiru aniyaquetu quijehuetillaticuare casamameretiyaque. Jadya ama buchatu ni ejeradya jutidya chachanecuare ama. Dyaquetanaajecuaredya jutidya tuque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesusrapa ecana chachaneya jadya bacatsu tujatu Jesús etibene eque jipeajecuare ecuita cuana ducu equedya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Tura jutuyaque jabatsu cuanadya jutidya chacha ejuu”, jadya tujatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jipetitsu tujatu jabacuare Jesúsja unaju ebebacuaju ehuejitaque. Tura jabaya tsehuedya tujatu neticuare ami. Chacha cabaticuare tuja ecuita ujejedaque. ");
INSERT INTO cavNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tumetu Jesús caadebaticuare tuja casa tsehue ejeque cuana chachanehuaque. Jadya tibudya tujatu tibene bajiyu acuare ecuita cuana ducu queja. Bajiyutsu tujatu bacaduracuare: —¿Aira jabahua ecue unaju? ");
INSERT INTO cavNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jadya juyajutu tura mepehua cuanara jadya acuare: —Jeedya bacuemi ecuita cuanara naiishaya. ¿Eje bucha juatsu mira ecuana bacaduraya aira jabahuaque? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Caquemitsatimaradya jutidyatu Jesúsra petatibarillanucacuare, adeba ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Epunatu caadebaticuaredya tura chachanehuaque. Tuja etibene quejaquetu juticuare tuja yacuaju. Tadadayaquetu tuja yacuaju chichucata juticuare. —Ique micue una jabadaditsu chacha juhua, —jadya tujatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—Mama, chachami juhua, mira era chachaneyaque pana ejene ahua tibu. Cacasaticue. Inime tsapema dirucue. Amena tuque micue ujeje anihuaque chacha juhua, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Tuque quisaratiya jarijudyatu yana dujuqui cuanaque juticuare Jairoja etare juque. —Micue bacujunatu amena majuhua. Ai jiteque ni tu Ebahuityaquique cuama amena, —jadya tunajatu Jairo acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Arepa tunara huaraji jadya cuejayaju bacaya ama buchatu Jesúsra jadya acuare: —Jidama inime baume. Cacasaticue. Eaqueja nimee camadya jucue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Pedro, Santiago, Juan (Santiago tsehuequique) jadya tujatu ecana acuare: —Micuana camadya eatsehue nejecue. Tuhuadya umae paneti, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Junaticuare tuna huarajija etareju. Junatitsu tuna Jesúsra emajuque naru ishu bajejeyaju banaticuare. Bacaajecuare tujatu ecana quique, pau pau juyaju. ");
INSERT INTO cavNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nubinatitsu tujatu ecana jadya anaticuare: —¿Aishu tuque micuana emajuque naru ishu bajejeya? ¿Eje bucha juatsu tuque micuana majuhuaque jidama inime ishu baya? Tumeque ebacujuna pijitu majuma. Tahuiya jutidya tuque, —jadya tuna Jesúsra anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jadya bacatsutu ecuita cuanara ijaribacuare, tunara yuneri cuitadya emaju baya tibu. Ecanajetijacatu ebacujuna piji jucuare. Tume tuna Jesúsra dutya cuinanashacuare. Nubiquerecuare tujatu ebacujuna pijija etataque ecatse, quimisha tura mepehua cuanaque jadya camadya. Nubinaticuare ecana ebacujuna piji emajuque jarayaju. ");
INSERT INTO cavNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tuhua nubinatitsutu Jesúsra emetucuju inanaticuare ebacujuna piji emajuque. Isaranaticuaretu emajuque: —Talita, cumi (“Ebacujuna piji, netitsuracue” jadique). ");
INSERT INTO cavNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tura jadya ayaju cuitatu ebacujuna piji canajetietinucatsu, anitsura netitsura jadya juatsu ajecuare. Peadya tunca beta earacana mara tujatu anicuare. Tuque ajenucaya baatsutu tuhua jucuare cuanaque dyaque anajacatacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Tume tuna Jesúsra nereda bucha cuejae acuare: —Cueja cueja neaume ni ejeque riya jadya juhuaque, —jadya tujatu ecana acuare. Jadya juu jadya juatsu tujatu ecatse acuare: —Nemihuacue, —jadya tujatu acuare ebacujuna pijija etataque ecatse. ");
INSERT INTO cavNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesústu dirunucacuare tuhuaque. Cuacuaretu Nazaretju, tuque catemuticuareju. Tura mepehua cuana tsehuetu cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Amena canajara huecaca juetihuajutu cuacuare caradati ishuque etareju. Nubitsu tujatu tuhua cuanaque bahuityatibunenucacuare. Anajacatacuare ecana, tura jidaque quisarati cuejayaju bacatsu. —Riyaque ecuita taa dyaque inimequi quisarati ishu. ¿Eju jatsuri riyaque jadya quisarati cabahuityatihua? ¿Eje bucha ae jatsu rejari eau ejeque ecuitara ayaque ama? ");
INSERT INTO cavNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nanadaju ecuanara bacuareque taa riya. ¿Riyaquedya ama jatsu ri Joséja ebacuaque, mesa, caju cuana pujija ebacuaque? ¿Mariaja ebacuaque di taa riya? ¿Riyaque di taa ri Santiago, José, Simón, Judas jadyaja eujique? Tuja enuu cuanaque tupuju cuanaque taa rena rehua ecuanaja epujudya aniya, —jadya tuna jucuare. Tunara nanada equedya bahua tibu, tunajatu ejenecarama acuare tuque Mesiasque, Yusuja Emepeque jadique. Jadya tibudya tunajatu bacacarama acuare tura bahuityayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesúsra tuna acuare: —Quisarati dyaque jida cuanaque cuejaqui cuanaque tuna dutya queja jida batsataya, tunaja epuju cuanara cuita bacue aijama. Dutyara tuna pana ijacabaca aya; tuja etareju cuanara cuita bacue aijama, —jadyatu Jesúsra acuare Nazaretju cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tuhua tuja epuju tujatu anericuare ama ai ejeque ecuitaja ataquique ama, tuhua cuanaque tuaqueja catyaticarama juya baatsu. Eje uma piji ujejeda cuanaque cuita camadya tujatu chachanecuare, tuja emetucu tsehue jabatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Turatu bape cuita bacuare, eje uma piji ecana tuaqueja catyaticara juya baatsu. Jadya juatsutu Jesús junenicuare epu ashaasha cuana japadamaju ecuita cuana bahuitya. ");
INSERT INTO cavNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sitacuare tujatu peadya tunca beta earacana tura mepehua cuanaque. —Necuacue beta beta cama ecue quisarati cuejara. Ijahua cuana ijehuecuina ishu micuana tyaya casa. ");
INSERT INTO cavNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Tuna cuadishahuaque cuahuie tujatu ecana acuare: —Micuanara tsahuatiya cuanaradya micuana tsujema tyatsaya micuanara ai sareya cuanaque, micuana Yusuja mere juyaque baatsu. Jadya tibudya sari cuita camadya necadujuticue. Necadujutiume shitara ni chipiru. Cadujutitaqui ama micuana ara ishuque ni jutu ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Asicada juatsu catacati ishu jutu ishuque necadujutiume. Zapato jutuyaque cuita camadya necadujuticue. ");
INSERT INTO cavNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ejeque epuju junatitsu, ejera jida batsayaju, tuhuadya neanicue tuja etareju, peya epuju dirunucaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eju junatiyaju ecuita cuanara batsacarama ayaju, eju tunara micuanara cuejayaque bacacacarama ayaju, masadama necuinanacue tuhuaque. Cuinanayaque neitataquenacue muru micuanaja ehuachi juque, “Aine yatse micuana tsehue juma”, jadya tuna ayaque. Tunadya tuna inime metse Yusuja quisarati bacacacarama ahua tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Epu cuana tupu tuna junenicuare Yusuja quisarati cueja juyaque. —Inime necacuareticue. Peya inime nejucue micuanaja jucha cuana aniyaque caadebatitsu, —jadya tunajatu ecana cuejaajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ijehuecuinacuare tunajatu jetiama ijahua cuanara quijahuatishaya cuanaja ijahua cuana. Jetiama tuna ujejeda cuanaque chachanecuare, iyucaju riya piji etseri juratsu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ecuari Herodesratu bacacuare Jesús ai juyaque, eje bucha juyaque jadya. Dutya quejatu ecuita cuanara Jesúsja ishu quisarati acuare. —Tumeque Jesústu baya ecuita ama. Juan Ecuita Cuana Utsaquique emajuque cacuitatitsu netitsuranucachineque tume. Jadya tibudyatu Jesúsja casa aniya ejeque ecuitaja ataquique ama aishu, —jadyatu Herodes jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Peya cuana bacue jucuare: —Elías ecacuitatique jutidya tume, Yusu equeque quisarati cuejaquique. Peya cuana bacue jucuare: —Jesústu beru Yusu equeque quisarati cueja jucuareque jutidya, emajuque enetitsuranucaque. Jadya tuna cuji cuita juatsu quisaraticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Dutya ecuita cuanara quisarati ayaque bacatsutu Herodes jadya junucacuare: —Tumequetu Juan era iyuca tubumerechineque. Jesús bucha cacuitatitsutu netitsuranucachine, —jadyatu tuque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Iyacua micuana Juan eje bucha iyetanae jucuareque cuejaya. Herodes patu caquemiticuare Herodías tsehue, arepa tumeque epuna tuatsehuequi Felipeja ehuaneque jucuare ama bucha. Eje uma cuejadya datse patu Juan Ecuita Cuana Utsaquira acuare: “Caquemititaqui amami micue miatsehuequija ehuaneque tsehue”. Jadya cuejayaju patu Herodes cahuaiticuare Juan tsehue. Jadya juatsu tujatu sudaru cuana queja inamerecuare. Inameretsu tujatu cadena tsehue risimeretsu etare apudaju ishamerecuare. Tura Herodías dyaque bijida baya tibu tujatu Juan jadya amerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Juanra jadya quisarati ahuajutu Herodiasra dyaque ujeu bacuare. Iyemerecara ebari tujatu acuare. Jadya ama bucha patu Herodesra acuare: “Eje bucha juyaju ni tuque iyema”. ");
INSERT INTO cavNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodestu bahuedya jucuare Juan Ecuita Cuana Utsaquique tuyuque, tuque Yusuja inime eque aniyaque jadya. Inime tujatu tupucuare “Yusura taa enerecaturau, era Juan iyemerehuaju”. Jadya tibudya tujatu etare apudaju ishamerecuare jutidya. Eje uma cuautu etare apudaju jucuare Juan tsehue quisaratira, tura cuejayaque bacacara ebari aya tibu. Jadya ama buchatu bape bape inime tupu tsehue jutidya cuinana bahue jucuare, inime cacuareticarama juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Chamacamatu Herodiasra eje bucha iyemeree Juan aishuque emajaca dadicuare. Cuinana huecaca camaratsurutiyajutu Herodes chine caticuare. Cuejamerecuaretu dutya huaraji inime metse cuanaque. Sudaru cuana cuatsashaqui cuanaquetu cuejamerecuaredya. Tumebaedyatu Galilea yahua juque dutya inime metse cuanaque cuejamerebarecuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Tuna araarayajutu Herodiasja ebacujunaque dutya ihuarahua cuanaja yacuaju ijahue juishu nubiticuare. Jadya tuque ijahue juyaju baatsutu Herodesra bijisericuare tuja ijahue, tumebaedya tuatsehue araaraya cuanara. Tuja yatuca eque dyaque jida baatsu tujatu epuna ehue ebari acuare: —Bacacue ique ai mira bijida bayaque. Etyaudya mique era. ");
INSERT INTO cavNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yusura ique panerecatura, era mique tyaana ayaque tyayaque ama juatsu. Ique chipiruqui. Jetiamaja ecuari ique. Etyaudya mique ecue ai aniyaque patya jaque, mira bacayaque juatsu, —jadyapa tujatu epuna ehue ebari acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jadya ahuajutu tumeque epuna ehue ebari cuinanaquenacuare etare juque. Tume tujatu ecuaque bacaduraticuare: —¿Ai mira bacamerecara aya? —Bacacue Juan Ecuita Cuana Utsaquija iyuca, iyuca camadya, —jadyatu ecuaquera acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tumetu epuna ehue ebari nubinatinucacuare ecuari Herodes queja. —Iyemerecue Juan Ecuita Cuana Utsaquique. Pititubumeretsu tuja iyuca pejaju iyatsu ique inamerecue. Riyaque mique bacaya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jadya ahuajutu Herodes dyaque peya inime jucuare. Jadya ama bucha tujatu eje bucha tyataqui ama amadya bacuare, tura quisarati ahuaque tuatsehue chine juya cuanaja ijacaju jadya juhua tibu, “Yusura ique panerecatura, era tyaana ahuaque tyayaque ama juatsu”. ");
INSERT INTO cavNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jadya tibudya tujatu cuatsashacuare tuja sudaru: —Juan Ecuita Cuana Utsaquique pititubuticue. Pititubutitsu tuja iyuca beticue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jadya ahuajutu cuacuare etare apudaju. Cuaatsutu pititubuticuare Juan. Tubutsutu Juanja iyuca pejaju iyatsu epuna ehue ebari tyaticuare. Tura tyatihuaju tujatu ecuaque inamereticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jadya juhuaque bahue juatsutu Juanra mepehua cuanara emajuque queticuare. Dujutsu tuna ishaticuare caniju. (Herodesratu dutya tume cuanaque inime tupuqui acuare. Jadya tibudya tujatu Jesús, Juan Ecuita Cuana Utsaquique chacha enetitsuranucaque bucha bacuare.) ");
INSERT INTO cavNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jidaque quisarati cuejara cuadishatanacuare cuanaque juetitsu tunajatu cuejaeticuare Jesús tuna eje bucha jutihua cuanaque, dutya tunara bahuityatihua cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tunara tuque tuna junenitichine cuanaque cuejayaque tsunumeetu ecuita cuana Jesús queja umae jutiya, diruya jadya jucuare. Tuja, ni tura mepehua cuanaja jadyatu aijama emajaca jucuare ni araara ishu. Jadya tibudya tujatu ecana jadya acuare: —Necuara peya queja amaca ecuana taca jari. Ecastere micuana juneniyaque. Necanajaraticue jari tuhua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jadya cacuejatitsu tuna cuacuare cuaba eque peya queja amaca ajetaya ama queja. ");
INSERT INTO cavNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Umada ecuita cuanara tuna badadicuare cuayaju. Adebadadicuare tuna eju Jesús cuayaju. Tume tuna Jesús cuayaju badaditsu ecuita cuana dutya epuju cuanaque tsajajabarecuare Jesús tura mepehua cuana tsehue cuaya queja. Baredadicuare tunara. Icueneta junati ecana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Cuaba juque cuinanayaratu Jesúsra bacuare jetiama ecuita tuque ihua juyaju. Jadya baatsu tujatu ecana nerecada banaticuare. Uhuisha cuana aija naruquima juneniyaque bucha tujatu ecana banaticuare. Jadya tibu tujatu ecana jetiama Yusuja quisarati cuejatibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Amena ijeti nubihuietu tura mepehua cuanara Jesús jipeticuare. —Amena taa ri chinehua. Rehuari aijama ni eju buchique ara ishu cuanaque quemi ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Isaracue ecuita cuana. Padiru ecana epu cuanaju, epu ashaasha cuana japadamaju. Pacabacatidiru ecana ara ishu cuanaque, —jadya tunajatu aticuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—Cuadishaya ama tuna era. Micuanaradya ecana nemihuacue, —jadya tuna Jesúsra acuare. —Ecuanaja dyadi taa ri aijama ecuita jetiamaja ara ishuque quemi ishuque. Jetiama taa tuque ecuana chipiru esareu, tuna tupu, dutya mihua ishu. Beta ciento ficha taa tuque ecuana esareu, peadya ecuita shucuta badi mere ejuuque etsujequi tupu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—¿Eje uma pan jatsu ecana cabetihua? Nebacaduraticue, —jadya tuna Jesúsra acuare. Bacaduratitsu tunajatu cuejaeticuare: —Pishica pan, beta jae jadya piji camadya tunaja aniya. ");
INSERT INTO cavNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Tume tujatu ecuita cuana cuarequi cuarequi iyabutyamerecuare tuhua tuna netibareyaju cuitadya. ");
INSERT INTO cavNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Dutya ecuita cuana anibutecuare. Peadya cuareju cien, peya cuareju pishica tunca jadya tuna jetiama cuare anibutebarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jadya juatsutu Jesúsra inaticuare pishica pan, beta jae jadya. Inatsu tujatu barepa Yusu aniya queja petacuare. Petayaquetu jucuare: —Yusurupai mique aya, Tata, mira ecuana riyaque ara ishuque tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai au jadya aatsu tujatu pan cuana cuesibarecuare. Jadya aatsu tujatu tyabarecuare tura mepehua cuanaque, ecuita cuana tunaja tyabare ishu. Betaque jae umanashatsu tujatu ecana tyabarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Dutya tuhua jucuare cuanaque tuna araaracuare, pana jeque juya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jadya juhuajutu Jesúsra mepehua cuanara jequeshabarecuare peadya tunca beta earacana jiti arida cuanaque pan tunara arabishahua cuana tsehue, jae jadya tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jetieque ama tuna araaracuare. Pishica mil deca cuana tuna araaracuare; epuna cuana, ebacua piji cuana jadya piyebamaque. ");
INSERT INTO cavNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tumetu Jesúsra tura mepehua cuanaque jadya acuare: —Neanibutecue cuabaju. Necarequeticue bei yueque macare epu Betsaida bacaniju. Tumidya micuana adadiya ecuita cuana isaratsu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Amena ecuita cuana cuadisha ishu isaratsutu Jesús tsuracuare emata baruda cuita amaju Yusu tsehue quisarati ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Cuaba tsehue cuahua cuanaque tuna bei patya patya apunacuare. Jesús camadyatu jucuare uhuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Japada equera tuna Jesúsra bacuare masada nerecada tsehue tarutaruyaju cuejijira acuatsuraya tibu. Amena huecaca japadama tacure quique pidya juhuaju tuna Jesúsra jipedirunucacuare, ena dyaque eque ajeajeyara. Baredirucara datse tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jesús ena dyaque eque ajeajeyaju baatsu tuna quiquecuare: —¡Ita nebacue! ¡Yatanana tume! —jadya tuna quique eque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Dutyara tunajatu bape inime tillaqui jadya acuare, ena dyaque eque ajeya baatsu. Jadya juyaju tuna Jesúsra isaracuare: —¡Bajida nejuume! ¡Idya ique! ¡Casada nejucue! —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tumetu tsuracuare tuna queja cuabaju. Tuque cuabaju tsurahuaju cuitatu amena cuejiji neticuare. Jadya baatsutu tura mepehua cuanaque anajacatacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Tunaratu adebacuare ama jari tuja casa aniyaque, arepa tura pan, jae jadya jetiama ecuitaja ishu tupu amerehuaque bahua ama bucha. Adebataqui ama jari tuna bacuare Jesús aique. ");
INSERT INTO cavNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Bei riquetsu tunajatu Genesaret yahuaju jaratsuranatitsu cuaba risinaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Muya jutidya, tuna cuaba juque cuinanayajutu tuhua aniya cuanara Jesús adebatsa piisi acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Masadama tunajatu tsapecuare quisarati tuque junatihuaque. Dutya jujeri tuhua cuanaque tuna bahue jucuare. Jesús, tura mepehua cuanaque jadya tuna epu epu cuanaju junenicuare. Jesús tunaja epuju junatihuaque bahue juatsutu tuhua cuanara dujubarecuare ebadequi cuanaju ujejeda cuanaque tuaqueja. ");
INSERT INTO cavNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Eju tuque junatiyaju epu achaacha cuanaju, epu arida cuanaju, tee cuanaju aniya cuanara jadya tunajatu cuinanashabarecuare edijiju ujejeda cuanaque. Canerecaticuare tuna tuaqueja: —Cajabamereticue taa ujejeda cuana queja micue una cuatsa cuana pijidya jutidya, tuna chacha juishu, —jadya tunajatu Jesús acuare. Dutya ejeque tuja una jabaqui jucuare cuanaque tuna pana chacha jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Umae fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya tuna juticuare Jerusalén juque. Junatitsu tunajatu Jesús jipeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Tuhuadya tunajatu bacuare Jesúsra mepehua cuanaque tunaja bahue ama juyaju emetucu cutsatimaque araarayaju. ");
INSERT INTO cavNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Dutya ecuanaja ata cuana, fariseo cuana neri neri, ecuanaja baba cuanaja bahue eque tuna anijacaya ama. Araaraya ama tuna tunaja bahue emetucu cutsatimaque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mercadoju quemihuaque arama jarique tunajatu utsajacama aya tunaja bahue. Tumebaedya canecu cuana, ena iyaqui arida cuanaque, equiniqui metal cuana tunajatu utsa bahue tunaja bahue. Tumebaedya tuna cutsati bahue etahuiqui cuana. Dutya ecuanaja baba cuanaja bahue tunajatu ajacaya ama. Jadya tuna juya, jadya jujacatsu Yusu cahuaitishaya bucha cabatitsu. ");
INSERT INTO cavNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jesúsja cuanaque cutsatima araarayaju baatsutu fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya quisaraticuare: —Mira mepehua cuanaquetu ecuanaja baba cuanaja bahue eque ama juya. Araara ishutu micue cuanaque emetucu cutsatiya ama ecuanaja bahue eque Yusu cahuaitisha ishu ama. ¿Eje bucha juatsu? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tura tuna quemitsacuare: —Yusu adebaquipa ejuu, jadya micuana juya, ai yuneri ama. Isaías Yusu equeque quisarati cuejaquiratu micuana jadya ayaque huenecuare jadya: “Riyaque ecuita cuanara muiya tunaja quisarati tsehue camadya. Jadya ama bucha tuna eje bucha juya eque ejitaju ecue cuanaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yana cana cuita tunara tunaja bahue cuana eque muiya. Tunara bahuityayaquetu ecuita cuanara inime tupuyaquedya jutidya”, jadyatu Yusu jucuare Isaías eque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Micuana micuana Yusura cuatsashaya eque anijacahua, ecuita cuanara cuatsashaya eque ani ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Micuanaratu dyaque ijacabacaya ecuanaja baba cuanara cuejahua cuanaque, Yusura cuejayaque ebacauque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés equetu Yusura cuatsashacuare béru: “Muibacue micue tata, micue cuaa jadya”. Tumebaedyatu jucuare: “Paiyetana ejeque etataqueja ishu, ecuaqueja ishu jidama quisarati ayaque”. ");
INSERT INTO cavNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","Micuanaratu cuarehua riyaque cacuatsashati. Tume micuana, micuanaja tata nerecada cuanara catsahuamereti ishu bacayaju, jubahue: “Tsahuataqui ama mique ecue, amena ecue dutya ai aniyaque Yusu etya tibu”. ");
INSERT INTO cavNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jadya apupashae tuque micuana Yusura cuatsashahuaque aya, micuana cuejatahua cuana equedya jutidya juishu. Micuana camadya ama micuana jadya juya. Tumebaedya micuana peya cuana casada tsehue amereya micuana juya bae. Umada ecuita cuanaja bahue cuanaque micuana ajacaya ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tumetu Jesúsra ihuaracuare ecuita cuana tuhua ejeuma netiya cuanaque. Tume tujatu ecana acuare: —Nebacacue ique dutyara. Pana ijacabaca neacue. ");
INSERT INTO cavNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ni ai buchique micuanara arayara micuana cajuchatishaya ama. Micuanaja ducuta inime jidamaque cuinanayaratu Yusu cahuaitishaya. ");
INSERT INTO cavNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Micuana quijacabacati aqui juatsu, nebacacue, —jadya tujatu ecana acuare: ");
INSERT INTO cavNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jadya isara aatsutu Jesúsra ecuita cuana isaraquenacuare. Nubidirucuaretu etare ducu. Amena tuque etareju nubidiruhuajutu tura mepehua cuanara bacaduracuare: —¿Eje buchique tu tumeque mira ecuita cuana bahuityahuaque? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—Arepa micuana eatsehue juneniya ama bucha, tuque micuana adebaya ama jari micuana era eje buchique bahuityacara ayaque. Ni ejeque earaquira micuana cajuchatishaya ama. ");
INSERT INTO cavNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Arayaquetu ecare canijudya judiruya. Tuhuaquedyatu cuinanaya. Ni eje tuputu nubiya ama ecuanaja inime Yusu adebaquiju. Jadya tibudya ecuana, ecuanara arayara cajuchatishaya ama, —jadya tujatu ecana acuare. Jadya cuejae aatsu tuna Jesúsra huecashacara acuare. Aijamatu ejeque earaqui arataquimaque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesusratu tuja cuanaque isaranucacuare: —Educu juquetu ecuitaja juetiya cajuchati ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Iyuca juquetu jidamaque aishuque bijiseri juetiya. Tuhuaquedyatu jidamaque aishuque inime tupu juetiya, eje tsehuedya jutidya decadeca, puna puna jadique bijiseri, chiri jucaraque, peya iyecaraque, ");
INSERT INTO cavNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","peya tsehue ecaquemitique jaraquerecaraque, tuja ishu cuita camadya ai umada aniajecaraque, dutya ai jidamaquedya jutidya acaraque, peya ijahue acaraque, ai ajaca baecuaque acaraque, peya jaque metsene ishu bijiseri, peyaja ishu jidama quisaraticaraque, dyaque inime metse jucaraque. Tuhuaquedyatu aishuque ama inime cuinanaya. ");
INSERT INTO cavNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Dutya riya cuanaque acaraquetu educu juque cuinanaya. Dutya riya cuanaratu ecuita cajuchatishaya. Yusuratu asicabaya riya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesústu cuanucacuare tuhuaque. Tumetu cuacuare Tiro queja amaca. Epuju junatitsutu etareju nubicuare. Tumeque etarejutu etehua junati datse jucara jucuare. Eje bucha etehua junatitaqui ama tu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Anicuaretu tumeque epuju peadya epunaja ebacujunaque ijahua cuanara quijahuatishayaque. Bahuetu jucuare epuna Jesús junatihuaque. Bahue juatsutu yume cuau cuitadya Jesús queja jucuare. Junatitsutu Jesúsja yacuaju nuyunaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Tumeque epunatu israelita ama jucuare. Sirofenicia yahuaju ecuinanaque patu jucuare. Jesúsja yacuaju nuyutsutu canerecaticuare: —Ique Cuatsashaquique, nerecabacue ique. Ijehuecuinacue ijahua cuana ecue ebacujuna juque, —jadyatu epunara aticuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—Icuene tuque ecue israelita cuana tsahuataqui. Aijama jari tuque ecue emajaca ecue ata ama cuanaque tsahua ishu. Adebayami quisarati: “Jidama tu ebacua cuana earaqui secatsu chapa cuana tyau” jadique, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Epunaratu quemitsacuare: —Jejee, Ique Cuatsashaquique. Jadya ama buchatu chapa cuanara enimetsequeja ebacua cuanaquera mesa emaque pacacashaya cuanaque arayadya, —jadyatu acuare epunara. ");
INSERT INTO cavNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—Jidadya mira quemitsahua. Jadya caquemitsati juatsumi ejitajudya juhua era micue bacujuna juque ijahua cuana eijehuecuinauque, pana ejene ayaque. Jida dirucue. Micue etareju judirutsu tuque mira micue bacujuna ijahua cuanara jacahuaju badiruya. Ijehuecuinatillahua tuja tuque ijahua cuana, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jadya ahuajutu epuna dirunucacuare tuja etareju. Etareju judirutsu tujatu ebacujunaque badirucuare amena quijahuatijacahuaju. Dyaque jida inime tsapematu tuja etahuiquiju jaracuare, ijahua cuanara amena jacahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro juque cuinanatsutu Jesús Galilea beiju judirunucacuare. Sidón yahua, Peadya Tunca Epu Ebari Cuana equetu cueticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tuhuadyatu ecuita cuanara tuaqueja dujucuare ecuita isahueque, quisarati baecuaque jadya. Tuaqueja dujutsu tunajatu isaracuare Jesús: —Nerecabacue ecuana. Jabacue riyaque ecuita, tuja ijaca pacashatana ishu, quisarati ishu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesusratu dujucuare peya queja amaca, ecuita cuana riya piji jacamere ishu. Tuhua dujutsu tujatu emetucu sapara huicuabu ecatse beta eque amaca ijaca caniju ishacuare. Tuequedya tujatu emetucu sapara tuja ijaca cani juque yume quemi acuare. Emetucu sapara huicuabu tujatu ecuedi iyacuare. Jadya aatsu tujatu pepacuare ujejedaja yanaju. ");
INSERT INTO cavNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jadya aatsu tujatu petacuare barepa. Canajeti ebari juatsutu jadya jucuare: —¡Efata! (“Pacashatanacue ijaca cani ecatse” jadique.) ");
INSERT INTO cavNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jadya ayaju cuitadyatu ecuita jida quijacabacati, quisarati jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesusratu ecuita cuana acuare: —Cueja cueja ecana neaume, —jadya tuna Jesúsra acuare. Jadya ama bucha tuna quisarati tsapecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jesúsra quisarati baecuaque, isahueque jadique quijacabacatisha, quisaratisha jadya ahuaque bacatsaqui jucuare cuanaque tuna anajacatacuare. —¡Dutyatu jida aya! Isahue cuanaquetu jida quijacabacatishaya. Quisarati baecua cuanaquetu quisaratishaya, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Eje uma huecaca ama jadya juchineque cuetihuajutu ecuita jetiamaque cuanucacuare Jesúsra cuejayaque bacara. Tuna aracara juyaque adebatsutu Jesúsra tura mepehua cuanaque ihuaracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nerecada taa rique ecuita cuana arama baatsu baya, riya barepa tibene equeque taa rena ique ijacabaca juyaque. Amena taa renajari aijama ara ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Cuadishacarama taa rena aramaque aya tunaja etare cuanaju. Edijiju taa rena emajudiruu. Umae taa ri japada aniya cuanaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—¿Eje bucha dadie jatsu tuque ecuana eau earaqui ecuita jetiamaja ishu, rehua ni ejeque buchique anitaya amaju? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesúsra tuna bacaduracuare: —¿Eje uma pan micuanaja aniya? —Pacarucu piji camadya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tuequedya tujatu iyabutyamerecuare ecuita cuana. Yahuaju iyabutyameretsu tujatu inacuare pacarucu pan. Pan inatsutu jucuare: —Yusurupai mique aya, Tata, mira ecuana riyaque earaqui tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai aatsu tujatu pan cuesibarecuare. Cuesibaretsu umanashatsu tujatu pan tyabarecuare tura mepehua cuanaque. Tyahuaju tunajatu tyabarecuare ecuita cuana. ");
INSERT INTO cavNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tumebaedya tunaja anicuare eje uma cuana jae. Jesústu quisaratinucacuare Yusu tsehue: —Yusurupai mique aya, riyaque jae cuana mira ecuana tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai au jadya aatsu tujatu ecana acuare: —Netyabarecue ecuita cuana, —jadya tujatu acuare tura mepehua cuanaque. Jadya aatsu tujatu jae umanashacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Dutya tuhua jucuare cuanaque tuna araaracuare jequeya tupu. Araara amena juatsutu tura mepehua cuanara jequeshabarecuare pacarucu jiti arida cuanaque pan cuesi cuana anidadihua tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Jetieque ama tuna araaracuare. Pushi mil deca cuana tuna araaracuare. Jadya juatsutu Jesúsra ecuita cuana amena isaracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Tuna isaratsutu anibutedirucuare cuabaju, tura mepehua cuana tsehue. Anibutetsu tuna cuacuare Dalmanuta bacani yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Umae fariseo cuanatu Jesús queja juticuare. Catibuticuare ecana Jesús tsehue caquemitsati caquemitsati. Sarecuare tunajatu eje bucha eque jidama aishu. Tume tunajatu Jesús acuare: —Acue ecuanaja yatucaju ai bapeque inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu, —jadya tunajatu acuare, arepa tuna tuque Yusu equeque junahuaque ejenecarama acuare ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesústu ducuta peya inime jucuare, tuna tuaqueja catyaticarama juya baatsu. —“Acue ai inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu”, jadya micuanara aya. Aya ama tuque era, ni aidya jutidya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jadya isarae aatsu tujatu ecana shanaquenacuare. Yudijidya anibutedirunucatu jucuare cuabaju. Carequeticuare ecana bei yueque macare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesúsra mepehua cuanaque tuna cuayaque pan umada cadujuti ishu nime aputacuare. Peadya pan piji camadya tuna cadujuticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesúsra tuna isaracuare: —Neijacabacacue. Necanaruticue bacue fariseo cuanaja, Herodesja jadya levadura tsehue, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tunaratu adebacuare ama tura eje buchique jadya ayaque. Jadya tibu tuna, tuna cama quisaraticuare: —Ecuana pan umadama cabetihua baatsu tura ecuana jadya quisarati tsehue aya, —jadya tuna, tuna cama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesusratu adebacuaredya tuna cabacaduratibareyaque. —¿Eje bucha juatsu micuana, pan umadama cabetihuaju cuana era nereda aya bucha cabatiya? ¡Adebaya ama jaridya ni taa tuque micuana era bahuityayaque! ¡Adebaya ama jari tuque micuana era micuanara ai sareyaque etyauque! Micuanara ecue quisarati bijidamadurahua bucha tuque. ");
INSERT INTO cavNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Micuanaja yatuca tsehuedya tuque micuana bahua micuana era casa bamere ishu ahuaque. Micuanaja ijaca tsehuedya tuque micuana bacahua era bahuityahuaque. Neadebacue era jetiamaque mihuachineque. ");
INSERT INTO cavNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Pishica pan era pishica mil ecuitaja ishu tupu amerechine patya, ¿eje uma jiti tuque micuana jequeshachine pan arabishahua cuana tsehue? —jadya tujatu ecana acuare. —Peadya tunca beta earacana jiti, —jadya tunajatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Pacarucu pan umanashatsu era pushi mil ecuita aramerechineque, ¿eje uma jiti tuque micuana jequeshachine anidadichine cuana tsehue? —Pacarucu jiti, —jadya tunajatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—Arepa micuana era achineque bahua ama bucha taa micuana adebaya ama jari micuanara ai sareyaque tyaishu ecue casa aniyaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tuequedya tuna junaticuare Betsaidaju. Junatihuajutu tuhua cuanara dujucuare Jesús queja ecuita shuhuique. Canerecaticuare tuna tuaqueja: —Nerecabacue ecuana. Jabacue riyaque shuhuique tuque capetati ishu, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jadya ayaju tujatu inacuare emetucuju shuhuique. Inatsu tujatu cuinanaquerecuare epu juque. Cuinanaqueretsu tujatu ecuedi tsehue pepacuare yatucaju. Jadya au jadya aatsu tujatu yatucaju emetucu tsehue jabacuare. Jabatsu tujatu bacaduracuare: —¿Are capetatiyadya mique? ");
INSERT INTO cavNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ecuitaratu petatsu jadya acuare: —Jejee, amena tuque bayadya riya piji. Baya tuque ecuita cuana. Juneniyaju tuna baya. Jadya ama bucha tuna cueyane jida cuita ama aya. Acui cuana bucha jutidya tuna baya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tumetu Jesúsra yudijidya jaba anucacuare yatucaju. Jabanucahuajutu ecuita amena jida capetaticuare. Dutyadyatu jida pana cueyane acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tumetu Jesúsra jadya acuare: —Tuyu diru jucue micue etareju. Epuju yudijidya dirunuca juume, —jadyatu acuare Jesúsra. ");
INSERT INTO cavNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jadya juatsutu Jesús cuacuare tura mepehua cuana tsehue Cesarea Filipo epu ebari japadama anitaya cuana queja. Edijiju tujatu ecana bacaduranaticuare: —¿Eje buchatu ecuita cuanara ecue ishu inime tupuya? ¿Ai jadya tunara aya? —jadya tujatu ecana anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tunaratu quemitsacuare: —Umae cuanarami aya Juan Ecuita Cuana Utsaquique emajuque enetitsuranucaque jadya. Peya cuanarami Elías jadya aya. Peya cuanara bacuemi aya beru Yusu equeque quisarati cuejaquique emajuque enetitsuranucaque jadya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—¿Micuanara bacue, ique ai jadya aya? —jadya tujatu ecana acuare. —Miquemi Mesías, Yusuja Emepeque, —jadyatu Pedrora quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—Necuejaume jari ni ejeque buchique ique Mesiasque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Tumeque huecaca equetu Jesús cacuejatitibunecuare tura mepehua cuanaque tuque eje bucha judadiyaque. —IQUE ECUITA dyaque canerecatitaqui. Emuiba cuanara, pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadya dyaque nerecaturadadiya. Iyemeredadiya tunara ique. Quimisha huecaca juatsu netitsuranucaya, —jadya tujatu ecana cuejatibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Pana ejitaju tujatu ecana bahue amerecuare tuque iyetanadadiyaque. Pedroratu ejenecuare ama Yusuja Emepeque jadya ejudadiuque. Jadya tibudya tujatu peya queja ihuara acuare. Tuna peya queja jacameretsu piji tujatu Jesús nereda atibunecuare: —Jadya quisarati aume. ¡Arequemi jadya ejudadiu ama! —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesústu huarerecuare. Huareretsu tujatu bajiyucuare tura mepehua cuanaque. Tume tujatu Pedro nereda acuare: —Satanástu mique eque quisaratiya. Maju aqui cuana jaque jutidya tuquemi inime tupuya, Yusu jaque ama. Bacacarama tuque aya mique eque Satanás ama amara cuejayaque, —jadyatu Jesúsra Pedro aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tuequedyatu Jesúsra isaranucacuare tura mepehua cuanaque, ecuita cuana jadya: —Micuana eatsehue junenicara juyaque juatsu, era cuatsashaya eque neanicue, micuanaja biji eque juneniyaque nime aputatsu, arepa micuana canerecati, maju jadya jutaqui ama bucha, curusuju etata ejuu bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Micuana ni catehuatiya eaqueja ecatyatique eiyetauju, ejetsunue ama micuana anibuque. Tume micuana majubuque ni eje tupu Yusu queja judiru ishu ama. Micuana ni eaqueja catyatihua baatsu iyetaya, Yusuja quisarati ejenehua baatsu ni micuana iyetaya, Yusu tsehue micuana anisiribuque, arepa micuanaja ecuita ririya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ecuita ni ijahuaja etiquiju judirubuque, ni aishu buchique tujatu jida juhua ama riyaque yahuaju tuja dutya ai anihuaque. Ni aishu buchique tu jida ama dyaque chipiruda juishu, majudaditsu dutyadya shanadadiya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aijamatu ni ai buchique micuanara maju ishu ama etsujetyauque. ");
INSERT INTO cavNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Iyacua riyaque yahuajutu aniya ecue ama cuanaja yacuaju ique eje buchique quisarati aishu bisuya cuanaque. Tunajatu bisu aniya ecue quisarati cueja ishu. Ejeque huecaca IQUE ECUITA junanucabuque. Barepaju Yusu tsahuaqui cuanara tajibebuque. Ique junanucayajutu dutyara babuque ecue Etataja casa. Bisunabuquedya ique tume ecue ishu bisuhua cuana tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Pusha amadya micuana cuejaya. Umae micuana rehua majuhuishaya ama, dutya era ecue casa tsehue narutibuneyaque badadiya tupu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Shucuta huecaca juatsutu Jesúsra dujucuare emata barudaju Pedro, Santiago, Juan jadya. (Juan tu Santiago tsehuequique jucuare.) Tuhuadyatu tunara petayaju cabapeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tuja unatu pajada, huecada dyaque tiquida jucuare. Ni ejeradya jutidyatu riyaque yahua juque ai utsatsu jadya pajae eamereu. ");
INSERT INTO cavNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Masadaque amatu Moisés yanume, Elías yanume jadya ejitaju jucuare. Tume tatse Jesús tsehue quisaratinacuare. Tuatsehue cuacuare cuanaratu bacacuare quisaratiyaju. ");
INSERT INTO cavNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jadya bacatsutu Pedrora Jesús acuare: —Ecuana Bahuityaquique, dyaque jida taa ecuana rehua. Eau tuque ecuana quimisha erere, peadya micue ishu, peya Moisésja ishu, peya bacue Eliasja ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tuque, tuja ecare ecatse jadya tuna dyaque ejecutana jucuare. Jadya tibudyatu tuque ai quisarati ataqui ama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Tumetu barepa juque huanira dunutillacuare. Tume tunajatu bacacuare huani ducuque Yusu jadya quisaratiyaju: —Riyaque rique ecue ebacua dyaque iyuhuedaque. Nebacajacaume. Eje bucha tura cuejaya eque nejucue, —jadya tuna Yusura acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jadya bacatsutu quimisha, Jesús tsehue cuacuare cuanara bajiyucuare. Bajiyunucatsu tunajatu banucacuare ama Moisés, Elías jadya, Jesús camadya. ");
INSERT INTO cavNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Emata juque buteajeyara tuna Jesúsra cuatsashacuare: —Necuejahuishaume jari ni ejeque buchique micuanara eje bucha bahuaque. IQUE ECUITA majuhuaque, chacha netitsuranucahuaju piisi ecana necuejacue, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tura cuejahua equedya tuna jucuare. Jadya ama bucha tuna tuna cama cabacaduratitibunecuare: —¿Eje buchiquetu “Ique majuhuaque, chacha netitsuranucaya” jadique? —jadya tuna cabacaduratiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tume tunajatu bacaduracuare Jesús: —¿Eje bucha juatsutu cacuatsashati bahuityaqui cuanara Eliaspa icuene junabuque, Mesías junama jariju, jadya aya? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Tura tuna quemitsacuare: —Tunara bahuityayaquetu yuneridya. Eliastu icuene junabuque. Turadyatu dutya bajejenabuque. Tumebaedyatu ehuene Yusuja quisarati. ECUITAtu ijahue ijahue atabuque. Pana bijidamadura tunajatu abuque. Yusuja Emepeque eadebau bucha adebae ama tunajatu abuque. ");
INSERT INTO cavNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pusha amadya micuana cuejaya. Elías buchiquetu amena junahuadya. Eijacabacauque, tunajatu ijahue ijahue acuare, tunara acara aya eque. Judadihuatu Yusuja quisarati icueneta huene ea bae cuitadya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesúsra, emata tuatsehue juque buteetibeya cuanara tunajatu bacuare ecuita jetiera ama peya cuana dunuyaju. Tuhuadyatu jucuare cacuatsashati bahuityaqui cuanaque Jesúsja cuana tsehue caquemitsati caquemitsati juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Riya batsa cuita tunajatu Jesús judiruyaju acuare. Batsatsu tunajatu anajacata ishu acuare, tunara emataju jari bucha baya tibu. Batsatsu tuna tuaqueja tsajajabare jucuare tuque isarara. ");
INSERT INTO cavNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusratu isaratsacuare tura mepehua cuanaque: —¿Ai micuana caquemitsati caquemitsati juya tuna tsehue? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Peadya tuhua jucuareratu quemitsacuare: —Behua rique ecue ebacua miaqueja. Ijahua cuanarari quijahuatishaya. Jadya tiburi quisarati baecua. ");
INSERT INTO cavNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ejudya jutidya juneniyajutu ijahuara ecue ebacua yahua catsaqui amereya. Jadya juyaque tujatu cuinanaya uba jasa yatsanaca eque. Etse tari jadya tujatu amereya. Dutya ecuita tujatu temutsuya. Canerecatihua datse ique mira mepehua cuana queja ijahua ijehuecuinamere ishu datse. Arepa ijehuecuinacara aya ama bucha, tuna ijehuecuinataquima bahua, —jadyatu ebacua pijija etataquera Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jadya bacatsutu Jesúsra acuare tuhua jucuare cuanaque: —¡Micuana micuana quejeneti baecua! Arepa micuana era ayaju bahua ama bucha, adebaya ama jaridya tuque micuana Yusuja casa. ¿Eje tupu cuita micuana eiduu? ¿Micuanara adebaya tupu ni taa? Nebecue requeja tumeque ebacua piji, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jadya ahuaju tunajatu becuare. Behuajutu ijahuara, Jesús baatsu, manu amerenucacuare ebacua piji. Tume tujatu yahua catsaqui amerenucacuare. Tipiru tipiru, yatsanaca eque ubajasa jadya tujatu amerenucacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Tumetu Jesúsra bacaduracuare ebacua pijija etataque: —¿Eje tupuri jadya catibuticuare? —Nanada equeque cuitadya. ");
INSERT INTO cavNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Eje uma ijehue cuanatu ijahuara aya etiquiju, enaju jadya iyecara aatsu. Nerecabacue yatse. Tsahuacue yatse, micue casa aniyaque juatsu, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—¿Eje bucha juatsu jatsu mira “micue casa aniyaque juatsu” jadya aya? Ecue ishutu dutya ai ataqui. Ejera Yusura casa tyahuaque ejeneyaratu eau dutya, —jadyatu Jesúsra acuare ecuita. ");
INSERT INTO cavNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tumetu ebacua pijija etataquera pana ejitaju quisarati acuare: —Riya pijidya tuque ejeneya mira ecue ebacua juque ijahua cuana eijehuecuinauque. Tsahuacue ique; pana ejene paa mira jadya ayaque, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Amena Jesúsra umada ecuita cuana caradatiyaju baatsu tujatu nereda acuare tumeque ijahua ebacua piji yuamaturaqui juyaque: —Cuinanacue riyaque ebacua piji quejaque, ijahua quisarati baecua, isahue ijacama jadya amerequique. Cuinanatsu dirucue; ni eje tupumi tuaqueja nubinucaya ama, —jadya tujatu acuare ijahua. ");
INSERT INTO cavNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jadya ayajutu ijahua quiqueterequenanucacuare. Manu tujatu ebacua piji amerequenanucacuare. Jadya aatsutu cuinanacuare. Cuinanatsutu shanacuare ebacua piji emaju bucha. —¡Majuhua tuque! —jadyatu umae jucuare ebacua piji yahuaju jujaraya baatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesusratu emetucuju inatsu nityatsuracuare. Tumetu ebacua piji netitsuracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jadya aatsutu Jesús nubicuare etareju, tura mepehua cuana tsehue. Jesús tsehue camadya cabatitsu tunajatu bacaduracuare: —¿Eje bucha juatsu tuque ecuana ijehuecuinataqui ama bahua tumeque ijahua ebacua piji yuamaturaquique? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—Ijehuecuinataqui ama tuque micuana tumeque ijahua bahua, Yusu tuja casa jadya aishu bacahua ama tibu. Aijamatu peya eje bucha eque cuinanasha ishuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tuhuaque cuinanatsu tuna cueticuare Galilea yahua eque. Jesusratu ecuita cuana tuque ejuque bahue amerecarama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Emajaca tujatu tura mepehua cuanaque bahuitya ishu anicara jucuare. Ni aija perema tujatu ecana bahuityacara acuare. —Ejera cuana tsetatsu inameredadiya IQUE ECUITA. Inameretsu tura ique iyecara juya cuana queja iyemeredadiyadya. Iyedadiya tunara ique. Iyehuaju quimisha huecaca juatsu netitsuranucaya, —jadyatu cacuejaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Adebacuare ama tunajatu tura cuejayaque. Bacaduracarama tunajatu acuare tura eje buchique jadya ayaque, adebataqui ama baatsu bacadurayaju nereda eau bucha caadebatitsu. ");
INSERT INTO cavNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tuequedya tuna junaticuare Capernaum epu ebariju. Etareju junatitsu tuna Jesúsra bacaduranaticuare: —¿Ai tuque micuana caquemitsati caquemitsati ishu abeabehua edijiju jeyaque? Jadya tujatu ecana bacaduracuare, arepa tuque tunara eje buchique quisarati ahuaque bahue jucuare ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Tuna tuna anama cuitadya jucuare. Bisucuare tuna, tuque quemitsa ishu, tura mepehua cuanaque ecana ejequepa ecana dyaque inime metseque jadya juatsu caquemitsatihua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Anibutetsutu Jesúsra acuare tura mepehua cuanaque: —Nejecue. Nejipenacue ique. Micuana ni emuita jucara juya, dyaque jetiedyaque bucha necabamereticue. Camereti arida ejuuque, nemerecue jutidya peya cuana, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jadya juatsu tujatu ihuaracuare ebacua piji tuhua netiya baatsu. Ihuaratsu tujatu tuna patya nityacuare. Ebacua pijija yaracacaju tujatu ebi ecatse huanacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Micuanara ni ecue cuanaque jida tsehue batsaya, arepa tuna riyaque ebacua piji bucha paju ama bucha, idya datse micuanara jida tsehue batsaya. Micuanara ni ique jida tsehue batsaya, tume tuque micuana ecue Etata Ique Cuadishaquique jidadya batsaya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juantu quisaraticuare Jesús tsehue: —Ecuana Bahuityaquique, ecuana micue quisarati cuejara cuachine patya, tuque ecuana bachine ejeque cuana ijahua cuana micue ebacaniju ijehuecuina juyaju. Jadya baatsu tuque ecuana achine: “‘Jesúsja ebacaniju rique ijahua ijehuecuinaya’ jadya ajacacue, ai mi Jesúsra mepehuaque batu”, —jadyatu Juanra Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jadya ahuajutu Jesúsra acuare: —Jadya neaume. Ejera yuneridya ecue ebacaniju aya ejeque ecuitaja ataquique ama; tumequetu ecue ishu jidama quisaratinime ama. ");
INSERT INTO cavNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ecuana iyuhueda baquira ecuana ujeu baya ama. ");
INSERT INTO cavNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pusha amadya micuana cuejaya. Yusuratu jidaque tyabuque ecue cuanaque tsahuaqui cuanaque. Arepa tuna ena cuana pijidya jutidya iji ishu tyahua ama bucha, tujatu ecana tsujetyabuquedya, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jesúsra tuna bahuityanucacuare: —Ejera riyaque ebacua piji bucha cuanaque cajuchatishayaquetu Yusura dyaque nerecaturabuque. Dyaque jidatu majutaqui juhua ejeque cajuchatishamaquedya. Dyaque jidatu peya cajuchatishaquique tumu ebari epitiju risitsu bei dyaque dedaju ijehuetaqui juhua. ");
INSERT INTO cavNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Emetucu tsehue ni micuana cajuchaticara juya, necatubuticue cajuchatimaquedya, jidamaque acara ayaque micuanaja aishu ama. Nejacacue cajuchaticaraque. Dyaque jidatu bipidya Yusu queja judirutaqui, bibeta ijahuaja etiquiju enubidiruuque, etiqui ticu baecuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Tuhuatu emaju cuanaja ecuita cayuamatijacaya ama, tsuju cuanara araya tibu. Tuhuatu etiqui ticunime ama. ");
INSERT INTO cavNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Cuacara ni micuana juya eju micuana cuataqui amaju, cajuchatimaquedya ehuachi necatubuticue, eju micuana cuacara juyaju cuaishu ama. Nejacacue cajuchaticaraque. Dyaque jidatu ruduruduque Yusu queja judirutaqui, huachi beta ijahuaja etiquiju ejudiruuque. ");
INSERT INTO cavNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Tuhuatu emaju cuanaja ecuita cayuamatijacaya ama, tsuju cuanara araya tibu. Tuhuatu etiqui ticunime ama. ");
INSERT INTO cavNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Micuanaja petataquimaque ni micuana petacara aya, necahuicaticue yatuca, cajuchatimaquedya, jidamaque peta ishu amadya. Nejacacue cajuchaticaraque. Dyaque jidatu Yusu queja judirutaqui atuca pidya camadya, ijahuaja etiquiju atuca beta ejudiruuque. ");
INSERT INTO cavNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Tuhuatu emaju cuanaja ecuita cayuamatijacaya ama, tsuju cuanara araya tibu. Tuhuatu etiqui ticunime ama. ");
INSERT INTO cavNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Etiquira, banura jadya jidamaque cuinanashaya bucha, jadidyatu Yusura ecue cuanaque jidamaque cuinanashaya canerecati eque. ");
INSERT INTO cavNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Banu tu jida earaqui dyaque jida amere ishu. Banuja, ni banu huaja etereu, aijamatu ni eje bucha banuqui amerenuca ishuque. Banura earaqui dyaque jida amerenucaya bucha, tumebaedya micuana dyaque jida peya cuana tsehue ani ishu cabahuenetitaqui, ai aishu jida ama ejuu tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesústu dirucuare Capernaum juque. Tuhuaque cuinanatsutu cuacuare Judea yahua queja. Jordán cueri yueque macaretu cuacuare. Tuhuadyatu ecuita cuana jetiama yudijidya caradarati junucacuare tuaqueja. Caradatihuaju tujatu ecana bahuityanucacuare tuja bahue. ");
INSERT INTO cavNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tumetu umae fariseo cuanara jipeticuare. Quisaratishatsu tunajatu pusha pusha tsehue jidama amerecara acuare. Bacaduraticuare tunaja tuque: —¿Ecuanaja ehuane amena bijidama baatsu, ijehuetaquidya tuque ecuanaja? —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Tume tuna Jesúsra quemitsacuare peya cabacadurati eque: —¿Eje buchique cacuatsashatitu Moisésra huenecuare? ");
INSERT INTO cavNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tunaratu quemitsacuare: —Turatu huenecuare: “Ijehuecara ni micuana aya micuanaja huane, neinamerecue quirica eje bucha juatsu micuanara ijehueyaque cuejayaque. Inameretsu micuanaja huane neijehuecue”, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesúsra tuna acuare: —Moisesratu adebacuaredya Yusuja cuanaque ama Yusuja biji eque anicarama juya cuanaque, tunaja biji equedya jutidya. Jadya tibudya tujatu huenecuare ecaquemitique cajacatitaquique. ");
INSERT INTO cavNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jadya ama buchatu Yusura yuequedya inime iyahua ecaquemitique cajacati ishu ama. Ehuene tu Yusuja quisarati: “Yusuratu yuequedyadya iyacuare deca, epuna jadya carequi juishu”. ");
INSERT INTO cavNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Tumebaedya tu ehuene: “Jadya tibudyatu decaja jacataqui etataque, ecuaque, carequi juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Caquemitihuaju tatse Yusura baya peadya camadya bucha”. Jadya tibu tatse amena beta ama, peadya camadya. ");
INSERT INTO cavNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yusura cuitadya casitatishahua tibu, tujatu ecatse peadya camadya bucha baya. Jadya tibudya tatse ni ejeque ecuitaja buchique cajacatishataqui ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Etareju judirunucatsutu Jesús tura mepehua cuanara acuare: —Pana cueja cuita ecuana anucacue ecaquemitique cajacati ishuque ama, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—Micuana ni micuanaja huane neri tsehue cajacatitsu, peya epuna tsehue caquemitinucaya, tume micuana cajuchatiya. Yusuja yatucaju tuque micuanaja icueneque epuna huane neri jaridya, ai tupujuque ama. ");
INSERT INTO cavNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tumebae nucadya, epuna ni tuja yahuique jacatsu, peya deca tsehue caquemitinucaya, Yusu tujatu cahuaitishaya. Yusuratu icueneque deca baya epunaja yahuique neri, beta ishuque ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tumetu umae ebacua cuana etata cuanaquera Jesús queja dujubarecuare. —Emetucu micue iyacue ebacua cuanaja iyuca dyaque. Bacacue ecana Yusu queja, tuja ecana jida naru ishu, —jadya tunajatu Jesús acuare. Jesúsra mepehua cuanara tuna jadya baatsu, nereda jutidya atsabarecuare ebacua cuana tsehue cuacuare cuanaque: —Nepereume Jesús, —jadya tunajatu ecana atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Tura mepehua cuanaque jadya quisaratiyaju bacatsutu Jesús cahuaiticuare tuna tsehue. —Pajedya ebacua cuana eaqueja. Necuadishaume ecana eaquejaque. Esiri cuanaque camadya ama, tumebaedya tuna dyadi tuna Yusu jaquedya. ");
INSERT INTO cavNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pusha amadya micuana cuejaya. Yusura dutya naruhuaju tuaqueja judirucara juya cuanaquetu era cuatsashaya eque jutaqui ebacua cuejataquique bucha, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jadya quisarati aatsutu Jesúsra ebacua cuana tuhua jucuare cuanaque ebiju inatsu macacabarecuare. Peadya peadyaja iyuca dyaquetu emetucu iyabarecuare. —Yusura jida narucue, —jadya tujatu ecana peadya peadya abarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Amena Jesús dirunucayajutu ecuita juticuare tsajaja cama. Jutitsutu nuyunaticuare tuja yacuaju. Bacaduranaticuare tura: —Jidaque Ebahuityaquique, ¿ai mere tuque jidaque eau, Yusu queja judiru ishu ni eje tupu tuque jaca ishu ama? —jadya tujatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusratu quemitsacuare: —¿Adebayadyami eje buchique quisarati ahuaque? ¿Eje bucha juatsu mira “Jidaque Ebahuityaquique” jadya aya? Yusu peadya camadya tu jidaque. ");
INSERT INTO cavNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Bahuedyami Yusura cuatsashahuaque. “Quiyeti puji juume. Peyaja ehuaneque micuique bucha aniquere aume. Chiri juume. Ni ejeque buchique pusha pusha aume. Ijahue aume peya. Muibacue mique baquique, mique susuquique jadya”. Jadyatu Yusura cuatsashacuare béru, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Dutya riya cuanaque cacuatsashati cuana tuque muibacuare nanada equeradya, Ebahuityaquique, —jadyatu ecuitara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jadya bacatsutu Jesúsra iyuhue tsehue pana peta acuare. —Aniya jari tuque micue eje bucha ataquique. Dutya micue aniya cuanaque catyati aticue. Catyati aatsu tyabarecue chipiru nerecada cuanaque. Dutya micue ai catyati aatsu, juetinucacue eaqueja eatsehue juneni ishu. Eaqueja ni mi ecatyatiu, tume tuque micue eaniu Yusuja cuanaja ishu tuja barepaju aniyaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jadya ayaju bacatsutu ecuita dyaque peya inime dirucuare, tuja dyaque jetiama aniyaque catyati acarama aya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tumeque ecuita yuneridya tuatsehue junenicarama juyaque adebatsutu Jesúsra peta baretsu tura mepehua cuanaque isaracuare. —Jetiama ai aniya cuanaratu dyaque ibeda, masada baya eaqueja pana catyati juishu, Yusura dutya naruyaju judirutaqui juishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jadya bacatsu tuna bape bacacuare. Jesúsra tuna yudijidya cuejanuca acuare: —Ecue iyuhueda cuanaque, dyaque ibeda, masadatu eaqueja pana catyati juishu, Yusura dutya naruyaju judirutaqui juishu. ");
INSERT INTO cavNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cahuayutu etsucuija cani eque eje bucha cuetitaqui ama. Tumebaedya tuna tunaja ai aniyara eje bucha judirutaqui ama amereya Yusu queja, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jadya bacatsu tuna bape pana baca anucacuare. Cabacaduratibarecuare ecana tuna cama: —Chipiruqui cuanaque ni Satanás quejaque quinajacameretitaqui ama cabatiya, ¿ejeque jatsutu tuaquejaque equinajacameretiu? —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúsra tuna petatsu jadya quemitsacuare: —Ecuita ni tu tuta taca eje bucha quinajacameretie juma Satanás quejaque. Yusura peadya camadya tuna einajacamereu. Yusuja ishutu aijama ai ataquimaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jadya bacatsutu Pedrora acuare: —Ecuana ecuana dutya cashanatihua miatsehue juneni ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","—Pusha amadya micuana cuejaya. Micuana ni cashanatiya dutya micuanaja ai aniyaque eatsehue juneni ishu, Yusuja quisarati cuejara cuaishu, Yusura micuana tyaya dutya micuanara riyaque yahuaju sareyaque. Tura micuana tyaya micuanara sareya tupu dyaquedya, cien etyau bucha dyaque jetiama. Micuana ni etare cashanatiya, tura micuana tyaya eju ani ishuque. Cashanatiya ni micuana micuana tsehuequi cuanaque, micuanaja tata, micuanaja cuaa, micuanaja bacua cuana, tura micuana peya cuana queja iyuhue tsehue narumereya tunaja ata neri bucha. Cashanatiya ni micuana micuanaja tee cuana, tura micuana tyaya dutya micuanara ara ishuque sareya cuanaque. Riyaque yahuaju jari tupu micuana ecue cuanara ama ijahue ijahue abuque. Jadya ama bucha micuana Yusura dujubuque tuja yacuaju ni eje tupu tuque jaca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iyacua dyaque inime metse cabatiya cuanaque tuna inime metse ama jubuque. Iyacua jetiedya, inime metse ama cabatiya cuanaque bacue dyaque inime metse cabatibuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús, tura mepehua cuanaque jadya tuna Jerusalén diji eque cuacuare. Jesús tunajatu icuenenitya aajecuare. Tuque ujeu baqui cuanaque tumeque epu ebariju aniya baatsutu tura mepehua cuanara inime tillaqui acuare, tuque tuhua cuaya baatsu. Tuque tupuju cuaya cuanaque tuna tumebaedya bajida jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Pana baca neacue. Micuana micuana bahuedya Jerusalénju ique cuayaque. Neadebacue era cuejachineque IQUE ECUITA eje bucha judadiyaque era cuejahuaque. Pae cuanaja huaraji cuana queja, cacuatsashati bahuityaqui cuana queja jadya tunara inamereya. Tunara ique aya “Paiyetanadya” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Israelita ama cuana queja tunara inamereya. Ijahue ijahue tunara aya. Ebi tsehue au, catsacatsa, ecuedira jadya tunara aya. Iyemereya tunara ique. Quimisha huecaca majutsu chacha netitsuranucaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Tumetu Santiago, Juan, Zebedeoja ebacuaque ecatsera jipeticuare Jesús. —Ecuana Bahuityaquique, nerecabacue yatse. Tyacue yatse, yatsera mique bacayaque, —jadya tatsejatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Ai tuque metse bijida baya? ");
INSERT INTO cavNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Mique dutya naruqui jutibuneyaque, yatse bacanishacue miatsehue enaruqui iyuca juishu. Emuita eanicuareju yatse iyabutyacue, peadya micue jida eque amaca, peya jani eque amaca jadya. Miatsehue muitapeedya yatse paju, —jadya tatsejatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Metse metse baecua eje buchique metsera bacayaque. Ique dyaque canerecatiyaque tu patsedaque ebuijiu buchique. ¿Ique canerecatiya bucha canerecatie metse ejuudya? Yusura cuatsashaya eque juishu ecutsameretiu bucha; tumebaedya ique majuya Yusura cuatsashaya eque cuita juishu. ¿Ejuudya metse tura cuatsashaya eque? —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Eiduudya tuque yatsera, —jadya tatsejatu quemitsacuare. —Pusha amadya metse cuejaya. Canerecatibuquedya metse, ique canerecatiya bucha. Majubuquedya metse ique majuya bucha. ");
INSERT INTO cavNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jadya ama bucha ecuetu aijama cueja ishu ejeque ecue jida eque amaca, jani eque amaca jadya iyabutya ishu, eatsehue enaruqui juishu. Yusura camadyatu mepebuque tuhua iyabutya ishu, —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Umae tura mepehua cuanaquetu Santiago, Juan ecatsera bacayaque bacatsu cahuaiticuare tatse tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesúsra tuna dutya tuaqueja ihuaracuare. —Yahua juque huaraji cuanara tuna cuatsashaya, emechiquira cuatsashaya bucha. Casada cuanaratu jetiedya cuanaque casada tsehue cuatsashaya equedya amereya. ");
INSERT INTO cavNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Micuana micuana jadya jutaqui ama. Peya queja ni micuana camuimereticara juya, tunadya tuque micuanaja tsahuataqui. ");
INSERT INTO cavNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ejeque micuana muitacara juyaque juatsu, necacasaticue peya cuana pureamatura ishu, micuana cuita camadya ama. ");
INSERT INTO cavNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ique juya bae nejucue. Ique junahua riyaque yahuaju peya cuana tsahua ishu, tunaja ique tsahua ishu ama. Tuna jiteque maju ishu, eaqueja catyatihuaju tuna Ijahua quejaque inajacamere ishu ique junahua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Tuequedya tuna junaticuare Jericóju tura mepehua cuana tsehue. Tuhuaque cuinanayaratu Jesúra badirucuare shuhuique ediji jiruru juaniyaju. Bartimeo bacanitu jucuare, Timeoja ebacuaque. Cuetiya cuanaque chipiru bacaanitu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ejera cuanatu cuejacuare Jesús Nazaret juque cuetiyaque. Jadya bacatsutu quiquetibunecuare: —¡Jesús, miquemi Yusuja Emepeque, David eque ejuracanaque! Nerecabacue taa ique, —jadya tujatu quique eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Umadaratu nereda datse acuare, tuque abacasha ishu. Tuque bacue jadya ayaju dyaque jebuda quiquecuare: —¡Miquemi Yusuja Emepeque! ¡David eque ejuracanaque mique! ¡Nerecabacue taa ique! —jadyatu jebuda quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Tuque juaniya tuyu junatitsutu Jesús netinaticuare. Cuatsashacuaretu tuhua cuanaque: —Requeja nebecue shuhuique. Tura jadya ayaju tunajatu ihuaracuare shuhuique: —Cacasaticue. Netitsuracue. Ihuaraya tura mique, —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tume tujatu caramati ishuque ijehuequenacuare. Nere netitsura juatsutu Jesús jipeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—¿Eje buchami eaqueja catimerecara juya? —jadyatu Jesúsra bacaduracuare. —Ebahuityaquique, capetatishanucacue ique. ");
INSERT INTO cavNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—Amenami capetatiya. Erami capetatishahua, mira era mique ecapetatishauque ejenehua tibu. Jida dirucue, —jadyatu Jesúsra acuare. Tura jadya aya tsehuedya cuitatu capetaticuare. Tajiajecuaretu Jesús ediji eque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Junaticuaretu Jesús tura mepehua cuana tsehue Jerusalén piji dyane. Emata baruda cuita ama Olivo Acui Quini bacaniju tuna junaticuare. Beta epu ecatse Betfagé, Betania jadya japadama tuna jucuare. Junatitsutu Jesúsra icueneta cuadisha acuare beta tura mepehuaque ecatse. ");
INSERT INTO cavNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Ecuanaja yacua tuyu epu achaachaju necuacue. Tuhua junatitsu tuque metse banatiya burro erisique netiyaju, ni aija buchique isaanimaque. Nepisuticue. Pisutsu ecue nebecue. ");
INSERT INTO cavNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ejera ni metse aya: “¿Aishu tuque metse pisuya?”, “Ecuana Cuatsashaquiratu sareya. Masadama tujatu cuadishanucaya”, jadya neacue, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Tura jadya ahuaju tatse cuacuare. Banaticuare tatse burro isaanimaque etsecueju erisique netiyaju. Banatitsu tatse pisucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Burro pisuyaju baatsu tatse tuhua cuanara bacaduracuare: —¿Ai metse juya? ¿Aishu tuque metse burro pisuya? —jadya tunajatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jadya tunara ayaju tatsejatu quemitsacuare Jesúsra cuejadadihua equedya: —Ecuana Cuatsashaquira pari sareya. Masadama patujatu cuadishanucaya, —jadya tatsejatu ecana cuejacuare. Tatsera jadya ayaju, tunajatu ecatse acuare: —Jida. Nedujucue taa, —jadya tunajatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Pisutsu tatsejatu dujucuare burro Jesús queja. Judiruqueretsu tatsejatu tatsera jutuya tsehue titecuare. Tatsera bajeje amena ahuajutu Jesúsra isaanicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jesúsra isaanihuaju tunajatu jetiama tuhua cuanara tunaja jutu ishu cuanaque pijabarecuare edijiju, tuque muiyaque. Peya cuanaratu ejaqui cuana huanabarecuare edijiju, tuque muiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesús icuene, tupuju jadya cuaya cuanaquetu quiquetibunecuare: —¡Hosana! ¡Jida paju Yusuja ebacaniju jeyaque! ");
INSERT INTO cavNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Yusurami cuadishahua ecuana naruqui juishu, Davidra ecuanaja baba cuana naruhua bucha narue aishu! ¡Arida, dyaque casada jadyatu Yusu barepajuque! —jadya tuna jubarecuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tuequedyatu Jesús junaticuare Jerusalénju. Junatitsutu nubinaticuare Yusuja etareju. Nubinatitsutu petanaticuare ai cuana dutya queja amaca. Petanati jadya aatsutu cuinananucacuare. Dirunucacuare Betaniaju tura mepehua cuana tsehue, amena chinehua tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huecacape nuca Betania juque Jerusalénju dirunucayaquetu Jesús aracara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Japada equeratu badirucuare acui higuera bacani. Jaquiqui tibutu ecaca sahuaqui cuana datse juquena jucuare. Cacaqui ejuuque peta ishu tujatu petaticuare. Baticuare amatu ni peadya ecaca buchique ecuiju, ejaqui camadya, higo jahuane mara ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tumetu Jesúsra jadya acuare tumeque acui: —¡Cacacatinucanime ama mique! Aranucanime ama tunaja tuque micue ecaca, —jadya tujatu acuare. Tura mepehua cuanaratu tura jadya ayaju bacacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jadya juu jadya juatsu tuna junaticuare Jerusalénju. Junatitsutu nubinaticuare Jesús Yusuja etareju. Nubitsutu dyaque cahuaitinaticuare, tuhua eje bucha juyaque baatsu. Jadya tibudya tujatu ecana etsecueju pana ijehuecuinatilla acuare catyati puji cuana, bacabaca puji cuana jadya. Tipacatillacuare tujatu chipiru cuarequi juya cuanaja mesa cuana. Huei catyati juya cuanaja ani ishu cuanaquetu tumebaedya tipacabarecuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","—Etsecue cuana eque catyati ishu cuanaque necuetiquereume, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Catyati juya cuanaque ijehuecuinatilla jadya aatsu tujatu cuejatibunecuare ecuita cuana: —Yusuja quisarati tu jadya ehuene: “‘Ecue etare tu dutya queja aniya cuanaque eatsehue quisarati ishuque etare bacani’ jadyatu Yusu beru jucuare”. Jadya ama bucha tuque micuana chiri puji cuana catehua ishuque cani bucha jutidya amereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadyatu tuque quisaratiyaju bacacuare. Cahuaititsu tunajatu inime piretibunecuare eje bucha iyee aishuque. Tunaratu tuque mubacuare, ecuita cuanara Jesús ijacabacaya baatsu, tuna ebacauque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Amena apunahuajutu Jesús dirunucacuare Jerusalén juque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Huecacape nuca Jesús, tura mepehua cuanaque Jerusalénju dirunucaya tsunumee tunajatu petadirucuare acui Jesúsra “Cacacatinucanime ama mique” jadya achineque. Pana maju tirita patu raracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petatitsutu Pedro huecatanacuare Jesúsra higueraja ishu quisarati achineque. —Petacue higuera, Ecuana Bahuityaquique. Acui mira riya barepa “Cacacatinucanime ama mique” jadya achinequeri pana raradya juchine, —jadyatu Pedrora Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesúsra tuna cuejacuare: —Yusu queja micuana pana catyati neri jutaqui. ");
INSERT INTO cavNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yuneridya ni micuana ejeneya era ecue casa tyahuaque, ejenecara ejenecarama jadya ama ni micuana eau, tumebaedyatu micuanara amereya equedya ejuu, arepa ai ibedaque paju ama bucha. Riyaque uhua cuemusu micuana eau: “Anisicuacue tuhuaque. Cueri cuanaja ecuaqueju pacacacue”. Amereya equedyatu ejuu. ");
INSERT INTO cavNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jutaquijudya micuana cuejaya. Yusu tsehue quisaratiyaque, ai ni micuana ebacau, tyayadya tura micuana, ejenecara ejenecarama jadya ayaque ama juatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Yusu tsehue quisaratima jarira nenerecabacue peya cuanara jidama ahuaque. Nenerecabacue ecana, Yusura dyadi micuana cuitadya jidama juhuaque apupasha ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Micuanara ni peya nerecabaya ama, tume tuque micuanaja Tata barepajura dyadi apupashaya amadya micuanaja jucha cuana, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jerusalénju tuna yudijidya judirunuca jucuare. Yusuja etare queja juneniyajutu pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara, israelita cuana emuiba cuanara jadya jipeticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jipetitsu tunajatu bacaduracuare: —¿Airami ejeque ecuitaja ataquique ama aishu cuatsashahua? ¿Aija casa tsehue tuquemi jadya aya? —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesúsra tuna quemitsacuare: —Era micuana tumebaedya bacaduraya. Quemitsaya ni micuanara ique, tume micuana cuejaya aira cuatsashahuaju era riya cuanaque ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Airatu Juan cuatsashacuare ecuita cuana utsa ishu? ¿Yusura, ecuita cuanara ni taa? Nequemitsacue ique, —jadya tuna Jesúsra bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Tume tuna, tuna cama quisaraticuare: —¿Eje bucha tuque ecuana equemitsau? “Yusuradyatu cuatsashacuare”, jadya ni ecuana eau, tume tura ecuana ebacadurau: “¿Eje bucha juatsu jatsu tuque micuana Juanra cuejacuareque ejenecuare ama?” jadya tura ecuana eau. ");
INSERT INTO cavNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Ecuita cuanaja ecuadishaquedya jutidyatu jucuare”, jadya ni ecuana eau, tumetu dutya jujeri ecuita cuana ecahuaitiu ecuana tsehue”, jadya tuna cacuejatibarecuare. Bahuedya tuna jucuare, dutya jujeri ecuita cuanara, Juan Yusu equeque quisarati cuejaqui jucuareque adebacuareque. ");
INSERT INTO cavNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ecuita cuana mubatsu tunajatu Jesús quemitsacarama acuare. Chamacama tunajatu quemitsacuare: —Baecua ecuana aira Juan ecuita cuana utsa ishu cuatsashacuareque, —jadya tunajatu Jesús acuare. —Jutaquiju micuana era cuejaya amadya aira ique ecuitaja ataquique ama aishu ique cuatsashahuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jadya juatsutu Jesús catibutinucacuare ecuita cuana bahuitya. Riyaque cuatsabiji tujatu ecana cuejacuare, tuna bahuityayaque. —Peadya ecuitajatu tee aridaque anicuare. Tee aatsutu uva uhuamerecuare. Taracanemerecuare tura. Amerecuaretu uva jahuanehuaju pitutsu nacaca tisi ishuque. Amerecuaretu etare piji barudaque, tueque tsuratsu, dutya queja naru ishu. Umae ecuita cuana queja tujatu tee narumerecuare. Tura tuna acuare: “Micuanara ni ecue tee naruya, tume ecuana uva jahuanehuaju cajaquetiya micuana tsehue”. Tuna tuna endya jucuare. Tume cuanaque bajejetsutu emechiqui cuacuare japada peya yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uva jahuane mara juetihuaju tujatu tuque merequique cuadishacuare tee naruqui cuana queja. “Cuacue ecue teeju mere juya cuana queja. Cuejaticue ecana; pacuadisha tuna ecue ishuque uva epituque”, jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jadya ahuajutu cuacuare. Jutihuajutu tee naruqui cuanara inatsacuare. Mirimiri tunajatu atsacuare. Mema tuna cuadishacuare, ni peadya uva caca tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jadya juhua baatsutu emechiquira cuadishanucacuare peya tuja mere puji. Tumeque tunajatu ijahue ijahue, ujeda, ujeda jadya atsacuare. Puucuare tuna iyucaju. ");
INSERT INTO cavNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tuequedyatu emechiquira cuadishanucacuare peya mere puji nuca. Tumeque tunajatu iyetsacuare. Jadya juatsutu umada peya cuana cuadishacuare. Umae tuna miririshatsacuare. Peya cuana bacue tuna iyetsabarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Amena aijama jucuare mere puji cuana cuadisha ishu. Peadya cuita camadya tuhua jucuare tuja peadyaque ebacuaque iyuhuedaque. Datse juatsu tujatu ebacuaque neri cuadishacuare. ‘Riyaque renajari eje bucha ama atsaya. Ecue ebacua neri tibu, tunajatu muibatsaya’ jadya datse tujatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ebacuaquera jipeajeyajutu tee naruqui cuanaque jadya jucuare tuna cama: ‘Riyaquedya ri tee metseja ebacuaque neri. Eje tupu etataque majuhuajuri riyaquedya tee metse judadiya. Neiyetsara. Ecuanadya emechiqui nejura’ jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Inatsacuare tunara. Inatsatsu tunajatu iyecuare. Iyetsu tunajatu emajuque ijehueticuare tee tibene. Jadyatu tee naruqui cuanaque jucuare, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tume tuna Jesúsra bacaduracuare tuque quisaratiyaju bacaqui cuanaque: —¿Eje buchatu anabuque tee naruqui cuanaque emechiquira? Era micuana cuejaya. Juetitsu tujatu iyemerenabuquedya tee naruqui cuanaque. Peyadya tujatu mere puji cuana sarenabuque tee naru ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Neadebacue riyaque Yusuja quisarati ehueneque. Adebayadya tuque era micuanaja riyaque quisarati eje uma isara eaque: ‘Tumu ebari etare puji cuanara tsumecarama acuarequetu tumu dyaque saretanayaque judadicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ecuana Cuatsashaquiratu dyaque saretanayaque amerecuare. Riyaque jadya baatsu, ecuana dyaque pureama juya’ jadya tu ehuene. ");
INSERT INTO cavNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Riyaque cuatsabiji bacatsutu israelita cuanaja huaraji cuana dyaque cahuaiticuare, tunara cuitadya Jesús bijidamadurahuaque caadebatitsu, mere puji cuanara tee metseja ebacuaque bijidamadurahua bucha. Eje buchadya iyecara datse tunajatu acuare. Jadya ama bucha “Iyacua ni ecuana einau, ecuita cuanatu ecuana tsehue ecahuaitiu”, jadya tunajatu inime jucuare. Ecuita cuana mubatsu tunajatu Jesús inacuare ama tumeque ura cuitadya. Shanaquenacuare jutidya tunaja tuque. ");
INSERT INTO cavNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Israelita cuanaja huaraji cuanaratu cuadishacuare fariseo cuana, Herodes tsehue junenicuare cuanaque jadya Jesús queja. —Jidama nequisaratishara, huaraji cuana queja duju ishu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tume cuadishahua cuanaratu jadya anaticuare: —Ebahuityaquique, ecuana ecuana bahue mique jida, tuyuque. Miratu bahuityaya Yusuja inime eque ani ishuque, ni ejeque buchique mubatsu ama. Micue ishutu ecuita cuana dutya tupu. Jadya tibudya ecuana cuejacue. ¿Ecuanaja cacuatsashati eque, tuque ecuanaja ecuana naruquique Roma juque tsujetyataqui, tsujetyataqui ama ni taa? Tura ecuana tsuje tyamereyaju, ¿tsujetyataquidya tuque ecuanaja, aijama ni taa? —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesusratu adebacuaredya tunara jidama inime tupuya tsehue jadya bacaduratiyaque. —Micuanara ijahue acara aya jadya cabacadurati tsehue, babi pujira armadilla nityatsu ai cuanubi eamereu bucha. Nequeticue ficha enaruquija chipiru tuque tsujetya ishuque. Papeta era, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jadya ahuaju tunajatu queticuare peadya ficha “denario” bacani, Roma juque enaruquique tsuje tyaishuque chipiru. Petatsu tuna Jesúsra bacaduracuare: —¿Aija ebutsequini ri riyaque fichaju eiya? ¿Aija ebacani ri rehua ehuene? —Enaruquique muidaque César bacani jaque tume, —jadya tunajatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—Jutaquiju netyacue enaruqui César tuque tyaishuquedya. Yusu netyacue Yusuja ishuquedya, —jadya tuna Jesúsra acuare. Anajacatacuare tuna tuque jadya caquemitsatiyaju bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tumeque huecaca nucadyatu saduceo cuanara Jesús baticuare. Tunaradyatu ejenecuare ama emaju cuanaque netitsuranucayaque. Junatitsu tunajatu Jesús isaranaticuare: ");
INSERT INTO cavNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Ebahuityaquique, Moisésra taa tu riyaque cuatsashacuare. “Ejeque ecuita ni majuya cabacuatimaque, tuatsehuequiquetu caquemitinucataqui eahuemaju tsehue, tuatsehue cabacuati ishu, icueneque ebacua emajuja ebacuaque bucha ishu”, jadyatu Moisésra cacuatsashati huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Riyaque cuatsabiji mique ecuana aya; ijariba ishuque jutidya tu ecuita emajuque chacha netitsuranucaya jadique. Anicuaretu ecuitaja pacarucu ebacuaque. Icueneque ebacuaquetu caquemiticuare. Huanequi juu jadya juatsutu majucuare bacuamaque. ");
INSERT INTO cavNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Majuhuajutu ejuque beta ishuque caquemitinucacuare eahuemaju tsehue. Beta ishuque tumebaedya majunucacuaredya bacuamaque. Quimisha ishuque ejuquetu caquemitinucacuare eahuemaju tsehue. Tumebaedyatu junucacuare. Bacuamaquedyatu majunucacuare bacuamaque tere. ");
INSERT INTO cavNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jadya ecana jubarecuare; pacarucudyatu tumeque epuna tsehue cama ecana caquemititsu majuetibecuare. Tumeque nerecadaque epunatu pacarucu ahuee juhuaque majucuaredya, yahue cuanaque majuterehuaju. Jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","“Ecuanarami bacaduraya riyaque. Yuneridya ni majuya cuanaque chacha netitsuranucabuque, ¿ejeja ehuanequetu jubuque chacha netitsuranucatsu, riyaque yahuaju tuque pacarucu ahuee juhua tibu? —jadya tunajatu Jesús bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesúsra tuna quemitsacuare: —Micuana micuana cuji juya. Micuanaratu adebaya ama Yusuja quisarati ehueneque, ni Yusura eauque. ");
INSERT INTO cavNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Emaju cuanaque netitsuranucatsu tuna caquemitinucabuque ama. Barepaju Yusu tsahuaqui cuanaque tuna caquemiti baecua. Jadidya tu emaju cuanaque; netitsuratsu tuna caquemitibuque amadya. ");
INSERT INTO cavNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yuneridyatu emaju cuanaque chacha netitsuranucabuque. Pusha ama cuitadya tuque micuana eje uma isara ahua Moisésra huenecuareque, acui huija jujuyaque murutayaque ama tura huenecuareque. Yusuratu Moisés acuare: “Ique Yusu, Abraham, Isaac, Jacob jadyara iyacua muiyaque”. Chacha cuanara cuita camadya Yusu emuiu tibu, yuneridyatu Abraham, Isaac, Jacob jadya ecana enetitsura. ");
INSERT INTO cavNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yusu tu chacha cuanara muiyaque, emaju cuanara ama. Micuana micuana pana cuji eju emaju cuanaque chacha netitsuranucaya ama jadique ejeneya tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Tuhuadyatu cacuatsashati bahuityaquique jucuare. Tura tuna quisaratiyaju bacacuare. Adebacuaredya tura Jesúsra saduceo cuana jida quemitsahuaque. Tumetu tura Jesús isaratsu bacaduracuare: —Ebahuityaquique, aniyatu jetiama cacuatsashati cuana ecuanaja cacuatsashatiju ehueneque. ¿Ejeque cacuatsashatira cuatsashaya eque cuita ecuana jutaqui? ");
INSERT INTO cavNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusratu quemitsacuare: —Ehuene tu Yusuja quisarati: “Nebacacue ique, micuana Israel eque ejuracana cuanara. Ecuana Cuatsashaquique tu Yusu; tuque peadya camadya tu Ecuana Cuatsashaquique. ");
INSERT INTO cavNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Iyuhueda bacue ducuta Yusu Mique Cuatsashaquique. Yusu iyuhueda bacue ducuta; dutya micue cabijiseriti tsehue Yusu pureamaturacue, dutya micue inime tupu tsehue, dutya micue casa tsehue.” Riyaque cacuatsashatira cuatsashaya eque cuita micuana jutaqui. ");
INSERT INTO cavNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Riyaque ri beta ishuque: “Iyuhue tsehue bacue peya cuana; mique cuitadya iyuhueda cabatiya bucha iyuhuee peya bacue”. Jeeque cacuatsashati ecatsera cuatsashaya eque cuita micuana jutaqui. Aijamatu peya cacuatsashati dyaque inime metseque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jadya cuejayaju bacatsutu cacuatsashati bahuityaquira acuare: —Jidadya tuquemi cuejaya, Ebahuityaquique. Yusu tu Ecuana Cuatsashaquique peadyaque. Aijamatu peya Yusu, tuque cuita camadya. Mira quisarati ahuaque tu yuneridya. ");
INSERT INTO cavNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yusu tuque ecuanaja ducuta iyuhueda bataqui. Dutya ecuanaja inime tupu tsehue tuque ecuanaja iyuhueda bataqui, ecuanaja casa tsehue jadya. Tumebaedya yuneridya tuque ecuanaja peya cuana iyuhueda bataqui; ecuana cuitadya iyuhueda cabatiya bucha iyuhuee tuque ecuanaja peya bataqui. Yusu, peya cuana jadya ni ecuana iyuhueda baya, tuquetu dyaque pureama juya, ecuanara uu cuana, jadya ama juatsu peya ai tuque tyayaju pureama juya bucha ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tumetu Jesúsra tura jida inime tupu tsehue quemitsahuaque adebatsu jadya acuare: —Miratu amena adebatibuneya Yusu eje bucha pureamatura aishuque. Masadama ni mi tujaque ejudadiu, —jadyatu Jesúsra acuare. Dutya riya cuanaque bacatsutu ni ejeradya jutidya bacaduranucacuare ama. ");
INSERT INTO cavNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús tuhua Yusuja etareju bahuitya bahuityaya jarira tujatu tuque quisaratiyaju bacaqui cuanaque jadya acuare: —Cacuatsashati cuana bahuityaqui cuanaque tuna juya “Mesías, Yusuja Emepequetu ejeque ecuita baedya jutidya judadibuque, David eque ejuracanaque jubuque tibu”. Cuejaya micuana era. ");
INSERT INTO cavNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David cuitadyatu bahue jucuare Mesías ecuita camadya ama jubuqueque, ecuita cuana bucha dyaque inimequique, Yusuja Espirituradya jadya huenemerecuare tibu: “Yusuratu Ique Cuatsashaquique jadya cuejacuare: ‘Anibutecue ecue jida eque amaca muita ishu, era mique ujeu baqui cuanaque dutya ijahue atillaya tupu, Ique Cuatsashaquique’” jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Davidradyatu Mesías ‘Ique Cuatsashaquique’ jadya acuare, arepa tueque ejuracanaque ama bucha. Yuneri cuitadyatu Mesías ecuita jutidya ama ejuu; ecuita cuana bucha dyaque inimequiquedya tume, —jadya tujatu ecana acuare. Jesús quisaratiyajutu jetiama ecuitara pureama tsehue bacacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesúsra tuna bahuityanucacuare: —Necanaruticue cacuatsashati bahuityaqui cuana tsehue. Tuna aniya bae neaniume. Tunaratu una junudaque jutuya, peya cuana queja Yusu adebaqui jadya cabamereti ishu datse. Epu patya eque cuetiyaju tuna dyaque muida tsehue isaratacara juya. ");
INSERT INTO cavNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Caradati ishuque etareju cuaatsu tuna muida cuanaque anibahueju anibutetiya. Chine cuana ishu araaratayaju cuaatsu tuna emuita cuanaja eaniqui cuanaju cama tuna eaniqui metsene juya. ");
INSERT INTO cavNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Arepa ecana eahuemaju cuanaque tsahuaya bucha cabatiya ama bucha, yuneri cuitadya tunajatu eahuemaju nerecada cuanaque tunaja ai aniya cuanaque secatillaya, tuna tunaja etare juque cuitadya ijehuecuinaya tupu. Yusu tsehue quisaratiyaque tuna tsunuda quisarati bahue dutyaja ijacaju, tuna queja “Yusu adebaqui cuita rena”, jadya catimere ishu datse. Yusura tuna dyaque nerecaturabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesústu Yusuja etareju anibutecuare ecuita cuanara Yusuja ishu chipiru iyaya tuyu. Petacuare tujatu umada ecuita cuanara chipiru ishayaju. Jetiama chipiruda cuanaque tuna cueticuare tueque jetiama chipiru isha juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Tuequedyatu eahuemaju nerecadaque junaticuare. Tumeque epunaratu ishaticuare cajuju beta ficha piji cobre eaque, tsuje aridaque ama, ai tsujequi cuitaque ama. ");
INSERT INTO cavNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Baatsutu Jesúsra acuare tura mepehua cuanaque: —Pusha amadya micuana cuejaya. Yusuratu dyaque tsuje arida baya epuna nerecada eahuemajura ishahuaque, chipiruda cuanara jetiama ishahuaque bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tunaratu ishahua tunaja anidadiyaque jutidya. Jeeque epuna nerecadara taa tyatillahua tuja dutya aniyaque piji, tuja ai caquemiti ishu ejuuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús Yusuja etare juque cuinanayajutu peadya tura mepehuara jadya acuare: —¡Ecuana Bahuityaquique, petacue! Dyaque jida piji taa Yusuja etare, tumebaedya dutya ai ea cuanaque etare tsecue cuanaju, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—Pusha amadya. Jida pijidya tuquemi petaya. Jadya ama buchatu Yusuja etare, etsecueju dutya ai ea cuanaque pana rihuishatanatere jubuque. Anibuque amatu tumu ecadyaqueti. Dutya tumu etare enityatsuraquetu yahuaju tere jubuque, —jadyatu Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jadya juatsu tuna cuanucacuare uhua cuemusu Olivo Acui Quini bacaniju. Tumeque uhua cuemusutu Yusuja etare tuyu jucuare. Aninaticuaretu Jesús. Anibutehuajutu Pedro, Santiago, Juan, Andrés ecanara jipeticuare. Jipetsu tunajatu bacaduracuare: ");
INSERT INTO cavNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Cuejacue ecuana. ¿Eje tuputu jadya judadiya? ¿Aiju ecuana caadebatibuque yahua tereyaque huecaca japadamaque? —jadya tunajatu Jesús bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Nimequi tsehue nequihuaticue. Ijahue necatimereume. ");
INSERT INTO cavNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ique junanucahuie tuna jetiama junabuque iquepa ejuu jadya juya cuanaque. “Ique Mesías, Yusuja Emepeque”, jadya tuna jetiama junabuque. Jetiamara tuna ejenebuque. Ijahue tuna atabuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dutya quejaquedya jutidya tuna catibuque. Japadama tuque micuana ecana catiyaju bacabuque. Tumebaedya tuque micuana ecana japadapa catiya jadya bacabuque. Jadya bacatsu “Masadamatu tere juetiya”, jadya micuanaja inime paju ama. Dutya tume cuanaquetu jadya jubuque icuene. Tere ishuque ama jari tume. ");
INSERT INTO cavNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Riyaque yahuaju cuanaque tuna peya yahuaju cuana tsehue catibuque. Anape cuanaquetu catibuque peya anae cuana tsehue. Bucucubuquetu yahua dutya queja. Eje uma epu cuanaju tuna dyaque mije jubuque. Jadya cuana judadiyaquetu canerecati catibutiyaque jutidya. Ecue cuanaque tuna dyaque canerecatibuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Necanaruticue bacue micuana. Micuana ujeu baqui cuanara micuana ijahue ijahue abuque eaqueja ecatyati baatsu. Inatsu tunara micuana huaraji cuana queja dujubuque. Abuque tunara micuana caradati ishuque etare cuanaju. Dujubuque tunara micuana enaruqui cuanaja yacuaju, ecuari cuanaja yacuaju eaqueja ecatyati baatsu. Tume tuque micuanaja emajaca anibuque ique eje buchique tuna cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dutya terema jarijudyatu ecue quisarati jidaque dutya queja cuejatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Huaraji cuanaja yacuaju dujutanayaju jidama inime nebaume quicueneti ishhu quisarati aishu. Quisarati ishuque ura juetihuaju, Yusura huecashaya eque nequisaraticue, Yusuja Espíritu micuana eque quisaratiya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ecue cuanaque tuna tunaja etareju cuanara cuitadya ijahue ijahue abuque. Iyemere ishu tunajatu huaraji cuana queja inamerebuque. Etata cuanaquera tuna ebacua cuanaque cuitadya inamerebuque, ebacua cuanaquera bacue etata cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Dutya jujerira micuuana ujeu babuque, eaqueja ecatyati baatsu. Ejeque tereya tupu eatsehue nime aputayaque ama camadyatu Yusu queja judirubuque ni eje tupu tuque jacanuca ishu ama, —jadya tunaa Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jesúsra tuna cuejanucacuare: —Ejitajutu dyaque jidama cuitaque judadibuque “Ecuita Cuana Bajituraquique” bacani. Eju tuque anitaquiju amatu anibuque. Yusuja etarejutu ejitaju jubuque. Tumequepa amena juetihua jadya bacatsutu Yusuja quisarati ehueneque pana adeba aya cuanara adebabuque masadama eje bucha judadiyaque. Ecuita Cuana Bajituraquique Jerusalénju juetihua jadya baatsutu Judea yahuaju cuanaque huanataqui emata cuanaju catehua juishu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Muya jutidyatu Ecuita Cuana Bajituraquique juetibuque. Jadya tibudya tuna etare ebarucue ecamahua jepeda cuana juque ai inaquenama butetaqui huana ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Teeju mere juya cuanaque tuna judirunucataqui ama tunaja etareju. Tuequedya tuna huanataqui. Nubitinucataqui ama tuna tunaja caramati ishuque jiteque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Dyaque nerecadatu jubuque epuna maqui cuanaque, bacua nanaqui cuanaque jadya. Tuna tuna eje bucha huanataqui ama ebajarara cabatibuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nebacabacacue Yusu queja, micuana huanayaque huecaca cuejipa, nei micuana huanayaque huecaca ejuetiuju. ");
INSERT INTO cavNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ecuita Cuana Bajituraquique ejitaju juhuajutu dyaque canerecati ishuque anibuque. Ni eje tuputu jadya canerecati anihua ama Yusura yahua iyahua equeque tumeque huecaca judadibuque bucha. Ecuita Cuana Bajituraquique ijehuetanahuajutu aninucabuque ama jadique canerecati ni eje tupu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Dyaquetu Yusura iyuhueda baya tuja cuanaque, tura mepehua cuanaque. Jadya tibudyatu Yusura tumeque huecaca canerecati ishuque jununashabuque ama. Tura ni jadya ama eau, ni aira buchiquetu eiduu ama; ni ejequetu chacha ejuu ama. ");
INSERT INTO cavNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Aira cuejatsu ama micuana ique junanucahuaque bahue jubuque. Jadya tibudya ejera ‘Mesiastu junanucahua. Ecuanaja epujudya rique’ jadya ayaju, neejeneume. Ejera ni micuana aya: ‘Mesiastu junanucahua. Peya epuju tuque’ neejeneume. ");
INSERT INTO cavNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tume cuanaque huecaca juetihuaju tuna jetiama pusha pusha jubuque: ‘Ique Mesías, Yusuja Emepeque’ jadya ama juatsu ‘Ique Yusuja quisarati cueja ishuque cuita camadya’ jadya. Abuque tunajatu inimeradya jutidya ecuitaja ataquique ama. Eje uma tunajatu ecana ijahue abuque. Dutya tunajatu ecana cujishabuque. Yusuja cuanaque neri neri tunajatu ijahue acara ebari abuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Necanaruticue. Icuenetadya micuana cuejahua riyaque, micuana ijahue eatauju, —jaadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesúsra tuna bahuityanucacuare: —Masadama huecaca cuana nerecada ishuque cuetiajeyaju cuitadyatu ijeti apunabuque. Badiu huecadama jubuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Purari cuanatu barepa juque pacacabuque. Barepaju casada aniya cuanaque tuna piririterebuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Tuequedya tunara IQUE ECUITA huani ducu junanucayaju batsabuque. Ecue dyaque casa tsehue junanucabuque. Cabameretibuque ique eje bucha muitaeque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Cuadishabuque tuque barepaju ique tsahuaqui cuanaque, ecue cuanaque dutya yahua queja aniya cuanaque sita ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Anibuquetu ique masadama junanucayaque adeba ishuque, masadama nei mara catibutinucayaque adeba ishuque aniya bucha. Ita taa acui higuera bacani neadebacue. Yaa cuana catapananatiyaju baatsu, micuana bahue amena nei mara catibutiyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tumebaedya micuana dutya riya cuanaque era cuejahua cuanaque juajeya baatsu, bahuedya micuana jubuque yahua amena terehuieque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pusha amadya micuana cuejaya. Dutya riya cuanaquetu judadibuque iyacua ecuita cuana aniyaque majuma jarijudya. ");
INSERT INTO cavNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Arepa barepa, yahua jadya pana cuaretana jubuque ama bucha, dutya micuana era cuejahua cuanaquetu cuaretanatsu ama jadya judadibuque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Yusu ecue Etata peadya camadyatu bahue ejeque huecaca ique junanucayaque. Tuque peadya camadyatu bahue huecadaju ni, jadya ama juatsu meta eje tupu ique junanucayaque. Ni ejeque ecuitaratu adebaya ama. Ni ejeque barepaju Yusu tsahuaquiratu adebaya ama. Arepa ique Yusuja Ebacuaque ama bucha, eratu adebaya amadya. ");
INSERT INTO cavNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Jadya tibudya nequihuaticue. Neihuajacaume ique junanucayaque, ai micuana bahue batune eje tupu ique junanucayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ique ecuita eje queja cuayaque ejeque huecaca juetinucayaque cacuejatima cuau ejuu buchique. Cuama jariratu tumeque ecuitara aya tuja mere puji cuana: ‘Nenarucue ecue aniya cuanaque’. Cuejabareyatu ecana peadya peadya tuque juneniya tupu tura amerecara ayaque. Cuejamereyatu etsecue naruquique: ‘Quihuatijacaume bacue ejeque uradya jutidya ique juetinucayaju etsecue pacasha ishu’. ");
INSERT INTO cavNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Canarutijacataqui ama, mere jadya tuna jutaqui ejeque huecaca etare metseque juetiyaque baecua tibu. Ejuetiutu apupuyaju, jadya ama juatsu barepatya, jadya ama juatsu tacure quiqueyaju, jadya ama juatsu apudajudya. Tumebaedya micuanara ique junanucayaque neihuajacaume. ");
INSERT INTO cavNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ique muya jutidya junanucabuque. Neajacaume bacue era micuana amerequenayaque. Ecabatique bucha nejucue. ");
INSERT INTO cavNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Micuana amereyaque tumebaedya tuque amereya dutya: ‘Neihuajacaume ique junanucayaque. Ecabatique bucha nejucue’ —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Beta huecacatu bataqui ama jucuare Pascua chine, ecuanaja baba cuana Egipto juque cuinanacuareque adeba ishuque, pan levaduramaque ecuanaja ara bahueque. Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadyatu Jesús iye ishu, tseta inamere aishu sarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—Neinamerera ama Pascua chine ishu cuita, ecuita cuana ecapuritishau tibu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesústu Betaniaju jucuare Simónja etareju. Icuenetu tumeque ecuita erami ririshaqui ujeje tsehue jucuare. Jadya tibudya tunajatu “Leproso” jadya isarae acuare. Chineju araarayajutu Jesús epunara jipeticuare botilla caca alabastro eaque ina jadya. Tumeque botilla cacatu etseri ijimeda tsehue ejequeshaque jucuare, dyaque tsuje aridaque, “nardo” bacani. Pucucuare tujatu botilla cacaja etumuqui. Pucutsu tujatu etseri ijimedaque juraticuare Jesúsja iyucaju. ");
INSERT INTO cavNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Epunara jadya aya baatsutu umae tuhua cuanaque cahuaiticuare: —Nepetacue tura etseri dyaque tsuje aridaque ijehueneyaju. Ni aishu buchique tu jida ama jadya ijehuenetsu. ");
INSERT INTO cavNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Catyati ni tu aquena juhua etseri ijimedaque, umada tujatu chipiru inaquena juhua, quimisha ciento ficha dyaque cuitadya, peadya mara mere juatsu etsujequi einau tupu. Jetiamatu nerecada cuanaque etsahuauque chipiru inatsu, —jadya tuna jucuare. Sicacada ecana epunaja ishu quisaraticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Tuna quisaratiyaju bacatsu tuna Jesúsra acuare: —Jadya neaume. ¿Eje bucha juatsu jatsu tuque micuana tumeque quisarati tsehue aya? Tura ique jadya ahuaquetu dyaque jidaque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Micuana ducutu jujacaya amadya nerecada cuanaque. Aijama amadya tuque micuanaja emajaca juya tuna micuanaja ai aniyaque tyaishu, ique bacue aijama. Ique micuana tsehue junenisiriya ama. ");
INSERT INTO cavNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Riyaque epunaratu ahua tuja ecue ishu ataquique. Ique iyetahuaju papata ishuque tura jadya ahua. ");
INSERT INTO cavNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pusha amadya micuana cuejaya. Riyaque epunara jadya ahuaque tuna dutya yahuaju bahue jubuque, eju ecue quisarati jidaque cuejatanayaju, ecuita cuanaja tuque adeba ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Tumetu Judas Iscariote, Jesúsra mepehuaque, cuacuare pae cuanaja huaraji cuana queja. Bajejeticuaretu inime tuna queja eje bucha inamere Jesús aishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tura jadya quisarati ayaju bacatsu tuna pureama jucuare. —Mira ecuana Jesús menajetyahuaju, mique ecuana chipiru tsehue tsujetyaya, —jadya tunajatu acuare. Tumeque huecaca equeratu Judasra Jesús eje bucha inameree aishuque sarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jueticuaretu icueneque huecaca Pascua chine ecuanaja pan levaduramaque, uhuisha jidaque iyetsu jadya ara bahueque huecaca. Tumeque huecacatu Jesúsra mepehua cuanara Jesús jipetitsu bacaduracuare: —¿Ejumi bajejemerecara aya riyaque chineju Pascua ishu araara ishu? —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Tunara jadya atihuaju tujatu cuadishacuare beta tura mepehuaque ecatse. Tatse cuama jariju tujatu ecatse acuare: —Jerusalénju nebajejeticue. Necuacue. Tuhua junatitsu tuque metse tsuruya ecuita suraju ena duju juyaque. Tudya netupuajecue. ");
INSERT INTO cavNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Tupujudya aajetsu, ejeque etareju tuque nubidiruyaju baatsu, tuhuadya nenubicue. Etare metseque jadya neaticue: “Ecuana Bahuityaquirami bacaduramereya: ‘¿Eje dyanepa micue etareju emajaca, tuque tura mepehua cuana tsehue Pascua ishu araara ishu?’” jadya nebacaduraticue. ");
INSERT INTO cavNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Metsera jadya ayaju tura metse bamereya tuja etareju emajaca aridaque beta ishuque pisoju. Tuhuadyatu aniya dutya ecuanara sareyaque. Tuhuadya nebajejecue ara ishuque, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jadya ahuaju tatse cuacuare. Junaticuare ecatse epu ebariju. Junatihuajutu jucuare dutya tatse Jesúsra cuejadadihua bae cuitadya. Tumeque ecuita tsurutsu, etare cuejahuaju cuaatsu, tatsejatu earaqui bajejeticuare Pascua juyaque chineju ara ishuque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Amena apunahuajutu Jesús junaticuare tura mepehua cuana tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Amena mesaju araarayara tuna Jesúsra jadya acuare: —Peadyara micuanara ique ujeu baqui cuana queja inamereya, peadya eatsehue araarayara, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jadya ayaju tuna peya inime jucuare. Peadya peadyara tunajatu bacadurabarecuare: —¿Era ni taa, Ecuana Cuatsashaquique? —jadya tunajatu abarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—Eatsehue peadya pejaju araarayara, pan mullayara. ");
INSERT INTO cavNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bérutu Yusu equeque quisarati cuejaqui cuanara huenecuare ecuita jidama cuanara iyebuqueque. Tunaja quisarati ehuene equedyatu juya. ¡Dyaque nerecadatu jubuque ique ujeu baqui cuana queja inamerequi juyaque! Dyaque jida taa tu tumeque ecuita ecuaquera ejitaju aquena ama juhua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Araarayaquetu Jesúsra pan inacuare. Pan inatsu tujatu —Yusurupai mique aya, Tata, —jadya Yusu acuare. Yusurupai, jadya aatsu tujatu pan cuesicuare. Cuesitsu tujatu tuatsehue anibareya cuanaque tyabarecuare. —Nearacue. Riyaque rique ecue ecuita, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Tuequedya tujatu canecu juque uva nacaca esasanashaque inanucacuare. Canecu inatsu, —Yusurupai mique aya, Tata, —jadyatu Yusu acuare. Yusurupai jadya aatsu tujatu ecana sadatsu inamerebarecuare, tunaja ijibare ishu canecu juque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—Riyaque rique ecue ami, micuana jiteque quijehuetiyaque. Jetiama tuna eaqueja catyatibuque. Ique ecue ami quijehuetitsu majuhuajutu Yusura iyaya iyacuaque inime tuaqueja judiru ishuque. Ique majuhuaju piisitu riyaque inime yunerinetanaya. ");
INSERT INTO cavNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Riyaque micuana cuejaya. Ni eje tupu tuque riyaque yahuaju Pascua chine micuana tsehue anucaya ama; ijinucanime ama tuque ecue uva nacaca esasanashaque. Jadya ama buchatu tumeque huecacaca era dutya naruyaque huecaca juetihuaju piisi tuque ijibuque micuana tsehue iyacuaque eijiqui, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Chineju araara amena juatsu tunajatu Yusu pureama aishuque jeru acuare. Jeru amena juatsu tuna cuacuare uhua cuemusu Olivo Acui Quini bacaniju. ");
INSERT INTO cavNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tuhua junatitsutu Jesúsra isaracuare tura mepehua cuanaque. —Riyaque meta micuanara era ijahue ahua bucha cabatitsu jacatillaya. Yusuja quisarati tu ehuene: “Tuna aquereniquiquetu iyetanabuque. Dutya tura aquerenihua cuanaque tuna tsapetanabuque, uhuisha cuana naruquique iyetanahuaju etsapetanau bucha”. ");
INSERT INTO cavNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Emajuque netitsuranucatsu icuenetadya cuaya Galileaju, tuhua micuana tsehue catsurutinuca ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jadya juyajutu Pedrora acuare: —Arepa dutyara jacatillaya ama bucha, ecuemi jacanime ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—Pusha amadya mique aya. Riyaque meta, tacure quique beta juma jarijudyami catehuati quimisha juya. “Adebaya ama tuque era”, jadya aquimisha mira aya, —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—¡A, aijama! Mique adebaya ama jiu junime ama ique. Miatsehue iyepeedya datse tunara paa. “Tujaque ama ique” jadya junime ama ique, —jadyatu Pedrora Jesús acuare. —Mique adebaya ama jiu junime ama ique, —jadya tunajatu abarecuare, Pedrora aya baedya. ");
INSERT INTO cavNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Tumetu Jesús tura mepehua cuana tsehue junaticuare Getsemaní bacani emajacaju. Tuhua junatitsu tujatu ecana anaticuare: —Rehuadya neanibutecue, ique ecue Etata tsehue quisaratiya tupu. ");
INSERT INTO cavNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jadya juatsu tujatu dujucuare Pedro, Santiago, Juan jadya. Japada cuita ama tunajatu ecana jacacuare. Cuayaquedyatu Jesús dyaque peya inime cabatiajecuare, niju huenanada, eje buchadya jucara jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Dyaque peya inime taa cabatiya. Idutaqui ama cuita taa rique baya. Rehuadya neanicue. Ecabati nejucue. Netahuiume, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tuna jadya aatsutu Jesús cuacuare eje japa cuita amadya. Cuaatsutu chichucata junaticuare, yahua queja huipuchitana. Jadya juatsutu Yusu tsehue quisaraticuare: —Tata, ique canerecati ishuque ama juatsu taa ecanerecatiu ama. ");
INSERT INTO cavNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ecue Etata, micuetu dutya ataqui. Riya ique nerecada jutaquique tu ai patseda buchique. Canerecatitaquique ama juatsu taa ecanerecatiu ama. Ebacau datse mique era, ique canerecati ishu ama. Jadya ama bucha ecue biji eque ama paju. Micue biji eque paju, —jadyatu Jesúsra acuare tuja Etataque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Jadya juatsutu cuanucacuare quimisha tura dujuhua cuana queja. Cuaatsu tujatu ecana tahuijarabareyaju baticuare. Isaranaticuaretu Pedro: —¿Tahuiyami, Simón? ¿Eje bucha ecabati jutaqui amami yaratupu cuana cabatihua, ni peadya ura cuana? ");
INSERT INTO cavNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tuequedya tujatu ecana quimishadya isaracuare: —Necabaticue. Netahuiume. Nebacabacacue Yusu queja, micuana Satanásra ique jacamerecara ayaju, micuanaja idu ishu. Micuanaja tacajatu aijama casa Ijahuara cajuchatishacara ayaju casada juishu, arepa micuanara jacacarama aya ama bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Cuabeta ishutu Jesús cuanucacuare tuque cuahuaju nucadya, Yusu tsehue quisaratira. —Tata, canerecatitaquique ama juatsu taa ique ataya bae eatau ama. Jadya ama bucha ecue biji eque ama paju. Micue biji eque paju, —jadya ati beta tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Jadya juatsutu cuanucacuare tura quimisha dujuhua cuana queja. Cuanucatsu tujatu ecana tahuijarabareyaju batinucacuare. Busataqui ama cuita tunajatu yatuca bacuare tahuicara juatsu. Tahuiya baatsu tura nereda ayaju tuna eje bucha caquemitsatitaqui ama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Cuaquimisha ishutu cuanucacuare Yusu tsehue quisaratira. Jadya juatsutu cuanucacuare tura dujuhua cuana queja. —¿Canajaraya jari cuitadya micuana? ¿Tahuiya jari cuitadya ni taa micuana? Riya tupu camadya. Amenatu ura juetihua IQUE ECUITA tunara jucha arida cuana queja inamereyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Nenetitsuracue. Nedirura. Amenatu jehua ique ujeu cuana queja inamerequi juyaque, —jadya tuna Jesúra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús quisaratiya jarijutu Judas junaticuare, tura mepehuaquedya datse. Ecuita jetiama tsehuetu cuacuare. Cuchiru tsehue, acui tsehue jadya tuna junaticuare. Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara, emuiba cuanara jadya tuna cuadishacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Junatima jariradya tuna Judasra cuejanaticuare: “Era dyahuanatiyaque, tudya tume. Neinacue. Risitsu, nedujucue”, jadyapa tujatu ecana junatimaradya anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Junatitsu tujatu Jesús jipeticuare. —Banuchi, Ebahuityaquique. Jadya aatsu tujatu Jesús dyahuanaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Tura jadya ayajutu ecuita cuanara Jesús inaticuare. Inatsu tunajatu jida risicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jesúsra mepehuaratu cuchiru baeque baina juque juputsu pae dyaque muidaque merequique ijaca pejucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Tumetu Jesúsra isaracuare ecuita cuana jetiamaque: —Micuana micuana jehua cuchiru tsehue, acui tsehue jadya ique inara, chiri puji inara ejeu bucha. Anichinedya tuque micuanaja emajaca ejudya jutidya ique ina ishu cuchiruma, acuima. ");
INSERT INTO cavNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Dutya huecaca taa ique Yusuja etareju Yusuja quisarati bahuitya juchine. ¿Tume micuanara eje bucha juatsu inachine ama tuhua? Riya ique atayaqueri juya Yusu equeque quisarati cuejaqui cuanara cuejacuareque, Yusuja quisaratiju ehuene bae cuitadya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tuque quisaratiya tsunumeedyatu Jesúsra mepehua cuanaque dutya huanaterecuare. Jacacuare tuna Jesús. ");
INSERT INTO cavNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Peadya ehue ebariratu Jesús tupujudya acuare, sahuana tsehue capirurititsu. Tumeque datse tunajatu inacara acuare. Sahuana camadya tuna inadaditsu secacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Tunara inadadihuaju tujatu sahuana shanacuare. Quinajacameretitsutu huanacuare ecatacatique. ");
INSERT INTO cavNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Tuequedya tunajatu Jesús dujucuare pae dyaque muidaja etareju. Tuhuatu ecasitati jucuare pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque, tumebaedya israelita cuana emuiba cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Tumetu Pedrora tunara Jesús dujuyaju japa tupuaje acuare. Cuacuaretu pae dyaque muidaja etare tsecue tupu. Etare tsecue junatitsutu sudaru cuana tsehue aninaticuare. Tuna tsehuetu etiqui bahuinitya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pae cuanaja huaraji cuanara, dutya huaraji cuana tuhua ecasitati jucuare cuanaratu tyacara acuare Roma juque huaraji, tuque iyemere ishu. Jadya ama bucha tunajatu dadicuare ama eje bucha eque jidama cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jetiama tuhua jucuare cuanaratu pusha pusha tsehue jidamapa ejuu jadya acuare. Jadya ama bucha tunajatu daditaqui ama bacuare dutyara tupu tuque jidama ejuque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Eje uma quisaratiyaju bacatsutu umae chamacama huaraji cuanaja yacuaju netitsuranucacuare quisarati ishu. Pusha pusha tunajatu cuejacuare: ");
INSERT INTO cavNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Cuejaya micuana ecuanara, icuene tuque quisaratiyaju bacachineque: “Rihuishatillaya tuque Yusuja etare ecuita cuanaja eaque. Rihuishatillatsu, quimisha huecaca juatsu tuque anucaya ecuitaja eaque ama”, jadya tuque ecuana quisaratiyaju bacachine, —jadya tuna pusha pusha jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Arepa ecana umada “Bacachine tuque ecuana jadya quisaratiyaju”, jadya juya ama buchatu tunara cuitadya eje bucha adebataqui ama bacuare tunara quisaratiyaju bacahua tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Tuna jadya juyaju bacatsutu pae dyaque muidaque netitsuracuare dutya tuhua cuanaja yacuaju. Turatu Jesús bacaduracuare: —Bacahuadyami ecana micue ishu quisaratiyaju. ¿Caquemitsatiya ama cuitadya mique? ¿Jadidyami quisaratichine, jadya ama ni taa? ");
INSERT INTO cavNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesústu caquemitsaticuare ama. Yudijidyatu pae dyaque muidara bacaduranucacuare: —¿Midyami Mesías, Yusuja Emepeque? ¿Midyami Yusu Dyaque Jidaja Ebacuaque, aijama ni taa? ");
INSERT INTO cavNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—Jejee, Mesiasdya ique; Yusuja Ebacuaque ique. Ejeque huecaca micuanara ique babuque Yusuja jida eque amaca eaniqui muidaju aniyaju. Tumebaedya micuanara babuque barepa huani ducu eque junanucayaju, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jadya quisaratiyaju bacatsutu pae dyaque muidaque cahuaiticuare. Cahuaititsutu una cachajaticuare, dyaque cuita ecahuaitique ejitaju juishu. —Sareya ama tuque ecuana peyaja riyaque jidama juchineque cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Jesusratu Yusu cahuaitishaya tuja quisarati tsehue. Micuanaratu bacahuadya tura quisarati jidamaque ayaju. ¿Eje bucha micuana amerecara aya? ¿Iyemerecara, iyemerecarama ni taa? —jadya tujatu acuare peya huaraji cuana. —Jucha metse tuque. Pamajudya, —jadya tuna caquemitsaticuare. Dutyaja tupu tunajatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jadya aatsutu umae cuanara ebutsequiniju ecuedira acuare, eraca tsehue butsequini risi jadya. Jadya aatsu tunajatu bahuapaja bahuapaja acuare. —¿Aira taa mi ahua? —jadya tunajatu acuare, ijaribayaque. Tumebaedyatu sudaru cuanara bahuapajacuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pedrotu juanicuare jari pae dyaque muidaja etare tsecue. Tuque tuhua juaniyajutu nubiticuare tumeque etareju mere juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedro etiqui cunu etiqui bahui ani juyajutu epunara petanityacuare. —Miquemi Jesús Nazaretju tsehue junenihuaquedya, —jadyatu Pedro epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedrotu catehuaticuare: —¡Aijama, mama! ¡Adebaya ama tuque era! ¿Ejeque cuana taa tuquemi jadya aya? —jadyatu Pedro caquemitsaticuare. Tuequedyatu etare tsecue enubitaquiju netidirunucacuare. Jadya juyaju cuitatu tacure quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Epuna etareju mere juyaratu banucacuare tuhua junetiyaju. —Riyaque ecuita ri Jesús tsehue junenihuaquedya, —jadya tujatu acuare tuhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Tuquetu catehuatinucacuare: —¡Aijama, mama! ¡Adebaya ama tuque era! —jadyatu pusha pusha junucacuare. Yaratupu juatsutu tuhua cuanara jadya anucacuare Pedro: —Yuneri cuitadyami mique Jesús tsehue junenihuaquedya. Ecuanarami adebaya mique Galilea juque, —jadya tunajatu Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Tunara jadya ayajutu Pedro caquemitsaticuare: —¡Aijama! ¡Adebaya ama tuque tumeque ecuita micuanara ique jadya ayaque! Yusu bahue ique yuneri quisaratiya. Ique yuneri ama juyaque juatsu, Yusura panerecatura, —jadya tuna Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tuque jadya quisaratiyaju cuitatu tacure quique beta jucuare. Jadya juyajutu Pedro huecatanacuare. Caadebaticuaretu Jesúsra jadya cuejachineque: “Tacure quique beta juma jarijumi catehuati quimisha juya. ‘Adebaya ama tuque era’ jadya aquimisha mira aya”. Jadique adebatsutu Pedro paa ebari jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Apudajudyatu pae cuanaja huaraji cuana caradatinucacuare emuiba cuana tsehue, cacuatsashati bahuityaqui cuana tsehue jadya. Tuhuatu jucuare dutya israelita huaraji cuana. Inime tunajatu bajejecuare Jesús iyemere ishu. Erisi tunajatu Pilato Roma juque enaruqui cuarequi queja dujumerecuare. Pilato tunajatu tyaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Tuja yacuaju netitihuajutu Pilatora bacaduracuare: —¿Midyami israelita cuanaja ecuari? —Jejee, mira aya equedya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Pae cuanaja huaraji cuanaratu pusha pusha cuita cuejacuare dyaque jidamapa ejuu jadya Pilatoja yacuaju. ");
INSERT INTO cavNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Tumetu Pilatora bacaduranucacuare: —¿Bacaya amami ecana micue ishu dutya jidamaque quisarati ayaju? ¿Eje bucha juatsu tuquemi ecana quemitsaya ama? —jadyatu Pilatora Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesusratu quemitsacuare ama ni peadya quisarati tsehue. Jadya baatsutu enaruquique anajacatacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dutya maratu Pilatoja bahue jucuare Pascua chine ishu etare apudaju erisi netiyaque inajaca, ecuita cuanara peadya ejeque inajacamerecara ayaque camadya. ");
INSERT INTO cavNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tumepatyatu erisi neticuare ecuita etare apudaju Barrabás bacani. Roma juque enaruqui tsehue patu cahuaiticuare. Tuque, tuja ecare cuana jadya patuna enaruqui tsehue cahuaititsu quiyeticuare. Jadya tibudyapa tunajatu etare apudaju ishacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jetiamatu ecuita Pilatoja etare tsecue casitaticuare. Bacaticuare tuna: —Nerecabacue ecuana. Inajacacue micue bahue ecuanara mepeyaque, —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jadya tunara bacayaju bacatsu tuna Pilatora bacaduracuare: —¿Jesús tuque micuana eaqueja inajacamerecara aya, israelita cuanaja ecuari jadya juyaque? —jadya tujatu ecana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Turatu adebacuaredya ecuita cuanara ama Jesús ujeu bayaque, tunaja huaraji cuanara camadya. Bahuedyatu jucuare jishatsu huaraji cuanara Jesús inamerehuaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jadya ama buchatu pae cuanaja huaraji cuanara ecuita cuana capuritishacuare. —Pilato nebacacue, tuja Barrabás camadya inajacamere ishu, —jadya tunajatu ecana acuare. Ecuita jetiera amatu Pilato bacacuare, tuna huaraji cuanara cuejamerehuaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Tume tuna Pilatora bacaduranucacuare: —¿Tume jatsu micuanara ique ai amerecara aya Jesús micuanaja ecuari tsehue? ");
INSERT INTO cavNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—¡Curusuju tatamerecue! ¡Tuhua pamaju! —jadya tuna caquemitsaticuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Eje bucha juatsu? ¿Ai tujatu jidama achine? —jadya tuna Pilatora bacaduracuare. Abacatanacuare ama tuna quiqueyaque: —¡Curusuju tatamerecue maju ishu! ");
INSERT INTO cavNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatoratu ecuita cuana pureamaturacara acuare, tuatsehue ecahuaitiuju. Jutaquijudya tujatu Barrabásdya inajacamerecuare. Tuequedya tujatu Jesús menajetyacuare sudaru Romaju cuanaque, tunaja catsacatsa, curusuju tata jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Icuene tunajatu dujucuare Pilatoja etare tsecue. Sitacuare tuna dutya sudaru cuana tuhua anicuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ijahue ayaquedya jutidya tunajatu ecuari edujuta bucha dujue acuare. Dyaque jutuyaque tacatsu tunajatu jutumerecuare una sehuesahuauque, ecuari arida cuanaja ejutuqui tsehue. Iyucaju tunajatu jutumerecuare cunu sahua cuija epicaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—¡Emuita paju israelita cuanaja ecuari muidaque! —jadya tuna jucuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Acui tsehue tuna iyucaju acuare. Ecuedira tuna acuare. Jadya aatsu tuna tuja yacuaju chichucata jucuare, tuque ijahue ayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Jadya ijahue ijahue amena aatsu tunajatu tacanucacuare una sehuesahuauque, tujaque cuita una jutumerenuca ishu. Jadya aatsu tunajatu curusuju tata ishu dujucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Epu ebari juque cuinanayara tunajatu tsurutsacuare ecuita Cirene juque, Simón bacani. Simóntu Alejandro, Rufo jadyaja etataque jucuare. Eje queja japada juneniyaque juetiyaque tunajatu tsurutsatsu casada tsehue curusu mapamerecuare Jesús tatatana ishu juyaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Tudya tuna dujucuare Jesús Gólgota bacani emajacaju. Tumequetu jucuare uhua cuemusu, emaju iyuca baeque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tuhua tunajatu Jesús ijimerecara acuare uva nacaca esasanashaque mirra tsehue eujaque, ecuita uje cuana ujejarasha ishu. Jesusratu ijicarama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jadya aatsu tunajatu curusuju tatacuare. Curusuju amena tatatanahuaju tuna dadu ijahue jucuare, Jesúsra jutuhua cuanaque ejeja ejeja juyaque tuna cama cajaquetibare ishu. ");
INSERT INTO cavNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Apudajudya las nueve cuana ni tunajatu curusuju tatacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Tauraju ehueneque tunajatu shuracuare ebarucue tuja iyuca dyaque. Taurajutu ehuene jucuare eje bucha juatsu Jesús curusuju tatatanahuaque bahue amere ishuque. “Riyaque ri Jesús, israelita cuanaja ecuari” jadyatu ehuene jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Tumebaedya tunajatu beta ecuita casada tsehue ai secaquique ecatse curusuju tatacuare, Jesúsja jida eque amaca, peya jani eque amaca jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Icueneta huenedyatu Yusuja quisarati atanacuare: “Yusuja Emepeque ujeu baqui cuanaratu quiyeti puji bucha abuque”. Tumetu icueneta cueja atanacuare bae cuitadya judadicuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tueque cuetiya cuanaratu ijaribacuare iyuca huinu huinu tsehue tuque asicaba, bijidamadura jadya ayaque: —Miquemi dyaque casada cabatichine Yusuja etare rihuisha ishu. Quimisha huecaca juatsupa nityatsuranucaya, jadyami juchine. ");
INSERT INTO cavNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Yuneridya ni micue casa aniya, quinajacamereticue mita taca. Butecue curusu juque, —jadyatu ecuita cuanara acuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadya tunajatu ijillahuanacuare: —Peya cuana inajacamere ishupa tuja casa aniya. Tumetu tuta taca quinajacameretitaqui ama cabatiya. ");
INSERT INTO cavNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Mesías, Yusuja Emepequepa jadyatu juchine. Ecuanaja ecuari dyaque aridaquepa, jadyatu juchine. Curusu juque ni buteya, tume tuque ecuana ejeneya tuque Mesiasque, —jadya tuna tuna cama jubarecuare, tuque ijahue ayaque. Chiri aridaque ecatse tuatsehue curusuju tatatanacuareratu ijillahuananucacuaredya. ");
INSERT INTO cavNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tumetu tumeque chinequeja, barepatya eque las tres chinequeja dutya yahua apunaterecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Las tres chinequeja dyanetu Jesús jebuda quiquecuare: —Eloí, Eloí, ¿lema sabactani? (“Ecue Etata Yusu, ¿eje bucha juatsu mira jacahua?” jadique) —jadyatu quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Eje uma tuhua neticuare cuanaratu bacacuare. Elías tura ihuaraya bucha jutidya tunajatu bacacuare. —Nebacacue. Elías béru Yusu equeque quisarati cuejaquique jucuareque tujatu ihuaraya, tuque tsahuana ishu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jadya Jesús quiqueyaju bacatsutu eraca pucaca jiteque tsajajaajecuare. Mullaticuare tujatu uva nacaca esasanashaque patsedaju. Mullatsu tujatu acui barudaju risitsu nityatsuratsu ecuatsaju jipemerecuare tuja susu ishu datse. —Nebara, ejepa Elíasra junatsu butyanaya curusu juque, —jadyatu jucuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Tumetu Jesús quique pidya casada juatsu, amena ishu canajeti pidya juatsu majucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tuque majuyajudyatu Yusuja etare juque junuda eshuraque Dyaque Muidaque penequique chajatanacuare ebarucue eque emaque queja. ");
INSERT INTO cavNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Tuhuatu neticuare curusu tuyu cien sudaru cuana cuatsashaquique. Jesús majuya baatsutu jucuare: —Pusha ama cuitadya tucueri riyaque ecuita Yusuja Ebacuaque juhua, —jadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tuhuatu jetiama epuna cuana neticuare japada eque capetatiya cuanaque. María Magdalaju aniyaquetu tuhuadya jucuare, tumebaedya peya María, Santiago “Barudama”, José jadya ecatseja ecuaque. Salomé, tumebaedya peya cuana umada tuna tuhua netibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galileaju cuaya patya equetu tumeque epuna cuana tuatsehue junenicuare, tuque tsahua juyaque. Dutya riya cuanaque epuna cuanatu tuatsehue jecuare Jerusalénju. ");
INSERT INTO cavNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ijetitu amena nubihuie cuita jucuare. Cuetihuietu amena jucuare huecaca ecuanaja canajara huecaca ishu cabajejeti bahueque. ");
INSERT INTO cavNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Tumetu ijeti butema jarijudya, ecuita José Arimateaju cuinanacuareque juticuare Pilato queja. Josétu huaraji dyaque jida, emuique jucuare. Tuquetu peya huaraji cuana tsehue ecadutyatiquedya jucuare. Jadya ama bucha tujatu ejenecuare Jesús Yusuja enaruqui juishu ecuadishaque. Pilato queja junatitsu tujatu bacaticuare: —¿Ebutyamereu ama mira Jesús curusuju emaju badeyaque? Paishati caniju, —jadya tujatu Pilato aticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","“Jesús amena majuhua” jadya bacatsutu Pilatora ejenecarama acuare. Ihuaracuare tujatu sudaru cuana cuatsashaquique tuhua Golgotaju jucuareque. Tuque jutihuaju tujatu bacaduratsacuare: —¿Are majuhuadya Jesús? ¿Ejetsunue cuitatu amena maju jida juhuaque? —jadyatu Pilatora acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sudaru cuana cuatsashaquiratu quemitsacuare: —Jejee, yuneridyatu majuhua. Jadya bacatsutu Pilatora acuare José: —Butyameretsu emaju papa ishu cani epuruju ishaticue. ");
INSERT INTO cavNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Tumetu Joséra quemiticuare sahuana ishuque ejutuqui dyaque jidaque. Tura jadya ayaju tujatu curusu juque butyamerecuare. Butyameretsu tujatu piruricuare sahuana tsehue. Ishaticuare tujatu tumu cani jadya ishu epuruju. Jesús emajuque ishatsu tujatu etsecue tachimerecuare tumu ebari tsehue. ");
INSERT INTO cavNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalajura, María Jesúsja ecuaquera jadyatu petacuare. Bacuare tatse Jesús emajuque eju ishatanayaju. ");
INSERT INTO cavNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Amena ijeti nubihuaju, canajara huecaca cuetihuajutu, quimisha epuna cuanara ijimedaque quemiticuare Jesús emaju jarayaque ijimeda tsehue ati ishu. Ijimedaque quemira cuacuare cuanaque tuna jucuare: María Magdala juque; María, Santiago “Barudamaja” ecuaque; Salomé jadya. ");
INSERT INTO cavNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ijeti cuinanaya tsehuedya, apudajudya cuita dumicu huecacatu epuna cuana cuahuecacacuare Jesús emajuque tumu cani epuruju ishatanachineju. ");
INSERT INTO cavNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Tuhua cuayaque tuna juajecuare tuna cama: —¿Aira dyadi tuque ecuanaja tumu ebari tecuya emaju cani tsecue penequique? —jadya tuna cabacaduratiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Junatiyara tunajatu banaticuare tumu ebari cani tsecue penequique tuhua ama. Etecu tuna banaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Nubinaticuare tuna caniju. Nubitsu tunajatu banaticuare ehue ebari jida eque amaca juaniyaju. Ejutuqui paja tsehuetu ecajututi jucuare. Tuque baatsu tuna dyaque jecutanacuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tura tuna isaratsacuare: —Nejecutanaume. Jesús, Nazaret juque, curusuju tatatanachineque sare micuana juya. Rehua ama rique. Chachatu netitsuranucahua. Nepetanacue tunara ishachineju, yuneri tuque rehua aijamaque bahue juishu. ");
INSERT INTO cavNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Petatsu ebajarara nedirunucacue. Tura mepehua cuanaque necuejadirucue. Pedro neri neri necuejaticue. “Jesús patu icuenetadya cuaya Galileaju. Tuhuadyapa tura micuana ihuatiya. Tuhuadyapa tuque micuana batiya, tura micuana icueneta cuejachine baedya”, —jadya tujatu ecana cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jadya ayajutu epuna cuana masadama emaju cani juque dirunucacuare. Tsajaja cama tuna dirucuare. Tadadaya jadya tuna bajida juatsu jucuare. Epu ebariju dirunucayara tunajatu ni ejequedya jutidya cuejacuare, dyaque bajida cuita juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesús chacha junucatsu, netitsuratsu dumicu huecacaju tujatu icuene cuita cabamereti ishu acuare María Magdalaju anicuareque, tura icuene pacarucu ijahua cuana ijehuecuinacuareque. ");
INSERT INTO cavNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jesúsra cabamereti ishu ahuajutu tumeque epuna cuacuare tura mepehua cuanaque cuejara, Jesús amena enetitsuranucaque. Tuna queja junatitsu tujatu ecana peya inime, paya jadya juyaju banaticuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","“Jesús tu amena enetitsurunuca. Era cuitadyatu bahua”, jadya tura cuejayaju, tunajatu ejenecuare ama. ");
INSERT INTO cavNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Beta tura mepehuaque ecatse peya epuju cuayaju tatse Jesúsra cabamereti ishu acuare. Adeba piisi ama tatsejatu acuare, tunara babanicuare bucha ama cabamereticuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Pana adeba aatsu tatse yudijidya cuanuca jucuare peya cuana cuejara. Jadya cuejaya bacatsutu umae cuanara ejenecarama acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Peadya tunca peadya earacana tura mepehua cuanaque mesaju araarayaju tuna Jesúsra cabamereti ishu acuare. Jesúsra tuna nereda acuare: —Eje umara micuana cuejachine tunara cuitadya ique chacha banucachineque. Ejenechine ama micuana ecana, tunara cuejayaju. ¿Eje bucha juatsu? ¿Eje bucha juatsu micuana niju pajida quejeneti baecua? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Isaranucacuare tujatu ecana: —Necuacue ecue quisarati dutya queja cuejara. ");
INSERT INTO cavNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Necuejacue ecana: “Ejeque, Jesús queja catyatitsu cutsameretiyaquetu Yusu queja judirubuque. Ejeque, Jesús queja catyatiyaque amatu ijahuaja etiquiju ijehuetanabuque”, jadya ecana necuejaticue. ");
INSERT INTO cavNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Eratu tyabuque eaqueja catyatiya cuanaque casa, ejeque ecuitaja ataquique ama aishu. Ecue casa tsehue tunajatu ijahua cuana ijehuecuinabuque. Ecue casa tsehue tunajatu yana cuana bape eque cuejabuque ecue quisarati. ");
INSERT INTO cavNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Inaya ni tuna bacua dyaque ujeda cuanaque, ijiya ni tuna ai venenuquique, eje bucha ama tuna jubuque. Ujejeda cuanaque tunajatu jabatsu chachanebuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tuna cueja amena aatsutu Ecuana Cuatsashaquique Jesús cuacuare barepaju. Aniticuaretu eaniqui muidaju Etataque Yusuja jida eque amaca. ");
INSERT INTO cavNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Tuequedyatu Jesúsra mepecuare cuanaque cuacuare dutya queja tuja quisarati cuejara. Jesús bacue tuna tsehuedya cuacuare. Casaturacuaretu ecana. Tuna quisarati jidaque cueja juyaju tuna Jesúsra ejeque ecuitaja ataquique ama amerecuare, tunara quisarati cuejayaque Yusu jaque yunerine ishu. Riya tupu camadya micuana cuejahua. Marcos");
INSERT INTO cavNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Riya micue quirica cuadishaya, Teófilo. Hueneya rique quirica mique Jesucristo eje buchique bahue amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Umaeratu amena huenecuaredya Jesús eje bucha riyaque yahuaju junahuaque. Jadique quisarati huenema jarique tuna tura mepehua cuana tsehue, tuque eje bucha juyaju petaqui jucuare cuana tsehue, jadya tuna quisaraticuare. Eje bucha juhuaque pana bahue juatsu piisi tunajatu huenecuare tuque jucuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Eratu adebacuare dutya inime eque, inime tsapema tsehue catibutihua eque terediruya tupu. Jidadya tuque adebaya riya cuanaque huene ishu, mique ecue dyaque iyuhuedaque Teófilo. ");
INSERT INTO cavNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Hueneya tuque micue era riyaque cueja, mique tunara bahuityacuareque, pusha ama cuitadya yunerique mique bahue juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Teófilo, icuene mique cuejaya Zacarías ehuaneque Elisabet tsehue eje bucha jucuareque. Herodes Judeaju enaruqui jucuare patyatu jadya jucuare. Israel eque ejuracanaquetu Zacarías bacani jucuare. Paetu jucuare. Abías cuare juquetu jucuare. Tuja ehuanequetu Elisabet bacani jucuare. Tumeque epunatu jucuare pae israelita Aarón bacani eque ejuracanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Betadya tatse tuyu jucuare Yusuja yacuaju. Tatse tatse anicuare Yusura cuatsashahua eque. Jadya tibu tatse ni ejeradya jutidya ni aiju jucha metse jadya acuare ama. ");
INSERT INTO cavNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bacuama tatse jucuare, Elisabet cabacuati baecua juya tibu. Betadya tatse amena esiri jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jadyatu jucuare Zacarías queja inime, tuque Yusuja etareju mere juyaju. Quimisacarucu huecaca cama tunajatu mere ishuque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Pae cuanaja bahue tunajatu peadya tuhuaque mepe bahue junenicuare muru ijimedaque pahua ishu Yusuja etareju Muida Cuitaque Amaju. Tume tunajatu Zacarías mepecuare muru ijimedaque pahua ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Tura muru ijimedaque pahuayajutu jetiama ecuita caradatihua cuanaque etare tsecue Yusu tsehue quisarati bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Tumetu Zacarías queja cabamereticuare barepa juque Yusu tsahuaquique Yusura cuadishayaque. Tumu mesa tunara muru ijimedaque pahuati bahuejutu jida eque amaca netinacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tuque baatsutu Zacarías ana ajacatacuare. Dyaque bajidatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Yusu tsahuaquiratu isaracuare: —Zacarías, bajida juume. Yusura tuque micue quisarati bacahua. Ayadya tujatu mira bacahua equedya. Micue huane Elisabet tu cabacuatiya. Peadya ebacua tujatu adadiya. “Juan” tuja ebacani paju. ");
INSERT INTO cavNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Mique, tumebaedya peya cuana jadya micuana pureama jubuque ebacua nana cuinanahuaju. Dyaque jida micuana jubuque, Yusura ecuita dyaque inime metseque bucha baya tibu. Turatu ijibuque ama uva nacaca esasanashaque ni peya nijuqui ishuque. Tuque cuinanama jarijudyatu Yusuja Espíritu tuatsehue jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Turatu jetiama israelita cuana inime cacuaretishabuque, Yusu iyuhueda bamere ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ecuana Cuatsashaquira Yusuja quisarati cuejatibunema jarijutu micue bacuara jadya cuejabuque: “Nequihuaticue, Ecuana Cuatsashaquique junayaju ishu”. Tujatu tumeque casadya anibuque Yusu equeque quisarati cuejaquique beru Elías jucuare bae. Yusuja Espíritu tu micue bacua tsehue jubuque, béru Elías tsehue jucuare bae. Micue bacuaratu etata cuanaque queja ebacua cuanaque iyuhueda bamerebuque. Turatu Yusu adeba baecua cuanaque Yusu iyuhueda amerebuque. Jadya bajejee tujatu abuque ecuita cuana, Ecuana Cuatsashaquique jida tsehue batsa ishu, —jadyatu Yusu tsahuaquira acuare Zacarías. ");
INSERT INTO cavNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacariasratu bacaduracuare Yusu tsahuaquique: —¿Eje bucha adebae jatsu tuque eau yuneridya jadya juyaque? Esiri cuita dyadi taa ique, ecue ehuane bacue tumebaedya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Yusu tsahuaquiratu quemitsacuare: —Ique Gabriel bacani; dutya huecaca Yusuja yacuaju tuque mere juyaque ique. Turadya cuadishahua mique isara ishu, riyaque jidaque quisarati cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Era cuejahuaque mira ejenehua ama tibumi iyacua quisarati baecua juya. Quisaratijacaya mique, micue bacua cuinanaya tupu. Yuneridya, jadidyatu judadiya, —jadya tujatu acuare Zacarías. ");
INSERT INTO cavNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tuque jadya juya tsunumeetu jetiama ecuita etsecueju caradaticuare, Zacarías cuinanayaque ihua. Tume tuna cabacaduratibarecuare: —¿Eje bucha juatsutu Zacarías tsunutaya? ");
INSERT INTO cavNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Amena tuque cuinanaetitsu tujatu ecana isaracara datse acuare. Zacariastu quisaratitaqui ama cabaticuare. Anamatu jucuare. Adebacuaredya tunajatu Muida Cuita Amaju barepa juque ai cuana bahuaque. Emetucu tsehuedya jutidya tujatu ecana piyecuejacuare tura bahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Amena Yusuja etareju mere ishuque huecaca tuja terehuajutu Zacarías dirucuare tuja etareju. ");
INSERT INTO cavNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jadya juatsu tujatu ehuaneque Elisabet maqui jucuare. Pishica baditu cuinana baecua jucuare tuja etare juque. Inime tujatu jucuare: ");
INSERT INTO cavNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—¡Yusutu dyaque jida eatsehue! Nerecabahua tura ique bacuamaque ebisuuju, —jadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Shucuta badi juhuajutu Yusura cuadishacuare tuque tsahuaquique Gabriel bacani Nazaret epu ebariju Galilea yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Epuna ehue ebari María bacani deca baecua queja tujatu cuadishacuare. Tumeque epuna ehue ebarijatu anicuare caquemiti ishuque quisarati ecuita José bacani tsehue. Josétu jucuare ecuari David eque ejuracanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Yusu tsahuaquiquetu nubiticuare María aniyaju. Nubitsu tujatu isaraticuare: —Bandía, mama. Isaraya mique era. Yusu tu miatsehue dyaque jida. Tuquetu miatsehuedya. Turami mepehua dutya epuna cuana ducuque, —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Amena barepa juque Yusu tsahuaquique baatsu, tuja etsuri bacatsu tujatu eje bucha adebataquima, ni daditaqui inime bacuare. Tume tujatu inime jucuare: —¿Eje bucha juatsu tura jadya isaranae aya? —jadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tumetu Yusu tsahuaquira acuare: —Bajida juume, María. Yusutu miatsehue dyaque jida. ");
INSERT INTO cavNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ejetsunue juatsu amami carecani isaqui juya. Peadya ebacua tuque micue cuinanaya. JESUS bacani acue. ");
INSERT INTO cavNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tuquetu dyaque inime metseque judadiya. YUSU DYAQUE CASADAJA EBACUAQUE bacanitu judadiya. Micue bacuatu Yusura ameredadiya ecuari, tuja ebabaque David amerehua bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Cuatsashajacabuque ama tujatu israelita cuana. Terebuque ama tujatu ecuari juque inime, —jadya tujatu María acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tumetu Mariara acuare: —Ique deca baecua. ¿Eje bucha cabacuatie ejuu? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Yusu tsahuaquiratu quemitsacuare: —Yusuja Espíritu tu miaqueja junaya. Yusu dutya casa aniyarami jadya amereya. Jadya tibudyatu ebacua nana cuinanayaque YUSUJA EBACUAQUE bacani juya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Tumebaedyatu micue ata Elisabetja cuinanayadya ebacua, arepa tuque esiri juya ama bucha. Tunara “cabacuati baecua” jadya ayaquetu amena shucuta badi maquique. ");
INSERT INTO cavNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Aijamatu Yusuja ai ataqui amaque, —jadyatu Yusu tsahuaquira acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Tumetu Mariara acuare: —Yusu Ecuana Cuatsashaquira cuatsashaya eque juishuque ique. Paju taa mira ique cuejahua eque, —jadyatu Mariara acuare. Tuque jadya cuejatsutu Yusu tsahuaquique dirunucacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Eje uma huecaca ama jadya juhuaque cuetihuajutu María cabajejetitsu cuacuare Judea emata epuju, Elisabet, Zacarías ecatse aniyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tuhua junatitsutu nubinaticuare tatseja etareju. Etareju nubinatitsu tujatu isaranaticuare tuja ata Elisabet. ");
INSERT INTO cavNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mariara jadya isaranatie ayajutu Elisabetja ebacua ecare cani juque bucucucuare. Jadya juyajutu Elisabet caadebaticuare Yusuja Espíritu tuatsehueque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Tume tujatu María jadya acuare: —Yusurami mepehua dutya epuna cuana ducuque mique peadya. Tuquetu miatsehue dyaque jida. Tumebaedya tujatu mepehua micue bacua cuinanadadiyaque, dyaque jida tuatsehue juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Ai jatsu ique, Ique Cuatsashaquija ecuaque eaqueja tarepera jeishu? ");
INSERT INTO cavNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Mira isarayaju micue etsuri bacaya tsehuedya cuitadya tuque ecue ebacua nana ecarecani juque bucucuhua, pureama juatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Miquemi dyaque jida, mique tyatana ana atahuaque tyatahua tibu. Yuneri cuitadyatu Yusura yana ahua equedya judadiya, —jadyatu Elisabetra atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Tumetu María jerucuare Yusu pureama ayaque: “Dutya ecue inime tsehue mique pureama aya, Yusu Ique Cuatsashaquique dyaque casadaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mique Ique Inajacamerequiradya ducuta pureama amereya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Mira jida tsehue mepehua. Mique merequique jetiedyaque ique. Riyaque huecaca eque amena dutyara: ‘María peadyatu aniya epuna Yusura mepehuaque, tuatsehue dyaque jida juishu’ jadya abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mique dutya casa aniyaquemi dyaque jida juhua eatsehue. Miquemi juchama neri. ");
INSERT INTO cavNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Micuetu nerecabajacanime ama mique muibaqui cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Miquemi dyaque casada. Casumitiya cuanara inime pireya cuanaquemi pana yuamatura aya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Casada cabatiya cuanaque tuquemi casadama amereya. Casadama cabatiya cuanaque tuquemi casada amereya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nerecada cuanaque tuquemi dutya tunara ai sareya cuanaque tyaya. Chipiruda cuanaque bacuemi ecana ni ai buchique tyaya ama. ");
INSERT INTO cavNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Micuetu tsahua bahue Israel eque ejuracana cuanaque, mique merequi cuanaque. Ni eje tupu mira ecuana iyuhue tsehue bajacaya ama. ");
INSERT INTO cavNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jadidya tuquemi quisarati tyahua ecuanaja ebaba Abraham, dutya tuque eque ejuracana cuanaque jadya. Tereya ama tuque micue ecuana tsehue ecuana nerecaba ishuque”, jadyatu Mariara Yusu jeru eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Quimisha baditu Maria Elisabet queja aniticuare. Jadya juatsutu dirunucacuare tuja etareju. ");
INSERT INTO cavNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tumetu Elisabetja cuina ishuque huecaca jueticuare. Ejitajutu acuare peadya deca ebacua. ");
INSERT INTO cavNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Yusu Elisabet tsehue dyaque jidaque bahue juatsutu tuja ata cuana tuaqueja cuacuare, “Dyaque jidatu Yusu miatsehue” jadya cuejara. ");
INSERT INTO cavNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ebacua nanaja cuinana huecaca catsurutiyajutu tuja ata cuana, tuque japadama aniya cuanaque jadya chine ishu cuejatanacuare. Tumeque huecacatu ebacua nana ecuita huitu biti tubutanacuare tunaja bahue Israel eque ejuracanaque jadya adebatae juishuque. Etataque “Zacarías” bacani datse tunajatu acara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tume tuna ecuaque Elisabetra jadya acuare: —“Juan” bacani paju, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—¿Eje bucha juatsu? Aijama taa tu Juan bacani micue ata ni peadya, —jadya tunajatu acuare Elisabet. ");
INSERT INTO cavNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Elisabetra “Zacarías” bacani acarama aya bacatsu, “‘Juan’ bacani paju”, jadya ayajutu ecuita cuanara emetucu tsehuedya jutidya ebacua nanaja etataque bacaduracuare: —¿Ai bacani tuquemi amerecara aya? —jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Tuja emetucu tsehue piye cuejatsu tujatu bacacuare aiju huene ishuque. Inatsatsu tujatu huenecuare, “‘Juan’ bacani paju”. Dutyara tunajatu bape ebari bacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jadya huenetsutu Zacarías quisaratitibunenucacuare. Quisaratinucatsu tujatu Yusu pureama atibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Dutya tuque japadama aniya cuanaque tuna anajacatacuare. Tsapecuare tunajatu quisarati dutya Judea yahuaju emata cuanaju anitaya cuana queja Zacarías eje bucha juhuaque. Cuatsabiji tunajatu acuare, ebacuaqueja ebacani cuejatsupa amena quisaratinucaya jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Dutya tumeque cuatsabiji jadya juhuaque bahue juya cuanara tunajatu bape bacacuare. Cabacaduratibarecuare tuna: —¿Aitu judadibuque tumeque ebacua nana? —jadya tuna jubarecuare tuna cama. Yuneridya tucuetu Yusu Ecuana Cuatsashaquira naruya, tsahuaya jadya aya eje tupu tuque aniya jari tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Tumetu Yusuja Espiritura ebacua nanaja etataque Zacarías jerushacuare: ");
INSERT INTO cavNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yusu Ecuana Cuatsashaquique, pureama ea jucue. Miquemi Yusu ecuana Israel eque ejuracana cuanara muiyaque. Emuita mique, ecuana Ijahua quejaque inajacamerera jehua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Mira tuque ecuanaja Ecuana Inajacamerequique casadaque cuadishahua. David eque ejuracanaque tume. ");
INSERT INTO cavNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Jadya tuquemi quisarati iyacuare mique eque quisarati cuejaqui cuana eque béru yuequedya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Inajacamerebuque micuana era dutya micuana bijidamaduraqui cuana quejaque, tumebaedya micuana ujeu baqui cuana quejaque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Anibuque tuque ecue canerecabati micuana tsehue, micuana eque ejuracana cuana tsehue jadya. Judadima ama amatu judadibuque era micuana eje bucha aana ahuaque’ jadya mira ecuana ahua. ");
INSERT INTO cavNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Riyaque tuquemi quisarati tyacuare ecuanaja ebaba Abraham: ");
INSERT INTO cavNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","‘Eratu mique eque ejuracana cuanaque cuinanashabuque tuna ujeu baqui cuana quejaque, tunaja ique bajida tsehue ama mere ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ecue cuanaque tuna amerebuque. Tuyu tuna anishabuque ecue yacuaju’ jadya tuquemi Abraham tyaana acuare”, jadyatu Zacariasra acuare tuque pureama ayaque. Jadya quisarati au jadya juatsu tujatu anucacuare quisarati ebacuaque Juanja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“Miquemi ecue ebacua. Miquemi Yusu ebarucue aniya equeque quisarati cuejaqui judadiya. Ecuana Cuashatsaquique junama jarijumi tuque junayaju ishu ecuita cuana bajeje ishu jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Miratu cuejabuque micue ata cuana Yusura tuna inajacamerebuqueque, tunaja jucha cuana tillabuqueque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yusura ecuana inajacamerebuque ecuana huecaquique junatsu, ijetira huecacayaju yahua udaya bucha huecaera. ");
INSERT INTO cavNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Tura ecuana huecanaya ecuana apuda ducu aniya cuanaque, ecuana maju mubajacaya ama cuanaque. Tura ecuana Yusu tsehue jida amerenucaya, tuatsehue ecuana eje bucha tsehue ama ani ishu”, jadyatu Zacarías jucuare jeru eque. ");
INSERT INTO cavNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ebacua nana bacue ariari juajecuare. Quinimetiajecuare. Amena ecuita juatsutu anicuare epu ebari japada anitaya cuanaju. Tuhuatu anicuare, tuja ata israelita cuana Yusuja quisarati cuejatibuneya tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tume patyatu Roma juque enaruqui Augusto bacanira cuatsashacuare dutya tuque muibaqui cuanaque tunaja dutyaja ebacani cuana quiricaju quiyatiti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Riyaque inime, ebacani quiricaju quiyatitu jumetse jucuare Cirenio, Siriaju aniya cuanaja huaraji jucuare patya. ");
INSERT INTO cavNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Dutya tuna cuataqui jucuare tunaja ebaba cuanaqueja epuju, tuhua ebacani cuana quiyamereti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","José, David eque ejuracanaque juya tibutu cuataqui jucuare Belén bacani epuju, tuque cuinanacuareju. Tumetu José cuacuare tuja epu Nazaret bacani juque, Galilea yahua juque; tuhuaquetu cuacuare Belénju Judea yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tudya tatse María cuinahuaraque Belénju cuacuare tatseja ebacani quiyameretira. Mariajatu quisarati anicuare caquemiti ishuque José tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Tatse Belénju junatiyaque huecaca tujatu cuina ishuque huecaca jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Cuinanacuare tujatu bametseque ebacuaque. Cuinanahuajutu piruricuare eja tsehue. Piruritsutu huanacuare huaca cuana araara ishuju, etare anitaya cuanaju aijama emajaca jucuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Tumepatyatu anicuare Belén emajacaju uhuisha cuana narusisa juya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Muya jutidyatu ejitaju jucuare barepaju Yusu tsahuaquique. Yusuratu uhuisha naruqui cuanaque dutya huecatillamerecuare. Jadya baatsu tuna bajida jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tume tuna Yusu tsahuaquira aticuare: —Bajida nejuume. Era micuana jidaque quisarati cuejanaya dutya ecuita cuana pureama amere ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Riyaque huecacatu David beru anicuare epuju cuinanahua Micuana Inajacamerequique. Tuquetu Ecuatsashaquique, Mesías “Yusuja Emepeque” jadique. ");
INSERT INTO cavNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Riyaque micuana cuejanaya, micuana era cuejayaque yunerique bahue juishu. Ebacua nana petara cuaatsu tuque micuana eja tsehue epiruri jarayaju batiya, huaca cuana araara ishuju, —jadya tujatu ecana aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Tuque quisaratiya tsunumeetu ejitaju jucuare jetiama barepaju Yusu tsahuaqui cuanaque. Tume tuna jerucuare Yusu pureama ayaque: ");
INSERT INTO cavNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Hosana! ¡Arida, dyaque casada jadyatu Yusu barepaju aniyaque! ¡Inime tsapema paju Yusu pureamaturaqui cuanaque!”, jadya tuna jucuare jeru eque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jadya juatsutu Yusu tsahuaqui cuanaque dirunucacuare yudijidya barepaju. Amena tuna dirunucahuajutu uhuisha naruqui cuanaque tuna cama quisaratitibunecuare: —Necuara Belénju. Nebatira tumeque inime eje bucha juhuaque, Yusura ecuana cuejamerehuaque, —jadya tuna jucuare tuna cama. ");
INSERT INTO cavNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jadya juatsu tuna ebajarara cuita cuacuare. Junatitsu tunajatu banaticuare María, José, ebacua nana jadya. Ebacua nanatu jaracuare huaca cuana araara ishuju. ");
INSERT INTO cavNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ebacua nana banatitsu tunajatu María ecatse cuejanaticuare tuna cuejatahuaque ebacua nana eje buchique. ");
INSERT INTO cavNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Dutya tuhua jucuare cuanaque tuna uhuisha naruqui cuanara cuejayaque bacatsu anajacatacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariatu nime aputacuare ama uhuisha naruqui cuanara cuejahuaque. Tumequedya jutidya tujatu inime tupuqui acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Uhuisha naruqui cuanaque tuna dirunucacuare. Barepa juque tsahuaquira cuejahua bae cuitadya batitsu, tunajatu Yusu pureama, mui jadya jeru eque aajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ebacua nanaja cuinana huecaca catsurutiyajutu etataque ecatsera tunaja bahue amerecuare. Ecuita huitu biti tatsejatu tubumereticuare, israelita riya jadya adebatae juishu. Jadya aatsu tunajatu JESUS bacani iyacuare. Riyaque ebacanidyatu barepa juque Yusu tsahuaquira María iyamerecuareque tuque maqui juma jariju. ");
INSERT INTO cavNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Pushi tunca huecaca cuetihuaju, tatsejatu dujucuare ebacua nana Jerusalén epu ebariju Yusu bamereti ishu. Moisésja cacuatsashatitu jadya jucuare. Pushi tunca huecaca ebacua cuinana ishu aniyajutu etata cuanaque quibeti bahue junenicuare Yusuja yacuaju jida, asicadama cabamereti ishu. Jadya tibu tatsejatu ebacua nana dujucuare Yusuja etareju, Yusu bamereti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jadya tatsejatu acuare, Yusura cuatsashahuaque jadya ehuene tibu: “Dutya icueneque deca ebacua cuinanayaquetu Yusuja ishu cuita camadya jutaqui”. ");
INSERT INTO cavNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yusura jadya amereya tibu tatsejatu Yusu tyataqui jucuare beta huei. Tume tatse cuacuaredya huei tyara. ");
INSERT INTO cavNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tumepatyatu ecuita Simeón bacani Jerusalénju anicuare. Tumeque ecuitatu jida tuyuque jucuare. Turatu ihuacuare eje tupu Yusura Israel eque ejuracana cuanaque jida inimeju cuinanashadadiyaque. Yusuja Espíritu tu anicuare tuatsehue. Simeonratu iyuhueda bacuare Yusu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Berutu Espiritura tuque cuejacuare: “Miratu babuque Yusura riyaque yahuaju cuadishabuqueque. Tuque bamaquemi majubuque ama”. ");
INSERT INTO cavNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mariara, Joséra jadya ebacua nana Jesús Yusuja etareju cacuatsashati eque aishu beya tsunumeetu Yusuja Espiritura Simeón inime tyacuare tuque tuhua nucadya cuaishu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nubitsu tujatu María ecana jipeticuare. Jipetitsutu ebacua nana mapaticuare. Mapatsu tujatu Yusu pureama acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Yusu Ecuana Cuatsashaquique, amena tuquemi ahuadya mira quisarati mique merequique tyaana acuareque. Amena ique pureama juya. Majutaqui ique, era ihuayaque ejitaju juhua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bahuadya tuque era, mira Ecuana Inajacamerequique cuadishahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Cuadishahua tuque mira dutya queja aniya cuanaque eje bucha inajacameree ayaque adeba ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tudyatu israelita ama cuana Yusu eje buchique adebamerequique. Tunaja hueca buchique tume. Tuque equedya ecuana israelita cuanaque muitabuque. Tuque equedya ecuana micue cuanaque muitabuque,” jadyatu Simeón jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joséra, Jesúsja ecuaquera jadya tatsejatu anajacata ishu acuare, Simeónra ebacua nana eje bucha judadiyaque quisarati ayaju bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeónra tatse cuejacuare: —Yusura jida nenarucue. Metse tsehue pajuneni, —jadya tujatu ecatse acuare. Tuequedya tujatu María isaracuare: —Jetiama Israel eque ejuracana cuanaque tuna micue bacua queja catyatibuque. Tuna tuna dyaque jida jubuque. Peya israelita cuana bacue tuaqueja catyatibuque ama. Tuna tuna dyaque canerecatibuque. Dutyara jujerira tunajatu micue bacua bijidamadurabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Jadya adebataetu jubuque peadya peadyara inime tupuyaque. Miquemi nerecada jubuque, micue bacua eje bucha judadiyaque baatsu. Cuchiru ebari micue enijuju tutsuhua buchami cabatibuque, —jadyatu Simeónra María acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tumebaedyatu tuhuadya jucuare epuna Ana bacani. Tuquetu Yusu equeque quisarati cuejaquique jucuare. Tuquetu jucuare Fanuelja ebacujunaque, Aser cuare juque. Anatu jucuare esiri. Ehue ebariquetu ahuequi jucuare. Tuja yahuique tsehuetu anicuare pacarucu mara piji camadya. ");
INSERT INTO cavNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Tumepatyatu jucuare eahuemajuque quimisacarucu tunca pushi earacana mara. Cuinana baecuatu jucuare Yusuja etare juque. Huecada tupu, meta tupu jadya tujatu Yusu merecuare, Yusu tsehue quisarati, arama quibeti jadya juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeón María tsehue quisaratiya tsunumeetu Anara jipeticuare. Yusurupaitu acuare Yusu. Yusu yusurupai aatsutu quisaratitibunecuare tuhua cuana tsehue: —Riyaque ebacua nana ri Yusura Jerusalénju aniya cuanaque jida inimeju cuinanasha ishu cuadishahuaque. Riyaquedya ri micuanara ihuahuaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusura Moisés eque dutya cuatsashahuaque atillatsu tuna dirunucacuare Galileaju, tunaja epu Nazaretju. ");
INSERT INTO cavNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ebacua nana bacue ariari juajecuare. Casada, quinimeti, bahue jadyatu juajecuare. Yusuratu jacacuare ama. Iyuhue tsehue tujatu narucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Josétu María tsehue cuau cuau jucuare Jerusalénju dutya mara Pascua chine ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús amena peadya tunca beta earacana mara juhuaju tatsejatu dujucuare Jerusalénju, Pascua chine ishu, tatseja tumepatya jadya bahue jucuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Amena chine terehuajutu María, José ecatse dirunucacuare tatseja epuju. Tumetu Jesús anicuare Jerusalénju, ecuaque, José jadya baecuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Tatseratu Jesús ecuita cuana ducu diruya cuana bucha datse bacuare. Ajecuare tuna peadya huecaca. Amena ijeti nubihuaju tatsejatu sarecuare tatseja ata cuana ducu, tatseja eadeba cuana tsehue jadya ediruuque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Dadicuare ama tatsera. Yudijidya tatse cuanucacuare Jerusalénju, tuque sarera. ");
INSERT INTO cavNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Quimisha huecaca juatsu tatse chamacama dadicuare Yusuja etareju, cacuatsashati bahuityaqui cuana tsehue juaniyaju, tura ecana bacadurabaretsu ijaca bacaaniyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tuque quisaratiyaju bacaqui cuanaratu bape bacuare tuque dyaque bahue baatsu, tura ecana dutya jida quemitsaya bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Amena anajacatacuare María, José jadya ecatse Jesús tuhua dadidirutsu. Tuja ecuaqueratu jadya acuare: —¿Eje bucha juatsu mira yatse jadya jutidya ahua, deca? Tata tsehue mira yatse jidama cuita inime bamerehua mique datse saretsu, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesúsra tatse jadya quemitsacuare: —¿Aishu jatsu metsera sareya? ¿Adebaya ama jatsu metsera ique ecue Etataja etareju ai jutaquique? —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Tatseratu adebacuare ama eje buchique tura jadya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tumetu dirucuare tatse tsehue Nazaretju. Yana equedyatu jucuare. Tuja ecuaquetu eje bucha nime aputataquima jucuare dutya eje bucha juhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesústu daneajecuare. Dyaquedya jutidyatu cabahuityatiajecuare. Yusu pureamaturayaque, ecuita cuana pureamaturayaque jadyatu anicuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Tumetu Yusura Juan, Zacaríasja ebacuaque cuadishacuare, tuja quisarati cuejara. Juantu anicuare tsecada eje uma piji anitaya cuana queja, Tiberio Roma juque enaruquique peadya tunca pishica earacana mara jucuare patya. Tumebaedyatu Poncio Pilato, Judea juque huaraji jucuare tume patya. Herodes tu huaraji jucuare Galileaju. Felipe, Herodes tsehuequiquetu Iturea, Traconite jadyaju huaraji jucuare. Lisanias tu Abilinia juque huaraji jucuare. Anás, Caifás jadya tatse pae dyaque muidaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tumetu Juan quisarati cuejacuejanira cuacuare dutya queja cueri Jordán bacani jiruru queja. Juanja tuna cueja bahue jucuare tuhua cuanaque: —Necacuareticue inime, Yusuja micuanaja jucha cuana apupasha ishu. Necutsamereticue, yuneridya inime cacuaretihua jadique adebataqui juishu, —jadya tujatu ecana cueja bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jadyatu jucuare, beru yuequedya Yusu equeque quisarati cuejaquique Isaiasra huenecuare equedya: “Quisarati cuejatu jubuque ejeque cuana tsecada eje uma piji anitaya cuana queja. ‘Nequihuaticue, Ecuana Cuatsashaquique junayaju ishu. Jidamaque neajacacue. Jida tuyu nejucue, ediji benubenuque etuyune ejuu bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Dutyatu ebajeje jubuque. Dutya jidama cuanaquetu etuyune jubuque. Ediji ebajejeque buchatu jubuque, ehuedeta cuana ejequeshabare bucha, emata, uhua cuemusu cuana ecuepubare bucha, ediji benu benu cuanaque etuyunebare bucha, ediji dutya tupu ama cuanaque epapabare bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Dutya queja cuanaquetu bahue jubuque eje bucha inajacameree Yusura abuqueque’”, jadyatu Isaiasra huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","8","Umada ecuita cuanatu cuacuare Juanra Yusuja quisarati cuejayaque ijacabacara, tuaqueja cutsameretira. Tuaqueja cuaya cuanaque tujatu ecana atsacuare: —Cutsameretimaquedya necabamereticue inime cacuaretihuaque, cajuchaticarama juyaque jadya. Bacua cuana yachi tiruyaju eje buchadya huanacara ejuu bucha micuana juya. Cutsameretitsu Yusura enerecaturauque ehuanau bucha tuque micuanaja inime juya. Jadya ama tuque. “Abraham eque ejuracanaque tibu, ecuana Yusura nerecaturabuque ama”, jadya micuanaja inime paju ama. Dyaque inime metseque juishuque ama tu Abraham eque ejuracanaque. Cuejaya micuana era. Yusujatu aniya casa riyaque tumu cuana Abraham eque ejuracanaque amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Micuana micuana acui cacacati baecuaque bucha. Acui cacacati baecuaque tu jacha tsehue cuere, pahua jadya aishuque. Jadya micuana Yusura abuque, micuana inime cacuaretiyaque ama juatsu. Acui cuere bahuera eau bucha tura micuana abuque, —jadya tuna Juanra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jadyatu tuque bacaqui cuanara bacaduracuare: —Jutaquiju ¿ai ecuana Yusura amerecara aya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tura tuna quemitsacuare: —Jadya nejucue yuneridya micuana inime cacuaretihuaque ejitaju juishu. Ejeja beta camisa aniyajatu tyataqui peadya ejeja aijama cuitaque. Ejeja ara ishuque aniyajatu jaquetsu tyataqui ejeja aijamaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Tumetu juticuare Roma juque enaruquija chipiru bacaqui cuanaque cutsameretira. —Ebahuityaquique, ¿eje bucha ecuana ejuu inime cacuaretihuaque ejitaju cabamereti ishu? —jadya tunajatu Juan acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—Dyaque cuita ecana netsujebacaume. Cacuatsashatira tsuje bacaya tupu camadya netsuje bacacue, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Tumebaedyatu sudaru cuanara bacaduraticuare: —¿Ecuana bacue eje bucha jutaqui inime cacuaretihuaque ejitaju adebataqui juishu? —jadya tunajatu acuare. —Nesecaume ai ni ejeque casada tsehue. Misida neaume ni ejeque eje bucha jumaquedya jutidya. Pureamadya jutidya nejucue micuana tsujetyataya tsehue, —jadya tuna Juanra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ecuita cuanatu quihuaticuare ai cuana dyaque jidaque etyatauque ihua. Tume tuna cabacaduratibarecuare tuna cama: —¿Juan ni taa ri Mesiasdya ejuu Yusuja Emepeque, aijama ni taa? —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Tume tuna Juanra dutya jadya acuare: —Era micuana utsaya ena tsehue, inime cacuaretihua jadique adebataqui juishu. Tsunutaya amatu peya junayaque. Tujatu dyaque casa aniya, ecue bucha ama. Tuque baatsu ique ni aishuquedya jutidya; mere puji tuja patrón tsehue beta tupu ama ejuu bucha jutidya ique. Tume junayara micuana Yusuja Espíritu tyanaya, tujaque jadique adebataqui juishu. Tuaqueja catyaticarama juya cuanaque tujatu nerecaturadadiya ijahuaja etiquiju. ");
INSERT INTO cavNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ecuita trigo iruru, tsaje jadya aishuque buchique tu Junayaque. Turatu tuja cuanaque nityasicuanabuque tunaja ishu cuita emajacaju, ecuita trigo etareju equiyatiu bucha. Tuja ama cuanaque bacuetu ijehuebuque nerecatura ishu etiqui ticu baecuaju, trigo tsaque epahuata bucha, —jadya tuna Juanra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jadya eque, peya umada cacuejati eque jadyatu Juanra cuejacuejanicuare ecuita cuana jida iyacuaque quisarati. ");
INSERT INTO cavNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Tumebaedya tujatu huaraji Herodes nereda bucha cuejae acuare, Herodías tuatsehuequi Felipeja ehuaneque tsehue baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodesratu cuejayaju bacacarama acuare. Tura cuejayaque bacataquiquetu dyaque jidama jutidya inime tupucuare. Etare apudaju jutidyatu Juan ishamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Etare apudaju ishatanama jariratu Juanra utsacuare jaridya umada tuaqueja jutiya cuanaque. Jesústu cuacuare tuaqueja cutsameretira. Tumetu Juanra Jesús utsacuaredya. Amena Jesús cutsameretitsu, Yusu tsehue quisaratiyajutu barepa pacashatanacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Bacuaretu Yusuja Espíritu huei jiuque tuque dyaque buteyaju. Tume tujatu barepa juque etsuri bacacuare. Yume tucuetu jucuare tuja Etataque Yusu. —Mique mique ecue Ebacua dyaque iyuhuedaque. Ique dyaque pureama juya miatsehue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Quimisha tunca maraquetu Jesús Yusuja quisarati bahuitya catibuticuare. Ecuita cuanaratu Joséja ebacuaque buchadya jutidya bacuare. José tu Elíja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí tu Matatja ebacuaque jucuare. Matat tu Levíja ebacuaque jucuare. Leví tu Melquija ebacuaque jucuare. Melqui tu Janaja ebacuaque jucuare. Jana tu Joséja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José tu Matatiasja ebacuaque jucuare. Matatías tu Amósja ebacuaque jucuare. Amós tu Nahúmja ebacuaque jucuare. Nahúm tu Eslija ebacuaque jucuare. Esli tu Nagaija ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tu Maatja ebacuaque jucuare. Maat tu Matatiasja ebacuaque jucuare. Matatías tu Semeija ebacuaque jucuare. Semei tu Josécja ebacuaque jucuare. Joséc tu Judája ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá tu Joanánja ebacuaque jucuare. Joanán tu Resaja ebacuaque jucuare. Resa tu Zorobabelja ebacuaque jucuare. Zorobabel tu Salatielja ebacuaque jucuare. Salatiel tu Nerija ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tu Melquija ebacuaque jucuare. Melqui tu Adija ebacuaque jucuare. Adi tu Cosamja ebacuaque jucuare. Cosam tu Elmadamja ebacuaque jucuare. Elmadam tu Erja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er tu Jesúsja ebacuaque jucuare. Jesús tu Eliezerja ebacuaque jucuare. Eliezer tu Jorimja ebacuaque jucuare. Jorim tu Matatja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat tu Levíja ebacuaque jucuare. Leví tu Simeónja ebacuaque jucuare. Simeón tu Judája ebacuaque jucuare. Judá tu Joséja ebacuaque jucuare. José tu Jonamja ebacuaque jucuare. Jonam tu Eliaquimja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim tu Meleaja ebacuaque jucuare. Melea tu Menaja ebacuaque jucuare. Mena tu Matataja ebacuaque jucuare. Matata tu Natánja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán tu Davidja ebacuaque jucuare. David tu Isaíja ebacuaque jucuare. Isaí tu Obedja ebacuaque jucuare. Obed tu Boozja ebacuaque jucuare. Booz tu Salaja ebacuaque jucuare. Sala tu Naasónja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón tu Aminadabja ebacuaque jucuare. Aminadab tu Adminja ebacuaque jucuare. Admin tu Arnija ebacuaque jucuare. Arni tu Esromja ebacuaque jucuare. Esrom tu Faresja ebacuaque jucuare. Fares tu Judája ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá tu Jacobja ebacuaque jucuare. Jacob tu Isaacja ebacuaque jucuare. Isaac tu Abrahamja ebacuaque jucuare. Abraham tu Taréja ebacuaque jucuare. Taré tu Nacorja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor tu Serugja ebacuaque jucuare. Serug tu Ragauja ebacuaque jucuare. Ragau tu Pelegja ebacuaque jucuare. Peleg tu Heberja ebacuaque jucuare. Heber tu Salaja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala tu Cainánja ebacuaque jucuare. Cainán tu Arfaxadja ebacuaque jucuare. Arfaxad tu Semja ebacuaque jucuare. Sem tu Noéja ebacuaque jucuare. Noé tu Lamecja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec tu Matusalénja ebacuaque jucuare. Matusalén tu Enocja ebacuaque jucuare. Enoc tu Jaredja ebacuaque jucuare. Jared tu Mahalaleelja ebacuaque jucuare. Mahalaleel tu Cainánja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán tu Enósja ebacuaque jucuare. Enós tu Setja ebacuaque jucuare. Set tu Adánja ebacuaque jucuare. Adán tu Yusuja ebacuaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tumetu Jesús, Yusuja Espiritura cuitadya aquereniyaque, cuacuare cueri Jordán emajaca queja amaca. Tuequedyatu Yusuja Espiritura dujucuare japada peya queja amaca anitaya amaju. ");
INSERT INTO cavNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Tuhuadyatu jucuare pushi tunca huecaca. Aramatu jucuare. Pushi tunca huecaca cuetihuajutu amena aracara jucuare. Satanasratu cajuchatishacara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jipetitsu tujatu Jesús acuare: —Yusuja Ebacuaquepa mique, jadyami juya. Jutaquiju riyaque tumu pan cacueyatishacue, —jadyatu Satanásra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusratu acuare: —¡Aama! ¡Aya ama tuque era! Ehuene tu Yusuja quisarati: “Earaqui tsehue jipidya amatu Yusura ecuita cuana anishaya. Tumebaedyatu Yusuja dutya cacuatsashati eque anitaqui”, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Tumetu Satanásra Jesús dujucuare emata dyaque barudaque matina. Tuequeradya tujatu yaratupu piji cuita bamerecuare dutya epu cuana riyaque yahua juque. ");
INSERT INTO cavNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","—Erami huaraji amereya dutya riyaque epu cuanaju. Tumeque epu cuana, dutya tuhua jidaque aniyaquetu ecuique. Era ejeque tyacara ayaque tuque tyaya. Etyau mique era dutya ai jidaque aniyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Mira ique chichucata juatsu muiyaju, dutya riya cuanaque tuque micue ejuu, —jadyatu Satanásra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesusratu acuare: —¡Aijama, Ijahua! ¡Micue yacuaju ique chichucata junime ama! Ehuene tu Yusuja quisarati: “Mique Cuatsashaquique Yusu camadya muicue. Tura cuatsashaya eque peadya camadya jucue”, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jadya juatsutu Satanásra Jesús Jerusalénju dujunucacuare. Dujutsu tujatu tsuraquerecuare Yusuja etare camahua barudaju. —Putitanacue reeque. Yuneridya ni mi Yusuja Ebacuaque, tumemi ujeda ecatiu ama, ");
INSERT INTO cavNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Yusuja quisarati jadya ehuene tibu: “Yusuratu cuadishaya barepa juque tuque tsahuaqui cuanaque mique naru ishu, ");
INSERT INTO cavNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","mique pacacayaju inatsa ishu, mique ni riya piji buchique ujeda cati ishu ama, tumura ehuachiju ujeda eauju” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesusratu acuare: —¡Aama! ¡Aya ama tuque era! Tumebaedya tu Yusuja quisarati ehuene: “Nime adebaume Yusu” jadya, —jadyatu Jesúsra Satanás acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesús datse cajuchatishacara aatsutu Satanásja inime terecuare. Tume tujatu jacacuare eje uma huecaca cuana. ");
INSERT INTO cavNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesústu dirunucacuare Galileaju. Yusuja Espirituratu jacacuare ama. Dutya tumeque emajacajutu ecuita cuanara Jesús cuatsabiji acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Dutya huecaca tujatu ecana bahuityacuare Yusuja quisarati caradati ishuque etare cuanaju. Cuejayaque bacatsu tunajatu pureama acuare: —¡Aijamatu peya ecuana jida bahuityaquique Jesús buchique! —jadya tuna jubarecuare tuna cama. ");
INSERT INTO cavNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesústu cuacuare Nazaretju tuque catemuticuareju. Tuhua jari tuputu canajara huecaca cuanaju cuacuanicuare caradati ishuque etareju, tuja bahue. Tuhua nubitsutu netitsuracuare, Yusuja quisarati jebuda isara ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Inamerecuare tunajatu quirica epirurique isara ishu Isaiasra quisarati cuejacuareque, Yusu equeque cuitadya beru huenetanacuareque. Quirica inatsa, pacasha jadya aatsutu Jesúsra dadicuare jadya ehueneque. Tume tujatu isaracuare etsuri jebuda tsehue: ");
INSERT INTO cavNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yusuratu tuja Espíritu eaqueja cuadishahua. Mepehua tura ique, tuja quisarati nerecada cuanaque cueja ishu. Cuadishahua tura ique, etare apudaju erisi netiya cuanaque inajacatanabuqueque cueja ishu, shuhui cuanaque capetatisha ishu, jidama ujeda ujeda ataya cuanaque tsahua ishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tura ique cuadishahua, Yusura amena ecuita cuana tuja jidaque bamereyaque huecaca amena juetihuaque cuejara”, jadya tu ehuene Yusuja quisarati. ");
INSERT INTO cavNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yusuja quisarati isarajacatsutu Jesúsra piruricuare quirica. Piruritsu tujatu tyacuare caradati ishuque etareju mere juyaque. Tumetu anibutecuare tuna cueja ishu. Dutya caradatihua cuanaratu pana peta acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Tura tuna cuejacuare: —Iyacua cuitadyari juhua riyaque ehueneque jadya judadiya jadya béru huenetanacuareque. Bacahuadya tuque micuanara, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dutya tuhua cuanaratu jida quisarati acuare Jesúsja ishu. Anajacatacuare tuna, tura jidaque quisarati cuejayaju. Cabacaduratibarecuare tuna: —Riyaque ri Joséja ebacuaque. ¿Eje bucha juatsu jatsutu dyaque jida quisaratiya? —jadya tuna jucuare tuna cama. ");
INSERT INTO cavNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Quisaraticuare jaritu Jesús: —Eratu adebaya micuanara inime tupuyaque. “Casamati puji, casamaticue mita taca. Ecuanaratu mira Capernaumju ai ni ejeque ecuitaja ataquique ama achineque bacatsachine. Rehua dyadi acuedya”, jadya tuque micuana inime tupuya. ");
INSERT INTO cavNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","“Era micuana jadya ayaqueri yunerique. Ni ejeque quisarati dyaque jida cuanaque cuejaquitu jida batsataya ama tuque catemuticuareju. ");
INSERT INTO cavNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Adebaya micuana ecuanaja yahua Israelju béru jucuareque, Elías Yusu equeque quisarati cuejaquique anicuare patyaque. Quimisha mara peya patya patya tuputu nei jucuare ama. Dyaque mije tuna jucuare dutya epu cuanaju. Anicuaretu umada Israelju eahuemaju cuanaque nerecada cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jadya ama buchatu Yusura Elías cuadishacuare ama ni ejeque buchique tuna tsahua ishu. Cuadishacuare tujatu peya yahua queja Sarepta epu bacaniju aniya queja. Tumeque eputu epu ebari Sidón japadama jucuare. Epuna eahuemajuque tuhua aniyaque tsahua ishu tujatu cuadishacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","“Micuanaratu adebayadya ecuanaja yahua Israelju junucacuareque, Eliseo Yusu equeque quisarati cuejaquique anicuare patyaque. Anicuaretu jetiama ujejeda cuanaque pusesera ririshaya cuanaque ecuanaja yahuaju. Jadya ama bucha ni ejeque buchique tujatu tuhuaque chachanecuare ama. Naamán camadyatu chachanecuare, peya yahua Siria bacaniju aniyaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jadya bacatsu tuna caradati ishuque etareju aniya cuanaque dyaque cahuaiticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Cahuaititsu ecana netitsuracuare. Cuinanashacuare tuna Jesús epu juque. Emata dyaquetu tumeque epu jucuare. Dujucuare tuna emata matina, tueque pacacashacara aatsu. Iyecara datse tuna acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jadya ama buchatu Jesús quinajacamereticuare. Quinajacameretitsutu tuna patya eque cuinanacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Judirunucacuaretu Jesús Capernaumju Galilea yahuaju. Canajara huecacajutu ecuita cuana bahuitya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Pureama tsehue tuna anajacatacuare tura bahuityayaque bacatsu, huaraji equisaratiu bucha quisaratie juya bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Anicuaretu tumeque etareju ecuita ijahua cuanara quijahuatishayaque. Tuque quijahuatishaquiquedya jutidyatu ecuita eque quiquecuare: ");
INSERT INTO cavNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¿Ai jitequemi jeya ecuana queja, Jesús Nazaret juque? ¿Ecuana aputasharami jeya? Adebaya mique ecuanara. Miquemi juchama. Yusu quejaquemi jehua, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesusratu tumeque ijahua nereda acuare: —¡Abacata jucue! ¡Iyacua cuita cuinanacue riyaque ecuita quejaque! —jadyatu Jesúsra acuare ijahua ecuita quijahuatishaquique. Jadya quisarati aatsutu ijahuara ecuita yahua catsaqui amerecuare dutya tuhua aniya cuanaja yacuaju. Tuque rihuishatsutu cuinanacuare tuaquejaque eje bucha ameretsu ama. ");
INSERT INTO cavNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Dutya tuque petaqui jucuare cuanaque tuna jecutanacuare. Cabacaduratibarecuare tuna: —¿Eje bucha quisaratietu Jesús jadya ejuu? Huaraji equisaratiu bucha rejari quisarati. Cacuatsashati casada tsehuetu tura cuatsashaya ijahua cuana. Tuna bacue tuequedya juya tura amereya equedya, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tumeque jadya jucuarequetu tsapetanacuare dutya tumeque yahuaju. Dutya tuna bahue jucuare Jesús jadya juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Tumetu Jesús israelita cuanaja caradati ishuque etare juque cuinanatsu nubidirucuare Simónja etareju. Simónja ehuanequeja ecuaquetu dyaquene cuita, baara juyaque jaracuare. Tumetu tuhua cuanaque Jesús queja canerecaticuare tuja chachane ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jadya bacatsutu Jesúsra jipeticuare. Jipetitsu tujatu peque netititsu petaticuare. Nereda tujatu baara acuare. Baara nereda aya tsehuedya cuitadyatu baara juyaque chacha jucuare. Tumetu netitsuratsu earaqui jucuare Jesús, tura mepehua cuanaque jadya mihua ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Amena ijeti nubihuajutu ecuita cuanara becuare Jesús queja ujejeda cuanaque umada ujeje tsehue cuanaque. Tume tujatu ecana iyucaju emetucu tsehue jababarecuare. Jadya chachanee tujatu ecana abarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Umae cuanatu ijahua cuanara quijahuatishayaque jucuare. Jesusratu ijahua cuana ijehuecuinacuare. Diruyaque tuna quiquecuare: —¡Miquemi Yusuja Ebacuaque! —jadya tuna jubarecuare quique eque. Jesusratu ijahua cuana nereda acuare. Quisaratishacarama tujatu ijahua cuana acuare, ecuita cuanara tuque Mesiasque eadebauju. ");
INSERT INTO cavNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Huecacanucatsutu Jesús cuinanacuare epu juque, peya queja amaca anitaya amaju. Ecuita cuanaratu sareticuare. Junaticuare tuna tuaqueja. Banatitsu tunajatu acuare: —Jesús, diruume. Ecuana tsehuedya rehua anicue, —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesúsra tuna acuare: —A, aijama eje bucha anitaqui ama rehua cabatiya. Cuataqui peya epu cuanaju jidaque quisarati cuejara. Cuejataqui tuque ecue tuhua cuanaque eje bucha narue ecana Yusura ayaque, jadya ishu ique cuadishatanacuare tibu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tumetu Jesús junenicuare Yusuja quisarati cueja juyaque caradati ishuque etare cuanaju dutya queja israelita cuana anitaya cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Juneniyaquedya jutidyatu Jesús netidirucuare Genesaret bacani bei jiruru. Ecuita cuanatu catiiticuare tuque peque, Yusuja quisarati baca juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bacuare tujatu beta cuaba memaque bei jiruru, jae puji cuana tunaja jae deru ishuque utsara cuinanahuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tumetu Jesús anibutecuare Simónja cuabaju. Anibutetsu tujatu Simón acuare: —Japajapa piji nejaca bei cuatsa. Tuequera tujatu ecana cuejatibunecuare mejijiju cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Amena quisaratijacatsu tujatu Simón cuejacuare: —Dujucue cuaba bei deda queja, —jadya tujatu Simón acuare. —Nemarecue micuanaja jae deru ishu cuanaque, —jadya tujatu ecana acuare tuhua cuabaju cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonratu acuare: —Ecuana Bahuityaquique, dutya meta datse ecuana jae deru jusisahua. Ahua ama tuque ecuana ni peadya jae. Jadya ama bucha mira cuatsashaya tibu, pamaretinuca ecuana jae deru ishu cuanaque, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jadya ayaju maretsu tunajatu acuare umada jae, amena tunaja jae deru ishu cuanaque jae bicuera chaja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Tume tunajatu peya cuabaju cuanaque eme ihuara acuare, tuna tsahuana ishu. Cuaatsu tunajatu jequeshacuare beta cuaba jae tsehue. Nudyajericuaretu cuaba ecatse jae bicuera. ");
INSERT INTO cavNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jadya baatsutu Simón Pedro nuyucuare Jesúsja yacuaju. —Japada jucue eaquejaque, Ecuana Cuatsashaquique. Ique ecuita juchaquique jutidya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Simón, tuatsehue juneniyaque ecatse Santiago, Juan, Zebedeoja ebacuaque ecatse, ejecutana tuna jucuare, jae jetiama baatsu. Tumebaedya peya cuana ejecutana jucuare. Tumetu Jesúsra cuejacuare Simón: —Cacasaticue. Miquemi jae puji. Iyacua mique ecuita cuana Yusu adeba mere ishuque amereya, —jadya tujatu Simón acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jaratsuratsu tunajatu shanaquenacuare tunaja cuaba ecatse. Dutya shanaquenatsu tuna Jesús tsehue junenitibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesús tumeque epuju junatihuajutu ecuita pusese sehuera rami ririshayaque juticuare. Jesús baatsutu tuja yacuaju chichucata jucuare ebutse quini tsehue yahua tseraya tupu, tuque muiyaque. Chichucata juatsu tujatu Jesús isaratsacuare: —Ique Cuatsashaquique, chachanecara aatsu taa mira ecue ujeje aniyaque echachaneu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Tura jadya ayajutu Jesúsra jabacuare. —Chachaneyadya mique era, —jadyatu Jesúsra acuare. Jadya aya tsunumeetu pusese aputacuare tuja ecuita juque. Chachadya tu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—Cuejacueja camadya aume ni ejequedya jutidya mique eje bucha chachae juhuaque. Aticue Moisésra amereya equedya. Riyata cuau cuitadya jucue pae queja, tuja mique pana adeba atsa ishu, “Chachadya rique” jadya tuja aishu. Cadujuticue Moisésra amerehua equedya riyaque ujeje chacha eju cuanaja Yusu tyabahueque. Jadya juatsutu ecuita cuana bahue juya mique amena chachaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Arepa Jesúsra cuejamerecarama ahua ama buchatu dutya queja tuque jadya juyaque quisarati tsapetanacuare. Jetiama ecuitatu caradaticuare Jesús quisaratiyaju baca ishu, tuja ujejeda cuanaque chachane ishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesústu eje uma cuau jubahue jucuare emajaca ecuita anitaya amaju, tuhua Yusu tsehue quisarati ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Peya huecaca Jesús tuhua bahuitya bahuityayajutu fariseo cuana anibarecuare, tumebaedya cacuatsashati bahuityaqui cuanaque. Tuna tuna jecuare dutya Galilea jiruruque, Judea juque, Jerusalén juque jadya. Yusuja casa tsehuetu Jesúsra chachanenicuare tuhua ujejeda cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tumetu junaticuare tuhua ecuita cuana ebadequi baeju ajebaecuaque duju juyaque. Datse tuna emajaca sarecuare ecuita jetiama ducu etareju nubicara juatsu, ajebaecuaque Jesúsja yacuaju huanacara aatsu datse. ");
INSERT INTO cavNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amena eje bucha nubitaqui ama cabatitsu, ecuita jetiama cuita baatsu, tuna tsuracuare ebarucue etare dyaque. Tsuratsu tunajatu eje uma teja bucha cuanaque huetsacuare etare camahua jepedaque. Huetsatsu tunajatu ajebaecuaque butyacuare ecuita jetiama ducu, Jesús netiya tuyu. ");
INSERT INTO cavNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ujejedaque dujuqui cuanara Jesúsra ajebaecuaque eajeshauque ejeneyaque adebatsu tujatu jadya ajebaecuaque acuare: —Micue jucha cuana tu amena eapupasha, tata —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jadya quisaratiyaju bacatsutu cacuatsashati bahuityaqui cuanara, fariseo cuanara jadya inime tupucuare: —¿Eje bucha juatsuri riyaque ecuita jadya quisaratiya? Yusu tujatu ijillahuanaya. ¡Ni ejeradya jutidyatu jucha cuana eapupashau, Yusura peadya camadya! —jadya tunajatu inime tupubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesústu bahuedya jucuare tunara eje bucha inime tupuyaque. —¿Eje bucha juatsu tuque micuana jadya inime tupuya: “Yusu tujatu ijillahuanaya” jadya? Jida ama tuque micuana inime tupuya. ");
INSERT INTO cavNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Era ni ajebaecuaque eau: “Micue jucha cuana tu eapupasha” jadya, eadebau ama tuque micuana ecue casa aniyaque, eapupasha, apupashama jadique ejitaju ama tibu. Era ni eau: “Netitsuracue. Piruricue micue jara ishuque. Ajecue”, tumeque ura cuitadya tuque micuana eadebau ecue casa aniyaque, ajebaecuaque juneniyaju baya tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tuque juneniya baatsu micuana bahue juya ecue tumebaedya riyaque yahuaju jucha cuana apupasha ishu casa aniyaque, —jadya tujatu ecana acuare. Tumetu Jesúsra acuare ajebaecuaque: —Netitsuracue. Piruricue micue jara ishuque. Dirucue micue etareju, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jadya ayaju cuitatu ecuita netitsuracuare. Tuja jara ishuque piruritsu, huesatsutu cuinanaquenacuare tuhuaque dutyara petayaju. Tumetu dirucuare tuja etareju Yusu pureama ayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Dutya tuna anajacatacuare. Pureama tuna Yusu acuare: —¡Dyaque jida, casada taa Yusu! Iyacua ecuana bahua dyaque bape ebarique, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jadya juu jadya juatsutu Jesús cuinanacuare epu juque. Tume tujatu ecuita bacuare Roma juque enaruquija ishu chipiru tsuje bacayaque juaniyaju. Tuquetu Leví bacani jucuare. Tunaja etsujequi sita ishu pequetu juanicuare. —Eatsehue junenicue, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jadya ahuajutu Leví netitsuraquenacuare. Dutya tujatu shanaquenacuare Jesús tsehue juneni ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jadya juatsutu Leví chine arida caticuare tuja etareju Jesús pureama aatsu. Tuhuatu jucuaredya enaruquija ishu chipiru tsuje bacaqui cuanaque, umae bijidamadurataya cuanaque jadya. Tudya tuna jetiama mesaju Jesús tsehue araaracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseo cuanara, tumebaedya cacuatsashati bahuityaqui cuanara jadyara tunajatu bacuare eje bucha juyaque. Jadya baatsu tuna quisaratitibunecuare Jesúsja ishu. Acuare tunajatu Jesúsra mepehua cuanaque: —Riyaque ecuita cuana ri bijidamadurataya cuanaque. Micuana micuana araarataqui ama, ijiijitaqui ama jadya enaruquija ishu chipiru tsuje sitaqui cuana tsehue, tumebaedya peya jucha arida cuana tsehue, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesúsra tuna quisaratiyaju bacacuare. —Chacha cuanaratu sareya ama casamati puji. Ujejeda cuanara camadyatu sareya. ");
INSERT INTO cavNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Juchama bucha cabatiya cuanaque sarera ama jehua. Ique jehua jucha arida cabatiya cuanaque jiteque, tuna inime cacuaretisha ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Umae ecuita cuanaratu Jesús bacaduracuare: —Juan tsehue juneniya cuanaqueri arama quibetiya Yusu muiyaque cabamereti ishu. Tumebaedya fariseo cuana tsehue juneniya cuanaque jadidya ecana juya. Yusamimi ecana tsunuda juya; arama quibetijacama ecana juya. Mira mepehua cuanaque bacue ecana araaraya, ijiijiya jadya juya. Arama ecana quibeti baecua. ¿Eje bucha juatsu? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","35","Jesúsra tuna quemitsacuare: —Caquemitiyaju cuaishu ecueja cuanaque tuna arama quibetiya ama caquemitihuaque tuna tsehueju. Tuna quejaque dujutanahuaju piisi tuna arama quibetiya. Tumebaedyatu ecue cuanaque ique cuanucahuaju piisidya tuna arama quibetiya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesúsra tuna bahuityayaque cuatsabiji eque cuejacuare: —Ni ejeratu camisa iyacuaque racaya, camisa siri eraca iyacua tsehue sipi ishu. Jadya ayaque juatsutu yuamaturatanaya camisa iyacuaque. Tumetu esipiquique iyacuaque beru tsehue beta tupu ama juya. ");
INSERT INTO cavNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tumebaedyatu ishataqui ama tupari sasana ishuque sura siri cuitaju. Tupari sasanayaratu epututashau sura siri. Tumetu eaputau sura, tupari jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jadya tibudyatu tupari sasana ishuque sura jida iyacuaju ishataqui. ");
INSERT INTO cavNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ni ejeratu tupari uqueuqueque ijicara aya, tupari sasadaque ijitsu, tupari sasadaquepa dyaque jida jadya juatsu, —jadya tujatu ecana acuare. (Riyaque cueja tsehue tuna Jesúsra bahuityacuare. Eje bucha anitaqui amatu beru inime israelita cuanara bahuityacuare eque, iyacuaque tura cuitadya bahuityaya eque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tume patyatu Jesús cueticuare euhua cuana eque canajara huecacaju. Aridatu trigo euhuaque jucuare ejahuane, amena racataqui. Jesúsra mepehua cuanaratu cuetiyaradya jutidya trigo esa sepitsu, irurutsu mucuajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Umae fariseo cuanara baatsu tunajatu ecana cuejacuare: —Moisésra cuatsashacuare eque ama micuana juya. Meredya micuana juya etsucaca cuana sepi, iruru, mucu jadya juyaque. Meretu jutabaecua canajara huecacaju, —jadya tunajatu ecana quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tuna jadya quisaratiyaju bacatsu tuna Jesúsra quemitsacuare: —Neadebacue ecuanaja ebaba David emuique jucuareque. Tuque, tuatsehue cuaya cuanaque jadya tuna aracara jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Davidtu Yusuja etareju nubicuare. Nubitsu tujatu Yusuja ishu eiyaque pan cuana inacuare. Inatsu tujatu aracuare. Tumebaedyatu tyacuare tuatsehue cuaya cuanaque. Arepa tuja, tuatsehue cuaya cuanaja jadya arataquima paju ama bucha tuna aracuare, pae cuanaja cuita camadya arataquique. Jadya ama buchatu Yusu cahuaitishacuare ama, tumeque pan aratsu. ");
INSERT INTO cavNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","“IQUE ECUITAjatu aniya cacuatsashati canajara huecacaju ai juishuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Canajara huecacajutu Jesús caradati ishuque etareju nubinucacuare. Catibuticuaretu bahuitya bahuitya. Tuhuatu jucuare ecuita jida equeque emetucu majuque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Cacuatsashati bahuityaqui cuanara, fariseo cuanara jadyatu Jesús jidama inime tupu tsehue petacuare. “Tura ni canajara huecacaju riyaque emetucu majuque chachaneya, tume tuque ecuana huaraji cuana queja cuejatiyadya”, jadya tunajatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesústu bahue jucuare eje bucha tunara inime tupuyaque. Tume tujatu isaracuare ecuita emetucu majuque: —Netitsuracue. Netinacue requeja tuna patya, —jadya tujatu acuare. Jadya ahuajutu netitsuracuare tumeque ecuita. Netitsuratsutu tuna patya netiticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Tumetu Jesúsra tuhua cuanaque bacaduracuare: —Bacaduraya micuana era. ¿Ecuanaja cacuatsashati eque canajara huecacaju tuque ecuanaja jidaque ataqui, jidamaque ni taa? ¿Ejeque majutaqui baatsu echachaneudya tuque ecuanara, “Pamaju” jadya ni taa ecuana eau? ¿Eje bucha micuana inime tupuya? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Tumetu Jesúsra petacuare dutya tuque tabuqui cuanaque. Tuna petatsutu anucacuare ecuita emetucu majuque: —Rirucue micue ebi, —jadya tujatu acuare. Jadya ayajutu ecuitara rirucuare ebi. Tura ebi riruya tsehuedya cuitadya tujatu emetucu chacha jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jadya juya baatsutu Jesús ujeu baqui cuanaque dyaque cahuaiticuare. Tuna cama tuna cacuejaticuare: —¿Eje bucha tuque ecuana eau Jesús iyemere ishu? —jadya tuna tuna cama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jadya juu jadya juatsutu Jesús tsuracuare emataju Yusu tsehue quisaratira. Peadya meta yutatu Yusu tsehue quisaratisisacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Huecacatsu tujatu tuaqueja ihuaracuare tuatsehue juneni ishu. Tume tujatu mepecuare peadya tunca beta earacana. —“Jesúsja Ecuadisha cuanaque” jadya bacani eque neadebatacue, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ebacaniju tujatu abarecuare: Simón (Jesúsra tujatu peya ebacani iyacuare “Pedro”.) Andrés (Simón tsehuequique) Santiago Juan Felipe Bartolomé ");
INSERT INTO cavNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo Tomás Santiago (Alfeoja ebacuaque) Simón (Tuque patu Roma juque enaruquique bijidamaduraqui juyaque jucuare.) ");
INSERT INTO cavNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas (Santiago tsehuequique) Judas Iscariote (Jesús inamerequi judadicuareque) Jadya tuna jucuare tura mepecuare cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesústu butecuare emata juque tuna tsehue. Tumetu netidirucuare uhua jepedaju tura mepehua cuana tsehue. Tumebaedya anicuare umada ecuita dutya quejaque Judeaju aniya cuanaque jecuareque, Jerusalén juque, dyaque japada cuanaque Tiro, Sidón jadya quejaque. Tume cuanaque tuna junacuare Jesús quisaratiyaque bacacara aatsu, tuja chachane ishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jesúsra tuna chachanecuare. Tumebaedya tujatu ijehuecuinacuare ijahua cuana umae ecuita cuana quijahuatishaqui juya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Dutya ecuitaratu Jesús jabacara acuare tuja unaju. Tuja una jabatsudya jutidya tuna chacha jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jadya juatsutu Jesúsra tura mepehua cuanaque petatsu acuare: —Dyaque jida micuana aniya. Arepa micuana nerecada juya ama bucha, Yusura micuana naruya, baya jadya aya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Dyaque jida micuana aniya. Arepa micuana iyacua aracara juya ama bucha, tupuju micuana tyatanabuque dutya micuanara ai sareya cuanaque, pana jeque juya tupu. “Dyaque jida micuana aniya. Arepa micuana iyacua peya inime juya ama bucha, tupuju micuana casaturatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Dyaque jida micuana aniya, arepa iyacua micuana Yusu jaque ama cuanara ujeu baya ama bucha, arepa tunara micuana caradati ishuque etare juque ijehueya ama bucha, arepa tunara micuana ijillahuanaya ama bucha, arepa tunara micuana bijidamaduraya ama bucha. Tunara micuana nerecaturaya, IQUE ECUITA queja catyatihua baatsu. Jadya ama bucha dyaque jida micuana aniya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jadya atayaju, dyaque pureama nejucue. Necanimehuallatiume, barepaju Yusura dyaque jidaque tyatsabuqueque adebatsu. Micuana camadya ama micuana jadya canerecatie juya. Jadya nerecaturaedyatu tunaja ebaba cuanaquera acuare béru Yusu equeque quisarati cuejaqui cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Nerecapane micuana, ecue ama cuanaque, chipiruda cuanaque! Riyaque yahuaju camadya micuana pureama juya; tupuju bacue aijama. ");
INSERT INTO cavNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Nerecapane micuana iyacua jetiama ai dyaque umada aniya cuanaque! Tupuju tuque micuanaja aijama jubuque. “¡Nerecapane micuana iyacua pureama juatsu tsaya cuanaque! Quique, pau pau micuana jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Nerecapane micuana! Dyaque jidama micuana nerecada jubuque, arepa iyacua dutyara jida micuanaja ishu quisarati aya ama bucha, tupuju bacue aijama. Micuanaja ishu camadya ama jadya jida quisaratie juya. Jadya jida quisaratiedyatu jucuare micuanaja baba cuana pusha pusha bahuityaqui cuanaja ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jesúsra tuna bahuityanucacuare: —Micuana ique bacaqui cuanaque micuana cuejaya. Iyuhueda nebacue micuana ujeu baqui cuanaque. Jida ecana nebacue. ");
INSERT INTO cavNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Micuana jidama quisarati tsehue aqui cuanaque jida nebacue. Yusu queja nebacabacacue micuana ijillahuana, jidama aqui cuanaja ishu. “Jida jucue ique ujeu, jidama jadya aqui cuana tsehue”, jadya Yusu neacue. ");
INSERT INTO cavNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ejera bahuapajayaque juatsu, peya ebahua eque necatimerenucacue. Ejera micuana chompa secayaque juatsu, netyacuedya micuanaja camisa. ");
INSERT INTO cavNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ejera ai bacayaquedya netyacue. Ejera micuana jaque ai secayaque juatsu, “Cuaretyau anucacue” jadya neaume. ");
INSERT INTO cavNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Peya cuana queja necabamereticue tunara eje bucha bacara aya eque. Jadya tibudya tuna dyadi jida tsehuedya nebacue. ");
INSERT INTO cavNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Micuanara ni micuana iyuhueda baqui cuanaque camadya iyuhueda baya, “Ecuana ecuana peya cuana bucha dyaque jida”, jadya micuanaja inime paju ama. Butsee jucha arida cuanaratu iyuhueda baya tuna iyuhueda baqui cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Micuana jida aqui cuanaque camadya ni micuana jida baya, “Ecuana ecuana peya cuana bucha dyaque jida”, jadya micuanaja inime paju ama. Butsee jucha arida cuanaratu tuna jida aqui cuanaque jida baya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Micuanara ni chipiru tyaya ejeque micuanara cuaretyau anucayaque adebayaque camadya, “Ecuana ecuana peya cuana dyaque jidaque”, jadya micuanaja inime paju ama. Butsee jucha arida cuanaquetu jadidya juya. Tunaratu jucha arida cuanaque tyayadya, tunara ecuarequi tyanucayaque adebatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iyuhueda nebacue micuana ujeu baqui cuanaque. Jida ecana nebacue. Netsahuacue ecana. Netyacue ecana ai tunara bacayaque, “Cuaretyau tura anucaya”, jadya juatsu ama. Jadya juatsu micuana Yusura dyaque jidaque tyadadibuque. Yusu tu dyaque jida, tuque yusurupai abaecua cuana tsehue, jidama cuana tsehue jadya. Micuanara ni ecana jida tsehue baya, tume micuana Yusu ebarucueja ebacua cuanaqueque ejitaju cabameretiya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jida tsehue nebacue ejequedya jutidya, micuanaja Tatara micuana jida tsehue baya bucha, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesúsra tuna bahuityanucacuare: —Micuanara ni peya jidama juyaque cuejaya, tume micuana Yusura eje bucha juyaque cuejayadya. Micuanara ni “Peya cuanatu inime metse” jadya aya ama, tume micuana Yusura “Inime metse” jadya ama aya. Micuana ni pana nime aputa juya peya cuanara jidama ayaque, tumetu Yusu micuana jidama juyaque pana nime aputadya juya. ");
INSERT INTO cavNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Netyacue peya cuana; Yusura dyadi micuana tyayadya. Inijeda nejuume tuna tsehue. Ijahue ecana neaume equiniqui pana jequesha ama tsehue. Nejequeshacue tunaja equiniqui. Pana jequesha neacue. Cuacha cuacha jequesha tii jadya tunaja shitara neacue. Pana jequesha tii ai nudyanucataquima neamerecue. Micuana ni peya cuana ai tyaishu inijeda juya, tumetu Yusu dyadi inijedadya juya micuana jidaque tyaishu. Micuanara ni tyacara tsehue tupuya ai tyayaque, tume micuana Yusura dyaque jidaque tyaajeyadya jutidya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesúsra tuna cuatsabiji cuejacuare tuna bahuityayaque: —¡Eje bucha jida caaquerenitie jatsutu ejuu beta tupu shuhuique ecatse! Tume taa tatse betadya caniju epacacadiruu. ");
INSERT INTO cavNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ejeque cabahuityatiyaque tu tuque bahuityaquique bucha dyaque bahuee ama. Tuque bahuityatayaque bahue juteretsu piisitu tuque bahuityaquique bahuee bucha ejudadiu. ");
INSERT INTO cavNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Micuanaja cuitadya yatucaju acui tibu ebari aniyaque juatsu, ¿eje bucha juatsu jatsu tuque micuana peyaja yatuca juque aijara piji quemicara aya? ");
INSERT INTO cavNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Micuanaja cuitadya yatucaju acui tibu aniyaque caadebatiyaque ama, ¿tume tuque micuana peya eje bucha juatsu jadya eau: “Aijara tuque micue yatucaju aniya. Paquemi micue era”, jadya eau? ¡Ebaupa, ai jadique micuana shuhuique buchique! Icuene micuana cuitadya yatuca juque acui tibu necaquemiticue. Caquemititsu tuque micuana ebau jida peyaja aijara yatuca juque quemi ishu, —jadya tuna Jesúsra acuare. (Riya tsehue tujatu ecana bahuityacuare: Neadebacue micuanaja jucha. Adebatsu neajacacue, peyaja ishu jidama quisaratimaque.) ");
INSERT INTO cavNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Acui jidajatu juya amadya ecaca jidama arataquimaque. Acui arataquimajatu juya amadya ecaca arataquique. ");
INSERT INTO cavNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Dutya acuitu adebataqui ecacaju. Acui cuijaquijutu higo ni uvaja ecaca juya ama. ");
INSERT INTO cavNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ecuita jidaquetu jidadya quisaratiya, jidaque inime tuja educuju aniya tibu. Ecuita jidamaque bacue jidama quisaratiya, jidamaque inime tuja educuju aniya tibu. Educuju ecuanaja inime tupu aniyaquedya tuque ecuanaja quisarati abahue —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesúsra tuna cuejanucacuare: —Ni eje bucha “Ecuana Cuatsashaquique” jadya ataqui ama micuanaja ique, ai micuana era amereya eque juya batu. ");
INSERT INTO cavNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cuejaya micuana riyaque cuatsabiji micuana huecasha ishu, ai bae eaqueja catyatitsu ecue quisarati bacaqui cuanaque jadique. ");
INSERT INTO cavNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","49","Anicuaretu beta ecuita etare caticuareque ecatse. Icueneratu deda purucuare. Puru jadya aatsu tujatu tumu ebari dyaque yahua pajidaju dudu cuana puchacuare. Jida deda tujatu puchacuare ni eje tupu bucucunuca ishu ama. Peya bacue mejijiju jutidya etare caticuare. Cueri pesitanatsutu ejuri casada tsehue etare ecatse catsaqui jucuare. Icueneque etare pujija eaque casada neticuare. Rihuicuare ama, dudu cuana yahua pajidaju casada epucha tibu. Peyara etare acuareque bacue rihuicuare, mejijiju jutidya dudu cuana epucha tibu. Pana aputatere jucuare. “Era bahuityayaque bacatsu era amereya eque juya cuanaque tuna yahua pajidaju etare caticuare buchique. Tuna tuna ni eje tupu yuamaturatana ishuque ama. Era amereya eque ama juya cuanaque bacue mejijiju etare caticuare buchique. Tuna tuna pana aputatere jubuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesústu ecuita cuana isaratilla amena aatsu, cuacuare peya epu Capernaum bacaniju. ");
INSERT INTO cavNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tuhuatu jucuare huaraji cien sudaru cuana cuatsashaquique Roma juque ecuadishaque. Anicuare tujatu mere puji dyaque iyuhuedaque. Tumeque tuque merequiquetu dyaque ujejeda majuhuie jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesúspa ujejeda cuanaque chachane juya jadya bacatsutu cien sudaru cuana cuatsashaquira ihuaracuare umae israelita cuana emuiba cuanaque. —Necuacue Jesús queja. Necuejaticue paje rehua. Pachachanenatu ique merequique, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tura jadya ahuaju tuna cuacuare Jesús queja. Tuque jipetitsu tuna tuaqueja canerecaticuare: —Nerecabacue taa ecuana. Chachaneticue cien sudaru cuana cuatsashaquija mere puji. Dyaquene cuita, majuhuie tuque. Nerecabacue taa sudaru cuanaja huaraji. Tuquetu dyaque jidaque. ");
INSERT INTO cavNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Arepa Roma juque ama ama bucha, dyaque iyuhueda tujatu baya ecuanaja ata israelita cuana. Turadya tuque ecuanaja amerecuare etare ecuana caradati ishuque rehua Capernaumju, —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Tunara jadya ayajutu cuacuare Jesús tuna tsehue. Jesús etare japadama juajeyaju tuna huarajira cuadishacuare tuja eadeba cuanaque Jesús cuejatsa ishu: —Jetaqui ama taa mi ecue etareju, Ique Cuatsashaquique. Ique israelita ama. Bahuedya ique micue cacuatsashati eque mique ecue etareju nubitaquique ama. ");
INSERT INTO cavNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Jadya tibudya mique tsurutsahua ama, ique mique buchique ama juya tibu. Nerecabacue ique. Mique eju netiya eque camadya cuatsashacue ique merequique ecue chacha juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ique ecue huaraji cuanara cuatsashayaju yana equedya jubahue. Era dyaditu sudaru cuana cuatsashayadya. Era ecue sudaru cuadishayaju, masadamadyatu cuaya. Peya ni era ihuaraya, masadamatu jeya. Era ni ecue mere puji “Acue jeeque” jadya aya, masadamadya tujatu aya. Ique bahuedya micue casa aniyaque ique merequique chachane ishu, —jadyatu huarajira cuejamerecuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jadya bacatsutu Jesúsra ecuita bape bacuare tuja quejeneti baatsu. Tibene huarere juatsu tujatu tuque tupuju cuaya cuanaque petacuare. —Riyaque Romajura taa dyaque ejene neri aya era tuja tuque merequique echachaneuque. Pusha amadya aijamatu ni ejeque ecue ata israelita ique dyaque ejenequique, —jadya tuna Jesúsra acuare. Tumetu Jesúsra tuequeradya jutidya chachanecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Amena etareju judirunucatsutu cuadishahua cuanara badirucuare huaraji merequique chacha juhuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jadya juatsutu Jesús cuacuare Naín bacani epuju. Tura mepehua cuanara, peya umada ecuita cuanara jadyatu tajiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Amena epu piji dyanetu Jesusra tsurutsacuare ecuita cuana ehue ebari emajuque tumu caniju ishati ishu duju juyaju. Tumeque emajuquetu epuna eahuemajuja peadyaque piji ebacuaque jucuare. Umada ecuita epu ebariju cuanaratu epuna tajiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesusratu eahuemajuque baatsu, nerecada bacuare. —Paume, mama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jipetsu tujatu emajura jara ishu ayaque jabatsacuare, emajuque dujuqui juya cuanaque nityatsa ishu. Jabatsayajutu emajuque duju juya cuanaque netinaticuare. —Anitsuracue, ehue ebari emajuque, —jadya tujatu acuare emajuque. ");
INSERT INTO cavNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jesúsra jadya ayajutu ehue ebari emajuque chacha junucacuare. Chacha juatsutu anitsuracuare. Quisaratitibunecuare. Chachanetsutu Jesúsra ehue ebarija ecuaque cuejacuare: —Jee micue bacua chacha juhua, mama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jadya baatsutu tuhua cuanaque anajacatacuare. Yusuja ishu tunajatu jida quisarati acuare: —¡Yusu equeque quisarati cuejaquiquetu ecuana tsehuedya aniya! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Dutya Judea yahuaju, peya epu japadama cuanaju aniya cuanaque jadya tuna bahue jucuare Jesúsra emajuque chacha nityatsuranucahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Ecuita Cuana Utsaquiratu bacatsacuare quisarati Jesús ai juyaque, emajuque tura chacha nityatsuranucahuaque. Juan tsehue juneniya cuanaratu cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jadya bacatsutu Juanra ihuaracuare beta tura mepehuaque ecatse, Jesús queja cuadisha ishu, tuque bacadurati ishu: —¿Midyami Mesías, Yusuja Emepeque rehua junataquique? ¿Ihuaya jari ni taa ecuana peya? —jadya tatse Juanra Jesús bacaduramerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanra cuadishahuaque ecatsetu junaticuare Jesús queja. Junatitsu tatsejatu anaticuare: —Juan Ecuita Cuana Utsaquira yatse cuadishahua rehua mique bacadurara. ¿Midyami Mesías, Yusuja Emepeque rehua junataquique? ¿Ihuaya jari ni taa ecuana peya? —jadya tatsejatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Tatse junatihuajutu Jesúsra chachanecuare umada ujejeda cuanaque, dyaque jidama ujeje cuana tsehue nerecada jucuare cuanaque. Chachanecuaretu ijahua cuanara quijahuatishaya cuanaque; tuna quejaque tujatu ijahua cuana ijehuecuinacuare. Umada shuhui cuanaquetu capetatishacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tume tatse Jesúsra quemitsacuare: —Metseratu bacahuadya era ai cuejayaque. Bahuadya metsera ique ujejeda cuanaque chachane juyaju. Dirunucatsu Juan necuejadirucue metsera bahuaque, bacahuaque jadya. Necuejacue era shuhui cuanaque capetatishayaque; rudurudu cuanaque rena jida ajeshaya; pusesera ririshaya cuanaque rena chachaneya, isahue cuanaque rena quijacabacatishaya; emaju cuanaque rena nityatsuranucaya; nerecada cuanaque rena Yusu queja judiru ishuque quisarati cuejaya. ");
INSERT INTO cavNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Dyaque jida paju ique dyaque adebaquique, eaqueja nimee jujacayaque ama jadya, —jadyatu Jesúsra Juan cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanra cuadishahuaque ecatse diruhuajutu Jesúsra cuejatibunecuare Juan eje buchique: —Jetiama micuana cuachine yachiju Juanra cuejayaque ijacabacara. ¿Ai tuque micuana batichine tuhua? Micuanaratu adebahuadya Juanra ejenecara, ejenecarama jadya ama Yusuja quisarati ahuaque. Shita cuejijira peya queja huanati, peya queja huanati eau bucha ama tuque. ");
INSERT INTO cavNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bacaduranucaya micuana era. ¿Eje buchique ecuita batiya bucha tuque micuanaja inime juchine? Bahuedya micuana, tuque ejutuqui jida piji tsehue ama ecajututique. Ejutuqui jida piji tsehue ecajututi cuanaque tuna chipiruda cuanaja, ecuari cuanaja etareju aniya. ");
INSERT INTO cavNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bacaduranucaya micuana era. ¿Ai bucha adebatsu tuque micuana batichine? ¿Yusu equeque cuitadya quisarati cuejaquique ni taa tuque micuana batichine? Pusha amadya, Juan tu Yusu equeque cuitadya quisarati cuejaquique. Yusuratu tuque mepecuare israelita cuana quisarati cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jadya tu Yusuja quisarati ehuene: “Cuadishabuque tuque mique cuadishama jariju ique merequique. Turatu ecuita cuana bajejebuque, tunaja mira quisarati cuejadadibuqueque bacatibune ishu”. Juan tu Yusuja quisarati cuejaquique. ");
INSERT INTO cavNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Riyaque micuana cuejaya. Juan Ecuita Cuana Utsaquiratu quisarati cuejahua dyaque saretanayaque, beru yuequedya quisarati cuejaqui cuanara cuejahua buchique ama. Jadya ama bucha iyacua ecue cuanara cuejayaque tu dyaque jidaque, Juanra cuejacuare buchique ama. Jadidya tuque, arepa micuanara ecue cuanaque jetiedya, aishuque ama jadya baya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Dutya jujeri ebijidamadura cuanaque Juanra quisarati cuejayaque bacatsu, tunajatu inime juticuare, Yusu yuneridya tuyuque. Butsee Roma juque enaruquija ishu chipiru tsuje bacaqui cuanaque tuna inime cacuareticuare. Tuna jadya juhuaju tuna Juanra utsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Fariseo cuanara, cacuatsashati bahuityaqui cuanara jadyara tunajatu bijidamaduracuare Yusura tunaja ishu eje bucha acara ayaque. Tuna tuna inime cacuareticuare ama; ni ecana Juanra utsacuare, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Tume tuna Jesúsra bahuityanucacuare: —¿Ai baetu iyacua aniya cuanaque? ¿Ai tsehue beta tupu jadya tuna eau? ");
INSERT INTO cavNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Tuna tuna peya cuanara cuejaya eque jucarama juya. Ebacua cuana ijahue juya bucha jutidya tuna, peya ebacua cuanara ijahue aquerecara ayaju ijahue jucarama juya bucha. “Yusura tuaqueja judiru ishuque quisarati cuejamereyaju bacatsu, pureama nejucue”, jadya ayaju bacatsu, tuna pureama jucarama juya. “Peya inime micuanaja jucha cuana aniyaque caadebatitsu nejucue”, jadya ayaju bacatsu, tuna peya inime jucarama juya. Ebacua cuana tuna tsehue tupu cuanara rauta duduyaju ijahue jucarama ejuu bucha tuna. Ebacua cuana tuna tsehue tupu cuanara peya inimeque jeru ayaju pacarama ejuu bucha tuna. ");
INSERT INTO cavNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Iyacua tunara yatse bijidamadurahua Juan, ique jadya. Juantu anicuare quibeti neri juyaque, ecuita cuana tsehue araara, ijiiji jadya juyaque ama. Tuque jadya juya baatsu tuque micuana ahua, tuquepa equijahuati jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tuequedya IQUE ECUITA junahua. Ique bacue earaqui ara, uva nacaca esasanashaque iji jadya juya ecuita cuana tsehue. Ique jadya baatsu micuanara “Dajicada, nijuqui arida” jadya aya. Iquepa ecuita cuanara bijidamaduraya cuanaja ecare; tumebaedya iquepa enaruquija ishu chipiru sitaqui cuana tsehue casitatiya, jadya micuanara aya. ");
INSERT INTO cavNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Era, Juanra jadya ayaque baatsutu ejitaju yatse betadya Yusura bahue amereya eque juyaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Fariseo Simón bacaniratu Jesús ihuaramerecuare araaraquere ishu. Jadya ahuajutu Jesús cuacuare tuja etareju. Junati jadya juatsutu anibutecuare araara ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tumetu epuna decadeca aridara tumeque epuju aniyara bacacuare Jesús fariseoja etareju araarara cuahua jadique. Jadya bahue juatsutu epuna cuacuare tumeque etareju. Dujucuare tujatu ijimedaque dyaque tsuje aridaque botilla alabastro eaju equinineque. ");
INSERT INTO cavNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nubinatitsutu Jesúsja ehuachi peque anibutetsu pacuare, Jesús muibayaque caadebamereti ishu. Payara tujatu paanacaca tsehue Jesúsja ehuachi nacatashacuare. Ehuachi paanacaca tsehue nacatashatsu, tujatu etsaru tsehue tillatsu rarashacuare. Huachi dyahua jadya tujatu acuare. Jadya aatsu tujatu etseri ijimedaque juracuare tuja ehuachiju. ");
INSERT INTO cavNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jadya juyajutu fariseora Jesús ihuaraqui juhuara bacuare. Jadya baatsu tujatu inime tupucuare: —Jesús ni tu Yusuja Ecuadishaque ama. Jadique juatsu taa tujatu eadebau tumeque epuna jidamaque. Tumebaedyatu eadebau tumeque epuna jida anieque ama, —jadya tujatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesusratu adebacuare Simónra eje bucha inime tupuyaque. —Simón, bacacue. Cuejacara mique aya, —jadyatu Jesúsra acuare. —Cuejacue taa ique, Ebahuityaquique, —jadyatu Simónra quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—Anicuaretu ecuita chipirudaque. Beta ecuitajatu manu anicuare tuaqueja. Peadyajatu manu dyaque umada anicuare —500 ficha cuana, peadya ecuitara beta mara mere juatsu etsujequi einau tupu. Peyaja bacue peya tsehue beta tupu ama jetiedya —50 ficha cuana camadya, peadya ecuitara beta badi mere juatsu etsujequi einau tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Betara tatsejatu tsujetyataqui ama bacuare tatseja manu. Jutaquijudyatu tatse manu inamerequira nerecabacuare tatseja manu. Jadya apupashaetu chipirudara acuare manu tatseja beta jadya. “Iyacua era mique bacadurayaque quemitsacue, Simón. ¿Ejera tatsejatu dyaque yusurupai, iyuhueda jadya baya manu apupashaquique? —jadyatu Jesúsra acuare Simón. ");
INSERT INTO cavNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Eratu manu dyaque jetiamaque apupashatanahuaque adebaya. —Tuyudya, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Tumetu Jesúsra huareretsu epuna petayara Simón cuejacuare: —Bahuadyami riyaque nerecadaque epuna. Ique micue etareju nubihuaju mira huachi utsamerehua ama mique merequi cuana queja, ecuanaja bahue eque. Jadya ama bucha riyaque epunara tuque ecue utsahua tuja paanacaca tsehue. Etsaru tsehue tuja tuque ecue tillahua. ");
INSERT INTO cavNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ni mira ique junayaju dyahuatsahua, ecuanaja bahue eque. Riyaque epunara taa junaya tajira dyahuahuaque dyahuajacaya ama ecue ehuachiju. ");
INSERT INTO cavNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni mira etseri tsehue iyucaju pepahua eihuara cuanaque eata bucha. Tura taa ecue ehuachi nacatashahua etseri ijimeda tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jadya mique cuejaya, Simón. Tura ique jadya ayaquetu cabameretihua tura ique dyaque iyuhueda bayaque, tuja jucha cuana jetiamaque apupashatanahuaque jadya. Ejeque riya piji jucha apupashatayaque bacue dyaque ama iyuhue cabameretiya, —jadya tujatu Simón acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Simón jadya aatsutu Jesúsra epuna isaracuare: —Era tuque micue apupashaya jucha cuana, mama. ");
INSERT INTO cavNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Peya cuana tuatsehue anibareya cuanaque tuna quisaraticuare tuna cama: —¿Eje bucha anie rejari ejuu inime jucha apupasha ishu? ");
INSERT INTO cavNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesusratu epuna acuare: —Yusurami amena inajacamerehua, mique eaqueja catyatihua tibu. Jida dirucue, mama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jesústu junenicuare jetiama epu cuanaju, epu achaacha cuanaju, Yusura tuaqueja catyatiya cuanaque eje bucha narue ayaque jadya cuanaque cueja juyaque. Peadya tunca beta earacana tura mepehua cuanaratu tajitajinicuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Icuenetu Jesúsja echachanedya jucuare umae epuna ijahua cuanara quijahuatishaya cuanaque, ujejeda cuanaque jadya. Quimisha epuna jadya chachae jucuare cuanaratu tajicuaredya. Jucuare tuna: María, Magdalaju anicuareque (Tujadyatu pacarucu ijahua Jesúsra ijehuecuinacuare.); ");
INSERT INTO cavNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juana, Chuzaja ehuaneque, (Chuzatu Herodesja etareju mayuruma jucuare.); tumebaedya Susana. Jetiama umae epuna cuanaratu tajicuaredya. Tunaja ai aniya cuana tsehue piji tsahua jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tuhuapa Jesús jadya bacatsu tuna jetiama epu cuana juque cuinanabarecuare Jesús queja cuaishu. Casitatihuaju tuna Jesúsra bahuityacuare cuatsabiji eque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Anicuaretu ecuita. Cuacuaretu tuja teeju uhuauhuara. Tura uhuaajeyaquetu umae pacacacuare edijiju, yahua pajidaju. Uhuayaque tujatu etsucaca huirucuare yahuaju. Tueque ajeya cuanaratu tapapashacuare. Upati huiri cuanaratu anibutetsu mucutillacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Peya etsucaca cuanatu pacacacuare yahua macana dedamaju. Huijatsutu danecuare ama. Raracuare jutidyatu euhuaque ehuija cuanaque, tuja etiri yahua nacadaju ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Umae bacue pacacacuare acui tiri, acuija jadya jetiama ducu. Acuija cuana danetsu tujatu trigo euhuaque ehuija cuanaque iyetillacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Umae etsucaca cuanatu pacacacuare yahua jidaju. Cacacaticuare umada. Tee mere pujiratu jetiama huesacuare tuhua euhuaque. Peadya peadya esajutu jucuare cien tsucaca. Jadyatu jucuare teeju euhua cuanaque, —jadyatu Jesús jucuare. Tumeque quisarati cueja amena aatsu tuna Jesúsra acuare: —Quijacabacati aqui juatsu, nebacacue, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tumetu Jesús tura mepehua cuanara bacaduracuare: —¿Eje buchique ri riyaque cuatsabiji? ¿Ai mira ecuana bahuityacara aya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—Yusura micuana pana adebamere acara aya tura tuja cuanaque naruyaju eje bucha juyaque. Peya cuana jadya cuejae eauque, tuna cuatsabiji cuana eque jutidya cuejaya jari, tunara era bahuityayaque pana adeba eauju. Tunaratu era ayaque baya. Tume tuna baatsu bama jiu juya. Bacatsu tuna bahuityahua ama jiu juya, arepa bacahua ama bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesúsra tuna bahuityanucacuare: —Pana cueja micuana aya uhuauhua puji cuatsabiji equeque eje buchique. Etsucaca euhua cuanaquetu Yusuja quisarati jadique. ");
INSERT INTO cavNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Umaetu Yusuja quisarati bacatsu masadama nime aputaya, Satanásra masadama pana nime aputashamere aya tibu. Jadya tibudya tuna Yusu queja catyatiya ama; Yusura tuna Ijahua quejaque inajacamereya ama. Tuna tuna yahua pajidaque buchique. ");
INSERT INTO cavNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Umaeratu ejetsunue ishu ama pureama tsehue Yusuja quisarati bacaya. Quisarati ejenehua baatsu jidama atayaju, masadama tuna ejenejacaya, pana adeba aya ama tibu. Tuna tuna yahua macana dedamaque buchique. Huijahua cuanaquetu macana quini danetsu tsunuda ama juya, etiri dedama tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Umaera Yusuja quisarati bacaya cuanaratu ejenejacaya, riyaque yahuaju cuanaquedya jutidya dyaque inime tsapequi aya tibu. Tunajatu inime juya, chipiru anitsu cuita camadya dyaque pureama ejuu bucha. Dutya tuna tunaja bijida cuanaque camadya inime tupuqui aya. Jadya juatsu tuna Yusu muijacaya. Tuna tuna yahua acuija quinique buchique. ");
INSERT INTO cavNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Umae cuana Yusuja quisarati bacaqui juya cuanaratu adebaajeyadya jutidya. Nime aputaya ama ecana. Tuna eje bucha anieju tuna ejitaju Yusuja biji eque aniyaque. Umae cuana tunajatu tsahuaya eaqueja catyati ishu. Tunadya tuna yahua jidaque buchique, esaju jetiama etsucaca cacacatihuaque buchique, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesúsra tuna bahuityanucacuare: —Ude tuchatsu tuque ecuana tehuaya ama eperere emaque ni ishaya ama sura ducu. Etehuauque tuque ecuana iyaya ebarucue, nubitiya cuanaja jida capetati ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Dutya etehuaquetu ejitaju judadiya. Dutya ibedaquetu adebataqui judadiya. Yusura micuana bahue ameredadiya eje bucha jue tujaque juishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Pana baca neacue era cuejayaque. Ejeja ai aniyajatu dyaquedya ai aniajeya. Ejeque ai aniya bucha cabatiyaque, aimaquedya jutidya, tuja aniya cabatiyaque tujatu aputatereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesúsja ecuaque, tuatsehuequi cuanaque jadya tuna junaticuare tuaqueja. Jipetaqui ama tunajatu bacuare, tuhua jetiama ecuita jucuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tumetu ejera cuana Jesús cuejaticuare: —Micue cuaa, micue miatsehuequi cuanaque jadya rena etsecueju. Miatsehuepa tuna quisaraticara juya, —jadya tujatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jadya bacatsutu Jesúsra acuare: —Tumeque epuna tuque ecue ecuaa; tume cuanaque tuna ecue eatsehuequi cuanaque. Jadya ama bucha tuque ecue aniya peya ecue iyuhueda cuanaque. Yusuja quisarati bacatsu tueque juya cuanaque tuna tuque ecue iyuhueda cuanaque. Tunadya tuna ecue ecuaa, ecue eatsehuequi cuanaque bucha bae ayaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Peya huecacatu Jesúsra acuare tura mepehua cuanaque cuabaju anibutetsu: —Bei yueque macare necarequetira, —jadya tujatu ecana acuare. Jadya juatsu tuna carequeticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Carequetiyaquetu Jesús tahuicuare. Tuque tahuijarayajutu muya jutidya cuejipa casadaque jueticuare. Cuejipa juetitsutu ena pacura cuaba ebariju ena ishacuare. Jadya tibutu ena pacura cuaba nudyajeri nudyajeri acuare. Rumutanaya bucha tuna cabaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jadya cabatitsutu tura mepehua cuanara Jesús bushishaticuare. —¡Ecuana Naruquique, rumutanaya ecuana! ¡Ena pacura ecuana nudyaya! —jadya tunajatu acuare quique eque. Tunara jadya ayajutu Jesús cabaticuare. Netitsuratsu tujatu acuare cuejipa, ena pacu jadya: —¡Tume tupu camadya! ¡Neticue! —jadya tujatu acuare. Tura jadya aya tsehuedyatu cuejipa neticuare. Dutyatu pana abacatana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jadya juatsutu Jesúsra acuare tura mepehua cuanaque: —¿Eje bucha juatsu micuana bajida cuita juhua? ¿Eje bucha juatsu micuana eatsehue nime aputahua? Tuna bacue dyaque eanajacata jucuare. Bajida ecana jucuare. Tuna taca tuna jadya jutibunecuare: —¡Ai ecuita dyadi ri riyaque! ¡Cuejipa, ena pacu jadya taa tuja yana equedya juya! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Chamacama tuna jaratsuradirucuare Gerasaju aniya cuana queja, bei yueque macare, Galilea tuyu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amena Jesús cuaba juque cuinanayajutu ecuitara jipeticuare, epu japadama dyane eanisirira. Tuquetu equijahuatique jucuare. Junenicuaretu tarema, ecatacati jadya. Anianinicuaretu tumu cani cuanaju emaju cuanaque eishaju. ");
INSERT INTO cavNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Tumetu Jesús baatsu, tuque jipetitsu chichucata jucuare tuja yacuaju. Jadya ayajutu Jesúsra ijahua cuana ecuita yuamaturaqui juya cuanaque acuare: —Necuinanacue tumeque ecuita quejaque, ijahua cuana, —jadya tujatu ecana acuare. Tsunudatu ijahua cuanara tumeque ecuita quijahuatishajacama acuare. Naru ishutu ecuita cuanara eje uma risi datse abahue jucuare ehuachiju, ebi ecatseju jadya cadena tsehue. Ijahua cuanaja casa tsehue tujatu cadena metal eaque tibibishajacama acuare. Ijahua cuanaratu aquerenicuare eje queja anitaya ama cuana queja japada. Jesúsra ijahua cuana tuaquejaque cuinana ishu cuatsashahuajutu ecuita quiquecuare: —¿Ai jitequemi jeya eaqueja, Jesús Yusu barepajuja Ebacuaque? Nerecabacue ique. Nerecaturaume taa ique, —jadyatu equijahuatira Jesús acuare jebuda quique eque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jadya quiqueyajutu Jesúsra bacaduracuare ecuita: —¿Ai bacani mique? —Ique Umadaque bacani, —jadyatu ijahua cuana caquemitsaticuare ecuitaja quisarati eque. Jadya tuna jucuare, tuna dyaque umada tuque quijahuatishaqui cuanaque juhua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—Cuadishaume ecuana emajaca ebariju ijahua cuana nerecaturatanayaju, —jadyatu ijahua cuanara acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jetiamatu cuchi cuana araaranibarecuare emata jiruru. Ijahua cuanaratu Jesús acuare: —Panubi ecuana cuchi cuanaju, —jadya tunajatu acuare Jesús. —Nenubicue taa. ");
INSERT INTO cavNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tumetu ijahua cuanara quijahuatishajacacuare tumeque ecuita. Tuaquejaque cuinanatsu tuna cuchi cuanaju nubibarecuare. Dutya cuchi cuana ijahuaqui cuanaque tuna tsajajayaque pacacadirucuare bei tihuesu baruda eque. Beiju pacacatsu tuna huiditerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuchi cuana naru juya cuanaratu bacuare jadya juyaju. Jadya baatsu tuna tsajajaterecuare epu ebariju. Cuetiyara tunajatu epu cuana juque cuejabarecuare tuhua eje bucha juhuaque. Epu ebariju judirutsu tunajatu tumeque quisarati nucadya tsapedirunucacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Tunara cuejayaque bacatsutu ecuita cuana cuabarecuare eje bucha juhuaque petara. Junaticuare tuna Jesús queja. Tuhua junatitsu tunajatu banaticuare ecuita equijahuati juhuaque, Jesús peque juaniyaju. Ecajututi, tuja jida inime tsehue, equijahuatijaca jadya tunajatu banaticuare. Jadya banatitsu tuna dyaque cuita eanajacata jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jesúsra equijahuatija ijahua cuana ijehuecuinayaju baqui jucuare cuanaratu peya cuana cuejacuare eje bucha juhuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jadya bacatsutu dutya jujeri Gerasa yahuaju aniya cuanara Jesús muda bacuare. Jadya tibudya tunajatu acuare: —Dirucue rehuaque. Tunara jadya ayajutu Jesús anibutecuare cuabaju, dirunucacara juatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Cuabaju anibuteyajutu equijahuatijacara Jesús acuare: —Ique miatsehue junenicara juya, —jadya tujatu acuare. —Aijama. Rehuadya anicue. ");
INSERT INTO cavNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Dirunucacue micue ata cuana queja. Cuejadirucue ecana Yusura micue ishu dutya ahua cuanaque, —jadyatu Jesúsra acuare. Tura jadya ahuajutu ecuita dirucuare. Dirutsu tujatu ecana cuejaajecuare dutya tuja epuju cuanaque, tuque Jesúsra eje bucha ahua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús bei yueque macare judiruhuajutu ecuita cuanara jida pureama tsehue batsacuare. Dutyara tunajatu ihuacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jesús tuna tsehue quisaratiyajutu ecuita Jairo bacanira jipeticuare. Tuquetu caradati ishuque etare juque inime metseque jucuare. Jipetitsutu nuyunaticuare Jesúja yacuaju. Nuyutsutu canerecaticuare Jesús queja tuja etareju cuaishu: ");
INSERT INTO cavNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","—Nerecabacue ique. Ecue ebacujuna peadya tunca beta earacana maraquetu majuhuie cuita. Tuque peadya piji cuita camadya tuque ecue ebacujuna. Chachaneticue ecue, —jadya tujatu Jesús acuare. Jesús cuayaju baatsutu umada ecuitara tupujudya acuare. Naiishacuare tunaja tuque. ");
INSERT INTO cavNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tumeque ecuita cuana ducudyatu jucuare epuna ujejedaque. Peadya tunca beta earacana maratu amena nerecada, ujejeda jucuare. Ebacuatare tujatu jidama jucuare; ami tujatu jucuaredya jutidya. Eje uma casamati bahue cuana quejatu casamamereticuare datse. Dutya tuja chipiru aniyaquetu quijehuetillaticuare casamameretiyaque. Jadya ama buchatu ni ejeradya jutidya chachanecuare ama. ");
INSERT INTO cavNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Etibene eque jipeaje tujatu Jesús acuare. Jipetitsu tujatu jabacuare tuja unaju ebebacuaju ehuejitaque. Tura jabaya tsehuedya tujatu neticuare ami. ");
INSERT INTO cavNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jabahuajutu Jesúsra bacaduracuare: —¿Aira jabahua? Dutya tuque peque cuanaquetu —Juhua aba, —jadya jucuare. Jadya juyajutu Pedrora acuare: —Ecuana Bahuityaquique, jeedya bacuemi ecuita cuanara naiishaya. ¿Eje bucha juatsu mira ecuana bacaduraya aira jabahuaque?, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—Ejera cuana jabahua chacha juishu. Ecue casa chachane ishuque cuinanayaju caadebatihua. Ejeque cuana tuque chachanehua, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Amena epunatu tuque jadya juhuaque tehuataqui ama baatsu, tadadayaque Jesúsja yacuaju chichucata juticuare. Dutya tuhua ecuita cuanaja ijacaju tujatu Jesús isaracuare: —Erami jabahua. Micue una jabatsu chacha ejuuque tuque ecue inime juhua. Tume taa jadiquedya. Micue una jabaya tsehuedya cuitadya chacha juhua, —jadyatu epunara Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—Mama, chachami juhua, mira era chachaneyaque pana ejene ahua tibu. Cacasaticue. Inime tsapema dirucue, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Tuque quisaratiya jarijudyatu yana dujuquique juticuare Jairoja etare juque. —Micue bacujunatu amena majuhua. Ai jiteque ni tu Ebahuityaquique cuama amena, —jadya tujatu Jairo acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jadya juya bacatsutu Jesúsra jadya acuare Jairo: —Jidama inime baume. Cacasaticue. Eaqueja nimee camadya jucue. Micue bacujuna emajuquetu chacha netitsuranucaya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Etareju junatitsutu Jesúsra acuare Pedro, Santiago, Juan jadya; —Micuana camadya eatsehue nenubicue. Tuhuadya umae paneti, —jadya tujatu ecana acuare. Nubiquerecuare tujatu ebacujuna pijija etataque ecatse, quimisha tura mepehua cuanaque jadya camadya. ");
INSERT INTO cavNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Dutya ecuita cuana bacue quique, pau pau jucuare ebacujuna piji majuhuaja etareju. —Nepajacacue. Tumeque ebacujuna piji tu majuma. Tahuiya jutidya tuque, —jadya tuna Jesúsra anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jadya bacatsutu ecuita cuanara ijaribacuare, tunara yuneri cuitadya emaju baya tibu. Ecanajetijacatu ebacujuna piji jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Tuque emaju jarayaju nubitsutu Jesúsra emetucuju inanaticuare. Isaranaticuaretu emajuque: —Ebacujuna piji, netitsuracue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Tura jadya ayaju cuitatu ebacujuna piji canajetietinucatsu, anitsuratsu netitsuracuare. Jesusratu ecuaque ecatse jadya acuare: —Nemihuacue. ");
INSERT INTO cavNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Tuja etataque ecatsetu tahuiju bucha cabaticuare. —Cueja cueja neaume ni ejeque riya jadya juhuaque, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesúsra tuna sitacuare peadya tunca beta earacana tura mepehua cuanaque. —Ijahua cuana ijehuecuina ishu micuana tyaya casa. Tumebaedya micuana cuatsashaya ejeque ujeje, eje bucha ujeje tsehue cuanaque chachane ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Cuadishaya micuana, Yusura naruyaju eje buchique quisarati tsape ishu, ujejeda cuanaque chachane ishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","“Yusuja quisarati cuejara cuayaque necadujutiume ni ai buchique. Necadujutiume sari, ni shitara ni ara ishu cuanaque ni chipiru. Asicada juatsu catacati ishu jutu ishuque necadujutiume. ");
INSERT INTO cavNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ejeque epuju junatitsu ejera jida batsayaju tuhuadya neanicue, tuja etareju peya epuju dirunucaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Eju junatiyaju tunara micuana batsacarama ayaju, masadama necuinanacue tuhuaque. Cuinanayaque neitataquenacue muru micuanaja ehuachi juque ‘Aine yatse micuana tsehue juma’ jadya tuna ayaque. Tunadya tuna inime metse, Yusuja quisarati bacacarama ahua tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jadya ahuaju tuna cuacuare. Cuacuare tuna dutya epu achacha cuanaju. Yusuja quisarati cueja juyaque, ujejeda cuanaque chachane jadya tuna epu cuanaju juajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ecuari Herodesratu bacacuare Jesús ai juyaqe, eje bucha juyaque jadya. Turatu bape bape jutidya inime tupucuare Jesús tsehue. Umaetu jucuare: “Jesústu baya ecuita ama. Juan Ecuita Cuana Utsaquique emajuque cacuitatitsu netitsuranucachineque tume” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Peya cuana bacue jucuare: “Elías ecacuitatique jutidya tume”. Peya cuana bacue jucuare: “Jesústu beru Yusu equeque quisarati cuejaquique jutidya, emajuque enetitsuranucaque”. Jadya bacatsatsutu Herodesra eje bucha adebataqui ama bacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","—Ique taa dyaque bahue Juan emajuque. Eradyatu pititubumerechine. ¿Ejeque ecuita jatsu dyadi tu Jesús? Bacaya taa quisarati ejenetaquique ama, —jadyatu Herodes jucuare. Bacara ebari tujatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jidaque quisarati cuejara cuadishatanacuare cuanaque juetitsu tunajatu cuejaeticuare Jesús tuna eje bucha jutihua cuanaque. Jadya juatsu tujatu ecana dujucuare peya queja amaca Betsaida epu japadama, tuna canajarasha ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tuna cuahuaque bahue juatsutu ecuita cuana cuacuare tuna sarera. Jesusratu batsacuare ecuita cuana tuaqueja jutihuaju. Cuejacuare tujatu ecana Yusura eje bucha narue ecuana adadiyaque. Chachanecuaretu ujejeda cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Amena ijeti nubihuietu peadya tunca beta earacana tura mepehua cuanara Jesús jipeticuare. —Isaracue ecuita cuana. Padiru ecana epu cuanaju, epu ashaasha japadama cuanaju. Pacabacatidiru ecana ara ishu cuanaque, eju tahui ishuque jadya. Rehuari aijama earaqui ni ai buchique tunaja ishu, —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—Cuadishaya ama tuna era. Micuanaradya ecana nemihuacue, —jadya tuna Jesúsra acuare. —Rehua rique ecuanaja aniya pishica pan, beta jae jadya piji camadya. ¿Ai tsehue ni rique ecuana mihuama ecuita jetieque ama? Dutya ecuitaja ishu tupu ejuuque juatsu, camadya ecuana ecuau earaqui bacara, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Deca cuana cuita camadya epiyebaque tuna jucuare pishica mil ecuita. —Jaquetsu jaquetsu ecana neiyabutyabarecue; peadya cuare pishica tunca, peya cuareju pishica tunca nucadya jadya ecana neiyabutyacue, —jadyatu Jesúsra acuare tura mepehua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cuejaya equedya tuna jucuare. Dutya tunajatu ecuita cuana iyabutyacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jadya juatsutu Jesúsra inacuare pishica pan, beta jae jadya. Inatsu tujatu barepaju Yusu aniya queja petacuare. Petayaquetu jucuare: —Yusurupai mique aya, Tata, mira ecuana riyaque ara ishuque tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai au jadya aatsu tujatu pan cuana cuesibarecuare. Jadya aatsu tujatu tyabarecuare tura mepehua cuanaque, tunaja ecuita cuana tyabare ishu. Tura ecana pan tyabareya tupu tujatu pan umanashacuare. Dutyaja ishutu tupu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Dutya tuna araaracuare, pana jeque juya tupu. Amena jadya juhuajutu Jesúsra mepehua cuanara jequeshacuare peadya tunca beta earacana jiti arida cuanaque pan tunara arabishahua cuana tsehue, jae jadya tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Peya huecacatu Jesús cuacuare peya queja amaca Yusu tsehue quisaratira. Tura mepehua cuanaque bacue tuatsehuedya jucuare. Etataque tsehue quisarati amena juatsutu Jesúsra tura mepehua cuanaque bacaduracuare: —¿Eje buchatu ecuita cuanara ecue ishu inime tupuya? ¿Ai jadya tunara aya? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tunaratu quemitsacuare: —Umae cuanarami aya Juan Ecuita Cuana Utsaquique emajuque enetitsuranucaque jadya. Peya cuanarami Elías jadya aya. Peya cuanara bacuemi aya beru Yusu equeque quisarati cuejaqui emajuque enetitsuranucaque jadya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—¿Micuanara bacue, ique ai jadya aya? —Miquemi Mesías, Yusuja Emepeque, —jadyatu Pedrora quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—Necuejaume jari ni ejeque buchique ique Mesiasque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesúsra tuna cuejanucacuare: —IQUE ECUITA dyaque canerecatitaqui. Emuiba cuanara, pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadya dyaque nerecaturadadiya. Iyemeredadiya tunara ique. Quimisha huecaca juatsu chacha netitsuranucaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jadya juatsu tuna dutya tuhua jucuare cuanaque Jesúsra isaracuare: —Micuana eatsehue junenicara juyaque juatsu, era cuatsashaya eque neanicue, micuanaja biji eque juneniyaque nime aputatsu, arepa micuana canerecati, maju jadya jutaqui ama bucha, curusuju etata ejuu bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Micuana ni catehuatiya eaqueja ecatyatique eiyetauju, ejetsunue ama micuana anibuque. Tume micuana majubuque ni eje tupu Yusu queja judiru ishu ama. Micuana ni eaqueja catyatihua baatsu iyetaya, Yusu tsehue micuana anisiribuque, arepa micuanaja ecuita ririya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ecuita ni Yusu jipema, ijahuaja etiquiju ni judiruya, ni aishu buchique tujatu jida juhua riyaque yahuaju tuja dutya ai anihuaque, arepa dyaque chipiruda paju ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Iyacua riyaque yahuajutu aniya ique eje buchique quisarati aishu bisuya cuanaque. Tunajatu bisu aniya ecue quisarati cueja ishu. Ejeque huecaca IQUE ECUITA junanucabuque. Barepaju Yusu tsahuaqui cuanara tajibebuque. Ique junanucayajutu dutyara babuque ecue Etataja casa. Bisunabuquedya ique ecue ishu bisuhua cuana tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Pusha amadya micuana cuejaya. Umae micuana rehuaque majuhuishaya ama, dutya era ecue casa tsehue narutibuneyaque badadiya tupu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jadya juu jadya juatsutu peadya semana junucatsu Jesús tsuracuare emataju Yusu tsehue quisaratira. Dujucuare tujatu Pedro, Santiago, Juan jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yusu tsehue quisaratiyaque tujatu ebutsequini cabapeticuare. Tuja unatu pajada, huecada, dyaque tiquida jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Masadaque amatu Moisés yanume, Elías yanume jadya ejitaju jucuare hueca dyaque tiquida ducu. Tume tatse Jesús tsehue quisaratinacuare. Jesús eje bucha iyetanae Jerusalénju judadiyaque tunajatu quisarati acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro ecanatu tahui idutaquima baatsu tahuicuaredya. Cabatietitsu tunajatu bacuare Jesús hueca tiquidaja edunu, beta ecuita ecatse tuatsehue netiyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Amena Moisés, Elías jadya Jesús quejaque japacuinaajeyajutu Pedro quisaraticuare: —Ecuana Bahuityaquique, dyaque jida taa ecuana rehua. Eau tuque ecuana quimisha erere, peadya micue ishu, peya Moisésja ishu, peya bacue Eliasja ishu, —jadya tujatu acuare. Tuque dyaque jecutanahua tibutu ai quisarati ataqui ama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro quisaratiyajutu barepa juque huanira dunutillacuare. Huanira dunutillaya baatsutu Pedro ecana eanajacata jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tume tunajatu bacacuare huani ducuque Yusu jadya quisaratiyaju: —Riyaque rique ecue ebacua dyaque iyuhuedaque. Nebacajacaume. Eje bucha tura cuejaya eque nejucue, —jadya tuna Yusura acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jadya quisaratijacahuaju tunajatu banucacuare ama Moisés, Elías jadya, Jesús camadya. Tunaratu ni ejeque buchique cuejacuare ama tunara eje bucha bahuaque. Jesús barepaju diruhuaju piisi tunajatu cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Huecacanucatsutu Jesús, tuatsehue cuahua cuanaque jadya butecuare emata juque. Butehuajutu ecuita jetiera ama tsurutsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Tuna ducuratu Jesús jipeticuare. Jesús jipetitsu tujatu acuare: —Nerecabacue ique. Riya ecue ebacua behua. Peadyaque piji ri rique ecue. Ijehuecuinacue ecue ebacua juque ijahua cuana. ");
INSERT INTO cavNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mididatu amena ijahuara quijahuatishayaque. Quiqueshatilla bahue reja rique. Piririshatilla bahue tuja tuque. Manutu jubahue. Ubajasa tujatu jubahue ecuatsa eque. Ijahuara tuque ecue ebacua dyaque yuamaturaya. Casatilla, nerecatura quijahuatisha jadya aatsutu chamacama cuinana bahue ijahua ebacua piji quejaque. ");
INSERT INTO cavNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Canerecatihua datse ique mira mepehua cuana queja, ijahua ijehuecuinamere ishu datse. Arepa ijehuecuinacara aya ama bucha, tuna ijehuecuinataquima bahua, —jadyatu ebacua pijija etataquera Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jadya bacatsutu Jesúsra tuhua cuanaque acuare: —¡Micuana micuana quejeneti baecua, cuejataqui ama jadya! Arepa micuana era ayaju bahua ama bucha, adebaya ama jaridya tuque micuana Yusuja casa. ¿Eje tupu cuita micuana eiduu? —jadya tujatu ecana acuare. —Becue requeja micue bacua, —jadyatu Jesúsra acuare ebacua pijija etataque. ");
INSERT INTO cavNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ebacua pijira Jesús jipeajeyajutu ijahuara manu amerenucacuare. Tume tujatu yahua catsaqui amerenucacuare. Jesusratu nereda acuare ijahua ebacua piji yuamaturaqui juyaque: —Cuinanacue riyaque ebacua piji quejaque, —jadya tujatu acuare ijahua. Jadya quisarati aya tsehuedya cuitadyatu ebacua piji quijahuatijacacuare. Quijahuatishajacatsutu Jesúsra ebacua pijija etataque cuejacuare: —Jee micue bacua equijahuatijaca juhua, tata, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Anajacatacuare tuna tuhua jucuare cuanaque. —¡Dyaque jida, casada jadya taa Yusu! —jadya tuna jucuare. Dutya tuhua cuanaque Jesúsra aya cuanaque baatsu eanajacata jarijudyatu Jesúsra anucacuare tura mepehua cuanaque: ");
INSERT INTO cavNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Nebacacue jida era cuejayaju. Nenime aputaume bacue. Ejera cuana tsetatsu inameredadiya IQUE ECUITA, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Tura mepehua cuanaratu adebacuare ama eje buchique tura jadya ayaque. Arepa quisarati bacaya ama bucha, tunajatu eje bucha adebataqui ama bacuare, Yusuja adebamerema jari tibu. Tuna tuna bajida jucuare, “Pana cueja ecuana acue mira quisarati ahuaque”, jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Tumetu Jesúsra mepehua cuanaque caquemitsati caquemitsati jutibunecuare: —¿Ejeque ecuana dyaque inime metseque?, —jadya tuna cabacaduratibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesusratu adebacuaredya tunara eje bucha inime tupuyaque. Tume tujatu ihuaracuare ebacua piji tuhua netiya baatsu. Ihuaratsu tujatu tuque peque nityacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jadya aatsu tujatu tura mepehua cuanaque cuejacuare: —Dyaque inime metsequetu dyaque jetiedyaque bucha cabatiyaque. Micuanara ni ecue cuanaque jida tsehue batsaya, arepa tuna riyaque ebacua piji bucha paju ama bucha, idya datse micuanara jida tsehue batsaya. Micuanara ni ique jida tsehue batsaya, tume tuque micuana ecue Etata Ique Cuadishaquique jidadya batsaya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juantu quisaraticuare Jesús tsehue: —Ecuana Bahuityaquique, ecuana micue quisarati cuejara cuachine patya, tuque ecuana bachine ejeque cuana ijahua cuana micue ebacaniju ijehuecuina juyaju. Jadya baatsu tuque ecuana achine: “‘Jesúsja ebacaniju rique ijahua ijehuecuinaya’ jadya ajacacue, ai mi Jesúsra mepehuaque batu”, —jadyatu Juanra Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jadya ahuajutu Jesúsra acuare: —Jadya neaume. Ecuana iyuhueda baquira ecuana ujeu baya ama, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Eje uma huecaca ama Yusu queja dirunuca ishuque aniyajutu Jesús tuja casada inime tsehue cuacara ebari jucuare Jerusalénju, arepa tuhua tuque canerecatiyaque bahue juya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Amena cuita cuahuiera tujatu cuadishacuare icueneta umae ecuita cuana eju junatiyaque etare banati ishu. Tuna tuna cuaatsu, junaticuare Samaria yahua epuju. Cuacuare tuna Jesús, tuatsehue cuaya cuanaque jadya eju junati ishuque sarera. ");
INSERT INTO cavNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Tumeque epuju cuanaratu icuene cuahua cuanaque jadya atsacuare: —Nudyatsaya ama tuque ecuana Jesús, ni tuatsehue cuaya cuanaque, micuana Jerusalénju cuaya tibu, —jadya tunajatu ecana atsacuare, Samariaju cuanara israelita cuana ujeu baya tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Icuene cuahua cuanaque tuna yudijidya dirunuca jucuare Jesús tsurutsa ishu. Tsurutsatsu tunajatu cuejatsacuare tumeque epuju cuanara nudyatsacarama ayaque. Juan, Santiago ecatseratu bacacuare tunara cuejaetiyaju. Jadya bacatsu tatse jadya jucuare: —¿Miratu bijida baya ecuana Yusu queja bacabaca ishu, tuja barepa juque etiqui butya ishu, tumeque epuju cuanaque iyetillamere ishu, beru Elías etiqui barepa juque butyamere ishu, Yusu queja bacabacacuare bucha? —jadya tatsejatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jadya juyaju tatse Jesúsra nereda acuare: ");
INSERT INTO cavNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","—Jadya nequisaratiume. Micuana micuana baecua jari eje bucha juatsu ique riyaque yahuaju jehuaque. IQUE ECUITA jehua aniya cuanaque anishara, tuna iyetillara ama, —jadya tujatu ecatse acuare. Jadya juatsu tuna dirucuare peya epuju. ");
INSERT INTO cavNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tuna ediji eque cuayajutu peadya ecuita quisaraticuare: —Ebahuityaquique, ique junenicara juya miatsehue eju mique cuayaju, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—Dyaque masada tuque. Equique chapa cuanajatu aniya cani; upati cuanaja bacue eja. IQUE ECUITAja bacue aijama etare tahui ishuque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Peya tujatu jadya acuare: —Eatsehue junenicue, eje queja ique cuayaju. —Ecuatsashaquique, icuene tuque ecue etata narutaqui tuque majuya tupu. Tuque majuhuaju, papatsu piisi miatsehue juneniya. Ihuacue jari ique, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—A, aijama. Iyacuadya eatsehue junenicue. Cuejaticue ecana dutya queja aniya cuanaque Yusura eje bucha narue adadiyaque. Ique adebaya ama cuanaque tuna emaju cuanaque bucha. Tunara inime tsapequi paa ai riyaque yahuaju cuanaque, emaju cuanaque papaya tupu. Peyatu mere aniya micue ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Peyaratu Jesús acuare: —Ecuatsashaquique, ique miatsehue pajuneni. Icuene ecue etareju cuanaque paisarati jari, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—A, aijama. Cashanaticue micue ai beru anicuareque. Ejeque paruparuyaque catibene bajiyuyijsvsysjs ama mere tu jidama. Tumebaedya ni mi Yusu mereya micue ai aniya cuanaque cashanaticarama tsehue, ni mi aishudya jutidya jida. —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jadya juatsutu Ecuana Cuatsashaquira mepenucacuare peya cuana pacarucu tunca beta earacana ecuita. Cuadishacuare tujatu ecana beta beta cama icuene dutya epu arida cuanaju, epu achaacha cuanaju, eju tuque cuataqui epu cuanaju. Cuadishacuare tujatu ecana tuna quihuatiyaju tuque juti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—Yusuja quisarati bacama cuanaque tuna trigo amena ejahuaneque buchique. Arepa ecana jetiama aniya jari ama bucha, eje uma ama tu quisarati tsapequi cuanaque, tee metsera mere puji cuana trigo racara ecuadishau bucha. Jadya tibudya nebacacue Yusu; pacuadishatu jetiama ecue quisarati cuejaqui cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Necuacue ecue quisarati cuejara. Micuana micuana muda majutaqui inime cuanaju nubi ishuque. Cuadishaya micuana era, uhuisha cuana iba cuana ducu ecuadishau bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","“Necadujutiume chipiru ni shurumai. Zapato jutuyaque cuita camadya necadujuticue. Dutya micuanara sareyaquedya micuana tyataya. Tsunuda cuita nenetiume ejeque edijiju isaratsayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ejeque etareju ni micuana nubiya, jadya ecana neisaranaticue: “Yusura inime tsapema neamerecue. ");
INSERT INTO cavNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tuhua ni aniya jida jucara juya cuanaque, tume ecana jida inime tsapema paju, micuanara isaranatihua baedya. Jadya ama ni, tume ecana tuna eje bucha anicara juya equedya paani. ");
INSERT INTO cavNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Icueneque etareju tunara jida batsayaque neaninaticue. Nearacue, neijicue tunara tyayaquedya. Nebisuume earaqui tunara tyayaque ara ishu, mere puji tsujetyataqui juya tibu. Nenubinubiniume etare cuana tupu, ani ishuque sare juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ejeque epuju junatitsu, ecuita cuanara ni micuana jida batsaya, nearacue tunara tyayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Nechachanecue tuhuaque ujejeda cuanaque. ‘Iyacua Yusura nenarucue’ jadya ecana necuejacue tumeque epuju aniya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ejeque epuju junatitsu, tuhuaque ecuita cuanara ni micuana jidama batsaya, necuinanacue tumeque epu juque. Tumeque epu patya eque cuetiyaque ecana jadya neacue tuhua aniya cuanaque: ");
INSERT INTO cavNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Jeeque epu juque muru ecuanaja ehuachiju badehuaque tuque ecuana itataya, “Aine yatse micuana tsehue juma” jadique. Nenime aputaume riyaque. Ecuanara micuana cuejahua micuana Yusu queja catyatitsu eje bucha judirue Yusu queja juishuque. Micuanadya micuana inime metse, Yusuja quisarati bacacarama ahua tibu’ jadya ecana neacue tumeque epu juque cuinanayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Tere huecaca juetihuaju tuna Yusura dyaque nerecaturabuque tuja quisarati bacacarama juya cuanaque. Sodomaju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha tuna tumeque huecaca juetihuaju dyaque ama canerecatibuque, micuanara quisarati cuejayaque bacacarama ahua cuanaque bucha ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jadya quisarati amena aatsutu Jesúsra quisarati acuare tuja quisarati bijidamadurahua cuanaja ishu. Tuna cuitadya baatsu quisarati aya buchatu jucuare, arepa tuna tuhua aijama jucuare ama bucha: —¡Dyaque nerecada micuana jubuque, micuana Corazínju, Betsaidaju jadya aniya cuanaque! Tiro, Sidón jadyaju anicuare cuanaque tuna dyaque jidama jucuare. Jadya ama bucha, baquena ni tuna juquena juhua Yusuja casa era micuana iyacua bamereyaque, cacuaretiquena tuna inime juquena jucuare. Jutuquena tunajatu jucuare ejutuqui sehuedaque, ai tiru, muru tsehue iyucaju casehueti jadya, inime cacuaretihua jadya ata ishu. Micuana micuana cacuaretihua ama inime, arepa era Yusuja casa tsehuedya ayaju bahua ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Riyaque micuana cuejaya. Ejeque huecaca Yusura jidama cuanaque nerecaturadadiyaju, tura micuana dyaque nerecaturabuque; Tiroju, Sidónju cuanaque jucuare dyaque tura micuana nerecaturabuque. Micuanajatu aniya emajaca ecue casa baishu. Tunaja baishuque aijama jucuare tibu, micuana tuna bucha dyaque micuana nerecada jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Micuana Capernaumju aniya cuanaque, jida bucha datse micuana cabatiya. Dyaque inime metseque bucha datse micuana cabatiya. Barepaju etsurashatau bucha datse micuana cabatiya. Ijahuaja etiquiju jutidya micuana nudyatabuque, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesusratu isaranucacuare tuja cuanaque ecuadisha cuanaque: —Micuanara cuejayaju bacaqui juya cuanaratu era cuejayaque bacayadya. Micuana bijidamaduraqui juya cuanara idya bijidamaduraya. Ique bijidamaduraqui juya cuanara Ique Cuadishaquique dyadi tunajatu bijidamadurayadya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yusuja quisarati cuejatitsutu juetinucacuare pacarucu tunca beta earacana cuadishatacuare cuanaque pureama tsehue. —Atichine ecuana mira amerechineque, Ecuana Cuatsashaquique. Ijahua cuanara ecuana muibachine, ecuanara tuna micue ebacaniju ijehuecuinayaju, —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesúsra tuna acuare: —Jejee, bahuedya ique ecue dyaque casa aniyaque, Satanásja casa bacue ecue bucha ama. Bacuaredya tuque Yusuja yacua juque pupipupiya bucha pacacae juyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Era micuana casa tyachine ni ejeque eju nerecada juishu ama, ni micuana bacuaja ni ajipaja ujeda aishu ama, tumebaedya micuanaja Satanás dyaque ijahue aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pureama nejucue, ijahua cuana ijehuecuina ishuque casa aniya cabatitsu jipidya ama. Dyaque pureama nejucue, micuana Yusu queja judiruya cabatitsu, micuanaja ebacani Yusuja quiricaju ehuene cabatitsu. ");
INSERT INTO cavNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tumeque quisarati ayaju cuitatu Jesús Yusuja Espiritura pureama amerecuare. Jadya tibutu Jesús Yusu tsehue quisaraticuare: —Tata, miquemi barepa, yahua jadya metseque. Bahue, inimequi bucha cabatiya cuana queja ecabameretiuquemi, mique eje buchique adebacara, bahue jucara ebari juya cuana queja cabameretihua. Yusurupai mique aya, mique jadya juhua tibu. Jadidyatu juya, mira jadya amerehua tibu, Tata, —jadya tujatu Yusu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jadya juatsu tujatu isaranucacuare tuhua cuanaque: —Ecue Etatara ique mepehua tuque cuarequi rehua ecuita cuana ejitaju amere ishu. Ecue Etatara peadya camadya ique pana adeba aya. Ique tuja Ebacuaque. Era cuita camadya tuque ecue Etata pana adeba aya. Tumebaedyatu adebaya era adebamerehua cuanara, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tume tujatu tura mepehua cuanaque quisarati cuejacuare: —Dyaque jida paju micuanara era ecue casa tsehue ayaju tunaja yatuca tsehue petaqui cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Neadebacue riyaque. Beru yuequedya tu Yusu equeque quisarati cuejaqui cuanara, tumebaedya ecuari cuanara jadya bacara ebari acuare ecue casa micuanara iyacua bayaque. Bacacara ebari tuna acuare ecue quisarati iyacua micuanara bacayaque. Jadya ama bucha tunaja anihua ama emajaca baishu ni baca ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jadyatu cacuatsashati bahuityaquira jipetitsu acuare Jesús, tuque nime adeba ishu. —Ebahuityaquique, ¿eje bucha ique ejuu, Yusu queja judiru ishu ni eje tupu tuque jaca ishu ama? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesusratu quemitsacuare: —Micuetu eisaradya Yusuja quisarati. ¿Eje buchatu cacuatsashati ehuene tuhua? ");
INSERT INTO cavNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—Yusujatu cacuatsashati jadya: “Iyuhueda bacue ducuta Yusu Mique Cuatsashaquique. Yusu iyuhueda bacue ducuta; dutya micue cabijiseriti tsehue Yusu pureamaturacue, dutya micue casa tsehue, dutya micue inime tupu tsehue”. Tumebaedya tu ehuene: “Iyuhue tsehue bacue peya cuana. Mique cuitadya iyuhueda cabatiya bucha iyuhuee peya bacue”, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—Jidadyami caquemitsatihua. Mique caquemitsatihua eque ni mi eaniu, Yusu quejami judirubuque ni eje tupu jaca ishu ama, —jadyatu Jesusra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cacuatsashati bahuityaquiratu peya cuana queja jida cabamereti ishu, Jesús bacaduracuare: —¿Ejeque rique ecue peya cuana iyuhueda baishuque? —jadya tujatu acuare, tuja ata cuana camadya inime tupuqui ayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesusratu riyaque cuatsabiji cuejacuare tuque quemitsayaque: —Peadya ecuitatu ehuachi eque cuacuare Jerusalén juque Jericóju. Israelita tu jucuare. Tuque cuayajutu chiri puji cuanara inatsacuare. Miririshacuare tunaja tuque. Secacuare tunajatu chipiru tuque cadujutiyaque. Iyejeri jadya aatsu tunajatu ediji jiruru huanatsu shanacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Tuequedya pae cuacuare tumeque ediji eque nucadya. Turatu bacuare ecuita ediji jiruru jujarayaju. Ujeda eaque baya ama buchatu barenaticuare jutidya tumeque israelita ujeda eaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Tumebaedyatu junatinucacuare pae cuana tsahuaquique. Turatu tumebaedya banatinucacuare ecuita ujeda eaque. Baya ama buchatu barenucacuaredya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Jadya juatsutu junatinucacuare ecuita Samaria juque, tumeque ediji eque nucadya. Bacuare tujatu ujeda eaque ediji jiruru jarayaju. Arepa israelita cuanara Samariaju aniya cuanaque bijidamaduraya ama buchatu Samariajura nerecabacuare ujeda eaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jipeticuaretu ujeda eaque. Jipetitsu tujatu ujeda eaque etseri tsehue tedi, sama jadya acuare. Tuque jadya samatsu tujatu querecuare tuja ujeda eaque. Masadama tujatu tura mula isaanibeyaju iyatsuracuare. Tuque iyatsuratsutu cuanucacuare. Tura cuitadya mula icuene nitya aajecuare ecuita dujuyaque. Nudyadirucuaretu etare tarepe puji cuana tahui ishuju. Tuhuatu ecuita Samariajura narusisacuare ujeda eaque. ");
INSERT INTO cavNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Huecacatsu diruyaratu ecuita Samariajura quemicuare beta chipiru tsuje aridaque tuja shurumai juque. Tumeque chipiru quemitsu, tujatu tsujetyacuare etare metseque. ‘Narucue jida jeeque ecuita. Riyaque chipiru ni ri tupu ama, juetinucatsu mique tsujetya tillaetiya’ jadya tujatu acuare. Jadya tsahuaetu Samariajura israelita ujeda eaque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cuatsabiji cuejatilla amena aatsutu Jesúsra bacaduracuare cacuatsashati bahuityaquique: —¿Ejeratu ecuita ujeda eaque iyuhue queticuare? —jadya tujatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—Tuque nerecabaquira, —jadyatu quemitsacuare ecuitara. Tumetu Jesúsra jadya acuare: —Jutaquiju mique tumebaedya jucue. Canerecabati tsehue peya cuana bacue, arepa micue ata ama paju ama bucha, —jadyatu Jesusra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús, tura mepehua cuanaque jadya tuna cuaquenanucacuare Jerusalénju. Ediji eque cuayaque tuna junaticuare epu achaachaju Jerusalén japadama. Junatihuajutu epuna Marta bacanira jida batsacuare, tuja etareju nudyatsatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tumeque epunajatu anicuare tuatsehuequique tupujuque María bacani. Marta ai juyaque etsahuauquetu ejanaque Jesús peque jutidya anibutecuare tuque quisaratiyaju ijacabaca. ");
INSERT INTO cavNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martaratu jidama inime bacuare, mere jetiama ataquique aniya baatsu. Tumetu Martara Jesús jipetitsu jadya aticuare: —Ecuana Cuatsashaquique, ¿miratu jidama ama inime baya ecue ejana tuhua mique quisaratiyaque ijacabacaani, ique bacue casada mere jadya juyaju? Tueque cuejacue; paje, patsahuana tura ique, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tudyatu Jesúsra quemitsacuare: —Miquemi cuji cuita juya, Marta. Miratu dyaque inime tupuqui cuita aya micue mere, Yusuja quisarati ama. ");
INSERT INTO cavNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Yusu jaque peadya camadya micue inime tupuqui ataquique, Mariara inime tupuqui aya bucha. Tuquetu nime aputaya ama tura ijacabacayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jesústu Yusu tsehue quisaraticuare peya queja amaca. Quisaratijacahuajutu peadya tura mepehuara isaracuare: —Bahuityacue ecuana Yusu tsehue eje bucha quisaratie juishuque. Juanra tura mepehua cuanaque bahuityahua bucha bahuityae ecuana acue, Ecuana Cuatsashaquique, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—Yusu tsehue quisaratiyaque, jadya neacue: “Ecuanaja Etata barepaju aniyaque, muiba ishuque mique. Adebaya mique ecuana juchama nerique. Pajuetihuisha huecaca micue ecuana naru ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Tyacue ecuana riyaque huecaca ara ishuque ecuanara sareyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Apupashacue ecuanaja jucha cuana. Ecuana peya cuanara jidama ayaque nime aputaya bucha, jadidya ecuanaja ecuana jidama juya cuanaque apupashacue. Satanásra cajuchatishacara ayaju, ecuana tsahuacue, ecuana ecajuchatiuju”, jadya neacue Yusu tsehue quisaratiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Tumebaedya tujatu ecana cuatsabiji cuejacuare, Yusu ai bacatsu bacajaca ishuque ama. —Ita taa mi micue ataja etareju meta patya ejutiu. Etsecue equemi etare metseque eisaratiu: “Nerecabacue ique. ¿Etyau ama mira quimisha pan? ");
INSERT INTO cavNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ecue eadebaquetu junahua ecue etareju. Aijama ecue ai tsehue batsa ishuque. Tuque mihua ishu mique bacaya”, jadya tuquemi eatiu. ");
INSERT INTO cavNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jadya mira bacayajumi micue atara equemitsau educu equera: “Aijama. ¿Eje bucha juatsu jatsumi meta patya jeya? Amena taa tuque etare yahuehua. Amena ecuana ecue ebacua cuana tsehue jarahua; canajaraya ecuana. Amena eje bucha netitsurataqui ama”, jadya turami eau. ");
INSERT INTO cavNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cuejaya mique riyaque. Bacajacaya ama ni mira, netitsurayadya tuque, mira ai bacayaque tyaishu. Mira ai sareyaque turami tyayadya, mira bacajacahua ama tibu, ai mique tuja ata baatsu ama. ");
INSERT INTO cavNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Cuejaya micuana era. Nebacabacajacaume Yusu queja. Tyayadya tura micuana. Nebacajacaume ai sareyaque. Yusura micuana dadimereya. Canimehuallatima neihuacue micuanara ai Yusu bacahuaque tura tyaya tupu. Etareju nubicara juatsu etare metsera pacashaya tupu eihuau bucha ihuae neacue. ");
INSERT INTO cavNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ejera bacajacayaque ama tujatu tyayadya. Ejera sareyaratu dadiyadya. Ejera canimehuallatima ihuayaratu bayadya tura bacahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Mira bayara pan bacayaju ni taa mi tumu jutidya etyau ara ishu? ¿Mira bayara jae bacayaju ni taa mi bacua jutidya etyau ara ishu? ");
INSERT INTO cavNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Eca bacayaju ni taa mi etyau ajipa jutidya ara ishu?. ¡Ni ejeque etataqueratu tura bayaque jadya eau ama! ");
INSERT INTO cavNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Butsee micuana jidamaradya tuque micuana micuanara baya cuanaque jidaque tyaya. Yutsumadya Yusu barepajura tuja Espíritu micuanara bacayaju cuadishayadya, —jadyatu Jesúsra tura mepehua cuanaque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesusratu ijehuecuinacuare ijahua ecuita quisarati baecua amerequique. Ijahua cuinanahuajutu ecuita quisaraticuare. Tuhua cuanaquetu anajacatacuare quisaratiya bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Umae cuanatu jucuare: —Beelzebú, ijahua cuana cuatsashaquique tu tuatsehue. Jadya tibudya tujatu casa aniya ijahua cuana ijehuecuina ishu, —jadya tuna jucuare. (Beelzebú taa tu Satanás bacani nucadya.) ");
INSERT INTO cavNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Peya cuanaratu sarecuare eje bucha eque Jesús jidama aishu. Tume tunajatu acuare: —Acue ecuanaja yacuaju ai bapeque inimeradya jutidya Yusuja peadya camadya ataquique, micue casa Yusu barepajuja aniyaque ecuana bahue juishu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesusratu adebacuare tunara eje bucha inime tupuyaque. —Jadique juatsu taa tu Satanás tuta tacadya jutidya pana cayuamaturati ejuu. Ita taa nebacacue. Yahuaju dutya aniya cuanaque ni ecajaquetibareu cuarepe cuarepe tuna cama cati ishu, tuna camadya jutidya tuna ecatillatiu. Peadya etaretu pana rihuishatanatere ejuu. Dutya tumu etare enityatsuraquetu yahuaju tere ejuu. ");
INSERT INTO cavNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Era ni Satanásja casa tsehue ijahua cuana eijehuecuinau, tume taa tu Satanás tuja cuana tsehuedya jutidya ecatiu. Tumetu ni ejeque ijahuadya jutidya tura cuatsashaya eque ejuu ama. Micuanara ique aya, Beelzebúja casa tsehuepa ijahua cuana ijehuecuinaya jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Jetiama micuana tsehue juneniya cuanara dyaditu ijahua cuana ijehuecuinaya. ¿Aira tuna tyaya tumeque casa? Tuna tuna bahuedya, Beelzebúra ni ejeque casa tyayaque ama ijahua cuana ijehuecuina ishu, ijahua cuana tujaque juya tibu. Micuanara ni ejeneya Yusuja casa tsehue tunara ayaque, tume tuque micuanaja ejenetaquidya era dyadi Yusuja casa tsehuedya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Yusuja Espiritura casa tyaya ijahua cuana ijehuecuina ishu. Jadya tibudya tuque micuanaja inime jutaqui “Riyaque ri Yusuja Emepeque”, idya micuanara ihuacuareque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ecuita casadara quiyeti ishu tsehue tuja ai cuana naruyajutu dutya tuja etareju eje bucha ama juya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jadya ama buchatu peya dyaque casadaque tuaqueja ejunau tuatsehue cati ishu. Dyaque casadara ijahue aatsu, tujatu secaya dutya tuja quicueneti ishuque, dutya tuja ai anihua cuanaque jadya. Ique Satanás bucha dyaque casadaque. Aputashatillacuare tuque era tuja casa anicuareque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ejeque ecue ishu jidama quisaratiyaquetu ique ujeuque. Ique tsahua baecuara ique jidama aya. Tumequetu era mepeyaque dacashaajeya buchique, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tuhua cuanaque tuna Jesúsra cuejanucacuare: —Anicuaretu ijahua tura quijahuatishaya quejaque ecuinanaque. Tumeque ijahuatu junenicuare anitaya ama cuanaju ani ishuque sare juyaque. Dadicuare amatu eju ani ishuque. Dadima aatsu tujatu jadya inime tupucuare: “Padirunuca ique eju ique cuinanashatahuaju. Tuatsehue camadya ique eaninucau” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tumeque ecuita queja judirunucatsu tujatu badirucuare ni ejeque ijahua tsehue ama, etare ejabu, jida, ebajeje bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jadya baatsutu tumeque ijahuara peya ijahua cuana sareticuare. Pacarucu ijahua cuana, tuque bucha dyaque jidama cuanaque tujatu daditicuare. Daditsu tujatu ecana beticuare. Juetinucatsu tunajatu dutyara quijahuatishanuca acuare tumeque nerecadaque ecuita. Jadya juetu ecuita juya tuque icuene juhua bucha dyaque jidama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesús jadya quisaratiyajutu epuna jetiama ecuita ducuque quiquecuare: —¡Dyaque jida paju epuna mique ijehuecuinatsu susuqui juhuaque! —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","—Jejee, tumeque epunatu jida, pureama cabatiya. Dyaque jidatu Yusura cuatsayaque bacatsu cuatsashaya equedya juya cuanaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ecuita cuana Jesús queja casitatiyaju tujatu ecana isaratibunecuare: —Dutya jujeritu ecuita iyacua aniya cuanaque jidamaque inime cadujutiya. “Acue ai inimeradya jutidya, ecuana mique Yusura cuadishahuaque bahue juishu” jadya ajacama taa micuanara aya. Aya ama tuque era. Jonás jucuareque cuita camadya micuana huecashaya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Niniveju anicuare cuanaque Jonás eje bucha jucuareque bahue juatsu, tunajatu adebacuare tuque Yusura tuna Yusuja quisarati cueja ishu cuadishahuaque. Tumebaedya micuanara IQUE ECUITA eje bucha judadiyaque baatsu, tuque micuana adebadadiya ique Yusuja ecuadishaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Beru yuquejanetu ecuari epuna Sabá juque beni diji queja anicuareque jecuare dyaque japadaque Salomón dyaque inimequija quisarati bacara. Ique Salomón bucha dyaque inime metseque. Jadya ama bucha micuana era cuejayaque bacacarama aya. Jadya tibudyatu tere ishuque huecaca juetihuaju, Yusura ecuita cuana tuna eje bucha jubuqueque cuejabareyaju, tumeque ecuari epunaradya micuana pana cueja abuque Yusuja yacuaju: ‘Dyaque ecana pacanerecati Jesús yahuaju aniya patya tura cuejayaque bacacarama jucuare cuanaque’. ");
INSERT INTO cavNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jonásra Yusuja quisarati cuejayajutu Niniveju cuanaque inime cacuareticuare. Ique Jonás bucha dyaque inime metseque. Jadya ama bucha micuana bacacarama aya era bahuityayaque. Tumetu tumeque huecaca Yusura dutya eje bucha judadibuqueque cuejabareyaju, Niniveju anicuare cuanara micuana pana cueja abuque Yusuja yacuaju: ‘Dyaque ecana pacanerecati Jesús yahuaju aniya patya tura cuejayaque bacacarama jucuare cuanaque’ jadya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesúsra tuna cuejanucacuare: —Ude tuchatsu tuque ecuana tehuaya ama caju ducu. Etehuauque tuque ecuana iyaya ebarucue, nubitiya cuanaque jida capetati ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yatuca tsehue ademe ecuana capetatiya. Capetatitsu ecuana canarutiya ai muda cuanaju. Yatuca ecatse jidaju ecuana jidadya anitaqui. Yatuca ecatse jidamaju, ecuana ecanarutiu amadya muda cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Era micuana cuejahuaque tu hueca buchique. Necanaruticue bacue ecue quisarati enime aputauju. Ecue yana equedya ama ni micuana aniya, tume micuana apudaju juneniyaque cuji juhuaque bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Yuneridya ni micuanara adebaya, tume micuanara pana adeba aya ique aique, aira cuadishahuaque jadya. Tume tuque micuanaja saretaqui ama ecue ai inimeradya jutidya aishuque yunerique adeba ishu. Ude tsehue jida edijiju juneniyaque bucha micuana ejuu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús quisaratijacahuajutu fariseora tuja etareju araarati ishu cuejacuare. Jesústu nubitsu aninaticuare mesaju, emetucu cutsatimaque israelita cuanaja bahue eque ama. ");
INSERT INTO cavNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jadya baatsutu fariseora jidama bacuare, Jesús cacuatsashati eque ama juya baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ecuana Cuatsashaquiratu tura inime tupuyaque adebaya tibu jadya acuare fariseo: —Arepa micuana fariseo cuana ecuitaju asicadaque jida catillaticara juya ama buchatu Yusura micuanaja inime ducuta asicada baya. Jidama micuana juajeya. Chiri micuana juajeyadya jutidya. Micuana micuana canecu, peja jadya dyaque camadya eutsaque bucha, educuju asicadaque utsama. ");
INSERT INTO cavNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ecuita inime tupu baecua cuanaque! Pusha amadya tuque ecuanaja Yusura ecuita iyahua, tumebaedya ecuanaja educu juque inime. Ecuita camadya ama inime tupuqui neacue, educu juque inime tumebaedya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Micuana micuana jida bucha cabatiya, micuanara nerecada cuanaque ai tyaya tibu. Micuanara ni Yusu mereya educuju inime eiyacuane tsehue, tume micuana Yusura jida asicadama baya, peja dyaque educuju jadya pana utsa eaque bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Nerecapane micuana fariseo cuana! Arepa micuana cacuatsashati cuana aishuque ama jipenee eque juya ama bucha, cacuatsashati dyaque inime metse eque micuana aniya ama. Micuanajatu Yusu tyabahue cacuatsashatira casada tsehue tyamereyaque camadya. Acuihuija ijimeda cuanaque “menta”, “ruda” jadya bacani micuanaja etare taracaju cuhuatiya cuanaque, teeju cuhuatiya cuanaque jadya tuque micuanaja tyabahue. Jadya ama bucha tuque micuana jida, tuyu tsehue ama baya peya cuana. Micuanaratu Yusu iyuhuedama baya. Pusha amadya tuque micuanaja Yusu tyataqui cacuatsashati eque casada tsehue tyataquique. Jadya ama buchatu dyaque saretanaya jida, tuyu peya cuana tsehue ani ishu, Yusu iyuhueda baishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Nerecapane micuana fariseo cuana! Caradati ishuque etareju cuaatsu micuana muida cuanaque anibahueju anibutecara juya. Ediji cuanaju juneniyaju micuana dyaque muida tsehue isaratacara juya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Nerecapane micuana! Micuana micuana uhuacuare emaju cuanaque eishaque ejitajuque ama buchique. Ecuita cuanatu cuetiya, emajuque jarayaque dyaque eque adebayaque ama. Tumebaedya micuana jidadya batacara datse micuana juya; ai jidaque ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jadya juyaju bacatsutu cacuatsashati bahuityaquira acuare: —Jadya quisarati tsehue, fariseo cuana jipidya ama tuquemi ijillahuanaya. Ecuana cacuatsashati bahuityaqui cuanaque mira ecuana ijillahuanayadya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jadya juatsutu Jesúsra acuare: —¡Nerecapane micuana dyadi cacuatsashati bahuityaqui cuanaque! Casada tsehue micuana peya cuana jetiama cacuatsashati cuana eque amereya, tuna tsahuayaque ama. Abu ishuque dyaque bicueda eje bucha abutaquimaque peya abumere ishuque bajejequi buchique micuana. Micuanara cuitadyatu ni ai buchique abucarama aya, ni micuana peya abuquerecara aya. ");
INSERT INTO cavNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","“¡Nerecapane micuana! Micuana micuana jidama, micuanaja baba cuana bucha. Berutu micuanaja baba cuanara iyecuare Yusu equeque quisarati cuejaqui cuanaque. Iyacua tuque micuana micuanaja baba cuanara iyecuare cuanaja uhuacuare cuana jida piji bajejeya. Jadya juyaque micuana amena ejitaju juya micuanaja baba cuanaja inime cadujutiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Yusutu icueneta bahue eje bucha judadibuqueque. Jadya tibudyatu jucuare béru: ‘Cuadishabuque tuque tuna queja ique equeque quisarati cuejaqui cuanaque, anaqui cuanaque jadya. Umae tunajatu iyebuque. Peya cuana tunajatu ijahue ijahue abuque’ jadyatu Yusu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Nerecaturatabuque micuana ecue cuanaque jidama ahuaju camadya ama, tumebaedya micuanaja baba cuanara béru yuequedya Yusu equeque quisarati cuejaqui cuanaque iyecuare tibu. Dutya iyetacuare tibu Abel equeque, Zacarías tupu micuana jucha metse. Zacariastu Yusuja etareju iyetanacuare, Muida Cuitaque Ama, mesa tumu eaque Yusu tyaya cuanaque iya ishuque petya majaca. Pusha amadya micuana cuejaya. Micuana iyacua aniya cuanaque micuana nerecada atabuque Yusu dutya merequi cuanaque iyetacuareja inime. ");
INSERT INTO cavNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Nerecapane micuana cacuatsashati bahuityaqui cuanaque! Micuana cuitadya micuana baecua eje bucha judirue Yusu queja juishuque, ni micuana peya cuana bahue amerecara aya. Micuana micuana etsecue yahue tsehue teriqui buchique, micuana cuitadya nubi ishu ama ni ejeque nubicara juyaque nubi ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jadya quisarati ayaju bacatsutu cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya ecahuaiti dyaque jucuare. Jesúsja ishu tunajatu jidama quisarati acuare. Cacuatsashati eje bucha adeba aishuque tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yara tupu yara tupu tunajatu bacaduraajecuaredya jutidya. Eje buchadya Yusuja ishu jidama quisaratisha, jadya ama juatsu cacuatsashati bape cuejamere, huaraji cuana queja cueja jadya tunajatu acara ebari acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tume juyajutu casitaticuare eje uma mil ecuita cuana. Quitushatiya, ecatiiti jadya ecana jucuare. Jesusratu tura mepehua cuanaque isaracuare, ecuita jetiera ama bacayaju. —Necanaruticue fariseo cuana tsehue. Levadura buchiquetu tunara bahuityaya cuanaque. Jidadya batacara datse tuna juya, ai jidaque ama. ");
INSERT INTO cavNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Dutya ibedaquetu adebataqui judadiya. Dutya etehuaquetu ejitaju judadiya. ");
INSERT INTO cavNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Meta quisaratiyaquetu bacataquidya juya huecadaju. Micuanara etare teritsu cuejayaquetu dutya queja cuejatanabuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesúsra tuna bahuityanucacuare: —Nemubaume micuana iyecara juya cuanaque. Arepa tunara micuana eiyeu ama bucha, jadya aatsu tunajatu aijama casa micuana nerecatura ishu ni riya piji buchique. ");
INSERT INTO cavNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cuejaya micuana era, ejeque micuanaja mubataquique. Nemubacue Yusu camadya. Tuja peadya camadyatu casa aniya micuana majuhuaju ijahuaja etiquiju nudya ishu. Tuque camadya nemubacue. ");
INSERT INTO cavNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Yusuratu naruya dutya ai aniyaque. Upati huiri cuanatu tsujequi cuitaque ama. Pishicaque tu beta peadya chipiru tsuje piji. Jadya ama buchatu Yusura naruya; bahuedya tuna eje bucha juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Yusuratu adebaya dutya eje bucha micuana judadiyaque. Turatu adebaya dutya, eje uma micuanaja iyucaju etsaru aniyaque. Jutaquiju bajida nejuume. Pusha ama cuitadya micuana Yusura naruya. Upati huiri cuana naruya bucha, dyaque jida tura micuana narujacaya ama. ");
INSERT INTO cavNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Cuejaya micuana era. Ejeque ni ecuita cuanaja yacuaju ‘Jesús jaque ique’ jadya cacuejatiya, era ecue Etata barepajuja yacuaju, tuque tsahuaqui cuanaja yacuaju jadya ‘Ecuique tume’ jadidya abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ejeque ni ecuita cuanaja yacuaju ‘Ique Jesús jaque ama’ jadya cacuejatiya, era dyaditu ecue Etata barepajuja yacuaju, tuque tsahuaqui cuanaja yacuaju jadya ‘Ecuique ama tume’ jadidya abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Yusuratu IQUE ECUITAja ishu quisarati jidama ayaja jucha cuana eapupashau. Jadya ama bucha tujatu jucha cuana apupashabuque ama tuja Espirituja ishu cuita jidama quisarati aya cuanaja. ");
INSERT INTO cavNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Dujubuque tunara micuana caradati ishuque etareju huaraji cuana ecasitatiju. Epu naruqui cuanaque, inime bajejequi cuana jadyaja yacuaju micuana dujutanabuque. Huaraji cuanaja yacuaju dujutatsu jidama inime nebaume quicueneti ishu quisarati ishu ni eje bucha cuejae aya tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Quisarati ishuque ura juetihuaju Yusuja Espiritura micuana huecashaya micuana eje bucha quisaratie juishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Umada ecuita cuanatu jucuare Jesús tsehue. Peadyaratu jadya acuare Jesús: —Ebahuityaquique, ecue etatara tuque yatseja majutsu shanacuare dutya tuja ai anicuare cuanaque. Cuejacue ecue eusi; patya tura ique ecue ishu aniyaque, —jadya tujatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesusratu acuare: —Ique micue tataja ai jucuare cuanaque cajaqueti ishuque cueja ishuque ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tumebaedyatu Jesus jucuare: —Nebijiseriume dutya ai aniya cuanaque ni petaya cuanaque. Arepa ecuita dyaque umada chipiru tsehue ama buchatu dyaque jidama inimeju. Ejeque huecaca tujatu majutsu, shanabuquedya dutya tuja ai cuana, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jadya aatsu tuna Jesúsra bahuityacuare jeeque cuatsabiji eque. —Anicuaretu chipirudaque. Dutya tuja tee cuanaju uhuamerecuare cuanaquetu jida huijacuare. Jetiama tujatu huesamerecuare tuhua euhuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Chipirudaratu inime tupucuare: “¿Eje bucha ejuu? ¿Eju iyameretaqui ama taa baya ecue teeju era huesamereya cuanaque?” ");
INSERT INTO cavNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tume tujatu adebacuare eje bucha iyameree aishuque. “Parihuishamere tucue ecue beruque huesamereya cuanaque quiniqui cuanaque. Paamerenuca peya etare dyaque arida cuanaque. Tuhuadya tucue etare iyacua cuanaju paiyamere dutya ecue aniyaque, dutya era huesamereya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Tume tuque ecue inime juya. Amena ecue aniya umada earaqui eiyaque eje uma mara tupu. Pacanajara ique. Paaraara. Paijiiji. Iyacua pureama paju”, jadyatu chipirudaque jucuare datse. ");
INSERT INTO cavNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Arepa ecuitaja eje uma mara chacha ani ishu cabaticuare ama buchatu jadya ama jucuare. Yusuratu jadya acuare: “Inimema mique. Riyaque apuna cuitadyami majuya. ¿Aija ishu cuana taa tuquemi tume cuanaque iyamerehua?” jadyatu Yusura acuare chipirudaque. Jadya majuetu tumeque ecuita jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Cuejaya micuana era. Jadyatu jubuque tunaja ishu cuita camadya jetiama chipiru, ai jadya caradatiya cuanaque. Arepa tuna dyaque chipiruqui cabatiya ama bucha, tuna Yusura nerecada, aima bucha baya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jadya junuca jadya juatsutu Jesúsra tura mepehua cuanaque bahuityanucacuare: —Cuejaya micuana era. Netsapeume inime: “¿Ai dyadi rique araya, ijiya? ¿Ai dyadi rique jutuya?” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Yusura micuana iyahua tibu, yuneri cuitadya tura micuana tyadadiya micuanaja aijamaque ara ishuque, jutu ishuque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Neadebacue upati huiri cuana. Tunaratu inime tsapeya ama tunara sareya tsehue. Tuna tuna cuhuatiya ama ni cahuesatiya ama ara ishuque. Aijama tunaja ni eju tunaja earaqui iya ishuque. Jadya ama bucha tuna Yusura tyaya ara ishuque. Tujaque micuana. Micuana tura micuana dyaque iyuhueda baya, upati huiri cuana bucha ama. Yuneri cuitadya tura micuana tyaya micuanara ara ishuque sareyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ni ejeradya jutidyatu tuja maju ishuque ura juetihuaju tuja ani erirunucau ama. ");
INSERT INTO cavNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ni micuana ataqui baya batu di taa riya pijique, ¿tume tuque micuana eje bucha juatsu inime tsapequi aya peya ai cuana? ");
INSERT INTO cavNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Micuanajatu tsapetaqui ama inime jutu ishu cuana tsehue. Nebacuedya yachiju shasha cuana eje bucha danee juyaque. Tunaratu jidama ama inime baya jutu ishu cuana tsehue. Mere ecana juya ama chipiru jiteque, ni ecana taritariya. Jadya ama bucha tuna Yusura jida piji amereya. Salomón tu jucuare ecuari dyaque jida tsehue cajututitsu jida piji. Jadya ama bucha shasha cuana yachi juquetu dyaque jida piji, Salomónra ejutuqui dyaque jidaque jutucuare bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Shasha yachi juqueri tsunuda ama juya. Tumeque huecaca camadya tu jida piji; peya huecaca bacue eijehue ejuu etiquiju. Yusura yachi juque shasha cuana dyaque jida piji amereya tibu, yuneridya tura micuana tyayadya micuanara jutu ishu sareyaque. Micuanaratu tura naruyaque ejeneya ama, arepa tuque micuana upati jeta aqui cuanaque, shasha cuana jadya naruyaju baya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Yusura tura iyahuaque naruya tibu, inime netsapeume: ‘¿Ai dyadi tuque ecuana araya? ¿Ai dyadi tuque ecuana ijiya?’ jadya tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yusu adeba baecua cuanaque tuna tumeque inime tupu tsehuedya jutidya juneniya. Micuana jadya inime tupu tsehue nejuneniume. Micuanaja taa tu aniya Etata Yusu barepa juque, micuanara ai ara ishuque, jutu ishuque jadya sareyaque tyaquique. ");
INSERT INTO cavNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Pana catyati nejucue Yusu queja, tuja micuana naru ishu. Jadya anie ni micuana juya, tume tura micuana tyaya dutya micuanara sareya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Arepa micuana eje uma ama, casadama jadya juya ama bucha, bajida nejuume, ecue cuanaque. Micuanaja Tata Yusura micuana mepehua micuana eatsehue jupee huaraji aridaque juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Catyati neacue micuanaja aniyaque. Tumeque chipiru inayaque nerecada cuanaque netyabarecue. Nequiyatiajecue etsujequi tere baecuaque barepaju. Yusu queja micuana quiyatiajeyaquetu cayuamati baecua. Chiritanaya ama tuque, ni tu yuamaturaya rapara. ");
INSERT INTO cavNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tupujacaya ama tuque ecuana inime ecuanaja iyuhueda cuanaque quiyatihuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","38","“Cuejaya micuana riyaque cuatsabiji. Pana adeba neacue. Anicuaretu peadya ecuita chine ishu caquemititayaju cuacuareque. Tuja mere puji cuanatu baecua jucuare ai ura tuque juetinucayaque. ‘Meta patya ni tu juetiya, jadya ama juatsu ni huecacayaju’ jadya tunajatu inime jucuare. Ai ura tuque juetinucayaque baecua tibu tuna ecajututi anicuare. Ude ecana catuchaticuare. Tahuicuare ama ecana. Ecabati tuna anisisacuare. Equihuati tuna anicuare eje tupu tura juetitsu isaraetiyaju masadama etsecue pacasha ishu. Tumetu patrónra tuja mere puji jida cuanaque juetitsu sumietiya ecabati tuque ihua juya cuanaque. Ejeque uradya jutidya tuque juetitsu meta patya, huecacayaju, juetitsu tujatu ecana cuejaetiya mesaju anibute ishu. Ejutuqui jidaque bacue catacati, mere ishuque jutu jadya juatsu tujatu earaqui quinineya. “Jutaquiju micuana dyadi nequihuaticuedya ecabajejeti ique junanucayaju ishu, mere puji jida cuanaque jucuare bucha, tunaja patrón ihuayaque jucuare bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Bahue nejucue riyaque. Ni ejeque etare metsequetu bahue ama ejeque ura chiri puji ejutiuque. Junayaque bahueque juatsutu ecabati ejuu, chiri puji etareju chiri ejutiuque naru. ");
INSERT INTO cavNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Micuana dyadi equihuatidya nejucue ique batsa ishu. Muya jutidya micuana eanau, ejeque huecaca ique junanucayaque baecua tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Tumetu Pedrora bacaduracuare: —Ecuana Cuatsashaquique, ¿jadya cuejae mira ecuana aya, ecuana camadya, dutyadya ni taa? ");
INSERT INTO cavNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesusratu quemitsacuare: —Neihuacue ique, mayuruma jidara tuja patrón iyuhuedaque juetiyaque eihuau bucha. Mere puji yana equedya juyaquetu jida, inimequique. Micuanaja pana adeba aishu micuana cuejaya riyaque. Anicuaretu mayuruma. Tuja patronratu shanacuare tuque juneniya tupu tuja etareju cuanaque naru ishu. “Dutya huecaca ecana ara ishu cuanaque tyacue”, jadya patu tuja patrónra aquenacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tumeque mayuruma ni amerehua eque juya, peya cuana ni tu narujacaya ama, dutya pureamatu jubuque tuja patrón juetihuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pusha amadya micuana cuejaya. Tura tuja patrónja mere puji cuana jida naruhua tibu, tujatu dutya tuja ai aniya cuanaque narumereya. ");
INSERT INTO cavNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Mayuruma ni cuejataquima, amerehua eque amadyatu juya. Tura ni jadya inime tupuya: ‘Ecue patróntu juetihuishaya ama. Ecue biji eque paju jari’ jadya. Amena jadya juatsu tujatu peya mere puji cuana nerecaturaya; ijahue ijahue jutidyatu ecana aya. Chine mere, araara, nijuqui arida cuana tsehue, ijiijiya jadya tsehue jutidyatu ecana aniquereya, tuja mere ataqui ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tumetu tuja patrón juetiya ni tuque quihuatiyaju, ni tuque juetinucayaque ura bahueju. Jadya baetitsutu tuja patrónra catsa catsa, ijehue jadya aetiya tuja etare juque. Riyaque mayurumatu canerecatibuque. Yusu adeba baecua cuanaque canerecatiya bucha canerecatietu jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Mere puji ni yana equedya ama juya, arepa tuque tuja patrónra amereyaque bahue ama bucha, tumetu dyaque nerecada atanabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ejeque mere puji ni yana equedya ama juya, tuja patrónra amereyaque baecua juatsu, tumetu dyaque ama nerecaturatanabuque. Jetiama aniya cuanajatu jetiamadya tyataqui peya cuana. Tumebaedya ejera ni pana adeba aya Yusuja biji equeque bahuityataquidya tunajatu peya cuana tunara adebayaque, —jadya tujatu ecana acuare. (Riyaque cuatsabiji eque tuna Jesúsra bahue amerecara acuare tuque iyuhueda baqui cuanara ihuayaque; tuque iyuhuedama baqui cuanara bacue ihuaya ama jadique.) ");
INSERT INTO cavNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesúsra tuna bahuityanucacuare: —Etiqui jujuajeyara dutya jiji asicada cuanaque jadya tirushatsu bajejeajeya buchique ique. Ique jehua riyaque yahuaju jidamaque aputasha, eaqueja catyatiya cuanaque tunaja educuju asicadaque aniyaque tilla jadya aishu. ¡Eatilla jipe ecue Yusura mere amerehuaque ejuu! ");
INSERT INTO cavNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ique dyaque canerecatitaqui, majutaqui judadiya ique nerecada juyaque atillaya tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Micuanaja ni tu inime juya, ique junahua baatsu dutya inime jidama cuanaque, cati jadya amena terehua bucha? Jadya ama tuque. Ique adeba baecua cuanaque tuna ecue cuana tsehue cahuaititsu catibuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Iyacua equeque tu micuana dyaque ujeu baqui cuanaque micuanaja etareju cuanaquedya. Ita taa nebacue. Peadya etarejutu eaniu ecuita, tuja ehuaneque, ebacujunaque, ebacuaque, ebacuaqueja ehuaneque. Ique adeba baecua cuanaratu ique adebaqui cuanaque ujeu babuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Etataqueratu ebacuaque ujeu babuque; ebacuaquera bacue etataque. Ecuaqueratu ebacujunaque ujeu babuque; ebacujunaquera bacue ecuaque. Yahuiqueja ecuaqueratu ujeu babuque ebacuaque jahuane; ebacuaque jahuanera bacue yahuiqueja ecuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesúsra tuna cuejanucacuare: —Nei diji equeque huani sehueda netitsuraya baatsu, micuana juya: “Nei tu netihua; iyacuari nei juya”. Tumetu micuanara quisarati ahua equedya juya. ");
INSERT INTO cavNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Beni mara juetihuajutu “Amena nei jujacaya” jadya micuana jubahue. Micuana micuana bahue jida amena beni maraju nei jujacayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Micuana aniya patyatu Yusura jetiama aya ique tuaquejaque junahuaque adebamere ishuque. Micuanaradya jutidyatu adebaya ama, arepa micuana huecaca cuana eje buchique adeba bahue ama bucha, arepa micuana riyaque yahua juque adeba bahue ama bucha. Micuana micuana jidamaque inime cadujutiya, arepa micuana dyaque inime adebabada cabatiya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Micuanara cuitadya neadebacue dyaque jida tuyuque. ");
INSERT INTO cavNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ejera ni micuana huaraji queja cuejaya, dujucara ni tunara micuana aya, huaraji queja junatimaradya icuene jida inime nebajejecue. Icuenedya ni micuana inime ebajejeu ama, tume tunara micuana edujuu inime bajejequi queja. Dujuhuaju micuana inime bajejequira policía cuana queja edujumereu. Tume tunara micuana etare apudaju eishau. ");
INSERT INTO cavNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Pusha amadya micuana cuejaya. Tuhua tunara micuana enityamereu, huarajira tsujebacayaque tsujetyatillaya tupu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tumeque huecaca nucadyatu umae ecuita cuana jecuare Jesús queja. Cuejanaticuare tuna Jesús: —Pilatoratu eje uma israelita cuana Galilea juque iyemerecuare, tuna Yusuja etareju uu cuana iyetsu Yusu tyau juyaju. ¿Eje bucha juatsu tuna iyetanacuare, tuna jucha arida baatsu ni taa?, —jadya tunajatu bacaduraticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","—Micuanaratu adebaya tume cuanaque ecuita cuana Galileaju cuanaque peya cuana Galileaju cuanaque bucha jucha arida juatsu majucuare bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","¡Aijama! Tuna tuna peya ecuita cuana bucha dyaque jidamaque ama jucuare. Dutya tuna jucha arida cuanaque, micuana dyadi tumebaedya. Micuana ni cacuaretiya ama micuanaja inime, Yusu queja micuana judirubuque ama. ");
INSERT INTO cavNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Adebaya micuana peadya tunca quimisacarucu earacana ecuita cuana Siloéju aruhue etare rihuitsu tyanatanacuareque. ¿Eje bucha tuque micuana ecana adebaya? ¿Jerusalenju anicuare cuanaque bucha dyaque jucha aridaque ni taa? ");
INSERT INTO cavNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","¡Aijama! Tuna tuna peya cuana bucha dyaque jidamaque ama jucuare. Tuna tuna jucha arida jucuare; micuana bacue tuna baedya. Micuana ni inime cacuaretiya ama, ni ejeque micuana Yusu queja judirubuque ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jadya juatsu tuna Jesúsra jadya cuejanucacuare bahuityayaque. —Anicuaretu teeju acui higuera bacani euhuaque. Tuque uhuaquiratu sarenacuare ecaca. Dadinacuare amatu ni peadya ecaca. ");
INSERT INTO cavNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jadya juatsu tujatu ecuita tee naruquique cuejacuare: “Quimisha mara ique amena jeujeu juyaque riyaque acui caca sarera. Ni cacacati pidya ecue riyaque jucuare. Cuerehuanacue. Yanacana cuitari riyaque acui euhua”, jadyatu emechiquira acuare tee naruquique. ");
INSERT INTO cavNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tee naruquiratu acuare: “Riyaque mara camadya panetinuca jari. Eratu jida naruya. Huaca taraca juque mechi tsehue mechi pahuau euhuaque jida juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Peadya mara junucatsu cuanatu cacaqui ejuu. Cacacatinucaya ama ni, tumetu amena cueremeretaqui tumeque acui”, jadya tujatu acuare. Jadyatu jucuare acui cacamaque, —jadyatu Jesús jucuare. (Riyaque cuatsabiji tsehue tuna Jesúsra bahuityacara acuare. Inime cacuaretiya ama cuanaque tuna ijehuetanabuque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Canajara huecacajutu Jesús Yusuja quisarati bahuitya jucuare caradati ishuque etareju. ");
INSERT INTO cavNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tuhuadyatu jucuare epuna peadya tunca quimisacarucu earacana mara ujejedaque, yume tucue ijahuara jadya amereyaque. Ebebacua tujatu ecatununati jucuare. Jida netitaqui amatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Baatsutu Jesúsra ihuaracuare: —Jecue requeja, mama. Tuaqueja ihuaratsu tujatu acuare: —Mama, erami eremeque tuyuneya. ");
INSERT INTO cavNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jadya aatsu tujatu emetucu tuque dyaque huanacuare tuque chachane ishu. Jadya aya tsehuedya cuitadyatu epuna ereme juneniyaque jida neticuare. Tume tujatu amena Yusu pureama acuare: —¡Dyaque jida taa Yusu! —jadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Caradati ishuque etare naruquique huarajitu yaque cahuaiticuare, Jesúsra canajara huecacaju chachanehua baatsu. Turatu tuhua ecaradati cuanaque jadya acuare: —Aniyatu shucuta huecaca mere juishuque. Mere huecacaju nejecue casamameretira, canajara huecacaju ama. ¡Canajara huecaca tu casamati huecaca ama! —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jadya juyaju bacatsu tuna Ecuana Cuatsashaquira isaracuare dutya tuhua cuanaque: —Jidadya batacara datse micuana juya, ai jidaque ama. Micuana micuana mere juyadya canajara huecacaju. Inajacaya micuana canajara huecacaju huaca cuana, burro cuana jadya taraca juque cuinanasha ishu, ena ijimereti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Riyaque epuna ri israelita, Abraham eque ejuracanaque. Amena ri peadya tunca quimisacarucu earacana mara ijahuara ujejeda amereyaque. ¿Eje bucha chachanetaquima rejari ejuu ujeje canajara huecacaju? —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesúsra jadya ayaju cabacatitsutu tuque jadya juyaju jidama baqui cuanaque cabisuticuare. Peya cuanatu pureamadya jucuare Jesúsra ayaque baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Bahuityanucacuare tuna Jesúsra: —Cuejaya micuana riyaque cuatsabiji, micuana Yusura eje bucha micuana amena naruyaque bahue amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Adebayadya micuana mostaza caca, teeju euhuataque. Achaachaque piji, bataqui nerique ama. Jadya ama buchatu buraratsu, huijatsu, danetsu dyaque arida juya. Tuja yaa cuanajudyatu upati huiri cuana eja catiya, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra jadique huecashacuare. Arepa catibutiyaque eje uma piji tuaqueja catyatiajeya ama bucha, tuequedya tuna riya piji, riya piji jetiama catyatiajeya.) ");
INSERT INTO cavNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tumebaedya tujatu ecana riyaque cuatsabiji eque bahuityanucacuare: —Bahue micuana amerecara aya eje bucha micuana amena Yusura naruyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Epunatu pan ejuu. Eiyautu riya piji levadura. Quimisha equiniqui medidaju tujatu harina ehuauu. Tumeque riya piji levaduraradyatu dutya esaca huauhuaju emujashau, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tujatu ecana jadique huecashacara acuare. Levadurara dutya esaca mujashaya bucha, jadidyatu tuja quisarati dutya queja cuejatanabuque jadique.) ");
INSERT INTO cavNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesústu cuanucacuare Jerusalénju. Cuetiajecuaretu epu ebari cuana eque, epu achaacha cuana eque. Tumeque epu cuanaju aniya cuanaque tujatu bahuityaajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ejera cuanatu bacaduracuare: —¿Eje uma ama tuna Yusu queja judirubuque ni eje tupu jaca ishu ama, Ecuatsashaquique? —jadya tujatu acuare. Jesúsratu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Yusu queja judiru ishu tu masada, ibeda jadya; etsecue quinidama eque careta careta nubie ejuu bucha tuque. Ducuta inime tsehue eje buchadya dutya acara nejucue tuaqueja judiru ishu. Cuejaya micuana era. Dutya jujeri datse tuna Yusu queja judirucara juya. Jadya ama bucha tuna judirubuque ama, ai tuna eje bucha judiru ishuque aya batudya. ");
INSERT INTO cavNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Anicuaretu etare metseque. Nubi ishu emajaca tyau jadya aatsutu etare cateriticuare. Yusu tu etare metsesque buchique. Tere huecaca juetihuaju micuana Yusuja eaniqui etsecue netinatibuque. Ihuarabuque micuana Yusu. ‘Ecuana Cuatsashaquique, pacashacue ecuana’ jadya tuque micuana abuque. ‘Aijama. Adebaya ama micuana era. ¿Ejuque cuana taa micuana?’ jadya tura micuana abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tume tuque micuana abuque: ‘Mira taa ecuana adebayadya. Araaracuaredya taa ecuana miatsehue. Mique taa mi ecuanaja epu cuanaju bahuitya bahuityacuare’ jadya tuque micuana abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jadya bacatsu micuana Yusura abuque: ‘A, aijama. Micuana micuana ecue ama cuanaque. Cuejahuadya micuana era. Adebaya ama micuana era. Nenetisicuacue ique pequeque, micuana micuana jidama juhua cuanaque’ jadya tura micuana abuque. ");
INSERT INTO cavNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Abraham, Isaac, Jacob, Yusu equeque quisarati cuejaqui cuanaque jadya yuqueja Yusuja yacuaju aniya baatsu, micuana dyaque peya inime jubuque, tuna queja nubitaqui ama juya cabatitsu. Etse tari tsehue micuana pabuque tuhua nubitaqui ama cabatitsu. ");
INSERT INTO cavNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Eje uma israelita ama cuanaque tuna Yusu huaraji dyaque aridaque aniyaju judirubuque. Dutya quejaque tuna tuhua judirubuque. Junabuque tuna nei diji eque amacaque, beni diji eque amacaque, ijeti cuinanaya eque amacaque, ijeti nubiya eque amacaque jadya tuna caradatibuque Yusuja yacuaju pureama juishu. Caradatitsu tuna eatsehue araarapee jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iyacua dyaque inime metse cabatiya cuanaque tuna inime metse ama jubuque. Iyacua jetiedya, inime metse ama cabatiya cuanaque bacue dyaque inime metse cabatibuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Amena tuque quisaratijacahuajutu junacuare umae fariseo cuana. —Dirucue rehuaque. Herodesrami iyemerecara aya, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tura tuna acuare: —Herodes tu inime adebabadaque. Necuejadirucue jadya: “Eje uma huecaca ama mere juya jari. Cuinanashaya jaridya tuque ijahua cuanara quijahuatishaya cuanaja ijahua cuana. Ujejeda cuanaque tuque chachaneya. Jadya juatsu tuque ecue mere tereya”. ");
INSERT INTO cavNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Juneniya jari ique Jerusalén queja amaca iyacua, metajudya, tibene jadya. Jerusalén tu Yusu equeque cuitadya quisarati cuejaqui cuanaque iyetana ishuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jadya quisarati amena aatsutu Jesúsra quisarati acuare Jerusalénju aniya cuanja ishu. Tuna cuitadya baatsu quisarati aya buchatu jucuare, arepa tuna tuhua ama jucuare ama bucha. —Micuana Jerusalénju aniya cuanaque, micuanaja epu ebarijutu Yusu equeque quisarati cuejaqui cuanaque tumu tsehue iyetajacama jucuare. Eje uma narucara ebari datse micuana ahua. Tacure jabacua cuana ecuaquera yajapara emaque ishatsu enaruu bucha, narue datse micuana acara ahua. Micuanajatu ecue jadya narue aishu bijidama juhua. Dutya jujeri micuana eaqueja catyaticarama juhua. ");
INSERT INTO cavNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nebacacue. Yusuratu tuja epu ebari narujacabuque, tumebaedya tuhua anibuque cuanaque. Banucabuque ama micuanara ique, “Jida paju Yusuja ebacaniju junayaque”, dutya israelita cuana jadya judadiya tupu, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Canajara huecacajutu Jesús cuacuare fariseo huarajija etareju araara ishu. Tuhua jucuare cuanara tunajatu Jesús narucuare tura eje bucha canajara huecacaju ai ayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Tumebaedyatu tuhuadya jucuare ecuita ujejedaque emujatereque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesusratu bacaduracuare cacuatsashati bahuityaqui cuanaque, fariseo cuana jadya: —¿Ecuanaja cacuatsashatijutu ehuene, ecuita ujejedaque canajara huecacaju, chachanetaquique, aijama ni taa? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Tuna bacue abacatadya jutidya jucuare. Caquemitsaticuare ama tuna. Jadya juatsutu Jesúsra ecuita emujatereque jabatsu chachanecuare. Chachanetsu tujatu —Jida dirucue micue etareju, —jadya acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jadya juatsutu Jesúsra fariseo cuana anucacuare: —Micuana micuana mere juyadya canajara huecacaju. Micuanaja bacua, jadya ama juatsu juye canajara huecacaju epacacau cani dedaju. Tumeque uradya tuque micuana ecuinanashatiu, arepa canajara huecaca paju ama bucha. ¿Yuneridya? —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Eje bucha quemitsataqui ama tunajatu bacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesusratu bacuare eihuara cuanaque eaniqui dyaque jida muida cuanaque iyabutya ishuque eaniqui sare juyaju mesaju. Jadya juya baatsu tujatu ecana cuejacuare: ");
INSERT INTO cavNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Eju tunara chine ishu araara ishu cuejahuaju, neanibuteume eaniqui muida cuanaque iyabutya ishuju. Muidaque iyabutya ishuque eaniqui ni mi metseneya, ¿eje buchami ejuu, peya eihuaraque mique bucha dyaque muidaque jutihuaju? ");
INSERT INTO cavNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Metse cuejaqui juhuarami jadya eau: “Netitsuracue tumeque eaniqui juque. Riyaque ecuita tuhua paanibute”. Tumemi bisu majaca nerecada cuana ducu anidirutaqui. Jadyatu juya tuna taca camuibati juya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Tume amena tunara araara ishu ihuarayaju, neanibutecue nerecada cuana tsehue. Jadya juyajumi mique ihuaramerequira jadya eau: “Netitsuracue. Anibuteticue tuhua dyaque muida cuanaja eaniquiju”, jadya turami eau. Tume tuna dutya peya cuana ecueja cuanaque bahue ejuu mique muibataquique. Jadyatu juya tuna taca camuibati juya ama cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Yusuratu dyaque inime metse cabatiyaque aishu ama amereya. Aishuque ama cabatiyaquetu dyaque inime metse Yusura amereya, —jadyatu Jesúsra eihuara cuanaque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tumebaedya tujatu tuque ihuaramerequique acuare: —Chine catiyaque, micue ata cuana cuita camadya ihuaraume ni micue miatsehuequi cuanaque, micue eadeba cuanaque, micue epuju chipiruda inime metse cuanaque. Ihuaraya ni mi eadeba cuanaque, chipiruda cuanaque camadya, tume tunarami tuna chine catiyaque cuare ihuara jutidya eau. Jadya mique juhuajumi tume tsujema tyatana juya. ");
INSERT INTO cavNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jadya ama juatsu, chine catinucayaque, ihuaracue nerecada cuanaque, ebi tubu cuanaque, rudurudu cuanaque, shuhui cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Arepa micue nerecada cuanara, ujejeda cuanara jadya chine ishu ihuaranucataquima baya ama bucha, miquemi dyaque pureama micue canerecabatimi ecana bamerehua tibu. Amena ishuque huecacaju Yusura emaju cuanaque nityatsuranucatsu turami dyaque jida abuque, mira tume cuanaque nereca bahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jadya juya bacatsutu tuhua mesaju juaniyara Jesús jadya acuare: —Dyaque jida taa Yusu huaraji dyaque arida aniyaju judiruya cuanaque, tuatsehue araara ishu ecueja cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tura jadya ayajutu Jesúsra cuejacuare riyaque cuatsabiji tuna bahuityayaque, dutya ecuejaque ama Yusu queja judiruyaque. —Anicuaretu ecuita chipirudaque. Tuquetu cabajejeticuare chine arida juishu. Ihuaramerecuare tujatu ecana jetiama chine ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Earaqui amena juhuaju tujatu cuadishacuare tuque merequi tuja ecueja cuanaque ihuarara. “Nejecue. Amenatu iyatanahua”, jadya tujatu cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Cuejatahua ama bucha ecana cuacarama jucuare. Tudya tunajatu cuejacuare tuna cuejaqui juhuaque eje bucha juatsu tuna cuataqui ama juyaque. Icueneratu jadya acuare: “Cuaya ama ique chinera. Iyacua cuitadya ique yahua caquemitihua tee ishuque. Cuataqui ique tumeque petara. Cuejadirucue chine metseque; panerecaba tura ique”. ");
INSERT INTO cavNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Peyaratu jadya acuare: “Cuaya ama ique chinera. Quemihua tuque pishica yunta juye cuana. Tume cuanaque adebara cuaya. Cuejadirucue chine metseque; panerecaba tura ique”, jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Quimisha ishuratu jadya acuare: “Cuaya ama ique chinera. Iyacuadya taa huanequi juhua. Jadya tibu taa eje bucha cuataqui ama juya. Cuejadirucue chine metseque: panerecaba tura ique”, jadyatu peyara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Ecuejaquiquetu dirunucacuare. Judirunucatsu tujatu tuja patrón cuejadirucuare: ‘Dutya mira ihuaramerehua cuanaque tuna jecarama juya’. Tura jadya cuejadiruyajutu chine metseque cahuaiticuare dyaque. ‘Ebajarara cuacue epu quini cuana, epu tipare aniya cuana queja. Queticue requeja nerecada cuanaque, bima cuanaque, rudurudu cuanaque, shuhui cuanaque jadya eatsehue tuna araara ishu’ jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Tura jadya cuatsashahuajutu ecuejaquique cuacuare tuja yana equedya. Jadya cuejatitsutu judirunucacuare. ‘Mira cuatsashahua eque tuque ahua. Jetiama rena quetihua nerecada cuanaque, ujejeda cuanaque. Aniya jaridya emajaca jetiama ecuitaja ishu’ jadya tujatu acuare tuque merequique. ");
INSERT INTO cavNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jadya juyajutu patrónra jadya acuare: ‘Cuanucacue peya epu cuanaju, tee cuanaju. Tuqueja cuanaque ihuaraticue. Paje ecana ique chine catiyaju. Eje uma ecue etareju nubiya tupu ecana panubi. ");
INSERT INTO cavNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jeeque micuana cuejaya. Paaraarana ama ni ejeque era icuene ihuarahua cuanaque’ jadyatu chine metseque jucuare, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jerusalénju diruyaquetu Jesús tuhuaque cuanucacuare. Ecuita cuana jetiamaratu Jesús tupujudya acuare. Tuna queja huarere juatsu tujatu ecana isaracuare: ");
INSERT INTO cavNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Eaqueja catyaticara juya cuanaque, ecue jucara juya cuanaja ique dyaque iyuhueda bataqui, tuja etataque, ecuaque, ehuaneque, ebacua cuanaque, tuatsehuequi cuanaque bucha iyuhuee ama. Ique tunaja pureama ameretaqui, tuna pureama ejuuque. Jadya ama ni juya, tumetu ecue jutaqui ama. ");
INSERT INTO cavNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Micuana eatsehue junenicara juyaque juatsu, ecue yana equedya nejucue, arepa micuana canerecati, maju jadya jutaqui ama bucha, curusuju etata ejuu bucha. Ique jiteque iyetacara juyaju, iyetacarama juyaquetu ecuique jutaqui ama. ");
INSERT INTO cavNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Eaqueja catyatimaquedya yuneri nejucue eatsehue junenisiriyaque, canimehuallaticarama tsehue. Cuejaya micuana riyaque cuatsabiji micuana huecasha ishu. Anicuaretu ecuita etare iyacuaque caticara juyaque. Etare tibunema jarira tujatu inime tupucuare ama dutya tura etare ishu sareyaque tuja aniyaque, aijama jadique. ");
INSERT INTO cavNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Tumetu etare catibuticuare, dutyadya tuja etare atilla ishu aniya jadique baecuaquedya jutidya. Dudu cuana puchabaretsu tuja aijama jucuare ejaqui espiqui jadya tsuje tyaishu. Tuja dudu cuana camadya epucha eque tuna jetiama cueti cueti jucuare. Petatsu tunajatu ijaribacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Nepetacue riyaque dudu cuana camadya. ¡Inimema shana ri ecuita! Etareri caticara juchine, atilla ishu tupu aniyaque baecuaquedya jutidya”. ");
INSERT INTO cavNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Cuejanucaya micuana era. Anicuaretu ecuari peya yahua juque ecuari tsehue catira cuahuaque. Tuquetu peadya tunca mil sudaru cuana cuatsashaquique jucuare. Peya yahuajuja bacue beta tunca mil sudaru cuana anicuare. Catira cuamaradyatu icueneque ecuarira jida inime etupuu: ‘¿Ijahuedya tuque eau peya cuana, aijama ni taa?’ jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Juya ni tuja inime: ‘Eje bucha ijahuee ni tuque ama sudaru jetiamaque’ peya japada jarijudya tujatu cuadishaya icueneta ecuejaqui cuanaque: ‘Necahuaiti ama. ¿Eje bucha yatse ejuu jida, catima ani ishu?’ jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","“Jutaquijudya, eaqueja catyatimaradya jida inime netupucue, yuneridya micuana dutya ai aniya cuanaque cashanaticara tsehueque, aijama jadique. Eatsehue junenicara juyaquetu ecue yana equedya jutaqui, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesúsra tuna cuejanucacuare: —Banu tu jida. Banuja, ni banu huaja etereu, aijamatu ni eje bucha banuqui amerenuca ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jida amatu ni mechi jida amere ishu, ni aishu buchique. Ijehuetaquidya tuque jidama tibu. Tumebaedya micuana, micuana ni ecue yana eque jujacaya, tume micuana ni aishu buchique. Micuana quijacabacati aqui juatsu, nebacacue, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jetiama enaruquija ishu chipiru tsuje bacaqui cuanaque, peya ebijidamadura cuanaque jadya tuna cajipeticuare Jesús queja, tura cuejayaque ijacaba ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Fariseo cuana, cacuatsashati bahuityaqui cuanaque jadya tuna quisaratitibunecuare Jesúsja ishu: —Jeeque ecuitaja taa bijida jucha arida cuana tsehue juneni ishu. Tuna tsehuedya araaraya jadyatu juya, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jadya juatsu tuna Jesúsra riyaque cuatsabiji cuejacuare: ");
INSERT INTO cavNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Peadya ecuitaja cien uhuisha eaniu. Peadya tuja cuji ejuu. ¿Eje buchatu tumeque ecuita ejuu? Eshanau jari di taa tujatu puscurucu tunca puscurucu earacana taracaju. Eishautu eju aija eje bucha ataqui amaju. Jadya shanatsutu pereu amadya ecuau uhuisha cuji ejuque sarera. Esareudya tujatu dadiya tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Daditsu, pureama aatsu tujatu yaracacaju hueishatsu edujuu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Etareju judirutsutu eihuarau tuja ata cuana, tuja eadeba cuanaque jadya. Jadya tujatu ecana eau: “Pureama nejura, era ecue uhuisha cuji ejuque dadihua tibu”. ");
INSERT INTO cavNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","“Pusha amadya micuana cuejaya. Barepaju cuanaquetu pureama juya, Yusuja cuanaque jetiama tuja yana equedya juya baatsu. Jadya ama bucha tuna dyáque pureama juya, peadya jucha aridaque inime cacuaretiya baatsu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesúsra tuna bahuityanucacuare: —Peya micuana cuejaya. Anicuaretu epuna. Peadya tunca ficha chipiru tuja anicuareque, peadya ni ecaaputashatiu, ¿ai tu ejuu? Etuchau tu ude. Tucha jadya aatsu tujatu tsucuta etare ejabuu inime eque chipiru pana sare ayaque. Chamacama tujatu edadiu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Daditsu tujatu eihuarau tuja ata cuana, tuja eadeba cuanaque jadya. “Pureama nejura. Dadihua tuque ecue chipiru aputahuaque”, jadya tujatu ecana eau. Jadyatu epuna chipiru caaputashatiyaque ejuu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Pusha amadya micuana cuejaya. Ejeque ecuita jucha aridaque inime cacuaretiyajutu dyaque pureama juya barepaju Yusu tsahuaqui cuanaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesúsra tuna bahuityanucacuare: —Peya micuana cuejaya. Anicuaretu ecuitaja beta ebacuaque ecatse. ");
INSERT INTO cavNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ebacuaque tupujuratu jadya etataque acuare: “Tyacue ique, mique majuhuaju ecue jubuqueque”. Jadya tura ahuajutu etataquera tyacuare chipiru, ai cuana jadya tuja ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eje uma huecaca piji juatsutu ebacuaque tupujuque casitaticuare tuja ai aniya cuanaque. Catyati caticuare tuja ai cuana. Chipiru inatsutu dirucuare japada anape cuana queja. Tuhua judirutsu tujatu baya ijehuene chipiru acuare tuja biji eque. ");
INSERT INTO cavNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amena tuja chipiru pana tere juhuaju tuna dyaque mije jucuare tumeque yahuaju. Tumetu ehue ebari arara majuya bucha cabaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jadya juatsutu cuacuare mere sarera. Ecuita chipirudaque tumeque yahuaju aniya queja canerecatiticuare: “Micue mere aniyaque juatsu, micue mere paa. Aijama rique ecue ara ishuque”, jadya tujatu aticuare chipirudaque. Ecuitaratu cuadishacuare cuchi cuana naru ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Dyaque cuita aracara juatsu tujatu cuchi cuanara arayaque bijisericuare. Ni ejeradya jutidyatu ara ishuque tyacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Jadya tibudya tujatu inime tupucuare tuque juneniyaque. ‘Ecue etataja mere puji cuanaja taa tu aniya ara ishuque jetiama. Ique taa rehua arara majuya. ");
INSERT INTO cavNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ecue etata queja tucue padirunuca. Jadya paadiru: “Ecue etata, cajuchatihua taa ique Yusu tsehue, miatsehue jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mere taa amerecue. Micue bacua bucha bae aume. Micue mere puji bucha bae jutidya acue”, jadya era ecue etata paadiru’ jadya tujatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jadya inime tuputsutu judirunucacuare tuja etataqueja etareju. “Tuque japada jariju cuitadyatu etataque esirira batsacuare diruyaju. Batsatsu tujatu nerecabacuare. Tsajaja tsurutsa, macacatsa, dyahua jadya tujatu atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","‘Tata, cajuchatichine taa ique Yusu tsehue, miatsehue jadya. Micue bacua bucha batsae aume. Eje bucha micue bacua ique jadya ataqui ama mique baya’ jadya tujatu acuare tuja etataque. ");
INSERT INTO cavNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Etataqueratu ebacuaque quisaratiyaju bacaya ama bucha jadya acuare tuque merequi cuanaque: ‘Ebajarara ejutuqui jida pijique nequeticue. Nejutumerecue ecue ebacua. Nejutumerecue metara, zapatu jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Neiyeticue huaca ecuanara tsericuinashayaque. Nearaarara. Chine nejura. ");
INSERT INTO cavNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Riyaque ecue ebacua era emaju bucha bayaqueri chacha juetinucahua. Era eaputa bucha dutya huecaca adebayaqueri juetinucahua’ jadya tujatu ecana acuare. Jadya juatsu tuna catibuticuare chine. ");
INSERT INTO cavNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Tuna jadya juyajutu ebacuaque icueneque teeju mere juyaque judirucuare. Etare jipeajeyaque tujatu bacaajecuare tuna dudududuyaju, ijahue jadya juyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Judirutsu tujatu dudududuyaju bacatsu tuna merequique tueque cuetiya baatsu ihuaracuare. Ihuaratsu tujatu bacaduracuare: ‘¿Ai tuna juya? ¿Eje bucha juatsu tuna dudududuya, ijahue jadya juya?’. ");
INSERT INTO cavNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Micue jautu juetihua. Micue tataratu iyemerehua huaca tseridaque, tuja ebacuaque jida chacha juetinucahua baatsu’ jadyatu tuna merequira acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jadya bahue juatsutu eujique dyaque cahuaiticuare, yanacana chipiru ijehue pujija ebacaniju chine juya baatsu. Cahuaititsutu nubicarama jucuare. Tuja ebacuaque icueneque cahuaititsu nubicarama juya baatsutu esirique cuinanaticuare. ‘Nubicue, ebacua. Baeticue ecue jau. Juetinucahua rique’ jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Turatu etataque jadya atsacuare: ‘Aijama. Miquemi bahuedya eje uma mara era merehuaque eje bucha tsehue ama, ni micue yana acarama tsehue ama. Jadya ama bucha micue ique ni eje tupu etya uhuisha jabacua ecue iyuhueda cuana tsehue chine juyaque ara ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jeeque micue bacuaratu yanacana ijehuene ahua micue chipiru epuna jidama cuana tsehue. Iyacua tuque juetihuaju tuquemi tuja ishu iyemerehua huaca tseridaque chine juyaque ara ishu’ jadya tujatu etataque atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“‘Ecue ebacua, mique taa mi eatsehuedya. Dutya ecue aniyaque tu micuiquedya. ");
INSERT INTO cavNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Iyacua taa chine dyaque jida, pureama jadya nejura. Micue jau, era emaju bucha bayaquetu chacha juetinucahua. Era eaputa bucha ecue inime juyaqueri juetinucahua’ jadya tujatu ebacuaque acuare, —jadya tuna Jesúsra cuejacuare riyaque cuatsabiji. (Riyaque cuatsabiji tsehue ecuana Jesúsra bahuityacara aya ecuana ejeque jucha aridaque inime cacuaretiyaju Yusu queja catyatiyaju ecuana pureama juishu.) ");
INSERT INTO cavNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesusratu tura mepehua cuanaque bahuityanucacuare: —Peya micuana cuatsabiji cuejaya micuana bahuitya ishu. Anicuaretu chipirudaque, tuja mayuruma jadya. Umae cuanaratu cuejacuare tuja patrón: “Micue mayurumaratu yanacana quemidya jutidya aya micue chipiru, ai jida tsume aishu ama”. ");
INSERT INTO cavNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jadya bacatsutu tuja patrónra ihuaracuare mayuruma. “¿Eje buchique tunara jadya cuejahua? Bamerecue ique mira ecue mere puji cuanaja manu cuana huenechine cuanaque. Amenami ecue mayuruma jujacaya”, jadyatu chipiru metsera acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jadya bacatsutu mayurumara inime tupucuare: “Amena taa ecue mere aijama. ¿Eje bucha anie juya? Casadama taa ique tee mere juishu. Bisuya taa ique tsujema bacabaca juneni ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","A, adebahua tuque era. Adebahua tuque ique rehuaque cuinanahuaju aira batsayaque”. ");
INSERT INTO cavNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Jadya juatsu tujatu ihuaramerecuare peadya peadya mere puji cuana manuqui cuanaque. Icuene junahuaque tujatu bacaduracuare: ‘¿Eje uma tuque micue manu aniya ecuana merequi juchine queja?’ ");
INSERT INTO cavNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Turatu quemitsacuare: ‘Umada tuque ecue manu aniya, pushi mil litro jujeri olivo tseri’ jadya tujatu acuare. ‘Jeedya micue manu quirica. Era tuque micue manu aniyaque jaquechine. Amena tuque micue aniya patya jaque camadya, beta mil litro jujeri olivo tseri camadya. Anibutecue. Ebajarara iyacuaque manu quiricaju micue ebacani huenecue’. ");
INSERT INTO cavNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Jadya juatsu tujatu bacaduracuare peya: ‘¿Eje umatu micue manu aniya?’ jadya tujatu acuare. ‘Umada tuque ecue manu aniya. Cien arrobas trigo tupu tuque ecue manu’ jadya tujatu acuare. ‘Jeedya micue manu quirica. Era tuque micue cuarechine micue manu. Micue icuene juchine tupu ama tuque micue manu, quimisacarucu tunca arrobas trigo tupu camadya’ jadyatu mayurumara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Chipiru metsequetu bahue jucuare mayuruma ai juhuaque. ‘Arepa tura ique ijahue ahua ama bucha, tuquetu dyaque inime adebabada. Aniyatu umada tuque rehuaque cuinanahuaju tuque batsaqui cuanaque’ jadyatu tuja patrón jucuare, —jadya tuna Jesúsra cuejacuare. (Jesusratu jadya quisarati acuare. Yusu adeba baecua cuanaquetu dyaque bahue tunaja chipiru tsume; Yusuja cuanaque bacue jadya ama jadique.) ");
INSERT INTO cavNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesúsra tuna bahuityanucacuare: —Pusha amadya micuana cuejaya. Peya cuana tsehue jida juishu cabamereti ishu jadya micuanaja chipiru netsumecue. Micuana jadya juyaque juatsu, micuanaja chipiru terehuaju micuana jida batsatabuque micuana maju baecua anidiruyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ejera ni peya tuja riya piji aniya tsehue ijahue aya ama, tumebaedya tujatu jetiama tsehue ijahue aya ama ni ejeque. Ejera ni riya piji tuja aniya tsehue ejeque ijahue aya, tumebaedya tujatu jetiama anitsu ijahue eau. ");
INSERT INTO cavNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Micuana ni baecua riyaque yahuaju chipiru tsume, tume taa micuana ni aira buchique Yusu jaque ai narumereya ama. ");
INSERT INTO cavNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Micuana ni baecua peyaja ai naru, tume micuana yuneri cuitadya baecua micuana jaque cuita ai canaruti. ");
INSERT INTO cavNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ni ejera buchiquetu emereu ama beta patrón. Jadya jucara juyaque juatsu, tuque micuana, peya ujeu, peya bacue iyuhueda jadya jutidya ebau. Peyatu nijuta ducuta jadya tsehue emereu, peya bacue merecarama tsehue. Eje bucha anie ni micuana juma Yusuja biji eque, micuanaja ishu cuita camadya chipiru radanitya jadya juatsu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseo cuanatu chipiru dyaque iyuhueda baqui jucuare. Jadya bacatsu tunajatu Jesús ijaribacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jadya juatsu tuna Jesúsra acuare: —Micuanajatu inime juya micuana jida, inime cujisha baecua bucha. Yusura micuana yuneri eje buchique adebaya. Yusu adeba baecua cuanara iyuhueda bayaquetu Yusuja ujeu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Jesúsra tuna bahuityanucacuare: —Yuequedya yahua nanada equedyatu ecuita cuanaja inime juhua, Moisésja cacuatsashati equedya anitsu, Yusu equeque quisarati cuejaqui cuanara cuejaya eque anitsu, Yusu queja judiruya jadya datse. Juan Ecuita Cuana Utsaquira micuana cuejacuaredya micuana inime cacuareti ishuque. Tuequequedyatu cuejatanahua Yusura eje bucha narue dutya ecuita cuana ayaque. Jadya bacatsu datse tuna dutya jujeri eje buchadya judirucara juya Yusu queja. ");
INSERT INTO cavNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Yusura cuatsashahuaquetu ni eje tupu apupashatanaya ama. Peadya quisarati tujatu bareya ama. Barepa, yahua jadya aniya jari tuputu cacuatsashati cuana tere nime ama. ");
INSERT INTO cavNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Micuana ni micuanaja huane neri tsehue cajacatitsu, peya epuna tsehue caquemitinucaya, tume micuana cajuchatiya. Yusuja yatucaju tuque micuanaja icueneque epuna huane neri jaridya, ai tupujuque ama. Micuana ni epuna peyaja eijehue tsehue caquemitiya, tumebaedya micuana cajuchatiya, peya jaque micuana micuana jaque eata aya tibu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesúsra tuna bahuityanucacuare: —Anicuaretu ecuita chipirudaque. Ejutuqui jidaquetu dutya huecaca jutucuare. Dutya huecacatu chine mere jetiama earaqui bajeje, araara jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Anicuaretu nerecadaque Lázaro bacani. Dyaque ujejedaquetu jucuare, tuja ecuita pusese camaque. Chipirudaja etare tsecuetu yahuaju anianini bahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Eje buchadya jequecara jadyatu jucuare chipirudaja ara cuesusu tsehue, arabishatsu ijehueya tsehue jadya. Casadama cuita tibutu chapa cuanara tuja pusese cuana tecueyaju eje bucha camuyatitaqui ama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Chamacamatu ecuita nerecadaque majucuare. Barepa juque Yusu tsahuaqui cuanaratu dujucuare Yusu queja ecatyati cuanaque majutsu judiruyaju, ecuanaja ebaba emuibaque Abraham peque. Chipirudaquetu tumebaedya majunucacuaredya. Papatanacuaredya tuque. ");
INSERT INTO cavNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Chipirudaquetu majutsu tuyu judirudya ijahuaja etiquiju jucuare, Yusu adeba baecua cuanaque judiruyaju. Dyaquetu canerecaticuare. Dyaque nerecada juyara tujatu japada equera bacuare Abraham, Lázaro jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Tumetu chipirudaque quiquecuare: ‘Nerecabacue ique, tata Abraham. Cuadishacue Lázaro; paje, pabana tura ique. Tuja emetucu sapara huitu enaju mutyatsu tura ecue yana riya piji cuita pabaneshana. Dyaque cuita taa etiquiju canerecatiya’ jadya tujatu Abraham acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamratu acuare: ‘Tata, adebacue. Chacha jariju tuque micue anihua dutya ai mira bijida bahuaque. Lázaro bacue dyaque nerecada jucuare. Iyacuatu Yusura casaturaya. Mique bacue nerecada juya. ");
INSERT INTO cavNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jadya juatsu jipidya ama tuque Lázaro cuadishaya ama miaqueja. Aniyatu ecuana patya emajaca dyaque dedaque. Ni ejequedya jutidyatu ecarequetiu rehuaque tuqueja ni tuhuaque requeja’ jadyatu Abrahamra acuare chipirudaque. ");
INSERT INTO cavNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“‘Jutaquiju nerecabacue ique. Cuadishacue Lázaro ecue etataja etareju aniya cuana queja, tata. ");
INSERT INTO cavNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tuhua tuque ecue aniya pishica ecue eatsehuequi cuanaque. Cuadishacue. Pacuejatitu ecana. Chacha jarijudya ecana inime pacacuareti. Tuna inime cacuaretiyaque ama juatsu, tuna tuna dyadi rehua canerecati ishuju juetibuque’ jadya tujatu Abraham acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamratu acuare: ‘Tunajatu aniyadya eje bucha bacae aishuque Moisésra, Yusu equeque quisarati cuejaqui cuanara jadya huenecuareque. Cuejayaju bacatsu tuna paejene tumeque ehuene cuanaque’. ");
INSERT INTO cavNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jadya ajaju bacatsutu chipirudara acuare: ‘Tata, bacaya ama tunaja tuque. Ejeneya ama tunajatu ehuene cuanaque. Ejeque emajuque chacha netitsuranucahuaque batsatsu camadya tuna inime ecacuaretiu’ jadyatu chipirudara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","‘Bacacarama ni tuna aya Moisésra, Yusu equeque quisarati cuejaqui cuanara jadya huenecuare cuanaque, bacaya amadya tunajatu ni ejeque emajuque batsatsu’ jadyatu Abrahamra acuare. Jadyatu jucuare beta ecuita ecatse, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesusratu acuare tura mepehua cuanaque: —Majuma jari tuputu ecuita cuana cajuchaticara jujacaya ama. Dyaque nerecadatu jubuque ejeque cajuchatishayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Dyaque jidatu majutaqui juhua ebacua cuana bucha cuanaque cajuchatishaquique. Dyaque jidatu tumu erieri ishuque epituju risitsu bei dyaque dedaju ijehuetaqui juhua, ejeque cajuchatishamaque maju ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Necanaruticue eje bucha juyaque. “Micuana tsehuequi buchique ni cajuchatiya, nereda neacue. Tuque ni inime cacuaretiya, nenerecabacue; nenime aputacue tura eje bucha ahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ita taa nebacue. Ejera micuana jidama ajacama eau, jadya apidya jadya ama, tura micuana jidama juatsu eau, ‘Inime cacuaretihua. Cahuaitishanucacarama mique anucaya’ jadya anajacama eau. Jadya tura ayaju, nenerecabacue; nenime aputacue tura eje bucha jidama ahuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jesúsra mepehua cuanaratu Jesús isaracuare. (“Ecuadishata cuanaque” bacani tuna jucuare.) —Tsahuacue ecuana miaqueja dyaque nimee juaje ishu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—Micuanara ni ejenequena juhua, paju era micuanaja ataquimaque aishu casa tyayaque, ni aidya jutidya tuque micuana ataquima ama ebau. Jeeque acui morera bacani ni micuana eau: “Mutsautanacue rehuaque. Netisicuacue ena cuanaja ecuaque patya”, micuanaja yana equedyatu ejuu acui, era casa tyahuaque ejenehuaque juatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Jadya micuana cuejaya. Ecuitaja eaniu tuja mere puji tuja tee cuanaju, jadya ama juatsu, huaca cuana naruquique. Tuja mere puji chinequeja piji tuja mere juque juetiyaju, ¿tuja patronratu canajara ishu emajaca yume tyatsadya eau? ‘Anibutecue. Canajarabaca, araara jadya juatsu canajaracue’ jadya tujatu eau? ");
INSERT INTO cavNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Aijama! Jadya eauque, ‘Nahui caticati jadya juatsu ique araarayaju merenacue. Ique amena juhuaju piisi mique araaracue’ jadya tujatu eau. ");
INSERT INTO cavNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Patronratu yusurupai aya ama tuja mere puji, tura cuatsashahuaque camadya ahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tumebaedya micuana, Yusura amereyaque atillatsu muita ishuque bucha necabacatiume. ‘Ecuanaratu ecuanaja ai ataquique camadya ahua’ jadya necuejacue Yusu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesústu Jerusalénju cuayaque cueticuare Samaria, Galilea jadya eque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Peadya epu achaacha equetu cueticuare. Cuetiyajutu peadya tunca ecuita pusesera ririshaya cuanaque tuque tsurutsa ishu cuinanacuare. Japajapa piji tuna netinaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Netinatitsu tuna quiquecuare: —Nerecabacue taa ecuana, Jesús. Chachanecue ecuana, Ebahuityaquique, —jadya tunajatu acuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesúsra tuna baatsu isaracuare: —Pae queja necabameretiticue, micuana chacha juhuaque tuna bahue juishu, —jadya tuna Jesúsra acuare. Tume cuayaquedya jutidya tuna chacha jucuare Jesúsja casa eque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Peadya camadyatu yudijidya cuanuca jucuare Jesús queja, chacha juhua cabatitsu. Cuanucayaquetu juajecuare: —¡Dyaque jida taa Yusu! —jadyatu quique eque juajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesúsja yacuajutu nuyunaticuare. Ebutsequini tsehue yahua tseraya tuputu huipuchitanacuare. —Yusurupai mique aya, mira chachanehua tibu, —jadya tujatu Jesús aticuare. Jadya yusurupai atietu ecuitara cuanucatsu acuare, arepa tuque samaritano juya ama bucha. Puscurucu israelita cuana bacue yudijidya cuanuca jucuare ama Jesús yusurupai ara. ");
INSERT INTO cavNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—Peadya tunca ecuita taa tuque chachanehua. ¿Are peya cuana? ¿Puscurucu taa tu bataqui ama? ");
INSERT INTO cavNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Arepa peya yahua juque ama bucha taa ri riyaque jenucahua Yusu pureama ara. ¿Eje bucha juatsutu umae puscurucu jenucahua ama? Tuna taa tuna ecuanaja ata cuana, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jadya juatsu tujatu Samaria juque isaracuare: —Netitsuracue. Dirucue. Miquemi chacha juhua, mira era eje bucha eauque pana ejene ahua tibu, —jadyatu Jesúsra ecuita acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Peya huecacatu fariseo cuanara Jesús bacaduracuare: —¿Eje bucha juyaju ecuana caadebatibuque Yusura dutya ecuita cuana riyaque yahuaju aniya cuanaque narutibuneyaque? Tura tuna quemitsacuare: —Yusura narutibunehuajutu ejitajuque ama jubuque, ni eje bucha adebataqui. ");
INSERT INTO cavNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Arepa umae cuana jadya ejuu ama bucha, “Amenari riyaque epu Yusura narutibunehua”, jadya ama juatsu “Yuqueja anape cuana queja tuque”, pusha pusha jutidya tume. Yusura narutibuneyaquetu ejitaju ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jadya juatsu tujatu isaracuare tura mepehua cuanaque: —Ecue cuanaquetu canerecatidadibuque. Eje tupu ecue cuanaque nerecaturatayaju micuana jubuque: “Areque Jesús ECUITA rehua ecuana tsehuedya ejuu ecuana casatura ishu” jadya. Ique ejitajuque ama tuhua jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","“Rehuadya ri Mesías”, jadya ama juatsu “Tuhua tu Mesías”, jadya ni tu umae jubuque. Neejeneume. Necuinanaume ique sarera, ique rehua ama juya. ");
INSERT INTO cavNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Aira cuejatsu ama micuana IQUE ECUITA junanucahuaque bahue jubuque. Dutyajadyatu babahue pupipupiyaque dutya queja; jadidya ique dutyara babuque junanucayaju. ");
INSERT INTO cavNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","“Icuene ique dyaque nerecada jutaqui jari. Iyacua ecuita aniya cuanara bijidamadurabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noé aniya patya, tuque cuaba ebariju nubima jarijutu ecuita jidama cuanaque anicuare; ni ecana Yusura nerecaturayaju canerecati ishu equihuati jucuare. Jadidyatu jubuque ique junanucahuie. ");
INSERT INTO cavNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tume patya beru ena eque teretama jarijutu ecuita cuana anicuare tuna anietibehua buchadya jutidya. Araaraya, ijiijiya, huanequi, ahuequi jadya anie tuna jucuare Noé cuaba ebariju nubicuare tupu. Muya jutidyatu ena shumaumaque ama jueticuare, tunara ihuayaju ama. Dutya tuna huiditerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot aniya patya jucuare buchadyatu junucabuque. Ecuita cuanatu anicuare tuna anietibehua buchadya jutidya. Araaraya, quemiquemiya, catyati, uhuauhuaya, etare catiya jadya anie tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot, Sodoma juque cuinanayaque huecacatu Yusura pacacashacuare barepa juque etiqui, macana huiri cuana epacacau bucha. Dutya tuna majuterecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jadidyatu jubuque IQUE ECUITA ejitaju junayaque huecaca. Ique junabuque ni aira ihuayaju ama. ");
INSERT INTO cavNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Muya jutidya ique junanucabuque. Tumeque huecaca tuna etare ebarucue ecamahua jepeda cuana juque ai etare ducu inaquenama butetaqui huana ishu. Teeju mere juya cuanaque ecana judirunucataqui ama etareju tunaja ai jiteque. Tuhuaquedya tuna huanataqui. ");
INSERT INTO cavNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Neadebacue Lotja ehuaneque jucuareque. Tuque yudijidya cuanuca jucara juyajutu Yusura iyecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Micuana ni catehuatiya eaqueja ecatyatique eiyetauju, ejetsunue ama micuana anibuque. Tume micuana majutsu ni eje tupu Yusu queja judirubuque. Micuana ni ique jiteque, ejenetsu jadya iyetaya, tume micuana Yusu quejadya anisiribuque, arepa micuanaja ecuita ririya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Ique junanucayajutu ecue cuanaque enityasicua jubuque ecue ama cuana ducuque. Beta ecatse tuhua cuinetse cuartoju etahuiu. Ecuiquetu Yusu queja dujutanabuque. Peya bacue shanatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Beta epuna tuhua cuinetse eerieriu. Ecuiquetu dujutanabuque Yusu queja. Peya bacue shanatanabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Beta ecuitatu teeju cuinetse mere ejuu. Ecuiquetu Yusu queja dujutanabuque. Peya bacue shanatanabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jadya juya bacatsu tunajatu bacaduracuare: —¿Eje tsunutu jadya jubuque, Ecuana Cuatsashaquique? Tura tuna quemitsacuare quisarati jida eadeba tsehue: —Eju ai emajuque ririyajutu jamani cuana caradatiya aija cuejatsu ama. Tumebaedyatu jubuque ique junanucayaju. Dutya tuna bahue jubuque, aija cuejatsu ama, —jadya tuna Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesúsra tuna bahuityacuare cuatsabiji Yusu queja tunara bacayaque tyaya tupu bacabaca ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—Anicuaretu epuju huaraji inime bajejequique. Jadique inime tujatu ijehuecuare ama: “Eratu aya ai acara ayaque. Eratu inime baya ama Yusura, ecuita cuanara jadya ecue ishu inime tupuyaque” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tumeque epuju nucadyatu anicuare eahuemajuque. Castere baecuatu jucuare huaraji queja cuau cuau juyaque. “Tsahuacue ique. Bajejecue riyaque inime ique jidama aqui juhua tsehue”, jadya tujatu ajacama acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Tsunudatu huarajira tsahuacarama acuare. Epunaratu bacajacacuare ama. Amena chamacama huarajira inime tupucuare: “Mui baecua tuque ecue Yusu, ni ejequedya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jadya ama bucha, patsahua tucue era, tuque eaqueja jejaca ishu. Jeujeudya jutidyari ejuu. Amena tuque bacacarama aya”, jadyatu huaraji jucuare. Jadya bajejetu huaraji jidama cuitara acuare inime, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tuequedyatu Ecuana Cuatsashaquique Jesús jucuare: —Bacahua micuana huaraji jidamaque jucuareque cuatsabiji. ");
INSERT INTO cavNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Butsee tumeque huaraji jidamaratu tsahuacuare eahuemajuque tuaqueja cuau cuau jucuareque. Yusuratu tsahuayadya tuja cuanaque, huecada tupu meta tupu jadya tuaqueja bacabacaya cuanaque. ¿Quemitsa ishu tsunutaya bucha tuque micuana baya? ¡Aijama! ");
INSERT INTO cavNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Pusha amadya micuana cuejaya. Tuquetu tsunutaya ama tuja cuanaque tsahua ishu. ¿IQUE ECUITA junanucahuajutu riyaque yahuaju anibuque tunara bacayaque yuneri cuitadya Yusura tyayaque ejenequi cuanaque? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tuhuatu jucuare umae peya cuana bijidamaduraqui cuanaque, tuna dyaque jida bucha cabatiya cuanaque. Jesusratu cuejanucacuare riyaque cuatsabiji, tuna adebamere, huecasha jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Anicuaretu beta ecuita ecatse. Peadyatu fariseo jucuare. Peya bacue enaruquija ishu chipiru tsuje bacaquique jucuare. Fariseojatu inime jucuare, peya cuana bucha ama tuque cuita camadya dyaque jidaque bucha. Cuacuare tatse Yusuja etareju Yusu tsehue quisaratira. ");
INSERT INTO cavNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseotu netinaticuare ejitaju dutyaja peta ishu. Netinatitsutu Yusu tsehue quisaraticuare. “Yusu, yusurupai mique aya; mira ique peya cuana bucha dyaque jida tuyu iyahua. Ique chiri baecua ni ique jidama ni epuna metsequi tsehue eani. Yusurupai mique aya, yumeque enaruiquija ishu chipiru tsuje bacaquique jidamaque buchique ama ique. ");
INSERT INTO cavNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Dutya badiju quimisacarucu huecaca arama quibeti bahue mique era muiyaque cabamereti ishu. Jetiama mique tyabahue ecue chipiru, ai ecue aniya cuanaque. Peadya tunca ecue aniyaque, mique peadya tyabahue micue ishu, —jadyatu fariseora Yusu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Ecasumitiuque, enaruquija ishu chipiru tsuje bacaquique bacue juchaquidya jutidya cabaticuare. Ecuita cuanaja ijacaju amatu Yusu tsehue quisaraticuare. Bisutsu tujatu petacarama acuare ebarucue queja. Yacuatu camiriticuare tuja jucha aniyaque caadebatitsu. Jucuaretu: ‘Nerecabacue taa ique, Yusu. Ique jucha aridaque. Apupashacue ecue jucha cuana’ jadya tujatu Yusu acuare. Yusu tsehue quisarati jadya juatsu tatse dirucuare tatseja etareju. Jadya tatse jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Yusuratu apupashacuare enaruquija ishu chipiru tsuje bacaquija jucha cuana, fariseo jaque bacue aijama. Jeeque micuana cuejaya. Yusuratu dyaque inime metse cabatiyaque aishu ama amereya. Aishuque ama cabatiyaquetu dyaque inime metse Yusura amereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tumetu umae ebacua cuana etata cuanaquera Jesús queja dujubarecuare. —Emetucu micue iyacue ebacua cuanaja iyuca dyaque. Bacacue ecana Yusu queja, tuja ecana jida naru ishu, —jadya tunajatu Jesús acuare. Jesúsra mepehua cuanara tuna jadya baatsu, nereda jutidya atsabarecuare ebacua cuana tsehue cuacuare cuanaque: —Nepereume Jesús, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesusratu ihuaracuaredya tuaqueja ebacua cuana. —Pajedya ebacua cuana eaqueja. Necuadishaume ecana eaquejaque. Esiri cuanaque camadya ama, tumebaedya tuna dyadi tuna Yusu jaquedya. ");
INSERT INTO cavNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pusha amadya micuana cuejaya. Yusura dutya naruhuaju tuaqueja judirucara juya cuanaquetu era cuatsashaya eque jutaqui ebacua cuejataquique bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Peya huecacatu ecuita inime metsera Jesús bacaduraticuare: —Jidaque Ebahuityaquique, ¿ai mere tuque jidaque eau, Yusu queja judiru ishu ni eje tupu tuque jaca ishu ama? —jadya tujatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesusratu quemitsacuare: —¿Adebayadyami eje buchique quisarati ahuaque? ¿Eje bucha juatsu mira “Jidaque Ebahuityaquique” jadya aya? Yusu peadya camadya tu jidaque. ");
INSERT INTO cavNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Bahuedyami Yusura cuatsashahuaque. “Peyaja ehuaneque micuique bucha aniquere aume. Quiyeti puji juume. Chiri puji juume. Ni ejeque buchique pusha pusha aume. Muibacue mique baquique, mique susuquique jadya”. Jadyatu Yusura cuatsashacuare béru, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Dutya riya cuanaque cacuatsashati cuana tuque muibacuare nanada equeradya, —jadyatu ecuitara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jadya bacatsutu Jesúsra jadya acuare: —Aniya jari tuque micue eje bucha ataquique. Dutya micue aniya cuanaque catyati aticue. Catyati aatsu tyabarecue chipiru nerecada cuanaque. Dutya micue ai catyati aatsu, juetinucacue eaqueja eatsehue juneni ishu. Eaquejami ecatyatiu; tume tuque micue eaniu Yusuja cuanaja ishu tuja barepaju aniyaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Jadya ayaju bacatsutu dyaque peya inime jucuare, tuja dyaque jetiama aniyaque catyati acarama acuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tuja ai aniya cuanaque cashanaticarama juyaque baatsutu Jesúsra acuare: —Jetiama ai aniya cuanaratu dyaque ibeda, masada baya eaqueja pana catyati juishu, Yusura dutya naruyaju judirutaqui juishu. ");
INSERT INTO cavNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cahuayutu etsucuija cani eque eje bucha cuetitaqui ama. Tumebaedya tuna tunaja ai aniyara eje bucha judirutaqui ama amereya Yusu queja, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jadya juya bacatsutu tuque bacaqui cuanaque jucuare: —Chipiruda cuanaque ni Satanás quejaque quinajacameretitaqui ama cabatiya, ¿ejeque jatsutu tuaquejaque equinajacameretiu? —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—Ecuita ni tu tuta taca eje bucha quinajacameretie juma Satanás quejaque. Yusura peadya camadya tuna einajacamereu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jadya bacatsutu Pedrora acuare: —Ecuana Cuatsashaquique, ecuana ecuana dutya cashanatihua miatsehue juneni ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","—Pusha amadya micuana cuejaya. Micuana ni cashanatiya dutya micuanaja ai aniyaque Yusura eje bucha narue ayaque quisarati cueja ishu, Yusura micuana tyaya dutya micuanara riyaque yahuaju sareyaque. Tura micuana tyaya micuanara sareya tupu. Micuana ni etare cashanatiya, tura micuana tyaya eju ani ishuque. Cashanatiya ni micuana micuanaja huane, micuana tsehuequi cuanaque, micuanaja tata, micuanaja cuaa, micuanaja bacua cuana, tura micuana peya cuana queja iyuhue tsehue narumereya tunaja ata neri bucha. Micuana majuhuaju tura micuana barepaju tuatsehue anishasiribuque ni eje tupu tuque jaca ishu ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesúsra tuna peya queja amaca duju acuare peadya tunca beta earacana tura mepehua cuanaque, tuque eje bucha juyaque cueja ishu: —Micuana micuana bahuedya Jerusalénju ique cuayaque. Tuhuadya ique eje bucha juya, beru Yusu equeque quisarati cuejaqui cuanara ique eje bucha judadiyaque cuejahua equedya. ");
INSERT INTO cavNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Israelita ama cuana queja tunara inamereya. Ijahue ijahue tunara aya. Ijillahuana, ecuedira jadya tunara aya. ");
INSERT INTO cavNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ebi tsehue au, catsacatsa jadya tunara aya. Jadya aatsu tunara iyeya. Quimisha huecaca majutsu chacha netitsuranucaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Tura mepehua cuanaratu adebataqui ama bacuare eje buchique tura cuejahuaque. Yusura tunajatu inime tachicuare, tunara Jesús quisaratiyaque eadebauju. Jadya tibu tunajatu adebacuare ama. ");
INSERT INTO cavNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús, tura mepehua cuanaque jadya tuna Jericó epuju cajipetiajecuare. Tuhuadyatu shuhuique ediji jiruru anianinicuare cuetiya cuanaque chipiru baca juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ecuita umadaque cuetiyaju bacatsu tujatu ecana bacaduracuare: —¿Eje buchatu juya? ¿Ejequetu cuetiya? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","—Jesús Nazaret juquetu cuetiya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jadya ayaju bacatsutu quiquecuare: —¡Jesús, miquemi Yusuja Emepeque, David eque ejuracanaque! Nerecabacue taa ique, —jadya tujatu quique eque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jesúsra icuenenitya aajeya cuanaratu nereda acuare, tuque abacasha ishu. Tuque bacue jadya ayaju dyaque jebuda quiquecuare: —¡Miquemi Yusuja Emepeque! ¡David eque ejuracanaque mique! ¡Nerecabacue taa ique!, —jadyatu jebuda quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Tuque juaniya tuyu junatitsutu Jesús netinaticuare. Cuatsashacuaretu tuhua cuanaque: —Requeja nebecue shuhuique. Shuhuique tuaqueja cajipetihuaju tujatu bacaduracuare: ");
INSERT INTO cavNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Eje buchami eaqueja catimerecara juya? —Ecuatsashaquique, capetatishanucacue ique. ");
INSERT INTO cavNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Amenami capetatiya. Erami capetatishahua, mira era mique ecapetatishauque ejenehua tibu, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Tura jadya aya tsehuedya cuitatu capetaticuare. Tajiajecuaretu Jesús ediji eque, Yusu pureama ayaque. —¡Dyaque jida, casada taa Yusu! —jadyatu juajecuare. Tuhua jucuare cuanaratu jadya baatsu Yusu pureama acuare, —¡Jejee, casadadya tu Yusu! ¡Jidadya tuque! —jadya tuna, tuna dyadi jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tudyatu Jesús judirucuare Jericóju. Tuhua judiruhuaquetu cueticuare tumeque epu eque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tuhuatu anicuare ecuita chipirudaque Zaqueo bacani. Tuquetu jucuare enaruquija ishu chipiru tsuje bacaqui cuanaja huaraji. ");
INSERT INTO cavNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesúspa cuetiya jadya bacatsu tujatu bacara ebari acuare. Tuque ecuita barudama juya tibu, tujatu eje bucha petataqui ama bacuare ecuita cuana ducu netiyara. ");
INSERT INTO cavNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Tsajajaajetsutu icueneta tsuranati jucuare acui sicómoro bacaniju, japadama cuetiyaju Jesús batsacara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesusratu tueque cuetiyara bajiyudirucuare ebarucue. Bajiyutsu tujatu bacuare acuiju tsuratsu yaaju juaniyaju. Baatsu tujatu isaracuare: —Bandía, Zaqueo. Butecue ebajarara. Ique micue etareju riyaque huecaca nubidiruya, —jadya tujatu Zaqueo acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jadya ayajutu Zaqueo ebajarara butecuare. Jida inime tsehuetu Jesús batsacuare, tuja etareju nudyatsatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Zaqueoja etareju nubiya baatsutu tuhua jucuare cuanaque Jesúsja ishu quisaratitibunecuare, tuque enaruquija ishu chipiru bacaquija etareju nubiya baatsu. —Ita nepetacue. Jesústu nubitihua ecuita jucha aridaja etareju, —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zaqueotu juneticuare Jesúsja yacuaju. —Tyaya tuque nerecada cuanaque patya jaque dutya ecue aniyaque, Ecuana Cuatsashaquique. Era tuna eje uma ijahue acuare. Ecue tsuje bacataquique dyaquedya tuna tsuje bacabacanicuare, enaruquija ishu chipiru sitayaque. Era peadya peso chirihuaque tuna pushi peso cuaretyau abareya, —jadyatu Zaquerora acuare Jesús. Jadya cacuejatietu jucuare tuque jidama juhuaque, tumebaedya inime cacuaretihuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tudyatu Jesúsra acuare: —Berutu Abraham Yusu queja nimee anicuare. Jadidyari riyaque ecuita tuque eque ejuracanaque Ijahua quejaque quinajameretihua tuque eaqueja catyatihua tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ique riyaque yahuaju junahua Yusu adeba baecua cuanaque sarera tuna Ijahua quejaque inajacamerera jadya, uhuisha cuji eju bucha cuanaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalén japadama juajeya cabatitsu tunajatu peadya peadyaja inime jucuare. —Masadama ni tu Jesús huaraji dyaque casadaque ejuu riyaque yahuaju, —jadya tuna jucuare. Jadya tibudya tuna Jesusra cuejacuare riyaque cuatsabiji inime yunerique ama bajeje ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Anicuaretu ecuita dyaque inime metse eque ejuracanaque. Peya yahuaju japada cuacaraquetu jucuare, ecuari bacanisha ishu, jadya aatsu tuja yahuaju dirunuca ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cuinanama jarira tujatu ihuaracuare peadya tunca tuque merequi cuanaque. Tyabarecuare tujatu ecana peadya peadya ficha cuana chipiru tsuje aridaque. “Ique juneniya jari tupu jeeque chipiru tsehue quemi quemi, catyati jadya nejucue. Neumanashacue ecue chipiru,” jadya tujatu peadya peadya cama mere puji cuana abarecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Tuja epuju cuanaratu ujeu bacuare. Cuadishacuare tunajatu icuene ecuejaquique tuque cuayaque epuju. ‘Bijidama tuque ecuana baya jeeque ecuita ecuanaja ecuari juishu’ jadya tunajatu cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Japada cuaatsutu ecuari bacanishatanacuare. Jadya juatsutu juetinucacuare tuja epuju. Juetinucatsu tujatu ihuaramerecuare tuja mayuruma. ‘Ihuaramerecue era cuayara chipiru tyaquenacuare cuanaque. Bahue jucara juya tunara chipiru eje bucha acuareque, eje uma tuna umanashacuareque’ jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Icuenequetu juticuare tuja yacuaju. ‘Tsumechine tuque micue chipiru mira tyacuareque. Tuatsehue tuque umanashamerechine peadya tunca ficha dyaque tsuje aridaque’ jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Jadya ayaju bacatsutu ecuarira acuare: ‘Jida. Miquemi jidaque mere puji. Miratu pana tsume ahua era riya piji tyacuareque. Tume mique tyaya mere dyaque muidaque. Bacanishaya mique era peadya tunca epu cuanaju aniya cuanaque naru ishu’ jadya tujatu acuare tuja mere puji. ");
INSERT INTO cavNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tuequedyatu peya ecuarija yacuaju jutinucacuare. ‘Tsumechine tuque micue chipiru mira tyacuareque. Tuatsehue tuque umanashamerechine pishica ficha dyaque tsuje aridaque’ jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jadya ayaju bacatsutu ecuarira acuare: ‘Bacanishaya mique era pishica epu cuanaju aniya cuanaque naru ishu’ jadyatu tuja patrónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Jadya juatsutu peya jutinucacuare ecuarija yacuaju. ‘Jeedya micue chipiru mira ique tyacuareque. Eracaju dunutsu tuque iyacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Bajida juchine mira era aputashahuaju cuana jidama eauju. Ique bahue micue peya cuana tsehue canerecabati aijamaque. Ique taa bahuedya jucuare mira ecue riya piji aniyaque secanucabuqueque. Arepa ecuanara iruruya ama bucha, dutyadya tu micue ishuque. Arepa ecuanaradya tee cuana uhuahua ama bucha, miratu huesamereya micue ishu cuita camadya’ jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Miquemi mere puji cuejataquimaque. Iyacuami bahue juya. Nerecaturaya mique era, mira quisarati ahua equedya. Adebachinemi ecue canerecabati aijamaque. Ecue ishupa dutya micuanara iruruchineque. Era camadyapa tsumehua dutya ecue ishu camadya micuanara uhuahuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Jadya mira ejeneya tibu taa tuquemi dujuquena cuana dyadi juquena jucuare chipiru umanashaqui cuana queja. Tume taa tuque junanucatsu ecue chipiru era mique tyacuareque, tumeque chipiru eumanaque tsehue inapee aquena juhua’ jadyatu tuja patrónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jadya tujatu ecana acuare tuhua cuanaque: ‘Nesecacue chipiru tumeque mere puji cuejataquimaque. Netyacue peadya tunca chipiru umanashaqui juhuaque’ jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","‘Aniya tujatu peadya tunca chipiru, jadya tunajatu patrón acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘Pusha amadya micuana cuejaya. Ejeja aniyaquetu dyaque tyatanabuque. Tuja aniyaque dyaquedyatu tyatanabuque. Ejera ni jidama tsumeya tuque tyatahuaque, secatabuquedya tuque, arepa riya piji tuja aniya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Peya micuana cuejaya. Jadyatu juya ique ujeu baqui cuanaque, ecue naru ishu bijidama baqui juhua cuanaque. Nerisicue. Nebecue requeja. Neiyecue ecana ecue yacuaju’ jadya tuna ecuarira acuare. Jadyatu jucuare chipiru umanashaqui cuanaque, —jadya tuna Jesúsra acuare. (Riyaque cuatsabiji eque tuna Jesúsra huecashacuare, Yusu ecuanaja dutya casa tsehue meretaquique tura ecuana casa tyaya tsehue.) ");
INSERT INTO cavNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tumeque quisarati cuejatillatsutu Jesús cueticuare tuhuaque tura mepehua cuana tsehue Jerusalénju judiru ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Emata baruda cuita ama Olivo Acui Quini bacaniju tuna junaticuare. Beta epu ecatse Betfagé, Betania jadya japadama tuna jucuare. Junatitsutu Jesúsra icueneta cuadisha acuare beta tura mepehuaque ecatse. ");
INSERT INTO cavNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Ecuanaja yacua tuyu epu achaachaju necuacue. Tuhua junatitsu tuque metse banatiya burro erisique netiyaju, ni aija bucha isaanimaque. Nepisuticue. Pisutsu ecue nebecue. ");
INSERT INTO cavNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ejera ni metse bacaduraya: “¿Aishu tuque metse pisuya?” “Ecuana Cuatsashaquiratu sareya”, jadya neacue, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Tudyatu cuadishahuaque ecatse cuacuare. Banaticuare tatse burro isaanimaque Jesúsra cuejahua equedya. Banatitsu tatse pisucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burro pisuyaju baatsu tatse emetse cuanaquera bacaduracuare: —¿Aishu tuque metse ecuanaja burro pisuya? —jadya tunajatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—Ecuana Cuatsashaquira pari sareya, —jadya tatsejatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Pisutsu tatsejatu dujucuare burro Jesús queja. Judiruqueretsu tatsejatu tatsera jutuya tsehue titecuare. Tume tatsejatu bajeje amena aatsu Jesús isaanimerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesúsra isaanihuaju tunajatu jetiama tuhua cuanara tunaja jutu ishu cuanaque pijabarecuare edijiju, tuque muiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Judirucuare tuna emata Olivo Acui Quini jiruru. Dutya umada ecuita cuana tuatsehue ajeya cuanaque jerutibunecuare ecana pureama tsehue. Yusu tunajatu pureama acuare, Jesúsra Yusuja casa bamere ishu dutya ahuaque baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—¡Jida paju ecuari Yusuja ebacaniju jeyaque! ¡Amenatu Yusuja cahuaiti terehua ecuita cuana tsehue! ¡Arida, dyaque casada jadyatu Yusu barepajuque! —jadya tuna jubarecuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ecuita cuana ducutu fariseo cuana jucuare. Jadya quisarati bacatsu tunajatu Jesús acuare: —Ebahuityaquique, nereda acue miatsehue cuaya cuanaque; jadya ecana paquisarati ama, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tume tuna Jesúsra acuare: —Ique pureama ataqui tibu tunara jadidya aya. Ecuita cuana ique pureama aqui cuanaque ni eabacashau, tume taa Yusura tumu cuana queja pureama eamereu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Amena epu aridaque japadama juetiyara tujatu petacuare epu. Petatsu tuna Jesúsra enapacuare tumeque epu ebariju aniya cuanaque nerecada judadiyaque adebatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—Arepa micuanara ique iyacua pureama aya ama bucha, micuanaratu adebaya ama eaqueja catyatihuaju micuana Yusura jida ebajiyunucauque. Areque micuana pana adeba eau. Aijama, eje bucha adebaene tuque micuana ama. Ibecuinahuatu micuanaja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Juetibuquetu huecaca jidamaque micuana canerecati ishuque. Micuana ujeu baqui cuanaratu tibarillabuque micuanaja epu ebari. Nityatsurabuque tunajatu mechi uyuuyu esipique micuanaja epu pana teritilla aishu. Dutya eque tunara micuana iye ishu tabutillabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Dutya tunara micuana iyetillabuque. Micuanaja etare cuanatu terebuque, ni peadya tumutu anibuque ama cadyaquetitsu. Arepa micuana Yusura Ijahua quejaque eje bucha quinajacameretie juishuque bahue amerehua ama bucha, tuque micuana bijidamadurahua. Jadya tibu micuana canerecatibuque, —jadyatu Jesús jucuare ai ecuita cuana Jerusalén juque eisarau bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jadya juu jadya juatsutu Jesús Yusuja etareju nubidirucuare. Nubitsutu dyaque cahuaiticuare, tuhua eje bucha juyaque baatsu. Jadya tibu tujatu ecana etsecueju pana ijehuecuinatilla acuare catyati puji cuana, bacabaca puji cuana jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Cuinanashayaque tujatu ecana jadya acuare: —Yusuja quisarati tu jadya ehuene: “‘Ecue etare tu eatsehue quisarati ishuque etare bacani’ jadyatu Yusu beru jucuare”. Jadya ama bucha tuque micuana chiri puji cuana catehua ishuque cani bucha jutidya amereya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jerusalénju judirutsutu Jesús dutya huecaca Yusuja etareju cuau cuau jucuare, Yusuja quisarati bahuitya juyaque. Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara, epu juque huaraji cuanara jadyatu Jesús iyecara ebari acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Terecuare ama tunaja inime eje bucha iyemeree tuque eauque. Eje bucha eque eje bucha ataqui amatu jucuare, ecuita cuanara quisaratiyaju jida bacacuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Peya huecacatu Jesúsra Yusuja etareju ecuita cuana Yusuja quisarati bahuityanucacuare, Yusu queja judiru ishuque quisarati cueja. Tuque jadya quisaratiyajutu junacuare pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque, israelita cuanaja emuiba cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jipetitsu tunajatu bacaduracuare: —¿Airami ejeque ecuitaja ataquique ama aishu cuatsashahua? ¿Aija casa tsehue tuquemi jadya aya? —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesúsra tuna quemitsacuare: —Era micuana tumebaedya bacaduraya. Nequemitsacue ique. ");
INSERT INTO cavNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Airatu Juan cuatsashacuare ecuita cuana utsa ishu? ¿Yusura, ecuita cuanara ni taa? —jadya tuna Jesúsra bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Tume tuna, tuna cama quisaraticuare: —“Yusuradyatu cuadishahua”, jadya ni ecuana eau, tume tura ecuana ebacadurau: “¿Eje bucha juatsu jatsu tuque micuana Juanra cuejacuareque ejenecuare ama?” jadya tura ecuana eau. ");
INSERT INTO cavNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Ecuita cuanaja ecuadishaquedya jutidyatu jucuare”, jadya ni ecuana eau, tumetu dutya jujeri ecuita cuana ecahuaitiu ecuana tsehue. Tume tunara ecuana eiyeu tumu tsehue. Juan tunajatu Yusu equeque quisarati cuejaquique bucha adebaya, —jadya tuna cacuejaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Chamacama tunajatu quemitsacuare: —Baecua ecuana aira Juan ecuita cuana utsa ishu cuatsashacuareque, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Jutaquiju micuana era cuejaya amadya aira ique ecuitaja ataquique ama aishu cuatsashahuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jadya juatsutu Jesús catibutinucacuare ecuita cuana bahuitya. Riyaque cuatsabiji tujatu ecana cuejacuare, tuna bahuitya ishu. —Peadya ecuitajatu tee aridaque anicuare. Tee ameretsu tujatu uva uhuamerecuare. Umae ecuita cuana queja tujatu tee narumerecuare. Tura tuna acuare: “Micuanara ni ecue tee naruya, tume ecuana uva jahuanehuaju cajaquetiya micuana tsehue”. Tuna tuna endya jucuare. Tume cuanaque bajejetsutu emechiqui cuacuare japada peya yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uva jahuane mara juetihuaju tujatu tuque merequique cuadishacuare tee naruqui cuana queja. “Cuacue ecue teeju mere juya cuana queja. Cuejaticue ecana; pacuadisha tuna ecue ishuque uva epituque”, jadya tujatu ecana cuejamerecuare. Jadya ahuajutu cuacuare. Jutihuajutu tee naruqui cuanara inatsacuare. Mirimiri tunajatu atsacuare. Mema tuna cuadishacuare, ni peadya uva caca tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jadya juhua bacatsutu emechiquira cuadishanucacuare peya tuja mere puji. Tumeque tunajatu ijahue ijahue, miririsha jadya atsacuare. Memadya tuna cuadishanucacuare, ni peadya uva caca tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tuequedyatu emechiquira cuadishanucacuare peya mere puji nuca. Tumeque tunajatu ujeda atsacuare. Ujeda aatsu tunajatu tee tibene ijehueticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“‘¿Eje bucha juya?’ jadyatu inime tupucuare tee metsera. ‘A, adebahua tuque era. Pacuadisha era ecue ebacua neri, dyaque iyuhuedaque. Jida tunajatu emuibatsau’ jadya datse tujatu inime jucuare. Jadya inime tuputsu tujatu ebacuaque neri cuadishacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ebacuaquera jipeajeyajutu tee naruqui cuanaque jadya jucuare tuna cama: ‘Riyaquedya ri tee metseja ebacuaque neri. Eje tupu etataque majuhuajuri riyaquedya tee metse judadiya. Neiyetsara. Ecuanadya emechiqui nejura’ jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inatsacuare tunara. Inatsatsu tuna tee juque cuinanashacuare. Cuinanashatsu tuna iyecuare. Jadyatu tee naruqui cuanaque jucuare, —jadya tuna Jesúsra cuejacuare. Tume tuna Jesúsra bacaduracuare tuque quisaratiyaju bacaqui cuanaque: —¿Eje buchatu anabuque tee naruqui cuanaque emechiquira? ");
INSERT INTO cavNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Era micuana cuejaya. Juetitsu tujatu iyemerenabuquedya tee naruqui cuanaque. Peyadya tujatu mere puji cuana sarenabuque tee naru ishu, —jadya tujatu ecana cuejacuare. Jadya bacatsu tuna jucuare: —¡Jadya paju ama! ");
INSERT INTO cavNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesúsra tuna petacuare. —Ehuenedya tu Yusuja quisarati jadya. ¿Eje buchique tume? “Tumu etare puji cuanara tsumecarama acuarequetu tumu dyaque saretanayaque judadicuare. Ecuana Cuatsashaquiratu dyaque saretanayaque amerecuare”, jadya tu ehuene. ");
INSERT INTO cavNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ejeque chicatsu tumeque tumu dyaque rihuiyaquetu dyaque ujeda catibuque. Tumu ni ejeque dyaque rihuiya muru tujatu tyanatsu amerebuque. (Riyaque quisarati eque tuna Jesúsra bahuityacuare. Tuque bijidamaduraqui cuanaquetu dyaque nerecaturatanabuque.) ");
INSERT INTO cavNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Riyaque cuatsabiji bacatsutu pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque jadya dyaque cahuaiticuare, tunara cuitadya Jesús bijidamadurahuaque caadebatitsu, mere puji cuanara tee metseja ebacuaque bijidamadurahua bucha. Eje buchadya inacara datse tunajatu acuare Jesús. Eje bucha jadya ataqui ama tunajatu bacuare, ecuita cuana ecahuaitiuque adebatsu. Jutaquiju tunajatu inacuare ama tumeque ura cuitadya, ecuita cuana mubatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jadya juatsu tuna quinimeticuare Jesús ina ishu. Inime bajejetsu tunajatu eje uma ecuita cuana Jesús queja cuadishacuare. —Necuacue Jesús isarara. Jida tuyu cuita bucha necabameretiticue. Jadya juya ama bucha enaruquija ishu jidama nequisaratishacue. Tume inatsu nedujura huaraji cuana queja, —jadya tunajatu ecana cuejamerecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jadya juatsutu tumeque ecuadisha cuanaque cuacuare Jesús isarara. —Ebahuityaquique, ecuana ecuana bahue mique jida, tuyuque. Miratu bahuityaya Yusuja inime eque ani ishuque, ni ejeque buchique mubatsu ama. Micue ishutu ecuita dutya tupu. ");
INSERT INTO cavNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jutaquijudya ecuana cuejacue. ¿Ecuanaja cacuatsashati eque, tuque ecuanaja ecuana naruquique Roma juque tsujetyataqui, tsujetyataqui ama ni taa? —jadya tunajatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesusratu adebacuaredya tunara jidama inime tupuya tsehue jadya bacaduratiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Nebamerecue ique ficha enaruquija chipiru tuque tsujetya ishuque. Papeta era. —jadya tujatu ecana acuare. Petatsu tuna Jesúsra bacaduracuare: —¿Aija ebutsequini ri riyaque fichaju eiya? ¿Aija ebacani ri rehua ehuene? —Enaruquique muidaque César bacani jaque tume, —jadya tunajatu quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Jutaquiju netyacue enaruqui César tuque tyaishuquedya. Yusu netyacue Yusuja ishuquedya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yuhua dutyaja yacuaju tunajatu eje bucha jidama quisaratishataquima bacuare. Anajacatacuare jutidya tuna tuque jadya caquemitsatihuaju bacatsu. Abacatanacuaredya jutidya tuna. ");
INSERT INTO cavNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Tumeque huecaca nucadyatu saduceo cuanara Jesús baticuare. Tunaradyatu ejenecuare ama emaju cuanaque netitsuranucayaque. Junatitsu tunajatu Jesús isaranaticuare: ");
INSERT INTO cavNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Ebahuityaquique, Moisésra taa tu riyaque cuatsashacuare. “Ejeque ecuita ni majuya cabacuatimaque, tuatsehuequiquetu caquemitinucataqui eahuemaju tsehue, tuatsehue cabacuati ishu, icueneque ebacua emajuja ebacuaque bucha ishu”, jadyatu Moisésra cacuatsashati huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Riyaque cuatsabiji mique ecuana aya; ijariba ishuque jutidya tu ecuita emajuque chacha netitsuranucaya jadique. Anicuaretu ecuitaja pacarucu ebacua cuanaque. Icueneque ebacuaquetu caquemiticuare. Huanequi juu jadya juatsutu majucuare bacuamaque. ");
INSERT INTO cavNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Majuhuajutu ejuque beta ishuque caquemitinucacuare eahuemaju tsehue. Beta ishuquetu tumebaedya majunucacuaredya bacuamaque. ");
INSERT INTO cavNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Quimisha ishuque ejuquetu caquemitinucacuare eahuemaju tsehue. Tumebaedyatu junucacuare. Bacuamaquedyatu majunucacuare. Jadya ecana jubarecuare; pacarucudyatu tumeque epuna tsehue cama ecana caquemititsu majuetibecuare bacuamaque tere. ");
INSERT INTO cavNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Tumeque nerecadaque epunatu pacarucu ahuee juhuaque majucuaredya, yahue cuanaque majuterehuaju. Jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","“Ecuanarami bacaduraya riyaque. Yuneridya ni majuya cuanaque chacha netitsuranucabuque, ¿ejeja ehuanequetu jubuque chacha netitsuranucatsu, riyaque yahuaju tuque pacarucu ahuee juhua tibu? —jadya tunajatu Jesús bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesúsra tuna quemitsacuare: —Micuana micuana cuji juya. Riyaque yahuaju camadyatu ecuita cuana caquemitiya. ");
INSERT INTO cavNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yusuja yacuaju judirubuque cuanaque netitsuranucatsu tuna caquemitinucabuque ama barepaju. ");
INSERT INTO cavNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Maju, netitsuranuca jadya juatsu tuna majunucanime ama. Barepaju Yusu tsahuaqui cuanaque tuna caquemiti baecua. Jadidyatu emaju cuanaque; netitsuratsu tuna caquemitinucabuque amadya. Yusu jaque tuna jubuque; tuja ebacua cuanaque tuna jubuque. ");
INSERT INTO cavNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yuneridyatu emaju cuanaque chacha netitsuranucabuque. Neadebacue Moisésra cuitadya huenecuareque, acui huija jujuyaque murutayaque ama tura huenecuareque. Yusutu jucuare: “Ique Ecuatsashaquique. Ique Yusu, Abraham, Isaac, Jacob jadyara iyacua muiyaque”. ");
INSERT INTO cavNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Yusutu chacha cuanara muiyaque, emaju cuanara ama. Jadya tibudya yuneridyatu Abraham, Isaac, Jacob jadya ecana enetitsura. Yusuratu dutya enetitsura baya, arepa majuhua ama bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—Dyaque jidami caquemitsatihua, Ebahuityaquique, —jadyatu acuare umae cacuatsashati bahuityaqui cuanara. ");
INSERT INTO cavNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Tumetu saduceo cuanaja inime terecuare bacaduranuca ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesúsra tuna jadya cuejacuare: —Micuanajatu inime juya: “Mesías Yusuja Emepequetu ejeque ecuita baedya jutidya judadibuque, David eque ejuracanaque jubuque tibu”. Micuana micuana cuji juya, jadya inime tuputsu. ");
INSERT INTO cavNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David cuitadyatu bahue jucuare Mesías ecuita camadya ama jubuqueque, ecuita cuana bucha dyaque inimequique. Salmos quiricaju tuque ecuanaja Davidra cuitadya huenecuareque eisara: “Yusuratu Ique Cuatsashaquique jadya cuejacuare: ‘Anibutecue ecue jida eque amaca muitaj ishu, ");
INSERT INTO cavNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","era mique ujeu baqui cuanaque dutya ijahue atillaya tupu, Ique Cuatsashaquique’” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Davidradyatu Mesías ‘Ique Cuatsashaquique’ jadya acuare, arepa tueque ejuracanaque ama bucha. Yuneri cuitadyatu Mesías ecuita jutidya ama ejuu; ecuita cuana bucha dyaque inimequiquedya tume, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesúsratu isaracuare tura mepehua cuanaque, jetie ecuitara bacayaju ama. ");
INSERT INTO cavNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Necanaruticue cacuatsashati bahuityaqui cuana tsehue. Tuna aniya bae neaniume. Tunaratu una junudaque jutuya, peya cuana queja Yusu adebaqui jadya cabamereti ishu datse. Epu patya eque cuetiyaju tuna dyaque muida tsehue isaratacara juya. Caradati ishuque etareju cuaatsu tuna muida cuanaque anibahueju anibutetiya. Chine cuana ishu araaratayaju cuaatsu tuna emuita cuanaja eaniqui cuanaju cama tuna eaniqui metsene juya. ");
INSERT INTO cavNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Arepa ecana eahuemaju cuanaque tsahuaya bucha cabatiya ama bucha, yuneri cuitadya tunajatu eahuemaju nerecada cuanaque tunaja ai aniya cuanaque secatillaya, tuna tunaja etare juque cuitadya ijehuecuinaya tupu. Yusu tsehue quisaratiyaque tuna tsunuda quisarati bahue dutyaja ijacaju, tuna queja “Yusu adebaqui cuita rena”, jadya catimere ishu datse. Yusura tuna dyaque nerecaturabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesústu juanicuare Yusuja etareju. Petacuare tujatu chipiruda cuanara Yusuja ishu chipiru cajuju ishayaju. ");
INSERT INTO cavNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tumebaedyatu banucacuare eahuemaju dyaque nerecadara beta ficha piji cobre ishatiyaju, tsuje aridaque ama, ai tsujequi cuitaque ama. ");
INSERT INTO cavNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Baatsutu Jesús jucuare: —Pusha amadya micuana cuejaya. Yusuratu dyaque tsuje arida baya epuna nerecada eahuemajura ishahuaque, chipiruda cuanara jetiama ishahuaque bucha ama. ");
INSERT INTO cavNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tunaratu ishahua tunaja anidadiyaque jutidya. Jeeque epuna nerecadara taa tyatillahua tuja dutya aniyaque piji, tuja ai caquemiti ishu ejuuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Umae cuanatu quisaraticuare: —¡Dyaque jida piji taa Yusuja etare! ¡Tumu jida piji cuana tsehue taa ea! Ai jida piji cuana tsehue taa ebajeje ecuita cuanara Yusu tyahua tsehue, —jadya tuna jucuare Yusuja etare petatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tuna jadya juyaju bacatsutu Jesús jucuare: —Juetibuquetu huecaca Yusuja etare, etsecueju dutya ai ea cuanaque pana rihuishatanatere jubuqueque. Anibuque amatu tumu ecadyaqueti. Dutya tumu etare enityatsuraquetu yahuaju tere jubuque, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jesúsra mepehua cuanaratu bacaduracuare: —Ecuana Bahuityaquique, cuejacue ecuana. ¿Eje tuputu jadya judadiya? ¿Aiju ecuana caadebatibuque yahua tereyaque huecaca japadamaque? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","—Nimequi tsehue nequihuaticue. Ijahue necatimereume. Ique junanucahuie tuna jetiama junabuque iquepa ejuu jadya juya cuanaque. “Idya Mesías, Yusuja Emepeque”, jadya tuna jetiama jubuque. Peya cuanara bacue anabuque: “Amena tu piji dyane Cristo junanucayaque”. ¡Neejeneume! Tuna tsehue nejuneniume tunaja pusha pusha cabahuityati ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Dutya quejadya jutidya tuna catibuque. Japadama tuque micuana ecana catiyaju bacabuque. “Peya yahuaju aniya cuanaque patuna cahuaitiya tunaja huaraji cuana tsehue”, jadya tuque micuana bacabuque. Jadya bacatsu “Masadamatu tere juetiya”, jadya micuanaja inime paju ama. Dutya tume cuanaquetu jadya jubuque icuene. Tere ishuque ama jari tume. ");
INSERT INTO cavNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Riyaque yahuaju cuanaque tuna peya yahuaju cuana tsehue catibuque. Anape cuanaquetu catibuque peya anae cuana tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bucucubuquetu yahua dutya queja muda. Eje uma epu cuanaju tuna dyaque mije jubuque. Ujeje cuanatu tsapetanabuque dutya queja. Barepajutu ejitaju jubuque ai muda cuanaque. Babuque tuque micuana jetiama micuana tere japadamaque adebamere ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Dutya riya cuanaque ejitaju juma jariju micuana ujeu baqui cuanara micuana nerecada abuque eaqueja ecatyati baatsu. Inabuque tunara micuana caradati ishuque etareju huaraji cuana queja duju ishu. Etare apuda cuanaju micuana ishatanabuque. Dujubuque tunara micuana ecuari cuanaja yacuaju, enaruqui cuanaja yacuaju, eaqueja ecatyati baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Tume tuque micuanaja emajaca anibuque ique eje buchique tuna cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Huaraji cuanaja yacuaju dujutanayaju jidama inime nebaume quicueneti ishu quisarati aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Eradya micuana dyaque inimequi amerebuque quisarati ishu. Ni ejequetu micuana eje bucha aquique casada jubuque ama micuana ana tsurutsa ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Micuanaja ata cuanara cuitadya Yusu adeba baecua cuanara micuana menajetyabuque micuana ujeu baqui cuana queja. Micuanaja tata cuanara, micuana tsehuequi cuanara, micuana japadama aniya cuanara, eadeba cuanara jadya micuana tsautyabuque micuana ujeu baqui cuana queja. Umae micuana iyetanabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Dutya jujerira micuana ujeu babuque, eaqueja ecatyati baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jadya ama bucha Yusura micuana narujacaya ama. Aputashabuque ama tujatu ni peadya etsaru micuanaja iyuca juque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Eaqueja nimee ni micuana jujacaya ama, Yusura micuana tuaqueja dujubuque tuatsehue anisiri ishu, ni eje tupu tuque jaca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Sudaru jetiama cuanara Jerusalén epu ebari amena tabuhua baatsu, micuana caadebatibuque amena tillatanayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tumetu Judeaju cuanaque huanataqui emata cuanaju catehua juishu. Jerusalénju cuanaque tuna cuinanataqui tuhuaque. Teeju mere juya cuanaque tuna judirunucataqui ama epuju. Tuequedya tuna huanataqui. ");
INSERT INTO cavNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Yusu adeba baecua cuanaque nerecatura ishuque huecacatu juetibuque; Yusura yana iyacuare eque cuitadyatu judadibuque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Dyaque nerecadatu jubuque epuna maqui cuanaque, bacua nanaqui cuanaque jadya. Tuna tuna eje bucha huanataqui ama ebajarara cabatibuque. Riyaque yahuaju aniyaquetu dyaque nerecada jubuque. Dyaque jidama, ni eje tupu jadya canerecatie juhua bucha ama, ni yahua ejitaju juhua equeque. Yusuratu dyaque canerecatishabuque tuque adeba baecua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Eje uma tuna catiyaque majubuque. Peya cuana tunajatu dujubuque risitsu japada peya yahuaju. Israelita ama cuanaratu pana tilla abuque Jerusalén epu ebari. Tunaratu israelita cuana nerecaturabuque Yusura huecaca iyahua tupu, israelita ama cuanara jidama adadiyaque tereya tupu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jesúsra tuna bahuityanucacuare: —Anibuquetu ique masadama junanucayaque adeba ishuque. Cabapetibuquetu ijeti, badi, purari cuana jadya. Dutya ecuita cuanatu enime aputa, tadadaya jadya jubuque, bajida cuita juatsu. Enaja ecuaquetu sicacada jubuque. Ena pacu cuanatu netitsurabuque dyaque muda. ");
INSERT INTO cavNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ecuita cuanatu manu, emaju bucha jadya jubuque bajida juatsu, yahua eje bucha juyaque adebatsu. Barepaju casada aniya cuanaque tuna piririterebuque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Tuequedya tunara IQUE ECUITA huani ducu junanucayaju batsabuque. Ecue dyaque casa tsehue junanucabuque. Cabameretibuque ique eje bucha muitaeque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jadya juyaque catibutiya baatsu necacasaticue jutidya. Pureama tsehue, quihuati jadya jutidya nejucue. Bahuedya micuana jubuque masadama ique junanucayaque micuana inajacamere ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Turadya tuna jeeque cuejacuare bahuityayaque: —Ita taa acui higuera bacani neadebacue, peya acui cuana jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Yaa cuana catapananatiyaju baatsu, micuana bahue amena nei mara catibutiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tumebaedya micuana dutya riya cuanaque era cuejahua cuanaque juajeya baatsu, bahuedya micuana jubuque Yusura amena masadama dutya ecuita cuana narudadiyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Pusha amadya micuana cuejaya. Dutya riya cuanaquetu judadibuque iyacua ecuita cuana aniyaque majuma jarijudya. ");
INSERT INTO cavNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Arepa barepa, yahua jadya pana cuaretana jubuque ama bucha, dutya micuana era cuejahua cuanaquetu cuaretanatsu ama jadya judadibuque. ");
INSERT INTO cavNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Necanaruticue. Daja iji iji, nijuqui jadya nejucue. Riyaque yahua juquedya jutidya inime tupuqui neaume. Tume cuanaquedya jutidya ni micuana inime tupuqui aya, tume micuana junanucayara muya jutidya aya, cuanubi trampara muya jutidya einau bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Dutya jujeri yahuaju aniya cuanaque muya jutidya tuna atanabuque ique junanucayaju, tunara ique ihuaya ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Nimequi tsehue neihuacue. Jadya bacabacae Yusu queja nejucue: ‘Ecuanaja Etata, tsahuacue ecuana, ecuanaja dutya idu ishu miaqueja nimee jujacama, bisuma ECUITAja yacuaju cabamereti ishu’ jadya Yusu nebacacue, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Huecadaju tuna Jesúsra bahuityacuare Yusuja etareju epu ebariju. Chineju bacue cuinanacuare epu juque Olivo Acui Quiniju tahuidiru ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Dutya jujeri ecuitatu juti bahue jucuare apudajudya cuita Yusuja etareju tuque quisaratiyaju ijacabacara. ");
INSERT INTO cavNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Japadama israelita cuanaja chine Pascua bacani jucuare, tunaja ebaba cuanaque Egipto juque cuinanacuareque adeba ishuque chine. Tumeque chine ishu tunajatu araaranicuare pan levaduramaque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Pae cuanaja huaraji cuanara, cacuatsashati bahuityaqui cuanara jadyatu inime tupucuare Jesús eje bucha iyemeree aishuque. Etehua inamere tunajatu acara acuare. “Ecuita cuanatu ecuanara Jesús inamerecara ayaque bahue juatsu, ecahuaitiu ecuana tsehue”, jadya tunajatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tumetu Judas Iscariote Satanásra netiquerecuare, Jesúsra mepehuaquedya datse. Inimetu tupumerecuare Jesús eje bucha inameree aishuque tuque ujeu baqui cuana queja. ");
INSERT INTO cavNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tumetu Judas cuacuare pae cuanaja huaraji cuana tsehue, Yusuja etareju mere juya cuanaja huaraji cuana tsehue jadya quisaratira. Cuejaticuare tujatu ecana eje bucha inameree Jesús aishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Tura jadya quisarati ayaju bacatsu tuna pureama jucuare. —Mira ecuana Jesús menajetyahuaju, mique ecuana chipiru tsehue tsujetyaya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Tuque bacue endya jucuare. Tumeque huecaca equequetu Judasra Jesús eje bucha inameree aishuque sarecuare. Etehua inamere tujatu acara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jueticuaretu icueneque huecaca Pascua chine ishu, pan levaduramaque tunaja ara bahueque huecaca. Tumeque huecaca nucadya tunajatu iye bahue jucuare uhuisha jidaque Yusuja ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesusratu cuadishacuare Pedro, Juan jadya. Cuejacuare tujatu ecatse: —Nebajejeticue ecuanaja riyaque chineju Pascua ishu ara ishuque, —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tatseratu bacaduracuare: —¿Ejumi bajejemerecara aya? ");
INSERT INTO cavNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—Jerusalénju nebajejeticue. Tuhua junatitsu tuque metse tsuruya ecuita suraju ena duju juyaque. Tudya netupuajecue. Tupujudya aajetsu, ejeque etareju tuque nubidiruyaju baatsu tuhuadya nenubicue. ");
INSERT INTO cavNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Etare metseque jadya neaticue: “Ecuana Bahuityaquirami bacaduramereya: ‘¿Eje dyanepa micue etareju emajaca tuque tura mepehua cuana tsehue Pascua ishu araara ishu?’” jadya nebacaduraticue. ");
INSERT INTO cavNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Metsera jadya ayaju tura metse bamereya tuja etareju emajaca aridaque beta ishuque pisoju. Tuhuadyatu aniya dutya ecuanara sareyaque. Tuhuadya nebajejecue ara ishuque, —jadya tatse Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jadya ahuaju tatse cuacuare. Junaticuare ecatse epu ebariju. Junatihuajutu jucuare dutya tatse Jesúsra cuejadadihua bae cuitadya. Bajejenaticuaredya tatse chineju ara ishu cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Amena araara ishuque ura juetihuajutu Jesús, tura mepehua cuana tsehue anibutecuare mesaju. ");
INSERT INTO cavNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—Camadya ishu rique aya riyaque chine riyaque yahuaju. Jadya tibudya, eje buchadya araaracara ebari juya micuana tsehue, ique majuma jariquedya. ");
INSERT INTO cavNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Yusu tsehue enaruqui jupee juyaque huecaca piisi tuque riyaque chine anucabuque, jucha cuana tillataqui juishu iyetanatsu, uhuisha beru iyetana bahue junenicuare bucha iyetanae juatsu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jadya juatsu tujatu canecu juque uva nacaca esasanashaque inacuare. Canecu inatsutu —Yusurupai mique aya, Tata, —jadya Yusu acuare. Yusurupai jadya aatsu tujatu ecana acuare: —Neijicue jeeque. Riya piji riya piji necajaqueticue. ");
INSERT INTO cavNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Riyaque micuana cuejaya. Riyaque yahuaju Pascua chine micuana tsehue anucaya ama; ijinucanime ama tuque ecue uva nacaca esasanashaque. Jadya ama buchatu tumeque huecaca era Yusu tsehue narupee ayaque huecaca juetihuaju piisi tuque ijibuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jadya juatsu tujatu inanucacuare pan. Pan inatsu tujatu —Yusurupai mique aya, Tata, —jadya Yusu acuare. Yusurupai jadya aatsu tujatu pan cuesicuare. Cuesitsu tujatu tuatsehue anibareya cuanaque tyabarecuare. —Riyaque rique ecue ecuita, micuana jiteque maju ishu catyatiyaque. Micuana jadya araarae juyaque, neadebacue ique micuana jiteque majuyaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Araara amena juatsutu Jesúsra canecu juque uva nacaca esasanashaque inanucacuare. Canecu inatsu tujatu acuare: —Riyaque rique ecue ami, micuana jiteque quijehuetiyaque. Ique ecue ami quijehuetitsu majuhuajutu Yusura iyaya iyacuaque inime micuana tuaqueja judiru ishuque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Peya micuana cuejaya. Ique inamerequi juyaqueri rehuadya eatsehuedya mesaju. ");
INSERT INTO cavNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","IQUE ECUITA majuyadya. Iyeyadya tunara ique, Yusuja inime jadya juya tibu. ¡Dyaque nerecadatu jubuque ique ujeu baqui cuana queja inamerequi juyaque! —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jadya ahuaju tuna cabacaduratibarecuare tuna cama: —¿Ejeque ecuana jadya ejuu? ¿Aija ishu tujatu quisarati aya? —jadya tuna tuna cama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Tuequedya tuna caquemitsati caquemitsati jucuare ejeque ecana dyaque inime metse juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Tume tuna Jesúsra isaracuare: —Yusu adeba baecua cuanajatu inime juya dyaque inime metse cuanaque camadya cacuatsashati ishuque bucha. Ecuari cuanajatu casada tsehue cuatsasha bahue tunaja epu cuanaju aniya cuanaque. Huaraji cuana tuna casada tsehue camuimereti bahue tunaja jetiedya cuana queja. ");
INSERT INTO cavNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Micuana micuana jadya jutaqui ama. Inime metse cuanaque tuna jetiedya cuanaque bucha cabatitaqui. Ecuatsashaqui cuanara tuna peya cuana mere, tsahuataqui. ");
INSERT INTO cavNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Riyaque yahuajutu dyaque inimequi cuanaque anibuteya araara ishu mesaju, tunaja jetiedya cuanara mereyaju. Amena ique micuana queja jecuare ejeque jetiedyaque inimemaque bucha, micuana tsahua ishu, micuana queja ique cameremereti ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Micuana micuana eatsehue jujacahua ama ique dyaque canerecatiyaque huecaca. ");
INSERT INTO cavNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jadya tibu micuana tyaya casa enaruqui juishu. Ecue Etatara ique enaruqui juishu casa tyahua bucha, tyaedyaa micuana era casa tyaya. ");
INSERT INTO cavNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ecuari tuja eadeba cuana tsehue ejuu bucha araara, ijiiji jadya, jadidya micuana eatsehue jubuque Yusuja yacuaju. Micuana micuana ique muitaya bucha muitaedya jubuque, enaruqui cuanaja eaniquiju anibutehuaju. Micuanaratu narubuque peadya tunca beta earacana cuare cuanaque Israel eque ejuracana cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jadya quisarati amena aatsutu Ecuana Cuatsashaquira Simón Pedro isaracuare peya cuanaja ijacaju. —Satanasratu Yusu queja bacacuare, mique eaqueja nimee amerejacacara aatsu, Simón. Trigo tsaque etsajeu bucha tuque. Trigo asicadaque cuinanasha, jida arataquique camadya ani jadya ishu etsajeu bucha. Jadidya tuque, mira canerecati idutsu, tume tuquemi dyaque jida Yusu emereu. ");
INSERT INTO cavNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ique mique jiteque bacabacahua, mique eaqueja nimee jujaca ishu ama. Yara tupu mira jacaya; tumemi eaquejadya juetinucaya. Eaqueja nimee junucatsu micue ecare cuana casaturacue eaqueja nimee juishu, —jadyatu Jesúsra acuare Simón. ");
INSERT INTO cavNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—Ecuemi jacanime ama, Ecuana Cuatsashaquique. Ique bajidama miatsehue apuda etareju nubi ishu, ni miatsehue majupee juishu jadya, —jadyatu Simónra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—Cuejaya mique, Pedro. Riyaque meta, tacure quiquehuiemi catehuati quimisha juya. “Adebaya ama tuque era”, jadya aquimisha mira aya, —jadyatu Jesúsra Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jadya juatsu tuna Jesúsra bacaduracuare: —Era micuana shurumaima, chipiruma, zapatuma jadya ecue quisarati cuejara cuadishaya patya ¿ai tuque micuanaja aijama jucuare? —Aijama. Anicuaredya tuque ecuanaja ecuanara ai sareya cuanaque, —jadya tuna caquemitsaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—Iyacua bacue shurumai, chipiru jadya aniyaque juatsu, necadujuticue. Ejeja ni aijama quicueneti ishuque, catyati micuanaja neacue camisa, quicueneti ishuque quemi ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Dutya Yusuja quisaratiju ehueneque ique eje bucha judadiyaque jadidya pajudadi. Ehuenedya tuque: “Yusuja Emepeque ujeu baqui cuanaratu quiyeti puji bucha abuque”. Amena tu ejetsunue ama tunaja ique jadya aishuque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—Jeedya rehua beta cuchiru ebari, Ecuana Cuatsashaquique, —jadya tuna jucuare. —¡Tume tupu camadya! —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jadya juatsutu Jesús cuinanacuare epu ebari juque. Tuja bahuedyatu cuacuare uhua cuemusu Olivo Acui Quini bacaniju. Tura mepehua cuanaratu cuayaju tajiticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tuhua junatitsu tujatu ecana acuare: —Nebacabacacue Yusu queja, micuana Satanásra ique jacamerecara ayaju micuanaja idu ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Tume tuna Jesúsra jacacuare, tumu casa tupu dyane emareu tupu japae. Tuna jacatsutu chichucata junaticuare. Chichucata juatsutu Yusu tsehue quisaraticuare: ");
INSERT INTO cavNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Tata, nerecada ique amerecarama ayaque juatsu, ebacau datse mique era, ique canerecati ishu ama. Riya ique nerecada jutaquique tu ai patseda buchique. Jadya ama bucha ecue biji eque ama paju. Micue biji eque paju, —jadyatu Jesúsra acuare tuja Etataque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Tuque jadya juyajutu cabamereticuare barepa juque Yusu tsahuaquique, tuque casatura ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Tuja dyaque canerecati tsehuetu bacabacacuare. Tuja ducuta dyaque canerecati tsehuetu jucuare. Hueruru tujatu ami patataya bucha jucuare yahuaju, tuque Yusu queja bacabacayaju. ");
INSERT INTO cavNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yusu tsehue quisaratiyaque netitsuratsutu cuanucacuare tura mepehua cuana queja. Dyaque cuita peya inimeratu huenanashacuare. Baticuaretu ecana tahuijarabareyaju. ");
INSERT INTO cavNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—¿Eje bucha juatsu micuana tahuiya? Necabaticue. Netahuiume. Nebacabacacue Yusu queja, micuana Satanásra ique jacamerecara ayaju, micuanaja idu ishu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús quisaratiya jarijutu Judas junaticuare, tura mepehuaquedya datse. Tuque tupujudyatu junaticuare jetiama ecuita cuana. Junatitsutu Judasra Jesús jipenatitsu dyahuacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jadya tura ayaju Jesúsra jadya acuare: —Judas, ¿dyahuatsu mira menajetyaya, IQUE ECUITA ique ujeu baqui cuana queja? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesúsra mepehua cuanaratu jadya juya bacatsu, bacaduracuare: —¿Quicuenetiya ecuana ecuanaja cuchiru ebari tsehue, Ecuana Cuatsashaquique? ");
INSERT INTO cavNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Peadyaratu pae dyaque muidaque merequique ujeda acuare; jida equeque amaca eque ijaca tujatu pejucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jadya ayajutu Jesúsra acuare: —Jadya neaume. ¡Tume tupu camadya! —jadya tujatu acuare. Jadya ahuajutu Jesúsra jabacuare ijaca pejutanahuaque. Jabatsu tujatu ijaca chachanecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jadya juatsu tujatu isaracuare pae cuanaja huaraji cuana, Yusuja etareju mere juya cuana naruqui cuanaque, israelita cuanaja emuiba cuanaque jadya: —Micuana micuana jehua cuchiru tsehue, acui tsehue jadya ique inara, chiri puji inara ejeu bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Anichinedya tuque micuanaja emajaca ejudya jutidya ique ina ishu cuchiruma, acuima. Dutya huecaca taa ique Yusuja etareju Yusuja quisarati bahuitya juchine. ¿Tume micuanara eje bucha juatsu inachine ama tuhua? Amena micuana Yusura emajaca tyahua ique ina ishu. Amenatu dyaque casadaque Ijahua, Yusu tsehue ecahuaitique, tuja biji eque juya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jadya juatsu tunajatu inamerecuare Jesús. Inameretsu tunajatu Jesús dujucuare pae dyaque muidaja etareju. Tumetu Pedrora tunara Jesús dujuyaju japa tupuaje acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Etareju judirutsu tunajatu etsecueju etiqui ruquedirucuare. Ruquetsu tuna etiqui bahui jucuare. Pedro bacue tuhuadya tuna tsehuedya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Etiqui jujuyara udayaju baatsutu tuhua mere juya epunara Pedro junetiya baatsu petatsu acuare: —Riyaque ecuita ri Jesús tsehue junenihuaquedya, —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","—¡Aijama, mama! ¡Adebaya ama tuque era! —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Yara tupu juatsutu peyara banucacuare. —Mique taa mi Jesús tsehue junenihuaquedya, —jadya tujatu acuare. —¡A, aijama! ¡Tuatsehue juneninime ama ique! ¡Adebaya ama tuque era! —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Peadya ura tupu junucatsutu peyara jadya anucacuare: —Yuneri cuitadya ri riyaque ecuita Jesús tsehue junenihuaquedya, Galilea juque nucadya tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—¡Aijama, tata! Eje buchique cuana taa mira jadya aya; ique taa baecua. ¡Adebaya ama tuque era! —jadyatu Pedrora acuare. Tuque jadya quisaratiyaju cuitatu tacure quiquecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Tumetu Ecuana Cuatsashaquira huareretsu Pedro petacuare. Jadya baatsutu Pedro huecatanacuare. Adebacuaretu Jesúsra cuejachineque: “Riyaque meta tacure quiquehuiemi catehuati quimisha juya. ‘Adebaya ama tuque era’ jadya aquimisha mira aya”. ");
INSERT INTO cavNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jadique adebatsutu Pedro cuinanatsu paa ebari jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesús naruqui cuanaratu Jesús ijillahuanacuare. Atuca penetsu tunajatu bahuapajacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","—Caadebaticue. ¿Aira taa mi bahuapajahua? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ijillahuanajacacuare ama tunaja tuque. ");
INSERT INTO cavNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Amena huecacahuajutu casitaticuare israelita cuanaja emuiba cuanaque, pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque jadya. Dujumerecuare tunajatu Jesús huaraji inime cuana bajejequi cuanaja yacuaju. ");
INSERT INTO cavNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Midyami Mesías, Yusuja Emepeque? Pusha pusha ecuana aume, —jadya tunajatu acuare. Tura tuna quemitsacuare: —Era ni micuana “Jejee” jadya aya, ejeneya ama micuanara ique. ");
INSERT INTO cavNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Era ni micuana ebacadurau: “¿Ejeneya micuana ique Yusuja Emepeque?”, equemitsau ama micuanara ique. ");
INSERT INTO cavNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Iyacua eque micuanara IQUE ECUITA baya Yusu Dutya Casa Tsehueja yacuaju, ecue casa ique cabameretiyaju, —jadya tuna tura acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jadya juyaju tunajatu dutyara bacaduracuare: —¿Jutaquiju ni taa mi midya Yusuja Ebacuaque? —Jejee, Yusuja Ebacuaquedya ique, micuanara ahua equedya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—Sareya ama tuque ecuana peyaja riyaque jidama juchineque cueja ishu. Ecuanara cuitadyatu bacahua tura quisarati jidamaque ayaju, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jadya juatsu tuna dutya huaraji cuana netitsuracuare, “Amena tuque ecuana dutya quisarati atillahua” jadya ishu. Dujumerecuare tunajatu Jesús Pilato queja. ");
INSERT INTO cavNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Tuhua junatitsu tuna cuejatibunecuare Pilato, Jesús eje bucha ejuuque. —Riyaque ecuitarari ecuanaja yahuaju aniya cuana queja muimerecarama aya Roma juque enaruqui. Tsujetyataqui amapa tuque ecuanaja ecuana naruquique. Tumebaedyatu Mesías, ecuanaja ecuari jadya catiya, —jadya tunajatu acuare Pilato. ");
INSERT INTO cavNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jadya juyajutu Pilatora bacaduracuare: —¿Midyami israelita cuanaja ecuari? —Jejee, mira aya equedya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jadya juatsutu Pilatora acuare pae cuanaja huaraji cuana, ecuita jetiamaque tuhua aniya cuanaque: —Dadiya ama taa era ni eje buchique inime jidamaque riyaque ecuitaja. ");
INSERT INTO cavNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jadya bacatsutu Jesús ujeu baqui cuanara dyaque jebuda quique eque acuare: —Dutya queja tujatu ecuita cuana sicacaturaya. Junenichinetu dutya Judea yahuaju, Galilea eque Jerusalén tupu jadya juyaque, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jesúspa dutya Galileaju junenichine jadya bacatsutu Pilatora bacaduracuare: —¿Galilea juque ri riyaque ecuita? ");
INSERT INTO cavNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tunara bacue “Jejee, tuhuaquedya tume”, jadya ahuaju, tujatu dujumerecuare Herodes queja, Herodesradya Galileaju cuanaque narucuare tibu. Tuquetu bahuedya jucuare Herodes Jerusalénju jehuaque. ");
INSERT INTO cavNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesús baatsutu Herodes dyaque pureama jucuare, beru tura bacara ebari acuareque baya tibu. Ecuita cuanara tuque eje bucha juyaque cuejayaju bacatsu, Herodesra tuja yatuca tsehue bacara acuare Yusuja casa bamereyaque ayaque. Jadya tibutu Herodes tuja yacuaju Jesús dujutanahuaju pureama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Dutya aidya jutidya tujatu bacaduracuare. Jesusratu quemitsacuare ama ni riya piji buchique. ");
INSERT INTO cavNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Pae cuanaja huaraji cuana, cacuatsashati bahuityaqui cuanaque jadya tuna tuhua jucuare. Tunaratu Herodes eje buchapa Jesús equisaratiu, jadique pusha pusha cuejajacacuare ama. ");
INSERT INTO cavNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Tumetu Herodesra, sudaru cuana tuhua jucuare cuanara jadya ijillahuanacuare. Jutumerecuare tuna ejutuqui jidaque ecuarira jutuyaque, tuque ijariba ishu ijahue ayaquedya jutidya. Jadya aatsutu Herodesra cuadishanucacuare Pilato queja. ");
INSERT INTO cavNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Berutu Pilato, Herodes tsehue ujeu cabaticuare. Herodesra Jesús Pilato queja cuadishahuaju tatse jida junucacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jadya juatsutu Pilatora sitacuare pae cuanaja huaraji cuana, israelita cuanaja huaraji cuana, ecuita cuana jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—Micuanarari bemerenucahua riyaque ecuita eaqueja. Ecuita cuanapa rejari sicacaturaya. Micuanaja yacuajudya tuque bacadurahua. Arepa micuanara turapa cacuatsashati muibachine ama jadya aya ama bucha, era taa ri dadiya ama ni riya piji buchique ecajuchatique. ");
INSERT INTO cavNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesra tumebaedya dadihua ama tuque jidama ejuuque. Herodesra tuque ecajuchatique adebahuaque juatsu, eje bucha cuadishanucae jatsu tujatu aquena juhua rehua. Eje bucha iyemeree jatsu rique eau. ");
INSERT INTO cavNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Catsacatsa camadya tuque amereya. Catsacatsa ameretsu tuque inajacaya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Tunaja bahuetu jucuare Pascua ishu peadya ecuita etare apudaju erisi netiyaque inajaca. Ecuita cuanara ejeque inajacamereyaque camadyatu Pilatora inajacamerenicuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pilatora Jesús tuque inajacamereya jadya ayaju tuna dutya quiquetibunenucacuare: —¡Pajuani! ¡Iyemerecue Jesús! ¡Barrabás inajacacue! ¡Jesús inajacamereume! ");
INSERT INTO cavNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barrabástu quiyeti puji, ecuita cuana queja huaraji cuana muimerecarama amerequique jadya jucuare. Jadya tibu tunajatu etare apudaju nityacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatoratu inajacacara acuare Jesús. Jadidya tujatu ecuita cuana anucacuare datse: —Inajacaya rique era, catsacatsa ameretsu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Jadya bacatsu tuna quiqueterecuare jutidya: —¡Curusuju tatamerecue! ¡Tuhua pamaju! ¡Curusuju tatamerecue! ");
INSERT INTO cavNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Cueja quimisha ishu tuna Pilatora acuare: —¿Eje bucha juatsu? ¿Ai tujatu jidama achine? Era taa dadiya ama eje bucha juatsu iyemere ishuque. Catsa catsa ameretsu painajacamere, —jadya tuna Pilatora acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ecuita cuanatu dyaque jebuda quiquenucacuare Jesús iyemere ishu: —¡Curusuju tatamerecue! ¡Curusuju tatamerecue! Quiquejacacuare ama ecana. Dyaque quique quique juatsu tunajatu Pilato ejetanashacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilatoratu amena tunaja biji equedya acuare. —Micuanara acara aya equedya paju, —jadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Tumetu Pilatora sudaru cuana jadya acuare: —Neinajacacue Barrabás quiyeti puji, ecuita cuana queja huaraji cuana muimerecarama amerequique. Jesús neiyecue, israelita cuanara amerecara aya equedya, —jadya tuna Pilatora acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sudaru cuanaratu Jesús dujucuare tuhuaque iye ishu. Epu ebari juque cuinanayara tunajatu tsurutsacuare ecuita Cirene juque, Simón bacani. Eje queja japada juneniyaque tunajatu tsurutsatsu casada tsehue curusu mapamerecuare. Curusu mapa jadya aatsutu Simónra Jesús icuenenitya acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jetiama ecuita cuanaratu tupujudya acuare. Tuna tupujutu jetiama epuna cuana cuacuare Jesús jiteque peya inime, paya jadya juajeyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Tibene bajiyu aatsu tuna Jesúsra jadya acuare: —Mama ecana Jerusalénju aniya cuanaque, ique riya nerecada juya baatsu camadya ama nepacue. Nepacue, micuana, micuanaja bacua cuana jadya canerecatidadiyaque adebatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Micuanaja epuju aniya cuanaque tuna dyaque nerecada judadibuque. Dyaque jidama nerecada juya cabatitsu tunajatu epuna bacuama cuanaque jadya abuque: “Micuana micuana dyaque inime tsapema, epuna cuana bacuaqui cuanaque bucha ama. Tuna tuna huenanaya tunaja ebacua cuanaque canerecatiya baatsu. Micuana micuana huenanataqui ama” jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jerusalénju cuanaratu dyaque canerecatiya cabatitsu quiquebuque tumu ebari cuana emata cuana juque: “Ecuana dyaque nepacacacue ecuana iye ishu. Rihuitsu ecuana netyanacue”. ");
INSERT INTO cavNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cuati raramaque ni ecuana ruqueya, tume taa tuque ecuana yuneri cuitadya cuati eraraque ruqueya. Tumebaedya ique, jucha metseque ama dyaque canerecatiya; yutsumadya micuana jucha metse cuanaque dyaquedya micuana canerecatibuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jesús tsehue dujupeedya tunajatu acuare beta quiyeti puji ecatse curusuju tata ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Jadya junatie tuna jucuare uhua cuemusu “Emaju iyuca baeque” bacaniju. Tuhua junatitsu tunajatu Jesús curusuju tatacuare. Tumebaedya tunajatu quiyeti puji ecatse tatacuaredya, Jesúsja jida eque amaca, peya jani eque amaca jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tunara curusuju tatayajutu Jesúsra: —Tata, nerecabacue ecana. Apupashacue tunaja jucha. Baecua tuna eje bucha juyaque, —jadya acuare. Curusuju amena tatatsutu sudaru cuana dadu ijahue jucuare, Jesúsra jutuhua cuanaque ejeja ejeja juyaque tuna cama cajaquetibare ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jetiamatu ecuita tuhua jucuare capetatiyaque. Israelita cuanaja huaraji cuanaratu Jesús ijahue ijahuedya acuare: —Peya cuana inajacamere ishupa tuja casa aniya. Iyacua tuque tuta taca paquinajamereti, yuneridya tuque Mesías, Yusuja Emepeque juatsu, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sudaru cuanaratu ijahue ijahuedya acuare Jesús. Ijillahuanacuare tunaja tuque. Jipetitsu tunajatu iji ishu tyacara acuare uva nacaca patsedaque. ");
INSERT INTO cavNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Yuneridya ni mi israelita cuanaja ecuari, quicueneticue. Butecue curusu juque, —jadya tunajatu ijahue ayaque acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Shuracuare tunajatu curusuju Jesúsja iyuca dyaque ehueneque. Huenecuare tunajatu quisarati griego cuanaja yana eque, Roma juque huaraji cuanaja yana eque, israelita cuanaja yana eque jadya. “Riyaque ri israelita cuanaja ecuari” jadyatu ehuene jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Peadya quiyeti puji tuhua curusuju etata badeyaratu ijillahuanacuare Jesús. —Mique ni Mesías, Yusuja Emepeque, quinajacamereticue. Yatse dyadi inajacamerecuedya. Butyacue yatse curusu juque, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tura jadya ayaju bacatsutu peya quiyeti pujira nereda acuare: —¿Miratu Yusu mubaya ama? Yatse yatse tuque bae nerecada atahuaquedya. Yatse yatse tumebae majue juyaquedya. ");
INSERT INTO cavNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Yatse yatse yunerijudya nerecada ataya, yatsedya jucha metse tibu. Riyaque ecuita ri juchama, —jadya tujatu peya acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jadya peya aatsu tujatu Jesús jadya acuare: —Mique enaruqui juatsu, micue canerecabati tsehue ique bacue, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—Pusha amadya mique cuejaya. Iyacuadya yatse majuya. Eatsehuedyami Yusuja yacuaju judiruya, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Barepatyatu ijeti apunaterecuare. Tumetu dutya yahuaju apuda jucuare quimisha ura dyane, las tres chinequeja tupu. Yusuja etare juque junuda eshuraque Dyaque Muidaque penequiquetu patya chajatana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesústu majuyaque quiquecuare: —Tata, amena taa majuya. Ecue yatananatu miaqueja judiruya, —jadya tujatu acuare tuja Etataque Yusu. Jadya quisarati aatsutu Jesús amena ishu canajeti pidya juatsu majucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tuhuadyatu jucuare cien sudaru cuana cuatsashaquique. Jesús eje bucha majue juhua baatsutu jadya jucuare: —¡Pusha ama cuitadya tucueri riyaque ecuita jucha metse ama juhua! —jadyatu Yusu pureama ayaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jetiamatu ecuita cuana casitaticuare tuhua, jadya juyaque peta ishu. Jadya baatsu tuna dirunucacuare tunaja etare cuanaju. Tume diruyaquedya tuna yacua camiritiajecuare, tuna peya inime juyaque cabamereti ishu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesúsja umada eadeba cuanaque, epuna cuana Galilea eque tuque tajibe juchine cuanaque jadya tuna neticuare japada, dutya eje bucha juyaque peta juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Anicuaretu ecuita José bacani epu Arimatea Judea yahuaju anicuareque. Huaraji dyaque jida, emuiquetu jucuare. Tuquetu peya huaraji cuana tsehue ecadutyatiquedya jucuare. Arepa israelita cuanaja huaraji juya ama buchatu tuja jadya ama inime jucuare Jesús iyemerecara juhua cuana tsehue. Ejenecuare tujatu Jesús Yusuja enaruqui juishu ecuadishaque. ");
INSERT INTO cavNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tudyatu cuacuare Pilato queja. Junatitsu tujatu Pilato bacaticuare: —¿Ebutyamereu ama mira Jesús curusuju emaju badeyaque? Paishati caniju, —jadya tujatu Pilato aticuare. Pilatoratu acuare: —Butyameretsu emajuque cani epuruju ishaticue. ");
INSERT INTO cavNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tura jadya ayaju tujatu curusu juque butyamereticuare. Butyameretsu tujatu piruricuare sahuana tsehue. Ishaticuare tujatu tumu cani jadya ishu epuruju, tsumemaju. ");
INSERT INTO cavNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jesús majucuareque huecacatu jucuare israelita cuana canajara huecaca ishu cabajejeti huecacaju. Ejetsunue amatu canajara huecaca ishuque jucuare ni ejeque mere juishuque ama. Jadya tibu tujatu aijama jucuare emajaca emajuque pana bajeje aishu. ");
INSERT INTO cavNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Epuna cuana Jesús tajiaje jucuare cuanaque Galilea equeque cuanaratu Jesús emajuque ishatanayaju bacuare. Baticuare tuna eje bucha ishae tuna emajuque ayaque. Petacuare tunajatu Jesús emajuque ishatanayaju. ");
INSERT INTO cavNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jadya juatsu tuna dirunucacuare tuna junachineque etareju. Etareju judirunucatsu tunajatu bajejedirucuare ijimeda cuanaque, esamaqui teditedi ishu cuanaque israelita cuanaja emaju cuanaque ishama jariju tsume bahue jucuare cuanaque. Tume cuanaque bajeje amena aatsutu epuna cuana canajaratibunecuare canajara huecacaju, tumeque huecaca ni ejeque buchique mere juishuque ama jucuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Amena dumicu huecacaju, semanaju icueneque huecaca, apudajudya cuitatu epuna cuana cuahuecanucacuare Jesús emajuque tumu cani epuruju ishatanachineju, ijimedaque tunara bajejechineque duju juyaque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Junatiyara tunajatu banaticuare tumu ebari cani tsecue penequique peya queja amaca etecu. ");
INSERT INTO cavNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nubinaticuare ecana caniju. Nubitsu tuna banaticuare ama Jesús emajuque jarayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Baecua tuna jucuare eje bucha juhuaque. Ejecutana tuna jucuare. Tume tunajatu bacuare beta ecuita jiuque ecatse tuna peque netiyaju. Ejutuqui tiquida tsehue tatse ecajututi jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Tuna bacue dyaque bajida cuita jucuare. Yahua queja huipuchitana ecana jucuare bajida juatsu. Tumeque ecuita ecatsera tuna acuare: —¿Eje bucha juatsu tuque micuana emajuque cani ducu sareya chacha juneniyaque? ");
INSERT INTO cavNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rehua ama rique. Chachatu netitsuranucahua. Neadebacuedya eje bucha tura micuana Galileaju jariju cuejahuaque: ");
INSERT INTO cavNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“IQUE ECUITApa ecuita jucha arida cuana queja catyati atanaya. Curusuju tatatsu tunara iyeya. Netitsuranucaya quimisha huecaca juatsu”, jadya tura micuana cuejachine, —jadya tuna ecuita ecatsera acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jadya ayaju tunajatu adebacuare Jesúsra quisarati achineque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jadique adebatsu tuna Jerusalénju dirunucacuare tumu cani juque cuinanatsu. Judirutsu tunajatu cuejadirucuare dutya tunara eje bucha batihua cuanaque Jesúsra mepehua cuanaque, peya ecuita cuana jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Riyaque cuatsabiji ecuadisha cuanaque cuejaquique epuna cuanatu jucuare: María, Magdala epu juque; Juana; María, Santiagoja ecuaque; peya epuna cuana Jesús tajiqui juchine cuanaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ecuadisha cuanaratu ejenetaqui ama bacuare epuna cuanara cuejayaju. “Riyaque epuna cuana rena ejecutana jutidya. ¡Eje bucha jue ni tu tunara cuejaya bae juma!”, jadya tunajatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jadya ama buchatu Pedro netitsuratsu tsajaja ajecuare caniju, yuneri, yuneri ama jadique bahue jucara juatsu. Tuhua junatitsutu remenaticuare educuju peta ishu. Bacuare ama tujatu emajuque, sahuana cuana camadya. Eanajacataquetu dirucuare etareju, eje bucha tumeque juhuaque baatsu. ");
INSERT INTO cavNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tumeque huecaca nucadyatu Jesúsja emepeque ecatse cuacuare Emaús bacani epuju. Tumeque eputu jucuare peadya tunca peadya earacana kilómetro dyane Jerusalén eque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Cuayaquedya jutidya tatse cuatsabiji juajecuare eje bucha juhua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Tuque eje bucha juchineque adebatsu cabacaduratiajeyaju tatse, Jesúsra cuitadya jipeajecuare. Adaditsutu tatse tsehuedya cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Adeba piisi ama tatsejatu acuare, tunara babanicuare bucha ama cabamereticuare tibu. ");
INSERT INTO cavNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tume tatse Jesúsra bacaduracuare: —¿Ai metse cabacaduratiajeya? ¿Eje bucha juatsu metse peya inime cuita baya? —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Cleofas bacaniratu quemitsacuare: —¿Baecua jatsumi Jerusalénju eje bucha inime juchineque? Dutya taa tuna riya cuita juchineque bahue. ¿Mique peadya camadya ni mi baecua riyaque quisarati? ");
INSERT INTO cavNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Aitu eje bucha juchine? —jadya tatse Jesúsra acuare. —Jesús Nazaretju anichineque juchineque mique jadya aya. Tuquetu Yusu equeque quisarati cuejaquique juchine. Turatu anenichine jetiama ai ni ejeque ecuitaja ataquique ama, Yusuja peadya ataquique. Yusuja quisarati tujatu cuejacuejanichine. Tura ayaque baatsu, bacatsu jadya tuna dutya jujerira adebachine jida tuyuque ecuita. Anenichine tujatu Yusuja biji eque camadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pae cuanaja huaraji cuanara, ecuana naruqui cuanara jadyatu tuque ujeu bacuare. Inamerechine tunaja tuque. Inameretsu tunajatu iyemerechine. Sudaru cuana queja tuna curusuju tatamerechine. ");
INSERT INTO cavNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ecuanajatu inime juchine tuque Mesiasra cuana ecuana israelita cuana ijahue ijahue atayaque cuinanasha ishuque bucha datse. Amenatu quimisha huecaca tuque iyetanachineque. Ecuana bacue aninucachine jucuare baedya jutidya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","“Eje bucha tuputillataqui ama ecuana inime baya. Riyaque apudajudya huecacama jarijutu cuahua umae epuna cuana caniju Jesús emajuque bajejera. ");
INSERT INTO cavNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Aijama tuna emajuque batihua. Aijama baatsu tuna ecuana queja judiruhua. Cuejahua tunara ecuana eje bucha batihuaque. Cuejatihua tunara ecuana: ‘Ecuita jiuque patu bahua, Yusu tsahuaquique ecatse. Cuejahua tatsera ecuana: “Jesúspa chacha” jadya’. ");
INSERT INTO cavNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ecuanaja eadebaque ecatse cuahua emajuque ishatanachineque petara. Jesús emajuque tatsejatu bahua ama, —jadya tatsejatu Jesús cuejaajecuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Tatsera cuatsabiji ayaque bacatsu tatse Jesúsra acuare: —¡Metsejatu cuejayaju jaraya ama cuitadya! Metsera Yusu equeque cuitadya quisarati cuejaqui cuanara cuejahuaque pana adeba ahuaque juatsu taa metse bahue ejuu jadya judaditaquique. ");
INSERT INTO cavNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Canerecati, maju jadya ishuque ama jatsutu Mesías juchine, Yusuja yacuaju muitama jarijudya? —jadya tujatu ecatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Cuejatibunecuare tujatu ecatse dutya tuque eque huenetanacuareque Yusuja quisaratiju. Moisésra huenecuare eque tujatu ecatse cuejatibunecuare. Cuejaajecuaretu Yusu equeque quisarati cuejaqui cuanara huenecuare cuanaque. Jadya tsehue tujatu ecatse adebamerecuare yuneri cuitadya Yusura eje bucha judadiya jadya acuare eque cuitadya judadichineque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tuna cuayaque epuju junatitsutu Jesús cuaya jiudya jutidya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tatse tatse canerecaticuare tuhuadya tuque tatse tsehuedya junatishacara aatsu. —Rehuadya anicue yatse tsehue. Amenari chinehua. Apunayari amena, —jadya tatsejatu acuare. Jadya juatsutu Jesús nubidirucuare tatse tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mesaju tuna anibutecuare araara ishu. Ara ishu tujatu pan inacuare. Pan inatsutu Jesúsra Yusu acuare: —Yusurupai mique aya, Tata, mira ecuana jeeque earaqui tyahua tibu. Yusurupai jadya aatsu tujatu ecatse tyacuare cuesitsu, cuesitsu. ");
INSERT INTO cavNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jesúsra pan cuesitsu tyayaju tatse chamacama Yusura adebamerecuare tuque Jesúsque. Jadya juatsutu aputacuare tatse tsehueque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Cacuejaticuare tatse: —Pusha ama cuitadya yatse jida cabatihua. Anajacata ishu tuque yatse ahua, tura Yusuja quisarati pana cueja abeabeyaju, —jadya tatse cacuejaticuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jadya juatsu tatse mesa juque yume netitsura juatsu dirunucacuare Jerusalénju. Judirunucatsu tatse yume barediru cuitadya jucuare peya cuana peadya tunca peadya earacana Jesúsra mepehua cuana queja, tumebaedya peya cuana Jesús queja catyatihua cuana queja. ");
INSERT INTO cavNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tatse tuhua nubidiruhuaju tatse tuhua jucuare cuanara jadya atsacuare: —Pusha amadyatu Ecuana Cuatsashaquique netitsuranucahua. Chacha tuque. Pedro quejatu cabameretihua, —jadya tunajatu ecatse atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jadya atsayajudya tatsejatu cuejacuare tatse Emaúsju cuayaque eje bucha juhuaque. Jadya tatse cacuejaticuare: —Jesúsra pan cuesiya baatsu tuque yatse chamacama adebahua. ");
INSERT INTO cavNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tuna quisaratiya jarijutu Jesús cuitadya cabamereticuare tuhua tuna queja. —Netsapeume inime, —jadya tujatu ecana acuare isarayaque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Tuna bacue dyaque ejecutana cuita, bajida jadya jucuare. Yatanana cuana baya bucha tunajatu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—¿Eje bucha juatsu micuana dyaque cuita ejecutana? ¿Eje bucha juatsu micuanara ique ama bucha baya? ¿Eje bucha juatsu micuana cabacaduratiya “¿Airi riyaque?”, ique ejuuque adebaya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nepetacue ecue emetucu, ecue ehuachi jadya. Idya cuitadya ique. Nejabacue. Nepetacue ique. Yatananajatu aijama erami ni etsau micuanara ecue baya bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jadya cuejatsu tujatu ecana bamerecuare emetucu, ehuachi jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jadya bacatsu tuna anajacatacuare. Pureama ecana jucuare. Pana cueyane ama jari tunajatu acuare tuque Jesúsque. Pana caadebamereti juishu tujatu ecana jadya acuare: —¿Aniya micuanaja rehua ai ara ishuque? —jadya tujatu ecana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jadya juyaju tunajatu tyacuare peadya cuesi jae ecuahuique, huaja jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tyayaju tujatu inatsacuare. Inatsu tujatu aracuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jadya juatsu tujatu ecana acuare: —Ique iyetama jariju, ique micuana tsehue jariju, micuana cuejachine: “Yusura tuja quisaratiju cuejacuare bae cuitadya ique judadiya, Moisés eque, Yusu equeque quisarati cuejaqui cuana eque, Salmos cuana huenequi jucuare cuana eque jadya”. Riya cuita eje bucha juchine cuanaquetu dutya era micuana jadyatu judadiya jadya achine equedya juchine, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jadya juatsu tujatu ecana huecashacuare Yusuja quisarati ehueneque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—Riyaquedya tu Yusura jadyatu judadiya jadya acuareque. Riyaquedya tu jadya ehueneque: “Mesías tu canerecati, maju jadya ishuque. Quimisha huecaca emajuquetu chacha netitsuranucabuque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mesiasja ebacaniju tuna cuabuque dutya queja quisarati cuejara. ‘Mesías queja catyatitsu necacuareticue inime, Yusura micuanaja jucha cuana tilla ishu’ jadya tuna cuejamerebuque. Cuejatibunebuque tunajatu Jerusalén eque. Tuequedya tuna dutya queja cuadishabuque”. Riyaquedya tu Yusura jadyatu judadiya jadya acuareque. ");
INSERT INTO cavNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","“Micuanaratu bahuadya ique eje bucha juhuaque. Jutaquiju peya cuana necuejacue dutya micuanara bachineque, bacachineque jadya. ");
INSERT INTO cavNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Eratu cuadishaya micuana queja Ecue Etatara micuanaja cuadisha ana ahuaque. Neanicue jari rehuadya Jerusalénju ebarucueque Micuana Casaturaquique juetiya tupu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jadya juatsu tuna Jesúsra dujucuare epu ebari juque, peya queja amaca Betania piji dyane. Emetucu tujatu tuna dyaque huesacuare. Jadya aatsu tujatu ecana acuare: —Yusuja casa micuana tsehue paju. Yusura necasaturacue. ");
INSERT INTO cavNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jadya quisarati aatsutu dirucuare tuna quejaque. Barepajutu dujutanacuare. ");
INSERT INTO cavNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Barepaju cuaya baatsu tunajatu pureama acuare: —¡Dyaque jida taa Jesús! ¡Dyaque casada, emui jadya taa tuque! Tuque pureama au amena aatsu tuna dirunucacuare Jerusalénju tunaja pureama tsehue. ");
INSERT INTO cavNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Dutya huecaca ecana Yusuja etareju tuque pureama ajacama jucuare. Jadyatu jucuare. Riya tupu camadya. Lucas");
INSERT INTO cavNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Yuequedya, yahua iyama jarijutu Jesucristo anicuaredya amena. Tuquetu QUISARATI jucuare, YUSU ADEBAMEREQUIQUE jadique. Tuquetu Yusu tsehuedya anicuare. YUSU EJE BUCHIQUE ADEBAMEREQUIQUE tu jucuare. Yusu cuitadyatu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Yahua iyama jarijutu tuque Yusu tsehuedya anicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Betaradya tatsejatu Yusu tsehue dutya aniyaque iyacuare. Tura ni iyaquena ama juquena juhua dutya aniyaque, ni ai buchiquetu eaniu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riyaque YUSU EJE BUCHIQUE ADEBAMEREQUIQUE tu ecuita cuana iyacua ani tyaquique. Tura ecuana bamereya Yusu queja eje bucha judirue juishuque, ude tsehue udatsu ediji ebamereu bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Turatu Yusu adebamereya tuque adeba baecua juhua cuanaque, apuda ducu huecadaque ejuu bucha. Tuatsehue cahuaitiya cuanaratu casa secataqui ama baya, apuda ducu juneniya bucha cuanara. ");
INSERT INTO cavNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yusuja quisarati Jesúsja cuejatibunema jarijutu anicuare Yusuja peya ecuadishaque. Tumequetu Juan bacani jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Tuquetu icueneta junacuare Jesús eje buchique cueja ishu, dutyaja tunaja Jesús queja nimee juishuque emajaca ani ishu. Cudatitsu eju cuayaque adebataqui ejuu bucha, jadiya tu Jesús eque Yusu queja judiru ishuque adebataqui. ");
INSERT INTO cavNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan amatu EUDAQUIQUE jucuare. Tuquetu junacuare tumeque EUDAQUIQUE eje buchique cuejara cuita camadya. ");
INSERT INTO cavNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Juan tuque eje buchique cuejaya tuputu Jesús yuneri cuita EUDAQUIQUE caadebameretihuie jucuare. Tuquetu amena dutya riyaque yahuaju cuanaque Yusu adebamerehuie jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","YUSU ADEBAMEREQUIQUE, QUISARATIdyatu riyaque yahuaju junacuare. Rehuadyatu aninacuare. Arepa turadya yahua iyahua ama bucha, yahuaju dutya ai aniyaque iyahua ama bucha, dutyara jujeri tunajatu jida ama batsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tuja yahuajudyatu junacuare, tuja ata israelita cuana aniyaju. Jadya ama bucha tuna dutya jujeri tuaqueja catyaticarama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Peya cuanara bacue jida tsehue batsacuare. Tunadya tuna tuaqueja catyaticuare. Tunadya tujatu ecana Yusu jabacua ameredadihua. ");
INSERT INTO cavNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tuja ebacuaque tura ecuana amerehua, ecuanaja etatara ecuana susuqui tsehue baatsu bucha ama, aiju cabijiserititsuque ama. Yusura cuitadya ecuana tuja ebacuaque amerehua. ");
INSERT INTO cavNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jesucristo YUSU ADEBAMEREQUIQUE tu ecuita jucuare. Riyaque yahuajutu ecuana ducu aninacuare. Arepa ecuana jucha arida ama bucha tura ecuana dyaque iyuhueda bahua. Tura ecuana Yusuja quisarati neri cuejahua. Ecuanara tujatu jidaque bacuare, casa tuja aniyaque, tuque Yusuja Ebacuaque peadyaque juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juan Ecuita Cuana Utsaquiratu jetiama ecuita cuejacuare Jesúsja quisarati. Jesús tuaqueja junahuaju tujatu acuare: —Jeequedya micuana era jeya jadya cuejachineque. Ique ejitaju juma jarijutu tuque anicuaredya, arepa ique tuja icueneque paju ama bucha. Jadya tibudyatu tuque dyaque emuique, ique bucha ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesúsra ecuana dyaque iyuhueda bajacaya ama, arepa ecuana cajuchatiya ama bucha. Baajeyadya jutidya tura ecuana jida tsehue, tura ecuana dyaque iyuhueda baya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moisés equetu Yusura ecuanaja baba cuana tuja cacuatsashati cuana adebamerehua eje bucha anie juishuque. Jesucristo eque bacue ecuana Yusura bamerehua tura ecuana dyaque iyuhueda bayaque, arepa ecuana cajuchatiya ama bucha. Tuque equedya ecuana Yusura adebamerehua tuja quisarati yunerique. ");
INSERT INTO cavNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ni ejejadya jutidya tu Yusu eba. Jadya ama bucha tu peadyaque Ebacuaqueja camadya eba. Tuquetu Yusu tsehueque camadya. Tuquetu Yusu Etataque cuitadya. Tura cuitadya ecuana Yusu eje buchique bamereya. ");
INSERT INTO cavNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Israelita cuanaja huaraji cuanatu bahue jucara jucuare Juan aique. Jadya tibudya tunajatu Jerusalén equeque cuadishacuare tuatsehue quisarati ishu. Cuadishacuare tunajatu umae pae cuana, pae cuana tsahuaqui cuanaque levita bacani cuana jadya. —¿Ai mique? ¿Midyami Mesías Yusuja Emepeque? —jadya tunajatu bacaduramerecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Junatitsu tunajatu bacaduranaticuare. Juantu tuta tacadya jutidya tuque eje buchique cacuejaticuare: —Ique Mesías ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tume tunajatu yudijidya bacadura anucacuare: —¿Midyami Elías, Yusu equeque quisarati cuejaquique? —jadya tunajatu acuare. —Aama, ique Elías ama. Yudijidya tuna bacaduranucacuare: —¿Midya ni taa mi Yusu equeque quisarati cuejaquique ecuanara ihuayaque? —jadya tunajatu acuare. Tura tuna quemitsacuare: —A, aijama. Ique ama micuanara ihuayaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tudya tunajatu anucacuare: —¿Ai jatsu mique? Cuejacue ecuana, ecuana cuadishaqui cuanaque ecuanaja cuejadiru ishu. ¿Mique aique? ¿Ai juyaque? jadique.? ");
INSERT INTO cavNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Tudya tuna Juanra quemitsacuare: —Ique tsecada eje uma piji anitaya cuana queja quisarati cueja juyaque. “Nequihuaticue Ecuana Cuatsashaquique junayaju ishu. Jida tuyu nejucue, ediji benubenuque etuyune ejuu bucha,” jadya tuna cuejaya, Isaiasra cuejacuare baedya, —jadya tuna Juanra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseo cuanara cuadishaya cuanaratu anucacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Bacaduracuare tunaja tuque: —¿Eje bucha juatsu jatsu tuquemi ecuita cuana utsaya, ai mi Mesías, ni Elías ni Yusu equeque quisarati cuejaquique ecuanara ihuayaque batu di taa? —jadya tunajatu Juan acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jadya bacatsu tuna Juanra acuare: —Era tuna ena tsehue camadya utsaya, inime cacuaretihua jadique adebataqui juishu. Peya bacue aniya micuana ducu rehua. Ique buchique ama dyaque inime metseque. Tumequetu micuanara adebaya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Tsunutaya amatu riyaque yahuaju mere catibuti ishu. Tuque baatsu ique ni aishuquedya jutidya; mere puji tuja patrón tsehue beta tupu ama ejuu bucha jutidya ique, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Riyaquetu epu Betania bacaniju jadya jucuare, Jordán cueri yueque macare. Tuhua tujatu inime cacuaretiya cuanaque utsautsanicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jadya juu jadya junucatsutu Juanra bacuare Jesús tuaqueja jutiyaju. Tuque batsatsutu Juanra acuare tuhua jucuare cuanaque: —Nepetacue. Jeequedya ri UHUISHA BUCHA IYETAE ATADADIYAQUE. Yusuja Ecuadishaque riya, ecuanaja jucha cuana apupasha ishuque. ");
INSERT INTO cavNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jeequedya tuque quisarati achine peya huecaca ique jadya juya patya: “Tsunutaya ama tu riyaque yahuaju peya dyaque inime metseque mere catibutiyaque. Tuquetu dyaque inime metseque, ique buchique ama. Ique ejitaju juma jarijutu tuque anihua”. ");
INSERT INTO cavNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Icuene ique baecua juchine Jesús Mesiasque. Jadya ama buchatu era ecue ata israelita cuana Mesías queja catyatishacara achine. Jadya tibudya tuque utsachine inime cacuaretiya cuanaque, —jadya ecuana Juanra acuare: ");
INSERT INTO cavNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Juanra ecuana cuejanucacuare tura tuja yatuca eque bahuaque: —Huei jiuque tuque Yusuja Espíritu barepa juque buteyaju bachine. Jesús dyaquetu butechine. Jadya baatsu tuque ecue chamacama inime jutichine Jesús Mesiasque. ");
INSERT INTO cavNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jadya bama jariju ique baecua juchine Jesús aique. Yusura icuenetadya cuejacuare: “Ecue Espíritu tuquemi ecue Emepe dyaque eje tupu buteyaju badadiya. Tuque dyaque tuque ecue Espíritu anibuteya. Iyacua mique cuadishaya ecuita cuana ena tsehue utsara. Mira tuna utsaya inime cacuaretihuaque adebataqui juishu; jadidya tuque tyadadiya ecue Espíritu, ecuique jadya adebataqui juishu”, jadya ique Yusura cuejacuare icuenetadya. ");
INSERT INTO cavNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yusura cuejacuare bae cuitadya tuque bachine. Yuneri cuitadya micuana cuejaya Jesús Yusuja Ebacuaqueque, —jadya ecuana Juanra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huecacanucatsutu Juan tuhua junucacuare yatse tsehue. ");
INSERT INTO cavNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Bacuare tujatu Jesús cuetiyaju. Petadaditsu yatse Juanra jadya acuare: —Nepetacue. ¡Tumequedya tu UHUISHA BUCHA IYETAE ATADADIYAQUE! —jadya tura yatse acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jadique quisarati bacatsu yatse Jesús tsehue junenitibunecuare Juan jacatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesústu etibene queja cabajiyuti jucuare. Cabajiyutitsu tura yatse batsacuare tuque tupuju cuayaju. —¿Ai tuque metse sareya? —jadya tura yatse atsacuare. Yatseratu quemitsacuare: —Ebahuityaquique, ¿ejumi aniya? ");
INSERT INTO cavNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—Nejecue. Necuara eju ique junachineju, —jadya tura yatse acuare. Jadya ahuaju yatse tuatsehuedya cuacuare. Las cuatro chinequeja ecuana junaticuare tuque juticuareque etareju. Tuhuadya ecuana tumeque etareju tuatsehue anichinepecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andrés tsehue yatse jucuare, Simón Pedro tsehuequi tsehue. Icuene yatse Juan tsehue junenicuare. Tuequedya yatse Jesús tsehue junenitibunecuare, tura bahuityayaque cabahuityati ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jesús tsehue quisaratitsutu Andrés masadama cuacuare tuatsehuequi Simón sarera. Banatitsu tujatu anaticuare: —Mesías tuque yatse bahua, —jadya tujatu anaticuare. (“Cristo” jadique tu Mesías.) ");
INSERT INTO cavNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andresratu Simón dujucuare Jesús queja. Tudyatu Jesúsra batsatsu jadya atsacuare: —Miquemi Simón bacani, Jonás bacanija ebacuaque. Iyacua tuque micue peya ebacani iyaya. Cefas bacani mi juya, —jadya tujatu Simón acuare. (Cefas tu “Pedro” jadique griego yanaju, “Tumu Ebari” jadique.) ");
INSERT INTO cavNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huecacanucatsutu Jesús jucuare: —Cuaya Galileaju —jadya. Tuhua cuayara tujatu tsurutsacuare ecuita Felipe bacani. Tuque tsurutsatsu tujatu —Jecue. Eatsehue junenicue, —jadya atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipetu anicuare epu ebari Betsaida bacaniju, Andrés, Pedro ecatse aniyaju. ");
INSERT INTO cavNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","—Jejee, juneniyadya miatsehue. Jadya juatsutu Felipe cuacuare Natanael sarera. —Tsuruhua tuque yatse Mesías Yusuja Emepeque. Bérutu Moisésra huenecuare Yusura cuadishadadiyaque jadya ayaque. Tumebaedyatu Yusu equeque quisarati cuejaqui cuanara huenecuare tuque jadya ayaque. Iyacua ecuana bahue tuque aique. Jesús tume; Joséja ebacuaque, Nazaret juque jeyaque tume, —jadyatu acuare Natanael Felipera. ");
INSERT INTO cavNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaelratu acuare: —¡Eje bucha jadya jue tu ejuu! Aijama tu ai jidaque Nazaret juque. Miquemi cuji cuita eju, —jadya tujatu acuare: —Necua. Baticue, —jadyatu Felipera acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesusratu batsacuare Natanael tuaqueja cuayaju. Batsatsu tura ecuana acuare: —Riya junayaque ri yuneri Israel eque ejuracanaque neri. Tuquetu ecuita tuyuque. Tujatu ni ejeque buchique ijahue abaecua, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaeltu cabacatiajecuare jadya ayaju. Cabacatitsu tujatu Jesús isaracuare: —Bandía. Bama taa micue ique. ¿Eje bucha adebae aatsumi ique eba bucha cuita quisaratiya? —jadya tujatu Jesús acuare. —Yusuja casa eque mique icuenedya bahua ique bana ishu mique Felipeja ihuarama jarijudya. Arepa ique tuhua miatsehue ama juhua ama bucha, Yusura bamereyaju mique bahua higuera aputa emaque juaniyaju, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jadya ayatu Natanaelra acuare: —Ebahuityaquique, miquemi Yusuja Ebacuaque. ¡Midyami Israel eque ejuracana cuanaque narudadiquique! ");
INSERT INTO cavNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesusratu acuare: —¿Miratu ique Mesiasque ejenehua, era mique higuera aputa emaque juaniyaju bahua jadya ayaju, era ecuita cuanaja ataquimaque eau jadique bahue juatsu? Dyaquedyami eaqueja nimee judadiya, dyaque ibedaque era ayaju baatsu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tuequedya ecuana Jesúsra acuare: —Pusha amadya micuana cuejaya. Yatuca cabapetitsu tuque micuana barepa epacashatana babuque. Babuque tuque micuana barepaju Yusu tsahuaqui cuanaque ique merera buteyaju tsurayaju jadya. Babuque tuque micuana ecana IQUE ECUITA mere juyaju, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Jadya juu jadya juatsutu beta huecaca anicuare caquemiti ishuque chine Canáju. Tumeque eputu Galilea yahuaju jucuare. Jesús, Jesúsja ecuaque, ecuana tura mepehua cuanaque jadya ecuana chine ishu cuacuare, dutyadya ecuana cuaishu cuejatanahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ecuana tuhuajudya tunajatu uva nacaca esasanashaque eijiqui terecuare chine terema jarijudya. Tunara cuejahuajutu ecuaquera cuejaticuare Jesús: —Aijama patunajatu amena eijiqui uva nacaca esasanashaque, —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusratu acuare: —¿Aishu jatsu mira ique tumeque cuejaya, mama? Juetima jari tuque ecue Yusuja casa bamere ishuque, —jadya tujatu acuare ecuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jadya tura aya ama buchatu ecuaquera quijimereti puji cuana acuare: —Ecue ebacuara cuejaya equedya nejucue. ");
INSERT INTO cavNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Anicuaretu tuhua shucuta sura tumu bucha pajie ea cuanaque. Aridatu sura cuana jucuare. Quimisacarucu tunca jadya ama juatsu cien litro tunajatu sura cuanaju ena isha bahue junenicuare. Israelita cuanajatu ena tuhua eishaque tsume bahue junenicuare emetucu cuana cutsati ishu, emaricaca cuana jadya, tunaja bahue utsa ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Tudyatu Jesúsra quijimeretiya cuanaque acuare: —Nejequeshabarecue jida ena tsehue tumeque sura cuana, —jadya tujatu ecana acuare. Jequeshacuaredya tunara. Jida cuachacuacha tuna sura cuana ena tsehue jequeshabarecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Amena tunara jequeshahua baatsu tuna Jesúsra acuare: —Iyacua netsehuacue riya piji. Nechibamereticue chine metseque. Tura jadya ahuaju, tunajatu riya piji tsehuacuare. Tsehuatsu tunajatu chibamereticuare chine metseque. ");
INSERT INTO cavNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Enatu cabapeticuare uva nacaca esasanashaque. Chine metseratu chibatsacuare. Tuquetu baecua jucuare eje bucha juhuaque, aira ena uva nacaca esasanashaque cabapetishahuaque. Quijimereti puji cuana camadya tuna bahue jucuare, tunaradya sura cuanaju ena jequeshabarehua tibu. Dyaque jida cuita baatsu tujatu huanequi juhuaque ihuaracuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Amena huanequi juhuaque jutihuajutu chine metsera atsacuare: —Icuene cuita tuque ecuanaja eihuara cuanaque uva nacaca esasanashaque dyaque jidaque ijimere bahue. Tunara amena nime tupu ijihuaju tuque ecuana amena uva nacaca jida cuitaque ama ijimere bahue. Mira taa ecana jadya ama ahua. Chine terehuie jutidyami uva nacaca dyaque jidaque cuinanashahua, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesúsra jadya ahuaque baatsu, ecuana tura mepehua cuanara tuque ecuana ejenecuare tuja Yusuja casa aniyaque. Caná Galilea yahuajutu Jesúsra ena cabapetishacuare uva nacaca esasanashaque. Tuhua tujatu ametse acuare ni ejeque ecuitaja ataquique ama. Tuhuatu cabameretimetse jucuare tuque Yusuja casa tsehueque. ");
INSERT INTO cavNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jadya juatsutu Jesús Capernaumju dirucuare. Ecuaque, tuatsehuequi cuana tsehue jadya tuna dirucuare. Ecuana tumebaedya dirucuare tuna tsehue. Tuhua ecuana anidirucuare eje uma huecaca cuana. ");
INSERT INTO cavNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Pascua chine bacanitu piji dyane cuita jucuare, ecuanaja baba cuana Yusura Egipto juque cuinanashacuareque adeba ishuque. Jadya tibudyatu Jesús cuacuare Jerusalénju. Ecuanaratu tajiajecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tuhua junatitsutu Jesús cuacuare Yusuja etareju. Nubinatitsu tujatu ecana banaticuare jetiama Yusu tyaishu juye, uhuisha, huei jadya catyati juya cuanaque. Tumebaedyatu bacuare chipiru cuare juya cuanaque. Tume cuanaratu peya epu cuana juque chipiru cuarecuare. Yusu mui ishuju, jadya jutaquiju ama tuna jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jadya baatsutu Jesús tuna tsehue cahuaiticuare. Cahuaititsutu capicaticuare huacabiti. Huacabiti tsehue tujatu ecana pana ijehuecuinatilla acuare tuhua Yusuja etareju catyati juya cuanaque. Tumebaedyatu juye, uhuisha cuana catyati juya cuanaque ijehuecuinacuare. Dacashatillacuare tujatu chipiru amena cuarehua cuanaque. Tipacatillacuaretu mesa cuana. ");
INSERT INTO cavNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jadya tujatu acuare huei catyati puji cuana: —Nedujutillacue micuanaja dutya ai rehua aniya cuanaque. Riyaque etare ri ecue Etata mui ishuque. Mercado ama riya. Catyati, bacabaca jadya ishuque ama riya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jadya juya bacatsu, ecuana tura mepehua cuanara tuque ecuana adebacuare Yusuja quisarati jadya ehueneque: “Yusu, micue etare tuque dyaque muibaya. Ejequeja buchique tuque bijidamaduramerecarama aya” jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jadya Jesúsra ahuaque baatsutu israelita cuanaja huaraji tuhua jucuare cuanara Jesús acuare: —¿Airami casa tyahua Yusuja etare juque ijehuecuinatilla ishu? Acue Yusuja casa bamere ishu yuneridya tura mique jadya aishu cuatsashahuaque ecuana ejenemere ishu, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesúsra tuna quemitsacuare: —Arepa micuanara Yusuja etare rihuishaya ama bucha, eratu quimisha huecacaju nityatsuradadinucaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—¡Eje bucha nityatsuranucae ni tuquemi quimisha huecacaju anucama! Pushi tunca shucuta earacana mara tuna tsunutacuare riyaque etare ayaque, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Tunaja adebataquique amatu Jesúsra jadya acuare quisarati. “Yusuja etare” jadya Jerusalén juque etare ama tujatu jadya acuare. Tudya cuitadyatu jadya caticuare, tuque Yusuja eaniqui juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jadya tibudya Jesús emajuque chacha netitsuranucahuaju ecuana tura mepehua cuanara adebacuare tuja quisarati. “Yusuja quisarati tu ehuene yuneridya Jesús majutsu chacha netitsuranucabuqueque. Jesúsra ecuana icueneta cueja ahuaque tu yuneriquedya”, jadya ecuana jucuare tuque emajuque netitsuranucahuaque baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jesús tunajatu Jerusalénju Pascua chine ishu jetiamara ejenecuare tuque Mesiasque. Yusuja casa tsehue ayaque baatsu tunajatu ejenecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesúsra tuna adebacuaredya tuna yuneri ama tuaqueja catyatiyaque. Tura Yusuja casa tsehue inimeradya jutidya ayaque bacara aatsudya jutidya tupujudya ayaque adebaya tibu, tura tuna ejitaju cuita “Ique Mesías” jadya acuare ama. ");
INSERT INTO cavNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ni ejeja buchiquetu tuque ecuita cuana eje buchique cuejataqui ama jucuare, tura cuitadya ecuita cuana eje bucha inime cadujutiyaque, inime tupuyaque jadya adebaya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Anicuaretu ecuita Nicodemo bacani. Tuquetu huaraji israelita cuanaja emuique jucuare. Fariseo tu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Chinejutu Jesús tsehue quisaratira cuacuare. Junatitsu tujatu isaranaticuare Jesús: —Banuchi, Ebahuityaquique. Bahue ecuana mique bahuitya bahuitya pujique, mique Yusuja Ecuadishaque. Ni ejera bucharatu mira Yusuja casa tsehue ayaque eau ama, Yusura casa tyayaque ama juatsu, —jadya tujatu anaticuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—Pusha amadya mique cuejaya. Eje bucha narue ni tu Yusura ama ejeque yudijidya cananatinuca junucamaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—¿Eje bucha cananatinucae ecuana ejuu amena esirique? ¡Eje bucha jadya jue ecuana ejuu! ¡Eje bucha nubinucae ecuana ejuu ecuana susuqui cuanaja ecarecaniju yudijidya cuinananuca juishu! —jadyatu Nicodemora acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesusratu acuare: —Yusuja Espíritu eque iyacuanemaquetu Yusura naruyaju eje bucha nubidirutaqui ama, tumebaedya utsamaque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ecuana susuquija ecarecani juque cuinanahuaju ecuana ecuana baqui cuanaja ebacuaque. Yusuja Espiritu eque eiyacuaneque bacue ecuana, Yusuja ebacuaque, Yusuja Espiritura ecuana Yusu jaque amerehua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Bape baume riyaque quisarati, cananatinucataqui mique jadique. ");
INSERT INTO cavNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Cuejijitu riyaque yahuajura ni ejera buchara naruya ama. Tuuuyaju bacatsu, ejaqui cuana bucucushayaju baatsu tuque ecuana cuejiji adebaya. Jadya ama bucha ecuana adebaya ama ejuque cuinanahuaque ni eju netidiruyaque. Tumebae cuitadyatu Yusuja Espíritu eque cananatinucahua cuanara adebaya ama tuna Yusura eje bucha iyacuanee ahuaque. Jadya ama bucha tunajatu tuja casa bayadya, —jadyatu Jesúsra Nicodemo acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—¿Eje bucha cuana taa? Adebataqui ama tuque baya, mira ique riyaque cuejayaque, —jadyatu Nicodemora acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—Mique taa mi Israel eque ejuracana cuanaque bahuityaquique. Mira taa tuna Yusuja quisarati bahuityaya. ¿Eje bucha juatsu jatsu tuquemi cueyanetaqui ama baya era cuejayaque? ");
INSERT INTO cavNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pusha amadya mique cuejaya. Era pana adeba ayaque mique cuejaya. Ecue yatuca tsehue ebaque mique cuejaya. Jadya ama buchatu mira adebaya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Riyaque yahua juque era cuejayaquemi adebataqui ama baya. ¡Eje bucha adebaedya tuquemi ama era Yusu quejaque cuejayaque! ");
INSERT INTO cavNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“IQUE ECUITA era peadyami Yusu eje buchique pana cueja eau. Ni ejeque buchiquetu tuja yacua juque butehua, ique cuita camadya. ");
INSERT INTO cavNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Béru ecuanaja baba cuana japada anianinicuare patya, cuatsashaya eque jucarama juya cuanaque tuna bacua dyaque ujeda cuanara acuare. Yusuratu Moisés bacua cueya bronce eaque ameretsu acuiju shuramerecuare. Bacuara ahuara bacua cueya eaque petayajutu Yusura chachanecuare. Tumebaedya IQUE ECUITA acuiju tatatanadadiya. Jadya iyetae judadiya. ");
INSERT INTO cavNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Dutya eaqueja catyatiya cuanaque tuna iyacuanetanaya. Majutsu tuna Yusu queja judirubuque ni eje tupu jacanuca ishu ama, —jadyatu Jesúsra Nicodemo acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yusuratu dutya dyaque iyuhueda baya. Jadya tibudya tujatu tuja peadyaque Ebacuaque ecuana jiteque maju ishu cuadishahua. Tuja Ebacuaque queja ni ecuana catyatiya, ijahuaja etiquiju ecuana judirubuque ama. Yusu tsehue ecuana anisiribuque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yusuratu riyaque yahuaju cuanaque nerecaturacarama acuare. Jadya tibudya tujatu Ebacuaque riyaque yahuaju cuadishahua, tuaqueja catyatiya cuanaque inajacamere ishu, tuna ijahuaja etiquiju judiru ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Yusuja Ebacuaque queja catyatiya cuanaque tuna Yusura jucha metse ama baya. Amena tuaqueja catyatima cuanaque bacue Yusura jucha metse baya, tuna tuja Ebacuaque queja catyatihua ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Huecajutu ejitaju eje buchique; jadidyatu Yusuja Ebacuaque riyaque yahuaju junahua Yusuja biji eque jadique bamere ishu. Jesús queja nimee ama cuanaque tuna Yusuja biji eque ama aniya. Tunadya tuna apuda ducu juneniya buchique. Jadya tibudya tuna Yusuja Ebacuaque queja catyaticarama juya. ");
INSERT INTO cavNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jidama juya cuanaratu apuda ducudya jidamaque aya, huecadaju ama. Japada tunajatu hueca jacaya, tuna jidama juyaque ejitaju ejuu tibu. Tumebaedya Yusu ujeu cuanara Jesúsja quisarati bacacarama aya, tura tunaja jucha cuana ejitaju eauju. ");
INSERT INTO cavNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yusuja quisarati yuneri eque aniya cuanaque tuna Jesús queja cajipeticara juya, tuna Yusura amereya eque juyaque caadebamereti ishu. Huecaju juneniya cuana buchique tuna. ");
INSERT INTO cavNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jadya juatsutu Jesús Judea yahuaju cuacuare. Ecuana bacue tuatsehuedya cuacuare. Eje uma huecacadya ecuana tuhua jucuare, tuaqueja nimee juya cuanaque utsa juyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Juantu ecuana eque eje japa amadya jucuare. Enonjutu cutsameretiya cuanaque utsa jucuare Salím japadama, tuhua cueri aniya tibu. Jetiama tuna cuacuare tuaqueja cutsameretira. ");
INSERT INTO cavNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jadyatu jucuare Juan etare apudaju ishatanama jariju. ");
INSERT INTO cavNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Umae Juan tsehue juneniya cuanaque tuna caquemitsatitibunecuare peadya israelita tuhua jucuare tsehue, tunaja bahue eque Yusuja yacuaju jida cajuchatima juishu tibu eque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Tuna cama caquemitsati caquemitsati juatsu tuna Juan queja cuacuare. —Ebahuityaquique, reeque japadama taa tumebaedya aniya ecuita cuana utsa juyaque. Icuene mique Jordán yueque macare juchine patyatu tuque miatsehuedya juchine. Cuejachinedya mira ecuana tuque Mesiasque. Dutya jujeri tuna tuaqueja cuaya cutsameretira. ¿Jidadya tu jadya juishu? —jadya tunajatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juanra tuna quemitsacuare: —Yusura yatse casa tyahua tuque mere ishu. Ni ejera buchiquetu emereu ama tuja cuitadya casa tyamaque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Micuanara cuitatu bacahuadya era ejitaju cuejayaju ique ama Mesías Yusuja Emepeque jadique. Cuejahua micuana era, tuque junama jarijudya ique icuene cuadishatahua tuque junayaque cueja ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Caquemititayaju cuejatahuaquetu pureama juya, arepa tuque ama caquemitiyaque ama bucha. Huanequi juyaque pureama juyajudya jutidyatu pureama juya. Tumebaedya ique iyacua pureama juya ecuita cuana Jesús queja catyatiya baatsu, tuque Mesías juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Dyaquedya tunajatu Jesúsja quisarati bacaajeyadya jutidya. Ecue quisarati tunajatu bacajacaya, —jadya tuna Juan Ecuita Cuana Utsaquira acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yusu quejaque junahuaque tu dyaque emui, dyaque bahue jadique. Riyaque yahuaju ejitaju juya cuanara bacue jacataqui ama baya, riyaque yahua juque camadya tuna adebaya. Riyaque yahua juque camadya tunajatu cuatsabiji aya. Barepa juque junahuara bacue dutya adebaya. ");
INSERT INTO cavNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Turatu Yusu queja bahuaque, bacahuaque jadya quisarati cuejaya. Jadya ama bucha dutyara jujeri ejenecarama aya tura cuejayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tura cuejayaque ejenequi cuanaque tuna juya: “Yuneri cuitadya tu Jesús Yusuja Ebacuaque, Yusu cuitadya jadya juhua tibu”, jadya jubahue. ");
INSERT INTO cavNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tuquetu Jesús Yusuja Ecuadishaque. Turatu Yusuja quisarati yunerique cuejaya, Yusuja Espiritura casaturajacaya ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yusuratu dyaque iyuhueda baya tuja Ebacuaque. Jadya tibudya tujatu Ebacuaque casa tyahua dutya naru ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Yusuja Ebacuaque queja catyatiya cuanaque tuna Yusu tsehue tere baecua anibuque. Majutsu tuna Yusu queja tuque jacanuca ishu ama judirubuque. Yusuja Ebacuaque queja catyatima cuanara bacue Yusu jipebuque ama. Dyaque nerecada nerecaturajacatsu ama tujatu ecana nerecaturabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Fariseo cuanaratu quisarati bacatsacuare Jesús tsehuepa ecana amena dyaque umada juneniya, Juan tsehue bucha ama. Utsaya patu ecana dyaque jetiama, Juanra utsaya bucha ama jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jesúsra cuita amadya tuna utsacuare; ecuana tura mepehua cuanara tuna utsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Fariseo cuana tuja ishu quisaratiyaque bahue juatsutu Jesús Judea juque dirunucacuare. Tuatsehue dirupeedya ecuana jucuare Galileaju. ");
INSERT INTO cavNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tume ecuana Galileaju judirutsu Samaria eque cuetitaqui jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria yahua eque juneniyaque ecuana Sicar epu bacaniju judirucuare. Tumeque eputu japadama jucuare Jacobra béru ebacuaque yahua tyacuareque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jesústu ena cani peque judirucuare. Tumeque ena canitu jucuare béru Jacobra purucuareque. Japada ajehua tibutu Jesús dyaque ecastere jucuare. Jadya tibudyatu ena cani peque anibutedirucuare. Barepatya huietu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Ecuana ecuana epuju cuacuare ara ishu cuanaque quemira. Ecuana epuju cuahuajutu juticuare epuna tuhua Samariaju aniyaque. Ena jitequetu juticuare. Epuna jutihuajutu Jesúsra isaratsacuare: —Bastare, mama. ¿Ena piji mira eijimereu ama? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","—Aijama, ijimereya ama mique era. Mique taa mi israelita jutidya. Ique taa Samaria juque. ¿Eje bucha juatsu, jatsu, mira ena iji ishu bacaya? —jadyatu epunara Jesús acuare. (Tumeque epunatu bahuedya jucuare israelita cuana Samariaju cuana tsehue cajipeticarama juyaque, ni peadya canecu ena Samariaju cuanara ai ijiquerecarama ayaque. Jadya tibudya tujatu jadya quemitsacuare.) ");
INSERT INTO cavNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tudyatu Jesúsra quemitsacuare: —Yusurami dyaque jida tsehue bacara aya. Miratu adebaya ama. Erami ena iji ishu bacaya. Mira ique adebaya ama ique aique. Ique aique adebayaque juatsu, mira ique ebacau ena iji ishu. Mira ique ena bacayaque juatsumi era etyau. Ijitsumi eiyacuane ejuu. Majutsumi Yusu queja ejudiruu tuque jacanuca ishu ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Tata, aijama taa tuque micue ai tsehue ena tsehua ishuque. ¿Eje bucha tsehuae jatsu tuquemi eau ena ique Yusu jaca baecua anidirusha ishuque? ");
INSERT INTO cavNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ecuanaja ebaba Jacobra taa tu riyaque ena cani juquedya ijicuare béru. Tuja ebacua cuanaquera, tuja uu cuanara jadyari rehuaquedya ena ijicuare. Tume patya equequetu ecuanaja ata cuanara ena rehuaque ijicuare riya cama jaridya. Ecuanaja ebaba emuira ena cani shanacuare juquedya rique ecuana ijiya jari. ¿Mique ni taa mi tuque dyaque inime metseque cabatiya? —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—Riyaque cani juque ena ijitsumi masadama ijicara junucaya. ");
INSERT INTO cavNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Era ena tyayaque ijitsumi ijicara junucanime ama ni riya puji buchique. Era ena tyayaque tu bapeque. Muhuehueya buchatu judadiya ena ura baecuaque. Jadiquetu era tyaya. Terebuque ama tuque. Ijitsumi tere baecua anisiribuque. Majutsumi Yusu queja judirubuque, tuque jacanuca ishu ama, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—Tata, tyacue ique tumeque ena ijicara junuca ishu ama, dutya huecaca risharisha ena jiteque junuca ishu ama, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—Ihuaraticue micue ahue. Tuatsehue jenucacue rehua, —jadyatu Jesúsra acuare epuna. ");
INSERT INTO cavNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—Ahuema ique, —jadyatu epunara acuare. —Pusha amadyami juya. Aijamadya tuque micue ahue. ");
INSERT INTO cavNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Miquemi pishica ahuee juhua. Iyacuami aniya peya ecuita tsehue. Micue ahue ama tume. ");
INSERT INTO cavNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—Tata, amena mique adebaya, mique Yusuja casa tsehue quisaratiyaque, mira ique micue bamaque pana adeba ahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","“Yuneridya tuque ecuanaja Yusu rehua emata Gerizimju camadya muitaqui”, jadyatu ecue ebaba ecana icuene rehua Samariaju anicuare cuanaque jubahue jucuare. Micuana israelita cuana bacue micuana jubahue “Tuyudya tu Jerusalénju cuita camadya Yusu mui ishu, peya epuju ama”, —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesusratu acuare: —Ejenecue era cuejayaque, mama. Juetiyatu huecaca ecue Etata Yusu dutya queja muitanadadiyaque, jadya ishu cuitaju camadya ama. Jetaqui ama micuana ni rehua riyaque emataju tuque muira, ni Jerusalénju tuque muira. ");
INSERT INTO cavNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Iyacuatu micuana Samariaju cuanara adebaya ama Yusu eje buchique, arepa micuana muiya jadya juya ama bucha. Ecuana israelita cuanara bacue ecuana adebaya tuque eje buchique. Yusu Neri tuque ecuana muiya. Yusuratu mepecuare Israel eque ejuracanaque Einajacamerequi juishu. ");
INSERT INTO cavNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Masadamatu ecuita cuanara Yusu muidadiya tuque eje bucha muitacara juya eque. Tuja inime eque tuna anibuque. Yusuja Esprituja casa eque tunajatu mui neri adadiya. Jadyatu ecuanaja Etata Yusuja bijida tuque jadya muiqui cuanaja mui ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yusu tu cuitama. Ejitajuque ama tume. Tuja Espíritu equetu caadebameretiya. Tuja Espíritu eque cuita camadya tuque micuana tuque emuita bucha muie eau Yusu, tuja quisarati yuneri eque cuita camadya, —jadyatu Jesúsra epuna acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—Jejee, adebayadya tuque era ejeque huecaca Yusuja Emepeque, Mesías junabuqueque. Tuque junatsu, tura ecuana bahuityanabuque ecuana bahue jutaquique, —jadyatu epunara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Idya Mesías, miatsehue iyaja cuita quisaratiyaque, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesús tumeque epuna tsehue quisaratiyaju ecuana tura mepehua cuanaque judirunucacuare. Bape ecuana badirucuare tuque epuna tsehue quisaratiyaju. Jadya ama bucha, “¿Eje bucha equemi tumeque epuna tsehue quisaratiya? ¿Ai tuquemi bacahua?” ni ejera tuque ecuana jadya bacadurataqui ama bacuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Tumetu epuna tuja sura ena cani peque shanaquenatsu cuacuare epuju. Ejeque tsuruyaquedya jutidya tujatu cuejaajecuare: ");
INSERT INTO cavNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Necuara ena caniju. Yuhuatu aniya ecuita. Adebamaradya jutidya tura ique eje buchique cuejahua. ¿Tudya ni tu Mesías? ¿Tudya ni tu Yusuja Emepeque? —jadya tujatu ecana cuejaajecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jadya bacatsu tuna epu juque cuinanatsu cuacuare Jesús queja. ");
INSERT INTO cavNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ecuita cuana junatimaju tuque ecuana Jesús acuare: —Jee taa ecuana ara ishu cuanaque quemitihua cuanaque. Nearaarara, —jadya tuque ecuana Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—Ecuetu aniya era ai sareyaque micuanara adebayaque ama, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—¿Aira cuana ni taa rejari behua ara ishuque? —jadya tuque ecuanaja inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ecuanara ara ishuque adebayaju ecuana Jesúsra quemitsacuare: —Ecuetu ataqui Ique Cuadishaquira amerehuaque. Tura amerehuaque tuque ecue atillataqui. ");
INSERT INTO cavNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Pushi badi juatsutu amena tupu ecuanara uhuahuaque huesa ishu”, jadya micuana jubahue. Era micuana cuejaya. Nepetacue junabareya cuanaque. Tunaratu sareya ejeja tsahuatsu masadama eaqueja catyati ishu. Tuna tuna teeju euhuaque amena ejahuane buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Euhuaque huesaqui cuanaque etsujequi inatsu pureama juya bucha, tume bae cuitadyatu Yusu merequi cuanaque pureama jubuque, peya cuana eaqueja catyatiyaju baatsu. Tuna ai juyaque tu ejitajudya judadiya; tumequetu tere baecuaque. Yusratu dyaque jida amerebuque dutya tuque merequi cuanaque, tunaja mere ejitaju ama bahuishaya cuanaque, tumebaedya masadama ejitaju baya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jadique quisarati tu yuneriquedya: “Peadya tu uhuauhua puji; peya bacue jahuanehuaju huesaquique”. Tumebaedyatu umaera tsahuaya icuene cuita ecue quisarati bacaqui juhua cuanaque eaqueja catyati ishu, peya cuana quisarati cuejaqui cuana eque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Cuadishaya micuana era ecue quisarati iyacuaque cuejara. Micuana micuana peyara uhuahuaque huesaqui buchique, peya cuanara icuene quisarati yunerique cuejahua tibu. Micuana quisaratiyaju bacaqui cuanaque tuna eaqueja catyatidadiya, ai micuanara jipidya cuejayaju ama, peya cuanara icuene cuejahua tibu, —jadya ecuana Jesúsra acuare, ecuita cuana tuaqueja junayaju. ");
INSERT INTO cavNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Epunara tuja epuju cuanaque Jesús bana ishu cuejabareyaquepa tujatu ecana acuare: —¡Dyaque taa tuja casa aniya! Tuja ique bamaque cuitadya tura adebahua ique eje buchique. Tura cuejayaque bacatsu tunajatu umadara ejenecuare Jesús, Mesiasque Yusuja Emepeque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Quisaratiyaju bacatsu tunajatu bacacaradya jutidya acuare. Jadya tibudya tunajatu tuaqueja jutitsu —Rehuadya ecuana queja eje uma huecaca cuana anicue jari, —jadya aticuare. Tumetu Jesús beta huecaca tuna queja anicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tura cuitadya cuejayaju bacatsu tuna dyaque umada tuaqueja catyaticuare. Ejenecuare tuna tuque Mesías jadique. ");
INSERT INTO cavNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Jesús queja catyatihua cuanaratu epuna acuare: —Icuene cuita tuque ecuana ejenehua tuque Mesiasque, mira cuejayaju bacatsu jutidya. Iyacuatu ecuanara cuitadya bacahua. Catyatihua ecuana tuaqueja. Amena tuque ecuana adebaya Yusura tuque riyaque yahuaju cuanaque Ijahua quejaque inajacamerera cuadishahuaque, —jadya tunajatu epuna acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Beta huecaca juatsu ecuana Jesús tsehue Samaria juque cuanucacuare, Galilea yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","“Yusuja quisarati cuejaquiquetu peya epuju cuanara muibaya; tuja epuju cuanara cuita bacue muibaya ama”, jadyatu Jesús beru jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jadya ama bucha tunajatu Jesús Galileaju junatihuaju tuhua cuanara jida batsacuare. Tuna dyadipa tuna Jerusalénju Pascua chine ishu cuacuaredya. Tuhuadya tunajatu bacuare Jesúsra ayaque ni ejeque ecuitaja ataquique ama. Jadya tibudya tunajatu pureama tsehue batsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tuequedyatu Jesús Caná Galilea yahuaju yudijidya dirunuca jucuare, icuene ena uva nacaca cabapetishacuareju. Tuhuatu jucuare huaraji, ecuari merequique. Ebacuaque tujatu dyaque ujejeda jucuare Capernaumju. ");
INSERT INTO cavNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesús junanucahuajutu huaraji ecuita cuanara cuejacuare: —Jesús ri rehua. Juetinucahuatu Judea juque. Jadya cuejahuaju tujatu Jesús isaraticuare. Canerecatinaticuaretu tuaqueja: —Nerecabacue taa ique. Ecue ebacua taa majutaqui cuita. Necua ecue etareju. Ecue ebacua chachaneticue, —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Tudyatu Jesús jucuare: —Ni ejeque buchique micuana eaqueja catyaticara juya, Yusuja casa bamere ishuque era ayaju bamaque, ni ejeque ecuitaja ataquique ama ayaque bamaque. ");
INSERT INTO cavNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Huarajitu quisaratinucacuare: —Ecuatsashaquique, jecue ebajarara, ecue ebacua majuma jarijudya. ");
INSERT INTO cavNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—Dirunucacue micue etareju. Micue bacua tu amena chacha. Majuya ama tuque, —jadyatu Jesúsra acuare. Huarajiratu ejenecuare Jesúsra tuja ebacuaque chachanehuaque, arepa japada ama bucha. Amena tuque ejenetsutu dirucuare tuja etareju. ");
INSERT INTO cavNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tudya tujatu tsurutsacuare edijiju tuja mere puji cuana. Isaratsacuare tuna tunaja patrón: —Micue bacua tu chacha. Amenatu dyaque mejemeje cuita juhua, —jadya tunajatu atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Tudyatu ecuitara bacaduratsacuare tuja mere puji cuana: —¿Ai ura dyane ecue ebacua jida mejemeje juhua? —jadya tujatu ecana atsacuare. —Riyabarepa a la una tujatu baara netichine, —jadya tunajatu atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jadya cuejayajutu ecuita huecatanacuare: “Tumeque ura cuita di taa riyabarepa Jesúsra ‘Micue bacua tu amena chacha’ jadya achine”. Tumetu Jesús queja catyaticuare. Tumebaedya dutya tuja etareju aniya cuanaque Jesús queja catyatibarecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Riyaquetu jadya jucuare Jesús Galilea juque Judeaju judiruhuaju. Canáju tujatu bamere beta ishu Yusuja casa bamerecuare, ejeque ecuitaja buchique ataquique ama aatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jadya juu jadya junucatsutu Jesús Jerusalénju yudijidya cuanuca jucuare. Tuhuatu israelita cuana chine jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Tuhua Jerusalenjutu ena cani dyaque quinidaque anicuare. Israelita cuanaja yana equetu tumeque ena cani Betzata bacani jucuare. Tumeque ena canitu jucuare epu tachiquique uhuisha cuana epuju nubiquique cani japadama. Anicuaretu pishica etare caca cuana ujejeda cuanaque jara ishuque. Etare caca cuanaja etabutu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Tuhuatu jarabarecuare umada ujejeda cuanaque. Anicuaretu shuhui cuanaque, ajebaecua cuanaque, ecaturuti cuanaque jadya. Tuhuadya tunajatu ihuacuare ena muhuehueyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Juatsudya juatsudyatu barepa juque Yusu tsahuaquique bute bahue jucuare ena cani ebari juque ena muhuehuesha ishu. Tura ena muhuehueshayajudyatu ujejeda cuanaque ena caniju nubi bahue junenicuare. Ena muhuehueyaju icuene nubiyaque camadyatu chacha jubahue jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tuhuatu jaracuare ecuita eje uma mara ujejedaque. Quimisha tunca quimisacarucu earacana mara ajebaecuaquetu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tuhua nubitsutu Jesúsra bacuare tumeque ecuita. Turatu adebacuaredya tumeque ecuita mara mara ajebaecuaque jarayaque. Isaranaticuare tuja tuque: —¿Netitsuracarami juya, tata? —jadya tujatu bacaduranaticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—Jejee, Ecuatsashaquique. Netitsuracara taa juya. Jadya ama buchari aijama ejeque ique ena muhuehueyaju isha ishu. Ique bucucutaqui ama juya tibu, peya cuanara bareya jutidya, —jadyatu ajebaecuara acuare Jesús ");
INSERT INTO cavNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—Netitsuracue. Huesacue micue jara ishuque. Dirucue micue etareju, —jadyatu Jesúsra acuare ujejedaque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jadya Jesúsra ahuaju cuitadyatu ecuita netitsuratsu ajecuare. Ajetsutu cahuesatiquenacuare tura jara ishu ahuaque. Cahuesatitsutu diruquenacuare. Canajara huecacajutu Jesúsra ecuita ebucucujacaque chachanecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Israelita huaraji cuanaratu bacuare tura jara ishu ahuaque cadujutiyaju. —Riyaque huecaca ri canajara huecaca. Ecuanaja cacuatsashati eque amami juya. Dujuta baecuatu ni ai buchique canajara huecacaju, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—“Huesacue micue jara ishuque. Dirucue micue etareju”, jadya ique ajeshaquira ahua, —jadya tuna acuare ecuita chacha juhuara. ");
INSERT INTO cavNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—¿Aira jatsumi jadya ahua: “Huesacue micue jara ishuque. Dirucue”, jadya? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ajebaecuaque netitsurahuaquetu baecua jucuare tuque ajeshaquique ai bacanique. Tuque ajeshatsutu Jesús masadama cuinanacuare ecuita jetiama ducuque. Jadya tibutu ecuitara eje bucha bacadurataqui ama bacuare tuja ebacani. ");
INSERT INTO cavNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jadya junucatsutu Jesúsra ecuita tsurunucacuare Yusuja etareju. —Amena mi juneniya. Cajuchatinucaume. Eajejacanucau mique, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Tuhuatu ecuitara adebacuare Jesús tura nityatsuratsu ajeshahuaque. Tumetu cuinanacuare. Cuinanatsutu israelita cuanaja huaraji cuana tsehue quisaratira cuacuare. —Jesusradya tucue ajeshahua, —jadya tujatu ecana aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Israelita cuanaja huaraji cuana tuna dyaque ecahuaiti jucuare Jesús tsehue, tura ujejedaque canajara huecacaju chachanehua baatsu. Quisaratitibunecuare tuna tuja ishu. Ujeu tsehue tunajatu petacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesústu bahuedya jucuare tuna tuatsehue dyaque ecahuaitique. Acuare tujatu ecana: —Ecue Etatatu dutya huecaca mere juya; ique tumebaedya mere jujacaya ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jadya tuque juyaju bacatsutu israelita cuanaja huaraji cuanara dyaque iyecara acuare. Iyecara tunajatu acuare, tura canajara huecacaju ahuaque tunara tumeque huecaca ataqui ama bucha bayaque ahua baatsu. Jadya juatsu camadya ama tuna tuatsehue dyaque ecahuaiti jucuare. Iyecara tunajatu acuare tuque Yusu tsehue beta tupu jadya catiyaju, Yusupa tuja Etataque cuitadya jadya juyaju bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesusratu israelita cuanaja huaraji cuana anucacuare: —Pusha amadya micuana cuejaya. Era quisarati ayaque, ai era ayaque tuque ecue casa tsehue ama aya, ni riya piji buchique. Dutya tuque aya ecue Etataja casa tsehue. Ecue Etatara ayaju ebaque camadya tuque aya. Ecue Etatara ayaque era dyaditu jadidya aya, ique tuja Ebacuaque juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ecue Etatara ique dyaque iyuhueda baya, tuja Ebacuaque tibu. Turatu ique tyaishu ni ai en aya ama. Dutya tuja casa tura tyahua, tura ai ayaque ecue dyadi aishu. Tuja casa tsehue tuque ujejeda cuanaque chachaneya. Ayadya tuque dyaque ibedaque tuja casa bamere ishu. Baatsu micuana anajacataya. ");
INSERT INTO cavNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ecue Etataratu emaju cuanaque yudijidya nityatsuranuca aya. Chacha tujatu ecana amerenucaya. Tuatsehue tujatu ecana anishanucaya tere nuca ishu ama. Eratu tumebaedya emaju cuanaque nityatsuranucaya. Ecue jadya inimeque juatsu tuna chachadya amerenucaya, ique tuja Ebacuaque tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ecue Etatara ama “Tuna ecajuchati” jadya abuque. Ique tura tyahua casa “Dutya jidama cuanaque ecajuchati” jadya aishu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jadya tura ique amerehua dutyaja tunaja ique mui ishu, tuque muitaya bae cuitadya ique muita ishu. Ique ni micuanara muiya ama, jutaquiju taa tuque micuana ecue Etata Ique Cuadishaquique muiya amadya. ");
INSERT INTO cavNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Pusha amadya micuana cuejaya. Era cuejaya eque aniya cuanaque, Ique Cuadishaqui queja catyatiya cuanaque tuna tere baecua anibuque. Yusu queja tuna judirubuque ni eje tupu jacanuca ishu ama. Yusuratu ni riya piji buchique juchaqui baya ama tuaqueja catyatiya cuanaque. Icuene tunajatu Yusu japada bacuare. Emaju bucha tuna junenicuare. Iyacua tuna amena chacha aniya. ");
INSERT INTO cavNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pusha amadya micuana cuejaya. Iyacua emaju bucha cuanaratu bacaya era cuejayaque. Yusuja Ebacuaque queja catyatitsu, tuna Yusuja yacuaju anibuque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Jadya anie tuna Yusu tsehue terenuca ishu ama jubuque, ecue Etataja tuna jadya anisha ishu casa aniya tibu. Tumebaedya tura ique tyahua tumeque casa eaqueja catyatiya cuanaque tere baecua anisha ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","IQUE ECUITA tibu, ecue Etatara cuatsashahua jidama cuanaque nerecatura ishu, cuejaya equedya aniya cuanaque jidaque tyaishu jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Neanajacataume era jadya cuejayaju. Juetibuquetu huecaca eje tupu dutya emaju cuanara ecue etsuri bacabuqueque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Netitsurabarebuque tuna tunaja uhuacuare cuana juque. Jida juhua cuanaque tuna chacha aninucabuque, ni eje tupu majunuca ishu ama, Yusu jacanuca ishu ama. Jidama juhua cuanaque tuna chachadya aninucabuque. Netitsuranucatsu tuna canerecati ishuju nubidirubuque ni eje tupu tuhuaque cuinananuca ishu ama, —jadya tujatu ecana cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jesúsra tuna bahuityanucacuare: —Dutya era ayaque tuque aya ecue cuita casa tsehue ama. Yusuja casa tsehue tuque aya. Eratu nerecaturabuque era amereya eque ama aniya cuanaque. Amereya eque aniya cuanaque bacue jidaque tyabuque. Dutya era ayaque tu tuyu. Ecue Etatara amereyaque cuita camadya tuque aya. Ecue inime equedya jutidya ama tuque aya, tuja inime eque, Ique Cuadishaquija inime eque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ique ni ecue taca ishudya jutidya equisaratiu, idya jutidya ni ejuu “Dutya tuque aya Yusuja casa tsehue”, eejeneu amadya micuanara ique. Peyajatu ataquidya ecue ishu jida quisarati. ");
INSERT INTO cavNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Aniyatu peya ecue ishu jida quisarati ayaque. Tumeque tu ecue Etata. Tuquetu bahue ique eje buchique. Ique bahuedya tuque yuneri quisaratiyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Icuene tuque micuana ecuita cuana cuadishacuare Juan Ecuita Cuana Utsaqui queja, eje buchique ique jadique bacadurati ishu. Tura ique eje buchique cuejahuaquetu yuneriquedya. ");
INSERT INTO cavNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Huecashaya micuana era, tura ique jadya ayaque quisarati jadya acuareque, micuana eaqueja catyatitsu quinajacameretitaquique. Jadya ama bucha tuque sareya ama ni ejeque ecuita ique aique pana adebamere aishuque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ude tsehue cudatitsu ecuana bahue eje eque cuayaque. Juan tu ude buchique jucuare. Turatu Yusuja quisarati cuejacuare micuana Yusuja biji eque ani ishuque bahue juishu. Ejetsunue ama micuana pureama juhua tura cuejayaque bacatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Aniyatu peya eje bucha eque ique eje buchique bahue jutaquique. Riyaque tu era Yusuja casa tsehue ayaque. Arepa micuana Juan Ecuita Cuana Utsaquira ique eje buchique cuejacuare ama bucha, era cuitadya ayaque baatsu, pana ejenedya tuque micuana aya ique Mesiasque. Ecue Etatara amereyaque era ayaju baatsu tuque micuana pana ejene eau ique yuneridya Yusuja Ecuadishaque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ecue Etata Ique Cuadishaquiratu tumebaedya ecue ishu jida quisarati aya. Jadya ama bucha micuana tura cuejayaque bacacarama aya, ni micuana bacara aya tudya cuitadya caadebameretiyaju. ");
INSERT INTO cavNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Arepa micuana tuja quisarati bacahua ama bucha, tuque micuana ejenehua ama, ni micuana tura amereya eque aniya. Adebataqui ama micuana baya, eaqueja catyaticarama juya tibu, tura cuitadya cuadishahua queja. ");
INSERT INTO cavNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Micuanaratu pana adeba acara tsehue isaraya Yusuja quisarati. Tuyudya tuque micuana adebaya isaratsu bahue micuana judadiya eje bucha anie tere baecua ishu jutaquique. Pana isara aatsu micuana bahue ejuu ique eje buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jadya ama bucha micuana eaqueja catyaticarama juya. Eaqueja ni micuana ecatyatiu, Yusu queja micuana anidirubuque eje tupu jacanuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Eratu jidama ama inime baya ecuita cuanara ique muiya amaju. ");
INSERT INTO cavNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Eratu adebaya eje bucha micuana inime cadujutiyaque. Eratu adebaya micuanara Yusu iyuhuedama bayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ique riyaque yahuaju junahua ecue Etata Yusura cuatsashayaju. Jadya ama bucha micuanara jida ama batsahua ni micuana eaqueja catyaticara juhua. Ejeu ni peya tuja inime tacaquedya jutidya, tumeque camadya tuque micuana jida ebatsau. Tume micuana tuaqueja ecatyatiu. ");
INSERT INTO cavNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Micuana micuana eje buchadya camuimereticara juya ecuita cuana queja. Jadya ama bucha micuana Yusu queja eje buchadya camuimereticara juya ama. Jadique juatsu yuneridya micuana eaqueja catyatiya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Paju ama micuanaja inime era cuita camadya ecue Etataja yacuaju, “Riya cuanaque ri jucha metse”, jadya aya bucha. Yusura tuyu juyaju baya bucha micuana cabatiya, Moisésra cuatsashahua eque anicara juya cabatitsu. Jadya ama bucha micuana Moisésra cuitadya eaqueja catyaticarama juhuaque cuejabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesratu huenecuare ique jadya ayaque. Yuneridya ni micuana ejenequena juhua Moisésra huenehuaque, tume micuana eaqueja catyatiquena juhua. ");
INSERT INTO cavNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ejeneya ama micuana tura huenehuaque. Yuneri cuitadya tuque micuana era cuejayaque ejeneya ama, —jadyatu Jesúsra acuare israelita cuanaja huaraji cuana. ");
INSERT INTO cavNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jadya juu jadya juatsutu Jesús cuacuare bei Galilea yueque macare. Tumeque beitu Tiberias bacani nucadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesús tuhuaque bahue juatsutu jetiama ecuita cuana cuacuare tuaqueja, Yusuja casa tsehue ujejeda cuanaque chachaneyaju bachineque juatsu. “Peya ai cuana tujatu eau ejeque ecuitaja ataquique ama”, jadya tunajatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jesústu ecuana tsehue emataju tsuracuare. Tsuratsu ecuana anibutecuare tuhuadya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tume patyatu israelita cuana chine catihuie jucuare. Tumeque chine bacanitu Pascua jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tudyatu Jesúsra anibutetsu batsacuare jetiama ecuita cuana tuaqueja cuayaju. Tuna cuayaju batsatsu tujatu Felipe bacaduracuare: —¿Ejuque tuque ecuana pan ebacau riya jetiama ecuitaja ara ishu? ");
INSERT INTO cavNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jadya tujatu bacaduracuare Felipe, Felipera eje bucha quemitsae ayaque bacacara aatsu. Jesústu icueneta bahue jucuare eje bucha mihuae dutya eauque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Feliperatu quemitsacuare: —Juhua aba. ¿Ejuque cuana taa tuque yatse equemiu? Tupu ama taa tu ejuu ni beta ciento ficha, peadya ecuita shucuta badi mere ejuuque etsujequi tupu, peadya peadyaja riya piji riya piji ara ishu, —jadyatu Felipera acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrés, ecue ecaretu Jesús tsehue quisaratiticuare. Tumequetu Simón Pedro tsehuequique jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Rehuari ebacua pijija aniya pishica pan cebada eaque, beta jae jadya. Jadya ama bucha ejebu tupue ni tu juma, jetiamaque ecuita mihua ishu, —jadyatu Andrésra Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—Necuejacue ecuita cuana; paanibute ecana dutya, —jadya tura ecuana acuare. Iyabutyacuare ecuana ecuita cuana. Tume tuna dutya tuhua anibutecuare nutsa dyaque. Jetiama ecuitatu jucuare. Deca cuana cuita camadya epiyebaque tuna jucuare pishica mil ecuita; tumebaedya jetiama epuna, ebacua cuana jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tudyatu Jesúsra inaticuare pishica pan. —Yusurupai mique aya, Tata, mira ecuana riyaque ara ishuque tyahua tibu, —jadya tujatu Yusu acuare. Yusurupai au jadya aatsu tura ecuana pan cuesibaretsu tyabarecuare. Tura ecuana pan tyabareya tupu tujatu jetiama umanashacuare. Tume tuna ecuanara tyabarecuare dutya anibutebarehua cuanaque. Tumebaedyatu jae anucacuare. Yusu yusurupai aatsu, tura ecuana tyabarecuare, ecuita cuana tyabare ishu. Tura ecuana tyabareya tupu tujatu jetiama umanashacuare. Tume tuque ecuana anibarehua cuanaque tyabarecuare. Dutya tuna araaracuare, pana jeque juya tupu. ");
INSERT INTO cavNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Amena dutya jequebarehuaju ecuana Jesúsra ihuaracuare: —Ecuesi cuana nemepecue arabishahua cuanaque; ni peadya ecuesi paaputa ama, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Tudya ecuana ejara cuana mepecuare. Mepetsu ecuana jequeshacuare peadya tunca beta earacana jiti arida cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Amena ecuita cuana Jesúsra Yusuja casa bamere ishu pan umanashahuaju baatsu, tuna jadya jucuare: —Pusha ama cuitadya ri riyaque ecuita Yusura riyaque yahuaju cuadisha ana ahuaque tuja quisarati ecuana cueja ishu. Riyaque ecuitadya tucue tuque ecuana ihuayaque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Tunara casada tsehue ecuari juishu dujucara ayaque caadebatitsutu Jesús peya queja amaca netisicuacuare, riyaque yahuaju ecuari juishu ama junahua tibu. Tuta taca pijitu cuacuare emata dyaque barudaju. ");
INSERT INTO cavNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ijeti nubihuaju, amena apunahuaju ecuana Jesúsra mepehua cuanaque bei jiruru butecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesús tsehue ama ecuana jucuare. Tume ecuana anibutecuare cuabaju. Cuabaju anibutetsu ecuana carequeticara jucuare yueque macare, epu ebari Capernaum bacaniju judiru ishu. Ecuana amena carequetiyajutu apuna jida jucuare; dyaque apuda jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Tudyatu cuejipa casadaque jueticuare. Ena pacu casada muda jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Amena ecuana pishica jadya ama juatsu shucuta kilómetro cuana diruhuaju tuque ecuana Jesús batsacuare ena dyaque eque ajetsu ecuana queja diruyaju. Mubatsacuare tuque ecuanara, yatanana bucha baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ecuana bajida juya baatsu ecuana Jesúsra quiquecuare: —¡Bajida nejuume! ¡Idya ique! —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Tuja etsuri bacatsu ecuana bajida jujacacuare. Jida pureama tsehue tuque ecuana iyabutyatsacuare cuabaju. Jadya juu jadya juatsu ecuana judirucuare bei yueque macare Capernaum japadama. ");
INSERT INTO cavNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Huecacanucatsutu Jesús sare juya cuanara Jesús tsurucuare ama. Bei jiruru queja judirutsu, tuna bahue judirucuare Jesúsra mepehua cuanaque Jesús tsehue ama cuahuaque, peadya cuabaju cuita camadya tumeque cuabaju anibutetsu cuahuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tuna Jesús eju cuahuaque bacadurani juyajutu Tiberias juque cuaba cuana junatibarecuare. Jaratsuracuare tuna riyabarepa buchaju pan tyahuaju Ecuana Cuatsashaquira yusurupai ahuaju, ecuita cuanara pan arachineju. ");
INSERT INTO cavNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jadya equetu Jesús sare juya cuanaque tuque tuhuaque ama bahue jucuare. Tumebaedya ecuana tura mepehua cuanaque ecuana tuhua amadya jucuare. Tume tuna Tiberias juque cuaba ebari cuana junahuaju anibutebarecuare bei rique ishu. Capernaum ebuteju jaratsuratsu tuna Jesús sarera cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Bei yueque macare carequetitsu tunajatu Jesús banaticuare. Banatitsu tunajatu bacaduranaticuare: —¿Eje tupumi junachine, Ebahuityaquique? Mique sare juyaque ecuana riya, —jadya tunajatu anaticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—Pusha amadya micuana cuejaya. Riyabarepa micuana arachine pan jae jadya era tyahuaju. Jequeya tupu micuana arachine. Jadya juatsu micuanara iyacua sarenucaya ecue mihuanuca ishu. Era riyabarepa achineque eje buchique jadique pana adeba aatsu ama micuanara sareya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Inime tupuqui neaume earaqui masadama tereyaque, riyaque yahuaju jari tupu micuanara arayaque. Aniyatu peya micuanaja ishu earaqui buchique. Tumera micuana iyacuaneya terenuca ishu ama ani ishu. Tumequetu IQUE ECUITAra tyayaque. Ecue Etata Yusu pureamaturayaque aniya tibu, tura cuejahua: “Tyacue ecuita cuana riyaque earaqui buchique, tuna tere baecua anisha ishuque”, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Tura jadya ayaju tunajatu bacaduracuare: —¿Eje bucha anie ecuana ejuu Yusu pureamaturajaca ishu ama? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—Yusura micuana tura cuadishahua queja catyatishacara aya. Idya tura cuadishahuaque. Jadya tibudyatu tuja bijida eaqueja micuana catyati ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—Acue ecuanaja yatucaju ejeque ecuitaja ataquique ama, ecuanaja mique Mesiasque ejene ishu. ¿Ai tuquemi aya Yusuja casa tsehue ejeque ecuitaja ataquique ama? ");
INSERT INTO cavNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ecuanaja baba cuana japada midida ama anitaya cuanaju juneniyaju, tuna Moisésra dutya huecaca ara ishuque tyacuare, maná pan jiuque. Yusuja quisarati tu ehuene: “Dutya huecaca tuna Moisésra tyacuare ara ishuque pan Yusura barepa juque cuadishayaque”, —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","—Pusha amadya micuana cuejaya. Arepa ecuanaja baba cuana Moisésra maná tyacuare ama bucha, tyacuare ama tujatu ecana earaqui neri barepa juque. Ecue Etata tu tumeque earaqui neri tyaquique. Tuquetu tere baecua anisha ishuque tyaquique. ");
INSERT INTO cavNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Béru Yusura barepa juque maná cuadishacuare bucha, tumebaedya tura ique barepa juque cuadishahua. Riyaque yahuaju ani ishu arataquique bucha, tumebaedya micuana eaqueja catyatitaqui Yusu tsehue maju baecua ani ishu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—Tumeque earaqui ecuana tyacue dutya huecaca, Ecuatsashaquique. ");
INSERT INTO cavNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesúsra tuna acuare: —Idya earaqui neri buchique Yusuja ecuadishaque. Idya eanishaquique. Araaratsu micuana masadama aracara junucaya. Ijiijitsu micuana masadama ijicara junucaya. Eaqueja nimee juyaju micuana era pureamatura neri aya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jadya ama bucha micuana eaqueja catyaticarama juya, era micuana cuejahua baedya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Dutya, ecue Etatara eaqueja amerehua cuanaque tu ecue cuanaque. Eaqueja catyaticara juya cuanaque tuque eaqueja ihuaraya. Bijidamadura nime ama tuna ecue. ");
INSERT INTO cavNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ique barepa juque jehua ecue inime eque juishu ama, ecue Etataja inime eque juishu. Ique jehua Ique Cuadishaquija inime eque juishu. ");
INSERT INTO cavNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ique Cuadishaquira narumerecara aya dutya tura eaqueja amerehua cuanaque. Jadya tibudya tunara jacaya ama. Era tuna chacha nityatsuranucabuque tere huecacaju Ique Cuadishaquija inime eque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ecue Etataratu dutya ique adebaqui cuanaque, dutya eaqueja catyatiya cuanaque tere baecua anishacara aya. Eje tupu jacanuca ishu ama tujatu ecana tuaqueja amerecara aya. Era cuitadya tuna tere huecacaju chacha nityatsuranucabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Israelita cuanaja huaraji cuanatu cahuaiticuare jutidya tuque quisaratiyaju bacatsu. Quisaratibarecuare jutidya tuna Jesúsja ishu. —Earaqui neri Yusura barepa juque cuadishahuaquepa tume, jadyatu juya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jeequedya ri Jesús, Joséja ebacuaque. Adebaya tuque ecuana tuja etataque, ecuaque jadya. Tume jatsutu ¿eje bucha juatsu “Idya barepa juque ecuadishataque” jadya juya. Pusha pusha arida tuque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tuna jadya quisaratiyaju, tuna Jesúsra jadya acuare: —Jadya nequisaratiume. ");
INSERT INTO cavNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ecue Etata Ique Cuadishaquiratu ecuita cuana eaqueja catyatishaya. Tura ni ecana jadya amereya ama, tume tuna eaqueja ecatyatiu amadya. Eaqueja catyatiya cuanaque tuna tere huecacaju emajuque nityatsuranucabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Icuene beru Yusu equeque quisarati cuejaqui cuanaratu huenecuare: “Yusura cuitadya tuna cuejabuque dutya eje bucha tujaque juishuque” jadya. Ecue Etatara cuejayaju bacaya cuanaque cuita camadya, tura cuejaya equedya aniya cuanaque cuita camadya tuna eaqueja catyatishaya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Pusha ama cuitadya ni ejeque riyaque yahuajujatu bama ecue Etata. Ecue camadya tuque ecue Etata eba, ique tuaquejaquedya jehua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Pusha amadya micuana cuejaya. Eaqueja catyatiyaque juatsu micuana terenucanime ama. Anisiribuque micuana Yusu tsehue. ");
INSERT INTO cavNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Idya cuitadya earaqui buchique Yusuja ecuadishaque. Idya tere baecua anishaquique. ");
INSERT INTO cavNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Egipto juque cuinanatsu ecuanaja baba cuanara aracuare maná barepa juque Yusura cuadishayaque. Jadya ama bucha tuna majucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Aniyatu peya earaqui buchique barepa eque jecuareque. Tuaqueja catyatiyaque juatsu micuana terenuca ishu ama anibuque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Idya cuitadya ique barepa juque junahuaque. Idya chacha anishaquique. Eaqueja catyatiya cuanaque tuna majunucabuque ama. Ique majudadiya, riyaque yahuaju cuanaque Yusu tsehue siri anisha ishu. Idya cuitadya catyatibuque, riyaque yahuaju cuanaja earaqui bucha, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jadya bacatsutu israelita cuanaja huaraji cuana tuna cama caquemitsati caquemitsati jutibunecuare: —¿Eje bucha tyae tura ecuana eau tuja ecuita cuitadya ecuanaja ara ishu? ¡Eje bucha jadya juetu ejuu! —jadya tuna jubarecuare. Adebataqui ama tunajatu bacuare tura eje buchique jadya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesústu bahue jucuare eje bucha tuna tuna cama quisaratiyaque. —Pusha amadya micuana cuejaya. Micuanara ni ecue erami araya ama, judirutaqui ama micuana Yusu queja tuque jacanuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Dutya micuana ecue erami ara juya cuanaque, ecue ami iji juya cuanaque micuana tere baecua anibuque, IQUE ECUITA juya tibu. Tere huecacaju tuque emaju cuanaque cani juque ecuita iyacua tsehue nityatsurabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ecue ecuita tu earaqui neri buchique. Ecue ami bacue eijiqui neri buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ecue erami ara juya cuanaque, ami iji juya cuanaque tuna eatsehue peadya camadya bucha, ique tuna tsehue peadya camadya bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ecue Etata Ique Cuadishaquiquetu chacha aniya. Maju baecua tuque. Tuque aniya tibu, ique dyadi aniyadya. Tumebaedyatu era ecue erami ara juya cuanaque anishaya. Era tuna eiyacuane amereya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jadya tu earaqui neri barepa juque junahuaque. Maná ecuanaja baba cuanara aracuare buchique ama tume. Arepa tuna aracuare ama bucha, dutya tuna majuterecuare. Ique barepa juque earaqui butecuare buchique. Dutya, ecue erami araqui juya cuanaque tuna maju baecua aninucabuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jadya tuna Jesúsra bahuityacuare ecuita cuana Capernaumju caradati ishuque etareju. ");
INSERT INTO cavNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jadique Jesúsra bahuityayaque bacatsutu jetiama tuque ijacabacaqui cuanara bijidamaduracuare tuja quisarati. —Riyaque tura cuejayaque ri ibeda ejene ishu, adeba ishu jadya. Cujishaya cuita jutidya tura ecuana. Ni ejeratu eadebau ama, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesústu bahuedya jucuare tuna cama eje bucha cacuejatiyaque. Adebacuaredya tujatu ecana tunara tuja quisarati bijidamadurayaque. Jadya tibudya tujatu ecana bacaduracuare: —¿Ecue quisarati tsehue ni taa micuana canimehuallatishahua? ");
INSERT INTO cavNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iyacua micuana eaqueja catyaticarama juya. ¿Eaqueja ni micuana ecatyatiu, IQUE ECUITA ecue eaniqui juque butecuareque tsuranucayaju baatsu? ");
INSERT INTO cavNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Riyaque yahuaju cuanaquetu tere baecua eaniu, earaqui aratsu ama. Yusuja Espiritura camadya micuana maju baecua anishaya. Era cuejahuaque ejenehua cuanaque cuita camadya tuna Yusuja Espíritu tsehue. Tuna cuita camadya tuna tere baecua anibuque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jadya ama bucha micuana umae eaqueja catyatima jari, —jadya tuna Jesúsra acuare. Jesústu icuenetadya bahue jucuare eje cuanaque tuaqueja catyaticarama juhua cuanaque, ejera tuque ujeu baqui cuana queja inameredadiyaque jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Bahuityanucacuare tujatu ecana: —Dutya ama micuana ecuique. Jadya tibudya micuana cuejanucaya. Ecue Etatara eaqueja nimee amereya cuanaque cuita camadyatu eaqueja catyatiya, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jadique quisarati ayaju bacatsutu jetiama tuque quisaratiyaju pana baca juya cuanara Jesús jacacuare. Juneninucacuare ama ecana tuatsehue, tuque quisaratiyaju baca ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Tume ecuana Jesúsra bacaduracuare: —¿Micuanara ni taa umaera aya bae jacacaradya aya? —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedroratu quemitsacuare: —Aijama, Ecuana Cuatsashaquique. Aijamatu peya ecuana Yusuja quisarati bahuityaquique. Mira peadya cuita camadya ecuana bahuityaya Yusu tsehue anisiri ishu eje bucha iyacuanetanae juishuque. ");
INSERT INTO cavNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Miaqueja cuita camadya ecuana catyatihua. Bahuedya ecuana mique cuita camadya Yusuja Ecuadishaque. Bahuedya ecuana mique cuita camadya juchama nerique, —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—Era micuana mepehua, micuana peadya tunca beta earacana. Jadya ama buchatu peadya micuana ducuque Satanás merequi juya, —jadya ecuana Jesúsra cuejacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jadya quisarati ayaquetu Jesúsra yana acuare Simón Iscarioteja ebacuaque Judas bacani jadya ayaque. Tumeque Judasdya tu ecuana Jesús tsehue juneniya patya ecuana tsehue junenicuareque. Jadya ama buchatu Judasra cuitadya inamerecuare Jesús tuque ujeu baqui cuana queja. ");
INSERT INTO cavNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jadya juatsutu Jesús junenicuare Galilea yahua epu cuanaju. Israelita cuanaja huaraji cuana tuque iyecara jucuare cuanaque tuna Judeaju jucuare. Jadya tibudyatu tuqueja junenicarama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Israelita cuanaja chine ebaritu piji dyane jucuare. Riyaque chine juya tupu ecuana erere cuana catitsu tuhua ani bahue jucuare, ecuanaja baba cuana erere cuanaju béru anianinicuareque adebayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Tuatsehuequi cuanaratu Jesús acuare: —Rehua aniume. Judea yahuaju dirucue; Jerusalénju dirucue chine ishu. Tuhuatu jetiama micue quisarati bacacara juya cuanaque. Tuhua adirucue Yusuja casa tsehue ni ejeque ecuitaja ataquique ama, tunaja dyadi mira aya cuanaque baishu. ");
INSERT INTO cavNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jetiamaja eadeba jucara juyaratu etehua bamere ama aya tuja casa. Jadya ejuuque tunajatu aya eje buchadya dutyara petayaju acara. Mira ecuanaja baishu ejeque ecuitaja ataquique ama aya tibu, acuedya jetiama ecuitaja yacuaju, —jadyatu tuatsehuequi cuanara acuare, tuque ijaribayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tuatsehuequi cuanaquetu tuaqueja catyatima jari jucuare. Ejeque ecuitaja ataquique ama aishuque camadya bucha tunajatu inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—Huecaca rique ecue juetima jari ecue casa dutya ecuita bamere ishuque. Micuanara camadyatu eau eje tupudya jutidya micuanara ai acara ayaque. Jerusalénju cuacara juatsu, micuana cuayadya. ");
INSERT INTO cavNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yusuja ama cuanaquetu micuana tsehue cahuaitiya ama. Eatsehue bacue ecana dyaque cahuaitiya, era tuna jidama aniyaque cuejajacaya amaju. Jadya tibu tunara ique ujeu baya. ");
INSERT INTO cavNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Necuacue micuana Jerusalénju chine jutayaju. Ique cuaya ama jari. Juetima jaritu huecaca tuhua ique casa cabameretiyaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Tuque jadya au jadya juatsutu tuatsehuequi cuanaque Jerusalénju cuacuare. Jesús bacue ejetsunue cuita ama Galileaju aninucacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eje uma huecaca tuatsehuequi cuanaque chine ishu cuahuaju amatu Jesús cuacuaredya. Batayaju amatu cuacuare, etehua cuau jipenee. ");
INSERT INTO cavNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Israelita cuanaja huaraji cuanaratu Jesús ujeu baatsu sarecuare. Chinera cuahua cuanaque ducu tunajatu bacaduranicuare: —¿Bahua amami Jesús? —jadya tunajatu ecana bacaduranicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tuhua jucuare cuanaque tuna Jesúsja ishu quisaraticuare. Etehua quisarati jipenee tuna jucuare. —Jesús tu dyaque jidaque, —jadya tuna umae jucuare. —Aijama, jidaque ama tume. Pusha pusha aridaque tume, —jadyatu jucuare peya cuana. ");
INSERT INTO cavNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Arepa ecana jetiama Jesúsja ishu quisaratiya ama bucha, ejitaju cuita ama tunajatu quisarati acuare israelita huaraji cuanara ebacauju, tunara Jesúsja ishu jida quisarati ayaju bacatsu enerecaturauju caadebatitsu. ");
INSERT INTO cavNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Amena chine patya patya dyane, chine terehuietu Jesús nubiticuare Yusuja etareju. Nubitsutu catibuticuare tuhua cuanaque bahuitya. ");
INSERT INTO cavNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Israelita cuanaja huaraji cuanatu tuque jadya bacatsu anajacatacuare. —¿Eje bucha juatsu jatsu ri riyaque dyaque inime adebabada cuita? Tuque taa tu ecuana cabahuityatihua bucha ama cabahuityatihua. Tujatu ecuita cuana bahuityataqui ama, —jadya tunajatu ecana acuare tuhua anibareya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesúsra tuna quemitsacuare: —Ecue casa tsehue camadya ama tuque ecuita cuana bahuityaya, Ique Cuadishaquija casa tsehue. ");
INSERT INTO cavNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ecue Etata Yusura cuatsashaya eque juya cuanaque tuna bahue ique Yusuja inime eque quisaratiyaque, ai ecue inime ama. ");
INSERT INTO cavNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Aniyatu umae tunaja inime equedya jutidya ecuita cuana bahuitya juya cuanaque, Yusura casa tyaya tsehue ama. Tume cuanaque tuna jadya juya muita ishu cuita camadya. Peya cuana bacue jadya ama. Yusu Tuna Cuadishaquija casa tsehue tunajatu ecana bahuityaya. Tuja cuanaque tuna jadya juya Yusu muimere ishu, tunadya jutidya camuimereti ishu ama. Tuna tuna yuneri quisaratiya. Tunaratu ni ejeque ijahue aya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moisesratu huenecuare micuana dutya tuja cacuatsashati eque ani ishu datse. Jadya ama bucha micuana ni ejequedya jutidya tume cuanaque cacuatsashati eque cuita aniya. ¿Eje bucha juatsu jatsu micuanara iyecara aya? —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jetiama Yusuja etareju jucuare cuanaratu bacacuare Jesús jadya quisaratiyaju. —Miquemi equijahuatique jutidya. ¿Aira jatsumi iyecara aya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesúsra tuna acuare: —Icuene tuque ecue bamere pidya achine casa canajara huecacaju, ujejedaque chachanetsu. Ique jadya juya baatsu micuana eatsehue cahuaitichine, canajara huecacaju mere juhua baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Béru tuna Moisésra deca nana ebacua cuana ecuita huitu biti catibutishacuare cuinana huecaca catsurutihuaju, achaacha eque israelita jadique adebataqui juishu. Riyaque cacuatsashati aijama jarijutu ecuanaja baba cuana ecuita huitu biti catubuti bahuedya jucuare. Arepa canajara huecaca ama bucha, tuque micuana ebacua nana cuana ecuita huitu tubutaqui tumeque huecaca, cuinana huecaca catsurutiyaju. ");
INSERT INTO cavNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Canajara huecacaju micuana jubahuedya jadya, Moisésra cuatsashahua eque ama ejuu tibu. Micuana tumeque huecaca jadya juya tibu, ¿eje bucha juatsu jatsu micuana eatsehue cahuaitiya era ujejedaque canajara huecacaju chachanechine baatsu? Micuanara ique aya iquepa Moisésja cacuatsashati eque ama juya jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Masadama ejeque misida neaume pana bau amaque yuneridya tumeque inime metseque baecuaque. ‘Jidamatu juhua’ jadya neaume ejeque baatsudya jutidya. Cajuchatiya bucha datse ni tuque micuana ebau cajuchatiyaque ama. Micuanara ni ejeque jidama juya jadya aya, pana bahue nejucue yuneridya tumeque jidama juhuaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tumetu umae Jerusalénju cuanaque tuna cama quisaratitibunecuare: —¿Jeequedya ama ri ecuanaja huaraji cuanara iyecara ayaque? ");
INSERT INTO cavNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Nepetacue. Jee di taa junetiya. Ecuita cuana bahuitya juya dutyaja yacuaju. Ni ejeradya jutidya inatsu etare apudaju ishaya. ¿Cacuaretihua ni taa tu inime ecuanaja huaraji cuana? ¿Chamacama ni taa tunajatu ejenehua tumeque ecuita yuneridya Mesiasque? ");
INSERT INTO cavNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Riyaque taa ri eje bucha jue juma Mesías. Bahuedya ecuana riyaque ejuque jehuaque. Mesías neritu muya jutidya junabuque. Ni ejeque buchiquetu bahue jubuque ama ejuque junayaque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesúsra tuna bahuityacuare jari Yusuja etareju. Tuna quisaratiyaque bacatsutu etsuri jebuda tsehue quisaraticuare: —Micuanajatu inime juya ique adebaya bucha. Bahue bucha micuana cabatiya ique ejuque jecuareque. Cuji micuana juya. Ecue inime taca eque camadya ama jecuare, Ique Cuadishaquija inime eque. Tuquetu pusha pusha baecua; dutya tura quisarati ayaquetu ejenetaqui. Adebaya ama tuque micuanara. ");
INSERT INTO cavNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Era camadyatu pana adeba aya, ique tuaquejaquedya jecuare tibu, tura ique cuadishacuare tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","“Yusuja Ecuadishaquedya ique” jadya quisarati aya bacatsu tuna cahuaiticuare. Inatsu tunara tibene risi acara acuare. Jadya ama bucha ni ejeradya jutidya inacuare, eje uma huecaca tunaja tuque ina ishuque huecaca anicuare jari tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Umaeratu ejenecuare tuque Mesiasque. —Ebacadya tuque ecuanaja Mesías neri junatsu patu abuque ni ejeque ecuitaja ataquique ama Yusuja casa bamere ishu jadique. Jesúsra ecuitaja ataquique ama aya tibu, jutaquiju taa tu yuneri cuitadya tumeque Yusuja Ecuadishaque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Fariseo cuanara tuna jetiama, Jesúspa yuneridya Mesías neri jadya juyaju bacacuare. Jadya bacatsu tuna cuacuare pae cuanaja huaraji cuana tsehue quisaratira. Dutyara tupu inime bajejetsu tunajatu ihuaracuare Yusuja etare naruqui cuanaque. —Neinaticue Jesús, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Tuna tumeque inime bajeje juya tuputu Jesúsra ecuita cuana cuejaajecuaredya jutidya: —Ejetsunue cuita ama micuana tsehue aninucaya. Masadama dirunucaya Ique Cuadishaqui queja. ");
INSERT INTO cavNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Sareya datse micuanara ique. Banucaya ama micuanara ique. Eju ique judiruyaju micuana judirutaqui ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","—¿Eju jatsuri riyaque ediruu ecuanaja daditaquima baishu? ¿Ecuanaja ata cuana peya yahua cuana aniyaju ni taa ri dirucara juya? ¿Israelita cuana griego cuana ducuque ni taa ri anisicuaya? ¿Bahuityacaradya ni taa tujatu aya tumebaedya israelita ama cuanaque dyadi? ");
INSERT INTO cavNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ecuanara patu sarebuque. Banucaya amapa tuque ecuanara. Ecuanapa ecuana judirutaqui ama eju tuque judiruyaju. Etehua buchique tume. Adebaya ama tuque ecuanara, —jadyatu israelita cuanaja huaraji cuana tuna camadya jutidya jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jesústu ecuita cuana tsehue quisaratinucacuare. Amena ishuque chine huecacatu jucuare, huecaca dyaque muidaque. Netitsuratsutu Jesús quisaraticuare: —Eaqueja necatyaticue, micuana majunuca baecua anicara juya cuanaque. Nejecue eaqueja, ijicaraque espereju ebutetiu bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ehuene tu Yusuja quisarati: “Eaqueja catyatiya cuanaque tuna eiyacuane juya terenuca baecua ani ishu. Tuna ducudyatu jubuque ena cani ticu baecua buchique”, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jadya cuajayaque tuna Jesúsra cuejacuare; Yusuja Espiritujatu jacanime ama Jesús queja catyatiya cuanaque. Ena cani ticu baecuaque bucha, jadidyatu Yusuja Espirituja jaca baecua juya Jesús queja catyatiya cuanaque. Jadyatu Jesús jucuare, Yusuja Espíritu riyaque yahuaju junama jariju. Junataqui ama jaritu jucuare, Jesús Yusuja yacuaju muita ishu judirunucama jari tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jesús jadya quisaratiyaju bacatsutu tuhua jucuare cuanara bape bape inime tupucuare Jesúsja ishu. —Pusha ama cuitadya riyaquedya ri Yusu equeque quisarati cuejaquique. Mesías junabuque cuejaquiquedya tume, —jadyatu umae jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—Tuque ama tume, —jadyatu peya cuana jucuare. —Tuquetu Mesías cuitadya. Peya cuana bacue jadya jucuare: —Aijama, tuque ama tu Mesías. ¡Eje bucha jadya jue ni tu juma! Tuque Galilea juque junahua tibu, eje bucha jue ni tu Mesías juma. Mesías neritu Galilea juque ama junabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yusuja quisarati ehuene equetu Mesías David eque ejuracanaque jubuque. Belénjutu cuinanabuque, ecuanaja ebaba David emuique anicuare epu juque, —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tumetu ecuita cuanaja juticuare amadya inime Jesús eje buchique. Caquemitsati caquemitsati jutidya ecana jucuare tuna cama. ");
INSERT INTO cavNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Umae cuanaratu inacara acuare. Jadya ama bucha ni ejera inacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yusuja etare naruqui cuanaque tuna Jesusmadya judirunucacuare fariseo cuana queja, pae cuana queja jadya. Jesús dujuya ama baatsu, tunajatu ecana bacaduratsacuare: —¿Eje bucha juatsu jatsu tuque micuana betihua ama? ");
INSERT INTO cavNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Enaruqui cuanara tuna quemitsacuare: —Dyaque jida ecuana bacahua tura quisarati cuana cuejayaque. Aijama tu peya, tuque bucha dyaque jida quisaratiyaque, —jadya tunajatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—¿Micuana dyadi tura micuana ijahuedya ahua? ");
INSERT INTO cavNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Huaraji emuita cuanaque tuna tuaqueja catyatihua ama ni ejeque. Ni ejequedya jutidya ecuana fariseo cuana tuaqueja catyatihua ama. ");
INSERT INTO cavNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ecuita jetiedya cuanaque cuita camadya tuna tuaqueja catyatihua. Jadya tuna juya, ecuanaja cacuatsashati pana adeba aya ama tibu. Tuna tuna aishuque ama. Yusura tuna nerecaturabuque, —jadyatu jucuare israelita cuanaja huaraji cuana. ");
INSERT INTO cavNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tuhuatu jucuare fariseo Nicodemo bacani. Tudyatu Jesús tsehue chineju quisaratira cuacuareque jucuare. Isaracuare tujatu fariseo cuana tuja ecare cuana: ");
INSERT INTO cavNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Dutyara tuque ecuana pana adeba aya ecuanaja cacuatsashati. Tumeque cacuatsashati eque tu tuyu ama ejeque jucha metse aishu, tumeque ecuita tsehue cuitadya quisaratimaque. Pana bahue ecuana jutaqui yuneridya tume jidama juchine jadya atayaque jidama juchineque. Jutaquiju “Jidamami juchine”, jadya amaquedya Jesús, neihuarara ecuanaja yacuaju tuque cuita quisaratisha ishu, —jadya tuna Nicodemora acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tunaratu acuare: —Mira taa tu inime tupuya Galileaju cuanara inime tupuya baedya. Mique taa mi Yusuja quisarati adebayaque ama buchadya quisaratiya, —jadya tunajatu ijaribayaque acuare. —Jesúspa Yusuja quisarati cuejaquique, jadya tuna juya. Isaracue Yusuja quisarati. Tumeque quisarati eque tu ni ejeque Yusuja quisarati cuejaquique Galilea eque junaya ama, —jadya tunajatu acuare pusha pusha ayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jadya juatsu tuna dirubarecuare tunaja etare cuanaju. ");
INSERT INTO cavNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tudyatu Jesús tsuracuare uhua cuemusu Olivo Acui Quini bacaniju. ");
INSERT INTO cavNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Peya huecaca apudajudyatu cuanucacuare Yusuja etareju. Jetiama ecuitaratu jipeticuare. Jipetihuajutu Jesús anibutecuare. Anibute jadya juatsu tujatu ecana bahuityatibunenucacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tumidyatu cacuatsashati bahuityaqui cuanara, fariseo cuanara jadya dujucuare Jesús queja peadya epuna. Arepa tuja yahuique neri aniya ama buchatu peya epuna cuanaja yahuique tsehue ani bijida jucuare. Fariseo cuanara patu peya deca tsehue jarayaju siraracuare. Tumepa tunajatu Jesús queja dujutsu, dutyaja yacuaju nityacuare tunaja peta ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tuhua iyabutyatsu tuna Jesús tsehue quisaratitibunecuare: —Ebahuityaquique, riyaque epuna tuque ecuana peya epunaja yahuique tsehue sirarahua. ");
INSERT INTO cavNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Riyaque epuna tuque ecuana dyaque inime metse baya. Moisésra cuatsashahua equetu tumu tsehue iyetaqui epuna peya deca tuja caquemitiqueremaque jaraquereyaque. Mira bacue ¿eje bucha baya? ¿Tumu tsehue iyetaqui, iyetaqui ama ni taa? —jadya tunajatu acuare tuque nime adebayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Tunaratu Jesús jidama quisaratishacara acuare, tuque jucha metse amerecara aatsu. Tura tuna quemitsacuare ama. Huipuchitanatsutu remecuare jutidya. Reme jadya juatsu tujatu emetucu sapara tsehue yahuaju huenetibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bacadurajacacuare ama tunaja tuque. Remehuaquetu netitsuranucacuare. Pana neti junucatsu tujatu ecana acuare: —Ejeque ni micuana cajuchatima cabatiya ni riya piji buchique, turadya riyaque epuna tumu tsehue maremetse paa, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yudijidya remenucatu jucuare Jesús. Remenuca jadya juatsu tujatu huenenucacuare yahuaju. ");
INSERT INTO cavNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Amena tuja quisarati bacatsu dutyadya ecana juchaquique caadebatibarecuare, dutya jidama inime tupuhuaque adebatsu. Dutya ecana peadya peadya cuinanabarecuare. Esiri cuanaque tuna icuene cuinanacuare, tupuju dutya ecuita cuana. Cuinanatsu tuna Jesús camadya epuna tsehue shanacuare. Amena dutya cuinanaterehuajutu Jesús neticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Peya ecuita cuana cuinanaterehua baatsu tujatu epuna jadya acuare: —¿Are mique jidama acara juhua cuanaque, mama? ¿Ni ejera buchiquemi tumu tsehue marehua? ");
INSERT INTO cavNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tudyatu acuare epunara: —Aama cuitadya, tata, ni ejera bucha. Dutya tuna cuinanaterehua. Tudyatu Jesúsra acuare: —Ni erami cuejaya amadya micue jucha tibu iyetanataquique. Dirucue. Cajuchatinucaume camadya, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yudijidyatu Jesúsra isaranucacuare ecuita cuana Yusuja etareju: —Ique hueca buchique. Yusuja quisarati micuana bahuityaya, micuana dyaque jida tuyu ani ishu. Eratu anishasiriya eaqueja nimee juya cuanaque. Jacaya amadya tuna era. Adebamereya tuna Yusu, tuna ni eje tupu apudaju juneniya cuanaque bucha juishu ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Tura jadya ahuajutu fariseo cuanara jadya acuare: —Miquemi micue inime tacadya jutidya quisaratiya. Jadya tibudya tuque ecuana ejenetaqui ama baya mira cuejayaque, peya mique eje buchique micue ishu quisaratitaqui tibu, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—Arepa ecue inime tacadya jutidya quisaratiya ama bucha, era cuejayaquetu yunerique. Ique bahue ejuque ique junahuaque, eju diruyaque jadya. Micuanara bacue adebaya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Arepa micuanara ique eje buchique adebaya ama ama bucha, micuanara “ecajuchati” jadya aya. Riyaque yahuaju cuanaja inime tupudya jutidya tuque micuana aya. Era bacue ni ejeque buchique “Ecajuchati mique” jadya aya ama, arepa era dutya adebaya ama bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jadya ama bucha, era ni eau “Riyaque ri ecajuchati”, yuneri ecajuchatidya tuque. Era ni aya “Jeequeri ecajuchati”, era camadya amatu jadya aya. Ecue Etataratu tumebaedya aya. ");
INSERT INTO cavNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ecuanaja cacuatsashati Moisésra huenecuareque tu jadya: “Beta ebaqui juhua ecatsera ni tume bae cuinetse aya quisarati, tatsera cuejayaque tu yuneri”. ");
INSERT INTO cavNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Aniyatu beta ecue ishu jida quisaratiyaque, idya cuitadya, tumebaedya ecue Etata Ique Cuadishaquique. Tume bae cuinetse quisarati aya tibu, ejenetaquidya yatse, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—¿Ejeque tuque micue Tata? —jadya tunajatu bacaduracuare. —Ique micuanara adebaya ama. Yutsumadya ecue Etata adebaya ama tuque micuanara. Ique ni micuana eadebau, tumebaedya tuque micuana ecue Etata eadebau, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jeeque tuna Jesúsra cuejacuare Yusuja etareju bahuityayaque. Tuquetu ecuita cuanara Yusuja ishu chipiru ishayaque equiniqui peque juneticuare. Tuque ujeu baqui cuanaratu tibene risi aishu inacara acuare. Jadya ama buchatu ni aira buchique inacuare ama, risita ishuque huecaca tuja juetima jari tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yudijidya bahuityanuca tuna Jesúsra acuare: —Masadama rehuaque dirunucaya. Yanacana cuita micuanara sareya. Banucaya ama micuanara ique. Eju ique dirunucayaju, micuana judirutaqui ama, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Tumetu israelita cuanaja huaraji cuana cabacaduratibarecuare tuna cama: —¿Tuta taca quiyeti ni taa ri juya? ¿Jadya tibu di taa ri jadya juya “Judirutaqui ama micuana eju ique dirunucayaju”? —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—Micuana micuana rehuaque riyaque yahua juque. Ique bacue yuqueja barepa juque, riyaque yahua juque ama. ");
INSERT INTO cavNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Micuana micuana Yusuja jucha secamaque majubuque. Micuanara ni ique ejeneya ama Yusuja Ecuadishaque jadique, eaqueja nimee ama ni micuana juya, tume micuana majudadiya micuanaja jucha cuana apupashamaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—¿Ai jatsu mique? —jadya tunajatu bacaduracuare. Tume tuna Jesúsra quemitsacuare: —Bahuedya ni micuana. Eje uma cuejadya micuana ahua amena. ");
INSERT INTO cavNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Aniya jari tuque ecue jetiama micuana cuejacara ayaque. Adebamerecara micuana aya micuana ecajuchatique. Arepa micuanara ique ejeneya ama ama bucha, era cuejayaque tu yunerique, Ique Cuadishaquique pusha pusha baecua tibu. Tura ique bahue amerehuaqueri era cuejaya riyaque yahuaju cuanaque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesusratu Etataque Yusu jadya ayaque jadya quisarati acuare. Jadya ama bucha israelita huaraji cuanara adebacuare ama. ");
INSERT INTO cavNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jadya tibudya tujatu ecana pana cueja aajecuaredya jutidya. —Iyacua micuanara adebaya ama ique aique. Ique curusuju tatameretsu eje umara micuanara adebabuque ique Yusuja Emepeque. Chamacama micuana umae bahue jubuque era ecue inime taca eque ama ayaque. Chamacama micuana bahue jubuque, era ecue Etatara cuita camadya bahue amereyaque era cuejayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Eratu ajacaya ama Ique Cuadishaquira amereyaque. Jadya tibudyatu tuque eatsehuedya. Jacanime ama tuja ique, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jadya Jesúsra cuejayaju bacatsu tuna umada catyaticuare tuaqueja. ");
INSERT INTO cavNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesústu israelita cuanaja huaraji cuana tsehue quisaratinucacuare, tura cuejayaque ejenequi juhua cuana tsehue: —Micuana ni era amereya eque juajeyadya jutidya, tume micuana yuneridya ecue cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Yuneridya ni micuana ique eje buchique cabahuityatiya, adebadadiyadya tuque micuana yunerique era cuejayaque. Pana adeba aatsu micuana einajacaque bucha. Metsequi bucha micuana jujacaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—¡Ecuana ecuana Abraham eque ejuracana cuanaque! ¡Ni eje tupu ecuana emetsene cuanaque bucha! ¿Eje bucha juatsu jatsumi “Metsequi cuana bucha ecuana jujacaya” jadya juhua? —jadya tunajatu acuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—Cajuchaticaraque cajuchatiya cuanaque tuna emetsene cuanaque bucha, cajuchatijacataqui ama cabatiya tibu. Tunaja ishutu eje bucha cajuchatijacataqui ama, emetseneja tuque metseque eje bucha jacataqui ama bucha. Satanás tu cajuchatiya cuanaque metseque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Metsequiquetu emechiqui jaque ejujacaudya, emechiquira catyati ahuaju. Emechiquija ebacuaque bacue, tuja ebacuaque jujacanime ama. Narujacaya amadya tuja tuque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ique Yusuja Ebacuaque. Era micuana inajacamerehuaju tumetu Satanás ama micuana metseque. Amena micuana tura cuatsashaya eque jutaqui ama. Pana einajacadya micuana juya. ");
INSERT INTO cavNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Arepa micuana Abraham eque ejuracanaque ama bucha, micuanara ique iyecara aya, micuanara era bahuityayaque ejenecarama aya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ecue Etatara bahuityayaque micuana era bahuityaya. Satanás tu micuanaja tata. Micuanaratu tura cuatsashayaque ajacaya ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—¡Aijama! Abraham tu ecuanaja etata. Tuque anicuare bucha ecuana aniya, —jadyatu israelita cuanaja huaraji cuanara quemitsacuare. —Arepa micuana Abraham eque ejuracanaque juya ama bucha, micuana tuque anicuare bucha ama aniya. Yuneridya ni micuana Abraham anicuare bucha anicara juya, tume taa micuana Yusura amereya eque eaniu tuque anicuare bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Jadya ama bucha, arepa era micuana yunerique ecue Etata Yusura bahuityahuaque cuejahua ama bucha micuanara iyecara aya. ¡Abraham tu jadya ejuu ama! Turatu ejenecuare Yusuja yunerique quisarati cuejayaju. ");
INSERT INTO cavNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Satanás juya bae cuitadya micuana juya. Tuque tuque micuanaja tata buchique, —jadya tuna Jesúsra acuare. —¡Aijama, jadya ama tuque! Yusuja biji eque ecuana aniya. Yusu peadya camadya tuque ecuanaja Tata, —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—Ique Yusu quejaque jehua. Tuja casa eque junahua riyaque yahuaju. Yuneridya ni micuanaja Yusu Tata ejuu, iyuhueda micuanara ebau. Ique jehua ecue inime taca camadya ama. Yusura cuadishaya tibu ique jehua. ");
INSERT INTO cavNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ecue quisarati tu micuanaja ishu etehua buchique, micuana tueque jucarama juya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Micuanaja tata tu Ijahua jutidya. Micuana micuana junenicara juya tuja biji eque. Ijahuatu yuequedya quiyeti puji juhua. Tuquetu yuneri quisarati baecua; pusha pushadya jutidyatu tuque juya, tuque pusha pusha arida tibu. Tuque equequedya tu dutya yuneri quisarati baecua cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ique bacue pusha pusha baecua. Jadya ama bucha micuanara ejenecarama aya. ");
INSERT INTO cavNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Dutyara micuanara adebaya ique cajuchatimaque. Ni ejeja micuanaja “ecajuchati” jadya ataqui ama. Jutaquiju jatsu micuanara ¿eje bucha juatsu ejenecarama aya era yunerique cuejayaju? ");
INSERT INTO cavNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yusuja cuanaquetu tuja quisarati equedya juya. Yusu jaque ama micuana. Jadya tibudya tuque micuana Yusuja quisarati bacacarama aya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Israelita cuanaratu acuare: —Yuneridya mique ecuana ijahua cuanara quijahuatishayaque jadya achine. Masa dyadi mi Samaria juque, ecuanara quisarati ahua baedya, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—Ique equijahuatique ama. Ni ejeque ijahuara ique cuatsashaya ama. Eratu ecue Etata muiya. Micuanara bacue ique muiya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Arepa ique ita taca camuiticarama juya ama bucha, ecue Etatara ique muimerecara aya. Turatu nerecaturabuque ique muicarama juya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pusha amadya micuana aya. Ejeque era cuejaya eque aniyaque tu maju ishuque ama, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tumetu israelita cuanaja huaraji cuanara acuare: —Jadya mira cuejayaju bacatsu, ecuana bahuedya mique equijahuatique. Abrahamtu Yusura amerehua eque anicuare. Jadya ama buchatu majucuare. Beru Yusuja quisarati cuejaqui jucuare cuanaque tuna Yusura amerehua eque anicuare. Jadya ama bucha tuna majucuare. Tume jatsumi ¿eje bucha juatsu “Ejeque era cuejaya eque aniyaque tu maju ishuque ama” jadya juya? ");
INSERT INTO cavNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham, Yusuja quisarati cuejaqui cuanaque jadya tuna majucuare. ¿Ejetsunuetu micue tunaja bucha dyaque casa aniya maju ishu ama? ¿Ai bucha jatsumi mique cabatiya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jadya tuna juyaju bacatsu tuna Jesúsra acuare: —Ique ni ita tacadya jutidya ecasumitiu, tume taa ni aira buchique eejeneu ama. Jadya ama bucha ita taca ama camuimeretiya; ecue Etatara muimereya, tumeque micuanara micuanaja Tatapa Yusu ejuu jadya ayaquedya. ");
INSERT INTO cavNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Micuanaratu adebaya ama. Era camadyatu pana adeba aya. Ique ni “Yusutu era adebaya ama”, jadya ejuu, pusha pusha arida ejuu, micuana bucha. Tume bacue eratu yuneri adebaya. Eratu aya tuja eje bucha quisarati juya equedya. ");
INSERT INTO cavNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abrahamtu dyaque pureama jucuare, ejeque huecaca ique, Einajacamerequique junaya jadya bahue juatsu. Ique baatsutu dyaque pureama jucuare, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—¡Eje bucha jadya juemi ejuu! Aijama jari taa tuque micue ni pishica tunca mara. ¿Tume jatsumi eje buchique “Abraham tuque ecue eba” jadya juya? —jadyatu israelita cuanaja huaraji cuanara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—Era cuejayaque tu yuneridya. Ique anihua Abraham ejitaju junime ama jariju, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jadya ayaju tunajatu tumu inacuare, tuque iyecara aatsu. Tunara jadya ayajutu Jesús etehua cuinana jucuare Yusuja etare juque. ");
INSERT INTO cavNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesusratu badirucuare ecuita yuequedya shuhui ecuinanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","—Ebahuityaquique, pusha amadya ni ri riyaque aija juchaju cuana jadya cuinanahua. ¿Shuhui ri, ecuaque, etataque ecatse cajuchatihua tibu, tuja cuita juchajudya ni taa? ¿Aija juchajuri riyaque shuhui cuinanacuare? —jadya tuque ecuana bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesúsra ecuana quemitsacuare: —Micuana micuana dyaque cuji eju. Ni ejeja juchaju amatu tuque jadya cuinanahua. Jadyatu cuinanahua, ai tuja juchaju ama ni tuja etataque ecuaqueja juchaju ama. Riyaque ecuita tu shuhui, tuque capetatiya baatsu, peya cuana Yusuja dyaque casa aniyaque bahue juishu. ");
INSERT INTO cavNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yusura ique cuadishahua tuque cuarequi mere juishu. Huecada tupu camadya ecuana mere juya bucha, jadidya tuque ecuanaja meretaqui emajaca aniya jari tupu. Apunahuaju bacue ecuana amena mere jujacaya. Jadidyatu juetibuque huecaca ecuanara tuque merejacadadiyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ique riyaque yahuaju aniya tupu, ique hueca bucha, era micuana Yusu adebamereya tibu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jadya quisarati aatsu tujatu ecuedi pushacuare yahuaju. Uyuuyu pijitu acuare tuja ecuedi tsehue. Tumeque uyuuyu tsehuedya tujatu pepacuare shuhuija yatucaju, tuque capetatisha ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—Cuacue. Cajibururutiticue enahuicuare Siloé bacaniju, —jadyatu Jesúsra shuhuique acuare. (Siloé jadique tu “ena jiriquini peya ejiri quiniju pacacadiruyaque”). Cuaatsutu shuhuique cajibururutiticuare. Juetinucatsutu capetaticuare amena. ");
INSERT INTO cavNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jadya baatsutu tumeque ecuita aniya peque aniya cuanara tumebaedya icuene tuque chipiru bacaani juyaju baqui jucuare cuanara jadya acuare: —Nepetacue. Riyaque ecuitadya ri chipiru baca juyaque anianicuareque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—Tudya tume. Tumeque ecuitadya tume, —jadyatu umaera acuare. —¡Aijama! Tumeque bataqui cuitadya tuque. Jeeque ecuita ri peya. Tuque ama tume, —jadyatu peya cuana jucuare. Tumetu Jesúsra capetatishahuaque jadya cacuejaticuare: —Idya ique; shuhui cuinanacuarequedya ique. ");
INSERT INTO cavNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—¿Eje bucha capatatiemi juhua? —jadya tunajatu bacaduracuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—Tumeque ecuita Jesús bacaniratu uyuuyu piji ahua. Tumeque uyuuyu tsehue pijidya tura yatucaju pepahua. Tuequedya tura ahua: “Cuacue Siloéju. Cajibururutiticue.” Jadya tura ahuajudya ique cuahua. Cajibururutitihua. Cajibururutititsu amena capetatihua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Eje dyane jatsu tumeque ecuita? —jadya tunajatu acuare. —Juhua aba. ¿Eje queja cuana taa rique? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Canajara huecacajutu Jesúsra tuja ecuedi tsehue uyuuyu aatsu shuhuique capetatishacuare. Jadya tibudyatu umaera capetatihuaque fariseo cuana queja dujucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Junatihuajutu fariseo cuanara bacaduratsacuare: —¿Eje bucha capetatiemi juhua? —Jesúsra pepahua uyuuyu tsehue yatucaju. Jadya ahuaju cajibururutitihua. Cajibururutititsu amena capetatihua, —jadya tujatu ecana quemitsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tuequedya umae fariseo cuana jadya jucuare: —Tuque capetatishaquiquetu canajara huecacaju mere juhua. Jadya tibudya ni tu Yusu equeque amadya, cacuatsashati cuana eque ama juya tibu. Peya fariseo cuana bacue jadya jucuare: —Shuhui cuanaque capetatishaquiquetu juchamaque ejuu. ¡Eje bucha bameree ni tu ama Yusuja casa cajuchatiyara! —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Adebataqui ama baatsu tunajatu yudijidya bacaduranuca acuare Jesúsra capetatishahuaque: —¿Eje bucha tuquemi inime tupuya tumeque ecuitaju? Tura mique capetatishahua tibu, ¿ai bucha tuquemi adebaya? —jadya tunajatu acuare. —Tudyatu Yusu equeque quisarati cuejaquique. Tuquetu Yusuja Ecuadishaque, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Israelita cuanaja huaraji cuanaratu ejenecarama acuare. —Shuhui ama tucuetu cuinanacuare, —jadya tuna jucuare. Jadya tibudya tunajatu ihuaracuare tuja etataque, ecuaque jadya bacadura ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","20","—¿Metseja bacuadya ri riyaque ecuita? —Jejee, yatseja ebacuadya tume. —¿Shuhuiri cuinanacuare? —Jejee, shuhuidyatu cuinanacuare. —¿Tume jatsuri iyacua eje bucha capetatie juya? ");
INSERT INTO cavNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","—Juhua aba. ¿Eje bucha capetatie cuana taa tu juhua? Baecua yatse aira tuque capetatishahuaque. Tuquetu amena esiri. Ebacua piji ama tuque. Ita nebacaduracue tuque. ¡Eje bucha cacuejatimaedyatu juma! —jadya tuna etataque ecatsera acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Tatsejatu inime jucuare: —Ecuanaja huaraji cuanatu juchine: “Nubitaqui amatu caradati ishuque etareju ‘Jesús tu Yusuja Emepeque’ jadya ejenequi juyaque”. Jadya tibudya tatse huaraji cuana mubatsu jadya caquemitsaticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jadya tibudya tuna ecuaque etataque ecatsera jadya acuare: “Ita taa nebacaduracue. Tuquetu amena esiri. Ebacua piji ama tuque”. ");
INSERT INTO cavNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Yudijidya ihuaranuca tuna anucacuare capetatihuaque. —Tuyu ecuana cuejacue, Yusura mira dutya quisarati ayaque bacayaque adebatsu. Ecuana ecuana bahue mique capetatishaqui juhuaquetu jucha aridaque. ¿Jadidya? ");
INSERT INTO cavNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Ique baecua tuque juchaqui, juchama jadique. Camadya ique bahue. Ique yuequedya shuhui capetatiyaque ama tura capetatishahua, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yudijidya bacadura tunajatu anucacuare tumeque ecuita: ¿Eje bucha capetatishae cuita turami ahua? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—Amena micuana cueja beta ahua. Ejenecarama micuanara aya. ¿Aishu jatsu micuana yudijidya cuejanuca cuejanuca eau? ¿Micuana ni taa micuana junenicaradya juya tuatsehue? —jadya tuna ecuitara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ecahuaiti tuna jucuare tuatsehue. Ijillahuanacuare tunaja tuque. —¡A, aijama! Ecuana ecuana tuatsehue junenicarama juya. Mique taa tuatsehue junenicue, ecuana aijama. Ecuanaratu ejeneya Moisésra huenecuareque camadya. ");
INSERT INTO cavNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ecuana ecuana bahue Yusu Moisés eque quisaraticuareque. Jesús bacue ecuana adebaya ama ni riya piji buchique, ni ecuana bahue aira cuadishahuaque, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ecuitara tuna jadya anucacuare: —Micuana micuana dyaque inime adebabada cabatiya. Jadya ama bucha micuana baecua aira cuadishahuaque. Baecua micuana ejuque tuque jehuaque ique capetatishaquique. ¡Era taa bape baya, micuana tuque ejuque baecua baatsu! ");
INSERT INTO cavNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ecuana ecuana bahue, Yusura juchaquique tuatsehue quisaratiyaju bacayaque ama. Turatu bacaya tuja biji eque aniya cuanaque cuita camadya. Tuque muiqui cuanaque camadya tujatu ecana bacaya. ");
INSERT INTO cavNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Yahua nanada equeque riyaque huecaca tuputu ni ejejadya jutidya ecapetatishau shuhui cuanaque. Jadya ama bucha Jesúsra iyacua capetatishahua. ");
INSERT INTO cavNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tuque ni Yusuja Ecuadishaque ama ejuu, eje bucha capetatishaedya tura ama. Yusuja casa tsehueque ama tu aidya juma, —jadya tuna ecuitara acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—¡Miquemi peya cuana bucha dyaque jucha aridaque! Micue juchajudyami shuhui cuinanacuare. Mique jadya ama bucha, mira ecuana ecuana cuitadya bahuityacara aya, —jadya tunajatu acuare. Cuinanashacuare tunajatu tunaja yacua juque. ");
INSERT INTO cavNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesústu bahue jucuare tumeque ecuita tunara tunaja yacua juque cuadishahuaque. Tuequedya tujatu tsuruticuare quisaratiquere ishu. Tsurutsatsu tujatu jadya bacaduratsacuare: —¿Midyami ECUITA queja catyatihua? —jadya tujatu atsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—¿Ejeque tuquemi jadya aya, tata? Bamerecue ique, ique ejeque mira jadya ayaque bahue juishu, ique tuaqueja catyati ishu, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—Tudya tuquemi iyacua cuita petaya. Tuatsehuedyami quisaratiya. Idya IQUE ECUITA. ");
INSERT INTO cavNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jadya bacatsutu nuyucuare Jesúsja yacuaju, tuque muiyaque. —Iyacua ique miaqueja catyatiya, Ique Cuatsashaquique, —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—Ique riyaque yahuaju jehua eaqueja catyatiya cuanaque jidaque tyaishu, ique bijidamaduraqui cuanaque nerecatura jadya aishu. Yusuja quisarati adebaya ama cuanaque tuna shuhuique bucha. Ique jehua tuna Yusuja quisarati adebamerera, tuna shuhuique bucha ama juishu. Peya cuanatu yanacana adebayapa tuna Yusuja quisarati jadya juya. Jehua ique tunara adebaya ama jadique bamerera, capetatiya bucha cuanaque shuhui amerera, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jadya quisaratiyaju bacatsutu umae fariseo cuana tuque peque cuanaque jadya jucuare: —¿Ecuana ni taa mira ecuana shuhui buchadya baya? —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesúsra tuna acuare: —Aijama ni micuanaja Yusu eje bucha adebae aishuque ejuu, dyaque cuita ama micuana ecajuchati ejuu. Tume micuana dyaque ecajuchati, tura cuatsashaya eque ama aniya tibu, arepa micuana pana adeba aya jadya juya ama bucha. Yusura micuana shuhuique bucha baya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yume bucha isaranucadyatu Jesúsra acuare fariseo cuana: —Peadya ecuitatu uhuisha taracaju etsecue eque ama nubicuare. Taraca dyaque eque tsuratsu jutidyatu nubicuare. Tumequetu emechiqui ama jucuare, chiri puji jutidya. Uhuisha cuana ina, duju jadya aishu jutidyatu nubicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Anicuaretu peya ecuita. Tumetu etsecue eque nubicuare. Tuquetu uhuisha cuana metseque neri jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Etsecue naruquiratu etsecue pacashaya uhuisha naruquique neri nubi ishu. Tume tujatu uhuisha tunaja ebacani eque cama ihuarabareya. Uhuisha cuanara tujatu etsuri adebaya. Tura tuna taraca juque etsecue eque cuinanashaya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tuna cuinanashatsu tuna turadya huidujuya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tunara adebayara ama huidujucara ayaju tunajatu tupujudya aya ama. Huanaya jutidya tuna, tuja etsuri adebaya ama tibu, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jadya cuatsabiji cuejayaque tuna Jesúsra acuare; tuja cuanaratu tuque adebaya, uhuisha cuanara enimetseque neri eadebau bucha. Jadya ama bucha tuna huecatanacuare ama tura cuejayaque. Ai ibeda buchiquetu tunaja ishu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jadya tuna Jesúsra bahuityanucacuare: —Pusha amadya micuana cuejaya. Ique etsecue buchique, uhuisha cuana nubiquique etsecue buchique. Ique equetu Yusu queja nubidirutaqui. ");
INSERT INTO cavNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ique junama jariju tuna jetiama junacuare. Yusuja ecuadishaquepa jadya tuna jucuare; yuneri ama. Tunadya tuna chiri puji cuana buchique; uhuisha metsequi cuanaque dujucara juya buchique tuna. Eaqueja catyatihua cuanaque tunajatu eaquejaque nime huallacara datse aya. Ecue cuanara tunajatu quisarati bacaya ama, uhuisha cuanara tuna metseque ama bacacarama eau bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Idya Yusu queja enubicuare. Uhuisha cuanatu taracaju nubihuaju aija eje bucha ataqui ama; jadidya tuque eaqueja catyatiya cuanaque inajacamerebuque. Uhuisha cuana nutsa jidaju araara ishu dujuta bahue bucha, jadidyatu era tyaya ecue cuanaque tunara sareya cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Chiri pujitu nubi bahue chirira, uhuisha cuana tsapetilla ishu, iye jadya aishu. Jadya ishu camadyatu nubi bahue taracaju. Ique bacue jecuare eaqueja catyatiya cuanaque dyaque jida, pureama ani ishu, tuna ani siri ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ique uhuisha metseque uhuisha cuana jida canarutiyaque buchique. Uhuisha jida naruquique tuja uhuisha cuna jiteque equiyemeretiu bucha, jadidya ique iyetadadiya ecue cuanaque jiteque. ");
INSERT INTO cavNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Etsahuaquiratu uhuisha cuana naruya etsujequi ina ishu cuita camadya, ai tuna narucara aatsu ama. Tuquetu tuna naruquique ama ni tuna metseque. Jadya tibudya tujatu iba batsatsu, uhuisha cuana shanaya. Tujaque ama tibu, tujatu ecana icueneya ama. Tumetu ibara aracara ayaju uhuisha cuana dutya queja tsapetanatereya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jadya tu Yusuja ama ecuadisha cuanaque. Naruya ama tunajatu ecue cuanaque. Shanaya jutidya tunajatu ai mudaque baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","“Ique uhuisha naruqui neri buchique, ecue cuanaque jida naruquique. Adebaya tuque ecue cuanaque. Ecue Etatara ique adebaya, iyuhueda jadya baya. Era dyaditu adebaya, iyuhueda jadidya baya. Tume bae nucadyatu era ecue cuanaque adebaya, iyuhueda jadya baya. Tunara bacue ique iyuhuedadya baya. Uhuisha naruquira tuja uhuisha cuana jida naruya bucha, tumebaedya ique ecue cuana jiteque iyetadadiya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Dutya uhuisha cuana tu peadya taracaju yuhua cama ama. Tumebaedyatu ecue cuanaque riyaque epuju camadya ama aniya; dutya queja tuna aniya. Tuna tuna eaqueja catyatidadiya. Tuna tuna era anishacara aya eque anidadibuque. Peadya camadya bucha tuna amereya, uhuisha cuana peadya cuareque camadya bucha. Ique peadya camadya tuna naruquique judadiya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ique iyetanadadiya tuna Ijahua quejaque inajacamere ishu. Majutsu chacha netitsuradadinucaya. Tume ecue Etatara dyaque iyuhueda baya tuja inime juya eque ique tuna inajacamere ishu iyetanadadiya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ique ecue inime taca eque iyetanadadiya eaqueja catyatiya cuanaque inajacamere ishu. Jadya jutaquique ama juatsu, ni aira buchique ique eiyeu ama. Aniya ecue inime iyeta ishu. Chacha netitsuranuca ishu ecue inime aniyadya. Jadyatu ecue inime tacaquedya jutidya, tumebaedya ecue Etataja inime ique majutsu netitsuranucaya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jadya cuejayaju bacatsutu israelita cuanaja huaraji cuanaja dutya tupu ama inime jucuare Jesús bacanuca ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Tumequetu ijahua cuanara quijahuatishayaque. Equijahuatique tume. ¿Eje bucha juatsu jatsu tuque micuana bacayadya jutidya? —jadya tuna jucuare jetiama. ");
INSERT INTO cavNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—Aijama, equijahuatique ama tume. Ni ejeque equijahuatiquetu tuque quisarati bucha jida piji equisaratiu ama. Eje bucha capetatishanucae ni tu ama equijahuatira shuhui cuanaque, tura ahua bucha, —jadyatu peya cuana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Eje uma huecaca junucatsutu israelita cuanaja huaraji cuana tsehue Jesús quisaratitinucacuare. Eje uma badi cuetihuaju tuna chine junucacuare Jerusalénju. Mara cuetihuie tuque ecuanaja chine abahue jucuare, ecuanaja baba cuanara Yusuja etare asicada cuanaque pana cuinanasha acuareque adeba ishuque. ");
INSERT INTO cavNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesústu junenicuare Yusuja etare ehueji quinida emaque Salomón Adeba Ishuque bacaniju. ");
INSERT INTO cavNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Israelita huaraji cuanara baatsu tunajatu tabucuare. Bacaduracuare tunaja tuque: —¿Midyami Mesías Yusuja Emepeque? Ejitaju adebataqui ecuana cuejacue mique jadique juatsu, ecuanaja ejene piisi aishu. Beru mira ecuana amena cuejacuejanichine ecuanaja adebataqui ama, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Tudya tuna Jesúsra quemitsacuare: —Jadya datse micuana cuejahua ique aique. Ejenecarama micuanara ahua. Eje uma audya tuque ahua Yusuja casa bamere ishu. Tume cuanaque aatsudya micuana ejitaju bamerehua ique Mesiasque, Yusuja Emepeque. ");
INSERT INTO cavNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Micuanaratu ejeneya ama ique Mesiasque, micuana ecuique ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ecue cuanara ique adebaya ique aique. Eratu adebaya eje cuanaque ecue cuanaque. Uhuisha cuana tuna naruquira amereya eque juya bucha, jadidyatu ecue cuanaque era amereya equedya juya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Eratu ecue cuanaque majunuca baecua anishaya. Ni eje tupu jacanuca ishu ama tuna Yusuja yacuaju judirubuque. Aija secanime ama ique. ");
INSERT INTO cavNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ecue Etatara tuna eaqueja nimee amerehua. Aijamatu peya tuque bucha casaeque. Ni aira buchique tuna ecue Etataja emetucu juque secaya ama. ");
INSERT INTO cavNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ecue Etataja casa aniya bae cuita nucadyatu ecue casa aniya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jadya tuque juyaju bacatsutu israelita cuanaja huaraji cuanara amena inaticuare tumu, tuque iyecara aatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","—Eje uma audya tuque micuanaja yacuaju achine ai jidaque ecue Etataja casa tsehue. ¿Ai, eje buchique era achine baatsu micuanara tumu tsehue acara aya? —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—Miquemi ecuita jutidya; miquemi Yusu tsehue beta tupu ama. Pusha pusha juyaquemi Yusu tsehue beta tupupa mique jadya juya. Miratu Yusu cahuaitishaya micue quisarati tsehue. Jadya tibu mique ecuana tumu tsehue acara aya, ni mira ai jidaque ahua tibu ama, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesúsra tuna quemitsanucacuare: —Micuanaja cacuatsashatiju tu ehuene Yusu jadya jucuareque: “Micuana micuana yusu cuana”. (Jadya tujatu quisarati ahua ecuatsashaqui cuanaque jadya ayaque, Yusuja casa eque ecana enaruqui juhua baatsu.) ");
INSERT INTO cavNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Bahuedya ecuana Yusuja quisaratiju ehueneque pusha pushaque ama, ni riya piji buchique. Yusura cuitadyatu acuare tura tuja quisarati bacamerehua cuanaque “yusu cuana” jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yusura cuitadya ique mepehua riyaque yahuaju cuanaque Ijahua quejaque inajacamere ishu. Turadya ique rehua cuadishahua. ¿Eje bucha juatsu micuana erapa Yusu cahuaitishaya jadya aya, ique Yusuja Ebacuaque jadya juhua baatsu, beta tupu tuque yatseja casa aniya jadya ique juhua baatsu? ");
INSERT INTO cavNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Era ni ecue Etatara ayaque aya ama, jutaquiju neejeneumedya ique tuaquejaque jehuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Era cuejahuaque bacatsu ni micuanara ejenecarama aya, era Yusuja casa bamere ishu ahua eque neejenecue. Micuanara ni yuneridya ejeneya ique Mesiasque, tume micuanara yuneridya ejeneya ecue casa ecue Etataja casa tsehue beta tupuque, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jadya juyaju bacanucatsutu israelita cuanaja huaraji cuanara dujucara anucacuare risitsu. Jesústu huananucacuare jutidya. ");
INSERT INTO cavNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús, ecuana tura mepehua cuanaque jadya ecuana dirunucacuare Jordán cueri yueque macare. Tuhua ecuana judirunucacuare Juan ecuita cuana utsa icuene jucuareju. ");
INSERT INTO cavNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Umada ecuita cuanaratu baticuare tuque quisaratiyaju bacacara aatsu. —Juan Ecuita Cuana Utsaquiratu acuare ama ni ai buchique ecuitaja ataquimaque. Jadya ama bucha tura ecuana cuejahua riyaque ecuita eje buchique. Dutyadya tujatu cuejahua riyaque ecuita eje buchique yuneridya, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tume tuna Jesús queja tuhuaque jetiama catyaticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Anicuaretu ecuita Lázaro bacani. Cujejedaditicuare tuque. Tuquetu María, Marta jadya tsehuequique jucuare. Betaniaju tuna anicuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariatu Ecuana Cuatsashaquija ehuachiju etseri ijimedaque juratillaqui jucuareque jucuare, juratsu etsaru tsehue tillaqui jucuareque. ");
INSERT INTO cavNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Tatse tsehuequique ujejeda juhuaju tatsejatu Jesús cuejamerecuare. —Ecuana Cuatsashaquique, Lázaro micue iyuhuedaque tu dyaquene cuita, —jadyatu cuejamerehuara Jesús cuejaticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jadya quisarati bacatsutu Jesús jucuare: —Jejee, ujejeda dyaquene cuita tuque. Yusu casa cabamereti ishutu jadya juya. Yusu, ique jadya muita ishutu jaya juya. Ai tuque maju ishu ama tu jadya, —jadyatu Jesús jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iyuhuedatu Jesúsra Marta, María, Lázaro jadya bacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Arepa tuna iyuhueda baya ama bucha, Lázaro ujejeda dyaquene cuita jadya bacaya ama buchatu yume cuau ama jucuare. Aninucacuaretu tuhua beta huecaca. ");
INSERT INTO cavNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jadya juatsu ecuana Jesúsra acuare: —Necuanucara iyacua Judeaju, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—Ecuana Bahuityaquique, amena ishu mique Jerusalénju jutihuaju taa mi israelita cuanaja huaraji cuanara tumu tsehue iyecara achine. ¿Tumemi eje bucha juatsu tuhua cuacara junucaya? —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—Cuayadya ique. Ijetira ecuana peadya tunca beta earacana ura udaya dutya huecaca. Ejeque huecadaju ajeyaquetu chicaya ama, tura riyaque yahua juque hueca eque petaya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ejeque meta ajeyaquetu echicau, tuja hueca ama tibu, —jadya ecuana Jesúsra acuare. (Jadiquetu Jesúsra quisarati jadya acuare. Tuquepa eje bucha iyetae juma Yusura huecaca iyahuaque juetimaju.) ");
INSERT INTO cavNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yara tupu juatsu tura ecuana cuejanucacuare: —Ecuanaja iyuhuedaque Lazarotu tahuiya. Pacabatishati era, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—Tahuiyaque juatsutu mejemeje juya, Ecuana Cuatsashaquique, —jadya tuque ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jadya quisarati ayaquetu Jesúsra “Lazarotu majuchine” jadique jadya acuare. Ecuanaratu cuji cuita juatsu “Lázaro tahuiya” cuana bucha jutidya bacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Tume ecuana Jesúsra pana cueja acuare ecuana bahue ishu: —Lazarotu amena majuchine. ");
INSERT INTO cavNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Cuachine ama ique tuque ujedaque bahue juya tsehuedya. Iyacua micuana ecue casa bamereya, micuana eaqueja nimee juishu. Micuana ni eaqueja nimee camadya juya, tume ique dyaque pureama juya. Ita iyaja cuita emajuque nebatira, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—Ecuana dyadi tuatsehue necuaradya. Tuatsehue iyepee tuna neara, —jadya ecuana Tomásra acuare, pere cuinanacuarera. ");
INSERT INTO cavNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","18","Junaticuare ecuana Betaniaju. Tumeque eputu Jerusalén japadama jucuare, quimisha kilómetro jujeri. Lázaro aniyaju junatima jarijudyatu umae cuinanacuare Jesús cuejara. —Lazarotu amena majuchine. Pushi huecaca tuque ecuana amena emajuque papachineque, —jadya tunajatu cuejatsacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Enuuque ecatse Marta, María jadya tatse paya jadya jucuare. Jetiama tatseja ata cuana peya cuana jadya tuna cuacuare tatse nime perera. ");
INSERT INTO cavNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta tunajatu cuejacuare Jesús amena japadama juajeyaque. Bahue juatsu tujatu cuinanatsu tsurutsacuare. María bacue cuinanacuare ama etare juque. ");
INSERT INTO cavNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martatu juticuare ecuana queja. —Ique Cuatsashaquique, mique rehua juchineque juatsu taa ecue enuu majuquena ama juchine. ");
INSERT INTO cavNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ique taa bahue Yusura mique mira dutya bacayaque tyayaque. Mira ni tuque eisarau ecue eatsehuequija ishu, Yusura taa tuque micue quisarati ebacau, —jadya tujatu atsacuare Jesús. ");
INSERT INTO cavNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—Micue nuutu emaju jaraya ama, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Jejee, adebayadya tuque era, tuque emaju jarasiriyaque ama. Bahuedya ique tuque dutya emaju cuanaque netitsuranucayaque huecaca chacha netitsuranucabuqueque, —jadyatu Martara Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","—Idya emaju cuanaque chacha amerequique. Idya emaju cuanaque nityatsuraquique. Eaqueja catyatiya cuanaque, arepa majuya ama bucha tuna chacha netitsuranucabuque. ");
INSERT INTO cavNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Eaqueja catyatiya cuanaque tuna majutsu, chacha netitsuranucabuque. Yusuja yacuaju tuna chacha anibuque majunuca ishu ama. ¿Ejeneyadya mira? —jadyatu Jesúra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—Jejee, Ique Cuatsashaquique. Ejeneyadya tuque era. Midyami Mesías, Yusuja Emepeque. Yusuja Ebacuaque mique. Midya mique ecuana ihuacuareque, —jadyatu Martara Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jadya quisarati amena aatsutu Marta cuacuare ejanaque María cuejara. Inime eque piji tujatu cuejacuare peya cuanara ebacauju: —Ecuana Cuatsashaquique ri rehua. Ihuaramerehua tura mique. Jecuepa, —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jadya bacatsutu nere netitsuraquena jucuare. Jadya juatsutu Jesús tsehue quisaratira cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Junatima jari ecuana Jesús tsehue epuju jucuare. Martara tsurutsahuaju jari ecuana jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tuequedyatu tuja ata cuana María nime perera cuahua cuanaque tuque nere netitsura juatsu cuinanaquenayaju baatsu, tuna tupujudya acuare, tuque uhuacuareju enuuque enapara cuana cuaya bucha baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Tumetu Mariara ecuana queja junatitsu bacuare Jesús. Junatitsutu nuyunaticuare Jesúsja yacuaju. —Ique Cuatsashaquique, mique rehua juchineque juatsu taa ecue enuu majuquena ama juchine, —jadya tujatu aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Mariatu paya jadya jucuare. Tumebaedya tuque tajiaje juhua cuanara paquerecuaredya. Tuque dyaque peya inime baatsutu Jesús dyadi niju pau, peya inime jadya jucuare. Dyaque peya inime ishutu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Tume tujatu ecana bacaduracuare tuhua jucuare cuanaque: —¿Eju tunajatu Lázaro emajuque ishachine? —Banacue, Ecuana Cuatsashaquique, —jadya tunajatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Tuhua junatitsutu Jesúsra enapacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Paya baatsutu israelita cuana tuhua jucuare cuanaque jadya jucuare: —¡Dyaque iyuhueda tujatu Lázaro yanume juchine! ");
INSERT INTO cavNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Umae cuana bacue jucuare: —Riyajari casa aniya atucama cuanaque capetatisha ishu. ¿Eje bucha amae di taa rejari aquena juchine Lázaro maju ishu ama? —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tumetu Jesús cuacuare Marta, María, peya cuana tuhua jucuare cuana tsehue Lazaroja uhuacuareju. Dyaquetu capeyainimeticuare. Lazarotu eisha jucuare tumu ebari caniju. Cani tsecuetu tumu ebari tsehue etumu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tuhua junatitsu tuna Jesúsra cuatsashacuare: —Nenityasicuacue tumeque tumu etsecue penequique, —jadya tujatu ecana acuare. —Jadya juume, Ecuana Cuatsashaquique. Riya taa tu ecayuamati amena. Pushi huecaca tuque ecuana amena ishachineque, —jadyatu Marta majuchineja enuuquera Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—Yuneridya ni mi eaqueja nimee juya, Yusurami tuja casa bamereya micue yacuajudya. ¿Jadya ama jatsu mique ahua? Ique pana ejene acue, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Tura jadya ahuaju tunajatu tumu nityasicuacuare. Ebarucue queja bajiyutsutu Jesús Yusu tsehue quisaraticuare: —Ecue Etata, yusurupai mique aya, mira ique bacaya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Adebaya tuque era, mira ique dutya huecaca era isarayaju bacayaque. Etsuri jebuda tsehuedya mique isaraya, rehua eatsehue cuanaja baca ishu, tunaja yuneridya ique micue ecuadishaque ejene ishu, —jadyatu Jesúsra Yusu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jadya juu jadya juatsu tujatu isaracuare jebuda: —¡Lázaro, cuinanacue tuhuaque! ");
INSERT INTO cavNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Tumetu emajuque chacha netitsuracuare. Cuinanacuaretu caniju ishatanachineque. Chamacamatu cuinanacuare emetucu ecatse ehuachi ecatse jadya pirurichineque jirama tibu. Tuja ebutsequini bacue eraca tsehue edunu jadique. —Pana jira neacue. Pabucucu, —jadya tuna Jesúsra acuare. Jadya ayaju tunajatu jiracuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jadya Jesúsra ahuaque baatsutu umada israelita cuana María tajira cuahua cuanaque catyaticuare Jesús queja. ");
INSERT INTO cavNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Peya cuana bacue cuacuare fariseo cuana queja, Jesúsra eje bucha ahuaque cuejara. ");
INSERT INTO cavNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tumetu fariseo cuanara pae cuanaja huaraji cuana cuejaticuare. Masadama tuna dutya israelita cuanaja huaraji cuana dyaque arida cuanaque casitaticuare. —¿Eje bucha tuque ecuana Jesús eau? Dutyara bayaju taa tu aya Yusuja casa bamere ishuque. Jadya tibu taa ecana amena jetiama tuaqueja catyatiya. ");
INSERT INTO cavNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","¿Eje bucha jatsu tuque ecuana eau, tuja tume cuanaque ajaca ishu? ¿Eje bucha jatsu tuque ecuana eau, ecuita cuana tuaqueja catyatijaca ishu? Tuja cuanara ni ecuari bacanishaya, tume taa tu ecuanaja enaruqui Romajura ecuadishau rehua sudaru cuana ecuanaja epu tilla ishu. Tume taa tunajatu Yusuja etare erihuishatillanau. Ecuanaja baba cuanaja bahue eque taa tunara ecuana eanishajacau, —jadya tuna tuna cama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifástu tumeque mara pae dyaque muidaque jucuare. Tuquetu quisaraticuare: —Micuana micuana baecua ni ai buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Dyaque jida neiyera jutidya Jesús, dutya ecuana etillatau tibu. Dyaque jida peadya camadya pamaju, dutya ecuana emajuuju, —jadya tuna Caifásra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Turatu adebacuare ama eje buchique tura quisarati ayaque. Arepa tuque tumeque mara pae dyaque muidaque juya ama buchatu Jesús tsehue cahuaiticuare jutidya. Jadya ama buchatu Yusura adebamerecuare Jesús israelita cuanaja ishu majudadiyaque. Jadyatu quisaraticuare ai tuja taca inime ama. Yusura adebamereyaque tujatu quisarati acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesústu israelita cuanaja ishu camadya ama majudaditaqui jucuare. Tuquetu majudaditaqui jucuare dutya queja cuanaja ishu, dutya ecuana peadya camadya bucha juishu. ");
INSERT INTO cavNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifásja quisarati bacatsutu tumeque huecaca eque israelita cuanaja huaraji cuanara Jesús iye ishu inime bajejetibunecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jadya tibudyatu Jesús amena ejitaju cuita israelita cuanaja epu ebari cuanaju junenicarama jucuare. Tumetu Judea juque cuinanatsu, ecuana tsehuedya dirunucacuare Efraín bacani epuju. Tumeque eputu jucuare tsecada anitaya cuanaque japadama. Tuhuadya ecuana tuatsehue anidirucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jetiama israelita cuanatu epu cuana juque cuabarecuare Jerusalénju, amena Pascua chine japadama juajeya baatsu. Tumeque chine ishu tuna tunaja bahue cabajejetitaqui jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","57","Fariseo cuanara, pae cuanaja huaraji cuanara patuna amerecuare: —Ejeque ni micuana bahue juya Jesús ejuque, necuejacue ecuana, ecuanaja inati ishu —jadya. Jadya tibudyatu Yusuja etareju ai jidamaque eaniu cuanaque cabajejetira cuahua cuanara sarecuare Jesús. Cabacaduratibarecuarepa ecana tuna cama: —¿Eje bucha ni tu juya? ¿Ejeudyatu Jesús chine ishu, aijama ni taa? —jadya tuna jubarecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Shucuta huecaca Pascua chine aniya jariju ecuana Jesús tsehue cuacuare Betaniaju, Lázaro anicuareju, tura Lázaro chacha nityatsuranucachineju. ");
INSERT INTO cavNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ecuana junatihuajutu umae Jesúsja eadeba cuanara Betaniaju anicuare cuanara bajejecuare earaqui chineju tuatsehue araara ishu. Martara tuna tsahuacuare earaqui iya. Lazarotu mesaju Jesús tsehue araara anicuare, ecuana, peya cuana jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Tumetu Mariara etseri ijimedaque becuare kilo patya jaque dyane, nardo bacani, ijimedaque eaque. Tumequetu tsuje aridaque jucuare. Tumeque nardodyatu Mariara Jesúsja ehuachi ecatseju juracuare. Juratsu tujatu tillacuare etsaru tsehue. Ijimedaquetu etare quini pashutanacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariote Jesúsra mepehuaquedyatu dyaque ecahuaiti jucuare María tsehue. Tumequedyatu Jesús ujeu baqui cuana queja inameredadiqui juyaque jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Cahuaititsutu jucuare: —¿Eje bucha juatsu jatsutu tumeque epunara ijimedaque catyati ahua ama? Umada tujatu chipiru inaquena juhua, quimisha ciento ficha dyaque. Peadya mara mere juatsu etsujequi einau tupu tuque. Jetiamatu nerecada cuanaque etsahuauque chipiru inatsu, —jadyatu Judas jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jadyatu quisaraticuare, ai nerecada cuanaque tsahuacara aatsu ama, chiri arida juatsudya jutidya. Tuquetu ecuanaja chipiru naruquique jucuare. Tuhuadya tujatu chirichirinicuare tuhua ishatanayaque tuja ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","—Nereda María aume. Tujatu tumeque ijimedaque eiya juhua ique iyetahuaju papamajudya pepa ishu, —jadya tujatu Judas acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","—Micuana ducutu jujacaya amadya nerecada cuanaque, ique bacue aijama. Ique micuana tsehue junenisiriya ama, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Umada israelita cuanatu Jesús Betania epuju junatihuaque bahue juatsu cuacuare tuaqueja. Cuacuare tuna ai Jesús jipidya baticara aatsu ama. Tumebaedya tunajatu Lázaro bacara acuare, Jesúsra emajuque nityatsuranucacuareque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Jesúsra Lázaro emajuque nityatsurachine tibutu umada israelita cuana Jesús queja catyaticuare. Jesús queja catyatitsu tunajatu pae cuanaja huaraji cuana amena bacacarama acuare, Jesús cuita camadya. Jadya tibudyatu pae cuanaja huaraji cuanara Lázaro dyadi iyecaradya acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jesús ehuachiju pepatanahuaque peya huecaca nucatu jetiama Jerusalénju Pascua chine bacara cuaya cuanaque bahue jucuare Jesús amena tuhua junatihuieque, amena tuque edijiju juajeyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Bahue juatsu tuna ejaqui cuana rarubaretsu, ejaqui cuana inabaretsu cuinanabarecuare Jesús tsurutsa ishu. Jadyatu ecuanaja bahue jucuare ecuari junayaju ejaqui cuana inatsu tsurutsa. Quiqueajecuare ecana: —¡Hosana! ¡Jida paju Yusuja ebacaniju jeyaque! ¡Jida paju ecuanaja ecuari, Israel eque ejuracana cuanaque naru ishu jeyaque! —jadya tuna jubarecuare quique eque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ecuita jetiamaque tsurutsamaquedya patu burruju anitsuratsu Jesús cuacuare. Yusuja quisarati béru cuejatacuare bae cuitadyatu jucuare: ");
INSERT INTO cavNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Bajida nejuume, Siónju aniya cuanaque. Micuanaja ecuaritu micuana queja junaya. Burro dyaque equetu junaya”, jadyatu ehuene Yusuja quisarati. (Sion bacanidyatu Jerusalén jucuare.) ");
INSERT INTO cavNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Dutya tume cuanaque baatsu, bacatsu ecuana Jesúsra mepehua cuanara tuque ecuana adebacuare ama eje buchique jadya juyaque. Ecuanaja ishutu etehuaque jucuare. Jesús emajuque netitsuranucahuaju, tuque Yusuja yacuaju judirunucahuaju ecuana chamacama huecatanacuare Yusuja quisarati jadya ehueneque. “Jesús jadya judadihuaquetu Mesías jadya judadiya jadya ehuene eque cuitadya judadihua”, jadya tuque ecuanaja chamacama inime jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jesús Jerusalénju cuama jarijudyatu tura Lázaro emajuque nityatsurayaju baqui juchine cuanara cuejacuare peya cuana eje bucha juchineque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jadique quisarati bacatsachine tibutu ecuita jetieque ama cuinanacuare Jesús tsurutsa ishu. Bacara tunajatu acuare emajuque chacha nityatsuranuca ishu casa aniyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jetiamara Jesús pureama ayaque bacatsutu fariseo cuana tuna cama quisaraticuare: —¡Nebacacue eje bucha juyaque! ¡Eje bucha jatsu ecuana ejuu! Dutyara taa tuna tuque bacaya, ecuana ebacauque, —jadya tuna jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tuhuatu umae griego cuana jucuare Jerusalénju, israelita cuana tsehue Pascua chine cuetishara cuacuare cuanaque. Yusu muira tuna cuacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tunaratu jipeticuare Felipe. Felipetu jucuare Betsaida epu juque, Galilea yahua juque. Jipetitsu tunajatu isaraticuare: —Jesús tsehue ecuana quisaraticara juya, tata, —jadya tunajatu Felipe acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jadya ahuajutu Felipe cuacuare Andrés queja. —Griego cuana patu Jesús tsehue quisaraticara juya, —jadya tujatu Andrés aticuare. Tuequedya tatse cuacuare Andrés tsehue Jesús queja. —Griego cuana patu miatsehue quisaraticara juya, —jadya tatsejatu Jesús aticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jadya bacatsu tatse Jesúsra acuare: —Masadamatu juetiya huecaca IQUE ECUITA iyetanayaque, emajuque netitsuranucayaque. Jadya ejitaju jue tuque ecue casa, jidaque juya. ");
INSERT INTO cavNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pusha amadya metse cuejaya. Ecaca ecuana uhuaya. Uhuahuajutu ecaca uhuahuaque pana cabapeti neri juya. Pana cabapeti juyaque ama juatsu, peadya ecaca camadya aniya. Cabapetiyaque juatsu, buraratsu, danetsutu umada ecaca juya. Tumebaedya ique majutaqui jetiama ecana eaqueja catyati ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Tumebaedya riyaque yahuaju eje bucha tsehue ani dyaque bijida cuanara tunajatu majutsu Yusu dyaque japada babuque. Riyaque yahuaju eje bucha tsehue ani bijidamaduraqui cuanaque tuna Yusu queja anidirubuque ni eje tupu jaca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Yuneri cuitadya ecue inime eque anicara juya cuanaquetu era cuatsashaya eque juya. Era cuatsashaya eque jujacaya ama cuanaque tuna eatsehue anisiribuque. Tuna tuna ecue Etatara muitsabuque, —jadya tatse Jesúsra acuare dutyaja ijacaju. ");
INSERT INTO cavNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesústu dutyaja ijacaju quisaratinucacuare: —Bahuedya ique ejetsunue amatu amena ique iyetana ishuque. Dyaque taa peya inime cabatiya. ¿Eje bucha dyadi tuque era ecue Etata aya: “Tata, peya eje bucha eque micue inime eque jutaquique juatsu taa mique eau, ‘Jadya nerecaturae taa aume’”, jadya ni taa eau. Jadya ama bucha maju ishudya riyaque yahuaju junahua tibu, —jadya tujatu ecana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Tumetu Jesúsra tuja Etataque acuare: —Tata, micue dyaque casa, jidaque jadya aniyaque ique eje bucha juya eque pabamere, —jadya tujatu tuja Etataque acuare dutyaja ijacaju. Jadya ahuajutu barepa juque quisarati bacataqui jucuare: —Amenatu era bamerehua ecue dyaque casa, jidaque, ique emui juishu. Bamerenucayadya tuna era, “Dyaque jida, casada jadya taa mi, Yusu”, jadya tuna juishu, —jadyatu Yusu barepa juque quisaraticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tuhua ecuana tsehue jucuare cuanaratu bacacuare etsuri barepa juque. Umaeratu bacacuare tiritiya bucha. —Tiritiya tuque. —Aijama, tiritiya ama tuque. Barepa juque Yusu tsahuaquique jutidyatu quisaratiya, —jadyatu umae cuji cuita juatsu jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tume ecuana Jesúsra isaracuare, tumebaedya peya cuana tuhua jucuare cuanaque: —Ecue Etatatu barepa juque quisaratihua ique cuejayaque ama. Micuanadya tura micuana cuejahua. ");
INSERT INTO cavNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Amenatu ejetsunue ama Yusuja tuaqueja catyatima cuanaque “Micuana micuana jucha metse” jadya aishu. Ejetsunue amatu bataqui ama ecue ama cuanaque cuatsashaquique ecue casa seca ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ique curusuju tatatanaya maju ishu. Ique tuhua curusuju etata badeya baatsu tuna jetiama eaqueja catyatiya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Riyaque quisarati tsehue tura ecuana cuejacuare eje bucha majue juyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tuhua jucuare cuanaque tuna jucuare: —Moisésra huenecuare equetu Mesías patu anisiribuque. ECUITApa curusuju tatatanaya maju ishu. Jutaquiju ni taa tu ¿ECUITA, Yusuja Emepeque ecuanara ihuayaque? —jadya tunajatu Jesús acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Tume tuna Jesúsra quemitsacuare: —Ique hueca buchique, micuana Yusuja quisarati adebamerera jehua tibu. Ejetsunue ama micuana tsehue rehua juneniya jari. Eaqueja micuana catyatitaqui, emajaca aniya jari tupu. Necatyaticue, canerecati ishuju judiru ishu ama. Apuda ducu juneniya cuanaque tuna baecua eju cuayaque; jadidyatu eaqueja catyatiya ama cuanaque baecua canerecati ishuju judiruyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Eaqueja necatyaticue ique micuana tsehue jari tupu. Eaqueja ni micuana catyatiya, tume micuana huecadaju juneniya cuana buchique juya, —jadya tuna Jesúsra acuare. Jadya quisarati aatsutu Jesús ecuita jetiama ducuque cuinanacuare. Baecua tuna jucuare eju tuque diruhuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Arepa Jesúsra tunaja yacuaju Yusuja camadya ataquique acuare ama bucha tuna dutya jujeri cuitadya tuaqueja catyaticarama jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Isaías Yusu equeque quisarati cuejaquira icueneta huene acuare eque cuitadyatu judadicuare: “Ecuana Cuatsashaquique, ecuanara tuna jetiama cuejaya micue quisarati yunerique. Jadya ama bucha tuna eje umara piji camadya ejenehua. Arepa tunara micue casa bahua ama bucha, eje umara piji camadyatu adebaya bahuaque” jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jadya equetu dutya jujeri israelita cuana Jesús queja catyatihua ama, ecuanaja baba cuana béru jucuare bucha. Dutya jujeri ecuanaja baba cuanaratu ejenecuare ama Isaiasra quisarati cuejacuareque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Isaiastu jadya junucacuare beru: “Yusura tuna adebamerehua ama tunara petahuaque. Tura tuna adebamerehua ama. Jadya tibu tuna tuaqueja catyatihua ama, arepa ecana Yusura tuja casa bamerehua ama bucha, arepa tuna tuja quisarati bacahua ama bucha. Cacuaretihua ama ecana inime Yusu queja junuca ishu, Tuja tuna inajacamere ishu”, jadyatu Isaiasra huenecuare béru. ");
INSERT INTO cavNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jadya tujatu huenecuare, Yusura tuque Jesús eje bucha judadiyaque bahue amerecuare tibu. Riyaque bahue juatsutu Isaiasra icuenetadya ahua quisarati Jesúsja ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Arepa dutyara jujeri israelita cuanara Jesús bijidamadurahua ama bucha, umae camadya tuna tuaqueja catyatihua. Umae dyaque inime metse cuanaque tuna tuaqueja catyatihua. Jadya ama buchatu tume cuanaque ejitaju ama cacuejaticuare Jesús queja catyatihuaque, fariseo cuana mubaya tibu, tuna Jesús queja catyatihuaque cacuejatiyaju fariseo cuanara caradati ishuque etareju ecasitatiquereuque ama adebaya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Tume bajida cuanaratu ecuita cuana pureamaturacara acuare, Yusu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesústu quisaraticuare: —Ejeque eaqueja catyatiyaquetu eaqueja jipidya ama catyatiya, tumebaedya Ique Cuadishaqui queja. ");
INSERT INTO cavNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ejera ni ique yuneridya adebaya, tumebaedya tujatu adebaya Ique Cuadishaquique. ");
INSERT INTO cavNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ique hueca buchique riyaque yahuaju junahua, eaqueja catyatiya cuanaja Yusuja quisarati adeba ishu. Jehua ique, tuna apuda ducu juneniya cuanaque bucha juishu ama, huecadaju juneniya cuanaque bucha juneni ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Micuanaratu ecue quisarati bacaya, era amereya eque juyaque ama, era ama micuana “jucha arida” jadya aya. Micuanaja juchajudya micuana canerecatibuque. Ique junahua riyaque yahuaju micuana “Ecajuchati micuana” jadya aishu ama, eaqueja catyatiya cuanaque inajacamere ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Arepa ecue inime ama tuna canerecatibuque ama buchatu aniya ique bijidamaduraqui cuanaque nerecaturaquique, ecue quisarati bacayaque ama juatsu. Tere huecaca juetihuaju Yusura cuitadya micuana abuque: “Micuana micuana ecajuchatique”. Jadya tujatu ecana abuque, tunara era cuejahuaque ejenehua ama tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ecue casa eque ama ique quisaratiya, mere jadya juya. Ecue Etata Ique Cuadishaquira casa tyaya tibu tuque mereya. Eratu cuejaya, bahuityaya tura ique amereya eque. ");
INSERT INTO cavNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Micuana ni ecue Etatara cuatsashaya eque aniya, tume micuana tuatsehue anisiribuque majunuca ishu ama. Riyaque tura ique bahue amerehuaque micuana era cuejahua, tura ique amerehua baedya, —jadya tuna Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tumequetu jucuare Pascua chine reeque tibene. Jesústu bahuedya jucuare masadama majuyaque, ejetsunue ama Etataque queja tsura ishuque bataqui amaque. Jesusratu dyaque iyuhueda bacuare riyaque yahua juque tuja cuanaque. Tume tura ecuana diruma jarira bamerehua dyaque tuja iyuhue aniyaque ecuana tuja cuana tsehue. ");
INSERT INTO cavNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesústu araaracuare ecuana tsehue. Judas, Simón Iscarioteja ebacuaqueratu Jesús israelita cuanaja huaraji cuana queja inamerecara acuare. Icuene patu Ijahuara jadya inime tupumerecuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesústu caadebaticuare tuque tuja Etataquera dutya casa tyacuareque. Bahuedyatu tuque jucuare tuque Yusu quejaque jehuaque, Yusu quejadya dirunucayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ecuana araaraya jari tsunumeetu tuque netitsuracuare. Netitsuratsu tujatu dyaque jutuyaque tacacuare. Catacatitsutu paño tsehue etimaju carisiticuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Carisititsu tujatu ena juracuare bañadorju. Peadya peadya tura ecuana huachi utsabarecuare. Icueneque utsatsu tujatu paño tsehue huachi tillacuare. Tuequedyatu beta ishuque utsatsu tillanucacuaredya. Jadidya tura ecuana dutya huachi utsatillacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro queja judirutsutu Jesúsra huachi utsacara acuare. Pedrotu bahuedya jucuare mayurura tuja jetiedyaque huachi utsataquique ama. Jadya tibudya tujatu Jesús acuare: —Ecuana Cuatsashaquique, ¿eje bucha huachi utsae mira eau? ");
INSERT INTO cavNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—Utsaya tuque micue era. Iyaja cuita tuquemi adebaya ama eje bucha juatsu era jadya ayaque. Tupuju tuquemi adebaya, —jadya tujatu Pedro acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—A, aijama. Ecue ehuachi tuque micue utsanime ama. —Era ni micue utsaya ama, tumemi ecuique ama, —jadyatu Jesúsra acuare Pedro. ");
INSERT INTO cavNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jadya bacatsutu Simón Pedrora jadya acuare: —Jutaquiju ehuachiju camadya ama utsacue, Ecuana Cuatsashaquique. Jutaquiju ecue utsacuedya emetucu, iyuca jadya. ");
INSERT INTO cavNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—Ejeque iyaja cuita enahuiquetu utsataqui ehuachiju camadya, ecuita jidadya asicadama tibu. Yusura micuanaja jucha cuana apupashahuaju micuana butseeju nahuihua bucha. Yusura tuque micuanaja jucha cuana amena apupashahua. Aniyatu rehua peadya tuja jucha cuana apupashamaque. Tumequedya tu asicadaque buchique, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesústu bahuedya jucuare ejera ecuana tuque ujeu baqui cuana queja inamereyaque. Jadya tibudyatu “Aniyatu peadya micuana ducu jucha cuana apupashamaque”, jadya jucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ecuana dutya huachi utsatilla jadya aatsutu Jesús dyaque jutu ishuque cajututinucacuare. Cajututinucatsutu mesaju anibutenucacuare ecuana tsehue. —¿Adebayadya micuana era eje bucha juatsu micuana ehuachiju utsahuaque? ");
INSERT INTO cavNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Micuanara ique “Ecuana Bahuityaquique, Cuatsashaquique” jadya isarae aya. Tuyudya micuanara jadya isarae aya, ique jadiquedya tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Arepa ique Micuana Cuatsashaquique, Bahuityaquique ama bucha, era micuana huachi utsahua, peya cuana tsahua juyara aya bucha. Jadya tibudya micuana jadya cutsatie ehuachi necaticue, peya cuana tsehue yurameta catsahuaticaraque cabamereti ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Era micuana bamerehua micuana eje bucha jutaquique. Jutaquiju necatsahuaticue peya cuana tsehue, era micuana tsahuahua bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pusha amadya micuana cuejaya. Mere puji tunajatu patrón muibaya bucha mui bae ama aya. Ecuadishaque bacue tuque cuadishaquique bucha muie ama aya. ");
INSERT INTO cavNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Micuanaratu bacayadya, jeeque era jadya ayaque. Micuanara ni peya cuana tsahuaya, era micuana tsahuahua bae, dyaque jida micuana judadiya. ");
INSERT INTO cavNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Dutya ama micuana Yusura dyaque jida amereya. Era micuana peadya peadya adebaya era mepehuaque. Peadyara micuanara ique ujeu baqui cuana queja inamereya. Yusuja quisarati ehuene baedyatu juya: “Eatsehue araarayara ique bijidamadurabuque”. ");
INSERT INTO cavNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Icueneta cuejadya micuana aya riyaque, ique inameretama jarijudya. Era cuejahua bae cuitadya juhuaju, tuque micuana ejeneya ique Mesiasque, era micuana cuejahua baedya. ");
INSERT INTO cavNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ejera ni era cuadishayaque jida batsaya, tumebaedya tunara ique jida batsaya. Ejera ni ique jida batsaya, tumebaedya tunajatu Ique Cuadishaquique jida batsaya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jadya ecuana cuejatsutu Jesús dyaque capeya inimeticuare. —Yuneridya peadyara micuanara ique ujeu baqui cuana queja inamereya, —jadya tujatu quisarati acuare dutya ecuanaja baca ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jadya quisaratiyaju bacatsu ecuana yurameta capetatibare jucuare. Bape bapedya jutidya tuque ecuana inime tupucuare ejeque tura jadya ayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ique Jesús aniya peque anicuare, ique Jesúsja dyaque iyuhuedaque jucuareque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Tume ique Simón Pedrora tuja emetucu tsehue piyecuejacuare. Bacaduramerecara tura Jesús acuare ejera inamereyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Tume ique Jesús queja jipetanacuare. Tuaqueja pana cajipeti juatsu tuque bacaduracuare: —Ecuana Cuatsashaquique, ¿airami inamereya? —jadya tuque acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—Pan cuesi tuque enameju mullaya. Mullatsu micuana ejequedya tyaya. Ejeque era tyayaque, tudya tume, —jadya Jesúsra acuare. Jadya juatsu tujatu mullacuare pan cuesi. Tume tujatu tyacuare Judas Iscariote, Simónja ebacuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judasratu pan cuesi inatsacuare Jesúsra tyayaque. Inatsahuajutu Ijahua tuaqueja nubicuare tuque tura amereya eque amere ishu. Jadya ahuajutu Jesúsra Judas acuare: —Mira eje bucha acara ayaque, acue iyaja cuitadya, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ecuanaratu adebacuare ama eje bucha juatsu Jesúsra jadya isarae ahuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judastu jucuare chipiru quiniquique caja caca naruquique. Umaeja tuque ecuanaja inime jucuare: —Jesusratu Judas jadya ahua, earaqui chine ishu ara ishu quemira cuaishu. Peya cuanajatu inime jucuare: —Jadya tujatu ahua, Judas queja nerecada cuanaque chipiru tyamerecara aatsu, —jadya tuque ecuana cuji cuita juatsu inime tupucuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judastu pan inatsa jadya aatsu apuda ducu diruquenacuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cuinanahuajutu Jesús quisaraticuare: —Masadama IQUE ECUITA muitaya. Ique eje bucha ataya equetu ecue Etata muitaya. ");
INSERT INTO cavNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Era Yusuja casa dyaque aniyaque bamereya buchadya tura bamerenucayadya ecue casa dyaque aniyaque. Tsunutaya amatu jadya juyaque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Amena tsunudama micuana tsehue aniya, micuana ecue ebacua bucha cuanaque. Sareya datse micuanara ique. Iyacua micuana cuejaya, ecuanaja huaraji cuana icuene cuejachineque: “Ique eju diruyaju micuana judirutaqui ama”. ");
INSERT INTO cavNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jeeque cacuatsashati iyacuaque micuana cuejaya: “Iyuhueda necabaticue micuana cama. Era micuana iyuhueda baya bucha iyuhueedya micuana necabaticue dutya peya cuana tsehue”. ");
INSERT INTO cavNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Iyuhueda ni micuana cabatiya dutya peya cuana tsehue, tume tuna dutya bahue judadiya micuana ecue emepeque. ");
INSERT INTO cavNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simón Pedroratu Jesús bacaduracuare: —¿Ejumi diruya, Ecuana Cuatsashaquique? —Eju ique diruyaju, eje bucha tuputaqui ama micue ique iyacua. Tupujumi dirubuquedya ique eju diruyaju, —jadyatu Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—¿Eje bucha juatsu miatsehue dirutaqui ama, Ecuana Cuatsashaquique? Ique bajidama mique jiteque maju ishu, —jadyatu Pedrora acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—¿Pusha amadyami ique jiteque maju ishuque? Jeeque mique cuejaya. Riyaque meta, tacure quiquehuiemi catehuati quimisha juya. “Adebaya ama tuque era”, jadya aquimisha mira aya, —jadyatu Jesúsra acuare Pedro. ");
INSERT INTO cavNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesúsra ecuana bahuityanucacuare: —Inime tsape nejuume. Peya inime nejuume. Yusu queja nimee micuana amena juhua. Eaqueja nimee nejucuedya. ");
INSERT INTO cavNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ecue Etata aniyajutu aniya dyaque umada ani ishu cuanaque. Yunerique ama juatsu taa micuana cuejaquena ama juquena juhua. Ique diruya tuhua micuanaja ani ishuque bajejediru ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Dirutsu, micuanaja ani ishuque pabajejediru; amena aatsu, yudijiya junanucabuque micuana jiteque, micuana eatsehue diru ishu. Tuhua micuana aniqueredirubuque ique jacanuca ishu ama. ");
INSERT INTO cavNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Bahuedya micuana ique eju diruyaque. Bahuedya micuana tuhua eje bucha judirue juishuque, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomástu quisaraticuare: —Ecuana Cuatsashaquique, baecua ecuana mique eju diruyaque. ¿Eje bucha bahuee jatsu ecuana tuhua eje bucha judirue juishuque ejuu? ");
INSERT INTO cavNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesúsra ecuana acuare: —Idya Yusu Etata queja judiru ishuque. Idya yunerique adebamerequique. Idya eanisirishaquique. Eaqueja catyatiya cuanaque cuita camadyatu Etata queja judirubuque, peya cuana bacue aijama. ");
INSERT INTO cavNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Micuanara ique adebayaque juatsu, tuque micuana adebayadya ecue Etata. Iyacua tuque micuana adebaya ecue Etatara ahua cuanaque, era ahua cuanaque micuanara bahua tibu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—Ecuana Cuatsashaquique, bamerecue dyadi ecuana Etata. Tumeque cuita camadya tuque ecuana bacara aya. Tume ecuana pureama juya, —jadyatu Felipera acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—Felipe, ¿eje bucha juatsumi jadya quisaratiya? Ique amena tsunuda micuana tsehue junenihua. ¿Eje bucha juatsu dyadi tuquemi adebaya ama jari? Ejera ique bahuaratu bahuadya ecue Etata. ¿Eje bucha juatsu dyadimi “Bamerecue ecuana Etata Yusu”, jadya juya? ");
INSERT INTO cavNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ique, ecue Etata Yusu, jadya yatse peadya camadya. Ique tuatsehue; tuque bacue eatsehue. ¿Ejeneya amami riyaque, Felipe? —jadyatu Jesúsra acuare. Isaranucacuare tura ecuana: —Era micuana cuejayaquetu ecue inime tacaque camadya ama. Ecue Etata tu eatsehuedya. Tudya cuitadyatu ique eque mere juya. ");
INSERT INTO cavNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Neejenecue ecue quisarati. Ique, ecue Etata jadya yatse peadya camadya. Micuanara ni ejenecarama aya ecue quisarati, neejenecue micuanara era Yusuja casa tsehue ai era ahuaque bahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Pusha amadya micuana cuejaya. Paju ama micuanaja inime eatsehue ama tibu ecue casa tsehue ama bucha. Dutya eaqueja catyatiya cuanaratu ayadya era ahuaque. Ecuetu amena aijama juya dyaque cuita emajaca ique cuita rehua riyaque yahuaju mere juishu, ique ecue Etata queja diruya tibu. Ecue cuanaja bacue dyaque emajaca aniya tuque mere aishu, era aya bucha dyaque aishu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Dutya micuanara ecue ebacaniju bacayaju eratu aya, ecue Etataja casa, jidaque jadya ejitaju amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Micuanara “Acue ecue micue ebacaniju” jadya ayaju eratu dutya micuanara bacayaque aya, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jesúsra ecuana isaranucacuare: —Micuanara ique iyuhueda bayaque juatsu, ecue yana equedya nejucue. ");
INSERT INTO cavNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ique ecue Etata queja bacabacaya, Micuana Tsahuaquique tuja cuadisha ishu. Junabuquetu micuana queja, micuana tsehue anisiri ishu; shananime ama tuja micuana. ");
INSERT INTO cavNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Tuquetu Yusuja Espiritu cuitadya, Yunerique Ejitaju Amerequique. Yusuja cuanaque amatu riyaque Espíritura cuatsashaya eque ejuu ama. Tunaratu tuque adebaya ama, ni tuna adebaya tuque ai juyaque. Micuanara bacue tuque adebaya, micuana tsehue aniya tibu. Micuana peadya peadya tsehuetu anisiribuque. Shananime ama tuja micuana. ");
INSERT INTO cavNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Jacanime ama micuana ecue ejequeja tsahuameremaque. Junanucabuque ique micuana tsehue anina ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ejetsunue juatsu ama ecue cuanara ama banucaya ama. Micuanara camadya masadamadya banucaya. Ique majutsu chacha netitsuranucaya tibu, micuana dyadi tumebaedya majutsu chacha netitsuradadinucaya. ");
INSERT INTO cavNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ique, Ecue Etata jadya yatse peadya camadya. Micuana micuana peadya camadya bucha eatsehue, ique bacue micuana tsehue. Yusuja Espíritu micuana queja junahuaju tuque micuana pana adeba abuque riyaque. Ai etehua buchique amatu jubuque. ");
INSERT INTO cavNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Era cuatsashaya eque juya cuanara yuneridya iyuhueda baya, ecue quisarati bacaqui cuanara. Ecue Etataratu ique iyuhueda baqui cuanaque iyuhueda baya. Era dyadi tuna tumebaedya iyuhueda baya. Era tuna pana adebamere aya ique aique, ique tunaja pana adeba aishu, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jadya juya bacatsutu Judasra bacaduracuare: (Judas Iscariote amatu jucuare, peya Judas.) —Ecuana Cuatsashaquique, ¿eje bucha caadebameretiemi juya ecuana queja, peya cuana queja caadebamereti ama jadya? —jadya tujatu acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—Ique iyuhueda baqui cuanaquetu ecue yana equedya juya. Ecue Etatara tuna iyuhueda bayadya. Ique, ecue Etata jadya yatse tuna tsehue aninaya; jacanime ama tuna yatseja. ");
INSERT INTO cavNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ique iyuhuedama baqui cuanara tuque ecue yana aya ama. Jadya micuana cuejaya, ecue casa eque jipidya ama, ecue Etata Ique Cuadishaquija casa. ");
INSERT INTO cavNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Riyaque micuana cuejaya, ique micuana tsehue jari tupu. ");
INSERT INTO cavNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ecue Etataratu tuja Espíritu cuitadya cuadishaya micuana queja. Ecue inime juya equetu tura cuadishaya. Yusuja Espíritu cuitadyatu Micuana Icuenequique. Tura micuana yunerique bahuityaya. Dutya micuana era cuejahua cuanaque tura micuana huecashaya. ");
INSERT INTO cavNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Era micuana inime tsapema, dyaque jida amereya, ique bucha. Yusuja cuanara ama ni micuana eje bucha inime tsapema ameree ama, era micuana aya bucha. Era micuana inime tsapema anishaya, arepa eje buchadya jutidya inime jidama cuanaque aniya ama bucha. Tupupe tupupe inime neaume, era shanaya cabatitsu. Jidama inime nebaume. Bajida nejuume. ");
INSERT INTO cavNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bacahuadya tuque micuanara, era “Ique ecue Etata queja dirutsu, junanucaya yudijidya micuana tsehue anisiri ishu”, jadya ayaju. Ecue Etata tu ique bucha dyaque emuique. Micuanara ique iyuhueda baya tibu, micuana pureama jutaqui ique ecue Etata queja diruyaju. ");
INSERT INTO cavNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ique ecue Etata queja diruma jariradya micuana dutya riya cuanaque cuejahua. Tume jadya ique judadihuaju micuanara pana ejenedya aya era yuneridya quisarati ahuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Tsunutaya amatu Yusuja ama cuanaque cuatsashaquique. Jadya tibudya tuque ecue aijama dyaque cuita emajaca micuana cueja ishu. Tura ique casa secacara aya; eje bucha casa secae ni tura ama. ");
INSERT INTO cavNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Eratu aya ecue Etatara amereyaque cuita camadya, era tuque dyaque iyuhueda baya tibu. Dutyatu jutaqui eje bucha tura ecue ishu inime pirehua eque, tuja ama cuanaque bahue juishu ique tuja inime eque juyaque. “Nenetitsuracue. Nedirura rehuaque, —jadya tura ecuana acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jesúsra ecuana isaracuare: —Ique uva cunu neri buchique. Ecue Etata tu uva cunu naruquique buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Dutya eaqueja catyatiya cuanaque tuna era daneshaya buchique. Era cuatsashaya eque ama juya cuanaque tuna cacacatiya ama bucha cuanaque. Tume cuanaque tuna Yusura ijehueya. Era cuatsashaya eque juya cuanaque tujatu ecana dyaquedya tsahuaya, tunaja jidamaque secatsu, era cuatsashaya eque amere ishu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ecue Etatara micuana amena secacuaredya jidama cuanaque, micuanara era cuejayaque bacahua tibu. Micuana micuana yaa cuana ebajejeque buchique. ");
INSERT INTO cavNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Eatsehue ecadutyati neanicue. Eatsehue ni micuana ecadutyati aniya, tume ique micuana tsehue ecadutyati aniya. Yaa ni cunuju casipitima, ejebu cacacatie ni tu juma, ecasipitique juatsu camadya. Tumebaedya micuana ecue Etataja inime eque micuana ejuu ama eatsehue ecadutyatique ama juatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ique uva cunu buchique; micuana micuana cunu yaa cuana buchique. Micuana ni eatsehue ecadutyati aniya, ique ni micuana tsehue ecadutyati aniya, tume micuana Yusuja inime eque juya. Yaa ecaca cuedaque bucha micuana juya. Eatsehue ni micuana ecadutyati ama aniya, eje bucha pureamaturae ni tuque micuana Yusu ama ni eje bucha eque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Micuana ni eatsehue ecadutyati anicarama juya, Yusura micuana tee naruquira yaa cacacati baecuaque ebau bucha bae aya. Tumeque yaa cuanatu rarutaqui. Rarutsutu eijehueta rara ishu. Rarahua baatsutu tee pujira mepe radanitya jadya aatsu pahuaya. Jadidyatu jubuque eaqueja catyatima cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Eatsehue cadutyatitsu neanicue. Era cuatsashaya eque nejucue, era bahuityahuaque nime aputama. Jadya ni micuana juya, Yusura micuana tyaya micuanara bacayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Micuana ni Yusuja inime eque aniya, tume tuque micuana micuanaja ani jida eque bamereya Yusu jida casadaque. Tume tuna bahue juya micuana yuneri cuitadya ecuique. ");
INSERT INTO cavNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ique ecue Etatara iyuhueda baya bucha, iyuhuee micuana era baya. Jutaquiju jida inime tsapema neanicue, era micuana iyuhueda bayaque adebatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ique ecue Etatara cuatsashaya eque jujacaya ama. Jadya tibudya ique inime tsapema, ique ecue Etatara iyuhueda bayaque caadebatitsu. Jutaquiju micuana ni era cuatsashaya eque jujacaya ama, dyaque jida micuana judadiya, era micuana iyuhueda bayaque caadebatitsu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Jadya micuana isarahua, micuana dyaque jida inime tsapema cuita juishu, era micuana jida inime tsehue amereya bucha. ");
INSERT INTO cavNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Jeeque cacuatsashati micuana cuejaya: “Iyuhueda necabaticue micuana cama. Era micuana iyuhueda baya bucha, iyuhueedya micuana necabaticue dutya peya cuana tsehue”. ");
INSERT INTO cavNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ecuana ni iyetacarama ama juya, peya eiyetauju, yuneridya ecuana cabameretiya iyuhueda bayaque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Micuana ni era cuatsashaya eque juya, yuneridya micuana ecue iyuhueda cuanaque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Patronratu tuja mere puji cuana tura dutya inime pireyaque cuejaya ama, tuja iyuhueda cuanaque camadya. Era micuana aya “ecue mere puji cuana” jadya ama, “ecue iyuhueda cuanaque” jadya, era micuana ecue Etatara dutya ique cuejahuaque cuejahua tibu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ique micuanara ama mepehua Micuana Cuatsashaquique juishu. Era micuana mepehua ecue iyuhueda cuanaque juishu. Era micuana mepehua Yusuja inime eque juishu, tuaqueja nimee jujaca ishu ama. Ecue Etatara micuana dutya tyaya ecue ebacaniju bacayaju. ");
INSERT INTO cavNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Riyaque micuana amerenucaya: “Iyuhueda necabaticue peya cuana tsehue”, —jadya ecuana Jesúsra acuare. ");
INSERT INTO cavNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jesúsra ecuana bahuityanucacuare: —Yusuja ama cuanara micuana ujeu bayaju, jidama inime nebaume. Neadebacue, ique tunara icuene ujeu bahuaque. ");
INSERT INTO cavNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Micuana ni riyaque yahua juquedya jutidya ejuu, Yusu ujeu baqui cuana tsehue ni micuana jida ejuu, tume tunara micuana iyuhueda ebau. Era micuana mepehua micuana riyaque yahua juque cuita camadya juishu ama. Jadya tibudya micuana Yusuja ama cuanara ujeu baya, micuana tuna bucha ama aniya baatsu. ");
INSERT INTO cavNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Neadebacue micuana era icuene cuejahuaque: “Mere puji tunajatu patrón muibaya bucha muie ama aya”. Ique tunara baya bae, baedya tunara micuana abuque. Ique jidama ijahue ijah