﻿USE sofia;
DROP TABLE IF EXISTS sofia.car_vpl;
CREATE TABLE car_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES car_vpl WRITE;
INSERT INTO car_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Mo'ko David parymbo, mo'ko Abraham parymbo Jesus Kristus tangonymbo etykon a'pemy'san karetary. ");
INSERT INTO car_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham 'wa Isak typa'kano'se man. Isak 'wa Jakob typa'kano'se man. Jakob 'wa Juda, mo'karon ipiryjan enapa typa'kano'se mandon, ");
INSERT INTO car_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda 'wa mo'ko Tamar maro Peres, mo'ko Sera enapa typa'kano'se mandon. Peres 'wa Hesron typa'kano'se man. Hesron 'wa Aram typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram 'wa Aminadab typa'kano'se man. Aminadab 'wa Nakson typa'kano'se man. Nakson 'wa Salmon typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon 'wa mo'ko Rahab maro Boas typa'kano'se man. Boas 'wa mo'ko Ruth maro Obed typa'kano'se man. Obed 'wa Isai typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai 'wa mo'ko poto 'su jopoto David typa'kano'se man. David 'wa mo'ko Uria pytymbo maro Salomo typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomo 'wa Rekabeam typa'kano'se man. Rekabeam 'wa Abia typa'kano'se man. Abia 'wa Asaf typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaf 'wa Josafat typa'kano'se man. Josafat 'wa Joram typa'kano'se man. Joram 'wa Usia typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia 'wa Jotam typa'kano'se man. Jotam 'wa Akas typa'kano'se man. Akas 'wa Hiskia typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskia 'wa Manase typa'kano'se man. Manase 'wa Amos typa'kano'se man. Amos 'wa Josia typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josia 'wa Jekonia, mo'karon ipiryjan enapa typa'kano'se mandon, moro Babylon 'wa Simosu emimarykon jako. ");
INSERT INTO car_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Moro Babylon 'wa Simosu emima'san wyino, Jekonia 'wa Sealtiel typa'kano'se man. Sealtiel 'wa Serubabel typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel 'wa Abihud typa'kano'se man. Abihud 'wa Eljakim typa'kano'se man. Eljakim 'wa Asor typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor 'wa Sadok typa'kano'se man. Sadok 'wa Akim typa'kano'se man. Akim 'wa Eliud typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud 'wa Eleaser typa'kano'se man. Eleaser 'wa Matan typa'kano'se man. Matan 'wa Jakob typa'kano'se man. ");
INSERT INTO car_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakob 'wa Josef typa'kano'se man. Josef ro Maria yino me tywaije man. Mo'ko ro Jesus, mo'ko Mesias me kynejatojaton inoro sano me tywaije man. ");
INSERT INTO car_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Abraham wyinombo ro David taronaka mo'karon kari'na pa'kano'namonymbo ainapatoro itu'ponaka okupa'en mandon. David wyinombo ro Babylon 'wa Simosu emimary taronaka mo'karon kari'na pa'kano'namonymbo ainapatoro itu'ponaka okupa'en mandon. Moro Babylon 'wa emimarykon wyinombo ro mo'ko Mesias taronaka mo'karon kari'na pa'kano'namonymbo ainapatoro itu'ponaka okupa'en mandon. ");
INSERT INTO car_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesus Kristus ero wara tywoma man: Epekaty'po wyino ty'wa, mynoto me terapa mo'ko Jesus sano Maria wairy ukuty'po mo'ko Josef 'wa, moro tymaro emamyry uwaporo. Mo'ko Tamusi a'kary pori'tory 'wa te mynoto me tyje kynakon. ");
INSERT INTO car_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mo'ko ino man Josef tamambore kynakon. Pyiwano taka mo'ko typyty man emapory 'se'pa kynakon. Iro ke ro ekapyn ta inondary 'se kynakon. ");
INSERT INTO car_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Moro wara iwonumengary jako 'ne iwoneto amy Tamusi apojon wonepo'po i'wa. Ika'po: “Josef, David parymbo, apyty me mo'ko Maria apyiry poko kytety'kai. Mo'ko iwe'mekatopo irombo Tamusi a'kary wyino man. ");
INSERT INTO car_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Amy wokyry'membo apyitan. Mo'ko ety me ro Jesus yko me. Mo'ko ro irombo ta'sakarykon epano'tan morokon yja'wan me iwe'i'san wyino.” ");
INSERT INTO car_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Pa'poro moro tywo'ka'se man ero tauran uku'ponenymbo Jesaja 'wa Tamusi nekari'po'po wo'ka'to'me: ");
INSERT INTO car_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Eneko. Mo'ko wokyry anukutypyn mynoto me kynaitan. Amy wokyry'membo apyitan. Ety me Emmanuël yta'ton. Moro tauro'po man: ‘Tamusi kymaroine man’. ");
INSERT INTO car_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Moro one'no wyino tupaka'po mero, mo'ko Josef we'i'po mo'ko Tamusi apojon wyka'po wara ro. Maria apo'i'po i'wa typyty me. ");
INSERT INTO car_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Anipokonoma'pa te iwe'i'po, mo'ko ty'me apyiry uwaporo i'wa. Irombo ety me Jesus yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Poto 'su jopoto me mo'ko Herodes a'ta, undy wyino siriko menganamon tunda'san Jerusalem 'wa, moro Judea tano Betlehem po mo'ko Jesus woma'po wyino. ");
INSERT INTO car_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ika'san: “Oje ko mo'ko oma'senan Simosu Jopotory nan? Moro isirikory wepa'kary enei irombo na'na. Ety awonga na'na nopyi.” ");
INSERT INTO car_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Moro eta'po mero, mo'ko jopoto Herodes we'naranga'po, pa'poro mo'karon Jerusalem ponokon maro. ");
INSERT INTO car_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Pa'poro mo'karon Tamusi pokonokon jopotorykon, pa'poro mo'karon Tamusi karetary uku'namon enapa a'nano'po'san i'wa. Oje mo'ko Mesias womary man ukutyry 'se iwyinoine kynakon. ");
INSERT INTO car_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ika'san i'wa: “Betlehem po, Judea ta. Tymero irombo man mo'ko Tamusi auran uku'ponenymbo 'wa: ");
INSERT INTO car_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Amoro, Juda yinonorymbo tano Betlehem, irombo ro ko'warono kapyn amoro mana morokon Juda tanokon potonon ra'na. Awyino ro irombo amy poto 'su jopoto kyno'tan. Mo'ko ro mo'karon ypyitorykon Israel pajanymbo enenen me kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Irombo Herodes 'wa ekapyn ta mo'karon siriko menganamon ko'mapo'san. Moro siriko wonepotopombo kurita poko iru'pyn me imero iwoturupo'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Irombo Betlehem 'wa emoky'san i'wa. Ika'po i'waine: “Pa'poro one wara mo'ko pitani wairy imengatandoko iru'pyn me. Epory'po mero, ekari'toko me y'wa, ety awonga wyto'se me awu enapa.” ");
INSERT INTO car_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Mo'ko jopoto auran eta'po mero, ito'san. Irombo moro siriko, moro iwepa'kary tone tywaije i'waine kynakon iro wyto'po uwapoine. Irombo mo'ko pitani waitopo epo moro siriko poropy'po. ");
INSERT INTO car_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Moro siriko ene'po me ro rapa ty'waine, poto me imero ewa'pota'san. ");
INSERT INTO car_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Moro auto taka tywo'my'san mero, mo'ko pitani ene'po i'waine mo'ko isano Maria maro. Iwokunama'san ety awongato'me. Morokon tynyrykon je'nykon etapurumaka'san i'waine. Ika'mi'po, typoporen tykoro'kamy, typoporen itupu epuku'po yry'san i'waine i'wa. ");
INSERT INTO car_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Irombo iwonetoine Tamusi 'wa uru'san, Herodes 'wa rapa erama'pa iwaito'ko'me. Iro ke ro amy terapa oma ta iwerama'san tywaito'kon 'wa. ");
INSERT INTO car_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ito'san wyino Josef woneto amy Tamusi apojon wonepo'po. Ika'po i'wa: “Ajawongo. Mo'ko pitani maro, mo'ko isano maro enapa etuwarikako Egypte 'wa. Moro po ro aiko me moro aweramary man ekarityry 'wa ro y'wa. Mo'ko Herodes irombo mo'ko pitani upitan iwoto'me.” ");
INSERT INTO car_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josef awomy'po. Moro koko noro mo'ko pitani maro, mo'ko isano maro enapa iwomima'po Egypte 'wa. ");
INSERT INTO car_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Herodes rombyry 'wa ro moro po iwe'i'po. Iwara ro ero Tamusi auran uku'ponenymbo nekarity'po wo'kapy'po: Egypte wyino ymuru siko'mai. ");
INSERT INTO car_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Mo'karon siriko menganamon 'wa tamu'ma'po ukuty'po mero, mo'ko Herodes wore'ko'po imero. Irombo warinu pokonokon emoky'san i'wa Betlehem 'wa. Moro wyino ro pa'poro mo'karon oko siriko aitonon wokyryja'makon, mo'karon oko siriko anapo'i'pa noro aitonon wokyryja'makon enapa wopo'san i'wa. Mo'karon siriko menganamon nekarity'po siriko wepa'katopombo kurita poko irombo tywo'po'se kynakon. ");
INSERT INTO car_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Moro jako ro ero Tamusi auran uku'ponenymbo Jeremia nekarity'po wo'kapy'po: ");
INSERT INTO car_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama po ura, ataikapo'no kynotanon. Rakel turare man ty'makon poko. Aturake'kapo'pa man, uwa rapa iwairykon ke. ");
INSERT INTO car_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mo'ko Herodes romby'po mero, Josef woneto amy Tamusi apojon wonepo'po Egypte po. ");
INSERT INTO car_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ika'po: “Ajawongo! Mo'ko pitani maro, mo'ko isano maro enapa eramako mo'karon Israel pajanymbo yinonory 'wa. Mo'ko pitani wory 'sangonymbo tyromo'se terapa mandon.” ");
INSERT INTO car_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Irombo Josef awomy'po. Mo'ko pitani maro, mo'ko isano maro enapa iwerama'po mo'karon Israel pajanymbo yinonory 'wa. ");
INSERT INTO car_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mo'ko tyjumy Herodes y'petakan me Judea jopotory me mo'ko Arkelaus wairy eta'po mero te ty'wa, tanarike Josef kynakon moro 'wa tytory poko. Tywoneto turu'po mero, iwomima'po Galilea 'wa. ");
INSERT INTO car_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Moro po ro amy Nasaret tatynen aitopo 'wa amanje ito'po. Iwara ro ero Tamusi auran uku'ponamonymbo nekarity'po wo'kapy'po: Nasaret pono me kynejatota'ton. ");
INSERT INTO car_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Moro jako ro mo'ko kari'na etykanen Johanes 'wa moro Judea wo'iry ta oty ekarory a'mo'po. ");
INSERT INTO car_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ika'po: “Ajemamyrykon u'matoko. Tamusi nundymary tyse waty terapa man.” ");
INSERT INTO car_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Mo'ko poko ro mo'ko Tamusi auran uku'ponenymbo Jesaja taurana man, moro ero wara tykary jako: Moro iponomyn wo'i ta amy ko'tatoto auran kynotanon: “Mo'ko Jopoto emary ika'toko. Sapatoro morokon emary ytoko.” ");
INSERT INTO car_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johanes wo'my me kameri ypotymbo kapy'po kynakon. Ekundy me tonomy pi'pombo kapy'po kynakon. Kasapa erepary me kynakon wano maro. ");
INSERT INTO car_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Mo'karon Jerusalem ponokon, pa'poro mo'karon Judea ponokon, pa'poro mo'karon Jordan po amandonon wo'to'konymbo kynakon i'wa. ");
INSERT INTO car_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Iwosetykapoto'konymbo kynakon moro Jordan tunary taka. Moro tatykarykon jako ro, pa'poro yja'wan me tywe'i'san ekari'topombo i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Pyime enapa Farise, Saduse wopy'san i'wa asetykapo. Ika'po i'waine: “Yja'wangonymbo 'ne roten, noky ko moro o'toto Tamusi erekuru wyino awetuwarikarykon man ekano'poi o'waine? ");
INSERT INTO car_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ajemamyrykon u'ma'po enepotoko. ");
INSERT INTO car_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Aturu'san ta te kykaton: ‘Abraham na'na tamurumbo me man.’ Wykaje irombo o'waine: Tamusi erokon topu kapyry taro man Abraham pajanymbo me. ");
INSERT INTO car_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Moro wywy tyje terapa man moro wewe undy po. Pa'poro epepo'non wewe akotory kynaitan. Wa'to taka ipapyry kynaitan. ");
INSERT INTO car_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Awu tuna ke katykaton moro ajemamyrykon u'ma'po enepoto'me. Mo'ko wena'po ta kyno'san inoro te yko'po pana'pe man. Isapatokanen me ywairy pairo supija. Mo'ko ro Tamusi a'kary ke ajetykata'ton, wa'to ke enapa. ");
INSERT INTO car_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Moro aresi pombokatopo irombo aina terapa man. Irombo moro aresi werikatopo a'metan. Irombo moro aresi kura'matan moro ikura'matopo auto ta. Moro iwerirymbo koro'katan te e'wutypyn wa'to ke.” ");
INSERT INTO car_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Irombo Galilea wyino Jesus tunda'po moro Jordan 'wa Johanes 'wa asetykapo. ");
INSERT INTO car_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Johanes te a'kotory 'se rypo kynakon. Ika'po i'wa: “O'wa te yjetykary manombo man. Irombo y'wa terapa mo'san?” ");
INSERT INTO car_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus 'wa te ejuku'po: “Yjetykary kysa'kotoi. Pa'poro irombo Tamusi nisanory kapyry ky'waine man.” Morombo mero Johanes we'i'po ana'koto'pa noro. ");
INSERT INTO car_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus etyka'po. Moro tuna wyino tu'tary akono mero, kapukon wendakary ene'po i'wa. Mo'ko Tamusi a'kary wony'tory ene'po i'wa amy akukuwa wara tytu'ponaka. ");
INSERT INTO car_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Irombo kapukon wyino amy auranano wota'po. Ika'po: “Mo'se ro, mo'ko nipynen ymuru mo'se man. Yturu'po ewa'pory me man.” ");
INSERT INTO car_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Irombo Tamusi a'kary 'wa Jesus aro'po iponomyn wo'i taka, mo'ko ewa'rumy tamuru 'wa u'kuto'me. ");
INSERT INTO car_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Oko-kari'na kurita, oko-kari'na koko tywonema'po wyino ikumyry'po. ");
INSERT INTO car_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Irombo mo'ko u'kunen wopy'po I'wa. Ika'po I'wa: “Tamusi ymuru me ro aja'ta iro ke, ajauranako, erokon topu wonurimato'me perere me.” ");
INSERT INTO car_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesus 'wa te ejuku'po: “Tymero man: Perere poko roten kapyn kari'na kynemandan, pa'poro Tamusi yndary wyino epa'katoto auranano poko te.” ");
INSERT INTO car_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Irombo mo'ko ewa'rumy tamuru 'wa aro'po moro kurano aitopo 'wa. Moro Tamusi auty retyry esipiry tu'ponaka yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Irombo ika'po I'wa: “Tamusi ymuru me ro aja'ta, ata'porongo po'ponaka. Tymero irombo man: Tamusi tapojongon emo'tan ajupu'po me. Awomarymbo apyita'ton, apupuru aniwo'pa awaito'me topu pona.” ");
INSERT INTO car_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesus wyka'po i'wa: “Tymero enapa man: Mo'ko Ajopotory Tamusi anu'ku'pa maitake.” ");
INSERT INTO car_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Irombo mo'ko ewa'rumy tamuru 'wa aro'po amy kawono imero wypy tu'ponaka. Pa'poro ero nono tu'ponokon potonon jopotokon nundymarykon kuranory enepo'po i'wa Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Irombo ika'po I'wa: “Pa'poro moro sytake o'wa, tokuna'po yjety awonga'poto o'wa.” ");
INSERT INTO car_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Morombo mero Jesus wyka'po i'wa: “Omimako, Satan! Tymero irombo man: Ajopotory Tamusi po'ponaka roten mokunamatake. Mo'ko ety roten mawongatake.” ");
INSERT INTO car_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Irombo mo'ko ewa'rumy tamuru 'wa inonda'po. Mo'karon Tamusi apojongon wopy'san terapa epano'se. ");
INSERT INTO car_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yja'wangon kari'na aru'katopo taka Johanes aru'ka'po eta'po mero, Jesus womima'po Galilea 'wa. ");
INSERT INTO car_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasaret 'wa amanje rapa ito'pa iwe'i'po. Kafaraum 'wa terapa ito'po amanje, moro tuna juwembory esi'wonaka, mo'ko Sebulon maro Naftali yinonory 'wa. ");
INSERT INTO car_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Iwara ro ero Tamusi auran uku'ponenymbo Jesaja nekarity'po wo'kapy'po: ");
INSERT INTO car_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulon yinonory, Naftali yinonory enapa, moro tuna juwembory 'wa ytototo oma pato man iro, moro Jordan kopose me enapa man iro, mo'karon Simosu me e'i'non yinonory Galilea, ");
INSERT INTO car_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","mo'karon ewa'rumy ta amandonon kari'na amy poto 'su aweinano enejaton. Mo'karon tawa'ruman romo'no waitopo po amandonon 'wa aweinano kynawonjan. ");
INSERT INTO car_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Morombo wyino mo'ko Jesus 'wa amy oka ekarityry a'mo'po ero wara: “Ajemamyrykon u'matoko. Moro Tamusi nundymary irombo tyse waty terapa man.” ");
INSERT INTO car_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Irombo moro Galilea tano tuna juwembory esi'wo tytory jako, oko asepiryjan ene'san i'wa: Simon, mo'ko Petrus me enapa kynejatojaton inoro, mo'ko ipiry Andreas maro. Woto pokonokon mo'karon kynatokon. Moro tuna juwembory ta sipi pa'satokon. ");
INSERT INTO car_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Irombo ika'po i'waine: “O'toko ywena'po ta. Kari'na pokonokon me terapa kyta'ton.” ");
INSERT INTO car_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Irombo o'win wytory morokon tysipirykonymbo nonda'san i'waine. Jesus wena'po ta terapa ito'san. ");
INSERT INTO car_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Irombo a'si 'ko rapa tyto'po mero, oko amykon rapa asepiryjan ene'san i'wa: mo'ko Sebedeus ymuru Jakobus mo'ko ipiry Johanes maro. Kurijara ta morokon tysipirykon ato'satokon mo'ko tyjumykon Sebedeus maro. Jesus 'wa iko'ma'san. ");
INSERT INTO car_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","O'win wytory moro kurijara ta ro mo'ko tyjumykon no'po i'waine. Jesus wena'po ta terapa ito'san. ");
INSERT INTO car_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Irombo pa'poro morokon Galilea tanokon Simosu wota'nano'to'kon autokon ta emeparykon aropoty'po i'wa. Ijako ro moro Tamusi nundymary ekapory ekarojakon. Pa'poro anyky wyino, je'tunano wyino enapa iru'pa rapa mo'karon kari'na yjakon. ");
INSERT INTO car_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Moro ekary wota'po ro pa'poro Sirie po. Irombo pa'poro mo'karon mene aitonon aro'san i'waine I'wa: pa'poro roten anyky pe aitonon, je'tunano na'karykarykon, takyramon, nuno nany'korykon, wajaku pangon enapa. Ikura'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Pyime kari'na apyimykon 'wa iwekena'po. Galilea ponokon, Dekapolis ponokon, Jerusalem ponokon, Judea ponokon, Jordan koposenokon aito'kon ponokon wopy'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mo'karon kari'na apyimykon ene'po mero, Jesus wonuku'po moro wypy tu'ponaka. Iwotandy'mo'po mero, mo'karon inemeparykon wopy'san I'wa. ");
INSERT INTO car_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Irombo emeparykon a'mo'po i'wa. Ika'po: ");
INSERT INTO car_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sara'me 'ne janon kynaita'ton mo'karon Tamusi embata oty'pambo aitonon. I'wanokon me ro irombo moro Tamusi nundymary man. ");
INSERT INTO car_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sara'me 'ne janon kynaita'ton mo'karon kata'mato aitonon. Tamusi irombo kynewa'porota'ton. ");
INSERT INTO car_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sara'me 'ne janon kynaita'ton mo'karon pyi'me'ke aitonon. Ero nono apyita'ton irombo ty'wanokon me. ");
INSERT INTO car_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sara'me 'ne janon kynaita'ton mo'karon tamambore aino 'sangon. Tamusi irombo kynytan i'waine. ");
INSERT INTO car_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sara'me 'ne janon kynaita'ton mo'karon ta'sakary kotanory enenamon. Ikotanorykon enetan enapa irombo Tamusi. ");
INSERT INTO car_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sara'me 'ne janon kynaita'ton mo'karon ituru'san tykoroka man inaron. Tamusi eneta'ton irombo. ");
INSERT INTO car_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sara'me 'ne janon kynaita'ton mo'karon sara'me aino ene'namon. Tamusi irombo ty'makon me kynejatota'ton. ");
INSERT INTO car_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sara'me 'ne janon kynaita'ton mo'karon tamambore aino poko kari'na erekuru niwekenarykon. I'wanokon me ro irombo moro Tamusi nundymary man. ");
INSERT INTO car_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Sara'me 'ne janon maita'ton, yjupu'po me ajejurukon jako kari'na 'wa, awekenarykon jako erekurukon 'wa, apokoine yja'wangon onapi ekarityry jako i'waine. ");
INSERT INTO car_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Tawa'pore aitoko me. Ajewa'porykon nominon. Moro ajepetykon irombo poto me man kapukon ta. Iwara enapa uwapo mo'karon Tamusi auran uku'ponamonymbo tywekena tywaije mandon kari'na erekuru 'wa.” ");
INSERT INTO car_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ero nono wajory me mandon amyjaron. Moro iposinymbo wyto'ma'poto te, oty ke noro ko iposinory naitan? A'kuru noro mupija. Mipa'sa terapa. Irombo kari'na kynuta'mipo'tan. ");
INSERT INTO car_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ero nono aweiry me mandon amyjaron. Amy poto 'su aitopo tywotunemyry upijan, kawo ta'ta, amy wypy tu'po. ");
INSERT INTO car_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ipo'ma'po wyino kororeta anyry'pa mandon tosipi upi'nonaka, apo'ny tu'ponaka te, pa'poro mo'karon auto tanokon kari'na 'wano me oty aweipato'me i'wa. ");
INSERT INTO car_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Iwara ro enapa moro ajaweirykon kari'na 'wano me oty aweipan. Irombo mero morokon iru'pyngon anikapyrykon amaminano eneta'ton. Mo'ko kapu tano ajumykon ety awongata'ton enapa.” ");
INSERT INTO car_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moro omenano mero'po aike'ka, mo'karon Tamusi auran uku'ponamonymbo nimero'san aike'ka pai ywopy'po kysekano'ton. Aike'kaine kapyn wopyi, iru'pa 'kopore te enepoine. ");
INSERT INTO car_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ita'ro pore, kapu, nono utapyry uwaporo, o'win amy jota, o'win amy itinga'po pai utapy'pa pairo kynaitan moro omenano mero'po wyino, moro pa'poro otykon wo'kapyry uwaporo. ");
INSERT INTO car_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mo'ko ko'waronombo ro rypo omenano mero'po urumenanen, mo'ko moro wara enapa ta'sakary emepanen ejatota'ton inorombo ro ko'warono me moro Tamusi nundymary ta. Mo'ko apyinenymbo te, mo'ko apyiry man poko ta'sakarykon emepanenymbo ejatota'ton poto me moro Tamusi nundymary ta. ");
INSERT INTO car_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Wykaje irombo o'waine: Mo'karon Tamusi karetary uku'namon ko'po, mo'karon Farise ko'po enapa tamambore e'i'pa aja'taine, o'my'pa moro Tamusi nundymary taka maita'ton. ");
INSERT INTO car_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Ero atangonymbo neta'po auranano tota o'waine man: ‘Woto kyte'i. Mo'ko kari'na wonenymbo wytory man mo'ko a'wembono auranano ynen jopoto po'ponaka.’ ");
INSERT INTO car_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Awu te wykaje o'waine: Mo'ko amy ta'sakary maro areku ta amandoto wytory man mo'ko a'wembono auranano ynen jopoto po'ponaka. Mo'ko upu'pomynymbo me 'ne roten ta'sakary ejunenymbo wytory man mo'karon jopoto wota'nanopy'san po'ponaka. Mo'ko oty anukutypyn me 'ne roten ta'sakarymbo ejunenymbo wytory man moro ata'karykatopo wa'to taka. ");
INSERT INTO car_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Moro Tamusi 'wa tymy apo'ny tu'ponaka moro anyry arory jako awetuwaro'ma'poto moro tyturu'po ta mo'ko aja'sakary 'wa ajapyiry poko, ");
INSERT INTO car_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","moro anyry inoko moro po moro tymy apo'ny po. Mo'ko aja'sakary maro 'ne ka'tu irupa aito. Irombo mero eramako moro anyry aro. ");
INSERT INTO car_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ko'i mo'ko ajemendonen poko iru'pa aiko, oma ta noro imaro awytory jako. Ijako irombo mo'ko ajemendonen ajytan mo'ko a'wembono auranano ynen jopoto ainaka. Mo'ko ro mo'ko yja'wangon kari'na aru'katopo jopotory ainaka ajytan. Mo'ko ro ajaru'katan moro yja'wangon kari'na aru'katopo taka. ");
INSERT INTO car_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ita'ro pore, o'ka'pa maitake moro wyino moro irombo ro kusiri pana'po epemary uwaporo o'wa. ");
INSERT INTO car_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ero auranano tota o'waine man: ‘Taporitonone aino kysany'mai.’ ");
INSERT INTO car_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Awu te wykaje o'waine: Pa'poro mo'karon ta'sakary pyty poko owa'no'tonon moro taporitonone iwairymbo any'maton terapa tyturu'san ta. ");
INSERT INTO car_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Yja'wan taka moro ajenuru apo'tun 'wa ajemapory jako, ikako. Emako awyinombo. Moro o'win aja'mun pisara'po utapyry irombo iru'pa 'ne ka'tu rapa man moro ata'karykatopo taka pa'poro moro aja'mun emary ko'po. ");
INSERT INTO car_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Yja'wan taka moro ajainary apo'tun 'wa ajemapory jako, i'kotoko. Emako awyinombo. Moro o'win aja'mun pisara'po utapyry irombo iru'pa 'ne ka'tu rapa man moro ata'karykatopo taka pa'poro moro aja'mun emary ko'po. ");
INSERT INTO car_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Ero enapa takari'se tywaije man: ‘Amy typyty nondanen 'wa amy inondatopo kareta yry man i'wa.’ ");
INSERT INTO car_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Awu te wykaje o'waine: Pa'poro mo'karon typyty nondanamon moro taporitonone iwairymbo any'maton, amy terapa wokyry maro e'i'pa iwe'i'poto irombo. Amy inonda'po woryi apyinen enapa moro taporitonone iwairymbo any'manon. ");
INSERT INTO car_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ero atangonymbo neta'po auranano enapa tota o'waine man: ‘Mo'ko Tamusi ety ejatory ta awykatopombo kysany'mai. Apyiko te.’ ");
INSERT INTO car_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Awu te wykaje o'waine: O'to awykato'kon kysipori'tomaton pairo moro Tamusi ety ejatory ke. Kapu enapa kysejatoton moro ajauran pori'tomato'me. Tamusi apo'ny irombo moro man. ");
INSERT INTO car_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Nono enapa kysejatoton. Tamusi pupuru apo'ny irombo moro man. Jerusalem enapa kysejatoton. Mo'ko poto 'su Jopoto waitopo irombo moro man. ");
INSERT INTO car_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ajupu'po enapa kysejatoi. O'win pairo irombo ajunsety pisara'po amu'nory, ikarairory pai mupija. ");
INSERT INTO car_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Moro ‘a'a’ awykato'kon a'a me nainen. Moro ‘uwa’ uwa me nainen. Morokon ko'pono auranano mo'ko yja'wan wyino man. ");
INSERT INTO car_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Ero auranano tota o'waine man: ‘Onunano onunano epety me nainen. Jewano jewano epety me nainen.’ ");
INSERT INTO car_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Awu te wykaje o'waine: Mo'ko yja'wan me aitoto wyino kytosaijomaton. Mo'ko ajapo'tun wyino apasapaikanen wyinonaka te moro atoneno apasary enapa u'mako. ");
INSERT INTO car_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Moro upi'nono awo'my pinary 'se mo'ko a'wembono auranano ynen jopoto po'ponaka ajarory 'san a'ta, moro itu'pono awo'my pinary enapa kysa'kotoi i'wa. ");
INSERT INTO car_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Mo'ko o'win dusun apo tymaro awytoto'me awyry'kanen maro oko dusun apo i'tango. ");
INSERT INTO car_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Mo'ko o'wa aturupototo 'wa moro iwoturupotopo yko. Ajotyry kysaijomai mo'ko a'kuru 'san 'wa. ");
INSERT INTO car_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ero auranano tota o'waine man: ‘Aja'sakary pynary o'wa man. Ajenono'nen jenonopyry o'wa man.’ ");
INSERT INTO car_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Awu te wykaje o'waine: Ajenono'namon ipynatoko. Mo'karon erekuru awekenaton inaron poko Tamusi 'wa ajauranatoko. ");
INSERT INTO car_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iwara ro mo'ko kapukon tano ajumykon y'makon me maita'ton. Mo'ko ro irombo moro tywejuru awongapojan mo'karon yja'wangon epo, mo'karon iru'pyngon epo enapa. Konopo ene'pojan tamamboramon 'wano me, emambo'non 'wano me enapa. ");
INSERT INTO car_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tamusi 'kare ajepemata'ton, mo'karon apynanamon pynary jako roten o'waine. Mo'karon pyrata amo'i'namon enapa 'kare moro wara e'i'pa nandon. ");
INSERT INTO car_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Poto 'su oty 'kare mika'saton, mo'karon aja'sakarykon 'wa roten ‘Mondo ro rypo mandon?’ awykarykon jako. Mo'karon Simosu me e'i'non enapa 'kare moro wara e'i'pa nandon. ");
INSERT INTO car_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Oty anamonopy'pa iro ke aitoko, oty anamonopy'pa mo'ko kapu tano ajumy wairy wara enapa.” ");
INSERT INTO car_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Tuwaro aitoko kari'na enuru me moro Tamusi nisanory kapyry pona o'waine. Ijako irombo mo'ko kapu tano ajumykon ajepema'paine kynaitan. ");
INSERT INTO car_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Amy otypyn epanopyry jako o'wa, wararo kysekaroi. Moro wara irombo mo'karon tonapiramon kynaijaton morokon Simosu wota'nano'to'kon auto ta, oma ta enapa, mo'karon kari'na 'wa totykon awongato'me. Ita'ro pore, moro tapetykon tapyije terapa i'waine man. ");
INSERT INTO car_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","O'wa amy otypyn epanopyry jako, oro moro ajapory apojery o'to moro ajapory apo'tun wairy anukuty'pa nainen. ");
INSERT INTO car_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Moro o'wa epanopyry one'pa nainen. Irombo mo'ko one'non otykon enenen ajumy ajepematan.” ");
INSERT INTO car_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Tamusi 'wa ajauranarykon jako, mo'karon tonapiramon wara kytaiton. Mo'karon apokupe irombo man morokon Simosu wota'nano'to'kon auto ta, potonon oma apotyrykon po Tamusi 'wa auranarykon, kari'na 'wa taneto'ko'me. Ita'ro pore, moro tapetykon tapyije terapa i'waine man. ");
INSERT INTO car_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amoro te, Tamusi 'wa ajauranary jako, moro apu'to'po taka i'tango. Irombo moro pena ra'kere'to'po mero, mo'ko onepyn ajumy 'wa ajauranako. Irombo mo'ko one'non otykon enenen ajumy ajepematan. ");
INSERT INTO car_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tamusi 'wa ajauranarykon jako ajaurangon kysipyryrykaton, mo'karon Tamusi anukuty'non wara. Pyime o'to tykarykon ke irombo moro taurangon 'wa Tamusi wepanamary man ekano'saton. ");
INSERT INTO car_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Iwaraine kytaiton. Moro anamonopyrykon otykon uku'san irombo mo'ko ajumykon, moro ipoko awoturuporykon uwaporo. ");
INSERT INTO car_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ero wara te ajauranatoko amyjaron: “Kapukon tano Papa, oro ajety tykuranondo nainen. ");
INSERT INTO car_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Oro moro anundymary no'nen. Oro moro anisanory no'ka'nen nono tu'po, kapu ta iwo'kapyry wara enapa. ");
INSERT INTO car_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Moro eromeno na'na erepary yko na'na 'wa. ");
INSERT INTO car_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Moro yja'wan me na'na we'i'po ikako, na'na 'wa moro yja'wan me typoko ta'sakarykon we'i'po kary wara enapa. ");
INSERT INTO car_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na'na kysu'kupoi. Na'na te aijomako mo'ko yja'wan wyino. ");
INSERT INTO car_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“O'waine moro yja'wan me apokoine aja'sakarykon we'i'po ka'poto irombo, mo'ko kapu tano ajumykon enapa moro yja'wan me awe'i'san katan. ");
INSERT INTO car_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Moro yja'wan me apokoine aja'sakarykon we'i'po anika'pa awe'i'sando te mo'ko ajumykon enapa moro yja'wan me awe'i'san anika'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Awonemarykon jako, kata'mato ajembatarykon kysyton mo'karon tonapiramon wara. Mo'karon irombo tombatarykon yja'wangaton, tywonemarykon enepoto'me ta'sakarykon 'wa. Ita'ro pore, moro tapetykon tapyije terapa i'waine man. ");
INSERT INTO car_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amoro te awonemary jako, ajupu'po apoko karapa ke. Ombataku'mi'ko. ");
INSERT INTO car_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kari'na 'wa kapyn moro awonemary enery man, mo'ko onepyn ajumy 'wa te. Irombo mo'ko one'non otykon enenen ajumy ajepematan.” ");
INSERT INTO car_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Tapenamon otykon kysa'nano'ton ero nono tu'po. Oruko, pisu enapa moro po kynija'pukata'ton. Manamangon moro po kyno'myta'ton imona'toine. ");
INSERT INTO car_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kapu ta te tapenamon otykon a'nano'toko. Moro po ro oruko, pisu enapa anija'puka'paine man. Moro po ro manamangon o'my'pa mandon imona'toine. ");
INSERT INTO car_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ajotyrykon waitopo po ro irombo aturu'po enapa man.” ");
INSERT INTO car_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Moro ja'munano aweiry moro onunano man. Iru'pa moro ajenuru a'ta, moro aja'mun pa'poro taweije kynaitan. ");
INSERT INTO car_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yja'wan me moro ajenuru a'ta te moro aja'mun pa'poro tawa'rume kynaitan. Moro ajaweirymbo ewa'rumamy'poto, tawa'rume pore kynaitan sena! ");
INSERT INTO car_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Amy pairo kari'na oko jopotokon pyitory me tywairy upijan. Ijako irombo mo'ko o'win amy jenono'tan, mo'ko o'win amy pynatan te. Mo'ko o'win amy ekosa tywairy 'se kynaitan, mo'ko o'win amy te ato'ke kynaitan. Tamusi pyitorykon me awairykon mupijaton, moro pyrata pyitorykon me aja'taine.” ");
INSERT INTO car_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Iro ke ro wykaje o'waine: Kytesykaton oty enapyry man poko, oty enyry man poko pai o'waine, ajemando'ko'me, one wara aja'mungon wo'myndory man poko enapa. Moro amano poto me e'i'pa nan moro arepa ko'po? Moro ja'munano poto me e'i'pa nan moro wo'mynano ko'po? ");
INSERT INTO car_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","O'po'toko tyre mo'karon tonoro 'wa. O'pomy'pa mandon. Wonatopo anipoty'pa mandon. Wonatopo ana'nanopy'pa mandon ikura'matopo taka. Mo'ko kapu tano ajumykon te kynupaton. Mo'karon tonoro ko'po tyse poto me e'i'pa amyjaron mandon? ");
INSERT INTO car_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Noky ko a'si 'ko roten tywesykary 'wa tamamyry mosindopory taro nan? ");
INSERT INTO car_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","O'tono'me ko mesykaton wo'mynano poko? Morokon itupu epyryry atytary 'wa tyre o'po'toko. Emamina'pa mandon. Mauru ane'py'i'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wykaje te o'waine: O'win amy itupu epyryry wara pairo mo'ko Salomo ewo'myndo'pa tywaije man iru'pyn me. ");
INSERT INTO car_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Moro itupu, moro erome mondo man iro, moro koro'po wa'to taka kynematon iro wo'myndo'poto moro wara Tamusi 'wa, iko'po 'ne ka'tu rapa awo'myndo'paine naitan, amyjaron Tamusi anamyikaporo'non? ");
INSERT INTO car_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kytesykaton iro ke. Kykaton: ‘Oty ko kysena'ta'ton?’, ‘Oty ko kysenyta'ton?’, ‘Oty ko kyse'mo'ta'ton?’ ");
INSERT INTO car_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Pa'poro morokon otykon upijaton ro irombo mo'karon Tamusi anukuty'non kari'na. Mo'ko kapu tano ajumykon te pa'poro morokon anamonopyrykon otykon uku'san. ");
INSERT INTO car_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Moro Tamusi nundymary 'ne ka'tu te, moro inisanory enapa upitoko. Irombo mero pa'poro morokon otykon ytan enapa o'waine. ");
INSERT INTO car_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Koro'pono oty poko kytesykaton. Oro koro'po terapa moro koro'pono oty kari'na sykapon. Moro o'win kurita nenepyry yja'wan oty iporo terapa man moro kurita 'wano me.” ");
INSERT INTO car_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Aja'sakarykon kysemendoton. Iwara ro emendo'paine maita'ton. ");
INSERT INTO car_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Moro o'waine aja'sakarykon emendotopo ke ro rapa irombo Tamusi ajemendota'ton. Moro ana'kurukon oty u'kutopo ke ro rapa otykon u'kutan Tamusi o'waine. ");
INSERT INTO car_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","O'tono'me ko mo'ko aja'sakary enuru aki'manen wewe pisara'po poko mo'po'san? Moro aseke ajenuru aki'manen wakapu anene'pa te mana. ");
INSERT INTO car_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","One wara ko iro ke mo'ko aja'sakary 'wa mykatan ‘O'ko 'ne, moro wewe pisara'po sika'se me ajenuru wyino’, aseke moro ajenuru ta moro wakapu a'ta? ");
INSERT INTO car_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tonapiren 'ne roten! Moro wakapu na'nen ikako aseke ajenuru wyino! Irombo mero iru'pa mo'po'take moro aja'sakary enuru tano wewe pisara'po kato'me o'wa. ");
INSERT INTO car_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Moro kurano oty kysyton mo'karon pero 'wa. Ijako irombo kyno'ta'ton ajekapo'seine. Morokon ajotyrykonymbo paraso topurumbo kysematon mo'karon pyiruku 'wa. Ijako irombo kynuta'mipo'ta'ton.” ");
INSERT INTO car_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Otykon poko aturupotoko. Irombo otykon mapyita'ton. Otykon upitoko. Irombo otykon mepota'ton. Pena imorykatoko. Irombo moro pena kynotapurumakatan o'waine. ");
INSERT INTO car_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mo'ko otykon poko aturupototo otykon apyitan. Mo'ko otykon upinen otykon epotan. Mo'ko pena morykanen 'wa moro pena kynotapurumakatan. ");
INSERT INTO car_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Amy ara'nanokon jumynano 'kare topu ytan tymuru 'wa, perere poko iwoturupo'poto. ");
INSERT INTO car_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Okoju ytan 'kare i'wa, woto poko iwoturupo'poto. ");
INSERT INTO car_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yja'wangon me awairykon se'me ro rypo amyjaron kurangon otykon myjaton o'makon 'wa. Ako'poine 'ne ka'tu rapa te mo'ko kapu tano ajumykon kurangon otykon ytan mo'karon aturupotonon 'wa. ");
INSERT INTO car_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Mo'karon kari'na 'wa ajenarykon 'se awairykon wara enapa mo'karon kari'na enatoko. Moro ekari'san ro irombo moro omenano mero'po, mo'karon Tamusi auran uku'ponamonymbo nimero'san enapa.” ");
INSERT INTO car_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Moro sirapi pena ta o'mytoko. Poto me irombo moro uta'no taka kari'na a'mykanen pena man. Takumbire moro uta'no taka kari'na aronen oma man. Pyime moro oma taka kari'na kyny'saton. ");
INSERT INTO car_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sirapi me te moro amano taka kari'na a'mykanen pena man. Akumbi'pa moro amano taka kari'na aronen oma man. Pyime 'ne waty kari'na moro oma epojaton. ");
INSERT INTO car_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Tuwaro aitoko mo'karon Tamusi auran uku'ponen waikamon poko. Mo'karon ro kapara eneke kyno'saton o'waine. Koro'na te tokonamon pero me mandon. ");
INSERT INTO car_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Emamingon poko muku'taton. Winu me tykapymy wonatopo epery po'saton 'kare takyramon itupu wyino. Oroi epery po'saton 'kare paremuru wyino. ");
INSERT INTO car_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Pa'poro iru'pyn wewe kurangon me kynepetanon. Yja'wan wewe yja'wangon me kynepetanon. ");
INSERT INTO car_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Iru'pyn wewe yja'wangon me tapetary upijan. Yja'wan wewe kurangon me tapetary upijan. ");
INSERT INTO car_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Pa'poro kurangon me epetapyn wewe takotomy me man. Wa'to taka tamamy me man. ");
INSERT INTO car_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iro ke ko'wu emamingon poko mo'karon tonapiramon muku'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Pa'poro 'ne waty Jopoto me yjejatonamon kyno'myta'ton moro Tamusi nundymary taka. Mo'ko kapukon tano Yjumy nisanory ka'nen te itaka kyno'mytan. ");
INSERT INTO car_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Moro kurita pyime kari'na kyngata'ton: ‘Jopoto! Jopoto! Ajety ta 'kare Tamusi auran anuku'po'pa na'na ne'i. Ajety ta 'kare akywano animoma'pa na'na ne'i. Ajety ta 'kare pyime pori'tonano anenepo'pa na'na ne'i.’ ");
INSERT INTO car_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Moro jako ro wykatake i'waine: ‘Ajukuty'paine pairo wa. Omimatoko ywyinombo, yja'wangonymbo 'ne roten.’ ” ");
INSERT INTO car_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Mo'ko yjauran 'wa epanamatoto, irombo moro tyneta'po ka'nen amy oty uku'nen, topu tu'po tauty amynenymbo wokyry wara man. ");
INSERT INTO car_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tauty amy'ma'po mero i'wa, konopo kyno'san. Tunakon kynapeinanon. Pepeito tam'po'kory kyno'san. Irombo moro auto pona kyno'wojan. Oma'pa te man. Topu tu'po irombo tapo'nyndo man. ");
INSERT INTO car_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mo'ko yjauran 'wa epanamatoto, irombo tyneta'po anikapypyn te amy oty anukutypyn, sakau tu'po tauty amynenymbo wokyry wara man. ");
INSERT INTO car_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tauty amy'ma'po mero i'wa, konopo kyno'san. Tunakon kynapeinanon. Pepeito tam'po'kory kyno'san. Moro auto pona kyno'wojan. Irombo kynomanon. Pa'poro imero kyno'tororokanon.” ");
INSERT INTO car_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Morokon ekarity'san mero Jesus 'wa, mo'karon kari'na apyimykon enumengapo'san poto me morokon inekarityry 'wa. ");
INSERT INTO car_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Amy poto 'su jopoto wara irombo imero kynemepatokon. Mo'karon Tamusi karetary uku'namon wara kapyn kynemepatokon. ");
INSERT INTO car_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Moro wypy wyino iwony'to'po mero, kari'na apyimykon 'wa Jesus wekena'po. ");
INSERT INTO car_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Irombo amy areky pan wopy'po I'wa. Iwokunama'po ipo'ponaka. Ika'po: “Jopoto, i'se aja'ta, ykura'mary taro mana.” ");
INSERT INTO car_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Irombo Jesus 'wa tainary tynga'po, apyito'me. Ika'po: “Ekura'mako rapa iro ke!” Irombo o'win wytory moro erekyrymbo utapy'po. ");
INSERT INTO car_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Irombo Jesus wyka'po i'wa: “Tuwaro koro aiko. Amy 'wa pairo koro kysekarityi. Asenepotango te mo'ko Tamusi pokono 'wa. Moro Moses wykatopombo yko me Tamusi 'wa, Tamusi emamina'po amyika'to'me mo'karon Tamusi pokonokon 'wa.” ");
INSERT INTO car_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Moro Kafaraum taka Jesus wo'myry jako, amy warinu pokonokon jopotory wopy'po I'wa e'pima. ");
INSERT INTO car_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ika'po: “Jopoto, mo'ko ypyitory auto po tapapo man. Ija'mun tyromo'se man. Mene kynota'karykanon.” ");
INSERT INTO car_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesus wyka'po i'wa: “Wo'take iro ke ikura'ma.” ");
INSERT INTO car_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mo'ko warinu pokonokon jopotory 'wa te ejuku'po. Ika'po: “Jopoto, uwam'po watapoja yjauty taka awo'myto'me. Ajauranako roten te. Irombo mo'ko ypyitory iru'pa rapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Awu ro rypo jopoto nundymary me wa. Ynundymarykon me rapa warinu pokonokon mandon. Amy 'wa ywyka'poto: ‘Itango!’ kyny'san. Amy 'wa rapa ywyka'poto: ‘O'ko 'ne!’ kyno'san. Ypyitory 'wa ywyka'poto: ‘Ero wara aiko!’ moro wara ro kynaijan.” ");
INSERT INTO car_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Moro eta'po mero, Jesus enuta'po imero. Mo'karon tywekenanamon 'wa ika'po: “Ita'ro pore, mo'karon Israel pajanymbo ra'na mo'sepan Tamusi amyikanen anepory'pa pairo we'i. ");
INSERT INTO car_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","“Wykaje o'waine: pyime kari'na kyno'ta'ton undy wyino, aretyry wyino enapa. Irombo kynendameta'ton Abraham, Isak, Jakob maro moro Tamusi nundymary ta. ");
INSERT INTO car_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pyime moro Tamusi nundymary tanokon me rypo yry'san emata'ton moro irombo ro tawa'rumanymbo taka. Moro po ro atamono, aijekyno enapa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Irombo Jesus wyka'po mo'ko warinu pokonokon jopotory 'wa: “I'tango. Moro anamyikary wara ro oty no'ka'nen.” Moro jako 'ne ro mo'ko ipyitory we'i'po iru'pa rapa. ");
INSERT INTO car_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Moro Petrus auty taka tywo'my'po mero, Jesus 'wa mo'ko i'menoty epory'po tapapo, komyinano pe. ");
INSERT INTO car_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ainary apo'i'po mero Jesus 'wa, moro ikomyinymbo utapy'po. Irombo mo'ko woryi awomy'po upaine. ");
INSERT INTO car_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iko'mamy'po mero, pyime takyramon enepy'san i'waine I'wa. Tauran ke roten mo'karon akywano moma'san i'wa. Pa'poro mo'karon any'pangon kura'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Iwara ro ero Tamusi auran uku'ponenymbo Jesaja nekarity'po wo'kapy'po: Moro ru'me kywairykonymbo tyka i'wa man. Kanykyrykonymbo typina i'wa man. ");
INSERT INTO car_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Kari'na apyimy 'wa tu'memyry ene'po mero ty'wa, Jesus wyka'po moro tuna juwembory patoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Irombo amy Tamusi karetary uku'nen wopy'po I'wa. Ika'po I'wa: “Amepanen, oja awytotopo 'wa ro wy'take awena'po ta.” ");
INSERT INTO car_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Irombo Jesus wyka'po i'wa: “Mo'karon joroko tautake mandon. Mo'karon tonoro tapo'nyne mandon. Mo'ko kari'na ymuru upu'po te erematopo'ma man.” ");
INSERT INTO car_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Amy terapa inemepary wyka'po I'wa: “Jopoto, oro yjumy na'nen sunendamyi.” ");
INSERT INTO car_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesus wyka'po te i'wa: “O'ko ywena'po ta. Oro mo'karon iromby'san mo'karon takepyrykon unensen.” ");
INSERT INTO car_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kurijara taka iwotaru'ka'po mero, mo'karon inemeparykon wyto'san imaro. ");
INSERT INTO car_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Irombo orometa woma'po moro tuna juwembory taka. Parana kynotaru'kakon terapa moro kurijara taka. Jesus te kyno'ny'sakon. ");
INSERT INTO car_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Irombo ito'san i'wa. Embaka'po i'waine. Ika'san i'wa: “Jopoto, na'na epano'ko! Kuta'saton terapa!” ");
INSERT INTO car_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Irombo ika'po i'waine: “O'tono'me ko tanarike 'ne terapa mandon, Tamusi anamyikaporo'non?” Irombo awomy'po. Morokon pepeito, moro parana e'ma'san i'wa. Ity'me imero pa'poro oty we'i'po moro parana ta. ");
INSERT INTO car_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Poto me imero mo'karon kari'na enuta'san. Ika'san: “Noky 'ne ko mo'se nan, se? Morokon pepeito, moro parana ro rypo kore nepanamaton i'wa, ran!” ");
INSERT INTO car_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Koposenaka itunda'po mero, mo'karon Gadara wyinonokon 'wa, oko takyramon wopy'san epoje moro atunendopo wyino. Anari me imero kynatokon. Amy pairo moro oma ta tytory upijakon. ");
INSERT INTO car_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Mo'karon ko'ta'san ro: “Oty 'se ko na'na maro man, se, Tamusi ymuru? Mopyi terapa na'na a'karykapo?” ");
INSERT INTO car_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tyse terapa iwyinoine moky pyiruku tywendamerykon aropo'satokon. ");
INSERT INTO car_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mo'karon wokyryjan akyrykon we'pima'san Jesus 'wa. Ika'san: “Na'na momary jako o'wa, na'na aropoko mo'karon pyiruku taka.” ");
INSERT INTO car_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Irombo ika'po i'waine: “I'tandoko iro ke!” Mo'karon wokyryjan akyrykonymbo wepa'ka'san iwyinoine. Mo'karon pyiruku taka terapa ito'san. Irombo mo'karon pyiruku eka'numy'san moro eme'tary wyino moro tuna juwembory taka. Pa'poro i'maty'san moro tuna ta. ");
INSERT INTO car_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mo'karon pyiruku enenamonymbo eka'numy'san moro poto 'su aitopo 'wa. Pa'poro oty, o'to mo'karon takyramonymbo we'i'san enapa ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Morombo mero pa'poro moro aitopo ponokon wyto'san Jesus epoje. Ene'po mero ty'waine, iwe'pima'san i'wa moro tyinonorykon wyino itoto'me. ");
INSERT INTO car_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesus wotaru'ka'po kurijara taka. Koposenaka rapa iwepato'po, moro tamandopo 'wa. Irombo amy iwajakuta'po enepy'po i'waine I'wa, moro ipaty tu'po ro. ");
INSERT INTO car_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Moro i'waine poto me Tamusi amyikary enery ke ty'wa, Jesus wyka'po mo'ko iwajakuta'po 'wa: “Aturu'po apyiko, ito'my! Oja'wanykonymbo kyno'kanon.” ");
INSERT INTO car_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Morombo mero amykon Tamusi karetary uku'namon wyka'san tyturu'san ta: “Tamusi ety jamikanon mo'se!” ");
INSERT INTO car_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Moro iwonumengarykon ukutyry ke ty'wa, Jesus wyka'po: “O'tono'me ko yja'wan me moro aturu'san ta monumengaton? ");
INSERT INTO car_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Otypan ko ija roten nan? Awykary mo'se iwajakuta'po 'wa: ‘Oja'wanykonymbo kyno'kanon.’? Awykary te ka'tu ‘Ajawongo! Itopo'ko!’? ");
INSERT INTO car_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","O'po'toko, muku'to'se me mo'ko kari'na ymuru aina yja'wan me e'i'po kary wairy ero nono tu'po.” Irombo ika'po mo'ko iwajakuta'po 'wa: “Ajawongo. Apaty anungo. I'tango ajauty 'wa.” ");
INSERT INTO car_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Irombo awomy'po. Ito'po tauty 'wa. ");
INSERT INTO car_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Moro ene'po mero ty'waine, mo'karon kari'na apyimykon 'wa Tamusi nendo'po. Tamusi ety awonga'po i'waine, kari'na 'wa moropan pori'tonano yry'po ke i'wa. ");
INSERT INTO car_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Moro wyino a'si 'ko tyto'po mero, amy wokyry wotandy'mo'po ene'po Jesus 'wa moro pyrata amo'i'topo auto po. Ety me Mateus kynakon. Mo'ko 'wa ro ika'po: “O'ko ywena'po ta.” Irombo Mateus awomy'po. Ito'po Jesus wena'po ta. ");
INSERT INTO car_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Irombo wyino Mateus auty ta Jesus tarije'po kynendamejakon. Pyime Rome pono jopoto ekataka pyrata amo'i'namon, pyime enapa amykon terapa tyja'wangamon tarije'po kynendamejatokon Jesus maro, mo'karon inemeparykon maro enapa. ");
INSERT INTO car_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Moro ene'po mero ty'waine, mo'karon Farise wyka'san mo'karon inemeparykon 'wa: “Na! O'tono'me ko mo'karon pyrata amo'i'namon maro, mo'karon tyja'wangamon maro enapa mo'ko ajemepanamon nendamejan?” ");
INSERT INTO car_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aurangon eta'po mero, Jesus wyka'po: “Anyky'non amy tapino'namon anupi'pa mandon. Je'tun pangon te amy tapino'namon upijaton. ");
INSERT INTO car_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Onumengatandoko o'to tauro'po me ero auranano wairy poko: ‘Kari'na 'wa kotano enery 'se wa. Tywomy tonomy 'se'pa wa.’ Tamamboramon ko'ma opy'pa tywaije wa. Mo'karon tyja'wangamon ko'ma te tywo'se wa.” ");
INSERT INTO car_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Moro jako ro mo'karon Johanes nemeparykon wopy'san Jesus 'wa. Ika'san: “O'kapyn roten na'na, mo'karon Farise enapa kynonematon. O'tono'me ko mo'karon anemeparykon onema'pa nandon?” ");
INSERT INTO car_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus wyka'po i'waine: “Mo'karon oko aimytonon ewa'manamon 'kare tywonemarykon taro nandon, mo'ko pytatoto a'ta tokosaine! Amy jako te mo'ko pytatoto pinata'ton iwyinoine. Irombo mero kynonemata'ton. ");
INSERT INTO car_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Amy pairo kari'na amy asery kamisa anatoky'pa man amy penato'po wo'mynanombo poko. Ijako irombo moro asery kamisa moro wo'mynanombo tyngatan. Irombo poto me 'ne ka'tu rapa moro iwo'seka'po kynaitan. ");
INSERT INTO car_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Asery winu anije'nyndo'pa enapa mandon penato'san tonomy pi'sanymbo kapy'san ke. Ijako irombo morokon winu je'nykonymbo kyno'sekatan. Irombo moro winu kynotakamatan. Morokon ije'nykonymbo a'kuru upita'ton noro. Asery winu yry te man asery ije'ny taka. Irombo moro winu moro ije'ny maro ro mikura'matake.” ");
INSERT INTO car_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Eruparykon jako noro, amy jopoto wopy'po I'wa. Iwokunama'po ipo'ponaka. Ika'po: “Yjemyirymbo eromembo roten nirombyi. O'ko, ajainary myry'se me itu'ponaka, erenato'me rapa.” ");
INSERT INTO car_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Irombo Jesus awomy'po. Imaro ito'po. Mo'karon inemeparykon wyto'san enapa. ");
INSERT INTO car_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Irombo amy je'tun pan woryi moro po kynakon. Ainapatoro itu'ponaka oko siriko terapa no'mo roten kynakon. Mo'ko wyto'po ro I'wa. Inga'na'po ta moro iwo'my sese'wuru y'tu'ka'po iwa. ");
INSERT INTO car_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tyturu'po ta irombo kyngakon: “Iwo'my y'tu'ka'poto roten y'wa, iru'pa rapa waitake.” ");
INSERT INTO car_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus wotu'ma'po te. Mo'ko woryi ene'po mero, ika'po: “Aturu'po apyiko, iso'ne. Moro o'wa Tamusi amyikary akura'mai.” Morombo wyino iru'pa rapa mo'ko woryi kynakon. ");
INSERT INTO car_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Irombo mo'karon Simosu wota'nano'to'kon auto jopotory auty 'wa tytunda'po mero, Jesus 'wa mo'karon kari'na wotaikapotyry ene'po. Sina pokonokon enapa moro po kynatokon. ");
INSERT INTO car_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Irombo ika'po: “Omimatoko! Mo'ko amyija'ko iromby'pa man. Kyno'ny'san te.” Irombo auno'poty'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kurandonaka mo'karon kari'na emoky'san mero ty'wa, iwo'my'po mo'ko amyija'ko waitopo 'wa. Ainary poko apo'i'po i'wa. Irombo mo'ko amyija'ko awomy'po. ");
INSERT INTO car_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Moro ekary wotaripapy'po ro moro po wararo. ");
INSERT INTO car_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Moro wyino Jesus wytory jako, oko enu'non wyto'san iwena'po ta. Iko'ta'san: “Na'na kotanory eneko, David parymbo!” ");
INSERT INTO car_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Auto 'wa itunda'po mero, mo'karon enu'non wopy'san I'wa. Jesus wyka'po i'waine: “Ajepanopyrykon taro ywairy mamyikaton?” Ika'san I'wa: “A'a, Jopoto. Na'na kynamyikanon.” ");
INSERT INTO car_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Irombo enurukon y'tu'ka'san i'wa. Ika'po: “Moro anamyikarykon ro no'ka'nen.” ");
INSERT INTO car_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Irombo enurukon we'i'san iru'pa rapa. Jesus 'wa te apo'tun pe e'ma'san. Ika'po: “Tuwaro koro aitoko. Amy 'wa pairo ero oty ukutyry kapyn man.” ");
INSERT INTO car_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tywepa'ka'san mero te, moro po aito'kon wararo Jesus ekaro'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mo'karon wyto'san wyino, amy takyren erupopyn wokyry enepy'po i'waine Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mo'ko akyrymbo moma'po wyino, mo'ko erupopynymbo aurana'po. Mo'karon kari'na apyimykon enuta'san imero. Ika'san: “Eropan oty asenepo'pa noro man mo'karon Israel pajanymbo ra'na.” ");
INSERT INTO car_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mo'karon Farise wyka'san te: “Mo'ko ewa'rumy tamuru pori'tory ta mo'karon ewa'rumy momanon.” ");
INSERT INTO car_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pa'poro potonon, siky'inon aito'kon 'wa Jesus wyto'po. Morokon Simosu wota'nano'to'kon auto wararo kari'na emepary aropoty'po i'wa. Ijako ro moro Tamusi nundymary ekapory ekarojakon. Pa'poro anyky wyino, je'tunano wyino enapa iru'pa rapa mo'karon kari'na yjakon. ");
INSERT INTO car_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Mo'karon kari'na apyimykon 'wa tywo'potyry jako, moro ikotanorykon ene'po i'wa. Takinda irombo, tyrupota enapa kynatokon, ene'nemyngon kapara wara. ");
INSERT INTO car_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Irombo ika'po mo'karon tynemeparykon 'wa: “Moro typotymy pyime ro rypo man. Mo'karon ipo'namon te pyime waty mandon. ");
INSERT INTO car_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Iro ke ro mo'ko wonatopo potyry Jopotory 'wa aturupotoko amykon noro ipo'namon man emo'to'me i'wa.” ");
INSERT INTO car_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Irombo mo'karon ainapatoro itu'ponaka okonokon tynemeparykon ko'mapo'san i'wa ty'wa. Irombo ipori'toma'san i'wa. Pa'poro yja'wangon akywano momary, pa'poro any'pangon, je'tun pangon kura'mary enapa yry'po i'wa ainakaine. ");
INSERT INTO car_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Erokon mo'karon ainapatoro itu'ponaka okonokon apojoma'san etykon: Koromo 'ne Simon, mo'ko Petrus me kynejatojatokon inoro mo'ko ipiry Andreas maro, mo'ko Sebedeus ymuru Jakobus mo'ko ipiry Johanes maro, ");
INSERT INTO car_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipus Bartolomeus maro, Tomas mo'ko pyrata amo'i'nen Mateus maro, mo'ko Alfeo ymuru Jakobus mo'ko Tadeus maro, ");
INSERT INTO car_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","mo'ko Judea poko o'wo'matoto Simon mo'ko Judas Iskariot maro (mo'ko 'wa ro enapa Jesus takarama man). ");
INSERT INTO car_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Mojan ainapatoro itu'ponaka okonokon apojoma'san Jesus 'wa ero wara: “Simosu me e'i'non 'wa kytoton. Samaria ponokon waitopo taka kyto'myton. ");
INSERT INTO car_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","I'tandoko 'ne ka'tu te mo'karon utapy'san kapara waranokon Israel pajanymbo 'wa. ");
INSERT INTO car_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Moro senge terapa moro Tamusi nundymary wairy ekary arotoko i'waine. ");
INSERT INTO car_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Je'tun pangon irupa rapa ytoko. Iromby'san awongatoko rapa. Areky pangon ikura'matoko. Yja'wangon akywano imomatoko. Epemary pyndo oty mapyiton. Epemary pyndo enapa oty ytoko. ");
INSERT INTO car_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Ika'mi'po, amu'nymbo, ikarai'po kysaroton amaroine. ");
INSERT INTO car_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Otyje'ny'ma i'tandoko. Awo'mykon y'petakangon kysaroton. Isapato'pa, apose'ma i'tandoko. Mo'ko amaminatoto 'wa tarepary apyiry man. ");
INSERT INTO car_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Poto 'su aitopo taka, ko'warono aitopo taka pai awo'my'sando, amy o'wa tatawary 'san upitoko. Mo'ko ekosa ro aitoko, moro aitopo wyino awytorykon 'wa ro. ");
INSERT INTO car_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Moro auto taka awo'myrykon jako ro, mo'karon itanokon 'wa kaitoko: ‘Sara'me aitoko, yja'sakarykon.’ ");
INSERT INTO car_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","O'waine tatawary 'se mo'karon auto tanokon a'ta, moro awykato'kon sara'me aino ekosaine nainen. Moro wara e'i'pa a'taine, moro awykato'kon sara'me aino neraman rapa o'waine. ");
INSERT INTO car_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amy oje o'waine tatawary 'se'pa kari'na a'ta, ajaurangon 'wa tywepanamary 'se'pa kari'na a'ta, i'tandoko moro auto wyino, moro aitopo wyino pai. Awytorykon mero moro apupurukon i'kokatoko. ");
INSERT INTO car_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ita'ro pore, moro a'wembono auranano ytopo kurita moro aitopo kynota'karykatan Sodom, Gomora ko'po 'ne ka'tu rapa. ");
INSERT INTO car_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Komo'saton te 'ne kapara emokyry wara tokonamon pero ra'naka. Tuwaro koro aitoko okoju wara. Ija'wany'pa koro aitoko akukuwa wara. ");
INSERT INTO car_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","“Tuwaro aitoko mo'karon kari'na poko. Ajarota'ton irombo a'wembono auranano yto'kon auto taka. Opoky'mata'ton morokon tywota'nano'to'kon auto ta. ");
INSERT INTO car_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Potonon jopotokon po'ponaka, poto 'su jopoto y'petakangon po'ponaka enapa ajarota'ton yjupu'po me. Moro jako ro otypan oty wo'kapy'po ekarityry taro maita'ton i'waine, mo'karon Simosu me e'i'non 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jopoto po'ponaka ajarorykon jako i'waine ajemendoto'ko'me, kytesykaton o'to awykarykon man poko. Moro jako 'ne moro o'to awykarykon man mapyita'ton. ");
INSERT INTO car_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Amyjaron kapyn irombo ajauranata'ton. Mo'ko ajumykon a'kary te otaine kynauranatan. ");
INSERT INTO car_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kari'na typiry, tyryi ekaramatan iwoto'me. Jumynano ro rypo ty'me ekaramatan. Pitanikon tysanokon, tyjumykon auran po'takaro imero kynaita'ton. Tysanokon, tyjumykon wopota'ton. ");
INSERT INTO car_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Pa'poro kari'na ajenono'ta'ton yjety upu'po me. Mo'ko tyrombyry 'wa ro ata'karykano ta eja'nakatoto epano'tan te Tamusi. ");
INSERT INTO car_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“O'win amy aitopo ta kari'na erekuru 'wa awekenarykon jako, amy terapa aitopo 'wa etuwarikatoko. Ita'ro pore, mo'karon Israel pajanymbo waito'kon etawa'mary mupita'ton, mo'ko kari'na ymuru wopyry uwaporo. ");
INSERT INTO car_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Amy omepatoto tamepanen ko'po e'i'pa man. Amy pyitonano tyjopotory ko'po e'i'pa man. ");
INSERT INTO car_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mo'ko omepatoto 'wa iporo terapa man mo'ko tamepanen wara iwairy. Mo'ko pyitonano 'wa iporo terapa man mo'ko tyjopotory wara iwairy. Be'elsebul me amy auto jopotory ejuru jako kari'na 'wa, yja'wan me 'ne ka'tu rapa mo'karon auty tanokon ejuta'ton. ");
INSERT INTO car_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Tanarike kytaiton ipokoine. Pa'poro onepyn oty irombo kynonepotan. Unemy'po oty kynotuku'tan. ");
INSERT INTO car_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Pa'poro o'waine ewa'rumy ta ynekarityry ekari'toko aweiry ta. Apanarykon taka ekarity'po ekarotoko autokon re'ta. ");
INSERT INTO car_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","“Tanarike kytaiton mo'karon aja'mungon wonamon poko. Aja'karykon wory upijaton. Tanarike te aitoko mo'ko ata'karykatopo wa'to ta aja'mungon maro aja'karykon uta'kary taro aitoto poko. ");
INSERT INTO car_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Oko wansiri epety me o'win kusiri pana'po man. O'win amy mo'kopan wansiri pairo te nono tu'ponaka oma'pa man Tamusi nisanory pyndo. ");
INSERT INTO car_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Amyjaron te, ajunsetykon pairo pa'poro tu'ku man. ");
INSERT INTO car_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tanarike iro ke kytaiton. Pyimano wansiri ko'po tapene mandon amyjaron. ");
INSERT INTO car_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Pa'poro mo'karon kari'na embata ywyinonokon me okari'tonon wyino enapa wokari'take mo'ko kapukon tano yjumy embata. ");
INSERT INTO car_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mo'ko kari'na embata yjukuty'pa tywairy ekari'nen anukuty'pa te wokari'take mo'ko kapukon tano yjumy embata. ");
INSERT INTO car_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nono tu'ponaka sara'me aino ene'se tywo'se kakano'ton. Sara'me aino ene'se kapyn wopyi. Supara ene'se te wopyi. ");
INSERT INTO car_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ata'sakano ene'se wopyi. Wokyry tyjumy jenono'tan. Amyinano tysano jenono'tan. Parysanonano ty'menoty jenono'tan. ");
INSERT INTO car_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","O'win auto ta asekaro kari'na kynaijenono'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Amy 'wa ypynary ko'po tyjumy, tysano pynary jako, y'wano me tywairy upitan. Amy 'wa ypynary ko'po tamyiry, tymuru pynary jako, y'wano me tywairy upitan. ");
INSERT INTO car_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mo'ko ywena'po ta tytoto'me tywakapuru ananumy'pa man inoro y'wano me tywairy upitan. ");
INSERT INTO car_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mo'ko tamamyry eponenymbo moro tamamyry uta'katan. Mo'ko yjupu'po me tamamyry uta'kanenymbo te moro tamamyry epotan. ");
INSERT INTO car_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mo'ko ajewa'manamon yjewa'manon. Mo'ko yjewa'manen mo'ko yjemo'nenymbo ewa'manon. ");
INSERT INTO car_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Amy 'wa amy Tamusi auran uku'ponen ewa'ma'poto Tamusi auran uku'ponen me iwairy ke, amy Tamusi auran uku'ponen epety apyitan. Amy 'wa amy tamamboren ewa'ma'poto tamamboren me iwairy ke, amy tamamboren epety apyitan. ");
INSERT INTO car_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Amy 'wa sapera'membo ta roten tuna ke o'win amy mo'kopan ko'warono upa'poto ywyinono me iwairy ke, ita'ro pore, tapety anapo'i'pa e'i'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Mo'karon ainapatoro itu'ponaka okonokon tynemeparykon uru'ma'san mero ty'wa, Jesus wyto'po moro wyino mo'karon kari'na emepa, moro iru'pyn oka ekaro enapa iwaito'kon 'wa. ");
INSERT INTO car_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Moro yja'wangon kari'na aru'katopo ta one wara mo'ko Mesias emaminary ekary eta'po mero ty'wa, Johanes 'wa amykon tynemeparykon emoky'san ");
INSERT INTO car_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jesus 'wa aturupo. Ika'san: “Mo'ko o'toto manombo amoro man? Amy terapa momo'tan te ka'tu na'na?” ");
INSERT INTO car_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesus 'wa ejuku'san: “Morokon aneta'san, anene'san enapa ekari'tandoko Johanes 'wa. ");
INSERT INTO car_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Enu'nonymbo kyno'po'saton rapa. Wajaku pangonymbo kyny'saton rapa. Yja'wan areky pangonymbo kynekura'maton rapa. Ipana'nonymbo kynipanataton rapa. Iromby'san kynawonjaton rapa. Mo'karon omi tanokon amy iru'pyn oka etaton. ");
INSERT INTO car_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Sara'me 'ne janon kynaitan mo'ko ypoko aki'ny'ma aitoto.” ");
INSERT INTO car_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mo'karon Johanes apojongon wyto'san mero, Johanes poko mo'karon kari'na apyimykon erupary a'mo'po Jesus 'wa: “Oty ene ko mytoton moro iponomyn wo'i taka? Amy pepeito ne'wujukuru itupu ene ka'tu? ");
INSERT INTO car_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Oty ene ko iro ke mytoton? Amy iru'pyn tymi'mi'ken wo'mynano tano wokyry ene ka'tu? Mo'karon iru'pyngon tymi'mi'kamon wo'mynano tanokon kari'na te 'kuru morokon potonon jopotokon autykon ta mandon. ");
INSERT INTO car_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Oty ene 'ne ka'tu ko iro ke mytoton? Amy Tamusi auran uku'ponen ene ka'tu? A'a, wykaje o'waine, amy Tamusi auran uku'ponen ko'pono 'ne ka'tu rapa ene! ");
INSERT INTO car_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mo'ko poko ro tymero man: Eneko, yjapojon semo'sa ajuwapo. Mo'ko ro moro ajemary ka'tan o'wa. ");
INSERT INTO car_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Ita'ro pore, mo'karon woryijan uwembo wyino oma'san ra'na amy pairo e'i'pa tywaije man mo'ko kari'na etykanen Johanes ko'po. Ise'me te mo'ko ko'waronombo moro Tamusi nundymary tano iko'po man poto me. ");
INSERT INTO car_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mo'ko kari'na etykanen Johanes we'i'po poro, erome noro, moro Tamusi nundymary apyiry poko kari'na kyno'wo'maton. Tokonamon kari'na kyno'saton apyije. ");
INSERT INTO car_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Pa'poro mo'karon Tamusi auran uku'ponamonymbo, moro omenano mero'po enapa moro Tamusi nundymary poko taurana mandon Johanes taronaka ro. ");
INSERT INTO car_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Amyikary 'se aja'taine, mo'ko o'toto manombo Elia mo'ko man. ");
INSERT INTO car_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mo'ko typanaken nepanaman. ");
INSERT INTO car_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Otypan oty wara ko mo'karon eromenokon kari'na syta'ton? ");
INSERT INTO car_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Otykon ekaramatopo po tandy'ponokon, ero wara ta'sakarykon ko'manamon pitanikon wara mandon: ‘Na'na o'waine sina etoi. Irombo uwa'pa maiton. Na'na atamotopo ware kapyi o'waine. Irombo atamo'pa maiton.’ ");
INSERT INTO car_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Mo'ko Johanes irombo nopyi. Arepa anenapy'pa man. Winu anenyry'pa man. Irombo mykaton: ‘Amy yja'wan noky itu'po man.’ ");
INSERT INTO car_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Mo'ko kari'na ymuru nopyi. Arepa ena'san. Winu enyjan enapa. Irombo mykaton: ‘Enetoko! Amy kumi'man pore kari'na, ran! Amy tanymy 'san pore kari'na, ran! Mo'ko Rome pono jopoto ekataka pyrata amo'i'namon pawanary, amy tyja'wangamon pawanary enapa mo'ko man!’ Tywonumengapore Tamusi wairy enepojan morokon inikapy'san amaminano.” ");
INSERT INTO car_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","“Irombo Jesus 'wa morokon ty'wa pori'tonano apyimy enepoto'konymbo aito'kon poko tauranary a'mo'po. Tamamyrykon anu'ma'pa iwe'i'san ke, eju'san i'wa: ");
INSERT INTO car_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Je'tun pe pore kynaitan o'wa, Korasin. Je'tun pe pore kynaitan o'wa, Betsaida. Moro Tyrus po, moro Sidon po enapa morokon otaine onepo'san Tamusi pori'torykon wo'kapy'sanymboto, penaro terapa natu'matoryine. Morokon yja'wan me tywe'i'san jetumary enepotopo womynano ke terapa newomyndotoryine. Weru'no'po ke terapa natakoroirotoryine. ");
INSERT INTO car_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wykaje o'waine: Moro a'wembono auranano yry jako, moro Tyrus ko'po 'ne ka'tu rapa, moro Sidon ko'po enapa mata'karykata'ton. ");
INSERT INTO car_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Amoro rapa Kafaraum, ajawongary man mekano'san kapu taka? Iromby'san waitopo taka te mony'totake. Moro Sodom po morokon ota onepo'san Tamusi pori'torykon wo'kapy'sanymboto, erome noro mondo nairy. ");
INSERT INTO car_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wykaje o'waine: moro a'wembono auranano yry jako, moro Sodom ko'po 'ne ka'tu rapa mata'karykatake.” ");
INSERT INTO car_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Moro jako enapa Jesus wyka'po: “Papa, kapu, nono Jopotory, poto me ajety sawongaje morokon ynekarity'san otykon unemy'san poko o'wa mo'karon oty uku'namon omepa'san wyino, uku'po'san poko te o'wa mo'karon sikyi'non 'wa. ");
INSERT INTO car_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","A'a, papa, moro wara iru'pa oty topoje o'wa man. ");
INSERT INTO car_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Pa'poro oty yryi yjumy yjainaka. Amy pairo kari'na mo'ko ymunano anukuty'pa man. Mo'ko jumynano roten kynuku'san. Amy pairo kari'na enapa mo'ko jumynano anukuty'pa man. Mo'ko ymunano roten kynuku'san. Mo'ko i'wa enepory 'se mo'ko ymunano waitopo enapa kynuku'san. ");
INSERT INTO car_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“O'toko 'ne y'wa, pa'poro awosin pangon otykon naki'marykon. Awu karemapota'ton. ");
INSERT INTO car_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Moro ynyry oty arotopo anundoko. Y'wa omepapotoko. Yturu'po irombo pyi'me'ke man. Po'po watapoja. Aja'karykon 'wano me oremano mepota'ton. ");
INSERT INTO car_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Moro ynyry oty arotopo irombo tupi me waty man. Moro anarorykon me ynyry sawo'ne man.” ");
INSERT INTO car_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Moro jako ro amy otare'matopo kurita Jesus kyny'sakon morokon awasi paty ta. Irombo mo'karon inemeparykon kumyry'san. Morokon wonatopo epery potyry a'mo'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Moro ene'po mero mo'karon Farise wyka'san Jesus 'wa: “Eneko! Moro otare'matopo kurita ta tykapymy waty oty ka'saton mo'karon anemeparykon!” ");
INSERT INTO car_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesus wyka'po te i'waine: “Awe'i'san poro o'to mo'ko David we'i'po anerupa'pa mandon, moro kumyno ta ta'ta mo'karon ta'sakarykon maro? ");
INSERT INTO car_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Moro Tamusi auty taka tywo'my tywaije man. Morokon Tamusi embata yry'san perere tana'se i'waine tywaine man. Morokon perere enapyry waty i'wa tywaije man, mo'karon a'sakarykon 'wa waty enapa. Mo'karon Tamusi pokonokon 'wa roten te morokon perere enapyry tywaije man. ");
INSERT INTO car_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Moro omenano karetary ta ka'tu anerupa'pa mandon onewara mo'karon Tamusi pokonokon 'wa tamendorykon pyndo moro Tamusi auty ta moro otare'matopo kurita yja'wangary? ");
INSERT INTO car_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Wykaje te o'waine: amy Tamusi auty ko'pono ero po man. ");
INSERT INTO car_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","O'to tauro'po me ero auranano wairy ukutyry manombo rypo tywaije o'waine man: ‘Kari'na 'wa kotano enery 'se wa. Tywomy tnomyn 'se'pa 'wa.’. Moro ukuty'pomboto o'waine, u'tano'non u'ta oty anyry'pa maitoryine. ");
INSERT INTO car_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Mo'ko kari'na ymuru irombo moro otare'matopo kurita jopotory me man.” ");
INSERT INTO car_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Irombo moro wyino Jesus wyto'po. Moro iwomepato'kon auto taka iwo'my'po. ");
INSERT INTO car_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Moro ro po amy ainamiriri'ta'po kynakon. Irombo Jesus emendoto'man epoto'me ty'waine, iwoturupo'san i'wa: “Iru'pa nan moro otare'matopo kurita amy je'tum pan kura'mary?” ");
INSERT INTO car_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesus wyka'po i'waine: “Amy otare'matopo kurita o'win amy ara'nanokon eky kapara woma'poto topona taka, anika'pa naitan? ");
INSERT INTO car_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kapara ko'po 'kare kari'na e'i'pa nan. Iro ke ro moro otare'matopo kurita aja'sakary poko iru'pa awairy man.” ");
INSERT INTO car_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Irombo ika'po mo'ko wokyry 'wa: “Ajainary ityngako!” Irombo moro tainary tynga'po i'wa. Irombo iru'pa rapa moro ainary we'i'po moro atoneno wara. ");
INSERT INTO car_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Irombo tywepa'ka'san mero mo'karon Farise worupa'san ase'wa one wara Jesus wory man poko. ");
INSERT INTO car_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Moro ukuty'po mero ty'wa, Jesus womima'po moro wyino. Pyimanokon kari'na apyimy 'wa iwekena'po. Pa'poro je'tun pangon kura'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","E'mapoty'san te imero i'wa takarory pona. ");
INSERT INTO car_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Iwara ro ero Tamusi auran uku'ponenymbo Jesaja nekarity'po wo'kapy'po: ");
INSERT INTO car_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Enetoko. Mo'se mo'ko ynapo'i'po ypyitory. Sipynaje. Yja'kary apokupe man. Yja'kary itu'ponaka sytake. Kari'na poko a'wembono auranano yry man ekarotan i'waine. ");
INSERT INTO car_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Asauranaka'pa kynaitan. Iko'tapoty'pa kynaitan. Auran aneta'pa kari'na kynaitan omakon ta. ");
INSERT INTO car_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Waruma wotamboty'po anipyty'ka'pa kynaitan. Kororeta ka'mukepyry ane'wu'ka'pa kynaitan. Moro wara kynaitan moro a'wembono auranano 'wa pa'poro oty y'mondory 'wa ro. ");
INSERT INTO car_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mo'ko momo'tan ro kari'na. ");
INSERT INTO car_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Irombo amy takyren wokyry enepy'po i'waine I'wa. Mo'ko ro enu'pa, erupo'pa enpa kynakon. Irombo iru'pa rapa yry'po i'wa. Aurana'po rapa. Oty ene'po rapa i'wa. ");
INSERT INTO car_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Pa'poro kari'na apyimykon enuta'san imero. Ika'san: “Mo'ko David parymbo kapyn mo'se nan?” ");
INSERT INTO car_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Moro eta'po mero mo'karon Farise wyka'san: “Mo'ko ewa'rumy tamuru Be'elsebul pori'tory ta roten mo'karon ewa'rumy momanon.” ");
INSERT INTO car_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","“Jesus 'wa te iwonumengarykon ukuty'po. Ika'po i'waine: “O'win e'i'pa amy nono undymanamon a'ta, moro nono undymary kynotany'matan. O'win e'i'pa amy aitopo ponokon, amy auto tanokon a'ta, tywairy taro waty moro aitopo, moro auto pai kynaitan. ");
INSERT INTO car_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan 'wa Satan momary jako, mo'karon Satan nundymary tanokon o'win e'i'pa mandon. One wara noro ko mo'karon tynundymary tanokon undymatan? ");
INSERT INTO car_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Y'wa mo'karon ewa'rumy momary jako Be'elsebul pori'tory ta, noky pori'tory ta ko mo'karon apyitorykon nimomaton? Iro ke ro mo'karon apyitorykon a'wembono auranano yta'ton apokoine. ");
INSERT INTO car_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tamusi a'kary pori'tory ta mo'karon ewa'rumy momary jako te y'wa, moro Tamusi nundymary tywo'se terapa man o'waine. ");
INSERT INTO car_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","One wara ko amy pana'pyn kari'na auty taka tywo'myry taro amy naitan morokon otyry mona'toto'me, mo'ko pana'pyn animy'pa na'nen ta'ta? Imy'poto te ty'wa, morokon auty tanokon mona'tory taro kynaitan. ");
INSERT INTO car_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mo'ko ymaro e'i'pa aitoto yjenono'nen me man. Mo'ko ymaro a'nano'to'pa aitoto aripa'to man. ");
INSERT INTO car_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Iro ke ro wykaje o'waine: pa'poro kari'na yja'wanykonymbo, ukuty'pa 'ne roten yja'wan me o'to ika'san tywo'kary taro man. Mo'ko Tamusi a'kary ejunen yja'wanymbo te o'ka'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Mo'ko kari'na ymuru poko yja'wan me orupatoto yja'wanymbo ty'wo'kary taro man. Mo'ko Tamusi a'kary poko yja'wan me orupatoto yja'wanymbo te o'ka'pa kynaitan moro eromeno nono tu'po, moro aireno nono tu'po enapa. ");
INSERT INTO car_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Iru'pa amy wewe a'ta, moro epery enapa iru'pa man. Yja'wan me amy wewe a'ta, moro epery enapa yja'wan me man. Wewe uku'san kari'na epery poko. ");
INSERT INTO car_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Yja'wangonymbo 'ne roten, one wara ko amyjaron yja'wan me aitonon iru'pa o'to awykarykon taro maita'ton? Moro kari'na turu'po tano wotakamary irombo indary wyino kyno'san. ");
INSERT INTO car_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Mo'ko iru'pyn kari'na moro kurano je'ny wyino kurangon otykon pa'kanon. Mo'ko yja'wan kari'na ko'wu moro tyja'wany je'ny wyino yja'wangon otykon pa'kanon. ");
INSERT INTO car_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wykaje te o'waine: pa'poro yja'wan me tykato'konymbo poko kari'na wosaijomary kynaitan moro a'wembono auranano ytopo kurita. ");
INSERT INTO car_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Awykato'pombo poko ro irombo a'wembono auranano yta'ton apoko, iru'pyn taka ajyto'me, yja'wan taka ajyto'me pai.” ");
INSERT INTO car_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Irombo amykon Tamusi karetary uku'namon, amykon Farise enapa wyka'san i'wa: “Amepanen, amy kapu wyinono oty 'nare enepoko na'na 'wa.” ");
INSERT INTO car_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesus 'wa ejuku'san: “Yja'wangon kari'na, taporitonokon nonamon kari'na enapa amy kapu wyinono oty enery 'se mandon. Amy anene'pa te kynaita'ton. Mo'ko Tamusi auran uku'ponenymbo Jona po roten te no'po'sen. ");
INSERT INTO car_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oruwa kurita, oruwa koko mo'ko woto tam'po'kory uwembo ta Jona we'i'po wara enapa irombo mo'ko kari'na ymuru oruwa kurita, oruwa koko moro nono koro'na kynaitan. ");
INSERT INTO car_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Moro a'wembono auranano yry jako, mo'karon Ninive ponokon kynawonda'ton mo'karon eromenokon kari'na maro. Mo'karon Ninive ponokon ro kynemendota'ton imero. Mo'karon Ninive ponokon waty Tamusi 'wa tywotu'ma tywaije nandon moro Jona auran poko. Ero po kore Jona ko'pono 'ne ka'tu rapa na. ");
INSERT INTO car_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Moro a'wembono auranano yry jako, mo'ko ijary pono woryi jopoto kynawondan mo'karon eromenokon kari'na maro. Mo'ko woryi ro kynemendota'ton imero. Mo'ko woryi waty tywo'se nan ero nono y'maty'po wyino Salomo wonumengapory eta. Ero po kore Salomo ko'pono 'ne ka'tu rapa na.” ");
INSERT INTO car_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Amy yja'wan akywano womimapoto mo'ko tynaki'marymbo wyino, tywotare'matopo upi kyny'san iponono aito'kon taka. Amy anepory'pa tywe'i'poto te ");
INSERT INTO car_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kynganon: ‘Weramatake rapa moro yjautymbo 'wa.’ Irombo tytunda'po po, moro tywaitopombo epojan itary'pa, ta'me, sara'me. ");
INSERT INTO car_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Irombo kyny'san rapa oko-to'ima noro amykon tyko'ponokon yja'wangon akywano aije. Irombo kyno'myjaton, moro po tywaito'ko'me. Iwara mo'ko wokyry yja'wan me 'ne ka'tu rapa kynaijan moro koromo tywe'i'po ko'po. Mojan eromenokon yja'wangon kari'na epotan enapa moropan oty.” ");
INSERT INTO car_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","“Mo'karon kari'na apyimykon 'wa auranary jako noro, mo'ko Jesus sano tunda'po mo'karon ipiryjan maro. Enery 'se kynatokon. Kurando kynaimomo'satokon. ");
INSERT INTO car_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Irombo amy wyka'po I'wa: “Asano, apiryjan kurando mandon. Ajenery 'se mandon.” ");
INSERT INTO car_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Mo'ko torupanenymbo 'wa te Jesus wyka'po: “Noky ko ysano me nan? No'kan ko ymeseku'san me mandon?” ");
INSERT INTO car_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tainary ke mo'karon tynemeparykon ekarity'san i'wa. Ika'po: “Mojan te ysano me, ymeseku'san me mandon. ");
INSERT INTO car_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Mo'ko kapukon tano yjumy nisanory wara aitoto ro ypiry me man, yjenauty me man, ysano me enapa man.” ");
INSERT INTO car_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Moro noro kurita Jesus wepa'ka'po. Moro parana esi'wo iwotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Pyime imero mo'karon kari'na wota'nanopy'san i'wa. Iro ke ro amy kurijara ta iwotandy'mo'po. Mo'karon ata'nanopy'san mapo kynatokon. ");
INSERT INTO car_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Irombo Jesus 'wa pyime otykon ekarity'san onumengato'kon auranano ke. Ika'po i'waine: “Epanamatoko! Amy maina pokono o'ponje kyny'san. ");
INSERT INTO car_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Moro iwo'pomyry jako ro, a'si 'ko amykon inipomyry epy kyno'pa'san oma esi'wo. Irombo mo'karon tonoro ena'se kyno'saton. ");
INSERT INTO car_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","A'si 'ko enapa amykon kyno'pa'san moro topu pan nono tu'ponaka. Moro po iko'po 'ne 'ne sakau waty man. O'win wytory kynatytanon, ipyimy'ma moro sakau wairy ke. ");
INSERT INTO car_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Weju wepa'ka'po mero te, asiny kynikoro'kanon. Imi'pa tywairy ke, kynajutanon. ");
INSERT INTO car_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","“Amykon enapa takyramon itupu paty ta kynopa'san. Irombo moro takyramon itupu atytary moro wonatopo wojan. ");
INSERT INTO car_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","“Amykon kyno'pa'san iru'pyn nono tu'ponaka. Amykon kynepetanon ainatone-kari'na me, amykonymbo oruwa-kari'na me, amykonymbo o'win-kari'na me itu'ponaka ainapatoro. ");
INSERT INTO car_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Irombo mo'karon inemeparykon wopy'san I'wa. Ika'san: “O'tono'me ko onumengato'kon auranano mekari'san i'waine?” ");
INSERT INTO car_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Irombo ejuku'san i'wa: “Amyjaron moro Tamusi nundymary poko tamorepa mandon, mo'karon kapyn te. ");
INSERT INTO car_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Mo'ko totyken 'wa irombo otykon yta'ton. Ekosa ro oty kynotakamatan. Mo'ko otypyn wyino te otyrykonymbo pinata'ton. ");
INSERT INTO car_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Iro ke ro onumengato'kon auranano sekari'sa i'waine. Kyno'po'saton ro rypo irombo. Otymbo ro anene'pa te mandon. Kynepanamaton ro rypo. Otymbo ro aneta'pa te mandon. ");
INSERT INTO car_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mojan ro ero Tamusi auran uku 'ponenymbo Jesaja wyka'po ka'pojaton: “Mepanamata'ton ro rypo apanarykon ke. Otymbo ro aneta'pa te maita'ton. Mo'po'ta'ton ro rypo ajenurukon ke. Otymbo ro anene'pa te maita'ton. ");
INSERT INTO car_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mojan kari'na turu'san tyja'nata man. Tywepanapu'to mandon. Tywonupu'to mandon. Iwara tanurukon ke oty anene'pa mandon. Typanarykon ke oty aneta'pa mandon. Ituru'san oty anukuty'pa man. Tamamyrykon anu'ma'pa mandon, tywekura'mapoto'ko'me y'wa. ");
INSERT INTO car_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Amyjaron, sara'me 'ne morokon ajenurukon ajypojaton. Oty enepojaton irombo o'waine. Sara'me 'ne morokon apanarykon ajypojaton. Oty etapojaton irombo o'waine. ");
INSERT INTO car_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ita'ro pore, pyime Tamusi auran uku'ponamonymbo irombo, tamamboramon enapa morokon anenerykon otykon enery 'se rypo tywaije mandon. Anene'pa te tywaije mandon. Morokon anetarykon otykon etary 'se enapa rypo tywaije mandon. Aneta'pa te tywaije mandon. ");
INSERT INTO car_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“O'to tauro'po me moro maina pokono poko ynekarity'po onumengatopo auranano wairy etatoko. ");
INSERT INTO car_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","“Morokon oma esi'wo o'papy'san wonatopo epy wara mo'karon ero wara aitonon mandon: Moro Tamusi nundymary ekary etaton. O'to tauro'po me te moro oka wairy anukuty'pa mandon. Irombo mo'ko yja'wan kyno'san. Moro ituru'san ta o'papy'san mona'tojan. ");
INSERT INTO car_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","“Morokon topu pan nono tu'ponaka o'papy'san wonatopo epy wara mo'karon ero wara aitonon mandon: O'win wytory Tamusi auran ewa'maton, eta'po mero ty'waine. ");
INSERT INTO car_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ituru'san ta te atandy'mo'pa man. Ko'i roten Tamusi amyikaton. Moro Tamusi auranymbo upu'po me awosin pangon otykon 'wa toporykon jako, ta'sakarykon 'wa tykota'marykon jako pai, o'win wytory kynomaton. ");
INSERT INTO car_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","“Morokon takyramon itupu paty ta o'papy'san wonatopo epy wara mo'karon ero wara aitonon mandon: Tamusi auranymbo etaton. Irombo te pyime nono tu'ponokon otykon poko kynonumengaton. Pyrata kynemu'maton. Iwara te moro Tamusi auranymbo epeta'pa kyniromo'san ituru'san ta. ");
INSERT INTO car_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","“Morokon iru'pyn nono tu'ponaka o'papy'san wonatopo epy wara mo'karon ero wara aitonon mandon: Moro Tamusi auranymbo etaton. O'to tauro'po me iwairy uku'saton. Irombo kynepetaton, amykonymbo ainatone-kari'na me, amykonymbo oruwa-kari'na me, amykonymbo o'win-kari'na me itu'ponaka ainapatoro.” ");
INSERT INTO car_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Amy rapa onumengatopo auranano ekarity'po Jesus 'wa i'waine. Ika'po: “Moro Tamusi nundymary amy tymainary ta iru'pyn wonatopo epy pyryrykanen kari'na wara man. ");
INSERT INTO car_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Mo'karon kari'na wo'nykyry jako, mo'ko ijenono'nen kyno'san. Itupu epyryry pyryrykanon moro awasi paty ta. Irombo kyny'san moro wyino. ");
INSERT INTO car_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Moro awasi atytary jako, epetary jako, moro itupu enapa kynatytanon. ");
INSERT INTO car_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Irombo mero mo'ko maina aporemy pyitorykon kyno'saton i'wa. Kyngaton i'wa: ‘Jopoto, iru'pyn wonatopo epy kapyn amainary ta mipyryrykan? One wara ko iro ke itupu pe nan?’ ");
INSERT INTO car_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kynganon i'waine: ‘Amy yjenono'nen 'wa moro wara tyje man.’ ");
INSERT INTO car_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Irombo mo'karon ipyitorykon kyngaton i'wa: ‘Na'na wytory 'se iro ke man moro itupu yna?’ Kyneju'saton: ‘Uwa. Ijako irombo moro itupu nary ta moro awasi mungata'ton. ");
INSERT INTO car_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Oro okororo natytan moro awasi potyry 'wa ro. Moro awasi po'topo kurita wykatake mo'karon ipo'namon 'wa: “Moro itupu 'ne ka'tu inatoko. Tamororo'ke pai imypo'toko, mikoro'kato'se me. Irombo moro awasi a'nano'toko moro ikura'matopo taka.” ’ ” ");
INSERT INTO car_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Amy rapa onumengatopo auranano ekarity'po Jesus 'wa i'waine. Ika'po: “Moro Tamusi nundymary amy tymainary ta kari'na nipomyry wonatopo epy'po'membo 'ko wara man. ");
INSERT INTO car_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Moro wonatopo epy'po ro irombo ro ko'warono moro man. Atyta'ma'poto te, poto me kynaijan pa'poro amykon terapa wonatopo ko'po. Wewe me kynaijan. Mo'karon tonoro tapo'nykon ka'saton morokon iporirykon poko.” ");
INSERT INTO car_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Amy rapa onumengatopo auranano ekarity'po i'wa i'waine: “Moro Tamusi nundymary moro perere uwapurotopo wara man. Amy woryi 'wa oruwa parapi poromy taka tyry'poto, pa'poro moro poromy uwapurojan.” ");
INSERT INTO car_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Pa'poro morokon otykon ekarity'san Jesus 'wa mo'karon kari'na apyimykon 'wa onumengato'kon auranano me. Onumengato'kon auranano pyndo anerupa'paine iwe'i'po. ");
INSERT INTO car_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Iwara ro ero Tamusi auran uku'ponenymbo nekarity'po wo'kapy'po: Onumengato'kon auranano sipa'katake yndary wyino. Ero nono wo'kapy'po poro atunemy'pombo oty sarykatake. ");
INSERT INTO car_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Irombo Jesus 'wa mo'karon kari'na apyimykon no'san. Auto 'wa ito'po. Irombo mo'karon inemeparykon wopy'san i'wa. Ika'san: “Moro maina tano itupu poko anekarity'po onumengatopo auranano ekari'ko na'na 'wa iru'pyn me 'ne ro.” ");
INSERT INTO car_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ejuku'san i'wa. Ika'po: “Mo'ko irupyn wonatopo epy pyryrykanen, mo'ko kari'na ymuru mo'ko man. ");
INSERT INTO car_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Moro maina, ero nono moro man. Moro irupyn wonatopo epy, moro Tamusi nundymary tanokon kari'na mo'karon mandon. Moro itu'pu, mo'karon ewa'rumy wyinonokon kari'na mo'karon mandon. ");
INSERT INTO car_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mo'ko itupu epyryry pyryrykanen tyjenono'ken, mo'ko ewa'rumy tamuru mo'ko man. Moro wonatopo potyry, ero nono y'matyry moro man. Mo'karon ipo'namon, Tamusi apojongon mo'karon mandon. ");
INSERT INTO car_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Moro itupu a'nanopy'po koro'kary wara enapa oty kynaitan ero nono y'matyry jako. ");
INSERT INTO car_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Mo'ko kari'na ymuru mo'karon kapu tanokon tapojongon emo'tan. Mo'karon ro moro Tamusi nundymary wyino mo'karon yja'wan taka ta'sakarykon emaponamon, mo'karon yja'wan me ta'sakarykon enanamon a'nano'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Irombo moro wa'to je'ny taka kynemata'ton. Moro po ro atamono, aijekyno enapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Irombo mero mo'karon tamamboramon moro tyjumykon nundymary ta weju wara taweije kynaita'ton. Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Moro Tamusi nundymary amy maina ta unemy'po karukuri wara man. Moro epojan ro amy kari'na. Irombo kynunenjan rapa. Ewa'pory pa'poro totyrymbo ekarama kyny'san. Morombo mero moro maina epeka'san. ");
INSERT INTO car_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Moro Tamusi nundymary amy kurangon paraso topurukonymbo upinen otykon ekaramanen wokyry wara enapa man. ");
INSERT INTO car_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Irombo amy tapenenymbo paraso topurumbo epory'poto ty'wa, pa'poro totyrymbo ekarama kyny'san. Irombo moro paraso topurumbo epeka'san. ");
INSERT INTO car_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Moro Tamusi nundymary amy parana taka ipapy'po sipi wara man. Pa'poro roten woto apyijan. ");
INSERT INTO car_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","A'nopy'poto, mo'karon woto pokonokon kynityngaton maponaka. Irombo tandy'po mo'karon kurangonymbo katon kurukurukon taka. Mo'karon yja'wangonymbo pa'saton te. ");
INSERT INTO car_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Moro wara enapa oty kynaitan ero nono y'matyry jako. Mo'karon Tamusi apojongon kynepa'kata'ton. Irombo mo'karon yja'wangon kari'na yta'ton typo mo'karon tamamboramon wyino. ");
INSERT INTO car_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Irombo moro wa'to je'ny taka kynemata'ton. Moro po ro atamono, aijekyno enapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Erokon pa'poro muku'ton?” Ika'san I'wa: “A'a.” ");
INSERT INTO car_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Irombo Jesus wyka'po i'waine: “Iro ke ro pa'poro mo'karon Tamusi nundymary ta omepatonon me e'i'san Tamusi karetary uku'namon amy totyry kura'matopo wyino aserynon otykon, penatonon otykon enapa pa'kanen auto jopotory wara mandon.” ");
INSERT INTO car_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Morokon onumengato'kon auranano ekarity'ma'san wyino ty'wa, Jesus womima'po moro wyino. ");
INSERT INTO car_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Moro tywetuwaro'matopombo 'wa tytunda'po mero, mo'karon ta'sakarykon emepa'san i'wa moro iwota'nano'to'kon auto ta. Mo'karon auran etanamon enuta'san imero. Ika'san: “Oje ko moro tywonumengapore aino topoje i'wa nan? Oje ko morokon pori'tonano topoje i'wa nan? ");
INSERT INTO car_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Mo'ko auto amynen ymuru kapyn mo'se nan? Maria kapyn isano me nan? Jakobus, Josef, Simon, Judas kapyn ipiryjan me nandon? ");
INSERT INTO car_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Pa'poro mo'karon enaunan waty kyra'naine nemanjaton? Oje ko iro ke pa'poro morokon otykon topoje i'wa nan?” ");
INSERT INTO car_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jesus imero kynere'kojatokon. Jesus wyka'po te i'waine: “Wararo amy Tamusi auran uku'ponen ety kawo man. Moro iwetuwaro'matopombo po roten te ety awonga'pa man. Mo'karon omorykon ekosa enapa ety awonga'pa man.” ");
INSERT INTO car_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tamusi anamyika'pa iwairykon ke ro pyime 'ne waty potonon pori'tonano enepo'po i'wa moro po. ");
INSERT INTO car_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Moro jako ro mo'ko jopoto Herodes 'wa Jesus ekary eta'po. ");
INSERT INTO car_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Irombo mo'karon typyitorykon 'wa ika'po: “Mo'ko kari'na etykanenymbo Johanes mo'ko man. Iromby'san wyino tawonje rapa man. Iro ke ro morokon pori'tonano ita kynemaminanon.” ");
INSERT INTO car_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Mo'ko Herodes 'wa irombo Johanes tapyipo tywaije kynakon. Tymypo tywaije i'wa kynakon. Taru'kapo tywaije i'wa kynakon yja'wangon kari'na aru'katopo taka, mo'ko typiry Filipus pytymbo Herodias upu'po me. ");
INSERT INTO car_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Johanes wykatopombo irombo tywaije kynakon Herodes 'wa: “Mo'ko woryi maro kapyn awairy man.” ");
INSERT INTO car_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes Johanes wory 'se rypo tywaije kynakon. Mo'karon kari'na apyimy pona te tanarike kynakon. Tamusi auran uku'ponen me irombo Johanes enejatokon. ");
INSERT INTO car_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mo'ko Herodes 'wa moro tywomatopombo kurita ewa'mary jako te, mo'ko Herodias emyiry uwa'po mo'karon ejuku'san 'wa. Herodes apokupe imero kynakon. ");
INSERT INTO car_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Iro ke ro Tamusi ety ejatory ta ika'po i'wa: “Moro y'wa awoturupotopo oty ro sytake o'wa.” ");
INSERT INTO car_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Irombo tysano 'wa tapokuma'po ke, mo'ko amyija'ko wyka'po: “Mo'ko kari'na etykanen Johanes upu'pombo ene'ko y'wa amy apo'ny tu'po.” ");
INSERT INTO car_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Kata'mato mo'ko jopoto we'i'po. Ise'me te mo'ko amyija'ko woturupotopo yry man ekarity'po i'wa, Tamusi ety ejatory ta, mo'karon endametonon netary me enapa taurana'po ke i'wa. ");
INSERT INTO car_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Moro yja'wangon kari'na aru'katopo ta ro Johanes u'kapo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Amy apo'ny tu'po moro upu'pombo enepy'po mero, mo'ko amyija'ko ainaka ypo'po i'wa. Irombo mo'ko amyija'ko 'wa tysano 'wa aro'po. ");
INSERT INTO car_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Morombo mero mo'karon Johanes nemeparykon wopy'san moro ekepy'po aije. Unemy'po i'waine. Morombo wyino ito'san Jesus 'wa ekari'se. ");
INSERT INTO car_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Moro eta'po mero ty'wa, Jesus wyto'po kurijara ta moro wyino, amy iponomyn aitopo 'wa, o'win upu'po tywaito'me. Moro eta'po mero ty'waine, mo'karon kari'na apyimykon 'wa iwekena'po typupurukon poko, morokon tywaito'kon wyino. ");
INSERT INTO car_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Moro kurijara wyino tywo'ka'po mero, moky kari'na wota'nanopy'san ene'po Jesus 'wa. Ikotanorykon ene'po i'wa. Mo'karon ira'nanokon je'tun pangon yry'san i'wa iru'pa rapa. ");
INSERT INTO car_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Koine 'ne iwe'i'po mero mo'karon inemeparykon wopy'san I'wa. Ika'san: “Ero aitopo ipono'ma man. Koine 'ne terapa man. Mo'karon kari'na apyimykon emo'toko rapa, tareparykon man epeka'to'se me morokon sengenokon aito'kon ta.” ");
INSERT INTO car_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus wyka'po te i'waine: “Itorykon kapyn man. Amyjaron te upatoko.” ");
INSERT INTO car_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Irombo ika'san I'wa: “Ainatone roten perere na'na ekosa man, oko woto maro.” ");
INSERT INTO car_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus wyka'po i'waine: “Ene'toko y'wa.” ");
INSERT INTO car_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Irombo mo'karon kari'na apyimykon andy'mopo'san i'wa itupu tu'po. Morokon ainatone perere, mo'karon okonokon woto anumy'san i'wa. Tamusi ety awonga'po i'wa. Irombo mero morokon perere y'sakapoty'san i'wa. Irombo mo'karon tynemeparykon 'wa yry'san i'wa, mo'karon kari'na apyimykon upato'me i'waine. ");
INSERT INTO car_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Pa'poro iwendame'san. Pa'poro iwaime'san. Irombo ainapatoro itu'ponaka oko kurukuru morokon arepa akosinykonymbo amo'i'ky'san i'waine. ");
INSERT INTO car_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Mo'karon endame'san wokyryjan ainatone dusun iwairy taro kynatokon. Woryijan, pitanikon enapa te tywendame kynatokon. ");
INSERT INTO car_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Irombo o'win wytory Jesus 'wa mo'karon tynemeparykon wyry'ka'san, iwotaru'kato'ko'me kurijara taka, tuwapo itoto'ko'me koposenaka. Mo'karon kari'na apyimykon emokyry 'se rapa kynakon aseke ro. ");
INSERT INTO car_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mo'karon kari'na emoky'ma'san mero ty'wa, moro wypy tu'ponaka ito'po, o'win 'ne Tamusi 'wa tauranato'me. Iko'mamy'poto, o'win upu'po moro po kynakon. ");
INSERT INTO car_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Moro jako moro kurijara ty'se terapa mapo wyino kynakon. Parana yja'wan me imero moro kurijara yjakon. Pepeito po'ponaka irombo kyny'sakon. ");
INSERT INTO car_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Irombo tuna tu'po Jesus wyto'po mo'karon tynemeparykon epoje, koko, emamyry jako. ");
INSERT INTO car_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Moro tuna tu'po itory ene'po mero ty'waine, mo'karon inemeparykon wety'ka'san. Ika'san: “Amy akatombo mo'ko man”. Enarirykon wotaikapoty'san. ");
INSERT INTO car_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","O'win wytory te Jesus aurana'po i'waine. Ika'po: “Aturu'san apyitoko! Awu te wa! Kytety'katon!” ");
INSERT INTO car_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrus 'wa te ejuku'po. Ika'po: “Amoro me ro aja'ta, kaiko y'wa, ywo'to'me o'wa tuna tu'po.” ");
INSERT INTO car_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesus wyka'po i'wa: “O'ko 'ne iro ke!” Irombo Petrus wo'ka'po moro kurijara wyino. Ito'po tuna tu'po Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Moro pepeito pori'tory 'wa tywo'poty'po mero te, iwety'ka'po. Tywotu'mukury mero iko'ta'po: “Jopoto! Kapano'ko!” ");
INSERT INTO car_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","O'win wytory Jesus 'wa tainary tynga'po. Petrus apo'i'po i'wa. Ika'po i'wa: “Oty anamyikaporopyn! O'tono'me ko oko aturu'po myryi?” ");
INSERT INTO car_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Irombo moro kurijara taka iwotaru'ka'san mero, moro pepeitombo yity'na'po imero. ");
INSERT INTO car_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mo'karon kurijara ta aitonon wokunama'san ipo'ponaka. Ika'san: “Iporo ro Tamusi ymuru amoro mana.” ");
INSERT INTO car_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Atonenaka tywepato'san mero, moro Genesaret yinonory 'wa itunda'san. ");
INSERT INTO car_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jesus ukuty'po mero ty'waine, mo'karon moro ponokon 'wa oka aripapy'po pa'poro moro wyinonokon aito'kon ta. Irombo pa'poro je'tun pangon enepy'san i'waine I'wa. ");
INSERT INTO car_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Iwe'pima'san i'wa, iwo'my sese'wuru roten y'tu'kato'me ty'waine. Pa'poro mo'karon i'tu'kanamonymbo we'i'san iru'pa rapa. ");
INSERT INTO car_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Irombo Jerusalem wyino amykon Farise wopy'san amykon Tamusi karetary uku'namon maro Jesus 'wa. Ika'san i'wa: ");
INSERT INTO car_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“O'tono'me ko mo'karon anemeparykon mo'karon uwapoto'san wykato'konymbo wara e'i'pa nandon? Asainaty'pa kore nendamejaton, ran!” ");
INSERT INTO car_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ejuku'san i'wa: “Amyjaron rapa, o'tono'me ko moro Tamusi wykatopombo memapojaton morokon anapyirykon uwapoto'san wykato'konymbo 'wa? ");
INSERT INTO car_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tamusi irombo tyka man: ‘Ajumy, asano inendoko. Mo'ko tyjumy, tysano ejunen rombyry man.’ ");
INSERT INTO car_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amyjaron te mykaton: ‘Amy wykary jako tyjumy 'wa, tysano 'wa pai: ‘Pa'poro ajepano'to'kon manombo y'wa, Tamusi 'wa syryi,’ ");
INSERT INTO car_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","mo'kopan 'wa tyjumy, tysano nendory kapyn noro man.’ Moro wara ro moro Tamusi wykatopombo mirupomangapojaton morokon anapyirykon uwapoto'san wykato'konymbo 'wa. ");
INSERT INTO car_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Tonapiramon 'ne roten, iporo imero mo'ko Tamusi auran uku'ponenymbo Jesaja ero wara apokoine tyka man: ");
INSERT INTO car_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Mojan ero ponokon yjety awongaton tyndarykon ke roten. Ituru'san te tyse man ywyino. ");
INSERT INTO car_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Typo roten moro yjety awongaton. Morokon kari'na emepato'kon i'waine, kari'na wykato'konymbo roten morokon man.” ");
INSERT INTO car_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Irombo mo'karon kari'na apyimy ko'ma'po mero ty'wa, Jesus wyka'po i'waine: “Epanamatoko y'wa. Uku'toko o'to ywykary. ");
INSERT INTO car_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Amy pairo indary taka o'mytoto oty kari'na anany'ma'pa man. Moro indary wyino o'toto oty te kari'na any'manon.” ");
INSERT INTO car_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Irombo mo'karon inemeparykon wopy'san I'wa. Ika'san: “Mo'karon Farise ere'ko'san muku'san moro awykatopombo 'wa?” ");
INSERT INTO car_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Irombo ika'po i'waine: “Pa'poro mo'ko kapu tano yjumy nipomy'torymbo tungamy moro man. ");
INSERT INTO car_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ipokoine kytaiton. Enu'non aronamon enu'non mo'karon mandon. Enupyn 'wa enupyn arory jako, okororo kynomata'ton amy nono atory taka.” ");
INSERT INTO car_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrus 'wa te Jesus ejuku'po: “Moro onumengatopo auranano iru'pyn me na'na 'wa ekari'ko.” ");
INSERT INTO car_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ika'po te: “Amyjaron ro rypo ka'tu onumenga'pa mandon? ");
INSERT INTO car_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Anukuty'pa mandon pa'poro morokon yndanano taka o'mytonon otykon wytory uwembonano taka, irombo amy oje terapa kurandonaka rapa iwopyry? ");
INSERT INTO car_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Moro indary wyino o'toto oty te ituru'po wyino kyno'san. Moro ro kari'na any'manon. ");
INSERT INTO car_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Moro ituru'po wyino ro irombo kyno'san yja'wan onumengano, kari'na wory, taporitonone aino any'mary, wararo wokyry, woryi maro aino, maname aino, tonapire aino, Tamusi ejuru. ");
INSERT INTO car_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Morokon otykon ro kari'na any'manon. Asainaty'pa endameno te kari'na anany'ma'pa man.” ");
INSERT INTO car_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Irombo Jesus wyto'po moro wyino. Iwomima'po moro Tyrus yinonory 'wa, moro Sidon yinonory 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Irombo amy Kana'an ponombo woryi wepa'ka'po. Iko'ta'po i'wa: “Jopoto, David parymbo, ykotanory eneko! Yjemyiry takyre man. Kynota'karykanon imero.” ");
INSERT INTO car_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus we'i'po te anejuku'pa pairo. Irombo mo'karon inemeparykon wopy'san i'wa. Ika'san: “Emo'ko rapa mo'ko woryi. Kywena'san ta tyko'tapotyry ene'san.” ");
INSERT INTO car_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ika'po eju'to'ko'me: “Tomo'se wa mo'karon utapy'san kapara waranokon Israel pajanymbo 'wano me roten.” ");
INSERT INTO car_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mo'ko woryi wopy'po te i'wa. Ipo'ponaka iwokunama'po. Ika'po: “Jopoto, kapano'ko.” ");
INSERT INTO car_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus 'wa te ejuku'po: “Yja'wan me man mo'karon pitanikon ereparymbo pinary, mo'karon pero upato'me ike.” ");
INSERT INTO car_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Mo'ko woryi wyka'po te: “Iwara ro rypo man, Jopoto. Mo'karon pero enapa te tapara wyino opapy'san taporenjan erepary pisara'san ena'saton.” ");
INSERT INTO car_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Irombo mero Jesus wyka'po i'wa: “Woryi, moro o'wa Tamusi amyikary poto me man. Anisanory wara ro o'wano me oty no'ka'nen.” Morombo wyino iru'pa rapa mo'ko emyiry kynakon. ");
INSERT INTO car_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Irombo moro wyino Jesus wyto'po. Moro Galilea tano tuna juwembory esi'wo ito'po. Moro wypy tu'ponaka iwonuku'po. Moro po ro iwotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Irombo pyime imero kari'na apyimykon wopy'san i'wa. Iwajakuta'san, enu'non, atamemy'san, erupo'non, pyime noro amykon terapa je'tun pangon enepy'san i'waine i'wa. Ipupuru po roten enytoka'san i'waine. Irombo iru'pa rapa yry'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Mo'karon kari'na apyimy enutano'po'po imero erupo'nonymbo auranary 'wa, iru'pa rapa atamemy'sanymbo we'i'san 'wa, iwajakuta'sanymbo wytopotyry 'wa, enu'nonymbo 'wa oty enery 'wa enapa. Irombo mo'karon Israel pajanymbo tamusiry ety awonga'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Irombo Jesus 'wa mo'karon tynemeparykon ko'ma'san ty'wa. Ika'po: “Mo'karon pyimano kari'na kotanory seneja. Oruwa kurita terapa yjekosa mandon erepa'mambo. Uwembotary'pa emokyrykon 'se'pa rapa wa. Ijako irombo oma ta kynirupomanda'ton.” ");
INSERT INTO car_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Irombo mo'karon inemeparykon wyka'san I'wa: “Oje ko arepa kysepota'ton mojan pyimanokon kari'na waimeto'me, ero iponomyn po?” ");
INSERT INTO car_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus wyka'po i'waine: “O'toro perere ko ajekosaine nan?” Ika'san: “Oko-to'ima perere, amykon woto'makon maro.” ");
INSERT INTO car_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Morombo mero mo'karon pyimano kari'na 'wa ika'po, nono tu'po iwotandy'moto'ko'me. ");
INSERT INTO car_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Irombo morokon oko-to'imanokon perere anumy'san i'wa, mo'karon woto maro. Tamusi ety awonga'po i'wa. Morombo mero i'sakapoty'san i'wa. Irombo mo'karon tynemeparykon 'wa yry'san i'wa, mo'karon kari'na apyimykon upato'me i'waine. ");
INSERT INTO car_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Pa'poro iwendame'san. Pa'poro iwaime'san. Irombo oko-to'ima kurukuru morokon arepa akosinykonymbo amo'iky'san i'waine. ");
INSERT INTO car_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Mo'karon endame'san wokyryjan okupa'en dusun kynatokon. Woryijan, pitanikon enapa te tywendame kynatokon. ");
INSERT INTO car_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Irombo mo'karon kari'na apyimykon emoky'san mero ty'wa, Jesus wotaru'ka'po kurijara taka. Ito'po moro Magadan yinonory 'wa. ");
INSERT INTO car_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Irombo mo'karon Farise wopy'san mo'karon Saduse maro Jesus 'wa. U'kuto'me ty'waine, iwoturupo'san amy kapu wyinono oty enepoto'me I'wa. ");
INSERT INTO car_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ejuku'san i'wa: “Koine 'ne mykaton: ‘Embatary iru'pyn me kynaitan. Kapu irombo tapire na.’ ");
INSERT INTO car_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kokoro mykaton: ‘Pari'pe erome kynaitan. Kapu irombo tuwasakaraije na.’ Kapu enery poko one wara embatary wairy man muku'saton. Amano poko te one wara oty wairy man ukutyry mupijaton? ");
INSERT INTO car_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yja'wangon kari'na, taporitonokon nonamon kari'na enapa amy kapu wyinono oty enery 'se mandon. Amy anene'pa te kynaita'ton. Mo'ko Tamusi auran uku'ponenymbo Jona po roten te no'po'sen.” Morombo mero ino'san i'wa. Ito'po. ");
INSERT INTO car_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Moro koposenaka tywepatorykon jako, mo'karon Jesus nemeparykon tytuwarenge'se kynatokon perere arory poko. ");
INSERT INTO car_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus wyka'po i'waine: “Tuwaro koro aitoko mo'karon Farise 'wa perere uwapurotopo pona, mo'karon Saduse 'wa perere uwapurotopo pona enapa.” ");
INSERT INTO car_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ase'wa iworupa'san. Ika'san: Moro wara kyngano perere anenepy'pa kywe'i'san ke. ");
INSERT INTO car_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Moro ukuty'po mero Jesus wyka'po: “O'tono'me ko moro iperere'pa awairykon poko morupaton ase'wa, oty anamyikaporo'non? ");
INSERT INTO car_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Oty anukuty'pa noro ka'tu mandon? Muta'katon terapa o'toro kurukuru morokon anamo'iky'san arepa akosinykonymbo we'i'san, mo'karon ainatone dusun kari'na upa'san wyino morokon ainatone perere ke? ");
INSERT INTO car_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Muta'katon enapa terapa o'toro kurukuru morokon anamo'iky'san arepa akosinykonymbo we'i'san, mo'karon okupa'en dusun kari'na upa'san wyino morokon oko-to'ima perere ke? ");
INSERT INTO car_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","One wara ko anukuty'pa mandon perere poko aurana'pa o'waine ywe'i'po? Wykai te o'waine, mo'karon Farise 'wa perere uwapurotopo pona, mo'karon Saduse 'wa perere uwapurotopo pona enapa tuwaro awaito'ko'me!” ");
INSERT INTO car_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Irombo mero ko'wu moro perere uwapurotopo pona kapyn tuwaro tywaito'ko'me ika'po ukuty'po i'waine, mo'karon Farise 'wa kari'na emepatopo pona te, mo'karon Saduse 'wa kari'na emepatopo pona enapa. ");
INSERT INTO car_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Moro Sesarea Filipi yinonory 'wa tytunda'san mero, mo'karon tynemeparykon 'wa Jesus woturupo'po: “Noky me ko mo'ko kari'na ymuru ekari'saton mo'karon kari'na?” ");
INSERT INTO car_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Irombo ika'san: “Amykonymbo mo'ko kari'na etykanenymbo Johanes me kynekari'saton. Amykonymbo te Elia me kynekari'saton. Amykonymbo rapa Jeremia me kynekari'saton, amy Tamusi auran uku'ponenymbo me pai.” ");
INSERT INTO car_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Irombo ika'po i'waine: “Amyjaron rapa, noky me ko kakari'saton?” ");
INSERT INTO car_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Petrus 'wa ejuku'po. Ika'po i'wa: “Mo'ko Mesias amoro mana, mo'ko nurono Tamusi ymuru.” ");
INSERT INTO car_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Eju'to'me Jesus wyka'po: “Sara'me 'ne janon maitake amoro, Simon Barjona. Kari'na 'wa kapyn irombo moro takari'se man o'wa, mo'ko kapukon tano yjumy 'wa te. ");
INSERT INTO car_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Awu enapa noky me awairy sekari'sa. Petrus amoro mana. Moro topu tu'po ro mo'karon ywyinonokon auty samytake. Moro pori'tory amono'ke ro moro iromby'san waitopo kynaitan. ");
INSERT INTO car_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Morokon Tamusi nundymary ra'kererykon sytake o'wa. Ero nono tu'po animy'po oty kapu ta tymy kynaitan. Ero nono tu'po animboka'po oty kapu ta tymboka kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Irombo mero mo'karon tynemeparykon 'wa ika'po, amy 'wa pairo mo'ko Mesias me tywairy anekarity'pa iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Morombo wyino Jesus 'wa Jerusalem 'wa tytory man ekarityry amo'po mo'karon tynemeparykon 'wa. Onewara mo'karon uwapoto'san 'wa, mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Tamusi karetary uku'namon 'wa enapa imero ta'karykapory man, tywory man enapa ekarisakon i'waine. Oruwa kurita tywo'po pa'po me te tawomyry man rapa ekarisakon i'waine. ");
INSERT INTO car_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Irombo te Petrus 'wa typo terapa aro'po. Irombo e'mary a'mo'po i'wa. Ika'po: “Tamusi ajaijomatan, Jopoto! Moropan oty ajepory'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus wotu'ma'po te. Petrus 'wa ika'po: “Omimako ywyino, Satan! Kaki'maje! Tamusi 'wa kapyn moro awonumengary man, kari'na 'wa te!” ");
INSERT INTO car_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Irombo Jesus wyka'po mo'karon tynemeparykon 'wa: “Ywena'po ta tywopyry 'se amy a'ta, aseke ty'poko ituwarengepyry man. Ywara enapa moro tywakapuru anumyry i'wa man. Irombo mero iwopyry man ywena'po ta. ");
INSERT INTO car_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mo'ko tamamyry aijomary 'san moro tamamyrymbo uta'katan. Mo'ko yjupu'po me tamamyry uta'kanenymbo te moro tamamyry epotan. ");
INSERT INTO car_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Otypan iru'pyn oty epotan ko amy kari'na, pa'poro ero nono tu'pono oty apo'i'poto ty'wa, irombo aseke moro tamamyrymbo uta'ka'poto ty'wa? Otypan oty ytan pai ko moro tamamyry y'petakan me? ");
INSERT INTO car_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Mo'ko kari'na ymuru irombo kyno'tan mo'ko tyjumy kuranory ta, mo'karon apojongon maro. Irombo mero pa'poro kari'na 'wa oty epemapotan moro o'to iwe'i'san wararo. ");
INSERT INTO car_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Ita'ro pore, amykonymbo ero po o'po'tonon iromby'pa kynaita'ton poto 'su jopoto me mo'ko kari'na ymuru wopyry enery uwaporo ty'waine.” ");
INSERT INTO car_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","O'win-to'ima kurita pa'po me Jesus 'wa Petrus, Jakobus, mo'ko ipiry Johanes aro'san tymaro amy kawono wypy tu'ponaka. Moro po ro a'saka'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Irombo inenerykon mero iwonurima'po. Moro embatary aweita'po weju wara. Moro iwo'my amu'na'po aweinano wara. ");
INSERT INTO car_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Irombo Elia wosenepo'po i'waine Moses maro. Jesus maro kynorupatokon. ");
INSERT INTO car_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Irombo Petrus wyka'po Jesus 'wa: “Jopoto, ka'ety ero po na'na man. I'se aja'ta, oruwa pataja'makon ero po samytake, o'wa o'win, Moses 'wa o'win, Elia 'wa o'win enapa.” ");
INSERT INTO car_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Auranary jako noro te, amy taweijen kapurutu wopy'po eponakaine. Moro kapurutu wyino ro amy auranano wota'po: “Mo'se, ymuru mo'se man. Sipynaje. Yjapokupe man. Epanamatoko i'wa.” ");
INSERT INTO car_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Moro eta'po mero, mo'karon Jesus nemeparykon woma'san tombata'po. Iwety'ka'san imero. ");
INSERT INTO car_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Irombo Jesus wopy'po i'waine. I'tu'ka'san i'wa. Ika'po i'waine: “Ajawondoko! Kytety'katon!” ");
INSERT INTO car_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Irombo iwo'poty'san rapa. Jesus roten ene'po terapa i'waine tokosaine. ");
INSERT INTO car_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tywony'torykon jako rapa moro wypy wyino, Jesus wyka'po i'waine: “Amy pairo kari'na 'wa moro anene'san oty kysekari'ton me, mo'ko kari'na ymuru awomyry uwaporo rapa iromby'san wyino.” ");
INSERT INTO car_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Mo'karon inemeparykon woturupo'san i'wa. Ika'san: “O'tono'me ko mo'karon Tamusi karetary uku'namon nykaton: ‘Elia na'nen kyno'tan.’?” ");
INSERT INTO car_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Irombo ika'po i'waine: “Elia na'nen ro kyno'tan, pa'poro oty yje rapa iru'pa? ");
INSERT INTO car_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wykaje te o'waine: Elia tywo'se terapa man. Anukuty'pa te tywaije mandon. Tynisanorykon tyka'se i'waine ty'waije man imaro. Iwara enapa mo'ko kari'na ymuru a'karykapota'ton.” ");
INSERT INTO car_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Irombo mero ko'wu mo'karon inemeparykon 'wa ukuty'po mo'ko kari'na etykanenymbo Johanes poko torupa'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mo'karon kari'na apyimykon 'wa iwopy'san mero, amy kari'na wopy'po Jesus 'wa. Ipo'ponaka iwokunama'po. Ika'po: ");
INSERT INTO car_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Jopoto, ymuru kotanory eneko. Tyja'natapo'ke man. Kynota'karykanon imero. O'kapyn wa'to taka, tuna taka enapa kynomanon. ");
INSERT INTO car_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mo'karon anemeparykon 'wa rypo saroi. Ikura'mary upiton te.” ");
INSERT INTO car_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Irombo Jesus 'wa ejuku'po: “Na! Oty anamyika'non pore yja'wangon kari'na, ran! O'toro kurita noro ko ajekosaine waitan? O'toro kurita noro ko ero wara awairykon sapyitan? Mo'ko myre'ko'ko ene'toko y'wa.” ");
INSERT INTO car_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Irombo Jesus 'wa mo'ko myre'ko'ko akyry e'ma'po. Irombo mo'ko akyrymbo wyto'po iwyino. Morombo wyino irupa rapa mo'ko myre'ko'ko kynakon. ");
INSERT INTO car_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Irombo a'saka'pa Jesus maro tywe'i'san mero, mo'karon inemeparykon woturupo'san i'wa: “O'tono'me ko imomary upi na'na?” ");
INSERT INTO car_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ika'po i'waine: “Oty anamyikaporo'non me awairykon ke. Ita'ro pore, amy ko'warono wonatopo epy wara roten moro o'waine Tamusi amyikary a'ta, irombo moro wypy 'wa awyka'sando: ‘Omimako ero wyino mony 'wa terapa!’ kynomimatan. Pa'poro o'to awairykon taro maita'ton.” ");
INSERT INTO car_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Irombo moro Galilea po tytopotyrykon jako ro, Jesus wyka'po mo'karon tynemeparykon 'wa: “Mo'ko kari'na ymuru yta'ton mo'karon kari'na ainaka. ");
INSERT INTO car_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Mo'karon ro kyniwota'ton. Oruwa kurita tywo'po pa'po me te kynawondan rapa.” Mo'karon inemeparykon we'i'san imero kata'mato. ");
INSERT INTO car_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Moro Kafaraum taka iwo'my'san mero, mo'karon Tamusi auty epematopo amo'i'namon wopy'san Petrus 'wa. Ika'san i'wa: “Moro Tamusi auty epety anyry'pa nan mo'ko ajemepanamon?” ");
INSERT INTO car_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Petrus wyka'po: “A'a, kynyjan.” Auto 'wa Petrus tunda'po mero, o'to ikary uwaporo Jesus wyka'po i'wa: “One wara ko monumenganon, Simon? Noky 'wa ko mo'karon potonon jopoto nopemapojaton? Mo'karon typyitorykon 'wa, mo'karon typyitorykon ra'naka amanje opy'san ty'senokon kari'na wa te ka'tu?” ");
INSERT INTO car_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrus wyka'po: “Mo'karon typyitorykon ra'naka amanje opy'san tysenokon kari'na 'wa.” Irombo mero Jesus wyka'po i'wa: “Mo'karon ipyitorykon iro ke mo'ko tyjopotorykon anepema'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mo'karon Tamusi auty epety amo'i'namon anere'kopo'pa te kytaisen. Kowai ematango moro tuna juwembory taka. Mo'ko koromo anatoky'po woto apyiko. Indakapako. Irombo o'win amy amu'nymbo pyrata mepotake. Moro ro apyiko, myry'se me mo'karon Tamusi auty epety amo'i'namon 'wa, y'wano me, o'wano me enapa.” ");
INSERT INTO car_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Moro jako 'ne mo'karon Jesus nemeparykon wopy'san i'wa. Ika'san: “Noky ko iro ke poto me 'ne nan moro Tamusi nundymary ta?” ");
INSERT INTO car_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Irombo amy pitani ko'ma'po i'wa ty'wa. Owarira'na yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Irombo ika'po: “Ita'ro pore, atu'ma'pa aja'taine, pitanikon wara e'i'pa aja'taine, o'my'pa pairo maita'ton moro Tamusi nundymary taka. ");
INSERT INTO car_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Mo'se pitani wara kowaroko amy wotapory jako, inorombo ro poto 'su mo'ko man moro Tamusi nundymary ta. ");
INSERT INTO car_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mo'ko yjety ta mo'sepan pitani ewa'manen yjewa'manon. ");
INSERT INTO car_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Mo'ko yja'wan taka o'win mo'sepan yjamyikanen pitani emaponenymbo u'mukary iru'pa 'ne ka'tu rapa man parana jansikyry taka, taneka'to oty ami'topo poto'su topu ke. ");
INSERT INTO car_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ero nono janon kynotakaryka'tan kari'na emapory ke yja'wan taka. Moro yja'wan taka kari'na womary akotory tupi me man. Mo'ko ika'pone kari'na 'wa te jetumbe pore oty kynaitan. ");
INSERT INTO car_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Yja'wan taka moro ajainary 'wa, moro apupuru 'wa pai ajemapory jako, i'kotoko. Emako awyinombo. O'win roten ajainary maro, o'win roten apupuru maro pai moro i'matypyn amano taka awytory iru'pa 'ne ka'tu rapa man moro okororo ajainary maro, okororo apupuru maro pai moro e'wutypyn roten wa'to taka awytory ko'po. ");
INSERT INTO car_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“Yja'wan taka moro ajenuru 'wa ajemapory jako, ikako. Emako awyinombo. O'win ajenuru maro moro i'matypyn amano taka awytory iru'pa 'ne ka'tu rapa man okororo ajenuru maro moro ata'karykatopo wa'to taka ajemary ko'po. ");
INSERT INTO car_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tuwaro aitoko o'win amy mo'sepan ko'warono enu'kary pona o'waine. Wykaje irombo o'waine, mo'karon unenamon kapu tanokon apojonano mo'ko kapukon tano yjumy embata roten mandon.” ");
INSERT INTO car_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“One wara ko monumengaton? Amy kari'na ekosa ainatone-kari'na kapara a'ta, irombo o'win amy utapy'poto, o'to ko naitan? Mo'karon okupa'en-kari'na itu'ponaka ainapatoro itu'ponaka okupa'en-to'ima kapara anino'pa naitan morokon wypy tu'po, mo'ko o'win utapy'po upi tytoto'me? ");
INSERT INTO car_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ita'ro pore, epory'poto ty'wa, mo'ko o'win tynepory'po ewa'matan mo'karon okupa'en-kari'na itu'ponaka ainapatoro itu'ponaka okupa'en-to'ima utapy'pa e'i'san ewa'mary ko'po. ");
INSERT INTO car_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Iwara enapa mo'ko kapu tano ajumykon o'win amy mo'sepan ko'warono utapyry 'se'pa man.” ");
INSERT INTO car_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Yja'wan me apoko amy aja'sakary we'i'poto, i'tango i'wa. Oko roten aja'taine, e'mako. Iwepanama'poto o'wa, mo'ko aja'sakary tapano'se o'wa man. ");
INSERT INTO car_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Epanama'pa iwe'i'poto, o'win, oko amykon maro pai i'tango i'wa. Oko, oruwa oty amyikaponamon 'wa irombo amy kari'na emendotopo pori'tomary man. ");
INSERT INTO car_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mo'karon 'wa enapa epanama'pa a'ta, mo'karon Tamusi na'nanopy'san apyimy 'wa ekari'ko. Mo'karon Tamusi na'nanopy'san apyimykon 'wa enapa epanama'pa a'ta, enery o'wa man amy Tamusi anukutypyn me, amy Rome pono jopoto ekataka pyrata amo'i'nen me enapa. ");
INSERT INTO car_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ita'ro pore, ero nono tu'po animy'san otykon kapu ta tymy kynaitan. Ero nono tu'po animboka'san otykon kapu ta tymboka kynaitan. ");
INSERT INTO car_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ita'ro pore, amy oty poko tywoturupoto'ko'me, ero nono tu'po oko amykon ara'nanokon 'wa o'win taurangon yry'poto amy oty poko, mo'ko kapukon tano yjumy moro oty ytan i'waine. ");
INSERT INTO car_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Yjety ta amy oje oko, oruwa kari'na wota'nanopy'san to irombo awu ira'naine wa.” ");
INSERT INTO car_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Irombo mero Petrus wopy'po Jesus 'wa. Ika'po: “O'toromboto ko yja'wan me poko mo'ko yja'sakary we'i'po kary y'wa nan? Oko-to'imamboto?” ");
INSERT INTO car_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesus wyka'po i'wa: “Oko-to'imamboto kapyn. Oruwa kari'na itu'po naka ainapatoromboto oko-to'imamboto te. ");
INSERT INTO car_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Iro ke ro moro Tamusi nundymary amy tapendomanamon typyitorykon 'wa opema'pototo poto 'su jopoto wara man. ");
INSERT INTO car_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Moro a'mo'po mero i'wa, amy poto me ependomanen ipyitory ene'saton ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Moro tu'tano epemary upiry ke i'wa mo'ko ijopotory kynganon ekaramato'me ipyty maro, i'makon maro, pa'poro otyrykonymbo maro enapa, moro tu'tano epemato'me i'wa. ");
INSERT INTO car_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Irombo mo'ko ipyitory kynokunamanon ipo'ponaka. Kynganon: ‘A'si 'ko noro aimomo'ko. Pa'poro moro yju'tano sepematake.’ ");
INSERT INTO car_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Irombo mo'ko ijopotory ikotanory enejan. Kynemo'san. Moro u'tanombo kakapojan. ");
INSERT INTO car_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kurandonaka tywepa'ka'po mero, mo'ko pyitonano amy ta'sakary pyitonano epojan. Mo'ko ro a'si 'ko ko roten kynependomanon. Irombo mo'ko tapendomanen tapyije i'wa man enasary poko. Kynganon i'wa: ‘Moro aju'tano epemako.’ ");
INSERT INTO car_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mo'ko a'sakary pyitonano kynokunamanon ipo'ponaka. Kynganon i'wa: ‘A'si 'ko noro aimomo'ko. Pa'poro moro yju'tano sepematake.’ ");
INSERT INTO car_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Moro 'se'pa te mo'ko inependomary man. Mo'ko tapendomanen aru'kapojan moro yja'wangon kari'na aru'katopo taka, moro tu'tano epema'mary 'wa ro i'wa. ");
INSERT INTO car_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mo'karon ene'po mero mo'karon a'sakarykon pyitonano 'wa ije'tuma'po imero. Kyny'saton mo'ko tyjopotorykon 'wa. Pa'poro moro o'kapy'po oty ekari'saton i'wa. ");
INSERT INTO car_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Irombo mo'ko jopoto 'wa mo'ko wokyry tyko'mapo man ty'wa. Kynganon i'wa: ‘Yja'wanymbo 'ne roten, moro aju'tanombo tam'po'kory sikakapoi, awe'pima'po ke y'wa. ");
INSERT INTO car_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mo'ko aja'sakary pyitonano kotanory enery manombo kapyn o'wa tywaije nan, y'wa moro akotanory ene'po wara enapa?’ ");
INSERT INTO car_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","“Irombo mo'ko ijopotory tywore'ko man. Mo'karon kari'na a'karykaponamon ainaka tyje i'wa man, pa'poro moro tu'tano epema'mary 'wa ro i'wa. ");
INSERT INTO car_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Moro wara enapa mo'ko kapu tano yjumy ajyta'ton, morokon apokoine yja'wan me aja'sakarykon we'i'san anika'pa aja'taine aturu'san maro.” ");
INSERT INTO car_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Moro wara taurana'ma'po mero, Jesus wyto'po Galilea wyino moro Judea yinonory 'wa, moro Jordan koposeno nono tu'po. ");
INSERT INTO car_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Pyime kari'na apyimykon 'wa iwekena'po. Mo'karon je'tun pangon kura'ma'san i'wa moro po. ");
INSERT INTO car_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Irombo amykon Farise wopy'san I'wa u'kuto'me. Ika'san: “Iru'pa nan amy wokyry 'wa pa'poro roten oty poko typyty nondary?” ");
INSERT INTO car_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ejuku'san i'wa. Ika'po: “Kareta ta anerupa'pa maiton Tamusi 'wa koromo ero nono kapyry jako kari'na kapy'po wokyry me, woryi me enapa? ");
INSERT INTO car_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tyka man Tamusi: ‘Iro ke ro amy wokyry tyjumy, tysano notan. Typyty maro kynotapyitan. Irombo mo'karon okonokon kari'na o'win ja'munano kynaita'ton.’ ");
INSERT INTO car_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Iwara te oko noro e'i'pa mandon. O'win te mandon. Iro ke ro mo'karon Tamusi napyipo'san nondapory kapyn man kari'na 'wa.” ");
INSERT INTO car_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Irombo ika'san I'wa: “O'tono'me ko iro ke Moses ino 'wa woryi nondapojan, amy inondatopo kareta mero'poto i'wa?” ");
INSERT INTO car_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ika'po i'waine: “Tyturu'poja'nare awairykon ke Moses apytykon nondapojan o'waine. Koromo 'ne te moro wara e'i'pa tywaije man. ");
INSERT INTO car_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wykaje te o'waine: amy typyty nondanenymbo 'wa amy terapa apyiry jako, mo'ko koromono typyty maro tywairymbo any'manon, wararo wokyry maro e'i'pa iwe'i'poto.” ");
INSERT INTO car_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Mo'karon inemeparykon wyka'san I'wa: “Moro wara typyty maro wokyry a'ta, iru'pa pore moro aimy'pa aino nairy.” ");
INSERT INTO car_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Irombo Jesus wyka'po i'waine: “Pa'poro 'ne kari'na ero auranano anukuty'pa mandon. Mo'karon i'waine ukutyry tyje Tamusi 'wa man inaron roten kynuku'saton. ");
INSERT INTO car_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Amykonymbo irombo moro tysanokon uwembo wyino tywopy'san poro woryi maro tywairykon upijaton. Amykonymbo rapa kari'na 'wa woryi maro e'i'non me tyje mandon. Amykon rapa moro Tamusi nundymary upu'po me woryi maro e'i'non me tywotyje mandon. Mo'ko ukutyry taro aitoto nuku'nen.” ");
INSERT INTO car_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Irombo pitanikon enepy'san i'waine I'wa. Tainary yry 'se i'wa kynatokon itu'ponakaine. Ipokoine Tamusi 'wa auranary 'se kynatokon. Mo'karon inemeparykon 'wa te mo'karon ene'namon e'ma'san. ");
INSERT INTO car_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jesus wyka'po te: “Oro tyre mo'karon pitanikon no'sen y'wa. Kysa'kototon. Mo'kopangon 'wano me ro irombo moro Tamusi nundymary man.” ");
INSERT INTO car_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Irombo itu'ponakaine tainary yry'po i'wa. Morombo mero ito'po moro wyino. ");
INSERT INTO car_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Irombo amy kari'na wopy'po I'wa. Ika'po: “Amepanen, otypan iru'pyn oty ko sika'tan, moro i'matypyn roten amano epoto'me y'wa?” ");
INSERT INTO car_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesus wyka'po i'wa: “O'tono'me ko maturupojan y'wa otypan oty wairy poko iru'pa? O'win roten amy iru'pa man. Moro i'matypyn amano taka awo'myry 'se aja'ta te, morokon Tamusi wykato'konymbo apyiko.” ");
INSERT INTO car_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ika'po Jesus 'wa: “Otypangon?” Jesus wyka'po: “Erokon: Woto kyte'i. Taporitonone aino kysany'mai. Amonatai. Onapi ke amy oty kysamyikapoi. ");
INSERT INTO car_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Ajumy, asano inendoko. Aja'sakary ipynako, aseke awaipynary wara enapa.” ");
INSERT INTO car_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Mo'ko pyito wyka'po I'wa: “Pa'poro morokon wara ro we'i. Oty noro ko samono'san?” ");
INSERT INTO car_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus wyka'po i'wa: “Oty anamonopy'pa awairy 'se aja'ta, pa'poro ajotyrykonymbo ekaramatango. Irombo moro epe'po yko mo'karon oty'non 'wa. Iwara totyke imero maitake kapukon ta. Irombo o'ko 'ne ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Moro eta'po mero ty'wa, mo'ko pyito wyto'po kata'mato terapa, pyime totyry wairy ke. ");
INSERT INTO car_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Irombo mero Jesus wyka'po mo'karon tynemeparykon 'wa: “Ita'ro pore, tupi me man amy totyken wytory moro Tamusi nundymary taka. ");
INSERT INTO car_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Wykaje rapa o'waine: Amy totyken kari'na wo'myry moro Tamusi nundymary taka tupi me man amy kameri wo'myry ko'po amy akusa enuru taka.” ");
INSERT INTO car_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Moro eta'po mero mo'karon inemeparykon we'naranga'san imero. Ika'san: “Noky 'ne ko iro ke uta'no wyino tunemyry taro nan?” ");
INSERT INTO car_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesus wo'poty'po i'waine. Irombo ika'po: “Moro oty kari'na ekosa tywo'kapyry taro e'i'pa man. Tamusi ekosa te pa'poro oty tywo'kapyry taro man.” ");
INSERT INTO car_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Moro poko eju'to'me Petrus wyka'po I'wa: “Eneko. Na'na pa'poro totyrymbo ynoi, awena'po ta tytoto'me. Oty ytan ko iro ke moro na'na 'wa?” ");
INSERT INTO car_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesus wyka'po mo'karon tynemeparykon 'wa: “Ita'ro pore, asery me rapa pa'poro oty yry'po mero, moro tykuranory ta jopoto me tywaitopo tapo'ny tu'po mo'ko kari'na ymuru wotandy'mo'po mero, amyjaron ywena'po ta ito'san enapa ainapatoro itu'ponaka oko jopotokon me awaito'kon ajapo'nykon tu'po matandymota'ton. Mo'karon ainapatoro itu'ponaka okonokon Israel y'makon pajanymbo poko a'wembono auranano myta'ton. ");
INSERT INTO car_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mo'ko yjupu'po me tautykonymbo, typiryjanymbo pai, tanaunanymbo pai, tyjumymbo pai, tysanombo pai, ty'makonymbo pai, tymainarymbo pai nojan inoro ainatone-kari'namboto moro ko'po 'ne ka'tu rapa oty apyitan. Moro i'matypyn amano apyitan enapa. ");
INSERT INTO car_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pyime uwaponokonymbo te wena'po tanokon me kynaita'ton. Pyime wena'po tanokonymbo uwaponokon me kynaita'ton. ");
INSERT INTO car_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Moro Tamusi nundymary amy tymosirory upinen jopoto wara man. Kokoro 'ne kynepa'kanon moro winu paty tymainary ta amaminatonon man upi. ");
INSERT INTO car_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mo'karon amaminatonon auran maro tauran epopojan, o'win kurita o'win amu'nymbo pyrata poko emaminato'ko'me. Morombo mero kynemo'saton moro tymainary taka. ");
INSERT INTO car_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Irombo okupa'en-to'ima juru a'ta, kynepa'kanon rapa. Moro otykon ekaramatopo po emami'ma amykon rapa wokyryjan enejan. ");
INSERT INTO car_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mo'karon 'wa ro kynganon: ‘Amyjaron enapa i'tandoko moro ymainary taka. Iru'pa kapemata'ton.’ ");
INSERT INTO car_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Irombo tyto mandon. Kurita 'ne 'ne a'ta, moro wara rapa kynaijan. Oruwa juru a'ta, moro wara 'su ko enapa kynaijan. ");
INSERT INTO car_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ainatone juru a'ta tywepa'ka'po mero, amykon rapa topoje i'wa man. Tyka man i'waine: ‘O'tono'me ko emami'ma ero po mo'po'saton kokoronombo poro?’ ");
INSERT INTO car_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tyka mandon i'wa: ‘Amy pairo na'na 'wa aturupo'pa ne'i ty'wa na'na emaminato'me.’ Tyka man i'waine: ‘Amyjaron enapa i'tandoko moro ymainary taka.’ ");
INSERT INTO car_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Iko'mamyry mero mo'ko winu paty aporemy kynganon mo'ko totyry enenen 'wa: ‘Mo'karon amaminatonon iko'mako. Irombo epematoko. Mo'karon wena'po tanokonymbo na'nen epemako. Mo'karon koromonokonymbo epemako wena'po ta.’ ");
INSERT INTO car_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Irombo mo'karon ainatone juru a'ta opy'san tytunda mandon. Tywe'i'san mero o'win amu'nymbo pyrata apyijaton. ");
INSERT INTO car_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tytunda'san mero, mo'karon koromonokonymbo 'wa rypo iko'poine pyrata apyiry man takano'se man. Mo'karon enapa te o'win amu'nymbo pyrata apyijaton, tywe'i'san mero. ");
INSERT INTO car_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tapetykon apo'i'ma'po mero ty'waine, toruwarykon arojaton mo'ko maina aporemy 'wa. ");
INSERT INTO car_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Kyngaton: ‘Mo'karon wena'po tanokonymbo o'win juru roten nemaminaton. Irombo na'na epemary wara enapa mepematon. Na'na te kokorombo poro awosin pe tamaminary ko'mangai asiny tam'po'kory ta.’ ");
INSERT INTO car_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Irombo te o'win amy ejuku'po i'wa: ‘Yjakono, yja'wan me apoko e'i'pa wa. Ajepety me o'win amu'nymbo pyrata wairy man poko kapyn kauran kysepopoi? ");
INSERT INTO car_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Moro ajemamina'po epety apyiko. Irombo i'tango. Awu mo'ko wena'po tanombo epemary 'se wa ajepema'po wara enapa. ");
INSERT INTO car_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ynisanory kapyry kapyn ka'tu y'wa nan moro ypyratary maro? Iru'pa ywairy poko ka'tu more'kojan?’ ");
INSERT INTO car_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iwara te mo'karon wena'po tanokonymbo uwaponokon me kynaita'ton. Irombo mo'karon uwaponokonymbo wena'po tanokon me kynaita'ton.” ");
INSERT INTO car_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalem 'wa tywonukuru jako, Jesus 'wa mo'karon ainapatoro itu'ponaka oko tynemeparykon ko'ma'san typo. Oma ta ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Enetoko. Jerusalem 'wa kytonu'saton. Moro po ro mo'ko kari'na ymuru yta'ton mo'karon Tamusi pokonokon jopotorykon ainaka, mo'karon Tamusi karetary uku'namon ainaka enapa. Mo'karon ro a'wembono auranano yta'ton, iwoto'me. ");
INSERT INTO car_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Irombo mo'karon Simosu me e'i'non ainaka kynyta'ton, ipoko iwosaijamboto'ko'me, ipoky'mato'me i'waine, wakapu poko iwoto'me enapa i'waine. Moro ijoruwanory kurita te kynawondan rapa.” ");
INSERT INTO car_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Irombo mo'ko Sebedeus y'makon sano wopy'po Jesus 'wa mo'karon ty'makon maro. Iwokunama'po ipo'ponaka, amy oty poko tywoturupoto'me i'wa. ");
INSERT INTO car_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesus wyka'po i'wa: “Oty 'se ko man?” Ika'po i'wa: “Kaiko, mojan okonokon y'makon wotandy'moto'me ajaporito moro anundymary ta: o'win amy ajapo'tun wyino, o'win amy ajapojery wyino.” ");
INSERT INTO car_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesus 'wa ejuku'po: “O'to awykarykon anukuty'pa mandon. Moro ynenyry man je'tun pan ysaperary tano enyry taro 'kare mandon.” Mo'karon i'makon wyka'san I'wa: “A'a, moro wara tywairy taro na'na man.” ");
INSERT INTO car_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus wyka'po i'waine: “Moro ysaperary tano menyta'ton. Yjapo'tun wyino te, yjapojery wyino pai, ajandy'moporykon supija. Morokon aito'kon taporemyndopo terapa man yjumy 'wa.” ");
INSERT INTO car_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Moro ukuty'po mero ty'waine, mo'karon ainapatoronokon wore'ko'san mo'karon oko asepiryjan poko. ");
INSERT INTO car_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Irombo Jesus 'wa iko'ma'san ty'wa. Ika'po: “Muku'saton waty mo'karon nono tu'ponokon jopoto 'wa mo'karon ta'sakarykon jopotomary, mo'karon typyratakamon wotapory kawo mo'karon ta'sakarykon ko'po? ");
INSERT INTO car_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Moro wara kapyn te iwairy man ara'naine. Poto me tywairy 'se amy a'ta ara'naine, ta'sakarykon tomosiry me iwairy man. ");
INSERT INTO car_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Uwapono me tywairy 'se amy a'ta ara'naine, ta'sakarykon pyitory me iwairy man. ");
INSERT INTO car_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Mo'ko kari'na ymuru enapa tytomosike aije opy'pa tywaije man. Kari'na pyitory me te tywo'se man, romo'se pyimano kari'na y'petakan me.” ");
INSERT INTO car_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Irombo Jeriko wyino itorykon jako, amy kari'na apyimy 'wa Jesus wekena'po. ");
INSERT INTO car_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Moro oma esi'wo oko amykon enu'non tandy'po kynatokon. Typatoine Jesus wytory eta'po mero ty'waine, iko'ta'san: “Na'na kotanory eneko, Jopoto, David parymbo!” ");
INSERT INTO car_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mo'karon kari'na apyimy 'wa te e'mapoty'san, ity'nato'ko'me. Mo'ja 'ne ka'tu rapa te iko'tapoty'san: “Na'na kotanory eneko, Jopoto, David parymbo!” ");
INSERT INTO car_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Irombo Jesus poropy'po. Iko'ma'san i'wa. Ika'po i'waine: “O'to ko ywairy 'se mandon ajekatakaine?” ");
INSERT INTO car_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ika'san I'wa: “Jopoto, na'na tanutary 'se man.” ");
INSERT INTO car_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus 'wa ikotanorykon ene'po. Irombo enurukon y'tu'ka'san i'wa. Irombo o'win wytory enuta'san. Morombo mero iwena'po ta ito'san. ");
INSERT INTO car_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Irombo tyse waty Jerusalem wyino tywe'i'san mero, moro oleif paty wypy patono aitopo Betfage 'wa itunda'san. Moro po ro Jesus 'wa oko amykon tynemeparykon apojoma'san. Ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Moro ajuwaponokon aitopo'membo 'wa i'tandoko. Moro aitopo taka awo'myrykon akono mero amy woryi parito my'po mepota'ton, amy parito'membo maro. Imbokatoko me. Irombo ene'toko me y'wa. ");
INSERT INTO car_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Amy o'to amy wykary jako o'waine, kaitoko me: “Mo'ko Jopoto i'seine man. O'win wytory rapa kynene'pota'ton.” ");
INSERT INTO car_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Moro tywo'ka'se man ero Tamusi auran uku'ponenymbo nekarity'po wo'ka'to'me: ");
INSERT INTO car_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Kaitoko mo'karon Sion ponokon 'wa: “Mo'ko Ajopotorykon janon kyno'san, pyi'me'ke, amy parito tu'po, amy oty aronen parito y'me tu'po.” ");
INSERT INTO car_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Mo'karon inemeparykon wyto'san. Jesus wyka'po wara ro iwe'i'san. ");
INSERT INTO car_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mo'ko woryi parito enepy'po i'waine mo'ko parito'membo maro. Tynoponykon yry'san i'waine itu'ponakaine. Itu'poine ro Jesus wotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Pyime imero kari'na 'wa tynoponykon apika'san oma rary me. Amykonymbo 'wa wewe porirykonymbo y'koto'san. Irombo oma rary me yry'san i'waine. ");
INSERT INTO car_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mo'karon oma ta Jesus uwapo ytotonon kari'na apyimy, mo'karon iwena'po ta ytotonon kari'na apyimy enapa kyniko'tapo'satokon: “Hosana mo'ko David parymbo 'wano me. Mo'ko Tamusi ety ta o'toto nainen pa'poro kurano maro. Hosana! Tamusi ety imero kawo nainen kapukon ta.” ");
INSERT INTO car_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Irombo Jerusalem taka iwo'myry jako, pa'poro mo'karon Jerusalem ponokon wetururuka'san. Ika'san: “Noky ko mo'ko nan?” ");
INSERT INTO car_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mo'karon kari'na apyimykon wyka'san: “Mo'ko Galilea tano Nasaret ponombo Tamusi auran uku'ponen Jesus mo'se man.” ");
INSERT INTO car_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Moro Tamusi auty 'wa tytunda'po mero, Jesus 'wa pa'poro mo'karon Tamusi auty ta otykon ekaramanamon, otykon epeka'namon moma'san. Mo'karon pyrata ambo'namon pyratary apo'nykonymbo uringa'san i'wa. Mo'karon akukuwa ekaramanamon apo'nykonymbo uringa'san enapa i'wa. ");
INSERT INTO car_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ika'po i'waine: “Tymero man: Yjauty ejatota'ton Tamusi 'wa kari'na we'pimatopo me. Amyjaron te amy tymonakamon autary me terapa myjaton.” ");
INSERT INTO car_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Moro Tamusi auty ta ro enu'non, iwajakuta'san enapa wopy'san I'wa. Ikura'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Moro anumengaponamon otykon kapyry ene'po ro mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Tamusi karetary uku'namon 'wa enapa. Moro Tamusi auty ta “Hosana mo'ko David parymbo 'wano me!” mo'karon pitanikon ko'tapo'tyry eta'po i'waine. Morokon poko ro iwore'ko'san. ");
INSERT INTO car_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ika'san Jesus 'wa: “Moro o'to ikarykon metanon?” Jesus wyka'po i'waine: “A'a, setaje. Awe'i'san poro kare ero imero'po anerupa'pa mandon: Pitanikon 'wa, oma'senangon 'wa enapa ajety mawongapoi.” ");
INSERT INTO car_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Moro po ro ino'san i'wa. Jerusalem wyino Betania 'wa ito'po. Moro po ro iwonyky'po. ");
INSERT INTO car_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kokoro 'ne Jerusalem 'wa rapa tywonukuru jako, Jesus kumyry'po. ");
INSERT INTO car_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Irombo oma esi'wo amy oroi ene'po i'wa. Ito'po i'wa. Amy pairo epery anepory'pa te iwe'i'po. Arymbo roten ipoko kynakon. Irombo ika'po moro oroi 'wa: “Epeta'pa roten 'su myre mairy.” O'win wytory moro oroi ajuta'po. ");
INSERT INTO car_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Moro ene'po mero, mo'karon inemeparykon enuta'san imero. Ika'san: “One wara ko o'win wytory najutai moro oroi?” ");
INSERT INTO car_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Eju'to'ko'me Jesus wyka'po: “Ita'ro pore, Tamusi amyikary jako o'waine, oko aturu'san e'i'pa a'ta, oroi any'mary taro roten kapyn maita'ton. Ero wypy 'wa pairo te awyka'sando ‘Ajawongo! Parana taka omatango!’ kyno'ka'tan ro. ");
INSERT INTO car_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tamusi amyikary jako o'waine, pa'poro Tamusi 'wa awoturupoto'kon mapyita'ton.” ");
INSERT INTO car_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Irombo moro Tamusi auty taka Jesus womy'po. Mo'karon kari'na emepary jako i'wa, mo'karon Tamusi pokonokon jopotorykon wopy'san i'wa mo'karon uwapoto'san maro. Ika'san i'wa: “Noky ko erokon otykon ka'pojan o'wa? Noky ko erokon otykon kapyry yryi ajainaka?” ");
INSERT INTO car_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesus 'wa ejuku'san: “Awu enapa o'win amy oty poko waturupoja o'waine. Yjauran ejuku'poto o'waine, sekari'take noky 'wa oma yry'po erokon otykon ka'to'me y'wa. ");
INSERT INTO car_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Moro Johanes 'wa kari'na etyka'po, noky nisanory ko moro tywaije nan? Tamusi nisanory? Kari'na nisanory te ka'tu?” Irombo ero wara ase'wa iworupa'san: “Kyka'sando ‘Tamusi nisanory moro tywaije man,’ kyngatan ky'waine ‘O'tono'me ko iro ke Johanes anamyika'pa maiton?’ ");
INSERT INTO car_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kyka'sando te ‘Kari'na nisanory moro tywaije man,’ tanarike kywairykon kynaitan mo'karon kari'na apyimy pona. Pa'poro irombo Johanes apyijaton amy Tamusi auran uku'ponenymbo me.” ");
INSERT INTO car_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Irombo ero wara Jesus ejuku'po i'waine: “Na'na anukuty'pa man.” Irombo Jesus wyka'po i'waine: “Awu enapa iro ke anekarity'pa waitake o'waine noky 'wa oma yry'po erokon otykon ka'to'me y'wa. ");
INSERT INTO car_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“One wara ko monumengaton ero poko? Amy wokyry oko tymune tywaije man. Mo'ko o'win amy 'wa mo'ko ijumyn kyny'san. Kynganon: ‘Koki, erome moro winu paty maina taka ajemaminatango.’ ");
INSERT INTO car_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tyjumy 'wa kynganon: ‘Uwa to, papa.’ Morombo wyino te moro moro wara tyka'po je'tumanon. Irombo moro maina taka kyny'san. ");
INSERT INTO car_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Irombo mo'ko ijumy mo'ko o'win amy tymuru 'wa terapa kyny'san. Moro koromo tyka'po wara ro rapa kynganon i'wa. Mo'ko imuru kynganon i'wa: ‘Iru'pa man, papa.’ Ito'pa te tywaije man. ");
INSERT INTO car_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nokypan 'wa ko moro tyjumy nisanory tyka'se nan?” Ika'san: “Mo'ko koromono 'wa.” Jesus wyka'po i'waine: “Ita'ro pore, mo'karon Rome pono jopoto ekataka pyrata amo'i'namon, mo'karon tyja'mungon poko pyrata ka'namon woryijan ajuwaporoine kyny'saton moro Tamusi nundymary taka. ");
INSERT INTO car_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mo'ko Johanes irombo moro tamambore aino emary ekari'se rypo tywo'se man o'waine. Anamyika'pa te tywaije mandon. Mo'karon Rome pono jopoto ekataka pyrata amo'i'namon 'wa te, mo'karon tyja'mungon poko pyrata ka'namon woryijan 'wa enapa tamyika man. Moro tone o'waine man. Ise'me te moro o'to awe'i'san anije'tuma'pa tywaije mandon. Anamyika'pa tywaije mandon.” ");
INSERT INTO car_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Amy terapa onumengatopo auranano etatoko. Amy auto jopotory tywaije man. Maina ta winu me tykapymy wonatopo typonje i'wa man. Moro maina tyjarando i'wa man. Moro wonatopo epery aikukato'man tatoka i'wa man. Kawo amy o'po'to'man tyka'se i'wa man. Irombo tapema me amykon maina pokonokon apojomanon, moro maina eneto'me i'waine. Morombo wyino amy tyseno aitopo 'wa ytopo'se kyny'san. ");
INSERT INTO car_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Irombo tywairy 'wa moro wonatopo epery we'i'po mero, mo'karon typyitorykon emo'san mo'karon maina pokonokon 'wa, morokon wonatopo epery aije. ");
INSERT INTO car_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Mo'karon maina pokonokon te mo'karon ipyitorykon apyijaton. O'win amy ypoky'maton. O'win amy wojaton. O'win amy tu'ponaka topu pa'saton. ");
INSERT INTO car_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Amykon rapa typyitorykon emo'san mo'ko maina aporemy, mo'karon koromonokonymbo ko'po pyime. Moro koromonombo wara ro rapa o'to tyje mandon mo'karon maina pokonokon 'wa. ");
INSERT INTO car_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Irombo mero ko'wu mo'ko tymuru emo'san i'waine mo'ko maina aporemy. Kynganon: ‘Ymuru nendota'ton.’ ");
INSERT INTO car_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mo'ko imuru ene'po mero te ty'waine, mo'karon maina pokonokon tyworupa mandon ase'wa. Kyngaton: ‘Mo'se ro mo'ko tyjumy otyrykonymbo apyinen man mo'se man. O'toko 'ne! Kysiwosen! Irombo moro inapyiry manombo kysapyisen!’ ");
INSERT INTO car_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Irombo mo'ko maina aporemy ymuru tapyije i'waine man. Moro maina wyino toma i'waine man. Tywo i'waine man. ");
INSERT INTO car_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","O'to ko iro ke mo'ko maina aporemy mo'karon maina pokonokon ytan, tywopy'po mero?” ");
INSERT INTO car_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ika'san I'wa: “Je'tun pe imero kyni'ma'kapota'ton. Moro winu paty maina enepotan tapema me amykon terapa maina pokonokon 'wa, mo'karon iwe'i'san mero moro wonatopo epery yry 'se kynaita'ton inaron 'wa.” ");
INSERT INTO car_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jesus wyka'po i'waine: “Awe'i'san poro kare ero Tamusi karetary ta imeropo anerupa'pa mandon: “Moro auto amynamon nema'pombo topu 'ne ro moro auto pori'tomanen me tywaije man. Tamusi emamin moro tywaije man. Moro 'wa kywo'potyrykon jako, poto me kanumengapojaton.” ");
INSERT INTO car_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Iro ke ro wykaje o'waine: Moro Tamusi nundymary pinata'ton awyinoine. Kynyta'ton tamamiporamon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Moro topu tu'ponaka amy woma'poto, kynotambaikatan. Amy tu'ponaka moro topu woma'poto, kynami'tan.” ");
INSERT INTO car_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Morokon inekarity'san onumengato'kon auranano eta'po mero ty'waine, mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Farise 'wa enapa moro typokoine Jesus aurana'po ukuty'po. ");
INSERT INTO car_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Apyiry 'se rypo kynatokon. Mo'karon kari'na apyimykon nendojatokon te. Tamusi auran uku'ponen me irombo kynapyijatokon. ");
INSERT INTO car_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Irombo onumengato'kon auranano ke rapa Jesus 'wa mo'karon kari'na erupa'san. Ika'po: ");
INSERT INTO car_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Moro Tamusi nundymary amy tymuru pytary ewa'maponen poto'su jopoto wara man. ");
INSERT INTO car_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mo'karon typyitorykon emo'san mo'karon ejuku'san ko'ma, iwo'to'ko'me mo'ko tymuru pytary ewa'ma. Tywopyrykon 'se'pa te mo'karon ejuku'san mandon. ");
INSERT INTO car_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Irombo amykon rapa typyitorykon emo'san. Kynganon i'waine: ‘Kaitoko mo'karon ejuku'san 'wa: “Moro arepa naikepyi terapa. Yjekykonymbo paka, tykakamon paka'makon enapa tywo terapa mandon. Pa'poro oty naikepyi terapa. O'toko 'ne ymuru pytary ewa'ma.” ’ ” ");
INSERT INTO car_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Mo'karon ejuku'san te tywenge moro oka etaton. O'win amy tymainary taka kyny'saton. O'win amy moro ty'wa otykon ekaramatopo 'wa kyny'san. ");
INSERT INTO car_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Mo'karon a'sakarykon mo'karon taju'namonymbo pyitorykon apyijaton. Kynipoky'maton. Kyniwojaton pairo. ");
INSERT INTO car_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Irombo mo'ko poto 'su jopoto kynore'kojan. Mo'karon warinu pokonokon apyimykon emo'san. Mo'karon typyitorykon wonamonymbo wopojan i'waine. Moro iwaito'konymbo po'mapojan i'waine. ");
INSERT INTO car_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Morombo wyino mo'karon typyitorykon 'wa kynganon: ‘Moro aimyno ewa'mato'me pa'poro oty naikepyi terapa. Mo'karon ejuku'san te moro 'wano me uwam'po tywaije mandon. ");
INSERT INTO car_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Iro ke ro morokon oma wo'raka'san 'wa itandokon. Pa'poro aneporykon kari'na iko'matoko moro aimyno ewa'ma.’ ");
INSERT INTO car_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Irombo mo'karon ipyitorykon kyny'saton omakon taka. Pa'poro tyneporykon yja'wangon, iru'pyngon enapa kari'na ene'saton. Moro aimyno ewa'matopo a'no'katon imero mo'karon endame o'tonon. ");
INSERT INTO car_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Irombo mo'ko jopoto kyno'myjan mo'karon opy'san ene. Irombo o'win amy kari'na enejan moro po aimyno ewa'matopo wo'mynano ane'moky'pa. ");
INSERT INTO car_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kynganon i'wa: ‘Yjakono, one wara ko ijaro 'wa mopyi aimyno ewa'matopo wo'mynano ane'moky'pa?’ Anejuku'pa te mo'ko wokyry man. ");
INSERT INTO car_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Irombo mero mo'ko jopoto kynganon typyitorykon 'wa: ‘Ainary, ipupuru imytoko. Ematoko moro tawa'rumanymbo taka. Moro po ro atamono, aijekyno enapa kynaitan.’ ");
INSERT INTO car_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Pyime irombo mo'karon iko'ma'san mandon. Pyime 'ne waty te mo'karon apo'i'san mandon.” ");
INSERT INTO car_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Irombo mero mo'karon Farise wyto'san ase'wa orupa one wara amy auranymbo poko ro rypo Jesus apyiry man poko ty'waine. ");
INSERT INTO car_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Irombo amykon tynemeparykon, amykon Herodes wyinonokon enapa emoky'san i'waine I'wa. Mo'karon wyka'san ro i'wa: “Amepanen, enapita'pa awairy uku'san na'na. Iporo imero moro Tamusi emary poko kari'na memepaje. Amy kari'na aninendo'pa awairy uku'san enapa na'na. Asewara imero kari'na menaje. ");
INSERT INTO car_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ekari'ko iro ke na'na 'wa one wara ero poko awonumengary. Iru'pa nan mo'ko Rome pono jopoto nundymary epemary? Uwa ka'tu?” ");
INSERT INTO car_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesus 'wa te moro yja'wanme iwonumengarykon ukuty'po. Irombo ika'po i'waine: “O'tono'me ko ku'kujaton, tonapiramon 'ne roten? ");
INSERT INTO car_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moro inundymary epematopo pyrata epety ene'toko y'wa, sene'se me.” Irombo amy amu'nymbo pyrata enepy'po i'waine i'wa. ");
INSERT INTO car_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Irombo Jesus woturupo'po i'waine: “Noky ko tu'ku nan ipoko? Noky ety ko tymero nan ipoko?” ");
INSERT INTO car_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Irombo ika'san i'wa: “Mo'ko Rome pono jopoto.” Irombo mero Jesus wyka'po i'waine: “Mo'ko Rome pono jopoto otyry iro ke ytoko i'wa. Mo'ko Tamusi otyry te ytoko Tamusi 'wa.” ");
INSERT INTO car_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Moro eta'po mero ty'waine, iwonumenga'san imero. Ino'po i'waine. Ito'san iwyino. ");
INSERT INTO car_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Moro noro kurita mo'karon Saduse wopy'san Jesus 'wa. Mo'karon ro uwa moro iromby'san wyino awono wairy ekari'saton. Irombo iwoturupo'san i'wa. ");
INSERT INTO car_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ika'san: “Amepanen, Moses tyka man: I'me'ma amy romby'poto, mo'ko ipirymbo 'wa mo'ko ipytymbo apyiry man. Irombo tyryi 'mi ekataka pitani kapyry i'wa man. ");
INSERT INTO car_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Oko-to'ima te amykon asepiryjan kynaisen na'na ekosa. Mo'ko koromono kynipytan. Irombo kyniromo'nen. I'me'ma mo'ko typytymbo ynon mo'ko typiry 'wa. ");
INSERT INTO car_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mo'ko koromonombo wara enapa mo'ko ipokorono kyniromo'nen. Iwara enapa mo'ko ijoruwanorymbo romby'po. Oko-to'imanombo mero moro wara kyiromo'sen. ");
INSERT INTO car_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Iwena'san ta ko'wu mo'ko woryi kyniromo'nen.” ");
INSERT INTO car_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","“Moro iromby'san wyino awono jako rapa, nokypan pyty me 'ne ko mo'ko woryi naitan? Pa'poro mo'karon oko-to'imanokon asepiryjan pyty me waty tywaije nan?” ");
INSERT INTO car_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus wyka'po eju'to'ko'me: “Tamusi karetary, Tamusi pori'tory anukuty'pa awairykon ke, ipo waty awonumengarykon man. ");
INSERT INTO car_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iromby'san wyino tawomy'sando rapa, wokyryjan ipyta'pa mandon, woryijan inomba'pa mandon. Kapu tanokon apojonano wara te mandon. ");
INSERT INTO car_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mo'karon iromby'san awomyry man poko 'kare ero o'wanokon me Tamusi wyka'po anerupa'pa maiton: ");
INSERT INTO car_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Awu Abraham tamusiry awu wa, Isak tamusiry, Jakob tamusiry enapa.” Iromby'san tamusiry kapyn mo'ko man. Nuronokon tamusiry te mo'ko man.” ");
INSERT INTO car_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Moro eta'po mero, mo'karon kari'na apyimykon enumengapo'po imero moro i'wa emepato'kon 'wa. ");
INSERT INTO car_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesus 'wa mo'karon Saduse yity'nano'po'san eta'po mero, mo'karon Farise wopy'san ase'wa. ");
INSERT INTO car_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Irombo o'win amy ira'nanokon Tamusi karetary uku'nen woturupo'po Jesus 'wa. U'kuto'me ika'po i'wa: ");
INSERT INTO car_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Amepanen, otypan omenano ko poto me 'ne nan moro omenano karetary ta?” ");
INSERT INTO car_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus wyka'po i'wa: “Mo'ko Atamusiry Jopoto ipynako pa'poro aturu'po maro, pa'poro aja'kary maro, pa'poro awonumengary maro enapa. ");
INSERT INTO car_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Moro ro, moro irombo ro poto 'su omenano mero'po moro man. ");
INSERT INTO car_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Moro ipokorono asewara imaro man: Aja'sakary ipynako, aseke awaipynary wara enapa. ");
INSERT INTO car_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Erokon okonokon omenano ro pa'poro moro omenano karetary tano, pa'poro mo'karon Tamusi auran uku'ponamon nimero'san enapa pori'tomano.” ");
INSERT INTO car_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Moro iwota'nanopy'san po ro Jesus woturupo'po mo'karon Farise 'wa: ");
INSERT INTO car_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“One wara ko monumengaton mo'ko Mesias poko? Noky parymbo ko mo'ko nan?” Ika'san I'wa: “David parymbo mo'ko man.” ");
INSERT INTO car_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Irombo Jesus wyka'po i'waine: “One wara ko iro ke David mo'ko Tamusi a'kary 'wa taurambary ta Tyjopotory me nejatojan? Kynganon irombo: ");
INSERT INTO car_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Tamusi nykai mo'ko Yjopotory 'wa: Yjapo'tun wyino atandy'moko, mo'karon ajenono'namon yry 'wa ro y'wa apupuru upi'nonaka.’ ");
INSERT INTO car_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","David 'wa Jopoto me mo'ko Mesias ejatory jako, one wara ko iro ke iparymbo me rapa nan?” ");
INSERT INTO car_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Amy pairo te ejukuru upijakon. Morombo poro amy pairo we'i'po oty poko noro tywoturupory 'se'pa i'wa. ");
INSERT INTO car_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Irombo mero Jesus aurana'po mo'karon kari'na apyimykon 'wa, mo'karon tynemeparykon 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ika'po: “Mo'karon Tamusi karetary uku'namon, mo'karon Farise enapa, Moses apo'nymbo tu'po tywotandy'mo mandon. ");
INSERT INTO car_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Pa'poro o'to ikato'kon wara aitoko. Morokon ro apyitoko. Morokon iwairykon wara te kytaiton. Morokon tykato'kon wara irombo e'i'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Awosin pangon otykon, morokon arory tupi me man irokon myjaton. Irombo kari'na tu'ponaka kynyjaton. Aseke te o'win amy tainarykon siky'iry ke pairo morokon otykon y'tu'kary 'se'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Pa'poro morokon tynikapyrykon otykon ka'saton kari'na enuru me roten. Morokon taijomanamon amo'tykon akumbirojaton irombo. Moro tywo'mykon sese'wuru mosindojaton. ");
INSERT INTO car_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Apokupeine man ta'sakarykon ko'po iru'pyn me tapo'ne iwendamerykon, uwapo imero morokon tywota'nano'to'kon auto ta iwotandy'morykon, ");
INSERT INTO car_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","morokon otykon ekaramato'kon po kari'na 'wa ewa'marykon, amepanamon me kari'na 'wa ejatorykon enapa. ");
INSERT INTO car_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Amyjaron te amepanamon me kytojatopoton. O'win roten irombo ajemepanamon man. Pa'poro amyjaron asepiryjan me mandon. ");
INSERT INTO car_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Amy pairo enapa ero nono tu'po ajumykon me kysejatoton. O'win roten ajumykon man: mo'ko kapu tano ajumykon. ");
INSERT INTO car_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jopoto me enapa kytojatopoton. O'win roten Ajopotorykon man: mo'ko Mesias. ");
INSERT INTO car_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mo'ko ara'naine poto me aitoto wairy man atomosirykon me. ");
INSERT INTO car_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Pa'poro aseke toty awonganen ety po'po kynaitan. Aseke toty emaponen ety te kawo kynaitan. ");
INSERT INTO car_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Je'tun pe pore te oty kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, amyjaron Farise enapa. Moro Tamusi nundymary irombo mira'kere'tojaton, kari'na wo'myry pona, o'my'pa awairykon ke itaka. Irombo mo'karon tywo'myrykon 'sangon ma'kotojaton. ");
INSERT INTO car_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Je'tun pe pore te kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, Farise enapa. Parana irombo mipatojaton, mapo enapa mytopo'saton, o'win roten amy kari'na yto'me Simosu me. Simosu me iwe'i'po mero te ako'poine 'ne ka'tu rapa tyja'wan ke mypojaton. ");
INSERT INTO car_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Je'tun pe pore te oty kynaitan o'waine, enu'non oma ekari'namon. Mykaton irombo: ‘Mo'ko tauran pori'tomato'me moro Tamusi auty ejatonenymbo 'wa moro tykatopombo kapyry kapyn man. Mo'ko tauran pori'tomato'me moro Tamusi auto tano ika'mi'po ejatonenymbo 'wa te moro tykatopombo kapyry man.’ ");
INSERT INTO car_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oty anukuty'non enu'non! Oty ko poto me 'ne nan? Moro ika'mi'po? Moro ika'mi'po kuranondonen Tamusi auty te ka'tu? ");
INSERT INTO car_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Mykaton enapa: ‘Mo'ko tauran pori'tomato'me moro Tamusi 'wa tymy apo'ny ejatonenymbo 'wa moro tykatopombo kapyry kapyn man. Mo'ko tauran pori'tomato'me moro itu'pono Tamusi 'wa tymy ejatonenymbo 'wa te moro tykatopombo kapyry man.’ ");
INSERT INTO car_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Enu'non 'ne roten! Oty ko poto me 'ne nan? Moro Tamusi 'wa tymy? Moro Tamusi 'wa tymy kuranondonen apo'ny te ka'tu? ");
INSERT INTO car_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Mo'ko Tamusi 'wa tymy apo'ny ejatonen moro tauran pori'tomapojan moro apo'ny 'wa roten kapyn, pa'poro itu'ponokon otykon 'wa enapa te. ");
INSERT INTO car_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Mo'ko Tamusi auty ejatonen moro tauran pori'tomapojan moro Tamusi auty 'wa roten kapyn, mo'ko ita amandoto 'wa enapa te. ");
INSERT INTO car_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Mo'ko kapu ejatonen moro tauran pori'tomapojan moro Tamusi apo'ny 'wa roten kapyn, mo'ko itu'po tandy'pono 'wa enapa te. ");
INSERT INTO car_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Je'tun pe pore te oty kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, amyjaron Farise enapa. Morokon tuma poporoto'kon itupu jainapatoronorymbo irombo, pa'poro tanapymy sa'rombo jainapatoronorymbo enapa irombo amy myjaton Tamusi 'wa. Morokon potononymbo otykon poko te ko'wu atuwarenge'saton: moro tamambore aino, moro kotano enery, moro Tamusi amyikary enapa. Irokon poko tuwaro awairykon manombo man, morokon koromonokon otykon poko atuwarengepyrykon pyndo. ");
INSERT INTO car_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Enu'non oma ekari'namon! Karapana kato'me moro anenyrykon misukaton. Mo'ko kameri te ko'wu me'mo'saton moro anenyrykon maro. ");
INSERT INTO car_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Je'tun pe pore te oty kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, Farise enapa. Kurando wyino roten moro asaperarykon, awendameto'kon mikorokaton. Itaine te moro mona tam'po'kory, moro kuminano tam'po'kory enapa man. ");
INSERT INTO car_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Enupyn 'ne roten Farise! Ita 'ne ka'tu moro sapera ikorokako. Irombo mero kurando wyino enapa tykoroka kynaitan. ");
INSERT INTO car_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Je'tun pe pore te oty kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, Farise enapa. Tamu'ne ikuripa'san tu'munano, morokon kurando kurangon me kynonejaton irokon, morokon korona te pyime imero je'ponanokonymbo pa'poro roten nurijangon otykon maro man irokon wara mandon. ");
INSERT INTO car_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Morokon wara enapa amyjaron kurando tamambore monepojaton kari'na 'wa. Otaine te moro ajenapirykon tam'po'kory, moro oja'wanykon tam'po'kory enapa man. ");
INSERT INTO car_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Je'tun pe pore te oty kynaitan o'waine, tonapiramon Tamusi karetary uku'namon, Farise enapa. Mo'karon Tamusi auran uku'ponamonymbo tu'mungon irombo mika'saton. Morokon tamamboramon tu'mungon mikura'maton. ");
INSERT INTO car_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Irombo mykaton: ‘Mo'karon kytangonymbo jako kywe'i'sanymboto, mo'karon Tamusi auran uku'ponamonymbo mynuru ani'kambo'pa imaroine kytaitoryine.’ ");
INSERT INTO car_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Iwara ro mo'karon Tamusi auran uku'ponamonymbo wonamonymbo pajanymbo me awairykon aseke mamyikapojaton. ");
INSERT INTO car_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Aike'katoko iro ke moro atangonymbo na'mo'po amaminano. ");
INSERT INTO car_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yja'wangonymbo 'ne roten! One wara ko moro ata'karykatopo taka ajaroporykon wyino metuwarikata'ton? ");
INSERT INTO car_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Iro ke ro Tamusi auran uku'ponamon, oty uku'namon, Tamusi karetary uku'namon enapa semo'sa o'waine. Amykonymbo ira'nanokon miwota'ton. Mipokata'ton wakapu poko. Amykonymbo mipoky'mata'ton awota'nano'to'kon autokon ta. Ajerekurukon kyniwekenata'ton aito'kon wararo. ");
INSERT INTO car_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Iwara ro pa'poro ero nono tu'po e'kamy'po tamamboramon mynurumbo epemapotan Tamusi o'waine. Mo'ko Abel wyinombo ro mynu epemary marota'ton mo'ko Berekja ymuru Sakarias 'wa ro. Mo'ko Sakarias mo'ko Tamusi auty ta mo'ko Tamusi 'wa tymy apo'ny pato tywo o'waine man inoro, wykaje irombo. ");
INSERT INTO car_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","“Ita'ro pore, pa'poro morokon otykon mo'karon eromenokon kari'na tu'ponaka kyno'tan. ");
INSERT INTO car_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jerusalem, Jerusalem, amoro mo'karon Tamusi auran uku'ponamon wonen, topu ke mo'karon o'wa emoky'san apojonano wonen, pyimemboto rypo o'makon a'nanopyry 'se we'i, amy korotoko 'wa ty'makon a'nanopyry wara taporiry upi'nonaka. I'se'pa te maiton. ");
INSERT INTO car_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iro ke ro moro ajautykon itary'pa kynainopotan. ");
INSERT INTO car_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wykaje irombo o'waine: Erombo poro yjene'pa noro rapa maita'ton moro ero wara awykarykon poko ro: ‘Tykuranondo man mo'ko Tamusi ety ta o'toto.’ ” ");
INSERT INTO car_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Moro Tamusi auty wyino Jesus wepa'ka'po mero, mo'karon inemeparykon wopy'san I'wa. Moro Tamusi auty enepojatokon I'wa. ");
INSERT INTO car_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Irombo ika'po i'waine: “Pa'poro moro menejaton? Ita'ro pore, oko pairo topu anino'pa kynaita'ton asetu'po.” ");
INSERT INTO car_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Moro oleif paty wypy tu'po iwotandy'mo'po mero, a'saka'pa mo'karon inemeparykon wopy'san I'wa. Ika'san: “Ekari'ko na'na 'wa, one wara a'ta moro oty wairy man. Otypan oty poko ko moro awopyry man, moro nono y'matyry man enapa uku'tan na'na?” ");
INSERT INTO car_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesus wyka'po eju'to'ko'me: “Tuwaro aitoko, amy 'wa ajemu'marykon pona. ");
INSERT INTO car_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pyime kari'na irombo yjety a'kutan. ‘Mo'ko Mesias awu wa,’ kyngata'ton. Irombo pyime kari'na emu'mata'ton. ");
INSERT INTO car_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Warinu ekary, warinu wairy man ekary enapa metata'ton. Tuwaro te aitoko awety'karykon pona. Morokon otykon wo'kapyry ro irombo man. Irombo ro noro kapyn te moro man. ");
INSERT INTO car_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kari'na ase'wa warinu ka'ta'ton. Potonon aito'kon ase'wa kyno'wo'mata'ton. Aito'kon po kumyno, tytyty enapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Morokon ro moro ata'karykano wota'mory moro kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Moro jako ro ajekaramata'ton, aja'karykapoto'ko'me. Awota'ton. Pa'poro kari'na ajenono'ta'ton yjety upu'po me. ");
INSERT INTO car_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Pyime Tamusi amyikanamonymbo kynomata'ton. Ase'wa kynokaramata'ton. Ase'wa kynaijenono'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Pyime Tamusi auran uku'ponamon me okaritonon kynawonda'ton. Pyime kari'na emu'mata'ton. ");
INSERT INTO car_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Aseme noro poto me moro omenano mero'po enu'kary wairy pyime ase'wa kari'na waipynarymbo y'sanapangatan. ");
INSERT INTO car_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mo'ko i'matyry 'wa ro eja'nakatoto epano'tan te Tamusi. ");
INSERT INTO car_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Moro Tamusi nundymary ekapory ekarota'ton pa'poro ero nono tu'po. Pa'poro kari'na 'wa kynetapota'ton. Irombo mero ko'wu ero nono kyni'ma'tan. ");
INSERT INTO car_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Moro Tamusi wyinono aitopo po mo'ko Tamusi auran uku'ponenymbo Daniel nekarity'po oty any'manen nurija noky enery jako o'waine” - mo'ko ero kareta erupanen tuwaro nainen - ");
INSERT INTO car_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“moro jako ro mo'karon Judea ponokon netuwarikasen morokon wypy 'wa. ");
INSERT INTO car_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tauty re'ta amy a'ta, oro netuwarikan. Tauty taka rapa o'my'pa nainen morokon totyry aije. ");
INSERT INTO car_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Tymainary ta amy a'ta, erama'pa nainen tynopony aije. ");
INSERT INTO car_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Mo'karon mynotonon 'wa, mo'karon onema'senangon 'wa enapa je'tun pe pore oty kynaitan moro jako. ");
INSERT INTO car_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","“Tamusi 'wa te aturupotoko poto 'su i'sano jako, amy otare'matopo kurita pai etuwarika'pa awaito'ko'me. ");
INSERT INTO car_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Poto 'su ata'karykano irombo kynaitan moro jako. Tamusi 'wa ero nono kapy'po poro, erome noro moropan oty o'kapy'pa man. Moropan oty enapa o'kapy'pa noro rapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ko'i aike'ka'pa moro oty we'i'poto, amy pairo kari'na epa'ka'pa nairy. Mo'karon typo tynyry'san kari'na upu'san me te ko'i moro oty aike'katan Tamusi. ");
INSERT INTO car_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Moro jako ro amy wykary jako o'waine ‘Eneko, mo'se ro mo'ko Mesias’, ikary jako pai ‘Eneko, mo'ky inoro’, kysamyikaton. ");
INSERT INTO car_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mo'karon Mesias me okari'tonon irombo kynawonda'ton. Mo'karon Tamusi auran uku'ponamon me okari'tonon kynawonda'ton. Potonon anumengaponamon otykon, potonon pori'tonano enepota'ton enapa. Iwara ro mo'karon typo Tamusi nyry'san kari'na emu'mary poko pairo kyne'kuta'ton. ");
INSERT INTO car_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enetoko, iwo'kapyry uwaporo oty sekarityi o'waine. ");
INSERT INTO car_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iro ke ro amykon wykary jako o'waine ‘Eneko, moro iponomyn wo'i ta man,’ kytoton i'wa. Ikarykon jako ‘Eneko, moro apu'to'po ta man,’ kysamyikaton. ");
INSERT INTO car_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Kapekape 'wa undy wyinombo aretyry 'wa ro oty aweipary wara irombo mo'ko kari'na ymuru wopyry kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Amy tonomy ekepy'po po ro mo'karon kurumu kynota'nano'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“O'win wytory moro moro jakono ata'karykano pa'po me moro weju kynewa'rumandan. Moro nuno aweita'pa kynaitan. Morokon siriko kapu rary wyino kyno'pa'tan. Irombo morokon kapu tanokon pori'tonano kynesakamapo'ta'ton. ");
INSERT INTO car_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Irombo mero mo'ko kari'na ymuru wopyry man uku'potopo oty kynonepotan kapu poko. Pa'poro ero nono tu'po mo'karon kari'na kynotamota'ton. Mo'ko kari'na ymuru wopyry eneta'ton kapurutu ta, pori'tonano maro imero, kurano me imero. ");
INSERT INTO car_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kuti tam'po'kory ety wota'po mero, mo'karon tapojongon apojomatan. Mo'karon ro mo'karon typo inyry'san a'nano'ta'ton morokon okupa'en pepeito wo'tokon wyino, pa'poro ero nono y'maty'po 'wa ro. ");
INSERT INTO car_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Moro oroi po roten opotoko. Morokon iporiry sekurita'po mero, irombo arynary jako, senge terapa moro poto 'su iromy wairy muku'saton. ");
INSERT INTO car_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Iwara enapa uku'toko apenarykon wyino senge terapa mo'ko kari'na ymuru wairy, pa'poro morokon otykon wo'kapyry enery jako o'waine. ");
INSERT INTO car_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ita'ro pore, mo'karon eromenokon kari'na i'maty'ma'pa kynaita'ton, pa'poro erokon otykon wo'kapyry uwaporo. ");
INSERT INTO car_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kapu, nono kynuta'tan. Moro yjauranymbo te utapy'pa roten kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Amy pairo te anukuty'pa man otypan kurita, o'toro juru a'ta morokon otykon wo'kapyry man. Mo'karon kapu tanokon Tamusi apojongon enapa anukuty'pa mandon. Mo'ko ymunano enapa anukuty'pa man. Mo'ko jumynano roten kynuku'san. ");
INSERT INTO car_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Mo'ko Noe jako iwe'i'pombo wara enapa kynaitan mo'ko kari'na ymuru wopyry jako. ");
INSERT INTO car_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Moro jako ro irombo, moro poto 'su kumano uwaporo, tywendame mandon, typytapo'se mandon, tyinombapo'se mandon moro atunendopo tam'po'kory taka Noe wo'mytopo kurita 'wa ro. ");
INSERT INTO car_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Oty wopyry anukuty'pa pairo tywaije mandon, moro pa'poro ty'ma'kanamon man kumano wopyry uwaporo. Iwara enapa mo'ko kari'na ymuru wopyry kynaitan. ");
INSERT INTO car_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Moro jako ro oko wokyryjan maina ta kynaita'ton. Irombo o'win amymbo arota'ton Tamusi apojongon. O'win amymbo nota'ton te. ");
INSERT INTO car_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Oko woryijan kyno'kyta'ton aseta. Irombo o'win amymbo arota'ton Tamusi apojongon. O'win amymbo nota'ton te. ");
INSERT INTO car_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Iro ke ro tuwaro aitoko! Mo'ko Ajopotorykon wo'topo kurita anukuty'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Ero te uku'toko: One wara a'ta mo'ko manaman wopyry ukuty'pomboto ty'wa, mo'ko tautynen o'ny'se ito'pa nairy. Mo'ko manaman ana'mykapo'pa tauty taka nairy. ");
INSERT INTO car_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Amyjaron enapa penaro ro awaimomokyrykon man. Mo'ko kari'na ymuru irombo typo roten kyno'tan. ");
INSERT INTO car_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nokypan pyitonano ko iro ke tamyikapore, tupu'pone enapa imero nan, mo'ko ijopotory 'wa yto'me mo'karon a'sakarykon epo, upato'ko'me i'wa arepa enapyry tunda'po mero? ");
INSERT INTO car_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sara'me 'ne janon kynaitan mo'ko moro wara ijopotory nepory'po tywopy'poto. ");
INSERT INTO car_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ita'ro pore, mo'ko ijopotory pa'poro moro totyry ytan ainaka. ");
INSERT INTO car_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Yja'wan me mo'ko ipyitory a'ta te, tyturu'po ta ikary: ‘Yjopotory opy'pa na'nen man’, ");
INSERT INTO car_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","irombo mo'karon ta'sakarykon pyitonano ypoky'mary, mo'karon etyndonon maro tywendamery a'mo'poto i'wa, ");
INSERT INTO car_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","mo'ko ijopotory amy kurita typo roten kyno'tan. Mo'ko typyitory poromu'katan. ");
INSERT INTO car_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Irombo kynemimatan. Tonapiramon yry wara enapa kynytan. Mo'karon waito'kon po ro atamono, aijekyno enapa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Moro jako moro Tamusi nundymary ainapatoro tykororetarykon anunamon amyijanon wara mandon. Morokon tykororetarykon anumy'san mero kyny'saton mo'ko pytatoto epoje. ");
INSERT INTO car_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ainatone onumengapo'pa mandon. Ainatone tywonumengapore mandon. ");
INSERT INTO car_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Morokon kororeta arory jako ty'waine, mo'karon onumengapo'non amyijanon kororeta katy anaro'pa mandon. ");
INSERT INTO car_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mo'karon tywonumengaporamon te tukuwarikon ta kororeta katy arojaton enapa. ");
INSERT INTO car_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","O'poro'pa noro mo'ko pytatoto a'ta, pa'poro kynuwetunaton. Irombo kyno'ny'saton. ");
INSERT INTO car_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Irawone 'ne a'ta kari'na kyniko'taton: ‘Eneko. Mo'ko pytatoto kyno'san. Epa'katoko epoje!’ ");
INSERT INTO car_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Irombo pa'poro mo'karon amyijanon kynupakaton. Morokon tykororetarykon yjaton iru'pa. ");
INSERT INTO car_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Mo'karon onumengapo'non kyngaton mo'karon tywonumengaporamon 'wa: ‘A'si 'ko moro ajekosanokon kororeta katy amy ytoko na'na 'wa. Na'na kororetary irombo kyne'wu'san terapa.’ ");
INSERT INTO car_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Mo'karon tywonumengaporamon te kyngaton eju'to'ko'me: ‘Uwa. Ka'pa rapa pa'poro kamono'keine iwairy. Mo'karon ekaramanamon wyino amy epeka'tandoko aseke.’ ");
INSERT INTO car_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Kororeta katy epeka'se ito'san wyino, mo'ko pytatoto kono'san. Imaro ro mo'karon aikepy'san terapa amyijanon kyno'myjaton moro pytano ewa'matopo auto taka. Irombo moro pena tyra'kere'to man. ");
INSERT INTO car_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Morombo wyino mo'karon a'sakarykonymbo amyijanon enapa kyno'saton. Kyngaton: ‘Jopoto! Jopoto! Na'na 'wa etapurumakako!’ ");
INSERT INTO car_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mo'ko te ero wara kyneju'saton: ‘Ita'ro pore, ajukuty'paine wa.’ ");
INSERT INTO car_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Iro ke ro tuwaro aitoko. Moro kurita, moro ijururu enapa anukuty'pa irombo mandon.” ");
INSERT INTO car_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Moro Tamusi nundymary amy tyse ytopo'se ytototo wokyry wara man. Tytory mero, mo'karon typyitorykon ko'manon. Morokon totyry yjan ainakaine. ");
INSERT INTO car_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","O'win amy 'wa ainatone dusun ika'mi'po pyrata yjan, o'win amy 'wa oko dusun, o'win amy 'wa o'win dusun, moro ipori'torykon taro ro. O'win wytory ");
INSERT INTO car_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","mo'ko ainatone dusun ika'mi'po pyrata apyinenymbo kyny'san amamina ike. Itu'ponaka ainatone dusun ka'san noro. ");
INSERT INTO car_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Iwara enapa mo'ko oko dusun apyinenymbo oko dusun ka'san noro itu'ponaka. ");
INSERT INTO car_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mo'ko o'win dusun apyinenymbo te tyto'po mero nono amikanon. Moro tyjopotory pyratary unenjan. ");
INSERT INTO car_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Akore'pe tywe'i'po wyino mo'karon pyitonano jopotory kyno'san rapa. O'to mo'karon typyitorykon 'wa moro typyratary yry'po ukutyry 'se man. ");
INSERT INTO car_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Irombo mo'ko ainatone dusun apyinenymbo kyno'san i'wa. Itu'ponaka ainatone dusun ene'san noro i'wa. Kynganon: ‘Jopoto, ainatone dusun myryi y'wa. Eneko. Ainatone dusun noro amy sikapyi.’ ");
INSERT INTO car_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mo'ko ijopotory kynganon i'wa: ‘Iru'pa tywaije mana, amoro iru'pyn, tamyikaporen pyitonano. A'si'konombo oty poko tamyikapore me'i. Pyimano oty pokono me terapa kytake. Oko'ne, mo'ko ajopotory maro tawa'pore aiko.’ ");
INSERT INTO car_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Irombo mo'ko oko dusun apyinenymbo enapa kyno'san i'wa. Kynganon: ‘Jopoto, oko dusun myryi y'wa. Eneko. Oko dusun noro amy sikapyi.’ ");
INSERT INTO car_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mo'ko ijopotory kynganon i'wa: ‘Iru'pa tywaije mana, amoro iru'pyn, tamyikaporen pyitonano. A'si'konombo oty poko tamyikapore me'i. Pyimano oty pokono me terapa kytake. Oko'ne, mo'ko ajopotory maro tawa'pore aiko.’ ");
INSERT INTO car_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Irombo mo'ko o'win dusun apyinenymbo enapa kyno'san i'wa. Kynganon: ‘Jopoto, amy ituru'popopyn kari'na me awairy suku'sa. Anipomy'torymbo mipo'sa, ynaripapy'torymbo ma'nano'sa. ");
INSERT INTO car_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tanarike we'i. Iro ke ro moro apyratary sunemyi nono ta. Eneko ero iro.’ ");
INSERT INTO car_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Irombo mo'ko ijopotory kynganon eju'to'me: ‘Amoro yja'wanymbo, akinupan pyitonano, muku'sakon ka'tu ynipomy'torymbo po'nen me ywairy, ynaripapy'torymbo a'nano'nen me ywairy enapa. ");
INSERT INTO car_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Moro ypyratary yry manombo iro ke tywaije o'wa man mo'karon pyrata pokonokon 'wa. Ijako moro ypyratary rapa sapyiry moro iwe'mekatopo maro. ");
INSERT INTO car_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Moro pyrata ipinatoko ainary wyino. Irombo yko mo'ko ekosa ainapatoro dusun ika'mi'po pyrata man inoro ainaka. ");
INSERT INTO car_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","“Pa'poro totykamon 'wa irombo otykon yta'ton. Ekosaine ro oty kynotakamatan. Mo'ko otypyn wyino te otyrykonymbo pinata'ton. ");
INSERT INTO car_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Mo'ko uwam'pono pyitonano te ematoko moro tawa'rumanymbo taka. Moro po ro atamono, aijekyno enapa kynaitan.’ ");
INSERT INTO car_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Moro tykuranory ta mo'ko kari'na ymuru wopyry jako pa'poro mo'karon kapu tanokon apojonano maro, moro kurano tapo'ny tu'po kynotandy'motan. ");
INSERT INTO car_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Pa'poro nono tu'ponokon kari'na a'nano'ta'ton ipo'ponaka. Irombo mo'karon kari'na a'sakatan, mo'ko tonomyn enenen 'wa mo'karon kapirita yry wara typo mo'karon kapara wyino. ");
INSERT INTO car_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Mo'karon kapara ytan tapo'tun wyino. Mo'karon kapirita ytan te tapojery wyino. ");
INSERT INTO car_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Irombo mo'ko poto 'su Jopoto kyngatan mo'karon tapo'tun wyinonokon 'wa: ‘O'toko 'ne, amyjaron Yjumy nikuranondo'san. Ajotyrykon me moro Tamusi nundymary apyitoko. O'wanokon me ro irombo tyje tywaije man ero nono wo'kapy'po poro. ");
INSERT INTO car_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tykumyje irombo wakon. Irombo arepa ke kupasen. Tuna 'se wakon. Irombo tuna ke kupasen. Tyseno me o'waine wakon. Irombo ywo'ny'to'man mysen. ");
INSERT INTO car_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Iwo'my'ma wakon. Irombo kywo'myndosen. Je'tun pe wakon. Irombo yjenenamon me maisen. Yja'wangon kari'na aru'katopo ta wakon. Irombo yjene mo'sen.’ ");
INSERT INTO car_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Irombo mo'karon tamamboramon kyneju'ta'ton. Kyngata'ton: ‘Jopoto, one wara a'ta ko moro akumyry jako arepa ke na'na ajupan? One wara a'ta ko moro tuna 'se aja'ta tuna ke na'na ajupan? ");
INSERT INTO car_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","One wara a'ta ko moro tyseno me aja'ta na'na 'wa na'na awo'ny'to'man ynen o'wa? One wara a'ta ko moro iwo'my'ma aja'ta na'na awo'myndon? ");
INSERT INTO car_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","One wara a'ta ko moro je'tun pe aja'ta, yja'wangon kari'na aru'katopo ta aja'ta pai ajene na'na kyndonen?’ ");
INSERT INTO car_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Irombo mo'ko poto 'su Jopoto kyneju'ta'ton. Kyngatan: ‘Ita'ro pore, pa'poro mo'ko ko'waronombo ro rypo yja'sakary 'wa anikapy'san oty y'wano me tyka'se o'waine man.’ ");
INSERT INTO car_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Irombo mero kyngatan mo'karon tapojery wyinonokon 'wa: ‘Amyjaron atany'ma'san, i'tandoko ywyino moro e'wutypyn roten wa'to taka, mo'ko ewa'rumy tamuru 'wano me, mo'karon apojongon 'wano me enapa yry'po taka. ");
INSERT INTO car_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tykumyje irombo wakon. Irombo arepa ke yjupa'pa maisen. Tuna 'se wakon. Irombo tuna ke yjupa'pa maisen. ");
INSERT INTO car_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tyseno me o'waine wakon. Irombo ywo'ny'to'man anyry'pa maisen. Iwo'my'ma wakon. Irombo ywo'myndo'pa maisen. Je'tun pe wakon. Yja'wangon kari'na aru'katopo ta enapa wakon. Irombo yjene opy'pa maisen.’ ");
INSERT INTO car_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Irombo mo'karon enapa kyneju'ta'ton. Kyngata'ton: ‘Jopoto, one wara a'ta ko moro tykumyje aja'ta, moro tuna 'se aja'ta, moro tyseno me aja'ta, moro iwo'my'ma aja'ta, moro je'tun pe aja'ta, moro yja'wangon kari'na aru'katopo ta aja'ta ajepanopy'pa na'na kynainen?’ ");
INSERT INTO car_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Irombo mo'ko poto'su Jopoto kyneju'ta'ton. Kyngatan: ‘Ita'ro pore, pa'poro mo'ko ko'waronombo 'wa ro rypo anikapy'torymbo oty Y'wano me enapa anikapy'pa tywaije mandon.’ ");
INSERT INTO car_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Mo'karon ro moro i'matypyn roten ata'karykano taka kyny'ta'ton. Mo'karon tamamboramon te moro i'matypyn roten amano taka kyny'ta'ton.” ");
INSERT INTO car_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Pa'poro morokon otykon ekarity'ma'po mero, Jesus wyka'po mo'karon tynemeparykon 'wa: ");
INSERT INTO car_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Muku'saton waty oko kurita noro mo'ko eratonomapotopombo onory ewa'mary wopyry wairy. Irombo mo'ko kari'na ymuru ekaramata'ton wakapu poko ipokato'me.” ");
INSERT INTO car_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Moro jako ro mo'karon Tamusi pokonokon jopotorykon wota'nanopy'san mo'karon uwapoto'san maro mo'ko Kajafas tatynen Tamusi pokonokon jopotory auty ta. ");
INSERT INTO car_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Taurangon epopo'san i'waine amy amepo maro Jesus apyito'me ty'waine, iwopoto'me. ");
INSERT INTO car_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ika'san te: “Mo'ko eratonomapotopombo onory ewa'mary ta kapyn apyiry ky'waine man. Ijako irombo mo'karon kari'na kywo'mata'ton.” ");
INSERT INTO car_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Irombo Betania po mo'ko areky pan Simon auty ta Jesus a'ta, ");
INSERT INTO car_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","amy woryi wopy'po I'wa amy tapenen topu kapy'po patere'membo maro. Ita amy tapenen typoporen mere tatynen karapa kynakon. Irombo upu'po tu'ponaka i'kamy'po i'wa, moro iwendamery jako ro. ");
INSERT INTO car_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Moro ene'po mero mo'karon inemeparykon wore'kosan. Ika'san: “O'tono'me ko moro wara moro karapa akamanon mo'ko? ");
INSERT INTO car_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Tapene rypo ekaramary manombo tywaije man. Irombo moro epe'po yry manombo tywaije man mo'karon ipyrata'non 'wa.” ");
INSERT INTO car_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Moro ukuty'po mero ty'wa, Jesus wyka'po i'waine: “O'tono'me ko mo'ko woryi poko mandon? Moro inikapyry irombo y'wano me irupa man. ");
INSERT INTO car_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mo'karon ipyrata'non irombo kynaijaton roten ajekosaine. Awu te e'i'pa roten waitake ajekosaine. ");
INSERT INTO car_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yja'mun tu'ponaka ero typoporen karapa y'kamyi moro yjunemyry man 'wano me. ");
INSERT INTO car_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ita'ro pore, pa'poro wararo ero nono tu'po moro iru'pyn oka ekari'topo po ro, mo'se woryi nikapy'po ekari'ta'ton enapa, kari'na wonumengato'me ipoko.” ");
INSERT INTO car_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Morombo mero o'win amy Jesus nemepary, mo'ko Judas tatynen wyto'po mo'karon Tamusi pokonokon jopotorykon 'wa. ");
INSERT INTO car_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ika'po i'waine: “Oty yry 'se ko mandon moro y'wa ajainakaine Jesus yry epety me?” Irombo o'win-kari'na itu'ponaka ainapatoro amu'nymbo pyrata ke epema'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Morombo mero amy oma upiry a'mo'po i'wa, ainakaine Jesus yto'me. ");
INSERT INTO car_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Moro koromono uwaputa'non perere ewa'matopo kurita mo'karon Jesus nemeparykon wopy'san i'wa aturupo: “Oje ko na'na 'wa mo'ko eratonomapotopombo y'mo'kary 'se man, onoto'me o'wa?” ");
INSERT INTO car_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ika'po: “I'tandoko moro poto 'su aitopo taka inoropan kari'na 'wa. Irombo kaiko me i'wa: Mo'ko amepanen kynganon: ‘Tyse waty terapa man moro ajekosa mo'karon ynemeparykon maro y'wa mo'ko eratonomapotopombo onory man.’ ” ");
INSERT INTO car_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Irombo mo'karon Jesus nemeparykon we'i'san ika'po wara ro ty'waine. Mo'ko eratonomapotopombo y'mo'ka'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iko'mamy'po mero, tari'po Jesus arepa kynendamejakon mo'karon ainapatoro itu'ponaka okonokon tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Moro tywendamerykon jako ro ika'po: “Ita'ro pore, o'win amy ara'nanokon yjekaramatan.” ");
INSERT INTO car_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Irombo pa'poro tywe'i'san mero kata'mato imero mo'karon inemeparykon wyka'san I'wa: “Awu kapyn waty, Jopoto?” ");
INSERT INTO car_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ejuku'san i'wa: “Mo'ko ywara enapa moro arepa a'pitopo taka tarepary a'pijan inoro yjekaramatan. ");
INSERT INTO car_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Kyny'san ro mo'ko kari'na ymuru, typoko imero'po wara ro. Mo'ko kari'na ymuru ekaramanen te janon kynotamotan. Iru'pa nairy ero nono tu'ponaka opy'pa iwe'i'pomboto.” ");
INSERT INTO car_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Irombo mo'ko ekaramanen man Judas woturupo'po: “Awu kapyn waty, yjemepanen?” Ika'po i'wa: “Aseke inoro me mokari'sa.” ");
INSERT INTO car_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Irombo moro arepa enapyry jako ro, Jesus 'wa amy perere anumy'po. Tamusi ety awonga'po mero ipoko, i'sakapoty'po i'wa. Irombo ekamy'po i'wa tynemeparykon 'wa. Ika'po: “Apyitoko! Ena'toko! Yja'mun ero man.” ");
INSERT INTO car_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Irombo amy sapera anumy'po i'wa. Tamusi ety awonga'po mero moro sapera tano tanymy poko, yry'po i'wa i'waine. Ika'po i'waine: “Pa'poro amy enytoko. ");
INSERT INTO car_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ymynuru ero man. Moro ro kyne'kanjan moro Tamusi wykatopombo pori'tomanen me. Pyimano kari'na upu'san me kyne'kanjan, ija'wanykonymbo kato'me. ");
INSERT INTO car_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wykaje te o'waine, erombo poro winu anenyry'pa noro rapa waitake. Moro yjumy nundymary ta te asery me senytake rapa amaroine.” ");
INSERT INTO car_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Irombo Tamusi ety awongatopo wareka'ma'san mero, ito'san moro oleif paty wypy 'wa. ");
INSERT INTO car_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Irombo Jesus wyka'po i'waine: “Ero koko pa'poro ywyino matu'mata'ton. Tymero irombo man: “Mo'ko kapara enenen siwotake. Mo'karon kapara apyimy kynotaripa'tan.” ");
INSERT INTO car_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Iromby'san wyino yjawomy'po mero te, Galilea 'wa wy'take ajuwapoine.” ");
INSERT INTO car_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrus 'wa te ejuku'po: “Pa'poro kari'na ro rypo awyino kynotu'mata'ton. Awu kapyn te.” ");
INSERT INTO car_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesus wyka'po te i'wa: “Ita'ro pore, ero koko korotoko ko'tary uwaporo, oruwamboto yjukuty'pa awairy mekari'take.” ");
INSERT INTO car_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrus wyka'po I'wa: “Yrombyry man jako ro rypo amaro, ajukuty'pa ywairy anekarity'pa waitake!” Moro wara enapa pa'poro mo'karon a'sakarykon wyka'san. ");
INSERT INTO car_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Irombo Jesus wyto'po imaroine amy Getsemane tatynen wonatopo paty 'wa. Irombo ika'po mo'karon tynemeparykon 'wa: “Ero po atandy'motoko. Tamusi 'wa aurana wy'sa.” ");
INSERT INTO car_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Petrus, mo'karon okonokon Sebedeus ymurukon aro'san i'wa tymaro. Kata'mato imero iwe'i'po. Anari 'wa imero apo'i'po. ");
INSERT INTO car_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Irombo ika'po i'waine: “Moro kata'mato ywairy je'tun ywory 'se imero man. Ero po ro aitoko. Ywara enapa koro tuwaro aitoko me.” ");
INSERT INTO car_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Irombo a'si 'ko noro ito'po. Tombata'po iwoma'po. Tamusi 'wa iwoturupo'po: “Papa, yjuwaporimakary taro ta'ta, ero je'tun pan sapera yjuwaporimakan. Ynisanory kapyn te no'ka'nen. Anisanory te.” ");
INSERT INTO car_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Irombo iwopy'po rapa mo'karon tynemeparykon 'wa. Iwo'nykyrykonymbo epory'po i'wa. Irombo Petrus 'wa ika'po: “Ko'i roten pairo iro ke nuro awairykon mupijaton? ");
INSERT INTO car_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tuwaro aitoko. Tamusi 'wa aturupotoko, moro aju'kuto'kon 'wa ajapyirykon pona. Mo'ko a'kanano ro rypo oty kapyry 'se man. Moro ja'munano te ru'me man.” ");
INSERT INTO car_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Irombo ijokonory me ito'po rapa. Tamusi 'wa aurana'po. Ika'po: “Papa, yjuwaporimakary taro e'i'pa ero je'tun pan sapera a'ta, enyry man a'ta y'wa, oro moro anisanory no'ka'nen.” ");
INSERT INTO car_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Irombo tywerama'po mero rapa, iwo'nykyrykonymbo epory'po rapa i'wa. Epirykon irombo imero tawosinapo'se kynatokon. ");
INSERT INTO car_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ino'san i'wa. Ito'po rapa Tamusi 'wa aurana ijoruwanory me. Koromo taurana'po wara ro rapa aurana'po. ");
INSERT INTO car_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Irombo mo'karon tynemeparykon 'wa tywopy'po mero rapa, ika'po i'waine: “Erome te o'ny'toko. Otare'matoko. Moro jururu irombo nitundai terapa. Mo'ko kari'na ymuru yjaton terapa mo'karon tyja'wangamon ainaka. ");
INSERT INTO car_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ajawondoko. Ka'makon. Mo'ko yjekaramanen irombo nitundai terapa.” ");
INSERT INTO car_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Moro Jesus auranary jako noro, typo roten mo'ko o'win amy inemepary Judas tunda'po. Imaro moky imero kari'na kynatokon, supara maro, putu maro. Mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa enapa tomo'se kynatokon. ");
INSERT INTO car_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Mo'ko ekaramanen 'wa te enepoto'man takari'se kynakon i'waine. Tyka kynakon: “Mo'ko siposimatake inoro, inoro ro mo'ko man. Apyitoko me.” ");
INSERT INTO car_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Irombo o'win wytory Jesus 'wa ito'po. Ika'po: “Mondo ro rypo man, yjemepanen?” Irombo iposima'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesus wyka'po te i'wa: “Yjakono, moro ipoko awo'topombo ika'ko imero!” Irombo mero iwopy'san. Jesus apo'i'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Irombo wyino o'win amy Jesus ekosa aitoto 'wa tysuparary so'ka'po ije'ny wyino. Irombo mo'ko Tamusi pokonokon jopotory pyitory panaka'po i'wa atone. ");
INSERT INTO car_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesus wyka'po te i'wa: “Moro ije'ny taka rapa moro asuparary yko. Pa'poro mo'karon supara apyinamon wotan irombo supara ro. ");
INSERT INTO car_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","O'win wytory ka'tu ainapatoro itu'ponaka oko ko'po tapojongon apyimykon anemoky'pa yjumy wairy man mekano'san, yjepano'to'me i'wa ywoturupo'poto? ");
INSERT INTO car_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Moro wara ywe'i'poto te, morokon ero wara oty wairy man mero'san tywo'kapyry upiry.” ");
INSERT INTO car_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Moro jako ro mo'karon kari'na apyimykon 'wa Jesus wyka'po: “Amy tokonen manaman apyiry 'sangon wara imero supara maro, putu maro tywo'se mandon yjapyije. Kurita wara ro ajekosaine kari'na semepakon tandy'po moro Tamusi auty ta. Moro jako te yjapo'i'pa maisen. ");
INSERT INTO car_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pa'poro te erokon no'kapyi mo'karon Tamusi auran uku'ponamonymbo nimero'san wo'ka'to'me.” Irombo pa'poro mo'karon inemeparykon 'wa o'win upu'po ino'po. Pa'poro eka'numy'ma'san. ");
INSERT INTO car_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Irombo Jesus aro'po mo'karon apyinamonymbo 'wa mo'ko Tamusi pokonokon jopotory Kajafas auty 'wa. Moro po ro mo'karon Tamusi karetary uku'namon, mo'karon uwapoto'san enapa tywota'nano'se kynatokon. ");
INSERT INTO car_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus ko'wu tyse terapa kyny'sakon Jesus wena'po ta, mo'ko Tamusi pokonokon jopotory auty 'wa ro imero. Moro ipyrorory taka tywo'my'po mero mo'karon oranano ekosa iwotandy'mo'po, otypan oty wo'kapyry eneto'me. ");
INSERT INTO car_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mo'karon Tamusi pokonokon jopotorykon, pa'poro mo'karon Simosu jopotorykon enapa amy Jesus emendoto'man onapi upijatokon, iwopoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amy iwopoto'man anepory'pa te iwe'i'san, pyime rypo mo'karon typo roten Jesus emendo o'tonon wairy se'me. ");
INSERT INTO car_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Irombo ro me ro ko'wu oko amykon wopy'san uwaponaka. Ika'san: “Mo'se nykai: ‘Ero Tamusi auty aka'poto y'wa, oruwa kurita amy'mary taro rapa wa.’ ” ");
INSERT INTO car_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Irombo mo'ko Tamusi pokonokon jopotory awomy'po. Ika'po Jesus 'wa: “O'to yka'pa man moro i'waine ajemendotopo poko?” ");
INSERT INTO car_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","O'to yka'pa te Jesus we'i'po. Irombo mo'ko Tamusi pokonokon jopotory wyka'po I'wa: “Mo'ko nurono Tamusi embata waturupoja o'wa, mo'ko Mesias, mo'ko Tamusi ymuru amoro man.” ");
INSERT INTO car_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesus wyka'po i'wa: “Aseke inoro me kakari'sa. Wykaje te o'wa: erombo wyino ro mo'ko kari'na ymuru tandy'po meneta'ton mo'ko pari'pyn apo'tun wyino. Irombo kapurutu tu'po iwopyry meneta'ton.” ");
INSERT INTO car_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Irombo mo'ko Tamusi pokonokon jopotory 'wa moro tywo'mymbo seka'po. Ika'po: “Tamusi ejui! O'tono'me noro ko emendonamon me amykon kysupijaton? Tamusi ety jamikary i'wa metaton. One wara ko monumengaton ipoko?” ");
INSERT INTO car_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ika'san eju'to'me: “Iwory man.” ");
INSERT INTO car_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Irombo eta'tapoty'san embatary tu'ponaka. Tainarykon amo'mere'ko'san ke iwo'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Amykonymbo 'wa embata'mo'po. Ika'san: “Noky 'wa awo'po ekari'ko na'na 'wa Kristus, Tamusi auran uku'ponen me aja'ta!” ");
INSERT INTO car_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Moro jako Petrus kurando kynakon mo'ko Tamusi pokonokon jopotory auty pyrorory ta. Irombo amy amyijanano wopy'po i'wa. Ika'po: “Amoro enapa mo'ko Galilea pono Jesus maro makon.” ");
INSERT INTO car_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pa'poro mo'karon moro po aitonon netary me te Petrus wyka'po: “Uwa! O'to awykary anukuty'pa pairo wa.” ");
INSERT INTO car_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Irombo moro o'mytopo 'wa ito'poto, amy terapa amyijanano 'wa ene'po. Irombo mo'karon moro po o'po'tonon 'wa ika'po: “Mo'ko Nasaret pono Jesus maro mose wokyry kynakon.” ");
INSERT INTO car_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrus 'wa mo'ko enapitary ekarity'po rapa, Tamusi ety ejatory ta: “Mo'ko wokyry anukuty'pa wa.” ");
INSERT INTO car_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Irombo a'si 'ko a'si 'ko mo'karon moro po o'po'tonon wopy'san Petrus 'wa. Ika'san i'wa: “Iporo ro amoro enapa amy a'sakarykon me mana. Ajauran emery irombo ajuku'pojan.” ");
INSERT INTO car_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Irombo Petrus 'wa yja'wan me imero toruwary amo'po. Tamusi ety ejatory ta ika'po: “Tamusi yjuta'kan mo'ko wokyry ukutyry jako y'wa!” Irombo o'win wytory amy korotoko ko'ta'po. ");
INSERT INTO car_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Irombo Petrus wetuwaro'ma'po rapa moro Jesus wyka'po poko: “Mo'ko korotoko ko'tary uwaporo oruwamboto yjukuty'pa awairy mekari'take.” Irombo kurandonaka ito'po. Je'tun pe imero iwotamo'po. ");
INSERT INTO car_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Emamy'po mero pa'poro mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa enapa taurangon epopo'san Jesus wopoto'me. ");
INSERT INTO car_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Irombo imy'po i'waine. Aro'po i'waine. Mo'ko Rome wyinono jopoto Pilatus ainaka terapa yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ipoko moro a'wembono auranano yry'po ene'po mero, mo'ko ekaramanenymbo Judas 'wa moro o'to tywe'i'po je'tuma'po. Morokon o'win-kari'na itu'ponaka ainapatoro amu'nymbo pyrata aro rapa ito'po mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ika'po: “Yja'wan oty tyka'se y'wa man. Amy yja'wan oty anikapypynymbo takarama y'wa man.” Ika'san te: “Moro poko o'to tykary upijan na'na. Amoro terapa atuku'ko.” ");
INSERT INTO car_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Moro Tamusi auty taka morokon amu'nykonymbo pyrata papy'po i'wa. Irombo ito'po moro wyino. Irombo iwona'sawyry'ka'po. ");
INSERT INTO car_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mo'karon Tamusi pokonokon jopotorykon 'wa morokon amu'nykonymbo pyrata amo'iky'san. Ika'san: “Erokon yry kapyn ky'waine man moro Tamusi 'wa tymy je'ny taka. Mynu epetymbo irombo moro man.” ");
INSERT INTO car_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Taurangon epopo'san i'waine mo'ko ori'no ka'nen yinonorymbo epeka'to'me ty'waine ike, mo'karon tysenokon aito'kon wyino opy'san unendo'ko'me. ");
INSERT INTO car_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Iro ke ro erome noro moro nono ety me man ‘Mynu pan nono’. ");
INSERT INTO car_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Iwara ro ero Tamusi auran uku'ponenymbo Jeremia nekarity'po wo'kapy'po: Moro o'win-kari'na itu'ponaka ainapatoro amu'nymbo pyrata tapije i'waine man. Moro wara ro mo'karon Israel pajanymbo 'wa epety tajato roten man. ");
INSERT INTO car_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Mo'ko ori'no ka'nen mainarymbo poko moro pyrata tyje i'waine man, Tamusi wyka'po wara ro. ");
INSERT INTO car_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesus aro'po te i'waine mo'ko Rome wyinono jopoto po'ponaka. Mo'ko woturupo'po ro i'wa: “Mo'karon Simosu Jopotory amoro man?” Jesus wyka'po: “Aseke inoro me kajatoja.” ");
INSERT INTO car_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa enapa tamendory jako o'to yka'pa iwe'i'po. ");
INSERT INTO car_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Morombo mero Pilatus woturupo'po I'wa: “Aneta'pa man o'toro 'ko waty ajemendory i'waine?” ");
INSERT INTO car_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amy pairo oty poko te anejuku'pa Jesus we'i'po. Mo'ko Rome wyinono jopoto wonumenga'po imero. ");
INSERT INTO car_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Amy oty ewamary wararo te moro yja'wangon kari'na aru'katopo wyinombo o'win amy mo'karon kari'na nisanorymbo kapotopombo mo'ko jopoto 'wa kynakon. ");
INSERT INTO car_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Moro jako ro amy yja'wan me ekary aitoto Barabas tatynen wokyry kynakon moro yja'wangon kari'na aru'katopo ta. ");
INSERT INTO car_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Moro iwota'nanopy'san po ro mo'ko Pilatus wyka'po i'waine: “Noky nondary 'se ko mandon y'wa: mo'ko Barabas, mo'ko Mesias me inejatorykon Jesus te ka'tu?” ");
INSERT INTO car_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus irombo kynuku'sakon i'se'pa tywairykon ke Jesus yry'po i'waine tainaka. ");
INSERT INTO car_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Moro jopoto apo'ny tu'po tandy'po a'ta ro, ipyty 'wa tauranymbo aropo'po i'wa: “Mo'ko tamamboren wokyry poko koro kyte'i. Ero koko irombo ywoneto poto me imero wata'karykai upu'po me.” ");
INSERT INTO car_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mo'karon Tamusi pokonokon jopotorykon 'wa te, mo'karon uwapoto'san 'wa enapa mo'karon ata'nanopy'san apokuma'san, iwoturupoto'ko'me mo'ko Barabas nondato'me i'wa, mo'ko Jesus wopoto'me te i'wa. ");
INSERT INTO car_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Mo'ko jopoto wyka'po: “Nokypan nondary 'se ko mandon y'wa o'waine?” Ika'san: “Barabas.” ");
INSERT INTO car_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatus wyka'po i'waine: “O'to ko iro ke mo'ko Mesias me inejatorykon Jesus sytan?” Pa'poro ika'san: “Ipokary man wakapu poko.” ");
INSERT INTO car_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ika'po: “Otypan yja'wan oty 'ne ko iro ke tyka'se i'wa nan?” Pari'pe 'ne ka'tu rapa iko'tapoty'san: “Ipokary man wakapu poko.” ");
INSERT INTO car_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilatus 'wa aronge roten moro o'to tywairy ene'po. Asemenoro te mo'karon kari'na kynokopatokon. Irombo tuna apo'i'po i'wa. Tainary ku'mity'po i'wa, embataine ro. Ika'po: “Yju'ta kapyn man moro imynuru we'kamyry. Amyjaron terapa aseke atuku'toko.” ");
INSERT INTO car_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Irombo pa'poro mo'karon kari'na 'wa ejuku'po: “Moro imynuru we'kamyry na'na u'ta nainen, na'na y'makon u'ta enapa.” ");
INSERT INTO car_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Irombo Barabas kapo'po i'wa ekatakaine. Jesus yry'po te i'wa mo'karon warinu pokonokon ainaka wakapu poko ipokato'me. Mene 'ne ka'tu ipoky'mapo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Irombo mo'ko Rome wyinono jopoto pyitorykon 'wa Jesus aro'po moro a'wembono auranano ytopo auto taka. Pa'poro mo'karon ta'sakarykon ko'ma'san i'waine. ");
INSERT INTO car_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iwo'mynga'po mero ty'waine, amy tapiren kamisa ke terapa iwo'myndo'po i'waine. ");
INSERT INTO car_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","U'mariry me amy sipatamu waton momy'po i'waine. Irombo upu'po tu'ponaka yry'po i'waine. Amy waruma waton ke aposenyndo'po i'waine apo'tun wyino. Irombo ipo'ponaka iwokunama'san. Aki'ma'po i'waine. Ika'san: “Na'na te kore awopy'po ewa'maje, Simosu Jopotory!” ");
INSERT INTO car_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Irombo itu'ponaka eta'tapoty'san. Moro waruma waton pina'po i'waine ainary wyino. Ike ro iwo'po i'waine upu'po po. ");
INSERT INTO car_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ipoko tywosaijamba'ma'san mero, moro ty'waine iwo'myndotopombo so'ka'po rapa i'waine. Moro iwo'my ke rapa iwo'myndo'po i'waine. Irombo aro'po i'waine, ipokato'me wakapu poko. ");
INSERT INTO car_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Moro tytorykon jako ro, amy Sirene pono, Simon tatynen wokyry epory'po i'waine. Mo'ko wyry'ka'po ro i'waine moro Jesus pokatopo man wakapu aroto'me i'wa. ");
INSERT INTO car_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Irombo itunda'san moro Golgota tatynen aitopo 'wa. Moro tauro'po man ‘u'je'pombo waitopo’. ");
INSERT INTO car_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Irombo amy itun pan oty maro i'kaima'po winu ke upa'po i'waine. Apo'po mero te enyry 'se'pa iwe'i'po. ");
INSERT INTO car_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Moro wakapu poko ipoka'po wyino ty'waine, asekaro morokon iwo'mykonymbo ekamy'san i'waine tymeramon tapusikiri emapoty'san wyino ty'waine. ");
INSERT INTO car_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tandy'po kynerandojatokon moro po. ");
INSERT INTO car_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ero wara moro emendotopo mero'po yry'po i'waine epo: MO'KARON SIMOSU JOPOTORY JESUS MO'SE MAN ");
INSERT INTO car_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Imaro ro oko tokonamon manamangon poka'san i'waine, o'win amy apo'tun wyino, o'win amy apoje wyino. ");
INSERT INTO car_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Mo'karon moro pato ytotonon imero tupu'san sekesekematokon. Jesus ejujatokon. ");
INSERT INTO car_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kyngatokon: “Amoro moro Tamusi auty akanen, irombo oruwa kurita amy'manen rapa! Aseke opano'ko, Tamusi ymuru me aja'ta. O'kako moro apokatopombo wyino.” ");
INSERT INTO car_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Iwara enapa mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon, mo'karon uwapoto'san enapa Jesus ere'no'satokon. Kyngatokon: ");
INSERT INTO car_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Amykon terapa tapano'se I'wa mandon. Aseke te tywopanopyry upijan. Mo'karon Israel pajanymbo Jopotory mo'ko man. Oro erome moro typokatopombo wyino nony'ton, kysamyikato'se me. ");
INSERT INTO car_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tamusi amyikanon waty? Oro mo'ko ro erome nepano'nen, i'se ta'ta. ‘Tamusi ymuru awu wa,’ tyka irombo man.” ");
INSERT INTO car_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iwara enapa mo'karon imaro ipoka'san manamangon kynejujatokon. ");
INSERT INTO car_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Kurita 'ne 'ne iwe'i'po mero, pa'poro moro nono ewa'rumamy'po oruwa juru taronaka. ");
INSERT INTO car_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Oruwa juru iwe'i'po mero, mo'ja imero Jesus ko'ta'po. Ika'po: “Eli, eli, lama sabaktani?” Moro tauro'po man: ‘Ytamusiry, ytamusiry, o'tono'me ko o'win upu'po kynoi?’ ");
INSERT INTO car_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Irombo amykon moro po o'po'tonon 'wa moro auran eta'po. Ika'san: “Elia ko'manon.” ");
INSERT INTO car_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","O'win wytory amy 'wa amy tymi'mi'ken oty u'mu'ka'po tyjasakoren winu taka. Amy waruma waton pokonaka yry'po i'wa, Jesus upato'me ty'wa ike. ");
INSERT INTO car_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amykonymbo wyka'san te: “'Nare Elia wopyry kysenesen epano'se.” ");
INSERT INTO car_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mo'ja 'ne ka'tu rapa Jesus ko'ta'po. Irombo iworemakepy'po. ");
INSERT INTO car_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Morombo mero moro Tamusi auty ta isererema'po kamisa wo'seka'po ase'ra, kawo wyinombo ro po'ponaka. Nono wetytyka'po. Topukon we'mopoty'san. ");
INSERT INTO car_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Morokon tu'munanokon wotapurumakapoty'san. Pyime Tamusi wyinonokonymbo iromby'san awomy'san rapa. ");
INSERT INTO car_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Morokon tytu'mungonymbo wyino ito'san. Irombo moro Jesus awomy'po wyino moro Tamusi wyinono aitopo 'wa ito'san. Moro po ro pyime kari'na 'wa iwosenepo'san. ");
INSERT INTO car_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mo'karon Jesus erandonamon warinu pokonokon 'wa mo'ko tyjopotorykon maro moro nono wetytykary apo'po. Morokon otykon wo'kapyry ene'po mero ty'waine, iwety'ka'san imero. Ika'san: “Iporo ro kore Tamusi ymuru mo'se tywaije na.” ");
INSERT INTO car_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Irombo tyse terapa pyime woryijan kyno'po'satokon. Galilea wyino Jesus tywekena i'waine kynakon. Enenamonymbo mo'karon kynatokon. ");
INSERT INTO car_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Imaroine kynatokon mo'ko Magdala pono Maria, mo'ko Maria mo'ko Jakobus sano me, Josef sano me enapa kynakon inoro, mo'ko Sebedeus ymurukon sano enapa. ");
INSERT INTO car_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Irombo koine 'ne amy Arimatea pono typyrataken Josef tatynen wokyry wopy'po. Jesus nemepary me e'i'po enapa mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilatus 'wa ito'po Jesus ekepy'po poko aturupo. Irombo Pilatus 'wa ypo'po ainaka. ");
INSERT INTO car_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Irombo Josef 'wa mo'ko ekepy'po pina'po. Amy asery tamu'nen ty'meijen kamisa ke ijondo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Irombo moro asery tunendopo man me tynatokapo'po topu taka yry'po i'wa. Amy poto 'su topu uringapoty'po i'wa moro atunendopo penary apu'toto'me. Irombo ito'po. ");
INSERT INTO car_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Moro atunendopo po ro tandy'po kynatokon mo'ko Magdala pono Maria, mo'ko amy terapa Maria maro. ");
INSERT INTO car_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Irombo koro'po, moro otare'matopo kurita mo'karon Tamusi pokonokon jopotorykon wyto'san mo'karon Farise maro Pilatus po'ponaka. ");
INSERT INTO car_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ika'san: “Jopoto, nuro noro ta'ta ‘Oruwa kurita pa'po me yjawondake rapa’ mo'ko tonapiren wyka'po poko na'na netuwaro'mai rapa. ");
INSERT INTO car_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Moro ijoruwanory kurita taronaka iro ke moro atunendopo erandopory 'se'pa man? Ijako irombo mo'karon inemeparykon moro ija'munumbo mona'to kyno'ta'ton. Mo'karon kari'na 'wa kyngata'ton: ‘Mo'karon iromby'san wyino nawomyi rapa.’ Irombo moro wena'po tano onapi poto me 'ne ka'tu rapa kynaitan moro koromono ko'po.” ");
INSERT INTO car_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatus wyka'po i'waine: “Mojan amykon oranano. Anisanorykon wara ro irupyn me moro atunendopo erandopodoko.” ");
INSERT INTO car_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Iwara te ito'san. Mo'karon oranano 'wa moro atunendopo erandopo'po i'waine. Moro aputy topu poko amy oty yry'po i'waine aky'katome isakamary pona. ");
INSERT INTO car_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Moro otare'matopo kurita pa'po me, emamyry jako, mo'ko Magdala pono Maria wyto'po mo'ko amy terapa Maria maro moro atunendopo ene. ");
INSERT INTO car_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Typo roten amy tytyty tam'po'kory wopy'po. Amy Tamusi apojon wony'to'po irombo kapu wyino. Moro atunendopo 'wa iwopy'po. Moro atunendopo penary wyino moro aputy topu uringapoty'po i'wa. Itu'po ro iwotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kapekape wara imero kynakon. Moro iwo'my tamu'ne kynakon mauru wara. ");
INSERT INTO car_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Mo'karon atunendopo erangon enariry wetytyka'san imero. Iromby'san wara iwo'papy'san. ");
INSERT INTO car_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Mo'ko Tamusi apojon wyka'po te mo'karon woryijan 'wa: “Kytety'katon amyjaron. Suku'sa irombo mo'ko ipoka'po Jesus upiry o'waine. ");
INSERT INTO car_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ero po waty man. Tawonje rapa te man, tyka'po wara ro. O'toko 'ne. Enetoko, se, ero ytopombo. ");
INSERT INTO car_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ko'i mo'karon iromby'san wyino awomy'po ekari'tandoko mo'karon inemeparykonymbo 'wa. Ajuwapoine kyny'tan Galilea 'wa. Moro po ro meneta'ton. Moro roten sekari'sa o'waine.” ");
INSERT INTO car_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Irombo o'win wytory ito'san moro atunendopo wyino, tanarike, tawa'pore imero enapa te. Mo'karon inemeparykonymbo 'wa moro oka aro eka'numy'san. ");
INSERT INTO car_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Moro jako ro Jesus 'wa mo'karon woryijan epory'san. Ika'po i'waine: “Iru'pa ro rypo mandon?” Iwopy'san i'wa. Ipupuru apo'i'po i'waine. Iwokunama'san ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Irombo Jesus wyka'po i'waine: “Kytety'katon. Mo'karon yja'sakarykon 'wa kaitandoko Galilea 'wa itoto'ko'me. Moro po ro yjeneta'ton.” ");
INSERT INTO car_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Mo'karon woryijan wytory jako noro, amykon moro po e'i'san oranano wyto'san Jerusalem 'wa, pa'poro morokon o'kapy'san otykon ekari'se mo'karon Tamusi pokonokon jopotorykon 'wa. ");
INSERT INTO car_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mo'karon uwapoto'san maro tywota'nanopy'san mero, morokon taurangon epopo'san i'waine. Poto me mo'karon warinu pokonokon ainary'to'san i'waine pyrata ke. ");
INSERT INTO car_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ika'san i'waine: “Koko awo'nykyrykon jako imona'to mo'karon inemeparykonymbo wopy'san ekari'toko me. ");
INSERT INTO car_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Mo'ko Rome wyinono jopoto 'wa eta'poto, na'na kynerupatan o'to ajyry'paine iwaito'me.” ");
INSERT INTO car_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Irombo moro pyrata apo'i'po i'waine. Moro ty'waine ika'san wara ro iwe'i'san. Moro auranano wotaripapy'po ro wararo mo'karon Simosu ra'na. Erome noro kynotaripa'san. ");
INSERT INTO car_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Irombo mo'karon ainapatoro itu'ponaka o'win Jesus nemeparykonymbo wyto'san Galilea 'wa, moro Jesus 'wa torupato'konymbo wypy 'wa. ");
INSERT INTO car_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesus ene'po mero ty'waine, ipo'ponaka iwokunama'san. Amykonymbo we'i'san te anamyikaporo'pa. ");
INSERT INTO car_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesus wopy'po i'waine. Ika'po: “Pa'poro oty yjainaka tyje man kapu ta, nono tu'po enapa. ");
INSERT INTO car_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Pa'poro kari'na ytandoko iro ke nemeparykon me. Etykatoko me mo'ko jumynano ety ta, mo'ko ymunano ety ta, mo'ko Tamusi a'kary ety ta enapa. Emepatoko me moro o'to o'waine ywyka'po wara ro iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Enetoko. Awu kurita wararo ajekosaine waitake, nono y'matyry 'wa ro.”");
INSERT INTO car_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesus Kristus, mo'ko Tamusi ymuru me man inoro, ekapory wota'mory. ");
INSERT INTO car_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ero wara morokon Tamusi auran uku'ponenymbo Jesaja wykato'konymbo mero'san man: Eneko, yjapojon semo'sa ajuwapo. Mo'ko ro ajemary ka'tan. ");
INSERT INTO car_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Moro iponomyn wo'i ta ero wara amy ko'tatoto auran kynotanon: “Mo'ko Jopoto emary ika'toko. Sapatoro morokon emary ytoko.” ");
INSERT INTO car_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Moro imero'po wararo moro iponomyn wo'i ta mo'ko Johanes waitopombo kynakon kari'na etykary poko, ero ekarory ta: “Ajemamyrykon u'matoko! Asetykapotoko! Irombo Tamusi oja'wanykonymbo katan.” ");
INSERT INTO car_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Pa'poro mo'karon Judea ponokon, pa'poro mo'karon Jerusalem ponokon wo'to'konymbo kynakon i'wa. Iwosetykapoto'konymbo kynakon moro Jordan tunary taka. Moro tatykarykon jako ro pa'poro yja'wan me tywe'i'san ekari'topombo i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Johanes wo'my me kameri ypotymbo kapy'po kynakon. Ekundy me tonomy pi'pombo kapy'po kynakon. Kasapa erepary me kynakon wano maro. ");
INSERT INTO car_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ero oka ekari'sakon: “Mo'ko yko'po pana'pe man inoro kyno'san ywena'po ta. Nonsume isapatory etandy ymbokary pairo supija. ");
INSERT INTO car_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Awu tuna ke katykaton. Mo'ko te Tamusi a'kary ke ajetykata'ton.” ");
INSERT INTO car_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Moro jako ro Jesus wopy'po Nasaret wyino. Nasaret Galilea ta man. Irombo Johanes 'wa etyka'po moro Jordan taka. ");
INSERT INTO car_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Irombo moro tuna wyino tu'tary akono mero, kapukon wendakary ene'po i'wa. Mo'ko Tamusi a'kary wony'tory ene'po i'wa amy akukuwa wara tytu'ponaka. ");
INSERT INTO car_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Irombo kapukon wyino amy auranano wota'po: “Amoro, mo'ko nipynen ymuru amoro mana. Amoro ro yturu'po ewa'pory me mana.” ");
INSERT INTO car_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Irombo o'win wytory Tamusi a'kary 'wa aro'po moro iponomyn wo'i taka. ");
INSERT INTO car_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Moro po ro oko-kari'na kurita iwe'i'po mo'ko Satan 'wa tu'kuru ta. Tokonamon no'kan ra'na kynakon. Tamusi apojongon 'wa te epanopy'po. ");
INSERT INTO car_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yja'wangon kari'na aru'katopo taka Johanes aru'kapo wyino i'waine, Jesus wyto'po Galilea 'wa. Mo'ko Tamusi ekapory ekarory arojakon. ");
INSERT INTO car_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ero wara kyngakon: “Iporo terapa man. Moro Tamusi nundymary tyse waty terapa man. Ajemamyrykon u'matoko. Moro iru'pyn oka amyikatoko.” ");
INSERT INTO car_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Irombo moro Galilea tano tuna juwembory esi'wo tytory jako, Simon ene'po i'wa, mo'ko ipiry Andreas maro. Woto pokonokon mo'karon kynatokon. Moro tuna juwembory ta sipi pa'satokon. ");
INSERT INTO car_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Irombo Jesus wyka'po i'waine: “O'toko ywena'po ta. Kari'na pokonokon me terapa kyta'ton.” ");
INSERT INTO car_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Irombo o'win wytory morokon tysipirykon nonda'san i'waine. Jesus wena'po ta terapa ito'san. ");
INSERT INTO car_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Irombo a'si 'ko rapa tyto'po mero, mo'ko Sebedeus ymuru Jakobus ene'po i'wa, mo'ko ipiry Johanes maro. Kurijara ta morokon tysipirykon ato'satokon. ");
INSERT INTO car_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Irombo o'win wytory iko'ma'san i'wa. Moro kurijara ta ro mo'ko tyjumykon Sebedeus no'po i'waine, mo'karon ipyitorykon maro. Jesus wena'po ta terapa ito'san. ");
INSERT INTO car_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Irombo Kafaraum taka ito'san. Irombo moro otare'matopo kurita o'win wytory ito'po moro Simosu wota'nano'to'kon auto taka, emepato'ko'me ty'wa. ");
INSERT INTO car_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mo'ko Jesus auranymbo 'wa poto me mo'karon kari'na enumengapo'san. Amy poto 'su jopoto wara irombo kynemepatokon. Mo'karon Tamusi karetary uku'namon wara kapyn kynemepatokon. ");
INSERT INTO car_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Moro jako 'ne terapa moro iwota'nano'to'kon auto ta amy yja'wan akywano pan kynakon. Mo'ko ko'ta'po ro: ");
INSERT INTO car_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“O'tono'me ko na'na poko man, se, Nasaret pono Jesus? Na'na uta'ka ka'tu mopyi? Suku'sa noky me awairy. Amoro 'ne mo'ko Tamusi wyinono me mana!” ");
INSERT INTO car_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Irombo apo'tun pe Jesus 'wa e'ma'po: “Ity'me aiko! Epa'kako mo'ko wyino!” ");
INSERT INTO car_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Irombo mo'ko yja'wan akywano 'wa mo'ko wokyry apyipo'po wa'jo'pan 'wa. Tyko'ke imero iwepa'ka'po iwyino. ");
INSERT INTO car_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Pa'poro kari'na we'naranga'san imero. Ase'wa kyngatokon: “Oty ko moro nan, se? Otypan asery omepano ko moro nan? Jopoto wara kore imero mo'karon yja'wangon akywano poko napo'tunapo'sa, ran! Irombo kore i'wa nepanamaton, ran!” ");
INSERT INTO car_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Irombo o'win wytory moro inikapy'po ekary wotaripapy'po pa'poro morokon Galilea wyinonokon aito'kon wararo. ");
INSERT INTO car_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Irombo moro Simosu wota'nano'to'kon auto wyino tywepa'ka'san mero, o'win wytory ito'san Simon, Andreas auty 'wa. Jakobus, Johanes wyto'san enapa imaroine. ");
INSERT INTO car_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Mo'ko Simon y'menoty tapapo kynakon, komyinano pe. Irombo o'win wytory Jesus erupa'po i'waine ipoko. ");
INSERT INTO car_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Irombo ito'po mo'ko woryi 'wa. Ainary poko awonga'po i'wa. Irombo moro komyinanombo wyto'po iwyino. Mo'ko woryi 'wa ro upa'san. ");
INSERT INTO car_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Irombo koine, weju wo'myry mero, pa'poro mo'karon mene je'tun pangon, pa'poro mo'karon takyramon enapa enepy'san i'waine I'wa. ");
INSERT INTO car_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pa'poro imero mo'karon aitopo tanokon wota'nanopy'san moro pena po. ");
INSERT INTO car_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Irombo Jesus 'wa pyime ukuty'pa 'ne roten anyky pe aitonon kura'ma'san. Pyime yja'wangon akywano moma'san i'wa mo'karon takyramon wyino. Mo'karon ewa'rumy anauranano'po'pa pairo iwe'i'po, tukutyry ke i'waine. ");
INSERT INTO car_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Emamyry jako, tawa'rume noro a'ta, Jesus awomy'po. Iwepa'ka'po kurandonaka. Amy iponomyn 'wa ito'po. Moro po ro aurana'po Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Irombo Simon 'wa iwekena'po mo'karon tokosanokon kari'na maro. ");
INSERT INTO car_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Irombo epory'po mero ty'waine, ika'san I'wa: “Pa'poro ajupijaton.” ");
INSERT INTO car_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Irombo Jesus wyka'po i'waine: “Ka'makon amykon terapa sengenokon aito'kon 'wa, moro po enapa moro ynenepy'po oka sekarity'se me. Moro me ro irombo tywo'se wa.” ");
INSERT INTO car_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Irombo pa'poro morokon Galilea ponokon Simosu wota'nano'to'kon autokon ta moro tynenepy'po oka ekarity'po i'wa. Mo'karon ewa'rumy moma'san ro rypo i'wa mo'karon takyramon wyino. ");
INSERT INTO car_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Irombo amy areky pan wopy'po I'wa, e'pima. Tokuna'po iwoma'po ipo'ponaka. Irombo ika'po: “I'se aja'ta, ykura'mary taro mana.” ");
INSERT INTO car_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Irombo Jesus 'wa ikotanory ene'po. Tainary tynga'po i'wa, apyito'me. Irombo ika'po: “Ekura'mako rapa iro ke!” ");
INSERT INTO car_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Irombo o'win wytory moro erekyrymbo utapy'po. Iwekura'ma'po rapa. ");
INSERT INTO car_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","E'ma'po mero, o'win wytory emoky'po i'wa tywyino. ");
INSERT INTO car_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ero wara ika'po i'wa: “Tuwaro koro aiko! Amy 'wa pairo koro kysekarityi. Asenepotango te mo'ko Tamusi pokono 'wa. Moro awekura'ma'po poko mo'ko Moses wykatopombo yko me Tamusi 'wa, Tamusi emamina'po amyikato'me i'waine.” ");
INSERT INTO car_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Irombo te moro tyto'po wyino, ekarityry aropoty'po terapa i'wa. Wararo terapa ekaro'po i'wa. Iwara te Jesus 'wa tone me noro amy aitopo taka tytory upi'po. Aito'kon wyino kurando roten terapa kynakon, iponomyn po. Kari'na wararo wyino kynosakon I'wa. ");
INSERT INTO car_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Irombo Jesus tunda'po rapa Kafaraum 'wa. Irombo amykon kurita pa'po me auto po iwairy eta'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Moky rapa imero iwota'nanopy'san. Iwara ro moro pena po taru'se iwe'i'po. Jesus 'wa moro Tamusi auranymbo ekarityry a'mo'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Irombo okupa'en amykon 'wa amy iwajakuta'po enepy'po I'wa. ");
INSERT INTO car_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","I'wa itundanopyry upiry ke ty'waine, taru'se iwairy ke, mo'ko Jesus epo moro auto aputymbo ka'po i'waine. Moro ka'po mero ty'waine, ipaty tu'po ro mo'ko iwajakuta'po eny'topo'po i'waine ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Moro i'waine poto me Tamusi amyikary enery ke ty'wa, Jesus wyka'po mo'ko iwajakuta'po 'wa: “Ito'my, oja'wanykonymbo kyno'kanon.” ");
INSERT INTO car_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Irombo te amykon Tamusi karetary uku'namon moro po tandy'po kynatokon. Mo'karon wyka'san ro tyturu'san ta: ");
INSERT INTO car_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Na! O'to ko mo'se nykanon? Tamusi ety jamikaje kore, ran! Noky aina ko yja'wan me e'i'san kary nan? Tamusi aina roten kapyn?” ");
INSERT INTO car_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Irombo o'win wytory Jesus 'wa moro wara iwonumengarykon ukuty'po. Irombo ika'po i'waine: “O'tono'me ko moro wara mykaton aturu'san ta? ");
INSERT INTO car_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Otypan ko ija roten nan? Awykary mo'se iwajakuta'po 'wa ‘Oja'wanykonymbo kyno'kanon.’? Awykary te ka'tu ‘Ajawongo. Apaty anungo. I'tango!’? ");
INSERT INTO car_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","O'po'toko, muku'to'se me mo'ko kari'na ymuru aina yja'wan me e'i'po kary wairy ero nono tu'po.” Irombo ika'po mo'ko iwajakuta'po 'wa: ");
INSERT INTO car_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Ajawongo amoro. Apaty anungo. I'tango ajauty 'wa.” ");
INSERT INTO car_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Irombo mo'ko iwajakuta'po awomy'po. Typaty anumy'po i'wa. Irombo o'win wytory pa'poro inenerykon mero kurandonaka ito'po. Pa'poro imero enuta'san. Tamusi ety awonga'po i'waine. Ero wara ika'san: “Tywe'i'po poro moropan oty anene'pa na'na man!” ");
INSERT INTO car_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Irombo moro aitopo wyino Jesus wyto'po rapa. Moro tuna juwembory esi'wo ito'po. Moky rapa ekosa iwota'nanopy'san. Emepa'san I'wa. ");
INSERT INTO car_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Irombo tytory jako mo'ko Alfeo ymuru, Levi, ene'po I'wa. Levi tandy'po kynakon mo'ko Rome pono jopoto ekataka pyrata amo'i'topo auto po. Irombo Jesus wyka'po i'wa: “O'ko ywena'po ta.” Irombo Levi awomy'po. Ito'po Jesus wena'po ta. ");
INSERT INTO car_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Amy kurita Levi auty ta Jesus tarije'po kynendamejakon. Pyime Rome pono jopoto ekataka pyrata amo'i'namon, pyime enapa amykon terapa tyja'wangamon tarije'po kynendamejatokon Jesus maro, mo'karon inemeparykon maro enapa. Pyime irombo mo'karon iwena'po ta ytotonon kynatokon. ");
INSERT INTO car_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Irombo mo'karon Farise wyinonokon Tamusi karetary uku'namon 'wa iwendamery ene'po mo'karon tyja'wangamon maro, mo'ko Rome pono jopoto ekataka pyrata amo'i'namon maro enapa. Irombo ika'san mo'karon inemeparykon 'wa: “Na! O'tono'me ko nendamejan mo'karon pyrata amo'i'namon maro, mo'karon tyja'wangamon maro enapa?” ");
INSERT INTO car_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aurangon eta'po mero, Jesus wyka'po i'waine: “Anyky'non tapino'namon anupi'pa mandon. Je'tun pangon te tapino'namon upijaton. Tamamboramon ko'ma opy'pa we'i. Mo'karon tyja'wangamon ko'ma te wopyi.” ");
INSERT INTO car_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","O'wino me mo'karon Johanes nemeparykon, mo'karon Farise nemeparykon enapa kynonematokon. Irombo iwopy'san Jesus 'wa. Ika'san: “O'tono'me ko mo'karon anemeparykon onema'pa nandon, mo'karon Johanes nemeparykon wonemary jako, mo'karon Farise nemeparykon wonemary jako enapa?” ");
INSERT INTO car_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesus wyka'po i'waine: “Mo'karon oko amykon aimytonon ewa'manamon 'kare tywonemarykon taro nandon, mo'ko pytatoto a'ta tokosaine! Tokosaine mo'ko pytatoto a'ta, tywonemarykon upijaton. ");
INSERT INTO car_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amy jako te mo'ko pytatoto pinata'ton iwyinoine. Irombo mero kynonemata'ton. ");
INSERT INTO car_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Amy pairo kari'na amy asery kamisa anatoky'pa man amy penato'po wo'mynanombo poko. Ijako irombo moro asery kamisa atoky'po moro wo'mynanombo tyngatan. Irombo poto me 'ne ka'tu rapa moro iwo'seka'po kynaitan. ");
INSERT INTO car_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Amy pairo kari'na enapa asery winu anije'nyndo'pa man penato'san tonomy pi'sanymbo kapy'san ke. Ijako irombo moro winu morokon tyje'nykonymbo sekatan. Irombo kynotakamatan moro winu. Morokon ije'nykonymbo a'kuru upita'ton noro. Asery winu yry te man asery ije'ny taka.” ");
INSERT INTO car_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","O'wino me moro otare'matopo kurita Jesus kyny'sakon morokon awasi paty ta. Mo'karon inemeparykon 'wa tytorykon ta roten morokon wonatopo epery potyry a'mo'po, ena'to'me ty'waine. ");
INSERT INTO car_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Irombo mo'karon Farise wyka'san I'wa: “Eneko! O'tono'me ko moro otare'matopo kurita tykapymy waty oty ka'saton?” ");
INSERT INTO car_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Irombo ika'po i'waine: “Awe'i'san poro o'to mo'ko David we'i'po anerupa'pa mandon, kumyno ta ta'ta mo'karon ta'sakarykon maro? ");
INSERT INTO car_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Moro Tamusi auty taka tywo'my man, mo'ko Abjatar a'ta mo'karon Tamusi pokonokon jopotory me. Irombo David 'wa morokon Tamusi embata yry'san perere tana'se man. Morokon perere enapyry waty man amy typono roten kari'na 'wa. Mo'karon Tamusi pokonokon 'wa roten te enapyry man. Irombo mo'ko David 'wa mo'karon ta'sakarykon tupa enapa man ike.” ");
INSERT INTO car_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesus wyka'po enapa i'waine: “Moro otare'matopo kurita tyka'se man kari'na 'wano me. Mo'ko kari'na te ikapy'pa tywaije man moro otare'matopo kurita 'wano me. ");
INSERT INTO car_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Iro ke ro mo'ko kari'na ymuru moro otare'matopo kurita jopotory me enapa man.” ");
INSERT INTO car_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Irombo Jesus wo'my'po rapa moro Simosu wota'nano'to'kon auto taka. Moro po ro amy ainamiriri'ta'po kynakon. ");
INSERT INTO car_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jesus poko mo'karon Farise tuwaro kynatokon. Moro otare'matopo kurita ikura'mary enery 'se kynatokon i'wa, emendoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Irombo ika'po mo'ko ainamiriri'ta'po 'wa: “O'ko 'ne owarira'naka.” ");
INSERT INTO car_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Irombo ika'po i'waine: “Iru'pa nan moro otare'matopo kurita aja'sakary poko iru'pa awairy, yja'wan me ipoko awairy te ka'tu? Iru'pa nan moro otare'matopo kurita amy aja'sakary rombyrymbo awongary o'wa, iromo'kapory te ka'tu o'wa?” Anejuku'pa te iwe'i'san. ");
INSERT INTO car_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Irombo pa'poro i'waine tare'ke iwo'poty'po. Moro tyturu'poja'nare iwairykon 'wa ituru'po je'tunanopy'po. Irombo ika'po mo'ko wokyry 'wa: “Ajainary ityngako!” Irombo moro tainary tynga'po i'wa. Irombo iru'pa rapa moro ainary we'i'po. ");
INSERT INTO car_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Irombo tywepa'ka'san mero, o'win wytory mo'karon Farise worupa'san mo'karon Herodes wyinonokon maro, one wara Jesus wory man poko. ");
INSERT INTO car_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Irombo Jesus womima'po moro wyino. Moro tuna juwembory 'wa ito'po mo'karon tynemeparykon maro. Amy kari'na apyimy 'wa iwekena'san, Galilea wyino, Judea wyino, ");
INSERT INTO car_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem wyino, Idumea wyino, Jordan koposenokon aito'kon wyino, Tyrus, Sidon wyinonokon aito'kon wyino enapa. Morokon inikapy'san ekary etary ke ty'waine, moky mo'karon kari'na kyno'satokon I'wa. ");
INSERT INTO car_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Irombo ika'po mo'karon tynemeparykon 'wa amy kurijara'membo waito'me tyse waty tokosa, itaka tywotaru'kato'me, mo'karon kari'na apyimy wotunsi'kory jako tytu'ponaka. ");
INSERT INTO car_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Pyime kari'na kura'mary ke i'wa, pa'poro mo'karon je'tun pangon wotunsi'ko'san itu'ponaka, i'tu'kato'me ty'waine. ");
INSERT INTO car_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mo'karon yja'wangon akywano 'wa Jesus ene'po mero, kyno'pa'satokon ipo'ponaka. Kyniko'tapo'satokon: “Mo'ko Tamusi ymuru amoro mana.” ");
INSERT INTO car_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Irombo Jesus kyne'mapo'satokon imero, takarory pona i'waine. ");
INSERT INTO car_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Irombo Jesus wonuku'po moro wypy tu'ponaka. Tynisanorykonymbo ro ko'ma'san I'wa ty'wa. Irombo iwopy'san i'wa. ");
INSERT INTO car_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ainapatoro itu'ponaka oko amykon apo'i'san i'wa, tokosa iwaito'ko'me. Tamusi auranymbo ekari'se apojomarykon 'se kynakon. Apojonanokon me enapa kynejatojatokon. ");
INSERT INTO car_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ipori'toma'san i'wa, mo'karon yja'wangon akywano momato'me i'waine. ");
INSERT INTO car_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Mo'karon ainapatoro itu'ponaka oko Jesus napo'i'san etykon kynatokon: Simon (Petrus me enapa Jesus kynejatojakon), ");
INSERT INTO car_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","mo'ko Sebedeus ymuru Jakobus mo'ko ipiry Johanes maro (Boanerges me enapa Jesus kynejatojatokon, moro tauro'po man konomeru y'makon), ");
INSERT INTO car_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andreas, Filipus, Bartolomeus, Mateus, Tomas, mo'ko Alfeo ymuru Jakobus, Tadeus, mo'ko Judea poko o'wo'matoto Simon, ");
INSERT INTO car_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot (mo'ko 'wa ro enapa Jesus takarama man). ");
INSERT INTO car_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Irombo auto taka iwo'my'po. Moky rapa kari'na wota'nanopy'san. Iwara te tywendamerykon upi'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Mo'karon omorykon 'wa moro eta'po mero, aije ito'san. Ero wara ika'san: “Tupu'po ta waty man.” ");
INSERT INTO car_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Irombo mo'karon Jerusalem wyino o'pema'san Tamusi karetary uku'namon wyka'san: “Mo'ko Be'elsebul ita man. Mo'ko ewa'rumy tamuru pori'tory ta ro mo'karon ewa'rumy momanon.” ");
INSERT INTO car_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Irombo Jesus 'wa iko'ma'san ty'wa. Amykon onumengato'kon auranano ekarity'po i'wa i'waine: “One wara ko mo'ko Satan aseke tywaimomary taro nan? ");
INSERT INTO car_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","O'win e'i'pa amy nono undymanamon a'ta, moro nono undymary tywairy taro waty man. ");
INSERT INTO car_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O'win e'i'pa amy auto tanokon a'ta, moro auto tywairy taro waty man. ");
INSERT INTO car_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aseke mo'ko Satan wo'wo'mary jako, o'win e'i'pa mo'karon inundymary tanokon a'ta, mo'ko Satan tywairy taro waty man. Kynuta'tan. ");
INSERT INTO car_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Amy pana'pyn kari'na auty taka amy pairo kari'na tywo'myry upijan, morokon otyry mona'toto'me, mo'ko pana'pyn animy'pa na'nen ta'ta. Imy'poto te ty'wa, morokon auty tanokon mona'tory taro man. ");
INSERT INTO car_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Ita'ro pore, pa'poro kari'na yja'wanykonymbo, ukuty'pa 'ne roten yja'wan me iworupa'san kyno'katan. ");
INSERT INTO car_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mo'ko Tamusi a'kary poko yja'wan me orupatoto yja'wanymbo te o'ka'pa roten kynaitan. Amy aitoto roten yja'wan oty te u'ta kynaitan.” ");
INSERT INTO car_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Moro wara Jesus wyka'po, amy yja'wan akywano ekarityry ke i'waine ty'tu'po. ");
INSERT INTO car_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Irombo isano wopy'po mo'karon ipiryjan maro. Jesus ko'mapo'po i'waine kurandonaka. ");
INSERT INTO car_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Amy kari'na apyimy wotandy'mo'po 'wa tu'menje kynakon. Mo'karon wyka'san ro I'wa: “Eneko! Asano, apiryjan, ajenaunan enapa kurando mandon. Ajenery 'se mandon.” ");
INSERT INTO car_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Irombo ejuku'san i'wa: “Noky ko ysano me nan? No'kan ko ymeseku'san me nandon?” ");
INSERT INTO car_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Irombo pa'poro mo'karon tu'menamon kari'na wotandy'mo'san 'wa tywo'potyry jako ro, ika'po: “Enetoko! Ysano me, ymeseku'san me mojan mandon! ");
INSERT INTO car_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Mo'ko Tamusi nisanory wara aitoto ro ypiry me man, yjenauty me man, ysano me enapa man.” ");
INSERT INTO car_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Irombo moro tuna juwembory esi'wo rapa Jesus 'wa emeparykon a'mo'po. Moky imero kari'na wota'nanopy'san ekosa. Iro ke ro amy kurijara ta iwotandy'mo'po, a'si 'ko ira'na tywaito'me. Pa'poro mo'karon ata'nanopy'san mapo kynatokon. ");
INSERT INTO car_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Irombo Jesus 'wa pyime otykon poko emepa'san onumengato'kon auranano ke. Ero wara emepa'san i'wa: ");
INSERT INTO car_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Epanamatoko! Amy maina pokono tyto man o'ponje. ");
INSERT INTO car_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Moro iwo'pomyry jako ro, a'si 'ko amykon inipomyry epy tywo'pa'se man oma esi'wo. Irombo mo'karon tonoro tywo'se mandon. Irombo tana'se i'waine man. ");
INSERT INTO car_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","A'si 'ko enapa amykon tywo'pa'se man topu pan nono tu'ponaka. Moro po iko'po 'ne 'ne sakau waty man. O'win wytory kynatytanon, ipyimy'ma moro sakau wairy ke. ");
INSERT INTO car_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Weju wepa'ka'po mero te, asiny 'wa tykoro'ka man. Imi'pa tywairykon ke, tajuta man. ");
INSERT INTO car_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Amykon enapa tywo'pa'se man takyramon itupu paty ta. Irombo moro takyramon itupu atytary 'wa moro wonatopo tywo man. Epeta'pa tywaije man. ");
INSERT INTO car_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amykon enapa tywo'pa'se man iru'pyn nono tu'ponaka. Tatyta man. Potonon me tywaije man. Irombo amykon tapeta tywaije man o'win-kari'na itu'ponaka ainapatoro me, amykon tapeta tywaije man oruwa-kari'na me, amykon tapeta tywaije man ainatone-kari'na me.” ");
INSERT INTO car_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Irombo ika'po: “Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","A'saka'pa tywe'i'san mero, mo'karon inemeparykon maro mo'karon ekosa aitonon woturupo'san i'wa morokon onumengato'kon auranano poko. ");
INSERT INTO car_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Irombo ika'po i'waine: “Amyjaron moro Tamusi nundymary poko tamorepa mandon. Mo'karon amykon terapa 'wa te pa'poro omepano apyiry man onumengato'kon auranano ta. ");
INSERT INTO car_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Kyno'po'ta'ton ro rypo. Otymbo ro anene'pa te kynaita'ton. Kynepanamata'ton ro rypo. Otymbo ro aneta'pa te kynaita'ton. Iwara tamamyrykon anu'ma'pa kynaita'ton. Ija'wanykonymbo ika'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Irombo ika'po i'waine: “O'to tauro'po me moro onumengatopo auranano wairy anukuty'pa mandon? One wara ko iro ke muku'ta'ton o'to tauro'po me pa'poro morokon onumengato'kon auranano wairy? ");
INSERT INTO car_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Mo'ko maina pokono Tamusi auranymbo aripa'san. ");
INSERT INTO car_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","“Amykonymbo kari'na morokon oma ta o'pa'tonon wonatopo epy wara mandon. Moro Tamusi auranymbo etaton. Eta'po mero te i'waine, o'win wytory mo'ko Satan kyno'san. Inoro ro moro ituru'san ta o'papy'po Tamusi auranymbo pinanon. ");
INSERT INTO car_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","“Amykonymbo kari'na rapa morokon topu pan nono tu'po o'pa'tonon wonatopo epy wara mandon. Moro Tamusi auranymbo eta'po mero ty'waine, o'win wytory tawa'porykon maro kynapyijaton. ");
INSERT INTO car_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ituru'san ta te atandy'mo'pa man. Ko'i roten Tamusi amyikaton. Moro Tamusi auranymbo upu'po me awosin pangon otykon 'wa toporykon jako, ta'sakarykon 'wa tykota'marykon jako, o'win wytory kynomaton. ");
INSERT INTO car_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","“Amykonymbo kari'na rapa morokon takyramon itupu paty ta o'pa'tonon wonatopo epy wara mandon. Tamusi auranymbo etaton. ");
INSERT INTO car_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Irombo te pyime nono tu'ponokon otykon poko kynonumengaton. Pyrata kynemu'maton. Pyime amykon terapa otykon poko enapa ituru'san kynikuminanon. Iwara te moro Tamusi auranymbo epeta'pa kyniromo'san ituru'san ta. ");
INSERT INTO car_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","“Amykonymbo kari'na rapa morokon iru'pyn nono tu'ponaka o'pa'tonon wonatopo epy wara mandon. Moro Tamusi auranymbo etaton. Kynapyijaton tyturu'san ta. Irombo amykonymbo o'win-kari'na itu'ponaka ainapatoro me kynepetaton, amykonymbo oruwa-kari'na me, amykonymbo ainatone-kari'na me.” ");
INSERT INTO car_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Irombo ika'po i'waine: “Akororetary 'kare myjan amy tosipi upi'nonaka, apaty upi'nonaka pai. Akororetary anyry'pa 'kare man moro apo'ny tu'ponaka. ");
INSERT INTO car_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Unemy'po oty wepa'kary man. Onepyn oty wonepory man. ");
INSERT INTO car_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Irombo ika'po i'waine: “Tuwaro aitokon moro anetarykon poko. Moro ana'kurukon oty u'kutopo ke enapa otykon u'kuta'ton o'waine. Itu'ponaka 'ne ka'tu rapa oty yta'ton o'waine. ");
INSERT INTO car_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Mo'ko totyken 'wa irombo otykon yta'ton. Mo'ko otypyn wyino te otyrykonymbo pinata'ton.” ");
INSERT INTO car_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Irombo ika'po: “Moro Tamusi nundymary amy o'pondoto wara man. Mo'ko o'pondoto moro wonatopo epy pyryrykanon maina ta. ");
INSERT INTO car_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Iko'mamyry wararo o'ny'se kyny'san. Emamyry wararo kynawonjan rapa. Irombo moro wonatopo epy kynatytanon. Kynipuwanon. One wara 'ne moro oty wo'kapyry anukuty'pa man mo'ko o'pondoto. ");
INSERT INTO car_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Moro nono aseke wonatopo atytano'pojan. Moro epy na'sen kynatytanon, irombo moro epery je'ny, irombo moro epery 'nero. ");
INSERT INTO car_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Moro wonatopo epery we'i'po mero, o'win wytory moro i'kototopo aropojan, moro ipo'topo kurita tunda'po ke.” ");
INSERT INTO car_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Irombo ika'po: “Otypan oty wara ko moro Tamusi nundymary kysyta'ton? Otypan onumengatopo auranano ko kysekari'ta'ton ipoko? ");
INSERT INTO car_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Irombo ro ko'warono wonatopo epy'po'membo wara man, maina ta ipomyry jako. ");
INSERT INTO car_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Typomy'poto, kynatytanon. Irombo irombo ro poto 'su wonatopo me kynaijan. Potonon me kyniporitanon. I'sanory ta ro mo'karon tonoro tapo'nykon amyjaton.” ");
INSERT INTO car_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Pyime moropangon onumengato'kon auranano ke moro Tamusi auranymbo ekari'sakon Jesus i'waine, apyiry taro ro i'waine. ");
INSERT INTO car_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Onumengatopo auranano rato te aurana'pa kynakon i'waine. A'saka'pa tywe'i'san mero te mo'karon tynemeparykon maro, o'to tauro'po me pa'poro morokon onumengato'kon auranano wairy ekari'sakon i'waine. ");
INSERT INTO car_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Koine 'ne ika'po i'waine: “Moro tuna juwembory kysipatosen.” ");
INSERT INTO car_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Mo'karon kari'na apyimy no'po i'waine. Moro ita iwaitopo kurijara ta ro mo'ko Jesus aro'po i'waine. Amykon enapa kurijara wyto'san imaroine. ");
INSERT INTO car_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Irombo orometa wopy'po. Parana 'wa terapa tywotaru'kary a'mo'po moro kurijara taka. Moro kurijara kynotu'mu'sakon terapa. ");
INSERT INTO car_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesus moro kurijara ansety ta ta'sapony'ne kyno'ny'sakon. Irombo embaka'po i'waine. Ika'san I'wa: “Na'na emepanen! Kutapyrykon se'me esyka'pa man?” ");
INSERT INTO car_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tupaka'po mero, pari'pe moro pepeito e'ma'po i'wa. Ika'po moro parana 'wa: “Oity'nako! Ity'me terapa aiko!” Irombo moro pepeito yity'na'po. Ity'me imero moro parana we'i'po. ");
INSERT INTO car_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Irombo ika'po i'waine: “O'tono'me ko tanarike 'ne terapa mandon? Tamusi anamyika'pa noro ka'tu mandon?” ");
INSERT INTO car_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Poto me iwe'naranga'san. Ase'wa ika'san: “Noky 'ne ko mo'se nan, se? Moro pepeito, moro parana enapa kore nepanamaje i'wa, ran!” ");
INSERT INTO car_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Irombo koposenaka itunda'san mo'karon Gerasa wyinonokon 'wa. ");
INSERT INTO car_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesus wo'ka'po mero moro kurijara wyino, o'win wytory moro atunendopo wyino amy yja'wan akywanopan wokyry wopy'po epoje. ");
INSERT INTO car_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Moro atunendopo ta roten iwaitopombo kynakon. Siparari kapy'po ke ro rypo amy pairo noro imyry upijakon. ");
INSERT INTO car_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pyimemboto rypo ainary, ipupuru enapa tymy tywaije i'waine kynakon siparari ke. Morokon tainary myto'konymbo siparari apo'topombo te i'wa kynakon. Morokon typupuru myto'konymbo siparari y'mopo'topombo i'wa kynakon. Amy pairo apyiry upijakon, ity'nato'me. ");
INSERT INTO car_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Koko, kurita wararo moro atunendopo ta, morokon wypy ta enapa tyko'tapotyry aropo'topombo i'wa kynakon. Aseke ro topu ke iwo'wotopombo kynakon. ");
INSERT INTO car_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tyse ro Jesus ene'po mero ty'wa, eka'numy'po i'wa. Tokuna'po iwoma'po ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Mo'ja iko'ta'po: “Oty 'se ko ymaro man, se, Jesus, inorombo ro kawono Tamusi ymuru? Tamusi embata waturupoja o'wa, yja'karykapo'pa awaito'me!” ");
INSERT INTO car_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Moro wara ika'po, Jesus wyka'po ke ty'wa: “Amoro yja'wan akywano, epa'kako mo'ko kari'na wyino.” ");
INSERT INTO car_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Irombo Jesus woturupo'po i'wa: “One wara ko ajety nan?” ");
INSERT INTO car_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Irombo ika'po I'wa: “ ‘Pyimano’ yjety me man, pyime na'na wairy ke.” Irombo iwe'pima'po imero Jesus 'wa, moro aitopo wyino tomoky'pa iwaito'me. ");
INSERT INTO car_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Moro jako 'ne moky pyiruku moro wypy tu'po tywendamery aropo'satokon. ");
INSERT INTO car_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Irombo mo'ko wokyry akyrykon we'pima'san Jesus 'wa. Ika'san: “Na'na emo'ko mo'kan pyiruku 'wa, itakaine na'na nyto'se me.” ");
INSERT INTO car_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesus 'wa iru'pa epory'po. Mo'ko wokyry wyino mo'karon yja'wangon akywano wepa'ka'san. Mo'karon pyiruku taka terapa ito'san. Irombo mo'karon pyiruku eka'numy'san moro eme'tary wyino moro tuna juwembory taka. O'win-kari'namboto ainatone-kari'na iwairy taro kynatokon. Pa'poro i'maty'san moro tuna juwembory ta. ");
INSERT INTO car_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Irombo mo'karon pyiruku enenamonymbo eka'numy'san moro wyino. Ekarity'po i'waine moro poto 'su aitopo ta, mo'karon aitopo wyino kurando amandonon 'wa enapa. Irombo otypan oty wo'kapy'po ene mo'karon aurangon etanamonymbo wopy'san. ");
INSERT INTO car_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesus 'wa iwopy'san. Moro po ro mo'ko pyime takyrenymbo ene'po i'waine tandy'po, tywewo'myndo, tupu'po ta terapa. Irombo iwety'ka'san imero. ");
INSERT INTO car_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mo'karon enenamonymbo 'wa erupa'san otypan oty 'wa mo'ko takyrenymbo epory'po poko, mo'karon pyiruku poko enapa. ");
INSERT INTO car_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Irombo Jesus 'wa imero iwe'pima'san, moro tyinonorykon wyino itoto'me. ");
INSERT INTO car_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Moro kurijara taka iwotaru'kary jako ro, mo'ko takyrenymbo we'pima'po i'wa, ekosa tywaito'me. ");
INSERT INTO car_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","I'se'pa te Jesus we'i'po. Ika'po i'wa: “I'tango ajauty 'wa, ajomorykon 'wa. Pa'poro ekari'ko me i'waine one wara Tamusi 'wa ajyry'po, one wara akotanory ene'po i'wa.” ");
INSERT INTO car_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Irombo mo'ko wokyry wyto'po. Dekapolis po pa'poro one wara Jesus 'wa tyry'po ekarityry a'mo'po i'wa. Pa'poro mo'karon auran etanamon wonumenga'san imero. ");
INSERT INTO car_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Irombo moro kurijara ta Jesus wepato'po rapa koposenaka. Pyime kari'na wota'nanopy'san rapa ekosa. Awopa me ro iwe'i'po. ");
INSERT INTO car_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Moro jako ro amy Jairus tatynen Simosu wota'nano'to'kon auto jopotory wopy'po. Jesus ene'po mero ty'wa, tokuna'po iwoma'po ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Iwe'pima'po imero i'wa. Ika'po: “Yjemyiry'membo kyniromo'san terapa. O'ko, ajainary myry'se me itu'ponaka, iwekura'mato'me rapa, iromby'pa iwaito'me.” ");
INSERT INTO car_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Irombo Jesus wyto'po imaro. Moky kari'na 'wa iwekena'po. Moky imero itu'ponaka kynotunsi'kojatokon. ");
INSERT INTO car_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ira'naine ro amy je'tun pan woryi kynakon. Ainapatoro itu'ponaka oko siriko terapa no'mo roten kynakon. ");
INSERT INTO car_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ta'karykapo tywaije kynakon pyime epino'namon 'wa. Pa'poro totyrykonymbo tyje tywaije i'wa kynakon tapinopyry epety me. Ise'me roten ekura'ma'pa pairo tywaije kynakon. Iro'ne me 'ne ka'tu rapa te tywaije kynakon. ");
INSERT INTO car_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Mo'ko ro Jesus ekary etary poko tyto kynakon mo'karon kari'na apyimy ra'naka. Irombo Jesus ynga'na'po ta moro iwo'my y'tu'ka'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kyngakon irombo: “Iwo'my y'tu'ka'poto roten y'wa, iru'pa rapa waitake.” ");
INSERT INTO car_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Irombo o'win wytory moro imynurumbo wo'kepy'po. Tyja'mun ta moro tywekura'ma'po rapa apo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","O'win wytory tywyino amy typori'torymbo wepa'kary apo'po Jesus 'wa. Irombo iwotu'ma'po mo'karon kari'na apyimy ra'na. Ika'po: “Noky ko ywo'my y'tu'kai?” ");
INSERT INTO car_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mo'karon inemeparykon wyka'san I'wa: “Meneja kore mo'karon kari'na apyimy wotunsi'kory otu'ponaka, ran! Ise'me roten ‘Noky ko y'tu'kai?’ mykaje!” ");
INSERT INTO car_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Wararo te iwo'poty'po, noky 'wa moro oty kapy'po eneto'me ty'wa. ");
INSERT INTO car_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Mo'ko woryi te otypan oty wo'kapy'po uku'sakon tymaro. Tywety'kary ta ko'wu iwopy'po. Tokuna'po iwoma'po ipo'ponaka. Irombo pa'poro ekarity'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Irombo Jesus wyka'po i'wa: “Iso'ne, moro o'wa Tamusi amyikary akura'mai. Iru'pa i'tango. Ajanykyrymbo wyino iru'pa rapa aiko.” ");
INSERT INTO car_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus auranary jako noro, amykon wopy'san mo'ko Simosu wota'nano'to'kon auto jopotory auty wyino. Ika'san: “Ajemyiry nirombyi terapa. O'tono'me ko mo'ko amepanen poko noro man?” ");
INSERT INTO car_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Moro aurangon eta'po mero ty'wa, Jesus wyka'po mo'ko Simosu wota'nano'to'kon auto jopotory 'wa: “Kytety'kai. Tamusi roten te amyikako.” ");
INSERT INTO car_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Irombo amy pairo 'wa tywekenary 'se'pa iwe'i'po. Petrus, mo'karon asepiryjan Johanes, Jakobus maro roten ito'po. ");
INSERT INTO car_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Irombo mo'ko Simosu wota'nano'to'kon auto jopotory auty 'wa tytundarykon jako, iwose'mere'karykon ene'po i'wa. Mo'ja imero kynotamojatokon. ");
INSERT INTO car_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Irombo moro auto taka tywo'my'po mero, ika'po: “O'tono'me ko mataikapo'saton, matamojaton? Mo'ko amyija'ko iromby'pa man. Kyno'ny'san te.” ");
INSERT INTO car_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Irombo auno'poty'po i'waine. Kurandonaka pa'poro emoky'san mero ty'wa, mo'ko amyija'ko wo'ny'topo taka iwo'my'po mo'ko ijumy, isano, mo'karon tokosanokon tynemeparykon maro roten. ");
INSERT INTO car_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Irombo mo'ko amyija'ko apo'i'po i'wa ainary poko. Ika'po i'wa: “Talita, kum!” Moro tauro'po man: “Wodi, ajawongo!” ");
INSERT INTO car_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","O'win wytory mo'ko amyija'ko awomy'po. Typupuru ema'po rapa i'wa. Ainapatoro itu'ponaka oko siriko mo'ko amyija'ko kynakon. Poto'me imero iwe'naranga'san. ");
INSERT INTO car_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Irombo imero Jesus 'wa e'mapoty'san, amy 'wa terapa ekarityry pona i'waine. Irombo mo'ko amyija'ko upapo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Irombo moro wyino ito'po. Moro tywetuwaro'matopombo aitopo Nasaret 'wa ito'po. Mo'karon inemeparykon 'wa iwekena'po. ");
INSERT INTO car_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Moro otare'matopo kurita tunda'po mero, Jesus 'wa emeparykon a'mo'po moro Simosu wota'nano'to'kon auto ta. Pyime mo'karon i'wa epanamatonon enuta'san imero. Ika'san: “Oje ko morokon auranano topoje i'wa nan? One wara ko moro wara tywonumengapore tywaije nan? Otypangon pori'tonano ko morokon inenepory nan? ");
INSERT INTO car_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Mo'ko auto amynen kapyn mo'se nan? Mo'ko Maria y'me, mo'ko Jakobus, Joses, Judas, Simon yryi kapyn mo'se nan? Mo'karon enaunan waty ero po kyra'naine nemanjaton?” Jesus imero kynere'kojatokon. ");
INSERT INTO car_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Irombo Jesus wyka'po i'waine: “Wararo amy Tamusi auran uku'ponen ety kawo man. Moro iwetuwaro'matopombo po roten te 'kuru ety awonga'pa man, mo'karon omorykon ra'na, mo'karon auty tanokon ra'na enapa.” ");
INSERT INTO car_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Moro po ro amy pairo poto 'su oty anikapy'pa iwe'i'po. Amykon je'tun pangon kura'ma'po roten i'wa, tainary yry ke ty'wa itu'ponakaine. ");
INSERT INTO car_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Poto me imero iwonumenga'po moro Tamusi anamyika'pa iwairykon poko. Irombo morokon sengenokon aito'kon wa ito'po. Emeparykon aropoty'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Irombo mo'karon ainapatoro itu'ponaka okonokon ko'ma'san i'wa ty'wa. Irombo oko oko pai emokyrykon a'mo'po i'wa. Pori'tonano yry'po i'wa i'waine, mo'karon yja'wangon akywano momato'me i'waine. ");
INSERT INTO car_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ika'po i'waine: “Amy pairo oty koro kysaroton oma tano me. Erepa'ma i'tandoko, otyje'ny'ma, ipyrata'pa. Moro ajaposenykon roten te arotoko. ");
INSERT INTO car_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Tysapatoke i'tandoko. Awo'mykon y'petakangon te kysaroton.” ");
INSERT INTO car_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ika'po i'waine: “Amy auto taka awo'my'sando, moro po ro aitoko, moro aitopo wyino awytorykon 'wa ro. ");
INSERT INTO car_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amy oje o'se'paine a'taine, o'waine tywepanamarykon 'se'pa a'taine, i'tandoko moro aitopo wyino. Awytorykon mero moro apupurukon i'kokatoko, tu'taine oty wairy uku'to'me i'waine.” ");
INSERT INTO car_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Irombo mero ito'san. Mo'karon kari'na 'wa ika'san tamamyrykon u'mato'me i'waine. ");
INSERT INTO car_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Pyime yja'wangon akywano moma'san i'waine. Pyime je'tun pangon kura'ma'san i'waine, amy wewe epery katy ke ikyrykyrymarykon ke. ");
INSERT INTO car_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Irombo mo'ko poto 'su jopoto Herodes 'wa Jesus ekary eta'po, wararo ety we'i'po ke takare. Kari'na irombo kyngatokon: “Mo'ko kari'na etykanenymbo Johanes tawonje rapa man iromby'san wyino. Iro ke ro morokon pori'tonano ita kynemaminanon.” ");
INSERT INTO car_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Amykonymbo wykatopombo te kynakon: “Elia mo'ko man.” Amykonymbo rapa kyngatokon: “Mo'karon penatonon Tamusi auran uku'ponamonymbo wara enapa, amy Tamusi auran uku'ponen mo'ko man.” ");
INSERT INTO car_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Moro eta'po mero te Herodes wyka'po: “Mo'ko ynu'kapo'po Johanes ro mo'ko tawonje rapa man.” ");
INSERT INTO car_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Mo'ko Herodes 'wa irombo Johanes tapyipo tywaije kynakon typyitorykon 'wa. Taru'kapo i'wa kynakon yja'wangon kari'na aru'katopo taka, mo'ko typiry Filipus pytymbo Herodias upu'po me. Mo'ko ro tapyije tywaije i'wa kynakon typyty me. ");
INSERT INTO car_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Johanes wykatopombo irombo kynakon Herodes 'wa: “Apiry pyty maro kapyn awairy man.” ");
INSERT INTO car_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Moro poko ro Herodias mo'ko Johanes jenono'sakon. Iwopory 'se kynakon. Moro kapyry upijakon te, ");
INSERT INTO car_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Johanes nendory ke Herodes 'wa. Herodes 'wa tuku'se kynakon Johanes wairy amy Tamusi wyinono tamamboren kari'na me. Johanes unendopombo i'wa kynakon iwory pona. Auran etary jako ty'wa, one wara moro poko tywonumengary upitopombo i'wa kynakon. Ise'me moro i'wa iwepanamary apokupe kynakon. ");
INSERT INTO car_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Irombo amy kurita Herodias 'wa oma epory'po. Herodes moro tywomatopombo kurita ewa'makon. Arepa amy ena'pojakon mo'karon tupi'nonokon jopotokon 'wa, mo'karon warinu pokonokon jopotorykon 'wa, mo'karon Galilea po potonon me aitonon 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Irombo mo'ko Herodias emyiry wopy'po. Uwa'po ipo'ponakaine. Herodes apokupe imero kynakon. Mo'karon imaro endametonon apokupe enapa kynakon. Irombo mo'ko jopoto Herodes wyka'po mo'ko amyija'ko 'wa: “Anisanory ro oty poko aturupoko y'wa. Sytake o'wa. ");
INSERT INTO car_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Tamusi netary me wykaje o'wa: moro y'wa awoturupotopo oty ro sytake o'wa. Moro ynundymary pairo ase'ra sa'sakatake amaro, i'se aja'ta.” ");
INSERT INTO car_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Irombo mo'ko amyija'ko wyto'po rapa. Tysano 'wa iwoturupo'po: “Oty poko ko waturupotan?” Isano wyka'po: “Mo'ko kari'na etykanen Johanes upu'pombo poko aturupoko i'wa.” ");
INSERT INTO car_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Irombo o'win wytory tarawone ito'po rapa mo'ko jopoto 'wa. Iwoturupo'po: “Erome ro tapo'nyne mo'ko kari'na etykanen Johanes upu'pombo ene'ko y'wa.” ");
INSERT INTO car_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Kata'mato imero mo'ko jopoto we'i'po. Ise'me te ‘uwa’ yka'pa iwe'i'po moro iwoturupotopo poko, Tamusi netary me, mo'karon endametonon netary me enapa taurana'po ke mo'ko amyija'ko 'wa. ");
INSERT INTO car_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Irombo o'win wytory mo'ko jopoto 'wa amy warinu pokono emoky'po, Johanes upu'pombo ene'to'me i'wa. Moro yja'wangon kari'na aru'katopo ta ro Johanes u'ka'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Irombo amy apo'ny tu'po moro upu'pombo enepy'po i'wa. Mo'ko amyija'ko 'wa yry'po i'wa. Mo'se 'wa tysano 'wa terapa yry'po. ");
INSERT INTO car_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Irombo moro eta'po mero mo'karon Johanes nemeparykon wyto'san moro ekepy'po aije. Irombo unemy'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Irombo mo'karon Jesus napojoma'san wota'nanopy'san rapa ekosa. Pa'poro o'to tywe'i'san, one wara ty'waine ta'sakarykon emepa'san enapa ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Irombo ika'po i'waine: “O'toko ymaro amy iponomyn aitopo 'wa, a'si 'ko awotare'mato'ko'me.” Moky rapa imero kari'na i'waine kyno'satokon. Typo kyny'satokon rapa. Moro ro moro iwendamerykon upi'pojakon. ");
INSERT INTO car_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Irombo moro kurijara ta ito'san amy iponomyn aitopo 'wa, a'saka'pa tywaito'ko'me. ");
INSERT INTO car_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pyime kari'na 'wa te itorykon ene'po. Ojapan itorykon ukuty'po i'waine. Irombo pa'poro morokon aito'kon wyino taka'ne mo'karon kari'na wyto'san uwapoine moro itundato'kon man 'wa. ");
INSERT INTO car_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Moro kurijara wyino tywo'ka'po mero, moky kari'na wota'nanopy'san ene'po Jesus 'wa. Ikotanorykon ene'po i'wa, ene'nemyngon kapara wara iwairykon ke. Irombo pyime otykon poko emeparykon a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Koine 'ne terapa iwe'i'po mero, mo'karon inemeparykon wopy'san I'wa. Ika'san: “Ero aitopo ipono'ma man. Koine 'ne terapa man. ");
INSERT INTO car_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mo'karon kari'na emo'toko rapa, tareparykon man epeka'to'se me morokon sengenokon aito'kon po.” ");
INSERT INTO car_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesus wyka'po te eju'to'ko'me: “Amyjaron te upatoko!” Irombo ika'san I'wa: “Ainapatoro-kari'na amu'numbo poko perere epeka'se na'na ny'tan, upato'ko'me?” ");
INSERT INTO car_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ika'po i'waine: “O'toro perere ko ajekosaine nan? Enetandoko 'nare!” Irombo ene tyto'san mero, ika'san: “Ainatone perere, oko woto maro.” ");
INSERT INTO car_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Irombo mo'karon tynemeparykon 'wa tymondymonge mo'karon kari'na andy'mopo'san i'wa moro itupu tu'po. ");
INSERT INTO car_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ainatone-kari'na pai iwotandy'mo'san, oruwa-kari'na pai enapa. ");
INSERT INTO car_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Irombo Jesus 'wa morokon ainatone perere, mo'karon okonokon woto apo'i'po. Kapu 'wa iwo'poty'po. Tamusi ety awonga'po i'wa. Irombo mero morokon perere y'sakapoty'po i'wa. Mo'karon tynemeparykon 'wa yry'po i'wa, mo'karon ata'nanopy'san upato'me i'waine. Mo'karon okonokonymbo woto y'sakapoty'po enapa i'wa, pa'poro kari'na 'wa amy apyito'me. ");
INSERT INTO car_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Pa'poro iwendame'san. Pa'poro iwaime'san. ");
INSERT INTO car_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Irombo ainapatoro itu'ponaka oko kurukuru morokon arepa akosinykonymbo amo'iky'san i'waine. Mo'karon woto akosinykonymbo a'nanopy'san enapa i'waine. ");
INSERT INTO car_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Mo'karon endame'san ainatone dusun kynatokon. ");
INSERT INTO car_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Irombo o'win wytory Jesus 'wa mo'karon tynemeparykon wyry'ka'san, iwotaru'kato'ko'me kurijara taka, tuwapo itoto'ko'me koposenaka, Betsaida 'wa. Mo'karon kari'na apyimykon emokyry 'se na'nen kynakon aseke ro. ");
INSERT INTO car_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","“Iru'pa i'tandoko!” tyka'po mero mo'karon kari'na 'wa, moro wypy tu'ponaka ito'po, Tamusi 'wa tauranato'me. ");
INSERT INTO car_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iko'mamy'po mero, moro kurijara tuna owarira'na terapa kynakon. Jesus te o'win upu'po kynakon mapo. ");
INSERT INTO car_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Irombo tywotarimarykon poko iwo'mikarykon ene'po i'wa. Pepeito po'ponaka kyny'satokon. Irombo tuna tu'po ito'po epojeine, koko, emamyry jako. ");
INSERT INTO car_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Moro tuna tu'po itory enery mero te ty'waine, amy akatombo ja'ta ekanopy'po i'waine. Tywe'i'san mero ene'po i'waine. Mo'ja imero iwety'ka'san wotaikapoty'san. O'win wytory te aurana'po i'waine. Ika'po: “Aturu'san apyitoko! Awu te wa! Kytety'katon!” ");
INSERT INTO car_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Irombo iwotaru'ka'po moro ikurijararykon taka. Irombo moro pepeitombo yity'na'po imero. Poto me imero iwe'naranga'san. ");
INSERT INTO car_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Morokon perere apyimanga'san anenutano'po'paine tywaije kynakon. Tyturu'poja'nare kynatokon. ");
INSERT INTO car_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Atonenaka tywepato'san mero, moro aitopo Genesaret 'wa itunda'san. Moro po ro iwo'kima'san. ");
INSERT INTO car_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iwo'ka'san mero moro kurijara wyino, o'win wytory mo'karon moro ponokon 'wa Jesus ukuty'po. ");
INSERT INTO car_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Irombo pa'poro morokon moro ponokon aito'kon wara ro eka'numboty'san. Oje iwairy eta'po 'wa ro mo'karon je'tun pangon aropoty'san i'waine, iwo'ny'to'kon tu'po ro. ");
INSERT INTO car_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesus tundato'po 'wa ro, itaronokon aito'kon 'wa, potonon aito'kon 'wa, siky'inon aito'kon 'wa pai, wararo morokon otykon ekaramatokon po mo'karon je'tun pangon yto'konymbo i'waine kynakon. Irombo iwe'pimato'konymbo i'wa kynakon, iwo'my sese'wuru roten y'tu'kato'me ty'waine. Irombo pa'poro mo'karon i'tu'kanamonymbo iru'pa rapa kynaijatokon. ");
INSERT INTO car_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Irombo mo'karon Farise wopy'san, amykon Jerusalem wyino opy'san Tamusi karetary uku'namon maro. Iwota'nanopy'san Jesus ekosa. ");
INSERT INTO car_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Irombo amykon inemeparykon wendamery ene'po i'waine nurija me, asainaty'pa wykaje irombo. ");
INSERT INTO car_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Mo'karon Farise irombo, pa'poro mo'karon Simosu wykaje irombo, asainaty'pa endame'pa mandon. Iru'pyn me morokon tainarykon ku'mity'san mero te kynendamejaton, mo'karon uwapoto'san 'wa tamepa'san wara ro. ");
INSERT INTO car_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Otykon ekaramatopo wyino tywopy'sando, eku'mity'pa na'sen ta'taine, endame'pa mandon. Pyime noro otykon poko moro wara kynaijaton, mo'karon uwapoto'san 'wa tamepa'san wara ro. Tysaperarykon atywojaton, typarapirykon atywojaton, tysipararirykon atywojaton, tapo'nykon ku'mi'saton a'kuru uwaporo. ");
INSERT INTO car_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mo'karon Farise, mo'karon Tamusi karetary uku'namon enapa woturupo'san ro i'wa: “O'tono'me ko mo'karon anemeparykon mo'karon uwapoto'san wyka'san wara e'i'pa nandon? Asainaty'pa kore nendamejaton, ran!” ");
INSERT INTO car_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesus wyka'po te i'waine: “Iporo ro imero Jesaja 'wa Tamusi auran tuku'po tywaije man, moro opangon tonapiramon poko ero wara imerory jako ty'wa: Mojan ero ponokon yjety awongaton tyndarykon ke roten. Ituru'san te tyse man ywyino. ");
INSERT INTO car_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Typo roten moro yjety awongaton. Kari'na wykato'konymbo roten ekari'saton kari'na emepato'kon me. ");
INSERT INTO car_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Mo'ko Tamusi wykatopombo mematon. Mo'karon uwapoto'san wykato'konymbo wara te ko'wu maijaton.” ");
INSERT INTO car_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ika'po noro i'waine: “Iru'pyn me pore man moro Tamusi wykatopombo mematon, mo'karon uwapoto'san wykato'konymbo wara awaito'ko'me. ");
INSERT INTO car_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses waty tyka nan: ‘Ajumy, asano inendoko. Mo'ko tyjumy, tysano ejunen rombyry man.’ ");
INSERT INTO car_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amyjaron te mykaton: ‘Amy wykary jako tyjumy 'wa, tysano 'wa pai: ‘Pa'poro ajepano'to'kon manombo y'wa, korban moro man’ ’ - moro tauro'po man: Tamusi 'wa tymy moro man - ");
INSERT INTO car_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ma'kotojaton terapa moro tyjumy, tysano epanopyry i'wa. ");
INSERT INTO car_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Moro wara ro moro Tamusi wykatopombo mirupomangaton, moro uwapoto'san wykato'konymbo ekarityry ke o'waine o'makon 'wa. Pyime moropangon otykon mika'saton.” ");
INSERT INTO car_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Irombo mo'karon kari'na apyimy ko'ma'po mero rapa ty'wa, ika'po i'waine: “Pa'poro epanamatoko y'wa. Uku'toko o'to ywykary. ");
INSERT INTO car_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Amy pairo indary taka o'mytoto oty kari'na anany'ma'pa man. Morokon indary wyino o'tonon otykon te kari'na any'manon.” ");
INSERT INTO car_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Irombo mo'karon kari'na apyimy wyino auto taka iwo'my'po mero, mo'karon inemeparykon woturupo'san i'wa, moro inekarity'po onumengatopo auranano poko. ");
INSERT INTO car_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ika'po i'waine: “Amyjaron ro rypo ka'tu onumenga'pa mandon? Anukuty'pa mandon, moro indaka o'mytoto oty wairy kari'na anany'ma'pa? ");
INSERT INTO car_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Moro arepa ituru'po taka ito'pa man. Uwembo taka te kyny'san. Moro wyino ro kurandonaka rapa kyno'san.” Iwara te Jesus 'wa pa'poro tanapymy oty wairy ekarity'po iru'pa. ");
INSERT INTO car_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Irombo ika'po: “Morokon indary wyino o'tonon otykon te kari'na any'manon. ");
INSERT INTO car_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mo'karon kari'na turu'san wyino irombo morokon yja'wangon onumengano kyno'san kurandonaka. Tyturu'san ta kynonumengaton wararo woryijan maro, wokyryjan maro tywairykon poko, mona poko, kari'na wory poko, ");
INSERT INTO car_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","taporitonone aino any'mary poko, tykumingon poko, yja'wan me aino poko, amu'mano poko, yja'wangon omenano poko, tamynykon poko, ojuno poko, ta'sakarykon ko'po tywairykon poko, to'merepyrykon kapyry poko. ");
INSERT INTO car_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Pa'poro erokon yja'wangon otykon koro'na wyino kurandonaka kyno'san. Morokon ro kari'na any'manon.” ");
INSERT INTO car_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Irombo Jesus awomy'po. Moro wyino Tyrus wyinonaka terapa ito'po. Moro po ro amy auto taka iwo'my'po. Amy 'wa moro po tywairy ukutyry 'se'pa kynakon. Tywotunemyry upi'po te i'wa. ");
INSERT INTO car_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Irombo te o'win wytory amy woryi 'wa ekary eta'po. Emyiry'membo amy yja'wan akywano pe kynakon. Jesus 'wa tywopy'po mero, tokuna'po iwoma'po ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Amy Griek woryiry mo'ko kynakon, amy Syro-Fenisia po oma'po. Irombo Jesus 'wa iwe'pima'po mo'ko yja'wan akywano momato'me i'wa mo'ko tamyiry wyino. ");
INSERT INTO car_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Irombo ika'po i'wa: “Mo'karon pitanikon aimeporykon na'sen man. Yja'wan me man mo'karon pitanikon ereparymbo pinary, mo'karon pero upato'me ike.” ");
INSERT INTO car_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Mo'ko woryi wyka'po te I'wa: “Jopoto, mo'karon pero pairo moro endametopo upi'no mo'karon pitanikon erepary putuku'san ena'saton.” ");
INSERT INTO car_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Irombo ika'po mo'ko woryi 'wa: “Moro wara ajaurana'po ke, i'tango ajauty 'wa. Mo'ko yja'wan akywano ajemyiry wyino nepa'kai terapa.” ");
INSERT INTO car_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Irombo tauty 'wa tytunda'po mero, mo'ko amyija'ko epory'po i'wa tapapo tywo'ny'topo tu'po. Mo'ko yja'wan akywano tyto kynakon iwyino. ");
INSERT INTO car_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Irombo moro Tyrus wyino tytory jako rapa, moro Sidon yinonory tu'po, irombo moro Dekapolis yinonory tu'po ito'po moro Galilea tano tuna juwembory 'wa. ");
INSERT INTO car_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Irombo amy ipanapyn enepy'po i'waine I'wa. Erupo'pa enapa kynakon mo'ko ipanapyn. Irombo iwe'pima'san I'wa tainary yto'me I'wa itu'ponaka. ");
INSERT INTO car_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Irombo Jesus 'wa mo'karon kari'na apyimy wyino aro'po, typo terapa imaro tywaito'me. Irombo morokon ipanary taka morokon tainary siky'iry yry'po i'wa. Irombo eta'ta'po. Morombo mero moro inuru y'tu'ka'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Irombo kapu 'wa iwo'poty'po. Poto me imero iworekama'po. Irombo ika'po i'wa: “Efata!”. “Otapurumakako!” tauro'po man moro. ");
INSERT INTO car_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Irombo morokon ipanary wotapurumaka'san o'win wytory. Iru'pa rapa moro inuru we'i'po. Iru'pa rapa aurana'po. ");
INSERT INTO car_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Irombo Jesus wyka'po i'waine, amy pairo 'wa anekarity'pa iwaito'ko'me. Moro Jesus auran te kynypojatokon 'ne ka'tu rapa. Moro ko'po 'ne katu rapa imero kynekari'satokon. ");
INSERT INTO car_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iwe'naranga'san imero. Ika'san: “Pa'poro oty iru'pa tyje i'wa man. Ipana'non panatano'pojan ro rypo rapa. Erupo'non erupotano'pojan rapa.” ");
INSERT INTO car_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Amy jako rapa, pyime rapa kari'na tywota'nano'se kynatokon. Erepa'ma iwairykon ke, Jesus 'wa mo'karon tynemeparykon ko'ma'san. Irombo ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Mo'karon pyimano kari'na kotanory seneja. Oruwa kurita terapa yjekosa mandon erepa'mambo. ");
INSERT INTO car_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Uwembotary'pa emoky'sando rapa y'wa autykon 'wa, oma ta kynirupomanda'ton. Amykonymbo tysembo tywo'se mandon.” ");
INSERT INTO car_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Irombo mo'karon inemeparykon 'wa ejuku'po: “Oje ko arepa kysepota'ton ero iponomyn po mojan pyimano kari'na waimeto'me?” ");
INSERT INTO car_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Irombo Jesus woturupo'po i'waine: “O'toro perere ko ajekosaine nan?” Ika'san: “Oko-to'ima.” ");
INSERT INTO car_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Irombo mo'karon pyimano kari'na 'wa ika'po, nono tu'po iwotandy'moto'ko'me. Irombo morokon oko-to'ima perere anumy'po i'wa. Irombo Tamusi ety awonga'po i'wa. Morombo mero i'sakapoty'po i'wa. Irombo mo'karon tynemeparykon 'wa yry'po i'wa, mo'karon ata'nanopy'san upato'me i'waine. Irombo mo'karon inemeparykon 'wa upa'san. ");
INSERT INTO car_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Amykon enapa woto'makon ekosaine kynatokon. Irombo Tamusi ety awonga'po mero ty'wa ipoko, Jesus wyka'po mo'karon tynemeparykon 'wa, mo'karon woto ke enapa mo'karon kari'na upato'me. ");
INSERT INTO car_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Irombo iwendame'san. Iwaime'san. Irombo oko-to'ima kurukuru moro arepa akosinymbo amo'iky'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Okupa'en dusun me iwairy taro mo'karon kari'na kynatokon. Irombo emoky'san rapa i'wa. ");
INSERT INTO car_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Morombo wyino o'win wytory iwotaru'ka'po moro kurijara taka mo'karon tynemeparykon maro. Irombo ito'po Dalmanuta pato. ");
INSERT INTO car_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Irombo mo'karon Farise wopy'san Jesus weto. Irombo imaro taurangon ejukuru a'mo'po i'waine. U'kuto'me iwoturupo'san i'wa, amy kapu wyinono oty enepoto'me i'wa. ");
INSERT INTO car_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Irombo poto me imero Jesus worekama'po. Ika'po: “O'tono'me ko mo'karon eromenokon amy kapu wyinono oty enery 'se 'ne ka'tu nandon? Ita'ro pore, mo'karon eromenokon amy kapu wyinono otymbo ro anene'pa pairo kynaita'ton!” ");
INSERT INTO car_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Irombo ino'san i'wa. Iwotaru'ka'po rapa moro kurijara taka. Irombo iwepato'po koposenaka. ");
INSERT INTO car_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Irombo te mo'karon Jesus nemeparykon tytuwarenge'se kynatokon perere arory poko tymaroine. O'win roten perere amy ekosaine kynakon moro kurijara ta. ");
INSERT INTO car_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Irombo Jesus 'wa e'ma'san. Ika'po: “Tuwaro koro aitoko mo'karon Farise 'wa perere uwapurotopo pona, mo'ko Herodes 'wa perere uwapurotopo pona enapa.” ");
INSERT INTO car_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Irombo ase'wa iworupa'san moro iperere'pa tywairykon poko. ");
INSERT INTO car_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Moro ukuty'po mero, Jesus wyka'po i'waine: “O'tono'me ko moro iperere'pa awairykon poko morupaton? Oty anukuty'pa noro ka'tu mandon? Anene'pa ka'tu maiton? Tyturu'poja'nare ka'tu mandon? ");
INSERT INTO car_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Tanuke awairykon se'me oty anene'pa mandon? Typanake awairykon se'me oty aneta'pa mandon? ");
INSERT INTO car_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Muta'katon terapa ka'tu morokon ainatonenombo perere y'sakapoty'pombo y'wa mo'karon ainatone dusun kari'na 'wa. O'toro kurukuru ko moro akosinymbo mamo'i'sen?” Irombo ika'san I'wa: “Ainapatoro itu'ponaka oko.” ");
INSERT INTO car_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Morokon oko-to'imanombo perere y'sakapoty'pomboto y'wa mo'karon okupa'en dusun kari'na 'wa, o'toro kurukuru ko moro akosinymbo mamo'i'sen?” Irombo ika'san i'wa: “Oko-to'ima.” ");
INSERT INTO car_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Irombo ika'po i'waine: “Ise'me roten oty anukuty'pa noro mandon?” ");
INSERT INTO car_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Irombo Betsaida 'wa itunda'san. Moro po ro amy enupyn enepy'po i'waine I'wa. Iwe'pima'san i'wa mo'ko enupyn y'tu'kato'me i'wa. ");
INSERT INTO car_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Irombo Jesus 'wa mo'ko enupyn apo'i'po ainary poko. Kurandonaka aro'po i'wa moro aitopo wyino. Irombo mo'ko wokyry enuru taka eta'ta'po. Tainary yry'po i'wa itu'ponaka. “Oty menejan?” iwoturupo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Mo'ko enupyn enuta'po. Irombo ika'po: “Kari'na ro rypo seneja. Wewe wytopotyrykon wara te senejaton.” ");
INSERT INTO car_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","O'wimboto ro'kon tainary yry'po i'wa moro enuru tu'ponaka. Irombo enu'kyi'ma imero iwo'poty'po. Iwekura'ma'po. Pa'poro rapa oty ene'po i'wa iru'pyn me. ");
INSERT INTO car_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Irombo auty 'wa emoky'po Jesus 'wa. Ika'po: “Moro aitopo taka te kyton rapa.” ");
INSERT INTO car_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Irombo te Jesus wyto'po mo'karon tynemeparykon maro morokon Sesarea Filipi patonokon siky'inon aito'kon 'wa. Oma ta mo'karon tynemeparykon 'wa iwoturupo'po: “Noky me ko yjekari'saton mo'karon kari'na?” ");
INSERT INTO car_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Irombo ejuku'po i'waine: “Mo'ko kari'na etykanenymbo Johanes me. Amykonymbo te ajekari'saton Elia me. Amykonymbo rapa ajekari'saton amy uwaponombo Tamusi auran uku'ponenymbo me.” ");
INSERT INTO car_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Irombo iwoturupo'po i'waine: “Amyjaron rapa, noky me ko kakari'saton?” Petrus 'wa ejuku'po. Ika'po i'wa: “Mo'ko Mesias amoro mana.” ");
INSERT INTO car_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Irombo Jesus 'wa e'ma'san amy erupary pona i'waine typoko. ");
INSERT INTO car_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Irombo mero emeparykon a'mo'po i'wa. Ika'po: “Mo'ko kari'na ymuru wota'karykary imero man. Mo'karon uwapoto'san 'wa, mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Tamusi karetary uku'namon 'wa emary man. Iwory man i'waine. Irombo oruwa kurita pa'po me awomyry rapa man.” ");
INSERT INTO car_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Enari'ma imero moro wara ika'po. Irombo Petrus 'wa typo terapa aro'po. Irombo e'mary a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus wotu'ma'po te. Mo'karon tynemeparykon 'wa iwo'poty'po. Irombo apo'tun pe imero Petrus e'ma'po i'wa. Ika'po: “Omimako ywyinombo, Satan! Tamusi 'wa kapyn awonumengary man, kari'na 'wa te!” ");
INSERT INTO car_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Irombo mo'karon kari'na apyimy ko'ma'po i'wa ty'wa, mo'karon tynemeparykon maro. Ika'po i'waine: “Ywena'po ta tywopyry 'se amy a'ta, aseke typoko ituwarengepyry man. Ywara enapa moro tywakapuru anumyry i'wa man. Irombo mero iwopyry man ywena'po ta. ");
INSERT INTO car_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mo'ko tamamyry aijomary 'san moro tamamyrymbo uta'katan. Mo'ko yjupu'po me, moro iru'pyn oka upu'po me enapa tamamyry uta'kanenymbo te moro tamamyry epotan. ");
INSERT INTO car_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Otypan iru'pyn oty epotan ko amy kari'na, pa'poro ero nono tu'pono oty apo'i'poto ty'wa, irombo aseke moro tamamyrymbo uta'ka'poto ty'wa? ");
INSERT INTO car_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Otypan oty ytan pai ko moro tamamyry y'petakan me? ");
INSERT INTO car_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ypoko, yjauranymbo poko enapa amy wepy'i'to'poto mojan taporitonokon nonamon ra'na, mojan tyja'wangamon ra'na, mo'ko kari'na ymuru kynepy'i'totan enapa ipoko, tyjumy kuranory ta tywopyry jako mo'karon kapu tanokon Tamusi apojongon maro.” ");
INSERT INTO car_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Irombo ika'po i'waine: “Ita'ro pore, amykonymbo ero po o'po'tonon iromby'pa kynaita'ton moro pori'tonano maro moro Tamusi nundymary wopyry enery uwaporo ty'waine.” ");
INSERT INTO car_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","O'win-to'ima kurita pa'po me Jesus 'wa Petrus, Jakobus, Johanes aro'san tymaro amy kawono wypy tu'ponaka. Moro po a'saka'pa kynatokon. Irombo inenerykon mero iwonurima'po. ");
INSERT INTO car_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tamu'ne imero moro iwo'my we'i'po, typotyre imero. Amy pairo wo'mynano sa'wonen moro wara wo'mynano amu'nory upijan. ");
INSERT INTO car_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Irombo Elia wosenepo'po i'waine Moses maro. Jesus maro kynorupatokon. ");
INSERT INTO car_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Irombo Petrus wyka'po Jesus 'wa: “Na'na emepanen, ka'ety ero po na'na man. Oro na'na oruwa pataja'makon amyn, o'wa o'win, Moses 'wa o'win, Elia 'wa o'win enapa.” ");
INSERT INTO car_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","O'to tykary anukuty'pa kynakon, poto me tywety'ka'san ke. ");
INSERT INTO car_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Irombo amy kapurutu wopy'po eponakaine. Moro kapurutu wyino ro amy auranano wota'po: “Mo'se, nipynen ymuru mo'se man. Epanamatoko i'wa.” ");
INSERT INTO car_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Irombo moro tywotu'ma'sando typo roten Jesus roten tera'a ene'po i'waine tokosaine. ");
INSERT INTO car_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tywony'torykon jako rapa moro wypy wyino, ika'po mo'karon tynemeparykon 'wa, amy pairo kari'na 'wa moro tynene'san oty anekarity'pa iwaito'ko'me, mo'ko kari'na ymuru awomyry uwaporo rapa iromby'san wyino. ");
INSERT INTO car_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Moro auranymbo kura'ma'po i'waine tyturu'san ta. Ase'wa roten te o'to tauro'po me moro iromby'san wyino rapa awono wairy poko kynorupatokon. ");
INSERT INTO car_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Irombo iwoturupo'san i'wa: “O'tono'me ko mo'karon Tamusi karetary uku'namon nykaton: ‘Elia na'nen kyno'tan.’?” ");
INSERT INTO car_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Irombo ika'po i'waine: “Elia na'nen ro kyno'tan, pa'poro otykon yje rapa iru'pa. O'tono'me ko iro ke tymero nan mo'ko kari'na ymuru wota'karykary man, moro uwam'pono me yry man enapa? ");
INSERT INTO car_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wykaje te o'waine: Elia tywo'se terapa man. Irombo tynisanorykon tyka'se i'waine man imaro, ipoko imero'po wara ro.” ");
INSERT INTO car_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Irombo mo'karon tynemeparykon a'sakarykon 'wa rapa tywopyrykon jako, moky imero kari'na 'wa u'memy'san ene'po i'waine. Amykon Tamusi karetary uku'namon taurangon eju'satokon imaroine. ");
INSERT INTO car_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Irombo Jesus ene'po mero, pa'poro mo'karon kari'na apyimy enuta'po imero. Irombo o'win wytory iwopy'san i'wa, “Mondo ro rypo man?” tykato'ko'me i'wa. ");
INSERT INTO car_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Irombo Jesus woturupo'po tynemeparykon 'wa: “Oty poko ko imaroine ajaurangon meju'saton?” ");
INSERT INTO car_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Irombo o'win amy ira'nanokon 'wa ejuku'po: “Amepanen, ymuru senepyi o'wa. Amy yja'wan akywano aurana'pa kynenanon. ");
INSERT INTO car_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Apyiry wararo ty'wa, kynuwa'mojan. Indary kyna'kosatanon. Tyjery kyjan. Irombo kynija'natanon. Mo'karon anemeparykon 'wa rypo waturupoi, mo'ko akyrymbo momato'me i'waine iwyino. Imomary upiton te.” ");
INSERT INTO car_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Irombo Jesus 'wa ejuku'san: “Na, oty anamyika'non pore kari'na, ran! O'toro kurita noro ko ajekosaine waitan? O'toro kurita noro ko ero wara awairykon sapyitan? Mo'ko myre'ko'ko ene'toko y'wa.” ");
INSERT INTO car_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Irombo mo'ko myre'ko'ko enepy'po i'waine I'wa. Mo'ko akyry 'wa Jesus ene'po mero, o'win wytory imero mo'ko myry'ko'ko apyipo'po i'wa wa'jo'pan 'wa. Sakau taka mo'ko myre'ko'ko woma'po. Ta'kosare imero kynoturingapo'sakon. ");
INSERT INTO car_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Irombo Jesus woturupo'po ijumy 'wa: “Akore'pe terapa ero oty pe nan?” ");
INSERT INTO car_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Irombo mo'ko ijumy wyka'po: “Pitani me iwe'i'po poro. Pyimemboto terapa wa'to taka kyneman rypo, tuna taka enapa, iromo'kato'me. Amy oty kapyry taro te aja'ta, na'na epano'ko. Na'na kotanory eneko.” ");
INSERT INTO car_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Irombo Jesus wyka'po i'wa: “ ‘Ikapyry taro aja'ta’ mykanon? Mo'ko Tamusi amyikanen 'wa pa'poro oty tywo'kapyry taro man.” ");
INSERT INTO car_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","O'win wytory mo'ja imero mo'ko myre'ko'ko jumy wyka'po: “Tamusi ro rypo samyikaje. Kapano'ko, ru'me ro rypo a'si 'ko yja'ta!” ");
INSERT INTO car_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Irombo mo'karon kari'na apyimy wopyry ene'po mero ty'wa, pari'pe imero Jesus 'wa mo'ko myre'ko'ko tu'ponombo yja'wan akywano moma'po: “Amoro aurana'pa, ipana'pa kari'na ynen akywano, wykaje o'wa: epa'kako mo'se myre'ko'ko wyino. Itaka noro kytopyi.” ");
INSERT INTO car_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Irombo mo'ko myre'ko'ko apyipo'po mero ty'wa wa'jo'pan 'wa, tyko'ke iwepa'ka'po iwyino. Akepy wara imero mo'ko myre'ko'ko we'i'po. Pyime mo'karon kari'na wyka'san: “Nirombyi terapa.” ");
INSERT INTO car_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesus 'wa te ainary poko apo'i'po. Awonga'po i'wa. Irombo mo'ko myre'ko'ko awomy'po. ");
INSERT INTO car_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Irombo auto taka Jesus wo'my'po mero, typo terapa mo'karon inemeparykon woturupo'san i'wa: “O'tono'me ko imomary upi na'na?” ");
INSERT INTO car_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Irombo ika'po i'waine: “Mo'kopan akywano momary mupija Tamusi 'wa aurana'pa aja'ta.” ");
INSERT INTO car_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Irombo moro wyino mo'ja ro ito'san moro Galilea yinonory tu'po. Amy kari'na 'wa pairo uku'pory 'se'pa Jesus kynakon, ");
INSERT INTO car_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","mo'karon tynemeparykon emepary ke ty'wa. Ika'po i'waine: “Mo'ko kari'na ymuru yta'ton mo'karon kari'na ainaka. Mo'karon ro kyniwota'ton. Oruwa kurita tywo'po wyino te kynawondan rapa.” ");
INSERT INTO car_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","O'to tauro'po me te moro auranano wairy anukuty'pa kynatokon. I'wa tywoturuporykon poko enapa tanarike kynatokon. ");
INSERT INTO car_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Irombo Kafaraum 'wa itunda'san. Auto 'wa tytunda'po mero iwoturupo'po i'waine: “Oty poko 'ne ko morupaton moro oma ta?” ");
INSERT INTO car_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Anejuku'pa te iwe'i'san, oma ta ase'wa tyworupa'san ke, nokypan wairy poko poto me 'ne tyra'naine. ");
INSERT INTO car_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Irombo Jesus wotandy'mo'po. Mo'karon ainapatoro itu'ponaka oko tynemeparykon ko'ma'san i'wa. Ika'po i'waine: “Ta'sakary ko'po poto me tywairy 'se amy a'ta, wena'po ta imero iwairy man, pa'poro ta'sakarykon pyitory me.” ");
INSERT INTO car_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Irombo amy pitani yry'po i'wa owarira'naka. Irombo ewa'mary mero ty'wa, anumy'po i'wa tapoponaka. Ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mo'ko yjety ta mo'sepan pitani ewa'manen yjewa'manon. Mo'ko yjewa'manen te yjewa'ma'pa man. Mo'ko yjemo'nenymbo ewa'manon te.” ");
INSERT INTO car_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Irombo Johanes wyka'po I'wa: “Na'na emepanen, na'na amy kari'na 'wa ajety ta yja'wangon no'kan momary enei. Irombo a'kotory poko rypo na'na ne'kui, kywena'san ta ito'pa iwairy ke.” ");
INSERT INTO car_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesus wyka'po te: “Kysa'kototon. Mo'ko yjety ta amy pori'tonano eneponen ko'i 'ne yja'wan me tauranary upitan ypoko. ");
INSERT INTO car_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mo'ko kyjenonopy'paine aitoto irombo kywyinonokon me man. ");
INSERT INTO car_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ita'ro pore, mo'ko saperamembo ta roten tuna ke ajupanamon mo'ko Mesias wyinonokon me awairykon ke, tapety anapo'i'pa e'i'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Mo'ko yja'wan taka o'win mo'sepan yjamyikanen pitani emaponenymbo emary iru'pa 'ne ka'tu rapa man parana taka, taneka'to amy poto 'su oty ami'topo topu ke. ");
INSERT INTO car_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Yja'wan taka moro ajainary 'wa ajemapory jako, i'kotoko. O'win roten ajainary maro awytory moro i'matypyn roten amano taka iru'pa 'ne ka'tu rapa man moro okororo ajainary maro moro i'matypyn roten ata'karykatopo taka awytory ko'po, moro e'wutypyn roten wa'to taka awytory ko'po. ");
INSERT INTO car_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Yja'wan taka moro apupuru 'wa ajemapory jako, i'kotoko. Syky'ta me moro i'matypyn roten amano taka awytory iru'pa 'ne ka'tu rapa man moro okororo apupuru maro moro i'matypyn roten ata'karykatopo taka ajemary ko'po. ");
INSERT INTO car_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Yja'wan taka moro ajenuru 'wa ajemapory jako, ikako. O'win ajenuru maro moro Tamusi nundymary taka awytory iru'pa 'ne ka'tu rapa man okororo ajenuru maro moro i'matypyn roten ata'karykatopo taka ajemary ko'po. ");
INSERT INTO car_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Moro po ro mo'karon ononamon oruko i'maty'pa roten mandon. Moro po ro moro wa'to e'wuty'pa roten man. ");
INSERT INTO car_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Pa'poro kari'na wajo'tory man wa'to ke. ");
INSERT INTO car_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wajo, iru'pyn oty moro man. Moro iposinymbo wyto'ma'poto te, oty ke noro ko miposinota'ton? Iro ke ro wajo pe awairykon man. Ase'wa enapa sara'me ajemandoko.” ");
INSERT INTO car_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Irombo Jesus awomy'po moro wyino. Moro Judea yinonory 'wa terapa ito'po, moro Jordan koposeno nono tupo. Mo'karon kari'na apyimy wota'nanopy'san rapa i'wa. Tamerymbo mero emepa'san rapa i'wa. ");
INSERT INTO car_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Irombo amykon Farise wopy'san I'wa. Ero wara iwoturupo'san i'wa, u'kuto'me: “Iru'pa nan amy wokyry 'wa typyty nondary?” ");
INSERT INTO car_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Irombo Jesus 'wa ejuku'san. Ika'po: “O'to ko Moses tyka nan o'waine moro poko?” ");
INSERT INTO car_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Irombo ika'san: “Moses ino 'wa kyninondapojan, amy ainondatopo kareta mero'poto mo'ko wokyry 'wa.” ");
INSERT INTO car_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesus wyka'po te i'waine: “Tyturu'poja'nare awairykon ke moro wara tymero i'wa man. ");
INSERT INTO car_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Koromo ero nono kapyry jako te, “Tamusi 'wa wokyry me, woryi me kari'na tyka'se man. ");
INSERT INTO car_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Iro ke ro amy wokyry tyjumy, tysano notan. Typyty maro kynotapyitan. ");
INSERT INTO car_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Irombo mo'karon okonokon kari'na o'win ja'munano kynaita'ton.” “Iwara te oko noro e'i'pa mandon. O'win te mandon. ");
INSERT INTO car_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Iro ke ro mo'karon Tamusi napyipo'san nondapory kapyn man kari'na 'wa.” ");
INSERT INTO car_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Irombo auto 'wa tytunda'san mero rapa, mo'karon inemeparykon woturupo'san rapa i'wa moro ikatopombo poko. ");
INSERT INTO car_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Irombo ika'po i'waine: “Amy typyty nondanenymbo 'wa amy terapa apyiry jako, mo'ko koromono typyty maro tywairymbo any'manon. ");
INSERT INTO car_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Amy tyino nondanenymbo 'wa amy terapa apyiry jako, mo'ko koromono tyino maro tywairymbo any'manon.” ");
INSERT INTO car_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Irombo pitanikon enepy'san i'waine I'wa, apyito'ko'me I'wa. Mo'karon inemeparykon 'wa te mo'karon ene'namon e'ma'san. ");
INSERT INTO car_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Moro ene'po mero, Jesus wore'ko'po. Ika'po i'waine: “Oro tyre mo'karon pitanikon no'sen y'wa. Kysa'kototon. Mo'kopangon 'wano me ro moro Tamusi nundymary man. ");
INSERT INTO car_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ita'ro pore, amy pitani'membo wara moro Tamusi nundymary anewa'ma'pa amy kari'na a'ta, itaka o'my'pa pairo kynaitan.” ");
INSERT INTO car_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Irombo mo'karon pitanikon anumy'san i'wa tapoponaka. Tainary yry'po i'wa itu'ponakaine. Ikuranondo'san i'wa. ");
INSERT INTO car_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Irombo oma ta Jesus wytory jako rapa, taka'ne imero amy wokyry wopy'po i'wa. Irombo ipo'ponaka tokuna'po iwoma'po. Iwoturupo'po: “Iru'pyn amepanen, o'to ko ywairy nan, moro i'matypyn roten amano epoto'me y'wa?” ");
INSERT INTO car_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Irombo Jesus wyka'po i'wa: “O'tono'me ko iru'pyn me kajatojan? Amy kari'na pairo iru'pa e'i'pa man. Tamusi roten iru'pa man. ");
INSERT INTO car_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Erokon Tamusi wykato'konymbo muku'sa terapa: Woto kyte'i. Taporitonone aino kysany'mai. Amonatai. Onapi ke amy oty kysamyikapoi. Aja'sakary kysimonatoi. Ajumy, asano inendoko.” ");
INSERT INTO car_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Irombo mo'ko wokyry wyka'po I'wa: “Amepanen, pa'poro morokon wara ro waija, pitani me yja'tanombo poro.” ");
INSERT INTO car_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Irombo Jesus wo'poty'po i'wa. Ipyna'po i'wa. Irombo ika'po i'wa: “O'win amy oty ro'kon mamono'sa. Pa'poro ajotyrykonymbo ekaramatango. Moro epetymbo yko mo'karon oty'non 'wa. Iwara totyke imero maitake kapu ta. Irombo o'ko 'ne ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Moro eta'po mero mo'ko wokyry embatary we'petakama'po. Kata'mato terapa ito'po, pyime imero totyry wairy ke. ");
INSERT INTO car_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Irombo Jesus wo'poty'po wararo mo'karon tynemeparykon 'wa. Irombo ika'po i'waine: “Tupi me pore man mo'karon totykamon wytory moro Tamusi nundymary taka.” ");
INSERT INTO car_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Moro auran 'wa imero mo'karon inemeparykon enumengapo'san. Jesus wyka'po te i'waine rapa: “Y'makon, tupi me pore man moro Tamusi nundymary taka ytono. ");
INSERT INTO car_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Amy totyken kari'na wo'myry moro Tamusi nundymary taka tupi me man amy kameri wo'myry ko'po amy akusa enuru taka.” ");
INSERT INTO car_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Poto me 'ne ka'tu rapa iwonumenga'san. Ika'san ase'wa: “Noky ko iro ke uta'no wyino tunemyry taro nan?” ");
INSERT INTO car_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesus wo'poty'po i'waine. Irombo ika'po: “Moro kari'na eko'sa tywokapyry upijan. Tamusi eko'sa te kynoka'san. Tamusi eko'sa irombo pa'poro oty tywokapyry taro man.” ");
INSERT INTO car_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Irombo Petrus wyka'po I'wa: “Eneko, na'na pa'poro totyrykonymbo ynoi, awena'po ta tytoto'me.” ");
INSERT INTO car_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Irombo Jesus wyka'po: “Ita'ro pore, mo'ko yjupu'po me, moro iru'pyn oka upu'po me enapa tauty, typiryjan pai, tanaunan pai, tysano pai, tyjumy pai, ty'makon pai, tymainarykonymbo pai nojan ");
INSERT INTO car_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","inoro ero nono tu'po ainatone-kari'namboto moro ko'po 'ne ka'tu rapa oty apyitan, tywory sanory ta kari'na 'wa tywekenapotyry se'me. Irombo moro aireno nono tu'po moro i'matypyn roten amano apyitan. ");
INSERT INTO car_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pyime uwaponokonymbo te wena'po tanokon me kynaita'ton. Pyime wena'po tanokonymbo uwaponokon me kynaitaton.” ");
INSERT INTO car_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Irombo oma ta Jerusalem 'wa kynonu'satokon. Jesus uwapoine kyny'sakon. Mo'karon inemeparykon imero poto me kynonumengatokon. Mo'karon iwekenanamon kari'na ko'wu tanarike kynatokon. Irombo mo'karon ainapatoro itu'ponaka oko tynemeparykon ko'ma'san rapa i'wa typo. Erupa'san i'wa, otypan oty 'wa topory man poko. ");
INSERT INTO car_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Enetoko!” ika'po. “Jerusalem 'wa kytonu'saton. Moro po ro mo'ko kari'na ymuru yta'ton mo'karon Tamusi pokonokon jopotorykon ainaka, mo'karon Tamusi karetary uku'namon ainaka enapa. Mo'karon ro a'wembono auranano yta'ton iwoto'me. Irombo mo'karon Simosu me e'i'non ainaka kynyta'ton. ");
INSERT INTO car_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Irombo ipoko kynosaijambata'ton. Itu'ponaka kyneta'tapo'ta'ton. Kynipoky'mata'ton. Irombo kyniwota'ton. Oruwa kurita pa'po me te kynawondan rapa.” ");
INSERT INTO car_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Irombo mo'karon Sebedeus y'makon Johanes, Jakobus wopy'san I'wa. Ika'san: “Amepanen, amy oty poko na'na woturupo'poto, na'na rypo takataka ikapyry 'se o'wa man.” ");
INSERT INTO car_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Irombo ika'po i'waine: “Oty kapyry 'se ko mandon y'wa ajekatakaine?” ");
INSERT INTO car_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Irombo ika'san I'wa: “Na'na 'wa oma yko, na'na wotandy'moto'me ajaporito, kurano me awe'i'poto: o'win amy ajapo'tun wyino, o'win amy ajapojery wyino.” ");
INSERT INTO car_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesus wyka'po te i'waine: “O'to awykarykon anukuty'pa mandon. Moro je'tun pan ysaperary tano enyry taro 'kare mandon. Moro ywota'karykary wara 'kare awota'karykarykon taro mandon.” ");
INSERT INTO car_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Irombo ika'san I'wa: “A'a, moro wara tywairy taro na'na man.” Irombo Jesus wyka'po i'waine: “Moro ysaperary tano menyta'ton enapa. Moro ywota'karykary wara enapa mata'karykata'ton. ");
INSERT INTO car_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Yjapo'tun wyino te, yjapojery wyino pai, ajandy'moporykon supija. Morokon aito'kon taporemyndo terapa man.” ");
INSERT INTO car_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Irombo mo'karon amykon terapa ainapatoro inemeparykon 'wa eta'po. Iwore'ko'san imero Jakobus poko, Johanes poko enapa. ");
INSERT INTO car_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Irombo Jesus 'wa iko'ma'san ty'wa. Ika'po i'waine: “Muku'saton waty mo'karon ‘jopoto’ ikato'kon 'wa mo'karon ta'sakarykon jopotomary, mo'karon tykakamon waijopotomary ira'naine? ");
INSERT INTO car_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Moro wara kapyn iwairy man ara'naine. Poto me tywairy 'se amy a'ta ara'naine, ta'sakary tomosiry me iwairy man. ");
INSERT INTO car_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Uwapono me tywairy 'se amy a'ta ara'naine, mo'ko wairy man pa'poro ta'sakarykon pyitory me. ");
INSERT INTO car_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mo'ko kari'na ymuru enapa tytomosike aije opy'pa tywaije man. Kari'na tomosiry me te tywo'se man, romo'se pyimano kari'na y'petakan me.” ");
INSERT INTO car_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Irombo Jesus tunda'po Jeriko 'wa mo'karon tynemeparykon maro. Moro Jeriko wyino itorykon jako rapa amy kari'na apyimy maro, oma esi'wo mo'ko Timeus ymuru Bartimeo, amy enupyn epataimatoto, tandy'po kynakon. ");
INSERT INTO car_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Typato mo'ko Nasaret pono Jesus wytory eta'po mero ty'wa, tyko'tary a'mo'po i'wa: “David parymbo, Jesus! Ykotanory eneko to!” ");
INSERT INTO car_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Irombo pyime kari'na 'wa e'mapoty'po, ity'nato'me. Mo'ja 'ne ka'tu rapa te iko'tapoty'po: “David parymbo, ykotanory eneko to!” ");
INSERT INTO car_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Irombo Jesus poropy'po. Ika'po: “Iko'matoko y'wa.” Irombo mo'ko enupyn ko'ma'po i'waine. Ika'san i'wa: “Aturu'po apyiko. Ajawongo. Ako'manon.” ");
INSERT INTO car_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Irombo tynoponymbo ema'po i'wa. Ta'po'ne imero awomy'po. Irombo ito'po Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesus wyka'po i'wa: “O'to ko ywairy 'se man ajekataka?” Irombo mo'ko enupyn wyka'po I'wa: “Jopoto, oro wo'po'nen rapa!” ");
INSERT INTO car_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Irombo Jesus wyka'po i'wa: “I'tango. Moro o'wa Tamusi amyikary akura'mai.” Irombo o'win wytory enuru we'i'po iru'pa rapa. Irombo oma ta Jesus wena'po ta ito'po. ");
INSERT INTO car_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Irombo tyse waty Jerusalem wyino tywe'i'san mero, moro oleif paty wypy patonokon aito'kon Betfage, Betania 'wa itunda'san. Moro po ro Jesus 'wa oko amykon tynemeparykon apojoma'san. ");
INSERT INTO car_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ika'po i'waine: “Moro ajuwaponokon aitopo'membo 'wa i'tandoko. Moro aitopo 'wa awo'myrykon po'takaro amy parito'membo my'po mepota'ton. Tywe'i'po poro mo'ko parito'membo amy kari'na anaro'pa noro man tynga'nary tu'po. Imbokatoko me. Irombo ene'toko me ijaro 'wa. ");
INSERT INTO car_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Irombo amy kari'na woturupo'poto o'waine: ‘O'to ko maijaton?’ kaitoko me i'wa: ‘Mo'ko Jopoto i'se man. O'win wytory ijaro 'wa rapa kynene'potan.’ ” ");
INSERT INTO car_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Irombo ito'san. Mo'ko parito'membo my'po epory'po i'waine amy auto penary po kurando, oma esi'wo. Imboka'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Irombo amykon moro po o'po'tonon wyka'san i'waine: “O'tono'me ko mo'ko parito'membo mimbokaton?” ");
INSERT INTO car_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Irombo Jesus wyka'po wara ro ika'san i'waine. Irombo ipokoine noro e'i'pa mo'karon o'po'tonon we'i'san. ");
INSERT INTO car_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Irombo mo'ko parito'membo aro'po i'waine Jesus 'wa. Tynoponykon yry'san i'waine itu'ponaka. Irombo Jesus wotandy'mo'po itu'po. ");
INSERT INTO car_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Pyime kari'na 'wa tynoponykon apika'san oma rary me. Amykonymbo 'wa moro oma esi'wo tyni'koto'san sa'rombo aripapy'san moro oma rary me. ");
INSERT INTO car_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Mo'karon oma ta Jesus uwapo ytotonon, mo'karon iwena'po ta ytotonon enapa kyniko'tapo'satokon: “Hosana! Mo'ko Tamusi ety ta o'toto nainen pa'poro kurano maro. ");
INSERT INTO car_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Mo'ko kytangon David y'petakan nundymary man nainen pa'poro kurano maro. Hosana! Tamusi ety imero kawo nainen kapu ta.” ");
INSERT INTO car_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Irombo Jesus wo'my'po Jerusalem taka. Moro Tamusi auty 'wa itunda'po. Pa'poro oty ene'ma'po mero moro po, iwepa'ka'po rapa, tyko'mamyry 'wa terapa iwairy ke. Betania 'wa ito'po mo'karon ainapatoro itu'ponaka oko tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Irombo kokoro Betania wyino tytorykon jako Jesus kumyry'po. ");
INSERT INTO car_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Tyse ro amy oroi ene'po i'wa taryne. Irombo tapeke iwairy ene ito'po. Tytunda'po mero i'wa, amy pairo epery anepory'pa iwe'i'po. Arymbo roten ipoko kynakon. Tapery jako waty kynakon moro wewe. ");
INSERT INTO car_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Irombo ika'po moro oroi 'wa: “Amy pairo kari'na noro ajeperymbo enapyry upin.” Moro moro wara ikary eta'po mo'karon inemeparykon 'wa. ");
INSERT INTO car_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Irombo Jerusalem taka iwo'my'san. Moro Tamusi auty 'wa tytunda'po mero, Jesus 'wa mo'karon Tamusi auty ta otykon ekaramanamon, otykon epeka'namon moma'san. Mo'karon pyrata ambo'namon pyratary apo'nykonymbo uringa'san i'wa. Mo'karon akukuwa ekaramanamon apo'nykonymbo uringa'san enapa i'wa. ");
INSERT INTO car_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Amy kari'na 'wa pairo oty arory 'se'pa kynakon moro Tamusi auty ta. ");
INSERT INTO car_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Irombo emepa'san i'wa. Ika'po: “Ero wara 'kare imero'pa nan: Yjauty ejatota'ton Tamusi 'wa pa'poro kari'na we'pimatopo me. O'waine te amy tymonakamon autary me terapa tyje man.” ");
INSERT INTO car_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Irombo mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Tamusi karetary uku'namon 'wa enapa moro o'kapy'po ekary eta'po. Irombo kynonumengatokon one wara Jesus wory man poko. Tanarike irombo kynatokon ipona, pa'poro mo'karon kari'na apyimy enumengapory ke i'wa morokon emepato'kon ke. ");
INSERT INTO car_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iko'mamyry mero te kurandonaka iwepa'ka'san Jerusalem wyino. ");
INSERT INTO car_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Irombo kokoro, moro wonatopo pato rapa tytorykon jako, tajuta terapa imero moro oroi enejatokon, moro imity wyinombo ro. ");
INSERT INTO car_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Irombo o'to moro oroi 'wa Jesus wyka'po poko Petrus wetuwaro'ma'po rapa. Irombo ika'po I'wa: “Na'na emepanen, eneko, moro ajauran ke anany'ma'po oroi tajuta man.” ");
INSERT INTO car_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Eju'to'ko'me Jesus wyka'po: “Tamusi amyikary o'waine man. ");
INSERT INTO car_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ita'ro pore, amy wykary jako ero wypy 'wa: ‘Ajawongo! Parana taka omatango!’ kyno'ka'tan ro, oko e'i'pa ituru'po a'ta, moro tykatopo wo'kapyry amyikary jako te ty'wa. ");
INSERT INTO car_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Iro ke ro wykaje o'waine: Pa'poro Tamusi 'wa awoturupoto'kon, pa'poro awe'pimato'kon apo'i'san terapa o'waine amyikatoko. Irombo mapyita'ton ro. ");
INSERT INTO car_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Irombo ajauranarykon jako Tamusi 'wa, yja'wan me apokoine amy aja'sakarykon we'i'po poko atuwarenge'toko. Moro wara awairykon jako, mo'ko kapu tano ajumykon enapa kynituwarenge'tan morokon yja'wan me awe'i'san poko.” ");
INSERT INTO car_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Irombo Jerusalem taka rapa iwo'my'san. Irombo moro Tamusi auty ta Jesus wytopotyry jako, mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon, mo'karon uwapoto'san enapa wopy'san I'wa. ");
INSERT INTO car_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iwoturupo'san I'wa: “Noky ko erokon otykon ka'pojan o'wa? Noky ko erokon otykon kapyry yryi ajainaka?” ");
INSERT INTO car_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesus 'wa ejuku'san: “O'win roten amy oty poko waturupoja o'waine. Yjauran ejuku'poto o'waine, sekari'take noky 'wa oma yry'po erokon otykon ka'to'me y'wa. ");
INSERT INTO car_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Moro Johanes 'wa kari'na etyka'po, Tamusi nisanory moro tywaije nan? Kari'na nisanory te ka'tu? Kaju'toko!” ");
INSERT INTO car_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Irombo ero wara ase'wa iworupa'san: “Kyka'sando ‘Tamusi nisanory moro tywaije man,’ kyngatan ‘O'tono'me ko iro ke Johanes anamyika'pa maiton?’ ");
INSERT INTO car_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kyka'sando te ‘Kari'na nisanory moro tywaije man.’ ...” Tanarike irombo kynatokon mo'karon kari'na apyimy pona. Pa'poro irombo Johanes wairy amyitatokon ipororo amy Tamusi auran uku'ponenymbo me. ");
INSERT INTO car_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Irombo ero wara Jesus ejuku'po i'waine: “Anukuty'pa na'na man.” Irombo Jesus wyka'po i'waine: “Awu enapa iro ke anekarity'pa waitake o'waine, noky 'wa oma yry'po erokon otykon ka'to'me y'wa.” ");
INSERT INTO car_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Irombo onumengato'kon auranano ekarityry a'mo'po Jesus 'wa i'waine: “Amy wokyry 'wa maina ta winu me tykapymy wonatopo typonje tywaije man. Moro maina tyjarando i'wa man. Moro wonatopo epery aikukato'man tatoka i'wa man. Kawo amy o'po'topo tyka'se i'wa man. Irombo tapema me amykon maina pokonokon apojomanon, moro maina eneto'me i'waine. Morombo wyino amy tyseno aitopo 'wa ytopo'se kyny'san. ");
INSERT INTO car_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Irombo moro wonatopo epery we'i'po mero, amy typyitory emo'san mo'karon maina pokonokon 'wa, moro wonatopo epery amy aije. ");
INSERT INTO car_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Irombo mo'karon maina pokonokon kynapyijaton. Kynipoky'maton. Irombo ainary'pa kynemo'saton rapa. ");
INSERT INTO car_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","“Irombo mo'ko jopoto 'wa amy rapa typyitory tomo'se man. Mo'ko embata'mopo'saton ro mo'karon maina pokonokon. Kynipy'i'topojaton imero. ");
INSERT INTO car_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","“Irombo amy rapa tomo'se i'wa man. Mo'ko wojaton ro imero. Moro wara enapa pyime a'sakarykon tyje i'waine man. Amykonymbo typoky'ma i'waine man. Amykonymbo imero tywo i'waine man. ");
INSERT INTO car_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“O'win ro'kon amy ekosa tywaije man, mo'ko inipynary imuru. Irombo ro mero ko'wu mo'ko tomo'se i'wa man i'waine. Kynganon: ‘Ymuru nendota'ton.’ ");
INSERT INTO car_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Irombo mo'karon maina pokonokon tyworupa mandon ase'wa. Kyngaton: ‘Mo'se ro mo'ko tyjumy otyrykonymbo apyinen man mo'se man. O'toko 'ne! Kysiwosen! Irombo moro inapyiry manombo kotyrykon me kynaitan.’ ");
INSERT INTO car_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","“Irombo kynapyijaton. Kyniwojaton. Moro maina wyino kynematon. ");
INSERT INTO car_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“O'to ko iro ke mo'ko maina aporemy naitan? Mo'karon maina pokonokon ywo kyno'tan. Moro maina ytan amykon terapa 'wa. ");
INSERT INTO car_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Ero imero'po anerupa'pa 'kare maiton: Moro auto amynamon nema'pombo topu 'ne ro moro auto pori'tomanen me tywaije man. ");
INSERT INTO car_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tamusi emamin moro tywaije man. Moro 'wa kywo'potyrykon jako, poto me kanumengapojaton.” ");
INSERT INTO car_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Irombo mero mo'karon ineruparykon wonumenga'san rypo apyiry poko, typokoine moro onumengatopo auranano ekarity'po ke i'wa. Mo'karon kari'na apyimy nendojatokon te. Iro ke ro ipoko waty iwe'i'san. Ito'san iwyino. ");
INSERT INTO car_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Irombo amykon Farise, amykon Herodes wyinonokon enapa emoky'san i'waine Jesus 'wa, auranymbo poko ro rypo apyito'me. ");
INSERT INTO car_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tytunda'san mero, ika'san I'wa: “Amepanen, enapita'pa awairy uku'san na'na. Amy kari'na aninendo'pa awairy uku'san enapa na'na. Asewara imero kari'na menaje. Iporo ro imero moro Tamusi emary poko kari'na memepaje. Iru'pa nan iro ke na'na 'wa mo'ko Rome pono jopoto nundymary epemary? Na'na nepematan? Uwa ka'tu?” ");
INSERT INTO car_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesus 'wa moro tonapire iwairykon ukuty'po. Irombo ika'po i'waine: “O'tono'me ko ku'kujaton? Amy amu'nymbo pyrata ene'toko y'wa, sene'se me.” ");
INSERT INTO car_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Irombo amy enepy'po i'waine I'wa. Irombo Jesus woturupo'po i'waine: “Noky ko tu'ku nan ipoko? Noky ety ko tymero nan ipoko?” Irombo ika'san I'wa: “Mo'ko Rome pono jopoto.” ");
INSERT INTO car_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesus wyka'po i'waine: “Mo'ko Rome pono jopoto 'wa iroke otyry ytoko. Mo'ko Tamusi otyry te ytoko Tamusi 'wa.” Poto me imero enumengapo'san Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Irombo amykon moro iromby'san wyino awono anamyika'non Saduse wopy'san I'wa amy oty poko aturupo. Ika'san: ");
INSERT INTO car_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Amepanen, Moses 'wa tymero man ky'wanokon me: “I'me'ma noro typyty a'ta amy kari'na yryimbo romby'poto, mo'ko ipirymbo 'wa terapa mo'ko ipytymbo apyiry man. Irombo mo'ko tyryi 'mi ekataka i'mekary i'wa man.” ");
INSERT INTO car_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Irombo te oko-to'ima amykon asepiryjan tywaije mandon. Irombo mo'ko koromono kynipytanon. I'me'ma te kyniromo'san. ");
INSERT INTO car_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Irombo mo'ko ipokorono terapa mo'ko ipytymbo apyijan. Mo'ko enapa kyniromo'san i'me'ma. Mo'ko ijoruwanorykon kyniromo'san iwara enapa. ");
INSERT INTO car_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Oko-to'imanombo mero i'me'ma tyromo'se mandon. Irombo mero ko'wu mo'ko woryi enapa tyromo'se man. ");
INSERT INTO car_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Moro iromby'san wyino awono jako awomyrykon jako rapa, nokypan pyty me ko iro ke mo'ko woryi naitan? Mo'karon oko-to'imanokon asepiryjan pyty me waty tywaije nan?” ");
INSERT INTO car_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesus wyka'po i'waine: “Tamusi karetary, Tamusi pori'tory enapa anukuty'pa awairykon ke, ipo waty moro awonumengarykon man. ");
INSERT INTO car_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Moro iromby'san wyino awono jako tawomy'sando rapa wokyryjan ipyta'pa mandon, woryijan inomba'pa mandon. Kapu tanokon apojonano wara te mandon. ");
INSERT INTO car_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Irombo mo'karon iromby'san awomyry man poko rapa, moro Moses nimero'po kareta ta 'kare anerupa'pa maiton, one wara moro paremuru po Tamusi wyka'po i'wa: ‘Awu Abraham tamusiry awu wa, Isak tamusiry, Jakob tamusiry enapa.’ ");
INSERT INTO car_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Iromby'san tamusiry kapyn mo'ko man. Nuronokon tamusiry te mo'ko man. Ipo waty imero monumengaton.” ");
INSERT INTO car_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Irombo o'win amy Tamusi karetary uku'nen wopy'po I'wa. Iporo ro Jesus 'wa ejuku'san eta'po ke ty'wa, iwopy'po Jesus 'wa aturupo: “Otypan omenano mero'po ko poto me 'ne nan, morokon amykon terapa omenano ko'po?” ");
INSERT INTO car_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesus 'wa ejuku'po: “Ero morokon amykon terapa omenano ko'po poto me man: Epanamako, Israel! Mo'ko Jopoto mo'ko kytamusirykon me man inoro, mo'ko roten Jopoto me man. ");
INSERT INTO car_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Mo'ko atamusiry Jopoto ipynako pa'poro aturu'po maro, pa'poro aja'kary maro, pa'poro awonumengary maro, pa'poro apori'tory maro enapa. ");
INSERT INTO car_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ipokoro ero poto me man: Aja'sakary ipynako, aseke awaipynary wara enapa. Amy rapa poto 'su omenano mero'po waty man morokon ko'po.” ");
INSERT INTO car_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Irombo mo'ko Tamusi karetary uku'nen wyka'po I'wa: “Iporo ro man, amepanen. Iporo ro mykai Tamusi me mo'ko roten wairy poko. Mo'ko rato amy rapa waty man. ");
INSERT INTO car_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Poto me ro man moro ipynary ky'waine pa'poro kyturu'san maro, pa'poro kywonumengarykon maro, pa'poro kypori'torykon maro enapa. Poto me enapa man ka'sakarykon pynary ky'waine, aseke kywaipynarykon wara enapa. Morokon ro potonon me man pa'poro morokon tykoro'ka me Tamusi 'wa tymy ko'po, pa'poro morokon tywo me Tamusi 'wa tymy ko'po enapa.” ");
INSERT INTO car_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tywonumengapore tajuku'po ke, Jesus wyka'po i'wa: “Tyse waty terapa mana moro Tamusi nundymary wyino.” Morombo wyino pa'poro iwety'ka'san amy oty poko noro tywoturuporykon poko i'wa. ");
INSERT INTO car_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Irombo moro Tamusi auty ta mo'karon kari'na emepary jako ty'wa, Jesus wyka'po: “One wara 'ne ko mo'karon Tamusi karetary uku'namon mo'ko Mesias ekari'saton David parymbo me? ");
INSERT INTO car_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aseke mo'ko David tykambo me man, mo'ko Tamusi a'kary 'wa taurambary ta: “Tamusi nykai mo'ko Yjopotory 'wa: ‘Yjapo'tun wyino atandy'moko, mo'karon ajenono'namon yry 'wa ro y'wa apupuru upi'nonaka’.” ");
INSERT INTO car_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Aseke ro David Tyjopotory me kynejatojan. One wara ko iro ke iparymbo me rapa nan?” Mo'karon kari'na apyimy apokupe imero kynakon moro auran etary. ");
INSERT INTO car_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Moro emeparykon jako ro ika'po i'waine: “Tuwaro aitoko mo'karon waino pangon Tamusi karetary uku'namon pona. Apokupeine man masi'pyngon wo'mynano ta itopotyrykon, morokon otykon ekaramato'kon po kari'na 'wa ewa'marykon, ");
INSERT INTO car_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","uwapo imero morokon tywota'nano'to'kon auto ta iwotandy'morykon, ta'sakarykon ko'po iru'pyn me tapo'ne iwendamerykon. ");
INSERT INTO car_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mo'karon ro mo'karon inongepy'san otyke'kamaton. Iru'pa tywairykon ekano'to'me kari'na 'wa, Tamusi 'wa akore'pe imero kynauranaton. Awosin pe 'ne ka'tu rapa te moro inapyirykon man a'wembono auranano kynaitan.” ");
INSERT INTO car_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Irombo Jesus wyto'po atandy'mo moro Tamusi 'wa tymy pyrata je'ny 'wa. Irombo mo'karon pyimano kari'na 'wa pyrata yry enejakon moro pyrata je'ny taka. Pyime mo'karon typyratakamon poto me pyrata yjatokon. ");
INSERT INTO car_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Irombo amy omi ta aitoto inongepy'po wopy'po. Oko tyka'miramon pyrata'makon 'ko yry'po i'wa. A'si 'ko 'ko imero moro pyrata kynakon. ");
INSERT INTO car_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Irombo Jesus 'wa mo'karon tynemeparykon ko'ma'san. Ika'po i'waine: “Ita'ro pore, mo'se omi tano inongepy'po pa'poro mo'karon pyrata ynamon ko'po pyrata yryi moro ije'ny taka. ");
INSERT INTO car_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Pa'poro mo'karon poto me pyrata ynamonymbo ekosa pyrata kynotakamanon. Moro yton ro. Mo'se woryi ko'wu omi ta man. Ise'me pa'poro typyratarymbo yryi, pa'poro tarepary epety manombo.” ");
INSERT INTO car_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Irombo iwepa'kary jako rapa moro Tamusi auty wyino, o'win amy inemepary wyka'po I'wa: “Amepanen, eneko morokon kurangon pore topu! Eneko morokon kurangon pore auto!” ");
INSERT INTO car_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Irombo Jesus 'wa ejuku'po: “Erokon potonon auto menejan? Pa'poro kynitororokata'ton. Oko pairo topu asetu'po anino'pa kynaita'ton ero po.” ");
INSERT INTO car_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Irombo iwotandy'mo'po moro oleif paty wypy tu'po, moro Tamusi auty 'wa tu'po 'ne. Moro a'saka'pa ta'taine ro moropo, Petrus, Johanes, Jakobus, Andreas woturupo'san i'wa: ");
INSERT INTO car_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ekari'ko na'na 'wa, one wara a'ta moro oty wairy man. Otypan oty poko ko na'na nuku'tan one wara a'ta pa'poro morokon otykon wo'kapyry man?” ");
INSERT INTO car_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Irombo Jesus 'wa tauranary a'mo'po: “Tuwaro aitoko, amy 'wa ajemu'marykon pona. ");
INSERT INTO car_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pyime irombo kari'na yjety a'kutan. ‘Inoro ro awu wa’, kyngata'ton. Irombo pyime kari'na emu'mata'ton. ");
INSERT INTO car_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Warinu ekary, warinu wairy man ekary enapa etary jako o'waine, kytety'katon. Morokon otykon wo'kapyry man. Irombo ro noro kapyn te moro man. ");
INSERT INTO car_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kari'na ase'wa warinu ka'ta'ton. Potonon aito'kon ase'wa kyno'wo'mata'ton. Aito'kon po tytyty kynaitan. Kumyno kynaitan. Morokon ro moro ata'karykano wota'mory moro kynaitan. ");
INSERT INTO car_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Amyjaron te tuwaro aitoko. Tyjopotorykon wota'nanopy'san po'ponaka ajarota'ton ajemendoto'ko'me. Irombo morokon ase'wa tywo'to'kon auto ta mene opoky'mata'ton. Poto 'su jopoto y'petakangon po'ponaka, potonon jopotokon po'ponaka enapa ajarota'ton yjupu'po me, otypan oty wo'kapy'po ekari'to'me o'waine i'waine. ");
INSERT INTO car_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pa'poro kari'na 'wa 'ne ka'tu te moro iru'pyn oka etary man. ");
INSERT INTO car_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Ajarorykon jako i'waine ajyto'ko'me mo'karon jopoto ainaka, iko'po 'ne 'ne o'to awykarykon man poko kytesykaton. Moro moro jako ajaurambarykon wara ro ajauranata'ton. Amyjaron kapyn irombo ajauranata'ton moro jako. Mo'ko Tamusi a'kary te otaine kynauranatan. ");
INSERT INTO car_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Kari'na typiry, tyryi ekaramatan iwoto'me. Jumynano ro rypo aseke ty'makon ekaramatan. Pitanikon tysanokon, tyjumykon auran po'takaro imero kynaita'ton. Kyniwopota'ton. ");
INSERT INTO car_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Pa'poro kari'na ajenono'ta'ton yjety upu'po me. Mo'ko i'matyry 'wa ro eja'nakatoto epano'tan te Tamusi. ");
INSERT INTO car_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Amy ty'wano waty aitopo po mo'ko oty any'manen nurija noky enery jako o'waine” - mo'ko ero kareta erupanen tuwaro nainen -, “moro jako ro mo'karon Judea tanokon netuwarikasen morokon wypy 'wa. ");
INSERT INTO car_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tauty re'ta amy a'ta, oro netuwarikan tywony'to'po mero, tauty taka o'my'pa amy oty aije. ");
INSERT INTO car_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tymainary ta amy a'ta, erama'pa nainen tynopony aije. ");
INSERT INTO car_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mo'karon mynotonon 'wa, mo'karon onema'senangon 'wa enapa je'tun pe pore oty kynaitan moro jako. ");
INSERT INTO car_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","“Tamusi 'wa te aturupotoko poto 'su i'sano jako o'kapy'pa morokon otykon waito'me. ");
INSERT INTO car_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Poto 'su ata'karykano irombo kynaitan moro jako. Tamusi 'wa ero nono kapy'po poro, erome noro moropan oty o'kapy'pa man. Moropan oty enapa o'kapy'pa noro rapa kynaitan. ");
INSERT INTO car_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ko'i anaike'kapo'pa Tamusi we'i'poto, amy pairo kari'na epa'ka'pa nairy. Mo'karon typo tynyry'san kari'na upu'san me te ko'i morokon otykon aike'kary man tyje i'wa man. ");
INSERT INTO car_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Moro jako ro amy wykary jako o'waine ‘Eneko, mo'se ro mo'ko Mesias’, ikary jako pai ‘Eneko, mo'ky inoro’, kysamyikaton. ");
INSERT INTO car_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Mo'karon Mesias me okari'tonon irombo kynawonda'ton. Mo'karon Tamusi auran uku'ponamon me okari'tonon kynawonda'ton. Potonon otykon enepota'ton. Iwara ro mo'karon typo Tamusi nyry'san kari'na emu'mary poko pairo kyne'kuta'ton. ");
INSERT INTO car_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amyjaron te tuwaro aitoko me. Iwo'kapyry uwaporo pa'poro oty sekarityi o'waine. ");
INSERT INTO car_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Moro jako ro, moro poto 'su ata'karykano pa'po me, moro weju kynewa'rumandan. Moro nuno aweita'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Morokon siriko kapu rary wyino kyno'pa'tan. Irombo morokon kapu tanokon pori'tonano kynesakamapo'tan. ");
INSERT INTO car_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Moro jako ro mo'ko kari'na ymuru wopyry eneta'ton kapurutu ta, pori'tonano maro imero, kurano me imero. ");
INSERT INTO car_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Moro jako ro mo'karon kapu tanokon tapojongon apojomatan. Mo'karon typo tynyry'san a'nano'potan i'waine morokon okupa'en pepeito wo'to'kon wyinombo ro, pa'poro ero nono y'maty'po 'wa ro. ");
INSERT INTO car_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Moro oroi ajenutano'posen. Morokon iporiry sekurita'po mero, irombo arynary jako, senge terapa moro poto 'su iromy wairy muku'saton. ");
INSERT INTO car_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Iwara enapa uku'toko apenarykon wyino senge terapa mo'ko kari'na ymuru wairy, morokon otykon wo'kapyry enery jako o'waine. ");
INSERT INTO car_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","“Ita'ro pore, mo'karon eromenokon kari'na i'maty'ma'pa kynaita'ton, pa'poro erokon otykon wo'kapyry uwaporo. ");
INSERT INTO car_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kapu, nono kynuta'tan. Moro yjauranymbo te utapy'pa roten kynaitan. ");
INSERT INTO car_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Amy pairo te anukuty'pa man otypan kurita, o'toro juru a'ta erokon otykon wo'kapyry man. Mo'karon kapu tanokon Tamusi apojongon enapa anukuty'pa mandon. Mo'ko ymunano enapa anukuty'pa man. Mo'ko jumynano roten kynuku'san. ");
INSERT INTO car_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Tuwaro aitoko! Kyto'ny'ton! Anukuty'pa irombo mandon, one wara a'ta morokon otykon wo'kapyry man. ");
INSERT INTO car_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Amy tyse ytopo'se ytototo wokyry wara man. Tytory mero mo'karon typyitorykon aina moro tauty nojan. Iwararoine ro emamingon yjan. Irombo mo'ko pena eran 'wa kynganon tuwaro iwaito'me. ");
INSERT INTO car_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Iro ke ro tuwaro aitoko! Anukuty'pa irombo mandon one wara a'ta mo'ko tautynen weramary rapa: koine pai, koko pai, korotoko ko'ta'poto pai, kokoro 'ne pai. ");
INSERT INTO car_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Typo roten kyno'tan. Oro awo'nykyrykonymbo anepory'pa nainen! ");
INSERT INTO car_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ero o'waine ynekarityry pa'poro kari'na 'wano me sekari'sa: tuwaro aitoko!” ");
INSERT INTO car_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Oko kurita ro'kon mo'ko eratonomapotopombo onory ewa'mary, morokon uwaputa'non perere ewa'mary tundary we'i'poto, mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon enapa amy amepo upijatokon Jesus apyito'me ty'waine, iwoto'me. ");
INSERT INTO car_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ero wara kyngatokon: “Mo'ko eratonomapotopombo onory ewa'mary jako kapyn apyiry ky'waine man. Aseke mo'karon kari'na kywo'mata'ton.” ");
INSERT INTO car_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Irombo Betania po mo'ko areky pan Simon auty ta Jesus wendamery jako ro, amy woryi wopy'po amy tapenen topu kapy'po patere'membo maro. Ita amy tapenen typoporen, nardus tatynen i'kaimapyn karapa kynakon. Irombo moro patere'membo pynga'po i'wa. Moro itano karapa y'kamy'po i'wa Jesus upu'po tu'ponaka. ");
INSERT INTO car_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Amykonymbo moro po aitonon wore'ko'san te. Ase'wa ika'san: “O'tono'me ko moro wara moro karapa akamanon mo'se? ");
INSERT INTO car_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Atone'pu-kari'na amu'nymbo pyrata ko'po rypo moro karapa ekaramary manombo tywaije man. Irombo moro pyrata yry manombo rypo tywaije man mo'karon ipyrata'non 'wa.” Iwore'ko'san imero mo'ko woryi poko. ");
INSERT INTO car_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesus wyka'po te i'waine: “Ipoko kytaiton! O'tono'me ko ipoko mandon? Iru'pyn oty kapyi y'wano me. ");
INSERT INTO car_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mo'karon ipyrata'non irombo kynaijaton roten ajekosaine. I'se awe'i'san mero, epanopyrykon taro mandon. Awu te e'i'pa roten waitake ajekosaine. ");
INSERT INTO car_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Typori'tory taro ro mo'se woryi oty kapyi. Yja'mun kyrykyrymai terapa typoporen karapa ke, yjunemyry uwaporo. ");
INSERT INTO car_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ita'ro pore, pa'poro wararo ero nono tu'po moro iru'pyn oka ekarityry jako, mo'se woryi nikapy'po ekari'ta'ton enapa iwonumengato'ko'me ipoko.” ");
INSERT INTO car_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Irombo Judas Iskariot, mo'ko o'win amy Jesus nemepary wyto'po mo'karon Tamusi pokonokon jopotorykon 'wa, Jesus ekaramato'me ty'wa i'waine. ");
INSERT INTO car_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Moro eta'san mero ty'waine, ewa'pota'san imero. Pyrata ke epemary man ejato'po i'waine. Morombo mero amy oma upijakon Jesus yto'me ty'wa ainakaine. ");
INSERT INTO car_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Irombo moro koromono uwaputa'non perere ewa'matopo kurita tunda'po. Moro kurita ro mo'ko eratonomapotopombo kapara'membo wotopombo mo'karon Simosu 'wa kynakon. Moro jako ro mo'karon Jesus nemeparykon woturupo'san I'wa: “Oja ko na'na wytory 'se man mo'ko eratonomapotopombo y'mo'ka, onoto'me o'wa?” ");
INSERT INTO car_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Irombo oko tynemeparykon emoky'san i'wa. Ika'po i'waine: “I'tandoko moro poto 'su aitopo taka. Irombo amy wokyry 'wa poty'sa ta tuna arorymbo mepota'ton. Mo'ko ro iwekenatoko me. ");
INSERT INTO car_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Irombo amy auto taka iwo'my'poto, kaitoko mo'ko tautynen 'wa: ‘Mo'ko amepanen kynganon: ‘Oje ko moro ywaitopo man nan, mo'ko eratonomapotopombo onoto'man y'wa mo'karon ynemeparykon maro?’ ’ ");
INSERT INTO car_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Irombo kawo amy poto 'su apuru'po enepotan o'waine. Pa'poro terapa kyna'kurukon man oty ita man. Moro po ro mo'ko kapara'membo i'mo'katoko me pa'poro ky'waine.” ");
INSERT INTO car_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Irombo mo'karon oko inemeparykon wyto'san. Irombo itunda'san moro poto 'su aitopo 'wa. Irombo Jesus wyka'po wara ro ty'waine oty epory'po i'waine. Irombo mo'ko eratonomapotopombo y'mo'ka'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iko'mamy'po mero, Jesus wopy'po mo'karon ainapatoro itu'ponaka oko tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Irombo tarije'po tywendamerykon jako ro, Jesus wyka'po i'waine: “Ita'ro pore, o'win amy ara'nanokon yjekaramatan, o'win amy ymaro endametoto.” ");
INSERT INTO car_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Irombo kata'mato terapa iwe'i'san. Pa'poro tywe'i'san mero ika'san I'wa: “Awu kapyn waty?” ");
INSERT INTO car_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Irombo ika'po i'waine: “Ainapatoro itu'ponaka oko ynemeparykon me mandon amyjaron. O'win amy ara'nanokon te yjekaramatan. Mo'ko ywara enapa moro arepa a'pitopo taka tarepary a'pinen, mo'ko ro, inoro mo'ko man. ");
INSERT INTO car_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Kyny'san ro mo'ko kari'na ymuru, typoko imero'po wara ro. Mo'ko kari'na ymuru ekaramanen te janon kynotamotan. Iru'pa nairy ero nono tu'ponaka opy'pa iwe'i'pomboto.” ");
INSERT INTO car_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Irombo moro tywendamerykon jako noro, amy perere anumy'po i'wa. Tamusi ety awonga'po mero ipoko, i'sakapoty'po i'wa. Irombo ekamy'po i'wa i'waine. Ijako ro ika'po: “Apyitoko. Yja'mun ero man.” ");
INSERT INTO car_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Irombo amy sapera anumy'po i'wa. Tamusi ety awonga'po mero moro sapera tano tanymy poko, yry'po i'wa i'waine. Pa'poro tywe'i'san mero amy enyry'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Irombo ika'po i'waine: “Ymynuru ero man. Kyne'kanjan moro Tamusi wykatopombo pori'tomato'me. Pyimano kari'na upu'san me kyne'kanjan. ");
INSERT INTO car_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ita'ro pore, winu anenyry'pa noro ra'a waitake. Moro Tamusi nundymary ta te asery me senytake rapa.” ");
INSERT INTO car_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Irombo Tamusi ety awongato'me tywareta'ma'san mero, ito'san moro oleif paty wypy 'wa. ");
INSERT INTO car_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Irombo Jesus wyka'po i'waine: “Pa'poro ywyino matu'mata'ton. Tymero irombo man: “Mo'ko kapara enenen siwotake. Irombo mo'karon kapara kynotaripa'ta'ton.” ");
INSERT INTO car_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Moro iromby'san wyino yjawomy'po mero te, Galilea 'wa wy'take ajuwapoine.” ");
INSERT INTO car_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrus wyka'po te I'wa: “Pa'poro kari'na ro rypo awyino kynotu'mata'ton. Awu te atuma'pa waitake!” ");
INSERT INTO car_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Irombo Jesus wyka'po i'wa: “Ita'ro pore, ero koko noro okomboto korotoko ko'tary uwaporo, oruwamboto yjukuty'pa mokari'take.” ");
INSERT INTO car_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Irombo paripe 'ne ka'tu rapa Petrus wyka'po: “Yrombyry man jako ro rypo amaro, ajukuty'pa okarity'pa waitake.” Moro wara enapa pa'poro mo'karon a'sakarykon wyka'san. ");
INSERT INTO car_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Irombo amy Getsemane tatynen wonatopo paty 'wa ito'san. Irombo ika'po mo'karon tynemeparykon 'wa: “Ero po atandy'motoko. Tamusi 'wa aurana wy'sa.” ");
INSERT INTO car_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Petrus, Johanes, Jakobus aro'san i'wa tymaro. Irombo amy poto 'su anari wopy'po imero itu'ponaka, kynety'ka'ko imero. ");
INSERT INTO car_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Irombo ika'po i'waine: “Kata'mato ywairy je'tun ywory 'se rypo terapa man. Ero po ro aitoko. Tuwaro koro aitoko me.” ");
INSERT INTO car_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Irombo a'si 'ko noro ito'po. Tombata'po iwoma'po. Irombo Tamusi 'wa iwoturupo'po moro ata'karykano 'wa tuwaporimakato'me, i'se iwairy taro ro. ");
INSERT INTO car_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Irombo ika'po: “Aba, papa, pa'poro oty kapyry ajaina man. Ero je'tun pan sapera 'wa kuwaporimakapoko. Ynisanory kapyn te no'ka'nen. Anisanory te.” ");
INSERT INTO car_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Irombo iwopy'po rapa mo'karon tynemeparykon 'wa. Iwo'nykyrykonymbo epory'po terapa i'wa. Irombo Petrus 'wa ika'po: “Simon, mo'ny'san? Ko'i roten pairo nuro awairy mupijan? ");
INSERT INTO car_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Tuwaro aitoko. Tamusi 'wa aturupotoko, moro aju'kuto'kon 'wa ajapyirykon pona. Mo'ko a'kanano ro rypo oty kapyry 'se man. Moro ja'munano te ru'me man.” ");
INSERT INTO car_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Irombo ito'po rapa. Tamusi 'wa rapa aurana'po. Koromo taurana'po wara ro rapa aurana'po. ");
INSERT INTO car_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Irombo tywerama'po mero rapa, iwo'nykyrykonymbo epory'po rapa i'wa. Epirykon imero tawosinapo'seine kynatokon. One wara pairo Jesus ejukuru upi'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Irombo moro ijoruwanorymbo ta tywopy'po mero rapa, ika'po i'waine: “Erome te o'ny'toko iro ke. Otare'matoko. Naikepyi terapa. Moro ijururu nitundai terapa. Mo'ko kari'na ymuru yjaton terapa irombo mo'karon tyja'wangamon ainaka. ");
INSERT INTO car_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ajawondoko. Ka'makon. Mo'ko yjekaramanen irombo nitundai terapa.” ");
INSERT INTO car_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Moro Jesus auranary jako noro, typo roten mo'ko o'win amy inemepary Judas tunda'po. Imaro moky imero kari'na kynatokon supara maro, putu maro. Mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Tamusi karetary uku'namon 'wa, mo'karon uwapoto'san 'wa enapa tomo'se kynatokon. ");
INSERT INTO car_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mo'ko ekaramanen 'wa te enepoto'man takari'se kynakon i'waine. Tyka kynakon: “Mo'ko siposimatake inoro, inoro ro mo'ko man. Apyitoko me. Irombo torane arotoko me.” ");
INSERT INTO car_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Irombo itunda'po. O'win wytory Jesus 'wa ito'po. Ika'po i'wa: “Yjemepanen!” Irombo imero iposima'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Irombo mo'karon imaro opy'san 'wa Jesus apo'i'po. ");
INSERT INTO car_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Irombo o'win amy moro po aitoto 'wa tysuparary so'ka'po ije'ny wyino. Irombo mo'ko Tamusi pokonokon jopotory pyitory panaka'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Irombo Jesus woturupo'po i'waine: “Amy tokonen manaman apyiry 'sangon wara imero supara maro, putu maro tywo'se mandon yjapyije. ");
INSERT INTO car_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kurita wara ro ajekosaine kari'na semepakon moro Tamusi auty ta. Moro jako te yjapo'i'pa maisen. Ero wara te morokon imero'san wo'kapyry man.” ");
INSERT INTO car_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Irombo mo'karon inemeparykon 'wa o'win upu'po Jesus no'po. Pa'poro eka'numy'ma'san. ");
INSERT INTO car_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Irombo amy pyito kyniwekenakon. Iwo'my'ma mo'ko pyito kynakon. Amy kamisa ke roten tywainopondo kynakon. Irombo apo'i'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Iwo'kerenga'po te iwyinoine. Moro inoponymbo wainopo'po roten ainaine. Inopo'ma eka'numy'po. ");
INSERT INTO car_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Irombo Jesus aro'po i'waine mo'ko Tamusi pokonokon jopotory 'wa. Pa'poro mo'karon Tamusi pokonokon jopotorykon, mo'karon uwapoto'san, mo'karon Tamusi karetary uku'namon enapa wota'nanopy'san. ");
INSERT INTO car_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrus tyse terapa kyny'sakon Jesus wena'po ta. Mo'ko Tamusi pokonokon jopotory auty taka ro imero Jesus wekena'po i'wa. Irombo wa'to ekonda iwotandy'mo'po, mo'karon oranano ekosa. ");
INSERT INTO car_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mo'karon Tamusi pokonokon jopotorykon, pa'poro mo'karon Simosu jopotorykon enapa amy Jesus emendoto'man upijatokon, iwopoto'me ty'waine. Amy iwopoto'man anepory'pa te iwe'i'san. ");
INSERT INTO car_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Pyime kari'na Jesus emendojatokon. Onapi roten ekari'satokon te ipoko. O'win morokon aurangon e'i'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Irombo amykon tonapiramon awomy'san emendoto'me. Ika'san: ");
INSERT INTO car_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Na'na ikary etai: ‘Ero ainanano ke ikapy'po Tamusi auty sakatake. Irombo oruwa kurita amy terapa samy'matake rapa, ainanano ke waty.’ ” ");
INSERT INTO car_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Moro wara enapa te morokon Jesus emendoto'kon i'waine o'win e'i'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Irombo mo'ko Tamusi pokonokon jopotory awomy'po. Owarira'naka ito'po. Irombo Jesus 'wa iwoturupo'po: “O'to yka'pa man morokon i'waine ajemendotopo poko?” ");
INSERT INTO car_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","O'to yka'pa te Jesus we'i'po. Anejuku'paine pairo iwe'i'po. Irombo mo'ko Tamusi pokonokon jopotory woturupo'po rapa I'wa: “Mo'ko Mesias amoro man? Mo'ko tykuranondo man inoro ymuru amoro man?” ");
INSERT INTO car_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Irombo Jesus wyka'po: “Inoro ro awu wa. Aire mo'ko kari'na ymuru tandy'po meneta'ton mo'ko pari'pyn apo'tun wyino. Aire kapurutu ta iwopyry meneta'ton.” ");
INSERT INTO car_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Irombo mo'ko Tamusi pokonokon jopotory 'wa moro tywo'mymbo seka'po. Ika'po: “O'tono'me ko emendonamon me noro amykon kysupijaton? ");
INSERT INTO car_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Tamusi ety jamikary i'wa metaton. One wara ko monumengaton ipoko?” Irombo pa'poro ika'san: “Iwory man.” ");
INSERT INTO car_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Irombo amykonymbo eta'tapoty'san itu'ponaka. Kamisa ke embatapu'to'po i'waine. Irombo tainarykon amo'mere'ko'san ke iwo'po i'waine. Irombo ika'san I'wa: “Tamusi auran uku'ponen, ekari'ko noky 'wa awo'po!” Mo'karon oranano 'wa mene imero embata'mopoty'po. ");
INSERT INTO car_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Irombo po'po moro pyroro ta mo'ko Petrus a'ta noro, mo'ko Tamusi pokonokon jopotory emyijary amy wopy'po moro pato. ");
INSERT INTO car_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wa'to ekonda Petrus ene'po mero ty'wa, iru'pa 'nero ene ito'po. Irombo ika'po: “Amoro enapa mo'ko Nasaret pono maro makon, mo'ko Jesus maro.” ");
INSERT INTO car_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Petrus wyka'po te: “Uwa! Anukuty'pa wa. O'to awykary anukuty'pa pairo wa.” Irombo a'si 'ko ito'po moro o'mytopo 'wa. Irombo korotoko ko'ta'po. ");
INSERT INTO car_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Irombo Petrus ene'po mero rapa, mo'ko woryi wyka'po rapa mo'karon moro po o'po'tonon 'wa: “Amy a'sakarykon mo'se man.” ");
INSERT INTO car_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Enapitary ekarity'po rapa te Petrus 'wa. Irombo a'si 'ko a'si 'ko mo'karon o'po'tonon wyka'san rapa i'wa: “Iporo ro amy a'sakarykon amoro mana, to! Galilea pono enapa amoro mana.” ");
INSERT INTO car_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Irombo Tamusi ety ejatory ta Petrus wyka'po: “Tamusi yjuta'kan, mo'ko awykato'kon wokyry ukutyry jako y'wa!” ");
INSERT INTO car_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Irombo o'win wytory korotoko ko'ta'po rapa. Irombo Petrus wetuwaro'ma'po rapa moro Jesus auranymbo poko: “Okomboto korotoko ko'tary uwaporo, oruwamboto yjukuty'pa mokari'take.” Irombo iwotamo'po imero. ");
INSERT INTO car_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Emamy'po mero, ko'i terapa mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa, mo'karon Tamusi karetary uku'namon 'wa, pa'poro mo'karon Simosu jopotorykon 'wa enapa taurangon epopo'san i'waine. Irombo Jesus my'po i'waine. Aro'po i'waine. Pilatus ainaka terapa yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilatus woturupo'po I'wa: “Mo'karon Simosu Jopotory amoro man?” Irombo Jesus 'wa ejuku'po: “Moro wara aseke mykaje.” ");
INSERT INTO car_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mo'karon Tamusi pokonokon jopotorykon 'wa pyime otykon poko Jesus emendo'po. ");
INSERT INTO car_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Irombo Pilatus woturupo'po rapa I'wa: “Anejuku'paine pairo man? Etako o'toro 'ko waty ajemendory i'waine!” ");
INSERT INTO car_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Anejuku'pa noro te Jesus we'i'po. Pilatus wonumenga'po imero. ");
INSERT INTO car_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Amy oty ewamary wararo te moro yja'wangon kari'na aru'katopo wyino o'win amy mo'karon kari'na nisanorymbo katopombo mo'ko Pilatus 'wa kynakon. ");
INSERT INTO car_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Moro jako 'ne te mo'ko Barabas tatynen moro yja'wangon kari'na aru'katopo ta kynakon ta'sakarykon maro. Amy kari'na tywo tywaije i'waine kynakon moro tywe'kurukon jako mo'karon tupi'nonakaine tynamonymbo momary poko. ");
INSERT INTO car_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Irombo mo'karon kari'na apyimy wonuku'po kawonaka. Pilatus 'wa iwoturupo'san, tamerymbo mero iwaito'me takatakaine. ");
INSERT INTO car_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Irombo Pilatus 'wa ejuku'san: “Mo'ko Simosu Jopotory nondary 'se'pa mandon y'wa?” ");
INSERT INTO car_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kynuku'sakon irombo i'se'pa tywairykon ke mo'karon Tamusi pokonokon jopotorykon 'wa Jesus yry'po tainaka. ");
INSERT INTO car_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mo'karon Tamusi pokonokon jopotorykon te imero mo'karon kari'na apyimy apokumatokon, Barabas kato'me i'wa. ");
INSERT INTO car_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Irombo Pilatus woturupo'po rapa i'waine: “O'to ko iro ke mo'se wokyry sytan, mo'se Simosu Jopotory me anejatorykon?” ");
INSERT INTO car_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Irombo iko'tapoty'san rapa: “Ipokary man wakapu poko!” ");
INSERT INTO car_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Irombo Pilatus wyka'po i'waine: “O'tono'me? Otypan yja'wan oty 'ne ko iro ke tyka'se i'wa nan?” Pari'pe 'ne ka'tu rapa te imero iko'tapoty'san: “Ipokary man wakapu poko!” ");
INSERT INTO car_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Irombo Pilatus 'wa mo'karon kari'na apyimy nisanory wararo Barabas kapo'po. Jesus yry'po te i'wa mo'karon warinu pokonokon ainaka wakapu poko ipokato'me. Mene 'ne ka'tu ipoky'mapo'po i'wa. ");
INSERT INTO car_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Irombo mo'karon warinu pokonokon 'wa Jesus aro'po moro a'wembono auranano ytopo auto taka. Pa'poro mo'karon ta'sakarykon ko'ma'san i'waine. ");
INSERT INTO car_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Irombo amy tapenen tykujuren wo'mynano ke Jesus wo'myndo'po i'waine. Amy sipatamu waton momy'po i'waine u'mariry me. Upu'po tu'ponaka yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Irombo ewa'ma'po i'waine. Ika'san: “Na'na te kore awopy'po ewa'maje, Simosu Jopotory!” ");
INSERT INTO car_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Irombo amy waruma waton ke iwo'po i'waine upu'po po. Itu'ponaka eta'tapoty'san. Iwokunama'san ipo'ponaka, ety awonganamon wara. ");
INSERT INTO car_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ipoko tywosaijamba'ma'san mero, moro tykujuren iwo'mymbo so'ka'po rapa i'waine. Irombo moro iwo'my ke rapa iwo'myndo'po i'waine. Irombo kurandonaka aro'po i'waine ipokato'me wakapu poko. ");
INSERT INTO car_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Irombo amy wokyry maina wyino kyny'sakon ipatoine. Amy Sirene pono mo'ko kynakon, Simon tatynen. Aleksander, Rufus jumykon mo'ko kynakon. Mo'ko wyry'ka'po ro mo'karon warinu pokonokon 'wa, moro Jesus pokatopo man wakapu aroto'me i'wa. ");
INSERT INTO car_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Irombo Jesus aro'po i'waine moro Golgota tatynen aitopo 'wa. Moro tauro'po man ‘u'je'pombo waitopo’. ");
INSERT INTO car_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Irombo amy itun pan oty maro i'kaima'po winu ke upa'po i'waine. Anenyry'pa te iwe'i'po. ");
INSERT INTO car_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Irombo ipoka'po i'waine moro wakapu poko. Morokon iwo'mykonymbo ekamy'san i'waine asekaro. Nokypan 'wa otypan iwo'mymbo apyiry man uku'to'me ty'waine, tymeramon tapusikiri emapoty'san i'waine. ");
INSERT INTO car_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kokoro, okupa'en-to'ima juru a'ta ipoka'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ero wara moro Jesus emendotopo tymero kynakon epo: MO'KARON SIMOSU JOPOTORY ");
INSERT INTO car_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Imaro ro oko tokonamon manamangon poka'san i'waine, o'win amy apo'tun wyino, o'win amy apoje wyino. ");
INSERT INTO car_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Mo'karon moro pato ytotonon imero tupu'san sekesekematokon. Jesus ejujatokon. Kyngatokon: “E! Amoro moro Tamusi auty akanen, irombo oruwa kurita amy'manen rapa! ");
INSERT INTO car_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Aseke opano'ko! O'kako moro apokatopombo wyino!” ");
INSERT INTO car_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Iwara enapa mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon enapa Jesus ere'no'satokon. Kyngatokon: “Amykon terapa tapano'se i'wa mandon. Aseke te tywopanopyry upijan. ");
INSERT INTO car_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Oro mo'ko Mesias, mo'karon Israel pajanymbo Jopotory erome kynenerykon me nony'ton moro typokatopombo wyino, kysamyikato'se me.” Mo'karon imaro ipoka'san enapa kynejujatokon. ");
INSERT INTO car_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kurita 'ne 'ne iwe'i'po mero, pa'poro moro nono ewa'rumamy'po, oruwa juru taronaka. ");
INSERT INTO car_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Oruwa juru a'ta mo'ja imero Jesus ko'ta'po. Ika'po: “Eloi, Eloi, lama sabaktani?” Moro tauro'po man: ‘Ytamusiry, ytamusiry, o'tono'me ko o'win upu'po kynoi?’ ");
INSERT INTO car_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Irombo amykon moro po o'po'tonon 'wa moro auran eta'po. Irombo ika'san: “Etatoko! Elia ko'manon.” ");
INSERT INTO car_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Irombo ko'i amy 'wa amy tymi'mi'ken oty u'mu'ka'po tyjasakoren winu taka. Amy waruma waton pokonaka yry'po i'wa, Jesus upato'me ty'wa ike. Ika'po: “Elia wopyry kysenesen, ipokatopombo wyino ika.” ");
INSERT INTO car_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mo'ja te imero Jesus ko'ta'po. Irombo iworemakepy'po. ");
INSERT INTO car_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Moro jako ro moro Tamusi auty ta isererema'po kamisa wo'seka'po ase'ra, kawo wyinombo ro po'ponaka. ");
INSERT INTO car_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Moro moro wara irombyry ene'po mero ty'wa, mo'ko ipato o'po'toto warinu pokonokon jopotory wyka'po: “Iporo ro kore mo'se wokyry Tamusi ymuru mo'se tywaije na.” ");
INSERT INTO car_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amykon enapa woryijan tyse terapa kyno'po'satokon. Imaroine kynatokon: mo'ko Magdala pono Maria, mo'ko Salome, Maria mo'ko meseku Jakobus sano, mo'ko Joses sano me enapa man inoro enapa. ");
INSERT INTO car_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Mo'karon wytotopombo ro kynakon Jesus wena'po ta, Galilea po a'ta. Upatopombo enapa i'waine kynakon. Pyime enapa amykon terapa Jesus maro Jerusalem 'wa ito'san woryijan moro po kyno'po'satokon. ");
INSERT INTO car_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Irombo koine 'ne, moro otare'matopo kurita wopy'pa ro, ");
INSERT INTO car_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","mo'ko Arimatea pono Josef 'wa tyturu'po apo'i'po, Pilatus 'wa tytoto'me, Jesus ekepy'po poko aturupo. Mo'ko Josef ro amy poto'su Simosu jopotory mo'ko kynakon. Moro Tamusi nundymary wopyry po enapa kyno'po'sakon. ");
INSERT INTO car_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Tyromo'se terapa Jesus wairy ekary eta'po mero, Pilatus enuta'po. Irombo mo'ko warinu pokonokon jopotory ko'mapo'po i'wa. Iwoturupo'po i'wa tyromo'se terapa Jesus wairy poko. ");
INSERT INTO car_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mo'ko warinu pokonokon jopotory 'wa iromby'po ekarity'po mero, Jesus ekepy'po ypo'po Pilatus 'wa mo'ko Josef ainaka. ");
INSERT INTO car_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Irombo Josef 'wa amy tamu'nen kamisa epekaty'po. Irombo Jesus ka'po i'wa moro ipokatopombo wakapu wyino. Irombo moro kamisa ke ijondo'po i'wa. Irombo moro amy topu atoka'po atunendopo taka unemy'po i'wa. Irombo amy topu uringapoty'po i'wa moro ipenary apu'toto'me. ");
INSERT INTO car_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Moro oje Jesus unemy'po ene'po mo'ko Magdala pono Maria 'wa, mo'ko Joses sano Maria 'wa enapa. ");
INSERT INTO car_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Irombo moro otare'matopo kurita pa'po me, koko, mo'ko Magdala pono Maria, mo'ko Jakobus sano Maria, mo'ko Salome 'waine typoporamon otykon epekaty'san, Jesus kyrykyryma tytoto'ko'me. ");
INSERT INTO car_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Irombo kokoro 'ne imero, koromo weju wepa'kary jako, ito'san moro atunendopo 'wa. ");
INSERT INTO car_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ase'wa kyngatokon: “Noky ko moro atunendopo penary aputy topu emimatan ky'waine?” ");
INSERT INTO car_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Potombo me irombo moro topu kynakon. Irombo te tyse terapa moro topu emima'po ene'po i'waine. ");
INSERT INTO car_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Irombo tywo'my'san mero moro atunendopo taka, apo'tun wyino amy pyito wotandy'mo'po ene'po i'waine, tamu'nen wo'mynano ta. Irombo poto me imero iwety'ka'san. ");
INSERT INTO car_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Mo'ko wyka'po te i'waine: “Kytety'katon. Mo'ko Jesus, mo'ko Nasaret pono, mo'ko wakapu poko ipoka'po mupijaton, aine? Nawomyi rapa. Ero po uwa man. Enetoko! Ero moro ytopombo. ");
INSERT INTO car_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","I'tandoko rapa te. Ajuwapoine Galilea 'wa itory ekari'tandoko mo'karon inemeparykon 'wa, Petrus 'wa enapa. Moro po ro mo'ko Jesus meneta'ton, ika'pombo wararo o'waine.” ");
INSERT INTO car_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Irombo iwepa'ka'san rapa. Eka'numy'san moro atunendopo wyino, tanarirykon 'wa tytytykarykon ta. Amy pairo kari'na 'wa otymbo ro anekarity'pa iwe'i'san, tywety'karykon ke. ");
INSERT INTO car_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Moro otare'matopo kurita pa'po me, moro iromby'san wyino kokoro 'ne tawomy'po wyino, mo'ko Magdala pono Maria 'wa na'sen iwosenepo'po. Mo'ko wyino ro oko-to'ima yja'wangon no'kan tymoma I'wa kynakon. ");
INSERT INTO car_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mo'ko wyto'po ro ekari'se mo'karon Jesus maro e'i'san 'wa. Mo'karon imero kata'mato noro kynotamojatokon. ");
INSERT INTO car_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nuro ene'po ekarity'po mero mo'ko woryi 'wa ty'waine, anamyika'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Morombo wyino amy me terapa iwosenepo'po oko amykon a'sakarykon 'wa, moro Jerusalem wyino iwepa'karykon jako. ");
INSERT INTO car_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Irombo iwerama'san rapa ekari'se mo'karon ta'sakarykon 'wa. Mo'karon anamyika'pa enapa te iwe'i'san. ");
INSERT INTO car_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Irombo wyino Jesus wosenepo'po mo'karon ainapatoro itu'ponaka o'win tynemeparykon 'wa, iwendamerykon jako. Oty anamyika'pa iwairykon poko, tyturu'poja'nare iwairykon poko enapa e'ma'san I'wa, mo'karon tawomy'po wyino tanenamonymbo anamyika'pa iwe'i'san ke. ");
INSERT INTO car_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Irombo ika'po i'waine: “Pa'poro ero nono tu'po wararo i'tandoko. Pa'poro kari'na 'wa moro iru'pyn oka ekari'toko. ");
INSERT INTO car_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mo'ko amyikanenymbo asetykapototo utapy'pa kynaitan. Mo'ko anamyika'pa aitoto poko te mo'ko a'wembono auranano ynen jopoto yja'wan auranano ytan. ");
INSERT INTO car_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tamusi mo'karon tauran amyikanamonymbo epanotan erokon kapu wyinono otykon ke: yjety ta yja'wangon no'kan momata'ton; aserynon auranano ta kynauranata'ton; ");
INSERT INTO car_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","tainarykon ke okoju apo'i'poto i'waine, amy romo'kanen oty enyry'poto pai i'waine, o'to pairo e'i'pa kynaita'ton; je'tun pangon tu'ponaka tainarykon yry'sando i'waine, kynekura'mata'ton rapa.” ");
INSERT INTO car_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Irombo aurana'ma'po mero i'waine, mo'ko Jopoto Jesus awo'nuku'po kapu taka. Tamusi apo'tun wyino iwotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mo'karon inemeparykon wyto'san te wararo moro iru'pyn oka ekari'se. Moro jako ro mo'ko Jopoto kynepano'satokon. Aurangon amyikapojakon kapu wyinono otykon ke.");
INSERT INTO car_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Pyime terapa kari'na tywe'ku mandon morokon kyra'naine o'kapy'san otykon merory poko, ");
INSERT INTO car_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","mo'karon koromo 'ne enenamonymbo, mo'karon Tamusi auran pyitorykon me tywaije mandon inaron nekarity'san wara ro. ");
INSERT INTO car_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Iwena'san ta awu enapa pa'poro iru'pyn me imerory poko we'kui o'wa, tywaiporen jopoto Teofilus. Morokon koromonokonymbo wyinombo ro pa'poro iru'pyn me simengai imerory uwaporo. ");
INSERT INTO car_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iwara ro tamyikapore morokon ajemepato'konymbo wairy muku'take. ");
INSERT INTO car_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Judea po poto 'su jopoto me mo'ko Herodes a'ta, amy Sakarias tatynen Tamusi pokono kynakon. Amy Abia wyinono me kynakon mo'karon Tamusi pokonokon ta'sakarykon maro. Ipyty ety me Elisabet kynakon. A'aron parymbo mo'ko Elisabet kynakon. ");
INSERT INTO car_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Okororo tamambore kynatokon Tamusi embata. Pa'poro morokon Tamusi wyka'san wararo kynemanjatokon. Mo'karon a'sakarykon amy pairo yja'wan o'to yka'pa kynatokon ipokoine. ");
INSERT INTO car_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","I'me'ma kynatokon, Elisabet 'wa tywe'mekary upiry ke. Tytam'pota, tyno'pota terapa kynatokon. ");
INSERT INTO car_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","O'wino me mo'karon Abia wyinonokon ta'sakarykon maro mo'ko Sakarias tamamine kynakon Tamusi pokono me moro Tamusi auty ta. Amykon kurita ro emaminarykon kynakon Tamusi pokonokon me. ");
INSERT INTO car_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mo'karon Tamusi pokonokon emerymbo me ro tymeramon tapusikiri emapoty'san i'waine, o'win amy tyra'nanokon ekari'to'me amy amaminano ka'nen me. Moro wara mo'ko Sakarias ekarity'po moro Tamusi auty taka o'mytoto man me, amy Tamusi 'wa tymy typoporen oty po'ma. ");
INSERT INTO car_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Moro Tamusi 'wa tymy typoporen oty po'mary jako ro Sakarias 'wa, pa'poro mo'karon kari'na apyimy Tamusi 'wa kynauranakon kurando. ");
INSERT INTO car_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Irombo amy Tamusi apojon wosenepo'po i'wa moro typoporen oty apo'ny apo'tun wyino. ");
INSERT INTO car_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ene'po mero, Sakarias we'naranga'po. Poto me imero iwety'ka'po. ");
INSERT INTO car_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mo'ko apojonano wyka'po te i'wa: “Kytety'kai koro, Sakarias. Tamusi 'wa awoturupotopombo tota man. Mo'ko apyty Elisabet mynoto me kynaitan. Wokyry'membo me kynonematan. Mo'ko ety me ro Johanes yry o'wa man. ");
INSERT INTO car_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ajewa'pory kynominotan. Pyime kari'na moro iwoma'po ewa'mata'ton. ");
INSERT INTO car_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mo'ko ro irombo poto me kynaitan Tamusi embata. Winu anenyry'pa kynaitan. Je'tun pan tanymy anenyry'pa kynaitan. Iwomarymbo ro Tamusi a'kary kynapyitan. ");
INSERT INTO car_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Pyime Israel pajanymbo u'mapotan rapa mo'ko Ijopotorykon Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Inoro uwapo ro kyny'tan mo'ko omuru mo'ko Elia a'karymbo pori'tory ta. Mo'karon uwapoto'san turu'san ewa'porotan rapa mo'karon i'makon poko. Mo'karon typanaja'naramon ypotan rapa tywonumengapore mo'karon tamamboramon wara. Iwara ro amy kari'na apyimy a'nano'tan Tamusi pyitorykon me.” ");
INSERT INTO car_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Irombo Sakarias wyka'po mo'ko apojonano 'wa: “One wara ko moro wara iwairy man suku'tan? Awu irombo tam'po'ko me terapa wa. Ypyty enapa no'po'ko me terapa man.” ");
INSERT INTO car_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Irombo mo'ko apojonano 'wa ejuku'po: “Gabriel awu wa. Tamusi embata ywaitopo man. Tamusi yjemokyi ajerupato'me, ero iru'pyn oka ekarito'me y'wa o'wa. ");
INSERT INTO car_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Epanamako. Aurana'pa maitake. Ajauranary mupitake, yjauran anamyika'pa awe'i'po ke. Morokon otykon wo'kapy'matopo kurita ajauranatake rapa. Morokon otykon kyno'ka'tan moro tywo'kapyrykon man kurita tunda'po mero.” ");
INSERT INTO car_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ijako ro mo'karon kari'na apyimy Sakarias momokyry poko kynakon kurando. Moro wara akore'pe Tamusi auty ta iwairy kynenumengapojatokon. ");
INSERT INTO car_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Irombo kurandonaka tywepa'ka'po mero, tauranary upijakon terapa i'waine. Irombo i'wa moro Tamusi auty ta amy oty wosenepo'po ukuty'po i'waine. Tainary ke roten terapa kynerupatokon. Tauranary upijakon. ");
INSERT INTO car_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Irombo Tamusi pokono me tamamingepy'ma'po mero ito'po rapa tauty 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Morombo pa'po me mo'ko ipyty Elisabet we'i'po mynoto me. Ainatone nuno asenepo'pa iwe'i'po. ");
INSERT INTO car_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ika'po: “Tamusi ro ero wara yjyryi. Kari'na 'wa ypy'i'toporymbo aike'ka nopyi.” ");
INSERT INTO car_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Irombo o'win-to'ima nuno terapa mynoto me Elisabet a'ta, Tamusi 'wa moko apojonano Gabriel emoky'po amy Galilea tano, Nasaret tatynen aitopo 'wa, ");
INSERT INTO car_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","amy wokyry maro e'ipyn amyija'ko 'wa. Mo'ko amyija'ko taporemyndo terapa kynakon amy Josef tatynen wokyry 'wa. Mo'ko wokyry ro amy David parymbo mo'ko kynakon. Mo'ko amyija'ko ety me Maria kynakon. ");
INSERT INTO car_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Irombo auto taka tywo'my'po mero, ero wara mo'ko apojonano wyka'po: “Iru'pa ro rypo man, pa'poro kurano apyinenymbo? Tamusi amaro man!” ");
INSERT INTO car_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria y'naranga'po te moro auranano 'wa. Iwonumenga'po o'to tauro'po me moro auranano wairy poko. ");
INSERT INTO car_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Irombo mo'ko apojonano wyka'po i'wa: “Kytety'kai, Maria. Kurano meporyi Tamusi ekosa. ");
INSERT INTO car_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Epanamako. Mynoto me maitake. Irombo amy wokyry'membo me monematake. Inoro ety me ro Jesus mytake. ");
INSERT INTO car_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Poto me kynaitan Tamusi embata. Mo'ko inorombo ro kawono Tamusi ymuru me kynejatota'ton. Mo'ko Kyjopotorykon Tamusi mo'ko itamurumbo David apo'nymbo tu'po kynandy'motan. ");
INSERT INTO car_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Mo'ko Jakob pajanymbo 'wa kynaitan roten poto 'su jopoto me. Inundymary i'maty'pa roten kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Irombo Maria wyka'po mo'ko apojonano 'wa: “One wara ko moro no'ka'tan? Wokyry maro waty waipo'sa.” ");
INSERT INTO car_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Irombo mo'ko apojonano wyka'po i'wa: “Tamusi wyinono a'kanano otu'ponaka kyno'tan. Mo'ko inorombo ro kawono pori'tory ajondotan. Iro ke ro enapa mo'ko kurano mo'ko kynomatan inoro ejatota'ton Tamusi ymuru me. ");
INSERT INTO car_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Epanamako! Mo'ko ajomory Elisabet enapa mynoto me man. Wokyry'membo me kynonematan, no'po'ko me tywairy se'me. O'win-to'ima nuno terapa mynoto me man mo'ko e'mekapynymbo. ");
INSERT INTO car_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","I'se Tamusi a'ta irombo pa'poro oty tywo'kapyry taro man.” ");
INSERT INTO car_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Irombo Maria wyka'po: “Ero po wa, Tamusi emyijary me. Oro awyka'po wararo nainen ymaro.” Irombo mo'ko apojonano wyto'po iwyino. ");
INSERT INTO car_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Morombo wyino ro Maria awomy'po. Iwonsi'ma'po tytory poko moro wypy 'wa, amy Judea tano aitopo 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Iwo'my'po mo'ko Sakarias auty taka. “Iru'pa ro rypo man?” ika'po Elisabet 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Mo'ko Maria auran eta'po mero Elisabet 'wa, mo'ko uwembo tano pitani wesakama'po. Irombo Tamusi a'kary 'wa Elisabet apo'i'po. ");
INSERT INTO car_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mo'ja imero Elisabet wyka'po: “Tykuranondo mana pa'poro woryijan ko'po! Tykuranondo man mo'ko ajuwembo tano pitani! ");
INSERT INTO car_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Noky ko awu wan mo'ko Yjopotory sano wo'to'me yjetawa? ");
INSERT INTO car_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Moro ajauran etary akono mero irombo y'wa, mo'se pitani ewa'pory imero nesakamai yjuwembo ta. ");
INSERT INTO car_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mo'ko woryi morokon ty'wa Tamusi nekari'po'san otykon wo'kapy'mary man amyikanon inoro sara'me 'ne kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Irombo Maria wyka'po: “Yturu'po poto me Tamusi ety awonganon. ");
INSERT INTO car_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yja'kary tawa'pore man mo'ko Yjepano'nen Tamusi poko. ");
INSERT INTO car_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Po'po tamyijary wairy kotanory tone i'wa man. Erombo wyino Tamusi newa'porory me yjejatota'ton pa'poro mo'karon eromenokon kari'na, mo'karon airenokon enapa. ");
INSERT INTO car_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mo'ko typori'token 'wa potonon otykon tyka'se man y'wano me. Kurano me 'ne ety man. ");
INSERT INTO car_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Mo'karon tynendonamon kotanory enetan mo'karon eromenokon kari'na ra'na, mo'karon airenokon ra'na enapa. ");
INSERT INTO car_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Apory tywepori'toma man. Mo'karon kynaijaton 'ne inaron taripa'po i'wa mandon aseke iwonumengarykon 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Typori'tokamon tamapo i'wa mandon apo'nykon wyino. Po'po aitonon tawonga i'wa mandon. ");
INSERT INTO car_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kumytonon 'wa iru'pyngon otykon tyje i'wa man. Typyratakamon ainary'pa tymoma i'wa mandon. ");
INSERT INTO car_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Typyitory Israel tapano'se i'wa man. Abraham kotanory tone i'wa man. Aikepy'pa roten mo'karon ipajanymbo kotanory enejan, kytangonymbo 'wa tyka'po wararo.” ");
INSERT INTO car_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Oruwa nuno iwairy taro Maria we'i'po Elisabet ekosa. Irombo mero ito'po rapa tauty 'wa. ");
INSERT INTO car_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Irombo te Elisabet wonematopo kurita tunda'po. Wokyry'membo me iwonema'po. ");
INSERT INTO car_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Irombo one wara Tamusi 'wa poto me imero ikotanory ene'po ekary eta'po mo'karon emamyry a'sakarykon 'wa, mo'karon omorykon 'wa enapa. Tawa'pore imero kynatokon imaro. ");
INSERT INTO car_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Irombo moro ijoruwa-to'imanory kurita iwopy'san mo'ko oma'senan y'kotory ene. Mo'ko ijumy Sakarias ety ta rypo yry 'se kynatokon. ");
INSERT INTO car_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mo'ko isano wyka'po te: “Uwa, Johanes te ety me kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Irombo ika'san i'wa: “Amy pairo ajomory ety te moro wara e'i'pa man.” ");
INSERT INTO car_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Irombo ijumy 'wa tainarykon ke iwoturupo'san one wara mo'ko tymuru ety yry 'se iwairy poko. ");
INSERT INTO car_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Irombo amy paranga'membo poko iwoturupo'po. Moro tu'po ‘Johanes ety me man’ mero'po i'wa. Pa'poro imero enuta'san. ");
INSERT INTO car_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Irombo te o'win wytory tauranary taro rapa iwe'i'po. Iru'pa rapa inuru we'i'po. Aurana'po rapa. Moro jako ro Tamusi ety awonga'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Irombo anari wopy'po pa'poro mo'karon emamyrykon a'sakarykon tu'ponaka. Pa'poro morokon wo'kapy'san ekary wotaripapy'po pa'poro morokon Judea ponokon wypy wararo. ");
INSERT INTO car_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Pa'poro moro oka etanamonymbo 'wa tyturu'san ta apo'i'po. Ika'san: “Oty me ko iro ke mo'se pitani naitan?” Tamusi ainary irombo kynepano'sakon. ");
INSERT INTO car_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Irombo mo'ko ijumy Sakarias apo'i'po Tamusi a'kary 'wa. Tamusi a'kary 'wa auranano'po'po Tamusi auran uku'ponen me. Ika'po: ");
INSERT INTO car_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Tykuranondo man mo'karon Israel pajanymbo Jopotory Tamusi. Mo'karon typyitorykon apyimy tatawa i'wa man. Yja'wan wyino ikato'kon tyka'se i'wa man. ");
INSERT INTO car_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Amy pari'pyn kaijomato'kon tyje i'wa man mo'ko typyitory David auty ta, ");
INSERT INTO car_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","mo'karon penatonon kurangon tauran uku'ponamonymbo wyka'san wararo. ");
INSERT INTO car_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Kaijomato'kon tyka'se i'wa man kyjenono'namon wyino, pa'poro mo'karon kanerykon 'se'non wyino enapa. ");
INSERT INTO car_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mo'karon kytangonymbo kotanory tone i'wa man. Moro tykatopombo poko ituwarengepy'pa tywairy tanepo i'wa man. ");
INSERT INTO car_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Mo'ko kytangon Abraham 'wa irombo toty ejatory ta takari'sembo me Tamusi 'wa man ");
INSERT INTO car_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","moro ky'waine enari'ma toty awongapory man ty'wa, kyjenono'namon ainary wyino kypina'san mero. ");
INSERT INTO car_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Kyrombyrykon 'wa ro moro ky'waine typynary man, moro tamamboramon me kywairykon man tyjembo me i'wa man. ");
INSERT INTO car_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Amoro te, koki, mo'ko inorombo ro kawono auran uku'ponen me ajejatota'ton. Jopoto uwapo my'take emary ka'se. ");
INSERT INTO car_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Mo'karon ipyitorykon memepatake morokon ija'wanykonymbo kary man poko Tamusi 'wa, uta'no wyino unendo'ko'me. ");
INSERT INTO car_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kotano enejan mo'ko tyturu'poporen kytamusirykon. Iro ke ro kapu wyino aweinano kyno'tan katawaine karukuri wara. ");
INSERT INTO car_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Mo'karon ewa'rumy ta romo'no nendonamon aweipatan. Sapatoro moro sara'me amano emary taka kynarota'ton.” ");
INSERT INTO car_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mo'ko pitani wetuwaro'ma'po te. Tamusi a'kary 'wa ipori'toma'po. Morokon ipono'non wo'i ta kynemanjakon mo'karon Israel pajanymbo 'wa tywosenepotopo kurita 'wa ro. ");
INSERT INTO car_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Moro jako ro mo'ko Rome pono jopoto Augustus 'wa tauranymbo aripa'po'po pa'poro mo'karon tynundymary tanokon wytoto'me totykon meropo. ");
INSERT INTO car_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sirie po jopoto me Kuirinius a'ta, koromo mo'karon kari'na etykon merory moro kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Pa'poro kari'na wyto'san tytangonymbo waito'kon 'wa totykon meropo. ");
INSERT INTO car_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josef wonuku'po enapa moro Galilea tano aitopo Nasaret wyino, moro Judea 'wa, moro Betlehem tatynen David womatopombo 'wa. David parymbo me ro irombo Josef kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mo'ko typyty man Maria maro ito'po toty meropo. Maria mynoto me kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Irombo moro Betlehem po a'taine ro, Maria nunorymbo y'maty'po. ");
INSERT INTO car_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Wokyry'membo me iwonema'po. Koromo iwe'mekatopo mo'ko kynakon. Kamisa ke inopondo'po i'wa. Irombo amy tonomy wendametopo taka enaryka'po i'wa. Iwo'ny'to'kon man waty kynakon kawo moro iwaito'kon auto ta. ");
INSERT INTO car_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Moro aitopo wyino tyse waty amykon kapara enenamon kynatokon. Wo'i ta mo'karon tokykon erandory emangatokon. ");
INSERT INTO car_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Irombo amy Tamusi apojon wopy'po i'waine. Tamusi kuranory 'wa aweipa'san imero. Poto me imero iwety'ka'san. ");
INSERT INTO car_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Irombo mo'ko apojonano wyka'po i'waine: “Kytety'katon! Epanamatoko! Amy iru'pyn oka ekari'se wopyi o'waine, pa'poro mo'karon aja'sakarykon ewa'poroto'man me. ");
INSERT INTO car_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ero kurita irombo moro David waitopombo po mo'ko Ajepano'namon man tywoma man. Mo'ko ro, Mesias me aitoto Jopoto mo'ko man. ");
INSERT INTO car_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ero poko ro muku'ta'ton inoro me iwairy: Amy pitani'membo mepota'ton tapapo amy tonomy wendametopo ta, tynopondo'ma kamisa ke.” ");
INSERT INTO car_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Irombo typo roten mo'ko apojonano ekosa amy kapu tanokon apojonano apyimy wosenepo'po. Ero wara Tamusi ety awongatokon: ");
INSERT INTO car_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kurano nainen Tamusi 'wa kapukon ta. Nono tu'po Tamusi nipynarykon 'wa sara'man amano nainen.” ");
INSERT INTO car_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Irombo kapu taka rapa mo'karon apojonano wyto'san mero, ase'wa mo'karon kapara enenamon wyka'san: “Ka'makon iro ke Betlehem 'wa, moro o'kapy'po oty ene, moro Tamusi nekaropo'po oty ene.” ");
INSERT INTO car_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Tonsine imero ito'san. Irombo Maria, Josef epory'san i'waine. Mo'ko pitani'membo tapapo kynakon amy tonomy wendametopo ta. ");
INSERT INTO car_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ene'po mero ty'waine, mo'ko pitani poko tyneta'san auranano ekaro'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Pa'poro mo'karon kapara enenamon nekarory etanamon enuta'san imero. ");
INSERT INTO car_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria 'wa te pa'poro morokon otykon kura'ma'san tyturu'po ta. Ipoko tywonumengary ko'mangapo'sakon. ");
INSERT INTO car_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Irombo mo'karon kapara enenamon werama'san rapa. Tamusi ety awonga'po i'waine pa'poro morokon tyneta'san, tynene'san otykon epory'san ke ty'waine moro tyneta'sanymbo oka wararo. ");
INSERT INTO car_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Irombo, oruwa-to'ima kurita mo'ko pitani we'i'po mero, i'koto'po i'waine. Moro jako ro ety me Jesus yry'po enapa i'waine, mo'ko apojonano wykatopombo wararo mynoto me mo'ko isano wairy uwaporo. ");
INSERT INTO car_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moro Moses karetary tano omenano mero'po wararo tywekorokamama'san mero, Jesus aro'po i'waine Jerusalem 'wa Tamusi po'ponaka aro. ");
INSERT INTO car_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ero wara irombo moro amy Tamusi nimeropo'po omenano tymero man: Pa'poro mo'ko koromo 'ne tysano uwembo wyino omatoto wokyry'membo kynaitan Tamusi 'wano me. ");
INSERT INTO car_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Moro jako enapa amy tywo me Tamusi 'wa tymy aro kyny'satokon moro Tamusi nimeropo'po omenano wykary wararo: Oko tukuruwe, oko akukuwa'makon pai. ");
INSERT INTO car_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Irombo te amy wokyry kynakon Jerusalem po, amy Simeon tatynen. Mo'ko wokyry tamambore kynakon. Tamusi poko ituwarengepy'pa roten kynemanjakon. Tamusi 'wa Israel kotanory enery man momo'sakon. Tamusi a'kary itu'po kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Tamusi a'kary 'wa ro tuku'po kynakon i'wa iromby'pa iwairy man, mo'ko Tamusi nyry'po Mesias enery uwaporo. ");
INSERT INTO car_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Mo'ko wokyry aro'po ro mo'ko Tamusi a'kary 'wa moro Tamusi auty taka. Irombo Jesus a'myka'po mero isano 'wa ijumy maro, moro omenano mero'po wararo tywaito'ko'me imaro, ");
INSERT INTO car_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","anumy'po enapa mo'ko Simeon 'wa tapoponaka. Irombo Tamusi ety awonga'po i'wa imero. ");
INSERT INTO car_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ika'po: “Erome te sara'me apyitory maropoja moro awyka'pombo wararo. ");
INSERT INTO car_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Yjenuru mo'ko o'wa uta'no wyino kari'na unendopo pitani enei, ");
INSERT INTO car_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","mo'ko anyry'po pa'poro kari'na nenery man me. ");
INSERT INTO car_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Mo'karon ajukuty'non kari'na 'wano me kynaweitatan, tynukuty'torykon otykon eneto'me i'waine. Mo'karon Israel pajanymbo ety awongatan.” ");
INSERT INTO car_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Moro wara Jesus poko Simeon wyka'po 'wa ijumy, isano enutano'po'san. ");
INSERT INTO car_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Irombo Simeon 'wa ikuranondo'san. Mo'ko isano Maria 'wa te ika'po: “Epanamako! Mo'se pitani poko ro pyimano Israel pajanymbo emapota'ton Tamusi. Pyime enapa amykon awongapota'ton i'wa. Kapu tanokon otykon enepotan mo'se pitani. Pyime kari'na ato'ke te kynaitan. ");
INSERT INTO car_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Amoro, aturu'po ta supara je'tun kyny'tan. Pyimano kari'na wonumengary wepa'kary te man ituru'san wyino.” ");
INSERT INTO car_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Moro jako 'ne amy Tamusi auran uku'ponen Ana tatynen woryi kynakon moro po. Mo'ko Aser parymbo Fanuel emyiry mo'ko kynakon. No'po'ko me terapa imero kynakon. Amyija'ko me noro ta'ta oko-to'ima siriko tyinone tywaijembo me kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Moro pa'po me te ino'ma iwaitopombo kynakon okupa'en-kari'na itu'ponaka okupa'en siriko iwairy taro terapa. Omima'pa iwaitopombo kynakon moro Tamusi auty wyino. Koko, kurita wararo Tamusi ety awongatopombo i'wa kynakon. Iwonematopombo kynakon. Tamusi 'wa auranatopombo kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Mo'ko wopy'po ro aporitonakaine. Irombo Tamusi ety awonga'po i'wa. Irombo mo'ko oma'senan poko pa'poro mo'karon yja'wan wyino Jerusalem ymbokary momo'namon erupakon. ");
INSERT INTO car_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Irombo pa'poro moro Tamusi nimeropo'po omenano wararo tywe'i'ma'san mero, iwerama'san rapa Galilea 'wa, moro tywaito'kon Nasaret 'wa. ");
INSERT INTO car_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mo'ko pitani te kynetuwaro'makon. Aseme noro tywonumengapore kynaijakon. Tamusi kuranory imaro kynakon. ");
INSERT INTO car_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Siriko wararo mo'ko Jesus sano wytotopombo kynakon ijumy maro Jerusalem 'wa, mo'ko eratonomapotopombo onory ewa'ma. ");
INSERT INTO car_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Irombo ainapatoro itu'ponaka oko siriko Jesus we'i'po mero, tamerykonymbo mero Jerusalem 'wa iwonuku'san rapa mo'ko eratonomapotopombo onory ewa'ma. ");
INSERT INTO car_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ewa'ma'ma'po mero, tyweramarykon a'mo'po i'waine rapa. Mo'ko myre'ko'ko Jesus wainopo'po te Jerusalem po mo'ko tyjumy, tysano nukuty'tory me. ");
INSERT INTO car_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mo'karon tytorykon a'sakarykon maro te kynekano'satokon ijumy, isano. Iro ke ro o'win kurita tyto'san mero, upi ito'san mo'karon tomorykon ra'naka, mo'karon tynukutyrykon ra'naka enapa. ");
INSERT INTO car_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Anepory'pa tywe'i'san mero te, upi iwerama'san rapa Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Oruwa kurita iwe'i'san upiry poko. Irombo epory'po i'waine moro Tamusi auty ta. Mo'karon amepanamon ra'na tandy'po kynakon. I'waine kynepanamakon. Kynoturupojakon enapa i'waine otykon poko. ");
INSERT INTO car_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Pa'poro mo'karon i'wa epanamatonon enumengapojakon imero moro tupu'pone iwairy, moro i'wa ejukurukon enapa. ");
INSERT INTO car_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ene'po mero, poto me imero mo'ko ijumy, isano enuta'san. Irombo mo'ko isano wyka'po I'wa: “Koki, o'tono'me ko ero wara na'na poko me'i? Tanariry ta na'na ajupiry aropotyi, awu ajumy maro!” ");
INSERT INTO car_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Irombo ika'po i'waine: “O'tono'me ko kupiton? Papa auty ta ywairy man anukuty'pa ka'tu maiton?” ");
INSERT INTO car_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","O'to pairo te ikary anukuty'pa kynatokon ty'waine. ");
INSERT INTO car_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Irombo iwo'pema'po imaroine Nasaret 'wa. Pa'poro o'to ikato'kon 'wa kynepanamakon. Mo'ko isano te pa'poro morokon otykon apyijakon tyturu'po ta. ");
INSERT INTO car_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mo'ko Jesus te kynetuwaro'makon. Aseme noro tywonumengapore, typyne kynaijakon Tamusi embata, mo'karon kari'na embata enapa. ");
INSERT INTO car_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Atone'pu siriko terapa Rome pono jopoto me Tiberius a'ta, Judea pono jopoto me Pontius Pilatus a'ta, Galilea pono jopoto me Herodes a'ta, Iturea pono jopoto me, Trakonitis pono jopoto me enapa mo'ko ipiry Filipus a'ta, Abilene pono jopoto me Lysanias a'ta, ");
INSERT INTO car_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","mo'karon Tamusi pokonokon jopotorykon me Anas a'ta mo'ko Kajafas maro, Tamusi 'wa mo'ko Sakarias ymuru Johanes auramba'po moro iponomyn wo'i ta. ");
INSERT INTO car_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Irombo Johanes wytopoty'po pa'poro moro Jordan pato, ero ekarory ta: “Ajemamyrykon u'matoko! Asetykapotoko! Irombo Tamusi oja'wanykonymbo katan.” ");
INSERT INTO car_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Mo'ko Tamusi auran uku'ponenymbo Jesaja wykato'konymbo mero'san wara iwe'i'po: Moro iponomyn wo'i ta amy ko'tatoto auran kynotanon: “Mo'ko Jopoto emary ika'toko. Sapatoro morokon emary ytoko. ");
INSERT INTO car_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Pa'poro morokon nono ansikyry a'no'kata'ton. Pa'poro wypy, pa'poro nono unsikyry kata'ton. Morokon oma wotu'mapotyry sapatoro kynaitan. Morokon oma taratarary kaperota'ton. ");
INSERT INTO car_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Irombo pa'poro kari'na moro Tamusi 'wa uta'no wyino tunendo'kon eneta'ton.” ");
INSERT INTO car_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Mo'karon kari'na apyimykon kyno'satokon i'wa asetykapo. Mo'karon 'wa ro ikatopombo kynakon: “Yja'wangonymbo 'ne roten, noky ko moro o'toto Tamusi erekuru wyino awetuwarikarykon man ekano'poi o'waine? ");
INSERT INTO car_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ajemamyrykon u'ma'po enepotoko. Aturu'san ta te kykaton: ‘Abraham na'na tamurumbo me man.’ Wykaje irombo o'waine: Tamusi erokon topu kapyry taro man Abraham pajanymbo me. ");
INSERT INTO car_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Moro wywy tyje terapa man moro wewe undy po. Pa'poro epepo'non wewe akotory kynaitan. Wa'to taka ipapyry kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Irombo mo'karon kari'na apyimykon woturupo'san Johanes 'wa: “O'to ko iro ke na'na naitan?” ");
INSERT INTO car_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Irombo ero wara Johanes 'wa ejuku'san: “Mo'ko oko tywo'mynen o'win amy tywo'my ynen mo'ko iwo'mymyn 'wa. Mo'ko pyime tarepanen arepa amy ynen mo'ko erepamyn 'wa.” ");
INSERT INTO car_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mo'ko Rome pono jopoto ekataka pyrata amo'i'namon wopy'san enapa asetykapo i'wa. Mo'karon wyka'san ro i'wa: “Amepanen, o'to ko na'na naitan?” ");
INSERT INTO car_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Irombo Johanes wyka'po i'waine: “Moro anamo'ikyrykon man pyrata ko'po kysamo'i'ton.” ");
INSERT INTO car_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Warinu pokonokon woturupo'san ro rypo i'wa: “Na'na rapa iro ke, o'to ko na'na naitan?” Irombo ika'po i'waine: “Pyrata poko kari'na kysainakerengaton. Typo roten kari'na kysemendoton, ipyratary apyito'me o'waine. Tawa'pore aitoko moro ajemamingon epety poko.” ");
INSERT INTO car_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mo'karon kari'na te mo'ko Mesias momo'satokon. Tyturu'san ta kynonumengatokon inoro me pai mo'ko Johanes wairy poko. ");
INSERT INTO car_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Irombo Johanes wyka'po pa'poro i'waine: “Awu tuna ke katykaton. Mo'ko yko'po pana'pe man inoro te kyno'san. Isapatory etandy ymbokary pairo supija. Mo'ko ro Tamusi a'kary ke ajetykata'ton, wa'to ke enapa. ");
INSERT INTO car_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Moro aresi pombokatopo aina terapa man. Irombo moro aresi werikatopo a'metan. Irombo moro aresi kura'matan moro ikura'matopo auto ta. Morokon iwerirymbo koro'katan te e'wutypyn roten wa'to ke.” ");
INSERT INTO car_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Pyime noro e'mapotyrykon ta moro iru'pyn oka ekari'sakon mo'karon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Irombo te mo'ko poto 'su jopoto Herodes e'mapoty'po i'wa, mo'ko imo'wusary Herodias poko. Pa'poro morokon inikapy'san yja'wangon otykon poko enapa Herodes e'mapoty'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Itaka ro mo'ko Johanes aru'kapo'po i'wa moro yja'wangon kari'na aru'katopo taka. ");
INSERT INTO car_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Johanes 'wa paporo mo'karon kari'na etykary jako noro te, Jesus etyka'po enapa. Irombo Tamusi 'wa auranary jako moro kapu wendaka'po. ");
INSERT INTO car_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mo'ko Tamusi a'kary wony'to'po itu'ponaka amy akukuwa eneke. Irombo kapu wyino amy auranano wota'po: “Nipynen ymuru amoro mana. Yturu'po ewa'pory me ro mana.” ");
INSERT INTO car_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus 'wa tamamin a'mory jako, o'win-kari'na itu'ponaka ainapatoro siriko iwairy taro kynakon. Mo'karon kari'na kynyjatokon mo'ko Josef ymuru me. Josef Eli ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli Matat ymuru me tywaije man, Matat Levi ymuru me tywaije man, Levi Melki ymuru me tywaije man, Melki Janai ymuru me tywaije man, Janai Josef ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josef Matatias ymuru me tywaije man, Matatias Amos ymuru me tywaije man, Amos Na'um, Na'um Hesli ymuru me tywaije man, Hesli Nagai ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Ma'at ymuru me tywaije man, Ma'at Matatias ymuru me tywaije man, Matatias Seme'in ymuru me tywaije man, Seme'in Josek ymuru me tywaije man, Josek Joda ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda Joanan ymuru me tywaije man, Joanan Resa ymuru me tywaije man, Resa Serubabel ymuru me tywaije man, Serubabel Sealtiel ymuru me tywaije man, Sealtiel Neri ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melki ymuru me tywaije man, Melki Adi ymuru me tywaije man, Adi Kosam ymuru me tywaije man, Kosam Elmadan ymuru me tywaije man, Elmadan Er ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josua ymuru me tywaije man, Josua Elieser ymuru me tywaije man, Elieser Jorim ymuru me tywaije man, Jorim Matat ymuru me tywaije man, Matat Levi ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi Simeon ymuru me tywaije man, Simeon Juda ymuru me tywaije man, Juda Josef ymuru me tywaije man, Josef Jonan ymuru me tywaije man, Jonan Eljakim ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eljakim Melea ymuru me tywaije man, Melea Mena ymuru me tywaije man, Mena Matata ymuru me tywaije man, Matata Natan ymuru me tywaije man, Natan David ymuru me tywaije man, David Isai ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Isai Obed ymuru me tywaije man, Obed Boas ymuru me tywaije man, Boas Salmon ymuru me tywaije man, Salmon Nakson ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nakson Aminadab ymuru me tywaije man, Aminadab Admin ymuru me tywaije man, Admin Arni ymuru me tywaije man, Arni Hesron ymuru me tywaije man, Hesron Peres ymuru me tywaije man, Peres Juda ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda Jakob ymuru me tywaije man, Jakob Isak ymuru me tywaije man, Isak Abraham ymuru me tywaije man, Abraham Tera ymuru me tywaije man, Tera Nahor ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor Serug ymuru me tywaije man, Serug Re'u ymuru me tywaije man, Re'u Peleg ymuru me tywaije man, Peleg Eber ymuru me tywaije man, Eber Sela ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela Kenan ymuru me tywaije man, Kenan Arpaksad ymuru me tywaije man, Arpaksad Sem ymuru me tywaije man, Sem Noe ymuru me tywaije man, Noe Lamek ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek Metusale ymuru me tywaije man, Metusale Henok ymuru me tywaije man, Henok Jered ymuru me tywaije man, Jered Mahalalel ymuru me tywaije man, Mahalalel Kenan ymuru me tywaije man, ");
INSERT INTO car_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan Enos ymuru me tywaije man, Enos Set ymuru me tywaije man, Set Adam ymuru me tywaije man, Adam Tamusi ymuru me tywaije man. ");
INSERT INTO car_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tamusi a'kary 'wa tapyije Jesus werama'po moro Jordan wyino. Moro jako ro Tamusi a'kary pori'tory ta itopoty'po moro iponomyn wo'i ta. ");
INSERT INTO car_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Oko-kari'na kurita moro po iwe'i'po, mo'ko ewa'rumy tamuru 'wa tu'kuru ta. Morokon kurita endame'pa pairo iwe'i'po. Moro pa'po me te ikumyry'po. ");
INSERT INTO car_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Irombo mo'ko ewa'rumy tamuru wyka'po I'wa: “Tamusi ymuru me ro aja'ta iro ke, ero topu 'wa ajauranako iwonurimato'me perere me.” ");
INSERT INTO car_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Irombo Jesus 'wa ejuku'po: “Tymero man: Perere poko roten kari'na emamy'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Irombo Jesus aro'po i'wa kawonaka. Ko'i roten imero pa'poro ero nono tu'ponokon potonon jopotokon nundymary enepo'san i'wa Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Irombo mo'ko ewa'rumy tamuru wyka'po I'wa: “Pa'poro erokon potonon aito'kon morokon ikuranorykon maro ro ajainaka sytake. Erokon irombo yjainaka tyje man. Ynisanorymbo 'wa ro yry yjaina man. ");
INSERT INTO car_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Iro ke ko'wu tokuna'po yjety awonga'poto o'wa, pa'poro ajotyry me kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Irombo Jesus 'wa ejuku'po: “Ero wara tymero man: Ajopotory Tamusi po'ponaka roten mokunamatake. Mo'ko ety roten mawongatake.” ");
INSERT INTO car_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Irombo Jerusalem 'wa Jesus aro'po i'wa. Moro Tamusi auty retyry esipiry tu'ponaka yry'po i'wa. Irombo ika'po I'wa: “Tamusi ymuru me ro aja'ta, ata'porongo ero wyino po'ponaka. ");
INSERT INTO car_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Tymero irombo man: Tamusi tapojongon emo'tan ajaijomato'me i'waine. ");
INSERT INTO car_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Awomarymbo apyita'ton, apupuru aniwo'pa awaito'me topu pona.” ");
INSERT INTO car_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Irombo Jesus 'wa ejuku'po: “Moro Tamusi karetary kynganon: Mo'ko Ajopotory Tamusi anu'ku'pa maitake.” ");
INSERT INTO car_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Irombo Jesus u'ku'ma'po mero ty'wa, inonda'po 'non mo'ko ewa'rumy tamuru 'wa. ");
INSERT INTO car_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Irombo Tamusi a'kary pori'tory ta Jesus werama'po rapa Galilea 'wa. Moro po ro pa'poro wararo ekary wota'po. ");
INSERT INTO car_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Emepato'konymbo i'wa kynakon morokon iwota'nano'to'kon autokon ta. Pa'poro mo'karon auran etanamon 'wa ety awongatopombo kynakon. ");
INSERT INTO car_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Irombo moro Nasaret, moro tywetuwaro'matopombo 'wa itunda'po. Irombo tamerymbo me ro moro otare'matopo kurita ito'po moro Simosu wota'nano'to'kon auto taka. Irombo awomy'po moro Tamusi karetary erupato'me. ");
INSERT INTO car_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Mo'ko Tamusi auran uku'ponenymbo Jesaja auranymbo mero'po kareta yry'po i'waine ainaka. Irombo moro kareta karanga'po i'wa. Ero mero'po epory'po i'wa: ");
INSERT INTO car_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Tamusi a'kary ytu'po man. Irokero Tamusi 'wa tapyije wa mo'karon oty'non 'wa amy iru'pyn oka ekari'nen me. Tamusi 'wa tapojoma wa mo'karon imy'san 'wa imbokarykon man ekari'to'me, mo'karon enu'non 'wa enutarykon man ekari'to'me, sara'man amano taka mo'karon ikota'ma'san yto'me, ");
INSERT INTO car_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","moro Tamusi 'wa tykuranory enepotopo siriko ekaroto'me enapa. ");
INSERT INTO car_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ero erupa'ma'po mero ty'wa, moro kareta amemy'po rapa i'wa. Yry'po rapa i'wa mo'ko pyitonano 'wa. Irombo iwotandy'mo'po. ");
INSERT INTO car_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Pa'poro moro Simosu wota'nano'to'kon auto tano onunano kyno'po'sakon i'wa. Irombo ko'wu Jesus wyka'po i'waine: “Erome ro moro aneta'san ynerupa'po kyno'ka'san.” ");
INSERT INTO car_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Irombo pa'poro mo'karon epanamatonon 'wa iporo moro auran wairy ekarity'po. Moro auran kuranory 'wa imero poto me enutano'po'san. Irombo ika'san: “Mo'ko Josef ymuru kapyn mo'se nan?” ");
INSERT INTO car_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Irombo Jesus wyka'po i'waine: “Ero kari'na wykatopo pa'me ro awykarykon man suku'sa y'wa: ‘Apino'nen, aseke opino'ko! Pa'poro morokon na'na neta'san Kafaraum po anikapy'san otykon ero awomatopombo po enapa ika'ko.’ ” ");
INSERT INTO car_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ika'po te: “Ita'ro pore, amy pairo Tamusi auran uku'ponen isano'pambo man moro tywetuwaro'matopombo aitopo po. ");
INSERT INTO car_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yjauran irombo amyikatoko. Elia jako pyime inongepy'san tywaije mandon mo'ko Israel pajanymbo ra'na. Moro jako ro oruwa siriko itu'ponaka o'win-to'ima nuno moro kapu tatapuje tywaije man. Pa'poro ero nono tu'po poto 'su kumyno tywaije man. ");
INSERT INTO car_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ise'me te Elia anemoky'pa Tamusi tywaije man amy pairo 'wa. Amy Sarefat pono inongepy'po 'wa roten Tamusi 'wa tomo'se tywaije man, moro aitopo Sidon wyinonaka. ");
INSERT INTO car_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Mo'ko Tamusi auran uku'ponenymbo Elisa jako ko'wu pyime areky pangon tywaije mandon mo'ko Israel pajanymbo ra'na. Amy pairo te ikura'ma'pa tywaije man. Mo'ko Sirie pono Na'aman roten iru'pa rapa tyje tywaije man.” ");
INSERT INTO car_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Moro wara ikary eta'po mero ty'waine, pa'poro moro Simosu wota'nano'tokon auto tanokon wore'ko'san imero. ");
INSERT INTO car_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Awomy'san. Irombo imoma'po i'waine moro tywaito'kon wyino. Moro tywaito'kon apo'ny wypy eme'tairy 'wa ro aro'po i'waine, po'ponaka emato'me. ");
INSERT INTO car_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ira'naine ro te Jesus wyto'po moro wyino. ");
INSERT INTO car_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Irombo moro Galilea tano aitopo Kafaraum 'wa iwo'pema'po. Moro po ro emepa'san i'wa morokon otare'mato'kon kurita. ");
INSERT INTO car_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Morokon i'wa emepato'kon 'wa imero poto me enutano'po'san, amy poto 'su jopoto wara imero auranary ke. ");
INSERT INTO car_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Moro Simosu wota'nano'to'kon auto ta ro amy yja'wan akywano pan wokyry kynakon. Mo'ko ko'ta'po ro mo'ja imero: ");
INSERT INTO car_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“O'tono'me 'ne ko na'na poko man, se, Nasaret pono? Na'na uta'ka ka'tu mopyi? Suku'sa noky me awairy. Amoro 'ne ro mo'ko Tamusi wyinono me mana!” ");
INSERT INTO car_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Irombo apo'tun pe Jesus 'wa e'ma'po: “Ity'me aiko! Epa'kako mo'ko wyino!” Irombo owarira'naka imero mo'ko yja'wan 'wa mo'ko wokyry ema'po. Irombo iwepa'ka'po iwyino. Amy o'to pairo anyry'pa iwe'i'po. ");
INSERT INTO car_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Pa'poro kari'na we'naranga'san. Ase'wa ika'san: “Otypan auranano ko moro nan? Jopoto wara kore imero mo'karon yja'wangon akywano poko napo'tunapo'sa, ran! Irombo kore nepa'katon, ran!” ");
INSERT INTO car_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Irombo moro inikapy'po ekary wotaripapy'po pa'poro morokon moro ponokon aito'kon wararo. ");
INSERT INTO car_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Irombo Jesus awomy'po moro Simosu wota'nano'to'kon wyino. Simon auty 'wa ito'po. Mo'ko Simon y'menoty je'tun pan komyinano pe kynakon. Iwoturupo'san i'wa epano'to'me. ");
INSERT INTO car_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Irombo eponaka Jesus wonsuma'po. Moro komyinanombo e'ma'po i'wa. Irombo moro komyinanombo wyto'po iwyino. O'win wytory mo'ko woryi awomy'po. Upa'san terapa i'wa. ");
INSERT INTO car_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Irombo weju wo'myry mero pa'poro kari'na 'wa mo'karon ukuty'pa 'ne roten anyky pangon ta'sakarykon enepy'san I'wa. Iwe'i'san mero tainary yry'po I'wa itu'ponakaine. Ikura'ma'san rapa I'wa. ");
INSERT INTO car_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Pyime kari'na wyino tyko'keine imero yja'wangon akywano wepa'ka'san enapa. Kyngatokon: “Tamusi ymuru amoro mana!” Jesus 'wa te apo'tun pe e'ma'san. Anauranano'po'paine pairo iwe'i'po, mo'ko Mesias me tywairy ukutyry ke i'waine. ");
INSERT INTO car_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Emamy'po mero iwepa'ka'po. Amy iponomyn 'wa ito'po. Moro jako ro mo'karon kari'na apyimykon kynupijatokon. Irombo itunda'san I'wa. Itory pona tywyinoine kyna'kotojatokon. ");
INSERT INTO car_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ika'po te i'waine: “Morokon amykon terapa aito'kon po enapa moro Tamusi nundymary ekapory ekarityry y'wa man. Moro waton me ro irombo tomo'se wa.” ");
INSERT INTO car_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Irombo morokon Judea ponokon Simosu wota'nano'to'kon autokon ta moro iru'pyn oka ekarory aropoty'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Irombo moro Genesaret wyinono tuna juwembory esi'wo mo'karon kari'na apyimy moro Tamusi auranymbo etakon. Iwotunsi'korykon mero tytu'ponaka, ");
INSERT INTO car_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesus 'wa oko kurijara wo'kima'san ene'san. Mo'karon woto pokonokon tywo'ka kynatokon morokon kurijara wyino. Tysipirykon ku'mi'satokon. ");
INSERT INTO car_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Irombo Jesus wotaru'ka'po moro o'win amy kurijara taka. Simon kurijarary moro kynakon. Irombo Jesus woturupo'po Simon 'wa a'si 'ko moro tykurijarary emo'to'me i'wa ira'naka. Ita tandy'po ro mo'karon kari'na apyimy emepakon. ");
INSERT INTO car_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tauranary poko taikepy'po mero, ika'po Simon 'wa: “Epa'kako ira'naka. Irombo woto poko asipirykon ipa'toko.” ");
INSERT INTO car_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Irombo Simon 'wa ejuku'po. Ika'po: “Amepanen, pa'poro ero koko na'na wo'mika'po se'me, amy nokymbo ro anapo'i'pa na'na ne'i. Ajauran poko te erokon sipi sipa'take.” ");
INSERT INTO car_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Moro wara tywe'i'san mero, moky imero woto apo'i'san i'waine. Morokon isipirykon imero kyno'sekakon rypo. ");
INSERT INTO car_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Irombo mo'karon moro kurijara akono tanokon tamamingon a'sakarykon apomapoty'san i'waine tapano'seine iwo'toko'me. Irombo iwopy'san. Okororo morokon kurijarakon a'no'ka'san i'waine. Kynotu'mu'satokon rypo. ");
INSERT INTO car_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Moro ene'po mero te ty'wa, tokuna'po Simon Petrus woma'po Jesus po'ponaka. Ika'po: “Jopoto, i'tango ywyino. Tyja'wange irombo wa.” ");
INSERT INTO car_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Mo'karon woto apyimy apo'i'po 'wa enutano'po'po pa'poro mo'karon ta'sakarykon maro. ");
INSERT INTO car_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedeus ymurukon Jakobus, Johanes enuta'san enapa poto me imero. Mo'karon ro mo'ko Simon emaminary a'sakarykon me kynatokon. Irombo Jesus wyka'po Simon 'wa: “Kytety'kai! Erombo wyino kari'na apyiry poko maitake.” ");
INSERT INTO car_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Morokon kurijara awo'nuku'san mero ty'waine maponaka, pa'poro totyrykonymbo nonda'san i'waine. Jesus wena'po ta terapa ito'san. ");
INSERT INTO car_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Irombo amy moro pono aitopo ta Jesus a'ta, amy areky na'no'ka'po wokyry moro po kynakon. Jesus ene'po mero ty'wa, tombata'po iwoma'po. Jesus 'wa iwe'pima'po: “Jopoto, i'se aja'ta, ykura'mary taro mana.” ");
INSERT INTO car_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Irombo Jesus 'wa tainary tynga'po. Apo'i'po i'wa. Ika'po: “Ekura'mako rapa iro ke.” Irombo o'win wytory moro erekyrymbo utapy'po. ");
INSERT INTO car_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Irombo ika'po i'wa, amy pairo 'wa anekarity'pa iwaito'me. Ikapo: “Asenepotango te mo'ko Tamusi pokono 'wa. Moro awekura'ma'po poko mo'ko Moses wykatopombo yko Tamusi 'wa, Tamusi emamina'po amyikato'me i'waine.” ");
INSERT INTO car_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ise'me te wararo 'ne ka'tu rapa Jesus ekary wotaripapy'po. Irombo pyime kari'na apyimykon wota'nanopy'san ekosa auran etato'me, tanykyrykonymbo kato'me enapa i'wa. ");
INSERT INTO car_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jesus wytotopombo te kynakon ipono'non 'wa. Moro po ro Tamusi 'wa auranatopombo kynakon. ");
INSERT INTO car_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Amy kurita Jesus mo'karon ata'nanopy'san emepatokon. Amykon Farise amykon omenano mero'po poko amepanamon maro moro po tandy'po kynatokon. Pa'poro morokon Galilea tanokon aito'kon wyino, morokon Judea tanokon aito'kon wyino, Jerusalem wyino enapa moro 'wa tywota'nano'se kynatokon. Tamusi pori'tory Jesus maro kynakon mo'karon je'tun pangon kura'mato'me. ");
INSERT INTO car_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Irombo te amykon wokyryjan 'wa amy iwajakuta'po wokyry enepy'po ipaty tu'po ro. A'mykary u'ku'po rypo i'waine, Jesus po'ponaka yto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Tunsi'ke mo'karon kari'na apyimy wairy ke, a'mykary upi'po i'waine. Irombo moro auto re'taka iwonuku'san. A'si 'ko moro auto aputymbo ka'po mero ty'waine, ipaty tu'po ro mo'ko iwajakuta'po eny'topo'po i'waine owarira'naka Jesus po'ponaka. ");
INSERT INTO car_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Moro i'waine poto me Tamusi amyikary enery ke ty'wa, Jesus wyka'po: “Ty'wo, morokon oja'wanykonymbo tyka man.” ");
INSERT INTO car_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Irombo mo'karon Tamusi karetary uku'namon wyka'san mo'karon Farise maro: “Noky 'ne ko mo'se nan, mo'se Tamusi ety jamikanen? Noky aina ko yja'wan me e'i'san kary nan? Tamusi aina roten kapyn?” ");
INSERT INTO car_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Moro wara te iwonumengarykon ukuty'po mero ty'wa, ejuku'san Jesus 'wa: “O'to ko mykaton aturu'san ta? ");
INSERT INTO car_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Otypan ko ija roten nan? Awykary mo'se iwajakuta'po 'wa ‘Oja'wanykonymbo tyka man.’? Awykary te ka'tu ‘Ajawongo. Itango.’? ");
INSERT INTO car_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","O'po'toko, muku'to'se me mo'ko kari'na ymuru aina moro yja'wan me e'i'po kary wairy ero nono tu'po.” Irombo ika'po mo'ko iwajakuta'po 'wa: “Ajawongo amoro. Apaty anungo. I'tango ajauty 'wa.” ");
INSERT INTO car_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Irombo inenerykon me ro o'win wytory awomy'po. Moro typatymbo anumy'po i'wa. Irombo tauty 'wa ito'po, Tamusi ety awongary ta. ");
INSERT INTO car_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Pa'poro imero iwe'naranga'san. Tamusi ety awonga'po imero i'waine. Poto me tywety'karykon ta ika'san: “Atukuty'non otykon erome kyseneton.” ");
INSERT INTO car_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Morombo wyino kurandonaka tyto'po mero, mo'ko Rome pono jopoto ekataka pyrata amo'i'nen Levi tatynen ene'po Jesus 'wa. Levi tandy'po kynakon moro pyrata amo'i'topo auto po. Irombo Jesus wyka'po i'wa: “O'ko ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Irombo Levi awomy'po. Pa'poro otymbo nonda'po i'wa. Jesus wena'po ta terapa ito'po. ");
INSERT INTO car_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Irombo Levi 'wa amy poto 'su endameno ka'po'po tauty ta Jesus ewa'mato'me. Pyime imero mo'ko Rome pono jopoto ekataka pyrata amo'i'namon tywo'se kynatokon. Pyime enapa amykon roten kari'na imaroine kynendamejatokon. ");
INSERT INTO car_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Irombo mo'karon Farise 'wa, mo'karon Tamusi karetary uku'namon 'wa enapa toruwarykon enepy'po mo'karon Jesus nemeparykon 'wa. Ika'san: “O'tono'me ko mendamejaton mo'ko Rome pono jopoto ekataka pyrata amo'i'namon maro, mo'karon tyja'wangamon maro enapa?” ");
INSERT INTO car_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Irombo Jesus 'wa ejuku'san: “Anyky'non amy tapino'namon anupi'pa mandon. Je'tun pangon te amy tapino'namon upijaton. ");
INSERT INTO car_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Tamamboramon ko'ma opy'pa we'i. Mo'karon tyja'wangamon ko'ma te wopyi, tamamyrykon u'mato'me i'waine.” ");
INSERT INTO car_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Irombo Jesus 'wa ika'san: “Mo'karon Johanes nemeparykon, mo'karon Farise nemeparykon enapa o'kapyn roten kynonematon, Tamusi 'wa otykon poko tywoturuporykon ta. Mo'karon anemeparykon te ko'wu kynendamejaton roten.” ");
INSERT INTO car_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesus wyka'po i'waine: “Mo'karon oko amykon aimytonon ewa'manamon enemapory taro 'kare mandon, mo'ko pytatoto a'ta ekosaine? ");
INSERT INTO car_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amy jako te mo'ko pytatoto pinata'ton iwyinoine. Irombo mero kynonemata'ton.” ");
INSERT INTO car_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amy enapa onumengatopo auranano ekarity'po i'wa i'waine: “Amy pairo kari'na amy asery wo'mynano aniseka'pa man, amy ipunu'po ato'to'me amy penato'po wo'mynanombo pokonaka. Ijako moro asery wo'mynano any'matan. Moro penato'po 'wa waty ro rypo moro asery wo'mynano punu'po kynaitan. ");
INSERT INTO car_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Amy pairo kari'na enapa asery winu anije'nyndo'pa man penato'san tonomy pi'sanymbo kapy'san ke. Ijako moro asery winu morokon tyje'nykonymbo sekatan. Irombo kynotakamatan moro winu. Morokon ije'nykonymbo kynotany'mata'ton. ");
INSERT INTO car_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Asery winu yry te man asery ije'ny taka. ");
INSERT INTO car_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Amy pairo kari'na enapa asery winu 'se'pa man, penato enyry'poto ty'wa. Kynganon irombo: ‘Moro penato winu iru'pa 'ne ka'tu rapa man.’ ” ");
INSERT INTO car_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Amy otare'matopo kurita Jesus kyny'sakon morokon awasi paty ta. Moro jako ro mo'karon inemeparykon morokon awasi ejakatokon. Morokon epery ena'to'me ty'waine, tainarykon ke kynakatokon. ");
INSERT INTO car_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Irombo te amykon Farise wyka'san: “O'tono'me ko moro otare'matopo kurita tykapymy waty oty mika'saton?” ");
INSERT INTO car_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Irombo Jesus 'wa ejuku'san: “O'to mo'ko David we'i'po anerupa'pa mandon, moro kumyno ta ta'ta mo'karon ta'sakarykon maro? ");
INSERT INTO car_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Moro Tamusi auty taka tywo'my man. Morokon Tamusi embata yry'san perere typina i'wa man. Tana'se i'wa man. Mo'karon ta'sakarykon enapa tupa i'wa mandon ike. Morokon perere enapyry waty man amy typono roten kari'na 'wa. Mo'karon Tamusi pokonokon 'wa roten te enapyry man.” ");
INSERT INTO car_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Irombo Jesus wyka'po i'waine: “Mo'ko kari'na ymuru moro otare'matopo kurita jopotory me man.” ");
INSERT INTO car_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Irombo amy terapa otare'matopo kurita Jesus wo'my'po moro Simosu wota'nano'to'kon auto taka. Irombo kynemepatokon. Moro jako ro amy apo'tun wyino ainamiriri'ta'po wokyry moro po kynakon. ");
INSERT INTO car_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mo'karon Tamusi karetary uku'namon, mo'karon Farise enapa tuwaro kynatokon. Moro otare'matopo kurita ikura'mary enery 'se kynatokon i'wa, emendoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesus te iwonumengarykon uku'sakon. Irombo ika'po mo'ko ainamiriri'ta'po 'wa: “Ajawongo. O'ko 'ne owarira'naka.” Irombo awomy'po. Owarira'naka ito'po. ");
INSERT INTO car_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Irombo Jesus wyka'po i'waine: “Amy oty poko waturupoja o'waine. Iru'pa nan moro otare'matopo kurita aja'sakary poko iru'pa awairy, yja'wan me ipoko awairy te ka'tu? Iru'pa nan moro otare'matopo kurita amy aja'sakary rombyrymbo awongary o'wa, iromo'kapory te ka'tu o'wa?” ");
INSERT INTO car_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Pa'poro i'waine Jesus wo'poty'po. Irombo ika'po mo'ko wokyry 'wa: “Ajainary ityngako!” Moro tainary tynga'po i'wa. Iru'pa rapa moro ainary we'i'po. ");
INSERT INTO car_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mo'karon Tamusi karetary uku'namon, mo'karon Farise enapa wore'ko'san te imero. Ase'wa iworupa'san o'to Jesus yry man poko. ");
INSERT INTO car_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Moro jako noro Jesus wonuku'po moro wypy tu'ponaka tauranato'me Tamusi 'wa. Tauranary emanga'po i'wa Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Emamy'po mero, mo'karon tynemeparykon ko'ma'san i'wa ty'wa. Iwyinoine ro ainapatoro itu'ponaka oko amykon yry'san i'wa typo. Mo'karon ejatojakon enapa apojonanokon me. ");
INSERT INTO car_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Mo'karon etykon ro kynatokon: Simon (Petrus me enapa Jesus kynejatojakon), ipiry Andreas, Jakobus, Johanes, Filipus, Bartolomeus, ");
INSERT INTO car_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus, Tomas, mo'ko Alfeo ymuru Jakobus, Simon (mo'ko o'wo'matonon a'sakarymbo me enapa kynejatojatokon), ");
INSERT INTO car_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","mo'ko Jakobus ymuru Judas, Judas Iskariot (mo'ko 'wa ro Jesus takarama man). ");
INSERT INTO car_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Irombo Jesus wo'pema'po imaroine moro wypy wyino. Amy ipipakyry po iporopy'po. Moky imero inemeparykon moro po imaro kynatokon. Amy kari'na apyimy tam'pokory enapa tywo'se kynakon pa'poro morokon Judea tanokon aito'kon wyino, Jerusalem wyino, morokon parana wyinonokon aito'kon Tyrus, Sidon wyino enapa. ");
INSERT INTO car_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","I'wa tywo'se kynatokon epanama, tanykyrykonymbo wyino ekura'mapo enapa. Mo'karon yja'wangon akywano naki'marykon wekura'ma'san rapa. ");
INSERT INTO car_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Pa'poro imero mo'karon kari'na apyimy i'tu'kary 'se kynakon pa'poro ikura'marykon ke i'wa moro tywyino epa'katoto pori'tonano ke. ");
INSERT INTO car_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Irombo iwo'poty'po mo'karon tynemeparykon 'wa. Ika'po: “Sara'me 'ne janon maita'ton, amyjaron oty'pambo aitonon! O'wanokon me ro irombo moro Tamusi nundymary man. ");
INSERT INTO car_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sara'me 'ne janon maita'ton, amyjaron erome kumytonon! Maimeta'ton irombo. Sara'me 'ne janon maita'ton, amyjaron erome atamotonon! Ajauwata'ton irombo.” ");
INSERT INTO car_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Sara'me 'ne janon maita'ton, mo'ko kari'na ymuru upu'po me mo'karon kari'na 'wa ajenonopyrykon jako, amomarykon jako, ajejurukon jako, ajetykon emapory jako yja'wan atywano wara. ");
INSERT INTO car_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Irokon wo'kapyry jako, tawa'pore aitoko me. Ajewa'porykon nuwan. Moro ajepetykon irombo poto me man kapu ta. Iwara enapa irombo mo'karon Tamusi auran uku'ponamonymbo tykota'ma tywaije mandon mo'karon eromenokon tangonymbo 'wa. ");
INSERT INTO car_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Je'tun pe pore te kynaitan o'waine, typyratakamon! Aturu'san andy'moto'kon irombo mapo'i'ma'ton terapa. ");
INSERT INTO car_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Je'tun pe pore kynaitan o'waine, erome asiwo'tatonon! Akumyrykon irombo awota'ton. Je'tun pe pore te kynaitan o'waine, erome auwapo'tonon! Kata'mato 'ne irombo maita'ton. ");
INSERT INTO car_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Je'tun pe pore kynaitan o'waine, pa'poro kari'na 'wa iru'pa ajekarityrykon jako. Iwara enapa irombo mo'karon Tamusi auran uku'ponen waikamon iru'pa takari'se mandon mo'karon itangonymbo 'wa.” ");
INSERT INTO car_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“O'waine te, epanamatonon me, wykaje: Ajenono'namon ipynatoko. Mo'karon tyturu'san ta ajapyinamon poko iru'pa aitoko. ");
INSERT INTO car_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mo'karon ajany'manamon ikuranondotoko. Mo'karon mene ajejunamon poko Tamusi 'wa ajauranatoko. ");
INSERT INTO car_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","“Mo'ko apasapaikanen wyinonaka moro apasary akono enapa u'mako. Mo'ko itu'pono awo'my pinanen 'wa moro upi'nono awo'my pinary enapa kysa'kotoi. ");
INSERT INTO car_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Pa'poro mo'karon o'wa e'pimatonon 'wa inisanorykon yko. Ajotyrykonymbo pinanen 'wa kytoturupoi morokon otykon poko. ");
INSERT INTO car_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Mo'karon kari'na 'wa ajenarykon 'se awairykon wara enapa mo'karon kari'na enatoko. ");
INSERT INTO car_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Mo'karon apynanamon pynary jako o'waine, otypan iru'pyn oty ko moro nan? Mo'karon tyja'wangamon kari'na enapa irombo mo'karon typynanamon pynaton. ");
INSERT INTO car_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Iru'pa mo'karon iru'pa ajenanamon enary jako o'waine, otypan iru'pyn oty ko moro nan? Mo'karon tyja'wangamon kari'na irombo moro wara enapa kynaijaton. ");
INSERT INTO car_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Mo'karon oty y'petakamanamon me anekanopyrykon 'wa oty a'kupory jako o'waine, otypan iru'pyn oty ko moro nan? Mo'karon tyja'wangamon kari'na enapa totyrykon a'kupojaton tyja'wangamon kari'na 'wa, i'petakan apyito'me rapa ty'waine. ");
INSERT INTO car_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","“Mo'karon ajenono'namon te ipynatoko! Iru'pa enatoko! Ajotyrykon a'kupotoko i'waine. Yry rapa kysimomo'ton. Moro moro wara awe'i'san epety ro poto me kynaitan. Mo'ko inorombo ro kawono y'makon me maita'ton. Mo'ko enapa irombo mo'karon tynapo'i'san iru'pyn oty poko tawa'porykon anenepo'non enanon iru'pa. Mo'karon yja'wangon kari'na enanon ro rypo iru'pa. ");
INSERT INTO car_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Kotano enetoko, mo'ko kapu tano ajumy 'wa kotano enery wara. ");
INSERT INTO car_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Aja'sakarykon kysemendoton. Irombo emendo'paine maita'ton. Aja'sakarykon u'tano me amy oty kysekari'ton. Irombo aju'tano me amy oty ekarity'pa kynaitan. Yja'wan me aja'sakarykon we'i'san ikatoko. Irombo yja'wan me awe'i'san kyno'katan. ");
INSERT INTO car_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Otykon ytoko. Irombo otykon mapyita'ton. Otykon mapyita'ton u'kutopo ta taky'ka me, tysekesekema me, tu'pese'ke imero. Moro ana'kurukon oty u'kutopo ke enapa otykon u'kuta'ton o'waine.” ");
INSERT INTO car_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Amy onumengatopo auranano ekarity'po enapa i'wa i'waine: “Amy enupyn amy enupyn arory taro nan? Okororo oma'pa naita'ton amy nono atory taka? ");
INSERT INTO car_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","“Amy omepatoto mo'ko tamepanen ko'po e'i'pa man. Pa'poro kari'na te tywomepa'ma'po mero mo'ko tamepanen wara kynaitan. ");
INSERT INTO car_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“O'tono'me ko mo'ko aja'sakary enuru aki'manen wewe pisara'po poko mo'po'san? Moro aseke ajenuru aki'manen wakapu anene'pa te mana. ");
INSERT INTO car_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","One wara ko mo'ko aja'sakary 'wa mykatan ‘Ito'my, o'ko 'ne, moro wewe pisara'po sika'se me ajenuru wyino,’ moro aseke ajenuru tano wakapu anene'pa aja'ta? Tonapiren 'ne roten! Moro wakapu na'nen ikako aseke ajenuru wyino! Irombo mero iru'pa mo'po'take moro aja'sakary enuru tano wewe pisara'po kato'me o'wa.” ");
INSERT INTO car_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Amy iru'pyn wewe irombo yja'wangonymbo me epeta'pa man. Iwara enapa amy yja'wanymbo wewe kurangon me epeta'pa man. ");
INSERT INTO car_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Pa'poro wewe uku'san kari'na epery poko. Kari'na irombo moro oroi epery anipoty'pa man takyramon itupu wyino. Moro winu me tykapymy wonatopo anipoty'pa enapa man paremuru wyino. ");
INSERT INTO car_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","“Mo'ko iru'pyn kari'na moro kurano je'ny tyturu'po wyino kurano pa'kanon. Mo'ko yja'wan kari'na ko'wu moro tyja'wany je'ny wyino yja'wan oty pa'kanon. Moro kari'na turu'po tano wotakamary irombo indary wyino kyno'san.” ");
INSERT INTO car_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“O'tono'me ko Jopoto me kajatopo'saton, moro o'to ywykary wara waty aja'taine? ");
INSERT INTO car_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Noky wara pa'poro mo'karon y'wa o'tonon, mo'karon yjauran 'wa epanamatonon, irombo moro tyneta'san ka'namon wairy senepoja o'waine. ");
INSERT INTO car_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Amy auto amynen wara mandon. Koro'naka moro sakau amikanon. Topu tu'po moro apo'ny ka'san. Ikuma'po mero, moro tuna apeiny kyno'wojan moro auto pona. Anisakama'pa pairo te man, iru'pyn me tamy iwairy ke. ");
INSERT INTO car_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mo'ko y'wa epanamatoto, irombo morokon tyneta'san wara e'i'pa aitoto, amy sakau tu'po apo'ny'ma tauty amynen wara man. Moro tuna apeiny kyno'wojan moro auto pona. Irombo o'win wytory moro autombo kynomanon. Pa'poro imero kyno'tororokanon.” ");
INSERT INTO car_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Taurana'ma'po mero mo'karon kari'na 'wa, Kafaraum taka iwo'my'po. ");
INSERT INTO car_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Irombo te amy Rome pono warinu pokonokon jopotory nipynary ipyitory mene je'tun pe kynakon. Kyniromo'sakon terapa. ");
INSERT INTO car_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesus ekary etary ke ty'wa, amykon uwapoto'san Simosu emoky'san i'wa Jesus 'wa, iwoturupoto'ko'me, mo'ko typyitory epano'se iwo'to'me irombyry pona. ");
INSERT INTO car_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tytunda'san mero Jesus 'wa, iwe'pima'san imero. Ika'san: “Epanopyry o'wa iru'pa man. Kypynaton irombo. Simosu pynanon, wykaje irombo. ");
INSERT INTO car_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Moro kywota'nano'to'kon auto ro rypo kakatakaine tamypo i'wa man.” ");
INSERT INTO car_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Irombo Jesus wyto'po imaroine. Tyse waty iwe'i'po mero te moro auto wyino, mo'ko jopoto 'wa amykon ta'sakarykon emoky'san I'wa, tauranymbo ekari'se: “Jopoto, kyto'mikai! Uwam'po watapoja yjauty taka awo'myto'me. ");
INSERT INTO car_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Iro ke ro aseke ywopyry 'se'pa we'i o'wa. Ajauranako roten te mo'ko ypyitory waito'me iru'pa rapa. ");
INSERT INTO car_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Awu ro rypo jopoto nundymary me wa. Ynundymarykon me rapa warinu pokonokon mandon. Amy 'wa ywyka'poto: ‘I'tango!’ kyny'san. Amy 'wa rapa ywyka'poto: ‘O'ko 'ne!’ kyno'san. Ypyitory 'wa ywyka'poto: ‘Ero ika'ko!’ kynika'san.” ");
INSERT INTO car_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Moro eta'po mero, Jesus enuta'po imero. Tywotu'ma'po mero, mo'karon tywekenanamon kari'na apyimy 'wa ika'po: “Wykaje o'waine, mo'karon Israel pajanymbo ra'na mo'sepan Tamusi amyikanen anepory'pa pairo we'i.” ");
INSERT INTO car_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Irombo auto 'wa tytunda'san mero rapa, iru'pa terapa mo'ko pyitonano epory'po mo'karon apojonanokonymbo 'wa. ");
INSERT INTO car_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Akore'pe 'ne waty morombo wyino amy Nain tatynen aitopo 'wa Jesus wyto'po mo'karon tynemeparykon maro. Amy kari'na apyimy wyto'po enapa imaro. ");
INSERT INTO car_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Itundary jako 'ne moro aitopo penary 'wa, mo'karon kari'na amy akepy pa'katokon. O'win'konombo tysano y'me mo'ko kynakon. Isano tyinonge'se terapa kynakon. Moky imero moro aitopo tanokon imaro kyny'satokon. ");
INSERT INTO car_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mo'ko isano ene'po mero ty'wa, poto me imero mo'ko Jopoto 'wa ikotanory ene'po. Ika'po i'wa: “Kytotamoi koro.” ");
INSERT INTO car_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Irombo moro akepy arotopo 'wa ito'po. Apo'i'po i'wa. Mo'karon akepy aronamon poropy'san. Irombo ika'po: “Koki, wykaje o'wa, ajawongo rapa!” ");
INSERT INTO car_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Irombo mo'ko iromby'po awomy'po. Tandy'po iwe'i'po. Tauranary a'mo'po i'wa rapa. Irombo Jesus 'wa yry'po rapa isano 'wa. ");
INSERT INTO car_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Pa'poro imero iwe'naranga'san. Poto me imero Tamusi ety awonga'po i'waine. Ika'san: “Amy poto 'su Tamusi auran uku'ponen kyra'nakaine nopyi! Tamusi typyitorykon etawai.” ");
INSERT INTO car_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Moro ekary wotaripapy'po ro pa'poro morokon Judea wyinonokon aito'kon wararo. ");
INSERT INTO car_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mo'ko Johanes 'wa pa'poro morokon otykon eta'san mo'karon tynemeparykon wyino. ");
INSERT INTO car_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Irombo oko amykon ko'ma'san i'wa ty'wa. Mo'karon emoky'san ro i'wa mo'ko Jopoto 'wa aturupo: “Mo'ko o'toto manombo amoro man? Amy terapa momo'tan te ka'tu na'na?” ");
INSERT INTO car_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Tytunda'san mero Jesus 'wa, mo'karon wokyryjan wyka'san: “Mo'ko kari'na etykanen Johanes na'na emokyi o'wa, aturupo: ‘Mo'ko o'toto manombo amoro man? Amy terapa momo'tan te ka'tu na'na?’ ” ");
INSERT INTO car_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Moro jako 'ne ro Jesus pyime je'tun pangon kura'makon anykyrykon wyino, aki'manamon otykon wyino, akyrykonymbo wyino. Pyime enapa enu'non enutano'pojakon rapa. ");
INSERT INTO car_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Irombo Jesus 'wa ejuku'san: “Morokon anene'san, aneta'san enapa ekari'tandoko Johanes 'wa. Enu'nonymbo kyno'po'saton rapa. Iwajakuta'sanymbo kyny'saton. Areky pangonymbo kynekura'maton rapa. Ipana'nonymbo kynipanataton. Iromby'sanymbo kynawonjaton. Mo'karon omi tanokon amy iru'pyn oka etaton. ");
INSERT INTO car_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sara'me 'ne janon kynaitan mo'ko ypoko ataki'mapyn.” ");
INSERT INTO car_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Mo'karon Johanes apojongon wyto'san mero rapa, mo'ko Johanes poko mo'karon kari'na apyimykon erupary a'mo'po Jesus 'wa: “Oty ene ko mytoton moro iponomyn wo'i taka? Amy pepeito ne'wujukuru itupu ene ka'tu? ");
INSERT INTO car_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Oty ene ko iro ke mytoton? Amy iru'pyn tymi'mi'ken wo'mynano tano wokyry ene ka'tu? Mo'karon tapenamon wo'mynano tanokon waino pangon kari'na te 'kuru morokon potonon auto ta mandon. ");
INSERT INTO car_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Oty ene 'ne ka'tu ko iro ke mytoton? Amy Tamusi auran uku'ponen ene ka'tu? A'a, wykaje o'waine, amy Tamusi auran uku'ponen ko'pono ene 'ne ka'tu rapa! ");
INSERT INTO car_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Mo'ko poko ro tymero man: “Eneko, yjapojon semo'sa ajuwapo. Mo'ko ro moro ajemary ka'tan awytory mero.” ");
INSERT INTO car_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Wykaje o'waine, mo'karon woryijan uwembo wyino oma'san ra'na amy pairo e'i'pa man Johanes ko'po. Ise'me te mo'ko ko'waronombo moro Tamusi nundymary tano poto me man iko'po. ");
INSERT INTO car_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Moro Johanes auran eta'po mero, pa'poro mo'karon kari'na, mo'karon Rome pono jopoto ekataka pyrata amo'i'namon enapa tywosetykapo i'wa mandon. Iwara ro moro Tamusi wonumengary tawa'ma i'waine man. ");
INSERT INTO car_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mo'karon Farise te mo'karon omenano mero'po uku'namon maro Johanes 'wa asetykapo'pa tywaije mandon. Iwara ro moro ty'wanokon Tamusi nisanory ematon. ");
INSERT INTO car_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Otypan oty wara ko iro ke mo'karon eromenokon kari'na syta'ton? One wara ko nandon? ");
INSERT INTO car_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Otykon ekaramatopo po tandy'ponokon, ero wara ta'sakarykon ko'manamon pitanikon wara mandon: ‘Na'na o'waine sina etoi. Irombo uwa'pa maiton. Na'na atamotopo ware kapyi o'waine. Irombo atamo'pa maiton.’ ");
INSERT INTO car_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mo'ko kari'na etykanen Johanes irombo nopyi. Arepa anenapy'pa man. Winu anenyry'pa enapa man. Irombo mykaton: ‘Amy yja'wan noky itu'po man.’ ");
INSERT INTO car_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mo'ko kari'na ymuru nopyi. Arepa ena'san. Winu enyjan enapa. Irombo mykaton: ‘Eneko! Amy kumi'man pore kari'na, ran! Amy tanymy 'san pore kari'na, ran! Mo'ko Rome pono jopoto ekataka pyrata amo'i'namon a'sakary, amy tyja'wangamon kari'na a'sakary enapa mo'ko man!’ ");
INSERT INTO car_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","“Tywonumengapore Tamusi wairy ekari'saton pa'poro mo'karon tywonumengaporamon.” ");
INSERT INTO car_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","O'win amy Farise woturupo'po Jesus 'wa tokosa iwendameto'me. Irombo iwo'my'po mo'ko Farise auty taka. Iwotunga'po moro iwendameto'kon po. ");
INSERT INTO car_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Mo'ko Farise auty ta ro iwairy ukuty'po amy moro pono tyja'wangen woryi 'wa. Amy tapenen topu kapy'po patere'membo ta amy tapenen typoporen karapa enepy'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Irombo Jesus ynga'na'po taka ito'po. Kynotamojakon morokon ipupuru po. Tanakuru ke morokon ipupuru ke'purory amo'po i'wa. Irombo moro tunsety ke i'koka'po i'wa. Morokon ipupuru posimapoty'po i'wa. Irombo ikyrykyryma'po i'wa moro typoporen karapa ke. ");
INSERT INTO car_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Moro ene'po mero ty'wa, mo'ko Jesus ko'manenymbo Farise wyka'po tyturu'po ta: “Tamusi auran uku'ponen me ta'ta, noky me mo'ko ty'tu'kanen woryi wairy ukutyry mo'se. Tyja'wange iwairy ukutyry.” ");
INSERT INTO car_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Irombo Jesus 'wa ejuku'po: “Simon, amy o'to ywykary 'se wa o'wa.” Irombo Simon wyka'po: “Ajauranako, yjemepanen.” ");
INSERT INTO car_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesus wyka'po: “Oko wokyryjan o'wino me amy pyrata y'mekaponen ependomatokon. Mo'ko o'win amy u'tano me kynakon ainatonemboto ainatone-kari'na amu'nymbo pyrata. Mo'ko akono u'tano me kynakon oko-kari'na itu'ponaka ainapatoro amu'nymbo pyrata. ");
INSERT INTO car_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Epemary upiry ke i'waine, mo'ko pyrata y'mekaponen wyka'po okororo i'waine: ‘Moro po nainen!’ Nokypanymbo ko poto me 'ne nipynatan?” ");
INSERT INTO car_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon 'wa ejuku'po: “Mo'ko poto me 'ne ependomanenymbo pai.” Irombo Jesus wyka'po i'wa: “Iporo ro mykaje.” ");
INSERT INTO car_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Irombo mo'ko woryi 'wa tywotu'ma'po mero, Jesus wyka'po Simon 'wa: “Mo'se woryi menejan? Ajauty taka ywo'my'po mero, tuna amy anyry'pa me'i y'wa, ypupuru ku'mi'to'me. Mo'se woryi te tanakuru ke ypupuru ke'puroi. Irombo tunsety ke ni'kokai. ");
INSERT INTO car_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Amoro, yposima'pa me'i. Mo'se woryi te ywo'my'po poro ypupuru posimary poko roten ne'i. ");
INSERT INTO car_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Karapa ke pairo yjupu'po anapo'pa me'i. Mo'se woryi te tapenen karapa ke ypupuru kyrykyrymai. ");
INSERT INTO car_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","“Iro ke ro wykaje o'wa: morokon pyimanokon ija'wanykonymbo tyka man. Moro enepojan ro moro pynato imero iwairy. A'si 'ko 'ko roten te oja'wanymbo ka'poto, a'si 'ko 'ko roten pynato maitake.” ");
INSERT INTO car_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Irombo Jesus wyka'po mo'ko woryi 'wa: “Oja'wanykonymbo tyka man.” ");
INSERT INTO car_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Irombo mo'karon iwendamery a'sakarykon 'wa tyworuparykon a'mo'po: “Noky ko mo'se nan? Yja'wan me e'i'po kaje pairo kore, ran!” ");
INSERT INTO car_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Irombo Jesus wyka'po mo'ko woryi 'wa: “Moro o'wa Tamusi amyikary uta'no wyino ajunemyi. Iru'pa i'tango.” ");
INSERT INTO car_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Akore'pe 'ne waty morombo pa'po me Jesus 'wa potonon aito'kon wararo, siky'inon aito'kon wararo moro Tamusi nundymary ekapory aropoty'po. Mo'karon ainapatoro itu'ponaka okonokon imaro kynatokon, ");
INSERT INTO car_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","amykon woryijan maro. Mo'karon woryijan wyino ro Jesus 'wa yja'wangon akywano tymoma kynatokon. Anykykon wyino enapa tykura'ma i'wa kynatokon. Etykon me kynatokon: mo'ko Magdala pono ikato'kon Maria (mo'ko wyino ro oko-to'ima yja'wangon akywano tymoma kynatokon), ");
INSERT INTO car_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mo'ko Herodes upi'nono jopoto Kusas pyty Johana, mo'ko Susana, pyime enapa amykon terapa woryijan. Inaron ro aseke typyratarykon yjatokon i'wano me. ");
INSERT INTO car_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Irombo amy kari'na apyimy wota'nanopy'po Jesus ekosa. Pa'poro aitopo wyino tywo'se kynatokon mo'karon kari'na. Irombo Jesus 'wa ero onumengatopo auranano ekarity'po: ");
INSERT INTO car_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Amy maina pokono tyto man o'ponje. Moro iwo'pomyry jako ro, a'si 'ko amykon inipomyry epy tywo'pa'se man oma esi'wo. Moro po ro tuta'mipo'se tywaije man. Irombo mo'karon tonoro 'wa tana'se man. ");
INSERT INTO car_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Amykon enapa tywo'pa'se man topu pan nono tu'ponaka. Irombo atytarymbo ro tajuta man, tarure 'ne moro nono wairy ke. ");
INSERT INTO car_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Amykon enapa tywo'pa'se man takyramon itupu paty ta. Irombo morokon takyramon itupu atytary 'wa moro wonatopo tywo man. ");
INSERT INTO car_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amykon enapa tywo'pa'se man iru'pyn nono tu'ponaka. Tatyta'po mero tapeta tywaije man ainatone-kari'na me.” Ero ekarity'ma'po mero pari'pe ika'po: “Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Irombo mo'karon inemeparykon woturupo'san i'wa, o'to tauro'po me moro onumengatopo auranano wairy poko. ");
INSERT INTO car_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Irombo ika'po: “Amyjaron moro Tamusi nundymary poko tamorepa mandon. Mo'karon amykon terapa womepary te man onumengato'kon auranano wyino. Kyno'po'ta'ton ro rypo. Otymbo ro anene'pa te kynaita'ton. Kynepanamata'ton ro rypo. Otymbo ro aneta'pa te kynaita'ton. ");
INSERT INTO car_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Moro onumengatopo auranano tauro'po man ero wara: Morokon wonatopo epy, Tamusi auranymbo morokon man. ");
INSERT INTO car_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Morokon oma esi'wo o'papy'san wara mo'karon ero wara aitonon mandon: Moro Tamusi auranymbo etaton. Irombo te mo'ko ewa'rumy tamuru kyno'san. Moro ineta'san auranano pinanon ituru'san wyino, Tamusi anamyika'pa iwaito'ko'me. Iwara epanopy'pa mandon. ");
INSERT INTO car_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Morokon topu pan nono tu'ponaka o'papy'san wara mandon mo'karon Tamusi auran ewa'manamon, eta'po mero ty'waine. Ituru'san ta te atandy'mo'pa man. Ko'i roten Tamusi amyikaton. Otykon 'wa tu'kurukon jako, kynomaton. ");
INSERT INTO car_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Morokon takyramon itupu paty ta o'papy'san wara mo'karon ero wara aitonon mandon: Moro Tamusi auranymbo etaton. Irombo te aseme noro esykano 'wa, pyrata 'wa, tysanoramon otykon 'wa kynotamiromo'kapojaton. E'i'pa mandon. ");
INSERT INTO car_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Morokon iru'pyn nono tu'ponaka o'papy'san wara mo'karon ero wara aitonon mandon: Moro Tamusi auranymbo eta'poto ty'waine, kynikura'maton kurangon tyturu'san ta. Tyweja'nakarykon ta kynepetaton.” ");
INSERT INTO car_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Amy pairo kari'na tykororetary po'ma'po wyino anunemy'pa man amy waresa upi'no, typaty upi'no pai. Apo'ny tu'ponaka te kynyjan, mo'karon o'mytonon 'wa eneto'me! ");
INSERT INTO car_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Unemy'po oty kynepa'katan. Onepyn oty kynotuku'tan. Kynonepotan. ");
INSERT INTO car_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tuwaro aitoko one wara awepanamarykon poko. Mo'ko totyken 'wa otykon yta'ton. Mo'ko otypyn wyino totyry me inekanopyrymbo pinata'ton enapa.” ");
INSERT INTO car_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Irombo isano wopy'po I'wa mo'karon ipiryjan maro. I'wa te tytundarykon upi'po i'waine, tywotunsi'ko mo'karon kari'na apyimy wairy ke. ");
INSERT INTO car_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Irombo ika'san i'wa: “Asano, apiryjan kurando mandon. Ajenery 'se mandon.” ");
INSERT INTO car_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ejuku'san te i'wa: “Mojan te, mo'karon Tamusi auranymbo etaton, irombo iwara enapa kynaijaton inaron ysano me mandon, ypiryjan me enapa mandon.” ");
INSERT INTO car_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Amy kurita kurijara taka iwotaru'ka'po mo'karon tynemeparykon maro. Irombo ika'po i'waine: “Moro tuna juwembory kysipatosen.” Irombo iwaimoky'san. ");
INSERT INTO car_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iwepatorykon jako ro Jesus wo'nyky'po terapa. Irombo orometa woma'po moro tuna juwembory taka. Tuna terapa imero kynotaru'kakon itakaine. Yja'wan oty terapa imero kynepojatokon. ");
INSERT INTO car_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Irombo ito'san i'wa. Embaka'po i'waine. Ika'san i'wa: “Jopoto! Jopoto! Kuta'saton terapa!” Irombo te awomy'po. Moro pepeito, morokon mapapuru e'ma'san i'wa. Irombo ity'na'san. Ity'me imero iwe'i'po. ");
INSERT INTO car_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesus wyka'po ko'wu i'waine: “Oje 'ne ko moro o'waine Tamusi amyikary nan?” Mo'karon wety'ka'san te imero. Poto me imero enuta'san. Ase'wa kyngatokon: “Noky 'ne ko mo'se nan, se? Morokon pepeito 'wa, moro tuna 'wa aurana'poto kore nepanamaton i'wa, ran!” ");
INSERT INTO car_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Irombo iwo'kima'san moro Gerasa ponokon waitopo po. Moro ro moro Galilea kopose me man. ");
INSERT INTO car_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Maponaka Jesus wonuku'po mero, moro aitopo wyino amy takyren wokyry wopy'po epoje. Penaro terapa wo'mynano anemyndo'pa kynakon. Amy auto ta emamy'pa kynakon. Atunendopo ta te kynemanjakon. ");
INSERT INTO car_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesus ene'po mero ty'wa, tyko'ke imero tokuna'po iwoma'po Jesus po'ponaka. Pari'pe imero ika'po: “Oty 'se ko ymaro man, se, Jesus, inorombo ro kawono Tamusi ymuru? We'pimaje o'wa: Ka'karykapoi koro.” ");
INSERT INTO car_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jesus irombo mo'ko yja'wan akywano 'wa tyka terapa kynakon iwepa'kato'me. Pyimemboto terapa mo'ko akyry 'wa mo'ko wokyry tykota'ma kynakon. Pyimemboto ro rypo siparari ke ainary, ipupuru enapa tymy i'waine kynakon. Morokon tymyto'konymbo apo'topombo te i'wa kynakon. Irombo mo'ko yja'wan 'wa ipono'non 'wa arotopombo kynakon. ");
INSERT INTO car_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesus woturupo'po te i'wa: “One wara ko ajety nan?” Irombo ika'po: “Pyimano.” Pyime imero irombo mo'karon ewa'rumy we'i'san mo'ko wokyry ta. ");
INSERT INTO car_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Irombo iwe'pima'san i'wa moro ije'pomyn topona taka tomoky'paine iwaito'me. ");
INSERT INTO car_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Moro jako 'ne amy pyiruku apyimy moro wypy tu'po tywendamery aropo'sakon. Irombo mo'karon ewa'rumy we'pima'san Jesus 'wa mo'karon pyiruku taka ta'mykapoto'ko'me. Irombo Jesus 'wa iru'pa epory'po. ");
INSERT INTO car_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Mo'karon ewa'rumy wepa'ka'san ko'wu mo'ko wokyry wyino. Mo'karon pyiruku taka ito'san. Irombo mo'ko pyimano pyiruku apyimy eka'numy'po moro eme'tary wyino moro tuna juwembory taka. Tuna ta i'maty'po. ");
INSERT INTO car_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Moro oty wo'kapy'po ene'po mero ty'waine, mo'karon pyiruku enenamon eka'numy'san. Irombo moro oty ekaro'po i'waine moro aitopo ta, moro aitopo wyino kurando enapa. ");
INSERT INTO car_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mo'karon kari'na wopy'san otypan oty wo'kapy'po ene. Jesus 'wa iwopy'san. Irombo mo'ko pyimano ewa'rumy ninonda'po wokyry epory'po i'waine Jesus ekonda tandy'po. Tywewo'myndo kynakon, tupu'po ta terapa. Iwety'ka'san imero. ");
INSERT INTO car_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","One wara mo'ko takyrenymbo epanopy'po ekarity'po mo'karon enenamonymbo 'wa. ");
INSERT INTO car_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Irombo pa'poro mo'karon Gerasa wyinonokon ata'nanopy'san woturupo'san Jesus 'wa itoto'me tywyinoine, poto me imero tywety'karykon ke. Irombo Jesus wotaru'ka'po kurijara taka, tyweramato'me rapa. ");
INSERT INTO car_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mo'ko ewa'rumy ninonda'po wokyry we'pima'po Jesus 'wa, ekosa tywaito'me. Jesus 'wa te emoky'po rapa. Ika'po i'wa: ");
INSERT INTO car_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Eramako rapa ajauty 'wa. Pa'poro o'to Tamusi 'wa ajyry'po ekari'ko me.” Irombo ito'po. Pa'poro one wara Jesus 'wa tyry'po ekarityry aropoty'po i'wa pa'poro moro poto 'su aitopo ta. ");
INSERT INTO car_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus werama'po mero rapa, itundary ewa'ma'po mo'karon kari'na apyimy 'wa. Imomokyry poko irombo pa'poro tywaije kynatokon. ");
INSERT INTO car_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Moro jako 'ne amy Jairus tatynen wokyry wopy'po. Amy Simosu wota'nano'to'kon auto jopotory mo'ko kynakon. Jesus po'ponaka tokuna'po iwoma'po. Iwe'pima'po i'wa iwo'to'me tauty 'wa, ");
INSERT INTO car_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","mo'ko o'win'konombo tamyiry'membo rombyry ke terapa. Ainapatoro itu'ponaka oko siriko iwairy taro kynakon mo'ko emyiry'membo. Mo'ko Jairus auty 'wa itory jako ro, mo'karon kari'na apyimykon imero kynotunsi'kojatokon itu'ponaka. ");
INSERT INTO car_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ira'naine ro amy je'tun pan woryi kynakon. Ainapatoro itu'ponaka oko siriko terapa no'mo roten kynakon. Tapino'namon 'wa pa'poro typyratary yry'po se'me, amy pairo ikura'mary upijakon. ");
INSERT INTO car_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Mo'ko wyto'po ro Jesus 'wa, inga'na'po ta. Moro iwo'my sese'wuru y'tu'ka'po i'wa. O'win wytory imero moro imynurumbo wo'kepy'po. ");
INSERT INTO car_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Irombo Jesus wyka'po: “Noky ko y'tu'kai?” Pa'poro kari'na 'wa ani'tu'ka'pa tywairy ekarity'po. Irombo Petrus wyka'po: “Na'na emepanen, mo'karon kari'na apyimykon kore natunsi'kojaton otu'ponaka. Ajaky'katon enapa.” ");
INSERT INTO car_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesus wyka'po te: “Amy kari'na tuwano me y'tukai. Amy ypori'torymbo wepa'kary sapoi ywyino.” ");
INSERT INTO car_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Atunemy'pa tywairy man ukuty'po mero ko'wu ty'wa, mo'ko woryi enariry wopy'po i'wa tytytyne. Tokuna'po iwoma'po ipo'ponaka. Irombo pa'poro kari'na netary me o'tono'me ty'wa Jesus y'tu'ka'po, one wara o'win wytory tywekura'ma'po enapa ekarity'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Irombo Jesus wyka'po i'wa: “Yjemyiry, moro o'wa Tamusi amyikary akura'mai. Iru'pa i'tango.” ");
INSERT INTO car_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Moro auranary jako noro, amy kari'na wopy'po mo'ko Simosu wota'nano'to'kon auto jopotory auty wyino. Ika'po: “Ajemyiry nirombyi terapa. Mo'ko amepanen poko noro kyte'i.” ");
INSERT INTO car_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Moro eta'po mero ty'wa, Jesus wyka'po mo'ko Simosu wota'nano'to'kon auto jopotory 'wa: “Kytety'kai. Tamusi roten te amyikako. Iru'pa rapa kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Moro auto 'wa tytunda'po mero, amy wo'myry 'se'pa iwe'i'po tymaro. Mojan roten wo'my'san imaro: Petrus, Johanes, Jakobus, mo'ko amyija'ko jumy, isano enapa. ");
INSERT INTO car_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pa'poro kari'na mo'ko amyija'ko amojatokon ty'popurukon po'po'mary ta. Jesus wyka'po te: “Kytotamoton. Iromby'pa man. Kyno'ny'san te.” ");
INSERT INTO car_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Irombo auno'poty'po i'waine. Iromby'po uku'satokon. ");
INSERT INTO car_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesus 'wa te mo'ko amyija'ko ainary apo'i'po. Irombo ika'po: “Iso'ne, ajawongo!” ");
INSERT INTO car_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Irombo a'kary werama'po rapa. O'win wytory imero awomy'po. Irombo Jesus 'wa upapo'po. ");
INSERT INTO car_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ijumy, isano enapa we'naranga'san imero. Jesus wyka'po te i'waine, amy kari'na 'wa pairo moro o'kapy'po oty anekarity'pa iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Irombo mo'karon ainapatoro itu'ponaka okonokon a'nano'po'san i'wa. Irombo ipori'toma'san i'wa. Pa'poro yja'wangon akywano momary, je'tun pangon kura'mary enapa yry'po i'wa ainakaine. ");
INSERT INTO car_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Irombo moro Tamusi nundymary ekaro emoky'san i'wa, mo'karon je'tun pangon kura'ma enapa. ");
INSERT INTO car_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ika'po i'waine: “Amy pairo oty koro kysaroton amaroine oma tano me. Aposeny'ma, otyje'ny'ma, erepa'ma, ipyrata'pa i'tandoko. Awo'mykon y'petakan kysaroton. ");
INSERT INTO car_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Amy auto taka awo'my'sando, moro po ro aitoko. Moro wyino ro rapa aimo'toko. ");
INSERT INTO car_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","O'se'paine te amy aitopo tanokon a'ta, i'tandoko moro aitopo wyino. Awaimokyrykon mero moro apupurukon i'kokatoko, tu'taine oty wairy uku'to'me i'waine.” ");
INSERT INTO car_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Irombo mero ko'wu iwaimoky'san. Morokon aito'kon wararo ito'san. Wararo moro iru'pyn oka ekaro'po i'waine. Wararo enapa je'tun pangon kura'ma'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Irombo mo'ko jopoto Herodes 'wa pa'poro otypan oty wo'kapy'po ekary eta'po. One wara morokon tyneta'san poko tywonumengary upijakon. Amykonymbo Johanes awomy'po rapa ekari'satokon mo'karon iromby'san wyino. ");
INSERT INTO car_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Amykonymbo rapa Elia wosenepo'po ekari'satokon. Amykonymbo rapa o'win amy mo'karon uwaponokonymbo Tamusi auran uku'ponamonymbo a'sakarymbo awomy'po ekari'satokon. ");
INSERT INTO car_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodes wyka'po: “Aseke ro kore Johanes su'kapoi, ran! Noky poko 'ne ko iro ke eropangon oka setanon?” Mo'ko kari'na enery 'se imero kynakon. ");
INSERT INTO car_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tywerama'san mero, mo'karon Jesus napojoma'san 'wa pa'poro o'to tywe'i'san ekarity'po i'wa. Irombo Jesus kynarojatokon amy Betsaida tatynen aitopo 'wa, a'saka'pa tywaito'ko'me moro po. ");
INSERT INTO car_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mo'karon kari'na apyimykon 'wa te moro itorykon ukuty'po moro 'wa. Irombo iwekena'san i'waine. Jesus 'wa iwopy'san ewa'ma'po. Moro Tamusi nundymary poko erupa'san i'wa. Mo'karon tywekura'marykon 'sangon kura'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Koine 'ne iwe'i'po mero, mo'karon ainapatoro itu'ponaka okonokon Jesus nemeparykon wopy'san i'wa. Ika'san I'wa: “Mo'karon kari'na apyimy emo'ko rapa, morokon sengenokon aito'kon taka nytoto'se me tywo'ny'to'kon man upi, tareparykon man upi enapa. Ero po irombo amy iponomyn aitopo po kytaton.” ");
INSERT INTO car_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesus wyka'po te i'waine: “Amyjaron te upatoko.” Irombo ika'san: “Ainatone roten perere na'na ekosa man, oko woto maro. Na'na wytory ka'tu nan pa'poro mo'karon kari'na apyimy erepary man epeka'se?” ");
INSERT INTO car_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ainatone dusun iwairy taro irombo mo'karon wokyryjan kynatokon moro po. Irombo ika'po mo'karon tynemeparykon 'wa: “Mo'karon kari'na andy'mopotoko oruwa-kari'na pai iwairy taro.” ");
INSERT INTO car_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Iwara ro iwe'i'san. Pa'poro andy'mopo'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Irombo Jesus 'wa morokon ainatone perere apo'i'san mo'karon oko woto maro. Kapu 'wa iwo'poty'po. Tamusi ety awonga'po i'wa ipokoine. Irombo mero i'sakapoty'san i'wa. Irombo mo'karon tynemeparykon 'wa yry'san i'wa, mo'karon kari'na apyimy upato'me i'waine. ");
INSERT INTO car_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Pa'poro iwendame'san. Pa'poro iwaime'san. Irombo ainapatoro itu'ponaka oko kurukuru morokon arepa akosinykonymbo amo'iky'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","O'wino me o'win 'ne tyjumy 'wa tauranary poko Jesus kynakon. Mo'karon inemeparykon roten imaro kynatokon. Irombo iwoturupo'po i'waine: “Noky me ko yjekari'saton mo'karon kari'na apyimykon?” ");
INSERT INTO car_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Irombo ejuku'po i'waine: “Mo'ko kari'na etykanenymbo Johanes me. Amykonymbo te ajekari'saton Elia me. Amykonymbo rapa amy uwaponombo Tamusi auran uku'ponenymbo awomy'po ekari'saton.” ");
INSERT INTO car_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Irombo iwoturupo'po i'waine: “Amyjaron rapa, noky me ko kakari'saton?” Irombo Petrus 'wa ejuku'po: “Mo'ko Tamusi nyry'po Mesias me.” ");
INSERT INTO car_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","E'mapoty'san te Jesus 'wa. Ika'po i'waine, amy 'wa pairo anekarity'pa iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ika'po: “Poto me mo'ko kari'na ymuru wota'karykary man. Mo'karon uwapoto'san, mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon enapa i'se'pa kynaita'ton. Irombo kyniwota'ton. Moro ijoruwanory kurita te kynawondan rapa.” ");
INSERT INTO car_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Irombo pa'poro i'waine aurana'po: “Tywopyry 'se amy a'ta ywena'po ta, aseke ty'wano me kapyn noro iwairy man. Kurita wararo moro tywakapuru anumyry i'wa man. Irombo iwopyry man ywena'po ta. ");
INSERT INTO car_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mo'ko tamamyry aijomary 'san irombo moro tamamyry uta'katan. Mo'ko yjupu'po me tamamyry uta'kanen man te moro tamamyry aijomatan. ");
INSERT INTO car_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Otypan iru'pyn oty epojan ko amy kari'na pa'poro ero nono tu'pono oty apo'i'poto ty'wa totyry me, irombo aseke moro tamamyry uta'ka'poto, any'ma'poto pai? ");
INSERT INTO car_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","“Ypoko, yjauranymbo poko enapa amy wepy'i'to'poto, mo'ko kari'na ymuru enapa kynepy'i'totan ipoko, tywopyry jako moro tykuranory ta, mo'ko tyjumy kuranory ta, mo'karon Tamusi apojongon kuranory ta enapa. ");
INSERT INTO car_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","“Ita'ro pore: amykon ero po o'po'tonon tyrombyrykon uwaporo moro Tamusi nundymary eneta'ton.” ");
INSERT INTO car_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Irombo oruwa-to'ima kurita iwairy taro moro wara tyka'po wyino, Jesus 'wa Petrus, Johanes, Jakobus aro'san tymaro moro wypy tu'ponaka, Tamusi 'wa tauranato'me. ");
INSERT INTO car_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tamusi 'wa auranary jako ro embatary wonurima'po. Tamu'ne imero moro iwo'my we'i'po, typotyre imero. ");
INSERT INTO car_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Irombo oko wokyryjan kynorupatokon imaro. Moses mo'ko kynakon Elia maro. ");
INSERT INTO car_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kurangon me imero kynosenepojatokon. Kynerupatokon moro Jerusalem po i'wa moro tamamyry aike'kary man poko. ");
INSERT INTO car_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petrus, mo'karon a'sakarykon enapa wojakon imero uwetykon. Tyja'mungon apo'i'san mero ty'waine, kurano me imero Jesus ene'po i'waine. Mo'karon oko wokyryjan ene'san enapa i'waine aporito. ");
INSERT INTO car_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Irombo itorykon mero rapa iwyino, Petrus wyka'po Jesus 'wa: “Jopoto, ka'ety ero po na'na man. Oro na'na oruwa pataja'makon amyn, o'wa o'win, Moses 'wa o'win, Elia 'wa o'win enapa.” O'to tykary anukuty'pa kynakon. ");
INSERT INTO car_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Moro wara ikary jako noro amy kapurutu wopy'po eponakaine. Mo'karon Jesus nemeparykon wety'ka'san moro kapurutu taka Moses, Elia wonekepyrykon mero. ");
INSERT INTO car_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Moro kapurutu wyino ro amy auranano wota'po: “Ymuru mo'se man. Typo syryi. Epanamatoko i'wa.” ");
INSERT INTO car_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Moro auranano wotakepy'po mero, o'win 'ne rapa Jesus kynakon. Irombo mo'karon inemeparykon yity'na'san. Moro jako ro amy pairo 'wa moro tynene'san oty anekaro'pa na'sen iwe'i'san. ");
INSERT INTO car_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Irombo koro'po moro wypy wyino iwony'to'san mero, amy kari'na apyimy 'wa Jesus epory'po. ");
INSERT INTO car_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Irombo 'kuru mo'karon kari'na apyimy wyino amy wokyry ko'ta'po: “Amepanen, we'pimaje o'wa ymuru eneto'me. O'win 'ko 'ko mo'ko ymuru man. ");
INSERT INTO car_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Amy yja'wan akywano itu'ponaka kyno'san. Typo roten kyniko'tanon. Wa'jo'pan 'wa kynapyipojan. Indary a'kosatano'pojan. Ikota'ma'po mero roten rypo kyninondanon. ");
INSERT INTO car_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mo'karon anemeparykon 'wa rypo we'pimai mo'ko yja'wan akywano momato'me i'waine. Imomary upiton te.” ");
INSERT INTO car_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Irombo Jesus 'wa ejuku'po: “Oty anamyika'non 'ne roten! Yja'wangonymbo! O'toro kurita noro ko ero ajemerykon senetan? Mo'ko omuru ene'ko ijaro 'wa.” ");
INSERT INTO car_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Irombo iwopyry jako noro mo'ko yja'wan 'wa uwa'mo'po nono tu'ponaka. Wa'jo'pan 'wa apyipo'po i'wa. Jesus 'wa te mo'ko yja'wan akywano aike'kapo'po. Mo'ko myre'ko'ko kura'ma'po i'wa. Irombo ijumy 'wa rapa yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Pa'poro imero kari'na enuta'san, moro Tamusi pori'tory ene'po mero. Pa'poro kari'na enumengapory jako ro pa'poro morokon tynikapyrykon 'wa, Jesus wyka'po mo'karon tynemeparykon 'wa: ");
INSERT INTO car_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ero koro apanarykon ta apyitoko. Mo'ko kari'na ymuru yta'ton kari'na ainaka terapa.” ");
INSERT INTO car_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","O'to tauro'po me te ero auranano wairy anukuty'pa kynatokon. Tunenje kynakon iwyinoine, anukuty'pa iwaito'ko'me. I'wa ipoko tywoturuporykon poko te tanarike kynatokon. ");
INSERT INTO car_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Irombo mo'karon Jesus nemeparykon ase'wa kynorupatokon nokypan wairy poko poto me 'ne tyra'naine. ");
INSERT INTO car_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesus te morokon ituru'san wonumengary uku'sakon. Amy pitani'membo apo'i'po i'wa. Taporito yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Irombo ika'po i'waine: “Mo'ko yjety ta mo'se pitani ewa'manen yjewa'manon. Mo'ko yjewa'manen ro mo'ko yjemo'nenymbo ewa'manon. Mo'ko uwam'po 'ne ara'naine man inoro poto me 'ne man.” ");
INSERT INTO car_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Irombo Johanes 'wa ejuku'po: “Jopoto, na'na amy kari'na 'wa ajety ta yja'wangon akywano momary enei. A'kotory poko rypo na'na ne'kui, kywena'san ta ito'pa iwairy ke.” ");
INSERT INTO car_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesus wyka'po te i'wa: “Kysa'kototon. Mo'ko ajenonopy'paine aitoto awyinonokon me man.” ");
INSERT INTO car_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Morokon kapu taka tytoto'man kurita tundarykon mero, Jerusalem 'wa imero Jesus 'wa tomary yry'po. ");
INSERT INTO car_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Apojonanokon emoky'san I'wa tuwapo. Irombo amy Samaria ponokon waitopo taka iwo'my'san amy tywaito'ko'man upi. ");
INSERT INTO car_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mo'karon moro ponokon te Jesus apyiry 'se'pa kynatokon, Jerusalem 'wa tomary yry'po ke i'wa. ");
INSERT INTO car_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Moro eta'po mero ty'waine, mo'karon inemeparykon Jakobus, Johanes wyka'san: “Jopoto, na'na auranary 'se man wa'to wo'to'me kapu wyino, ikoro'kato'ko'me?” ");
INSERT INTO car_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesus wotu'ma'po te i'waine. E'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Irombo amy terapa aitopo 'wa ito'san. ");
INSERT INTO car_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Irombo oma ta itorykon jako amy kari'na wyka'po Jesus 'wa: “Oja awytotopo 'wa ro wy'take awena'po ta.” ");
INSERT INTO car_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Irombo Jesus wyka'po i'wa: “Mo'karon joroko tautake mandon. Mo'karon tonoro tapo'nyne mandon. Mo'ko kari'na ymuru upu'po te erematopo'ma man.” ");
INSERT INTO car_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Irombo amy terapa 'wa ika'po: “O'ko ywena'po ta.” Mo'ko 'wa te ejuku'po: “Jopoto, oro yjumy na'nen sunendamyi.” ");
INSERT INTO car_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesus wyka'po te i'wa: “Oro mo'karon iromby'san mo'karon takepyrykon unensen. Amoro te moro Tamusi nundymary ekarotango.” ");
INSERT INTO car_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Amy rapa wyka'po: “Awena'po ta wy'take, Jopoto. Oro mo'karon yjauty tanokon 'wa na'nen te ywytory sekarityi.” ");
INSERT INTO car_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesus wyka'po i'wa: “Mo'ko tywena'po taka o'po'toto maina uringanen uwam'po man Tamusi nundymary 'wano me.” ");
INSERT INTO car_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Morombo wyino Jesus 'wa oruwa-kari'na itu'ponaka ainapatoro itu'ponaka oko amykon terapa omepatonon apojoma'san. Oko oko pai emoky'san i'wa tuwapo pa'poro aseke tytoto'man potonon aito'kon 'wa, siky'inon aito'kon 'wa enapa. ");
INSERT INTO car_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","“Ika'po i'waine: “Moro typotymy pyime ro rypo man. Mo'karon ipo'namon te pyime waty mandon. Iro ke ro mo'ko wonatopo potyry Jopotory 'wa aturupotoko mo'karon ipo'namon man emo'to'me i'wa ipo'se. ");
INSERT INTO car_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","I'tandoko. Komo'saton 'kuru kapara'makon emokyry wara tokonamon pero ra'naka. ");
INSERT INTO car_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pyrata je'ny, oty je'ny, asapatorykon y'petakan kysaroton. Amy pairo kari'na kyserupaton oma ta. ");
INSERT INTO car_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amy auto taka awo'my'san po ro mo'karon itanokon 'wa 'ne ka'tu kaitoko: ‘Sara'me aitoko, yja'sakarykon.’ ");
INSERT INTO car_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Moro po ro amy sara'me tywairy 'san a'ta, moro awykato'kon sara'me aino kynaitan ekosa. Moro wara e'i'pa a'ta, moro awykato'kon sara'me aino kyneramatan rapa o'waine. ");
INSERT INTO car_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mo'ko sara'me tywairy 'san auty ta ro aitoko me. Ajupato'kon ena'toko me, enytoko me enapa. Amy amaminatoto 'wa irombo emamina'po epety yry man. Kytomimapo'ton me auto wararo. ");
INSERT INTO car_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Amy aitopo taka awo'my'sando, irombo mo'karon moro ponokon 'wa ajewa'ma'sando, ajupato'kon ena'toko me. ");
INSERT INTO car_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mo'karon moro ponokon je'tun pangon ikura'matoko me. Kaitoko me i'waine: ‘Moro Tamusi nundymary tyse waty man awyinoine.’ ");
INSERT INTO car_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amy aitopo taka awo'my'sando te, irombo ajewa'ma'paine iwe'i'sando, epa'katoko me potonon oma taka. Irombo kaitoko me i'waine: ");
INSERT INTO car_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ero awaito'kon e'kyinymbo, moro na'na pupuru poko tywotapyije man iro y'kokanon rapa na'na o'waine. Ero te uku'toko: moro Tamusi nundymary tyse waty man.’ ");
INSERT INTO car_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Wykaje o'waine: moro iwosenepotopo kurita moro aitopo kynota'karykatan moro Sodom ko'po 'ne ka'tu rapa. ");
INSERT INTO car_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Je'tun pe pore kynaitan o'wa, Korasin. Je'tun pe pore kynaitan o'wa, Betsaida. Moro Tyrus po, moro Sidon po enapa morokon otaine onepo'san Tamusi pori'torykon wo'kapy'sanymboto, penaro terapa natu'matoryine. Penato'san wo'mynano ke terapa newo'myndotoryine. Weru'no'po ke terapa natakoroirotoryine. ");
INSERT INTO car_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Moro a'wembono auranano yry jako, moro Tyrus ko'po 'ne ka'tu rapa, moro Sidon ko'po enapa mata'karykata'ton. ");
INSERT INTO car_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amoro rapa Kafaraum, ajawongary man mekano'san kapu taka? Iromby'san waitopo taka te mony'totake. ");
INSERT INTO car_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mo'ko o'waine epanamatoto, y'wa kynepanamanon. Mo'ko o'se'non y'se'pa man. Mo'ko y'sepyn mo'ko yjemo'nenymbo 'se'pa man.” ");
INSERT INTO car_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Mo'karon oruwa-kari'na itu'ponaka ainapatoro itu'ponaka oko Jesus nemoky'san werama'san rapa tawa'pore imero. Ika'san: “Jopoto, mo'karon akywano ro rypo na'na 'wa kynepanamaton ajety ejatory mero na'na 'wa.” ");
INSERT INTO car_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Irombo Jesus wyka'po i'waine: “Mo'ko Satan womary janon senejakon kapu wyino kapekape wara. ");
INSERT INTO car_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kypori'tomaton okoju, sipiriri uta'mito'me o'waine, pa'poro mo'ko tyjenonoken pori'tory ko'po pana'pe awaito'ko'me enapa. Amy pairo yja'wan oty ajepory'paine kynaitan. ");
INSERT INTO car_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","O'waine te mo'karon akywano wepanamary poko tawa'pore kytaiton. Kapu ta ajetykon mero'san poko te tawa'pore aitoko.” ");
INSERT INTO car_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Moro jako 'ne Jesus ewa'poro'po imero mo'ko Tamusi a'kary 'wa. Ika'po: “Papa, kapu, nono Jopotory, poto me ajety sawongaje morokon ynekarity'san otykon unemy'san poko o'wa mo'karon oty uku'namon omepa'san wyino, uku'po'san poko te o'wa mo'karon oty anukuty'non 'wa. A'a, papa, moro wara iru'pa oty topoje o'wa man. ");
INSERT INTO car_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Pa'poro oty yryi yjumy yjainaka. Amy pairo kari'na noky me mo'ko ymunano wairy anukuty'pa man. Mo'ko jumynano roten kynuku'san. Amy pairo enapa noky me mo'ko jumynano wairy anukuty'pa man. Mo'ko ymunano roten kynuku'san. Mo'ko i'wa mo'ko ymunano tyjumy enepory 'se tywaije man inoro enapa kynuku'san.” ");
INSERT INTO car_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Irombo iwotu'ma'po mo'karon tynemeparykon 'wa. I'waine roten ika'po: “Sara'me 'ne janon morokon anenerykon enenamon onunano kynaita'ton. ");
INSERT INTO car_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wykaje o'waine: Pyime Tamusi auran uku'ponamonymbo, potonon jopotokon enapa morokon anenerykon otykon enery 'se rypo tywaije mandon. Anene'pa te tywaije mandon. Morokon anetarykon etary 'se enapa rypo tywaije mandon. Aneta'pa te tywaije mandon.” ");
INSERT INTO car_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Irombo te amy Tamusi karetary uku'nen we'i'po u'kuru 'se. Ika'po: “Amepanen, o'to ko ywairy nan moro i'matypyn roten amano epoto'me y'wa?” ");
INSERT INTO car_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesus wyka'po i'wa: “Oty ko tymero nan moro omenano karetary ta? One wara ko moro merupanon?” ");
INSERT INTO car_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Irombo Jesus ejuku'po i'wa: “Mo'ko Atamusiry Jopoto ipynako pa'poro aturu'po maro, pa'poro aja'kary maro, pa'poro apori'tory maro, pa'poro awonumengary maro enapa. Aja'sakary ipynako, aseke awaipynary wara enapa.” ");
INSERT INTO car_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Irombo Jesus wyka'po i'wa: “Iporo ro mykaje. Moro wara ro aiko. Irombo moro i'matypyn roten amano mepotake.” ");
INSERT INTO car_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mo'ko te Jesus 'wa ty'mondory 'se'pa kynakon. Iro ke ro iwoturupo'po i'wa: “Noky ko iro ke yja'sakary me nan?” ");
INSERT INTO car_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Moro poko Jesus wyka'po: “Amy wokyry Jerusalem wyino kyno'pemanon Jeriko 'wa. Irombo amykon tymonakamon oma ta itorymbo apyijaton. Kyniwo'mynga'maton. Mene imero kyniwojaton. Eke'manga'po mero, tyno i'waine man. ");
INSERT INTO car_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ijako 'ne terapa moro oma ta amy Tamusi pokono kyno'pemanon. Mo'ko kari'na ene'po mero ty'wa, kynuremejan. ");
INSERT INTO car_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Iwara enapa amy Tamusi pokonokon pyitory tywaije man. Ene'po mero ty'wa, tureme enapa i'wa man. ");
INSERT INTO car_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amy moro oma ta ytototo Samaria pono enapa ipato kyny'san. Ene'po mero ty'wa, ikotanory enejan. ");
INSERT INTO car_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Kyny'san i'wa. Morokon iwo'san epino'san oleif katy ke, winu ke enapa. Irombo kynipererekanon. Typaritory tu'ponaka yry'po mero, amy ytopo'tonon wo'ny'topo auto 'wa kynarojan. Moro po ro iru'pa kynenejan. ");
INSERT INTO car_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Irombo koro'po oko amu'nymbo pyrata pinanon moro typyratary je'ny wyino. Mo'ko auto aporemy 'wa kynyjan. Kynganon: ‘Iru'pa eneko. Ero ko'po pyrata papy'poto o'wa, awu kapematake, yweramary mero.’ ");
INSERT INTO car_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","“One wara ko monumenganon? One ko mo'ko tymonakamon neke'manga'san a'sakary me tywaije nan mo'karon oruwanokon ra'na?” ");
INSERT INTO car_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Irombo mo'ko Tamusi karetary uku'nen 'wa ejuku'po: “Mo'ko ikotanory enenenymbo.” Irombo Jesus wyka'po i'wa: “I'tango. Amoro enapa moro wara aiko.” ");
INSERT INTO car_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Irombo Jerusalem 'wa tytorykon jako noro, Jesus wo'my'po amy aitopo taka. Irombo amy Marta tatynen woryi 'wa apo'i'po tauty ta. ");
INSERT INTO car_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mo'ko ro typityne kynakon. Mo'ko ipity ety me Maria kynakon. Inoro wotandy'mo'po ro Jesus po'ponaka, o'to ikary 'wa tywepanamato'me. ");
INSERT INTO car_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta te mo'karon opy'san upary poko roten kyno'mikakon. Irombo Jesus 'wa ito'po. Ika'po i'wa: “Jopoto, iru'pa mepojan ypity 'wa o'win upu'po yno'po ajupanamon me? Kaiko i'wa yjepatoma iwo'to'me!” ");
INSERT INTO car_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Irombo mo'ko Jopoto 'wa ejuku'po: “Marta 'ko! Mesykaje 'ne, mo'mikaje 'ne pyime oty poko. ");
INSERT INTO car_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","O'win roten oty poko awairy man. Maria irombo moro iru'pynymbo oty apo'i. Moro ro ipina'pa kynaitan iwyino.” ");
INSERT INTO car_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","O'wino me amy oje Tamusi 'wa Jesus aurana'po. Aurana'ma'po mero, o'win amy inemepary wyka'po I'wa: “Jopoto, na'na emepako Tamusi 'wa na'na auranary poko, mo'ko Johanes 'wa tynemeparykon emepa'san wara enapa.” ");
INSERT INTO car_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Irombo ika'po i'waine: “Tamusi 'wa ajauranarykon jako, ero wara kaitoko: “Papa, oro ajety tykuranondo nainen. Oro moro anundymary no'nen. ");
INSERT INTO car_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Moro eromeno na'na erepary yko na'na 'wa. ");
INSERT INTO car_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Moro yja'wan me na'na we'i'po ikako. Na'na enapa irombo pa'poro yja'wan me typoko ta'sakary we'i'po kanon. Na'na kysu'kupoi mo'ko yja'wan 'wa.” ");
INSERT INTO car_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Irombo ika'po i'waine: “Amy ara'nanokon pai takonone man. Irawone 'ne pai kyny'tan takono 'wa tykato'me: ‘Yjakono, oruwa perere amy ene'ko y'wa. Si'petakamatake rapa. ");
INSERT INTO car_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Amy terapa yjakono te kore ytopo'sembo nopyi y'wa, ran. Upatopo waty te man yjekosa.’ ");
INSERT INTO car_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Mo'ko ajakono 'kare tauty wyino nykatan o'wa: ‘Kaki'maje! Ypenary sira'kere'toi terapa. Watungai terapa y'makon maro. Yjawomyry noro supija moro oty yto'me o'wa.’ ");
INSERT INTO car_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Wykaje te o'waine: Moro perere yje ro rypo tawomyry 'se'pa ta'ta takono me iwairy ke, kynawondan toty any'mary pona. Pa'poro inisanory ytan i'wa. ");
INSERT INTO car_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Iro ke ro wykaje o'waine: Otykon poko aturupotoko. Irombo otykon mapyita'ton. Otykon upitoko. Irombo otykon mepota'ton. Pena imorykatoko. Irombo moro pena kynotapurumakatan o'waine. ");
INSERT INTO car_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mo'ko otykon poko aturupototo otykon apyitan. Mo'ko otykon upinen otykon epotan. Mo'ko pena morykanen 'wa moro pena kynotapurumakatan. ");
INSERT INTO car_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Amy ara'nanokon jumynano 'kare okoju ytan tymuru 'wa, woto poko iwoturupo'poto. ");
INSERT INTO car_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Sipiriri ytan 'kare i'wa, amy korotoko y'mo poko iwoturupo'poto. ");
INSERT INTO car_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yja'wan me awairykon se'me iro ke amyjaron kurangon otykon myjaton o'makon 'wa. Ako'poine 'ne ka'tu rapa mo'ko kapu tano jumynano ta'kary ytan mo'karon aturupotonon 'wa.” ");
INSERT INTO car_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Irombo Jesus 'wa amy erupopyn wyino akyrymbo moma'po. Mo'ko takyrymbo womima'po mero, mo'ko erupopynymbo aurana'po rapa. Mo'karon kari'na apyimykon enuta'san imero. ");
INSERT INTO car_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amykonymbo wyka'san te: “Mo'ko Be'elsebul pori'tory ta, mo'ko ewa'rumy tamuru pori'tory ta mo'karon ewa'rumy momanon.” ");
INSERT INTO car_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Amykonymbo woturupo'san te Jesus 'wa amy kapu wyinono oty enepoto'me i'wa. Iwara u'kuru 'se kynatokon. ");
INSERT INTO car_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesus 'wa te iwonumengarykon ukuty'po. Irombo ikapo i'waine: “O'win e'i'pa amy nono undymanamon a'ta, moro nono undymary kynotany'matan. Autokon asetu'ponaka kyno'tororokata'ton. ");
INSERT INTO car_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","O'win e'i'pa mo'karon Satan nundymary tanokon a'ta, one wara noro ko nundymata'ton? Be'elsebul pori'tory ta irombo ewa'rumy momary mekari'saton y'wa. ");
INSERT INTO car_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Y'wa te mo'karon ewa'rumy momary jako Be'elsebul pori'tory ta, noky pori'tory ta ko mo'karon apyitorykon nimomaton? Iro ke ro mo'karon apyitorykon a'wembono auranano yta'ton apokoine. ");
INSERT INTO car_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tamusi ainary siky'iry pori'tory ta mo'karon ewa'rumy moma'sando y'wa, moro Tamusi nundymary tywo'se terapa man o'waine. ");
INSERT INTO car_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Amy pana'pyn tyrapanen wokyry 'wa typyrorory erandory jako, morokon otyry o'to e'i'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amy iko'pono pana'pyn wopy'poto te iweto, kyni'mondotan. Pa'poro moro inamyikary iwo'wo'matopombo pinatan. Irombo pa'poro tynipina'san otyrymbo aripa'tan. ");
INSERT INTO car_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Mo'ko ymaro e'i'pa aitoto yjenono'nen me man. Mo'ko ymaro a'nano'to'pa aitoto aripa'to man.” ");
INSERT INTO car_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Amy yja'wan akywano wyto'poto mo'ko tynaki'marymbo wyino, tywotare'matopo upi kyny'san aruta'san aito'kon taka. Amy anepory'pa tywe'i'poto te kynganon: ‘Weramatake rapa moro ynino'po yjauty 'wa’. ");
INSERT INTO car_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Irombo tytunda'po mero, moro tywaitopombo epojan terapa ta'me, sara'me. ");
INSERT INTO car_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Irombo kyny'san rapa oko-to'ima noro amykon tyko'ponokon yja'wangon akywano aije. Irombo kyno'myjaton moro po tywaito'ko'me. Iwara mo'ko wokyry yja'wan me 'ne ka'tu rapa kynaijan moro koromo tywe'i'po ko'po.” ");
INSERT INTO car_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Irombo morokon otykon ekarityry jako ro I'wa, mo'karon kari'na apyimy wyino amy woryi wyka'po mo'ja I'wa: “Sara'me 'ne janon kynaitan moro ajaropo'nenymbo uwembonano, moro ajupanenymbo manaty.” ");
INSERT INTO car_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesus wyka'po te: “Moro ko'po 'ne ka'tu rapa janon sara'me kynaita'ton mo'karon Tamusi auran etanamon, mo'karon ikura'manamon enapa.” ");
INSERT INTO car_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Aseme noro moky kari'na kynetururukatokon Jesus 'wa. Irombo ika'po: “Mo'karon eromenokon kari'na yja'wan me mandon. Amy kapu wyinono oty enery 'se mandon. Amy anene'pa te kynaita'ton. Jona po roten te no'po'sen. ");
INSERT INTO car_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mo'karon Ninive ponokon 'wa amy kapu nenepory oty me mo'ko Jona wairy wara enapa mo'ko kari'na ymuru kynaitan mo'karon eromenokon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Moro a'wembono auranano yry jako, mo'ko ijary pono woryi jopoto kynawondan mo'karon eromenokon kari'na maro. Mo'ko woryi ro kynemendota'ton imero. Mo'ko woryi waty tywo'se nan ero nono y'maty'po wyino, Salomo wonumengapory eta. Ero po te kore Salomo ko'po 'ne ka'tu rapa oty na. ");
INSERT INTO car_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Moro a'wembono auranano yry jako, mo'karon Ninive ponokon enapa kynawonda'ton mo'karon eromenokon kari'na maro. Mo'karon Ninive ponokon ro kynemendota'ton imero. Mo'karon Ninive ponokon waty Tamusi 'wa tywotu'ma tywaije nandon moro Jona auran poko. Ero po te kore Jona ko'po 'ne ka'tu rapa oty na.” ");
INSERT INTO car_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Amy pairo kari'na amy tykororetary po'ma'po wyino anunemy'pa man amy oty unendopo taka, tosipi upi'nonaka pai. Amy apo'ny tu'po te kynyjan, mo'karon o'mytonon 'wa eneto'me. ");
INSERT INTO car_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Moro aja'mun aweiry me moro ajenuru man. Iru'pa moro ajenuru a'ta, moro aja'mun ro rypo pa'poro taweije man. Yja'wan me a'ta te, moro aja'mun ro rypo tawa'rume man. ");
INSERT INTO car_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tuwaro iro ke aiko, moro otano ajaweiry ewa'rumamyry pona. ");
INSERT INTO car_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Taweije, ewa'rumy'ma pairo pa'poro moro aja'mun a'ta, moro ajemamyry pa'poro taweije kynaitan, moro aweinano 'wa ajaweipary wara imero.” ");
INSERT INTO car_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Aurana'ma'po mero, amy Farise 'wa Jesus ejuku'po endame iwo'to'me ty'wa. Irombo ito'po imaro auty 'wa. Iwotunga'po moro arepa apo'ny po. ");
INSERT INTO car_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tywendamery uwaporo asainaty'pa Jesus wairy ene'po mero, mo'ko Farise enuta'po imero. ");
INSERT INTO car_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jesus wyka'po te i'wa: “Amyjaron Farise me moro asaperarykon, awendameto'kon ikorokatokon kurando wyino. Aseke otaine te moro akumingon tam'po'kory, moro oja'wanykon tam'po'kory enapa man. ");
INSERT INTO car_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oty anukuty'non! Mo'ko kurandono ka'nenymbo moro itano anikapy'pa enapa nan? ");
INSERT INTO car_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Moro asaperarykon tano te ytoko mo'karon oty'non 'wa. Iwara ro pa'poro oty i'ko'ma kynaitan o'waine. ");
INSERT INTO car_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Je'tun pe pore te kynaitan o'waine, Farise. Morokon tuma poporoto'kon itupu jainapatoronorymbo amy pairo, pa'poro tanapymy sa'rombo jainapatoronorymbo amy enapa myjaton Tamusi 'wa. Moro tamambore aino poko te, moro Tamusi pynary poko enapa atuwarenge'saton. Irokon poko tuwaro awairykon manombo man, morokon koromonokon poko atuwarengepyrykon pyndo. ");
INSERT INTO car_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Je'tun pe pore te kynaitan o'waine, Farise. Ajapokupeine man moro uwapo awotandy'morykon morokon awota'nano'to'kon auto ta, moro ajewa'marykon enapa morokon otykon ekaramato'kon po. ");
INSERT INTO car_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Je'tun pe pore te kynaitan o'waine. Morokon atukuty'non tu'munano wara mandon. Otypan oty tu'po tytorykon anukuty'pa mandon mo'karon itu'po ytotonon.” ");
INSERT INTO car_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Irombo o'win amy Tamusi karetary uku'nen 'wa ejuku'po: “Amepanen, moro wara awykary ke na'na ety enapa terapa memapoja.” ");
INSERT INTO car_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesus wyka'po te i'wa: “Je'tun pe pore te kynaitan o'waine enapa, Tamusi karetary uku'namon. Awosin pangon otykon morokon arory tupi me man irokon maropojoton aja'sakarykon 'wa. Aseke te o'win amy ajainary siky'iry ke pairo morokon otykon y'tu'kary 'se'pa mandon. ");
INSERT INTO car_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Je'tun pe pore te kynaitan o'waine. Mo'karon Tamusi auran uku'ponamonymbo tu'mungon mika'saton. Atangon 'wa te tywo mandon. ");
INSERT INTO car_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Moro wara ro menepojaton iru'pa morokon o'to atangon we'i'san epory o'waine. O'win mandon imaroine. I'waine ro waty mo'karon Tamusi auran uku'ponamonymbo tywo nandon. Amyjaron te ko'wu morokon itu'mungon mika'pojaton iru'pyn me. ");
INSERT INTO car_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Iro ke te mo'ko oty uku'nen Tamusi tyka man: Yjauran uku'ponamon, yjapojongon enapa semo'ta'ton i'waine. Amykonymbo wota'ton. Amykonymbo kota'mata'ton. ");
INSERT INTO car_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Iwara ro pa'poro moro ero nono wo'kapy'po poro e'kamy'po Tamusi auran uku'ponamonymbo mynurumbo epemapotan Tamusi mo'karon eromenokon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Mo'ko Abel wyinombo ro mynu epemary arota'ton mo'ko Sakarias 'wa ro. Mo'ko Sakarias mo'ko Tamusi auty po mo'ko Tamusi 'wa tymy apo'ny pato tywo man inoro, wykaje irombo. A'a, mo'karon eromenokon kari'na 'wa kynepemapotan Tamusi. ");
INSERT INTO car_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Je'tun pe pore te kynaitan o'waine, Tamusi karetary uku'namon. Moro tukutymy 'wa ytototo oma mapu'toton. Aseke ro rypo ito'pa maiton ita. Mo'karon ita tytory 'sangon pairo ta'koto o'waine mandon.” ");
INSERT INTO car_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Moro wyino Jesus wyto'po mero, mo'karon Tamusi karetary uku'namon 'wa mo'karon Farise maro ijenonopy'po 'ne ka'tu rapa. Tameronokon otykon poko auranano'pory a'mo'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Iwara apyiry 'se kynatokon auran poko. ");
INSERT INTO car_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Moro jako ro moky imero kari'na wota'nanopy'san. Asetu'po imero iwe'i'san. Irombo Jesus 'wa tauranary a'mo'po mo'karon tynemeparykon 'wano me, mo'karon kari'na wepanamato'me ro rypo: “Tuwaro koro aitoko mo'karon Farise 'wa perere uwapurotopo pona. Moro tonapire aino pona, wykaje irombo. ");
INSERT INTO car_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","“Pa'poro onepyn oty kynonepotan. Unemy'po oty kynotuku'tan. ");
INSERT INTO car_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Pa'poro o'to ewa'rumy ta awykato'kon kynotatan aweiry ta. Moro ajautykon apu'to'po ta aja'sakarykon panary taka anekarity'san kynokarotan autokon re'ta. ");
INSERT INTO car_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“O'waine te wykaje, yja'sakarykon, tanarike kytaiton mo'karon aja'mungon wonamon poko. Awo'san mero, o'to noro ajyrykon upijaton. ");
INSERT INTO car_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Sekari'sa o'waine, nokypan 'nero poko tanarike awairykon man. Tanarike aitoko mo'ko awo'san mero moro e'wutypyn wa'to taka ajemarykon aina man inoro poko. Wykaje kore o'waine, mo'ko poko tanarike aitoko. ");
INSERT INTO car_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Ainatone wansiri epety me oko kusiri pana'po anyry'pa nandon? O'win amy mo'kopan wansiri poko pairo te Tamusi ituwarengepy'pa man. ");
INSERT INTO car_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Amyjaron te, ajunsetykon pairo pa'poro tu'ku man. Tanarike kytaiton. Pyimano wansiri ko'po tapene mandon amyjaron. ");
INSERT INTO car_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Wykaje o'waine: pa'poro mo'karon kari'na embata ywyinonokon me okari'tonon wyino enapa kynokari'tan mo'ko kari'na ymuru mo'karon Tamusi apojongon embata. ");
INSERT INTO car_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mo'ko kari'na embata yjukuty'pa tywairy ekari'nen te anukuty'pa mo'ko kari'na ymuru kynokari'tan mo'karon Tamusi apojongon embata. ");
INSERT INTO car_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Pa'poro mo'ko kari'na ymuru ejunen yja'wanymbo tywo'kary taro man. Mo'ko Tamusi a'kary ejunen yja'wanymbo te o'ka'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Morokon Simosu wota'nano'to'kon auto taka mo'karon jopotokon po'ponaka ajarorykon jako i'waine ajemendoto'ko'me, kytesykaton o'to awykarykon man poko awosaijomato'ko'me. ");
INSERT INTO car_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mo'ko Tamusi a'kary irombo moro jako 'ne moro o'to awykarykon man ekari'tan o'waine.” ");
INSERT INTO car_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Irombo o'win amy mo'karon ata'nanopy'san ra'nano wyka'po I'wa: “Na'na emepanen, mo'ko yryi 'wa kaiko moro na'na jumy 'mi nino'po a'sakato'me i'wa ymaro.” ");
INSERT INTO car_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesus wyka'po te i'wa: “Noky ko yjyryi ajekatakaine a'wembono auranano ynen jopoto me, se, otykon a'sakanen me pai?” ");
INSERT INTO car_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Irombo ika'po mo'karon ata'nanopy'san 'wa: “Tuwaro koro aitoko enumene awaipotyrykon pona. Tunsi'ke ro rypo ajaina oty a'ta, moro ajemamyry ajaina e'i'pa man.” ");
INSERT INTO car_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Irombo amy onumengatopo auranano ekarity'po i'wa i'waine: “Amy typyrataken mainary tanokon wonato'kon tapeke imero tywaije man. ");
INSERT INTO car_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Irombo mo'ko tymainaken tyturu'po ta tywonumenga man: ‘O'to ko waitan? Pa'poro moro wonatopo epery ytopo waty man.’ ");
INSERT INTO car_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Irombo tyka man: ‘Ero wara waitake. Morokon yjotyrykon kura'mato'kon sakatake. Potonon me 'kopore samytake. Morokon ta ro pa'poro wonatopo epery sikura'matake, pa'poro amykon terapa yjotyrykon enapa. ");
INSERT INTO car_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Irombo yturu'po ta wykatake: ‘Pyime imero totyke mana. Siriko poko ajapyitan. Otare'mako! Endameko! Tawa'pore aiko!’ ’ ");
INSERT INTO car_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tamusi te tyka man i'wa: ‘Oty anukutypyn! Ero koko aromo'take. Irombo noky otyry me ko naitan moro ana'nanopy'po?’ ");
INSERT INTO car_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Moro wara kynaitan mo'ko ty'wa roten otykon a'nano'san, Tamusi ekosa te oty'pa man inoro.” ");
INSERT INTO car_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Irombo ika'po mo'karon tynemeparykon 'wa: “Iro ke ro wykaje o'waine: kytesykaton oty enapyry man poko ajemando'ko'me, one wara aja'mungon wo'myndory man poko enapa. ");
INSERT INTO car_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Poto me irombo moro amano man moro arepa ko'po. Poto me moro ja'munano man moro wo'mynano ko'po. ");
INSERT INTO car_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","“O'po'toko tyre mo'karon tonoro 'wa. O'pomy'pa mandon. Wonatopo anipoty'pa mandon. Otykon kura'matopo waty man ekosaine. Tamusi te kynupaton. Mo'karon tonoro ko'po te tyse poto me mandon amyjaron. ");
INSERT INTO car_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Noky ko a'si 'ko pairo tywesykary 'wa tamamyry mosindopory taro nan? ");
INSERT INTO car_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Moropan ko'warono oty kapyry upi'poto o'waine, o'tono'me ko mesykaton morokon amykonymbo otykon poko? ");
INSERT INTO car_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Morokon itupu epyryry atytary 'wa tyre o'po'toko. Emamina'pa mandon. Mauru ane'py'i'pa mandon. Wykaje te o'waine: o'win amy itupu epyryry wara pairo mo'ko Salomo ewo'myndo'pa tywaije man iru'pyn me. ");
INSERT INTO car_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Tamusi 'wa moro itupu, moro erome mondo man iro, moro koro'po wa'to taka kynematon iro wo'myndo'poto moro wara, iko'poine 'ne ka'tu rapa awo'myndota'ton, amyjaron Tamusi anamyikaporo'non! ");
INSERT INTO car_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amyjaron enapa kytesykaton oty enapyry man poko, oty enyry man poko o'waine. ");
INSERT INTO car_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Pa'poro morokon otykon upijaton mo'karon nono tu'ponokon kari'na. Mo'ko ajumykon te morokon anamonopyrykon otykon uku'san. ");
INSERT INTO car_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Inundymary te upitoko. Irombo morokon otykon ytan enapa o'waine. ");
INSERT INTO car_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kytety'katon, amyjaron pyime waty aitonon. Otykon undymanamon me irombo ajyrykon man tyje man mo'ko ajumykon 'wa. ");
INSERT INTO car_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Ajotyrykonymbo ekaramatoko. Moro epetymbo ytoko mo'karon ipyrata'non 'wa. Ija'puta'non pyrata je'ny ika'toko. I'maty'non otykon a'nano'toko kapu ta. Moro 'wa ro manaman tytory upijan. Moro po ro pisu ija'pukary upijan. ");
INSERT INTO car_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ajotyrykon waitopo po ro irombo aturu'san enapa man.” ");
INSERT INTO car_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Tywoku'my terapa awairykon man ajopotorykon 'wanokon me. Tyka'mure morokon akororetarykon wairy man. ");
INSERT INTO car_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","“Aimyno ewa'majembo tyjopotorykon weramary momo'namon wara aitoko. Iwopy'poto, o'win wytory moro pena metapurumakata'ton i'wa, imoryka'poto i'wa. ");
INSERT INTO car_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sara'me 'ne janon kynaita'ton mo'karon pyitonano, mo'karon ijopotorykon tywopy'poto nuro kynepota'ton inaron. Ita'ro pore, kynoku'mytan, kynungapota'ton, irombo uparykon arotan. ");
INSERT INTO car_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sara'me 'ne janon kynaita'ton mo'karon moro wara inepory'san, irawone 'ne pairo tywopy'poto, koromo korotoko ko'tary jako pai. ");
INSERT INTO car_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ero te uku'toko: mo'ko tautynen 'wa one wara a'ta mo'ko manaman wopyry ukuty'pomboto, tauty taka ana'mykapo'pa nairy imonatato'me. ");
INSERT INTO car_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Amyjaron enapa taike'se terapa awaimomokyrykon man. Mo'ko kari'na ymuru irombo typo roten kyno'tan.” ");
INSERT INTO car_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Irombo Petrus wyka'po: “Jopoto, na'na 'wa roten moro onumengatopo auranano mekari'san? Pa'poro amykonymbo 'wa enapa te ka'tu mekari'san?” ");
INSERT INTO car_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Irombo mo'ko Jopoto wyka'po: “Nokypan oty enenen ko iro ke tupu'pone, tamyikapore enapa nan, mo'ko ijopotory 'wa yto'me mo'karon a'sakarykon epo, upato'ko'me i'wa arepa enapyry tunda'po mero? ");
INSERT INTO car_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sara'me 'ne janon kynaitan mo'ko moro wara ijopotory nepory'po tywopy'poto. ");
INSERT INTO car_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Iporo ro wykaje o'waine: Mo'ko ijopotory pa'poro moro totyry ytan ainaka. ");
INSERT INTO car_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mo'ko ipyitory wyka'poto te tyturu'po ta ‘Yjopotory opy'pa na'nen man’, irombo mo'karon tupi'nonokon wokyryjan, woryijan ypoky'mary, tywendamery, tywetymyry a'mo'poto i'wa, ");
INSERT INTO car_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","mo'ko ijopotory amy kurita typo roten kyno'tan. Mo'ko typyitory poromu'katan. Irombo kynemimatan. Amyikapo'pa aitonon yry wara enapa kynytan. ");
INSERT INTO car_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mo'ko tyjopotory nisanory uku'nen pyitonano, mo'ko inisanory kapyry 'se'pa tywaije man inoro ypoky'mata'ton mene. ");
INSERT INTO car_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mo'ko inisanory anukutypyn 'wa te epoky'mapoto'man oty kapy'poto, a'si 'ko roten epoky'mano apyitan. Pa'poro mo'ko pyime oty apyinenymbo wyino pyime oty upita'ton. Mo'ko ainaka pyime oty tyje man inoro wyino poto me 'ne ka'tu rapa oty 'se kynaita'ton.” ");
INSERT INTO car_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Wa'to ema wopyi ero nono tu'ponaka. Ika'mutary 'se terapa rypo we'i. ");
INSERT INTO car_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ywota'karykary te man. Iwo'kapyry uwaporo sara'me ywairy supija. ");
INSERT INTO car_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Sara'me aino ene'se ywopy'po mekano'saton ero nono tu'ponaka? Uwa, wykaje o'waine. Ata'sakano ene'se te wopyi. ");
INSERT INTO car_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Erombo poro ainatone amykon o'win auto tanokon kynota'sakata'ton. Oruwa oko amykon jenono'ta'ton. Oko oruwa amykon jenono'ta'ton. ");
INSERT INTO car_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Jumynano tymuru jenono'tan. Sanonano tamyiry jenono'tan. Amyinano tysano jenono'tan. Y'menotynano typarysano jenono'tan. Iparysano ty'menoty jenono'tan.” ");
INSERT INTO car_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mo'karon kari'na apyimykon 'wa Jesus wyka'po: “Amy kapurutu wopyry enery jako o'waine aretyry wyino, o'win wytory mykaton ‘konopo kyno'san’. Irombo kyno'san ro. ");
INSERT INTO car_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ijary wyino pepeito woturory apory jako o'waine, mykaton ‘asin pe kynaitan’. Asin pe ro kynaijan. ");
INSERT INTO car_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Tonapiramon 'ne roten! Nono, kapu embatary emery muku'saton. One wara ko iro ke moro aireno aino emery anukuty'pa mandon? ");
INSERT INTO car_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“O'tono'me ko aseke one wara moro tamambore aino wairy anyry'pa mandon? ");
INSERT INTO car_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Mo'ko ajemendonen maro awytory jako mo'ko jopoto po'ponaka, o'mikako oma ta noro awonumengarykon epopory poko rapa. Ijako irombo mo'ko a'wembono auranano ynen jopoto po'ponaka ajarotan. Mo'ko ro mo'ko yja'wangon kari'na aru'katopo jopotory ainaka ajytan. Mo'ko ro ajaru'katan moro yja'wangon kari'na aru'katopo taka. ");
INSERT INTO car_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wykaje o'wa, o'ka'pa maitake moro wyino, moro irombo ro kusiri pana'po epemary uwaporo o'wa.” ");
INSERT INTO car_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Moro jako 'ne amykon kari'na amy oka ekarityry a'mojatokon Jesus 'wa. Pilatus 'wa amykon Galilea ponokon wopo'san ekarity'po i'waine moro Tamusi 'wano me tywomy yry jako i'waine. Moro imynurukon we'kaima'po ekarity'po i'waine morokon inyrykon maro. ");
INSERT INTO car_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Irombo Jesus 'wa ejuku'san: “Mo'karon Galilea ponokon mekano'saton tyja'wange pa'poro mo'karon amykonymbo Galilea ponokon ko'po, moro wara i'maty'san ke? ");
INSERT INTO car_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Uwa, wykaje o'waine. Ajemamyrykon anu'ma'pa aja'taine, iwaraine enapa pa'poro o'ma'ta'ton. ");
INSERT INTO car_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Mo'karon Siloam po moro kawono auto womary niwo'san ainapatoro itu'ponaka oruwa-to'imanokon kari'na rapa mekano'saton tyja'wange pa'poro mo'karon Jerusalem ponokon ko'po? ");
INSERT INTO car_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Uwa, wykaje o'waine. Ajemamyrykon anu'ma'pa aja'taine, iwaraine enapa pa'poro o'ma'ta'ton.” ");
INSERT INTO car_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Irombo Jesus 'wa ero onumengatopo auranano ekarity'po: “Amy wokyry 'wa moro winu paty tymainary ta amy oroi typonje tywaije man. Irombo iwo'topombo tywaije man epeta'po ene. Amy eperymbo ro anepory'pa te tywaije man. ");
INSERT INTO car_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Irombo tymainary enenen 'wa tyka man: ‘Eneko. Oruwa siriko terapa epeta'po ene ywopyry poko wa. Amy eperymbo ro anepory'pa te wa. Akotoko. Typo roten nono aky'manganon.’ ");
INSERT INTO car_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Mo'ko imainary enenen te tyka man: ‘Jopoto, oro o'win siriko ro'kon ero po nainen. Moro ekondano nono sasa'kary su'mendake. Sundy'totake a'kapotato'me. ");
INSERT INTO car_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Irombo mero pai kynepetatan. Epeta'pa te iwe'i'poto, makotopotake.’ ” ");
INSERT INTO car_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","O'wino me otare'matopo kurita amy Simosu wota'nano'to'kon auto ta Jesus ta'sakarykon emepakon. ");
INSERT INTO car_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Moro po ro amy ainapatoro itu'ponaka oruwa-to'ima siriko terapa ewa'rumy nirupomangary woryi kynakon. Nonsume kyny'sakon. Sapatoro tywairy upijakon. ");
INSERT INTO car_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ene'po mero ty'wa, Jesus 'wa iko'ma'po. Ika'po i'wa: “O'pi, arupomanganenymbo nyton.” ");
INSERT INTO car_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Tainary yry'po i'wa itu'ponaka. O'win wytory sapatoro rapa iwe'i'po. Irombo Tamusi ety awonga'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mo'ko iwota'nano'to'kon auto jopotory wore'ko'po te, moro otare'matopo kurita amy kura'ma'po ke Jesus 'wa. Ika'po mo'karon kari'na apyimy 'wa: “O'win-to'ima kurita amaminatopo man. Ijako ro ekura'mapotoko, se. Moro otare'matopo kurita kapyn te.” ");
INSERT INTO car_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesus 'wa te ejuku'po: “Tonapiramon 'ne roten! Moro otare'matopo kurita 'kare ajeky paka, parito pai animboka'pa mandon moro erepary je'ny wyino, tuna enyje aroto'me. ");
INSERT INTO car_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mo'se ainapatoro itu'ponaka oruwa-to'ima siriko Satan nimy'po Abraham parymbo ymbokary kapyn te tywaije nan moro imytopo wyino otare'matopo kurita?” ");
INSERT INTO car_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Moro wara ikary 'wa pa'poro mo'karon ore'kotononymbo py'i'topo'san. Pa'poro mo'karon kari'na apyimy ewa'pota'po te morokon inikapyry potonon otykon poko. ");
INSERT INTO car_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Irombo Jesus wyka'po: “Otypan oty wara ko moro Tamusi nundymary nan? Oty wara ko sytan? ");
INSERT INTO car_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Amy wonatopo epy'po'membo 'ko wara man. Amy kari'na 'wa maina ta typomy'poto, kynatytanon. Wewe me kynaijan. Mo'karon tonoro tapo'nykon ka'saton morokon iporirykon poko.” ");
INSERT INTO car_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ika'po enapa: “Otypan oty wara ko moro Tamusi nundymary sytan? ");
INSERT INTO car_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Perere uwapurotopo wara man. Amy woryi 'wa oruwa parapi tano man poromy taka tyry'poto, pa'poro moro poromy uwapurojan.” ");
INSERT INTO car_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Moro Jerusalem 'wa tytory jako ro potonon aito'kon pato, siky'inon aito'kon pato enapa ito'po. Tytotopo wara ro mo'karon tywaitoponamon emepakon. ");
INSERT INTO car_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Irombo amy woturupo'po I'wa: “Jopoto, iporo ro nan pyime waty mo'karon uta'no wyino Tamusi nunemyrykon wairy?” Irombo ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“O'mikatoko moro sirapi pena ta awo'myto'ko'me. Pyime irombo, wykaje o'waine, tywo'myrykon poko kyne'kuta'ton. Tywo'myrykon upita'ton te. ");
INSERT INTO car_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Mo'ko auto aporemy 'wa moro pena etapuru'poto, awo'myrykon noro mupita'ton. Moro pena ro rypo mimorykata'ton. Mykata'ton: ‘Jopoto, etapurumakako na'na 'wa!’ Ajeju'ta'ton te: ‘Ajukuty'paine wa.’ ");
INSERT INTO car_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Morombo mero mykata'ton: ‘Amaro kore na'na kynendamen, ran. Na'na emandopo po kore oma ta kari'na memepan, ran.’ ");
INSERT INTO car_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Irombo kyngatan o'waine: ‘Ajukuty'paine wa. Omimatoko ywyinombo pa'poro, yja'wangonymbo 'ne roten.’ ");
INSERT INTO car_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Irombo matamota'ton, maijekyta'ton, mo'ko Abraham, mo'ko Isak, mo'ko Jakob, pa'poro mo'karon Tamusi auran uku'ponamonymbo enery jako o'waine moro Tamusi nundymary ta, ato'ka'marykon jako te Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Irombo undy wyino, aretyry wyino, parana wyino, ijary wyino enapa kari'na kyno'ta'ton. Kynendameta'ton moro Tamusi nundymary ta. ");
INSERT INTO car_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Iwara mo'karon wena'po tanokonymbo uwaponokon me kynaita'ton. Irombo mo'karon uwaponokonymbo wena'po tanokon me kynaita'ton.” ");
INSERT INTO car_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Moro jako 'ne amykon Farise wopy'san Jesus 'wa. Ika'san i'wa: “Omimako ero wyino. Herodes awory 'se man.” ");
INSERT INTO car_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Irombo ika'po i'waine: “Mo'ko joroko 'wa kaitandoko: ‘Erome, koro'po enapa akywano momary, je'tun pangon kura'mary enapa sarotake. Moro ijoruwanory kurita te yjaike'take. ");
INSERT INTO car_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ywytory te man erome, koro'po, mony koro'po enapa. Aipo'pa man amy Tamusi auran uku'ponen rombyry Jerusalem wyino kurando.’ ");
INSERT INTO car_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Jerusalem, Jerusalem, amoro mo'karon Tamusi auran uku'ponamon wonen, topu ke mo'karon o'wa emoky'san apojonano wonen, pyimemboto rypo o'makon a'nanopyry 'se we'i, amy korotoko 'wa ty'makon a'nanopyry wara taporiry upi'nonaka. I'se'pa te maiton. ");
INSERT INTO car_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Iro ke ro moro ajautykon itary'pa kynainopotan. Wykaje te o'waine: Yjene'pa noro maita'ton moro ero wara awykarykon 'wa ro: ‘Tykuranondo man mo'ko Tamusi ety ta o'toto.’ ” ");
INSERT INTO car_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","O'wino me, moro Simosu wotare'matopo kurita, Jesus wyto'po amy Farise jopotory auty 'wa, endame. Tuwaro imero Jesus poko kynatokon. ");
INSERT INTO car_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Irombo amy a'wese'tapoty'po wokyry we'i'po ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Irombo mo'karon omenano mero'po uku'namon 'wa, mo'karon Farise 'wa enapa Jesus wyka'po: “Iru'pa nan moro otare'matopo kurita amy kura'mary? Uwa ka'tu?” ");
INSERT INTO car_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Anejuku'pa te iwe'i'san. Irombo Jesus 'wa mo'ko a'wese'tapoty'po apo'i'po ainary poko. Ikura'ma'po i'wa. Irombo emoky'po rapa i'wa. ");
INSERT INTO car_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Irombo Jesus wyka'po i'waine: “Moro otare'matopo kurita topona taka o'win amy ara'nanokon ymuru woma'poto, eky paka woma'poto pai, o'win wytory anika'pa naitan?” ");
INSERT INTO car_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Moro poko ejukuru upi'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Irombo one wara uwapo imero mo'karon iko'ma'san wotungary ene'po Jesus 'wa. Iro ke ro amy onumengatopo auranano ekarity'po i'wa i'waine: ");
INSERT INTO car_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Aimytonon ewa'matopo 'wa ako'ma'poto, uwapo kytotungai. Amy ako'ponombo pai tyko'ma enapa man. ");
INSERT INTO car_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Irombo pai tywopy'po mero mo'ko ako'manamonymbo kyngatan o'wa: ‘Mo'se 'wa 'nare moro awotungatopombo yko.’ Irombo pai amoro pyiwano me wena'po taka atunga my'take. ");
INSERT INTO car_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","“Ako'ma'poto te atungatango moro yja'wanymbo apo'nano tu'ponaka. Irombo pai tywopy'po mero, mo'ko ako'manenymbo kyngatan o'wa: ‘Yjakono, uwapo 'kopore atungako, se!’ Irombo pa'poro mo'karon moro po atunga'san ajety awongary eneta'ton. ");
INSERT INTO car_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Pa'poro aseke toty awonganen ety emapota'ton. Aseke te toty emaponen ety awongata'ton.” ");
INSERT INTO car_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ika'po enapa mo'ko tyko'manenymbo 'wa: “Kurita'ne'neno, koineno arepa ka'pory jako o'wa pai, apawanarykon, apiryjan, ajomorykon, ajaporito amandonon typyratakamon kysiko'maton. Mo'karon ro ako'mata'ton rapa endame. Iwara ro tyndameno'po'san y'petakamata'ton rapa o'wa. ");
INSERT INTO car_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amy poto 'su endameno ka'pory jako te o'wa, epataimatonon, turupy me aitonon, iwajakuta'san, enu'non roten iko'mako. ");
INSERT INTO car_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Irombo janon sara'me 'ne maitake. O'wa irombo i'petakamary upijaton. I'petakan te mapyitake mo'karon tamamboramon awomyry jako rapa.” ");
INSERT INTO car_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Moro eta'po mero ty'wa, o'win amy endametoto wyka'po I'wa: “Sara'me 'ne janon kynaitan mo'ko Tamusi nundymary ta kynendametan inoro.” ");
INSERT INTO car_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesus wyka'po i'wa: “Amy kurita amy wokyry amy poto 'su endameno ka'pory poko tywaije man. Pyime ta'sakarykon taju'se tywaije i'wa mandon. ");
INSERT INTO car_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Moro arepa kapy'ma'po mero, typyitory tomo'se i'wa man mo'karon tynejuku'san 'wa ekari'se: ‘O'toko 'ne! Pa'poro oty naikepyi terapa!’ ");
INSERT INTO car_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Irombo tywe'i'san mero pa'poro tywopyrykon upiry takari'po i'waine man. Mo'ko koromono tyka man i'wa: ‘Ymainary man te kore amy sepekatyi. Iro ene ro ywytory man. Waturupoja o'wa yja'wan me ypoko onumenga'pa awaito'me.’ ");
INSERT INTO car_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Amy rapa tyka man: ‘Ainapatoro paka te kore amykon sepekatyi. Inaron menga ro ywytory man. Waturupoja o'wa yja'wan me ypoko onumenga'pa awaito'me.’ ");
INSERT INTO car_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Amy rapa tyka man: ‘Penaro waty te kore ypytai. Iro ke ro ywopyry supija.’ ");
INSERT INTO car_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Tywerama'po mero, mo'ko pyitonano 'wa pa'poro oty takari'se man tyjopotory 'wa. Irombo mo'ko jopoto tywore'ko man. Mo'ko typyitory 'wa tyka man: ‘Ko'i terapa morokon potonon oma taka, morokon siky'inon oma taka enapa i'tango ero aitopo ta. Mo'karon epataimatonon, turupy me aitonon, enu'non, iwajakuta'san ene'ko ijaro 'wa.’ ");
INSERT INTO car_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Taikepy'ma'po mero, mo'ko pyitonano tyka man: ‘Jopoto, awykatopombo no'kapyi terapa. Ise'me te atungatopo noro mondo man.’ ");
INSERT INTO car_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Irombo ijopotory tyka man mo'ko typyitory 'wa: ‘Ero aitopo wyino kurandonaka i'tango morokon potonon oma taka, morokon siky'inon oma taka. Mo'karon moro ponokon iwyry'kako iwo'to'ko'me yjauty 'wa. Yjauty a'nopyry imero man. ");
INSERT INTO car_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wykaje o'waine: amy pairo penaro ynejuku'po yjerepary anapo'pa kynaitan.’ ” ");
INSERT INTO car_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Pyime kari'na apyimykon Jesus maro kyny'satokon. Irombo iwotu'ma'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Ika'po: “Tyjumy, tysano, typyty, ty'makon, typiryjan, tanaunan, aseke tamamyry anijenonopy'pa mo'ko y'wa o'toto a'ta, ynemepary me tywairy upijan. ");
INSERT INTO car_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Mo'ko ywena'po ta tytoto'me tywakapuru ananumy'pa man inoro ynemepary me tywairy upijan. ");
INSERT INTO car_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Mo'ko kawono auto amyry 'san ara'nanokon 'kare atandy'mo'pa na'sen naitan epety u'kuto'me, moro tamymy kapy'mary man eneto'me ty'wa. ");
INSERT INTO car_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Moro auto apo'ny kapy'poto i'wa, irombo aike'kary upiry jako i'wa, pa'poro mo'karon enenamon kynaki'mata'ton. ");
INSERT INTO car_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kyngata'ton: ‘Mo'ko wokyry kore nata'moi amy oty amyry poko. Aike'kary upi te.’ ");
INSERT INTO car_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Mo'ko amy terapa jopoto maro o'wo'ma tytory 'san jopoto 'kare atandy'mo'pa na'sen nan mo'karon turunamon maro, tyworupato'me. Mo'ko o'win-kari'na dusun warinu pokonokon maro o'toto jopoto y'mondory taro tywairy ukutyry 'se na'sen man mo'karon ainapatoro dusun typyitorykon maro. ");
INSERT INTO car_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ru'me ta'ta te, amykon tauran ekari'namon emo'tan mo'ko tywo'wo'mary akono 'wa tyse noro a'ta, aturupo one wara ase'wa rapa tywairykon man poko. ");
INSERT INTO car_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Iwara ro pa'poro oty nondary 'se'pa amy ara'nanokon a'ta ynemepary me tywairy upijan.” ");
INSERT INTO car_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Wajo, iru'pyn oty moro man. Moro iposinymbo wyto'ma'poto te, oty ke noro ko iposinory naitan? ");
INSERT INTO car_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Maina ta ro rypo noro a'kuru mupija, wonatopo a'kaporoto'me. Mipa'sa terapa. Mo'ko typanaken nepanaman.” ");
INSERT INTO car_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","O'kapyn roten pa'poro mo'karon Rome pono jopoto ekataka pyrata amo'i'namon, mo'karon tyja'wangamon kari'na enapa kyno'satokon Jesus 'wa epanama. ");
INSERT INTO car_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mo'karon Farise eruwa'san te mo'karon Tamusi karetary uku'namon maro. Ase'wa ika'san: “Mo'se tyja'wangamon kari'na wopyry ewa'manon. Kynendamejan pairo imaroine.” ");
INSERT INTO car_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Irombo Jesus 'wa amy onumengatopo auranano ekarity'po: ");
INSERT INTO car_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Amy ara'nanokon ekosa ainatone-kari'na kapara a'ta, irombo o'win amy utapy'poto, o'to ko naitan? Mo'karon okupa'en-kari'na itu'ponaka ainapatoro itu'ponaka okupa'en-to'ima kapara anino'pa moro iponomyn wo'i ta naitan, mo'ko o'win utapy'po upi tytoto'me, epory 'wa ro ty'wa? ");
INSERT INTO car_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Irombo mo'ko kapara epory'po mero ty'wa, tawa'pore tymota'ponaka kynanundan. ");
INSERT INTO car_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Auto 'wa tytunda'poto, mo'karon ta'sakarykon ko'matan mo'karon taporito amandonon maro. Kyngatan: ‘Tawa'pore aitoko ymaro! Mo'ko utapy'po ykaparary seporyi rapa.’ ");
INSERT INTO car_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wykaje o'waine: moro o'win amy tyja'wangen kari'na 'wa tamamyry u'mary mo'karon kapu tanokon ewa'porotan amykon okupa'en-kari'na itu'ponaka ainapatoro itu'ponaka okupa'en-to'imanokon tamamyrykon u'mary 'se'non tamamboramon ko'po. ");
INSERT INTO car_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Amy woryi ekosa ainapatoro amu'nymbo pyrata a'ta, irombo o'win amy utapy'poto, o'to ko naitan? Kororeta po'ma'po mero tauty ana'koka'pa naitan upito'me, epory 'wa ro ty'wa? ");
INSERT INTO car_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Epory'poto, mo'karon ta'sakarykon ko'matan mo'karon taporito amandonon maro. Kyngatan: ‘Tawa'pore aitoko ymaro! Moro ynuta'ka'po amu'nymbo pyrata seporyi rapa.’ ");
INSERT INTO car_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iwara enapa mo'karon Tamusi apojongon ewa'porojan moro o'win amy tyja'wangen kari'na 'wa tamamyry u'mary.” ");
INSERT INTO car_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Irombo Jesus wyka'po: “Amy wokyry oko tymune tywaije man. ");
INSERT INTO car_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Irombo mo'ko imeseku'po tyka man tyjumy 'wa: ‘Papa, erome moro aromby'po mero ynapyiry man ene'ko y'wa.’ Irombo ijumy 'wa morokon totyrykon a'saka'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Irombo amykon kurita pa'po me, pa'poro totyrykon ekarama'san mero ty'wa, mo'ko imeseku'po tyto man amy tyseno aitopo 'wa. Moro po ro typyratary takama roten i'wa man, to'merepyry maro. ");
INSERT INTO car_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","“Irombo pa'poro typyratary akama'ma'po mero, amy poto 'su kumyno tywo'se man moro aitopo taka. Morombo wyino ro omi taka tywoma man. ");
INSERT INTO car_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Irombo tyto man o'win amy moro pono 'wa, e'pima. Mo'ko 'wa ro tomo'se man wo'i taka tokykon pyiruku ene. ");
INSERT INTO car_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Moro po ro mo'karon tynenerykon pyiruku erepary enapyry 'se terapa tywaije man. Amy kari'na pairo te anupa'pa ike tywaije man. ");
INSERT INTO car_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Irombo tupu'po rapa tapyije i'wa man. Tyka man: ‘O'toro 'ko waty yjumy pyitorykon ekosa arepa kynotakamanon. Awu te ykumyry 'wa ero po wo'wopoja. ");
INSERT INTO car_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yjumy 'wa rapa wy'take. Wykatake i'wa: ‘Papa, yja'wan me we'i Tamusi embata, ajembata enapa. ");
INSERT INTO car_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Omuru me noro yjejatory 'se'pa rypo wa. O'win amy apyitory me kyko.’ ’ ");
INSERT INTO car_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Irombo tyjumy 'wa tyto man. Irombo tyse noro oma ta iwopyry jako, ijumy 'wa tone terapa man. Irombo ikotanory imero tone i'wa man. Epoje taka'nunje man. Irombo taky'ka i'wa man typona. Typosimapo'se i'wa man. ");
INSERT INTO car_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Irombo mo'ko imuru tyka man i'wa: ‘Papa, yja'wan me we'i Tamusi embata, ajembata enapa. Omuru me noro yjejatory 'se'pa rypo wa.’ ");
INSERT INTO car_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mo'ko ijumy te tyka man mo'karon typyitorykon 'wa: ‘Ko'i! Moro iru'pynymbo wo'mynano ene'toko. Iwo'myndotoko ike. Ainatanondotoko. Isapato'totoko. ");
INSERT INTO car_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Mo'ko tykakenymbo paka'membo ene'toko. Iwotoko. Kytendamesen tawa'pore imero. ");
INSERT INTO car_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Mo'se ymuru tyromo'se rypo kynakon. Nerenai rapa te. Tuta'se rypo kynakon. Noporyi rapa te.’ Irombo tawa'pore imero tywendame mandon. ");
INSERT INTO car_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Mo'ko uwapotory imuru te maina ta tywaije man. Irombo tytundary mero auto 'wa, moro sina ety maro uwarykon tota i'wa man. ");
INSERT INTO car_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Irombo o'win amy pyitonano tyko'ma i'wa man. Tywoturupo man i'wa oty me moro oty wairy poko. ");
INSERT INTO car_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mo'ko ro tyka man i'wa: ‘Apiry te nopyi rapa. Ajumy mo'ko tykakenymbo paka'membo wopoi, iru'pa rapa epory'po ke ty'wa.’ ");
INSERT INTO car_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Mo'ko iryi te tywore'ko man. Tywo'myry 'se'pa tywaije man auto taka. Mo'ko ijumy tywo'se man kurandonaka, a'mykary u'ku. ");
INSERT INTO car_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Mo'ko imuru te tyka man tyjumy 'wa: ‘Eneko. O'toro 'ko siriko waty yjemaminaje o'wa. Ywe'i'po poro typanaja'nare e'i'pa we'i. Ise'me te amy pairo kapirita'membo ro anyry'pa me'i y'wa, tawa'pore wendame'se me yja'sakarykon maro. ");
INSERT INTO car_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mo'ko omuru, mo'ko to'mere'samon woryijan maro ajotyrykonymbo akamanenymbo wopy'po mero te ko'wu, mo'ko tykakenymbo paka'membo tywopo o'wa man.’ ");
INSERT INTO car_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Mo'ko ijumy te tyka man: ‘Koki, amoro kore awe'i'po poro yjekosa mana, ran! Pa'poro yjotyry kore ajotyry me na, ran! ");
INSERT INTO car_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tawa'pore awendamery manombo man. Mo'ko apiry tyromo'se rypo kynakon. Nerenai rapa te. Tuta'se rypo kynakon. Noporyi rapa te.’ ” ");
INSERT INTO car_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Tynemeparykon 'wa enapa ika'po: “Amy typyrataken wokyry upi'no amy otyry enenen tywaije man. Irombo otyry akamanen me takarama amy 'wa man ijopotory 'wa. ");
INSERT INTO car_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Irombo mo'ko ijopotory kyniko'mapojan. Kynganon i'wa: ‘Otypan oty ko setanon apoko? Enepoko y'wa kareta tu'po one wara moro ajainaka ynyry'po ene'po o'wa. Yjotyry enenen me o'se'pa noro wa.’ ");
INSERT INTO car_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Irombo mo'ko tyjopotory otyry enenen kynganon tyturu'po ta: ‘O'to ko waitan? Yjopotory waty totyry enenen me noro y'se'pa nan. Samba a'kuru supija. Ywepataimary poko typyike wa. ");
INSERT INTO car_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","O'to ywairy man te suku'sa terapa, mo'karon kari'na 'wa yjapyito'me tautykon ta, mo'ko yjopotory otyry enenen me noro e'i'pa yja'ta.’ ");
INSERT INTO car_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Irombo iwe'i'san mero mo'karon tyjopotory ependomanamon ko'mapojan. Irombo kynganon mo'ko koromono 'wa: ‘O'toro ko yjopotory mependomanon?’ ");
INSERT INTO car_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Irombo kynganon i'wa: ‘Ainatone-kari'na samaku oleif katy.’ Irombo kynganon i'wa: ‘Ero, moro o'toro o'wa ependomary uku'potopo kareta ero man. Atandy'moko. Ko'i oko-kari'na itu'ponaka ainapatoro imeroko.’ ");
INSERT INTO car_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Irombo mero mo'ko ijokonory 'wa kynganon: ‘O'toro ko mependomanon?’ Irombo kynganon: ‘Ainatone-kari'na kurukuru awasi.’ Irombo mo'ko tyjopotory otyry enenen kynganon i'wa: ‘Ero, moro o'toro o'wa ependomary uku'potopo kareta ero man. Okupa'en-kari'na imeroko.’ ");
INSERT INTO car_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Irombo ijopotory 'wa mo'ko yja'wan totyry enenenymbo tamyika man imero, tupu'pone iwe'i'po ke. Mo'karon ero nono y'makon tupu'pone asepoko mandon mo'karon aweinano y'makon ko'po. ");
INSERT INTO car_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Awu te wykaje o'waine: Moro tykoren pyrata ke ata'saka'totoko, ajapyito'ko'me i'waine morokon utapy'non aito'kon taka, pyrata utapy'po mero. ");
INSERT INTO car_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Amy a'si'kono oty poko tamyikapore amy a'ta, pyimano oty poko enapa tamyikapore man. Amy a'si'kono oty upu'po me emambo'pa amy a'ta, pyimano oty upu'po me enapa emambo'pa man. ");
INSERT INTO car_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Moro tykoren pyrata poko tamyikapore e'i'pa awe'i'sando, noky ko ajamyikata'ton moro iro 'nero poto 'su oty poko? ");
INSERT INTO car_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Moro aja'sakary otyry poko tamyikapore e'i'pa awe'i'sando, noky ko moro ajotyrykon man ytan o'waine? ");
INSERT INTO car_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“O'win amy pyitonano oko jopotokon pyitory me tywairy upijan. Ijako irombo mo'ko o'win amy jenono'tan, mo'ko o'win amy pynatan te. Mo'ko o'win amy ekosa tywairy 'se kynaitan, mo'ko o'win amy te ato'ke kynaitan. Tamusi pyitorykon me awairykon mupijaton, moro pyrata pyitorykon me aja'taine.” ");
INSERT INTO car_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Pa'poro te eta'san mo'karon Farise 'wa. Inaron ro pyrata pynatokon imero. Jesus u'kupoty'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Irombo ika'po i'waine: “Amyjaron aja'sakarykon embata tamamboramon wara monepojaton. Tamusi te aturu'san uku'san. Morokon poto me kari'na nenerykon Tamusi ato'ke man. ");
INSERT INTO car_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Moro omenano mero'po, mo'karon Tamusi auran uku'ponamonymbo enapa taurana mandon Johanes taronaka ro. Morombo wyino te moro Tamusi nundymary ekari'saton kari'na iru'pyn oka me. Pa'poro enapa itaka tywo'myrykon poko kyno'wo'maton. ");
INSERT INTO car_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Moro kapu ero nono maro tutapyry taro man o'win amy itinga'po utapyry ko'po moro omenano mero'po wyino. ");
INSERT INTO car_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Amy typyty nondanenymbo 'wa amy terapa woryi apyiry jako typyty me, moro typyke tywairymbo any'manon. Amy wokyry 'wa amy inonda'po woryi apyiry jako typyty me, tyinone mo'ko woryi wairymbo any'manon.” ");
INSERT INTO car_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Amy typyrataken wokyry tywaije man. Ty'meijen tykujuren mauru kapy'po wo'mynano ta iwewo'myndotopombo man. Kurita wararo poto 'su uwano ka'pojan. ");
INSERT INTO car_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Irombo ipenary po amy epataimatoto tapapo kyniko'mambo'san. Areky pe imero man. Lasarus ety me man. ");
INSERT INTO car_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Mo'ko typyrataken erepary akosinykonymbo enapyry 'se man. Pero terapa te erekyry amejaton. ");
INSERT INTO car_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Amy kurita mo'ko epataimatoto tyromo'se man. Irombo Tamusi apojongon 'wa mo'ko Abraham enaka taro man. ");
INSERT INTO car_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mo'ko typyrataken tyromo'se enapa man. Irombo tunenje man i'waine. Irombo moro iromby'san waitopo ta tywota'karykary jako, tyse Lasarus enejan Abraham ena. ");
INSERT INTO car_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Irombo mo'ja kynganon: ‘Papa Abraham, ykotanory eneko. Lasarus ene'poko y'wa, tainary aresikyry u'mu'ka'se me tuna taka a'si 'ko 'ko roten ynuru y'sanapangato'me. Wa'to ka'muru je'tun irombo yja'karykaje.’ ");
INSERT INTO car_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abraham te kynganon: ‘Ito'my, onumengako rapa one wara iru'pyngon oty epory'po poko o'wa moro nuro noro aja'ta. Moro jako ro Lasarus 'wa yja'wan oty epory'po. Erome te ero po Tamusi kynewa'porojan. Amoro terapa te mata'karykaje. ");
INSERT INTO car_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Itaka ro, amy poto 'su nono atory na'na a'kotojan awyinoine. Iwara te mo'karon ero wyino o'waine tytorykon 'se aitonon tytorykon upijaton. Iwara enapa mo'karon moro wyinonokon tywepatorykon upijaton na'na wyinonaka.’ ");
INSERT INTO car_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Irombo te mo'ko typyratakenymbo kynganon: ‘Waturupoja iro ke o'wa, papa, mo'ko Lasarus emo'to'me o'wa yjumy auty 'wa. Ainatone noro ypiryjan mandon moro po. ");
INSERT INTO car_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Oro poto me imero ne'mapo'sen, iwopyrykon pona ero ata'karykatopo taka, ywopy'po wara.’ ");
INSERT INTO car_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham te kynganon: ‘Moro Moses nimero'po ekosaine man, mo'karon Tamusi auran uku'ponamonymbo nimero'san maro. Oro morokon 'wa nepanamasen.’ ");
INSERT INTO car_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Irombo te mo'ko typyratakenymbo kynganon: ‘Uwa, papa Abraham! Epanama'pa kynaita'ton. Iromby'san wyino amy wyto'poto te ty'waine, tamamyrykon u'mata'ton.’ ");
INSERT INTO car_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham te tyka man i'wa: ‘Moro Moses nimero'po 'wa, mo'karon Tamusi auran uku'ponamonymbo nimero'san 'wa enapa epanama'pa ta'taine, amy iromby'san wyino awomy'po anamyika'pa pairo kynaita'ton.’ ” ");
INSERT INTO car_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Irombo Jesus wyka'po mo'karon tynemeparykon 'wa: “Morokon yja'wan taka kari'na emapoto'kon otykon opy'pa tywairykon upijaton. Mo'ko ene'ponamon 'wa te je'tun pe pore kynaitan! ");
INSERT INTO car_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","O'win amy ero pono ko'warono emapory ko'po iru'pa nairy moro parana taka emary, amy miri topuru ke taneka'to. ");
INSERT INTO car_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Tuwaro koro aitoko. Yja'wan me amy aja'sakary we'i'poto e'mako. Tamamyry u'ma'poto i'wa, yja'wan me i'we'i'po ikako. ");
INSERT INTO car_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O'win kurita oko-to'imamboto yja'wan me o'to ajyry'poto i'wa, irombo oko-to'imamboto o'wa iwopy'poto ‘Yjemamyry su'matake’ tauro me, moro yja'wan me iwe'i'po kary o'wa man.” ");
INSERT INTO car_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Irombo mo'karon apojoma'san wyka'san mo'ko Jopoto 'wa: “Poto me 'ne ka'tu rapa Tamusi amyikanamon me na'na yko.” ");
INSERT INTO car_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Irombo mo'ko Jopoto wyka'po: “Amy ko'warono wonatopo epy wara roten rypo moro o'waine Tamusi amyikary we'i'poto, irombo moro poto 'su wewe 'wa awyka'sando: ‘Atungako nono wyino! Parana ta terapa o'pongo!’ nepanamary o'waine. ");
INSERT INTO car_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Ara'naine o'win amy a'ta pyitonano aporemy me, irombo imainary uringajembo iwopy'poto, ekykon enejembo pai, nykatan typyitory 'wa: ‘O'ko 'ne ko'i! Endameko, se!’? ");
INSERT INTO car_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Yka'pa naitan i'wa: ‘Yjerepary man ika'ko! Irombo awewo'myndo'po mero, kupako. Ywendame'ma'po mero mendametake amoro.’? ");
INSERT INTO car_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Morokon i'wa tyjopotory wykato'konymbo kapy'san 'kare mo'ko jopoto ewa'porotan. ");
INSERT INTO car_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iwara enapa amyjaron, pa'poro mo'ko ajopotorykon wykato'konymbo kapy'sando o'waine, mykata'ton: ‘Uwam'ponokon pyitonano roten na'na man. Na'na tynikapyry man kapyi roten.’ ” ");
INSERT INTO car_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Irombo amy kurita tytory jako noro Jerusalem 'wa, Jesus wyto'po moro Samaria wairy pato Galilea maro asepona. ");
INSERT INTO car_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Irombo amy aitopo'membo taka itory jako, ainapatoro areky pangon wokyryjan wopy'san epoje. Tyse a'si'ko iporopy'san. ");
INSERT INTO car_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Moro po ro Jesus 'wa iko'ta'san: “Jesus! Amepanen! Na'na kotanory eneko!” ");
INSERT INTO car_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ene'san mero, Jesus wyka'po i'waine: “Asenepotandoko mo'karon Tamusi pokonokon 'wa.” Irombo itorykon jako ro, iwekura'ma'san rapa. ");
INSERT INTO car_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Moro iru'pa tywe'i'po ene'po mero, o'win amy werama'po rapa, mo'ja imero Tamusi ety awongary ta. ");
INSERT INTO car_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Irombo tombata'po iwoma'po Jesus pupuru pato, ety awongato'me ty'wa. Amy Samaria pono te mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Irombo Jesus wyka'po: “Ainapatoronombo mero kapyn tywekura'ma nandon? Oje ko iro ke mo'karon okupa'en-to'imanokon nandon? ");
INSERT INTO car_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Amykon rapa erama'pa naiton Tamusi ety awongato'me? Mo'se o'win Simosu me e'ipyn roten te neramai?” ");
INSERT INTO car_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Irombo Jesus wyka'po i'wa: “Ajawongo! Iru'pa itango! Moro o'wa Tamusi amyikary akura'mai.” ");
INSERT INTO car_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Mo'karon Farise woturupo'san Jesus 'wa one wara a'ta moro Tamusi nundymary wopyry poko. Irombo ejuku'san i'wa: “Moro Tamusi nundymary tuku'se me opy'pa man. ");
INSERT INTO car_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awykary mupitake: ‘Eneko! Ero iro!’. Awykary pai mupitake ‘Eneko! Moro iro!’. Moro Tamusi nundymary irombo ara'naine man.” ");
INSERT INTO car_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Irombo ika'po mo'karon tynemeparykon 'wa: “Amy jako o'win kurita roten mondo rapa mo'ko kari'na ymuru wairy enery 'se rypo maita'ton. Anene'pa te maita'ton. ");
INSERT INTO car_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Irombo kyngata'ton o'waine: ‘Eneko! Mo'ko inoro!’. Kyngata'ton pai: ‘Eneko! Mo'se inoro!’. O'po'se kytoton! Kysiwekenaton! ");
INSERT INTO car_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Moro kapekape ka'mutapotyry 'wa wararo kapu aweipary wara irombo mo'ko kari'na ymuru kynonepotan moro tywo'topo kurita. ");
INSERT INTO car_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Poto me na'sen te iwota'karykary man. Mo'karon eromenokon kari'na 'wa na'sen urumenary man. ");
INSERT INTO car_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Mo'ko Noe jako iwe'i'pombo wara enapa kynaitan mo'ko kari'na ymuru wopyry jako. ");
INSERT INTO car_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tywendame mandon, typytapo'se mandon, tyinombapo'se mandon moro atunendopo tam'po'kory taka Noe wo'mytopombo kurita taronaka. Irombo mero poto me tykuma man. Irombo pa'poro kari'na ty'ma'se mandon. ");
INSERT INTO car_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lot jako enapa tywendame mandon, tywopeka'se mandon, tywokarama mandon, tywo'ponje mandon, tywotautymapo'se mandon. ");
INSERT INTO car_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Moro Sodom wyino Lot wytotopombo kurita te konopo wara imero wa'to suwapuru maro tywo'pa'se man kapu wyino. Iwara pa'poro moro ponokon kari'na ty'ma'ka mandon. ");
INSERT INTO car_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iwara enapa kynaitan moro kari'na ymuru wepa'katopo kurita. ");
INSERT INTO car_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Moro kurita tauty re'ta amy a'ta, oro netuwarikan tauty taka o'my'pa totyrykon aije. Tymainary ta amy a'ta, tywena'po taka rapa ito'pa nainen. ");
INSERT INTO car_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Onumengatoko rapa mo'ko Lot pytymbo poko. ");
INSERT INTO car_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mo'ko tamamyry aijomary 'san moro tamamyry uta'katan. Mo'ko tamamyry uta'kanen man moro tamamyry ytan asery me rapa. ");
INSERT INTO car_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Wykaje irombo o'waine: moro koko oko o'win o'ny'topo ta kynaita'ton. Irombo o'win amymbo arota'ton Tamusi apojongon. O'win amymbo nota'ton te. ");
INSERT INTO car_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Oko woryijan kyno'kyta'ton aseta. Irombo o'win amymbo arota'ton Tamusi apojongon. O'win amymbo nota'ton te.” ");
INSERT INTO car_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Irombo moro poko ro inemeparykon wyka'san I'wa: “Oje ko morokon no'ka'tan, Jopoto?” Ika'po i'waine: “Amy tonomy ekepy'po po ro mo'karon kurumu kynota'nano'ta'ton.” ");
INSERT INTO car_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Irombo Jesus 'wa amy onumengatopo auranano ekarity'po mo'karon tynemeparykon emepato'me, o'kapyn roten irupota'pa Tamusi 'wa auranato'ko'me. ");
INSERT INTO car_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ero wara ika'po: “Amy aitopo ta amy a'wembono auranano ynen jopoto tywaije man. Tamusi aninendo'pa tywaije man. Ta'sakary poko enapa esyka'pa tywaije man. ");
INSERT INTO car_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Moro aitopo ta ro enapa amy inongepy'po tywaije man. Mo'ko wytotopombo man mo'ko jopoto 'wa, tykato'me: ‘Mo'ko yja'wan me yjenanenymbo 'wa moro o'to yjyry'po epemapoko morokon omenano mero'san wykary wararo.’ ");
INSERT INTO car_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Akore'pe mo'ko woryi epanopyry 'se'pa mo'ko jopoto waitopombo man. Irombo mero te kynganon tyturu'po ta: ‘Tamusi aninendo'pa ro rypo wa. Yja'sakary poko ro rypo esyka'pa wa. ");
INSERT INTO car_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ise'me te mo'ko woryi sepano'take, yjaki'mary ke i'wa. Ka'pa rapa ypasapaikary ko'wu i'wa.’ ” ");
INSERT INTO car_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Irombo Jesus wyka'po: “O'to mo'ko emambopyn a'wembono auranano ynen jopoto wyka'po apyitoko apanarykon ta. ");
INSERT INTO car_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Tamusi iro ke mo'karon typo tynyry'san, mo'karon koko, kurita wararo tajatonamon epanopyry poko naimomo'tan? ");
INSERT INTO car_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wykaje o'waine, ko'i imero Tamusi kynepano'ta'ton! Mo'ko kari'na ymuru te moro Tamusi amyikary epotan ero nono tu'po, tywopy'poto?” ");
INSERT INTO car_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesus 'wa amy noro onumengatopo auranano ekarity'po mo'karon tamamboramon me asenetonon poko, mo'karon uwam'ponon me ta'sakarykon enenamon poko enapa: ");
INSERT INTO car_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Oko kari'na tywonu'se tywaije mandon moro Tamusi auty 'wa tauranato'ko'me Tamusi 'wa: amy Farise amy Rome pono jopoto ekataka pyrata amo'i'nen maro. ");
INSERT INTO car_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Pyre mo'ko Farise kynaurananon Tamusi 'wa tyturu'po ta: ‘Tamusi, ajety sawongaje e'i'pa ywairy poko mo'karon amykonymbo kari'na wara: kumi'mangon wara, emambo'non wara, taporitonone aino any'manamon wara, mo'ky pyrata amo'i'nen wara enapa pai. ");
INSERT INTO car_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Okomboto wonemaje oko-to'ima kurita ta. Pa'poro ynapyiry otykon jainapatoronorymbo amy syja.’ ");
INSERT INTO car_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mo'ko pyrata amo'i'nen te tyse moro Tamusi auty wyino typoro'se man. Tywo'potyry 'se'pa pairo tywaije man kapu 'wa. Ty'popuru po'po'mary ta te tyka man: ‘Tamusi! Tyja'wange wa imero! Aturu'popory enepoko y'wa!’ ");
INSERT INTO car_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Wykaje o'waine: mo'ko pyrata amo'i'nen tamambore terapa tyto man tauty 'wa. Mo'ko Farise kapyn te. Pa'poro mo'karon aseke totykon awonganamon etykon emapotan Tamusi. Mo'karon aseke totykon emaponamon etykon awongatan te Tamusi.” ");
INSERT INTO car_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amy kurita amykon pitanikon enepy'san enapa i'waine Jesus 'wa, apyito'ko'me i'wa. Moro ene'san mero, inemeparykon 'wa mo'karon ene'namon e'mapoty'san. ");
INSERT INTO car_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesus 'wa te mo'karon pitanikon ene'po'san ty'wa. Ika'po: “Oro mo'karon pitanikon no'sen y'wa. Kysa'kototon! Mo'sepangon 'wano me ro moro Tamusi nundymary man. ");
INSERT INTO car_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Ita'ro pore, amy pitani'membo wara moro Tamusi nundymary anewa'ma'pa amy kari'na a'ta, o'my'pa pairo kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Irombo amy jopoto woturupo'po Jesus 'wa: “Iru'pyn amepanen, o'to ko ywairy nan moro i'matypyn roten amano epoto'me y'wa?” ");
INSERT INTO car_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Irombo Jesus wyka'po i'wa: “O'tono'me ko ‘iru'pyn’ me kajatojan? Amy pairo kari'na iru'pa e'i'pa man. Tamusi roten iru'pa man. ");
INSERT INTO car_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Morokon Tamusi wykato'konymbo muku'sa: Taporitonone aino kysany'mai. Woto kyte'i. Amonatai. Onapi ke amy oty kysamyikapoi. Ajumy, asano inendoko.” ");
INSERT INTO car_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Irombo mo'ko wokyry wyka'po: “Pa'poro morokon wara ro we'i, pitani me yja'tanombo poro.” ");
INSERT INTO car_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Moro eta'po mero, Jesus wyka'po i'wa: “Amy o'win oty ro'kon mamono'sa. Pa'poro ajotyrykonymbo ekaramatango. Moro epetymbo yko mo'karon oty'non 'wa. Iwara totyke imero maitake kapukon ta. Irombo o'ko 'ne ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Moro eta'po mero, kata'mato imero iwe'i'po, typyratake imero tywairy ke. ");
INSERT INTO car_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Irombo kata'mato iwe'i'po ene'po mero ty'wa, Jesus wyka'po: “Tupi me pore man mo'karon totykamon wytory moro Tamusi nundymary taka. ");
INSERT INTO car_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Amy typyrataken kari'na wo'myry moro Tamusi nundymary taka tupi me man amy kameri wo'myry ko'po amy akusa enuru taka.” ");
INSERT INTO car_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Irombo mo'karon auran etanamon wyka'san I'wa: “Noky ko iro ke tapanopyry taro nan?” ");
INSERT INTO car_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Irombo Jesus wyka'po i'waine: “Morokon kari'na ekosa tywo'kapyry taro e'i'pa man irokon Tamusi ekosa tywo'kapyry taro man.” ");
INSERT INTO car_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Irombo Petrus wyka'po i'wa: “Eneko, na'na totyrykonymbo ynoi, awena'po ta tytoto'me.” ");
INSERT INTO car_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Irombo Jesus wyka'po i'waine: “Ita'ro pore, mo'ko Tamusi nundymary upu'po me tauty, typyty pai, typiryjan pai, tysano pai, tyjumy pai, ty'makon pai nojan ");
INSERT INTO car_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","inoro ro ero nono tu'po pyimemboto moro ko'po 'ne ka'tu rapa oty apyitan. Irombo moro aireno nono tu'po moro i'matypyn roten amano apyitan.” ");
INSERT INTO car_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Irombo mo'karon ainapatoro itu'ponaka oko tynemeparykon aro'san i'wa typo terapa. Ika'po: “Epanamatoko! Jerusalem 'wa kytonu'saton. Moro po ro ko'wu pa'poro mo'karon Tamusi auran uku'ponamonymbo nimero'san mo'ko kari'na ymuru poko kyno'ka'tan. ");
INSERT INTO car_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mo'karon Simosu me e'i'non ainaka kynyta'ton. Irombo ipoko kynosaijambata'ton. Kynikota'mata'ton. Itu'ponaka kyneta'tapo'ta'ton. ");
INSERT INTO car_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kynipoky'mata'ton. Irombo kyniwota'ton. Oruwa kurita pa'po me te kynawondan rapa.” ");
INSERT INTO car_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","O'to ikary anukuty'pa te mo'karon inemeparykon we'i'san. Moro auran tauro'po anukuty'pa iwe'i'san. Oty poko auranary anukuty'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Moro Jeriko 'wa itundarykon jako, oma esi'wo amy enupyn tandy'po kynepataimakon. ");
INSERT INTO car_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Irombo amy kari'na apyimy wytory etary ke tyrato, iwoturupo'po oty me iwairy poko. ");
INSERT INTO car_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Irombo ejuku'po i'waine: “Mo'ko Nasaret pono Jesus ero pato kyny'san.” ");
INSERT INTO car_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Irombo iko'ta'po: “Jesus! David parymbo! Ykotanory eneko!” ");
INSERT INTO car_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Mo'karon uwapo ytotonon 'wa te e'mapoty'po, ity'nato'me. Mo'ja 'ne ka'tu rapa iko'tapoty'po: “David parymbo! Ykotanory eneko, se!” ");
INSERT INTO car_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Irombo Jesus poropy'po. Mo'ko enupyn ene'po'po i'wa ty'wa. Itunda'po mero, Jesus woturupo'po i'wa: ");
INSERT INTO car_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“O'to ko ywairy 'se man o'wa?” Irombo ika'po: “Jopoto, oro wo'po'nen rapa.” ");
INSERT INTO car_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Irombo Jesus wyka'po i'wa: “O'po'ko rapa! Moro o'wa Tamusi amyikary akura'mai.” ");
INSERT INTO car_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","O'win wytory enuru we'i'po iru'pa rapa. Irombo Jesus wena'po ta ito'po, Tamusi ety awongary ta. Pa'poro kari'na 'wa moro ene'po. Irombo Tamusi ety awonga'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Irombo moro Jeriko taka tywo'my'po mero, ita kyny'sakon. ");
INSERT INTO car_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Irombo te amy Sakeus tatynen wokyry moro po kynakon. Mo'ko Rome pono jopoto ekataka pyrata amo'i'namon jopotory me kynakon. Typyratake kynakon. ");
INSERT INTO car_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Noky me Jesus wairy enery 'se kynakon. Mo'karon kari'na apyimy te enery a'kotojakon i'wa, sani'myn 'ky 'ky iwairy ke. ");
INSERT INTO car_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Irombo uwaponaka eka'numy'po. Jesus eneto'me ty'wa amy oroi poko iwonuku'po, moro pato itory man ke. ");
INSERT INTO car_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Irombo moro 'wa tytunda'po mero, Jesus wo'poty'po kawonaka. Ika'po i'wa: “Sakeus, ko'i ony'toko. Ero kurita ajauty ta ywairy man!” ");
INSERT INTO car_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Irombo ko'i iwony'to'po. Tauty taka Jesus wopyry ewa'ma'po i'wa imero. ");
INSERT INTO car_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Moro ene'po mero, pa'poro mo'karon kari'na eruwa'san. Ika'san: “Amy yja'wan me aitoto auty taka otawa nyton.” ");
INSERT INTO car_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mo'ko Sakeus awomy'po te. Ika'po mo'ko Jopoto 'wa: “Ase'ra te morokon yjekosanokon sytake mo'karon ipyrata'non 'wa. Amy kari'na 'wa moro ynamo'ikyry manombo ko'po ywoturupo'poto, okupa'emboto sytake i'wa rapa.” ");
INSERT INTO car_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Irombo Jesus wyka'po i'wa: “Erome te ero auto tanokon kari'na tyka mandon uta'no wyino, mo'se wairy ke enapa amy Abraham parymbo me. ");
INSERT INTO car_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Mo'ko kari'na ymuru irombo tywo'se man moro utapy'po upi, ika enapa moro uta'no wyino.” ");
INSERT INTO car_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Mo'karon ty'wa epanamatonon 'wa amy noro onumengatopo auranano ekarity'po i'wa. Mo'karon kari'na irombo ko'i terapa moro Tamusi nundymary wosenepory ekano'satokon, Jerusalem wyino tyse waty terapa iwairy ke. ");
INSERT INTO car_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ika'po: “Amy poto me aitoto wokyry tyse tyto man amy aitopo jopotory me tandy'moto'me. Morombo wyino iweramary rapa kynakon. ");
INSERT INTO car_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Tytory uwaporo ainapatoro typyitorykon tyko'ma i'wa mandon. Irombo ainatone-kari'na amu'nymbo pyrata tyje i'wa man i'waine. Tyka man i'waine: ‘Ajemaminatoko ike, ywopyry 'wa ro.’ ");
INSERT INTO car_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mo'karon inundymary man tanokon 'wa te amykon apojonano tomo'se mandon ‘Na'na mo'se wairy 'se'pa man tyjopotory me.’ tauro me. ");
INSERT INTO car_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Mo'ko poto me aitoto wokyry tywerama rapa man jopoto me tyry'po mero. O'win wytory mo'karon pyrata ke tynainary'to'san typyitorykon tyko'mapo i'wa mandon, o'to moro pyrata ke iwe'i'san uku'to'me ty'wa. ");
INSERT INTO car_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Irombo mo'ko koromono tywo'se man i'wa. Tyka man: ‘Jopoto, apyratary tu'ponaka ainapatoromboto amy sikapyi.’ ");
INSERT INTO car_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Irombo ijopotory tyka man i'wa: ‘Iru'pa tywaije mana, iru'pyn pyitonano. A'si'kono poko tamyikapore awe'i'po ke, ainapatoro aitopo undymanen me maitake.’ ");
INSERT INTO car_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Mo'ko ijokonory tywo'se man. Tyka man: ‘Jopoto, apyratary tu'ponaka ainatonemboto amy sikapyi.’ ");
INSERT INTO car_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I'wa enapa mo'ko Jopoto tyka man: ‘Amoro, ainatone aitopo undymanen me kyja.’ ");
INSERT INTO car_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Irombo mo'ko ipokorono terapa tywo'se man. Tyka man: ‘Jopoto, ero apyratary. Amy kamisa ta sunemyi. ");
INSERT INTO car_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Tanarike waty we'i apoko, tokone awonery ke. Anyry'torymbo manunja. Anipomy'torymbo mipo'sa.’ ");
INSERT INTO car_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Irombo ijopotory tyka man: ‘Aseke ajauranymbo ro yja'wan me ajypojan, yja'wanymbo 'ne roten pyitonano. Tokone ywonery muku'sakon. Ynyry'torymbo anunen me ywairy muku'sakon. Ynipomy'torymbo po'nen me ywairy muku'sakon. ");
INSERT INTO car_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","O'tono'me ko iro ke moro ypyratary anyry'pa me'i moro pyrata kura'matopo auto taka? Ijako ywopy'po mero, aije rapa wytory moro iwe'mekatopo maro ro.’ ");
INSERT INTO car_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Irombo mo'karon tokosanokon 'wa tyka man: ‘Moro pyrata ipinatoko ainary wyino. Yko mo'ko ekosa ainatone-kari'na amu'nymbo man inoro ainaka.’ ");
INSERT INTO car_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Irombo tyka mandon i'wa: ‘Jopoto, ainatone-kari'na terapa ekosa man.’ ");
INSERT INTO car_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mo'ko jopoto te tyka man: ‘Wykaje o'waine, pa'poro mo'ko totyken 'wa otykon yta'ton. Mo'ko otypyn wyino otyrykonymbo pinata'ton. ");
INSERT INTO car_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mo'karon yjenono'namon te, mo'karon tyjopotorykon me y'se'non ene'toko ijaro 'wa. Irombo ynenery me ro iwotoko!’ ” ");
INSERT INTO car_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Moro wara taurana'ma'po mero, tynemeparykon uwapo tywonukuru a'mo'po rapa i'wa Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Irombo morokon aito'kon Betfage, Betania 'wa, moro oleif paty tatynen wypy 'wa tytunda'po mero, oko amykon tynemeparykon apojoma'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Ika'po i'waine: “Moro ajuwaponokon aitopo'membo 'wa i'tandoko. Awo'myrykon akono mero amy parito'membo my'po mepota'ton. Tywe'i'po poro mo'ko parito'membo amy kari'na anaro'pa noro man tynga'nary tu'po. Imbokatoko me. Irombo ene'toko me ijaro 'wa. ");
INSERT INTO car_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Irombo amy kari'na woturupo'poto o'waine: ‘O'tono'me ko mimbokaton?’ kaitoko me i'wa: ‘Mo'ko Jopoto i'se man.’ ” ");
INSERT INTO car_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Irombo tyto'san mero, mo'karon oko inapojoma'san 'wa Jesus wyka'po wara ro oty epory'po. ");
INSERT INTO car_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mo'ko parito'membo ymbokary jako ro i'waine, mo'karon aporenjan wyka'san i'waine: “O'tono'me ko mo'ko parito'membo mimbokaton?” ");
INSERT INTO car_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Irombo ika'san: “Mo'ko Jopoto i'se man.” ");
INSERT INTO car_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Irombo aro'po i'waine Jesus 'wa. Tynoponykon yry'san i'waine mo'ko parito'membo tu'ponaka. Jesus andy'mopo'po i'waine itu'ponaka. ");
INSERT INTO car_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Itory jako ro tynoponykon apika'san i'waine oma rary me. ");
INSERT INTO car_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tyse waty terapa Jerusalem wyino iwe'i'po mero, moro oleif paty wypy wo'pemary po, pa'poro mo'karon inemeparykon apyimy 'wa tawa'pore imero mo'ja Tamusi ety awonga'po pa'poro morokon tynene'san ipori'tory poko. ");
INSERT INTO car_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ika'san: “Mo'ko Tamusi ety ta o'toto Jopoto nainen pa'poro kurano maro. Sara'me aino kapu ta nainen. Mo'ko Tamusi ety imero kawo nainen kapu ta.” ");
INSERT INTO car_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Irombo mo'karon ata'nanopy'san ra'nanokon Farise amykon wyka'san I'wa: “Amepanen, mo'karon anemeparykon e'mako!” ");
INSERT INTO car_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Irombo ejuku'san i'wa: “Wykaje o'waine, mojan yity'na'sando, morokon topu terapa kyniko'tapo'ta'ton!” ");
INSERT INTO car_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Irombo tyse waty iwe'i'po moro Jerusalem wyino. Ene'po mero, amo'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ika'po: “Oty 'wa moro sara'me aino enepyry ukutyry manombo rypo man o'wa enapa ero kurita. Moro ajenuru te enery upijan. ");
INSERT INTO car_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amykon kurita irombo mo'karon ajenono'namon aja'koto'mata'ton. Aju'menda'ton. Wararo ajaky'kata'ton. ");
INSERT INTO car_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ajami'ta'ton pa'poro otanokon o'makon maro. Oko pairo topu anino'pa ota kynaita'ton asetu'po, moro Tamusi 'wa ajetawary anukuty'pa awe'i'po ke.” ");
INSERT INTO car_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Irombo moro Tamusi auty 'wa tytunda'po mero, mo'karon otykon ekaramanamon momary a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ika'po i'waine: “Tymero man: ‘Yjauty kynaitan kari'na we'pimatopo me.’ O'waine te amy tymonakamon autary me terapa tyje man.” ");
INSERT INTO car_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Irombo kurita wararo kynemepatokon moro Tamusi auty ta. Mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon, mo'karon jopotokon enapa iwory 'se kynatokon. ");
INSERT INTO car_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amy oma anepory'pa te kynatokon, pa'poro kari'na wairy ke auran etary 'se imero. ");
INSERT INTO car_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Irombo amy kurita mo'karon kari'na emepary jako Jesus 'wa moro Tamusi auty ta, moro iru'pyn oka ekarityry jako i'wa enapa, mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon, mo'karon uwapoto'san enapa wopy'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Irombo ika'san I'wa: “Na'na 'wa ekari'ko, noky 'wa erokon otykon ka'pory o'wa, noky 'wa pai erokon otykon kapyry yry'po ajainaka?” ");
INSERT INTO car_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Irombo ejuku'san i'wa: “Awu enapa amy oty poko waturupoja o'waine. Ekari'toko 'nare y'wa. ");
INSERT INTO car_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Moro Johanes 'wa kari'na etyka'po, Tamusi nisanory moro tywaije nan? Kari'na nisanory te ka'tu?” ");
INSERT INTO car_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Irombo ero wara ase'wa iworupa'san: “Kyka'sando: ‘Tamusi nisanory moro tywaije man,’ kyngatan: ‘O'tono'me ko iro ke Johanes anamyika'pa maiton?’ ");
INSERT INTO car_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Kyka'sando te: ‘Kari'na nisanory moro tywaije man’, pa'poro mo'karon kari'na topu ke kywota'ton. Amy Tamusi auran uku'ponen me irombo Johanes we'i'po amyikaton.” ");
INSERT INTO car_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Irombo Jesus ejuku'po i'waine: “Anukuty'pa na'na man ojembo moro kari'na etyka'po wairy.” ");
INSERT INTO car_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Irombo Jesus wyka'po iwaine: “Awu enapa iro ke anekarity'pa waitake o'waine, noky 'wa erokon otykon kapyry yry'po yjainaka.” ");
INSERT INTO car_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Irombo mo'karon ata'nanopy'san 'wa ero onumengatopo auranano ekarityry a'mo'po i'wa: “Amy wokyry 'wa amy maina ta winu me tykapymy wonatopo typonje man. Irombo tapema me amykon tapojoma i'wa mandon, moro maina eneto'me i'waine. Morombo wyino amy tyseno aitopo 'wa sirikokon poko amanje tyto man. ");
INSERT INTO car_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Irombo moro wonatopo epery we'i'po mero, amy typyitory tomo'se i'wa man mo'karon maina pokonokon 'wa, moro wonatopo epery amy aije. Mo'karon maina pokonokon 'wa te tywo'ma man. Irombo ainary'pa tomo'se rapa i'waine man. ");
INSERT INTO car_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","“Irombo mo'ko jopoto 'wa amy rapa typyitory tomo'se man. Mo'ko enapa i'waine tywo'ma man. Mene typy'i'topo i'waine man. Irombo ainary'pa tomo'se rapa i'waine man. ");
INSERT INTO car_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","“Irombo amy rapa tomo'se i'wa man ijoruwanory typyitory me. Mo'ko enapa te mene imero tymyngapo'se i'waine man. Irombo toma i'waine man moro maina wyino. ");
INSERT INTO car_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Irombo mo'ko maina aporemy tyka man: ‘O'to ko waitan? Mo'ko ynipynary ymuru semo'take. Mo'ko nendota'ton pai.’ ");
INSERT INTO car_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Iwopyry ene'po mero te, mo'karon maina pokonokon tyworupa mandon ase'wa. Tyka mandon: ‘Mo'se ro mo'ko tyjumy otyrykonymbo apyinen man mo'se man. Kysiwosen, moro inapyiry manombo waito'me kotyrykon me.’ ");
INSERT INTO car_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Irombo moro maina wyino toma i'waine man. Tywo i'waine man. “O'to ko iro ke mo'ko maina aporemy mo'karon maina pokonokon ytan? ");
INSERT INTO car_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Iwoine kyno'tan. Irombo moro maina ytan amykon 'wa terapa.” “Moro eta'po mero mo'karon kari'na wyka'san: “Uwa pairo!” ");
INSERT INTO car_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesus wo'poty'po i'waine. Irombo ika'po: “O'to ko iro ke ero imero'po tauro'po nan: “Moro auto amynamon nema'pombo topu 'ne ro moro auto pori'tomanen me tywaije man.” ");
INSERT INTO car_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Pa'poro moro topu poko atamiromo'katoto ambaikata'ton. Mo'ko itu'ponaka kynomatan inoro ami'tan.” ");
INSERT INTO car_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Typokoine moro onumengatopo auranano ekarity'po ke i'wa, mo'karon Tamusi karetary uku'namon, mo'karon Tamusi pokonokon jopotorykon enapa wonumenga'san rypo apyiry poko. Mo'karon pyimano kari'na nendojatokon te. ");
INSERT INTO car_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Amy iru'pyn oma upiry ta ty'waine, amykon emoky'san i'waine maname o'po'se. Tamamboramon wara mo'karon emoky'san wosenepory kynakon, auranymbo poko ro rypo Jesus apyito'me ty'waine, yto'me ty'waine mo'ko Rome wyino opy'po jopoto ainaka. ");
INSERT INTO car_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Irombo iwoturupo'san Jesus 'wa: “Amepanen, iru'pa o'wa kari'na erupary, emepary uku'san na'na. Asewara imero kari'na menaje. Iporo moro Tamusi emary poko memepaje. ");
INSERT INTO car_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Iru'pa nan iro ke na'na 'wa mo'ko Rome pono jopoto nundymary epemary? Na'na nepematan? Uwa ka'tu?” ");
INSERT INTO car_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesus 'wa te tu'kuru ukuty'po i'waine. Irombo ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Amy amu'nymbo pyrata ene'ko y'wa sene'se me. Noky upu'po ko tu'ku nan ipoko? Noky ety ko tymero nan ipoko?” Irombo ika'san: “Mo'ko Rome pono jopoto.” ");
INSERT INTO car_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Irombo Jesus wyka'po i'waine: “Mo'ko Rome pono jopoto 'wa iro ke moro otyry ytoko. Mo'ko Tamusi otyry te ytoko Tamusi 'wa.” ");
INSERT INTO car_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Irombo auran poko apyiry upi'po i'waine mo'karon kari'na nenery me. Moro auran 'wa tanumengaporykon ta anejuku'pa i'wei'san. ");
INSERT INTO car_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Irombo amykon moro iromby'san wyino rapa awono anamyika'non Saduse wopy'san I'wa amy oty poko aturupo. Ika'san: ");
INSERT INTO car_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Amepanen, Moses 'wa tymero man ky'wanokon me: “I'me'ma typyty a'ta amy kari'na yryi romby'poto, mo'ko ipirymbo 'wa terapa mo'ko ipytymbo apyiry man. Irombo mo'ko tyryi 'mi ekataka pitani kapyry i'wa man.” ");
INSERT INTO car_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","“Oko-to'ima amykon asepiryjan kynatokon. Irombo mo'ko koromono typyta man. I'me'ma te tyromo'se man. ");
INSERT INTO car_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Irombo ipokorono 'wa terapa ipytymbo tapyije man. ");
INSERT INTO car_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Irombo mo'ko ijoruwanorykon 'wa enapa. Iwara pa'poro oko-to'imanombo mero i'me'ma tyromo'se mandon. ");
INSERT INTO car_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Morombo wyino mo'ko woryi enapa tyromo'se man. ");
INSERT INTO car_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Mo'karon iromby'san wyino awomyrykon jako rapa, nokypan pyty me ko mo'ko woryi naitan? Mo'karon oko-to'ima asepiryjan pyty me waty tywaijembo me nan?” ");
INSERT INTO car_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Irombo Jesus wyka'po i'waine: “Mo'karon ero nono tu'ponokon kari'na kynipytaton, tyworyijatonon yinombaton. ");
INSERT INTO car_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Moro aireno nono tu'po te mo'karon iromby'san wyino awondo'ko'me iru'pa epory'san ipyta'pa mandon, inomba'pa mandon. ");
INSERT INTO car_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Tyrombyrykon upijaton noro enapa. Kapu tanokon apojonano wara irombo mandon. Iromby'san wyino tawomy'san ke, Tamusi y'makon me mandon. ");
INSERT INTO car_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Moses enapa mo'karon iromby'san awomyry man uku'pojan moro paremuru po. Moro po kynganon: “mo'ko Jopoto, mo'ko Abraham tamusiry, mo'ko Isak tamusiry, mo'ko Jakob tamusiry enapa.” ");
INSERT INTO car_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Iromby'san tamusiry kapyn mo'ko man. Nuronokon tamusiry te mo'ko man. I'wa pa'poro kari'na nuro mandon.” ");
INSERT INTO car_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Irombo ejuku'po amykon Tamusi karetary uku'namon 'wa: “Amepanen, iporo ro mykaje.” ");
INSERT INTO car_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Irombo mo'karon Saduse we'i'san tanarike amy noro oty poko tywoturuporykon poko i'wa. ");
INSERT INTO car_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Irombo Jesus wyka'po i'waine: “One wara 'ne ko mo'ko Mesias ekari'saton David parymbo me? ");
INSERT INTO car_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aseke mo'ko David tykambo me man moro ware karetary ta: “Tamusi nykai mo'ko Yjopotory 'wa: ‘Yjapo'tun wyino atandy'moko, ");
INSERT INTO car_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mo'karon ajenono'namon yry 'wa ro y'wa apupuru apo'ny me.’ ” ");
INSERT INTO car_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Aseke ro David mo'ko kari'na ejatojan Jopoto me. One wara ko iro ke David parymbo me rapa mo'ko kari'na nan?” ");
INSERT INTO car_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Pa'poro mo'karon ata'nanopy'san netary me ika'po mo'karon tynemeparykon 'wa: ");
INSERT INTO car_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Tuwaro aitoko mo'karon waino pangon Tamusi karetary uku'namon pona. Apokupeine man masi'pyngon wo'mynano ta itopotyrykon, otykon ekaramato'kon po ewa'marykon, uwapo iwotandy'morykon morokon Simosu wota'nano'to'kon auto ta, ta'sakarykon ko'po iru'pyn me tapo'ne iwendamerykon. ");
INSERT INTO car_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mo'karon inongepy'san otyke'katon. Iru'pa tywairykon ekano'toko'me kari'na 'wa, Tamusi 'wa akore'pe imero kynauranaton. Moro ipokoine tymy a'wembono auranano te awosin pe 'ne ka'tu rapa kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Irombo mo'karon typyratakamon 'wa pyrata yry ene'po i'wa moro Tamusi 'wa tymy pyrata je'ny taka. ");
INSERT INTO car_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Amy omi ta aitoto inongepy'po 'wa enapa oko tyka'miramon pyrata'makon yry ene'po i'wa itaka. ");
INSERT INTO car_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Irombo ika'po: “Ita'ro pore, mo'se omi tano inongepy'po pa'poro mo'karon amykon terapa ko'po nyryi. ");
INSERT INTO car_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Pa'poro mo'karon poto me pyrata ynamonymbo ekosa pyrata kynotakamanon. Moro yton ro. Mo'se woryi ko'wu omi ta man. Ise'me pa'poro typyratarymbo yryi, pa'poro tarepary epety manombo.” ");
INSERT INTO car_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Irombo amykonymbo kynorupatokon moro Tamusi auty kura'ma'po poko kurangon topu ke, mo'karon kari'na nyry'san kurangon otykon ke enapa. Irombo Jesus wyka'po: ");
INSERT INTO car_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Pa'poro morokon anenerykon otykon tororokata'ton amy jako. Oko pairo topu anino'pa kynaita'ton asetu'po.” ");
INSERT INTO car_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Irombo iwoturupo'san i'wa: “Na'na emepanen, one wara a'ta ko iro ke morokon otykon naitan? Otypan oty poko ko moro one wara a'ta pa'poro erokon otykon wo'kapyry man uku'tan na'na?” ");
INSERT INTO car_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Irombo Jesus wyka'po: “Tuwaro aitoko awomu'maporykon pona. Pyime yjety a'kuta'ton. Amykon kyngata'ton: ‘Inoro ro awu wa.’ Amykon terapa kyngata'ton: ‘Eromembo roten kynaitan.’ Iwena'san ta kytoton. ");
INSERT INTO car_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Irombo warinu ekary etary jako o'waine, o'wo'mano ekary etary jako o'waine, kytety'katon. Morokon otykon wo'kapyry na'sen man. O'win wytory te i'matyry kapyn moro kynaitan.” ");
INSERT INTO car_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Irombo ika'po i'waine: “Kari'na ase'wa warinu ka'ta'ton. Potonon aito'kon ase'wa kyno'wota'ton. ");
INSERT INTO car_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Potonon tytyty kyno'tan. Aito'kon po kumyno kynaitan, anyky kynota'kutan. Anarinon otykon kyno'ka'tan. Potonon otykon enapa kynosenepotan kapu rary poko. ");
INSERT INTO car_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pa'poro morokon wairy uwaporo te, ajapyita'ton. Awetoine kyndopo'ta'ton. Tyjopotorykon wota'nanopy'san po'ponaka ajarota'ton ajemendoto'ko'me. Ajaru'kata'ton yja'wangon kari'na aru'katopo taka. Potonon jopotokon po'ponaka, poto 'su jopoto y'petakangon po'ponaka enapa ajarota'ton yjety upu'po me. ");
INSERT INTO car_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Moro jako ro moro anamyikarykon mekari'ta'ton. ");
INSERT INTO car_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kytesykaton moro one wara awosaijomarykon man poko moro ajemendorykon man uwaporo. ");
INSERT INTO car_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Awu ro oty suku'potake o'waine, iru'pyn me ajauranato'ko'me. Ajaurangon ejukuru upita'ton mo'karon ajenono'namon. O'to tywairykon upita'ton. ");
INSERT INTO car_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","“Irombo ajumy, asano, apiryjan, ajomorykon, aja'sakarykon ro rypo ajekaramata'ton. Amykon ara'nanokon wopota'ton enapa. ");
INSERT INTO car_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Pa'poro kari'na ajenono'ta'ton yjety upu'po me. ");
INSERT INTO car_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","O'win amy ajunsety pairo te utapy'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Moro aweja'nakarykon ke amano mepota'ton. ");
INSERT INTO car_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Warinu pokonokon apyimykon 'wa Jerusalem u'memyry enery mero te o'waine, uku'toko me moro utapyry wairy tyse waty terapa. ");
INSERT INTO car_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Oro moro jako ro mo'karon Judea tanokon netuwarikasen morokon wypy 'wa. Mo'karon Jerusalem ta aitonon wytory man kurandonaka. Mo'karon maina ta aitonon wairy man Jerusalem taka rapa o'my'pa. ");
INSERT INTO car_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Moro jako ro Tamusi mo'karon kari'na yja'wanykonymbo ramatan itu'ponakaine ro rapa, pa'poro morokon imero'san wo'ka'to'me. ");
INSERT INTO car_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Mo'karon mynotonon 'wa, mo'karon onema'senangon 'wa enapa je'tun pe pore oty kynaitan moro jako. Awosin pangon otykon kari'na epota'ton ero nono tu'po. Tamusi erekuru kyno'tan itu'ponakaine. ");
INSERT INTO car_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Moro supara ke pyime moro ponokon y'ma'kata'ton mo'karon Simosu me e'i'non. Pyime enapa kynarota'ton pa'poro wara ro ero nono tu'po. Moro Jerusalem uta'mita'ton, moro tamaporykon man kurita 'wa ro. ");
INSERT INTO car_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Weju poko, nuno poko, siriko poko potonon oty enepotan kapu. Ero nono tu'po moro parana wetururukary mory mo'karon kari'na ytan o'to tywairykon man anukuty'pa. ");
INSERT INTO car_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Morokon nono tu'ponaka o'tonon otykon poko iwety'karykon kyniwota'ton. Morokon kapu tanokon pori'tonano irombo kynesakamapo'tan. ");
INSERT INTO car_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Moro jako ro mo'ko kari'na ymuru wopyry eneta'ton kapurutu ta, pori'tonano maro imero, kurano me imero. ");
INSERT INTO car_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","“Morokon otykon wo'kapyry wota'mory jako, ajawondoko. Ajupu'san awongatoko. Eromembo roten moro ata'karykano wyino mo'kata'ton.” ");
INSERT INTO car_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","“Irombo Jesus 'wa amy onumengatopo auranano ekarity'po: “Moro oroi 'wa o'po'toko, pa'poro morokon amykon terapa wewe 'wa enapa. ");
INSERT INTO car_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Arynary enery mero o'waine, senge terapa moro poto 'su iromy wairy muku'saton. ");
INSERT INTO car_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Iwara enapa senge moro Tamusi nundymary wairy uku'toko, morokon otykon wo'kapyry enery mero o'waine. ");
INSERT INTO car_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ita'ro pore, mo'karon eromenokon kari'na i'maty'ma'pa kynaita'ton, pa'poro otykon wo'kapyry uwaporo. ");
INSERT INTO car_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kapu, nono kynuta'tan. Moro yjauranymbo te utapy'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Tuwaro koro aitoko moro awonumengarykon any'mary pona moro kari'na u'werendy'konen tanymy 'wa, moro amano poko esykano 'wa pai. Aseke irombo moro kurita typo roten ajepota'ton ");
INSERT INTO car_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","amy ajenando'kon wara. Moro kurita irombo pa'poro ero nono tu'ponokon kari'na epotan. ");
INSERT INTO car_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Tuwaro roten te aitoko. Tamusi 'wa aturupotoko awepori'tomato'ko'me pa'poro morokon kyno'ka'tan irokon otykon wyino awotunendo'ko'me, mo'ko kari'na ymuru po'ponaka awo'to'ko'me.” ");
INSERT INTO car_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kurita moro Tamusi auty ta kari'na emepatopombo i'wa kynakon. Koko te kurandonaka itotopombo kynakon moro oleif paty tatynen wypy tu'ponaka. ");
INSERT INTO car_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kokoro 'ne pa'poro mo'karon kari'na apyimy wo'topombo kynakon I'wa auran eta moro Tamusi auty taka. ");
INSERT INTO car_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Morokon uwaputa'non perere ewa'mary, mo'ko ‘eratonomapotopombo onory ewa'mary’ me kynejatojaton iro, tyse waty terapa kynakon. ");
INSERT INTO car_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Moro jako ro mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon maro oma upijatokon Jesus woto'me. Ekapyn ta iwory 'se kynatokon, tanarike tywairykon ke mo'karon kari'na apyimy pona. ");
INSERT INTO car_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Irombo mo'ko Satan wo'my'po Judas Iskariot tatynen, mo'ko o'win amy Jesus nemepary me man inoro taka. ");
INSERT INTO car_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tyto'po mero, mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi auty erangon jopotorykon enapa erupa'san Judas 'wa, one wara Jesus yry man poko ty'wa ainakaine. ");
INSERT INTO car_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mo'karon ewa'pota'san ro. Irombo pyrata ke epemary man poko taurangon epopo'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas 'wa enapa iru'pa epory'po. Irombo amy oma upiry a'mo'po i'wa Jesus yto'me ainakaine mo'karon kari'na apyimy nukuty'tory me. ");
INSERT INTO car_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Irombo te morokon uwaputa'non perere ewa'mary jakono koromono kurita tunda'po. Moro kurita ro mo'ko eratonomapotopombo kapara'membo wory kynakon. ");
INSERT INTO car_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Moro jako ro Jesus 'wa Petrus emoky'po Johanes maro. Ika'po i'waine: “Mo'ko eratonomapotopombo i'mo'katandoko kywotorykon me.” ");
INSERT INTO car_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Irombo iwoturupo'san I'wa: “Oje ko na'na 'wa i'mo'kary 'se man?” ");
INSERT INTO car_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ika'po i'waine: “Moro Jerusalem taka awo'my'sando, amy wokyry 'wa poty'sa ta tuna arorymbo mepota'ton. Mo'ko ro iwekenatoko me moro iwo'mytopo auto taka. ");
INSERT INTO car_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Irombo mo'ko auto aporemy 'wa kaitoko me: ‘Mo'ko amepanen kynganon o'wa: ‘Oje ko mo'karon nemeparykon maro mo'ko kapara'membo onoto'man y'wa nan?’ ’ ");
INSERT INTO car_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Irombo kawo amy poto 'su apuru'po enepotan o'waine. Pa'poro kyna'kurukon man oty ita terapa man. Moro po ro mo'ko kapara'membo i'mo'katoko me.” ");
INSERT INTO car_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Irombo ito'san. Jesus wyka'po wararo ty'waine oty epory'po i'waine. Irombo mo'ko kapara'membo y'mo'ka'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Irombo mo'ko eratonomapotopombo onory mero, tari'po Jesus we'i'po mo'karon apojoma'san maro tywendameto'me. ");
INSERT INTO car_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Irombo ika'po i'waine: “Mo'se eratonomapotopombo onory 'se imero we'i amaroine, moro ywota'karykary man uwaporo! ");
INSERT INTO car_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wykaje irombo o'waine, mo'ko eratonomapotopombo anono'pa noro rapa waitake ewa'mary uwaporo moro Tamusi nundymary ta.” ");
INSERT INTO car_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Irombo amy sapera apo'i'po i'wa. Tamusi ety awonga'po mero, ika'po: “Ero apyitoko. A'si pai 'ko enytoko. ");
INSERT INTO car_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wykaje irombo o'waine, erombo wyino winu anenyry'pa noro waitake moro Tamusi nundymary wopyry 'wa ro.” ");
INSERT INTO car_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Irombo mero amy perere anumy'po i'wa. Tamusi ety awonga'po mero ipoko, i'sakapoty'po i'wa. Irombo ekamy'po i'wa i'waine. Ika'po: “Yja'mun ero man. O'wanokon me ro syja. Ero wara aitoko me, ypoko awetuwaro'mato'ko'me rapa.” ");
INSERT INTO car_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Iwara enapa moro endameno pa'po me moro sapera anumy'po i'wa. Ika'po: “Ero sapera moro Tamusi wykatopombo yjan rapa asery me. Ikatopombo pori'tomanen me ro ymynuru kyne'kanjan, ajupu'san me. ");
INSERT INTO car_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Mo'ko yjekaramanen man te 'kuru erome kynendamejan ymaro. ");
INSERT INTO car_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kyny'tan ro mo'ko kari'na ymuru, Tamusi 'wa yry'po wararo. Mo'ko ekaramanenymbo te janon kynotamotan imero.” ");
INSERT INTO car_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Irombo ase'wa iworupa'san nokypan 'wa moro oty kapyry man poko. ");
INSERT INTO car_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Taurangon ejuku'san enapa i'waine nokypan wairy poko poto me 'ne tyra'naine. ");
INSERT INTO car_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesus wyka'po te i'waine: “Mo'karon potonon jopotokon mo'karon typyitorykon yjaton tytomosirykon me. Mo'karon aijopotoma'san kynojatopojaton ta'sakarykon epano'namon me. ");
INSERT INTO car_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amyjaron te, moro wara awairykon kapyn man. Ara'naine mo'ko uwapotombo wairy man amy meseku wara. Ara'naine mo'ko jopoto wairy man amy pyitonano wara. ");
INSERT INTO car_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nokypan ko poto me 'ne nan? Mo'ko endametoto? Mo'ko upanen te ka'tu? Mo'ko endametoto kapyn? Awu te ara'naine amy pyitonano wara wa. ");
INSERT INTO car_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Amyjaron te mo'ja ro maiton yjekosa pa'poro yju'kuto'kon ta. ");
INSERT INTO car_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Iro ke ro awu anundymarykon man syja o'waine, yjumy 'wa yry'po wara enapa y'wa. ");
INSERT INTO car_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Poto 'su jopoto me ywe'i'poto, ymaro mendameta'ton ywendametopo po. Matandy'mota'ton jopoto apo'nykon tu'po. Mo'karon ainapatoro itu'ponaka oko Israel y'makon pajanymbo poko a'wembono auranano myta'ton. ");
INSERT INTO car_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon, Simon, epanamako te! Mo'ko Satan awonumengarykon u'kuru 'se imero ne'i. ");
INSERT INTO car_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Awu te Tamusi 'wa waturupoi, o'wa Tamusi amyikakepyry pona. Amoro mo'karon aja'sakarykon ipori'tomako me, Tamusi 'wa awotu'ma'poto rapa.” ");
INSERT INTO car_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Irombo Petrus wyka'po I'wa: “Jopoto, amaro ro yja'wangon kari'na aru'katopo taka ywytory taro wa. Amaro ro yrombyry taro enapa wa.” ");
INSERT INTO car_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesus wyka'po te: “Wykaje o'wa, Petrus: ero koko noro korotoko ko'tary uwaporo, oruwamboto yjukuty'pa awairy mekari'take.” ");
INSERT INTO car_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Irombo ika'po tynemeparykon 'wa: “Ipyrata'pa, otyje'ny'ma, isapato'pa ajemoky'sando y'wa moro iru'pyn auranano ekari'se, matupiton amy oty poko?” Irombo ika'san: “Uwa.” ");
INSERT INTO car_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Irombo Jesus wyka'po i'waine: “Erome te typyratake amy a'ta, typyratary aron tymaro. Iwara enapa totyje'nyne amy a'ta, totyry je'ny aron. Isupara'pa amy a'ta, tywo'mymbo ekaraman amy epeka'to'me. ");
INSERT INTO car_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ero wara irombo wykaje o'waine: tymero man: ‘Yja'wan oty ka'namonymbo maro tu'ku man’. Moro ro kyno'ka'tan ymaro.” ");
INSERT INTO car_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Irombo ika'san: “Jopoto, erokon amykon oko supara.” Irombo Jesus wyka'po i'waine: “Iporo terapa man!” ");
INSERT INTO car_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Irombo Jesus wyto'po Jerusalem wyino kurandonaka. Tamery mero moro oleif paty wypy 'wa ito'po. Mo'karon inemeparykon wyto'san iwena'po ta. ");
INSERT INTO car_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Irombo moro 'wa tytunda'po mero, mo'karon tynemeparykon 'wa ika'po: “Tamusi 'wa ajauranatoko aju'kurukon pona.” ");
INSERT INTO car_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Irombo iwyinoine iwomima'po, a'si 'ko tyse. Iwokunama'po. Tamusi 'wa aurana'po: ");
INSERT INTO car_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Papa, ero je'tun pan sapera 'wa kuwaporimakapoko. Ynisanory kapyn te no'ka'nen. Anisanory te.” ");
INSERT INTO car_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Irombo amy kapu tano apojonano wosenepo'po i'wa ipori'tomato'me. ");
INSERT INTO car_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Irombo amy poto 'su anari 'wa imero apo'i'po. Pari'pe 'ne ka'tu rapa Tamusi 'wa aurana'po. Mynu wara moro eramukuru wo'paikapoty'po nono tu'ponaka. ");
INSERT INTO car_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tamusi 'wa taurana'ma'po mero, awomy'po. Mo'karon tynemeparykon 'wa ito'po. Kata'mato iwairykon 'wa tyny'no'se epory'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Irombo ika'po i'waine: “O'tono'me ko mo'ny'saton? Ajawondoko! Tamusi 'wa ajauranatoko aju'kurukon pona.” ");
INSERT INTO car_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Moro Jesus auranary jako noro, amy kari'na apyimy wopy'po. Mo'ko o'win amy Jesus nemepary Judas tatynen uwapoine kynakon. Jesus 'wa iwopy'po, iposima. ");
INSERT INTO car_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesus wyka'po te i'wa: “Judas, iposimary ke mo'ko kari'na ymuru mekaramanon?” ");
INSERT INTO car_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Irombo otypan oty wo'kapyry man ene'po mero mo'karon Jesus ekosanokon wyka'san i'wa: “Jopoto! Nipakotota'ton na'na supara ke?” ");
INSERT INTO car_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Irombo o'win amy Jesus ekosano 'wa mo'ko Tamusi pokonokon jopotory pyitory panaka'po apo'tun wyino. ");
INSERT INTO car_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Irombo Jesus wyka'po: “Ajaike'toko!” Irombo mero mo'ko wokyry panary apyipo'po rapa i'wa. Iru'pa rapa yry'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Irombo mo'karon tyweto opy'san Tamusi pokonokon jopotorykon, mo'karon Tamusi auty erangon jopotorykon, mo'karon uwapoto'san 'wa ika'po: “Amy manaman apyiry 'sangon wara imero supara maro, putu maro tywo'se mandon. ");
INSERT INTO car_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Kurita wararo ajekosaine wakon moro Tamusi auty ta. Moro jako te yjapo'i'pa maiton. Erome te Tamusi anisanorykon ka'pojaton o'waine. Erome mo'ko ewa'rumy tamamin kapyry taro man.” ");
INSERT INTO car_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesus apo'i'po mero, moro wyino aro'po i'waine. Mo'ko Tamusi pokonokon jopotory auty 'wa aro'po i'waine. Petrus kyniwekenatokon tyse terapa. ");
INSERT INTO car_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Moro auto pyrorory apu'to'po owarira'na wa'to po'manga'po i'waine. Moro wa'to ekonda iwotandy'mo'san. Petrus wotandy'mo'po enapa ira'naine. ");
INSERT INTO car_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Irombo moro wa'to aweiry ta amy amyijanano 'wa iwotandy'mo'po ene'po. Iru'pyn me imero iwo'poty'po i'wa. Irombo ika'po: “Mo'se enapa kore imaro kynakon!” ");
INSERT INTO car_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Petrus wyka'po te: “Uwa, woryi! Anukuty'pa wa!” ");
INSERT INTO car_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Akore'pe waty moro pa'po me amy terapa 'wa ene'po. Inoro wyka'po ro i'wa: “Amoro enapa amy a'sakarykon me mana!” Petrus wyka'po te: “Uwa pairo, to!” ");
INSERT INTO car_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","A'si 'ko akore'pe moro pa'po me amy terapa wyka'po imero: “Mo'ko enapa kore imaro kynakon, ran! Galilea pono enapa mo'ko man.” ");
INSERT INTO car_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrus 'wa te ejuku'po: “O'to awykary anukuty'pa wa, se!” Irombo te moro auranary jako noro, amy korotoko ko'ta'po. ");
INSERT INTO car_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Irombo Jesus wotu'ma'po. Petrus 'wa iwo'poty'po. Moro tywosenerykon akono mero Petrus wetuwaro'ma'po rapa moro Jesus auranymbo poko: “Ero koko moro korotoko ko'tary uwaporo, oruwamboto yjukuty'pa awairy mekari'take.” ");
INSERT INTO car_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Irombo iwepa'ka'po kurandonaka. Je'tun pe imero iwotamo'po. ");
INSERT INTO car_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Mo'karon apyinamon wosaijamba'san te Jesus poko. Mene iwo'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Irombo kamisa ke embatapu'to'po mero ty'waine, iwoturupo'san i'wa: “Tamusi auran uku'ponen! Ekari'ko noky 'wa awo'po!” ");
INSERT INTO car_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Pyime noro je'tun pe o'to ika'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Irombo koro'po, emamy'po mero, mo'karon Tamusi pokonokon jopotorykon wota'nanopy'san mo'karon Tamusi karetary uku'namon maro. Jesus ene'po'po i'waine typo'ponakaine. ");
INSERT INTO car_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ika'san i'wa: “Mo'ko Mesias me aja'ta, ekari'ko na'na 'wa.” Jesus wyka'po te i'waine: “Ekarity'poto ro rypo y'wa, yjamyika'pa maita'ton. ");
INSERT INTO car_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ywoturupo'poto ro rypo o'waine amy oty poko, yjejuku'pa maita'ton. ");
INSERT INTO car_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Erome ro mo'ko kari'na ymuru tandy'po kynaitan mo'ko pari'pyn Tamusi apo'tun wyino.” ");
INSERT INTO car_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Irombo pa'poro iwoturupo'san Jesus 'wa: “Tamusi ymuru iro ke amoro man?” Irombo Jesus 'wa ejuku'san: “Aseke ro mykaton inoro me ywairy.” ");
INSERT INTO car_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Irombo ika'san: “O'tono'me ko emendonen me amy kysupijaton noro? Aseke ro kore indary wyino emendoto'man kysetaton, ran!” ");
INSERT INTO car_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Irombo pa'poro mo'karon Simosu jopotorykon apyimy awomy'po. Jesus aro'po i'waine Pilatus po'ponaka. ");
INSERT INTO car_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Emendory a'mo'po iwaine. Ika'san: “Mo'se eporyi na'na pa'poro Simosu wonumengary any'manen me. Mo'ko Rome pono jopoto anepemapo'pa man pyrata ke, moro aitopo undymary epety me. Mesias me kynokari'san, Poto 'su Jopoto me.” ");
INSERT INTO car_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Irombo Pilatus woturupo'po i'wa: “Mo'karon Simosu Jopotory amoro man?” Irombo Jesus 'wa ejuku'po: “Aseke ro moro wara mykaje.” ");
INSERT INTO car_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Irombo Pilatus wyka'po mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon kari'na apyimykon 'wa enapa: “Amy pairo oty anepory'pa wa mo'se wokyry u'ta.” ");
INSERT INTO car_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Aikepy'pa te iwe'i'san tykarykon poko: “Emeparykon ta mo'karon kari'na apokumanon pa'poro Judea ta. Galilea wyino ro kari'na apokumary tane'se i'wa man ijaro 'wa.” ");
INSERT INTO car_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Moro eta'po mero, Pilatus woturupo'po i'waine: “Galilea pono mo'se nan?” ");
INSERT INTO car_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Amy Herodes nundymary tano me mo'ko Jesus wairy ukuty'po mero, aropo'po i'wa Herodes 'wa. Inoro ro moro jako 'ne Jerusalem po kynakon. ");
INSERT INTO car_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesus enery 'wa Herodes ewa'poro'po imero. Penaro terapa enery 'se kynakon, ekary eta'po ke ty'wa. Amy Jesus nenepory kapu wyinono oty enery po kyno'po'sakon. ");
INSERT INTO car_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","A'si 'ko akore'pe otykon poko Herodes woturupo'po Jesus 'wa. Anejuku'pa pairo te iwe'i'po. ");
INSERT INTO car_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ijako ro mo'karon Tamusi pokonokon jopotorykon, mo'karon Tamusi karetary uku'namon enapa mene kynemendojatokon. ");
INSERT INTO car_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Irombo Herodes 'wa enu'kary a'mo'po mo'karon warinu pokonokon maro. Iwosaijamba'san ipoko. Iwo'myndopo'po i'wa amy typotyren wo'mynano ke. Moro wara ro aropo'po rapa i'wa mo'ko Pilatus 'wa. ");
INSERT INTO car_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Moro kurita ro Herodes we'i'po Pilatus maro asakono me. Moro uwaporo iwaijenono'to'konymbo kynakon. ");
INSERT INTO car_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Irombo mo'ko Pilatus 'wa ro mo'karon Tamusi pokonokon jopotorykon ko'ma'san, mo'karon amykon terapa Simosu jopotorykon ko'ma'san enapa mo'karon kari'na apyimy maro. Ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“Mo'se wokyry mene'ton y'wa kari'na erupo'toma'san poko emendory ta. Ajembataine ro iru'pyn me simengai. Emendory se'me o'waine, otymbo ro anepory'pa we'i u'ta. ");
INSERT INTO car_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes enapa amy pairo oty anepory'pa tywaije man u'ta. Ijaro 'wa rapa irombo tane'po i'wa man. Otymbo ro anikapy'pa kore mo'se wokyry tywaije na iwopoto'me y'wa. ");
INSERT INTO car_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Iro ke ro sinondatake, ipoky'ma'po mero.” ");
INSERT INTO car_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pa'poro te mo'karon kari'na apyimy ko'ta'po: “Uwa, mo'se uta'kako imero! Barabas te inondako na'na 'wa!” ");
INSERT INTO car_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Mo'ko Barabas ro moro jako moro yja'wangon kari'na aru'katopo taka toma kynakon. O'win amy kari'na irombo tywo i'wa kynakon moro Jerusalem po iwe'kurukon jako mo'karon tupi'nonakaine tynamonymbo momary poko. ");
INSERT INTO car_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatus 'wa te Jesus nondary 'se tywairy ekarity'po rapa. ");
INSERT INTO car_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mo'karon ko'tapoty'san te: “Ipokary man! Wakapu poko ipokary man!” ");
INSERT INTO car_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Irombo te Pilatus wyka'po ijoruwanory ta: “Otypan yja'wan oty kapyi 'ne ko iro ke? U'ta otymbo ro anepory'pa we'i, iwopoto'me y'wa. Iro ke ro sinondatake, ipoky'ma'po mero.” ");
INSERT INTO car_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Aikepy'pa te mo'karon kari'na kyniko'tapo'satokon wakapu poko ipokato'me. Iko'tykon 'wa Pilatus y'mondo'po. ");
INSERT INTO car_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Irombo iwoturupoto'kon kapyry man ekarity'po Pilatus 'wa. ");
INSERT INTO car_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Inisanorykon wararo mo'ko warinu kapyry jako o'win amy kari'na wo'po poko moro yja'wangon kari'na aru'katopo taka aru'ka'po nondapo'po i'wa. Jesus yry'po te ainakaine iwopoto'me. ");
INSERT INTO car_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Irombo Jesus aro'po i'waine. Oma ta amy maina wyino o'toto wokyry poro'ka'po i'waine. Amy Sirene pono Simon tatynen mo'ko kynakon. Mo'ko mota'ponaka ro moro Jesus pokatopo man wakapu yry'po i'waine, aroto'me i'wa Jesus wena'po ta. ");
INSERT INTO car_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Poto 'su kari'na apyimy Jesus wena'po ta kyny'sakon. Pyime woryijan enapa ira'naine kynatokon. Inaron ro Jesus amojatokon ty'popurukon po'po'mary ta. ");
INSERT INTO car_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Irombo Jesus wotu'ma'po tynga'na'po taka. Ika'po i'waine: “Jerusalem ponokon woryijan, kytotamoton ypoko. Aseke apokoine te atamotoko, o'makon poko enapa. ");
INSERT INTO car_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Amy jako irombo kyngata'ton: ‘Sara'me 'ne janon kynaita'ton mo'karon i'me'non woryijan, morokon e'meka'nonymbo uwembonanokon, morokon pitani anupa'nonymbo manatykon enapa.’ ");
INSERT INTO car_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Moro jako ro tykarykon a'mota'ton morokon wypy 'wa: ‘Omatoko na'na tu'ponaka!’ Morokon wypy'makon 'wa kyngata'ton: ‘Na'na unendoko!’ ");
INSERT INTO car_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ero wara moro irombypyn wewe yry jako i'waine, o'to ko iro ke moro iromby'po yta'ton?” ");
INSERT INTO car_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Oko yja'wangonymbo kari'na aro'san enapa i'waine, asewara imaro ipokato'ko'me. ");
INSERT INTO car_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Irombo moro ‘U'je'pombo Waitopo’ tatynen 'wa tytunda'san mero Jesus poka'po i'waine wakapu poko. Mo'karon okonokon tyja'wangamon poka'san enapa i'waine, o'win amy apo'tun wyino, o'win amy apoje wyino. ");
INSERT INTO car_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Irombo Jesus wyka'po: “Papa, ija'wanykonymbo ikako. O'to tywairykon anukuty'pa mandon.” Irombo iwo'mykonymbo ekamy'san i'waine ase'wa. Nokypan 'wa otypan iwo'mymbo apyiry man uku'to'me ty'waine, tymeramon tapusikiri emapoty'san i'waine. ");
INSERT INTO car_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Irombo mo'karon kari'na apyimy kyno'po'sakon. Mo'karon Simosu jopotorykon Jesus ety jamikatokon. Kyngatokon: “Amykon terapa tapano'se i'wa man. Aseke nopano'nen, mo'ko Tamusi nyry'po Mesias me ta'ta!” ");
INSERT INTO car_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mo'karon warinu pokonokon 'wa enapa ere'nopy'po. Tyjasakoren winu ke upa iwopy'san. ");
INSERT INTO car_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ika'san i'wa: “Mo'karon Simosu Jopotory me ro aja'ta, aseke opano'ko!” ");
INSERT INTO car_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Epo tymero kynakon: MO'SE MO'KARON SIMOSU JOPOTORY ");
INSERT INTO car_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Mo'ko o'win amy ipoka'po tyja'wangen 'wa ro rypo eju'po: “Mo'ko Mesias kapyn amoro man? Opano'ko aseke iro ke. Irombo na'na epano'ko enapa.” ");
INSERT INTO car_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mo'ko akono 'wa te e'ma'po: “Amoro Tamusi aninendo'pa pairo man, iwara enapa awopory se'me? ");
INSERT INTO car_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ky'ko te kyrombyry iru'pa man. Moro o'to kywe'i'po epety kysapyija. Mo'se te amy pairo yja'wan me o'to e'i'pa tywaije man.” ");
INSERT INTO car_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Irombo ika'po Jesus 'wa: “Jesus, ypoko onumengako me, Poto 'su Jopoto me awe'i'poto.” ");
INSERT INTO car_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Irombo Jesus wyka'po i'wa: “Ita'ro pore, erome ro yjekosa terapa maitake Tamusi waitopo po.” ");
INSERT INTO car_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kurita 'ne 'ne iwe'i'po mero, pa'poro wararo ewa'rumamy'po. Oruwa juru taronaka aweita'pa rypo moro weju kynakon. ");
INSERT INTO car_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Moro jako ro moro Tamusi auty ta isererema'po kamisa wo'seka'po ase'ra. ");
INSERT INTO car_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesus wyka'po mo'ja: “Papa, ajainaka yja'kary syja.” Moro wara tyka'po mero, iworemakepy'po. ");
INSERT INTO car_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Moro ene'po mero ty'wa, mo'ko warinu pokonokon jopotory 'wa Tamusi ety awonga'po. Ika'po: “Iporo ro kore mo'se wokyry tamambore tywaije na!” ");
INSERT INTO car_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Mo'karon oty ene opy'san kari'na apyimykon werama'san rapa tautykon 'wa, morokon otykon wo'kapyry ene'po mero ty'waine. Oma ta ty'popurukon po'po'mary aro'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pa'poro Jesus nukutyrykon te tyse kyno'po'satokon, mo'karon Galilea wyino iwekenanamonymbo woryijan maro. ");
INSERT INTO car_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Amy Josef tatynen Simosu jopotorykon te tauran anepopo'pa tywaije kynakon mo'karon ta'sakarykon nikapyry man oty poko. Amy Judea tano Arimatea tatynen aitopo pono mo'ko kynakon, amy iru'pyn, tamamboren wokyry. Moro Tamusi nundymary wopyry po enapa kyno'po'sakon. ");
INSERT INTO car_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inoro wyto'po ro Pilatus 'wa aturupo Jesus ekepy'po poko. ");
INSERT INTO car_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Moro ipokatopombo wakapu wyino ika'po i'wa. Kamisa ke ijondo'po i'wa. Unemy'po i'wa amy topu atoka'po atunendopo taka. Moro taka amy unemy'pa na'sen tywaije kynakon. ");
INSERT INTO car_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Moro otare'matopo kurita te kynitundakon terapa. Moro 'wano me ro mo'karon Simosu otykon ytokon iru'pa. ");
INSERT INTO car_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Mo'karon Galilea wyino Jesus maro opy'san woryijan 'wa te Josef tywekena tywaije kynakon. One wara moro unendopo taka Jesus ekepy'po yry ene'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Irombo iwerama'san rapa auto 'wa. Moro po ro typoporamon otykon ka'poty'san i'waine kari'na kyrykyrymato'kon maro. Moro otare'matopo kurita iwotare'ma'san moro omenano mero'po wararo. ");
INSERT INTO car_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Irombo moro otare'matopo kurita pa'po me, kokoro 'ne imero mo'karon woryijan wyto'san moro Jesus unendopombo 'wa morokon tynikapy'san typoporamon otykon aro. ");
INSERT INTO car_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Moro unendopombo aputy topu epory'po i'waine tamima terapa. ");
INSERT INTO car_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Irombo itaka tywo'my'san mero, mo'ko Jopoto Jesus ekepy'po anepory'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","One wara pairo moro poko tywonumengarykon upijatokon. Moro jako 'ne oko wokyryjan wosenepo'san typotyramon wo'mynano ta. ");
INSERT INTO car_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Irombo mo'karon woryijan wety'ka'san wonsuma'san. Mo'karon okonokon wokyryjan wyka'san te i'waine: “O'tono'me ko mo'ko nurono mupijaton iromby'san ra'na? ");
INSERT INTO car_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ero po waty man! Nawomyi rapa! Onumengatoko rapa o'to ika'po poko moro Galilea po noro ta'ta, ");
INSERT INTO car_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","moro tyja'wangamon kari'na ainaka mo'ko kari'na ymuru yry man poko, moro iwory man poko, moro ijoruwanory kurita awomyry man poko rapa.” ");
INSERT INTO car_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Irombo morokon aurangonymbo poko iwetuwaro'ma'san rapa. ");
INSERT INTO car_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Irombo tywerama'san mero, pa'poro morokon ekarity'san i'waine mo'karon ainapatoro itu'ponaka o'win Jesus nemeparykonymbo 'wa, pa'poro mo'karon amykon terapa 'wa enapa. ");
INSERT INTO car_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ekari'namon me kynatokon mo'ko Magdala pono Maria, mo'ko Johana, mo'ko Jakobus sano Maria, mo'karon a'sakarykon woryijan enapa. ");
INSERT INTO car_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mo'karon apojoma'san te mo'karon woryijan 'wa typo roten oty ekarityry ekano'satokon. Anamyika'paine iwe'i'san. ");
INSERT INTO car_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mo'ko Petrus awomy'po te. Taka'ne imero ito'po moro Jesus unendopombo 'wa. Itaka tywonsuma'po mero, inoponykonymbo roten ene'san terapa i'wa. Iwerama'po rapa. Tywonumengary aro'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Moro kurita noro oko amykon Jesus nemeparykonymbo kyny'satokon amy Emaus tatynen aitopo'membo 'wa. Oruwa-kari'na stadion moro aitopo man Jerusalem wyino. ");
INSERT INTO car_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mo'karon ro kynorupatokon pa'poro morokon o'kapy'san poko. ");
INSERT INTO car_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Moro iworuparykon jako ro, iwosauranakarykon jako, aseke Jesus wopy'po i'waine. Imaroine tytory a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Anukuty'pa te kynatokon, tanupu'to tywairykon ke. ");
INSERT INTO car_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Irombo ika'po i'waine: “Oty poko ko moju'po'saton ero awytorykon ta?” Iporopy'san. Iposi'ma Jesus 'wa iwo'poty'san. ");
INSERT INTO car_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Irombo o'win amy Kleopas tatynen 'wa ejuku'po: “Jerusalem etawary se'me o'wa, amoro roten anukuty'pa man oty wo'kapy'po erokon kurita Jerusalem po?” ");
INSERT INTO car_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ika'po i'waine: “Otypan oty?” Ika'san I'wa: “Mo'ko Nasaret pono Jesus epory'po oty kore, ran! Tamusi auran uku'ponenymbo mo'ko kynakon. Pana'pe kynakon tamamin ta, tauran ta Tamusi embata, pa'poro mo'karon ero ponokon kari'na apyimy embata enapa. ");
INSERT INTO car_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Mo'karon Tamusi pokonokon jopotorykon 'wa te, mo'karon na'na jopotorykon 'wa enapa takarama man iwopoto'me. Typokapo i'waine man wakapu poko. ");
INSERT INTO car_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Na'na te rypo moro i'wa Israel ymbokary po no'potyi. Erome te oruwa kurita terapa morokon otykon wo'kapy'san man. ");
INSERT INTO car_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amykon na'na woryijatonon enapa te na'na enutano'poton. Kokoro 'ne imero moro Jesus unendopombo 'wa tyto tywaije mandon. ");
INSERT INTO car_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ija'munumbo anepory'pa te tywaije mandon. Irombo no'ton rapa na'na 'wa. Amykon nuro ekari'namon kapu tanokon apojonano wosenepo'san ekari'ton enapa ty'waine. ");
INSERT INTO car_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Irombo amykon na'na a'sakarykon nytoton moro unendopombo 'wa. Mo'karon woryijan wyka'san wararo topoje i'waine man. Jesus anene'pa te tywaije mandon.” ");
INSERT INTO car_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Irombo ika'po i'waine: “Tu'ja'nare kore mandon! Pa'poro morokon Tamusi auran uku'ponamon wyka'san anamyikaporo'pa mandon! ");
INSERT INTO car_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mo'ko Mesias wota'karykary man kapyn tywaije nan, moro tykuranory taka tywo'myto'me?” ");
INSERT INTO car_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Irombo pa'poro morokon Tamusi karetary ta morokon typoko imero'san ekarity'san i'wa i'waine. Moses po iwota'mo'po. Irombo mo'ja ro ito'po pa'poro mo'karon Tamusi auran uku'ponamonymbo 'wa. ");
INSERT INTO car_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Irombo tyse waty terapa moro itoto'kon aitopo 'wa itundarykon we'i'po. Mo'ko we'i'po amy mo'ja ro ytototo wara. ");
INSERT INTO car_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Iwyry'ka'po te i'waine itoto'me tymaroine. Ika'san: “Na'na ekosa aiko! Koine 'ne terapa man. Kyniko'manjan terapa.” Irombo imaroine ito'po ekosaine tywaito'me. ");
INSERT INTO car_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Irombo tywotunga'san mero tywendameto'ko'me, perere anumy'po i'wa. Tamusi ety awonga'po i'wa. Moro perere y'sakapoty'po i'wa. Irombo ekamy'po i'wa i'waine. ");
INSERT INTO car_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Moro jako 'ne enuta'san. Ukuty'po rapa i'waine. Tukuty'po mero te iwonekepy'po. ");
INSERT INTO car_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Irombo ase'wa ika'san: “Kyturu'san waty nasinakon moro oma ta korupary jako i'wa, morokon imero'san enepory jako i'wa!” ");
INSERT INTO car_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Irombo o'win wytory awomy'san. Iwerama'san Jerusalem 'wa rapa. Moro po ro mo'karon ainapatoro itu'ponaka o'win Jesus nemeparykonymbo wota'nanopy'san epory'san i'waine mo'karon ekosanokon maro. ");
INSERT INTO car_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Mo'karon wyka'san ro mo'karon Emaus wyino opy'san 'wa: “Iporo ro mo'ko Kyjopotorykon tawonje man. Simon 'wa tywosenepo man!” ");
INSERT INTO car_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Irombo mo'karon Emaus wyino opy'san 'wa moro oty 'wa oma ta topory'san, moro one wara moro perere y'sakapotyry jako ty'waine ukuty'po ekarity'po. ");
INSERT INTO car_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Morokon otykon poko iworuparykon jako noro, typo roten aseke Jesus ira'naine kynakon. ");
INSERT INTO car_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ika'po i'waine: “Iru'pa ro rypo mandon?” Poto me iwety'ka'san. Tanarike imero iwe'i'san. Amy akatombo ja'ta ekanopy'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ika'po te i'waine: “O'tono'me ko mety'katon? O'tono'me ko moropangon onumengano mene'pojaton aturu'san taka? ");
INSERT INTO car_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","O'po'toko yjainary 'wa, ypupuru 'wa. Awu ro awu wa. Yja'mun apotoko, se, meneto'se me amy akatombo me kapyn ywairy. Amy akatombo kore ija'mu'ma man. Awu te tyja'mune wa.” ");
INSERT INTO car_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Moro wara tykary akono mero morokon tainary, typupuru enepo'san i'wa i'waine. ");
INSERT INTO car_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ise'me te tawa'porykon ta anamyika'pa iwe'i'san. Enuta'san imero. Irombo Jesus wyka'po i'waine: “Tanapymy me amy ajekosaine nan?” ");
INSERT INTO car_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Irombo amy woto kararaka'po punu'po ke upa'po i'waine. ");
INSERT INTO car_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Apo'i'po i'wa. Inenerykon mero ono'po i'wa. ");
INSERT INTO car_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ika'po i'waine: “Ajekosaine noro yja'ta, ero wara wykan o'waine: ‘Morokon Moses karetary ta, mo'karon Tamusi auran uku'ponamonymbo karetarykon ta, moro ware karetary ta enapa ypoko tymero man irokon wo'kapyry man.’ ” ");
INSERT INTO car_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Irombo enutano'po'san i'wa, morokon imero'san uku'to'me i'waine. ");
INSERT INTO car_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ika'po i'waine: “Iwara tymero man mo'ko Mesias wota'karykary, moro ijoruwanory kurita awomyry rapa mo'karon iromby'san wyino. ");
INSERT INTO car_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jerusalem wyino pa'poro kari'na 'wa ety ta ero oka aripapyry man tymero enapa menejaton: Tamamyrykon u'mary man mo'karon kari'na 'wa, tyja'wanykonymbo kato'me Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Erokon amyikaponamon me amyjaron mandon. ");
INSERT INTO car_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mo'ko yjumy wykatopombo semo'take otu'ponakaine. Amyjaron te aimomo'toko me Jerusalem po, ajondorykon 'wa ro kapu tano pori'tonano ke.” ");
INSERT INTO car_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Irombo Jesus 'wa aro'san kurandonaka moro aitopo'membo Betania 'wa. Moro po ro tainary awonga'po i'wa kawonaka. Ikuranondo'san i'wa. ");
INSERT INTO car_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Moro ikuranondorykon jako noro, ito'po iwyinoine. Kapu taka awo'nuku'po. ");
INSERT INTO car_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Tywokunama'ma'san mero, Jerusalem 'wa rapa iwerama'san tawa'pore imero. ");
INSERT INTO car_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Irombo o'kapyn roten moro Tamusi auty ta Tamusi ety awongary poko iwe'i'san.");
INSERT INTO car_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Koromo moro auranano tywaije man. Moro auranano Tamusi ekosa tywaije man. Moro auranano ro Tamusi me tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Moro ro koromo Tamusi ekosa tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Moro 'wa pa'poro oty tyka'po man. Moro pyndo amy pairo ikapy'po oty ikapy'pa tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Moro auranano ta ro amano tywaije man. Moro amano ro mo'karon kari'na aweiry me tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Moro aweinano ro oty aweipanon ewa'rumy ta. Moro ewa'rumy 'wa e'wu'kary tupi man. ");
INSERT INTO car_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Irombo amy kari'na apojoma'po Tamusi 'wa. Ety me Johanes kynakon. ");
INSERT INTO car_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Mo'ko wopy'po ro oty amyikaponen me. Moro aweinano poko oty amyikapory i'wa kynakon, pa'poro kari'na yto'me ty'wa Tamusi amyikanamon me. ");
INSERT INTO car_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mo'ko kapyn moro aweinano me kynakon. Moro aweinano poko te oty amyikapory i'wa kynakon. ");
INSERT INTO car_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Moro iro 'nero aweinano, moro pa'poro kari'na aweipanon iro kyno'sakon ero nono tu'ponaka. ");
INSERT INTO car_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Irombo ero nono tu'po kynakon. Ero nono tyka'po i'wa kynakon. Ise'me te anukuty'pa ero nono we'i'po. ");
INSERT INTO car_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Mo'karon ta'sakarykon emandopo 'wa iwopy'po. Mo'karon a'sakarykon we'i'san te i'se'pa. ");
INSERT INTO car_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pa'poro mo'karon ty'sangonymbo 'wa te, mo'karon toty amyikanamon 'wa oma yry'po i'wa, Tamusi y'makon me iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tamusi y'makon me yry'san uwembonano wyino omano poko kapyn, kari'na nisanory 'wa kapyn, wokyry nisanory 'wa kapyn, Tamusi 'wa te. ");
INSERT INTO car_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Moro auranano we'i'po kari'na me. Kyra'naine emamy'po. Moro ikuranory ene'po na'na 'wa. Mo'ko o'win'konombo tymuru 'wa mo'ko jumynano nyry kurano moro kynakon. Tyturu'popore imero, iporo enapa moro auranano kynakon. ");
INSERT INTO car_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ipoko ro Johanes 'wa oty amyikapo'po. Iko'ta'po: “Mo'se inoro, mo'ko ero wara ynekarity'po: ‘Mo'ko ywena'po ta kyno'san inoro yko'po poto me man.’ Ywairy uwaporo irombo mondo terapa tywaije man.” ");
INSERT INTO car_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Moro ituru'popory wotakamary wyino ituru'popory tapyipo'se pa'poro ky'waine man. ");
INSERT INTO car_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Moro omenano mero'po ene'nen me irombo Moses tywaije man. Moro tyturu'popore aino ene'nen me te, moro iporono ene'nen me enapa Jesus Kristus tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Amy pairo kari'na Tamusi anene'pa noro man. Mo'ko o'win'konombo Tamusi ekondano ymunano, mo'ko Tamusi me enapa man inoro 'wa te tuku'po man. ");
INSERT INTO car_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Mo'karon Simosu jopotorykon 'wa Jerusalem wyino Tamusi pokonokon emoky'san ipyitorykon maro Johanes 'wa ero wara aturupo: “Noky ko amoro man?” Irombo Johanes 'wa oty amyikapo'po. ");
INSERT INTO car_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Oty anipyi'me'to'pa ejuku'san i'wa. Ika'po imero i'waine: “Mo'ko Mesias kapyn awu wa.” ");
INSERT INTO car_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Iwoturupo'san i'wa: “Noky ko iro ke amoro man? Elia?” Ika'po i'waine: “Uwa, inoro kapyn awu wa.” Ika'san: “Mo'ko Tamusi auran uku'ponen ka'tu amoro man?” Ika'po eju'to'ko'me: “Uwa.” ");
INSERT INTO car_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Irombo ika'san i'wa: “Noky 'ne ko iro ke amoro man? Okari'ko, na'na nekarity'se me mo'karon tomo'namonymbo 'wa. O'to ko mykanon aseke apoko?” ");
INSERT INTO car_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ika'po: “Mo'ko ero wara moro iponomyn wo'i ta ko'tatoto awu wa: ‘Sapatoro mo'ko Jopoto emary ytoko.’ ” Mo'ko Tamusi auran uku'ponenymbo Jesaja auranymbo moro man. ");
INSERT INTO car_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mo'karon apojoma'san ra'na amykon Farise enapa kynatokon. ");
INSERT INTO car_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Mo'karon woturupo'san ro i'wa. Ika'san: “O'tono'me ko iro ke kari'na metykanon, mo'ko Mesias me kapyn, mo'ko Elia me kapyn, mo'ko Tamusi auran uku'ponen me kapyn enapa awairy se'me?” ");
INSERT INTO car_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Johanes wyka'po eju'to'ko'me: “Awu tuna ke kari'na setykaje. Amy te man ara'naine anukuty'torykon, ");
INSERT INTO car_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","mo'ko ywena'po ta o'toto. Mo'ko sapatory etandy ymbokary pairo supija.” ");
INSERT INTO car_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Moro wara 'kuru iwe'i'po moro Betania po, moro tuna Jordan kopose me, moro Johanes 'wa kari'na etykatopombo po. ");
INSERT INTO car_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Irombo koro'po ty'wa mo'ko Jesus wopyry ene'po i'wa. Irombo ika'po: “Enetoko mo'ky mo'ko Tamusi kaparary'membo, mo'ko yja'wan me ero nono we'i'po kanen. ");
INSERT INTO car_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mo'ko ro mo'ko ero wara ynekarity'po: ‘Ywena'po ta amy yko'po poto me aitoto wokyry kyno'san.’ Ywairy uwaporo irombo mondo terapa tywaije man. ");
INSERT INTO car_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Awu enapa anukuty'pa wakon. Mo'karon Israel pajanymbo 'wa iwonepoto'me te wopyi tuna ke kari'na etyka.” ");
INSERT INTO car_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johanes 'wa oty amyikapo'po. Ika'po: “Mo'ko Tamusi a'kary wony'tory senei akukuwa eneke kapu wyino itu'ponaka. Irombo itu'po ro ne'i. ");
INSERT INTO car_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Awu enapa anukuty'pa wakon. Mo'ko tuna ke kari'na etyka yjemo'nenymbo te kyngan y'wa: ‘Mo'ko Tamusi a'kary wony'tory menetake amy kari'na tu'ponaka. Irombo itu'po iwairy menetake. Mo'ko ro, mo'ko Tamusi a'kary ke kari'na etykanen mo'ko man.’ ");
INSERT INTO car_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Senei ro. Mo'ko Tamusi ymuru me mo'ko wairy samyikapoja.” ");
INSERT INTO car_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Irombo koro'po Johanes moro ty'wa kari'na etykatopo po rapa kynakon oko tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Irombo Jesus wytory ene'po mero ty'wa, ika'po: “O'po'toko. Mo'ky mo'ko Tamusi kaparary'membo.” ");
INSERT INTO car_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mo'karon okonokon inemeparykon 'wa moro wara ikary eta'po. Irombo Jesus wekena'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus wotu'ma'po. Moro i'waine tywekenary ene'po mero, ika'po i'waine: “Oty 'se ko mandon?” Ika'san I'wa: “Rabi,” (moro tauro'po man: amepanen) “oje ko ajemanjan?” ");
INSERT INTO car_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ika'po i'waine: “O'toko, meneto'se me.” Irombo ito'san imaro. Emandopo ene'po i'waine. Moro jako okupa'en juru kynakon. Iro ke ro moro kurita ekosa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","O'win amy mo'ko Johanes wykatopombo poko Jesus wekenanenymbo mo'ko Simon Petrus piry Andreas mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Mo'ko wyto'po ro mo'ko typiry Simon epoje na'nen. Ika'po i'wa: “Mo'ko Mesias eporyi na'na.” Moro Mesias tauro'po man: ikapa'po. ");
INSERT INTO car_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Irombo aro'po i'wa Jesus 'wa. Ene'po mero, Jesus wyka'po i'wa: “Mo'ko Johanes ymuru Simon amoro mana. Kefas terapa ajety me kynaitan.” Moro Kefas tauro'po man Petrus. ");
INSERT INTO car_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Irombo koro'po Galilea 'wa tytory 'se Jesus we'i'po. Irombo Filipus epory'po i'wa. Jesus wyka'po i'wa: “O'ko ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Amy Betsaida pono mo'ko Filipus kynakon, mo'ko Andreas wara, mo'ko Simon wara enapa. ");
INSERT INTO car_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipus 'wa Natanael epory'po. Ika'po i'wa: “Mo'ko omenano karetary ta ipoko Moses 'wa oty tymero man inoro, mo'ko ipoko mo'karon Tamusi auran uku'ponamonymbo 'wa tymero man inoro eporyi na'na: Jesus, mo'ko Josef ymuru, mo'ko Nasaret pono.” ");
INSERT INTO car_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Irombo Natanael wyka'po i'wa: “Iru'pyn oty 'kare Nasaret wyino tywopyry taro nan.” Filipus wyka'po i'wa: “O'ko 'ne, mene'se me.” ");
INSERT INTO car_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael wopyry ene'po mero, Jesus wyka'po ipoko: “Enetoko. Mo'se amy Israel parymbo 'nero. Kari'na anemu'ma'pa man.” ");
INSERT INTO car_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael wyka'po i'wa: “Ojembo ko kuku'san?” Jesus wyka'po eju'to'me: “Filipus 'wa ako'mary uwaporo, moro oroi upi'no konei.” ");
INSERT INTO car_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanael wyka'po I'wa: “Amepanen, Tamusi ymuru amoro mana. Poto 'su Israel pajanymbo Jopotory amoro mana.” ");
INSERT INTO car_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesus wyka'po eju'to'me: “Moro oroi upi'no y'wa ajene'po ekarity'po ke kamyikanon? Morokon ko'ponokon potonon otykon menetake.” ");
INSERT INTO car_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ika'po noro i'wa: “Ita'ro pore, kapu wendaka'po meneta'ton. Mo'karon Tamusi apojongon wonukuru, iwony'torykon enapa meneta'ton mo'ko kari'na ymuru epo.” ");
INSERT INTO car_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Irombo oko kurita pa'po me amy aimyno ewa'mary kynakon Kana po, Galilea ta. Moro po ro mo'ko Jesus sano kynakon. ");
INSERT INTO car_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mo'ko Jesus enapa mo'karon inemeparykon maro taju'se kynakon moro aimyno ewa'mato'me. ");
INSERT INTO car_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Irombo moro winu y'matyry mero mo'ko Jesus sano wyka'po I'wa: “Winu waty noro man ekosaine.” ");
INSERT INTO car_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesus wyka'po i'wa: “O'tono'me ko ypoko man? Moro o'to ywaitopo jururu itunda'pa na'nen man.” ");
INSERT INTO car_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Isano wyka'po mo'karon otykon ekanamon 'wa: “O'to ika'po wara ro aitoko!” ");
INSERT INTO car_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","O'win-to'ima topu kapy'san potysa moro po kynatokon. Simosu emery wara ro mo'karon aimyno ewa'manamon wekumi'to'kon tuna je'ny morokon kynakon. Oko, oruwa samaku tuna apyiry taro kynatokon. ");
INSERT INTO car_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesus wyka'po mo'karon otykon ekanamon 'wa: “Morokon potysa a'no'kapo'toko tuna ke.” Irombo a'no'kapoty'san imero i'waine. ");
INSERT INTO car_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Irombo mero ika'po i'waine: “Amy anundoko. Irombo mo'ko endameno jopotory 'wa arotoko.” Amy aro'po ro i'waine. ");
INSERT INTO car_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Mo'ko endameno jopotory 'wa moro winu me enurima'po tuna apo'po. Mo'karon tuna anunamonymbo ojembo moro winu wopy'po uku'satokon. Mo'ko endameno jopotory te anukuty'pa kynakon. Iro ke ro mo'ko pytatoto ko'ma'po i'wa. ");
INSERT INTO car_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Ika'po i'wa: “Pa'poro kari'na moro iru'pynymbo winu na'nen ekambojan. Mo'karon ejuku'san wetymy'san mero te moro yja'wanymbo winu ekambojan. O'wa te moro iru'pynymbo winu tykura'ma man wena'po tano me.” ");
INSERT INTO car_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ero Kana po, Galilea ta Jesus nikapy'po oty, moro koromono me inikapy'po kapu wyinono oty moro kynakon. Iwara ro moro tykuranory enepo'po Jesus 'wa. Mo'karon inemeparykon 'wa amyika'po. ");
INSERT INTO car_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Irombo mero Kafaraum 'wa iwo'pema'po mo'ko tysano maro, mo'karon typiryjan maro, mo'karon tynemeparykon maro enapa. Amykon kurita roten moro po iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tyse waty mo'ko ‘eratonomapotopombo’ onory ewa'mary we'i'po mero, Jesus wonuku'po Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Irombo moro Tamusi auty ta tandy'po mo'karon paka, kapara, akukuwa ekaramanamon, mo'karon pyrata ambo'namon enapa epory'san i'wa. ");
INSERT INTO car_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Irombo kurawa kapy'po i'wa tonomy ypo'topo me. Mo'karon kapara, paka moma'san i'wa moro Tamusi auty wyino. Mo'karon pyrata ambo'namon pyratarymbo papy'po i'wa nono tu'ponaka. Morokon itapararykonymbo uringa'san i'wa. ");
INSERT INTO car_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Mo'karon akukuwa ekaramanamon 'wa ika'po: “Pa'poro erokon otykon ero wyino emimatoko. Mo'ko yjumy auty kysyton amy otykon ekaramatopo auto me.” ");
INSERT INTO car_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Irombo mo'karon inemeparykon wetuwaro'ma'san rapa ero imero'po poko: Moro ajauty 'wano me yjemaminary asiny ywotan. ");
INSERT INTO car_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mo'karon Simosu jopotorykon woturupo'san I'wa: “Otypan kapu wyinono oty menepotan, moro iru'pa moro moro wara awairy wairy uku'to'me na'na 'wa?” ");
INSERT INTO car_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesus wyka'po eju'to'ko'me: “Ero Tamusi auty akatoko. Irombo oruwa kurita samy'matake rapa.” ");
INSERT INTO car_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Irombo mo'karon Simosu jopotorykon wyka'san: “Oko-kari'na itu'ponaka o'win-to'ima siriko ero Tamusi auty amy'mary tywaije man. Amoro te oruwa kurita mamy'matan rapa?” ");
INSERT INTO car_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Moro ipoko auranatopo Tamusi auty te moro ija'mun moro kynakon. ");
INSERT INTO car_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iromby'san wyino awomy'po wyino mo'karon inemeparykon wetuwaro'ma'san rapa moro moro wara ika'po poko. Irombo moro imero'po, moro Jesus wykatopombo amyika'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Mo'ko eratonomapotopombo onory ewa'mary jako Jerusalem po a'ta ro, pyime kari'na 'wa moro ety amyika'po. Morokon inenepory kapu wyinonokon otykon enejatokon irombo. ");
INSERT INTO car_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesus te ainakaine tywotyry 'se'pa kynakon. Pa'poro irombo emerykon uku'sakon. ");
INSERT INTO car_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Kari'na 'wa kari'na poko oty ekarityry anupi'pa kynakon, kari'na ukutyry ke aseke ty'wa. ");
INSERT INTO car_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Irombo amy Nikodemus tatynen Simosu jopotory kynakon. Amy Farise mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Mo'ko wopy'po ro koko Jesus 'wa. Ika'po I'wa: “Amepanen, Tamusi wyino amepanen me awopy'po uku'san na'na. Amy pairo morokon anenepory kapu wyinonokon otykon enepory upijan, imaro e'i'pa Tamusi a'ta.” ");
INSERT INTO car_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesus wyka'po eju'to'me: “Ita'ro pore, asery me rapa e'i'pa ta'ta, amy pairo kari'na moro Tamusi nundymary enery upitan.” ");
INSERT INTO car_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodemus wyka'po I'wa: “One wara ko asery me rapa amy kari'na naitan, tam'po'ko me ta'ta? Tysano uwembo taka rapa 'kare tywo'myry taro nan, tamapoto'me rapa i'wa.” ");
INSERT INTO car_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesus wyka'po eju'to'me: “Ita'ro pore, asery me tuna wyino, a'kanano wyino enapa opy'pa ta'ta, amy pairo kari'na moro Tamusi nundymary taka tywo'myry upitan. ");
INSERT INTO car_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ja'munano wyino ja'munano kyno'san. A'kanano wyino a'kanano kyno'san. ");
INSERT INTO car_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Moro ‘Asery me rapa awairykon man’ ywyka'po 'wa kytonumengapoton. ");
INSERT INTO car_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Pepeito tynisanory 'wa ro kynoturojan. Imory metaje. Ojembo iwopyry, oja itory pai anukuty'pa te mana. Iwara enapa pa'poro a'kanano wyino opy'san mandon.” ");
INSERT INTO car_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodemus wyka'po eju'to'me: “One wara ko moro tywo'kapyry taro nan?” ");
INSERT INTO car_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesus wyka'po eju'to'me: “Israel pajanymbo emepanen me awairy se'me morokon otykon anukuty'pa man? ");
INSERT INTO car_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ita'ro pore, tynukutyry poko na'na kynaurananon. Tynene'po amyikapojan na'na. Moro na'na namyikapory anapo'i'pa te mandon amyjaron. ");
INSERT INTO car_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nono tu'ponokon otykon poko o'waine yjauranary jako yjamyika'pa aja'taine, one wara ko kapu tanokon otykon poko yjauranary jako kamyikata'ton? ");
INSERT INTO car_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Amy pairo kapu taka anuku'pa tywaije man. Mo'ko kapu wyino opy'po roten kynonu'tan: mo'ko kari'na ymuru. ");
INSERT INTO car_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Mo'ko Moses 'wa moro iponomyn wo'i ta mo'ko okoju awonga'po wara enapa mo'ko kari'na ymuru awongary man, ");
INSERT INTO car_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pa'poro amyikanen 'wa moro i'matypyn roten amano epoto'me. ");
INSERT INTO car_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Poto me ero nono pynary ke ty'wa, Tamusi 'wa mo'ko o'win'konombo tymuru tyje man. Iwara pa'poro mo'karon amyikanamon utapy'pa kynaita'ton. Moro i'matypyn roten amano apyita'ton te. ");
INSERT INTO car_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tamusi 'wa mo'ko tymuru ero nono tu'ponaka tomo'se man, ero nono poko i'wa a'wembono auranano yto'me kapyn, epano'to'me te i'wa. ");
INSERT INTO car_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mo'ko imuru amyikanen poko a'wembono auranano yry'pa man. Mo'ko anamyikapyn poko te a'wembono auranano tyje terapa man, mo'ko o'win'konombo Tamusi ymuru ety anamyika'pa iwairy ke. ");
INSERT INTO car_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ero wara moro a'wembono auranano man: Moro aweinano ero nono tu'ponaka tywo'se man. Mo'karon kari'na 'wa te moro ewa'rumy typyna man moro aweinano ko'po. Morokon kari'na emamingon irombo yja'wan me kynatokon. ");
INSERT INTO car_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Mo'ko yja'wangon otykon ka'nen moro aweinano jenono'san. Moro aweinano 'wa ito'pa man. Morokon tynikapyrykon otykon uku'pory 'se'pa irombo man. ");
INSERT INTO car_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mo'ko iporono oty ka'nen te aweinano 'wa kyny'san, Tamusi apokupe morokon tynikapyrykon otykon wairy woneto'me.” ");
INSERT INTO car_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Irombo mero Jesus wyto'po mo'karon tynemeparykon maro moro Judea yinonory 'wa. Moro po ro imaroine a'si'ko akore'pe kynakon. Kari'na etykakon. ");
INSERT INTO car_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johanes enapa kari'na etykakon Enon po, Salim wyino tyse waty. Pyime irombo tuna undykon moro po kynatokon. Kari'na kyno'satokon i'wa. Irombo i'wa kynosetykapojatokon. ");
INSERT INTO car_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Moro jako mo'ko Johanes yja'wangon kari'na aru'katopo taka aru'ka'pa na'nen kynakon. ");
INSERT INTO car_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Moro jako ro mo'karon Johanes nemeparykon 'wa taurangon ejuku'san amy Simosu maro ekorokano poko. ");
INSERT INTO car_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Irombo Johanes 'wa iwopy'san. Ika'san i'wa: “Amepanen, mo'ko Jordan kopose me ajekosa kynakon inoro, mo'ko mamyikapon inoro kari'na etykanon. Pa'poro kari'na kyny'saton I'wa.” ");
INSERT INTO car_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Johanes wyka'po eju'to'ko'me: “Kari'na amy pairo oty apyiry upijan, anyry'pa ty'wa Tamusi we'i'poto. ");
INSERT INTO car_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Aseke amyjaron ero ywyka'po amyikaponamon me mandon: ‘Mo'ko Mesias kapyn awu wa. Uwapono me te tomo'se wa.’ ");
INSERT INTO car_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mo'ko tynaporemyndo'po woryi apyinen, amy pytatoto mo'ko man. Mo'ko pytatoto ekosano akono, mo'ko i'wa kynepanamanon inoro kynewa'potanon moro auran etary jako. Moro wara enapa yjewa'pory y'namorojan. ");
INSERT INTO car_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Poto me 'ne ka'tu rapa mo'ko wairy man. Awu te ko'waro 'ko 'ne ka'tu rapa ywairy man. ");
INSERT INTO car_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Mo'ko kawo wyino o'toto pa'poro kari'na epo man. Mo'ko nono wyinono nono wyino man. Nono wyino kynaurananon. Mo'ko kapu wyino o'toto te pa'poro kari'na epo man. ");
INSERT INTO car_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Moro tyneta'po amyikaponen me man. Amy pairo kari'na te moro inamyikapory anamyika'pa man. ");
INSERT INTO car_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mo'ko inamyikapory amyikanenymbo te iporo Tamusi wairy amyikapojan. ");
INSERT INTO car_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mo'ko Tamusi nemoky'po irombo Tamusi auran ekari'san. Poto me irombo Tamusi ta'kary yjan i'wa. ");
INSERT INTO car_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mo'ko jumynano mo'ko tymuru pynanon. Pa'poro oty ainaka tyje i'wa man. ");
INSERT INTO car_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mo'ko ymunano amyikanen ekosa i'matypyn roten amano man. Mo'ko ymunano anamyikapyn te amano anene'pa kynaitan. Tamusi erekuru te itu'po kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jesus 'wa Johanes ko'po pyime tynemeparykon me kari'na yry, etykarykon enapa eta'po mo'karon Farise 'wa. ");
INSERT INTO car_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Aseke te Jesus kari'na anetyka'pa kynakon. Mo'karon inemeparykon te kynetykatokon. ");
INSERT INTO car_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Mo'karon Farise 'wa moro eta'po ukuty'po mero ty'wa, Jesus wyto'po Judea wyino Galilea 'wa rapa. ");
INSERT INTO car_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Samaria yinonory tu'po te itory kynakon. ");
INSERT INTO car_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Moro Samaria ta ro amy Sikar tatynen aitopo 'wa itunda'po. Mo'ko tymuru Josef 'wa Jakob nyry'pombo nono wyino tyse waty moro aitopo kynakon. ");
INSERT INTO car_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jakob toponarymbo moro po kynakon. Tytory poko tyrupota'po ke, Jesus wotandy'mo'po moro topona po. Kurita 'ne 'ne kynakon moro jako. ");
INSERT INTO car_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Irombo amy Samaria pono woryi wopy'po tuna aije. Jesus wyka'po i'wa: “Tuna ke kupako.” ");
INSERT INTO car_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Mo'karon inemeparykon irombo tyto kynatokon moro Sikar 'wa arepa epeka'se. ");
INSERT INTO car_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Irombo mo'ko Samaria pono woryi wyka'po I'wa: “One wara ko amoro Simosu me y'wa amy Samaria pono woryi me tuna poko maturupojan?” Mo'karon Simosu irombo mo'karon Samaria ponokon maro asato'ke mandon. ");
INSERT INTO car_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesus wyka'po eju'to'me: “Moro Tamusi nyry ukuty'pomboto o'wa, noky me mo'ko tuna poko aturupo'po wairy ukuty'pomboto enapa o'wa, amoro i'wa maturupory tuna poko. Irombo amano ynen tuna yry o'wa.” ");
INSERT INTO car_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Irombo mo'ko woryi wyka'po I'wa: “Jopoto, tuna anundopo waty man ajekosa. Irombo moro topona jansi'pe man. One wara ko iro ke amano ynen tuna ajekosa naitan? ");
INSERT INTO car_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mo'ko na'na tamurumbo Jakob ko'po ka'tu man? Mo'ko 'wa ro irombo ero topona tyje man na'na 'wa. Aseke iwyino tuna tanyje i'wa man ty'makon maro, tokykon maro enapa.” ");
INSERT INTO car_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesus wyka'po eju'to'me: “Pa'poro ero tuna enynen tuna 'se rapa kynaitan. ");
INSERT INTO car_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Moro ynyry tuna enynenymbo te, tuna sanory aniwo'pa noro rapa kynaitan. Moro ynyry tuna kynaitan mo'ko enynenymbo ta i'matypyn amano ynen, pari'pe o'puririkatoto tuna undy me.” ");
INSERT INTO car_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Mo'ko woryi wyka'po I'wa: “Jopoto, moro tuna ene'ko y'wa, ywo'pa noro tuna sanory waito'me, tuna aije opy'pa noro ywaito'me ijaro 'wa.” ");
INSERT INTO car_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesus wyka'po i'wa: “Oino iko'matango. Irombo ijaro 'wa rapa o'ko 'ne.” ");
INSERT INTO car_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Mo'ko woryi wyka'po eju'to'me: “Ino'ma wa.” Jesus wyka'po i'wa: “Iporo ro ino'ma mokari'sa. ");
INSERT INTO car_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ainatonemboto tyinone tywaije mana. Mo'ko erome imaro mana inoro oino kapyn mo'ko man. Iporo ro moro mekari'sa.” ");
INSERT INTO car_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Mo'ko woryi wyka'po I'wa: “Jopoto, amy Tamusi auran uku'ponen me awairy seneja. ");
INSERT INTO car_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Na'na tangonymbo 'wa moro wypy tu'po Tamusi ety tawonga man. Amyjaron te Jerusalem po Tamusi ety awongary man mekari'saton.” ");
INSERT INTO car_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesus wyka'po i'wa: “Kamyikako, woryi! Amy jako moro wypy tu'po kapyn, Jerusalem po kapyn enapa Tamusi ety mawongata'ton. ");
INSERT INTO car_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anukuty'torykon ety mawongaton amyjaron. Na'na te tynukutyry ety awonganon. Moro opano'no irombo Simosu wyino kyno'san. ");
INSERT INTO car_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Aire 'kopore mo'karon inaron 'ne ro Tamusi ety awonganamon iporo Tamusi ety awongata'ton a'kanano ta. Erome ro moro wara terapa kynaijaton. Mo'kopangon 'se ro irombo mo'ko jumynano man toty awonganamon me. ");
INSERT INTO car_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","A'kanano mo'ko Tamusi man. Iporo ro mo'karon ety awonganamon 'wa ety awongary man a'kanano ta.” ");
INSERT INTO car_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Mo'ko woryi wyka'po I'wa: “Suku'sa mo'ko Mesias, mo'ko Kristus me inejatorykon wopyry man. Mo'ko ro tywopy'po mero pa'poro oty ekari'tan na'na 'wa.” ");
INSERT INTO car_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesus wyka'po i'wa: “Inoro ro ajerupanon. Inoro ro awu wa.” ");
INSERT INTO car_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Moro jako 'ne mo'karon inemeparykon tunda'san. Woryi maro iworupary poko enuta'san imero. Ise'me amy pairo we'i'po aturupo'pa i'wa oty 'se iwairy poko, o'tono'me mo'ko woryi maro iworupary poko pai. ");
INSERT INTO car_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Irombo mo'ko woryi 'wa moro typotysarymbo no'po. Moro aitopo taka ito'po. Ika'po mo'karon kari'na 'wa: ");
INSERT INTO car_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“O'toko 'ne amy wokyry ene. Pa'poro o'to ywe'i'po ekarityi y'wa. Mo'ko Mesias pai 'nare mo'ko nan?” ");
INSERT INTO car_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Irombo moro aitopo wyino iwepa'ka'san mo'ko wokyry ene. ");
INSERT INTO car_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","A'saka'pa imaro tywe'i'san mero mo'karon inemeparykon wyka'san Jesus 'wa: “Na'na emepanen, endameko.” ");
INSERT INTO car_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ika'po te i'waine: “Anukuty'torykon arepa yjekosa man.” ");
INSERT INTO car_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mo'karon inemeparykon wyka'san ase'wa: “Amy 'wa ka'tu arepa tane'se nan i'wa?” ");
INSERT INTO car_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesus wyka'po i'waine: “Moro y'wa mo'ko yjemo'nenymbo nisanory kapyry, moro y'wa inyry amaminano kapy'mary enapa yjerepary me man. ");
INSERT INTO car_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ero wara yka'pa mandon: ‘Okupa'en nuno pa'po me wonatopo potyry kynaitan.’? Wykaje o'waine, o'po'toko! Morokon maina enetoko! Wonatopo tywaije terapa man. Typotyry taro terapa man. ");
INSERT INTO car_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Mo'ko ipo'nenymbo moro tamamina'po epety apyijan terapa. Morokon tynipoty'san a'nano'san i'matypyn amano 'wanokon me. Iwara okororo mo'ko iponen mo'ko ipo'nen maro kynewa'potata'ton. ");
INSERT INTO car_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Iporo ro irombo ero taurotopo man: ‘O'win amy kyniponjan. O'win amy kynipo'san.’ ");
INSERT INTO car_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Awu komo'ton awo'mika'torykonymbo po'se. Amykon terapa tywo'mika mandon. Iwo'mika'marykon 'wa terapa amyjaron tywo'se mandon amamina.” ");
INSERT INTO car_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Pyime moro Samaria tano aitopo ponokon 'wa Jesus amyikapo'po ero wara mo'ko woryi wykary 'wa: “Pa'poro o'to ywe'i'po ekarityi y'wa.” ");
INSERT INTO car_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","I'wa tytunda'san mero, mo'karon Samaria ponokon woturupo'san, tokosaine iwaito'me. Irombo oko kurita ekosaine iwe'i'po. ");
INSERT INTO car_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Pyime noro kari'na 'wa amyika'po moro inekarityry poko. ");
INSERT INTO car_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Irombo mo'ko woryi 'wa ika'san: “Moro anekarityry poko noro kapyn na'na kynamyikanon. Aseke ro irombo na'na netai. Iporo ro ero nono Epano'nen me iwairy ukutyi na'na.” ");
INSERT INTO car_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Oko kurita pa'po me Jesus wyto'po moro wyino Galilea 'wa. ");
INSERT INTO car_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Aseke i'wa takari'se kynakon amy pairo Tamusi auran uku'ponen wairy isano'pambo moro tywetuwaro'matopombo aitopo po. ");
INSERT INTO car_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea 'wa itunda'po mero, mo'karon moro ponokon 'wa ewa'ma'po. Moro Jerusalem po mo'ko eratonomapotopombo onory ewa'mary jako irombo morokon inikapyry otykon tone i'waine kynakon. Mo'karon enapa irombo tyto tywaije kynatokon mo'ko eratonomapotopombo onory ewa'ma. ");
INSERT INTO car_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesus wyto'po rapa Kana 'wa, Galilea ta, moro ty'wa winu me tuna ka'topombo aitopo 'wa. Irombo Kafaraum po amy jopoto kynakon. Imuru je'tun pe kynakon. ");
INSERT INTO car_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Mo'ko ijumy 'wa ro Judea wyino Galilea 'wa Jesus tunda'po eta'po. Ito'po I'wa. Iwoturupo'po i'wa tymuru kura'ma iwo'pemato'me tymaro Kafaraum 'wa. Kyniromo'sakon irombo mo'ko imuru. ");
INSERT INTO car_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesus wyka'po i'wa: “Potonon anumengaponamon otykon anene'pa aja'taine, poto me Tamusi anamyika'pa mandon.” ");
INSERT INTO car_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Mo'ko jopoto wyka'po te I'wa: “Jopoto, o'ko ymaro, ymuru romby'pa ro.” ");
INSERT INTO car_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesus wyka'po i'wa: “I'tango ajauty 'wa. Omuru nuro man.” Mo'ko wokyry 'wa Jesus auran amyika'po. Ito'po. ");
INSERT INTO car_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Iwo'pemary jako noro mo'karon ipyitorykon wopy'san epoje. Ika'san i'wa: “Omuru nuro man.” ");
INSERT INTO car_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Iwoturupo'po i'waine moro o'toro juru a'ta iru'pa rapa iwe'i'po poko. Ika'san i'wa: “Koinaro o'win juru a'ta, moro ikomyinymbo no'myi.” ");
INSERT INTO car_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Moro wara ijururu a'ta ro Jesus 'wa nuro tymuru wairy ekarity'po ukuty'po mo'ko ijumy 'wa. Irombo mo'ko Jesus amyika'po i'wa pa'poro mo'karon tauty tanokon maro. ");
INSERT INTO car_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ero moro ijokonory Jesus nenepo'po kapu wyinono oty ero kynakon Galilea po, Judea wyino tywerama'po wyino. ");
INSERT INTO car_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Morombo wyino Simosu 'wa amy oty ewa'mary kynakon. Moro me ro Jesus wonuku'po Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Moro Jerusalem po ro moro kapara penary pato amy ekupitopo man. Simosu auran ta Betsata me kynejatojaton. Moro po ro ainatone pataja man. ");
INSERT INTO car_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Morokon ta ro pyime je'tun pangon kynatokon: enu'non, iwajakuta'san, a'pota'san enapa. ");
INSERT INTO car_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Irombo amy wokyry moro po kynakon. O'win-kari'na itu'ponaka ainapatoro itu'ponaka oruwa-to'ima siriko terapa je'tun pe kynakon. ");
INSERT INTO car_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Mo'ko wotunga'po ene'po ro Jesus 'wa. Akore'pe terapa je'tun pe iwairy ukuty'po ke ty'wa, ika'po i'wa: “Awekura'mary 'se man?” ");
INSERT INTO car_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Mo'ko je'tun pan 'wa ejuku'po: “Jopoto, moro tuna wesakama'poto, amy yjemanen waty man moro ekupitopo taka. Moro tuna 'wa ywytory jako amy terapa itaka kynomanon yjuwaporo.” ");
INSERT INTO car_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesus wyka'po i'wa: “Ajawongo. Moro apaty anungo. I'tango.” ");
INSERT INTO car_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","O'win wytory mo'ko wokyry wekura'ma'po. Moro typaty anumy'po i'wa. Ito'po. Otare'matopo kurita te moro oty wo'kapy'po. ");
INSERT INTO car_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Iro ke ro mo'ko ekura'ma'po 'wa mo'karon Simosu jopotorykon wyka'san: “Erome otare'matopo kurita man. Moro apaty arory kapyn o'wa man.” ");
INSERT INTO car_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ejuku'san te i'wa: “Mo'ko ykura'manenymbo te nykai y'wa: ‘Moro apaty anungo. Itango.’ ” ");
INSERT INTO car_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Iwoturupo'san i'wa: “Noky ko moro wara nykai o'wa: ‘Anungo. Itango.’?” ");
INSERT INTO car_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Anukuty'pa te mo'ko ekura'ma'po kynakon, Jesus wyto'po ke ko'i imero mo'karon ata'nanopy'san apyimy taka. ");
INSERT INTO car_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Morombo wyino te epory'po rapa Jesus 'wa moro Tamusi auty ta. Irombo Jesus wyka'po i'wa: “Eneko. Tywekura'ma mana. Kyteja'wangai noro. Ka'pa rapa amy yja'wan oty 'wa 'ne ka'tu rapa ajepory!” ");
INSERT INTO car_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Irombo mo'ko wokyry wyto'po. Mo'ko tykura'manenymbo me Jesus wairy ekarity'po i'wa mo'karon Simosu jopotorykon 'wa. ");
INSERT INTO car_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Iro ke ro mo'karon Simosu jopotorykon erekuru 'wa Jesus wekenatopo kynakon, moropangon otykon kapyry ke i'wa otare'matopo kurita. ");
INSERT INTO car_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ejuku'san te Jesus 'wa: “Mo'ko yjumy kynaijan roten tamaminary poko. Awu enapa.” ");
INSERT INTO car_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Iro ke ro iwory 'se 'ne ka'tu rapa mo'karon Simosu jopotorykon kynatokon. Moro otare'matopo kurita jamikakon roten kapyn. Tyjumy me te mo'ko Tamusi ejatojakon enapa. Iwara te Tamusi maro asewara kynokari'sakon. ");
INSERT INTO car_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesus wyka'po eju'to'ko'me: “Ita'ro pore, amy pairo oty kapyry upijan aseke mo'ko ymunano, mo'ko tyjumy 'wa ikapyry anene'pa ta'ta. Pa'poro mo'ko nikapyry ka'san ro irombo mo'ko ymunano enapa. ");
INSERT INTO car_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tymuru pynanon mo'ko jumynano. Pa'poro tynikapyry otykon enepojan i'wa. Potonon 'ne ka'tu rapa otykon enepotan i'wa, poto me ajenutato'ko'me. ");
INSERT INTO car_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mo'ko jumynano 'wa mo'karon iromby'san awongary wara, nuro i'wa yrykon wara enapa mo'ko ymunano tynisanorykonymbo ro yjan nuro. ");
INSERT INTO car_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Mo'ko jumynano amy pairo kari'na poko a'wembono auranano anyry'pa man. Mo'ko ymunano ainaka te pa'poro moro a'wembono auranano yry tyje i'wa man, ");
INSERT INTO car_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","pa'poro kari'na 'wa mo'ko ymunano ety awongato'me mo'ko jumynano ety awongary wara enapa i'waine. Mo'ko ymunano ety anawongapyn mo'ko emo'nenymbo jumynano ety anawonga'pa enapa man. ");
INSERT INTO car_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ita'ro pore, mo'ko yjauran etanen ekosa, mo'ko yjemo'nenymbo amyikanen ekosa enapa i'matypyn amano man. Ipoko a'wembono auranano yry'pa kynaitan. Romo'no wyino tyto man amano taka. ");
INSERT INTO car_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ita'ro pore, amy jako mo'karon iromby'san mo'ko Tamusi ymuru auran etata'ton. Eromembo roten moro wara kynaitan. Mo'karon i'wa epanama'san nuro kynaita'ton. ");
INSERT INTO car_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mo'ko jumynano amano undy me man. Iwara enapa mo'ko tymuru amano undy me tyje i'wa man. ");
INSERT INTO car_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Mo'ko tymuru ainaka moro a'wembono auranano yry tyje i'wa man, kari'na ymuru me iwairy ke. ");
INSERT INTO car_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ero ajenumengapo'paine nainen: Amy jako auran etata'ton mo'karon tu'munano ta aitonon. ");
INSERT INTO car_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Irombo kynepa'kata'ton. Mo'karon iru'pyngon otykon ka'namonymbo kynawonda'ton nuro tywaito'ko'me. Mo'karon yja'wangon otykon ka'namonymbo kynawonda'ton moro a'wembono auranano apyito'me ty'waine. ");
INSERT INTO car_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Amy pairo oty kapyry supija aseke. Yneta'po wara ro a'wembono auranano syja. Moro ynyry a'wembono auranano iporo man. Aseke ynisanory kapyn supija, mo'ko yjemo'nenymbo nisanory te. ");
INSERT INTO car_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Aseke ypoko oty amyikapory jako y'wa, moro y'wa oty amyikapory iporo waty man. ");
INSERT INTO car_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Amy terapa te ypoko oty amyikapojan. Suku'sa iporo moro ypoko inamyikapory wairy. ");
INSERT INTO car_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ajapojongon tomo'se o'waine mandon Johanes 'wa. Mo'ko 'wa ro iporonokon otykon tamyikapo man. ");
INSERT INTO car_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Awu te kari'na namyikapory 'wa opano'po'pa wa. Ajepano'to'ko'me roten moro wara wykaje. ");
INSERT INTO car_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Mo'ko ro moro tyka'muren, taweijen kororeta me kynakon. Amyjaron ko'i roten tawa'pore awairykon 'se tywaije mandon aweiry ta. ");
INSERT INTO car_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Yjekosa te amy Johanes namyikapory ko'pono oty man. Morokon jumynano nyry'san ynikapyry man amaminano, morokon aseke ynikapyry enapa amaminano moro jumynano 'wa yjemoky'po amyikapojan. ");
INSERT INTO car_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Mo'ko yjemo'nenymbo jumynano 'wa ypoko oty tamyikapo man. Amy jako pairo auran aneta'pa tywaije mandon. Amy jako pairo anene'pa tywaije mandon. ");
INSERT INTO car_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Moro auranymbo anapo'i'pa mandon aturu'san ta. Mo'ko inemoky'po anamyika'pa irombo mandon. ");
INSERT INTO car_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Morokon kareta mimengaton. Moro i'matypyn amano epory irombo mekano'saton itaine. Ypoko te oty amyikapojaton. ");
INSERT INTO car_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ise'me y'wa awopyrykon 'se'pa mandon, amano epoto'me o'waine. ");
INSERT INTO car_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Kari'na 'wa yjety awongary anupi'pa wa. ");
INSERT INTO car_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Suku'sa te moro Tamusi pyny wairy e'i'pa otaine. ");
INSERT INTO car_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Awu mo'ko yjumy ety ta wopyi. Yjewa'ma'pa te mandon. Aseke toty ta amy terapa wopy'poto, mewa'mata'ton mo'ko. ");
INSERT INTO car_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","One wara ko kamyikata'ton? Ase'wa irombo ajetykon mawongaton. Mo'ko o'win'kono Tamusi 'wa ajetykon awongary anupi'pa te mandon. ");
INSERT INTO car_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Y'wa ajemendorykon kysekano'ton mo'ko jumynano ekosa. Moses, mo'ko ipoko amyjaron mo'po'saton inoro ajemendonamon me man. ");
INSERT INTO car_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses amyikary jako rypo irombo o'waine, kamyikatory. Ypoko irombo mo'ko 'wa oty tymero man. ");
INSERT INTO car_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mo'ko nimero'san anamyika'pa aja'taine, one wara ko yjauran mamyikata'ton?” ");
INSERT INTO car_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Morombo wyino Jesus 'wa moro Galilea tano tuna juwembory, moro Tiberias pono tuna juwembory me enapa kynejatojaton iro pato'po. ");
INSERT INTO car_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kari'na apyimy tam'po'kory 'wa iwekena'po. Morokon je'tun pangon poko inikapyry kapu wyinonokon otykon irombo tone i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Wypy tu'ponaka Jesus wonuku'po. Moro po ro iwotandy'mo'po mo'karon tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mo'karon Simosu 'wa eratonomapotopombo onory ewa'mary tyse waty kynakon. ");
INSERT INTO car_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesus wo'poty'po. Kari'na apyimy tam'po'kory wopyry ene'po mero ty'wa typato, Filipus 'wa ika'po: “Oje ko perere kysepeka'ta'ton iwendameto'ko'me?” ");
INSERT INTO car_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","U'kuto'me te moro wara ika'po. Aseke irombo moro o'to tywairy man uku'sakon. ");
INSERT INTO car_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipus wyka'po eju'to'me: “Ainapatoro-kari'na amu'nykonymbo pyrata poko perere epekaty'poto ro rypo, pa'poro iwaraine e'i'pa kynaitan. A'si'ko pairo tywendamerykon upita'ton.” ");
INSERT INTO car_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","O'win amy inemepary, mo'ko Simon Petrus piry Andreas wyka'po I'wa: ");
INSERT INTO car_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Amy myre'ko'ko ero po man. Mo'ko ekosa ro ainatone perere man oko woto maro. O'to ko moro mo'karon mokynokon kari'na ytan?” ");
INSERT INTO car_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jesus wyka'po: “Mo'karon kari'na andy'mopotoko.” Itupu pyime kynakon moro po. Mo'karon kari'na wotandy'mo'san. Ainatone dusun iwairy taro mo'karon wokyry kynatokon. ");
INSERT INTO car_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesus 'wa morokon perere apo'i'san. Tamusi ety awonga'po mero, aripa'po'san i'wa mo'karon moro po atandy'mo'san kari'na ainaka. Iwara enapa mo'karon woto aripa'po'san i'wa, i'se iwairykon taro ro. ");
INSERT INTO car_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Iwaime'san mero mo'karon tynemeparykon 'wa ika'po: “Morokon arepa akosinykonymbo amo'i'toko, amy pairo waito'me atakama'pa.” ");
INSERT INTO car_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mo'karon endametonon nino'san ainatonenokon perere y'sakapoty'san akosinykonymbo amo'iky'san i'waine ainapatoro itu'ponaka oko kurukuru. ");
INSERT INTO car_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jesus 'wa amy kapu wyinono oty kapy'po ene'po mero ty'waine, ika'san: “Iporo ro mo'ko nono tu'ponaka o'toto manombo Tamusi auran uku'ponen mo'se man.” ");
INSERT INTO car_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jopoto me tyto'me tapyije tywopyrykon 'se iwairykon ukuty'po Jesus 'wa. Iro ke ro iwomima'po rapa iwyinoine morokon wypy 'wa, o'win upu'po tywaito'me. ");
INSERT INTO car_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Iko'mamyry mero mo'karon inemeparykon wo'pema'san moro tuna 'wa. ");
INSERT INTO car_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kurijara taka iwotaru'ka'san Kafaraum 'wa tywepatoto'ko'me. Ewa'rumamy'po po Jesus opy'pa noro i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Pepeito tam'po'kory 'wa parana awonga'po. ");
INSERT INTO car_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","O'win-kari'na itu'ponaka ainatone stadion mosin po terapa tywotarima'san mero, moro tuna tu'po Jesus wytory ene'po i'waine moro kurijara wyino tyse waty. Iwety'ka'san. ");
INSERT INTO car_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesus wyka'po te i'waine: “Awu te wa. Kytety'katon.” ");
INSERT INTO car_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Aru'kapory 'se kynatokon. O'win wytory te moro kurijara tunda'po moro itoto'kon 'wa. ");
INSERT INTO car_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Irombo koro'po mo'karon kari'na apyimy moro tuna kopose me noro kynakon. O'win roten kurijara wairy moro po, moro kurijara taka ataru'ka'pa Jesus wairy, a'saka'pa mo'karon inemeparykon wytory enapa tone i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tiberias wyino te amykon kurijara tywo'se kynatokon. Senge roten kynatokon mo'ko Jopoto 'wa Tamusi ety awongatopombo wyino, moro iwendameto'konymbo wyino. ");
INSERT INTO car_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Uwa moro po Jesus wairy, uwa enapa mo'karon inemeparykon wairy ene'po mero ty'waine, iwotaru'ka'san morokon kurijara taka. Kafaraum 'wa ito'san Jesus upi. ");
INSERT INTO car_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Moro tuna kopose me epory'po mero ty'waine, ika'san I'wa: “Amepanen, one wara a'ta ko ijaro 'wa mopyi?” ");
INSERT INTO car_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesus wyka'po eju'to'ko'me: “Ita'ro pore, kapu wyinonokon otykon ene'san poko kapyn o'waine kupijaton, moro awendame'san poko te, moro awaime'san poko enapa. ");
INSERT INTO car_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Moro atany'matoto man arepa poko kyto'mikaton. Moro aitoto man roten arepa poko te o'mikatoko. Moro ytan ro o'waine mo'ko kari'na ymuru. Mo'ko wyino ro mo'ko jumynano Tamusi tywokari'se man.” ");
INSERT INTO car_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Irombo ika'san I'wa: “O'to ko na'na naitan morokon Tamusi emamingon ka'to'me ty'wa?” ");
INSERT INTO car_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesus wyka'po eju'to'ko'me: “Ero moro Tamusi emamin: moro o'waine mo'ko inemoky'po amyikary.” ");
INSERT INTO car_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ika'san I'wa: “Otypan kapu wyinono oty ko menepotan, na'na 'wa ajamyikato'me ene'po mero? Otypan oty ko mika'tan? ");
INSERT INTO car_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mo'karon kytangonymbo 'wa moro Tamusi nyry arepa tana'se man moro iponomyn wo'i ta, ero imero'po wara: Kapu wyinono arepa ke tupa tywaije i'wa mandon.” ");
INSERT INTO car_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Irombo Jesus wyka'po i'waine: “Ita'ro pore, Moses 'wa kapyn tupa mandon moro kapu wyinono arepa ke. Mo'ko yjumy te ajupaton moro iro 'nero kapu wyinono arepa ke. ");
INSERT INTO car_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Moro Tamusi wyinono arepa moro kapu wyino kyony'tojan iro, moro nono 'wa amano ynen moro man.” ");
INSERT INTO car_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Irombo ika'san I'wa: “Jopoto, moro arepa yko na'na 'wa o'kapyn roten.” ");
INSERT INTO car_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesus wyka'po i'waine: “Moro amano ynen arepa awu wa. Mo'ko y'wa o'toto aniwo'pa noro ikumyry kynaitan. Mo'ko yjamyikanen aniwo'pa noro tuna sanory kynaitan. ");
INSERT INTO car_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Wykai terapa te o'waine: moro o'waine yjene'po se'me yjamyika'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Pa'poro y'wa mo'ko jumynano nyry kyno'tan y'wa. Amy pairo y'wa o'toto animoma'pa waitake. ");
INSERT INTO car_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kapu wyino tywony'to wa aseke ynisanory ka'se kapyn, mo'ko yjemo'nenymbo nisanory ka'se te. ");
INSERT INTO car_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ero mo'ko yjemo'nenymbo nisanory: mo'ko y'wa inyry anuta'ka'pa ywairy man, awongary te man moro irombo ro kurita. ");
INSERT INTO car_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ero irombo mo'ko yjumy nisanory: mo'ko ymunano ene'po wyino amyikanen 'wa i'matypyn amano apyiry man. Y'wa awongary enapa man moro irombo ro kurita.” ");
INSERT INTO car_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Mo'karon Simosu eruwa'san moro ero wara ika'po poko: “Moro kapu wyino ony'to'po arepa awu wa.” ");
INSERT INTO car_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ika'san: “Jesus kapyn mo'ko nan, mo'ko Josef ymuru, mo'ko ijumy, isano kysuku'saton inoro? One wara ko iro ke erome nykanon ‘Kapu wyino tywony'to wa.’?” ");
INSERT INTO car_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesus wyka'po eju'to'ko'me: “Ase'wa ajeruwaton. ");
INSERT INTO car_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Amy pairo y'wa tywopyry upijan, tytynga'pa mo'ko yjemo'nenymbo jumynano a'ta, moro irombo ro kurita ynawongary man me. ");
INSERT INTO car_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mo'karon Tamusi auran uku'ponamonymbo karetary ta tymero man: Pa'poro Tamusi 'wa tamepa kynaita'ton. Pa'poro mo'ko jumynano 'wa tywepanamary ta omepa'po y'wa kyno'san. ");
INSERT INTO car_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Amy pairo 'wa te Tamusi ene'po anekarity'pa wa. Mo'ko Tamusi wyino opy'po 'wa roten mo'ko jumynano tone man. ");
INSERT INTO car_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","“Ita'ro pore, mo'ko Tamusi amyikanen ekosa i'matypyn amano man. ");
INSERT INTO car_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Moro amano ynen arepa awu wa. ");
INSERT INTO car_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mo'karon atangonymbo 'wa moro Tamusi nyry arepa moro iponomyn wo'i ta tana'se man. Tyromo'se te mandon. ");
INSERT INTO car_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mo'ko kapu wyino ony'tototo arepa ena'nen te iromby'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Moro kapu wyino ony'to'po nurono arepa awu wa. Amy 'wa ero arepa enapy'poto, nuro kynaitan i'matypyn me. Moro ynyry man arepa, ypunu moro man. Nuro nono yto'me man.” ");
INSERT INTO car_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Morombo mero mo'karon Simosu wosauranaka'san ase'wa. Ika'san: “One wara ko mo'ko wokyry moro typunu ytan ky'waine onoto'me?” ");
INSERT INTO car_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Irombo Jesus wyka'po i'waine: “Ita'ro pore, mo'ko kari'na ymuru punu anono'pa aja'taine, moro imynuru anenyry'pa aja'taine enapa, amano waty man otaine. ");
INSERT INTO car_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Mo'ko ypunu ononen, mo'ko ymynuru enynen ekosa i'matypyn amano man. Mo'ko ro sawongatake moro irombo ro kurita. ");
INSERT INTO car_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Moro ypunu, arepa 'nero moro man. Moro ymynuru, woku 'nero moro man. ");
INSERT INTO car_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Mo'ko ypunu ononen, mo'ko ymynuru enynen yta man mo'ja ro. Awu enapa mo'ko ta wa mo'ja ro. ");
INSERT INTO car_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mo'ko nurono jumynano 'wa tomo'se wa. Mo'ko upu'po me ro nuro wa. Iwara enapa mo'ko yjononen nuro kynaitan yjupu'po me. ");
INSERT INTO car_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Moro kapu wyino ony'to'po arepa ero man. Mo'karon atangonymbo nenapy'san arepa wara kapyn man. Tyromo'se irombo mandon. Mo'ko ero arepa ena'nen te nuro kynaitan i'matypyn me roten.” ");
INSERT INTO car_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Moro wara Jesus wyka'po mo'karon kari'na emepary jako moro Kafaraum po moro iwota'nano'to'kon auto ta. ");
INSERT INTO car_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Moro wara ikary eta'po mero ty'waine, pyime inemeparykon wyka'san: “Moro auranano apyiry je'tun pe man. Noky ko etary taro nan?” ");
INSERT INTO car_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Moro tauranymbo poko mo'karon tynemeparykon eruwary ukuty'po mero ty'wa, Jesus wyka'po i'waine: “Moro yjauran mije'tumaton? ");
INSERT INTO car_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","One wara ko iro ke monumengatory, mo'ko kari'na ymuru wonukuru ene'poto o'waine moro uwapo tywaitopombo 'wa? ");
INSERT INTO car_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mo'ko a'kanano nuro kari'na yjan. Moro ja'munano otymbo ro anyry'pa man. Morokon o'waine ywykato'konymbo auranano, a'kanano morokon man. Amano morokon man. ");
INSERT INTO car_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amykon te Tamusi anamyika'pa mandon ara'naine.” Penaro ro irombo Tamusi anamyika'pa nokypangon wairy, nokypan 'wa enapa takaramary man uku'sakon Jesus. ");
INSERT INTO car_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Irombo ika'po: “Iro ke ro wykai o'waine: Amy pairo y'wa tywopyry upijan, oma anyry'pa ty'wa mo'ko jumynano we'i'poto.” ");
INSERT INTO car_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Moro poko ro pyime inemeparykon wotu'ma'san iwyino. Imaro noro ito'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Irombo mo'karon ainapatoro itu'ponaka okonokon 'wa Jesus wyka'po: “Amyjaron enapa ka'tu ynory 'se mandon?” ");
INSERT INTO car_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Mo'ko Simon Petrus wyka'po te eju'to'me: “Jopoto, noky 'wa ko na'na nytory? I'matypyn amano ynen auranano ajekosa man. ");
INSERT INTO car_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Amoro 'ne mo'ko Tamusi wyinono me awairy uku'san na'na. Moro amyikanon ro na'na.” ");
INSERT INTO car_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesus wyka'po eju'to'ko'me: “Ainapatoro itu'ponaka okonokonymbo mero 'kare ajapo'i'paine wainen. Ise'me te o'win amy ara'nanokon ewa'rumy me man.” ");
INSERT INTO car_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mo'ko Simon Iskariot ymuru Judas poko aurana'po moro kynakon. Mo'ko 'wa ro irombo Jesus ekaramary kynakon. Mo'karon ainapatoro itu'ponaka okonokon ra'nano amy mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Morombo mero Jesus wytopoty'po Galilea po. Judea 'wa irombo tytory 'se'pa kynakon, tywory 'se mo'karon Simosu jopotorykon wairy ke. ");
INSERT INTO car_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Tyse waty morokon pataja ewa'mary kynakon mo'karon Simosu 'wa. ");
INSERT INTO car_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Irombo mo'karon Jesus piryjan wyka'san I'wa: “Ero wyino omimako. Judea 'wa i'tango. Iwara mo'karon anemeparykon morokon anikapyry amaminano eneta'ton. ");
INSERT INTO car_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Amy pairo ekapyn ta o'to e'i'pa man, takare tywairy 'se ta'ta. Moropangon otykon kapyry jako o'wa, onepoko pa'poro kari'na 'wa.” ");
INSERT INTO car_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mo'karon ipiryjan enapa irombo anamyika'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus wyka'po i'waine: “Moro ywytotopo jururu itunda'pa noro man. Amyjaron te o'kapyn roten awytorykon taro mandon. ");
INSERT INTO car_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ero nono ajenonopyrykon upijan. Awu te yjenono'san. Yja'wan me irombo morokon emamin wairy samyikapoja. ");
INSERT INTO car_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amyjaron anu'toko moro oty ewa'matopo 'wa. Awu moro 'wa anuku'pa wa, itunda'pa noro moro ywytotopo jururu wairy ke.” ");
INSERT INTO car_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Moro wara tyka'po mero, Galilea po iwainopo'po. ");
INSERT INTO car_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Moro oty ewa'matopo 'wa mo'karon typiryjan wonuku'san mero te, Jesus wonuku'po enapa, tone me kapyn, ekapyn ta te. ");
INSERT INTO car_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Moro oty ewa'matopo po mo'karon Simosu kynupijatokon. Kyngatokon: “Oje ko nan?” ");
INSERT INTO car_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ipoko taurane kynatokon mo'karon kari'na apyimykon. Amykonymbo iru'pa kynekari'satokon. Amykonymbo te kyngatokon: “Uwa. Mo'karon kari'na emu'manon.” ");
INSERT INTO car_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amy pairo te enari'ma aurana'pa ipoko kynakon. Mo'karon Simosu jopotorykon pona irombo tanarike mo'karon kari'na kynatokon. ");
INSERT INTO car_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ase'ra moro oty ewa'mary a'ta, Jesus wonuku'po moro Tamusi auty 'wa, kari'na emepa. ");
INSERT INTO car_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mo'karon Simosu enuta'san imero. Ika'san: “One wara ko mo'se kareta uku'san, emepa'pa tywe'i'po se'me?” ");
INSERT INTO car_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesus wyka'po eju'to'ko'me: “Moro ynyry omepano ywyino kapyn kyno'san, mo'ko yjemo'nenymbo wyino te. ");
INSERT INTO car_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mo'ko nisanory kapyry 'se amy a'ta, Tamusi wyino moro omepano wopyry, aseke ywykatopo me iwairy pai uku'tan. ");
INSERT INTO car_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Mo'ko aseke tywyino oty pa'kanen aseke toty awongary 'se man. Mo'ko tomo'nenymbo ety awongary poko o'mikatoto iporo man. Mo'ko emambo'pa e'i'pa man. ");
INSERT INTO car_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Moses moro omenano karetary anyry'pa o'waine tywaije nan? Amy pairo ara'nanokon te moro omenano anapo'i'pa man. O'tono'me ko ywory poko mo'mikaton?” ");
INSERT INTO car_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mo'karon kari'na apyimy 'wa ejuku'po: “Ewa'rumy otu'po man. Noky ko awory poko no'mikanon?” ");
INSERT INTO car_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesus wyka'po eju'to'ko'me: “O'win amy amaminano sikapyi. Irombo ajenutaton imero. ");
INSERT INTO car_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iro ke ro wykaje: Moses 'wa o'wanokon me moro e'kotono tyje man. Mo'ko Moses wyino kapyn te kyno'san moro e'kotono, mo'karon atangonymbo wyino te. Otare'matopo kurita enapa kari'na mi'kotopojaton. ");
INSERT INTO car_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Amboty'pa moro Moses nimero'po omenano waito'me otare'matopo kurita enapa kari'na mi'kotopojaton. O'tono'me ko iro ke ypoko tare'ke mandon, o'win amy kari'na kura'ma'po ke imero y'wa moro otare'matopo kurita? ");
INSERT INTO car_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Itu'pono oty poko roten a'wembono auranano kysyton. Iporo te moro a'wembono auranano ytoko.” ");
INSERT INTO car_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Irombo amykon Jerusalem ponokon wyka'san: “Mo'ko iwory poko kyno'mikaton inoro kapyn mo'ko nan? ");
INSERT INTO car_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Eneko te. Enari'ma imero kynaurananon. O'to pairo yka'pa mandon i'wa. Mo'karon jopoto 'wa pai 'nare iporo Mesias me iwairy tuku'se na. ");
INSERT INTO car_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ojeno me mo'ko wairy te kysuku'saton. Mo'ko Mesias wopyry jako te amy pairo moro ojeno me iwairy anukuty'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Irombo Jesus ko'ta'po moro kari'na emepary jako. Ika'po: “Kuku'saton. Ojeno me ywairy enapa muku'saton. Aseke ywonumengary me opy'pa tywaije wa. Amy iporono 'wa te tomo'se wa. Mo'ko anukuty'pa te amyjaron mandon. ");
INSERT INTO car_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Awu suku'sa. Mo'ko wyino irombo tywo'se wa. Mo'ko 'wa enapa tomo'se wa.” ");
INSERT INTO car_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Irombo apyiry 'se iwe'i'san. Amy pairo we'i'po te anapo'i'pa. Moro apyitopo jururu irombo itunda'pa noro kynakon. ");
INSERT INTO car_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pyime kari'na 'wa te amyika'po. Ika'san: “Mo'ko wokyry nenepo'san kapu wyinonokon otykon ko'po 'kare pyime kapu wyinonokon otykon enepotan mo'ko Mesias, tywopy'poto.” ");
INSERT INTO car_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Moro wara Jesus poko mo'karon kari'na auranary eta'po mo'karon Farise 'wa. Irombo mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Farise 'wa enapa Tamusi auty erangon emoky'san apyije. ");
INSERT INTO car_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Irombo Jesus wyka'po: “A'si'ko noro ajekosaine wa. Morombo mero wy'take mo'ko yjemo'nenymbo 'wa. ");
INSERT INTO car_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kupita'ton. Yjepory'pa te maita'ton. Moro ywytotopo 'wa awopyrykon mupita'ton.” ");
INSERT INTO car_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Irombo mo'karon Simosu wyka'san ase'wa: “Oja ko ny'tan, epory upito'me ky'waine? Mo'karon Griek waito'kon 'wa ka'tu ny'tan mo'karon moro ponokon Simosu emepa? ");
INSERT INTO car_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","O'to tauro'po ko moro ikatopo nan, moro ‘Kupita'ton. Yjepory'pa te maita'ton. Moro ywytotopo 'wa awopyrykon mupita'ton.’?” ");
INSERT INTO car_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Moro irombo ro iro 'nero oty ewa'matopo kurita Jesus ko'ta'po pyre. Ika'po: “Tuna sanory 'wa amy wory jako, y'wa no'nen tuna enyje. ");
INSERT INTO car_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mo'ko yjamyikanen turu'po wyino amano ynamon tuna kynapeinatan, moro Tamusi karetary wykary wara ro.” ");
INSERT INTO car_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Mo'ko a'kanano poko ika'po moro kynakon. Mo'ko apyiry man ro kynakon mo'karon amyikanamonymbo 'wa. Opy'pa na'nen mo'ko a'kanano kynakon. Awonga'pa na'nen irombo Jesus kynakon. ");
INSERT INTO car_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Amykonymbo moro wara ikary etanamonymbo wyka'san: “Iporo ro mo'ko Tamusi auran uku'ponen mo'ko man.” ");
INSERT INTO car_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Amykonymbo wyka'san rapa: “Mo'ko Mesias mo'ko man.” Amykonymbo wyka'san rapa: “Galilea wyino 'kare mo'ko Mesias no'san. ");
INSERT INTO car_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Yka'pa 'kare moro Tamusi karetary nan: ‘David parymbo mo'ko Mesias kynaitan. Moro David waitopombo Betlehem wyino kyno'tan.’ ” ");
INSERT INTO car_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","O'win e'i'pa moro aurangon kynakon ipoko. ");
INSERT INTO car_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Amykonymbo apyiry 'se kynatokon. Amy pairo we'i'po te anapo'i'pa. ");
INSERT INTO car_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Mo'karon Tamusi auty erangon werama'san mero, mo'karon Tamusi pokonokon jopotorykon woturupo'san, mo'karon Farise woturupo'san enapa i'waine: “O'tono'me ko anenepy'pa maiton?” ");
INSERT INTO car_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mo'karon Tamusi auty erangon wyka'san eju'to'ko'me: “Mo'ko auranary wara amy pairo kari'na aurana'pa tywaije man.” ");
INSERT INTO car_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Mo'karon Farise wyka'san eju'to'ko'me: “Amyjaron enapa ka'tu ajemu'maton? ");
INSERT INTO car_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Amy Simosu jopotory 'wa 'kare, amy Farise 'wa enapa 'kare tamyika nan. ");
INSERT INTO car_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Mo'karon omenano mero'po anukuty'non kari'na apyimy te tywotany'ma man.” ");
INSERT INTO car_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Irombo mo'ko Nikodemus, mo'ko uwapo Jesus ene opy'po Farise wyka'po mo'karon ta'sakarykon 'wa: ");
INSERT INTO car_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Moro omenano mero'po 'kare a'wembono auranano yjan kari'na poko, moro auran etary uwaporo, moro o'to 'ne iwe'i'po ukutyry uwaporo.” ");
INSERT INTO car_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ika'san eju'to'me: “Amoro enapa ka'tu Galilea pono me man? Moro Tamusi karetary tyre imengako. Galilea wyino Tamusi auran uku'ponen opy'pa man.” ");
INSERT INTO car_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Irombo mero pa'poro rapa ito'san tautykon 'wa. ");
INSERT INTO car_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesus wyto'po te moro oleif paty wypy 'wa. ");
INSERT INTO car_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Irombo kokoro moro Tamusi auty 'wa rapa Jesus wopy'po. Pa'poro mo'karon kari'na kyno'satokon I'wa. Tywotandy'mo'po mero kynemepatokon. ");
INSERT INTO car_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Mo'karon Tamusi karetary uku'namon 'wa te, mo'karon Farise 'wa enapa amy woryi aro'po I'wa. I'wa taporitonone aino any'marymbo tapyije i'waine kynakon. Mo'ko woryi yry'po ro i'waine owarira'na. ");
INSERT INTO car_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Irombo ika'san Jesus 'wa: “Amepanen, mo'se woryi 'wa taporitonone aino any'marymbo apo'i na'na. ");
INSERT INTO car_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mo'kopangon woryijan tu'ponaka topu papyry man ekari'san ky'waine mo'ko Moses moro omenano mero'po ta. Amoro te, o'to ko mykanon moro poko?” ");
INSERT INTO car_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","U'kuto'me moro wara ika'san, amy emendoto'man epoto'me ty'waine. Tawejaku'po Jesus we'i'po. Sakau ta oty merory a'mo'po i'wa tainary ke. ");
INSERT INTO car_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Tywoturuporykon poko aikepy'pa iwe'i'san mero, awomy'po. Ika'po i'waine: “Mo'ko ija'wanypyn na'nen topu pa'nen itu'ponaka.” ");
INSERT INTO car_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tawejaku'po rapa iwe'i'po. Sakau ta oty merory a'mo'po rapa i'wa. ");
INSERT INTO car_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Moro auran eta'po mero ty'waine, o'win o'win pai ito'san. Mo'karon uwapoto'san na'nen wyto'san. Jesus no'po ko'wu i'waine mo'ko owarira'nanombo woryi maro roten. ");
INSERT INTO car_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Irombo Jesus awomy'po. Ika'po mo'ko woryi 'wa: “Woryi, oje ko nandon? Amy pairo a'wembono auranano anyry'pa ne'i apoko?” ");
INSERT INTO car_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Mo'ko woryi wyka'po: “Uwa, Jopoto.” Irombo Jesus wyka'po: “Awu enapa a'wembono auranano anyry'pa wa apoko. I'tango. Erombo poro yja'wan me noro kyte'i.” ");
INSERT INTO car_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesus wyka'po rapa mo'karon kari'na 'wa: “Moro nono aweiry awu wa. Mo'ko ywena'po ta ytototo itopoty'pa noro kynaitan ewa'rumy ta. Amano aweiry te ekosa kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Mo'karon Farise wyka'san te I'wa: “Aseke apoko oty mamyikapoja. Moro anamyikapory oty iporo waty man.” ");
INSERT INTO car_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesus wyka'po eju'to'ko'me: “Aseke ypoko oty amyikapory se'me, moro ynamyikapory oty iporo man. Ojembo ywopy'po, oja ywytory enapa suku'sa. Amyjaron te ojembo ywopy'po, oja ywytory enapa anukuty'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Amyjaron kari'na emery me a'wembono auranano myjaton. Awu te amy pairo poko a'wembono auranano anyry'pa wa. ");
INSERT INTO car_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","A'wembono auranano yry jako ro rypo, moro ynyry a'wembono auranano iporo man. O'win upu'po irombo e'i'pa wa. Mo'ko yjemo'nenymbo jumynano te ymaro man. ");
INSERT INTO car_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moro o'wanokon omenano karetary ta enapa tymero man oko kari'na namyikapory oty wairy iporo. ");
INSERT INTO car_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Awu aseke ypoko oty samyikapoja. Mo'ko yjemo'nenymbo jumynano enapa te ypoko oty amyikapojan.” ");
INSERT INTO car_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Irombo mero ika'san I'wa: “Oje ko mo'ko ajumy nan?” Jesus wyka'po eju'to'ko'me: “Yjukuty'pa mandon. Mo'ko yjumy anukuty'pa enapa mandon. Yjukutyry jako rypo, mo'ko yjumy enapa muku'tory.” ");
INSERT INTO car_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Moro wara aurana'po, moro pyrata ytopo po moro Tamusi auty ta kari'na emepary jako ty'wa. Anapo'i'pa te amy pairo we'i'po. Apyitopo jururu irombo itunda'pa na'nen kynakon. ");
INSERT INTO car_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesus wyka'po rapa i'waine: “Wy'take. Kupita'ton. Oja'wanykon ta te aromo'ta'ton. Ywytotopo 'wa awopyrykon mupijaton amyjaron.” ");
INSERT INTO car_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Mo'karon Simosu wyka'san: “Aseke ka'tu no'wotan? Kynganon irombo: ‘Ywytotopo 'wa awopyrykon mupijaton amyjaron.’ ” ");
INSERT INTO car_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesus wyka'po i'waine: “Amyjaron po'po wyino mandon. Awu kawo wyino wa. Amyjaron ero nono wyino mandon. Awu ero nono wyino kapyn wa. ");
INSERT INTO car_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Wykai o'waine: Oja'wanykon ta aromo'ta'ton. Inoro me ro ywairy anamyika'pa aja'taine irombo, oja'wanykon ta aromo'ta'ton.” ");
INSERT INTO car_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ika'san Jesus 'wa: “Noky ko amoro man?” Ika'po i'waine: “Mo'ko penaro terapa ynekarity'po. ");
INSERT INTO car_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Pyime o'to apokoine ywykary taro wa. Pyime otykon poko apokoine a'wembono auranano yry taro wa. Mo'ko yjemo'nenymbo te iporo man. Moro iwyino yneta'po sekari'sa kari'na 'wa.” ");
INSERT INTO car_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Mo'ko jumynano poko ty'waine auranary anukuty'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesus wyka'po i'waine: “Mo'ko kari'na ymuru awonga'po mero o'waine, muku'ta'ton inoro me ywairy, amy pairo oty anikapy'pa aseke ywairy, mo'ko jumynano 'wa yjemepa'po wara te yjauranary. ");
INSERT INTO car_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","“Mo'ko yjemo'nenymbo ymaro man. O'win upu'po yno'pa man. Morokon apokupangon otykon irombo sika'sa mo'ja ro.” ");
INSERT INTO car_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Pyime moro wara ikary etanamonymbo 'wa amyika'po. ");
INSERT INTO car_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mo'karon tamyikary a'monamonymbo Simosu 'wa ika'po: “Mo'ja ro moro yjauran apyiry jako o'waine, iporo ro ynemeparykon me mandon. ");
INSERT INTO car_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Moro iporono muku'ta'ton. Moro iporono ro ajyta'ton aporemy'ma.” ");
INSERT INTO car_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ika'san eju'to'me: “Abraham pajanymbo na'na man. Tywe'i'po poro taporemyne e'i'pa tywaije man na'na. One wara ko iro ke mykanon ‘Aporemy'ma maita'ton.’?” ");
INSERT INTO car_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesus wyka'po eju'to'ko'me: “Ita'ro pore, pa'poro yja'wan me aitoto yja'wan me aino naporemyndo'po me man. ");
INSERT INTO car_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Mo'ko aporemyndo'po mo'ja ro auto ta e'i'pa kynaitan. Mo'ko ymunano te mo'ja ro moro po kynaitan. ");
INSERT INTO car_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mo'ko ymunano 'wa aporemy'ma ajyry'sando, iporo ro aporemy'ma maita'ton. ");
INSERT INTO car_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Abraham pajanymbo me awairykon suku'sa. Ise'me ywory poko te mo'mikaton, yjauranymbo apyiry 'se'pa awairykon ke. ");
INSERT INTO car_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mo'ko yjumy ekosa ynene'san otykon sekari'sa. Amyjaron enapa mo'ko ajumykon ekosa aneta'san otykon mika'saton.” ");
INSERT INTO car_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ika'san eju'to'me: “Mo'ko Abraham na'na epy me man.” Jesus wyka'po i'waine: “Abraham pajanymbo me ro aja'taine rypo, iwara enapa maitory. ");
INSERT INTO car_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ywory poko te mo'mikaton, Tamusi wyino yneta'po iporono oty ekarityry se'me y'wa o'waine. Moro wara e'i'pa mo'ko Abraham tywaije man. ");
INSERT INTO car_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mo'ko ajepykon wara te mandon.” Irombo ika'san I'wa: “Wo'kapyimo kapyn na'na man. Tamusi roten na'na jumy man.” ");
INSERT INTO car_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesus wyka'po i'waine: “Ajumykon me ro Tamusi a'ta rypo, kypynatory. Tamusi wyino irombo tywo'se wa, ero po ywaito'me. Aseke opy'pa tywaije wa. Mo'ko 'wa te tomo'se wa. ");
INSERT INTO car_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","O'tono'me ko yjauran anukuty'pa mandon? Yjauran etary upiry ke o'waine. ");
INSERT INTO car_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mo'ko ewa'rumy tamuru ajumykon me man. Mo'ko ajumykon nisanory kapyry 'se ro mandon. Penaro ro kari'na wonen me mo'ko tywaije man. Iporono oty wyino kapyn man. Iwyino kapyn enapa iporono oty man. Tonapitary jako, typo ro kynaurananon. Tonapiren noky irombo mo'ko man. Onapi jumy mo'ko man. ");
INSERT INTO car_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Awu te iporono oty sekari'sa. Iro ke ro yjamyika'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Noky ko ara'naine yju'ta amy yja'wan oty wairy ekarityry taro nan? Iporono oty ekarityry jako y'wa, o'tono'me ko yjamyika'pa mandon? ");
INSERT INTO car_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mo'ko Tamusi y'me Tamusi auran etanon. Amyjaron ko'wu etary 'se'pa mandon, Tamusi y'makon me kapyn awairykon ke.” ");
INSERT INTO car_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Mo'karon Simosu wyka'san eju'to'me: “Iporo waty Samaria pono me, takyre enapa ajekari'san na'na?” ");
INSERT INTO car_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesus wyka'po eju'to'ko'me: “Takyre e'i'pa wa. Mo'ko yjumy ety te sawongaje. Amyjaron te yjety anawonga'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Awu te aseke yjety awongary poko o'mika'pa wa. Mondo terapa man mo'ko moro poko o'mikatoto. A'wembono auranano ytan enapa. ");
INSERT INTO car_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ita'ro pore, mo'ko yjauran kura'manen romo'no anene'pa roten kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Irombo mero mo'karon Simosu wyka'san I'wa: “Erome te takyre ajukutyi na'na. Mo'ko Abraham tyromo'se man, mo'karon Tamusi auran uku'ponamon enapa. Ise'me amoro mykaje ‘Mo'ko yjauran kura'manen anepory'pa roten romo'no kynaitan.’ ");
INSERT INTO car_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Mo'ko na'na epy Abraham uwapotory me ka'tu man? Tyromo'se man. Mo'karon Tamusi auran uku'ponamonymbo enapa tyromo'se mandon. Noky me ko mokano'san?” ");
INSERT INTO car_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesus wyka'po eju'to'ko'me: “Aseke yjety awongary jako y'wa, amy oty kapyn moro man. Mo'ko yjumy te yjety awonganen me man. Mo'ko ro mekari'saton atamusirykon me. ");
INSERT INTO car_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anukuty'pa te mandon. Awu te suku'sa. Anukuty'pa ywairy ekarityry jako rypo y'wa, awaraine tonapire wairy. Suku'sa te. Moro auran sikura'maje. ");
INSERT INTO car_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mo'ko ajepykon Abraham 'wa tawa'pore moro ywo'topo kurita tymomo'se man. Irombo ene'po mero tawa'pota man.” ");
INSERT INTO car_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Mo'karon Simosu wyka'san I'wa: “Oko-kari'na itu'ponaka ainapatoro siriko e'i'pa na'nen mana. Irombo Abraham tone o'wa nan?” ");
INSERT INTO car_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesus wyka'po i'waine: “Ita'ro pore, mo'ko Abraham uwapotory me wa.” ");
INSERT INTO car_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Irombo mero topu anumy'san i'waine, itu'ponaka emato'ko'me. Iwotunemy'po te. Moro Tamusi auty wyino ito'po. ");
INSERT INTO car_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tytory ta Jesus 'wa amy enu'pa oma'po wokyry ene'po. ");
INSERT INTO car_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Irombo mo'karon inemeparykon woturupo'san i'wa. Ika'san: “Amepanen, o'tono'me ko mo'ko wokyry enu'pa tywoma nan? Aseke tyja'wany poko? Mo'ko tyjumy, tysano yja'wany poko te ka'tu?” ");
INSERT INTO car_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesus wyka'po eju'to'ko'me: “Aseke tyja'wany poko kapyn, mo'ko tyjumy, tysano yja'wany poko kapyn enapa enu'pa tywoma man. Kari'na 'wa typoko Tamusi emamin eneto'me te enu'pa tywoma man. ");
INSERT INTO car_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Mo'ko yjemo'nenymbo emamin kapyry ky'waine man, kurita a'ta ro'kon. Aire kyniko'mandan. Irombo amy pairo tamaminary upitan. ");
INSERT INTO car_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ero nono tu'po yja'ta ro'kon, ero nono aweiry me wa.” ");
INSERT INTO car_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Moro wara tyka'po mero, sakau tu'ponaka eta'ta'po. Moro tatakurumbo maro sakau y'kaima'po i'wa akuru me. Moro akuru ke ro mo'ko enupyn enuru kyrykyryma'po i'wa. ");
INSERT INTO car_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Irombo mero ika'po i'wa: “Eku'mi'tango moro ekupitopo Siloam taka.” Moro Siloam tauro'po man ‘Emoky'po’. Mo'ko enupyn wyto'po eku'mi'se. Irombo tanure terapa iwerama'po. ");
INSERT INTO car_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Mo'karon emamyry a'sakarykon, mo'karon epataimatoto me enenamonymbo enapa wyka'san: “Mo'ko tandy'po epataimatotombo wokyry kapyn mo'ko nan?” ");
INSERT INTO car_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Amykonymbo wyka'san: “A'a, inoro ro mo'ko man.” Amykonymbo wyka'san te: “Uwa, inoro kapyn mo'ko man. Eneke te man.” Aseke te mo'ko wokyry wyka'po: “Inoro ro awu wa.” ");
INSERT INTO car_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Irombo ika'san i'wa: “One wara ko ajenutai?” ");
INSERT INTO car_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ika'po eju'to'ko'me: “Amy Jesus tatynen wokyry sakau y'kaimai tatakurumbo maro akuru me. Moro akuru ke ro yjenuru kyrykyrymai. Irombo mero nykai y'wa: ‘Moro Siloam tunary taka eku'mi'tango.’ Irombo wyton. Yweku'mity'ma'po mero, yjenutai.” ");
INSERT INTO car_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ika'san i'wa: “Oje ko mo'ko wokyry nan?” Ika'po: “Anukuty'pa wa.” ");
INSERT INTO car_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Irombo mero mo'ko enupynymbo aro'po i'waine mo'karon Farise 'wa. ");
INSERT INTO car_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Otare'matopo kurita irombo Jesus 'wa akuru tyka'se kynakon. Mo'ko enupynymbo tanutano'po enapa i'wa kynakon. ");
INSERT INTO car_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mo'karon Farise woturupo'san enapa moro one wara enuta'po poko. Irombo ika'po i'waine: “Akuru ke yjenuru kyrykyrymai. Irombo yweku'mity'po mero yjenutai.” ");
INSERT INTO car_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Amykon Farise wyka'san i'wa: “Mo'ko moro wara e'i'po wokyry Tamusi wyino opy'pa man. Moro otare'matopo kurita anu'ku'pa irombo man.” Amykon rapa wyka'san te: “One wara ko amy yja'wan kari'na moropangon kapu wyinonokon otykon kapyry taro nan?” O'win e'i'pa moro iwonumengarykon we'i'po. ");
INSERT INTO car_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Irombo ika'san mo'ko enupynymbo 'wa rapa: “O'to ko amoro mykanon mo'ko ajenutano'ponenymbo poko?” Ika'po: “Amy Tamusi auran uku'ponen mo'ko man.” ");
INSERT INTO car_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Mo'karon Simosu moro enu'pa iwe'i'po, moro enuta'po enapa amyikary 'se'pa kynatokon. Iro ke ro mo'ko ijumy, isano ko'mapo'san i'waine. ");
INSERT INTO car_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Iwoturupo'san i'waine: “Mo'ko enu'pa tywoma anekarityrykon o'makon mo'se nan? One wara ko iro ke erome oty enejan?” ");
INSERT INTO car_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Mo'ko ijumy, isano 'wa ejuku'san. Ika'san: “Ty'me me mo'se uku'san na'na. Enu'pa tywoma man. ");
INSERT INTO car_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","One wara enuta'po, noky 'wa enutano'po'po pai anukuty'pa na'na man. Aturupotoko aseke i'wa. Uwapotombo me terapa man. Aseke typoko ajerupata'ton.” ");
INSERT INTO car_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Moro wara mo'ko ijumy, isano wyka'san, mo'karon Simosu jopotorykon pona tanarike tywairykon ke. Mo'karon 'wa ro taurangon topopo terapa kynakon, moro tywota'nano'to'kon auto taka opy'pa noro mo'ko Mesias me Jesus ekari'nen waito'me. ");
INSERT INTO car_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Iro ke ro mo'ko ijumy, isano wyka'san: “Uwapotombo me terapa man. Aseke i'wa aturupotoko.” ");
INSERT INTO car_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Irombo mero ijokonory me mo'ko enupynymbo wokyry ko'mapo'po i'waine. Ika'san i'wa: “Tamusi ety awongako. Tyja'wange mo'ko wokyry uku'san na'na.” ");
INSERT INTO car_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ika'po eju'to'ko'me: “Tyja'wange iwairy anukuty'pa wa. O'win oty te suku'sa. Enu'pa wakon. Erome te oty seneja.” ");
INSERT INTO car_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ika'san i'wa: “O'to ko iro ke ajyryi? One wara ko ajenutano'poi?” ");
INSERT INTO car_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ika'po eju'to'ko'me: “Sekarityi terapa o'waine. Epanama'pa te maiton. Oty etary 'se ko rapa mandon? Amyjaron enapa ka'tu inemeparykon me awairykon 'se mandon?” ");
INSERT INTO car_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Irombo mero eju'po i'waine. Ika'san i'wa: “Amoro mo'ko nemepary me mana. Na'na te Moses nemeparykon me man. ");
INSERT INTO car_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moses 'wa Tamusi aurana'po uku'san na'na. Mo'ko wopy'po anukuty'pa te na'na man ojembo.” ");
INSERT INTO car_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mo'ko wokyry wyka'po eju'to'ko'me: “Na! Anumengapoto moro oty man. Yjenutano'po'po se'me amyjaron moro ojembo iwopy'po anukuty'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tyja'wangamon kari'na 'wa epanama'pa Tamusi wairy kysuku'saton. Mo'ko tynendonen 'wa te, mo'ko tynisanory ka'nen 'wa te kynepanamanon. ");
INSERT INTO car_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Erombo ponaro amy 'wa amy enu'pa oma'po enutano'po'po ota'pa man. ");
INSERT INTO car_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Tamusi wyino opy'pa tywe'i'pomboto, amy pairo oty kapyry upiry.” ");
INSERT INTO car_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ika'san eju'to'me: “Oja'wanykon ta tywoma mana. Ise'me na'na emepary 'se man?” Irombo imoma'po i'waine kurandonaka. ");
INSERT INTO car_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Moro i'waine imoma'po eta'po Jesus 'wa. Irombo epory'po mero ika'po i'wa: “Mo'ko kari'na ymuru mamyikanon amoro?” ");
INSERT INTO car_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mo'ko wokyry wyka'po eju'to'me: “Inoro me noky wairy ekari'ko, Jopoto, samyika'se me.” ");
INSERT INTO car_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesus wyka'po eju'to'me: “Tone terapa o'wa man. Mo'ko ajerupanen mo'ko man.” ");
INSERT INTO car_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Irombo ika'po: “Samyikaje, Jopoto.” Irombo ipo'ponaka iwokunama'po. ");
INSERT INTO car_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Irombo mero Jesus wyka'po: “Ero nono poko a'wembono auranano yje tywo'se wa. Mo'karon enu'non kynenutata'ton. Mo'karon tanuramon enu'pa kynaita'ton.” ");
INSERT INTO car_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Moro eta'po mero ty'waine, mo'karon ekosa aitonon Farise wyka'san I'wa: “Na'na enapa ka'tu enu'pa nan?” ");
INSERT INTO car_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesus wyka'po i'waine: “Enu'pa awe'i'sanymboto, ija'wany'pa maitory. Tanure te mokari'saton. Iro ke ro oja'wanykon kynaijan roten.” ");
INSERT INTO car_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Ita'ro pore, mo'ko kapara waitopo penary ta o'mypyn, mo'ko amy terapa oje itaka anu'toto, amy manaman mo'ko man. ");
INSERT INTO car_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Mo'ko pena ta o'mytoto te mo'karon kapara enenen me man. ");
INSERT INTO car_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Mo'ko 'wa ro mo'ko pena eran moro pena etapurumakanon. Mo'ko tanenamon auran 'wa mo'karon kapara kynepanamaton. Mo'karon tokykon ko'manon etykon ta. Kurandonaka kynarojaton. ");
INSERT INTO car_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Pa'poro mo'karon tokykon pa'ka'san mero ty'wa, uwapoine kyny'san. Mo'karon kapara iwena'po ta kyny'saton, auran ukutyry ke ty'waine. ");
INSERT INTO car_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Amy tynukuty'torykon wena'po ta ito'pa kynaita'ton. Kynetuwarikata'ton te iwyino, auran anukuty'pa tywairykon ke.” ");
INSERT INTO car_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Moro onumengatopo auranano ekarityry jako Jesus 'wa ty'waine, o'to ikary anukuty'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesus wyka'po rapa: “Ita'ro pore, mo'karon kapara waitopo penary awu wa. ");
INSERT INTO car_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Pa'poro mo'karon yjuwapo tywo'se mandon inaron, manamangon mo'karon mandon. Moro aurangon 'wa epanama'pa te mo'karon kapara tywaije mandon. ");
INSERT INTO car_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Moro pena awu wa. Mo'ko yta o'mytoto tunenje kynaitan. Kyno'mytan. Kynepa'katan. Tarepary paty epotan. ");
INSERT INTO car_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mo'ko manaman imona'toine, iwoine, uta'kaine roten kyno'san. Awu te tywo'se wa amano epoto'me i'waine i'maty'pa roten. ");
INSERT INTO car_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Mo'ko iru'pyn kapara enenen awu wa. Mo'ko iru'pyn kapara enenen moro tamamyrymbo nondary taro man tokykon upu'po me. ");
INSERT INTO car_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mo'ko tapema me kapara enenen, amy kapara enenen 'nero kapyn mo'ko man. Ekykon kapyn mo'karon kapara man. Amy tokonen pero wopyry ene'po mero ty'wa, mo'karon kapara nojan. Kynetuwarikanon. Mo'ko tokonen pero te mo'karon kapara apyijan. Kynaripa'pojaton. ");
INSERT INTO car_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Tapema me roten tamaminary ke irombo mo'karon kapara poko esyka'pa man mo'ko wokyry. ");
INSERT INTO car_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Iru'pyn kapara enenen awu wa. Yjekykon suku'sa. Yjekykon yjuku'saton. ");
INSERT INTO car_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Mo'ko jumynano 'wa yjukutyry wara awu enapa mo'ko jumynano suku'sa. Yjemamyrymbo sinondaje mo'karon kapara upu'po me. ");
INSERT INTO car_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Amykon terapa kapara enapa yjekykon me mandon. Ero kapara waitopo tanokon kapyn mo'karon mandon. Mo'karon arory enapa y'wa man. Yjauran 'wa kynepanamata'ton. O'win kapara apyimy me kynaita'ton. O'win amy enenamon me kynaitan. ");
INSERT INTO car_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Mo'ko jumynano ypynanon, moro yjemamyrymbo nondary ke y'wa. Sapyitake rapa te. ");
INSERT INTO car_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Amy pairo anipina'pa man ywyino. Aseke te sinondaje. Inondary yjaina man. Apyiry rapa yjaina man. Moro wara mo'ko yjumy wyka'po man y'wa.” ");
INSERT INTO car_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Moro auran poko mo'karon Simosu wonumengary we'i'po rapa o'win e'i'pa. ");
INSERT INTO car_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Pyime amykon wyka'san: “Takyre man. To'mere'se man. O'tono'me ko i'wa mepanamaton?” ");
INSERT INTO car_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amykon wyka'san rapa te: “Amy takyren moro wara aurana'pa man. Amy akywano 'kare amy enupyn enutano'pory taro nan.” ");
INSERT INTO car_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Irombo Tamusi 'wano me rapa moro auty yry ewa'mary kynakon Jerusalem po. Poto 'su i'sano kynakon. ");
INSERT INTO car_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ijako Jesus moro Salomo ety tano Tamusi auty pery upi'no kyny'sakon. ");
INSERT INTO car_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Irombo u'memy'po mo'karon Simosu 'wa. Ika'san I'wa: “Akore'pe noro na'na wyino oty munendan? Mo'ko Mesias me aja'ta, na'na wyino kysunemyi.” ");
INSERT INTO car_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesus wyka'po eju'to'ko'me: “Wykai terapa o'waine. Yjamyika'pa te mandon. Morokon yjumy ety ta ynikapyry amaminano ypoko oty amyikapojan. ");
INSERT INTO car_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amyjaron te yjamyika'pa mandon, yjekykon me kapyn awairykon ke. ");
INSERT INTO car_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mo'karon yjekykon yjauran 'wa kynepanamaton. Awu suku'saton. Ywena'po ta kyny'saton. ");
INSERT INTO car_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","I'matypyn amano syja i'waine. Utapy'pa roten kynaita'ton. Amy pairo anipina'paine yjainary wyino kynaitan. ");
INSERT INTO car_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Moro y'wa mo'ko yjumy nyry'po pa'poro oty ko'po poto me man. Amy pairo kari'na oty pinary upijan mo'ko yjumy ainary wyino. ");
INSERT INTO car_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Awu mo'ko jumynano maro o'win wa.” ");
INSERT INTO car_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Irombo mero topu anumy'san rapa mo'karon Simosu 'wa itu'ponaka ipa'to'ko'me. ");
INSERT INTO car_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesus wyka'po te i'waine: “Pyime mo'ko jumynano wyinonokon kurangon amaminano senepoi o'waine. Otypan poko ko topu papyry 'se mandon?” ");
INSERT INTO car_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Mo'karon Simosu wyka'san eju'to'me: “Amy iru'pyn amaminano poko kapyn na'na topu papyry 'se man otu'ponaka, Tamusi ety jamikary poko te o'wa. Kari'na me awairy se'me irombo Tamusi me matyja.” ");
INSERT INTO car_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesus wyka'po eju'to'ko'me: “Moro anamyikarykon omenano karetary ta ero imero'pa nan: ‘Awu wykai ‘Tamusi me mandon’ ’? ");
INSERT INTO car_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Moro omenano karetary tambotyry taro waty man. Moro te mo'karon Tamusi auran nepory'san ejatojan Tamusi me. ");
INSERT INTO car_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","One wara ko iro ke awu, mo'ko tywyinono me mo'ko jumynano nyry'po, mo'ko ero nono tu'ponaka inemoky'po, Tamusi ety jamikanen me kakari'saton, ywyka'po poko: ‘Tamusi ymuru awu wa’? ");
INSERT INTO car_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Morokon yjumy emamingon anikapy'pa yja'ta, yjamyikary kapyn o'waine man. ");
INSERT INTO car_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Morokon amaminano kapyry se'me te y'wa yjamyika'pa aja'taine, morokon amaminano 'ne amyikatoko. Irombo mero muku'ta'ton moro yta mo'ko jumynano wairy, mo'ko jumynano ta awu ywairy enapa.” ");
INSERT INTO car_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Irombo apyiry poko rapa iwe'ku'san. Iwetuwarika'po te iwyinoine. ");
INSERT INTO car_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ito'po rapa moro Jordan koposenaka, moro koromo Johanes 'wa kari'na etykatopombo 'wa. Moro po ro iwe'i'po. ");
INSERT INTO car_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Pyime kari'na wopy'san I'wa. Ika'san: “Amy pairo kapu wyinono oty anenepo'pa ro rypo Johanes kynainen. Pa'poro mo'se wokyry poko inekarityry otykon te iporo tywaije man.” ");
INSERT INTO car_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Pyime kari'na 'wa moro po amyika'po. ");
INSERT INTO car_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Amy Betania pono wokyry Lasarus je'tun pe kynakon. Moro Betania ro mo'karon asepityjan Maria, Marta emando'kon me kynakon. ");
INSERT INTO car_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mo'ko Maria 'wa ro moro mere tatynen karapa ke mo'ko Jopoto kyrykyryma'po wyino moro ipupuru ty'koka kynakon moro tunsety ke. Mo'ko piry ro, Lasarus, je'tun pe kynakon. ");
INSERT INTO car_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mo'karon asepityjan 'wa ro ero oka aropo'po mo'ko Jesus 'wa: “Jopoto, mo'ko anipynary aja'sakary je'tun pe man.” ");
INSERT INTO car_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Moro eta'po mero ty'wa, Jesus wyka'po: “Iromo'to'me kapyn moro je'tunano man, Tamusi ety awongato'me te, mo'ko Tamusi ymuru ety awongato'me enapa.” ");
INSERT INTO car_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus 'wa 'kuru mo'ko Marta, mo'ko ipity, mo'ko Lasarus enapa typyne kynatokon. ");
INSERT INTO car_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Moro je'tun pe Lasarus wairy ekary eta'po mero ty'wa, oko kurita noro Jesus we'i'po moro ipo tywaitopo po. ");
INSERT INTO car_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Irombo mero ika'po mo'karon tynemeparykon 'wa: “Judea 'wa rapa ka'makon.” ");
INSERT INTO car_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Mo'karon inemeparykon wyka'san I'wa: “Amepanen, topu ke awory 'se mo'karon Simosu wairy se'me, moro 'wa rapa awytory 'se man?” ");
INSERT INTO car_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesus wyka'po eju'to'ko'me: “Ainapatoro itu'ponaka oko juru kapyn taweije nan o'win kurita? Kurita amy wytopotyry jako, oty pona o'wo'pa man, ero nono aweiry enery ke ty'wa. ");
INSERT INTO car_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Koko amy wytopotyry jako te, oty pona kyno'wojan, awei'pa tywairy ke.” ");
INSERT INTO car_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Moro wara ika'po. Irombo mero ika'po noro i'waine: “Mo'ko ka'sakarykon Lasarus tywo'ny'se man. Awu te embaka wy'sa.” ");
INSERT INTO car_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Mo'karon inemeparykon wyka'san I'wa: “Jopoto, tywo'ny'se ta'ta, iru'pa rapa kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Iromby'po 'wa Jesus wyka'po moro kynakon. Mo'karon inemeparykon te moro Lasarus wo'nyky'po ekano'satokon tywotare'mato'me. ");
INSERT INTO car_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Irombo mero oty we'i'po wara ro Jesus 'wa oty ekarity'po i'waine. Ika'po: “Lasarus tyromo'se man. ");
INSERT INTO car_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Uwa ekosa ywe'i'po poko tawa'pore wa ajupu'san me. Iwara ro Tamusi amyikary taro 'ne ka'tu rapa maita'ton. Ka'makon te i'wa.” ");
INSERT INTO car_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Mo'ko Tomas, mo'ko Didymus me kynejatojaton inoro wyka'po mo'karon ta'sakarykon Jesus nemeparykon 'wa: “Imaro ka'makon, imaro ro kyromo'to'se me.” ");
INSERT INTO car_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tytunda'po mero, okupa'en kurita terapa mo'ko Lasarus unemy'po wairy ukuty'po Jesus 'wa. ");
INSERT INTO car_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Moro Betania tyse waty Jerusalem wyino kynakon, atone'pu stadion itysenory wairy taro. ");
INSERT INTO car_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Pyime Simosu Marta 'wa, Maria 'wa enapa tywo'se kynatokon, ituru'san andy'moto'me mo'ko ipiryjan pa'po po. ");
INSERT INTO car_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Mo'ko Jesus wopyry eta'po mero ty'wa, mo'ko Marta wyto'po epoje. Maria we'i'po te auto po. ");
INSERT INTO car_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Irombo Marta wyka'po Jesus 'wa: “Jopoto, ero po awe'i'poto, ypiry iromby'pa nairy. ");
INSERT INTO car_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ise'me Tamusi 'wa pa'poro awoturupotopo yry man suku'sa.” ");
INSERT INTO car_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesus wyka'po i'wa: “Kynawondan mo'ko apiry.” ");
INSERT INTO car_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta wyka'po I'wa: “Moro irombo ro kurita awono jako 'kuru awomyry man suku'sa.” ");
INSERT INTO car_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesus wyka'po i'wa: “Awu moro awono undy me, moro amano undy me enapa wa. Mo'ko yjamyikanen nuro kynaitan, tyromby'poto ro rypo. ");
INSERT INTO car_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Pa'poro mo'ko nurono yjamyikanen iromby'pa roten kynaitan. Moro mamyikanon?” ");
INSERT INTO car_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mo'ko woryi wyka'po I'wa: “A'a, Jopoto. Mo'ko Mesias me, mo'ko Tamusi ymuru me, mo'ko ero nono tu'ponaka o'toto manombo me awairy samyikaje.” ");
INSERT INTO car_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Moro wara tyka'po mero, mo'ko Marta wyto'po. Mo'ko typity Maria ko'ma'po i'wa. Ekapyn ta ika'po i'wa: “Mo'ko amepanen nopyi. Ako'manon.” ");
INSERT INTO car_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Moro eta'po mero ty'wa, tarawone awomy'po I'wa tytoto'me. ");
INSERT INTO car_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus moro aitopo taka noro o'my'pa kynakon. Moro Marta 'wa topotopombo po noro te Jesus kynakon. ");
INSERT INTO car_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tarawone Maria awomy'po tytoto'me. Moro ene'po ro mo'karon auty 'wa iwonumengary andy'mo opy'san Simosu 'wa. Irombo iwekena'po i'waine. Moro atunendopo 'wa itory ekano'satokon atamo. ");
INSERT INTO car_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria tunda'po moro ipo Jesus waitopo 'wa. Ene'po mero ty'wa, ipupuru po iwoma'po. Ika'po I'wa: “Jopoto, ero po awe'i'poto, ypiry iromby'pa nairy.” ");
INSERT INTO car_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria wotamory, mo'karon imaro opy'san Simosu wotamory enapa ene'po mero ty'wa, Jesus worekama'po. Kata'mato iwe'i'po. ");
INSERT INTO car_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ika'po: “Oje ko myton?” Ika'san I'wa: “Jopoto, eneko, se.” ");
INSERT INTO car_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesus wotamo'po. ");
INSERT INTO car_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Irombo mo'karon Simosu wyka'san: “Eneko. Poto me typyna tywaije i'wa man.” ");
INSERT INTO car_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amykon wyka'san te: “Mo'ko enupynymbo tanutano'po i'wa man. Mo'ko Lasarus rombyry a'kotory taro te e'i'pa tywaije nan?” ");
INSERT INTO car_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesus worekama'po rapa. Moro atunendopo 'wa ito'po. Topu atory moro atunendopo me kynakon. Ipenary aputy me topu tyje kynakon. ");
INSERT INTO car_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesus wyka'po: “Moro ipenary aputy topu emimatoko.” Irombo mo'ko iromby'po enautymbo Marta wyka'po I'wa: “Jopoto, tykore terapa man mo'ko akepy. Okupa'en kurita terapa moro iromby'po man.” ");
INSERT INTO car_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesus wyka'po i'wa: “ ‘Tamusi amyikary jako o'wa, poto me Tamusi wairy menetake’ yka'pa we'i o'wa?” ");
INSERT INTO car_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Moro ipenary aputy topu emima'po i'waine. Irombo kawonaka Jesus wo'poty'po. Ika'po: “Papa, ajety sawongaje moro y'wa awepanama'po poko. ");
INSERT INTO car_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Penaro terapa moro y'wa awepanamary suku'sa. Mo'karon o'po'tonon kari'na upu'san me te moro wara wykaje. Iwara ro moro o'wa yjemoky'po amyikata'ton.” ");
INSERT INTO car_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Moro wara tyka'po wyino, iko'ta'po imero: “Lasarus, epa'kako.” ");
INSERT INTO car_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Irombo mo'ko iromby'po wepa'ka'po. Ainary, ipupuru tyjasimembo'se kynakon kamisa ke. Tu'mytyne enapa kynakon. Irombo Jesus wyka'po mo'karon kari'na 'wa: “Ikarangatoko, nyto'se me.” ");
INSERT INTO car_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Pyime mo'karon Maria ene opy'san Simosu 'wa Jesus amyika'po, moro inikapy'po oty ene'po mero ty'waine. ");
INSERT INTO car_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amykon wyto'san te mo'karon Farise 'wa. Moro Jesus nikapy'po oty ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Irombo mero mo'karon Tamusi pokonokon jopotorykon wota'nanopy'san mo'karon Farise maro. Ase'wa ika'san: “O'to ko kytaita'ton? Pyime kapu wyinonokon otykon enepojan irombo mo'ko wokyry. ");
INSERT INTO car_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ipoko e'i'pa ka'taine, pa'poro kari'na kynamyikata'ton. Irombo mo'karon Rome ponokon kyno'ta'ton moro kywaito'kon pono Tamusi auty tororoka, mo'karon ka'sakarykon Simosu uta'ka enapa.” ");
INSERT INTO car_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Irombo o'win amy a'sakarykon, Kajafas, mo'ko moro siriko ta mo'karon Tamusi pokonokon jopotory me kynakon inoro wyka'po i'waine: “Onumengapo'pa mandon. ");
INSERT INTO car_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Anukuty'pa mandon mo'karon ero ponokon kari'na upu'po me o'win kari'na rombyry wairy iru'pa o'wanokon me. Iwara ro pa'poro mo'karon ka'sakarykon Simosu utapy'pa kynaita'ton.” ");
INSERT INTO car_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tuwano me kapyn moro wara taurana man. Moro siriko tano Tamusi pokonokon jopotory me te moro wara moro Tamusi auran tuku'po i'wa man. Mo'karon Simosu 'wano me Jesus rombyry man takari'se i'wa man, ");
INSERT INTO car_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","mo'karon Simosu 'wano me roten kapyn, mo'karon ataripapy'san Tamusi y'makon a'nano'to'me enapa te i'wa. ");
INSERT INTO car_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Morombo wyino ro iwory man poko iworupato'kon kynakon. ");
INSERT INTO car_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Iro ke ro tone me noro kapyn Jesus wytopo'topo kynakon mo'karon Simosu ra'na. Iwomima'po te moro iponomyn wo'i esi'wonaka, moro Efraim tatynen aitopo 'wa. Moro po ro iwe'i'po mo'karon tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mo'karon Simosu 'wa mo'ko eratonomapotopombo onory ewa'mary tyse waty kynakon. Pyime kari'na wonuku'san tywaito'kon wyino Jerusalem 'wa, mo'ko eratonomapotopombo onory ewa'mary uwaporo Tamusi 'wano me tywekorokato'ko'me. ");
INSERT INTO car_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Irombo Jesus upijatokon. Moro Tamusi auty ta tywota'nanopy'san po ase'wa kyngatokon: “One wara ko monumengaton? Opy'pa kynaitan ero oty ewa'mary 'wa, aine?” ");
INSERT INTO car_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mo'karon Tamusi pokonokon jopotorykon, mo'karon Farise enapa tyka kynatokon, mo'ko oje Jesus wairy uku'nen wo'to'me ty'waine ekari'se, mo'ko Jesus apyito'me ty'waine. ");
INSERT INTO car_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","O'win-to'ima kurita noro mo'ko eratonomapotopombo onory ewa'mary tundary a'ta, Jesus wyto'po moro Betania 'wa. Moro Betania po ro mo'ko iromby'san wyino inawonga'po Lasarus kynemanjakon. ");
INSERT INTO car_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Moro po ro mo'ko Jesus erepary man kapy'po i'waine. Mo'ko Marta arepa ekanen me kynakon. Mo'ko Lasarus mo'karon Jesus maro endametonon ekosa kynakon. ");
INSERT INTO car_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maria 'wa o'win tukuwari'membo nardus katy ke 'ne ro tapenen karapa anumy'po. Moro karapa ke ro morokon Jesus pupuru poporo'san i'wa. Irombo tunsety ke morokon ipupuru y'koka'po i'wa. Moro auto y'namoro'po moro karapa popory 'wa. ");
INSERT INTO car_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Irombo o'win amy inemepary, Judas Iskariot, mo'ko ekaramanen man wyka'po: ");
INSERT INTO car_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“O'tono'me ko moro karapa ekarama'pa tywaije nan atone'pu-kari'na amu'nymbo pyrata poko, moro epe'po yto'me mo'karon ipyrata'non 'wa?” ");
INSERT INTO car_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Mo'karon ipyrata'non poko tywesykary ke kapyn te moro wara ika'po, amy manaman me tywairy ke te. Ekosa moro pyrata je'ny kynakon. Iwyino ro pyrata pinatopo i'wa kynakon. ");
INSERT INTO car_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesus wyka'po: “Ipoko kyte'i. Oro nikura'man moro yjunendopo kurita 'wano man me. ");
INSERT INTO car_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mo'karon ipyrata'non kynaijaton roten ajekosaine. Awu te e'i'pa roten waitake ajekosaine.” ");
INSERT INTO car_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Pyime Simosu 'wa Betania po Jesus wairy ukuty'po. Irombo iwopy'san, mo'ko Jesus upu'po me roten kapyn, mo'ko iromby'san wyino inawonga'po Lasarus eneto'me enapa te ty'waine. ");
INSERT INTO car_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mo'karon Tamusi pokonokon jopotorykon worupa'san mo'ko Lasarus wory man poko enapa. ");
INSERT INTO car_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Pyime irombo Simosu iwyinoine kyny'satokon. Jesus amyikatokon terapa. ");
INSERT INTO car_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Irombo koro'po moro Jerusalem 'wa Jesus wopyry man eta'po wyino ty'waine, mo'karon eratonomapotopombo onory ewa'ma opy'san kari'na apyimy 'wa ");
INSERT INTO car_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","wasai ary y'koto'san. Jerusalem wyino iwepa'ka'san Jesus epoje. Iko'ta'san: “Hosana! Mo'ko Tamusi ety ta o'toto, mo'ko Israel pajanymbo Jopotory nainen pa'poro kurano maro.” ");
INSERT INTO car_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus 'wa amy parito'membo epory'po. Mo'ko tu'po ro iwotandy'mo'po, imero'po wara ro: ");
INSERT INTO car_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Tanarike kytaiton, Sion ponokon. Mo'ko Ajopotorykon kyno'san amy parito'membo tu'po. ");
INSERT INTO car_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Koromo 'ne moro anukuty'pa mo'karon inemeparykon kynatokon. Kapu taka Jesus awonga'po wyino te iwetuwaro'ma'san moro ipoko tymero oty wairy wara ro kari'na 'wa yry'po poko. ");
INSERT INTO car_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mo'ko Jesus 'wa unendopo wyino mo'ko Lasarus ko'ma'po, moro i'wa iromby'san wyino awonga'po ekari'satokon mo'karon moro jako ekosa e'i'san. ");
INSERT INTO car_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Moro i'wa moro kapu wyinono oty enepo'po eta'po ke ro ty'waine, mo'karon kari'na apyimy wyto'po epoje. ");
INSERT INTO car_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Irombo mo'karon Farise wyka'san ase'wa: “Menejaton? O'to pairo kywairykon kysupijaton! Pa'poro kari'na kyny'san iwena'po ta.” ");
INSERT INTO car_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amykon Griek enapa Jerusalem 'wa tywonu'se kynatokon Tamusi ety awonga mo'ko eratonomapotopombo onory ewa'matopo 'wa. ");
INSERT INTO car_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Mo'karon wopy'san ro mo'ko Galilea tano Betsaida pono Filipus 'wa. Iwoturupo'san i'wa: “Jopoto, Jesus enery 'se na'na man.” ");
INSERT INTO car_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filipus wyto'po Andreas 'wa ekari'se. Irombo Andreas wyto'po Filipus maro Jesus 'wa ekari'se. ");
INSERT INTO car_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesus wyka'po eju'to'ko'me: “Mo'ko kari'na ymuru awongatopo jururu nitundai. ");
INSERT INTO car_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ita'ro pore, nono tu'ponaka oma'pa, iromby'pa enapa moro itupu epyry'po we'i'poto, tywe'i'po po roten man. Iromby'poto te, tapeke imero kynaijan. ");
INSERT INTO car_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mo'ko tamamyry pynanen kynuta'katan. Mo'ko ero nono tu'po tamamyry jenono'nen te kynikura'matan i'matypyn me. ");
INSERT INTO car_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ypyitory me amy a'ta, ywena'po ta iwopyry man. Moro ywaitopo po ro mo'ko ypyitory enapa kynaitan. Ypyitory me amy a'ta, ety awongatan mo'ko jumynano. ");
INSERT INTO car_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Erome yturu'po atandy'mo'pa man. O'to ko wykatan? ‘Papa, ero ijururu 'wa kuwaporimakapoko.’? Ero 'wano ero ijururu ta tywo'se wa. ");
INSERT INTO car_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Papa, ajety awongapoko.” Irombo kapu wyino amy auranano wota'po: “Sawongapoi terapa. Sawongapotake rapa te.” ");
INSERT INTO car_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Eta'po mero ty'waine, mo'karon ekosa aitonon kari'na 'wa konomeru mory me ekarity'po. Amykonymbo wyka'san te: “Amy kapu tano apojonano nauranai I'wa.” ");
INSERT INTO car_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesus wyka'po te: “Yjupu'po me kapyn moro auranano nauranai, ajupu'san me te. ");
INSERT INTO car_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Erome ero nono poko a'wembono auranano ytopo jururu nitundai. Erome kurandonaka ero nono jopotory ematopo jururu nitundai. ");
INSERT INTO car_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ero nono wyino yjawonga'po mero, pa'poro kari'na sityngata'ton y'wa.” ");
INSERT INTO car_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Moro one wara tyrombyry man poko moro wara aurana'po. ");
INSERT INTO car_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Irombo mo'karon kari'na apyimy wyka'po i'wa: “Mo'ko Mesias wairy man roten ekari'san na'na 'wa moro omenano karetary. One wara ko iro ke mo'ko kari'na ymuru awongary man mekari'san? Noky ko mo'ko kari'na ymuru nan?” ");
INSERT INTO car_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesus wyka'po i'waine: “Akore'pe noro waty moro aweinano ajekosaine kynaitan. Itopo'toko, ajekosaine moro aweinano a'ta ro'kon, aporomu'ka'paine moro ewa'rumy waito'me. Mo'ko ewa'rumy ta ytopo'toto oja tytory anukuty'pa man. ");
INSERT INTO car_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ajekosaine moro aweinano a'ta ro'kon, moro aweinano amyikatoko. Iwara ro aweinano y'makon me maita'ton.” Moro wara tyka'po mero, Jesus wyto'po. Iwyinoine iwotunemy'po. ");
INSERT INTO car_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","O'toro 'ko waty kapu wyinonokon otykon enepo'san se'me i'wa tombataine, anamyika'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Iwara ro ero mo'ko Tamusi auran uku'ponenymbo Jesaja wykatopombo wo'kapy'po: Jopoto, noky ko moro na'na netapo'po amyikai? Noky 'wa ko moro Tamusi ainary nasenepoi? ");
INSERT INTO car_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Amyikary upi'po i'waine ero wara mo'ko Jesaja wyka'po ke enapa: ");
INSERT INTO car_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Tanupu'to i'wa mandon. Ituru'san tyja'naka i'wa man. Otymbo ro anene'pa kynaita'ton. Ituru'san otymbo ro anukuty'pa kynaitan. Atu'ma'pa pairo kynaita'ton. Iwara anikura'ma'paine waitake. ");
INSERT INTO car_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Moro wara Jesaja tyka tywaije man, moro Jesus kuranory ene'po ke ty'wa. Mo'ko poko ro taurana tywaije man. ");
INSERT INTO car_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ise'me pyime Simosu jopotorykon 'wa amyika'po. Mo'karon Farise nendojatokon te. Iro ke ro moro ty'waine Jesus amyikary uku'pory 'se'pa kynatokon. Ka'pa rapa Simosu wota'nano'to'kon auto wyino imomarykon. ");
INSERT INTO car_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kari'na 'wa totykon awongary irombo apokupeine 'ne ka'tu rapa kynakon moro Tamusi 'wa totykon awongary ko'po. ");
INSERT INTO car_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Irombo mo'ja Jesus wyka'po: “Mo'ko yjamyikanen awu yjamyika'pa man. Mo'ko yjemo'nenymbo amyikanon te. ");
INSERT INTO car_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Mo'ko yjenenen mo'ko yjemo'nenymbo enejan. ");
INSERT INTO car_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Awu aweinano me ero nono tu'ponaka tywo'se wa. Iwara pa'poro yjamyikanen ewa'rumy ta e'i'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Amy 'wa yjauran eta'poto, irombo anapo'i'pa a'ta, awu a'wembono auranano anyry'pa waitake ipoko. Ero nono poko a'wembono auranano yje kapyn tywo'se wa, ero nono aijoma te. ");
INSERT INTO car_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mo'ko yjurumenanen 'wano me, mo'ko yjauran anapo'ipyn 'wano me amy a'wembono auranano ynen jopoto terapa man. Moro yjauranymbo a'wembono auranano ytan ipoko moro irombo ro kurita. ");
INSERT INTO car_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Aseke awu aurana'pa wa. Mo'ko yjemo'nenymbo jumynano 'wa te o'to ywykary man takari'se man. ");
INSERT INTO car_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Moro ikatopombo wairy suku'sa i'matypyn amano me. Moro y'wa mo'ko jumynano wyka'po wara ro pa'poro morokon ywykato'kon man.” ");
INSERT INTO car_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mo'ko eratonomapotopombo onory ewa'mary wopyry uwaporo tuku'se terapa Jesus 'wa kynakon moro nono wyino mo'ko jumynano 'wa tywomimatopo jururu tunda'po. Iro ke ro mo'karon ero nono tu'po tywyinonokon tynipynarykon pynary enepory 'se imero kynakon. ");
INSERT INTO car_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Endameno kynakon. Moro jako mo'ko Simon Iskariot ymuru Judas turu'po taka mo'ko ewa'rumy tamuru 'wa moro Jesus ekaramato'man onumengano tyje terapa kynakon. ");
INSERT INTO car_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Mo'ko jumynano 'wa tainaka pa'poro oty yry'po, moro Tamusi wyino tywopy'po, moro Tamusi 'wa tytory man enapa uku'sakon mo'ko Jesus. ");
INSERT INTO car_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Irombo moro endameno wyino awomy'po. Moro itu'pono tywo'my so'ka'po i'wa. Amy kamisa ke iwoku'my'po. ");
INSERT INTO car_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Irombo amy parapi taka tuna yry'po mero ty'wa, mo'karon tynemeparykon pupuru ku'mityry a'mo'po i'wa. Morokon ipupurukon y'kokakon moro tywoku'mytopo kamisa ke. ");
INSERT INTO car_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Irombo Simon Petrus 'wa itunda'po. Mo'ko wyka'po I'wa: “Jopoto, amoro ypupuru miku'mi'tan?” ");
INSERT INTO car_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesus wyka'po eju'to'me: “Moro o'to ywairy anukuty'pa mana erome. Aire te muku'take.” ");
INSERT INTO car_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrus wyka'po I'wa: “Ypupuru aniku'mity'pa te maitake.” Jesus wyka'po te eju'to'me: “Aku'mity'pa yja'ta, ywyinono kapyn amoro mana.” ");
INSERT INTO car_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Irombo Petrus wyka'po I'wa: “Jopoto, ypupuru roten kapyn, yjainary enapa te, yjupu'po enapa iku'mi'ko.” ");
INSERT INTO car_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesus wyka'po i'wa: “Mo'ko ekupi'po tykoroka imero man. Typupuru ku'mityry roten i'wa man. Amyjaron enapa tykoroka mandon. Pa'poro 'ne kapyn te.” ");
INSERT INTO car_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Noky 'wa takaramary man uku'sakon irombo. Iro ke ro ika'po: “Pa'poro 'ne kapyn tykoroka mandon.” ");
INSERT INTO car_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Morokon ipupurukon ku'mity'ma'san mero ty'wa, moro itu'pono tywo'my e'moky'po rapa i'wa. Irombo iwendame'po rapa. Ika'po i'waine: “O'to ywe'i'po muku'saton? ");
INSERT INTO car_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Amepanen me, Jopoto me enapa kajatojaton. Iporo ro moro wara kajatojaton. Inoro ro irombo awu wa. ");
INSERT INTO car_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Awu morokon apupurukon siku'mityi Ajopotorykon me, Ajemepanamon me enapa. Iro ke ro o'waine enapa ase'wa apupurukon ku'mityry man. ");
INSERT INTO car_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Oty senepoi o'waine. Moro o'to ywe'i'po wara ro awairykon enapa man. ");
INSERT INTO car_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ita'ro pore, amy pyitonano mo'ko tyjopotory ko'po e'i'pa man. Amy apojoma'po enapa mo'ko tapojomanenymbo ko'po e'i'pa man. ");
INSERT INTO car_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sara'me 'ne janon maita'ton, moro ukutyry jako o'waine, iwara enapa awairykon jako. ");
INSERT INTO car_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Pa'poro 'ne kapyn apokoine moro wara wykaje. Moro y'wa no'kan apo'i'san suku'sa. Iporo te ero imero'po wairy man: “Mo'ko ymaro endametoto kynotu'manon ywyino.” ");
INSERT INTO car_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Erome ro sekari'sa terapa o'waine, moro iwo'kapyry uwaporo. Iwara ro iwo'kapyry jako mamyikata'ton inoro me ro ywairy. ");
INSERT INTO car_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ita'ro pore, mo'ko amy ynemoky'po ewa'manen yjewa'manon. Mo'ko yjewa'manen te mo'ko yjemo'nenymbo ewa'manon.” ");
INSERT INTO car_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Moro wara tyka'po mero kata'mato Jesus we'i'po. Ero wara oty amyikapo'po: “Ita'ro pore, o'win amy aja'sakarykon yjekaramatan.” ");
INSERT INTO car_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Mo'karon inemeparykon wo'poty'san asembata. Noky 'wa ikary anukuty'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","O'win amy inemepary, mo'ko poto me inipynary, aporito kynakon. ");
INSERT INTO car_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Mo'ko 'wa ro tupu'po ke Simon Petrus wyka'po, iwoturupoto'me noky 'wa ikary poko. ");
INSERT INTO car_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Mo'ko wotu'ma'po ro Jesus 'wa. Ika'po I'wa: “Jopoto, noky 'wa ko mykanon?” ");
INSERT INTO car_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesus wyka'po eju'to'me: “Mo'ko yna'pi'po perere punu'po sytake i'wa inoro, inoro ro mo'ko man.” Irombo amy perere punu'po a'pi'po i'wa. Yry'po i'wa mo'ko Simon Iskariot ymuru Judas 'wa. ");
INSERT INTO car_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas 'wa perere punu'po apo'i'po mero, mo'ko Satan wo'my'po ija'mun taka. Jesus wyka'po i'wa: “Moro anikapyry sanory ika'ta terapa.” ");
INSERT INTO car_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Amy pairo endametoto oty 'wa ikary anukuty'pa kynakon. ");
INSERT INTO car_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ekosa moro pyrata je'ny wairy ke, amykonymbo ero wara Jesus wykary ekano'satokon: “Mo'ko eratonomapotopombo onory ewa'mato'me kynisanorykon otykon epeka'tango.” Ero wara ikary ekano'satokon enapa: “Mo'karon ipyrata'non 'wa pyrata amy ytango.” ");
INSERT INTO car_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Moro perere punu'po apo'i'po mero ty'wa, Judas wepa'ka'po. Tyko'manje terapa moro jako kynakon. ");
INSERT INTO car_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Mo'ko Judas wepa'ka'po mero, Jesus wyka'po: “Erome mo'ko kari'na ymuru kuranory kynonepojan. Irombo ita mo'ko Tamusi kuranory kynonepojan. ");
INSERT INTO car_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ita mo'ko Tamusi kuranory wonepo'poto, tyta enapa mo'ko Tamusi ikuranory enepotan. O'win wytory kynenepotan. ");
INSERT INTO car_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Y'makon, akore'pe noro e'i'pa waitake ajekosaine. Kupita'ton. Mo'karon Simosu 'wa ywyka'po wara enapa erome wykaje o'waine: ‘Ywytotopo 'wa awopyrykon mupijaton amyjaron.’ ");
INSERT INTO car_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Asery me wykaje o'waine: Ase'wa awaipynarykon man. Moro y'wa apyna'san wara ro awaipynarykon man. ");
INSERT INTO car_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ara'naine aipynano a'ta, ynemeparykon me awairykon uku'ta'ton pa'poro kari'na.” ");
INSERT INTO car_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Irombo Simon Petrus wyka'po I'wa: “Jopoto, oja ko my'tan?” Jesus wyka'po eju'to'me: “Moro ywytotopo 'wa erome ywena'po ta awopyry mupija. Aire te moro 'wa ywena'po ta mo'take.” ");
INSERT INTO car_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrus wyka'po I'wa: “Jopoto, o'tono'me ko erome awena'po ta ywopyry supijan? Yjemamyry pairo sytake ajupu'po me.” ");
INSERT INTO car_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesus wyka'po eju'to'me: “Ajemamyry pairo my'tan yjupu'po me? Ita'ro pore, korotoko ko'tary uwaporo, oruwamboto yjukuty'pa awairy mekari'take.” ");
INSERT INTO car_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Kata'mato kytaiton. Tamusi amyikatoko. Kamyikatoko enapa. ");
INSERT INTO car_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mo'ko yjumy auty ta pyime aitopo man. Moro wara e'i'pa a'ta irombo sekarityryine o'waine. Awaito'kon man kura'ma wy'sa. ");
INSERT INTO car_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ikura'ma'san mero wo'take rapa ajaijeine. Iwara ro moro ywaitopo po amyjaron enapa maita'ton. ");
INSERT INTO car_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Moro ywytotopo emary muku'saton.” ");
INSERT INTO car_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas wyka'po I'wa: “Jopoto, moro awytotopo anukuty'pa na'na man. One wara ko moro oma ukutyry taro na'na nan?” ");
INSERT INTO car_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Irombo Jesus wyka'po i'wa: “Awu, moro oma, moro iporo aino, moro amano awu wa. Ypato roten mo'ko jumynano 'wa tytundary taro kari'na man. ");
INSERT INTO car_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Yjukutyry jako o'waine, mo'ko yjumy enapa muku'ta'ton. Erombo poro muku'ta'ton. Tone o'waine man.” ");
INSERT INTO car_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filipus wyka'po I'wa: “Jopoto, mo'ko jumynano enepoko na'na 'wa. Moro iporo terapa na'na 'wa kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesus wyka'po i'wa: “Filipus, akore'pe terapa ajekosaine ywairy se'me yjukuty'pa noro man? Mo'ko yjenenenymbo 'wa mo'ko jumynano tone man. One wara iro ke mykanon: ‘Mo'ko jumynano enepoko na'na 'wa.’? ");
INSERT INTO car_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mo'ko jumynano ta ywairy, moro yta mo'ko jumynano wairy enapa anamyika'pa man? Morokon o'waine ywykato'kon otykon, aseke yjauran kapyn morokon man. Mo'ko yta aitoto jumynano te morokon tamamingon ka'san. ");
INSERT INTO car_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mo'ko jumynano ta ywairy, moro yta mo'ko jumynano wairy enapa amyikatoko yjauran poko. Moro wara anamyika'pa aja'taine, morokon ynikapy'san amaminano poko roten amyikatoko. ");
INSERT INTO car_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Ita'ro pore, mo'ko yjamyikanen morokon ynikapyry amaminano ka'tan aseke enapa. Potonon 'ne ka'tu rapa otykon ka'tan. Awu irombo mo'ko jumynano 'wa wy'sa. ");
INSERT INTO car_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Morokon yjety ta awoturupoto'kon sika'take. Iwara ro mo'ko jumynano kuranory kynonepotan mo'ko ymunano ta. ");
INSERT INTO car_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Morokon y'wa awoturupoto'kon sika'take awu.” ");
INSERT INTO car_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Ypynary jako o'waine, morokon ywykato'kon mapyita'ton. ");
INSERT INTO car_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Awu mo'ko jumynano 'wa waturupotake. Irombo ajepano'namon me amy terapa ytan o'waine, mo'ja ro ajekosaine iwaito'me. ");
INSERT INTO car_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mo'ko iporono oty eneponen a'kanano mo'ko man. Apyiry upijan ero nono, anene'pa tywairy ke, anukuty'pa tywairy ke enapa. Amyjaron te muku'saton, ajekosaine iwairy ke, otaine iwairy man ke enapa. ");
INSERT INTO car_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“A'saka'pa ano'paine wa. Wo'take rapa o'waine. ");
INSERT INTO car_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ko'i terapa yjeneke'tan ero nono. Amyjaron te kaneta'ton. Nuro irombo awu wa. Amyjaron enapa mo'ja ro nuro maita'ton. ");
INSERT INTO car_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Moro kurita muku'ta'ton mo'ko yjumy ta ywairy, moro yta awairykon, moro otaine ywairy enapa. ");
INSERT INTO car_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mo'ko ywykato'konymbo uku'nenymbo, apyinamonymbo enapa ypynanen me man. Mo'ko ypynanen pynatan mo'ko yjumy. Awu enapa sipynatake. Wonepotake i'wa.” ");
INSERT INTO car_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","“Mo'ko Judas, mo'ko Iskariot kapyn te, wyka'po I'wa: “Jopoto, o'tono'me ko na'na 'wa monepotan, ero nono 'wa kapyn te?” ");
INSERT INTO car_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesus wyka'po eju'to'me: “Mo'ko ypynanen moro yjauran apyitan. Mo'ko yjumy kynipynatan. I'wa kyny'tan na'na. Ekosa kynemandan na'na. ");
INSERT INTO car_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mo'ko ypynapyn moro yjauran anapo'i'pa man. Moro anetarykon auranano, yjauran kapyn moro man. Mo'ko yjemo'nenymbo jumynano auran te moro man. ");
INSERT INTO car_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Moro wara wykaje o'waine, ajekosaine noro yja'ta. ");
INSERT INTO car_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mo'ko kari'na epano'nen te, mo'ko Tamusi a'kary, mo'ko yjety ta mo'ko jumynano kynemo'tan inoro ajemepata'ton pa'poro oty poko. Pa'poro morokon ywykato'konymbo otykon poko atuwaro'mata'ton rapa. ");
INSERT INTO car_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Sara'me amano sinoja ajekosaine. Moro yjekosano sara'me aino syja o'waine. Ero nono 'wa yry wara anyry'pa o'waine wa awu. Kytesykaton. Kytety'katon. ");
INSERT INTO car_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ero wara ywykary tota o'waine man: ‘Wy'sa. Wo'take rapa te o'waine.’ Ypynary jako rypo o'waine, tawa'pore maitory mo'ko jumynano 'wa ywytory poko. Mo'ko jumynano irombo poto me man yko'po. ");
INSERT INTO car_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Erome ro sekarityi terapa o'waine, moro iwo'kapyry uwaporo. Iwara ro iwo'kapyry jako mamyikata'ton. ");
INSERT INTO car_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Pyime noro ajerupa'paine waitake. Ero nono jopotory irombo kyno'san terapa. O'to te yjyry upijan. ");
INSERT INTO car_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ero nono 'wa te moro y'wa mo'ko jumynano pynary ukutyry man. Mo'ko jumynano wykato'konymbo wara ro y'wa oty kapyry ukutyry enapa man ero nono 'wa. Ajawondoko. Ka'makon ero wyino.” ");
INSERT INTO car_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Moro winu me tykapymy wonatopo 'ne ro awu wa. Mo'ko yjumy, mo'ko maina aporemy mo'ko man. ");
INSERT INTO car_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Pa'poro epetapyn yporiry y'kotojan. Pa'poro apetatoto yporiry korokanon, epetato'me 'ne ka'tu rapa. ");
INSERT INTO car_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Amyjaron tykoroka terapa mandon moro o'waine ywykato'konymbo auranano 'wa. ");
INSERT INTO car_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yta aitoko, otaine ywairy wara. Moro porinano aseke tapetary upijan, moro winu me tykapymy wonatopo epy poko e'i'pa ta'ta. Moro wara amyjaron enapa ajepetarykon mupita'ton, yta e'i'pa aja'taine. ");
INSERT INTO car_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Moro winu me tykapymy wonatopo awu wa. Morokon porinano amyjaron mandon. Mo'ko yta aitoto, mo'ko ita wa inoro pyime kynepetanon. Ypyndo irombo o'to pairo awairykon mupijaton. ");
INSERT INTO car_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mo'ko yta e'i'pa aitoto emata'ton, moro wonatopo pori'po emary wara. Irombo kynajutanon. Moropangonymbo a'nano'saton. Wa'to taka kynematon. Irombo kynikoro'san. ");
INSERT INTO car_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yta aja'taine, otaine enapa morokon yjauranymbo a'ta, pa'poro anisanorykon poko aturupotoko. Irombo mapyita'ton. ");
INSERT INTO car_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Moro pyime ajepetarykon, moro ynemeparykon me awairykon enapa mo'ko yjumy kuranory enepojan. ");
INSERT INTO car_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Mo'ko yjumy 'wa ypynary wara enapa awu kypynaton. Moro ypyny ta ro aitoko. ");
INSERT INTO car_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Morokon ywykato'konymbo apyiry jako o'waine, moro ypyny ta roten maita'ton. Iwara enapa mo'ko yjumy wykato'konymbo sapyija. Iwara ro moro ipyny ta roten wa. ");
INSERT INTO car_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Moro wara wykaje o'waine, otaine moro yjewa'pory waito'me, atamonopy'pa moro ajewa'porykon waito'me. ");
INSERT INTO car_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Ero wara wykaje o'waine: Ase'wa aipynatoko, moro y'wa apyna'san wara enapa. ");
INSERT INTO car_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Moro a'sakanano upu'po me romo'no ko'pono aipynano waty man. ");
INSERT INTO car_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yja'sakarykon me mandon, morokon ywykato'kon kapyry jako o'waine. ");
INSERT INTO car_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pyitonano me noro rapa ajejato'paine wa. Mo'ko pyitonano irombo mo'ko tyjopotory nikapyry oty anukuty'pa man. Amyjaron te, yja'sakarykon me 'ne ro mandon. Pa'poro mo'ko yjumy wyino yneta'san otykon irombo suku'poi o'waine. ");
INSERT INTO car_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","O'waine kapyn tapyije wa. Y'wa te tapyije mandon. Y'wa ro tapojoma mandon apeta awytoto'ko'me, morokon ajeperykon waito'me roten enapa. Irombo pa'poro yjety ta ty'wa awoturupoto'kon ytan mo'ko jumynano o'waine. ");
INSERT INTO car_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ero wara wykaje o'waine: Ase'wa aipynatoko.” ");
INSERT INTO car_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Ero nono 'wa ajenonopyrykon jako, awu na'nen i'wa yjenonopy'po uku'toko. ");
INSERT INTO car_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ero nono wyinonokon me awe'i'sanymboto, apynatory amy ty'wano oty pynary wara. Ero nono wyinonokon me kapyn awairykon ke te, ero nono wyino y'wa ajapo'i'san ke, ero nono ajenono'saton. ");
INSERT INTO car_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Onumengatoko rapa ero ywykatopombo poko: ‘Amy pyitonano mo'ko tyjopotory ko'po poto me e'i'pa man.’ Kari'na erekuru 'wa ywekena'pomboto, amyjaron enapa moro erekurukon awekenata'ton. Yjauranymbo apo'i'pomboto i'waine, ajaurangon apyita'ton enapa. ");
INSERT INTO car_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Moro wara te kari'na erekuru awekenata'ton yjety upu'po me. Mo'ko yjemo'nenymbo anukuty'pa irombo mandon. ");
INSERT INTO car_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Opy'pa ywe'i'pomboto, anerupa'paine ywe'i'pomboto, u'tano'ma naitory. Erome te moro tyja'wanykonymbo pyi'me'tory upijaton. ");
INSERT INTO car_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mo'ko yjenono'nen mo'ko yjumy jenono'san enapa. ");
INSERT INTO car_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Morokon kari'na nikapy'torykonymbo otykon anikapy'pa ira'naine ywe'i'pomboto, u'tano'ma naitory. Erome te morokon ynikapy'san otykon eneton. Ise'me te yjenono'saton. Mo'ko yjumy jenono'saton enapa. ");
INSERT INTO car_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ero auranano, moro omenano karetary ta tymero man iro wo'kapyry te kynakon: “Typo roten yjenono'ton.” ");
INSERT INTO car_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Mo'ko yjumy ekosa yja'ta, mo'ko kari'na epano'nen, iporono oty eneponen a'kanano, mo'ko yjumy wyino kyno'san inoro semo'take o'waine. Mo'ko ro oty amyikapotan ypoko. ");
INSERT INTO car_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Amyjaron enapa te oty mamyikapota'ton. Penaro terapa irombo yjekosa mandon.” ");
INSERT INTO car_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Morokon otykon sekarityi o'waine, omapoty'pa awaito'ko'me. ");
INSERT INTO car_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Morokon tywota'nano'to'kon auto wyino amomata'ton. Amy kurita pa'poro mo'karon awonamon kari'na Tamusi ety awongatopo amaminano kapyry ekano'ta'ton pairo ty'waine. ");
INSERT INTO car_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Moro wara kynaita'ton, mo'ko jumynano anukuty'pa, yjukuty'pa enapa tywairykon ke. ");
INSERT INTO car_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Morokon otykon te sekarityi o'waine, moro ipokoine yjaurana'po poko awetuwaro'mato'ko'me rapa moro iwo'kapyrykon mero. Uwapo morokon otykon poko aurana'pa we'i, ajekosaine ywairy ke.” ");
INSERT INTO car_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Erome te wy'sa mo'ko yjemo'nenymbo 'wa. Aturupo'pa pairo te mandon moro oja ywytory poko. ");
INSERT INTO car_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Morokon otykon ekarity'po ke y'wa, suku'sa morokon aturu'san a'no'ka'san kata'mato aino 'wa. ");
INSERT INTO car_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Iporo te wykaje o'waine: Moro ywytory o'wanokon me iru'pa man. Ito'pa yja'ta irombo mo'ko kari'na epano'nen opy'pa o'waine kynaitan. Ywyto'po mero te semo'take o'waine. ");
INSERT INTO car_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tywopy'po mero oty me yja'wan me aino wairy, oty me tamambore aino wairy, oty me a'wembono auranano yry wairy enepotan ero nono 'wa. ");
INSERT INTO car_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yja'wan me aino enepotan moro yjamyika'pa iwairykon ke. ");
INSERT INTO car_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tamambore aino enepotan moro jumynano 'wa ywytory ke, moro yjene'pa noro awairykon ke enapa. ");
INSERT INTO car_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","A'wembono auranano yry enepotan mo'ko nono jopotory poko a'wembono auranano yry'po ke. ");
INSERT INTO car_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Pyime noro otykon ekarityry y'wa man o'waine. Apyiry te mupijaton erome. ");
INSERT INTO car_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tywopy'poto te mo'ko iporono oty eneponen a'kanano pa'poro iporono oty enepotan o'waine. Aseke tauran anekarity'pa kynaitan. Morokon tyneta'san otykon ekari'tan te. Morokon o'tonon otykon ekarotan o'waine. ");
INSERT INTO car_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Mo'ko ro yjety awongatan. Pa'poro o'waine tynekarory man apyitan irombo ywyino. ");
INSERT INTO car_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Pa'poro mo'ko jumynano ekosanokon otykon, yjotyrykon morokon man. Iro ke ro wykai o'waine: ‘Pa'poro o'waine tynekarory man apyijan ywyino.’ ” ");
INSERT INTO car_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ko'i terapa kaneke'ta'ton. Irombo mero ko'i terapa kaneta'ton rapa.” ");
INSERT INTO car_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Irombo amykon inemeparykon wyka'san ase'wa: “O'to ika'po ko ero nan: ‘Ko'i terapa kaneke'ta'ton. Irombo mero ko'i terapa kaneta'ton rapa.’? O'to ika'po ko rapa ero nan: ‘Wy'sa mo'ko jumynano 'wa.’?” ");
INSERT INTO car_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ika'san: “O'to tauro'po ko moro ‘ko'i terapa’ nan? O'to ikary anukuty'pa kytaton.” ");
INSERT INTO car_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","“Amy oty poko tywoturuporykon 'se iwairykon ukuty'po Jesus 'wa. Irombo ika'po i'waine: “Ase'wa morupaton moro ero wara ywyka'po poko: ‘Ko'i terapa kaneke'ta'ton. Irombo mero ko'i terapa kaneta'ton rapa.’? ");
INSERT INTO car_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ita'ro pore, amyjaron turare maita'ton. Matamota'ton. Ero nono te tawa'pore kynaitan. O'waine je'tun pe oty kynaitan. Moro je'tunano te kyne'petakamatan awa'ponano me. ");
INSERT INTO car_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Amy onematoto woryi je'tunano apojan, moro tywonematopo jururu tunda'po ke. Tywonema'po mero te moro je'tunano poko noro onumenga'pa man. Tawa'pore irombo man moro ty'wa ero nono tu'ponaka amy kari'na yry'po poko. ");
INSERT INTO car_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Iwara enapa erome oty je'tun pe o'waine man. Moro y'wa ajenerykon jako rapa te tawa'pore moro aturu'san kynaitan. Irombo amy pairo moro ajewa'porykon anipina'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Moro jako amy pairo oty poko y'wa aturupo'pa maita'ton. Ita'ro pore, amy oty poko yjety ta mo'ko jumynano 'wa awoturupo'sando, kynytan o'waine. ");
INSERT INTO car_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Erome noro yjety ta oty poko aturupo'pa mandon. Aturupotoko. Irombo mapyita'ton. Iwara ro atamonopy'pa moro ajewa'porykon kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Amy waretatoto wara morokon otykon sekarityi o'waine. Amy jako te waretatoto wara noro aurana'pa o'waine waitake. Tywotuku'se me te mo'ko jumynano poko oty sekari'take o'waine. ");
INSERT INTO car_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Moro kurita yjety ta oty poko maturupota'ton. Ajekatakaine mo'ko jumynano 'wa ywoturupory man anekarity'pa o'waine wa. ");
INSERT INTO car_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mo'ko jumynano irombo aseke apynaton, moro o'waine ypynary ke, moro o'waine Tamusi wyino ywopy'po amyikary ke enapa. ");
INSERT INTO car_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mo'ko jumynano wyino tywo'se wa ero nono tu'ponaka. Wy'sa rapa ero nono wyino mo'ko jumynano 'wa.” ");
INSERT INTO car_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Mo'karon inemeparykon wyka'san i'wa: “Erome tywotuku'se me imero ajauranaje, waretatoto wara kapyn pairo. ");
INSERT INTO car_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Erome moro o'wa pa'poro oty ukutyry uku'san na'na. O'wa kapyn oty poko kari'na woturupory man. Moro poko Tamusi wyino awopy'po amyikanon na'na.” ");
INSERT INTO car_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesus wyka'po eju'to'ko'me: “Erome te mamyikaton? ");
INSERT INTO car_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kyno'san, tywo'se terapa man moro aseke ajautykon 'wa pa'poro awotaripa'to'kon jururu, moro o'waine o'win upu'po ynotopo jururu. O'win upu'po kapyn te wa. Mo'ko jumynano irombo ymaro man. ");
INSERT INTO car_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Morokon sekarityi o'waine, yta sara'me aino epoto'me. Ero nono tu'po mata'karykaton. Aturu'san te apyitoko. Ero nono si'mondoi.” ");
INSERT INTO car_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Moro wara tyka'po mero Jesus wo'poty'po kapu 'wa. Ika'po: “Papa, moro ijururu nitundai. Omuru ety awongako, omuru 'wa ajety awongato'me. ");
INSERT INTO car_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Pa'poro kari'na irombo ainaka tyje o'wa man, pa'poro ty'wa anyry'san kari'na 'wa i'matypyn amano yto'me i'wa. ");
INSERT INTO car_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Moro i'matypyn amano tauro'po 'kuru man moro kari'na 'wa ajukutyry, moro i'waine mo'ko o'win'kono iporono Tamusi ukutyry, moro i'waine mo'ko anemoky'po Jesus Kristus ukutyry enapa. ");
INSERT INTO car_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Awu ajety sawongai ero nono tu'po, moro y'wa ika'to'me anyry'po amaminano kapy'mary ke. ");
INSERT INTO car_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Papa, amoro moro awaitopo po yjety awongako, moro awaitopo po ero nono wairy uwaporo yjety awonga'po wara ro rapa. ");
INSERT INTO car_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Moro ajety sekaroi mo'karon ero nono wyino y'wa anyry'san kari'na 'wa. O'wanokon me terapa kynatokon. Irombo yjainaka tyje tywaije o'wa mandon. Moro ajauran tapyije i'waine man. ");
INSERT INTO car_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Awyino pa'poro y'wa anyry'san otykon wairy uku'saton erome. ");
INSERT INTO car_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Morokon y'wa anekari'po'san otykon sekarityi i'waine. Mo'karon ro kynapyisen. Iporo ro moro awyino ywopy'po wairy uku'saton. O'wa yjemoky'po amyikaton. ");
INSERT INTO car_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“I'wanokon me o'wa waturupoja. Ero nono 'wano me kapyn waturupoja. Mo'karon y'wa anyry'san kari'na 'wano me te waturupoja. O'wanokon me irombo mo'karon mandon. ");
INSERT INTO car_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Pa'poro y'wanokon kari'na o'wanokon me mandon. Pa'poro o'wanokon kari'na y'wanokon me mandon. Mo'karon ta ro ykuranory man. ");
INSERT INTO car_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ero nono tu'po noro e'i'pa waitake. Mo'karon te ero nono tu'po kynaita'ton. Awu wo'take o'wa. Kurano papa, moro y'wa anyry'po ajety ta unendoko, kywara enapa o'win iwaito'ko'me. ");
INSERT INTO car_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ekosaine yja'ta, sunenjatokon moro y'wa anyry'po ajety ta. Saijomatokon. Amy pairo ynunemy'po utapy'pa ne'i, mo'ko uta'toto manombo rato. Moro imero'po wo'kapyry irombo ne'i. ");
INSERT INTO car_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Erome te wo'take o'wa. Ero nono tu'po te erokon otykon sekari'sa, itaine atamonopy'pa moro ewa'porykon waito'me. ");
INSERT INTO car_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ajauranymbo synen i'waine. Ero nono kynijenono'saton, ywara enapa ero nono wyino kapyn iwairykon ke. ");
INSERT INTO car_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Waturupoja o'wa ero nono wyino ipinato'ko'me kapyn, aijomato'ko'me te mo'ko yja'wan wyino. ");
INSERT INTO car_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ywara enapa ero nono wyino kapyn mandon. ");
INSERT INTO car_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ikuranondotoko moro iporono ta. Moro ajauran iporono me man. ");
INSERT INTO car_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ero nono tu'ponaka o'wa yjemoky'po wara awu enapa semo'saton wararo ero nono tu'po. ");
INSERT INTO car_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Upu'san me ro wekuranondoja, mo'karon waito'me enapa moro iporono ta tykuranondo. ");
INSERT INTO car_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“I'wanokon me roten kapyn, mo'karon aurangon poko yjamyikanamon 'wano me enapa te waturupoja, ");
INSERT INTO car_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","o'win pa'poro iwaito'ko'me, kyta iwaito'ko'me enapa, papa, yta awairy wara, ota ywairy wara enapa. Irombo mero moro o'wa yjemoky'po amyikatan ero nono. ");
INSERT INTO car_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Moro y'wa anyry'po kurano syryi i'waine, kywara enapa o'win iwaito'ko'me, ");
INSERT INTO car_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","awu itaine, amoro yta. Iwara oty anamonopy'pa o'win kynaita'ton. Iwara moro o'wa yjemoky'po uku'tan ero nono. Moro o'wa ypyna'po wara o'wa ipynarykon uku'tan enapa. ");
INSERT INTO car_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Papa, mo'karon y'wa anyry'san kari'na wairy 'se wa moro oje ywaitopo po ro. Irombo mero moro y'wa anyry'po kurano eneta'ton. Typyna irombo o'wa tywaije wa ero nono wo'kapyry uwaporo. ");
INSERT INTO car_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tamamboren papa, ero nono ajukuty'pa man. Awu te kuku'sa. Mo'karon te moro o'wa yjemoky'po uku'saton. ");
INSERT INTO car_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Moro ajety sekaroi i'waine. Mo'ja ro enapa sekarotake, moro o'wa ypynatopo aipynano waito'me itaine, ywaito'me enapa itaine.” ");
INSERT INTO car_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Moro wara tyka'po wyino Jesus 'wa mo'karon tynemeparykon maro moro i'poriry Kidron pato'po. Moro pato ro amy wonatopo paty maina kynakon. Moro taka ito'po mo'karon tynemeparykon maro. ");
INSERT INTO car_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mo'ko ekaramanen Judas enapa moro maina uku'sakon. Moro 'wa ro irombo Jesus mo'karon tynemeparykon arojakon o'kapyn. ");
INSERT INTO car_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Moro 'wa ro Judas wyto'po amy warinu pokonokon apyimy maro, amykon Tamusi auty erangon, mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon Farise 'wa enapa tomo'se kynatokon inaron maro enapa. Turi, kororeta, o'woto'kon enapa ekosaine kynatokon. ");
INSERT INTO car_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus pa'poro morokon toponamon man otykon uku'sakon. Iwepa'ka'po. Ika'po mo'karon o'tonon 'wa: “Noky ko mupijaton?” ");
INSERT INTO car_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ika'san eju'to'me: “Mo'ko Nasaret pono Jesus.” Ika'po i'waine: “Inoro ro awu wa.” Mo'karon opy'san ekosa ro mo'ko ekaramanen Judas enapa kynakon. ");
INSERT INTO car_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Moro “Inoro ro awu wa,” ika'po mero mo'karon kari'na wyto'san wena'po taka. Nono tu'ponaka iwo'papy'san. ");
INSERT INTO car_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesus woturupo'po rapa i'waine: “Noky ko mupijaton?” Ika'san: “Mo'ko Nasaret pono Jesus.” ");
INSERT INTO car_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesus wyka'po eju'to'ko'me: “Wykai terapa o'waine: inoro ro awu wa. Yjupiry jako o'waine, mojan yja'sakarykon aropotoko.” ");
INSERT INTO car_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Iwara ero auranymbo wo'kapy'po: ‘Amy pairo y'wa anyry'po anuta'kapo'pa we'i.’ ");
INSERT INTO car_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Petrus ekosa supara kynakon. Moro so'ka'po ro i'wa. Mo'ko Tamusi pokonokon jopotory pyitory panaka'po i'wa ike. Mo'ko pyitonano ety me kynakon Malkus. ");
INSERT INTO car_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesus wyka'po te Petrus 'wa: “Moro supara e'mo'ko rapa moro ije'ny taka. Moro y'wa mo'ko yjumy nyry'po sapera anenyry'pa ka'tu ywairy man mekano'san?” ");
INSERT INTO car_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Mo'karon warinu pokonokon apyimy 'wa, mo'ko ijopotorykon 'wa, mo'karon Simosu nemoky'san Tamusi auty erangon 'wa Jesus apo'i'po. Apomy'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mo'ko Anas 'wa na'nen aro'po i'waine. Mo'ko ro mo'ko Kajafas y'metamuru me kynakon. Kajafas ro moro siriko Tamusi pokonokon jopotory me kynakon. ");
INSERT INTO car_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mo'ko ro enapa, mo'ko ero wara mo'karon Simosu jopotorykon urunenymbo mo'ko kynakon: “Kari'na upu'san me o'win kari'na rombyry iru'pa man.” ");
INSERT INTO car_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesus wekena'po Simon Petrus 'wa amy enapa inemepary maro. Mo'ko inemepary ro mo'ko Tamusi pokonokon jopotory nukutyry mo'ko kynakon. Jesus maro iwo'my'po mo'ko Tamusi pokonokon jopotory auty pyrorory taka. ");
INSERT INTO car_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Petrus poropy'po te kurando moro pena po. Irombo mo'ko Tamusi pokonokon jopotory nukutyry Jesus nemepary wepa'ka'po. Mo'ko pena eran me aitoto woryi erupa'po i'wa. Irombo Petrus a'myka'po i'wa. ");
INSERT INTO car_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Mo'ko pena eran wyka'po ro Petrus 'wa: “Amoro enapa kapyn mo'ko wokyry nemepary amy amoro man?” Petrus wyka'po te: “Uwa, amy kapyn awu wa.” ");
INSERT INTO car_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ty'sanore iwairy ke, mo'karon pyitonano 'wa, mo'karon Tamusi auty erangon 'wa enapa wa'to'po tyka'mutano'po kynakon. Moro 'wa ro kynotasinano'pojatokon. Ekosaine ro Petrus enapa kynotasinano'pojakon. ");
INSERT INTO car_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Mo'ko Tamusi pokonokon jopotory woturupo'po Jesus 'wa mo'karon inemeparykon poko, moro inyry omepano poko enapa. ");
INSERT INTO car_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesus wyka'po eju'to'me: “Kurando kari'na 'wa yjauranato. Semepatoine morokon iwota'nano'to'kon auto ta, moro Tamusi auty ta enapa. Morokon po ro pa'poro Simosu kynota'nano'saton. Amy pairo oty anekarity'pa maname waito. ");
INSERT INTO car_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","O'tono'me ko y'wa maturupoja oty poko? Mo'karon ynekarity'san otykon etanamonymbo 'wa tyre aturupoko. Mo'karon o'to ywyka'po uku'saton.” ");
INSERT INTO car_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Moro wara ika'po mero, amy oranano 'wa ipasapaika'po. Ika'po: “Moro wara mo'ko Tamusi pokonokon jopotory meju'sa, hen?” ");
INSERT INTO car_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesus wyka'po eju'to'me: “Yja'wan me yjaurana'poto, ekari'ko one wara 'ne yja'wan me yjaurana'po. Iru'pa yjaurana'poto te, o'tono'me ko iro ke kywojan?” ");
INSERT INTO car_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Tapomy ro Anas 'wa Jesus emoky'po mo'ko Tamusi pokonokon jopotory Kajafas 'wa. ");
INSERT INTO car_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus te kynotasinano'pojakon noro moro wa'to 'wa. Irombo ika'san i'wa: “Amoro enapa kapyn amy inemepary amoro man?” Petrus wyka'po te: “Uwa, amy kapyn awu wa.” ");
INSERT INTO car_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Irombo mo'ko Tamusi pokonokon jopotory pyitory amy, mo'ko Petrus nipanaka'po omory me kynakon inoro wyka'po: “Moro wonatopo paty maina ta kapyn konei imaro?” ");
INSERT INTO car_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Enapitary ekarity'po rapa te Petrus 'wa. Irombo mero o'win wytory amy korotoko ko'ta'po. ");
INSERT INTO car_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Irombo Jesus aro'po i'waine mo'ko Kajafas wyino mo'ko Rome wyinono jopoto auty 'wa. Kokoro 'ne kynakon. Mo'karon Simosu we'i'san te o'my'pa. Mo'ko eratonomapotopombo kapara'membo onory 'se tywairykon ke irombo tyweja'wangarykon 'se'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Irombo Pilatus wepa'ka'po i'waine. Ika'po: “Oty poko ko mo'se wokyry memendojaton?” ");
INSERT INTO car_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ika'san eju'to'me: “Yja'wan oty ka'nen me e'i'pa a'ta, o'wa anekarama'pa na'na nairy.” ");
INSERT INTO car_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilatus wyka'po i'waine: “Arotoko iro ke. Aseke moro ajemerykon karetary wykary wara a'wembono auranano ytoko ipoko.” Mo'karon Simosu wyka'san te i'wa: “Amy pairo kari'na wory kapyn man na'na 'wa.” ");
INSERT INTO car_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iwara te moro Jesus auranymbo, moro i'wa one wara tyrombyry man ekarity'po wo'kapyry kynakon. ");
INSERT INTO car_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Irombo Pilatus wo'my'po rapa moro auto taka. Jesus ko'mapo'po i'wa. Ika'po I'wa: “Mo'karon Simosu Jopotory amoro man?” ");
INSERT INTO car_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesus wyka'po eju'to'me: “Aseke moro wara mykanon? Amykon te ka'tu ypoko ajerupaton?” ");
INSERT INTO car_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatus wyka'po eju'to'me: “Amy Simosu 'kare awu wan. Aseke aja'sakarykon, mo'karon Tamusi pokonokon jopotorykon ajekaramaton y'wa. O'to ko me'i?” ");
INSERT INTO car_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesus wyka'po eju'to'me: “Ero nono wyino kapyn moro ynundymary man. Ero nono wyino moro ynundymary a'ta rypo, mo'karon ypyitorykon no'mikatory moro Simosu 'wa yjekaramary a'kototo'me. Ero wyino kapyn te moro ynundymary man.” ");
INSERT INTO car_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilatus wyka'po I'wa: “Jopoto kapyn 'kare amoro man.” Jesus wyka'po eju'to'me: “Aseke amoro jopoto me kakari'sa. Awu typa'kano'se wa, ero nono tu'ponaka tywo'se wa moro iporono auranano amyikapoto'me. Pa'poro mo'karon iporono auranano wyinonokon yjauran 'wa kynepanamaton.” ");
INSERT INTO car_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatus wyka'po I'wa: “Oty ko moro iporono auranano nan?” Moro wara tyka'po mero, Pilatus wepa'ka'po rapa mo'karon Simosu 'wa. Ika'po i'waine: “Amy pairo oty anepory'pa we'i u'ta. ");
INSERT INTO car_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ajemerykon wararo te moro yja'wangon kari'na aru'katopo wyino o'win amy kapory y'wa man mo'ko eratonomapotopombo onory ewa'mary jako. Oty 'se ko mandon? Mo'ko Simosu Jopotory sinondapotan?” ");
INSERT INTO car_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Iko'tapoty'san: “Mo'ko kapyn. Mo'ko Barabas te.” Mo'ko Barabas ro amy tokonen manaman mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Irombo mero Pilatus 'wa Jesus ypoky'mapo'po. ");
INSERT INTO car_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mo'karon warinu pokonokon 'wa amy sipatamu waton momy'po u'mariry me. Upu'po tu'ponaka yry'po i'waine. Amy tapenen tykujuren wo'mynano ke iwo'myndo'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Irombo iwopy'san i'wa. Ika'san: “Na'na te kore awopy'po ewa'maje, Simosu Jopotory!” Ipasapaika'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilatus wepa'ka'po rapa. Ika'po i'waine: “Sipa'kaje o'waine, muku'to'se me amy pairo oty anepory'pa ywe'i'po u'ta.” ");
INSERT INTO car_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesus wepa'ka'po ro, moro sipatamu waton kapy'po u'mari ta, moro tykujuren wo'mynano ta enapa. Irombo Pilatus wyka'po i'waine: “Mo'se mo'ko wokyry.” ");
INSERT INTO car_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ene'po mero ty'waine, mo'karon Tamusi pokonokon jopotorykon ko'tapoty'san mo'karon Tamusi auty erangon maro. Ika'san: “Ipokary man! Wakapu poko ipokary man!” Pilatus wyka'po i'waine: “Arotoko. Aseke ipokatoko. Awu irombo amy pairo oty anepory'pa wa u'ta.” ");
INSERT INTO car_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Mo'karon Simosu wyka'san eju'to'me: “Omenano karetary na'na ekosa man. Moro ro irombyry man ekari'san, Tamusi ymuru me iwotyry'po ke.” ");
INSERT INTO car_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Moro eta'po mero tanarike 'ne ka'tu rapa Pilatus we'i'po. ");
INSERT INTO car_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Moro auto taka rapa iwo'my'po. Irombo Jesus 'wa iwoturupo'po: “Ojeno ko amoro man?” Anejuku'pa te Jesus we'i'po. ");
INSERT INTO car_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilatus wyka'po I'wa: “Yjerupary 'se'pa man? Yjaina anondapory wairy, apokapory wairy enapa anukuty'pa man?” ");
INSERT INTO car_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesus wyka'po eju'to'me: “Ajaina kapyn wairy, kawo wyino moro wara yry'pa iwe'i'pomboto. Iro ke ro mo'ko o'wa yjekaramanenymbo u'ta poto 'su 'ne ka'tu rapa oty man.” ");
INSERT INTO car_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Morombo wyino Pilatus wo'mika'po inondapory poko. Mo'karon Simosu ko'ta'san te. Ika'san: “Mo'ko nondapo'poto o'wa, mo'ko Rome pono jopoto pawanary kapyn amoro mana. Pa'poro aseke poto 'su jopoto me atytoto mo'ko Rome pono jopoto y'tu'kanen me man.” ");
INSERT INTO car_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Moro eta'po mero ty'wa, Pilatus 'wa Jesus pa'kapo'po. Iwotandy'mo'po moro jopoto me tywaitopo tapo'ny tu'po, moro topu ke ira'to'po aitopo, moro Simosu gabata me kynejatojaton iro po. ");
INSERT INTO car_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Kurita'ne'ne iwairy taro kynakon moro otare'matopo kurita uwaporo. Irombo Pilatus wyka'po mo'karon Simosu 'wa: “Mo'se mo'ko Ajopotorykon.” ");
INSERT INTO car_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Mo'karon ko'tapoty'san ro: “Iwory man! Iwory man! Wakapu poko ipokary man!” Pilatus wyka'po i'waine: “Mo'ko Ajopotorykon iro ke sipokapotan wakapu poko?” Mo'karon Tamusi pokonokon jopotorykon wyka'san eju'to'me: “Mo'ko Rome pono jopoto rato amy na'na jopotory waty man.” ");
INSERT INTO car_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Irombo mero Pilatus 'wa Jesus yry'po i'waine, ipokato'me. Jesus aro'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Aseke Jesus moro typokato'man wakapu arojakon. Jerusalem wyino iwepa'ka'po moro ‘U'je'pombo Waitopo’ tatynen 'wa. Golgota me mo'karon Simosu moro aitopo ejatojaton moro taurangon ta. ");
INSERT INTO car_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Moro po ro wakapu poko Jesus poka'po. Imaro oko amykon terapa poka'san, o'win amy apojery wyino, o'win amy apo'tun wyino. Jesus owarira'naine kynakon. ");
INSERT INTO car_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Paranga'membo pokapo'po enapa Pilatus 'wa mo'ko Jesus epo. Moro tu'po ro tymero kynakon: MO'KO NASARET PONO JESUS, MO'KARON SIMOSU JOPOTORY. ");
INSERT INTO car_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Moro imero'po erupa'po pyime Simosu 'wa. Tyse waty irombo Jerusalem wyino moro Jesus pokatopo kynakon. Moro oty tymero kynakon mo'karon Simosu auran ta, mo'karon Rome ponokon auran ta, mo'karon Griek auran ta enapa. ");
INSERT INTO car_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Mo'karon Tamusi pokonokon jopotorykon Simosu wyka'san Pilatus 'wa: “Mo'karon Simosu Jopotory me iwairy kysimeroi. Mo'karon Simosu Jopotory me iwokarity'po te imeroko.” ");
INSERT INTO car_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatus wyka'po te eju'to'ko'me: “Moro ynimeropo'po ani'petakama'pa waitake.” ");
INSERT INTO car_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jesus poka'po mero ty'waine, mo'karon warinu pokonokon 'wa morokon itu'ponokon iwo'mykonymbo a'saka'san okupa'en undy, tywe'i'san wara ro. Moro upi'nono iwo'mymbo te o'win kynakon. Atoky'pa moro kamisa kynakon. ");
INSERT INTO car_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Irombo ase'wa ika'san: “Aniseka'pa kytaisen. Tymeramon tapusikiri kysemasen one 'wa apyiry man uku'to'me.” Iwara ero imero'po wo'kapy'po: Morokon ywo'mykonymbo ekamy'san i'waine aseka ro. Ywo'my poko tapusikiri emapoty'san i'waine. Moro wara mo'karon warinu pokonokon we'i'san. ");
INSERT INTO car_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Moro Jesus pokatopombo wakapu ekosa kynatokon mo'ko isano, mo'ko isano pity, mo'ko Klopas pyty Maria, mo'ko Magdala pono Maria enapa. ");
INSERT INTO car_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Mo'ko isano ekosa mo'ko poto me inipynary inemepary kynakon. Ene'san mero ty'wa, Jesus wyka'po mo'ko tysano 'wa: “Mo'ko apyiko o'me me.” ");
INSERT INTO car_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Irombo mo'ko tynemepary 'wa ika'po: “Mo'ko apyiko asano me.” Morombo mero mo'ko inemepary 'wa mo'ko isano apo'i'po tokosa tauty ta. ");
INSERT INTO car_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Pa'poro oty aikepy'po uku'sakon Jesus moro jako. Irombo moro imero'po wo'ka'to'me ika'po: “Tuna 'se wa.” ");
INSERT INTO car_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Moro po ro amy parapi kynakon, ta'no'se tyjasakoren winu ke. Moro winu taka ro amy tymi'mi'ken oty u'mu'ka'po i'waine. Moro oty yry'po ro amy hysop epy pokonaka. Irombo Jesus yndary ponaka yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Moro winu amy enyry'po mero ika'po: “Naikepyi.” Irombo mero moro tupu'po sekuma'po i'wa. Iworemakepy'po. ");
INSERT INTO car_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Moro jako opy'pa noro moro otare'matopo kurita kynakon. Moro otare'matopo kurita te morokon wakapu poko mo'karon ipoka'san ekepy'san wairy 'se'pa mo'karon Simosu kynatokon. Poto me irombo moro otare'matopo kurita wairy kynakon. Iro ke ro Pilatus 'wa iwoturupo'san mo'karon ipoka'san y'sairykon ambopoto'me, morokon wakapu wyino ikato'ko'me. ");
INSERT INTO car_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Irombo mero mo'karon warinu pokonokon 'wa mo'ko Jesus maro ipoka'san y'sairykon amboty'san, mo'ko o'win amy na'nen, irombo mo'ko akono terapa. ");
INSERT INTO car_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesus 'wa tytunda'san mero te, tyromo'se terapa ene'po i'waine. Iro ke ro morokon i'sairy anamboty'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Moro isoropary puka'po te o'win amy warinu pokono 'wa typosi'ken siparari ke. O'win wytory iwyino mynu wopy'po tuna maro. ");
INSERT INTO car_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Mo'ko morokon otykon enenenymbo kynamyikapojan. Moro inamyikapory oty iporo man. Iporonokon otykon ekarityry uku'san ty'wa. O'waine enapa amyikarykon 'se man. ");
INSERT INTO car_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Moro oty tywo'ka'se man, ero imero'po wo'ka'to'me: Amy pairo ije'po amboty'pa kynaitan. ");
INSERT INTO car_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Amy oje rapa tymero man: Mo'ko inipuka'san 'wa kyno'po'ta'ton. ");
INSERT INTO car_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Morombo mero Pilatus 'wa mo'ko Arimatea pono Josef woturupo'po mo'ko Jesus ekepy'po kato'me ty'wa moro wakapu wyino. Mo'ko Josef ro amy Jesus nemepary me kynakon, maname te irombo, mo'karon Simosu jopotorykon nendory ke ty'wa. Pilatus 'wa iru'pa epory'po. Irombo Josef 'wa Jesus ekepy'po ka'po moro wakapu wyino. ");
INSERT INTO car_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Mo'ko Nikodemus wyto'po imaro. Mo'ko 'wa ro uwapo Jesus koko tatawa kynakon. Oruwa kiro iwairy taro mere maro aloe y'kaima'po Nikodemus ekosa kynakon. ");
INSERT INTO car_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Mo'ko Jesus ekepy'po pina'po i'waine. Irombo morokon typoporamon otykon maro ijasimemboty'po i'waine ty'meijamon kamisa ke. Moro wara irombo mo'karon Simosu akepy unenjaton. ");
INSERT INTO car_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Moro Jesus pokatopombo wyino tyse waty amy wonatopo paty kynakon. Moro ta ro amy asery atunendopo kynakon. Amy pairo noro kari'na yry'pa kynakon itaka. ");
INSERT INTO car_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Moro taka roten Jesus ekepy'po yry'po i'waine, senge roten iwairy ke. Moro otare'matopo kurita irombo kynitundakon terapa. ");
INSERT INTO car_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Irombo moro otare'matopo kurita pa'po me, kokoro 'ne imero, tawa'rume noro a'ta, mo'ko Magdala pono Maria wyto'po moro Jesus unendopombo 'wa. Irombo moro ipenary aputy topu ene'po i'wa tamima. ");
INSERT INTO car_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Irombo eka'numy'po Simon Petrus 'wa, mo'ko o'win amy omepatoto, mo'ko poto me Jesus kynipynakon inoro 'wa enapa. Ika'po i'waine: “Mo'ko Jopoto moro unendopombo wyino taro man. Oje yry'po anukuty'pa na'na man.” ");
INSERT INTO car_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Irombo Petrus wepa'ka'po mo'ko o'win amy omepatoto maro. Ito'san moro Jesus unendopombo 'wa. ");
INSERT INTO car_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Okororo eka'numy'san. Mo'ko o'win amy omepatoto taka'ne kynakon Petrus ko'po. Mo'ko tunda'po na'nen moro Jesus unendopombo 'wa. ");
INSERT INTO car_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Itaka iwonsuma'po. Morokon inoponykonymbo kamisa ene'san i'wa. O'my'pa te iwe'i'po. ");
INSERT INTO car_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Irombo iwena'po ta Simon Petrus tunda'po enapa. Mo'ko wo'my'po moro atunendopo taka. Morokon inoponykonymbo kamisa ene'san i'wa. ");
INSERT INTO car_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Moro u'jondotopombo kamisa ene'po enapa i'wa, morokon inoponykonymbo kamisa ekosa kapyn te. Typo terapa te tamenje kynakon. ");
INSERT INTO car_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Morombo mero mo'ko o'win amy omepatoto, mo'ko Petrus uwapo tytunda kynakon inoro wo'my'po enapa. Oty ene'po mero ty'wa oty amyika'po i'wa. ");
INSERT INTO car_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Moro iromby'san wyino awomyry man mero'po anukuty'pa na'nen kynatokon. ");
INSERT INTO car_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Mo'karon omepatonon werama'san rapa moro ita tywaito'kon auto 'wa. ");
INSERT INTO car_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria te moro Jesus unendopombo wyino kurando kynotamojakon. Moro tywotamory ta moro atunendopo taka iwonsuma'po. ");
INSERT INTO car_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Irombo oko tamu'ne ewo'myndo'san kapu tanokon apojonano ene'san i'wa. Tandy'po kynatokon moro Jesus ekepy'po waitopombo po, o'win amy moro upu'po waitopombo po, o'win amy moro ipupuru waitopombo po. ");
INSERT INTO car_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Mo'karon woturupo'san ro i'wa: “Woryi, o'tono'me ko matamojan?” Ika'po i'waine: “Mo'ko Yjopotory taro man. Oje tyje iwairy anukuty'pa wa.” ");
INSERT INTO car_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Moro wara tyka'po mero iwotu'ma'po. Irombo Jesus ene'po i'wa. Jesus me iwairy anukuty'pa te kynakon. ");
INSERT INTO car_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesus wyka'po i'wa: “Woryi, o'tono'me ko matamojan? Noky ko mupijan?” Mo'ko wonatopo paty enenen ja'ta ekanopyry ke ty'wa, ika'po I'wa: “Jopoto, o'wa aro'poto, oje yry'po ekari'ko, moro wyino saro'se me.” ");
INSERT INTO car_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesus wyka'po i'wa: “Maria.” I'wa tywotu'ma'po mero Maria wyka'po I'wa Simosu auran ta: “Rabuni.” Moro tauro'po man: yjemepanen. ");
INSERT INTO car_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesus wyka'po i'wa: “Kapo'i koro. Awomy'pa noro irombo wa mo'ko jumynano 'wa. Mo'karon yja'sakarykon 'wa ero yjauranymbo ekari'tango: ‘Mo'ko yjumy, mo'ko ajumykon me enapa man inoro 'wa yjawomyry man. Mo'ko ytamusiry, mo'ko atamusirykon me enapa man inoro 'wa yjawomyry man.’ ” ");
INSERT INTO car_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Irombo mero mo'ko Magdala pono Maria wyto'po mo'karon omepatonon 'wa, moro ty'wa mo'ko Jopoto ene'po ekari'se, moro o'to ty'wa ika'po ekari'se enapa. ");
INSERT INTO car_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Irombo koko mo'karon omepatonon tywota'nano'se kynatokon. Morokon pena tyra'kere'to i'waine kynakon, mo'karon Simosu pona tanarike tywairykon ke. Irombo typo roten Jesus wopy'po ira'nakaine. Ika'po i'waine: “Sara'me aitoko.” ");
INSERT INTO car_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Moro wara tyka'po mero, morokon tainary, moro tysoropary enepo'po i'wa i'waine. Mo'ko Jopoto ene'po mero ty'waine, mo'karon omepatonon ewa'pota'san imero. ");
INSERT INTO car_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesus wyka'po rapa i'waine: “Sara'me aitoko. Mo'ko jumynano 'wa yjemoky'po wara enapa komo'saton.” ");
INSERT INTO car_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Moro wara tyka'po mero, uro'san i'wa. Ika'po i'waine: “Mo'ko Tamusi wyinono a'kanano apyitoko. ");
INSERT INTO car_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Yja'wan me kari'na we'i'san ka'poto o'waine, tyka ro kynaitan. Anika'pa awe'i'sando te, ika'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","O'win amy mo'karon ainapatoro itu'ponaka okonokon a'sakary Tomas, mo'ko Didymus me kynejatojaton inoro uwa tywaije kynakon ekosaine, mo'ko Jesus wopyry jako. ");
INSERT INTO car_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Mo'karon iwomepary a'sakarykon wyka'san i'wa: “Mo'ko Jopoto enei na'na.” Mo'ko Tomas wyka'po te i'waine: “Morokon ainary ta morokon putuputuri pa'san anene'pa yja'ta, morokon putuputuri pa'san taka moro yjainary siky'iry ane'moky'pa yja'ta, anamyika'pa waitake.” ");
INSERT INTO car_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Irombo oko-to'ima kurita pa'po me mo'karon inemeparykon moro auto ta rapa kynatokon. Tomas ro ekosaine kynakon. Tyra'kere'to morokon pena wairy se'me typo roten Jesus wopy'po ira'nakaine. Ika'po i'waine: “Sara'me aitoko.” ");
INSERT INTO car_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Morombo mero mo'ko Tomas 'wa ika'po: “Ero 'wa moro ajainary siky'iry ene'ko. Morokon yjainary eneko. Moro ajainary ene'ko. Moro ysoropary taka e'mo'ko. Senu'ka pe kyte'i. Isenu'ka'pa te aiko.” ");
INSERT INTO car_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomas wyka'po eju'to'me: “Yjopotory! Ytamusiry!” ");
INSERT INTO car_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesus wyka'po i'wa: “Yjene'po ke oty mamyikanon? Sara'me 'ne janon kynaita'ton mo'karon enery pyndo oty amyikanamon.” ");
INSERT INTO car_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Pyime noro kapu wyinonokon otykon enepo'san Jesus 'wa mo'karon tynemeparykon embata. Morokon te ero kareta ta imero'pa tywaije mandon. ");
INSERT INTO car_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Morokon imero'san te tymero man mo'ko Mesias me, mo'ko Tamusi ymuru me enapa Jesus wairy amyikato'me o'waine, amyikanamon me ajemando'ko'me enapa ety ta. ");
INSERT INTO car_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Morombo wyino Jesus wosenepo'po rapa mo'karon tynemeparykon 'wa moro Tiberias juwembory esi'wo. Ero wara te iwosenepo'po. ");
INSERT INTO car_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Asekosa kynatokon mo'ko Simon Petrus, mo'ko Tomas, mo'ko Didymus me kynejatojaton inoro, mo'ko Galilea tano Kana pono Natanael, mo'karon Sebedeus ymurukon, oko noro amykon terapa inemeparykon enapa. ");
INSERT INTO car_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrus wyka'po mo'karon ta'sakarykon 'wa: “Woto poko wy'sa.” Mo'karon amykonymbo wyka'san: “Na'na kyny'san amaro.” Kurandonaka ito'san. Moro kurijara taka iwotaru'ka'san. Moro koko te otymbo ro anapo'i'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Emamy'po po terapa Jesus pe'ja po kynakon. Jesus me iwairy anukuty'pa te mo'karon inemeparykon kynatokon. ");
INSERT INTO car_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Irombo Jesus wyka'po i'waine: “Pyitonon, perere etapyry me woto amy waty nan ajekosaine?” Ika'san: “Uwa.” ");
INSERT INTO car_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ika'po i'waine: “Moro sipi ematoko moro kurijara apo'tun wyino. Iwara amy mapyita'ton.” Ema'po i'waine. Irombo aru'kary upi'po terapa i'waine. Pyime irombo woto ita kynakon. ");
INSERT INTO car_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Irombo mo'ko poto me Jesus nipynary omepatoto wyka'po Petrus 'wa: “Mo'ko Jopoto mo'ko man.” Mo'ko Jopoto me iwairy eta'po mero ty'wa, Simon Petrus wewo'myndo'po. Iwoku'my'po. Moro tywo'my upi'nono ta roten irombo kynakon. Irombo iwoma'po moro tuna taka. ");
INSERT INTO car_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Mo'karon a'sakarykon 'wa te moro kurijara wena'po ta moro woto na'no'ka'po sipi kyryrykary enepy'po maponaka. Tyse waty irombo mapo wyino kynatokon. Ainatone-kari'na apo iwairy taro mapo wyino kynatokon. ");
INSERT INTO car_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Maponaka tywo'ka'san mero, wa'to'po po'manga'po tu'po woto ene'po i'waine. Perere ene'po enapa i'waine. ");
INSERT INTO car_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesus wyka'po i'waine: “Anapo'i'san woto amy ene'toko.” ");
INSERT INTO car_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Irombo Simon Petrus wotaru'ka'po rapa. Moro sipi kyryryka'po i'wa maponaka. Oko-to'ima-kari'na itu'ponaka ainapatoro itu'ponaka oruwa potonon woto ita kynatokon. Pyime mo'karon woto wairy se'me moro sipi we'i'po o'seka'pa. ");
INSERT INTO car_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesus wyka'po i'waine: “Endametoko.” Amy pairo inemepary tywoturupory 'se'pa kynakon i'wa: “Noky ko amoro man?” Mo'ko Jopoto me iwairy uku'satokon irombo. ");
INSERT INTO car_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Irombo Jesus 'wa moro perere anumy'po. Ekamy'po i'wa i'waine, mo'ko woto maro. ");
INSERT INTO car_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Moro ijoruwanory me Jesus wosenepotopo moro kynakon moro iromby'san wyino tawomy'po wyino. ");
INSERT INTO car_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Iwendame'san wyino Jesus wyka'po Simon Petrus 'wa: “Johanes ymuru Simon, kypynanon mojan ko'po?” Petrus wyka'po I'wa: “A'a, Jopoto, moro y'wa apynary muku'sa.” Jesus wyka'po i'wa: “Mo'karon yjekykon kapara indameno'poko.” ");
INSERT INTO car_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ijokonory me Jesus wyka'po rapa i'wa: “Johanes ymuru Simon, kypynanon?” Petrus wyka'po I'wa: “A'a, Jopoto, moro y'wa apynary muku'sa.” Jesus wyka'po i'wa: “Mo'karon yjekykon kapara eneko.” ");
INSERT INTO car_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ijoruwanory me Jesus wyka'po i'wa: “Johanes ymuru Simon, kypynanon?” Petrus 'wa moro ijoruwanory me moro ‘Kypynanon?’ ikary je'tuma'po. Irombo ika'po Jesus 'wa: “Jopoto, pa'poro oty muku'sa. Moro y'wa apynary muku'sa.” Jesus wyka'po i'wa: “Mo'karon yjekykon kapara indameno'poko. ");
INSERT INTO car_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","“Ita'ro pore, moro apitaniry jako aseke moku'myjakon. Anisanory wara ro mytopo'sakon. Ajatypy'poto te, morokon ajainary mityngatake. Amy terapa kari'na ajeku'mytan. Awytory 'se'tonorymbo 'wa ajarotan.” ");
INSERT INTO car_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Moro wara Jesus 'wa moro one wara Petrus rombyry man 'wa moro Tamusi ety awongary man ekarity'po. Moro wara tyka'po wyino, ika'po Petrus 'wa: “O'ko ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tywotu'ma'po mero, Petrus 'wa tywena'san ta mo'ko poto me Jesus nipynary omepatoto wopyry ene'po. Mo'ko ro mo'ko eratonomapotopombo onory jako Jesus aporito tywaije kynakon. Mo'ko enapa tywoturupo kynakon i'wa: “Jopoto, noky ko ajekaramatan?” ");
INSERT INTO car_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Inoro ene'po mero ty'wa, Petrus wyka'po Jesus 'wa: “Jopoto, o'to ko naitan mo'ko?” ");
INSERT INTO car_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesus wyka'po i'wa: “Moro ywopyry man 'wa ro nuro iwairy 'se yja'ta, apoko nan? Amoro te o'ko ywena'po ta.” ");
INSERT INTO car_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Irombo iromby'pa mo'ko omepatoto wairy man oka wotaripapy'po mo'karon Jesus wyinonokon ra'na. Jesus te yka'pa tywaije kynakon: “Iromby'pa kynaitan.” Tyka te tywaije kynakon: “Moro ywopyry man 'wa ro nuro iwairy 'se yja'ta, apoko nan?” ");
INSERT INTO car_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Mo'ko omepatoto, mo'ko erokon otykon amyikapojan inoro, mo'ko imeronamonymbo, inoro ro mo'ko man. Iporo moro inamyikapory wairy uku'san na'na. ");
INSERT INTO car_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Pyime noro amykon terapa otykon tyka'se man Jesus 'wa. O'win o'win pai morokon mero'sanymboto, ero nono tu'po morokon imero'san kareta waitopo waty nairy, wykaje awu.");
INSERT INTO car_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus, moro koromono ykaretary simeron pa'poro o'to tywairy a'mo'po poko Jesus 'wa, pa'poro i'wa kari'na emepa'san poko enapa, ");
INSERT INTO car_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kapu taka awo'nuku'po 'wa ro. Moro tawo'nukuru uwaporo te Tamusi a'kary pori'tory ta takari'se i'wa man one wara mo'karon tynapojomarykon me tynapo'i'san wairy man. ");
INSERT INTO car_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Mo'karon 'wa ro enapa moro tywota'karyka'po wyino pyime otykon ke nuro tywairy tamyikapo i'wa man. Oko-kari'na kurita ta pyimemboto tywosenepo i'waine man. Torupa i'wa mandon moro Tamusi nundymary poko. ");
INSERT INTO car_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","O'wino me imaroine ta'ta, ika'po i'waine Jerusalem wyino ito'pa iwaito'ko'me. Ika'po: “Moro o'waine ynekarity'pombo yjumy wykatopombo imomo'toko. ");
INSERT INTO car_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Johanes 'wa irombo tuna ke mo'karon kari'na tatyka mandon. Amyjaron te pyime 'ne waty amykon kurita pa'po me Tamusi a'kary ke tatyka maita'ton.” ");
INSERT INTO car_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Mo'karon Jesus ekosa ata'nanopy'san woturupo'san i'wa: “Jopoto, erome te mo'karon Israel pajanymbo mundymapotan rapa amy aseke ijopotorykon 'wa?” ");
INSERT INTO car_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Irombo te ika'po i'waine: “One wara a'ta oty wo'kapyry man Papa aina man. Ajainaine kapyn man moro ukutyry. ");
INSERT INTO car_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mepana'tomata'ton te, mo'ko Tamusi a'kary wopy'po mero otu'ponakaine. Yjekary amyikaponamon me maita'ton Jerusalem po, pa'poro wararo Judea po, pa'poro wararo Samaria po enapa, ero nono y'maty'po 'wa ro.” ");
INSERT INTO car_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Moro wara ika'ma'po wyino inenerykon mero kapu taka awo'nuku'po. Amy kapurutu notaka iwonekepy'po. ");
INSERT INTO car_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Onu'ka'pa kapu taka itory enery jako noro i'waine, typo roten oko wokyryjan we'i'san ekosaine tamu'namon wo'mynano ta. ");
INSERT INTO car_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mo'karon wyka'san ro: “Galilea ponokon wokyryjan, o'tono'me ko moro po noro mo'po'saton kapu 'wa? Mo'ko awyinoine kapu taka awo'nuku'po Jesus kyno'tan rapa moro kawonaka tytory ene'po wara enapa o'waine.” ");
INSERT INTO car_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Irombo Jerusalem 'wa iwerama'san rapa, moro oleif paty wypy wyino. O'win dusun apo ko'po kapyn moro wypy man Jerusalem wyino. ");
INSERT INTO car_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Irombo Jerusalem taka tywo'my'san mero, moro tywaito'kon poto 'su apuru'po taka ito'san kawonaka. Mo'karon moro po aitonon me ro kynatokon Petrus, Johanes, Jakobus, Andreas, Filipus, Tomas, Bartolomeus, Mateus, mo'ko Alfeo ymuru Jakobus, mo'ko o'wo'matonon a'sakarymbo Simon, mo'ko Jakobus ymuru Judas enapa. ");
INSERT INTO car_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Inaron ro pa'poro o'kapyn roten o'win tywonumengarykon ta Tamusi 'wa kynauranatokon. Amykon woryijan enapa imaroine kynatokon. Mo'ko Jesus sano Maria, mo'karon ipiryjan enapa imaroine kynatokon. ");
INSERT INTO car_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Amy kurita te Petrus awomy'po mo'karon ta'sakarykon ra'na. O'win-to'imamboto o'win-kari'na iwairy taro mo'karon ata'nanopy'san kynatokon. Petrus wyka'po: ");
INSERT INTO car_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Yja'sakarykon, moro imero'po, moro penaro David 'wa Judas poko mo'ko Tamusi a'kary nekari'po'pombo wo'kapyry ro tywaije man. Judas 'wa waty oma takari'se nan mo'karon Jesus apyinamon 'wa. ");
INSERT INTO car_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ka'sakarykon me tu'ku man. Moro kynikapyrykon amaminano wota'saka'po amy enapa tyka'se i'wa tywaije man. ");
INSERT INTO car_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Irombo te amy nono'membo tapeka'se i'wa tywaije man moro tyja'wany epe'po poko. Irombo tombata'po tywoma tywaije man. Tywotuweseka tywaije man. Pa'poro imero uwembombo tywo'se tywaije man kurandonaka. ");
INSERT INTO car_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Moro tota tywaije man pa'poro mo'karon Jerusalem po amandonon 'wa. Moro nono ro tajato i'waine man aseke taurangon ta Akeldama me. Moro tauro'po man: Mynu pan nono. ");
INSERT INTO car_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Moro ware karetary ta irombo tymero man: “Oro moro iwaitopo nipononge'nen. Oro amy pairo ipo emamy'pa nainen.” “Tymero enapa man: “Oro amy terapa i'petakan me nainen oty enenen me.” ");
INSERT INTO car_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Kokosaine mo'ko Jopoto Jesus a'ta, mo'ko Johanes 'wa etyka'po wyinombo ro moro awo'nuku'po 'wa ro, amykon wokyryjan tyweramapo'se mandon kymaroine. ");
INSERT INTO car_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Mo'karon wyino ro o'win amy apyiry man moro awomy'po amyikaponen me iwaito'me kymaroine.” ");
INSERT INTO car_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Irombo oko amykon aro'san i'waine uwaponaka: mo'ko Barsabas tatynen Josef (Justus me enapa kynejatojatokon), mo'ko Matias maro. ");
INSERT INTO car_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Irombo ero wara aurana'san Tamusi 'wa: “Amoro, Jopoto, pa'poro turu'ponano muku'sa. Na'na 'wa iro ke uku'poko nokypan 'se awairy mojan okonokon wyino, ");
INSERT INTO car_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","moro Judas nino'po apojonano emamin ka'tome. Judas 'wa irombo moro amaminano tyno man moro tywaitopo 'wa tytoto'me.” ");
INSERT INTO car_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Irombo tymeramon tapusikiri emapoty'san i'waine. Iwara ro mo'ko Matias ekarity'po moro amaminano apyinen me. Mo'karon ainapatoro itu'ponaka o'win apojoma'san apyimy taka a'myka'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Moro koromono wonatopo poty'po ewa'matopo kurita tunda'po mero, pa'poro tywota'nano'se kynatokon. ");
INSERT INTO car_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Irombo typo roten kapu wyino amy oty mory wopy'po, pepeito tam'po'kory mory wara imero. Moro iwotandy'moto'kon auto a'no'ka'po imero moro oty mory 'wa. ");
INSERT INTO car_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Irombo wa'to ka'muru'makon wara otykon wosenepo'san i'waine. Pa'poro iwe'i'san mero itu'ponakaine morokon otykon wotaripapy'san. ");
INSERT INTO car_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Irombo Tamusi a'kary 'wa i'namoro'san. Ukuty'non roten auranano ta tauranarykon a'mo'po i'waine, Tamusi a'kary 'wa tauranano'porykon wararo. ");
INSERT INTO car_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Moro jako Jerusalem po pa'poro ero nono tu'ponokon aito'kon wyino opy'san Tamusi nendonamon Simosu kynatokon. ");
INSERT INTO car_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Moro oty mory wota'po mero, pyime kari'na wota'nanopy'san. Poto me imero iwonumenga'san, pa'poro aseke taurangon ta auranarykon etary ke ty'waine. ");
INSERT INTO car_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","I'narangapo'san moro oty 'wa. Irombo ika'san: “Galilea ponokon kapyn pa'poro mo'karon auranatonon nandon? ");
INSERT INTO car_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","One wara ko iro ke pa'poro aseke kaurangon ta auranarykon kysetaton? ");
INSERT INTO car_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partie ponokon me, Medië ponokon me, Elam ponokon me, Mesopotamie ponokon me, Judea ponokon me, Kapadosi ponokon me, Pontus ponokon me, Asia ponokon me, ");
INSERT INTO car_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigie ponokon me, Panfili ponokon me, Egypte ponokon me, Sirene wyino amandonon Libie ponokon me, Rome ponokon otawatonon me, ");
INSERT INTO car_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Simosu me, Simosu me atypo'san me, Kreta ponokon me, Arabi ponokon me enapa pa'poro aseke kaurangon ta auranarykon kysetaton, one wara Tamusi 'wa potonon otykon kapy'san poko.” ");
INSERT INTO car_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Pa'poro iwe'naranga'san. One wara pairo moro oty poko tywonumengarykon anukuty'pa iwe'i'san. Ika'san: “Oty 'ne ko ero nan?” ");
INSERT INTO car_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amykonymbo te kynauno'po'satokon. Kyngatokon: “Tywetynje mandon.” ");
INSERT INTO car_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Irombo te Petrus awomy'po mo'karon ainapotoro itu'ponaka o'win apojoma'san maro. Mo'ja aurana'po i'waine: “Yja'sakarykon Simosu, pa'poro Jerusalem po aitonon enapa, ero ukutyry 'se wa o'waine. Iru'pa koro yjauran 'wa epanamatoko. ");
INSERT INTO car_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Mojan tywetynje anekanopyrykon irombo etymy'pa mandon. Kokoro noro man. Okupa'en-to'ima juru man. ");
INSERT INTO car_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Mo'ko Tamusi auran uku'ponen Joel wykatopombo te ero man: ");
INSERT INTO car_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Morokon irombo ro kurita ero wara kynaitan, kynganon Tamusi. Yja'kary a'si'ko sytake pa'poro kari'na tu'ponaka. Irombo mo'karon omurukon, ajemyirykon yjauranymbo uku'pota'ton. Mo'karon ara'nanokon pyitonon 'wa otykon kynosenepota'ton. Mo'karon uwapoto'san kynone'po'ta'ton. ");
INSERT INTO car_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Mo'karon ypyitorykon tu'ponaka, mo'karon yjemyijarykon tu'ponaka enapa morokon kurita yja'kary amy sytake. Irombo yjauranymbo uku'pota'ton. ");
INSERT INTO car_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Anumengaponamon otykon senepotake kawo kapu poko. Po'po ero nono tu'po potonon otykon senepotake. Mynu kynaitan. Wa'to kynaitan, to'kyine imero. ");
INSERT INTO car_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Moro weju imero kynewa'rumandan. Moro nuno mynu me imero kynaitan. Moro wara kynaitan moro poto 'su, taweijen mo'ko Jopoto wo'topo kurita uwaporo. ");
INSERT INTO car_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Irombo mero pa'poro mo'ko Jopoto ety ejatonen tunenje kynaitan uta'no wyino.” ");
INSERT INTO car_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Yja'sakarykon, Israel pajanymbo, ero yjauran 'wa epanamatoko! Amy tynemoky'po wokyry me mo'ko Nasaret pono Jesus wairy aseke Tamusi 'wa tanepo man. Ita irombo tamamina man anumengaponamon kapu wyinono otykon, potonon pori'tonano enepoto'me ara'naine. Aseke waty morokon muku'saton. ");
INSERT INTO car_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aseke ro Tamusi 'wa tyjembo me tywaije man mo'ko Jesus yry man ajainakaine. Penaro terapa tuku'se tywaije Tamusi 'wa man. Irombo wakapu poko typokapo o'waine man tyja'wangamon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Tamusi 'wa te iromby'san wyino tawongapo rapa man. Morokon iromby'po je'tun taike'ka i'wa man. Moro tyromo'se aino 'wa mo'ja ro apyiry tupi me tywaije man. ");
INSERT INTO car_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","David irombo ipoko kynganon: “Mo'ko Jopoto yjenuru ta roten man. Mo'ko ro yjapo'tun wyino man, ywomapotyry pona. ");
INSERT INTO car_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Iro ke ro yturu'po tawa'pore man. Yndary kynominojan. Yja'mun pairo tywotunendopo amy epotan Tamusi momokyry ta. ");
INSERT INTO car_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yja'kary anino'pa irombo mana mo'karon iromby'san waitopo po. Mo'ko ajety awonganen apyitory anuta'kapo'pa mana. ");
INSERT INTO car_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Amano emary menepoi y'wa. Moro yjekosa awairy poto me yjewa'porojan.” ");
INSERT INTO car_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Yja'sakarykon, iru'pyn po kysuku'saton mo'ko kytangon David romby'po, unemy'po enapa. Erome noro moro itu'mun kokosaine man. ");
INSERT INTO car_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Amy Tamusi auran uku'ponen me tywaije man. Tamusi 'wa amy typarymbo andy'mory man tuku'se i'wa man moro tapo'nymbo tu'po. Aseke toty ejatory ta moro wara Tamusi tyka tywaije man. ");
INSERT INTO car_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David 'wa penaro ro tone terapa tywaije man one wara aire oty wairy man. Iwara ro mo'ko Mesias awomyry man rapa takari'se i'wa man. Mo'karon iromby'san waitopo 'wa ino'pa iwairy man, ikota'pa moro ija'mun wairy man enapa takari'se i'wa man. ");
INSERT INTO car_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Mo'ko Jesus ro Tamusi 'wa tawongapo rapa man. Moro amyikaponamon me pa'poro na'na man. ");
INSERT INTO car_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Tawonga ro man Tamusi apo'tun wyinonaka. Irombo Tamusi a'kary tapyije i'wa man tyjumy wyino, ika'pombo wara ro. Mo'ko ro tyje i'wa man. Moro ro meneton. Metaton enapa. ");
INSERT INTO car_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David 'ne ro irombo awomy'pa tywaije man kapu taka. Aseke ro tyka man: “Tamusi nykai mo'ko Yjopotory 'wa: ‘Yjapo'tun wyino atandy'moko, ");
INSERT INTO car_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mo'karon ajenono'namon yry 'wa ro y'wa apupuru apo'ny me.’ ” ");
INSERT INTO car_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Iro ke ro iru'pyn po ero ukutyry man pa'poro mo'karon Israel pajanymbo 'wa: Mo'ko Jesus, mo'ko wakapu poko anipoka'san, Tamusi 'wa Jopoto me, Mesias me enapa tyje man.” ");
INSERT INTO car_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ero eta'po mero ituru'san 'wa imero iwo'san. Irombo Petrus 'wa, mo'karon amykon terapa apojoma'san 'wa enapa ika'san: “Na'na a'sakarykon, o'to ko na'na naitan?” ");
INSERT INTO car_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Irombo Petrus wyka'po i'waine: “Ajemamyrykon u'matoko. Pa'poro awe'i'san mero asetykapotoko Jesus Kristus ety ta, oja'wanykonymbo wo'kato'me. Irombo mero mo'ko Tamusi a'kary mapyita'ton. ");
INSERT INTO car_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","O'wanokon me irombo moro Tamusi wykatopombo man, o'makon 'wano me, paporo mo'karon ty'wa mo'ko Kyjopotorykon Tamusi niko'marykon man tysenokon 'wano me enapa.” ");
INSERT INTO car_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pyime noro Petrus aurana'po moro oty amyikaponen me. Irombo uru'san imero i'wa: “Opano'potoko mo'karon tyja'wangamon kari'na wyino.” ");
INSERT INTO car_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Mo'karon Petrus auran amyikanamonymbo wosetykapo'san. Moro kurita ro oruwa dusun iwairy taro kari'na we'i'san Kristus wyinonokon me. ");
INSERT INTO car_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Mo'karon apojoma'san nyry omepano ta iweja'nakato'kon kynakon. Ase'wa iwota'nano'to'kon kynakon. Ase'wa iwendameto'kon kynakon. Auranato'kon enapa kynakon Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Tamusi emaminatopo kynakon mo'karon apojoma'san ta, pyime potonon anumengaponamon kapu wyinonokon otykon enepoto'me i'waine. Iwara pa'poro kari'na 'wa Tamusi nendotopo kynakon. ");
INSERT INTO car_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Pa'poro mo'karon Kristus wyinonokon wota'nano'topo kynakon ase'wa. Pa'poro tywe'i'san mero ase'wa totyrykon aripa'topo i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Totyrykonymbo ekaramatopo i'waine kynakon. Irombo moro epetymbo ekandopo i'waine kynakon mo'karon oty'non 'wa, enekeine ro. ");
INSERT INTO car_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kurita wararo ase'wa iwota'nano'to'kon kynakon moro Tamusi auty ta. Autokon po ase'wa iwendameto'kon kynakon. Tawa'pore iwendameto'kon kynakon. E'i'pa 'ne iwaito'kon kynakon. ");
INSERT INTO car_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tamusi ety awongatopo i'waine kynakon. Pa'poro mo'karon kari'na 'wa typyne iwaito'kon kynakon. Kurita wararo Tamusi 'wa mo'karon uta'no wyino tynunemyrykon apyimangatopo kynakon. ");
INSERT INTO car_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","O'wino me Petrus wyto'po Johanes maro moro Tamusi auty 'wa koine, oruwa juru a'ta. Moro juru ta ro mo'karon Simosu Tamusi 'wa kynauranaton. ");
INSERT INTO car_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Moro po ro amy tywoma'po poro iwajakuta'po wokyry kynakon. Kurita wararo arotopo kynakon moro Tamusi auty penary, moro ‘Kurano Pena’ me kynejatojaton iro 'wa. Pyrata poko iwe'pimatopo kynakon mo'karon Tamusi auty taka o'mytonon 'wa. ");
INSERT INTO car_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Irombo moro Tamusi auty taka Petrus, Johanes wo'myrykon ene'po mero ty'wa, pyrata poko iwe'pima'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Irombo onu'ka'pa imero Petrus wo'poty'po i'wa Johanes maro. Ika'po i'wa: “Na'na 'wa o'po'ko.” ");
INSERT INTO car_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Irombo iwo'poty'po i'waine. Tainary'tory ekano'sakon i'waine. ");
INSERT INTO car_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Petrus wyka'po te: “Amu'nymbo, ika'mi'po enapa waty man yjekosa. Moro yjekosa aitoto oty te syja o'wa: Mo'ko Nasaret pono Jesus Kristus ety ta ajawongo! Itopo'ko!” ");
INSERT INTO car_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Irombo ainary apo'tun poko apo'i'po i'wa. Awonga'po i'wa. O'win wytory imero morokon ipupuru, morokon ima'kariry wepori'toma'san. ");
INSERT INTO car_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ta'po'ne awomy'po. Itopoty'po! Imaroine moro Tamusi auty taka iwo'my'po tywota'porombotyry ta, Tamusi ety awongary ta. ");
INSERT INTO car_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Pa'poro mo'karon moro po ata'nanopy'san 'wa moro itopotyry, moro i'wa Tamusi ety awongary ene'po. ");
INSERT INTO car_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Irombo moro ‘Kurano Pena’ tatynen Tamusi auty penary po tandy'po pyrata poko e'pimatotombo me iwairy ukuty'po i'waine. Enuta'san imero. Iwe'naranga'san enapa moro wara iwe'i'po poko. ");
INSERT INTO car_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Mo'ko Petrus, mo'ko Johanes enapa aninonda'paine mo'ko wajaku panymbo kynakon. Tywe'naranga imero mo'karon kari'na wetururuka'san itu'ponakaine moro Salomo ety tano Tamusi auty pery po. ");
INSERT INTO car_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Moro ene'po mero, Petrus wyka'po i'waine: “Yja'sakarykon, Israel pajanymbo, o'tono'me ko moro oty ajenumengapojaton? O'tono'me ko onu'ka'pa na'na 'wa mo'po'saton? Aseke typori'tory 'wa ka'tu, aseke na'na we'pimary 'wa ka'tu mo'se wokyry awongapo'po mekano'saton na'na 'wa? ");
INSERT INTO car_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mo'ko Abraham tamusiry, mo'ko Isak tamusiry, mo'ko Jakob tamusiry, mo'ko kytangon tamusiry 'wa ro mo'ko typyitory Jesus ety tawonga imero man. Mo'ko Jesus ro o'waine takarama tywaije man. Mo'ko Pilatus embata turumena o'waine tywaije man, inondary man yry'pombo se'me i'wa. ");
INSERT INTO car_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","“O'waine te mo'ko Tamusi wyinono tamamboren turumena man. Tywoturupo mandon amy kari'na wonenymbo nondato'me i'petakan me. ");
INSERT INTO car_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Iwara mo'ko amano taka kari'na aronen tywopo o'waine man. Tamusi 'wa te iromby'san wyino tawongapo rapa man. Moro amyikaponamon me ro na'na man. ");
INSERT INTO car_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Mo'ko Jesus ety amyikai ro mo'se anenerykon, anukutyrykon wokyry. Iro ke ro moro ety nipori'tomai. Mo'ko Jesus amyikary ro nikura'mai. Moro ro pa'poro menejaton. ");
INSERT INTO car_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Yja'sakarykon, suku'sa mo'ko Jesus wo'po o'waine, mo'karon ajopotorykon 'wa enapa, anukuty'pa awe'i'san ke. ");
INSERT INTO car_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Tamusi 'wa te pa'poro mo'karon tauran uku'ponamonymbo 'wa takari'po tywaije man mo'ko Mesias me tynyry man wota'karykary man. Moro wara ro tyka'po i'wa man. ");
INSERT INTO car_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Iro ke ro moro ajemamyrykon u'matoko. Tamusi 'wa atu'matoko, oja'wanykonymbo kato'me. ");
INSERT INTO car_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Irombo Tamusi aja'karykon eremapotan. Mo'ko o'wanokon me tynyry'po Mesias Jesus emo'tan. ");
INSERT INTO car_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kapu ta mo'ko Jesus wairy man pa'poro asery me oty yry man 'wa ro rapa Tamusi 'wa. Moro poko ro penaro terapa mo'karon tauran uku'ponamonymbo typyitorykon tauranano'po Tamusi 'wa man. ");
INSERT INTO car_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Moses tyka man: ‘Mo'ko Ajopotorykon Tamusi yjawonga'po wara enapa amy tauran uku'ponen awongatan aja'sakarykon ra'na. Pa'poro o'to ikary 'wa ro awepanamarykon man. ");
INSERT INTO car_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Irombo ero wara kynaitan: Pa'poro mo'ko Tamusi auran uku'ponen 'wa epanamapyn kari'na uta'kary man awyinomboine.’ ");
INSERT INTO car_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Samuel 'wa ro rypo, pa'poro mo'karon iwena'po ta opy'san Tamusi auran uku'ponamon 'wa enapa morokon erome o'ka'tonon otykon takari'se man. ");
INSERT INTO car_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Amyjaron mo'karon Tamusi auran uku'ponamonymbo pajanymbo me mandon. Moro atangonymbo 'wa Tamusi wykatopombo o'wanokon me man. Abraham 'wa waty tyka nan: ‘Mo'karon apajangonymbo pa'poro ero nono tu'ponokon kuranondoponamon me kynaita'ton.’ ");
INSERT INTO car_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","O'waine na'nen Tamusi 'wa mo'ko typyitory tane'po man, akuranondoto'ko'me i'wa, awotu'ma'sando oja'wanykonymbo wyino.” ");
INSERT INTO car_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Mo'karon kari'na apyimy 'wa Petrus, Johanes auranarykon jako noro mo'karon Tamusi pokonokon, mo'ko Tamusi auty erangon jopotory, mo'karon Saduse wopy'san iwetoine. ");
INSERT INTO car_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Tare'ke imero kynatokon, mo'karon okonokon apojoma'san 'wa mo'karon kari'na emepary ke iromby'san awomyry man poko Jesus awomy'po ke. ");
INSERT INTO car_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Irombo apo'i'san i'waine. Moro yja'wangon kari'na aru'katopo taka aru'kapo'san i'waine. Moro po ro emangapo'san i'waine, iko'mamy'po ke terapa. ");
INSERT INTO car_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pyime te mo'ko Kristus ekary etanamonymbo we'i'san Kristus wyinonokon me. Iwara ainatone dusun iwairy taro pa'poro mo'karon Kristus wyinonokon we'i'san. ");
INSERT INTO car_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Irombo koro'po mo'karon Simosu jopotorykon, mo'karon uwapoto'san, mo'karon Tamusi karetary uku'namon enapa wota'nanopy'san Jerusalem po, ");
INSERT INTO car_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","mo'ko Tamusi pokonokon jopotory Anas maro, Kajafas, Johanes, Aleksander maroine, pa'poro mo'ko Tamusi pokonokon jopotory omorykon maro enapa. ");
INSERT INTO car_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Irombo mo'karon apojoma'san ene'po'san i'waine owarira'naka. Iwoturupo'san i'waine: “Otypan pori'tonano ta ko, otypan atywano ta ko mo'ko iwajakuta'po mikura'maton?” ");
INSERT INTO car_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Tamusi a'kary 'wa ty'namoro Petrus wyka'po i'waine: “Jopotokon, na'na uwapotorykon, ");
INSERT INTO car_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","na'na 'wa erome maturupojaton mo'ko wajaku panymbo 'wa iru'pyn oty epory'po poko, oty 'wa ikura'ma'po poko. ");
INSERT INTO car_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Pa'poro iro ke o'waine, pa'poro Israel pajanymbo 'wa enapa ero ukutyry man: mo'se wokyry ero po tywekura'ma ajekosaine man mo'ko Nasaret pono Jesus Kristus ety ta. Mo'ko ro miwoposen wakapu poko. Tamusi 'wa te tawongapo rapa man iromby'san wyino. ");
INSERT INTO car_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Mo'ko ro moro auto pori'tomanen topu me man. O'waine ro rypo auto amynamon me turumena tywaije man. ");
INSERT INTO car_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Mo'ko aina roten ajunemyrykon man uta'no wyino. Amy rapa atywano irombo yry'pa kapu upi'no tywaije man kari'na ra'na kunendo'ko'me uta'no wyino.” ");
INSERT INTO car_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Enari'ma Johanes maro Petrus auranary ene'po mero, omepa'non me, amorepa'non me iwairykon ukuty'po mero enapa, mo'karon aurangon etanamonymbo enuta'san imero. Jesus maro ytopo'tononymbo me ukuty'san rapa i'waine. ");
INSERT INTO car_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","O'to pairo te imero tykarykon upijatokon, mo'ko ikura'ma'po wokyry enery ke ty'waine ekosaine. ");
INSERT INTO car_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Irombo kurandonaka rapa aropo'san i'waine moro tywota'nanoto'kon wyino. Irombo ase'wa iworupa'san. ");
INSERT INTO car_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ika'san: “O'to ko mojan wokyryjan kysyta'ton? I'waine irombo amy poto pore pori'tonano enepo'po uku'saton pa'poro mo'karon Jerusalem ponokon. Onapi me moro pori'tonano ekarityry kysupijaton. ");
INSERT INTO car_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mo'ja ro mo'karon kari'na ra'na ero oka wokarory pona te mojan wokyryjan kysity'ka'masen, Jesus ety ejatory ta noro amy pairo kari'na erupary pona.” ");
INSERT INTO car_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Iko'mapo'san rapa i'waine. Ika'san i'waine, moro Jesus ety anejato'pa pairo noro iwaito'ko'me, amy pairo noro anemepa'pa enapa iwaito'ko'me ipoko. ");
INSERT INTO car_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Petrus 'wa te ejuku'san Johanes maro. Ika'san i'waine: “Amyjaron terapa aseke uku'toko otypan wairy Tamusi embata iru'pa 'ne: moro o'waine na'na wepanamary, moro Tamusi 'wa na'na wepanamary te ka'tu? ");
INSERT INTO car_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Na'na irombo ity'me tywairy upijan morokon tynene'san, tyneta'san otykon poko.” ");
INSERT INTO car_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mene 'ne ka'tu rapa ity'ka'ma'ma'san mero ty'waine, inonda'san mo'karon Tamusi pokonokon jopotorykon 'wa. Amy oma anepory'pa iwe'i'san ipoky'mapoto'ko'me, mo'karon kari'na apyimy poko tanarike tywairykon ke. Pa'poro kari'na irombo moro o'kapy'po oty poko Tamusi ety awongatokon. ");
INSERT INTO car_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Mo'ko poto pore pori'tonano nikura'ma'po wokyry irombo oko-kari'na siriko ko'po terapa kynakon. ");
INSERT INTO car_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tynonda'san mero, ta'sakarykon 'wa mo'karon apojoma'san wyto'san, pa'poro morokon Tamusi pokonokon jopotorykon, mo'karon uwapoto'san wykato'konymbo ekari'se. ");
INSERT INTO car_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Morokon eta'san mero ty'waine, asewara imero Tamusi 'wa mo'karon a'sakarykon aurana'san. Ika'san: “Jopoto, pa'poro itanokon maro ro kapu, nono, parana ka'nenymbo! ");
INSERT INTO car_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Mo'ko apyitory David yndary ta mo'ko aja'kary ero wara tauranano'po o'wa man: “O'tono'me ko mo'karon kari'na apyimykon natamiromo'katon? O'tono'me ko aronge roten otykon poko nonumengaton? ");
INSERT INTO car_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mo'karon ero nono jopotorykon kynawonjaton, warinu ka'se tytoto'ko'me. Mo'karon aito'kon undymanamon kynota'nano'saton Tamusi weto tytoto'ko'me, mo'ko Mesias me inapo'i'po weto enapa.” ");
INSERT INTO car_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Iporo ro irombo ero aitopo ta mo'ko awyinono apyitory me anapo'i'po Jesus weto tytoto'ko'me tywota'nano'se tywaije mandon mo'ko Herodes mo'ko Pontius Pilatus maro, mo'karon Simosu me e'i'non maro, mo'karon Israel pajanymbo maro enapa. ");
INSERT INTO car_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Morokon penaro terapa apori'tory ta, anisanory ta enapa awykato'konymbo tyka'se i'waine man. ");
INSERT INTO car_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Erome enapa, Jopoto, eneko moro i'waine na'na ty'ka'mary. Apyitorykon te epano'ko enari'ma imero ajauranymbo ekari'to'me. ");
INSERT INTO car_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ajainary ityngako, kari'na kura'mato'me, potonon anumengaponamon kapu wyinonokon otykon enepoto'me enapa mo'ko awyinono apyitory Jesus ety ejatory poko.” ");
INSERT INTO car_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tamusi 'wa aurana'ma'san mero moro iwota'nano'to'kon wesakamapoty'po imero. Pa'poro iwe'i'san mero Tamusi a'kary 'wa i'namoro'san. Irombo enari'ma imero moro Tamusi auranymbo ekarityry a'mo'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Pa'poro mo'karon Kristus wyinonokon turu'san o'win kynakon. O'win a'kanano kynakon. Amy pairo enapa ty'wano me roten amy totyry anekarity'pa kynakon. Pa'poro te morokon totyrykon yjatokon ase'wa ty'wanokon me. ");
INSERT INTO car_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Poto 'su pori'tonano maro mo'karon apojoma'san 'wa mo'ko Jopoto Jesus awomy'po rapa amyikapo'po. Tamusi 'wa poto me imero tyturu'popory yry'po pa'poro i'waine. ");
INSERT INTO car_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Amy pairo enapa omi ta e'i'pa kynakon ira'naine. Pa'poro mo'karon tyinonokamon, tautynamon 'wa moro tyinonory, tauty pai ekaramatopo kynakon. Irombo morokon tynekarama'san epe'san ytopo i'waine kynakon ");
INSERT INTO car_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","mo'karon apojoma'san pupurukon po. Mo'karon 'wa terapa ekandopo kynakon mo'karon kari'na 'wa, enekeine ro. ");
INSERT INTO car_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Iwara ro amy Josef tatynen kynakon, mo'ko Barnabas me mo'karon apojoma'san kynejatojatokon inoro. Moro Barnabas tauro'po man: kari'na pana'tomanen. Amy Tamusi pokonokon pyitory mo'ko kynakon, amy Siprus po oma'pombo. ");
INSERT INTO car_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tyinonoke kynakon. Moro nono ekarama'po ro i'wa. Irombo moro epe'po yry'po i'wa mo'karon apojoma'san pupurukon po. ");
INSERT INTO car_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Irombo amy Ananias tatynen wokyry 'wa mo'ko typyty Safira maro amy nono ekarama'po. ");
INSERT INTO car_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Moro tynekarama'po epe'po wyino amy pina'po i'wa ty'wano me. Mo'ko ipyty ro rypo moro uku'sakon. Irombo moro tynipina'po a'sakarymbo yry'po i'wa mo'karon apojoma'san pupurukon po. ");
INSERT INTO car_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Petrus wyka'po te: “Ananias, o'tono'me ko mo'ko Satan 'wa matapyipoi Tamusi a'kary emu'mato'me o'wa, moro nono epe'po amy pinato'me o'wa? ");
INSERT INTO car_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Ekaramary uwaporo ajotyry me kapyn kynakon? Ekarama'po wyino, moro epe'po ajaina kapyn kynakon? O'to ko me'i moro wara awaito'me? Aja'sakary 'wa enapita'pa me'i. Tamusi 'wa te ajenapitai.” ");
INSERT INTO car_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Moro auranano eta'po mero Ananias wotuwa'mo'po. Iromby'po. Irombo poto 'su ety'kano wopy'po mo'karon ekary etanamonymbo tu'ponaka. ");
INSERT INTO car_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Irombo mo'karon pyitonon awomy'san inopondoto'me. Irombo kurandonaka aro'po i'waine. Unemy'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Irombo oruwa juru pa'po me, mo'ko Ananias pyty wo'my'po, otypan oty wo'kapy'po anukuty'pa. ");
INSERT INTO car_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Irombo Petrus wyka'po i'wa: “Moro wara moro anekarama'san epe'po nan? Kaiko y'wa.” Irombo “A'a, moro wara man,” ika'po. ");
INSERT INTO car_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Irombo Petrus wyka'po i'wa: “One wara ko ajaurangon mepopoton mo'ko Tamusi a'kary u'kuto'me? Eneko. Mo'karon oino unenamonymbo kyno'myjaton rapa. Mo'karon ro rapa kurandonaka ajarota'ton ajunenje.” ");
INSERT INTO car_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Irombo o'win wytory iwotuwa'mo'po Petrus pupuru po. Iromby'po enapa. Tywo'my'san po mo'karon pyitonon 'wa iromby'po epory'po enapa. Irombo kurandonaka aro'po i'waine. Ino aporito ro unemy'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Irombo poto 'su ety'kano wopy'po pa'poro mo'karon Tamusi na'nanopy'san apyimy tu'ponaka, pa'poro moro oka etanamonymbo tu'ponaka enapa. ");
INSERT INTO car_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Tamusi emamina'po mo'karon apojoma'san ta, pyime potonon anumengaponamon otykon enepoto'me i'waine mo'karon kari'na 'wa. O'win turu'ponano maro pa'poro ase'wa kynatokon moro Salomo ety tano Tamusi auty pery po. ");
INSERT INTO car_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mo'karon iwyinoine e'i'non tanarike kynatokon iwyinonakaine tytorykon poko. Pa'poro kari'na te mo'karon Kristus wyinonokon ety awongatokon. ");
INSERT INTO car_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Aseme noro mo'karon Jopoto amyikanamon kynotapyimangatokon, wokyryjan ke, woryijan ke enapa. ");
INSERT INTO car_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Mo'karon je'tun pangon pa'katokon pairo kurandonaka potonon oma taka, iwo'ny'to'kon tu'po ro, typatoine Petrus wytory a'kary womato'me roten amy tu'ponaka. ");
INSERT INTO car_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Morokon Jerusalem wyinonokon aito'kon wyino enapa moky kari'na kyno'satokon je'tun pangon ene'se, yja'wan akywano pangon ene'se enapa. Irombo pa'poro kynekura'matokon. ");
INSERT INTO car_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Mo'ko Tamusi pokonokon jopotory wore'ko'po te mo'karon ta'sakarykon maro. Saduse me mo'karon kynatokon. ");
INSERT INTO car_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Irombo mo'karon apojoma'san apyipo'san i'waine. Aru'kapo'san i'waine yja'wangon kari'na aru'katopo taka. ");
INSERT INTO car_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Koko te amy Tamusi apojon 'wa morokon yja'wangon kari'na aru'katopo penarykon etapurumakapoty'san. Mo'karon apojoma'san pa'kapo'san mo'ko Tamusi apojon 'wa kurandonaka. Ika'po i'waine: ");
INSERT INTO car_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“I'tandoko moro Tamusi auty taka. Mo'karon kari'na erupatoko pa'poro ero asery amano poko.” ");
INSERT INTO car_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Iwepanama'san i'wa. Kokoro 'ne, aweitary uwaporo ito'san moro Tamusi auty taka. Irombo kari'na emepatokon. Ijako ro mo'ko Tamusi pokonokon jopotory tunda'po mo'karon ta'sakarykon maro. Mo'karon Simosu jopotorykon, pa'poro mo'karon Israel pajanymbo uwapotorykon ko'mapo'san i'waine, ase'wa tywota'nano'to'ko'me. Irombo amykon oranano emoky'san i'waine moro yja'wangon kari'na aru'katopo 'wa, mo'karon apojoma'san aije. ");
INSERT INTO car_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Moro 'wa tytunda'san mero te mo'karon oranano we'i'san mo'karon apojoma'san anepory'pa. Irombo tywerama'san mero ika'san: ");
INSERT INTO car_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Moro yja'wangon kari'na aru'katopo eporyi na'na iru'pyn me tyra'kere'to. Mo'karon erandonamon enapa pena po kynatokon. Etapurumaka'po mero te, itary'pa na'na neporyi.” ");
INSERT INTO car_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Moro eta'po mero ty'waine, mo'ko Tamusi auty erangon jopotory maro mo'karon Tamusi pokonokon jopotorykon we'i'san one wara moro oty wairy anukuty'pa. ");
INSERT INTO car_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Irombo te amy wopy'po tykato'me: “Eneko, mo'karon anaru'ka'san wokyryjan Tamusi auty ta rapa kari'na emepaton!” ");
INSERT INTO car_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Irombo mo'ko Tamusi auty erangon jopotory wyto'po mo'karon typyitorykon maro aijeine. Tokone te e'i'pa iwe'i'san ipokoine. Tanarike irombo kynatokon mo'karon kari'na 'wa topu ke tyworykon pona. ");
INSERT INTO car_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mo'karon apojoma'san aro'san ro i'waine mo'karon Simosu jopotorykon po'ponaka. Irombo mo'ko Tamusi pokonokon jopotory woturupo'po i'waine: ");
INSERT INTO car_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Aje'ma'paine na'na ne'i kari'na anemepa'pa noro awaito'ko'me mo'ko Jesus ety ejatory ta? Moro omepano te maripa'ton pa'poro ero Jerusalem ta. Mo'ko wokyry wo'po epemapory 'se mandon na'na 'wa.” ");
INSERT INTO car_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrus 'wa te mo'karon apojoma'san maro ejuku'po. Ika'po: “Tamusi 'wa te kywepanamarykon man kari'na 'wa kywepanamarykon ko'po. ");
INSERT INTO car_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mo'ko kytangon tamusiry 'wa mo'ko wakapu poko aniwopo'san Jesus tawongapo rapa man. ");
INSERT INTO car_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Mo'ko ro Tamusi 'wa tyje man kawo tapo'tun wyino Jopoto me, kari'na Epano'neme enapa. Iwara ro mo'karon Israel pajanymbo 'wa tamamyrykon u'mary 'se man ija'wanykonymbo kato'me. ");
INSERT INTO car_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Irokon amyikaponamon me na'na man mo'ko Tamusi nyry'po a'kanano maro. Mo'ko ro tyje i'wa man mo'karon ty'wa epanamatonon 'wa.” ");
INSERT INTO car_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Moro eta'po mero, iwore'ko'san imero. Iworykon 'se kynatokon. ");
INSERT INTO car_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Irombo mo'karon Simosu jopotorykon ra'na o'win amy Gamaliel tatynen Farise awomy'po. Amy Tamusi karetary uku'nen mo'ko kynakon. Pa'poro kari'na kyninendojatokon. Mo'ko wyka'po ro mo'karon apojoma'san aroto'me 'non kurandonaka. ");
INSERT INTO car_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Irombo ta'sakarykon 'wa ikapo: “Yja'sakarykon, Israel pajanymbo, tuwaro koro aitoko o'to mo'karon wokyryjan yry man poko o'waine. ");
INSERT INTO car_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Penaro terapa a'si'ko amy Teudas tatynen tywokari'se tywaije man amy poto 'su kari'na me. Irombo amykon okupa'emboto ainatone-kari'na wokyryjan iwairy taro iwyinonokon me tywaije mandon. Mo'ko Teudas te tywo tywaije man. Irombo iwyinonokonymbo tywotaripa'se mandon. Tuta'se mandon. ");
INSERT INTO car_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ipa'po me morokon atywano meropory jako mo'ko Galilea pono Judas terapa tywaije man. Iwyinonaka ro rypo pyime kari'na tywaije mandon. Mo'ko enapa te tuta'se man. Pa'poro rapa mo'karon iwyinonokonymbo tywotaripa'se mandon. ");
INSERT INTO car_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Iro ke ro wykaje o'waine: mojan wokyryjan poko kytaiton! Inondatoko! Kari'na nisanory me moro inikapyrykon a'ta, kynota'kototan. ");
INSERT INTO car_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Tamusi nisanory me a'ta te, a'kotorykon mupita'ton. Eromembo roten pai Tamusi maro awo'wo'marykon kynotuku'tan.” Irombo iwepanama'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Irombo mo'karon apojoma'san ko'mapo'san rapa i'waine. Ipoky'ma'san mero ika'san i'waine aurana'pa noro iwaito'ko'me Jesus ety ejatory ta. Irombo inonda'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Mo'karon Simosu jopotorykon wyino ito'san, tawa'pore moro tywota'karyka'san poko moro Jesus ety upu'po me. ");
INSERT INTO car_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kurita wararo moro Tamusi auty ta, autokon po enapa kari'na emepatokon. Mo'ko Mesias me Jesus wairy ekapory ekari'satokon aikepy'pa roten. ");
INSERT INTO car_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Moro jako ro, aseme noro pyime mo'karon Tamusi nemeparykon wairy jako, mo'karon Griek auran etanamon Simosu 'wa toruwarykon a'mo'po mo'karon Simosu auran etanamon Simosu poko. Kurita wararo irombo u'ku'pa mo'karon inongepy'san tyworyijatonon enejatokon, moro inongepy'san epano'to'kon ekamyry jako. ");
INSERT INTO car_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Irombo mo'karon ainapatoro itu'ponaka oko apojoma'san 'wa pa'poro mo'karon omepatonon a'nano'po'san. Irombo ika'san: “Na'na 'wa waty man moro Tamusi auranymbo ekarityry nondary, moro arepa, pyrata pai ekamyry eneto'me. ");
INSERT INTO car_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Yja'sakarykon, ara'naine te oko-to'ima takaporamon, a'kanano ni'namororykon, tywonumengaporamon wokyryjan upitoko. Mo'karon andy'mota'ton ro na'na otykon ekanamon me. ");
INSERT INTO car_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Na'na Tamusi 'wa tauranary poko, Tamusi auranymbo ekarityry poko enapa aikepy'pa kynaitan.” ");
INSERT INTO car_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Pa'poro mo'karon ata'nanopy'san apokupe moro we'i'po. Irombo Stefanus, Filipus, Prokorus, Nikanor, Timon, Parmenas, Nikolas apo'i'san i'waine. Mo'ko Stefanus ro poto me Tamusi amyikakon. Tamusi a'kary ni'namorory me kynakon. Mo'ko Nikolas amy Antioki ponombo me kynakon. Simosu me atypo'po me kynakon. ");
INSERT INTO car_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mo'karon oko-to'imanokon aro'san ro i'waine mo'karon apojoma'san po'ponaka. Itu'ponakaine ro tainarykon yry'san mo'karon apojoma'san 'wa, taurana'ma'san mero Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Aseme noro poto me moro Tamusi auran kynaijakon. Aseme noro imero pyime mo'karon omepatonon kynaijatokon Jerusalem po. Pyime imero Tamusi pokonokon 'wa enapa moro iru'pyn oka amyika'po. ");
INSERT INTO car_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Mo'ko Stefanus y'namorojakon ro Tamusi turu'popory, ipori'tory enapa. Potonon anumengaponamon pori'tonano enepojakon. ");
INSERT INTO car_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Irombo te amykon pyitonanokonymbo wota'nano'topo ikato'kon tanokon Simosu awomy'san. Sirene, Aleksandria, Silisia, Asia ponokonymbo mo'karon kynatokon. Taurangon ejukuru a'mo'po i'waine Stefanus maro. ");
INSERT INTO car_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Iwonumengapory amono'ke te iwe'i'san, mo'ko auranano'ponen a'kanano amono'ke enapa. ");
INSERT INTO car_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Irombo amykon wokyryjan erupo'toma'san i'waine, ikato'ko'me: “I'wa Moses ety any'mary, Tamusi ety any'mary enapa etai na'na.” ");
INSERT INTO car_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Iwara mo'karon kari'na apyimy, mo'karon uwapoto'san, mo'karon Tamusi karetary uku'namon enapa apokuma'san i'waine. Stefanus weto ito'san. Apo'i'po i'waine. Irombo aro'po i'waine mo'karon Simosu jopotorykon po'ponaka. ");
INSERT INTO car_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ipo'ponakaine enapa onapi ekari'namon me amykon yry'san i'waine. Mo'karon wyka'san ro: “Mo'se wokyry aikepy'pa yja'wan me o'to kynganon ero Tamusi waitopo poko, moro omenano mero'po poko enapa. ");
INSERT INTO car_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Mo'ko Nasaret pono Jesus 'wa ero aitopo akary man ekarityry etai na'na i'wa, morokon ky'waine Moses nino'san omenano y'petakamary man enapa.” ");
INSERT INTO car_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Irombo pa'poro mo'karon auranano poko aitonon Simosu jopotorykon wo'poty'san Stefanus 'wa onu'ka'pa. Irombo embatary ene'po i'waine amy kapu tano apojonano embatary wara. ");
INSERT INTO car_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Irombo mo'ko Tamusi pokonokon jopotory woturupo'po Stefanus 'wa: “Iporo nan?” ");
INSERT INTO car_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Irombo Stefanus wyka'po: “Yja'sakarykon, yjuwapotorykon, epanamatoko! Mo'ko kurano Tamusi tywosenepo tywaije man mo'ko kytangonymbo Abraham 'wa, Mesopotamie po emamyry jako, Haran 'wa amanje itory uwaporo. ");
INSERT INTO car_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tamusi tyka man i'wa: ‘Moro awomatopombo, mo'karon ajomorykon enapa inoko. Irombo moro o'wa ynekarityry man aitopo 'wa terapa i'tango.’ ");
INSERT INTO car_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Irombo mero mo'karon Kaldea ponokon waitopo tyno i'wa man. Haran 'wa amanje tyto man. Irombo ijumy romby'po mero, Tamusi 'wa tamima man ero erome ajemando'kon nono 'wa. ");
INSERT INTO car_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ero po ro Tamusi amy nono pisara'po pairo anyry'pa tywaije man ainaka, ipajanymbo yinonory me iwaito'me. Otyry me te, ipajanymbo otyry me enapa ero nono yry man tajato i'wa man, i'me'ma iwairy se'me. ");
INSERT INTO car_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tamusi 'wa takari'se enapa tywaije man mo'karon ipajanymbo emamyry man amykon terapa yinonory tu'po, aporemyndorykon man, okupa'emboto ainatone-kari'na siriko ikota'marykon man enapa. ");
INSERT INTO car_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","‘Mo'karon aporemyndonamon poko te a'wembono auranano sytake awu.’ tyka man Tamusi. ‘Irombo mero moro nono wyino kynomimata'ton. Irombo yjety awongata'ton ero po.’ ");
INSERT INTO car_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","“Irombo tywyinono me Abraham wairy enepoto'me moro e'kotono omenano tyje Tamusi 'wa man i'wa. Iwara ro mo'ko tymuru Isak ty'koto Abraham 'wa man, oruwa-to'ima kurita iwe'i'po mero. Moro wara enapa Isak 'wa tymuru Jakob tyje man. Iwara ro rapa Jakob 'wa ty'makon, mo'karon ainapatoro itu'ponaka okonokon Simosu epykon me tywaije mandon inaron tyje mandon. ");
INSERT INTO car_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Tato'keine iwairy ke mo'karon Jakob ymurukon 'wa mo'ko typiry Josef takarama tywaije man, Egypte po amy taporemynen pyitonano me iwaito'me. Tamusi te imaro tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Pa'poro morokon ikota'mato'kon wyino tyka i'wa man. Typyne, tywonumengapore enapa tyje i'wa man mo'ko Egypte jopotory Farao embata. Mo'ko Farao 'wa ro Egypte undymanen me, pa'poro tauty tanokon undymanen me enapa tyje man. ");
INSERT INTO car_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Irombo te poto 'su kumyno tywo'se tywaije man pa'poro moro Egypte 'wa, moro Kana'an 'wa enapa. Poto 'su aikota'mano tywaije man. Mo'karon kytangon tarepange'se tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egypte po arepa wairy eta'po mero, moro 'wa Jakob 'wa mo'karon kytangon tomo'se mandon koromono me. ");
INSERT INTO car_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ijokonory ta ro Josef typiryjan 'wa tywokari'se man. Irombo mo'ko Farao 'wa Josef omorykon tuku'se tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Irombo Josef 'wa tyjumy Jakob taipo tywaije man pa'poro tomorykon maro ro. Oruwa-kari'na itu'ponaka atone'pu kari'na tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Irombo Jakob tywo'pema man Egypte 'wa. Moro po ro kytangonymbo maro tyromo'se man. ");
INSERT INTO car_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Irombo ekepy'san taro mandon Sikem 'wa. Moro po ro mo'ko Abraham 'wa amy atunendopo tapeka'sembo me tywaije man mo'karon Hemor ymurukonymbo wyino. Moro po ro tunenje tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Aseme noro senge moro Abraham 'wa Tamusi wykatopombo wo'kapyry wairy jako, aseme noro enapa mo'karon ka'sakarykon tywotapyimanga tywaije mandon Egypte po. ");
INSERT INTO car_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Irombo amy Josef anukutypyn asery jopoto tawonje man Egypte po. ");
INSERT INTO car_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Moko 'wa ro mo'karon komorykonymbo tykota'ma mandon. Tamu'ma'ma i'wa mandon. Mo'karon kytangonymbo tywyry'ka i'wa mandon mo'karon oma'senangon noto'me i'waine kurando i'ma'to'ko'me. ");
INSERT INTO car_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Moro jako ro Moses tywoma tywaije man. Iru'pyn pitani'membo me tywaije man Tamusi embata. Oruwa nuno tyjumy auty ta tytuwaro'ma tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kurando ino'po mero te, mo'ko Farao emyiry 'wa tanunje tywaije man. Irombo ty'me me tytuwaro'ma i'wa tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Irombo Moses tamepa tywaije i'waine man pa'poro morokon Egypte ponokon nukutyry otykon poko. Taurambore, tamamimbore enapa tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Irombo oko-kari'na siriko tywe'i'po mero, mo'karon ta'sakarykon, mo'karon Israel pajanymbo ene tytory poko tywonumenga tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Irombo amy Egypte pono 'wa yja'wan me amy ta'sakary enary tone i'wa tywaije man. Mo'ko inikota'mary ta'sakary taijoma i'wa tywaije man. Mo'ko Egypte pono poko tarekuru tyka i'wa tywaije man. Tywo i'wa tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moro taijomato'ko'me Tamusi 'wa tomokyry ukutyry takano'se i'wa tywaije man mo'karon ta'sakarykon 'wa. Moro anukuty'pa te tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Irombo koro'po amykon ta'sakarykon wo'wo'mary topoje i'wa tywaije man. Irombo iwo'wo'marykon aike'ka tyto tywaije man. Tyka man i'waine: ‘Yja'sakarykon, asa'sakame mandon! O'tono'me ko yja'wan me asepoko mandon?’ ");
INSERT INTO car_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Mo'ko yja'wan me ta'sakary enanen 'wa Moses tarima tywaije man. Tyka tywaije man: ‘Noky ko na'na undymanen me ajyryi? Noky ko na'na poko a'wembono auranano ynen jopoto me ajyryi? ");
INSERT INTO car_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ywory 'se ka'tu man, koinaro o'wa mo'ko Egypte pono wo'po wara enapa?’ ");
INSERT INTO car_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","“Moro eta'po mero Moses tywetuwarika tywaije man. Midjan 'wa amanje tyto tywaije man. Moro po ro oko wokyryjan typa'kano'se i'wa tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Oko-kari'na siriko pa'po me, moro wypy Sinai pono iponomyn wo'i ta amy Tamusi apojon tywosenepo tywaije man i'wa, amy tyka'muren paremuru ta. ");
INSERT INTO car_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moro ene'po mero, Moses tanuta man. Imenga tytory jako ro, Tamusi auran tota i'wa man: ");
INSERT INTO car_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Awu, atangonymbo tamusiry awu wa, Abraham tamusiry, Isak tamusiry, Jakob tamusiry enapa.’ Moses tywetytyka man. Imenga tytory poko tanarike tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Tamusi te tyka man i'wa: ‘Esapatokako. Moro awaitopo nono kurano me man. ");
INSERT INTO car_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iru'pyn po mo'karon Egypte ponokon ypyitorykon kota'mary senei. Ipu'ningon enapa setai. Iro ke ro wony'toi epano'seine. I'tango. Egypte 'wa komo'sa.’ ");
INSERT INTO car_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moses mo'karon a'sakarykon 'wa turumena tywaije man. Tyka tywaije mandon: ‘Noky ko na'na undymanen me ajyryi? Noky ko na'na poko a'wembono auranano ynen jopoto me ajyryi?’ Inoro ro mo'ko paremuru ta asenepo'po Tamusi apojon 'wa tomo'se tywaije man Tamusi auranymbo me, mo'karon Israel pajanymbo undyma, epano'seine enapa. ");
INSERT INTO car_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Inoro 'wa ro rapa mo'karon ta'sakarykon Egypte wyino taro mandon. Inoro 'wa ro rapa potonon anumengaponamon otykon tanepo man moro Egypte po, moro Tapiren Parana po, moro iponomyn wo'i ta enapa, oko-kari'na siriko iwairy taro. ");
INSERT INTO car_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Inoro ro rapa tyka man mo'karon Israel pajanymbo 'wa: ‘Yjawonga'po wara enapa amy tauran uku'ponen awongatan Tamusi aja'sakarykon ra'na.’ ");
INSERT INTO car_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Inoro 'wa ro rapa moro iponomyn wo'i ta iwota'nanopyrykon jako moro wypy Sinai wyino mo'ko Tamusi apojon auranymbo taro tywaije man mo'karon kytangonymbo 'wa. Amano ynamon auranano tapyije i'wa man yto'me ky'waine. ");
INSERT INTO car_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mo'karon kytangonymbo te tywepanamarykon 'se'pa tywaije mandon i'wa. Tywotu'ma iwyino tywaije mandon. Egypte po tywairykon po tywo'po'se rapa tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","A'aron 'wa tyka tywaije mandon: ‘Kytamusirykon me amykon ika'ko, kuwapoine itoto'ko'me. One wara mo'ko Egypte wyino kane'namonymbo Moses we'i'po irombo atukuty'pa man.’ ");
INSERT INTO car_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","“Irombo amy paka'membo tyka'se i'waine tywaije man. Mo'ko tynikapy'san tamusi 'wa amy tywomy tyje i'waine tywaije man. Moro aseke tynikapy'san tawa'ma i'waine man. ");
INSERT INTO car_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Irombo Tamusi tywotu'ma iwyinoine tywaije man. Tynonda i'wa tywaije mandon morokon kapu rary pokonokon otykon ety awongato'me i'waine. Iwara ro enapa tymero man moro Tamusi auran uku'ponamonymbo karetary ta: “Israel pajanymbo, tywomykon 'kare mysen y'wa moro iponomyn wo'i ta oko-kari'na siriko. ");
INSERT INTO car_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Moro Molok auty kore maropo'sen, ran, moro atamusirykon Raifa sirikory enapa. Mo'karon ro mu'kusen, ipo'ponakaine awokunamato'ko'me. Iro ke ro Babylon ko'po tyse kamimata'ton.” ");
INSERT INTO car_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Moro iponomyn wo'i ta mo'karon kytangonymbo ekosa moro taropotymy Tamusi auty, moro Tamusi wykato'konymbo waito'kon auto tywaije man. Moro auto ro mo'ko torupanenymbo nekarity'po wara ro tyka'se Moses 'wa tywaije man, moro inenepo'po wara ro. ");
INSERT INTO car_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Morombo wyino ro mo'ko Josua maro mo'karon kytangonymbo 'wa moro Tamusi auty taro tywaije man moro Tamusi anukuty'non wyino tynipinarykon nono taka. Uwapoine Tamusi 'wa mo'karon tukuty'non tymoma tywaije mandon. Ty'makonymbo 'wano me moro Tamusi auty tynopo'se mo'karon kytangonymbo 'wa tywaije man, morokon David emando'kon siriko 'wa ro. ");
INSERT INTO car_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Mo'ko ro typyne tywaije man Tamusi embata. Irombo tywoturupo tywaije man mo'karon Jakob pajanymbo ra'na amy Tamusi auty man amyto'me ty'wa. ");
INSERT INTO car_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Mo'ko Salomo 'wa te amy Tamusi 'wano auto tamy tywaije man. ");
INSERT INTO car_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Mo'ko inorombo ro kawono te ainanano nikapy'san ta emamy'pa man. Mo'ko Tamusi auran uku'ponenymbo irombo tyka man: ");
INSERT INTO car_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Moro kapu ywotandy'motopo me man, kynganon Tamusi. Moro nono ypupuru apo'ny me man. Otypan auto amyry 'se ko mandon y'wa? Otypan ywotare'mato'man amyry 'se ko mandon? ");
INSERT INTO car_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yjainary 'kare pa'poro morokon otykon anikapy'pa ne'i.” ");
INSERT INTO car_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Senu'ka pangon 'ne roten! Aturu'san Tamusi anamyika'pa man. Apanarykon Tamusi 'wa epanama'pa man. Tamusi a'kary arimary poko roten mandon amyjaron mo'karon atangonymbo we'i'san wara enapa. ");
INSERT INTO car_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nokypan Tamusi auran uku'ponenymbo aniwekena'pa ko mo'karon atangonymbo erekuru tywaije nan? Mo'ko tamamboren wopyry man ekari'namonymbo ro rypo tywo i'waine tywaije mandon. Mo'ko tamamboren ko'wu o'waine takarama man. O'waine tywo man. ");
INSERT INTO car_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Tamusi apojongon wyino moro omenano mero'po tapyije o'waine tywaije man. Anamyika'pa te tywaije mandon.” ");
INSERT INTO car_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Moro eta'po mero, mo'karon Simosu jopotorykon wore'ko'san. Ipoko imero iwaijeky'san. ");
INSERT INTO car_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mo'ko Tamusi a'kary mo'ko Stefanus y'namorojakon. Kapu 'wa onu'ka'pa kyno'po'sakon. Tamusi kuranory ene'po i'wa. Jesus ene'po i'wa pyre Tamusi apo'tun wyino. ");
INSERT INTO car_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Irombo ika'po: “Eneko, morokon kapu wendaka'san seneja. Mo'ko kari'na ymuru seneja pyre Tamusi apo'tun wyino.” ");
INSERT INTO car_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Mo'karon Simosu jopotorykon ko'ta'san te mo'ja imero. Iwepanapu'to'san. Asewara imero itu'ponaka iwotunsi'ko'san. ");
INSERT INTO car_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Moro aitopo wyino ikyryryka'po i'waine, topu pa'to'me i'waine itu'ponaka. Mo'karon emendonamonymbo 'wa tynoponykon yry'san amy Saulus tatynen pyito pupuru po. ");
INSERT INTO car_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Irombo topu papy'san i'waine Stefanus tu'ponaka, mo'ko Jopoto ejatory jako ro i'wa: “Jopoto Jesus, yja'kary apyiko.” ");
INSERT INTO car_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Irombo iwokunama'po. Iko'ta'po: “Jopoto! Ero yja'wan me iwe'i'san poko kyto'potyi!” Moro wara tyka'po wyino iwopisamy'po. ");
INSERT INTO car_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulus 'wa enapa moro Stefanus wory epory'po iru'pa. Moro jako ro mo'karon Jerusalem ponokon Tamusi na'nanopy'san weto kyndopo'satokon. Pa'poro mo'karon Kristus wyinonokon wotaripapy'san wararo Judea, Samaria wo'irykon taka. Mo'karon apojoma'san we'i'san roten te ataripapy'pa. ");
INSERT INTO car_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Amykon Tamusi amyikanamon Simosu 'wa Stefanus unemy'po. Ty'popurukon po'po'mary ta imero amo'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Irombo Saulus 'wa mo'karon Tamusi na'nanopy'san kota'mary aro'po. Wararo morokon autokon taka tywo'myry aro'po i'wa. Wokyryjan, woryijan kyryrykapotyry aro'po i'wa, aru'kato'ko'me yja'wangon kari'na aru'katopo taka. ");
INSERT INTO car_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mo'karon ataripapy'san 'wa te moro iru'pyn oka ekarityry aro'po aito'kon wararo. ");
INSERT INTO car_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Iwara ro Filipus tunda'po moro Samaria tano poto 'su aitopo 'wa. Moro po ro mo'ko Mesias ekaro'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Irombo tywe'i'san mero mo'karon kari'na apyimykon 'wa morokon Filipus wyka'san apo'i'san typanarykon ta, moro i'wa tywepanamarykon jako, morokon inenepory kapu wyinonokon otykon enery jako enapa. ");
INSERT INTO car_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Pyime yja'wan akywanopangonymbo wyino mo'karon akyrykonymbo wepa'ka'san tyko'ke. Pyime enapa iwajakuta'san, syky'ta me ytotononymbo kura'ma'san. ");
INSERT INTO car_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Irombo poto 'su awa'ponano wopy'po moro aitopo taka. ");
INSERT INTO car_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Irombo te amy Simon tatynen wokyry moro aitopo po kynakon. Tamoreke kynakon. Penaro terapa mo'karon Samaria ponokon enumengapojakon. Poto me kynokari'sakon. ");
INSERT INTO car_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Pa'poro kari'na, po'ponokon, kawonokon enapa, kawo kynapyijatokon. Kyngatokon: “Moro poto 'su Tamusi pori'tory ikato'kon mo'se man.” ");
INSERT INTO car_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Kawo mo'karon kari'na kynapyijatokon, akore'pe terapa amorery 'wa tanumengaporykon ke. ");
INSERT INTO car_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipus 'wa te moro Tamusi nundymary, moro Jesus Kristus ety enapa ekaro'po mero, amyika'po i'waine. Wokyryjan, woryijan enapa wosetykapo'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Mo'ko Simon 'wa ro rypo amyika'po. Tywosetykapo'po wyino, Filipus ekosa roten terapa iwe'i'po. Morokon potonon pori'tonano wo'kapyry enery kynenumengapojakon. ");
INSERT INTO car_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria ponokon 'wa Tamusi auranymbo apo'i'po eta'po mero ty'waine, mo'karon Jerusalem ponokon apojoma'san 'wa Johanes emoky'po Petrus maro eneine. ");
INSERT INTO car_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Moro 'wa tytunda'san mero, Tamusi 'wa iwoturupo'san ta'kary emo'to'me i'wa itu'ponakaine. ");
INSERT INTO car_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Amy pairo tu'ponaka irombo mo'ko Tamusi a'kary opy'pa na'nen tywaije kynakon. Tatyka roten te kynatokon mo'ko Jopoto Jesus ety ta. ");
INSERT INTO car_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Irombo Petrus 'wa Johanes maro tainarykon yry'san itu'ponakaine. Irombo Tamusi a'kary wopy'po itu'ponakaine. ");
INSERT INTO car_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Moro kari'na tu'ponaka mo'karon apojoma'san 'wa tainarykon yry 'wa mo'ko Tamusi a'kary ene'pory ene'po mero, pyrata yry 'se mo'ko Simon we'i'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ika'po iwaine: “Moro pori'tonano y'wa enapa yko, mo'ko Tamusi a'kary wo'to'me, yjainary yry'poto y'wa yja'sakary tu'ponaka.” ");
INSERT INTO car_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Petrus wyka'po te i'wa: “Amoro ro apyratary maro ajuta'ko! Pyrata poko ka'tu moro Tamusi nyry apyiry mekano'san? ");
INSERT INTO car_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","O'wano me kapyn ero oty man. Aturu'po irombo iru'pa waty man Tamusi embata. ");
INSERT INTO car_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Moro oja'wanymbo wyino atu'mako. Tamusi 'wa aturupoko moro yja'wan me aturu'po wonumengary kato'me. ");
INSERT INTO car_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Itumbato mana. Amano any'manen me kaneja.” ");
INSERT INTO car_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Irombo Simon 'wa ejuku'po: “Amyjaron te yjekataka Tamusi 'wa ajauranatoko amy pairo awykatopombo oty waito'me yjepory'pa.” ");
INSERT INTO car_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Mo'ko Jopoto auranymbo amyikapory poko tywe'i'ma'san mero, Jerusalem 'wa rapa tytorykon a'mo'po i'waine. Tytorykon jako ro pyime Samaria ponokon aitopo'makon ta moro iru'pyn oka ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Amy Tamusi apojon wyka'po te Filipus 'wa: “Ajawongo. Koine 'wa aiko me moro Jerusalem wyino Gasa 'wa ytototo oma ta. Iponomyn po moro oma man.” ");
INSERT INTO car_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Irombo awomy'po. Ito'po. Moro jako 'ne amy Etiopi pono kyny'sakon Jerusalem wyino. Mo'ko Kandake, mo'ko Etiopi pono woryi jopoto pyitory amy mo'ko kynakon. Pa'poro ipyratary enenen me kynakon. Jerusalem 'wa tyto tywaije man Tamusi ety awonga. ");
INSERT INTO car_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Mo'ko ro auto 'wa rapa kyny'sakon. Tytararary ta tywotandy'mo'po po mo'ko Tamusi auran uku'ponenymbo Jesaja nimero'po erupakon. ");
INSERT INTO car_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Irombo mo'ko Tamusi a'kary wyka'po Filipus 'wa: “Moro tarara ponaronaka i'tango. Irombo aporito i'tango.” ");
INSERT INTO car_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Tarawone Filipus wyto'po iwyinonaka. Irombo mo'ko Tamusi auran uku'ponenymbo Jesaja nimero'po erupary eta'po i'wa. Ika'po: “Muku'san iro ke moro anerupary?” ");
INSERT INTO car_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Irombo ika'po: “One wara ko suku'tan, anekarity'pa amy a'ta o'to tauro'po me iwairy?” Irombo Filipus 'wa iwoturupo'po iwotaru'kato'me, taporitonaka atandy'mo. ");
INSERT INTO car_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ero Tamusi karetary wota'saka'po inerupary me kynakon: Amy iwoto'me inarorykon kapara wara tyndary anetapurumaka'pa man. Amy typokanen ainano kapara'membo wara ity'me man. ");
INSERT INTO car_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ikota'mary jako o'to iwe'i'po imenga'pa man. Noky ko mo'karon emamyry a'sakarykon ekari'tan? Ero nono tu'po irombo emamyrymbo aike'katon. ");
INSERT INTO car_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Irombo mo'ko Kandake pyitory wyka'po Filipus 'wa: “Waturupoja o'wa, noky poko ko mo'ko Tamusi auran uku'ponenymbo naurananon? Aseke typoko? Amy terapa poko te ka'tu?” ");
INSERT INTO car_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Irombo Filipus 'wa tauranary a'mo'po. Moro imero'po wyino ro mo'ko Jesus ekapory ekarity'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Oma ta tytorykon jako, amy tuna pato ito'san. Irombo mo'ko Kandake pyitory wyka'po: “Eneko! Mony amy tuna. Oty ko ywosetykary a'kototan?” ");
INSERT INTO car_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Irombo moro tytararary poro'kapo'po i'wa. Okororo ito'san moro tuna taka, Filipus mo'ko Kandake pyitory maro. Irombo Filipus 'wa mo'ko Kandake pyitory etyka'po. ");
INSERT INTO car_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Moro tuna wyino iwonuku'san mero, mo'ko Tamusi a'kary 'wa Filipus aro'po moro wyino. Anene'pa noro mo'ko Kandake pyitory we'i'po. Mo'ja ro ito'po tawa'pore. ");
INSERT INTO car_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filipus te typo roten Asoto po terapa kynakon. Tytory jako ro mo'ja ro, pa'poro aito'kon po moro iru'pyn oka ekarity'po i'wa, Sesarea 'wa tytundary 'wa ro. ");
INSERT INTO car_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Amy anari me noro mo'ko jopoto nemeparykon 'wa mo'ko Saulus kynakon. Uta'karykon man ejatopo'sakon. Irombo mo'ko Tamusi pokonokon jopotory 'wa ito'po. ");
INSERT INTO car_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Morokon Damaskus po Simosu wota'nano'to'kon 'wanokon kareta poko iwoturupo'po i'wa. Morokon kareta ke ro oma epory 'se kynakon mo'karon tyneporykon man Jesus wyinonokon wokyryjan, woryijan enapa apyito'ko'me, irombo Jerusalem 'wa aroto'ko'me. ");
INSERT INTO car_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Irombo itory jako ro tyse waty Damaskus wyino i'wei'po mero, typo roten kapu wyino amy anusi'kanen aweinano wopy'po ijondo. ");
INSERT INTO car_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nono tu'ponaka iwoma'po. Irombo amy auranano wykary eta'po i'wa ty'wa: “Saul, Saul, o'tono'me ko moro ajerekuru ywekenanon?” ");
INSERT INTO car_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Irombo ika'po: “Noky ko amoro man, Jopoto?” Ejuku'po i'wa: “Mo'ko aniwekenary Jesus awu wa. ");
INSERT INTO car_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ajawongo te. I'tango moro aitopo 'wa. Moro po ro metatake o'to awairy man.” ");
INSERT INTO car_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Mo'karon imaro ytotonon wokyryjan enuta'san imero. O'to pairo yka'pa iwe'i'san. Tota ro rypo moro auranano i'waine kynakon. Amy kari'na anene'pa te kynatokon. ");
INSERT INTO car_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Irombo Saulus awomy'po rapa nono wyino. Tanuru etapurumaka'po se'me, oty anene'pa terapa kynakon. Apory poko terapa aro'po i'waine Damaskus 'wa. ");
INSERT INTO car_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oruwa kurita iwairy taro oty anene'pa kynakon. Endame'pa, o'nyry'pa enapa kynakon. ");
INSERT INTO car_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Moro aitopo Damaskus po te amy Ananias tatynen omepatoto kynakon. Mo'ko 'wa ro mo'ko Jopoto wosenepo'po iwonetono wara. Ika'po i'wa: “Ananias!” Irombo ejuku'po i'wa: “Ero po wa, Jopoto.” ");
INSERT INTO car_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Mo'ko Jopoto wyka'po i'wa: “Ajawongo. I'tango moro Sapatorono Oma tatynen taka, moro Judas auty 'wa. Moro po ro amy Saulus tatynen Tarsus pono poko aturupoko. Tamusi 'wa irombo kynaurananon. ");
INSERT INTO car_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Amy tywonetono wara amy Ananias tatynen wokyry wo'myry enei. I'wa ro tainary yry enei tytu'ponaka, oty eneto'me rapa ty'wa.” ");
INSERT INTO car_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias 'wa ejuku'po: “Jopoto, pyime kari'na wyino setai mo'ko wokyry 'wa Jerusalem po mo'karon awyinonokon kota'ma'ma'san imero. ");
INSERT INTO car_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ero po pairo pa'poro mo'karon ajety ejatonamon apyiry tyje man ainaka mo'karon Tamusi pokonokon jopotorykon 'wa.” ");
INSERT INTO car_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Mo'ko Jopoto wyka'po te i'wa: “I'tango. Mo'ko irombo yjemamin ka'nen me sapo'i. Mo'ko ro yjety ekary arotan Simosu me e'i'non 'wa, potonon jopotokon 'wa, mo'karon Israel pajanymbo 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Awu ro i'wa senepotake one wara iwota'karykary man yjety upu'po me.” ");
INSERT INTO car_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Irombo Ananias wyto'po. Iwo'my'po moro auto taka. Tainary yry'po i'wa Saulus tu'ponaka. Irombo ika'po: “Saul, yja'sakary, mo'ko jopoto yjemokyi o'wa, mo'ko Jesus, mo'ko awo'topombo oma ta tywosenepo o'wa man inoro. Oty enery 'se rapa o'wa man. Tamusi a'kary 'wa o'namorory 'se man.” ");
INSERT INTO car_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","O'win wytory imero enuru we'i'po o'karangatoto wara. Oty ene'po rapa i'wa. Awomy'po. Irombo iwosetykapo'po. ");
INSERT INTO car_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Iwendame'po. Iwara te iwepana'toma'po rapa. Amykon kurita noro Damaskus po Saulus we'i'po mo'karon omepatonon ekosa. ");
INSERT INTO car_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","O'win wytory imero morokon Simosu wota'nano'to'kon ta Tamusi ymuru me mo'ko Jesus wairy ekarity'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Pa'poro mo'karon auran etanamon enuta'san imero. Ika'san: “Mo'ko Jerusalem po moro atywano ejatonamon y'ma'kanen kapyn mo'se nan? Ijaro 'wa opy'pa tywaije nan apyijeine, aroto'ko'me mo'karon Tamusi pokonokon jopotorykon 'wa?” ");
INSERT INTO car_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Aseme noro pari'pe mo'ko Saulus kynaijakon. Mo'karon Damaskus ponokon Simosu wonumengary e'mito'po'po i'wa, mo'ko Mesias me mo'ko Jesus ekarityry ke. ");
INSERT INTO car_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Amykon kurita pa'po me mo'karon Simosu worupa'san terapa iwory poko. ");
INSERT INTO car_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saulus 'wa te moro ukuty'po. Koko, kurita wararo moro aitopo penarykon erandojatokon mo'karon Simosu iwoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Irombo koko mo'karon inemeparykon 'wa aro'po. Amy kurukuru ta eny'topo'po i'waine kurandonaka moro aitopo a'kototy wyino. ");
INSERT INTO car_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Irombo Jerusalem 'wa tytunda'po mero, mo'karon omepatonon apyimy taka tywo'myry poko Saulus kyne'kujakon. Pa'poro te tanarike ipoko kynatokon. Amy omepatoto me iwairy anamyika'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas 'wa te aro'po mo'karon apojoma'san 'wa. Moro one wara Saulus 'wa oma ta mo'ko Jopoto ene'po, moro i'wa erupa'po, moro one wara Damaskus po enari'ma Jesus ety ta aurana'po enapa ekarity'po i'wa i'waine. ");
INSERT INTO car_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Iwara te Saulus we'i'po ekosaine moro Jerusalem po. Enari'ma mo'ko Jesus ety ta kynauranakon. ");
INSERT INTO car_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Mo'karon Griek auran etanamon Simosu aurangon eju'sakon. Mo'karon te iwory 'se terapa kynatokon. ");
INSERT INTO car_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Moro ukuty'po mero ty'waine, mo'karon Jesus wyinonokon 'wa Sesarea 'wa aro'po. Moro wyino ro Tarsus 'wa aropo'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Moro jako pa'poro moro Judea po, Galilea po, Samaria po enapa mo'karon Tamusi na'nanopy'san sara'me kynemanjatokon. Aseme noro ituru'san kynepori'tomatokon. Tamusi nendojatokon. Aseme noro kynotapyimangatokon mo'ko Tamusi a'kary 'wa tapanopyrykon ta. ");
INSERT INTO car_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Moro wararo tytopotyry jako, mo'karon Lida ponokon Tamusi wyinonokon 'wa enapa Petrus tunda'po. ");
INSERT INTO car_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Moro po ro amy Eneas tatynen wokyry epory'po i'wa. Oruwa-to'ima siriko ta'tanombo po ro tywo'ny'topo tu'po roten iwaitopo kynakon. ");
INSERT INTO car_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Wajaku pe kynakon. Mo'ko 'wa ro Petrus wyka'po: “Eneas! Jesus Kristus iru'pa rapa ajyjan. Ajawongo! Moro awo'ny'topo iru'pa yko!” O'win wytory imero awomy'po. ");
INSERT INTO car_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Pa'poro mo'karon Lida ponokon 'wa, Saron ponokon 'wa ene'po. Irombo mo'ko Jopoto wyinonaka iwotu'ma'san. ");
INSERT INTO car_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Moro Jope po amy Tabita tatynen omepatoto woryi kynakon. Griek auran ta Dorkas me moro atywano man. Mo'ko 'wa ro pyime ta'sakarykon epano'topo kynakon otykon poko. ");
INSERT INTO car_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Mo'ko any'ta'po ro moro jako. Irombo iromby'po. Iku'mity'po wyino kawonaka aro'po i'waine amy apu'to'po taka. ");
INSERT INTO car_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Moro Lida tyse waty man Jope wyino. Moro po Petrus wairy eta'po mero ty'waine, mo'karon omepatonon 'wa oko wokyryjan emoky'san i'wa “Ko'i terapa o'ko 'ne na'na 'wa!” tauro me. ");
INSERT INTO car_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Irombo Petrus awomy'po. Ito'po imaroine Jope 'wa. Moro 'wa tytunda'po mero, kawonaka aro'po i'waine moro apu'to'po taka. Irombo pa'poro mo'karon inongepy'san wota'nanopy'san ekondaka. Tywotamorykon ta wo'mynano, noponano enepojatokon. Morokon ka'sakon ro Dorkas, nuro noro ta'ta. ");
INSERT INTO car_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrus 'wa te pa'poro emoky'san kurandonaka. Tywokunama'po mero Tamusi 'wa aurana'po. Irombo mo'ko iromby'po 'wa iwotu'ma'po. Ika'po: “Tabita! Ajawongo!” Irombo tanuru etapurumaka'po i'wa. Petrus ene'po mero awomy'po. Tandy'po iwe'i'po. ");
INSERT INTO car_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ainary poko awonga'po Petrus 'wa. Irombo mo'karon Tamusi wyinonokon, mo'karon inongepy'san enapa ko'ma'san i'wa. Tarena rapa mo'ko woryi yry'po i'wa ipo'ponakaine. ");
INSERT INTO car_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Pa'poro moro aitopo Jope ta ro moro oka wota'po. Pyime kari'na we'i'san mo'ko Jopoto amyikanamon me. ");
INSERT INTO car_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrus we'i'po a'si'ko akore'pe moro Jope po, amy tonomy pi'pombo ka'nen Simon ekosa. ");
INSERT INTO car_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesarea po amy Kornelius tatynen wokyry kynemanjakon. Amy Itali ety tano warinu pokonokon apyimy wota'saka'po jopotory me kynakon. ");
INSERT INTO car_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Tamusi nendojakon. Pa'poro tauty tanokon maro Tamusi ety awongatopo i'wa kynakon. Mo'karon oty'non ainary'totopo i'wa kynakon. O'kapyn roten Tamusi 'wa auranatopo kynakon. ");
INSERT INTO car_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mo'ko 'wa ro amy kurita, koine, oruwa juru a'ta pai, tanuja'kandary ta amy Tamusi apojon wo'myry ene'po ty'wa. Ika'po i'wa: “Kornelius!” ");
INSERT INTO car_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","I'wa ro Kornelius wo'poty'po. Iwety'kapo. Ika'po: “Oty ko moro nan, jopoto?” Mo'ko Tamusi apojon wyka'po i'wa: “Moro ty'wa ajauranapoty'po poko, mo'karon oty'non ainary'topoty'po poko enapa Tamusi ituwarengepy'pa man. ");
INSERT INTO car_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Erome amykon wokyryjan emo'ko Jope 'wa, Simon, mo'ko Petrus me enapa kynejatojaton inoro ko'ma. ");
INSERT INTO car_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Amy tonomy pi'pombo emaminano'nen Simon ekosa man. Mo'ko ro parana po kynemanjan.” ");
INSERT INTO car_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Mo'ko torupanenymbo Tamusi apojon wyto'po mero, oko amykon typyitorykon, o'win amy Tamusi nendonen toran enapa ko'ma'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Pa'poro oty poko erupa'ma'san mero, emoky'san i'wa Jope 'wa. ");
INSERT INTO car_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Irombo koro'po itorykon jako, moro aitopo 'wa tytundarykon 'wa iwe'i'san mero, Petrus wonuku'po auto tu'ponaka, Tamusi 'wa aurana. Kurita 'ne 'ne kynakon moro jako. ");
INSERT INTO car_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Irombo ikumyry'po. Tywendamery po terapa iwo'poty'po. Iwetuma'mo'karykon jako ro tanuja'kandary a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Kapu wendaka'po ene'po i'wa. Poto 'su kamisa eneke amy oty eny'topory ene'po i'wa morokon okupa'en ipanakujarykon poko. ");
INSERT INTO car_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ita ro ukuty'pa 'ne roten okupa'en ipupuru aitonon, tuwembo poko ytotonon, tonoro enapa kynatokon. ");
INSERT INTO car_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Irombo amy auranano eta'po i'wa: “Ajawongo, Petrus! Iwoko! Onoko!” ");
INSERT INTO car_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petrus wyka'po te: “Uwa pore, Jopoto! Ywe'i'po poro nurijangon no'kan anono'pa wa.” ");
INSERT INTO car_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ijokonory ta ro amy auranano wyka'po i'wa: “Pa'poro Tamusi nekarity'po irupa yja'wan me kysekarityi.” ");
INSERT INTO car_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oruwamboto moro wara iwe'i'po. Irombo o'win wytory rapa moro oty awo'nuku'po kapu taka. ");
INSERT INTO car_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Oty me 'ne moro tynene'po oty wairy poko tywonumengary anukuty'pa Petrus kynakon. Moro jako ro mo'karon Kornelius napojoma'san wokyryjan 'wa tywoturupo'san wyino moro Simon auty epory'po. Pena po kynatokon. ");
INSERT INTO car_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Moro auto ta Simon, mo'ko Petrus me enapa kynejatojaton inoro wairy poko mo'ja kynoturupojatokon. ");
INSERT INTO car_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Moro tynene'po poko Petrus wonumengary jako noro, mo'ko Tamusi a'kary wyka'po i'wa: “Eneko! Oruwa wokyryjan ajupijaton. ");
INSERT INTO car_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ajawongo iro ke. Ony'toko. O'to yka'pa i'tango imaroine. Awu ro sene'poton.” ");
INSERT INTO car_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Petrus wony'to'po. Mo'karon wokyryjan 'wa ika'po: “Eneko! Awu te mo'ko anupirykon me wa. Oty poko ko ijaro 'wa mo'ton?” ");
INSERT INTO car_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Irombo ika'san: “Amy Kornelius tatynen warinu pokonokon jopotory man. Tamambore man. Tamusi nendojan. Pa'poro Simosu ekosa takapore man. Mo'ko 'wa ro amy Tamusi apojon wyino amy oka tota man, tauty 'wa ajaipoto'me, amy auranano etato'me awyino.” ");
INSERT INTO car_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Irombo a'myka'san i'wa. Iwo'ny'to'kon man ekarity'po i'wa i'waine. Irombo koro'po awomy'po. Imaroine ito'po. Amykon Jope ponokon Kristus wyinonokon wyto'san imaro. ");
INSERT INTO car_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Irombo koro'po itunda'po Sesarea 'wa. Kornelius kynimomo'satokon. Mo'karon tomorykon, mo'karon tynipynarykon ta'sakarykon enapa ta'nano'po terapa i'wa kynatokon. ");
INSERT INTO car_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tauty taka Petrus wo'myry jako, Kornelius wopy'po epoje. Ipo'ponaka iwokunama'po. ");
INSERT INTO car_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Petrus 'wa te awonga'po. Ika'po: “Ajawongo! Awara enapa kari'na me wa.” ");
INSERT INTO car_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Torupary jako ro i'wa, Kornelius 'wa a'myka'po. Moro auto ta pyime kari'na wota'nanopy'san epory'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Irombo ika'po i'waine: “Amy Simosu 'wa waty man amy Simosu me e'ipyn apyiry ta'sakary me, etawary pai. Moro waty muku'saton. Y'wa te Tamusi yja'wan me kari'na nurija'mary wairy enepoi. ");
INSERT INTO car_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Iro ke ro o'to yka'pa wopyi, yko'mapo'po mero o'waine. Ekari'toko iro ke oty poko yko'mapo'po o'waine.” ");
INSERT INTO car_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Irombo Kornelius wyka'po: “Mony 'ne koinaro, oruwa juru a'ta Tamusi 'wa yjauranakon yjauty ta. ");
INSERT INTO car_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Typo roten amy wokyry we'i'po yjembata. Iwo'my typotyre kynakon. Ika'po y'wa: ‘Kornelius, moro ty'wa ajauranapoty'po tota Tamusi 'wa man. Moro o'wa oty'non ainary'topoty'po poko enapa Tamusi ituwarengepy'pa man. ");
INSERT INTO car_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Apojonano emo'ko Jope 'wa, Simon, mo'ko Petrus me enapa kynejatojaton inoro ko'ma. Amy tonomy pi'pombo emaminano'nen Simon auty po man, parana po.’ ");
INSERT INTO car_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Irombo o'win wytory apojonano semokyi o'wa ajaije. Iru'pa 'ne man awopy'po. Erome ko'wu pa'poro na'na ero po man Tamusi embata, pa'poro morokon o'wa Tamusi wykato'konymbo etato'me.” ");
INSERT INTO car_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Irombo Petrus 'wa eruparykon a'mo'po. Ika'po: “Erome te sukutyi Tamusi embata pa'poro kari'na wairy asewara. ");
INSERT INTO car_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Pa'poro inendonen, pa'poro tamamboren Tamusi apokupe man. Noky me iwairy poko o'poty'pa Tamusi man. ");
INSERT INTO car_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ero moro Israel pajanymbo 'wa Tamusi naropo'po iru'pyn oka me man: Jesus Kristus mo'ko pa'poro kari'na Jopotory me man inoro ekosa sara'me aino epory taro pa'poro kari'na man. ");
INSERT INTO car_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Pa'poro moro Judea po otypan oty we'i'po muku'saton. Galilea po moro oty tywota'mo man, Johanes 'wa moro asetykapono ekarory a'mo'po wyino. ");
INSERT INTO car_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Mo'ko Nasaret pono Jesus irombo ty'namoro Tamusi 'wa man ta'kary ke, pori'tonano ke enapa, apojomato'me. Kurangon otykon kapyry taropo'se mo'ko Jesus 'wa man. Pa'poro mo'karon ewa'rumy tamuru naporemyndo'san kura'mary enapa taropo'se i'wa man. Tamusi irombo imaro tywaije man. ");
INSERT INTO car_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Na'na ro pa'poro o'to Simosu waito'kon ta, Jerusalem po enapa iwe'i'po amyikaponamon me man. Wakapu poko tysereremapo i'waine man, iromo'to'me. ");
INSERT INTO car_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tamusi 'wa te ijoruwanory kurita tawongapo rapa man. Tanepo i'wa man mo'ko Jesus ");
INSERT INTO car_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","pa'poro 'ne kari'na 'wa kapyn, mo'karon oty amyikaponamon me inapo'i'sanymbo 'wa roten te. Inaron ro na'na man. Na'na ro imaro kynendamen, kynonynen, moro awomy'po wyino. ");
INSERT INTO car_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Oty amyikaponamon me na'na 'wa tyka man nuronokon poko, iromby'san poko enapa a'wembono auranano ynen jopoto me Tamusi 'wa tyry'po ekari'to'me mo'karon kari'na 'wa. ");
INSERT INTO car_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mo'ko ety ta ro pa'poro mo'ko amyikanen yja'wanymbo wo'kary amyikapojaton pa'poro mo'karon Tamusi auran uku'ponamonymbo.” ");
INSERT INTO car_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus 'wa morokon otykon ekarityry jako noro, mo'ko Tamusi a'kary wopy'po pa'poro mo'karon auran etanamon tu'ponaka. ");
INSERT INTO car_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Pa'poro mo'karon Petrus maro opy'san i'koto'san Kristus wyinonokon enuta'san imero mo'ko Tamusi nyry a'kanano wopy'po poko mo'karon Simosu me e'i'non tu'ponaka enapa. ");
INSERT INTO car_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ukuty'non auranano ta irombo auranarykon etatokon. Tamusi ety awongary etatokon enapa i'waine. Irombo mero Petrus wyka'po: ");
INSERT INTO car_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Amy kari'na 'kare tuna ke etykarykon a'kotory taro nan. Kywaraine enapa irombo Tamusi a'kary tapyije i'waine man.” ");
INSERT INTO car_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Irombo Jesus Kristus ety ta etykapo'san i'wa. Morombo mero iwoturupo'san i'wa amykon kurita noro tokosaine iwaito'me. ");
INSERT INTO car_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Mo'karon Simosu me e'i'non 'wa moro Tamusi auranymbo amyika'po eta'po Judea po mo'karon apojoma'san 'wa, mo'karon Kristus wyinonokon 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Petrus wonuku'po mero te Jerusalem 'wa, mo'karon i'koto'san Kristus wyinonokon wonumengary o'win e'i'pa kynakon moro Petrus wonumengary maro. ");
INSERT INTO car_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ika'san: “I'koto'non auty taka tywo'my mana. Imaroine tywendame mana.” ");
INSERT INTO car_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Petrus 'wa te pa'poro morokon o'kapy'san otykon ekarityry a'mo'po koromono wyinombo ro. Ika'po: ");
INSERT INTO car_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Moro aitopo Jope po yjauranakon Tamusi 'wa. Moro jako ro yjenuja'kandary a'mo'po y'wa. Moro yjenuja'kandary jako ro, kapu wyino poto 'su kamisa eneke amy oty eny'topory ene'po y'wa morokon okupa'enokon ipanakujarykon poko. Y'wa imero moro oty wopy'po. ");
INSERT INTO car_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Itaka ywo'potyry jako ro okupa'en ipupuru aitonon tonomy, tokonamon tonomy, tuwembo poko ytotonon, tonoro ene'san y'wa. ");
INSERT INTO car_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Amy auranano wykary eta'po enapa y'wa: ‘Ajawongo, Petrus! Iwoko! Onoko!’ ");
INSERT INTO car_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Ywyka'po te: ‘Uwa pore, jopoto! Ywe'i'po poro nurijangon no'kan anaru'ka'pa wa yndaka.’ ");
INSERT INTO car_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ijokonorymbo ta ro kapu wyino amy auranano wota'po, yjeju'to'me: “Pa'poro Tamusi nekarity'po irupa yja'wan me kysekarityi.” ");
INSERT INTO car_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oruwamboto moro wara iwe'i'po. Irombo pa'poro rapa kapu taka awo'nuku'san. ");
INSERT INTO car_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Morombo mero o'win wytory oruwa wokyryjan tunda'san moro na'na waitopo auto 'wa. Sesarea wyino y'wanokon me tomo'se tywaije kynatokon. ");
INSERT INTO car_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Mo'ko Tamusi a'kary wyka'po y'wa esyka'pa imaroine ywytoto'me. Ymaro ro mojan o'win-to'ima ka'sakarykon wyto'san. Irombo mo'ko yko'maponenymbo wokyry auty taka na'na wo'my'po. ");
INSERT INTO car_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mo'ko 'wa ro na'na 'wa moro one wara ty'wa tauty ta mo'ko Tamusi apojon ene'po ekarity'po. Ero wara mo'ko apojonano wyka'po ekarity'po i'wa: ");
INSERT INTO car_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","‘Apojonano emo'ko Jope 'wa Simon, mo'ko Petrus me enapa kynejatojaton inoro ko'ma. Mo'ko ro ajerupatan, uta'no wyino ajunendo'me, pa'poro ajauty tanokon unendo'me enapa.’ ");
INSERT INTO car_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Irombo moro yjauranary a'mo'po mero y'wa, mo'ko Tamusi a'kary wopy'po itu'ponakaine, koromo 'ne na'na tu'ponaka tywopy'po wara enapa. ");
INSERT INTO car_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Irombo mo'ko Jopoto auranymbo poko ywetuwaro'ma'po rapa: ‘Johanes 'wa kari'na tatyka man tuna ke. Amyjaron te Tamusi a'kary ke tatyka maita'ton.’ ");
INSERT INTO car_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Mo'ko Jopoto Jesus Kristus amyika'po mero ky'waine, Tamusi 'wa mo'ko ta'kary tyje tywaije man ky'waine. Mo'ko ro rapa tyje Tamusi 'wa man i'waine. One wara ko iro ke awu Tamusi sa'kotory?” ");
INSERT INTO car_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Morokon eta'san mero, ituru'san wotandy'mo'san. Tamusi ety awonga'po i'waine. Ika'san: “Tamusi 'wa iro ke mo'karon Simosu me e'i'non 'wa enapa emamyrykon tu'mapo man, utapy'pa iwaito'ko'me.” ");
INSERT INTO car_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Moro Stefanus wo'po wyino opy'po ata'karykano 'wa ro mo'karon Kristus wyinonokon taripa'po tywaije kynatokon Jerusalem wyino. Iwara ro kynotaripa'satokon Fenisia 'wa, Siprus 'wa, Antioki 'wa enapa. Amy pairo 'wa te moro oka anekarity'pa kynatokon. Mo'karon Simosu 'wa roten te kynekari'satokon. ");
INSERT INTO car_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mo'karon etuwarikatonon ra'na amykon Siprus ponokon, Sirene ponokon wokyryjan enapa kynatokon. Mo'karon ro mo'karon Griek auran etanamon enapa erupatokon, moro Antioki 'wa tytunda'san mero. Mo'ko Jopoto Jesus ekapory ekari'satokon i'waine. ");
INSERT INTO car_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tamusi ainary kynakon imaroine. Pyime kari'na we'i'san Kristus wyinonokon me. Iwotu'ma'san mo'ko Jopoto 'wa. ");
INSERT INTO car_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ekarykon eta'po ro mo'karon Jerusalem po Tamusi na'nanopy'san 'wa. Irombo Barnabas emoky'po i'waine Antioki 'wa. ");
INSERT INTO car_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Tytunda'po mero, Barnabas 'wa moro Tamusi turu'popory ene'po. Ewa'pota'po. Ipori'toma'san i'wa tyturu'san maro mo'ko Jopoto ekosa iwaito'ko'me roten. ");
INSERT INTO car_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Iru'pyn wokyry mo'ko Barnabas kynakon. Tamusi a'kary kyni'namorojakon. Poto me Tamusi amyikakon. Amy poto 'su kari'na apyimy we'i'po mo'ko Jopoto wyinono me. ");
INSERT INTO car_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Irombo Barnabas wyto'po Tarsus 'wa Saulus upi. ");
INSERT INTO car_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Epory'po mero, Antioki 'wa aro'po i'wa. Moro po ro o'win siriko iwairy taro mo'karon Tamusi na'nanopy'san 'wa apo'i'san tokosaine. Pyime kari'na emepa'san i'waine. Moro Antioki po ro koromo mo'karon omepatonon ejato'san Kristus ety ta. ");
INSERT INTO car_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Moro jako ro Jerusalem wyino Tamusi auran uku'ponamon tunda'san Antioki 'wa. ");
INSERT INTO car_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Irombo o'win amy ira'nanokon Agabus tatynen awomy'po. Tamusi a'kary 'wa ty'namorory ta pa'poro kari'na emando'kon 'wa amy poto 'su kumyno wopyry man ekarity'po i'wa. Moro ro 'kuru tywo'se man Rome pono jopoto me Klaudius a'ta. ");
INSERT INTO car_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Judea ponokon Kristus wyinonokon epanopyry man yry'po mo'karon Antioki ponokon omepatonon 'wa. Typori'torykon taro ro pyrata aropory man yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iwara ro iwe'i'san. Barnabas maro Saulus apojoma'po i'waine moro tymy aroto'me mo'karon uwapoto'san 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Moro jako ro mo'ko jopoto Herodes wyto'po amykon Tamusi na'nanopy'san weto ikota'mato'ko'me. ");
INSERT INTO car_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Mo'ko Johanes piry Jakobus u'kapo'po i'wa supara ke. ");
INSERT INTO car_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Mo'karon Simosu apokupe moro we'i'po ene'po mero ty'wa, Petrus apyipo'po enapa i'wa, morokon uwaputa'non perere ewa'mary jako mo'karon Simosu 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Apyipo'po mero, aru'kapo'po i'wa yja'wangon kari'na aru'katopo taka. Ainapatoro itu'ponaka o'win-to'ima warinu pokonokon ypo'san i'wa erangon me. Okupa'en pai iwota'saka'san. Mo'ko eratonomapotopombo onory ewa'mary pa'po me Herodes mo'ko Petrus pa'kapory 'se kynakon emendopoto'me mo'karon kari'na embata. ");
INSERT INTO car_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Iwara ro moro yja'wangon kari'na aru'katopo ta Petrus a'ta, mo'karon Tamusi na'nanopy'san o'kapyn roten ipoko kynauranatokon Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Moro Herodes 'wa tamendopoto'man kurita uwaporo, Petrus kyno'ny'sakon koko. Opatoro tymy kynakon siparari ke oko warinu pokonokon poko. Pena po enapa erangon kynatokon. ");
INSERT INTO car_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Typo roten amy Tamusi apojon wopy'po. Moro iwo'ny'topo aweita'po imero. Irombo Petrus y'tu'ka'po mo'ko apojonano 'wa isoropary po, upakato'me. Ika'po: “Ko'i ajawongo!” Morokon imyto'konymbo woma'san morokon apory wyino. ");
INSERT INTO car_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Irombo mo'ko apojonano wyka'po i'wa: “Asapatory e'mo'ko.” Moro wara ro Petrus we'i'po. Irombo mo'ko apojonano wyka'po i'wa: “Ewo'myndoko. Irombo kywekenako.” ");
INSERT INTO car_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Irombo Petrus awomy'po kurandonaka iwekenato'me ty'wa. Iporo ro o'to mo'ko apojonano 'wa tyry anukuty'pa kynakon. Tanuja'kandary ekano'sakon. ");
INSERT INTO car_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Irombo moro koromono oranano waito'kon, moro ijokonory enapa ratonoma'san i'waine. Morombo mero moro kari'na emando'kon 'wano siparari pena 'wa itunda'san. Aseke ro moro pena wotapurumaka'po. Kurandonaka iwepa'ka'san. O'win amy oma y'ma'ka'po mero ty'waine, o'win wytory mo'ko Tamusi apojon wonekepy'po. ");
INSERT INTO car_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Irombo Petrus 'wa tywonumengary apo'i'po rapa. Ika'po: “Erome te suku'sa 'ne ro Tamusi 'wa tapojon emoky'po Herodes pori'tory wyino ykato'me, morokon Simosu nikapyry 'san otykon wyino enapa.” ");
INSERT INTO car_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Moro ukuty'po mero ty'wa, ito'po mo'ko Johanes, mo'ko Markus me enapa kynejatojaton inoro sano auty 'wa. Moro po ro pyime ata'nanopy'san kynauranatokon Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Moro o'mytopo pono pena moryka'po mero i'wa, amy Rode tatynen amyijanano wopy'po o'po'se. ");
INSERT INTO car_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrus auran ukuty'po mero ty'wa, ewa'pory we'i'po moro pena anetapurumaka'pa. Pena po mo'ko Petrus wairy ekari'se eka'numy'po mo'karon auto tanokon 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Mo'karon wyka'san ro i'wa: “Aje'mere'sa.” Ise'me te tauran ja'nakakon. Irombo ika'san: “Mo'ko kapu tano erandonen te mo'ko man.” ");
INSERT INTO car_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Petrus te pena morykary poko noro kynakon. Moro pena etapurumaka'po mero ty'waine, ene'po i'waine. Enuta'san imero. ");
INSERT INTO car_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ity'nato'ko'me tainary awonga'po mero ty'wa, moro one wara Tamusi 'wa moro yja'wangon kari'na aru'katopo wyino typa'kapo'po ekarity'po i'wa. Morombo wyino ika'po: “Erokon koro ekari'toko me Jakobus 'wa, mo'karon amykonymbo Kristus wyinonokon 'wa enapa.” Irombo ito'po amy terapa aitopo 'wa. ");
INSERT INTO car_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aweita'po mero, mo'karon warinu pokonokon we'naranga'san imero. O'to 'ne Petrus we'i'po anukuty'pa iwe'i'san. ");
INSERT INTO car_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Irombo Herodes 'wa Petrus aipo'po. Anepory'pa mo'karon ainamon we'i'san mero te, mo'karon erandonamonymbo ko'mapo'san i'wa. Oty wo'kapy'po poko i'waine tywoturupo'po wyino, iwopo'san i'wa. Irombo Herodes wo'pema'po Judea wyino Sesarea 'wa. Moro po ro iwe'i'po. ");
INSERT INTO car_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Moro jako te Herodes kynore'kojakon mo'karon Tyrus, Sidon ponokon poko. Mo'karon wopy'san ro asewara Herodes 'wa. Mo'ko Blastus, mo'ko Herodes auty tanokon otykon enenen me kynakon inoro 'wa iwopano'po'san, Herodes 'wa tywoturupoto'ko'me areku aike'kato'me. Moro Herodes yinonory wyino irombo moro tareparykon ene'potopo i'waine kynakon. ");
INSERT INTO car_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Amy erupato'kon man kurita Herodes 'wa poto 'su jopoto wo'my e'moky'po. Iwotandy'mo'po moro jopoto apo'ny tu'po. Irombo tauranary a'mo'po i'wa i'waine mo'karon ata'nanopy'san ra'na. ");
INSERT INTO car_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Irombo mo'karon ata'nanopy'san ko'tapoty'san i'wa: “Kari'na auran kapyn moro man! Tamusi auran te moro man!” ");
INSERT INTO car_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","O'win wytory imero any'ko'po amy Tamusi apojon 'wa, Tamusi ety awongary wara toty awongary ana'ko'to'pa iwe'i'po ke. Oruko 'wa tonory ta iromby'po. ");
INSERT INTO car_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Aseme noro poto me moro Tamusi auran kynaijakon. Iwotaripapy'po. ");
INSERT INTO car_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Mo'karon Jerusalem ponokon Kristus wyinonokon 'wa moro tynaro'san pyrata yry'po mero ty'waine, Barnabas, Saulus werama'san Antioki 'wa. Johanes, mo'ko Markus me enapa kynejatojatokon inoro aro'po i'waine tymaroine. ");
INSERT INTO car_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Moro Antioki pono Tamusi na'nanopy'san apyimy ta ro Tamusi auran uku'ponamon me, amepanamon me enapa kynatokon Barnabas, Simeon, mo'ko Niger me kynejatojaton inoro, mo'ko Sirene pono Lusius, mo'ko jopoto Herodes maro etuwaro'ma'po Manaen, Saulus enapa. ");
INSERT INTO car_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","O'wino me Tamusi na'nanopy'san me Tamusi ety awongatokon. Kynonematokon enapa. Moro jako ro mo'ko Tamusi a'kary wyka'po: “Barnabas Saulus maro ytoko typo moro i'wanokon me ynyry'po amaminano ka'to'me.” ");
INSERT INTO car_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Tywonema'san mero, Tamusi 'wa taurana'san mero, itu'ponakaine tainarykon yry'san mero enapa, moro tokosanokon amaminano poko Barnabas aike'ka'po, Saulus aike'ka'po enapa i'waine. ");
INSERT INTO car_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Mo'ko Tamusi a'kary 'wa tomoky'san mero, Barnabas maro Saulus wo'pema'po Seleusie 'wa. Moro wyino ro kurijara ta ito'san Siprus 'wa. ");
INSERT INTO car_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Moro aitopo Salamis 'wa tytunda'san mero, moro Tamusi auranymbo ekarity'po i'waine morokon Simosu wota'nano'to'kon autokon ta. Johanes enapa imaroine kynakon epano'namon me. ");
INSERT INTO car_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Pa'poro moro pa'wu tu'po tytopoty'san wyino, Pafos 'wa itunda'san. Moro po ro amy tamoreken Simosu epory'po i'waine. Tamusi auran uku'ponen waike kynakon. Barjesus ety me kynakon. ");
INSERT INTO car_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Mo'ko ro mo'ko pa'wu undymanen Sergius Paulus ekosa kynakon. Mo'ko Sergius Paulus amy tupu'ponen wokyry me kynakon. Mo'ko 'wa ro Barnabas, Saulus ko'mapo'san ty'wa. Moro Tamusi auranymbo etary 'se kynakon iwyinoine. ");
INSERT INTO car_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Aurangon po'takaro te kynakon mo'ko Elymas, mo'ko tamoreken. (Moro Elymas taurotopo ro tamoreke man.) Kristus wyinono me mo'ko pa'wu undymanen wairy a'kotory 'se kynakon. ");
INSERT INTO car_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Saulus, mo'ko Paulus me enapa kynejatojaton inoro y'namoro'po Tamusi a'kary 'wa. Onu'ka'pa Elymas ene'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","Irombo ika'po: “Tonapiren 'ne roten! Yja'wanymbo 'ne roten! Ewa'rumy tamuru a'sakary! Pa'poro tamambore aino jenono'nen! Morokon sapatoronokon Tamusi emary ko'wairory poko mana! ");
INSERT INTO car_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Erome te Tamusi opoky'matan. Ajenuke'take. Weju anene'pa maitake amy kurita 'wa ro.” Irombo o'win wytory imero enuru ewa'rumamy'po. Amy taronen man upi'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Moro ene'po mero mo'ko pa'wu undymanen we'i'po Kristus wyinono me. Mo'ko Jopoto poko omepano 'wa i'naranga'po. ");
INSERT INTO car_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Irombo kurijara ta Pafos wyino tyto'san mero, mo'karon ta'sakarykon maro Paulus tunda'po moro Panfili tano aitopo Perge 'wa. Johanes we'i'po te imaroine tytory 'se'pa noro. Iwerama'po rapa Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Mo'karon a'sakarykon wyto'san te Perge wyino moro Pisidie tano Antioki 'wa. Moro po ro moro otare'matopo kurita iwo'my'san moro Simosu wota'nano'to'kon auto taka. Iwotandy'mo'san. ");
INSERT INTO car_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Moro omenano mero'po, mo'karon Tamusi auran uku'ponamonymbo nimero'san kareta erupa'ma'san mero enapa, mo'karon Simosu wota'nano'to'kon auto jopotorykon 'wa ero taurangonymbo aropo'po mo'karon apojoma'san 'wa: “Yja'sakarykon, amy o'to awykarykon 'se aja'taine mo'karon ijaro 'wa opy'san pori'tomato'me, kaitoko.” ");
INSERT INTO car_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Irombo Paulus awomy'po. Tainary awonga'po i'wa ity'nato'ko'me. Irombo ika'po: “Israel pajanymbo, Tamusi nendonamon, epanamatoko. ");
INSERT INTO car_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Mo'karon Israel pajanymbo tamusiry 'wa mo'karon kytangonymbo tyje mandon tywyinonaka. Mo'karon typyitorykon ety enapa tawonga i'wa man, mo'karon Egypte ponokon ekosa emamyrykon jako. Moro Egypte wyino ro taro i'wa mandon typori'tory ta. ");
INSERT INTO car_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Irombo oko-kari'na siriko iwairy taro moro iponomyn wo'i ta moro emepo'pa iwairykon tapyije i'wa man. ");
INSERT INTO car_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Moro Kana'an yinonory tu'po oko-to'ima amykon aseke tamerykon aronamon kari'na apyimykon y'ma'ka'san wyino ty'wa, moro inonorykon aporenjan me mo'karon Israel pajanymbo tyje i'wa mandon. ");
INSERT INTO car_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","O'win-kari'namboto o'win-kari'na itu'ponaka oko-kari'na itu'ponaka ainapatoro siriko iwairy taro morokon otykon tywo'ka'se man. Moro pa'po me undymanamon me amykon tyje mandon mo'ko Tamusi auran uku'ponenymbo Samuel wairy 'wa ro. ");
INSERT INTO car_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Morombo wyino tywoturupo mandon amy poto 'su jopoto poko. Tamusi 'wa mo'ko Kis ymuru Saul tyje man ijopotorykon me. Mo'ko ro amy Benjamin pajanymbo a'sakary me tywaije man. Oko-kari'na siriko jopoto me tywaije man. ");
INSERT INTO car_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Mo'ko Saul ka'po wyino, i'petakan me mo'ko David tyje man ijopotorykon me. Mo'ko poko ro Tamusi 'wa ero tuku'po man: ‘Mo'ko Isai ymuru David seporyi amy yturu'po nisanory wokyry me. Pa'poro o'to ywykato'kon ka'tan.’ ");
INSERT INTO car_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Mo'ko parymbo ro amy tyje Tamusi 'wa man mo'karon Israel pajanymbo Epano'namon me moro tykatopombo wararo. Mo'ko Jesus, wykaje irombo. ");
INSERT INTO car_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Mo'ko wopyry uwaporo Johanes 'wa pa'poro mo'karon Israel pajanymbo tyko'ma mandon tamamyrykon u'mato'me i'waine, iwosetykapoto'ko'me enapa. ");
INSERT INTO car_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Moro tamamin aike'kary 'wa Johanes tyka man: ‘Mo'ko Mesias me anekanopyrykon kapyn awu wa. Ywena'po ta te kyno'tan mo'ko isapatory etandy ymbokato'me y'wa uwam'po watapoja inoro.’ ");
INSERT INTO car_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Yja'sakarykon, Abraham pajanymbo, mo'karon ara'naine Tamusi nendonamon enapa, ky'wanokon me ro ero kari'na ymbokanen auranano tyje man. ");
INSERT INTO car_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Mo'karon Jerusalem ta amandonon irombo mo'karon tyjopotorykon maro mo'ko Jesus ukutyry 'se'pa tywaije mandon. Turumena i'waine man. Iwara te mo'karon Tamusi auran uku'ponamonymbo nimero'san, morokon otare'matopo kurita wararo tyneruparykon tyka'po i'waine man. ");
INSERT INTO car_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Amy pairo iwopoto'man anepory'pa tywe'i'san se'me, Pilatus 'wa tywoturupo mandon iwopoto'me. ");
INSERT INTO car_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Pa'poro morokon ipoko imero'san ka'po'san mero ty'waine, tyka i'waine man moro ipokatopombo wakapu wyino. Irombo tunenje i'waine man. ");
INSERT INTO car_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Tamusi 'wa te iromby'san wyino tawongapo rapa man. ");
INSERT INTO car_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Pyime kurita tywosenepo man mo'karon Galilea wyino Jerusalem 'wa tymaro anuku'san 'wa. Inaron ro erome kari'na 'wa moro o'to iwe'i'po ekari'namon me mandon. ");
INSERT INTO car_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Iru'pyn oka ekari'san ro na'na o'waine. Moro kytangonymbo 'wa tykatopombo ro ");
INSERT INTO car_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","tyka'po Tamusi 'wa man mo'karon ipajanymbo 'wano me, ky'wanokon me, wykaje irombo. Jesus irombo tawongapo rapa i'wa man. Iwara enapa moro ijokonory ware ta tymero man: “Ymuru amoro mana. Erome ajumy me tywaije wa.” ");
INSERT INTO car_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Ikota'pa moro ija'mun waito'man me mo'karon iromby'san wyino Jesus tawongapo rapa man Tamusi 'wa. Moro poko ro tyka man Tamusi: ‘Moro yturu'po maro David 'wa ywykato'konymbo sika'take o'waine.’ ");
INSERT INTO car_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Amy terapa oje irombo tyka man: ‘Mo'ko tamyikaporen apyitory ja'mun anikotano'po'pa maitake.’ ");
INSERT INTO car_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Mo'karon tamamyry jakonokon ta'sakarykon 'wano me tamamina'po mero, mo'ko David tyromo'se man Tamusi nisanory me. Mo'karon itangon tu'mungon aporito tunenje man. Ija'mun tykota man. ");
INSERT INTO car_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mo'ko Tamusi nawongapo'po ja'mun te ikota'pa tywaije man. ");
INSERT INTO car_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Mo'ko nikapy'po poko ro morokon oja'wanykonymbo kary man uku'toko, yja'sakarykon. Moro ekarojan ro na'na. Pa'poro oja'wanykonymbo kary tupi man morokon Moses nimero'san omenano 'wa. ");
INSERT INTO car_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Pa'poro kari'na yja'wanykonymbo kanon moro i'wa mo'ko Tamusi nawongapo'po amyikary. ");
INSERT INTO car_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Tuwaro aitoko, mo'ko o'win amy Tamusi auran uku'ponenymbo wyka'po waito'me ajepory'paine. Ero wara irombo tymero i'wa man: ");
INSERT INTO car_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Senu'ka pangon! Ajenutatoko! Oneke'toko! Moro ajemamyrykon jakonokon kurita amy oty sika'sa. O'waine moro oty ekarity'pomboto amy kari'na 'wa, anamyika'pa pairo maitory.’ ” ");
INSERT INTO car_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kurandonaka itorykon jako, mo'karon aurangonymbo etanamonymbo woturupo'san i'waine mony otare'matopo kurita rapa auranato'ko'me morokon tynekarity'san poko. ");
INSERT INTO car_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Moro Simosu wota'nano'topo auto wyino tywepa'ka'san mero, Paulus, Barnabas wekena'san pyime Simosu 'wa, pyime Tamusi nendonamon Simosu me atypotonon 'wa enapa. Mo'karon apokuma'san ro i'waine mo'ja ro moro Tamusi turu'popory ta emando'ko'me. ");
INSERT INTO car_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Moro otare'matopo kurita wopyry ta pa'poro rypo mo'karon moro ponokon wota'nanopyry manombo tywaije man, mo'ko Jopoto ekary eta. ");
INSERT INTO car_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Mo'karon kari'na apyimykon ene'san mero ty'waine, mo'karon Simosu ato'ke iwe'i'po. Irombo onapi me moro Paulus nekarityry ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Enari'ma te Paulus, Barnabas wyka'san: “O'waine na'nen moro Tamusi auranymbo etary kynakon. Amyjaron te murumenaton. Moro i'matypyn amano apyinamon me atu'ku'pa matypojaton. Iro ke ro mo'karon Simosu me e'i'non 'wa kynotu'manon na'na. ");
INSERT INTO car_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ero wara irombo mo'ko Jopoto na'na 'wa tyka man: ‘Mo'karon Simosu me e'i'non 'wano aweinano me kyryi. Iwara ro uta'no wyino kari'na munendake nono y'matyry 'wa ro.’ ” ");
INSERT INTO car_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Moro eta'po mero, mo'karon Simosu me e'i'non ewa'pota'san. Mo'ko Jopoto ekary amyika'po i'waine. Pa'poro mo'karon i'matypyn amano 'wanokon me tyje tywaije kynatokon inaron we'i'san Kristus wyinonokon me. ");
INSERT INTO car_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Moro wyino ro mo'ko Jopoto ekary wotaripapy'po wararo. ");
INSERT INTO car_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mo'karon Simosu 'wa te mo'karon Tamusi nendonamon tywoneporamon woryijan, mo'karon aitopo ponokon potonon wokyryjan enapa erupo'toma'san. Mo'karon maro ro mo'karon aitopo ponokon apokuma'san i'waine, Paulus, Barnabas wetoine itoto'ko'me. Imoma'san ro i'waine moro tyinonorykon wyino. ");
INSERT INTO car_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Mo'karon apojoma'san 'wa te typupurukon y'koka'san, mo'karon aitopo ponokon e'mato'me ty'waine. Irombo ito'san Ikonium 'wa. ");
INSERT INTO car_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mo'karon Antioki ponokon omepatonon te moro awa'ponano 'wa, Tamusi a'kary 'wa enapa ty'namororykon ko'mangapo'satokon. ");
INSERT INTO car_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iwara enapa oty we'i'po Ikonium po. Iwo'my'san moro Simosu wota'nano'to'kon auto taka. Moro aurangon 'wa pyime Simosu, Griek enapa ypo'san Kristus wyinonokon me. ");
INSERT INTO car_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Mo'karon aurangon anamyika'non Simosu 'wa te mo'karon Simosu me e'i'non apokuma'san mo'karon Kristus wyinonokon urumenato'me i'waine. ");
INSERT INTO car_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","A'si 'ko akore'pe mo'karon apojoma'san we'i'san moro po. Mo'ko Jopoto amyikary ta enari'ma aurana'san. Mo'ko 'wa ro moro inekarityrykon takary amyikapo'po, anumengaponamon otykon, potonon pori'tonano enapa ka'pory ke ty'wa ainarykon 'wa. ");
INSERT INTO car_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Mo'karon moro po amandonon wotaripapy'san te. Amykonymbo we'i'san mo'karon Simosu wyinonokon me. Amykonymbo we'i'san mo'karon apojoma'san wyinonokon me. ");
INSERT INTO car_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Irombo mo'karon tyjopotorykon maro mo'karon Simosu, Simosu me e'i'non wemomy'san, iwetoine tytoto'ko'me, ikota'maine, topu ke enapa iwoine. ");
INSERT INTO car_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Moro ukuty'po mero ty'waine, mo'karon apojoma'san wetuwarika'san Likaoni 'wa. Moro po ro morokon aito'kon Lystra, Derbe po, morokon iwyinonokon aito'kon po enapa ");
INSERT INTO car_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","moro iru'pyn oka ekarityry aropoty'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lystra po ro amy wajaku pan wokyry tandy'po kynakon. Tywoma'po po ro wajaku pe kynakon. Tywe'i'po poro ito'pa kynakon. ");
INSERT INTO car_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Inoro ro Paulus 'wa kynepanamakon auranary jako. Irombo Paulus wo'poty'po i'wa onu'ka'pa. Tykura'mary amyikary taro iwairy ene'po mero ty'wa, ");
INSERT INTO car_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","pari'pe Paulus wyka'po iwa: “Ajawongo!” Ta'po'ne imero awomy'po. Irombo itopoty'po. ");
INSERT INTO car_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Moro Paulus nikapy'po oty ene'po mero ty'waine, mo'karon kari'na apyimykon ko'tapoty'san mo'karon Likaoni ponokon auran ta: “Mo'karon tamusikon tywony'to mandon ky'waine, kari'na me tywonurima.” ");
INSERT INTO car_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Barnabas ejato'po i'waine Seus me. Paulus ejato'po i'waine Hermes me, auranano ekari'nen me iwairy ke. ");
INSERT INTO car_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Irombo moro aitopo esi'wono Seus auty jopotory 'wa otykon epyryry ke eneka'to'san wokyryjan paka enepy'san pena 'wa. Mo'karon kari'na apyimykon maro mo'karon paka wory 'se kynakon mo'karon tamusi me tynekanopyrykon ewa'mato'me. ");
INSERT INTO car_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Moro eta'po mero te ty'waine, mo'karon apojoma'san Paulus, Barnabas 'wa tynoponykon seka'san. Iwota'poromy'san mo'karon kari'na apyimy taka. ");
INSERT INTO car_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","Iko'ta'san: “Yja'sakarykon, o'to ko maijaton? Awaraine enapa kari'na me roten na'na man. Iru'pyn oka ekari'se te na'na nopyi o'waine, moropangon arongangon otykon wyino awotu'mato'ko'me mo'ko nurono Tamusi 'wa. Inoro 'wa ro kapu, nono, parana, pa'poro itanokon maro ro tyka'se man. ");
INSERT INTO car_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Uwapo i'wa mo'karon Simosu me e'i'non 'wa inisanorykon ro tyka'po man. ");
INSERT INTO car_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ise'me mondo tywairy tanepo i'wa man. Kurangon otykon tyka'se i'wa man o'wanokon me. Kapu wyino konopo tane'po i'wa man. Tapepore wonatopo waitopo tyje i'wa man. Tarepando i'wa mandon. Aturu'san tawa'poro i'wa man.” ");
INSERT INTO car_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Moro aurangon we'i'po rypo moro tawa'mato'ko'me mo'karon kari'na apyimy 'wa mo'karon paka wory ana'koto'pa. ");
INSERT INTO car_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Irombo Antioki wyino, Ikonium wyino enapa Simosu wopy'san mo'karon kari'na apyimykon erupo'toma. Irombo Paulus tu'ponaka topu papy'san i'waine. Ikyryryka'po i'waine moro aitopo wyino kurandonaka. Tyromo'se kynekano'satokon. ");
INSERT INTO car_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mo'karon omepatonon 'wa tu'memy'po mero te, awomy'po rapa. Ito'po rapa moro aitopo taka. Irombo koro'po Barnabas maro ito'po Derbe 'wa. ");
INSERT INTO car_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe po ro moro iru'pyn oka ekarity'po i'waine. Omepatonon me pyime kari'na ypo'san mero ty'waine, iwerama'san rapa Lystra 'wa, Ikonium 'wa, Antioki 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Morokon aito'kon po ro mo'karon omepatonon pana'toma'san i'waine. Asinanopy'san i'waine Kristus wyinonokon me iwaito'ko'me mo'ja ro. Ika'san i'waine: “Moro Tamusi nundymary taka kytorykon jako, pyime awosin pangon otykon 'wa koporykon man.” ");
INSERT INTO car_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Wararo mo'karon Tamusi na'nanopy'san apyimy undymanamon me uwapoto'san andy'mo'san i'waine. Tywonemarykon ta Tamusi 'wa ipokoine aurana'san. Mo'ko inamyikarykon Jopoto ainaka yry'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Pisidie yinonory tu'po ro Panfili 'wa itunda'san. ");
INSERT INTO car_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Perge po moro oka ekarity'po mero ty'waine, Atalia 'wa iwo'pema'san. ");
INSERT INTO car_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Moro wyino ro kurijara ta ito'san Antioki 'wa. Moro po ro moro Tamusi turu'popory poko mo'karon Tamusi na'nanopy'san tywoturupo tywaije kynatokon moro erome inaike'ka'san amaminano ka'to'me. ");
INSERT INTO car_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Moro 'wa tytunda'san mero, mo'karon Tamusi na'nanopy'san ko'mapo'san i'waine. Irombo pa'poro morokon tymaroine Tamusi nikapy'san otykon ekaro'san i'waine. Tamusi 'wa pena etapurumaka'po ekarity'po i'waine mo'karon Simosu me e'i'non waito'me Kristus wyinonokon me. ");
INSERT INTO car_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Irombo a'si 'ko akore'pe iwe'i'san mo'karon moro ponokon omepatonon ekosa. ");
INSERT INTO car_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Irombo amykon Judea wyino o'pema'san 'wa mo'karon Antioki ponokon Kristus wyinonokon emepary a'mo'po. Ika'san: “Moro Moses nimero'po omenano o'kotopojaton. Moro wara ei'pa aja'taine, uta'no wyino ajunemyrykon tupi me kynaitan.” ");
INSERT INTO car_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Paulus, Barnabas ato'keine moro aurangon kynakon. Apo'tun pe imaroine taurangon ejuku'po i'waine. Irombo Paulus, Barnabas, amykon ta'sakarykon enapa emoky'san i'waine Jerusalem 'wa mo'karon apojoma'san, uwapoto'san po'ponaka moro atamiromo'katopo oty poko orupa. ");
INSERT INTO car_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Mo'karon Tamusi na'nanopy'san nemoky'san wyto'san moro Fenisia, Samaria yinonory tu'po. Moro tytorykon jako ro mo'karon Simosu me e'i'non 'wa tamamyrykon u'ma'po ekarity'po i'waine. Iwara pa'poro mo'karon Kristus wyinonokon ewa'poro'san imero i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jerusalem 'wa itunda'san mero, iwopy'san ewa'ma'po mo'karon moro ponokon Tamusi na'nanopy'san 'wa, mo'karon apojoma'san 'wa, mo'karon uwapoto'san 'wa enapa. Irombo pa'poro morokon tymaroine Tamusi nikapy'san otykon ekaro'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Irombo te amykon Kristus wyinonokon me e'i'san Farise moro po kynatokon. Inaron awomy'san ro ero tykato'ko'me: “I'kotorykon man. Moro Moses nimero'po omenano yry man inapyirykon man me.” ");
INSERT INTO car_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Irombo mo'karon apojoma'san wota'nanopy'san mo'karon uwapoto'san maro moro oty poko orupa. ");
INSERT INTO car_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Akore'pe ipoko tyworupa'san wyino, mo'ko Petrus awomy'po. Ika'po i'waine: “Yja'sakarykon, Tamusi 'wa ara'naine yjapo'i'po muku'saton mo'karon Simosu me e'i'non 'wa moro iru'pyn oka ekari'nen me, etato'me, amyikato'me i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Irombo mo'ko turu'ponano uku'nen Tamusi 'wa mo'karon ynerupa'san Simosu me e'i'non tuku'po mandon Kristus wyinonokon me. Ta'kary waty tyje i'wa nan i'waine, ky'waine yry'po wara enapa. ");
INSERT INTO car_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Amy me terapa pairo anekarity'paine tywaije man. Moro i'waine Kristus amyikary ke ituru'san tykoroka i'wa man. ");
INSERT INTO car_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","O'tono'me ko iro ke Tamusi mu'kujaton awosin pangon otykon ka'pory ke o'waine mo'karon omepatonon 'wa. Mo'karon kytangonymbo 'wa, ky'waine enapa moro oty kapyry tupi tywaije man. ");
INSERT INTO car_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mo'ko Jopoto Jesus turu'popory 'wa te uta'no wyino kunemy'san kysamyikaton. Iwara enapa te mo'karon Simosu me e'i'non omepatonon tunenje mandon.” ");
INSERT INTO car_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Pa'poro mo'karon kari'na apyimy we'i'po ity'me, Barnabas 'wa, Paulus 'wa enapa tywepanamato'ko'me. One wara mo'karon Simosu me e'i'non ra'na Tamusi 'wa ty'waine anumengaponamon otykon, potonon pori'tonano ka'po'san ekarity'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Aurana'ma'san mero, Jakobus 'wa tauranary a'mo'po. Ika'po: “Yja'sakarykon, epanamatoko y'wa! ");
INSERT INTO car_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","One wara Tamusi 'wa penaro terapa mo'karon Simosu me e'i'non etawa'san ekarityi mo'ko Simeon. Toty awonganamon me amy apyimykon apyiry 'se Tamusi tywaije man. ");
INSERT INTO car_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iwara enapa mo'karon Tamusi auran uku'ponamonymbo tyka tywaije mandon. Tymero irombo man: ");
INSERT INTO car_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Morombo mero weramatake rapa. Moro David patajarymbo samytake rapa. Iru'pa rapa sytake. ");
INSERT INTO car_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","18","Iwara ro Tamusi upita'ton mo'karon amykon terapa kari'na, pa'poro mo'karon ywyinonokon me yniko'ma'san Simosu me e'i'non enapa. Iwara kynganon Tamusi, mo'ko morokon penaro terapa uku'po'san otykon ka'san inoro.’ ");
INSERT INTO car_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Iro ke ro awu ero wara wonumengaje: mo'karon Tamusi 'wa atu'matonon Simosu me e'i'non anaki'ma'pa kywairykon man. ");
INSERT INTO car_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Erokon ekarityry te ky'waine man i'waine: Morokon tanymanamon otykon uremenary i'waine man: Ikapy'san tamusi 'wa yry'san tonomy onory kapyn i'waine man, wararo roten wokyry, woryi poko iwairykon kapyn man, ena'sawyry'kary ke iwo'po tonomy onory kapyn i'waine man, mynu enapyry kapyn enapa i'waine man. ");
INSERT INTO car_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Morokon penaro terapa Moses nimero'san omenano erupaton ro 'kuru wararo aito'kon po morokon Simosu wota'nano'to'kon auto ta, moro otare'matopo kurita wararo.” ");
INSERT INTO car_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Irombo mero mo'karon apojoma'san, uwapoto'san 'wa pa'poro mo'karon Tamusi na'nanopy'san maro amykon tyra'nanokon wokyryjan ekarity'san, emo'to'ko'me Antioki 'wa Paulus, Barnabas maroine. Mo'karon inekarity'san ro kynatokon mo'ko Barsabas me inejatorykon Judas mo'ko Silas maro. Okororo etykon poto me kynakon mo'karon Kristus wyinonokon ra'na. ");
INSERT INTO car_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","I'waine ro ero kareta aropo'po i'waine: Mo'karon Kristus wyinonokon apojoma'san, uwapoto'san ero kareta aropojaton mo'karon Antioki ponokon, Sirie ponokon, Silisia ponokon Simosu me e'i'non Kristus wyinonokon 'wa. Iru'pa ro rypo mandon? ");
INSERT INTO car_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amykon ajetawanamon na'na a'sakarykon 'wa asykapo'san ekary etai na'na. Amykon aurangon 'wa moro awonumengarykon jamika'po ekary etai na'na. Na'na napojomarykon me kapyn te moro wara tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Iro ke ro tauran epopoi na'na amykon wokyryjan ekari'to'me, emo'to'ko'me o'waine na'na nipynarykon Barnabas, Paulus maroine. ");
INSERT INTO car_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Barnabas, Paulus 'waine ro 'kuru moro tamamyrykon ko'po poto me mo'ko Kyjopotorykon Jesus Kristus ety tyje man. ");
INSERT INTO car_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Iwara te 'kuru Judas, Silas emo'ton na'na o'waine. Aseke ro ero na'na nimero'po ekari'ta'ton enapa o'waine. ");
INSERT INTO car_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tamusi a'kary 'wa, na'na 'wa enapa irombo iru'pa topoje man iko'po 'ne 'ne ajaki'ma'paine na'na wairy man. Ero wara roten te awairykon man: ");
INSERT INTO car_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ikapy'san tamusi 'wa yry'san tonomy onory kapyn o'waine man, mynu enapyry kapyn o'waine man, ena'sawyry'kary ke iwo'po tonomy onory kapyn o'waine man, wararo roten wokyry, woryi poko awairykon kapyn man. Irokon poko tuwaro aja'taine, iru'pa man. Iru'pa aitoko! ");
INSERT INTO car_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Irombo mo'karon inapojomarykon wo'pema'san Antioki 'wa. Moro po ro mo'karon Kristus wyinonokon a'nano'po'san mero ty'waine, moro kareta yry'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Erupa'ma'po mero ty'waine, ewa'pota'san moro typana'tomato'kon auranano poko. ");
INSERT INTO car_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas, Silas 'wa enapa ipana'toma'san. Tamusi auran uku'ponamon me irombo kynatokon. Pyime auranano ke mo'karon Kristus wyinonokon pori'toma'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A'si'ko akore'pe moro po tywe'i'san wyino, iwerama'san rapa Jerusalem 'wa. Imaroine ro mo'karon Antioki ponokon Kristus wyinonokon 'wa “Iru'pa aitoko!” tyka'san aropo'po mo'karon apojomanamonymbo 'wa. ");
INSERT INTO car_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Paulus wainopo'po Barnabas maro Antioki po. Moro po ro pyime ta'sakarykon maro ro mo'karon Kristus wyinonokon emepatokon. Mo'ko Jopoto ekapory ekari'satokon enapa. ");
INSERT INTO car_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Amykon kurita pa'po me te Paulus wyka'po Barnabas 'wa: “Kyteraman rapa, one wara mo'karon Kristus wyinonokon wairy ene pa'poro morokon ky'wa mo'ko Jopoto ekapory ekari'to'konymbo 'wa.” ");
INSERT INTO car_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Irombo Barnabas mo'ko Markus me inejatorykon Johanes arory 'se enapa kynakon tymaroine. ");
INSERT INTO car_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paulus te arory 'se'pa kynakon, Panfili po tyno'san ke i'wa, ito'pa enapa iwe'i'po ke tapatomaine moro amaminano poko. ");
INSERT INTO car_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Moro poko ro mene asepoko iwe'i'san. Irombo iwotaripapy'san. Barnabas 'wa Markus aro'po tymaro kurijara ta Siprus 'wa. ");
INSERT INTO car_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paulus 'wa te Silas apo'i'po tapaton me. Iwaimokyry uwaporo, i'wano me moro Tamusi turu'popory poko mo'karon Kristus wyinonokon woturupo'san. ");
INSERT INTO car_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Irombo mo'karon Tamusi na'nanopy'san apyimykon pori'tomary aropoty'po i'wa Sirie po, Silisia po enapa. ");
INSERT INTO car_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Irombo Paulus tunda'po Derbe 'wa, Lystra 'wa enapa. Moro po ro amy Timoteus tatynen omepatoto kynakon. Amy Kristus wyinono Simosu woryiry isano me kynakon. Mo'ko ijumy te amy Griek mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Mo'ko Timoteus ro takapore kynakon mo'karon Lystra ponokon, Ikonium ponokon Kristus wyinonokon ekosa. ");
INSERT INTO car_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Inoro wytory 'se ro Paulus we'i'po tymaro. Moro waton me ro mo'karon moro wyinonokon Simosu upu'san me i'kotopo'po i'wa. Griek me irombo pa'poro kari'na ijumy uku'satokon. ");
INSERT INTO car_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Morokon aito'kon wararo tytopotyrykon jako, mo'karon Jerusalem ponokon apojoma'san, uwapoto'san aurangonymbo ekaro'san i'waine mo'karon Kristus wyinonokon napyiry man me. ");
INSERT INTO car_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Iwara ro mo'karon Tamusi na'nanopy'san kynepori'tomatokon Kristus wyinonokon me. Kurita wararo pyime 'ne ka'tu rapa kynaijatokon. ");
INSERT INTO car_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Irombo ito'san Frigie yinonory tu'po, moro Galatie yinonory tu'po enapa. Mo'ko Tamusi a'kary 'wa te a'koto'san Asia po moro oka ekarory pona i'waine. ");
INSERT INTO car_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Misie 'wa tytunda'san mero, Bitinia 'wa tytorykon poko iwe'ku'san. Mo'ko Jesus a'kary we'i'po te anaropo'paine. ");
INSERT INTO car_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Irombo Misie ratonoma'po mero, Troas 'wa itunda'san. ");
INSERT INTO car_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Koko Paulus 'wa tywoneto amy Masedonie pono wokyry ene'po. Inoro 'wa ro iko'ma'po. Ika'po: “Masedonie 'wa epatoko na'na epano'se.” ");
INSERT INTO car_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Moro wara iwonety'po ke, o'win wytory na'na wo'mika'po Masedonie 'wa tytory poko. Tamusi 'wa tyko'ma'po ukuty'po na'na 'wa moro iru'pyn oka ekari'to'me mo'karon moro ponokon 'wa. ");
INSERT INTO car_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Troas wyino kurijara ta tywaimoky'po mero, sapatoro na'na wyto'po Samotrake 'wa. Irombo koro'po Neapolis 'wa na'na wyto'po. ");
INSERT INTO car_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Moro wyino na'na wyto'po Filipi 'wa. Amy Rome ponokon emandopo moro kynakon. Moro koromono Masedonie wota'saka'po tano aitopo moro kynakon. Moro po ro amykon kurita na'na we'i'po. ");
INSERT INTO car_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Moro otare'matopo kurita na'na wepa'ka'po moro aitopo wyino, tuna wyinonaka. Moro po ro amy Tamusi 'wa auranatopo uku'sakon na'na. Tywotandy'mo'po mero, na'na 'wa mo'karon woryijan wota'nanopy'san erupa'san. ");
INSERT INTO car_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Amy Lydia tatynen woryi moro po kynakon. Amy tykujuramon kamisa ekaramanen Tyatira pono mo'ko kynakon. Tamusi nendonen mo'ko kynakon. Moro iwepanamary jako ro, mo'ko Jopoto 'wa moro Paulus auran aropo'po ituru'po taka. ");
INSERT INTO car_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Irombo mo'karon tauty tanokon maro tywosetykapo'po mero, tauty 'wa na'na ejukuru poko iwo'mika'po. Ika'po: “Y'wa mo'ko Jopoto amyikary ukutyry jako o'waine, o'toko ymaro yjauty 'wa. Yjekosa aitoko.” Tywo'wyry'ka me na'na aro'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Amy kurita moro Tamusi 'wa auranatopo 'wa na'na wytory jako, na'na epory'po amy takyren amyijanano 'wa. Airenokon otykon uku'ponen me pyime pyrata ka'sakon mo'karon taporenjan ekataka. ");
INSERT INTO car_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Mo'ko 'wa ro Paulus wekenary, na'na wekenary a'mo'po. Iko'ta'po: “Mojan wokyryjan mo'ko inorombo ro kawono Tamusi pyitorykon mojan mandon. One wara uta'no wyino kari'na unemyry man ekari'saton o'waine.” ");
INSERT INTO car_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Pyime kurita moro wara iwe'i'po. Paulus ato'ke te moro wara iwairy we'i'po. Iwotu'mapo. Irombo ika'po mo'ko akyry 'wa: “Jesus Kristus ety ta wykaje o'wa mo'ko woryi wyino awepa'kato'me.” Irombo o'win wytory iwepa'ka'po iwyino. ");
INSERT INTO car_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Pyrata anikapy'pa noro mo'ko tamyijarykon wairy man ene'po mero ty'waine, mo'karon woryi aporenjan 'wa Paulus maro Silas apo'i'san. Ikyryryka'san i'waine moro otykon ekaramatopo 'wa, mo'karon jopoto po'ponaka. ");
INSERT INTO car_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ipo'ponakaine aro'san mero ty'waine, ika'san: “Mojan Simosu ero kywaito'kon jamikapojaton. ");
INSERT INTO car_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Morokon inekarorykon omenano apyiry kapyn ky'waine man. Mo'ko Rome jopotory upi'nonokon 'wa waty morokon man.” ");
INSERT INTO car_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Mo'karon woryi aporenjan maro mo'karon kari'na apyimy wopy'po enapa Paulus, Silas wetoine. Irombo mo'karon jopoto 'wa iwo'mykonymbo sekapo'po'san. Irombo wewe ke ipoky'mapo'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Mene ipoky'mapo'san mero ty'waine, moro yja'wangon kari'na aru'katopo taka aru'kapo'san i'waine. Mo'ko yja'wangon kari'na aru'katopo eran apojoma'po i'waine iru'pyn me imero erandoto'ko'me i'wa. ");
INSERT INTO car_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Moro wara tapojoma'po ke ro, koro'na imero etapuru'san i'wa. Morokon ipupurukon uru'ka'san i'wa amy wewe kapy'po taka. ");
INSERT INTO car_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Irawone 'ne iwairy taro a'ta, Tamusi 'wa kynauranatokon. Tamusi ety awongatokon enapa tywarerykon ta. Mo'karon aru'ka'san kynepanamatokon i'waine. ");
INSERT INTO car_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Irombo typo roten nono wetytyka'po imero. Moro yja'wangon kari'na aru'katopo apo'ny wesakamapoty'po. O'win wytory pa'poro morokon pena wotapurumaka'san. Pa'poro mo'karon aru'ka'san myto'konymbo wo'ka'san. ");
INSERT INTO car_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tupaka'po mero, mo'ko erangon 'wa morokon yja'wangon kari'na aru'katopo penarykon ene'po tywotapurumakapo'se. Mo'karon aru'ka'san wetuwarika'san ekanopyry ke ty'wa, moro tysuparary so'ka'po i'wa ije'ny wyino, tywo'woto'me rypo. ");
INSERT INTO car_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Pari'pe te Paulus wyka'po i'wa: “Kyto'woi te koro! Pa'poro na'na ero po man!” ");
INSERT INTO car_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Irombo taweiry me wa'to ene'po'po mo'ko erangon 'wa. Morombo mero iwota'poromy'po moro aru'kato'kon taka. Tytyty'ne iwoma'po Paulus, Silas pupurukon po. ");
INSERT INTO car_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kurandonaka aro'san mero ty'wa, ika'po i'waine: “Jopotokon, o'to ko waitan uta'no wyino yjunendo'me?” ");
INSERT INTO car_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Irombo ika'san: “Mo'ko Jopoto Jesus amyikako! Moro wara awe'i'poto uta'no wyino matunendake, ajauty tanokon maro ro.” ");
INSERT INTO car_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Irombo mo'ko Jopoto ekary ekarity'po i'waine i'wa, pa'poro mo'karon auty tanokon 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Irombo aro'san i'wa tymaro, koko noro a'ta. Morokon iwo'san ku'mity'san i'wa. O'win wytory iwosetykapo'po, pa'poro mo'karon tauty tanokon maro. ");
INSERT INTO car_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tauty taka awo'nuku'san mero ty'wa, arepa ke upa'san i'wa. Moro ty'wa Tamusi amyika'po ewa'ma'po i'wa pa'poro mo'karon tauty tanokon maro. ");
INSERT INTO car_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Emamy'po mero mo'karon jopoto 'wa typyitorykon emoky'san mo'ko yja'wangon kari'na aru'katopo eran 'wa, “Mo'karon kari'na inondatoko,” tauro me. ");
INSERT INTO car_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Irombo mo'ko yja'wangon kari'na aru'katopo eran 'wa aurangonymbo ekarity'po Paulus 'wa. Ika'po: “Mo'karon jopoto 'wa moro anondapoto'kon auranano tane'po man. Epa'katoko iro ke. Iru'pa i'tandoko.” ");
INSERT INTO car_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paulus wyka'po te i'waine: “Mo'ko Rome jopotory upi'nonokon me na'na wairy se'me, pa'poro kari'na nenery me na'na wosaijomary pyndo na'na ypoky'ma'san mero moro yja'wangon kari'na aru'katopo taka na'na aru'katon. Erome te 'kare rapa ekapyn ta na'na pa'kapojaton. Uwa pairo! Oro te aseke no'sen na'na pa'kapo.” ");
INSERT INTO car_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Moro Paulus auranymbo ekarity'po ro mo'karon pyitonano 'wa mo'karon jopotokon 'wa. Mo'ko Rome jopotory upi'nonokon me iwairykon eta'po mero ty'waine mo'karon jopotokon wety'ka'san. ");
INSERT INTO car_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Irombo iwopy'san i'waine. Pyi'me'ke iwoturupo'san i'waine iwepa'kato'ko'me. Iwepa'ka'san mero, iwe'pima'san moro tywaito'kon wyino itoto'ko'me. ");
INSERT INTO car_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Moro yja'wangon kari'na aru'katopo wyino tywepa'ka'san mero, Lydia auty 'wa ito'san. Moro po ro mo'karon Kristus wyinonokon ene'san i'waine. Ipana'toma'san i'waine. Irombo iwaimoky'san. ");
INSERT INTO car_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Irombo Amfipolis, Apolonia pato tyto'san mero, itunda'san Tesalonika 'wa. Moro po ro amy Simosu wota'nano'to'kon auto kynakon. ");
INSERT INTO car_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Tamerymbo mero Paulus wyto'po mo'karon ta'sakarykon ene. Oruwa otare'mato'kon kurita mo'karon ta'sakarykon erupa'san i'wa. Moro Tamusi karetary yry'po i'wa moro tynekarityry pori'tomanen me. ");
INSERT INTO car_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Moro kareta wykary wara ro mo'ko Mesias wota'karykary man we'i'po, moro iromby'san wyino awomyry man we'ipo enapa enepo'po i'wa. Ika'po i'waine: “Mo'ko Mesias me ro Jesus sekari'sa o'waine.” ");
INSERT INTO car_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Amykon 'wa Paulus amyika'po. Paulus, Silas wyinonokon me iwe'i'san, pyime Tamusi nendonamon Griek maro, a'si'ko pyime kawo aitonon woryijan maro enapa. ");
INSERT INTO car_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mo'karon Simosu ato'ke te iwe'i'po. Amykon yja'wangonymbo kari'na ko'mapo'san i'waine. Imaroine ro mo'karon aitopo ponokon tururukapo'san i'waine mo'ko Jason auty 'wa. Paulus, Silas arory 'se kynatokon mo'karon kari'na wota'nano'to'kon 'wa, emendoto'ko'me ty'waine. ");
INSERT INTO car_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Anepory'pa tywe'i'san mero te, amykon Kristus wyinonokon maro Jason kyryryka'po i'waine mo'karon jopoto po'ponaka. Iko'tapoty'san: “Mo'karon pa'poro ero nono tu'ponokon kari'na apokumanamon ijaro 'wa enapa tywo'se mandon. ");
INSERT INTO car_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason tokosa kynenapojaton. Pa'poro mo'kopangon mo'ko Rome pono jopoto nyry'san omenano po'takaro mandon. Poto 'su jopoto me amy terapa ekari'saton: amy Jesus tatynen.” ");
INSERT INTO car_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Moro auranano 'wa ro mo'karon kari'na apyimy, mo'karon jopoto y'narangapo'san poto me. ");
INSERT INTO car_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Jason 'wa ta'sakarykon maro moro tynondato'ko'man pyrata epema'san mero, mo'karon jopoto 'wa inondapo'san. ");
INSERT INTO car_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Iko'mamy'po mero ko'i terapa mo'karon Kristus wyinonokon 'wa Paulus, Silas aropo'san Berea 'wa. Moro 'wa tytunda'san mero, moro Simosu wota'nano'to'kon auto taka ito'san. ");
INSERT INTO car_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Mo'karon ro tamepore kynatokon mo'karon Tesalonika ponokon ko'po. Tyturu'san maro mo'ko Jopoto ekary ewa'ma'po i'waine. Kurita wararo moro Tamusi karetary menga'po i'waine, iporo morokon Paulus nekarity'san wairy eneto'me. ");
INSERT INTO car_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Pyime amykon ira'nanokon we'i'san Kristus wyinonokon me, a'si'ko pyime amykon kawonokon Griek woryijatonon, ikyryjatonon maro enapa. ");
INSERT INTO car_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Moro Paulus 'wa Berea po enapa mo'ko Tamusi auranymbo ekarityry ukuty'po mero te ty'waine, mo'karon Tesalonika ponokon Simosu wyto'san enapa moro 'wa mo'karon kari'na apyimykon erupo'toma, amiromo'kaine enapa. ");
INSERT INTO car_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","O'win wytory mo'karon Kristus wyinonokon 'wa Paulus aropo'po parana esi'wonaka. Silas, Timoteus wainopo'san te moro po. ");
INSERT INTO car_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Mo'karon aronamon 'wa Athene 'wa Paulus aro'po. Iwerama'san rapa, amy Silas, Timoteus 'wanokon kareta maro. Moro ta ro tymero Paulus 'wa kynakon ko'i terapa iwo'to'ko'me ty'wa. ");
INSERT INTO car_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Athene po imomokyrykon jako ro Paulus ere'kojakon moro pyime moro po u'ku'san tamusi wairy enery. ");
INSERT INTO car_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Moro iwota'nano'to'kon auto ta mo'karon Simosu, mo'karon Tamusi nendonamon enapa erupary a'mo'po i'wa. Moro otykon ekaramatopo po enapa kurita wararo mo'karon kari'na erupary a'mo'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Amykon Epikurus wyinonokon oty uku'namon maro, amykon Stoa tanokonymbo oty uku'namon maro enapa Paulus aurana'po. Amykonymbo wyka'san: “O'to 'ne ko tykary 'se mo'ko tauran pyryrykanen nan?” Amykonymbo wyka'san rapa: “Ukuty'non tamusi ekari'nen me kynonepojan.” Paulus 'wa irombo mo'ko Jesus ekapory, moro iromby'san wyino awono enapa takari'se kynakon. ");
INSERT INTO car_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Irombo tymaroine aro'po i'waine moro Areopagus po omenano enetopo 'wa. Ika'san i'wa: “Oty me moro anekarityry asery omepano wairy ekarityry 'se'pa man na'na 'wa? ");
INSERT INTO car_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Amykon aserynon otykon metapojan na'na 'wa. O'to tauro'po me iwairykon ukutyry 'se na'na man.” ");
INSERT INTO car_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Pa'poro Athene ponokon apokupe, mo'karon ira'naine amandonon typonokon apokupe enapa man amy asery oty ekarityry, etary enapa. ");
INSERT INTO car_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Irombo Paulus wyto'po moro Areopagus po omenano enetopo owarira'naka. Ika'po: “Athene ponokon, pa'poro oty poko moro o'waine tamusikon nendory seneja. ");
INSERT INTO car_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Awaito'kon po yweramapotyry jako irombo, morokon o'waine tamusikon nendoto'kon aito'kon 'wa ywo'potyry jako, amy tymy apo'ny enapa seporyi. Moro poko ro tymero man: UKUTYPYN TAMUSI 'WA “Moro aninendorykon anukuty'torykon ro sekari'sa o'waine. ");
INSERT INTO car_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Mo'ko pa'poro itu'pono maro ero nono ka'nenymbo Tamusi kapu, nono Jopotory me man. Amy ty'wano me kari'na namy'san auto ta emamy'pa man. ");
INSERT INTO car_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Kari'na 'wa opatomapo'pa man. Amono'ke waty irombo amy oty man. Aseke te pa'poro no'kan 'wa amano yjan, oremano yjan, pa'poro oty yjan. ");
INSERT INTO car_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","O'win kari'na tapyimangapo i'wa man. Pa'poro ero nono tu'po tamangapo i'wa mandon. Pa'poro i'wanokon me one wara a'ta, oje enapa emamyrykon man tyje tywaije i'wa man. ");
INSERT INTO car_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Topory 'se Tamusi tywaije man, tupiry poko iwe'kurukon jako 'ne. Tyse waty irombo Tamusi man pa'poro kywyinoine. ");
INSERT INTO car_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Mo'ko ta ro kamanjaton, kytesakamaton, kytaton. Iwara enapa amykon awyinonokon waretatonon tywareta mandon: ‘I'makon me irombo kytaton.’ ");
INSERT INTO car_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Tamusi y'makon me kywairykon ke ro, Tamusi ekanopyry kapyn ky'waine man amykon tainaporamon kari'na nikapy'san ika'mi'po, amu'nymbo, topu ja'ta pai. ");
INSERT INTO car_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tamusi o'poty'pa noro man moro uwapo oty anukuty'pa kari'na we'isan poko. Erome te wararo pa'poro kari'na 'wa tamamyrykon u'mary man ekaropojan. ");
INSERT INTO car_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Amy pa'poro kari'na poko a'wembono auranano yto'man kurita irombo tyje i'wa man. Moro a'wembono auranano ypotan amy tynapo'i'po wokyry 'wa. Mo'ko ro iromby'san wyino tawongapo rapa i'wa man, mo'ko tynapo'i'po wokyry me iwairy enepoto'me.” ");
INSERT INTO car_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Mo'karon iromby'san awomyry poko auranary eta'po mero ty'waine, amykonymbo 'wa auno'poty'po. Amykonymbo wyka'san te: “Amy jako rapa moro poko auranary etatan na'na.” ");
INSERT INTO car_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Moro wara te Paulus wyto'po iwyinoine. ");
INSERT INTO car_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amykon wokyryjan wyto'san te imaro. Irombo Kristus wyinonokon me iwe'i'san. Ira'naine enapa kynatokon mo'ko Areopagus po omenano enenen Dionysius, amy Damaris tatynen woryi, amykon noro. ");
INSERT INTO car_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Morombo mero Paulus wyto'po Athene wyino Korinte 'wa. ");
INSERT INTO car_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Moro po ro amy Akila tatynen Simosu epory'po i'wa. Pontus po oma'po mo'ko kynakon. Penaro 'ne waty Itali wyino tywo'se kynakon mo'ko typyty Prisila maro. Mo'ko Rome pono jopoto Klaudius irombo tyka tywaije kynakon pa'poro Simosu wytoto'me Rome wyino. Mo'karon 'wa ro Paulus wyto'po. ");
INSERT INTO car_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Asewara tamamingon wairy ke, Paulus we'i'po ekosaine. Tonomy pi'pombo emaminano'namon me irombo kynatokon. ");
INSERT INTO car_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Irombo otare'matopo kurita wararo moro Simosu wota'nano'to'kon auto ta Paulus kari'na erupakon. Moro oka amyikapory poko kyne'kujakon i'waine, Simosu 'wa, Griek 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Masedonie wyino Silas tunda'po mero Timoteus maro, Paulus we'i'po roten moro iru'pyn oka ekarityry poko. Mo'ko Mesias me Jesus wairy ekari'sakon mo'karon Simosu 'wa. ");
INSERT INTO car_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Tauran etary 'se'pa iwairykon ke, yja'wan me tauranarykon a'mo'po mero i'waine, tywo'my purumburunga'po i'wa oma e'kyinymbo wo'kato'me iwyino. Ika'po i'waine: “Yjaikepyi apokoine. Aseke atuku'toko. Arombyrykon jako yju'ta e'i'pa maitaton. Simosu me e'i'non 'wa terapa wy'take.” ");
INSERT INTO car_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Irombo moro wyino ito'po. Iwo'my'po amy Tamusi nendonen Titius Justus tatynen auty taka. Moro auty ro moro Simosu wota'nano'to'kon auto aporito kynakon. ");
INSERT INTO car_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Mo'ko Simosu wota'nano'to'kon auto jopotory Krispus we'i'po mo'ko Jopoto wyinono me pa'poro tauty tanokon maro. Pyime Paulus auran etanamonymbo Korinte ponokon we'i'san enapa Kristus wyinonokon me. Iwosetykapo'san. ");
INSERT INTO car_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Irombo koko mo'ko Jopoto wyka'po Paulus 'wa iwoneto: “Tanarike kyte'i. Ajauranako. Ity'me kyte'i. ");
INSERT INTO car_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Awu ro amaro wa. Amy pairo yja'wan me o'to ajyry upitan. Pyime irombo y'wanokon mandon ero aitopo po.” ");
INSERT INTO car_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Irombo o'win siriko itu'ponaka o'win-to'ima nuno moro po Paulus we'ipo moro Tamusi auran poko kari'na emeparykon poko. ");
INSERT INTO car_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Moro Akaje undymanen me Galio we'i'po mero, asewara imero mo'karon Simosu wyto'san Paulus weto. Galio po'ponaka aro'po i'waine emendoto'me ty'waine. ");
INSERT INTO car_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ika'san: “Mo'se wokyry kyno'mikanon moro omenano mero'po ratoro Tamusi nendopory poko mo'karon kari'na 'wa.” ");
INSERT INTO car_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Irombo tauranary 'se Paulus a'ta 'ne, Galio wyka'po mo'karon Simosu 'wa: “Amy ta'sakary poko yja'wan me iwe'i'pomboto, amy poto 'su yja'wan oty kapy'pomboto pai i'wa, moro awotamiromo'kato'kon simengary. ");
INSERT INTO car_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Iru'pa ko'wu auranano poko, o'to tauroto'kon poko, ajemerykon poko roten te mo'saton y'wa. Aseke te morokon otykon enetoko. Moropangon otykon poko a'wembono auranano ynen me ywairy 'se'pa wa.” ");
INSERT INTO car_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Irombo imomapo'san i'wa tywyino. ");
INSERT INTO car_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Irombo pa'poro mo'karon moro po ata'nanopy'san 'wa mo'ko Simosu wota'nano'to'kon auto jopotory Sostenes apo'i'po. Mene iwo'ma'po i'waine mo'ko a'wembono auranano ynen jopoto nenery me. Galio we'i'po te o'to yka'pa pairo. ");
INSERT INTO car_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paulus we'i'po amykon kurita noro Korinte po. Irombo moro tytory man ekarity'po i'wa mo'karon Kristus wyinonokon 'wa. Kurijara ta ito'po. Imaro ro Prisila wyto'po Akila maro. Tytory uwaporo tunsety ty'kotopo i'wa kynakon moro Kengre po, moro amy oty kapyry man ekarity'po ke ty'wa Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efese 'wa tytunda'san po Prisila, Akila no'san i'wa. Irombo ito'po moro Simosu wota'nano'to'kon auto 'wa. Moro po ro mo'karon Simosu erupa'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Mo'karon woturupo'san ro i'wa akore'pe noro iwaito'me tokosaine. I'se'pa te iwe'i'po. ");
INSERT INTO car_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Tytory man ekarityry jako te ika'po: “I'se Tamusi a'ta, wo'take rapa o'waine.” Irombo kurijara ta Efese wyino ito'po. ");
INSERT INTO car_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Sesarea 'wa tytunda'po mero iwonuku'po mo'karon Tamusi na'nanopy'san 'wa “Iru'pa ro rypo mandon?” tykato'me. Morombo mero iwo'pema'po Antioki 'wa. ");
INSERT INTO car_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","A'si 'ko akore'pe moro po tywe'i'po wyino, ito'po morokon Galatie tanokon aito'kon 'wa, Frigie 'wa enapa, pa'poro mo'karon omepatonon pori'toma. ");
INSERT INTO car_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Irombo amy Apolos tatynen Simosu tunda'po Efese 'wa. Aleksandria po oma'po mo'ko kynakon. Amy tauran uku'nen wokyry mo'ko kynakon. Iru'pyn me moro Tamusi karetary uku'sakon. ");
INSERT INTO car_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Mo'ko Jopoto wyino aino poko tamepa kynakon. Asin pe imero moro poko kynauranakon. Iporo imero morokon Jesus wyinonokon otykon poko mo'karon kari'na emepakon. Moro Johanes 'wa kari'na etyka'san wara roten te kari'na etykary uku'sakon. ");
INSERT INTO car_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Mo'ko 'wa ro enari'ma tauranary a'mo'po moro Simosu wota'nano'to'kon auto ta. Auran eta'po mero ty'waine, Prisila 'wa Akila maro typo aro'po. Moro Tamusi wyino aino enepo'po i'waine i'wa iru'pyn me 'ne ka'tu rapa. ");
INSERT INTO car_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Irombo Akaje 'wa tytory 'se iwe'i'po mero, mo'karon Kristus wyinonokon 'wa asinanopy'po. Kareta aropo'po i'waine mo'karon moro po omepatonon 'wa, iru'pa itundary apyito'me i'waine. Akaje 'wa tytunda'po mero, amy poto me mo'karon Kristus wyinonokon me e'i'san pori'tomanen me iwe'i'po Tamusi turu'popory ta. ");
INSERT INTO car_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Pari'pe irombo mo'karon Simosu auran po'takaro iwe'i'po pa'poro kari'na embata. Moro Tamusi karetary wyino mo'ko Mesias me Jesus wairy enepo'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Korinte po Apolos a'ta, Paulus tunda'po Efese 'wa, morokon wypy tanokon aito'kon 'wa tytopoty'po wyino. Moro Efese po ro amykon omepatonon epory'san i'wa. ");
INSERT INTO car_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Irombo ika'po i'waine: “Kristus wyinonokon me awairykon jako, mo'ko Tamusi a'kary mapyisen?” Ika'san i'wa: “Mondo Tamusi a'kary wairy aneta'pa pairo na'na kynainen.” ");
INSERT INTO car_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Irombo ika'po i'waine: “Oty me ko iro ke masetykaposen?” Irombo ika'san: “Johanes 'wa kari'na etyka'san wara na'na enapa kynosetykapon.” ");
INSERT INTO car_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paulus wyka'po te: “Johanes 'wa kari'na tatyka man emamyrykon u'ma'po enepoto'me. Tyka man i'waine, mo'ko tywena'po ta o'toto man, mo'ko Jesus, amyikato'me i'waine.” ");
INSERT INTO car_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Moro eta'po mero, iwosetykapo'san Jesus ety ta. ");
INSERT INTO car_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Paulus 'wa itu'ponakaine tainary yry jako ro, mo'ko Tamusi a'kary wopy'po itu'ponakaine. Ukuty'non roten auranano ta aurana'san. Tamusi auran uku'po'po enapa i'waine. ");
INSERT INTO car_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ainapatoro itu'ponaka oko iwairy taro mo'karon asetykapo'san wokyryjan kynatokon. ");
INSERT INTO car_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Oruwa nuno Paulus kyndopo'sakon moro Simosu wota'nano'to'kon auto 'wa. Enari'ma mo'karon kari'na erupakon. I'waine ro moro Tamusi nundymary ekary amyikapory poko kynakon. ");
INSERT INTO car_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amykonymbo te kyneja'nakatokon. Moro oka amyikary 'sepa kynatokon. Mo'karon kari'na apyimy embata moro Kristus wyino aino auno'potyry a'mo'po mero i'waine, Paulus wyto'po iwyinoine. Mo'karon omepatonon aro'san i'wa tymaro. Irombo poro kurita wararo kynerupatokon moro Tiranus ety tano omepatopo auto ta. ");
INSERT INTO car_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Oko siriko moro wara iwe'i'po. Iwara pa'poro mo'karon Asia po amandonon 'wa mo'ko Jopoto ekary eta'po, Simosu 'wa, Griek 'wa enapa. ");
INSERT INTO car_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Potonon pori'tonano ka'pojakon Tamusi mo'ko Paulus 'wa. ");
INSERT INTO car_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Morokon eramukuru y'kokato'konymbo, morokon emaminato'konymbo kamisa yry'san pairo mo'karon kari'na 'wa mo'karon je'tun pangon tu'ponaka. Iwara morokon anykyrykonymbo kynuta'satokon. Mo'karon akyrykonymbo enapa kynepa'katokon. ");
INSERT INTO car_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Irombo amykon ytopo'tonon, kari'na akykanamon Simosu we'ku'san moro Jesus ety ta mo'karon takyramon kari'na akykary poko. Ika'san mo'karon akyrykon 'wa: “Mo'ko Paulus nekarory Jesus pori'tory ta kymomaton.” ");
INSERT INTO car_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Oko-to'ima amy Tamusi pokonokon jopotory Skevas tatynen Simosu ymurukon wokyryjan we'i'san moro wara. ");
INSERT INTO car_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mo'ko yja'wan wyka'po te i'waine eju'to'ko'me: “Jesus suku'sa. Paulus ekary setan. Amyjaron te, no'kan ko amyjaron mandon?” ");
INSERT INTO car_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Irombo mo'ko takyren wokyry wota'poromy'po itu'ponakaine. Pa'poro i'mondo'san i'wa. Iko'poine pari'pe kynakon. Iwo'my'ma, mene tywo eka'numy'san moro auto wyino. ");
INSERT INTO car_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Moro ekary eta'po ro pa'poro mo'karon Efese ponokon Simosu 'wa, Griek 'wa enapa. Poto 'su anari wopy'po itu'ponakaine. Iwara mo'ko Jopoto Jesus ety we'i'po poto me 'ne ka'tu rapa. ");
INSERT INTO car_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Pyime Kristus wyinonokon me e'i'san wopy'san morokon yja'wan me tywe'i'san ekari'se Tamusi embata, kari'na embata enapa. ");
INSERT INTO car_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","A'si'ko pyime enapa mo'karon tamorekamonymbo 'wa tykaretarykonymbo enepy'san. Irombo pa'poro kari'na embata ikoro'ka'san i'waine. Morokon kareta epety u'ku'po i'waine oko-kari'na itu'ponaka ainapatoro dusun amu'nymbo pyrata iwairy taro. ");
INSERT INTO car_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Iwara moro Tamusi auran pari'pe kynotaripa'sakon. Poto me 'ne ka'tu rapa kynaijakon. ");
INSERT INTO car_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Pa'poro morokon wo'kapy'ma'san mero, Paulus 'wa Jerusalem 'wa tytory man yry'po Masedonie tu'po, Akaje tu'po enapa. Ika'po: “Moro 'wa ywyto'po wyino, Rome 'wa enapa ywytory man.” ");
INSERT INTO car_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Irombo oko tapatongon emoky'san i'wa Masedonie 'wa: Timoteus Erastus maro. Mo'ko 'nero we'i'po te a'si 'ko noro Asia po. ");
INSERT INTO car_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Moro jako ro amy poto 'su atamiromo'kano we'i'po moro Kristus wyino aino poko. ");
INSERT INTO car_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Amy Demetrius tatynen amu'nymbo ka'nen amu'nymbo ka'po'sakon Artemis auty'makon me mo'karon ta'sakarykon maro. Iwara ro poto me pyrata epojatokon. ");
INSERT INTO car_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Mo'ko Demetrius 'wa ro pa'poro moro amaminano pokonokon a'nano'po'san. Ika'po: “Yja'sakarykon, muku'saton pyime pyrata epory ky'waine ero amaminano poko. ");
INSERT INTO car_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Mo'ko Paulus te uwa mo'karon ikapy'san tamusi wairy ekarojan. Pyime kari'na 'wa moro oka tamyikapo i'wa man, ero Efese po roten kapyn, pa'poro rypo Asia po enapa te. Moro ro aseke menejaton, metaton enapa. ");
INSERT INTO car_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Moro inekarory oka moro kamamingon uta'kary taro roten kapyn man. U'ku'pa enapa te mo'ko poto 'su woryi tamusi Artemis auty ypory taro man. Mo'ko pa'poro Asia po, pa'poro ero nono tu'po enapa woryi tamusi me kynamyikaton inoro kuranory any'maton!” ");
INSERT INTO car_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Moro eta'po mero, iwore'ko'san. Tyko'ke ika'san: “Kurano me pore mo'ko Efese pono Artemis man!” ");
INSERT INTO car_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ekonykon 'wa ro pa'poro moro aitopo sararakapo'po. Tymonge mo'karon kari'na wetururuka'san moro asaijambatopo taka. Mo'karon Paulus maro opy'san Masedonie ponokon Gajus, Aristarko kyryryka'san i'waine tymaroine. ");
INSERT INTO car_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paulus we'i'po mo'karon kari'na apyimy taka tytory 'se. Anaropo'pa te mo'karon omepatonon we'i'san. ");
INSERT INTO car_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Amykon ipynanamon Asia undymanamon 'wa enapa Paulus e'mapo'po moro asaijambatopo taka itory pona. ");
INSERT INTO car_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Tamero roten mo'karon kari'na apyimyn wota'nanopy'san ko'tapoty'san, atukuty'pa oty wairy ke. Pyime kari'na oty upu'po me tywota'nanopy'san anukuty'pa kynatokon. ");
INSERT INTO car_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Irombo mo'karon Simosu 'wa Aleksander arima'po uwaponaka, mo'karon kari'na 'wa auranato'me. Mo'ko Aleksander 'wa ro tainary awonga'po ity'nato'ko'me, mo'karon Simosu aijomato'me ty'wa mo'karon kari'na embata. ");
INSERT INTO car_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Simosu me te iwairy ukuty'po mero ty'waine, pa'poro asewara mo'karon kari'na ko'tapoty'san oko juru iwairy taro: “Kurano me pore mo'ko Efese pono Artemis man!” ");
INSERT INTO car_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Mo'ko kareta pokono jopoto 'wa te ko'wu mo'karon ata'nanopy'san yity'nano'po'san. Irombo ika'po i'waine: “Efese ponokon yja'sakarykon! Noky ko ero nono tu'po anukuty'pa nan Efese wairy mo'ko kurano Artemis auty enenen me, moro kapu wyino oma'po oty enenen me enapa? ");
INSERT INTO car_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Onapi me morokon otykon ekarityry tupi me man. Iro ke ro oity'narykon man. Tonsi'ne 'ne oty kysika'ton. ");
INSERT INTO car_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Mojan wokyryjan ro rypo tane'se o'waine mandon ijaro 'wa. Amy tamusi auty ta te imonata'pa tywaije mandon. Mo'ko kytamusirykon woryi poko enapa yja'wan me o'to yka'pa tywaije mandon. ");
INSERT INTO car_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Amy kari'na emendory 'se Demetrius a'ta mo'karon ta'sakarykon maro, iru'pa man. O'kapyn roten a'wembono auranano yjaton mo'karon a'wembono auranano ynamon jopotokon. Mo'karon po'ponaka ase'wa iwosemendorykon man. ");
INSERT INTO car_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amy terapa oty 'se noro aja'taine, moro omenano mero'po wararo kywota'nanopyrykon man, kaurangon epopoto'me ipoko. ");
INSERT INTO car_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Moro erome o'kapy'po oty poko kamendorykon taro kytaton warinu upinamon me. O'tono'me kywetururuka'san ekarityry kysupijaton. O'to pairo kykarykon kysupijaton ipoko.” Moro wara tyka'po mero mo'karon etururuka'san emoky'san i'wa autykon 'wa rapa. ");
INSERT INTO car_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Pa'poro oty yity'na'po mero rapa, Paulus 'wa mo'karon omepatonon ko'mapo'san ty'wa. Ituru'san pori'toma'san i'wa. Tytory ekarity'po mero ty'wa i'waine, iwaimoky'po Masedonie 'wa. ");
INSERT INTO car_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Moro po tytopotyry jako ro pyime auranano ke mo'karon Kristus wyinonokon pori'toma'san i'wa. Irombo Griek yinonory 'wa itunda'po. ");
INSERT INTO car_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Oruwa nuno moro po iwe'i'po. Irombo kurijara ta Sirie 'wa rapa tytory 'se iwe'i'po. Moro jako 'ne tywory 'se mo'karon Simosu wairy ukuty'po i'wa. Iro ke ro Masedonie tu'po rapa ito'po. ");
INSERT INTO car_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mojan wokyryjan wyto'san imaro: mo'ko Berea pono Pirus ymuru Sopater, mo'karon Tesalonika ponokon Aristarko, Sekundus enapa, mo'ko Derbe pono Gajus, Timoteus, mo'karon Asia ponokon Tikikus, Trofimus enapa. ");
INSERT INTO car_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Mo'karon wyto'san ro uwapo Troas 'wa na'na momo'se. ");
INSERT INTO car_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Na'na waimoky'po te Filipi wyino kurijara ta morokon uwaputa'non perere ewa'mato'kon kurita pa'po me. Ainatone kurita na'na we'i'po Troas 'wa tytory poko. Moro po ro oko-to'ima kurita na'na we'i'po. ");
INSERT INTO car_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Moro otare'matopo kurita pa'po me na'na wota'nanopy'po endame. Irombo Paulus mo'karon Kristus wyinonokon erupakon. Irombo koro'po tywaimokyry man yry'po ke ty'wa, irawone 'ne taronaka ro kynauranakon. ");
INSERT INTO car_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","A'si'ko pyime kororeta typo'mapo'se kynatokon moro kawo na'na wota'nanopy'po po. ");
INSERT INTO car_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pena ta amy myre'ko'ko tandy'po kynakon. Eutikus ety me kynakon. Akore'pe imero mo'ko Paulus auranary jako ro uwety kyniwojakon. Iwo'nyky'po. Irombo iwotuwa'mo'po po'ponaka moro ijoruwanory kawono auto rary wyino. Ekepy'po anumy'po terapa i'waine. ");
INSERT INTO car_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Tywony'to'po mero, Paulus woma'po aseke itu'ponaka. Typona aky'ka'po i'wa. Ika'po: “Kytotaikapo'ton. Nuro man.” ");
INSERT INTO car_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Kawonaka tyto'po mero rapa, arepa y'sakapoty'po Paulus 'wa. Iwendame'po na'na maro. Akore'pe noro erupa'san i'wa. Aweitary jako terapa aikepy'po. Morombo mero ito'po. ");
INSERT INTO car_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nuro terapa mo'ko myre'ko'ko aro'po i'waine auty 'wa. Ituru'san wepori'toma'san imero. ");
INSERT INTO car_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Na'na na'nen wotaru'ka'po moro kurijara taka. Aso 'wa na'na wyto'po. Moro po ro Paulus aru'kary kynakon na'na 'wa. Moro wara ro Paulus tyka tywaije kynakon, typupuru poko Aso 'wa tytory 'se tywairy ke. ");
INSERT INTO car_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Aso po na'na epory'po mero i'wa, aru'ka'po na'na 'wa. Irombo na'na wyto'po Mitylene 'wa. ");
INSERT INTO car_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Moro wyino tywaimoky'po koro'po Kio patonaka na'na tunda'po. Irombo koro'po na'na wepato'po Samos 'wa. Irombo koro'po ko'wu na'na tunda'po Milete 'wa. ");
INSERT INTO car_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Efese ratonomary man irombo tyje Paulus 'wa kynakon, Asia po akore'pe 'ne tywairy pona. Kynonsi'makon, moro koromono wonatopo poty'po ewa'matopo kurita Jerusalem po tywairy u'kuto'me. ");
INSERT INTO car_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Milete po ta'ta ro mo'karon Efese ponokon Tamusi na'nanopy'san uwapotorykon ko'mapo'san i'wa ty'wa. ");
INSERT INTO car_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ty'wa itunda'san mero, ika'po i'waine: “Muku'saton one wara ara'naine yjemamy'po moro koromo ypupuru ema'po poro y'wa ero Asia tu'ponaka. ");
INSERT INTO car_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tamusi 'wano me yjemaminato, po'po ywotapory ta. Ywory poko mo'karon Simosu tywe'kutoine. Moro ro tana'ke yjenato. Moro ro enapa awosin pangon otykon 'wa yju'kupoto. ");
INSERT INTO car_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Amy pairo ajepano'to'kon oty anunemy'pa wairy ta moro oka sekari'to o'waine. Kurando, autokon ta enapa kamepatoine. ");
INSERT INTO car_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mo'karon Simosu 'wa, mo'karon Griek 'wa enapa moro Tamusi 'wa iwotu'marykon man, moro i'waine mo'ko Kyjopotorykon Jesus amyikary man enapa samyikapoto. ");
INSERT INTO car_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Erome ko'wu Jerusalem 'wa wy'sa. Moro 'wa ro irombo Tamusi a'kary ywyry'kanon. Otypan oty 'wa moro po yjepory man anukuty'pa wa. ");
INSERT INTO car_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ymyry man, ykota'mary man enapa amyikapojan te y'wa mo'ko Tamusi a'kary, aito'kon 'wa ytundary wararo. ");
INSERT INTO car_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Y'wa te moro yjemamyry poto me kapyn man. Moro ywytotopo oma y'ma'kary 'se te wa. Moro y'wa mo'ko Jopoto Jesus nyry'po amaminano kapy'mary 'se wa. Moro Tamusi turu'popory ekapory amyikapory 'se wa, wykaje irombo. ");
INSERT INTO car_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Yjene'pa noro rapa awairykon man suku'sa. Pa'poro o'waine moro Tamusi nundymary ekarory saropo'nen. ");
INSERT INTO car_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Iro ke ro ero kurita wykaje o'waine: Ajutapyrykon jako, yju'ta e'i'pa maitaton. ");
INSERT INTO car_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Pa'poro irombo o'to wainen pa'poro moro Tamusi nisanory ekaroto'me y'wa o'waine. ");
INSERT INTO car_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Tuwaro aitoko aseke apokoine, mo'karon ajekosanokon Tamusi na'nanopy'san kapara poko enapa. Enenamon me ro Tamusi a'kary 'wa tyje mandon, ituwaro'mato'ko'me. Tapeka'se Tamusi 'wa mo'karon mandon aseke tymuru mynuru ke. ");
INSERT INTO car_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Uwa ywe'i'po mero anari'non no'kan wopyry man suku'sa ara'nakaine. Mo'karon ro kynokombata'ton mo'karon Tamusi na'nanopy'san kapara poko. ");
INSERT INTO car_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Amykon ara'nanokon pairo iporo waty auranano ekari'ta'ton, mo'karon omepatonon kerengato'me tywyinonakaine. ");
INSERT INTO car_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Iro ke ro tuwaro aitoko. Moro oruwa siriko koko, kurita aikepy'pa roten yjurary ta o'win o'win pai y'wa aje'mapoty'san kysuta'katon. ");
INSERT INTO car_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Erome te Tamusi ainaka kyjaton. Oro moro ituru'popory ekary moro awytoto'ko'man oma enepon. Mo'ko aina ro apori'tomarykon man. Pa'poro mo'karon tywyinonokon me e'i'san 'wa moro inapyirykon man yry enapa aina man. ");
INSERT INTO car_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Amy pairo kari'na ekosano amu'nymbo, ika'mi'po, wo'mynano sanory po pai o'poty'pa we'i. ");
INSERT INTO car_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Aseke muku'saton erokon yjainary ke yjemamina'po morokon ynisanory poko, mo'karon yjekosanokon nisanory poko enapa. ");
INSERT INTO car_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Pa'poro o'to ywairy ta senepoi o'waine, one wara amaminano poko kywo'mikarykon man, mo'karon oty'non epano'to'me ky'waine. Mo'ko Jopoto Jesus auranymbo uta'kary kapyn ky'waine man. Aseke irombo tyka man: ‘Iru'pa oty yry man oty apyiry ko'po.’ ” ");
INSERT INTO car_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Moro wara tyka'po mero, iwokunama'po. Pa'poro imaroine Tamusi 'wa aurana'po. ");
INSERT INTO car_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Mo'ja imero pa'poro iwotamo'san. Paulus ewa'ma'po imero i'waine. Iposimapoty'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Moro “Yjene'pa noro maita'ton,” ika'po je'tuma'po 'ne ka'tu rapa i'waine. Aro'po ko'wu i'waine moro kurijara 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wyry'me na'na wo'kerenga'po iwyinoine. Kurijara taka tywotaru'kapo mero, sapatoro na'na wyto'po Kos 'wa, irombo koro'po Rhodos 'wa, irombo wyino Patara 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Moro po ro amy Fenisia 'wa ytototo kurijara epory'po na'na 'wa. Moro taka ro na'na wotaru'ka'po. Irombo na'na waimoky'po ");
INSERT INTO car_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sirie 'wa. Siprus wonepo'po mero, apo'tun wyino na'na 'wa iratonoma'po. Iwara na'na tunda'po Tyrus 'wa. Moro po ro irombo moro kurijara waitarykary kynakon. ");
INSERT INTO car_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Irombo mo'karon omepatonon epoje na'na wyto'po. Oko-to'ima kurita na'na we'i'po ekosaine. Tamusi a'kary 'wa ty'namororykon ke Paulus uru'po i'waine Jerusalem 'wa itory pona. ");
INSERT INTO car_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Irombo ko'wu na'na waimokyry man rapa kynakon, mo'ja ro tytoto'me. Moro kurijara 'wa rapa na'na aro'po pa'poro i'waine, woryijan 'wa, pitanikon 'wa enapa. Moro aitopo no'po mero ty'wa, awopa me na'na wokunama'po, Tamusi 'wa tauranato'me. ");
INSERT INTO car_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Ase'wa “Iru'pa aitoko!” tyka'po mero, na'na wotaru'ka'po moro kurijara taka. Mo'karon wyto'san te auto 'wa rapa. ");
INSERT INTO car_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyrus wyino ro na'na tunda'po Tolemai 'wa. Moro po ro mo'karon Kristus wyinonokon etawa na'na wyto'po. O'win kurita na'na we'i'po ekosaine. ");
INSERT INTO car_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Irombo koro'po na'na wyto'po Sesarea 'wa. Moro po ro na'na wo'my'po mo'ko iru'pyn oka ekaronen Filipus auty taka. Mo'karon oko-to'imanokon a'sakary amy mo'ko kynakon. ");
INSERT INTO car_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Okupa'en emyirykon kynatokon, ino'maine. Tamusi auran uku'ponamon me kynatokon. ");
INSERT INTO car_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Amykon kurita ekosaine na'na we'i'po. Moro jako ro Judea wyino amy Agabus tatynen Tamusi auran uku'ponen wo'pema'po Sesarea 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Na'na 'wa tywopy'po mero, Paulus ekundy pina'po i'wa. Aseke typupuru, tainary my'po i'wa ike. Irombo ika'po: “Ero wara mo'ko Tamusi a'kary kynganon: ‘Ero wara ero akundynano aporemy myta'ton mo'karon Simosu Jerusalem po. Kynyta'ton Simosu me e'i'non ainaka.’ ” ");
INSERT INTO car_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Moro eta'po mero, na'na 'wa, mo'karon moro ponokon Kristus wyinonokon 'wa enapa Paulus e'ma'po Jerusalem 'wa itory pona. ");
INSERT INTO car_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paulus wyka'po te: “O'to ko maijaton? Ajurarykon terapa yturu'po ambotyry 'se man. Ywaimypory taro roten kapyn, ywo'wopory taro enapa te wa Jerusalem po mo'ko Jopoto Jesus ety upu'po me.” ");
INSERT INTO car_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Na'na 'wa tywepanamary 'se'pa iwairy ke, na'na yity'na'po. Na'na wyka'po roten: “Mo'ko Jopoto nisanory ro no'ka'nen.” ");
INSERT INTO car_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Irombo wyino totyrykon maro na'na waimoky'po Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amykon Sesarea ponokon omepatonon wyto'san na'na maro. Mo'karon 'wa ro na'na aro'po amy Mnason tatynen Siprus ponombo 'wa, o'ny'se. Mo'ko ro penaro terapa omepatoto me kynakon. ");
INSERT INTO car_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Jerusalem 'wa na'na tunda'po mero, mo'karon Kristus wyinonokon 'wa na'na ewa'ma'po imero. ");
INSERT INTO car_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Irombo koro'po na'na maro Paulus wyto'po Jakobus 'wa. Pa'poro mo'karon Kristus wyinonokon uwapotorykon enapa moro po kynatokon. ");
INSERT INTO car_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","“Iru'pa ro rypo mandon?” tyka'po mero i'waine, mo'karon Simosu me e'i'non ra'na ty'wa Tamusi nika'po'san otykon ekarity'san Paulus 'wa isiky'i'po mero. ");
INSERT INTO car_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Morokon eta'san mero ty'waine, Tamusi ety awonga'po i'waine. Irombo ika'san Paulus 'wa: “Meneja te, yja'sakary, o'toro 'ko dusun waty mo'karon Kristus wyinonokon me e'i'san Simosu wairy. Tywe'i'san mero moro omenano mero'po wykary wara tywairykon poko kyno'mikaton. ");
INSERT INTO car_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tota te i'waine man o'wa pa'poro mo'karon Simosu me e'i'non ra'na amandonon Simosu emepary mo'ko Moses anamyika'pa noro iwaito'ko'me. Mo'karon wokyryjan ty'makon ani'kotopo'pa iwairykon man poko emeparykon ekari'saton o'wa. Morokon Simosu emery nondapory ekari'saton o'wa ty'waine. ");
INSERT INTO car_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","One wara ko aino nan? Atunda'po ekary etata'ton irombo. ");
INSERT INTO car_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Iro ke ro na'na wykary wara aiko. Okupa'en amykon wokyryjan na'na ekosa mandon. Tywonemarykon ta ty'waine amy oty kapyry man takari'se i'waine man Tamusi 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Mo'karon ro arotoko amaro. Imaroine ekorokapoko. Unsetykon y'kotory epemako. Iwara onapi me roten morokon apoko inekarityrykon otykon wairy uku'ta'ton. Moro Simosu emery arory eneta'ton o'wa moro ty'waine arory wara enapa. ");
INSERT INTO car_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mo'karon Simosu me e'i'non Kristus wyinonokon poko na'na tauran epopon terapa. I'waine ro na'na kareta meron, ikapy'san tamusi 'wa yry'san tonomy anono'pa iwaito'ko'me, mynu anenapy'pa iwaito'ko'me, ena'sawyry'kary ke iwo'po tonomy anono'pa iwaito'ko'me, wararo roten wokyry, woryi poko e'i'pa enapa iwaito'ko'me.” ");
INSERT INTO car_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Irombo Paulus 'wa mo'karon wokyryjan aro'san tymaro. Irombo koro'po imaroine tywekorokapo'po mero, moro Tamusi auty taka ito'po. Moro po ro moro ekorokano y'matyry man kurita ekarity'po i'wa. One wara a'ta pa'poro ty'waine moro Tamusi 'wa tymy yry man ekarity'po enapa i'wa. ");
INSERT INTO car_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Morokon oko-to'imanokon kurita y'matyry 'wa mo'karon Asia wyino opy'san Simosu 'wa Paulus ene'po moro Tamusi auty ta. Irombo pa'poro mo'karon kari'na apyimy sararakapo'po i'waine iweto itoto'ko'me. Apo'i'po mero ty'waine ");
INSERT INTO car_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","iko'tapoty'san: “Na'na epano'toko, Israel pajanymbo! Mo'se ro mo'ko yja'wanymbo amepanen me man! Wararo pa'poro kari'na emepanon Simosu emery urumenato'me i'waine, moro omenano mero'po urumenato'me i'waine, moro Tamusi auty urumenato'me enapa i'waine. Itaka ro Griek tane'se i'wa mandon moro Tamusi auty taka. Iwara ero Tamusi waitopo tyja'wanga i'wa man.” ");
INSERT INTO car_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Moro uwaporo 'ne irombo mo'ko Efese pono Trofimus tone i'waine kynakon imaro moro aitopo ta. Mo'ko aro'po ekano'satokon ro Paulus 'wa moro Tamusi auty taka. ");
INSERT INTO car_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Pa'poro moro Jerusalem wesararaka'po. Kari'na wetururuka'po. Paulus kyryryka'po i'waine kurandonaka moro Tamusi auty wyino. Morombo mero o'win wytory morokon pena etapupoty'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Iwory 'se a'taine ro, mo'ko warinu pokonokon jopotory 'wa moro pa'poro Jerusalem wesararaka'po ekary tunda'po. ");
INSERT INTO car_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","O'win wytory ito'po iwetoine typyitorykon maro, tupi'nonokon jopotokon maro enapa. Ipyitorykon maro mo'ko warinu pokono jopoto ene'po mero ty'waine, Paulus wokepy'po i'waine. ");
INSERT INTO car_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Tytunda'po mero, mo'ko warinu pokono jopoto 'wa Paulus apyipo'po. Opatoro imypo'po i'wa siparari ke. Irombo noky me iwairy poko, otypan oty kapy'po poko enapa i'wa iwoturupo'po. ");
INSERT INTO car_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Tamero roten mo'karon kari'na apyimy kyniko'tapo'sakon. Morokon iko'tykon ra'na one wara 'ne moro oty wairy ukutyry upijakon. Iro ke ro Paulus aropo'po i'wa moro warinu pokonokon auty 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Iwonukuru mero mo'karon kari'na apyimy ekony wyino Paulus anumy'po pairo mo'karon warinu pokonokon 'wa. ");
INSERT INTO car_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","“Kysiwosen!” tykary arojakon mo'karon kari'na apyimy iwena'po ta tyko'ke imero. ");
INSERT INTO car_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Mo'karon warinu pokonokon auty taka ta'mykary mero, Paulus wyka'po mo'ko warinu pokonokon jopotory 'wa: “Amy oty poko ywoturupory 'se wa o'wa.” Irombo Paulus ejuku'po i'wa: “Ky! Griek auran ka'tu metanon? ");
INSERT INTO car_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mo'ko penaro waty mo'karon Rome ponokon weto kari'na apokumanenymbo, mo'ko wo'i taka okupa'en dusun tokonamon aronenymbo Egypte pono kapyn iro ke amoro man?” ");
INSERT INTO car_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paulus wyka'po te: “Uwa. Moro Silisia tano takaren aitopo Tarsus pono Simosu awu wa. Waturupoja o'wa mo'karon kari'na 'wa yjauranato'me.” ");
INSERT INTO car_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Iru'pa i'wa epory'po mero, Paulus 'wa moro tawo'nuku'po po tainary awonga'po, mo'karon kari'na yity'nato'me. Ity'na'ma'san mero, aurana'po i'waine moro Simosu auran ta. Ika'po: ");
INSERT INTO car_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Yja'sakarykon, uwapoto'san, epanamatoko ero ywosaijomatopo yjauran 'wa.” ");
INSERT INTO car_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Simosu auran ta auranary etary mero ty'waine, ity'na'san 'ne katu rapa. Ika'po: ");
INSERT INTO car_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Simosu awu wa. Tywoma wa moro Silisia tano aitopo Tarsus po. Ero po te wetuwaro'man. Gamaliel ekosa iru'pyn me 'ne womepan morokon kytangon emerykon mero'san poko. Wararo Tamusi emamin poko wo'mikan, moro erome awo'mikarykon wara enapa. ");
INSERT INTO car_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Moro asery omepano apyinamon uta'kary 'se wainen. Wokyryjan, woryijan simysen yja'wangon kari'na aru'katopo taka aru'kato'ko'me. ");
INSERT INTO car_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Iporo moro wairy ekarityry taro man mo'ko Tamusi pokonokon jopotory mo'karon uwapoto'san maro. Mo'karon enapa irombo mo'karon ka'sakarykon 'wanokon kareta ysen y'wa, Damaskus 'wa ywytory man jako. Moro po enapa moro asery omepano apyinamon myry 'se wainen Jerusalem 'wa ene'to'ko'me, ikota'mato'ko'me. ");
INSERT INTO car_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Irombo wytonen Damaskus 'wa. Tyse waty ytundary we'i'po mero, typo roten kurita 'ne 'ne kapu wyino amy poto 'su aweinano kyno'nen yjaweipa. ");
INSERT INTO car_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Woman nono tu'ponaka. Irombo amy auranano wykary setan y'wa: ‘Saul, Saul, o'tono'me ko ajerekuru ywekenanon?’ ");
INSERT INTO car_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Irombo seju'nen: ‘Noky ko amoro man, Jopoto?’ Irombo kyngan y'wa: ‘Mo'ko Nasaret pono Jesus awu wa, mo'ko aniwekenary.’ ");
INSERT INTO car_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Mo'karon ymaro ytotonon ro rypo moro aweinano enesen. Mo'ko yjerupanen auran aneta'pa te kynaisen. ");
INSERT INTO car_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Irombo wykan: ‘O'to ko waitan, Jopoto?’ Mo'ko Jopoto kyngan y'wa: ‘Ajawongo. I'tango Damaskus 'wa. Moro po ro moro o'to 'ne awairy man metatake.’ ");
INSERT INTO car_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Moro anusi'kanen aweinano 'wa yjenuke'ka'po ke, mo'karon ymaro ytotonon yjapory ta terapa yjarosen Damaskus 'wa. ");
INSERT INTO car_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Moro po ro amy Ananias tatynen wokyry kynakon. Moro omenano mero'po wara amandoto mo'ko kynakon. Pa'poro mo'karon moro ponokon Simosu kynamyikatokon. ");
INSERT INTO car_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Mo'ko ro kyno'nen y'wa. Kyngan: ‘Saul, yja'sakary, ajenutako!’ Irombo o'win wytory yjenutan rapa. Ananias senen. ");
INSERT INTO car_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Irombo kyngan y'wa: ‘Penaro terapa mo'ko kytangon tamusiry 'wa tapyije mana moro tynisanory uku'to'me o'wa, mo'ko tamamboren eneto'me o'wa, indary wyino enapa auran etato'me o'wa. ");
INSERT INTO car_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ekataka ro pa'poro kari'na 'wa morokon anene'san, aneta'san otykon amyikaponen me maitake. ");
INSERT INTO car_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Oty noro ko mimomo'san? Ajawongo. Asetykapoko. Oja'wanykonymbo iku'mi'poko, ety ejatory ta.’ ");
INSERT INTO car_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Jerusalem 'wa ywerama'po po rapa, moro Tamusi auty ta Tamusi 'wa yjauranary jako, yjenuja'kandan. ");
INSERT INTO car_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Inoro ro rapa Jopoto wykary senen y'wa: ‘Onsi'mako! Ko'i terapa Jerusalem wyino i'tango. Moro o'wa yjekary amyikapory anapo'i'pa kynaita'ton.’ ");
INSERT INTO car_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Awu te wykan: ‘Jopoto, morokon Simosu wota'nano'to'kon auto wararo mo'karon ajamyikanamon myry, ipoky'marykon enapa aropo'nenymbo me ywairy uku'saton aseke. ");
INSERT INTO car_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Mo'ko ajekary amyikaponenymbo Stefanus mynuru y'kambory jako, moro po enapa wakon. Iru'pa moro wara yry sepojakon. Mo'karon iwonamon wo'mykon enenen me wakon.’ ");
INSERT INTO car_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Irombo kyngan y'wa: ‘I'tango. Awu komo'sa tyse mo'karon Simosu me e'i'non 'wa.’ ” ");
INSERT INTO car_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ero eta'po mero, Paulus 'wa iwepanamakepy'san. Iko'tapoty'san: “Nuta'nen mo'ko wokyry! Mo'kopan wairy kapyn man nuro.” ");
INSERT INTO car_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Tyko'tapotyrykon ta ro iwewo'mynga'san. Kawonaka sakau e'kyino'san i'waine. ");
INSERT INTO car_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Moro ene'po mero ty'wa, mo'ko poto 'su warinu pokonokon jopotory wyka'po Paulus a'mykato'me moro warinu pokonokon auty taka, ipoky'mary ta o'to iwe'i'po mengato'me. O'tono'me ipoko iko'tapotyrykon ukutyry 'se kynakon. ");
INSERT INTO car_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Typoky'mato'me tymyry jako ro i'waine, Paulus wyka'po mo'ko tokonda aitoto warinu pokonokon jopotory 'wa: “Iru'pa nan amy Rome jopotory upi'nono ypoky'mary amy a'wembono auranano ynen jopoto auran pyndo?” ");
INSERT INTO car_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Moro eta'po mero ty'wa, mo'ko jopoto wyto'po mo'ko topono jopoto 'wa. Ika'po: “O'to ko maitan? Amy Rome jopotory upi'nono irombo mo'ko wokyry man.” ");
INSERT INTO car_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Mo'ko epono jopoto wyto'po Paulus 'wa. Ika'po i'wa: “Amy Rome jopotory upi'nono amoro man? Kaiko y'wa.” Paulus wyka'po: “A'a.” ");
INSERT INTO car_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Mo'ko jopoto 'wa ejuku'po: “Awu poto me imero pyrata sepeman, amy Rome jopotory upi'nono me ywaito'me.” Paulus wyka'po: “Awu te amy Rome jopotory upi'nono me tywoma wa.” ");
INSERT INTO car_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Moro eta'po mero, anipoky'ma'pa rapa mo'karon ipoky'mary 'sangonymbo we'i'san. Mo'ko jopoto wety'ka'po enapa, amy Rome jopotory upi'nono me mo'ko tynimy'po wairy ukuty'po mero. ");
INSERT INTO car_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Mo'karon Simosu 'wa Paulus emendopo ukutyry 'se iru'pyn me mo'ko jopoto kynakon. Iro ke ro irombo koro'po mo'karon Tamusi pokonokon jopotorykon, pa'poro mo'karon Simosu jopotorykon enapa a'nano'po'san i'wa. Ipo'ponakaine ro Paulus ene'po'po i'wa moro aru'katopombo wyino. ");
INSERT INTO car_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Mo'karon Simosu jopotorykon 'wa tywo'potyry ta Paulus wyka'po: “Yja'sakarykon, moro ero kurita 'wa ro ka'sakarykon ra'na Tamusi embata yjemamy'po yturu'po anamiromo'ka'pa man.” ");
INSERT INTO car_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Irombo mo'ko Tamusi pokonokon jopotory Ananias 'wa ipotapaikapo'po mo'karon aporitonokon 'wa. ");
INSERT INTO car_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Morombo mero Paulus wyka'po i'wa: “Apaikatan Tamusi, kurando tywonepore aitoto! Amoro moro omenano mero'po wykary wara a'wembono auranano ypoko mytan? Moro omenano mero'po wara waty kore kypaikapoja, ran!” ");
INSERT INTO car_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Mo'karon Paulus aporitonokon wyka'san: “Mo'ko Tamusi pokonokon jopotory mejuja!” ");
INSERT INTO car_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Irombo Paulus wyka'po: “Yja'sakarykon, mo'ko Tamusi pokonokon jopotory me iwairy anukuty'pa we'i. Ero wara irombo tymero man: ‘Ajundymanamon jopoto poko yja'wan me ajauranary kapyn man.’ ” ");
INSERT INTO car_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Irombo Saduse me, Farise me enapa mo'karon Simosu jopotorykon wairy wopy'po mero tanuru taka, Paulus ko'ta'po ira'naine: “Yja'sakarykon, Farise awu wa. Farise ytangon me tywaije mandon. Moro y'wa iromby'san awomyry momokyry poko a'wembono auranano yry man ypoko.” ");
INSERT INTO car_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Moro wara ika'po mero, mo'karon Farise woseju'poty'san mo'karon Saduse maro. Iwonumengarykon wotaripapy'po. ");
INSERT INTO car_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Mo'karon Saduse irombo uwa moro iromby'san wyino awono wairy ekari'saton. Uwa Tamusi apojon ekari'saton. Uwa a'kanano ekari'saton enapa. Mo'karon Farise te pa'poro mondo morokon otykon wairy amyikaton. ");
INSERT INTO car_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Mo'ja imero ase'wa iko'tapoty'san. Irombo amykon Tamusi karetary uku'namon Farise awomy'san. Tarekurukon ta ika'san: “Mo'se wokyry ta yja'wan oty anepory'pa na'na man! Amy a'kanano, amy Tamusi apojon pai taurana man i'wa.” ");
INSERT INTO car_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Poto me moro areku wairy ene'po mero ty'wa, mo'ko warinu pokonokon jopotory wety'ka'po Paulus sara'kapotyry pona i'waine. Iro ke ro moro warinu pokonokon apyimy ko'mapo'po i'wa emima iwyinoine. Aropo'po i'wa i'waine moro warinu pokonokon auty taka rapa. ");
INSERT INTO car_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Irombo koko mo'ko kapu tano Jopoto wonepo'po i'wa. Ika'po i'wa: “Eja'nakako. Moro Jerusalem po yjekary amyikapory poko awe'i'po wara Rome po enapa amyikapory poko maitake.” ");
INSERT INTO car_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Irombo koro'po mo'karon Simosu 'wa taurangon epopo'po maname Paulus wory man poko. Tamusi embata endame'pa, onyry'pa enapa tywairykon man ekarity'po i'waine ase'wa moro Paulus wory uwaporo. ");
INSERT INTO car_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Mo'karon taurangon epoponamonymbo oko-kari'na wokyryjan ko'po kynatokon. ");
INSERT INTO car_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Mo'karon wyto'san ro mo'karon Tamusi pokonokon jopotorykon 'wa, mo'karon uwapoto'san 'wa enapa. Ika'san: “Tamusi embata amy otymbo ro anyry'pa tyndaka tywairy man ekarityi na'na ase'wa moro Paulus wory uwaporo. ");
INSERT INTO car_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Amyjaron te mo'karon Simosu jopotorykon maro mo'ko warinu pokonokon jopotory 'wa aturupotandoko Paulus aropoto'me apo'ponakaine rapa. Iru'pa 'ne ka'tu rapa ipoko oty ukutyry 'se okari'toko. Na'na mondo terapa kynaitan itundary uwaporo iwoto'me.” ");
INSERT INTO car_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paulus patymy 'wa te moro iwory 'se iwairykon eta'po. Irombo ito'po moro warinu pokonokon auty 'wa, Paulus 'wa ekari'se. ");
INSERT INTO car_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Irombo Paulus 'wa o'win amy warinu pokonokon jopotory ko'ma'po. Ika'po i'wa: “Mo'se myre'ko'ko aroko mo'ko ajepono 'wa. Amy oty ekarityry 'se man i'wa.” ");
INSERT INTO car_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Mo'ko 'wa ro mo'ko myre'ko'ko aro'po mo'ko topono 'wa. Ika'po i'wa: “Paulus, mo'ko aru'ka'po yko'mai. Naturupoi y'wa mo'se myre'ko'ko ene'to'me o'wa. Amy oty ekarityry 'se man o'wa.” ");
INSERT INTO car_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Irombo mo'ko poto 'su warinu pokonokon jopotory 'wa mo'ko myre'ko'ko apo'i'po apory poko. Typo aro'po i'wa. Iwoturupo'po i'wa: “Oty ekarityry 'se ko man y'wa?” ");
INSERT INTO car_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ika'po: “Mo'karon Simosu 'wa taurangon topopo man, o'wa tywoturupoto'ko'me, koro'po o'wa mo'ko Paulus aropoto'me mo'karon Simosu jopotorykon po'ponaka, iru'pa 'ne ka'tu rapa ipoko oty uku'to'me tiro. ");
INSERT INTO car_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kysamyikaton te. Oko-kari'na ko'po wokyryjan maname iwory 'se mandon. Tamusi embata endame'pa, onyry'pa enapa tywairykon man tajato i'waine man ase'wa moro Paulus wory uwaporo. Erome moro aropory momo'saton roten o'wa.” ");
INSERT INTO car_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Irombo mo'ko jopoto wyka'po mo'ko myre'ko'ko 'wa: “Amy 'wa koro ero y'wa anekarity'po kysekarityi.” Irombo aropo'po i'wa. ");
INSERT INTO car_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Irombo oko amykon warinu pokonokon jopotorykon ko'ma'san i'wa. Ika'po: “Oro ainapatoro-kari'na warinu pokonokon, oruwa-kari'na itu'ponaka ainapatoro kaware tu'ponokon, ainapatoro-kari'na waita aronamon enapa naike'sen tytoto'ko'me Sesarea 'wa, koko, okupa'en-to'ima juru a'ta. ");
INSERT INTO car_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Oro amykon kaware mondo naisen Paulus aroto'me. Oro iru'pa narosen mo'ko Rome wyinono jopoto Feliks 'wa.” ");
INSERT INTO car_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Amy kareta mero'po enapa i'wa ero wara: ");
INSERT INTO car_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaudius Lysias mo'ko tywaiporen jopoto Feliks 'wa ero kareta merojan. Iru'pa ro rypo man? ");
INSERT INTO car_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Mo'se wokyry mo'karon Simosu 'wa tapyije kynakon. Iwory manombo rypo i'waine kynakon. Iro ke ro yjupi'nonokon maro iwyinoine emima wytonen. Rome pono me iwairy suku'nen. ");
INSERT INTO car_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Moro i'waine emendotopo ukutyry 'se ywairy ke mo'karon ijopotorykon po'ponaka saron. ");
INSERT INTO car_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Iwara ro seponen emendory i'waine amykon tamerykon mero'san poko. Amy iwopoto'man oty poko kapyn, amy imypoto'man oty poko kapyn enapa te emendory i'waine seponen. ");
INSERT INTO car_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Iwory 'se iwairykon eta'po mero te, o'win wytory saropoi o'wa. Mo'karon emendonamon 'wa enapa suku'poi moro apo'ponaka itorykon man morokon ty'waine emendoto'kon ekari'se. ");
INSERT INTO car_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Mo'ko toponokon jopoto wyka'po wararo, mo'karon warinu pokonokon wyto'san mo'ko Paulus aije. Koko aro'po i'waine moro Antipatris 'wa. ");
INSERT INTO car_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Irombo koro'po mo'ko Paulus aropo'po i'waine mo'karon kaware tu'ponokon 'wa. Mo'karon 'nero werama'san te moro tautykon 'wa rapa. ");
INSERT INTO car_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Sesarea 'wa tytunda'san mero, mo'karon kaware tu'ponokon 'wa moro kareta yry'po mo'ko Rome wyinono jopoto ainaka. Paulus aro'po enapa i'waine ipo'ponaka. ");
INSERT INTO car_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Moro kareta erupa'po mero ty'wa, mo'ko jopoto woturupo'po Paulus 'wa ojeno me iwairy poko. Paulus wyka'po: “Silisia pono awu wa.” ");
INSERT INTO car_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Irombo mo'ko jopoto wyka'po: “Mo'karon ajemendonamon wopy'san mero, wepanamatake o'wa.” Irombo Paulus erandopo'po moro Herodes namypo'po auto ta. ");
INSERT INTO car_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ainatone kurita Paulus tunda'po we'i'po mero, mo'ko Tamusi pokonokon jopotory Ananias wopy'po amykon uwapoto'san maro, amy Tertulus tatynen awo'ka maro enapa. Mo'ko Rome wyinono jopoto po'ponaka iwopy'san Paulus emendotopo uku'po. ");
INSERT INTO car_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Paulus ko'mapo'po mero, Tertulus 'wa emendory a'mo'po. Ika'po: “Tywaiporen jopoto Feliks, opo te sara'me imero na'na kynemanjan. Awonumengapory iru'pa 'ne ka'tu rapa otykon yryi na'na 'wano me. ");
INSERT INTO car_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Wararo tyto'po po ro erokon anuta'ka'pa roten na'na man ajety awongary ta. ");
INSERT INTO car_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Aromangary 'se'pa te wa. Iro ke ro waturupoja o'wa ko'i roten awepanamato'me na'na 'wa tawa'pore. ");
INSERT INTO car_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Any'mato mo'se wokyry eporyi na'na. Pa'poro ero nono tu'po mo'karon Simosu ere'kopojan asepoko. Mo'ko Nasaret pono wyinonokon jopotory me mo'se man. ");
INSERT INTO car_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Moro Tamusi auty yja'wangary poko pairo kyne'kun. Irombo na'na kynapyinen.” ");
INSERT INTO car_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","“O'wa imengary jako aseke pa'poro morokon na'na 'wa emendoto'kon muku'take.” ");
INSERT INTO car_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Mo'ko tyjawo'karykon wyka'po pori'tomato'me ty'waine, mo'karon Simosu 'wa moro wara ro iwairy ekarity'po. ");
INSERT INTO car_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Mo'ko jopoto 'wa tainary awonga'po mero, Paulus 'wa tauranary a'mo'po. Ika'po: “Suku'sa sirikokon poko mo'karon ero ponokon kari'na poko a'wembono auranano ynen jopoto me awairy. Iro ke ro enari'ma wasaijomaje apo'ponaka. ");
INSERT INTO car_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ainapatoro itu'ponaka oko kurita ko'po kapyn moro Jerusalem 'wa Tamusi ety awonga ywonuku'po man. Iporo moro wairy muku'take, otykon mengary jako o'wa. ");
INSERT INTO car_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Amy pairo kari'na maro ywoseju'potyry, amy pairo kari'na apyimy erupo'tomary enapa anepory'pa kynaisen y'wa, Tamusi auty ta pai, Simosu wota'nano'to'kon autokon ta pai, amy oje terapa pai. ");
INSERT INTO car_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Iporo morokon erome ty'waine yjemendoto'kon wairy enepory upijaton o'wa. ");
INSERT INTO car_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Moro amy me onumengano ikato'kon wykary wara te y'wa mo'ko kytangonymbo tamusiry ety awongary pyime'tory supija. Pa'poro moro omenano mero'po, mo'karon Tamusi uku'ponamonymbo nimero'san enapa samyikaje. ");
INSERT INTO car_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mojan wara enapa amy oty wopyry simomo'sa Tamusi wyino: moro tamamboramon, emambo'non enapa awomyry man rapa mo'karon iromby'san wyino. ");
INSERT INTO car_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Moro me ro wo'mikaje yturupo yjamiromo'ka'pa iwaitome Tamusi embata, kari'na embata enapa. ");
INSERT INTO car_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Sirikokon poko ywyto'po wyino wo'nen rapa ipyrata'non yja'sakarykon 'wa pyrata ene'se, Tamusi 'wa tymy ene'se enapa. ");
INSERT INTO car_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Morokon poko yja'ta ro ikoroka'sene yjeposen moro Tamusi auty ta, kari'na apyimy pyndo, kari'na wotaikapotyry pyndo enapa. ");
INSERT INTO car_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Amykon Asia ponokon Simosu te moro po kynatokon. Mo'karon wairy manombo te man ero po, yjemendoto'me. Amy oty poko pairo te yjemendory upiry suku'sa i'waine. ");
INSERT INTO car_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Oro mojan wokyryjan pai aseke moro ty'waine otypan ynikapy'po yja'wan oty epory'po ekari'sen, mo'karon Simosu jopotorykon po'ponaka yja'ta. ");
INSERT INTO car_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Moro tyra'naine yko'tatopombo poko roten ka'tu yjemendota'ton. Yko'tan irombo: ‘Mo'karon iromby'san awomyry poko erome a'wembono auranano yry man ypoko.’ ” ");
INSERT INTO car_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Mo'ko Feliks mo'ko iru'pa a'si'ko moro asery omepano uku'sakon inoro 'wa amy kurita terapa moro oty mengary man yry'po. Ika'po: “Mo'ko warinu pokonokon jopotory Lysias wopy'po mero, moro ajauranato'konymbo simengatake rapa.” ");
INSERT INTO car_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Irombo mo'ko tupi'nono warinu pokonokon jopotory 'wa Paulus erandopo'po i'wa aru'katopo ta. Ika'po iko'po 'ne 'ne kapyn ipoko iwaito'ko'me, a'sakarykon 'wa epanopyrymbo ana'koto'pa iwaito'ko'me enapa. ");
INSERT INTO car_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Amykon kurita pa'po me Feliks wopy'po rapa mo'ko typyty Drusila, mo'ko Simosu woryiry me kynakon inoro maro. Paulus ko'mapo'po i'wa. Moro Kristus Jesus amyikary poko inekarityry 'wa Feliks wepanama'po. ");
INSERT INTO car_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Tamambore aino poko, eja'nakano poko, moro aireno a'wembono auranano poko enapa Paulus auranary mero te Feliks wety'ka'po. Irombo ika'po: “Iporo terapa man. I'tango. Amy jako pai kyko'mapotake rapa.” ");
INSERT INTO car_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Pyrata yry momo'sakon enapa Paulus 'wa ty'wa. Moro mero kyniko'mapopo'sakon ty'wa, imaro tyworupato'me. ");
INSERT INTO car_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Oko siriko pa'po me Feliks y'petakan me Porsius Festus we'i'po. Mo'karon Simosu ewa'pory me Feliks 'wa mo'ko Paulus no'po aru'ka'po po. ");
INSERT INTO car_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Oruwa kurita moro tynundymary man 'wa tytunda'po wyino, Festus wyto'po Sesarea wyino Jerusalem 'wa. ");
INSERT INTO car_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Moro po ro mo'karon Tamusi pokonokon jopotorykon wopy'san i'wa mo'karon Simosu jopotorykon maro Paulus emendo. ");
INSERT INTO car_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Iwe'pima'san Paulus ene'poto'me i'wa Jerusalem 'wa. Yja'wan me te kynonumengatokon. Oma ta irombo iwory poko kynonumengatokon. ");
INSERT INTO car_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus 'wa te Paulus erandory ekarity'po Sesarea po. Aseke ko'i terapa tytory 'se iwokarity'po. Ika'po: ");
INSERT INTO car_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Oro iro ke mo'karon ajopotorykon nytosen ymaro, nemendoto'se me, yja'wan oty kapy'poto i'wa.” ");
INSERT INTO car_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Oruwa-to'ima kurita ko'po kapyn, ainapatoro kurita ko'po kapyn pai moro ekosaine tywe'i'po wyino, Sesarea 'wa iwo'pema'po rapa. Irombo koro'po iwotandy'mo'po moro a'wembono auranano ytopo tapo'ny tu'po. Paulus ko'mapo'po i'wa typo'ponaka. ");
INSERT INTO car_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Iwopy'po mero mo'karon Jerusalem wyino o'pema'san Simosu 'wa Paulus u'memy'po. Pyime yja'wangon imero otykon poko emendo'po i'waine. Iporo te morokon emendoto'kon wairy enepory upijatokon te. ");
INSERT INTO car_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Tywosaijomato'me te Paulus wyka'po: “Yja'wan me e'i'pa we'i moro Simosu emery mero'po poko, moro Tamusi auty poko, mo'ko Rome pono jopoto poko enapa.” ");
INSERT INTO car_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mo'karon Simosu ewa'porory 'se tywairy ke te Festus woturupo'po Paulus 'wa: “Jerusalem 'wa awytory 'se'pa man, moro po a'wembono auranano syry'se me apoko, erokon ajemendoto'kon menga'san wyino y'wa?” ");
INSERT INTO car_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paulus wyka'po te: “Mo'ko Rome pono jopoto ekataka ero po amy a'wembono auranano ynen jopoto apo'ny man. Moropan po ro a'wembono auranano yry man ypoko. Mo'karon Simosu anyry'pa we'i yja'wan me o'to. Amoro enapa iru'pyn po moro muku'sa. ");
INSERT INTO car_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yja'wan oty kapy'poto y'wa, amy ywopoto'man oty kapy'poto pai y'wa, moro yrombyry anurumena'pa waitake. Iporo waty te morokon mojan 'wa yjemendoto'kon a'ta, amy pairo kari'na o'to yjyry upitan mojan kari'na ewa'poroto'me. Mo'ko Rome pono jopoto 'wa a'wembono auranano yry 'se wa ypoko.” ");
INSERT INTO car_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Mo'karon turunamon maro tyworupa'ma'po mero, Festus wyka'po Paulus 'wa: “Mo'ko Rome pono jopoto 'wa apoko a'wembono auranano yry 'se awairy mekarityi. Mo'ko 'wa ro my'take.” ");
INSERT INTO car_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Amykon kurita pa'po me mo'ko poto 'su jopoto Agripa wopy'po mo'ko Bernis maro Sesarea 'wa, Festus etawa. ");
INSERT INTO car_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Amykon kurita moro po iwairykon ke, Festus 'wa Agripa erupa'po Paulus poko. Ika'po: “Feliks 'wa amy aru'ka'po wokyry tyno man. ");
INSERT INTO car_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Mo'ko poko ro yjerupa kyno'sen mo'karon Tamusi pokonokon jopotorykon, mo'karon Simosu uwapotorykon enapa, Jerusalem po yja'ta. ");
INSERT INTO car_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mo'karon Rome ponokon emery me kapyn moro amy kari'na ewa'poroto'me o'to amy terapa kari'na yry wairy sekari'nen. Mo'karon tamendonamon po'ponaka na'nen mo'ko emendo'po wosaijomary man wairy sekari'nen i'waine. ");
INSERT INTO car_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Kyno'sen ro ijaro 'wa. Iwopy'san koro'po o'win wytory moro a'wembono auranano ytopo yjapo'ny tu'po watandy'mon. Mo'ko wokyry sene'pon ypo'ponaka. ");
INSERT INTO car_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ipo'ponaka ro te amy pairo yja'wan me ynekanopyry oty poko anemendo'pa kynaisen. ");
INSERT INTO car_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Aseke tytamusirykon amyikary emery poko te k