﻿USE sofia;
DROP TABLE IF EXISTS sofia.capNT_vpl;
CREATE TABLE capNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES capNT_vpl WRITE;
INSERT INTO capNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristuqui Davidz̈ majchmajtquiztan, niz̈aza Abrahamz̈ majchmajtquiztan tjoñitac̈ha. Jesucristuz̈ tuquita atchi ejpnacac̈ha tinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamqui Isaacz̈ ejptac̈ha. Isaacqui Jacobz̈ ejptac̈ha. Jacobqui Judaz̈ ejptac̈ha, niiz̈ jilanacz̈tanpacha. ");
INSERT INTO capNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judaqui Fares ejptac̈ha, Zaratanpacha. Tamarqui Fares Zara maatac̈ha. Faresqui Esromz̈ ejptac̈ha. Esromqui Aramz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aramqui Aminadabz̈ ejptac̈ha. Aminadabqui Naasonz̈ ejptac̈ha. Naasonqui Salmonz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonqui Booz ejptac̈ha. Rahabqui Booz maatac̈ha. Boozqui Obedz̈ ejptac̈ha. Rutqui Obedz̈ maatac̈ha. Obedqui Isaíz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaíqui David cjita chawc jilirz̈ ejptac̈ha. Davidqui Urías tjunatan zalz̈cu Salomonz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomonqui Roboamz̈ ejptac̈ha. Roboamqui Abías ejptac̈ha. Abiasqui Asaz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaqui Josafatz̈ ejptac̈ha. Josafatqui Joramz̈ ejptac̈ha. Joramqui Uzías ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uziasqui Jotamz̈ ejptac̈ha. Jotamqui Acaz̈ ejptac̈ha. Acazqui Ezequías ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequiasqui Manasés ejptac̈ha. Manasesqui Amonz̈ ejptac̈ha. Amonqui Josías ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josiasqui Jeconías ejptac̈ha, niiz̈ jilanacz̈tanpacha. Nii timpuqui Israelit z̈oñinacaqui preso chjitz̈tatac̈ha Babilonia cjita yokquin. ");
INSERT INTO capNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jalla nekztanaqui Jeconiasqui Salatielz̈ ejptac̈ha. Salatielqui Zorobabelz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabelqui Abiudz̈ ejptac̈ha. Abiudqui Eliaquimz̈ ejptac̈ha. Eliaquimqui Azorz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azorqui Sadocz̈ ejptac̈ha. Sadocqui Aquimz̈ ejptac̈ha. Aquimqui Eliudz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliudqui Eleazarz̈ ejptac̈ha. Eleazarqui Matanz̈ ejptac̈ha. Matanqui Jacobz̈ ejptac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacobqui Josez̈ ejptac̈ha. Josequi María lucutac̈ha. Mariiqui Jesús majtchinc̈ha. Niz̈aza Jesusaqui Yooz cuchanz̈quita Cristo cjitazakazza. ");
INSERT INTO capNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tunca pusin atchi ejpnacaz̈ kamta wachquichic̈ha Abrahamz̈ timpuquiztan Davidz̈ timpucama. Niz̈aza tsjii tunca pusin atchi ejpnacaz̈ kamta wachquichic̈ha Davidz̈ timpuquiztan Israel z̈oñinacaz̈ Babilonia cjita yokquin preso chjichta timpucama. Niz̈aza tsjii tunca pusin atchi ejpnacaz̈ kamta wachquichic̈ha Babilonia yokquin chjichta timpuquiztan Cristuz̈ nasta tjuñicama. ");
INSERT INTO capNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jalla tuz̈uc̈ha Jesucristuz̈ nastaqui. Niiz̈ maa María cjitiqui Josiz̈tan zalzjapa kazzintac̈ha. Ima lucz̈tan kamcan ica cjissinc̈ha Yooz Espíritu Santuz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Naaz̈a lucu José cjitaqui Yooz kuzcama kamñitac̈ha. Niiz̈ tjun María icaz̈ cjen Josequi kuz turwaysi cjissic̈ha. Nekztan jamazit jaljtis pecatc̈ha. Kjanacama ultimu jaljtitasaz̈ niiqui, Maríiqui z̈oñiz̈ chjaawjkatta cjitasac̈ha, ana honorchiz. ");
INSERT INTO capNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jalla nuz̈ jaljtis pinsan, Yooz Jilirz̈ anjilaqui wiiquin niiz̈quiz tjonzic̈ha, tuz̈ cjican: —José, Davidz̈ majchmaati, Yooz Espíritu Santuqui am maataka t'iczic̈ha. Jalla niz̈tiquiztan ana jiwjata naatan zalzqui. ");
INSERT INTO capNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Niz̈aza majttanaqui, wawz̈ tjuuqui Jesús cjitaz̈ cjequic̈ha. Jalla niiqui niiz̈ wajtchiz z̈oñinaca ujnacquiztan liwriyaquic̈ha. —Nuz̈ cjichic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","23","Tuqui timpuquiztanpacha Yooz Jiliriqui profetz̈quiz chiikatchic̈ha, tuz̈ cjican: “Tsjaa tunsill turqui icaquic̈ha. Nekztan lucmajch wawa mataquic̈ha. Nii wawaqui Emanuel cjitaz̈ cjequic̈ha”. Emanuelqui tuz̈ cjic̈ha: uc̈humnacatanc̈ha Yoozqui. Nii profetz̈ takucama cumplissic̈ha Jesucristuz̈ nastanaqui. ");
INSERT INTO capNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jalla nekztan Josequi tjaji wajtz̈cu, Yooz anjilaz̈ mantitacama ojkchic̈ha. Mariatan zalzic̈ha. Niz̈aza persun tjunjapa ricujchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Naaz̈a majtz tjuñicama Josequi Maríatan anapan ultimu lucutiñi paasic̈ha. Jalla niz̈tiquiztan ana zalzi cjichucatac̈ha, pero chicapan kamñitac̈ha. Wawa majttan, Jesús cjita tjuuz̈tan tjuuzkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belén cjita wajtquiz niz̈aza Judea cjita yokquin Jesusaqui majttatac̈ha. Nii nacionz̈ chawjc jiliritac̈ha Herodes cjitaqui. Jalla nii tuquita timpuquiz jalla tuz̈u watchitakalc̈ha. Nii nacionquin Jerusalén cjita wajtquin tuwanchuctan tsjii kjaz̈ z̈oñinacaqui irantiz̈quichic̈ha. Mago cjita z̈oñinacatac̈ha ninacaqui, warawar puntu istutiiñi. ");
INSERT INTO capNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jerusalén wajtquiz irantiz̈cu pewcpewczic̈ha tuz̈ cjican: —Uzca nassic̈ha judío z̈oñinacz̈ chawjc jiliriqui. ¿Jakziquintaya? —jalla nuz̈ cjican pecunchic̈ha. Niz̈aza cjichic̈ha, —Wejrnacqui tuuna z̈ejlcan niiz̈ nastiquiztan warawara cherchinc̈ha. Jalla niz̈tiquiztan nii rispiti tjonchinc̈ha, —jalla nuz̈ cjican mazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodes cjita jiliriqui magonacaz̈ quint'ita nonz̈cu, ancha pinsamintu apazzic̈ha persun kuzquiz. Niz̈aza Jerusalén wajtquiz kamñi z̈oñinacami ancha kuzquiz pinsatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jalla nekztanaqui nii rey jiliriqui timplu chawjc jilirinaca, niz̈aza lii tjaajiñi maestrunaca kjawzic̈ha. Ninacz̈quiz pewczic̈ha: —¿Jakziquint Cristuqui majtta cjesaya? —jalla nuz̈ cjican pewczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ninacaqui kjaazic̈ha tuz̈ cjican: —Belén wajtquinc̈ha, Judea yokquin. Tsjii profetaqui cjijrchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Judá yokquinc̈ha Belén watjaqui. Jalla nii watjapanc̈ha chekanaqui, parti watjanacquiztan Judá yokquin. Jalla nekztan tsjii chawc jiliriqui ulnaquic̈ha. Jalla niiqui wejt Israel z̈oñinacaz̈ mantaquic̈ha; niz̈aza cwitaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jalla nekztanaqui Herodes jiliriqui magonaca jamazit kjawzic̈ha. Nekztanaqui zumpacha pewczic̈ha, c̈hjul timpuquiztan nii warawaraqui paristc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jalla nekztanaqui Herodesqui magonaca cuchanchic̈ha Belén watja, jalla tuz̈ cjican: —Nii Belén watja oka, niz̈aza nii wawz̈ puntu zumpacha pjurwiit'aquic̈ha. Wawa watz̈cuqui, wejtquiz mazcaquic̈ha. Wejrmi zakal ojkz pecuc̈ha, wawa rispiti. ");
INSERT INTO capNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jalla nekztan Herodes jiliriz̈ chiiz̈inta taku nonz̈cu, magonacaqui ojkchic̈ha. Jerusalén watja ulantan, nii tuuna cherta warawaraqui ninacz̈ tucquin wilta okatc̈ha. Jakziquin nii wawa z̈elatc̈haja, jalla nii juntuñ tsijtsic̈ha warawaraqui. ");
INSERT INTO capNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nii warawara tsijtsi cherz̈cu, magonacaqui ancha wali cuntintutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nekztanaqui kjuya luzcu, wawa cherchic̈ha Marii maatanpacha. Jalla nekztanaqui ninacaqui quillzic̈ha wawa rispitsjapa. Paaz caja cjetz̈cu, wawz̈quiz zuma cusasanaca onanchic̈ha, kori, insinzu, mirra. Jalla nuz̈ nii wawz̈quiz rispit'ichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jalla nekztanaqui wiiquin Yoozqui magonacz̈quiz chiiz̈inchic̈ha, ana Herodes kjutñi quepajo. Jalla niz̈tiquiztan persun watja quejpchic̈ha yekja jicz kjutñi. ");
INSERT INTO capNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jalla nekztanaqui nii magonacaz̈ ojktan tsjii Yooz Jilirz̈ anjilaqui wiiquin Josez̈quiz parisisquichic̈ha. Nekztan tuz̈ cjichic̈ha: —Z̈aazna, tii wawa chjicha maatanpacha. Egipto yokquin oka, atipasjapa. Herodes jiliriqui tii wawaz̈ kjuraquic̈ha conzjapa. Jalla nii Egipto yokquin am z̈elaquic̈ha, c̈hjulorat wejrqui amquiz wilta chiyac̈haja, jalla niicama. —Jalla nuz̈ wiiquin chiichic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jalla nuz̈ anjilaz̈ chiitiquiztan Josequi nii orapacha z̈aazic̈ha. Nekztan wawz̈tan maatan chjitchic̈ha. Nii weenpacha ulanchic̈ha Egipto yok kjutñi. ");
INSERT INTO capNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Jalla nicju kamchic̈ha Herodes ticzcama. Niiz̈ tuquitanpacha Yooz Jiliriqui profetz̈quiz chiikatchic̈ha, tuz̈ cjican: “Egipto yokquiztan wejt persun Maati kjawznacha”. Jalla nii profetz̈ chiita takuqui cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodesqui kuzquiz tantiyassic̈ha, “Magonacaqui wejttanz̈ burlaskalak” cjican. Jalla niz̈tiquiztan walja z̈awjzic̈ha. Jesucristo majtta timpu tantiichic̈ha magonacaz̈ maztiquiztan. Jalla nuz̈ tantiiz̈cu mantichic̈ha Belén wajtquin niz̈aza nii wajtz̈ tjiyaran tjapa lucmajch wawanaca pizc watquiztan kozzuc conajo. ");
INSERT INTO capNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jalla nuz̈ cumplissic̈ha Jeremías cjita profetz̈ cjijrta takuqui. ");
INSERT INTO capNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tuqui timpuqui Jeremiasqui cjijrchic̈ha, tuz̈ cjican: “Ramá cjita wajtquin wali chawc llaqui z̈elaquic̈ha niz̈aza alto jorz̈tan kaaquic̈ha. Raquel cjitiqui ancha kaaquic̈ha naaz̈a maatinacz̈quiztan. Ana wira kuztami ch'uj cjequic̈ha. Niz̈aza naaz̈a maatinacaqui ticziz̈ cjequic̈ha”. Jalla nuz̈ cjijrchic̈ha Jeremías cjita Yooz taku paljayñi profetaqui. ");
INSERT INTO capNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wiruñaqui Herodes cjita jiliriqui ticzic̈ha. Jalla nekztanaqui tsjii Yooz Jiliriz̈ anjilaqui Josez̈quin wilta parisisquichic̈ha wiiquin. Nii oraqui Josequi Egiptuquin tira z̈elatc̈ha. Anjilaqui cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Z̈aazna, tii am uza chjicha maatanpacha. Israel yoka quepa. Am wawa conz pecñi Herodes jazic ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jalla nuz̈ cjen Josequi z̈aaz̈cu Israel yokquin nii uztan maatan chjitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Israel yokquin Judea provinciquin Arquelao cjita jiliritac̈ha mantiñiqui. Jalla niic̈ha Herodes majchqui. Niiz̈ ejpz̈ puestuquizpacha luzzitac̈ha. Josequi nii quintu zizcu, Judea yokquin kamz jiwjatchic̈ha. Nekztan tsjii anjilaqui wiiquin Josez̈quiz paljaychic̈ha, Judea yokquiz ana kamajo, antiz Galilea yokquin okajo. Jalla nekztan Galilea yok kjutñi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jalla nii yoka irantiz̈cu, Nazaret cjita wajtquiz kamchic̈ha. Tuqui timpuqui Yooz cuntiquiztan chiiñi profetanacaqui mazinchic̈ha, Jesusaqui “nazareno” cjitazakaz cjequic̈ha, jalla nuz̈ cjican mazinchic̈ha. Nazaret wajtquiz kamcan profetanacaz̈ chiita taku cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Niiz̈ wiruñaqui Juan Bautistaqui Judea provinciquin z̈elatc̈ha, ch'ekti yokquin. Yooz taku paljayatc̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","tuz̈ cjican: —Kuznacaz̈ campiya. Arajpach Yoozqui waj mantaquic̈ha. Nii timpuqui z̈catz̈inz̈quic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tuqui timpuqui Isaías cjita profetaqui Juanz̈ puntuquiztan cjijrchic̈ha, tuz̈ cjican: “Ch'ekti yokquin tsjii z̈oñz̈ joraz̈ nonz̈ta cjequic̈ha. Alto jorquiztan tuz̈ cjican chiyaquic̈ha: ‘Tsjii chawjc Jiliriz̈ tjonaquic̈ha. Jaziqui zuma kamañ jicz tjaczna. Tsjii jicztakaz anc̈huca kuznaca zumpacha azquicha, niz̈aza zuma lijitumapanz̈ cjee’”. Jalla nuz̈ cjijrtatac̈ha Juanz̈ puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanz̈ zquitiqui camello cjita animalz̈ chomquiztan watstatac̈ha. Niiz̈ cinturonaqui zkizitac̈ha. Niz̈aza langosta cjita kolta animalanaca lujlñitac̈ha. Munti misq'uinaca lujlñizakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Walja z̈oñinacaqui Juanz̈ taku nonz̈ñi tjonñitac̈ha, Jerusalén chawc wajtquiztan, niz̈aza Judea yokquiztan, niz̈aza Jordán cjita puj z̈catirantan. Walja z̈oñinaca tjonñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jakziltat niiz̈ persun ujnaca mazzaja jalla ninacz̈quiz Juanqui bautissic̈ha Jordán cjita pujquiz. ");
INSERT INTO capNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nii tama z̈oñinacz̈tanpacha walja fariseonacami, niz̈aza saduceonacami jalla nii jilirinacami Juanz̈quin tjonchizakazza bautista cjisjapa. Jalla ninaca cherz̈cu, Juanqui tuz̈ chiiz̈inchic̈ha: —Zkoraz̈takaz incallñi z̈oñinaca. Yooz Ejpqui ujchiz z̈oñinaca wajillaz̈ casticaquic̈ha. ¿Ject anc̈hucaquiz nii mazzejo? ¿Nii casticu atipzjapa wejtquinz̈ tjonkaya? ");
INSERT INTO capNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Kuz campiichinc̈hucz̈laj niiqui, zumapankaz kamaquic̈ha, anc̈huca campiita kuz kjanapacha tjeezjapa. ");
INSERT INTO capNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Anc̈hucqui anaz̈ mit kuzziz porapat chiyasaquic̈ha, tuz̈ cjican: “Wejrnacqui Abrahamz̈ majchmaatinacz̈quiztanpacha tjoniñc̈ha, Yoozqui anaz̈ wejrnaca casticasac̈ha”. Jalla niz̈ta ana chiichiiz waquisic̈ha. Yoozqui tii maznacquiztan z̈oñiz̈ cjiskatasac̈ha, Abrahamz̈ majchmaatinaca cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anc̈hucqui tsjii frut muntiz̈takazza. Ana zuma fruta pookñi muntiqui k'aatztaz̈ cjequic̈ha jir achz̈tan. Jalla nuz̈ k'aatztiquiztanaqui, ujtaz̈ cjequic̈ha. Jalla niz̈ta irataz̈ anc̈hucaquiz wataquic̈ha. Ana zuma kamañchiz z̈oñinaca casticta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wejrqui weraral chiyuc̈ha. Kjaztankal bautisuc̈ha, anc̈huca kuznaca campiitiquiztan. Tsjiiqui wejt wirquin tjonc̈ha. Jalla niiqui Espíritu Santuz̈tanami niz̈aza arajpach ujz̈tanami bautisaquic̈ha. Jalla niic̈ha wejtquiztan tsjan juc'ant poderchizqui. Niiz̈quiz atintisjapa anal waquisuc̈ha, niiz̈ c̈hjata jerz̈cu chjojkzinimi. Inakaztc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Anc̈hucqui trigo zkalaz̈takazza. Nii tjoñi jiliriqui trigonaca kjojaquic̈ha. Nekztan itzanacami zuma trigumi pjalznaquic̈ha. Nii zuma triguqui ricujtaz̈ cjequic̈ha. Niiz̈ persun kjuyquin majctaz̈ cjequic̈ha. Nii itzanacazti liwj ujtaz̈ cjequic̈ha, ana wira tjesñi ujquiz. Jalla niz̈ta irataz̈ anc̈hucaquiz wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Niiz̈ wiruñaqui Jesusaqui Galilea yokquiztan Jordán cjita pujquin ojkchic̈ha, jakziquint Juan z̈elatc̈haja, jalla nicju. Bautiskatzjapa Juanz̈quin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jesusiz̈ irantitan, Juanqui ana nii bautis pecatc̈ha. Jalla tuz̈ cjichic̈ha: —Amz̈ wejr bautis waquizic̈ha. ¿Am wejtquiz tjonkaya? ¿Weriz̈ bautista cjisjapaya? —Jalla nuz̈ cjichic̈ha Juanqui. ");
INSERT INTO capNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anzikam wejr bautisaquic̈ha. Yooz mantitacama liwj cumplis waquizic̈ha uc̈humqui. —Jalla nuz̈ kjaaztiquiztan Juanqui “iyaw” cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Nekztanaqui Juanqui Jesusa bautissic̈ha. Kjazquiztan ulnan, nii orapacha arajpacha cjetzic̈ha. Nekztan Jesusaqui cherzic̈ha Yooz Espíritu Santo palomaz̈takaz chjijwz̈quiñi. Jalla niiz̈ juntuñpacha Espíritu Santuqui irantiz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Nekztanaqui arajpachquiztan tsjii jora paljayz̈quiñi nonzic̈ha, jalla tuz̈ cjiñi: —Tiic̈ha wejt ultim k'ayi Maatiqui. Tiiz̈ cjen ancha cuntintutc̈ha wejrqui. —Jalla nuz̈ cjichic̈ha nii tsewctan chiiz̈quiñi joraqui. ");
INSERT INTO capNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jalla nekztanaqui Jesusaqui Jordán cjita pujquiztan ojkchic̈ha. Nuz̈ okan, Espíritu Santuqui Jesusa chjitchic̈ha ch'ekti yokquin, Satanás diabluz̈ yanz̈ta cjisjapa. Satanasqui Jesusa ujquiz tjojtskatz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jalla nijwc z̈ejlcan, Jesusaqui pusi tunc tjuñi pusi tunc arama ana c̈hjeri lujlchic̈ha. Jalla nii pusi tunc tjuñi wattiquiztan ancha c̈hjeri eecskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jalla nekztanaqui diabluqui Jesusiz̈quiz macjatchic̈ha ujquiz tjojtskatz yanzjapa. Jalla tuz̈ cjichic̈ha: —Amqui ultim Yooz Maatimz̈laj niiqui, tii maznacquiztan t'anta tuckatalla. ");
INSERT INTO capNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Z̈oñinacaqui anaz̈ c̈hjerz̈tan alaja z̈etasac̈ha. Yooz takuc̈ha chekanaqui, jalla niic̈ha ultim c̈hjeriz̈takazqui”. Jalla nuz̈ kjaazic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jalla nekztanaqui diabluqui Jesusa chjitchic̈ha Jerusalén, Yooz illzta chawjc watja. Jalla nicju timplu tsewcta pjurniguin yawkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nekztan diabluqui cjichic̈ha: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Yooz Ejpqui niiz̈ anjilanaca mantaquic̈ha am cwitajo. Ninacz̈ persun kjarz̈tan am cwitaquic̈ha, ana am kjojcha chjojric̈hta cjeyajo mazquizimi”. Jazic, ultim Yooz Maatimz̈laj niiqui, tsewctan kozzuc tii yokquiz layzca. —Jalla nuz̈ cjichic̈ha nii diabluqui. ");
INSERT INTO capNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Nekztanaqui Jesusaqui kjaazic̈ha tuz̈ cjican: —Cjijrta Yooz takuqui zakaz cjic̈ha: “Z̈oñiqui ultim arajpach Yooz ana inakaz nuz̈ yanznaquic̈ha”. Jalla nuz̈ cjijrtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jalla nekztanaqui wilta ujquiz tjojtskatz yanzjapa, diabluqui Jesusa chjitchic̈ha pajk cur puntiquin. Jalla niwjc chjitz̈cu, diabluqui tjapa tii muntuquiz z̈ejlñi nacionanaca niz̈aza tjapa ninacz̈ cusasanacz̈tanpacha, niz̈aza tjapa ninacz̈ honoranacz̈tanpacha jalla ninaca diabluqui Jesusiz̈quiz tjeezic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Nekztan nii diabluqui cjichic̈ha: —Tjapa tinaca amquiz tjaasac̈ha, wejtquizim quillzaja, niz̈aza wejr rispitc̈haja, niiqui. ");
INSERT INTO capNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jalla niz̈tiquiztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Satanás, wejtquiztan zaraka amqui. Cjijrta Yooz takuqui tuz̈ cjic̈ha: Yooz Jilirz̈quinkaz rispita, niz̈aza nii alaja sirwa. Niikazza am Yooz Jiliriqui. ");
INSERT INTO capNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jalla nuz̈ Jesusiz̈ chiitiquiztan diabluqui Jesusiz̈quiztan zarakchic̈ha. Nekztan tsjii kjaz̈ anjilanacaqui Jesusiz̈quin atinti tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Niiz̈ wiruñaqui Jesusaqui quintu nonchic̈ha, Juan carsilquiztac̈ha, jalla nii. Jalla nii quintu nonz̈cu, Galilea yokquin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero Nazaret wajtquin ana kamchic̈ha; antis Capernaum wajtquin kami ojkchic̈ha. Capernaum watjaqui kot atquiztac̈ha, Zabulón yokquin niz̈aza Neftalí yokquintac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jalla nuz̈ ojktiquiztan Isaías profetaz̈ cjijrta taku cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Jalla tuz̈ cjijrchic̈ha Isaías profetaqui: “Zabulón, niz̈aza Neftalí, am yokaqui kot atquizza, niz̈aza jiczquizza Jordanquiztan tuwanchuc. Niz̈aza Galilea yokquinc̈ha. Jalla nii Galiliiquinaqui yekja wajtchiz z̈oñinacaz̈ kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Am yokquin z̈ejlñi z̈oñinacaqui zumchiquiz kamc̈ha, ana zuma kamañquiz. Ninacaqui tsjii z̈oñi cheraquic̈ha. Nii z̈oñiqui zuma kamaña tjeeznaquic̈ha, zuma kjanaz̈takaz. Ticzi z̈oñinacaz̈takaz kamc̈ha; anaz̈ Yooz kamaña zizza. Pero kjanapachaz̈ Yooz zuma kamaña tjeezta cjequic̈ha.” ");
INSERT INTO capNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jalla nekztanaqui Jesusaqui Yooz puntu kjanzt'i kallantichic̈ha, tuz̈ cjican: —Kuznaca campiya. Arajpach Yooz waj mantaquic̈ha. Jalla nii timpuqui z̈catz̈inz̈quic̈ha. —Jalla nuz̈ paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesusaqui Galilea cjita kot at tjiyaranz̈ okatc̈ha. Jalla nuz̈ ojkcan pucultan jilazullca z̈oñinaca cherchic̈ha. Tsjiiqui Simón cjitatac̈ha, niz̈aza Pedro cjitazakaztac̈ha. Tsjiiqui Andrés cjitatac̈ha. Jalla ninacaqui ch'iz tanñinacatac̈ha. Nii oraqui ninacaqui ch'iz tanz kjazquiz tjojtsi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jalla ninacz̈quiz Jesusaqui tuz̈ cjican paljaychic̈ha: —Wejttan chica ojklayñi cjee. Jaknuz̈ ch'iz juntichamz̈laja, jalla niz̈ta irata anc̈hucqui Yooztajapa z̈oñinaca juntaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jalla nuz̈ chiitiquiztan nii pucultan z̈oñinacaqui nii orapacha ch'iz tanz eccu, Jesusiz̈tan chica ojklaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jalla nekztanaqui tsjii koloculla najwcjapa ojkz̈cu Jesusaqui tsjii pucultan jilazullca z̈oñinaca cherchizakazza. Tsjiiqui Jacobo cjitatac̈ha. Tsjiiqui Juan cjitatac̈ha. Zebedeoz̈ majchtac̈ha. Niiz̈ ejpz̈tanpacha warcuquiz z̈elatc̈ha, ch'iz tanz azquichcan. Jalla nii cherz̈cu, Jesusaqui ninaca kjawzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Nekztan nii orapacha warcumi niiz̈ ejpmi eccu, Jesusiz̈tan chica ojklaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tjapa nii Galilea cjita yokaran ojklaychic̈ha, zapa ajcz kjuyquiz Yooz puntu tjaajincan. Niz̈aza paljaychic̈ha, Yooziz̈ mantita z̈oñinacaz̈ cjee, cjican. Niz̈aza tjapaman laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesusiz̈ ojklayta, jalla nii quintuqui tjapa Siria yokquin ojkchic̈ha. Jalla niz̈tiquiztan, tjapaman conchiz z̈oñinacami, niz̈aza tjapaman laa ayiñi z̈oñinacami, niz̈aza zajraz̈ tanta z̈oñinacami, niz̈aza t'ucur z̈oñinacami, niz̈aza ana ojklayi atñi zuch z̈oñinacami, tjapaman laanaca Jesusiz̈quin chjitz̈tatac̈ha. Nekztanaqui Jesusaqui nii laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilea z̈oñinacaqui niiz̈quin walja apz̈quichic̈ha, niz̈aza Decápolis watjanacquiztan z̈oñinacami, niz̈aza Jerusalén wajtquiztan z̈oñinacami, niz̈aza Judea yokanacquiztan z̈oñinacami, niz̈aza Jordán pujz̈ tuwanchuctan z̈oñinacami. Tjapa nii z̈oñinacami jalla nuz̈ Jesusa apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Walja tama z̈oñinaca cherz̈cu, Jesusaqui tsjii kolta curulla yawchic̈ha. Jalla nekztan nii curullquin julzic̈ha. Niz̈aza niiz̈ kjawz̈ta z̈oñinacaqui niiz̈ muytata ajczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jalla nekztan Jesusaqui ninacz̈quiz tjaajñi kallantichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Jecnacat “wejrqui ujchizpanc̈ha” cjican persun kuzquiz sint'ic̈haja, jalla ninacaz̈ Yooz wajtchiz z̈oñinaca cjequic̈ha. Nekztanqui cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‛Jecnacat persun ujquiztan llaquita z̈ejlc̈haja, jalla ninacz̈quiz Yoozqui kuznaquic̈ha. Nekztan cuntintuz̈ cjequic̈ha ninacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‛Jecnacat humilde kuzziz cjec̈haja, jalla ninacz̈quiz Yoozqui irinsaz̈ tjaaquic̈ha, ew yoka. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jecnacat Yooz kuzcamakaz kamz ancha pecc̈haja, jalla ninacz̈quiz Yoozpanz̈ zuma kamzjapa yanapaquic̈ha. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‛Jecnacat parti z̈oñinacz̈tajapa oksñi kuzziz cjec̈haja, jalla ninaczquiz Yoozqui zakaz oksnaquic̈ha. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‛Jecnacat ancha zuma kuzziz cjec̈haja, jalla ninacaqui Yooz cheraquic̈ha. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‛Jecnacat pasinsis kuzziz kamñi cjec̈haja, jalla ninacaqui Yooz maati cjitaz̈ cjequic̈ha. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jecnacat Yooz kuzcama kamtiquiztan chjaawjta sufrac̈haja, jalla ninacaz̈ Yooz wajtchiz z̈oñinaca cjequic̈ha. Nekztan cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Jecnacat weriz̈ cjen z̈oñinacaz̈ chjaawjta cjec̈haja, niz̈aza kijchta cjec̈haja, niz̈aza tjapaman toscar tawkz̈tan quintra ch'aanita cjec̈haja, jalla ninacami cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jecnacat weriz̈ cjen jalla niz̈tanaca sufrichi cjec̈haja, jalla ninacz̈quiz Yoozqui arajpachquin wali pajk honora tjaaquic̈ha. Jalla niz̈tiquiztan tii muntuquiz kamcan, cuntintukaz̈ cjee. Anc̈hucqui cjuñzna. Yooz cuntiquiztan chiiñi profetanacaqui niz̈ta zakaz sufrichic̈ha tuqui timpuquiztanpacha. ");
INSERT INTO capNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesusaqui tjaajinchizakazza: —Anc̈hucqui tii muntuquiz kamcan yacu cuntaz̈takazza, parti z̈oñinacz̈tajapa. Pero yacuqui lak'az̈ cjesaz̈ niiqui, ¿kjaz̈pant wilta walipan cjisnasajo? Anapanz̈ cjesac̈ha. Nekztan anaz̈ c̈hjuljapami sirwasac̈ha; tjojttapanz̈ cjesac̈ha; nekztan z̈oñinacaz̈ tjecz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‛Anc̈hucqui tii muntuquiz kamcan, parti z̈oñinacz̈tajapa kjana cuntaz̈takaz cjesac̈ha, zuma kamaña zizajo. Tsjii curquiz kjuyta watjaqui, ana chjojz̈ta cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tsjii lamparaqui tjeez̈taz̈ cjec̈haj niiqui, anapanz̈ cajón koztan nonz̈ta cjesac̈ha. Lamparaqui tjeeztaz̈ cjec̈haj niiqui, tsewc tsjijptapanz̈ cjesac̈ha, tjapa nii kjuyquiz z̈ejlñi z̈oñinacz̈tajapa kjanajo. ");
INSERT INTO capNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jalla nuz̈ anc̈hucqui lamparaz̈takaz cjee, z̈oñinacz̈tajapaqui. Kjanapacha zuma kamañchiz cjee. Nekztan z̈oñinacaqui anc̈huca zuma kamaña cherz̈cu, anc̈huca arajpach Yooz Ejpz̈quin honora tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesusaqui tjaajinchizakazza: —Wejrqui ana tjonchinc̈ha Moisés lii tjatanskatzjapa, niz̈aza profetanacaz̈ tjaajintanaca tjatanskatzjapami. Jalla niz̈ta anaz̈ pinsa anc̈hucqui. Wejrqui ana tjonchinc̈ha nii tuquita Yooz tjaajintanaca tjatñiqui; antis tjonchinc̈ha cumpliskatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Weraral chiiz̈inuc̈ha. Tuquita Yooziz̈ tjaata liiquiztan tjapa puntumi tjapa letrami anaz̈ tjatanta cjequic̈ha, tjappacha cumpliscama. Ima tii muntumi arajpachami tucuz̈inz̈nan, nii liiqui anapanz̈ tjatantaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Jalla niz̈tiquiztan jequit tuquita Yooziz̈ tjaata liiquiztan tsjii mantita, kolta lii cjenami, ana pajz pecc̈haj niiqui, niz̈aza yekjap z̈oñinacz̈quiz niz̈tapacha tjaajinc̈haja, jalla nii z̈oñiqui arajpach Yooz wajtquin anaz̈ c̈hjul honorchiz cjequic̈ha. Pero jequit nii tuquita lii mantita cazac̈haja, niz̈aza yekjap z̈oñinacz̈quiz niz̈tapacha tjaajinc̈haja, jalla nii z̈oñiqui arajpach Yooz wajtquin chekan honorchiz z̈oñiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Anc̈hucaquiz wejr chiiz̈inuc̈ha. Lii tjaajiñi maestrunacami, niz̈aza fariseo z̈oñinacami z̈ejlc̈ha. Pero anc̈hucqui ninacz̈quiztan anaz̈ juc'anti Yooz mantitacama kamac̈haj niiqui, anapanz̈ arajpach Yooz wajtquin luzasac̈ha. Yooz mantitacama kamstanc̈ha, arajpach Yooz wajtquin luzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesusaqui tjaajinchizakazza: —Anc̈hucqui tuquita atchi ejpnacz̈quiztan tuz̈ nonzinc̈hucc̈ha. Ninacaqui cjiñitac̈ha, tuz̈ cjican: “Anac̈ha z̈oñi conzqui. Jequit z̈oñi conac̈haja, niiqui juzjitaz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero wejr chiiz̈inuc̈ha, jequit tsjii jilz̈japa z̈awjwac̈haj niiqui, jusjitaz̈ cjequic̈ha. Niz̈aza jequit tsjii jilz̈tan ch'aac̈haj niiqui, Junta Suprema cjita chawjc jilirinacaz̈ jusjitaz̈ cjequic̈ha. Niz̈aza jequit tsjii jilz̈quiz “ana zumamc̈ha” cjican ch'aanc̈haj niiqui, infiernuquin chjatkattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Niz̈aza tii puntu zakal cjeec̈ha. Jequit niiz̈ ofrenda Yooz yujcquin chjichac̈haj niiqui, niz̈aza chjichcu niiz̈ jilz̈tan quintra tanasta cjuñsnac̈haj niiqui, ");
INSERT INTO capNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jalla nekztan ima ofrenda tjaacan, nii timpluquizpacha ecla. Nekztanaqui niiz̈ jilz̈quin pertuna mayiza ojkla. Niiz̈tan jilz̈tan walikaz cjila. Jalla nekztanaqui timpluquin quejpz̈cu, ofrenda Yoozquin tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‛Jequit am quintra quijchi cjec̈haj niiqui, niz̈aza jilirz̈ kjuya chjichac̈haj niiqui, jalla nii quijchi z̈oñz̈quiz pertunam mayizaquic̈ha ana enenzcu, ima jilirz̈ kjuya irantican. Pertunazta cjequiz̈ niiqui, anam juez jilirz̈quin intirjita cjequic̈ha jusjita cjisjapa. Amqui ultimpacha juez jilirz̈quin intirjita cjesaz̈ niiqui, nii juez jiliriqui am tsjii policiiquin zakaz intirjasac̈ha; carsilquiz chawjcta cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Weraral chiiz̈inuc̈ha. Carsilquiz chawjctam cjesaz̈ niiqui, anam ulanasac̈ha, liwj pacañcama. ");
INSERT INTO capNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesusaqui tjaajinchizakazza: —Anc̈hucqui tuquita atchi ejpnacz̈quiztan tuz̈ nonzinc̈hucc̈ha: “Anac̈ha adulteriuquiz ojklayzqui”. ");
INSERT INTO capNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero wejrqui tuz̈ chiiz̈inuc̈ha, jakzilta luctakat yekja maataka “wejt maatakaj cjejaa” cjican pinsic̈haja, jalla niiqui persun kuzquiz niwjctanaqui adulterio paachizakazza Yooz yujcquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Am z̈ew latu c̈hjujquiqui ujquiz tjojtskatc̈haj niiqui, nii c̈hjujqui leczna, niz̈aza nawjk tjojtta. Jalla nuz̈ tsjii c̈hjujquiqui pertissi cjenaqui am parti curpuqui ana infiernuquin tjojtta cjesac̈ha. Jalla nuz̈ waliz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Niz̈aza am z̈ew kjaraqui ujquiz tjojtskatc̈haj niiqui, nii kjara pootzna, niz̈aza nawjk tjojtta. Jalla nuz̈ tsjii kjaraqui pertissi cjenaqui am parti curpuqui ana infiernuquin tjojtta cjesac̈ha. Jalla nuz̈ waliz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesusaqui tjaajinchizakazza: —Anc̈huca tuquita atchi ejpnacaqui tuz̈ cjiñitac̈ha: “Jecmiz̈ niiz̈ persun tjunatan jaljtasaz̈ niiqui, primiruqui tsjii ultim jaljtita cjijrta papel certificado tjaasa”. ");
INSERT INTO capNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero wejrqui tuz̈ chiiz̈inuc̈ha, jakziltamiz̈ persun tjunatan jaljtasaz̈ niiqui, niz̈aza ana c̈hjul adulterio motivo z̈elan, jalla nijwctanaqui naa ultimu jaljtita tjunqui adulterio cjiskatasac̈ha. Niz̈aza jakziltami naa ultimu jaljtita tjunatan zalznac̈haj niiqui, adulterio ujpanz̈ paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesusaqui tjaajinchizakazza: —Niz̈aza anc̈hucqui tuquita atchi ejpnacz̈quiztan tuz̈ nonzinc̈hucc̈ha: “Anac̈ha toscar tawkz̈tan juramento paazqui. Juramento paaquiz̈ niiqui, tjapa nii juramentuz̈tan compromitta takupanz̈ cumplisnaquic̈ha Yooz yujcquiziqui”. ");
INSERT INTO capNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero wejrqui tuz̈ chiiz̈inuc̈ha, anaz̈ c̈hjulquiztanami juramento paasac̈ha, werara chiizpanc̈ha. Niz̈aza anac̈ha “arajpacha zizza” cjican juramento paazqui. Yooztajapac̈ha arajpachaqui. ");
INSERT INTO capNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Niz̈aza anac̈ha “tii yoka zizza” cjican juramento paazqui. Yooztajapac̈ha tii yokaqui. Niz̈aza Jerusalén wajtz̈ tjuu aynakcan anac̈ha juramento paazqui. Chawjc Yooz Jilirz̈tajapac̈ha nii watjaqui. ");
INSERT INTO capNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Niz̈aza anac̈ha “wejt persun acha zizza” cjican juramento paazqui. Amqui anam zinta tsok charquiztan chiw charquin tuckatasac̈ha. Niz̈aza anam zinta chiw charquiztan tsok charquin tuckatasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jalla niz̈tiquiztan, “Jesalla” cjicanaqui, “Jesalla” cjispanc̈ha; niz̈aza “Anaz̈” cjicanaqui, “Anaz̈” cjispanc̈ha. Zajra diabluz̈ cjen juramento paazqui z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesusaqui tjaajinchizakazza: —Anc̈hucqui tuquita atchi ejpnacz̈quiztan tuz̈ nonzinc̈hucc̈ha: “Tsjii z̈oñiqui yekja z̈oñz̈ c̈hjujqui pjatz̈inasac̈ha, nekztan nii pjatñi z̈oñz̈ c̈hjujqui pjatz̈intazakaz cjesac̈ha. Niz̈aza tsjii iz̈ke chjatkatz̈inasaz̈ niiqui, nii chjatkatñi z̈oñz̈ iz̈ke chjatkatz̈intazakaz cjesac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero wejr chiiz̈inuc̈ha, anac̈ha kijtzñi z̈oñiqui niz̈tapacha kijtzqui. Niz̈aza am quintra tsjii yujc latu kijchasaz̈ niiqui, kijchta cjiskazza, tsjii yujc latuz̈tanpachami. ");
INSERT INTO capNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Niz̈aza jakziltamiz̈ am tanz̈cu am almilla kjanz pecc̈haj niiqui, kjañaj cjiskazza, irztanpachami. ");
INSERT INTO capNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jakziltamiz̈ niiz̈ kuzi tsjii tupucama, amquiz chjitskatasaz̈ niiqui, juc'anti tupucama chjichna. ");
INSERT INTO capNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jakziltamiz̈ amquiztan mayasaz̈ niiqui, tjaa amqui. Niz̈aza jakziltamiz̈ amquiztan tomzñi tjonasaz̈ niiqui, onzna amqui. ");
INSERT INTO capNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesusaqui tjaajinchizakazza: —Niz̈aza anc̈hucqui tuquita atchi ejpnacz̈quiztan tuz̈ nonzinc̈hucc̈ha: “Mazinacz̈tan zuma munaziza. Niz̈aza am quintra z̈oñinacz̈tan chjaawjkata”. ");
INSERT INTO capNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero wejr chiiz̈inuc̈ha, am quintra z̈oñinacz̈tanami zuma munaziza. Niz̈aza am quintra laykiñi z̈oñinacz̈tajapa zuma kuztan Yoozquiztan maynaquic̈ha. Niz̈aza am quintra chjaawjkatñi z̈oñinacz̈quin zumapan paa. Niz̈aza am quintra ch'aañinacz̈quinami kichñinacz̈quinami zumapan Yoozquiztan mayt'iz̈ina. ");
INSERT INTO capNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Jalla nuz̈ zuma kamcan anc̈hucqui tjeez̈a, arajpach Yooz Ejpz̈ maatic̈hucc̈ha, nii. Yoozqui zuma z̈oñinacz̈quizimi ana zuma z̈oñinacz̈quizimi liwj tsjiikaz niiz̈ paata tjuñi tewkkatc̈ha. Niz̈aza niiz̈ kuzcama kamñinacz̈quizimi niz̈aza ana niiz̈ kuzcama kamñinacz̈quizimi tjapa ninacz̈quiz chijñi apayz̈quic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Anc̈hucqui persun okzñi z̈oñinacz̈quizkaz okznaquiz̈ niiqui, jalla nuz̈ paatiquiztan ¿c̈hjul premio Yoozquiztan tanznaquejo? Jalla niz̈tazakaz kamc̈ha ana wali impuesto cobriñinacami. ");
INSERT INTO capNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Niz̈aza anc̈hucqui persun jilanacz̈quizkaz tsaanaquiz̈ niiqui, jalla nijwctan ¿c̈hjul zumaz̈ anc̈huc paajo? Jalla niz̈tazakaz paac̈ha ana Yooz pajñinacami. ");
INSERT INTO capNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Anc̈hucqui walja zuma kuzziz kama, jaknuz̈t anc̈huc arajpach Yooz Ejp walja zuma kuzzizpanc̈halaja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesusaqui tjaajinchizakazza: —Anc̈hucqui anac̈ha persunpacha honorchizkaz cjis peczqui. Anac̈ha z̈oñinacz̈ yujcquiz anc̈huca Yooz custurumpinaca paazqui, z̈oñinacz̈quiztan honorchiz cjisjapa. Anc̈hucz̈ jalla nuz̈ persun honorchizkaz cjis pecaquiz̈ niiqui, nii honorchiz kaz cjequic̈ha. Anc̈huca arajpach Yooz Ejpqui ana iya honora tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ana zum kuzziz z̈oñinacaqui t'akjir z̈oñinacz̈quiz onanz̈cu z̈oñi z̈oñinacz̈quin mazmazñic̈ha, “onanchinc̈ha” nuz̈ cjicanaqui. Ajcz kjuyaranami calliranami jalla niz̈ta paañic̈ha, z̈oñinacaz̈ ninacz̈japa zuma chiyajo. Pero wejrqui weraral chiiz̈inuc̈ha. Jalla niz̈ta paañi z̈oñinacaqui nii honorchizkaz cjequic̈ha. Anc̈hucqui anac̈ha niz̈ta iratapacha kama. ");
INSERT INTO capNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Anc̈huczti t'akjir z̈oñinacz̈quiz onanz̈cu, jalla nii anc̈huca onantaqui anaz̈ jecz̈quizimi mazmaznaquic̈ha, “onanchinc̈ha”, cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Niz̈aza t'akjir z̈oñinacz̈quiz jamazit onaquic̈ha. Aunquimi anc̈hucaz̈ jamazit paachiz̈ cjenami, anc̈huca Yooz Ejpqui cherc̈ha. Jalla nuz̈ cherz̈cu anc̈hucaquiz kjanacama honora tjaaquic̈ha, tsjii premiuz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Niz̈aza nii ana zum kuzziz z̈oñinacaqui Yoozquin mayizican jalla tuz̈ juztazñic̈ha. Ajcz kjuyquizimi call isquinquizimi tsijtchi Yoozquin mayiziñic̈ha, tjapa z̈oñinaca cherajo. Wejrqui weraral chiiz̈inuc̈ha, jalla nuz̈ paaz̈cu ninacaqui nii honorchizkaz cjequic̈ha. Anc̈hucqui anac̈ha niz̈ta irata mayizizqui. ");
INSERT INTO capNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anc̈huczti Yooz Ejpz̈quin mayizizjapaqui, kjuyquiz luz waquizic̈ha, niz̈aza kjuy chawjcz waquizic̈ha. Jalla nekztan anc̈huca Yooz Ejpz̈quin mayizasac̈ha. Jalla nuz̈ zinalla mayizan anc̈hucatan chicaz̈ cjequic̈ha Yooz Ejpqui. Jalla nuz̈ jamazit mayiztiquiztan Yooz Ejpqui anc̈hucaquiz honora tjaaquic̈ha, tsjii premiuz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yoozquin mayizcan, anac̈ha wiltan wiltan takunaca quejpz̈cu quejpz̈cu mayizizaqui. Jalla nuz̈ mayizaquiz̈ niiqui, inapanikazza. Jalla niz̈taz̈ mayizza ana Yooz pajñi z̈oñinacaqui. Jalla nuz̈ wacchi chiican mayizitiquiztan “nonznaqueeka Yoozqui” cjican. ");
INSERT INTO capNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jalla niz̈ta anaz̈ anc̈huc cjeella. Anc̈huca Yooz Ejpqui zizza, c̈hjulut anc̈huc pecc̈haja, jalla nii. Ima anc̈hucaz̈ mayizan, panz̈ zizza Yooz Ejpqui. ");
INSERT INTO capNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Jaziqui anc̈hucqui jalla tuz̈ mayizaquic̈ha: “Yooz Tata, amqui arajpachquin z̈ejlc̈ha. Am tjuu honorchiz aptitaj cjilalla. ");
INSERT INTO capNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Niz̈aza am mantiz timpu tjonchej cjilalla. Niz̈aza tii muntuquiz z̈ejlñi z̈oñinacaqui am kuzcamaj kamlalla. Jaknuz̈t am kuzcama kamc̈haja arajpachquin z̈ejlñinaca, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Niz̈aza tonjiqui c̈hjeri tjaaz̈calla c̈hjerz̈tan kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Niz̈aza wejtnacaz̈ paata ujnaca pertunalla, jaknuz̈t wejrnacqui wejtnaca quintra paañi pertunuc̈haja, jalla niz̈aza. ");
INSERT INTO capNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Niz̈aza anaz̈ anawalinacz̈quiz tjojtskatalla, antis anawalinacquiztanz̈ liwriyalla. Amc̈ha wiñaya juc'ant mantiñamqui, niz̈aza amc̈ha wiñaya juc'ant azzizqui, niz̈aza amc̈ha wiñaya juc'ant honorchizqui. Jalla nuz̈oj cjila. Amén.” ");
INSERT INTO capNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‛Anc̈huca quintra paañinacz̈quiz pertunaquic̈ha. Nekztan Yooz Ejp zakaz anc̈huca ujnaca pertunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Anc̈huca quintra paañinacz̈quiz ana pertunaquiz̈ niiqui, nekztan ana zakaz Yooz Ejpqui anc̈huca ujnaca pertunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","—Anc̈hucqui ayunascan anaz̈ llaquit chercherchiz cjee. Ana zum kuzziz z̈oñinacaqui llaquit chercherchiz ayunasñic̈ha, z̈oñinaca ninaca ayunasñi cherajo. Wejrqui weraral chiiz̈inuc̈ha, jalla nuz̈ paatiquiztan ninacaqui inapanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Anc̈huczti ayunascanaqui zumpacha yujcmiz̈ awjzna, niz̈aza zumpacha achami c̈hjijczna, ");
INSERT INTO capNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","z̈oñinaca anc̈huc ayunasñi ana nayajo. Yooz Ejpqui ana cherta cjenaqui tjappacha cherc̈ha, jamazit paatami. Yooz Ejpqui anc̈hucaquiz zuma honoraz̈ tjaaquic̈ha, tsjii premiuz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesusaqui tjaajinchizakazza: —Tii muntuquiz kamcanaqui anac̈ha muzpa cusasanaca juntizqui. Kjurinacakaz anc̈huca juntita cusasanaca lulaquic̈ha. Niz̈aza parti anc̈huca juntita cusasanaca inapankaz chjijtaquic̈ha. Niz̈aza tjañiqui kjuyaz̈ luzasac̈ha, anc̈huca cusasanaca tjangzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Nonz̈na, arajpachquin muzpa cusasanaca juntaquic̈ha. Arajpachquin cusasanaca lujlñimi, niz̈aza cusasanaca akziñimi, niz̈aza cusasanaca tjangziñimi ana z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Jakziquizt anc̈huca cusasanaca juntita z̈ejlc̈haja, jalla nicjukaz̈ anc̈huc kuz tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jesusaqui tjaajinchizakazza: —Z̈oñz̈ c̈hjujquiqui persun curpuz̈ lamparaz̈takazza. Jaziqui z̈oñz̈ c̈hjujqui zuma cjequiz̈ niiqui, zuma cheraquic̈ha. Jalla niz̈tazakaz z̈oñz̈ kuzqui zuma cjequiz̈ niiqui, zuma kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Z̈oñz̈ c̈hjujquizti ana zuma cjequiz̈ niiqui, zumchiquiztakaz ojklayaquic̈ha. Anc̈huca kamaña zumchiquiz panz̈ cjequiz̈ niiqui, juc'anti juc'anti zumchiquiz cjisnaquic̈ha. Nekztan ¿jaknuz̈t zuma kamasajo? ");
INSERT INTO capNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesusaqui tjaajinchizakazza: —Anaz̈ jakziltami pizc patruna sirwasac̈ha. Pizc patrunchiz cjesaz̈ niiqui, tsjii patrunz̈quiz ana pectaz̈ cjesac̈ha. Tsjii patrunz̈quiz pectaz̈ cjesac̈ha. Tsjii patrunz̈quizkaz zuma sirwasac̈ha. Jalla niz̈tiquiztan Yoozquiz sirwican anaz̈ ancha paazquiz kuz tjaasac̈ha. Niz̈aza paazquiz kuz tjaaquiz̈ niiqui, anaz̈ Yoozquin ancha kuzziz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesusaqui tjaajinchizakazza: —Anc̈hucaquiz tuz̈ chiiz̈inuc̈ha, z̈ejtzjapaqui kjaz liczmi lujlz c̈hjerimi pecc̈ha. Jalla nuz̈ cjenami anc̈hucqui anac̈ha kuzquizic c̈hjerquiztan llaquita cjisqui. Niz̈aza curpu wali cjisjapa zquiti pecc̈ha. Jalla nuz̈ cjenami anc̈hucqui anac̈ha zquitquiztan llaquita cjisqui. C̈hjul c̈hjerquiztanami z̈oñz̈ z̈etiz̈ juc'anti importic̈ha. Niz̈aza c̈hjul zquitquiztanami persun curpuz̈ juc'anti importic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Laylayñi wez̈lanacaz̈ cherzna. Jalla nii wez̈lanacaqui ana zkalami c̈hjacc̈ha, niz̈aza ana zkalquiztanami ricujc̈ha, niz̈aza ana c̈hjeri yaaz zquitchizza. Jalla nuz̈ cjenami anc̈huca arajpach Yooz Ejpqui wez̈lanacz̈quiz c̈hjeri tjaac̈ha. Yooz yujcquiziqui anc̈hucqui c̈hjul wez̈lanacquiztanami juc'antiz̈ importic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Anaz̈ jec kolta z̈oñimi persunpacha tsjan lajcha paki atasacna, llaquiziñi kuzziz cjenami ancha lajcha pecñi kuzziz cjenami. ");
INSERT INTO capNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‛¿Kjaz̈tiquiztan anc̈hucqui zquitquiztankaz llaquit kuzziz cjesajo? Plantanacz̈ pjajkjallaz̈ cherzna, jaknuz̈t pajkc̈haja, jalla nii. Ninacaqui anaz̈ langza, niz̈aza anaz̈ kawanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jalla nuz̈ cjenami nii pjajkjallanacaqui ancha c'achjallac̈ha. Finu zquiti cujtz̈cumi ricachu Salomón cjita jiliriqui anaz̈ juc'ant c'achja nii pjajkjallanacz̈quiztanami. ");
INSERT INTO capNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Plantanacaqui tsjii upacamakaz z̈ejlc̈ha. Nekztanaqui jakataz̈u kattaz̈u jurnuquiz tjutjunzjapa ujz̈tac̈ha. Jalla niz̈ta cjenami Yooz Ejppacha nii plantanaca cwitic̈ha. Anc̈hucqui c̈hjul plantaquiztanami juc'antipanz̈ importic̈ha. Jalla niz̈tiquiztan Yoozqui anc̈huc juc'ant cwitic̈ha, Yoozquin ana tjapa kuzziz cjenami. ");
INSERT INTO capNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Jalla niz̈tiquiztan anc̈hucqui anac̈ha llaquita kuzziz cjisqui, c̈hjul c̈hjerquiztanami, niz̈aza kjaz liczquiztanami, niz̈aza c̈hjul zquitquiztanami. ");
INSERT INTO capNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ana criichi z̈oñinacaqui tii muntu cucasanacz̈quin kuzziz ojklayc̈ha. Anc̈huczti ana niz̈ta kuzziz cjeella. Anc̈hucac̈ha arajpach Yooz Ejpchizqui. C̈hjultakic̈ha anc̈hucqui pecc̈haj niiqui, liwj zizza Yooz Ejpqui. ");
INSERT INTO capNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jalla niz̈tiquiztan Yooz Ejpz̈quinpankaz walja kuzziz cjee. Niz̈aza niiz̈ mantita zuma kamañquiz kuzziz cjee. Jalla nekztanaqui anc̈hucaltaqui cawalikaz cjequic̈ha c̈hjulumi. ");
INSERT INTO capNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Jakatan c̈hjulut anawalinaca watac̈haj niiqui, jalla nii ana juyzu paa tonjiqui. Jakaqui c̈hjulut watac̈haj niiqui, jakapachaz̈ jaknuz̈quinami wataquic̈ha. Zapuru c̈hjul anawalinacaqui z̈ejlñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesusaqui tjaajinchizakazza: —Anc̈hucalaqui anac̈ha z̈oñinacz̈ uj chii chiizqui. Jalla nuz̈ z̈oñinacz̈ uj chii chiyaquiz̈ niiqui anc̈hucqui juc'ant ujchiz cjequic̈ha Yooz yujcquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Niz̈aza z̈oñinacz̈quizimi “Amqui Yooziz̈ castictaj cjila”, cjican chiyaquiz̈ niiqui anchucqui Yooziz̈ casticta zakaz cjequic̈ha. Zoñinacz̈tan zuma kama. Nekztan Yooz Ejpqui anc̈hucatan zumaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Niz̈aza amqui am jilz̈ c̈hjujcquiz tsjii cjujchilla cherasaz̈ niiqui, ¿kjaz̈tiquiztan am persun c̈hjujcquiz pajk cjujchi ana cherjo? ");
INSERT INTO capNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Am persun c̈hjujcquiz nii pajk cjujchi ana cherasaz̈ niiqui, ¿kjaz̈tiquiz̈tan am jilz̈quiz chiijo, “Jila, am c̈hjujcquiztan cjujchilla apakz̈inac̈ha”, cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ana zum kuzziz z̈oñimc̈ha amqui. Am persun c̈hjujcquiztan pajk cjujchi apakalla. Nekztan zuma cherasac̈ha, y niz̈aza am jilz̈ c̈hjujcquiztan cjujchilla apakasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‛Yoozquin criichi z̈oñinaca, anc̈hucqui Yooz taku anapan nonz pecñi z̈oñinacz̈tan Yooz puntu ana paljayaquic̈ha. Ninacaqui pacunacaz̈takazza. Niz̈ta z̈oñinacaqui anc̈hucaltan ch'atñi pacuz̈takaz cjesac̈ha. Niz̈aza nii Yooz taku anapan nonz pecñi z̈oñinacaqui cuchinacaz̈takazza. Yooz puntu nonz̈cu, kuzquizkaz z̈awjc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesusaqui tjaajinchizakazza: —Yooz Ejpz̈quiztan mayaquiz̈ niiqui, Yooz Ejpqui tjaaquic̈ha. Niz̈aza Yoozquin kjuraquiz̈ niiqui, Yooz wachaquic̈ha. Niz̈aza kjuy zanquiztan t'oc t'ocaquiz̈ niiqui, cjetz̈intaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jequit mayac̈haja, risiwaquicha. Niz̈aza jequit Yoozquin kjurac̈haja, wachaquic̈ha. Niz̈aza jequit kjuy zanquiztan t'oc t'ocac̈haja, cjetz̈intaz̈ cjequic̈ha. Jalla nuz̈uc̈ha Yoozquiz mayizizqui. ");
INSERT INTO capNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Anaz̈ jakziltami anc̈huca majch t'anta mayanaqui maz chjalznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Niz̈aza anaz̈ jakziltami anc̈huca majch ch'iz mayanaqui zkora chjalznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Anc̈hucqui ana zum kuzziz cjenami zuma cusasanaca tjayinc̈hucc̈ha persun maatinacz̈quiz. Jaziqui anc̈huca arajpach Yooz Ejpqui mayñi maatinacz̈quiz juc'ant zumaz̈ tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‛Jaknuz̈t anc̈hucqui parti z̈oñinaca anc̈hucatan zuma munaziz pecc̈haj niiqui, jalla niz̈tapacha parti z̈oñinacz̈tan zuma munaziz waquizic̈ha anc̈hucqui. Jalla niipan Moisés liiquiz chiichic̈ha, niz̈aza Yooz cuntiquiztan chiiñi profetanacaz̈ cjijrtanacami. ");
INSERT INTO capNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesusaqui tjaajinchizakazza: —Yoozquin ojkz pecc̈haj niiqui, zkoz zanquiztan luzza. Infiernuquin ojkñi jicz palac̈ha, niz̈aza pal zanchizza. Jalla nijwcchuc ojkñi z̈oñinacaqui muzpac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Tsjiic zakaz z̈ejlc̈ha. Arajpachquin ojkñi jicz zkozac̈ha, niz̈aza zkoz zanallchizza. Niz̈aza c'ujlcullac̈ha arajpachquin ojkñi jiczqui. Jalla nii jiczquinaqui koluckaz z̈oñi ojkc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesusaqui tjaajinchizakazza: —Anc̈hucqui zumpacha cwitasaquic̈ha toscar taku chiichiiñi z̈oñinacz̈quiztanami. Jalla ninacaqui “Yooziz̈ tjaata taku chiyuc̈ha” cjiñizakazza. Ninacaqui anc̈hucaquiz tjonz̈a, tsjii uuzi zkizi tjutz̈ta kitiz̈takaz. Ninacz̈ kuzqui anawira zumac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ninacz̈ ana zuma kamañquiztan pajtaz̈ cjequic̈ha, ultimu ana zum z̈oñinacaqui. Tsjii ch'ap muntiqui uwas frutchiz anaz̈ cjesac̈ha. Niz̈aza tsjii ch'ap plantaqui higo frutchiz anaz̈ cjesac̈ha. Jalla niz̈tapanc̈ha ana zum kuzziz z̈oñinaca. Zuma kamañchizqui anapanz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tjapa zuma muntinacaqui zuma fruta pookñic̈ha. Niz̈aza tjapa ana zuma muntinacaqui ana zuma fruta pookñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Zuma muntiqui anapanz̈ ana zuma frutchiz cjesac̈ha. Niz̈aza ana zuma muntiqui anapanz̈ zuma frutchiz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Jakzilta muntit zuma fruta ana pookzaja, k'atz̈taz̈ cjequic̈ha niz̈aza ujtaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jalla niz̈tanacquiztan anc̈hucqui ana zum kuzziz z̈oñinaca pajaquic̈ha, ninacaz̈ ana zuma kamañquiztan. ");
INSERT INTO capNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesusaqui tjaajinchizakazza: —Yekjap z̈oñinacaqui wejtquiz “wejt Jiliri, wejt Jiliri” paljayc̈ha. Pero nuz̈ chiicanami, anaz̈ wejt arajpach Ejpz̈ mantuquiz kamaquiz̈ niiqui, anapanz̈ arajpach wajtquin okasac̈ha, niz̈aza anapanz̈ arajpach Yooz Ejpz̈ mantuquiz z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ultim z̈oñi pjalz tjuñquiziqui wacchi z̈oñinacaqui wejtquiz paljayaquic̈ha, tuz̈ cjican: “Wejt Jiliri, wejt Jiliri, am tjuu aynakcan Yooz taku paljaychinc̈ha, niz̈aza am tjuu chiican zajranaca chjatkatchinc̈ha, niz̈aza am tjuu aynakcan wacchi milajrunaca paachinc̈ha”. Jalla nuz̈ cjican wejtquiz paljayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jalla nuz̈ paljaytiquiztanami wejrqui cjeec̈ha, “Anc̈huc anawira pajchinla pero. Wejtquiztan zaraka. Anc̈hucc̈ha ana zuma paañinacaqui”. ");
INSERT INTO capNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesusaqui tjaajinchizakazza: —Jakziltami weriz̈ chiita taku nonz̈aja, niz̈aza weriz̈ chiita tawk jaru kamc̈haja, jalla niiqui zuma intintazñi z̈oñinacac̈ha. Intintazñi z̈oñiqui jalla tuz̈uc̈ha. Tsjii maz lum juntuñ kjuya kjuyc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nekztanaqui chijñi chijinchic̈ha. Nekztan puj kjazqui walja tsijtchic̈ha, niz̈aza pjatzic̈ha, niz̈aza tjamiqui walja tjamchic̈ha nii kjuya quintra. Pero nii chijñimi, tjamimi, kjazmi ana nii maz juntuñ kjuyta kjuyaqui pali atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jaziqui jakziltami weriz̈ chiita taku nonzcanpacha ana wejt tawk jaru kamc̈haja, jalla niiqui zumzu z̈oñic̈ha. Zumzu z̈oñiqui jalla tuz̈uc̈ha. Ana zuma yokallquiz pjil yok juntuñ kjuya kjuychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nekztanaqui chijñi chijinchic̈ha. Jalla nekztan puj kjazqui walja tsijtchic̈ha, niz̈aza pjatzic̈ha, niz̈aza walja tjamchic̈ha nii kjuya quintra. Jalla nekztanaqui nii pjil yok juntuñ kjuyta kjuyaqui muzpa tsucchuca pajlzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesusaz̈ jalla nuz̈ tjaajñi z̈erz̈tan, nonz̈ñi z̈oñinacaqui walja ispantichic̈ha niiz̈ tjaajintiquiztan. ");
INSERT INTO capNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jesusaqui walja zizñi zizñi tjaajinchic̈ha. Lii tjaajiñi maestrunacaqui ana niz̈ta tjaajiñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jalla nekztanaqui Jesusaqui curquiztan chjijwz̈quichic̈ha. Niz̈aza muzpa z̈oñinaca apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tsjii mojkchi janchichiz laa z̈oñiqui Jesusiz̈quiz macjatz̈quichic̈ha. Jesusiz̈ yujcquiz quillz̈cu, tuz̈ cjichic̈ha: —Wejt Jiliri, tii laaquiztanz̈ c̈hjetnalla. Am wejr c̈hjetinzim pecc̈haj niiqui, wejr c̈hjetinzim atc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jalla nekztanaqui Jesusaqui kjarz̈tan lanz̈can, tuz̈ cjichic̈ha: —Wejr am c̈hjetnasachiya. C̈hjetintam cjissa. Jesusaz̈ jalla nuz̈ chiitiquiztan, nii mojkchi janchichiz z̈oñiqui laaquiztan z̈ejtchi quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Nekztanaqui Jesusaqui niiz̈quin chiiz̈inchic̈ha, tuz̈ cjican: —Wejr am tsjii cjesac̈ha. Jalla tii c̈hjetintiquiztanaqui anam jecz̈quizimi maznaquic̈ha. Timpluquin oka. Jalla nicju timplu jilirz̈quin persunpacha tjeez̈ca, z̈ejtchi, jalla nii. Niz̈aza Moisés mantita ofrenda tjaaquic̈ha, tjapa z̈oñinaca zizajo, laaquiztan c̈hjetinta, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jalla nekztanaqui Jesusaqui Capernaum cjita watja luzzic̈ha. Jalla nuz̈ luzan tsjii roman sultat capitán jiliriqui niiz̈quin macjatz̈quichic̈ha. Nekztanaqui roct'ichic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","tuz̈ cjican: —Wejt Jiliri, kjuyquiz wejt piyuna ajpzquiz z̈ejlc̈ha, ana tsijtñi. Niz̈aza walja ana wali ayiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nekztanaqui Jesusaqui cjichic̈ha: —Nii c̈hjetñi okasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nii sultat capitán jiliriqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, anal wejt kjuyquiz am tjonz̈ca cjiyi atasac̈ha. Wejrqui amquiztan inakaztc̈ha. Jaziqui takukaz chiya c̈hjetinzjapa. Nekztan wejt piyunaqui c̈hjetinta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wejrpacha wejt pajk jilirz̈ mantuquiz z̈eluc̈ha. Niiz̈ mantitacama ojklayiñc̈ha. Niz̈aza wejt mantuquiz sultatunaca z̈ejlc̈ha, c̈hjulut wejr mantuc̈haja, jalla nuz̈ cjen zultatunaca ojkc̈ha. Niz̈aza zultatu kjawznuc̈haja, zakaz tjonc̈ha. Niz̈aza wejt piyuna c̈hjulu paajumi mantuc̈haja, zakaz paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jalla nuz̈ nonz̈cu, Jesusaqui nii jiliri ancha zuma kuzziz naychic̈ha. Nekztanaqui nuz̈ nayz̈cu Jesusaqui niiz̈ apzñinacz̈quiz cjichic̈ha: —Wejrqui weraral cjiwc̈ha. Chekapan tii z̈oñiqui juc'ant Yoozquin kuzzizza, tjapa Israel wajtchiz z̈oñinacz̈quiztanami. ");
INSERT INTO capNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niz̈aza wejrqui cjiwc̈ha, tuwantan tajatan muzpa z̈oñinacaqui tjonaquic̈ha, arajpach Yooz wajtquin luzjapa. Jalla nii Yooz wajtchiz z̈oñinacaqui Abrahamz̈tan, Isaacz̈tan, Jacobz̈tan, jalla ninacz̈tan juntupacha cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Israel z̈oñinacazti arajpach Yooz wajtquin z̈ejlchucatac̈ha. Pero Yooz wajt zawntan zumchiquiz chjatkattaz̈ cjequic̈ha. Jalla nicjuz̈ kaaquic̈ha, niz̈aza iz̈ke jojcan z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jalla nekztanaqui Jesusaqui capitán jilirz̈quiz tuz̈ cjichic̈ha: —Am kjuya oka. Jaknuz̈t am tjapa kuztan criic̈haja, jalla niz̈tapachaz̈ cjequic̈ha. Jalla nii orapacha niiz̈ piyunaqui z̈ejtchi quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nekztanaqui Jesusaqui Pedruz̈ kjuya ojkchic̈ha. Jalla nicju ajpzquiz Pedruz̈ ajmuz̈ maa cherchic̈ha ch'ujlñi conz̈tan laa cjichi. ");
INSERT INTO capNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Naaz̈a kjara lanz̈inchic̈ha. Nuz̈ lanztiquiztan nii ch'ujlñi conquiztan z̈ejtchinc̈ha. Nii orapacha z̈aaz̈cu, ninaca atinti kallantichinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nii c̈hjetinta quintu nonz̈cu tjuñiz̈ kattan muzpa zajraz̈ tanta z̈oñinaca Jesusiz̈quiz zjijctatac̈ha. Jesusaqui tsjii taku chiiz̈cu zajranaca chjatkatchic̈ha. Niz̈aza tjapa laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nii c̈hjetintanacaqui Isaías profetaz̈ chiita taku cumplissic̈ha. Isaiasqui cjijrchic̈ha tuz̈ cjican: “Tsjii z̈oñiqui uc̈hum laa curpunaca tjupi cjiskataquic̈ha, niz̈aza conanacquiztan uc̈hum c̈hjetnaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wiruñaqui tsjii noojiqui muzpa z̈oñinacaqui walja muytata Jesusiz̈quiz ajczic̈ha. Jalla niz̈ta cherz̈cu, Jesusaqui mantichic̈ha, kotz̈ tsjii latuquiztan okajo. ");
INSERT INTO capNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Jalla nekztanaqui tsjii lii tjaajiñi maestruqui Jesusiz̈quiz macjatz̈quichic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, jakzitchum okac̈haja, amtan chicapachal ojklayasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesusaqui niiz̈quin kjaazic̈ha, tuz̈ cjican: —Kitinacami kjuychizza. Niz̈aza wez̈lanacami tjurchizza. Wejrzti anal kjuychizza, tjajzjapami. ");
INSERT INTO capNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tsjiiqui niiz̈quiz apzñi z̈oñinacz̈quiztan zakaz paljaychic̈ha, tuz̈ cjican: —Wejt Jiliri, amtan chica ojklayasac̈ha. Pero wejt ejpc̈ha ticziqui. Nekztan iyal wejt ejp tjatsñi okaz̈ cjeella. ");
INSERT INTO capNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Wejttan chicaka am ojklaya. Ticziz̈takaz z̈oñinacaqui, jalla ninacaj ticzinaca tjatz̈lani. ");
INSERT INTO capNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jalla nuz̈ chiyz̈cu Jesusaqui warcuquiz luzzic̈ha. Niiz̈ tjaajinta z̈oñinacaqui luzzizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ninacaz̈ kotquiz okan, tjamiqui walja tjamchic̈ha. Jalla nuz̈ tjaman kjaz ljojkiqui warcu tjatanz pecatc̈ha. Jesusazti tjajatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nii kjaz ljojkiz̈ cjen tjaajinta z̈oñinacaqui Jesusa z̈inchic̈ha, tuz̈ cjican: —¡Wejt Jiliri! ¡Liwriyalla! Tii warcu kjazquiz julzmayac̈ha. Ticznac̈hani uc̈humqui. ");
INSERT INTO capNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈hucqui ancha tsuctsucjo? Anc̈hucqui anac̈ha wejtquin tjapa kuzziz. Jalla nekztan Jesusaqui z̈aaz̈cu, tjamimi kjaz ljojkimi ujzic̈ha. Jalla nuz̈ chiitiquiztan tjamimi kjaz ljojkimi apaltichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nii apaltiñi cherz̈cu niiz̈tan ojklayñi z̈oñinacaqui ispantichic̈ha, niz̈aza tuz̈ cjichic̈ha: —¿C̈hjul z̈oñit teejo? Tjamimi tii kot kjaz ljojkimiz̈ tiiz̈ chiita takukaz cazla. ");
INSERT INTO capNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nii kotz̈ nawjctuñtan irantiz̈cu, Jesusaqui Gadara cjita yokquin ulanchic̈ha. Ulantan pucultan z̈oñinacaqui campu santuquiztan tjonchic̈ha. Nii pucultan z̈oñinacaqui zajraz̈ tantatac̈ha walja ana walinacatac̈ha, z̈oñinacz̈tan kichasñipanikaztac̈ha. Jalla niz̈tiquiztan nii jiczquiz ana jecmi ojklayñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jesusiz̈quiz macjatz̈cu nii zajranacaz̈ tanta z̈oñinacaqui kjawchic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan wejtnacaquiz mitisejo? Ima casticz timpu irantiz̈can amqui tekz tjonchamc̈ha, wejrnaca sufriskatzjapa. ¿Kjaz̈tatajo? —Nuz̈ cjican kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Niz̈aza nii nawjkchuc cuchinacaqui ojklayc̈ha lujlcan. ");
INSERT INTO capNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Zajranacaqui Jesusiz̈quiz rocchic̈ha tuz̈ cjican: —Amqui wejrnaca chjatkataquiz̈ niiqui, nii cuchinacz̈quin wejrnaca luzkatalla. ");
INSERT INTO capNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Niz̈taqui, oka. Cuchinacz̈quin luzca. Jalla nuz̈ chiitiquiztan zajranacaqui z̈oñinacz̈quiztan ulanchic̈ha; cuchinacz̈quin luzzic̈ha. Zajranacaz̈ luztiquiztan cuchinacaqui tsjii barranc k'awquin tjojtsic̈ha, kotquizpachatac̈ha. Jalla nuz̈quiz kjaztan tsamz̈cu, ticzic̈ha nii cuchinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jalla nii cuchi itzñinacaqui ancha tsucchi zajtchic̈ha. Watja irantiz̈cu, nii pucultan zajraz̈ tanta z̈oñinacz̈ puntuquiztan quint'ichic̈ha, niz̈aza tjapa niz̈ta watchinacami. ");
INSERT INTO capNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jalla nii quintu nonz̈cu tjapa nii wajtquiz z̈ejlñi z̈oñinacaqui ulanchic̈ha, jakziquin Jesusa z̈elatc̈haja, nicju. Jesusiz̈tan zalz̈cu, ninacaqui rocchic̈ha, ninacz̈ yokquiztan okajo. ");
INSERT INTO capNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jalla niiz̈ wiruñpachaqui Jesusaqui wilta warcuquiz luzzic̈ha. Nekztan kotz̈ tsjii latuquiztan kajkchic̈ha. Niz̈aza niiz̈ persun watja irantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jalla nijwc z̈oñinacaqui Jesusiz̈quin tsjii zuch z̈oñi chjitchic̈ha. Tjajz zquitinacz̈tanpacha ajpchi chjitchic̈ha. Ninacz̈ tjapa kuz cjicjiñi cherz̈cu, Jesusaqui laa z̈oñz̈quiz paljaychic̈ha, tuz̈ cjican: —Jila, ana llaquisa; tjup kuzziz cjee. Am ujnacac pertuntac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jalla niz̈ta chiiñi nonz̈cu yekjap lii tjaajiñi maestrunacaqui kuzquiz tuz̈ pinsichic̈ha: “Yooz quintrala; tii z̈oñz̈ takuqui anawalipanla”. ");
INSERT INTO capNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero Jesusaqui ninacz̈ kuzquiz pinsita zizatc̈ha. Jalla nekztan ninacz̈quiz cjichic̈ha: —¿Kjaz̈tiquiztan anc̈hucqui niz̈ta ana zuma pinsamintuchiztajo? ");
INSERT INTO capNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Jakzilta takut pjasila chiiz cjesajo? ¿“Am ujnaca pertuntac̈ha” chiiz pjasila cjesaya? Uz̈ ¿“Tsijtsna, oka”, jalla nuz̈ chiiz pjasila cjesaj? ");
INSERT INTO capNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Tsewctan cuchanz̈quita Yooz Zoñtc̈ha wejrqui. Tii muntuquiz jiliritc̈ha, ujnaca pertunzjapami. Razunal chiyuc̈ha. Nuz̈ zizjapa, anc̈hucqui tiiz̈ chera. Jalla nekztanaqui nii zuch z̈oñz̈quiz cjichic̈ha: —Tsijtsna, am tjajz zquiti apta; niz̈aza am kjuya oka. ");
INSERT INTO capNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jalla nii orapacha tsijtsic̈ha, niz̈aza niiz̈ kjuya ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Zoñinaca nii cherz̈cu, tsucchi quirchic̈ha, niz̈aza “Yoozqui honorchiz cjilalla” cjican chiichic̈ha. Yoozqui z̈oñinacz̈quiz niz̈ta c̈hjetinñi azi tjaachiz̈ cjen, nuz̈ chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nii kjuyquiztan ulanz̈cu Jesusaqui Mateo cjita z̈oñi cherchic̈ha. Mateoqui impuesto cobriñi puestuquiz julzi z̈elatc̈ha. Jesusaqui niiz̈quiz cjichic̈ha: —Wejttan chica ojklaya. Jalla nekztan Mateoqui tsijtscu, Jesusiz̈tan ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Niiz̈ wiruñ Jesusaz̈ Mateoz̈ kjuyquin lulan, muzpa impuesto cobriñinacami niz̈aza ujchiz z̈oñinacami irantichic̈ha. Niz̈aza ninacaqui Jesusiz̈tan niiz̈ tjaajinta z̈oñinacz̈tan chica julzic̈ha tsjii mizquiz. ");
INSERT INTO capNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fariseo z̈oñinacazti jalla nii cherz̈cu, Jesusiz̈ tjaajinta z̈oñinacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈huca tjaajiñi maestruqui impuesto cobriñinacz̈tan niz̈aza ujchiz z̈oñinacz̈tan c̈hjeri lujljo? ");
INSERT INTO capNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesusaqui jalla niz̈ta pewczñi nonz̈cu ninacz̈quiz cjichic̈ha: —Zuma wiw z̈oñinacaqui anaz̈ médicu kullñimi pecc̈ha. Antiz laa z̈oñinacaz̈ médicu kullñimi pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yooz takuqui tuz̈ cjic̈ha: “Oksñi kuzziz z̈oñinaca juc'antil pecuc̈ha wilana jawkñi z̈oñinacz̈quiztan”. Tantiiya c̈hjul puntut tii Yooz taku chiic̈haja, nii zumpacha intintaza. Jaziqui wejrqui “Zuma kamuc̈ha” cjiñi z̈oñinacz̈quiz anal kjawsñi tjonchinc̈ha. Antiz “Ujchizpanc̈ha” cjiñi z̈oñinacz̈quiz kjawsñi tjonchinc̈ha, ninacz̈ kuz campiita cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistaz̈ tjaajinta z̈oñinacaqui Jesusiz̈quiz macjatz̈quichic̈ha. Nekztan pewczic̈ha, tuz̈ cjican: —Wejrnacmi fariseo z̈oñinacami walja ayunasiñc̈ha. Amiz̈ tjaajinta z̈oñinacazti ana ayunasñipanla. ¿Kjaz̈tiquiztan niz̈tajo? ");
INSERT INTO capNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿Kjaz̈t weriz̈ tjaajinta z̈oñinaca llaquit kuzziz ayunasasajo, weriz̈ z̈elanpachajo? Wejrqui zalz kazzi tjowaz̈takaztc̈ha. Ninacaqui zalz pjijstiquiz invittanacaz̈takazza. Zalz kazzi tjowaz̈ z̈elan, niiz̈ zalz pjijstiquiz invittanacaqui ana llaquit kuzziz ayunasasac̈ha. Pero tsjii timpuz̈ tjonaquic̈ha. Jalla nii timpuquiz zalzñi tjowa kjañtaz̈ cjequic̈ha; jalla nekztanz̈ ayunasasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‛Anaz̈ jakziltami tsjel zquiti ew rimintuz̈tan rimintasac̈ha. Ew rimintuqui jaljtapasac̈ha, niz̈aza nii ach zquitiqui juc'anti wjajrz̈cu tsjelanznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Niz̈aza anaz̈ jakziltami ach zkiz luuzquiz ew vinu alznasac̈ha. Jalla niz̈taz̈ alznasaz̈ niiqui, zkiz luuz panz̈ wjajrskatasac̈ha ew vinuqui. Nekztan vinumi zkiz luuzmi pertisnasac̈ha. Ew vinu ew zkiz luuzquiz panz̈ alznasac̈ha. Jalla nuz̈ zumpacha cjesac̈ha vinumi zkiz luuzmi. ");
INSERT INTO capNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesusaz̈ tjaajnan, tsjii judío z̈oñinacz̈ jiliriqui irantichic̈ha. Jesusiz̈ yujcquin quillzic̈ha, tuz̈ cjican: —Wejt majtqui ticzñil jitc̈ha. Amqui wejt kjuya okasaz̈ niiqui, naaquiz am persun kjarz̈tan lanznasac̈ha. Nekztan naaqui z̈etaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nekztanaqui Jesusaqui tsijtscu nii jilirz̈tan ojkchic̈ha tjaajinta z̈oñinacz̈tanpacha. ");
INSERT INTO capNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jalla nuz̈ okan, tsjaa laa maatak z̈onqui Jesusiz̈quiz wirquiztan macjatz̈quichinc̈ha. Tunca paan wata ljok tjawksñi laakaz t'akjiri z̈elintac̈ha. Jesusiz̈quiz macjatz̈cu Jesusiz̈ zquit puntallquiz lanzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ima macjatcan pinsichinc̈ha, “Wejrqui niiz̈ zquitilla lanz̈cu z̈etaka wejrqui” cjican. ");
INSERT INTO capNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jalla nuz̈ lanztiquiztan Jesusaqui jalla naaz̈a kjutñi kjutz̈cu naa maatak z̈oñ cherzic̈ha. Nekztan tuz̈ cjichic̈ha: —Cullaca, tjup kuzziz cjee. Amiz̈ tjapa kuztan criichiz̈ cjen, z̈ejtchi cjissamc̈ha. Jalla nii orapacha z̈ejtchin cjissinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jalla nekztanaqui Jesusaqui tira ojkchic̈ha. Nii jilirz̈ kjuya irantican Jesusaqui cherchic̈ha, nii jilirz̈ majt tjatzjapa banda pjujñinacaqui listutakalc̈ha, jalla nii. Niz̈aza z̈oñinacaqui anchaz̈ kaacan aranchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Nuz̈ cherz̈cu Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucqui tekztanz̈ ulna. Taa uzqui anac̈ha ticzinqui, antiz tjajc̈ha. Jalla nuz̈ Jesusiz̈ chiitiquiztan, z̈oñinacaqui niiz̈quin tjassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nekztanaqui Jesusaqui ninaca ulanskatchipanc̈ha. Nekztan luzcu, naaz̈a ticzi uza kjarcu tanz̈cu, z̈inzic̈ha; z̈ejtchinpacha. ");
INSERT INTO capNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jalla nekztanaqui tjapa kjutñi nii yokquin nii milajru quintu ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jalla nijwctan ulanz̈quitiquiztan pucultan zur z̈oñinacaqui niiz̈quin apz̈quichic̈ha, kjawcan: —Davidz̈ majchmaatquiztan tjoñi, wejrnaca okznalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Nekztan Jesusaz̈ kjuya luztan nii zur z̈oñinacaqui niiz̈quin macjatchic̈ha. Nekztan Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Wejrqui anc̈huc cherkatasac̈ha, ¿jalla nii crii anc̈hucya? Ninacaqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, criyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jalla nekztanaqui Jesusaqui ninacz̈ c̈hjujqui lanlanz̈inchic̈ha. Niz̈aza cjichic̈ha: —Anc̈hucaz̈ tjapa kuztan criitiquiztan cherñi cjisna. ");
INSERT INTO capNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nii orapacha ninacz̈ c̈hjujquiqui cherñi cjissic̈ha. Nekztanaqui Jesusaqui ninacz̈quiz zumpacha chiiz̈inchic̈ha, tuz̈ cjican: —Tii c̈hjetintaqui anaj jecmi zizla; anc̈hucmi anaz̈ jecz̈quizimi chiichiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jesusaz̈ nuz̈ chiiz̈inchiz̈ cjenami, ninacaqui ulanz̈cu, tjapa yokaran nii c̈hjetinta quintu parlichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nii kjuyquiztan ulnan yekjap z̈oñinacaqui tsjii zajraz̈ tanta z̈oñi zjijcchic̈ha. Zajraz̈ tantiquiztan ana chiiñi atatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nekztanaqui Jesusaqui nii zajra chjatkatchic̈ha. Jalla nuz̈ chjatkattiquiztan nii ana chiiñi z̈oñiqui chiyi kallantichic̈ha. Zoñinacazti jalla nii cherz̈cu walja ispantichi cjissic̈ha, tuz̈ cjican: —Tii Israel yokquiz ana wira tiz̈tanaca cheriñtac̈ha wejrnacqui. ");
INSERT INTO capNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero fariseo nz̈oñinacazti tuz̈ cjetc̈ha: —Tiiqui zajranacz̈ jilirz̈ aztankaz zajranaca chjatkatñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesusaqui tjapa wajtquiztan watja niz̈aza jochquiztan jochi ojklaychic̈ha, judío ajcz kjuyquizimi tjaajincan. Yooz mantuquiz kamz puntu chiiz̈inchic̈ha. Niz̈aza tjapaman laanacami niz̈aza jallc'a curpuchiznacami c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Zoñinaca cherz̈cu, ninaca okzic̈ha. Ana awatirchiz uuzanacaz̈takaz z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Zoñinaca okzcu, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Weraral cjiwc̈ha. Zkalaqui walja z̈ejlc̈ha. Pero zkala ajzñi z̈oñinacac̈ha upaqui. ");
INSERT INTO capNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Yooz Ejpqui zkal Patrunac̈ha. Jalla niz̈tiquiztan Yooz Patrunz̈quiztan mayiza, zkala ajzñi z̈oñi cuchnajo. ");
INSERT INTO capNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jalla nekztanaqui Jesusaqui niiz̈ tuncapan illzta z̈oñinaca kjawzic̈ha. Nekztan ninacz̈quiz mantiz poder tjaachic̈ha, zajranaca chjatkatzjapa, niz̈aza tjapaman laanacami jallc'a curpuchiznacami c̈hjetnajo. ");
INSERT INTO capNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nii tuncapan illzta apostolonacaqui jalla tiz̈ta tjuuchiznacatac̈ha: Primiruqui Simonatac̈ha, niz̈aza niiz̈ tsjii tjuuqui Pedro cjitazakaztac̈ha. Nekztan niiz̈ lajktac̈ha, Andrés cjita. Nekztan Jacobotac̈ha, niz̈aza niiz̈ jila Juan. Nii pucultanaqui Zebedeoz̈ majchwichtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nekztan Felipitac̈ha, Bartolometac̈ha, Tomastac̈ha, niz̈aza Mateotac̈ha. Nii Mateozti impuesto cobriñitac̈ha. Nekztan Jacobotac̈ha, Alfeoz̈ majchtac̈ha. Nekztan Lebeotac̈ha niz̈aza niiz̈ tsjii tjuuqui Tadeo cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nekztan Simonatac̈ha, niiqui cananista cjita partiquiztantac̈ha. Ultimquiziqui Judas Iscariotetac̈ha, jalla niiqui Jesusiz̈ quintra tarasunchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesusaqui nii tuncapan illzta z̈oñinaca cuchanz̈quichic̈ha, niiz̈ cuntiquiztan ojklayajo. Ima cuchanz̈can tuz̈ chiiz̈inchic̈ha: —Judío yokquinpanz̈ ojklayaquic̈ha, Samaria yokquin niz̈aza yekja yokanacquin ana ojklayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel wajtchiz z̈oñinacz̈quinkaz okaquic̈ha. Jalla ninacaqui katchi uuzinacaz̈takaz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Arajpach Yooz mantuquiz kamz timpu z̈catz̈inz̈quic̈ha. Jalla nii paljaycan ojklayz̈caquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Niz̈aza laanaca c̈hjetnaquic̈ha. Niz̈aza ticzinaca jacatatskataquic̈ha. Niz̈aza mojkchi janchichiz z̈oñinaca c̈hjetnaquic̈ha. Niz̈aza zajranaca chjatkataquic̈ha. Tii mantiz poderaqui anc̈hucaquiz nuz̈ukaz tjaatac̈ha. Jalla niz̈tiquiztan tii poderz̈tan z̈oñinacz̈quiz yanapz̈cu anaz̈ c̈hjulumi mayaquic̈ha pacajo. ");
INSERT INTO capNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‛Paaz ana chjichaquic̈ha, kor paazmi, chiw paazmi, cobre paazmi. ");
INSERT INTO capNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Niz̈aza ana chjichaquic̈ha z̈ak quelzmi. Tsjii almilla alaja chjichaquic̈ha. Niz̈aza ana iya c̈hjulumi chjichasac̈ha, ana yekja c̈hjatami, niz̈aza atsmi. Yooztajapa langzñinacz̈quiziqui c̈hjeriqui tjaata cjis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‛Anc̈hucqui wajtquizimi jochquizimi irantiz̈cuqui, zuma z̈oñipanz̈ kjurznaquic̈ha. Nuz̈ zuma z̈oñi wachcuqui, niiz̈ kjuyquiz alujasaquic̈ha, nii wajtquiztanami jochquiztanami ulanzcama. ");
INSERT INTO capNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Tsjii kjuya luzcu, tsaanaquic̈ha, “Anc̈huc walipaj cjila”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nii kjuychiz z̈oñinaca zumaz̈laj niiqui, jalla ninacz̈taqui walipanz̈ cjequic̈ha. Yekjapa z̈oñinacaqui ana zumaz̈laj niiqui, jalla ninacz̈taqui c̈hjulumi anawalikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jakziltat anc̈huc ana risiwaquiz̈ niiqui, niz̈aza anc̈huc ana nonz pecaquiz̈ niiqui, ninacz̈quiztan okaquiz̈ anc̈hucqui. Nii kjuyquiztan ulnaquic̈ha niz̈aza nii wajtquiztanaqui. Nekztan nii wajtquiztan kjojchquiz z̈catchi pulpunaca tsajt tsajtsnaquic̈ha. Jalla nii tsajt tsajttaqui siñalaz̈ cjequic̈ha ninacz̈ quintra, anc̈huc ana risiwchiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Weraral cjiwc̈ha. Casticz tjuñquiziqui nii anc̈huc ana zuma risiwñi z̈oñinaczti juc'anti castictaz̈ cjequic̈ha, Sodoma cjita Gomorra cjita, jalla nii wajtchiz z̈oñinacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jesusaqui tjaajinchizakazza: —Tii weriz̈ chiiz̈inta taku nonz̈na. Wejrqui anc̈huc cuchnuc̈ha. Anc̈hucqui kitinacz̈ taypiquiz ojklayaquic̈ha, uuzanacaz̈takaz. Jalla niz̈tiquiztan anc̈hucqui walja kuzziz cjee. Listuz̈ cjequic̈ha z̈koraz̈takaz, pero zuma paazjapa. ");
INSERT INTO capNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Anc̈hucqui persunpachaz̈ walja cwitazaquic̈ha. Anc̈hucqui jilirinacz̈quin intirjita cjequic̈ha; niz̈aza ajcz kjuyquiz wjajttaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Niz̈aza anc̈hucqui wejt puntuquiztan parlichiz̈ cjen chjichtaz̈ cjequic̈ha prefectonacz̈quinami, niz̈aza tsjan chawjc jilirinacz̈quinami. Nekztan anc̈hucqui wejt puntuquiztan chiyaquic̈ha, nii jilirinacz̈ yujcquizimi, niz̈aza ana judío wajtchiz z̈oñinacz̈ yujcquizimi. ");
INSERT INTO capNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jilirinacz̈quiz intirjitaz̈ cjenami, ana kuz turwaysi cjequic̈ha, c̈hjulut anc̈huc kjaaznac̈haja, niz̈aza jaknuz̈t kjaaznac̈haja, jalla nii. Jilirinacz̈ yujcquiz prisintiz ora, Yoozqui anc̈huca kuzquiz chiiz taku tjaaquic̈ha, jaknuz̈t chiizalaj, nii. ");
INSERT INTO capNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Anc̈huca persun kuzquiztan anaz̈ chiyaquic̈ha. Antiz anc̈huca Yooz Ejpz̈ Espíritu Santuqui anc̈huc chiikataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‛Nii timpuquiziqui z̈oñinacaqui persun jilz̈ quintra aptjapznaquic̈ha persun jila conkatzjapa. Niz̈aza ejpnacaqui persun maatinacz̈ quintra aptjapznaquic̈ha. Maatinacazti persun maa ejpnacz̈ quintra zakaz aptjapznaquic̈ha, persun ejpnaca conkatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tjapa ana criichi z̈oñinacaqui anc̈hucaquiz ch'aanaquic̈ha wejt puntu parliñiz̈ cjen. Pero jakziltat ticzcama wali tjurt'iñi kuzziz cjec̈haj niiqui, liwriitaz̈ cjequic̈ha, Yooztan wiñaya kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tsjii wajtchiz z̈oñinacaqui anc̈huc chjatkataquiz̈ niiqui, ninacz̈quiztan yekja wajtquin okaquic̈ha. Weraral cjiwc̈ha, wejrqui arajpachquiztan cuchanz̈quita Z̈oñtc̈ha. Ima weriz̈ tii muntuquiz wilta tjonan, anc̈hucqui tjapa Israel watjanacz̈quin anaz̈ iranti atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‛Tjaajinta z̈oñiqui niiz̈ tjaajiñiz̈quiztan anaz̈ juc'anti cjesac̈ha. Niz̈aza piyunaqui niiz̈ patrunz̈quiztan anaz̈ juc'anti cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tsjii tjaajinta z̈oñiqui niiz̈ tjaajiñiz̈ irata, jalla niz̈ta tjaajiñiz̈ cjisnaquiz̈ niiqui, cuntintuz̈ cjis waquizic̈ha. Niz̈aza tsjii piyunaqui niiz̈ patrunz̈ irata, jalla niz̈ta patrunaz̈ cjisnaquiz̈ niiqui, cuntintuz̈ cjis waquizic̈ha. Nonz̈na anc̈hucqui, quintra z̈oñinacaqui “Beelzebú” cjican zajra jilirz̈ tjuuz̈tan wejtquiz tjuuskataquiz̈ niiqui, anc̈hucaquiz juc'ant anawal tjuuz̈tanz̈ tjuuskataquic̈ha. Wejrqui kjuychiz patrunz̈takaztc̈ha, anc̈huczti wejt kjuy familiaz̈takazza. ");
INSERT INTO capNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","‛Jalla niz̈tiquiztan anc̈hucqui anaz̈ z̈oñi eksna. Tjapa chjojzakuñ tjaajintami zuma kjana ziztaz̈ cjequic̈ha. Niz̈aza tjapa jamazit tjaajintami niz̈tazakaz zuma kjana ziztapankaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Tjapa weriz̈ chjojzaka tjaajintanacami anc̈hucqui z̈oñinacz̈ yujcquiz kjanacama paljayaquic̈ha. Niz̈aza tjapa weriz̈ jamazit tjaajintanacami anc̈hucqui paljayaquic̈ha, tjapa z̈oñinaca nonzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Nonz̈na anc̈hucqui, anac̈ha eksqui tii curpu alaja conñinacz̈quizimi. Ninacaqui animuqui anaz̈ conasac̈ha. Antiz Yoozquizpan eksna. Jalla niic̈ha curpumi animumi infiernuquin wiñaya t'akjisiskatñiqui. ");
INSERT INTO capNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","‛Tsjii paaztan pizc wez̈lanaca kjayasac̈ha. Jalla nuz̈ koluc valorchiz kjayz̈cumi anc̈huca Yooz Ejpqui ninaca cwitic̈ha. Yooz Ejpz̈ ana munan, tsjii wez̈laqui anaz̈ ticznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jilanaca, Yooz Ejpqui tjapa anc̈huca ach charanaca kanz̈intac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Jalla niz̈tiquiztan anaz̈ c̈hjulquiztanami eksna. Wez̈lanacz̈quiztan anc̈hucc̈ha juc'ant valorchizqui. Yooz Ejpqui anc̈huc juc'anti cwitaquic̈ha wez̈lanacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‛Jakziltat parti z̈oñz̈ yujcquiz wejt favora cjec̈haj niiqui, niz̈azakal wejrqui wejt arajpach Yooz Ejpz̈ yujcquiz nii z̈oñz̈ favora chiyac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Niz̈aza jakziltat parti z̈oñz̈ yujcquiz wejr ana pajñi nicac̈haj niiqui, niz̈aza wejrqui wejt arajpach Yooz Ejpz̈ yujcquiz nii z̈oñz̈ quintra ana pajñi zakal chiyac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‛Tii taku nonz̈na. Weriz̈ tjontiquiztan z̈oñinacaqui ana zumquin cjequic̈ha; quintrasñi cjequic̈ha. Nekztan aptjapznaquic̈ha. Ana criichinacaqui criichi z̈oñinacz̈ quintra cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Weriz̈ tjontiquiztan tsjii maatiqui persun ejpz̈japa quintraz̈ cjequic̈ha. Niz̈aza tsjaa majtqui persun maajapa quintra cjequic̈ha. Niz̈aza tsjaa wazmi persun kjan maajapa quintra cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Jalla niz̈ta zapa mayni familianacaqui ninacporaz̈ quintraz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Jakziltat persun maa ejpz̈quizkaz kuzziz cjec̈haja, jalla niiqui anaz̈ wejt partiquiz cjichuca cjesac̈ha. Niz̈aza jakziltat persun ocjalz̈quizkaz kayazt'ac̈haja, jalla niiqui anaz̈ wejt partiquiz cjichuca cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jakziltat wejt partiquiz cjis pecc̈haj niiqui, tjapa kuztanz̈ wejtquiz cjistanc̈ha. Sufrisjapaqui listoj cjila, ticzcama. Ana niz̈ta wejtquin tjapa kuztan cjec̈haj niiqui, anaz̈ wejt partiquiz cjichuca cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jakziltat weriz̈ cjen persun anazum kamañquiztan ana jaytac̈haja, jalla niiqui ultimquiziqui ana liwriita cjesac̈ha. Niz̈aza jakziltat weriz̈ cjen persun anazum kamañquiztan jaytac̈haja, jalla niiqui ultimquiziqui liwriitaz̈ cjequic̈ha; Yooztan wiñaya zuma kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jequit anc̈huc risiwc̈haja, niz̈aza wejrmi zakaz risiwc̈ha. Niz̈aza jequit wejr risiwc̈haja, jalla niiqui niz̈azakaz wejt Yooz Ejpmi risiwc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Jequit tsjii Yooziz̈ cuchanta profeta risiwaquiz̈ niiqui, jalla niiqui profetaz̈takaz honorchiz zakaz cjequic̈ha. Niz̈aza jequit tsjii Yooz kuzcama kamñi z̈oñi risiwac̈haja, jalla niiqui Yooz kuzcama kamñiz̈ premio, jalla niz̈tazakaz honorchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Niz̈aza jequit tsjii wejtquin kuzziz z̈oñz̈quiz yanapac̈haja, jalla niiqui honorchiz zakaz cjequic̈ha. Jequit wejtquin criichi z̈oñz̈quiz tsjii tasa kjaz onac̈haja, jalla niiqui honorchiz zakaz cjequic̈ha. —Jalla nuz̈ chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Niiz̈ tuncapan illzta z̈oñinacz̈quiz tjaajinz z̈erz̈cu, nekztan Jesusaqui ojkchic̈ha, yekja watjanac kjutñi. Wajtquiztan watja ojklaychic̈ha, z̈oñinacz̈quiz tjaajñi, niz̈aza Yooz taku paljayi. ");
INSERT INTO capNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juanqui nii oraqui carsilquiztac̈ha. Jalla nicju Cristuz̈ ojklaytanaca quintu nonchic̈ha. Nekztanaqui Juanqui tsjii kjaz̈t mazinaca Jesusa pewczñi cuchanz̈quichic̈ha. Nekztan irantiz̈cu Jesusiz̈quiz ");
INSERT INTO capNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","pewczic̈ha, tuz̈ cjican: —Cristuqui tjoniz̈ cjispacha; ¿Amj Yoozquiztan cuchanz̈quita Cristumkaya? ¿Uz̈ yekjaz̈ tjewznasa, jaa? ");
INSERT INTO capNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Jaknuz̈t cherc̈haja nonz̈aja, jalla nii tjappachaz̈ Juanz̈quiz quint'iz̈caquic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Zur z̈oñinacac cherc̈ha, Zuch z̈oñinacaqui ojklayc̈ha. Mojkchi janchichiz z̈oñinacaqui c̈hjetintac̈ha. Oñi z̈oñinacaqui nonz̈a. Niz̈aza ticzi z̈oñinacaqui jacatatskattac̈ha. Niz̈aza pobre z̈oñinacz̈quiz Yooz liwriiñi taku paljaytapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Jakziltat weriz̈ paatanaca cherz̈cu, niz̈aza weriz̈ chiitanaca nonz̈cu, ana kuz turwayziz̈laj niiqui, walipanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Jalla ninacaz̈ ojktan, Jesusaqui chiyi kallantichic̈ha Juanz̈ puntuquiztan. Z̈oñinacz̈quiz tuz̈ cjichic̈ha: —Ch'ekti yokquin, ¿c̈hjulu cherzñi ojkchinc̈huctaya? ¿Tjamiz̈ tjizinta caña cherzñi ojkchinc̈huctajo? Anac̈hay. ¿Fino zquiti cujtchi z̈oñi cherzñi ojkchinc̈huctajo? Chawjc jilirz̈ kjuyquin zuma zquiti cujtchi z̈oñi z̈ejlc̈ha. Jalla nii zizza anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿C̈hjulu cherzñi ojkchinc̈huctaya? ¿Yooz cuntiquiztan chiiñi profeta cherzñi ojkchinc̈huctaya? Jesalla, ultim werara nuz̈ ojkchinc̈hucc̈ha. Juanqui tuquita profetanacz̈quiztan juc'ant chekanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juanz̈ puntuquiztan Yooz takuqui tuz̈ cjic̈ha: “Yooz Ejpqui tsjii z̈oñi cuchanz̈caquic̈ha ima Cristuz̈ Yooz taku paljayi ojklayan. Nii z̈oñiqui Israel z̈oñinacz̈quiz Cristu zuma tjewskataquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Weraral cjiwc̈ha. Juan Bautistac̈ha parti z̈oñz̈ maatinacz̈quiztan tsjan juc'antiqui. Pero chjul Yooz maatimi z̈oñz̈ maatiquiztan tsjan juc'antic̈ha. Arajpach Yoozquin kuzziz z̈oñinacac̈ha Yooz maatinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‛Juanz̈ tjontiquiztan anzcama muzpa z̈oñinacaqui ts'acjazcan arajpach Yooz mantuquiz luz pecc̈ha; walja tjapa aztan niz̈aza tjapa kuztan luz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Juanz̈ tjonzcama, tjapa tuquita profetanacz̈ chiitanacami niz̈aza Moisés liinacami arajpach Yooz cuchanz̈quita puntuquiztan chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Elías cjita profetaqui wilta tjoniz̈ cjispacha; nii Elias tjonz cuntiquiztanc̈ha Juan Bautistaqui. Jalla niic werarac̈ha. Nuz̈ criiz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Jakziltac̈halaj nonzñi cjunc̈hiz, jalla niiqui tii chiitaqui nonz̈na. ");
INSERT INTO capNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‛¿Kjaz̈tat tii timpuquiz z̈ejlñi z̈oñinacajo? ¿Jecnaca iratat tinacajo? Jalla tiz̈ta ocjalanacaz̈takazza tinacaqui. Yekjap ocjalanacaqui palazquin julzi uzinc̈ha, niz̈aza ninacz̈ mazinaca kjawkjawz̈a, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tsajtsjapa pincallu pjujchinc̈ha. Anc̈huczti ana tsajtchinc̈hucc̈ha. Niz̈aza kaayikaayi wirzu itzinc̈ha. Anc̈huczti ana kaachinc̈hucc̈ha”. Jalla nuz̈ cjichic̈ha ocjalanacaqui. Jalla niz̈ta iratac̈ha tii timpuquiz z̈ejlñi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan tjonchic̈ha. Niiqui zumanaca ana lujlñic̈ha, niz̈aza ana licñic̈ha. Jalla niz̈tiquiztan anc̈hucqui tuz̈ cjiñc̈hucc̈ha, “Juanqui zajraz̈ tantac̈ha” cjican. ");
INSERT INTO capNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Niiz̈ wiruñaqui wejrqui tjonchinc̈ha, arajpach Yooz Ejpz̈ cuchanz̈quita Z̈oñi. Wejrqui zumanaca luluc̈ha, niz̈aza licuc̈ha. Jalla niz̈tiquiztan anc̈hucqui wejt puntuquiztan cjic̈ha: “Niic̈ha ancha lujlñiqui, niz̈aza licñiqui, niz̈aza niic̈ha ujchiz z̈oñinacz̈ maziqui, niz̈aza anawali impuesto cobriñinacz̈ maziqui”. Jalla nuz̈ cjiñc̈hucc̈ha wejt puntuquiztan. Tuz̈ zakal cjiwc̈ha: Yooz puntu zuma zizñi z̈oñinacaqui Yooz tjaajintacama kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jalla nekztanaqui Jesusaqui chiichic̈ha, chojru kuzziz z̈oñinacz̈ puntu. Tsjii watjanacquiz ancha milajrunaca paachic̈ha. Pero nii wajtchiz z̈oñinacazti persun uj ana pajchic̈ha; niz̈aza kuznaca ana campiichic̈ha. Jalla niz̈tiquiztan Jesusaqui ninacz̈quiz ayjatchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Corazín wajtchiz z̈oñinaca, anc̈hucaquiz ancha anawaliz̈ wataquic̈ha. Niz̈aza Betsaida wajtchiz z̈oñinaca, anc̈hucaquiz ancha anawalizakaz wataquic̈ha. Anc̈huca watjanacquiziqui walja milajrunaca paachinc̈ha. Tiro cjita niz̈aza Sidón cjita watjanacquiz nii milajrunaca paataz̈ cjitasaz̈ niiqui, nii ortanpacha nii wajtchiz z̈oñinacaqui Yoozquin kuzziz cjitasac̈ha; niz̈aza “ujchizpanc̈ha wejrnacqui, pertunalla”, cjitasac̈ha. Niz̈aza uj zint'iz̈cu nii wajtchiz z̈oñinacaqui llaquita kuz kjanapacha tjeezñi cjitasac̈ha, lutu zquiti cujtz̈cu, niz̈aza achquiz kjupz̈tan tjajlz̈cu. ");
INSERT INTO capNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jalla niz̈tiquiztan anc̈hucqui juyzu casticz tjuñquiziqui juc'anti castictaz̈ cjequic̈ha nii Tiro cjita niz̈aza Sidón cjita watjanacchiz z̈oñinacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Capernaum wajtchiz z̈oñinaca, ¿kjaz̈tiquiztan anc̈hucqui pinsejo, “Yoozqui uc̈hum honorchiz cjizkataquic̈ha”, cjicanajo? Anaz̈ nuz̈ cjesac̈ha. Pero anc̈huczti kozzuc tjojttaz̈ cjequic̈ha infiernuquin sufrisjapa, ujchiz z̈oñinacz̈tan chica. Anc̈huca wajtquiziqui walja milajrunaca paachinc̈ha. Sodoma cjita wajtquiz nii milajrunaca paataz̈ cjitasaz̈ niiqui, nii watjaqui anz tii tjuñinaca z̈ejltasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Jalla niz̈tiquiztan nii juyzu casticz tjuñquiziqui anc̈hucqui juc'anti castictaz̈ cjequic̈ha, Sodoma wajtchiz z̈oñinacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jalla nii orazakaz Jesusaqui chiichic̈ha: —Wejt Yooz Tata, amqui honorchizam cjilalla. Arajpachquin z̈ejlñinacami tii muntuquiz z̈ejlñinacami amc̈ha mantiñamqui. Amqui humilde z̈oñinacz̈quiz chjojzaka tjaajinta tjeezamc̈ha. Zizñi z̈oñinacz̈quizimi intintazñi z̈oñinacz̈quizimi nii chjojzaka tjaajintanacami ana zizkatchamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yooz Tata, amiz̈ muntaqui nuz̈uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","‛Yooz Tata, tjapa amiz̈ ziztanacaqui wejtquiz tjaajinchamc̈ha. Ultimquiziqui anaz̈ jecmi wejr am Majch zumpacha pajc̈ha. Am alaja wejr zumpacha pajc̈ha. Niz̈aza anaz̈ jecmi am Yooz Ejp zumpacha pajc̈ha. Wejr alaja am zuma pajuc̈ha. Niz̈aza jakziltiz̈quiz wejrqui zizkatz pecac̈haja, jalla ninacazakaz am zuma pajasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anc̈hucqui jakziltat ana zumanacquiztan otchiz̈laj niiqui, wejtquizza macjatz̈ca. Niz̈aza jakziltat persun aztan Yooz watja irantiz otchiz̈laj niiqui, wejtquizza macjatz̈ca. Weril anc̈hucaquiz jeejzkatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Wejrqui pasinsis kuzziztc̈ha, niz̈aza humilde kuzziztc̈ha. Jalla niz̈tiquiztan weriz̈ tjaata kamaña catoka; niz̈aza wejt puntuquiztan zizñi cjee. Nekztan persun kuz jeejz wachaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Weriz̈ tjaata kamañaqui anac̈ha ch'ama, niz̈aza wejt manta paazqui cjez̈akazza. ");
INSERT INTO capNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tsjii jeejz tjuñquiziqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tan c̈hjacta zkalanac taypiranz̈ okatc̈ha. Tjaajinta z̈oñinacaqui c̈hjeri eecskatchic̈ha. Nekztan ninacaqui tric oz chjojlunaca kjajpz̈cu, tricu lujlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo z̈oñinacaqui jalla niz̈ta paañi cherz̈cu, Jesusiz̈quiz cjichic̈ha: —Chera, tii amiz̈ tjaajinta z̈oñinacaqui trabajla. Jeejz tjuñquiziqui niz̈ta trabajzqui uc̈hum lii quintrala. —Jalla nuz̈ chiican ujchiz jwes pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nekztanaqui Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui tuz̈ liichinc̈hucc̈ha, ¿anajaa? C̈hjeri eecznanaqui David cjita z̈oñiqui niiz̈ mazinacz̈tan tiz̈ta paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Niiqui Yooz timpluquin luzcu Yooz yujcquin nonz̈ta t'antanaca lujlchic̈ha. C̈hjul z̈oñimi anapantac̈ha permitta nii t'antac lujlzqui. Lii quintrala niiqui. Timplu jilirinacapankaz lulasac̈ha. Pero nii Davidzti lujlchipanc̈ha. Niz̈aza niiz̈ mazinacaqui nii t'anta lujlchizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Niz̈aza Moisés liiquiz tiz̈ta liichinc̈hucz̈, ¿ana jaa? Jeejz tjuñquiziqui timplu jilirinacaqui ana jeejz̈la. Jalla nuz̈ ana jeejztiquiztanaqui, ninacz̈tajapa anaz̈ ujchiz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Anc̈hucaquiz cjiwc̈ha. Tekz tsjiic̈ha timpluquiztan juc'ant chekanaqui. ");
INSERT INTO capNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Niz̈aza anc̈hucqui cjijrta Yooz taku ana intintazzinc̈hucc̈ha. Yooz taku tuz̈ cjic̈ha: “Wejrqui wilana jawkñi z̈oñinaca anal pecuc̈ha. Okzñi kuzziz z̈oñinacapan pecuc̈ha”. Tii Yooz taku intintaztasaz̈ niiqui, anaz̈ anc̈hucqui tii z̈oñinaca ujchiz jwes pectasac̈ha. Tii z̈oñinacaqui jaziqui anaz̈ uj paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrpanikal jeejz tjuñquizimi mantasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jalla nekztanaqui najwcchuc ojkz̈cu judío ajcz kjuyquiz luzzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jalla nicju tsjii z̈oñi z̈elatc̈ha kjara kjonchi. Tsjii quintra z̈oñinacaqui uj jwesjapa Jesusiz̈quiz pewczic̈ha tuz̈ cjican: —¿Jeejz tjuñquiziqui z̈oñi c̈hjetinz cjesaya, uz̈ anapan cjesaj? nuz̈ cjican pewczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesusaqui ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Jeejz tjuñquiziqui uuzac tujquiz tjojtsiz̈ cjesaz̈ niiqui, ¿kjaz̈a anc̈huczti tujquiztan uuza joozñi ana okasajo? ");
INSERT INTO capNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero z̈oñiqui uuziz̈quiztan juc'antiz̈ walc̈ha. Jalla niz̈tiquiztan jeejz tjuñquizimi anac̈ha lii quintra zuma paazqui. ");
INSERT INTO capNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jalla nekztanaqui Jesusaqui laa z̈oñz̈quiz cjichic̈ha: —Am kjara zjijca. Nekztan z̈ejtchi cjissic̈ha, nii tsjii kjara wiwuz̈ niz̈tapacha. ");
INSERT INTO capNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jalla nekztanaqui fariseo z̈oñinacaqui ulanz̈cu, Jesusiz̈ conzjapa kazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jalla nii zizcu Jesusaqui najwcchuc ojkchic̈ha. Niz̈aza muzpa z̈oñinacaqui Jesusiz̈quiz apzic̈ha. Jesusaqui tjapa nii apzñi laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Nekztan ninacz̈quiz mantichic̈ha, ana jecz̈quizimi Jesusiz̈ c̈hjetinñi puntuquiztan parlajo, nii. ");
INSERT INTO capNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jalla niz̈ta ojklaycan, Jesusaqui Isaías profetaz̈ cjijrta taku nuz̈quiz cumplissic̈ha. Yoozqui Isaiasquiz tuz̈ cjijrkatchic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Jalla tiic̈ha weriz̈ illzta z̈oñiqui, weriz̈ mantitacama ojklayñi z̈oñi. Jalla niiz̈quin kayazt'uc̈ha. Niiz̈ cjen cuntintutc̈ha wejrqui. Jalla nuz̈ cjic̈ha Yoozqui. Wejt Espíritu Santuqui niiz̈ kuzquiz cjequic̈ha. Niiqui yekja watjanacchiz z̈oñinacz̈quin Yooz liwriiñi taku paljayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Z̈oñinacz̈quizimi ana ch'aanaquic̈ha, niz̈aza ana kjawaquic̈ha. Calliran alto jorz̈tan ana paljayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tsjii tjuwanta cañami anaz̈ kjolaquic̈ha. Niz̈aza ch'aman asñi michami anaz̈ tjesaquic̈ha, niiz̈ ultimpacha legal mantiz tjuñicama. ");
INSERT INTO capNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Niiz̈ cjen yekja watjanacchiz z̈oñinacaqui zuma liwriiz tjuñi tjewznaquic̈ha”. Jalla nuz̈ Jesusiz̈ puntuquiztan Yooz takuqui cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jalla nekztanaqui tsjii laa z̈oñiqui Jesusiz̈quin chjichtatac̈ha. Nii z̈oñiqui zajraz̈ tantaz̈ cjen zuratac̈ha, niz̈aza ana chiiñitac̈ha. Jesusaqui nii z̈oñi c̈hjetinchic̈ha. Jalla niz̈tiquiztan cherñi chiiñi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jalla nuz̈ c̈hjetintiquiztan tjapa z̈oñinacaqui ispantichic̈ha tuz̈ cjican: —¿Tiij Davidz̈ majchmajtquiztan tjonñi cjesaya? ¿Tiipan Cristo cjesaya? ");
INSERT INTO capNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Nii nonz̈cu fariseo z̈oñinacaqui tuz̈ cjichic̈ha: —Tiiqui ana wal z̈oñikalala. Zajranacz̈ Beelzebú jilirz̈ aztankaz yekja zajranaca chjatkatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesusaqui ninacz̈ pinsitanaca zizzic̈ha, jalla niz̈tiquiztan ninacz̈quiz cjichic̈ha: —Jakzilta nacionamiz̈ partira partira t'akznaquiz̈ niiqui, niz̈aza t'aka t'aka kichasaquiz̈ niiqui, k'ala tjatantaz̈ cjequic̈ha. Tsjii watjamiz̈ niz̈aza tsjii kjuya familiamiz̈ niz̈ta t'aka t'aka cjisnaquiz̈ niiqui, anaz̈ tjurasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jalla niz̈ta irata Satanás diabluqui persun partira chjatkattasaz̈ niiqui, niipacha t'akztasac̈ha. Jalla nuz̈ t'akz̈tiquiztan niiz̈ mantiz azi anaz̈ tjurasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Anc̈hucqui wejt puntuquiztan cjiñc̈hucc̈ha, “Beelzebú diabluz̈ aztan zajranaca chjatkatc̈ha”. Jalla nuz̈ cjiñc̈hucc̈ha. Jalla nuz̈uz̈laj niiqui, ¿ject anc̈huca partira z̈oñinacz̈quiz azi tjaazjo, zajranaca chjatkatzjapajo? Jalla niz̈tiquiztan kjanapachaz̈ wejt puntuquiztan tsjii kjutñi chiichinc̈hucc̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wejrzti Yooz Espíritu Santuz̈ aztan zajranaca chjatkatiñc̈ha. Jalla niicz̈ cjic̈ha, Yooz mantiz timpu anc̈hucaquiz z̈catz̈inz̈quic̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‛Tsjilla cjesac̈ha. Anaz̈ jecmi tsjii azziz z̈oñz̈ kjuyquiziqui luzi atasac̈ha; niz̈aza anaz̈ niiz̈ kinakunacami jwesi atasac̈ha, ima c̈hejlcanaqui. Nii c̈hejlz̈cu, nekztan tjapa kinakunaca jwesi luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‛Jecc̈halaj ana wejt favora, niiqui wejt quintrac̈ha. Niz̈aza jequit wejttan chica Yooz kjutñi z̈oñinaca ana macjatskatc̈haja, jalla niiqui z̈oñinacaz̈ Yoozquiztan tirkatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","‛Jazic anc̈hucaquiz chiyuc̈ha, tuz̈ cjican: tjapa ujnacami niz̈aza tjapa ana zum takunacami pertuntaz̈ cjesac̈ha. Pero jakzilta z̈oñit Yooz Espíritu Santuz̈ quintra chiyac̈haj niiqui, anaz̈ pertuntaz̈ cjesac̈ha. Nii z̈oñiqui wiñaya ujchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jakzilta z̈oñit wejt quintra chiyac̈haj niiqui, pertuntaz̈ cjesac̈ha. Pero jakzilta z̈oñit Yooz Espíritu Santuz̈ quintra chiyac̈haj niiqui, anaz̈ pertuntaz̈ cjequic̈ha. Nii z̈oñiqui wiñaya ujchiz cjequic̈ha; anawira pertuntaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nekztan Jesusaqui tjaajinchic̈ha, tuz̈ cjican: —Zuma muntiz̈laj niiqui, zuma frutaz̈ pookc̈ha. Niz̈aza ana zuma muntiz̈laj niiqui, ana zuma frutaz̈ pookc̈ha. Jalla niz̈tiquiztan muntiqui niiz̈ frutquiztan pajza, zuma ana zuma, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Zkoraz̈takaz anc̈hucqui, ana zum z̈oñc̈hucc̈ha. ¿Kjaz̈z̈a anc̈hucqui zumanaca chiyasajo? Anc̈huca kuzquiz pinsitaqui ana zuma parijula. Jaziqui anc̈hucc̈ha anazumanacapan chiiñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tsjii zuma z̈oñiqui zuma chiic̈ha, niiz̈ zuma kuzquiztan. Nizaza tsjii ana zum z̈oñizti ana zumapaz̈ chiic̈ha, niiz̈ ana zuma kuzquiztan. Jaknuz̈t kuzquiz pinsic̈haja, jalla nuz̈ chiic̈ha z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anc̈hucaquiz cjiwc̈ha, juyzu casticz tjuñquiziqui zapa mayni cwinta tjaastanc̈ha, tjapa ana zuma chiitanacami. ");
INSERT INTO capNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anc̈hucaz̈ chiitiquiztan jama jusjitaz̈ cjequic̈ha, ujchiz cjec̈haja, ana ujchiz cjec̈haja, nuz̈. ");
INSERT INTO capNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jalla nekztanaqui yekjap fariseo z̈oñinacaqui lii tjaajiñi maestrunacz̈tan Jesusiz̈quiz cjichic̈ha: —Maestro, am milajru paañi cherz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesusaqui ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Ana zum z̈oñinacc̈hucc̈ha. Ana Yoozquin kuzziz z̈oñinacc̈hucc̈ha. ¿Kjaz̈t tsjii milajru mayc̈ha, zinalaz̈takaz? Jonáz cjita profetz̈ zinala, niikaz anc̈hucaquiz tjaata cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonasqui pajk ch'iz pjuchquiz z̈ejlchic̈ha c̈hjep majz̈tan c̈hjep aramz̈tan. Jalla niz̈ta irata wejrqui tii yok koztan kamac̈ha c̈hjep majz̈tan c̈hjep aramz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Juyzu tjuñquiziqui, jalla nii casticz tjuñquiziqui Nínive wajtchiz z̈oñinacaqui jacatataquic̈ha. Nekztan ninacaqui tii timpuquiz kamñi z̈oñinacz̈ uj tjeeskataquic̈ha. Jonás Yooz taku paljaytiquiztan ninacaqui Yoozquin kuzziz cjissic̈ha. Pero wejrtc̈ha Jonasquiztan juc'ant chekanaqui. Tii timpuquiz kamñi z̈oñinacazti anaz̈ Yoozquin kuz tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Niz̈aza casticz tjuñquiziqui tsjaa waruta maatak jilirqui jacatataquic̈ha. Nekztan naaqui tii timpuquiz kamñi z̈oñinacz̈ uj tjeeskataquic̈ha. Naaqui najwkta yokquiztan tjonchinc̈ha Salomonz̈tan zali, niz̈aza niiz̈ zuma razunchiz taku nonzñi. Pero tejkz wejrtc̈ha Salomonquiztan tsjan juc'ant chekanaqui. Pero tii timpuquiz kamñi z̈oñinacazti wejt taku anaz̈ nonz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","‛Tsjii zakal quint'asac̈ha. Tsjii zajraqui z̈oñz̈quiztan ulanz̈cu kjoñ yokaran ojklayñitac̈ha, jeejzjapa kjurcan. Ana jeejz watz̈cuqui, kuzquiz pinsichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Jaziqui wejr quepaka jakziquiztan ulanzquituc̈haja, jalla nicju”. Jalla nuz̈ quejpz̈cu nii z̈oñz̈tan wilta zalchic̈ha. Nii z̈oñiqui pewz̈ta kjuyaz̈takaztac̈ha, cuza z̈cayi, azquitz̈ta, pero laachitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jalla nuz̈ zaltiquiztan nii zajraqui pakallak juc'ant anawali zajranaca zjijqui ojkchic̈ha. Zajranaca zjijcz̈cu, tjappacha nii z̈oñz̈ kuzquiz luzzic̈ha. Jalla niz̈tiquiztan nii z̈oñiqui juc'ant ana waliz̈ cjissic̈ha tuquita kamzquiztan. Jalla niz̈ta irata tii ana zum z̈oñinacz̈quiz wataquic̈ha. —Jalla nuz̈ quint'ichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesusaqui iyapanz̈ z̈oninacz̈quiz chiyatc̈ha. Jalla nuz̈ chiyan niiz̈ maaqui lajknacz̈tan irantiz̈quichic̈ha. Z̈oñinacz̈ tjiiquin z̈elan, niiz̈tan parlis pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tsjii z̈oñiqui Jesusiz̈quiz mazzic̈ha, tuz̈ cjican: —Am maa lajknacz̈tanpacha tii tjiiquiz z̈ejlc̈ha. Am kjawz̈, amtanz̈ parlis pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesusaqui mazñi z̈oñz̈quiz kjaazic̈ha, tuz̈ cjican: —¿Ject wejt maaya? ¿Ject wejt jilanacaya? ");
INSERT INTO capNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jalla nuz̈ chiiz̈cu tjaajinta z̈oñinacz̈ kjutñi kjarz̈tan tjeezic̈ha, niz̈aza cjichic̈ha: —Tinacac̈ha wejt maami, wejt jilanacami. ");
INSERT INTO capNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jecnacami wejt arajpach Yooz Ejpz̈ kuzcama kamc̈haja, jalla ninacac̈ha wejt jilanacami, wejt cullaquinacami, wejt maami. ");
INSERT INTO capNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nii noojpacha Jesusaqui kjuyquiztan ulanchic̈ha. Kot kjutñi ojkz̈cu kot atquiz julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jakziquin nii z̈elatc̈haja, jalla nicju z̈oñinacaqui walja ajczic̈ha. Jalla niz̈tiquiztan tjaajinzjapa tsjii warcuquiz luzzic̈ha. Nekz julzic̈ha. Tjappacha z̈oñinacaqui kot at tjiiquiz z̈ejlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jalla nekztanaqui Jesusaqui z̈oñinacz̈quiz walja Yooz puntunaca tjaajinchic̈ha, tjapaman quintunacz̈tan. Jalla nuz̈ tjaajincan tuz̈ cjichic̈ha: —Tsjii z̈oñiqui zkal c̈hjaqui tewcchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Zkala c̈hjaccan, parti simillaqui jicz latuquiz tjojtsic̈ha. Nekztan wez̈lakaz nii simillac ilziqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Parti simillazti maz yokaran tjojtsic̈ha. Nekziqui anaz̈ wacchi pjila z̈elatc̈ha. Nekztan koloculla pjila z̈elan ratulla jeczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jalla nuz̈ jecz̈tiquiztan sii kjakiqui ujchic̈ha; koluc sep'allchiztac̈ha nekztan. Ratulla kjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Parti simillazti ch'ap ch'ap yokaran tjojtsic̈ha. Ch'apinacakazza ancha pajkchiqui, niz̈aza atipchiqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Parti simillazti zuma yokquiz tjojtsic̈ha. Nekztan zuma pookchic̈ha. Yekjap simillaqui patac c̈hjerchiz zapa zkal ozquiz pookchic̈ha; niz̈aza yekjap simillaqui sojta tuncan c̈hjerchiz zapa zkal ozquiz pookchic̈ha; yekjap simillaqui quinsa tuncan c̈hjerchiz pookchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jakziltaz̈laja nonzñi cjuñchiz niiqui, nonz̈la. ");
INSERT INTO capNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jalla nekztanaqui tjaajinta z̈oñinacaqui Jesusiz̈quiz macjatchic̈ha, niz̈aza pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan am niz̈ta quintunacz̈tankaz z̈oñinacz̈quiz tjaajinya? ");
INSERT INTO capNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesusaqui kjaazic̈ha tuz̈ cjican: —Arajpach Yooz mantuquiz kamz puntuquiztan ch'aman intintazzuca quintunacz̈tan tjaajnuc̈ha. Anc̈hucaquizkaz Yoozqui zizkatz munc̈ha nii puntunacquiztanaqui. Parti z̈oñinacz̈quiziqui Yoozqui ana zizkatz munc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Jequit zizac̈haja, jalla niiz̈quiziqui juc'ant tjaajinz tjaataz̈ cjequic̈ha. Nekztan zumpacha zizñiz̈ cjequic̈ha. Jequit ana zizac̈haja, jalla niiz̈ kuzquiztan kjañtaz̈ cjequic̈ha nii ana intintaztanacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jalla niz̈tiquiztan wejrqui tiz̈ta quintunacz̈tan paljayuc̈ha. Parti z̈oñinacaqui weriz̈ paata cherz̈cumi ana cherchiz̈takaz cjissa. Niz̈aza weriz̈ chiita taku nonz̈cumi, ana nonzñiz̈takaz tucc̈ha; ana intintazñi z̈oñinacac̈ha ninacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Jalla niz̈ta cjissiz̈ cjen, Isaías profetz̈ taku cumplissa. Jalla tuz̈ Isaiasqui cjijrchic̈ha: “Anc̈hucqui nonznaquic̈ha. Nonz̈cu, ana intintazaquic̈ha. Niz̈azaz̈ cheraquic̈ha. Cherz̈cu, anaz̈ tantiyasaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tii z̈oñinacz̈ kuznacaqui chojru cjissic̈ha; ana zumaz̈ nonz̈a. Niz̈aza c̈hjujcchiz cjenami ana cherzñi atc̈ha, zur z̈oñiz̈takaz. Jalla nuz̈ cjisnaquic̈ha, ana cherzñi cjisjapa, niz̈aza ana nonzñi cjisjapa, niz̈aza ana kuzquiz intintiñi cjisjapa, niz̈aza ana wejtquin macjatzjapa. Ana wejtquin tjontiquiztan, ana liwriita cjesac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‛Anc̈hucc̈ha cuntintu. Anc̈hucqui cherzñi z̈oñinacc̈hucc̈ha. Niz̈aza nonzñi z̈oñinacc̈hucc̈ha. Anc̈hucc̈ha Yooziz̈ wintiz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Weraral cjiwc̈ha. Wacchi profetanacami niz̈aza zuma kuzziz z̈oñinacami anc̈hucaz̈ chertanaca cherz zakaz pecatc̈ha. Pero ana cherchic̈ha. Niz̈aza anc̈hucaz̈ nonz̈tanaca nonz zakaz pecatc̈ha. Pero ana nonzic̈ha. Anc̈huczti cherchinc̈hucc̈ha, niz̈aza nonzinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jazic anc̈hucz̈ nonz̈nalla. Jalla tuz̈ cjic̈ha nii zkala c̈hjacz quintuqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nii jicz latuquiz tjojtsi simillaqui jalla tiz̈ta z̈oñinacac̈ha. Ninacaqui arajpach Yooz mantuquiz kamz puntuquiztan nonzcanpacha, ana intintazza. Diabluqui ninacz̈ kuzquiz tjonz̈cu, ninacaz̈ intintazta kjañc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Niz̈aza nii maz yokquiz tjojtsi simillaqui jalla tiz̈ta z̈oñinacac̈ha. Ninacaqui Yooz taku nonz̈cu nii ora cuntintuz̈ nonz̈a; cuntintuz̈ catokc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ninacaqui ana tjapa kuztan catoktiquiztan zkoluc zep'ichiz zkalaz̈takazza. Jalla niz̈tiquiztan ana tjuraquic̈ha. Yooz taku criichiz̈ cjen, sufraquic̈ha; niz̈aza chjaawjkattaz̈ cjequic̈ha. Jalla nekztan orallaz̈ quejpsnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Niz̈aza nii ch'ap yokquiz tjojtsi simillaqui jalla tiz̈ta z̈oñinacac̈ha. Ninacaqui Yooz taku nonz̈cu, catokc̈ha. Pero nekztan juc'anti kuz tjaac̈ha tii muntu cusasanacquiz. Wali jiru kamzpanz̈ pecc̈ha. Persun kuzquiz pectiquiztanaqui Yooz taku tjatz̈a ninacz̈ kuzquiz. Jaziqui ana zuma kamc̈ha; ana pookñi zkalaz̈takaz kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Niz̈aza nii zum yokquiz tjojtsi simillaqui jalla tiz̈ta z̈oñinacac̈ha. Ninacaqui Yooz taku nonz̈cu, zuma tjapa kuz catokc̈ha; zuma intintic̈ha. Jalla niz̈tiquiztan zuma kamañchiz cjissa, zuma pookchi zkalaz̈takaz. Nii zuma pookñi z̈oñinacaqui zuma kamañchizpanz̈ cjissa, jaknuz̈t tsjii simillaqui patac c̈hjerchiz, sojta tunc c̈hjerchiz, quinsa tunc c̈hjerchiz pookc̈haja, jalla niz̈tac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Tsjii quintuz̈tan quint'ichic̈ha Jesusaqui, tuz̈ cjican: —Arajpach mantiñi Yooz puntuqui jalla tuz̈uc̈ha. Tsjii z̈oñiqui zuma similla c̈hjacchic̈ha zkal yokquiz. ");
INSERT INTO capNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tjapa niiz̈ kjuychiz z̈oñinacaz̈ tjajan, tsjii quintra z̈oñiqui tjonchic̈ha. Nekztan zkalquiz ana wal pastunaca c̈hjacchic̈ha. Jalla nuz̈ ana wal c̈hjacz̈cu, ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Nii tric zkala jecz̈tan, chicapacha pajkchic̈ha nii ana wal pastunacaqui. Niz̈aza pizcpacha pookchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jalla nii cherz̈cu, nii piyunanacaqui patrunz̈quin mazñi ojkchic̈ha. Niiz̈quin mazzic̈ha, tuz̈ cjican: “Wejt Patruna, amiz̈ c̈hjacta simillaqui zumaz̈laj niiqui, ¿jakziquiztan tii ana wal simillanaca pajkchitaya?” ");
INSERT INTO capNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Patrunaqui kjaazic̈ha, tuz̈ cjican: “Tsjii quintra z̈oñiqui niz̈ta paac̈hani”. Jalla nekztanaqui piyunanacaqui pewczic̈ha tuz̈ cjican: “¿Wejrnacqui nii ana wal pastunaca k'achasaya?” ");
INSERT INTO capNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Nii patrunaqui cjichic̈ha: “Ana k'achaquic̈ha. Ana wal pastu k'achcan yekjap tricz̈tanpachaz̈ k'achnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Antiz pizcpacha pajkla, cujich timpu tjonzcama. Jalla nekztan wejt piyunacnacaqui cuchantaz̈ cjequic̈ha. Ninacaqui anawal pastunaca ricujaquic̈ha. Nekztan kojchquiz c̈hejlznaquic̈ha ujzjapa. Jalla nekztanaqui tricuz̈ ricujz̈cu, wejt tiric yaaz kjuyquiz majcznaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Niz̈aza Jesusaqui tsjii puntuzakaz quint'ichic̈ha, tuz̈ cjican: —Arajpach Yooz mantiz puntuqui tuz̈uc̈ha. Tsjii z̈oñiqui niiz̈ yokquiz mostas similla c̈hjacchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mostas simillaqui parti simillquiztan juc'ant zkoltallac̈ha. Jalla nuz̈ cjenami pajkz̈cuqui tjapa zkalanacquiztan tsjan pakjic̈ha. Pajk muntiz̈takaz cjissa. Nekztan wez̈lanacaqui nii mostas munti itzquiz tjuraz̈ tjacñiz̈ tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesusaqui tsjii quint'ichizakazza, tuz̈ cjican: —Arajpach Yooz mantiz puntuqui jalla tuz̈uc̈ha. Tsjaa maatak z̈onqui c̈hjep medida tupz̈cu nii liwatura jac'uquiz utchinc̈ha; niz̈aza t'ajzinc̈ha, tjapa nii t'anti maza tsijtkatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Tjapa tjaajintanacami quintunacz̈tan paljaytatac̈ha. Arajpach Yooz puntuquiztan tjaajincan, Jesusaqui quintunacz̈tankaz tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jalla nuz̈ tjaajincan, Jesusaqui tuquita profetaz̈ chiita takuqui cumplissic̈ha. Profetaqui jalla tuz̈ cjijrchic̈ha: “Quintunacz̈tankaz chiyuc̈ha. Tii muntu kallantitiquiztan weriz̈ chiita tjaajintanaca ana intintazzucac̈ha. Jalla nii ana intintaztanaca paljayuc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jalla niz̈ta puntunaca chiiz z̈erz̈cu, Jesusaqui z̈oñinacz̈quiztan ojkchic̈ha; kjuyquiz luzzic̈ha. Jalla nicju niiz̈ tjaajinta z̈oñinacaqui macjatchic̈ha, tuz̈ cjican: —Nii zkal yokquiz c̈hjacta ana wal pastu, jalla nii puntuquiztan wejtnacaquiz intintazkatalla. ");
INSERT INTO capNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jalla nekztanaqui Jesusaqui intintazkatchic̈ha tuz̈ cjican: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrtc̈ha zuma similla c̈hjaciñtqui. ");
INSERT INTO capNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Nii zkal yokaqui tii muntuc̈ha. Nii zuma zkalanacaqui cjic̈ha, arajpach Yooz mantuquiz kamñi z̈oñinacac̈ha nii. Ana zuma pastunacaqui diabluz̈ mantuquiz kamñi z̈oñinacac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nii ana wal pastu c̈hjacñimi diablupachac̈ha. Zkala ajz timpuqui tii muntu tucuz̈inz timpuc̈ha. Nii zkala ajzñi piyunanacaqui Yooz anjilanacac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Jaknuz̈t nii ana wal pastunaca ricujz̈cu, ujquin ujzjapa tjojttaz̈ cjec̈haj niiqui, jalla niz̈ta irataz̈ wataquic̈ha tii muntu tucuz̈inz̈can, ultim juyzuz̈ nekz. ");
INSERT INTO capNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Jalla nii oraqui wejt anjilanaca cuchanz̈cac̈ha, tii muntuquiztan tjapa ana wal z̈oñinaca ricuji. Wejt anjilanacaqui tjapa ujnaca paakatñi z̈oñinacami, niz̈aza tjapa ana wali paañinacami ricujaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Jalla nuz̈ ricujz̈cu, infiernuquin tjojttaz̈ cjequic̈ha kjakchi jurnuquiztakaz. Jalla nekzi anchaz̈ kaaquic̈ha, niz̈aza waljaz̈ iz̈ke kjojznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yooz kuzcama kamñi z̈oñinacazti arajpach Yooz wajtquiz z̈elaquic̈ha, tjuñiz̈takaz kjancan. Jakziltat nonzñi cjuñchizc̈hucz̈laja, nonz̈na. ");
INSERT INTO capNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Arajpach Yooz mantuquiz kamañaqui jalla tuz̈uc̈ha. Tsjii yokquiz pajk paaz c̈hjojz̈tatac̈ha. Tsjii z̈oñiqui nii c̈hjojz̈ta paaz wajtchic̈ha. Nii wajtz̈cu, wilta c̈hjojzic̈ha nekzpacha. Ancha cuntintutac̈ha. Nekztanaqui tjapa niiz̈ cusasanaca tuyi ojkchic̈ha. Niiz̈ cusasanaca tjuyz̈cu, nii yoka kjaychic̈ha. Jalla nuz̈uc̈ha arajpach Yooz kamañquiz luzqui. Nii kamañaqui c̈hjulquiztanami juc'anti valorchizza. ");
INSERT INTO capNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Niz̈aza arajpach Yooz mantuquiz kamañaqui tuz̈uc̈ha. Tsjii tintichiz z̈oñiqui zuma valorchiz perlanaca kjayi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nekztan tsjii ancha zuma valorchiz perla wajtchic̈ha. Jalla nekztanaqui tjapa niiz̈ cusasanaca tuychic̈ha, nii perla kjayzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Niz̈aza arajpach Yooz mantiz puntuqui tuz̈uc̈ha. Tsjii ch'iz tanñi z̈oñinacaqui niiz̈ ch'iz tanz pajk kotquiz tjojtzic̈ha. Jalla nuz̈ tjojtz̈tiquiztan tjapaman ch'iznaca tanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nekztan ch'iz tanz chjijpztanaqui, kot at tjiiquin jwessic̈ha. Jalla nekztanaqui ninacaqui nijwc julz̈cu, ch'iz pjalzic̈ha. Zuma ch'iznaca canastiquiz yaazic̈ha. Ana zuma ch'iznacazti tjojtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jalla niz̈ta irataz̈ tii muntu tucuz̈inz̈tanaqui wataquic̈ha. Anjilanacaqui ulanz̈caquic̈ha z̈oñinaca pjali, zuma z̈oñinaca ana zuma z̈oñinaca, nii. ");
INSERT INTO capNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nii ana zuma z̈oñinacaqui infiernuquin tjojttaz̈ cjequic̈ha tsjii kjakchi jurnuquiztakaz. Jalla nekzi ancha kaaquic̈ha, niz̈aza iz̈ke kjojaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jalla nekztanaqui Jesusaqui z̈oñinacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Anc̈hucqui tjapa tii weriz̈ chiita quintunaca intintiya? Nii z̈ejlñi z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, wejrnacqui intintasuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Nekztan Jesusaqui cjichic̈ha: —Tsjii lii tjaajiñi maestruqui arajpach Yooz mantuquiz cjisnaquiz̈ niiqui, tsjii kjuya patrunaz̈takaz cjissa. Jalla nuz̈ cjistiquiztan niiz̈ ziztanacquiztan zuma tjaajintanaca zizkatasac̈ha, tuquita tjaajintami niz̈aza anzta tjaajintami. ");
INSERT INTO capNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jalla tii arajpach Yooz mantiz puntuquiztan chiiz z̈erz̈cu, jalla nekztan Jesusaqui ojkchic̈ha, niiz̈ persun yoka. ");
INSERT INTO capNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jalla nicju irantiz̈cu, ajcz kjuyquiz tjaajñi kallantichic̈ha. Nii nonz̈ñi z̈oñinacaqui ispantichic̈ha tuz̈ cjican: —¿Jakziquin tii z̈oñizti ancha tiz̈tanaca zizñi cjissitajo? ¿Kjaz̈t ancha tiz̈ta milajrunaca paasajo? ");
INSERT INTO capNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Carpinteroz̈ majchkazza tiiqui. Tiiz̈ maaqui María cjitic̈ha. Niz̈aza tiiz̈ lajknacaqui Jacoboc̈ha, Josec̈ha, Simonac̈ha, niz̈aza Judassa. ");
INSERT INTO capNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Niz̈aza tiiz̈ cullaquinacaqui uc̈humnacz̈tan kamc̈ha. Jalla niz̈tiquiztan, ¿jakziquin tiiqui tiz̈tanaca zizzitajo? ");
INSERT INTO capNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jalla niz̈ta pinsitiquiztan ninacaqui Jesusiz̈japa quintra cjissic̈ha. Pero Jesusaqui ninacz̈quiz cjichic̈ha: —Persun wajtchiz z̈oñinacami, niz̈aza persun kjuychiz z̈oñinacami tsjii Yooziz̈ uchta profetz̈quiz ana rispitc̈ha. Parti z̈oñinacazti niiz̈quiz rispitc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jalla niz̈tiquiztan nekzi ana ancha milajrunaca paachic̈ha, nii wajtchiz z̈oñinacaqui Jesusiz̈quiz ana criichiz̈, nekztan. ");
INSERT INTO capNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jalla nii oranaca Herodes cjita jiliriqui Jesusiz̈ quintu nonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Jalla nuz̈ nonz̈cu, niiz̈ piyunanacz̈quiz cjichic̈ha: —Juan Bautistala tiiqui. Ticziquiztan jacatatchila. Jalla niz̈tiquiztan walja milajarunaca paazjapa poderchizlani. ");
INSERT INTO capNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jalla nuz̈ tsucchic̈ha Herodes jiliriqui. Tuquiqui Herodesqui Juan tankatchic̈ha. C̈hejlz̈cu carsilquin chjitchic̈ha. Jalla nuz̈ paachic̈ha, niiz̈ tjunaz̈ cjen. Niiz̈ tjunqui Herodías cjitic̈ha. Tuquiqui naaqui niiz̈ jilz̈ tjuntac̈ha. Felipe cjitatac̈ha Herodes jilaqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jalla niz̈ta anawali zalziz̈ cjen, Juanqui Herodiz̈quiz chiiz̈inchicha tuz̈ cjican: —Naa maatak z̈on anaz̈ am tjun cjichuca. Felipiz̈ tjunc̈ha naaqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Jalla nuz̈ chiiz̈intiquiztan Herodes Juan conz pecatc̈ha. Pero z̈oñinaca ekscu ana atchic̈ha. Tjapa z̈oñinacaqui Juanz̈quiz rispitchic̈ha tuquita Yooz taku parliñi profetaz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nii Herodesqui niiz̈ persun cumpleañ tjuñquiziqui pjijsta paachic̈ha. Jalla nuz̈ pjijsta paan, naa Herodías majtqui ulanz̈quichinc̈ha, invittaz̈ z̈oñinacz̈ yujcquiz tsati. Jalla nuz̈ tsatan ancha justassic̈ha Herodesqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Zuma tsattiquiztan Herodesqui taku onzic̈ha, tuz̈ cjican: —C̈hjulum mayc̈haja, jalla nii tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ima mayan maaqui mataquiz mantichinc̈ha, Juanz̈ acha mayzjapa. Jalla naaz̈a maaz̈ chiita takucama Herodesquiztan maychinc̈ha, tuz̈ cjican: —Tsjii chuwquiz Juan Bautistaz̈ acha tjaalla. ");
INSERT INTO capNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jalla nuz̈ maytiquiztan Herodesqui llact'azzic̈ha. Pero invittaz̈ z̈oñinacaz̈ nonznan taku onzic̈ha. Jalla niz̈tiquiztan naaz̈a maytacama mantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Juanqui carsilquiz z̈elatc̈ha. Jalla nijwc cuchanchic̈ha, Juanz̈ acha pooti. ");
INSERT INTO capNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jalla nekztanaqui tsjii chuwquiz acha zjijcz̈cu, naaquiz tjaatatac̈ha. Nekztan naaqui maaquinz̈ tjaachinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jalla nii quintu nonz̈cu, Juanz̈ tjaajinta z̈oñinacaqui Juanz̈ curpu chjichi tjonchic̈ha. Nekztanaqui nuz̈ chjichcu niiz̈ curpu tjatzic̈ha. Jalla nuz̈ tjatz̈cu, Jesusiz̈quin mazñi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nii quintu nonz̈cu Jesusaqui najwk ojkchic̈ha, ana z̈oñi z̈ejlz̈ yokquin. Warcuquiz ojkchic̈ha. Pero z̈oñinacaqui nuz̈ ojkchi quintu nonchic̈ha. Jalla nekztanaqui ninacaqui nii yokaranpacha wajtanacquiztan ulanchic̈ha. Jesusiz̈quin wilta zali kjojchin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Warcuquiztan ulanz̈cu Jesusaqui tama z̈oñinaca cherchic̈ha. Jalla nuz̈ cherz̈cu niiz̈ kuzquiz sint'ichic̈ha ninacz̈tajapa. Nekztan zjijcta laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Waj zezi cjisnan niiz̈ illzta z̈oñinacaqui Jesusiz̈quin tjonchic̈ha, tuz̈ cjican: —Waj zezilla. C̈hjeri pecc̈ha. Tii yokquiziqui anaz̈ c̈hjeri z̈ejl-la. Jalla niz̈tiquiztan tii z̈oñinaca cutzna. Okaj cjee, joch kjuyaran c̈hjeri kjayz̈cumi lulac̈hani tinacacni. ");
INSERT INTO capNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesusaqui ninacz̈quiz cjichic̈ha: —Anaz̈ cuchta cjesac̈ha. Anc̈hucaz̈ c̈hjeri tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nekztanaqui ninacaqui kjaazic̈ha, tuz̈ cjican: —Wejtnacalta ana lujlz c̈hjeri z̈ejlc̈ha. Pjijska t'antalla pizc ch'iztankaz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesusaqui ninacz̈quiz cjichic̈ha: —Nii c̈hjeri wejtquiz zjijca. ");
INSERT INTO capNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jalla nekztanaqui Jesusaqui z̈oñinacz̈quin mantichic̈ha, pasturan julzna cjee. Jalla nuz̈ julzkatz̈cu nii pjijska t'anta nii pizc ch'iz persun kjarz̈tan tanzic̈ha. Tanz̈cu tsewcchuc arajpach kjutñi cherzic̈ha, niz̈aza Yooz Ejpz̈quin gracias cjican chiichic̈ha. Nekztanaqui t'anta kjolz̈cu tjaajinta z̈oñinacz̈quiz tojunchic̈ha. Nekztan ninacaqui parti z̈oñinacz̈quin partir paychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","T'antanaca ch'iznaca lujlz̈cu liwjpacha nii z̈oñinacaqui chjekchi cjissic̈ha. Niz̈aza nii t'antiquiztan nii ch'iznacquiztan z̈ejtchinacaqui tuncapan canasta chjijpi ricujtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jalla nii t'anta ch'iz lujlchi z̈oñinacaqui pjijska warank luctakanacatac̈ha. Maatakanacami ocjalanacami ana kantatac̈ha nii oraqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nekztanaqui Jesusaqui niiz̈ tjaajintanaca warcuquiz luzkatchic̈ha, niiz̈ tuqui kota kakjayajo tsjii latu kotquin irantizcama. Jesusazti nii z̈ejlñi z̈oñinacz̈quiz persun kjuyquin okaj cjican nijwctan najwkchuc cuchanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jalla nuz̈ cuchanz̈cu Jesusaqui curulla yawchic̈ha, zinalla Yooz Ejpz̈tan parlisjapa. Jalla nuz̈ mayizan ween cjissic̈ha. Nicju zinatac̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nii oraqui niiz̈ tjaajinta z̈oñinacaqui kotz̈ taypiquin okatc̈ha. Tjamiqui warcuz̈ quintra walja tjamatc̈ha. Niz̈aza kjaz ljojkimi warcu waljaz̈ aytinquiskatatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wali chawc kjantati Jesusaqui ninacz̈quin z̈catz̈inchic̈ha, kjaz juntuñ ojkcan. ");
INSERT INTO capNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Niiz̈ tjaajinta z̈oñinacaqui, Jesusa kjaz juntuñ tjoñi cherz̈cu, ancha tsucchic̈ha, niz̈aza kjawchic̈ha, tuz̈ cjican: —Cuntinaz̈lani —cjican kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ninacaz̈ kjawan Jesusaqui ninacz̈quiz paljayz̈quichic̈ha, tuz̈ cjican: —Tjup kuzziz cjee. Wejrpanc̈ha. Anaz̈ tsuca. ");
INSERT INTO capNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nekztanaqui Pedruqui paljaychic̈ha, tuz̈ cjican: —Wejt Jiliri, amz̈laj niiqui, wejr kjawznalla kjaz juntuñ ojkzjapa am irantiscama. ");
INSERT INTO capNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesusaqui niiz̈quiz cjichic̈ha: —Pichalla amqui. Nekztanaqui Pedruqui warcuquiztan ulanz̈cu, kjaz juntuñ oki kallantichic̈ha, Jesusa jakziquin tjenatc̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nii walja tjamiz̈ cjen tsucchic̈ha. Tsucz̈cu, kjazquiz luzi kallantichic̈ha. Nekztan kjawchic̈ha, tuz̈ cjican: —Wejt Jiliri, wejr yanapalla, wejr z̈ejtkatalla. ");
INSERT INTO capNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nii orapacha Jesusaqui Pedruz̈ kjara tanzic̈ha, niz̈aza niiz̈quiz cjichic̈ha: —Ancha upa kuzzizamc̈ha amqui. ¿Kjaz̈tiquiztan am kuz turwayskatchamtaya? ");
INSERT INTO capNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ninacaz̈ warcuquin luztan, tjamiqui zekchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jalla nii cherz̈cu warcuquiz z̈ejlñi z̈oñinacaqui Jesusiz̈ yujcquiz quillzic̈ha, tuz̈ cjican: —Chekapan werara Yooz Maatimkalala amqui. ");
INSERT INTO capNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jalla nuz̈ kota kajkz̈cu, Genesaret cjita yoka irantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nii yokchiz z̈oñinacaqui Jesusa pajchic̈ha. Jalla nekztan “Jesusa tekz z̈ejlc̈ha”, cjican liwj nii yokaran mazmazzic̈ha. Nii quintu maztiquiztan tjapa laanaca zjijcchic̈ha, jakziquin Jesusa z̈elatc̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nii z̈oñinacaqui Jesusiz̈quiz walja rocchic̈ha, tuz̈ cjican: —Am zquit puntalla mekaz lanzkatz̈inalla. Tjapa lanzñi z̈oñinacaqui z̈ejtchi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jalla nekztanaqui tsjii kjaz̈ fariseo z̈oñinacaqui niz̈aza tsjii kjaz̈ lii tjaajiñi maestrunacz̈tanpacha Jesusiz̈quiz macjatchic̈ha. Ninacaqui Jerusalén wajtquiztan tjonchic̈ha. Jesusiz̈quiz pecunchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Kjaz̈tiquiztan amiz̈ tjaajintanacaqui uc̈hum tuquita atchi ejpnacz̈ custurumpi ana cazjo? Ana kjara awjz̈cu, lujl-la. ");
INSERT INTO capNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Pero Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Anc̈huczti, ¿kjaz̈tiquiztan Yooz mantita lii ana cazjo? Nii lii caz cjenpacha persun custurumpinacakaz paala anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yoozqui tuz̈ cjichic̈ha: “Am maa ejpmi rispitaquic̈ha”. Niz̈aza cjichic̈ha: “Jequit persun maa ejpz̈ quintra chjaawjkatac̈haja, jalla niiqui contaj cjila”. ");
INSERT INTO capNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero anc̈huczti tuz̈ tjaajiñc̈hucc̈ha: Z̈oñiqui persun maa ejpz̈quin chiyasac̈ha, tuz̈ cjican: “Am anal yanapasac̈ha. Tjapa wejt cusasanaca Yoozquin tjaatac̈ha nekztan”. ");
INSERT INTO capNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jequit niz̈ta chiyac̈haj niiqui, niiz̈ persun maa ejpz̈quiz anaz̈ yanapchuca cjesac̈ha. Jalla nuz̈ tjaajincan anc̈hucqui Yooz mantita ana walkatchinc̈hucc̈ha, persun custurumpi jarukaz ojkzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ana wal kuzziz z̈oñinaca. Isaías cjita profetaqui anc̈huca puntuquiztan zuma kjana cjijrchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Tii z̈oñinacaqui atz̈tankaz wejtquiz rispitc̈ha. Pero tinacz̈ ultim kuzzti wejtquiztan az̈quinc̈ha. Niz̈aza wejr anaz̈ rispitc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Tinacaqui inakaz wejtquin custurumpi paac̈ha. Tinacz̈ tjaajintanacaqui z̈oñiz̈ mantitakazza”. ");
INSERT INTO capNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jalla nekztanaqui Jesusaqui z̈oñinaca kjawzic̈ha, niz̈aza tuz̈ cjichic̈ha: —Nonz̈na, niz̈aza intintazñi kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Anaz̈ zawnctan kjuylchuc z̈oñz̈ atquiz luzñiqui uj cjesac̈ha z̈oñz̈quiziqui. Antiz z̈oñz̈ atquiztan ulanñi, jalla niiz̈ uj cjesac̈ha z̈oñz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jalla nuz̈ chiitiquiztan Jesusiz̈ tjaajinta z̈oñinacaqui niiz̈quin macjatchic̈ha, niz̈aza cjichic̈ha: —Nii fariseo z̈oñinacaqui am chiita taku nonz̈cu ancha z̈awjwatc̈ha. ¿Nii ana naychamjo? ");
INSERT INTO capNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Jakzilta zkalat wejt arajpach Yooz Epiz̈ ana c̈hjacta cjec̈haja, jalla nii zkalaqui zep'iz̈tanpacha kajlz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ninacz̈quiz ana chjijquiza. Ninacaqui zur z̈oñinacaz̈takazza. Yekja zuranacz̈quiz irpican, pucultanpacha wali ojtquiz tjojtsnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pedruqui Jesusiz̈quiz cjichic̈ha: —Tii puntuquiztan wejtnacaquiz tjaajznalla. ");
INSERT INTO capNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesusaqui cjichic̈ha: —¿Anc̈hucqui zakaz ana intintiya? ");
INSERT INTO capNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Tjapa atquiz luzñi c̈hjeriqui pjuchquiz luzza, nekztan wir kjutñiz̈ ulanc̈ha. ¿Jalla nii ana intintiya? ");
INSERT INTO capNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero atquiztan ulanñi chiitaqui kuzquiztan tjonc̈ha. Jalla nii z̈oñz̈quiziqui uj cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kuzquiztanpanz̈ ulanc̈ha tiz̈tanaca, ana wali pinsisnacaqui, niz̈aza z̈oñi conzqui, niz̈aza adulteriuquiz ojklayzqui, niz̈aza yekja maatakz̈tan z̈ejlzqui, niz̈aza cusasanaca kjañzqui, niz̈aza toscar taku chiizqui, niz̈aza ana wal taku joojoozqui. ");
INSERT INTO capNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Jalla niz̈tanaca uj cjesac̈ha z̈oñz̈quiziqui. Pero ana kjara awjz̈cu, jalla niz̈ta lujlz̈cu, anapan uj cjesac̈ha. Jalla niiqui z̈oñz̈ custurumpikazza. ");
INSERT INTO capNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jalla nekztanaqui Jesusaqui nijwctan ojkchic̈ha Tiro niz̈aza Sidón cjita yokquin. ");
INSERT INTO capNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jalla nijwc z̈elan tsjaa cananea yokchiz z̈oñqui Jesusiz̈quiz tjonzinc̈ha, kjawcan: —Wejt Jiliri. Davidz̈ majchmajtquiztan tjonñi. Wejr oksnalla. Wejt majtqui zajraz̈ tantac̈ha. Jalla niz̈tiquiztan ana wira wali laac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesusaqui ana c̈hjulumi kjaazic̈ha. Jalla nekztan niiz̈ tjaajinta z̈oñinacaqui roqui tjonchic̈ha, tuz̈ cjican: —Tsjiika oka cjee. Uc̈hum wirquiz kjaw jawi apz̈quic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nekztanaqui Jesusaqui cjichic̈ha: —Yooz Ejpqui wejr cuchanz̈quichic̈ha Israel wajtchiz z̈oñinacz̈quin, ninacz̈quinkaz. Nii Israel z̈oñinacaqui katchi uuzanacaz̈takazza. ");
INSERT INTO capNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero naa maatak z̈oñqui macjatz̈quichinc̈ha, niz̈aza niiz̈ yujcquiz quillzinc̈ha, tuz̈ cjican: —Wejt Jiliri, wejr yanapt'alla. ");
INSERT INTO capNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Nekztan Jesusaqui naaquiz cjichic̈ha: —Maatinacz̈ t'anta ana kjañasac̈ha, pawcz̈quin tjaazjapaqui. Jalla niiqui ana wali cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jalla nuz̈ chiiz̈inta cjenami naaqui cjichinc̈ha: —Jesalla, wejt Jiliri. Pero pacunacami patrunaz̈ mizquiztan tjawkzi c̈hjerilla lujlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Cullacalla, walja Yoozquin kuzzizamc̈ha. Jaknuz̈um am pecc̈haja, nuz̈oj cjila. Jalla nii orapacha naaz̈a majtqui z̈ejtchi cjissinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jalla nekztanaqui Jesusaqui nijwctan ulanchic̈ha, Galilea cjita kot ata watchic̈ha. Nekztan tsjii curulla yawz̈cu julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Tama z̈oñinacaqui irantiz̈quichic̈ha, jakziquin nii z̈elatc̈haja, jalla nicju. Ninacaqui laanaca zjijcchic̈ha, zuch z̈oñinaca, zur z̈oñinaca, ana chiiñi z̈oñinaca, c̈hjojritz̈ta z̈oñinaca, tjapaman laanaca, jalla ninaca zjijctatac̈ha, Jesusiz̈ yujcquin. Jesusaqui ninaca liwj c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jalla nuz̈ cherz̈cu, z̈oñinacaqui ancha ispantichic̈ha. Ana chiiñi z̈oñinacaqui chiiñi cjissic̈ha. C̈hjojritz̈ta z̈oñinacaqui z̈ejtchi cjissic̈ha. Zuch z̈oñinacaqui ojklayñi cjissic̈ha. Zur z̈oñinacaqui cherñi cjissic̈ha. Jalla nuz̈ cherz̈cu z̈oñinacaqui walja Yooz honora waytichic̈ha, “Israel z̈oñinacz̈ Yooz ancha honorchiz cjilalla”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinaca kjawz̈cu, tuz̈ cjichic̈ha: —Tii z̈oñinacz̈tajapa kuzquiz anchal sint'uc̈ha. C̈hjep maj wejttan chica z̈ejlc̈ha, niz̈aza ana c̈hjul c̈hjerchizza. Persun kjuyanacquin anal cutz pecuc̈ha ana lujlchi cjen. Tinacaqui ana lujlchi okaquiz̈ niiqui, jiczaranz̈ tismayasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nekztan niiz̈ tjaajinta z̈oñinacaqui cjichic̈ha: —¿Jaknuz̈t c̈hjeri cunsicas, tii wacchi z̈oñinacz̈tajapajo? Tii yokquizic anaz̈ kjayzmi z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈ t'antichizt anc̈hucjo? Ninacaqui kjaazic̈ha, tuz̈ cjican: —Pakallak t'antac̈ha, niz̈aza tsjii kjaz̈ ch'iznacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jalla nekztan Jesusaqui nii z̈oñinacz̈quiz mantichic̈ha, yokquiz julznajo. ");
INSERT INTO capNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Nekztan persun kjarz̈tan nii pakallak t'anta ch'iztanpac̈ha tanzic̈ha. Jalla nekztan Yoozquin gracias cjican tjaachic̈ha. Nekztan nii t'antanaca ch'iznaca kjolkjolzic̈ha. Nekztan niiz̈ tjaajinta z̈oñinacz̈quiz toj tojzic̈ha. Nekztan ninacazti partir paychic̈ha nii tama z̈oñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tjapa nii tama z̈oñinacazti c̈hjeri lujlz̈cu chjekchi cjissic̈ha. Niz̈aza z̈ejtchinacaqui pakallak canasta chjijpi ricujtatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pusi warank luctak z̈oñinacatac̈ha lujlchiqui. Niz̈aza nii oraqui maatakami ocjalami muzpa z̈elatc̈hay, pero ana kantatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jalla nekztanaqui Jesusaqui nii z̈oñinacz̈quiz liwj cuchanchic̈ha okajo. Niimi warcuquin luzzic̈ha. Nekztan Magdala cjita yokquin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseo z̈oñinacami, saduceo z̈oñinacami Jesusa cherzñi ojkchic̈ha. Jesusiz̈ quintra uj jwes pecatc̈ha. Jalla niz̈tiquiztan Jesusiz̈quiztan maychic̈ha, arajpach milajru tjeeznajo, tsjii sinalaz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Zezilla arajpach tsjiri ljoc cjissi cjen, “Jakac zuma tjuñiz̈ cjequic̈ha” cjiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Niz̈aza wentan tjuñi tjewktan arajpach tsjiri ljoc cjissi cjenaqui, walja tsjiri cjenaqui, “Tonjiqui ana zum tjuñiz̈ cjequic̈ha” cjiñc̈hucc̈ha. Ana zum kuzziz z̈oñinaca. Anc̈hucqui tsewcta tsjiri cherz̈cu, zuma tjuñi ana zuma tjuñi cjec̈haja, jalla nii zumpacha zarayiñc̈hucc̈ha. Pero anc̈hucqui weriz̈ paata sinalanaca cherz̈cu, ana zuma zarayiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ana zum kuzziz z̈oñinacaqui Yoozquiztan zarakchiz̈ cjen, sinala sinala mayc̈ha. Anc̈hucz̈tajapa Jonás puntuqui siñalaz̈takaz z̈ejlc̈ha. Ana iya tjeez̈ta cjequic̈ha. —Jalla nuz̈ chiiz̈cu Jesusaqui ninacz̈quiztan zarakchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Niiz̈ tjaajinta z̈oñinacaqui kotquin tsjii latu kajkchic̈ha. Niz̈aza t'anti z̈aka chjitz tjatstkalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Tii taku nonz̈na. Fariseo z̈oñinacz̈ liwaturz̈quiztanami niz̈aza saduceo z̈oñinacz̈ liwaturz̈quiztanami zumpacha cwitasaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jalla nii chiita nonz̈cu, tjaajinta z̈oñinacaqui ninacpora parlassic̈ha, tuz̈ cjican: —Uc̈humqui ana t'anta zjijctac̈ha, jalla niz̈tiquiztan niz̈ta chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesusaqui ninacz̈ pinsita zizcu, ninacz̈quiz paljaychic̈ha tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈hucqui t'antiquinkaz pinsejo? Anc̈hucqui ancha upa kuzzizc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Anapanz̈ anc̈hucqui wira intintas, ¿tiz̈ta ana cjuñzjo? Pjijska t'antiquiztan pjijska warank luctak z̈oñz̈quiz partir payz̈cu lujlkatchinla. Nekztan ¿kjaz̈ canasta nii z̈ejtchi t'antanaca ricujtataya? ");
INSERT INTO capNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Niz̈aza pakallak t'antiquiztan pusi warank luctak z̈oñz̈quiz partir payz̈cu lujlkatchinla. Nekztan ¿kjaz̈ canastat nii z̈ejtchi t'antanaca ricujtataya? ");
INSERT INTO capNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Fariseo z̈oñinacz̈ puntuquiztanami niz̈aza saduceo z̈oñinacz̈ puntuquiztanami, jalla nii liwatur puntu chiichinc̈ha. Jalla nii chiitaqui anac̈ha ultim t'anti puntuquiztanaqui. ¿Anaz̈ nii intintas, anc̈hucya? ");
INSERT INTO capNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jalla nekztanaqui ninacaqui zumpacha intintazzic̈ha. Jesusaqui ultim t'anti liwaturquiztan ana nii puntu chiiz̈inchic̈ha. Pero fariseoz̈ tjaajinta puntuquiztan niz̈aza saduceoz̈ tjaajinta puntuquiztan, jalla nii puntu chiiz̈inchic̈ha, jalla nii tjaajintanacquiztan cwitasaquic̈ha, cjican. ");
INSERT INTO capNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jalla nekztanaqui Jesusaqui Cesarea de Filipo cjita yokquin ojkchic̈ha. Nii irantiz̈cu, niiz̈ tjaajinta z̈oñinacz̈quiz pewczic̈ha, tuz̈ cjican: —Wejrqui tsewcta cuchanz̈quita Yooz Z̈oñtc̈ha. Z̈oñinacaqui wejt puntuquiztan ¿kjaz̈t cjeejo? ");
INSERT INTO capNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ninacaqui kjaazic̈ha, tuz̈ cjican: —Yekjapanacaqui am puntuquiztan tuz̈ cjicha: “Juan Bautistac̈ha niiqui”. Yekjapanacaqui cjic̈ha, “Eliassa niiqui”. Niz̈aza yekjapanacaqui cjic̈ha, “Jeremiassa niiqui”. Niz̈aza yekjapanacaqui cjic̈ha, “Tsjii yekja profetac̈ha niiqui”. ");
INSERT INTO capNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jalla nekztanaqui Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Anc̈huczti wejt puntuquiztan ¿kjaz̈zaz̈ cjeejo? ");
INSERT INTO capNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pedruqui tuz̈ cjichic̈ha: —Yooziz̈ uchta Cristumc̈ha amqui, z̈ejtñi Yooz Maatimc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jesusaqui nekztan cjichic̈ha: —Simón, Jonás maati, jalla nuz̈ chiitiquiztanaqui cuntintum cjee amqui. Anaz̈ jakzilta z̈oñimi amquiz nii tjaajinchiqui. Wejt arajpach Yooz Ejppankazza am zizkatchiqui. ");
INSERT INTO capNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Amquiz cjiwc̈ha. Tekztan najwkchuc amqui Pedro cjitam cjequic̈ha. Niz̈aza tii maz simintuchiz wejrqui wejt icliza kjuyac̈ha. Wejt iclizaqui wejtquin kuzziz z̈oñinacac̈ha. Ticzmi wejt iclizquiztan ana atipasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wejrqui amquiz llawiz̈takaz poder tjaac̈ha z̈oñinaca arajpach Yooz mantuquiz luzkatzjapa. Tii muntuquiz amqui jequit Yooz mantuquiz luzkatac̈haja, jalla niiqui arajpach Yooz wajtquin luzkatta zakaz cjequic̈ha. Niz̈aza tii muntuquiz jequit Yooz mantuquiz ana luzkatac̈haja, jalla niiqui arajpach Yooz wajtquin ana luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz mantichic̈ha, tuz̈ cjican: —Anaz̈ jecz̈quizimi maznaquic̈ha, “Niic̈ha Cristuqui” cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nekztan najwkchuc Jesusaqui tjaajinta z̈oñinacz̈quiz niiz̈ ticz puntuquiztan paljayi kallantichic̈ha, tuz̈ cjican: —Wejrqui Jerusalén watja ojkstanc̈ha. Jalla nicju nii wajtchiz jilirinacami, niz̈aza timplu jilirinacami, niz̈aza lii tjaajiñi maestrunacami jalla ninacaqui wejr walja sufriskataquic̈ha. Ultimquiziqui wejr conaquic̈ha. Jalla nuz̈ contiquiztan c̈hjep majquiztan jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nekztanaqui Pedruqui Jesusa tsjii latu chjitchic̈ha, chiiz̈inzjapa. Chiiz̈inz̈can, tuz̈ cjichic̈ha: —Wejt Jiliri, amiz̈ nuz̈ chiitacama Yooz Ejpqui anaj niic nuz̈ munlalla. Amquiz anaj niz̈ta watlalla. ");
INSERT INTO capNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jalla nuz̈ chiitiquiztan Jesusaqui Pedruz̈ kjutñi kjutzic̈ha, tuz̈ cjican: —Satanás, wejtquiztan zaraka. Amqui wejr ujquiz tjojtskatz pecc̈ha. Am kuz pinsitaqui anaz̈ Yooz pinsita, antiz z̈oñiz̈ pinsitakazza. ");
INSERT INTO capNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz cjichic̈ha: —Jequit wejttan chica kamz pecc̈haj niiqui, primiruqui persun kamañ wiraqui tjatzla. Sufrisjapaqui listoj cjila, ticzcama. Nekztan wejttan chicaz̈ kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jakziltat persun kamañ wira ana tjats pecc̈haj niiqui, arajpach kamañaqui ana tjaataz̈ cjequic̈ha. Jakziltat wejt laycu persun kamañ wira tjatznac̈haja, jalla niiqui arajpachquin wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tsjii z̈oñiqui tjapa tii muntuquiz z̈ejlñi cusasanaca kanasac̈ha. Pero nekztan infiernuquin okaquiz̈ niiqui, tjapa nii kanta cusasanaca, ¿c̈hjuljapat sirwejo? Inakaz cjequic̈ha. Arajpachquin Yooztan kamzqui persun liwriizqui anaz̈ paaztanac kjayasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tsjii noojiqui wejrqui wejt anjilanacz̈tan quejpz̈cac̈ha; wejt Ejpz̈ wali aztan quejpz̈cac̈ha. Jalla nuz̈ quejpz̈cu, wejrqui zapa mayniz̈quiz tjaac̈ha, jaknuz̈t kamc̈haja, jalla nii jaru tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Weraral cjiwc̈ha. Tsjii noojiqui wejrqui mantiz poderz̈tan tjonac̈ha. Yekjap tekzi z̈ejlñi z̈oñinacaqui nii noojcama ana ticznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sojta tjuñquiztan Jesusaqui Pedruz̈tan, Jacobz̈tan, Juanz̈tan, Jacoboz̈ lajk, jalla ninaca chjitchic̈ha. Ninacz̈tan alaja nuz̈ pajk curquin ojkz̈cu, yawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jalla nicju ninacz̈ yujcquin tsjemat chercherchiz cjissic̈ha. Jesusiz̈ yujcqui walja c'ajñi cjissic̈ha tjuñiz̈takaz. Niz̈aza niiz̈ zquitimi muzpa llijñi cjissic̈ha, niz̈aza ancha chiwi. ");
INSERT INTO capNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nii orapacha Moisestan Eliastan parizichic̈ha. Nii pucultan z̈oñiqui Jesusiz̈tan parlican z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jalla nekztan Pedruqui Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, tekz z̈ejlzqui walikazza. Am pecaquiz̈ niiqui, c̈hjep chjujlli kjuyaz̈ kjuyac̈ha wejrnacqui, tsjiiqui amta, tsjiiqui Moisesta, tsjiiqui Eliasta. ");
INSERT INTO capNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedruz̈ nuz̈ chiyan, zuma kjañi tsjiriqui ninacz̈quiz urpuntichic̈ha. Tsjirquiztan tsjii jora chiiz̈quichic̈ha, tuz̈ cjican: —Tiic̈ha wejt k'ayi Maatiqui. Tiiz̈ cjen anchal cuntintutc̈ha. Jalla tiiz̈ takunaca catoka. ");
INSERT INTO capNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jalla nii chiiz̈quita nonz̈cuqui, nii c̈hjep tjaajinta z̈oñinacaqui yokquiz tuzi t'okzic̈ha. Muzpa tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jalla nuz̈ tuzi t'okzi z̈elan, Jesusaqui ninacz̈quiz macjatz̈quichic̈ha. Ninacz̈quiz kjarz̈tan lanlanz̈inchic̈ha, tuz̈ cjican: —Tsijtsna. Anac̈ha tsuca. ");
INSERT INTO capNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ninacaqui acha waytiz̈cu Jesusa alajakaz cherzic̈ha, ana iya jecmi cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nekztanaqui curquiztan chjijwz̈can, Jesusaqui ninacz̈quiz mantichic̈ha, tuz̈ cjican: —Anaz̈ jecz̈quizimi nii anc̈hucaz̈ cherta maznaquic̈ha, weriz̈ ticziquiztan jacatatta, jalla niicama. ");
INSERT INTO capNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nekztanaqui niiz̈ tjaajinta z̈oñinacaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —Lii tjaajiñi maestrunacaqui cjiñic̈ha, primero Elías profetaqui tjonstanc̈ha, nii. ¿Kjaz̈tiquiztan nii maestrunacaqui niz̈ta chiiya? ");
INSERT INTO capNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Ultimupanz̈ Eliasqui wejt tuqui tjonchic̈ha. Niiqui tjappachaz̈ tjaczic̈ha, wejr tjonzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wejrqui cjiwc̈ha. Eliasqui tjonchitala. Pero lii maestrunacaqui nii Elías ana pajchila. Antiz ninacz̈ kuzcama nii Elías c̈hjulumi sufriskatchic̈ha. Niz̈aza ninacaqui wejrzakaz ancha sufriskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jalla nuz̈ Jesusiz̈ chiitiquiztan nii tjaajinta z̈oñinacaqui tantiyazzic̈ha, Juan Bautistac̈ha Eliasqui, nii. ");
INSERT INTO capNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jalla nekztanaqui curquiztan chjijwz̈cu, parti z̈oñinacz̈quiz irantiz̈quichic̈ha. Nekztan tsjii z̈oñiqui Jesusiz̈quiz macjatz̈cu, niiz̈ yujcquiz quillzic̈ha. Niz̈aza tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wejt Jiliri, wejt majchquiz okz̈nalla. Niiqui t'ucñipanc̈ha. Ancha sufric̈ha. Avisac ujquiz tjojtsa, niz̈aza kjazquiz zakaz tjojtsa. ");
INSERT INTO capNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tekz zjijcchinc̈ha am tjaajinta z̈oñinacz̈quiz. Ninacaqui ana c̈hjetñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tii timpuquiz kamñi z̈oñinacaqui ana Yoozquin kuzzizza, ana zumac̈ha. ¿C̈hjulorcamat wejr anc̈hucatan z̈elaqui? ¿C̈hjulorcamat anc̈hucaquiz awantaqui? Wejtquin zjijca nii am majch. ");
INSERT INTO capNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jalla nekztanaqui Jesusaqui nii majch tanñi zajra ujzic̈ha; nekztan chjatkatchic̈ha. Jalla nii orapacha z̈ejtchi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jalla nekztanaqui tjaajinta z̈oñinacaqui Jesusiz̈quiz zinapora pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan wejrnacqui zajraz̈ tanta z̈oñi ana c̈hjetñi atchintaya? ");
INSERT INTO capNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui anac̈ha Yoozquin tjapa kuzziz. Jalla niz̈tiquiztan ana chjatkati atc̈ha. Weraral cjiwc̈ha. Tsjii mostasa cjita simillaqui koltallac̈ha. C̈hjactiquiztan walja pakjiz̈ pajkc̈ha. Yoozquin tjapa kuzzizc̈huc cjec̈haj niiqui, jalla tuz̈ paasac̈ha. Tii curumiz̈ mantasac̈ha, tuz̈ cjican: “Tekztan najwk oka”. Jalla nuz̈ mantitiquiztan curucz̈ okasac̈ha. Tjappacha c̈hjulumi paasac̈ha anc̈hucqui, ultimu Yoozquin tjapa kuztan cjec̈haj niiqui. ");
INSERT INTO capNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero tii punta zajra chjatkatzjapa, Yoozquin mayiziz waquizic̈ha. Niz̈aza ayunas waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea yokaran juntupacha ojklaycan, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz chiichic̈ha, tuz̈ cjican: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui z̈oñinacz̈ kjarquin intirjital cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Niz̈aza contal cjeec̈ha. Niz̈aza c̈hjep majquiztanzti jacatatac̈ha. Jalla nuz̈ chiitiquiztanaqui ancha llaquisiskatchic̈ha nii tjaajintanacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nekztan Jesusiz̈tan niiz̈ tjaajintanacz̈tanpacha Capernaum watja irantichic̈ha. Nekztan timplujapa impuesto cobriñinacaqui Pedruz̈quin cherzñi ojkchic̈ha. Jalla niiz̈quin zalz̈cu pewczic̈ha tuz̈ cjican: —¿Anc̈huca tjaajiñi maestruqui timplu impuesto ana pacñikaya? ");
INSERT INTO capNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pedruqui kjaazic̈ha, tuz̈ cjican: —Impuesto pacñipanc̈hay. Jalla nekztanaqui Pedruqui kjuyquiz luzzic̈ha, jakziquin Jesusac z̈elatc̈haja, jalla nicju. Ima Pedruz̈ chiyan, Jesusaqui niiz̈quiz paljaychic̈ha, tuz̈ cjican: —Simón, ¿tii tantiya? Tii muntuquiz z̈ejlñi jilirinacaqui impuesto cobriñic̈ha. ¿Jakziltiz̈quiztan cobriya? ¿Persun wajtchiz z̈oñinacz̈quiztankaya? uz̈ ¿yekja wajtchiz z̈oñinacz̈quiztan, ja'? ");
INSERT INTO capNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pedruqui kjaazic̈ha tuz̈ cjican: —Yekja wajtchiz z̈oñinacz̈quiztanpanc̈ha. Nekztan Jesusaqui cjichic̈ha: —Jalla niz̈tiquiztan nii jilirinacz̈ persun wajtchiz z̈oñinacaqui impuestonaca ana pacasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Jalla nuz̈ cjenami, anaz̈ jecmi uc̈hum quintra iñiziñi cjiskatz pecuc̈ha. Jaziqui kotquin oka. Nekztan ch'iz tanzjapa kjazquiz anzuelo tjojtznaquic̈ha. Primiru tanzi ch'iz lecznaquic̈ha. Nii ch'iz ata waakatz̈cu, tsjii paaz wachaquic̈ha. Nii paazqui wejt impuestojapa, niz̈aza am impuestojapa wacaquic̈ha. Nii paaz chjicha, uc̈hum impuestonaca paczjapa. ");
INSERT INTO capNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jalla nii orapacha tjaajinta z̈oñinacaqui Jesusiz̈quiz macjatz̈cu pewczic̈ha, tuz̈ cjican: —Arajpach Yooz wajtquiz, ¿ject juc'ant pajk puestuquin uchtaz̈ cjeequi? ");
INSERT INTO capNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jalla nekztanaqui Jesusaqui tsjii uza kjawzic̈ha. Nii uza ninacz̈ taypiquiz tsijtskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nekztanaqui Jesusaqui cjichic̈ha: —Weraral cjiwc̈ha. Anc̈hucqui tii ocjalz̈ kuz irata, niz̈ta kuzziz pecc̈ha. Anc̈huca kuz ana campiita cjec̈haj niiqui, arajpach Yooz wajtquiz anapan luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jalla niz̈tiquiztan tii ocjalz̈ kuz irata, jalla niz̈ta humilde kuzziz cjis waquizic̈ha. Jakziltat niz̈ta kuzziz cjisnaquiz̈ niiqui, jalla niic̈ha arajpach Yooz wajtquiz juc'ant honorchizqui. Juc'ant zuma puestuquiz uchtaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jequit weriz̈ cjen tsjii ocjalaz̈takaz humilde kuzziz z̈oñi risiwc̈haja, jalla niiqui wejrzakaz risiwc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‛Niz̈aza jakzilta humilde kuzziz z̈oñit wejtquin tjapa kuztan criyac̈haja, jalla niiz̈quiz ana jakziltami ujquiz tjojtskatz waquizic̈ha. Ujquiz tjojtskataquiz̈ niiqui, nii ujquiz tjojtskatñi z̈oñz̈ jorquiz tsjii pajk molinu tjaaj mokz̈cu, koz kotquiz jacuntiz waquizic̈ha. Jalla nii tsjan cusaz̈ cjesac̈ha nii ujquiz tjojtskatñi z̈oñz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Zoñinacajay! Ujquiz tjojtaquic̈ha, niz̈aza ujquiz tjojtskataquic̈ha. Pero nekztan ana walinaca tjonaquic̈ha. Tii muntuquiz ujquiz tjojtskatñinaca panz̈ z̈elaquic̈ha, pero nii ujquiz tjojtskatñinacaqui ninacz̈tajapa ana waliz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‛Jalla niz̈tiquiztan am kjaraz̈laj uz̈ kjojchaz̈laj ujquiz tjojtskatc̈haja, nii uj paañi kjara cjicu uz̈ kjojcha cjicu pootzna, niz̈aza najwk tjojta. Jalla nuz̈ tsjii kjara cjicu uz̈ tsjii kjojcha cjicu pertissi cjenami am parti curpuqui ana infiernuquin tjojttaz̈ cjesac̈ha. Jalla nuz̈ waliz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Niz̈aza am c̈hjujcquiqui ujquiz tjojtskatc̈haja, jalla nii c̈hjujcqui lecz̈na, niz̈aza najwk tjojta. Yooztan wiñaya kamzjapaqui tsjii c̈hjujquiqui pertissiz̈ cjequiz̈ niiqui, waliz̈ cjequic̈ha. Tjapa curpuqui infiernuquin tjojttaz̈ cjequiz̈ niiqui, ana waliz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‛Humilde kuzziz z̈oñinacz̈tan ana chjaawjkata. Anc̈hucaquiz cjiwc̈ha, ninacz̈ anjilanacaqui wejt arajpach Yooz Ejpz̈ yujcquiz z̈ejlñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui tii muntuquiz tjonchinc̈ha, ujquiz kamñi z̈oñinaca liwriizjapa. ");
INSERT INTO capNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‛¿Jalla tii tantiya? Tsjii z̈oñiqui patac uuzichiztac̈ha. Patac uuziquiztan tsjiillaqui yekjaquin zaraktan, nii z̈oñiqui nii llatuntunc llatuncani uuzinaca curquin ecaquic̈ha, zarakchi uuza kjurz̈quizjapa. ");
INSERT INTO capNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Niz̈aza katchi uuza wachaquiz̈ niiqui, nekztan walja chipznaquic̈ha ana zarakchi uuzanacz̈quiztan juc'anti. ");
INSERT INTO capNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jalla niz̈ta irata anc̈huca arajpach Yooz Ejpqui humilde kuzziz z̈oñinacz̈quiztan anapan jakziltami pertita cjis munc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‛Am jilaqui am quintra ana wali paaquiz̈ niiqui, jalla niiz̈tan zinapora palt'a, niiz̈ ana wali paata ujquiztan “ujchizpanc̈ha” cjican cjeequi. Jalla nuz̈ amiz̈ chiiz̈intiquiztan catokaquiz̈ niiqui, nii jilaqui ricujta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Zinapora chiiz̈intiquiztan ana nonz pecaquiz̈ niiqui, nii uj paañi jilz̈quiztan okaquic̈ha. Nekztan iya pucultan jila kjawz̈cu, wilta nii uj paañi jilz̈quin okaquic̈ha, niiz̈ paata uj tjeezjapa. Jalla nuz̈ paaz̈cu pucultan cjicu uz̈ c̈hjepultan cjicu testicz̈ taypiquiz niiz̈ paata uj tjeez̈ta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nii uj paañiqui anapanz̈ niiz̈ uj maz pecaquiz̈ niiqui, jalla nii puntuquiztan tjapa icliz jilanacz̈quin maznaquic̈ha. Anapan niiz̈ uj maz pecaquiz̈ niiqui, ana Yoozquin criichi jilaz̈takaz c̈hejlnaquic̈ha, niz̈aza impuesto cobriñi z̈oñiz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Ultim weraral cjiwc̈ha. Tii muntuquiz jequit am c̈helac̈haja, jalla niiqui arajpach Yooziz̈ c̈hejlta zakaz cjequic̈ha. Niz̈aza tii muntuquiz jequit am cutznac̈haja, jalla niiqui arajpach Yooziz̈ cutz̈ta zakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tii zakal chiiz̈inuc̈ha. Tii muntuquiz pucultan anc̈hucqui tsjiikaz Yoozquiztan mayaquiz̈ niiqui, anc̈hucaquiz tjaataz̈ cjequic̈ha. Wejt arajpach Yooz Ejpqui anc̈hucaz̈ mayta tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Niz̈aza tsjii pucultanami c̈hjepultanami wejtquin kuzziz cjen wejt tjuuquiz ajcznaquiz̈ niiqui, jalla ninacz̈ taypiquiz wejrzakaz z̈elac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wiruñaqui Pedruqui Jesusiz̈quin pewczñi ojkchic̈ha. Zalz̈cu, jalla tuz̈ pewczic̈ha: —Wejt Jiliri, ¿Kjaz̈ wiltamiz̈ wejt jilaqui wejt quintra uj paaz̈cu pertuna mayisasaya? ¿Niz̈aza wejrqui kjaz̈ wiltat pertunasaya? ¿Pakallak wilta pertunasaya? ");
INSERT INTO capNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Wejrqui cjiwc̈ha, anaz̈ pakallak wilta cjesac̈ha. Antiz pakallak tunc pakallakuni wiltan wiltan pertunasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Arajpach Yooz mantiz puntuquiztan jalla tuzuc̈ha. Tsjii chawc jiliriqui piyunanacz̈quiz kaja packatz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jalla nuz̈ packatan tsjii kajchiz z̈oñiqui zjijctatac̈ha. Nii z̈oñiqui walja kajanacchiztac̈ha, tsjii kjaz̈ millona. ");
INSERT INTO capNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nii piyunz̈taqui anaz̈ pacz paaz z̈elatc̈ha. Nekztan patrunaqui jalla tuz̈ mantichic̈ha: “Tii z̈oñi tuya, paaz cunsiczjapa. Niz̈aza niiz̈ tjunmi, ocjalanacami, tjapa niiz̈ cusasanacami liwj tuyla kaja pacz paaz cunsiczjapa”. ");
INSERT INTO capNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nekztanaqui nii piyunaqui patrunz̈ yujcquiz quillzic̈ha, niz̈aza roct'ichic̈ha, tuz̈ cjican: “Wejt patruna, pertunalla. Tjappachal pacac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Niz̈tami patrunaqui ancha okzic̈ha; niz̈aza nii kaja ana cobrichic̈ha. Jalla niz̈tiquiztan liwrii cjissic̈ha nii kajquiztan. ");
INSERT INTO capNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Wajilla nii piyunaqui nijwctan ulanz̈cu tsjii piyun maztan zalchic̈ha. Nii piyun maziqui tsjii kjaz̈talla kajatac̈ha nii pertunta piyunz̈quiz. Nekztan nii pertunta piyunaqui jor t'ullcu tanchic̈ha, nii packatzjapa, tuz̈ cjican: “Kajquiztan tjappacha paca”. ");
INSERT INTO capNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jalla nekztanaqui nii piyun maziqui niiz̈ yujcquiz quillzic̈ha, niz̈aza roct'ichic̈ha, tuz̈ cjican: “Pasinsis kuzziz cjee. Nii kajallquiztan tjappachakal pacac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Nii kaja cobriñizti ana munchic̈ha. Antiz carcilquin uchantichic̈ha, jalla nii kaja paczcama. ");
INSERT INTO capNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Parti piyunanacaqui niz̈ta paañi cherz̈cu ancha sint'ichic̈ha. Nekztan patrunz̈quiz mazñi ojkchic̈ha. Jalla nicju tjappacha quint'ichic̈ha, jaknuz̈t watc̈haja, nii. ");
INSERT INTO capNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jalla nekztanaqui patrunaqui nii pertunta piyuna wilta kjawz̈katchic̈ha. Nekztan cjichic̈ha: “Ana zum kuzziz piyuna, wejrqui tjapa am kajanaca pertunchinc̈ha, amiz̈ roct'iñiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jaknuz̈t wejrqui am kajquiztan, pertunchinc̈haja, jalla nuz̈uzakaz amlaqui am piyun mazquiz pertunstanc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jalla nekztanaqui patrunaqui juc'anti z̈awjzic̈ha. Niz̈aza mantichic̈ha, nii piyuna casticzjapa, tjapa niiz̈ kaja paczcama. ");
INSERT INTO capNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesusaqui nii quintu quint'ican jalla tuz̈ z̈erzic̈ha: —Jakzilta anc̈hucaquiztan niiz̈ jilz̈quiz kuzquiztan ana pertunac̈haja, jalla nuz̈uzakaz wejt arajpach Yooz Ejpqui anc̈hucaquiz ana pertunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jalla nuz̈ tjaajinz̈cu Jesusaqui Galilea yokquiztan ojkchic̈ha. Judea yokquin irantichic̈ha, Jordán cjita pujz̈ tuwanchuc. ");
INSERT INTO capNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Muzpa z̈oñinacaqui niiz̈quiz apzic̈ha. Jalla nicju muzpa laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jalla nekztanaqui yekjap fariseo z̈oñinacaqui Jesusiz̈quiz macjatchic̈ha, ujquiz tjojtskatzjapa. Nekztan tuz̈ pewczic̈ha: —¿C̈hjul uj paatiquiztanaqui persun maatakz̈tanaqui jaljtasaya? ");
INSERT INTO capNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Yoozqui tii muntu paacan, luctakz̈tan maatakz̈tan paachic̈ha. ¿Cjijrta Yooz takuqui ana liichinc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yooz takuqui tuz̈ cjic̈ha: “Jalla niz̈tiquiztan tsjii z̈oñiqui tjunatan zalzjapa, maa ejpz̈quiztan zarakstanc̈ha. Zalz̈cu pucultan tsjii lucutiñi cjissa”. ");
INSERT INTO capNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jalla nuz̈ kjanapacha tjeez̈a, anaz̈ iya pucultan z̈oñi, pero tsjiikazza. Jalla niz̈tiquiztan anaz̈ jaljtasac̈ha. Yoozza tsjii luctakz̈tan tsjaa maatakz̈tan chjalziqui, tsjii lucutiñi cjisjapa. Yooz chjalz̈taqui ana jaljta cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nekztanaqui pewczic̈ha tuz̈ cjican: —Moisesqui jalla tuz̈ mantichic̈ha. Tsjii certificado de divorcio tjaaquiz̈ niiqui, tjunatan jaljtasac̈ha. ¿Kjaz̈tiquiztan niz̈ta mantichejo, ana jaljtiz z̈elanajo? ");
INSERT INTO capNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Anc̈hucaz̈ chojru kuzziz cjen Moisesqui tjunatan jaljtis lii tjaachic̈ha. Primirquiztanpacha anataz̈ niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wejrqui anc̈hucaquiz chiiz̈inuc̈ha. Adulteriuquiz ojklayñiz̈ cjenkaz am maatakz̈tan jaljtasac̈ha. Jequit ana adulterio paachiz̈ cjenaqui niiz̈ persun maatakz̈tan jaljtac̈haja, niz̈aza yekja maatakz̈tan zalznac̈haja, jalla niiqui adulterio uj paac̈ha. Niz̈aza jequit divorcita maatakz̈tan zalznac̈haja, nii zakaz adulterio paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tjaajinta z̈oñinacaqui niiz̈quiz cjichic̈ha: —Luctakz̈tan persun maatakz̈tan jalla niz̈ta cjesaz̈ niiqui, anaz̈ cumpinc̈ha zalzqui. ");
INSERT INTO capNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesusaqui nekztan cjichic̈ha: —Tjapa z̈oñinacaqui tii tjaajinta anaz̈ catokaquic̈ha. Jakziltiz̈quiz Yoozqui tjaajnac̈haja, jalla niiqui tii tjaajintaqui catokaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Z̈oñinacaqui punta punta ana zalzi cjic̈ha. Yekjapanacaqui nastiquiztanpacha ana zalzucac̈ha. Yekjapanacazti capunapantac̈ha, jalla niz̈tiquiztan ana zalzñi atasac̈ha. Yekjapanacazti ana zalz pecc̈ha, arajpach Yooz Ejpz̈tajapa langzjapa. Jecmiz̈ tii takucama kami catokaquiz̈ niiqui, paj kamla. ");
INSERT INTO capNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Z̈oñinacaqui ocjalanaca Jesusiz̈quiz zjijcchic̈ha, ocjalanacz̈quiz kjarz̈tan lanznajo, nii ocjalanacz̈tajapa Yoozquin mayiz̈inajo. Pero tjaajinta z̈oñinacaqui zjijcñi z̈oñinacz̈quiz atajchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Nekztan Jesusaqui cjichic̈ha: —Tii ocjalanaca wejtquin tjonaj cjee, ana ataja. Tii ocjalanacz̈ kuz irata jalla niz̈ta kuzzizza arajpach Yooz mantita kamañchiz z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nekztan Jesusaqui ocjalanacz̈quiz kjarz̈tan lanzic̈ha. Jalla nekztan nii yokquiztan ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wiruñaqui tsjii tjowaqui Jesusa cherzñi ojkchic̈ha. Nekztan pewczic̈ha, tuz̈ cjican: —Zuma Maestro, Yooztan wiñaya kamzjapa, ¿c̈hjul zumanacat wejr paasaya? ");
INSERT INTO capNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan “Zuma Maestro” cjee amjo? Tsjii alajac̈ha zumaqui. Yoozkazza niiqui. Yooztan wiñaya kamz pecc̈haj niiqui, Yooz Epiz̈ mantitanac jaru kama cjee. ");
INSERT INTO capNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nii tjowaqui jalla nekztan kjaazic̈ha, tuz̈ cjican: —¿C̈hjul mantitanacaya? Jesusaqui niiz̈quiz cjichic̈ha: —Anac̈ha z̈oñi conzqui. Anac̈ha adulteriuquiz ojklayzqui. Anac̈ha tjangzqui. Anac̈ha toscara chiizqui, jecz̈quizimi. ");
INSERT INTO capNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Am maa ejpmi rispitaquic̈ha. Jaknuz̈um persunpachquiz okzñamz̈laja, jalla niz̈ta okzñi kuzziz cjispanc̈ha z̈oñinacz̈quizimi, lijitum maziz̈takazza. ");
INSERT INTO capNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nii tjowaqui nekztan cjichic̈ha: —Tjapa nii mantitanacami cumpliñc̈ha koltiquiztanpacha. ¿Jaziqui c̈hjulut wejtta pjaltasa? ");
INSERT INTO capNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesusaqui tuz̈ cjichic̈ha: —Ancha wali cjissim pecc̈haj niiqui, oka, niz̈aza amta z̈ejlñi cusasanaca tuyzna. Jalla nii tuyz̈cu, porinacz̈ ona. Jalla niz̈tiquiztan arajpachquin cusasanacaz̈takaz zuma honora tjaatam cjequic̈ha. Jalla nii cumpliscu wiltam tjonaquic̈ha wejttan chica ojklayzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jalla niz̈ta chiita nonz̈cu, nii tjowaqui walja llaquita kuzziz ojkchic̈ha. Ancha ricachutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quin cjichic̈ha: —Weraral anc̈hucaquiz cjiwc̈ha. Tsjii ricachu z̈oñi arajpach Yooz mantuquiz luzjapa ancha ch'amaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tsjii camello cjita animala z̈ejlc̈ha. Nii camelluqui ch'aman acuj cjuñ pjetquiz luzasac̈ha. Jalla niz̈taz̈ ricachunacaqui tsjan ch'amac̈ha Yooz kamañ jiczquiz luzqui, Yooz wajtchiz z̈oñi cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jalla nuz̈ nonz̈cu, tjaajinta z̈oñinacaqui walja ispantichic̈ha. Nekztan ninacpora pewcsarassic̈ha, tuz̈ cjican: —¿Jectpan liwriita cjesajo? ");
INSERT INTO capNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesusaqui ninacz̈ kjutñi cherzic̈ha. Jalla nekztan cjichic̈ha: —Z̈oñinacaqui anaz̈ persunpacha liwrii atasac̈ha. Yoozpankazza liwriiñiqui. Yoozqui jecmi liwrii atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jalla nekztanaqui Pedruqui Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, wejrnacqui tjapa persun cusasanaca jaytichinc̈ha, amtan chica ojklayzjapa. ¿Jalla niz̈tiquiztan wejrnacqui c̈hjulut canas? ");
INSERT INTO capNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—Jesusaqui kjaazic̈ha, tuz̈ cjican: —Weraral anc̈hucaquiz cjiwc̈ha. Ew muntuquiz z̈elan, wejrqui poderchiz puestuquiz luzac̈ha. Anc̈hucazakaz poderchiz puestunacquiz luzaquic̈ha, tuncapan Israel partira mantizjapa. ");
INSERT INTO capNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jakzilta z̈oñit weriz̈ cjen kjuyanaca, jilanaca, cullaquinaca, maa ejp, tjun, ocjalanaca, yokanaca ecac̈haja, jalla ninacaz̈ walja zuma kamañ wirchiz cjequic̈ha. Niz̈aza arajpachquin Yooztan wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Arajpachquin Yoozqui wacchi tii timpuquiz tucquin cjiñi z̈oñinaca wirquin cjiskataquic̈ha. Niz̈aza Yoozqui wacchi tii timpuquiz wirquin cjiñi z̈oñinaca tucquin cjiskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‛Arajpach mantiñi Yooz puntuquiztan jalla tuz̈uc̈ha. Wentanalla tsjii yokchiz wali pajk patrunaqui piyunanaca kjuri ulanchic̈ha, uwas frut zkala ajzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Piyunanacz̈tan acuerduquiz luzzic̈ha, zita langz̈tan tsjii denario cjita paaz paczjapa. Jalla nekztanaqui langzñi cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nekztan wenzlaka wilta ulanchic̈ha. Palazquin inakaz z̈ejlñi z̈oñinaca cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ninacz̈quiz paljaychic̈ha, tuz̈ cjican: “Anc̈hucqui wejt zkal yokquin langzñi oka. Wejrkal zumpacha pacac̈ha”. Nekztanaqui ninacaqui ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Taypuru patrunaqui wilta ulanchic̈ha, iya piyunanaca kjuri, niz̈aza langznajo. Niz̈aza taypuru zezi cjeella wilta ulanchic̈ha, piyunanaca kjuri, niz̈aza langznajo. ");
INSERT INTO capNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nii noojpacha zezi cjee wilta palaz kjutñi ulanchic̈ha. Niz̈aza palazquin inakaz z̈ejlñi z̈oñinacz̈tan zalchic̈ha. Ninacz̈quiz paljaychic̈ha tuz̈ cjican: “¿Kjaz̈tiquiztan anc̈hucqui tonj zita ana langz z̈ejljo?” ");
INSERT INTO capNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ninacaqui patrunz̈quiz kjaazic̈ha, tuz̈ cjican: “Anaz̈ jecmi wejrnac langznajo rocchic̈ha”. Nekztanaqui patrunaqui cjichic̈ha: “Anc̈hucqui wejt yokquin zakaz langzñi oka. Wejrkal jakniiz̈laj niil pacac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Tjuñiz̈ kattan nii yokchiz patrunaqui niiz̈ langzkatñi encargado mantichic̈ha, tuz̈ cjican: “Kjawz̈ca langzñi piyunanaca, paczjapa. Primiruqui wiri tjonchi piyunanacz̈quiz pacaquic̈ha; wirquin, tuqui tjonchi piyunanacz̈quiz pacaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jalla nekztanaqui nii wiri luzzi piyunanacaqui langzkatñiz̈quiz macjatchic̈ha. Zapa mayni ninacz̈quiz pactac̈ha, tsjii nooj lanztaz̈ niz̈tapacha. Tsjii denario cjita paaz tanzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jalla nekztanaqui wirquin paczquita primiru piyuna luzzi z̈oñinaca kjawz̈tatac̈ha. Jalla nii primiru piyuna luzzi z̈oñinacaqui pinsichic̈ha jila paca tanzjapa wiri piyuna luzzi z̈oñinacz̈quiztan. Jalla nekztanaqui pacchic̈ha tsjii denario cjita paaz zakaz. ");
INSERT INTO capNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jalla nii paca tanz̈cu patrunz̈ quintra quijchic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","tuz̈ cjican: “Tii wirquin piyuna luzzi z̈oñinacaqui tsjii orakaz langzic̈ha. Wejrnaczti primirquiztanpacha langzinc̈ha, niz̈aza zita ancha sii kjakquiz otz̈can langzinc̈ha. Ninacz̈quizimi wejtnacaquizimi tsjiikaz pacchamc̈ha”. Jalla nuz̈ cjican quijchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Nii patrunaqui tsjii ninacz̈quiz kjaazic̈ha, tuz̈ cjican: “Jila, amquiz anal incallchinc̈ha. Jalla nuz̈ tsjii acuerduquiz luztapanla, tsjii denario paaz paczjapa. ");
INSERT INTO capNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tii paca tanzna, niz̈aza oka. Tii wirquin piyuna luzzi z̈oñinacz̈quiz niz̈azakaz pacz pecuc̈ha, amquiz pactala, jalla nuz̈ zakaz. ");
INSERT INTO capNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wejt persun paaztan jaknuz̈ut wejr pinsuc̈haja, jalla nuz̈ wejt munañpiquiz pacasac̈ha. Weriz̈ zuma pacñi kuzziz cjen amqui iñiziñi kuzziz cjissamla”. ");
INSERT INTO capNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jalla niz̈ta irataz̈ wirquin cjiñinacaqui tucquinz̈ cjequic̈ha. Niz̈aza tucquin cjiñinacaqui wirquinz̈ cjequic̈ha. Kjawz̈ta z̈oñinacaqui wacchic̈ha. Illzta z̈oñinacazti kolucullac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Wiruñaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tan Jerusalén ojkchic̈ha. Jalla nuz̈ jiczquiz ojkcan, Jesusaqui tsjii latu niiz̈ tuncapan illzta z̈oñinaca chjitchic̈ha, niz̈aza ninacz̈quiz tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Anc̈hucqui zizza, tii jiczqui Jerusalén kjutñiz̈ ojkc̈ha, nii. Jerusalén wajtquin wejrqui intirjital cjeec̈ha timplu jilirinacz̈quizimi lii tjaajiñi maestrunacz̈quizimi. Jalla ninacaqui wejr conaquic̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Niz̈aza wejrqui yekja wajtchiz z̈oñinacz̈quiz intirjital cjeec̈ha, ana wali burla paata cjisjapa. Niz̈aza wejrqui wjajttal cjeec̈ha. Ultimquiziqui cruzquiz ch'awcta contal cjeec̈ha. Jalla nekztan c̈hjep majquiztanzti jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jacobz̈tan Juanz̈tan ninacz̈ maaqui Jesusiz̈quiz macjatz̈quichinc̈ha. Jacobz̈tan Juanz̈tan ninacz̈ ejpqui Zebedeo cjitatac̈ha. Jalla naa maaqui maatinacz̈tanpacha Jesusiz̈quin macjatchinc̈ha. Nekztanaqui naaqui Jesusiz̈ yujcquiz quillzinc̈ha, tsjii favora mayzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Nekztan Jesusaqui naaquiz cjichic̈ha: —¿Amqui c̈hjulum pecya? —cjican. Naaqui kjaazinc̈ha, tuz̈ cjican: —Amqui am mantis puestuquin luzcu tii wejt pucultan majchnaca am latuquiz uchnalla, tsjiiqui z̈ew latuquiz niz̈aza tsjiiqui zkar latuquiz. ");
INSERT INTO capNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesusaqui tuz̈ kjaazic̈ha: —Anc̈hucqui c̈hjulut mayc̈haja ana intintazza. Wejrqui walja sufris tanc̈ha. ¿Niz̈tapacha anc̈huc sufrasaya? Niz̈aza tsjii nooj ancha sufrican watac̈ha tsjii bautismoz̈takaz. ¿Jalla niz̈tapacha anc̈huc sufrasaya? Ninacaqui tuz̈ kjaazic̈ha: —Nii sufris watimi atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nekztan Jesusaqui cjichic̈ha: —Weraral cjiwc̈ha. Anc̈hucpacha sufris tanznaquic̈ha, tsjii licz wazuz̈takaz. Niz̈aza sufris wataquic̈ha, tsjii bautismoz̈takaz. Pero wejrqui mantis puestuquin luzcu, z̈ew latuquizimi zkar latuquizimi ana jecmi uchasac̈ha. Wejt Yooz Ejpkaz nii puestunaca tjaaquic̈ha jecz̈tajapa tjacz̈takazlani, jalla ninacz̈ta. ");
INSERT INTO capNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Parti nii tuncapan illzta z̈oñinacaqui nii mayta puntu nonz̈cu nii pucultan jilazullcaz̈ quintra z̈awjchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero Jesusaqui tjappacha nii tjaajintanaca kjawzic̈ha, nekztan tuz̈ cjichic̈ha: —Anc̈hucqui zumpacha zizza, jalla tuz̈u. Tii muntuquiz nación jilirinacaqui patrunaz̈takaz mantiñic̈ha, niz̈aza chawc jilirinacaqui parti z̈oñinacz̈quiziqui niiz̈ mantita cazkatñipankazza. ");
INSERT INTO capNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Anc̈hucqui ana niz̈ta irata cjee. Tsjii kjutñic̈ha nii irat kuzqui. Anc̈hucaquiztan jequit chawc jiliriz̈takaz cjis pecc̈haja, jalla niiqui piyunaz̈takaz cjis waquizic̈ha parti z̈oñinacz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Niz̈aza jequit anc̈hucaquiztan tucquin mantiñi cjis pecc̈haja, jalla niiqui wirquin cjis waquizic̈ha, parti z̈oñinacaz̈ mantitacama cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrpacha tii muntuquiz ana tjonchinc̈ha, sirwita cjisjapa. Antiz wejrc̈ha tjonchinqui, z̈oñinacz̈quiz sirwisjapa, wejr ticzcama. Jalla nuz̈ ticz̈cu walja preciochiztakal cjeec̈ha, z̈oñinaca liwriizjapa. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jalla nekztanaqui Jericó wajtquiztan ulnan, muzpa z̈oñinacaqui Jesusiz̈quiz apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jicz latuquin pucultan zur z̈oñi julzi z̈elatc̈ha. Ninacaqui Jesusaz̈ watñi nonz̈cu, kjawchic̈ha tuz̈ cjican: —Wejt Jiliri, Davidz̈ majchmajtquiztan tjonñi, wejrnacz̈ okznalla. ");
INSERT INTO capNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Nekz z̈ejlñi z̈oñinacaqui ninacz̈quiz ujzic̈ha, ch'uj cjeyajo. Ninacazti juc'anti kjawchic̈ha, tuz̈ cjican: —Wejt Jiliri, Davidz̈ majchmajtquiztan tjonñi, wejrnacz̈ okznalla. ");
INSERT INTO capNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jalla nekztan Jesusaqui tsijtscu, ninaca kjawzic̈ha. Kjawz̈cu ninacz̈quiz tuz̈ pewczic̈ha: —¿C̈hjuluz̈ werj paaj cjii anc̈hucya? ");
INSERT INTO capNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nii zur z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, wejtnaca c̈hjujquiz̈ c̈hjetinz̈inalla. ");
INSERT INTO capNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Nekztanaqui Jesusaqui ninacz̈quiz sint'izcu c̈hjujqui lanlanz̈inchic̈ha. Jalla nii orapacha cherñi cjissic̈ha. Jalla nekztanaqui Jesusiz̈quiz apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén watja z̈catz̈incan, Betfagé watja irantichic̈ha. Betfagé watjaqui Olivos cjita curu z̈catitac̈ha. Nicju irantican Jesusaqui pucultan tjaajinta z̈oñinaca cuchanchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Jalla nii najwkta watja oka. Jalla nicju mokta ljat azni wachaquic̈ha, niz̈aza pajk zjijc maltum wawchizza naa azniqui. Mokta jerz̈cu wejtquin akz̈caquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jakzilta z̈oñimiz̈ atajasaz̈ niiqui, niiz̈quiz anc̈hucqui “Wejt Jiliriz̈ pecc̈ha. Wajilla tjepunta cjequic̈ha tii azniqui”, nuz̈ cjican nii z̈oñz̈quiz cjequic̈ha. —Jalla nuz̈ mantichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jalla nii watchiqui profetaz̈ cjijrta taku cumplissic̈ha. Tuquitan nii profetaqui tuz̈ cjijrchic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión wajtchiz z̈oñinacz̈quiz tuz̈ chiya: Chera, anc̈huca chawc Jiliri tjonc̈ha, humilde kuzziz. Niz̈aza zjijc maltum aznuquiz yawchi tjonaquic̈ha, niz̈aza nii zjijc aznuz̈ maatanpacha tjonaquic̈ha. Jalla ninacaqui carga kuzñi aznunacac̈ha'”. Jalla nuz̈ cjijrchic̈ha nii profetaqui. ");
INSERT INTO capNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jalla nekztanaqui nii pucultanaqui ojkchic̈ha. Niz̈aza jaknuz̈t Jesusaqui mantitc̈haja, jalla niicama paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ninacaqui ljat azñi naaz̈a pajk zjijctanpacha akz̈quichic̈ha. Jalla nuz̈ akz̈cu, zquitinaca aznunacz̈ juntuñ caruntichic̈ha. Nekztan Jesusaqui yawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Niiz̈ ojkz jicz latuquiz muzpa z̈oñinaca z̈elatc̈ha. Ninacz̈ zquiti jiczquiz chjinzic̈ha. Yekjapaqui ramuz c̈hjañinaca murchic̈ha jiczquiz chjinzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tucquin ojkñi z̈oñinacami wirquin tjonñi z̈oñinacami chipcan walja wiwi kallantic̈hic̈ha, tuz̈ cjican: —¡Viva tii Yooz tjuuquiz tjonchi z̈oñi! ¡David cjita chawc Jilirz̈ majchmajtquiztan tjonñi! ¡Amqui rispittaj cjila! ¡Amquiz honora tjaataj cjila! ¡Yooz Ejpz̈quin zakaz honora tjaataj cjila! —Jalla nuz̈ wiwchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesusaz̈ Jerusalén watja luztan, tjapa nii chawjc wajtchiz z̈oñinacaqui walja ispantichi tjojknakchic̈ha. Niz̈aza walja pewcpewczic̈ha, tuz̈ cjican: —¿Jectpan teejo? ");
INSERT INTO capNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Z̈oñinacaqui tuz̈ kjaazic̈ha: —Tiiqui Jesusa cjita profetala. Nazaret de Galilea, jalla najwktan tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jalla nekztan Jesusaqui Yooz timpluquin luzzic̈ha. Jalla nicju tuyñinacami kjayñinacami timpluquiztan liwj tirkatchic̈ha zancchuccama. Niz̈aza paaz campiiñi z̈oñinacz̈ mizami pjocz̈inchic̈ha; paloma tuyñinacz̈ sillami pjocz̈inchizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jalla nuz̈ paaz̈cu tuz̈ cjichic̈ha: —Yooz Takuqui tuz̈ cjic̈ha: “Wejt kjuyaqui Yoozquin mayiziz kjuyac̈ha”. Anc̈huczti tjañinacz̈ kjuyaz̈takaz paachinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jalla nicju tsjii kjaz̈ zur z̈oñinaca Jesusiz̈quiz macjatz̈quichic̈ha, niz̈aza tsjii kjaz̈ zuch z̈oñinaca. Jesusaqui ninaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero timplu jilirinacami lii tjaajiñi maestrunacami jalla nii c̈hjetiñi milajru cherz̈cu, z̈awjchic̈ha. Niz̈aza ocjalanacaqui timpluquin Jesusiz̈quiz tuz̈ wiwchic̈ha: “¡David cjita chawc jilirz̈ majchmajtquiztan tjonñi! ¡Rispittaj cjila!” Jalla nuz̈ nonz̈cu timplu jilirinacami lii maestrunacami ancha z̈awjchic̈ha Jesusiz̈ quintra. ");
INSERT INTO capNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nekztan Jesusiz̈quiz paljaychic̈ha, tuz̈ cjican: —¿Tinacaz̈ chiita taku ana nonz̈jo? Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Nonznuc̈ha. Niz̈aza nii puntu Yooz takuqui tuz̈ cjic̈ha: “Ocjalanacami piz itzñi wawanacami wejttajapa honora zumpachaz̈ tjaaquic̈ha. Jalla nuz̈ paaquic̈ha Yoozqui”. ¿Jalla nii cjijrta Yooz taku liichinc̈huckaya; ana jaa? ");
INSERT INTO capNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jalla nekztanaqui ninacz̈quiztan ojkchic̈ha. Betania watja ojkchic̈ha. Jalla nicju alujassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jakataz̈uqui wenzlaka Jerusalén watja quejpcan c̈hjeri eecskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jicz latuquiz higo munti cherchic̈ha. Jalla nii muntiquin macjatchic̈ha, fruta apakz̈cu lujlzjapa. Pero fruta ana wajtchic̈ha, c̈hjañchiz alajatac̈ha. Jalla niz̈tiquiztan Jesusaqui nii muntiquiz cjichic̈ha: —Jazic anam iya fruta pookñi cjequic̈ha. Jalla nii orapacha nii muntiqui kjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jalla niz̈ta munti kjonñi cherz̈cu, tjaajinta z̈oñinacaqui ispantichic̈ha, niz̈aza Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan nii higo munti ratulla kjonya? ");
INSERT INTO capNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesusaqui tuz̈ kjaazic̈ha: —Weraral anc̈hucaquiz cjiwc̈ha. Anc̈hucqui Yoozquin tjapa kuztanc̈hucc̈halaj niiqui, niz̈aza ana payznakñi kuzzizc̈hucc̈halaj niiqui, tii irata zakaz paasac̈ha. Niz̈aza juc'ant pajk milajru paasac̈ha. Tii curumi mantasac̈ha, tuz̈ cjican: “Tekz̈tan oka. Pajk kotquin tjojtsna”. Jalla nuz̈ mantiz̈cu niz̈ta zakaz okasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Niz̈aza anc̈hucqui c̈hjulumi tjapa kuztan Yoozquiztan mayac̈haja, jalla niit jama anc̈hucaquiz tjaataz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jerusalén irantiz̈cu Jesusaqui wilta timpluquin luzzic̈ha. Jalla nicju tjaajnan, timplu jilirinacami wajtchiz jilirinacami niiz̈quiz macjatz̈quichic̈ha. Nekztan pewczic̈ha, tuz̈ cjican: —¿Jec am mantichi tii paazjapajo? ¿Jec jilirit am utchi jiliriz̈takaz cjisjapajo? ");
INSERT INTO capNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Wejrzal anc̈hucaquiz tsjii pewcznac̈ha. Anc̈hucqui wejtquiz kjaaznaquiz̈ niiqui, wejrzakal anc̈hucaquiz maznac̈ha, jec wejr mantichi, nii. ");
INSERT INTO capNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wejtquiz kjaaznalla. ¿Ject Juan mantiz̈quichi bautisjapaya? ¿Yoozkaya, z̈oñinaca, ja'? Jalla nekztanaqui ninacpora parlatc̈ha, tuz̈ cjican: —¿Jaknuz̈um cjeequi? Uc̈humz̈ “Yoozqui Juan mantichic̈ha” cjicanz̈ kjaaznaquiz̈ niiqui, jalla tiicni uc̈humnacaquiz kjaaznac̈han, cjican: “Niz̈tiquiztan ¿kjaz̈tiquiztanz̈ anc̈hucqui ana nii criichinc̈hucta?” ");
INSERT INTO capNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Niz̈aza uc̈humz̈ “Zoñiqui Juan mantichic̈ha” cjicanz̈ kjaaznaquiz̈ niiqui, z̈oñinacaqui uc̈humnacaquiz ¿kjaz̈ cjiquejo? —Jalla nuz̈ parlatc̈ha. Z̈oñinacaqui Juanz̈ puntu cjiñic̈ha, Yooz parti parliñi profetac̈ha niiqui. Jalla niz̈tiquiztan ninacaqui z̈oñinaca eksic̈ha, “Uc̈hum conac̈hani”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jalla nuz̈ parliz̈cu ninacaqui Jesusiz̈quiz cjichic̈ha: —Ana zizuc̈ha wejrnacqui. Jalla niz̈ta kjaaztiquiztan Jesusaqui cjichic̈ha: —Wejrmi ana zakal anc̈hucaquiz maznac̈ha, jec wejr mantichi tii paazjapa. ");
INSERT INTO capNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wiruñaqui Jesusaqui tsjii puntu chiichic̈ha, tuz̈ cjican: —Tii puntu tantiya. Tsjii z̈oñiqui pucultan majchwichtac̈ha. Tsjiiz̈quiz cjichic̈ha: “Wejt maati, tonjiqui uwas frut ajzñi oka”. ");
INSERT INTO capNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Nii mantita maatiqui tuz̈ kjaazic̈ha: “Anac̈ha”. Jalla niiz̈ wiruñalla niiz̈ kuz campiichic̈ha. Nekztan uwas frut langzñi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Niz̈aza nii ejpqui tsjii maati cheri ojkchic̈ha. Niiz̈tan zalz̈cu, niz̈tazakaz uwas frut ajzñi mantichic̈ha. Jalla niiqui kjaazic̈ha, tuz̈ cjican: “Tata, okasac̈ha”. Ultimquiziqui nuz̈ cjiscuqui ana ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nii pucultanquiztan ¿jakzilta maatit niiz̈ ejpz̈ mantitacama paachiya? Ninacaqui kjaazic̈ha tuz̈ cjican: —Primiru mantitaz̈, jalla niic̈ha. Jalla nekztanaqui Jesusaqui cjichic̈ha: —Weraral anc̈hucaquiz cjiwc̈ha. Impuesto cobriñinacami, niz̈aza ujchiz maatakanacami arajpach Yooz wajtquiz anc̈hucz̈ tuqui luzaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Juan Bautistaqui tjaajñi tjonchic̈ha, jaknuz̈t anc̈hucalaqui kamz̈taz̈laja, jalla nii tjaajinchic̈ha. Pero anc̈hucqui niiz̈ tjaajinta ana criichinc̈hucc̈ha. Impuesto cobriñinacazti niz̈aza ujchiz maatakanacazti niiz̈ tjaajinta criichic̈ha. Jalla nii cherchinc̈huc̈ha anc̈hucqui. Jalla niz̈tanaca cherz̈cumi, anc̈hucqui ana Yoozquin cjisjapa kuz campiichinc̈hucc̈ha. Anc̈hucc̈ha niiz̈ taku ana criichinc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","‛Jalla tii quintu zakaz nonz̈na. Tsjii yokchiz patrunaqui uwas zkala c̈hjacchic̈ha. Nekztan uwas zkal muytata pirka pirkichic̈ha. Niz̈aza tsjii maz ojt paachic̈ha, uwas kjaz spjijtzjapa. Niz̈aza tsjii campanturiz̈ cherchi kjuychic̈ha, nii zkala itzjapa. ‛Nekztan nii patrunaqui zkal yoka alquilchic̈ha piyunanacz̈quiz. Nekztan jicz ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Zkala ajz timpu irantiz̈can, patrunaqui tsjii kjaz̈ piyuna cuchanz̈quichic̈ha, niiz̈ parti zkala ricujajo. ");
INSERT INTO capNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero nii zkala alquilñi z̈oñinacazti nii cuchanz̈quita piyunanaca tanchic̈ha. Tsjiiqui kitz̈tac̈ha. Tsjiiqui contac̈ha. Tsjiiqui maztan c̈hajctac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Nekztanaqui patrunaqui wilta piyunanaca cuchanz̈quichic̈ha, primirquiztan juc'anti. Pero nii zkala alquilñi z̈oñinacazti niz̈tapacha ana wali paachizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ultimquiziqui patrunaqui niiz̈ persun majch cuchanz̈quichic̈ha, tuz̈ tantiican: “Wejt ultim maatiqui rispitz̈inaa” cjican. ");
INSERT INTO capNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Niiz̈ majch cherz̈cu, nii alquilñi z̈oñinacaqui ninacpora palt'ichic̈ha, tuz̈ cjican: “Jalla tiikat liwj tii irinsa tanznac̈hani. Jalla niz̈tiquiztan z̈-conla, uc̈humnacaltajapa tii yok irinsa cjeyajo”. ");
INSERT INTO capNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jalla nekztanaqui nii z̈oñinacaqui majch tanchic̈ha; nekztan yokquiztan jwescu conchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jalla nekztanaqui Jesusaqui pewczic̈ha, tuz̈ cjican: —Jalla nii patrunpacha tjonz̈cu, ¿c̈hjulukat nii alquilñi z̈oñinacz̈tajapa paac̈hani? ");
INSERT INTO capNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Z̈oñinacaqui kjaazic̈ha tuz̈ cjican: —Nii ana wal z̈oñinacaqui contaz̈ cjequic̈ha, ana importayz̈cu. Nekztan nii zkal yoka yekja piyunanacz̈quiz alquilaquic̈ha, zkala ajz timpu niiz̈ parti zkala ricujz̈cu niiz̈quiz tjaata cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha: —Yooz takuqui tuz̈ cjic̈ha: “Kjuy pirkiñinacaqui tsjii maz tjojtchic̈ha. Nii tjojta mazqui isquinquiz cjissic̈ha. Juc'ant chekan mazqui cjissic̈ha. Yoozqui nuz̈ utchic̈ha. Uc̈humqui jalla nii cherz̈cu ispantichic̈ha”. Jalla nuz̈ cjic̈ha cjijrta Yooz takuqui. Anc̈hucqui nii Yooz taku liichinc̈hucc̈ha, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Anc̈hucaquiz chiiz̈inuc̈ha, anc̈hucqui nii ana wal alquilñi z̈oñinacaz̈takazza. Jalla niz̈tiquiztan anc̈hucqui Yooz kjuychiz famillquiztan chjatkattaz̈ cjequic̈ha. Yekja z̈oñinacaqui Yooz famillquiz luzaquic̈ha. Yooz kuzcama kamñi z̈oñinacaqui luzaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nonz̈na. Maz puntuquiztan zakal chiyuc̈ha. Jakziltat nii maz cjen ujquiz tjojtsnac̈haja, jalla niiqui pirasuz̈takaz t'okuntaz̈ cjequic̈ha. Niz̈aza jakziltiz̈ juntuñ nii mazqui tjojtsnaquiz̈ niiqui, pulpuz̈takaz t'okuntaz̈ cjequic̈ha. Nii z̈oñinacaqui k'ala akz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jalla nii Jesusiz̈ chiita takunaca nonz̈cu, timplu jilirinacami, fariseo parti jilirinacami tantiichic̈ha, ninacz̈ puntu chiiñi, nii. ");
INSERT INTO capNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jalla nuz̈ tantiiz̈cu, Jesusa tanz pecatc̈ha. Pero ana atchic̈ha, parti z̈oñinaca ekscu. Parti z̈oñinacaqui Jesusiz̈ puntu tantiyatc̈ha, Yooz taku parliñi profetac̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jalla nekztanaqui Jesusaqui wilta tjaajinchizakazza. Jalla tuz̈ cjican quint'ichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Arajpach Yooz kjuychiz familiaqui jalla tuz̈uc̈ha. Tsjii chawjc jiliriqui niiz̈ majchtajapa zalz pjijsta paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Niiz̈ piyunanaca cuchanchic̈ha, invitta z̈oñinaca kjawzñi. Nii kjawz̈ta z̈oñinacaqui ana tjonz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nekztanaqui yekja piyunanaca cuchanchizakazza, tuz̈ cjican: “Invitta z̈oñinacz̈quin mazca, ‘Chjeri lujlz tjacztac̈ha. Wejt wacanaca conkatchinc̈ha, niz̈aza cjew animalanacami. Tjappacha listuc̈ha, jaziqui pjijstiquin tjonla’ ”. ");
INSERT INTO capNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jalla nuz̈ chiyanami nii invitta z̈oñinacaqui ana cazquichic̈ha. Tsjiiqui zkal yoka ojkchic̈ha. Tsjiiqui tuyz̈tan ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Parti invitta z̈oñinacaqui kjawzñi cuchanta piyunanaca tanzic̈ha. Nekztan kitchic̈ha, conañcama. ");
INSERT INTO capNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jalla nekztanaqui nii chawc jiliriqui ninacz̈ quintra z̈awjzic̈ha. Nekztan zultatunaca cuchanz̈quichic̈ha, nii piyuna conñinaca conz̈cajo. Niz̈aza, ninacz̈ watja ujz̈cajo. ");
INSERT INTO capNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jalla niz̈ta paaz̈cu chawc jiliriqui piyunanacz̈quiz cjichic̈ha: “Tjappacha zalz pjijstac listuc̈ha. Nii primir invitta z̈oñinacaqui ana tjonz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jalla niz̈tiquiztan anc̈hucqui pajk calliranz̈ ojklayz̈ca. Jecnacz̈tanami zalac̈haja, jalla ninacz̈quiz tjonajum cjequic̈ha tii zalz pjijstiquin”. ");
INSERT INTO capNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jalla nekztanaqui piyunanacaqui call kjutñi ulanchic̈ha, niz̈aza tjapa niiz̈ zaltanaca kjuyquiz ajcskatz̈quichic̈ha, zuma z̈oñimi, ana zuma z̈oñimi. Jalla nekztanaqui pjijsta paaz kjuyaqui chjijpsi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‛Jalla nekztanaqui chawjc jiliriqui luzquichic̈ha invitta z̈oñinaca cherzñi. Tsjii z̈ejlñi z̈oñi naychic̈ha, ana pjijsta paaz zquiti cutchi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jalla nuz̈ nayz̈cu nii chawjc jiliriqui niiz̈quin paljaychic̈ha tuz̈ cjican: “Jila, ¿kjaz̈tiquiztan amqui ana pjijsta paaz zquiti cujtchi luzquichamtajo?” Nii z̈oñiqui ch'uj quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nekztanaqui chawjc jiliriqui pjijsta atintiñi z̈oñinacz̈quiz mantichic̈ha, tuz̈ cjican: “Kjojchanacami kjaranacami c̈hejlz̈ina. Zawnc zumchiquiz tjojta, jalla nicju kaala, niz̈aza niiz̈ iz̈ke kjojla”. ");
INSERT INTO capNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesusaqui cjichizakazza: —Kjawz̈ta z̈oñinacaqui tamac̈ha. Illzta z̈oñinacaqui kolucullac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jalla nekztanaqui fariseo z̈oñinacaqui ojkchic̈ha. Ninacaqui acuerduquiz kazzic̈ha, Jesusiz̈ quintra tsjii ujchiz cjiskatzjapa. Jaknuz̈umi Jesusa tsjii ana wali chiikataquic̈ha; jalla nii ujchiz cjiskatz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jalla nekztan ninacz̈ partiquiztan yekjap z̈oñinaca cuchanz̈quichic̈ha, Herodes parti z̈oñinacz̈tanpacha. Jalla nii cuchanta z̈oñinacaqui Jesusiz̈quiz cjichic̈ha: —Maestro, wejrnac zizuc̈ha, amqui werarapan chiic̈ha, niz̈aza Yooz kamañ puntuquiztan weraram tjaajiñamc̈ha, kjaz̈tami z̈oñiqui chiic̈hani, niz̈aza kjaz̈ta z̈oñimi z̈elac̈hani. ");
INSERT INTO capNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jaziqui amqui tii tantiiz̈inalla. ¿Roman chawc jilirz̈quin impuesto pacz wali cjesaya? uz̈ ¿anaz̈ wali cjesaj? Jalla nii ziz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero Jesusaqui ninacz̈ ana zuma pinsita intinzuna zizzic̈ha. Jalla niz̈tiquiztan ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Ana zum kuzziznaca, ¿kjaz̈tiquiztan anc̈hucqui wejt quintra uj jwes pecjo? ");
INSERT INTO capNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Impuesto pacz paaz tjeezna. Jalla nekztan tsjii denario cjita paaz zjijcchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jalla nii paaz cherz̈cu, Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Tii paazquiz ¿jecz̈ yujctaya? Niz̈aza tii cjijrta tjuu, ¿jecz̈ tjuutaya? ");
INSERT INTO capNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Nii quintranacaqui kjaazic̈ha, tuz̈ cjican: —Roman chawc jilirz̈tac̈ha. Jesusaqui nekztan cjichic̈ha: —Roman chawc jilirz̈taqui jalla nii jilirz̈quin tjaasa. Niz̈aza c̈hjulut Yooztaqui Yoozquinpan tjaasa. ");
INSERT INTO capNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jalla nuz̈ nonz̈cu, nii quintranacaqui ispantichic̈ha. Nekztan Jesusiz̈quiztan zarakz̈cu ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jalla nii noojpacha yekjap saduceo parti z̈oñinacaqui Jesusa cheri ojkchic̈ha. Saduceo parti z̈oñinacaqui ana criiñitac̈ha, ticziquiztan jacatatz, nii. Jalla nuz̈ cjenami Jesusiz̈quiz pewczic̈ha. Tii quintu quint'ican, pewczic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Maestro, Moisesaqui uc̈humnacalta cjijrtkalc̈ha, tuz̈ cjican: “Tsjii z̈oñi ticznasaz̈ niiqui, niiz̈ tjun ana ocjalchiz cjesaz̈ niiqui, nekztan nii ticzi z̈oñz̈ jilaqui naa z̈ewatan zalz waquizic̈ha, nii ticzi jilz̈ cuntiquiztan ocjala paazjapa”. ");
INSERT INTO capNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jaziqui wejrnacporquiz pakallak jilazullca z̈elatc̈ha. Jilir jilaqui zalsic̈ha. Nekztan ticzic̈ha ana ocjalchiz. Jalla nekztan jilirz̈ jar jilaqui naa z̈ewatan zalsizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Nii jilaqui ticzizakazza ana zinta ocjala ecz̈cu. Nekztan yekja taypir jilz̈tan niz̈tazakaz watchic̈ha. Niz̈aza tjappach nii pakallak jilazullquiz̈quiz niz̈ta watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Tjapa nii pakallak jilazullcaz̈ ticztan, naa z̈ewqui ticzinzakazza. ");
INSERT INTO capNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jaziqui ticziquiztan jacatatz̈cu, naa z̈ewqui ¿jakziltiz̈ tjun cjequejo? Tjappacha naatancama zalzitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Anc̈hucqui tsjii kjutñi kiwkchinc̈hucc̈ha. Anc̈hucqui Yooz takumi ana zuma zizza. Niz̈aza Yooz azimi ana pajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ticzi z̈oñinacaz̈ jacatattanaqui zalzqui ana z̈elaquic̈ha. Z̈oñinacami z̈oñz̈ maatinacami ana zalznaquic̈ha. Nii timpuquiz z̈oñinacaqui arajpach Yooz anjilanacaz̈takaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero nii ticziquiztan jacatatz puntu, ¿Yooz tawkquiz ana tuz̈ liichinc̈hucjo? Tii puntuquiztan Yoozpachaz̈ chiichiqui. Jalla tuz̈ cjican Yoozqui cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Wejrqui Abrahamz̈ Yoozza, niz̈aza Isaacz̈ Yoozza, niz̈aza Jacobz̈ Yoozza”. Anac̈ha ticzi z̈oñz̈ Yoozqui. Antiz z̈ejtñi z̈oñz̈ Yoozza. ");
INSERT INTO capNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jalla nuz̈ chiita nonz̈cu, nekz z̈ejlñi z̈oñinacaqui Jesusiz̈ chiitiquiztan ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jalla nuz̈ chiiz̈cu Jesusaqui saduceo parti z̈oñinaca ch'uju paachic̈ha. Jalla nuz̈ ch'uj paatiquiztan fariseo parti z̈oñinacaqui wilta ajczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Tsjii lii maestruqui niz̈aza fariseo partinacz̈quiztan uj jwesjapa yanz pecatc̈ha. Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Maestro, uc̈hum liiquiztanaqui ¿c̈hjul mantitat juc'ant chekanaya? ");
INSERT INTO capNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tii mantitac̈ha juc'ant chekanaqui. “Anc̈huca Yooz Ejp Jilirz̈quiz sirwa, tjapa kuztanami, tjapa animuz̈tanami, tjapa pinsamintuz̈tanami”. ");
INSERT INTO capNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Parti mantitanacquiztan cjenaqui jalla niic̈ha chekanaqui. ");
INSERT INTO capNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Niiz̈ jaru tii mantitaqui z̈ejlc̈ha. “Jaknuz̈um persunpachquiz okzñamz̈laja, jalla niz̈ta okzñi kuzziz cjistanc̈ha z̈oñinacz̈quizimi, liijitum maziz̈takaz”. ");
INSERT INTO capNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Jalla nii pizc mantitanacac̈ha chekanaqui. Niz̈aza tjapa Moisés tjaata liimi, niz̈aza tjapa profetanacaz̈ tjaajintanacami nii pizc mantitanacz̈ partiquiztan chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo z̈oñinacaz̈ ajczi z̈elan, Jesusaqui ninacz̈quiz pewczic̈ha tuz̈ cjican: —Anc̈hucqui Cristumz̈ puntuquiztan tantiya. ¿Cristuqui jecz̈ majch niiqui? ");
INSERT INTO capNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Nekztanaqui ninacaqui Jesusiz̈quiz kjaazic̈ha, tuz̈ cjican: —Davidz̈ majchmajtquiztan tjonñic̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jalla nuz̈ kjaaztiquiztan Jesusaqui ninacz̈quiz cjichic̈ha: —David jiliriqui Cristuz̈ puntuquiztan chiican, “Chawc Jiliri” cjichic̈ha. Jalla nuz̈ chiiz̈cu, Yooz Espíritu Santuz̈ chiikatchiqui. ");
INSERT INTO capNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Davidaz̈ cjijrta Yooz takuqui tuz̈ cjic̈ha: “Yooz Jiliriqui wejt chawjc Jilirz̈quiz cjichic̈ha: ‘Wejrqui am kjojch koztan am quintri z̈oñinaca tjeczkatac̈ha. Nii oracama wejt z̈ew latuquiz julzna’.” ");
INSERT INTO capNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Jaziqui Davidaqui “chawjc Jiliri” cjichic̈ha Cristuz̈ puntuquiztan. Jalla niz̈tiquiztan ¿jaknuz̈t nii chawjc Jiliri Davidz̈ majchqui cjesajo? —Jalla nuz̈ pewczic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Anaz̈ jecmi kjaazñi atchic̈ha, ana zinta takumi. Jalla nuz̈quiztanpacha ana c̈hjulumi pewczñi atchizakazza iya. Jalla nii orquiztanpacha pecunz eksipanc̈ha nii quintra z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jalla nekztanaqui Jesusaqui nekz z̈ejlñi z̈oñinacz̈quizimi niiz̈ tjaajinta z̈oñinacz̈quizimi tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Lii tjaajiñi maestrunacami niz̈aza fariseo z̈oñinacami persun puntuquiztan tuz̈ tantiic̈ha, tjaajinz puestuquiz uchtac̈ha Moisés liiquiztan punta punta tjaajinzjapa, nii. Jalla nuz̈ tantiic̈ha persun amtiquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Anc̈hucqui ninacaz̈ tjaajintacama oka. Niz̈aza ninacaz̈ chiitacama paa. Pero ninacz̈ kamz jaru, ana kama. Ninacaqui tjaajinc̈ha, pero persun tjaajinta jaru ana ojkc̈ha, ana cumplic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ninacaqui walja mantitanaca paac̈ha, walja kuziz̈takaz z̈oñinacz̈quiz jepc̈ha. Tjapa ninacz̈ mantitanacaqui anapan atchucac̈ha. Jalla nuz̈ cjenami tjapa mantitanaca z̈oñinacz̈quiziqui tirapanz̈ ijsijc̈ha. Pero ninacapacha anaz̈ c̈hjulquizimi yanapc̈ha nii cumplisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ninacaqui c̈hjulu paatami paac̈ha, z̈oñinacakaz cherajo. Yujc ayquizimi kjarquizimi cjijrta Yooz taku jweranchiz̈ ojklayc̈ha, niz̈aza parti z̈oñinacz̈quiztan juc'anti lajch chjajlchiz zquiti cujtchiz̈ ojklayc̈ha. Jalla niz̈taz̈ ojklayz̈ juztazza. ");
INSERT INTO capNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pjijstiquiz cjen tucquin panz̈ julz pecc̈ha. Niz̈aza ajcz kjuyquiz cjen tucquin panz̈ julz pecc̈ha honorchiz cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ninacaqui z̈oñinacz̈ taypiquiz cjen rispitz̈tan tsaanta cjis pecc̈ha, niz̈aza “Maestro” cjita cjis pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‛Anc̈hucqui anac̈ha z̈oñinacz̈quiz “maestro” cjita cjis peczqui. Tjapa anc̈hucqui jilazullquic̈hucc̈ha. Tsjii Maestruchizc̈huckazza. Cristuc̈ha nii Maestruqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Niz̈aza anc̈hucqui tii muntuquiz kamcan anaz̈ jecz̈quizimi “ejp” cjican chiiz waquizic̈ha. Tsjii Ejpchizc̈huckazza. Arajpach Yooz Ejpc̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Niz̈aza anc̈hucqui anac̈ha z̈oñinacz̈quiz “jiliri” cjita cjis peczqui. Tsjii jilirchizc̈hucc̈ha. Cristuc̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Anc̈hucquiztan jequit jiliriz̈takaz cjis pecc̈haja, jalla niiqui piyunaz̈takaz cjis waquizic̈ha parti z̈oñinacz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jequit persun honora waytiz pecc̈haja, ultimquiziqui ana honorchiz cjequic̈ha. Niz̈aza jequit humilde kuzzizlaja, jalla niiqui ultimquiziqui honorchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‛Lii tjaajiñi maestrunaca, niz̈aza fariseo parti z̈oñinaca, ana zuma kuzziz z̈oñinacc̈hucc̈ha. Anc̈hucqui anawalipanz̈ cjisnaquic̈ha. Z̈oñinaca atajiñc̈hucc̈ha, arajpach Yooz wajtchiz ana luzajo. Anc̈hucpachaz̈ ana luzza, niz̈aza pecchi cjenami parti z̈oñinacz̈quizimi ana luzkatiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Lii tjaajiñi maestrunaca, niz̈aza fariseo z̈oñinaca, ana zuma kuzziz z̈oñinacc̈hucc̈ha. Anc̈hucqui anawalipanz̈ cjisnaquic̈ha. Z̈ew maatakanacz̈quiztan kjuy cusasanaca kjañiñc̈hucc̈ha. Jalla nuz̈ paaz̈cumi nii maataka incallzjapa az̈ka az̈ka Yoozquin maytaz̈oka payiñc̈hucc̈ha ninacz̈tajapaz̈takaz. Jalla nuz̈ paatiquiztan anc̈hucqui juc'anti castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‛Lii tjaajiñi maestrunaca, fariseo z̈oñinaca, ana zum kuzziz z̈oñinacc̈hucc̈ha. Jaziqui anc̈hucqui anawalipanz̈ cjisnaquic̈ha. Anc̈hucqui jaknuz̈umi anc̈huca cuzturumpi jaru z̈oñinaca ojkkatzkaz pecc̈ha. Jalla nuz̈ ojkkatz̈cuqui anc̈hucqui nii z̈oñinaca anc̈hucaquiztan pizc wilta wilta juc'anti anawaliz̈ cjiskatc̈ha, infiernuquin casticta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‛Anc̈hucqui anawalipanz̈ cjisnaquic̈ha, zur z̈oñiz̈takaz irpiñinaca. Anc̈hucqui cjiñc̈hucc̈ha: “Jakziltat timplu tistiwcchiz juramintu paaquiz̈ niiqui, jalla nii juramintuqui anaz̈ walc̈ha. Pero jakziltat timplu kor paaz tistiwcchiz juramintu paaquiz̈ niiqui, jalla nii juramintuqui walc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Zumzu zur z̈oñinaca. ¿Jakziltat juc'ant chekanaqui, timpluquin z̈ejlñi korinacakaya, uz̈ timplupanej? Timpluz̈ cjen nii korinacaqui walc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Niz̈aza anc̈hucqui cjiñc̈huczakazza: “Jakziltat timplu altar tistiwcchiz juramintu paaquiz̈ niiqui, jalla nii juramintuqui anaz̈ walc̈ha. Pero jakziltat altarquin uchta ofrenda tistiwcchiz juramintu paaquiz̈ niiqui jalla nii juramintuqui walc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Zumzu zur z̈oñinaca. ¿Jakziltat juc'ant chekanaqui, ofrendakaya, uz̈ altarapanej? Altaraz̈ cjen nii ofrendaqui walc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jakziltat altar tistiwcchiz juramintu paaquiz̈ niiqui, niz̈aza tjapa nii altar juntuñ z̈ejlñinaca tistiwcchiz juramintu paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Niz̈aza jakziltat timplu tistiwcchiz juramintu paaquiz̈ niiqui, niz̈aza timpluz̈ Yooz tistiwcchiz juramintu paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Niz̈aza jakziltat arajpach tistiwcchiz juramintu paaquiz̈ niiqui, niz̈aza arajpach Yooz tistiwcchiz juramintu paac̈ha. Yoozqui arajpachquin z̈ejlc̈ha, niz̈aza arajpachquiztan mantic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‛Lii tjaajiñi maestrunaca, niz̈aza fariseo z̈oñinaca, ana zum kuzziz z̈oñinacc̈hucc̈ha. Anc̈hucqui anawalipanz̈ cjisnaquic̈ha. Anc̈hucqui diezmos tjaayiñc̈hucc̈ha mentquiztan, anizquiztan, cominquiztan. Jalla nii kolta plantanacquiztan anc̈hucqui diezmos tjaayiñc̈hucc̈ha. Pero anc̈hucqui liiz̈ chekan mantitanac jaru ana kamiñc̈hucc̈ha. Yooz kuz jaru ana kamiñc̈hucc̈ha, niz̈aza ana okzñi kuzzizc̈hucc̈ha; niz̈aza ana Yoozquin kuzzizc̈hucc̈ha. Jalla niz̈ta chekan lii jaru ana kamiñc̈hucc̈ha. Jalla niz̈ta jaru kamz waquizic̈ha, diezmos tjaacanami. ");
INSERT INTO capNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anc̈hucqui zur irpiñinaca. Tiz̈ta irata paayiñc̈hucc̈ha. Tsjii z̈oñiqui kolta zmoyalla culchic̈ha ana lujlzjapa. Jalla nuz̈ cjenami pajk ana wali animala ana culz̈cu lujlchic̈ha. Jalla niz̈ta irata paayiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‛Liy tjaajiñi maestrunaca, niz̈aza fariseo z̈oñinaca, ana zum kuzziz z̈oñinacc̈hucc̈ha. Anawalipanz̈ cjisnaquic̈ha anc̈hucqui. Wazumi chuwami zawnctanaqui ajuntaz̈ cjesac̈ha. Jalla nuz̈ cjenami kjuyltan cjujchiz̈ cjesac̈ha. Jalla niz̈taz̈ anc̈hucqui. Zawncta curpuqui walikaz chercherc̈ha. Anc̈huca kuzquizzti cjujchinacaz̈takaz z̈ejlc̈ha. Tjañi zaazmi anawali paazmi jalla niz̈ta kuzzizc̈hucc̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Zur fariseo z̈oñinaca, primiruqui zuma kuzziz cjisna ajunta chuwaz̈takaz; nekztanaqui zuma z̈oñiz̈ tsijtchizakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‛Lii tjaajiñi maestrunaca, niz̈aza fariseo z̈oñinaca, ana zum kuzziz z̈oñinacc̈hucc̈ha. Anawalipanz̈ cjisnaquic̈ha anc̈hucqui. Chiw ljocz̈tan tjarta sipulturuz̈takazza anc̈hucqui. Anc̈huca tsitiqui walikazza. Anc̈huca kuzzti ana walipanc̈ha. Sipultura ticzi z̈oñinacz̈ tsjijnacz̈tan chjijpsi, niz̈ta ana walic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jalla niz̈taz̈ anc̈hucqui. Z̈oñinacaqui anc̈huc zuma z̈oñiz̈takaz nayc̈ha. Pero anc̈huca persun kuzquizzti juc'ant anawalinaca z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‛Lii tjaajiñi maestrunaca, niz̈aza fariseo z̈oñinaca, ana zum z̈oñinacc̈hucc̈ha. Anawalipanz̈ cjisnaquic̈ha. Anc̈hucqui profetanacz̈ sipulturunaca azquichiñc̈hucc̈ha, niz̈aza Yooz kuzcama kamñita z̈oñinacz̈ monumentunaca c'achjalla cjiskatiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Niz̈aza nii zuma z̈oñinacz̈ puntuquiztan tuz̈ cjiñc̈hucc̈ha: “Uc̈hum tuquita atchi ejpnacaqui anawali kamchic̈ha. Wejrnacqui nii tuqui timpuquiz kamtasaz̈ niiqui, anaz̈ profetanaca conzjapa yanaptasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jalla nuz̈ chiican, anc̈hucpacha chiic̈ha, profeta conñi z̈oñinacz̈ majchmaatic̈hucc̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Jaknuz̈t anc̈huca tuquita atchi ejpnacaqui anawali paatc̈haja, jalla niz̈tazakaz payiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‛Zkoraz̈takaz z̈oñinaca. Zkoraz̈ta sarchiz z̈oñinaca. Anc̈hucqui anapanz̈ wira atipasac̈ha infiernuquin casticzquiztanaqui. Castictapanz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Anc̈huc juc'ant casticta cjisjapa, anc̈hucaquiz cuchanz̈cac̈ha profetanaca, niz̈aza Yooz puntu zuma zizñinaca, niz̈aza Yooz puntu tjaajinñinaca. Jalla nii z̈oñinaca cuchanz̈quichiz̈ cjen, anc̈huczti tsjii yekjanaca conaquic̈ha, yekjanaca cruzquiz ch'awcznaquic̈ha, yekjanaca ajcz kjuyquizpacha wjajtaquic̈ha. Niz̈aza yekjanaca wajtquiztan watja tanzjapa apznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jalla nuz̈ paatiquiztan anc̈huca ujnacquiztanami niz̈aza anc̈huca tuquita atchi ejpnacz̈ ujnacquiztanami caztictaz̈ cjequic̈ha. Anc̈huca atchi ejpnacaqui zuma z̈oñi conchic̈ha, Abelquiztanpacha asta Berequías majch Zacarías, jalla niicama. Zacariasqui timpluquizpacha contatac̈ha, altar z̈cati. ");
INSERT INTO capNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Anc̈hucaquiz weraral cjiwcha. Tjapa nii uj paatanacquiztan casticta cjequic̈ha tii timpuquiz kamñi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nekztan Jesusaqui chiichic̈ha, tuz̈ cjican: Jerusalén wajtchiz z̈oñinaca, Jerusalén wajtchiz z̈oñinaca. Profetanaca coniñc̈hucc̈ha. Niz̈aza Yooz cuchanz̈quita profetanaca maztan c̈haciñc̈hucc̈ha. Kjaz̈ wilta wejrqui tii z̈oñinaca juntis pecchinc̈ha, cwitisjapa. Jaknuz̈t wallpiqui kjar koztan ozmachanaca cwitic̈haja, jalla niz̈ta irata tii z̈oñinaca cwitis pecchinc̈ha. Tii z̈oñinacazti wira ana nuz̈ cwitiskatz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tii taku nonz̈na. Anc̈huca kjuyanacaqui jaytitaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Anc̈hucaquiz cjiwc̈ha. Tsjii noojiqui anc̈hucqui wejt puntuquiztan chiyaquic̈ha, tuz̈ cjican: “Yooz Jilirz̈ tjuuquiz tjonñi, amqui honorchiz cjila”. Jalla nii noojcama anc̈hucqui ana wejr wilta cheraquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nekztanaqui Jesusaqui timpluquiztan ulanchic̈ha. Nekztan niiz̈ tjaajinta z̈oñinacaqui niiz̈quin macjatz̈cu, tuz̈ cjichic̈ha: —Cherzna. Ancha c'achjac̈ha tii timplu kjuyanacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tjapa tii timplu kjuyanaca zumpacha cherzna. Anc̈hucaquiz weraral cjiwc̈ha. Tsjii noojiqui tii kjuyanacaqui k'ala pajltaz̈ cjequic̈ha. Ana zinta tii maznaca pirkita z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nekztan ninacaqui Olivos cjita curullquin ojkchic̈ha. Nicju Jesusaz̈ julzi z̈elan, tjaajinta z̈oñinacaqui niiz̈quiz jamazit tuz̈ cjichic̈ha: —Maznalla. ¿C̈hjulorat nii amiz̈ chiita wataqui? Niz̈aza am tjonz siñala, ¿jakziltat cjeequiya? Niz̈aza tii muntu tucuzinz siñala, ¿jakziltat cjeequiya? ");
INSERT INTO capNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nekztanaqui Jesusaqui kjaazic̈ha tuz̈ cjican: —Anc̈hucz̈ cwitaza, ana jecmi anc̈hucaquiz incallskata. ");
INSERT INTO capNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Muzpa z̈oñinacaqui wejt tjuuz̈tan tjonaquic̈ha, “Wejrtc̈ha Cristutqui” cjican. Jalla nuz̈ chiiz̈cu tama z̈oñinaca incalltaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Niz̈aza anc̈hucqui quira z̈ejlz̈ quintunaca zizaquic̈ha; niz̈aza yekja quira quintunaca arawasaquic̈ha. Jalla nuz̈ cjenami anaz̈ tsuca. Nuz̈ watstanc̈ha. Imazic̈ha tii muntu tucuzinzqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nacionpora talznaquic̈ha; niz̈aza quira paaquic̈ha. Niz̈aza mach'a z̈elaquic̈ha, niz̈aza conanaca ojklayaquic̈ha, niz̈aza walja yoka chekjincan terremotoz̈ wataquic̈ha, wacchi yokaran. ");
INSERT INTO capNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tjapa tii wattanaqui juc'anti t'akjiziz z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‛Jalla nekztanaqui anc̈hucqui jilirinacz̈quiz intirjitaz̈ cjequic̈ha sufriskatzjapa. Niz̈aza contaz̈ cjequic̈ha anc̈hucqui. Niz̈aza anc̈hucaz̈ wejtquiz criichiz̈ cjen, tjapa ana criichi z̈oñinacaqui anc̈huca quintraz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jalla nuz̈ watan, muzpa Yoozquin criichi z̈oñinacaqui quejpsnaquic̈ha. Yoozquin criichi z̈oñinacz̈ quintra cjisnaquic̈ha, jilirinacz̈quin intirjizcama. Criichi z̈oñinacz̈quiz ancha chjaawjkataquic̈ha nii quejpsñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Muzpa toscara chiiñinaca ojklayaquic̈ha, tuz̈ cjican: “Yooziz̈ tjaata takuc̈ha tiiqui”. Nii toscar takunacz̈tan muzpa z̈oñinacz̈quiz incallaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Anawalinacaz̈ miraquic̈ha. Z̈oñinacpora ana zuma munasaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jakziltat wejt tjonzcama tjurt'iñi kuzziz z̈elac̈haja, jalla niiqui ultimquiziqui liwriitaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Yooziz̈ liwriita z̈oñinacac̈ha Yooz kjuychiz familiaqui. Jalla nii zuma taku tjapa kjutñi tii muntuquiz parlitaz̈ cjequic̈ha, tjapa z̈oñinaca zizajo. Jalla nii wattanaqui tii muntuqui tucuzinznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‛Tii zakal cjiwc̈ha. Tii puntuquiztan Daniel cjita profetaqui cjijrchic̈ha: “Tsjii noojiqui tsjii juc'ant ana wali akñi z̈oñi parizaquic̈ha. Yooz chekan kjuyquinkaz luzaquic̈ha”. (Tii taku liiñiqui intintaza.) ");
INSERT INTO capNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Jalla nuz̈ cherz̈cu Judea yokquin z̈ejlñi z̈oñinacaqui curunacz̈quin atipz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Niz̈aza nuz̈ cherz̈cu kjuy juntuñ z̈ejlñi z̈oñinacaqui chjujz̈cu ana kjuya luzla, cusasanaca chjitzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Niz̈aza pampiquin z̈ejlñi z̈oñinacaqui persun zquiti apti ana quejpz̈quila. ");
INSERT INTO capNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nii tjuñquiziqui ic maatakanacami k'azllu wawchiz maatakanacami ancha t'akjiri z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yoozquinc̈ha mayiza anc̈hucqui, anaj zac timpuquin niz̈tanaca watsjapa, niz̈aza anaj jeejz tjuñquiz niz̈tanaca watsjapa. ");
INSERT INTO capNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tii sufris timpu juc'anti sufris cjequic̈ha yekja sufrisnacquiztanami. Yooz tii muntu paatiquiztan jecchuc anapanc̈ha tiz̈ta sufrisnacaqui watchiqui. Niz̈aza tekz̈tan najwcchuc anaz̈ iya juc'anti sufrisqui cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Yoozqui anaz̈ tii sufrisnaca tucuskatasaz̈ niiqui, tjapa z̈ejlñi z̈oñinacaqui ticznasac̈ha. Yoozqui niiz̈ illz̈ta z̈oñinacz̈ laycu nii sufrisnaca tucuskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‛Niz̈aza yekjap z̈oñinacaqui anc̈hucaquiz chiyasac̈ha, tuz̈ cjican: “Tekzic̈ha Cristuqui”. Yekjapac chiyasac̈ha, “Nii nacjuc̈ha Cristuqui” cjican. Jalla nuz̈ chiyanami anapanc̈ha nii taku criyaquic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Incallñi z̈oñinacaz̈ tjonaquic̈ha. Yekjapaqui “Cristutc̈ha wejrqui” cjequic̈ha. Yekjapaqui “Yooziz̈ tjaata taku mazniñtc̈ha wejrqui” cjequic̈ha. Ninacaqui walja ispantichuca milajrunacaz̈ paaquic̈ha, incallzjapa. Tjapa z̈oñinacaz̈ incallz pecaquic̈ha, asta Yooziz̈ illzta z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ima tiz̈tanacaz̈ tjonan wejrqui anc̈hucaquiz ultim weraral maznuc̈ha, ana incallta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Z̈oñinacaqui “Ch'ekti yokquin cherz̈quilalla, nicjuc̈ha Cristuqui” cjequic̈ha. Jalla nii quintu nonz̈cu, anapanz̈ okaquic̈ha. Niz̈aza “Tii kjuyquizza Cristuqui” cjequic̈ha. Jalla nii quintu nonz̈cu, anapan criyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","‛Anc̈hucaquiz cjiwc̈ha. Jalla tiz̈tal irata tjonac̈ha wejrqui. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jaknuz̈t lliwjlliwjñi tuwantan tajachuc lliwjc̈haja, jalla nuz̈ tjonac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jakziquin zerwi z̈ejlc̈haja, jalla nekzi zkaranacaz̈ ajcznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‛Nekztanaqui tii sufris timpu wattan, tjuñiqui zumaquic̈ha; kataquic̈ha, ana iya kjanaquic̈ha. Jiizmi niz̈azakaz ana iya kjanaquic̈ha. Warawaranacami pachquiztan tjojtsnaquic̈ha. Niz̈aza tseecu azziz z̈ejlñinacaqui chjekinskattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jalla nekztanaqui arajpachquin wejt siñalaqui parisaquic̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jalla nuz̈ wejt siñala cherz̈cu tjapa ana criichi z̈oñinacaqui kaaquic̈ha. Ninacaqui wejt tjonz cheraquic̈ha. Wejrqui tsjir taypiquiz tjonac̈ha walja aztan, niz̈aza Yooz Epiz̈ aziz̈ tjeez̈can. ");
INSERT INTO capNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Niz̈aza wejt anjilanaca cuchanz̈cac̈ha weriz̈ illzta z̈oñinaca juntjapzjapa, trompeta tjawz̈cu. Illztanacaqui tjapa tii muntuquiztanpacha juntaptaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‛Anc̈hucqui higuera munti puntuquiztan zizza, jalla tuz̈. Higuera muntiqui ch'ojñantiz kallantaquiz̈ niiqui, waj kutunz timpuz̈ kallantaquic̈ha. Jalla nii zizza anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jalla niz̈ta irataz̈ tjapa weriz̈ chiita wattan, tii muntuqui waj tucuzinznaquic̈ha. Jalla nuz̈ anc̈hucaquiz zizkatz pecuc̈ha. Jaknuz̈t tsjii z̈oñiqui kjuy zana z̈catz̈inc̈haja, luzjapa, jalla niz̈ta irataz̈ z̈catzinchic̈ha tii muntu tucuzinzqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Anc̈hucaquiz weraral cjiwc̈ha. Ima tii timpuquiz kamñi z̈oñinacaz̈ ticznan, tjapa weriz̈ chiitanaca wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Arajpachami tii yok muntumi liwj tucuzaquic̈ha. Wejt takunacazti wiraz̈ ana tucuzaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‛Pero wejt tjonz tjuñimi, wejt tjonz orami anaz̈ jecmi zizasac̈ha, anaz̈ arajpach Yooz anjilanacami, anaz̈ Yooz Majchmi. Yooz Ejp alajakaz zizza. ");
INSERT INTO capNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‛Jaknuz̈t Noez̈ timpu watc̈haja, jalla nuz̈ wataquic̈ha wejt tjonz tjuñquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noez̈ timpuquiz ima tii muntu kjaztan tuzkatta cjen, z̈oñinacaqui tuz̈ kamñitac̈ha, lujlcan, liccan, zalzcan, zalzjapa majtnaca tjaacan. Jalla nuz̈ kamñitac̈ha Noez̈ warcuquiz luz tjuñicama. ");
INSERT INTO capNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kjaz juyzu tjonzcama z̈oñinacaqui ana c̈hjul tantiyassi z̈ejlchic̈ha. Nekztan kjaz tjontiquiztan tjappacha z̈oñinacaqui kjazquiz kuzta ticzic̈ha. Jalla niz̈ta irataz̈ wataquic̈ha wejt tjonz̈ tjuñquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jalla nii noojiqui pucultan z̈oñiqui pampiquin cjec̈hani. Tsjiiqui arajpach kjutñi waytiz̈cu chjitz̈taz̈ cjequic̈ha. Tsjiiqui ectaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Niz̈azakaz pucultan maatakanacaqui jawuncan z̈elac̈hani. Tsjaaqui arajpach kjutñi waytiz̈cu chjitz̈taz̈ cjequic̈ha. Tsjaaqui ectaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‛Jalla niz̈tiquiztan anc̈hucqui walja naynay z̈elaquic̈ha. C̈hjulorat wejr, am Yooz Jiliri, tjonac̈haja, jalla nii ora ana zizzuca. ");
INSERT INTO capNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Anc̈hucqui tii zizza. Kjuychiz z̈oñiqui tjañi tjonz ora ziztasaz̈ niiqui, walja naynay z̈ejltasac̈ha, niiz̈ kjuya ana tjañiz̈ luzta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Jalla niz̈ta irataz̈ anc̈huqui naynay z̈elaquic̈ha. Tiripintit, ana pinsita orquiz tjonac̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Tsjii kjuychiz z̈oñiqui piyunanacz̈quiz kjuya tjiisic̈ha, cwitisjapa, niz̈aza lujlz ora c̈hjeri tjaazjapa. ¿Jakzilta piyunat zuma cumpliñi, niz̈aza zuma cwitiñiya? Nii tantiya. ");
INSERT INTO capNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Jalla tiz̈taz̈ piyunanacaqui. Kjuychiz z̈oñiz̈ irantiz̈can tsjii piyunaqui cwitican z̈ejlchic̈ha, jaknuz̈t cumpjiitaz̈laja, jalla nuz̈ cumplican z̈ejlchic̈ha. Jalla niic̈ha zuma piyunaqui. Niz̈aza nii piyunaqui cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Anc̈hucaquiz weraral cjiwc̈ha. Nii kjuychiz z̈oñiqui tjapa niiz̈ cusasanaca cumpjiyaquic̈ha nii zuma piyunz̈ kjarquiz. ");
INSERT INTO capNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Nii kjuy cumpjiita piyunaqui ana zuma cjec̈haj niiqui, pinsasac̈ha jalla tuz̈: “Aaaa, wejt patrunaqui ana uri tjonasaka”, cjican cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jalla nekztan parti piyunanacz̈quiz wjajtasac̈ha. Niz̈aza ana zum z̈oñinacz̈tan cumpant'asac̈ha, lujlcanami liccanami. ");
INSERT INTO capNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jalla nuz̈ kaman, nii kjuychiz patrunaqui tiripintitz̈ tjonaquic̈ha, tsjii ana zizta orquiz. ");
INSERT INTO capNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Jalla nekztanaqui nii ana zum piyunaqui zuma castictaz̈ cjequic̈ha. Niz̈aza nii ana zuma piyunaqui chjatkattaz̈ cjequic̈ha. Niz̈aza infiernuquin z̈ejlcan, kaaquic̈ha, niz̈aza iz̈ke kjojaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‛Tii zakal chiyuc̈ha. Arajpach Yooz mantis puntuqui jalla tuz̈uc̈ha. Tunca turtakanacaqui micha tanz̈cu tsjii zalzñi tjowz̈quin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Pjijskaltanaqui ima ojkcan ana zuma tantiichic̈ha. Tsjii pjijskaltanaqui zuma listu tjaczitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nii pjijskaltan ana zuma tantiitazzi turtakanacazti michaka chjitchic̈ha, ana iya parafina chjitchic̈ha, tsjiiz̈tan camzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nii pjijskaltan zuma listu ojkchinacaqui wilta camzjapami parafina chjitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nii zalzñi tjowaqui ana uri tjonchic̈ha. Jalla niz̈tiquiztan tjaji tjonkatchic̈ha tjappacha. Niz̈aza tjajchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jalla nekztanaqui chica arama kjawñi jora nonzic̈ha, tuz̈ cjican: “Cherzna. Zalzñi tjowa tjonz̈ca. Ulanz̈ca niz̈aza risiwz̈ca”. ");
INSERT INTO capNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Tjapa nii turtakanacaqui z̈aazic̈ha, niz̈aza micha teezjapa tjaczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Niiz̈ upaquiztanalla nii pjijskaltan ana zuma tantiyazzi turtakanacaqui tsjii pjijskaltan turtakanacz̈quiz cjichic̈ha, “Parafina tojnalla, wejtnaca parafina upzic̈ha. Niz̈aza wejtnaca micha tjessa”. ");
INSERT INTO capNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero nii walja tantiitazzi turtakanacaqui tuz̈ kjaazic̈ha: “Ana atchuca. Wejtnacaltami anc̈hucaltami anaz̈ wacasac̈ha. Jalla niz̈tiquiztan anc̈hucaz̈ oka, jakziquin parafina tuyc̈haja, jalla nicju. Anc̈hucaltajapa kjayz̈ca”. ");
INSERT INTO capNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nii pjijskaltan turtakanacaz̈ parafina kjayi ojktan, zalzñi tjowaqui irantiz̈quichic̈ha. Nekztan nii tantitazzi turtakanacaqui zalzñi tjowz̈tan kjuyquiz luzzic̈ha, zalz pjijsta paazjapa. Jalla nekztanaqui kjuya chawczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Wiruñaqui nii kjayi ojkchi turtakanacaqui quejpz̈quichic̈ha, tuz̈ cjican: “Wejt Jiliri, Wejt Jiliri, cjetznalla, cjetznalla”. ");
INSERT INTO capNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Pero niiqui kjaazic̈ha, tuz̈ cjican: “Anc̈huc anal pajuc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jalla niz̈tiquiztan Jesusaqui ninacz̈quiz chiiz̈inchic̈ha tuz̈ cjican: —Anchucqui walja zuma listu tjacziz̈ cjequic̈ha. Wejt tjonz tjuñi orami ana zizza. ");
INSERT INTO capNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‛Arajpach Yooz kamañaqui jalla tuz̈uc̈ha. Tsjii z̈oñiqui jiczquin ojkz cjen, niiz̈ piyunanaca kjawzic̈ha. Piyunanacz̈quiz paaz tjiizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","‛Tsjii tsjiiz̈quiz pjijska warank paaznaca tjaachic̈ha. Tsjiiz̈quiz paa warank paaznaca tjaachic̈ha. Tsjiiz̈quizqui tsjii warank paaznaca tjaachic̈ha. Zapa mayniz̈quiz ninacz̈ negocio paaz atñi jama tjaachic̈ha. Jalla nekztanaqui ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nii tsjii pjijska warank paaznaca tanzñi piyunaqui paaztan negocio paachic̈ha. Jalla nuz̈ paaz̈cu tsjii pjijska warank paaznacz̈tan canchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Niz̈azakaz nii tsjii paa warank paaznaca tanzñi piyunaqui paaztan negocio paachic̈ha. Jalla nuz̈ paaz̈cu tsjii paa warank paaznacz̈tan canchizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nii tsjii warankalla paaznaca tanzñi piyunazti patrunz̈ paaz chjojzic̈ha. Yokquiz ojt jwetz̈cu, jalla nekz chjojzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‛Az̈ktan niiz̈ wiruñ nii paaz kajz̈ñi patrunaqui quejpz̈quichic̈ha. Jalla nekztanaqui piyunanacz̈quiztan kaja cobrichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Primiruqui nii tsjii pjijska warank paaznaca tanzñiqui tjonchic̈ha. Jalla niiqui patrunz̈quiz paaznaca intirjichic̈ha, tuz̈ cjican: “Wejt Jiliri, wejtquiz pjijska warank paaznaca tjaachamc̈ha. Nii paaztan trabajz̈cu, iya pjijsk warank paaztan canchinc̈ha. Jalla tiic̈ha amiz̈ tjaatami niz̈aza weriz̈ cantami”. ");
INSERT INTO capNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Patrunaqui niiz̈quiz cjichic̈ha: “Walikazza. Amqui ancha zuma piyunamc̈ha. Zuma trabajchamc̈ha. Zkoluc paaz zuma trabajtiquiztan, jaziqui juc'anti paaznaca amquiz cumpjiyac̈ha”. Niz̈aza cjichic̈ha: “Luzca. Wejttan chica chjipzna. Cuntintum cjee”. ");
INSERT INTO capNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jalla niiz̈ wiruñ nii tsjii paa warank paaznaca tanzñi piyunaqui tjonchic̈ha, tuz̈ cjican: “Wejt Jiliri. Wejtquiz paa warank paaznaca tjaachamc̈ha. Iya tsjii paa warank paaztan canchinc̈ha. Jalla tiic̈ha amiz̈ tjaatami niz̈aza weriz̈ cantami”. ");
INSERT INTO capNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Niiz̈ patrunaqui niiz̈quin cjichic̈ha: “Walikazza. Amqui ancha zuma piyunamc̈ha. Zuma trabajchamc̈ha. Zkoluc paaz zuma trabajtiquiztan, jaziqui juc'anti paaznaca amquiz cumpjiyac̈ha”. Niz̈aza cjichic̈ha: “Luzca. Wejttan chica chjipzna. Cuntintum cjee”. ");
INSERT INTO capNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero nekztan nii tsjii warank paaznaca tanzñi piyunaqui tjonchic̈ha. Niiqui patrunz̈quiz cjichic̈ha: “Wejt Jiliri. Amqui c'ar patrunamc̈ha. Jalla nii zizzatuc̈ha. Amqui ana c̈hjulumi paaz̈cumi canñamc̈ha. Niz̈aza ana c̈hjacz̈cumi, ajzñamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Jalla niz̈tiquiztan ekzinc̈ha, niz̈aza ojkz̈cu am paaznaca yokquiz chjojchinc̈ha. Pero tekziz̈ am paazqui”. ");
INSERT INTO capNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Patrunaqui nii piyunz̈quiz tuz̈ kjaazic̈ha: “Ana zum piyuna. Jayri piyuna. Wejrqui ana c̈hjacz̈cu ajzñinpanc̈ha, niz̈aza ana c̈hjulumi paaz̈cu caniñpanc̈ha. Jalla niz̈tapanim zizla amqui. ");
INSERT INTO capNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Jalla niz̈tiquiztan wejt paaz bancuquiz mekaz uchanchucataz̈, jalla. Jalla nuz̈ paatasaz̈ niiqui, wejrqui quejpz̈cu bancuquiztan paaz majchtanpacha ricujtasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jalla nekztanaqui nii patrunaqui nekzi z̈ejlñi z̈oñinacz̈quiz cjichic̈ha: “Tii piyunz̈quiztan nii warank paaznaca kjaña. Nii tunca warank paaznacchiz piyunz̈quiz tjaa. ");
INSERT INTO capNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jakziltat z̈elinchiz̈laja, jalla niiz̈quiz iya tjaataz̈ cjequic̈ha, jilacama. Niz̈aza jakziltat zkoluc z̈elinchiz̈laja, niz̈aza ana zuma trabajchiz̈laja, jalla niiz̈quiztan tjappacha kjañtaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tii ana zum piyuna chjatkata, zawncta zumchiquin. Jalla nicju kaaquic̈ha, niz̈aza iz̈ke kjojaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‛Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tsjii noojiqui wejrqui wilta tjonac̈ha, wejt azi tjeez̈can. Rey cjita Jiliri cjeec̈ha. Tjapa wejt anjilanacz̈tanpacha tjonac̈ha. Poderchiz tjonac̈ha z̈oñinaca pjalzjapa. Tsjan chekan juez Jiliritc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wejt yujcquin tjapa tii muntuquiz kamñi z̈oñinaca juntjaptaz̈ cjequic̈ha. Jalla nekztanaqui wejrqui ninaca pjalznac̈ha, jaknuz̈t tsjii awatiriqui uuza yekja niz̈aza cabra yekja pjalznac̈haja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Pjalz̈cu uuzanacaqui z̈ew latuquiz cjequic̈ha, cabranacazti zkar latuquiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wejrtc̈ha chekan juez jiliritqui. Nekztanaqui wejt z̈ew latu pjalz̈tanacz̈quiz tuz̈ cjeec̈ha: “Wejt Epiz̈ k'aachita z̈oñinaca, pichalla anc̈hucalta tjaczta kamaña tanzjapa. Tii muntu paata ora, niwjctanpacha anc̈hucalta nii kamaña tjacztac̈ha, Yooztan kamzjapa, nii kjuychiz familia cjisjapa”. ");
INSERT INTO capNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Niz̈aza cjeec̈ha, “Anc̈hucqui zumanaca paachinc̈hucc̈ha. Weriz̈ c̈hjeri eecsiz̈ cjen, anc̈hucqui wejtquiz c̈hjeri tjaachinc̈hucc̈ha. Niz̈aza weriz̈ kjaz pecan, anc̈hucqui wejtquiz kjaz onanchinc̈hucc̈ha. Niz̈aza yekja yokquin ojklayan, anc̈hucqui wejtquiz tjajz kjuyquiz kjawzinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Weriz̈ ana zquitchiz cjen anc̈hucqui zquiti onanchinc̈hucc̈ha. Niz̈aza laaquichi cjen, wejtquin tjonzinc̈hucc̈ha. Niz̈aza carsilquiz chajwcta cjen, anc̈hucqui wejtquin cherzñi tjonchinc̈hucc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jalla nekztanaqui zuma kamañchiz z̈oñinacqui wejtquin cjequic̈ha: “Wejt Jiliri, ¿c̈hjulora am c̈hjeri eecsi cherchintaya? Niz̈aza c̈hjeri lujlzjapa, ¿c̈hjulora onanchintaya? ¿C̈hjulora am kjaz pecan, onanchintaya? ");
INSERT INTO capNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿C̈hjulora am yekja yokquin ojklayan tjajz kjuyquiz kjawzintaya? ¿C̈hjulora am ana zquitchiz cjen, zquiti onanchintaya? ");
INSERT INTO capNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Niz̈aza ¿c̈hjulora am laaquichi cjen, tjonzintaya? ¿C̈hjulora am carsilquiz cjen, amquin tjonzintaya?” ");
INSERT INTO capNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jalla nekztanaqui zuma kamañchiz z̈oñinacz̈quiz kjaaznac̈ha, tuz̈ cjican: “Anchucaquiz weraral cjiwc̈ha. Wejrtc̈ha chekan juez Jiliritqui. C̈hjulora wejt jilanacz̈quiz yanapc̈haja, humilde jilanacaz̈ cjenami, jalla niiqui wejtquiztakaz yanapchinc̈hucc̈ha”. Nuz̈ chiyac̈ha pjalz tjuñquiz. ");
INSERT INTO capNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jalla nekztanaqui wejrqui, chawc juez Jiliri cjican, nii zkar latu pjalz̈tanacz̈quiz cjeec̈ha: “Anc̈hucqui, Yoozqui anc̈huca quintrac̈ha. Jaziqui wejtquiztanz̈ infiernuquin oka. Diabluz̈tami niiz̈ anjilanacz̈tami tjacztac̈ha nii infiernuqui. Anc̈hucqui zakaz nii infiernuquin wiñaya sufraquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Weriz̈ c̈hjeriz̈ eecsiz̈ cjen, anc̈hucqui ana wejtquiz c̈hjeri onanchinc̈hucc̈ha. Weriz̈ kjaz pecan, anc̈hucqui ana wejtquiz kjaz onanchinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Weriz̈ yekja yokquin ojklayan, ana tjajz kjuyquiz kjawzinc̈hucc̈ha. Weriz̈ ana zquitchiz cjen, ana zquiti onanchinc̈hucc̈ha. Weriz̈ laa cjen, niz̈aza carsilquiz cjen, anc̈hucqui ana wejr cherzñi tjonzinc̈hucc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jalla nekztanaqui ninacaqui cjequic̈ha: “Wejt Jiliri, ¿c̈hjulora am c̈hjeri eecsi cjen, kjaz pecchi cjenami, yekja yokquin ojklaychi cjen, ana zquitchiz cjen, laa cjen, carsilquiz chawcta cjen, jalla c̈hjulora am niz̈ta cherchintaya? Niz̈ta chertuc̈haja, yanaptasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jalla nektanaqui wejrqui, chawc juez Jiliri cjican, ninacz̈quiz kjaaznac̈ha, tuz̈ cjican: “Anchucaquiz weraral cjiwc̈ha. C̈hjulora wejt jilanacz̈quiz humilde cjenami ana yanapchiz̈laja, wejtquiztakaz ana yanapchinc̈hucc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jalla nekztanaqui nii ana zuma kamañchiz z̈oñinacaqui infiernuquin cuchantaz̈ cjequic̈ha, wiñaya casticta cjisjapa. Nii zuma kamañchiz z̈oñinacazti Yooztan chica wiñaya kamzjapa okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tjappacha nii chiitanaca z̈erz̈cu, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Anc̈hucqui zizza, puc majc̈ha pascua pjijstaqui. Jalla nii pjijsta ora wejrqui intirjital cjeec̈ha cruzquiz ch'awcta cjisjapa. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jalla nii oraqui timplu jilirinacami, liy tjaajiñi maestrunacami judío wajtchiz jilirinacami ajczic̈ha, Caifás jilirz̈ kjuy patiuquiz. Caifás cjitaqui timplu jilirinacz̈quiztan chawc jiliritac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jalla nicju ninacaqui palt'ichic̈ha, niz̈aza kazzic̈ha mañz̈tan Jesusa tanzjapa. Jalla nuz̈ tanz̈cu, Jesusa conzjapa kazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Nuz̈ kazcu tuz̈ cjichic̈ha: —Pjijsta paan Jesusa tanz anaz̈ cjichuca. Z̈oñinacaqui aptjapznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesusaqui Betania wajtquiz z̈elatc̈ha, Simonz̈ kjuyquiz. Niiz̈ tuquiqui Simonaqui janchi mojkchi laatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Jalla nekz z̈elan, tsjaa maatak z̈onqui Jesusiz̈quiz macjatz̈quichinc̈ha. Naaqui tsjii putilla chjitchinc̈ha. Nii putillquiz cuza mazk'a ulurchiz asiiti z̈elatc̈ha, ancha jila walurchiz. Nii putilltac̈ha zuma alabastro cjita maztan paataqui. Jesusa mizquiz z̈elan naa maatak z̈onqui niiz̈ achquiz zuma asiiti alz̈inchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Niiz̈ tjaajintanacaqui nii cherz̈cu, z̈awjzic̈ha, naa z̈oña quintra. Jalla nekztan tuz̈ cjichic̈ha: —¿Kjaz̈tiquiztan tii walurchiz asiiti pertejo? ");
INSERT INTO capNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Jalla tiiqui antis tuychucatac̈ha walja jiluñ, niz̈aza pori z̈oñinacz̈quiz yanapzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesusaqui nii chiiñi nonz̈cu tjaajintanacz̈quiz ujzic̈ha: —¿Kjaz̈tiquiztan taa z̈onatan chjijcjisejo? Anac̈ha taa z̈on kjaz̈ cjisqui. Jalla tuz̈ taa z̈oñaz̈ paataqui wejtquiztan walikazza. ");
INSERT INTO capNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porinacz̈quiz yanapz pecaquiz̈ niiqui, porinacaqui anc̈hucatan panz̈ z̈elaquic̈ha. Wejrzti anc̈hucatan ana z̈ejlztanpanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Jalla taa maatak z̈oñqui wejtquiz tii zuma ulurchiz asiiti alz̈inz̈cu, wejt curpu tjaczinc̈ha, tjatta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Anc̈hucaquiz weraral cjiwc̈ha. Jakziquinami tii muntuquiziqui liwriiñi Yooz taku parlita cjec̈haja, jalla niz̈tazakaz taa maatak z̈onaz̈ paataqui parlita zakaz cjequic̈ha, jalla naaquiztan cjuñta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Tuncapan illzta z̈oñinacz̈quiztan tsjiiqui Judas Iscariote cjitatac̈ha. Jalla niiqui ojkchic̈ha timplu jilirinacz̈tan parli. ");
INSERT INTO capNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jalla nuz̈ parlican cjichic̈ha: —Anc̈hucaquiz Jesusal intirjasaz̈ niiqui, anc̈hucqui ¿kjaz̈ paaz pacas? Jalla nii orapacha quinsa tunc paaznaca Judasquiz pacchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jalla nuz̈quiz Judasqui c̈hjulorat Jesusa tankatchuca cjec̈haja, jalla nii ora walja kjurchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jalla nekztanaqui ana liwaturz̈tan t'anta lujlz pjijzta, jalla nii pjijztaz̈ primir tjuñquiz tjaajinta z̈oñinacaqui Jesusiz̈quin macjatz̈cu tuz̈ pewczic̈ha: —¿Jakziquin wejrnacqui tjaczñi ojkz pecya, pascu c̈hjeri lujlzjapaya? ");
INSERT INTO capNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesusaqui tuz̈ kjaazic̈ha: —Watja oka. Tsjii z̈oñz̈tan zalaquic̈ha. Niiz̈quiz̈ cjee, “Maestruqui z̈-cjic̈ha. ‘Wejt ticz ora wajillac̈ha. Am kjuyquiz pascua pjijztal paac̈ha wejt tjaajinta z̈oñinacz̈tan’ ”. ");
INSERT INTO capNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nekztanaqui Jesusaz̈ mantitacama ojkchic̈ha. Nii tokinzt'ita kjuyquiz pascu c̈hjeri tjaczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Weenjapa cjistan Jesusaqui nii kjuyquiz z̈ejlcan mizquiz julzic̈ha niiz̈ tuncapan tjaajinta z̈oñinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jalla nuz̈ c̈hjeri lujlcan, ninacz̈quiz cjichic̈ha: —Anc̈hucaquiz weraral cjiwc̈ha. Tsjii tsjii anc̈hucqui wejt quintra paaquic̈ha, niz̈aza tarazunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jalla nuz̈ chiitiquiztan tjaajinta z̈oñinacaqui walja llaquita cjissic̈ha. Jalla nekztan ninacaqui tsjiiza tsjiiza pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿wejr cjesajo? ");
INSERT INTO capNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Nekztanaqui Jesusaqui tuz̈ kjaazic̈ha: —Anziqui wejttan chicaz̈ tii chuwquiztan lujlc̈ha nii tarazunñi z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jaknuz̈t cjijrta Yooz takuqui cjic̈haja, jalla niicama okac̈ha. Nii tarazunñi z̈oñiqui anaj maa pjuchquiztan nastc̈haja, waliz̈ cjitasac̈ha niiz̈taqui. Wejr tarazuntiquiztan wali chawc ujchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jalla nekztanaqui Judasqui, nii tarazunñi z̈oñiqui, tuz̈ cjichic̈ha: —Maestro, ¿wejr cjesajo? Jesusaqui tuz̈ kjaazic̈ha: —Jesalla, amchiya. ");
INSERT INTO capNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jalla nuz̈ pascua c̈hjeri lujlcan Jesusaqui niiz̈ persun kjarz̈tan t'anta tanzic̈ha. Nekztan Yooz Ejpz̈quin gracias cjican tjaaz̈cu, t'anta kjolzic̈ha. Jalla nuz̈ kjolz̈cu, niiz̈ tjaajinta z̈oñinacz̈quiz tjaachic̈ha, tuz̈ cjican: —Lujlzna. Jalla tiic̈ha wejt curpu cuntaqui. ");
INSERT INTO capNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jalla nekztan persun kjarz̈tan tsjii wazu tanzic̈ha. Yooz Epz̈quin gracias cjican tjaachizakazza. Nekztan tjaajinta z̈oñinacz̈quin c̈hjalz̈cu zapa mayni licchic̈ha. Jalla nuz̈ c̈hjalz̈cu, tuz̈ cjichic̈ha: —Tii wazquiztan tjapa anc̈hucqui liczna. ");
INSERT INTO capNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Wejt ljocquiztanz̈ cjic̈ha tiiqui. Wejt ljocz̈tan tsjii ew acta tjulz̈taz̈ cjequic̈ha. Wacchi z̈oñinacz̈ laycu wejt ljocqui tjawktaz̈ cjequic̈ha ninacz̈ uj pertunta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wejr cjiwc̈ha. Uwas kjaz ana iya licac̈ha, c̈hjulorcama wejt Yooz Ejp tjapa mantac̈haja, jalla nekztan anc̈hucatan wilta uwas kjaz licac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nekztan Yooz wirzu itzcu, Olivos cjita curulla ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz tuz̈ cjichic̈ha: —Jalla tii weenqui tantal cjeec̈ha. Nekztan tjapa anc̈hucqui ana wejtquin kuzziz tucaquic̈ha. Jalla nuzpan cjijrta Yooz takuqui cjic̈ha: “Uuza awatiri contanaqui uuzanacaqui wichanznaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wejr jacatatz̈cuqui anc̈huca tuqui okayac̈ha Galilea cjita yoka. ");
INSERT INTO capNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nekztanaqui Pedruqui cjichic̈ha: —Tjappacha ana amquin kuzziz tucac̈hani. Wejrzti ana wira niz̈ta cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jalla nuz̈ chiitiquiztan Jesusaqui tuz̈ kjaazic̈ha: —Amquiz weraral cjiwc̈ha. Jalla tii weenpacha c̈hjep wilta amqui ana wejr pajñi chiican k'otaquic̈ha, ima wallpaz̈ kjawan. ");
INSERT INTO capNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Nekztan Pedruqui Jesusiz̈quiz kjaazic̈ha, tuz̈ cjican: —Wejrqui amtan chicami waztal ticznasac̈ha. Anapan amquiztan k'otasac̈ha. Niz̈aza tjapa nii tjaajintanacaqui tsjiika chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jalla nekztan Jesusaqui niiz̈ tjaajintanacz̈tan Getsemaní cjita yoka irantichic̈ha. Jalla niwjc irantiz̈cu, ninacz̈quiz cjichic̈ha: —Tekz julzna anc̈hucqui. Wejrqui nii nawcju Yooz Ejpz̈tan parli okac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jalla nekztan Pedruz̈tan niz̈aza Zebedeoz̈ pucultan majchnacz̈tan chjitchic̈ha. Nekztanaqui Jesusaqui kuzquiz walja llaquisatc̈ha, niz̈aza anchaz̈ llactazatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jalla niz̈tiquiztan Jesusaqui nii c̈hjepultan chjichta tjaajintanacz̈quiziqui cjichic̈ha: —Wejt kuzqui ancha llaquissa, ticzmayac̈ha. Anc̈hucqui tekzi z̈ela. Wilaquic̈ha, anac̈ha tjajaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jalla nekztanaqui Jesusaqui tsjii koluc nawjcchuc ojkchic̈ha. Yokquizkaz tuzi t'okz̈cu Yoozquin mayizichic̈ha, tuz̈ cjican: —Wejt Yooz Ejp. Tii juc'ant sufris timpu anal watz pecuc̈ha. Tii sufrisquiztan liwriichucaz̈laj niiqui, amqui wejr liwriyalla. Pero anal wejt kuzcama cjis pecuc̈ha. Antiz jaknuz̈t am kuz amtic̈haja, am munañpakaj cjila. ");
INSERT INTO capNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jalla nekztanaqui tjaajintanacz̈quin quejpz̈quichic̈ha. Tjajchi zalchic̈ha. Jaziqui Jesusaqui Pedruz̈quiz cjichic̈ha: —¿Anc̈hucqui anapanz wejttan tsjii orami wilasi atya? ");
INSERT INTO capNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tjaji watzi z̈ela, niz̈aza wilazaquic̈ha. Yoozquin mayizaquic̈ha, ana ujquiz tjojtsjapa. Chekapan, anc̈huca kuzqui wilasac̈ha. Pero anc̈huca curpuzti anaz̈ awantasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nekztan Jesusaqui wilta Yooztan parli ojkchic̈ha. Tuz̈ cjican, mayizichic̈ha: —Wejt Yooz Ejp, tii sufrisquiztan ana liwriita cjichucaz̈laj niiqui, am kuz munañpaj cjila. ");
INSERT INTO capNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nekztan wilta tjaajintanacz̈quin quejpz̈cu tjajchi zalchic̈ha. Ancha tjaji tjonatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","C̈hjepquiziqui wilta ninacz̈quiztan ojkchic̈ha, Yooz Ejpz̈quin parli. Primiru jaknuz̈t parlic̈haja, jalla nuz̈ zakaz parlichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jalla nekztanaqui tjaajintanacz̈quin quejpchic̈ha. Ninacz̈quin paljaychic̈ha, tuz̈ cjican: —Jaziqui tjajchinc̈hucc̈ha anc̈hucqui, niz̈aza jeejzinc̈hucc̈ha. Nuz̈ukazza. Wejrqui ujchiz z̈oñinacz̈ kjarquiz intirjital cjeec̈ha. Anz nii ora irjatz̈quic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Z̈aazna. Ojkla. Wejr tankatñi z̈oñiqui nii najwcz̈ tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesusa nuz̈ chiyan, Judasqui irantiz̈quichic̈ha. Niitac̈ha Jesusiz̈ tuncapan illzta z̈oñinacz̈quiztanqui. Judastan tama z̈oñinacaqui tjonchic̈ha pajk cuchillunacchiz, niz̈aza wjajtz carotinacchiz. Timplu jilirinacami wajt jilirinacami ninaca cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tarazunñi Judasqui niiz̈ tuquilla nii z̈oñinacz̈tan kazzitac̈ha, tuz̈ cjican: —Wejrqui nii z̈oñz̈quiz chjulznac̈ha. Jalla niiz̈ cjequic̈ha nii z̈oñiqui. Jalla nekztan zuma tanz̈cu chjichaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jalla nuz̈ kazcu Judasqui Jesusiz̈quiz macjatchic̈ha, tuz̈ cjican: —Tjaajiñi Maestru, ¿walikazkay? Jalla nuz̈ tsaanz̈cu, chjulzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Jila, ¿c̈hjulquin am tjonjo? Jalla nekztanaqui z̈oñinacaqui z̈catz̈inz̈quichic̈ha, niz̈aza preso chjichi tanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jalla nuz̈ paan, tsjii tsjii Jesusiz̈ tjaajinta z̈oñiqui pajk cuchillu jooz̈cu, quintri z̈oñz̈ cjuñi c̈hjajtz̈inchic̈ha. Nii cjuñi chjajtz̈inta z̈oñiqui timplu jilirz̈ piyunatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jalla nekztan Jesusaqui tuz̈ cjichic̈ha: —Am pajk cuchillu c̈hjojzna, nii cuchill c̈hjojzquiz. Jakziltat pajk cuchillu joojooc̈haja, jalla ninacaqui pajk cuchillz̈tan conta zakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Wejt Yooz Ejpz̈quiztan mayasac̈ha, wejtquiz yanapzjapa. Jalla nuz̈ maytiquiztan wejt Yooz Ejpqui anzpachaz̈ wacchi anjilanaca cuchanz̈casac̈ha, tuncapan walja tama ejércitonacacama. ¿Nii ana zizya? ");
INSERT INTO capNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero jalla niz̈ta anal mayac̈ha. Jalla tiz̈ta watstanc̈ha, jaknuz̈t cjijrta Yooz taku chiic̈haja, jalla nii cumplistanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jalla nekztanaqui Jesusaqui nii tjonchi z̈oñinacz̈quiz cjichic̈ha: —Anc̈hucqui pajk cuchillunacz̈tan wjajtz carotinacz̈tan wejr tani tjonchinc̈hucc̈ha, wejr tjañi cjes, niz̈taz̈takaz. ¿Kjaz̈tiquiztan niz̈ta tjonchinc̈huctajo? Zapurupan anc̈hucatan z̈ejlchinc̈ha, timpluquiz tjaajincan. Jalla nii oranacaqui anaz̈ wejr tanchinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Tjapa tii watñinacaqui jaknuz̈t tuquita profetanacaz̈ cjijrtc̈haja, jalla niit jama cumplistanc̈ha. Jalla nekztanaqui tjapa Jesusiz̈ tjaajinta z̈oñinacaqui tsucaña wichanzic̈ha. Jesusa zinalla ecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jalla nii Jesusa tanñi z̈oñinacaqui Caifás cjita jilirz̈quin chjitchic̈ha. Caifasqui timplu jilirinacz̈ chawc jiliritac̈ha. Caifás kjuyquin liy tjaajiñi maestrunacami wajt jilirinacami ajczitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedruqui nii chawc jilirz̈ kjuy patiucama apzic̈ha az̈quiztanalla. Nii patiuquin luzcu, julzi z̈elatc̈ha wijilñi policianacz̈tan. Jaknuz̈t Jesusa watc̈haja, jalla nii cherzjapa z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Timplu jilirinacami, wajt jilirinacami, tjapa mantiñi jilirinacami Jesusiz̈ quintra uj jwes pecatc̈ha, toscaraz̈ cjenaqui, conkatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Wacchi z̈oñinacami toscar tawkz̈tan prisintiz̈quichic̈ha Jesusiz̈ quintra uj tjojtunzjapa. Pero ana c̈hjul uj jwesi atchic̈ha. Ultimquiziqui pucultan toscar tisticunacaqui apantiz̈quichic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tuz̈ cjican: —Tii z̈oñiqui cjiñic̈ha, “Yooz timplu t'ezinz̈u, c̈hjep majquiz wiltal tsijtsnasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jalla nekztanaqui timplu chawc jiliriqui tsijtsic̈ha. Jesusiz̈quiz cjichic̈ha: ¿Kjaz̈tiquiztan am ana kjaazjo? ¿Kjaz̈ cjican tii z̈oñinacaqui am quintra chiijo? ");
INSERT INTO capNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jalla nuz̈ chiiz̈inanami Jesusaqui ch'uju z̈ejlchic̈ha. Jalla nekztanaqui nii timplu chawc jiliriqui niiz̈quiz cjichizakazza: —Z̈ejtñi Yooz tjuuquiz am juramintu paakatac̈ha, werara chiizjapa. Mazna. ¿Amqui Cristumkaya? ¿Niz̈aza Yooz Majchpanikaya? ");
INSERT INTO capNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Wejrc̈hay. Amqui jaknuz̈um chiic̈haja, jalla nuz̈uc̈ha. Wejr zakal anc̈hucaquiz cjeec̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tsjii noojiqui anc̈hucqui wejr cheraquic̈ha, juc'anti azziz Yooz z̈ew latuquiz julzi. Niz̈aza arajpachquiztan tsjir taypiquiz wilta tjonac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jalla nuz̈ kjaaztiquiztan timplu chawc jiliriqui niiz̈ persun zquiti wjajrz̈inchic̈ha, z̈awjchi kjanapacha tjeezjapa. Niz̈aza cjichic̈ha: —Tii z̈oñiqui persun tawkz̈tan Yooz quintra chiichic̈ha. ¿Kjaz̈t iya tisticunaca pecznasajo? Anc̈hucpacha tiiz̈ ana wal takunaca nonzinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Kjaz̈tat cjees? Ninacaqui kjaazic̈ha, tuz̈ cjican: —Tiiqui ujchizpanc̈ha. Paj ticzla. ");
INSERT INTO capNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jalla nekztanaqui Jesusiz̈ yujcquiz llawziz̈tan tjujti kallantichic̈ha, niz̈aza wjajtchic̈ha. Partinacaqui yujcquiz c̈hajczic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tuz̈ cjican: —Amqui Cristumz̈laj niiqui, jazic ¿jequit am c̈hajczjo? Jalla nii pajalla. ");
INSERT INTO capNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nii ora Pedruqui zancu kjuy patiuquin julzi z̈elatc̈ha. Nekz z̈elan tsjaa piyuniqui niiz̈quiz macjatz̈cu paljaychinc̈ha, tuz̈ cjican: —Amqui ojklayñamla nii Galilea yokchiz Jesusiz̈tan, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pedruqui parti z̈oñinacz̈ yujcquiz k'otchic̈ha, tuz̈ cjican: —C̈hjulquiztankam chiic̈hani, anal intintazuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nekztanaqui Pedruqui zan kjutñi z̈catz̈inchic̈ha. Nekztan tsjaa piyuniqui nii cherz̈cu parti z̈oñinacz̈quiz cjichinc̈ha: —Tii z̈oñipan ojklayatla tii Nazaret wajtchiz Jesusiz̈tan chica. ");
INSERT INTO capNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pedruqui wilta k'otchic̈ha. Juramintuz̈tan tuz̈ cjichic̈ha: —Nii z̈oñi anapan pajuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jalla niiz̈ upaquiztan nekz z̈ejlñi z̈oñinacaqui Pedruz̈quiz macjatz̈cu, cjichizakazza: —Chekapan, amqui zakaz Jesusiz̈ parti z̈oñinacz̈tan chica ojklayñamla. Am takuqui kjanapachala, ninacaz̈ takukam chiila. ");
INSERT INTO capNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nekztanaqui Pedruqui wilta k'otchic̈ha, juramintu paacan. —Anapal nii z̈oñi pajuc̈ha. Toscara chiichinz̈laj niiqui, Yooz wejr casticac̈hani. —Nuz̈ cjichic̈ha Pedruqui. Jalla nii orapacha tsjii wallpi jora kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jalla nii wallpa kjawñi nonz̈cu, Pedruqui Jesusiz̈ chiita taku cjuñzic̈ha. Niiz̈ tuquiqui Jesusaqui cjichic̈ha: “Ima wallpaz̈ kjawan, c̈hejp wilta amqui ana wejr pajñi chiican k'otaquic̈ha”. Jalla nuz̈ cjuñz̈cu Pedruqui nekztan ulanchic̈ha. Niz̈aza walja kuzquiz sint'ican kaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kjanz̈quitan tjapa timplu jilirinacami, wajtchiz jilirinacami tsjii acuerduquiz luzzic̈ha Jesusa conkatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jalla nekztan Jesusa chejlz̈cu chjitchic̈ha Poncio Pilato cjita chawc jilirz̈quin. Nii oraqui naciona mantiñi gobernutac̈ha Pilatuqui. ");
INSERT INTO capNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jesusa tarazunñi Judasqui Jesusa conata cherz̈cu, kuzquiz walja sint'ichic̈ha. Jalla nuz̈ sint'iz̈cu nii quinsa tunc tjaata paaz tjepunchic̈ha timplu jilirinacz̈quizimi wajtchiz jilirinacz̈quizimi. ");
INSERT INTO capNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Paaz tjepunz̈cu, tuz̈ cjichic̈ha: —Wejr uj paachinc̈ha. Ana c̈hjul ujchiz z̈oñi tarazunchinc̈ha. Ninacazti niiz̈quiz tuz̈ kjaazic̈ha: —Jalla niiqui, ¿c̈hjul importejo wejtnacaquiztanajo? Niiqui amtakazza. ");
INSERT INTO capNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jalla nekztanaqui Judasqui timpluquinpacha nii paaz tjojtunchic̈ha. Nekztan ojkchic̈ha. Persunpacha jora mokz̈cu, tsjijpscu ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Nekztanaqui timplu jilirinacaqui paaz ricujz̈cu, tuz̈ cjichic̈ha: —Tii paazqui anaz̈ uc̈humqui ofrend cajquiz uchasac̈ha. Tiic̈ha z̈oñz̈ ljok kjayta paazqui. ");
INSERT INTO capNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nekztanaqui ninacaqui kazzic̈ha nii paaztan yoka kjayzjapa. Nii yokaqui Campo del Alfarero niz̈ta cjita tjuuchiztac̈ha. Yekja wajtchiz ticzi z̈oñinaca tjatzjapatac̈ha nii yokaqui. ");
INSERT INTO capNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nuz̈quiz tii timpucama nii yokz̈ tsjii tjuuqui Campo de Sangre cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jalla nuz̈ Jeremías profetz̈ takuqui cumplissic̈ha. Tuqui timpu Jeremiasqui cjijrchic̈ha, tuz̈ cjican: “Israel z̈oñinacaqui nii z̈oñi tankatz precio utchic̈ha, quinsa tunc paaznaca, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nii quinsa tunc paaznacz̈tan Campo del Alfarero cjita yoka kjayaquic̈ha, jaknuz̈t Yooz Jiliriz̈ mantic̈haja, jalla nuz̈”. ");
INSERT INTO capNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nekztanaqui Jesusaqui naciona mantiñi chawc jilirz̈quin chjichtatac̈ha. Nii mantiñi jiliriqui Jesusiz̈quiz tuz̈ pewczic̈ha: —¿Amqui judionacz̈ chawc jilirimkaya? Jesusaqui tuz̈ kjaazic̈ha: —Am jaknuz̈um chiic̈haja, nuz̈uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Timplu jilirinacami wajtchiz jilirinacami, jalla ninacaz̈ uj tjojtuntan, Jesusaqui anaz̈ c̈hjulumi kjaazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jalla nekztanaqui Pilato jiliriqui tuz̈ cjichic̈ha: —¿Anam am kjaaznaquiya tjapa tii am quintra chiyanaqui? ");
INSERT INTO capNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesusazti jalla nuz̈ chiyanami ana c̈hjulumi kjaazic̈ha. Jalla niz̈tiquiztan nii mantiñi chawc jiliriqui ispantichic̈ha. Ana c̈hjul pinsimi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jalla nii pascu pjijztiquiz Pilato chawc jiliriqui tsjii cuzturumpichiztac̈ha. Tsjii priz z̈oñiqui cutzpanikaztac̈ha z̈oñinacaz̈ chiitacama. ");
INSERT INTO capNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tsjii ana wal z̈oñiqui Barrabás cjita prisu zakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Z̈oñinaca ajcziz̈ cjen Pilatuqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Jakzilta tii tanta z̈oñinacat liwrii cutz̈ta cjeequi? ¿Barrabás cjeequi? uz̈ ¿Jesús, Cristo cjita cjeeja? ");
INSERT INTO capNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato jiliriqui zizzic̈ha, Jesusa chjaawjcu judío z̈oñinacaqui nii intirjichic̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatuqui niiz̈ jusjiis mizquiz julzi z̈elatc̈ha. Jalla nicju z̈elan niiz̈ tjunqui tsjii z̈oñi mazñi cuchanz̈quichinc̈ha. Nii mazñi z̈oñiqui tuz̈ chiichic̈ha: “Am tjun cjic̈ha: ‛Nii zuma z̈oñz̈quiz ana mitisaquic̈ha. Nii z̈oñiz̈ cjen tiz̈wan juc'ant ana wali c̈hjuuzinc̈ha. Nii z̈oñz̈quiz ana mitis waquizic̈ha'”. ");
INSERT INTO capNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero timplu jilirinacami wajtchiz jilirinacami, nii z̈ejlñi z̈oñinacz̈quiz intintiskatchic̈ha, Barrabás cutzna cjeyajo, niz̈aza Jesusa contaj cjila cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jalla nekztanaqui nii mantiñi jiliriqui wilta z̈oñinacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Jakzilta pirit tii pucultan tantanacquiztan liwrii cutznaqui? Z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —Barrabás cutzna. ");
INSERT INTO capNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato jiliriqui wilta ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Tii Cristo cjita Jesusiz̈quiz, ¿c̈hjulut wejr paa-aqui? Tjappacha nii z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —¡Cruzquiz ch'awczna! ");
INSERT INTO capNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Nekztanaqui Pilato jiliriqui cjichic̈ha: —¿C̈hjul uj paachi teejo? Nii z̈oñinacazti juc'anti kjawchic̈ha: —¡Cruzquizka ch'awczna! —cjican. ");
INSERT INTO capNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jalla nekztanaqui Pilato jiliriqui naychic̈ha, nii z̈oñinaca ana intintiskatchuca. Nii z̈oñinacaqui walja z̈awjchiz̈ ch'ajrapatc̈ha. Jalla nekztanaqui Pilato jiliriqui kjaz zjijckatchic̈ha. Nii zjijcta kjazquiz kjara awjzic̈ha z̈oñinacz̈ yujcquiz, tuz̈ cjican: —Tii zuma z̈oñz̈ ticzqui anaz̈ wejt uj cjequic̈ha. Anc̈huca ujz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tjapa nii z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —Wejtnacaltazat uj cjec̈hani, niz̈aza wejtnaca ocjalanacz̈tami. ");
INSERT INTO capNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jalla nekztanaqui Pilato jiliriqui Barrabás liwrii cutzic̈ha. Nekztanaqui Jesusa wjajtzjapa mantichic̈ha. Niz̈aza cruzquiz ch'awcta cjeyajo, zultatunacz̈quiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jalla nekztanaqui nii mantita zultatunacaqui jilirz̈ palacio kjuyquin Jesusa chjitchic̈ha. Nekztanaqui tjapa nii zultatz̈ tropanaca kjawsassic̈ha, Jesusa muytata. ");
INSERT INTO capNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Nekztanaqui Jesusa c̈hjojkchic̈ha. Jalla nuz̈ c̈hjojkz̈cu tsjii ljoc murat zquiti tjutzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Nekztan niiz̈ achquiz ch'ap pilluz̈takaz paaz̈cu scarz̈inchic̈ha, niz̈aza z̈ew kjarquiz wara tanskatchic̈ha. Jalla nuz̈ paaz̈cu niiz̈ yujcquiz quillzic̈ha, tuz̈ cjican: —¡Viva tii judío z̈oñinacz̈ chawc jiliri! —Jalla nuz̈ chiican burla paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niz̈aza llawziz̈tan niiz̈quiz tjujtchic̈ha. Niiz̈ kjarquiztan wara kjañcan, achquiz wjajtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jalla nuz̈ burla paaz̈cu, niiz̈quiztan ljoc murat zquiti c̈hjojkchic̈ha. Nekztan wilta niiz̈ persun zquiti tjutzic̈ha. Jalla nekztanaqui cruzquiz ch'awczjapa Jesusa chjitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jalla nuz̈ Jesusa chjichcan tsjii Cirene wajtchiz z̈oñi zalz̈quichic̈ha. Simón cjitatac̈ha. Jalla nii z̈oñiqui Jesusiz̈ cruza kuzkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Jalla nuz̈ Gólgota cjita yokquin irantichic̈ha. Nii yokaqui “Ach Tsjij yoka” cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Jalla nicju tsjii vinz̈tan jarz̈tan t'ajz̈ta lickatchic̈ha. Pero nii mallz̈cu, ana licz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Cruzquiz ch'awcz̈cu, zultatunacaqui Jesusiz̈ zquiti tanzjapa surtiassic̈ha. Jalla nuz̈ paatan profetz̈ takuqui cumplissic̈ha. Nii tuquita profetaqui tuz̈ cjichic̈ha: “Wejt zquiti tanzjapa surtiasaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jalla nekztanaqui nijwcpacha ninacaqui wilzjapa julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Kjaz̈tiquiztan Jesusa cruzquiz ch'awctataz̈laja, jalla nii tabliquiz cjijrtatac̈ha, tuz̈ cjican, “Tiic̈ha Jesusaqui, judío z̈oñinacz̈ chawc jiliri”. Jalla nuz̈ cjijrz̈cu ach tsewctuñ nii tabla ch'awcz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Niz̈aza pucultan tjañinaca cruzquiz ch'awctatac̈ha, tsjiiqui z̈ew latu tsjiiqui zkar latu. ");
INSERT INTO capNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Nekz watñi z̈oñinacaqui iñarcan, acha wewcz̈iñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Niz̈aza tuz̈ cjichic̈ha: —Amqui cjiñamla, “Timplu t'ezinz̈cu c̈hjep majquiztan tsijtsnasac̈ha”. Jalla niz̈ta payi atasaz̈ niiqui, jazic persunpacha liwriisalla. Yooz Maatimz̈laj niiqui, cruzquiztan apakscu, chjijwz̈calla. ");
INSERT INTO capNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jalla niz̈ta irata zakaz iñarchic̈ha timplu jilirinacami, liy tjaajiñi maestrunacami, fariseo parti z̈oñinacami, wajtchiz jilirinacami. Jalla ninacaqui porapat parlassic̈ha tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Tiiqui yekja z̈oñinaca liwriichic̈ha, pero persunpacha anaz̈ liwrii atc̈ha. Israel z̈oñinacz̈ chawc jiliriz̈laj niiqui, cruzquiztan apakscu, chjijwz̈quila. Nekztan niiz̈quiz criyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","“Tiic̈ha cjiñiqui, Yoozquin tjapa kuzziztc̈ha. Wejrtc̈ha Yooz Maatiqui”, cjican. Yoozqui tii k'aachichiz̈laja, jaziqui anzpacha Yooz tiij liwriila. ");
INSERT INTO capNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nii cruzquiz ch'awcta tjañinacami Jesusiz̈quiz quintra chiichizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Taypurquiztan majña kak oracama tjapa nii yokaqui zumchi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jalla nii orapacha Jesusaqui tjapa aztan kjawchic̈ha, tuz̈ cjican: —Elí, Elí, ¿lama sabactani? —Jalla nii takuqui cjic̈ha: “Wejt Yooz, wejt Yooz, ¿kjaz̈tiquiztan wejr jaytichamtajo?” ");
INSERT INTO capNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Yekjap nekz z̈ejlñi z̈oñinacaqui jalla nii kjawñi nonz̈cu, cjichic̈ha: —Nonz̈na. Tiiqui Elías profetaz̈ kjaw kjawla. ");
INSERT INTO capNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nekztan tsjii tsjiiqui esponja cjita kjaz ch'umñi apti zajtchic̈ha. Jar vinu ch'umkatz̈cu zjijcchic̈ha. Nekztanaqui war puntiz̈tan chjapz̈cu, Jesusiz̈quin chjalzic̈ha, liquinzjapa. ");
INSERT INTO capNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Parti z̈oñinacaqui cjichic̈ha: —Z̈ela cjee. Antiz chekz̈la, Elías tii liwrii cunamit tjonac̈han. ");
INSERT INTO capNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nekztanaqui Jesusaqui altu jorz̈tan wilta kjawchic̈ha. Jalla nuz̈ kjawz̈cu ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jalla nii orapacha pajk timplu cortina chicatquiz juystokaz wjajrzic̈ha, tsewctan kozzuc. Niz̈aza yokac chjekinchic̈ha. Niz̈aza cur akjinacaqui c'acchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Niz̈aza sipulturanacaqui cjetsi cjissic̈ha. Muzpa Yoozquin criichi ticzi z̈oñinacaqui jacatatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesusaz̈ jacatattiquiztan nii parti jacatatchi z̈oñinacaqui Jerusalén wajtquiz luzquichic̈ha. Jalla nicju muzpa z̈oñinacaqui ninaca cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Zultat capitanaqui nii Jesusa wijilñi zultatunacz̈tanpacha yoka chjekiñi cherz̈cu, niz̈aza tjapa nii watñi cherz̈cu, walja tsucchic̈ha. Jalla nekztan cjichic̈ha: —Chekapan tii z̈oñiqui werar Yooz Maatitakalala. ");
INSERT INTO capNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jalla nicju wacchi maatakanacaqui z̈elatc̈ha, az̈quiztan chekz̈can. Nii maatakanacaqui Galilea yokquiztanpacha Jesusa apzic̈ha, nii atintizjapa. ");
INSERT INTO capNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Jalla nii maatakanacaqui tuz̈ cjita tjunchiztac̈ha: María Magdalenatac̈ha; niz̈aza Mariiqui Jacob Josez̈ maatac̈ha; niz̈aza Zebedeoz̈ tjun z̈elatc̈ha. Naaqui majchwichchiztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Waj zumznan, tsjii ricach z̈oñi, José cjita tjonchic̈ha. Arimatea wajtchiz z̈oñitac̈ha. Niz̈aza Jesusa cumpañt'iñi z̈oñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jalla nii z̈oñiqui Pilato jilirz̈quin zali ojkchic̈ha. Nuz̈ zalz̈cu, Jesusiz̈ curpu maychic̈ha. Nekztan Pilato jiliriqui mantichic̈ha nii curpu intirjajo. ");
INSERT INTO capNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josequi Jesusiz̈ curpu chjichcu, limpu saban pañz̈tan capzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Niiz̈ta ew sipultura z̈elatc̈ha, mazquiztan jwetta. Jalla nii sipulturquiz Jesusiz̈ curpu tjatchic̈ha. Jalla nuz̈ tjatz̈cu, sipultur zana pajk maztan pjuczic̈ha. Nekztan ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jalla nicju María Magdalena, niz̈aza tsjaa María julzi z̈elatc̈ha, sipulturz̈ yujcquiz. ");
INSERT INTO capNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Jakataz̈uqui, jeejz tjuñijapa tjaczcu, timplu jilirinacami, fariseo parti z̈oñinacami Pilato jilirz̈quin zali ojkchizakazza. ");
INSERT INTO capNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jalla nuz̈ zalz̈cu tuz̈ cjichic̈ha: —Wejt Jiliri, wejrnacqui tuz̈ cjuñznuc̈ha. Tii toscar chiiñi z̈oñiqui, z̈ejtcanaqui, tuz̈ cjichic̈ha: “C̈hjep maj ticziquiztan jacatatac̈ha wejrqui” cjican chiiñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Jalla niz̈tiquiztan mantiz̈inalla c̈hjep majcama sipultura zumpacha wijilta cjila. Ana zuma wijilta cjequiz̈ niiqui, niiz̈ tjaajinta z̈oñinacaqui ween niiz̈ curpu chjichi tjonasac̈ha. Jalla nekztanaqui z̈oñinacz̈quiz k'otasac̈ha: “Jesusaqui ticziquiztan jacatatchic̈ha” cjican. Niz̈ta toscara juc'ant anawaliz̈ cjesac̈ha, primira toscara chiitiquiztan. ");
INSERT INTO capNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jalla nekztanaqui Pilato jiliriqui ninacz̈quiz cjichic̈ha: —Jalla tekz zultatunaca z̈ejlc̈ha wijilñijapaqui. Anc̈hucqui oka, nii sipultura zumpachaz̈ chawjcz̈ca, jaknuz̈t atc̈haja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jalla nekztanaqui ojkz̈cu, sipultura zumpacha chawjcz̈quichic̈ha. Niz̈aza nii chawjcz̈ta maz latuquiz sinalt'iz̈cu ecchic̈ha. Niz̈aza nekzpacha nii sipultura wijilñi zultatunacami ecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Kjantati jeejz tjuñi watz̈cu María Magdalena cjitiqui tsjaa Mariatan sepultura cherzñi ojkchic̈ha, primir siman tjuñi kallznan. ");
INSERT INTO capNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Tsjii Yooz anjilaqui arajpachquiztan chjijwz̈quichic̈ha. Nekztan yoka walja chjekinchic̈ha. Anjilaz̈ nii sipultura pjucz̈ta maz cjewz̈inchiqui. Nekztan Yooz anjilaqui nii maz juntuñ julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anjilaqui ancha kjañchic̈ha liwjliwjñiz̈takaz. Niz̈aza ancha chiwitac̈ha niiz̈ zquitiqui, kjatñiz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jalla nuz̈ cherz̈cu wijilñi zultatunacaqui walja tsucchic̈ha chjekinzcama. Ticzi z̈oñiz̈takaz cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jalla nekztanaqui nii anjilaqui maatakanacz̈quiz cjichic̈ha: —Anaz̈ anc̈huc eksna. Wejrqui zizuc̈ha, anc̈hucqui Jesusaz̈ kjurc̈ha, cruzquiz ch'awcta Jesusa. ");
INSERT INTO capNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Anaz̈ tekz z̈ejlc̈ha. Niiqui jacatatchic̈ha, jaknuz̈t chiitc̈haja, jalla nuz̈. Pichay, tii sipultura cherzna. ");
INSERT INTO capNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Nekztanaqui apuraz̈ oka. Niiz̈ tjaajinta z̈oñinacz̈quiz mazca, tuz̈ cjican: “Jesusaqui ticziquiztan jacatatkalc̈ha. Anc̈huca tuqui Galilea yokquin okaychic̈ha. Jalla nicjuz̈ anc̈hucqui Jesusa jacatatchi cheraquic̈ha”. Wejrqui cuchanz̈quitac̈ha tii puntuquiztan anc̈hucaquiz maznajo. —Nuz̈ cjican paljaychic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jalla nekztanaqui sipultur kjuya cherz̈cu, maatakanacaqui apura ojkchic̈ha, ispantichi niz̈aza walja cuntintu. Zati pariju ojkchic̈ha tjaajintanacz̈quin mazñi. ");
INSERT INTO capNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jalla nuz̈ okan Jesusaqui ninacz̈quiz parizichic̈ha. Nekztan ninacz̈quiz tsaanchic̈ha. Nii maatakanacaqui Jesusiz̈quiz macjatz̈cu rispitcan, quilljatchic̈ha, Nekztan niiz̈ kjojcha z̈cojrzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Anaz̈ anc̈hucqui eksna. Wejt jilanacz̈quin mazca, Galilea yok kjutñi ojkla ninacaqui. Jalla nicju ninacaqui wejr cheraquic̈ha. Jalla nii maznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jalla nuz̈ nii maatakanacaz̈ okan wijilñi zultatunacaqui watja ojkchic̈ha. Nekztan timplu jilirinacz̈quin tjapa watchinaca quint'ichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jalla nekztanaqui timplu jilirinacaqui wajtchiz jilirinacz̈quin parli ojkchic̈ha. Nuz̈ parliz̈cu tsjii acuerduquiz luzzic̈ha. Jalla nekztanaqui nii quint'iñi zultatunacz̈quiz paaz tjaachic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tuz̈ cjican: —Anc̈hucqui tii wajtchiz z̈oñinacz̈quiz cjequic̈ha: “Ween wejtnacaz̈ tjajan, niiz̈ tjaajinta z̈oñinacaqui Jesusiz̈ curpu kjañz̈cu chjitchic̈ha”. Jalla nuz̈uz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Chawc jiliriqui anc̈hucaz̈ quint'ita nonznaquiz̈ niiqui, wejrnacqui niiz̈tan parlac̈ha anc̈hucqui ana casticta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jalla nekztanaqui nii zultatunacaqui nii ch'iiz̈inta paaz tanz̈cu, ojkchic̈ha. Jalla nekztan nii paaz laycu toscara chiichic̈ha. Jalla niz̈ta toscar quintu judío z̈oñinacaqui chiichiiñic̈ha anz tii timpuquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jalla nii maatakanacaz̈ maztiquiztan nii tuncaman tjaajinta z̈oñinacaqui Galilea yoka ojkchic̈ha, Jesusaz̈ t'okinzt'ita curquin. ");
INSERT INTO capNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jalla nicju Jesusa cherz̈cu, niiz̈quiz rispitchic̈ha. Yekjapa kuz turwaysi zelatc̈ha, ultimu werara Jesucristo, uz̈ anaj Jesucristo. ");
INSERT INTO capNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jalla nekztanaqui Jesusaqui ninacz̈quin macjatz̈cu, tuz̈ cjichic̈ha: —Wejtquizpacha tjapa mantiz poder tjaatac̈ha, arajpachquin z̈ejlñinaca mantizjapami, niz̈aza tii yok muntuquiz z̈ejlñinaca mantizjapami. ");
INSERT INTO capNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jaziqui anc̈hucqui cuchnuc̈ha. Tjapa tii muntu nacionanacz̈quin oka. Tjapaman nacionchiz z̈oñinacz̈quiz wejtquin kuzziz cjisjapa tjaajinz̈ca. Niz̈aza Yooz Ejp, Yooz Majch, Yooz Espíritu Santo, jalla wejtnaca tjuuz̈tan criichi z̈oñinaca bautizaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Niz̈aza tjapa weriz̈ mantitanaca nii z̈oñinacz̈quiz tjaajnaquic̈ha ninaca cazajo. Zapuru wejrqui anc̈hucatan chica cjeec̈ha, tii muntu tucuzinz̈cama. Jalla nii anc̈hucqui tiraz̈ cjuñaquic̈ha. Jalla nuz̈oj cjila. Amén.");
INSERT INTO capNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Liwriiñi takuqui Jesucristo Yooz Majch puntuquiztan jalla tuz̈uc̈ha. Jesucristuc̈ha Yooz Majchqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Tuqui timpuqui tsjii Yooz cuntiquiztan chiiñi profeta z̈elatc̈ha, Isaías cjita. Nii profetaqui cjijrchic̈ha tii takunaca: “Nonz̈na. Yoozqui Jesucristuz̈ tuqui tsjii z̈oñi cuchanz̈caquic̈ha, tjappacha tjacznajo. ");
INSERT INTO capNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jaziqui ch'ekti yokquin nii z̈oñz̈ joraqui altu tawkz̈tan paljayaquic̈ha, tuz̈ cjican: ‘Tsjii chawc jiliriqui tjonaquic̈ha. Jaknuz̈t jicz zuma tjacznac̈haja, jalla niz̈ta anc̈huca kuznaca zuma tjaczna. Anc̈huca kamañanacaqui zuma lijitumapanz̈ cjee’ ”. Nuz̈ cjijrchic̈ha Isaías cjita z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jalla niz̈tapan Juan Bautistaqui ch'ekti yokquin parizizquichic̈ha. Niz̈aza z̈oñinaca bautissic̈ha. Niz̈aza paljaychic̈ha, tuz̈ cjican: —Kuznacaz̈ campiya, ujnaca pertunta cjisjapa. Nekztan anc̈huc bautisasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Tama z̈oñinaca Juanz̈quin ojkchic̈ha, Judea cjita yokquiztan, niz̈aza Jerusalén cjita wajtquiztan. Jakzilta z̈oñit persun ujnacquiztan “ujchizpanc̈ha” cjican kuzquiz zint'ic̈haja, jalla niiqui bautistatac̈ha Jordán cjita puj kjazquiz. ");
INSERT INTO capNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanz̈ zquitiqui camello chomquiztan watstatac̈ha. Niz̈aza Juanqui zkiz tsjaychiztac̈ha. Niiz̈ c̈hjeriqui tiz̈tatac̈ha: langosto cjita kolta animalanaca, niz̈aza misq'ui. Jalla nii lujlñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Juanqui ojklaycan z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Tsjiiqui wejt wirquin tjonc̈ha. Jalla niic̈ha wejtquiztan tsjan juc'anti poderchizqui. Niiz̈quiz atintisjapa anal waquisuc̈ha, niiz̈ c̈hjata jerz̈cu chjojkzinimi. Inakaztc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Kjaztankal bautisuc̈ha. Nii tjonñi jilirizti Espíritu Santuz̈tan bautisaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nekztanaqui Jesusaqui Nazaret cjita wajtquiztan ojkchic̈ha. Nazaaret watjaqui Galilea cjita provinciquintac̈ha. Jesusaqui Juanz̈quin ojkchic̈ha, Jordán cjita pujquin. Nekz Juanqui Jesusa bautissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesusaqui kjazquiztan ulancan arajpacha cjetzi cherchic̈ha, nii orapacha. Yooz Espíritu Santo palomaz̈takaz chjijwz̈quiñi cherzic̈ha. Niiz̈ juntuñpacha irantiz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Nekztan arajpachquiztan tsjii jora paljayz̈quiñi nonzic̈ha, tuz̈ cjican: —Amc̈ha wejt k'ayi Maatimqui. Amiz̈ cjen ancha cuntintutc̈ha wejrtqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nekztanaqui Espíritu Santuqui ch'ekti yokquin Jesusa ojklayskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jalla nicjuz̈ pusi tunc tjuñi kamchic̈ha Jesusaqui. Nekziqui q'uit animalanaca zakaz z̈elatc̈ha. Jaziqui Satanás cjita diabluqui Jesusiz̈quiz tjonzic̈ha; ujquiz tjojtskatz pecatc̈ha. Pusi tunc tjuñi ujquiz tjojtskatz yanznatc̈ha. Nekztan Yooz anjilanacaqui tjontjonz̈quiñitac̈ha Jesusa atintizjapa. ");
INSERT INTO capNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wiruñaqui Juanqui carsilquiz chawjctatac̈ha. Nekztan Jesusaqui Galilea cjita yokquin ojkchic̈ha. Nii yokquin Yooz liwriiñi taku paljaychic̈ha, jaknuz̈t z̈oñinaca Yooz wajtchiz z̈oñi cjissaja, nii. ");
INSERT INTO capNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tuz̈ cjican, paljaychic̈ha: —Tii timpumiz̈ otc̈ha. Anzpacha z̈oñinacaqui Yooz wajtchiz z̈oñi cjesac̈ha. Kuznaca campiya, “ujchizpanc̈ha”, cjican. Nekztan tii liwriiñi takuz̈ tjapa kuztan catoka. Tii takuz̈ criya. ");
INSERT INTO capNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Tsjii pajk kota z̈elatc̈ha, Galilea cjita. Jesusaqui kot ataran ojklaycan pucultan jilazullca cherchic̈ha; Simón, niz̈aza Andrés cjitatac̈ha. Ninacatac̈ha ch'iz tanñinacaqui. Nii ora ch'iz tanz kjazquiz tjojtznatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha, tuz̈ cjican: —Anc̈hucqui, wejttan chicaz̈ ojklayñiz̈ cjee. Anziqui ch'iz tanz langzzizza. Pero wejrqui anc̈hucaquiz yekja langzquin utznac̈ha, Yooztajapa z̈oñinaca kjawzqui, nii. ");
INSERT INTO capNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nekztanaqui nii orapacha ninacaqui ch'iz tanz eccu, Jesusiz̈tan chica ojklayñi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesusaqui tsjii koloculla nawjcjapa ojkz̈cu, tsjii pucultan z̈oñinaca cherchizakazza; Jacobo, niz̈aza Juan cjitatac̈ha. Ninacz̈ ejpqui Zebedeo cjitatac̈ha. Nii pucultan z̈oñinaca warcuquiz z̈elatc̈ha, ch'iz tanz azquichcan. ");
INSERT INTO capNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jaziqui Jesusaqui ninaca kjawzic̈ha, niiz̈tan chica ojklayñi cjisjapa. Ninacz̈ ejp warcuquiz z̈elatc̈ha, piyunanacz̈tan. Pero Jacobz̈tan Juanz̈tan ejp ecchic̈ha, Jesusiz̈tan ojklayzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nekztanaqui jeejz tjuñi Capernaum cjita watja luzzic̈ha Jesusiz̈tan ninacz̈tan. Nekziqui judío z̈oñinacz̈ ajcz kjuyquiz luzzic̈ha. Nekztan Jesusaqui tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Chawc jiliri irata tjaajnatc̈ha, zuma zizñi. Judiuz̈ lii tjaajiñinacaz̈takaz ana nuz̈ tjaajnatc̈ha. Jesusiz̈ tjaajintiquiztan z̈oñinacaqui ispantichic̈ha: —¡Ancha cuzala! —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nii ajcz kjuyquizpacha tsjii zajraz̈ tanta z̈oñi z̈elatc̈ha. Nii z̈oñiqui kjawchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesusa, Nazaret wajtchiz z̈oñimla. ¿Kjaz̈tiquiztan am wejtnacaquiz mitizi? Wejrnaca aki tjonchamz̈lani. Jaziqui am pajuc̈ha. Zuma Yooz Z̈oñimla. —Nuz̈ cjican, kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nekztan Jesusaqui zajriz̈quiz ujzic̈ha, tuz̈ cjican: —¡Ch'uj z̈ela! Tii z̈oñz̈quiztan ulna. ");
INSERT INTO capNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nekztan zajraqui nii tanta z̈oñi chekjinskatz̈cu, niz̈aza altu tawkz̈tan kjawz̈cu, ulanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Niz̈ta cherz̈cu, z̈oñinacaqui ancha tsucchic̈ha. Ninacpora parlassic̈ha, tuz̈ cjican: —¿C̈hjulut niz̈ta teejo? Tsjemataz̈ tjaajinla. Walja azziz tawkchizla. Tii z̈oñiqui zajramiz̈ mantila. Niz̈aza zajrami tiiz̈ taku cazla. —Nuz̈ ispantichi parlassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Oralla Jesusiz̈ paataqui mazmaztatac̈ha tjapa nii yokaran. ");
INSERT INTO capNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nekztanaqui ajcz kjuyquiztan ulanz̈cu, Jesusaqui Simón, niz̈aza Andrés, jalla ninacz̈ kjuyquiz luzzic̈ha, Jacobz̈tan Juanz̈tan, nuz̈. ");
INSERT INTO capNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simónz̈ ajmuz maaqui ajpsquiz ch'ujlñi conchiz laaquichi z̈elatc̈ha. Tjapa curpu walja kjakatc̈ha. Jaziqui Jesusiz̈quiz mazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesusaqui macjatz̈cu, naaz̈a kjara tanz̈cu, tsijtskatchic̈ha. Nekztanaqui naaz̈a kjakñi cona zarakchic̈ha. Nekztan naa z̈onqui ninaca atintichinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nekztanaqui nii zez tjuñiz̈ kattan Jesusiz̈quiz tjapa laaquichi z̈oñinacami, niz̈aza zajraz̈ tanta z̈oñinacami zjijctatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Niz̈aza Jesusaz̈ alujta kjuy zanaran tjapa nii wajtchiz z̈oñinacaqui ajczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Nekztanaqui Jesusaqui tjapaman laa z̈oñi c̈hjetinchic̈ha. Z̈oñinacz̈quiztan muzpa zajranaca chjatkatchic̈ha. Zajranacaqui Jesusa pajchic̈ha; pero Jesusaqui ana chiikatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Jakawenz taz̈uqui ima kjanz̈can Jesusaqui z̈aazic̈ha, iya zumchi zumchi cjican. Wajtquiztan ulanz̈cu, ana z̈oñz̈ z̈ejlz yokquin ojkchic̈ha, Yooz Ejpz̈tan parli. ");
INSERT INTO capNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wiruñaqui Simonaqui niiz̈ mazinacz̈tan Jesusa kjuri ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jesusiz̈quiz zalz̈cu cjichic̈ha: —Tjapa z̈oñinacaqui am pewc pewcz̈a. ");
INSERT INTO capNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Nekztan Jesusaqui cjichic̈ha, tuz̈ cjican: —Nacjuñz̈ ojkla, visin watjanacquin. Nicju zakaz Yooz taku paljayzquiztanc̈ha wejrqui. Jalla niijapa tii muntuquiz tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nekztanaqui Galilea yokaran ojklaychic̈ha, ajcz kjuyanacquin Yooz taku paljaycan, niz̈aza zajranaca chjatkatcan. ");
INSERT INTO capNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tsjii mojkchi janchichiz z̈oñi z̈elatc̈ha. Niiqui Jesusiz̈quiz tjonchic̈ha. Quillz̈cu, rocchic̈ha, tuz̈ cjican: —Wejr c̈hjetinzim pecc̈haj niiqui, wejr c̈hjetinzim atc̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nekztan Jesusaqui nii z̈oñi okz̈cu, niiz̈quiz lanzic̈ha, tuz̈ cjican: —Wejr am c̈hjetnasachiya. Jaziqui c̈hjetintam cjissa. ");
INSERT INTO capNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jalla nuz̈ chiitiquiztanaqui nii orapacha nii z̈oñiqui z̈ejtchi cjissic̈ha, mojkchi janchi laa cjitiquiztan. ");
INSERT INTO capNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Nekztanaqui Jesusaqui nii z̈oñz̈quiz iwjt'ichic̈ha, tuz̈ cjican: —¡Jaziqui tii c̈hjul am chiichiijay! Anac̈ha jecz̈quizimi chiichiizqui. Timpluquin oka amqui. Nekztan timplu jilirz̈quin persuna tjeez̈ca. Niz̈aza c̈hjetintiquiztan Moisés mantitacama paa. Jaknuz̈t Moisesqui ofrenda uchajo mantic̈haja, jalla nuz̈ ofrenda uchaquic̈ha. Jalla niz̈tiquiztan z̈oñinaca am z̈ejtchi zizaquic̈ha. Jazic oka amqui. —Nuz̈ mantichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Nekztan nii z̈ejtchi z̈oñiqui tjapa kjutñi ojklaychic̈ha, nii z̈ejtta quintu parlican. Tjapa z̈oñinacz̈quin nii quint'ichic̈ha. Jalla nekztanaqui tjapa z̈oñinacaqui Jesusiz̈tan zalz pecatc̈ha. Jalla niz̈tiquiztan Jesusaqui anaz̈ jakzi wajtquizimi luzi atchic̈ha, z̈oñiz̈ zizan. Ana z̈oñz̈ z̈ejlz yokuñ ojklaychic̈ha. Niz̈tami tjapa kjuttan z̈oñinacaqui niiz̈quin tjonñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Tsjii kjaz̈ majquiztan Jesusaqui Capernaum wajta quejpchic̈ha, persun kjuyquiz. Nii zizcuqui, tama z̈oñinacaqui ajczic̈ha, kjuya chjijpscama. Niz̈aza anatac̈ha campo kjuy zanaran. Nekztan ajczi z̈oñinacz̈quiz Jesusaqui Yooz taku tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nuz̈ tjaajnan, pakpaltan z̈oñinaca tjonchic̈ha, tsjii zuch z̈oñi kuzi. ");
INSERT INTO capNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Muzpa z̈oñi ajcziz̈ cjen, Jesusiz̈quin ana macjati atchic̈ha. Nekztanaqui tsewctan kjuya pjetz̈cu, pjetquiztan zuch z̈oñi kjuylchuc chjijunz̈quichic̈ha, niiz̈ tjajz zquitquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ninacaqui Jesucristuz̈quin tjapa kuztan tjonchic̈ha. Nii nayz̈cu, Jesusaqui zuch z̈oñz̈quiz paljaychic̈ha, tuz̈ cjican: —Jilala. Jaziqui am ujnaca pertuntac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Kjuyquiz julzi yekjap z̈oñinaca z̈elatc̈ha, judiuz̈ lii tjaajiñi z̈oñinaca. Ninacaqui kuzquiz pinsatc̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan tiiqui niz̈ta chiijo? Anawalipanc̈ha tiiz̈ takuqui. ¿Ject ujnaca pertunasajo? Yoozpanikazla ujnaca pertunñiqui. —Jalla nuz̈ pinsichic̈ha lii tjaajiñi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesusaqui persun kuzquiz ninacz̈ pinsita zizzic̈ha. Nekztan ninacz̈quiz paljaychic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈huca kuz niz̈ta pinsejo? ");
INSERT INTO capNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jakzilta takut pjasila chiiz cjesajo? Tii zuch z̈oñz̈quiz chiiz̈insjo, “Am ujnacami pertunta”, ¿cjis pjasila cjesaya? uz̈ “Tsijtsna. Am tjajz zquiti aptiz̈cu oka”, ¿nuz̈ chiiz pjasila cjesaj? ");
INSERT INTO capNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha wejrqui. Tii muntuquiz jiliritc̈ha, ujnaca pertunzjapami. Jalla nii zizjapa, anc̈hucqui tiiz̈ chera. Nekztanaqui zuch z̈oñz̈quiz cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Amquiz cjiwc̈ha, tsijtsna. Am tjajz zquitinaca aptaza. Oka am kjuya. —Nuz̈ cjican chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nekztanaqui nii zuch z̈oñiqui tsijtsic̈ha. Tjajz zquiti aptichic̈ha. Liwj tjappachaz̈ cheran, ulanchic̈ha. Jalla niz̈ta cherz̈cu tjapa z̈oñinacaqui walja ispantichi quirchic̈ha, tuz̈ cjican: —Tiz̈ta wira ana cheriñc̈ha. Nekztanaqui Yoozquin honora waytichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nekztanaqui Jesusaqui wajtquiztan ulanz̈cu, pajk kot ataran wilta ojklayatc̈ha. Nuz̈ ojklayan, z̈oñinacaqui niiz̈quin macjatz̈quichic̈ha. Nekztan Jesusaqui ninacz̈quiz tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wiruñaqui nawjcjapa ojkchic̈ha. Jiczquiz ojkcan, Leví cjita z̈oñi cherchic̈ha, aduanz̈ kjuyquiz julznan. Levíz̈ ejpqui Alfeo cjitatac̈ha. Jesusaqui niiz̈quiz paljaychic̈ha, tuz̈ cjican: —Wejttan chica ojklayñim cjequic̈ha. Nekztan tsijtscu, Jesusiz̈tan ojkchic̈ha Leviqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Niz̈aza Leviz̈ kjuya luli ojkchic̈ha. Nicju Jesusiz̈tan niiz̈ tjaajintanacz̈tan nuz̈ lulan, aduanerunacz̈tan niz̈aza ujchiz z̈oñinacz̈tan nekzizakaz lulatc̈ha. Muzpa z̈oñinacaqui Jesusiz̈quin apzitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tsjii kjaz̈t judiuz̈ lii tjaajiñi z̈oñinaca zakaz z̈elatc̈ha, fariseoz̈ partinacami. Jaziqui Jesusiz̈tan anazum z̈oñinacz̈tan juntu lulan, naychic̈ha. Nekztan pewczic̈ha niiz̈ tjaajinta z̈oñinacz̈quiz, tuz̈ cjican: —¿Kjaz̈tiquiztan tii Jesusa aduanerunacz̈tan niz̈aza ujchiz z̈oñinacz̈tan lujljo? ");
INSERT INTO capNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ninacz̈ chiita nonz̈cu, Jesusaqui kjaazic̈ha, tuz̈ cjican: —Zuma z̈ejtchinacaqui anaz̈ kullñi pecasac̈ha. Laa z̈oñinacaz̈ kullñic pecc̈ha. Wejrqui “Zumal kamuc̈ha” cjiñi z̈oñinacz̈quiziqui ana kjawzñi tjonchinc̈ha. Antiz “ujchizpanc̈ha” cjiñi z̈oñinacz̈quiz kjawzñi tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Juanz̈ tjaajintanacz̈tan fariseoz̈ parti z̈oñinacz̈tan, jalla ninacaqui ayunasñipantac̈ha. Jaziqui z̈oñinacaqui Jesusiz̈quiz pewczñi tjonchic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan Juanz̈ tjaajintanacz̈tan niz̈aza fariseoz̈ tjaajintanacz̈tan ayunasñejo? Amiz̈ tjaajintanacazti ana ayunasñipanla. ");
INSERT INTO capNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nekztan Jesusaqui ninacz̈quiz tuz̈ cjichic̈ha: —Zalz pjijstiquiz impittaz̈ cjenaqui, ¿kjaz̈t ayunasasajo? Zalsñi z̈oñz̈tan pjijstaz̈ paac̈ha. Zalsñi z̈oñi z̈elanpacha, anaz̈ ayunasasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Tii jarquin nii zalsñi z̈oñiz̈ kjantaz̈ cjequic̈ha. Nekztanz̈ ayunasasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesusaqui tii takuzakaz chiichic̈ha: —Anaz̈ jakziltami zijzi zquitquiziqui ew rimintiz̈tan rimintasac̈ha. Niz̈ta rimintasaz̈ niiqui, zijzi zquiti juc'anti wjajrskatasac̈ha. Ewqui zijziquiztan jaljiznasac̈ha. Nekztan juc'antiz̈ tsjelanznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Niz̈aza anaz̈ jakziltami zijzi zkiz luusquiz ew vino alznasac̈ha. Niz̈ta alznasaz̈ niiqui, zkiz luus wjajrskatasac̈ha ew vinuqui. Nekztanaqui zkiz luusmi vinumi pizcpacha pertisnasac̈ha. Ew vinuqui ew zkiz luusquizpanz̈ alznasac̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nekztanaqui tsjii jeejz tjuñi Jesusaqui tiric zkal taypiran okatc̈ha tjaajintanacz̈tan. Zkal taypiran ojkcan tjaajinta z̈oñinacaqui tiric oza kjajpchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nii cherz̈cu, yekjap fariseonacaqui Jesusiz̈quiz paljaychic̈ha, tuz̈ cjican: —Cherzna. ¿Kjaz̈tiquiztan niz̈ta paajo? Jeejz tjuñquiziqui niz̈ta anapanc̈ha paazqui. Uc̈hum lii quintrala, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui Yooz taku liichinc̈hucc̈ha, ¿ana jaa? Cjijrta Yooz takuqui tuz̈ cjic̈ha: uc̈hum tuquita atchi ejp, Davíd cjitaqui, niiz̈ mazinacz̈tan c̈hjeri eecskatchic̈ha. Ana c̈hjul c̈hjerchiz cjen, ");
INSERT INTO capNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Yooz timpluquiz luzzic̈ha. Nii ora timplu chawc jiliritac̈ha Abiatar cjitaqui. Timpluquin Yooz yujcquiz nonz̈ta t'antanaca z̈elatc̈ha. Jalla nii t'anta aptiz̈cu, lujlchic̈ha David cjitaqui. Niz̈aza niiz̈ mazinacz̈quiz tojunchic̈ha. Anapantac̈ha permitta nii t'anta lujlzqui ina z̈oñz̈laqui. Niz̈ta lujlz̈cuqui lii quintrala niiqui. Timplu jilirinacaz̈tapankaz nii t'anta lulaj cjitaqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Nekztanaqui Jesusaqui ninacz̈quiz chiiz̈inchizakazza: —Z̈oñz̈ laycu jeejz tjuñiqui uchtatac̈ha. Nii jeejz tjuñquiztanaqui z̈oñic̈ha juc'ant chekanaqui. ");
INSERT INTO capNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jeejz tjuñquizimi c̈hjulu paaz cjenami weril mantasac̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nekztanaqui Jesusaqui wilta tsjii judionacz̈ ajcz kjuyquiz luzzic̈ha. Nekz tsjii kjara kjoñchi z̈oñi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ujchiz jwesjapa quintri z̈oñinacaqui Jesusa awayt'atc̈ha, jeejz tjuñquiz c̈hjetnaquiya, uz̈ anaz̈ c̈hjetnasaj. ");
INSERT INTO capNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nekztanaqui Jesusaqui kjara kjoñchi z̈oñz̈quiz paljaychic̈ha, tuz̈ cjican: —Tsijtsna. Tii taypiquin cjisna. ");
INSERT INTO capNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nekztan parti z̈oñinacz̈quiz paljaychizakazza, tuz̈ cjican: —¿Jeejz tjuñquiziqui uc̈hum liiqui kjaz̈t cjeejo? ¿Z̈oñz̈quiz zuma paasaya uz z̈oñz̈quiz ana zuma paasaja; z̈oñz̈ wira liwriyasaya uz z̈oñz̈ wira ticskatasaja? —Nuz̈ pewczic̈ha Jesusaqui. Ninacazti ch'ujukaz z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nekztan Jesusaqui niiz̈ muytata z̈ejlñi z̈oñinacz̈ kjutñi chercherzic̈ha. Ninacz̈japa z̈awjchic̈ha; niz̈aza ninacz̈ chojru kuzziz cjen, llaquitatac̈ha. Nekztan laa z̈oñz̈quiz paljaychic̈ha, tuz̈ cjican: —Am kjara chjinzna. Nuz̈ kjara chjinz̈cu, z̈ejtchi quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nekztanaqui fariseo z̈oñinacaqui ulanchic̈ha. Ulanz̈cu Herodes partinacz̈tan Jesusiz̈ quintra parlichic̈ha: —¿Jaknuz̈t Jesusa conas? —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈tan ojklaychic̈ha pajk kot ata. Muzpa tama z̈oñinacaqui apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tjapa kjuttan yokquiztan tjonchic̈ha, Galilea yokquiztan, Judea yokquiztan, Jerusalén wajtquiztan, Idumea yokquiztan, Jordán pujz̈ najwctan yokquiztan, Tiro Sidón wajtanac kjuttan, tjapa tii yokanacquiztan Jesusiz̈quin tjonchic̈ha, niiz̈ ancha wali paatanaca cheri. ");
INSERT INTO capNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈quiz chiiz̈inchic̈ha: —Wejtta warcuz̈ tjacz̈ina, tii tama z̈oñinaca ana wejtquiz ts'acjasajo. ");
INSERT INTO capNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Muzpa z̈oñinacaz̈ c̈hjetintaz̈ cjen, tjapa laa z̈oñinacaqui Jesusiz̈quin tjonchic̈ha. Niiz̈quiz lanzjapa, ancha ts'acjassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niz̈aza c̈hjulorami zajranacaqui nii cherc̈haja, niiz̈ yujcquiz quillzic̈ha. Kjawcan, chiichic̈ha: —Yooz Matimc̈ha amqui, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jalla nekztanaqui Jesusac ninacz̈quiz walja iwjt'ichic̈ha, tuz̈ cjican: —Wejtquiztanac anac̈ha anc̈hucqui chiizqui, “Yooz Maatimc̈ha”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nekztanaqui Jesusaqui tsjii curullquin yawchic̈ha. Niiz̈ kuz pecta z̈oñinaca illz̈cu ninaca kjawzic̈ha. Nekztan niiz̈quin macjatchic̈ha illzta z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tuncapan z̈oñi utchic̈ha niiz̈tan kamajo, niz̈aza Yooz taku parlajo. ");
INSERT INTO capNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ninacz̈quiz poderchiz cjiskatchic̈ha, Yooz aztan laa z̈oñinaca c̈hjetnajo, niz̈aza zajrami chjatkatajo. ");
INSERT INTO capNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nii illzta z̈oñinacaqui tinacatac̈ha; Simonatac̈ha; niiqui Pedro cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobotac̈ha; Zebedeoz̈ majchtac̈ha niiqui. Juantac̈ha; Jacoboz̈ lajktac̈ha niiqui. Jacobz̈tan Juanz̈tan altu jorchiz cjen Boanerges cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrestac̈ha. Felipitac̈ha. Bartolomitac̈ha. Mateotac̈ha. Tomastac̈ha. Yekja Jacobotac̈ha; Alfeoz̈ majchtac̈ha niiqui. Tadeotac̈ha. Yekja Simonatac̈ha; tsjii politicutac̈ha niiqui, cananiz̈ partitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariotitac̈ha; Jesusiz̈ quintra tarazunchic̈ha niiqui. Jalla nuz̈uc̈ha Jesusiz̈ illzta z̈oñinacaqui. Nekztanaqui Jesusaqui kjuyquin ojkchic̈ha niiz̈ illzta tjaajintanacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nekziqui muzpa z̈oñinacaqui ajcsizakaztac̈ha. Jesusaqui niiz̈ tjaajintanacz̈tanaqui ana c̈hjeri luli atchic̈ha, z̈oñinacaz̈ muzpa ajcziz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Nekztanac yekjap z̈oñinacaqui cjichic̈ha: —Lucurataz̈ niiqui, —cjican. Jaziqui z̈oñiz̈ lucurata cjiñiz̈ cjen Jesusiz̈ parintinacaqui tjonchic̈ha Jesusa chjichi. ");
INSERT INTO capNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Niz̈aza Jerusalenquiztan judiuz̈ lii tjaajiñinacaqui tjonchic̈ha, tuz̈ cjican: —Jesusaqui Beelzebú cjita zajraz̈ tantac̈ha. Nii zajriz̈ jilirz̈ aztan yekja zajranaca chjatkatñic̈ha tiiqui. —Nuz̈ cjichic̈ha. Beelzebú cjitaqui zajriz̈ jiliritac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nekztanaqui niz̈ta chiiñi z̈oñi kjawz̈cuqui, Jesusaqui paljaychic̈ha, tuz̈ cjican: —¿Jaknuz̈t Satanás cjita zajraqui persunpacha chjatkatasajo? ");
INSERT INTO capNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tsjii wajtchiz z̈oñinacaqui pizcquiz t'aksnasaz̈ niiqui, tsjiimi tsjiimi quintrasasaz̈ niiqui, nii wajtaqui tjatantaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Niz̈aza tsjii kjuychiz z̈oñinacaqui pizcquiz t'aksnasaz̈ niiqui, tsjiimi tsjiimi quintrasasaz̈ niiqui, nii kjuychiz z̈oñinaca wichansnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanasaqui persuna t'aksnasaz̈ niiqui, ezasac̈ha. Niiz̈ aziqui miransnasac̈ha. Anaz̈ azziz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‛Jaziqui anaz̈ jecmi tsjii azziz z̈oñz̈ kjuyquiziqui luzi atasac̈ha, ima azziz z̈oñi c̈hejlcanaqui. Anaz̈ niiz̈ kinakunacami jwesi atasac̈ha. C̈hejlz̈cu, nekztan kinakunaca jwesi luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Cheka ultimu werara chiyuc̈ha, tjapa ujnacami tjapa anazum takunacami pertuntaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero jakzilta z̈oñit Yooz Espirituz̈ quintra chiic̈haj niiqui, anaz̈ pertunta cjesac̈ha. Nii z̈oñiqui wiñaya ujchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Z̈oñiz̈ “Zajraz̈ tantamc̈ha amqui,” cjiñiz̈ cjen, nuz̈ paljaychic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nekztanaqui Jesusiz̈ maatan lajknacz̈tan tjonchic̈ha. Kjuy zanquiztan tsijtscu, Jesusa kjawskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Kjuyltan z̈oñinacaqui Jesuiz̈quiz muytata julzi z̈elatc̈ha. Ninacaqui Jesusiz̈quiz mazzic̈ha: —Tekz am maa tjonchinc̈ha am lajknacz̈tan. Am kjawz̈a, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Nekztanaqui Jesusaqui kjaazic̈ha: —¿Ject wejt maajo, wejt jilanacajo? ");
INSERT INTO capNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nii muytata julzi z̈oñinacz̈ kjutñi cherz̈cu, Jesusaqui cjichic̈ha: —Tinacac̈ha wejt maaqui, wejt jilanacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Jakziltat Yooz mantitacama ojkc̈haja, niic̈ha wejt jilaqui, wejt cullaqui, wejt maaqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wilta Jesusaqui kot atquiz tjaajinchic̈ha. Nekztanac muzpa z̈oñinacaqui niiz̈quiz macjatz̈quichic̈ha. Jalla nekztan Jesusaqui walsiquiz luzzic̈ha kot kjutñi. Z̈oñinacazti kot atquiz z̈ejlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Nekztan nii walsiquiztan z̈oñinacz̈quiz muzpa tjaajinchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Nonz̈na anc̈hucqui. Tsjii z̈oñiqui zkal c̈hjaqui tewcchic̈ha. Nekztan zkal semilla wichcan wichcanka c̈hjacchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nuz̈ c̈hjacan, parti semillanacaqui jicz latuquiz tjojtsic̈ha. Nekzi wez̈lanacaqui tjonchic̈ha nii semilla luli. ");
INSERT INTO capNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Parti semillanacaqui maz yokaran tjojtsic̈ha. Maz juntuñaqui ljawallatac̈ha yokaqui. Nekztan ratulla jeczic̈ha nii c̈hjactaqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero sii kjakiqui nii c̈hjactaqui ujsic̈ha. Ana kozi zep'i atz̈cu, ratulla kjoñchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Parti semillanacaqui ch'ap yokaran tjojtsic̈ha. Nekztan ch'apinacakaz pajkchi, nii c̈hjactaqui tjatanchic̈ha. Ana pookchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Parti semillanacazti zuma yokquiz tjojtsic̈ha. Nekztan cuza jeczic̈ha, pajkchic̈ha, c̈hjerchic̈ha. Jaziqui nii semillanacaqui quinsatunca sojtatunca, patac c̈hjerchiz zapa zkal ozquiz, nuz̈ pookchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jalla nekztanaqui Jesusaqui chiiz̈inchic̈ha: —Jakziltaz̈laja nonzñi cjuñchiz niiqui, nonz̈la. ");
INSERT INTO capNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wiruñaqui Jesusa zinalla z̈elan, niiz̈ tuncapan tjaajinta z̈oñinacz̈tan nekz z̈ejlñinacz̈tan, ninacaqui Jesusa pecunchic̈ha c̈hjacz quintu. ");
INSERT INTO capNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucaquiz Yooz tjaajnaquic̈ha anc̈huca kuzquiz, niiz̈ mantita kamaña puntuquiztan zizjapa. Yekjap z̈oñinacz̈quizzti quintunacz̈tankaz nii puntuquiztan chiyuc̈ha, ana criichi kuzziz cjen. ");
INSERT INTO capNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Jalla niz̈ta chiyuc̈ha, chercanpacha ana zizajo, nonzcanpacha ana intintajo, ana kuz campiizkatajo, ujquiztan ana pertunta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nekztanaqui Jesusaqui tjaajinta z̈oñinacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Anac̈ha tii zkala c̈hjacz quintu ziz, anc̈hucjo? ¿Jaknuz̈t parti weriz̈ chiita quintunaca zizasajo? ");
INSERT INTO capNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Anc̈hucaquiz tjaajnuc̈ha. Zkala c̈hjacz quintuqui jalla tuz̈ cjic̈ha: Jakziltat Yooz taku paljayc̈haja, jalla niic̈ha nii zkala c̈hjacñi z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Tsjii semillanacaqui jicz latuquiz tjojtsic̈ha. C̈hjulorat tsjii z̈oñinacaqui Yooz taku nonz̈aja, oralla Satanasaqui tjonc̈ha, kuzquiztan nonz̈ta taku kjañzjapa. Jalla niz̈tac̈ha nii jicz latuquiz yokaz̈takaz z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Niz̈aza tsjii semillanacaqui maz yokaran tjojtsic̈ha. Nii maz yokaz̈takaz z̈oñinacaqui Yooz taku nonz̈cu, orallaz̈ catokc̈ha. Pero tsjii upacamakaz Yooz tawk jaru kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ana koz zep'ichiz zkalaz̈takazza ninacaqui. Yooz taku catoktiquiztan yekjap z̈oñinacaqui quintrassa, ninaca chjaawjc̈ha. Niz̈aza pruebanacac tjonc̈ha. Nekztan ratulla Yooz taku tjatz̈a, quejpsa. ");
INSERT INTO capNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Niz̈aza tsjii semillanacaqui ch'ap yokaran tjojtsic̈ha. Nii ch'ap yokaz̈takaz z̈oñinacaqui Yooz taku nonz̈a. ");
INSERT INTO capNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nekztanaqui c̈hjulquinami pinsic̈ha. Wali jiru cjis pecc̈ha; c̈hjultakimiz̈ pecc̈ha. Nekztan kuzqui turwaysa. Niz̈ta kuzziz cjen, Yooz taku tjatanñic̈ha. Ch'ap yokaran c̈hjacta semillanaca ch'apiz̈ atipta, anaz̈ pakji atc̈ha. Jalla niz̈taz̈ nii ch'ap yokaz̈takaz z̈oñinacaqui. Nuz̈quiz nii z̈oñz̈ kuzquiz Yooz takuqui anaz̈ pookc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Tsjii semillanacaqui zuma yokquiz tjojtsic̈ha. Nii zuma yokaz̈takaz z̈oñinacaqui Yooz taku nonz̈cu, tjapa kuztan catokc̈ha. Nekztanaqui ninacz̈ kuzquiz Yooz takuqui cusaz̈ pookc̈ha. Nii zum yokquiz c̈hjactaqui cusaz̈ c̈hjerc̈ha —quinsatunca, sojtatunca, patac c̈hjerchiz zapa zkal ozquiz. Jalla niz̈ta Yooz takuqui pookc̈ha zuma z̈oñinacz̈ kuzquiziqui. Jesusaqui tsjiiz̈tan quint'ichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","—Micha ana tjeeznasac̈ha cajun kjuyltan nonzjapa, niz̈aza tjajz zquit koztan nonzjapa. ¿Jalla niz̈ta cjesajo? Anaz̈ cjesac̈ha. Micha tjeezqui iztacz̈ juntuñ nonznasac̈ha, zuma kajajo. ");
INSERT INTO capNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","C̈hjulu c̈hjojz̈tami waz̈tapanikaz cjequic̈ha. Niz̈aza Yooz puntu ana ziztanacami kjanapacha ziztapanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Jakziltaz̈laj nonzñi cjuñchiz niiqui, nonz̈la. ");
INSERT INTO capNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jesusaqui cjichizakazza: —Weriz̈ chiita taku zuma nonz̈nalla anc̈hucqui. Jaknuz̈t anc̈huc tjaac̈haja, jalla niz̈tazakaz Yoozqui anc̈hucaquiz tjaasac̈ha; iya zakaz yapznasac̈ha Yoozqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jakziltaz̈laj catokñi kuzziz niiqui, juc'anti zuma kuz tjaataz̈ cjequic̈ha, Yooz taku intintajo. Jakziltaz̈laj ana catokñi kuzziz niiqui, juc'anti turwayskattaz̈ cjequic̈ha. Jalla niz̈tiquiztan Yooz takuqui anapan intintiñiz̈ cjequic̈ha. —Nuz̈ tjaajinchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Niz̈aza Jesusaqui iya tjaajinchic̈ha, tuz̈ cjican: —Yooz wajtchiz z̈oñinacaqui jalla tuz̈uc̈ha. Tsjii z̈oñiqui zkala c̈hjacc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nekztan ween tjajc̈ha, majiñ z̈aaz̈a. Jaknuz̈t zkalaqui jecz̈aja, pajkc̈haja, nii ana zizza z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Zkal yokaqui juyz̈tokaz pookc̈ha. Primiruqui zkalaqui jecz̈a, nekztan pjajkjallc̈ha, nekztan ozziz cjissa, nekztan c̈hjerchizza. Nuz̈ pookc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Nekztan zkala wejlziz̈ cjen pajk cuchillz̈tan zkala ajza. Zkala ricujz timpuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesusaqui tsjii quintuz̈tan tjaajinchic̈ha. —Yooz wajtchiz z̈oñinaca, ¿jalla nii puntu irata c̈hjulut cjesajo? Anc̈hucaquiz cjiwc̈ha, tii quintu irata cjesac̈ha, mostaz quintu. ");
INSERT INTO capNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Tsjii semillaqui mostaza cjitac̈ha. Tjapa semillquiztan juc'ant zkoltallac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero c̈hjacta mostaz semillaqui walja pakji pajkc̈ha, c̈hjul zkalquiztanami juc'anti. Pajk itzzizza. Layñi wez̈lanacami itzquiz julz̈cu, ziwz̈quiz jeejznasac̈ha. —Nuz̈ tjaajinchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jalla niz̈ta quintunacz̈tan z̈oñinacz̈quiz tjaajinchic̈ha, quintu nonz̈ñi otchañcama. ");
INSERT INTO capNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Quintunacz̈tankaz tjaajinchic̈ha. Nekztan niiz̈ persun tjaajinta z̈oñinacz̈quiz zapa quintumi intintiskatchic̈ha, parti z̈oñinacaz̈ ana z̈elan. ");
INSERT INTO capNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tsjii nooj tjuñiz̈ kattan, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Tii kotz̈ najwktuñtanz̈ ojklay, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nekztan parti z̈oñinaca eccu, Jesusaqui tsjii walsiquiz ojkchic̈ha niiz̈ tjaajintanacz̈tan. Niz̈aza yekja walsanacaqui ninacz̈tan chica ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nekztanaqui tsjii wali pjursanti tjami zalchic̈ha. Jaziqui juc'anti tjamiz̈ cjen walsiquiz ancha kjaz luzzic̈ha. Walsaqui jozipan kjaz chjijpsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesusaqui walsa kjuyltan tsjii azquiz tjajatc̈ha, wirquin. Tjaajinta z̈oñinacaqui Jesusa z̈iñzic̈ha, tuz̈ cjican: —¡Tjaajiñi Maestro! ¡Ticzmayala uc̈humqui! ¿Anam llaquisya? ");
INSERT INTO capNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wajtz̈cuqui Jesusaqui tjami mantichic̈ha, apaltajo. Kjaz ljojki mantichizakazza: —¡Ch'uj z̈ela! —cjican. Nekztanac tjamimi niz̈aza kjaz ljojkinacami apaltichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha: —¿Kjaz̈tiquiztan ancha tsucchinc̈huctajo? ¿Ana wejtquiz kuzzizc̈huckaya? ");
INSERT INTO capNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Tjaajinta z̈oñinacaqui ancha ispantichi cjissic̈ha. Ninacpora parlassic̈ha, tuz̈ cjican: —¿C̈hjul z̈oñit teejo? Tiiz̈ takucama tjamimi niz̈aza kjaz ljojkimi cazla. ");
INSERT INTO capNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nekztanaqui kotz̈ najwctuñtan irantichic̈ha Gadara cjita yokquin. ");
INSERT INTO capNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","3","Jesusaqui walsiquiztan ulantan, tsjii zajraz̈ tanta z̈oñiqui campu santuquiztan tjonchic̈ha. Campu santuquin kamñitac̈ha. Niz̈aza anaz̈ jecmi nii zajraz̈ tanta z̈oñi c̈heli atatc̈ha, jir carinz̈tanami. ");
INSERT INTO capNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Kjaz̈ wilta kjojchami kjarami carinz̈tan c̈hejlz̈inzpantac̈ha. C̈hejlz̈tiquiztan carinaqui kjoksñipankaztac̈ha; t'una kjolzñipankaztac̈ha. Anaz̈ jecmi nii z̈oñz̈ azquiziqui alcansatc̈ha, nii atipzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ween majiñ campu santuran cururan ojklayñitac̈ha kjawcan. Maztan persun janchi chjojritsñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Az̈quiztan nii z̈oñiqui Jesusa cherz̈cu, zajtz̈quichic̈ha, Jesusiz̈ yujcquiz quillzlaki. ");
INSERT INTO capNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Nekztan altu jorz̈tan chiichic̈ha, tuz̈ cjican: —Jesusa, Arajpach Yooz Maati, ¿kjaz̈tiquiztan am wejtquiz mitisi? Am roct'uc̈ha, anaz̈ wejr tjatnalla, anaz̈ wejr sufriskatalla. ");
INSERT INTO capNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Tuquiqui Jesusaqui mantichic̈ha, tuz̈ cjican: —Zajra, tii z̈oñz̈quiztan ulna. Nuz̈ mantitiquiztan zajraqui chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Niz̈aza Jesusaqui pewczic̈ha: —¿C̈hjul tjuuchizamta? —cjican. Nii zajraqui kjaazic̈ha, tuz̈ cjican: —Tama cjitaz̈ wejt tjuuqui. Tamac̈ha wejrnacqui. ");
INSERT INTO capNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nekztan nii zajranacaqui Jesusiz̈quiz ancha rocchic̈ha, ana najwcuñ ojklayskatajo. ");
INSERT INTO capNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nekziqui tsjii lumquiz tama cuchinacaqui lulatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Niz̈taqui Jesusiz̈quiz rocchic̈ha, tuz̈ cjican: —Cuchinacz̈quin wejrnac cuchnalla. Cuchinacz̈quizkaz luzkatalla. ");
INSERT INTO capNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nekztanac Jesusac cjichic̈ha: —Oka niz̈taqui. Ulanz̈cu zajranacami cuchinacz̈quiz luzzic̈ha. Tsjii pizc waranka cuchinaca z̈elatc̈ha. Zajranacaz̈ luztan cuchinacaqui ispantichic̈ha. Kot kjutñi jira pariju chjujcuntichic̈ha. Kjazquiz luzcu, ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nekztanaqui nii cuchi itzñi z̈oñinacaqui tsucaña zajtchic̈ha. Wajtquinami jochquinami cwint'ichic̈ha cuchi kjazquiz katta quintu. Nekztan z̈oñinacaqui ojkchic̈ha, nii paatanaca cherzñi. ");
INSERT INTO capNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","16","Jesusiz̈quin irantiz̈cu, zajraz̈ tanta z̈oñi z̈ejtchi cherchic̈ha. Julzi, zquitimi cujtzi, z̈ejtchi, niz̈ta cherchic̈ha. Jalla nuz̈ cherz̈cu nii z̈oñinacaqui ancha tsucchic̈ha. Ispantichic̈ha. Nekztan nii cherzñi z̈oñinacaqui yekja z̈oñinacz̈quiz mazzic̈ha. Jaknuz̈t nii zajraz̈ tanta z̈oñi watc̈haja, jaknuz̈t nii cuchinacami watc̈haja, nii mazmazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Nekztanaqui z̈oñinacaqui Jesusiz̈quiz rocatc̈ha: —Tii yokquiztan okalla amqui, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Nekztan Jesusa walsiquiz luznan nii z̈ejtchi z̈oñiqui Jesusiz̈quiz rocatc̈ha: —Amtanpan tira z̈ejlz pecuc̈ha, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesusaqui ana munchic̈ha, tuz̈ cjican: —Am kjuya oka amqui, am jamillanacz̈quin. Ninacz̈quiz mazca, “Wejr okzic̈ha Yoozqui. Yooz c̈hjetintitc̈ha wejrqui”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nekztanaqui Tunca Wajtanaca cjita yokaran ojklaychic̈ha nii z̈ejtchi z̈oñiqui. Nicjuñ jaknuz̈ Jesusaqui nii c̈hjetinchiz̈laja, jalla nii mazmazquichic̈ha. Jalla nekztanaqui nii maztiquiztan tjapa z̈oñinacaqui tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nekztanaqui Jesusaqui kot najwctuñtan quejpz̈quichic̈ha walsiquiz. Kot ataran z̈elan, nekziqui muzpa tama z̈oñinacaqui niiz̈ muytata ajczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jalla nekztan tsjii Jairo cjita z̈oñiqui tjonchic̈ha. Judionacz̈ ajcz kjuy jiliritac̈ha niiqui. Jesusa cherz̈cu niiz̈ yujcquiz ezlaki quillzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nekztan Jesusiz̈quiz ancha rocchic̈ha, tuz̈ cjican: —Ticzmayaz̈ wejt kolta uzqui. Tjonz̈calla amqui. Wejt uzaquiz am persun kjarz̈tan lanz̈inalla, wejt uz z̈etajo, ana ticznajo. ");
INSERT INTO capNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nekztanac Jesusaqui niiz̈tan chica nii z̈oñz̈ kjuya ojkchic̈ha. Okan tama z̈oñinacaqui Jesusiz̈ wirquiz apzic̈ha, ts'acjascan tejwc tejwcwarascan. ");
INSERT INTO capNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Z̈oñinacz̈ taypiquiz tsjaa laa z̈on z̈elatc̈ha. Tuncapan wata ljoc okiñtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tsjii kjaz̈ kullñi z̈oñinacz̈quin ojkchinc̈ha. Juc'anti sufriskatchic̈ha ninacaqui. Nuz̈quiz inapankaz tjappacha naaz̈a cusasa castassinc̈ha. Naa z̈onqui juc'anti laa cjisnatc̈ha; ana wira z̈eti atatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Jesusiz̈ paata quintunaca nonchinc̈ha. Nekztan Jesusiz̈ wirquiztan macjatchinc̈ha. Tama z̈oñinacz̈ taypiquiz z̈elan, tuz̈ cjican pinsichinc̈ha: —Niiz̈ zquitikaj lanznuc̈haj niiqui, z̈etaka. Nekztan niiz̈ zquiti lanzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Lanz̈cu nii orapacha tsijtsic̈ha naaz̈a ljoc ojkñiqui. Z̈ejtchinc̈ha. Persun janchiquiz naychinc̈ha, nii laaquiztan z̈ejtchi. ");
INSERT INTO capNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesusaqui persun kuzquiz naychic̈ha, niiz̈ aztan naa z̈on c̈hjetinchic̈ha, nii. Nayz̈cu wir kjutñi cherzic̈ha. Nekztan pewczic̈ha, tuz̈ cjican: —¿Ject wejt zquiti lanzejo? ");
INSERT INTO capNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nekztanac niiz̈ tjaajinta z̈oñinacaqui cjichic̈ha: —Cherzna. Tama z̈oñinaca ancha amquiz ts'acjassa. ¿Kjaz̈tiquiztan am nuz̈ pewczjo, “Ject wejr lanzejo?” cjicanajo. ");
INSERT INTO capNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Nekztan Jesusac z̈oñinacz̈ kjutñi chercherzic̈ha, jectc̈halaj nii lanzi, nii pajzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nekztan naa z̈onqui persun curpu z̈ejtchi nayz̈cuqui, ekekscan cjarcatcan macjatchinc̈ha, Jesusiz̈ yujcquiz quillzinc̈ha. Nekztan naaqui tjapa werara mazzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nekztan Jesusaqui cjichic̈ha: —Cullacalla. Tjapa kuztan criichiz̈ cjen, c̈hjetinta cjissamc̈ha. Jaziqui z̈ejtchipanim cjequic̈ha. Cuntintum okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Nekztanaqui Jesusiz̈ naa z̈onaquiz chiyan, tsjii z̈oñinacaqui tjonchic̈ha; Jairo cjita judio jilirz̈ kjuyquiztan tjonchic̈ha. Nii jilirz̈quiz cjichic̈ha: —Am uzqui ticzinc̈ha. Anam iya tii maestruz̈quiz molistis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesusazti nii z̈oñinacz̈ chiita taku ana catokchic̈ha. Nekztan nii jilirz̈quiz cjichic̈ha: —Ana am niic kuz turwayskata. Yoozquin tjapa kuztanpan cjeella. ");
INSERT INTO capNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nekztan Jesusaqui Pedruz̈tan Santiaguz̈tan Juanz̈tan (Santiaguz̈ lajk) ninacakaz apskatchic̈ha. Partinaca ana apskatchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nekztan judío jilirz̈ kjuyquin irantiz̈quichic̈ha. Nekzi z̈oñinacaqui ancha kjawcanz̈ kaatkalc̈ha. Niz̈ta cherchic̈ha Jesusaqui. Ancha arnatc̈ha nii kaañi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Kjuyquin luzcu, Jesusaqui cjichic̈ha: —¿Kjaz̈tiquiztan ancha aranjo, niz̈aza kaajo? Taa uzqui anac̈ha ticzin, tjajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nekztan nii z̈ejlñi z̈oñinacaqui tjassic̈ha, nii nonz̈cu. Jesusazti zancuñ nii z̈oñinaca ulanskatchic̈ha. Nekztanaqui Jesusaqui maa ejpz̈tan niiz̈ mazinacz̈tan luzzic̈ha, jakziquin naa uz z̈elatc̈haja, nicju. ");
INSERT INTO capNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nekztan Jesusaqui naa uza kjara tanzic̈ha. Niz̈aza altu tawkz̈tan chiichic̈ha: —Talita cumi, —cjican. Nii takuqui cjic̈ha, “Usalli, z̈aazna”. ");
INSERT INTO capNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Nekztanac nii orapacha naa uzqui z̈aaziñc̈ha. Ojklaychiñc̈ha. Tuncapan watchiztac̈ha naa uzqui. Nekztanaqui nii z̈oñinacaqui kuz kata tsucchic̈ha. Ancha ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Nekztan Jesusaqui zuma iwjt'ichic̈ha, tuz̈ cjican: —Ana jecz̈quizimi tii c̈hjetinta quintu chii chiyaquic̈ha. Nuz̈ mantiz̈cu, ninacz̈quiz mantichizakazza, naa uzaquiz c̈hjeri tjaajo, nii. ");
INSERT INTO capNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nekztanaqui Jesusaqui najwctan persun wajtquin ojkchic̈ha niiz̈ tjaajintanacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Jeejz tjuñquiziqui judionacz̈ ajcs kjuyquiz tjaajinchic̈ha. Nii nonz̈cuqui z̈oñinacaqui ispantichic̈ha, tuz̈ cjican: —¿Jakziquin zizzit tii z̈oñi tii tjaajinznacaya? ¿Jaknuz̈ zizzit tii tjaajinznacaya? ¿Jaknuz̈ paachit tii milajrunacaya? ¿Jaknuz̈upan teejo? ");
INSERT INTO capNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Tiiqui carpintirukazla, María majchc̈ha tiic, ¿ana jaa? Tiiz̈ lajknacaqui Jacobo, José, Judas, Simón cjitac̈ha. Ninacz̈tan tiiz̈ cullaquinacz̈tan tii wajtquiz uc̈humnacz̈tan kamc̈ha. —Nuz̈ cjichic̈ha. Nekztanaqui nii wajtchiz z̈oñinacaqui Jesusiz̈ quintra muzpa z̈awjzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nekztan Jesusac chiichic̈ha: —Tjapa z̈oñinacaqui Yooziz̈ uchta profetz̈quiz rispitla. Pero persun wajtchiz z̈oñinacami persun parintinacami persun familianacami profetz̈quiz anaz̈ rispitz pecñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Nekziqui nii wajtquiz tsjii kjaz̈ultan z̈oñi c̈hjetinchic̈ha, kjarz̈tan lanz̈cu. Ana iya milajru paayi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ana criiñiz̈ cjen Jesusaqui cjichic̈ha: —¿Kjaz̈tiquiztan tii z̈oñinacaqui ana criijo? ¿Kjaz̈t cjisnaquejo? Nekztanaqui nii wajtquiztan ulanz̈cu, visinunacz̈ wajtquiztan wajta tjaajinñi ojklaychic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesusaqui niiz̈ tuncapan tjaajinta z̈oñinaca kjawz̈cu, pucultan pucultan cuchanchic̈ha: —Anc̈hucqui Yooz aztan zajranaca chjatkataquic̈ha, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jalla nekztanac mantichic̈ha, tuz̈ cjican: —Anc̈hucqui anaz̈ c̈hjulumi chjichaquic̈ha jiczjapaqui, anaz̈a z̈ak quelzmi anaza c̈hjerimi anaza paazmi. Tsjii atskaz chjichaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","C̈hjata c̈hjatz̈cuc̈ha okaquic̈ha. Niz̈aza tsjii zquitillchizkaz okaquic̈ha, ana pizc zquitchiz. ");
INSERT INTO capNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Anc̈hucqui jakziquinz̈ alujasac̈haja, nekziz̈ kamaquic̈ha, c̈hjulorat nii wajtquiztan ulnac̈haja, niicama. ");
INSERT INTO capNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jakzilta watjat anc̈huc ana cherz pecc̈haja, niz̈aza anc̈huca takumi ana nonz pecc̈haja, jalla nii wajtquiztan ulnaquic̈ha. Nekztan nii yok pulpu anc̈huca kjojchquiztan tsajt tsajtsnaquic̈ha, ninacz̈ uj tjeezjapa. Ultim weraral cjiwc̈ha, juyzu tjuñquiziqui Sodomo niz̈aza Gomorra cjita watjanacchiz z̈oñinacaqui castictaz̈ cjequic̈ha. Pero nii ana anc̈huc pecñi z̈oñinacazti juc'anti castictaz̈ cjequic̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jalla nekztanaqui niiz̈ tuncapan tjaajinta z̈oñinacaqui Yooz taku paljayi ulanchic̈ha, tuz̈ cjican: —Anc̈hucqui tjappacha kuz campiya. Anc̈huca uj paaznacaqui eca. ");
INSERT INTO capNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nekztanaqui zmali zajranaca chjatkatchic̈ha. Niz̈aza asiitiz̈tan achquiz tjawkz̈cu, muzpa laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Tjapa kjutñi nii yokaran z̈oñinacaqui Jesusiz̈ ancha wali paata milajrunaca zizzic̈ha. Herodes cjita nacionz̈ chajwc jilirimi zizzizakaztac̈ha. Nii Jesusiz̈ paata milajrunacz̈ puntu nonz̈cuqui, Herodesaqui cjichic̈ha: —Juan Bautistala tiiqui. Ticziquiztan jacatatchiz̈lani. Jalla niz̈tiquiztan walja milajrunaca paazjapa poderchizlani. ");
INSERT INTO capNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yekjap z̈oñinacaqui cjichic̈ha: —Elías cjita profetila tiiqui. Yekjapaqui cjichic̈ha: —Tuquitan Yooz taku parliñi profetaz̈takazla tiiqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Jesusiz̈ quintu nonz̈cu Herodes cjita nacionz̈ chawc jiliriqui cjichic̈ha: —Juan Bautistala tiiqui. Wejrqui tiiz̈ acha pootkatchinc̈ha. Anziqui jacatatchila tiiqui. —Nuz̈ cjichic̈ha Herodesaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Tuquiqui tuz̈u watchic̈ha. Herodiy cjita z̈onqui Felipiz̈ tjuntac̈ha. Felipitac̈ha Herodes jilaqui. Nekztan Herodesaqui Felipiz̈ tjunatan zalsic̈ha. Nekztan Herodiy cjita tjunqui Herodiz̈quiz paljaychic̈ha: —Nii Juan tankata. Carsilquiz chawjczna. —Nuz̈ cjichinc̈ha naaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Tuquitan Juanqui Herodes cjita jilirz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Am persun jilz̈ tjunatan zalsamc̈ha amqui. Nuz̈ ana waquisic̈ha. Jaziqui liy quintram kamc̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Nekztanaqui naa Herodiiqui Juanz̈ quintra ancha z̈awjchinc̈ha. Conkatzpan pecatc̈ha. Pero ana atchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juanqui zuma kuzziztac̈ha, ana ujchiz z̈oñi. Nekztan Herodesaqui Juanz̈quiz eksic̈ha. Nekztan Herodiyqui ana conkati atchinc̈ha. Herodesaqui Juanz̈ taku nonz̈cu, walja paysnakchic̈ha. Jalla nuz̈ cjenami Juanz̈ taku juztazñipankaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Wiruñaqui niiz̈ cumpliaños pjijztiquiz Herodesaqui cusa c̈hjerinaca luli kjawzic̈ha. Wajt jilirinaca, sultatz̈ jilirinaca, Galiliquiztan ricach z̈oñinaca, ninaca kjawzic̈ha. Nii tjuñquiz naa Herodiyqui ancha kuz tjutzinc̈ha, Juan conkatzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nii nooj jakziquin c̈hjeri lujlc̈haja, nicju Herodiyz̈ turqui tsati luzzinc̈ha. Nekztanaqui naa turaz̈ ancha tsajtchinc̈ha. Nii cherz̈cu, juztazzic̈ha Herodiz̈tan niiz̈ invitta z̈oñinacz̈tanaqui. Nekztan nii Herodes jiliriqui naa turaquiz paljaychic̈ha, tuz̈ cjican: —C̈hjulum pecc̈haj niiqui, wejtquiztan mayaquic̈ha. Amquiz tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jaziqui Herodesac turaquiz juramentuz̈tan chiichic̈ha, tuz̈ cjican: —C̈hjulu pecanami amiz̈ maytacama chicat wejt nacionami amquiz tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nekztan ulanz̈cu naa turqui maa pewczinc̈ha: —¿C̈hjulut wejr mayas, mama? —cjican. Maaqui kjaazinc̈ha: —Juan Buatistiz̈ acha maya. ");
INSERT INTO capNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nekztan apura jilirz̈quiz luzquichinc̈ha naa turqui. Maychinc̈ha maaz̈ mantitacama, tuz̈ cjican: —Anzpacha tsjii chuwquiz Juan Bautistiz̈ achal pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nekztanaqui nii jiliriqui ancha llactazzic̈ha. Juramentuz̈tan chiichiz̈ cjen, niz̈aza niiz̈ mazinacaz̈ nonziz̈ cjen, ana kjaz̈ cjiyi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Nekztan sultatu cuchanchic̈ha Juanz̈ acha zjijcajo. ");
INSERT INTO capNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Carsila ojkchic̈ha mantita sultatuqui. Nekztanaqui Juanz̈ acha pootz̈cu chuwquiz zjijcchic̈ha. Naa turaquiz acha tjaatatac̈ha. Nekztan naaqui maaquin acha tjaaz̈quichinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jalla nekztanaqui Juanz̈ acha poota nonz̈cuqui, Juanz̈ tjaajintanacaqui niiz̈ curpu mayi tjonchic̈ha, chjitzjapa, yokquiz tjatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wiruñaqui Jesusiz̈ cuchanta z̈oñinacaqui quejpz̈quichic̈ha. Jesusiz̈quiz cwint'ichic̈ha tjapa ojklaytanacami tjapa tjaajintanacami. Nekztan Jesusaqui ninacz̈quiz paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","—Jakziquint ana z̈oñinaca z̈ejlc̈haja, nicju tjappachaz̈ ojklalla. Nicju jeejz̈caquic̈ha. Ancha z̈oñinacaz̈ tjontjonz̈tiquiztan wira ana c̈hjerimi lujlzucatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Nekztanaqui Jesusiz̈tan niiz̈ tjaajinta z̈oñinacz̈tan, jalla ninacakaz ojkchic̈ha; ana z̈ejlz yokquin walsiquiz ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero eclichi z̈oñinacaqui ninaca ojkñi cherchic̈ha. Z̈oñinacaqui ninaca pajz̈cu tjapa wajtquiztan kjojchuñ zajtchic̈ha. Jaziqui nii z̈oñinacaqui Jesusiz̈ tuqui irantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesusaqui nii yokquin irjatz̈cuqui walsiquiztan ulanchic̈ha. Nekztan tama z̈oñinaca cherzic̈ha. Nii z̈oñinaca okzic̈ha. Ana awatirchiz uuzanacaz̈takaz nii z̈oñinaca z̈elatc̈ha. Nekztanac Jesusac walja tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ima tjuñ katalla Jesusiz̈ tjaajintanacaqui tjonchic̈ha, tuz̈ cjican: —Ana z̈ejlz yokquizla uc̈humqui. Tjuñiqui wajillaz̈ kataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jaziqui tii z̈oñinacaqui joch kjutñimi wajt kjutñimi cuchnalla, nicju c̈hjerimi kjayz̈cajo. Ninacz̈ta c̈hjeri ana z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesusaqui kjaazic̈ha: —Anc̈hucc̈ha tinacz̈quiz c̈hjeri tjaa. Ninacaqui cjichic̈ha: —¿Tinacz̈quiz c̈hjeri tjaazjapa, paa patac paaztan t'anta kjayi okas? ");
INSERT INTO capNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nekztan Jesusac kjaazic̈ha: —¿Kjaz̈ t'antat anc̈hucalta z̈ejljo? Cherz̈ca anc̈hucqui. Nekztan cherz̈cu quejpz̈quichic̈ha ninacaqui. Nekztan chiichic̈ha, tuz̈ cjican: —Pjijska t'anta pizc ch'iz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jalla nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Jaziqui pastu yokaran t'aka t'aka tii z̈oñinaca tjulz̈na, ");
INSERT INTO capNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","patacquiztan pataca, pjijska tuncquiztan pjijska tunca. Nekztan nuz̈upan julzic̈ha z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nekztanaqui Jesusaqui nii pjijska t'anta pizc ch'iz niiz̈ kjarquiz tanzcuqui, tsewcchuc cherzic̈ha. Nekztan Yooz Ejpz̈quin gracias cjican chiichic̈ha. Nekztan t'anta kjolzic̈ha. T'una t'una kjolz̈cu, tjaajintanacz̈quiz tojzic̈ha, parti z̈oñinacz̈quiz onajo. Niz̈aza nii pizc ch'iz tojzizakazza z̈oñinaca lulajo. ");
INSERT INTO capNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nekztan tjapa z̈oñinacaqui chjeki cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Nekztanaqui z̈ejtchi t'anti t'unanacami ch'iz t'unanacami tuncapan canasta chjijpi ricujchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nii t'anta lujlñi luctak z̈oñinacaqui pjijska warankatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nekztanaqui Jesusaqui niiz̈ tjaajintanaca walsiquiz luzkatchic̈ha, nii kota kakajo, Betsaida cjita wajtquin kotz̈ najwcchaktan. Ninacz̈ ojktan Jesusaqui parti z̈oñinacz̈quiz cjichic̈ha: —Anc̈huca kjuyaz̈ okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Z̈oñinaca cuchanz̈cuqui Jesusaqui cur kjutñi yawchic̈ha, Yooz Ejpz̈tan parlisjapa. ");
INSERT INTO capNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nii oraqui zumchitac̈ha. Curquin Jesusaqui zinallatac̈ha. Pajk kotquiziqui nii tjaajinta z̈oñinaca walsiquiz kjaz kot taypiquintac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesusaqui curquiztan walsa cherchic̈ha. Tjamiqui pjursantitac̈ha. Nii tjaajinta z̈oñinacaqui tjapa aztan langznatc̈ha, najwcchaktan walsa tjakzjapa. Ima kjantatiz̈ cjen ninacz̈quin ojkchic̈ha Jesusaqui. Kjaz juntuñ ojkchic̈ha, tsjii latu watzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nii tjaajintanacazti Jesusa kjaz juntuñ ojkñi cherchic̈ha. Nekztanac kjawchic̈ha: —Cuntinaz̈ caa, almaz̈ caa, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ancha tsucchic̈ha. Nekztanaqui Jesusaqui paljaychic̈ha, tuz̈ cjican: —Anac̈ha tsuca anc̈hucqui. Wejrtc̈ha. Tjup kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nekztanaqui walsiquiz luzzic̈ha Jesusaqui. Nii oraqui tjamiqui zekzic̈ha. Jalla nekztanaqui tjaajintanacaqui ispantichic̈ha. Inakaz cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ninacatac̈ha ana nii t'anta milajru intintazñinacaqui. Imazi ninacz̈ kuznacatac̈ha zizñi. ");
INSERT INTO capNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nekztanaqui pajk kota kajkz̈cuqui Genesaret cjita yokquiz irantichic̈ha. Nekztan walsa kjaz kot atquiz mokz̈cu ecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Walsiquiztan ulnan z̈oñinacaqui Jesusa pajchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jalla nekztanac nii z̈oñinacaqui tjapa kjutñi ojkchic̈ha, laanaca zjijczjapa. Jakziquint Jesusa z̈elatc̈haja, nicju laa z̈oñinaca zjijcchic̈ha zquitquiz callz̈cu. ");
INSERT INTO capNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jochiran kolta watjaran pajk watjaran ojklayatc̈ha Jesusaqui. Jakziquint ojklayatc̈haja, nekzi laa z̈oñinaca zjijcñipankaztac̈ha. Niz̈aza z̈oñinacaqui Jesusa rocchic̈ha, laa z̈oñinaca Jesusiz̈ zquiti lanznajo. Jesusiz̈ zquiti lanzñinacaqui z̈ejtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nekztanaqui fariseo z̈oñinacaqui Jesusiz̈quiz macjatchic̈ha, tsjii kjaz̈t judiuz̈ lii tjaajiñinacz̈tan Jerusalenquiztan tjonchi. Jakziquin Jesusa z̈elatc̈haja, jalla nicju ajcsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Niz̈aza nekzi Jesusiz̈ tjaajinta z̈oñinacaqui c̈hjeri lulatc̈ha, kjara awjz costumbre ana paaz̈cu. Nuz̈ ana kjara awjz̈cu lulan, cherchic̈ha parti z̈oñinacaqui. Nekztan quintra chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Nii fariseo z̈oñinacaqui ana kjara awjz̈cu, wira ana lujlñitac̈ha. Parti judio z̈oñinacaqui niz̈tazakaztac̈ha. Jaziqui tuquita z̈oñinacz̈ costumbre nuz̈upan chjojñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Niz̈aza c̈hjeri kjayz̈cu ana kjara awjz costumbre paaz̈cu, ana wira lujlñipantac̈ha. Nuz̈upan ancha costumbre cumpliñinacatac̈ha. Wazunacami mazcanacami jir mazcanacami catrinacami niz̈tanaca ajunñipankaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Nuz̈ cjen nii fariseo z̈oñinacaqui judiuz̈ lii tjaajiñinacz̈tan Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan am tjaajintanacaqui tuquita costumbre ana cumplejo? Ana kjara ajwz̈cu lujl-la. ");
INSERT INTO capNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Anazum kuzziz z̈oñinacc̈hucc̈ha anc̈hucqui. Ultim werara anc̈huca puntuquiztan chiichic̈ha tuquita Isaías cjita z̈oñiqui. Tuz̈ cjican cjijrtkalc̈ha: “Tii z̈oñinacaqui tawkz̈tankaz Yooz rispitc̈ha; juntuñkazza. Ultimu kuzquiz ana Yooz rispitc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Inapankaz Yooz sirwic̈ha tii z̈oñinacaqui. Tinacaqui z̈oñz̈ taku tjaajiñic̈ha, ‘Tiic̈ha Yooz takuqui’, cjican”. —Nuz̈ cjijrtkalc̈ha Isaías cjita z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jesusaqui cjichizakazza: —Niz̈tapan anc̈hucqui Yooziz̈ mantita ana cumpliñc̈hucc̈ha. Z̈oñz̈ cuzturumpi cumpliñc̈hucpankazza. Mazcanacami wazunacami ajunz niz̈ta costumbrenaca cumpliñc̈hucpankazza. ");
INSERT INTO capNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Anc̈hucqui Yooziz̈ mantita tjatanc̈ha. Anc̈huca costumbrekaz tucquin utc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tuquita Moisés cjita z̈oñiqui chiiz̈inchic̈ha: “Am maa ejp rispita. Niz̈aza jakziltami niiz̈ maa ejpz̈ quintra chjaawjkatac̈haja, jalla niiqui, contaj cjila”. Nuz̈ mantichic̈ha Moisesaqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anc̈huczti tuz̈ cjiñc̈hucc̈ha: “Jakzilta z̈oñit niiz̈ maa ejpz̈quiz chiyasac̈ha, tuz̈ cjican, ‘Wejrqui amquiz anal yanapi atasac̈ha. Tjapa wejt cusasanaca, Yoozquiz tjaatac̈ha’. ");
INSERT INTO capNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Nuz̈ chiyac̈haj niiqui, maa ejp yanapz anaz̈ waquisic̈ha”. Nuz̈ cjiñc̈hucc̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Niz̈tiquiztan anc̈huca costumbre ana tjatzñiz̈ cjen, Yooz mantitaqui tjatz̈a. Jalla niz̈ta paayiñc̈hucpankazza anc̈hucqui. —Nuz̈ chiiz̈inchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nekztanaqui Jesusaqui wilta z̈oñinaca kjawzic̈ha, tuz̈ cjican: —Anc̈hucqui, tjappacha nonz̈na. Wejt taku intintazñi cjee. ");
INSERT INTO capNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Anaz̈ zawnctan kjuylchuc luzñiqui uj cjesac̈ha z̈oñz̈quiziqui. Z̈oñz̈ kuzquiztan ulanñi niiz̈ uj cjesac̈ha z̈oñz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jakziltaz̈laj nonzñi cjuñchiz niiqui, nonz̈la. ");
INSERT INTO capNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nekztanac Jesusac z̈oñinaca eccu kjuya ojkchic̈ha. Kjuya luzcu niiz̈ tjaajintanacaqui Jesusiz̈quiz nii ana intintazta takunaca pewczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jalla nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿Anc̈hucqui niz̈tazakaz anaz̈ naazya? ¿Anapanz̈ intintiya? Tuz̈uc̈ha niiqui. Anac̈ha zawnctan kjuylchuc luzñiqui uj cjesac̈ha z̈oñz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nii lujltaqui kuzquiz ana luzasac̈ha; pjuchquizpanz̈ luzza. Nekztan pjuchquiztan wir kjutñi ulanc̈ha zawncchuc. Jalla niz̈tiquiztan c̈hjul c̈hjeripankaz lulasac̈ha z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nekztan cjichizakazza: —Kuzquiztan ulanñi niiz̈ uj cjesac̈ha z̈oñz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Z̈oñz̈ kuzquiztan tiz̈ta ana walinaca ulanc̈ha: anawali pinsiz, adulteriuquiz ojklayz, yekja maatakz̈tan z̈ejlz, z̈oñi conz, ");
INSERT INTO capNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","tjañi cjis, wali jiru cjis pecz, uj paaz, incallz, anawali kamañchiz cjis, c̈hjultaki zmaz, anazum takunaca joojooz, mita cjis, anazum kuzziz cjis. ");
INSERT INTO capNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Niz̈tanaca kuzquiztan ulanc̈ha. Jalla niz̈tanaca uj cjesac̈ha z̈oñz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nekztanaqui Jesusaqui tsijtsic̈ha. Jakziquin Tiro Sidón cjita watjanaca z̈ejlc̈haja, nijcchuc ojkchic̈ha. Nicju tsjii kjuyquiz alujassic̈ha. Ana z̈oñiz̈ pajta kamz pecatc̈ha. Pero ana pajta kamzqui anapantaz̈ atchuca. ");
INSERT INTO capNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Jesusiz̈ tjonta zizcu nii orapacha tsjaa z̈onqui Jesusiz̈ yujcquiz quillzlaki macjatz̈quichinc̈ha. Naaz̈a uzqui zajraz̈ tantatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Sirofenicia cjita yokchiz z̈ontac̈ha naaqui. Grecia cjita taku chiyiñtac̈ha. Jaziqui naa z̈onqui Jesusa rocchinc̈ha: —Wejt uzaquiztan zajra chjatkatz̈inalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Nekztan Jesusaqui kjaazic̈ha: —Primiru maatinaca c̈hjeri chjeki lujlsa. Maatinacz̈ c̈hjeriqui kjañz̈cu pawcz̈quin tjojtanz anaz̈ waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Naaqui kjaazinc̈ha, tuz̈ cjican: —Nuz̈upanzac̈ha. Weraram chiic̈ha. Pero pacunacami mis koztan ocjalz̈ tajwkta c̈hjerinaca lujlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nekztanac Jesusac chiichic̈ha: —Amiz̈ zuma chiitiquiztan zajraqui ulanskatchinc̈ha am uzaquiztanaqui. Jaziqui am kjuya quepa. ");
INSERT INTO capNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nekztanaqui kjuya quejpchinc̈ha naa z̈onqui. Nii kjuyquin naaz̈a uz ajpsquiz z̈elanami, zajraqui chekapanz̈ ulantkalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nekztan Jesusaqui Tiro cjita yokquiztan quejpz̈quichic̈ha. Sidón cjita watja, Decápolis cjita yoka watz̈cu Galilea cjita kot ataran ojklaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nicju tsjii oñ z̈oñi Jesusiz̈quiz zjijctatac̈ha. Cjacja chiiñizakaztac̈ha. Nekztan z̈oñinacaqui Jesusiz̈quiz rocatc̈ha: —Am kjarz̈tan tii z̈oñi lanz̈inalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nekztanaqui Jesusaqui nii z̈oñi chjitchic̈ha tsjii latu. Nekztan nii oñ z̈oñz̈ cjuñquiz loc'anz̈tan c̈hjapzic̈ha. Nekztan llawsiz̈tan tjujtz̈cu nii z̈oñz̈ las lanzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Niz̈aza Jesusaqui tsewcchuc cherz̈cu: —Aayj, —cjican llactazzic̈ha. Nekztan chiichic̈ha, —Efata, —cjican. Nii tsjemat taku cjic̈ha, “Cjetzi cjee”, nii. ");
INSERT INTO capNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nekztanac nii z̈oñz̈ cjuñinacaqui cjetzi cjissic̈ha. Niiz̈ lasqui z̈ejtchizakazza. Cusa chiiñi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nekztanaqui Jesusaqui mantichic̈ha, tuz̈ cjican: —Tii anam jecz̈quizimi maznaquic̈ha. Nekztanaqui z̈oñinacaqui nii taku ana cassic̈ha. Nekztan Jesusaqui juc'anti ana chiychiyajo mantichic̈ha. Nekztan nii z̈oñinacazti juc'anti mazmazzic̈ha tjapa kjutñi. ");
INSERT INTO capNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jaziqui walja ispantichic̈ha nonzñi z̈oñinacaqui, tuz̈ cjican: —Tjapa niiz̈ paatanacaqui ancha zumac̈ha. oñ z̈oñimi nonskatñic̈ha. Up z̈oñimi chiikatñic̈ha. Ancha cusac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tsjii nooj muzpa z̈oñinacaqui wilta ajcsic̈ha. C̈hjeri miranzcama z̈ejlchic̈ha. Nekztan Jesusaqui niiz̈ tjaajintanaca kjawz̈cu, ninacz̈quiz paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—C̈hjep maj tii z̈oñinacaqui wejttan kamchic̈ha. Jaziqui tinacaqui ana c̈hjerchizza. Tinacz̈quiz okz̈nuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ana c̈hjeri tjaaz̈cu kjuya cuchnasaz̈ niiqui, jiczquiz c̈hjerz̈ kjara tismayasac̈ha. Yekjap z̈oñinacaqui az̈quiztan tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jesusiz̈ tjaajintanacaqui kjaazic̈ha: —Wazquizza uc̈humqui; anaz̈ c̈hjulumi z̈ejlc̈ha tekziqui. ¿C̈hjul c̈hjeri tii z̈oñinacz̈quiz tjaasajo, wejrnacjo? ");
INSERT INTO capNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha: —¿Kjaz̈ t'antat anc̈hucalta z̈ejlya? Tjaajintanacaqui kjaazic̈ha: —Pakallaku. ");
INSERT INTO capNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jaziqui Jesusaqui nii z̈oñinacz̈quiz chiichic̈ha: —Anc̈hucqui, yokquiz julzna. Nekztanaqui t'anta tanz̈cu Yooz Ejpz̈quin gracias cjican chiichic̈ha. Nekztan t'anta kjolkjolz̈cu, niiz̈ tjaajintanacz̈quiz tjaachic̈ha, z̈oñinacz̈quiz tojznajo. Nekztan partir paychic̈ha tjaajinta z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nii tjaajintanacaqui tsjii kjaz̈ chi'iznacchiztac̈ha. Nii tanz̈cu Jesusaqui wilta Yooz Ejpz̈quin gracias cjican chiichic̈ha. Nekztan tjaajintanacz̈quiz chiichic̈ha: —Tii z̈oñinacz̈quiz tii ch'iznaca tojzna, anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nii z̈oñinacaqui lujlchic̈ha, chjekañcama. Nekztan z̈ejtchi c̈hjerinaca tjappacha juntiz̈cu, pakallaku canasta chjijpsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nii lujlñi z̈oñinacaqui tsjii pusi warankatac̈ha. Nekztan Jesusaqui z̈oñinaca cuchanchic̈ha, kjuya okajo. ");
INSERT INTO capNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jesusaqui tjaajintanacz̈tan walsiquiz luzcu, Dalmanuta cjita yokquin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Fariseo z̈oñinacaqui tjonz̈cu, Jesusiz̈quiz ch'ayi kallantichic̈ha, tuz̈ cjican: —Amqui Yooztamc̈halaj niiqui, milajru tekz paalla niz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nekztan Jesusaqui walja llactazcan ujrsic̈ha. Nekztan chiichic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan milajrukaz pecjo? ¿Tii z̈oñinacajo? Weraral cjiwc̈ha, milajru ana paasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nii z̈oñinaca eccu, walsiquiz luzcu, ojkchic̈ha, wilta kot nawjktuñtan kajkzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jesusiz̈ tjaajintanacaqui t'anta chjitz tjatsic̈ha. Tsjii t'antakaz z̈elatc̈ha walsiquiz. ");
INSERT INTO capNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nekztan Jesusaqui ninacz̈quiz chiiz̈inchic̈ha: —Cwitazaquic̈ha fariseoz̈ liwaturz̈quiztan niz̈aza Herodiz̈ liwaturz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nekztan nii tjaajinta z̈oñinacaqui Jesusiz̈ chiiz̈intiquiztan palt'ichic̈ha, tuz̈ cjican: —Uc̈humqui ana t'anta zjijctala. ¿Kjaz̈ cjeequejo? ");
INSERT INTO capNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Nekztan ninacaz̈ nuz̈ parlan, Jesusaqui pewczic̈ha: —¿Kjaz̈tiquiztan t'antiquiztan parli anc̈hucjo? ¿Anapanz̈ intintiy? ¿Kjaz̈tat anc̈hucjo? ¿Anc̈huca kuzqui ana naazñipan, kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Anc̈huca c̈hjujquiqui anaj cherchiya? ¿Anc̈huca cjuñimi anaj nonziya? ¿Tii anapanz̈ cjuñkaya? ");
INSERT INTO capNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Wejrqui pjijska t'antiz̈tan pjijska warank luctak z̈oñinaca lulunchinc̈ha. ¿Nekztan kjaz̈ canastat nii z̈ejtchi t'anta ricujtatajo? Ninacaqui kjaazic̈ha: —Tuncapani. ");
INSERT INTO capNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Nekztan Jesusaqui pewczizakazza: —Wejrqui pakallaku t'antiz̈tan pusi warank z̈oñi lulunchinc̈ha. ¿Nekztan kjaz̈ canastat nii z̈ejtchi t'anta ricujtatajo? Ninacaqui kjaazic̈ha: —Pakallaku. ");
INSERT INTO capNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nekztan Jesusaqui pewczizakazza: —¿Anapanz̈ zuma intintas, anc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nekztan Betsaida cjita yokquin irantichic̈ha. Nekzi tsjii kjaz̈u z̈oñinacaqui Jesusiz̈quiz tsjii zur z̈oñi zjijcchic̈ha. Zjijcz̈cu rocchic̈ha: —Tii lanz̈inalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nekztan Jesusaqui nii zur z̈oñz̈ kjarcu tanz̈cu, wajtz̈ tjiya chjitchic̈ha. Nekztan niiz̈ c̈hjujcquiz llawsiz̈tan t'awzic̈ha. Kjarz̈tan lanz̈cu pewczic̈ha: —¿Jaziqui c̈hjultakinacam cherya? ");
INSERT INTO capNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Zur z̈oñiqui acha waytiz̈cu chercherzic̈ha. Nekztan kjaazic̈ha: —Z̈oñi cherchucac̈ha, ojklayñi. Pero ana cusal cheruc̈ha; muntinacaz̈takaz nii z̈oñinaca cheruc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesusaqui nii z̈oñz̈ c̈hjujcquiz wilta kjarz̈tan lanzic̈ha, zuma cherajo. Nekztan niiz̈ c̈hjujqui zuma z̈ejtchic̈ha. Nii z̈oñiqui zuma calaru cherchic̈ha az̈kquin. ");
INSERT INTO capNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesusaqui c̈hjetinz̈cu niiz̈ kjuya cuchanchic̈ha, tuz̈ cjican: —Anam wajtquiz luzaquic̈ha. Anaz̈ jecz̈quizimi tii c̈hjetinta chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nekztan Jesusaqui tjaajintanacz̈tan ojkchic̈ha, Cesarea de Filipo cjita yok kjutñi. Ojkcan Jesusaqui pewczic̈ha: —¿Ject wejrjo? ¿Kjaz̈t cjii z̈oñinaca wejt puntuquiztanajo? ");
INSERT INTO capNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Niiz̈ tjaajinta z̈oñinacaqui kjaazic̈ha: —Yekjap z̈oñinaca, “Juan Bautistala”, cjic̈ha. Yekjapac, “Eliasla”, cjic̈ha. Yekjapac, “Tsjii Yooz taku parliñi profetala”, cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nekztan Jesusaqui pewczic̈ha: —¿Anc̈huczti, jaknuz̈ cjii wejt puntuquiztanajo? Pedruqui kjaazic̈ha: —Yooziz̈ cuchanz̈quita Cristumc̈ha amqui, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nekztan Jesusaqui mantichic̈ha: —Anaz̈ jecz̈quizimi nii maznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nekztan niiz̈ tjaajinta z̈oñinacz̈quiz wilta tjaajñi kallantichic̈ha, tuz̈ cjican: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jaziqui ancha t'akjisac̈ha. Wajt jilirinacami timlu jilirinacami judio tjaajiñinacami, ninacaqui wejtquiz chjaawjkataquic̈ha. Wejrqui contal cjeec̈ha. Nekztan c̈hjep majquiztan jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jesusaqui nuz̈ kjanacama niiz̈ ticz mazinchic̈ha. Tii mazintiquiztan Pedruqui tsjii latu Jesusa chjitchic̈ha. Nekztan paljaychic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan niz̈ta chiijo? Anapan niz̈ta chiyalla amqui. ");
INSERT INTO capNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesusaqui wir kjutñi parti tjaajinta z̈oñinacz̈quin cherzic̈ha. Nekztan Jesusaqui Pedro ujzic̈ha, tuz̈ cjican: —Satanás, zaraka wejt yujcquiztan. Amiz̈ pinsita anac̈ha Yooziz̈ pinsita, z̈oñiz̈ pinsitakazza. ");
INSERT INTO capNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nekztan Jesusaqui nekz z̈ejlñi z̈oñinaca kjawz̈cu, chiiz̈inchic̈ha, tuz̈ cjican: —Jequit wejttan chica ojklayz pecc̈haj niiqui, primiraqui persun kamañ wiraqui tjatz̈la. Sufrisjapaqui listoj cjila, ticzcama. Nekztan wejttan chicaz̈ kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jakziltat persun kamañ wira ana tjatz pecc̈haj niiqui, arajpach kamañaqui ana tjaataz̈ cjequic̈ha. Jakziltat tii muntuquiz Yooz tawk laycu niz̈aza wejt laycu persun kamañ wira tjatznac̈haja, jalla niiqui arajpachquin wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tsjii z̈oñiqui tjapa tii muntuquiz z̈ejlñi cusasanaca canasac̈ha. Pero nekztan infiernuquin okaquiz̈ niiqui, tjapa nii canta cusasanaca, ¿c̈hjuljapat sirwasajo? Inakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Arajpachquin Yooztan kamzqui persun liwriizqui anaz̈ paaztanac kjayasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Wejrqui cjiwc̈ha, tii muntuquiz z̈oñinaca z̈ejlc̈ha, ana Yooz kuzcama ojklayñi, persun kuzcama ojklayñi, ujchizza. Nii z̈oñinacz̈tan z̈elan, jakziltat wejtquiztan niz̈aza wejt tawkquiztan asac̈haja, niz̈aza ana pajñi chiyac̈haj niiqui, jalla niiz̈quiztan wejrzal ana pajñi chiyac̈ha. Tsjii nooj wejrqui wejt Ejpz̈ aztan tjonac̈ha zuma arajpach Yooz anjilanacz̈tan. Nii ora wejtquiztan asñi ana pajñi z̈oñinacz̈quiztanaqui wejrzal ana pajñi chiyac̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesusaqui cjichizakazza: —Ultimu werara wejr cjiwc̈ha, tsjii nooj Yoozqui aztan mantaquic̈ha. Ima nii tjuñi tjonan yekjap tekzta z̈oñinacaqui anaz̈ ticznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Sojta tjuñquiztan Jesusaqui c̈hjepultan tjaajinta z̈oñinaca chjitchic̈ha, Pedro, Jacobo, Juan, jalla ninacz̈tan. Pakpaltan tsjii curu yawchic̈ha. Nicju nii c̈hjepultanz̈ yujcquiz Jesusaqui tsjemat chercherchiz̈ cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Niiz̈ zquitiqui ancha llijatc̈ha. Ancha chiw kjatñiz̈takaztac̈ha. Anaz̈ jec z̈oñimi niz̈ta chiwi zquiti cjiskati atc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nekztan pucultan z̈oñinaca jecz̈quichic̈ha; Elías niz̈aza Moisés cjitatac̈ha ninacaqui. Jesusiz̈tan parlichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Nekztan Pedruqui Jesusiz̈quiz paljaychic̈ha: —Wejt Tjaajiñi. Walikazza tekz z̈ejlzqui. C̈hjep chjujlli kjuya kjuyznasac̈ha, tsjiiqui amta tsjiiqui Moisesta, tsjiiqui Eliasta. ");
INSERT INTO capNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Nekztan nii tjaajinta z̈oñinacaqui ancha tsucchic̈ha. Pedruqui c̈hjulut chiyi ana zuma tantiichucatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","8","Nekztan ninacz̈quiz tsjiriqui urpuntichic̈ha. tsewctan tsjirquiztan tsjii joraqui chiiz̈quichic̈ha: —Wejt k'ay Majchc̈ha tiiqui. Tiiz̈quiz nonz̈na. Nekztan tjaajinta z̈oñinacaqui tjapa kjutñi chercherzic̈ha. Anazaka c̈hjulumi tjenchic̈ha. Jesusapankaz z̈elatc̈ha nii chjepultan z̈oñinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jesusaqui nii curquiztan chjijwz̈quican ninacz̈quiz paljaychic̈ha, tuz̈ cjican: —Anc̈hucaz̈ cherta ana jecz̈quizimi chiichiyaquic̈ha. Weriz̈ jacatattan, nekztan chiichiyaquic̈ha anc̈hucqui. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ninacpora pewcsarassic̈ha: —¿C̈hjulut tii jacatatz puntu cjeejo? Niz̈tami Jesusiz̈ chiitacama ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nekztan Jesusiz̈quiz pewczic̈ha: —Judiuz̈ lii tjaajiñinacaqui cjiñic̈ha, “Primiruqui Elías profetaqui tjonstanc̈ha”, nii. ¿Kjaz̈tiquiztan niz̈ta chiiya? ");
INSERT INTO capNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Ultimupan Elías profetaqui primiru tjonchic̈ha, tjappacha tjaczjapa. Niz̈aza cjijrta Yooz takuqui tuz̈ cjic̈ha, wejr tsewctan cuchanz̈quita Yooz Z̈oñz̈ puntuquiztan. Tekziqui ancha sufrac̈ha wejrqui. C̈hjaawjtaza iñartaza cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jaziqui wejr cjiwc̈ha, Eliasaqui tjonchila. Nekztan z̈oñinacaqui Elías ninacz̈ munañparu paachic̈ha. Nuz̈upan cjijrta Yooz takuqui cjic̈ha Elías puntuquiztan. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nekztan parti tjaajinta z̈oñinacz̈quiz irantichic̈ha. Nekzi muzpa z̈oñinacaqui z̈elatkalc̈ha. Parti tjaajintanacz̈tan judiuz̈ lii tjaajiñinacz̈tan ch'aazatkalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tjappacha Jesusa cherz̈cu ispanti ch'uj cjichic̈ha. Nekztan tsaani zajtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesusaqui pewczic̈ha, tuz̈ cjican: ¿Ninacz̈tan c̈hjulut chiyas? ");
INSERT INTO capNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tsjii z̈oñiqui kjaazic̈ha: —Tjaajiñi Maestro, wejrqui wejt uza amquiz zjijcchinc̈ha. Zajraz̈ luztan, upa cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Jakziquinami zajraqui wejt uzquiz pankaz luzza. Nekztan t'uckatc̈ha. Nekztan yokquiz tjojtsa. Atquiztan c̈h'utukaz̈ jup'okic̈ha. Iz̈kekaz̈ jojc̈ha. Ljajtikaz̈ cjissa. Jaziqui amiz̈ tjaajintanacz̈quiz rocchinc̈ha, zajra chjatkatajo. Ninacaqui ana chjatkati atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jaziqui Jesusaqui kjaazic̈ha: —Anc̈hucqui, ana criiñi z̈oñinacc̈hucpanc̈ha. ¿C̈hjuloracamat anc̈hucatan kamac wejrjo? ¿C̈juloracamat anc̈hucatan awantac wejrjo? Niz̈tac nii uza zjijcz̈ca. ");
INSERT INTO capNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nekztan nii uzac zjijctatac̈ha. Nii zajraqui Jesusa cherz̈cu uza t'uckatchic̈ha. Nekztan nii uzaqui yokquiz tjojtsic̈ha. Yokquizpacha zunt'ichic̈ha, atquiztan c̈h'utu jup'okcan. ");
INSERT INTO capNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesusaqui ejpz̈quiz pewczic̈ha: —¿C̈hjuloratanpacha am uza laacjichitajo? Niiz̈ ejpqui kjaazic̈ha: —Koltallquiztanpacha. ");
INSERT INTO capNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Tii zajrapan wilta wilta tjojt tjojtskatc̈hani ujquizimi kjazquizimi ticskatzjapaqui. Am cunam atc̈hani. Tii kullz̈inalla. Okz̈nalla wejrnacqui. ");
INSERT INTO capNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nekztan Jesusaqui nii ejpz̈quiz chiichic̈ha: —¿Kjaz̈tiquiztan am nuz̈ cjeejo, “Am cunam atc̈han”, cjicanajo? Yoozquin tjapa kuzziz z̈oñiqui c̈hjulumipankaz atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nii uz ejpqui altu jorz̈tan chiichic̈ha: —¡Tjapa kuzziz wejrqui! ¡Juc'anti Yoozquin kuzziz cjis yanapt'alla! ");
INSERT INTO capNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesusaqui naychic̈ha, muzpa z̈oñinaca ajcsquiñi. Nekztan zajra ujzic̈ha, tuz̈ cjican: —Zajra, amqui tii uza upa oñi cjiskatchamc̈ha. Wejrqui am mantuc̈ha. Tiiz̈quiztan ulna. Anam iya tii uza tanaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nii zajraqui uza wilta t'uckatchic̈ha. Nekztan ancha kjawcan, ulanchic̈ha. Nii uza ticziz̈takaz cjissic̈ha. Nekztan jila parti z̈oñinacaqui chiichic̈ha: —¡Ticzila tii uzaqui! ");
INSERT INTO capNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nekztan Jesusac kjarallcu tanz̈cu z̈inzic̈ha. Nekztan nii uzaqui tsijtsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nekztanac tjaajinta z̈oñinacaqui kjuy luzcu jamazit Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan wejrnacqui ana nii zajra chjatkati atojo? ");
INSERT INTO capNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesusaqui kjaazic̈ha: —Ana Yooztan parliscu ana ayunascu, anaz̈ tii zajranacaqui chjatkati atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈tan ojkchic̈ha Galilea yoka nuz̈. Ana z̈oñiz̈ zizan nekz z̈ejlz pecatc̈ha, niiz̈ tjaajinta z̈oñinacz̈quiz iya tjaajinzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Tuz̈ cjican tjaajinchic̈ha: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tsjii z̈oñiqui wejr tarazunaz̈ paaquic̈ha, wejr tankatzjapa. Nekztan tantapal cjeec̈ha. Contal cjeec̈ha. Nekztan c̈hjep majquiztan jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tjaajintanacaqui Jesusiz̈ takunaca ana cusa intintazi atchic̈ha. Niz̈aza Jesusa iya pewcz eksic̈ha: —¿Kjaz̈t cjiy, nii am takunacajo? —Nuz̈ cjican, pewcz pecatc̈ha, pero. ");
INSERT INTO capNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nekztan Capernaum cjita wajta irantichic̈ha. Kjuyquiz luzcu Jesusaqui niiz̈ tjaajintanaca pewczic̈ha: —¿Ojkcan anc̈huc c̈hjuluc̈ha parliya? ");
INSERT INTO capNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nekztan anaz̈ c̈hjulumi kjaazic̈ha. Ojkcan tii puntu parlatc̈ha, “¿Ject tucquinaqui cjes?” cjican. ");
INSERT INTO capNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nekztan Jesusaqui julzic̈ha. Niiz̈ tuncapan tjaajinta z̈oñinaca kjawz̈cu, paljaychic̈ha: —Jakziltat tucquinac cjis pecc̈haj niiqui, wirquinpankaz cjis waquizic̈ha. Mantapaazpankaz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesusac tsjii uza kjawz̈cu, taypiquiz tsijtskatchic̈ha. Nii uza z̈cojrzic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Jakzilta z̈oñit wejt laycu tsjii ocjala sirwic̈haja, jalla niiqui wejr sirwic̈ha. Niz̈aza anaz̈ wejr alaja sirwic̈ha; wejrz̈ cuchanz̈quiñi nii zakaz sirwic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nekztan Juanqui cjichic̈ha: —Tjaajiñi, am tjuuz̈tan tsjii z̈oñiqui zajranaca chjatkatatc̈ha. Niiqui ana uc̈humtan chica ojklayñic̈ha. Nekztan wejrnacqui ujzinc̈ha, “Niz̈ta anac̈ha paazqui”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesusaqui cjichic̈ha: —Ana niz̈ta chiya. Jakzilta z̈oñit wejt tjuuz̈tan tsjii milajru paac̈haj niiqui, wejt quintra ana pjazila chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Jakzilta z̈oñiz̈laja ana uc̈hum quintra niiqui, uc̈humnaca partizakazza. ");
INSERT INTO capNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Weraral chiyuc̈ha, anc̈hucqui Cristuz̈ illzta z̈oñinacpanc̈hucc̈ha. Jakzilta z̈oñit weriz̈ cjen anc̈hucaquiz tsjii kjazllami onanc̈haja, jalla niiqui nekztan ultimu juc'ant zumanaca tanznaquic̈ha arajpachquin. ");
INSERT INTO capNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Nekztan Jesusaqui tjaajinchic̈ha, tuz̈ cjican: —Wejtquiz criichi z̈oñinaca z̈ejlc̈ha, humilde kuzziz cjiñi. Jakzilta z̈oñit niz̈ta criichi z̈oñinaca ujquiz tjojtskatac̈haja, jalla niiqui ana wali paac̈ha. Nii paañi z̈oñz̈ jorquiz pajk tjaaj mokz̈cu, koz kotquiz jacuntiz waquizic̈ha. Jalla niz̈ta tsjan cusaz̈ cjesac̈ha nii z̈oñz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Am kjarat ujquiz tjojtskatz pecc̈haj niiqui, pootzna. Infiernuquin pizc kjarchiz ojkzqui, nii ana waliz̈ cjesac̈ha. Juc'anti cusaz̈ cjesac̈ha tsjii kjarchizkaz arajpachquin luzqui. Infiernuquin ujqui wira ana tjesnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Infiernuquiziqui z̈oñi lujlñi lak'unacami anaz̈ ticznaquic̈ha. Nii asñi ujqui anaz̈ wira tjesnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Niz̈aza am kjojchat ujquiz tjojtskatz pecc̈haj niquii, pootzna. Infiernuquin pizc kjojchchiz Yooz cuchnasaz̈ niiqui, ana waliz̈ cjesac̈ha. Juc'anti cusaz̈ cjesac̈ha tsjii kjojchchizkaz arajpachquin ojkzqui. Infiernuquin ujqui wira ana tjesnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Infiernuquiziqui z̈oñi lujlñi lak'unacami anaz̈ ticznaquic̈ha. Nii asñi ujqui ana wira tjesnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Am c̈hjujquit ujquiz tjojtskatz pecc̈haj niiqui, leczna. Infiernuquin pizc c̈hjujcchiz Yooz cuchnasaz̈ niiqui, ana waliz̈ cjesac̈ha. Juc'anti cusaz̈ cjesac̈ha tsjii c̈hjujcchizkaz arajpachquin ojkzqui. ");
INSERT INTO capNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Infiernuquiziqui z̈oñi lujlñi lak'unacami anaz̈ ticznaquic̈ha. Nii asñi ujqui ana wira tjesnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‛Tjapa z̈oñinacaqui ujz̈tan tjacz̈taz̈ cjequic̈ha. Zapa wilananacaqui yawcz̈tan tjacz̈tapanc̈ha, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yacuqui zumac̈ha. ¿Yacuz̈ lak'anznasaz̈ niiqui, kjaz̈t wilta ch'uyi cjisnasa? Yawcchizpanz̈ anc̈huc z̈elaquic̈ha. Porapat zumaz̈ kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nekztan Jesusaqui Capernaum wajtquiztan ulanz̈cu, Judea yokquin ojkchic̈ha; niz̈aza Jordán cjita pujz̈ najwctuñtan ojkchic̈ha. Nicju muzpa z̈oñinacaqui wilta ajcsic̈ha. Nekztan Jesusaqui wilta tjaajinchic̈ha, jaknuz̈t tjaajiñitaz̈laj, nii. ");
INSERT INTO capNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fariseo z̈oñinacaqui tjonchic̈ha, Jesusa ujquiz tjojtskatzjapa. Nekztan pewczic̈ha, tuz̈ cjican: —¿Uc̈hum liiqui kjaz̈t cjeejo? ¿Tsjii luctakaqui persun tjunatan jaljtiz waquizasaya? Tjaajnalla. ");
INSERT INTO capNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesusaqui ninacz̈quiz pewczic̈ha: —¿Moisés cjita z̈oñiqui, jaknuz̈t anc̈hucaquiz mantichiya? ");
INSERT INTO capNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nekztan ninacaqui kjaazic̈ha: —Moisesaqui tuz̈ mantichic̈ha, “Tsjii luctakaqui certificado de divorcio tjaasac̈ha tjunatan jaljtizjapa. Nekztan jaljtasac̈ha.” ");
INSERT INTO capNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nekztanaqui Jesusaqui chiiz̈inchic̈ha: —Anc̈huca chojru kuzziz cjen nuz̈ mantitatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Niiz̈ tuquiqui ana niz̈ta mantitatac̈ha. Tuqui timpuqui Yoozqui tjappacha paacan, z̈oñi paachic̈ha luctaka maataka. ");
INSERT INTO capNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Niz̈tiquiztan z̈oñiqui maa ejpz̈quiztan zarakaquic̈ha, tjunatan kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Nekztan nii lucutiñi z̈oñiqui tsjiikaz cjissa”. Anaz̈ iya pucultan z̈oñi, pero tsjiikazza. ");
INSERT INTO capNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Yoozqui tsjii lucutiñi cjiskatchic̈ha. Nekztan lucutiñi z̈oñiqui anapan jaljtiz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wiruñaqui niiz̈ tjaajinta z̈oñinacaqui kjuyquiz Jesusa jamazit pewczic̈ha nii jaljtiz puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesusaqui kjaazic̈ha: —Jakzilta z̈oñit tjunatan jaljtiz̈cu yekja maatakatan zalz̈aj niiqui, ujz̈ paac̈ha, tuquita tjuna quintra. ");
INSERT INTO capNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Niz̈aza jakzilta z̈ont persun luctakz̈tan jaljtiz̈cu, yejka luctakz̈tan zalz̈aj niiqui, ujzakaz paac̈ha, tuquita lucz̈ quintra. ");
INSERT INTO capNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsjii nooj z̈oñinacaqui Jesusiz̈quin ocjalanaca zjijcchic̈ha, kjarz̈tan lanznajo. Nuz̈ zjijcan Jesusiz̈ tjaajintanacaqui nii ocjala chjaawjchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Niz̈ta chjaawjñi nayz̈cu Jesusaqui z̈awjchic̈ha. Nekztan tjaajinta z̈oñinacz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Tii ocjalanacaqui wejtquiz tjonaj cjee. Anaz̈ chjaajwa. Tii ocjalanacz̈ kuzziz irata, jalla niz̈ta z̈oñinacac̈ha Yooz wajtchiz z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ultim weraral chiyuc̈ha, ocjalanacaqui maa ejpz̈ mantitanaca cazza. Jalla niz̈ta irata z̈oñinacaqui Yooz mantitanaca caz waquizic̈ha. Ana cazaquiz̈ niiqui, wira ana Yooz wajtchiz z̈oñinaca cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nekztan Jesusaqui ocjalanaca z̈cojrz̈cu k'aachichic̈ha. Zapa mayniz̈quiz kjarz̈tan lanz̈cu: —Yooz am wintijla, —cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nekztanaqui z̈oñinacz̈quiztan Jesusaz̈ zaraktan tsjii z̈oñiqui zati pariju tjonchic̈ha, niiz̈ yujcquiz quillslaki. Nii z̈oñiqui cjichic̈ha: —Tjaajiñi Maestro, zumamz̈ amqui. Yooztan wiñaya kamzjapaqui, ¿c̈hjul zumanacat wejr paasaya? ");
INSERT INTO capNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesusaqui kjaazic̈ha: —¿Kjaz̈tiquiztan, “Zumamz̈ amqui”, cjeejo? Anaz̈ jec z̈oñimi zumaqui, Yoozpankazza zumaqui. ");
INSERT INTO capNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Amqui Yooz mantitanaca zizñamc̈ha: “Anac̈ha adulteriuquiz ojklayzqui. Anac̈ha conzqui. Anac̈ha tjañi cjisqui. Anac̈ha toscara chiizqui. Anac̈ha incallzqui. Am maa ejpc̈ha rispitzqui”. ");
INSERT INTO capNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Nii z̈oñiqui kjaazic̈ha: —Tjaajiñi Maestro, koltallquiztanpacha tjapa tinaca caziñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesusaqui nii z̈oñz̈ kjutñi cherzic̈ha, k'aachtican. Nekztan cjichic̈ha: —Tsjii cusasa pjaltic̈ha amtaqui. Tjappacha am c̈hjultaki z̈ejlñinaca tuyzna. Poris z̈oñinacz̈quiz nii paaz ona. Oka jaziqui. Nekztan am arajpachquin juc'anti ricachum cjequic̈ha. Nuz̈ paaz̈cu wejtquin tjona. Sufrisjapa listu cjee. Nekztan wejttan chica ojklayñi cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Walja ricachutac̈ha nii z̈oñiqui. Nekztan nii chiitiquiztan ancha upa kuz cjissic̈ha. Llaquita ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nekztan Jesusaqui tjapa kjutñi chercherzic̈ha. Nekztan tjaajintanacz̈quiz paljaychic̈ha, tuz̈ cjican: —¡Ricachunacz̈taqui walja ch'amac̈ha Yooz wajtchiz z̈oñinaca cjisqui! ");
INSERT INTO capNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Niiz̈ tjaajintanacaqui Jesusaz̈ chiitiquiztan ancha tsucchic̈ha. Nekztanaqui Jesusaqui wilta paljaychic̈ha, tuz̈ cjican: —Jilanaca. ¡Jakzilta z̈oñit tii wir cusasanacquiz kuz tjaac̈haja, jalla ninacz̈taqui walja ch'amac̈ha Yooz wajtchiz z̈oñinaca cjisqui! ");
INSERT INTO capNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tsjii camello cjita animala z̈ejlc̈ha. Nii camelluqui ch'aman acuj cjuñquiz luzasac̈ha. Ricachunacazti tsjan ch'aman Yooz wajtquiz luzasac̈ha, Yooz mantita z̈oñinaca cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nii chiitiquiztan tjaajinta z̈oñinacaqui juc'anti tsucchic̈ha. —¿Jequit liwriita cjesajo? —cjican, pewcsassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesusaqui ninacz̈quiz cherzic̈ha. Nekztanac cjichic̈ha: —Z̈oñiqui anaz̈ persunpacha liwrii atasac̈ha. Yoozpankazza liwriiñiqui. Yoozqui jecmi liwrii atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nekztan Pedruqui Jesusiz̈quiz paljaychic̈ha: —Nonz̈na. Wejrnacqui tjappacha ecchinc̈ha, amtan chica ojklayzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Nekztan Jesusaqui cjichic̈ha: —Weraral anc̈hucaquiz cjiwc̈ha. Jakzilta z̈oñit Yooz tawk laycu wejt laycu kjuya, jilanaca, cullacanaca, maa, ejp, maatinaca, zkalanaca, jalla ninaca ecac̈haj niiqui, ");
INSERT INTO capNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tii muntuquiz kjuyanaca, jilanaca, cullacanaca, maanaca, maatinaca, zkalanaca, niz̈tanaca patac wiltaz̈ ninacz̈tajapa z̈elaquic̈ha. Pero chjaawjta iñartazaz̈ cjequic̈ha. Jalla nuz̈ cjenami, arajpachquin wiñaya Yooztan zuma kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Walja anzic tucquin z̈oñinacaqui wirquin cjisnaquic̈ha ultimquiziqui. Niz̈aza walja anzic wirquin z̈oñinacaqui tucquin cjisnaquic̈ha ultimquiziqui. ");
INSERT INTO capNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nekztan Jesusaqui Jerusalén cjita wajtquin okatc̈ha tjaajintanacz̈tan. Jesusac̈ha ninacz̈ tuqui ojkchiqui. Nii tjaajinta z̈oñinacaqui tsucchi okatc̈ha. Nii parti apzñinacaqui ekscan okatc̈ha. Nekztanac Jesusac niiz̈ tuncapan tjaajintanaca kjawz̈cu, tsjii kjutñi chjitchic̈ha. Nekztan jaknuz̈t niiz̈quiz watac̈haja jalla nii mazinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jesusac cjichic̈ha: —Nonz̈na. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jerusalén watjaz̈ ojkc̈ha uc̈humqui. Jalla nii wajtquin tarazuna paatal cjeec̈ha. Timlu jilirinacz̈quiz niz̈aza judío tjaajiñinacz̈quiz tantal cjeec̈ha. Nekztan ninacaqui, “Ticz̈la tiiqui”, cjequic̈ha. Nekztan yekja wajtchiz z̈oñinacz̈quiz intirjital cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nekztan wejr munu paatal cjeec̈ha. Llawsiz̈tan tjujttal cjeec̈ha. Wjajttal cjeec̈ha. Ultimquiziqui contal cjeec̈ha. Nekztan ticz̈cuqui c̈hjep majquiztanac jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nekztanaqui Zebedeoz̈ majchnacaqui Jacobz̈tan Juanz̈tan Jesusiz̈quin macjatchic̈ha tuz̈ cjican: —Tjaajiñi Maestro, c̈hjulut amquiztan pecuc̈haj niiqui, tjaalla. ");
INSERT INTO capNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesusaqui pewczic̈ha: —¿C̈hjuluz̈ pecya? ");
INSERT INTO capNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nii pucultan z̈oñiqui kjaazic̈ha: C̈hjuloram am tjappacha mantac̈haj niiqui, wejrnac julskatalla, tsjiiqui z̈ew kjuttan, tsjiiqui zkar kjuttan. ");
INSERT INTO capNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Nekztan Jesusaqui cjichic̈ha: —Anc̈hucqui tii mayta ana intintichiñc̈hucc̈ha. Wejrqui tsjii wasu licznac̈ha. Niz̈aza tsjii bautismo bautista cjeec̈ha. ¿Jalla niz̈tapacha anc̈huc sufri atasajo? ");
INSERT INTO capNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ninacaqui kjaazic̈ha: —Atasac̈hay. Nekztan Jesusaqui cjichic̈ha: —Wejr irata anc̈hucqui tsjii wasu licznaquic̈ha. Niz̈aza tsjii bautismo bautista cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero z̈ewquiztan niz̈aza zkarquiztan julznaj cjic̈haj niiqui, wejr ana nii atasac̈ha. Jakziltiz̈taz̈laj nii julz tjacz̈ta niiqui, ninacz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nekztan nii parti tunca tjaajintanacaqui nuz̈ nonz̈cu, z̈awjchic̈ha Jacobuz̈ niz̈aza Juanz̈ kjutñi. ");
INSERT INTO capNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Nekztan Jesusaqui tjaajinta z̈oñinaca kjawzic̈ha, tuz̈ cjican: —Anc̈hucqui zizza. Tsjii nacionz̈ chawjc jiliriqui nacion nuz̈pachaz̈ cazkatc̈ha. Tsjii c'ari patrunaz̈takaz cjissa jilirinacaqui. Jilirinacaqui tjapa z̈oñinaca rispitskatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Anc̈huczti anac̈ha niz̈ta cjisqui. Jakziltat anc̈hucaquiztan juc'ant chekan z̈oñi cjis pecc̈haj niiqui, partinacz̈ piyuna cjis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Jakziltat anc̈hucaquiztan ancha tucquin cjis pecc̈haj niiqui, tjapa z̈oñinacz̈ mantuquizpanz̈ cjis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jalla niz̈tijapa wejr tjonchinc̈ha. Tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Pero ana z̈oñiz̈ sirwita cjisjapa tjonchinc̈ha. Antiz z̈oñinaca sirwisjapa tjonchinc̈ha. Z̈oñinacz̈ cuntiquiztan ticzjapami, z̈oñinaca liwriizjapami, niijapa tjonchinc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nekztan Jesusaqui Jericoquiztan ulanz̈quichic̈ha tjaajinta z̈oñinacz̈tanami tama z̈oñinacz̈tanami. Jicz latuquiz tsjii zur z̈oñi julzi z̈elatc̈ha, tomangz̈can. Bartimeo cjitatac̈ha, Timeoz̈ majch. ");
INSERT INTO capNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nii Nazaret wajtchiz Jesusa macjatz̈quiñi nayz̈cu, nii zur z̈oñiqui kjawchic̈ha, tuz̈ cjican: —¡Jesusa, Davidz̈ Majchimc̈ha! ¡Wejr okz̈nalla! ");
INSERT INTO capNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nekztan z̈oñinacaqui nii zur z̈oñi ujsic̈ha: —¡Ch'uj z̈ela! —cjican. Nekztan nii zur z̈oñiqui juc'anti kjawchic̈ha: —¡Davidz̈ Majch, wejrpanz̈ okz̈nalla! ");
INSERT INTO capNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nekztan Jesusaqui tsijtsic̈ha. —Nii z̈oñi kjawz̈ca, —cjichic̈ha. Z̈oñinacaqui nii zur z̈oñi kjawzic̈ha, tuz̈ cjican: —Tsijtsna. Zuti cjee. Jesusaz̈ am kjawz̈a. ");
INSERT INTO capNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Nekztan niiz̈ zquiti cujtz̈cu, tjojktichic̈ha. Jesusiz̈quin macjatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nekztan Jesusaqui nii z̈oñi pewczic̈ha: —¿C̈hjulum pecya? ¿Kjaz̈um wejr paljay-ya? Nii zur z̈oñiqui kjaazic̈ha: —Tjaajiñi Maestro, ancha zurtc̈ha wejrqui. Cherz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesusaqui cjichic̈ha: —Am tjapa kuztan cjen z̈ejtchamc̈ha. Jazic oka. Nii orapacha nii z̈oñz̈ c̈hjujquiqui cjetsic̈ha. Cherñi cjissic̈ha. Nekztan Jesusaz̈ okan nii z̈oñiqui apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nekztanaqui pizc wajtquin irantichic̈ha Tsjiiqui Betfagé cjitac̈ha, tsjiiqui Betania cjita. Jerusalén wajtz̈ z̈catillatac̈ha, Olivos cjita cur zanquiz. Jesusaqui tsjii pucultan tjaajinta z̈oñinaca tuqui cuchanchic̈ha, ");
INSERT INTO capNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","tuz̈ cjican: —Jerusalén watja oka. Irantiz̈cu tsjii mokz̈ta aznu cheraquic̈ha. Nii aznuqui ana zinta z̈oñiz̈ yawztac̈ha. Jalla nii aznu jwerz̈cu wejtquin zjijcaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yekjap z̈oñiz̈ pewcznanaqui, “¿Kjaz̈tiquiztan niz̈ta paa?” cjenaqui, anc̈hucqui tuz̈ kjaaznaquic̈ha, “Chawjc jiliriz̈ pecc̈ha”, cjican. “Upaquiztan tii aznuc tjepuntaz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nekztan nii pucultanaqui ojkchic̈ha. Tsjii aznu cherchic̈ha, kjuy zanquiz mokz̈ta; callquiztac̈ha. Nekztan ninacaqui aznu jwersic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yekjap nekz z̈ejlñi z̈oñinacaqui pewczic̈ha: —¿Kjaz̈tiquiztan anc̈huc nii aznu jwerjo? ");
INSERT INTO capNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jesusiz̈ chiitacama kjaazic̈ha. Nuz̈quiz nii z̈oñinacaqui cutzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesusiz̈quin nii aznu zjijcchic̈ha. Nekztan zquitinaca carunsic̈ha, Jesusiz̈ yawzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Yekjap z̈oñinacaqui ch'ojña ramuzanaca pootz̈cu, nii jiczquiz chjinchic̈ha. Zquitinaca chjinchizakazza. Nuz̈ paachic̈ha rispitsjapa. ");
INSERT INTO capNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jesusiz̈ tucquin ojkñi z̈oñinacami Jesusiz̈ wirquin apzñi z̈oñinacami tjappacha wiwchic̈ha, tuz̈ cjican: —¡Viva tii Yooz tjuuquiz tjonchi z̈oñi! ¡Yooz wintijla! ");
INSERT INTO capNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tiiz̈ mantaquic̈ha, uc̈hum tuquita z̈oñic̈ha David cjita, jalla niz̈ta! ¡Yooz wintijla! ¡Viva uc̈hum Yooz! ");
INSERT INTO capNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jalla nuz̈u Jesusaqui Jerusalén watja luzzic̈ha. Niz̈aza timpluquiz luzzic̈ha. Tjapa kjutñi chercherchic̈ha. Nekztan tjuñiz̈ zeziz̈ cjen Betania cjita wajtquin ojkchic̈ha niiz̈ tuncapan tjaajinta z̈oñinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jakataz̈uqui Jesusaqui Betania wajtquiztan ulanz̈can, c̈hjeri eecskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Az̈quiztan higuer munti cherchic̈ha, ch'ojña chjañchiz. Nii munti cherzñi ojkchic̈ha, “Frutaj z̈ejlz̈”, cjican. Nii munti irantan, chjañikaz z̈elatc̈ha. Anatac̈ha frut timpu. ");
INSERT INTO capNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nekztan Jesusaqui nii muntiz̈ quintra chiichic̈ha: —Tii muntiquiztan anaz̈ jecmi iya fruta lulaquic̈ha. Niiz̈ tjaajintanacaqui nii chiita nonzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nekztan Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tan Jerusalén watja irantiz̈cu timpluquiz luzzic̈ha. Nekztan timpluquiztan zawncchuc liwj tuyñi z̈oñinacami kjayñi z̈oñinacami tjirkatchic̈ha. Paaz campiiñi z̈oñinacz̈ mizami paloma tuyñiz̈ zillami k'ala pjokz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jesusaqui nii timplu patiuran kuz̈ñi z̈oñinaca k'ala jarq'uichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Nekztanac chiiz̈inchic̈ha, tuz̈ cjican: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Wejt kjuyac̈ha Yooztan parlis kjuyaqui. Jakzilta z̈oñimi Yooztan parlasac̈ha tekziqui.” Anc̈hucqui tii timplu tjangz kjuyaz̈takaz paachinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nekztan timplu chawjc jilirinacaqui judio lii tjaajiñinacaqui nii quintu zizcu parlichic̈ha: —¿Jaknuz̈t tii Jesusa conas? —cjican. Tjapa z̈oñinacazti Jesusiz̈ tjaajintiquiztan ispantichic̈ha: —Ancha cusala, —cjican. Niz̈tiquiztan nii quintri z̈oñinacaqui Jesusiz̈quiztan eksñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Tjuñiz̈ kattan Jesusaqui wajtquiztan ulanchic̈ha niiz̈ tjaajinta z̈oñinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Jakawenztaz̈uqui nii higuer cjita munti wilta watchic̈ha. Waaa, kjoñchi cherchic̈ha, z̈ep'anacz̈quiztanpacha. ");
INSERT INTO capNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedruqui Jesusiz̈ tuquita chiita taku cjuñz̈cu cjichic̈ha: —Tjaajiñi Maestro, cherz̈ca. Amqui tii muntiz̈ quintra chiichamc̈ha. Jaziqui kjoñchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesusaqui kjaazic̈ha: —Yoozquiz tjapa kuztan cjee. ");
INSERT INTO capNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Weraral cjiwc̈ha, jakzilta z̈oñit nii najwc curquiz, “Curu, tekztan zaraka. Pajk kotquiz luzca”, nuz̈ cjican chiyasaz̈ niiqui, niz̈tapachaz̈ curu okasac̈ha, ana paysnakasaz̈ niiqui, tjapa kuztan cjesaz̈ niiqui. ");
INSERT INTO capNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Jaziqui anc̈hucaquiz chiyuc̈ha, c̈hjulumi Yoozquiztan mayizaquiz̈ niiqui, tjaataz̈ cjequic̈ha, Yoozquin tjapa kuztanz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Niz̈aza anc̈hucqui c̈hjulorat Yoozquiztan mayisaja, nii orac anc̈huca quintra z̈oñinacz̈ uj pertunaquic̈ha. Nekztan anc̈huca Yooz Ejpqui anc̈huca ujmi zakaz pertunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Anc̈hucqui ana z̈oñz̈ uj pertunasaz̈ niiqui, niz̈aza arajpach Yooz Ejpqui anc̈huca ujnaca anazakaz pertunasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nekztanaqui Jesusaqui Jerusalén watja wilta quejpchic̈ha niiz̈ tjaajinta z̈oñinacz̈tan. Jesusaz̈ timpluran ojklayan timplu jilirinacz̈tanami lii tjaajiñinacz̈tanami wajt jilirinacz̈tanami jalla ninacaqui Jesusiz̈quin tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nekztan pewczic̈ha: —¿Ject jilirit am mantichi, tii paazjapajo? ¿Jec jilirit am utchi jiliriz̈takaz paazjapajo? ");
INSERT INTO capNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesusac nekztan kjaazic̈ha: —Wejrmi jazic anc̈hucaquiz zakal pewcznac̈ha. Anc̈hucaz̈ kjaaztan, wejr zakal anc̈hucaz̈ pewcz̈tac kjaaznac̈ha, jec jilirit wejr utchi, nii. ");
INSERT INTO capNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tiil pewcznac̈ha anc̈hucaquiz. ¿Ject Juan mantichi, bautisjapajo? Yoozkaya uz̈ z̈oñej. Jazicz̈ kjaazna. ");
INSERT INTO capNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nekztanac ninacpora ancha ch'aasi kallantichic̈ha, tuz̈ cjican: —¿Kjaz̈um kjaaznaquejo? “Yooz mantitac̈ha”, cjequiz̈ niiqui, nekztan “¿Kjaz̈tiquiztan anc̈huc nii Juan ana criichinc̈huctajo?” nuz̈ cjec̈han tiicni. ");
INSERT INTO capNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Uc̈humqui anapanc̈ha chiyi atasac̈ha, “Z̈oñiz̈ mantitacha”, cjican. Z̈oñinacaqui walja nii Juanz̈quin rispittiquiztan, cjichic̈ha: —Werara Yooz taku parliñi profetac̈ha Juanqui. Niz̈tiquiztan nii jilirinacaqui z̈oñinaca ekscu, ");
INSERT INTO capNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ana kjaazñi atchic̈ha. Ninacaqui chiichic̈ha: —¿Jaknuz̈ukazlan? Nekztanac Jesusac cjichic̈ha: —Niz̈aza wejr ana zakal maznasac̈ha, jec jilirit wejr utchi, nii. ");
INSERT INTO capNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nekztan Jesusaqui tsjii quintu paljaychic̈ha, tuz̈ cjican: —Tsjii z̈oñi z̈elatc̈ha, patruna. Nii z̈oñiqui uwas zkala c̈hjacchic̈ha. Nekztan pajk uyu pirkichic̈ha nii zkal muytata. Niz̈aza maz ojt paachic̈ha, uwas kjaz spjijtzjapa. Nekztan campanturi cherchi torre pirkichic̈ha, zkala itzjapa. ‛Nekztan nii patrunaqui zkala partira tjaachic̈ha piyunanacz̈quiz. Nekztan az̈kquin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nekztanaqui zkala ricujz timpuz̈ tjontan nii patrunaqui tsjii piyuna cuchanz̈quichic̈ha, niiz̈ partir zkala ricujzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nii partira tanzñi z̈oñinacaqui patrunaz̈ cuchanz̈quita piyuna tanz̈cu kijtchic̈ha. Wjajtchic̈ha. Ana c̈hjulchiz cuchanchic̈ha patrunz̈quin. ");
INSERT INTO capNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nekztan nii patrunaqui tsjiiz̈tan wilta cuchanz̈quichic̈ha. Nii partira tanzñi z̈oñinacaqui nii patrunz̈ piyuna maztan c̈hajcchic̈ha. Achquiz chjojritchic̈ha. Chjaawjkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nekztan nii patrunaqui wilta tsjii piyuna cuchanz̈quichic̈ha. C̈hjep wiltiquiziqui piyuna conchic̈ha. Niz̈ta anawali paachic̈ha tsjii kjaz̈ cuchanta piyunanacz̈quiz. Partiqui wjajttatac̈ha. Partiqui contatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‛Iya tsjii z̈elatc̈ha nii patrunz̈ k'ay majch. Ultimquiziqui nii patrunaqui k'ay majch cuchanz̈quichic̈ha, “Wejt majch rispitta cjequic̈ha”, cjican. ");
INSERT INTO capNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nii partira tanzñi z̈oñinacazti ninacpora parlassic̈ha tuz̈ cjican, “Tsjii nooj tii majchqui ejpz̈ irinsa tanznasac̈ha. Tii zkal yokanaca k'alaz̈ ricujasac̈ha. Ojklay tiiz̈ conla. Nekztan tsjii nooj uc̈humnacaltaz̈ tjappacha tii zkal yokanaca cjequiz̈, jalla”. ");
INSERT INTO capNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Nekztanaqui nii majch tanz̈cu conchic̈ha. Nekztan nii yokquiztan niiz̈ ticzi curpu jwescu, tjojtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Nekztan Jesusaqui pewczic̈ha: —¿Nii uwas zkalchiz patrunaqui, c̈hjulut paac̈haja? Wejr cjiwcha, nii patrunaqui tjonaquic̈ha. Nekztan nii partira tanzñi z̈oñinaca conaquic̈ha. Nekztan niiz̈ uwas zkal yokanaca yekjanacz̈quiz tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","‛Anc̈hucqui Yooz taku liichinc̈hucc̈ha, ¿ana jaa? Tsjii Yooz takuqui tuz̈ cjic̈ha: “Kjuy pirkiñinacaqui tsjii maz tjojtchic̈ha. Nii tjojta mazqui isquinquiz cjissic̈ha. Ultimquiziqui tucquin cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yoozqui nuz̈ cjiskatchic̈ha. Nii cherz̈cu ancha ispantichinc̈humc̈ha”. Nuz̈ cjic̈ha cjijrta Yooz takuqui. ");
INSERT INTO capNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nekztanaqui nii quintri z̈oñinacaqui Jesusa tanz pecatc̈ha: —Tii quintu wejtnaca quintraz̈, —cjican. Nekztan nii z̈ejlñi z̈oñinaca ekscu, quintri z̈oñinacaqui Jesusa ecchic̈ha, ana kjaz̈ cjiscu. Nuz̈quiz ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Yekjap fariseo z̈oñinacaqui Herodes z̈oñinacz̈tan cuchanz̈quitatac̈ha, Jesusa pewczñi. Niiz̈ chiitiquiztan tsjii anazum taku jwes pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jaziqui cjichic̈ha: —Tjaajiñi Maestro, zizuz̈ wejrnacqui, am werarapan chiiñamc̈ha, z̈oñinacaz̈ am quintra chiichiz̈ cjenami. Niz̈aza am taku anaj tsjii tsjii chiichila z̈oñinacz̈ laycu. Yooztan kamz puntuquiztan werarapan tjaajiñamc̈ha. Jazic tjaajz̈nalla tii puntu. Wejrnacqui César cjita jilirz̈quiz tas paaz tjaayiñc̈ha. ¿Nuz̈ walikazkay uz̈ anaz̈ wali cjesaj? ¿Nii tas paaz tjaaz waquizasaya, uz̈ anaz̈ waquizasaj, jaa? ");
INSERT INTO capNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesusaqui ninaca pizc kuzziz zizatc̈ha. Nekztan kjaazic̈ha: —¿Kjaz̈tiquiztan anc̈hucqui wejr ujchiz jwes pecjo? Tsjii paaz zjijca, cherzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tsjii paaz zjijcchic̈ha. Nekztan Jesusac pewczic̈ha: —¿Tii paazquiz, jecz̈ yujctaya? ¿Jecz̈ tjuu cjijrtataya? Ninacaqui kjaazic̈ha: —César cjita jilirz̈ tjuuc̈ha. Niiz̈ yujcc̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nekztan Jesusaqui chiichic̈ha. —C̈hjulumi jilirz̈ta cjenaqui jilirz̈quiz tjaa. Niz̈aza c̈hjulumi Yoozta cjenaqui Yoozquiz tjaa. Nuz̈ chiitiquiztan ninacaqui ancha ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nekztan yekjap saduceo z̈oñinacaqui Jesusa cherzñi ojkchic̈ha. Jacatatz puntu ana criiñipantac̈ha. Jesusiz̈quin macjatz̈cu pewczic̈ha: ");
INSERT INTO capNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tjaajiñi Maestro, Moisesaqui uc̈humnacalta cjijrtkalc̈ha, tuz̈ cjican: “Tsjii z̈oñi ticznasaz̈ niiqui, niiz̈ tjun ana ocjalchiz cjesaz̈ niiqui, nekztan nii ticzi z̈oñz̈ jilaqui naa z̈ewatan zals waquizic̈ha, nii ticzi jilz̈ cuntiquiztan ocjala paazjapa”. ");
INSERT INTO capNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jaziqui pakallak jilazullca z̈elatc̈ha. Nii jilir jilaqui zalsic̈ha. Nekztan ticzic̈ha ana ocjalchiz. ");
INSERT INTO capNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nekztan tsjii taypir jilaqui naa z̈ewatan zalsizakazza. Nekztan ana ocjalchiz ticzizakazza. Nekztan yekja taypir jilaqui naa z̈ewatan zalsizakazza. Nekztan ana ocjalchiz ticzizakazza. ");
INSERT INTO capNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Tjappach nii pakallak jilazullcanacaqui naa z̈onatan zalsic̈ha. Nekztan tjappacha ana ocjalchiz ticzic̈ha. Ultimquiziqui naa z̈onqui ticzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jaziqui z̈oñinaca jacatattanaqui wilta z̈eti tantanaqui ¿jakzilta jilz̈ tjun naa z̈on cjequejo? Pakallakuqui naa z̈onatan zalsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesusaqui kjaazic̈ha: —Anc̈huca takuqui tsjii kjutñi chiyiñc̈hucpanc̈ha. Anc̈hucqui Yooz takumi Yooz azimi anapan zizza. ");
INSERT INTO capNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ticzi z̈oñinacaz̈ jacatattanaqui anaz̈ zals z̈elaquic̈ha. Anaz̈ tjotjowami turtakanacami zalznaquic̈ha. Arajpach anjilanaca irataz̈ kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jacatatz puntuquiztan Moisesaqui liwruquiz cjijrtkalc̈ha. Liichinc̈hucc̈ha, ¿ana jaa? Tsjii ujsñi kalquiztan Yoozqui Moisesquiz paljaychic̈ha, tuz̈ cjican: “Abrahamz̈ Yooztc̈ha wejrtc̈ha. Niz̈aza Isaacz̈ Yooztc̈ha, niz̈aza Jacobz̈ Yooztc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yooz Ejpqui anac̈ha ticzi z̈oñz̈ Yoozqui, z̈ejtñi z̈oñz̈ Yoozqui. Niz̈tiquiztan anc̈huca takuqui ancha tsjii kjutñipankazza. ");
INSERT INTO capNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nekztanaqui z̈oñinacz̈tan Jesusiz̈tan ch'aasñi nonz̈cu tsjii judiuz̈ lii tjaajiñi z̈oñiqui macjatz̈quichic̈ha. Jesusaz̈ zuma kjaaztiquiztan nii z̈oñiqui pewczizakazza, tuz̈ cjican: —¿Jakzilta Yooz mantitat chekanaqui? ");
INSERT INTO capNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesusaqui kjaazic̈ha: —Tii Yooz mantitac̈ha chekanaqui: “Nonz̈na anc̈hucqui, Israeli wajtchiz z̈oñinaca. Tsjan chawjc jiliric̈ha uc̈hum Yoozqui. Ana iya yekja Yooz z̈ejlc̈ha. Yoozqui Jiliripanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Anc̈hucqui tii anc̈huca Yoozquiz tjapa kuztan sirwaquic̈ha, niz̈aza tjapa animuz̈tanami, niz̈aza tjapa pinsamintuz̈tanami, niz̈aza tjapa aztanami”. Jalla nii Yooz mantitac̈ha chekanaqui. ");
INSERT INTO capNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Niz̈tazakaz nii jaru tii Yooz mantitac z̈ejlc̈ha. Tuz̈ cjic̈ha: “Jaknuz̈um persunpachquiz okzñamz̈laja, jalla niz̈ta okzñi kuzziz cjistanc̈ha z̈oñinacz̈quizimi, lijitum maziz̈takaz”. Tii pizc mantitanacac̈ha juc'ant chekanaqui c̈hjul mantitanacquiztanami. ");
INSERT INTO capNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nekztan nii judío tjaajiñiqui cjichic̈ha: —Tjaajiñi Maestro, werara chiichamc̈ha. Am chiitaqui cusac̈ha. Tsjii Yoozpankaz z̈ejlc̈ha; ana iya z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tii Yoozquiz sirwispanz̈ waquizila, tjapa kuztan, niz̈aza tjapa animuz̈tan, niz̈aza tjapa pinsamintuz̈tan niz̈aza tjapa aztan. Nii jaruqui jaknuz̈um persunpachquiz okzñamz̈laja, jalla niz̈ta okzñi kuzziz cjistanc̈ha z̈oñinacz̈quizimi, lijitum maziz̈takaz. Yoozquin ujta wilana puntu mantitami niz̈aza ofrenda tjaaz mantitami jalla nii mantitanacz̈quiztan tii pizc Yooz mantitanacac̈ha juc'ant chekanaqui. ");
INSERT INTO capNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Nii judío tjaajiñi z̈oñiqui zuma intintazzi razunchiz chiichic̈ha. Niz̈ta nayz̈cu Jesusaqui chiichic̈ha: —Amqui Yooztan kamz jicz cjez̈ullac̈ha, Yooz mantita z̈oñi cjisjapa. Nekztan z̈oñinacaqui iya pecunchi Jesusiz̈quiz pewczñi anaz̈ atatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jaziqui Jesusaqui timpluquiz tjaajincan, cjichic̈ha: —Nii judío tjaajiñinacaqui tuz̈ cjic̈ha: “Davidz̈ majchkazza Cristuqui”. ¿Kjaz̈tiquiztan nuz̈ cjeejo? ");
INSERT INTO capNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Arajpach Yooz Espirituqui David chiikatchic̈ha, tuz̈ cjican: “Yooz Ejpqui wejt chawjc jilirz̈quiz cjichic̈ha: ‘Tsjii ora wejrqui am kjojch koztan am quintri z̈oñinaca t'okskatac̈ha. Nii oracama wejt z̈ew latu julzna’ ”. ");
INSERT INTO capNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Jaziqui Davidaqui persunpacha cjichic̈ha: “Chawjc jiliric̈ha tiiqui”. ¿Niz̈tiquiztan jaknuz̈t niiz̈ chawjc jiliri niiz̈ majchqui cjesajo? —Nuz̈ cjichic̈ha Jesusaqui. Nii tama z̈ejlñi z̈oñinacaqui Jesusiz̈ taku nonz juztazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Niz̈aza tjaajincan Jesusaqui cjichic̈ha: —Judío lii tjaajiñinacz̈quiztan cwitazaquic̈ha. Ninacac tol zquitchiz ojklayz juztazñic̈ha. Ninacaqui palazquiz tsaanskatzmi rispitskatzmi jalla niika pecñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ninacaqui ajcz kjuyquiz tucquin julz pecñic̈ha. Niz̈aza pjijstiquiz lujlcan ancha tucquin cjicjis pecñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ninacpacha z̈ewz̈ewanaca t'akjiri cjiskatñic̈ha. Niz̈aza z̈oñinaca incallzjapa az̈ka Yooztan parlitaz̈oka cjiñic̈ha. Jaziqui ninacaz̈ juc'anti casticta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nekztan Jesusaqui ofrenda tjaaz cajun yujcquin julzic̈ha. Nekzi z̈oñinaca paaz uchan cherchic̈ha. Yekjap ricachunacaqui muzpa paaz utchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nekztan tsjaa poris z̈ewqui tjonchinc̈ha. Pizc paazalla utchinc̈ha, koluculla. ");
INSERT INTO capNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz kjawzic̈ha. Nekztan intintiskatchic̈ha: —Weraral chiyuc̈ha, naa poris z̈ewqui nii cajunquiz juc'anti utchinc̈ha, tjapa nii parti z̈oñinacz̈quiztan cjen. ");
INSERT INTO capNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Nii parti z̈oñinacaqui c̈hjetinta paaz utchic̈ha. Naa poris z̈ewzti tjappacha naatan kamñi paaz utchiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nekztan timpluquiztan ulnan tsjii tjaajinta z̈oñiqui Jesusiz̈quiz paljaychic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, cherz̈ca. Tii pajk maznacami tii pajk kjuyanacami ancha cusac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jaziqui Jesusaqui niiz̈quiz chiichic̈ha: —Tii pajk kjuyanaca cherc̈ha amqui. Wejrqui cjiwc̈ha, tsjii nooj ana zinta tii maznacaqui pirkita z̈elaquic̈ha. Tjappacha pajlz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nekztan Olivos cjita curu ojkchic̈ha, timpluz̈ zanquiz. Nekzi Jesusac julzi z̈elatc̈ha; ana iya z̈oñi z̈elatc̈ha. Nekztan Pedruz̈tan, Jacoboz̈tan, Juanz̈tan, Andrestan, ninacaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Maznalla wejtnacaquiz. ¿C̈hjulorat nii amiz̈ chiita wataquejo? ¿Ima amiz̈ chiita watan, c̈hjulunacat wataquejo? ");
INSERT INTO capNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Nekztan Jesusaqui kjaazic̈ha: —Anc̈hucqui persunpachquiz cwitaza, anac̈ha jecz̈quizimi incallskata. ");
INSERT INTO capNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Z̈oñinacaqui wejt tjuu aynakcanz̈ tjonaquic̈ha, tuz̈ cjican: “Wejrtc̈ha Cristutqui”, Jalla nekztanaqui muzpa z̈oñinacaqui incallskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‛Anc̈hucqui quintunaca nonznaquic̈ha, quira z̈ejlz quintunaca, ch'ajwa quintunaca. Nekztan anac̈ha tsucaquic̈ha anc̈hucqui. Niz̈tapanz̈ wataquic̈ha. Tii muntu tucuzinzqui imaz̈ irjatz̈quic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nacionporaz̈ kichjasaquic̈ha. Wajtporaz̈ kichjasaquic̈ha. Tjapa kjutñi yokac chjeknaquic̈ha. Mach'anaca z̈elaquic̈ha. Z̈oñipora kichjasaquic̈ha. Ancha z̈oñinaca t'akjisaquic̈ha tjapa kjutñi. Sufrisnaca uzcakaz̈ kallza. Wiruñac juc'ant sufrisnaca z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‛Anc̈hucqui persuna waljaz̈ cwitazaquic̈ha. Z̈oñinacaqui anc̈huc tanz̈cu jilirinacz̈quin chjichaquic̈ha. Nekztan ajcz kjuyquiz wjajtazakaz cjequic̈ha anc̈hucqui. Weriz̈ cjen chawjc jilirz̈ yujcquizimi wajt jilirz̈ yujcquizimi apantitaz̈ cjequic̈ha. Nekztan wejt puntuquiztan ninacz̈quiz maznaquic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ima tii muntuz̈ tucuzan, Yooz takuqui tjapa nacionquin maz maztaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","C̈hjulorat anc̈hucqui jilirz̈quiz apantita cjec̈haja, jalla nii ora anac̈ha eksnaquic̈ha, ¿kjaz̈t wejr cjeequejo? —cjicanaqui. Niz̈aza anac̈ha ancha c̈hjulu chiismi pinsaquic̈ha anc̈hucqui. Nii oraqui Yooz anc̈hucaquiz tjaajznaquic̈ha, c̈hjul takut chiyac̈haja, nii. Anc̈huca persun pinsita inapankazza. Nii oraqui Yooz Espirituqui anc̈hucaquiz chiikataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tsjii jilaqui persun jila tarasunaquic̈ha conkatzjapa. Ejpnacaqui persun maati tarasunaquic̈ha conkatzjapa. Maatinacami maa ejpz̈ quintra tsijtsnaquic̈ha conkatzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anc̈huc weriz̈ cjen tjapa z̈oñinacaz̈ chjaawjtaz̈ cjequic̈ha. Jakzilta z̈oñit ticzcama wejtquiz tjurt'ac̈haja jalla niiqui liwriitaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‛Daniel cjita Yooz taku parliñi profetaqui cjijrtkalc̈ha, tuz̈ cjican: “Tsjii nooj tsjii juc'ant anawal akñi z̈oñi z̈elaquic̈ha”. Jakziquin niiqui ana z̈ejlsalaja, nicjuñ z̈elaquic̈ha tii anawaliqui. C̈hjulorat anc̈hucqui niz̈ta cherac̈haja, nii ora curunacquin atipas waquizic̈ha tjapa Judea yokquin z̈ejlñinacaqui. Liiñi z̈oñiqui intintazla. ");
INSERT INTO capNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Nii kjuy juntuñ z̈ejlñi z̈oñinacaqui chjijwz̈cu ana kjuya luzla, c̈hjulumi chjichi jwesjapa. ");
INSERT INTO capNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Nii zkalquin z̈ejlñi z̈oñinacaqui ana kjuya quejpla, zquiti apti. ");
INSERT INTO capNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nii timpuquiziqui ic maatakanacami k'azllu wawchiz maatakanacami ancha t'akjiri cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Yoozquinc̈ha mayiza anc̈hucqui, anaj zak timpuquin tiz̈tanacac tjonla, nii. ");
INSERT INTO capNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Tii sufris timpu yekja sufrisnacquiztan juc'anti sufris cjequic̈ha. Tuqui timpuqui Yoozqui tii muntu paachic̈ha. Nekztan jecchuc anapanz̈ tiz̈ta sufrisnacac watchiqui. Tekztan najwcchuc anaz̈ iya juc'anti sufrisqui cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Yoozqui anaz̈ tii sufrisnaca tucuskataquiz̈ niiqui, tjapa z̈oñinacaz̈ ticznaquic̈ha. Yoozqui niiz̈ illzta z̈oñinacz̈ cjen tii sufrisnaca tucuskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‛Niz̈aza yekjap z̈oñinacaqui anc̈hucaquiz chiyaquic̈ha: “Chera. Ticjuc̈ha Cristuqui”. Yekjapac chiyaquic̈ha: “Nacjuc̈ha Cristuqui” cjican. Nuz̈ chiichiz̈ cjenami, anapanc̈ha nii taku criyaquic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Incallñi z̈oñinacaz̈ tjonaquic̈ha. Tsjii incallñinacaqui: “Cristutc̈ha wejrqui”, cjequic̈ha. Yekjapazti: “Yooz taku parliñtc̈ha wejrqui”, cjequic̈ha. Ninacaqui walja ispantichuca milajrunacaz̈ paaquic̈ha, incallzjapa. Tjapa z̈oñinacaz̈ incallz pecaquic̈ha, Yooz illzta z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ima tiz̈tanacaz̈ tjonan wejrqui anc̈hucaquiz mazinchiñc̈ha. Niz̈tiquiztan walja cwitazaquic̈ha anc̈hucqui. Niz̈ta kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‛Nekztanaqui tii sufris timpu wattan, tjuñiqui zumaquic̈ha. Niz̈aza jiizmi anaz̈ iya kjanaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Warawaranacami tsewctan tjojtsnaquic̈ha. Tseecu azziz z̈ejlñinacaqui chjekinskattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jalla nekztanaqui z̈oñinacaqui tii tsewctan cuchanz̈quita Yooz Z̈oñiz̈ cheraquic̈ha. Wejrqui tsjir taypiquiz tjonac̈ha, walja aztan, ancha ispantichuca. ");
INSERT INTO capNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nekztanaqui tjapa kjutñi nii arajpach Yooz anjilanacaqui cuchanta cjequic̈ha, weriz̈ illztanaca juntjapz̈cajo. Tjapa yok tjiyquiztanpacha tjapa arajpach tjiyquiztanpacha juntjapz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‛Anc̈hucqui tii puntu zizaquic̈ha higuera cjita muntiquiztan. C̈hjulorat nii muntiqui ch'ojñantis cjissaja, jalla nii ora waj kutunz timpu z̈catic̈ha. Nuz̈upanz̈ zizza anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jalla niz̈tapacha tii weriz̈ chiita watan, anc̈hucqui tuz̈ zizaquic̈ha; tii tsewctan cuchanz̈quita Yooz Z̈oñiqui wajillaz̈ tjonaquic̈ha, nii. Niz̈aza tii muntu tucuzinzqui z̈catillac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Weraral cjiwc̈ha, tjapa tii timpuquiz z̈ejlñi z̈oñinacaqui ana ticznaquic̈ha, ima tii weriz̈ chiita watan. ");
INSERT INTO capNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Arajpachami yokami tucuzaquic̈ha. Wejt takunacazti wiraz̈ ana tucuzaquic̈ha. Nuz̈upanz̈ cumplisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‛Wejt tjonz tjuñimi wejt tjonz orami anaz̈ jecmi zizasac̈ha, anaz̈ nii arajpach Yooz anjilanacami, anaz̈ Yooz majchmi. Yooz Ejp alajakaz zizza. ");
INSERT INTO capNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","‛Anc̈hucqui, persuna naazna, cwitaza, Yoozquin mayiza. C̈hjulorat nii tjuñi tjonac̈haja, nii ora ana zizza anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jalla tii quintuz̈ iratac̈ha wejt tjonz tjuñi. Tsjii z̈oñiqui az̈kquin ojkz tantiichic̈ha. Ima niiz̈ kjuyquiztan zarakcan zapa mayni niiz̈ piyunanacz̈quiz langz tjaac̈ha. Kjuy cwitiñi z̈oñz̈quiz zuma cwitajo mantic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Nekztan ojkz̈cu, c̈hjulorat nii kjuychiz z̈oñiqui quepac̈haja, jalla nii ora, piyunanacaqui ana zizza, niit uz̈ zeztan tjonac̈haja, niit uz̈ chica arama tjonac̈haja, niit uz̈ kjantat ora tjonac̈haja niit uz̈ wentan tjonac̈haja. C̈hjulorat tjonac̈haja, ninacaqui anaz̈ zizza. Niz̈tiquiztan piyunanacaqui listuz̈ cjila. ");
INSERT INTO capNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Jalla nii irata anc̈hucqui listuz̈ cjee. Tiripintit anc̈hucaz̈ tjajan tjonasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wejrqui anc̈hucquizimi tjapa z̈oñinacz̈quizimi chiyuc̈ha, listupanc̈ha cjee. ");
INSERT INTO capNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Puc majkaz pjaltic̈ha pascu pjijztiquinaqui. Nii orazakaz yekja pjijztaqui kalltiznatc̈ha, ana liwaturchiz t'anta lujlz pjijzta. Jalla nii ora timplu jilirinacz̈tan judio tjaajiñinacz̈tan palt'ichic̈ha, tuz̈ cjican: —¿Jaknuz̈um Jesusa incallz̈cu tanas? Niz̈aza nuz̈ tanz̈cu, Jesusa conzjapa kazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ninacaqui tantiiz̈cu, cjichic̈ha: —Pjijztiquiz anaz̈ tanz waquizasac̈ha. Z̈oñinacaqui uc̈hum quintraz̈ cjisnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesusaqui Betania cjita wajtquiz z̈elatc̈ha, Simonz̈ kjuyquiz. Nii Simonaqui tuquitan mojkchi janchichiz z̈ejlñitac̈ha. Nekzi lulan tsjaa maatak z̈onqui tsjii putillz̈tan tjonzinc̈ha. Nii putillquiz cusa mazk'a ulurchiz asiiti z̈elatc̈ha, nardo cjita, ancha jila walurchiz. Nii putillaqui zuma alabastro cjita maztan paatatac̈ha. Nekztan naa maatak z̈onqui putilla kjolz̈cu Jesusiz̈ achquiz asiiti alsinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Yekjap nekz z̈ejlñi z̈oñinacaqui z̈awjzic̈ha. Ninacpora palt'ichic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan nii mazk'a ulurchiz asiiti pertejo? ");
INSERT INTO capNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Naalaqui asiiti tuysalani quinsa patac denario cjita paazuñ. Nekztan nii paazqui poris z̈oñinacz̈quiz onansalani. Naaz̈a quintra chutchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Nekztan Jesusaqui chiichic̈ha: —¿Kjaz̈tiquiztan taa z̈onatan chjijcjisejo? Anac̈ha taa z̈on kjaz̈ cjisqui. Wejtquiziqui walika paachinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Poris z̈oñinacami panz̈ z̈ejlc̈ha. C̈hjulorami ninacz̈quiziqui yanapasac̈ha. Wejrqui anal anc̈hucatan tira z̈elac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Taa z̈onqui jaknuz̈t payi atc̈haja, nii paachinc̈ha. Ima wejt curpu tjatan asiitiz̈tan alsinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Chekpacha weraral cjiwc̈ha, jaksiquinami tjapa kjutñimi Yooz taku parlita cjec̈haja, jalla nicju taaz̈a paata parlita cjequic̈ha, taa maatak z̈on cjuñznajo. ");
INSERT INTO capNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nekztanaqui Judas Iscariotiqui timplu jilirinacz̈quin palt'i ojkchic̈ha. Jesusiz̈ tuncapan tjaajinta z̈oñinacz̈quiztantac̈ha Judasqui. ");
INSERT INTO capNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Judas taku nonz̈cu jilirinacaqui ancha chipchic̈ha: —Paaz tjaasac̈ha, —cjican. Nekztanaqui Judasqui tantiichic̈ha, c̈hjulorat wali cjec̈haja, Jesusa tankatzjapa, nii. ");
INSERT INTO capNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pjijzta kallñi tjuñi, ana liwaturz̈tan t'anta lujlz pjijzta, nii tjuñi judio wajtchiz z̈oñinacaqui pascu uuza conñic̈ha. Nii noojpacha tjaajinta z̈oñinacaqui Jesusiz̈quiz pewczic̈ha: —¿Jakziquin wejrnacqui ojkz waquiziya, pascu c̈hjeri luli tjaczjapaya? ");
INSERT INTO capNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Nekztan Jesusaqui pucultan tjaajintanaca cuchanchic̈ha, tuz̈ cjican: —Wajtquin oka. Nekzi tsjii z̈oñz̈tan zalaquic̈ha kjaz luuz kuz̈z̈i. Nii z̈oñz̈ wirquiz apznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Jakziquin nii z̈oñiqui luzac̈haja, jalla nicju nii kjuychiz z̈oñz̈quiz paljayaquic̈ha, tuz̈ cjican: “Tjaajiñiqui cjichic̈ha: ¿Jakziquin wejt tjaajintanacz̈tan pascu c̈hjeri lulasaya? ¿Jaknit nii kjuyajo?” ");
INSERT INTO capNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nekztan nii kjuychiz z̈oñiqui tsewcta pisuquin tsjii pajk kjuya tjeeznaquic̈ha anc̈hucaquiz. Nii kjuya listu tjacz̈ta cjequic̈ha. Jalla nicju uc̈humqui c̈hjeri kisnaquic̈ha. —Nuz̈ mantichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nuz̈quis nii pucultan tjaajintanacaqui zarakchic̈ha. Watja ojkchic̈ha. Jesusiz̈ chiitacama niz̈tapacha watchic̈ha. Nekztanaqui pascu c̈hjeri kissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Tjuñiz̈ kattan Jesusaqui tjonchic̈ha tuncapan tjaajintanacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","C̈hjeri lujlcan Jesusaqui chiichic̈ha: —Weraral cjiwc̈ha, anc̈hucaquiztan tsjii wejttan lujlñiqui wejr tarazunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ninacaqui nuz̈quiz llaquita cjissic̈ha. Nekztan ninacaqui Jesusiz̈quiz pewczic̈ha. Tsjiiqui: —¿Wejrkay? —cjichic̈ha. Tsjiic: —¿Wejrkay? —cjichizakazza. ");
INSERT INTO capNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nekztanac Jesusac kjaazic̈ha: —Tuncapaniz̈ anc̈hucqui tsjiiqui wejr tarazunaquic̈ha. Anziqui niic̈ha wejttan chica c̈hjeri lujlchi. ");
INSERT INTO capNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejr okac̈ha, Yooz taku cjijrtacama. Jakziltat wejr tarazunac̈haja, jalla niiqui juc'anti castictaz̈ cjequic̈ha. Nii tarazuñi z̈oñiqui anaj maa pjuchquiztan nastc̈haj niiqui, juc'ant cusaz̈ cjitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nekztanaqui c̈hjeri lujlcan, Jesusaqui t'anta tanz̈cu Yoozquin gracias cjican chiichic̈ha. Nekztan t'anta kjolz̈cu, tjaajintanacz̈quiz tojzic̈ha, tuz̈ cjican: —Tanzna. Tii t'antac̈ha wejt curpu cuntaqui. ");
INSERT INTO capNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nekztan tsjii wazu tanzic̈ha. Yoozquin gracias cjican chiichizakazza. Nekztan ninacz̈quiz tjaatan, tjappacha ninacaqui nii wazquiztan liczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jesusaqui chiichic̈ha: —Wejt ljocquiztan cjic̈ha tiiqui. Wejt ljocz̈tan tsjii ew acta tjulz̈ta cjequic̈ha. Wejt ljocqui tjapa z̈oñinacz̈ cuntiquiztan tjawktaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Weraral cjiwc̈ha, uwas kjaz ana iya licac̈ha, c̈hjulorat Yooz tjapa mantac̈haja, jalla nii oracama. ");
INSERT INTO capNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tsjii Yooz wirsu itscu ojkchic̈ha Olivos cjita curullquin. ");
INSERT INTO capNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nekziqui Jesusaqui chiichic̈ha: —Tii weenaqui tjapa anc̈hucqui ana wejtquin kuzziz tucaquic̈ha. Niz̈tapan cjijrta Yooz takuqui cjic̈ha: “Wejr arajpach Yoozqui awatiri conac̈ha. Nekztan uuzanacaqui wichansnaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jesusaqui cjichizakazza: —Nekztan jacatatz̈cuqui anc̈huca tuqui okjayac̈ha Galilea cjita yokquin ");
INSERT INTO capNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nekztan Pedruqui chiichic̈ha: —Tjappacha ana amquin kuzziz cjec̈hani. Wejrqui ana wira niz̈ta cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesusaqui kjaazic̈ha: —Weraral cjiwc̈ha, tii weenpacha amqui ana wejr pajñi tucaquic̈ha, Ima wallpaz̈ pizc wiltaz̈ kjawan, amqui c̈hjep wilta wejr ana pajñim chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pedruqui juc'anti tjurt'ichic̈ha, tuz̈ cjican: —Wejrqui amtan chicami waztal ticznasac̈ha. Anapan amquiztanac zarakasac̈ha. Tjapa nii tjaajintanacaqui niz̈tapacha tjurt'ichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Nekztan Getsemaní cjita yokquin ojkchic̈ha. Nicju Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz chiichic̈ha: —Tekzi julzna. Wejrqui Yooztan parli okac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nekztan Pedruz̈tan Jacobz̈tan Juanz̈tan chjitchic̈ha. Jesusaqui walja llaquita kuzziz turwaysic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Niiz̈ tjaajintanacz̈quiz paljaychic̈ha: —Wejt kuzqui ancha llaquita, ticzucac̈ha. Anc̈hucqui tekzi z̈ela. Wilazaquic̈ha; anac̈ha tjajaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nekztan tsjii koluc tuquinalla ojkchic̈ha Jesusaqui. Yokquizkaz tuzi t'okzic̈ha. Yoozquiztan mayizichic̈ha, tuz̈ cjican: —Tii juc'ant sufris timpu anal wats pecuc̈ha. Tii sufrisquiztan liwriychucaz̈laj niiqui, amquiz̈ liwriyalla. ");
INSERT INTO capNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tira maycan cjichic̈ha: —Yooz Ejp, amqui c̈hjulumipankam atasac̈ha. Tii sufrisnacquiztan liwriyalla. Pero anal wejt kuzcama paaz pecuc̈ha. Jaknuz̈t am kuz amtic̈haj niiqui, jalla nuz̈ am munañpaj cjila. ");
INSERT INTO capNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nekztanaqui tjaajintanacz̈quin quejpz̈quichic̈ha. Tjajchi zalchic̈ha. Nekztanaqui Jesusaqui Pedruz̈quiz cjichic̈ha: —¿Simona, amquim tjajya? ");
INSERT INTO capNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","¿Anam tsjii orami wilazi atya? Wilaza. Yoozquiztan mayiza, ana ujquiz tjojtzjapa. Anc̈hucqui ancha kuztanc̈ha. Pero anc̈huca curpuzti anaz̈ awantasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nekztan Jesusaqui wilta Yooztan parli ojkchic̈ha. Tuquiqui jaknuz̈t parlic̈haja, niz̈tazaka parlichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wilta tjaajintanacz̈quin quejpz̈quichic̈ha. Wilta tjajchi zalchic̈ha. Ancha tjaji atipskatchic̈ha. Ninacaqui Jesusiz̈quiz ana kjaazñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jalla nekztan Jesusac c̈hjep wilta ojkz̈cu quejpz̈quichic̈ha. Nekztan chiichic̈ha: —Jaziqui tjajchinc̈hucc̈ha, anc̈hucqui, niz̈aza jeejzinc̈hucc̈ha. Nuz̈ukaz. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui ujchiz z̈oñinacz̈ kjarquiz tankattal cjeec̈ha. Nii ora anziqui irjatz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Z̈aazna. Ojkla. Cherz̈na. Wejr tarazuñi z̈oñiqui nii nacjuz̈ tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nii ora Jesusaz̈ nuz̈ chiyan, tsjiiqui tuncapan tjaajinta z̈oñinacz̈quiztan tjonchic̈ha, Judas cjita. Tama z̈oñinacaqui Judastan tjonchic̈ha pajk cuchillunacchiz, niz̈aza wjajtz carotinacchiz. Timplu chawjc jilirinacz̈tan judío lii tjaajiñinacz̈tan wajt jilirinacz̈tan ninacaz̈ cuchanz̈quita tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tuquitan nii tankatñi Judasqui kazzic̈ha Jesusa tankatzjapa. Nuz̈ kazcu, cjichic̈ha: —Tsjii z̈oñil chjulznac̈ha. Niiz̈ niic cjequic̈ha. Nekztan zuma tanz̈cu chjichaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Nii ora Judasqui Jesusiz̈quiz macjatchic̈ha: —Tjaajiñi Maestro, —cjican. Nekztan nii chjulzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nekztan z̈oñinacaqui Jesusa tanchic̈ha, preso chjitzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Tsjii nekz tsijtchi z̈oñiqui pajk cuchillu jwessic̈ha. Jalla nekztan tsjan chawjc jilirz̈ piyuna chjojritchic̈ha. Tsjii cjuñi pootz̈cu apakchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nekztan Jesusac chiichic̈ha: —Anc̈hucqui cuchillunacz̈tan carotinacz̈tan wejr tani tjonchinc̈hucc̈ha, tsjii tjañi cjes, niz̈taz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Zapuru anc̈hucaltan z̈ejlchinc̈ha, timpluquiz tjaajincan. Wira ana wejr tanchinc̈hucc̈ha. Pero anziqui jaknuz̈t Yooz taku chiic̈haja, nuz̈upanz̈ cumplita cjila. ");
INSERT INTO capNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nekztanaqui tjapa niiz̈ tjaajinta z̈oñinacaqui tsucaña wichanzic̈ha. Jesusa zinalla eclichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Tsjii tjowaqui Jesusa apzic̈ha, tsjii zquiti irzi. Nii tjowac tantazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Nekztan nii zquiti cutz̈cu, k'alapacha tsucaña atipchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nekztanaqui Jesusaqui chjichtatac̈ha timplu tsjan chawjc jilirz̈ kjuya. Nekziqui timplu chawjc jilirinacz̈tan wajt jilirinacz̈tan judío lii tjaajiñinacz̈tan ajczitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedruqui az̈quiztan apzic̈ha, chawjc jilirz̈ kjuy patio luzcama. Nii patiuquiz zultatunacz̈tan julzi z̈elatc̈ha, uj latuquiz kutuncan. ");
INSERT INTO capNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Kjuyquiziqui timplu jilirinacaqui tjapa jiliri mazinacz̈tan Jesusiz̈ quintra chiiñi z̈oñi kjuratc̈ha, Jesusa conta cjisjapa. Ana zinta uj wajtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Muzpa tama z̈oñinacaqui Jesusiz̈ quintra toscara chiichic̈ha. Pero ninacz̈ toscar takuqui anaz̈ wira casatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yekjap z̈oñinacaqui tsijtscu toscara chiichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Wejr nonziñc̈ha, tii z̈oñi tuz̈ chiiñi, “Tii z̈oñiz̈ kjuyta timplu pajlznac̈ha. Nekztan c̈hjep majquiztan yekja timplu kjuyac̈ha, ana z̈oñiz̈ kjuyta”. Nuz̈ chiiñi nonzinc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Anaz̈ niz̈tami z̈oñinacz̈ takuc casatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ultimquiziqui nii timplu chawjc jiliriqui tsijtsic̈ha z̈oñinacz̈ taypiquiz. Jesusiz̈quiz pewczic̈ha: —¿Anam kjaazñi at, kjaz̈tatajo? ¿Kjaz̈ cjican am quintra chii tii z̈oñinacajo? ");
INSERT INTO capNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesusaqui ana c̈hjulu tawkz̈cu, z̈elatc̈ha, ana kjaazic̈ha. Nekztan nii tsjan chawjc jiliriqui wilta pewczic̈ha: —¿Amqui Cristumkaya? ¿Arajpach Yooz Machimkaya? ");
INSERT INTO capNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesusaqui kjaazic̈ha: —Jesalla. Wejrtc̈ha Cristutqui. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tsjii nooj anc̈hucqui wejr cheraquic̈ha, juc'anti azziz Yooz latuquiz julzi. Nekztan arajpachquiztan tsjirquiz tjonac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Niz̈ta chiitiquiztan nii timplu chawjc jiliriqui niiz̈ zquiti wjajrzinchic̈ha, z̈awjchi tjeezjapa. Nekztan cjichic̈ha: —¿Kjaz̈tiquiztan iya quintra chiiñi z̈oñi pecasajo? ");
INSERT INTO capNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anc̈hucqui nonzinc̈hucc̈ha. Tiiz̈ takuqui Yooz quintrac̈ha. Ana walipanc̈ha. ¿C̈hjuluc̈hum paaqui, kjaz̈um cjeequi? ¿Tantiyalla? Nekztan tjappacha quintra chiichic̈ha: —Tii z̈oñi contaj cjila, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nekztan yekjapaqui Jesusiz̈quiz llawsiz̈tan tjujtchic̈ha, wjajtchizakazza. Nekztan niiz̈ yujc pañz̈tan tjotz̈inz̈cu, cjichic̈ha: —¡Pajalla, jaziqui! ¿Ject am wjajtchejo? Niz̈aza zultatunacaqui Jesusiz̈ yujcquiz c̈hajczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nii ora Pedruqui kjuy patiuquiz z̈elatc̈ha. Nekzi tsjaa z̈onqui tjonchinc̈ha. Naa z̈onqui timplu tsjan chawjc jilirz̈ piyunitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pedruz̈ uj latuquiz kutnan, cherchinc̈ha. Nekztan paljaychinc̈ha: —Amqui nii Nazaret wajtchiz z̈oñz̈tan chica ojklayñamla, nii Jesusiz̈tan. ");
INSERT INTO capNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pedruqui Jesusa ana pajñi chiichic̈ha: —Nii z̈oñi anal pajuc̈ha. Am takumi anal intintuc̈ha. Nuz̈ chiiz̈cu, zancu ulanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nicju naa z̈onqui wilta cherchinzakazza. Nii z̈ejlñi z̈oñinacz̈quiz maazinc̈ha, tuz̈ cjican: —Tii z̈oñicha ninacz̈tan chica ojklayñi. ");
INSERT INTO capNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedruqui wilta Jesusa ana pajñi chiichic̈ha. Nekztan tsjii upaquiz̈tan nii z̈ejlñi z̈oñinacaqui Pedruz̈quiz cjichizakazza: —Chekapan amqui ninacz̈tan chica ojklayñi z̈oñimla. Amqui Galilea wajtchiz z̈oñimla. Nii z̈oñinacz̈ irataz̈ chiiñamla. ");
INSERT INTO capNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Nekztan Pedruqui juramintuz̈tan chiichic̈ha, tuz̈ cjican: —Wejr toscara chiichinz̈laj niiqui, Yooziz̈ castictal cjila. Tii amiz̈ chiita z̈oñi ana wira pajuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pizcquizic nii orapacha tsjii wallpaqui kjawchic̈ha. Nekztanaqui Pedruqui Jesusiz̈ chiita taku cjuñzic̈ha. Tuz̈ mazinchitac̈ha, “Ima wallpaz̈ pizc wiltaz̈ kjawan, amqui c̈hjep wilta wejr ana pajñim tucaquic̈ha”. Nekztanaqui Pedruqui nii cjuñz̈cu, ancha llaquita cjissic̈ha. Nekztan ancha kaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kjantati timplu chawjc jilirinacz̈tan wajt jilirinacz̈tan judío lii tjaajiñinacz̈tan tjappacha jilirinacz̈tan ajczitac̈ha. Nekztan Jesusa c̈hejlz̈cu Pilato jilirz̈quin chjitchic̈ha. Nekztan niiz̈quiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nekztan Pilatuqui pewczic̈ha: —¿Am judionacz̈ chawjc jilirimya? Jesusaqui kjaazic̈ha: —Nuz̈upanzac̈ha, amiz̈ chiitacama. ");
INSERT INTO capNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Nekztan nii timplu jilirinacaqui Jesusiz̈ quintra c̈hjultaki tjojtunchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilatuqui pewczizakazza: —¿Kjaz̈tiquiztan am ana kjaazñi atjo? Tjapamanaz̈ am quintra chiila, pero. ");
INSERT INTO capNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesusaqui ana c̈hjulu tawkz̈cu z̈elatc̈ha. Nuz̈quiz Pilatuqui ana iya c̈hjulumi chiiz̈iñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilatuqui pascu pjijztiquiz tsjii piriz z̈oñi cutzñipantac̈ha z̈oñinacaz̈ chiitacama. ");
INSERT INTO capNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Carsilquiz tsjii kjaz̈ultan gobierno quintri z̈oñinacaz̈ chawjcta z̈elatc̈ha. Barrabás cjita ujchiz z̈oñi carsilquiz chawjctazakaztac̈ha. Revolucionquiz z̈oñi conchic̈ha Barrabás cjita z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jaziqui z̈oñinacaqui Pilatu pewczñi tjonchic̈ha, tuz̈ cjican: —Wejtnacalta tsjii z̈oñi cutz̈inalla. Tuquitanpacha nuz̈ cutzñampanla amqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilatuqui kjaazic̈ha: —¿Anc̈hucqui pecya, tii judionacz̈ chawjc jiliri cutzta cjisjapajo? ");
INSERT INTO capNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jesusa c̈hjaawjcu, nii timplu jilirinacaqui Pilatuz̈quiz intirjichic̈ha; nii zizzic̈ha Pilatuqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Nekztan nii timplu jilirinacaqui Jesusiz̈ quintra z̈oñinaca aptjapchic̈ha. Nekztan z̈oñinacaqui maychic̈ha, Barrabaspankaz cutzta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilatuqui wilta pewczic̈ha: —¿Tiizti? ¿Jaknuz̈t wejr paaj cjii anc̈hucjo? Anc̈hucqui tii judionacz̈ jiliric̈ha cjinc̈hucla. ");
INSERT INTO capNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nii z̈oñinacaqui kjawchic̈ha: —¡Tii z̈oñi conzna! ¡Cruzquiz ch'awczna! ");
INSERT INTO capNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Nekztan Pilatuqui chiichic̈ha: —¿Kjaz̈tiquiztan, c̈hjul uj paachit teejo? Nii z̈oñinacazti juc'anti kjawchic̈ha: —¡Cruzquiz ch'awczna! ");
INSERT INTO capNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatuqui nuz̈quiz z̈oñinacz̈ kuz wali cjisjapa Barrabás cutzic̈ha. Jesusa cusa wjajtkatz̈cuqui, Pilatuqui zultatunacz̈quiz intirjichic̈ha, cruzquiz ch'awcta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nekztan nii zultatunacaqui jilirz̈ kjuy patiuquin Jesusa chjitchic̈ha. Nekzi parti zultatunaca ajcznajo kjawzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nekztan Jesusiz̈quiz tsjii morat zquiti tjutzic̈ha. Niz̈aza tsjii ch'apirar pillu irata niz̈tiz̈tan Jesusiz̈ achquiz scarzinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Nekztan ararcan kjawchic̈ha: —¡Viva tii judío nacionz̈ chawjc jiliri! —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nekztan tsjii parz̈tan Jesusiz̈ achquiz t'etkatchic̈ha; llawsiz̈tan tjujtchic̈ha; rispittaz̈oka quillsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nekztan burla paaz̈cuqui Jesusiz̈quiztan nii morat zquiti chjojkz̈inchic̈ha. Niiz̈ persun zquiti tjutzic̈ha. Nekztanaqui Jesusa chjitchic̈ha cruzquiz ch'awczjapa. ");
INSERT INTO capNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tsjii Cirene wajtchiz z̈oñi z̈elatc̈ha, Simón cjita. Pucultan z̈oñz̈ ejptac̈ha niiqui, Rufo, niz̈aza Alejandruz̈ ejp. Jochquiztan kajkz̈catc̈ha. Nekz watan mantichic̈ha, Jesusiz̈ cruza kuz̈ajo. Nuz̈quiz uytissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nekztan Jesusaqui Golgota yokquin chjichtatac̈ha. Golgota cjitaqui tuz̈ cjic̈ha: “Ach Tsjij Yokac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Nekztan Jesusiz̈quiz vinu mirrz̈tan t'ajz̈ta tirinchic̈ha. Jesusazti ana licz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jalla nekztanaqui cruzquiz ch'awcz̈cu, sultatunacaqui zurtiychic̈ha niiz̈ zquitinaca tanzjapa, jakzilta sultatut nii zquiti tanznac̈haja, nii zizjapa. ");
INSERT INTO capNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Wenzlaka Jesusaqui cruzquiz ch'awctatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kjaz̈tiquiztan tii z̈oñi cruzquiz ch'awctataz̈laja, niiqui cjijrchic̈ha tsjii tawliquiz, tuz̈ cjican: “Tiiqui judionacz̈ chawjc jiliric̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jesusiz̈tan chicapacha tsjii pucultan tjañinaca yekja cruzanacquiz ch'awctazakaztac̈ha, tsjiic z̈ew kjuttan tsjiic zkar kjuttan. ");
INSERT INTO capNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nuz̈upan tuquitan cjijrta Yooz taku cjic̈ha. Nii Yooz taku tuz̈ cjic̈ha: “Ujchiz z̈oñinacz̈tan chica uchtac̈ha”. Nuz̈quiz nii Yooz takuqui cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Z̈oñinacaqui nekz watcan acha wewcz̈inchic̈ha; ancha z̈awjchi, tuz̈ cjican: —¡Aaj! Amqui timplu pajltasac̈ha. Nekztan c̈hjep majquiziqui wilta kjuytasac̈ha, jalla nuz̈ cjichamc̈ha, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jaziqui persunpacha am cruzquiztan zarakalla. Persunpacha liwriyalla amqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Niz̈aza nii timplu chawjc jilirinacz̈tan judío tjaajiñinacz̈tan parlassic̈ha, Jesusa iñarcan, tuz̈ cjican: —Yekjapanacz̈quiz liwriichic̈ha tiiqui. Persunpachazti anaz̈ liwrii atc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristuz̈laj niiqui, Israel nacionz̈ chawjc jiliriz̈laj niiqui, persunpachaj cruzquiztan apakscu, chjijwz̈quila. Nekz criyaquiz̈ uc̈humqui. Z̈oñinacaqui Jesusa iñarchic̈ha. Niiz̈tan chica ch'awcta z̈oñimi iñarchizakazza. ");
INSERT INTO capNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Taypurquiztan tjapa nii yokac zumchi cjissic̈ha, majñakak oracama. ");
INSERT INTO capNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nii ora Jesusaqui tjapa aztan kjawchic̈ha: —Eloi, Eloi ¿lama sabactani? —Tii takuqui cjic̈ha: “Wejt Yooz, wejt Yooz ¿kjaz̈tiquiztan wejr ecchamtajo?” ");
INSERT INTO capNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Yekjap nekz z̈ejlñinacaqui nii taku nonz̈cu cjichic̈ha: —Nonz̈na. Elías kjawz̈a tiiqui, nii tuquitan Yooz taku parliñi profetaqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Tsjiiqui ninacz̈quiztan zajtchic̈ha. Nekztan tsjii esponja cjita kjaz licñiquiz jar vinu licskatchic̈ha. Nekztan quejpz̈cu tsjii parquiz tsjijpchi Jesusiz̈quiz macjatskatchic̈ha nii jar vinu ch'umznajo. Nekztan nii z̈oñiqui parti z̈oñinacz̈quiz chiichic̈ha: —Tjewz̈la uc̈humqui. Jaknuz̈ukat Eliasac cruzquiztan apaki tjonac̈hani, niiz̈ chekz̈la. ");
INSERT INTO capNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesusaqui juc'anti kjawchic̈ha. Nuz̈quiz ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nii oraqui pajk timplu pañu juystokaz chicatquiz wjajrsic̈ha, tsewctan kozzuc. ");
INSERT INTO capNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nii romanz̈ sultatunacz̈ jiliriqui Jesusiz̈ yujc kjuttan z̈elatc̈ha. Tjappacha niiz̈ wattanaca cherz̈cu cjichic̈ha: —Chekapan Yooz Majchtakalc̈ha tii z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Niz̈aza tsjii kjaz̈ultan maatakanacaqui az̈quiztan chekzic̈ha. Nii maatakanacaqui tinacatac̈ha: María cjititac̈ha, Magdalena wajtchiz z̈onqui. Nekztan María cjitizakaztac̈ha, Josez̈ maa, niz̈aza Jacobz̈ maa (lajktac̈ha Jacoboqui). Nekztan Salomé cjititac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nii maatakanacaqui Jesusa apzitac̈ha, niz̈aza yanapchitac̈ha, Jesusa Galilea yokaran ojklayan nii ora. Nekztan ninacaqui Jesusiz̈tan chica Jerusalenquin tjonchic̈ha. Nii cruzaz̈ nekziqui muzpa maatakanaca z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Nii noojiqui pjijzta tjacz tjuñitac̈ha. Jeejz tjuñi ispirazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Niz̈tiquiztan tjuñiz̈ kattan tsjii José cjita Arimatea wajtchiz z̈oñiqui walja tjup kuzziz Pilatuz̈quin ojkchic̈ha. Nekztan Jesusiz̈ curpu maychic̈ha. Walja rispitta jiliritac̈ha nii Josiqui. Yooz tjapa mantiz timpu tjewznatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Niiz̈ tjontiquiztan, Pilatuqui ispantichic̈ha, tuz̈ cjican: —¿Kjaz̈t waj ticzi cjesajo? Nekztan zultatz̈ jiliri kjawzic̈ha, nii pewczjapa. ");
INSERT INTO capNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Nii zultatz̈ jiliriqui kjaazic̈ha: —Jesalla, ticzic̈ha, —cjican. Nekztan Pilatuqui Jesusiz̈ curpu chjitzjapa permiso tjaachic̈ha José cjita z̈oñz̈quiz: —Niz̈taqui niiz̈ curpu chjichalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nekztan Josiqui zuma chiw pañu kjaychic̈ha. Jesusiz̈ curpu chjijunz̈cu nii pañquiz tejlzic̈ha. Nekztan tsjii sipulturquiz majkzic̈ha. Nii sipulturaqui pajk mazquiz pjettatac̈ha. Nii sipulturz̈ zana tsjii pajk maztan pjuczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pucultan maatakanacaqui Jesusiz̈ curpu tjatñi cherchic̈ha. Tsjaaqui María Magdalena cjititac̈ha. Tsjaac María cjitizakaztac̈ha, yekja Josiz̈ maa. ");
INSERT INTO capNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judionacz̈ jeejz tjuñi jakataz̈u María Magdalenatan Jacobz̈ maa Mariatan Salomatan, nii c̈hjepultan maatakanacaqui cusa ulurchiz asiiti kjaychic̈ha, Jesusiz̈ ticzi curpu tjajlinzjapa. ");
INSERT INTO capNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ancha wentan ninacaqui sipultura cherzñi ojkchic̈ha tjuñiz̈ tewctanalla. ");
INSERT INTO capNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Sipultura ojkcan ninacpora parlassic̈ha tuz̈ cjican: —¿Jequit uc̈humtaqui cjetz̈inaquejo? ¿Nii pjucz̈ta pajk mazjo? ");
INSERT INTO capNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Nekztan irantiz̈cu, nii pajk pjucz̈ta mazqui cjetz̈ta cherzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sipultura luzcu, z̈ew latu kjuyltan tsjii tol chiw zquitchiz tjowa julzi cherchic̈ha. Nuz̈quiz nii maatakanacaqui ancha tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nii tjowaqui paljaychic̈ha, tuz̈ cjican: —Anaz̈ tsuca maataka. Anc̈hucqui Jesusaz̈ kjurc̈ha, nii cruzquiz ch'awcta z̈oñi. Niiqui jacatatchic̈ha jaziqui. Anac̈ha tekzi. Cherznalla. Tii sipulturquiz ana z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jazic anc̈hucqui oka. Niiz̈ tjaajinta z̈oñinacz̈quin mazca. Pedruz̈quizimi zaka mazna. Tuz̈ cjican anc̈huc maznaquic̈ha: “Jesusaqui anc̈hucaz̈ tuqui okjayaquic̈ha Galilea cjita yokquin. Nekzi Jesusiz̈tan zalaquic̈ha anc̈hucqui. Jaknuz̈t tuquitan chiiz̈inchipanc̈haja, jalla nuz̈uc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nekztanaqui nii maatakanacaqui sipulturz̈quiztan ulanz̈cu, zati pariju quejpchic̈ha, tsucaña chjekincan. Tsucaña ana c̈hjulumi chiyi atchic̈ha jecz̈quizimi. ");
INSERT INTO capNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesusaqui kjantatilla jacatatz̈cuqui primiraqui María Magdalenaquiz parizichic̈ha. Tuquitan Jesusaqui naaquiztan pakallaku zajranaca chjatkatchitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Naa z̈onqui Jesusiz̈ mazinacz̈quin mazñi ojkchinc̈ha. Ninacaqui llaquita z̈elatc̈ha, kaacan. ");
INSERT INTO capNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nekztan mazzinc̈ha: —Jesusaqui jacatatchic̈ha. Wejrqui nii cherchinc̈ha, —cjican. Nii nonz̈cu nii tjaajinta z̈oñinacaqui ana criichic̈ha. Inapanka chiitaz̈oka naychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wiruñaqui pucultan tjaajinta z̈oñinacaz̈ wajtquiztan okan, Jesusaqui parizichizakazza, tsjemata cjissi. ");
INSERT INTO capNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nekztan quejpz̈cu, nii pucultanaqui parti tjaajintanacz̈quiz mazzic̈ha. Nii mazta ana zakaz criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wiruñaqui Jesusaqui nii tuncamani tjaajinta z̈oñinacz̈quiz parizichic̈ha, c̈hjeri lulan. Ninacaqui jacatatta maztaqui ana criichic̈ha. Nekztan ninacz̈ ana criiñi kuzziz cjen ninacz̈quiz iwjt'ichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Niz̈aza Jesusaqui mantichic̈ha, tuz̈ cjican: —Jazic anc̈hucqui okaquic̈ha tjapa kjutñi tii muntu intiru. Tjapa z̈oñinacz̈quizimi liwriiñi taku paljayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Jakziltat tii taku criic̈haja, jalla niiqui liwriitaz̈ cjequic̈ha; niz̈aza bautista cjequic̈ha. Jakziltat tii taku ana criic̈haj niiqui, ancha castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yooz taku criichinacaqui tii milajrunaca paaquic̈ha. Wejt tjuuquiz zajranaca chjatkataquic̈ha. Yekja takunaca chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Zkora tanz̈cu zkorz̈quiz ana chjojrichtaz̈ cjequic̈ha. Tsjii veneno licz̈cu, ana ticznaquic̈ha. Kjarz̈tan lanz̈cu, laa z̈oñinaca c̈hjetnaquic̈ha. Niz̈ta paaquic̈ha Yooz taku criichi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nii taku chiiz̈cu chawjc jilir Jesusaqui arajpacha ojkchic̈ha. Nekzi Yooz z̈ew latuquiz julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nekztanaqui nii tjaajinta z̈oñinacaqui ulanz̈cu, tjapa kjutñi Yooz liwriiñi taku paljaychic̈ha. Chawjc jiliripanc̈ha Jesucristuqui. Jalla niic̈ha ninacz̈quiz yanapñiqui. Nii Yooz aztan paata milajrunacaqui tuz̈ cjic̈ha: “Tii Yooz takuqui werarapanc̈ha”. Nuz̈upanz̈ cjila. Amén.");
INSERT INTO capNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ancha zuma Teófilo, tii cartal amquin cjijrz̈cuc̈ha, Jesucristuz̈ puntuquiztan. Jesucristuz̈ nasta tjuñquiztanpacha jaknuz̈t watc̈haja, jalla niiqui ana tjatzic̈ha cherchi z̈oñinacaqui. Nii cherchi z̈oñinacaqui wejtnacaquiz tjaajinchic̈ha. Niz̈aza yekja z̈oñinacz̈quiz tjaajinchizakazza Jesucristuz̈ puntuquiztan. Nekztan tsjii kjaz̈ z̈oñinacaqui Jesucristuz̈ puntuquiztan cjijrchic̈ha niiz̈ jaru niiz̈ jaru. ");
INSERT INTO capNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Niz̈aza wejrqui zumpacha pewcpewczinc̈ha jaknuz̈t Jesucristuz̈ nasta tjuñquiztanpacha watc̈haja, jalla nii. Jalla nuz̈ pewcpewcz̈cu wejrqui pinsichinc̈ha Jesucristuz̈ puntuquiztan cjijrzjapazakaz niiz̈ jaru niiz̈ jaru. “Jalla niic waliz̈ cjesac̈ha”, cjican pinsichinc̈ha wejt kuzquiz. Jaziqui walja zuma Teófilo, amquin tii cartal cjijrz̈cuc̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Jesucristuz̈ puntu tjaajintanaca zumpacha zizajo. ");
INSERT INTO capNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ima Juan Bautistaz̈ nasan jalla tuz̈ watchic̈ha. Judea yokquin Herodes cjita pajk jiliriqui mantiñitac̈ha. Niz̈aza Zacarías cjita timplu cwitiñi z̈oñi z̈elatc̈ha. Niiqui Abías cjita t'akquiztantac̈ha. Niiz̈ tjun cjititac̈ha Elisabet. Ninacaqui Aarón cjita tuquita atchi ejpz̈quiztan tjonñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Nii pucultan lucutiñ z̈oñiqui Yooz yujcquiziqui zuma kamañchiztac̈ha. Yooz Epiz̈ mantitacama kamñitac̈ha. Jalla nuz̈ kaman ana c̈hjul ujmi ninacz̈ quintra tjeezñi atasac̈ha jecmi. ");
INSERT INTO capNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ninacaqui ana zinta majchchiztac̈ha. Elisabet cjitiqui ana wira matiñtac̈ha. Nii oraqui pucultan lucutiñi chawc chawcwatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tsjii nooj Zacarías t'akquiztan turnuz̈ tjonatc̈ha, Yooz sirwizjapa timpluquiz. Jalla niz̈tiquiztan Zacariasqui Yooz sirwatc̈ha timpluquiz. ");
INSERT INTO capNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nii timplu cwitiñinacaqui tsjii z̈oñi inzinzu tjaazñi illzñipantakalc̈ha. Nekztan Zacariiz̈quiz illzic̈ha. Jalla nuz̈ illztaz̈ cjen Zacariasqui Yooz timpluquiz luzzic̈ha, inzinzu tjaazñi. ");
INSERT INTO capNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jalla nii inzinzu tjaazñi oraqui tama z̈oñinacaqui Yoozquin mayizican z̈elatc̈ha timplu zancu. ");
INSERT INTO capNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jalla nekztanaqui tsjii Yooz anjilaqui Zacariiz̈quiz parisquichic̈ha timpluquiz. Nii anjilaqui inzinzu altarz̈ z̈ew latuquiz tsijtsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Anjila cherz̈cu Zacariasqui kuz turwaysi cjissic̈ha, ancha tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anjilaqui cjichic̈ha: —Zacarías, ana am tsuca. Yoozqui amiz̈ mayizitaqui nonzic̈ha. Jalla niz̈tiquiztan Yoozqui am Elisabet cjiti tjunaquiz lucmajch wawaz̈ majtkataquic̈ha. Jalla nuz̈ majttan am wawaqui Juan cjita tjuuchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","Jalla nii am majchqui walja pajk jiliriz̈ cjequic̈ha Yooz Ejpz̈ yujcquiziqui. Jalla nii majttiquiztanaqui, amqui cuntintum cjequic̈ha, walja chipsnaquic̈ha. Niz̈aza walja zoñinacami chipsnaquic̈ha, am tjunaz̈ majttiquiztanaqui. Am majchqui vinumi awarintimi ana licaquic̈ha. Ima maa pjuchquiztan ulnan Yooz Espíritu Santuqui am majch kuzquiz luzaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Am majchqui walja Israel wajtchiz z̈oñinaca Yooz Ejpz̈quin wilta sirwizkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Niz̈aza am majchqui ima Jesucristuz̈ ojklayan ojklayaquic̈ha, Yooz taku paljaycan. Cjuñzna. Tuqui timpuqui tsjii Yooz puntu paljayñi profeta z̈elatc̈ha, Elías cjita. Yooz Espíritu Santuqui nii Eliasquiz Yooziz̈ tjaata taku paljayskatchic̈ha. Jalla nii tjaata taku paljaychic̈ha Eliasqui, ana ekscu. Yoozquin tjurt'iñi kuzziztac̈ha. Jalla niz̈tapacha Yooz Espíritu Santuqui am majchquiz Yooziz̈ tjaata taku paljayskataquic̈ha. Niiz̈ paljaytiquiztan ejpz̈tanami maatinacz̈tanami wilta zumanskataquic̈ha. Niz̈aza am majch paljaytiquiztan ana Yooz kuzcama kamñi z̈oñinacami Yooz kuzcama kamñi cjisnaquic̈ha. Jalla niz̈tiquiztan Israel wajtchiz z̈oñinacaqui Yooz Majch tjonz tjuñi tjewznaquic̈ha. Zuma kamcan, ninacaqui tjewznaquic̈ha, Yooz Majch zuma risiwt'isjapa. —Jalla nuz̈ Zacariiz̈quiz paljaychic̈ha nii Yooz anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nekztan Zacariasqui anjilz̈quiz pewczic̈ha, tuz̈ cjican: —¿Ultim werara amiz̈ chiitajo? ¿Jaknuz̈t zizasajo? Wejrqui walja chawc z̈oñtla pero. Wejt maatakami chawc z̈on zakazza. ");
INSERT INTO capNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nii anjilaqui kjaazic̈ha, tuz̈ cjican: —Wejrqui Gabriel cjititc̈ha. Yooz manta payiñtc̈ha. Yoozqui wejr mantiz̈quic̈ha amquiz tii zuma takunaca maznajo. ");
INSERT INTO capNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amqui weriz̈ chiita ana criitiquiztan, upam cjisnaquic̈ha, am maati majtzcama. Yooziz̈ pinsita tjuñquiz weriz̈ chiita takuqui cumplisnaquic̈ha. —Jalla nuz̈ chiichic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Zacarías timplu kjuyltan az̈ka z̈elatc̈ha, ulanz̈quiz oraqui watatc̈ha. Jalla niz̈tiquiztan tjewzñi z̈oñinacaqui kuzquiz pinsichic̈ha, kjaz̈tiquiztan ana ulanz̈quejo, jalla nii. Z̈oñinacaqui zancu muzpa tjewznatc̈ha, Zacarías ulanz̈quizcama. ");
INSERT INTO capNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nekztanaqui Zacariasqui az̈ktanalla ulanz̈quichic̈ha. Pero ana jaknuz̈t chii atchic̈ha. Jalla niz̈tiquiztan nii zawnc z̈ejlñi z̈oñinacaqui ispantichic̈ha. “Timplu kjuyltan anjilz̈tan zalziz̈lani”, jalla nuz̈ cjeyassic̈ha. Upa cjissiz̈ cjen Zacariasqui z̈oñinacz̈quiz kjarz̈tan paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tsjii kjaz̈ majquiztan Zacariasqui timplu cwitis turnu cumplichic̈ha. Nii tjuñinaca z̈erz̈cu, persun kjuya ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Wiruñaqui niiz̈ Elisabet cjiti tjunqui ica cjissinc̈ha. Nekztan Elisabet tsjii pjijska jiiz kjuyaran z̈elatc̈ha. Ana kjuyquiztan kjuya ojklaychinc̈ha. Naaqui persun kuzquiz pinsichinc̈ha tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Yooz Jiliriqui wejr cjuñz̈cu, wejtquiz ickatchic̈ha. Jaziqui z̈oñinacaqui anaz̈ iya wejr iñarasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nekztanaqui sojta jiizquiztan Elisabet ickattanaqui, Yoozqui Gabriel cjita anjila cuchanz̈quichic̈ha Galilea cjita yokquin, Nazaret cjita wajtquiz. ");
INSERT INTO capNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nii wajtquiz tsjaa tunsill tur z̈elatc̈ha María cjiti. David cjita atchi ejpz̈quiztan tjoniñtac̈ha. Mariiqui José cjita z̈oñz̈tan kazzintac̈ha zalzjapa. Yoozqui naa Mariaquiz anjila cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Naaquiz tjonz̈cu, anjilaqui paljaychic̈ha, tuz̈ cjican: —Cullacalla, Yooz k'ayamc̈ha amqui. Yooz kjarquizza. Niz̈aza Yoozqui amtan chicapachac̈ha. Yoozqui tjapa maatakz̈quiztanam amquiz juc'ant wali favoraz̈ paaquic̈ha. —Jalla nuz̈ tsaanchic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Anjilz̈ taku nonz̈cu Mariiqui ispantichinc̈ha. Kuzquiz pinst'ichinc̈ha, nii tsaantaqui anal intintasac̈ha, cjican. ");
INSERT INTO capNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nekztanaqui anjilaqui naaquiz cjichic̈ha: —María, ana tsucaquiz̈ amqui. Yoozqui amquiz wali pajk favora paaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jalla niz̈tiquiztan amqui icaquic̈ha. Lucmajch wawchizim cjequic̈ha. Nii wawaqui Jesús cjita tjuuchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Tsjii noojiqui nii am majchqui wali pajk jiliriz̈ cjequic̈ha. Arajpach Yooz Ejpz̈ Majchpanc̈ha niiqui. Werar Yooz Ejpqui niiz̈ Majchquiz pajk mantiñi cjiskataquic̈ha, Israel wajtchiz z̈oñinacz̈japa. Am David cjita atchi ejptac̈ha tuquita pajk mantiñiqui. Jalla niz̈ta pajk mantiñi cjequic̈ha am majchqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Israel wajtchiz z̈oñinaca wiñayaz̈ mantaquic̈ha. Niiz̈ mantitaqui wiñayaz̈ z̈elaquic̈ha. Anaz̈ tucuzinznasac̈ha. —Nuz̈ paljaychic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nekztanaqui Mariiqui anjilz̈quiz pewczinc̈ha, tuz̈ cjican: —¿Jaknuz̈t tii cjesaya? Wejrqui ana luctaka pajuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nii anjilaqui kjaazic̈ha, tuz̈ cjican: —Yooz Espíritu Santuqui amquiz tjonznaquic̈ha. Jalla nuz̈ tjonan arajpach Yoozqui niiz̈ aztan tsjiriz̈takaz weezcaquic̈ha am juntuñ. Nii oraqui Yooz Espíritu Santuqui am t'icznaquic̈ha. Jalla niz̈tiquiztan nii am maatiqui juc'ant zuma lijitum kamañchiz cjequic̈ha. Yooz Majchpanc̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Niz̈aza amquiz maznuc̈ha tuz̈, am jamillquiztan Elisabet cjitiqui ickatchitac̈ha, chawc z̈on cjenami. Tuquiqui z̈oñinacaqui Elisabet puntuquiztan cjiñitac̈ha: “Naa z̈onc̈ha ana matiñqui” cjicanaqui. Jaziqui sojta jiizkaz icchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Yoozqui c̈hjulumipankaz paasac̈ha. —Jalla nuz̈ chiichic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nekztanaqui Mariiqui cjichinc̈ha: —Wejrqui Yooz Jiliriz̈ mantitacama kamiñ z̈ontc̈ha. Yoozqui wejtquizimi amiz̈ chiitacama paaj cjila. Jalla nuz̈ Mariaz̈ chiitan, anjilaqui ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nekztanaqui tsjii kjaz̈ majquiztan Mariiqui zati pariju ojkchinc̈ha Judea cjita kolta curunacchiz yokquin. ");
INSERT INTO capNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Jalla nicju Zacarías kjuya luzzinc̈ha. Kjuya luzcu Elisabetaquiz tsaanchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Nuz̈ Mariaz̈ tsaanan Elisabeta wawaqui pjuch kjuyl cjenpacha kissic̈ha. Nekztanaqui nii oraqui Espíritu Santuqui naa Elisabetaquiz luzzic̈ha niz̈aza chiikatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Jalla nekztan naaqui alto tawkz̈tan Mariaquiz paljaychinc̈ha, tuz̈ cjican: —Yoozqui amquiz tjapa maatakz̈quiztanami wali pajk favora paachic̈ha. Niz̈aza nii am majchqui walja honorchiz cjesaz̈ cjila. ");
INSERT INTO capNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Kjaz̈tiquiztan taa arajpach Jilirz̈ maaqui wejtquin tjonz̈quejo? Wejrqui inakaztc̈ha. Anal waquisuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Amiz̈ tsaanta taku nonz̈cu, wejt wawaqui pjuchquiz ancha cuntintu kis kissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Yooziz̈ apayz̈quita taku criichamc̈ha, nii Yooziz̈ chiita takucama cumplisnaquic̈ha, jalla nii criichamc̈ha. Jalla niz̈tiquiztan zuma cuntintum cjequic̈ha. Nuz̈ cjichinc̈ha Elisabetqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nekztanaqui Mariiqui chiichinc̈ha, tuz̈ cjican: “Wejt Yooz Jiliriz̈ honoral waytac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wejt Liwriiñi Yooziz̈ cjen, wejt kuzmi anchaz̈ chipc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Wejrqui inakaztc̈ha. Yooz mantitacama kamiñ z̈ontc̈ha. Yoozqui wejtquiz cjuñzquichic̈ha. Jaziqui walja azziz Yooz Ejpqui wejtquiz t'iczic̈ha. Jalla nuz̈ wejtquiz pajk obra paachic̈ha. Tekztan nawjcchuc tjapa z̈oñinacaqui wejt puntuquiztan parlaquic̈ha: ‘Yoozqui naaquiz zuma favora paachic̈ha’, cjican. Werar Yoozqui jecz̈quiztanami juc'anti zumapankazza. ");
INSERT INTO capNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Yoozqui tjapa niiz̈quin rispitñi z̈oñinacz̈quiz okzñipanc̈ha, watay wata okzñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Yoozza walja pajk obranaca paañiqui. Mit kuzziz z̈oñinacaz̈ pinsitanaca inakaz cjissa. ");
INSERT INTO capNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Walja azziz jilirinaca jwessa ninacz̈ puestuquiztan. Antiz humilde kuzziz z̈oñinaca honorchiz cjiskatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Niz̈aza jakziltat ana cusasanacchiz t'akjiri z̈ejlc̈haja, jalla nii t'akjirinacz̈quiz walja cusasanaca tjaaquic̈ha Yoozqui. Antiz ricachunzcazti laachi kjarquiz ana c̈hjulchiz quejpkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Niz̈aza Yoozqui uc̈hum tuquita atchi ejpnacz̈quizimi, Abrahamz̈quizimi, Abrahamz̈ majchmaatinacz̈quizimi, jalla ninacz̈quizimi taku tjaachic̈ha, ninaca tirapan okznajo. Jalla nuz̈ okz̈cu Yoozqui walja yanapc̈ha Israel wajtchiz Yooz sirwiñi z̈oñinacz̈quin, ninaca ana tjatsñic̈ha”. Jalla nuz̈ chiichinc̈ha Mariiqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Tsjii c̈hjep jiiz Mariiqui Elisabetatan kamchinc̈ha. Nekztan quejpchinc̈ha naaz̈a persun kjuya. ");
INSERT INTO capNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Naa Elisabeta majtz tjuñiqui irantiz̈quichic̈ha. Nekztan lucmajch wawa majtchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jalla nuz̈ cjen, Yoozqui Elisabetaquiz ancha zuma favora paachic̈ha. Jalla nii quintu zizcuqui, Elisabeta wisinunacami jamillanacami naaquin tjonzñi ojkchic̈ha. Nekztan ninacaz̈ tjonz̈tan, Elisabetaqui ancha cuntintutakalc̈ha. Ninacami cuntintuzakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jalla nekztan quinsakal tjuñquiztan Zacariastan Elisabetatan timplu ojkchic̈ha wawa chimpus cuztrumpi paakatzjapa. Nii cuztrumpi paatan ejpz̈ tjuuz̈tan tjuuzkatz pecatc̈ha, Zacarías cjican. ");
INSERT INTO capNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Wawz̈ maaqui cjichinc̈ha: —Anaz̈. Tii wejt maatiqui Juan cjita tjuuchizpanz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Partinacazti pewczic̈ha: —¿Kjaz̈tiquiztan niz̈ta tjuuskatz pecjo? Am jamillanacquiztan anaz̈ niz̈ta tjuuqui z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jalla nekztanaqui wawz̈ ejpz̈quiz kjarz̈tan pewczic̈ha, c̈hjul tjuuchizim pecas, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ejpqui tsjii maychic̈ha, tjuu cjijrzjapa. Nekztanaqui cjijrchic̈ha, tuz̈ cjican: “Wejt maatiqui Juan cjitaz̈ cjequic̈ha”. Nekztanaqui tjappacha ispantichic̈ha nii puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nii orapacha Zacariasqui wilta chiiñi cjissic̈ha. Jalla nuz̈ wilta chii atcan, Yooz honora paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jalla nuz̈ cjen wisinunacami ispantichi quirchic̈ha. Tjapa kjutñi nii Judea yokaran nii quintu ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tjappacha nii quintu zizñi z̈oñinacaqui kuzquiz pinsichic̈ha: “¿Tii uzaqui c̈hjulut cjisnaquejo?” cjican. Yooz kjarquizpantac̈ha nii wawaqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nekztanaqui Yooz Espíritu Santuqui Zacariiz̈quiz chiikatchic̈ha. Jalla niz̈tiquiztan Zacariasqui Yooziz̈ tjaata takucama paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Yooz Jiliri honorchiz cjilalla. Niic̈ha Israel z̈oñinacz̈ Yoozqui. Uc̈hum Yoozqui niiz̈ mantitacama kamñi z̈oñinacz̈quin cjuñzic̈ha. Jaziqui liwriita cjequic̈ha uc̈humqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yoozqui walja azziz Liwriiñi cuchanz̈quichic̈ha, uc̈humnacaquiz. Davidz̈ majch maatinacz̈quiztanpacha majttac̈ha nii Liwriiñiqui. David cjitaqui Yooz mantitacama kamñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tuqui timpuquiztanpacha jalla nuz̈upan Yoozqui taku tjaachic̈ha. Yooz taku paljayñi z̈oñinacaqui niiz̈ jaru niiz̈ jaru nii Yooziz̈ tjaata taku mazmazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nii maztaqui tuz̈utac̈ha: ‘Liwriitac̈humz̈ cjequic̈ha, uc̈hum quintra z̈oñinacz̈quiztanami, uc̈hum chjaawjkatñi z̈oñinacz̈quiztanami’. ");
INSERT INTO capNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Yooz Ejpqui uc̈hum tuquita atchi ejpnacz̈quiz taku tjaachic̈ha, tuz̈ cjican: ‘Wejrqui anc̈hucaquiz tira okzniñc̈ha. Weriz̈ zuma tjaata taku anal tjatsnac̈ha’. ");
INSERT INTO capNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Niz̈aza Yooz Ejpqui uc̈hum tuquita Abraham ejpz̈quiz taku juramintuz̈tan tjaachic̈ha, niijapami uc̈humjapami. ");
INSERT INTO capNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Uc̈hum quintra z̈oñinacz̈quiztanami liwriitanaqui, uc̈humqui ana ekscu Yoozquin sirwasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Niz̈aza uc̈humqui Yooz kuzcamakaz zuma lijituma kamaquic̈ha. Jalla nuz̈ kamcan uc̈humqui Yooz sirwaquic̈ha ticzcama”. ");
INSERT INTO capNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Niz̈aza Zacariasqui tira paljaychic̈ha, tuz̈ cjican: “Juan, wejt maati, amqui Jesús Jilirz̈ tjonz tuqui ojklayaquic̈ha, Israel z̈oñinaca nii zuma tjewznajo. Amqui jaknuz̈t z̈oñinacz̈ ujnacami pertunta cjec̈haja, jalla nii intintiskataquic̈ha. Z̈oñinacz̈ ujnaca pertunta cjen, liwriitaz̈ cjequic̈ha. Jalla nuz̈ intintiskattiquiztanaqui profeta cjitam cjequic̈ha amqui, arajpach Yooziz̈ tjaata taku paljayni profeta. ");
INSERT INTO capNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Yoozqui uc̈hum ancha okzñiz̈ cjen uc̈hum liwriyaquic̈ha. Tsewctanpacha tsjii Liwriiñi cuchanz̈quichic̈ha, uc̈hum kuzquiz tjuñiz̈takaz kjanajo. Jalla niz̈tiquiztan ew timpuz̈takaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Jalla nii Liwriiñiqui zuma kjanacamapanz̈ Yooz zuma kamañ jicz tjeeznaquic̈ha, zumchiquiztakaz kamñi z̈oñinacz̈quizimi, ticzquiztan eksñi z̈oñinacz̈quizimi. Niz̈aza nii Liwriiñiqui uc̈hum zuma irpaquic̈ha, Yooz Ejpz̈tanami uc̈humtanami zumanznajo”. Jalla nuz̈ cjichic̈ha Zacariasqui. ");
INSERT INTO capNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nekztanaqui nii Juan cjita uzaqui pajkchic̈ha. Zapuru juc'anti Yoozquin tjurt'iñi kuzziztac̈ha. Jalla nekztanaqui tsjii ch'ekti yokquin ojklayatc̈ha, Israel wajtchiz z̈oñinacz̈quiz niiz̈ obra tjeezcama. ");
INSERT INTO capNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Jalla nii timpuquiz tsjii walja chawc jiliri z̈elatc̈ha, Augusto cjita. Nii chawc jiliriqui mantichic̈ha, tuz̈ cjican: —Tjappacha z̈oñinacaqui tjuu apuntiskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Nii timpuquiz Cirenio cjita jiliri z̈elatc̈ha, Siria yokchiz z̈oñinaca mantiñi. Jalla nii timpuquiz primir censuqui watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Nekztanaqui tjapa z̈oñinacaqui persun watja ojkspantac̈ha, persun tjuu apuntiskati. ");
INSERT INTO capNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jalla nuz̈ cjen José cjita z̈oñiqui Galilea cjita provinsiquiztan, Nazaret cjita wajtquiztan ulanz̈quichic̈ha. Judea cjita provinsiquin, Belén cjita wajtquin ojkchic̈ha. Jalla nicju David cjita tuquita atchi ejpqui nassitac̈ha. Davidz̈ majchmaatquiztan tjonñitac̈ha Josequi. ");
INSERT INTO capNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jalla nuz̈ cjen nicju ojkchic̈ha, tjuu apuntiskati. María cjiti turatan zalzjapa kazzitac̈ha Josequi. Nii oraqui naa Mariiqui Espíritu Santuz̈ t'icz̈tatac̈ha. Juztan Mariatan pucultan ojkchic̈ha, tjuu apuntiskati. ");
INSERT INTO capNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén wajtquin irantiz̈cu, María majts oraqui tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jalla nicju Mariiqui primir wawa majtchinc̈ha, Belén wajtquiz, animalz̈ tjajz kjuyquiz. Wawaqui pañ awallz̈tan capz̈tatac̈ha. Jalla nuz̈ capz̈cu animalz̈ tjajz kjuyquiz t'apz̈tatac̈ha. Anaz̈ iya alujamintu wajtchucatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén wajt z̈catiran uuzi itzñi awatirinaca z̈elatc̈ha. Awatirinacaqui pakara uuzi itzñitac̈ha pamparanpacha. ");
INSERT INTO capNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jalla nuz̈ z̈elan tiripintit Yooz anjilaqui jecz̈quichic̈ha. Tsewctan ninacz̈ kjutñi walja kjanz̈quichic̈ha. Nuz̈ cherz̈cu ninacaqui ancha tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jalla nekztanaqui nii anjilaqui cjichic̈ha: —Ana tsuca anc̈hucqui. Zuma quintul zjijcz̈cuc̈ha. Tsjii Liwriiñiqui tjapa z̈oñinacz̈tajapa cuchanz̈quitac̈ha. Jalla niiz̈ cjen z̈oñinacaqui zuma cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tii zeziqui Davidz̈ wajtquiziqui tsjii wawa majttac̈ha. Jalla niiqui Jesucristo Yoozza, anc̈huc Liwriiñi. ");
INSERT INTO capNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Anc̈hucqui nii wawa wachaquic̈ha pañ awallz̈tan capz̈ta; niz̈aza animalz̈ tjajz kjuyquiz t'apz̈ta wachaquic̈ha. Jalla nuz̈ waz̈taz̈ cjen siñala cuntaz̈takaz cjequic̈ha. Jalla nuz̈ cjenaqui anc̈hucqui zizaquic̈ha, chekapan weraraz̈ chiitkalala, niiqui. —Nuz̈ cjichic̈ha anjilaqui. ");
INSERT INTO capNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jalla nekztan anjilz̈tan chica tama Yooz anjilanacaqui tsewctan jecz̈quichizakazza. Yooz anjilanacaqui Yooz honora waytichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Tsewcta arajpach Yooz honorchiz cjilalla. Niz̈aza tii yokquiziqui Yooz okz̈ta z̈oñinaca zuma cuntintu kuzziz cjilalla. ");
INSERT INTO capNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jalla nuz̈ chiiz̈cu, Yooz anjilanacaqui tsewc arajpacha quejpchic̈ha. Nekztan nii awatirinacaqui porapat parlassic̈ha, tuz̈ cjican: —Anjilaz̈ maztaqui arajpach Yoozquiztan tjonchikalala. Tsjii Liwriiñi majttakalala. Jalla nii cheriz̈ Belén watjaz̈ ojklalla. ");
INSERT INTO capNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jalla nekztanaqui awatirinacaqui zati pariju ojkchic̈ha. Belén wajtquin animalz̈ tjajz kjuyquiz luzzic̈ha. Nekzpacha awatirinacaqui zalchic̈ha Mariatan Juztan wawa t'apzi. ");
INSERT INTO capNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ninacz̈tan zalz̈cu tjappacha Yooz anjilaz̈ chiitanaca nii wawz̈ puntuquiztan quint'ichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Awatirinacaz̈ nuz̈ maztiquiztan, tjappacha nonz̈ñi z̈oñinacaqui ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariizti persun kuzquiz nii mazta chjojchinc̈ha. Nii mazta puntuquiz pinsican walja pinsamintu aptazzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Awatirinacaqui uuzi ichi quejpchic̈ha. Niz̈aza Yooz honora paljaychic̈ha, tuz̈ cjican: —Yoozza chekanaqui. Ancha walic̈ha uc̈humz̈ nonz̈tanaca, uc̈humz̈ chertanacami. Yooz anjilaz̈ chiitacama niz̈tapacha cherchinc̈humla. —Jalla nuz̈ cjican Yooz honora waytissic̈ha awatirinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Majttiquiztan quinsakal tjuñquiziqui jalla nekztan nii wawz̈quiz chimpuz cuztrumpi paachic̈ha. Ima Mariaz̈ ican, Yooz anjilaqui Mariaquiz chiichic̈ha, “Jesús cjita cjequicha amiz̈ primir majtta wawaqui”. Jalla niz̈tiquiztan nii anjilaz̈ chiita tjuuz̈tan tjuuzkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tuquitanpacha tsjii taku mantichic̈ha Moisesqui, tuz̈ cjican: “Majtz̈cu ima pusi tunc tjuñiz̈ cjen, maatakanacaqui Yooz sirwiz cuzturumpinaca ana payi atasac̈ha. Pusi tunc tjuñiz̈ tjonan, timpluquiz tsjii cuztrumpi paazpanc̈ha. Jalla nekztanaqui wilta Yooz sirwiz cuztrumpiz̈ paasac̈ha”. Jalla niz̈tiquiztan majtta tjuñquiztan pusi tunc tjuñi pjojkan Juztan Mariatan ninacz̈ wawa chjitchic̈ha Jerusalén cjita watja. Jalla nicju timpluquin ojkchic̈ha wawa Yoozquin cumpjii. ");
INSERT INTO capNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Tsjii Yooz liiqui tuz̈ cjichic̈ha, “Primir lucmajch wawa majtz̈cu, Yoozquin cumpjitaz̈ cjequic̈ha Yooz sirwajo”. Nuz̈ Yooz lii ut'aysiz̈ cjen lii jaru cumplichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Yooz mantita lii jaru nii lucutiñiqui ojkchic̈ha. Yooz liiqui zakaz cjic̈ha: “Tsjii pariza paluma uz tsjii pariza wez̈la palomaz̈takaz Yoozquin tjaaspanc̈ha”. Jaziqui nuz̈upan Yoozquin tjaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Nii timpuqui Jerusalenquiz tsjii Simeón cjita z̈oñi z̈elatc̈ha. Nii z̈oñiqui Yooz kuzcama kamñitac̈ha; Yooz lii jaru kamñitac̈ha. Niz̈aza Israel wajtchiz z̈oñinacz̈ Liwriiñi tjewzic̈ha. Simeonqui Espíritu Santuz̈ irpita z̈oñipantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santuqui Simeonz̈quiz taku tjaachic̈ha, tuz̈ cjican: “Ima ticzcan, amqui Yooz cuchanz̈quita Liwriiñi Jiliri cheraquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jalla nuz̈ taku tjaatiquiztanaqui Espíritu Santuqui Simeón irpichic̈ha timplu kjutñi. Nii oraqui Jesusiz̈ maa ejpqui nii timpluquin chjitchic̈ha. Nekziqui Jesusiz̈quiz mantita lii jaru cumplichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jesusa cjita wawa cherz̈cu, Simeonqui kjarz̈tan kaazic̈ha. Jalla nuz̈ kaaz̈cu, Yooz honorchiz cjeyajo, tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Yooz Tata, wejrqui amiz̈ mantitacama kamiñ z̈oñtc̈ha. Tuquiqui wejtquiz taku tjaachamc̈ha. Anziqui amiz̈ chiita taku cumplichamc̈ha. Jaziqui tiz̈tiquiztanaqui cuntintul ticznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jaziqui wejt persun c̈hjujcz̈tan tii amiz̈ cuchanz̈quita Liwriiñi cherchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Tjappacha tii muntuquiz z̈ejlñi z̈oñinacz̈tajapa tii Liwriiñi cuchanz̈quichamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Tii Liwriiñiz̈ cjen, Israel z̈oñinacz̈quizimi parti z̈oñinacz̈quizimi Yooz kamañ jicz tjeez̈taz̈ cjequic̈ha, liwriita cjeyajo. Niz̈aza tii Liwriiñiz̈ cjen, Israel wajtchiz z̈oñinacaqui zuma honorchiz cjisnaquic̈ha. —Jalla nuz̈ chiichic̈ha Simeonaqui. ");
INSERT INTO capNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeonz̈ chiitiquiztan Jesusiz̈ maa ejpqui ninacz̈ kuzquiz ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Nekztanaqui Simeonaqui ninacz̈ta Yoozquin mayizichic̈ha walikaz cjeyajo. Niz̈aza Jesusiz̈ maaquiz paljaychic̈ha, tuz̈ cjican: —Werarapanc̈hay, tii wawaz̈ cjen walja Israel wajtchiz z̈oñinaca liwriitapanz̈ cjequic̈ha. Niz̈aza tii wawaz̈ cjen yekjapa Israel wajtchiz z̈oñinacazti ujquin tjojtznaquic̈ha. Tiiqui walja chawc jiliripanz̈ cjequic̈ha. Pero walja z̈oñinacaqui nii anaz̈ rispitaquic̈ha, Yooziz̈ cuchanz̈quita cjenami. ");
INSERT INTO capNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tii wawaz̈ cjen z̈oñinacaz̈ kuzquiz pinsitanacaqui pajtaz̈ cjequic̈ha. Niz̈aza María, amqui tii wawaz̈ cjen ancha llaquitam cjequic̈ha. —Jalla nuz̈ mazzic̈ha Simeonaqui. ");
INSERT INTO capNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Nii oraqui tsjaa Ana cjiti z̈on z̈elatc̈ha, timpluquiz zakaz. Naatac̈ha Yooz taku paljayiñ profetqui. Jalla naaqui Fanuelz̈ majttac̈ha, Aser cjita t'akquiztan. Pakallawk wata zalztiquiztan, naaz̈a lucuqui ticzic̈ha. Anziqui walja chawc z̈ontac̈ha. Quinsakalc tunca pusin watchiztac̈ha naa z̈ewqui; timpluquiztan anapan ulniñtac̈ha. Ayunascan Yoozquin mayizican, Yooz Ejpz̈quin sirwiñtac̈ha majiñami weenami. ");
INSERT INTO capNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Jesús cjita wawa timpluquiz z̈elan, nii orapacha Ana cjiti z̈onqui nii wawz̈tan zalchinc̈ha. Nuz̈ zalz̈cu Yoozquin sparaquiz̈ cjichinc̈ha. Nekztan nii wawz̈ puntu paljayi kalltichinc̈ha Jerusalén watja liwriiz tjuñi tjewzñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tjapa Yooz mantita lii cumplizcuqui Jesusiz̈ maa ejpqui Galilea yokquin quejpchic̈ha. Niiz̈ persun watja Nazaret cjita quejpchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jalla nii wajtquinaqui nii uzaqui pajkchic̈ha. Tsjan tjupi y niz̈aza tsjan c̈hjultaki zizñi cjissic̈ha. Yooz Ejpqui nii walja cwitichic̈ha, niz̈aza yanapchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Zapa wata niiz̈ maa ejpqui Jerusalenquin ojkchic̈ha, pascua pjijsta payi. ");
INSERT INTO capNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesusaqui tuncapan wajtchiz cjen, niiz̈ jamillz̈tan Jerusalenquin ojkchic̈ha pascua pjijsta cuztrumpi payi. ");
INSERT INTO capNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jalla nekztan pjijsta z̈erz̈cuqui, quejpchic̈ha ninacaqui. Jesús uzazti Jerusalén wajtquiz eclichic̈ha. Niiz̈ maa ejp ana ecliñi naychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Niiz̈ maa ejpqui pinsatc̈ha, “Niiz̈ mazinacz̈tanz̈ caa”, cjican. Jalla nuz̈ cjen niiz̈ maa ejpqui ojkchic̈ha tsjii nooj intiru. Pero tjuñi kattan, Jesusa kjurchic̈ha jamillanacz̈quin niz̈aza ocjalz̈ maziran. ");
INSERT INTO capNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Maa ejpqui Jesusa ana wac̈hi atchic̈ha. Jalla nekztanaqui Jerusalén watja quejpchic̈ha, jalla nicju kjurzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tsjii c̈hjep majquiztan, maa ejpqui Jesús watchic̈ha timplu kjuyla. Timpluquiz Israel lii tjaajiñi maestrunacz̈tan z̈elatc̈ha. Maestrunacz̈ takunaca nonznatc̈ha. Y niz̈aza maestrunacz̈quiz pewcznatc̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nii uzaz̈ paljayta taku nonz̈cu tjapa z̈oñinacaqui ispantichic̈ha, nii uzaz̈ nuz̈ c̈hjulumi zizñiz̈ chiyan. ");
INSERT INTO capNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jalla nekztanaqui nuz̈ z̈ejlñi cherz̈cu, ispantichi cjissic̈ha maa ejpmi. Nekztanaqui niiz̈ maaqui chiiz̈inchinc̈ha: —Aay, tii wejt uza jay. ¿Kjaz̈tiquiztan am niz̈ta eclichamta? Am ancha llaquita kjurchinc̈ha wejrnacqui. —Jalla nuz̈ maaqui niiz̈quiz chiiz̈inchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jalla nekztanaqui Jesusaqui maaquiz kjaazic̈ha, tuz̈ cjican: —¿Wejr tjapa kjutñi kjurchamkaya? Wejt persun Ejpz̈ kjuyquiz z̈ejlstanpantac̈ha wejtlaqui. ¿Jalla nii ana zizzat amya? ");
INSERT INTO capNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jalla nuz̈ chiyan niiz̈ maa ejpqui ana intintazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Nekztanaqui Jesusaqui maa ejpz̈tan Nazaret cjita watja ojkchic̈ha. Nicju irantiz̈cu maa epiz̈ mantitanaca cazñipanikaztac̈ha. Maaqui jalla niiz̈ nuz̈ wattanacquiztan kuzquiz chjojchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jalla nekztan Jesusaqui tsjan pajkchic̈ha. Niz̈aza tsjan zizñi pinsamintuchiztac̈ha. Yooz Ejpmi z̈oñinacami niiz̈ cjen cuntintutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Zacarías Juan cjita majchqui Yooz taku paljayi kallantichic̈ha. Jalla nii timpuquiz tii jilirinaca z̈elatc̈ha. Tsjiiqui Tiberio cjitatac̈ha, juc'ant chawc jiliritac̈ha niiqui. Tunca pjijskan wata jiliri cjican mantichic̈ha. Niz̈aza tira mantiñipantac̈ha. Tsjiizuñqui Poncio Pilato cjitatac̈ha. Niiqui mantichic̈ha Judea cjita yokquin. Tsjiizuñqui Herodes cjitatac̈ha. Niiqui Galilea yokquin chawc jiliritac̈ha. Niiz̈ lajkqui Felipe cjitatac̈ha. Nii Felipiqui Iturea cjita yoka, Traconite cjita yoka, jalla nii pizc yokquin mantiñitac̈ha. Tsjiizuñqui Lisanias cjitatac̈ha. Niiqui Abilinia cjita yokquin mantiñitac̈ha. Nii timpuqui ninacatac̈ha pajk jilirinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Niz̈aza nii timpuqui Anastan Caifastan timplu chawc jilirinacatac̈ha. Nii timpuqui Juanqui z̈elatc̈ha tsjii ch'ekti yokquin. Jalla nuz̈ z̈elan Yoozqui Juanz̈quiz takunaca paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nekztan Juanqui tjapa kjutñi Jordán puj yokaran ojklaychic̈ha. Nicju z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Anc̈hucqui kuznacaz̈ campiya; Yoozquin kuzziz cjisna. Nekztan anc̈huca ujnaca pertunta cjequic̈ha. Jalla nekztanaqui bautistaz̈ cjesac̈ha. —Jalla nuz̈ paljaychic̈ha Juanqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tuquita tsjii Isaías cjita Yooz taku paljayñi profeta z̈elatc̈ha. Niiz̈ cjijrta takucama watchic̈ha. Jalla tuz̈ cjican, cjijrchic̈ha: “Ch'ekti yokquin tsjii z̈oñiqui altu tawkz̈tan paljayz̈caquic̈ha, tuz̈ cjican: ‘Tsjii chawc jiliriz̈ tjonaquic̈ha. Jaziqui zuma kamañ jicz tjaczna. Tsjii zuma jicztakaz anc̈huca kuznaca zumpacha tjaczna, y niz̈aza zuma lijitumapanz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","K'awanaca liwj tjattjatzna. Curunacami lumanacami zumpachaz̈ wjajrz̈na, nii jicz zuma zok'o okajo. Niz̈aza nii t'ojonacaqui zumpacha kjujzcatzna. Jalla nuz̈ zuma kamañ jicz tjacznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nii chawc jiliriz̈ tjontan, tjapa tii muntuquiz z̈ejlñi z̈oñinacami Yooz Epiz̈ cuchanz̈quita Liwriiñiz̈ cheraquic̈ha’ ”. Jalla nuz̈ cjican cjijrchic̈ha nii Isaías cjita z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Nekztanaqui z̈oñinacaqui tjapa watjanacquiztan ulanz̈quichic̈ha, Juanz̈ bautista cjisjapa. Juanqui nii z̈oñinacz̈quiz cjichic̈ha: —Zkora irata incallñi z̈oñinaca. Yooz Ejpqui ujchiz z̈oñinaca wajillaz̈ casticaquic̈ha. ¿Ject anc̈hucaquiz nii mazzejo? ¿Nii casticu atipzjapa wejtquinz̈ tjonya? ");
INSERT INTO capNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Kuz campiichinc̈hucz̈laj niiqui, zumapankaz kamaquic̈ha, anc̈huca campiita kuz kjana tjeezjapa. Anc̈hucqui anaz̈ mit kuzziz porapat chiyasaquic̈ha, tuz̈ cjican: “Wejrnacqui Abrahamz̈ majchmaatinacz̈quiztanpacha tjoniñc̈ha. Yoozqui anaz̈ wejrnaca casticasac̈ha”. Jalla niz̈ta ana chiichiiz waquisic̈ha anc̈hucqui. Yoozqui tii maznacquiztan Abrahamz̈ majchmaatinaca paasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anc̈hucqui tsjii frut muntiz̈takazza. Ana zuma fruta pookñi muntiqui k'aac̈htaz̈ cjequic̈ha jir achtan. Jalla nuz̈ k'aac̈htiquiztanaqui, ujtaz̈ cjequic̈ha. Jalla niz̈ta irataz̈ anc̈hucaquiz wataquic̈ha. Ana zuma kamañchiz z̈oñinaca castictaz̈ cjequic̈ha. —Nuz̈ cjican paljaychic̈ha Juanqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jalla nekztanaqui z̈oñinacaqui Juanz̈quiz pewczic̈ha: —¿Jaziqui c̈hjulut paaqui wejrnacjo? ");
INSERT INTO capNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Nekztanaqui Juanqui kjaazic̈ha, tuz̈ cjican: —Jequit pizc almillchiz cjechaj niiqui, tsjii almillaqui ana almillchiz z̈oñz̈quin tjaasac̈ha. Tsjii wacchi c̈hjerchiz z̈oñiqui tsjii ana c̈hjerchiz z̈oñz̈quin niiz̈ c̈hjeri tojnaquic̈ha. —Nuz̈ cjichic̈ha Juanqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jalla nekztanaqui tsjii impuesto cobriñi z̈oñinacaqui Juanz̈quin tjonchic̈ha, bautista cjisjapa. Nekztanaqui Juanz̈quiz pewczic̈ha, tuz̈ cjican: —Tjaajiñi, ¿wejrnacqui c̈hjulut paaquiya? ");
INSERT INTO capNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juanqui kjaazic̈ha, tuz̈ cjican: —Lii jaruz̈ cobraquic̈ha. Anaz̈ juc'anti cobraquic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Niz̈aza tsjii zultatunacaqui Juanz̈quiz pewczic̈ha, tuz̈ cjican: —¿Wejrnaczti c̈hjulut paaquiya? Juanqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui z̈oñz̈quiztan anaz̈ c̈hjulumi kjañasac̈ha. Niz̈aza anaz̈ fuerziyasac̈ha. Niz̈aza z̈oñz̈quizimi ana inapankaz tjojtnasac̈ha, tsjii cusasa packatzjapami. Niz̈aza anc̈huc persun suelduchiz cuntintupanz̈ cjee. —Jalla nuz̈ cjican kaazic̈ha Juanqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tjapa z̈oñinacaqui Yooziz̈ cuchanz̈quita Cristuz̈ tjonz ancha tjewznatc̈ha. Jalla niz̈tiquiztan z̈oñinacaqui kuznacquiz pinsichic̈ha: “Juanqui Cristuz̈lani” cjican. ");
INSERT INTO capNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero Juanqui tjappacha nii z̈oñinacz̈quiz cjichic̈ha: —Nonz̈na. Wejrqui kjaztankal bautisuc̈ha. Tsjiizuñ wejt wirquin tjonc̈ha. Jalla niiqui Espíritu Santuz̈tanami arajpach ujz̈tanami bautisaquic̈ha. Jalla niic̈ha wejtquiztan tsjan juc'ant poderchizqui. Anal niiz̈ c̈hjata chjojkzinimi atasac̈ha, niiz̈quiz atintisjapa. Inakaztc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Juanqui tira paljaychic̈ha, tuz̈ cjican: —Anc̈hucqui trigo zkalaz̈takazza. Nii tjoñi jiliriqui trigonaca kjojaquic̈ha. Nekztan itsanacami zuma trigumi pjalznaquic̈ha. Nii zuma triguqui ricujtaz̈ cjequic̈ha. Niiz̈ persun kjuyquin majcz̈taz̈ cjequic̈ha. Nii itsanacazti liwj ujz̈taz̈ cjequic̈ha, ana tjesñi ujquiz. Jalla niz̈ta irataz̈ anc̈hucaquiz wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jalla nuz̈ z̈oñinacz̈quiz chiiz̈inchic̈ha Juanqui. Niz̈aza yekja chiiz̈intanacami paljaychic̈ha, zuma Yooz taku paljaycan. ");
INSERT INTO capNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Niz̈aza wiruñaqui Juanqui Herodes cjita jilirz̈quiz iwjt'ichizakazza. Herodes cjita jiliriqui niiz̈ jilz̈ tjunatan zalsic̈ha. Felipe cjitatac̈ha niiz̈ jilaqui. Niz̈aza Herodesqui iya anawalinaca paachitakalc̈ha. Nekztan Juanqui Herodesquiz iwjt'ichic̈ha tjapa niiz̈ anawali paatiquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodeszti ana nonzic̈ha. Juc'anti anawalinaca paachic̈ha, Juan carsilquiz chawjczcama. ");
INSERT INTO capNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Juanqui ima carsilquiz chawcta z̈elan, walja z̈oñinaca bautissic̈ha. Niz̈aza Jesusa bautissizakazza. Jesusaqui bautista cjiscu Yooz Ejpz̈quin mayizatc̈ha. Nii orapacha arajpacha cjetzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Yooz Espíritu Santuqui tsjii palumaz̈takaz chjijwz̈quichic̈ha Jesusiz̈ juntuñ. Niz̈aza arajpachquiztan tsjii altu jora paljayz̈quiñi nonzic̈ha. Nii joraqui tuz̈ cjican chiiz̈quichic̈ha: —Amc̈ha wejt ultim k'ayi Maatimqui. Amiz̈ cjen anchal cuntintutc̈ha wejrtqui. ");
INSERT INTO capNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesusaqui nii oraqui quinsatunc watchiztac̈ha. Jalla nekztanaqui niiz̈ Yooz Epiz̈ tjaata trabajo kallantichic̈ha. Jesusiz̈ tuquita atchi ejpnacaqui tinacac̈ha. Primero Josez̈ maati cjitaz̈takaztac̈ha. Josequi Eliz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eliqui Matatz̈ majchtac̈ha. Matatqui Leviz̈ majchtac̈ha. Leviqui Melquiz̈ majchtac̈ha. Melquiqui Janaz̈ majchtac̈ha. Janaqui Josez̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josequi Matatías majchtac̈ha. Matatiasqui Amós majchtac̈ha. Amosqui Nahumz̈ majchtac̈ha. Nahumqui Esliz̈ majchtac̈ha. Esliqui Nagaiz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagaiqui Maatz̈ majchtac̈ha. Maatqui Matatías majchtac̈ha. Matatiasqui Semeiz̈ majchtac̈ha. Semeiqui Josez̈ majchtac̈ha. Josequi Judaz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judaqui Joanaz̈ majchtac̈ha. Joanaqui Resaz̈ majchtac̈ha. Resaqui Zorobabelz̈ majchtac̈ha. Zorobabelqui Salatielz̈ majchtac̈ha. Salatielqui Neriz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neriqui Melquiz̈ majchtac̈ha. Melquiqui Adiz̈ majchtac̈ha. Adiqui Cosamz̈ majchtac̈ha. Cosamqui Elmodamz̈ majchtac̈ha. Elmodamqui Erz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erqui Josuez̈ majchtac̈ha. Josuequi Eliezerz̈ majchtac̈ha. Eliezerqui Jorimz̈ majchtac̈ha. Jorimqui Matatz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matatqui Leviz̈ majchtac̈ha. Leviqui Simeonz̈ majchtac̈ha. Simeonqui Judaz̈ majchtac̈ha. Judaqui Josez̈ majchtac̈ha. Josequi Jonanz̈ majchtac̈ha. Jonanqui Eliaquimz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquimqui Meleaz̈ majchtac̈ha. Meleaqui Mainanz̈ majchtac̈ha. Mainanqui Matataz̈ majchtac̈ha. Matataqui Natanz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natanqui Davidz̈ majchtac̈ha. Davidqui Isaiz̈ majchtac̈ha. Isaiqui Obedz̈ majchtac̈ha. Obedqui Booz majchtac̈ha. Boozqui Salmonz̈ majchtac̈ha. Salmonqui Naasonz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasonqui Aminadabz̈ majchtac̈ha. Aminadabqui Aramz̈ majchtac̈ha. Aramqui Esromz̈ majchtac̈ha. Esromqui Fares majchtac̈ha. Faresqui Judaz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judaqui Jacobz̈ majchtac̈ha. Jacobqui Isaacz̈ majchtac̈ha. Isaacqui Abrahamz̈ majchtac̈ha. Abrahamqui Tarez̈ majchtac̈ha. Tarequi Nacorz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacorqui Serugz̈ majchtac̈ha. Serugqui Ragauz̈ majchtac̈ha. Ragauqui Pelegz̈ majchtac̈ha. Pelegqui Heberz̈ majchtac̈ha. Heberqui Salaz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Salaqui Cainanz̈ majchtac̈ha. Cainanqui Arfaxadz̈ majchtac̈ha. Arfaxadqui Semz̈ majchtac̈ha. Semqui Noez̈ majchtac̈ha. Noequi Lamecz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamecqui Matusalenz̈ majchtac̈ha. Matusalenqui Enocz̈ majchtac̈ha. Enocqui Jaredz̈ majchtac̈ha. Jaredqui Mahalaleelz̈ majchtac̈ha. Mahalaleelqui Cainanz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainanqui Enós majchtac̈ha. Enosqui Staz̈ majchtac̈ha. Setqui Adanz̈ majchtac̈ha. Adanqui Yooziz̈ paatiquiztan Yooz maatitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesusiz̈ kuztan Yooz Espíritu Santuz̈ kuztan tsjii kuzziztac̈ha. Jalla nuz̈ cjen Jesusaz̈ Jordán cjita pujquiztan okan, Espíritu Santuqui Jesusa chjitchic̈ha ch'ekti yokquin. ");
INSERT INTO capNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jalla nii ch'ekti yokquin z̈ejlchic̈ha pusi tunc tjuñi. Jalla nuz̈ z̈elanaqui nii Satanás cjita diabluqui Jesusa ujquiz tjojtskatzjapa pecatc̈ha. Jalla nii pusi tunc tjuñi Jesusaqui ana c̈hjeri lujlchic̈ha. Jalla niz̈tiquiztan pusi tunc tjuñquiztan ana lujlchiz̈ cjen c̈hjeri eecskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jalla nekztanaqui nii diabluqui cjichic̈ha: —Ultim Yooz Maatimz̈laj niiqui, amqui tii mazquiztan t'anta tuckatalla. —Nuz̈ diabluqui chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Z̈oñinacaqui anaz̈ c̈hjerz̈tan alaja z̈etasac̈ha. Yooz takuc̈ha chekanaqui, jalla niic̈ha ultim c̈hjeriz̈takazqui, Yooztan wiñaya z̈etzjapaqui”. ");
INSERT INTO capNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jalla nekztanaqui nii diabluqui Jesusa chjitchic̈ha tsjii pajk cur puntiquin. Jalla nicju tjapa tii muntuquiz z̈ejlñi yokanaca tjeezic̈ha tsjii ratukaz. ");
INSERT INTO capNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","Nekztanaqui diabluqui Jesusiz̈quiz cjichic̈ha: —Wejt yujcquiz quillsnaquiz̈ niiqui, niz̈aza wejr rispitaquiz̈ niiqui, tjapa tii yokquiz z̈ejlñinaca amquiz tjaataz̈ cjequic̈ha. Wejrqui tjapa tii yokanaca tjaac̈ha, am mantisjapa. Tii yokquiz z̈ejlñinaca amtaz̈ cjequic̈ha tjappacha. Tii tjappacha wejtquiz tjaatatac̈ha. Jaziqui wejrqui jakziltiz̈quiz tjaaz pecuc̈haja, jalla niiz̈quin tjaasac̈ha. —Jalla nuz̈ cjichic̈ha diabluqui. ");
INSERT INTO capNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Satanás, wejtquiztan zaraka. Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Ultim arajpach Yoozquinkaz rispita. Niz̈aza nii alaja sirwa. Niikazza Yooz Jiliric̈ha”, nuz̈ cjican cjijrtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","11","Nekztanaqui nii diabluqui Jesusa chjitchic̈ha Jerusalén cjita watja. Nicju timplu pjurniquin chjitchic̈ha. Nekztan cjichic̈ha: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Yooz Ejpqui niiz̈ anjilanaca mantaquic̈ha, am cwitisjapa. Ninacz̈ kjarz̈tan am cwitaquic̈ha, ana am kjojcha c̈hjojritz̈ta cjeyajo c̈hjul mazquiztanami”. Nuz̈ cjijrtac̈ha. Jaziqui ultim Yooz Maatimz̈laj niiqui, tsewctan kossuc tii yokquiz layz̈calla. ");
INSERT INTO capNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Z̈oñiqui ultim arajpach Yooz ana inakaz nuz̈ yanznaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jalla nekztanaqui diabluqui ana c̈hjulu iyas pinsiñi cjissic̈ha, Jesusa ujquiz tjojtskatzjapaqui. Nekztanaqui tsjii kjaz̈tapacha niiz̈quiztan zarakchic̈ha. Wiruñ wilta ujquiz tjojtskatz yanznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nekztanaqui Jesusaqui quejpz̈quichic̈ha Galilea cjita yokquin. Walja Espíritu Santuz̈ azziztac̈ha. Tjapa yok kjutñi niiz̈ quintuqui ancha ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Galilea yokquin z̈elan judío ajcz kjuyanacquizimi tjaajiñitac̈ha. Niiz̈ tjaajintiquiztan tjapa z̈oñinacaqui niiz̈ honora waytichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nekztanaqui niiz̈ persun watja ojkchic̈ha, Nazaret cjita. Jalla niitac̈ha niiz̈ pajkta watjaqui. Jeejz tjuñ nojiqui ajcz kjuyquin luzzic̈ha, niiz̈ cuztrumpi jaru. Jalla nii ajcz kjuyquin z̈ejlcan, tsijtsic̈ha Yooz taku liizjapa. ");
INSERT INTO capNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nekztanaqui Isaías cjita profetaz̈ cjijrta Yooz taku, jalla nii libruqui chjalz̈tatac̈ha Jesusa liyajo. Nii libro cjetz̈cu wajtchic̈ha tii cjijrta taku. Nekztan liichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Yooz Espíritu Santuqui wejt kuzquiz z̈ejlc̈ha. Wejrqui illztac̈ha, pori z̈oñinacz̈quiz zuma taku maznajo. Niz̈aza wejrqui cuchanz̈quitac̈ha llaquizñi z̈oñinaca ana llaquiz llaquizajo. Niz̈aza wejrqui cuchanz̈quitac̈ha tanta z̈oñinacz̈quiz maznajo, ‘Liwriitaz̈ cjequic̈ha anc̈hucqui’ cjican. Niz̈aza wejrqui cuchanz̈quitac̈ha zur z̈oñinacz̈ c̈hjujqui c̈hjetnajo. Niz̈aza wejrqui cuchanz̈quitac̈ha ana zuma langzkatta z̈oñinaca liwriyajo. ");
INSERT INTO capNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yooz Ejpqui z̈oñinacz̈quiz zuma favora paaquic̈ha. Jalla nuz̈ nii zumanaca paazjapa Yooz Espíritu Santuqui wejttan chicapachac̈ha”. Jalla nuz̈ Yooz taku cjijrtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jalla nekztanaqui Jesusaqui nii libro pjucz̈cu ajcz kjuya atintiñi z̈oñz̈quiz intirjichic̈ha. Nekztan nuz̈quiz julzic̈ha. Tjappacha nekz z̈ejlñi z̈oñinacaqui tira niiz̈quin chekznatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nekztanaqui paljayi kallantichic̈ha, tuz̈ cjican: —Tonjpacha tii cjijrta Yooz taku cumplissic̈ha anc̈hucaz̈ nonz̈nan. ");
INSERT INTO capNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nekztanaqui z̈oñinacaqui chiichic̈ha, tuz̈ cjican: —Walikazza tii Jesusaqui. Niiz̈ zuma chiita takunacquiztan ispantichic̈ha. Ninacpora parlassic̈ha, tuz̈ cjican: —¿Anaj tiic Juz maatiya? ");
INSERT INTO capNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nekztan Jesusaqui tuz̈ chiichic̈ha: —Anc̈hucaquiztan z̈oñi wejtquiz chiyac̈hani, “Am kullñi z̈oñimz̈laj niiqui, ima wejr kullcan, am persunpacha kullalla”. Wejrqui Capernaum wajtquin milajrunaca paachinc̈ha, jalla nii quintu nonzinc̈hucc̈ha. Jaziqui anc̈hucqui wejtquiz tuz̈ chiyac̈hani: “Niz̈tapacha tii am persun wajtquin paaz̈inalla”. Nuz̈ wejtquiz chiyac̈hani. ");
INSERT INTO capNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesusaqui tirapan paljaychic̈ha, tuz̈ cjican: —Weraral chiyuc̈ha. Yekja wajtchiz z̈oñinacaqui tsjii Yooz taku paljayñi profeta zuma risiwasac̈ha. Persun wajtchiz z̈oñinacazti nii Yooz taku paljayñi profetz̈quiz anaz̈ juyzu paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tuquiqui tsjii Elías cjita Yooz taku paljayñi profeta z̈elatc̈ha. Nii timpuqui walja z̈ewz̈ew maatakanaca z̈elatc̈ha Israel wajtquinaqui. C̈hjep wata sojta jiizziz ana wira chijinchic̈ha. Jalla niz̈tiquiztan walja mach'atac̈ha. Ana c̈hjeri z̈elatc̈ha nii wajtquinaqui. ");
INSERT INTO capNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Israel wajtquin walja z̈ewz̈ew maatakanaca z̈elanami, Eliasqui ninacz̈quin ana cuchantatac̈ha. Pero Sarepta cjita wajtquin tsjaa z̈ew z̈elatc̈ha, Sidón cjita wajtz̈ z̈cati. Jalla naa yekja wajtchiz z̈ewaquin cuchantatac̈ha Eliasqui. Jalla nuz̈upan cjetc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Niz̈aza tuqui timpuzakaz tsjii Eliseo cjita Yooz taku paljayñi profeta z̈elatc̈ha. Nii timpuqui walja mojkchi janchichiz laa z̈oñinaca z̈elatc̈ha; lepra cjita conac̈ha niiqui. Pero Eliseuqui persun wajtchiz laa z̈oñinacz̈quiz ana c̈hjulumi c̈hjetinchic̈ha. Antiz tsjii Naamán cjita Siria wajtchiz z̈oñz̈quiz c̈hjetinchic̈ha. —Jalla nuz̈ chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jalla nuz̈ chiita nonz̈cu, tjappacha nii ajczñi z̈oñinacaqui muzpa z̈awjchic̈ha Jesusiz̈ quintra. ");
INSERT INTO capNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ninacaqui walja tsijtsic̈ha. Nekztanaqui wajtquiztan Jesusa ulanskatchic̈ha. Nii watjaqui pajk waranc k'aw z̈cati z̈elatc̈ha. Jalla nuz̈ k'aw kjutñi Jesusa chjitchic̈ha, nii k'awquiztan kossuc tjojtsjapa. ");
INSERT INTO capNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ultimquiziqui Jesusazti ninacz̈ taypi watchic̈ha. Ana c̈hjulumi kjaz̈ cjita ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nekztanaqui Jesusaqui ojkchic̈ha Capernaum cjita watja Galilea cjita yokquin. Jalla nicjuqui jeejz tjuñ nooj Jesusaqui tjaajinchic̈ha ajcz kjuyquin. ");
INSERT INTO capNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Niiz̈ tjaajintiquiztan z̈oñinacaqui walja ispantichic̈ha. Jesusaqui pajk jilirz̈ tawkz̈tan tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Jalla nii ajcz kjuyquiz tsjii zajraz̈ tanta z̈oñi z̈elatc̈ha. Nii z̈oñiqui kjawchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Ay! Jesusa, Nazaret wajtchiz z̈oñimc̈ha. ¿Kjaz̈tiquiztan am wejtnacaquiz mitizi? ¿Kjaz̈tiquiztan wejrnac aki tjon amjo? Wejrqui am pajuc̈ha. Yooziz̈ zuma cuchanz̈quita Z̈oñimc̈ha amqui. —Jalla nuz̈ cjichic̈ha nii zajraqui. ");
INSERT INTO capNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nekztanaqui Jesusaqui nii zajriz̈quiz ujzic̈ha, tuz̈ cjican: —¡Ch'uj z̈ela! ¡Tii z̈oñz̈quiztan zaraka! Jalla nekztanaqui z̈oñi tjojtcu zajraqui ulanchic̈ha z̈oñinacaz̈ cheranpacha. Ana nii z̈oñi c̈hjojritz̈cu, ecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nekztan tjapa z̈oñinacaqui ispantichic̈ha. Jalla nekztan parlassic̈ha, tuz̈ cjican: —¿C̈hjul mantiñi takumekaz chiila tiiqui? Walja azziz tawkchizza. Tii z̈oñiqui zajramiz̈ mantila. Tiiz̈ mantitiquiztan zajramiz̈ ulanla. —Nuz̈ ispantichi parlassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tjapa kjutñi nii yokaran Jesusiz̈ ispantichuca paatanacquiztan walja parlasñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nekztanaqui Jesusaqui nii ajcz kjuyquiztan ulanz̈cu ojkchic̈ha. Nekztan Simonz̈ kjuyquin luzzic̈ha. Jalla nekz Simonz̈ ajmuz̈ maa ch'ujlñi cona laacjichi z̈elatc̈ha. Tjapa curpu walja kjakchi z̈elatc̈ha. Nii z̈ejlñi z̈oñinacaqui Jesusiz̈quiz roct'ichic̈ha: —C̈hjetinz̈inalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nekztanaqui Jesusaqui naa laa z̈ona kjutñi chutjatchic̈ha. Nekztan laa z̈on c̈hjetinchic̈ha. Ch'ujlñi conaqui apaltichic̈ha nuz̈quiz. Nii orapacha naa z̈onqui z̈aazinc̈ha, nekztanaqui ninaca atinti kallantichinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nekztanaqui tjuñiz kattan, z̈oñinacaqui tjapaman laa z̈oñinaca zjijcchic̈ha, Jesusa c̈hejtnajo. Nekztan Jesusaqui zapa mayniz̈quiz persun kjarz̈tan lanzic̈ha. Jalla nuz̈ lanz̈cu c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Niz̈aza tsjii kjaz̈ laa z̈oñinacz̈quiztan zajranaca ulanskatchic̈ha. Jalla nuz̈ ulanskatan zajranacaqui kjawchic̈ha: —Yooz Maatimc̈ha amqui, —cjican. Nii zajranacaqui zizatc̈ha, Yooziz̈ cuchanz̈quita Cristupankazza Jesusaqui, jalla nii. Jalla niz̈tiquiztan Jesusazti zajranacz̈quiz ujzic̈ha, tuz̈ cjican: —Jalla wejt puntuquiztan anapanc̈ha chiichiisqui. ");
INSERT INTO capNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Niiz̈ jakakattaz̈ wentan Jesusaqui wajtquiztan ulanchic̈ha, ana z̈oñz̈ z̈ejlz yokquin. Pero nii wajtchiz z̈oñinacazti walja nii kjurchic̈ha. Niz̈tami kjurñi z̈oñinacaqui irantichic̈ha jakziquin Jesusa z̈elatc̈haj, jalla nicju. Nii z̈oñinacaqui Jesusaz̈ atajs pecatc̈ha, ana jakziquinami okajo. ");
INSERT INTO capNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero Jesusaqui ninacz̈quiz cjichic̈ha: —Yekjap watjanacquin jaknuz̈t z̈oñinacaqui Yooz zuma kamañchiz kamz waquizic̈haja, jalla nii paljayzquiztanc̈ha wejrqui. Jalla niijapa wejrqui tii muntuquiz cuchanz̈quitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jalla nuz̈ paljaycan Jesusaqui ojklaychic̈ha Galilea yokaran. Jalla nuz̈ ojklaycan ajcz kjuyquizimi paljayñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Tsjii nooj Jesusaqui tsjii pajk kot atquin z̈elatc̈ha. Genesaret cjitac̈ha nii pajk kotaqui. Jalla nekz z̈elan walja z̈oñinacaqui niiz̈quin tjonchic̈ha. Yooz taku nonzjapa niiz̈ muytata ancha ts'acjasatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesusaqui pizc laachi warcu cherchic̈ha kot atquiz. Tsjii ch'iz tanñi z̈oñinacaqui warcunaca ecchitac̈ha. Ninacaqui ch'iz tanz rednaca awjnatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jalla nekztanaqui Jesusaqui Simón cjita z̈oñz̈ warcuquiz luzzic̈ha. Simonz̈quiz nii warcu koluc atskatchic̈ha kot mor kjutñi cheechi. Jesusaqui warcuquiz julz̈cu, z̈ejlñi z̈oñinacz̈quin tjaajñi kallantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jalla nuz̈ z̈oñinacz̈quiz tjaajñi z̈erz̈cu, Simonz̈quiz cjichic̈ha: —Tii warcu am chjicha tsjan kos kjutñi. Jalla nekztan am ch'iz tanz rednaca tjojtz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simonaqui kjaazic̈ha tuz̈ cjican: —Wejt Tjaajiñi Maestro, zeziqui wejrnacqui pakara langzinc̈ha, pero ana zinta ch'iz tanchinc̈ha. Niz̈taqui amiz̈ mantanaqui wejt ch'iz tanznaca tjojtznac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nekztanaqui ch'iz tanz tjojtz̈cu, walja muzpa ch'iz tanchi joozic̈ha, redmi wjajrzñi kallantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","8","Nii oraqui ninacz̈ mazinaca yekja warcuquintac̈ha koluc az̈kquinalla. Ch'iz tanz wjajrzñi kallantiquiztan mazinaca kjarz̈tan wilzcu, kjawzic̈ha yanapi tjonajo. Nii mazinacaqui irantiz̈cu, nii pizc warcuquiz ch'iztan chjijpsic̈ha. Ch'iztan jos nii kotquiz kos julzñi tjurchic̈ha nuz̈ wacchi ch'iz tanziz̈ cjen. Nii cherz̈cu, Simón Pedruqui Jesusiz̈ yujcquiz quillzic̈ha. Nekztan cjichic̈ha: —Wejt Yooz Jiliri, ancha ujchiz z̈oñtc̈ha wejrqui. Amtan chica ojklayzqui anal waquizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jalla nii wacchi ch'iz tanchiz̈ cjen, Simonaqui walja ispantichic̈ha, niz̈aza niiz̈ mazinacami. ");
INSERT INTO capNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Tsjii pucultan mazinacaqui Jacobz̈tan Juanz̈tan cjitatac̈ha. Ninacaqui Zebedeoz̈ majchnacatac̈ha. Jacobz̈tan Juanz̈tan niz̈aza ispantichi cjissic̈ha. Jesusaqui Simonz̈quiz cjichic̈ha: —Ana am tsuca. Jalla tekztan nawjkchuc jaknuz̈ ch'iz juntichamz̈laja, jalla niz̈ta irata amqui z̈oñinacam juntaquic̈ha Yooztajapaqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jalla nekztanaqui warcunaca yokquin irantiskatz̈cu, ninacaqui tjappacha ecchic̈ha. Niz̈aza nii ch'iz tanz langz jaytichic̈ha Jesusiz̈tan chica ojklayzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tsjii noojiqui Jesusaz̈ tsjii wajtquiz z̈elan, tsjii mojkchi janchichiz laa z̈oñi tjonchic̈ha. Jesusa cherz̈cuqui, niiz̈ yujcquiz puct'ichic̈ha yokquizpacha. Jalla nekztanaqui rocchic̈ha, tuz̈ cjican: —Wejt Jiliri, wejr c̈hjetnalla. Am wejr c̈hjetinzim pecc̈haj niiqui, wejr c̈hjetinzim atc̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nekztanaqui Jesusaqui kjarz̈tan lanzic̈ha, tuz̈ cjican: —Wejr am c̈hjetnasachiya. Jaziqui c̈hjetintam cjissa. Jalla nuz̈ chiitiquiztanaqui nii orapacha nii z̈oñiqui z̈ejtchi cjissic̈ha mojkchi janchi laaquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Nekztanaqui Jesusaqui nii z̈oñi mantichic̈ha ana jecz̈quizimi nuz̈ nii c̈hjetinta puntu chiichiyajo. Niz̈aza cjichic̈ha: —Timpluquin oka amqui. Timplu jilirz̈quin persuna tjeez̈ca. Niz̈aza c̈hjetintiquiztan Moisés mantitacama paa. Jaknuz̈t Moisesqui ofrenda uchajo mantic̈haja, jalla nuz̈ ofrenda uchaquic̈ha. Jalla niz̈tiquiztan z̈oñinaca am z̈ejtchi zizaquic̈ha. Jazic oka amqui. —Nuz̈ mantichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jalla nuz̈ ana chiyajo mantichiz̈ cjenami, Jesusiz̈ paata puntu juc'anti juc'anti parlita cjissic̈ha tjapa kjutñi z̈oñinacz̈quin. Jalla nii quintu nonz̈cuqui, ju'anti z̈oñinacaqui ajcsquichic̈ha Jesusiz̈ taku nonzjapa. Niz̈aza laanacami ajczquichic̈ha Jesusaz̈ c̈hjetinta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jalla niz̈tiquiztanaqui Jesusaqui nii z̈oñinacz̈quiztan zarakz̈cu ana z̈oñinacz̈ z̈ejlz yokquin ojkchic̈ha. Jalla nii yokquin Yooz Ejpz̈quin mayizichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Tsjii nooj niiz̈ wiruñ Jesusaqui tjaajnatc̈ha. Jalla niiran fariseo cjita z̈oñinacaqui julzi z̈elatc̈ha, niz̈aza judiuz̈ kamañ lii tjaajiñi z̈oñinaca z̈elatc̈ha. Jalla ninacaqui tjapa Galilea watjanacquiztan tjonchic̈ha, niz̈aza Judeaquiztan, niz̈aza Jerusalenquiztan. Niz̈aza Jesusaqui laa z̈oñinaca c̈hjetincan, Yooz azi tjeezic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jalla nekztanaqui tsjii kjaz̈ z̈oñinacaqui tsjii zuch z̈oñi zjijcchic̈ha tjajz zquitquiz callz̈cu. Irantiz̈cu kjuyquiz majcz pecatc̈ha. Jesusiz̈ yujcquiz nonzinz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero muzpa z̈oñinacacaz̈ ajcsiz̈ cjen, ana Jesusiz̈quin macjati atchic̈ha. Nekztanaqui kjuya yawz̈cu, tsewctan kjuya pjetchic̈ha, tejanaca apakz̈cu. Pjetquiztan nii zuch z̈oñi tsewctan kjuylchuc majcchic̈ha tjajz zquitquiz callz̈cu. Kjuyltan z̈ejlñi z̈oñinacz̈ taypi nuz̈ Jesusiz̈ yujcquin apjatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ninaca tjapa kuztan tjonchi nayz̈cu Jesusaqui laa z̈oñz̈quiz cjichic̈ha: —Jilala, jaziqui am ujnacaqui pertuntac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jalla nekztanaqui judiuz̈ kamañ lii tjaajiñinacz̈tan fariseonacz̈tan kuzquiz pinsi kallantichic̈ha, tuz̈ cjican: “¿Ject tii z̈oñejo? ¿Kjaz̈tiquiztan niz̈ta chiijo? Yooz quintra anawalipanla tii z̈oñz̈ takuqui. ¿Ject ujnaca pertunasajo? Yoozpanikazla ujnacaqui pertunñiqui”. Jalla nuz̈ pinsichic̈ha nii z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesusaqui persun kuzquiz ninacaz̈ pinsita naychic̈ha. Nekztan ninacz̈quiz paljaychic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan anchuca kuz niz̈ta pinsejo? ");
INSERT INTO capNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jaksilta takut pjasila chiiz cjesajo? Tii zuch z̈oñz̈quiz chiiz̈insjo, “Am ujnacami pertunta”, ¿cjis pjasila cjesaj? uz̈ “Tsijtsna. Am tjajz zquiti aptiz̈cu oka”, ¿nuz̈ chiiz pjasila cjesaj? ");
INSERT INTO capNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha wejrqui. Tii muntuquiz jiliritc̈ha, ujnaca pertunzjapa. Razunal chiyuc̈ha. Jalla nii zizjapa anc̈hucqui tiiz̈ chera. Nekztanaqui zuch z̈oñz̈quiz cjichic̈ha: —Amquiz cjiwc̈ha, tsijtsna. Am tjajz zquitinaca aptaza. Oka am kjuya. —Nuz̈ cjican chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nii orapacha nii zuch z̈oñiqui tsijtsic̈ha, z̈oñinacaz̈ cheranpacha. Tjajz zquiti aptiz̈cu, persun kjuya ojkchic̈ha. Yooz honora waytican ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jalla niz̈ta cherz̈cu tjapa z̈oñinacaqui walja ispantichi quirchic̈ha. Ekekscan ninacaqui Yooz honora waytichizakazza. Niz̈aza ninacpora parlassizakazza: —Tonj tjuñiqui walja ispantichucanaca cherchinc̈humc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jalla nekztanaqui Jesusaqui ulanchic̈ha. Jalla nuz̈ ulanz̈cu tsjii Leví cjita z̈oñi cherchic̈ha. Impuesto cobriñi z̈oñitac̈ha niiqui. Impuesto cobriñi puestuquiz julzi z̈elatc̈ha z̈oñinacz̈quiz cobrican. Jesusaqui nii z̈oñz̈quiz cjichic̈ha: —Wejttanz̈ ojkla. ");
INSERT INTO capNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nekztanaqui Leví cjita z̈oñiqui tsijtsic̈ha. Impuesto cobriz langz apatatz̈cu, Jesusiz̈tan chica ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nekztanaqui Jesusiz̈tan pjijsta paazjapa, Leviqui persun kjuyquiz zuma c̈hjeri tjaczic̈ha. C̈hjeri lujlcan Jesusaqui impuesto cobriñinacz̈tan niz̈aza yekja ujchiz z̈oñinacz̈tan chica julzi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jalla nii cherz̈cu, fariseo z̈oñinaca niz̈aza judiuz̈ lii tjaajiñi maestrunaca jalla ninacaqui Jesusiz̈ tjaajinta z̈oñinacz̈quiz chuchi kallantichic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan impuesto cobriñinacz̈tanami ujchiz z̈oñinacz̈tanami c̈hjeri lujl anc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nekztanaqui Jesusaqui nuz̈ nonz̈cu kjaazic̈ha ninacz̈quiz, tuz̈ cjican: —Wiw z̈oñinacaqui kullñi z̈oñi anaz̈ pecasac̈ha. Antiz laa z̈oñinacaz̈ pecchiya. ");
INSERT INTO capNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wejrqui “zumal kamuc̈ha” cjiñi z̈oñinacz̈quiziqui anal kjawzñi tjonchinc̈ha. Antiz “ujchizpanc̈ha” cjiñi z̈oñinacz̈quiz kjawzñi tjonchinc̈ha, ninaca Yoozquin kuzziz cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jalla nekztanaqui z̈oñinacaqui Jesusiz̈quiz chiichic̈ha, tuz̈ cjican: —Juanz̈ tjaajintanacami fariseoz̈ tjaajintanacami walja ayunasñic̈ha. Y niz̈aza ninacz̈ cuzturumpi jaru walja Yoozquin mayiziñic̈ha. Pero amiz̈ tjaajinta z̈oñinacazti ana ayunasñipanla. ¿Kjaz̈tiquiztan niz̈tajo? C̈hjeriz̈ lujlz̈la, niz̈aza mazk'a kjaz licz̈la, niz̈takazla. —Nuz̈ cjican uj tjojtunz pecchic̈ha nii z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nekztanaqui Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Zals pjijstiquiz z̈oñinacaz̈ impittaz̈ cjenaqui, ¿kjaz̈t zalsñi z̈oñz̈tajapa ayunasasajo? Nii zalsñi z̈oñi z̈elanpacha anaz̈ ayunasasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Tii jarquin nii zalsñi z̈oñiz̈ kjañtaz̈ cjen, jalla nekztanz̈ ayunasasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tsjii taku chiichizakazza, tuz̈ cjican: —Anaz̈ jecmi tsjii ew zquitquiztan riminta apakasac̈ha, tsjelanzi zquiti rimintisjapa. Jalla nuz̈ paaquiz̈ niiqui, nii ew zquiti pertisnaquic̈ha. Niz̈aza nii ew riminta apjattaqui tsjel zquitquiztan tsjemata cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Niz̈aza anaz̈ jecmi tsjii zijzi zkiz luusquiz ew vino alznasac̈ha. Niz̈ta alznasaz̈ niiqui, zkiz luus wjajrskatasac̈ha ew vinuqui. Nekztanaqui zkiz luusmi vinumi pizcpacha pertisnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ew vinuqui ew zkiz luusquizpanz̈ alznasac̈ha. Nekziqui zkiz luusmi vinumi zumapanz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y niz̈aza t'amchi vinu licz̈cu, anaz̈ ew vinu pecasac̈ha. “Wejtta t'amchi vinuqui walikazza”, cjican cjequic̈ha. Niz̈tazakaz z̈oñinacaqui Yooziz̈ tjaata ew kamaña ana pecasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Tsjii jeejz tjuñ noojiqui Jesusaqui zkal taypiranz̈ okatc̈ha niiz̈ tjaajinta z̈oñinacz̈tan. Jalla nuz̈ ojkcan niiz̈ tjaajinta z̈oñinacaqui tric oza kjajpchic̈ha. Nuz̈ kjajpz̈cu kjarz̈tan kjojchic̈ha. Nekztan lujlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Nii cherz̈cu tsjii kjaz̈ultan fariseo z̈oñinacazti ninacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈hucqui niz̈ta paajo? Jeejz tjuñquiziqui niz̈ta anapanc̈ha paazqui. Uc̈hum lii quintrala, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nekztanaqui Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui Yooz taku liichinc̈hucpanc̈ha, ¿ana jaa? Cjijrta Yooz takuqui tuz̈ cjic̈ha: uc̈hum David cjita tuquita atchi ejpqui niiz̈ mazinacz̈tan c̈hjeri eecskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","C̈hjeri eecznanaqui arajpach Yooz timpluquin luzzic̈ha. Nicju Yooz yujcquiz nonz̈ta t'antanaca z̈elatc̈ha. Jalla nii t'anta aptiz̈cu, lujlchic̈ha. Niz̈aza niiz̈ mazinacz̈quiz tojunchic̈ha. Anapantac̈ha permitta nii t'anta lujlsqui ina z̈oñz̈laqui. Niz̈ta lujlz̈cuqui, lii quintrala niiqui. Timplu jilirinacz̈tapankaz nii t'anta lulaj cjitaqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Niz̈aza Jesusaqui ninacz̈quiz cjichic̈ha: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jeejz tjuñquizimi c̈hjulu paaz cjenami mantasac̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Niiz̈ wiruñ jeejz tjuñquiziqui Jesusaqui luzzic̈ha judionacz̈ ajcz kjuyquiz. Jalla nii ajcz kjuyquin tjaajñi kallantichic̈ha. Nicju tsjii z̈oñi z̈elatc̈ha z̈ew kjara kjoñchi. ");
INSERT INTO capNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Niz̈aza judiuz̈ lii tjaajiñinacz̈tan, fariseonacz̈tan z̈elatc̈ha. Nii z̈oñinacaqui Jesusaz̈ awayt'atc̈ha, jeejz tjuñquiziqui c̈hjetnaqui anaz̈ c̈hjetna, jaa, jalla nii. Jalla nuz̈ awayt'atc̈ha, Jesusiz̈ quintra nii jaru aptisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesusaqui niz̈ta ana wali pinsitanaca kuzquiz naychipanc̈ha. Jalla nekztanaqui kjara kjoñchi z̈oñz̈quiz paljaychic̈ha, tuz̈ cjican: —Tsijtsna. Tii taypiquin cjisna. Nuz̈ chiitiquiztanaqui nii z̈oñiqui nii taypiquin tsijtsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nekztanaqui Jesusaqui parti z̈oñinacz̈quiz paljaychizakazza, tuz̈ cjican: —Wejrqui anc̈hucaquiz tsjii pewcsnasac̈ha. ¿Jeejz tjuñquiziqui uc̈hum liiqui kjaz̈t cjeejo? z̈oñz̈quiz zuma paasaya uz z̈oñz̈quiz ana zuma paasaja. Z̈oñz̈ wira liwriyasaya uz z̈oñz̈ wira ticskatasaja. Anc̈hucqui zumpacha zizza, zuma paazqui uc̈hum lii jaruc̈ha jeejz tjuñquizimi. —Jalla nuz̈ cjican, chiiz̈inchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jalla nekztanaqui Jesusaqui niiz̈ muytata z̈ejlñi z̈oñinacz̈ kjutñi chercherzic̈ha. Nekztan kjara kjoñchi z̈oñz̈quiz cjichic̈ha: —Am kjara chjinzna. Nii z̈oñiqui nuz̈ kjara chjinz̈cu niiz̈ kjara z̈ejtchi quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Quintra z̈oñinacazti nii cherz̈cu walja z̈awjchic̈ha Jesusiz̈ quintra. Jalla nekztanaqui ninacpora pewcsarassic̈ha, jaknuz̈t Jesusiz̈ quintra paa-as, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Niiz̈ wiruñaqui Jesusaqui tsjii curullquin ojkchic̈ha Yooz Ejpz̈quin mayizi. Ween pakara Yooz Ejpz̈quin mayizichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tjuñiz̈ tjewctanalla, niiz̈ tjaajinta z̈oñinaca kjawzic̈ha. Kjawz̈cu, Jesusaqui tuncapani illzic̈ha niiz̈ mantita apostolonaca cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nii illzta apostolunacaqui tuz̈ cjita tjuunacchiztac̈ha: Simonatac̈ha; niz̈aza niiz̈ tsjii tjuuqui Pedro cjitazakaztac̈ha. Andrestac̈ha, Simonz̈ lajk Jacobotac̈ha. Juantac̈ha. Felipetac̈ha. Bartolometac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateotac̈ha. Tomasatac̈ha. Jacobotac̈ha; niiqui Alfeo cjita z̈oñz̈ majchtac̈ha. Simonatac̈ha, niz̈aza niiqui Canaan t'akquiztantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judastac̈ha, Jacobz̈ lajk; niz̈aza Judas Iscariotitac̈ha; jalla niiqui Jesusiz̈ quintra tarazunchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jalla nekztanaqui Jesusaqui niiz̈ illztanacz̈tan chjijwz̈quichic̈ha curullquiztan. Pampiquin irantiz̈cu, niiz̈ tjaajinta z̈oñinacz̈tan tsijtsic̈ha. Nicju wacchi z̈oñinaca z̈elatc̈ha, tjapa kjuttan Judea yokquiztan, niz̈aza Jerusalén wajtquiztan, niz̈aza Tiro yokquiztan, niz̈aza Sidón yokquiztan, jalla nii yokanacquiztan tjonchic̈ha. Nii z̈oñinacaqui Jesusiz̈ takunaca nonzñi irantiz̈quichic̈ha. Yekjapanacaqui tjonchic̈ha laanacquiztan c̈hjetinta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Niz̈aza yekjapanacaqui tjonchic̈ha zajranacaz̈ tantiquiztan liwriita cjisjapa. Jalla nekztanaqui Jesusaqui ninaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesucristuqui c̈hjetinz azziztac̈ha. Niz̈aza Jesusaqui tjapa nii z̈ejlñi laanaca c̈hjetinchic̈ha niiz̈ aztan. Tjappacha laa z̈oñinacaqui Jesusa lanz pecatc̈ha, c̈hjetinta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈ kjutñi cherzic̈ha. Nekztan paljaychic̈ha, tuz̈ cjican: —Anc̈hucqui porinaca, Yooz mantita zuma kamañaqui anc̈hucaltajapac̈ha. Jalla niz̈tiquiztan cuntintuz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‛C̈hjeri eecsñinaca, wiruñ Yoozqui anc̈hucaquiz wali cjiskataquic̈ha, tsjii c̈hjerz̈tan chjekchiz̈takaz. Jalla niz̈tiquiztan cuntintuz̈ cjee. ‛Llaquitanaca, anzic anc̈huc kaac̈han. Wiruñaqui ananiiz̈ chipchipaquic̈ha. Jalla niz̈tiquiztan cuntintuz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","23","‛Anc̈hucqui, Yooz Majchquin sirwiñi z̈oñinacc̈hucc̈ha. Quintra z̈oñinacaqui anc̈hucaquiz chjaawjkatc̈ha. Niz̈aza jakurpayaquic̈ha. Niz̈azaz̈ ch'aanaquic̈ha. Niz̈aza iñaraquic̈ha. Anc̈hucaquiz ana zumapanz̈ nayaquic̈ha. Jalla nuz̈ cjenami ancha cuntintuz̈ cjee. Anc̈huczti arajpachquin ojkz̈cu, wali kamañ wira tanznaquic̈ha, tsjii chawc premiuz̈takaz. Niz̈tapan tuquitanpacha tii z̈oñinacz̈ tuquita atchi ejpnacaqui Yooz sirwiñi profetanacz̈quiz chjaawjkatñipantac̈ha. Jalla niz̈tiquiztan anziqui cuntintuz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‛Anc̈hucqui ricachunaca, cuntintukaz tii wirquiz kamchinc̈hucc̈ha. ¡Wiruñ anawalipanz̈ anc̈hucaquiz wataquic̈ha! ");
INSERT INTO capNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‛Anc̈hucqui zuma cusasanacchiz kamchinaca, poriz̈takaz cjisnaquic̈ha. Yoozquin ana cjuñziz̈ cjen t'akjiriz̈ cjisnaquic̈ha. Ana walinacquiztan chipchinaca tsjii noojiqui ananiiz̈ kaaquic̈ha niz̈aza llaquitaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‛Anc̈hucqui, Yooz taku chiitaz̈oka cjiñi z̈oninacc̈hucc̈ha. Tjapa z̈oñinacaqui anc̈huca honora waytaquiz̈ niiqui anc̈hucaquiz juc'ant anawaliz̈ cjequic̈ha. Tuquitanpacha tii z̈oñinacz̈ tuquita atchi ejpnacaqui niz̈tapan honora waytichic̈ha toscara chiichiiñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‛Anc̈hucqui, wejt taku nonzñinaca, anc̈hucaquiz tuz̈ cjiwc̈ha: Anc̈huca quintra z̈oñinacz̈tanami zuma kuzzizpanz̈ cjee. Y niz̈aza zumapanz̈ ninacz̈tan paa, niz̈aza anc̈huca chjawjkatñinacz̈tanami zumapanz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Niz̈aza anc̈huca quintra laykiñi z̈oñinacz̈quiz zuma tawkz̈tan paljaya anc̈hucqui. Niz̈aza anc̈huc iñariñi z̈oñinacz̈tajapa zuma tawkz̈tan Yoozquin mayt'iz̈ina. ");
INSERT INTO capNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jakziltamiz̈ am yujcquiz kichasaz̈ niiqui, ana niz̈tapacha amqui kicha. Anac̈ha cutjatzqui. Niz̈aza jakziltamiz̈ am ira kjañasaz̈ niiqui, nii kjañaj cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Niz̈aza jakziltamiz̈ amquiztan mayi tjonasac̈ha, nuz̈ tjaa. Jakziltamiz̈ amquiztan kjañasac̈ha, nuz̈ kjañaj cjee. Anam amqui quijasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jaknuz̈t anc̈hucqui parti z̈oñinaca anc̈hucatan zuma kamz pecc̈haj niiqui, jalla niz̈tapacha anc̈hucqui z̈oñinacz̈tan zuma kama. ");
INSERT INTO capNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‛Yekjapanacaqui anc̈hucatan zumaz̈ munazic̈ha. Anc̈hucqui ninacz̈tan alajapankaz zuma munazaquiz̈ niiqui, ¿kjaz̈tiquiztan anc̈hucqui “Zumal paa-uc̈ha” cjican chiyasajo? Niz̈ta iratazakaz paac̈ha anawal kuzziz Z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yekjapanacaqui anc̈hucaquiz yanapc̈ha. Anc̈hucqui ninacz̈tan alajapankaz yanapaquiz̈ niiqui, ¿kjaz̈tiquiztan anc̈hucqui “Zumal paa-uc̈ha” cjican chiyasajo? Niz̈ta iratazakaz paac̈ha anawal kuzziz z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yekjapanacaqui anc̈hucaquiz onza. Anc̈hucqui ninacz̈tan alajapankaz onznaquiz̈ niiqui, ¿kjaz̈tiquiztan anc̈hucqui “Zumal onznuc̈ha” cjican chiyasajo? Niz̈ta irata zakaz paac̈ha anawal kuzziz z̈oñinacami. Nekztan tsjii onzñizakaz tjewza. ");
INSERT INTO capNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero anc̈hucqui quintra z̈oñinacz̈tanami zuma munazizpanz̈ waquizic̈ha. Niz̈aza anc̈hucqui quintra z̈oñinacz̈quizimi yanapz panz̈ waquizic̈ha. Niz̈aza anc̈hucqui onz̈cumi anaz̈ tjewz waquizic̈ha “Niimiz̈ onz, jaa” cjicanaqui. Jalla nuz̈ kamtiquiztanaqui Yoozqui anc̈hucaquiz tsjii pajk honora tjaaquic̈ha. Niz̈aza nuz̈ kamtiquiztan anc̈hucqui tjeez̈a werar arajpach Yooz maatinacaz̈, nii. Niz̈aza nuz̈ kamcanaqui Yooz irataz̈ kamc̈ha. Yoozqui okzñizakazza quintra z̈oñinacz̈quiziqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Yooz Ejpqui walja okzñipanc̈ha. Niz̈ta irata anc̈hucqui okzñi kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‛Anc̈hucalaqui anac̈ha z̈oñinacz̈ uj paatanaca chii chiizqui. Jalla nuz̈ z̈oninacz̈ uj paatanaca chii chiyaquiz̈ niiqui anc̈hucqui juc'ant ujchiz cjequic̈ha Yooz yujcquiziqui. Niz̈aza z̈oñinacz̈quizimi “Amqui Yooziz̈ castictaj cjila”, cjican chiyaquiz̈ niiqui anchucqui Yooziz̈ casticta zakaz cjequic̈ha. Niz̈aza jakzilta z̈oñit anc̈huca quintra uj paac̈haja, jalla niiz̈quiz pertunz waquizic̈ha. Nekztan Yoozqui anc̈hucaquiz ujnaca zakaz pertunaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Anc̈hucqui okzñi kuzziz z̈oñinacz̈quizimi tjaa. Jalla nuz̈ tjaan Yoozqui anc̈hucaquiz juc'anti tjaaquic̈ha. Jalla tuz̈ Yoozqui tjaaquic̈ha. Anc̈huca quelzquiz chjijpi tjaaquic̈ha. Tsajtscu tsajtscu niz̈aza walja kala ts'aczcu tjaaquic̈ha. Jakziltat tuptalla tjaac̈haja, jalla niiz̈quiz nuz̈ tuptalla zakaz Yoozqui tjaaquic̈ha. Niz̈aza jakziltat c̈hjuñi kuzziz tjaac̈haja, jalla niiz̈quiz nuz̈ c̈hjuñi zakaz Yoozqui tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesusaqui tsjii takunacz̈tan chiichic̈ha, tuz̈ cjican: —¿Jaknuz̈t zur z̈oñiqui yekja zur z̈oñi irpiñiz̈takaz zuma chjichasajo? Pucultanpachaz̈ ojtquiz tjojtsnasac̈ha. Jalla niz̈taz̈ ana zuma cjicjiñi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tsjiilla cjesac̈ha. Tsjii tjaajinta z̈oñiqui niiz̈ tjaajiñiz̈quiztan anaz̈ juc'anti cjesac̈ha, aunquimi istutiiz̈cu tjaajiñi maestrupanikaz cjequic̈ha. —Jalla nuz̈ tjaajinchic̈ha Jesusaqui. Niz̈aza Jesusaqui tjaajinchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","—Amqui am jilz̈ c̈hjujcquiz tsjii cjujchilla cherasaz̈ niiqui, ¿kjaz̈tiquiztan am persun c̈hjujcquiz pajk cjujchi ana cherjo? ");
INSERT INTO capNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Am persun c̈hjujcquiz nii pajk cjujchi ana cherasaz̈ niiqui, ¿kjaz̈tiquiztan am jilz̈quiz chiijo, “Jila, am c̈hjujcquiztan nii cjujchilla apakz̈inac̈ha”, cjicanajo? Ana zum z̈oñic̈ha amqui. Primeruqui am persun c̈hjujcquiztan pajk cjujchi apakalla. Nekztan zuma cherasac̈ha. Y niz̈aza am jilz̈ c̈hjujcquiztan cjujchilla apakasac̈ha. —Jalla nuz̈ tjaajinchic̈ha Jesusaqui uj puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Niz̈aza z̈oñinacz̈ kamañ puntuquiztan Jesusaqui tjaajinchic̈ha tuz̈ cjican: —Tsjii zum muntiquiztan ana zum frutanaca anawira pookasac̈ha. Niz̈aza tsjii ana zum muntiquiztan zum frutanaca anazakaz pookasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Niz̈aza zapa muntinaca niiz̈ frutanacquiztan pajza. Jalla niz̈tiquiztan tsjii ch'ap muntiquiztan higo fruta anaz̈ pooki atasac̈ha. Niz̈aza tsjii ch'ap muntiquiztan uwas fruta anaz̈ pooki atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tsjii zuma kuzziz z̈oñiqui zuma takunaca paljayñipanc̈ha. Tsjii ana zuma kuzziz z̈oñizti ana zuma takunaca paljayñipanc̈ha. Jaknuz̈t kuzquiz pinsic̈haja, jalla nuz̈ chiic̈ha z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jesusaqui cjichizakazza: —Anc̈hucqui anaz̈ weriz̈ chiitacama kamc̈ha. Jaziqui, ¿kjaz̈tiquiztan anc̈hucqui wejt tjuu aynakjo, wilta wiltajo, “Wejt Jiliri, wejt Jiliri”, cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yekjap z̈oñinacazti wejtquin tjonz̈cu wejt takunaca tjapa kuz nonz̈a Niz̈aza weriz̈ chiitacamaz̈ kamc̈ha. Jalla tiz̈taz̈ nii z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jalla nii z̈oñiqui kjuya kjuychic̈ha. Primeraqui yoka jwetchic̈ha, maz zalzjapa. Nii mazquin zalz̈cu, jalla nii maz juntuñ chjuczic̈ha nii kjuy simintu. Nekztan kjuya pirkichic̈ha. Wiruñaqui tsjii puju kjaz chjijpi ojkchic̈ha, walja pjatsi. Nekztanaqui nii kjazqui ojkchic̈ha, kjuya t'eznata. Pero anapan t'ezñi atchic̈ha. Nii kjuyaqui maz juntuñ kjuytatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yekjap z̈oñinacazti wejt taku ana tjapa kuz nonz̈a. Niz̈aza weriz̈ chiitacama anaz̈ kamc̈ha. Jalla tiz̈taz̈ nii z̈oñiqui. Jalla nii z̈oñiqui kjuyazakaz kjuychic̈ha, ana maz simintuchiz. Wiruñaqui niz̈azakaz tsjii puju pjatzi, kjazqui kjuya t'ezinsjapa ojkchic̈ha. Nekztanaqui nii kjuyaqui ezzic̈ha. K'ala kuztac̈ha. Jalla niz̈taz̈ nii ana weriz̈ chiitacama kamñi z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesusaqui nuz̈ paljayz z̈erz̈cuqui, Capernaum cjita watja ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Nicju tsjii romano zultat jiliri z̈elatc̈ha. Niiz̈ ancha zuma piyunaqui ancha laatac̈ha, ticzmayatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nii zultat jiliriqui Jesusiz̈ quintu zizcu, tsjii kjaz̈ultan judionacz̈ jilirinaca cuchanz̈quichic̈ha, Jesusiz̈quiz rocz̈cajo niiz̈ piyuna c̈hjetnajo. ");
INSERT INTO capNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jalla nekztanaqui mantita z̈oñinacaqui Jesusiz̈quiz macjatchic̈ha. Nekztanac ancha roct'ichic̈ha, tuz̈ cjican: —Tii zultat jiliriqui ancha zumac̈ha. Jalla niz̈tiquiztan yanapchucapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Uc̈hum watja walja rispitñic̈ha. Niz̈aza tsjii uc̈humz̈ ajcz kjuya kjuykatchic̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","7","Nekztanaqui Jesusaqui nii rocñinacz̈tan ojkchic̈ha. Kjuya z̈cati cjisnan, nii zultat jiliriqui tsjii niiz̈ mazinaca cuchanz̈quichic̈ha, Jesusiz̈quiz chii, tuz̈ cjican: —Wejt jiliri, am yujcquizic anal waquizuc̈ha, am wejt kjuyquiz luzajo. Wejrqui persunpacha eksinc̈ha am kjuri ojkzjapa. Am ojkzqui ch'amaz̈ cjesac̈ha. Tekztanpacha tsjii taku chiyalla. Nuz̈ amiz̈ chiitiquiztanac z̈etaquic̈ha wejt piyunaqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wejrmi wejt jiliriz̈ mantitacama ojklayiñc̈ha. Niz̈aza wejt zultatunacaqui weriz̈ mantitacama ojklayñic̈ha. Jaziqui tsjiimil mantuc̈ha, “Oka” cjican. Nekztan ojkc̈ha. Niz̈aza tsjiimil kjawznuc̈ha. Nekztanac tjonc̈ha. Niz̈aza tsjiimil mantuc̈ha, “Tiz̈ta paa” cjican. Niimi zakaz paac̈ha. Niz̈tazakaz amqui mantasac̈ha, wejt piyuna z̈etajo. ");
INSERT INTO capNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jalla niz̈ta taku nonz̈cu, Jesusaqui, chiichic̈ha: —Cusapachaz̈ chiic̈ha nii z̈oñiqui, —cjican. Nekztanaqui apsñi z̈oñinacz̈ kjutñi chersic̈ha. Cherz̈cu tuz̈ cjichic̈ha: —Chekapan tii z̈oñiqui juc'ant Yoozquin kuzzizza tjapa Israel wajtchiz z̈oñinacz̈quiztanami. ");
INSERT INTO capNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nii jiliriz̈ cuchanta z̈oñinacaqui jilirz̈ kjuya irantiz̈cu chekapan laa piyuna z̈ejtchi zalchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Wiruñaqui Jesusaqui tsjii Naín cjita watja ojkchic̈ha, niiz̈ tjaajinta z̈oñinacz̈tan niz̈aza tama z̈oñinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wajt z̈cati irantiz̈cu, tsjii alma callñi cherchic̈ha. Jalla nii ticziqui zinta maatitac̈ha. Niiz̈ maaqui z̈ewtac̈ha. Walja nii wajtchiz z̈oñinacaqui cumpañtatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cherz̈cu, Jesucristu Jiliriqui naa maatak z̈onaquiz okzic̈ha, tuz̈ cjican: —Ana kaa amqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nekztanaqui Jesusaqui z̈catz̈inchic̈ha. Almiz̈ cajuna lanzic̈ha. Alma callñinacaqui nuz̈quiz tsijtsic̈ha. Nekztanaqui Jesusaqui ticzi z̈oñz̈quiz cjichic̈ha: —Jilala, amquiz cjiwc̈ha, “Z̈aaz̈na”. ");
INSERT INTO capNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jalla nii chiitiquiztanaqui nii ticzi z̈oñiqui z̈aazic̈ha. Nekztanac chii kallantichic̈ha. Nekztanaqui Jesusaqui niiz̈ maaquiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jalla nuz̈ cherz̈cu, tjappacha tsucchic̈ha. Niz̈aza tjappacha Yoozquin honora waytichic̈ha, tuz̈ cjican: —Uc̈hum wajtquizpacha tsjii chawc Yooziz̈ cuchanz̈quita z̈oñiqui jecsila, oré. Yoozqui niiz̈ wajtchiz z̈oñinaca yanapi tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jalla nekztanaqui tjapa Judea yokaran niz̈aza nii yok tjiyaran Jesusiz̈ zuma paata quintu ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan Bautistaz̈ tjaajinta z̈oñinacaqui nii z̈oñi jacatatchi quintu quint'ichic̈ha Juanz̈quiz. Jalla niz̈tiquiztan Juanqui Jesusiz̈ quintu zizzizakazza. Nekztanaqui pucultan niiz̈ tjaajintanaca kjawzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Nekztan Jesusiz̈quin cuchanz̈quichic̈ha, niiz̈quin pewcznajo, tuz̈ cjican: —Cristuqui tjonitaz̈ cjila. ¿Amqui Yoozquiztan cuchanz̈quita Cristumpankaya; uz yekjaz̈ tjonasaj? ");
INSERT INTO capNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Juanz̈ cuchanta z̈oñinacaqui Jesusiz̈quin z̈catz̈inchic̈ha. Jalla nekztanaqui irantiz̈cu, cjichic̈ha: —Juan Bautistaqui wejrnacz̈ cuchanz̈quic̈ha amquiz pewcznajo: “Cristuqui tjonitaz̈ cjila. ¿Amqui nii Cristumkaya, uj yekjaz̈ tjonasaj?” ");
INSERT INTO capNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nii orapacha nuz̈ irantitiquiztan Jesusaqui walja z̈ejlñi laanaca c̈hjetinchic̈ha. Niz̈aza zajraz̈ tanta z̈oñinaca c̈hjetinchic̈ha. Niz̈aza zur z̈oñinacz̈ c̈hjujqui c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jalla nekztanaqui Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Juanz̈quin quepa. Amiz̈ chertanaca nonz̈tanaca quint'iz̈ca. Weriz̈ paatanaca mazca. Zur z̈oñinaca cherzñi cjissila. Niz̈aza coj z̈oñinaca zuma kjojchchiz ojklayñi cjissila. Niz̈aza mojkchi janchichiz z̈oñinacami zuma janchichiz z̈ejtc̈hi cjissila. Niz̈aza oñ z̈oñinacami nonzñi cjissila. Niz̈aza ticzi z̈oñinaca jacatatchi cjissila. Niz̈aza pori z̈oñinacz̈quiz Yooz liwriiñi taku paljaytapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jakziltat weriz̈ paatanaca, chiitanaca nonz̈cu ana kuz turwayziz̈laj niiqui, walipanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juanz̈ cuchanz̈quita z̈oñinacaz̈ ojktan, Jesusaqui Juanz̈ puntuquiztan chiichic̈ha. Tjapa z̈oñinacz̈quiz tuz̈ cjichic̈ha: —¿C̈hjulu ch'ekti yokquin cherzñi ojkchinc̈huctaya? ¿Tsjii tjamiz̈ tjizinta kalu cherzñi ojkchinc̈huctaya? Anapanz̈ jaz. ");
INSERT INTO capNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Tsjii finu zquitchiz z̈oñi cherzñi ojkchinc̈huctaya? Anapanz̈, jaz. Finu zquitchiz z̈oñinaca chawc jilirz̈ kjuyquiz z̈ejlc̈ha. Niz̈aza wali jiru kamñi cusasanacchiz z̈oñinaca chawc jilirz̈ kjuyquiz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Nekztanac, ¿c̈hjulu cherzñi ojkchinc̈huctajo? Yooz taku paljayñi profeta cherzñi ojkchinc̈hucc̈ha. Nuz̈upancha. Juanqui Yooz yujcquiz juc'antic̈ha parti Yooz taku paljayñi profetanacz̈quiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juanz̈ puntuquiztan Yooz tawk libruquiz cjijrtac̈ha tuz̈ cjican: “Yooz Ejpqui tsjii z̈oñi cuchanz̈caquic̈ha ima Cristuz̈ Yooz taku paljayi ojklayan. Nii z̈oñiqui Israel z̈oñinacz̈quiz Cristo zuma tjewskataquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Juan Bautistac̈ha parti z̈oñz̈ maatiquiztan tsjan juc'antiqui. Pero tjapa Yoozquin kuzziz z̈oñimi Yooz maati cjequic̈ha. C̈hjul Yooz maatimi z̈oñz̈ maatiquiztan tsjaa juc'antic̈ha. —Jalla nuz̈ cjichic̈ha Jesucristuqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jalla nuz̈ nonz̈cuqui tjapa Juanz̈ bautistaz̈ z̈oñinacami cjichic̈ha: —Zumapanc̈ha Yooz Ejpqui, —cjicanaqui. Nuz̈uzakaz cjichic̈ha impuesto cobriñi z̈oñinacami, Juanz̈ bautista cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero fariseo z̈oñinacazti judioz̈ lii tjaajiñinacz̈tanpacha Yoozquin kuzziz puntuquiztan chiiz̈inta ana juyzu paachic̈ha. Niz̈aza Yooziz̈ cuchanz̈quita Juan Bautista ana rispitchicha. Niz̈tiquiztanaqui ana Juanz̈ bautistatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesucristo Jiliriqui cjichic̈ha: —¿Kjaz̈tat tii timpuquiz z̈ejlñi z̈oñinacajo? ¿Jectnaca iratatajo tinacajo? ");
INSERT INTO capNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ocjala irataz̈ tiinaca, ¿ana jaa? Ocjalanacaqui palazquin uzincan niiz̈ mazinacz̈quiz altu tawkz̈tan kjaw kjawc̈ha, tuz̈ cjican: “Wejrnacaz̈ pincallu pjujtan, ana tsajtchinc̈hucc̈ha anc̈hucqui. Wejrnacaz̈ llaquita itsan, ana kaachinc̈hucc̈ha”. Jalla niz̈ta ocjala iratac̈ha tii timpuquiz z̈ejlñi z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","¿Kjaz̈tiquiztan niz̈ta iratajo? Juan Bautistaqui tjonchic̈ha. T'anta ana lujlñitac̈ha. Vinumi ana licñitac̈ha. Jalla niz̈tiquiztan anc̈hucqui chiichinc̈hucc̈ha: “Zajriz̈ tantac̈ha niiqui”, cjican. ");
INSERT INTO capNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Wiruñaqui wejrqui tjonchinc̈ha. C̈hjulumi lujlchinc̈ha. Niz̈aza c̈hjulumi licchinc̈ha. Jalla niz̈tiquiztan anc̈hucqui wejt quintra chutc̈ha: “Walja lujlñic̈ha licñic̈ha tiiqui. Jalla tiipanc̈ha ujchiz z̈oñinacz̈ maziquiya, niz̈aza impuesto cobriñinacami”. Nuz̈ chiyiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tuz̈ zakal cjiwc̈ha: Yooz puntu zuma zizñi z̈oñinacaqui Yooz tjaajinta puntu tjeez̈a. ");
INSERT INTO capNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wiruñaqui tsjii fariseo z̈oñiqui Jesusa luli kjawzic̈ha. Nekztanaqui niiz̈ kjuya ojkchic̈ha Jesusaqui. Niiz̈ kjuya irantiz̈cu misquiz julzic̈ha lujlzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nii wajtquizpacha tsjaa ancha ujchiz maatak z̈onqui z̈elatc̈ha. Jesusa luli ojkchi quintu zizcu, fariseo z̈oñz̈ kjuya irantiz̈quichiñc̈ha alabastro cjita maz putillz̈tan. Nii putillaqui zuma uluraz aceiti chjijpitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Niz̈aza naaqui ancha kaacan Jesusiz̈ kjojch latuquiz julzinc̈ha. Jalla nekztanaqui naaz̈a c̈hjujc kaj c̈hjojcan Jesusiz̈ kjojcha awjzñi kallantichinc̈ha. Nekztan naaz̈a persun charz̈tan Jesusiz̈ kjojcha chjujzinchinc̈ha, zuma kjoñipacha. Nekztan Jesusiz̈ kjojcha chjulsinc̈ha. Nekztanaqui Jesusiz̈ kjojchquiz nii zuma uluraz aceitiz̈tan tjajlzinchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jalla nuz̈ cherz̈cuqui, fariseo impitñi z̈oñiqui persun kuzquiz pinsichic̈ha, tuz̈ cjican: “Tii z̈oñiqui ultim werar Yooz taku paljayñi z̈oñiz̈laj niiqui, tiiqui zizkalal, taa maatak z̈oñ ancha uj payiñc̈ha, jalla nii. Taa z̈oñzti tiiz̈ kjojcha zakal lanlanz̈la”. ");
INSERT INTO capNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jalla nekztanaqui Jesusaqui fariseo z̈oñz̈quiz cjichic̈ha: —Simona, amquiz tsjii taku chiyasac̈ha. Nekztan nii Simón cjita fariseuqui kjaazic̈ha, tuz̈ cjican: —Tjaajiñi, wejtquiz chiyalla. ");
INSERT INTO capNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Tsjii pucultan z̈oñiqui denario cjita paaz kajatac̈ha. Tsjii z̈oñiqui 500 denario cjita paaz kajatac̈ha. Tsjiizuñzti 50 denario kajatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jalla nekztanaqui nii pucultanaqui ana wira pjojki atchic̈ha. Niz̈tami ana wira pjojki atchiz̈ cjen nii kajñi z̈oñiqui nii pucultan z̈oñinacz̈quiz cjichic̈ha: “Anc̈hucaz̈ kajz̈ta paazqui anal cobrac̈ha. Jaziqui nuz̈quizpanikal pertunac̈ha”. Nekztanaqui Jesusaqui fariseo z̈oñz̈quiz pewczic̈ha, tuz̈ cjican: —Jaziqui kjaaznalla amqui. ¿Jakziltat nii pucultan z̈oñz̈quiztan nii ana cobriñi z̈oñz̈quiz juc'anti k'aachiiñi cjesaya? ");
INSERT INTO capNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Jalla nekztanaqui Simón cjita fariseuqui kjaazic̈ha, tuz̈ cjican: —Nii pajk kaja ana cobrita z̈oñiqui juc'ant k'aachiñi cjec̈hani. Nekztanaqui Jesusaqui cjichic̈ha: —Razunam chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nekztanaqui naa maatak z̈ona kjutñi cherz̈cu Jesusaqui Simonz̈quiz cjichic̈ha: —Wejrqui am kjuya luzquichinc̈ha. Amqui anam kjaz onanchamc̈ha, tii wejt kjojcha awjzjapa. ¿Taa maatak z̈on cherkay? Taa maatak z̈onzti persun c̈hjujc kajlliz̈tan wejt kjojcha awjzinc̈ha. Nekztanaqui persun charz̈tan chjujzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Amqui wejtquiz anam chjulzamc̈ha. Naazti nuz̈ luzcu wejt kjojchami chjul chjulz̈inchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amqui wejt achquiz ana aceitimi alz̈inchamc̈ha. Naazti wejt kjojchquizimi zuma uluraz aceite alzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jalla niz̈tiquiztan amquiz chiiz̈inuc̈ha tuz̈u. Walja naaz̈a ujnaca pertuntiquiztan taa maatak z̈onqui juc'anti wejr k'ayachtic̈ha. Jakziltat ujlliquiztan pertunta cjec̈haja, jalla niiqui anaz̈ juc'anti k'ayachtic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jalla nekztanaqui Jesusaqui naa maatak z̈onaquiz cjichic̈ha: —Am ujnacaqui pertuntac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nekztan parti impitta z̈oñinacaqui nii nonz̈cu ninacpora parla kallantassic̈ha, tuz̈ cjican: —¿Ject tii z̈oñejo? Wali ujnacamiz̈ pertunla. Ujquiztan z̈oñinacamiz̈ pertunc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesusaqui naa maatak z̈onaquiz cjichic̈ha: —Amiz̈ criitiquiztan jaziqui amqui liwriitac̈ha. Jaziqui cuntintum okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Wiruñaqui Jesusaqui wacchi watjanacaran jochinacaran ojklaychic̈ha. Jalla nuz̈ ojklaycan Yooz mantita zuma kamaña, jalla nii puntu paljaychic̈ha. Niiz̈ tuncapan illzta apostolonaca niiz̈tan chicapachatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Niz̈aza tsjii kjaz̈ultan niiz̈ c̈hjetinta maatakanaca cumpañtichic̈ha, ninacz̈tan chica. Niiz̈ tuquiqui nii maatakanacaqui zajraz̈ tantatac̈ha, y niz̈aza conanacchiztac̈ha. Jalla nii maatakquiztan tsjaaqui María Magdalena cjititac̈ha. Jalla naaquiztan pakallak zajranaca ulanchitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Niz̈aza tsjaa z̈on z̈elatc̈ha, Juana cjiti, Chuza cjita z̈oñz̈ tjuntac̈ha. Naaz̈a lucuqui Herodes cjita jiliri yanapñi secretariotac̈ha. Niz̈aza tsjaa Susana cjiti z̈on z̈elatc̈ha. Niz̈aza tsjii kjaz̈ultan iya maatakanacaqui apsñitac̈ha. Nii maatakanacaqui persun cusastan atintiñitac̈ha Jesusiz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Walja z̈oñinacaqui watjanacquiztan Jesusa cheri ulanz̈quichic̈ha. Walja z̈oñinacaz̈ nuz̈ juntazziz̈ cjen, Jesusaqui tsjii quintu quint'ichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Tsjii zkala c̈hjacñi z̈oñiqui zkal c̈hjaqui ojkchic̈ha. Nekztan zkal semilla wichcan wichcan c̈hjacchic̈ha. C̈hjaccan, parti semillanacazti jiczaran tjojtsic̈ha. Nii tjojtsi semillaqui tjecantatac̈ha, y niz̈aza wez̈lanacaz̈ lujltatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Tsjii parti zkal semillanacazti maz yokaran tjojtsic̈ha. Nii tjojtsi semillanacaqui jecz̈canpacha nuz̈quiz kjoñchic̈ha. Anaz̈ umit yoka z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Parti zkal semillanacazti ch'ap yokaran tjojtsic̈ha. Nuz̈ juntu pakan ch'apinacakazza atipchiqui. ");
INSERT INTO capNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Parti zkal semillanacazti zum yokquiz tjojtsic̈ha. Nekztan pajkchic̈ha. Nuz̈ pajkz̈cu, zuma c̈hjeri pookchic̈ha, patac c̈hjerchiz zapa chjojlluquiz. —Nuz̈ quint'iz̈cu Jesusaqui altu tawkz̈tan cjichic̈ha: —Jecc̈halaj cjuñchiz niiqui, z̈-nonz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jalla nekztanaqui niiz̈ tjaajinta z̈oñinacaqui Jesusiz̈quiz pewczic̈ha: —¿Jaknuz̈t chii tii am takojo? —cjican pewczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jalla nekztanaqui Jesusaqui kjaazic̈ha tuz̈ cjican: —Anc̈hucaquiz Yoozpachaz̈ tjaajnaquic̈ha anc̈huca kuzquiz, niiz̈ mantita kamañ puntuquiztan, nii. Yekjap z̈oñinacz̈quizzti quintunacz̈tankaz chiyuc̈ha Yooz mantita kamaña puntuquiztan. Jalla nuz̈quiz weriz̈ chiita quintu nonz̈cuqui parti z̈oñinacaqui ana wira intintiñiz̈ cjissa. Weriz̈ chiitiquiztanaqui ana wira tantiiñiz̈ cjissa. ");
INSERT INTO capNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz cjichic̈ha: —Jalla tiz̈ta puntunacquiztanz̈ chiic̈ha wejt zkala c̈hjacz quintuqui. Yooz takuc̈ha nii zkal semillanacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nii jiczaran z̈ejlñi z̈oñinacaqui Yooz taku nonzic̈ha. Yooz taku nonz̈tanaqui, diablu cjita zajraqui tjonza, ninacz̈ kuz turwayz̈inzjapa. Jalla nuz̈ paac̈ha diabluqui, nonzñi z̈oñinacaz̈ Yooz taku ana criyajo, y niz̈aza ninacaz̈ ana liwriita cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Niz̈aza nii maz yokaran z̈ejlñi z̈oñinacaqui Yooz taku nonzic̈ha. Yooz taku nonz̈cupacha cuntintuz̈ catokc̈ha. Pero Yoozquin tjapa kuzzizpan ana nonz̈a. Tsjiipacamakaz catokc̈ha. C̈hjul pruebaz̈ tjonanami ratullaz̈ quejpsa. ");
INSERT INTO capNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Niz̈aza nii ch'ap yokaran z̈ejlñi z̈oñinacaqui Yooz taku nonzic̈ha. Yooz taku nonz̈cu anaz̈ tjapa kuztan catokc̈ha. Cusasanacapankaz cherza; niz̈aza wali jiru kamspanz̈ pecc̈ha; niz̈aza pjijstanacapankaz pecc̈ha. Jalla niz̈tiquiztan c̈hjul ana walinaca tjontan, ninacz̈ kuznaca turwayskatc̈ha. Persun kuzquiz pectiquiztanaqui Yooz taku tjatz̈a. Jalla niz̈tiquiztan ana zuma kamasac̈ha. Ana pookñi zkalaz̈takaz kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nii zum yokquiz z̈ejlñi z̈oñinacaqui Yooz taku nonzic̈ha. Tjapa kuztan Yooz taku nonz̈a. Tjapa kuztanz̈ catokc̈ha. Niz̈aza Yooz takucama zuma kamc̈ha Yoozquin tjurt'iñi kuzziz. Jalla niz̈tiquiztan zuma pookñi zkalaz̈takaz kamc̈ha, zumapankaz kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jesusaqui tjaajinchic̈ha tuz̈ cjican: —Anaz̈ jecmi micha tjeeznasac̈ha cajun kjuyltan nonzjapa, uz̈ tjajz zquit koztan nonzjapa. Micha tjeez nonz juntuñpanz̈ nekzipan tewznasac̈ha kjuyquiz luzñi z̈oñinac̈zquin kjanajo. ");
INSERT INTO capNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","C̈hjulu c̈hjojz̈tami waz̈tapanikaz cjequic̈ha. Niz̈aza ana Yooz puntu ziztanacami kjanapacha ziztapanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Weriz̈ chiita taku zuma nonz̈nalla anc̈hucqui. Jakziltaz̈laj catokñi kuzziz niiqui, juc'anti zuma kuz tjaataz̈ cjequic̈ha, Yooz taku intintajo. Jakziltaz̈laj ana catokñi kuzziz niiqui, juc'anti turwayskattaz̈ cjequic̈ha. Jalla niz̈tiquiztan Yooz takuqui anapan intintiñiz̈ cjequic̈ha, “intintuc̈ha wejrqui” chiichiz̈ cjenami. —Jalla nuz̈ tjaajinchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wiruñaqui Jesusiz̈ maatan niiz̈ lajknacz̈tan irantiz̈quichic̈ha, jakziquin Jesusac z̈elatc̈haja, jalla nicju. Pero niiz̈quin ana macjati atchic̈ha. Kjuyquiz walja z̈oñinaca z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jalla nekztanaqui tsjii z̈oñiqui Jesusiz̈quiz mazzic̈ha, tuz̈ cjican: —Am maami am jilanacami kjuy zancu z̈ejlc̈ha. Am cherz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesusaqui nekztan kjaazic̈ha, tuz̈ cjican: —Yooz taku nonzñi z̈oñinacaqui y niz̈aza Yooz takucama kamñi z̈oñinacaqui, ninacapanc̈ha wejt familia cuntaqui, wejt maa cuntaqui, y niz̈aza wejt jilanaca cuntaqui. ");
INSERT INTO capNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Tsjii nooj Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tan luzzic̈ha tsjii warcuquiz. Nekztanaqui tuz̈ cjichic̈ha: —Tii kotz̈ nawjktuñtanz̈ ojklay. ");
INSERT INTO capNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Jalla nuz̈ ojkcan Jesusaqui tjajchic̈ha. Nekztanaqui tiripintit wali pjursanti tjami zalchic̈ha. Jalla nii tjamiz̈ cjen warcuqui kjaz ljojkiz̈tan julzmayaz̈ cjisnatc̈ha, kjaz chjijpi. ");
INSERT INTO capNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nekztanaqui Jesusiz̈ tjaajinta z̈oñinacaqui Jesusa z̈inchic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, Tjaajiñi Maestro, kotquiz julzmayaz̈ cjis uc̈humqui. Ticznac̈han uc̈humni. —Jalla nuz̈ chiitiquiztanaqui Jesusaqui z̈aazic̈ha. Nekztanaqui tjamz̈quiz niz̈aza kjaz ljojkimi mantichic̈ha apaltajo. Jalla nuz̈ mantitiquiztanaqui tjamimi kjaz ljojkimi apaltichic̈ha. Ch'ujupan cjissic̈ha. Nuz̈quiz walikaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —¿Ana wejtquin kuzziz cjissinc̈huckaya? —Nuz̈ pewcztiquiztan, nii tjaajinta z̈oñinacazti tsucchi ispantichi cjissic̈ha. Niz̈tiquiztan ninacpora parlassic̈ha, tuz̈ cjican: —¿Ject tii z̈oñejo? Tjamimi kjazmi tiiz̈ mantitacamaz̈ ojkc̈ha, tiiz̈ chiita takukaz cazza. ");
INSERT INTO capNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Niz̈tami Gadara cjita yokquin irantichic̈ha, kotz̈ nawjktuñtan, Galilea cjita yokz̈ nawjktuñtan. ");
INSERT INTO capNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesusa yokquiz chjijwz̈tan tsjii nii wajtchiz z̈oñiqui macjatz̈quichic̈ha. Az̈k watanaca zajraz̈ tantapantakalc̈ha nii z̈oñiqui. Zajraz̈ tantiquiztan ana zquiti cutñitakalc̈ha. Niz̈aza ana kjuyquizimi kamñitakalc̈ha. Campu santuran kamñitakalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Jesusa cherz̈cu, niiz̈ yujcquiz tuzi t'okzic̈ha yokquizpacha; kjawcan puct'ichic̈ha. Nekztanaqui Jesusaqui z̈oñi tanñi z̈ajra mantichic̈ha z̈oñz̈quiztan ulnajo. Nii chiitiquiztan zajraqui kjawchic̈ha, tuz̈ cjican: —Jesusa, Arajpach Yooz Maati, ¿kjaz̈tiquiztan am wejtquiz mitisi? Am roct'uc̈ha, anaz̈ wejr tjatnalla, anaz̈ wejr sufriskatalla. Tuquiqui wilta wilta zajraqui nii z̈oñi tanñitakalc̈ha. Niz̈aza nii wajtchiz z̈oñinacaqui zajraz̈ tanta z̈oñi c̈hejlñitakalc̈ha, y niz̈aza carinz̈tan mokñitakalc̈ha. Jalla nuz̈ moktiquiztanami c̈hejltiquiztanami carina kojkz̈cu atipasñipankaztakalc̈ha. Jalla nekztan zajraqui nii z̈oñi ch'ekti yokaran zajt zajtskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nekztanaqui Jesusaqui nii pewczic̈ha, tuz̈ cjican: —¿C̈hjul tjuuchizzamta? Nii zajraqui kjaazic̈ha: —Tama cjitaz̈ wejrqui, —cjican. Tama zajranacaqui nii z̈oñz̈quiz lusñitakalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Z̈cati cururan wacchi cuchinacaqui lujlcan z̈ejlñitakalc̈ha. Jalla niz̈tiquiztan zajranacaqui Jesusiz̈quiz rocchic̈ha, tuz̈ cjican: —Anaz̈ wejrnac casticta cjeyajo mantalla. Nii cuchinacz̈quin luzkatalla. —Jalla nuz̈ mantiskatz pecchic̈ha zajranacaqui. Nekztanaqui Jesusaqui nuz̈ mantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jalla nekztanaqui nuz̈ mantitiquiztan zajranacaqui z̈oñz̈quiztan ulanz̈cu cuchinacz̈quin luzi ojkchic̈ha. Cuchinacz̈quin luzcuqui cuchinaca tjiiranchic̈ha tsjii k'aw kjutñi. Nekztanaqui nii cuchinacaqui kossucpacha tjojtsic̈ha nii barranc k'awquiz. Niz̈aza kotquin tjojtsic̈ha. Jalla nuz̈quiz tjapa ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Cuchi itzñinacaqui nii cherz̈cu walja tsucchi zajtchic̈ha. Watjaran jochiran quintu quint'ican ojklaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Nii quintu nonz̈cu walja z̈oñinacaqui ojkchic̈ha nii paatanaca cheri. Jesusiz̈quin irantiz̈cu, nii zajraz̈ tanta z̈oñi z̈ejtchi cherchic̈ha. Nii z̈oñiqui julzi z̈elatc̈ha Jesusiz̈ kjojch latuquiz, zquiti cujtchi. Niz̈aza zuma tawkchiztac̈ha, ana lucuratz̈takaztac̈ha. Jalla nuz̈ cherz̈cu, nii cheri tjonchi z̈oñinacaqui nuz̈quiz ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Nii z̈oñi c̈hjetiñi cherchi z̈oñinacaqui quint'ichic̈ha parti z̈oñinacz̈quiz, jaknuz̈t Jesusaqui z̈oñi c̈hjetinc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Nii quintu nonz̈cu, tjapa Gadara cjita yokquiz z̈ejlñi z̈oñinacaqui Jesusiz̈quiz roqui kallantichic̈ha nawjk okajo. Nii z̈oñinacaqui cuchinacaz̈ pertissiz̈ cjen waljaz̈ eksnatc̈ha. Jalla niz̈tiquiztanaqui Jesusaqui tsjii warcuquiz luzzic̈ha, ojkzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nii zajriquiztan c̈hjetinta z̈oñiqui Jesusiz̈quiz rocchic̈ha, tuz̈ cjican: —Amtan chical ojkkatalla. Pero Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tekz am z̈ela. ");
INSERT INTO capNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Am kjuya oka. Z̈oñinacz̈quizim amqui quint'aquic̈ha jaknuz̈t Yoozqui am c̈hjetintc̈haja, jalla nii. Nekztanaqui nii z̈oñiqui ojkchic̈ha. Jalla nuz̈ ojkz̈cu tjapa kjutñi watjaran quint'ichic̈ha, jaknuz̈t Jesusaqui nii c̈hjetintc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jalla nekztanaqui Jesusaz̈ kotz̈ nawjktuñtan quejpz̈quitan, z̈ejlñi z̈oñinacaqui tjapa kuz risiwchic̈ha. Tjappacha Jesusiz̈ tjonz tjewsitac̈ha. Nekztanaqui niiz̈ tjontiquiztan cuntintutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jalla nekztan tsjii Jairo cjita z̈oñiqui irantiz̈quichic̈ha; ajcz kjuy jiliritac̈ha. Nii z̈oñiqui Jesusiz̈ yujcquiz puct'ichic̈ha. Nekztanaqui rocchic̈ha niiz̈ kjuya okajo. ");
INSERT INTO capNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nii oraqui nii z̈oñz̈ zinta majtqui ticzmayatac̈ha. Tuncapan watchiztac̈ha naa majtqui. Nekztan Jesusaqui jilirz̈ kjuya ojkchic̈ha. Jesusaz̈ okan, walja z̈oñinacaqui ts'acjascan apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jalla ninacz̈tan juntu tsjaa laa maatak z̈onqui okatc̈ha. Tuncapan wata inturu ljok ojkñi laa t'akjisichintakalc̈ha. Niz̈aza medicunacz̈quiz kullkatjawi ancha castassinc̈ha, ana c̈hjulchiz cjissintac̈ha. Nuz̈ kullkatz̈cumi ana wira z̈etatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Nekztanaqui naa laa z̈onqui Jesusiz̈ wir kjuttan macjatchinc̈ha. Niiz̈ zquit tjiiquiz lanzinc̈ha. Nii orapacha nuz̈ lanz̈cuqui z̈ejtchinc̈ha. Niz̈aza ljok ojkñimi tsijtsic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jalla nekztanaqui Jesusaqui pewczic̈ha, tuz̈ cjican: —¿Ject wejr lanzejo? Tjappacha ninacaqui ana zizñi chiichic̈ha, nuz̈ pewcz̈tiquiztan. Jalla nuz̈ cjen Pedruqui niiz̈ mazinacz̈tan cjichic̈ha: —Tjaajiñi Maestro, tii z̈oñinaca ancha amquiz ts'acjassa, niz̈aza tjapa kjuttanz̈ am tewjctewjcc̈ha. Jaziqui ¿kjaz̈tiquiztan am nuz̈ pewcz̈jo, “¿Ject wejr lanzejo?” cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Nekztanac Jesusaqui cjichic̈ha: —Tsjii tsjiiqui wejr lanzic̈ha. Wejr persun kuzquiz naychinc̈ha wejt aziqui tsjii c̈hjetinchic̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Naa maatak z̈onqui waj nuz̈ Jesusiz̈ kuzquiz pajta ziztiquiztan, cjarcatcan macjatchinc̈ha. Nekztan Jesusiz̈ kjojchquiz quillzinc̈ha. Tjapa z̈oñinaca z̈elan naaqui mazzinc̈ha, nii orac lanzintaz̈ naaqui, jalla nii. Niz̈aza nii lanz̈cu nii orapacha z̈ejtchi quirchinc̈ha naaqui. Jalla nuz̈ cjican mazzinc̈ha Jesusiz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Cullacalla, tjapa kuztan criichiz̈ cjen c̈hjetinta cjissamc̈ha. Jaziqui cuntintum am okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesusaz̈ ima naatan parla z̈erz̈nan, tsjii z̈oñiqui tjonchic̈ha Jairo cjita z̈oñz̈ kjuyquiztan. Nii Jairuqui ajcz kjuy jiliritac̈ha. Tjonchi z̈oñiqui Jairuz̈quiz cjichic̈ha: —Am majtqui ticzinpanc̈ha. Anam iya tii Maestruz̈quiz molistis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jalla nii takunaca nonz̈cuqui, Jesusaqui Jairuz̈quiz cjichic̈ha: —Ana am nic kuz turwayskata. Yoozquin tjapa kuzziz cjee. Nekztan am uzqui z̈etaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairuz̈ kjuya irantiz̈cu, Jesusaqui anaz̈ jecmi kjuyquiz luzkatchic̈ha. Jesusiz̈tan Pedruz̈tan, Jacobz̈tan, Juanz̈tan, naa uza maa ejpz̈tan jalla ninacakaz luzkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Nii kjuyquiz z̈ejlñi z̈oñinacaqui tjappachaz̈ kaatkalc̈ha. Niz̈aza naa uzaz̈ ticziz̈ cjen walja llaquitatakalc̈ha. Pero Jesusaqui ninacz̈quiz cjichic̈ha: —Anaz̈ kaa. Taa uzqui anac̈ha ticzin, antiz taa uzqui tjajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Nuz̈ Jesusiz̈ chiitiquiztan nii z̈ejlñi z̈oñinacaqui tjassic̈ha nii nonz̈cu. Ticzinpanc̈ha nuz̈ zizzic̈ha parti z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jalla nekztanaqui Jesusaqui naa uza kjara tanzinchic̈ha, y niz̈aza altu tawkz̈tan chiichic̈ha, tuz̈ cjican: —Kolta cullacalla, z̈aazna. ");
INSERT INTO capNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nii orapacha wilta z̈ejtchin cjissinc̈ha. Niz̈aza nii orapacha tsijtsinc̈ha. Nekztan Jesusaqui mantichic̈ha naa uzaquiz c̈hjeri tjaaznajo. ");
INSERT INTO capNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Naaz̈a maa ejpqui nuz̈ jacatatchiz̈ cjen ancha ispantichic̈ha. Nekztanaqui Jesusaqui ninacz̈quiz paljaychic̈ha: —Anaz̈ jecz̈quizimi chiichiyaquic̈ha tii c̈hjetinta quintu, —nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jalla nekztanaqui Jesusaqui niiz̈ tuncapan illzta apostolonaca kjawzic̈ha. Nekztan ninacz̈quiz mantiz azi tjaachic̈ha, tjapaman zajranaca chjatkatzjapa, niz̈aza tjapaman laanaca c̈hjetinzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Niz̈aza Jesusaqui ninacz̈quiz mantichic̈ha Yooz zuma kamañ puntuquiztan paljayajo, y niz̈aza laa z̈oñinaca c̈hjetnajo. ");
INSERT INTO capNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Niz̈aza cjichic̈ha: —Anc̈hucqui anaz̈ c̈hjulumi chjichaquic̈ha, jiczquin ojkcan. Anaza ajtsmi, anaza z̈ak quelsmi, anaza c̈hjerimi anaza paazmi. Niz̈aza zinta zquitikaz chjichaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Jakzi kjuyquinami irantiz̈cuqui nii kjuyquin alujasaquic̈ha. Jalla nicjuz̈ kamaquic̈ha, nii yokquiztan ojkzcama. ");
INSERT INTO capNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Yekjap wajtchiz z̈oñinacaqui anc̈huc anaz̈ risiwz pecaquiz̈ niiqui, nii wajtquiztanz̈ ulnaquic̈ha. Niz̈aza anc̈huca kjojchquiz zcatchi pulpunaca tsajt tsajtsnaquic̈ha. Jalla nii tsajt tsajtstaqui siñalaz̈ cjequic̈ha ninacz̈ quintra, anc̈huc ana risiwchiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jalla nekztanaqui Jesusiz̈ nuz̈ taku tjaatiquiztan apostolonacaqui niiz̈ mantitacama ojkchic̈ha. Tjapa jochinacz̈ kjutñi ojkchic̈ha, liwriiñi Yooz taku paljaycan, y niz̈aza laanaca c̈hjetincan. ");
INSERT INTO capNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tsjii chawc jiliriqui Herodes cjita z̈elatc̈ha. Jesusiz̈ quintu zizcu, ana c̈hjulumi naazipanc̈ha nii oraqui. Inakaz z̈elatc̈ha. Jesusiz̈ quintu nonz̈cu yekjapanacazti cjichic̈ha: —Juanqui ticziquiztan jacatatchiz̈lani. ");
INSERT INTO capNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yekjapanacazti chiichic̈ha tuz̈ cjican: —Tiila Eliasqui; jecz̈quichila. Elías cjitaqui tuquita Yooz taku paljayñi profetatac̈ha. Yekjapanacazti Jesusiz̈ puntu chiichic̈ha, tuz̈ cjican: —Tiila tsjii tuquita Yooz taku paljayñi profetaqui, jacatatchila. Jalla nuz̈ cjenami Herodes cjita jiliriqui inakaz cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Nii Herodesqui tuz̈ cjichic̈ha: —Wejrpanc̈ha mantichintqui, Juanz̈ acha murz̈cajo. Anziqui wacchi milajru paata quintunaca nonznuc̈ha. ¿Jectpan nii milajrunaca paañejo? ¿Juanpan cjesajo? Jalla nekztanaqui Herodesqui Jesusiz̈tan walja zalz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wiruñaqui Jesusiz̈ illzta apostolonacaqui cutjatchic̈ha. Nekztan Jesusiz̈quiz quint'ichic̈ha jaknuz̈t kamtc̈haja, jalla ninaca. Jalla nekztanaqui Jesusaqui ninaca chjitchic̈ha tsjii ana z̈ejlz yokquin, Betsaida cjita wajtz̈ z̈cati. ");
INSERT INTO capNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Nuz̈ ojkta zizcu, z̈oñinacaqui walja apzic̈ha. Nekztanaqui nuz̈ apz̈tiquiztan Jesusaqui zuma risiwchic̈ha. Ninacz̈quiz paljaychic̈ha Yooz mantita zuma kamañ puntu. Niz̈aza laanaca c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Zezi cjee ora Jesusiz̈ tuncapan illzta apostolonaca niiz̈quin macjatchic̈ha, tuz̈ cjican: —Tii z̈oñinaca cuchna joch kjutñi wajt kjutñi okaj cjee; tjajz kjuya kjurz̈caj cjee; niz̈aza lujlz c̈hjeri kjurz̈caj cjee. Tekziqui anaz̈ c̈hjulumi z̈ejlc̈ha. Jalla nuz̈ cuch waquizic̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesusaqui niiz̈ illzta apostolonacz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Anc̈hucz̈ antiz c̈hjeri tjaa. Ninacaqui kjaazic̈ha, tuz̈ cjican: —Anaz̈ wejtnacalta c̈hjulumi z̈ejlc̈ha. Pjijska t'antallz̈tan pizc ch'izlliz̈tan, niz̈tallakaz wejtnacalta z̈ejlc̈ha. Tinacz̈quiz tjaazjapa anapan wacasac̈ha. Tinacz̈quiz tjaasjapa, ¿c̈hjeri kjayi okasaya? ");
INSERT INTO capNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nii z̈ejlñi z̈oñinacaqui pjijska warank luctakatac̈ha. Nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈quiz cjichic̈ha: —Tjulz̈na tii z̈oñinacaqui pjijska tuncquiztan pjijska tunca jalla nuz̈ t'aka t'aka tjulz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jalla nuz̈ niiz̈ mantitacama paachic̈ha. Nekztan tjappacha julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nekztanaqui Jesusaqui persun kjarquiz nii pjijska t'anta nii pizc ch'iz tanzic̈ha. Nuz̈ tanz̈cu arajpach kjutñi cherzic̈ha. Nekztan Yooz Ejpz̈quin sparaquiz̈ cjichic̈ha, jalla nii t'antiquiztan, ch'izquiztan. Jalla nekztanaqui t'unz̈cu niiz̈ tjaajintanacz̈quiz chjalzic̈ha, parti z̈oñinacz̈quiz tojznajo. ");
INSERT INTO capNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nekztanaqui tjapa nii z̈oñinacaqui chjekañcama lujlchic̈ha. Jalla nuz̈ lujltanaqui z̈ejtchi t'anta ch'iz t'unanaca tuncapan canasta chjijpi ricujchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Tsjii nooj ana z̈oñinaca z̈elan, Jesusaqui Yooz Ejpz̈quin mayizatc̈ha. Niiz̈ tjaajinta z̈oñinacapantac̈ha niiz̈tan chicapachaqui. Jesusaqui ninacz̈quiz pewczic̈ha: —¿Jaknuz̈t pinsi z̈oñinacaqui wejt puntuquiztanajo? ");
INSERT INTO capNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Nekztanaqui nii tjaajintanacaqui kjaazic̈ha, tuz̈ cjican: —Yekjap z̈oñinacaqui cjic̈ha, Juan Bautistaz̈ amqui. Yekjapanacazti zakaz cjic̈ha, Elías amqui. Yekjapanacazti cjic̈ha, tuquita Yooz taku paljayñi profetaz̈lani jacatatchini, —jalla nuz̈ cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jaziqui nekztanaqui Jesusaqui wilta pewczic̈ha, tuz̈ cjican: —Anc̈huczti, ¿wejt puntuquiztan kjaz̈zaz̈ cjeejo? Pedruqui kjaazic̈ha, tuz̈ cjican: —Yooziz̈ cuchanz̈quita Crustumc̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jalla nekztanaqui Jesusaqui zumpacha niiz̈ tjaajintanacz̈quiz iwjt'ichic̈ha, ana jecz̈quizimi niz̈ta maznajo. ");
INSERT INTO capNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Niz̈aza Jesusaqui cjichic̈ha: —Yooz cuchanz̈quita z̈oñtc̈ha wejrqui. Pero walja sufristanc̈ha; niz̈aza wajt jilirinacami timplu chawc jilirinacami judioz̈ lii tjaajiñinacami wejr ana jiliriz̈takaz nayaquic̈ha. Niz̈aza wejr conta cjistanc̈ha. Niz̈aza c̈hjep majquiztan jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wiruñaqui tjapa nii z̈ejlñi z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Jequit wejttan chica kamz pecc̈haj niiqui, primiraqui persun kamañ wira tjatz̈la. Niz̈aza c̈hjul pruebanaca watanami zapuru wejttan chicapacha cjee, aunquimi persun wirami apt'ac̈hani. ");
INSERT INTO capNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jakziltat persun kamañ wira ana tjats pecc̈haj niiqui, arajpach kamañaqui ana tjaataz̈ cjequic̈ha. Jakziltat wejt laycu persun kamañ wira tjatznac̈haja, jalla niiqui arajpachquin wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Arajpachquin wiñaya kamañ wira pertaquiz̈ niiqui, ¿tii muntuquiz z̈ejlñi cusasa c̈hjuljapat sirwasajo? ");
INSERT INTO capNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Niz̈aza quintra z̈oñinacaz̈ z̈elan, jakziltat wejtquiztan wejt tawkquiztan ana pajñi chiyaquiz̈ niiqui, wejrqui niz̈tazakal niiz̈quiztan ana pajñi chiyac̈ha wejt mantiz timpuquiz, nekziqui. Tsjii noojiqui walja poderchiz quejpz̈cac̈ha wejt Yooz Ejpz̈ aztan, niz̈aza wejt Yooz Ejpz̈ anjilanacz̈tanpacha. Mantizjapa quejpz̈cac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Weraral cjiwc̈ha. Tsjii z̈oñinaca tekz z̈ejlcanpacha anaz̈ ticznaquic̈ha ima Yooz mantiz timpuquiz kallantan. ");
INSERT INTO capNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tsjii quinsakal tjuñquiztan Jesusaqui curulla yawchic̈ha Yooz Ejpz̈tan parli. Niz̈aza c̈hjepultan niiz̈ illzta z̈oñinaca chjitchic̈ha, Pedruz̈tan, Jacobz̈tan, Juanz̈tan; jalla ninacaqui Jesusiz̈tan chica ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yooz Ejpz̈tan parlican, Jesusiz̈ yujcmi niiz̈ cujtta zquitimi walja llijñi kjanapanikaz cjissic̈ha, chiwicamatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nii orapacha pucultan luctak z̈oñiqui parisiz̈quichic̈ha, Jesusiz̈tan parlisjapa. Nii pucultanaqui Moisestan Eliastantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Nii pucultanaqui walja chiw kjana llijñi taypiquiz tjonatc̈ha. Jesusiz̈ ticz puntu parlatc̈ha. Jerusalén wajtquiz jaknuz̈t ticznac̈haja jalla nii puntu. ");
INSERT INTO capNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Nii oraqui Pedruz̈tan niiz̈ mazinacz̈tan anchaz̈ tjaji tjonkatatc̈ha pero nii cherz̈cu ninacz̈ tjajimi zajtchic̈ha. Jesusiz̈ tjeez̈ta honora cherchic̈ha nii pucultan z̈oñinacaz̈ niiz̈tan z̈elan. Walja chiwi llijñi kjanñi cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Pucultan z̈oñinacaz̈ Jesusiz̈quiztan zarakan, Pedruqui cjichic̈ha: —¡Wejt Tjaajiñi Maestro, tekz z̈ejlzqui walipankazza! Jaziqui c̈hjep chjujlli kjuya kjuysla, tsjiiqui amta, tsjiiqui Moisesta, tsjiiqui Eliasta, jalla nuz̈. Pedruqui ana zuma tantiiz̈cu chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jalla nuz̈ Pedruz̈ chiyan, tsjii tsjiriz̈takaz macjatz̈quichic̈ha. Nekztan ninacz̈quiz urpuntichic̈ha. Jalla nuz̈ urpuntitiquiztan nii c̈hjepultan illzta z̈oñinacaqui walja tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Tsjirquiztan tsjii jora chiiz̈quiñi nonzic̈ha, jalla tuz̈ cjican: —Jalla tiic̈ha wejt k'ayi Maatiqui. Jalla tiiz̈ chiita taku nonz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jalla nuz̈ nii joraz̈ chiitan, Jesusaqui zinalla z̈elatc̈ha. Nii c̈hjepultan illztanacaqui nuz̈quiz ch'uju quirchic̈ha. Ana jecz̈quizimi nii cherta puntu chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Niiz̈ jaka taz̈u curquiztan chjijwz̈quichic̈ha. Walja z̈oñinacaqui Jesusiz̈tan zali tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nii tama z̈oñinacz̈quiztan tsjii z̈oñiqui altu tawkz̈tan paljaychic̈ha, tuz̈ cjican: —Wejt Tjaajiñi Maestro, wejt zinta majch cherz̈inz̈calla. ");
INSERT INTO capNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wilta wilta zajraz̈ tantac̈ha. Nii zajraqui anchaz̈ kjaw kjawkatc̈ha. Niz̈azaz̈ t'uckatc̈ha. Atquiztan ch'utuz̈ jupokskatc̈ha. Persun janchiz̈ c̈hjojritskatc̈ha. Niiz̈quiztan ana zarakz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Amiz̈ tjaajinta z̈oñinacz̈quiz rocchinc̈ha, wejt majch c̈hjetz̈inajo. Ana atchipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jalla nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tii z̈oñinacajay ana criiñipanc̈ha. ¡Walja ujnacchizc̈hucpanc̈ha anc̈hucjay! ¿C̈hjul oracamat anc̈hucatan wejr z̈elaquiya? ¿C̈hjul oracamat anc̈huca ujquiztan wejr awantaquiya? Niz̈taqui am majch zjijcz̈calla. ");
INSERT INTO capNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nii z̈oñz̈ laa majch Jesusiz̈quiz macjatan, zajraqui yokquiz tjojtchic̈ha. Wilta t'uckatchic̈ha. Jalla nekztanaqui Jesusaqui zajra ujzic̈ha. Nii z̈oñz̈ majch c̈hjetinz̈cu, niiz̈ persun ejpz̈quiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Nii Yooz aztan paata obra cherz̈cu tjapa z̈oñinacaqui ispantichic̈ha. Z̈oñinacaz̈ ispantichi z̈elan, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Tjapa kuztanz̈ tii weriz̈ paljayta nonz̈na anc̈hucqui. Anaz̈ tjatzna. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Quintra z̈oñinacz̈quiz wejr intirjital tarazuntal cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jalla nuz̈ chiyan niiz̈ tjaajinta z̈oñinacaqui ana intintazzic̈ha. Niz̈aza nii chiitaqui ana kjanzt'itatac̈ha, ninaca intintajo. Ana intintazcumi, pewcz eksnatc̈ha niiz̈ chiita taku kjana intintisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wiruñaqui niiz̈ tjaajinta z̈oñinacaqui ninacpora ch'aassi kallantichic̈ha, jakziltat ninacz̈quiztan tucquin cjes, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ninacz̈ kuz pinsita zizcu Jesusaqui tsjii uza tsijtskatchic̈ha niiz̈ latuquiz. ");
INSERT INTO capNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nekztan ninacz̈quiz paljaychic̈ha: —Jequit wejt cuntiquiztan tsjii uza risiwc̈haj niiqui, wejrpacha risiwc̈ha. Niz̈aza jequit wejr risiwc̈haja, niz̈aza risiwc̈ha wejr cuchanz̈quiñi. Jakziltat anc̈hucaquiztan wirquin nayta cjicjiyac̈haja, jalla niic̈ha tucquin zuma honorchizqui. ");
INSERT INTO capNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wiruñaqui Juanqui cjichic̈ha: —Wejt Tjaajiñi Maestro, tsjii z̈oñiqui am tjuu chiican zajranaca chjatkatchic̈ha. Nii cherz̈cu wejrnacqui ujzinc̈ha, “Ana niz̈ta paa”, cjican. Nii z̈oñiqui anac̈ha uc̈humnacatan ojklayñi. ");
INSERT INTO capNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesusaqui cjichic̈ha: —Anaz̈ nuz̈ atajc̈ha, jalla. Niz̈ta paañiqui anac̈ha uc̈humnacatan quintra. Jakziltaz̈laja ana uc̈humnacatan quintra, jalla niiqui uc̈hum favoraz̈ paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jalla nekztanaqui Jesusiz̈ arajpacha ojkz tjuñi z̈catz̈inz̈catc̈ha. Jalla niz̈tiquiztan walja p'ektichic̈ha Jerusalén watja ojkzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Niiz̈ tuqui z̈oñinaca cuchanchic̈ha, alujamint kjuya kjurz̈cajo. Jalla nekztanaqui nii cuchanta z̈oninacaqui Samaria cjita yokquin tsjii watja macjatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Nii Samaria wajtchiz z̈oñinacazti ana kjuyquiz kjawz pecatc̈ha Jesusaz̈ Jerusalén watja ojkz cjen. ");
INSERT INTO capNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Nii quintu nonz̈cu Jacobz̈tan Juanz̈tan Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, ¿kjaz̈t cjes? Wejrnacqui arajpachquiztan uj mantiz̈quila, cjiwc̈ha, ninaca tjatanzjapa. Jaknuz̈t tuqui timpu Elías cjita Yooz taku paljayñi profeta paatc̈haja, jalla nuz̈. Jalla nuz̈ waliz̈ cjesaz̈, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jalla nuz̈ chiitiquiztan Jesusaqui ninacaz̈ kjutñi cherzic̈ha. Nekztanaqui ujzic̈ha, tuz̈ cjican: —Anc̈huca kuzqui ana walic̈ha. Anaz̈ tantiyassa anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui tsewctan tjonchinc̈ha, ujchiz z̈oñinaca liwriizjapa. Ana tjonchinc̈ha ujchiz z̈oñinaca tjatanzjapa. Jalla nekztanaqui yekja watja ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jiczquiz okan, tsjii z̈oñiqui Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, jakziquinam ojkc̈haja amqui, wejrqui chicapachal ojklayz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Nekztan Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Kitinacami kjuychizza. Niz̈aza wez̈lanacami tjurchizza. Wejrzti anal kjuychizza, tjajzjapami. ");
INSERT INTO capNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Wiruñaqui Jesusaqui yekja z̈oñz̈quiz tuz̈ cjichic̈ha: —Wejttan chicaz̈ ojklaya. Nii z̈oñiqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, primiraqui wejt ticzi ejp tjatznac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Ticziz̈takaz ana zuma kamañchiz kamñi z̈oñinacaqui, jalla ninacaj ticzinaca tjatz̈la. Amqui ojkla, Yooz mantita zuma kamañ puntuquiztan paljayzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Wiruñaqui yekja z̈oñiqui Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, amtan chica ojklayz pecuc̈ha. Pero primiraqui wejt familianacz̈quiz wejt ojklayz puntu mazinz̈quiz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Jakziltat Yooztajapa langzñi kalltic̈haja, jalla niiqui tirapan Yoozta langz waquizic̈ha, ana wir kjutñi cherz̈cu. Jakziltat wir kjutñi cherznasaz̈ niiqui, niz̈aza tuquita kamañ wirquiz quejps pecasaz̈ niiqui, jalla niiqui anaz̈ Yooz mantita zuma kamaña tanznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jalla wiruñaqui Jesusaqui pakallak tunc z̈oñinaca illzic̈ha. Jalla nuz̈ illz̈cu Jesusaqui niiz̈ tuqui tjapa kjutñi pucultan pucultan cuchanchic̈ha, jakziquint okac̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ima cuchancan ninacz̈quiz cjichic̈ha: —Tsjii puntul chiiz̈inasac̈ha. Zkalaqui walja z̈ejlc̈ha. Pero zkala ajzñi z̈oñinacac̈ha upaqui. Yooz Ejpqui zkal Patrunac̈ha. Jalla niz̈tiquiztan Yooz Ejpz̈quiztan mayiza, zkala ajzñi z̈oñinaca cuchanz̈cajo. —Jalla nuz̈ paljaychic̈ha Jesusaqui, z̈oñinacac̈ha zkalaz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Niz̈aza Jesusaqui niiz̈ cuchanz̈quita z̈oñinacz̈quiz cjichic̈ha: —Anc̈hucqui uuzanacaz̈takaz cuchnuc̈ha. Tanñi kitinacaz̈ cheechi z̈oñinacz̈ taypiquin ojklayaquic̈ha anc̈hucqui. Jaziqui persunpachaz̈ cwitazaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Niz̈aza anaza quelsmi chjichaquic̈ha, anaza paaz pulsami. Ana enenz̈cu jiczquizic okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Tsjii kjuya luzcu, anc̈hucqui tsaanaquic̈ha, tuz̈ cjican: “Tii kjuychiz z̈oñinacaqui walipankaj cjila”. ");
INSERT INTO capNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nicju zuma kamñi z̈oñinaca z̈elaquiz̈ niiqui, walipankaz cjequic̈ha nii kjuychiz z̈oñinacaqui. Niz̈aza nii kjuyquiz zuma kamñi z̈oñinaca ana z̈elaquiz̈ niiqui, anc̈hucaz̈ tsaanta takuqui nuz̈quizkaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Kjuyquiztan kjuya ana ojklayaquic̈ha. Tsjii kjuya irantiz̈cu, nekzpachapan kamaquic̈ha. C̈hjulut nii kjuychiz z̈oninacaqui onac̈haja jalla niicz̈ lujlznaquic̈ha. Langzñi z̈oñinaca pacta cjis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Tsjii watja irantiz̈cu nii wajtquiz jakziltakat anc̈huc kjawz̈nac̈haj niiqui, jalla nekziqui lujlznaquic̈ha c̈hjulu onanami. ");
INSERT INTO capNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Niz̈aza nekz z̈ejlñi laanaca c̈hjetnaquic̈ha. Niz̈aza paljayaquic̈ha, tuz̈ cjican: “Yooz mantita zuma kamaña anc̈hucaquiz z̈catz̈inz̈quic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Niz̈aza tsjii wajtquiz irantiz̈cuqui, jalla nii wajtquiz anaz̈ anc̈huc kjawznaquiz̈ niiqui, calli kjutñiz̈ ulnaquic̈ha, nii wajt z̈oñinacz̈quiz tuz̈ cjican: “Tii wajt pulpu wejtnaca kjojchquiz zcatchipan cjen, jalla tii wajt pulpu tjappacha tsajt tsajtsnac̈ha. Jalla tii tsajtstaqui siñalaz̈ cjequic̈ha anc̈huca quintra. Pero anc̈hucqui tuz̈ zizla, Yooz mantita zuma kamaña anc̈hucaquiz z̈catz̈inz̈quichitac̈ha”. Jalla nuz̈ chiiz̈cuqui, nii ana anc̈huc kjawzñi wajtquiztan okaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Wejr cjiwc̈ha anc̈hucaquiz; casticz tjuñquiziqui nii wajtchiz z̈oñinacaqui juc'anti castictaz̈ cjequic̈ha, nii tuquita Sodoma cjita wajtchiz z̈oñinacz̈quiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Corazín wajtchiz z̈oñinaca, anc̈hucaquiz anawaliz̈ wataquic̈ha! ¡Niz̈aza Betsaida wajtchiz z̈oñinaca, anc̈hucaquiz anawaliz̈ wataquic̈ha! Anc̈huca watjanacquiziqui walja milajrunaca paatatac̈ha. Tiro Sidón cjita watjanacquiz nii milajrunaca paataz̈ cjitasaz̈ niiqui, walipan nii wajtchiz z̈oñinacaqui werar Yoozquiz cjuñzñiz̈ cjitasac̈ha, “Ujchizpantc̈ha; pertunalla”, cjicanaqui. Niz̈aza ninacz̈ uj sint'iz̈cu nii wajtchiz z̈oñinacaqui llaquita kuz kjanapacha tjeesñi cjitasac̈ha, lutu zquitchiz cujtz̈cu, niz̈aza achquiz kjupz̈tan tjajlz̈cu, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jalla niz̈tiquiztan anc̈hucqui casticu tjaaz tjuñquiziqui juc'anti castictaz̈ cjequic̈ha nii Tiro Sidón cjita watjanacchiz z̈oñinacz̈quiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Capernaum wajtchiz z̈oñinaca, ¿kjaz̈tiquiztan anc̈hucqui pinsejo, “Yoozqui uc̈hum honorchiz cjiskataquic̈ha”, cjicanjo? Anaz̈ nuz̈ cjesac̈ha. Pero anc̈huczti kozzuc tjojttaz̈ cjequic̈ha infiernuquin sufrisjapa, parti ujchiz z̈oñinacz̈tan chica. ");
INSERT INTO capNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Nekztan Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz tuz̈ cjichic̈ha: —Jakziltat anc̈huca taku nonz̈aj niiqui, niz̈aza wejt takumiz̈ nonz̈a. Niz̈aza jakziltat anc̈huca taku ana nonz pecc̈haj niiqui, niz̈aza wejt taku anaz̈ nonz pecc̈ha. Niz̈aza jakziltat wejt taku ana nonz pecc̈haj niiqui, niz̈aza werj cuchanz̈quiñi Yooz Ejp anaz̈ nonz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wiruñaqui nii pakallak cuchanta z̈oñinacaqui ancha cuntintu quejpz̈quichic̈ha, tuz̈ cjican: —Wejt Jiliri, am tjuu chiiz̈cu, am aztan zajranacami ulanskatchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Jesalla, tsjii rayuz̈takaz Satanás cjita diabluqui arajpachquiztan tjojtsic̈ha. Jalla nuz̈ cherchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wejrqui anc̈hucaquiz wejt azi tjaazinc̈ha. Jalla niz̈tiquiztan anc̈hucqui zkorami yek'achuncami tjecznaquiz̈ niiqui anaz̈ kjaz̈ cjisnasac̈ha. Niz̈aza nii wejt aztan tjapa quintranaca atipaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Zajranacaz̈ ulantiquiztan anc̈hucqui anaz̈ ancha chipchipasac̈ha. Antiz anc̈huca tjuunaca arajpachquin apuntitiquiztan, nekztanz̈ anc̈hucqui chipchipz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nii orapacha Jesusaqui ancha cuntintutac̈ha Yooz Espíritu Santuz̈ cjen. Nekztan cjichic̈ha: —Yooz Tata, arajpachquinami yokquizimi ampanc̈ha wali chawc jilirimqui. Am puntunaca humilde z̈oñinacz̈quiz tjeezamc̈ha, intintajo. Pero tii muntuquiz wali estudiantinacami zizñinacami am puntunaca anaz̈ intintazzic̈ha, c̈hjojz̈taz̈takaz ninacz̈quiziqui. Jalla nuz̈upanc̈ha am munañpaqui, Yooz Tata. Jalla niz̈tiquiztan am honora waytuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Niz̈aza Jesusaqui cjichic̈ha: —Yooz Tata, tjapa amiz̈ ziztanacami wejtquiz tjaajinchamc̈ha. Anaz̈ jecmi wejt kuz zizza. Yooz Tata, am panikaz wejt kuz zizza. Niz̈aza am kuz anaz̈ jecmi zizza. Wejr panikal zizuc̈ha. Niz̈aza Yooz Tata, jakziltiz̈quiz wejrqui am kuz zizkatz pecuc̈haja, jalla ninacazakaz am kuz zizaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tan zina z̈elatc̈ha. Ninacz̈quiz cherz̈cu cjichic̈ha: —Anchucqui zuma paatanaca cherchinc̈hucc̈ha. Jakziltat weriz̈ paatanaca persun c̈hjujcz̈tan cherchiz̈laja, cuntintuz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Wacchi tuquita Yooz taku paljayñinaca niz̈aza tuquita chawc jilirinaca, jalla ninacaqui weriz̈ zuma paatanaca cherz pecatc̈ha. Pero ana cherchic̈ha. Niz̈aza ninacaqui Yooz puntu takunaca nonz pecatc̈ha. Pero ana nonzic̈ha. Jaztankaz anc̈hucqui tii cherchinc̈hucc̈ha, niz̈aza nonzinc̈hucc̈ha. Jaziqui cuntintuz̈ cjee. ");
INSERT INTO capNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wiruñaqui tsjii judioz̈ lii tjaajiñi z̈oñiqui tsijtsic̈ha. Nekztanaqui Jesusiz̈quiz paljaychic̈ha, Jesusa lii quintra chiikatzjapa. Nekztan pewczic̈ha, tuz̈ cjican: —Wejt Tjaajiñi Maestro, Yooztan wiñaya kamzjapa ¿c̈hjulut paaz waquizisaya? ");
INSERT INTO capNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nekztanaqui Jesusaqui niiz̈quin kjaazic̈ha, tuz̈ cjican: —¿Kjaz̈ cjijrtat uc̈hum liiquiziya? ¿Jaknuz̈ liichamtajo? ");
INSERT INTO capNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nii lii tjaajiñiqui kjaazic̈ha, tuz̈ cjican: —Z̈oñinacz̈laqui Yoozquin tjapa kuzziz cjistanc̈ha. Yoozquin tjapa animuz̈tanami sirwistanc̈ha, niz̈aza tjapa aztanami, niz̈aza tjapa pinsamintuz̈tanami. Tjapa kuzziz Yoozquin cjistanc̈ha. Niz̈aza jaknuz̈t persunpachquiz okzñamz̈laja, jalla niz̈ta okzñi kuzziz cjistanc̈ha z̈oñinacz̈quizimi, lijitum maziz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Walikam kjaaza. Jalla nuz̈ amiz̈ kjaaztacama kamaquiz̈ niiqui, Yooztan wiñayam kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jesusiz̈ chiitiquiztan nii lii tjaajiñiqui atipz pecatc̈ha. Jalla nekztanaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Jec z̈oñinacz̈quiz wejrlaqui okstankaya? ");
INSERT INTO capNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ quint'ican: —Tsjii z̈oñiqui Jerusalén wajtquiztan okatc̈ha, Jericó cjita wajt kjutñi. Nuz̈ jiczquiz okan, tsjii kjaz̈ultan tjañinacz̈tan zalzic̈ha. Tjañinacaqui nii z̈oñi kijtchic̈ha, niz̈aza tjapa niiz̈ zquitinaca niiz̈ paaznaca kjañchic̈ha. Nekztanaqui zuma chjojricama ana z̈aañipacha ecchic̈ha. Nuz̈quiz ticzmaya z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nekztan tsjii icliz jiliriqui nii jicziñpacha okatc̈ha. Pero chjojrichta z̈oñi cherz̈cu, tsjii latu chjuuz̈cu watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Niiz̈ jarupachaqui tsjii timpluquiz sirwiñi z̈oñiqui nii jicziñpacha ojkchizakazza. Niz̈aza nii chjojrichta z̈oñi cherz̈cu, nawcjuñ zakaz chjuuzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Jalla nekztanaqui tsjii Samaria wajtchiz z̈oñiqui nii jicziñpacha tjonchizakazza. Jalla nuz̈ nii kijchta chjojrichta z̈oñi cherz̈cu, ancha okzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Jalla nekztanaqui kijchta z̈oñz̈quiz macjatchic̈ha. Chjojricama cherz̈cu kullzinchic̈ha aceitiz̈tan vinz̈tan. Nuz̈ kullz̈cu chjojri jerz̈inchic̈ha zumpacha. Nekztanaqui persun aznuquiz tewz̈cu chjitchic̈ha, tsjii alujamintuquin. Jalla nicju cwitichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jaka taz̈uqui ima wilta jicz ojkcan nii Samaria wajtchiz z̈oñiqui persun paaz jescu, pizc billete pacchic̈ha alujamintuchiz z̈oñz̈quiz. Nekztan cjichic̈ha, “Tii chjojrichta z̈oñi am cwitiz̈inalla. Tii paaz ana alcansaquiz̈ niiqui, wejrqui pjojkac̈ha, quejpz̈cuqui”. ");
INSERT INTO capNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jaziqui, ¿jakziltat nii c̈hjepultiquiztan chjojrichta z̈oñz̈quiz zuma okzikaya, lijitum maziz̈takazya? ¿Jaknuz̈um am tantii? Kjaaznalla. ");
INSERT INTO capNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jalla nekztanaqui nii lii tjaajiñiqui kjaazic̈ha, tuz̈ cjican: —Nii oksñi z̈oñipanc̈ha zuma maziz̈takazqui. Nekztanaqui Jesusaqui cjichic̈ha: —Jaziqui oka, nuz̈uzakaz ammi paalla. ");
INSERT INTO capNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jalla nekztanaqui Jesusaqui tira ojkchic̈ha. Ojkcan tsjii wajtquin luzzic̈ha. Jalla nicju Marta cjiti z̈onqui naaz̈a kjuyquiz Jesusa kjawzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martiqui cullacchiztac̈ha, María cjititac̈ha. Mariiqui Jesusiz̈ kjojch latuquiz julzinc̈ha, nii chiiñi nonzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martizti naaz̈a kjuy lurañquiz kuz tjaatc̈ha. Nekztan Jesusiz̈quiz macjatc̈hinc̈ha, tuz̈ cjican: —Wejt Jiliri, taa cullaquiqui wejr zinallakal tii kjuya lurañanacquiz jakjurpayc̈ha. Ana wejr yanapc̈ha. ¿Anam wejtquiztan sint'iya? Am chiiz̈inz̈inalla, wejr yanapajo. ");
INSERT INTO capNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Nekztanaqui Jesusaqui naaquiz kjaazic̈ha, tuz̈ cjican: —Marta, Marta, kjuy lurañanacz̈quiz kuz tjaachiz̈ cjen am kuzqui turwayzikalala. Jalla niz̈tiquiztan ancha llaquitamkalala amqui. ");
INSERT INTO capNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Tsjii zintallapanikaz z̈ejlc̈ha chekanaqui. Mariiqui nii zuma illzinc̈ha. Naaqui kuz tjaac̈ha wejt taku nonzjapa. Anaz̈ jecmi taa cullaqui wejt taku nonz̈tiquiztan apaki atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tsjii nooj tsjii yokquin Jesusaqui Yooz Ejpz̈quin mayizatc̈ha. Nuz̈ mayiziz z̈erz̈tanaqui niiz̈ tjaajintanacz̈quiztan tsjii tjaajinta z̈oñiqui pewczic̈ha tuz̈ cjican: —Jaziqui wejt Jiliri, Yooz Ejpz̈quin mayiziz tjaajznalla. Jaknuz̈t Juanqui niiz̈ tjaajinta z̈oñinacz̈quiz Yooz Ejpz̈quin mayiziz tjaajinchiz̈laja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nekztanaqui Jesusaqui tjaajinchic̈ha, tuz̈ cjican: —Yoozquin mayizizqui tuz̈uc̈ha: “Uc̈hum arajpach Yooz Ejp, am tjuuqui zuma honorchiz cjilalla. Niz̈aza am mantiz timpu irantiz̈quilalla. Niz̈aza am munañpaj cjilalla tii yokquizimi tsewc arajpachquinami. ");
INSERT INTO capNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Niz̈aza tonjtijapa niz̈aza zapurutijapa c̈hjeriz̈ tjaaz̈calla, azziz cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Wejrnacqui pertunchinc̈ha wejtnacaquiz ana zuma paañi z̈oñinaca. Jalla niz̈tiquiz amqui wejtnaca ujnacaz̈ pertunalla. Niz̈aza c̈hjul anawalinacami wejtnacaquiz ana watkatalla. Antiz c̈hjul anawalinacquiztanami liwriyalla”. ");
INSERT INTO capNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nekztan Jesusaqui ninacz̈quiz cjichizakazza: —Tsjii z̈oñiqui amiguchiztac̈ha. Nii amiguqui chica aramaz̈ kjuyquiz tjonchic̈ha, tuz̈ cjican: “Amigo, c̈hjep t'antaz̈ kajz̈nalla. ");
INSERT INTO capNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Wejt kjuyquiz tsjii z̈oñi irantiz̈quichic̈ha jiczquiztan. Anaz̈ wejttac c̈hjulumi z̈ejlc̈ha niiz̈quiz tjaazjapa”. ");
INSERT INTO capNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nekztanaqui nii z̈oñiqui kjaazic̈ha kjuyltan, tuz̈ cjican: “Anaz̈ wejr chiiz̈ina. Kjuyami zuma chawjcz̈tacha. Niz̈aza wejt ocjalanacaqui ajpzquiz wejttan chicaz̈ tjajc̈ha. Anaz̈ z̈aazñi atasac̈ha. Nekztan anal c̈hjulumi tjaayi atasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Amiguz̈ cjenami ana tjaayi z̈aaz pecchic̈ha. Pero niz̈tami tjaayi z̈aazic̈ha, ana iya molistita cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jaziqui cjiwc̈ha, Yooz Ejpz̈quiztan maya, nekztan Yooz Ejpqui z̈-tjaaquic̈ha. Niz̈aza zuma kamaña kjurzna, nekztan wac̈haquic̈ha. Niz̈aza kjuy chawjczquiztan t'oc t'ocz̈caquic̈ha, nekztan cjetz̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mayñi z̈oñinacami ninacz̈ mayta tjaataz̈ cjequic̈ha. Niz̈aza kjurñi z̈oñinacami nuz̈ kjurz̈cu wachaquic̈ha. Niz̈aza chawjczquiztan t'oc t'ocñi z̈oñinacz̈quizimi cjetz̈taz̈ cjequic̈ha. Jalla nuz̈uc̈ha Yooz Ejpz̈quin mayizizqui. ");
INSERT INTO capNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Kjaz̈t tsjii ejpqui anc̈hucporquiz t'anta mayñiz̈ majchquiz “Tiz̈ t'antaqui” cjican tsjii maz chjalznasajo? Anapanz̈ nuz̈ cjesac̈ha. Niz̈aza, ¿kjaz̈t ejpqui ch'iz mayñi majchquiz “Tiz̈ ch'izqui” cjican zkorakaz chjalznasajo? Anaz̈ nuz̈upan chjalznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Niz̈aza ¿kjaz̈t ejpqui wallpi ziñi mayñi majchquiz “Tiz̈ wallpi ziñiqui” cjican yek'achunca chjalznasajo? Anaz̈ nuz̈upan chjalznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jaziqui anc̈hucqui ana zum kuzziz cjenami zuma cusasapanikaz tjaasac̈ha persun maatinacz̈quiziqui. Ancha zuma kuzziz Yooz Ejpqui juc'ant zumanaca anc̈hucaquiz tjaasac̈ha. Jakziltat Espíritu Santo mayac̈haja, jalla niiz̈quiz arajpach Yooz Ejpqui Espíritu Santo cuchanz̈caquicha, nii mayñinacz̈ kuzquiz. ");
INSERT INTO capNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wiruñaqui zajraqui tsjii z̈oñi upa cjiskatchic̈ha. Nekztanaqui Jesusaz̈ nii zajra ulanzkattan, nii upa ana chiiñi z̈oñiqui chii kallantichic̈ha. Nekztan nuz̈ paatiquiztan nekz z̈ejlñi z̈oñinacaqui walja ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Yekjap z̈oñinacaqui Jesusiz̈ quintra chutchic̈ha, tuz̈ cjican: —Tiiqui anawal z̈oñikalala. Zajranacz̈ Beelzebú jilirz̈ aztan yekja zajranaca chjatkatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yekjap quintra z̈oñinacaqui yanz pecatc̈ha, arajpach Yooz aztan milajru paañi, ana arajpach Yooz aztan paañi, jalla nii. Yanzjapa pewczic̈ha: —Jaziqui arajpach milajru paala, —cjican. ");
INSERT INTO capNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesusaqui ninacz̈ kuz zizzic̈ha. Jalla niz̈tiquiztan paljaychic̈ha, tuz̈ cjican: —Tsjii nacionchiz z̈oñinacaqui t'aka t'aka cjisnaquiz̈ niiqui, ninacaz̈ kichassiz̈ cjen, nii nacionaqui tjatantaz̈ cjequic̈ha. Niz̈aza tsjii famillchiz z̈oñinacaqui chaasaquiz̈ niiqui, ninacaz̈ kichassiz̈ cjen nii famillaqui tjatantaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Niz̈aza Satanás cjita zajraz̈ partimi t'aka t'aka cjesaz̈ niiqui, ultimu tjatantaz̈ cjesac̈ha. ¿Kjaz̈t nii zajranacz̈ azi tjurasajo? Anaz̈ azziz cjesac̈ha. Anapanz̈ tjurasac̈ha. Jaziqui anc̈hucqui tuz̈ cjic̈ha, wejrqui zajranacz̈ Beelzebú cjita jilirz̈ aztan yekja zajranaca chjatkatc̈ha, jalla nuz̈ cjic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Pero wejrqui anaz̈ nuz̈u jalla. Nonz̈na. Anc̈huca partinacami zajranaca chjatkatñizakazza. ¿Jecz̈ aztan ninacac chjatkatjo? ¿Beelzebú cjita zajriz̈ aztan chjatkatjo? Anaz̈ cjesac̈ha. Anc̈huca parti z̈oñinacaz̈ paatiquiztan intintiz waquizic̈ha, zajriz̈ aztan anapan zajranaca chjatkatasac̈ha, jalla nuz̈ intintiz waquizic̈ha. Jalla niz̈tiquiztan anc̈hucqui kjanapachac̈ha ana zuma razunchizqui. ");
INSERT INTO capNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jaziqui ultim werara Yooz aztanpankal wejrqui zajranaca chjatkatuc̈ha. Yooz aztan chjatkattiquiztan, kjanapacha tjeez̈a, Yooz mantiz kamañ timpu irantiz̈quic̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‛Tsjiilla quint'asac̈ha. Tsjii walja armichiz z̈oñiqui persun kjuya walja tjurt'iñitac̈ha. Jalla niz̈tiquiztan kjuyquiz chjojtanaca segurotac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Nuz̈ armichiz̈ cjen cuntintu z̈elatc̈ha. Nekztanaqui tsjii tsjan tjup z̈oñiqui tjonchic̈ha. Armichiz z̈oñi atipz̈cu, tjapa niiz̈ armanaca kjañchic̈ha. Nekztan tjapa niiz̈ chjojta cusasanaca kjañchizakazza. Nekztan tjup z̈oñiqui niiz̈ mazinacz̈quiz kjañta cusasanaca tojunchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‛Nonz̈na. Jakziltat ana wejt favora cjec̈haj niiqui, wejt quintrac̈ha. Niz̈aza jakziltat Yooztajapa z̈oñinaca ana juntjapi yanapc̈haj niiqui, wejt quintra Yoozquiztan z̈oñinacaz̈ wichanskatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Niz̈aza Jesusaqui cjichic̈ha: —Tsjii zakal quint'asacha. Tsjii zajraqui z̈oñz̈quiztan ulanz̈cu kjoñ yokaran ojklaychic̈ha, jeejzjapa kjurcan. Ana jeejz watz̈cuqui, niiz̈ kuzquiz pinsichic̈ha, tuz̈ cjican: “Jaziqui wejr quepaka jakziquiztan ulanz̈quituc̈haja, jalla nicju”. ");
INSERT INTO capNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jalla nuz̈ quejpz̈cu niiz̈ ulanta z̈oñz̈quiz zalchic̈ha. Nii z̈oñz̈ kuzqui tsjii zuma pewz̈ta kjuyaz̈takaztakalc̈ha, niz̈aza zuma z̈cayi azquitz̈ta kjuyaz̈takaztakalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jalla nuz̈ zaltiquiztan nii zajraqui pakallak juc'ant anawali zajranaca zjijqui ojkchic̈ha. Ninaca zjijcz̈cu, tjapa nii zajranacaqui z̈oñz̈ kuzquiz luzzic̈ha. Jalla niz̈tiquiztan nii z̈oñiqui juc'ant anawaliz̈ cjissic̈ha tuquita kamzquiztan, tsjan ana zuma. ");
INSERT INTO capNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesusaz̈ nuz̈ quint'an, tsjaa maatak z̈onqui nii z̈ejlñi z̈oñinacz̈quiztan altu jorz̈tan paljaychic̈ha, tuz̈ cjican: —Honorchiz cjila am matiñ maaqui, am jwessinz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Nekztanaqui Jesusaqui cjichic̈ha: —Juc'ant honorchiz cjila Yooz taku nonzñinaca. Niz̈aza Yooz tawk jaru kamñinaca. ");
INSERT INTO capNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tsjan tsjan z̈oñinacaqui Jesusiz̈ muytataz̈ ajcznatc̈ha. Nekztanaqui Jesusaqui paljayi kallantic̈hic̈ha, tuz̈ cjican: —Jazta timpu z̈oñinacaqui ana zum kuzzizza. Milajru siñala paañipankaz pecc̈ha. Tuqui timpuqui Jonás cjita zoñiqui z̈elatc̈ha, Yooz taku paljayñi. Jalla niz̈ta paljayzqui tsjii siñalaz̈takazza, Yooziz̈ cuchanz̈quita cjican. Wejrzakal Yooz taku paljayuc̈ha. Anaz̈ iya c̈hjul siñalami z̈elasac̈ha tii z̈oñinacz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yooz Ejpqui Nínive cjita wajtchiz z̈oñinacz̈quiz Jonás cjita z̈oñi cuchanz̈quichic̈ha, casticu tjaaz tjuñi maznajo. Jalla niitac̈ha siñalaqui, nii timpuquiz kamñi z̈oñinacz̈taqui. Niz̈aza Yooz Ejpqui arajpachquiztan wejr cuchanz̈quichic̈ha. Jalla wejrtc̈ha siñalaqui, jazta timpuquiz kamñi z̈oñinacz̈taqui. Anaz̈ iya c̈hjul siñalami tjaataz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Pjalz tjuñquiziqui, jazta timpuquiz kamñi z̈oñinacaqui pjaltaz̈ cjequic̈ha, zuma, ana zuma, jalla nii. Ana zuma z̈oñinacaqui castictaz̈ cjequic̈ha. Nonz̈na. Tuqui timpuqui tsjaa maatak jilir z̈elatc̈ha, wartuñtan watja mantiñ. Pjalz tjuñquiziqui naaqui jakatatz̈cu jazta timpuquiz kamñi z̈oñinacz̈ uj kjana tjeeznaquic̈ha, jazta z̈oñinaca casticta cjeyajo. Naaqui muzpa az̈kquiztanpacha tjonchinc̈ha Salomón cjita jilirz̈quiz zali, niiz̈ zuma razun taku nonz̈ñi. Pero tekzi wejrqui z̈eluc̈ha Salomonz̈quiztan tsjan chekan jiliriqui. Pero jazta timpuquiz kamñi z̈oñinacaqui wejt taku anaz̈ nonz pecc̈ha. Niz̈tiquiztan juc'ant ujchizza, niz̈aza juc'ant castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Niz̈aza pjalz tjuñquiziqui Nínive wajtchiz z̈oñinacaqui jacatatz̈cu jazta timpuquiz kamñi z̈oñinacz̈ uj kjana tjeeznaquic̈ha. Jonás cjita z̈oñiz̈ Yooz taku paljaytiquiztan, nii Nínive wajtchiz z̈oñinacaqui Yoozquin kuzziz cjissic̈ha. Pero tekzi wejrqui z̈eluc̈ha Jonasquiztan tsjan chekan jiliriqui. Niz̈aza wejrtc̈ha tsjan chekan Yooz taku parliñtqui. Pero jazta timpuquiz kamñi z̈oñinacazti anal Yoozquin kuzziz cjissicha, weriz̈ paljayta Yooz taku nonz̈cu. Niz̈tiquiztan juc'ant ujchizza. Niz̈aza juc'ant castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Nekztanaqui Jesusaqui quint'ichic̈ha tuz̈ cjican: —Anaz̈ jecmi tsjii lámpara tjeezcu, chjojzakquiz nonznasac̈ha, niz̈aza anaz̈ tsjii cajon kjuylami nonznasac̈ha. Nii lamparaqui tseecupanz̈ tsjijpsnasac̈ha, kjuyquiz luzñi z̈oñinacz̈quiz kjanajo. ");
INSERT INTO capNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Z̈oñz̈ c̈hjujquiqui persun kuz lamparaz̈takazza. Z̈oñz̈ c̈hjujqui zumaz̈laj niiqui niz̈aza z̈oñz̈ kuzmi zumazakazza, zuma kjanquiztakaz kamc̈ha. Pero z̈oñz̈ chjujqui ana zumaz̈laj niiqui, kuzmi ana zumazakazza, zumchiquiztakaz kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Zuma kjanquizim kamc̈haj niiqui, persun kamaña zumaz̈ cwitazaquic̈ha, ana zumchi kamañchiz cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tsjii z̈oñiqui kjanquiztakaz zumapankaz kamc̈haj niiqui, niz̈aza ana c̈hjul ana waliquiz kamc̈haj niiqui, liwj niiz̈ kamtanaca zumaz̈ cjequic̈ha, jaknuz̈t tsjii lámpara wali kjanc̈haja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesusaz̈ chiyan, tsjii fariseo z̈oñiqui Jesusa c̈hjeri luli kjawzic̈ha, niiz̈ kjuyquin. Pucultanaqui kjuya irantiz̈cu, kjuya luzzic̈ha. Nekztan mizquiz julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jesusaqui kjara awjz custurumpi ana cumplichic̈ha ima lujlcan. Jalla nii cherz̈cu fariseo z̈oñiqui ispantichic̈ha. Jesusaqui persun kuzquiz naychic̈ha fariseo z̈oñiz̈ ispantita. ");
INSERT INTO capNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Nekztanaqui Jesusaqui niiz̈quiz paljaychic̈ha, tuz̈ cjican: —Tsjii z̈oñiqui tasanaca chuwanaca zawnctankaz awjza, niz̈aza chjujz̈a. Niz̈ta iratac̈ha anc̈hucqui fariseonaca. Anc̈hucqui zawnctankaz limpuc̈ha. Pero kjuyltanaqui anc̈huca kuzqui walja cjujchinacchizpanc̈ha. Anc̈huca kuzquiz tjangz zizza, niz̈aza c̈hjul anawali paazmi zizza. ");
INSERT INTO capNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Zumzu z̈oñinaca! Yoozqui curpumi kuzmi paachic̈ha. ¿Jalla anc̈hucqui anaz̈ nii zizjo? ");
INSERT INTO capNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Anc̈huca cusasanacquiztan z̈oñinacz̈quiz tjaaz waquizic̈ha. Anc̈hucqui tjapa z̈oñinacz̈tan okzñi kuzziz cjesaz̈ niiqui, anc̈huca kuzmi zumapanz̈ cjesac̈ha Yooz Ejpz̈ yujcquiziqui, ana kjara awjz cuzturumpi paaz̈cumi. ");
INSERT INTO capNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Ayii pori fariseonaca! Anc̈hucqui Yoozquin diezmos tjaayiñc̈hucc̈ha, niz̈aza tjapa plantanacquiztanami diezmos tjaayiñc̈hucc̈ha. Jalla nuz̈ paacan walikazza. Pero nuz̈ tjaacanami anc̈hucqui ana lijituma zuma kamañquiz kamchinc̈hucc̈ha, niz̈aza ana Yoozquin kuzzizc̈hucc̈ha. Zuma kamzqui, niz̈aza Yoozquin kuzzizqui, jalla niic̈ha chekanaqui. Pero diezmos tjaazmi zakaz cumpliz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Ayii pori fariseonaca! Ajcz kjuyquiziqui tucquin julzkaz pecc̈ha, niz̈aza honorchizkaj cjiw cjic̈ha anc̈hucqui. Niz̈aza anc̈hucqui jakzi calliranami zuma rispitchizkaz̈ wejr tsaanja cjic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Ayii pori fariseonaca! Niz̈aza ¡ayii pori lii tjaajiñinaca! Ana lijitum kuzzizc̈hucc̈ha. Anc̈huca liiqui cjic̈ha jakziltat tsjii sipultur juntuñ ojkchaja jalla niiqui Yoozquin ana macjatasac̈ha. Jalla niz̈ta irata anc̈hucqui z̈oñinacz̈quiz ana Yoozquin macjatskatc̈ha. Pero z̈oñinacaqui anc̈hucaz̈ puntu cjiñc̈ha, “Yooz z̈oñinacac̈ha ninacaqui”. Anc̈hucqui ninaca incallc̈ha, ana zuma kuzziz cjen. Anc̈hucqui ana pajta sipulturaz̈takazza. ");
INSERT INTO capNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jalla nuz̈ chiitiquiztan tsjii lii tjaajiñiqui kjaazic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, jalla nuz̈ chiiz̈cu, wejtnacaquiz ana zumam chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nekztanaqui Jesusaqui cjichic̈ha: —¡Ayii pori lii tjaajiñinaca! Anc̈hucqui parti z̈oñinacz̈quin niiz̈ jaru niiz̈ jaru ch'ama cuzturumpinaca yapchinc̈hucc̈ha: kuzi cuntaz̈takaz jepzinc̈hucc̈ha. Ch'ama cuzturumpinaca yapchiz̈ cjenami, anc̈hucqui anaz̈ tsjii loc'anz̈tanami yanapz pecc̈ha, z̈oñinaca nii cuzturumpinaca cumplajo. ");
INSERT INTO capNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‛¡Ayii! Anc̈hucqui ancha t'akjiric̈ha. Anc̈huca tuquita atchi ejpnacaqui Yooz taku paljayñi profetanaca conchic̈ha. Anc̈hucpacha nii paljayñinacz̈ sipulturanaca kjuyñicha, niwjctanaqui anc̈hucqui rispittaz̈okaz cjic̈ha. Pero anc̈hucqui anaz̈ ultimu rispitc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Tuquiqui anc̈huca ejpnacaqui nii Yooz taku paljayñinaca conchic̈ha. Nuz̈ conchi cjenami anc̈hucaquiztan walikazza. Anzimi anc̈hucqui sipulturanaca kjuyc̈ha, zuma z̈oñiz̈takazza. Pero ultimquiziqui anc̈hucqui ninacaz̈ paljayta Yooz taku anazakaz nonz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‛Jalla niz̈tiquiztan Yooz Ejpqui anc̈huca puntuquiztan zuma razun taku chiichic̈ha, tuz̈ cjican: “Wejrqui wejt taku paljayñi profetanacami apostolonacami cuchanz̈cac̈ha. Nekztanaqui yekjapanaca nii Yooz taku paljayñinacz̈quiztan contaz̈ cjequic̈ha. Yekjapazti kijchtaz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Tii muntu kalltiz, niwctanpacha Yooziz̈ cuchanz̈quita z̈oñinaca conchic̈ha anc̈huca tuquita atchi ejpnacaqui. Anc̈hucqui niz̈ta ana wal kuzzizzakazza. Jaziqui Yoozqui jazta timpuquiz z̈ejlñi z̈oñinacz̈quiz zakaz casticaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tsjii Zacarías cjita z̈oñiqui altarz̈tan timpluz̈tan, jalla nii taypiquiz contatac̈ha. Abel contiquiztanami Zacarías contiquiztanami niz̈aza tjappacha contanacquiztanami Yooz Ejpqui jazta timpuquiz z̈ejlñi z̈oñinacz̈quiz casticaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‛¡Ayii pori lii tjaajiñinaca! Liwriiñi Yooz taku liiz̈cu, zizcu, z̈oñinacz̈quiz ana nii tjaajinchinc̈hucc̈ha. Yooz taku tsjii llave irata tanzinc̈hucc̈ha. Nii llave tanz̈canpacha anc̈hucmi liwriiñi Yooz jiczquiz ana luzzinc̈hucc̈ha. Y niz̈aza nii llave tanz̈cu, ana cjetz̈inchinc̈hucc̈ha, liwriiñi Yooz jiczquiz z̈oñinaca luzajo. ");
INSERT INTO capNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","—Jalla nuz̈ chiiz̈inz̈cu Jesusaqui ojkchic̈ha. Nii lii tjaajiñinacz̈tan nii fariseonacz̈tan, jalla ninacaqui muzpa z̈awjchi cjissic̈ha Jesusiz̈ quintra. Niz̈aza ninacaqui Jesusiz̈quiz wiltan wiltan pewczic̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesusiz̈ quintra tsjii ujchiz jwezjapa. Jesusiz̈ kjaaztiquiztan uj tjojtunz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jesusaz̈ nuz̈ tjaajnan, zmali wacchi z̈oñinacaqui tjonchic̈ha, waranka waranka. Niz̈aza zmali porapat tewksascan tewksascan tjonchic̈ha. Primeraqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: —Fariseo z̈oñinacaqui anaz̈ ultimu Yoozquin kuzzizza. Anaz̈ lijitum Yooz z̈oñinacac̈ha, aunquimi lijitum z̈oñiz̈takaz cjicjiñi cjenami. Ninacz̈quiztan zumpachaz̈ cwit'azaquic̈ha, ana ninaca irata cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tsjii noojiqui tjapa chjojzakuñ paatami tjeez̈taz̈ cjequic̈ha. Niz̈aza tjapa chjojzakuñ pinsitami ziztaz̈ cjequic̈ha. Tsjii noojiqui z̈oñz̈ ultim kuz tjeez̈taz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Niz̈aza jamazit chiitanacami kjana ziztaz̈ cjequic̈ha. Chjojzakuñ chiitanacami tjapa z̈oñinacaqui zizaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","‛Jaziqui anc̈hucqui, wejt mazinaca, tuz̈ wejr chiiz̈inuc̈ha. Anac̈ha eksqui tii curpu alaja conñiz̈quiziqui. Curpu conz̈cu anaz̈ iya c̈hjulumi payi atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","¿Jecz̈quin antiz anc̈hucqui eks waquiziya? Yooz Ejpz̈quin eks waquizic̈ha. Yooz Ejpqui z̈oñz̈ curpu z̈eti tucuzinskatz̈cu z̈oñz̈ animumi infiernuquin tjojtzjapa azzizza. Jalla niiz̈quizza chekanaqui eksqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‛Tsjii pjijska wez̈laqui pizc paazkaz cwistic̈ha. Anac̈ha juc'ant valorchiz cjen, Yooz Ejpqui zapa wez̈lallami cjuñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Pero zapa z̈oñz̈quiz juc'anti cjuñc̈ha. Niz̈aza anc̈huca ach charami kanz̈intac̈ha, zintallquiztan zintalla. Anaz̈ anc̈hucqui tsuca. Nii wez̈lanacz̈quiztan anc̈hucc̈ha juc'ant valorchizqui. Yooz Ejpqui anc̈huc juc'ant cwitaquic̈ha wez̈lanacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‛Anc̈hucaquiz cjiwc̈ha: Jakziltat parti z̈oñz̈ yujcquiz wejt favora cjec̈haj niiqui, niz̈aza wejrqui Yooz anjilanacz̈ yujcquiz nii z̈oñz̈ favorazakal chiyac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jakziltat parti z̈oñz̈ yujcquiz wejr ana pajñi nicac̈haj niiqui, niz̈aza wejrqui Yooz anjilanacz̈ yujcquiz nii z̈oñz̈ quintra ana pajñi zakal cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‛Jakzilta z̈oñit Yooz Epiz̈ cuchanz̈quita Z̈oñz̈ quintra chiyac̈haj niiqui, pertuntaz̈ cjesac̈ha. Pero jakzilta z̈oñit Yooz Espíritu Santuz̈ quintra chiyac̈haj niiqui, anapanz̈ wira pertuntaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‛Wiruñaqui anc̈hucqui juezanacz̈ yujcquin niz̈aza jilirinacz̈ yujcquin chjichtaz̈ cjequic̈ha, ajcz kjuyquiz. Jalla nuz̈ chjichtiquiztan ana kuz turwaysi cjequic̈ha, jaknuz̈t chiyac̈haja, niz̈aza jaknuz̈t tjurt'azalaja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Anc̈huca chiiz ora Yooz Espíritu Santuqui anc̈huca kuzquiz chiizjapa tjaajznaquic̈ha, jaknuz̈t chiizalaj, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Tsjii z̈oñiqui Jesusiz̈quiz paljaychic̈ha, tuz̈ cjican: —Wejt Tjaajiñi Maestro, wejt jilz̈quiz chiinalla, wejt parti irinsa tjaa-ajo. ");
INSERT INTO capNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nekztanaqui Jesusaqui niiz̈quiz cjichic̈ha: —Jila, ¿kjaz̈tiquiztan amqui wejr jiliriz̈takaz cherz̈jo? Anapanz̈ wejr juez partirtqui, anc̈huca quija azquitzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Niz̈aza Jesusaqui ninacz̈quiz cjichic̈ha: —Persun kuzquiz naazna, niz̈aza cwitaza ana zmazñi kuzziz cjisjapa. Z̈oñz̈ wira kamañaqui anaz̈ niiz̈ wacchi cusasanacquiztan yatisinsa. ");
INSERT INTO capNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jalla nekztanaqui Jesusaqui tii quintu quint'ichic̈ha, tuz̈ cjican: —Tsjii ricach z̈oñi z̈elatc̈ha. Nii z̈oñz̈ yokquiziqui zkalanacaqui ancha cusa pookchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Jalla nuz̈ pooktiquiztan nii ricach z̈oñiqui kuzquiz pinsichic̈ha, tuz̈ cjican: “¿Kjaz̈t wejr cjequejo? Wejt yaaz kjuyanacaqui tii ajzta zkal c̈hjeri anaz̈ wacasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jalla nekztanaqui pinsichic̈ha, tuz̈ cjican: “Aaaa. Tuz̈ jazic cjeeka. Wejt zkala yaaz kjuyanaca pajlznaka. Nekztanaqui tsjan pajk kjuyanaca kjuysnaka. Jalla nekz tjappach zkal c̈hjeri yaaznaka, niz̈aza tjapa wejt cusasanaca”. ");
INSERT INTO capNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Jalla nekztanaqui nii ricach z̈oñiqui niiz̈ persun kuzquiz cjichic̈ha: “Aaaa. Wejrqui zmali cusasanaca yaazinc̈ha, niz̈aza zmali c̈hjerinaca yaazinc̈ha, az̈k wata tjurñipacha. Jeejznaka, niz̈aza cusa lujlsnaka, licsnaka. Niz̈aza cuntintul cjeeka”. ");
INSERT INTO capNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Yoozqui nii z̈oñz̈quiz cjichic̈ha, “Zumzu z̈oñimc̈ha amqui. Tiz̈wanpacha amqui ticznaquic̈ha. Am zkal c̈hjerimi am cusasanacami nii yaaztanacami inamayaz̈ cjequic̈ha, ¿c̈hjuljapat cjeequi neejo? ¿Jecz̈tapan cjeequi neejo?” ");
INSERT INTO capNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jaknuz̈t nii ricach z̈oñz̈quiz watchiz̈laja, jalla niz̈ta irataz̈ wataquic̈ha persunjapapankaz cusasa juntjapñi z̈oñinacz̈quiziqui. Niz̈ta z̈oñinacaqui Yooz yujcquiziqui poripanz̈ cjisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jalla nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz cjichic̈ha: —Anc̈hucaquiz tuz̈ cjiwc̈ha. Z̈oñiqui z̈ejtzjapaqui lujlz c̈hjeri pecc̈ha. Jalla nuz̈ cjenami, anc̈hucqui anac̈ha c̈hjerinacz̈quiz kuzqui llaquizizkatzqui. Niz̈aza z̈oñiqui curpu wali cjisjapa zquiti pecc̈ha. Jalla nuz̈ cjenami anc̈hucqui anac̈ha zquitinacz̈quiz kuzqui llaquizizkatzqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Z̈oñz̈ z̈etiqui c̈hjerquiztan juc'anti importic̈ha. Niz̈aza persun curpumi zquitquiztan ju'canti importic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Wez̈lanacz̈quiz cherzna. Anaz̈ zkalami c̈hjacc̈ha. Niz̈aza anaz̈ ajza. Niz̈aza ana c̈hjeri yaaz quetallchizza. Niz̈aza ana c̈hjeri yaaz kjuychizza. Jalla nuz̈ cjenami nii wez̈lanacz̈taqui lujlz c̈hjerinacami panz̈ z̈ejlc̈ha. Yooz Ejpkaz c̈hjeri tjaac̈ha. Pero anc̈hucqui Yooz yujcquiziqui wez̈lanacz̈quiztan juc'antiz̈ importic̈ha. Jaziqui anc̈hucaquiz zakaz Yoozqui lujlz c̈hjeri tjaaquic̈ha, z̈ejtzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Anaz̈ jec kolta z̈oñimi persunpacha tsjan lajcha paki atasac̈ha, llaquiziñi kuzziz cjenami ancha lajcha pecñi kuzziz cjenami. ");
INSERT INTO capNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Jalla niz̈ta ana atchucaz̈laj niiqui, ¿kjaz̈tiquiztan lujlz c̈hjerinacz̈quizimi zquitinacz̈quizimi anc̈huca kuzqui llaquizizkatjo? ");
INSERT INTO capNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‛Plantanacz̈ pjajkallaz̈ cherzna. Anaz̈ langza. Anaz̈ kawanc̈ha. Yoozqui nii pjajkallanacaz̈ pajkkatc̈ha. Zmali finu zquiti cujtz̈cumi anaz̈ jecmi pjajkallquiztanami juc'ant c'achalla cjesac̈ha. Niz̈aza finu zquiti cujtz̈cumi nii ancha ricachu Salomón jiliriqui anac̈ha pjajkallquiztan juc'ant c'achaqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Plantanacaqui tsjii upacamakaz c'achallac̈ha. Nekztanaqui jakataz̈u kattaz̈u tsjii jurnuquiz tjutjunzjapa ujz̈tac̈ha. Jalla nuz̈ cjenami Yooz Ejpkaz nii plantanacami niz̈ta cwitic̈ha. Anc̈hucc̈ha Yoozquin ana tjapa kuzziz z̈oñinaca. Anc̈huczti Yooz yujcquiziqui c̈hjul plantaquiztanami juc'antiz̈ importic̈ha. Jalla niz̈tiquiztan Yoozqui anc̈huc juc'anti cwitic̈ha; zquitchiz panz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jalla niz̈tiquiztan anc̈hucqui ana ancha llaquiziñi kuzziz ojklaya, c̈hjul c̈hjeri kjurzquiztanami. ");
INSERT INTO capNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tii muntuquiz ana Yoozquin criichi z̈oñinacaqui ancha llaquiziñi kuzziz ojklayc̈ha niz̈ta cusasanaca kjurcan. Anc̈hucqui anac̈ha niz̈ta llaquiziñi kuzziz ojklayzqui. Werar Yooz Ejpchizc̈hucc̈ha. Yooz Ejpqui zizza, c̈hjulut anc̈huc pecc̈haj, jalla nii. Anc̈hucqui c̈hjeri, zquiti, cusasanaca pecc̈ha, zejtzjapa, jalla nii zizza Yooz Ejpqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Niz̈tiquiztan anc̈hucqui Yooz Ejpz̈quinpankaz walja kuzziz cjee. Niz̈aza niiz̈ mantita zuma kamañquiz kuzziz cjee. Nekztanaqui Yooz Ejpqui anc̈hucaquiz c̈hjulumi cawalikaz tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","‛Niz̈aza Yooz Ejpqui anc̈huca uchaquic̈ha mantiñi puestuquiz. Jalla nuz̈uc̈ha Yooz munañpaqui. Tii muntuquiz z̈ejlcan anaz̈ eksna, anc̈hucqui wejt uuzanacc̈hucc̈ha, aunqui kolucullami. ");
INSERT INTO capNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Anc̈huca cusasa z̈ejlñinaca tuysna. Nekztan t'akjiri kamñi z̈oñinacz̈quiz tojna. Tii muntuquiz z̈ejlcan jaknuz̈t anc̈hucaqui zuma z̈ak quels tjaczaja, jalla niz̈ta irata zuma munaziñi kuz tjacz waquizic̈ha wiñaya zuma kamzjapa. Arajpachquin zuma cuntintu kamzjapa, anc̈huca kuz tjaczna, zuma azquicha. Tii muntuquiziqui tjañ z̈oñiqui anc̈huca cusasanaca kjañasac̈ha. Arajpachquin tjañ z̈oñinaca ana luzasac̈ha. Niz̈aza tekziqui tjujtami cjurimi anc̈huca zquitinaca lulasac̈ha. Arajpachquin tjujtami cjurimi ana z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jakziltat tii muntuquiz walja cusasanachizlaja, tii muntuquiz kamañ wirquiz kuz tjaac̈ha. Pero jakziltat arajpachquin kamañ wirquiz kuz tjaac̈haja jalla niiqui arajpachquin walja cusasanacchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Niz̈aza Jesusaqui tii quintu quint'ichic̈ha, tuz̈ cjican: —Arajpachquin ojkzjapa anc̈hucqui kuz zuma tjaczi tjewz̈na, tsjii tjeez̈ta lamaparaz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tiz̈taz̈takaz cjee. Tsjii patrunaqui zalsñi pjijstiquin ojkchic̈ha. Piyunanacaqui patrunz̈ cuttiz̈quiz tjewz̈a, niiz̈ irantiz̈quitan kjuy zan chawjcz cjetz̈inzjapa. Jalla niz̈ta irata anc̈hucqui Yooz tjonz tjuñi zuma tjewz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Weraral cjiwc̈ha. Patrunaz̈ tjonz oraqui jakzilta piyunanacat tjaji wajtsi tjewznac̈haja, jalla ninacaqui cuntintuz̈ cjee. Jalla nii piyunanacaqui patrunz̈ misquiz julskattaz̈ cjequic̈ha. Nekztanaqui nii patrunapachaz̈ c̈hjeri tjaaquic̈ha, niz̈aza ninacz̈quiz atintaquic̈ha. Jalla niz̈ta irata Yoozqui paaquic̈ha niiz̈ tjonz tjewzñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Chica aramami, kjantatimi, c̈hjulorakat nii patrunaqui irantiz̈quic̈hani. Nii oraqui jakzilta piyunanacat tjaji wajtsi tjewz tjewznac̈haja, cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tsjiilla zakaz cjiwc̈ha, anc̈hucaz̈ zizjapa. Tsjii kjuychiz z̈oñiqui c̈hjulorat tjañi tjonac̈haja, jalla nii ora zizaquiz̈ niiqui, tjaji wajtsipan tjewznaquic̈ha, nii tjañi ana luzkatzjapa, niz̈aza ana tjangskatzjapa. Tjañi tjonz ora zizcu, anapan niiz̈ kjuya nuz̈kaz ecasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Anc̈hucmi niz̈aza Yooz tjonz tjuñi walja listu tjacziz̈ tjewz̈na. Tiripintit tsjii ana pinsita oraqui wejrqui quejpz̈cac̈ha. Wejrtc̈ha tsewctan cuchanz̈quita Yooz Z̈oñtqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jalla nekztanaqui Pedruqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿tii quintu quint'ichamc̈ha wejtnacaltajapakazkaya? uz̈ ¿tjapa z̈oñinacz̈tajapa, jaa? ");
INSERT INTO capNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jesús Jiliriqui kjaazic̈ha, tuz̈ cjican: —Tsjii kjuy cwitiñi z̈oñi z̈elatc̈ha zuma cumpliñi, niz̈aza zuma intintiñi. Nii kjuychiz tuyñuqui zuma z̈oñz̈ kjarquiz niiz̈ kjuya ecchic̈ha, tjapa nii kjuyquiz z̈ejlñinacz̈tan. C̈hjeri tjaaz ora c̈hjeri tjaajo, jalla nuz̈ zakaz ecchic̈ha nii z̈oñz kjarquiz. ¿Ject nii zuma cumpliñi z̈oñejo? ");
INSERT INTO capNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jalla tiic̈ha nii z̈oñiqui. Kjuy tuyñu quejpsquizcama jakzilta z̈oñit niiz̈ kjuya zuma cwitican z̈ejlc̈haja, jalla niic̈ha zuma cumpliñi z̈oñiqui. Niz̈aza cuntintuz̈ cjequic̈ha nii zuma cwitiñi z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Wejrqui weraral cjiwc̈ha. Kjuya tuyñuqui cumpliñi z̈oñz̈ kjarquiz tjapa kjuy cusasanaca ecasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Tsjemata cwitiñi z̈oñi zakaz z̈elatc̈ha. Nii z̈oñiqui kuzquiz pinsichic̈ha, “Kjuychiz tuyñuqui anaz̈ uri tjonasaz̈, jaz”, cjican pinsichic̈ha. Jalla nekztanaqui nii kjuychiz luctaka cjiñi maataka cjiñi piyunanaca wjajtñitac̈ha. Niz̈aza nii z̈oñiqui persun lujlsquin licsquin kuz tjaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Tiripintit tsjii ana pinsita nooj kjuychiz tuyñuqui quejpz̈quichic̈ha. Tsjii ana zizta ora quejpz̈quichic̈ha. Jalla niz̈tiquiztan kjuychiz tuyñuqui nii ana zuma cwitiñi z̈oñz̈quiz juc'anti anawaliz̈ casticu tjaaquicha. Nii ana zuma z̈oñiqui jaknuz̈t ujchiz z̈oñinacaz̈ castictaz̈ cjec̈haja, jalla niz̈tapacha castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Tsjii piyunaqui zumpacha niiz̈ patrunaz̈ pecta langz zizzic̈ha. Niiz̈ patrunz̈ langz zizcanpacha, ana langzic̈ha. Jalla nuz̈ zizcanpacha, ana langztiquiztanaqui juc'anti castictaz̈ wjajtztaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Niz̈aza jakzilta piyunat ana niiz̈ patrunaz̈ pecta langz zizzaja, jalla niz̈ta cjenpacha ana cumplic̈haja, jalla niiqui upa casticta cjequic̈ha. Jakzilta z̈oñz̈quiz wacchi cusasanaca cwitajo tjaatc̈haja jalla nii z̈oñiqui tjapa nii cusasanacquiztan quint'istanc̈ha. Jakzilta z̈oñz̈quiz wacchi cusasanaca cwitajo cumpjiita cjec̈haja, jalla nii z̈oñiqui cusasanacchiz tuyñuz̈quiz quint'istanc̈ha tjapa cumpjiita cusasanacquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tsjiilla zakaz quint'ichic̈ha Jesusaqui, tuz̈ cjican: —Tekz werjqui tsjii uj peksñiz̈takaz tjonchinc̈ha. Nii uj peks oraqui wajiz̈ cjila. ");
INSERT INTO capNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Wejrqui tsjii wali pajk prueba watac̈ha bautismuz̈takaz. Niz̈aza nii watscama, ancha llaquital cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Weriz̈ tjontiquiztan z̈oñinacaqui anazumquin cjequic̈ha; t'aka t'akaz̈ cjequicha, wejtquiz criichinaca, ana wejtquiz criichinaca, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tii timpuquiztan nawjkchuc tsjii famillanacami t'aka t'akaz̈ cjequic̈ha. Tsjii famillquiz pjijskaltan cjec̈hani, c̈hjepultanac quintraz̈ cjequic̈ha pucultan z̈oñz̈japaqui. ");
INSERT INTO capNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Niz̈aza ejpz̈tan persun majchtan quintraz̈ cjequic̈ha. Niz̈aza majchz̈tan persun ejpz̈tan quintraz̈ cjequic̈ha. Niz̈aza maatan persun tjunmat matatan quintraz̈ cjequic̈ha. Niz̈aza naa tjunmat matatan persun maatan quintraz̈ cjequic̈ha. Niz̈aza kjan maatan wazatan quintraz̈ cjequic̈ha. Niz̈aza wazatan kjanatan quintraz̈ cjequic̈ha. Jalla nuz̈ cjisnaquic̈ha, wejtquiz criichinacz̈tan ana wejtquiz criichinacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jalla nekztanaqui Jesusaqui z̈oñinacz̈quiz cjichic̈ha: —Anc̈hucqui cjiñc̈hucc̈ha, wacchi tsjirinaca tajatan ulanz̈caquiz̈ niiqui, “chijnac̈hani”, nuz̈ cjiñc̈hucc̈ha. Nekztan jalla nuz̈ chijñiz̈ watc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Niz̈aza wartan quera querz̈caquiz̈ niiqui, “kjutñit cjec̈hani”, nuz̈ cjinc̈hucc̈ha. Nekztan jalla nuz̈ kjutñiz̈ watc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Hipócrita cheechi z̈oñi! Anc̈hucqui ¡ana lijitum kuzziz z̈oñinaca! Tjamz̈ puntu tsjirz̈ puntu walja zizñi chiiñc̈hucc̈ha. ¿Kjaz̈tiquiztan Yooz siñalanaca ana tantiyasajo? Kuz campiya, ima casticz ora irantan. ");
INSERT INTO capNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‛Niz̈aza ¿kjaz̈tiquiztan kamz puntu ana tantiyasajo, jaac̈ha zuma kamc̈haja, jaac̈ha ana zuma kamc̈haja, jalla nii? ");
INSERT INTO capNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jakziltat am quijz̈cu jilirz̈quin chjichac̈haja, jalla niiz̈quiztan pertunam mayizaquic̈ha ana enenz̈cu, ima jilirz̈quin irantican. Am quija ana pertunazta cjenaqui, nii jiliriqui policiiquiz am intirjasac̈ha. Nekztanaqui nii policiaqui am carsilquiz chawcwasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nekztanaqui wejrqui cjiwc̈ha, carsilquiztanaqui anapanim ulnasac̈ha, liwj tjappacha paczcama. Anziqui kuz campiya; Yoozquiztan pertuna maya, ana casticta cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nii orapacha tsjii kjaz̈ z̈oñinacaqui quintu zjijcchic̈ha, Jesusiz̈quiz mazñi. Tuz̈ cjican quint'ichic̈ha. Pilato cjita jiliriqui tsjii Galilea wajtchiz z̈oñinaca conkatchic̈ha. Nii conta z̈oñinacz̈ ljocqui animal ljocnacz̈tan t'ajzic̈ha. Tuquiqui animala contkalc̈ha, Yoozquin ofrenda tjaazjapa. ");
INSERT INTO capNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jalla nuz̈ nonz̈cu Jesusaqui cjichic̈ha: —¿Kjaz̈tiquiztan Galilea wajtchiz z̈oñinacz̈quiz nuz̈ anawali watchitajo? ¿Parti Galilea wajtchiz z̈oñinacz̈quiztan juc'ant ujchiz ninacajo? ¿Jalla niz̈tazaz̈ anc̈huc pinsiya? ");
INSERT INTO capNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Anc̈hucqui anac̈ha niz̈ta pinsa. Anc̈hucqui Yoozquin kuzzizpan cjee. Ana niz̈ta cjisnaquiz̈ niiqui, anc̈hucaquiz juc'ant anawaliz̈ watasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Jesusaqui quint'ichizakazza, tuz̈ cjican: —Tsjii tunca quinsakalcuni z̈oñinacaqui ticzic̈ha Siloé cjita wajt campanturi jalla ninacz̈ juntuñ pajlz̈tiquiztan. ¿Kjaz̈tiquiztan niz̈ta watchitajo? ¿Parti Jerusalén wajtchiz z̈oñinacz̈quiztan juc'ant ujchiz ninacajo? ¿Jalla niz̈tazaz̈ anc̈huc pinsiya? ");
INSERT INTO capNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Anc̈hucqui anac̈ha niz̈ta pinsa. Anc̈hucqui Yoozquin kuzzizpan cjee. Ana niz̈ta cjisnaquiz̈ niiqui, anc̈hucaquiz juc'ant anawaliz̈ watasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jalla nekztanaqui Jesusaqui tsjii quintu zakaz quint'ichic̈ha, tuz̈ cjican: —Tsjii z̈oñiqui niiz̈ yokquiz jiws muntinaca c̈hjacchic̈ha. Tsjii nooj ojkchic̈ha “jiwsa pookchiz̈caa” cjican, ojkchic̈ha. Irantiz̈cu, muntinacquiz ana c̈hjul jiws frutanaca watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jalla niz̈tiquiztan nii yoka cwitiñi z̈oñz̈quiz cjichic̈ha: “Chera, c̈hjep wata jiws frutanaca kjuri tjonchinc̈ha. Ana jiws frutanaca pookchikalc̈ha. Jaziqui tii muntinaca k'atzna. Inapanikaz z̈ejlc̈ha.” ");
INSERT INTO capNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jalla nekztanaqui nii yoka cwitiñi z̈oñiqui patrunz̈quiz cjichic̈ha: “Wejt patruna, tii watcamakaz z̈ela cjee. Wejrqui yokal zumpacha kjullznac̈ha, niz̈aza wanz̈tan wanit'ac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Jalla niz̈tiquiztanaqui jiws frutanaca pookz atc̈hani. Anapan pookaquiz̈ niiqui, nekztanaqui k'atz̈taz̈ cjequic̈ha”. —Jalla nuz̈ quint'ichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Tsjii jeejz tjuñquiziqui, Jesusaqui ajcz kjuyquiz tjaajnatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jalla nekz z̈elatc̈ha tsjaa laa maatak z̈on. Tunca quinsakalcun watanaca laatac̈ha. Tsjii zajraqui naa z̈on taj chutu paatkalc̈ha. Niz̈tiquiztanaqui anawira ts'iru tsijtsniñtac̈ha, ana c̈hjulu paazjapami. ");
INSERT INTO capNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesusaqui naa z̈on cherz̈cu, kjawzic̈ha, nekztan tuz̈ cjichic̈ha: —Cullacalla, am laaquiztan liwriita cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nekztanaqui Jesusaqui niiz̈ kjarz̈tan lanzic̈ha naa z̈onaquiz. Jalla nii orapacha naa z̈onqui ts'iru cjissinc̈ha. Niz̈tiquiztan Yooz Ejpz̈quin honora paljaychiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nii ajcz kjuy jilirizti Jesusiz̈japa z̈awjzic̈ha, nii jeejz tjuñquiz c̈hjetintiquiztan. Nekztanaqui nii jiliriqui zoñinacz̈quiz cjic̈hicha: —Sojta tjuñikaz langz waquizic̈ha. Jalla nii langz tjuñiran laanacaqui tjonsa c̈hjetintaz̈ cjisjapa. Anac̈ha jeejz tjuñquiziqui tjonzqui. ");
INSERT INTO capNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jalla nekztanaqui Jesús Jiliriqui nii jilirz̈quiz cjichic̈ha: —Ana zum kuzziz z̈oñinaca. Jeejz tjuñquiziqui tjapa anc̈hucanacaqui wacami aznumi cutzniñc̈hucc̈ha, kjaz liqui okajo, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Taa maatak z̈onqui Abrahamz̈ majch maatquiztan tjoniñc̈ha. Tunca quinsakalcun wata chututac̈ha, Satanás cjita zajraz̈ nuz̈ chutu paañiz̈ cjen. ¿Kjaz̈t tii jeejz tjuñquiziqui taa laa z̈onqui ana c̈hjetinta cjesajo? Jeejz tjuñquizmi c̈hjetinzpanikazza. ");
INSERT INTO capNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesusiz̈ nuz̈ chiitiquiztanaqui tjapa niiz̈ quintra z̈oñinacaqui azzi quirchic̈ha. Parti z̈oñinacazti cuntintutac̈ha, Jesusaz̈ nuz̈ pajk milajrunaca paachiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Tiz̈tac̈ha Yooz mantaparu ojkñi z̈oñinacz̈ puntuqui. Jalla nii puntuqui intintazkatasac̈ha, mostaz cjita semillz̈ puntu chiitiquiztan. Jalla tuz̈uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Tsjii mostaza cjita semilla z̈ejlc̈ha, ancha zkoltalla. Z̈oñiz̈ c̈hjactan, walja pakjiz̈ pajkc̈ha, tsjii pajk muntiz̈, nizta pakji. Niz̈aza nii mostaz muntiquiz wez̈lanacaqui tjuraz̈ paasac̈ha. Jalla nuz̈upan Yooz mantaparu ojkñi z̈oñinaca yapaquic̈ha, mostaz munti pajkñila, jalla niz̈ta irata. ");
INSERT INTO capNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Niz̈aza Jesusaqui cjichic̈ha: —Tii takunacz̈tanzakaz Yooz mantaparu ojkñi z̈oñinacz̈ puntu intintazkatasac̈ha. Jalla tuz̈uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Tsjaa maatak z̈onqui c̈hjep tupu jac'uz̈tan levaturz̈tan t'ajzinc̈ha. Nekztanaqui tjappacha nii t'anti masaqui t'amchic̈ha. Jalla niz̈ta iratac̈ha, tjapa kjutñi tii muntuquiz z̈oñinacaqui Yooz mantita kamañchiz cjisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wiruñaqui Jerusalén jiczquiz ojkcan, Jesusaqui tjaajinchic̈ha. Jakziran watatc̈haja, jalla nii watjaran jochiran tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nuz̈ tjaajnan, tsjii z̈oñiqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿koluckaz liwriita z̈oñinacajo? Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Anc̈hucqui tjapa kuz cjee, arajpach ojkñi zkoz jicz zanquiz luzjapa. Wejrqui anc̈hucaquiz cjiwc̈ha. Casticz tjuñquiziqui tjapa z̈oñinacaqui luz pecaquic̈ha. Nii oraqui anaz̈ ataquic̈ha. Jalla niz̈tiquiztan anziqui liwriiñi zanquiz luzjapa, tjapa kuz cjee. ");
INSERT INTO capNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tsjii noojiqui arajpach kjuychiz tuyñuqui tsijtsnaquic̈ha liwriiñi zana chawjczjapa. Anc̈hucqui, zawnctan cjiñinaca, nii chawjcz̈ta zanquiz t'ok t'okaquic̈ha, tuz̈ cjican: “Wejt jiliri, cjetznalla, cjetznalla”. Kjuychiz z̈oñiqui kjaaznaquic̈ha, tuz̈ cjican: “Anal anc̈huc pajuc̈ha. ¿Jecnactc̈huckazlaj anc̈hucqui?” ");
INSERT INTO capNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jalla nuz̈ chiitiquiztan anc̈huczti zakaz chiyac̈hani, tuz̈ cjican: “Amtan chica lujlchinc̈ha. Niz̈aza wejtnaca wajt calliran tjaajinchamc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero nii arajpach kjuychiz tuyñuqui kjaaznaquic̈ha, tuz̈ cjican: “Anc̈hucqui anapal pajuc̈ha, cjiwla. Wejtquiztan oka, tjapa anc̈hucqui ana zuma kuzzizc̈hucc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nekztan Jesusaqui cjichic̈ha: —Abrahamz̈tan, Isaacz̈tan, Jacobz̈tan, tjapa Yooz taku paljayñi profetanacz̈tan, tjappacha ninacaqui arajpach Yooz kjuyquiz z̈elaquic̈ha. Anc̈huczti zawnctanpanikaz z̈elaquic̈ha. Jalla nuz̈ zawnctan z̈ejlcan anc̈hucqui kaaquic̈ha, niz̈aza iz̈kez̈ jojaquic̈ha, ana luzzucaz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tjapa kjuttan criichi z̈oñinacaqui arajpach Yooz kjuyquin luzaquic̈ha, uz̈atan, wartan, tajatan, tuwantan, nuz̈ tjapa kjuttan. Niz̈aza nii luzzi z̈oñinacaqui arajpach Yooz kjuyquiz cusa atintitaz̈ cjequic̈ha. Yooz c̈hjeri luli julznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Niz̈aza Yoozqui arajpachquin yekjap tii muntuquiz wirquin cjiñi z̈oñinaca tucquin cjiskataquic̈ha. Niz̈aza yekjap tii muntuquiz tucquin cjiñi z̈oñinaca wirquin cjiskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesusiz̈ taku z̈erz̈tan, nii noojpacha, tsjii kjaz̈ fariseo z̈oñinacaqui tjonchic̈ha, tuz̈ cjican: —Tekztan am oka. Herodes cjita jiliriqui am conz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jalla nekztanac Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui nii mañus Herodesquin oka. Niiz̈quin chiiz̈ca, tuz̈ cjican: “Tsjii kjaz̈ tjuñi tirapal Yooz obranacal paa-uc̈ha, zajranaca chjatkatcan, laanaca c̈hjetincan. Nekztan tsjii kjaz̈ tjuñquiztan wejt obra z̈erznac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero wejrqui tsjii kjaz̈ tjuñi tiral kamac̈ha, Jerusalén wajtquin ticzcama. Jerusalén wajtquin Yooz taku paljayñi profetanacaqui ticstanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‛¡Jerusalén, Jerusalén wajtchiz z̈oñinaca! Anc̈hucqui Yooz taku paljayñinaca coniñc̈hucc̈ha. Niz̈aza Yooziz̈ cuchanz̈quita z̈oñinaca maztan c̈hjaquiñc̈hucc̈ha. Wallpiqui persun ozmachanaca kjarz̈ koztan juntiñil, jantey. Jalla niz̈ta irata wejrqui tii wajtchiz z̈oñinaca juntiz pecuc̈ha. Anc̈huczti ana wira wejtquin tjonz pequiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Jalla niz̈tiquiztan anc̈huca wajt yokaqui ana Yooz kjarquiz z̈ejlc̈ha. Niz̈aza wejrqui cjiwc̈ha. Tsjii noojiqui anc̈hucqui wejt puntuquiztan chiyaquic̈ha, “Honorchiz cjila, tii Yooziz̈ cuchanz̈quita z̈oñiqui”. Jalla nii oracama, anc̈hucqui wejr ana wilta cheraquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tsjii jeejz tjuñquiziqui Jesusaqui tsjii fariseo jilirz̈ kjuya luli ojkchic̈ha. Yekja fariseo z̈oñinacaqui Jesusa awayt'atc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Niz̈aza nii kjuyquiz z̈elatc̈ha tsjii curpu tjuuchi z̈oñi. Jesús z̈cati z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nii cherz̈cu Jesusaqui fariseo z̈oñinacz̈quiz lii tjaajiñinacz̈quiz, jalla ninacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Jeejz tjuñquiziqui tsjii laa z̈oñi c̈hjetnasay? uz̈ ¿ana c̈hjetnasaj? ");
INSERT INTO capNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ninacazti ch'ujukaz cjissic̈ha. Nekztanaqui Jesusaqui laa z̈oñi kjawz̈cu, c̈hjetinchic̈ha. Nekztan laa z̈oñz̈quiz cjichic̈ha: —Oka amqui —cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nekztanaqui Jesusaqui fariseo z̈oñinacz̈quiz tuz̈ cjichic̈ha: —Jeejz tjuñquiz cjenami aznumi wacami tujquiz tjojtsiz̈ cjen okz̈cu, ¿anaz̈ jooznasajo? ");
INSERT INTO capNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jalla nuz̈ chiitiquiztanaqui ana jaknuz̈ kjaazñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nekztanaqui Jesusaqui nii kjuyquin lujlcan jalla tiz̈ta cherchic̈ha. Kjawz̈ta z̈oñinacaqui tucquin julz kjuratc̈ha, niz̈aza honorchiz cjis pecatc̈ha. Jalla niz̈ta cjicjiñi cherz̈cu, Jesusaqui, tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Amqui tsjii zalzñi pjijztiquiz kjawz̈ta cjesaz̈ niiqui, anac̈ha tucquinpan julzqui. Am jarupacha tsjii juc'ant jilir z̈oñiqui tjonasaz̈ niiqui, am tucquin julzpantaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jecc̈halaj pucultan anc̈hucqui kjawzi, jalla nii kjawzñi z̈oñiqui amquiz chiyasac̈ha, “Am julz tii juc'ant jilirz̈quin tjaa”, cjican. Jalla niz̈tiquiztanaqui amlaqui azanpanti wirquin julz cjesac̈ha. Am aziz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ana niz̈ta paa. Antiz tuz̈ cjee. Tsjii zalzñi pjijztiquiz kjawztaz̈ cjesaz̈ niiqui, wirquinpankaz julzqui. Nekztan nii kjawzñi z̈oñiqui irantiz̈cuqui, amquin chiyasac̈ha, tuz̈ cjican: “Wejt k'ayi jila, ticchuc watz̈ca, tucquin julz̈ca”. Jalla nuz̈ kjawz̈cu tucquin tjulz̈tiquiztan parti z̈oñinacz̈ c̈hjujcquiziqui honorchizim cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jakzilta z̈oñit parti zoñinacz̈quiz persun honora chii chiyac̈haj niiqui, wiruñaqui nii z̈oñiqui ch'ujukaz cjesac̈ha. Pero humilde kuzziz z̈oñizti honorchiz cjiskattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Niz̈aza Jesusaqui nii kjawzñi z̈oñz̈quiz cjichic̈ha: —C̈hjeri tjaasim pecc̈haj niiqui, anam kjawznaquiz̈ am persun mazinacz̈quiz, niz̈aza am persun jilanacz̈quiz, niz̈aza am persun famill parintinacz̈quiz, niz̈aza am ricach visinunacz̈quiz, jalla ninacz̈quiz alaja anam kjawznaquic̈ha. Ninaca c̈hjeri luli kjawznasaz̈ niiqui, ninacaqui am zakaz kjawznasac̈ha. Niz̈tiquiztan amzakam c̈hjeri tanznaquic̈ha. Niz̈tiquiztan ana gastichim cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ana niz̈ta paa. Antiz tuz̈ cjee. C̈hjeri tjaasim pecc̈haj niiqui, kjawznaquic̈ha pori z̈oñinaca, zuch z̈oñinaca, coj z̈oñinaca, zur z̈oñinaca, jalla ninacz̈quiz kjawznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nuz̈ paaz̈cu cuntintum cjequic̈ha. Ninacaqui anaz̈ c̈hjulumi tjepñi atasac̈ha. Yooz zuma kamañchiz z̈oñinacz̈ jacatatz̈ tjuñiz̈ tjontan, jalla nekzim amqui tjepuntam cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jalla nuz̈ Jesusiz̈ chiita taku nonz̈cu, tsjii julzi z̈ejlñi z̈oñiqui Jesusiz̈quiz cjichic̈ha: —Arajpach Yooz Ejpz̈ kjuyquin lujlñinaca cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jalla nekztanaqui Jesusaqui nii z̈oñz̈quiz quint'ichic̈ha, tuz̈ cjican: —Tsjii nooj tsjii z̈oñiqui pajk pjijzta paachic̈ha. Tuquiqui walja z̈oñinaca kjawskatchic̈ha pjijztiquiz. ");
INSERT INTO capNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Pjijzta c̈hjeri lujlz ora piyunaqui kjawz̈ta z̈oñinacz̈quiz cuchanz̈quitac̈ha, tuz̈ cjeyajo: “Tjappacha listu tjacz̈tac̈ha, jaziqui z̈-tjona”. ");
INSERT INTO capNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nekztanaqui kjawz̈ta z̈oñinacaqui pasinza mayizichic̈ha. Tsjii z̈oñiqui cjichic̈ha: “Anzilla yoka kjaychinc̈ha. Jalla nii cherz̈quistanc̈ha. Jalla niz̈tiquiztan amqui wejr pasinzt'alla”. ");
INSERT INTO capNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Tsjiizti cjichic̈ha: “Anzilla tunca waca kjaychiñc̈ha. Jalla nii waca yanstanc̈ha. Jalla niz̈tiquiztan zumaz̈ pasinzt'alla”. ");
INSERT INTO capNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tsjiizti cjichic̈ha: “Anzilla tjunatan zalzinc̈ha. Niz̈tiquiztan anal oki atasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nii cuchanz̈quita piyunaqui quejpz̈cu patrunz̈quiz tjappacha quint'ichic̈ha, jaknuz̈ z̈oñinacat kjaaztc̈haja, jalla nii. Nuz̈ quint'itiquiztan nii patrunaqui walja z̈awjchi cjissic̈ha. Niz̈aza piyunz̈quiz cjichic̈ha: “Uri ojklayz̈ca calliran niz̈aza wajt tjiyaran. Pori z̈oñinaca zjijczna, niz̈aza zuch z̈oñinaca, cojonaca, zuranaca, jalla ninaca kjawz̈ca”. ");
INSERT INTO capNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Wiruñaqui nii piyunaqui mazzic̈ha tuz̈ cjican: “Wejt patruna, amiz̈ mantitacama ojklaychinc̈ha. Niz̈aza iya julz campo z̈ejlc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nekztanaqui patrunaqui cjichic̈ha piyunz̈quiz: “Wilta ojklayz̈ca callinacaran jicznacaran. Z̈oñinaca kjawkjawcan ojklayz̈ca kjuyquiz chjijpsnajo. Kjawz̈ta z̈oñinacz̈quiz tjonkatz̈ca”. ");
INSERT INTO capNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nekztan Jesusaqui cjichizakazza: —Wejrqui cjiwc̈ha. Weriz̈ primira kjawz̈ta z̈oñinacaqui anapan c̈hjeri lulasac̈ha wejt arajpach pjijztiquiziqui. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Walja z̈oñinacaqui Jesusa apzic̈ha. Nekztanaqui Jesusaqui tsijtscu z̈oñinacz̈ kjutñi quejpchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Jakzilta z̈oñit wejtquin kuzziz cjec̈haj niiqui, niiz̈ persun ejpmi, maami, tjunmi, maatinacami, persun jilanacami, persun cullaquinacami, niz̈aza niiz̈ persun kamañ wirami, jalla ninacz̈quiztanami wejtquin juc'anti kuzziz cjistanc̈ha. Anaz̈ wejtquin juc'anti kuzziz cjequiz̈ niiqui, anaz̈ wejt partir z̈oñi cjichuca cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jakzilta z̈oñit wejt partir z̈oñi cjis pecc̈haj niiqui, tjapa kuztanz̈ wejtquiz cjistanc̈ha niiz̈ persun wira apt'iz cjenami. ");
INSERT INTO capNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Tsjilla cjesac̈ha. Jequit tsjii campanturi kjuyz pecc̈haj niiqui, primiruqui gasto zumpacha tantiistanc̈ha, paaz wacata ana wacata, jaknuz̈ nii campanturi tsajczjapa, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ana zumpacha tantiiz̈cu kallantaquiz̈ niiqui, nekztan ana tsaqui atchucaz̈ cjesac̈ha. Jalla nuz̈ ana tsajcñi cherz̈cu parti z̈oñinacaqui nii z̈oñz̈quiz iñarasac̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","tuz̈ cjican: “Nii z̈oñiqui campantur kjuyi kallantichic̈ha. Nekztan ana tsaqui atchic̈ha. Ana zuma tantiichic̈ha”. Jalla nuz̈ tjasaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Niz̈aza jakzilta chawc jilirit quira zalz pecac̈haj niiqui, primiruqui zumpacha tantiistanc̈ha, niiz̈ tunca warank zultatunaca tsjiizuñz̈ paatunc warank quintra zultatunacz̈quiz atipata, ana atipata, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ana atipchucaz̈laj niiqui, quintra jilirz̈quin az̈quin cjen cumisiuna cuchansa, nuz̈quiz pasinza paajo, acuerdo luzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jalla niz̈ta, ima wejtquiz kuzziz cjen, zumpacha tantiiz waquizic̈ha. Jakzilta z̈oñit c̈hjultakquiztanami anaz̈ wejtquiz juc'anti kuzziz cjequiz̈ niiqui, anapanz̈ wejt parti z̈oñi cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","‛Yacuqui zumac̈ha. Yacuqui lak'ansnasaz̈ niiqui, ¿jaknuz̈t wilta zuma cjesajo? ");
INSERT INTO capNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Anapanz̈ cjesac̈ha. Anaz̈ yokjapa sirwasac̈ha, niz̈aza anaz̈ yok kulljapa sirwasac̈ha. Jalla nuz̈ ana sirwanami tjojtspanikazza. Jakziltaz̈laj cjuñchiz niiqui, zumpacha nonz̈na Yooz puntu intintisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Impuesto cobriñi z̈oñinaca niz̈aza ujchiz z̈oñinaca Jesusiz̈quiz macjatz̈quichic̈ha, niiz̈ taku nonzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jalla niz̈tiquiztanaqui fariseo z̈oñinacz̈tan lii tjaajiñinacz̈tan jalla ninacaqui Jesusiz̈ quintra chutchic̈ha, tuz̈ cjican: —Tii z̈oñiqui ujchiz z̈oñinacami risiwñipanikazza, niz̈aza ninacz̈tan chica c̈hjeri lujlñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jalla niz̈tiquiztan Jesusaqui ninacz̈quiz quint'ichic̈ha tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Tsjii z̈oñiqui patak uuzichiztac̈ha. Nekztanaqui tsjiilla katchic̈ha. Jalla nekztanaqui parti uuzinaca ilakz yokquin ecchic̈ha, katchi uuzi wajtzcama. ¿Jakziltat anc̈hucaquiztan ana niz̈ta paajo? ");
INSERT INTO capNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Niz̈aza katchi uuzi wajtz̈cuqui, azkar juntuñ tjojtz̈cu, awatiriqui tjonchic̈ha, ancha cuntintu. ");
INSERT INTO capNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Niz̈aza kjuya irantiz̈cuqui z̈catinta visinunacz̈quiz niz̈aza mazinacz̈quiz kjawzic̈ha, tuz̈ cjican: “Wejttan cuntintuz̈ cjee. Wejt katchi uuziqui wajtchinc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Niz̈aza wejrqui cjiwc̈ha, jalla niz̈ta iratac̈ha arajpachquinaqui. Tsjii ujchiz z̈oñiqui Yoozquin kuzziz cjesaz̈ niiqui, arajpachquin z̈ejlñinacaqui ancha cuntintuz̈ cjisnaquic̈ha. Llatunc tunc llatuncani ana Yoozquin kuzziz z̈oñinaca z̈elac̈hani: “Wejrnacqui zuma kamok”, cjicanaqui. Pero arajpachquinaqui ninacz̈quiztan juc'anti cuntintuz̈ cjequic̈ha nii zinta Yoozquin kuzziz z̈oñiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesusaqui quint'ichizakazza, tuz cjican: —Niz̈aza tsjaa tunca paazziz z̈on z̈elatc̈ha. Nekztanaqui tsjii paaz tjatanchinc̈ha. Paaz tjatanz̈cu, lámpara pekzinc̈ha. Niz̈aza kjuya pewchinc̈ha, zumpacha. Nuz̈ zuma pewcan, katchi paaz wajtchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nii paaz wajtz̈cu, mazinacz̈quiz niz̈aza z̈catinta visinunacz̈quiz kjawzinc̈ha, tuz̈ cjican: “Wejttan cuntintuz̈ cjee. Wejt katchi paaz wajtchinc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wejrqui cjiwc̈ha. Niz̈aza arajpachquinaqui Yooz anjilanacaqui cuntintuz̈ cjequic̈ha c̈hjulorami tsjii ujchiz z̈oñiqui Yoozquin kuzziz cjisnac̈haja, jalla nii oraqui. ");
INSERT INTO capNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Niz̈aza Jesucristuqui tii quintu zakaz quint'ichic̈ha, tuz̈ cjican: —Tsjii z̈oñi z̈elatc̈ha, pucultan lucmajch ocjalchiz. ");
INSERT INTO capNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nii upañaz̈ta majchqui ejpz̈quiz cjichic̈ha: “Tata, irinsaz̈ wejtquiz tjaall amqui”. Jalla nekztanaqui ejpqui irinsa t'akz̈inchic̈ha pucultan majchnacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tsjii kjaz̈ majquiztan upañaz̈ta majchqui irinsa tuychic̈ha. Nekztan tjappacha niiz̈ cusasanaca juntjapz̈cu, az̈kquin ojkchic̈ha yekja nacionquin. Nekztan nii nacionquin tjappacha niiz̈ cusasanaca gastichic̈ha, ana zuma kamcan. ");
INSERT INTO capNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Nuz̈quiz tjappacha cusasanaca mirz̈cuqui, upañaz̈ta majchqui ana c̈hjulchiz cjissic̈ha, z̈oñi maya. Niz̈aza nii nacionquiz c̈hjeri upsic̈ha. Upañaz̈ta majchqui c̈hjerz̈ kjara passic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nekztanac niiqui langz kjuri ojkchic̈ha. Tsjii z̈oñz̈quiz langz wajtchic̈ha. Nii patrunaqui jochi mantichic̈ha, cuchi ichajo. ");
INSERT INTO capNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ancha c̈hjeri eeczkatchic̈ha nii ejpz̈quiztan zarakchi majchqui. Ana c̈hjulu lulimi onantaz̈ niiqui. Jalla nekztanac cuch lulinacami chjajpinacami lujlznatakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jalla nekztanaqui kuzquiz pinsiskatchic̈ha, tuz̈ cjican: “Tjappacha wejt ejpz̈ piyunanacaqui cusa c̈hjerinaca lujlc̈hani. Niz̈aza z̈ejtchinacami z̈ejlc̈hani. Wejrzti tekzi t'akjiri z̈eluc̈ha; c̈hjerz̈ kjara pascu, ticz atuc̈hani. ");
INSERT INTO capNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Quepaz̈ wejrqui, tira wejt ejpz̈quin. Niz̈aza wejt ejpz̈quin cjeec̈ha: ‘Wejt Tata, Yooz quintra am quintra uj paachinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Wejrqui anam am maati cjichucac̈ha. Kjaz̈llami tsjii am piyunaz̈takaz uywalla’ ”. Jalla nuz̈ cjican pinsichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nekztanaqui ejpz̈quin zarakchic̈ha; ejpz̈ kjuy kjutñi ojkchic̈ha. Az̈kquin cjen ejpqui niiz̈ majch pajchic̈ha. Kuzquiz ancha okzic̈ha, ancha k'aaztichic̈ha. Nekztan majch zali zajtchic̈ha. Majch z̈cojrz̈cu, chjulzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Nekztanaqui majchqui ejpz̈quiz cjichic̈ha: “Tatay, wejrqui Yooz quintra, am quintra uj paachinc̈ha. Jaziqui wejr am maati anaz̈ cjichuca”. ");
INSERT INTO capNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jalla nekztanaqui ejpqui piyunanacz̈quiz cjichic̈ha: “Uri, jila walurchiz zquiti jwesanz̈ca. Nii zquitz̈tan wejt majch tjutz̈na. Niiz̈ loc'anquiz zurtija majcz̈ina. Niz̈aza zapato tjutz̈na. ");
INSERT INTO capNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Nekztanac anc̈hucqui walipunt cjew wacaz̈ zjijcz̈ca conzjapa. Pjijztaz̈ paaquic̈ha. Zuma c̈hjeriz̈ lulaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Wejt majch ticziz̈takaz katchitac̈ha. Jaziqui ticziquiztan jacatatchiz̈takaz tjonchic̈ha. Niz̈tami niiz̈tan zalchinc̈ha”. Jalla nekztanaqui pjijzta payi kallantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‛Jalla nuz̈ upañaz̈ta majch tjonz ora, niiz̈ jilaqui joch yokquintac̈ha. Kjuy z̈cati irantiz̈can, pjijzta nonzic̈ha, tsajtñi wayliz̈ jora. ");
INSERT INTO capNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Jalla niz̈tiquiztanaqui jilir majchqui tsjii tsjii piyuna kjawzic̈ha. Nuz̈ kjawz̈cu, “¿C̈hjulut wat?” cjican, pewczic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Piyunaqui kjaazic̈ha, tuz̈ cjican: “Am lajkqui tjonchila. Wiwusa anazak kjaz̈ cjissi tjonchic̈ha. Niz̈tiquiztan am ejpqui walipunt cjew wac conkatchic̈ha, pjijzta paazjapa”. ");
INSERT INTO capNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jalla nii quintu zizcu, jilir majchqui walja z̈awjchic̈ha. Pjijztiquiz ana luz pecatc̈ha. Nuz̈ cjen ejpzakazza nii roqui ulanz̈quichi luzcajo. ");
INSERT INTO capNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nekztanaqui jilir majchqui ejpz̈quiz cjichic̈ha: “Kjaz̈ watanaca wejrqui am sirwichinc̈ha. Niz̈aza am mantitacama okintac̈ha. Jalla nuz̈ cjenami ana wira tsjii cabrallami onanñamtac̈ha, wejt mazinacz̈tan pjijzta paazjapami. ");
INSERT INTO capNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Anziqui tii am ana cazñi majchqui tjonchic̈ha. Tiiqui ana zuma kamcan am paaz gastichila, ana zum maatakanacz̈tan zejlcan. Nuz̈ paata cjenami, niiz̈tajapa tsjii walipunt cjew waca conchamc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jalla nekztanaqui niiz̈ ejpqui kjaazic̈ha, tuz̈ cjican: “Wejt maati, amqui wejt chicaz̈ kamñampanla. Tjapaz̈ wejttac z̈ejl-la, niic amtacamac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tii am lajkqui ticziz̈takaztac̈ha. Jaziqui ticziquiztan jacatatchiz̈takaz tjonchic̈ha. Niz̈aza katchitac̈ha. Jaziqui waz̈tac̈ha. Jalla niz̈tiquiztan ancha cuntintuz̈ cjen pjijzta paaz waquizic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Niz̈aza Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz tsjii quintu zakaz quint'ichic̈ha, tuz̈ cjican: —Tsjii ricach z̈oñi z̈elatc̈ha. Niiz̈ kjuy cusasanaca cwitajo tsjii piyuna utchic̈ha. Wiruñaqui yekja z̈oñinacaqui nii patrunz̈quiz mazzic̈ha, tuz̈ cjican: “Tii am piyunaqui am cusasanaca ancha anawali gastiñic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Jalla nekztanaqui patrunaqui piyunz̈quiz kjawzic̈ha, tuz̈ cjican: “¿C̈hjul quintut am puntuquiztan nonojo? Jaziqui jaknuz̈um amqui wejt cusasa cwitiz̈inc̈haja, jalla nii wejtquiz quint'alla. Amiz̈ ana zuma cwitichiz̈ cjen anam iya wejt cusasa cwitasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nekztanaqui nii piyunaqui pinsichic̈ha, tuz̈ cjican: “¿Jaziqui kjaz̈t wejr cjisnaquejo? Wejt patrunaqui wejrz̈ jakjurpayla nii wejt langzquiztanaqui. Jaziqui ana ancha langziz̈ cjisnula wejrqui. Wejtta azi ana z̈ejlc̈ha, zkal yokquiz langzjapa. Niz̈aza z̈oñz̈quiztan tomangz eksnuc̈ha, azuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¿Jalla nuz̈ ana langzñi atchiz̈ cjen, c̈hjulut paa-as?” Nekztan piyunaqui cjichic̈ha: “Aaaa. C̈hjulut paa-as, nii zizuc̈ha wejrqui. Nekztan z̈oñinaca wejr atintiñiz̈ z̈elac̈han. Wejr kjawznac̈han ninacz̈ kjuyquizimi”. ");
INSERT INTO capNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jalla niiz̈ pinsita jaru piyunaqui zina zina patrunz̈ kajchi z̈oñinaca kjawzic̈ha. Tsjii primira kajchi z̈oñz̈quiz pewczic̈ha, tuz̈ cjican: “¿Kjaz̈um wejt patrunz̈quiz kajchamta?” ");
INSERT INTO capNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kajñi z̈oñiqui kjaazic̈ha, tuz̈ cjican: “Patac turril aceite kajchinc̈ha”. Jalla nekztanaqui piyunaqui cjichic̈ha: “Tiz̈ am factura. Uri julzna. Yekja factura paa. Pjijska tunca turril aceitekaz cjijrzna”. ");
INSERT INTO capNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Wiruñaqui tsjiizuñ kajchi z̈oñz̈quiz pewczic̈ha, tuz̈ cjican: “Am, ¿kjaz̈um kajchamta wejt patrunz̈quiz?” Kajñi z̈oñiqui kjaazic̈ha, tuz̈ cjican: “Patac quintal tiricu”. Nii piyunaqui cjichic̈ha: “Tiz̈ am factura. Niz̈aza yekja factura paa, quinsakal tunca quintal tiricukaz cjijrzna”. ");
INSERT INTO capNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jalla nii piyunaz̈ nuz̈ paan patrunaqui nii anawal piyuna c'uñchi pajchic̈ha, niiz̈ cusasanaca cwitiñi. Jalla niz̈taz̈takaz anawali kamñi z̈oñinacaqui tii muntuquiz cusasquin kuzziz kamc̈ha. Jalla nuz̈ kamcan ninacaqui c'uñchi tjojknakñic̈ha zuma kamñi z̈oñinacz̈quiztan juc'anti. ");
INSERT INTO capNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‛Wejrqui cjiwc̈ha. Tii ujchiz muntuquiz kamcanaqui z̈ejlñi cusasanaca gastis waquizic̈ha, zuma paacan tsjii zuma amigo tanzjapa. Jalla nekztan ticz̈cu anc̈hucqui kjawztaz̈ cjequic̈ha niiz̈ arajpach kjuyquin. ");
INSERT INTO capNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‛Jakzilta z̈oñit koluc cusasanaca zumpacha cwit'ac̈haj niiqui, niz̈aza wacchi cusasanaca zumpachazakaz cwit'aquic̈ha. Niz̈aza jakzilta z̈oñit koluc cusasanaca ana zuma cwit'ac̈haj niiqui, niz̈aza wacchi cusasanaca ana zuma cwit'ichiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Niz̈aza jakzilta z̈oñit tii ujchiz muntuquiz z̈ejlñi cusasanaca ana zumpacha cwit'asac̈haj niiqui, jalla niz̈ta ana zuma kamchiz̈ cjen, Yoozqui werar arajpach cusasanaca nii cwitiñijapa ana tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jakzilta z̈oñit Yooziz̈ tjaata cusasanaca ana zuma cwit'ac̈haj niiqui jalla niz̈ta ana zuma kamchiz̈ cjen, Yoozqui arajpach cusasanaca tjaaz cjen pacha ana tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‛Anaz̈ jakzilta piyunami pizc patruna sirwi atasac̈ha. Piyunaqui tsjii patrunz̈quizkaz kuz tjaasac̈ha. Tsjiizuñ patrunaz̈ jaytaquic̈ha. Niz̈aza nii piyunaqui tsjii patrunz̈quizkaz zumpacha sirwaquic̈ha. Nii tsjii patrunz̈quiz anapan zuma sirwi atasac̈ha. Yoozmi paazmi z̈ejlc̈ha pucultan patrunaz̈takaz. Pero z̈oñinacaqui pucultiz̈quiz kuz ana tjaasac̈ha. Tsjii patrunz̈quizpankaz zuma sirwasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ancha paaz pecñi fariseo z̈oñinacaqui tjapa Jesusiz̈ chiita taku nonzic̈ha. Jalla nuz̈ nonz̈cu Jesusa iñarchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesusaqui niz̈tiquiztan cjichizakazza: —Anc̈hucqui cusa z̈oñiz̈takaz ojklayiñchucc̈ha z̈oñz̈ yujcquiziqui. Yoozzti anc̈huca kuz zizza. Tii muntuquiz z̈ejlñi z̈oñinacaqui ana zuma kuzziz z̈oninacz̈ honorakaz waytic̈ha. Yooz Ejpzti nii ana zuma kuzziz z̈oñinaca chjaawjñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Niz̈aza Jesusaqui cjichic̈ha: —Juan Bautistaz̈ tjonzcama, Moisés mantita lii azziztac̈ha. Niz̈aza Yooz taku paljayñi profetz̈ tjaajintanacami azziztac̈ha, Juan Bautistaz̈ tjonzcama. Nii timpuqui jalla nii mantita takunaca azziztac̈ha. Pero Juan Bautistaz̈ tjontiquiztan, liwriiñi Yooz taku niz̈aza Yooz mantita kamañ puntu paljayzqui, jalla niic̈ha tsjan chekanaqui. Jaziqui walja z̈oñinacaqui Yooz mantita kamañquiz luzjapa tjapa kuz tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","‛Jalla nuz̈ cjenami tjuñimi warawarami yokami katasac̈ha. Pero tjapa nii arajpach Yooz liizti anaz̈ wira katasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Niz̈aza Jesusaqui cjichic̈ha: —Jakzilta z̈oñit niiz̈ maataka jakjurpayz̈cu yekja maatakz̈tan zalsnac̈haj niiqui, jalla nuz̈ cjenaqui adulterio uj paac̈ha. Niz̈aza jakzilta z̈oñit jakjurpayta maatakz̈tan zalsnac̈haj niiqui, adulterio uj zakaz paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Niz̈aza Jesusaqui tsjii quintu zakaz quint'ichic̈ha, tuz̈ cjican: —Tsjii wali jiru ricach z̈oñiqui z̈elatc̈ha. Zuma finu zquiti cujtzñitac̈ha. Niz̈aza zapuru pjijztakaz ancha cusa c̈hjeri lujlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nii oraqui tsjii pori z̈oñi z̈elatc̈ha Lázaro cjita. Niiz̈ janchiqui walja zkira cjijtchitac̈ha. Zapuru ricach z̈oñz̈ kjuy zanquiz julzi z̈ejlñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nii ricachuqui z̈ejtchi c̈hjerinaca tjojtñitacha. Nii pori z̈oñizti tjojtta z̈ejtchi c̈hjerinaca lujlz pecñitac̈ha. Pacunacaqui pori z̈oñz̈quiz macjatz̈cu niiz̈ zkiranaca issañitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tsjii noojiqui nii pori z̈oñiqui ticzic̈ha. Nekztanaqui Yooz anjilanacaqui nii chjitchic̈ha Yooz illzta zuma yokquin, Abraham cjita z̈oñz̈tan chica z̈elajo. Wiruñaqui nii ricachu z̈oñiqui ticzizakazza. Nekztanaqui yokquiz tjatz̈tatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nii ricachu z̈oñiqui infiernuquin sufrican z̈elatc̈ha. Nicju sufrican, tsewc kjutñi cherchic̈ha. Az̈quiztan cherchic̈ha Abrahamz̈tan Lazaruz̈tan. ");
INSERT INTO capNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jalla nuz̈ cherz̈cu, kjawchic̈ha, tuz̈ cjican: “Abraham tatay, wejr okznalla. Lázaru cuchanz̈ca, niiz̈ loc'ana kjaztan t'awz̈cu, wejt lasquiz lanznajo, ch'uñkatajo. Tii asñi ujquiz anchal sufruc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamzti cjichic̈ha: “Jila, cjuñznalla, muntuquiz kamcan, ancha cusa kamchamc̈ha. Lazaruzti t'akjiri kamchic̈ha. Jaziqui anziqui Lazaruqui kuztac̈ha, ancha cuntintuc̈ha. Amzti ancha sufric̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Niz̈azakaz Yoozqui pajk pal k'awa utchipanc̈ha wejtnacquiztanami amquiztanami. Jaziqui tekztan nawjkchuc ojkz pecñinacaqui anaz̈ okasac̈ha. Niz̈aza nawjktan tjonz pecñinacaqui anaz̈ tjonasac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","28","Jalla nekztanaqui nii ricuqui cjichic̈ha: “Abraham tatay, wejtta pjijskaltan jilanaca z̈ejlc̈ha. Jaziqui am rocuc̈ha, wejt ejpz̈ kjuyquin Lázaro cuchanz̈inz̈calla, ninacz̈quiz paljayajo, niz̈aza tii infiernuquiz ana tjonajo”. ");
INSERT INTO capNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abrahamqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: “Ninacz̈ta z̈ejl-la Moisés cjijrtami niz̈aza Yooz taku paljayñi profetanacz̈ cjijrtami. Nii cjijrtanacquiz cazla, kuz tjaala”. ");
INSERT INTO capNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jalla nekztanaqui nii ricuqui kjaazic̈ha tuz̈ cjican: “Razunam chiic̈ha, Abraham tatay. Pero tsjii z̈oñiqui ticziquiztan ninacz̈quin okac̈haj niiqui, Yoozquin kuzziz cjiskatac̈hani”. ");
INSERT INTO capNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nekztanaqui Abrahamqui cjichic̈ha: “Ninacaqui Moisés mantita taku niz̈aza Yooz taku paljayñinacz̈ taku ana criyac̈haj niiqui, tsjii ticziquiztan jacatatchi z̈oñz̈ takumi ana zakat criyac̈hani”. —Nuz̈ quint'ichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nekztanaqui Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz cjichic̈ha: —Ujquiz tjojtskatñi z̈oñinaca z̈ejlñipantac̈ha. Pero Yoozqui nii ujquiz tjojtskatñi z̈oñinacaqui anawaliz̈ watkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jakzilta z̈oñit Yoozquin kuzziz z̈oñi ujquiz tjojtskatac̈haj niiqui, niz̈ta ana zum z̈oñinacaqui koz kot kjazquin tjojttaz̈ waquizic̈ha, tsjii pajk taj maztan jorquiz mokz̈inta. Jalla nuz̈ tsjan cusaz̈ cjesac̈ha nii ujquiz tjojtskatñi z̈oñz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","‛Niz̈ta z̈oñinacz̈quiztan anc̈hucqui walja cwitassa, ana ujquiz tjojtsjapa. Tsjii am jilanacz̈quiztan am quintra uj paac̈haj niiqui, jalla niiz̈quiz z̈umpacha chiiz̈ina, niiz̈ kuz campiita cjeyajo. Nekztan niiz̈ kuz campiita cjec̈haja, jalla nii uj paañi z̈oñz̈quiz pertunaquic̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Zapa wiltami nii am quintra uj paañi z̈oñiqui pertuna mayizic̈haj niiqui, amqui pertunaquic̈ha, tsjii nooj pakallawk wilta am quintra uj paanami. ");
INSERT INTO capNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Wiruñaqui Jesusiz̈ illzta z̈oñinacaqui Jesusa jilirz̈quiz paljaychic̈ha tuz̈ cjican: —Juc'anti Yoozquin kuzziz cjisjapa yanapalla. ");
INSERT INTO capNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Nuz̈ maytiquiztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tsjii mostaz semillaqui aunqui koltallami wali pakji pakñic̈ha. Jalla niz̈ta iratac̈ha anc̈hucqui. Yoozquin walja kuzzizc̈hucc̈halaj niiqui, milajrunacami zakaz paasac̈ha. Walja Yoozquin kuzziz z̈elanaqui, tii sicómoro cjita muntiquiz cjesac̈ha, tuz̈ cjican, “Tekztan pajlta cjee, niz̈aza kotquin tjojtta cjee”. Jalla nuz̈ chiitiquiztan niz̈tapachaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jesusaqui cjichizakazza: —Tsjilla chiyasac̈ha. Anc̈hucaquiztan piyunchiz z̈oñi z̈elasac̈ha. Piyunaqui joch yokquiztan tjonasac̈ha, uywanaca itzcu, niz̈aza zkala yoka kjullz̈cu. Jalla nuz̈ langzquiztan tjontanaqui, anapanz̈ anc̈hucqui cjesac̈ha, “Watz̈ca, julzna, tiic̈ha lujlzna” cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Anc̈hucqui antiz piyunz̈quiz cjesac̈ha, “C̈hjeriz̈ apura kisna. Niz̈aza wejr atintisjapa, zumpacha tjaczna. Wejrqui lulac̈ha, licac̈ha. Nekztanz̈ amqui lulaquic̈ha, niz̈aza licaquic̈ha”. Jalla nuz̈ tsjii piyunz̈quiz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Jakzilta piyunat niiz̈ patrunz̈ mantitanaca paac̈haj niiqui, patrunaqui sparaquiz̈ cjesajo? ");
INSERT INTO capNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Anc̈hucqui Yooz piyunaz̈takazza. Jalla niz̈tiquiztan tjapa Yooz mantitacama kamcan, anc̈hucalaqui chiiz waquizic̈ha, tuz̈ cjican, “Wejrnacqui am piyunitc̈ha. Inakaztc̈ha wejrnacqui. Jaknuz̈t paaz waquizic̈haja, jalla niikaz paayinc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jalla nekztanaqui Jesusaqui Jerusalén watja ojkcan, Samaria cjita yoka Galilea cjita yoka nii taypiquin watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nekztanaqui tsjii watjallquiz, waj irantawc cjen, tuncaltan mojkchi janchichiz z̈oñinacaqui Jesusiz̈quin zali tjonchic̈ha. Az̈kquiztan Jesusiz̈quiz chiiz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Altu tawkz̈tan tuz̈ cjichic̈ha: —¡Jesusa, Jiliri, wejtnacaquiz okznalla! ");
INSERT INTO capNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jalla nii laanaca cherz̈cu, Jesusaqui cjichic̈ha: —Icliz jilirz̈quin persun janchi tjeezñi oka. Jalla nuz̈ ojkcan, laanacaqui z̈ejtchi quirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Tsjii tsjiiqui persun janchi z̈ejtchi cherz̈cu cuttichic̈ha, Jesusiz̈ kjutñi, altu jorz̈tan Yooz honora waytican quejpc̈hic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jalla nuz̈ Jesusiz̈quin wilta zalz̈cu, niiz̈ yujcquiz quillzic̈ha, niz̈aza tuzi t'okzic̈ha yoka iranta. Jesusiz̈quiz ancha sparaquiz̈ cjichic̈ha. Nii z̈oñiqui Samaria wajtchiz z̈oñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nekztanaqui Jesusaqui cjichic̈ha: —¿Anc̈hucqui anataj tuncaltanpacha z̈ejtchinc̈hucjo, tii laaquiztanajo? ¿Jakziquint tsjii partinacajo? ");
INSERT INTO capNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Amqui anaz̈ tii wajtchiz z̈oñila. Am zinakaz quejpz̈quila Yoozquin honora wayticanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nekztan Jesusaqui nii z̈oñz̈quiz cjichic̈ha: —Tsijtsna, oka. Amiz̈ tjapa kuz criitiquiztan, jaziqui c̈hjetintamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nekztanaqui fariseo z̈oñinacaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿C̈hjulorat Yooz Epiz̈ mantiz tjuñi irantiz̈caquiya? Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Yooz Epiz̈ mantiz tjuñiqui anac̈ha cherchuca. ");
INSERT INTO capNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Anac̈ha “tekzipan” cjican nii tjuñi tjeeznasac̈ha. Niz̈aza anac̈ha “nii nawjk” cjican nii tjuñi tjeeznasac̈ha. Yooz mantizqui z̈oñinacz̈ kuzquizpachac̈ha. Jalla niz̈tiquiztanac Yooz mantizqui anaz̈ cherchuca cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jalla nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈quiz cjichic̈ha: —Tsjii sufris timpuqui irantiz̈caquic̈ha anc̈hucaquiz. Jalla nekztanac anc̈hucqui wejr arajpachquiztan quejpsquiñi cherz pecaquic̈ha, tsjii noojillami. Pero weriz̈ arajpachquin z̈elan, anaz̈ wejr cheri atasac̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Niz̈aza nii sufris timpuquiziqui z̈oñiqui Cristuz̈ puntuquiztan parlaquic̈ha, tuz cjican: “Arajpachquiztan chjijwz̈quichic̈ha. Tekzi z̈ejlc̈ha”. Tsjiizti zakaz chiyaquic̈ha, “Nii nacjuc̈ha Cristuqui” cjican. Pero anc̈hucqui anaz̈ nicju okaquic̈ha, niz̈aza nii chiita taku anaz̈ criyaquicha. ");
INSERT INTO capNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tsjii liwjliwjñi rayu cjita tjonñila, jantey, jalla nuz liwjtayz̈caquic̈ha, liwjpacha irantaz̈ kjanz̈naquic̈ha. Jalla niz̈ta irata wejrqui arajpachquiztan wilta tjonac̈ha. Weriz̈ tjonan, tjappacha zizasac̈ha. Jalla niz̈taz̈ wejt tjonz tjuñiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Anziqui primiraqui wejrqui walja sufristanc̈ha. Niz̈aza tii timpuquiz kamñi z̈oñinacz̈quiztan anapan criital cjeec̈ha. Ana werj cherz pecaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jaknuz̈t Noez̈ kamta timpuquiz watc̈haja, jalla niz̈tazakaz wataquic̈ha ima weriz̈ tjonan. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noez̈ timpuquiz jalla tuz̈ kamñitac̈ha z̈oñinacaqui. Zuma c̈hjeri lujlñitac̈ha, niz̈aza licñitac̈ha. Niz̈aza zalzñitac̈ha, niz̈aza zalzjapa tjaañitac̈ha. Jalla nuz̈ z̈oñinacaqui kamchic̈ha asta Noez̈ pajk warcu kjuyquiz luzcama. Yooz kamañquiz kamzqui ana importayñitac̈ha. Jalla nekztanaqui kjaz juyzuqui tjonchicha. Jalla nii juyzuquiziqui tjappacha anawali kamñi z̈oñinacaqui ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Niz̈aza jaknuz̈t Lot cjita z̈oñz̈ timpuquiziqui watc̈haja, jalla niz̈tazakaz wataquic̈ha ima weriz̈ tjonan. Lujlñitac̈ha, licñitac̈ha, kjayñitac̈ha, tuyñitac̈ha, c̈hjacñitac̈ha, y niz̈aza kjuya kjuyñitac̈ha. Yooz kamañquiz kamzqui ana importayñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jalla Lotz̈ Sodoma cjita wajtquiztan ulantan, tiripintit uj azupri chijñi tjonchic̈ha. Nuz̈ chijintiquiztan tjappacha ujz̈cu ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Wejt tjonz tjuñquiziqui niz̈ta iratazakaz wataquic̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‛Nii wejt tjonz tjuñquiziqui jakziltat kjuy zawncu z̈elac̈haja, anaz̈ kjuy cusasanaca aptiñi luz waquizic̈ha. Niz̈aza jakziltat joch yokquin z̈elac̈haja, anaz̈ wajt kjuya cuttis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotz̈ tjuna puntuquiztan cjuñzna. ");
INSERT INTO capNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jakziltat persun kamañquiztan ana jaytac̈haja, jalla niiqui anaz̈ arajpachquin kamaquic̈ha. Niz̈aza jakziltat persun kamañ wira jaytic̈haja, jalla niiqui arajpachquin wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","‛Niz̈aza wejrqui cjiwc̈ha. Weriz̈ tjonan nii arama pucultan tsjii kjuyquiz tjajaquic̈ha. Jalla nuz̈ tjajan, tsjiiqui arajpach kjutñi waytiz̈cu chjichtaz̈ cjequic̈ha, tsjiizti pachpiquiz nii kjuyquiz ectaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Niz̈aza pucultan maatakanaca chica jawuncan, tsjaaqui arajpach kjutñi waytiz̈cu chjichtaz̈ cjequicha. Tsjaazuñzti pachpiquiz ectaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Niz̈aza pucultan luctakanaca joch yokquin z̈elan, tsjiiqui arajpach kjutñi waytiz̈cu chjichtaz̈ cjequic̈ha, tsjiizuñzti nii joch yokquinpacha ectaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jalla niz̈ta tjaajinta takunaca nonz̈cu, niiz̈ tjaajinta z̈oñinacaqui pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿jakziquin tiz̈tanaca wataquiya? Jalla nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Jakziquin ticzi janchi z̈ejlc̈haja, jalla nicju cunturinacaqui muzpa ajcsñic̈ha. Jalla niz̈ta irata jakziquin ana wali paañinacaqui z̈ejlc̈haja, jalla nicju ana walinaca wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nekztanaqui Jesusaqui tjaajinchic̈ha, z̈oñinacz̈laqui Yoozquin mayizizpanc̈ha, ana upa kuzcan, jalla nuz̈ tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tjaajincan jalla tuz̈ quint'ichic̈ha: —Tsjii juez jiliri tsjii wajtquiz z̈elatc̈ha. Yooz ana rispitñitac̈ha, niz̈aza ana c̈hjul z̈oñimi rispitñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Nii wajtquizpacha z̈elatc̈ha tsjaa z̈ew maatak z̈on. Tsjii nooj naa z̈onqui juez jilirz̈quin ojkchinc̈ha, tsjii quija quijsquizjapa, niz̈aza naaz̈a quintriz̈tan naa zumpacha azquichajo. ");
INSERT INTO capNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Az̈kapan juez jiliriqui ana naaz̈a quija nonz pecchic̈ha. Niiz̈ wiruñ niz̈tami pinsichic̈ha, tuz̈ cjican: “Taa z̈ew z̈onqui tirapanikal quijz̈tan wejr molistic̈ha. Yoozmi z̈oñimi wejtta anaz̈ importic̈ha. Jalla nuz̈ cjenami taaz̈a quija nonznac̈ha, wejtquiz ana tira molistajo tii quijz̈tan. Wejrqui ana azquichac̈haj niiqui, naaz̈ tjontjonanaqui wejt z̈awjwat zjijcnac̈hani”. ");
INSERT INTO capNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","7","Nekztanaqui Jesús Jiliriqui cjichic̈ha: —Jalla nuz̈ chiichic̈ha nii anawal juez jiliriqui. Niz̈aza Yooz Ejpqui niiz̈ illzta z̈oñinacz̈ quijanaca azquichaquic̈ha. Ninacaqui majiñami weenami Yoozquinkaz mayizic̈ha. Ninacz̈ mayizitiquiztan Yoozqui ana enenz̈cu ninacz̈ quintranaca azquichaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wejrqui cjiwc̈ha, tsjii noojiqui Yooz Ejpqui niiz̈ illztanacz̈ quija apuraz̈ atintaquic̈ha. Yooziz̈ tsewctan cuchanz̈quita Z̈oñi tjontan, Yoozqui ultimupan niiz̈ illztamiz̈ quija azquichaquic̈ha. Nii tjonz tjuñquiziqui, ¿tii yokquiz z̈ejlñi z̈oñinacaqui Yoozquin kuzziz z̈elasaya? ");
INSERT INTO capNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Tsjii z̈oñinacaqui z̈elatc̈ha, persun honora waytican, niz̈aza parti z̈oñinaca iñarcan. Jalla nii z̈oñinacz̈quiz tii quintu quint'ichic̈ha Jesusaqui, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pucultan z̈oñinacaqui timpluquin ojkchic̈ha, Yoozquin mayiza. Tsjiiqui fariseo partiquiztantac̈ha. Tsjiizuñqui impuesto cobriñi z̈oñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo z̈oñiqui tsijtchi mayiziñitac̈ha, tuz̈ cjican: “Yooz Tata, amquiz sparaquiz̈ cjiwc̈ha. Wejrqui anac̈ha nii yekja z̈oñinaca iratitqui. Ninacac̈ha tjañinacaqui, niz̈aza ninacac̈ha ñejonacaqui, niz̈aza ninacac̈ha adulteriuquiz ojklayñinacaqui. Niz̈aza wejrqui anac̈ha tii impuesto cobriñi iratitqui. ");
INSERT INTO capNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Wejrqui pizc wilta simanquiz ayunasiñc̈ha. Niz̈aza tjapa weriz̈ cantiquiztan tsjii tunca parti tjayiñc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jalla nii impuesto cobriñi z̈oñizti wirquin acha colzi z̈elatc̈ha. Ana tsewcchuc cherzipanz̈ z̈elatcha. Jalla nuz̈ persun ujchiz cjen persun tuzi c̈hajccan z̈elatc̈ha. Niz̈aza cjichic̈ha: “Yooz Tatay, wejr ujchizpantc̈ha. Wejr okznalla”. ");
INSERT INTO capNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jaziqui anc̈hucaquiz cjiwc̈ha. Nii impuesto cobriñi z̈oñiqui Yooz Epiz̈ yujcquiziqui niiz̈ ujquiztan liwriitac̈ha. Niiz̈ kjuya pertunta ojkchic̈ha. Nii fariseo z̈oñizti Yooz Epiz̈ yujcquiziqui tira ujchizpantac̈ha. Ana pertunta cjissic̈ha. Persun honora waytiñi z̈oñinacaqui ultimquiziqui azipanz̈ cjesac̈ha. Niz̈aza ultimquiziqui humilde kuzziz z̈oñinacazti honorchiz cjiskattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tsjii nooj z̈oñinacaqui Jesusiz̈quin ocjalanaca zjijcchic̈ha, kjarz̈tan lanznajo. Nuz̈ zjijcan, Jesusiz̈ tjaajinta z̈oñinacaqui ocjala zjijcñi z̈oñinaca ujzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Nuz̈ nonz̈cuqui Jesusaqui kjawzic̈ha, tuz̈ cjican: —Ocjalanaca wejtquin tjonaj cjee, ana chiiz̈ina. Tii ocjalanacz̈ kuz irata jalla niz̈ta kuzzizza Yooz Epiz̈ mantita kamañchiz z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tii razunazakal chiyuc̈ha. Ana tii ocjalanacz̈ kuz irata Yoozquin kuzzizzalaj niiqui, ana Yooz Ejpz̈ arajpach watja luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wiruñaqui tsjii jiliriqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, zumac̈ha amqui. Arajpach wajtquin wiñaya kamzjapa, ¿c̈hjulut paasaya? ");
INSERT INTO capNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan amqui wejtquiz “zumac̈ham” cjeejo? Anaz̈ jecmi zumaqui, Yoozpankazza zumaqui. ");
INSERT INTO capNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Amqui Yooz mantitanaca zizza: “Anac̈ha adulteriuquiz ojklayzqui. Anac̈ha z̈oñimi conzqui. Anac̈ha tjañi cjisqui. Anac̈ha toscarami chiizqui. Am maa ejpc̈ha rispitzqui”. ");
INSERT INTO capNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Nekztanaqui nii jiliriqui cjichic̈ha: —Wejrqui koltallquiztanpacha tjapa nii lii jaru cumpliñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jalla nuz̈ nii z̈oñiz̈ chiita nonz̈cu, Jesusaqui cjichic̈ha: —Tsjiillakaz pjaltic̈ha amtaqui. Tjappacha am c̈hjultak cusasanaca tuysna. Nekztan porinacz̈quiz nii paaz ona. Jalla nuz̈ onanz̈cuqui tsewcta arajpachquin juc'ant ricachum cjequic̈ha. Jaziqui nekztan wejttan chica ojklayñi cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nii oraqui walja ricachutac̈ha nii z̈oñiqui. Jalla nuz̈ Jesusiz̈ chiitiquiztan nonz̈cu, walja llactazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nii z̈oñi llaquita cherz̈cu, Jesusaqui cjichic̈ha: —Ricachunacz̈taqui walja ch'amac̈ha Yooz kamañ jiczquiz luzqui, Yooz mantita kamañquiz cjisjapaqui. ");
INSERT INTO capNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tsjii camello cjita pajk animalaqui ch'aman acuj cjuñquiz luzasac̈ha. Ricachunacz̈taqui tsjan ch'amac̈ha Yooz jiczquiz luzqui, Yooz mantita kamañquiz cjisjapaqui. ");
INSERT INTO capNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jalla nii nonz̈cu, nonzñi z̈oñinacaqui cjichic̈ha: —¿Jequit liwriita cjesajo? ");
INSERT INTO capNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Nekztanaqui Jesusaqui cjichic̈ha: —Z̈oñiqui anaz̈ persunpacha liwrii atasac̈ha. Yoozpankazza liwriiñiqui. Yoozqui jecmi liwrii atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nekztanaqui Pedruqui cjichic̈ha: —Wejt Jiliri, wejrnacqui tjappacha ecchinc̈ha, amtan chica ojklayzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jalla nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Weraral chiyuc̈ha. Jakzilta z̈oñimi kjuya, maa ejp, jilanaca, cullaquinaca, tjun, maatinaca, jalla ninaca ecc̈haj niiqui, Yooz mantita kamañquiz ojklayzjapa, ");
INSERT INTO capNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tii muntuquiz z̈ejlcan juc'anti tjaataz̈ cjequic̈ha. Y niz̈aza arajpachquin ojkz̈cu, Yooztan wiñaya cuntintu kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nekztanaqui Jesusaqui niiz̈ tuncapan tjaajintanaca tsjii latu kjawzic̈ha, tuz̈ cjican: —Jaziqui Jerusalén watjaz̈ ojkla. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tuquitanpacha Yooz taku paljayñi profetanacaqui wejt puntuquiztan mazincan cjijrchic̈ha. Jalla nii Jerusalén wajtquin ninacz̈ mazinta taku tjappacha cumplisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Yekja wajtchiz z̈oñinacz̈quiz intirjital cjeec̈ha. Niz̈aza ancha iñartal cjeec̈ha; arartal cjeec̈ha. Niz̈aza llawziz̈tan tjujtal cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Niz̈aza wjajtal cjeec̈ha. Nekztanaqui contal cjeec̈ha. Pero ticz̈cuqui c̈hjep majquiztan jacatatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jalla nii tjaajinta z̈oñinacaqui Jesusiz̈ chiita ana zinta intintazatc̈ha, c̈hjul puntuquiztan chiic̈haja, jalla nii. Nii takuqui ana intintichuc takuz̈takaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jalla nekztanaqui Jesusaqui Jericó cjita wajt z̈cati irantatc̈ha. Jalla nuz̈ irantan tsjii zur z̈oñi jicz latuquiz julzi z̈elatc̈ha, niiqui kjaraz̈ chjinchjinatc̈ha onajo. ");
INSERT INTO capNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Walja z̈oñinaca watwatñi nonz̈cu, zur z̈oñiqui pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan tama tama z̈oñinaca watwat? ");
INSERT INTO capNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Nekztanaqui z̈oñinaca kjaazic̈ha, tuz̈ cjican: —Jesusa, nii Nazaret wajtchiz z̈oñiqui watc̈ha tii jiczquiz. ");
INSERT INTO capNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jalla nii zizcu, zur z̈oñiqui altu jorz̈tan kjawchic̈ha, tuz̈ cjican: —¡Jesusa, Davidz̈ maati, wejr okznalla! Ana wali z̈eluc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nii Jesusiz̈ tuqui ojkñi z̈oñinacaqui nii zur z̈oñi ujzic̈ha, ch'uj z̈elajo. Zur z̈oñizti juc'anti altu jorz̈tan kjawchic̈ha, tuz̈ cjican: —¡Davidz̈ majch, wejr okznalla! ");
INSERT INTO capNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nekztanaqui altu jorz̈tan chiiñi nonz̈cu, Jesusaqui tsijtsic̈ha. Zur z̈oñi zjijqui cuchanchic̈ha. Zur z̈oñi z̈catz̈inz̈cu Jesusaqui pewczic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿C̈hjulut amta wejr paaquiya? Nii zur z̈oñiqui kjaazic̈ha, tuz̈ cjican: —¡Wejt Jiliri, c̈hjujcquiz̈ cjetz̈inalla! ");
INSERT INTO capNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nekztanaqui Jesusaqui cjichic̈ha: —Am c̈hjujcqui cjetz̈taj cjisla. Amiz̈ tjapa kuz criitiquiztanaqui, c̈hjetintamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Nii orapacha zur z̈oñiqui cherñi cjissic̈ha. Nekztanaqui Jesusiz̈tan chica ojklayatc̈ha, Yoozquin honora waytican. Jalla niz̈ta paata cherz̈cu, tjapa z̈oñinacaqui Yoozquin honora waytichizakazza. ");
INSERT INTO capNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jalla nekztanaqui Jerusalén wajt kjutñi ojkcan Jesusaqui Jericó cjita watja luzzic̈ha; nekztan nii wajt taypiquiz watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nicju tsjii ricach z̈oñi z̈elatc̈ha Zaqueo cjita. Nii z̈oñiqui impuesto cobriñiz̈ jiliritac̈ha, ancha ricachutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Niz̈aza nii z̈oñiqui Jesusa pajz pecatc̈ha. Kolta z̈oñitac̈ha. Jalla niz̈tiquiztan wacchi z̈oñinacz̈ taypiquiz cjen, Jesusiz̈quin anatac̈ha cherchuca. ");
INSERT INTO capNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Nekztan Zaqueoqui tucquin z̈ajtz̈cu tsjii sicómoro cjita munti yawchic̈ha, Jesusa cherzjapa. Nii munti, jicz latuquiz z̈elatc̈ha, Jesusiz̈ watz z̈catipan. ");
INSERT INTO capNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nii munti nuz̈ watcan, Jesusaqui tsewcchuc cherzic̈ha. Nuz̈ cherz̈cu cjichic̈ha: —Zaqueo, apura chjijwz̈ca. Tonj tjuñi am kjuyquiz kamstanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jalla nuz̈ chiitiquiztan Zaqueoqui apura chjijwz̈quichic̈ha. Ancha cuntintu Jesusa risiwchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jalla nii cherz̈cu, tjappacha nii z̈oñinacaqui Jesusiz̈ quintra chuchchic̈ha, tuz̈ cjican: —Jesusaqui nii ujchiz z̈oñz̈ kjuya kami ojkc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jalla nekztanaqui Zaqueoqui tsijtscu, Jesusa Jilirz̈quiz cjichic̈ha: —Wejt Jiliri, tii zizza. Porinacz̈quiz tjaa-ac̈ha chicata wejt cusasa z̈ejlñinaca. Niz̈aza jakzilta z̈oñz̈quiztan wejr incalltuc̈haja, jalla nii z̈oñz̈quiz wejr tjepnac̈ha pajkpic wiltiquiztan juc'anti. ");
INSERT INTO capNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nekztanaqui Jesusaqui cjichic̈ha: —Tonj tjuñi tii kjuychiz z̈oñinacaqui liwriitac̈ha, Yooz kamañquiz luzjapa. Tii z̈oñiqui Abraham cjita majchmaatiquiztanpacha tjonñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui tii muntuquiz tjonchinc̈ha, ujchiz z̈oñinaca kjawzñi, niz̈aza ninaca liwrii. ");
INSERT INTO capNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jerusalén wajtz̈ z̈cati z̈elan, z̈ejlñi z̈oñinacaqui pinsichic̈ha, tuz̈ cjican: “Anzilla Yooz mantiz tjuñiqui tjonac̈hani”. Jalla nuz̈ pinsitiquiztan, niz̈aza nii z̈ejlñi z̈oñinaca niiz̈ chiita taku nonznan, Jesusaqui tii quintu paljaychic̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","tuz̈ cjican: —Tsjii z̈oñi z̈elatc̈ha rispitta famillquiztan. Nii z̈oñiqui az̈kquin yekja wajtquin ojkchic̈ha, chawc jilir nombramiento tanzjapa. Nuz̈ tanz̈cu quejpz̈caquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ima ojkcan, nii z̈oñiqui tunca niiz̈ piyunanaca kjawzic̈ha. Kjawz̈cu zapa mayniz̈quiz tsjii pajk valorchiz paaz intirjichic̈ha. Niz̈aza ninacz̈quiz cjichic̈ha: “Tii paaztan negocioz̈ paaquic̈ha, wejt quejpsquizcama”. ");
INSERT INTO capNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Nii z̈oñz̈ persun wajtchiz z̈oñinacaqui nii walja chjaawjkatchic̈ha. Jalla niz̈tiquiztan niiz̈ wirquin tsjii cumizuna mantichic̈ha, tuz̈ cjeyajo: “Tii z̈oñi anaz̈ pecc̈ha uc̈hum chawc jiliri cjisjapa”. ");
INSERT INTO capNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Niz̈tami chawc jiliri nombritatac̈ha. Nekztan niiz̈ yoka quejpchic̈ha, mantizjapa. Niiz̈ irantiz̈cuqui, kjawzñi cuchanchic̈ha niiz̈ paaz intirjita z̈oñinacz̈quin, jaknuz̈t zapa mayni paaztan canc̈haja, jalla nii zizjapa. ");
INSERT INTO capNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Primir piyunaqui prisintichic̈ha, tuz̈ cjican: “Wejt patruna, am paaztan canchinc̈ha tunca wiltan wiltan juc'anti”. ");
INSERT INTO capNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nii chawc jiliriqui nii piyunz̈ honora paljaychic̈ha, tuz̈ cjican: “Ancha walic̈ha. Zuma piyunamc̈ha amqui. Nii zkoluc paaztan zumpacha trabajchamc̈ha. Jaziqui amqui jilirim cjequic̈ha, tunca watja mantiñim cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Tsjii piyunazti prisintichizakazza, tuz̈ cjican: “Wejt patruna, am paaztan canchinc̈ha pjijska wiltan wiltan juc'anti”. ");
INSERT INTO capNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Nii chawc jiliriqui paljaychic̈ha, tuz̈ cjican: “Jaziqui jilirim cjequic̈ha. Pjijska wajtquiztan mantiñim cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nekztanaqui tsjii piyunazti prisintichizakazza, tuz̈ cjican: “Wejt patruna, tiz̈ am paazqui. Tsjii pañquiz z̈cucz̈cu chjojchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Amqui walja cumpliskatñi patrunamc̈ha. Jalla niztiquiztan am eksinc̈ha. Ricujñamc̈ha ana amiz̈ nonztaqui. Niz̈aza ajzñamc̈ha ana amiz̈ c̈hjactaqui”. ");
INSERT INTO capNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nekztanaqui nii chawc jiliriqui chiiz̈inchic̈ha, tuz̈ cjican: “Ana zum piyunamc̈ha amqui. Am persun chiita takuqui am uj tjeez̈a. Amqui zizzamc̈ha, wejrqui kjanapanz̈lani cumpliskatiñ z̈oñtni, jalla nii. Ana weriz̈ nonztaqui ricujiñc̈halani. Ana weriz̈ c̈hjactaqui ajzniñc̈halani. ");
INSERT INTO capNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Niz̈tiquiztanaqui, ¿kjaz̈tiquiztanam amqui wejt paaz ana bancuquiz majcz̈injo? Bancuquiz majcz̈intiquiztan wejrqui paaz machtanpacha ricujtasac̈ha, tekz quejpz̈cu”. ");
INSERT INTO capNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nekztanaqui nii patrun jiliriqui parti z̈oñinacz̈quiz mantichic̈ha, tuz̈ cjican: “Intirjita paaz kjañzna. Nii tunca paazziz z̈oñz̈quiz tjaa”. ");
INSERT INTO capNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Z̈oñinacaqui cjichic̈ha: “¡Wejt Jiliri! Tunca paazzizza nii z̈oñiqui”. ");
INSERT INTO capNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Patrun jiliriqui kjaazic̈ha, tuz̈ cjican: “Anc̈hucaquiz tii razunal cjiwc̈ha. Jakzilta z̈oñit niiz̈ wacchi tjaata cusasa zuma cwitac̈ha, jalla niiz̈quiz juc'anti tjaata cjequic̈ha. Niz̈aza jakzilta z̈oñit niiz̈ koloculla tjaata cusasa ana zuma cwitac̈haja, jalla niiz̈quiztan asta nii zkolocullami kjañtaz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Niz̈aza nii jiliriqui mantichic̈ha, tuz̈ cjican: “Nii wejt quintra z̈oñinacaqui ana wejr pecchic̈ha ninacz̈ chawc jiliri cjisjapa. Jaziqui zjijczna ticju. ¡Zjijcz̈cu wejt yujcquiz conzna!” Jalla nuz̈ mantichic̈ha nii jiliriqui. ");
INSERT INTO capNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jalla nuz̈ quint'iz̈cu, Jesusaqui Jerusalén watja tira ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Betfagé cjita niz̈aza Betania cjita watjanaca z̈catz̈incan, niz̈aza Olivos cjita curulla z̈cati z̈elan, jalla nekztan pucultan niiz̈ tjaajinta z̈oñinaca cuchanchic̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tuz̈ cjican: —Nii nawjkta watja oka. Jalla nicju anc̈hucqui mokta aznu wac̈haquic̈ha. Anaz̈ jecmi nii aznuqui yawchi. Jalla nekztanaqui moktiquiztan jwerz̈cu, tekz zjijca. ");
INSERT INTO capNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jalla nuz̈ jwerz̈cu zjijcawc cjen cunamit z̈oñimiz̈ pewcznac̈han, “¿Kjaz̈tiquiztan tii aznu jwerjo?” cjicanaqui. Jalla nii puntu pewcztiquiztan anc̈hucqui kjaaznaquic̈ha, tuz̈ cjican: “Jesusa Jiliriz̈ tii aznu pecc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nekztanaqui nii pucultan tjaajintanacaqui ojkchic̈ha. Jaknuz̈t Jesusa chiitc̈haja, jalla nuz̈ cjitacama watchic̈ha. Jalla nuz̈ tsjii mokta aznu watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jalla nuz̈ jweran, nii aznuz̈ tuyñunacaqui pewczic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan nii aznu jwer anc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tjaajintanacaqui kjaazic̈ha, tuz̈ cjican: —Jesusa Jiliriqui tii aznuz̈ pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nekztanaqui Jesusiz̈quiz chjitchic̈ha. Nekztan zquitinaca jepz̈cu ninacaqui Jesusiz̈quiz yawkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Nii aznuquiz Jesusaz̈ jiczquiz okan, z̈oñinacaqui zquiti chjinchic̈ha, zquitinac juntuñ okajo chawc jiliriz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos cjita curulla watan, Jerusalén watja tjenzic̈ha. Jalla nekztanaqui tjapa niiz̈ tjaajinta z̈oñinacaqui altu jorz̈tan Yooz honora wayti kallantichic̈ha. Chipchipcan Yooz honora waytichic̈ha, tjapa Jesusiz̈ paata milajrunaca cherc̈hiz cjen. ");
INSERT INTO capNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Niz̈aza cjichic̈ha: —¡Chawc Jiliri! ¡Yooz tjuuquiz tjonchi jiliri! ¡Honorchiz cjila! ¡Arajpacha z̈ejlñinaca cuntintuz̈ cjee! ¡Arajpach Yoozquin wali honorchiz cjila! ");
INSERT INTO capNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jalla nuz̈ Jesusiz̈quiz honora waytitiquiztan tsjii z̈ejlñi fariseo z̈oñinacaqui paljaychic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, tii am apzñi z̈oñinaca ujzna ch'uj z̈elajo. ");
INSERT INTO capNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucaquiz cjiwc̈ha, tii z̈oñinacaz̈ ch'uj cjisnaquila niiqui, tii maznacamiz̈ altu jorz̈tan chiyasac̈ha, wejt honora waytizjapa. ");
INSERT INTO capNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén watja z̈catz̈incan, jalla nii watja cherz̈cu, Jesusaqui nii wajtchiz z̈oñinacaz̈ cjen kaachic̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","tuz̈ cjican: —Jerusalén wajtchiz z̈oñinaca, tonj tjuñquiziqui wejt puntuquiztan intintaztasaz̈ niiqui, zuma cuntintuz̈ cjitasac̈ha. Walipankaz kamtasac̈ha. Anc̈huca kuznaca jeejskatz pecuc̈ha. Pero wejt puntuquiztan anc̈hucaquiztan c̈hjojz̈tac̈ha. Jaziqui anc̈hucqui Yooz zumanaca anaz̈ cherasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wejt puntu ana intintazziz̈ cjen walja anawali tjuñinacaz̈ tjonaquic̈ha. Nii tjuñinacquiziqui anc̈huca quintra z̈oñinacaqui tii wajtz̈ tjiya tsjii pirka quintra paaquic̈ha. Tjapa kjuttanz̈ anc̈huca wajt muytata quintrarionacaqui z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Niz̈aza anc̈huca wajt pirkami k'ala pajltaz̈ cjequic̈ha. Tii wajtchiz z̈oñinaca ocjalanacz̈tanpacha contaz̈ cjequic̈ha. Niz̈aza tjappacha k'ala pampa nonz̈taz̈ cjequic̈ha, anaz̈ maz tawkitami z̈elaquic̈ha. Yoozqui anchucaquiz tsjii liwriiñi cuchanz̈quichic̈ha; anc̈huczti nii liwriiñiqui ana pajchinc̈hucc̈ha. Jalla niz̈tiquiztan tii wataquic̈ha. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jerusalén watja irantiz̈cu, Jesusaqui timpluquiz luzzic̈ha. Timpluquiztan zawncchuc liwj tuyñinacami kjayñinacami tjirkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ninacz̈quiz cjichic̈ha: —Cjijrta Yooz takuqui tuz̈ cjic̈ha: “Wejt kjuyaqui Yoozquin mayiziz kjuyac̈ha”. Anc̈huczti tii wejt kjuya tjañi z̈oñinacz̈ kjuyaz̈takaz paachinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jalla nekztanaqui zapuru Jesusaqui tjaajnatcha timpluquiz. Pero timplu jilirinacami lii tjaajiñi maestrunacami wajt jilirinacami, jalla ninacazti jaknuz̈t Jesusa coni atas, jalla nii kaznatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero tjappacha nii wajtchiz z̈oñinacaqui Jesusiz̈ taku nonzjapa kuz tjaatc̈ha. Jalla niz̈tiquiztan ana jaknuz̈quiztanami nii conz puntuqui asiptiskatz atatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Zapuru Jesusaqui timpluquiz z̈oñinacz̈quiz tjaajnatc̈ha, y niz̈aza liwriiñi Yooz taku paljayatc̈ha. Jalla nuz̈ tjaajnan, tsjii nooj timplu jilirinaca, lii tjaajiñi jilirinaca, wajt jilirinaca, jalla ninacaqui Jesusiz̈quiz macjatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nuz̈ macjatz̈cu Jesusiz̈quiz paljaychic̈ha: —Jaziqui am chiyaquic̈ha. ¿Jec am mantichi tii paazjapajo? Niz̈aza ¿jec jilirit am utchi jiliriz̈takaz cjisjapajo? ");
INSERT INTO capNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Wejrmi jazic anc̈hucaquiz zakal pewcznac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ject Juan mantiz̈quichi bautisjapajo? ¿Yoozkaya uz z̈oñinaca, ja? Kjaazna. ");
INSERT INTO capNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jalla nuz̈ chiitiquiztanaqui ninacpora ch'aasi kallantichic̈ha, tuz̈ cjican: —¿Jaknuz̈um cjeequi? “Yooz mantitac̈ha” cjican uc̈hum kjaaznaquiz̈ niiqui, “¿Kjaz̈tiquiztan anc̈huc nii Juan ana criichinc̈huctajo?” jalla nuz̈ cjec̈han tiicni. ");
INSERT INTO capNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Zoñiz̈ mantitacha Juanqui” cjican uc̈hum kjaaznaquiz̈ niiqui, tjapa z̈oñinacaqui uc̈hum conac̈hani maztan c̈hjacjawi. Tii z̈oñinacaqui Juanz̈ puntuquiztan cjiñic̈ha, niiqui werarapanc̈ha Yooz taku paljayñi profetaqui, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Nuz̈ palt'iz̈cu nii jilirinacaqui kjaazic̈ha, tuz̈ cjican: —Wejrnacqui anal zizuc̈ha, jequit Juanqui bautisajo mantiz̈quitc̈haja, nii. ");
INSERT INTO capNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nekztanaqui Jesusaqui cjichic̈ha: —Niz̈aza wejrqui ana zakal maznasac̈ha, jec jiliriz̈ mantita paa-uc̈haja wejrqui, nii. ");
INSERT INTO capNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nekztanaqui Jesusaqui z̈oñinacz̈quiz paljayi kallantichic̈ha. Paljaycan tii quintu quint'ichic̈ha, tuz̈ cjican: —Tsjii patrun z̈oñiqui uwasanac zkala c̈hjaczic̈ha. Nekztan nii zkala partira tjaachic̈ha piyunanacz̈quiz. Nekztanaqui az̈kquin ojkchic̈ha az̈k tjuñi kami. ");
INSERT INTO capNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Uwasa ajz cujicha timpu tjontan patrunaqui piyuna cuchanz̈quichic̈ha niiz̈ partir zkala ricujzjapa. Nii pachpiquiz partira langzñi z̈oñinacazti patrunaz̈ cuchanz̈quita piyuna kijchcu chjatkatchic̈ha. Ana c̈hjulchiz cuchanchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nekztanaqui patrunaqui wilta tsjiiz̈tan piyuna cuchanz̈quichic̈ha. Nekztan partir yokquiz kamñi z̈oñinacaqui patrunaz̈ cuchanz̈quita piyuna ch'aanchic̈ha, niz̈aza kijtchic̈ha, niz̈aza ana c̈hjulchiz cuchanchic̈ha patrunz̈quin. ");
INSERT INTO capNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nekztanaqui patrunaqui tsjiiz̈tan cuchanz̈quichic̈ha. Nii partira z̈oñinacaqui cuchanz̈quita piyuna chjojritchic̈ha, niz̈aza chjatkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","‛Niz̈tami nii yokchiz patrunaqui pinsichic̈ha, tuz̈ cjican: “¿C̈hjulut wejr paas? Wejt k'ayi majch cuchnac̈ha. Jalla nuz̈ cherz̈cuqui nii partira z̈oñinacaqui rispitac̈hani”. ");
INSERT INTO capNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero partira zkala langzñi z̈oñinacazti cuchanz̈quita majch cherz̈cu, ninacpora parlassic̈ha, tuz̈ cjican: “Tiiqui tjappacha tii irinsa tanznac̈hani. Jaziqui ticz̈ conz̈la. Nekztan uc̈humz̈ tii zkal yokac tanznaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Nuz̈ pinsitiquiztan partira langzñi z̈oñinacaqui cuchanz̈quita majch yok tjiya jwescu conchic̈ha. ‛Jaziqui pewcznuc̈ha: —Nii zkal yokchiz patrunaqui ¿c̈hjulukat nii z̈oñinacz̈tanac paac̈hani? ");
INSERT INTO capNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Wejrqui cjiwc̈ha. Tjonz̈cu zkal yokchiz patrunaqui partira langzñi z̈oñinaca conaquic̈ha. Nekztanaqui patrunaqui niiz̈ zkal yoka yejkz̈quin tjaaznaquic̈ha. Jalla nuz̈ nii quintu nonz̈cu, z̈oñinacaqui cjichic̈ha: —¡Yooz munañpaqui anaj nii cjila! ");
INSERT INTO capNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesusaqui ninacz̈ kjutñi cherz̈cu cjichic̈ha: —Wejt puntuquiztanaqui cjijrta Yooz takuqui tuz̈ cjic̈ha: “Kjuy pirkiñinacaqui tsjii maz tjojtchic̈ha. Nekztanaqui tjojtta mazqui isquinquiz cjissic̈ha. Ultimquiziqui tucquin cjissic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nii maz cjen jakziltat ujquiz tjojtsnac̈haja, jalla niiqui pirasuz̈takaz t'okuntaz̈ cjequic̈ha. Niz̈aza jakziltiz̈ juntuñ nii mazqui tjojtsnaquiz̈ niiqui, pulpuz̈takaz t'oknaquic̈ha. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jesusaqui nii quintu chiyatc̈ha quintra z̈oñinacz̈ puntu. Jalla niz̈tiquiztan timplu jilirinaca, niz̈aza lii tjaajiñi maestrunaca, jalla ninacaqui Jesusaqui tanz pecatc̈ha nii orapacha. Pero parti z̈ejlñi z̈oñinaca ekscu, ana tani atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pero nii quintranacaqui Jesusiz̈quiz tiraz̈ awayt'atc̈ha. Niz̈aza tsjii kjaz̈t awayt'ini z̈oñinaca mantichic̈ha, Jesusiz̈tan ojklayajo zuma z̈oñiz̈takaz. Nuz̈ chica ojklaycan Jesusiz̈quiztan ana zuma taku jwes pecatc̈ha, uj tjojtunzjapa. Jalla nuz̈ uj jwezanz̈cu nii wajt chawc jilirz̈quiz intirjiz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Jalla nuz̈ awayt'ican Jesusiz̈quiz pewczic̈ha tuz̈ cjican: —Tjaajiñi Maestro, zizuz̈ wejrnacqui, am werarapan tjaajiñamc̈ha. Kjaz̈tam parti z̈oñinacac chiyaj cjee, amqui werarapankaz chiiñamc̈ha Yooz kamañ puntuqui. ");
INSERT INTO capNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Jaziqui tjaajznalla tii puntuquiztan. Wejrnacqui César cjita chawc jilirz̈quiz tas paaz tjaayiñc̈ha. ¿Jalla nuz̈ tas paaz tjaazqui wali cjesaya, uz anaz̈ wali cjesaj? ");
INSERT INTO capNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero nuz̈ pewcztiquiztan nonz̈cu Jesusaqui ninacz̈ pizc kuzziz naychic̈ha. Nekztanaqui cjichic̈ha: —¿Kjaz̈tiquiztan anc̈hucqui chawc ujquin wejr tjojtskatz pecjo? ");
INSERT INTO capNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tsjii paaz zjijca, cherzjapa. Paaz zjijcz̈cu, Jesusaqui cjichic̈ha: —¿Tii paazquiz jecz̈ yujcta? ¿Niz̈aza tii paazquiz jecz̈ tjuu cjijrtata? Ninacaqui kjaazic̈ha: —César cjita jilirz̈ yujcc̈ha, niiz̈ tjuuzakazza. ");
INSERT INTO capNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —C̈hjulumi jilirz̈ta cjenaqui jilirz̈quiz tjaa. Niz̈aza c̈hjulumi Yoozta cjenaqui Yoozquiz tjaa. ");
INSERT INTO capNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Anaz̈ jecmi Jesusiz̈quiztan ana wal taku jwesi atasac̈ha nii z̈ejlñi z̈oñinacz̈ yujcquiz cjicanpachaqui. Jalla nuz̈ Jesusiz̈ kjaaztiquiztanaqui ninacaqui ispantichic̈ha; ch'uju cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Wiruñaqui tsjii kjaz̈t saduceo cjita z̈oñinacaqui Jesusiz̈tan zali ojkchic̈ha. Nii saduceo z̈oñinacaqui tjaajiñitac̈ha, ticzi z̈oñiqui anapan jacatatasac̈ha, nuz̈ cjiñitac̈ha. Jalla nii jacatatz puntuquiztan Jesusiz̈quiz paljaychic̈ha, ");
INSERT INTO capNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","tuz̈ cjican: —Tjaajiñi Maestro, Moisesaqui uc̈humnacalta cjijrtkalc̈ha, tuz̈ cjican: “Tsjii z̈oñi ticznasaz̈ niiqui, niiz̈ tjun ana ocjalchiz cjesaz̈ niiqui, nekztan nii ticzi z̈oñz̈ jilaqui naa z̈ew z̈on tjunatan zals waquizic̈ha, nii ticzi jilz̈ cuntiquiztan ocjala paazjapa”. ");
INSERT INTO capNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jaziqui pakallak jilazullca z̈elatc̈ha. Jilir jilaqui zalsic̈ha. Nekztan ticzic̈ha ana ocjalchiz. ");
INSERT INTO capNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nekztanaqui tsjii taypir jilaqui z̈ew z̈on tjunatan zalsizakazza. Nekztan ticzizakazza ana ocjalchiz. ");
INSERT INTO capNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Nekztanaqui yekja taypir jilaqui z̈ew z̈on tjunatan zalsizakazza. Niiz̈ jaru niiz̈ jaru naa tjunatan zalsic̈ha tjapa nii pakallak jilazullcanacaqui. Niz̈aza tjappacha ticzic̈ha jilazullcanacaqui. Ana ocjala ecchipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ultimquiziqui naa maatak z̈onqui ticzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Jaziqui z̈oñinaca jacatattanaqui, ¿jakzilta jilz̈ tjunt cjequejo naa z̈onjo? Tjappacha nii pakallak jilazullcaqui naa z̈onatan zalsic̈ha. —Jalla nuz̈ pewczic̈ha saduceo quintra z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jalla niz̈ta puntuquiztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tii muntuquiz z̈ejlcanaqui luctakami maatakami zalza; niz̈aza maatinaca zalsjapa tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jakziltat Yoozquin kuzzizlaj niiqui ticziquiztan jacatatz̈cu, arajpach wajtquin z̈elaquic̈ha. Nicju z̈ejlcan ana zalznaquic̈ha. Niz̈aza anaz̈ zalzmi z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Arajpachquin z̈ejlcan, z̈oñinacaqui anjilaz̈takaz cjequic̈ha; ana ticznasac̈ha. Niz̈aza jalla nuz̈ jacatattiquiztanaqui Yooz z̈ejtñi maatinacapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yooz tawk libruquiz tsjii ujsñi kal quintu z̈ejlc̈ha. Nii quintu quint'ican Moisespachac̈ha uc̈hum zizkatchi, z̈oñinaca ticziquiztan jacatatñi, jalla nii. Nii Yooz tawk libruquiz Moisesqui cjijrchic̈ha, tuz̈ cjican: “Yooz jiliriqui Abrahamz̈ Yoozza. Niz̈aza Isaacz̈ Yoozza. Niz̈aza Jacobuz̈ Yoozza”. ");
INSERT INTO capNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nii z̈oñinacz̈ curpu ticziz̈ cjenami, z̈ejtc̈ha. Yoozqui anac̈ha ticzi z̈oñz̈ Yoozqui. Niic̈ha z̈ejtñi z̈oñz̈ Yoozqui. Tjapa Yoozquin kuzziz z̈oñinacaqui z̈ejtchipan z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jalla nekztanaqui tsjii kjaz̈ lii tjaajiñi maestrunacaqui cjichic̈ha: —Zuma Tjaajiñi Maestro, walim chiichamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jesusiz̈ walja zizñi zizñi chiican quintra z̈oñinacaqui eksic̈ha iya pewczjapaqui. Panz̈ atiptatac̈ha ninacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nekztanaqui Jesusaqui cjichic̈ha: —Z̈oñinacaqui tuz̈ cjiñic̈ha: “Cristuc̈ha Davidz̈ Majchqui”. ¿Kjaz̈tiquiztan nuz̈ cjeejo? ");
INSERT INTO capNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Davidpachac̈ha cjichi Salmos cjita libruquiz, tuz̈ cjican: “Yooz Ejpqui wejt chawjc jilirz̈quiz cjichic̈ha: ‘Am kjojch koztan am quintri z̈oñinaca t'oksnac̈ha, jalla nii t'okscama wejt z̈ew latuquiz julzi z̈ela amqui’ ”. ");
INSERT INTO capNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Davidpachac̈ha Cristuz̈ puntuquiztan “Wejt chawjc jiliric̈ha” cjican chiichic̈ha. Jalla niz̈tiquiztan, ¿jaknuz̈t Cristo chawjc jiliri cjicanpacha Davidz̈ majch cjesajo? ");
INSERT INTO capNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Tjapa z̈oñinacaz̈ nonznan, Jesusaqui niiz̈ tjaajinta z̈oñinacz̈quiz paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Lii tjaajiñi maestrunacz̈quiztan cwitaza. Ninacaqui tol zquitchiz ojklayz justasñic̈ha, walja honorchiz cjisjapa. Niz̈aza palazquiz ojklaycan zuma rispitchiz̈ tsaanskatz pecñic̈ha. Niz̈aza ajcz kjuyquiz tucquin julz pecñic̈ha. Niz̈aza pjijstiquiz lujlcan ancha tucquin julz̈cu honorchiz cjiskaz pecñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Niz̈aza ninacapacha z̈ew maatakz̈ cusasanaca tanzjapa, incallc̈ha. Z̈oñinaca incallzjapa Yooztan az̈ka az̈ka parlitaz̈oka cjiñic̈ha. Yoozquin tjapa kuzziz z̈oñinacaz̈takaz tjeez pecc̈ha. Jalla niz̈tiquiztan ninacaqui juc'ant tsjan anawaliz̈ castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Tsjii nooj timpluquiz z̈ejlcan, Jesusaqui wali jiru ricach z̈oñinaca cherchic̈ha ofrend cajquiz paaz uchñi. ");
INSERT INTO capNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Niz̈aza tsjaa poris z̈ew maataka cherchic̈ha. Naa z̈ewqui pizc paazalla utchiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jalla nii cherz̈cu Jesusaqui cjichic̈ha: —Tii razunal cjiwc̈ha. Taa poris z̈ew z̈onqui ofrend cajquiz juc'ant jila utchiñc̈ha, tjapa parti z̈oñinacz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Parti z̈oñinacaqui z̈ejtchi paaz utchic̈ha. Naa poris z̈ewzti tjappacha naaz̈a paaz utchiñc̈ha; ana iya z̈ejlc̈ha, c̈hjeri kjayzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yekjap z̈oñinacaqui timplu puntuquiztan parlatc̈ha, niz̈aza nii timpluquiz z̈ejlñi c'achja maznac puntuquiztan parlatc̈ha, niz̈aza nii Yoozquiz ofrenda tjaata puntuquiztan parlatc̈ha. Jalla nuz̈ nonz̈cu timplu puntuquiztan Jesusaqui chiichic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Tsjii nooj tjapa tii timplu pajltaz̈ cjequic̈ha. Ana zinta tii maznaca pirkita z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jalla nekztanaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, ¿c̈hjulorat tii amiz̈ chiita wataquejo? Ima amiz̈ chiita takunaca watan, ¿c̈hjulut siñalaz̈takaz cjequejo? ");
INSERT INTO capNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Nekztanaqui Jesusaqui cjichic̈ha: —Anc̈hucqui persunpachquiz cwitaza, anac̈ha incallskata. Walja z̈oñinacaqui wejt tjuu aynakcanz̈ tjonaquic̈ha, tuz̈ cjican: “Wejrtc̈ha Cristutqui”. Niz̈aza “Wajillaz̈ Cristuz̈ tjonaquic̈ha”. Nuz̈ cjicanz̈ ojklayaquic̈ha. Jalla nuz̈ chiyanami anc̈hucqui anac̈ha criya, niz̈aza anaz̈ ninacz̈tan apznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","C̈hjulorat quira zalz quintumi niz̈aza kichas zalz quintumi z̈elac̈haj niiqui anc̈hucqui wiraz̈ ana tsucaquic̈ha. Nuz̈: watanami imaz̈ tii muntu tucuzinzqui irjatz̈caquic̈ha. Jalla niz̈ta ana walinacac̈ha primiraqui watstanqui. ");
INSERT INTO capNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesusaqui tira paljaychic̈ha, tuz̈ cjican: —Tsjii nacionz̈tan tsjii nacionz̈tan kichasaquic̈ha nacionpora. Nacionanacquiztan quiranaca zalassaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Niz̈aza pajk terremotonacaz̈ wataquic̈ha, yokaz̈ chjekinskatcan. Niz̈aza parti yokaran wali chawc mach'a z̈elaquic̈ha. Niz̈aza parti yokaran anawal cona z̈elaquic̈ha. Niz̈aza arajpachquin anawali ispantichucanacaz̈ parizaquic̈ha, pajk siñalaz̈takaz wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","‛Pero ima tiz̈tanaca watcan anc̈hucqui tantaz̈ cjequic̈ha, niz̈aza kijchtaz̈ cjequic̈ha. Niz̈aza ajcz kjuyquin chjichtaz̈ cjequic̈ha uj jwesanzjapa. Niz̈aza carsilquiz chawctaz̈ cjequic̈ha. Niz̈aza wali chawjc jilirz̈ yujcquin chjichtaz̈ cjequic̈ha. Jalla niz̈tanacaz̈ anc̈hucaquiz wataquic̈ha, anc̈hucaz̈ wejtquin kuzziz cjen. ");
INSERT INTO capNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jilirz̈ yujcquiz chjichta cjen, anc̈hucqui wejt favoraz̈ tjurt'aquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ima jilirz̈ yujcquiz tjurt'ican anc̈hucqui anc̈huca kuzquiz ana tantiiz waquizic̈ha, jaknuz̈t tjurt'ac̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Tjurt'iñi chiiz oraqui weril zizñi taku tjaajz̈cac̈ha anc̈huca kuzquiz. Nii anc̈hucaz̈ zizñi taku chiitiquiztan anaz̈ jecmi anc̈huca quintra kjaazñi atasac̈ha. Inakaz cjisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Anc̈hucqui tarasuntaz̈ cjequic̈ha. Maa ejp, jilanaca, famillanaca, mazinaca, jalla ninacz̈quiztanami tarasuntaz̈ cjequic̈ha anc̈hucqui. Nekztan yekjap anc̈hucaquiztan contaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Niz̈aza wacchi tii muntuquiz kamñi z̈oñinacaqui anc̈hucaquiz chjaawjkataquic̈ha, weriz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jalla nuz̈ cjenami anaz̈ zinta anc̈huca ach charami pertiskatta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Niz̈aza sufrichiz̈ cjenami jakziltat zumpacha Yoozquin tjurt'ichi cjec̈haja, Yooztan wiñaya cuntintu kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesusaqui cjichizakazza: —Jerusalén watja zultatuz̈ muyuntita cjen, anc̈hucqui naaznaquic̈ha, ultimu nii watjaqui t'ezintaz̈ cjeekalaka, jalla nuz̈ cjequic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jalla nuz̈ naazcan, Judea yokquin z̈ejlñi z̈oñinacaqui cur kjutñi zajtcu atipz waquizic̈ha. Niz̈aza Jerusalén wajtchiz z̈oñinacaqui wajtquiztan ulanz waquizic̈ha. Niz̈aza joch yokquin z̈ejlñi z̈oñinacaqui ana wajtquin quejpsquiz waquizic̈ha, atipz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nii noojiqui Yoozqui Israel z̈oñinaca casticaquic̈ha. Casticz puntuquiztan tjapa Yooz tawk libruquiz cjijrtaqui cumplisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Ic maatakanacajay! ¡Wawa t'ichiñi maatakanacajay! Ancha ana wali sufraquic̈ha. ¡Tjapa tii yokquiz z̈ejlñi z̈oñinacajay! Anchaz̈ llact'azaquic̈ha, castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Z̈oñinacaqui quirquiz ticziz̈ cjequic̈ha. Yekjap z̈oñinacacazti tanz̈cu chjichtaz̈ cjequic̈ha yekja nacionquin. Niz̈aza yekja wajtchiz z̈oñinacaqui tii wajtchiz z̈oñinaca mantaquic̈ha, nii yekjanacz̈ timpu tucuzinz̈cama, niz̈aza Yooz munañpa timpucama. ");
INSERT INTO capNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‛Jalla nekztanaqui tjuñquizimi jiizquizimi warawarquizimi, jalla ninacz̈quiz siñalanaca wataquic̈ha. Niz̈aza pajk kot ljojkiz̈ kjawaquic̈ha. Jalla niz̈tiquiztan tii yokquiz z̈ejlñi z̈oñinacaqui walja tsucchi kuzziz cjequic̈ha, niz̈aza turwayz̈inta kuzziz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Arajpachquin z̈ejlñi kjananacami c̈hjekinskattaz̈ cjequic̈ha. Jalla nii cherz̈cu z̈oñinacaqui pinsaquic̈ha, tii muntu kjaz̈t wataquejo, jalla nii. Tii muntu tucuzinz tjewznaquic̈ha. Jalla niz̈ta watan z̈oñinacaqui tsucscukaz tismayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jalla nekztanaqui z̈oñinacaqui wejr, nii tsewtan cuchanz̈quita Yooz Zoñi, quejpz̈quiñi cheraquic̈ha. Walja kjancan wejt azi tjeez̈can tsjir taypiquiz tjonac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jalla niz̈ta anawalinaca wati kallantan, anc̈hucqui walja Yoozquin kuzziz cjee. Achamiz̈ wayta, tsewcchucc̈ha cherzna. Wajillaz̈ anc̈huca ultim liwriiz tjuñi tjonaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Niz̈aza Jesusaqui tii quintu quint'ichic̈ha tuz̈ cjican: —Higo muntiquiztan naazna; c̈hjul muntimi naazna. ");
INSERT INTO capNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Anc̈hucmi tsjii munti ch'ojñapachaz̈ c'ajan tuz̈ zizza, kjutunz timpu z̈catz̈inc̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jalla niz̈ta irataz̈ tii weriz̈ chiitanaca watan, anc̈hucqui tuz̈ zizaquic̈ha, Yooz mantiz tjuñi z̈catz̈inc̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","‛Tii razunal cjiwc̈ha. Ima tjapa tii timpuquiz kamñi z̈oñinacaz̈ ticznan, tjapa weriz̈ chiitanaca wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Arajpachami yokami tucuzinznaquic̈ha. Wejt takuzti anapanz̈ tucuzinznaquic̈ha, panz̈ cumplisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‛Anc̈hucqui persunpachquiz cwitaza. Anc̈hucqui anaz̈ turpi kuzziz cjee. Ana wali kamz cjen, niz̈aza licz cjen, niz̈aza tii wir cusasanacz̈quiz kuz tjaaz cjen, jalla nuz̈ cjen z̈oñinacaqui turpi kuzzizza. Ana zuma kaman Yooz tjonz tjuñi tiripintit anc̈huc tanaquic̈ha ");
INSERT INTO capNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","tsjii trampaqui tiripintitz̈ tanz̈a, jalla niz̈ta irataz̈ Yoozqui tii muntuquiz ana wali kamñi z̈oñinaca tiripintit tanaquic̈ha, casticzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Anc̈huczti listu tjaczi tjewzñi cjee. Zapuru anc̈hucqui Yoozquiztan azziz cjisjapa mayiza, tjapa watñi anawalinacquiztan atipzjapa, niz̈aza tsewctan cuchanz̈quita Yooz Z̈oñz̈ yujcquiz zuma prisintizjapa. ");
INSERT INTO capNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jalla nuz̈ tjaajinchic̈ha Jesusaqui. Majiñqui Jesusaqui timpluquiz tjaajnatc̈ha zapuru. Weenqui Olivos cjita curullquin z̈eli okatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tjapa z̈oñinacaqui wentan timpluquiz tjonatc̈ha Jesusiz̈ taku nonzñi. ");
INSERT INTO capNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jalla nekztanaqui ana liwaturchiz t'anta lujlz pjijsta irantiz̈catc̈ha. Nii pjijstaqui pascua cjitatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nii oraqui timplu jilirinacami lii tjaajiñi maestrunacami, “¿Jaknuz̈t Jesusa conas?” cjican kazzic̈ha. Pero ninacaqui parti z̈oñinaca walja ekscu, ana coni atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jalla nekztanaqui Satanás cjita zajraqui Judas kuzquiz luzzic̈ha. Judasqui Iscariote cjitazakaztac̈ha. Judasqui parti tuncapan illzta z̈oñinacz̈quiztan nekztantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judasqui timplu chawc jilirinacz̈tanami, timplu zultatz̈ jilirinacz̈tanami parli ojkchic̈ha. Ninacz̈tan zalz̈cu, parlichic̈ha, jaknuz̈t ninacz̈ kjarquiz Jesusa intirjas, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jalla nuz̈ Judas parlitiquiztan quintra z̈oñinacaqui ancha cuntintutac̈ha. Paaz tjaaz compromitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jalla niz̈tiquiztan Judasqui asiptichic̈ha, “Way” cjican. Nekztanaqui tantiya kallantichic̈ha, jaknuz̈t ana tama z̈oñi z̈elan Jesusa intirjas, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jalla nekztanaqui ana liwaturchiz t'anta lujlz pjijstaqui irantiz̈quichic̈ha. Nii pjijstiquiz tsjii uuzi wilana conspantac̈ha, pascua pjijsta paazjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nekztanaqui Jesusaqui pucultan niiz̈ tjaajintanaca cuchanchic̈ha. Pedruz̈tan Juanz̈tan ninacatac̈ha. Ima cuchancan ninacz̈quiz tuz̈ cjichic̈ha: —Anc̈hucquiz̈ oka, uc̈humnacaz̈ pascua c̈hjeri lujlzjapa, tjaczca. ");
INSERT INTO capNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nekztanaqui nii pucultan tjaajintanacaqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Jakziquin wejrnacqui c̈hjeri tjacznaquiya? ");
INSERT INTO capNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui watja luzcu, tsjii z̈oñz̈tan zalaquic̈ha kjaz luuz kuzzi. Nii z̈oñz̈ wirquiz apznaquic̈ha, jakziquin luzac̈haja, jalla nekz. ");
INSERT INTO capNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jalla nekz luzcu nii kjuychiz z̈oñz̈quiz paljayaquic̈ha, tuz̈ cjican: “Wejt Tjaajiñi cjic̈ha: ¿Jakziquin visitz kjuya z̈ejlya, wejt tjaajintanacz̈tan pascu c̈hjeri lujlzjapaya?” ");
INSERT INTO capNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nekztanaqui tsewcta pisuquiz tsjii pajk kjuya tjeeznaquic̈ha anc̈hucaquiz. Nii kjuya listu tjaczta cjequic̈ha. Jalla nekz c̈hjeri lujlz tjacznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jalla nekztanaqui nii pucultanaqui ojkchic̈ha. Nekztan Jesusiz̈ chiitacama watchic̈ha. Jaziqui nekziqui pascu c̈hjeri kissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pascu c̈hjeri lujlz ora cjen, Jesusaqui niiz̈ illzta z̈oñinacz̈tan misquiz julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jalla nuz̈ julz̈cu Jesusaqui ninacz̈quiz cjichic̈ha: —Wejrqui anc̈hucatan tii pascu pjijsta c̈hjeri lujlzjapa ancha pecchinpanc̈ha, ima ticzcan. ");
INSERT INTO capNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Anc̈hucaquiz cjiwc̈ha, anc̈hucatan ana iya tii pjijsta paac̈ha, c̈hjuloracamat Yooz ultimu tjapa mantac̈haja, jalla nii oracama. Nekztan tii pjijsta wilta paa-ac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jalla nekztanaqui Jesusaqui persun kjarz̈tan wasu tanzic̈ha. Nekztan Yooz Ejpz̈quin sparaquiz̈ cjichic̈ha. Nekztanaqui niiz̈ illztanacz̈quiz cjichic̈ha: —Tii wasu tanz̈na. Anc̈huccama tojz̈cuqui liczna. ");
INSERT INTO capNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Tekztan nawjkchuc wejrqui uwas kjazqui anal iya licac̈ha, c̈hjuloracamat Yooz tjapa mantac̈haja, niicama. ");
INSERT INTO capNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jalla nii licz̈cuqui, Jesusaqui persun kjarz̈tan t'anta tanzic̈ha. Nekztan Yooz Ejpz̈quin sparaquiz̈ cjichic̈ha. Nekztanaqui t'anta kjolz̈cu niiz̈ illztanacz̈quiz tjaachic̈ha, tuz̈ cjican: —Tiic̈ha wejt curpuz̈ cuntaqui. Tii wejt curpuqui intirjitaz̈ cjequic̈ha anc̈huca laycu. Niz̈aza wejr cjuñz̈cu, tii lujlznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nekztan c̈hjeri lujlz̈cu, wasu tanzic̈ha. Nekztan niiz̈ tuqui chiita taku irata chiichizakazza, tuz̈ cjican: —Wejt ljocqui anc̈huca laycu tjawktaz̈ cjequic̈ha. Wejt ljocz̈tan ew z̈ejtz kamaña ut'aytaz̈ cjequic̈ha. Tii wazuquiztan liczqui wejt ljoc cuntiquiztanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","‛Wejt quintra tarasunñi z̈oñiqui wejttan chicapachac̈ha tii misquiz. ");
INSERT INTO capNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Wejrqui Yooz Epiz̈ munañpi jaru jalla nii kamañ jiczquiz okac̈ha. Wejt quintra tarasunñi z̈oñz̈quizzti anawaliz̈ cjisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jalla nuz̈ chiitiquiztan tjaajinta z̈oñinacaqui ninacpora pewcsassic̈ha: —¿Jequit wejrnacquiztan nii tarasunñi z̈oñi cjes? —Nuz̈ cjican ninacpora pewcsassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jalla niiz̈ wiruñaqui nii tjaajintanacaqui ch'aassic̈ha, ject tucquin naazi cjeequi, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesusaqui ninacz̈quiz cjichic̈ha: —Chawc jilirinacaqui persun wajtchiz z̈oñinaca mantiñic̈ha anawal patrunaz̈takaz. Niz̈aza nii jilirinacaqui mantita z̈oñinacz̈quiz jilirz̈ honorakaz waytiskatc̈ha, “walipan paac̈ha tii jiliriqui”, cjican. ");
INSERT INTO capNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Anc̈huczti anaz̈ niz̈ta paaz waquizic̈ha. Antiz anc̈hucqui tiz̈ta paaz waquizic̈ha. Jakziltat tsjan chawc jiliriz̈laj niiqui, tjowaz̈takaz cjis waquizic̈ha. Niz̈aza jakziltat mantiñiz̈laj niiqui, piyunaz̈takaz cjis waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","¿Ject tucquin chekan z̈oñejo? ¿Misquiz julzñi z̈oñej chekanaqui? Uz̈ ¿nii misquiz atintiñi z̈oñej, jaa? Tii razunal cjiwc̈ha: Misquiz julzñi z̈oñic̈ha tucquin chekanaqui. Jalla nuz̈ cjenami wejrqui anc̈hucaporquiz atintiñi z̈oñiz̈takaztc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‛Anc̈hucqui wejttan chica z̈ejlchinc̈hucpanc̈ha wejtquiz anawali watanami. Wejtquiztan ana zarakchinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jalla niz̈tiquiztan wejrqui anc̈huc uchac̈ha, mantiñi jilirinaca cjisjapa. Jaknuz̈t wejt Yooz Ejpqui mantiñi jiliri cjisjapa wejr utc̈haja, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Jalla nuz̈ cjen anc̈hucqui arajpach wajtquin wejttan chica z̈elaquic̈ha, niz̈aza wejttan chica lujlznaquic̈ha. Niz̈aza nekziqui wejttan chica jilirz̈ sillquiz julznaquic̈ha tuncapan Israel t'akquiz z̈oninaca pjalzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nekztan Jesusaqui cjichic̈ha: —Simona, Simona, tiim zizaquic̈ha amqui. Satanasqui am pecc̈ha, niiz̈ parti cjiskatzjapa. Trigoz̈takaz layinz pecc̈ha, ujquiz tjojtskatzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simona, am laycu tjurt'iz̈inchinc̈ha ana juc'anti upa kuzziz cjeyajo. Amqui Yoozquin tjapa kuztan quejpz̈cu am jilanaca yanapaquic̈ha tjup kuzziz tjurt'ajo. ");
INSERT INTO capNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nekztanaqui Simonaqui cjichic̈ha: —Wejt Jiliri, wejrqui listuc̈ha amtan chica ojkzjapa; carsilquizimi lusasac̈ha; nizaza amtan chicapachami ticsnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jalla nuz̈ chiitiquiztanaqui Jesusaqui cjichic̈ha: —Pedro, amquiz chiyuc̈ha, ima wallpaz̈ kjawan, amqui wejt puntuquiztan nicaquic̈ha. C̈hjep wilta wejr ana pajñim chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jalla nekztanaqui Jesusaqui paljaychic̈ha, tuz̈ cjican: —Tuquiqui wejrqui anc̈huc cuchanchinc̈ha ana quelzziz, niz̈aza ana paazziz, niz̈aza ana yekjat c̈hjatchiz. Jalla nuz̈ okan ¿anc̈hucaquiz c̈hjulut pjaltichiya? Nekztanaqui ninacaqui kjaazic̈ha: —Anaz̈ c̈hjulumi pjaltichic̈ha, —cjican. ");
INSERT INTO capNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Anziqui jakziltat quelzziz cjec̈haja, nii quelzqui chjicha. Niz̈aza jakziltat paazziz cjec̈haja, nii paazqui chjicha. Jakziltat ana armichiz z̈ejlc̈haja, persun chaquita tuyz̈la, arma kjayz̈japa. ");
INSERT INTO capNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Anc̈hucaquiz chiyuc̈ha. Wejt puntuquiztanaqui Yooz takuqui tuz̈ cjic̈ha: “Castictaz̈ cjequic̈ha anawal z̈oñinacz̈tan chica”. Wejt persunquiz cumplistanc̈ha nii cjijrta Yooz takuqui. Niz̈aza tjapa cjijrta Yooz takuqui wejt puntuquiztan cumplistanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jalla nekztanaqui ninacaqui cjichic̈ha: —Wejt Jiliri, tekzi pizc arma z̈ejlc̈ha. Jesusaqui kjaazic̈ha: —Nuz̈quizka cjila, —cjican. ");
INSERT INTO capNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jalla nekztanaqui Jesusaqui ulanchic̈ha. Olivos cjita curullquin ojkchic̈ha, jalla nicju ojkñipantac̈ha. Tjaajinta z̈oñinacaqui Jesusiz̈quiz apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Olivos cjita curulla irantiz̈cu, Jesusaqui cjichic̈ha: —Yooz Ejpz̈quin mayiza ana ujquiz tjojtsjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nekztanaqui Jesusaqui niiz̈ tjaajintanacz̈quiztan z̈oñiz̈ maz c̈hjacta, jalla nuz̈ullquin ojkchic̈ha. Jalla nicju quillsic̈ha Yooz Ejpz̈quin mayizizjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Mayizican cjichic̈ha: —Yooz Tata, amqui munaquiz̈ niiqui, wejr liwriyalla tii sufrisquiztan. Pero anal wejt kuzcama ojkz pecuc̈ha. Jaknuz̈ am kuz munc̈haja, jalla niicama ojkz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jalla nii oraqui arajpachquiztan tsjii Yooz Epiz̈ cuchanz̈quita anjilaqui jecz̈quichic̈ha, Jesusa azi tjaazjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesusaqui jalla nuz̈ ancha llact'azcan, tjapa aztan Yoozquin mayizatc̈ha. Jalla nuz̈ mayizan ancha pjalñi pjatzic̈ha ljocz̈takaz c̈hjujatc̈ha yok kjutñi. ");
INSERT INTO capNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yoozquin mayiziz z̈erz̈cu, tsijtsic̈ha Jesusaqui. Nekztanaqui niiz̈ tjaajintanacz̈quiz quejpchic̈ha. Ninaca llaquizinpantiz̈ tjajatc̈ha. Nuz̈ cjen Jesusaqui tjajñi zalchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jalla nekztanaqui Jesusaqui cjichic̈ha: —¿Anc̈hucqui kjaz̈tiquiztan tjaj-jo? Z̈aazna, Yoozquin mayiza ana ujquiz tjojtsjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesusaz̈ ima parla z̈erznan, walja z̈oñinaca tjonchic̈ha. Judas cjita z̈oñiqui tucquinpan tjonchic̈ha. Judasqui nii tuncapan illzta z̈oñinacz̈ partiquiztantac̈ha. Nekztan Jesusiz̈quin macjatchic̈ha chjulzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesusaqui Judasquiz cjichic̈ha: —Judas, ¿wejr tsjii chjulz̈cum amqui tarazunaquiya? Wejrtc̈ha Yooz cuchanz̈quita z̈oñtqui. ");
INSERT INTO capNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesusiz̈tan z̈ejlñi z̈oñinacaqui jalla niz̈ta cherz̈cu, pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿cuchillu armiz̈tan tjurt'aquiya? ");
INSERT INTO capNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Tsjii nii tjaajintanacz̈quiztan timplu jilirz̈ piyuna c̈hjojritchic̈ha, z̈ew cjuñi chjajtz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesusaqui cjichic̈ha: —Nuz̈quizkaz cjee. Armiz̈tan ana iya tjurt'aquic̈ha. Nekztanaqui nii orapacha Jesusaqui nii piyunz̈ cjuñi lanz̈cu c̈hjetinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Timplu chawc jilirinacami niz̈aza timplu zultatz̈ jilirinacami, niz̈aza wajt jilirinacami, jalla ninacami Jesusa preso chjichi tjonchic̈ha. Ninacz̈quiz paljaychic̈ha Jesusaqui, tuz̈ cjican: —¿Kjaz̈tiquiztan anc̈hucqui cuchillu armiz̈tan, niz̈aza tuñz̈tan tjonchinc̈hucta, wejr tanzjapaya? ¿Wejrqui tjañ z̈oñtkaya? ");
INSERT INTO capNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Zapuru timpluquiz kamchinc̈ha anc̈hucatan chica. Nii oraqui wejr ana kjaz̈ cjichinc̈hucc̈ha. Pero anzic̈ha anc̈huca tanz oraqui. Tii orakaz zumchiquiz kamñinacaqui mantasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jalla nekztanaqui z̈oñinacaqui Jesusa preso tanchic̈ha. Tanz̈cu timplu chawc jilirz̈ kjuya chjitchic̈ha. Pedruqui az̈kquiztanalla apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jalla nii jilirz̈ kjuy patio taypiquiz tsjii uj luminaru taazic̈ha. Z̈oñinacaqui uj muytata julzi z̈elatc̈ha. Niz̈aza Pedruqui ninacz̈tan chica julzi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jalla nuz̈ uj kjanquiz julzi z̈elan, tsjaa piyun z̈onqui Pedro z̈ejlñi cherchinc̈ha. Nekztan naaqui cjichinc̈ha: —Tii z̈oñiqui nii z̈oñz̈tan chica ojklayñitala, niiz̈ tiic, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pedruzti nuz̈ cjitiquiztan nicchic̈ha, tuz̈ cjican: —Cullaca, nii z̈oñi anal pajuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jalla niiz̈ wiruñpacha, tsjiizuñ Pedro cherchizakazza. Jalla nuz̈ cherz̈cu, cjichic̈ha: —Amqui nii parti z̈oñimla. Nekztanaqui Pedruqui kjaazic̈ha; tuz̈ cjican: —Anapanc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tsjii orquiztanaqui yekja z̈oñiqui paljaychizakazza, tuz̈ cjican: —Ultim werara, tii z̈oñiqui nii z̈oñz̈tan chica ojklayñipantala. Tiiqui Galilea wajtchiz z̈oñizakazla. ");
INSERT INTO capNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jalla nekztanaqui Pedruqui cjichic̈ha: —Jila, c̈hjulukam niz̈ta chiic̈hani, anal zizuc̈ha. Jalla nuz̈ chiyan nii orapachaqui tsjii wallpi jora kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jalla nuz̈ wallpi jora kjawan, Jesusaqui Pedruz̈ kjutñi kjutz̈cu cherz̈quichic̈ha. Jalla niz̈tiquiztan Pedruqui, Jesús Jilirz̈ tuqui chiita cjuñzic̈ha. Tuquiqui Jesusaqui cjichic̈ha: “Ima wallpaz̈ kjawan, amqui wejt puntuquiztan nicaquic̈ha. C̈hjep wilta wejr ana pajñim chiyaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jalla nuz̈ watz̈cu, Pedruqui ulanchic̈ha. Nuz̈ ulanz̈cu ancha kaachic̈ha, Jesusa ana pajñi chiiz̈cu. ");
INSERT INTO capNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesusa itzñi z̈oñinacaqui walja iñarchic̈ha. Niz̈aza Jesusa wjajtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Niz̈aza Jesusiz̈ c̈hjujcqui chawjcz̈inz̈cu yujcquiz kijtchic̈ha, tuz̈ cjican: —¡Tantiyalla! ¿Ject am kijchjo? ");
INSERT INTO capNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Niz̈aza niiz̈ quintra c̈hjul anawalinacami chiichic̈ha, nuz̈ iñarchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tjuñiz̈ tjewctanalla, tjapa judío jilirinacaqui juntassic̈ha, wajt jilirinacami, timplu jilirinacami, lii tjaajiñinacami, jalla ninacami. Jalla nekztanaqui Jesusa chawjc parliz kjuya chjitchic̈ha. Nicju ajczi jilirinacz̈quin apantichic̈ha. Nekztan jilirinacaqui niiz̈quiz pecunchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Jaziqui am chiya, ¿ampanim Cristumpanikaya? Jesusaqui kjaazic̈ha, tuz̈ cjican: —Wejrqui “jesalla” cjez̈ niiqui, anaz̈ wejr criyaquiz̈ anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Niz̈aza wejrqui anc̈hucaquiz pewcznaz̈ niiqui, anaz̈ wejr werara kjaazta cjeec̈ha. Niz̈aza wejr anaz̈ cujtznaquic̈ha ");
INSERT INTO capNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Tekztanpacha wejrqui tjapa azziz Yooz Ejpz̈ z̈ew latuquiz julzil cjeec̈ha. —Jalla nuz̈ kjaazic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jalla nekztanaqui tjapa nii z̈ejlñi z̈oñinacaqui pecunchic̈ha, tuz̈ cjican: —¿Am Yooz Majchimpanikaya? Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Wejrpanc̈ha, anc̈hucz̈ pecunc̈ha, jalla nuz̈upanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jalla nekztanaqui ninacaqui cjichic̈ha: —¿C̈hjul juc'antiz̈ tisticu tumpasajo? Uc̈humpachala niiz̈ persun ata chiiñi nonztaqui, ana wali chiichic̈ha, “Yooz Majchc̈ha wejrqui” cjican. ");
INSERT INTO capNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jalla nekztanaqui tjapa nii z̈ejlñi jilirinacaqui tsijtsic̈ha. Nekztanaqui Jesusa chjitchic̈ha Pilato cjita jilirz̈quin. ");
INSERT INTO capNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Jalla nicju uj tjojtñi kallantichic̈ha, tuz̈ cjican: —Wejrnacqui tii z̈oñi wajtchinc̈ha, tii wajtchiz z̈oñinacz̈quiz anawaliz̈ aptjapcan zelatc̈ha. Jalla nuz̈ wajtchinc̈ha. Tii z̈oñizakaz cjic̈ha: “Uc̈humqui Romanz̈ jilirz̈ tasa ana tjaaz waquizic̈ha” jalla nuz̈ cjic̈ha tiiqui. Niz̈aza cjic̈ha, “Wejrtc̈ha Yooz cuchanz̈quita Cristutqui”. Nuz̈ cjican, cjic̈ha, “Wejrtc̈ha chawc jiliritqui”. ");
INSERT INTO capNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jalla nekztanaqui Pilato cjita jiliriqui tuz̈ pewczic̈ha: —¿Judío wajtchiz z̈oñinacz̈ chawc jilirim amya? Nekztan Jesusaqui kjaazic̈ha, tuz̈ cjican: —Jalla nuz̈upanc̈ha, am nuz̈ chiita, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nekztanaqui Pilatuqui timplu chawc jilirinacz̈quiz, niz̈aza z̈ejlñi z̈oñinacz̈quiz cjichic̈ha: —Anal tii z̈oñz̈quiz c̈hjul ujmi wac̈huc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nii z̈oñinacazti ancha ujquiz tjojtskatz pecatc̈ha. Jalla niz̈tiquiztan cjichic̈ha: —Tii z̈oñiqui niiz̈ tjaajintiz̈tan waljaz̈ tjojktila tjapa Judea yokquin z̈ejlñi z̈oñinacaqui. Primiraqui Galilea yokquinz̈ niz̈ta paatc̈ha tiiqui. Jaziqui tekzi niz̈tazakaz paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jalla nuz̈ nonz̈cu, Pilatuqui pewczic̈ha, tuz̈ cjican: —¿Tiiqui Galilea yokchiz z̈oñikaya? ");
INSERT INTO capNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Jesalla” cjican kjaaztan, Pilatuqui Herodes cjita Galilea chawc jilirz̈quin nii Jesusa cuchanchic̈ha. Herodesqui Jerusalén wajtquiz z̈elatc̈ha nii ora. ");
INSERT INTO capNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jesusa cherz̈cuqui Herodesaqui ancha cuntintutac̈ha. Walja niiz̈ puntuquiztan quintunaca nonchic̈ha. Jalla niz̈tiquiztan az̈kanaca Jesusiz̈tan zalz pecatc̈ha. Jesusa milajru paañi cherz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodesaqui walja pewcñi kallantichic̈ha. Pero Jesusazti ana kjaazñi z̈ejlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jalla nicju zakaz timplu jilirinacami lii tjaajiñinacami chicapacha z̈elatc̈ha. Ninacaqui walja Jesusiz̈ quintra chiichic̈ha, uj tjojtunzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodesaqui zultatunacz̈tan Jesusa iñarchic̈ha. Burla paachic̈ha. Zultatunacaqui Jesusiz̈quiz chawc jilirz̈ punchu tjutzic̈ha. Jalla nekztanaqui Herodesaqui wilta Pilatuz̈quin cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nii oraqui Herodestan Pilatuz̈tan amigo pajassitac̈ha. Niiz̈ tuquiqui quintratac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jalla nekztanaqui Pilatuqui juntjapchic̈ha timplu jilirinacami wajt jilirinacami, niz̈aza z̈oñinacami. ");
INSERT INTO capNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Juntjapz̈cu, cjichic̈ha: —Anc̈hucqui wejtquiz tii z̈oñi zjijcchinc̈hucc̈ha, tuz̈ cjican: “Tii zoñiqui z̈oñinacaz̈ aptjapñicha”. Nekztanaqui anc̈huca yujcquiz tiiz̈quiz pecunchinla. Jalla nuz̈ pecuntiquiztan tii z̈oñz̈ ujqui ana watchinpanla, anchucaz̈ tii z̈oñz̈quiz uj tjojtuntiquiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesaqui niz̈azakaz ana c̈hjul ujmi watchic̈ha. Jalla niz̈tiquiztan wilta wejtquin cuchanz̈quitac̈ha. Ziza anc̈hucqui, tii z̈oñiqui anapanz̈ ticz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Jaziqui cunkal casticac̈ha, nekztanaqui cutsnac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Nii pjijstiquiz cjenaqui Pilat jiliriqui cuzturumpichiztac̈ha, tsjii pres z̈oñi liwrii cuts, jalla nii. Nii cuzturumpi paañitac̈ha z̈oñinacz̈ kuz wali cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jalla nuz̈ Pilatuz̈ chiitiquiztanaqui tjappacha nii z̈oñinacaqui kjawi kallantichic̈ha, tuz̈ cjican: —¡Panz̈ chjichla tiiqui! ¡Antiz Barrabás cutsla! ");
INSERT INTO capNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jalla nii Barrabasqui carsilquiz chawctatac̈ha, nii wajtquin jilirz̈ quintra z̈oñinaca aptjaptkalc̈ha, y niz̈aza z̈oñiz̈ contkalc̈ha. Jalla niz̈tiquiztan carsilquiz chawjctatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatuqui Jesusa cuts peccan z̈oñinacz̈quiz wilta paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Nii z̈oñinacazti juc'anti altu jorz̈tan kjawchic̈ha, tuz̈ cjican: —¡Cruzquiz ch'awczna! ¡Cruzquiz ch'awczna! ");
INSERT INTO capNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","C̈hjep wiltiquiz Pilatuqui paljaychic̈ha tuz̈ cjican. —Tii z̈oñi, ¿c̈hjul anawali paachejo? ¡Wejrqui tii z̈oñz̈ uj ana wachula! ¡Anaz̈ ticz waquizic̈ha tiiqui! ¡Jaziqui cunkal casticac̈ha, nekztanac cutsnac̈ha! ");
INSERT INTO capNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero nii z̈oñinacazti juc'anti kjawchic̈ha, “Cruzquiz ch'awczna” cjican. Timplu jilirinacami z̈oñinacami ancha kjawchic̈ha, Pilatuz̈ kuz atipscama. ");
INSERT INTO capNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jalla nuz̈ kjawtiquiztan Pilatuqui ninacz̈ kuzcama paachic̈ha. Jesusa cruzquiz ch'awczcajo mantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Niz̈aza Pilatuqui Barrabás cjita z̈oñi cutzic̈ha z̈oñinacz̈ kuzcama. Nii Barrabasqui carsilquiztac̈ha, jilirz̈ quintra z̈oñinaca aptjaptiquiztan, niz̈aza z̈oñi contiquiztan. Pilatuqui Jesusa intirjichic̈ha nii z̈oñinacz̈ kuzcama wali cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jalla nekztanaqui zultatunacaqui Jesusa chjitchic̈ha, cruzquiz ch'awczjapa. Jalla nuz̈ chjichan tsjii z̈oñi tanzic̈ha cruza tjuzjapa. Nii z̈oñiqui Cirene wajtchiztac̈ha, Simona cjitatac̈ha. Jochquiztan tjonatc̈ha. Jalla nuz̈ Simona tanz̈cu zultatunacaqui Jesusiz̈ cruza tjuzzic̈ha. Nekztan Jesusiz̈ wirquiz ojkkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Walja z̈oñinacaqui apznatc̈ha. Walja maatakanaca kaacan kjawcan ancha llaquita apzicha. ");
INSERT INTO capNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero Jesusaqui maatakanacz̈quiz cherz̈cu paljaychic̈ha, tuz̈ cjican: —Jerusalén wajtchiz maatakanaca, wejtquiztan ana kaa. Anc̈huca persunjapa niz̈aza anc̈huca maatinacz̈quiztan kaa. ");
INSERT INTO capNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Tsjii ora tjonaquic̈ha. Nii oraqui z̈oñinacaqui sufris cjen chiyaquic̈ha, “Ana majtñi maatakanacaqui cuntintuz̈ cjequic̈ha. Niz̈aza anaz̈ icchi maatakanacaqui cuntintuz̈ cjequic̈ha. Niz̈aza anaz̈ piz t'ichiñi maatakanacaqui cuntintuz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nii ora zakaz z̈oñinacaqui walja sufris cjen curunacz̈quiz paljayaquic̈ha, tuz̈ cjican: “Wejtnac juntuñ tjojtz̈ca”. Niz̈aza lumanacz̈quiz cjequic̈ha, “Wejrnacz̈ chjojsna, tsjii tjatta cunta”. ");
INSERT INTO capNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tsjii ch'ojñi muntiquiz tiz̈ta paaquiz̈ niiqui, kjoñ muntiquiz juc'ant ana wali paaquic̈ha. —Jalla nuz̈ paljaychic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Zultatunacaqui pucultan tjañinaca cruzquiz ch'awczjapa chjitchic̈ha Jesusiz̈tan chica. ");
INSERT INTO capNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Calavera cjita yoka irantiz̈cu, Jesusa cruzquiz ch'awcchic̈ha. Niz̈aza nii pucultan tjañinaca cruzquiz ch'awctazakaztac̈ha, tsjii tjañizti z̈ew latuquiztan, tsjii tjañizti zkar latuquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Cruzquiz ch'awctan, Jesusaqui cjichic̈ha: —Yooz Tatay, tii z̈oñinaca pertuna, c̈hjulut paac̈haja, anaz̈ intintic̈ha ninacaqui. Nii ora zultatunacaqui Jesusiz̈ zquiti tanzjapa, zurtiyassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jalla nekzi z̈oñinacaqui walja chekznatc̈ha. Jilirinacami ancha burla paachic̈ha, tuz̈ cjican: —Tiiqui yekjanaca liwriichic̈ha. Ultim werar Cristumc̈halaj niiqui, Yooziz̈ illztamc̈halaj niiqui, persunpacha liwriyalla. ");
INSERT INTO capNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Niz̈aza zultatunacaqui burla paachic̈ha. Macjatz̈cu jar vinu tirinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Niz̈aza cjichic̈ha: —Amqui judionacz̈ chawc jilirimc̈halaj, niiqui, persunpacha liwriyalla. ");
INSERT INTO capNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Niz̈aza cruzquiz Jesusiz̈ ach juntuñ litranaca cjijrtatac̈ha. C̈hjep tawkquiztan cjijrtatac̈ha, griego taku, latín taku, hebreo taku. Jalla tuz̈ cjijrtatac̈ha: “Tiic̈ha judionacz̈ chawc jiliriqui”. ");
INSERT INTO capNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tsjii ch'awcta tjañi z̈oñiqui Jesusiz̈quiz ana wal taku chiichic̈ha, tuz̈ cjican: —Amqui Cristumc̈halaj niiqui, persunpacha liwriyalla. Niz̈aza wejrnacmiz̈ liwriya. ");
INSERT INTO capNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Tsjii ch'awcta tjañizti nii tjañ mazquiz ujzic̈ha, tuz̈ cjican: —Amqui cruzquiz ch'awctazakazza. ¿Am anam Yooz eks, kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Uc̈humqui ujquiztan sufristanc̈ha. Cruzquiz ch'awcta cjispanz waquizic̈ha. Tii z̈oñizti ana c̈hjul ujchizza. ");
INSERT INTO capNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nekztan nii tsjii tjañ z̈oñiqui Jesusiz̈quiz paljaychic̈ha, tuz̈ cjican: —Jesusa, c̈hjulorat amqui mantiz kallantac̈haja, jalla nii ora wejr cjuñznalla. ");
INSERT INTO capNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —Weraral amquiz cjiwc̈ha, tonjtanpacha amqui wejttan chica cjequic̈ha, Paraíso cjita zuma yokquinaqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Nii oraqui taypuruz̈ cjisnatc̈ha. Tjapa nii yokaqui zumchi cjissic̈ha, majñakak oracama. ");
INSERT INTO capNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Tjuñiqui zumchi cjissizakazza. Niz̈aza pajk timplu cortina chicata wjajrzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jalla nekztanaqui Jesusaqui altu jorz̈tan kjawchic̈ha, tuz̈ cjican: —Yooz Tatay, am kjarquiz wejt animu cumpjiyuc̈ha. Jalla nuz̈ chiiz̈cu, ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jalla nuz̈ watchi cherz̈cu tsjii romanz̈ zultat jiliriqui Yooz honora paljaychic̈ha, tuz̈ cjican: —¡Ultim weraratakalc̈ha, tiiqui lijitum z̈oñitakalc̈ha! Ana ujchiztakalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Niz̈aza nuz̈ watchi cherz̈cu tjapa nii cherñi z̈oñinacaqui ancha llaquita ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesusiz̈ mazinacami niz̈aza nii Jesusa Galilea wajtquiztan apzi maatakanacami az̈kquiztan chekzcan quirchic̈ha. Tsijtscukaz cheksic̈ha nii watñiqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tsjii zuma z̈oñi z̈elatc̈ha José cjita. Yooz mantitacama kamñitac̈ha. Judea yokquin Arimatea wajtchiz z̈oñitac̈ha. Judiuz̈ jilirinacz̈ partitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nii zuma Josequi Yooz mantiz tjuñiz̈ tjewsñipantac̈ha. Niz̈aza niiqui anatac̈ha Jesusa conz kuzzizqui parti jilirinacz̈tanaqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nekztan Pilatuz̈quin ojkchic̈ha Jesusiz̈ curpu mayi. ");
INSERT INTO capNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nekztanaqui Josequi Jesusiz̈ curpu cruzquiztan apakz̈cu tsjii wali pajk pañuz̈tan capzic̈ha. Nekztanaqui sipulturquiz tjatzic̈ha. Nii sipulturuqui wali pajk mazquiz pjettatakalc̈ha. Anatakalc̈ha yekja almami tjatta niiqui. ");
INSERT INTO capNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jeejz tjuñi z̈catz̈intiquiztan, z̈oñinacaqui tjacznatc̈ha jeejz tjuñquiz z̈ejlzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nii Galilea yokquiztan Jesusiz̈tan chica tjonchi maatakaqui Juzquiz apzic̈ha, Jesusiz̈ sipulturu cheri, jaknuz̈t tjatz̈taz̈laja, nii cheri. ");
INSERT INTO capNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jalla nekztanaqui persun kjuya quejpz̈cu, zuma ulurchiz aceitenaca niz̈aza tjajlinz cremanaca jalla nii tjaczic̈ha. Nekztanaqui jeejz tjuñquiziqui jeejzic̈ha, judiuz̈ lii jaru. ");
INSERT INTO capNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tumincuqui simana kalltiznan maatakanacaqui Jesusiz̈ sipultura ojkchic̈ha walja wentan. Tjaczta ulurchiz aceitenaca chjitchic̈ha, Jesusiz̈ curpu tjajlinzjapa. Jalla nuz̈ okan yekja maatakanacaqui cumpant'ichizakazza. ");
INSERT INTO capNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jalla nicju irantiz̈cu nii sipulturu pjucz̈ta mazqui cjetz̈ta cherzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nekztanaqui sipulturquiz luzzic̈ha. Pero Jesusiz̈ curpuqui ana wajtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Jalla niz̈tiquiztan ninacz̈ kuz turwayskatatc̈ha. Ana jaknuz̈quin zizi atchic̈ha, c̈hjulu paachuca, jalla nii. Nuz̈ z̈elan pucultan luctak z̈oñiz̈takaz tsijtsi cherzic̈ha. Ninacz̈ zquiti walja llijatc̈ha. Maatakanacz̈tan chica cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jalla nuz̈ cherz̈cu walja tsucchic̈ha maatakanacaqui. Tuzi t'okzic̈ha. Jalla nuz̈ cjen pucultan luctakaz̈takaz anjilaqui chiiz̈inchic̈ha maatakz̈quiz, tuz̈ cjican: —¿Kjaz̈tiquiztam anc̈hucqui ticzinacporquiz z̈ejtñi z̈oñi kjurjo? ");
INSERT INTO capNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Anaz̈ tekz z̈ejlc̈ha niiqui. Jacatatchic̈ha niiqui. Anc̈hucz̈ cjuñzna, Galilea yokquiz ojklayan Jesusaqui niz̈ta mazinchipanla, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nicju Jesusaqui mazinchic̈ha, “Yooz Epiz̈ cuchanz̈quita Z̈oñtc̈ha wejrqui. Ujchiz z̈oñinacz̈ kjarquiz intirjital cjeec̈ha. Niz̈aza cruzquiz ch'awcz̈cu contal cjeec̈ha. Pero c̈hjep majquiztanaqui jacatatac̈ha”. Jalla nuz̈ Jesusaqui mazinchitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jalla nuz̈ chiyan maatakanacaqui cjuñzic̈ha Jesusiz̈ mazintanaca. ");
INSERT INTO capNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jalla nekztanaqui sipulturquiztan quejpz̈cu, tjappacha quint'ichic̈ha niiz̈ tuncamani illzta z̈oñinacz̈quiz, niz̈aza tjapa nekz z̈ejlñi z̈oñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jalla nii quint'iñi maatakanacaqui tiz̈ta tjuuchiztac̈ha: María Magdalenatac̈ha, Juanatac̈ha, Jacobuz̈ maatac̈ha Mariiqui, niz̈aza tsjii kjaz̈ yekja maatakanacatac̈ha. Jalla ninacaqui Jesusiz̈ illzta z̈oñinacz̈quiz quint'ichic̈ha, jaknuz̈t watchi, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jalla nii maatakanacz̈ quint'ita anapan criichic̈ha Jesusiz̈ illzta z̈oñinacaqui. —¿C̈hjulukat lucurataz̈takaz chiic̈hani nii maatakanacaqui? —jalla nuz̈ cjichic̈ha Jesusiz̈ illzta z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jalla nuz̈ ana criiz̈cumi Pedruqui ulanz̈cu sipulturu cherzñi zajtchic̈ha. Colz̈cu sipulturu kjuylchuc cherzic̈ha. Nii capz̈ta pañunaca tsjii latu chjojkz̈ta z̈elatc̈ha. Jalla nii cherz̈cu, walja kuzquiz pinsican ojkchic̈ha, c̈hjulut watc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nii noojpacha pucultan Jesusiz̈ tjaajinta z̈oñinacaqui Emaús cjita watjaz̈ okatc̈ha. Emaús watjaqui tsjii tuncaman kilometrotac̈ha Jerusalén wajtquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jiczquiz ojkcan, ninacpora parlassatc̈ha, tjapa Jesusiz̈ puntu watchinaca, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nuz̈ parlasan, Jesusapachac̈ha z̈catz̈inz̈quichi. Nekztan ninacz̈tan chica ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesusiz̈tan chica ojkcanami, nii pucultanaqui anapan pajñi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jalla nekztanaqui Jesusaqui ninacz̈quiz pewczic̈ha, tuz̈ cjican: —Jiczquiz ojkcan, ¿c̈hjul puntu anc̈hucqui parlasjo? ¿Kjaz̈tiquiztan llaquita anc̈huc ojkjo? ");
INSERT INTO capNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tsjiizuñqui Cleofás cjitatac̈ha. Jalla niiqui kjaazic̈ha, tuz̈ cjican: —Tjapa z̈oñinacaqui Jerusalén wajtquiz wajtchi quintu zizza. Am nekz z̈ejlcan, ¿nii watchinaca anam ziz, jaa? ");
INSERT INTO capNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nekztanaqui Jesusaqui kjaazic̈ha, tuz̈ cjican: —¿C̈hjulu watchitaya? Nekztanaqui nii pucultanaqui cjichic̈ha: —Tii quintu z̈ejlc̈ha. Tsjii Jesusa cjita z̈oñi z̈elatc̈ha, Nazaret wajtchiz z̈oñi. Yooz taku paljayñi profetatac̈ha niiqui. Yooz Ejpz̈ yujcquizimi z̈oñinacz̈ yujcquizimi walja Yooz aztan milajrunaca paachic̈ha. Niz̈aza Yooz taku zumapan parlichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jalla nekztanaqui uc̈hum timplu jilirinacami uc̈hum wajt jilirinacami nii Jesusa intirjichic̈ha cruzquiz ch'awczjapa, conzjapa. ");
INSERT INTO capNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wejrnacqui cjetuc̈ha, “Niiqui Israel wajtchiz z̈oñinaca liwriyaa” cjichintac̈ha. Niz̈aza tonjtanpacha c̈hjep majc̈ha, tiz̈ta watchiqui. ");
INSERT INTO capNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","Wejtnacaquiztan tsjii kjaz̈ maatakanacaqui wentan Jesusiz̈ sipulturu cherzñi ojkchic̈ha. Jalla nekztanac “Jesusiz̈ curpu ana z̈ejlcha” cjican tjonchic̈ha. Tjonz̈cu quint'ichic̈ha, tiz̈ta. Sipulturquin anjilanaca chertkalc̈ha. Anjilanacaqui cjitkalc̈ha “Jesusaqui vivo z̈ejtchic̈ha” cjican. Jalla nuz̈ quint'itkalc̈ha maatakanacaqui. Jalla nuz̈ quint'itiquiztan tsucchinc̈ha wejrnacqui. ");
INSERT INTO capNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jalla nii quintu nonz̈cu tsjii kjaz̈t wejtnaca mazinacaqui sipulturu cherzñi ojkchic̈ha. Nii maatakaz̈ quint'ita, jalla niz̈tapacha cherzic̈ha. Pero Jesusa ana cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Ancha ana intintiñi anc̈hucqui. ¿Kjaz̈tatajo? ¡Ancha ch'aman criichinc̈hucc̈ha tjapa Yooz taku paljayñi profetanacz̈ cjijrtaqui! ");
INSERT INTO capNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ima honorchiz mantican, Cristuqui nuz̈ sufrispantaz̈ niic, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jalla nekztanaqui Jesusaqui ninacz̈quiz tjaajñi kallantichic̈ha, tjapa cjijrta Yooz takunaca niiz̈ puntuquiztan, jalla nii. Tjaajincan, Moisés cjijrta libruquiztan kallantichic̈ha. Niz̈aza tjappacha Yooz taku paljayñi profetanacz̈ libruquiztan tjaajinchic̈ha niiz̈ persun puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jalla nekztanaqui jakziquin ojktc̈haja, jalla nicju irantitan, Jesusaqui tira wajtz cjichitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nii pucultan z̈oñinacaqui Jesusiz̈quiz rocatc̈ha, tuz̈ cjican: —Wejtnacatan z̈ela. Tjuñi zezillaz̈ cjissa, joz zumc̈ha. Nekztanaqui Jesusaqui ninacz̈tan chica tsjii kjuyquiz z̈eli luzzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nekztanaqui tjapa ninacaqui misquiz julzic̈ha. Nuz̈ julz̈cu Jesusaqui t'anta tanzic̈ha niiz̈ kjarz̈tan. Nekztanaqui Yooz Ejpz̈quin sparaquiz̈ cjichic̈ha. Nekztan ninacz̈quiz tojzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nuz̈ paan nii pucultan z̈oñinacaqui Jesusa pajñiz̈ cjissic̈ha, c̈hjujqui cjetz̈intaz̈takaz. Pero nii orapacha Jesusaqui liwj katchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Nii pucultanaqui ninacpora parlassic̈ha, tuz̈ cjican: —Uc̈humnacatan jiczquiz okan niz̈aza Yooz taku tjaajnan, uc̈humnaca kuzqui ancha zint'atc̈ha. Jalla niz̈tataz̈, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jalla nekztanaqui ana tjewz̈cu Jerusalén watja quejpchic̈ha. Jalla nicju Jesusiz̈ tuncaman illzta z̈oñinacz̈tan zalchic̈ha, yekja mazinacz̈tan juntazzi. ");
INSERT INTO capNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ninacaqui cjichic̈ha: —Ultim werara jacatatchipanc̈ha Jesusa Jiliriqui. Simonaqui zakaz cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nekztanaqui nii pucultanaqui zakaz quint'ichic̈ha, jaknuz̈t jicquiz okan, ninacz̈quiz watc̈haja, jalla nii. Niz̈aza jaknuz̈t Jesusiz̈quiz pajtc̈haja t'anta tojznan, nii quint'ichizakazza. ");
INSERT INTO capNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Jalla nuz̈ parlan, Jesusapachac̈ha ninacz̈ taypiquiz tsijtsiqui. Jesusaqui ninacz̈quiz tsaanchic̈ha, tuz̈ cjican: —¡Zuma kuzziz cjee! ");
INSERT INTO capNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ninacaqui ancha ispantichi cjissic̈ha, ancha tsucchic̈ha. Pinsichic̈ha, “Almaz̈ caa” cjican. ");
INSERT INTO capNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero Jesusaqui cjichic̈ha: —¿Kjaz̈tiquiztan anc̈hucqui tsucchinc̈hucta? ¿Kjaz̈tiquiztam wejt puntuquiztan anc̈huca kuzquiz turwaysita? ");
INSERT INTO capNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Wejt kjaraz̈ cherzna. Wejt kjojchaz̈ cherzna. Wejrpachac̈ha. Lanzna. Chera. Tsjii alma animuqui ana janchichizza, niz̈aza ana tsjijchizza. Anc̈hucqui cherc̈ha, wejrtc̈ha janchichizmi tsjijchizmi. ");
INSERT INTO capNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jalla nuz̈ chiican, Jesusaqui kjaranaca kjojchanaca tjeezic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jalla nekztanaqui nii z̈ejlñi z̈oñinacaqui kuzquiz pinsichic̈ha, “Jesusaqui z̈ejlc̈ha werara, ana werara”, nii. Niz̈tami cuntintutac̈ha. Ispantichi z̈elan, Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucalta ¿c̈hjulut lujlzjapa z̈ejl? ");
INSERT INTO capNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Nekztanaqui Jesusiz̈quiz tjaachic̈ha ch'iz canca, niz̈aza mazk'a. ");
INSERT INTO capNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesusaqui nii c̈hjeri tanz̈cu lujlchic̈ha ninacaz̈ cheran. ");
INSERT INTO capNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nekztanac cjichic̈ha: —Tuquiqui anc̈hucaltan z̈ejlcan anc̈hucaquiz mazinchintac̈ha, jaknuz̈t wejtquiz watstantaz̈laja, jalla nii. Jaziqui cumplispantac̈ha tjapa wejt puntuquiztan cjijrta Yooz takunaca. Moisesqui wejt puntuquiztan cjijrchic̈ha, niz̈aza tuquita Yooz taku paljayñi profetanacaqui cjijrchizakazza wejt puntuquiztan. Niz̈aza salmos cjita liwruquiz cjijrta zakaztac̈ha wejt puntuquiztan. Jalla nii tjapa cumplispantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jalla nekztanaqui Yooz taku tjaajincan zumpacha intintiskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Niz̈aza cjichic̈ha: —Jalla tuz̈ cjijrtatac̈ha. Cristuqui ticspantac̈ha. Niz̈aza c̈hjep majquiztan jacatatspantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nekztan Cristuz̈ mantita kamañquiz kamcan z̈oñinacaqui tjapa kjutñi nacionanacaran liwriiñi taku paljaystanc̈ha. Jerusalén wajtquiztan liwriiñi taku paljayi kallantistanc̈ha. Jalla tuz̈ cjican, paljayaquic̈ha, “Yoozquin kuzziz cjee, niz̈aza kuznaca campiya, ujnaca pertunta cjisjapa”. ");
INSERT INTO capNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Anc̈hucqui jalla niz̈tapacha paljayaquic̈ha. Tisticunacac̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yooz Ejpqui anc̈hucaquiz taku compromitchic̈ha anc̈huca kuzquiz Espíritu Santu cuchanzjapa. Wejrqui anc̈hucaquiz wajilla cuchanz̈cac̈ha nii wejt Yooz Epiz̈ compromitta Espíritu Santo, jalla nii. Niz̈aza tii Jerusalén wajtquizpachaz̈ kamla, tsewctan cuchanz̈quita Espíritu Santuz̈ azi tanzcama. ");
INSERT INTO capNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jalla nekztanaqui Jesusaqui ninaca chjitchic̈ha wajtz̈ tjiya, Betania cjita watjacama. Jalla nicju kjara waytiz̈cu, ninacz̈quiz cjichic̈ha: —Yooz Ejpqui anc̈hucaquiz zuma yanapla. ");
INSERT INTO capNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Jalla nuz̈ chiiz̈cuqui, Jesusaqui ninacz̈quiztan zarakchic̈ha. Tsewcchucpacha waytiscu chjichtatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nii ecta z̈oñinacaqui Jesucristuz̈ honora paljayz̈cu Jerusalén cjita watja ancha cuntintuz̈ cuttiz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Jalla nicju ninacaqui timpluquiz pan z̈ejlchic̈ha, Yooztajapa honora waytican. Jalla nuz̈oj cjila. Amén.");
INSERT INTO capNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ima tii muntu z̈elan Jesucristo z̈elatc̈ha. Jalla niic̈ha Yooz Taku cjita. Niz̈aza Yooz Ejpz̈tanc̈ha. Niimi Yoozzakazza. ");
INSERT INTO capNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Primirquiztanpacha niiqui Yooz Ejpz̈tanpanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jalla niiz̈ cjen Yoozqui tjappacha paachic̈ha. Tjapa niiz̈ paatacamac̈ha. Anaz̈ yekjaz̈ paataqui z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jalla niizakazza z̈eti tjaachiqui. Niz̈aza z̈ejtcan z̈oñinacaqui persun kuzquiz zuma kamaña zizasac̈ha. Tsjii kjanaz̈takaz Jesucristuqui Yooz zuma kamaña z̈oñz̈ kuzquiz zizkatñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Jaknuz̈t tsjii kjanaqui zumchiquiz kjanc̈haja, jalla niz̈ta Jesucristuqui zumchiquiz ojklayñi z̈oñinacz̈ kuzquiz zuma kamaña zizkatc̈ha. Nii zumchiquiz ojklayñi z̈oñinacac̈ha ana zuma kamañchizqui. Pero Jesucristuz̈ cjenpankaz Yooz zuma kamaña zizasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tsjii Yooziz̈ cuchanz̈quita z̈oñi z̈elatc̈ha, Juan cjita. ");
INSERT INTO capNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Niz̈aza Jesucristuc̈ha zuma kamaña zizkatñiqui. Juanqui Jesucristuz̈ puntuquiztan mazñi tjonchic̈ha, tsjii kjanaz̈takaz. Niz̈aza testicu cunta Jesucristuz̈ puntu werara mazzinchic̈ha. Tjapa z̈oñinacz̈quiz nuz̈ mazzinchic̈ha, Jesucristuz̈quiz criyajo. ");
INSERT INTO capNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juanqui anac̈ha ultim Yooz zuma kamaña zizkatñiqui. Antiz tsjii testicu cunta tjonchic̈ha, nii Yooz zuma kamaña zizkatñiz̈ puntuquiztan mazzinzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jesucristuc̈ha ultimu Yooz zuma kamaña zizkatñiqui. Jalla niic̈ha zapa z̈oñinacz̈ kuzquiz Yooz zuma kamaña zizkatñiqui. Niz̈aza Jesucristuqui tii muntuquiz tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Jalla nuz̈ tjonz̈cu tii muntuquiz kamchic̈ha. Niz̈aza niic̈ha tjapa tii muntuquiz z̈ejlñinaca paañiqui. Niiz̈ paataz̈ cjenami tii muntuquiz z̈ejlñi z̈oñinacaqui Jesucristo ana pajz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jesucristo Yooz Majchqui niiz̈ persun wajtchiz z̈oñinacz̈quiz tjonchic̈ha. Pero nii z̈oñinacazti Jesucristo ana pajz pecchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero jakziltami nii Jesucristo pajz pecc̈haja, niz̈aza niiz̈quin tjapa kuztan criic̈haja, jalla ninacaqui ultim Yooz maatinacapanz̈ cjissa. ");
INSERT INTO capNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jalla nuz̈ muñchic̈ha Yoozqui. Anaz̈ persun maa ejpz̈ kuzcama, niz̈aza anaz̈ persun kuzcama, niz̈aza anaz̈ z̈oñiz̈ pinsitacama, antiz Yooziz̈ pinsitacama z̈oñinacaqui Yooz maatinaca cjissa. ");
INSERT INTO capNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yooz Taku cjita Jesucristuqui tii muntuquiz tjonz̈cu, z̈oñz̈ curpuchiz wejtnacatan juntu kamchic̈ha. Jalla tii muntuquiz kamcan Jesucristuqui Yooz zuma okzñi kuz tjeezic̈ha. Niz̈aza Yooz lijitum kamañ puntunacami werara tjeezic̈ha. Tii muntuquiz kaman, wejrnacqui niiz̈ ancha zuma arajpach kamaña cherchinc̈ha. Niic̈ha Yooz Ejpz̈ zinta Majchqui. Jalla niz̈tiquiztan niiz̈ tjeez̈ta arajpach kamañaqui niiz̈ kamañapankalc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanqui nii Yooz Majch puntu mazzinchic̈ha, tuz̈ cjican: —Jalla tiiz̈ puntuquiztan tuqui chiichinc̈ha, tuz̈ cjican: “Tsjiiqui tjonc̈ha wejt jarupacha. Jalla niic̈ha wejtquiztan juc'ant chekanaqui. Ima weriz̈ nasan pan z̈elatkalc̈ha niiqui”. ");
INSERT INTO capNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nii Yooz Majchqui tsjan juc'ant zuma kuzziz cjen uc̈humnacaquiz zuma arajpach kamañchiz cjiskatchic̈ha juc'anti juc'anti. ");
INSERT INTO capNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Tuqui timpu Moisesqui lii mantitanaca z̈oñinacz̈quiz tjaachic̈ha. Jaziqui Jesucristuqui Yooz zuma okzñi kuz z̈oñinacz̈quiz tjeez̈a. Niz̈aza z̈oñinacz̈quiz Yooz zuma kamañchiz cjiskatc̈ha, niz̈aza Yooz puntunaca zizkatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Jesucristuc̈ha Yooz Majchqui. Anapanz̈ jec z̈oñimi Yooz cherchiqui. Niiz̈ zinta Majch alajakazza Yooz cherchiqui. Nii Yooz Majchqui Yooz Ejpz̈tan tsjii kuzzizpankazza. Jalla niz̈tiquiztan niic̈ha Yooz puntunacami werara zizkatñiqui. ");
INSERT INTO capNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juanz̈ mazzintaqui Jesucristuz̈ puntuquiztan jalla tuz̈uc̈ha. Jerusalén wajtchiz judío z̈oñinacaqui Juanz̈ puntuquiztan iya ziz pecatc̈ha. Nekztan timplu jilirinacami timpluquiz sirwiñinacami Juanz̈quin pewczñi cuchanz̈quitatac̈ha. Ninaca pewczic̈ha, tuz̈ cjican: —¿Amqui jequimtaya? ");
INSERT INTO capNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juanqui zumpacha mazzinchic̈ha. Nii pewczñi z̈oñz̈quiz ana nicchic̈ha. Mazzincan tuz̈ cjichic̈ha: —Wejrqui anac̈ha Cristutqui, anc̈hucaz̈ tjewz̈taqui. ");
INSERT INTO capNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jalla nekztanaqui nii pewczñi z̈oñinacaqui wilta pewczic̈ha tuz̈ cjican: —¿Jequimt amjo? ¿Elías cjita profetamkaya? Juanqui kjaazic̈ha, tuz̈ cjican: —Anac̈ha Eliastqui. Nekztanaqui ninacaqui pewczic̈ha, tuz̈ cjican: —Nii profeta tjoniz̈ cjizpacha, ¿niimi amya? Juanqui kjaazic̈ha, tuz̈ cjican: —Wejr anac̈ha niitqui. ");
INSERT INTO capNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jalla nekztanaqui ninacaqui cjichic̈ha: —¿Jecpant amjo? Wejrnacqui quintu chjitstanc̈ha wejrnac cuchanz̈quiñinacz̈quin. Am persun puntuquiztan ¿kjaz̈um cjii? ");
INSERT INTO capNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Nekztan Juanqui tuz̈ kjaazic̈ha: —Wejrtc̈ha alto jorz̈tan ch'ekti yokquin paljayiñtqui. Tuz̈ paljayiñc̈ha: “Yooz Jilirz̈tajapa zuma kamañ jicz tjaczna”. Jaknuz̈t Isaías cjita profeta chiitc̈haja, jalla nuz̈ paljayiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nii pewczñinacaqui fariseo z̈oñinacaz̈ cuchanz̈quitatac̈ha, Juanz̈quin. ");
INSERT INTO capNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ninacaqui pewczizakazza tuz̈ cjican: —Niz̈taqui amqui anaz̈ Cristumni, niz̈aza anaz̈ Eliasni, niz̈aza anaz̈ nii tjonñi profetamni. Ana niz̈ta z̈oñimz̈laj niiqui, ¿kjaz̈tiquiztan am judio z̈oñinaca bautisjo? ");
INSERT INTO capNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juanqui ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Wejrqui kjaztankaz bautisiñc̈ha. Judío z̈oñinacz̈quiztan tsjiiqui z̈ejlc̈ha, jalla niiqui anc̈hucqui anaz̈ pajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Jalla niiqui wejt jaruz̈ tjonc̈ha. Jalla nuz̈ cjenami niic̈ha wejtquiztan juc'ant tsjan chekanaqui. Jalla nii atintizjapa wejrqui anal waquizuc̈ha, niiz̈ zapat chiqui jwerzinimi, anaz̈ cjichuca. ");
INSERT INTO capNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betábara cjita yokquin nuz̈ Juanz̈quiz pecuntatac̈ha. Betábara cjita yokaqui Jordán cjita pujz̈ tuunac̈ha. Jalla nicju Juanqui bautisatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Jakataz̈uqui Juanqui Jesusa tjonñi cherchic̈ha. Jalla nuz̈ cherz̈cu, tuz̈ cjichic̈ha: —Cherzna. Tiic̈ha Yoozquiztan cuchanz̈quita z̈oñi, uuzi wilanaz̈takaz. Jalla tiiqui tii muntuquiz z̈ejlñi z̈oñinacz̈ cuntiquiztan ticznaquic̈ha. Ujchiz z̈oñinacz̈ laycu ticznaquic̈ha, ninacaz̈ ujnacquiztan ana casticta cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Wejrqui tiiz̈ puntuquiztan mazzinchinc̈ha tuz̈ cjican: “Wejt wirquin tjonc̈ha tsjiiqui. Jalla niic̈ha wejtquiztan juc'ant tsjan chekanaqui. Ima weriz̈ nasan, niiqui z̈elatkalc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wejrqui persunpacha tii z̈oñi anal zizaytuc̈ha, jecc̈halaj, jalla nii. Wejrqui Yooz mantita jaru kjaztan bautisiñc̈ha, Israel wajtchiz z̈oñinacz̈quiz nii pajkatta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Niz̈aza Juanqui Jesusiz̈ puntuquiztan tuz̈ chiichizakazza: —Wejrqui arajpachquiztan Yooz Espíritu Santo palumaz̈takaz chjijwz̈quiñi cherchinc̈ha. Nekztan nii palumaqui Jesusiz̈ juntuñpacha cjisquichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Tuquiqui wejrqui persunpacha tii z̈oñi anal zizaytuc̈ha, jecc̈halaj, jalla nii. Pero Yoozqui wejr mantichic̈ha kjaztan bautisajo. Niz̈aza wejtquiz tuz̈ cjichic̈ha: “Espíritu Santuqui jecz̈quiz chjijwz̈cac̈haja, niz̈aza niiz̈quiz z̈elac̈haja, jalla niic̈ha Espíritu Santuz̈tan bautisñiqui. Jalla nii cherz̈cu niiz̈quiz pajaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jaziqui niz̈tapan cherchinc̈ha, jalla niz̈tiquiztan wejrqui anc̈hucaquiz maznuc̈ha, tiic̈ha werar Yooz Maatiqui, cjican. ");
INSERT INTO capNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Jakataz̈uqui Juanqui pucultan niiz̈ tjaajinta z̈oñinacz̈tan tsijtsi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesusaz̈ nijcchuc ojklayan, Juanqui niiz̈quin cherz̈cu tuz̈ cjichic̈ha: —Cherzna. Tiic̈ha Yoozquiztan cuchanz̈quitaqui. Uuzi wilanaz̈takaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nii pucultan Juanz̈ tjaajintanacaqui jalla nuz̈ chiiñi nonz̈cu Jesusiz̈quiz apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jalla nekztanaqui Jesusaqui wir kjutñi cherz̈cu, ninaca apzquiñi naychic̈ha. Ninacz̈quiz cjichic̈ha: —¿C̈hjuluz̈ anc̈huc kjurya? Nii apzñi z̈oñinacaqui tuz̈ kjaazic̈ha: —Rabbí. (Rabbí cjita takuqui Tjaajiñi Maestro cjic̈ha ninacz̈ tawkquiztan.) ¿Jakziquinam am kamya? ");
INSERT INTO capNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jesusaqui ninacz̈quiz cjichic̈ha: —Picha. Wejttan oka, cherzjapa. Jalla nekztanaqui tjonzñi ojkchic̈ha, jakziquin kamchitaz̈laja, jalla nicju. Tjuñi zezi cjen nii pucultanaqui Jesusiz̈tan kamchic̈ha nii zeztan ween pakara. ");
INSERT INTO capNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Tsjii pucultiquiztan Andrés cjitatac̈ha, Simón Pedruz̈ lajktac̈ha. Jalla niiqui Juanz̈ chiita nonz̈cu Jesusa apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pero Andresqui ima Jesusiz̈tan ojklaycan niiz̈ Simón cjita jila kjuri ojkchic̈ha. Jalla niiz̈tan zalz̈cu, tuz̈ mazzic̈ha: —Wejrqui Mesiastan zalchinc̈ha. (Ninacz̈ tawkquiztan Mesías cjita tjuuqui Cristuz̈ cjicha. Cristo cjita tjuuqui “Yooz illzta” cjic̈ha.) ");
INSERT INTO capNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jalla nekztanaqui Andresqui niiz̈ jila Jesusiz̈quiz zjijcchic̈ha. Jesusaqui nii cherz̈cu, tuz̈ cjichic̈ha: —Amqui Simona cjitamc̈ha, Jonás majch. Tekztan najwcchuc Cefas cjita cjequic̈ha. (Cefas cjita tjuuqui Pedro cjic̈ha, ninacz̈ tawkquiztan. Pedro cjita tjuuqui “maz” cjic̈ha.) ");
INSERT INTO capNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jakataz̈uqui Jesusaqui Galilea yokquin ojkz pinsichic̈ha. Jalla nuz̈ okawk cjen, Felipe cjita z̈oñz̈tan zalchic̈ha. Niiz̈quiz tuz̈ cjichic̈ha: —Wejttanpanim chica ojklayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Nii Felipiqui Betsaida wajtchiz z̈oñitac̈ha. Andrestan Pedruz̈tan nii wajtchiz z̈oñinacazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jalla nekztanaqui Felipiqui Natanael kjuri ojkchic̈ha. Jalla niiz̈tan zalz̈cu cjichic̈ha: —Tsjii z̈oñz̈tan zalchinc̈ha. Niiz̈ puntuquiztan Moisesqui cjijrchipantala Yooziz̈ tjaata liy librunacquiz. Niz̈aza niiz̈ puntu profetanacaqui cjijrchizakaztac̈ha. Niiqui Jesusa cjitac̈ha, Josez̈ majch. Nazaret wajtchiz z̈oñic̈ha nii Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jalla nuz̈ nonz̈cu Natanaelqui tuz̈ cjichic̈ha: —¿Nazaret wajtquiztan zuma z̈oñi z̈elasajo? Anaz̈ jaz. Felipiqui niiz̈quiz tuz̈ kjaazic̈ha: —Cherz̈quilay. ");
INSERT INTO capNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesusaqui Natanael cjita z̈oñi macjatz̈quiñi cherz̈cu, tuz̈ cjichic̈ha: —Cherz̈ca. Nii z̈oñic̈ha lijitum Israel wajtchiz z̈oñiqui, ana incallñiqui, niz̈aza zuma kuzzizza. ");
INSERT INTO capNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jalla nekztanaqui Natanaelqui Jesusiz̈quiz pewczic̈ha tuz̈ cjican: —¿Jaknuz̈um am wejr pajjo? Jesusaqui niiz̈quiz kjaazic̈ha tuz̈ cjican: —Ima Felipe am kjawznan, wejrqui am cherchinc̈ha, higo munti koztan. ");
INSERT INTO capNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaelqui tuz̈ cjichic̈ha: —Tjaajiñi Maestro, am Yooz Maatimkalala, Israel z̈oñinacz̈ chawc Jilirimkalala. ");
INSERT INTO capNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nekztanaqui Jesusaqui niiz̈quiz cjichic̈ha: —Wejrqui chiichinc̈ha, am higo munti koztan z̈ejlñi cherchinc̈ha, nii. Jalla niz̈ta chiitiquiztan alaja wejtquizim kuzziz cjissamc̈ha. Pero wiruñaqui juc'ant pajk obranaca cheraquic̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Niz̈aza Jesusaqui cjichizakazza: —Anc̈hucaquiz weraral cjiwc̈ha. Anc̈hucqui arajpacha cjetsi cheraquic̈ha, niz̈aza Yooz anjilanacaqui wejt juntuñ chjijwz̈quiñi yawz̈quiñi cheraquic̈ha. Wejrtc̈ha tsewctan cuchanz̈quita Yooz Z̈oñtqui. ");
INSERT INTO capNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","C̈hjep majquiztan tsjii zalz pjijzta z̈elatc̈ha Caná wajtquin, Galilea yokquin. Jesusiz̈ maa nicju z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Niz̈aza Jesusaqui niiz̈ tjaajinta z̈oñinacz̈tanpacha nii zalz pjijztiquiz kjawz̈tatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jalla nuz̈ pjijzta paan vino upzitac̈ha. Jalla nekztanaqui Jesusiz̈ maaqui niiz̈quiz cjichinc̈ha: —Vino upzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesusaqui naaquiz tuz̈ kjaazic̈ha: —Maataka, ¿kjaz̈tiquiztan nii puntu wejtquiz chiijo? Wejt langz ora imazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Pero naaqui nekz atintiñi sirwizunacz̈quiz cjichinc̈ha: —Tiiz̈ mantitacama anc̈hucz̈ paaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jalla nicju sojta pajk maz luuznaca z̈elatc̈ha. Judío z̈oñinacaqui ajunz cuzturumpi paazjapa luuznaca joojooñitac̈ha. Zapa luuzquiz quinzakal tunc litro, patac litro, nuz̈ kjaz luzñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nekztan Jesusaqui nii pjijzta paañi sirwizunacz̈quiz mantichic̈ha, tuz̈ cjican: —Tii luuznacquiz anc̈hucqui kjaz chjijpznaquic̈ha. Nekztanaqui luuz joracama kjaznaca chjijpzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Jaziqui tsjii zkoluculla cooz̈na. Nekztan pjijzta paañi patrunz̈quiz chjicha. Jalla nuz̈ niiz̈ chiitacama chjitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nii pjijzta paañi patrunaqui mallzic̈ha nii kjazquiztan vino tucchi. Jakziquiztan tjonchi nii vino, jalla nii ana zizatc̈ha. Sirwizunacakaz zizatc̈ha. Ninacaz̈ kjazqui cootkalc̈ha. Jalla nuz̈ nii vino mallz̈cu pjijzta paañi patrunaqui nii zalzñi tjowa kjawzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nekztan tuz̈ cjichic̈ha: —C̈hjul z̈oñimi zuma vino panz̈ tjaac̈ha primiraqui. Nekztan kjawz̈ta z̈oñinacaz̈ zuma vino lictan nii jaru ana zuti zuma vino zakaz tjaac̈ha. Amzti tii oracama tii ancha zuma vino c̈hjojcham, ¿kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jalla niitac̈ha Jesusaz̈ primer paata milajruqui. Caná de Galilea wajtquiz paachic̈ha. Jesusaqui nii milajru paacan, niiz̈ arajpach kamañami azimi tjeezic̈ha. Jalla niz̈tiquiztan niiz̈tan chica ojklayñi z̈oñinacaqui niiz̈quizimi tjapa kuz cjissic̈ha, niz̈aza criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jalla niiz̈ wiruñ Capernaum wajtquin ojkchic̈ha. Niiz̈ maatan, niiz̈ lajknacz̈tan, niiz̈ tjaajinta z̈oñinacz̈tan, jalla ninacaqui niiz̈tan chica ojkchic̈ha. Jalla nicju tsjii kjaz̈ maj kamchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judío z̈oñinacz̈ pascua pjijzta wajillatac̈ha. Jalla niz̈tiquiztan Jesusaqui Jerusalén watja ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jalla nicju timplu patiuquiz luzcu, animala tuyñinaca cherchic̈ha. Vacanaca, uuzinaca, niz̈aza palumanaca jalla niz̈tanaca timplu patiuquiz tuyñi cherchic̈ha. Niz̈aza paaz campiiñinaca ninacz̈ puestuquiz julzi cherchizakazza. ");
INSERT INTO capNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jalla niz̈tanaca cherz̈cu Jesusaqui poota zkizquiztan lazu paachic̈ha. Jalla nekztanaqui nii laztan zancchuc liwj tirkatchic̈ha vacanacami, uuzinacami tjapa nii tuyñinacz̈tanpacha. Nii paaz campiiñi z̈oñinacz̈ paazmi k'ala witzinchic̈ha, niz̈aza ninacz̈ mizanacami pjokz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Nekztan paluma tuyñi z̈oñinacz̈quiz ujzic̈ha tuz̈ cjican: —Tjapa tinaca jwesa. Wejt Yooz Ejpz̈ kjuya anac̈ha tuyz kjuya tjaczqui. ");
INSERT INTO capNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jalla nekztanaqui niiz̈ tjaajinta z̈oñinacaqui cjijrta Yooz taku cjuñzic̈ha. Yooz tawk libruquiz tuz̈ cjijrtkalc̈ha: “Am kjuya rispitta cjiskatz pecuc̈ha. Nuz̈ pectiquiztan akztal cjeec̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jalla nekztanaqui judío z̈oñinacaqui niiz̈quiz pewczic̈ha tuz̈ cjican: —Jalla niz̈tanaca paazjapa, ¿ject am mantichejo? Yoozqui am mantichiz̈laj niiqui, tsjii siñala milajruz̈ tjeez̈na. ");
INSERT INTO capNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesusaqui tuz̈ kjaazic̈ha: —Tii timplu pajlz̈ta cjequic̈ha. Nekztan c̈hjep majquiz wilta tsijtsnac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jalla niz̈ta chiiñi nonz̈cu judío z̈oñinacaqui cjichic̈ha: —Tii timplu kjuycanaqui pusi tunc sojtan wata kjuytala pero. ¿Amqui c̈hjep majquizkaz tii timplu tsijtsnasajo? Anapan niim atasac̈ha amqui. ");
INSERT INTO capNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jalla nuz̈ nii timplu puntuquiztan chiican Jesusaqui niiz̈ persun curpu puntuquiztanz̈ chiyatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jesusaz̈ ticziquiztan jacatattan niiz̈ tjaajinta z̈oñinacaqui nii chiita cjuñzic̈ha. Nekztan Yooz takumi criichic̈ha, Jesusaz̈ jacatatz punto cjijrta. Niz̈aza Jesusiz̈ chiitanacami criichizakazza. ");
INSERT INTO capNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua pjijztiquiz Jesusaqui Jerusalén wajtquiz z̈elatc̈ha. Jalla nicju z̈elan walja z̈oñinacaqui niiz̈quin criichic̈ha. Niiz̈ paata milajrunacami siñalanacami, nii cherz̈cu criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesusaqui niiz̈ persun kuzquiz z̈oñinacz̈ kuz, jaknuz̈t cjec̈haja, jalla nii zizatc̈ha. Jalla niz̈tiquiztan Jesusaqui nii juntuñ criichi z̈oñinacz̈quiz ana juyzu paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesusaqui persunpacha z̈oñinacz̈ kuz jaknuz̈t cjec̈haja jalla nii zizatc̈ha. Jalla niz̈tiquiztan niiqui anaz̈ jec tjaajzñimi pecatc̈ha z̈oñinacz̈ kuz puntuquiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tsjii fariseo z̈oñi z̈elatc̈ha, Nicodemo cjita, judío z̈oñinacz̈ jiliritac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jalla nii Nicodemuqui tsjii ween Jesusiz̈quin tjonzñi ojkchic̈ha. Nekztan Jesusiz̈quin paljaychic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, z̈oñiqui ana Yooz poderz̈tanz̈laj niiqui, nekztan ana milajrunaca paasac̈ha, amiz̈ paata milajru, niz̈tanacami. Jalla niz̈tiquiztan wejrqui zizuc̈ha, Yoozquiztan tjonchamc̈ha, Yooz obra tjeezñi niz̈aza Yooz puntu tjaajñi. ");
INSERT INTO capNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jalla nekztanaqui Jesusaqui niiz̈quiz cjichic̈ha: —Amquiz weraral cjeec̈ha. Jequit ana pizc wilta nassi cjec̈haja, jalla niiqui arajpach Yooz wajtquiz ana kamasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jalla niz̈ta chiitiquiztan nii Nicodemo cjita z̈oñiqui tuz̈ pewczic̈ha: —Pero, ¿kjaz̈ tsjii z̈oñiqui wilta majtta cjesajo? Wilta majtta cjisjapa, ¿maa iczquiz wiltaz̈ luzasajo? ");
INSERT INTO capNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesusaqui tuz̈ kjaazic̈ha: —Ultimu werarapal cjiwc̈ha. Jequit kjazquiztanami Espíritu Santuz̈quiztanami ana nassi cjec̈haja jalla niiqui arajpach Yooz wajtquiz ana luzasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jequit maa ejpz̈quiztankaz nassaja, jalla niiqui z̈oñz̈ kamañchizkazza. Pero jequit Yooz Espíritu Santuquiztan zakaz nassaja, jalla niiqui Yooz Espíritu Santuz̈ kamañchizza. ");
INSERT INTO capNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Weriz̈ chiitiquiztan anam am ispantaquic̈ha. Tjapa z̈oñinacaqui pizc wilta nastanpanc̈ha cjiwc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nicjumi ticjumi tjamiqui tjamc̈ha. Nii tjamz̈ jora nonz̈canami jakziquiztan tjamz̈quic̈haja, jakzitchuc ojkc̈haja, jalla nii ana zizzuca. Jalla niz̈ta irataz̈ Yooz Espíritu Santuqui jecz̈ kuzquizimiz̈ luzasac̈ha. Niz̈aza ana Yoozquin criichi z̈oñinacaqui criichi z̈oñinacz̈ kamaña cherc̈ha. Pero nii Espíritu Santuz̈ tjaata kamaña ana intintazucac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jalla nekztanaqui Nicodemuqui wilta pewczic̈ha, tuz̈ cjican: —¿Jaknuz̈upan cjes teejo? ");
INSERT INTO capNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesusaqui niiz̈quin tuz̈ kjaazic̈ha: —Amqui Israel z̈oñinacz̈quiz tjaajiñi maestrumla. ¿Jalla tii weriz̈ chiita ana intintazzucakaya? ");
INSERT INTO capNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ultimupan wejr cjiwc̈ha. Wejrqui tii puntuquiztan intintazcu chiyuc̈ha. Weraraz̈ chiyuc̈ha, tii weriz̈ zizta niz̈aza cherta puntunacami. Jalla nuz̈ cjenami amqui weriz̈ chiita anam catokc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Tii muntuquiz watñi puntuquiztan chiyan ana intintazza amqui. Jaziqui juc'ant altu razunz̈tan arajpach Yooz puntuquiztan chiyanami, ¿jaknuz̈t am intintasasajo? ");
INSERT INTO capNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‛Anaz̈ jecmi arajpachquin yawchiqui. Wejrpankal arajpach Yooz puntuquiztan zumpacha zizuc̈ha. Wejrqui arajpachquiztan chjijwz̈quichinc̈ha. Wejrqui arajpachquiztan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Niz̈aza wejrqui cruzquiz waytital cjistanc̈ha. Jaknuz̈t Moisesqui tsjii korquiztan paata zkora pajk tuñquiz waytitc̈haja, jalla niz̈ta wejrqui waytital cjistanc̈ha, ");
INSERT INTO capNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","wejtquin criichi z̈oñinacz̈quiz ew kamaña tjaazjapa, ninaca Yooztan wiñaya kamajo, ana infiernuquin sufrajo. ");
INSERT INTO capNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Yooz Ejpqui tii muntuquiz z̈ejlñi z̈oñinacz̈quiz ancha okz̈quichipanc̈ha. Jalla niz̈tiquiztan niiz̈ zinta Majch cuchanz̈quichic̈ha, z̈oñinacz̈quiz ew kamañchiz cjiskatzjapa. Jakziltat niiz̈ zinta Majchquiz criyac̈haja, ew kamañchiz cjequic̈ha Yooztan wiñaya kamzjapa ana infiernuquin sufrajo. ");
INSERT INTO capNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Yooz Ejpqui niiz̈ Majch tii muntuquiz cuchanz̈quichic̈ha. Niiz̈ cjen z̈oñinaca liwriita cjesac̈ha infiernuquin ana casticta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","‛Jakziltat Yooz Majchquiz criyac̈haja, jalla niiqui ana infiernuquin castictaz̈ cjequic̈ha. Pero jakziltat Yooz Majchquiz ana criyac̈haja, jalla niiqui infiernuquin castictapanz̈ cjequic̈ha, Yooz zinta Majchquiz ana criitiquiztan. ");
INSERT INTO capNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yooz zinta Majchc̈ha Yooz kamaña tjeezñiqui zuma kjanaz̈takaz. Jalla nuz̈ cjenaqui tii muntuquiz tjontan, z̈oñinacaqui ana wali kamañchiz kamzpanz̈ pecatc̈ha, zumchiquiz kamzpanz̈ pecatc̈ha. Niz̈aza ninacaz̈ ana wali kamtanacaz̈ cjen Yooz kamañchiz cjis ana pecchipanc̈ha. Jalla niz̈tiquiztan castictapanz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tjapa ana wali kamñinacaqui Yooz kamaña tjeezñiz̈japa quintrac̈ha. Niz̈aza Yooz kamaña tjeezñiz̈quiz anaz̈ cherz pecc̈ha, ninacz̈ ana wali kamtanaca ana tjeezta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero jakziltat werar Yooz kamañ jaru kamz pecc̈haja, jalla niiqui Yooz kamaña tjeezñiz̈quiz macjatz̈quic̈ha kjanapacha tjeezjapa, niiz̈ zuma kamtanaca Yooz aztan kamtac̈ha, nii. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jalla nuz̈ Nicodemuz̈tan parliz̈cu, Jesusaqui tjaajintanacz̈tan Judea yokquin ojkchic̈ha. Jalla nicju niiz̈ tjaajintanacaqui bautiscan z̈ejlchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Niz̈aza Juan bautiscan zakaz z̈elatc̈ha. Salim cjita wajt z̈cati Enón cjita wajtquin z̈elatc̈ha. Jalla nicju wacchi kjaz z̈elatc̈ha. Nekztan z̈oñinacaz̈ tjonatc̈ha bautista cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jalla niz̈tanaca watchic̈ha, ima Juanqui carsilquin chawcta cjen. ");
INSERT INTO capNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jalla nekztanaqui Juanz̈ tjaajinta z̈oñinacz̈tan tsjii kjaz̈ judío z̈oñinacz̈tan ch'aassic̈ha, ajunz cuzturumpi puntuquiztan. ");
INSERT INTO capNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juanz̈ tjaajintanacaqui niiz̈quin mazñi tjonchic̈ha, tuz̈ cjican: —Tjaajiñi maestro, tsjiiqui amtan chica z̈elatc̈ha Jordán pujz̈ tuuna. Amqui niiz̈ puntuquiztan mazzinchamc̈ha. Jalla niiqui tekz z̈ejlc̈ha bautiscan. Niz̈aza tjapa z̈oñinacaqui niiz̈tan ojkzpanz̈ cjissa. ");
INSERT INTO capNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juanqui ninacz̈quiz tuz̈ cjichic̈ha: —Yooz Ejpqui wejtquiz tsjii kamaña tjaachic̈ha; niz̈aza tsjii puestuquiz wejr utchic̈ha. Jaknuz̈t Yoozqui z̈oñz̈quiz kamaña tjaatc̈haja, jalla nii jaru z̈oñiqui kamz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Anc̈hucpacha weriz̈ chiita nonzinc̈hucc̈ha. Wejr cjichinc̈ha: Anac̈ha wejr Cristutqui. Wejrzti niiz̈ tuqui cuchanz̈quita z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tsjii zalz pjijztiquiz zalzñi tjowaqui yanapñi mazinacz̈quiztan tsjan importantic̈ha. Nii zalzñi tjowaqui tjunchizza. Yanapñi mazinacaqui jalla nii nonz̈cu cuntintuc̈ha, niz̈aza chipchipc̈ha. Jalla niz̈ta iratac̈ha anziqui. Wejrqui Jesusiz̈ quintu nonz̈cu ancha cuntintutc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Niiqui juc'anti juc'anti tucquin cjistanc̈ha. Wejrzti niiz̈quiztan juc'anti juc'anti wirquin cjistanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nii tsewctan tjonchi z̈oñic̈ha tjapa z̈oñinacz̈quiztan juc'anti chekanaqui. Tii yok muntuquiz kamñi z̈oñinacaqui tii yokjapakaz kamañchizza. Niz̈aza tii yokjapa kamaña puntuquiztankaz parlic̈ha. Nii tsewctan tjonchi z̈oñizti tjapa z̈oñinacz̈quiztan juc'antic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Nii tsewctan tjonchi z̈oñiqui arajpachquin c̈hjulut chertc̈haja, nonz̈tc̈haja, jalla nii z̈oñinacz̈quiz mazzic̈ha. Jalla nii zumanaca maztiquiztanami z̈oñinacaqui anaz̈ wira criiz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jakziltat niiz̈ mazta criic̈haja, niiqui tjurt'aquic̈ha, Yooziz̈ chiita takuqui werarapankalala, cjican. ");
INSERT INTO capNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yooziz̈ cuchanz̈quita z̈oñiqui Yooz takupanz̈ parlic̈ha. Yooz Espíritu Santuc̈ha niiz̈ kuzquiz z̈ejlñipan, yanapzjapa. Jalla niz̈tiquiztan Yooz takupanz̈ parlic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Yooz Ejpqui niiz̈ Majch k'aachic̈ha. Jalla niz̈tiquiztan tjappacha tjaachic̈ha niiz̈ Majch kjarquiz. ");
INSERT INTO capNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jalla niz̈tiquiztan jakziltat Yooz Majchquiz criyac̈haja, jalla niiqui Yooztan wiñaya kamaquic̈ha. Niz̈aza jakziltat ana Yooz Majchquiz criyac̈haja niz̈aza ana cazac̈haja, jalla niiqui anapanz̈ Yooztan kamasac̈ha. Niz̈aza Yooz Ejpqui cjic̈ha, nii z̈oñiqui castictaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Z̈oñinacaqui Jesusiz̈quiz walja tjonchic̈ha niiz̈tan chica ojklayzjapa, Juanz̈quiztan juc'ant tama. Niz̈aza Juanz̈quiztan juc'anti z̈oñinaca bautissicha. Jalla nii quintu ojklayan, fariseo z̈oñinacaqui nii quintu nonchic̈ha. Nekztan Jesusiz̈tan quintrazi kallantichic̈ha. Nii zizzic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jalla nuz̈ nii Jesusiz̈ bautis quintu ojklaychiz̈ cjenami, Jesusaqui anaz̈ bautissic̈ha. Antiz niiz̈ tjaajinta z̈oñinacakaz bautisatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Pero fariseo z̈oñinacaqui Jesusiz̈ puntuquiztan nonz̈cu, Jesusiz̈tan quintrazi kallantichic̈ha. Jalla niz̈tiquiztan Jesusaqui Judea yokquiztan zarakchic̈ha, Galilea yokquin quejpz̈quizjapa. ");
INSERT INTO capNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jalla nii jiczquiz ojkcan, Samaria yoka nuz̈ watstantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jalla nuz̈ Samaria yokquin ojkcan Sicar cjita wajtquin irantichic̈ha. Tuqui timpu Jacob cjita z̈oñiqui niiz̈ José cjita majchquiz tsjii yoka tjaachitac̈ha. Nii yok z̈cati Sicar cjita watja z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Jalla nicju tsjii kjaz tuj z̈elatc̈ha, Jacobz̈ tuj cjitatac̈ha. Jesusaqui jiczquiz ojktiquiztan otchic̈ha. Nekztan tuj latuquiz julzic̈ha. Nii oraqui taypur wajitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Nekztanaqui niiz̈ tjaajinta z̈oñinacaqui watja luzzic̈ha lujlz c̈hjeri kjayzjapa. Jesusaz̈ nuz̈ zinalla z̈elan, tsjaa Samaria wajtchiz maatakqui nii tujquin kjaz cooyi tjonchinc̈ha. Jesusaqui naaquiz paljaychic̈ha: —Kjaz onalla, —cjican. ");
INSERT INTO capNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jalla nuz̈ kjaz tomangztiquiztan naa Samaria wajtchiz maatak z̈onqui cjichinc̈ha: —Amqui judío z̈oñimla. Wejrqui Samaria wajtchiz z̈ontc̈ha. ¿Kjaz̈tiquiztan amqui wejtquiztan kjaz mayjo? (Judío z̈oñinacz̈tan Samaria wajtchiz z̈oñinacz̈tan porapat ana parliñipanla, pero.) ");
INSERT INTO capNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jalla nekztanaqui naa maatakaz̈ chiitiquiztan Jesusaqui tuz̈ kjaazic̈ha: —Wejrqui amquiztan kjaz maychinc̈ha. Pero amzti wejt puntuquiztanami niz̈aza Yooziz̈ tjaaz puntuquiztanami intintitasaz̈ niiqui, jalla nekztan wejtquiztan z̈ejtñi kjaz maytasac̈ha. Niz̈aza nii z̈ejtñi kjaz tjaatam cjitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jalla nekztanaqui naa maatakqui tuz̈ cjichinc̈ha: —Señor, am anaj kjaz coozizzamla. Tii tuj kozic̈ha. ¿Jakzictanam nii z̈ejtñi kjaz tjaasajo? ");
INSERT INTO capNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Uc̈hum Jacob cjita tuquita ejpqui tii tuj ecanchic̈ha. Niz̈aza tii tujquiztan kjaz licñitac̈ha, niz̈aza niiz̈ maatinacami, niz̈aza niiz̈ animalanacami. ¿Amqui niiz̈quiztan juc'antim cjes, kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jalla nekztanaqui Jesusaqui naaquiz cjichic̈ha: —Jakziltat tii tuj kjazquiztan licc̈haja, jalla niiqui wiltaz̈ kjaz pecaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero jakziltat weriz̈ tjaata kjaz licc̈haja, jalla niiqui anaz̈ iya kjaz pecñiz̈ cjequic̈ha. Weriz̈ tjaata kjazqui niiz̈ persun kuzquiz tsjii jalzuriz̈takaz cjisnaquic̈ha wiñaya z̈ejtzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jalla nekztanaqui naa maatak z̈onqui niiz̈quiz cjichinc̈ha: —Señor, nii kjaz tjaalla, ana iya kjaz peczjapa, niz̈aza tii tujquiz ana iya kjaz cooyi tjonzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nekztanaqui Jesusaqui naaquiz cjichic̈ha: —Oka, am luctaka kjawz̈ca. Nekztan wiltam wejtquin tjonaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Naa maatak z̈onqui tuz̈ kjaazic̈ha: —Ana luctakchiztc̈ha. Jalla nuz̈ kjaaztiquiztan Jesusaqui tuz̈ cjichic̈ha: —Amqui weraram chiic̈ha, “Ana luctakchiztc̈ha” cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Amqui pjijska luctakchiztakalala amqui. Jalla niz̈tiquiztan anziqui am lucum cjic̈haja, jalla niiqui anaz̈ am ultim lucuqui. Jaziqui weraram chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jalla nekztanaqui naa maatak z̈onqui Jesusiz̈quiz tuz̈ cjichinc̈ha: —Señor, amc̈ha profetaqui, nuz̈ tantiyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Wejtnaca tuquita ejpnacaqui tii curquiz Yooz rispitñitac̈ha. Anc̈huc judío z̈oñinacazti cjiñchucc̈ha, Jerusalén wajtquin Yooz rispitsa, nii. ");
INSERT INTO capNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nekztanaqui Jesusaqui naaquiz tuz̈ kjaazic̈ha: —Maataka, weriz̈ chiita taku criya. Tsjii tjuñi tjonc̈ha. Jalla nii tjuñquiziqui anaz̈ tii curquizimi nizaza anaz̈ Jerusalén wajtquizimi Yooz Ejp rispitaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anc̈hucqui Yooz ana zuma pajz̈cu rispitc̈ha. Wejrnaczti Yooz lijituma pajz̈cu rispituc̈ha. Judío partiquiztanz̈ Yooziz̈ cuchanz̈quita Liwriiñiqui tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Nii tjonz tjuñquiziqui, niz̈aza anzimi, werar Yooz Ejp rispitñinacaqui kuztanami animuz̈tanami Yooz rispitaquic̈ha. Niz̈aza Yooz Ejpz̈ kuzcama weraraz̈ rispitaquic̈ha. Jalla niz̈ta rispitñinacaz̈ Yooz Ejpqui pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Yoozza ana janchichizqui, animuz̈takaz. Jalla niz̈tiquiztan niiz̈quin rispitñinacaqui kuztanami animuz̈tanami nii rispitstanc̈ha. Niz̈aza Yooz kuzcama werara rispitstanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jalla nekztanaqui naa maatak z̈onqui Jesusiz̈quiz cjichinc̈ha: —Tsjii noojiqui tsjii Yoozquiztan cuchanz̈quita cjitaqui tjonaquic̈ha. (Mesías, niz̈aza Cristo cjitazakazza niiqui.) Jalla nii tjonz̈cu wejtnacaquiz tjapa Yooz puntuquiztan tjaajnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Nekztanaqui Jesusaqui naaquiz tuz̈ cjichic̈ha: —Werjtc̈ha niitqui, amquiz paljayuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jalla nuz̈ parlan Jesusiz̈ tjaajinta z̈oñinacaqui quejpz̈quichic̈ha. Nuz̈ Jesusaz̈ tsjaa Samaria wajtchiz z̈onatan parliñi cherz̈cu, ispantichic̈ha. Ancha ispantiz̈cu tjapa nii tjaajintanacaqui ana pewczñi atchic̈ha, “Naaquiztan ¿c̈hjulum pec?” cjican, uz̈ “¿Kjaz̈tiquiztan naa z̈onatan parli?” cjican ana pewczñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nekztanaqui naa maatak z̈onqui kjaz luuz eccu, watja ojkchinc̈ha. Nekztan z̈oñinacz̈quin tuz̈ quint'ichinc̈ha: ");
INSERT INTO capNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ojklay, tsjii z̈oñiz̈ cherz̈quilay. Niiqui tjapa weriz̈ kamta puntu zizza. Wejtquiz nii puntu chiichic̈ha. ¿Anaj tii Yooz cuchanz̈quita Cristo cjesaya? ");
INSERT INTO capNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Nekztanaqui zoñinacaqui wajtquiztan ulanz̈quichic̈ha, jakziquin Jesusa z̈elatc̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ima nii z̈oñinacaz̈ irantiz̈can, niiz̈ tjaajintanacaqui Jesusiz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, c̈hjululla mekaz lujlz̈nalla. ");
INSERT INTO capNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jesusazti ninacz̈quiz cjichic̈ha: —Wejttac yekja lujlz z̈ejlc̈ha. Jalla nii lujlzqui anc̈hucqui anaz̈ pajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jalla nuz̈ chiitiquiztan niiz̈ tjaajintanacaqui ninacpora pewcsassic̈ha, tuz̈ cjican: —¿Jequit tiiz̈quiz lujlz c̈hjeri zjijcanchi cjesajo? ");
INSERT INTO capNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesusaqui ninacz̈quiz cjichic̈ha: —Wejrqui wejt cuchanz̈quiñiz̈ kuzcama kamuc̈ha. Niz̈aza niiz̈ pecta langz cumpluc̈ha. Jalla niic̈ha wejtta lujlz c̈hjeri cuntaqui. ");
INSERT INTO capNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Anc̈hucqui cjinc̈hucc̈ha, “Zkala ajzquinaqui pajkpic jiiz pjaltic̈ha”, jalla nuz̈ cjiñc̈hucc̈ha. Pero wejr anc̈hucaquiz cjiwc̈ha, “Nii z̈oñinacz̈quin cherzna. Pookchi zkalanacaz̈takaz ninacaqui. Ricujz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jakziltat nii pookchi zkalanaca ricujac̈haja, jalla niiqui pactaz̈ cjequic̈ha. Niz̈aza nii ricujta z̈oñinacaqui Yooztan wiñaya kamaquic̈ha. Jalla niz̈tiquiztan zkala c̈hjacñimi ajzñimi nuz̈ chicapacha cuntintuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Tii zkala puntuquiztan chiitaqui werarapanc̈ha. Jalla tuz̈ cjic̈ha: “Zkala c̈hjacñiqui tsjiic̈ha. Niz̈aza zkala ajzñiqui yekjac̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Wejrqui anc̈huc cuchanz̈quichinc̈ha, ana amiz̈ trabajta zkala ricujzjapa. Yekjanacac̈ha nii zkalac trabajchi Yooz taku paljaycan. Anc̈hucqui nii trabajtiquiz yapzinc̈hucc̈ha, ultimquiziqui Yooztajapa ricujta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jalla nekztanaqui wacchi Samaria wajtchiz z̈oñinacaqui niiz̈quiz criichic̈ha, naa maatak z̈onaz̈ maztaz̈ cjen. “Niiqui tjapa weriz̈ kamta puntu zizza”, jalla nuz̈ cjican mazzinc̈ha naaqui. ");
INSERT INTO capNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Niz̈aza Jesusiz̈quiz tjonz̈cu, nii Samaria wajtchiz z̈oñinacaqui Jesusiz̈quiz rocchic̈ha, tuz̈ cjican: —Wejtnacatan kamt'alla. Nekztanaqui Jesusaqui ninacz̈tan puc maj kamchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jalla nuz̈ niiz̈ persuna tjaajintiquiztan iya juc'anti nii z̈oñinacaqui niiz̈quiz criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ninacaqui naa maatak z̈onaquiz tuz̈ cjichic̈ha: —Wejrnacqui criyuc̈ha. Anaz̈ amiz̈ maztiquiztankaz criyuc̈ha. Antiz niiz̈ taku persuna nonz̈cupan criyuc̈ha. Chekapan, tiiqui Yooz cuchanz̈quita Cristukalc̈ha, z̈oñinacz̈quiz liwriiñiqui. Anzil nii zizuc̈ha wejrnacqui, niiz̈ tjaajinta taku nonz̈cu. ");
INSERT INTO capNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Puc majquiztan Jesusaqui Galilea yokquin ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jalla nekztanaqui Jesusaqui tuz̈ chiichic̈ha: —Tsjii Yooz cuntiquiztan chiiñi profetaqui niiz̈ persun wajtchiz z̈oñinacz̈quiz ana rispittac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jalla nekztanaqui Galilea irantitan, nii z̈oñinacaqui Jesusa zuma risiwchic̈ha. Nii z̈oñinacaqui Jerusalén ojkchizakaztac̈ha, pascua pjijzta payi. Jalla nicju z̈ejlcan tjapa Jesusaz̈ paatanaca cherchic̈ha. Jalla niz̈tiquiztan nii z̈oñinacaqui Jesusa zuma risiwchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Galilea yokquin z̈ejlcan, Jesusaqui Caná cjita watja wilta ojkchic̈ha. Tuquiqui nii wajtquiz kjazquiztan vino tuckatchic̈ha. Tsjii pajk jilirz̈ secretariuqui Capernaum wajtquiz z̈elatc̈ha. Nii secretariuz̈ majchqui laatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jesusaz̈ Judea yokquiztan Galilea tjonchi quintu zizcu, nii secretariuqui Jesusa roqui ojkchic̈ha niiz̈ kjuyquin tjonz̈cajo, niz̈aza niiz̈ majch c̈hjetnajo. Niiz̈ majchqui ticzmayatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jalla nekztan Jesusaqui niiz̈quiz cjichic̈ha: —Anc̈hucqui sinalanacami milajrunacami ana cheraquiz̈ niiqui, ana criyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nekztan nii secretariuqui cjichic̈ha: —Señor, ima wejt majch ticznan wejt kjuyquin tjonz̈calla. ");
INSERT INTO capNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesusaqui nekztan cjichic̈ha: —Am kjuya quepa, am majchqui z̈etaquic̈ha. Nekztan nii secretariuqui jalla nuz̈ Jesusaz̈ chiitan nii criichic̈ha. Jalla nekztan kjuya quejpchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jalla nuz̈ niiz̈ kjuya okan, niiz̈ piyunanacaqui niiz̈quin zalz̈quichic̈ha, tuz̈ cjican: —Am majchqui z̈ejtchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jalla nuz̈ chiitiquiztan nii secretariuqui pewczic̈ha, c̈hjulora niiz̈ majch z̈eti kallantichi, jalla nii. Niiz̈ piyunanacaqui cjichic̈ha: —Zezcu taypuruz̈ paztanalla nii kjakñi ch'ujlñiqui apaltichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nii ejpqui cjuñzic̈ha, nii orapacha Jesusaqui cjichic̈ha, “Am majchqui z̈etaquic̈ha”. Jalla niz̈tiquiztan nii ejpqui tjapa kuztan Jesusiz̈quiz criichic̈ha, tjapa niiz̈ kjuychiz z̈oñinacz̈tanpacha. ");
INSERT INTO capNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea yokquiztan Galilea quejpz̈cu, Jesusaqui nii milajru paachic̈ha. Jalla niiz̈tanaqui pizc wilta milajru paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wiruñaqui judío z̈oñinacaqui pjijzta paatc̈ha. Jalla nuz̈ paan, Jesusaqui Jerusalén watja quejpz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén wajtquiz tsjii pajk zana z̈elatc̈ha, uuzi zana cjita. Jalla nii z̈cati tsjii z̈oñiz̈ paata cocha kjazjapa z̈elatc̈ha. Nii cochaqui Betesda cjitatac̈ha Hebreo tawkquiztan. Nii coch muytata pjijska kjuyallanaca z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Jalla nekzi wacchi laanaca z̈elatc̈ha, zuranaca, zuch z̈oñinaca, ana tsijtñinaca. Nii laa z̈oñinacaqui kjaz kizkiz tjewznatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Awiz awizaqui tsjii anjilaqui nii cochquiz tjoñic̈ha kjaz tjarñi. Jalla nuz̈ nii kjaz tjarnan, primera kjazquiz luzzi z̈oñiqui z̈ejtchi cjisñitac̈ha, c̈hjul laaquiztanami. ");
INSERT INTO capNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tsjii laa z̈oñiqui quinsa tunc quinsakalcun wata laa z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesusaqui nii laa z̈oñi cherchic̈ha. Nekztan Jesusaqui zizzi cjissic̈ha, nii z̈oñi az̈k watanaca laachitac̈ha, nii. Jalla nuz̈ zizcu nii laa z̈oñz̈quiz pewczic̈ha tuz̈ cjican: —¿Z̈ejtchi cjissim pecya? ");
INSERT INTO capNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nii laa z̈oñiqui kjaazic̈ha tuz̈ cjican: —Señor, anaz̈ jecmi tii kjaz tjarnan wejr luzkatñi z̈ejlc̈ha. Luz pecuc̈ha, pero yekjakaz wejt tuqui luzza, tii kjazquizqui. ");
INSERT INTO capNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nekztanaqui Jesusaqui niiz̈quiz cjichic̈ha: —Z̈aazna, am tjajz zquiti apta, ojklaya. ");
INSERT INTO capNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jalla nii orapacha z̈ejtchi cjissic̈ha. Niiz̈ tjajz zquiti aptiz̈cu ojkchic̈ha. Jeejz tjuñquiz nii c̈hjetintaqui watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jalla niz̈tiquiztan judío z̈oñinacaqui nii c̈hjetinta z̈oñz̈quiz tuz̈ chiiz̈inchic̈ha: —Jeejz tjuñquiziqui, anac̈ha tjajz zquiti joojooz cjitaqui. Lii quintrala niiqui. ");
INSERT INTO capNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nii c̈hjetinta z̈oñiqui tuz̈ kjaazic̈ha: —Jalla nii wejr c̈hjetiñi z̈oñiqui wejr mantichic̈ha, tuz̈ cjican: “Tjajz zquiti aptiz̈cu, oka”. Jalla nuz̈ cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nii judío z̈oñinacaqui pewczic̈ha tuz̈ cjican: —¿Ject amquiz nuz̈ cjichejo, “Tjajz zquiti aptiz̈cu oka”, cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jesusaqui nii oraqui walja nekz z̈ejlñi z̈oñinacz̈ taypiquiztan katchic̈ha. Jalla niz̈tiquiztan nii z̈oñiqui ana pajchic̈ha, ject nii c̈hjetinc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Niiz̈ wiruñ Jesusaqui nii laaquiztan z̈ejtchi z̈oñz̈tan zalchic̈ha timpluquin. Nekztan niiz̈quiz cjichic̈ha: —Jila, amqui z̈ejtchamc̈ha. Jaziqui ana wilta uj paaquic̈ha. Uj paaquiz̈ niiqui, amquiz juc'ant anawalim cjisnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jalla nekztanaqui nii z̈oñiqui judío z̈oñinacz̈quin mazñi ojkchic̈ha, Jesusac̈ha nii c̈hjetiñi z̈oñiqui, jalla nii mazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nii Jesusaz̈ niz̈ta jeejz tjuñquiz c̈hjetintiquiztan judío z̈oñinacaqui Jesusiz̈ quintra cjissic̈ha; conz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ninacz̈quiz Jesusaqui tuz̈ cjichic̈ha: —Wejt Yooz Ejpqui tiraz̈ langz̈a, wejrmi niz̈tapachal langznuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jalla niz̈ta chiitiquiztan nii judío z̈oñinacaqui juc'ant z̈awjchic̈ha, niz̈aza juc'anti conz pecatc̈ha. Jesusaqui jeejz tjuñquiz ana permitta langz mantichic̈ha, judío z̈oñinacz̈ lii quintra. Niz̈aza “Yooz Ejpc̈ha wejt persun Ejpqui” cjican chiichic̈ha. Nuz̈ cjican “Wejrmi Yoozzakaztc̈ha” cjichic̈ha. Jalla niz̈tiquiztan nii judío z̈oñinacaqui Jesusiz̈ quintra juc'anti aptichic̈ha, conzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Niz̈aza Jesusaqui tuz̈ cjichic̈ha: —Anc̈hucaquiz weraral chiyuc̈ha. Wejrtc̈ha Yooz Majchqui. Pero persun kuzcama anal paasac̈ha. Yooz Epiz̈ tjaata obranacal paa-uc̈ha. Jaknuz̈t Yooz Ejpqui obra paac̈haja, jalla nuz̈uzakaz wejr Yooz Majchqui obra paa-uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yooz Ejpqui wejr k'aachic̈ha, niz̈aza tjapa niiz̈ paata obranacami wejtquiz tjeez̈a. Niz̈aza Yooz Ejpqui juc'anti pajk obranacaz̈ tjeeznaquic̈ha, anc̈huc ispantichi cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jaknuz̈t Yooz Ejpqui ticzinaca jacatatskatc̈haja, niz̈aza wilta z̈eti tjaac̈haja, jalla niz̈ta zakaz wejrqui z̈eti tjaac̈ha, wejt munañpicama. ");
INSERT INTO capNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yooz Ejpqui persunpacha ana casticu tjaac̈ha. Pero wejtquiz tjapa niiz̈ mantiz poder intirjichic̈ha castictu tjaazjapa. ");
INSERT INTO capNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jalla nuz̈ intirjichic̈ha, tjapa z̈oñinaca wejtquiz rispitajo, jaknuz̈t Yooz Ejpz̈quin rispitc̈haja, jalla nuz̈. Jakziltat wejtquiz ana rispitc̈haja, jalla niiqui wejr cuchanz̈quiñi Yooz Ejpz̈quin ana zakaz rispitc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‛Anc̈hucaquiz weraral chiyuc̈ha. Jakziltat weriz̈ chiita taku nonz̈cu tjapa kuztan catokc̈haja, niz̈aza wejr cuchanz̈quiñiz̈quiz kuz tjaac̈haja, jalla niiqui Yooztan wiñaya kamc̈ha. Niz̈aza ana casticta cjequic̈ha. Infiernuquin ojkñi jiczquiz eccu, arajpach ojkñi jiczquiz kamc̈ha, Yooztan wiñaya kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Anc̈hucaquiz weraral chiyuc̈ha. Tsjii timpu tjonc̈ha, niz̈aza anzimi nii timpuc̈ha. Anziqui ticziz̈takaz kamñi z̈oñinacaqui wejt taku nonznaquic̈ha. Jakziltat wejt taku nonz̈cu tjapa kuztan catokac̈haja, jalla niiqui ew kamañchiz kamaquic̈ha. Yooz Majchtc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yooz Ejpqui persunpacha z̈ejtkatz poderchizza. Niz̈aza wejt Yooz Ejpqui nii poder wejtquiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jalla niz̈tiquiztan Yooz Ejpqui pjalz puestuquiz wejr utchic̈ha. Jaziqui arajpachquin kamzmi niz̈aza infiernuquin casticzmi jalla nii mantiznaca wejtquiz intirjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tii weriz̈ chiitiquiztan ana ispanta. Tsjii timpu tjonc̈ha. Jalla nii timpuquiz tjapa ticzinacaqui wejt joraz̈ nonznaquic̈ha. Nekztan sipulturquiztanz̈ z̈aaznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Zuma kamchinacaqui jacatataquic̈ha Yooztan wiñaya kamzjapa. Ana zuma kamchinacazti jacatataquic̈ha infiernuquin casticta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‛Wejrqui persun kuzquiztanac anal pjalznasac̈ha. Jaknuz̈t wejt Yooz Ejp mantic̈haja, jalla niicamal pjalznuc̈ha. Anal wejt kuzquiztan pjalz pecuc̈ha. Antiz wejr cuchanz̈quiñiz̈ kuzcama pjalz pecuc̈ha. Jalla niz̈tiquiztan weriz̈ pjaltaqui lijitumac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Wejrkal persunpacha wejt favora chiyasaz̈ niiqui, weriz̈ chiita taku anaz̈ walasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero yekja tisticu wejt favora z̈ejlc̈ha. Jalla niic̈ha Yooz Ejpqui. Niiz̈ wejt puntuquiztan chiita takuqui werarapanc̈ha. Jalla nii zizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Anc̈hucqui Juanz̈quin pewczñi cuchanz̈quichinc̈hucc̈ha wejt puntuquiztan. Niiz̈ kjaaztaqui werarapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Z̈oñiz̈ wejt favora werara chiiñiz̈ cjenami, wejtquiz anaz̈ ancha importic̈ha. Yooz Ejpc̈ha wejt favora ultim werara chiiñiqui. Nuz̈ cjiwc̈ha, anc̈huc wejtquiz criyajo, anc̈huc liwriita cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanqui tsjii tjeezta lamparaz̈takaz kjanatc̈ha. Jalla nuz̈ kjancan nii Juanqui wejt puntu kjanzt'ichic̈ha. Niz̈aza tsjii upacamakaz niiz̈ kjanquiz anc̈hucqui cuntintu kamchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Juanqui wejt favora chiichic̈ha. Pero tsjiiqui z̈ejlc̈ha Juanz̈quiztan juc'anti. Jalla niic̈ha Yooz Ejpqui. Niiqui wejt favora zakaz chiic̈ha. Niz̈aza wejt Yooz Ejpqui wejr mantichic̈ha obranaca cumplizjapa. Tii obranacquiztan wejr pajtapan cjesac̈ha, Yoozquiztan tjonchin, ana Yoozquiztan tjonchin, nii. Tii weriz̈ paata obranaca kjanapacha tjeez̈a, Yooz Epiz̈ wejr cuchanz̈quita, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Wejr cuchanz̈quiñi Yooz Ejppacha wejt favora chiic̈ha. Anc̈hucqui niiz̈ persun jora ana nonznasac̈ha niz̈aza niiz̈ tsiti ana cherasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Yooz Ejpqui wejr cuchanz̈quichic̈ha. Pero anc̈hucqui wejtquiz ana criic̈ha. Jalla niz̈tiquiztan niiz̈ takumi anc̈huca kuzquiz ana zakaz catokc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Anc̈hucqui cjijrta Yooz taku anchaz̈ istutiic̈ha. Nekztan anc̈hucqui tantiic̈ha, “Yooz taku istutiichiz̈ cjen wejrnacqui Yooztan wiñaya kamaka,” cjican. Pero nii cjijrta Yooz takunacaqui wejt puntuquiztanz̈ chiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jalla nuz̈ istutiiz̈cupacha, anc̈huczti anaz̈ wejtquiz macjatz pecc̈ha, Yooz Ejpz̈tan wiñaya kamzjapaqui. ");
INSERT INTO capNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‛Z̈oñinacaz̈ tjaata honora wejtquiz anaz̈ importic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ultimu anc̈hucqui ana Yoozquin kuzzizc̈hucc̈ha. Nii zizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Wejt Yooz Ejpz̈ cuntiquiztan tjonchi cjenami, anc̈hucqui anaz̈ wejr criic̈ha. Pero yekja z̈oñiqui persun kuzcama anc̈hucaquiz tjonasaz̈ niiqui, niiz̈quiz criyasaz̈, jaz. ");
INSERT INTO capNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Anc̈hucqui anc̈hucporaz̈ honorchiz cjeyas pecc̈ha. Anc̈hucqui Yooziz̈ tjaata honorchiz cjisjapa anaz̈ importic̈ha. Jaziqui, ¿jaknuz̈t anc̈huc wejr criyasajo? ");
INSERT INTO capNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Anc̈hucqui Moisés liiquiz kuz tjaachiz̈ cjen, pinsaquic̈ha, Yooztan wiñaya kamaka, jalla nii. Pero nii Moisespacha anc̈huca ujnacaz̈ tjeeznaquic̈ha, Yooz Ejpz̈ yujcquiziqui. Anac̈ha wejrqui Yooz Ejpz̈ yujcquiz anc̈huca ujnaca tjeezniñtqui. ");
INSERT INTO capNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisesqui wejt puntuquiztan cjijrchic̈ha. Jalla niz̈tiquiztan anc̈hucqui Moisés cjijrta criitasaz̈ niiqui, wejtquiz zakaz criitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Anc̈hucqui nii Moisés cjijrtanaca ana criic̈haj niiqui, ¿jaknuz̈ weriz̈ chiitanaca criyasajo? ");
INSERT INTO capNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jalla nuz̈ chiiz̈cu Jesusaqui Galilea cjita kotz̈ nawjctuñtan ojkchic̈ha. Nii kotaqui Tiberias, cjitazakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Walja z̈oñinacaqui niiz̈quin apzic̈ha, milajrunaca paañi cherz̈cu niz̈aza laanaca c̈hjetinchi cherz̈cu. ");
INSERT INTO capNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Pero Jesusaqui tsjii curu yawchic̈ha niiz̈ tjaajintanacz̈tan. Jalla nicju julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Nii oraqui judío z̈oñinacz̈ pascua pjijzta z̈catitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Acha waytiz̈cu, Jesusaqui walja z̈oñinaca apz̈quiñi cherchic̈ha. Nekztanaqui Felipz̈quiz paljaychic̈ha, tuz̈ cjican: —¿Jakziquiztan lujlz c̈hjerinaca kjayz̈caqui, tii tama z̈oñinacz̈quiz luli tjaazjapaya? ");
INSERT INTO capNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesusaqui nuz̈ chiichic̈ha Felipe yanzjapa, jaknuz̈t kjaazñi, jalla nii. Nii ora Jesusa persun kuzquiz zizatc̈ha, jaknuz̈t nii z̈oñinaca luli tjaac̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nekztanaqui Felipiqui kjaazic̈ha, tuz̈ cjican: —Paa patac pajk paaz walurchiz t'anta anaz̈ alcansasac̈ha, zapa mayni zkoluccama lujlz cjenami. ");
INSERT INTO capNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tsjii tjaajintaqui, Andrés, cjitatac̈ha, Simón Pedruz̈ lajk. Jalla niiqui tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Tekz tsjii uza z̈ejlc̈ha, pjijska siwat t'antichiz, pizc ch'izziz. Pero ¿tama z̈oñinacz̈quiz wacas teejo? ");
INSERT INTO capNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nekztanaqui Jesusaqui mantichic̈ha: —Tjappacha nii z̈oñinaca, julznajo. Jalla nii yokaqui walja pastu yokatac̈ha. Nekziqui tsjii pjijska warank luctak z̈oñinaca julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jalla nekztanaqui Jesusaqui nii t'anta tanz̈cu, Yoozquin gracias cjican cjichic̈ha. Nekztanaqui tjaajintanacz̈quin tjaachic̈ha. Jalla nii tjaajintanacaqui partir paychic̈ha nii julzi z̈oñinacz̈quiz. Nuz̈uzakaz nii pizc ch'iztan tojz̈cu, lujlkatchic̈ha, jaknuz̈t zapa mayni pecatc̈haja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jalla nuz̈ nii z̈oñinacaz̈ chjekchiz̈ cjen, Jesusaqui niiz̈ tjaajintanaca mantichic̈ha, tuz̈ cjican: —Nii z̈ejtchi t'unanaca ricuja, ana c̈hjulumi pertita cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nekztanaqui z̈oñinacaz̈ lujlz z̈erz̈tan, niiz̈ tjaajintanacaqui nii pjijska siwat t'antiquiztan z̈ejtchinaca ricujchic̈ha. Tuncapan canasta chjijpi ricujchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Nekz z̈ejlñi z̈oñinacaqui Jesusiz̈ paata milajru cherz̈cu, tuz̈ cjichic̈ha: —Chekapani, tiikalala nii tjonñi profetaqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesusaqui ninacz̈ kuzquiz naychic̈ha. Ninacaqui Jesusa pjorzaz̈ majkz pecatc̈ha, ninacz̈ chawc jiliri cjeyajo. Jalla niz̈tiquiztan Jesusaqui ninacz̈quiztan zarakz̈cu cur punt kjutñi yawchic̈ha, zina z̈ejlzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Tjuñiz̈ kattan niiz̈ tjaajinta z̈oñinacaqui kot atquin chjijwz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nii curquiztan chjijwz̈cu warcuquiz luzzic̈ha, Capernaum watja irantizjapa. Jalla nekztanaqui kotquiz oki kallantichic̈ha. Ween zumchitac̈ha. Jesusaqui imapanz̈ ninacz̈quin tjonatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kotquiz okan tsjii pjursant tjamiqui tjamz̈quichic̈ha. Jalla niz̈tiquiztan kjaz ljojkjinacaqui waljaz̈ ljojkinz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tsjii tupu zkoluc jilalla ojkchiz̈ cjen, ninacaqui Jesusaz̈ warcuquin z̈catz̈inz̈quiñi cherchic̈ha. Jesusaqui kjaz juntuñ tjonatc̈ha. Pero Jesusiz̈quiz ana pajatc̈ha nii zumchiquiz cjen. Jalla nekztan ninacaqui ancha tsucchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Nekztan Jesusaqui ninacz̈quiz tuz̈ cjichic̈ha: —Werjtc̈ha. Anac̈ha tsuca. ");
INSERT INTO capNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jalla nuz̈ chiitiquiztan ninacaqui Jesusa warcuquiz cuntintu luzkatchic̈ha. Kot taypiquiztac̈ha. Pero nii ratupacha kot atquin cjissic̈ha, jakzi wajtquin okatc̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Jakataz̈uqui nii kotz̈ nawjctuñtan ecta z̈oñinacaqui Jesusa ana cherchic̈ha. Zezcu zeztan tsjii warcukaz z̈elatc̈ha. Jesusaqui warcuquiz ana luzzic̈ha. Niiz̈ tjaajinta z̈oñinacakaz warcuquiz ojkchic̈ha. Pero jakziquin Jesusaqui z̈elatc̈haja, ana zizzic̈ha nii ecta z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nekztan yekja warcunacaqui irantiz̈quichic̈ha Tiberias cjita wajtquiztan. Jakziquin nii z̈oñinaca t'anta lujlchiz̈laja, jalla nicju irantiz̈quichic̈ha. Ima lujlkatcan, Jesús Jiliriqui Yoozquin parlichic̈ha gracias cjican. ");
INSERT INTO capNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Nekzi ecta z̈oñinacaqui Jesusami niiz̈ tjaajintanacami ana nekz cherz̈cu warcunacquiz luzzic̈ha. Capernaum watja ojkchic̈ha Jesusa kjuri. ");
INSERT INTO capNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kot tsjii latuquin irantiz̈cu, z̈oñinacaqui Jesusiz̈tan zalchic̈ha. Jalla nuz̈ zalz̈cu niiz̈quiz pewczic̈ha tuz̈ cjican: —Tjaajiñi Maestro, ¿c̈hjulora tekz irantiz̈quichamtajo? ");
INSERT INTO capNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Anc̈hucaquiz ultim weraral chiiz̈inuc̈ha. Zezcu anc̈hucqui t'anta lujlchinc̈hucc̈ha chjekjañcama. Jalla niz̈tiquiztanz̈ anc̈hucqui wejr kjurc̈ha. Weriz̈ paata milajru anaz̈ intintazza anc̈hucqui. Jalla niiz̈ intintaztasaz̈ niiqui anaz̈ wejr kjurtasac̈ha c̈hjeri lujlzjapakaz. Antiz wejr kjurtasac̈ha, Yooz puntu tsjan zizjapa. ");
INSERT INTO capNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Anac̈ha miranzñi c̈hjerquinaqui kuz tjaazqui. Tsjii ratujapakazza niiqui. Antis ana miranzñi Yooz c̈hjerquiñc̈ha kuz tjaa. Yooz Ejpz̈tan wiñaya kamzjapac̈ha niiqui. Nii Yooz c̈hjeriqui wejrqui anc̈hucaquiz tjaasac̈ha. Yooz Ejpqui niijapa wejr utchipanc̈ha. Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jalla nekztanaqui nii z̈oñinacaqui pewczic̈ha tuz̈ cjican: —¿C̈hjulu obranacat paaz waquisasaya, Yooz munañpa cumplisjapaya? ");
INSERT INTO capNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Yooz cuchanz̈quita Z̈oñz̈quiz kuz tjaa; niiz̈quiz criya. Jalla niic̈ha Yooz munañpaqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nekztanaqui ninacaqui cjichic̈ha: —¿Amqui c̈hjul milajrum tjeeznas, wejrnac cherzjapajo? Nekztan amquin criyasac̈ha. ¿C̈hjul obram paa-as? ");
INSERT INTO capNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Uc̈hum tuquita atchi ejpnacaqui ch'ekti yokquin maná cjita c̈hjeri lujlchic̈ha. Niz̈aza nii puntuquiztan Yooz tawk libruquiz tuz̈ cjijrtac̈ha: “Moisesqui ninacz̈quiz arajpachquiztan tjonñi c̈hjeri tjaachic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jalla nuz̈ chiitiquiztan Jesusaqui tuz̈ kjaazic̈ha: —Anc̈hucaquiz ultim weraral chiiz̈inuc̈ha. Moisesqui anc̈huca atchi ejpnacz̈quiz c̈hjeri tjaachic̈ha. Pero Moisesqui anac̈ha tjaachiqui ultim werar arajpach t'anta c̈hjeriqui. Wejt Yooz Ejpc̈ha ultim werar arajpach t'anta c̈hjeri tjaachiqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jalla nii Yooziz̈ tjaata t'antaqui arajpachquiztan chjijwz̈quichic̈ha. Jalla niic̈ha tii muntuquiz z̈ejlñi z̈oñinacz̈quiz arajpach z̈eti tjaañiqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nekztanaqui ninacaqui Jesusiz̈quiz cjichic̈ha: —Señor, nii t'anta chjeri panz̈ tjaalla. ");
INSERT INTO capNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jalla nekztanaqui Jesusaqui tuz̈ cjichic̈ha: —Wejrtc̈ha arajpach z̈eti tjaañi t'antitqui. Jequit wejtquin tjonac̈haja jalla niiqui ana wira c̈hjeri eeczñiz cjequic̈ha; niz̈aza jequit wejtquiz criyac̈haja, jalla niiqui ana wira kjaz kjara pasñiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Tuqui wejrqui anc̈hucaquiz chiichinc̈ha, “Anc̈hucqui wejr cherz̈cumi wejtquiz ana criichinc̈hucc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yooz Ejpqui wejt mantuquiz cjisjapa z̈oñinaca intirjichic̈ha. Tjapa nii intirjita z̈oñinacaqui wejtquiz tjonaquic̈ha. Niz̈aza jakziltat wejtquiz tjonac̈haja, jalla niiqui ana weriz̈ c̈hjatkattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Wejrqui arajpachquiztan ana wejt persun kuzcama payi tjonchinc̈ha. Antiz wejrqui wejr cuchanz̈quiñi Yooz Ejpz̈ kuzcama payi tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Jalla tiic̈ha wejt Yooz Ejpz̈ kuzqui. Niiz̈ kuz tuz̈ pecc̈ha, wejr ana zinta niiz̈ intirjita z̈oñinaca pertiskatajo, niz̈aza ninaca jacatatskatajo. ");
INSERT INTO capNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Niz̈aza tiic̈ha wejt Yooz Ejpz̈ kuzqui. Niiz̈ kuz tuz̈ zakaz pecc̈ha, jequit wejr pajac̈haja, niz̈aza wejtquin criyac̈haja, jalla niiqui Yooztan wiñaya kamaquic̈ha. Niz̈aza wejrqui ninaca ticziquiztan jacatatskatac̈ha ultim juyzu pjalz tjuñquiziqui. Jalla nuz̈uc̈ha wejt Yooz Ejpz̈ kuzqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Tuqui Jesusaqui chiichic̈ha, tuz̈ cjican: —Wejrtc̈ha arajpachquiztan tjonchi t'antitqui. Jalla nii chiitiquiztan judío z̈oñinacaqui niiz̈ quintra chutchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ninacaqui cjichic̈ha: —¿Anaj tii Jesusac Jus maatejo? Uc̈humqui niiz̈ maa ejpz̈quiz̈ pajla. ¿Kjaz̈ tiizti “Arajpachquiztan tjonchinc̈ha” cjican chiyasajo? ");
INSERT INTO capNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jalla nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucqui anaz̈ nuz̈ wejt quintra chucha. ");
INSERT INTO capNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yooz Ejpqui wejr cuchanz̈quichic̈ha. Niz̈aza niic̈ha wejtquiz macjatskatñiqui. Jakziltat wejt Epiz̈ macjatskatta cjec̈haj niiqui jalla ninacakaz wejtquiz tjonasac̈ha. Anaz̈laj wejt Epiz̈ macjatskatz̈quitaqui, wejtquiz anaz̈ tjonasac̈ha. Niz̈aza jacatatz tjuñquiziqui wejtquiz criichinacaqui jacatatskatac̈ha, ninaca Yooztan wiñaya kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profetanacaqui tuquitan tuz̈ cjijrchic̈ha: “Yoozqui tjapa niiz̈ partir z̈oñinacz̈quiz tjaajnaquic̈ha”. Jalla niz̈tiquiztan jequit wejt Epiz̈ tjaajinta nonz̈aja, niz̈az̈a catokc̈haja, jalla niiqui wejtquiz tjonc̈ha, niz̈azaz̈ criic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‛Jalla nuz̈ wejt Yooz Epiz̈ tjaajinta cjenami, anaz̈ jecmi persun c̈hjujcz̈tan Yooz Ejp cherchiqui. Wejr alajac̈ha Yooz Ejp cherchintqui. Wejrqui Yooz Ejpz̈quiztan tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Anc̈hucaquiz ultim weraral chiyuc̈ha. Jequit wejtquiz criyac̈haja, jalla niiqui Yooztan wiñaya kamc̈ha; niz̈aza arajpachquin z̈ejtñiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Wejrtc̈ha arajpach z̈eti tjaañi t'antitqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Anc̈huca tuquita atchi ejpnacaqui ch'ekti yokquin maná cjita t'anta lujlchic̈ha. Pero nii t'anta lujlchiz̈ cjenami, ninacaqui ticzizakazza. ");
INSERT INTO capNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wejrtc̈ha arajpachquiztan tjonchi t'antitqui. Jequit wejt t'antiquiztan lulac̈haja, jalla niiqui Yooztan wiñaya kamaquic̈ha; arajpachquin z̈ejtñiz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Wejrqui arajpachquiztan tjonchinc̈ha. Jaziqui wejrpanc̈ha z̈eti tjaañi t'antitqui. Jequit tii t'antiquiztan lulac̈haja, jalla niiqui Yooztan chica wiñaya kamaquic̈ha. Tii wejt curpuqui t'anta cuntac̈ha. Wejt curpuqui tjaa-ac̈ha, tii muntuquiz z̈ejlñi z̈oñinaca Yooztan wiñaya kamajo. ");
INSERT INTO capNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jalla nuz̈ chiitiquiztanaqui nii judío z̈oñinacaqui ninacpora ch'aazi kallantichic̈ha, tuz̈ cjican: —¿Kjaz̈ tiiz̈ persun curpu uc̈hum lulajo tjaasajo? ");
INSERT INTO capNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesusaqui nekztanaqui cjichic̈ha: —Anc̈hucaquiz weraral chiyuc̈ha. Jequit anc̈hucaquiztan wejt curpu ana lulac̈haj niiqui, niz̈aza wejt ljoc ana licac̈haj niiqui, jalla niiqui anapanz̈ ultimu arajpach z̈ejtz wirchiz cjesac̈ha. Anapan Yooztan wiñaya kamasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jequit wejt curpu lulac̈haj niiqui, niz̈aza wejt ljoc licac̈haj niiqui, jalla niic̈ha Yooztan chica wiñaya kamñiqui. Niz̈aza nii z̈oñinacaqui tsjii tjonz tjuñquiziqui weriz̈ jacatatskattaz̈ cjequic̈ha, Yooztan wiñaya kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Wejt curpuqui ultimu arajpachquin z̈ejtkatñi c̈hjeric̈ha. Niz̈aza wejt ljocc̈ha ultimu arajpachquin z̈ejtzjapa liczqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Jequit wejt z̈ejtkatñi curpu lujlc̈haja, niz̈aza wejt z̈ejtkatñi ljoc licc̈haja, jalla ninacac̈ha wejttan tsjii kuzzizqui. Niz̈aza wejrtc̈ha ninacz̈tan tsjii kuzzizqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Wejr cuchanz̈quiñi Yooz Ejpc̈ha arajpach z̈ejtñi kamañchizqui. Wejrmi niiz̈ cjen arajpach z̈ejtñi kamañchiztc̈ha. Niz̈aza jequit wejtquiztan lujlc̈haja, jalla niic̈ha weriz̈ cjen arajpach zejtñi kamañchizqui. ");
INSERT INTO capNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Wejrtc̈ha nii arajpachquiztan tjonchi t'antitqui. Jalla tii t'antaqui anac̈ha nii maná cjita t'anta irataqui. Nii maná t'anta lujlchiz̈ cjenami, anc̈huca tuquita atchi ejpnacaqui ticzic̈ha. Jequit tii wejt t'anta lulac̈haja, jalla niiqui arajpachquin wiñaya z̈etaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jalla nuz̈ Jesusaqui tjaajinchic̈ha Capernaum wajtquiz ajcz kjuyquiz. ");
INSERT INTO capNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jalla niz̈ta tjaajinta nonz̈cu walja niiz̈quiz apzñinacaqui tuz̈ cjichic̈ha: —Tii chiitaqui ch'amac̈ha intintazqui. ¿Jequit tiiz̈ tjaajintiz̈quiz criyasajo? ");
INSERT INTO capNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesusaqui persun kuzquiz zizzic̈ha, tsjii apzñi z̈oñinacaqui niiz̈ chiitiquiztan chutchic̈ha jalla nii. Jalla niz̈tiquiztan tuz̈ cjichicha: —¿Tii chiitiquiztan chuchya, wejtquiztan zarakz pecya? ");
INSERT INTO capNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tuquiqui arajpachquin wejr z̈elatc̈ha. Anc̈hucqui wejr wilta arajpachquin ojkñi cheraquiz̈ niiqui, nekztan ¿jaknuz̈t anc̈huc cjeequi? ");
INSERT INTO capNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Tsjii z̈oñiqui animuz̈ cjen z̈ejtc̈ha. Niiz̈ curpuqui curpukazza, ana wiñaya z̈ejtñic̈ha. Niz̈aza weriz̈ chiita takuqui anc̈huca animunaca arajpachquin z̈etñi cjiskatasac̈ha, Yooztan wiñaya kamajo. ");
INSERT INTO capNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Yekjapanacaqui anc̈hucaquiztan wejtquiz ana criic̈ha. Jesusaqui primirquiztanpacha zizzic̈ha, jequit niiz̈quin ana criichi cjec̈haja, jalla nii Niz̈aza zizzic̈ha, jequit niiz̈ quintra tarazuna paac̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jalla nekztanaqui Jesusaqui tuz̈ cjichic̈ha: —Wejrqui cjichinpanc̈ha, “Yooz Ejppankazza z̈oñinaca wejtquiz macjatskatñiqui, wejtquiz criizjapa. Jequit wejtquiz macjatz̈quichi cjec̈haja, jalla niiqui wejtquiz tjonc̈ha, niz̈aza criic̈ha. Pero jequit ana macjatz̈quichi cjec̈haja, jalla niiqui anapan wejtquiz tjonasac̈ha, criizjapa”. ");
INSERT INTO capNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jalla nekztanaqui walja nii apzñinacaqui Jesusiz̈quiztan zarakchic̈ha. Niiz̈tan chica ana iya ojklaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Nekztanaqui Jesusaqui niiz̈ tuncapan tjaajintanacz̈quiz pewczic̈ha, tuz̈ cjican: —¿Anc̈huczakaz zarakz pecya? ");
INSERT INTO capNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nekztanaqui Simón Pedruqui kjaazic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿jecz̈quin wejrnac okasajo? ¿Yooz puntu tjaajinta cjisjapajo? Am takunacakazza werara tjaajintaqui, jaknuz̈t Yooztan wiñaya kamc̈haja, nii. ");
INSERT INTO capNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Wejrnacqui amquiz criichinc̈ha. Niz̈aza zizñi cjissinc̈ha, amqui Yooz cuchanz̈quita Cristumpanc̈ha; wiñaya z̈ejtñi Yooz Ejpz̈ Maatimc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesusaqui nekztan tuz̈ cjichic̈ha: —Wejrqui anc̈huc illzinc̈ha, tuncapani. Jalla niz̈ta cjenami tsjii anc̈hucaquiztan diabluz̈ mantuquiz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jalla nuz̈ chiican Jesusaqui Judas Iscariote, niiz̈ puntuquiztan chiichic̈ha. Simonz̈ majchtac̈ha niiqui. Judasqui tuncapan illzta z̈oñinacz̈quiztanpachac̈ha. Niiqui tarasunaz̈cu, Jesusa intirjaquic̈ha quintra z̈oñinacz̈ kjarquiz. ");
INSERT INTO capNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jalla nekztanaqui Jesusaqui Galilea yokaran ojklaychic̈ha. Judea yokquin ana ojklayz pecatc̈ha. Jalla nicju judío z̈oñinacaqui Jesusa conz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Nii timpuqui tsjii judío z̈oñinacz̈ pjijztaqui z̈catitac̈ha. Nii pjijzta paazjapa chjujlla kjuyanaca kjuychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jalla niz̈tiquiztan Jesusiz̈ lajknacaqui niiz̈quiz paljaychic̈ha, tuz̈ cjican: —Ana tekz z̈ela amqui. Judea yokquin oka. Jalla nicju am apzñinaca z̈ejlc̈ha. Jalla ninacz̈quiz amiz̈ paata obranaca cherskata. ");
INSERT INTO capNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Jakziltami z̈oñinacz̈quiz persun poder cherskatz pecc̈haja, jalla niiqui anaz̈ chjojzacuñ obranaca paac̈ha. Jaziqui amqui obranaca paaz poderchizzamz̈laj niiqui, kjanapacham z̈oñinacz̈quiz tjeeznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jesusiz̈ lajknacami ana niiz̈quin criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucqui c̈hjulorami pjijzta okasac̈ha. Wejt ojkz oraqui imazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Tii muntuquiz z̈ejlñi z̈oñinacaqui anc̈hucatan ana chjaawjkatasac̈ha. Wejttanzti chjaawjkatc̈ha. Wejrqui kjanapacha tjeeznuc̈ha ninacaz̈ ana wali paatanaca. Jalla niz̈tiquiztan wejttan quintrac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anc̈huckaz pjijzta oka. Wejrqui anal okasac̈ha. Wejt ojkz oraqui imazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jalla nuz̈ chiiz̈cu, nii Galilea yokquin eclichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Niiz̈ lajknacaz̈ pjijzta ojktanaqui Jesusaqui chjojzacuñ ojkchizakazza, z̈oñinaca ana cherajo. ");
INSERT INTO capNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Judío z̈oñinacazti Jesusa kjurchic̈ha nii pjijzta paañi z̈oñinacz̈porquiz, tuz̈ cjican: —¿Jakziquin nii z̈oñi z̈elasaya? ");
INSERT INTO capNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Wacchi nii pjijztiquin z̈ejlñi z̈oñinacaqui Jesusiz̈ puntu parlatc̈ha. Yekjap z̈oñinacaqui cjetc̈ha: “Niic̈ha zuma z̈oñiqui”. Yekjap z̈oñinacazti cjetc̈ha: “Niic̈ha ana zuma z̈oñiqui. Z̈oñinacz̈quiz tsjii kjutñi tjaajincan incallñic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero judío jilirinaca ekscu, anaz̈ jecmi Jesusiz̈ favora cuza kjana parlatc̈ha, antiz jamazitz̈ parlatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pjijzta taypi cjisnan, Jesusaqui timpluquin luzcu tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jesusaz̈ nuz̈ tjaajnan judío z̈oñinacaqui ispantichic̈ha, tuz̈ cjican: —¿Kjaz̈ tii z̈oñiqui zizñi zizñi tjaajnasajo, ana instutiiz̈cojo? ");
INSERT INTO capNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jalla nuz̈ nii judío z̈oñinacaz̈ parlitiquiztan Jesusaqui tuz̈ kjaazic̈ha: —Weriz̈ tjaajintaqui anac̈ha wejt kuzquiztan jwesta. Antiz wejr cuchanz̈quiñiz̈ kuzquiztan tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jakziltat Yooz kuzcama kamz pecc̈haj niiqui, nii z̈oñiqui zizaquic̈ha, weriz̈ tjaajintaqui Yoozquiztan tjonchic̈ha, nii. Anac̈ha wejt persun kuzquiztan tjonchiqui. ");
INSERT INTO capNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jakziltat persun kuzcama tjaajinc̈haja, jalla niiqui persun honorakaz waytiz pecc̈ha. Pero wejrqui Yooz kuzcama tjaajnuc̈ha. Yooz Ejpqui wejr cuchanz̈quichic̈ha. Jaziqui Yooz honora waytiz pecuc̈ha. Weriz̈ tjaajintami kamtami Yooz kuzcamapankazza. Werarapanc̈ha. Ana zinta toscara chiyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","‛Moisesqui anc̈hucaltajapa lii ecchic̈ha, ¿ana jaa? Jalla nuz̈ ecchiz̈ cjenpacha, anaz̈ jecmi anc̈hucaquiztan nii lii jaru kamchinc̈hucc̈ha. ¿Kjaz̈tiquiztan anc̈hucqui wejr conz pecjo, anc̈huca lii quintrajo? ");
INSERT INTO capNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jalla niz̈tiquiztan nii z̈oñinacaqui kjaazic̈ha tuz̈ cjican: —Amqui zajraz̈ tantamc̈ha. ¿Ject am conz pecjo? ");
INSERT INTO capNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesusaqui ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Tsjii pajk obra paachinc̈ha jeejz tjuñquiz. Jalla niz̈ta paatiquiztan anc̈hucqui ispantichinc̈hucc̈ha. Pero weriz̈ paata obra ana intintazzinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nonz̈na. Moisesqui janchiquiz chimpuz cuzturumpi anc̈hucaquiz mantichic̈ha. Primirquiztanpacha anc̈huca atchi ejpnacatac̈ha nuz̈ mantichiqui. Wiruñaqui Moisés zakaz nuz̈ mantichic̈ha, nii jaru. Jalla niz̈tiquiztan anc̈hucqui nii lii jaru z̈oñz̈ janchiquiz chimputa cjiskatiñc̈hucc̈ha, jeejz tjuñquizimi. ");
INSERT INTO capNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Moisés lii rispittapanz̈ cjisjapa, anc̈hucqui jeejz tjuñquiz cjenami z̈oñz̈ janchiquiz chimputa cjisiñc̈hucc̈ha. Jalla niz̈tiquiztan ¿kjaz̈tiquiztan anc̈hucqui wejt quintra z̈awj-jo, weriz̈ jeejz tjuñquiz z̈oñz̈ curpu c̈hjetintiquiztanajo? ");
INSERT INTO capNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Anc̈hucqui, Yooz kuzmi niz̈aza z̈oñz̈ kuzmi ana zizcuqui, anac̈ha uj jwez peczqui. Ujchiz jwez peccuqui zuma ujchiz jwezpanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jalla nekztanaqui yekjap Jerusalén z̈ejlñi z̈oñinacaqui pewczic̈ha, tuz̈ cjican: —Tiic̈ha nii conz pecta z̈oñi, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero tekz z̈ejl-la, anaz̈ chjojzacuñ tjaajinla; kjanaz̈ tjaajinla. Niiz̈ quintra z̈oñinacaqui ana kjaz̈mi cjila. Jaziqui, ¿jilirinacami pajkay, tiiqui Yooz cuchanz̈quita Cristokay? Anapanz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wejrnacqui zizuc̈ha, jakziquiztan tii z̈oñi tjonchiz̈laja, jalla nii. Pero Cristuz̈ tjonz̈cuqui anaz̈ jecmi zizaquic̈ha jakziquiztan tjonc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jalla nekztanaqui Jesusaqui timpluquin tjaajincan, alto tawkz̈tan tuz̈ cjichic̈ha: —Anc̈hucqui cjiñchucc̈ha, nii z̈oñi pajuc̈ha, niz̈aza jakziquiztan tjonchiz̈laja, nii. Ultimu anc̈hucqui wejr ana pajc̈ha. Wejrqui persun kuzquiztan ana tjonchinc̈ha. Antiz cuchanz̈quita tjonchinc̈ha. Nii wejr cuchanz̈quiñiqui zuma lujitumac̈ha. Niz̈aza anc̈hucqui nii ana pajc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Pero wejrqui niiz̈quiztan tjonuc̈ha. Niz̈aza niiqui wejr cuchanz̈quichic̈ha. Jalla niz̈tiquiztan wejrqui nii pajuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jalla niz̈ta chiitiquiztan ninacaqui preso tanz pecatc̈ha. Jesusiz̈ preso tanta cjis oraqui imazitac̈ha. Jalla niz̈tiquiztan ana jakziltami tanzñi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jalla nuz̈ tanz pecñi z̈oñinaca z̈elanami walja z̈oñinacaqui Jesusiz̈quin criichic̈ha. Nii criichinacaqui tuz̈ cjichic̈ha: —Yooz cuchanz̈quita Cristo tjonz̈cuqui, ¿tii z̈oñz̈quiztan juc'ant cuza milajrunaca paasajo? ");
INSERT INTO capNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jalla nekztanaqui fariseo z̈oñinacaqui Jesusiz̈ puntu chiitanaca nonz̈cu, ninacaqui timplu jilirinacz̈tanpacha Jesusa preso tani zultatunaca cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jalla niz̈tiquiztan Jesusaqui cjichic̈ha: —Wejrqui tsjii kjaz̈ jiizkal anc̈hucatan z̈elac̈ha, jalla nekztan wejr cuchanz̈quiñiz̈quin quepac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Jalla nekztan anc̈hucqui wejr kjuraquic̈ha. Jalla nuz̈ kjurcan anaz̈ wejr wachi ataquic̈ha. Niz̈aza anc̈hucqui anaz̈ oki atasac̈ha, jakziquint wejr z̈elac̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jalla nekztanaqui nii judío z̈oñinacaqui ninacpora pewcsassic̈ha, tuz̈ cjican: —¿Jakziquint tii okas, ana watz̈ta cjisjapajo? ¿Yekja yokquin kamñi judío z̈oñinacz̈quin niz̈aza nekz z̈ejlñi z̈oñinacz̈quin okas teejo, ninacz̈quin tjaajinzjapajo? ");
INSERT INTO capNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿C̈hjulut tiiz̈ chiitac cjes? “Anc̈hucqui wejr kjuraquic̈ha, pero wejr ana wachi ataquic̈ha”, cjican. Niz̈aza “Anc̈hucqui anaz̈ oki atasac̈ha, jakziquint wejr z̈elac̈haja, jalla nicju” cjican. Jalla nuz̈ chiyanaqui, ¿c̈hjulut cjes? ");
INSERT INTO capNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jalla nekztanaqui pjijzta tucuz̈inz̈ tjuñquiziqui wali chawc tjuñitac̈ha. Jalla nii tjuñquiziqui Jesusaqui tsijtscu, alto tawkz̈tan paljaychic̈ha: —Jakziltat kjaz kjara passaja, jalla niiqui wejtquiz macjatz̈ca, wejt wiñaya z̈ejtkatñi kjaz liczjapa. ");
INSERT INTO capNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Jequit wejtquiz criyac̈haja, jalla niiz̈ kuzquiztan walja zumanaca ulnaquic̈ha jaknuz̈t tsjii zuma jalzurquiztan zuma kjaznaca ulanc̈haja, jalla niz̈ta. Jalla nuz̈ Yooz tawk libruquiz cjijrtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jalla nuz̈ chiican Jesusaqui Espíritu Santuz̈ puntuquiztan chiichic̈ha. Wiruñaqui Yooz Espíritu Santuqui Jesusiz̈quiz criichinacz̈ kuzquiz luzaquic̈ha. Pero Jesusaqui imaz̈ ticznatc̈ha, niz̈aza imaz̈ tsewc arajpacha okatc̈ha. Jalla niz̈tiquiztan imazitac̈ha Espíritu Santo tjaataqui. ");
INSERT INTO capNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Jalla nuz̈ Jesusaz̈ chiita nonz̈cu yekjap z̈oñinacaqui cjichic̈ha: —Chekapan tiic̈ha nii tjonñi profetaqui. ");
INSERT INTO capNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Yekjapazti tuz̈ cjichic̈ha: —Tiic̈ha Yooziz̈ cuchanz̈quita Cristuqui. Yekjapanacaqui cjichic̈ha: —¿Kjaz̈ Galilea z̈oñinacz̈quiztan Cristuc nasasajo? Anaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","“Cristuqui Davidz̈ majchmajtquiztan naspanc̈ha, niz̈aza Belén cjita wajtquin nasaquic̈ha. Nii watjaqui Davidz̈ watja cjitac̈ha”. Jalla nuz̈ cjic̈ha Yooz takuqui. ");
INSERT INTO capNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jalla nuz̈ parliz̈cu nii z̈oñinacaqui t'aka t'aka cjissic̈ha, Cristuz̈ puntuquiztan ch'aazcu. ");
INSERT INTO capNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Yekjapanacaqui Jesusa preso tanz pecatc̈ha. Jalla nuz̈ peccanami, ana jaknuz̈umi payi atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Timplu zultatunacaqui timplu jilirinacz̈quinami fariseonacz̈quinami quejpchic̈ha, ana Jesusa preso tani atz̈cu. Nii jilirinacaqui zultatunacz̈quiz cjichic̈ha: —¿Kjaz̈tiquiztan anc̈huc nii ana zjijcjo? ");
INSERT INTO capNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Nii z̈ultatunacaqui kjaazic̈ha, tuz̈ cjican: —Anaz̈ jecmi chiic̈ha, jaknuz̈t nii z̈oñi chiyatc̈haja, jalla nuz̈uqui. ¿Yooziz̈ cuchanz̈quita nii z̈oñejo? ");
INSERT INTO capNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jalla nekztanaqui fariseo z̈oñinacaqui tuz̈ cjichic̈ha: —¿Anc̈huczakaz incallskatchinc̈hucz̈, jaz? ");
INSERT INTO capNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tjapa uc̈hum jilirinacami niz̈aza tjapa fariseo z̈oñinacami niiz̈quinaqui ana criichipanla. ");
INSERT INTO capNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tii ana lii pajñi z̈oñinacaqui, jalla ninacakazza niiz̈quin criichiqui. Ninacaqui Yooziz̈ castictapanz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo cjitatac̈ha tsjiiqui ninacz̈quiztan. Tuquiqui ween chjojzacuñ Jesusiz̈quin zina ojkchic̈ha. Jalla niiqui ninacz̈quiz cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Uc̈hum liiqui tuz̈ cjic̈ha, “Tsjii z̈oñiqui ima casticta cjican, primero kjawz̈ta cjequic̈ha, niiz̈ persun razuna nonz̈ta cjisjapa”. Nuz̈ cjic̈ha uc̈hum liiqui, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nekztanaqui ninacaqui kjaazic̈ha tuz̈ cjican: —¿Am zakaz Galileaquiztanajo? Yooz taku istutiya. Anaz̈ jec profetaqui Galileaquiztan tjonasac̈ha. Jazim zizaquiz̈, jaz. ");
INSERT INTO capNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jalla nekztanaqui tjappacha persun kjuya ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesusaqui Olivos cjita curulla ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jakataz̈uqui kjantati timpluquin quejpz̈quichic̈ha. Tjapa nekz z̈ejlñi z̈oñinacaqui niiz̈quin tjonchic̈ha. Jesusaqui julz̈cu wilta tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jalla nuz̈ julzi tjaajnan, lii tjaajiñinacami fariseonacami tsjaa maatak z̈on zjijcchic̈ha. Jalla naa maatak z̈onqui adulterio paachiz̈ cjen tanstkalc̈ha. Z̈oñinacaqui jalla nuz̈ tanz̈cu naa maatak z̈on Jesusiz̈ yujcquiz zjijcchic̈ha. Niz̈aza nii z̈ejlñi z̈oñinacz̈ taypiquiz tsijtskatchic̈ha naa z̈onqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nekztanaqui ninacaqui Jesusiz̈quiz tuz̈ paljaychic̈ha: —Tjaajiñi Maestro, taa maatak z̈onqui adulterio paañipacha tanassinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Moisés liiquiz tuz̈ mantitac̈ha, “Tiz̈ta adulteriuquiz cjicjiñi z̈oñinacaqui c̈hajc jawi conz cjitac̈ha”. Am, ¿kjaz̈um cjiy? ");
INSERT INTO capNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Jalla ninacaqui nuz̈ paljaychic̈ha, Jesusa kjaz cjiñit cjes, jalla nii zizjapa. Niz̈aza Jesusiz̈ chiitiquiztan ujchiz jwez pecatc̈ha, niiz̈ quintra tsjii uj tjojtunzjapa. Jalla nekztanaqui Jesusaqui pachpiquiz colz̈cu yokquiz cjijri kallantichic̈ha, niiz̈ loc'anz̈tan. ");
INSERT INTO capNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero ninacaqui tirapanz̈ Jesusiz̈quiz pewcnatc̈ha, “Am, ¿kjaz̈um cjii?” cjican. Jalla nekztan Jesusaqui zumpacha acha waytiz̈cu, ninacz̈quiz cjichic̈ha: —Anc̈hucaquiztan jakziltapiriz̈laj ana ujchiz, niiqui primiru taa maatak z̈onaquiz maztan c̈hajczkazza. ");
INSERT INTO capNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jalla nuz̈ chiiz̈cu wilta colz̈cu yokquiz tira cjijratc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jalla nuz̈ Jesusiz̈ chiitiquiztan nii z̈oñinacaqui persun ujquiztan sint'ichic̈ha. Nekztanaqui mayat mayat ch'uju ulñi kallantichic̈ha. Chawc z̈oñinacaz̈ primiraqui ulanchiqui. Nekztan tjappacha nii z̈oñinacaz̈ ulantan, Jesusaqui naa maatak z̈onatan, nuz̈ pucultankaz, eclichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jalla nekztanaqui Jesusaqui wilta acha waytichic̈ha. Anaz̈ jecmi z̈elatc̈ha. Naa maataka alajakaztac̈ha. Nekztan naaquiz cjichic̈ha: —Cullaca. ¿Jakziquin amquiz uj tjojtunñi z̈oñinacajo? ¿Ana jakziltami am castiqui atchikaya? ");
INSERT INTO capNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Naa maatak z̈onqui cjichinc̈ha: —Wejt Jiliri, anaz̈ jakziltami wejr castiqui atchic̈ha. Nekztanaqui Jesusaqui naaquiz cjichic̈ha: —Wejrmi anal am ujquiztan casticac̈ha. Jaziqui oka amqui, anam iya uj paaquic̈ha. —Nuz̈ pertunchic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wiruñaqui Jesusaqui z̈oñinacz̈quiz wilta paljaychic̈ha, tuz̈ cjican: —Wejrqui tii muntuquiz z̈ejlñi z̈oñinacz̈quiz zuma kamaña tjeeznuc̈ha, tsjii kjanaz̈takaz. Jakziltat wejt kamañ jaru kamac̈haja, jalla niiqui anawal zumchiquiz anaz̈ kamaquic̈ha. Niz̈aza nii zuma kamañchiz z̈oñinacac̈ha wiñaya Yooztan kamñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jalla nekztanaqui nii fariseo z̈oñinacaqui cjichic̈ha: —Am alaja am persunjapa chiic̈ha. Jalla niz̈tiquiztan anaz̈ walc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesusaqui kjaazic̈ha, tuz̈ cjican: —Tii weriz̈ chiitaqui wejt persunjapa cjenami walc̈ha. Wejrqui zizuc̈ha jakziquiztan tjontuc̈haja, niz̈aza jakzit wejr okac̈haja, jalla nii. Anchuczti anaz̈ nii zizza. ");
INSERT INTO capNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Anc̈hucqui z̈oñiz̈ pinsita jarukaz wejtquiz uj tjojtz pecc̈ha. Pero wejt kuz ana zizza. Wejrzti anal niz̈ta uj tjojtiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero weril tsjii z̈oñz̈quiz “Uj paachamc̈ha” cjeez̈ niiqui, wejrqui weraral chiyuc̈ha nii z̈oñiz̈ uj paañiz̈ cjen. Anal wejt kuzquiztankaz chiyuc̈ha. Wejr cuchanz̈quiñi Yooz Ejpz̈ kuzcamakal wejrmi chiyuc̈ha. Wejrmi wejt Yooz Ejpmi tsjiikaz chiyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Anc̈huca liiquiz tuz̈ cjijrtac̈ha: “Pucultan tistic z̈oñinacaqui tsjiikaz chiyaquiz̈ niiqui ninacz̈ chiitaqui walc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Wejrqui persun puntuquiztan chiyuc̈ha. Niz̈aza wejr cuchanz̈quiñi Yooz Ejpqui wejt puntuquiztan zakaz chiic̈ha. Jaziqui weriz̈ chiitaqui panz̈ walc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jalla nekztanaqui ninacaqui Jesusiz̈quin cjichic̈ha: —¿Jakziquint am Ejpjo? Jesusaqui tuz̈ kjaazic̈ha: —Anc̈hucqui wejr anaz̈ ultimu pajc̈ha, niz̈aza wejt Ejpmi anaz̈ pajc̈ha. Wejr ultimu pajc̈haj niiqui, wejt Ejp zakaz pajasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nuz̈ tjaajincan Jesusaqui timpluquiz z̈elatc̈ha. Jakziquin ofrenda utz cajanaca z̈elatc̈haja, jalla nekz z̈elatc̈ha. Nuz̈ z̈elan, anaz̈ jecmi Jesusa preso tanchic̈ha. Jesusa preso tanta cjis oraqui imazitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jalla nekztanaqui Jesusaqui wilta ninacz̈quiz cjichic̈ha: —Wejr okac̈ha. Jalla nekztanaqui anc̈hucqui wejr kjuraquic̈ha. Pero jakziquint wejr okac̈haja, jalla nicju anc̈hucqui anaz̈ oki atasac̈ha. Anc̈hucqui ticznaquic̈ha persun ujquiztan ana pertunta. ");
INSERT INTO capNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nekztanaqui nii judío z̈oñinacaqui cjichic̈ha: —Tiiqui chiic̈ha, “Jakziquint wejr okac̈haja, jalla nicju anc̈hucqui ana oki atasac̈ha”, cjicanz̈ chiic̈ha. ¿Tiiqui persunpacha curpu conasaya? ");
INSERT INTO capNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Nekztanaqui Jesusaqui tuz̈ cjichic̈ha: —Anc̈hucqui tii kozta yokchiz z̈oñc̈huckazza. Wejrzti tsewcta yokchiz z̈oñtc̈ha. Anc̈hucqui tii yokquiz z̈ejlñi z̈oñz̈ kuzcama kamiñc̈hucc̈ha. Wejrzti ana tii yokquiz z̈ejlñi z̈oñz̈ kuzcama kamiñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jalla niz̈tiquiztan wejrqui anc̈hucaquiz chiichinc̈ha, anc̈hucqui ticznaquic̈ha, persun ujquiztan ana pertunta. Ultimupan anc̈hucqui weriz̈ chiitaqui ana catokaquiz̈ niiqui, ticznaquic̈ha, persun ujquiztan ana pertunta. ");
INSERT INTO capNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jalla nekztanaqui ninacaqui pewczic̈ha, tuz̈ cjican: —¿Jequimt amjo? Jesusaqui tuz̈ kjaazic̈ha: —Jaknuz̈t wejt persun puntuquiztan chiintc̈halaja, jalla niz̈ta z̈oñtpanc̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Anc̈huca puntuquiztan wejtta walja chiiz z̈ejlc̈ha, anc̈huca uj tjeezjapa. Pero wejt chiizqui anac̈ha wejt kuzquiztanqui. Antiz wejr cuchanz̈quiñiz̈ kuzcamapankazza. Wejr cuchanz̈quiñiqui werara chiiñipanc̈ha. Wejrqui niiz̈quiztan nonz̈tanaca maznuc̈ha tii muntuquiz z̈ejlñi z̈oñinacz̈quiz. Jalla niz̈tiquiztan weriz̈ chiitaqui anc̈huca puntuquiztan ultim werarac̈ha. —Jalla nuz̈ chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jalla nuz̈ Yooz Ejpz̈ puntuquiztan chiyan, nii judío z̈oñinacaqui ana intintazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jalla nekztan Jesusaqui cjichic̈ha: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. C̈hjulorat anc̈hucqui wejr tsewcchuc waytita cherac̈haja, jalla nii ora anc̈hucqui zizaquic̈ha, werarac̈ha wejt persun puntuquiztan chiitaqui, nii. Wejrqui anal wejt persun kuzquiztan kamuc̈ha. Antiz wejt Yooz Epiz̈ kuzcama kamuc̈ha. Wejt waytiz oraqui jalla niizakaz zizaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wejr cuchanz̈quiñiqui wejttan chicaz̈ z̈ejlc̈ha. Wejrqui niiz̈ kuzcamapan kamuc̈ha. Jalla niz̈tiquiztan wejt Ejpqui anaz̈ wejr zina ecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jalla nuz̈ Jesusiz̈ chiitiquiztan muzpa z̈oñinacaqui niiz̈quin criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jalla nekztanaqui Jesusaqui niiz̈quiz criichi judío z̈oñinacz̈quiz cjichic̈ha: —Anc̈hucqui weriz̈ chiita tawkquiz tjapa kuztan tjurt'aquiz̈ niiqui, ultim werara wejt partir z̈oñinaca cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Niz̈aza Yooz takuc̈ha ultim weraraqui, nii zizaquic̈ha. Jalla nuz̈ werara zizcu liwriitaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Nii ana criichi judío z̈oñinacaqui Jesusiz̈quiz kjaazic̈ha, tuz̈ cjican: —Wejrnacqui Abrahamz̈ majchmajtquiztan tjoniñc̈ha. Jaziqui Yooz wajtchiz z̈oñinactc̈ha wejrnacqui. Yekjaz̈ mantuquiz anaz̈ wira z̈ejlchinc̈ha. Amzti, ¿kjaz̈tiquiztan chiichamta, “Anc̈hucqui liwriitaz̈ cjequic̈ha” cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucaquiz weraral chiyuc̈ha. Jakziltat uj paacan kamc̈haja, jalla niiqui ujz̈ mantuquiz kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tsjii mantita piyunaqui patrunz̈ kjuyquiz kamchi cjenami ultimu anaz̈ nii kjuychiz famillz̈ partiquiz z̈elasac̈ha. Antiz nii famillz̈ majchqui jalla niic̈ha famillz̈ partiquiz z̈ejlñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jalla niz̈tiquiztan anc̈hucqui Yooz Majchiz̈ liwriita cjequiz̈ niiqui ultim werara liwriita cjequic̈ha, Yooz kjuychiz famillquiz cjisjapaqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Wejr zizuc̈ha, anc̈hucqui Abrahamz̈ majchmajtquiztan tjoniñc̈hucc̈ha, nii. Pero jalla nuz̈ cjenami, anc̈hucqui weriz̈ chiitanaca anapan catokc̈ha. Jalla niz̈tiquiztan anc̈hucqui wejr conz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Wejrqui chiyuc̈ha, wejt Yooz Epiz̈ chiitanaca, jalla nii. Anc̈huczti anc̈huca epiz̈ chiita jaru paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ninacaqui tuz̈ kjaazic̈ha: —Wejtnaca atchi ejpc̈ha Abrahamqui. Pero Jesusaqui ninacz̈quiz cjichic̈ha: —Anc̈hucqui ultimu Abrahamz̈ majchmajtc̈huc cjic̈haj niiqui, niiz̈ kamta irataz̈ kamc̈hani. ");
INSERT INTO capNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Yoozquiztan nonz̈tanac jaru werara chiichinc̈ha. Jalla nuz̈ werara chiitiquiztan anc̈huczti wejr conz pecc̈ha. Abrahamqui ana niz̈ta paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Anc̈hucqui persun epiz̈ kamta irataz̈ kamc̈ha. Nekztanaqui ninacaqui cjichic̈ha: —Wejrnacqui anac̈ha adulteriuquiz kamñi maa ejpz̈quiztan tjoniñqui. Wejtnaca maa ejpnaca zizuc̈ha. Niz̈aza wejrnacqui tsjii arajpach Ejpchizkazza. Yoozza niiqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesusaqui nekztan cjichic̈ha: —Anc̈huca ejpqui Yoozzalaj niiqui, anc̈hucqui wejttan zuma munazitasac̈ha. Wejrqui Yooz Ejpz̈quiztanc̈ha; niiz̈quiztan tjonuc̈ha. Niiz̈ pinsitiquiztan tekz tii muntuquiz z̈eluc̈ha. Anal wejt kuzcamakaz tjonchinc̈ha. Wejt Yooz Ejpqui wejr cuchanz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Kjaz̈tiquiztan anc̈hucqui weriz̈ chiitanaca ana intintazasajo? Anc̈hucqui weriz̈ chiitanaca anapanz̈ kuztan nonz pecc̈ha, nekztan. ");
INSERT INTO capNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Anc̈huca ultim ejpqui diabluc̈ha. Niiz̈ kuzcama kamz pequiñc̈hucc̈ha. Primirquiztanpacha niic̈ha z̈oñi conñiqui. Niz̈aza diabluqui werara chiizquiztan ana juyzu paañic̈ha. Anapanc̈ha werar taku chiiñi niiqui. Niiz̈ ana zum kuzcamapan toscar takunaca chiic̈ha. Niipankazza toscara chiiñiqui. Niz̈aza niic̈ha toscar chiiñinacz̈ ejpqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Wejrqui anc̈hucaquiz weraral chiyuc̈ha. Anc̈huca diablu ejpchiz cjen, weriz̈ werara chiitanaca ana criiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Ject anc̈hucaquiztan tsjii weriz̈ paata uj tjeesnasajo? Wejrqui Yooz taku werarapan chiyuc̈ha. ¿Kjaz̈tiquiztan wira ana wejtquiz crii anc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Yooz partir z̈oñinacaqui Yooz takuz̈ nonz̈a. Anc̈huczti anapanc̈ha Yooz partira. Jalla niz̈tiquiztan anc̈hucqui Yooz taku ana nonz pecc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nekztan judío z̈oñinacaqui Jesusiz̈quiz kjaazic̈ha tuz̈ cjican: —Amqui anawal Samaria wajtchiz z̈oñimz̈lani. Zajraz̈ tanta z̈oñimz̈lani. Nuz̈upanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Wejrqui anac̈ha zajraz̈ tantitqui. Wejt Yooz Ejpz̈ honora waytuc̈ha. Anc̈huczti wejr iñarcan wejtquiz anaz̈ honora tjaac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wejrqui persun honora ana waytiz pecuc̈ha. Tsjiiqui z̈ejlc̈ha. Jalla niic̈ha wejt honora waytiz pecñiqui. Jalla niic̈ha lijituma pjalzñiqui. ");
INSERT INTO capNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Wejrqui anc̈hucaquiz weraral chiyuc̈ha. Jequit weriz̈ chiitacama kamc̈haja, jalla niiqui ana ticzñiz̈ cjequic̈ha; Yooztan wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jalla nuz̈ chiitiquiztan judío zoñinacaqui tuz̈ kjaazic̈ha: —Jalla nuz̈ amiz̈ chiitiquiztan wejrnacaqui zizzinc̈ha, zajraz̈ tantapanimkalal amqui. Abraham ticzic̈ha; profetanacami ticzizakazza. Amzti cjic̈ha, “Jequit weriz̈ chiitacama kamc̈haja, ana ticzñiz̈ cjequic̈ha”, nii. ");
INSERT INTO capNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Amqui wejtnacaz̈ ticzi Abraham ejpz̈quiztan tsjan jilirim cjes, ¿kjaz̈tatajo? Yooztajapa chiiñi profet z̈oñinacami ticzic̈ha. ¿Chjul z̈oñipanim amzt cjesajo? ");
INSERT INTO capNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesusaqui tuz̈ kjaazic̈ha: —Wejt persun honora waytaz̈ niiqui, jalla nuz̈ waytita honoraqui anaz̈ walc̈ha. Wejt Yooz Ejpc̈ha wejt honora waytiñiqui. Jalla niiz̈ puntu anc̈hucqui “Wejtnaca Yoozza” cjiñc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anc̈hucqui nii Yoozqui anapan pajc̈ha. Wejrkal nii pajuc̈ha. “Wejrqui Yooz Ejp anal pajuc̈ha”, cjesaz̈ niiqui, wejrqui toscaral cjesac̈ha, anc̈huc irata. Yooz Ejp pajuc̈ha; niz̈aza niiz̈ chiitacama kamuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tuquita atchi Abraham ejpqui wejt tjonz̈ tjuñi nonz̈cu, walja cuntintutac̈ha. Niz̈aza wejt tjonz tjuñi zizcu, walja chipchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jalla nuz̈ chiitiquiztan nii judío z̈oñinacaqui Jesusiz̈quiz cjichic̈ha: —Amqui imazi pjijzka tunc watchizzam pero. ¿Jaknuz̈t amzti Abraham pajcham cjesajo? ");
INSERT INTO capNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Anc̈hucaquiz ultim weraral cjiwc̈ha. Ima Abraham z̈elan, wejrqui z̈ejlchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jalla nuz̈ chiitiquiztan judío z̈oñinacaqui maznaca aptichic̈ha. Jesusa maztan c̈hajcz pecatc̈ha. Jesusazti chjojzic̈ha. Nekztan timpluquiztan ulanchic̈ha. Nekz z̈ejlñi z̈oñinacz̈ taypiquiztan atipassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jalla nekztanaqui Jesusaqui jiczquiz ojkchic̈ha. Nii jicz latuquiz tsjii zur z̈oñi z̈elatc̈ha. Majttiquiztanpacha zuratac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jalla nii z̈oñi cherz̈cu Jesusiz̈ tjaajinta z̈oñinacaqui pewczic̈ha, tuz̈ cjican: —Tjaajiñi Maestro, ¿kjaz̈tiquiztan zurapan majttata? ¿Niiz̈ maa ejpz̈ ujquiztan niz̈ta zura majtta cjesaya? Uz̈ ¿persunz̈ ujquiztan cjesaj? ");
INSERT INTO capNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Anaz̈ niiz̈ persun ujquiztanami, niz̈aza anaz̈ niiz̈ maa ejpz̈ ujquiztanami zura majttatac̈ha. Antiz zura z̈ejlc̈ha, niiz̈ zurz̈quiz Yooz obra tjeez̈ta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jaknuz̈t z̈oñinaca majiñ langz̈aja, jalla niz̈ta irata wejrnacqui tii muntuquiz z̈ejlcan langstanc̈ha. Wejt cuchanz̈quiñiz̈ tjaata obranaca langstanc̈ha. Zumz timpu wajillac̈ha. Zumchi cjenaqui anaz̈ jecmi langzuca. ");
INSERT INTO capNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tii muntuquiz z̈ejlcan wejrqui z̈oñinacz̈quiz Yooz zuma kamaña tjeeznuc̈ha, tsjii kjanaz̈takaz. ");
INSERT INTO capNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jalla nuz̈ chiiz̈cu, Jesusaqui yokquiz tjujtzic̈ha. Nekztan nii tjujtz̈ta llawsa yok pjilz̈tan tjarzic̈ha. Jalla nii aptiz̈cu nii zur z̈oñz̈ c̈hjujcquiz tjajlz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Nekztanaqui nii zur z̈oñz̈quiz cjichic̈ha: —Siloé cjita coch paata kjazquin oka. Jalla nicju c̈hjujqui awjz̈ca. Siloé cjita tjuuqui “Cuchanz̈quita” cjic̈ha ninacz̈ tawkquiz. Jalla nekztanaqui nii zur z̈oñiqui ojkz̈cu c̈hjujqui awjzic̈ha. Nekztan cherñi cjissic̈ha. Cherñi quejpz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jalla nekztan niiz̈ z̈cati kamñi z̈oñinacami niz̈aza niiz̈quiz pajñi z̈oñinacami nii z̈ejtchi cherz̈cu, tuz̈ cjichic̈ha: —¿Anaj tiiqui nii paaz tomtomangzñi z̈oñiya? Tuquiqui julzi z̈ejlñitala. ");
INSERT INTO capNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Yekjapanacaqui cjetc̈ha: —Niipansala. Yekjapac cjetc̈ha: —Anapanz̈ nii tiiqui. Niz̈taz̈takazla, pero. Pero nii z̈ejtchi z̈oñipachac̈ha cjichiqui: —Wejrpantc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jalla nekztanaqui niiz̈quiz pewcunchic̈ha: —¿Kjaz̈um am jazic cher, kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Niiqui ninacz̈quiz kjaazic̈ha tuz̈ cjican: —Nii Jesusa cjita z̈oñiqui llawsiz̈tan yok pjilz̈tan tjarzic̈ha. Jalla nuz̈ tjarz̈cu wejt c̈hjujcquiz tjajlz̈inchic̈ha, tuz̈ cjican: “Siloé cjita kjazquin oka. Jalla nicju ajunz̈ca”. Jalla nekztanaqui ojkchinc̈ha wejrqui. C̈hjujqui ajunz̈cu cherñi cjissinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jalla nekztanaqui nii z̈ejtchi z̈oñz̈quiz pewczizakazza tuz̈ cjican: —¿Jakziquin nii z̈oñiya? Niiqui tuz̈ kjaazic̈ha: —Anal zizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jalla nekztanaqui jakataz̈uqui nii zurquiztan c̈hjetinta z̈oñiqui fariseo partinacz̈quin chjichtatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jeejz tjuñquiz Jesusaqui nii milajru paachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseo z̈oñinacaqui nii zurquiztan c̈hjetinta z̈oñz̈quiz wilta pecunchic̈ha, tuz̈ cjican: —¿Anziqui kjaz̈tam cherya? Nii z̈oñiqui tuz̈ kjaazic̈ha: —Llawsiz̈tan pjilz̈tan tjarz̈cu, wejt c̈hjujqui tjajlz̈inchic̈ha. Jalla nekztan wejt c̈hjujqui ajunz̈cu, cherñi cjissinc̈ha. Jaziqui cheruc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Tsjii fariseo z̈oñinacaqui nii Jesusiz̈japa quintra chiichic̈ha, tuz̈ cjican: —Nii z̈oñiqui anaz̈ Yooz partiquiztan cjesac̈ha. Niiqui ana jeejz tjuñimi rispitchila. Yekjapazti cjetc̈ha: —¿Kjaz̈t ujchiz z̈oñiqui niz̈ta milajrunaca paasajo? Anaz̈ cjesac̈ha. Jalla niz̈tiquiztan Jesusiz̈ puntuquiztan t'aka t'aka cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jalla nuz̈ t'aka t'aka cjiscu, wilta nii zurquiztan c̈hjetinta z̈oñz̈quiz pecunchic̈ha, tuz̈ cjican: —¿Amqui kjaz̈um cjii, am c̈hjujqui c̈hjetiñi z̈oñz̈ puntu? Nii z̈oñiqui tuz̈ kjaazic̈ha: —Wejrqui cjiwc̈ha, jalla niic̈ha Yooz cuntiquiztan chiiñi profet z̈oñipanqui. ");
INSERT INTO capNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Tuquiqui nii z̈oñiqui zuratac̈ha, jaziqui cherñi cjissic̈ha. Pero nii judío z̈oñinacaqui nii milajru ana criiz pecatc̈ha. Jalla nekztan nii z̈oñz̈ maa ejp kjawzic̈ha, pewczjapa. ");
INSERT INTO capNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Jalla tuz̈ pewczic̈ha: —¿Tiic am majchkaya? ¿Tiic zurapan majttatakaya? ¿Kjaz̈t tiizti cherñi cjesajo? ");
INSERT INTO capNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nii maa ejpqui kjaazic̈ha, tuz̈ cjican: —Tiipanc̈ha wejtnaca majchqui. Niz̈aza zurapan majttatac̈ha. Jalla niikal chiyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Anziqui cherñi cjissiz̈lani, jalla nii puntuquiztanaqui anal zizuc̈ha. Niz̈aza jecc̈halaj tiiz̈ c̈hjujqui c̈hjetinchi anal zizuc̈ha. Tiika pewcnani. Pajk z̈oñic̈ha tiiqui. Tiipachaz̈ razunaqui tjaasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nii judío z̈oñinacaqui tsjii acuerduquiz parlassitac̈ha, jakziltat Jesusiz̈ puntuquiztan “Tiic̈ha Cristuqui” cjican chiyac̈haja, jalla niiqui ajcz kjuyquiztan chjatkattaz̈ cjistanc̈ha. Jalla nii acuerduquiz parlassitac̈ha. Jalla niz̈tiquiztan nii zur z̈oñz̈ maa ejpmi ekzic̈ha; ana kjanacama chiiz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jalla niz̈tiquiztan ninacaqui kjaazic̈ha, tuz̈ cjican: —Tiika pewcnani. Pajk z̈oñic̈ha tiiqui. ");
INSERT INTO capNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jalla nekztanaqui nii judío z̈oñinacaqui nii zurquiztan c̈hjetinta z̈oñi wilta kjawzic̈ha. Nekztan tuz̈ cjichic̈ha: —Yooz honora wayta. Anac̈ha Jesusiz̈ honora waytizqui. Wejrnaca zizuc̈ha, nii c̈hjetinñi cjita z̈oñiqui walja uj paañipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jalla nekztan nii zurquiztan c̈hjetinta z̈oñiqui tuz̈ kjaazic̈ha: —Wejrqui anal zizuc̈ha, uj paañi ana uj paañi, nii. Pero wejrqui zuratac̈ha. Jaziqui cheruc̈ha. Jalla nuz̈upan zizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wilta niiz̈quin pecunchic̈ha, tuz̈ cjican: —¿Jaknuz̈t paachitajo? ¿Jaknuz̈t am c̈hjujqui c̈hjetintajo? ");
INSERT INTO capNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nii z̈oñiqui tuz̈ kjaazic̈ha: —Anc̈hucaquiz chiichinsala. Weriz̈ chiita ana nonz pecc̈ha. ¿Kjaz̈tiquiztan wilta wilta wejr chiiyaj cjeejo? ¿Anc̈hucazakaz niiz̈tan chica ojklayñi cjis pecjo? ");
INSERT INTO capNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jalla nekztanaqui nii judío z̈oñinacaqui nii zurquiztan c̈hjetinta z̈oñz̈quiz ch'aanichic̈ha tuz̈ cjican: —Amqui nii z̈oñz̈ jaru ojkc̈ha. Wejrnaczti Moisés jaru okuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yoozqui Moisesquiz chiichic̈ha. Jalla nii zizuc̈ha. Tii z̈oñz̈quiztanaqui anal zizuc̈ha, jakziquiztan tjonc̈haja, jalla niimi. ");
INSERT INTO capNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jalla nekztanaqui nii c̈hjetinta z̈oñiqui tuz̈ cjichic̈ha: —Tiic̈ha ispantichuca. Anc̈hucqui jakziquiztan tjonc̈haja, nii ana zizza. Wejtquiz pero c̈hjujqui c̈hjetinz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Uc̈humqui zizla. Yoozqui ujchiz z̈oñinacz̈ mayiztaqui anaz̈ nonznasac̈ha cjic̈ha. Yooz rispitñi z̈oñinacz̈quizimi niz̈aza Yooz kuzcama kamñi z̈oñinacz̈quizimi, jalla ninacz̈quiz nonznasac̈ha Yoozqui cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Anawira tsjii zur z̈oñz̈ c̈hjujqui c̈hjetinta quintu z̈ejlñitala, tuquitanpachami. ");
INSERT INTO capNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nii z̈oñiqui ana Yooz partiquiztanz̈laj niiqui, ana c̈hjul pajk obrami paac̈hani. ");
INSERT INTO capNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jalla nekztanaqui nii judíonacaqui tuz̈ cjichic̈ha: —Amqui ujchizpan majttamtac̈ha. ¿Jaziqui wejtnacaquiz tjaajinzim pec, kjaz̈tatajo? Jalla nekztan nii zurquiztan c̈hjetinta z̈oñi ajcz kjuyquiztan chjatkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jalla nuz̈ chjatkattiquiztan Jesusaqui zizzic̈ha. Jalla nekztan nii z̈oñz̈tan wilta zalz̈cu, tuz̈ cjichic̈ha: —¿Tsewctan cuchanz̈quita Yooz Z̈oñz̈quizim criya? ");
INSERT INTO capNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nii c̈hjujqui c̈hjetinta z̈oñiqui tuz̈ kjaazic̈ha: —Señor, maznalla, ¿ject niiqui? Wejrqui niiz̈quin criyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesusaqui niiz̈quin kjaazic̈ha, tuz̈ cjican: —Anziqui werim cherc̈ha. Niic̈ha wejrtqui, amtan parliñtqui. ");
INSERT INTO capNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jalla nekztanaqui nii z̈oñiqui Jesusiz̈ yujcquiz rispitcan quillzic̈ha, tuz̈ cjican: —Wejt Jiliri. Amquiz criyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesusaqui niiz̈quiz cjichic̈ha: —Wejrqui tii muntuquiz tjonchic̈ha, z̈oñinaca pjalzjapa. Tsjii z̈oñinaca z̈ejlc̈ha ana zuma kamañchiz. Pero ninacz̈ ujquiztan kuz zint'ic̈ha, “ujchizpanc̈ha wejrqui” cjican. Wejrqui tjonchinc̈ha ninaca zuma kamañchiz cjiskatzjapa. Tsjii z̈oñinaca z̈ejlc̈ha. Jalla ninacaqui ana zuma kamañchizzakazza. Pero “Yooz puntu zuma zizuc̈ha” cjiñic̈ha. Jalla nuz̈ chiichiyanami ninacac̈ha zur z̈oñinacaz̈takaz. Jalla nii tjeezjapa, tii muntuquiz tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jesusaz̈ nuz̈ chiyan yekjap fariseo z̈oñinacaqui niiz̈ z̈cati z̈elatc̈ha. Ninacaqui nii chiita nonz̈cu, pewczic̈ha tuz̈ cjican: —¿Wejrnacmi zur z̈oñinacaz̈takaz cjesajo? Anaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jalla nekztanaqui Jesusaqui ninacz̈quiz tuz̈ cjichic̈ha: —Anc̈hucqui persun kuzquiz zur z̈oñiz̈takaz naytasaz̈ niiqui, anc̈hucqui anaz̈ anc̈huca ujquiztan casticta cjitasac̈ha. Pero “Wejrnacqui Yooz puntu zuma zizuc̈ha” cjicanz̈ chiila. Jalla niz̈tiquiztan anc̈huca ujquiztan casticta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesusaqui zakaz cjichic̈ha: —Anc̈hucaquiz weraral chiyuc̈ha. Jakziltat uuzi uyquiz ana zan kjutan luzzaja, yekja latuquiztan chjojzacuñ luzzaja, jalla niic̈ha ana wal tjañiqui. Uuzanaca kjañzjapa luzza. ");
INSERT INTO capNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero jakziltat uuzi uy zanquiztanpan luzzaja, jalla niic̈ha uuzi itzñi awatiriqui. ");
INSERT INTO capNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Niz̈aza uy zana cwitiñi z̈oñiqui uy zana cjetz̈iñic̈ha nii uuza awatiri luzjapa. Niz̈aza nii uuzanacaqui awatirz̈ jora pajc̈ha. Nii awatiriqui uuza tjuucu tjuucu kjawz̈a, niz̈aza uyquiztan jwessa. ");
INSERT INTO capNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Jalla nuz̈ tjapa niiz̈ uuzanaca jwescu, niiz̈ uuzanacz̈ tucquinz̈ ojkc̈ha. Niz̈aza nii uuzanaca niiz̈ wirquiz apz̈a, jora pajz̈cu. ");
INSERT INTO capNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Tsjii ana pajta z̈oñz̈ wirquiziqui anaz̈ apz̈a, antiz nii ana pajta z̈oñz̈quiztan zajtc̈ha, niiz̈ jora ana pajz̈cu. ");
INSERT INTO capNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jalla nuz̈ Jesusaqui quint'ichic̈ha. Pero nonz̈ñi z̈oñinacazti ana wira intintazzic̈ha, c̈hjul puntuquiztan chiic̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jalla nekztanaqui Jesusaqui wilta ninacz̈quiz chiichic̈ha, tuz̈ cjican: —Anc̈hucaquiz weraral chiyuc̈ha. Wejrtc̈ha uuzi uy zantqui. ");
INSERT INTO capNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ima weriz̈ tjonan, z̈oñinacaqui tjonchic̈ha, “Yoozquiztan tjonuc̈ha”, cjicanaqui. Pero tjañicamac̈ha tjapa nii tjonchi z̈oñinacaqui. Uuza tjangzñinacac̈ha ninacaqui. Pero ninacz̈ wirquiziqui wejt uuzanacaqui ana apzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Wejrtc̈ha uuzi uy zantqui. Jakziltat weriz̈ cjen Yooz jamillquiz luzzaja jalla niiqui liwriitaz̈ cjequic̈ha. Jalla niiqui Yooz uuza cuntaz̈ cjequic̈ha. Uuza uyquiz luznaquic̈ha, zaz̈ ulnaquic̈ha, zuma pastu watzjapa. Liwriitapaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‛Tjañi cjicjiñi z̈oñinacaqui tjonc̈ha, cjisñi, coni, niz̈aza tirkati, jalla nii alaja tjonc̈ha. Wejrzti tjonchinc̈ha, zuma kamaña tjaazjapa, anc̈huc ancha zuma kamañchiz cjiskatzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Wejrtc̈ha zuma awatirtqui. Tsjii zuma awatiriqui niiz̈ uuzanacz̈ laycu ticznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero yekjapanacaqui paca tanzjapakaz uuza ichñic̈ha. Jalla ninacaqui tsjii uuzi tanñi animalaz̈ tjonan uuzi eccu zatasac̈ha. Nii uuzaqui anac̈ha persun uuzanaca. Jalla nuz̈ uuzanaca ectan nii anawal animala tjonchiqui uuzanacaz̈ tanc̈ha, niz̈aza witc̈ha. Anac̈ha niz̈ta zuma awatiriqui. ");
INSERT INTO capNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nii anawal awatiriqui paca tanzjapakaz uuzi ichñic̈ha. Ana nii uuzanacz̈japa juyzu paañic̈ha, c̈hjulunacat watac̈haja, jalla nii. Jalla niz̈tiquiztan uuzanaca eccu, anawal animalquiztan zatasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","‛Wejrtc̈ha zuma awatirtqui. Jaknuz̈t wejt Yooz Ejpqui wejtquiz pajc̈haja, niz̈aza wejrmi wejt Ejpz̈quiz pajuc̈haja, jalla niz̈tac̈ha wejrqui wejt uuzanacz̈quiz pajuc̈ha, niz̈aza wejt uuzanacaqui wejtquiz pajc̈ha. Wejrqui wejt uuzanacz̈ laycu ticznac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wejtta zakaz z̈ejlc̈ha yekja uuzanaca ana tii uyquiz cjiñiqui. Wejrqui nii uuzanaca ricujzquiztanzakaztc̈ha. Jalla ninacaqui wejt taku cazaquic̈ha. Tjapa wejt uuzanacaqui tsjii tamaz̈ cjequic̈ha, niz̈aza tsjii awatirchiz. ");
INSERT INTO capNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Wejt uuzanacz̈ laycu ticznac̈ha, niz̈aza jacatatac̈ha. Jalla niz̈tiquiztan Yooz Ejpqui wejr k'aachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Anaz̈ jecmi wejr ticzkatasac̈ha. Antiz wejrqui persun kuzquiztan ticznac̈ha. Niz̈aza poderchiztc̈ha jacatatzjapa. Jalla nii poder wejt Yooz Ejpqui wejtquiz tjaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jalla nuz̈ Jesusiz̈ chiita taku nonz̈cu judío z̈oñinacaqui wilta t'aka t'aka cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Tsjii z̈oñinacaqui cjichic̈ha: —Zajraz̈ tantala. Lucuratala tiiqui. ¿Kjaz̈tiquiztan tiiz̈ chiita anc̈hucqui nonz̈jo? ");
INSERT INTO capNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yekjapac cjichic̈ha: —Tiiqui anaz̈ zajraz̈ tanta z̈oñiz̈ta chiic̈ha. ¿Niz̈aza zajraz̈ tanta z̈oñiqui tsjii zur z̈oñi c̈hjetnasajo? Anaz̈ cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Zac timputac̈ha. Niz̈aza Jerusalén wajtquin timplu cumpleañ pjijzta paatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jalla nii oraqui Jesusaqui timpluquin ojklayatc̈ha, Salomón cjita kjuy patiuran. ");
INSERT INTO capNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jalla nuz̈ ojklayan judío z̈oñinacaqui Jesusiz̈ muytata ajczic̈ha, tuz̈ cjican: —¿C̈hjulorcama amqui wejtnaca kuz turwayskataquejo? Amc̈halaj Cristumz̈ niiqui, tsjiika kjanacama chiizna. ");
INSERT INTO capNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Anc̈hucaquiz nuz̈ cjichinc̈ha. Pero weriz̈ chiitami ana criichinc̈hucc̈ha. Jaknuz̈t wejt Yooz Ejp mantac̈haja, jalla nii mantita jaru zuma obranacal paa-uc̈ha. Jalla nii obranacaz̈ cjen, anc̈hucqui zizasac̈ha, werjtc̈ha Cristo uz̈ anaz̈laj Cristo, nii. ");
INSERT INTO capNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Anc̈huczti ana wejtquiz criiñc̈hucc̈ha. Anc̈hucqui anac̈ha wejt uuzaz̈takazi, jaknuz̈t tuquiqui chiituc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Wejt uuzanacaqui wejt jora pajc̈ha, niz̈aza wejrqui wejt uuzanaca pajuc̈ha. Niz̈aza nii wejt uuzanacaqui wejtquiz apz̈quiñipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Wejrqui ninacz̈quiz zuma kamaña tjaa-uc̈ha, Yooztan wiñaya kamzjapa. Anapan infiernuquin okasac̈ha. Niz̈aza anaz̈ jecmi wejt kjarquiztan ninaca kjañasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Wejt Yooz Ejpqui wejt kjarquiz tjaachic̈ha. Jalla niiqui tjappachquiztanami juc'ant azzizza. Jalla niz̈tiquiztan anaz̈ jecmi Yooz Ejpz̈quiztan wejt uuzanaca kjañasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wejttan wejt Yooz Ejpz̈tan tsjii kuzziztc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jalla nuz̈ chiitiquiztan nii judío z̈oñinacaqui maztan aptiz̈cu wilta Jesusiz̈quiz c̈hajcz pecatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nekztan Jesusaqui ninacz̈quiz cjichic̈ha: —Wejrqui Yooz Ejpz̈ aztan zuma obranacal anc̈hucaquiz tjeezinc̈ha. Nii zuma obranaca Yooz kuzcama paachinc̈ha. ¿Jakziltat nii zuma obranacquiztan wejr maztan c̈hajcz pecjo? ");
INSERT INTO capNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Nii judío z̈oñinacaqui tuz̈ kjaazic̈ha: —Anal am c̈hacac̈ha, zuma obriquiztan. Yooz quintra chiitiquiztan am c̈hacac̈ha. Amqui z̈oñimkazza. Pero Yooztakam cjiicjiic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jalla nekztanaqui Jesusaqui ninacz̈quiz tuz̈ cjichic̈ha: —Anc̈huca liiquizpacha tuz̈ cjijrtapanc̈ha: “Yoozqui cjic̈ha: ‘Anc̈hucqui Yooztakazza.’ ” ");
INSERT INTO capNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Cjijrta Yooz takuqui anaz̈ niqui atasac̈ha. Jalla nii zizza uc̈humqui. Yoozqui niiz̈ taku catokñi z̈oñinacz̈ puntuquiztan cjichic̈ha, “Anc̈hucqui Yooztakazza”, cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Yoozqui wejr ut'aychic̈ha tii muntuquiz cuchanz̈quizjapa. Jalla niz̈tiquiztan wejrqui cjichinc̈ha, “Wejrtc̈ha Yooz Majchtqui”. Jalla nuz̈ chiitiquiztan, ¿kjaz̈t anc̈hucqui Yooz quintra chiiñi cjeejo? ");
INSERT INTO capNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Wejrqui wejt Yooz Epiz̈ mantita obranaca ana paayiñ cjitasaz̈ niiqui, wejtquiz criiz ana waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero wejt Yooz Epiz̈ mantita obranaca paayiñc̈ha. Jalla niz̈tiquiztan wejtquin criya. Weriz̈ chiitiquiztan anac̈ha wejtquiz criyac̈haj niiqui, weriz̈ paata obranacquiztan mekaz̈ wejtquiz criyalla. Wejtquin criyaquiz̈ niiqui, anc̈hucqui intintazaquic̈ha, wejttan Yooz Ejpz̈tan tsjiikazza, jalla nii. Wejt Yooz Ejpqui wejt kuzquiz z̈ejlc̈ha, niz̈aza wejrqui wejt Yooz Ejpz̈ kuzquiz z̈eluc̈ha. —Jalla nuz̈ chiichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nekztanaqui wilta Jesusa preso chjitz pecatc̈ha. Pero Jesusaqui ninacz̈quiztan atipassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jalla nekztanaqui Jesusaqui Jordán pujz̈ tuuna ojkchic̈ha. Jakziquin Juanqui primero bautistc̈haja, jalla nicju z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Walja z̈oñinacaqui niiz̈tan zali ojkchic̈ha. Ninacaqui tuz̈ cjichic̈ha: —Chekapan, tjapa Juanz̈ chiita tiiz̈ puntuquiztan werarapanc̈ha. Ana c̈hjul milajru paachi cjenami, Juanqui tiiz̈ puntuquiztan werarapan chiiñitakalala. ");
INSERT INTO capNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jalla nicju z̈elan walja nekz z̈ejlñi z̈oñinacaqui Jesusiz̈quiz criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tsjii laa z̈oñi z̈elatc̈ha, Lázaro cjita. Betania wajtchiz z̈oñitac̈ha. María, niz̈aza naaz̈a cullaqui, Marta, jalla nii pucultanaqui Betania wajtchizzakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariiqui nii laa Lazaruz̈ cullaquitac̈ha. Niz̈aza Mariiqui Jesusa Jilirz̈ kjojchquiz zuma ulurchiz asiiti alz̈inchintac̈ha. Nekztan naaz̈a persun ach charz̈tan Jesusiz̈ kjojchanaca chjujz̈inchintac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jalla nuz̈ nii pucultan maatakanacaqui Jesusiz̈quiz mazñi cuchanz̈quichic̈ha, tuz̈ cjican: —Wejt Jiliri, amiz̈ pecta k'aachita amigo laa cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesusaqui nii mazta nonz̈cu, cjichic̈ha: —Niiz̈ laacjitiquiztan ana ticznaquic̈ha. Antiz niiz̈ laacjitiquiztan Yooz azi tjeez̈taz̈ cjequic̈ha. Niz̈aza Yoozqui honorchiz cjequic̈ha. Niz̈aza Yooz Majchqui honorchiz zakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesusaqui Martaquiz, naaz̈a cullaqui Mariaquiz, niz̈aza ninacz̈ jila Lazaruz̈quiz, jalla ninacz̈quiz anchaz̈ k'aachichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jalla nuz̈ cjenami Lazaruz̈ laa quintu nonz̈cu, Jesusaqui iya puc majz̈tan kamchic̈ha, jakziquin kamatc̈haja, jalla nicju. ");
INSERT INTO capNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jalla nii puc majquiztan niiz̈ tjaajintanacz̈quiz cjichic̈ha: —Wiltaz̈ Judea yokquin okla. ");
INSERT INTO capNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nekztanaqui niiz̈ tjaajintanacaqui cjichic̈ha: —Tjaajiñi Maestro, az̈k tsjii kjaz̈ majkaz nekzta z̈oñinacaqui am maztan c̈hajcz pecatla, conzjapaqui. ¿Wilta am nicju ojkz pecya? ");
INSERT INTO capNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —Tsjii noojiqui tuncapan orchizza, majiñqui. Jakziltat kjanquiz ojkc̈haja, anaz̈ ezasac̈ha. Jalla niz̈ta iratac̈ha wejt kjanquiz ojkñi z̈oñinacaqui. Ima niiz̈ ticz ora irantiz̈can, walikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jakziltat ween zumchiquiz ojkc̈haja, jalla niiqui ezasac̈ha, kjanaz̈ ana z̈elanaqui. Jalla niz̈tac̈ha ana wejt kjanquiz ojkñi z̈oñinacaqui. Ana Yooz kuzcama kamtiquiztan anawalquiz tjojtsnasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Uc̈hum Lázaro amiguqui tjajc̈ha. Pero wejrqui Lázaro tjajil wajtskatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jalla nekztanaqui niiz̈ tjaajintanacaqui cjichic̈ha: —Jiliri, tjajc̈haj niiqui, nuz̈ cjenaqui upallat cjissani; z̈etaquiz̈, jaz. ");
INSERT INTO capNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Niiz̈ tjaajintanacaqui tsjii kjutñi intintazzic̈ha. Jesusaqui Lázaro ticz puntuquiztan chiichic̈ha. Niiz̈ tjaajintanacaqui ultimu tjajz puntuquiztan intintazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jalla niz̈tiquiztan Jesusaqui kjanapacha chiichic̈ha tuz̈ cjican: —Lazaruqui ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ana nicju z̈ejlchiz̈ cjen wejrqui cuntintuc̈ha. Jalla nuz̈ cjenc̈ha anc̈hucaltajapaqui waliqui, wejtquiz juc'anti criichi cjisjapa. Jazic nii cheriz̈ ojkla. ");
INSERT INTO capNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nekztanqui Tomasaqui, niiz̈ mazinacz̈quiz cjichic̈ha: —Uc̈humnac zakaz ojkla, tiiz̈tan chica ticzñi. Tomasaqui “Pacha” cjita z̈oñizakaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betania watja irantiz̈cu, Jesusaqui zizzic̈ha, Lazaruz̈ ticz̈taqui niz̈aza tjattaqui pajkpic tjuñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania watjaqui Jerusalén wajtquiztan pizc kilómetro jilallatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jalla nii z̈cati z̈elan walja z̈oñinacaqui Martaquiz niz̈aza Mariyaquiz kuzñi tjonzitac̈ha, ninacz̈ jila ticziz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martiqui Jesusaz̈ waj irantiz̈quiñi quintu nonz̈cu, Jesusiz̈quin zali ojkchinc̈ha. Mariiqui kjuyquin eclichintac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesusiz̈tan zalz̈cu, Martiqui paljaychinc̈ha, tuz̈ cjican: —Wejt Jiliri, am tekz z̈ejltasaz̈ niiqui, wejt jilaqui ana ticzi cjitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jalla nuz̈ cjenami wejrqui zizuc̈ha, c̈hjulu amiz̈ Yoozquiztan mayiztami tjaataz̈ cjequic̈ha. —Jalla nuz̈ Jesusiz̈quiz chiichinc̈ha Martiqui. ");
INSERT INTO capNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesusaqui naaquiz cjichic̈ha: —Am jilaqui jacatataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martiqui cjichinc̈ha: —Wejrqui zizuc̈ha, tii muntu tucuz̈inz̈tan, jacatatz tjuñquiziqui jacatataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nekztan Jesusaqui naaquiz cjichic̈ha: —Wejrtc̈ha jacatatskatiñtqui, niz̈aza arajpach z̈eti tjayiñtqui. Jakziltat wejtquiz criyac̈haja, ticzi cjenami, wilta z̈etaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Niz̈aza jakzilta z̈ejtñi z̈oñimi wejtquiz criyac̈haja, jalla niiqui anaz̈ wira ultimu ticznasac̈ha. Arajpachquin wiñaya z̈etaquic̈ha. ¿Jalla nii crii amya? ");
INSERT INTO capNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Naaqui tuz̈ kjaazinc̈ha: —Criyuc̈ha, wejt Jiliri. Niz̈aza criyuc̈ha, amqui Cristumc̈ha; niz̈aza Yooz Maatimc̈ha tii muntuquiz tjonchiqui. Jalla niiqui criyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jalla nuz̈ chiiz̈cu, Martiqui naaz̈a Marii cullaqui kjawzñi ojkchinc̈ha. Nekztan Mariaquiz jamazit chiichinc̈ha, tuz̈ cjican: —Tjaajiñi Maestruqui tekz tjonchic̈ha. Am kjawz̈ca cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Jalla nuz̈ nonz̈cu Mariiqui apura z̈aazinc̈ha. Jesusiz̈quin zali ojkchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesusaqui imaz̈ watja irantiz̈catc̈ha, jakziquin Marti niiz̈tan zalc̈haja, jalla niiranz̈ z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lázaro jilaz̈ ticziz̈ cjen, Mariaquiz kuzcan z̈oñinaca kjuyquin z̈elatc̈ha. Jalla ninacaqui María apura z̈aaz̈cu ulanñi cherz̈cu wirquizpacha apzic̈ha. Ninacaqui cjichic̈ha, “Lázaro jilz̈ sipulturquin kayit ojkc̈hani” cjican. ");
INSERT INTO capNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesusiz̈tan zalz̈cu Mariiqui niiz̈ yujcquiz quillzinc̈ha, tuz̈ cjican: —Wejt Jiliri, tekzim cjitc̈haj amqui, wejt jilaqui anaz̈ ticzi cjitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesusaqui naa María kaañi cherz̈cu, niz̈aza naatan tjonñi judío z̈oñinaca kaañi zakaz̈ cherz̈cu, persun kuzquiz ancha sint'ichic̈ha, niz̈aza ancha llaquita cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jalla nekztan pewczic̈ha, tuz̈ cjican: —¿Jakziquin tjatchinc̈huctaya? Ninacaqui cjichic̈ha: —Jiliri, niiz̈ cherz̈inz̈calla. ");
INSERT INTO capNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nekztanaqui Jesusaqui kaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jalla nuz̈ cherz̈cu z̈oñinacaqui cjichic̈ha: —Cherzna. Lázaro jila anchaz̈ k'aachichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yekjapa ninacazti cjichic̈ha: —Tiiqui zur z̈oñz̈ c̈hjujqui c̈hjetinchic̈ha. ¿Anaj tiic Lázaro jila c̈hjetnasaya, ana ticzi cjisjapaya? ");
INSERT INTO capNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jalla nekztanaqui Jesusaqui ancha kuzquiz sint'ican, sipulturquin macjatchic̈ha. Sipulturaqui pajk mazquiz pjetatac̈ha. Niz̈aza pajk maztan pjucz̈tatac̈ha, nii sipultur zana. ");
INSERT INTO capNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesusaqui nekztan cjichic̈ha: —Nii maz cjewz̈na. Martiqui, nii ticzi jilz̈ cullaquiqui, cjichinc̈ha: —Wejt Jiliri, pajkpic tjuñi tiiz̈ ticztaqui. Jalla niz̈tiquiztan tiiqui chjonanchiz̈lani. ");
INSERT INTO capNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Nekztanaqui Jesusaqui naaquiz cjichic̈ha: —Amqui wejtquiz criyaquiz̈ niiqui, Yooz azi tjeez̈tam cheraquic̈ha. ¿Anaj werj nuz̈ amquiz chiichinpanejo? ");
INSERT INTO capNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jalla nekztanaqui nii sipultura mazqui cjewz̈tatac̈ha. Nekztanaqui Jesusaqui arajpach kjutñi cherz̈cu, tuz̈ cjichic̈ha: —Yooz Ejp, weriz̈ mayizta nonzñiz̈ cjen gracias amquin cjiwc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Weriz̈ mayiztaqui nonzñampanc̈ha amqui. Jalla nii zizuc̈ha. Tekz tsijtchi z̈oñinacz̈tajapa nuz̈ chiyuc̈ha, amc̈ha wejr cuchanz̈quichi, jalla nii criyajo. ");
INSERT INTO capNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jalla nuz̈ mayizizcu, Jesusaqui alto tawkz̈tan mantichic̈ha tuz̈ cjican: —Lázaro, nekztan ulanz̈ca, ticchuc tjona. ");
INSERT INTO capNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nii ticziqui ulanz̈quichic̈ha, kjarami kjojchami jwerz̈intapacha, niz̈aza niiz̈ yujcmi tsjii pañz̈tan ch'okz̈inta. Nekztanaqui Jesusaqui nekz z̈ejlñi z̈oñinacz̈quiz mantichic̈ha: —Nii jwerz̈ina. Nekztan ojklayaj cjee. ");
INSERT INTO capNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jalla niz̈tiquiztan muzpa judío z̈oñinacaqui Jesusiz̈quin criichic̈ha. Ninacaqui Mariaquiz cumpantiz̈cu Jesusiz̈ paata milajru cherchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Yekjap nekz z̈ejlñi z̈oñinacazti fariseo z̈oñinacz̈quin mazñi ojkchic̈ha. Nicju tjapa Jesusiz̈ paatanaca quint'iz̈quichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jalla nuz̈ nonz̈cu fariseo partir z̈oñinacami timplu jilirinacami tjapa jilirinaca ajcskatchic̈ha. Nekztan jilirinacz̈quiz pewczic̈ha, tuz̈ cjican: —Nii z̈oñiqui anchaz̈ milajrunaca paac̈ha. ¿Uc̈humnacqui kjaz̈a cjeequi nii z̈oñz̈tan? ");
INSERT INTO capNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Jalla nuz̈kaz̈ milajrunaca tira paañiz̈laj niiqui, tjapa z̈oñinacaqui niiz̈quincama criyac̈hani. Jalla nuz̈ cjenaqui roman jilirinacaqui zultatunaca cuchanz̈cac̈hani, uc̈hum timplu pajlzjapani, niz̈aza uc̈hum naciona akzjapani. ");
INSERT INTO capNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nii wataqui Caifás cjitaqui uchtatac̈ha timplu chawc jiliri. Jalla niiqui paljaychic̈ha, tuz̈ cjican: —Anc̈hucqui ana zizñi z̈oñinacaz̈takaz, ¿kjaz̈tatajo? ");
INSERT INTO capNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Uc̈hum wajtchiz z̈oñinacz̈tajapa nii Jesusac ticstanc̈ha, tjapa uc̈humnaca ticz cjenquiztanpacha. Jalla nuz̈ waquizic̈ha. Tjapa tii naciona akz̈inasaz̈ niiqui, jalla niiz̈ ana wali cjesac̈ha. Nuz̈ ana waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nii timplu chawc jiliriqui anac̈ha persun kuzquiztan chiichiqui. Timplu chawc jiliriz̈ cjen, Yoozza nuz̈ chiikatchi. Jalla nuz̈ chiican, Jesusiz̈ puntu mazinchic̈ha, Jesusaqui nii wajtchiz z̈oñinacz̈tajapa ticznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Anazaz̈ nii wajtchiz z̈oñinacz̈tajapakaz ticznaquic̈ha. Tjapa z̈oñinacz̈tajapa ticznaquic̈ha. Yooz partiquiz kamñi z̈oñinacaqui tjapa kjutñi tii muntuquiz wichanzic̈ha. Jalla ninacaqui Jesusaqui tjapa nacionquiztan ricujaquic̈ha. Tsjii Yooz jamillajapa ricujaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jalla nuz̈ palt'iz̈cu nii noojtanpacha judío jilirinacaqui Jesusa conzjapa kazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jalla niz̈tiquiztan Jesusaqui chjojzacuñ ana kjanacama ojklaychic̈ha Judea cjita yokquiz. Jerusalén z̈cati yokquiztan ojkchic̈ha Efraín wajtquin. Efrain watjaqui ch'ekti yok z̈catitac̈ha. Jalla nicju niiz̈ tjaajintanacz̈tan kamchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Judío z̈oñinacz̈ pascua pjijzta wajillatac̈ha. Jalla niz̈tiquiztan walja z̈oñinacaqui jochinacquiztanami zkolta watjanacquiztanami Jerusalén watja ojkchic̈ha ima pascua pjijzta tjonan. Ajunz cuzturumpi payi ojkchic̈ha. Ana nii cuzturumpi paaquiz̈ niiqui, ana pascua pjijzta paasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Nii tjonchi z̈oñinacaqui Jesusa kjuratc̈ha. Timpluquin tsijtchi z̈ejlcan ninacpora Jesusiz̈ puntu pewcsassic̈ha, tuz̈ cjican: —¿Am jaknuz̈um tantii? ¿Tii pjijztiquiz Jesusac tjonasaya? ");
INSERT INTO capNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Niz̈aza fariseo partir z̈oñinacami timplu jilirinacami ordena tjaachic̈ha, jequit Jesusa cherac̈haja, jalla niiqui ninacz̈quiz maztanc̈ha, Jesusa preso tanta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua pjijzta wajilla sojta tjuñiz̈ cjen Jesusaqui Betania watja ojkchic̈ha, Lazaruz̈ kjuya. Niiz̈ tuquiqui Jesusaqui ticziquiztan nii Lázaro jila jacatatskatchitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jalla nicju Jesusiz̈quiz rispitcan zuma c̈hjeri tjaczinchic̈ha. Martiqui c̈hjeri atintichinc̈ha. Lazaruzti mizquiz z̈elatc̈ha, Jesusiz̈tan chica lujlcan nii parti z̈oñinacz̈tanpacha. ");
INSERT INTO capNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jalla nuz̈ lulan Mariiqui medio litro zuma ulurchiz asiiti zjijcchinc̈ha. Nii asiitiqui zuma legal nardo cjita asiititac̈ha, wali preciuchiztac̈ha. Jalla nii asiitiz̈tan Jesusiz̈ kjojchquiz alz̈cu tjajlz̈inchinc̈ha. Nekztan naaz̈a persun ach charz̈tan chjujz̈inchinc̈ha. Walja zuma ulurchiztac̈ha. Tjapa nii kjuyquiziqui nii zuma ulura chjijpsitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jalla nuz̈ asiiti alz̈inñi cherz̈cu, Judas Iscariote cjita Simonz̈ majchqui chutchic̈ha. Jalla niiqui Jesusiz̈ tjaajinta z̈oñinacz̈ partiquiztantac̈ha. Niz̈aza niipacha niiz̈ wiruñ Jesusiz̈ quintra tarasunaz̈ paaquic̈ha. Jalla nii Judasqui naa Mariaquiz paljaychic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Kjaz̈tiquiztan tii aceite ana 300 paazuñ tuytata, pori z̈oñinacz̈quiz yanapzjapajo? ");
INSERT INTO capNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judaszti anaz̈ porinaca importayatc̈ha. Tjañi zaañitac̈ha. Niiz̈ kjarquiztac̈ha paaz pulsaqui. Niz̈aza nii utz̈ta paaznacquiztan tjangñitac̈ha. Jalla niz̈tiquiztan nuz̈ chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jalla nekztanaqui Jesusaqui Judasquiz cjichic̈ha: —Ana naaquiz nuz̈ cjee. Ima wejt ticz tjuñi tjonan, naaqui wejttajapa tii aceite c̈hjojchinc̈ha, wejr zuma tjatta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tii muntuquiz porisanacac panz̈ z̈ejlc̈ha. Wejrzti anc̈hucatan ana tira z̈elac̈ha, tii muntuquiz. ");
INSERT INTO capNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Walja judío z̈oñinacaqui Jesusiz̈ quintu zizzic̈ha, Betania wajtquin z̈ejlñi, jalla nii. Jalla nekztan nicju ojkchic̈ha, Jesusa cherzñi, niz̈aza Lázaro cherzñi. Jesusaqui Lázaro ticziquiztan jacatatskatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jalla nuz̈ Lázaro jacatatskatta quintu nonz̈cu timplu jilirinacaqui Lazaruzakaz conz kazzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jalla nii Lazaruz̈ jacatattaz̈ cjen, walja judío z̈oñinacaqui nii jilirinacz̈ chiitanaca ana cazzic̈ha. Nekztan zarakz̈cu, Jesusiz̈quiz apoychic̈ha. Niz̈aza niiz̈quin criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Walja z̈oñinacaqui Jerusalén watja tjonz̈cu, nekz z̈elatc̈ha pascua pjijzta paazjapa. Jakataz̈uqui z̈oñinacaqui zizzic̈ha, Jesusaqui wajtquin wajillaz̈ irantiz̈quic̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Jalla nekztan chjañinacz̈tanpacha ramuza cjita munti itsa kjajpchic̈ha. Jalla nuz̈ nii ramuz itsanac manz̈cu, wajtz̈ tjiya Jesusa risiwi ulanchic̈ha, tuz̈ kjawcan: —¡Yoozqui honorchiz cjila! ¡Yooz Jilirz̈ tjuuquiz tjonñi z̈oñi rispittaj cjila! ¡Israel chawjc jiliri rispittaj cjila! ");
INSERT INTO capNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesusaqui tsjii aznu cunsicz̈cu, yawchic̈ha, jaknuz̈t Yooz tawk liwruquiz cjijrtc̈haja, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Cjijrta Yooz takuqui tuz̈ cjic̈ha: —Sión wajtchiz z̈oñinaca, anaz̈ eksna. Cherzna. Aznuquiz yawchi am chawjc jiliriz̈ tjonc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jalla nuz̈ watan nii ora niiz̈ tjaajintanacaqui anaz̈ intintazatc̈ha, kjaz̈tiquiztan niz̈ta wat, jalla nii. Jesusa arajpacha ojktan, jalla nekztan ninacaqui intintazzi cjissic̈ha. Jalla nii ora cjuñzic̈ha, tuquitan cjijrta Yooz takuqui tjapa nii watchinaca mazinchic̈ha, nii. Nii cjijrtanac jaru, nuz̈cama watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Niiz̈ tuquiqui Jesusaqui Lázaro ticziquiztan jacatatskatchic̈ha. Nekztan kjawz̈cu sipulturquiztan ulanskatz̈quichic̈ha. Jalla nii cherñi z̈oñinacaqui parti z̈oñinacz̈quiz walja parlichic̈ha tjapa nii milajru paatiquiztan. ");
INSERT INTO capNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jalla niz̈tiquiztan Jesusaz̈ paata milajru zizcu, walja z̈oñinacaqui Jesusiz̈quin zali ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jalla nuz̈ cherz̈cu fariseo z̈oñinacaqui ninacpora tuz̈ cjichic̈ha: —Wejrnacqui jazicz̈ cheruc̈ha. Tjapa z̈oñinacaqui niiz̈quin ojkzpanz̈ cjiskalala. Niz̈aza wejrnacqui anaz̈ c̈hjulumi kjaz̈ cjiyi atchuca cjesaz̈, jaz. ");
INSERT INTO capNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nii pjijzta ojkchi z̈oñinacz̈porquiz tsjii kjaz̈ griego wajtchiz z̈oñinaca z̈elatc̈ha. Ninacaqui Jerusalén watja ojkchizakazza, Yooz rispiti. ");
INSERT INTO capNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ninacaqui Felipiz̈quin tjonchic̈ha. Felipiqui Betsaida wajtchiztac̈ha, niz̈aza Galilea yokchiztac̈ha. Felipiz̈quiz rocchic̈ha tuz̈ cjican: —Señor, wejrnacqui Jesusiz̈tan zalz pecuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Nekztanaqui Felipiqui Andrez̈quiz mazñi ojkchic̈ha. Nekztanaqui pucultanaqui Jesusiz̈quiz mazñi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jalla nuz̈ maztiquiztan Jesusaqui cjichic̈ha: —Wejrqui tsewctan cuchanz̈quita Yooz Z̈oñtc̈ha. Jaziqui wejt ticz ora wajic̈ha. Jalla nekztanaqui wejrqui honorchiz cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Anc̈hucaquiz weraral chiyuc̈ha. Tsjii c̈hjacta trigo semillaqui yokquiz tjatz̈ta, katc̈ha. Jalla niz̈ta c̈hjacta cjen, ew zkala jecz̈a, niz̈aza pookc̈ha. Ana niz̈ta c̈hjacta cjequiz̈ niiqui, nuz̈quizkaz z̈ejlc̈ha semillaqui. ");
INSERT INTO capNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jalla niz̈ta iratac̈ha tii chiitaqui. Jakziltat persun kuzcamakaz kamz pecc̈haja, jalla niiqui ultim zuma kamaña pertaquic̈ha. Pero jakziltat tii muntuquiz z̈ejlcan persun kuzcama ana kamz pecc̈haja, niz̈aza Yooz kuzcama kamz pecc̈haja, jalla niiqui wiñayjapa zuma kamañchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jakziltat wejtquiz sirwac̈haja, jalla niiqui wejttan chica ojklaysa c̈hjul sufrizquiztanami. Nekztan jakziquin wejr z̈elac̈haja, jalla nicju wejttan chica wejt sirwiñinaca zakaz cjequic̈ha. Niz̈aza jakziltat wejtquiz sirwac̈haja, jalla niiz̈quiz wejt Yooz Ejpqui honoraz̈ tjaaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","‛Anziqui wejt kuzqui ancha turwaysic̈ha. ¿Kjaz̈ cjisnaqui? Yooz Ejp, tii sufrisquiztanz̈ liwriyalla. ¿Nuz̈ cjis wali cjesaya? Anac̈ha. Wejrqui tii muntuquiz tjonchinpanc̈ha, sufrisjapaqui. ");
INSERT INTO capNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yooz Ejp, am munañpaj cjila; ampacha rispittaj cjila. —Nuz̈ cjichic̈ha Jesusaqui. Jalla nii orapacha arajpachquiztan tsjii joraqui paljayz̈quichic̈ha, tuz̈ cjican: —Wejrqui rispittitc̈ha, niz̈aza rispittapan cjeec̈ha, amiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nekz z̈ejlñi z̈oñinacaqui jalla nii chiiñi jora nonz̈cu, cjichic̈ha: —Tsjii jorjorñi z̈elatc̈ha —nuz̈ cjichic̈ha. Yekjapanacaqui tuz̈ cjichic̈ha: —Tsjii anjilaz̈ paljayz̈quichila. ");
INSERT INTO capNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Anaz̈ wejttajapa nii jora chiiz̈quichic̈ha, antiz anc̈hucaltajapac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Weriz̈ ticztaz̈ cjen tii muntuquiz z̈ejlñi z̈oñinacaqui pjalz̈taz̈ cjequic̈ha. Niz̈aza tii muntuquiz mantiñi diabluqui atiptaz̈ cjequic̈ha, chjatkattaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yooz Z̈oñtc̈ha wejrqui. Jaziqui tii yokquiztan cruzquiz waytital cjeec̈ha. Nekztan tjapa wejt partir z̈oñinacz̈quiz wejtquin macjatskatac̈ha, wejtquin criizjapa. ");
INSERT INTO capNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jalla nuz̈ chiican Jesusaqui jaknuz̈t ticznac̈haja, jalla nii chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nekz z̈ejlñi z̈oñinacaqui tuz̈ cjichic̈ha: —Uc̈humnacqui uc̈hum liiquiztan zizzic̈ha, Cristuqui wiñaya z̈etaquic̈ha. ¿Kjaz̈ amqui chiyasajo, Yooz Z̈oñi cruzquiz waytita cjequic̈ha, cjicanajo? ¿Ject tii Yooz Z̈oñejo? ");
INSERT INTO capNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jalla nekztanaqui Jesusaqui cjichic̈ha: —Wejrqui tsjii upacamakal anc̈hucatan z̈elac̈ha Yooz kamaña tjeez̈can, tsjii kjanaz̈takaz. Jalla nuz̈ wejt kjana z̈elan, anc̈hucqui zuma kamañchiz kama. Zumchi cjis wajillac̈ha. Nii zumchi cjen, ana tsucaquic̈ha. Jakziltat anawal zumchiquiz kamc̈haja, jalla niiqui jakzitchuc ojkc̈haja, jalla nii ana zizza. ");
INSERT INTO capNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Jaziqui tsjii kjanaz̈takaz weriz̈ z̈elan, wejtquiz criya, zuma Yooz kamaña tjeezñinaca cjisjapa. Jalla nuz̈ chiiz̈cu Jesusaqui ojkchic̈ha. Nekztan ninacz̈quiztan c̈hjojzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ninacaz̈ cheran walja milajrunaca paachic̈ha Jesusaqui. Jalla nuz̈ paachiz̈ cjenami parti z̈oñinacaqui ana niiz̈quin criichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jalla nuz̈ ana criitiquiztan Isaías cjita profetz̈ takunaca cumplissic̈ha. Isaías cjita Yooz cuntiquiztan chiiñi profetaqui tuz̈ cjichic̈ha: “Yooz Jiliri, ¿ject wejtnacaz̈ chiita taku criijo? Niz̈aza am azi tjeeznan, z̈oñinacaqui anapaz̈ intintazza”. ");
INSERT INTO capNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","¿Kjaz̈t z̈oñinacaqui criyasajo? Isaiasqui tuz̈ cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Yoozqui tii z̈oñinaca zur z̈oñiz̈takaz cjiskatchic̈ha, ana cherñi z̈oñinacaz̈takaz cjeyajo. Niz̈aza chojru kuzziz cjiskatchic̈ha, ana intintazñi kuzziz cjeyajo. Jalla nuz̈ cjen ana wejtquin macjatz̈caquic̈ha, liwriita cjeyajo”. Nuz̈ cjijrchic̈ha Isaiasqui, ");
INSERT INTO capNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","tuquitan Jesusaz̈ tjeez̈ta honora puntu zizcu. ");
INSERT INTO capNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jila parti ana criichiz̈ cjenami, muzpa z̈oñinacaqui Jesusiz̈quiz criichic̈ha, niz̈aza jilirinacami. Pero fariseo z̈oñinaca ekscu ana kjanacama cjiicjiichic̈ha. Jamazit criichic̈ha, ana ajcz kjuyquiztan chjatkatta cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Z̈oñinacaz̈ rispitta cjis pecatc̈ha, Yoozquiztan cjen juc'anti. Jalla niz̈tiquiztan jamazit criichic̈ha Jesusiz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jalla nekztanaqui Jesusaqui altu jorz̈tan chiichic̈ha tuz̈ cjican: —Jakziltat wejtquiz criic̈haja, jalla niiqui wejr cuchanz̈quiñiz̈quiz nuz̈uzakaz criic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Niz̈aza jakziltat wejr cherc̈haja, jalla niiqui wejr cuchanz̈quiñiz̈quiz nuz̈uzakaz cherc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Wejrqui tii muntuquiz tjonchinc̈ha, Yooz kamaña tjeezjapa, tsjii kjanaz̈takaz. Jakziltat wejtquiz criic̈haja, jalla niiqui anawal zumchiquiz ana tira kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jakziltat weriz̈ chiita nonz̈cu ana catokac̈haja, jalla niiz̈ quintra tii ora anal chiyuc̈ha. Wejrqui z̈oñinacz̈ quintra chiizjapa ana tjonchinc̈ha. Antiz z̈oñinaca liwriizjapa tjonchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jakziltat wejtquiz ana criic̈haja, niz̈aza werj ana cherz pecc̈haja, niz̈aza weriz̈ chiita taku ana catokc̈haja, jalla niic̈ha persun quintra cjiicjiiñiqui. Pjalz tjuñquiziqui weriz̈ chiita taku ana catoktiquiztan jalla niz̈tiquiztan Yooz Ejpqui ultimquiz ninaca casticaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Wejrqui anal persun kuzquiztan chiiñc̈ha. Antiz wejr cuchanz̈quiñi Yooz Ejpz̈ mantita jaru chiiñc̈ha, niz̈aza niiz̈ mantitacama tjaajniñc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Wejt Yooz Epiz̈ mantitacama kamzqui arajpachquin Yooztan wiñaya kamzjapapanc̈ha. Jaziqui weriz̈ chiitaqui Yooz Epiz̈ mantitacama chiichinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ima pascua pjijzta tjonan, Jesusaqui zizzic̈ha niiz̈ ticz ora wajitac̈ha, jalla nii. Niz̈aza zizzic̈ha, tii muntu eccu niiz̈ Ejpz̈quinz̈ okaquic̈ha, nii. Tii muntuquiz z̈ejlcan Jesusaqui niiz̈ pecta mazinaca walja k'aachichic̈ha, ultim werarapan. Ticzcama k'aachichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Pascua pjijzta paacan, Jesusaqui niiz̈ tjaajintanacz̈tan c̈hjeri lujlchic̈ha. Judas Iscariote cjita Simonz̈ majch chicapacha nekz z̈elatc̈ha. Judas kuzqui diabluz̈ mantuquiz cjiskatchic̈ha. Diabluz̈ mantitaz̈ cjen Judasqui tarzuna paaz pinsichic̈ha, Jesusa tankatzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesusaqui zizzic̈ha, Yooz Ejpqui tjapa mantiznaca niiz̈ kjarquiz tjaachic̈ha. Niz̈aza niiqui Yooz Ejpz̈quiztan tjonchic̈ha, niz̈aza Yooz Ejpz̈quin quepaquic̈ha. Jalla nii zizzic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jalla nuz̈ zizziz̈ cjenami, piyunaz̈takaz cjissic̈ha. Misquiztan tsijtscu, niiz̈ juntuñta zquiti chjojksic̈ha. Nekztanaqui toalla aptiz̈cu, niiz̈tan tsjaasic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jalla nekztanaqui tsjii purinquiz kjaz alz̈cu, niiz̈ tjaajintanacz̈ kjojcha awjz̈iñi kallantichic̈ha. Nekztan nii tsjaazta toallz̈tan kjojchanaca chjujz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Niz̈aza Jesusaqui Simón Pedro cjita z̈oñz̈quiz niiz̈ kjojcha awjz̈iñi macjatchic̈ha. Nekztan Pedruqui Jesusiz̈quiz cjichic̈ha: —Wejt Jiliri, ¿amqui wejt kjojcha awjz̈inz pecya? Ana wejt kjojcha awjz̈inz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jalla nuz̈ chiitiquiztan Jesusaqui tuz̈ kjaazic̈ha: —Tii weriz̈ paataqui amqui ana intintazza anziqui. Tii jarquinam intintazaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero Pedruqui cjichic̈ha: —Wejt Jiliri, amqui wejt kjojcha anapanim awjz̈inasac̈ha. Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Wejrqui am kjojcha anal awjz̈inaz̈ niiqui, anam wejt partiquiz cjesac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jalla nekztanaqui Simón Pedro cjitaqui tuz̈ cjichic̈ha: —Wejt Jiliri, ana wejt kjojcha alajakaz awjnasac̈ha, wejt kjarami achami awjz̈inalla. ");
INSERT INTO capNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesusaqui niiz̈quiz tuz̈ cjichic̈ha: —Tsjii ajunta z̈oñiqui anaz̈ wilta wilta ajunz pecc̈ha, antiz kjojchakaz ajunz pecc̈ha. Nekztan limpuz̈ niiqui tjappacha. Anc̈hucqui limpuc̈ha, pero tsjiiqui ana limpuc̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesusaqui zizzic̈ha, jakziltat tarsuna paazcu nii tankatac̈haja, nii. Jalla niz̈tiquiztan nuz̈ chiichic̈ha Jesusaqui, “Tsjiiqui ana limpuc̈ha anc̈hucqui” cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nekztan Jesusaqui ninacz̈ kjojchanaca awjawjz̈iñz̈cu, niiz̈ juntuñta chjojkta zquiti aptichic̈ha. Zquiti cujtz̈cu wilta misquiz julzic̈ha. Nekztan ninacz̈quiz cjichic̈ha: —¿Tii weriz̈ paata anc̈hucqui intintazziñc̈huckaya? ");
INSERT INTO capNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Anc̈hucqui wejr “Tjaajiñi Maestruz̈” cjic̈ha, niz̈aza “Jiliriz̈” cjic̈ha. Jalla nuz̈upanc̈ha wejrqui. Jalla niz̈tiquiztan nuz̈pan chiiz waquizic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Wejrtc̈ha werara anc̈huca Jiliritqui niz̈aza Tjaajiñi Maestrutqui. Jaziqui wejrqui anc̈huca kjojcha ajunz̈inchinc̈ha. Jalla niz̈ta irata anc̈hucmi piyunanacaz̈takaz, porapat yanaparassa, niz̈ta kjojchanaca ajunz tjepi. ");
INSERT INTO capNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jazic niz̈ta paachinc̈ha, anc̈huc niz̈tapacha paajo. ");
INSERT INTO capNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Anc̈hucaquiz ultim weraral chiyuc̈ha. Tsjii piyunaqui niiz̈ jilirz̈quiztan anac̈ha juc'anti Niz̈aza tsjii cuchanz̈quitaqui niiz̈ cuchanz̈quiñiz̈quiztan anac̈ha juc'anti. ");
INSERT INTO capNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Anc̈hucqui tii puntu intintazzaj niiqui, jalla nii jaru kamz waquizic̈ha. Nekztan cuntintuz̈ cjequic̈ha anc̈hucqui. ");
INSERT INTO capNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‛Wejrqui weriz̈ illztanaca pajuc̈ha. Niz̈aza tsjiizuñ pajuc̈ha. Niiz̈ puntuquiztan cjijrta Yooz takuqui tuz̈ cjic̈ha: “Tsjii wejttan chica lujlñiqui wejt quintraz̈ cjisnaquic̈ha”. Jalla nii cjijrta Yooz takuqui cumplisnaquic̈ha. Tjapa anc̈huca puntuquiztan anal chiyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Pero anziqui ima tankatan anc̈hucaquiz chiyuc̈ha jaknuz̈t wejr tanta cjec̈haja, nii puntu kjanzt'uc̈ha. Jalla niz̈tiquiztan wejr tantanaqui, anc̈hucqui wejtquiz criyaquic̈ha, wejrtc̈ha Yoozquiztan cuchanz̈quitaqui, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Anc̈hucaquiz weraral chiyuc̈ha. Jakziltat weriz̈ cuchanz̈quita z̈oñinaca risiwc̈haja, jalla niiqui wejr zakaz risiwc̈ha. Niz̈aza jakziltat wejr risiwc̈haja, jalla niiqui wejr cuchanz̈quiñiz̈quiz risiwtazakaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jalla nuz̈ chiiz̈cu Jesusaqui persun kuzquiz ancha llaquita sint'ichic̈ha. Jalla nekztan tuz̈ kjanapacha cjichic̈ha: —Anc̈hucaquiz weraral chiyuc̈ha. Tsjii anc̈hucaquiztan wejr tankataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jalla nuz̈ chiitiquiztan niiz̈ tjaajintanacaqui porapat chersassic̈ha, kuzquiz pinsican, “¿Jakziltiz̈japa chiic̈haja?” jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Tsjii ancha k'aayi tjaajinta z̈oñi Jesusiz̈ latuquiz z̈cati julzi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jalla nekztan Simón Pedruqui nii z̈cati z̈ejlñiz̈quiz kjarz̈tan paljaychic̈ha. “¿Jecz̈quiztanpan chii? Maznalla”, cjicanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jalla niz̈tiquiztan nii z̈cati z̈ejlñi z̈oñiqui Jesusiz̈quiz pewczic̈ha tuz̈ cjican: —Wejt Jiliri, ¿ject am tankatñi z̈oñiqui? ");
INSERT INTO capNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesusaqui tuz̈ kjaazic̈ha: —Jecz̈quizkat wejrqui c̈hjer mazquiquiz t'awz̈cu tii t'anta tjaac̈haja, jalla niiz̈ cjequic̈ha niiqui. Jalla nekztanaqui nii t'anta t'awz̈cu, Judas Iscariotiquiz tjaachic̈ha. Niiqui Simonz̈ majchtac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jalla nii t'awz̈ta t'anta tanz̈tanaqui, Satanás cjita diabluqui Judas kuzquiz luzzic̈ha. Nekztanaqui Jesusaqui Judasquiz paljaychic̈ha, tuz̈ cjican: —C̈hjulum paac̈haja, apura paa. ");
INSERT INTO capNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nii parti mizquiz julzi z̈oñinacaqui ana intintichic̈ha, nii Jesusiz̈ chiita. ");
INSERT INTO capNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yekjapanacaqui tantiyatc̈ha, jalla tuz̈: Judas paaz pulsa tanzñiz̈ cjen, Jesusaqui niiz̈quiz mantichiz̈lani pjijzta paazjapa c̈hjulunaca kjayz̈japani. Yekjapanacazti zakaz tantiyatc̈ha, jalla tuz̈: Judas paaz pulsa tanzñiz̈ cjen, Jesusaqui mantichiz̈lani, pori z̈oñinacz̈quiz paaz onanzjapani. ");
INSERT INTO capNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judasqui nii t'anta tanz̈cu nii orapacha ulanchic̈ha. Nii oraqui weentac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jalla nuz̈ Judas ulantanaqui, Jesusaqui cjichic̈ha: —Wejrtc̈ha Yooz cuchanz̈quita Z̈oñtqui. Jaziqui wejrqui wejt Yooz tjaata kamaña tjeeznuc̈ha, honorchiz cjisjapa. Niz̈aza weriz̈ cjen Yooz Ejpqui honorchiz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jalla niz̈tiquiztan Yooz Ejpqui wejtquiz zakaz honorchiz cjiskataquic̈ha. Jalla niiqui wajillaz̈ wataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Weriz̈ pecta jilanaca, tsjii upacamakaz anc̈hucatan z̈elac̈ha. Nekztan anc̈hucqui wejr kjuraquic̈ha. Pero jaknuz̈t tuquiqui z̈oñinacz̈quiz chiituc̈haja, jalla niz̈tapachal anziqui anc̈hucaquiz tuz̈ chiyuc̈ha: Jakziquint wejr okac̈haja, jalla nicju anc̈hucqui ana oki atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Wejrqui tsjii ew mantita ortina anc̈hucaquiz tjaa-uc̈ha: “Porapat zuma munazizpanc̈ha, jalla nii. Jaknuz̈t wejrqui anc̈hucatan zuma munazituc̈haja, jalla niz̈ta anc̈hucqui porapat zuma munazaquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Anc̈hucaz̈ nii ortina mantita jaruz̈ kaman, tjapa z̈oñinacaqui zizaquic̈ha, anc̈hucc̈ha weriz̈ tjaajinta z̈oñinacapan. ");
INSERT INTO capNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jalla nekztanaqui Simón Pedruqui niiz̈quiz cjichic̈ha: —Wejt Jiliri, ¿am jakzim okaquiya? Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Jakziquint wejr okac̈haja, jalla nicju anaz̈ apzñi atasac̈ha anziqui. Tii jarquinaqui amqui wejtquin tjonaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pedruqui cjichizakazza: —Wejt Jiliri, ¿kjaz̈tiquiztan anzic ana am apzñi atasajo? Anzimi amquiztanami weril ticznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesusaqui tuz̈ kjaazic̈ha: —¿Wejtquiztan ticznasaya? Ultim weraral amquiz cjiwc̈ha: Ima quer wallpaz̈ kjawan, amqui c̈hjep wilta wejr ana pajñim toscara chiyaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wejt tjaajinta z̈oñinaca, Yooz Ejpz̈quin criyiñc̈hucc̈ha niz̈aza wejtquiz zakaz criya. Ana turwayzi kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Wejt Ejpz̈ arajpach kjuyquin wacchi campu z̈ejlc̈ha, kamzjapa. Ana niz̈ta z̈ejltasaz̈ niiqui wejrqui anc̈hucaquiz maztasac̈ha. Jaziqui wejrqui okac̈ha anc̈hucaltajapa campu tjaczquizjapa. ");
INSERT INTO capNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jalla nuz̈ campu tjaczñi ojkz̈cu, wiltal quejpz̈cac̈ha anc̈huc chjichi, wejttan kamzjapa. Jakziquint wejr z̈elac̈haja, jalla nicju anc̈huc zakaz z̈elaquic̈ha, weriz̈ chjichtaz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Anc̈hucqui jakziquint wejr okac̈haja, niiqui zizza. Niz̈aza wejt ojkz jicz zizza. ");
INSERT INTO capNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nekztanaqui Tomasqui cjichic̈ha: —Wejt Jiliri, jakziquinam am okac̈haja, anal zizuc̈ha wejrnacqui. ¿Kjaz̈t am ojkz jicz zizasaya? ");
INSERT INTO capNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesusaqui niiz̈quiz tuz̈ kjaazic̈ha: —Wejrtc̈ha jicz cuntitqui, arajpachquin irantizjapaqui. Niz̈aza wejrtc̈ha werarapankaztqui. Weriz̈ cjen werar Yooz kamaña zizasac̈ha. Niz̈aza wejrtc̈ha z̈eti tjaayiñtqui, Yooztan winaya kamzjapa. Weriz̈ cjenpankaz Yooz Ejpz̈quin iranti atasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Anc̈hucqui wejr ultimu pajtasaz̈ niiqui, anc̈hucqui wejt Yooz Ejp zakaz pajtasac̈ha. Jaztanpacha weriz̈ cjen anc̈hucqui wejt Yooz Ejp pajc̈ha, niz̈aza weriz̈ cjen anc̈hucqui Yooz Ejp cherc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Nekztanaqui Felipiqui cjichic̈ha: —Wejt Jiliri, Yooz Ejp cherkatalla, nuz̈quiz niimi bastakal cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesusaqui tuz̈ kjaazic̈ha: —Felipe, anc̈hucatan az̈kpacha z̈ejlchinzala. ¿Anapanim wejr pajjo? Jakziltat wejr cherc̈haja, niz̈aza Yooz Ejp cherc̈ha. ¿Kjaz̈t am nuz̈ cjeejo, “Yooz Ejp cherkata”, cjicanajo? ");
INSERT INTO capNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wejrmi Yooz Ejpmi tsjii kuzzizza. ¿Jalla nii anam crii amya? Weriz̈ anc̈hucaquiz chiitaqui anaz̈ persun kuzquiztan chiyuc̈ha, antiz Yooz Ejpz̈ cuntiquiztan chiyuc̈ha. Yooz Ejpqui wejt kuzquiz z̈ejlc̈ha. Jalla niz̈tiquiztan niiz̈ cjen obranacal paa-uc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Wejrmi Yooz Ejpmi tsjii kuzzizza. Jalla nii criyaquic̈ha, jaziqui. Weriz̈ chiitiquiztan ana criyasaz̈ niiqui, weriz̈ paata obranaca cherz̈cu mekaz criyalla. ");
INSERT INTO capNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Werarapan anc̈hucaquiz chiyuc̈ha. Jakziltat wejtquiz criican tjapa kuzziz cjec̈haja, jalla niiqui weriz̈ paata obranaca irataz̈ zakaz paaquic̈ha, niz̈aza weriz̈ paata obranacquiztan juc'ant pajk obranaca paaquic̈ha, weriz̈ Yooz Ejpz̈quin ojktiquiztan. ");
INSERT INTO capNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wejtquiz tjapa kuzziz cjen, anc̈hucqui c̈hjul mayiztami Yooz Ejpz̈quiztan mayac̈haj niiqui, jalla nii mayiztiquiztan wejrkal c̈hjulumi tjaa-ac̈ha. Jalla nuz̈ tjaa-ac̈ha, weriz̈ cjen Yooz Ejp juc'ant honorchiz cjisjapa. Werjtc̈ha Yooz Majchqui. ");
INSERT INTO capNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Anc̈hucqui wejtquiz tjapa kuzziz cjen c̈hjul mayiztami mayac̈haja, jalla nii mayiztiquiztan wejr tjaa-ac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","‛Anc̈hucqui wejttan tjapa kuztan munazaquiz̈ niiqui, weriz̈ tjaata ortinanaca cazaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Wejrqui Yoozquiztan mayac̈ha, tsjii tjurt'iz̈iñi cuchanz̈quizjapa. Nii tjurt'iz̈iñiqui anc̈huca kuzquiz wiñayaz̈ kamaquic̈ha. Yooz Espíritu Santuc̈ha niiqui. ");
INSERT INTO capNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nii tjurt'iz̈iñiqui werara intintazkataquic̈ha. Ana criichi z̈oñinacz̈ kuzquiz anaz̈ luzasac̈ha. Ninacaqui nii tjurt'iz̈iñi ana cherasac̈ha, niz̈aza ana pajasac̈ha. Nii tjurt'iz̈iñiqui anc̈huca kuzquiz z̈ejlc̈ha. Jalla niz̈tiquiztan nii pajc̈ha anc̈hucqui. Niz̈aza wiñaya anc̈huca kuzquizpacha z̈elaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Wejrqui anc̈huc anal ecac̈ha maa ejp wajchallaz̈takaz. Anc̈hucaquin wilta tjonac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tsjii upacamakaz, nekztan ana criichi z̈oñinacaqui ana iya wejr cheraquic̈ha. Anchuczti wejr wilta cheraquic̈ha. Niz̈aza jacatatz̈cu wiñayjapa z̈etac̈ha. Weriz̈ z̈ejtchiz̈ cjen, anc̈huc zakaz wiñaya z̈etaquic̈ha Yooztan kamcan. ");
INSERT INTO capNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jacatatz̈tanaqui anc̈hucqui zizaquicha, wejrqui wejt Yooz Ejpz̈tan tsjii kuzzizza. Niz̈aza anc̈hucqui wejttan tsjii kuzzizza. Niz̈aza wejrqui anc̈hucatan tsjii kuzzizza. ");
INSERT INTO capNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Jakziltat weriz̈ mantita ortinanaca catokc̈haja, niz̈aza cumplic̈haja, jalla niiqui ultimuz̈ wejttanz̈ munazic̈ha. Niz̈aza jakziltat wejttan munazic̈haja, jalla niiz̈tan zakaz wejt Yooz Ejpqui munazic̈ha. Niz̈aza wejrzakal niiz̈tan munazuc̈ha. Niz̈aza wejrqui nii z̈oñz̈quiz kjanacama wejt puntu zizkatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nekztan Judas (anac̈ha Iscariotiqui) tuz̈ pewczic̈ha: —Wejt Jiliri, ¿kjaz̈tiquiztan amqui wejtnacaquizkaz pajkataquiya, am puntuquiztan zuma zizjapaya? Niz̈aza ¿kjaz̈tiquiztan parti z̈oñinacz̈quin am persuna ana pajkataquiya? ¿Kjaz̈tiquiztan nuz̈ cjeejo? ");
INSERT INTO capNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesusaqui tuz̈ kjaazic̈ha: —Jakziltat wejttanpan munazic̈haja, jalla niiqui weriz̈ chiita taku cazza, niz̈aza wejt Yooz Ejpqui niiz̈tan munazic̈ha, niz̈aza wejrnacqui niiz̈quin tjonuc̈ha, niiz̈ kuzquiz kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jakziltat wejttan ana munazic̈haja, jalla niiqui weriz̈ chiita taku ana cazza. Weriz̈ chiita takuqui anac̈ha wejt persun kuzquiztan. Antiz wejr cuchanz̈quiñi Yooz Ejpz̈ kuzquiztanpanc̈ha weriz̈ chiita takuqui. ");
INSERT INTO capNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‛Anc̈hucatan iya z̈ejlcan anc̈hucaquiz tii puntunaca chiyuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wejt wiruñ weriz̈ cjen Yooz Ejpqui tsjii tjurt'iz̈iñi cuchanz̈caquic̈ha. Yooz Espíritu Santuc̈ha nii tjurt'iz̈iñiqui. Jalla niiqui wejt cuntiquiztanz̈ cjequic̈ha. Niiqui anc̈hucaquiz tjapa Yooz puntunaca tjaajnaquic̈ha, niz̈aza tjapa weriz̈ chiita takunaca cjuñkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‛Wejrqui anc̈huca kuznaca jeejzkatuc̈ha. Anc̈huca kuznaca jeejzkatz̈cuqui okac̈ha. Z̈oñinacaqui anapanz̈ z̈oñz̈ kuz niz̈ta jeejzkatasac̈ha. Anc̈huca kuznacaqui anac̈ha turwaysi cjee, niz̈aza anac̈ha eksna. ");
INSERT INTO capNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Anc̈hucqui weriz̈ chiita nonzinc̈hucc̈ha: Okac̈ha, niz̈azal anc̈hucaquiz wiltal tjonac̈ha, jalla nii. Anc̈hucqui wejttan zuma munaztasaz̈ niiqui, chipchiz̈ cjitasac̈ha, nii weriz̈ chiitaz̈ cjen. Wejrqui wejt Yooz Ejpz̈quin okac̈ha. Wejt Yooz Ejpqui wejtquiztan juc'antic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ima ojkcan anc̈hucaquiz anziqui mazinchinc̈ha, jalla nuz̈ wattan wejtquiz tjapa kuztan criyajo. ");
INSERT INTO capNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","‛Tii muntuquiz z̈ejlñi z̈oñinacaz̈ mantiñiqui tjoncha. Jalla nii anawal mantiñi diabluqui Judasquiz cuchanz̈quic̈ha, wejr tankatzjapa. Jalla niz̈tiquiztan tsjii upacamakaz anc̈hucatan parluc̈ha. Pero nii anawal mantiñiqui wejtquiztan anac̈ha juc'ant azzizqui. Jazic niiqui wejr anaz̈ mantasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Wejrqui wejt Yooz Epiz̈ mantitacama okac̈ha. Jalla niz̈tiquiztan tii muntuquiz z̈ejlñi z̈oñinacaqui zizaquic̈ha, wejrqui Yooz Ejpz̈tan zuma munazic̈ha, jalla nii. Jaziqui z̈aaz̈na. Tekz̈tan ojkla. ");
INSERT INTO capNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","‛Wejrtc̈ha chekan lijitumtqui, tsjii zuma uwas muntiz̈takaz. Wejt Yooz Ejpqui nii munti cwitiñic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nii uwas muntiquiztan skoz uwas piz itzanacaz̈ pajkc̈ha. Jakzilta uwas piz itzat ana c̈hjerchiz pajkc̈haja, nii ana c̈hjerñi itzaqui c'utz̈taz̈ cjequic̈ha. Niz̈aza nii munti cwitiñiqui c̈hjerñi itzanaca zumpachaz̈ azquichaquic̈ha, juc'ant c̈hjeri pookajo. Yooz Ejpc̈ha nii munti cwitiñiqui. ");
INSERT INTO capNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Weriz̈ chiitiquiztan anc̈hucqui zuma kuzziz cjissinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Niz̈aza wejrqui anc̈hucatan tsjii kuzziztc̈ha. Jalla niz̈ta anc̈hucqui wejttan tsjii kuzziz cjee. Tsjii muntiquiztan ojkñi piz itzaqui nii muntiquiztan apakta cjequiz̈ niiqui, ana c̈hjerchiz cjisnasac̈ha. Antiz nii zuma muntiquiz pajkñi itzanacakaz c̈hjerasac̈ha. Jalla niz̈ta nii munti itzanaca irataz̈ anc̈hucqui. Anc̈hucqui wejttan ana tsjii kuzziz cjec̈haj niiqui, ana zuma kami atasac̈ha. Antiz wejttan tsjii kuzziz cjec̈haj niiqui, nekzipanz̈ zuma kamaña niz̈aza zuma obranaca tjeeznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‛Wejrtc̈ha nii zuma uwas muntiz̈takaztqui. Anc̈huczti nii uwas piz pajkñi itzanacaz̈takazza. Jakziltat wejttan ultimu tsjii kuzziz̈laj niiqui, niz̈aza wejrmi niiz̈tan tsjii kuzziz cjesaz̈ niiqui, jalla niic̈ha ancha zuma kamaña niz̈aza zuma obranaca tjeezñiqui. Jakziltat wejttan ana tsjii kuzziz̈laj niiqui, Yooz yujcquiz ana c̈hjul zum obranacami tjeeznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jakziltat wejttan ana tsjii kuzziz̈laj niiqui, Yoozquiztan chjatkattaz̈ cjequic̈ha. Nekztanaqui ana zuma kamañchiz cjen kjoñchi itsanacaz̈takaz cjequic̈ha. Jalla niz̈tiquiztan nii kjoñchi itsanacaz̈takaz ricujtaz̈ cjequic̈ha ujquin ujzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","‛Anc̈hucqui wejttan tsjii kuzziz̈laj niiqui, niz̈aza weriz̈ tjaajinta takunaca catokaquiz̈ niiqui, nekztan wejtquiztan c̈hjulumiz̈ mayasac̈ha. Nekztanaqui amiz̈ mayiztiquiztan tjaataz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Anc̈hucqui walja zuma obranaca tjeezñiz̈ cjen, Yooz Ejpqui honorchiz cjequic̈ha. Niz̈aza anc̈huca zuma obranacchiz cjen anc̈hucqui weriz̈ tjaajinta z̈oñinacc̈hucc̈ha, jalla nii kjanapachaz̈ tjeeznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Jaknuz̈t wejt Yooz Ejpqui wejttan zuma munazic̈haja, jalla niz̈tapacha wejr anc̈hucatan zuma munazuc̈ha. Weriz̈ anc̈hucatan munazñiz̈ cjen, jalla niipanz̈ cjuñzna. ");
INSERT INTO capNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Anc̈hucqui weriz̈ mantita ortinanaca cumplaquic̈ha. Jalla nekztan wejrqui anc̈hucatan tirapan munaziñil cjeec̈ha. Wejrqui wejt Yooz Epiz̈ mantita ortinanaca cazzinc̈ha. Jalla niz̈tiquiztan niiqui wejttan tirapanz̈ munazic̈ha. Jalla niz̈ta irata anc̈hucatan wejttan cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‛Jalla nii puntunaca anc̈hucaquiz chiyuc̈ha, wejttan chica cuntintuz̈ cjisjapa, niz̈aza anc̈huca kuznacami ancha cuntintu cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Weriz̈ mantita ortinaqui tuz̈uc̈ha, jaknuz̈t wejr amtan zuma munazituc̈haja, jalla niz̈ta irata anc̈hucqui porapat munazaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Jakziltat persunpacha niiz̈ mazinacz̈ laycu ticz̈aja, jalla niiqui, ancha munaziñi kuz tjeez̈a. Jalla niz̈ta z̈oñz̈quiztan anaz̈ juc'anti munaziñi kuzziz z̈oñic z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Anc̈hucqui weriz̈ mantitacama kamaquiz̈ niiqui, nekzipanc̈ha anc̈hucqui wejttan munaziñiqui. ");
INSERT INTO capNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tekztan najwcchuc anal anc̈hucaquiz “wejt piyunanacac̈ha” cjican cjesac̈ha. Tsjii piyunaqui c̈hjulut patruna paac̈haja, ana zizza. Wejrqui tjapa wejt Yooz Epiz̈ chiitaqui anc̈hucaquiz zizkatchinc̈ha. Jalla niz̈tiquiztan tekztan najwcchuc anc̈hucaquiz “wejt mazinacapanc̈ha” cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Anc̈hucqui ana wejr illzinc̈hucc̈ha. Wejrzti anc̈huc illzinc̈ha, niz̈aza apóstol puestuquiz utchinc̈ha, Yooz taku parli okajo, niz̈aza walja z̈oñinaca wejtquiz criiskatajo. Niz̈aza nii wejtquiz criichi z̈oñinacaqui wejtquiz tiraz̈ tjurt'aquic̈ha. Wejtquiz kuzziz cjen, c̈hjul mayiztami Yooz Ejpz̈quiztan mayac̈haja, jalla nii mayiztaqui tjaataz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Wilta anc̈hucaquiz mantuc̈ha: Porapat zuma munazaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‛Ana criichi z̈oñinacaz̈ anc̈hucatan chjaawjkatan, cjuñzna, jalla niz̈ta ninacaqui wejttan chjaawjkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ana criichi z̈oñinacz̈ partiraz̈ cjitasaz̈ niiqui, anc̈hucqui ninacz̈quiz munazita cjitasac̈ha. Pero wejrqui anc̈huc illzinc̈ha. Jalla niz̈tiquiztan anac̈ha ana criichi z̈oñinacz̈ partira anc̈hucqui. Niz̈aza niz̈tiquiztan anc̈hucqui ana criichi z̈oñinacz̈quiz ana munazita cjequic̈ha, niz̈aza chjaawjtaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Weriz̈ chiitac cjuñzna. Wejrqui cjichinc̈ha, “Tsjii piyunaqui niiz̈ patrunz̈quiztan anac̈ha juc'anti”. Ana criichi z̈oñinacaqui wejtquiz sufriskatchic̈ha. Niz̈aza ninacaqui anc̈hucaquiz zakaz sufriskataquic̈ha. Weriz̈ tjaajinta taku ana catokchic̈ha. Jaziqui anc̈hucaz̈ tjaajinta taku ana zakaz catokaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero ana criichi z̈oñinacaqui anc̈huca quintra cjequic̈ha, anc̈hucaz̈ wejtquiz kuzziz cjen. Nii quintranacaqui wejr cuchanz̈quiñi anaz̈ pajc̈ha. Jalla niz̈tiquiztan anc̈hucaquiz quintrazza. ");
INSERT INTO capNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Wejrqui ninacz̈quiz Yooz taku mazñi ana tjontasaz̈ niiqui, ninacaqui ana nii pajk ujchiz cjitasac̈ha. Pero wejrqui wejt puntuquiztan kjanapacha ninacz̈quiz chiichinc̈ha. Jalla niz̈tiquiztan ninacaqui ana c̈hjulumi chiyi atasac̈ha, casticz tjuñquiziqui. Niz̈aza ninacz̈quiziqui anaz̈ pertunac z̈elasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Jakziltat wejtquiz chjaawjkatc̈haja, jalla niiqui wejt Yooz Ejpz̈quiz zakaz chjaawjkatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Wejrqui ninacz̈ yujcquiz walja milajru obranaca paachinc̈ha, jakzilta wali z̈oñz̈quiztanami juc'anti. Pero anapanc̈ha wejtquiz criiz pecchic̈ha. Jaziqui pajk ujchiz cjissic̈ha. Jalla niz̈ta obranaca anal paatasaz̈ niiqui, ninacaqui ana nii pajk ujchiz cjitasac̈ha. Pero niz̈ta obranaca paachinc̈ha. Niz̈aza ninacaqui weriz̈ paata milajrunaca cherchic̈ha. Jalla nuz̈ cherz̈cumi, wejtquizimi wejt Yooz Ejpz̈quizimi chjaawjchipanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jalla nuz̈ ninacaz̈ chjaawjtaqui cjijrta Yooz taku cumplissic̈ha. Ninacz̈ liiquizpacha cjijrta Yooz takuqui, tuz̈ cjic̈ha: “Wejtquiz chjaawjchic̈ha ana c̈hjul razunz̈tan”. ");
INSERT INTO capNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‛Wejrqui Yooz Ejpz̈quiztan anc̈hucaquiz Yooz Espíritu Santo cuchanz̈cac̈ha. Jalla nii Yooz Ejpz̈quiztan tjonchi Espíritu Santuqui wejt puntuquiztan weraraz̈ intintazkataquic̈ha, niz̈aza anc̈hucaltajapa tjurt'iz̈inaquic̈ha. Jalla nii Espíritu Santuqui tjonz̈cu wejt puntuquiztan zizkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Primirquiztanpacha anc̈hucqui wejttan chica ojklaychinc̈hucpanc̈ha. Jalla niz̈tiquiztan anc̈huczakaz wejt puntuquiztan zizkataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‛Tjapa weriz̈ chiitanacaqui anc̈hucaquiz chiichinc̈ha, c̈hjul sufrisquiztanami tirapan wejtquin kuzziz cjisjapa, niz̈aza ana wejtquiztan zarakzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jazta timpuquiz anc̈hucqui ajcz kjuyanacquiztan chjatkattaz̈ cjequic̈ha. Niz̈aza tsjii sufris ora tjonaquic̈ha. Jalla nii oraqui jecmit anc̈huc conac̈haja, jalla nii conñi z̈oñiqui cjequic̈ha, “Wejrtc̈ha Yooz sirwintqui. Jalla niz̈tiquiztan nii z̈oñi conchinc̈ha”, nuz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nii anc̈huc conñi z̈oñinacami wejtquizimi wejt Yooz Ejpz̈quizimi anapan pajc̈ha. Jalla niz̈tiquiztan anc̈huc conasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Tjapa weriz̈ chiitanacaqui anc̈hucaquiz chiichinc̈ha, anc̈hucaquiz yanapzjapa. Nii sufris ora tjontanaqui jalla tii weriz̈ chiitanaca cjuñznaquic̈ha. Primirquiztanpacha tii sufris puntuquiztan anc̈hucaquiz kjanacama ana chiichinc̈ha. Anc̈hucatan kamiñtac̈ha. Jalla niz̈tiquiztan tii sufris puntu ana chiiz pecchintac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","‛Pero anz wajilla wejr cuchanz̈quiñiz̈quin okac̈ha. Anc̈hucaquiztan anaz̈ jakziltami wejr pewcz̈a, “¿Jakzit okac̈haja?” jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Anchucqui ancha llaquita cjissinc̈hucc̈ha, jalla nuz̈ weriz̈ chiiñiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero wejrqui werara takunaca chiyuc̈ha. Weriz̈ ojktanaqui waliz̈ cjequic̈ha anc̈hucaltaqui. Wejrqui anal okasaz̈ niiqui, tjurt'iz̈iñi Espíritu Santuqui anaz̈ tjonasac̈ha. Pero wejr ojkz̈cuqui nii Tjurt'iz̈iñi cuchanz̈cac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jalla niiqui tjonz̈cuqui, ana criichi z̈oñinacz̈ kuzquiz ninacz̈ persun uj tantiyaskataquic̈ha. Niz̈aza Yooziz̈ mantita kamañ puntu tantiyaskataquic̈ha, niz̈aza nii Espíritu Santuqui Yooz casticz puntu tantiyaskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Espíritu Santuqui ana criichi z̈oñinacz̈ kuzquiz persun uj tantiyaskataquic̈ha, wejtquiz ana criichiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Niz̈aza nii Espíritu Santuqui ana criichi z̈oñinacz̈ kuzquiz Yooziz̈ mantita kamañ puntu tantiyaskataquic̈ha, weriz̈ Yooz Ejpz̈quin ojkchiz̈ cjen. Jalla niz̈tiquiztan anc̈huc zakaz wejr ana iya cheraquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Tii muntuquiz mantiñi diabluqui Yooziz̈ yatisinz̈tac̈ha, ana walipanc̈ha, nii. Jazic niiqui castictaz̈ cjequic̈ha ultim juyzuquiz. Jalla niz̈tiquiztan Espíritu Santuqui ana criichi z̈oñinacz̈quiz Yooz casticz puntu tantiyaskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‛Iya juc'anti kjaz̈umi anc̈hucaquiz chiiz̈inznaca z̈ejlc̈ha wejttaqui. Pero anziqui anc̈hucqui anaz̈ nii intintazasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Werar intintazkatñi Espíritu Santuqui tjonz̈cu, anc̈hucaquiz tjaajnaquic̈ha tjapa weraranaca. Anaz̈ persun kuzquiztan tjaajnaquic̈ha, antiz Yoozquiztan nonz̈tanaca tjaajnaquic̈ha. Niz̈aza tekztan najwcchuc c̈hjulut watac̈haja, jalla nii zakaz tjaajnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Espíritu Santuqui wejt puntuquiztan anc̈hucaquiz tjaajnaquic̈ha. Jalla nuz̈ tjaajinñiz̈ cjen wejrqui honorchiz cjeec̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tjapa Yooz Epiz̈ chiitaqui wejrpankazza chiiñtqui. Tsjiikaztc̈ha wejrnacqui. Jalla niz̈tiquiztan wejrqui chiichinc̈ha, Espíritu Santuqui wejt puntuquiztan anc̈hucaquiz tjaajnaquic̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‛Upaquiz̈tancama anc̈hucqui wejr ana cheraquic̈ha. Nekztanaqui tsjii kjaz̈ majquiztan wejr wilta cheraquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nekztanaqui yekjap tjaajintanacaqui porapat pewcsassic̈ha, tuz̈ cjican: —¿Kjaz̈t cjii tjeejo, tuz̈ cjicanajo? “Upaquiz̈tancama anc̈hucqui wejr ana cheraquic̈ha. Nekztanaqui tsjii kjaz̈ majquiztan wejr wilta cheraquic̈ha”. Niz̈aza tiiqui “Wejrqui Yooz Ejpz̈quin okac̈ha”, cjic̈ha. Jalla nuz̈ cjican, ¿kjaz̈t cjii teejo? ¿C̈hjul puntut chii teejo? ");
INSERT INTO capNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ninacaqui cjichizakazza: —“Upaquiz̈tancama” chiicanaqui, ¿kjaz̈t cjii teejo? Anac̈ha intintazzuca tiiz̈ chiitaqui. ");
INSERT INTO capNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesusaqui persun kuzquiz zizatc̈ha, ninacaqui niiz̈quin tsjii pewcz pecatc̈ha, jalla nii. Jalla nekztanaqui Jesusaqui ninacz̈quiz tuz̈ cjichic̈ha: —Wejrqui chiichinc̈ha, tuz̈ cjican: “Upaquiz̈tancama anc̈hucqui wejr ana cheraquic̈ha, nekztanaqui tsjii kjaz̈ majquiztan wejr wilta cheraquic̈ha”. Jalla nuz̈ chiican, ¿kjaz̈t cjii? ¿Jalla niic̈ha ziz pecya? ");
INSERT INTO capNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ultim weraral anc̈hucaquiz cjiwc̈ha. Anc̈hucqui llaquita cjequic̈ha, niz̈aza kaaquic̈ha. Ana criichi z̈oñinacazti cuntintuz̈ cjequic̈ha. Anc̈hucqui llaquita kuzziz cjenami, tsjii kjaz̈ majquiztan ancha chipchipcan cuntintuzakaz cjisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Nonz̈na. Majtz ora irantiz̈can tsjaa maatak z̈onqui janchinaca walja mizkatiñc̈ha. Nekztan wawa majtz̈cuqui, naa maatak z̈onqui wawchiz cjen ana janchi mizkattami cjuñiñc̈ha. Wawchiz cjen, ancha cuntintuc̈ha naaqui. ");
INSERT INTO capNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jalla niz̈ta irataz̈ anc̈hucqui anziqui llaquita kuzzizza. Pero wejrqui am wilta cherac̈ha. Jalla nii oraqui anc̈huca kuznaca cuntintuz̈ cjequic̈ha. Niz̈aza nii anc̈huca cuntintu cjis kuzqui anaz̈ jecmi wilta niz̈ta llaquita cjiskatasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‛Nii orquiztan najwcchuc anc̈hucqui zizñi cjiscu wejr anaz̈ iya pewcnaquic̈ha. Anc̈hucaquiz weraral chiyuc̈ha. Wejtquiz tjapa kuztan cjen, anc̈hucqui Yooz Ejpz̈quiztan c̈hjulumi mayac̈haja, jalla nekztan weriz̈ cjen nii mayiztaqui tjaataz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tii oracama anc̈hucqui anaz̈ c̈hjulumi maychinc̈hucc̈ha wejt tjuuquiz. Mayiza, nekztanaqui tjaataz̈ cjequic̈ha, anc̈huca kuz juc'anti cuntintu cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","‛Tii oracama wejrqui anc̈hucaquiz ch'aman intintazzuc takunaca chiichinc̈ha. Tsjii tjuñiqui tjonc̈ha. Jalla nii tjuñquiztan niz̈ta ch'aman intintazzuc takunacami anal iya chiyac̈ha. Antiz Yooz Ejpz̈ puntuquiztan jalla niil kjanacama chiyac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nii oraqui anc̈hucqui wejt tjuuquiz c̈hjulquiztanamiz̈ mayizaquic̈ha. Nekztan wejrqui anc̈hucaltajapa anal iya maynac̈ha wejt Yooz Ejpz̈quiztanqui. ");
INSERT INTO capNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Anc̈hucqui wejttan munazichinc̈hucc̈ha. Niz̈aza wejtquiz criichinc̈hucc̈ha, wejrqui Yooz Ejpz̈quiztan tjonchi, jalla nii. Jalla niz̈tiquiztan Yooz Ejppacha anc̈hucatan munazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Wejrqui Yooz Ejpz̈quiztan tii muntuquiz tjonchinc̈ha. Niz̈aza tii muntuquiztan, wejt Yooz Ejpz̈quin quepac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jalla nekztanaqui niiz̈ tjaajintanacaqui cjichic̈ha: —Jaziqui ultimu kjanacama chiichamc̈ha, ana ch'aman intintazzuc takunacz̈tan. ");
INSERT INTO capNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jaziqui zizuc̈ha, amqui tjapa c̈hjulumi zizñampanc̈ha, nii. Ampankam wejtnaca kuzmi zizza. Jalla niz̈tiquiztan wejrnacqui anal iya pewcnasac̈ha. Niz̈aza wejrnacqui ultim chekpacha criyuc̈ha, amqui Yooz Ejpz̈quiztan tjonchamc̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesusaqui ninacz̈quiz tuz̈ kjaazic̈ha: —¿Jaziqui anc̈hucqui ultim chekpacha criichinc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Tsjii ora wajic̈ha. Anzpachac̈ha nii oraqui. Nii oraqui anc̈hucqui wichanziz̈ cjequic̈ha, niz̈aza zina zina wichanziz̈ cjequic̈ha. Wejrqui zinalla ectal cjeec̈ha. Pero wejr zina ecta cjenami, wejrqui ana zina cjeec̈ha. Wejt Yooz Ejpz̈ wejttan chica cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jaziqui tjappacha tii takunaca anc̈hucaquiz chiichinc̈ha, wejtquiz kuzziz cjen, cuntintu cjisjapa. Tii muntuquiz z̈ejlcan anc̈hucqui sufraquic̈ha. Walja tjup kuzzizpan cjee. Wejrqui tjapa liju atipchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jalla nuz̈ chiiz̈cu Jesusaqui tsewcchuc arajpach kjutñi cherzic̈ha. Nekztan Yooz Ejpz̈tan parlichic̈ha, tuz̈ cjican: —Yooz Tatay. Wejt sufris ora tjonc̈ha. Wejrtc̈ha am Majchtqui. Wejtquiz honorchiz cjiskatalla. Nekztan wejrqui amquiz juc'ant honorchiz cjiskatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Tjapa z̈oñinaca mantizjapa, jalla nii poder wejtquiz tjaachamc̈ha. Jakziltami amqui wejtquiz intirjic̈haja wejt parti cjisjapa, jalla ninacz̈quiz arajpachquin wiñaya kamkatac̈ha wejrqui. ");
INSERT INTO capNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Amc̈ha zinta werara Yoozqui. Niz̈aza wejrtc̈ha Jesucristutqui; amiz̈ cuchanz̈quita Z̈oñtc̈ha. Wejt parti z̈oñinacaqui amquizimi wejtquizimi pajc̈ha. Jalla niz̈tiquiztan arajpachquin uc̈humtan wiñaya kamaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","‛Tii muntuquiz kamcan amquiz honorchiz cjiskatchinc̈ha. Niz̈aza amiz̈ mantita obranaca z̈erzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jaziqui, Yooz Tatay, amquin wilta quejpz̈cu, arajpachquin amtan chica z̈elaquic̈ha. Nekztan wejtquiz honorchiz cjiskatalla. Ima tii muntu z̈elan, wejrqui amtan chica honorchiztala. Jalla niz̈ta tuquita honorchiz irata wilta wejtquiz honorchiz cjiskatalla. ");
INSERT INTO capNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‛Amqui z̈oñinaca illzamc̈ha, wejt partiquiz cjisjapa. Jalla nii z̈oñinacz̈quiz intintazkatchinc̈ha am puntuquiztan. Ninacaqui amtac̈ha. Niz̈aza wejt parti cjisjapa wejtquiz tjaachamc̈ha. Niz̈aza ninacaqui am takunac jaru kamc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jaziqui wejt partir z̈oñinacaqui zizza, tjapa weriz̈ chiitaqui amquiztan tjonñicamac̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Amiz̈ chiita takunacacama ninacz̈quiz tjaajinchinc̈ha. Jalla nekztan ninacaqui weriz̈ tjaajinta catokchic̈ha. Niz̈aza weriz̈ tjaajinta z̈oñinacac̈ha zizñipanqui, wejrqui amquiztan tjonchinc̈ha, jalla nii. Niz̈aza criichipanc̈ha, amqui tii muntuquiz wejr cuchanz̈quichamc̈ha, nii. ");
INSERT INTO capNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‛Jaziqui ninacz̈tajapa amquiz mayizuc̈ha. Ana criichi z̈oñinacz̈tajapa anal mayizuc̈ha. Antiz wejt partir z̈oñinacz̈tajapakaz mayizuc̈ha, amiz̈ illzñiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Amtac̈ha tjapa wejt partir z̈oñinacaqui. Niz̈aza wejttac̈ha ninacaqui. Jalla ninacaz̈ cjen wejrqui honorchizza. ");
INSERT INTO capNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","‛Wajilla ana iya tii muntuquiz kamac̈ha. Nii wejt partir z̈oñinacaz̈ eclaquic̈ha. Tii muntuquiz tira z̈elaquic̈ha ninacaqui. Wejrzti amquin quejpz̈cac̈ha. Zuma arajpach Yooz Tatay, tii z̈oñinaca wejtquiz tjaachamc̈ha. Jaziqui am aztan tinaca tirapan cwitalla, tsjii kuzziz cjeyajo, jaknuz̈t uc̈humqui tsjii kuzzizlaja, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tii muntuquiz tinacz̈tan kamcan, tii z̈oñinaca cwitichinc̈ha, am aztan. Niz̈aza tinacz̈quiztan tsijtsinchinc̈ha c̈hjulquiztanami ana kjaz̈ cjisnajo. Tsjiiqui pertissipanc̈ha. Jalla nuz̈ pertisjapa nii Judas Iscariotiqui z̈ejltkalc̈ha. Jalla nuz̈ cjen tuquita cjijrta Yooz taku cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","‛Anziqui wejrqui amquin quejpz̈cac̈ha. Iya tsjii zkolucz̈tan tii muntuquiz kamcan wejrqui tinacz̈quiz chiiz̈inuc̈ha, wejtquiz criichi z̈oñinacaz̈ wejrz̈tapacha cuntintu cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Wejrqui tinacz̈quiz am taku tjaajinchinc̈ha. Jaknuz̈t wejrqui ana criichi z̈oñinacz̈ partiquiz ana z̈elatuc̈haja, jalla niz̈ta irata wejtquiz criichi z̈oñinacaqui ana z̈ejlc̈ha ana criichi z̈oñinacz̈ partiquiz. Jalla niz̈tiquiztan ana criichi z̈oñinacaqui ninacz̈quiz chjaawjc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Amquiztan ana mayizuc̈ha, wejt z̈oñinacaz̈ tii muntuquiztan chjichtaz̈ cjisjapa. Antiz amquiztan mayizuc̈ha, ana wal diabluz̈quiztan wejt z̈oñinaca tsijtsinta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jaknuz̈t wejrqui ana criichi z̈oñinacz̈ partiquiz ana z̈elatuc̈haja, jalla niz̈ta irata wejt z̈oñinacaqui ana z̈ejlc̈ha, ana criichi z̈oñinacz̈ partiquiz. ");
INSERT INTO capNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amiz̈ chiitaqui ultim werarac̈ha. Am takuz̈ cjen wejtquiz criichi z̈oñinaca zuma kamañchiz cjiskata. C̈hjul ana zuma kamañquiztanami zarakskata. ");
INSERT INTO capNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jaknuz̈t amqui tii muntuquiz z̈ejlñi z̈oñinacz̈ kjutñi wejr cuchanz̈quic̈haja, jalla niz̈aza wejrqui tii muntuquiz z̈ejlñi z̈oñinacz̈ kjutñi wejt z̈oñinaca cuchnuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wejtquiz criichi z̈oñinacz̈tajapa ancha kuztanc̈ha wejrqui ticzjapa. Niz̈aza am werar tawk jaru kamtiquiztan tii z̈oñinaca t'akz̈inuc̈ha amta cjeyajo. ");
INSERT INTO capNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‛Wejrqui tii tekz̈ta z̈oñinacz̈tajapa alaja anal mayizuc̈ha, antiz tjapa wejtquiz anzimi wiruñami criichi z̈oñinacz̈tajapa mayizuc̈ha. Tii tekz̈ta z̈oñinacaz̈ Yooz taku paljaytiquiztan yekjapanacaqui wejtquiz criyaquic̈ha. Jalla ninacz̈tajapa zakaz mayizuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Jalla tjapa ninacz̈tajapa mayizuc̈ha tsjii kuzziz cjisjapa. Yooz Tatay, amqui wejttan tsjii kuzzizza. Niz̈aza wejrqui amtan tsjii kuzziztc̈ha. Jalla niz̈ta irata ninacaqui uc̈humnacaquiz tsjii kuzziz cjila. Jalla nuz̈ mayizuc̈ha, tii muntuquiz z̈ejlñi z̈oñinaca criyajo, am wejr cuchanz̈quichi, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Amiz̈ wejtquiz tjaata arajpach kamaña, jalla nii kamaña ninacz̈quiz cjiskatchinzakazza, tsjii kuzziz cjeyajo, jaknuz̈ uc̈humqui tsjii kuzzizzalaja, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jaknuz̈t amqui wejttan z̈ejlc̈haja, jalla niz̈tac̈ha wejrqui ninacz̈tan z̈elac̈ha, ninaca tsjii kuzzizpan cjeyajo. Jalla niz̈tiquiztan z̈oñinacaqui zizaquic̈ha, amqui wejr cuchanz̈quichic̈ha, jalla nii. Niz̈aza z̈oñinacaqui zakaz zizaquic̈ha, amqui ninacz̈tan munazic̈ha, jaknuz̈t amqui wejttan munazic̈haja, jalla niz̈ta. ");
INSERT INTO capNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‛Yooz Tatay, amqui wejtquiz tii z̈oñinaca tjaachamc̈ha, wejtquiz criyajo. Jalla tinacaqui wejttan chica kamñijapa pecuc̈ha, jakziquin wejr z̈elac̈haja, jalla nicju. Jalla nuz̈ juntu z̈ejlcan tinacaqui wejt arajpach kamaña kjana cheraquic̈ha. Ima tii muntu z̈elan, wejttan munaziñiz̈ cjen amqui wejtquiz nii arajpach kamaña tjaachamc̈ha. Jalla nii kamaña cheraquic̈ha wejt partir z̈oñinacaqui. ");
INSERT INTO capNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ultim lijitum Tatayi ana criichi z̈oñnacaqui am anaz̈ pajc̈ha. Wejrzti am pajuc̈ha. Niz̈aza jalla tinacaqui zizza, amqui wejr cuchanz̈quichamc̈ha, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Am puntuquiztan tinacz̈quiz zumpacha intintazkatchinc̈ha. Niz̈aza wejrqui tiral intintazkatuc̈ha, ninacaz̈ zuma munazizjapa, jaknuz̈t uc̈humqui zuma munazic̈haja, jalla niz̈ta. Niz̈aza am puntuquiztan ninacz̈quiz intintazkatuc̈ha, wejr ninacz̈tan tsjii kuzziz cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesusaqui nuz̈ chiiz̈cu niiz̈ tjaajintanacz̈tan ojkchic̈ha. Cedrón cjita k'awz̈ tsjii latuquin ojkchic̈ha. Jalla nicju ch'ojñi muntinaca z̈elatc̈ha. Nijcchuc luzzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jesusaqui nii yokquin kjaz̈ wilta ajczñipantakalc̈ha niiz̈ tjaajintanacz̈tan. Tarazunñi Judasqui nii yoka pajchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jalla nicju Judasqui zultatunacami, niz̈aza timplu wijilñi zultatunacami, jalla ninaca chjitchic̈ha. Timplu jilirinacami, fariseo z̈oñinacami jalla ninacac̈ha nii timplu wijilñi zultatunaca cuchanchiqui. Ninacaqui irantichic̈ha michanacz̈tan teyanacz̈tan pajk cuchillunacz̈tan, niz̈aza wjajtz carotinacz̈tan. Jalla niz̈tanacz̈tan irantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesusaqui c̈hjulut watac̈haja, jalla nii tjapa zizatc̈ha. Nii tjonchi z̈oñinacz̈quiz macjatz̈cu, pewczic̈ha, tuz̈ cjican: —¿Jectc̈ha kjur anc̈hucjo? ");
INSERT INTO capNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jalla ninacaqui kjaazic̈ha, tuz̈ cjican: —Wejrnacqui kjuruc̈ha Jesusa, nii Nazaret wajtchiz z̈oñi. Jesusaqui tuz̈ kjaazic̈ha: —Wejrtc̈ha niitqui. Judas, nii tarazuñi z̈oñiqui ninacz̈tan chica tsijtchi z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesusaz̈ “Wejrtc̈ha niitqui” cjitiquiztan nii tanñi z̈oñinacaqui wir kjutñi atz̈cu porapat tewksarascu yokquiz tjojtassic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesusaqui wilta pewczic̈ha: —¿Jectpan anc̈huc kjurjo? —cjican. Ninacaqui wilta kjaazic̈ha, tuz̈ cjican: —Wejrnacqui kjuruc̈ha Jesusa, nii Nazaret wajtchiz z̈oñi. ");
INSERT INTO capNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesusaqui nekztan zakaz cjichic̈ha: —Wejrtc̈ha cjichinsala. Anc̈hucqui wejr kjurc̈ha. Jaziqui tii parti z̈oñinaca cutznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jalla nekztan Jesusaz̈ tuqui chiita taku cumplissic̈ha. Tuquiqui Jesusac̈ha chiichiqui, jalla tuz̈: “Yooz Epiz̈ wejtquiz tjaata z̈oñinacaqui ana tsjiimi pertichinc̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simón Pedruqui pajk cuchillchiztac̈ha. Jalla nii cuchillu jwescu, Pedruqui timplu jilirz̈ piyunz̈ z̈ew cjuñi pootz̈cu chjajtz̈inchic̈ha. Jalla nii cjuñi chjajtz̈inta z̈oñiqui Malco cjitatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Nekztanaqui Jesusaqui Pedruz̈quiz cjichic̈ha: —Am cuchillu cuchillz̈ z̈ejlz̈quiz quijtz̈na. Wejt Yooz Ejpz̈ pinsita kuz jaru wejtlaqui sufristanc̈ha. ¿Anaj wejr tii sufrasajo? ");
INSERT INTO capNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jalla nekztanaqui zultatunacami, zultatz̈ comandantimi, niz̈aza judío timplu wijilñi zultatunacami, jalla ninacaqui Jesusa tanz̈cu kjara jwerz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nekztan Anás cjita jilirz̈ kjuyquiz chjitchic̈ha. Anasqui Caifás ajmuz̈ ejptac̈ha. Jalla nii wata Caifasqui timplu chawjc jiliritac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nii Caifasqui tuquiqui tuz̈ cjitkalc̈ha: “Uc̈humnacaltajapa tsjii z̈oñi ticstanc̈ha, tjapa z̈oñinaca ana conta cjeyajo”. ");
INSERT INTO capNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesusa chjichan, Simón Pedruz̈tan tsjii tjaajinta z̈oñz̈tan Jesusa apzic̈ha. Nii tsjii Jesusiz̈ tjaajinta z̈oñiqui timplu jiliriz̈ pajtatac̈ha. Jalla niz̈tiquiztan Jesusiz̈quiz apz̈cu nii timplu jilirz̈ patiuquin luzzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pedruqui ana pajtaz̈ cjen zancu eclichic̈ha. Nekztan nii tsjii luzzi tjaajinta z̈oñiqui ulanz̈quichic̈ha, naa ulanz zanquiz cwitiñi z̈onaquin paljayzjapa. Jalla nuz̈ paljayz̈cu patiuquiz Pedro luzkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nekztan naa cwitiñi z̈onqui Pedruz̈quiz pewczinc̈ha, tuz̈ cjican: —¿Anaj am zakaz nii z̈oñz̈tan chica ojklayñamtajo? Nekztan Pedruqui chiichic̈ha: —Anaz̈ wejr, —cjican. ");
INSERT INTO capNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ch'uñuriz̈ cjen piyunanacami timplu zultatunacami uj taazic̈ha carpunz̈tan. Nekztan nii uj parazquiz tsijtchi kutnatc̈ha. Ninacz̈tan chica Pedruqui tsijtchi zakaz z̈elatc̈ha, kutuncan. ");
INSERT INTO capNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jalla nekztanaqui timplu chawjc jiliriqui Jesusa pecunchic̈ha, niiz̈ tjaajinta z̈oñinacz̈ puntuquiztanami niz̈aza niiz̈ persun tjaajintami. ");
INSERT INTO capNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Tjapa z̈oñinacz̈ yujcquiz tjaajinchinc̈ha. Uc̈hum ajcz kjuyquizimi timpluquizimi tjaajinchinc̈ha. Timpluquiz tjapa z̈oñinaca ajczñic̈ha. Ana chjojzaka tjaajinchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Kjaz̈tiquiztan nuz̈ wejr pecunjo? Weriz̈ tjaajinta nonzñi z̈oñinacz̈quiz pewczna, c̈hjulut tjaajintuc̈haja, jalla nii. Jalla ninacaqui weriz̈ tjaajintanaca zizza. ");
INSERT INTO capNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jalla nuz̈ chiitan, tsjii nekz tsijtchi z̈ejlñi zultatuqui Jesusa yujcquiz kjarz̈tan tsjajpchic̈ha, tuz̈ cjican: —¿Jalla nuz̈ timplu jilirz̈quiz kjaazkaya? ");
INSERT INTO capNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesusaqui nii zultatz̈quiz kjaazic̈ha, tuz̈ cjican: —Wejr ana zuma chiituc̈haj niiqui, ¿jaknuz̈t cjican ana zuma chiichintajo? Zumal chiyuc̈ha. ¿Kjaz̈tiquiztan am wejr tsjajpjo? ");
INSERT INTO capNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jalla nekztanaqui Jesusa kjara jwerz̈intapacha cuchanchic̈ha Caifás timplu chawjc jilirz̈quin. ");
INSERT INTO capNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jalla nii oraqui Simón Pedruqui tsijtchi z̈elatc̈ha nii ujquiz kutuncan. Tsjii tsjii nekz z̈ejlñi z̈oñiqui Pedruz̈quiz cjichic̈ha: —Amqui nii z̈oñz̈tan chica ojklayñamc̈ha, ¿ana jaa? Pedruqui toscara chiichic̈ha: —Anac̈ha wejrqui, —cjican. ");
INSERT INTO capNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jalla nekztanaqui tsjii timplu jilirz̈ piyunaqui Pedruz̈quiz pewczizakazza. Nii piyunaqui nii cjuñi chjajtz̈inta piyunz̈ familiatac̈ha. Jalla tuz̈ cjican pewczic̈ha: —Nii munti yokquin nii z̈oñz̈tan chica am cherchinla, ¿ana jaa? ");
INSERT INTO capNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pedruqui wilta toscara chiichic̈ha. Jalla nuz̈ wilta toscara chiyan, nii orapacha tsjii querwallpi jora kjawchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jalla nekztanaqui Caifás cjita z̈oñz̈quiztan Jesusaqui chjichtac̈ha pajk mantiñiz̈ kjuyquin. Waj kjantatitac̈ha. Nii judío z̈oñinacapacha nii pajk mantiñiz̈ kjuyquin ana luzzic̈ha, ninacz̈ cuzturumpi cjen. Jalla nuz̈ luztasaz̈ niiqui, pascua pjijzta c̈hjeri ana lujltasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jalla niz̈tiquiztan Pilatuqui ninacz̈quiz paljayi ulanz̈quichic̈ha, tuz̈ cjican: —Anc̈hucqui, ¿c̈hjul ujz̈ tii z̈oñz̈ quintra jwes pecya? ");
INSERT INTO capNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Z̈oñinacaqui tuz̈ kjaazic̈ha: —Tii z̈oñiqui ana c̈hjul pajk ujnacami paatasaz̈ niiqui, anal wejrnacqui tii intirjitasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nekztanaqui Pilatuqui ninacz̈quiz cjichic̈ha: —Anc̈huckaz chjicha, anc̈huca lii jaruz̈ justicia paaz̈ca. Nii z̈oñinacaqui kjaazic̈ha, tuz̈ cjican: —Wejtnacalta z̈oñi conzqui lii quintrac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Niiz̈ tuquiqui Jesusaqui chiitkalc̈ha, persun ticz puntuquiztan, jaknuz̈t ticznac̈haja, jalla nii. Niz̈aza niiz̈ chiitaqui cumplisnaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilatuqui wilta niiz̈ kjuyquin luzquichic̈ha. Jesusa kjawz̈cu, niiz̈quiz pewczic̈ha, tuz̈ cjican: —¿Judío z̈oñinacz̈ chawc jilirimkaya? ");
INSERT INTO capNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —¿Amqui jalla nuz̈ persun kuzquiztan wejr pewcz̈ya? Uz̈ ¿yekja z̈oñinaca amquiz nuz̈ pewczna cjichi jaa? ");
INSERT INTO capNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatuqui tuz̈ kjaazic̈ha: —Wejrqui judío z̈oñt, ¿jaa? Am persun wajtchiz z̈oñinacami niz̈aza am persun timplu jilirinacami, jalla nii z̈oñinacac̈ha wejtquin am intirjichiqui. ¿C̈hjul uj paachamt, amjo? ");
INSERT INTO capNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesusaqui nekztan cjichic̈ha: —Wejtla mantizqui anac̈ha tii muntuquiztan. Tii muntuquiztan wejtla mantiz cjesaz̈ niiqui, wejt piyunanaca kichaskatasac̈ha wejt quintra z̈oñinacz̈quiz, ana wejr intirjita cjisjapa. Pero wejtla mantizqui anac̈ha tii muntuquiztanaqui. ");
INSERT INTO capNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Nekztan Pilatuqui cjichic̈ha: —¿Niz̈taqui amc̈halani mantiñi jilirinqui? Jesusaqui cjichic̈ha: —Jesalla, wejr mantiñi jilirtchiya, am chiic̈ha jalla nuz̈. Tii muntuquiz tjonz̈cu nassinc̈ha, werara puntu tjaajinzjapa. Jakziltat nii werara tjaajinta jaru kamc̈haja, jalla niiqui weriz̈ chiita taku nonz̈a. ");
INSERT INTO capNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jalla nuz̈ chiitiquiztan Pilatuqui cjichic̈ha: —Werara puntuqui, ¿c̈hjulut neejo? Jalla nuz̈ pewcz̈cu Pilatuqui wilta ulanchic̈ha judío z̈oñinacz̈quin parli. Ninacz̈quiz cjichic̈ha: —Wejrqui tii z̈oñz̈quiz ana c̈hjul ujmi jwesi atuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pascu pjijztiquiz anc̈hucalta tsjii custurumpi z̈ejlc̈ha, wejtla tsjii preso tanta z̈oñi cutzqui. ¿Tii judío wajtchiz chawjc jiliri cutznaquiya? ¿Jalla nuz̈ cutskatz pecya? ");
INSERT INTO capNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Judío z̈oñinacaqui kjawchic̈ha: —¡Tii z̈oñi ana cutzna! ¡Barrabás cutzna! —cjican. Barrabasqui tsjii anawal tjañi z̈oñitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jalla nekztanaqui Pilatuqui wilta kjuylchuc Jesusa majcchic̈ha. Nekztanaqui Jesusiz̈quiz wjajtajo mantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Nekztan zultatunacaqui ch'apquiztan tsjii pilluz̈takaz paachic̈ha. Jalla nii paatiz̈tan Jesusiz̈ achquiz tewz̈inchic̈ha. Niz̈aza jilirz̈ murat zquiti tjutzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Jalla nuz̈ paaz̈cu niiz̈quin macjatchic̈ha, —¡Viva, judío z̈oñinacz̈ chawjc jiliri! —cjican. Niz̈aza Jesusiz̈ yujcquiz kjarz̈tan tsjajpchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nekztan Pilatuqui judío z̈oñinacz̈quin wilta ulanz̈quichic̈ha. Nekztan ninacz̈quiz cjichic̈ha: —Cherzna. Anc̈hucaz̈ intirjita z̈oñi ticju jwescac̈ha, anc̈huc zumpacha intintazajo. Wejrqui tii z̈oñz̈quiz anal c̈hjul ujmi jwesi atuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jalla nekztan Jesusaqui ulanzkatz̈quichic̈ha. Ch'apquiztan paataqui achquiz tewz̈inta, niz̈aza jilirz̈ murat zquiti tjutz̈ta. Nekztanaqui Pilatuqui ninacz̈quiz cjichic̈ha: —Tiic̈ha anc̈hucaz̈ intirjita z̈oñiqui. ");
INSERT INTO capNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Timplu jilirinacami, niz̈aza timplu wijilñi zultatunacami nii cherz̈cu, alto jorz̈tan kjawcan, chiichic̈ha: —¡Cruzquizkaz ch'awczna! ¡Cruzquizkaz ch'awczna! —cjican. Pilatuqui ninacz̈quiz cjichic̈ha: —Way, niz̈tacz̈ chjicha anc̈hucqui, niz̈aza cruzquiz ch'awcz̈ca. Pero wejrqui ana c̈hjul ujmi tiiz̈quiz jwesi atchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nekz z̈ejlñi judionacaqui tuz̈ kjaazic̈ha: —Wejrnacqui liichiztc̈ha. Wejtnaca lii jaru tii z̈oñic ticstanc̈ha, tiiqui “Wejrtc̈ha Yooz Majch” cjican ojklaychiz̈ cjen. ");
INSERT INTO capNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jalla nii chiita taku nonz̈cu, Pilatuqui tsjan eksic̈ha Jesusiz̈quiztan. ");
INSERT INTO capNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jalla niz̈tiquiztan Pilatuqui niiz̈ kjuya wilta luzzic̈ha Jesusiz̈quin pewczjapa. Jalla tuz̈ pewczic̈ha: —¿Jakziquiztan z̈oñipant amya? Jesusazti ana c̈hjulumi kjaazic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jalla niz̈tiquiztan Pilatuqui niiz̈quiz wilta paljaychic̈ha, tuz̈ cjican: —¿Kjaz̈tiquiztan am ana wejtquiz kjaazjo? Wejrqui mantasac̈ha, am cutzjapa. Niz̈aza mantasac̈ha cruzquiz ch'awczjapa, ¿Jalla nii ana ziz amjo? ");
INSERT INTO capNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesusaqui niiz̈quiz kjaazic̈ha, tuz̈ cjican: —Yoozqui amquiz mantiz poder ana tjaatasaz̈ niiqui, amtaqui mantiz poder ana z̈ejltasac̈ha. Yooz amquiz mantiz poder tjaachiz̈ cjenkaz wejr mantasac̈ha. Jalla niz̈tiquiztan jecc̈halaj amquiz wejr intirjichi, jalla ninacac̈ha amquiztan juc'ant ujchizqui. ");
INSERT INTO capNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jalla nuz̈ nonz̈cu Pilatuqui Jesusa anchaz̈ jaknuz̈umi cutz pecatc̈ha pero nii judío z̈oñinacazti kjawz̈can chiichic̈ha, tuz̈ cjican: —Tii z̈oñi cutznaquiz̈ niiqui, am zakaz César tsjan chawjc jilirz̈ quintra paaquic̈ha. Jakziltat “Wejrtc̈ha chawjc jiliritqui” cjican chec̈haj niiqui, César chawjc jilirz̈ quintraz̈ paac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatuqui jalla nuz̈ nonz̈cu, zultatu mantichic̈ha, Jesusa zancchuc jwescajo. Zancchuc jwesquichic̈ha Gabata cjita patiuquin. Gabata tuz̈ cjic̈ha, maznacz̈tan curta, jalla nii. Jalla nicju Pilatuqui jusjiiz julzquiz julzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Jalla nii tjuñiqui tjacz tjuñitac̈ha jaka pascua pjijztaz̈ cjen. Niz̈aza taypurutac̈ha. Nekztanaqui Pilatuqui nii judío z̈oñinacz̈quiz cjichic̈ha: —Tiic̈ha anc̈huca chawjc jiliriqui. ");
INSERT INTO capNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ninacaqui kjawchic̈ha, tuz̈ cjican: —¡Ticz̈la tiiqui! ¡Ticz̈la tiiqui! ¡Cruzquiz ch'awcz̈la! Nekztan Pilatuqui ninacz̈quiz cjichic̈ha: —¿Kjaz̈t anc̈huca tsjan chawjc jiliri ch'awcznas? Nii timplu jilirinacaqui tuz̈ kjaazic̈ha: —Wejtnacaltaqui zinta tsjan chawjc jiliri z̈ejlc̈ha, César cjitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jalla nekztanaqui Pilatuqui ninacz̈ kuzcama Jesusa intirjichic̈ha cruzquiz ch'awcta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jalla nekztanaqui Jesusaqui chjichtatac̈ha. Persuna cruza kuzi ojkkatchic̈ha Ach Tsjij cjita tjuuchiz yokquin. Nii yokaqui hebreo tawkquiz Gólgota cjitatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Jalla nicju cruzquiz ch'awctatac̈ha, niz̈aza niiz̈tan chica tsjii pucultan z̈oñinaca yekja cruzanacquiz ch'awctazakaztac̈ha, Jesusiz̈ porap kjuttan, Jesusazti ninacz̈ taypiquiz. ");
INSERT INTO capNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Niz̈aza Pilatuqui tsjii letrero paakatchic̈ha, tuz̈ cjican: “Jesusa Nazaret wajtchiz z̈oñi. Judionacz̈ tsjan chawjc jiliri”. Jalla nii paaz̈cu Jesusiz̈ ach juntuñ cruzquiz ch'awcz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Chawc wajt z̈cati Jesusaqui cruzquiz ch'awctatac̈ha. Jalla niz̈tiquiztan walja judío z̈oñinacaqui niiz̈ letrero liichic̈ha. Nii letreruqui c̈hjep tawkquiztan cjijrtatac̈ha, hebreo tawkquiztanami, griego tawkquiztanami, niz̈aza latín tawkquiztanami. ");
INSERT INTO capNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Nii letrero cherz̈cu timplu jilirinacaqui Pilatuz̈quiz cjichic̈ha: —Ana cjijra, “Judionacz̈ tsjan chawjc jiliri” cjicanaqui. Antiz cjijra, “Tii z̈oñiqui cjic̈ha, ‘Wejrtc̈ha judionacz̈ tsjan chawjc jiliritqui’ ”. Jalla nuz̈ cjijra. ");
INSERT INTO capNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilatuqui tuz̈ kjaazic̈ha: —Jaknuz̈t cjijrchinz̈laja, nuz̈upanikaz cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Zultatunacaqui Jesusa cruzquiz ch'awcz̈cu niiz̈ zquiti ricujchic̈ha. Niz̈aza pajkpic partiquiz tojzic̈ha, nii pajkpaltan zultatunacaqui. Tsjii pajk tol zquitiqui ana ch'ucuchiz watztatac̈ha, tsewcchuc kozzuc pakjipacha. ");
INSERT INTO capNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jalla niz̈tiquiztan nii zultatunacaqui porapat kazassic̈ha, tuz̈ cjican: —Anac̈hum wjajrla. Antiz surtiila. Tii zquitiqui jecz̈quizkat surti cayac̈hani niiz̈taz̈ cjequic̈ha. Jalla nuz̈ paatan cjijrta Yooz takuqui cumplissic̈ha. Cjijrta Yooz taku tuz̈ cjic̈ha: “Ninacz̈pora wejt zquiti tojzic̈ha, niz̈aza parti zquitquiztan surtiyassic̈ha”. Jalla nuz̈ paachic̈ha nii zultatunacaqui. ");
INSERT INTO capNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jalla nekz Jesusiz̈ cruz z̈cati tsijtsiñ z̈elatc̈ha, Jesusiz̈ maa; niz̈aza niiz̈ maa cullaqui; niz̈aza María (Cleofas tjuntac̈ha); niz̈aza María Magdalena; nii pajkpaltan z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesusaqui niiz̈ maa cherchic̈ha. Niz̈aza niiz̈ pecta tjaajinta z̈oñi naaz̈a z̈cati tsijtchi z̈elatc̈ha. Jalla nuz̈ cherz̈cu Jesusaqui niiz̈ maaquiz cjichic̈ha: —Maataka, tiic̈ha am maati cunta. ");
INSERT INTO capNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nekztanaqui nii tjaajinta z̈oñz̈quiz cjichizakazza: —Taac̈ha am maaqui. Jalla nekztanpacha nii tjaajinta z̈oñiqui Jesusiz̈ maa ricujz̈cu persun kjuya chjitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jalla nekztanaqui Jesusaqui zizzic̈ha, tjapa Yooz Epiz̈ tjaata langznaca liwj z̈erz̈tapantac̈ha, jalla nii. Nekztan cjichic̈ha: —Kjaz kjaral paznuc̈ha. Jalla nuz̈ cjican, cjijrta Yooz takuqui cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jalla nekzi tsjii ojch z̈elatc̈ha jar vinchiz. Jalla nekztanaqui kjaz ch'umñi esponja t'awzic̈ha nii vinquiz. Nekztan hisopo cjita munti parquiz chjapz̈cu, Jesusiz̈ atquin ch'iiz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesusaqui nii jar vinu licz̈cu, nekztan cjichic̈ha: —Tjapaz̈ cumplissay. —Jalla nuz̈ chiiz̈cu Jesusaqui acha colz̈cu ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Pascua pjijzta tjacz tjuñitac̈ha. Niiz̈ jakataz̈u jeejz tjuñitac̈ha, niz̈aza chawc pjijzti tjuñitac̈ha. Jalla niz̈tiquiztan judío z̈oñinacaqui nii cruzquiz ticziz̈ curpunaca anaz̈ nuz̈ tsjijptapacha c̈hjelinz pecatc̈ha. Jalla niz̈tiquiztan nii judionacaqui Pilatuz̈quin maychic̈ha, cruzquiz ch'awcta z̈oñinacz̈ lis tsjij kjolkjolz̈inajo, apura ticskatsjapa. Nekztan ticz̈tan cruzquiztan apakznasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Nekztan Pilatuqui zultatunaca mantichic̈ha, nii cruzquiz ch'awctanacz̈ lis kjolzjapa. Primir tjañz̈ lismi kjolz̈inchic̈ha. Niz̈aza tsjii tjañz̈ lizmi kjolz̈inchizakazza. ");
INSERT INTO capNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Nekztanaqui Jesusiz̈quiz macjatz̈cu, nii zultatunacaqui cherzic̈ha, ticzi, jalla nii. Jalla niz̈tiquiztan niiz̈ lismi ana kjolkjolz̈inchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero tsjii zultatuqui Jesusiz̈ ch'ill kjuttan chjapz̈inchic̈ha pajk cuchillz̈tan. Jalla nuz̈ chjaptan ljocmi kjazmi lewchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wejrpacha jalla nii cherchinc̈ha. Jalla niz̈tiquiztan werara ticlarchinc̈ha nii puntuquiztan, anc̈huczakaz criyajo. Weriz̈ ticlarta takuqui werarapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jalla tii watchi puntunacquiztan cjijrta Yooz takuqui cumplissic̈ha. Cjijrta Yooz takuqui jalla tuz̈ cjic̈ha: “Anaz̈ jakzilta niiz̈ tsjijmi kjoltaz̈ cjequic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Niz̈aza tsjii cjijrta Yooz takuqui tuz̈ cjicha: “Ninacaqui ninacaz̈ chjapta z̈oñiqui cheraquic̈ha”. ");
INSERT INTO capNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jalla nekztanaqui tsjii Arimatea wajtchiz z̈oñiqui, José cjita, Pilatuz̈quin mayi ojkchic̈ha. Josequi Jesusiz̈ curpu maychic̈ha tjatzjapa. Josequi chjojzaka Jesusiz̈ chiita tjaajintanaca catokchic̈ha, ana jecz̈quizimi mazcu. Parti judío jilirinacz̈quiztan eksic̈ha. Jalla nuz̈ maytan Pilatuqui permiso tjaachic̈ha. Jalla nekztanaqui Josequi ojkchic̈ha Jesusiz̈ curpu chjichi. ");
INSERT INTO capNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Niz̈aza Nicodemo cjita z̈oñiqui Jesusiz̈ curpu tjaczñi tjonchic̈ha. Jalla nuz̈ Jesusiz̈ curpu tjaczjapa zjijcchic̈ha, tsjii quintala zuma ulurchiz mirrz̈tan aloestan t'ajz̈ta. Niiz̈ tuquiqui Nicodemuqui Jesusiz̈quin ween tjonzitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Josez̈tan Nicodemz̈tan Jesusiz̈ curpu tjaczic̈ha. Niz̈aza nii mirrz̈tan aloestan jalla ninacz̈tan zuma pañunacz̈tan Jesusiz̈ curpu capzic̈ha, jaknuz̈utaz̈laj nii judío z̈oñinacz̈ cuzturumpi, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesusiz̈ cruzquiz ch'awcta yokquin muntinaca z̈elatc̈ha. Nii muntinac yokquiz tsjii ew sepulturu z̈elatc̈ha, ana jec ticzimi tjatz̈tatac̈ha nii ew sepulturquiz. ");
INSERT INTO capNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Judionacz̈ jeejz tjuñimi pascua pjijzta tjuñimi wajillatac̈ha. Pero nii ew sepulturuqui z̈catillatac̈ha. Jalla niz̈tiquiztan nii sepulturquin Jesusiz̈ curpu tjatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Semana kalltiznan nii tuming wenz chawjc kjantati María Magdalena sepulturquin ojkchinc̈ha. Nekztan cherchinc̈ha sepultura pjucz̈ta maz, cjetz̈tatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jalla nekztan María Magdalenqui zati pariju ojkchinc̈ha, Simón Pedruz̈quin, niz̈aza nii Jesusiz̈ pecta tjaajinta zoñz̈quin. (Jalla niic̈ha tii liwru cjijrñi Juan cjitaqui.) Jalla naa Mariiqui ninacz̈quiz paljaychinc̈ha, tuz̈ cjican: —Jesús Jilirz̈ curpu sepulturquiztan chjichtac̈ha. Niz̈aza jakziquin chjichcu tjatz̈takazlani anac̈ha zizzuca. ");
INSERT INTO capNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jalla nekztanaqui Pedruz̈tan nii tsjii pecta tjaajinta z̈oñz̈tan ulanz̈cu sepultura cherzñi ojkchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ninacac pucultan juntu zatatc̈ha. Nii tsjiiqui tsjan apura zajtchic̈ha Pedruz̈quiztan. Jalla nuz̈ zajtz̈cu Pedruz̈ tuqui sepulturquin irantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Irantiz̈cu sepulturquiz colz̈cu chercherzic̈ha, nii Jesusiz̈ curpu tejlz̈ta pañunaca nekzikaz cherzic̈ha. Pero ana luzzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Niiz̈ wiruñ Simón Pedruqui irantichizakazza. Jalla niiqui sepulturquiz luzzic̈ha. Niz̈aza niiqui Jesusiz̈ curpu tejlz̈ta pañunaca cherzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesusiz̈ acha jerz̈inta pañu morokpachalla tsjii latu nonz̈tatac̈ha. Parti pañunacz̈tan anatac̈ha juntu. ");
INSERT INTO capNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jalla nekztanaqui nii tuqui irantiñi z̈oñiqui sepulturquiz luzzizakazza. Jalla nii pañunaca cherz̈cu, criichic̈ha, Jesusa jacatatchi, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cjijrta Yooz takuqui Jesusaz̈ ticziquiztan jacatatz puntuquiztan chiic̈ha. Pero Jesusiz̈ tjaajintanacaqui nii cjijrta Yooz taku imaz̈ intintazatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Jalla nekztanaqui Pedruz̈tan Juanz̈tan, jalla nii pucultanaqui kjuya quejpchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria Magdalena cjitiqui sepultur zancu z̈elatc̈ha, kaacan. Jalla nuz̈ kaacan sepultur kjutñi colz̈cu cherzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Nekz sepulturquiz pucultan anjilanaca chiw zquiti cutchi z̈elatc̈ha. Jakziquiz Jesusa tjatz̈tataz̈laja, jalla nekz julzi z̈elatc̈ha. Tsjiiqui ach kjuttantac̈ha, tsjiiqui kjojch kjuttantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nii anjilanacaqui naaquiz pewczic̈ha: —Cullacalla, ¿kjaz̈tiquiztan am kaa? —cjican. Naaqui tuz̈ kjaazic̈ha: —Wejt Jilirz̈ curpu chjitchic̈ha. Jakziquin chjitz̈takazlani, anal zizi atuc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jalla nuz̈ chiiz̈cu, kjutzquichinc̈ha. Jalla nuz̈ kjutz̈cu Jesusa tsijtsi cherziñc̈ha. Pero Jesusa ana pajchinc̈ha nii ratu. ");
INSERT INTO capNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nekztan Jesusaqui naaquiz pewczic̈ha, tuz̈ cjican: —Cullacalla, ¿kjaz̈tiquiztan am kaa? ¿Jequim kjurya? Mariiqui persun kuzquiz pinsichinc̈ha: “Munti yoka cwitiñi z̈oñiz̈ caa”, cjican. Jalla niz̈tiquiztan niiz̈quiz cjichinc̈ha: —Señor, amqui Jesusiz̈ curpu chjitchamz̈laj niiqui, maznalla, jakziquin nii curpu cjichamta. Nekztan wejrqui niiz̈ curpu chjichasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesusaqui nekztan naaquiz cjichic̈ha: —¡María! Mariiqui nuz̈ chiiñi nonz̈cu zumpacha kjutzinc̈ha. Nekztan Jesusiz̈quiz chiichinc̈ha: —¡Raboni! —cjican. Nii takuqui hebreo tawkquiz “Maestro” cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nekztanaqui Jesusaqui naaquiz cjichic̈ha: —Wejr cutzna. Wejrqui imazil Yooz Ejpz̈quin okuc̈ha. Jaziqui mazñi okaquic̈ha weriz̈ tjaajinta jilanacz̈quin. Tuz̈ cjican maznaquic̈ha: “Wejrqui Yooz Ejpz̈quin okac̈ha. Jalla niiqui wejt Ejpc̈ha, niz̈aza anc̈huca Ejpzakazza. Niz̈aza niic̈ha wejt Yoozqui, niz̈aza anc̈huca Yoozqui”. ");
INSERT INTO capNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jalla nekztanaqui María Magdalenqui Jesusiz̈ tjaajintanacz̈quin mazñi ojkchinc̈ha, tuz̈ cjican: —Jesusa Jiliri cherchinc̈ha. Nekztan ninacz̈quin Jesusiz̈ chiitanaca mazzinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tumincuqui jalla nii nooj ween niiz̈ tjaajintanacaqui tsjii kjuyquiz z̈elatc̈ha. Kjuya zuma chawjcchitac̈ha, quintra z̈oñinaca ekscu. Jalla nuz̈ cjen Jesusaqui tsijtsi ninacz̈ taypiquiz parizichic̈ha. Nekztan ninacz̈quiz tsaanchic̈ha, tuz̈ cjican: —Anc̈hucqui walikaz cjee. ");
INSERT INTO capNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Jalla nuz̈ tsaanz̈cu, Jesusaqui ninacz̈quiz tjeezicha niiz̈ pjetta kjaranacaz̈, niz̈aza niiz̈ chjapta ch'illa. Jalla nekztanaqui ninacaqui Jesús Jiliri cherz̈cu, ancha chipchi cuntintutac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jalla nekztanaqui Jesusaqui wilta ninacz̈quiz tuz̈ chiichic̈ha: —Walikaz cjee. Jaknuz̈t Yooz Ejpqui wejr cuchanz̈quichic̈ha, jalla niz̈ta zakaz wejrqui anc̈hucaquiz cuchanz̈cac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jalla nuz̈ chiican, Jesusaqui ninacz̈ kjutñiz̈ pjujzic̈ha, tuz̈ cjican: —Anc̈hucqui, Yooz Espíritu Santuz̈ tanzna. ");
INSERT INTO capNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Jakzilta z̈oñz̈ ujnaca anc̈hucqui pertunaquiz̈ niiqui, Yooz Epiz̈ pertuntaz̈ cjequic̈ha. Niz̈aza jakzilta z̈oñz̈ ujnaca anc̈hucqui ana pertunaquiz̈ niiqui, ana pertuntaz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nii oraqui nii tuncapan illzta z̈oñinacz̈quiztan tsjiiqui ana z̈elatc̈ha, Tomás cjita. Niiz̈ tsjii tjuuqui “Pacha” cjitatac̈ha. Jesusa tjonz, nii ora ana z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wiruñaqui parti tuncapan tjaajintanacaqui Tomasquiz quint'ichic̈ha, tuz̈ cjican: —Jesús Jiliri wejrnac cherchinc̈ha. Pero Tomaszti tuz̈ cjichic̈ha: —Anal criyasac̈ha. Wejrqui Jesusiz̈ clawz̈tan pjetta kjarami ana cheraz̈ niiqui, niz̈aza nii pjetquiz ana wejt kjar loc'ana chjapznaz̈ niiqui, niz̈aza niiz̈ ch'ill pjetquiz wejt kjara ana chjapznaz̈ niiqui, jalla niz̈tiquiztan anal criyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Quinsakal tjuñquiztan nii tjaajintanacaqui wilta kjuyquin z̈elatc̈ha, Tomastanpacha. Kjuy chajwcchiz̈ cjenami, Jesusaqui ninacz̈ taypiquiz tsijtsi parizichic̈ha. Nekztan ninacz̈quiz tsaanchic̈ha, tuz̈ cjican: —Anc̈hucqui walikaz cjee. ");
INSERT INTO capNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jalla nekztanaqui Tomasquiz paljaychic̈ha, tuz̈ cjican: —Wejt kjara cherzna. Am kjar loc'ana tekz chjapzna. Niz̈aza am kjara zjijca, wejt ch'illquiz chjapzna. Anapan tira ana criiñi kuzziz cjee. Antiz criya, wejtquiz kuzziz cjee. ");
INSERT INTO capNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasqui tuz̈ kjaazic̈ha: —¡Wejt Jiliri! ¡Wejt Yooz! ");
INSERT INTO capNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesusaqui nekztan niiz̈quiz cjichic̈ha: —Jaziqui Tomás, amqui wejr cherz̈cu criichamc̈ha. Ana wejr cherz̈cu criichinacaqui, juc'ant waliz̈ cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesusaqui niiz̈ tjaajintanacaz̈ cheran walja milajrunaca paachic̈ha. Parti milajrunacakaz tii libruquiz cjijrtatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jalla tekz cjijrta milajrunacaqui wejrqui cjijrchinc̈ha anc̈hucqui criyajo, Jesusaqui Cristuc̈ha, niz̈aza Yooz Majchc̈ha, jalla nii. Niz̈aza cjijrchinc̈ha, anc̈huc Cristuz̈quin kuzziz cjisjapa, arajpachquin wiñaya kamzjapa. ");
INSERT INTO capNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Niiz̈ wiruñ Jesusaqui niiz̈ tjaajintanacz̈quiz wilta parizichic̈ha, Tiberias kot atquin. Jalla tuz̈ watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nekz z̈elatc̈ha, Simón Pedruz̈tan, “Pacha” cjita Tomastan, Caná de Galilea wajtchiz Natanaelz̈tan, Zebedeoz̈ majchnacz̈tan, niz̈aza tsjii pucultan iya tjaajintanacz̈tan. Jalla ninaca juntu z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nekztan Simón Pedruqui cjichic̈ha: —Wejrqui ch'iz tani okuc̈ha. Nii partinacaqui cjichic̈ha: —Wejrnacmi amtan chical okac̈ha. Jalla nekztan kotquin ojkchic̈ha. Nicju tsjii warcuquin luzzic̈ha. Pakara langzcanami ana c̈hjul ch'izmi tani atchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Kjanz̈canalla, Jesusaqui kot atquin parizizquichic̈ha. Nii tjaajintanacaqui ana zizatc̈ha, nii Jesusaz̈laj, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Jilanaca, ¿ana c̈hjul ch'izmi tanchinc̈huckaya? Ninacaqui kjaazic̈ha: —Ana c̈hjul, —cjican. ");
INSERT INTO capNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Nii warcuz̈ z̈ew latuquiz ch'iz tanz tjojtzna. Jalla nekz ch'iznaca tanznaquic̈ha. Jalla nuz̈ tjojtz̈tiquiztan wacchi ch'iznaca tanzic̈ha. Wacchi ch'iznaca tanchiz̈ cjen, wirataz̈ ana warcuquin joozuca. ");
INSERT INTO capNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nii Jesusaz̈ ancha k'aachita z̈oñiqui Pedruz̈quiz cjichic̈ha: —Niic̈ha Jesús Jiliriqui. Nuz̈ chiitiquiztan nii orapachalla Pedruqui niiz̈ chjojkta zquiti cutz̈cu, kot kjazquin luzzic̈ha, kjaz juntuñ narcan Jesusiz̈quin ojkzjapa. Warcuquiz langzcan, ana zquitchiztac̈ha, calzunsillo alaja. ");
INSERT INTO capNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Parti tjaajintanacaqui warcuquiz ojkchic̈ha ch'iz tanzquiz ch'iznaca joocan. Nii ch'iz tanzqui ch'iznacz̈tan chjijppachatac̈ha. Nii joocan kot atquin macjatz̈quichic̈ha. Ninacaqui kot atquiztan patac metruz̈ jalla nuz̈quinkaztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Nekztanaqui kot atquin irantiz̈cu, warcuquiztan ulanchic̈ha. Niz̈aza uj paraza cherchic̈ha, ch'iz tjucta. Niz̈aza t'anta z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nekztanaqui Jesusaqui ninacz̈quiz cjichic̈ha: —Tsjii kjaz̈ anc̈hucaz̈ tanta ch'iznaca zjijca. ");
INSERT INTO capNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jalla nuz̈ maytiquiztan Simón Pedruqui warcuquiz luzcu nii ch'iznaca kot atquin jooz̈quichic̈ha. Nii ch'iz tanzqui pajk ch'iznacz̈tan chjijpitac̈ha, patac pjijska tunca quinsani ch'iznacchiztac̈ha. Jalla nuz̈ wacchi tanchiz̈ cjenami, nii ch'iz tanzqui ana wjajrzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesusaqui ninacz̈quiz cjichic̈ha: —Picha. C̈hjeriz̈ lujl-lay. Ana ultimu pajz̈cumi anaz̈ jecmi nii tjaajintanacz̈quiztan pewczñi atatc̈ha, “¿Ject amya?” cjicanaqui. Ninacaqui “Jesús Jiliriz̈lani” nuz̈ kuzquiz pinsichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jalla nekztanaqui Jesusaqui ninacz̈quin z̈catz̈inz̈quichic̈ha. T'anta tanz̈cu, ninacz̈quiz tjaachic̈ha, niz̈aza ch'iz zakaz ninacz̈quiz tjaachic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ticziquiztan jacatatz̈cu, tii c̈hjep wiltiquiziqui Jesusaqui niiz̈ tjaajintanacz̈quiz parizichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jalla nuz̈ c̈hjeri lujltiquiztan, Jesusaqui Simón Pedruz̈quiz pewczic̈ha, tuz̈ cjican —Simón, Jonás maati, ¿amqui tii z̈oñinacz̈quiztan wejttan juc'anti munazkaya? Pedruqui tuz̈ kjaazic̈ha: —Jesalla, wejt Jiliri. Amqui zizza, wejr am pecuc̈ha, jalla nii. Nekztan Jesusaqui niiz̈quiz cjichic̈ha: —Wejt z̈oñinacz̈quiz arajpach c̈hjeri tjaa. Ninacac̈ha uuzanacaz̈takazqui. ");
INSERT INTO capNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Nekztan Jesusaqui Pedruz̈quiz wilta pewczic̈ha, tuz̈ cjican: —Simón, Jonás maati, ¿amqui wejttan zuma munazkaya? Pedruqui tuz̈ kjaazic̈ha: —Jesalla, wejt Jiliri. Amqui zizza, wejr am pecuc̈ha, jalla nii. Jesusaqui niiz̈quiz cjichic̈ha: —Wejt z̈oñinaca cwita. Ninacac̈ha uuzanacaz̈takazqui. ");
INSERT INTO capNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nekztanaqui Jesusaqui c̈hjep wiltiquiziqui Pedruz̈quiz pewczic̈ha: —Simón, Jonás maati, ¿amqui wejr peckaya? —cjican. Pedruqui jalla nuz̈ c̈hjep wilta pewcztiquiztan llaquita cjissic̈ha. Jalla nekztanaqui Pedruqui tuz̈ kjaazic̈ha: —Wejt Jiliri, amqui tjapa zizñampanc̈ha. Amqui zizza, wejr am pecuc̈ha, jalla nii. Nekztan Jesusaqui niiz̈quiz cjichic̈ha: —Wejt z̈oñinacz̈quiz arajpach c̈hjeri tjaa. ");
INSERT INTO capNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ultim weraral amquiz chiyuc̈ha. Amqui tjowa cjicanaqui zquiti cujtz̈cu jakziquinam ojkz pecc̈haja, ojkñamtac̈ha. Pero chawcz̈cuzti, amqui kjaram waaznaquic̈ha. Yekja z̈oñiqui am zquiti tjutznaquic̈ha, niz̈aza ana amiz̈ ojkz pecta, jalla nijcchuc chjichta cjequic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jalla nuz̈ chiiz̈cu, Jesusaqui mazinchic̈ha, jaknuz̈t Pedro ticstanc̈halaja, niz̈aza jaknuz̈t Pedruz̈ cjen Yoozquin honora tjaataz̈ cjec̈haja, jalla nii. Nekztan nuz̈ chiiz̈cu, Jesusaqui Pedruz̈quiz tuz̈ cjichic̈ha: —Wejt kamañquizka kama. ");
INSERT INTO capNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nekztanaqui Pedruqui wir kjutñi kjutz̈cu, Jesusiz̈ tjaajinta k'ayi z̈oñz̈ kjutñi cherzic̈ha. Nii tjaajinta k'ayi z̈oñiqui pascu pjijztiquiz c̈hjeri lulan, Jesusiz̈ latuquiz z̈elatc̈ha. Niiqui Jesusiz̈quiz pewczitac̈ha, tuz̈ cjican: “Wejt Jiliri, ¿ject am tankataquiya?” ");
INSERT INTO capNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jalla nii tjaajinta z̈oñz̈ kjutñi cherz̈cu, Pedruqui Jesusiz̈quiz pewczic̈ha, tuz̈ cjicha: —Wejt Jiliri, ¿tii z̈oñz̈quiz c̈hjulut wataquiya? ");
INSERT INTO capNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesusaqui Pedruz̈quiz tuz̈ kjaazic̈ha: —Wejt tjonzcama tii z̈oñz̈ z̈ejtz munaz̈ niiqui, ¿c̈hjulut amquiz importiya? Wejt kamañquizka kama amqui. ");
INSERT INTO capNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jalla nuz̈ Jesusaz̈ chiitiquiztan, tii quintu ojkchic̈ha, nii tjaajinta k'ayi z̈oñiqui ana ticznaquic̈ha, jalla nii. Pero Jesusaqui ana niz̈ta chiichic̈ha, “Amqui ana ticznaquic̈ha” cjican. Pero Jesusaqui cjichic̈ha, “Wejt tjonzcama tii z̈oñz̈ z̈ejtz munaz̈ niiqui, ¿c̈hjulut amquiz importiya?” Jalla nuz̈kaz cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Wejrpachac̈ha nii tjaajinta k'ayi z̈oñiqui. Wejrqui tii cartiquiz cjijrtanaca maznuc̈ha. Niz̈aza tii liwruquiz cjijruc̈ha. Niz̈aza criichi z̈oñinacaqui zizza, weriz̈ mazta taku werarapanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Niz̈aza iya juc'anti Jesusaz̈ paatanaca z̈ejlc̈ha. Tjapa niiz̈ paatanaca cjijrta cjesaz̈ niiqui, nii cjijrta liwrunaca tjapa tii muntuquiz chjijpsnasac̈ha. Niz̈aza iya juc'anti z̈elaquic̈ha. Nuz̈ukazza. Amén.");
INSERT INTO capNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Zuma Teófilo, tuqui wejrqui tsjii libro cjijrchinc̈ha tjapa Jesucristuz̈ puntuquiztan. Jesusiz̈ ojklaytanacami tjaajintanacami cjijrchinc̈ha, nasta tjuñquiztan, ");
INSERT INTO capNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","arajpacha quejpsquiz tjuñicama. Ima arajpacha quejpz̈can Jesusiz̈tan Espíritu Santuz̈tan apostolonacz̈quin mantichic̈ha, jaknuz̈t kamz waquizic̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesusaqui ticziquiztan jacatatz̈cu tii yokquiz iya pusi tunc tjuñi z̈ejlchic̈ha niiz̈ apostolonacz̈quiz persuna tjon tjonzjapa. Tjon tjonz̈can, kjanapacha tjeezic̈ha, “Jacatatchinc̈ha”, cjican. Niz̈aza jaknuz̈t Yooz mantuquiz kamz waquizic̈haja, jalla nii tjaajinchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tsjii nooj niiz̈ apostolonacz̈tan juntjapz̈cu, Jesusaqui ninacz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Anac̈ha tii Jerusalén wajtquiztan ulnaquic̈ha. Tekzic̈ha tjewznaquic̈ha anc̈hucqui, wejt Yooz Epiz̈ chiita taku cumpliscama. Niiqui Espíritu Santo cuchanz̈caquic̈ha; jalla niicamaz̈ tjewznaquic̈ha. Tuquitan wejrqui anchucaquiz nii puntu paljaychinpantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juan Bautistaqui kjaztan bautissipanc̈ha. Anziqui tsjii kjaz̈ majquiztan anc̈hucqui Espíritu Santuz̈tan bautistaz̈ cjequic̈ha. —Nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Apostolonacaqui Jesusiz̈tan juntjapsi cjen, pewczic̈ha, tuz̈ cjican: —Wejt Jiliri, ¿anzpacha amqui tii Israel wajtchiz z̈oñinaca ninacz̈ quintranacz̈quiztan liwriyaquiya? ¿Tii z̈oñinaca persuna mantisjapaya? ");
INSERT INTO capNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Nekztanaqui Jesusaqui ninacz̈quiz kjaazic̈ha, tuz̈ cjican: —Yooz Ejppankazza timpunacaqui mantiñiqui, c̈hjulorat tii tii watac̈haja, jalla nii. Niz̈aza Yoozqui anc̈hucaquiz ana zizkatz munc̈ha, c̈hjulorat tii Israel z̈oñinaca liwriita cjec̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero Espíritu Santuz̈ anc̈huca kuzquiz luztan, anc̈hucqui tjup kuzziz cjequic̈ha. Jalla nekztan anc̈hucqui wejt puntuquiztan paljayñi ojklayaquic̈ha Jerusalén wajt yokaran, niz̈aza Judea yokaran, niz̈aza Samaria yokaran, niz̈aza tjapa kjutñi. —Jalla nuz̈ cjichic̈ha Jesusaqui. ");
INSERT INTO capNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nekztan apostolonacaz̈ cheran Jesusaqui ninacz̈ taypiquiztan tsewcchuc waytissic̈ha. Yooz Epiz̈ chjichtatac̈ha arajpacha. Nuz̈quiz tsjir taypiquiz katchic̈ha Jesusaqui. Ana iya tjenchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nekztanaqui tsewcchuc cheksnan, pucultan chiw zquitchiz z̈oñinacaz̈takaz jecz̈quichic̈ha ninacz̈ z̈cati. ");
INSERT INTO capNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Nii pucultan anjilanacaqui tuz̈ cjichic̈ha: —Galilea z̈oñinaca, ¿kjaz̈tiquiztan anc̈hucqui tsewcchuc chekz̈qui? Jesusaqui anc̈hucaquiztan arajpacha chjichtac̈ha. Pero tsjii nooj nii Jesusapacha wilta tii muntuquiz quejpz̈caquic̈ha, jaknuz̈t tsjir taypiquiz katc̈haja, jalla nuz̈ tsjir taypiquizzakaz jecz̈caquic̈ha. Nuz̈ tjonaquic̈ha. —Nuz̈ cjichic̈ha anjilanacaqui. ");
INSERT INTO capNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Jalla nekztanaqui apostolonacaqui Olivos cjita curullquiztan chjijwz̈quiz̈cu, Jerusalén watja quejpchic̈ha. Jerusalén watjaqui nii curullquiztan z̈catitac̈ha, jeejz tjuñquiz jaknuz̈t judiuz̈ lii jaru ojkz waquizic̈haja, jalla nuz̈ullquin ojkztac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jerusalén watja irantiz̈cu apostolonacaqui alujta kjuya luzzic̈ha; tsewcta altu pisuquin alujtatac̈ha. Nii apostolonacaqui tinacatac̈ha: Pedrotac̈ha, Jacobotac̈ha, Juantac̈ha, Andrestac̈ha, Felipitac̈ha, Tomastac̈ha, Bartolomitac̈ha, Mateotac̈ha, Jacobo cjita Alfeoz̈ majchtac̈ha, Simonatac̈ha (niiqui cananista cjita partir z̈oñitac̈ha), niz̈aza Judas cjita Jacoboz̈ majchtac̈ha. Jalla ninacatac̈ha apostolonacaqui. ");
INSERT INTO capNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Tjapa ninacaqui tsjii kuzziz Yoozquin mayizizjapa ajcajczñipantac̈ha. Ninacz̈tan chica z̈elatc̈ha Jesusiz̈ lajknacz̈tan, Jesusiz̈ maatan, niz̈aza yekja maatakanacz̈tan. Tjappacha Yoozquin mayizican z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tsjii noojiqui jalla nuz̈ chicapacha z̈elan Pedruqui tsijtsic̈ha, nii Yoozquin criichi z̈oñinacz̈ taypiquiz. Nii oraqui tsjii patac paatuncani nuz̈quintakalc̈ha nii criichi z̈oñinacaqui. Pedruqui ninacz̈quiz cjichic̈ha: ");
INSERT INTO capNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Jilanaca, cullaquinaca, Judasqui Jesusa tanñi z̈oñinaca irpichic̈ha. Tuquitan jalla nii Judas puntuquiztan Espíritu Santuqui Davidz̈quiz mazinchic̈ha, Yooz tawk liwruquiz cjijrta cjisjapa. Niz̈aza nii Espíritu Santuz̈ mazintaqui cumplispantac̈ha. Jaziqui cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasqui uc̈hum partiquiztantac̈ha. Niz̈aza Yoozta langzñiquiz uchtatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nii anawali paañi Judasqui Jesusa tarasunta paaztan tsjii yoka kjaychic̈ha. Nekztan, kozzuc achchiz tjojtscu, walu pjatsi ticzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tjapa Jerusalén wajtchiz z̈oñinacaqui nii Judas quintu zizza. Jalla nii quintu nonz̈cu, Judas kjayta yoka tjuuskatchic̈ha, Acéldama cjican. Acéldama tjuuqui ninacz̈ tawkquiztan “Ljoc Yoka” cjic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Judas puntuquiztan Salmos cjita liwruquiz tuz̈ cjijrtac̈ha: “Niiz̈ kjuyaqui jaytitaj cjila. Niz̈aza ana jecmi nii kjuyquiz kamla”. Salmos cjita liwruquiz tuz̈ zakaz cjijrtac̈ha: “Niiz̈ puestuquiz yekja uchtaj cjila”. ");
INSERT INTO capNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Pedruqui tira chiichic̈ha, tuz̈ cjican: —Jalla nii Yooz takuz̈ cjen uc̈humnacquiztan tsjiiqui illza, Judas puesto tanzñijapa. Jaziqui nii puesto tanzñi z̈oñiqui tjapa wejrnacaz̈ Jesusiz̈tan ojklayta timpu cumpant'ichi z̈oñinacz̈quiztan illzta cjistanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juanz̈ bautis timpu jalla nijctanpacha Jesusa arajpacha ojkzcama, jalla nii timpu cumpant'ichi z̈oñinacz̈quiztan nii z̈oñiqui illzta cjistanc̈ha. Nekztan nii z̈oñiqui wejtnacatan chicapacha cjequic̈ha, Jesusaz̈ jacatatta puntu paljayzjapa. —Nuz̈ cjichic̈ha Pedruqui. ");
INSERT INTO capNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nekztanaqui pucultan z̈oñi illsic̈ha, tsjiiqui Judas puesto tanzñijapa. Tsjiiqui José cjitatac̈ha, niz̈aza Josiqui Barsabás cjitazakaztac̈ha. Niz̈aza Josiqui Justo tjuuchizzakaztac̈ha. Tsjiizuñqui Matías cjitatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nekztan nii ajczñi z̈oñinacaqui mayizichic̈ha, tuz̈ cjican: —Jesús Jiliri, amqui tjapa z̈oñinacz̈ kuz zizza. Jaziqui tii pucultiquiztan amiz̈ illzta apóstol tjeeznalla. ");
INSERT INTO capNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Niiqui Judas puestuquiz uchtaz̈ cjequic̈ha, amquin sirwiñiz̈ ojklayzjapa. Judasqui nii puestuqui pertichic̈ha anawali uj paaz̈cu. Jaziqui infiernuquin ojkchic̈ha. Jalla nuz̈ niiz̈taqui waquizichic̈ha. —Jalla nuz̈ mayizichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Nekztanaqui ject Jesusiz̈ illzta, jalla nii zizjapa, zurtiassic̈ha, nii pucultiquiztan jakziltiz̈quiz nii zurti cayac̈haja, jalla nii. Jalla nuz̈ zurtiascu, nii zurtiqui Matiasquiz caychic̈ha. Jalla nekztan Matiasqui nii parti tuncaman illzta apostolonacz̈tan juntu cjissic̈ha. Lijitum apóstol nuz̈quiz cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés cjita pjijsta tjuñquiz tjapa Jerusalén z̈ejlñi criichi z̈oñinacaqui juntassic̈ha tsjii kjuyquizkaz. ");
INSERT INTO capNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Tiripintit tsewctan tsjii chawc tjamz̈ joraz̈takaz nonzic̈ha. Tjapa nii kjuya zmali kjaazkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jalla nekztanaqui uj lastakaz jecz̈quichic̈ha zapa mayni ninacz̈ juntuñcama t'akz̈ta, yekja yekja. Jalla nuz̈ zapa mayniz̈quiz nii ujnacaqui z̈elatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jalla nuz̈ tjonz̈cu Espíritu Santuqui tjapa ninacz̈quiz luzzic̈ha. Nekztan ninacaqui parijunaca yekja yekja taku chiichiichic̈ha, jaknuz̈t nii Espíritu Santuz̈ chiikatc̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nii timpunacaqui Jerusalén wajtquin wacchi judío z̈oñinaca kamñi z̈elatc̈ha, ninacz̈ cuzturumpi jarupan paañi. Nii judío z̈oñinacaqui tjapa kjuttan ajczquichitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jalla nii suyniñi jora nonz̈cu, z̈oñinacaqui juntassic̈ha. Zapa mayni nii z̈oñinacaqui persun taku nonzic̈ha. Nekztan ana tantiichuca, c̈hjulut watac̈haja, nii. ");
INSERT INTO capNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jalla niz̈tiquiztan ninaca ancha kuz turwaysi cjissic̈ha. Ispantichi ninacpora parlassic̈ha, tuz̈ cjican: —¿Tjapa niz̈ta chiichiiñinacaqui anaj Galilea wajtchiz z̈oñinacajo? ");
INSERT INTO capNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Zapa mayni uc̈hum persun takuz̈ nonz̈a. ¿Jaknuz̈upan teejo? —Jalla nuz̈ cjichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nekz z̈elatc̈ha Partia z̈oñinaca, niz̈aza Media z̈oñinaca, niz̈aza Elam z̈oñinaca, niz̈aza Mesopotamia z̈oñinaca, niz̈aza Judea z̈oñinaca, niz̈aza Capadocia z̈oñinaca, niz̈aza Ponto z̈oñinaca, niz̈aza Asia yokchiz z̈oñinaca, ");
INSERT INTO capNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","niz̈aza Frigia z̈oñinaca, niz̈aza Panfilia z̈oñinaca, niz̈aza Egipto z̈oñinaca, niz̈aza Africa z̈oñinaca, nii Afric yokaqui Cirene yokz̈ nawjktuñtan. Niz̈aza Roma wajtquiztan tjonñi z̈oñinaca z̈elatc̈ha. Yekjapanacaqui judío maa ejpchiz z̈oñinacatac̈ha. Yekjapanacaqui ana judío maa ejpchiz cjenami judionacz̈ cuzturumpi paañi z̈oñinacapantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Niz̈aza z̈elatc̈ha Creta wajtchiz z̈oñinaca, niz̈aza Arabia z̈oñinaca. Nii z̈oñinacaqui parlassic̈ha, tuz̈ cjican: —Wacchi watjanacchiz z̈oñinacala uc̈humtanaqui. Pero zapa mayni uc̈hum persun takunacaz̈ nonz̈la. ¡Nii tjapa takunacz̈tan chiiñinacaqui Yooziz̈ ispantichuca paatanaca quint'ila! ");
INSERT INTO capNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jalla nuz̈ chiichiiñi nonz̈cu tjappacha ispantichic̈ha. Kuz turwaysi cjissic̈ha. Nekztan pewcsassic̈ha, tuz̈ cjican: —Nii puntuquiztanac, ¿kjaz̈t cjeejo? ");
INSERT INTO capNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yekjapanacaqui iñarchic̈ha, tuz̈ cjican: —Aaaa, ninacaqui licchikazza. ");
INSERT INTO capNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nekzpacha tsijtsi z̈elatc̈ha nii tuncapan illzta apostolonaca. Jaziqui Pedruqui altu jorz̈tan paljaychic̈ha, tuz̈ cjican: —Judea yokquiz kamñi z̈oñinaca, niz̈aza Jerusalén wajtquiz z̈ejlñi z̈oñinaca, wejt taku zumpachaz̈ nonz̈na. C̈hjuluz̈laja, jalla niil kjanzt'ac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Anc̈hucqui “Tii z̈oñinaca licchikaz” cjican pinsic̈ha. Pero tii z̈oñinacaqui anac̈ha licchi. Anzic wenzlakac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Anziqui Joelz̈ cjijrta Yooz taku cumplissa. Nii Joelqui Yooz cuntiquiztan mazinchic̈ha, tuz̈ cjican: ");
INSERT INTO capNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Yoozqui tuz̈ cjic̈ha, Tii timpu tucuzinz̈tan wejrqui tii muntuquiz z̈ejlñi z̈oñinacz̈quiz wejt Espíritul tjaac̈ha. Wejt Espíritu Santuz̈ kuzquiz luzziz cjen, anc̈huca maatinacaqui lucmajch cjiñi tjunmata cjiñi wejt takuz̈ parlaquic̈ha. Niz̈aza Espíritu Santuz̈ cjen tjotjowaqui visionanaca cheraquic̈ha. Niz̈aza chawc chawcwanacaqui wiyquin chjuuznaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jalla nii timpuquiz wejt sirwiñinacz̈quiz luctaka cjiñi maataka cjiñi wejt Espíritu cuchanz̈cac̈ha. Nii Espírituz̈ cjen, ninacaqui wejt takuz̈ parlaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Tsewc arajpachquinami tii yokquizimi wejrqui ispantichuca siñalanaca tjeeznac̈ha, ljocnaca, ujnaca, tsokchi tsjirinaca, uj z̈ketiz̈takaz, jalla nuz̈. ");
INSERT INTO capNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ima Jesucristo Jiliriz̈ tjonan, tjuñiqui zumchi cjisnaquic̈ha. Niz̈aza jiizmi ljocz̈takaz cjisnaquic̈ha. Jalla niz̈tanaca watan, wajillaz̈ Yooz chawc tjuñiqui tjonaquic̈ha, Yooz wali azi tjeezñi tjuñi. ");
INSERT INTO capNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nii timpuquiziqui jakziltat liwriita cjisjapa Yooz Jilirz̈quin mayizic̈haja, jalla niiqui liwriitaz̈ cjequic̈ha”. Jalla nuz̈ cjijrchic̈ha Joelqui. ");
INSERT INTO capNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","‛Israel wajtchiz z̈oñinaca, wejt taku nonz̈na. Jesusaqui Nazaret wajtchiz z̈oñitac̈ha. Anc̈huca watjanacquiz ojklaycan Jesusaqui Yooz aztan ispantichucanacami, milajrunacami, siñalanacami, jalla ninaca tjeezic̈ha. Nii tjeez̈ta obranaca anc̈hucqui zizza. Jalla nii obranacaqui kjanapacha tjeezic̈ha, Jesusaqui Yooz Epiz̈ cuchanz̈quita z̈oñipankazza, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jalla nuz̈ pajk obranaca paachiz̈ cjenami anc̈hucqui Jesusa conkatchinc̈hucc̈ha. Nekztanaqui anc̈hucqui uj paañi z̈oñinacz̈quiz Jesusa intirjichinc̈hucc̈ha cruzquiz ch'awczjapa. Tuquitanpacha Yooz Ejpqui jalla tiz̈tanaca watzpan zizatc̈ha. Niz̈aza niiz̈ muntacama tii watzjapa mantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Anc̈hucqui Jesusa conkatchinc̈hucc̈ha. Yooz Ejpzti Jesusa jacatatskatchic̈ha. Anawal ticzquiztan liwriichic̈ha. Nii ticzqui Jesusiz̈quiztanaqui anapantac̈ha atipchuca. ");
INSERT INTO capNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tuqui az̈k watanaca David cjita jiliriqui Jesusiz̈ puntu cjijrchic̈ha tuz̈ cjican: “Yooz Jiliri wejttan chica z̈eljñipanc̈ha. Jalla nuz̈ wejt kuzquiz Yoozquin zint'iñpanc̈ha. Yoozqui wejt z̈ew latuquiz z̈ejlc̈ha, wejr yanapzjapa, niz̈aza wejr ana c̈hjulquiztanami eksnajo. ");
INSERT INTO capNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Jalla niz̈tiquiztan wejt kuzqui wali cuntintutc̈ha. Chipchipcan wejt tawkz̈tan Yoozquin honoral tjaa-uc̈ha. Ticz cjenami, Yoozquin kuzziztc̈ha, Yooz Ejpqui wejr jacatatskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yooz Tata, amqui ticzi z̈oñinacz̈tan wejt alma anam ecaquic̈ha. Wejrqui am lijitum sirwiñi z̈oñtqui. Jaziqui wejt curpuqui anam ecaquic̈ha sipulturquiz mokajo. ");
INSERT INTO capNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Niz̈aza wejtquiz arajpach kamaña tjaajinchamc̈ha. Tii muntuquiz amtan chica kamcan ancha cuntintul cjeec̈ha”. Jalla nuz̈ Jesusiz̈ puntuquiztan cjijrchic̈ha Davidqui. ");
INSERT INTO capNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‛Jilanaca, uc̈hum David cjita tuquita atchi ejpz̈ puntuquiztan kjanapacha intintiskats pecuc̈ha. David jiliriqui ticzic̈ha. Niz̈aza tjattatac̈ha. Anzcama niiz̈ sipulturuqui uc̈hum yokquiz z̈ejlc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Davidqui illztatac̈ha Yooz taku chiiñijapa. Yooz Ejpqui niiz̈quiz juramintuz̈tan compromitkalc̈ha tuz̈ cjican: “David, tsjiiqui am majchmaatquiztan (Cristo cjita) pajk jiliri cjequic̈ha. Niiqui mantiz puestuquiz uchtaz̈ cjequic̈ha, tii wajtchiz z̈oñinaca mantizjapa.” Jalla nuz̈ Yoozqui Davidz̈quiz compromitchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jalla nii zizcu, Davidqui tuquitanpacha Cristuz̈ jacatatz puntuquiztan chiichic̈ha, tuz̈ cjican: “Cristuz̈ almaqui ticzi z̈oñinacz̈tan anaz̈ ecta cjequic̈ha. Niz̈aza Jesucristuz̈ curpumi anaz̈ mokaquic̈ha.” Jalla nuz̈ Cristuz̈ puntuquiztan chiichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jaziqui Yooz Ejpqui nii Jesucristo jacatatskatchic̈ha. Jacatattan, wejrnacpachac̈ha Jesucristo cherchintqui. Jaziqui tisticu cjican, nii puntu weraral chiyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesucristuqui jacatatz̈cu, Yooz Ejpz̈ z̈ew latuquiz walja honorchiz cjissic̈ha, Yooz Ejpz̈tan chica mantiñi. Niz̈aza Yooz Epiz̈ tuquita chiita tawk jaru Jesucristuqui Espíritu Santo z̈oñinacz̈quiz cuchanz̈quichic̈ha arajpachquiztan. Nii Espíritu Santuz̈ tjonchiz̈ cjen tii anc̈hucaz̈ chertanacami nonztanacami watchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Davidqui persun puntuquiztan ana chiichic̈ha. Davidc̈ha tsewc arajpachquin ana ojkchiqui, Yooztan mantizjapa. Davidpachac̈ha tuz̈ cjichiqui: “Wejt Yooz Ejp Jiliriqui wejt Yooz Majch Jilirz̈quiz chiichic̈ha: ‘Honorchiz cjisjapa, wejt z̈ew latuquiz julzna wejttan chica mantizjapa. ");
INSERT INTO capNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tsjii noojiqui am quintra z̈oñinaca k'ala atipz̈taz̈ cjequic̈ha. Am kjojch koztan tjecz̈taz̈takaz cjequic̈ha. Jalla nii oracama wejt z̈ew latuquiz julzna’ ”. ");
INSERT INTO capNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‛Anc̈hucqui Jesucristo cruzquiz ch'awcchinc̈hucc̈ha. Pero anziqui Yooz Ejpqui tii Jesusa tsjan chawc jiliri utchic̈ha z̈oñinaca liwriizjapa. Jalla nuz̈ intintiñi waquizila tjapa Israel wajtchiz z̈oñinacaqui. Ultim werarac̈ha tii takuqui. —Nuz̈ cjican Pedruqui paljaychic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jalla nuz̈ nonz̈cu nii z̈oñinacaqui persun kuzquiz ancha zint'ichic̈ha. Jalla niz̈tiquiztan Pedruz̈quizimi parti apostolonacz̈quizimi pewczic̈ha, tuz̈ cjican: —Jilanaca, ¿kjaz̈t cjisnaqui? ¿C̈hjulut wejrnac paaqui? ");
INSERT INTO capNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Nekztanaqui Pedruqui kjaazic̈ha, tuz̈ cjican: —Anc̈hucqui persun uj pajz̈cu, kuz campiya. Nekztanaqui Jesucristuz̈ tjuuquiz bautistaz̈ cjee. Jalla nekztanaqui anc̈huca ujnaca pertuntaz̈ cjequic̈ha. Niz̈aza Yooz Espíritu Santuqui anc̈huca kuzquiz nuz̈ukaz luzaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Nii compromitta Espíritu Santuqui tjaataz̈ cjequic̈ha anc̈hucaquizimi anc̈huca maatinacz̈quizimi, az̈kquin wajtchiz z̈oñinacz̈quizimi, niz̈aza tjapa uc̈hum Yooz Jiliriz̈ kjawz̈ta z̈oñinacz̈quizimi. Jalla ninacz̈quizimi Yooz Espíritu Santo tjaataz̈ cjequic̈ha. —Jalla nuz̈ kjaazic̈ha Pedruqui. ");
INSERT INTO capNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Wacchi takunacz̈tan Pedruqui ninacz̈quiz chiiz̈inchic̈ha, tuz̈ cjican: —Liwriita cjis waquizic̈ha, Cristuz̈ quintra uj paañi z̈oñinacz̈tan ana casticta cjisjapa. ");
INSERT INTO capNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jalla nekztanaqui walja z̈oñinacaqui Pedruz̈ chiita taku tjapa kuztan catokchic̈ha. Jalla nuz̈ catoktiquiztan tjapa ninaca bautistaz̈ cjissic̈ha. Nii noojiqui tsjii c̈hjep warank z̈oñinacaqui yapz̈quichic̈ha parti Yoozquin criichi z̈oñinacz̈quin. Jalla nuz̈ mirchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tjapa nii criichi z̈oñinacaqui apostolonacaz̈ tjaajintanacz̈quiz walja tjapa kuztac̈ha. Ninacaqui tsjii kuzzizpan cjissic̈ha. Chica juntasñitac̈ha Yoozquin mayizizjapa, niz̈aza c̈hjeri lujlzjapa. ");
INSERT INTO capNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Apostolonacaqui walja milajrunacami siñalanacami paachic̈ha. Jalla nuz̈ paatiquiztan tjapa z̈oñinacaqui ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tjapa Yoozquin criichinacaqui juntu kamchic̈ha. Niz̈aza tjapa ninacz̈ cusasami tsjiiquiz juntjapñitac̈ha, zapa mayniz̈quiz tojunzjapa. ");
INSERT INTO capNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Parti cusasa tuyz̈cu, nii paaz tojunñitac̈ha, ana z̈elinchiz z̈oñinacz̈quiz. ");
INSERT INTO capNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Zapuru timpluquiz ajczñipantac̈ha Yoozquin sirwizjapa. Niz̈aza criichi z̈oñinacz̈ kjuyquiztan kjuya okatc̈ha, juntu chjeri lujlzjapa. Humilde kuzziz zuma cuntintu lujlñipantac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Niz̈aza Yoozquin honora tjaañipantac̈ha. Jalla nuz̈ nii criichinacaz̈ zuma kamtiquiztan parti z̈oñinacaqui ninaca zuma rispitñitac̈ha. Zapuru z̈oñinacaqui criichic̈ha, liwriita cjisjapa. Nekztan parti criichi z̈oñinacz̈quiz juntassic̈ha. Jaziqui Jesucristo Jiliriqui criichi z̈oñinaca mirkatchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Tsjii noojiqui majñakak ora, Pedruz̈tan Juanz̈tan pucultan timplu kjutñi yawchic̈ha. Nii oraqui Yoozquin mayiziz oratac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nicju tsjii zuch z̈oñi z̈elatc̈ha. Zucha nassipantac̈ha. Zapuru timpluquin chjitz̈tatac̈ha. Hermosa cjita timplu zanquiz z̈ejlñitac̈ha, timplu luzñi z̈oñinacz̈quiztan paaz tomangzjapa. ");
INSERT INTO capNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nii zuch z̈oñiqui Pedruz̈tan Juanz̈tan timplu luzñi cherz̈cu, paaz tomangzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nekztanaqui Pedruz̈tan Juanz̈tan nii zuch z̈oñz̈ kjutñi cherzic̈ha. Nekztanaqui Pedruqui cjichic̈ha: —Wejtnaca kjutñi cherz̈ca. ");
INSERT INTO capNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jalla nuz̈ chiitiquiztan nii zuch z̈oñiqui “Paaz onaá” cjican cherzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pedruqui cjichic̈ha nekztanaqui: —Anaz̈ wejtta paaz z̈ejlc̈ha. Antis wejtta Jesucristuz̈ azi z̈ejlc̈ha, jalla niiz̈tan yanapasac̈ha. Jesucristo cjita Nazaret wajtchiz z̈oñz̈ aztan amquiz cjiwc̈ha, tsijtsna. Oka. ");
INSERT INTO capNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Niz̈aza Pedruqui nii zuch z̈oñz̈ z̈ew kjarcu tanz̈cu, tsijtskatchic̈ha. Nii tsijtskatan nii orapacha niiz̈ kjojchanacaqui tsijtsñi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jalla nekztanaqui nii zuch z̈oñiqui layz̈cu tsijtsic̈ha, niz̈aza ojklayñi cjissic̈ha. Nekztanaqui Pedruz̈tan Juanz̈tan chica timplu luzzic̈ha, ojkcan, laylaycan, niz̈aza Yooz tjuu alawazcan. ");
INSERT INTO capNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tjapa timpluquiz z̈ejlñi z̈oñinacaqui nii zuch z̈oñi ojklayñi cherchic̈ha, niz̈aza Yooz tjuu alawazñi nonzic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Nekz z̈ejlñi z̈oñinacaqui nii z̈oñi pajchic̈ha. Nii z̈oñipacha zapuru Hermosa cjita timplu zanquiz z̈ejlñitac̈ha, paaz tomtomangz̈can. Nii c̈hjetinta z̈oñi cherz̈cu ispantichi cjissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nii c̈hjetinta z̈oñiqui Pedruz̈quiztan Juanz̈quiztan anaz̈ eclawk cjetc̈ha. Ninaca Portal de Salomón cjita timplu kjuyquiz z̈elatc̈ha. Jalla nijcchuc tjapa nii timpluquiz z̈ejlñi z̈oñinacaqui zati pariju juntassic̈ha. Ispantichic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nekztanaqui Pedruqui nii juntasquiñi z̈oñinaca cherz̈cu, ninacz̈quiz paljaychic̈ha, tuz̈ cjican: —Israel wajtquiz z̈oñinaca, ¿kjaz̈tiquiztan anc̈hucqui ispantiya? ¿Kjaz̈tiquiztan anc̈hucqui wejrnaca chekz̈jo? Wejrnacpacha anac̈ha tii z̈oñi c̈hjetinchintqui. Anal wejtnaca aztan ojklayskati atchinc̈ha. Niz̈aza wejrnacaz̈ persuna zuma kamtiquiztan anal tii z̈oñi c̈hjetinchinc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Antiz Yoozkaz tii z̈oñi c̈hjetinchiqui. Nii Yoozqui uc̈hum tuquita ejpnacz̈ Yoozza, Abraham, Isaac, Jacobo, ninacz̈ Yoozza. Jalla nii Yoozpacha niiz̈ Majch Jesusiz̈quiz pajk honorchiz cjiskatchic̈ha. Nii Jesusaz̈ cjen, tii z̈oñic z̈ejtchic̈ha. Anc̈huczti jilirinacz̈quiz nii Jesusa intirjichinc̈hucc̈ha. Nekztanaqui Pilatuz̈ cutz tantiiz̈tan, anc̈hucqui ana cutskatz pecchinc̈hucc̈ha. “Tiiqui anapanc̈ha Yooziz̈ cuchanz̈quitaqui” cjican chiichinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesusaqui ana c̈hjul ujchizza. Yooz Ejpz̈ kuzcama kamñic̈ha. Nii Jesusa cuts cjenpacha, anc̈hucqui tsjii pajk ujchiz z̈oñi cutskatz pecchinc̈hucc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jalla nuz̈ nii z̈eti tjaañi Jesucristo conchinc̈hucc̈ha anc̈hucqui. Yooz Ejpzti Jesusa ticztiquiztan jacatatskatchic̈ha. Jalla nii puntuquiztanaqui wejrnacpachac̈ha cherchintqui. Jaziqui nii puntu zuma werara chiyasac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Tii Jesucristuc̈ha azzizqui. Jesucristuz̈quiz tjapa kuztan cjican, wejrnacqui Jesucristuz̈ aztan tii anc̈hucaz̈ pajta z̈oñi c̈hjetinchinc̈ha. Jesucristuz̈quin tjapa kuzziz cjen tii z̈oñiqui zumpacha z̈ejtchic̈ha. Jalla nuz̈ anc̈hucqui tjappachaz̈ cherz̈cu, nayaquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‛Jaziqui jilanaca, anc̈hucmi anc̈huca jilirinacami Jesusa conchinc̈hucc̈ha. Jalla nii ora anc̈hucqui c̈hjulut paatc̈haja anaz̈ zizatc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jalla nuz̈ cjenami Yoozqui niiz̈ persun taku cumpliskatchic̈ha. Tuquiqui Yoozqui tjapa niiz̈ taku chiiñi profetanacz̈quiz chiikatchic̈ha, tuz̈ cjican, “Yooz cuchanz̈quita Cristuqui sufristanc̈ha”. Nii takuqui cumplissic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jaziqui anc̈hucqui Yoozquin kuzziz cjee, persun uj pajz̈cu. Yoozquin quejpz̈ca, anc̈huca ujnaca pertunta cjisjapa. Jalla nekztanaqui Yooz Jiliriqui anc̈huca kuznaca cuntintu cjiskataquic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Niz̈aza Yooz Jiliriqui wilta cuchanz̈caquic̈ha Jesucristo anc̈hucalta uchta liwriiñiqui. ");
INSERT INTO capNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ima Jesucristuz̈ wilta tjonan Yooz Ejpqui tjappacha azquichaquic̈ha, jaknuz̈t tuquita zuma kuzziz Yooz taku chiiñi z̈oñinacaz̈ mazinc̈haja, jalla niicama cumpliskataquic̈ha. Jalla nii cumplis oracama Jesucristuz̈laqui tsewc arajpachquin kamspanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisesqui uc̈hum tuquita ejpnacz̈quiz cjichic̈ha: “Yooz Jiliriqui anc̈hucaquiz tsjii Yooz taku chiiñi profeta cuchanz̈caquic̈ha. Nii z̈oñiqui anc̈huca wajtchiz z̈oñinacz̈quiztanpacha ulnaquic̈ha. Jaknuz̈t Yooz Ejpqui wejr cuchanz̈quitc̈haja, jalla nuz̈uzakaz tsjii cuchanz̈caquic̈ha. Anc̈hucqui nii Yooz Epiz̈ cuchanz̈quita z̈oñz̈ taku tjapa kuztan nonz̈na, c̈hjulut chiyac̈haja, jalla nii. ");
INSERT INTO capNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jakziltat ana niiz̈ taku nonznawk cjec̈haj niiqui, Israel wajtchiz z̈oñinacz̈quiztan pjaltaz̈ cjequic̈ha. Niz̈aza walja castictaz̈ cjequic̈ha”. Nuz̈ cjic̈ha Moisesqui. ");
INSERT INTO capNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Niz̈aza tii timpu puntuquiztan tjapa Yooz taku chiiñi profetanacaqui parlichipanc̈ha Samuelz̈quiztanpacha jecchuc. ");
INSERT INTO capNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Nii profetanacz̈ taku Yooz Ejpqui anc̈hucaltajapa chiikatchic̈ha. Anc̈hucaltazakaz Yooz Ejpqui tsjii zuma taku tjaachic̈ha uc̈hum tuquita ejpnacz̈quiz. Jalla tuz̈ cjican, Yoozqui Abrahamz̈quiz taku tjaachic̈ha: “Am majchmaatiz̈ cjen, tjapa tii muntuquiz z̈ejlñi z̈oñinacz̈tajapa favoral paa-ac̈ha wejrqui”. ");
INSERT INTO capNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Yooz Ejpqui niiz̈ Majch jacatatskatz̈cu, anc̈hucaquiz primira cuchanz̈quichic̈ha, favora paacan. Jazic tjapa anc̈huc anawali paaznaca apatatspanc̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedruz̈tan Juanz̈tan jalla nuz̈ parlan, timplu jilirinacaqui, timplu zultatz̈ jilirz̈tan saduceo parti z̈oñinacz̈tan tjonchic̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedruz̈tan Juanz̈tan z̈oñinaca tjaajnatc̈ha, tuz̈ cjican: —Jesusaqui ticziquiztan jacatatchic̈ha. Jalla nuz̈ kjanapacha tjeez̈a, tjapa ticzi z̈oñinacaqui jacatataquic̈ha, jalla nuz̈. —Jalla niz̈ta chiitiquiztan ancha z̈awjchic̈ha nii jilirinacaqui. ");
INSERT INTO capNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jalla nekztanaqui Pedruz̈tan Juanz̈tan preso chjitz̈tatac̈ha. Niz̈aza carsilquiz majctatac̈ha, jakataz̈cama. Nii oraqui zeziqueyatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jalla nuz̈ Pedruz̈tan Juanz̈tan Yooz puntu chiichiichiz̈ cjen, tama nonzñi z̈oñinacaqui tjapa kuztan Yoozquin criichic̈ha. Luctak criichi z̈oñinacakaz tsjii pjijska warankatac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jakataz̈uqui Jerusalén wajtquin ajczitac̈ha wajt jilirinacami, timplu jilirinacami lii tjaajiñinacami. ");
INSERT INTO capNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nii oraqui timplu chawc jiliritac̈ha Anasqui. Niimi ajczitac̈ha, niz̈aza Caifastan, Juanz̈tan, Alejandruz̈tan. Niz̈aza tjapa timplu chawc jilirinacz̈ famillanacami ajczitac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jalla nuz̈ ajcziz̈ cjen Pedruz̈tan Juanz̈tan zjijckatchic̈ha. Nekztanaqui nii jilirinacz̈ taypiquiz apantiskatz̈cu pewczic̈ha, tuz̈ cjican: —Anc̈hucqui, ¿jakzilta jiliriz̈ mantitaz̈ cjen niz̈ta anc̈huc paajo? ");
INSERT INTO capNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jalla nekztanaqui Espíritu Santuqui Pedruz̈quiz tuz̈ chiikatchic̈ha: —Israel wajtchiz jilirinaca, timplu jilirinaca, ");
INSERT INTO capNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","wejrnacqui anc̈hucaz̈ yujcquiz zjijctac̈ha, tsjii wali paata zumpacha zizajo. Jaknuz̈t tii zuch z̈oñi z̈ejtchiz̈laja, jalla nii ziz pecaquiz̈ niiqui, niil quint'asac̈ha. ");
INSERT INTO capNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wejrnacqui anc̈huca yujcquiz weraral chiyac̈ha, anc̈huc nii quintu zumpacha zizajo; niz̈aza tjapa Israel wajtchiz z̈oñinaca zumpacha zizajo. Jesucristuz̈ aztan tii z̈oñi c̈hjetinta z̈ejlc̈ha tjapa anc̈huca yujcquiz tsijtchi. Anc̈hucqui nii Nazaret wajtchiz Jesucristo cruzquiz ch'awcchinc̈hucc̈ha. Nekztanaqui Yoozqui niipacha ticziquiztan jacatatskatchic̈ha. ");
INSERT INTO capNT_vpl 