﻿USE sofia;
DROP TABLE IF EXISTS sofia.caoNT_vpl;
CREATE TABLE caoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES caoNT_vpl WRITE;
INSERT INTO caoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jabi chama David yamabo, Abraham yamabo, tihi caba chahitaxocobo Jesucristo iniquë. Jabi Jesucristo naborëquëbo janë bo tëquë tsi xo naa. ");
INSERT INTO caoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham baquë Isaac iniquë. Isaac baquë Jacob iniquë. Jatsi doce ca baquë bo Jacob yamabá jayaniquë. Jacob jariapari baquë Judá iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jatsi dos ca baquë bo, naa Fares, Zara, tihi cabo Judá jayaniquë. Jato jahëhua, Tamar ini quiha. Jatsi Fares baquë Esrom iniquë. Esrom baquë Aram iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram baquë Aminadab iniquë. Aminadab baquë Naasón iniquë. Naasón baquë Salmón iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón baquë Booz iniquë. Jasca, jahuë jahëhua Rahab ini quiha. Jatsi Booz baquë Obed iniquë. Jasca, jahuë jahëhua Rut ini quiha. Jatsi Obed baquë Isaí iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí baquë David iniquë, naa chama-chamaria inish cato. David baquë Salomón iniquë. Urías i-ipaonish ca ahui jahuë jahëhua ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón baquë Roboam iniquë. Roboam baquë Abías iniquë. Abías baquë Asa iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa baquë Josafat iniquë. Josafat baquë Joram iniquë. Joram baquë Uzías iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías baquë Jotam iniquë. Jotam baquë Acaz iniquë. Acaz baquë Ezequías iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías baquë Manasés iniquë. Manasés baquë Amón iniquë. Amón baquë Josías iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Jeconías, jahuë noma bo, tihi cabo Josías saihuaniquë. Naatiyá tsi Babilonia mai qui Israél ca nohiria bohacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jaquirëquë Salatiel Jeconías saihuaniquë. Jatsi Salatiel baquë Zorobabel iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel baquë Abiud iniquë. Abiud baquë Eliaquim iniquë. Eliaquim baquë Azor iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor baquë Sadoc iniquë. Sadoc baquë Aquim iniquë. Aquim baquë Eliud iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud baquë Eleazar iniquë. Eleazar baquë Matán iniquë. Matán baquë Jacob iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob baquë José iniquë, naa María bënë. Jabi Jesu, naa Cristo icanai ca María comaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jabi Abraham bësotiyá quirëquë catorce ca naborëquëbo iniquë. Jatsi chama David yamabo bësoniquë. Jaquirëquë catorce ca naborëquëbo huëtsa bo iniquë. Jatsi Babilonia mai qui Israél cabo bohacaniquë. Jaquirëquë catorce ca naborëquëbo huëtsa bo iniquë. Jatsi Jesu coniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Nëca tsi quiha Jesucristo conina ra. Jabi bënë bipaima jahuë jahëhua María iniquë. Jahuë bënë ti ca José ini quiha. Jama, bënë binox pari tsi quiha María tohoyaniquë Espíritu Santó no. ");
INSERT INTO caoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jatsi quiha José, naa jahuë bënë ti cató María bicasyamaniquë, joni shinajiaxëni ca ja ini quëshpi na. Jasca, nohiria bësojo xo tsi bëro tsi María ja niacasyamani quiha, bërabihuacasyamaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Jaha tsi jahuë ahui ti ca niahai ca ja shina-shinaniquë. Shinajano tsi quiha ja qui jisiquiniquë Iboba ángel, ja namahai cató no. Jisiquihax José qui ja chaniniquë: —Jisa José, David yamaba chahitaxocobá. Mi ahui ti ca María biti raquëyamahuë. Espíritu Santó tsi ja tohoyayamëquë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Baquë comaxëhi quiha. Ja coquë tsi Jesu ja janëhacaxëti xo, jato jocha quima nohiria bo ja xabahamaxëhai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nëcapi-jayamëquë Iboba Chani jatihuahacano iquish na, naa jahuë Chani yoanish cató quënënina. ");
INSERT INTO caoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Jabi ja quënëni ca tsi xo naa: “Tohoyaxëhi quiha yoxajahini. Tohoyaxo tsi baquë comaxëhi quiha. Comaxo tsi Emanuel ja janëhacaxëti xo” —nëa tsi quiha José qui ángel nëcaniquë. Noba joí tsi “No bëta xo Dios” ii quiha jahuë janë. ");
INSERT INTO caoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Bësoxo tsi quiha María José biniquë jahuë ahui iti, naa angél yoani jascaria. Bixo tsi jahuë xobo qui ja bëniquë racati. ");
INSERT INTO caoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Jabi jahuë ahui ya ja jobonayamani quiha jariapari jahuë baquë conox pari no. Baquë coquë tsi quiha Jesu José janëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belén tsi quiha Jesu coniquë, naa jodioba maí no. Toa mai rey Herodés yonani quiha. Toatiyá tsi quiha Jerusalén qui tres ca tiisi ca joni bo cahëniquë. Nëama, naa oriente ax ja bëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Cahëhax, —¿Jahuënia ni jodioba chama-chamaria, naa cobëna cato? Jahuë huishti no jisyamëquë noba mai xo na. Ja iqui tsi ja qui arahi no joquë ra —i nohiria qui naa tres ca tiisi ca joni bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Jatsi quiha shina-huëjënatsi chama Herodes niquë nicahax na. Shina-huëjëniquë Jerusalén ca nohiria ri. ");
INSERT INTO caoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Jatsi jodioba arati iboba chama bo, Dios papi cahëxëni cabo, tihi cabo Herodés quënaniquë. Quënaxo tsi jato ja nicaniquë: —¿Jahuënia tsi coxëhi ni mato Cristo, naa mato Xabahamati Ibo ra? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Jatsi quiha ja quëbicaniquë: —Jodioba maí tsi, naa Belén yacatá tsi ja coti xo. Tocani quiha Dios Chani yoanish cato, naa ja quënëni cató no: ");
INSERT INTO caoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Jisa Belén ca nohiria bá. Jodioba maí tsi huëstima tsi xo toa mato oquë ca yaca huëtsa bo. Jama, oquëhuahacaxëhi quiha mato yaca ri. Belén tsi coxëhi quiha chama-chamaria. Noho Israél ca nohiria bo ó bësoxëhi quiha” ii quiha ja quënënina —i Herodes qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jatsi quiha johax ca tiisicanaibo qui chani Herodés raaniquë ja qui ja bëcano iquish na. Jamë jato bëta ja chanicasni quiha. Ja bëcaquë tsi quiha Herodés jato nicaniquë: —¿Jënino tsi ma jisni ca huishti jisiquini? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jatsi quiha Belén qui Herodés jato raaniquë. —Toa baquë mërahi bocata. Tsayahax jahari ma bëcano ëa yoaxëna. Ja qui cacasquia ëa ri ja qui araxëna —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Jatsi quiha Belén qui bocatsi quiha tiisi jaya ca joni bo niquë, Herodes nicahax na. Ja bocaquë tsi quiha jisiquitëquëniquë huishtima, naa jato maí tsi jisiquinish ca huishti jascaria cato. Jisiquixo tsi quiha Belén qui jato ja mëpiniquë. Jatsi Baquë Jesu ini ca iti qui cahëhax huishti niiniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jatsi ja rani-ranicaniquë, huishti jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ranihax José xobo qui ja jicocaniquë. Jicoxo baquë ico ca María ja jiscaniquë. Jatsi ja mënicaniquë. Mënihax ja qui ja aracaniquë. Jaquirëquë quiha jato sota bo ja pëcacaniquë, ja bëcani ca jahuë bo ja qui axëna. ");
INSERT INTO caoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jaquirëquë ja namacanai cató tsi quiha Diós jato yobaniquë: —Jahari Herodes qui boyamacahuë —iquiina. Jaha tsi bahi huëtsa quiha jato país qui ja bocaniquë jahari. ");
INSERT INTO caoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tiisi ca joni bo bocaquë tsi quiha José qui ángel jisiquiniquë ja namahai cató no. —Joihuë. Baquë pistia, jahuë jahëhua María, tihi cabo bihuë. Egipto mai qui jabatsicana. Toaparicahuë. Mato ë yoano tsi jënimaxëhi quiha ma bacahaina. Mi baquë mërapaima xo Herodes pë, axëna —nëa tsi quiha José qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jatsi quiha José joiniquë. Joixo Baquë, jahuë jahëhua, tihi cabo ja boniquë Egipto mai qui. Baquichá ja jisbayacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Toá tsi naama tsi quiha ja chitëcaniquë. Jatsi Herodes rësoquë tsi ja bacacaniquë. Nëca tsi Dios Chani yoanish cató quënëni ca jatihuahacani quiha, “Egipto quima noho Baquë ë quënaquë” i Ibo Dios ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jabi tiisi jaya ca joni bá Herodes paraniquë, quinia huëtsa jato mai qui ja bacacani quëshpi na. Jatsi ja paracanai ca cahëhax Herodes caxarianiquë. Caxaxo tsi jahuë soldado bo ja raaniquë jatiroha ca Belén ca baquë bo ati. Jasca, Belén tahë ca yaca bo qui jato ja raani quiha, toá ca baquë bo ati. Jatiroha ca baquë bo quiha, naa dos años nama cabo ja ani quiha. Jabi ja tocaniquë shinaxo na, siri tsi jahari jato mai qui tiisi jaya cabo bocani nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jato ja quëyoquë tsi quiha Jeremías, naa Dios Chani yoanish cató yoani ca jatihuahacani quiha. Ja yoani tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Anomaria iqui quiha Ramá ca pacotsa. Cohuëria xo ja ara-aracanaina ra. Toá tsi jato xocobo quëshpi tsi arahi quiha yoxa bo. Ranihuatimaxëni tsi xo toa jahuë nohiria, jato baquë bo acacani iqui na” tihi tsi ii quiha ja quënënina. ");
INSERT INTO caoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jatsi Herodes rësoniquë. Ja rësoquë tsi quiha José qui Iboba ángel jisiquiniquë ja namahai cató no. ");
INSERT INTO caoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Jisiquihax, —Joihuë. Baquë pistia, jahuë jahëhua, tihi cabo jahari Israel mai qui bohuë. Rësoyoniquë Baquë pistia acascanish cabo ra —i José qui ángel niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Jatsi quiha José joiniquë. Jesu pistia, jahuë jahëhua, tihi cabo bihax Israel mai qui ja bacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bacaxo tsi quiha Herodes yamaba baquë Arquelaó yonahai ca ja nicaniquë. Jahuë jahëpa ja ratini quiha yonaxëna. Nicahax tsi quiha José raquë-raquëniquë. Toa mai qui ja cacasyamani quiha racaxëna. Jatsi quiha angél yobatëquëniquë ja namahai cató no, Galilea mai qui ja cano. ");
INSERT INTO caoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Cahëhax Nazaret icanai ca yaca qui ja caniquë racahi na. Toa xo tsi jahuë xobo ja aniquë. Tocapijani quiha, Dios Chani yoanish cató chani jatihuaxëna, naa “Nazareno ja quënahacaxëti xo” i ja ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nazarét tsi Jesu racano tsi quiha nohiria ashimanish ca Juan jisiquiniquë jodioba maí no. Xabacha xo tsi quiha Dios Chani ja yoaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Mato jocha quima Dios quiri bësocana. Joti basima tsi xo Diós otohaina ra —i nohiria bo qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jabi nëca tsi quiha Juan yoati tsi Dios Chani yoanish ca Isaiás quënëni quiha: “Xabacha xo tsi quënaxëhi quiha joni. Quënahi tsi ‘Rohahuahacatsicana Ibo johai quëshpi na’ ixëhi quiha. Jasca, ‘Bahi mëstë ca acana ja bax coti’ ixëhi quiha” nëa tsi quiha ja quënëni ca niquë Juan yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Camello raní tsi quiha Juan sahuëti acacaniquë. Bichi cinturón ja chinëxëniquë. Chapo bo, bina bata, tihi cabo ja piniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jasca, jodioba maí ca nohiria tëquë Juan qui bocaniquë jahuë chani nicaxëna. Bocani quiha Jerusalén ca nohiria ri. Bocani quiha ani Jordán tapaí ca nohiria. ");
INSERT INTO caoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Jasca, jato jocha ja bërohuacaquë tsi quiha ani Jordán xo tsi jato ja ashimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jatsi Juan qui huëstima ca jodioba chama bo bocaniquë ashimahacaxëna. Jato jisi tsi jato Juán raahaniquë: —Jisa, rono ba baquë bá. ¿Tsohuë mato yobaha, Dios johai ca copi quima paxaxëna? ");
INSERT INTO caoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Jocha pi quima bësoquí tsi mato jabi paxa ca pari noqui jismacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Quiniacaxëcahuë. “Dios xocobo yoi bo xo noa” i ma casmitsa, Abraham yamaba chahitaxocobo ma nori iqui na. Mahitsa tsi xo toa ra. Jaha pi quëëquí tsi naa maxax bo jahuë xocobo yoi manëmati mëtsa xo Dios, jahuë́-na bo iti. ");
INSERT INTO caoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Jaboqui tsi nohiria copihi quiha Dios ra. Bimi jia ca pi jihuí saihuayamano tsi rërahi quiha ibo. Rëraxo tsi chihi qui niaxëhi quiha. Jabi tocaxëqui Dios ri jabi jia ca saihuayamahai ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jaboqui mato jocha quima pi ma casono tsi mato ashimaxëquia jënë́ no. Jama, ë cho joxëhi quiha ëa oquë cato ra. Jahuë yonati iti mëtsama xo ëa ra, ëa oquëria ca ja nori iqui na. Espíritu Santo, chihi, tihi cabá tsi mato ashimaxëhi quiha ra joquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nohiria yoi cabo quima jahuë xocobo yoi bo aquëxëhi quiha Dios, naa ibobá jahuë trigo bëro aquëhai jascaria. Aquëxo jahuë nëpo niahi quiha. Jasca, jahuë xobó tsi jahuë xocobo yoi bo ó bësoxëhi quiha Dios; jama nocatimaxëni ca chihi qui niahacaxëti xo toa nohiria yoi bo, naa nëpo niahacahai jascaria —i Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jatsi ani Jordán qui Jesu joniquë Galilea mai ax na. Johax tsi quiha Juan qui ja caniquë ashimahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jama, Juán Jesu ashimacasyamani quiha. —¿E qui johai pa? Jishopë, acasyama xo ëa ra. Ea pi mi ashimaxëti xo ra —i Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jatsi Jesú quëbiniquë: —Jaboqui ëa mi ashimano. Nëca ca quiniá tsi jaha Dios quëëhai ca jatihuaxëqui noa —i Jesu niquë Juan qui. Jatsi Juán Jesu ashimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ashima-hacahax tsi quiha jënë quima Jesu tsëquëniquë. Tsëquëjano tsi quiha japëquëniquë naipa. Jatsi nai ax Dios Shina ja qui botëhai ca, naa boto jascaria, Jesú jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Jatsi naipá ca joi chaniniquë: —Noho Baquë tsi xo naa ra. Noiquia. Ja qui raniquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jatsi quiha xaba qui Espíritu Santó Jesu mëpiniquë, Satanás tanamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta bari no tsi quiha ja piyamaniquë. Paxnatsijaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jatsi ja qui Satanás joniquë, jochati tanamaxëna. —Dios Baquë pi iqui tsi maxax bo qui chanihuë, mapari ja manëcano —i ja qui Satanás niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jatsi Jesú quëbiniquë: —“Mapari roha tsi bësoyamaxëhi quiha joni; jama Dios Chaní nori” ii quiha Quënëhacanish cabo —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jatsi Jerusalén qui Satanás boniquë. Boxo tsi quiha Dios arati xobo cacha, naa jahuë quëpë tsi Jesu ja nimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Nimahax Satanás chaniniquë: —Dios Baquë pi iquí tsi mai quiri mimë niahuë. “Jahuë ángel bo raaxëhi quiha Dios, mi noho ja bësocano” ii quiha Quënëhacanish cabo. Jasca, “Jato mëquënë́ tsi mia bëcaxëcani quiha, maxaxá tsi mi tahë bo tëquëyamano iquish na” ii quiha —nëa tsi Jesu qui Satanás nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jatsi Jesú quëbiniquë: —Jama xo. “Ibo Dios tanamayamahuë” ii quiha Quënëhacanish cabo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jatsi quiha maca tëtëca qui Satanás Jesu boniquë maí ca país bo, jato oquë, tihi cabo ja qui jismaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Jismahax tsi quiha Jesu qui ja chaniniquë: —Ea bësojó pi mi mënino tsi, ë qui pi mi arano tsi, naa jahuë bo tëquë mi qui axëquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jatsi Jesú quëbiniquë: —Cata, Satanás. “Ibo Dios roha qui aracana. Ja roha nicacana” ii quiha Quënëhacanish cabo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jatsi Jesu Satanás jisbayaniquë. Ja caquë tsi quiha ángel bo bëcaniquë Jesu mëbixëna. ");
INSERT INTO caoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Naatiyá tsi quiha preso qui Juan nanëhacaniquë rë. Nicaniquë Jesu. Nicahax tsi quiha jodioba mai Jesú jisbayaniquë. Jisbaya tsi Galilea mai qui ja bacaniquë, naa jahuë Nazarét ca xobo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Jama, Nazarét ja chitëyamani quiha. Riquihax Capernaum yaca qui ja cani quiha racaxëna, naa ia Galilea tapaí cato. Zabulón, Neftalí, tihi ca mai bo basima quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tocajaquë tsi Isaiás quënëni ca jatihuahacani quiha. Jabi Isaiás quënëni ca tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Jisa Zabulón ca nohiria bá; Jisa Neftalí ca nohiria bá, naa ia quinia cabo, naa ani Jordán rabëquëx ca nohiria bá. Jisa mato Galileá ca carayanabá. ");
INSERT INTO caoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Huëa-huëaria nori ca jisxëqui tsëmo ó ca bësohai ca nohiria bo ra. Rësopaoti basima ca nohiria bo qui huahuaxëhi quiha Huëa nori cato ra” ii quiha ja quënënina. ");
INSERT INTO caoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Jaquirëquë Dios Chani yoatí Jesú chitahëhuaniquë: —Mato jocha quima Dios quiri bësocahuë. Jaboqui otocatsi quiha chama-chamaria Dios ra —i nohiria bo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ia Galilea quënipama tsi quiha dos ca joni bo Jesú jisniquë, naa Simón, naa Pedro quënahacanish cato, jahuë noma Andrés. Jisi tsi jato ja quënaniquë. Jabi jato sani biti nishi bo niahi ja icani quiha, sani bicanaibo ja icani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—Nëri bëcahuë. Ea ma banahuano. Joni bo bicanaibo mato manëmaxëquia —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jatsi bamaxoma tsi quiha jato sani biti nishi bo, jato jahëpa, tihi cabo ja jisbëriacaniquë Jesu banahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Riquicayá tsi quiha ori tsi dos ca joni huëtsa bo Jesú jisniquë, naa Zebedeo baquë Jacobo, Jacobo noma Juan. Notí tsi jato jahëp ya ja icani quiha, jato sani biti nishi bo rohahuahi na. Jatsi Jesú jato quënaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jatsi bamaxoma tsi quiha jato nishi bo, jato jahëpa, tihi cabo ja jisbëriacaniquë Jesu banahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jatsi quiha Galilea mai tëquë tsi Jesu coniquë, Dios Chani yoahi na. Jodioba catiti xobo xo tsi ja tiisimabonani quiha. “Nohiria bo otocatsi quiha Dios ra” i ja ni quiha Chani jia ca yoahi na. Jasca, iquicanaibo, isicanaibo, tihi cabo ja jënimahuabonaniquë, Dios Chani yoaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jatsi ja ani iqui tsi chani pacananiquë ja yoati na. Siria maí tëquë tsi toa chani pacanani quiha. Jatsi iquicanaibo, isicanaibo, yoshi jaya cabo, yoyo jaya cabo, mohitimaxëni cabo, tihi cabo Jesu qui nohiria bá bëniquë jënimahuahacacano. Jatsi jato ja jënimahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jasca, nohiria miscó Jesu banahuaniquë ra. Galileá ca nohiria, Diez Yacatá ca nohiria, Jerusalén ca nohiria, jodioba maí ca nohiria, ani Jordán rabëquëx ca nohiria, tihi ca nohiriá banahuani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Nohiria misco jisi tsi maca chahitaxëni Jesu tëmahinaniquë. Tëmahinahax tsi quiha ja tsahoniquë. Jatsi jahuë rabëtiria bo ja qui quëtsoniquë jahuë chani nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jatsi jato tiisimati ja chitahëhuaniquë. Ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Shoma tsi xo toa Dios jabi ja nariscanai ca cahëxëni cabo. Jató-na xo Dios. Jato otoxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","‘Shoma tsi xo toa cohuë cabo. Jato bëpasimaxëhi quiha Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","‘Shoma tsi xo toa shinapënicanaibo. Naa mai tëquë ibohuacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","‘Shoma tsi xo toa Dios mëstë ó quëëcanaibo. Jato ranihuaxëhi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","‘Shoma tsi xo toa nohiria huëtsa bo mëbicanaibo. Jato mëbixëhi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","‘Shoma tsi xo toa shinajiaxëni jaya cabo. Dios jiscaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","‘Shoma tsi xo toa iquinacasyamacanaibo. Dios baquë bo quënahacacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","‘Shoma tsi xo toa tënëmahacacanaibo jia ca ja acanai quëshpi na. Jató-na xo Dios. Jato otoxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","‘Shoma xo mato, ëa iqui tsi nohiria bá mato ocahuaquë no, mato ja yosicaquë no, mato ja quiahuacaquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rani-ranicana, anomaria ca copi mato bax janahacaxëhai quëshpi na. Jabi toca tsi mato rëquë ca Dios Chani yoanish cabo tënëmahacani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","‘Chopara jascaria xo mato, maí ca nohiria bo oquëhuati. Jabi jahuë tëë bënopihi tsi anoma xo toa chopara ra. ¿Jënahuariaxo ja tëëhuahacatëquëna ra? (Jascaria, mato jabi jia ca pi ma bënono tsi ¿jënahuariaxo raca maí ca nohiria bá ëa cahëna?) Chopara yoi ca jascaria ma niahacaxëti xo pë, mahitsa ma nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","‘Huëa jascaria xo mato, maí ca nohiria bo huëahuati. Jabi jonëtimaxëni tsi xo tëmachí ca yacata. Baquichá tsi bëroria tsi xo jahuë pëxë bo. ");
INSERT INTO caoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jascaria, mato pëxë tsamaxo tsi caca namá janayamaqui mato. Jama, mana, naa jahuë iti ó janaqui mato, xobó ca nohiria bo tëquë bax huahuati. ");
INSERT INTO caoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jasca, nohiria bo bësojó tsi huahuapaima xo mato jabi jia cabo, ma acai ca ja jiscano iquish na. Jisí tsi mato mana ca Jahëpa oquëhuacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","‘¿Quënëhacanish cabo niahi ë joni pa? Iyamaquia ra. Quënëhacanish cabo jatihuahi ë joquë ra, niahi mari. ");
INSERT INTO caoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mato parayamaquia ra. Niahacapistiariayamaxëhi quiha Quënëhacanish cabo ó ca huësti ca yoba pistia ra. Jatihuahacaxëhi quiha jahuë yoba tëquë. ");
INSERT INTO caoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Quënëhacanish cabo ó ca yoba iriama ca pi nicayamahi tsi oquëyamaxëhi quiha toa nohiria ra, Dios otohai cató no. Jasca, “Mahitsa tsi xo toa yoba” i pi nohiria huëtsa qui ja no tsi chama-chamaria Dios qui yoixëhi quiha ja ocahaina. Mana tsi iriamaxëhi quiha toa ocahai cato ra. Jama, Quënëhacanish cabo ó ca yoba bo pi nicahi tsi huëtsa bo pi nicati tiisimahi tsi, oquë-oquëriaxëhi quiha toa nohiria ra, Diós otohai cató no. ");
INSERT INTO caoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Japi mato parayamaquia. Dios Chani cahëxëni cabo, fariseobo, tihi cabo pi mato mëstë huinoyamano tsi Diós otohai ca qui jicopistiayamariaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“‘Joni bo ayamahuë. Namëhacaxëti xo tsohuëcara ca joni huëtsa acax cato” i mato naborëquëbo qui Moisés yoba ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jama, mato qui ë yoahai ca tsi xo naa ra: Copihacaxëti xo tsohuëcara ca jabë xatë qui caxahai cato ra. Jabë xatë pi pasomaha chanihi tsi chama, naa juez qui ja bëhacaxëti xo copihacati. Jabi tënëtiya qui niahacati basima tsi xo toa tsohuëcara ca jabë xatë qui “Yoyoxëni xo mia pë” iquii cato. ");
INSERT INTO caoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Japi mabë xatë bo ya rabënaparicana, Dios qui arahi bocanox pari. Jama, Dios xobo xo pi mato qui caxa ca xatë shinaquí tsi Dios qui ma acatsai ca jahuë janaparicahuë. Jariapari mato qui caxa ca xatë qui bocata. Mabë xatë ya ma rabënaparino ra, Dios qui aranox pari. Rabënahax jahari Dios xobo qui bocata araxëna, ma bëha ca jahuë ja qui axëna. ");
INSERT INTO caoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","‘Tsohuëcara pi mato pasomaha-no tsi mëri tsi ja bëta rabënacana. Bamayamacana. Tocacana, gobierno chama bo qui mato ja mëayamano, copihacati. Tocapijano tsi preso qui ma niahacamitsa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Toá quima ma tsëquënox pari tsi toá cuenta pari jatihuaxëqui mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“‘Bënë jaya ca yoxa biyamacahuë” mato rëquëyamabo yoahacani quiha. Jabi toa yoba ma nicaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jama, jahuë bëro yoí pi bënë jaya ca yoxa tsayahi tsi ja bëta jochahi quiha bicatsai ca nohiria jahuë shina ó no. Ja bëta jobonahai jascaria tsi xo toa ja acaina. ");
INSERT INTO caoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Jabi mato oquë ca bëro pi mato jochamano tsi toa bëro tsëcacahuë. Niacahuë. ¿Oquëyamayamahi ni mato bëro pistia bënohaina, tënëtiya qui mato yora tëquë niahacayamano iquish na? ");
INSERT INTO caoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Mato oquë ca mëquënë́ pi mato jochamano tsi toa mëquë mëxtëquëcahuë. Mëxtëquëxo tsi niacahuë. ¿Oquëyamayamahi ni mato mëquë bënohaina, tënëtiya qui mato yora tëquë niahacayamano iquish na? ");
INSERT INTO caoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","‘Jasca, “Ahui pi niaquí tsi ja qui niati papi bënë́ ati xo” ¿i mato naborëquëbo qui Moisés yamayamani? ");
INSERT INTO caoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jama, ë yoahai ca tsi xo naa: Anoma tsi xo bënë́ jahuë ahui niahaina iquia ra. Mahitsa pi jahuë ahuini, naa joni huëtsa ya jobonayamahai ca ahui niaquí tsi jahuë ahui jochamahi quiha pë, bënë huëtsa ja biquë no. Jascaria, jochaxëhi quiha jahuë ahui bichi ca joni ri. ");
INSERT INTO caoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","‘Jabi mato naborëquëbo yoahacani ca yoba bo ma nicaniquë iquia. “Dios bax toa axëquia ra” i pi ma no tsi mato chani jatihuacana. “Anoma tsi xo toa ma ayamahaina tocaquí na” ii quiha Dios yoba ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jatsi, ë yoahai ca tsi xo naa: Oquë tsi xo toa ma bëpahaina. Jasca, Dios bësojo xo tsi jurar-ayamacana, “Axëquia ra” i nohiria qui ma quë no. Jasca, “Naipá tsi parayamaquia, axëquia ra” i nohiria qui yamacana, ma quëbiquë no. Diós yonahai iti tsi xo toa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jascaria, “Noba maí tsi parayamaquia; axëquia ra” iyamacana, ma quëbiquë no, Ibo Dios mai ja nori iqui na. Jasca, “Jerusalén tsi parayamaquia” iyamacana, noba chama-chamaria yaca ja nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jasca, “Noho mapó tsi parayamaquia” iyamacana. ¿Jënahuariaxo mato boo chëquë ma joxohuana? ");
INSERT INTO caoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Jama, “Axëquia, ayamaquia” tihi roha ca icana, ma quëbiquë no. Jahuëcara huëtsa pi ma yoano tsi Yoshi quima tsi xo toa ma yoahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","‘Jabi mato naborëquëbo yoahacani ca yoba ma nicaniquë iquia. “Nohiria huëtsa bëro quëshpi tsi jahuë bëro yoi copihacaxëti xo; jasca, nohiria huëtsa xëta quëshpi tsi jahuë xëta yoi copihacaxëti xo” i mato yoba ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jama, ë yoahai ca tsi xo naa: Yoixëni ca joní pi mato yosino tsi jahari iquinayamacana iquia. Tsohuëcaracá pi mato tapaishano tsi caxayamacana. Ja qui mato tamo huëtsa acana tapaishahacati. ");
INSERT INTO caoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Jasca, mato camisa pi biriacasquí tsi mato saco ri ja bino. ");
INSERT INTO caoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Jasca, huësti kilómetro pi soldado bá jato sota bo mato papimano tsi kilómetro huëtsa jato bax ma bocano jato mëbixëna. ");
INSERT INTO caoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jasca, tsohuëcaracá pi mato jahuëcara bënariano tsi ja qui acahuë. Tsohuëcaracá pi mato jahuëcara tanacasno tsi ja qui prestahuahacahuë. Tihi tsi xo toa noho yoba ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","‘Jabi mato naborëquëbo yoahacani ca yoba ma nicaniquë iquia, naa “Mato rabëti bo noicahuë; jama, mato pasomaha cabo qui caxacahuë” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jama, mato qui ë acai ca yoba tsi xo naa: Mato pasomaha cabo noicahuë iquia. Jasca, mato yosicanaibo bax bëhoxcana ra. ");
INSERT INTO caoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tocapiquí tsi mato naipá ca Jahëpa baquë bo ma nori ca jismaxëqui mato ra. Jatiroha cabo mëbihi quiha Dios. ¿Jiaxëni cabo, yoixëni cabo tëquë, tihi cabo qui huahuayamayamahi ni jahuë bari ra? Jasca, jia ca acanaibo, anoma ca acanaibo, naa jatiroha cabo qui oi paquëmahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mato rabëti bo roha pi noihi tsi ¿jënahuariahax nohiria huëtsa ma oquëna? Tocapimano tsi ¿mato copixëhi ni Dios pa? ");
INSERT INTO caoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Jasca, mato rabëti bo roha pi mëbihi tsi ¿nohiria huëtsa oquë ni mato pa? Iyamaqui mato ra. Tocacani quiha Dios cahëyamacanaibo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Jatsi quësotimaxëni ca jabi ma jayati xo, naa mato naipá ca Jahëpá-na jascaria. Tihi tsi xo toa noho yoba ra. ");
INSERT INTO caoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","‘Quiniacaxëcahuë. Nohiria bësojo xo tsi mato yonoco jia bo ma ayamati xo iquia. Tocapimano tsi mato copiyamaxëhi quiha mato naipá ca Jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Japi noitiria ca nohiria pi mëbiquí tsi no bëpati xo. “Jia tsi xo toa ë acaina ra” iyamacana nohiria bo qui, naa fariseobo jascaria. Anoma quiha. Jabi nohiria bo bësojo xo tsi tocacani quiha pë, nohiria bá jato oquëhuano iquish na. Jatsi shina-bënoyamacana. Copihacacahi quiha, nohiria bá jato oquëhuaquë no. Mana ca copi biyamacaxëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jama, noitiria ca nohiria pi mëbiquí tsi no bëpaxëti xo, mato rabëtiria bá ma acai ca cahëyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jonë tsi mato yonoco jia bo ma ano. Jatsi, mato copixëhi quiha Dios ra, jatiroha ca jahuë bo jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","‘Dios qui bëhoxhi tsi paraxëni ca fariseobo jascayamacana. Nohiria bo bësojó, naa jodioba catiti xobo bo, bahi bo, tihi cabá tsi Dios qui bëhoxcascani quiha pë, nohiria bá jato jisno iquish na. Jato copi ja bicaquë iquia. Mana ca copi biyamacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jama, bëhoxhi tsi mato naquëtë qui mamë jicocahuë. Jicohax caiti japacahuë, nohiria bá mato jisyamano iquish na. Toá tsi Dios qui bëhoxcana, mamë no. Jonë pi bëhoxmano tsi mato copixëhi quiha, ma acai ca jonë ca jahuë bo jisquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Jasca, Dios qui bëhoxhi tsi mahitsa ca chani iroha-irohayamacana. Tocacani quiha Dios cahëyamacanaibo. Jato chani tëtëca iqui tsi Diós jato nicahai ca quëscahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Jabi jaha ma quëëhai ca cahëhi quiha mato Jahëpa, ma bënanox pari no. ");
INSERT INTO caoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Japi nëca tsi bëhoxcana: “Oquëhuahacaxëti xo mi janë, noba naipá ca Jahëpá” icana. ");
INSERT INTO caoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“Nohiria bo mi ototsano. Mai xo tsi mi shina mi ano, naipa xo mi acai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Jatiroha ca bari oriquiti noqui ana. ");
INSERT INTO caoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Noba jocha mi shina-bënono, noqui pasomaha jochacanaiba jocha no shina-bënohai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Jochati no tanamahacayamano. Yoixëni cato chamá quima noqui mi tsëcano” tihi tsi nëcacana bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","‘Huëtsa ba jocha pi ma shina-bënono tsi mato jocha ri shina-bënoxëhi quiha Dios ri. ");
INSERT INTO caoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Jama, huëtsa ba jocha pi ma shina-bënoyamano tsi mato jocha shina-bënoyamaxëhi quiha Dios ri. ");
INSERT INTO caoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","‘Samaquí tsi bëmana cohuëria cabo jayamacana, naa paraxëni ca fariseobo jascaria. Bëcohuëhuacani quiha pë, nohiria bá ja samacanai jisno iquish na. Shina-bënoyamacana; jato copi ja bicaquë ra. Mana ca copi biyamacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jama, samahi tsi bëchococahuë. Bohuëxicahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Tocapimano tsi ma samahai ca cahëyamacaxëcani quiha nohiria ra. Cahëxëhi quiha mato Jahëpa roha, jatiroha ca jonë ca jahuë bo cahëquí na. Mato copixëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","‘Naa mai xo tsi copixëni ca jahuë bo catiayamacana mato bax na. Naamayamacaxëcani quiha naa maí ca jahuë bo ra. Mëri tsi quëyohacacahi quiha, naa raiti jotoró pihai jascaria. Jascaria, ja yomahacacamitsa. ");
INSERT INTO caoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Jama, naipá ca jahuë bo ma catiapaima xo. Toá tsi naamacaxëcani quiha. Quëyohacatimaxëni xo toá cabo. Jasca, yama tsi xo toa mana ca yomaxëni cato. ");
INSERT INTO caoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Japi maí ca jahuë bo pi ó quëërohaquí tsi Dios noiyoiyamaqui mato iquia. Jama, mana ca jahuë bo pi ó quëëquí tsi Dios noiyoiqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","‘Jabi lamparina jascaria xo mato shinana. Mato quinia qui huahuahi quiha mato shinana, jënima ja iquë no. Jaha tsi jabi jia ca jayaxëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Jama, shina yoi pi jayahi tsi tsëmo ó tsi bohoxëqui mato rë. Jabi mato shina jia ca pi tsëmonano tsi anomaria tsi xo toa tsëmo ra. Tsëmo-tsëmoria tsi xo rë. ");
INSERT INTO caoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","‘Dos ca chama bo jayatimaxëni tsi xo nohiria ra. Huësti chama qui caxaxëhi quiha; chama huëtsa noijahuanori. Huësti chama bax yonocoriaxëhi quiha; chama huëtsa chahahua-yamajahuanori. Japi, ¿jënahuariahax Dios bax ma yonocona, parata noihi na? Dos ca ibo jayatimaxëni xo mato ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jabi jahuë rabëti bo Jesú yoani tsi xo naa: —Oriquiti yoati tsi shina-huëjëyamacana. Jasca, mato yora sahuëhai ca sahuëti bo shina-huëjëyamacana. ¿Jabi oriquiti oquë ma ni ma bësohaina? Jasca, ¿sahuëti oquë ma ni mato yora? ");
INSERT INTO caoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Naipá ca isa bo tsayacahuë; bëro banayamacani quiha ra. Bëro tësayamacani quiha. Jasca, yama tsi xo toa jato xobo qui nanëhaca ca bimi ra; jama, jari jënima jaca nori. Jato pimahi quiha mato naipá ca Jahëpa ra. ¿Japa? ¿Isa bo oquë ma ni mato ri ra? ");
INSERT INTO caoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Jasca, ¿jënahuariaxo raca ja bësohai ca año bo joní huinomana, ja shina-huëjëhai cató no ra? Jatsi shina-huëjëyamacana ma bësohai yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","‘¿Jëniriahax sahuëti bo shina-huëjëcanai ra? Huasi joa jiaxëni cabo qui tsayacahuë. Yonocoyamacani quiha ra. Jasca, sahuëti bo ayamacani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Jama, rico inish ca Salomón yamaba sahuëti oquë-oquëria tsi xo naa joa bo sahuëcanaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jabi Dios tsi xo toa naa joa bo sahuëmahaina, naa naamayamahai ca joa bo ra. Tocapiquí tsi ¿tonia mato sahuëmayamayamaxëhi ni Dios ra? Iriama tsi xo toa ma chitimihaina rë. ");
INSERT INTO caoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Japi shina-huëjëyamacana. “¿Jahuë pixëhi ni noa rë?” iyamacana. “¿Jënë axëhi ni noa ra?” iyamacana. Jasca, “¿Jahuë sahuëxëhi ni noa rë?” iyamacana. ");
INSERT INTO caoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Piti, jënë, sahuëti, tihi cabo shina-huëjëcani quiha Dios cahëyamacanaibo. Jaha quëëriacani quiha. Jama, mato otohi quiha mato Jahëpa, ma narisyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Jatsi mato Chama-chamaria pari shinacana. Jaha ja quëëhai ca jabi jia ca ó quëëcana. Tocapimano tsi naa jahuë huëtsa bo tëquë mato qui axëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Japi, shina-huëjëyamacana huëaquë yoati na. Huëaquë tsi tobixëhi quiha noqui yosihai ca jahuë huëtsa bo tonia. Japi jaboqui tsi huëaquë ca noqui yosihai ca jahuë bo yoati no shina-huëjënayamano. ");
INSERT INTO caoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","‘Ranimisyamacana, Diós mato raniyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ranipimahuano tsi nohiria ma ranihai jascaria ca quiniá tsi mato ranixëhi quiha Dios ri. Jasca, nohiria pi ma shomahuano tsi jascaria ca quiniá tsi mato shomahuaxëhi quiha Dios. Toa tsi xo toa Dios medida ra. ");
INSERT INTO caoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Jama, anoma ca mabë xatë bá acai tsayacasqui mato pë, ja qui quësocasquí na. Mato qui bëroria tsi xo toa mabë xatë jocha; bëroma mató-na nori. ¿Jocha yama ni mato pa? ");
INSERT INTO caoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Jëniriahax raca “Mia mëbixëquia, yoi ca mi ayamano iquish na, ëbë xatë bá” i ma na, oquë ca yoi ca ma aquë no? ");
INSERT INTO caoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Jariapari tsi toa yoi ca ma acai ca niaparicahuë, quiaxëni cabá. Niahax tsi mabë xatë mëbiti mëtsaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","‘Dios Chani ayamacana nicacasyamacanaibo qui. Quiniacaxëcahuë. Ina jascaria tsi mato qui ja tsamicamitsa mato axëna. Jasca, Dios copixëni ca Chani jato qui ayamacana. Aapimahuano tsi yahua jascaria tsi ja yoshihuacamitsa. Yoshihuahax mato quiri ja bësocamitsa mato axëna. ");
INSERT INTO caoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","‘Dios qui bëhoxquí tsi bënacana; mato qui acacaxëhi quiha. Jasca, mëracana. Mëraquí tsi bixëqui mato ra. Jasca, quënacana; mato bax japëcahacaxëhi quiha jahuë caiti. ");
INSERT INTO caoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Bënahai ca qui acacaxëhi quiha. Bixëhi quiha mërahai cato. Jasca, japëcahacaxëhi quiha jahuë caiti, tsohuëcara ca quënahai ca bax na. ");
INSERT INTO caoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","‘¿Mato baquë qui maxax acaxëcanai pa, mapari ja bënaquë no? ");
INSERT INTO caoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Jasca ¿rono ja qui acaxëcanai pa, sani mato qui ja bënaquë no, piti? Ayamaqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mato xocobo qui jahuë jia bo ati cahëxëni xo mato, jochacanaibo ma iquë ri. ¿Jabi toca ma ni mato naipá ca Jahëpa ri? ¿Bënacanaibo qui jahuë oquë ca jahuë bo ayamayamaxëhi ni? Axëqui ra. ");
INSERT INTO caoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","‘Jabi mato qui jia tsi xo nohiriá mato mëbihaina. Japi mato qui jia ca quiniá tsi nohiria ma mëbiti xo mato ri. Toca tsi noqui yobahi quiha Dios Chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","‘Caiti natsëo nacocahuë. Chahitaxëni tsi xo toa tënëtiya qui mëpihai ca caiti ra. Huëstima cabo tsi xo toa ja qui jicocanaibo rë. ");
INSERT INTO caoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jama, natsëo ca tsi xo toa bëso-bësopaoti mëpihai ca caiti ra. Bëronoma xo toa quinia. Ichariama tsi xo toa ja qui jicocanaibo rë. ");
INSERT INTO caoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","‘Mahitsa ca chani yoacanaibo quiniacaxëcahuë. Jia tsi mato qui bëcani quiha, caxatimaxëni ca oveja jascaria; jama, cama jascaria jaca nori. ");
INSERT INTO caoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","‘Jato yoi ca jabi jisquí tsi jato cahëxëqui mato ra. Jabi bimi jia ca saihuatimaxëni tsi xo isnëpa ra. Jascaria tsi, jabi jia ca saihuatimaxëni tsi xo toa jabi yoi ca nohiria ri. ");
INSERT INTO caoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jabi bimi jia ca saihuahi quiha jihui jia cato. Bimi yoi ca saihuahi quiha jihui yoi cato. ");
INSERT INTO caoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jascaria tsi, jabi jia ca roha saihuahi quiha joni shinajiaxëni cato. ¿Jënahuariaxo raca jabi jia ca joni shina yoi ca jaya cató saihuana? ");
INSERT INTO caoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Japi bimi jia ca pi jihuí saihuayamano tsi toa rërahi quiha ibo. Rëraxo tsi chihi qui niahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Jabi toca tsi mahitsa ca chani yoacanaibo cahëxëqui mato pë. Jato yoi ca jabi bá tsi cahëhacacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","‘Jabi Diós otohai ca qui jicoyamaxëhi quiha jatiroha ca “Ibo, Ibo” ëa quënahai cato. Noho naipá ca Jahëpa yoba nicahai ca roha tsi xo toa ja qui jicohaina. ");
INSERT INTO caoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Toa copiti barí tsi ë qui bëcaxëcani quiha huëstima ca mahitsa ca chahahuacanaibo. Toa barí tsi “Huëtsa bo qui mi chani no yoaniquë, Ibobá” icaxëcani quiha pë. Jasca, “Mi janë́ tsi yoshi bo no tsëcaniquë, Ibobá” icaxëcani quiha pë. Jasca, “Mi janë́ tsi huëstima ca jisti bo no aniquë ra” icaxëcani quiha huëtsa bo. ");
INSERT INTO caoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jama, bëroria tsi jato quëbixëquia, “Mato cahëpistiayamariaquia. Ea basicahuë, anoma ca acanaibá” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","‘Jabi tiisi tsi xo toa tsohuëcara ca noho yoba chahahuahai cato, nicaxo na. Maxax cacha ca xobo rohahuahai ca joni iquiria xo. ");
INSERT INTO caoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Poxoyamahi quiha ja aca ca xobo ra. Johi quiha oi-oiria. Baihi quiha jënë. Xotoriahi quiha yoshini. Jahuë xobo pasomaha choshahi quiha. Jama, poxoyamahi quiha jahuë xobo, maxax cacha ja rohahuahacani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Jasca, tobi toa yoyoxëni ca joni ri. Noho yoba chahahuayamahi quiha, nicaxo na. Mashënë cacha xobo acai ca joni jascaria xo. ");
INSERT INTO caoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jatsi johi quiha oi-oiria. Baihi quiha jënë. Xotoriahi quiha yoshini. Xobo pasomaha choshahi quiha rë. Jatsi poxohi quiha. Anomaria tsi xo toa ja poxohaina ra —tihi tsi Jesú yoaniquë tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ja chanihai ca Jesú jatihuaquë tsi quiha quëtsonish ca nohiria ratëniquë ja tiisimahai ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Jasca, chama jaya ca joni jascaria tsi jato ja tiisimani quiha, jodioba yoba cahëxëni cabo jasca ja nomari. ");
INSERT INTO caoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jabi maca ax Jesu rënichiquë tsi quiha huëstima ca nohiriá banahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jatsi ja qui joniquë noitiria ca joni, naa leproso bichi jaya cato. Bonohuaxëni ca joni ja ini quiha. Basimahax Jesu bësojó tsi quiha ja mëniniquë. Mënihax, —Aapicatsaii tsi ëa jënimahuati mëtsa xo mia ra, Ibobá —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jatsi quiha Jesú joni motsaniquë jahuë mëquënë no. Motsahax ja qui ja chaniniquë: —Mia jënimahuacasquia ra. Jënima xo mia ra —iquiina. Jatsi quiha jahuë bono tapoyotapiniquë ra. Jënima jahuë bichi ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jatsi Jesú joni yobaniquë: —Jënipimiha ca huëtsa bo qui yoayamahuë. Bamaxoma tsi arati ibo qui pari mimë jismata. Moisés yoani ca ja qui ahuë tëpas-hacati, mi bahuëhai quëshpi na. Tocapimino tsi jënima mi nori ca cahëcaxëcani quiha nohiria —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jaquirëquë quiha Capernaúm ca yaca qui Jesu jiconiquë. Ja jicoquë tsi quiha ja qui caniquë romanoba capitán. Caxo tsi quiha Jesu ja bënarianiquë: ");
INSERT INTO caoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Noitiria tsi xo noho yonati. Xobó raca quiha. Anoma quiha. Mohitimaxëni xo rë —i Jesu qui capitán niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jatsi, —Mi baquë jënimahuahi caxëquia ra —i Jesu niquë ja qui. ");
INSERT INTO caoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jatsi quiha capitán quëbiniquë: —Noho xobo qui mi jicoyamano, taitá, anoma ca ë nori quëshpi na. Jama, nëa ax rohari pi mi chanino tsi jënimaxëhi quiha noho yonati ra. ");
INSERT INTO caoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Jabi ëa oquë ca chama bo nicati cahëquia ra, ëa ja yobacaquë no. Jasca, ëa nicahi quiha noho soldado bo ri. Jabi huësti soldado qui “Cata” i pi ë no tsi caqui ra. “Johuë” i pi huëtsa qui ë no tsi johi quiha. “Tocahuë” i pi noho yonati qui ë no tsi ahi quiha —nëa tsi quiha Jesu qui capitán nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jatsi Jesu ratëniquë, capitán quëbihaca nicahax na. Jesu qui jia ini quiha ja chanihaina ra. Jatsi banahuacanaibo qui Jesu chaniniquë: —Mato parayamaquia. Anomaria tsi xo naa carayana chitimihaina ra. Jodiobá mai tëquë ó yama tsi xo nëca ca jodio chitimihai ca jasca cato rë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Jaroha ca barí tsi bëcaxëcani quiha carayanabo jatiroha ca mai iti ax na. Abraham, Isaac, Jacob, tihi cabo ya tsi tsahocaxëcani quiha jato ri, Diós otohai cato xo tsi pixëna. ");
INSERT INTO caoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jama, tsëmo qui niahacacaxëcani quiha mato Israél cabo, naa Diós otohai ca qui jicoti iquish cabo. Toatsixëhi quiha araconahaina, tënëhaina ra —nëa tsi quiha Jesu nëcaniquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jatsi quiha capitán qui Jesu chaniniquë: —Cata. Mi chitimihai iqui tsi jënimaxëhi quiha mi yonati —i capitán qui ja niquë. Jabi toa horá tsi jahuë yonati jënimahua-tapihacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jatsi quiha Pedro xobo qui Jesu caniquë. Toa xo tsi quiha jahuë raisi ja jisniquë, naa jahuë ahuiní jahëhua. Iquihi quiha. Oxati raca ja ini quiha jahuë huao iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jatsi jahuë mëquë Jesú motsaniquë. Janacatapiniquë jahuë iquini ra. Joixo tsi Jesu oriquiti ja taaniquë pa. ");
INSERT INTO caoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bari caquë tsi quiha Jesu qui nohiria bëcaniquë. Ja qui yoshi jaya ca nohiria ja bëcani quiha ja jënimahuano. Jatsi jahuë chaní roha tsi jato yoshi bo ja tsëcani quiha. Iquicanaibo tëquë ja jënimahuani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nëca tsi Isaías yamabá yoani ca jatihuahacani quiha, naa “Noqui iquicanaibo jënimahuahi quiha. Noqui noitiria cabo mëbihi quiha” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ja qui nohiria huëstima ca quëtsohai ca jisi tsi quiha jahuë rabëti bo ja yobaniquë, ia rabëquëx ca qui ja bocano. ");
INSERT INTO caoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Toá tsi quiha yoba cahëxëni ca joni Jesu qui joniquë. Johax, —Mia banahuacasquia, ëa ri ra. Jahuëcara qui mi cahai cató tsi mia banahuaxëquia ëa ri —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jatsi Jesú quëbiniquë: —Jato quini bo jaya xo bocacamano, racati. Jasca, jato naha jaya xo isa bo ri. Jama, racati xobo yama ca ëa xo naa, naa nai ax johax cato —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jatsi Jesu banahuahai ca joni huëtsa chaniniquë: —Mia banahuacasquia, Ibobá. Jama, jariapari noho jahëpa ë maihuati xo. Rësopaimaria xo ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jatsi quiha, —Jaboqui ëa mi banahuano ra. Dios cahëyamacanaibá jato nabo maihuano —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jatsi noti qui Jesu jiconiquë. Jicoxo jahuë rabëti bo yaxo ia shitatsijahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jatsi quiha xotoriatsi yoshi niquë ra. Anomaria choca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jatsi Jesu bësomahi ja bocaniquë. Bësomahax, —Noqui mëbihuë, Ibobá. Jëtëquëqui noa ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jatsi quiha, —¿Jëniriahax raquëcanai pa? Iriama tsi xo ë qui ma chitimihaina rë —i jato qui ja niquë. Jatsi quiha Jesu joiniquë. Joihax yoshini, ia, tihi cabo qui ja chaniniquë, ja janacacano. Jatsi ia, yoshini, tihi cabo janacaniquë ra. Pasi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Jatsi ratëniquë joni bo. —¿Jahuë joni ni naa sa? Ja qui nicahi quiha yoshini pa. Jasca, ja qui nicahi quiha ia ri ra —i jaca ni quiha Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ia shitahax tsi quiha Gadara icanai ca mai qui Jesu cahëniquë. Toá tsi quiha dos ca noiti ca joni bo iniquë, naa yoshi jaya cabo. Nohiria maihuahacanish ca quini quima ax ja bëcaniquë, Jesu bëchaxëna. Jabi jato yoshi iqui tsi caxaxëniria naa dos ca joni bo ini quiha. Ja iqui tsi toá tsi jato bahí tsi nohiria bohoyamani quiha, raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jatsi Jesu qui quënatsi quiha jahuacaniquë: —¿Jënixo tsi noqui huënahuahai, Dios Baquë? ¿Noqui copihi mi joha rë? Jari noqui tënëtiya xaba ma xo naa ra. Tonia jari rëquë quiha —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Jabi basima tsi quiha yahua jinaya pihi ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Jatsi Jesu bënariatsi yoshi bá huaniquë toa yahua jinaya qui ja raahacacano. —Naa joni bo pi jënimahuacasquí tsi toá ca yahua jinaya qui noqui raahuë —iriatsi-jacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jatsi, —Bocata —i jato qui Jesu niquë. Tsëquëyoquë yoshi bo ra. Tsëquëhax tsi quiha yahua jinaya qui ja jicocaniquë. Jatsi jabatapitsi quiha yahua tirixëni niquë. Maca ax rënichihax ia qui ja paquëyocaniquë, jabahi na. Ja nëachiyocaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jatsi yahua jinaya obëso cabo yaca qui jabayoniquë, tsayahax na. Toa xo tsi quiha ja jiscani ca ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Jatsi quiha toa yacatá ca nohiria bëyocaniquë, Jesu ini ca qui. Jesu bëchaxo tsi quiha ja bënariacaniquë, jato mai ax ja riquino. ");
INSERT INTO caoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jatsi noti qui Jesu jicoha ca tsi ia ja shitaniquë. Shitahax tsi quiha jahuë yaca yoi qui ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yaca qui ja cahëcaquë tsi quiha ja qui toá ca nohiria bá mohiyama ca joni bëniquë, jahuë oxatí no. Jabi Jesu qui ja chitimiriacani quiha. Ja chitimicanai jisi tsi quiha mohitimaxëni ca qui Jesu chaniniquë: —Chamahuë baquë́. Masahacaquë mi jocha ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jatsi shinatsi quiha yoba cahëxëni cabá huaniquë. “Dios pasomaha chanihi quiha naa joni ra” i jamë jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jama, ja shinacanai ca jahuë bo Jesú cahëniquë. Cahëhax jato qui ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","—¿Jënica ni toa, bëroria ca yoatí? “Masahacaquë mi jocha” ¿iti ni? “Niina. Cohuë” ¿iti ni? ");
INSERT INTO caoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Jasca, nohiria ba jocha masati chama ë jaya ca ma cahëno ra —i jato qui Jesu niquë. Jatsi mohitimaxëni ca joni qui ja chaniniquë: —Niina. Mi oxati bihuë. Mi xobo qui cata —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Jatsi niitapiniquë joni. Niihax tsi quiha jahuë xobo qui ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ratëyoniquë nohiria, Jesú ani ca jisish na. Jatsi Dios oquëhuatsijahuacaniquë, Jesu qui jahuë chama-chamaria Diós ani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Riquiquiria tsi quiha gobierno xobo pistiá ca tsahohai ca joni, naa Mateo icanai ca Jesú jisniquë. Nohiria bo quima gobierno bax parata bichi Mateo ini quiha. Impuesto quiha. Jatsi, —E bëta mi jono ra —i Mateo qui Jesu niquë. Jatsi Mateo joiniquë. Joixo tsi quiha Jesu ja banahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jabi Mateo xobo xo tsi Jesu, jahuë rabëti bo, tihi cabá pihi iniquë. Ja picano tsi quiha huëstima ca gobierno bax parata bicanaibo, jochahuaxëni cabo, tihi cabo bëcaniquë, Jesu, jahuë rabëti bo, tihi cabo yaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Jatsi Jesu ya naa jochahuaxëni cabo iqui ca fariseobá jisniquë. Jisí tsi Jesu rabëti bo qui ja chanicaniquë: —¿Jëniriaxo gobierno parata bicanaibo, jochahuaxëni cabo, tihi cabo ya xo tsi pihi ni mato maestro pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jatsi Jesú quëbiniquë, jato nicaquí na: —Doctor quënayamaqui jënima cabo ra. Jama doctor quënahai ca tsi xo toa iquicanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bocahuë. Dios Chani cahëyamaqui mato ra. “Jaha ë quëëhai ca tsi xo toa ëa nohiriá noihaina, ja tëpascanai ca jahuë bo nomari” ii quiha Dios ra. Toa ma jabiti xo. Tsayacahuë. Mëstëxëni ca jaca nori ca quëscahuacanaibo quënahi ë joyamaniquë, jochahuaxëni cabo nori, Dios quiri ja bësocano iquish na —nëca tsi jodioba chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jatsi ashimanish ca Juan yamabá-na banahuacanaibo Jesu qui bëcaniquë. Bëxo tsi quiha ja nicacaniquë: —Huëstima tsi xo no samahaina ra. Jasca, samariacani quiha fariseobo ri. Jama, mi rabëti bo tsi xo toa samayamahaina pë. ¿Jënihax samayamacahi ni? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jatsi Jesú jato quëbiniquë: —Joní ahui yano tsi ¿cohuë ni bëcanish ca rabëti bo? Iyamacani quiha. Ahui yahax ca joni jato bëtano tsi ranicani quiha ra. Jascaria tsi jaboqui samayamahi quiha noho rabëti bo ri, jato bëta ë nori ca iqui na. Jama, tsëquëxëhi quiha bari huëtsa, jato quima ë mëbihacaxëquë no. Toatiyá tsi samacaxëcani quiha noho rabëti bo ri, cohuëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","‘Jasca, quësi paxá tsi raiti siri pishpayamahi quiha nohiria. Anoma quiha. Jabi quësi paxá pi ja pishpacano tsi përësixëhi quiha raiti siri. Përësihi quiha quësi paxa ri, jaha bëquiyamajahai iqui na. (Jascaria, mato arati quinia siri jaha bëquiyamahi quiha noho tiisi paxa cato. Jamëri ca xo.) ");
INSERT INTO caoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jasca, mato bichi ca sota sirixëni qui jënëria paxa ca rëhuiyamaqui mato. Anoma quiha. Ma rëhuipino tsi bichi ca sota poshaxëhi jënëria paxa cato. Jatsi japaquëxëhi quiha jënë rë. Yoshihuahacaxëhi quiha sota ri. Jama bichi ca sota paxa ca qui jënëria paxa ca rëhuihacaxëti xo. (Jascaria, anoma tsi xo arati quinia sirí tsi noho tiisi paxa ca tiisimahaina ra. Arati quinia huëtsá tsi ja tiisimahacaxëti xo. Mato arati jabi siri jaha bëquiyamahi quiha noho tiisi paxa) —nëa tsi quiha Jesu nëcaniquë jato qui. ");
INSERT INTO caoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nohiria bo qui Jesu chanino tsi quiha ja qui jodioba chama joniquë. Johax Jesu bësojó ja mëniniquë. —Rësoyaquë noho jahi rë. Johuë. Mi mëquënë́ tsi noho jahi mi motsano. Mi pi jono tsi bësoxëqui tia —nëa tsi quiha johax ca chama nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jatsi Jesu, jahuë rabëti bo, tihi cabo joiniquë, ja bëta caxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jabi ja bocano tsi quiha Jesu cho noitiria ca yoxa basimaniquë, Jesu motsaxëna. Doce año bo no tsi ja jimihacai ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jatsi yoxa shinaniquë. Shinahax, “Jahuë sahuëti pi motsahi tsi jënimaxëquia tia” i jamë ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jatsi Jesu bopinaniquë. Bopinaxo tsi quiha yoxa ja jisniquë. Jisi tsi, —Chamahuë, noho jahiní. Mi chitimihai ca iqui tsi mi jënimahuahacaquë ra —i ja qui Jesu niquë. Jënimatapiniquë yoxa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jatsi chama xobo qui jicohax tsi quiha música acanaibo Jesú jisniquë. Jahuë jahi maihuapaimaria ja icani quiha. Anomaria ja aracanai ca pacotsa ini quiha. Jatsi jato jisi tsi quiha, ");
INSERT INTO caoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—Bocahuë. Rësoyamaquë jahi pistia. Oxahi quiha —i nohiria bo qui Jesu niquë. Jatsi nohiria bá osaniquë, nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jatsi quiha cacha nohiria Jesú raaniquë. Raahax naquëtë qui ja jiconiquë. Jatsi jahi pistia mëquë ja biniquë. Joitapiniquë jahuë jahi ra. ");
INSERT INTO caoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jatsi Jesú ani ca nicayoniquë toa maí ca nohiria tëquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jato xobo Jesu jisbayaquë tsi quiha banahuatsi dos ca bëco cabá huaniquë. Banahuapama tsi ja quënacaniquë. —Noqui shinahuë ra, David yamaba Baquë́ —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Xobo qui Jesu jicoquë tsi quiha ja jicocaniquë jato ri. Jatsi Jesú jato nicaniquë: —¿Mato jënimahuati mëtsa ni ëa ra? ¿Jahuë shinacanai? —iquiina. Jatsi, —Ati mëtsa xo mia, Ibobá —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jatsi jato bëro bo Jesú motsaniquë. Motsapama tsi, —Ma chitimihai iqui tsi ocapixëhi quiha ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jatsi quiha ja taistëquëcaniquë. Jënima jato bëro ini quiha. Jatsi Jesú jato yoba-yobaniquë: —Mato ë jënimahuaha ca yoayamacahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jama, jisbaya tsi quiha Jesú ani yoati ja yoabonacaniquë toa mai tëquë xo na. ");
INSERT INTO caoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Bëco inish ca joni bo bocaquë tsi quiha Jesu qui chanitimaxëni ca joni nohiria bá bëniquë. Joni jaro quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jahuë yoshi Jesú tsëcaquë tsi chanitapitsi quiha joni niquë. Jatsi ratëyoniquë nohiria tëquë. —Anomaria tsi xo naa joní acaina ra. Noqui xërëquë ca nëca ca jahuë bo no jisyama-pistiarianiquë ra —i nohiria bo ni quiha Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jama, —Yoshini chamá tsi yoshi bo tsëcahi quiha naa joni pë. Yoshi tsi xo toa ja qui chama acaina ra —i jodioba chama bo niquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jabi yaca pistia bo, yaca-yacaria bo, tihi cabo qui Jesu shishoniquë, jato catiti xobo xo tsi tiisimahaina. “Nohiria bo otocatsi quiha Dios ra” i ja niquë Chani jia ca yoabonahi na. Jasca, noitiria cabo, iquicanaibo, tihi cabo ja jënimahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jasca, nohiria huëstima ca tsayapama tsi quiha Jesu cohuënaniquë, noitiria ja icani iqui na, naa jahabëso yama ca oveja jascaria. Ja shina-huëjënacanai ca ja cahëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jatsi quiha jahuë rabëti bo qui ja chaniniquë: —Huëstima ca tsi xo toa tësahacati cato ra; jama, ichariama ca tësacanaibo nori. ");
INSERT INTO caoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Japi tësati Ibo qui bëhoxcana ra, yonati bo ja raano iquish na, tësati —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jatsi jahuë doce ca rabëti bo Jesú quënaniquë. Quënaxo tsi quiha jato qui chama ja aniquë nohiria quima yoshi bo tsëcati. Jasca, chama jato qui ja aniquë iquicanaibo, isicanaibo, noitiria cabo, tihi cabo jënimahuati. ");
INSERT INTO caoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jabi doce ca joni bo quiha Jesú biniquë raaxëna. Jato janë bo tsi xo naa: Jariapari tsi xo Simón, naa Pedro quënahacanish cato. Jaquirëquë, Simón noma Andrés. Jaquirëquë, Zebedeo baquë Jacobo. Jaquirëquë, Jacobo noma Juan. ");
INSERT INTO caoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Jaquirëquë Felipe, Bartolomé, Tomás, Mateo, naa gobierno bax impuesto binish cato. Jaquirëquë Alfeo baquë Jacobo, Tadeo, ");
INSERT INTO caoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, naa gobierno pasomaha inish cato. Jatsi Judas Iscariote, naa soldado bo qui Jesu mëanish cato. ");
INSERT INTO caoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Naa doce ca rabëti bo Jesú raaniquë Dios Chani ja yoacano. Raaquí tsi quiha jato ja yobaniquë. Ja nëcaniquë: —Carayanaba mai, samaria caba yaca bo, tihi cabo qui boyamacana Dios Chani yoati. ");
INSERT INTO caoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jama, Israél ca nohiria bo qui roha bocahuë. Bënohax ca oveja bo jascaria ca xo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Capama tsi “Basima tsi xo Diós otohaina ra” itsicana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jasca, iquicanaibo jënimahuacana. Bësoyama cabo bësomacana. Leproso bo bahuëcana. Yoshi bo tsëcacana. Jabi copixoma tsi noho chama ma bichi iqui tsi parata biyamacana nohiria mëbiquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","‘Caquí tsi parata boyamacana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Jasca, rabë sahuëti, zapato bo, coti jihui, tihi cabo boyamacana. Jabi mato orihuaxëhi quiha mëbihacahax cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","‘Jabi yaca-yacaria, yaca pistia, tihi cabo qui cahëxo tsi toa xo tsi shinajiaxëni ca joni mëracana. Mërahax jahuë xobo roha tsi chitëcana. Xobo huëtsa qui boyamacana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jahuë xobo qui jicoquí tsi jia tsi jato joihuacana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jia pi toá ca nohiria bá mato joihuano tsi jato bax bëhoxcana, Diós jato shomahuano iquish na. Jama, mato pi ja joihuayamano tsi jato shomahuayamacana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jasca pi xobó ca nohiria bá mato joihuacas-yamano tsi jato jisbayacana. Jasca pi yacatá ca nohiria bá mato qui nicacasyamano tsi jato jisbayacana. Jisbaya tsi mato tahë ca cospo toj-tojhacahuë jato jocha jismaxëna. Toca tsi jato qui Dios caxa ma jismaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mato parayamaquia iquia. Anomariaxëhi quiha toa nohiria bá tënëhaina ra nohiria bo copiti barí no. Sodomá ca racanish ca nohiria bo oquë ixëti quiha. Gomorrá ca racanish ca nohiria bo oquëxëhi quiha ja tënëcanaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","‘Jaha bësocapa. Caxaxëniria ca lobo jascaria ca nohiria bo qui mato raaquia. Jato xërëquë ca oveja jascaria ixëqui mato. Japi quiniacaxëcahuë, naa rono ma quiniahai jascaria. Jato xërëquëpama tsi ishima ca boto jascariacana. ");
INSERT INTO caoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Jasca, mato pasomaha ca nohiria bo qui quiniacaxëcahuë. Chama bo qui mato mëacaxëcani quiha quësoxëna. Jasca, jato arati xobó tsi rashahacaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ea tahëxo tsi prefecto bo, chama-chamaria bo, tihi cabo qui mato bëcaxëcani quiha, naa mato jimibo. Jatsi xaba jayaxëqui mato ra, jato qui chaniti ëa yoati na. Jatsi Dios Chani nicacaxëcani quiha carayanabo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Jabi chama bo qui mato jimibá pi mato mëano tsi ma yoati ca yoaxëti ca yoati tsi shina-huëjënayamacana. Toa xaba tsëquëno tsi mato qui acacaxëhi quiha ma yoaxëti cato. ");
INSERT INTO caoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Toatiyá tsi ma chanino tsi ma yoaxëti ca mato jismaxëhi quiha Espíritu Santo. Chaniyamayoixëqui mato, Espíritu Santo ja nori. ");
INSERT INTO caoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","‘Toatiyá tsi jabë xatë yoi mëaxëhi quiha huëtsa, namëhacati. Jahuë baquë pasomahaxëhi quiha jahëpa ri. Jasca, jato nabo qui caxacaxëcani quiha xocobo ri. Caxaquí tsi chama bo qui jato nabo mëacaxëcani quiha rë, ja namëhacacano. ");
INSERT INTO caoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ea tahëhax tsi mato qui caxayocaxëcani quiha nohiria tëquë. Jama, xabahamahacaxëhi quiha jatiroha ca jahuë rëso qui tënë-tënëcanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jatsi huësti ca yacatá ca nohiria bá pi mato tënëmano tsi yaca huëtsa qui jabacana. Jabi bacaxëquia ra, jodioba maí ca yacata tëquë noho Chani ma yoanox pari no. ");
INSERT INTO caoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","‘Jabi jahuë maestro oquë ma xo jahuë alumno bo. Jasca, jahuë chama oquë ma xo yonati. ");
INSERT INTO caoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jabi jato maestro pi nohiria bá tënëmano tsi tënëmahacaxëhi quiha jahuë alumno bo ri iquia. ¿Jabi mato maestro ma ni ëa ra? “Satanás” pi ëa nohiria bá quënano tsi oquë ca yoixëni ca janë mato quënacaxëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Japi mato roacanaibo qui raquëyamacana. Bërohuahacaxëhi quiha noho Chani ra. Nicaxëhi quiha nohiria bo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Jaboqui mato qui baxëxquia quiniahi na. Jama, huëaquë tsi mato ë yoaha ca yoacaxëcahuë huënënë xo na, raquëxoma. ");
INSERT INTO caoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Jasca, mato acascanaibo qui raquëyamacana. Mato yora bo roha ati mëtsa ca xo, mato shina ati mëtsa jaca nomari. Jama, Dios qui nohiria raquëxëti xo. Ja tsi xo toa tënëtiya qui nohiria raati ibo-iboria, naa yora, shinana, tihi cabo quëyoti mëtsa cato. ");
INSERT INTO caoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Jabi mato ó bësohi quiha Dios ra. Jatiroha ca cahëhi quiha. Huësti ca copiriama ca chorobo pi mai qui paquëno tsi ¿cahëyama-yamahi ni mato Jahëpa ra? ");
INSERT INTO caoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Jasca, mato boo tëquë cahëhi quiha ra. Ja tocahacayocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Japi raquëyamacana. Dios qui copixëni xo mato ra; naa huëstima ca chorobo oquë quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","‘Nohiria bo bësojó pi “Cristó-na xo ëa” i nohiria no tsi noho naipá ca Jahëpa bësojó tsi “Nohó-na xo toa” ixëquia ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jama, nohiria bo bësojó pi ëa pasomaha nohiria chanino tsi noho naipá ca Jahëpa qui “Nohó-na ma xo toa” ixëquia ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","‘¿Jahuë qui tsi mai qui ë joni? ¿Jia tsi nohiria racanabëquimahi ë joni pa? Tocati ë joyamaniquë. Nohiria oquëxnamahi ë joquë ra, jia tsi jato racanabëquimahi nomari. Oquëxnamahai ca saipi jascaria tsi xo toa ë bëhai ca chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Joquë ëa ra, jahuë jahëpa pasomaha baquë janaxëna, jahuë jahëhua pasomaha jahi janaxëna. (Joquë ëa ra, jahuë raisi pasomaha raisi janaxëna.) ");
INSERT INTO caoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ea tahëhax tsi mato qui caxa-caxariaxëhi quiha mato xobó ca yoi bo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","‘Ea oquë pi jahuë jahëpa, jahuë jahëhua, tihi cabo noihi tsi nohó-natimaxëni ca xo toa nohiria ra. Jasca, jahuë baquë bo, jahuë jahi bo, tihi cabo pi oquë tsi noihi tsi nohó-natimaxëni ca xo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Mato cruz yoi pi iayamahi tsi ëa pi banahuayamahi tsi noho rabëti iti mëtsama xo mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Jabi jahuë shina bënoxëhi quiha jahuë shina xabahamacatsai cato. Jasca, jahuë shina bëboxëhi quiha ëa iqui tsi jahuë shina bënohai cato. ");
INSERT INTO caoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","‘Jabi ëa yoi joihuahi quiha mato joihuahai cato. Jasca, ëa pi joihuaquí Dios yoi, naa ëa raanish ca joihuahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Dios Chani bëhai ca ma joihuano tsi jia tsi mato copixëhi quiha Dios, Dios Chani bëhai ca ja nori iqui na. Jato copi jascaria ca bixëqui mato iquia. Jasca pi shina jiaxëni cabo joihuahi tsi jia tsi copihacaxëqui mato ra. Jato copi jascaria copihacaxëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ea tahëxo tsi noho rabëti bo pistia roha tsi ma mëbino tsi mato copixëhi quiha Dios iquia —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jatsi quiha Jesú jisbayaniquë jahuë doce ca rabëti bo yobaxo na. Jisbaya tsi quiha toa maí ca yaca bo xo tsi ja tiisimaniquë. Dios Chani ja yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jabi toatiyá tsi quiha presó Juan yamabo iniquë. Preso xo tsi Cristó acai ca jahuë bo ja nicaniquë. Nicaxo tsi quiha jahuë rabëti bo huësti huësti ca Jesu qui ja raaniquë, Xabahamati Ibo Jesu iqui ca nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jatsi Jesu ja nicacaniquë: —“Joxëti xo Xabahamati Ibo” i noquii quiha Juan ra. ¿Toa ni mia sa? ¿Joni huëtsa ó pasoxëhi ni noa sa? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jatsi Jesú jato quëbiniquë: —Jahari bocata. Ma tsayahana, ma nicahana, tihi cabo Juan yoacata. ");
INSERT INTO caoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Taiscani quiha bëco cabo. Tapicani quiha huico choni jaya cabo. Jënimahuahacahi quiha leproso cabo, naa bonohuaxëni cabo. Pasohi quiha pasoyamacanaibo. Bësotëquëcani quiha bësoyama cabo. Xabahamati Chani nicacani quiha noitiria cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Rani-ranicani quiha ëa chahahuacanaibo ra. Tihi ca tsi yoata —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Nicahax tsi quiha jahari Juan qui ja bocaniquë. Jaquirëquë nohiria bo qui Jesu chaniniquë Juan yoati na. —¿Jahuë ó ma pasoni jisxëna, xabachá ca Juan qui boquí na? ¿Cahëtimaxëni ca chamayama ca joni ó ma pasoni pa? ");
INSERT INTO caoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Jahuë jisi ma bocani? ¿Copixëni ca raiti sahuë ca joni jisti ó ma pasoni pa? Toca tsi ja iyamani quiha. Jabi xobo-xoboriá tsi racacani quiha copixëni ca sahuëti jaya cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Japa? ¿Jahuë ó ma pasoni jisxëna? Ea yoacahuë. ¿Dios Chani yoati ibo ó ma pasoni pa? Mato parayamaquia. Dios Chani yoati ibo oquë ca ma jisyamëquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Jabi Juan yoati tsi Dios chaniniquë Quënëhacanish cabo ó no. Nëcahi quiha: “Mia bëbo noho Chani bohai ca raaxëquia. Jariapari mi quinia rohahuaxëhi quiha” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","‘Mato parayamaquia ra. Yama tsi xo nohiria xërëquë tsi Juan oquë ca bësohax cato ra. Jama, Juan oquë ca tsi xo toa Diós otohai cato ó ca iriama cato ra —nëa tsi Jesu nëcaniquë Juan yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","‘Jabi jahuë yonoco ati Juan chitahëhuaquë rohari tsi jahuë chani qui caxa xo huëstima cabo. Jaboqui jasca pi xo rë. Ibo Diós nohiria bo otohai ca quinia quëyocascani quiha pë. Anomaria tsi xo toa ja acanaina. ");
INSERT INTO caoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jabi siri tsi Dios Chani yoahi Juan jonox pari no tsi Quënëhacanish cabá chani-chanipaoniquë Ibo johai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","“Joxëhi quiha Elías” i jaca paoni quiha. Jabi Juan tsi xo toa joxëhai ca Elías iquia. ¿Ja quënëcani ca chahahuacanai? ");
INSERT INTO caoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Nicati pi mëtsaquí tsi nicacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","‘¿Jënixëhi ni ëa pë, naa jaboqui bësocanai ca nohiria yoati na? Plazá ca chotëxëni ca xocobo jascaria ca xo rë. I-iquí tsi nëca tsi quënacaqui: ");
INSERT INTO caoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Mato bax pi bisto no ino tsi pabëcasyama xo mato pë. Jasca, mato bax pi no nahuarino tsi aracasyama xo mato pë” iquiina. Jabi naa chotëxëni ca xocobo jascaria tsi xo naa nohiria bo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jabi Juan joquë tsi mato qui yoi quiha jahuë jabi iniquë pë. Johax ja samaniquë. Jënë ja ariayamaniquë. Tocajaquë tsi “Yoyoxëni tsi xo naa joni ra” iyoniquë nohiria tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jatsi ë joquë, naa Nohiria Baquë ë nori cato. Ea ti tsi xo oriquihaina. Jasca ëa ti tsi xo toa jënë acaina. Tocahëno tsi ë qui yosacaqui pë. “Oriquitinaxëni, pahëxëni ca tsi xo toa” icaqui. “Tsayacapa, impuesto bicanaibo, jochacanaibo, tihi cabo ya rabënahi quiha pë” ii quiha jatiroha cabo ëa yoati na. Jabi mato qui yoi tsi xo noho jabi, ë acaina, tihi cabo. Jasca, mato qui yoi ini quiha Juan jabi jaa ri pë. Jama, tiisiyoi-canaibo qui jia tsi xo noba jabi bo, no acaina ra —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jatsi yaca bo, naa ja ani ca jisti bo jisnish cabo raahatsi quiha Jesú huaniquë. Jato ja raahani quiha jato jocha quima Dios quiri ja bësoyamacani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ja nëcaniquë: —Noitiriaxëhi quiha mato Corazín cabá. Noitiriaxëhi quiha mato ri Betsaidá cabá. Mato yaca bo xo tsi huëstima ca jisti bo acacani quiha; mahitsa rë. Jabi jochahuaxëni ca Tiro y Sidón yaca bo xo pi jasca ca jisti bo acacarohano tsi naama tsi jato jocha quima Dios quiri ja bësoquë acani quiha. Bamaxoma tsi moro ja sahuëquë acani quiha cohuëquí na. Jasca, chihi mishpó tsi ja tsahoquë acani quiha jato cohuë jismaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Jabi copiti barí tsi anomariaxëhi quiha mato copi ra; naa Tiro, Sidón, tihi cabo yacatá ca jochahuaxëni ca nohiria oquë nori. ");
INSERT INTO caoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","¿Japa mato Capernaum yacatá cabá? ¿Nai qui bocascanai pa? ¡Maj! Tënëtiya qui botëxëqui mato ra. Mato yacata ax tsi huëstima ca jisti bo acacaniquë ra; mahitsa rë. Jabi jochahuaxëni ca Sodoma xo pi jasca ca jisti bo acacarohano tsi ja chahahuaquë acaniquë ra. Jato yaca potas-hacayamaquë ani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Japi shinacahuë. Copiti barí tsi anomariaxëhi quiha mato copi ra. Jochahuaxëni ca Sodoma oquë ixëti quiha —nëa tsi Jesu nëcaniquë toa yaca bo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Naatiyá tsi bëhoxpama tsi Jesu nëcaniquë: —Mi qui “Gracias” iquia noho Jahëpá, cahëyamacanaibo qui mi chani jia ca mi jismaha quëshpi na. Maí ca tiisi jaya cabo, cahëxëni cabo, tihi cabo cahëmayamaqui mia ra. Jato joma quiha. Ja quëshpi tsi “Gracias” iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jabija, tocahi tsi raniqui mia, noho Jahëpá —i Jahëpa quiina. ");
INSERT INTO caoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jatsi, —Chama ë qui noho Jahëpá aniquë ra jahuë bo tëquë yonati. Jabi yama tsi xo toa ëa, naa Dios Baquë-baquëria ca cahëyoihai cato. Noho Jahëpa roha tsi xo toa ëa cahëyoihai cato iquia. Jasca, yama tsi xo toa Jahëpa Dios cahëxëni cato. Jahëpa Dios cahëxëni ca roha ca ëa xo naa, naa jahuë baquë. Jasca, Jahëpa Dios cahëcani quiha chahahuacanaibo ri. Jato qui noho Jahëpa jisiquimaquia, ja cahëcano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","E qui bëyocana mato joicanaibá. E qui bëcana, ihuë ca jabi papicanaibá. Mato joimaxëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ihuë yama tsi xo toa mato qui ë acatsai ca yugo, naa noho yoba. Bicana. Mato ë tiisimano. Ea ti tsi xo ishima. Ea ti tsi xo caxayama. Noho yugo pi bichi tsi joixëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bëro tsi xo noho yugo papihaina. Ihuë yama tsi xo toa mato qui ë acai ca yoba ra —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jaquirëquë trigo huai tsi nacohi quiha Jesu iniquë jahuë rabëti bo ya. Joiti bari ja ini quiha. Jabi paxnaquí tsi quiha jahuë rabëti bá trigo bimi risaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Jatsi ja acani ca jodiobo chama bá jisniquë, naa fariseobo icanish cabo. Jisi tsi Jesu qui ja quësocaniquë: —Tsayapa. Joiti barí tsi anoma ca acani quiha mi rabëti bo ra. Yonococani quiha pë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jatsi Jesú jato quëbiniquë: —¿Quënëhacanish cabo ó ca noba David yamabá ani ca ma tsayayamayamani, naa jahuë joni bo ya paxnaquí na? ");
INSERT INTO caoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Dios xobo ja jiconi quiha ra jahuë joni bo ya, arati ibo ba mapari bixëna. Toa xo tsi Dios qui aquëquëmani ca mapari ja pini quiha. Jasca, pini quiha jahuë joni bo ri. Roa toa ja acani ini quiha. Pinoma quiha. Arati ibo ba piti ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jasca, ¿Moisés quënëni ca ma tsayayamayamani? Jatiroha ca joiti barí tsi yonocohi quiha arati ibo bo ra. Jënima tsi xo toa joiti barí tsi ja yonococanaina ra. Yonocojacano tsi jato qui quësoyamaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Jama, ë qui tsi xo toa ma quësocanaina rë. Jaha quiniacaxëcahuë. Mato xërëquë tsi xo toa mato arati xobo, mato yoba, tihi cabo oquë cato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Quënëhacanish cabo pi cahërohahi tsi ë qui, naa anoma ca ayamahai ca qui ma quësoyamaquë aquë ra. “E qui oquë-oquëria tsi xo toa ëa ma noihaina ra, naa ë qui ma acai ca jaca nomari” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Jasca, joiti bari ibo-iboria ca ëa xo naa ra, naa Nohiria Baquë ë nori cato —nëa tsi jodiobo chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jodiobo chama bo Jesú jisbayaniquë. Jisbaya tsi quiha jodioba catiti xobo qui ja jiconiquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jabi toá tsi quiha mëquë choni jayanish ca joni ini quiha. Toá tsi ini quiha Jesu qui quësocascanai ca joni bo ri. Jatsi Jesu ja nicacaniquë: —¿Jënima ni joiti barí tsi jënimahuahaina? ¿Noba yoba pasomaha ma ni? —iquiina, ja qui quësocatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jatsi nëca tsi Jesú jato quëbiniquë: —Joiti barí pi maiquini qui mato oveja huësti ca paquërohano tsi ¿ma tsëcayamaquë ana? ");
INSERT INTO caoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Jabi oveja oquë ma ni nohiria ra? Japi jënima tsi xo joiti barí tsi jia ca acaina iquia —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jatsi noitiria ca joni qui Jesu chaniniquë: —Mi mëquë yoi mëtahuë —iquiina. Jatsi jahuë mëquë yoi ja mëtaniquë. Jënimatapiniquë jahuë mëquënë ra; jahuë mëquë huëtsa jascaria iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jatsi jodiobo chama bá jisbayaniquë caxahi na. Joiti barí tsi ja jënimahuani iqui tsi Jesu ja namëcascani quiha. Jabi toca tsi quiha ja shina-shinacaniquë pë, namëti quinia mërahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jabi ja namëcascanai ca Jesú nicaniquë. Nicaxo ja jisbayaniquë. Jatsi huëstima ca nohiriá banahuaniquë. Jatsi bëcanish ca iquicanaibo tëquë ja jënimahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jënimahuaxo tsi quiha jato ja yobaniquë tsohuë ca ja iqui ca yoayamati. ");
INSERT INTO caoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jabi ja ani cató tsi quiha Isaías yamabá quënëni ca jatihuahacani quiha. Jabi nëca tsi quiha Dios chaniniquë jahuë Baquë yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Noho yonati tsi xo naa ra. E biniquë noho yonoco ja ano. E noihai ca tsi xo naa. Ja qui raniquia. Noho shina ja qui axëquia. Jatiroha ca nohiria bo ó bësoxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jasca, johax iquinayamaxëhi quiha. Joi mërayamaxëhi quiha. Jahuë joi choshayamaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Noitiria cabo roayamaxëhi quiha. Jaha pasocanaibo ranihuaxëhi quiha. Ja pasomaha cabo bëboxëhi quiha, Dios mëstëxëni ca yoba nohiria bá cahëno iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Jasca, ja qui chitimicaxëcani quiha maí ca nohiria bo tëquë” i Dios ni quiha ja quënëni cató no. ");
INSERT INTO caoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jatsi Jesu qui noiti ca joni nohiria bá bëniquë ja jënimahuahacano. Bëco ca joni quiha. Jasca, jaro ja ini quiha, yoshi ja jayani iqui na. Jabi naa joni Jesú jënimahuaniquë. Jaquirëquë chaniti mëtsa joni iniquë. Jasca, ja taisniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jatsi ratëyoniquë nohiria tsayahax na. —¿Johai ca Xabahamati Ibo, naa David yamaba chahitaxocobo ma ni naa joni sa? —i jaca niquë ja ani ca tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Toca tsi nohiria chanicanai ca nicaxo fariseobá quëbiniquë, naa jodioba chama bo: —Ja qui Satanás chama aquë ra. Ja tsi xo toa yoshi tsëcati chama jaya xo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jama, ja shinacanai ca Jesú cahëniquë. Cahëhax chama bo qui ja chaniniquë: —Quëyohacaxëhi quiha país ca nohiria bo, ja nianacaquë no. Jasca, quëyohacaxëhi quiha xobó ca nohiria bo, yacatá ca nohiria bo, ja iquinacaquë no. Yonocobëquinatimaxëni ca xo. ");
INSERT INTO caoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jasca, Satanás-na maxo pasomaha pi Satanás maxo huëtsa iquinano tsi ¿jënahuariahax jahuë chama naamana? ");
INSERT INTO caoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Jasca, ¿Satanás chamá tsi jahuë yoshi bo natsëcahi ni ëa pa? Jabi Satanás ëa mëbipino tsi ¿tsohuë ni toa mato banahuacanaibo qui chama acax cato, yoshi bo natsëcati? Jabi yoshi bo natsëcani quiha mato banahuacanaibo ri. Mato banahuacanaibá acai cató tsi noqui bëro xo janyama ca ma shinahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yoshi bo natsëcati chama ë qui acax ca tsi xo Dios Shinana. Ja tsi xo toa ëa mëbihaina. Jaha tsi ë acai cató tsi bëroria tsi xo toa mato qui Diós yonati chama jaya cato ra. Joquë Cristo, naa nohiria bo Xabahamati Ibo iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","‘¿Jënahuariahax raca joni chamaxëni cato xobo qui joni jicona yomaxëna? ¿Jariaparí tsi chamaxëni ca joni nëxayamayamaxëhi ni? Nëxaxo jahuë jahuë bo yomati mëtsa xo. Jascaria, jahuë yoshi bo niahacanox pari no tsi nëxahacaxëti xo Satanás ri. ");
INSERT INTO caoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","‘Jabi ëa pasomaha yoi tsi xo toa ë bëtama cato. Jasca, Dios yonoco yoshihuahi quiha ëa mëbiyamahai cato. ");
INSERT INTO caoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Jasca, jatiroha ca jocha, jatiroha ca chani yoi cato, tihi cabo masaxëhi quiha Dios. Jama, Espíritu Santo pasomaha pi nohiria chanino tsi jahuë jocha masayamaxëhi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Jabi ëa pasomaha pi nohiria chanino tsi iriama tsi xo toa. Jahuë jocha masaxëhi quiha Dios. Jama, Espíritu Santo pasomaha pi nohiria chanino tsi jahuë jocha masayamaxëhi quiha Dios. Masahaca-timaxëni ca jocha tsi xo toa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","‘Jabi jahuë bimi iqui tsi jihui cahëqui noa. Jahuë bimi tsayaqui noa. Jatsi bimi jia ca saihuahi quiha jihui jia cato. Jama, jihui yoi tsi xo toa pinoma ca bimi saihuahaina. Yoi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Jisa rono ba xocobá. ¿Jënahuariahax jia ca ma chanina, yoixëni cabo imaquë no. Yoixëni ca jahuë bo pi nohiria bá shinano tsi anomaxëhi quiha toa ja chanicanai ri. ");
INSERT INTO caoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jascaria, jahuë chani jia cató tsi bërohuahacaxëhi quiha shina jia cato. Jasca, yoi ca saihuahi quiha joni yoixëni cato, naa jihui jascaria. Jahuë jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jabi huëstima tsi xo mahitsa ca chani rë. Jasca, jaroha ca barí tsi copihacaxëti quiha nohiria jato chani yoi ca tëquë quëshpi na iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Toa barí tsi mato chaní tsi copihacaxëqui mato. Jatsi paquëmahacaxëhi quiha chani jia ca chanihai cato. Jama, tënëmahacaxëhi quiha chani yoi ca chanihai cato ra —nëa tsi chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jatsi Moisés yoba cahëxëni cabo, fariseobo, naa jodioba chama bo, tihi cabo chaniniquë Jesu qui. Ja nëcacaniquë: —Jisti mi ano, maestró. Jisti jiscasqui noa —iquiina, jahuë chama jiscastsi na. ");
INSERT INTO caoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jatsi Jesú quëbiniquë: —Anomaria tsi xo jaboqui bësocanaibo rë. Jisti ó quëëmisxëniria tsi xo naa Dios qui chitimiyamacanaibo ra. Jatsi Jonás jisti roha jato qui acacaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jabi tres barihani, tres baquicha, tihi cabo tsi Jonás raaniquë sani chahita jatoquë́ no. Jascaria tsi tres barihani, tres baquicha, tihi cabo raaxëquia ëa ri mai xará no. ");
INSERT INTO caoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jatsi quiniacaxëcahuë. Copiti bari-baririá tsi niixëhi quiha Ninivé ca nohiria bo mato qui quësoxëna. Jato qui Dios Chani Jonás yoaquë tsi quiha jato jocha quima Dios quiri ja bësocani quiha, nicahax na. Jama, jaboqui nëá xo Jonás yamabo oquë cato. Jaha chahahuacas-yamaqui mato pë. Ja tsi xo toa mato qui quësocaxëcani quiha Ninivé ca nohiria bo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jasca, copiti bari-baririá tsi mato qui quësoxëhi quiha yoxa chama ri, naa Saba mai ax jonish cato. ¿Nëama ax ja joyamayamani Salomón yamaba tiisi nicaxëna? Jama, jaboqui nëá xo Salomón yamabo oquë cato. Ja qui nicacasyamaqui mato pë. Ja tsi xo toa mato qui quësoxëhi quiha toa yoxa chama ri —nëa tsi chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—Jabi joni quima tsëquëhax tsi quiha xabachá tsi co-cohi quiha yoshini, iti huëtsa mërahi na. Joicatsi quiha. Mahitsa mërahax, ");
INSERT INTO caoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“E jisbëriani ca xobo qui jahari caquia ra” i jamë i quiha. Jatsi quiha jahari cahi quiha. Cahax jahuë iti siri jisi quiha. Jaboqui jënima quiha, bahuëhaca xobo jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jatsi cahi quiha jabë yoshi bo mërahi na. Mëraxo tsi siete ca yoshi oquë ca bëhi quiha ja bëtati. Jatsi pë ja bëta joni qui jicocani quiha yoshi huëtsa bo ri, racaxëna. Japi noiti-noitiria xo toa joni ra. Ja iqui tsi jaboqui oquë tsi xo toa joni yoyo rë. Jabi naa joni jascariaxëhi quiha jaboqui bësocanai ca yoixëni cabo ri. Oquëriaxëhi quiha ma noitihaina ra —nëa tsi quiha Jesu nëcaniquë toá ca nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jari nohiria bo qui chanihi quiha Jesu iniquë, jahuë jahëhua, jabë xatë bo, tihi cabo xobo qui cahëquë no. Cahëhax tsi quiha xobo cacha ja niicaniquë. Niihax, —Jesu ya chanicasqui noa —i jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jatsi, —Cacha tsi xo mi jahëhua, mibë xatë bo. Toá tsi niicani quiha. Mi bëta chanicascani quiha ra —i huësti ca nohiria niquë Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jatsi quiha, —¿Tsohuë ni toa noho jahëhua yoi ra? ¿Tsohuë ni toa ëbë xatë yoi bo ra? —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jatsi quiha jahuë rabëti bo qui ja mëtoniquë. —Tsayapa. Nëá xo noho jahëhua yoi. Nëá xo ëbë xatë bo. ");
INSERT INTO caoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Jabi noho noma yoi, noho yoxa ca yoi, noho jahëhua yoi tsi xo toa noho naipá ca Jahëpa ó quëëhai ca acai cato ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Toa barí roha tsi quiha xobo Jesú jisbayaniquë. Jisbaya tsi quiha ia qui ja caniquë. Caxo tsi quiha toa xo tsi nohiria ja tiisimaniquë tsahoxo na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jatsi quiha ja qui nohiria quëtsoniquë. Anomaria ca nohiria ini quiha. Huëstima ca iqui tsi noti qui Jesu jiconiquë. Jatsi noti xo jato ja tiisimani quiha, tsahoxo na. Mai quëmapó tsi mani ini quiha nohiria tëxë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Jatsi huëstima ca jahuë bo jato ja yoaniquë chaniquí na. Bëroria ca chani quiha. Ja nëcaniquë: —Bëro sayahi huësti ca joni caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Jahuë huai sayajahuano tsi huësti huësti ca bëro bahi tapaí xapaquëniquë. Jahá ca bëro isa bá pini quiha joxo na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Jatsi bëro huëtsa maxax mai qui xapaquëniquë, naa iriama ca mai cató no. Toá tsi quiha bëro shinahatapiniquë, oti yama pi mai ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bari tsëquëquë tsi quiha ja mëshahaca-caniquë. Tapo mishni quiha. Ja iqui tsi ja chonicaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Jatsi huësti huësti ca bëro masa xërëquë xapaquëniquë rë. Bëro ya tsi quiha shinahabëquiniquë masara. Jatsi banahaca ca jocohai ca ja mapaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Jama, bëro huëtsa quiha mai jiaxëni ca qui xapaquëniquë. Bimi ja saihuacaniquë. Cien ca bëro huësti ca maxó saihuaniquë. Maxo huëtsa setenta. Maxo huëtsa treinta —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jatsi, —Ea nicaxëti xo jatiroha cabo ra —i Jesu niquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jatsi Jesu qui jahuë rabëti bo bëcaniquë. —¿Jënixo tsi toca ca chani noqui yoahai sa? Mi chani cahëyamaqui noa rë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jatsi Jesú jato quëbiniquë: —Mato qui acacaniquë Dios jonë ca tiisi ra, naa Diós otohai ca jahuë bo yoati na. Jama, naa chani cahëyamahi quiha nohiria tëxë. Jato qui jonë quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Japi jia pi ë qui ma nicano tsi anixëhi quiha ma bichi ca tiisi. Cahëyoixëqui mato ra. Jama, naa ma bichi ca tiisi pistia ca bënoxëqui mato, nicariayama-piquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ja tsi xo toa nëca ca chani nohiria bo qui chaniquia, nicaxo ja cahëyamacano. ");
INSERT INTO caoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Toca tsi jatihuahacaxëhi quiha Isaías yamabá quënënina jato yoati na. Jabi ja yoani ca tsi xo naa: “Cahëyamapistiariacaxëcani quiha, nicaxo na. Jasca, tsaya-tsayapama tsi jabija ca jisyamacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Quëstoria tsi xo naa nohiria ba shinana. Nicacasyamacani quiha pë. Bëpëquëyamacani quiha ra. Ja tsi xo toa jabija ca jisyamacaxëcani quiha rë. Ja tsi xo toa nicayoiyamacaxëcani quiha rë. ¿Jënahuariahax ë qui ri ja bësocana, jënimahuahacaxëna?” i Isaías yamabo ni quiha jato yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","‘Jama, shoma xo mato ra. Tsaya-tsayapama tsi jabija ca jisqui mato ra. Jasca jia tsi jabija ca jahuë bo nicahi quiha mato pahoqui. ");
INSERT INTO caoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jatsi ma shina-bënoyamano ra. Jabi ëa ma jisquë. Jasca, noho chani ma nicaquë. Jabi ma jisi ca jisti bo, naa ë acai ca jisti bo ó quëëni quiha huëstima ca Dios Chani yoanish cabo jisxëna. Jasca, ma nicaha ca chani nicati ó ja quëëcani quiha, nicati mëtsama jaca nori —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—Ea nicacana. Jaboqui yoaha ca chani bërohuaxëquia, naa bëro sayanish ca chani yoati na. Ma cahëyoino. ");
INSERT INTO caoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Toa bahi tapaí ca bëro jascaria tsi xo toa Ibo Dios Chani cahëyamacanaibo, nicaxo na. Ja nicacano tsi quiha johi quiha Satanás. Joxo tsi quiha jato shina ó banaha ca Chani mëbihi quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Jasca, maxax qui sayaha ca bëro jascaria tsi xo nohiria huëtsa. Ranixo tsi Dios Chani biriacani quiha, nicaxo na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Jama, naamayamahi quiha ja chahahuacanaina rë, tapo yama ca jascaria jaca nori iqui na. Dios Chani pi iqui tsi tënëhi tsi jahari bësotapi-cani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Jatsi masa xërëquë sayaha ca bëro jascaria tsi xo nohiria huëtsa. Dios Chani nicacani quiha jato ri; jama, Dios quima jato ninihi quiha maí ca jahuë bo, naa jaha ja quëëcanaina. Maí ca jahuë bo shinacani quiha pë. Jatsi Dios Chani, naa sayaha ca bëro tsiihaqui quiha parata ó ja quëëcanaina ra. Jasca, tsiihaqui quiha jato ranihuahai ca jahuë bo rë. Ja quëshpi tsi jato shina ó tsi anitimaxëni tsi xo Dios Chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jama, mai jiaxëni cato ó ca sayahaca ca bëro jascaria tsi xo nohiria huëtsa, naa Dios Chani nicacanaibo. Nicaxo tsi Dios Chani cahëcani quiha ra. Dios bax saihuacani quiha. Huësti ca maxo tsi xo cien ca saihuahaina. Maxo huëtsa tsi xo setenta ca saihuahaina. Maxo huëtsa tsi xo treinta ra —nëa tsi Jesu nëcaniquë, jahuë chani bërohuahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jatsi chani huëtsa jahuë rabëti bo qui Jesú aniquë, naa Diós nohiria copixëhai yoati na. Ja nëcaniquë: —Bëro jia ca jahuë huaí tsi joní sayahai ca jascaria tsi xo Diós otohaina. ");
INSERT INTO caoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jama, ibo oxano tsi baquichá johi quiha ibo qui caxahai cato. Joxo tsi bëro yoi sayahi quiha iboba huaí no pë. Masara ca bëro quiha. Jahuë trigo naxërëquë tsi quiha toa bëro sayahi quiha pë. Sayahax jabahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jatsi quiha shinahaniquë trigo. Bimijaquë tsi quiha jisiquiniquë masa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Jatsi quiha huai ibo qui yonati bo bëcaniquë. Johax, “Bëro jia ca roha no bananiquë huaí no pë, taitá. ¿Jahuëniahax masa joha sa?” i jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jatsi ibo nëcaniquë: “Tonia masa bëro bananiquë pë ë qui caxahai cato” iquiina. Jatsi, “¿Masa mëxaxëhi ni noa ra?” i ibo qui yonati bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ayamacana. Masa pi mëxaquí tsi noho trigo ri ma mëxamitsa rë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Jariapari ja shinahabëquicano. Jatsi tësatiyá tsi ‘Masa pari mëxacana’ ixëquia yonati bo qui. Mëxaxo tsi nëxacana mëshati. Jaquirëquë noho trigo xobo qui bëcahuë, tësaxo na” i noho yonati bo qui xëquia —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jatsi chani huëtsa Jesú yoaniquë: —Huaí tsi bëro mishni quiha, naa mostaza bëro joní bananina. Toa bëro jascaria tsi anixëhi quiha Diós nohiria bo otohaina. ");
INSERT INTO caoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mishni-mishniria tsi xo naa bëro ra. Jama, shinahaquí tsi pistiama tsi xo jahuë jihui ra. Banahaca ca jocohai ca huëtsa bo oquë quiha. Shinahacax jihui manëhi quiha. Jatsi jahuë mëshi bo ó tsi paihi quiha isa bo ra —i Jesu niquë tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jaquirëquë chani huëtsa Jesú yoaniquë: —Harina somo ca ya yoxá tëohacai ca levadura jascaria tsi xo Diós otohaina. Tres medidá tsi levadura tëohaqui yoxa, harina tëquë shapohuaxëna —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nohiria bo qui chanipama tsi nëca ca chani bá roha tsi Jesu chaniniquë. Ejemplo bo yama tsi ja chaniyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jabi ejemplo bá tsi ja chani-chaniniquë, Dios Chani yoanish cató quënëni ca jatihuaxëna. Jabi Jesu yoati ja yoani tsi xo naa: “Chani bo, naa ejemplo bá tsi nohiria bo qui chanixëhi quiha. Chanihax jonë ca jahuë bo bërohuaxëhi quiha, naa mai nëhohuahacanitiya rohari ca jahuë bo” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jatsi toa nohiria huëstima ca Jesú jisbayaniquë. Jisbayá tsi quiha xobo qui ja jiconiquë. Jatsi jahuë doce ca rabëti bo ja qui bëcaniquë. —¿Jënihi ni naa trigo huaí ca masara chani sa? Noqui yoahuë —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jatsi quiha toa chani Jesú bërohuaniquë: —Ea ti tsi xo toa bëro jia ca banahai cato, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jatsi nohiria bo jascaria tsi xo huai. Jatsi, Dios baquë bo tsi xo toa bëro jia cabo. Jato otoxëhi quiha Dios. Jatsi, Satanás baquë bo tsi xo toa bëro yoi bo. ");
INSERT INTO caoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Jatsi ë qui caxahai ca, naa bëro yoi sayanish ca tsi xo Satanás. Jatsi tësatiyá tsi xo toa xaba rëso, naa jaroha ca bari. Jatsi tësacanaibo tsi xo ángel bo. ");
INSERT INTO caoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mëshahacati ca mëxahacahai ca masa jascariaxëhi quiha jaroha ca barí no, ë joxëquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Noho ángel bo raaxëquia. E otohai cato ó ca jochamacanaibo, yoixëni ca nohiria bo, tihi cabo aquëquëmacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Aquëquëmaxo tsi tënëtiyá jato niacaxëcani quiha, naa chihi qui masa niahai jascaria. Toá tsi araconacaxëcani quiha ra. Jatsi, “Erama. Jishopë” icaxëcani quiha tënëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jama, bari huahuahai jascariaxëhi quiha Dios nohiria bo. Jahëpa Dios ya icaxëcani quiha, ja otohai cató no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","—Huai maihuaha ca jahuë copixëni cabo jascaria tsi xo Diós otohaina —i Jesu niquë—. Jabi huai maihuani ca jahuëmishni bo joní bërohuaniquë. Bërohuaxo tsi quiha toa jahuë bo maihuatëquëhi quiha, nohiria bá cahëyamano iquish na. Jatsi rani tsi jahuë jahuë bo tëquë iniahi quiha, parata bixëna. Toa huai copicatsi quiha. Iniaxo tsi quiha huai copihi quiha, maihuahacani ca jahuë copixëniria cabo bixëna —nëa tsi Jesu nëcaniquë Diós otohai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","—Copixëni ca perla bo mërahai ca comerciante jascaria tsi xo Diós otohaina —i Jesu niquë—. Jabi copixëni ca perla bo mërahi cahi quiha joni. ");
INSERT INTO caoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huësti ca perla copixëni ca jisi quiha. Jiaria ca perla quiha. Jisi tsi jahari jahuë xobo qui cahi quiha jahuë jahuë bo tëquë iniaxëna. Parata bicatsi quiha, toa perla copixëni ca copixëna. Parata bixo copihi quiha —nëa tsi Jesu nëcaniquë Diós otohai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","—Sani biti nishi jascaria tsi xo Diós otohaina —i Jesu niquë—. Jabi ia qui jahuë nishi niahi quiha ibo. Niaxo tsi huëstima ca sani jamëri cabo bichi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jahuë nishi rëamëno tsi mai quëmapo qui nishi xërëhi quiha. Jatsi tsahohi quiha ibo jahuë sani topixëna. Jahuë caca qui sani jia ca nanëhi quiha. Jama, sani yoi ca niahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jabi tocaxëhi quiha xaba rësó no. Bocaxë-cani quiha ángel bo jochahuaxëni cabo catiaxëna. Mëstëxëni ca xërëquë ó ca yoi cabo aquëquëmacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Aquëquëmaxo tsi horno chihi qui jato niacaxëcani quiha. Toá tsi xo huëstima ca ara-aracanaina ra. Toá tsi “Erama. Jishopë” icaxëcani quiha tënëhi na —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jatsi jahuë rabëti bo Jesú nicaniquë: —¿Naa ë yoaha ca jahuë bo tëquë cahëcanai? —iquiina. Jatsi, —Jaahuë. Cahëqui noa ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jatsi Jesú jato yoaniquë: —Rabë ca copixëni ca jahuë bo jaya xo jodioba yoba tiisimacanaibo, naa ëa banahuacanaibo. Jariapari ca copixëni ca jahuë tsi xo toa Dios Chani yoanish cabá quënënina. Yoahacaxëti quiha toa chani siri ra. Jasca tobi xo ë yoahai ca chani. Yoahacaxëti quiha naa chani paxa ca ri. Tihi cabo jayacani quiha yoati —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jabi naa ejemplo bo yoaxo tsi quiha Jesú jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jisbaya tsi quiha jahari jahuë yaca qui ja caniquë. Toa xo tsi jato catiti xobo xo tsi ja tiisimaniquë. Ratëniquë jahuë chani nicanish cabo. —¿Jahuëniá ca naa tiisi ja bini sa? ¿Jënahuariaxo raca naa jisti bo aqui ni pa? —i nohiria bo niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Carpintero José baquë ma ni naa ra? Jahuë jahëhua María, jahuë noma bo, naa Jacobo, José, Simón, Judas, tihi cabo cahëqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Nëá tsi racayamayamahi ni jahuë poi maxco bo ri? ¿Jahuëniá ca naa tiisi ja jabini pa? —i jaca niquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Jatsi pë Jesu pasomaha ja bësocaniquë. Jato qui yoi ja ini quiha. Jatsi Jesú jato yoaniquë: —Mai huëtsá ca Dios Chani yoati ibo pi chanino tsi ja qui nicayoicani quiha toá ca nohiria ra. Jama, jahuë maí ca nohiria bo qui ja chanipino tsi ja qui nicayamahi quiha jahuë yacatá cabo, jahuë xobó cabo ri. Jato qui yoi quiha jahuë chani rë —nëa tsi Jesu nëcaniquë jahuë yacatá ca nohiria bo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Japi jahuë yacata xo tsi jisti huëstima cabo ja ayamani quiha rë, ja qui ja chitimiyamacani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Toatiyá tsi quiha chama-chamaria Herodés nicaniquë Jesu yoati na. Nicahax, ");
INSERT INTO caoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","—Ashimati ibo Juan yamabo tsi xo toa ra. Tonia ja bësotëquëyamëquë iquia ra. Ja tsi xo toa jisti bo ati mëtsa xo toa joni tia —i Herodes niquë jahuë yonati bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jabi siri tsi soldado bo Herodés raani quiha Juan qui tsamiti. Tsamixo tsi quiha preso qui ja nanëni quiha, Herodías, naa jahuë noma Felipe ahui tahëxo na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jasca, pasiyamani quiha Juan. —Anoma tsi xo toa mi noma ahui bichiina, mi ahui iti —i ja qui Juan paoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ja iqui tsi Herodés Juan acasniquë. Jama, jodiobo qui ja raquëni quiha “Dios Chani yoati ibo-iboria xo Juan” i nohiria bo ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jatsi Herodes coni bari tsëquëquë tsi quiha Herodías jahi pabëniquë quëtsocani ca nohiria bësojó no. Chama Herodes qui jiaria quiha ja pabëhaina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rani tsi quiha jahi pistia qui Herodes nëcaniquë: —Mia parayamaquia. Jahuëcara ca, naa jaha mi quëëhai ca mi qui axëquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jatsi quiha jahuë jahëhua ya pari ja chaninaniquë, jahuë yoba nicaxëna. Nicahax, —Ashimati ibo Juan mapo ë qui ahuë ra, ratá no —i chama Herodes qui ja niquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Jatsi quiha Herodes cohuëniquë nicahax na. Jama, nohiria bo bësojó “Mia parayamaquia ra” i ja ni iqui tsi jahuë yonati bo ja raaniquë Juan mapo biti. ");
INSERT INTO caoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Jatsi quiha Juan mapo ja tëquëësacaniquë rë preso xo na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tëquëësaxo tsi jahari jahuë mapo ja bëcaniquë ratá no. Xotaco qui ja acani quiha. Jatsi jahuë jahëhua qui ja boniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jaquirëquë quiha Juan yora jahuë rabëti bá biniquë maihuaxëna. Maihuahax Jesu qui ja bocaniquë yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan namëni nicahax Jesú jisbayaniquë notí no. Jisbaya tsi quiha nohiria yama ca iti qui ja caniquë jamë icatsi na. Cohuë ja ini quiha. Jama, ja cahai ca yoati tsi nohiria bá nicaniquë rë. Nicaxo tsi quiha jato yaca bo ja jisbayacaniquë Jesu banahuaxëna. Maí tsi ja bocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jatsi noti ax tëmahinaxo tsi quiha toá ca mani ca nohiria bo Jesú jisniquë. Manahi ja icani quiha. Jato noiquí tsi quiha jato anomaria cabo ja jënimahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jatsi yata tsi quiha ja qui jahuë rabëti bo bëcaniquë. Bëcanax, —Caquë bari ra. Yama tsi xo xobo bo nëá no rë. Nohiria bo jahari raahuë, yaca bo xo tsi piti ja copicano iquish na —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jatsi, —Ja boyamacati xo. ¿Japa mato tsa ni? Jato pimacana —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jatsi ja quëbicaniquë: —Cinco ca mapari bo, dos ca sanino, tihi roha jaya xo noa ra piti —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jatsi, —E qui acahuë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jatsi nohiria Jesú tsahomayoniquë huasí no. Tsahomaxo tsi quiha cinco ca mapari bo, dos ca sanino, tihi cabo Jesú biniquë. Bichi tsi quiha mana qui tsayapama tsi “Gracias” i Dios qui ja niquë piti quëshpi na. Jatsi mapari ja tëxënamaniquë. Tëxënamaxo tsi quiha jahuë rabëti bo qui ja mëaniquë nohiria bo qui taati. ");
INSERT INTO caoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Jatsi piniquë nohiria tëquë. Ja sëyacaniquë. Jaquirëquë pihama ca quësi bo ja catiacaniquë. Doce ca caca quiha ja rëacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Jabi cinco mil ca joni bo ini quiha, naa mapari picanaibo. Tocahacayamani quiha yoxa bo, xocobo, tihi cabo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jatsi noti qui jahuë rabëti bo Jesú jicomaniquë, ja bëbo ia ja shitacano iquish na. Jasca, nohiria tëquë jahari jato xobo qui ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Raahax tsi quiha maca bo qui ja caniquë jamë no. Toá tsi ja bëhoxcasni quiha. Cahax toá tsi jamë ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jasca, toá ja no tsi quiha quëmapo basi, naa ia nëpax tsi quiha jahuë rabëti bo iniquë notí no. Toá tsi quiha chocá jato noti niahi iniquë rë, yoshi xotohai ca bëchá ja icani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jabi patiari quëonox pari no tsi jato qui Jesu caniquë. Jënë́ tsi ja coni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jatsi jënë́ tsi ja cohai jisi tsi ja raquëcaniquë, bërocamaqui quëscahuahi na. —Bërocamaqui rë —iria tsi jaca niquë, raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jatsi jato qui Jesú chanitapiniquë: —Chamacana. Ea yoi xo naa. Raquëyamacana —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jatsi Pedro chaniniquë: —Mia pi yoi no tsi ëa quënahuë, Ibobá. Jënë́ tsi mi qui ë jono ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jatsi, —Johuë —i Pedro qui Jesu niquë. Jatsi noti Pedro huajaniquë. Jënë́ tsi tapitsi quiha ja niquë ra Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Capama tsi quiha yoshi xotoriahai ca ja tsaya-tsayaniquë. Tsayahax ja raquëniquë. Jatsi jëtëquëtsijaniquë ra. Jatsi ja quënaniquë: —Ea mëbihuë, Ibobá —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jatsi quiha jahuë mëquë Jesú bitapiniquë mëbixëna. Mëbihax, —Iriama tsi xo ë qui mi chitimihaina rë. ¿Jënihax tsi ë qui mi chitimiyoiyamaha? —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jaquirëquë noti qui ja jicocaniquë. Janacatapini quiha yoshi xotohaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jatsi Jesu bësojó tsi noti ca joni bo mëniniquë. Mënihax, —Dios Baquë yoi xo mia ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jatsi quiha ia ja shitacaniquë, naa Jesu, jahuë rabëti bo. Shitaxo tsi quiha Genesaret mai qui ja rërëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Toá ca nohiria bá Jesu cahëtapini quiha. Cahëxo tsi quiha bamaxoma tsi chani ja raacaniquë toá ca maí ca nohiria bo qui. Jatsi iquicanaibo, anoma cabo, tihi cabo ja qui bëcaniquë jënimahuahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Jasca, jahuë sahuëti quëpë ja motsacascani quiha, —¿Motsapi? —iquiina. Jatsi jënimahuahacaniquë jahuë sahuëti motsanish cabo tëquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jatsi jodioba chama bo, yoba tiisimacanaibo, tihi cabo bëcaniquë Jerusalén ax na. Ja bëcana ca tsi Jesu ja nicacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Jënixo tsi noba rëquëyamaba jabi bo ayamacahi ni mi rabëti bo ra? Mëchocoyamacani quiha pë, oriquinox pari —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jatsi Jesú jato quëbiniquë: —¿Jënixo tsi Dios yoba nicayamacanai ra mato ri? Dios yoba mato qui oquë tsi xo mato jabi bo pë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jabi “Mato jahëpa bo, mato jahëhua bo, tihi cabo noicana” i Dios ni quiha. Jasca, “Namëhacati xo toa jahuë jahëpa jahuë jahëhua ranihai cato” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jama, mato qui jënima tsi xo mato noitiria ca nabo mëbiyamahaina rë. Mato nabo qui nëcaqui mato pë: “Jishopë. Mato mëbitimaxëni xo noa rë, Dios qui mato parata no aquitaha quëshpi na” i mato nabo quii quiha mato ra. Jabi tocaqui mato pë, jato mëbicasyamahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jatsi mato nabo mëbiyamaqui mato pë. Mato qui jënima tsi xo toca ca ma chanihaina rë. Anoma quiha. Toca tsi Dios yoba chahahuayamaqui mato ra, mato jabi bo banahuacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Jatsi quiamisxëni xo mato iquia. Mato yoati tsi chaniquí tsi Isaías yamabá parayamani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Chaniquí tsi jia tsi ëa ocahuacani quiha naa nohiria, jama, ëa basi jato shina nori’ i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jasca, ‘Mahitsa ë qui aracani quiha. “Dios yoba tsi xo naa” icani quiha pë, tiisimahi na, jato mahitsa ca yoba nori’ ii quiha Dios” nëa tsi quiha Isaías yamabo nëcaniquë mato yoati na —i jodioba chama bo qui Jesu niquë quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jaquirëquë Jesú nohiria bo quënaniquë. Quënahax, —Ea nicacana. Ma cahëno ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nohiria jochamayamahi quiha ja pihaina ra. Jama, nohiria jochamahai ca tsi xo toa yoi ca ja chanihaina, yoi ca ja shinahaina. Tihi tsi xo toa ja jochamahaina —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Jatsi quiha jahuë rabëti bo ja qui bëcaniquë. Bëhax tsi, —Bëcanish ca chama bo mi caxahuaquë pë. Jato qui yoi quiha mi yoahana —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jatsi quiha Jesú jato quëbiniquë: —Dios yoba ma xo toa ja tiisimacanina ra; nohiria yoba yoi roha nori. Naamayamaxëhi quiha toa ra. Quëyohacaxëhi quiha ja tiisimacanaina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Jatsi jato qui shina-huëjëyamacana. Bëco ca rëquëniniti ibo bo ca xo ra. Bëco ca joní pi bëco ca nohiria mëpino tsi naporoquini qui paquëcaxëcani quiha jato tëquëta ra. Jabi toca tsi ca xo —i Jesu niquë jodioba chama bo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jatsi Pedro chaniniquë: —No joma mi yoaha ca chani rë. Mi chani bërohuahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jatsi Jesú chaniniquë: —¿Cahëyamahi ni mato ri pa? ");
INSERT INTO caoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mato poco ax paquëhi quiha ma pihaina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Jama, nohiria shina yoi ca quima ax johi quiha yoixëni ca chanihaina. Ja tsi xo toa nohiria jochamahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Jasca, nohiria shina ax johi quiha yoi ca shinahai ri. Yoi ca pi shinaquí tsi anoma ca axëhi quiha ra. Shina yoi iqui tsi tobi xo ati ibo bo. Tobi quiha joni huëtsa ahui bichiina. Tobi quiha anoma ca chotahaina, quiahaina, ranimis-haina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nohiria jochamahai ca tsi xo toa bo iquia ra. Jama, mëchocoxoma pi no pino tsi no jochahai ca quëscahuacani quiha pë. Jama, nohiria yoihuayamahi quiha toa mëchocoyamahaina ra —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Toa ax riquihax tsi quiha basima ca Tiro, Sidón mai qui Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Jabi toá ca racanish ca yoxa Jesu qui joniquë. Carayana ja ini quiha; naa cananeabo icanai cato. Johax, —Ea shinahuë, Ibobá, chama David yamaba chahitaxocobá. Noitiria tsi xo noho jahini rë. Yoshi jaya xo ra. Tënëmahi quiha; anoma quiha —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Quëbiyamaniquë Jesu nicaxo na. Jatsi quiha ja qui jahuë rabëti bo bëcaniquë. Bëhax, —Naa yoxa raahuë. Jari noqui banahuahi quiha pë. Anoma xo ja pacots-huahaina ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jatsi quiha yoxa qui Jesú chaniniquë: —Israél ca nohiria qui roha ë raahacaniquë mëbiti, bënohai ca oveja bo jascaria jaca nori iqui na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ja yoani ca nicahax tsi quiha ja bësojó tsi carayana yoxa mëniniquë johax na. Bënapama tsi, —Ea mëbihuë ra, Ibobá —i ja qui yoxa niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jatsi quiha yoxa qui Jesu chanitëquëniquë: —Noba jabi pasomaha tsi xo carayanabo mëbihaina ra; naa noba mapari ina bo qui niahai jascaria nori —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jatsi quiha yoxá Jesu quëbiniquë: —Jabija, Taitá. Yoiria ca carayana ca roha ca ëa xo naa ra, jama, ¿jato chama mesa quima ax paquëhax ca quëxë mishni bo piyamayamahi ni ina bo ra? Jatsi ëa shinahuë ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Japi Jesú quëbiniquë: —Jiaria tsi xo toa ë qui mi chitimihaina, yoxá. Mi bax acacaxëhi quiha jaha mi quëëhaina iquia —iquiina. Jatsi jënimaritsiniquë jahuë jahini ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Toanahax riquicaya tsi quiha ia Galilea tsi Jesú quënibonaniquë. Quënihax maca ja tëmahinaniquë. Jatsi ja tsahoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jatsi ja qui bëcaniquë nohiria misco. Ja qui huico yoi bo, bëco cabo, yora choni jaya cabo, pasoyamacanaibo, iquicanaibo, tihi cabo quiha ja bëcaniquë. Bëxo tsi quiha Jesu tahë tsi jato ja janacaniquë ja jënimahuano. Jatsi quiha Jesú jato jënimahuaniquë. Chanitsi jaro cabo ni quiha. Jënimahuahacani quiha yora yoi jaya cabo. Tapini quiha huico yoi cabo. Taisni quiha bëco cabo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jisi tsi nohiria bo ratëniquë. Jatsi Israél ca Dios nohiria bá ocahuaniquë raniquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jatsi quiha jahuë rabëti bo Jesú quënaniquë. —Noitiria tsi xo naa nohiria bo rë. Tres bari no tsi ë bëta-jacaquë. Yama tsi xo ja picanaina rë. Paxnacani quiha ra. Toca tsi jato xobo qui raacasyamaxo ëa ra, ja rësocana-camitsa iqui na —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jatsi, —¿Jënahuariaxo raca jato bax mapari no bina ra? Xobo yama ca iti tsi xo naa ra —i ja qui jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jatsi quiha, —¿Jahuë tihi ca mapari jaya ni mato? —i jato qui Jesu niquë. Jatsi, —Siete ca mapari, rabë roha ca sani mishni bo, tihi roha jaya xo noa rë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Jatsi mai tsi quiha Jesú nohiria bo tsahomaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Tsahomaxo tsi quiha siete ca mapari bo, sani mishni bo, tihi cabo Jesú biniquë. Bichi tsi quiha “Gracias” i Dios qui ja niquë, piti quëshpi na. Jaquirëquë mapari, sani bo, tihi cabo ja tëxënamaniquë. Tëxënamaxo tsi quiha jahuë rabëti bo qui ja aniquë nohiria qui ja mëacano. Jatsi nohiria huëstima ca qui ja mëacaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Piniquë nohiria tëquë. Ja sëyayocaniquë. Ja picaquë tsi quiha pihama ca quësi mishni bo ja topiyocaniquë. Jatsi siete ca caca ja rëacaniquë pa. ");
INSERT INTO caoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Jabi cuatro mil ca joni bo pimahacani quiha. Tocahama ini quiha yoxa bo, xocobo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jaquirëquë jato xobo qui jahari Jesú raaniquë. Raahax noti qui ja jiconiquë. Jicohax Magdala icanai ca mai qui Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jatsi jodioba chama bo Jesu qui bëcaniquë tanamaxëna. Joi ja mëracascani quiha ja qui quësocatsi na. Ja iqui tsi, —Jisti no bax mi ano ra. Jisti pi mi ano tsi mia chahahuaxëqui noa ra —i ja qui jaca niquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jatsi nëca tsi Jesú jato quëbiniquë: —Naipá ca jisti bo cahëxëni xo mato ra. “Jiasharihi quiha” ii quiha mato, yata tsi xabaria ca nai jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Jasca, “Jopaima xo oi ra” iqui mato baquishmari tsi tsëmoria ca xabaria ca nai jisi na. Jabi nai tsaya-tsayaquí tsi oi johai ca, yota johai ca, tihi cabo cahëriaqui mato ra; jama, mato xërëquë ó ca jënipihai ca cahëyamaqui mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anomaria tsi xo naa jaboqui bësocanaibo ra. Dios cahëtimaxëni ca xo ra. “No bax mana ca jisti mi ano” ii quiha mato. Ayamaxëquia ra, ë qui ma chitimiyamahai iqui na. Jama, huësti ca jisti roha mato qui acacaxëhi quiha, Dios chama jaya ca ë nori ca ma cahëno iquish na. Tres bari no tsi mai xara ixëquia. Jaquirëquë tsëquëxëquia Jonás yamabo tsëquëni jascaria —nëa tsi Jesu nëcaniquë jodioba chama bo qui. Jatsi jato ja jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jatsi quiha ia rabëquëx ca qui ja shitacaniquë. Shitahax, —Jishopë. Mapari piti no shina-bënoquë rë —i jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jatsi quiha, —Jodioba chama bo qui quiniacaxëcahuë; mapari levadura jascaria ca xo pë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jatsi jato xërëquë tsi chaninatsijacaniquë: —Toca tsi chanihi quiha pë, mapari no shina-bënoha iqui na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jabi ja chaninacanai ca Jesú cahëniquë. Cahëhax ja nëcaniquë: —¿Jënihax joi i-icanai rë, naa ma shina-bënoha ca mapari yoati na? Iriama tsi xo ë qui ma chitimihaina rë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Jari cahëyamahi ni mato pa? Shinaparicahuë. ¿Cinco ca maparí tsi cinco mil ca joni bo ë pimayamahitaha? Jaquirëquë, ¿doce ca caca ma rëayamahita? ");
INSERT INTO caoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Jasca, ¿siete ca maparí tsi cuatro mil ca joni bo ë piyamayamëta? Jaquirëquë, ¿siete ca caca ma rëayamayamëta? ");
INSERT INTO caoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Jëniriahax ë yoahai ca cahëyoiyamacanai sa? Mapari yoi yoati chaniyamaquia. Jodioba chama bo qui quiniacaxëcahuë iquia; mapari levadura jascaria ca jaca nori —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jatsi jodioba yoiria ca yoba qui ja quiniacaxëti nori ca ja cahëcaniquë; mapari levadura yoati ja chaniyamaha nori. ");
INSERT INTO caoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jatsi quiha Cesareá ca Filipo yaca qui Jesu cahëniquë. Cahëxo tsi quiha jahuë rabëti bo ja nicaniquë: —¿Tsohuë ni ëa? ¿Jënihi ni nohiria bo ëa yoati na? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Jatsi quiha jahuë rabëti bá quëbiniquë: —“Ashimanish ca Juan yamabo përë xo mia” ii quiha huësti huësti ca nohiria. Jasca, “Elías yamabo xo mia” ii quiha nohiria huëtsa. Jasca, “Tonia Jeremías yamabo; ¿Dios Chani yoanish ca huëtsa ma ni?” ii quiha huëtsa bo —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jatsi jato Jesú nicaniquë: —¿Japa mato tsa ni? ¿Tsohuë ni ëa yoi? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jatsi, —Dios raahacanish ca Xabahamati Ibo xo mia ra; Bësohai ca Dios Baquë mi nori —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jatsi Jesú quëbiniquë: —Shoma xo mia Simón, Jonás baquë. Jabija tsi xo toa mi yoahana. Dios baquë ë nori ca mia cahëmaquë noho naipá ca Jahëpa. Nohiria bá yoahai ma xo toa mi shinahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mi yoaha iqui tsi nicaparihuë. Maxa-maxaria xo mia Pedró. Jabi tocahi quiha mi janë. Mia cacha noho iglesia axëquia. Bëbohacatimaxëni ixëhi quiha ra, naa toa ë qui chitimicaxëcanaibo. Jato bëboyamaxëhi quiha Satanás chama ra. ");
INSERT INTO caoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Jasca, mi qui mana ca chama axëquia, chitimicaxëcanaibo rëquëniniti. Jato yobaxëqui mia ra. Toatiyá tsi, “Jënima tsi xo toa jabi ma acaina” i pi mi no tsi jënimaxëhi quiha ja acanaina mana ca Dios qui. Jasca, “Anoma tsi xo toa acaina” i pi jato qui mi no tsi tocaxëhi quiha Dios ri. Tocaxëti quiha mi yoba —nëa tsi Pedro qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jatsi jahuë rabëti bo Jesú yobaniquë, nohiria bo Xabahamati Ibo-iboria ja iqui ca ja yoayamacano. ");
INSERT INTO caoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jaquirëquë quiha bëroria tsi jahuë rabëti bo qui chaniti Jesú chitahëhuaniquë. Ja nëcaniquë: —Jerusalén qui ë cati xo. Toa xo tsi ëa tënëmacaxëcani quiha yosibo, arati ibo-iboria bo, Dios yoba tiisimacanaibo. Ea namëcaxëcani quiha ra. Jama, tres bari quirëquë bësotëquëxëquia —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nicaxo tsi quiha Pedró Jesu aquëquëmaniquë, jamë ca ja qui chanixëna. Jatsi Jesu raahatsijahuaniquë. —Dios qui yoi tsi xo toa mi yoahana ra. Anoma quiha. Mi rësoyamano iquia —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jatsi Pedro quiri bësohax tsi, —Cata, Satanás. Jochati ëa tanamaqui mia pë. Diós shinahai ca jasca ma xo toa mi shinahaina ra, joni shinahai jasca nori —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jatsi quiha jahuë rabëti bo Jesú yobaniquë: —Ea banahuapicasquí tsi ma acatsai ca ma shinayamaxëti xo. Mato cruz ma iacano. Iaxo ëa ma banahuano. ");
INSERT INTO caoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jabi xabahamahacayamaxëhi quiha toa jahuë noma jabi ó quëëmisxëni cato. Jama, xabahamahacaxëhi quiha ëa iqui tsi jahuë noma jabi chihohuahai cato. Bëbo-bëboriaxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Jabi jatiroha ca maí ca jahuë bo nohiriá bëbomitsa; jama, tënëtiya pi qui caquí tsi ¿jahuë raca ja bëbona? Noitiria ca tsi xo toa. Tocapiquí tsi ¿jënahuariaxo joní ana, bësotëquëxëna? ");
INSERT INTO caoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Jatsi quiniacaxëcahuë. Noho Jahëpá oquë tsi joxëquia ra, noho ángel bo ya. Joxo tsi toa barí tsi jatiroha ca nohiria copixëquia ja acani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mato parayamaquia. Ma rësonox pari no tsi noho oquë, noho chama, tihi cabo jisxëqui mato huësti huësti cabo, rey jascaria tsi ë joxëquë no —i Jesu niquë jahuë rabëti bo yobahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis bari quirëquë quiha Pedro, Jacobo, Juan, tihi cabo maca qui Jesú boniquë jato bëta jamëxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bohax tsi quiha jahuë jaria rarinaniquë jato bësojó no. Bari jascaria jahuë bëmana huahuani quiha. Jasca, joxonariani quiha jahuë sahuëti, huëa jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Jatsi quiha toá tsi jisiquiniquë Moisés yamabo, Elías yamabo. Tihi quiha. Jesu ya chanihi quiha ja icaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jatsi quiha Jesu qui Pedró chaniniquë: —Noqui jiaria tsi xo nëá no iquiina. Nëa xo tsi tres ca tapas axëquia ra. Huësti mí-na, huësti Moisés yamabá-na, huësti Elías yamabá-na ra. ¿Mi qui jia ni? —nëa tsi quiha Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Chanijano tsi quiha bajrahai ca tsëmó jato mapaniquë. Jatsi tsëmo xërëquë ó ca joi ja nicacaniquë: —Noho Baquë tsi xo naa ra. Noiquia ra. E qui jia tsi xo toa ja acaina ra. Nicacana ra —i joi niquë jato qui. ");
INSERT INTO caoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Jatsi quiha jahuë rabëti bo raquëniquë joi nicahax na. Mai qui ja paquëcaniquë jato bëmana mai quiri. ");
INSERT INTO caoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jatsi jato qui Jesu caniquë. Caxo tsi jato ja motsaniquë. —Joicana. Raquëyamacana —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jatsi bëpëquëquí tsi quiha Jesu roha ja jiscaniquë. Jamëpistia ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jaquirëquë macaná rënichipama tsi jahuë rabëti bo Jesú yobaniquë: —Bëpacana. Ma jisi ca jahuë bo nohiria bo jari yoayamacana. Jariapari ë bësotëquëxëti xo ra, naa Nohiria Baquë ë nori cato —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Jatsi quiha jahuë rabëti bá nicaniquë: —Xabahamati Ibo jonox pari no tsi joxëti quiha Elías ii quiha noba yoba tiisimacanaibo ra. ¿Jënihi ni? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jatsi Jesú jato quëbiniquë: —Jabija tsi xo toa ja yoacanaina ra. Jariapari joxëti xo Elías, jatiroha ca rohahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Jama, joniquë Elías iquia ra. Ja joquë tsi nohiria bá cahëyamaniquë rë. Jasca, ja yosicaniquë pë. Jascaria tsi ëa, naa Nohiria Baquë ca tënëmacaxëcani quiha —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jatsi nohiria ashimanish ca Juan yamabo yoati tsi Jesu chaniha nori ca jahuë rabëti bá cahëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nohiria misco qui ja cahëcaquë tsi quiha Jesu qui joni joniquë. Johax tsi Jesu bësojó tsi ja mëniniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Noho baquë shinahuë, Ibobá. Yoyo jaya xo rë. Anomaria tsi xo jahuë pahë. Huëstima tsi chihi, jënë, tihi cabo qui paquëhi quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mi rabëti bo qui noho baquë ë bëquë, ja jënimahuacano. Atimaxëni ca xo rë —nëa tsi Jesu qui joni nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jatsi Jesu chaniniquë: —Chahahuatimaxëniria ca yosaxëni ca nohiria xo mato ra. ¿Jahuë tihi tsi mato qui yosaxëhi ni ëa rë? Jahuë baquë nëri bëcana ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jatsi quiha baquë ó ca yoshi Jesú raahaniquë. Raahajahuaquë tsi quiha baquë quima yoshi tsëquëniquë. Jënimatapiniquë baquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jaquirëquë Jesu jahuë rabëti bá nicaniquë jamë ja iquë no: —¿Jënixo tsi jahuë yoshi tsëcanoma no iqui rë? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jatsi Jesu nëcaniquë: —E qui ma chitimiyamayoicanai iqui na. Mato parayamaquia. Aniyamahi quiha ë qui ma chitimihaina rë. Jabi banahacanox pari tsi quiha mishni-mishniria tsi xo mostaza bëro. Jama, ani-aniriahi quiha toa jocohai cato. Chahitaxëni manëhi quiha. Jabi mostaza jocohai ca jascaria pi ë qui ma chitimihai ca anino tsi anomariaxëhi quiha ma acaina ra. Jatsi, “Toa tsi cata” i pi naa maca qui ma no tsi caxëhi quiha ra —nëa tsi Jesu jato qui nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jaquirëquë bari huëtsá tsi jahuë rabëti bo catiquë tsi quiha jato qui Jesu nëcaniquë. —Nohiria caxaxëniria cabo qui ë mëahacaxëti xo. Jatsi ëa, naa Nohiria Baquë nori ca acaxëcani quiha ra. Jama, tres bari quirëquë bësotëquëxëquia ra —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Jatsi jahuë rabëti bo cohuënaniquë nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jabi Capernaum mai qui ja cahëcaquë tsi quiha Pedro qui impuesto bicanaibo bëcaniquë jato arati xobo ax na. —¿Arati xobo qui impuesto copiyamahi ni mato chama sa? —i Pedro qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Jatsi, —¿Ocamani? —i jato qui Pedro niquë. Jatsi quiha xobo qui Pedro jiconiquë Jesu yoaxëna. Jama, ja chaninox pari no tsi Jesu ja qui chaniniquë: —¿Jahuë shinahai, Simón? ¿Tsohuë quima parata bichi ni maí ca chama bo? ¿Jabë nohiria bo quima ni? ¿Carayanabo quima ni? —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jatsi, —Carayanabo tsi xo toa impuesto acaina ra. Jato jabi quiha —i Pedro niquë. —Jabija tsi xo toa mi yoahana. Jatsi jato qui parata no ayamati xo pa, Diós-na bo no nori iqui na; carayanabo no nomari. ");
INSERT INTO caoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Maj. Jato no caxahuayamano. Parata ó pasocani quiha. Japi ia qui cata. Toa xo tsi huëti nishi niahuë. Jariapari ca sani bichi tsi japëcahuë. Toá ca parata copixëni ca jisxëqui mia. Bihuë. Impuesto bicanaibo qui toa parata ahuë. Mi impuesto, noho impuesto, tihi cabo mi copino —nëa tsi Pedro qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Toatiyá tsi Jesu qui bëxo tsi jahuë rabëti bá nicaniquë: —¿Tsohuë ni toa Diós otohai cató ca oquë cato? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jatsi quiha baquë pistia Jesú quënaniquë ja qui ja jono. Quënaxo tsi quiha jato xërëquë tsi baquë pistia ja niimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Niimahax ja nëcaniquë: —Mato parayamaquia ra. Xocobo jascaria ma manëti xo ra, Diós otohai ca qui jicocatsi na. Xocobo jascaria pi Dios quiri bësoyamahi tsi jicopistiayamariaxëqui mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Naa xocobo jascaria ma manëti xo. Iriama ca pi ma manëno tsi mato oquëhuaxëhi quiha Diós ja otohai cato xo na. ");
INSERT INTO caoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jasca, noho janë tahëxo pi nëca ca baquë joihuaquí tsi ëa ri joihuaqui mato ra —i jahuë rabëti bo qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","‘Jabi jia tsi ë qui chitimicani quiha naa xocobo ra. Japi noitiriaxëhi quiha ë quima nëca cabo bësomahai cato iquia. Anomariaxëhi quiha jahuë copi ra. Nëmi ca ia qui tsi tërotamë ca rënëti maxax ya ja niahacaxëti xo iquia. Jama, oquë-oquëria ca copi bixëhi quiha toa joni ra. ");
INSERT INTO caoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jabi noitiria tsi xo nohiria tëquë. Dios quima casoti tanamahacacaxëcani quiha ra, jochati. Jama, noiti-noitiria tsi xo toa nohiria ë quima casomahai cato. Anomariaxëhi quiha jahuë copi ra. ");
INSERT INTO caoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","‘Mato mëquënë́ pi mato jochamano tsi mërëësicahuë. Jasca, mato tahë́ pi mato jochamano tsi jorëësicahuë. Nëama niacahuë. Oquë tsi xo toa mërëxto jorëxto tsi nai qui cahaina. Noitiria tsi xo toa tënëtiya qui niahacahaina mëquë, tahë, tihi cabo ya. ");
INSERT INTO caoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jasca, mato bëró pi mato jochamano tsi bëtsëquëcahuë. Nëama niacahuë. Oquë tsi xo toa huësti ca bëro ya nai qui cahaina. Noitiria tsi xo toa tënëtiya qui rabë ca bëro ya niahacahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","‘Quiniacaxëcahuë. “Anoma tsi xo naa xocobo mishni bo” iyamacana ra. Tobi xo jato ángel bo ra, naa noho Jahëpa bësojó roha mani cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jabi mai qui ë joniquë bëno cabo xabahamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","‘¿Jahuë shinacanai? ¿Jënahuaxëhi ni oveja ibo, naa cien ca oveja jaya cato? Huësti ca oveja pi bënono tsi ¿noventa y nueve cabo jisbayayamayamaxëhi ni ibo, jahuë oveja huësti ca mëraxëna? Bënohax ca oveja mëraxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Bichi tsi rani-ranihi quiha. Naa huësti ca oveja tahëhax tsi anomaria tsi xo toa ja ranihaina. Naa huësti ca oveja quëshpi tsi ranihi quiha; naa noventa y nueve cabo quëshpi oquë ja nori. ");
INSERT INTO caoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jascaria tsi huësti ca xocobo mishni bënocasyama xo mato naipá ca Jahëpa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","‘Mato pasomaha pi mabë xatë jochano tsi jamë tsi ja qui bocata, yoi ca ja aca ca jismaxëna. Mato pi ja nicano tsi jia tsi mato bëta rabënaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jama, mato qui pi ja nicayamano tsi huësti huësti ca xatë huëtsa bo ja qui cati xo, ja qui ma quësocanai ca nicaxëna. Japi oquë tsi xo toa huësti huësti ca xatë huëtsa jayahaina, ja nicacano jato ri. Jabija pi no tsi ja qui quësocaxëcani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Jama, mato qui pi ja nicayamano tsi iglesiá ca nohiria qui yoacahuë. Ja qui ja quësocano jato ri ra. Jabi iglesiá ca nohiria qui pi jari ja nicayamano tsi ja bëta rabënayamacana. Ja bëta chaniyamacana, Dios cahëtimaxëniria ca jochahuaxëniria ja nori iqui na ra. ");
INSERT INTO caoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","‘Mato parayamaquia. Chama mato qui axëquia nohiria bo yobati. Dios qui jia tsi xo toa mai xo tsi ma yobahaina. Yobahi tsi “Jënima tsi xo toa acaina” i nohiria bo qui ma mitsa. Tocapimano tsi Dios qui jiaxëhi quiha ja acanaina. Jasca, “Anoma tsi xo toa acaina” i pi mano tsi Dios qui anomaxëhi quiha ja acanaina. ");
INSERT INTO caoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","‘Mato parayamaquia. Dios qui jia tsi xo dos ca xatë bo bëhoxhaina, jaharisi shinabëquipihi na. Nicaxo tsi jato bax axëhi quiha noho naipá ca Jahëpa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Jabi dos, tres roha pi ë qui aracascanaibo catino tsi jato bëta xo ëa ra —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Joxo tsi quiha Pedró Jesu nicaniquë: —Ea pasomaha pi ëbë xatë jochano tsi ¿jahuë tihi tsi ja aca ca shina-bënoxëhi ni ëa sa? ¿Siete ni? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jatsi Jesú quëbiniquë: —Siete roha iyamaquia. Ichariama tsi xo toa. Jama, huëstima tsi ma shina-bënoxëti xo ra, naa setenta veces siete. ");
INSERT INTO caoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Jabi noba naipá ca chama-chamaria Dios qui jia tsi xo toa noqui pasomaha ca jocha shina-bënohaina. Tobi chani quiha, rey yoati na. Nicacana: Jahuë yonati ba cuenta bo réy tsaya-tsayacasni quiha, jahuë parata ó quëëquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Jatsi quiha cuenta chahitaxëni ca jayanish ca yonati rey qui ja bëcaniquë. Millones naa yonati cuenta ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Copihacatimaxëni jahuë cuenta quiha. Jatsi quiha “Naa joni, jahuë ahuini, jahuë xocobo, jahuë jahuëmishni bo tëquë, tihi cabo iniacana jahuë cuenta quëyoti” i rey niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jatsi rey bësojó tsi yonati mëniniquë cohuëhi na. Rey ja bënariani quiha, “Ea shinahuë, taitá. Huënayamahuë. Mi parata tëquë mia copixëquia ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Jatsi quiha jahuë yonati réy noiniquë. Noixo tsi quiha jahuë cuenta ja quëyoniquë ra. Toa joni réy paquëmani quiha. Cuenta yama ja tsëquëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jatsi yonati jisbayaniquë. Jisbaya tsi quiha ja bëta yonocobëquihai ca yonati ja bëchaniquë. Jahuë rabëti quiha. Jabi jaha ca cuenta pistia toa rabëtí jayani quiha. Ichariama pesos quiha. Jama, bëchahax tsi quiha toa yonati, naa jahuë rabëti qui ja tsaminiquë. Tsamixo tsi quiha tëmosti ja chitahëhuaniquë pë. “Tobi mi cuenta ra. Noho parata bicasquia ra” jahuë rabëti qui toa joni ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Jatsi ja bëta yonocobëquinish ca yonati mëniniquë ja bësojó no. Ja bënarianiquë jaa ri. “Ea shinahuë ra. Huënayamahuë. Mi parata tëquë mi qui ayoxëquia ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jama, ja qui ja nicayamani quiha. Noixoma tsi quiha preso qui jahuë rabëti ja nanëniquë pë. Tsëquënoma ja ini quiha. Jariapari jahuë cuenta copiti nori ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jatsi quiha toa joní acani ca rey yonati huëtsa bá jisniquë. Jisi tsi quiha ja cohuënacaniquë. Jatsi jato rey qui ja bocaniquë yoi ca toa joní aca ca yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jatsi paquëmahacanish ca yonati quiha jahari réy quënaniquë. Quënahax, “Yoixëni ca yonati xo mia ra. Mi cuenta chahitaxëni ca ë quëyohitaquë ra, ‘Ea shinahuë’ i ë qui mi itaha iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Jascaria tsi mi bëta yonocobëquinahai cato cuenta mi quëyoti nori iquë ra, naa mi cuenta ë quëyohitaha jascaria” nëa tsi quiha ja qui rey nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Jatsi toa joni qui rey caxa-caxaniquë. Preso qui toa joni ja raaniquë. Tsëquënoma quiha toa joni iniquë ra, jahuë cuenta ja copinox pari. ");
INSERT INTO caoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Japi mabë xatë bo pi ma noiyamano tsi mato qui tocaxëhi quiha mato naipá ca Jahëpa ri —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Naa jahuë bo yoaxo tsi quiha Galilea mai Jesú jisbayaniquë. Jisbaya tsi quiha jodioba mai, naa ani Jordán rabëquëx ca qui ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jasca, huëstima ca nohiria banahuaniquë. Jatsi jato Jesú jënimahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jatsi quiha ja qui jodioba chama bo huësti huësti ca bëcaniquë tanamaxëna. Ja qui quësocascanaibo ja icani quiha. Nicahi tsi, —¿Anoma ni joní jahuë ahui niahaina? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jatsi Jesú jato quëbiniquë: —¿Quënëhacanish cabo ó ca ma jisyamani? Jariapari tsi bënë, ahuini, tihi cabo Diós bahahuaniquë racanabëquiti. ");
INSERT INTO caoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ja tsi xo toa jahuë jahëpa, jahuë jahëhua, tihi cabo jisbayati xo bënë, jahuë ahui ya racaxëna. (Jasca, jahuë nabo jisbayati xo ahui ri bënë ya racaxëna.) Toca tsi huëstinacani quiha rabë cato. ");
INSERT INTO caoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jaquirëquë rabë ma ca xo; jama, huësti ca jaca nori. Jabi Diós racabëquimaha ca no bëquëxyamano ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jatsi fariseobo chaniniquë: —Majia. Jabi jahuë ahui pi joní niacasno tsi “Ahui niati papi ja qui bënë́ ati xo” ¿i Moisés yamabo yamayamani? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jatsi jato qui Jesu nëcaniquë: —Jabija. Moisés yamabo qui jënima ahui niahai ini quiha rë. Jabi tocajani quiha, tiisimahacatimaxëniria ca mato jimibo ini iqui na. Jama, toca tsi ja iyamapaoni quiha jariapari no, naa bënë, ahuini, tihi cabo Diós nëhohuaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mato parayamaquia. Ahui jia ca, naa joni mëtsaxëniriama ca ahui pi niahi tsi jochahi quiha toa joni, ahui paxa ca ja biquë no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jatsi, —Jishopë. Tocapino tsi oquë tsi xo ahui biyamahaina ra —i jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jatsi Jesú quëbiniquë: —Jabi naa yoba bicasyama xo jatiroha ca joni bo. Jama, bichi quiha Dios qui jia cabo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Jabi tobi huësti huësti ahui bicasyamacanai ca joni bo. Huësti huësti ca tsi xo jobo yama cato, toca tsi ja coni iqui na. Jasca, ahui binoma xo joni huëtsa bo, jato jobo niahacani nori iqui na. Jasca, joni huëtsa bo tsi xo ahui bicasyamahaina, mana ca Dios yonoco ja acascanai iqui na. Jabi naa ë tiisimaha ca yoba biti xo nicati mëtsa cato —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Jabi Jesu qui xocobo mishni bo nohiria bá bëniquë, jato ja shomahuano, jato bax ja bëhoxno iquish na. Jama, xocobo bëhai ca nohiria raahati chitahëhuatsi jahuë rabëti bá huaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jatsi Jesú jato raahaniquë: —Jato chitiayamacana. E qui xocobo bëcano ra. Jato bicatsi quiha mana ca Jahëpa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jatsi quiha xocobo Jesú shomahuaniquë, jahuë mëquë jato ó tsi janaquí na. Shomahuaxo ja jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jatsi shinapayo Jesu jisi caniquë. Caxo tsi quiha ja nicaniquë: —¿Jahuë jia ca axëhi ni ëa, maestro jiaxëni cató, bëso-bësopaoxëna? —iquiina. Jatsi Jesu nëcaniquë: —“¿Jia ca ati ni?” i mi a pa. Huësti roha tsi xo toa jiaxëni cato ra. Dios yoba mi nicati xo, nai qui cacasquí na —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jatsi, —¿Jëni ca yoba nicaxëhi ni ëa pa? —i shinapayo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Nëca tsi Jesú quëbiniquë: —Joni ayamahuë. Joni huëtsa ahui biyamahuë. Yomayamahuë. Quiayamahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mi ipa, mi ihua, tihi cabo noihuë. Jasca, mi tapaí ca nohiria noihuë, naa mimë mi noihai jascaria. Tihi tsi mi ati xo ra —nëa tsi ja qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jatsi shinapayó quëbiniquë: —Toa yoba bo tëquë nicaquia ra, xocobo xo na. ¿Jahuë naris-hi ni ëa ati ra? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jatsi Jesu nëcaniquë: —¿Mëstëxëni ca joni manëcatsi ni mia pa? Cata. Mi jahuëmishni bo iniaparihuë. Parata bixo tsi noitiria cabo qui ahuë. Tocapimino tsi mi qui acacaxëhi quiha naipá ca jahuë bo ra. Jato qui acax tsi jahari johuë. Ea mi banahuano ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jatsi cohuënarianiquë shinapayo cato nicahax na, rico-ricoria ja ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jatsi jahuë rabëti bo qui Jesu nëcaniquë: —Bëronoma tsi xo rico ca joni Diós otohai ca qui jicohaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jahuë chama yoí tsi Diós otohai ca qui jicotimaxëni xo rico ca nohiria ra iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jatsi ratëniquë Jesu rabëti bo, ja yoani ca nicahax na. Ratëhax, —Tocapino tsi yama tsi xo toa xabahamahacati mëtsa cato rë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jatsi Jesú jato bëisniquë. —Jamë xabahamatimaxëni tsi xo nohiria ra. Jama, jatiroha ca ahi quiha Dios ra. Xabahamati Ibo tsi xo toa —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jatsi, —Tsayapa. Jatiroha ca no jisbërianiquë mia banahuaxëna. ¿Jahuë noqui copixëhi ni Dios ra? —i Jesu qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jatsi Jesu nëcaniquë: —Jabi jatiroha ca paxahuahacano tsi noho trono jiaxëní tsi tsahoxëquia nohiria bo ó bësoxëna, naa Nohiria Baquë ë nori cato. Toa xabacá tsi doce ca trono bo ó tsi tsahoxëqui mato ri, naa ëa banahuacanaibá. Israél ca doce ca maxo bo ó bësoxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Jasca, ëa iqui pi jahuë xobo, jahuë ahuini, jahuë xatë bo, jahuë jahëpa, jahuë jahëhua tihi cabo jisbëriaquí tsi cien veces huino jahari bixëqui mato. Jasca, bëso-bësopaoxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jabi toa barí tsi jarësoxëhi quiha huëstima ca jaboqui jariapari cabo, naa rico cabo, chama bo. Jasca, rëquëxëhi quiha huëstima ca jaboqui jacho cabo, naa noitiria cabo, yonati bo —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","‘Jabi noba naipá ca chama-chamaria Dios qui jia tsi xo jacho cabo rëquë iquiina —i Jesu niquë—. Tobi chani quiha huai ibo yoati na. Nicacana. Baquishmarí tsi joni bo bichi quiha naa huai ibo caniquë, jahuë huaí tsi yonocomaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","“Huësti ca parata quiha, naa bari yonoco sueldo mato qui axëquia ra, mato yonoco quëshpi na” i joni bo qui ibo niquë. Jatsi quiha jahuë huai qui jato ja raaniquë yonocoti. Jato qui jia ini quiha ibobá copihaina. ");
INSERT INTO caoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Jatsi quiha mënata bari no tsi yacatá ca plaza qui ibo catëquëniquë joni huëtsa bo mërahi na. Toá tsi niihai ca bamahai ca joni bo ja jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“¿Japa mato tsa ni? Noho huai qui bocata. Jia tsi mato copixëquia ra” i ibo niquë joni bo qui. Jatsi ja bocaniquë yonocoxëna jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","‘Jatsi matoroco bari tsi quiha catëquëniquë ibo, joni bo mëraxëna, ja bax ja yonococano. Jatsi a las tres tsi quiha ja catëquëniquë pa, joni huëtsa bo mëraxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jatsi quiha yata, a las cinco quiha, joni bo mërahi ibo caniquë. Bohohai ca joni bo ja jisni quiha. “¿Jëniriahax tsi nëbi bama-bamacanai ra?” i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yama tsi xo toa noqui yonoco amahaina rë” i jaca ni quiha. Jatsi, “Noho huai qui bocata. Jari tobi yonoco ra” i jato qui ibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","‘Bari caquë tsi quiha ibobá jahuë empleado quënaniquë. Quënahax, “Joni bo quënahuë. Jato copicasquia ra. Jacho ca maxo pari tsi copiti mi chitahëhuano” i jahuë empleado qui ibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Jatsi a las cinco chitahëhuanish ca joni bo pari bëcaniquë. Huësti ca parata, naa bari tëtëca sueldo jato qui ja aniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jatsi huino ca copi biti ó pasoniquë jariapari ca yonocoti chitahëhuanish cabo. Ja bëcaquë tsi quiha huësti roha ca parata, naa bari sueldo ja copihacacaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jato parata bichi tsi ibo ja ranicaniquë. Jato qui yoi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Huësti hora roha ja yonococaquë pë, naa noqui cho bëcanax cabo. Noqui tsi xo toa bari tëtëca yonocohaina rë. Anomaria bari huao quiha. Jama, huësti ca parata roha noqui mi aquë pë, naa jato qui mi aca jascaria” i ibo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Jatsi jato ó ca huësti ca qui ibo chaniniquë: “Huashiyamahai ca ëa xo naa ra. ¿Mato qui jia ma ni huësti ca parata bichiina, naa bari tëtëca yonoco quëshpi na? ‘Jënima’ i ë qui ma quë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Japi mato parata bicahuë. Bocata. Mi qui ë aca ca jaharisi ca naa mato cho bëcanax ca joni bo qui acasquia. ");
INSERT INTO caoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Noho parata ma ni naa ë acaina? Tonia ë qui caxaqui mato rë, mato cho ca jaroha ca maxo qui ë huashiyamaha iqui na” nëa tsi jato qui ibo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ja tsi xo toa rëquëxëhi quiha jacho cabo. Jasca, jachoxëhi quiha jariapari cabo —nëa tsi Jesu jahuë rabëti bo qui nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jabi Jerusalén qui capama tsi quiha jahuë doce ca rabëti bo Jesú catianiquë jamë tsi jato qui chanixëna. Chanipama tsi quiha, ");
INSERT INTO caoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Jerusalén qui caqui noa ra —i jato qui ja niquë—. Toa xo tsi arati iboba chama bo, yoba tiisimacanaibo, tihi cabo qui mëhaacaxëquia rë. “Ja namëhacaxëti xo” icaxëcani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Jatsi pë carayanabo qui ëa mëacaxëcani quiha mahuahacati, rashahacati, namëhacati. Jama, tres bari quirëquë bësotëquëxëquia ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jatsi Jesu qui Juan jahëhua joniquë, naa Zebedeo baquë ba jahëhua. Johax tsi quiha Jesu bësojo tsi ja mëniniquë. Mënixo tsi quiha ja nicaniquë, jahuëcara ca jia ca jahuë baquë bo bax Jesú ano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jatsi, —¿Jahuë ó quëëhai? —i ja qui Jesu niquë. Jatsi quiha, —Noho baquë bo shinahuë. Mana xo yonaquí tsi mia tapaí tsi noho baquë bo mi tsahomano ra, huësti ca mi mënëcayá no, huëtsa mëxojó no —i Jesu qui jahëhua niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jatsi, —Mi baahai ca cahëyamaqui mia ra —i ja qui Jesu niquë. Jatsi jahuë baquë bo, naa Jacobo, Juan, tihi cabo qui Jesu chaniniquë: —¿Tënëti mëtsaxëhi ni mato, naa ë tënëmahacapaimaria jascaria? —iquiina. —Jaahuë. Tënëti mëtsa xo noa ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jatsi, —Jabija. Tënëxëqui mato ra. Jama, noho mënëcayá ca tsahoti, noho mëxojó ca tsahoti, tihi cabo mato qui ati mëtsama xo ëa ra. Toa tsahoti bo bicaxëcani quiha noho Jahëpa qui jia cabo ra. Jato bax ja rohahuahacani quiha —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jatsi Jacobo, Juan, tihi cabo qui caxaniquë diez ca rabëti huëtsa bo, jaha ja quëëcanai ca nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Japi Jesú jato quënaniquë yobaxëna. —Nohiria yonamisxëniria tsi xo país ca chama bo ra. Ja yona-yonamiscanai ca cahëqui mato. Jasca, jato empleado bo tsi xo yonamisxëniria, jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Anoma quiha. Jabi ma tocayamano. Jama, mato yonati manëxëti xo toa oquë ca manëcatsai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Jasca, mato mëbihai ca yonati manëxëti xo toa mato rëquëninicatsai cato, ");
INSERT INTO caoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","naa mato ë mëbihai ca jascaria. Jabi mai qui ë joyamaniquë, ëa nohiria bá mëbino; jama, nohiria mëbiti nori. Jabi ëmë aquia nohiria bo bax nati, jocha quima huëstima ca nohiria paquëmaxëna —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó ax Jesu, jahuë rabëti bo, tihi cabo riquino tsi quiha huëstima ca nohiriá banahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jabi tobi ini quiha bahi tsi rabë ca bëco ca joni bo. Tsaho ja icani quiha. Jabi Jesu tarabihai nori ca nicaquí tsi quënati ja chitahëhuacaniquë. —Noqui shinahuë, David yamaba Baquë́ —iriatsi jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jatsi, —Pasicahuë. Pasicahuë ra —i jato qui nohiria bo niquë. Jama, oquë tsi quënati ja chitahëhuacaniquë. —Noqui shinahuë ra, David yamaba Baquë́ —iria-iriatsi jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jatsi Jesu niiniquë. —¿Jahuë ó quëëcanai? ¿Jënahuaxëhi ni ëa mato bax na ra? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Jatsi, —Taiscasqui noa ra, Ibobá —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jatsi quiha Jesú jato noiniquë. Noixo tsi quiha jato bëro ja motsaniquë. Jatsi taisritsijacaniquë. Jatsi Jesu ja banahuacaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jabi yaca Betfagé, yaca Betania, tihi cabo qui cahëpama tsi quiha rëquë jahuë rabëti bo dos ca Jesú raaniquë. Jerusalén basima ja icani quiha. Raahax, ");
INSERT INTO caoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Mato bësojó ca yaca qui jicocana. Jicoxo tsi nëxë ca burro jisxëqui mato. Ja bëta nii xo jahuë baquë. Jato mëriscana. Mërisxo tsi ë qui jato bëcana. ");
INSERT INTO caoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jasca, “¿Jënixo tsi jato mëriscanai?” i pi tsohuëcara no tsi “Bicatsi quiha Ibo” icana. Jatsi jahuë burro bo raatapixëhi quiha ibo ra —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Jabi tocapijani quiha Quënëhacanish cabo jatihuahacano iquish na. Jabi nëca tsi Dios Chani yoanish cabá quënëniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión yacatá ca nohiria qui chanicana: ‘Tsayacahuë. Mato qui johi quiha mato Rey ra. Ishima chamayama tsi xo. Burró tsaho johi quiha. Nohiria carga bëhai ca chaxpá tsi johi quiha pa’ ” nëa tsi ja quënëni ca nëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jatsi jahuë rabëti bo bocaniquë burro baquë mëraxëna, Jesú yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Bichi tsi quiha burro, jahuë baquë, tihi cabo jahari ja bëcaniquë. Bëxo tsi quiha jato sahuëti bo ja capohuëcaniquë. Jatsi burro cacha Jesu tsahoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jasca, huëstima ca nohiriá jato sahuëti bo poohabonaniquë bahí no, burro rëquë. Jasca, nohiria huëtsa bá mëshi bo quëësaniquë bahí tsi poohaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jatsi quënati rëquë bocanaibo, banahuacanaibo, tihi cabá chitahëhuaniquë: —Chama David yamabá chahitaxocobo joihuacana ra. Shomahuahaca ca tsi xo naa Iboba janë́ tsi johai cato ra. Naipá cabá ocahuano ra —nëa tsi nohiria bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalén qui Jesu jicoquë tsi quiha nohiria quëtsocaniquë. —¿Tsohuë ni naa johaina sa? —i quiha jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Jatsi, —Galileá ca Nazarét ca Jesu tsi xo naa ra. Dios Chani yoati ibo xo ra —i nohiria bo niquë quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Arati xobo qui Jesu jiconiquë. Jicoxo tsi quiha toá ca iniacanaibo cacha ja raaniquë. Raaquí tsi quiha parata rarinamacanaiba mesa bo ja narabaniquë. Jasca, boto iniacanaiba tsahoti bo ja pacanamaniquë. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","—Bëhoxti xobo quënahacaxëti xo noho xobo ra; jama, yomacanaibo iti noho xobo manëmaqui mato pë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jabi arati xobó tsi quiha bëco cabo, tapiyamacanaibo, tihi cabo iniquë. Jesu qui ja bëcani quiha jënimahuahacaxëna. Jatsi jato ja jënimahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jatsi quiha Jesu qui arati ibo bo, yoba tiisimacanaibo, tihi cabo caxaniquë, jiaria ca Jesú ani nori jisi na. Jasca, arati xobó tsi ranihai ca xocobo quënahi ini quiha, “Anomaria tsi xo David yamaba chahitaxocobo ra” iquiina. Jatsi Jesu qui jodioba chama bo caxaniquë toa chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Caxaxo tsi quiha Jesu ja raahacaniquë: —¿Xocobá quënahai ca nicayamahai? Anoma quiha —iquiina. Jatsi Jesú quëbiniquë: —Jato nicaquia ra. Tonia mato ri tsi xo toa Dios Chani cahëyamacanaina ra. “Xocobo mishni bo, xoma acai ca baquë bo, tihi cabo tiisimaqui mia Diós, jia tsi ja ocahua-ocahuariacano iquish na” ii quiha Quënëhacanish cabo —nëa tsi jodioba chama bo qui ja nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jatsi Jesú jato jisbayaniquë. Yaca ax riquihax Betania qui ja caniquë baquicha raaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Huëaquë baquishmarí tsi quiha jahari yaca qui Jesu caniquë. Capama tsi quiha ja paxnaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Jatsi higuera jihui ja jisniquë. Paxnahi tsi bahi tapaí ca higuera jihui qui ja caniquë bimi mëraxëna. Mëquëya ja ini quiha. Pëhi roha quiha. Jatsi quiha higuera jihui qui Jesu chaniniquë: —Bimitëquëpistiayamariaxëqui mia ra —iquiina. Jatsi janotapiniquë higuera jihui ra. ");
INSERT INTO caoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jatsi ratëniquë jahuë rabëti bo ocapijani ca jisi na. Ratëhax, —¿Jënahuariahax jihui janotapiha sa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jatsi Jesú jato quëbiniquë: —Mato parayamaquia. Dios qui pi chitimiyoiquí tsi higuera jihui qui ë aca ca oquë ca axëqui mato ra. Chitimiyoipimano tsi mato nicaxëhi quiha naa macana ra, “Tsëquëhuë. Ia qui niahacahuë” i ja qui ma quë no. ");
INSERT INTO caoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Chitimipiquí tsi ma bënahai ca bixëqui mato, ma bëhoxquë no —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jatsi jahuë arati xoboria qui Jesu caniquë. Toa xo tsi tiisimajahuano tsi quiha ja qui bëcaniquë arati ibo-iboria bo, nohiria yosibo. Bëhax, —Arati xobo quima iniacanaibo mi niahitaquë pë. ¿Tsohuë mi qui chama ani tocati ra? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Quëbihi tsi, —Mato nicapariquia ëa ri. Ea pi ma quëbino tsi toa ë qui toca ca ati chama anish ca mato yoaxëquia. ");
INSERT INTO caoNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Tsohuë Juan yamabo qui chama ani, nohiria bo ashimati? ¿Dios ni? ¿Joni ni? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jatsi ja chaninaparicaniquë: —“Dios” i pi no no tsi “¿jënixo tsi Juan yamabo ma chahahuayamani?” i noqui xëhi quiha pë. Jama, “Joni quima jahuë chama Juan yamabá biniquë” i pi no no tsi noqui caxaxëhi quiha nohiria bo rë. Jatsi, noqui acaxëcani quiha ra, “Dios Chani yoati ibo xo Juan” i jacanai quëshpi na —nëa tsi ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Japi, —Cahëyamaqui noa ra —i Jesu qui jaca niquë. Jatsi, —E qui toca ca ati chama anish ca mato yoayamaxëquia ëa ri —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jatsi jodioba chama bo qui chani Jesú yoaniquë: —¿Jahuë shinacanai, naa chani yoati na? Jabi dos ca baquë quiha joní jayaniquë. Jariapari ca baquë qui jahëpa caniquë chanixëna. Cahax, “Jisa baquë́, huai yonocohi cata” i quiha ja qui jahëpa niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jatsi quiha “Jishopë, cayamaquia ra” i baquë ni quiha. Jama, yata ja caniquë ra yonocohi na, shina paxa ca bichish na. ");
INSERT INTO caoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jatsi quiha jahuë noma qui jahëpa caniquë jasca ca nicaxëna. “Caquia ra” i jahuë noma ni quiha; jama, ja cayamaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Mato nicaquia. ¿Jëni ca baquë ni toa jahuë jahëpa jaha quëëni ca anish cato? —i jato qui Jesu niquë jato nicahi na. Jatsi, —Rëquëmë quiha —i jaca niquë. Jatsi Jesú jato yoaniquë. —Mato parayamaquia ra. Mato rëquë Diós otohai ca qui jicocaxëcani quiha yoixëni ca impuesto bicanaibo, joni mëtsaxëniria cabo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jabi joxo tsi quiha quinia jia ca Juan yamabá mato jismaniquë. Jahuë chani ma chahahuayamaniquë rë. Jama, impuesto bicanaibo, joni mëtsaxëniria cabo, tihi cabá tsi xo toa jahuë chani nicahaina ra. Ja chahahuacanai nori ca jisí tsi mato quinia yoi ca ma casoyamaniquë. Juan yamaba chani ma chahahuayamaniquë rë, (naa noma baquë jascaria) —nëa tsi jodioba chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—Chani huëtsa nicacano —i jodioba chama bo qui Jesu niquë—. Huai quiha joní aniquë. Axo tsi quiha toa xo tsi uva icanai ca bimi ja bananiquë. Jaquirëquë tëamë ca panë ja aniquë. Jatsi quiha maxaxá ca trapichi ja aniquë, jënëria ati. Axo tsi quiha jaha bësoti xobo ja aniquë, naa torre icanai cato. Jatsi joni huëtsa bo qui jahuë huai ibobá aquëniquë bimi xatë quëshpi na. Aquëhax tsi quiha jahari jahuë xobo qui ibo caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tësatiya tsëquëquë tsi quiha jahuë huai obësocanaibo qui jahuë yonati bo ibobá raaniquë jahuë bimi xatë ja bicano. ");
INSERT INTO caoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Jama, ja cahëcaquë tsi quiha jahuë yonati bo qui ja tsamicaniquë. Huësti ca yonati ja rashacani quiha. Huëtsa ja acani quiha. Huëtsa qui maxax bo ja niacani quiha axëna. ");
INSERT INTO caoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jatsi maxo huëtsa ibobá raaniquë, naa jahuë yonati bo. Jasca tsi toa maxo ri ja yosicaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Jarohari tsi jahuë baquë yoi quiha ibobá raaniquë, “Noho baquë qui nicacaxëcani quiha” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Jama, jahuë baquë jisi tsi “Iboba baquë tsi xo naa ra, naa huai bixëti ca ibo. ¿Canomani? Jahuë baquë no ano ra. Jahuë bixëti ca mai no bino” i yonococanaibo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jatsi baquë qui ja tsamicaniquë. Huai cacha niaxo tsi ja acaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","‘Jabi joxo tsi quiha ¿jënahuaxëhi ni huai ibo toa yonococanaibo qui? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jatsi jodioba chamabá quëbiniquë: —Caxaquí tsi toa yoixëni ca joni bo quëyoxëhi quiha ibo ra. Jatsi bimi xatë quëshpi tsi yonococanaibo huëtsa bo qui jahuë huai aquëxëhi quiha, ja bax ja yonococano —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jatsi Jesú jato yoaniquë: —¿Quënëhacanish cabo ó ca ma jisyamani naa yoati na? “Oquënaxëhi quiha yosibá niaha ca Maxaxa ra. Oquë-oquëria ca manëxëhi quiha ra. Diós aca ca tsi xo naa ra. Noqui jia quiha” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","‘Ja tsi xo toa jaboqui tsi mato shomahuacasyamaxo Dios ra. Jaboqui nohiria huëtsa, naa ja bax yonococascanaibo shomahuaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Noitixëhi quiha naa Maxax icanai ca chahahuayamacanaibo tëquë. Toa Maxax icanai cató tsi quëyohacacaxëcani quiha ra. Mai mishpo jascaria tsi jato timaxëhi quiha ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesu chani nicaxo tsi jato yoati tsi ja chanini nori jodioba chama bá cahëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jatsi Jesu qui ja tsamicascaniquë. Jama, nohiria bo qui ja raquëcani quiha, “Dios Chani yoati Ibo xo Jesu” i nohiria bo ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jatsi quiha jodioba chama bo qui chani, naa cuentos Jesú yoaniquë Diós otohai yoati na. Ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Naipá ca chama-chamaria Dios qui jia tsi xo toa jahuë joi bichiina. Jabi tobi quiha rey iniquë. Jahuë baquë bax fiesta-fiestaria ja shomahuaniquë; naa jahuë baquë ahui yahai ca fiesta quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jatsi jahuë yonati bo ja raaniquë joi amahacanish cabo quënaxëna. Jama, ja bëcasyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jatsi yonati huëtsa bo jato qui réy raaniquë. “‘Tsayacahuë. Oriquiti ibobá rohahuaquë ra mato bax na. Jahuë toro bo, jahuë vaca mishni bo, naa xënihuaxëni cabo ja aquë ra piti. Shomahuahacaquë oriquiti ra. Jahuë baquë ahui yahai ca fiesta qui bëcahuë’ i joi amahacanish cabo qui huë” i jahuë yonati bo qui rey niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Jama, ja bocasyamacani quiha. Jahuë huai qui huësti ca caniquë yonocoxëna. Huëtsa jahuë tienda qui caniquë jahuë jahuë bo iniaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jasca, nohiria huëtsa bá toa rey yonati bo qui tsaminiquë rë. Jato ja yosicaniquë. Yosixo tsi quiha jato ja aniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jatsi quiha toa nohiria bo qui caxaniquë rey ra. Caxaxo tsi jahuë soldado bo ja raaniquë jahuë yonati bo anish cabo axëna. Axo tsi quiha jato yaca bo ja mëshacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jatsi jahuë yonati bo réy quënaniquë. Quënahax jato qui ja chanitëquëniquë: “Rohahuahacaquë fiesta ra. No oriquino ra. Jama, toa joi amahacanish cabo jicomayamacana. Anoma ca xo. ");
INSERT INTO caoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jama, bahi rëso qui bocata. Toá ca noitiria cabo qui joi amacana, noho fiesta qui ja bëcano” i jahuë yonati bo qui rey ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Jatsi quiha bahi rëso qui jahuë yonati bo bocaniquë. Nohiria jisi tsi jato ja catiacaniquë fiesta qui bëxëna. Nohiria jiaxëni cabo, nohiria jiayama cabo, tihi cabo ja bëcaniquë. Ja bëcaquë tsi quiha nohiria rëamë tsi fiesta xobo iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","‘Jatsi fiesta xobo qui rey jiconiquë joi amahacanish cabo jisxëna. Jabi toá tsi huësti ca sahuëti jiayama ca sahuëhai ca joni ini quiha. Toa joni réy jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Jisi tsi “Yama tsi xo mi fiesta sahuëti pë. ¿Jënahuariahax raca mi jicoha pa?” i joni qui rey niquë. Jatsi pasihi joni ini quiha, raquëhi na. Chaniyamahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jatsi réy jahuë yonati bo yobaniquë: “Jahuë mëquënë, jahuë tahë, tihi cabo nëxacahuë. Cacha tsëmo qui naa joni niacahuë. Toá tsi araxëhi quiha. Toá tsi tënëxëhi quiha” i rey niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jatsi quiniacaxëcahuë. Huëstima tsi xo toa joi amahacanish cabo. Jama, ichariama tsi xo toa Diós bichiina —nëa tsi Jesu nëcaniquë jodiobá chama bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jatsi quiha jodioba chama bá jisbayaniquë shinacatsi na. Jesu ja paracascani quiha. Jabi yoi ca Jesu ja chanimacascani quiha ja qui quësocasquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Japi jató-na banahuacanaibo, Rey Herodés-na banahuacanaibo, tihi cabo ja raacaniquë Jesu nicati. Ja nëcacaniquë: —Mia ri tsi xo toa parayamahaina, maestró. Paraxoma tsi Dios quinia tiisimaqui mia ra. Tiisimaquí tsi nohiria shinahai ca chahahuayamaqui mia. Mi qui jaharisi tsi xo nohiria tëquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Japi mi shinahai ca noqui mi yoano. ¿Romanoba chama-chamaria qui impuesto bo no ati ni, naa noqui jodiobo? —nëa tsi Jesu qui jodioba chamabo nëcacaniquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jabi ja shinacanai ca yoi nori ca Jesú cahëniquë. Japi, —¿Jënixo tsi nëca tsi ëa tanamacanai pë, paramisxëni cabá? ");
INSERT INTO caoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Gobierno impuesto copihacati ca parata ëa jismacahuë —i jato qui Jesu niquë. Jatsi parata ja qui ja bëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","—¿Tsohuë bëmana jaria ni naa ra? ¿Tsohuë ni naa quënë ibo? —i jato qui Jesu niquë. —Romanoba chama-chamaria janë quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jatsi Jesú quëbiniquë: —Japi romanoba chama-chamaria qui jahuë jahuë bo tëquë acana. Jasca, Dios qui jahuë jahuë yoi bo acana —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jesú yoani ca nicahax ja ratëcaniquë. Ratëxo ja jisbayacaniquë. Ja bëta ja chanicasyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Jaquirëquë jaxaba rohari tsi quiha chama huëtsa bo, naa saduceobo icanai cabo Jesu qui bëcaniquë jato ri. (“Yama tsi xo nohiria bësotëquëhaina” icanish cabo tsi xo naa.) Bëxo tsi Jesu ja nicacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—“Baquë bo yama pi joni rësono tsi jahuë ahui bixëti xo jahuë noma. Bixo tsi jahuë rëquëmë bax xocobo ja saihuaxëti xo” i Moisés yamabo ni quiha, Maestró. ");
INSERT INTO caoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Jabi seis ca noma bo quiha jayapaoniquë joni, naa nëá ca racapaonish cato. Xocobo yama tsi naa joni rësoniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jatsi quiha jahuë xachacató jahuë ahui biniquë. Xocobo saihuahaxma tsi ja rësoniquë jaa ri. Jaquirëquë quiha jahuë noma huëtsá jahuë ahui biniquë. Xocobo saihuahaxma tsi ja rësoniquë jaa ri. Toca tsi jahuë noma bo tëquëtá aniquë. Ja rësoyocaniquë. Huësti ca xocobo ja saihuayamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Jarohapa tsi rësoniquë yoxa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Jabi nohiria bo bësotëquëno tsi ¿tsohuë ahui ni naa yoxa sa? Siete ca bënë ja jayaniquë bësoquí na pa —nëa tsi Jesu qui ja nëcacaniquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jatsi Jesú jato quëbiniquë: —Janyama xo mato ra. Quënëhacanish cabo, Dios chama, tihi cabo cahëyamaqui mato tia. ");
INSERT INTO caoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bësotëquëxo ahui bo, bënë bo, tihi cabo biyamaxëhi quiha nohiria bo, naipá ca ángel bo jascaria iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","¿Quënëhacanish cabo ó ca Diós mato yoani ca ma jisyamani pa, naa nohiria bësotëquëhai yoati na? ");
INSERT INTO caoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abraham, Isaac, Jacob, tihi caba Dios ca ëa xo naa ra” i Dios ni quiha. “Abraham yamabo, Isaac yamabo, Jacob yamabo” i ja yamani quiha ra, bësocanaiba Dios ja nori iqui na —i saduceobo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jatsi nohiria tëquë ratëniquë Jesú tiisimahai ca nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jabi Jesú quëbini iqui tsi saduceobo bërabiniquë. Jaquirëquë Jesu qui fariseobo, naa chama huëtsa bo bëcaniquë nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jabi jato maxo huësti, naa yoba cahëxëni cató Jesu nicaniquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—¿Jëni ca ni toa Dios yoba oquë-oquëria cato, maestró? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jatsi Jesú quëbiniquë: —“Mato joiti tëquë, mato shina tëquë, tihi cabá tsi mato Ibo Dios ma noiti xo” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Oquë-oquëria ca yoba tsi xo naa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Jasca, jaquirëquë ca yoba tsi xo naa: “Nohiria huëtsa bo noicahuë, mamë ma noihai jascaria” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Naa dos ca yoba qui chitimihi quiha Quënëhacanish cabo tëquë —nëa tsi ja qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jari fariseobo manicano tsi quiha Jesú jato nicaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Jahuë shinacanai, johai ca Xabahamati Ibo yoati na? ¿Tsohuë chahitaxocobo ni toa? —iquiina. Jatsi quiha, —David yamaba chahitaxocobo quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jatsi Jesú nicaniquë: —Dios shina rëamëquí tsi ¿jahuë chahitaxocobo “Ibo” David yamabá quënayamayamani? ¿Jënihax “Ibo” i ja ni, jahuë chahitaxocobo yoati tsi chanihi na? ");
INSERT INTO caoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Noho mënëcayá tsi tsahotsina, jariapari mia pasomaha cabo ë bëbono, jato mi yonano iquish na’ i noho Ibo qui Ibo Dios ni quiha” nëa tsi David yamabo nëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Noho Ibo” jahuë Xabahamati Ibo ja quënaniquë ra. “Ibo” pi jahuë chahitaxocobo no tsi ¿jënahuahax jahuë chahitaxocobo ii ni Cristo ra? —nëa tsi jato qui Jesu nëcaniquë nicahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jatsi fariseobo pasiniquë. Quëbitima-xëni ja icani quiha. Jaquirëquë jodioba chama bá Jesu nicatëquëpistiayamarianiquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jatsi mani ca nohiria, jahuë rabëti bo, tihi cabo qui Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Jabi nohiria bax Moisés yoba bërohuahi quiha fariseobo, yoba cahëxëni cabo. Jato yonoco quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Japi mato ja yoacanai ca yoba tëquë ma chahahuati xo. Jato nicacana. Jama, jato jabi banahuayamacana ra. Anoma quiha. Ja yoacanai ca yoba yoi ayamacani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nicatimaxëni ca yoba bo nohiria qui acani quiha pë ati, jama ja yoacanai ca yoba nicacanaibo jaca nomari. ");
INSERT INTO caoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Jato jabi quiha pë. Jatiroha ca acani quiha pë, nohiria bá jato tsayano iquish na. Papi mishni bo, naa Dios Chani jaya ca papi sahuëcani quiha pë. Toa papi banëxëcani quiha nohiria jismaxëna. Jato jabi quiha. Jasca, nohiria ba sahuëti bo huino xo jato sahuëti bo pë, nohiria oquë jaca nori quëscahuahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nohiria bo oriquino tsi oquë ca tsahoti bo bicascani quiha pë. Jato catiti xobó ca rëquë ca tsahoti bá tsi tsahocascani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jasca, bahi xo tsi joihuahacacascani quiha. Jato qui jia quiha “Maestro” quënahacahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","‘Jama, “Maestro” ma quënahacayamaxëti xo iquia, huësti roha ca maestro ma jaya ca iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Jasca, mai xo tsi “Jahëpa-jahëparia” joni quënayamacana. Huësti roha ca tsi xo toa mato Jahëpa-jahëparia, naa mato naipá ca Jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Maestro-maestroria” ma quënahacayamati xo, mato huësti ca Maestro-maestroria roha ca Cristo nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mato yonati iti quiha mato ó ca oquë cato. ");
INSERT INTO caoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jabi rabihuahacaxëhi quiha jamë oquëhuahai cato. Jama, oquëhuahacaxëhi quiha yonati jascaria ca manëhai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","‘Noitiria tsi xo mato, yoba tiisimacanaibá, fariseobá. Paramisxëni xo mato ra. Ma tiisimahai iqui tsi Diós otohai ca qui jicotimaxëni xo nohiria bo rë. Jasca, jicocasyama xo mato ri. Jabi nohiriá pi chahahuacasno tsi jato chitiaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","‘Noitiria xo mato, yoba tiisimacanaibá, fariseobá. Paramisxëni xo mato ra. Imanish ca yoxa bo paraqui mato pë, jato jahuë bo bixëna. Paraquí tsi jato xobo bo mëbiqui mato pë. Mëbihax Dios qui chani tëtëca bëhoxqui mato nohiria bo paraxëna. Quësohacaxëqui mato ra. Oquëxëhi quiha mato copi ri ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","‘Noiti xo mato yoba tiisimacanaibá, fariseobá. Paramisxëni xo mato ra. Nëama bocaqui mato pë, nohiria mërahi na, jato jabi bo rarinamaxëna. Jato jabi bo rarinamaxo tsi mato oquë tsi jato rohahuaqui mato, tënëtiya qui ja bocano, naa ma bocanai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","‘Noitiria xo mato, mato bëco ca rëquëninicanaibá. Anoma tsi xo toa ma tiisimahaina ra. “Arati xobó tsi axëquia” i nohiria quii tsi jatihuahacayamaxëti ca ma yoaha ca nori ca quëscahuaqui mato pë. Tocaqui mato pë, jurar-aqui na. (Jatsi ma yoaha ca iqui tsi ma axëhai nori ca quëscahuacani quiha nohiria rë.) Jama, “Arati xobó ca oro ca jahuë bá tsi axëquia” i jato quii tsi “Jatihuahacayoixëti xo no yoahaina” iqui mato pa. ");
INSERT INTO caoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Jisna. Cahëtimaxëniria ca bëcoxëniria ca xo mato ra. ¿Jënahuariahax arati xobó ca oro ca jahuë bo oquë ina? ¿Oquë ma ni Dios arati xobo ra? Dios roha tsi xo toa oro ca jahuë bo oquëhuati ibo cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jascaria tsi “Altár tsi axëquia ra” i nohiria quii tsi jatihuahacayamaxëti ca ma yoaha ca nori ca quëscahuaqui mato pë. (Jatsi ma yoaha ca iqui tsi ma axëhai nori ca quëscahuacani quiha nohiria rë.) Jama, “Altar ó ca janahaca jahuë bá tsi axëquia ra” i jato quii tsi “Jatihuahacayoixëti xo no yoahaina” iqui mato pa. ");
INSERT INTO caoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Jisna. Bëcoria xo mato ra. ¿Jënahuariahax altar ó ca Dios qui ma janaha ca oquë ina? ¿Oquë ma ni Dios altar? Dios altar tsi xo toa ma janaha ca oquëhuahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Jishopë. “Altár tsi axëquia ra” iqui mato pë, nohiria bo paracatsi na. Jama, “Altár tsi axëquia ra” imahai ca tsi xo toa “Altar ó ca janahaca cató tsi axëquia ra” imahai ca jascaria. Jaharisi ca xo. ");
INSERT INTO caoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jasca, “Arati xobó tsi axëquia ra” iqui mato pë, nohiria bo paracatsi na. Jama, “Arati xobó tsi axëquia ra” ipii tsi “Jaha ca bësohai ca Dios janë́ tsi axëquia ra” iyoiqui mato ra. Jaharisi tsi xo toa dos ca yoahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jasca, “Naipá tsi axëquia” iqui mato pë, nohiria bo paraxëna. Jama, “Naipá tsi axëquia” ipii tsi “Naipá ca tronó ca tsaho ca Dios janë́ tsi axëquia” iyoiqui mato ra. Jaharisi tsi xo toa dos ca yoahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","‘Noitiria xo mato, yoba cahëxëni cabá, fariseobá. Paramisxëni xo mato ra. Jabi ma tësaha ca yochi bo, naa mato menta, anís, comino, tihi cabo quima décima ca Dios qui aqui mato, mato yoba nicariaxëna. Tocaquí tsi Dios oquë-oquëria ca yoba nicayamaqui mato pë. ¿Japa? ¿Mabë xatë bo mëbicanai? ¿Noiyoicanai? ¿Dios chahahuayoicanai? Toca tsi ma ati nori iquë, mato yoba huëtsa bo niaxoma. ");
INSERT INTO caoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Bëco ca rëquëniniti ibo bo xo mato pë. Iriama ca yoba bo nica-nicapama tsi Dios oquë-oquëria ca yoba bo mataraqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","‘Noitiria xo mato, yoba cahëxëni cabá, fariseobá. Paramisxëni xo mato ra. Mëchocoha tsi xo mato mëquë bo. Mëchocoxo piquí tsi mato jabi bo nicariaqui mato; mahitsa quiha. Jahuëmishni bo ó quëëmisxëniria xo mato ra. Yoixëni ca xo mato shinana. ");
INSERT INTO caoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Jariapari tsi mato shina bahuëcana, bëcoria ca fariseobá. Mato shina pi bahuëhacano tsi jiaxëhi quiha mato jabi ri. ");
INSERT INTO caoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","‘Noitiria xo mato, yoba cahëxëni cabá, fariseobá. Paramisxëni xo mato. Joxohuahaca ca maihuati xobo bo jascaria xo mato ra. Jiaria tsi xo toa xobo cacha cato; jama, jaxara tsi nohiria xao bo, pisiria ca jahuë bo, tihi cabo jaca nori. ");
INSERT INTO caoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Toca xo mato ri. Nohiria bo qui jia jisiria xo mato jabi bo; jama, quiamisxëni ca jochahuaxëniria ca mato shina nori. ");
INSERT INTO caoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","‘Noitiria xo mato, yoba cahëxëni cabá, fariseobá. Paramisxëni xo mato. Jiaria ca maihuati xobo bo aqui mato, mato Dios Chani yoanish cabo bax na. Toca tsi jato oquëhua-casqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Tsayacahuë. Mato naaborëquëbá Dios Chani yoanish cabo aniquë pë. Jama, “Toatiyá pi bësorohaquí tsi jato ayamaquë no aniquë ra” iqui mato pë jaboqui. ");
INSERT INTO caoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Jabija. Jato ati iboba chahitaxocobo ma nori ca jismaqui mato ra, toca tsi ma chaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ma acatsai ca acahuë. Mato naborëquëbá chitahëhuani ca yonoco jatihuacana iquia ra. ¿Jaboqui ëa acasyamacanai? ");
INSERT INTO caoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","‘Rono bá, rono ba xocobá. Tënëtiya qui raahacaxëqui mato iquia. ¿Jënahuariahax toa copi ma paxana? ");
INSERT INTO caoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ja tsi xo toa Dios Chani yoacanaibo, yosibo, yoba cahëxëni cabo, tihi cabo mato qui raaxëquia Dios Chani nicamaxëna. Jatsi jato xatë axëqui mato. Jato xatë cruzó tsi tooxaxëqui mato. Huëtsa bo rashaxëqui mato pë mato catiti xobo xo na. Huëtsa bo chibaxëqui mato, yaca huëtsa, yaca huëtsa jato mërabonaquí na. Tihi tsi axëqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Jaha tsi mato qui japahacaxëhi quiha Dios copi ra, jatiroha ca acacanish cabo quëshpi na. Jariapari Abel acacaniquë. Jaquirëquë huëstima ca Dios Chani yoanish ca huëtsa bo acacani quiha. Jarohapa tsi Zacarías, naa Berequias baquë acacaniquë. Jabi altar, arati xobo naxërëquë xo tsi Zacarías ja tëpascaniquë. Tocanoma tsi xo toa acacanish cabo ra, naa Abel tëpas-hacanitiya rohari. ");
INSERT INTO caoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Mato parayamaquia. Copihacaxëti xo jaboqui ca bësocanaibo, jatiroha ca acacanish cabo quëshpi na iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","‘Jisa Jerusalén, Jerusalén ca nohiriá. Jisa, Dios Chani yoanish cabo ati ibobá. Jisa, Diós raani ca Chani bëcanaibo acanaibá. ¡Erama! Mato otocasquia ra, naa jahuë pëhi namá jahuë xocobo patiarí otohai jascaria. Jama, ëa biyamaqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Iquë ra. Diós mato niabëriaquë rë. Quëyohacaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jasca, ëa jistëquëyamariaxëqui mato, “Shoma tsi xo Iboba janë́ tsi johai cato” i ma xëquë rohari —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jabi jodioba arati xobo Jesú jisbayaniquë. Jisbayajahuano tsi quiha ja qui jahuë rabëti bo bëcaniquë jato arati xobo bo tsayamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Tsayapama tsi jato qui Jesú chaniniquë: —Jia tsi xo naa ma tsayacanaina. Mato parayamaquia. Potas-hacaxëhi quiha naa arati xobo bo tëquë ra. Matsami matsami niiyamaxëhi quiha jahuë maxax bo; huësti ca yama nomari —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Maca Olivo Ya icanai cató tsi Jesu tsahono tsi quiha ja qui jahuë rabëti bo bëcaniquë. Jahuë rabëti bo roha quiha. —¿Jënino tsi ocapixëhi ni naa mi yoahaina ra? Noqui yoahuë. ¿Jënahuariaxo tsi cahëxëhi ni noa, naa mi bacahaina, xaba rëso, tihi cabo tsëquëxëquë no? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jatsi Jesu nëcaniquë: —Quiniacaxëcahuë, ma parahacayamano. Joxëhi quiha huëstima ca noho janë́ tsi chanicanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Joxo tsi huëstima ca nohiria paracaxëcani quiha rë, “Cristo xo noa” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jasca, país bo nianahaina, país ca xërëquë ca nohiria iquinahaina, tihi cabo nicaxëqui mato ra. Nicahi tsi raquëyamacana. Ocapixëhi quiha ra; jama, jari xaba rëso ja nomari. ");
INSERT INTO caoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","País huëtsa pasomaha nianaxëhi quiha país huëtsa. Chama huëtsa pasomaha iquinaxëhi quiha chama huëtsa. Jasca, toatiyá tsi oriquiti biniaxëhi quiha nohiria bo rë. Jasca, yajoriaxëhi quiha mai. Toca tsi ja ixëti quiha jamëri ca iti bá no. ");
INSERT INTO caoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Jama, jariapari ca nohiria bá tënëhai ca chitahë roha tsi xo naa ra. Oquënaxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","‘Jatsi mato qui tsamicaxëcani quiha. Chama bo qui mato mëacaxëcani quiha acacati. Ea iqui tsi mato qui caxaxëqui jatiroha ca país ca nohiria. ");
INSERT INTO caoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Toatiyá tsi Dios quima bësocaxëcani quiha huëstima ca nohiria. Jabë xatë bo pasomaha chanicaxëcani quiha rë. Jabë xatë bo qui caxacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Jatsi jisiquixëhi quiha huëstima ca mahitsa ca Dios Chani yoacanaibo. Jisiquiquí tsi huëstima ca nohiria paracaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Toatiyá tsi pacanaxëhi quiha jochahaina. Janacaxëhi quiha nohiria bá noihaina; ");
INSERT INTO caoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","jama, jahuë rëso qui tënëcanaibo xabahamahacaxëti nori. ");
INSERT INTO caoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Jasca, jatiroha ca maí ca nohiria qui yoahacaxëti xo Dios Chani, naa ja otohai yoati na. Jabija ca Chani nicaxëhi quiha nohiria bo tëquë. Jaquirëquë tsëquëxëhi quiha jahuë rëso. ");
INSERT INTO caoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","‘Toatiyá tsi Dios arati xobo, naa iti-itiriá tsi niixëhi quiha quëyomisxëni ca yoiria cato, naa Daniel yamabá yoani jascaria. Jabi naa quënëni ca tsayahai cató cahëno ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Naa quëyomisxëni ca yoiria ca jisi tsi maca bo qui jabaxëti xo jodioba maí cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Jahuë xobo qui jicoyamaxëti xo xobo cacha ca nohiria jahuë jahuë bo bixëna. Ja bamayamano. ");
INSERT INTO caoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Jasca, jahuë sahuëti biti bacayamaxëti xo huaí ca yonocohai cato. Ja bamayamano. ");
INSERT INTO caoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Toatiyá tsi noitixëhi quiha tohoya ca yoxa bo, baquë pistia ico cabo. ");
INSERT INTO caoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dios qui bëhoxcana, matsitiyá tsi joiti barí tsi ma jabayamano. ");
INSERT INTO caoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jabi mai nëhohuahacanitiya rohari tsi huëstima ini quiha nohiria bá tënëhaina. Jama oquë-oquëriaxëhi quiha naatiyá ca ja tënëcaxëcanaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Jama, toa tënëti xaba pi Diós namahuayama-rohano tsi yama ca nohiria xabahamahacahai quë aquë. Ja bini ca nohiria bo bax toa xaba namahuaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","‘Jatsi “Nëá xo noqui Xabahamati Ibo, tsayapa. Toá xo ra” i pi tsohuëcara no tsi jato chahahuayamacana. ");
INSERT INTO caoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Toatiyá tsi jisiquixëhi quiha mahitsa ca Cristo bo. Jisiquixëhi quiha mahitsa ca Dios Chani yoacanaibo. Jisiquixo tsi jisti bo acaxëcani quiha pë, Diós bini ca nohiria bo paraxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Nicacahuë. Jaboqui mato yobapariquia, ocapijanox pari no. ");
INSERT INTO caoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Jasca, “Xabachá xo Cristo” i nohiria no tsi boyamacahuë. “Nëá xo, jonë quiha” i jaca no tsi jato chahahuayamacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Bajrahai ca canapa nai shitahai ca jascariaxëhi quiha Nohiria Baquë johaina. Mëri tsi ixëhi quiha ë johaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jabi yohina pi rësono tsi catitapicani quiha poico bo. Jahuë pisi quiha. Jascaria tsi, jocha oquë-oquëriano tsi joxëhi quiha Nohiria Baquë jahuë ángel bo ya. ");
INSERT INTO caoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","‘Anomariaxëhi quiha toa tënëtiya ra. Jaquirëquë tsëmonaxëhi quiha bari. Nai ax paquëxëhi quiha naipá ca huishti bo. Yajohacaxëhi quiha naipá ca jahuë bo. ");
INSERT INTO caoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jatsi naipá tsi jisiquixëquia, naa Nohiria Baquë ë nori cato. Jatsi araxëhi quiha maí ca nohiria bo tëquë. Jatsi tsëmó tsi ë johai ca jiscaxëcani quiha. Noho chama, noho oquë, tihi cabo jiscaxëcani quiha ë joquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Jasca, xoohacaxëhi quiha trompeta joi pistiamá no. Jatsi jatiroha ca quinia, naa norte, sur, este, oeste, tihi cabo qui noho ángel bo raaxëquia. Noho nohiria, naa ë bini cabo catiacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","‘Jabi higuera jihui jisti tsayano. Ja botoxpino tsi basima xo oitiya. Toa cahëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jascaria, ë yoaha ca jahuë bo chitahëno tsi basima tsi xo toa ë johaina. Joti basima xo ëa. ");
INSERT INTO caoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Mato parayamaquia. Jabi naatiyá ca bësocanaibo rësonox pari no tsi ocapixëhi quiha ë yoahana. ");
INSERT INTO caoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Huinocaxëhi quiha naipa, mai, tihi cabo; jama, huinoca-pistiayamariaxëhi quiha noho Chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","‘Jabi yama tsi xo toa ë johai ca bari hora cahëhaina. Cahëyamahi quiha naipá ca ángel bo. Cahëyamaquia ëa ri, naa Dios Baquë ë nori cato. Toa bari cahëhi quiha Jahëpa Dios roha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","‘Jabi ë jono tsi ë noho pasoyamacaxëcani quiha nohiria rë, naa Noé tiyá jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Toatiyá tsi Dios shinayamaquí tsi jënë ó ja pasoyamacaniquë. Raquëxoma tsi ja picani quiha. Jënë aii ja icani quiha. Ahui yahaii ja icani quiha. Ja tocacaniquë noti chahitaxëni ca qui Noé jiconox pari no. ");
INSERT INTO caoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Jënë baihai ca ó ja pasoyamacani quiha. Jarohapa tsi jënë́ tsi ja quëyohacacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","‘Toatiyá tsi yonocobëquihi ixëhi quiha dos ca joni bo huai xo na. Mëbihacaxëhi quiha huëstita. Jisbëriahacaxëhi quiha huëtsa. ");
INSERT INTO caoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Tobixëhi quiha dos ca yoxa bá xëqui timabëquinahaina. Mëbihacaxëhi quiha huëstita. Jisbëriahacaxëhi quiha huëtsa. ");
INSERT INTO caoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","‘Japi jaha bësocahuë, mato ibo johai ca bari ma cahëyamahai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yomaxëni ca johai ca hora pi cahërohahi tsi xobo ibo oxayamaquë aquë ra. Yomaxëni ca qui ja tsamiquë aquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Japi shomahuahacacana, ë noho ma pasomayamahai ca barí tsi ë joxëhai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","‘¿Tsohuë ni toa empleado jiaxëni cato, naa chahahuahacati cato? ¿Tsohuë bixëhi ni chama, jahuë yonati bo ototi, jato orihuati? ¿Jahuë yonati jiaxëni ca biyamayamaxëhi ni? ");
INSERT INTO caoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ja qui jahuë chamá aca ca yonoco pi aii tsi ranixëhi quiha toa empleado, jahuë chama joxëquë no. Ja acai ca jisxëhi quiha jahuë chama ra. ");
INSERT INTO caoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jatsi jahuë empleado jia ca qui oquë ca yonoco axëhi quiha, naa jahuë jahuë bo tëquë ototi. ");
INSERT INTO caoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Jama, yonati yoi ca iipihi tsi “Bamaxëhi quiha noho chama” jamë ixëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Jatsi jahuë chama yonati bo rashati chitahëhuaxëhi quiha pë. Pahëcanaibo ya oriquiti chitahëhuaxëhi quiha. Jënë aii quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Jatsi bacaxëhi quiha jahuë chama, naa jaha ja pasoyamahai ca barí no. ");
INSERT INTO caoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Bacaxo tsi raquëria ca nicamisxëni cabá copi toa empleado yoi ca qui axëhi quiha. Toá tsi ara-araxëhi quiha toa empleado nicamisxëni cato. ");
INSERT INTO caoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","‘Jabi tsëquëxëhi quiha Diós otohai ca bari ra. (Jaha bësocana.) Toa barí tsi nëcaxëhi quiha nohiria, naa chani jascaria. Jabi tobi quiha diez ca yoxajahi bo iniquë. Baquichá tsi quiha jato lamparina bo ja tsamacaniquë, ahui yahi johai ca joni bëchaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jabi cinco ca yoyoxëni ca yoxajahi bo ya ini quiha, cinco ca tiisi jaya ca huëtsa cabo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Jabi yoyoxëni cabá jato lamparina bo boniquë aceite yama. Aceite ja shina-bënocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jama, tiisi cabá aceite boniquë jato lamparina boquí na. ");
INSERT INTO caoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jatsi quiha ahui yahai ca bamaniquë. Manahi tsi yoxajahi ba bëro coshinaniquë. Jatsi oxatsijacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Jatsi baquichá tsi quiha tsohuëcara ca quënahai ca joi ja nicacaniquë, naa “Jaboqui cahëhi quiha ahui yahai cato ra. Bëchahi bëcahuë” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jatsi quiha joiniquë yoxajahi bo. Joixo tsi jato lamparina bo ja shomahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Jatsi quiha “Aceite pistia noqui ahuë. Nocapaima tsi xo noba lamparina bo rë” i tiisi cabo qui yoyoxëni cabo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jatsi quiha, “¿Jënahuariaxo mato qui no ana? No narismitsa. Oquë tsi xo tienda qui ma bocanaina copixëna” i jato qui tiisi ca yoxajahi bo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Jatsi quiha yoyoxëni ca yoxajahi bo bocaniquë aceite copixëna. Ja copicano tsi quiha ahui yahai ca cahëniquë. Jatsi quiha ja bëta fiesta qui rohahuahacanish ca yoxajahi bo jiconiquë. Ja jicoyocaquë tsi quiha caiti japahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jaquirëquë ja cho tsi quiha fiesta qui cahëcaniquë yoxajahi bo huëtsa bo. Cahëxo tsi quiha ja quënacaniquë: “Japëcahuë, taitá. Noqui jicomahuë ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jatsi quiha, “Mato cahëyamaquia ra” i jato qui ahui yahai ca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","‘Japi jaha bësocahuë, ë johai ca bari ma cahëyamahai quëshpi na —nëa tsi Jesu nëcaniquë chani yoahi na—. ");
INSERT INTO caoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","‘Jabi Diós otohai ca tsëquëno tsi copihacaxëhi quiha nohiria bo. Naa chani nicacahuë. Tobi quiha chama iniquë. Nëama país huëtsa qui ja cacasni quiha. Jabi canox pari tsi quiha jahuë yonati bo ja quënaniquë. Quënaxo tsi quiha jahuë parata jato qui ja prestahuahaniquë ja bax anihuati. ");
INSERT INTO caoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Huësti ca yonati qui cinco mil ca pesos ja aniquë. Yonati huëtsa qui dos mil ca pesos ja aniquë. Huëtsa qui un mil ca pesos ja aniquë. Jabi oquë ca tiisi jaya ca yonati qui huino ca parata ja ani quiha. Tiisiriama ca qui nama ca ja ani quiha. Parata axo tsi quiha ja jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jabi bamayamaniquë toa cinco mil ca pesos bichish ca yonati. Ja iniahai cató tsi quiha toa parata ja anihuaniquë. Toca tsi quiha cinco mil ca pesos ganancia ja aniquë ra jahuë chama bax na. ");
INSERT INTO caoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jabi tocaniquë dos mil ca pesos jaya ca ri. Dos mil ca pesos ganancia ja ani quiha jahuë chama bax na. ");
INSERT INTO caoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jama, un mil ca pesos bichish ca caniquë jahuë parata ya. Caxo tsi quiha maiquiní tsi jahuë chama parata ja maihuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","‘Naama tsi quiha, naa xëni huëtsá tsi quiha jato chama bacaniquë. Bacaxo tsi quiha jato qui ja prestahuahani ca parata ja bënaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jatsi quiha jariapari ca yonati, naa cinco mil ca pesos binish ca joniquë. Joxo tsi quiha jahuë chama qui jahuë cinco mil ca pesos jahari ja mëaniquë. Chamá-na quiha. Jatsi quiha chama qui cinco mil ca pesos huëtsa ja mëaniquë. Jahuë ganancia quiha. “Cinco mil ca pesos ë qui mi aniquë, taitá. Tsayahuë. Nëá xo cinco mil ca pesos huino, naa ganancia mi bax ë acana ra” i jahuë chama qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Jatsi quiha chama chaniniquë: “Jia tsi xo toa mi acana ra, yonati jiaxëni cató. Jia tsi noho parata pistia mi otoquë ra, negocio acaina. Ja iqui tsi oquë ca yonoco mi qui axëquia ati. Noho xobo qui jicohuë. No raninabëquino ra” i jahuë yonati qui chama niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jatsi quiha dos mil ca pesos binish ca yonati joniquë. Johax, “Dos mil ca pesos ë qui mi aniquë. Tsayapa. Nëá xo dos mil ca pesos huino quiha, naa ganancia mi bax ë acana ra” i jahuë chama qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Jatsi quiha ja qui jahuë chama nëcaniquë: “Jia tsi xo toa parata pistiá tsi negocio mi acana ra. Ja iqui tsi oquë ca yonoco mi qui axëquia ototi. Noho xobo qui jicohuë. No ranibëquinano ra” i ja qui chama ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jatsi quiha un mil ca pesos binish ca yonati joniquë. Johax, “Noiyamahai ca joni mi iqui ca ë nicaniquë, naa nohiria huëtsa bá banaha ca sayaha ca tihi cabo tësahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Japi ë raquë-raquëniquë. Raquëhi tsi mi parata ë maihuaniquë bënoyama-xëna. Tsayapa, nëá xo mi parata ra. Mí-na quiha” i chama qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jatsi quiha chama chaniniquë: “Yoixëni ca chiquixëniria ca yonati xo mia ra. Noiyamahai ca joni ë iqui ca mi cahëniquë. Jabija, noho yonati bá banaha ca sayaha ca, tihi cabo tësahai ca ëa xo naa. ");
INSERT INTO caoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Jëniriaxo tsi banco qui noho parata mi ayamani pa, ganancia bixëna? Jatsi joxo tsi noho parata yoi, jahuë banco ganancia, tihi cabo ë biquë aquë ra” i toa yonati qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Jatsi quiha toá ca mani cabo qui chama chaniniquë: “Jahuë mil ca pesos mëbicahuë. Toa cinco mil ca jaya ca yonati qui acahuë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Jabi huino ca copi bicaxëcani quiha jaya cabo, naa Dios bax yonococanaibo. Biniayamacaxëcani quiha. Jama, jahuë pistia roha ca bënoxëhi quiha yonocoyamahai cato. ");
INSERT INTO caoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Japi cacha tsëmo qui naa chiquixëni ca yonati niacahuë. Toá tsi ara-araxëhi quiha tënëhi na” i chama ni quiha —nëa tsi Jesu nëcaniquë naa chani yoahi na—. ");
INSERT INTO caoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","‘Jabi anomariaxëhi quiha toa barí tsi ë joxëhaina. Noho ángel bo ya tsi joxëquia, naa Nohiria Baquë ë nori cato. Johax noho trono-tronoriá tsi tsahoxëquia. ");
INSERT INTO caoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Jatsi ëa tëamë tsi caticaxëcani quiha maí ca nohiria bo tëquë. Jatsi nohiria bëquëxnamaxëquia, naa chibo quima jahuë oveja obëso cató tsëcahai ca jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Jahuë mënëcayá tsi oveja bo janahi quiha, chibo jahuë mëxojó no. ");
INSERT INTO caoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Jabi tocaxëquia ëa ri, naa chama-chamaria ë nori cato. Tocahax noho mënëcayá ca nohiria bo qui chaniparixëquia: “Bëcahuë, noho Jahëpá shomahuani ca ma bino ra. Naama tsi quiha ja rohahuahacani quiha, naa mai nëhohuahacanitiya rohari. ");
INSERT INTO caoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","E paxnano tsi ëa ma pimaniquë ra. E tëshinaquë tsi jënë ëa ma amaniquë ra. E co-coquë tsi mato xobo qui ëa ma jicomaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Sahuëti ë narisquë tsi ëa ma shomahuaniquë. Preso qui ë nanëhacaquë tsi ë qui ma shishoniquë” nëa tsi jato qui nëcaxëquia. ");
INSERT INTO caoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jatsi, “¿Jënino tsi mia no pimani pa, Ibobá, naa mi paxnaquë no? ¿Jënino tsi mia jënë no amani sa, naa mi tëshinaquë no? ");
INSERT INTO caoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Co-cohi tsi no bëta mi chitëni pa? ¿Jënino tsi mia no joihuani pa? ¿Jënino tsi sahuëti mi qui no ani, naa tsoboco mi iquë no? ");
INSERT INTO caoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Mi iquiquë tsi preso xara mi iquë tsi ¿jënino tsi mi qui no shishoni pa?” Tihi tsi i ë qui xëhi quiha mëstëhuahacahax cabo, quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Jatsi, “Nëa xo tsi ëbë xatë iriama cabo shomahuaquí tsi ë bax ma tocaquë ra” ixëquia. ");
INSERT INTO caoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jaquirëquë mëxojó ca nohiria bo qui chanixëquia: “Tori bocahuë. Yoshihuahacati xo mato ra. I-ipaohai ca chihi, naa Yoshini, jahuë ángel yoixëni bo, tihi cabo bax rohahuahacani ca chihi qui bocata. ");
INSERT INTO caoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Paxnahëquë tsi ëa ma pimayamaniquë pë. E tëshinaquë tsi ë qui jënë ma ayamaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","E co-coquë tsi mato xobo qui ëa ma jicomayamaniquë pë. Sahuëti ë narisquë tsi ëa ma mëbiyamaniquë pë” nëa tsi jato qui nëcaxëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jatsi ëa quëbicaxëcani quiha: “¿Jënino tsi mi iquini pa? ¿Jënino tsi mia no mëbiyamani pa, naa preso qui mi nanëhacaquë no? Cahëyamaqui noa ra” tihi tsi i ë qui caxëcani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jatsi, “Parayamaquia. Ebë xatë iriama cabo pi mëbicasyamaquí tsi ëa yoi ma mëbicasyamaniquë pë” i jato qui xëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Jatsi raahacacaxëcani quiha naabo. Tënë-tënëpaocaxëcani quiha. Jama, bëso-bësopaocaxëcani quiha mëstëhuahacahax cabo ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Nohiria bo tiisimahax tsi quiha jahuë rabëti bo qui Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Dos bari tsi chitahëxëhi quiha pascua fiesta. Toatiyá tsi chama bo qui mëahacaxëquia rë. Cruzó tsi ëa namëcaxëcani quiha —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Toatiyá tsi quiha Caifás xobo-xoboria tsi jodioba chama bo catiniquë. Toá mani ini quiha arati iboba chama bo, jodioba yosibo. ");
INSERT INTO caoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Toá tsi ja chaninacani quiha Jesu yoati na. Parahax tsi ja qui ja tsamicascani quiha namëxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—No quiniati xo ra. Anoma tsi xo fiesta no tsi ja qui no tsamihaina ra. Caxaxëhi quiha nohiria bo tia —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jabi yaca Betaniá tsi Jesu iniquë, naa bonohuaxëni ca Simón xobó no. ");
INSERT INTO caoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Toá ja no tsi quiha ja qui yoxa joniquë alabastro icanai ca botella ya. Perojome rëamë ja ini quiha. Joxo tsi quiha naa copixëni ca perojome jahuë mapo qui ja japaniquë, ja oriquiquë no. ");
INSERT INTO caoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jatsi yoxa qui jahuë rabëti bo caxaniquë ja aca ca jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","—¿Jëniriaxo tsi toa perojome mi yoshihuaha rë? Copixëni quiha. Huëstima ca parata quëshpi tsi naa perojome iniahacati nori iquë rë noitiria cabo qui ati —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jabi ja chanicani nori ca Jesú cahëni quiha. Cahëhax, —¿Jënixo tsi naa yoxa yosicanai pë? Jiaria tsi xo toa ë bax ja acana ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Mato bëtarohahi quiha noitiria cabo; jama, ëa ti tsi xo toa mato bëta naamayamahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Noho yora qui perojome ja japahai cató tsi ëa ja rohahuaquë maihuahacati. ");
INSERT INTO caoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ja aca ca nicaxëhi quiha maí ca nohiria bo tëquë, naa Dios Chani yoahacahai cató no. Jatsi naa yoxa shinaxëhi quiha nohiria bo, nicaxo na —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jatsi arati ibobá chama bo qui Judas caniquë, naa Iscariote yaca ax jonish cato. Jesu doce ca rabëti bo ó ca huësti ca ja ini quiha. Cahax, ");
INSERT INTO caoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—¿Jahuë tihi ca parata ë qui acaxëcanai Jesu quëshpi na? Mato qui mëaxëquia —i jato qui Judas niquë pë. Jatsi Judas qui treinta ca parata copixëni ca quiha ja acaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Bixo tsi quiha jato qui Jesu mëati xaba jia ca mërati ja chitahëhuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Jabi pascua fiesta bari bo tsëquëquë tsi quiha naa jariapari ca barí tsi levadura yama ca mapari jodiobá piniquë. Jato jabi quiha. Jatsi toa barí tsi quiha Jesu qui jahuë rabëti bo bëcaniquë. —¿Jahuënia xo tsi pascua oriquiti rohahuaxëhi ni noa sa, pixëna? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Tobi yacatá ca joni quiha. Ja qui bocata. “‘Basima tsi xo noho xabaca’ ii quiha Maestro” i ja qui cana. “Mi xobo xo tsi jahuë rabëti bo yaxo tsi pascua oriquiti picatsi quiha” i ja qui cana —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jatsi jahuë rabëti bo bocaniquë Jesú yoani ca axëna. Toa xo tsi quiha pascua oriquiti ja rohahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yata tsi naa bari caquë tsi quiha jahuë doce ca rabëti bo ya Jesu iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Oriquipama tsi, —Parayamaquia. Jodiobá chama bo qui ëa mëaxëhi quiha mato ó ca huësti cato rë —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jatsi quiha ja cohuënacaniquë. —¿Tsohuë cara ni toa sa? ¿Ea ti ma ni? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jatsi quiha Jesú quëbiniquë: —E bëtaxo tsi jahuë mapari pitëxti qui nacomabëquihai ca tsi xo toa ëa mëaxëhai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Rësoxëquia Quënëhacanish cabá yoani jascaria, naa Nohiria Baquë ë nori cato; jama, noiti-noitixëhi quiha toa jodioba chama bo qui ëa mëaxëhai ca joni ra. Ja qui oquë ja iquë aquë ja coyamarohapiquë no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jatsi, —¿Ea yoati tsi chanihi ni mia pa? —i Judas niquë, naa Jesu mëanish cato. —Jaahuë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jatsi oriquipama tsi quiha mapari Jesú biniquë. Bixo tsi “Gracias” i Dios qui ja niquë ja quëshpi na. Bëquëx-xo tsi jato qui mapari ja aniquë piti. —Bicahuë. Picahuë. Noho yora tsi xo naa —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jatsi copá ca jënë ja biniquë. Bichi tsi “Gracias” i ja niquë. Jatsi jënë jato qui ja aniquë. —Bicahuë. Ayocana —i Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Noho jimi tsi xo naa. Dios xabahamati quinia jisti quiha. Huëstima cabo bax japahacahi quiha noho jimi ra, jato jocha masati. ");
INSERT INTO caoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Jabi nëa xo tsi naa uva bimi jënë atëquëpistiayamariaxëquia, mato bëta xo tsi quinia paxá tsi ë atëquëxëquë rohari mana xo na, naa noho Jahëpá otohai cato xo na —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Quëquëhax tsi quiha Maca Olivo Ya qui ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jatsi quiha jato qui Jesú chaniniquë: —Naa baquichá tsi ëa pasomaha bësoyoxëqui mato rë. Tocaxëti quiha, “Oveja obëso ca tëpasmaxëquia. Pacanamahacaxëhi quiha jahuë oveja” i Quënëhacanish cato ó tsi Dios ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Jama, bësotëquëhax mato bëbo Galilea qui caxëquia —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jatsi quiha Pedró quëbiniquë: —Mi quima tëxë bo bësomitsa. Jama, mi quima casopistiayamariahai ca ëa xo naa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jatsi Pedro qui Jesu chaniniquë: —Mia parayamaquia. Naa baquichá tsi patiari bënë quëonox pari no tsi tres tsi “Jesu cahëyamaquia” ixëqui mia rë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Jatsi quiha, —Mi bëta pi rësorohahi tsi mi quima casopistiayamariaxëquia ra —i Pedro niquë. Jatsi toca tsi quiha chaniniquë jahuë rabëti huëtsa bo ri. ");
INSERT INTO caoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jatsi Getsemaní icanai ca qui Jesu caniquë jahuë rabëti bo ya. Cahax, —Nëbí tsahocana. Toa tsi caapariquia bëhox-xëna —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Jatsi Pedro, Zebedeo dos ca baquë, naa Jacobo, Juan, tihi roha cabo ja boniquë. Jatsi Jesu cohuënaniquë. Raquëtsijaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jatsi quiha, —Cohuëria ca ëa xo naa. Rësoti basima xo ëa rë. E bëta chitëcana. E bëta bësocana ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jatsi ori pistia cahax Jesu mëniniquë, jahuë bëmana mai quiri. Bëhoxtsijaniquë: —Mi qui pi jia no tsi ë quima naa johai ca tënëtiya mëbihuë, noho Jahëpá. Tënëcasyama xo ëa ra. Jama, jaha ë quëëhai ca mi ayamano; jama, mi shina roha ati nori ra —i Jesu niquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Bëhoxhax jahuë rabëti bo qui ja joniquë. Joxo tsi ja oxacanai ca ja jisniquë. Jatsi, —¿Huësti hora roha ë bëta bësoti mëtsama ni mato rë? ");
INSERT INTO caoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Bësocana. Bëhoxcana, jochati ma tanamahacayamano ra. Jabija, mato shina tsi xo toa bëhoxcatsaina; jama, mato yora tsi xo chamayama —i Pedro qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jatsi Jesu catëquëniquë bëhox-xëna. —Ea shinahuë, noho Jahëpá. Mi qui pi jia no tsi naa tënëtiya mi mëbino. Jama, jaha ë quëëhai ca mi ayamano, mi shina ati nori —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Bëhoxhax ja jotëquëniquë. Oxa ja icani ja jisniquë. Coshiria jato bëro ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jisbaya tsi ja bëhoxtëquëniquë, jasca ca yoahaina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jatsi jahuë rabëti bo qui ja bacaniquë. —¿Jari oxacanai rë? ¿Jari joicanai rë? Tsëquëquë ë tënëti hora ra. Jochahuaxëni cabo qui mëahacapaimaria xo ëa, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Joicana. ¿Canomani? Nëa johi quiha ëa mëacatsai ca joni rë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jabi jari ja chanino tsi Judas joniquë, naa doce ca ó ca huësti cato. Ja bëta bëcaniquë nohiria misco. Saipi bo, jihui bo, tihi cabo jayacani quiha. Ja raahacani quiha Jesu qui tsamiti. Arati ibo bo, yosibo, tihi cabá jato raani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jatsi nohiria misco qui jisti Judás aniquë. —Ma bicatsai ca joni tatsoxëquia. Toa joni qui tsamicahuë —i jato qui Judas, naa Jesu mëanish ca niquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Japi cahëhax Jesu qui Judas catapiniquë. Cahax, —¿Jënimani mia, maestró? —i Jesu qui ja niquë, joihuahi na. Joihuaxo tsi quiha Jesu ja tatsoniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jatsi Jesú quëbiniquë: —Mi acatsai ca ahuë pë, noho rabëtí —iquiina. Jatsi Jesu qui tsamihi ja bëcaniquë. Ja achajahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Jatsi quiha Jesu rabëti huësti cató jahuë saipi tsëcaniquë. Tsëcaxo tsi quiha arati ibo-iboria yonati ja paxtianiquë Jesu paxamacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jatsi, —Jahuë iti qui mi saipi jahari raahuë ra —i ja qui Jesu niquë—. Saipí tsi acacaxëhi quiha saipí iquinacascanaibo ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Jëniriahai? ¿Dios quënati mëtsa ca ë nori cahëyamahai? Dios ë quënarohano tsi huëstima ca ángel bo, naa doce ca ángel ejército ja raatapiquë aquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Jama, ángel bo ja raarohano tsi ¿jënahuariaxo Quënëhacanish cabo jatihuahacana? “Jochacanaibo qui ja mëahacati xo” ¿iyamacahi ni? —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jatsi bëcanish ca nohiria misco qui Jesú chaniniquë: —¿Saipi bo, tëpasti jihui bo, tihi cabo jaya ni mato pa? ¿Yomaxëni ca bichii jascaria ëa bichi bëcanai pa? Jatiroha ca bari mato bëta ë i-ipaoyamëquë arati xobó no. Toa xo tsi ë tiisimaquë tsi ë qui ma tsamiyamayamëquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Jama, ocapijaquë naa tëquëta, Dios Chani yoanish cabá quënëni ca jatihuahacano iquish na —nëa tsi jato qui Jesu nëcaniquë. Jatsi jahuë rabëti bá Jesu jisbërianiquë. Jisbëria tsi ja jabacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesu qui tsamixo tsi arati ibo ba chama Caifás qui Jesu ja bocaniquë copihacati. Toá tsi mani ini quiha yoba cahëxëni cabo, jodioba yosibo. ");
INSERT INTO caoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jasca, basi quiha Pedró banahuaniquë raquëquí na. Chama xobo huënë qui cahëhax toá tsi ja tooniquë. Jatsi huënë qui jicohax xobo obëso cabo ya Pedro tsahoniquë tsayaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jabi arati ibo bo, nohiria yosibo, tihi cabá Jesu namëcasni quiha. Ja tsi xo toa Jesu pasomaha ca joi ja mëracaniquë. Yama a ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Jama, tobi huëstima ca quiahuacanaibo ini quiha ja qui quësocatsi na. Jarohapa tsi dos ca quiaxëni ca joni niiniquë ja qui quësoxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—“Dios arati xobo potasti mëtsa xo ëa ra” i ja ni quiha. “Jaquirëquë quiha tres barí tsi naa xobo nimatëquëxëquia” i ja ni quiha —i jaca niquë Jesu qui quësocatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jatsi arati ibo ba chama joiniquë Jesu qui chanixëna. —¿Jënihai, naa jahuë bo yoati na? Mia pasomaha chanicani quiha ra. ¿Jato quëbicasyamahai? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Quëbiyamaniquë Jesu. Jatsi arati ibo ba chama chanitëquëniquë. —Bësohai ca Dios janë́ tsi mi chanino ra. Mi parayamano. ¿Dios Baquë, naa johai ca Xabahamati Ibo ni mia ra? Noqui yoahuë ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jatsi, —Ja tsi xo ëa ra. Jaboqui tsi chamaxëni ca Dios mënëcayá ca Nohiria Baquë tsaho ca jisxëqui mia. Naipá ca tsëmó tsi ja johai ca jisxëqui mia —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jatsi arati ibo ba chamá jahuë sahuëti jaraxaniquë caxaquí na. Jatsi, —Dios pasomaha ja chaniquë ra. Anoma quiha. ¿Jëniriaxo ja qui quësocanaibo huëtsa bo no nicacasna? Nëa roha xo tsi jahuë yoixëni ca chani no nicaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Jabija ni? —nëa tsi Caifás nëcaniquë. Jatsi, —Yoixëni tsi xo toa ja chanihana ra. Namëhacati xo ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jatsi quiha Jesu bëmana qui coshotsi-jahuacaniquë pë. Ja bëtoxacaniquë pë. Ja bëpaishacaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—Jisa, Xabahamati Ibobá. ¿Tsohuë mia aca? Noqui yoahuë ra —i jaca niquë tocahi na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Toatiyá tsi xobo cacha, naa huënënë́ tsi tsaho Pedro iniquë. Toa tsaho ja no tsi ja qui xotaco joniquë. Yonati ja ini quiha. Jatsi ja qui yonati chaniniquë, naa xotaco cato. —Jesu ya mi iquë, mia ri —i Pedro qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jama, —Jesu cahëyamahai ca ëa xo naa ra. E joma mi chanihaina —i Pedro niquë ja qui jato bësojo ax na. ");
INSERT INTO caoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jatsi caiti qui Pedro caniquë, naa huënënë́ cato. Toa xo tsi quiha xotaco yonati huëtsá Pedro jisniquë. Jatsi, —Jesu ya toa joni iquë ra —i toa yonati niquë toá ca manicanaibo qui. ");
INSERT INTO caoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jatsi caxahax Pedro ocaniquë: —Parayamaquia. Toa Jesu cahëyamahai ca ëa xo naa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jaquirëquë, yata pistia no tsi quiha toá ca niihai ca joni bo Pedro qui bëcaniquë. —Tonia Jesu rabëti huësti ca xo mia ra. Jamëri xo mi joi, mi chanihaina ra —i Pedro qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jatsi Pedro ocatëquëniquë pë: —Jabija ca pi ë chaniyamarohano tsi ëa Diós copino ra. Parayamaquia. Toa joni cahëyamaquia ra —i jato qui ja niquë rë. Tocajaquë tsi quiha patiari quëo-quëoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jatsi Jesú yoaha ca Pedró shinaniquë, naa “Patiari quëonox pari no tsi ‘Jesu cahëyamaquia’ ixëqui mia” i ja qui Jesu ni quëshpi na. Jatsi cacha Pedro caniquë. Cahax ja ara-araniquë rabihi na. ");
INSERT INTO caoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Huëaquë tsi arati ibo ba chama bo, nohiria yosibo, tihi cabo chaninaniquë Jesu namëti yoati na. Jesu ja namëcascani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jatsi quiha Jesu ja nëxacaniquë. Nëxaxo tsi quiha romanoba chama, naa Pilato icanai ca qui Jesu ja bocaniquë ja copihacano iquish na. Boxo tsi ja qui ja mëacaniquë ja namëhacano. ");
INSERT INTO caoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jabi Jesu ja namëcascani nori ca jisi tsi Judas rabiniquë, naa jato qui mëanish cato. Rabiquí tsi quiha jahari jodioba chama bo qui jahuë treinta ca parata copixëni ca ja bëniquë. Jaha ja quëëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—Jishopë. Jochaquë ëa ra. Shinajiaxëni ca ë mëaquë rë, ja namëcano —i jato qui Judas niquë. Jatsi, —Noba shina ri ma xo; mi shina nori —i ja qui jodioba chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jatsi napata qui toa parata ja nianiquë arati xobo xo na. Niabëria tsi jamë tsi ja namëhi caniquë, jamë tënëxëhax na. ");
INSERT INTO caoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jatsi arati ibo ba chama bá ja niani ca parata topiniquë. Topihax, —Anoma tsi xo naa parata ra. Namëti copiti parata quiha. Noba yoba pasomaha tsi xo noba caja qui naa parata yoi nanëhaina. Binoma quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Chaninahax Campo del Alfarero mai ja copicaniquë carayanabo maihuati. ");
INSERT INTO caoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ja tsi xo toa “Mai Jimi Ya” toa mai quënahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Jabi tocapijaquë tsi Dios Chani yoanish ca Jeremías yamabá yoani ca jatihuahacani quiha, naa “Treinta ca parata copixëni ca ja bicaniquë. Joni copi ja ini quiha. Toa precio jodiobá copipaoni quiha joni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bixo tsi alfarero mai ja copicaniquë, ëa Ibobá yoani jascaria” nëá tsi quiha ja quënëni ca nina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Romanoba chama bësojó Jesu nimahacaniquë ja copihacano. Jatsi, —¿Jodioba rey, naa chama-chamaria ni mia ra? —i Jesu qui romanoba chama niquë nicahi na. Jatsi, —Jaahuë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jama, arati ibo bo, nohiria yosibo, tihi cabo ja qui quësoquë tsi Jesú quëbiyamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Jatsi Pilató nicaniquë: —Huëstima ca tsi xo toa mi qui ja quësocanaina ra. ¿Jato nicayamahai? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Quëbiyamaniquë Jesu. Japi Pilato ratëniquë. Shinati ja cahëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Jabi jatiroha ca fiesta no tsi huësti ca presó ca joni quiha romanoba chamá paquëmapaoniquë nohiria bo qui. Jahuë jabi quiha. Nohiria qui jia ca joni iqui ca ja paquëmapaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Jasca, toatiyá tsi ati ibo quiha, naa Barrabás icanai ca preso xara iniquë. Toa joni quiha nohiria tëquëtá cahëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Japi nohiria misco catiquë tsi quiha Pilató jato nicaniquë: —¿Jënica joni mato bax paquëmaxëhi ni ëa ra? ¿Barrabás ni? ¿Jesu ni, naa Cristo imahaina? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jabi Jesu qui yosaxëni quiha toa jodiobo iniquë. Ja tsi xo toa Pilato qui ja mëacani quiha ja namëno. Jabi ja qui ja yosacanai ca Pilató cahëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Jatsi quiha nohiria copiti tsahotí ja tsahono tsi jahuë ahuiní ja qui chani raaniquë. “Toa shinajiaxëni ca joni namëyamahuë. E nama-namashinaquë ja yoati na ra” i ja niquë bënë qui. ");
INSERT INTO caoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Jama nohiria misco qui arati ibo bo, nohiria yosibo, tihi cabo chaniniquë namëcatsi na. Chanihax, —Barrabás bënacana ra. “Nati xo Jesu” icana —nëa tsi nohiria bo qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jatsi Pilato chanitëquëniquë: —Nëbi dos ca joni bo. ¿Jënica mato qui paquëmaxëhi ni ëa ra? —iquiina. Jatsi, —Barrabás —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Jatsi, —¿Jënahuaxëhi ni ëa ra Jesu qui, naa Cristo imahaina? —i Pilato niquë. Jatsi, —Cruzó tsi tooxahuë —i nohiria tëquë niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Jëni ni ra? ¿Jahuë yoi ca ja ani pa? —i Pilato niquë jato nicahi na. Jatsi jato joi ja choshacaniquë pë: —Cruzó tsi ja tooxahacati xo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jatsi Pilato yosananiquë. Mahitsa jato qui ja chanini quiha. Caxaxëniria quiha toa nohiria iniquë; iquinacaspaimaria jaca nori. Jatsi jënëpaxa Pilató bënaniquë jato bësojo xo tsi mëchocohaxëna. Mëchocohapama tsi, —Ja rësopino tsi noho shinari ma xo ra, mato shina nori —i nohiria qui Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Jatsi quiha nohiria tëquëtá quëbiniquë: —Noqui, noba xocobo, tihi cabo copihacano ra, ja rësohai quëshpi na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jatsi quiha jato qui Barrabás Pilató paquëmaniquë. Jaquirëquë Jesu ja rashaniquë rispichí no. Rashaxo tsi quiha soldado bo qui ja mëaniquë cruzó tsi ja tooxacano. ");
INSERT INTO caoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jatsi soldado bá Jesu biniquë. Bixo tsi quiha Pilato xobo-xoboria qui ja jicomacaniquë. Jatsi Jesu qui quëtsotsi soldado bo tëquë niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Quëtsoxo tsi jahuë sahuëti ja tsobocaniquë. Tsoboxo tsi quiha sahuëti shini, naa chama sahuëti ja sahuëmacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jatsi chaha ja quëcocaniquë moxa ya. Jahuë mapo ó tsi moxachaha janaxo tsi quiha jahuë mënëcaya ca mëquë ó tsi bastón ja janacaniquë. Rey chama-chamaria jisiria ja ini quiha. Jatsi ja bësojó ja mënicanaca tsi ja mahuacaniquë. —¡Viva, viva, jodioba chama-chamariá! —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Jatsi ja qui ja coshocaniquë. Jahuë mëquë ca bastón bichi tsi ja matoohacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mahuaxo tsi quiha jahuë sahuëti shini ja tsoboniquë. Jahuë sahuëti yoi sahuëmaxo tsi quiha tori Jesu ja bocaniquë cruzó tsi tooxaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Riquipama tsi mai huëtsa ca joni ja bëchacaniquë, naa Cirene ax jonish cato. Simón jahuë janë ini quiha. Ja qui tsamixo tsi quiha Jesu cruz ja qui ja janacaniquë ja iano. ");
INSERT INTO caoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Toca tsi Gólgota, naa Mapo Xao Ya qui ja cahëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Toa xo tsi vino, naa tiahui ya roihacanish ca jënë Jesu qui ja amaniquë ati. Jama, ja xëhayamaniquë tanaxo na. Moca quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jatsi cruzó tsi Jesu ja tooxacaniquë. Tooxaxo tsi quiha jahuë sahuëti bo ja oquëxnamacaniquë i-ihai cató no. ");
INSERT INTO caoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jaquirëquë ja tsahocaniquë toa xo tsi jaha bësoxëna. ");
INSERT INTO caoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Jatsi jahuë mapo maxcacha chani ja janacaniquë, naa ja qui ja quësocanina, “Jesu tsi xo naa, jodioba chama-chamaria” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jasca, ja bëta dos ca yomaxëni ca joni bo ja tooxacaniquë, huësti jahuë mënëcayá no, huësti jahuë mëxojó no. ");
INSERT INTO caoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jasca, —Jë, jë —i tarabicanish cabo niquë bëquëhi na. Jesu ja mahuacaniquë jato ri: ");
INSERT INTO caoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mimë xabahamahuë arati xobo potascatsai cató. ¿Tres barí tsi toa xobo nimati mëtsa ni mia pa? Dios Baquë pi iqui tsi cruz ax botëhuë ra —nëa tsi nohiria bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jascaria tsi mahuacaniquë arati ibo bo, yoba tiisimacanaibo, jodioba yosibo, tihi cabo ri: —Huëtsa bo ja xabahamaquë; jama, jamë xabahamati mëtsa ja nomari —i jaca niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","¿Noba Israel rey, naa noba chama-chamaria ni naa joni pa? Jaboqui cruz ax ja botëno ra. Tocapino tsi chahahuaxëqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","¿Dios qui chitimihi ni naa joni pa? Diós jahuë Baquë mëbino ra noipiquí na. “Dios Baquë xo ëa” ¿i ja yamayamani? —nëa tsi jodioba chama bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jasca, ja bëta tooxahacanish ca yomaxëni cabá Jesu mahuaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Matoroco barí tsi quiha tsëmonaniquë toa mai. Naama tsi quiha ja tsëmonina. Tres hora bo quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Jatsi a las tres tsi quiha joi pistiamá tsi Jesú quënaniquë: —Elí. Elí. ¿Lama sabactani? naa “¿Jënixo tsi ëa mi jisbëriaha rë, noho Diós, noho Diós?” —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Tocajaquë tsi quiha, —Eliás, naa Dios Chani yoanish ca quënahi quiha tonia —i jaca niquë, naa toá ca niicanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nicahax tsi quiha huësti ca joni jabaniquë tatë bixëna. Bixo tsi quiha vinagre jënë nopi ca qui ja moosaniquë. Moosaxo tsi tahua rëbiquirihaxo tsi Jesu ja amaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Jama, —Huënayamaxëhuë. Elías jomitsa mëbixëna. No tsayaparino —i ja qui tëxë bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jatsi Jesú quënatëquëniquë. Quënahax ja naniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ja naquë tsi quiha arati xobó ca rotamë ca quëbëti raiti jaxcahacaniquë. Mana ax napata quiri ja jaxcahacani quiha. Jasca, yajoniquë mai. Mapëxëniquë macaná ca maxax bo. ");
INSERT INTO caoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Japëquëniquë rësonish caba maiquini bo ra. Toá ca Dios qui chitiminish ca rësonish ca huëstima cabo bësomahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jatsi, jato maiquini ax ja tsëquëcaniquë. Jatsi Jesu bësotëquëquë tsi quiha Jerusalén qui ja jicocaniquë jato ri. Toa xo tsi huëstima ca nohiriá jato jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jabi mai yajoquë tsi quiha soldado bá capitán, Jesu obëso cabo, tihi cabo raquëniquë ocapijani ca jisi na. Jisi tsi, —Jabija xo ra. Dios Baquë yoi ja iquë ra —i jaca niquë raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Jasca, basima xo tsi huëstima ca yoxa bá tsayahi iniquë. Galilea ax Jesu ja banahuacani quiha mëbixëna. ");
INSERT INTO caoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Toa mani ini quiha María Magdalena, Jacobo José jahëhua María, Juan Jacobo jahëhua, naa Zebedeo baquë bo. ");
INSERT INTO caoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Bari caquë tsi quiha Arimatea yacata ax rico ca joni joniquë, naa José icanai cato. Jesu banahuanish ca ja ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Cahëhax Pilato jisi ja caniquë. Caxo tsi quiha Jesu yora ja bënaniquë maihuati. Jatsi chani Pilató raaniquë, José qui Jesu yora ja acano. ");
INSERT INTO caoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jahuë yora bichi tsi quiha sabana paxa cató tsi ja yaboniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jaquirëquë jahuë maiquini qui jahuë yora ja nanëniquë. Huëyohaca ca quini paxa ca ja ini quiha. Nanëxo tsi quiha maxax chahitaxëni caiti qui ja taraniquë. Taraxo tsi quiha ja jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jabi toá tsi maiquini bësojó María Magdalena, María huëtsa, tihi cabo tsaho ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Huëaquë tsi, naa jodioba joiti barí tsi quiha arati ibo bo, fariseobo, tihi cabo Pilato jisi bocaniquë. Bohax, ");
INSERT INTO caoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—Quiaxëni toa joni iquë ra bësohi na, taitá —i Pilato qui jaca niquë—. “Tres barí tsi bësotëquëxëquia” i ja ni quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Japi soldado bo jahuë maiquini qui mi raano jaha ja bësocano. Huinocaxëti quiha tres bari. Mi tocapiyamano tsi jahuë yora yomahi jahuë rabëti bo jomitsa ra. Yomahax “Ja bësotëquëquë ra” icaxëcani quiha pë. Jatsi Jesu quiahai ca oquëxëhi quiha ja quiacanaina ra —nëa tsi Pilato qui ja nëcacaniquë pë, naa jodioba chama bo. ");
INSERT INTO caoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Jatsi, —Soldado bo bihuë. Jia tsi jahuë maiquini ó bësocana —i jato qui Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jatsi ja bocaniquë. Maiquiní ca maxax ja rohahuacaniquë, bahama ja tarahacayamano iquish na. Jaquirëquë soldado bo ja nimacaniquë jaha ja bësocano. ");
INSERT INTO caoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jodioba joiti bari huinocaquë tsi quiha baquishmari tsi, naa domingó tsi María Magdalena, María huëtsa, tihi cabo bocaniquë Jesu mai jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Jatsi mai yajo-yajoniquë, nai ax ángel botëni quëshpi na. Botëxo tsi quiha bahama maxax ja taraniquë. Tori tarahax maxax cacha ja tsahoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Canapa bajra-bajrahai jascaria tsi quiha jahuë jaria ini quiha. Joxoria quiha jahuë sahuëti ini quiha, naa nieve jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Jatsi raquë-raquëniquë jaha bësohai ca soldado bo jisish na. Ja rëso-tapicaniquë raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jatsi quiha yoxa bo qui ángel chaniniquë: —Raquëyamacana. Jesu, naa tooxahacahitahax ca ma mërahai ca cahëquia. ");
INSERT INTO caoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yama xo ra. Ja bësotëquëquë ra, ja yoani jascaria. Nëri bëcahuë. Ja janahacahitaha ca ma tsayano. ");
INSERT INTO caoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Mëri, jaboqui jahuë rabëti bo yoata. “Ja bësotëquëquë” i jato qui cana. “Mato bëbo Galilea qui cahi quiha. Toa xo tsi Jesu jisxëqui mato” i jato qui cana. Jabi mato ë yoaha ca ma shina-bënoyamano —i yoxa bo qui ángel niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jatsi maiquini jisbaya tsi quiha rani tsi jahari yoxa bo jabaniquë jato rabëti bo yoaxëna. Jasca ja raquëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Jisbayajahuacano tsi quiha jato bësojó Jesu jisiquitapiniquë. Jisiquixo tsi jato ja joihuaniquë. Jatsi quiha ja bësojó tsi ja mënicaniquë jahuë tahë acha. Ja qui aratsijacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jatsi quiha, —Raquëyamacana. Ebë xatë bo qui ma chanino. “Galilea qui bocata. Toa xo tsi ëa jiscaxëcani quiha” icana —nëa tsi yoxa bo qui ja nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Jabi jahari yoxa bo bohono tsi quiha maiquini ó bësohai ca soldado bo yaca qui cahëniquë jato ri. Ocapijani ca arati ibo bo qui ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Nicahax arati ibo bo bocaniquë nohiria yosibo yoaxëna. Jënahuati ja cahëyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Japi soldado bo qui ja chanicaniquë jato quiamaxëna. —“Yomahacashinaquë jahuë yora” i nohiria bo qui cana. “Baquichá no oxano tsi jahuë yora jahuë rabëti bá yomashinaquë pë” icana. ");
INSERT INTO caoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Jatsi Pilató pi ma yoahai ca jahuëcara nicano tsi “Jabija” i ja qui xëqui noa. Ma raquëyamano —i soldado bo qui jodioba chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Jatsi quiha soldado bo qui parata chama bá aniquë quiamaxëna. Jatsi soldado bo jisbayaniquë, ja yoahacacani ca yoaxëna. Jabi jodiobo xërëquë tsi quiha toa quiahai ca chani pacananiquë pë. Toatiyá rohari no tsi jari chahahuahacahi quiha toa chani pë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jaquirëquë Jesu once ca rabëti bo bocaniquë Galileá ca maca qui, naa Jesú yoaha ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesu jisi tsi ja bësojó tsi quiha ja mënicaniquë; jama, Jesu ja iqui ca huësti huësti cabá chahahuayamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Basimahax tsi quiha jato qui Jesu chaniniquë: —Naipá cabo, maí cabo, tihi cabo yonati chama tëquë ë qui acacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jatsi nohiria bo tëquë qui bocata. Ea banahuacanaibo jato amacana. Jahëpa, jahuë Baquë, Espíritu Santo, tihi cabá janë́ tsi jato ashimacana. ");
INSERT INTO caoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Jasca, mato ë yoani ca jahuë bo tëquë jato tiisimacana. Mato bëtapaoxëquia ra, xaba rëso qui. Toa ma shina-bënoyamano —nëa tsi jahuë rabëti bo qui ja nëcaniquë.");
INSERT INTO caoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo Chani jia ca tsi xo naa, naa Diós raani ca Baquë yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jariapari tsi quiha jahuë Baquë yoati tsi Dios chaniniquë; naa Isaías yamabá quënëni cató no. “‘Mia bëbo noho Chani bëhai ca raapariquia, mi quinia rohahuati’ i jahuë Baquë qui Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jasca xabachá racaxëhi quiha mia bëbo cahai cato. Toa xo tsi quënaxëhi quiha. Quënahax, ‘Mamë rohahuacana, Ibo johai quëshpi na’ ixëhi quiha nohiria bo qui. ‘Mato jabi mëstëhuacana, naa bahi mëstëhuahai jascaria’ ixëhi quiha” nëa tsi Dios nëcani quiha Isaías yamabá quënëni cató no. ");
INSERT INTO caoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Jabi naa Chani bëhai ca ashimati ibo Juan ini quiha. Xabachá tsi quiha ja jisiquiniquë, Dios Chani yoahi na. Jatsi, —Mato jocha quima Dios quiri bësocana. Bësoxo ma ashimahacati xo. Jatsi masahacaxëhi quiha mato jocha ra —i nohiria bo qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jatsi quiha jodioba maí cabo, Jerusalén cabo, tihi ca nohiria bocaniquë, Juan chani nicacascani na. Nicaxo tsi quiha jato jocha ja bërohuacaniquë. Jatsi quiha Juan yamabá jato ashimaniquë ani Jordán xo na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jabi camello rani tsi Juan sahuëti acacani quiha. Bichi cinturón ja chinëxëni quiha. Chapo bo, nihí ca bata, tihi cabo ja pini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jabi Juán yoani ca chani tsi xo naa: —E cho joxëhi quiha ëa oquëria cato. Jahuë yonati iti mëtsama xo ëa ra, ëa oquëria ca ja nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Jënë́ tsi mato ashimaquia; jama, Espíritu Santó tsi mato ashimaxëhi quiha naa johai cato —i Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Jaquirëquë toatiyá tsi Nazaret, naa Galileá ca yaca ax Jesu joniquë. Ja joquë tsi quiha ani Jordán xo tsi Juán Jesu ashimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jatsi quiha jënë ax tsëquëpama tsi nai japëquëhai Jesú jisniquë. Jatsi ja qui Espíritu Santo botëniquë; boto botëhai jisiria iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jatsi quiha naipá ca joi chaniniquë: —Noho Baquë yoi xo mia. Mi qui raniquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jaquirëquë xaba qui Espíritu Santó Jesu raatapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta bari no tsi ja ini quiha xabachá no. Toá ja no tsi quiha Satanás tanamaniquë jochamaxëna. Jasca, toá tsi yohina bo ini quiha jato ri; jama, ángel bo bëcaniquë Jesu mëbixëna. ");
INSERT INTO caoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jabi preso qui Juan nanëhacaquë tsi quiha Galilea mai qui Jesu caniquë. Caxo tsi quiha Dios Chani jia ca ja yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yoahax, —Tsëquëquë xaba-xabatiya ra. Basima tsi xo Diós otohaina ra. Mato jocha quima casocana. Casoxo Dios Chani jia ca chahahuacana —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ia Galilea quënipama tsi quiha rabë ca joni Jesú jisniquë, naa Simón, jahuë noma Andrés. Sani bicanaibo ja icani quiha. Jabi jato nishi bo niahi ja icani quiha Jesu cahëquë no. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—E bëta bëcana. Joni bo biti mato tiisimaxëquia —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Jatsi quiha jato nishi bo ja janatapicaniquë Jesu banahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ori pistia caxo tsi quiha rabë ca joni huëtsa bo ja jisniquë, naa Zebedeo baquë Jacobo, Jacobo noma Juan. Jato notí tsaho ja icani quiha, jato nishi bo shomahuacanaina. ");
INSERT INTO caoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jato tsayapama tsi Jesú jato quënaniquë. Jatsi quiha jato jahëpa Zebedeo, jahuë yonati bo, tihi cabo ja jisbëriatapicaniquë. Jisbëria tsi quiha Jesu ja banahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jatsi Capernaum yaca qui ja cahëcaniquë, naa Jesu, jahuë rabëti bo ya. Jodioba joiti barí tsi quiha jato catiti xobo qui Jesu jiconiquë. Jicoxo tsi quiha tiisimatsijahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jabi ja tiisimani ca quinia qui nohiria bo ratëniquë. Jato yoba tiisimati maestro bo quirima ja ini quiha, chama ya jato ja tiisimani nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jatsi quiha yoshi jayanish ca joni jiconiquë catiti xobo qui. Pistiama ca joí tsi ja quënaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Noqui yosiyamahuë, Nazarét ca Jesú. Tonia noqui quëyohi mi joquë pë. Mia cahëquia. Mia ri tsi xo toa Dios Baquë jiaxëni cato ra —i ja qui yoshi niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jatsi Jesú yoshi raahaniquë: —Pasihuë. Joni quima ax natsëquëhuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jatsi pë yoshiní joni rasëbimaniquë. Rasëbimahax ja sai-sainiquë, natsëquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Jatsi quiha ratëyoniquë nohiria tsayahax na. Chaninatsijacaniquë: —¿Jëniria ni sa? ¿Tiisimahai ca paxa ni naa sa? Jisí. Chama jaya xo naa joni ra. Jisí. Jahuë chani qui nicahi quiha yoshi bo ri pa —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Jatsi Galilea maí tsi chani pacananiquë Jesú ani yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jaquirëquë catiti xobo jisbaya tsi quiha Simón, Andrés, tihi caba xobo qui ja bocaniquë. Bocaniquë Jacobo, Juan, jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jabi raca Simón raisi ini quiha. Ja iquini quiha. Xobo qui Jesu cahëquë tsi, —Iquihi quiha —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jatsi jisi Jesu caniquë. Caxo tsi quiha jahuë mëquë ja biniquë joimaxëna. Jatsi janacatapiniquë jahuë iquini ra. Joixo oriquiti taatsijahuaniquë pa. ");
INSERT INTO caoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bari chixabano tsi quiha iquicanaibo, anomaria cabo, yoshi jaya cabo, tihi cabo nohiria bá bëniquë Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Jasca, xobo bësojó tsi yacatá ca nohiria tëquë quëtsoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jatsi huëstima ca anomaria cabo ja jënimahuaniquë. Yoshi bo ja natsëcaniquë. Natsëcapama tsi yoshi bo ja pasimaniquë, ja chaniyamacano iquish na. Dios Baquë ja iqui ca ja cahëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Huëaquë, jari mitsëmono tsi Jesu joiniquë. Xobo jisbaya tsi quiha nohiria yama ca iti qui ja caniquë jamë no. Toá tsi ja bëhoxni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jatsi Jesu yopaxo tsi Simón, jahuë rabëti bo, tihi cabá mërahi bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jisi tsi, —Mia mëracani quiha nohiria tëquë ra —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jama, —Nëá ca yaca huëtsa bo qui no cati xo. Jato qui Dios Chani ë yoaxëti xo ra. Ja tsi xo toa ë raahacaniquë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jatsi Galilea mai tëquë xo tsi Dios Chani ja yoabonaniquë, jato catiti xobo xo na. Yoshi bo ja natsëcaniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jatsi lepra jaya ca joni Jesu qui joniquë jënimahuahacaxëna. Bonohuaxëni ca joni ja ini quiha. Mënihax, —Mi aapicatsai tsi ëa jënimahuati mëtsa xo mia ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jatsi quiha Jesu cohuënaniquë tsayahax na. Noitiria ca joni ja ini quiha. Jatsi Jesú joni motsaniquë. Motsahax, —Acasquia ra. Bahuëhacahuë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Jatsi tapotapiniquë jahuë bono bo. Jënima ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jatsi jahuë xobo qui raanox pari tsi Jesú yobaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Quiniahuë. E aca ca yoayamahuë. Jama, jaboqui arati ibo qui caaparita, mia ja tsayano iquish na. Jatsi Moisés yobani ca ja qui ahuë tëpas-hacati, nohiria bo qui mi jënimahuahacaha jismaxëna —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jama, caquí tsi quiha Jesú ja bax aca ca ja yoabonaniquë pë. Jatsi quiha chani pacanatapiniquë Jesu yoati na. Jaha tsi pë bëro tsi yaca qui jiconoma Jesu ini quiha, naa tihiria ca quëtsohai ca nohiria iqui na. Jaha tsi quiha yaca basi, naa xobo yama cató tsi quiha ja chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ichariama ca bari tsi quiha Jesu chitëniquë xobo yama cató no. Jaquirëquë Capernaum qui jahari ja joniquë jahuë xobo qui. Jatsi quiha jahari ja johai ca nohiria bá nicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jaha tsi quiha jahuë xobo qui huëstima ca nohiria quëtsoniquë. Jahuë xobo ja rëamëcani quiha. Jasca, caiti cacha xëa yama ini quiha niiti. Jatsi quiha jato qui Jesu chaniniquë, Dios Chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yoajahuano tsi quiha nohiria maxo xobo qui cahëniquë, mohitimaxëni ca joni bëhaina. Cuatro ca joni bá bëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Xobo qui cahëhax Jesu qui basimanoma ja icaniquë rë, naa huëstima ca nohiria iqui na. Jaha tsi quiha xobo mapasti tsëcatsijahuacaniquë. Quinihuaxo tsi quiha noitiria ca joni ja botëmacaniquë, jahuë oxatí no. ");
INSERT INTO caoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jabi Jesu qui ja chitimiriacani quiha toa joni ja jënimahuano. Jabi ja chitimicanai ca jisi tsi mohitimaxëni ca joni qui Jesu chaniniquë: —Masahacaquë mi jocha, noho baquë́ —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jabi toá tsi jodioba yoba tiisimacanaibo tsaho ini quiha. Jesú yoaha ca ja nicacaniquë. Nicahax, ");
INSERT INTO caoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","—¿Jënihax tsi toca tsi chanihi ni naa joni sa? Dios pasomaha chanihi quiha pë. Yama tsi xo jocha masati mëtsa cato ra; jaroha tsi xo Dios —i jamë jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jabi ja shinacanai ca Jesú cahëtapiniquë. Japi jato qui ja chaniniquë. —¿Jëniriahax toca tsi shinacanai rë, ëa yoati na? ");
INSERT INTO caoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Jëni ca ni toa bëroria ca yoati, naa mohitimaxëni ca qui? “Masahacaquë mi jocha” ¿iti ni? “Niina. Cohuë” ¿iti ni? ");
INSERT INTO caoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Jabi jocha masati chama Nohiria Baquë jaya ca ma cahëno ra. Tsayacahuë —i jato qui Jesu niquë. Jatsi mohitimaxëni ca joni qui Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Joihuë. Mi oxati topihuë. Mi xobo qui cata —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jatsi joitapiniquë joni ra. Joixo tsi quiha jahuë oxati ja topiniquë. Jatsi quiha xobo ja huajaniquë jato bësojó no. Jaha tsi quiha ja ratëyocaniquë tsayahax na. Tsayaxo tsi Dios ocahuatsijahuacaniquë: —Anomaria tsi xo naa no tsayahana ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jatsi Galilea qui jahari Jesu catëquëniquë. Caxo tsi quiha ja qui quëtsohai ca nohiria tiisimatsijahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ia quënipama tsi quiha gobierno bax nohiria quima parata biti ibo-iboria ca joni Jesú jisniquë, naa Alfeo baquë Mateo. Jahuë oficina xara tsaho ja ini quiha. Jatsi, —Ea banahuahuë —i ja qui Jesu niquë. Jatsi quiha Mateo joiniquë. Joixo tsi Jesu ja banahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jaquirëquë Mateo xobo qui Jesu caniquë oriquixëna. Jabi impuesto biti ibo-iboria bo, jochahuaxëni cabo, tihi cabo qui joi Mateó amani quiha Jesu ya oriquiti. Jabi Jesu ja banahuacascani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Jatsi quiha yosananiquë jodioba chama bo, naa jodioba yoba tiisimacanaibo, jochahuaxëni cabo ya Jesu oriquihai tsayahax na. Jatsi jahuë rabëti bo qui ja chanicaniquë: —¿Jënixo tsi impuesto biti ibo bo, jochahuaxëni cabo, tihi cabo ya oriquihi ni Jesu pë? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jatsi quiha Jesú jato quëbiniquë nicaxo na: —Doctor qui cayamahi quiha jënima cabo. Jama, doctor ó quëëhai ca tsi xo naa anoma cabo. Jasca, shinajiaxëni cabo quënahi ë joyamaniquë, jato jocha quima bësomati jochacanaibo quënati nori —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Toatiyá tsi quiha ashimati ibo Juan banahuacanaibo, fariseobo banahuacanaibo, tihi cabo samahi iniquë. Japi huësti huësti ca nohiria Jesu qui bëcaniquë nicaxëna. Johax, —¿Jënihax tsi samahi ni Juan banahuacanaibo, fariseobo banahuacanaibo? Mi rabëti bo tsi xo toa samayamacanaina pa —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jatsi Jesú quëbiniquë: —¿Joní ahui yano tsi samahi ni ahui bichish cato rabëti bo pa? Iyamacani quiha ra. Cohuëti xaba ma xo ra. Jabi ahui bichish ca jato bëtano tsi oriquicani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Jama, tobixëhi quiha bari huëtsa, naa ahui bichish ca mëbihacaxëhai ca bari. Toa barí tsi quiha samacaxëcani quiha jahuë rabëti bo cohuëhi na. (Jabi tocaxëhi quiha noho rabëti bo ri ë caquë no) —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jatsi quiha Jesu chaniniquë nohiria bo qui jahuë arati quinia paxa ca yoati na. —Quësi paxá tsi quiha raiti siri pishpayamahi quiha nohiria. Anoma quiha. Jabi quësi paxá tsi ja pishpapicano tsi përësixëhi quiha raiti siri. Përësixëhi quiha quësi paxa ri, jaha bëquiyamahai iqui na. (Jascaria, mato arati quinia siri jaha bëquiyamahi quiha noho tiisi paxa cato. Jamëri xo.) ");
INSERT INTO caoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jasca, jënë bichi ca sota sirixëni qui jëësihai ca jënë paxa ca rëhuiyamahi quiha nohiria. Rëhuipijahuacano tsi poshixëhi quiha jënë bichi ca sota ra. Jatsi japaquëxëhi quiha jënë. Yoshihuahacaxëhi quiha sota ra. Jama, jënë bichi ca sota paxa ca qui jënëria paxa ca rëhuihacati xo. (Jascaria, anoma tsi xo toa arati quinia sirí tsi noho tiisi paxa ca tiisimahaina ra. Arati quinia huëtsá tsi ja tiisimahacaxëti xo. Mato arati jabi siri jaha bëquiyamahi quiha noho tiisi paxa cato) —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Joiti barí tsi quiha harina trigo huai bo nacohi Jesu iniquë jahuë rabëti bo ya. Bohopama tsi quiha jahuë rabëti bá trigo bimi risaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jatsi quiha ja qui jodioba chama bo chaniniquë tsayahax na. —Tsayapa. Anoma ca acani quiha mi rabëti bo ra. Anoma tsi xo toa joiti barí tsi yonocohaina ra —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jatsi Jesú quëbiniquë: —¿Quënëhacanish cabo ó tsi noba David yamabá ani ca ma tsayayamayamani, naa jahuë joni bo ya ja paxnaniquë no? ");
INSERT INTO caoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Dios xobo qui ja jiconi quiha jahuë joni bo ya, arati ibo ba mapari bixëna. Jabi toatiyá tsi quiha arati ibo bo chama Abiatar i-ipaoni quiha. Jicoxo tsi quiha Dios qui aquëquëmani ca mapari David yamabá bini quiha, pixëna; naa pinoma ca mapari quiha. Jatsi quiha ja bëta inish ca joni bo qui toa roa ca mapari ja ani quiha piti —nëa tsi Jesu nëcaniquë jato qui. ");
INSERT INTO caoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jatsi, —Joiti bari Diós ani quiha joni mëbixëna ra. Joni acacayamani quiha joiti bari bax na. ");
INSERT INTO caoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Jatsi jënima tsi xo toa noho rabëti bá acaina, joiti bari Ibo-iboria ca ë nori iqui na —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Catiti xobo qui Jesu jicotëquëniquë. Toá tsi mëquë choni jayanish ca joni ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jatsi quiha nohiria bá Jesu tsaya-tsayamisniquë ja qui quësocasquí na. Joiti barí tsi joni ja jënimahuaxëti ó ja pasocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jatsi mëquë choni jayanish ca joni qui Jesu chaniniquë: —Niihuë. Nëri johuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jatsi nohiria bo Jesú nicaniquë: —¿Yoi ni, jia ni joiti barí tsi jia ca acaina? ¿Naa joni mëbixëhi ni noa? ¿Mëbiyamaxëhi ni noa? ¿Xabahamaxëhi ni noa; quëyoxëhi ni noa? —i jato qui ja niquë. Quëbiyamaniquë nohiria pë. Ja pasicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jatsi caxaxo tsi quiha Jesú jato bëisniquë. Cahëtimaxëni ca nohiria ra. Jato shina yoi iqui tsi Jesu cohuënaniquë. Jatsi noitiria ca joni qui Jesu chaniniquë: —Mi mëquë yoi mëtahuë —iquiina. Jatsi quiha joní jahuë mëquë mëtaniquë. Jënimahuahacani quiha jahuë mëquënë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jatsi bamaxoma tsi jodioba chama bá jisbayaniquë. Jisbaya tsi maxo huëtsa ya, naa Herodes yonati bo ya ja caticaniquë chaninaxëna, Jesu acascani na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jatsi ia qui Jesu caniquë jahuë rabëti bo ya. Ja caquë tsi quiha banahuacaniquë Galileá ca nohiria misco ra. ");
INSERT INTO caoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jisti bo Jesú acai ca nicahax bëcani quiha jodioba maí ca nohiria. Jasca, Jerusalén, Idumea, ani Jordán rabëquëxë, Tiro, Sidón mai, tihi cabo ax ja bëcani quiha Jesu jisxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jatsi quiha quëtsohai ca nohiria iqui tsi jahuë rabëti bo ja yobaniquë ja bax noti rohahuati. Nohiria quima paxati quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jabi huëstima ca ja jënimahuaniquë toa barí no. Ja tsi xo toa ja qui nohiria quëtsoni quiha Jesu motsaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Jasca, ja bësojó tsi yoshi jaya ca nohiria mëni-mëniniquë, Jesu tsayahax na. Mënihax yoshi bá quënaniquë: —Dios Baquë xo mia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jama, jato ja yobarianiquë tsohuë ja iqui ca yoayamati. ");
INSERT INTO caoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nohiria bo jënimahuahax tsi tëmachi Jesu tëmahinaniquë. Tëmahinaxo tsi quiha ja bicasni ca joni bo ja quënaniquë ja bëtati. Jatsi ja qui ja bëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Doce ca joni bo ja bini quiha ja bëtati, raahacati, Dios Chani yoati. ");
INSERT INTO caoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jasca, chama jato qui ja aniquë yoshi bo tsëcati. ");
INSERT INTO caoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jabi doce ca ja bini ca tsi xo naa: Simón, naa Pedro ja janëni cato, ");
INSERT INTO caoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, naa Zebedeo baquë, Jacobo noma Juan, (Boanerges ja quënahacacani quiha, “Tërëhai cato baquë bo” iquiina.) ");
INSERT INTO caoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeo baquë Jacobo, Tadeo, gobierno pasomaha ca Simón, ");
INSERT INTO caoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariote, naa jodioba chama bo qui Jesu mëanish cato. Tihi cabo Jesú biniquë ja bëtati. Jaquirëquë xobo qui Jesu jiconiquë jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ja qui nohiria misco quëtsotëquëniquë pa. Jabi nohiria iqui tsi pinoma quiha ja icaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jatsi quiha Jesú nohiria jënimahuahai ca jahuë noma bo, jahuë jahëhua, tihi cabá nicaniquë. Nicaxo tsi quiha Jesu bichi ja bocaniquë, yoyo jayahai ca quëscajahuahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jasca, jahuë xobo qui cahëniquë Jerusalén ca maestro bo, naa Dios yoba cahëxëni cabo. Cahëhax tsi quiha ja nëcacaniquë: —Jahuë ibo tsi xo Satanás ra. Yoshi bo ibo-iboria tsi xo toa Jesu mëbihai cato. Ja tsi xo toa yoshi tsëcati chama jaya xo ra —i jaca niquë pë, ja yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jatsi nohiria Jesú quënaniquë chani bo jato qui yoaxëna. Ja nëcani quiha: —¿Jënahuariaxo raca Satanás Satanás natsëcana? ");
INSERT INTO caoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jabi iquinapihi tsi quëyohacaxëhi quiha país ca nohiria ra. Chama yama xo toca ca gobierno ra. ");
INSERT INTO caoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jasca, quëyohacaxëhi quiha xobó ca nohiria ra, ja iquinacaquë no. Yonocobëquitimaxëni ca xo rë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Japi jamë pasomaha iquinapihi tsi quëyohacaxëhi quiha Satanás chama. Tocapijano tsi basima xo jahuë rëso ra. Jabi tocayamahi quiha Satanás ra. ");
INSERT INTO caoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","‘¿Jënahuariahax raca joni chamaxëni cato xobo qui joni jicona, jahuë jahuë bo yomaxëna? ¿Jariapari tsi quiha chamaxëni ca joni nëxayamayamaxëhi ni? Nëxaxo tsi jahuë jahuë bo yomahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","‘Mato parayamaquia. Nohiria jocha tëquë masaxëhi quiha Dios ra. Masahacaxëhi quiha ëa pasomaha ca chani ri. ");
INSERT INTO caoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jama, Espíritu Santo pi nohiriá ocahuano tsi jahuë jocha shina-bënoyamaxëhi quiha Dios. Quësohacapaoxëhi quiha toa nohiria ra —i Jesu niquë nohiria bo qui chanihi na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jabi toca tsi quiha Jesu chaniniquë: —Yoshi jaya —i jaca ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jatsi xobo qui jahuë jahëhua, jahuë noma bo, tihi cabo bëcaniquë. Xobo cacha nii ja icani quiha. Jatsi chani ja qui ja raacaniquë, cacha ja jono iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Jatsi, —Cacha tsi xo mi ihua, mi noma bo. Mia mëracani quiha —i Jesu tëamë ca nohiria niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jatsi Jesú jato nicaniquë: —¿Tsohuë ni toa noho jahëhua yoi ra? ¿Tsohuë ni toa ëbë xatë yoi bo? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jatsi ja tëamë ca tsaho ca nohiria qui tsayahax, —Nëá xo noho jahëhua yoi. Nëá xo ëbë xatë yoi bo. ");
INSERT INTO caoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ebë xatë, noho yoxa cato, noho jahëhua tihi ca tsi xo toa Dios shina acai cato iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ia Galilea quëmapo xo tsi quiha nohiria bo tiisimati Jesú chitahëhuaniquë. Anomaria nohiria iniquë ra, naa ja qui quëtsocanaibo. Nohiria misco quiha. Ja tsi xo toa ianë́ ca noti qui Jesu jiconiquë nohiria quima paxaxëna. Jicohax tsi quiha ja tsahoniquë. Quëmapó tsi quiha nohiria tëquë mani ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jatsi quiha huëstima ca jahuë bo jato ja yoaniquë chaniquí na. Bëroria ca jahuë chani ini quiha. Ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Bëro sayahi quiha huësti ca joni caniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Jahuë huai sayajahuano tsi quiha huësti huësti ca bëro bahi tapaí xapaquëniquë. Toá ca bëro isa bá piniquë joxo na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Jasca, bëro huëtsa quiha maxax mai qui xapaquëniquë, naa iriama ca mai cató no. Toá tsi quiha bëro shinahatapiniquë, oti yama pi mai ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bari tsëquëquë tsi quiha ja mëshahacaniquë. Tapo mishni quiha. Ja iqui tsi ja chonicaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Jatsi huësti huësti ca bëro masa xërëquë tsi xapaquëniquë rë. Bëro ya tsi shinahabëquiniquë masara pë. Banaha ca ja mapani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Jama, bëro huëtsa mai jiaxëni ca qui xapaquëniquë. Jocohax jia tsi quiha ja shinahaniquë. Huëstima ca bimi ja saihuacaniquë. Cien ca bëro huësti ca maxó saihuani quiha. Maxo huëtsa tsi quiha setenta. Maxo huëtsa ri treinta —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jatsi, —Ea nicaxëti xo jatiroha cabo ra —i Jesu niquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jamë pistia ja no tsi quiha jahuë rabëti bo, toá ca banahuacanaibo huëtsa bo, tihi cabá nicaniquë ja yoaha ca chani yoati na. Jato qui bëronoma ini quiha ja yoahana. ");
INSERT INTO caoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jatsi jato ja quëbiniquë: —Mato qui tiisi acacaniquë, Diós otohai ca yoati tsi jonë ca jahuë bo cahëti. Jama, naa jonë ca jahuë bo cahëyamahi quiha ëa pasomaha cabo. Nëca ca chaní tsi, naa ejemplo bá tsi nohiria qui chaniquia, nicaxo ja cahëyamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Dios quiri ja bësoyamacano, jato jocha masahacayamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jatsi Jesú jato nicaniquë: —¿E yoaha ca chani ma cahëyamaha pa? Cahëyamapiquí tsi ¿jënahuariaxo raca ë yoaxëhai ca ejemplo huëtsa bo ma cahëna? ");
INSERT INTO caoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Bëro sayahai ca tsi xo toa Dios Chani yoahai cato. ");
INSERT INTO caoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Huësti huësti ca nohiria tsi xo toa bahi tapaí ca bëro jascaria. Dios Chani nicacani quiha. Ja nicacano tsi johi quiha Satanás, jato shina ó ca sayaha ca chani tsëcaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Nohiria huëtsa tsi xo toa maxax mai qui sayaha ca bëro jascaria. Ranixo tsi Dios Chani biriacani quiha nicaxo na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Jama, jato shina ó tsi tapoyamahi quiha Dios Chani rë. Naamayamahi quiha ja chahahuacanaina rë. Dios Chani iqui tsi nohiria bá jato yosino tsi ja tënëmapihacacano tsi Dios quinia quima casotapicani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Jatsi nohiria huëtsa tsi xo toa masa xërëquë sayaha ca bëro jascaria. Dios Chani nicacani quiha jato ri; ");
INSERT INTO caoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","jama, Dios quima jato ninihi quiha maí ca jahuë bo, naa jaha ja quëëcanaina. Maí ca jahuë bo shinacani quiha pë. Jatsi Dios Chani, naa sayaha ca bëro tsiihaqui quiha parata ó ja quëëcanaina ra. Tsiihaqui quiha toa jato ranihuahai ca jahuë bo rë. Ja quëshpi tsi jato shina ó tsi anitimaxëni tsi xo Dios Chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jama, tobi quiha Dios Chani bicanaibo, nicaxo na. Mai jiaxëni cato ó ca sayaha ca bëro jascaria ca xo. Dios bax saihuacani quiha. Huësti ca maxo tsi xo cien ca saihuahaina. Maxo huëtsa tsi xo setenta ca saihuahaina. Maxo huëtsa tsi xo treinta ra —nëa tsi Jesu nëcaniquë, jahuë chani bërohuahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jatsi quiha jahuë chani Jesú rëtsaniquë: —¿Paiti nama, oxati nama, tihi cabo nama jahuë lamparina janahi ni ibo pa, tsamaxo na? Tocayamahi quiha ibo ra. Jahuë ití tsi janahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Jabi bërohuahacaxëhi quiha jaboqui jonë ca tëquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ea nicati xo jatiroha cabo ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jaquirëquë ja nëcaniquë: —Nicaquí tsi chahahuacana. Jia pi ma nicano tsi Dios Chani pi ma jabino tsi mato tiisi anihuaxëhi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Oquë ca tiisi bixëhi quiha tiisi jaya cabo; jama, jahuë tiisi pistia roha bënoxëhi quiha nicacasyamacanaibo ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jaquirëquë Jesu nëcaniquë: —Chani mato qui yoaquia Diós otohai ca mato cahëmaxëna. Tobi quiha huai ibo. Jahuë bëro sayahi cahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sayaxo jisbayahi quiha. Jatsi huinocahi quiha bari bo. Ibo yamano tsi jocohi quiha toa ja sayahana. Jia tsi shinahahi quiha; jamë no. ");
INSERT INTO caoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jabi mai tsi xo toa bëro jocomahaina. Jariapari tsi xo jahuë joco. Jaquirëquë jahuë pëhi. Jarohari tsi xo jahuë bimi shini cato. ");
INSERT INTO caoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jahuë bëro shiniquë tsi tësaqui ibo ra. Tsëquëquë tësatiya —i Jesu niquë tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jaquirëquë chani huëtsa Jesú yoaniquë: —¿Jënahuariaxo Diós otohai ca mato cahëmaxëhi ni ëa sa? ¿Jëni ca ejemplo yoaxëhi ni ëa sa, mato cahëmati? ");
INSERT INTO caoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jabi mostaza bëro chani mato yoaxëquia ra. Toca xo Diós otohaina ra. Jabi mishni-mishniria tsi xo toa banaha ca mostaza bëro. ");
INSERT INTO caoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jama, shinahacax pistiama quiha. Tëtëcaria tsi xo jahuë mëshi bo. Planta huëtsa bo oquë quiha. Jasca, mëshi naxërëquë xo tsi jato naha acani quiha isa bo, tëbaquishí racaxëna —i jato qui Jesu niquë, tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nëca tsi quiha huëstima ca ejemplo bo Jesú yoaniquë, Dios Chani nohiria bo tiisimaquí na. Cahëti mëtsa pi ja icano tsi ja tocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Jabi ejemplo bo ja yoarohaniquë tiisimaquí na. Jahuë jabi quiha. Jama, jahuë rabëti bo roha yaquí tsi quiha jahuë chani bo ja bërohuapaoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Yata, bari caquë tsi quiha jahuë rabëti bo Jesú yobaniquë: —¿Ia rabëquëx ca qui canomani? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Jatsi Jesu tsaho ca noti qui jahuë rabëti bo jiconiquë. Jicoxo tsi quiha nohiria bo ja jisbayacaniquë. Jisbaya tsi quiha ia ja shitacaniquë. Jatsi jato noti ya noti huëtsa bo shitaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jatsi iané tsi cosporiatsi yoshi niquë rë. Rëamëtsi quiha jato noti niquë choca iqui na. Jëtëquëpaimaria ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jama, noti chipojó Jesu iniquë. Oxa quiha. Tëpasamëti raca. Jatsi jahuë rabëti bá Jesu bësomaniquë. —Noqui shinahuë, Maestró. Rësopaima xo noa rë —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jatsi Jesu niiniquë. Niixo tsi quiha yoshi, choca, tihi cabo ja raahaniquë: —Pasihuë. Janacahuë ra —iquiina. Jatsi yoshi xotohai ca janacaniquë. Pasi roha ja ini quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jatsi jahuë rabëti bo qui Jesu chaniniquë: —¿Jëniriahax raquëcanai ra? ¿Jëniriahax ë qui ma chitimiyamaha? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Raquëhax, —¿Tsohuë cara ni naa sa? Ja qui nicahi quiha yoshini, choca, tihi cabo ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ia Galilea shitahax tsi quiha Gadara mai qui ja rërëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Rërëhax noti ax Jesu botëniquë. Jatsi maihuati quini bo, naa cementerio icanai ca ax joni joniquë, ");
INSERT INTO caoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","naa yoshi jaya cato. Toá tsi quiha ja racaniquë, rësonish caba maí no. Anomaria jahuë yoyo ini quiha. Nëxanoma quiha. Jasca, mëchichó nëxanoma ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Jasca, huëstima tsi jahuë mëquënë, jahuë tahë, tihi cabo nëxahacaniquë; mahitsa. Mëchichó toa joni ja nëxacaquë tsi quiha mëri tsi ja tësaniquë. Jasca, jahuë tahë achati manë bo ja choshapaoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Jasca, barihani, baquicha, rësonish caba maí tsi quiha ja cocohi iniquë. Maca bo nacopama tsi ja sai-saini quiha. Quënoxëni ca maxa bá tsi quiha jamë ja quëësani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jabi basi xo tsi Jesu jisi tsi quiha ja qui ja jabaniquë. Jabahax ja bësojó tsi quiha ja mëniniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Jatsi joi pistiamá tsi quiha ja quënaniquë: —Ea huënahuayamahuë Jesú, mana ca Dios Baquë́. Dios janë́ tsi ëa shinahuë. Ea tënëmayamahuë ra iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jabi toca tsi quiha ja chaniniquë Jesú yoaha iqui na, —Naa joni quima natsëquëhuë ra —i ja qui ja ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jatsi, —¿Jahuë ni mi janë ra? —i quiha Jesu niquë. —Seis Mil xo ëa —i ja niquë huëstima ca yoshi bo ja jayani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Jatsi Jesu ja bënarianiquë, toa mai quima jato ja raayamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Jabi toá tsi, basima quiha, huëstima ca yahua jinaya iniquë. Macana xo tsi pihi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jatsi yoshi bá bënaniquë: —Toa yahua jinaya qui noqui raahuë. Jato qui no jicono ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jatsi, —Bocata —i jato qui Jesu niquë. Jatsi joni quima ax yoshi bo natsëquëniquë. Natsëquëhax tsi quiha yahua jinaya qui ja jicocaniquë. Jatsi jabatsi yahua tirixëni niquë. Dos mil ca yahua quiha. Maca ax rënichihax ia qui ja jabayocaniquë. Ja nëachiyocaniquë ianë́ no. ");
INSERT INTO caoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jatsi yahua jinaya obëso cabo jabayocaniquë, ratëhi na. Yacatá ca nohiria, xabachá ca nohiria, tihi cabo yoahi ja bocani quiha. Jatsi nohiria bo bëcaniquë oca pi ja ni ca jisi na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesu ini ca qui cahëxo yoshi jayapaonish ca joni ja jiscaniquë. Jaboqui tsaho ja ini quiha. Raiti sahuë quiha. Yoyo yama, jënima ja ini quiha. Tsayahax ja raquëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jabi yoyoxëni ca joni jënimahuahacani ca quinia jisnish cabá yoaniquë bëcanish cabo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Jatsi Jesu bënatsi jahuacaniquë jato mai jisbayati. ");
INSERT INTO caoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jatsi jahuë noti qui Jesu jiconiquë jisbayaxëna. Jicojano tsi quiha, —Mi bëta cacasquia ra —i yoshi jayapaonish ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jama, noti qui Jesú jicomayamaniquë. Jicomayamaxo tsi quiha ja qui ja chaniniquë: —Jahari mi xobo, mi nabo, tihi cabo qui catá. Mi bax Ibobá acana, mia ja shomahuahana, tihi cabo jato mi yoano ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jatsi pë joni jisbayaniquë. Jisbaya tsi quiha Decápolis icanai ca yaca bo xo tsi Jesú ja bax ani ca ja yoabonaniquë. Ratëniquë jahuë chani nicanish cabo tëquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jahari ia rabëquëx ca qui Jesu cahëquë tsi toá tsi quiha nohiria misco mani iniquë. Quëmapó nii ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jatsi quiha ja qui joni joniquë, naa Jairo icanai cato. Jodioba catiti xobo chama quiha. Jesu jisi tsi quiha Jesu tahë tsi Jairo mëniniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mënihax ja bënarianiquë: —Anoma xo noho jahini rë. Noho xobo qui johuë. Noho jahi mi motsano ra, ja jënimanano iquish na, ja rësoyamano —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jatsi Jairo ya Jesu caniquë. Banahuaniquë nohiria misco ri, ja qui quëtsocanaina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Jabi nohiria xërëquë tsi quiha noitiria ca jimi acai ca yoxa ini quiha. Doce ca año no tsi quiha jimi ja ani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jasca, huëstima ca doctor bo qui ja cani quiha jënimahuahacaxëna. Quëyohacani quiha jahuë parata; jama, jari jasca pi ja ini quiha rë. Oquënahi ja jimi acai ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesu yoati tsi nicahi tsi nohiria xërëquë tsi Jesu cho ja basimaniquë. Basimaxo tsi quiha Jesu sahuëti ja motsaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jabi jamë ja nëcani quiha: “Jahuë sahuëti roha pi motsahi tsi jënimaxëquia ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Jatsi tocapijaniquë. Bismatapiniquë ja jimihaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jarohari tsi quiha jahuë chama natsëquëha ca Jesú cahëtapiniquë. Nohiria naxërëquë bopinaxo tsi quiha ja nicaniquë: —¿Tsohuë noho sahuëti motsaha? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Jatsi jahuë rabëti bá quëbiniquë: —Tsayahuë. Anomaria tsi xo toa nohiriá mia tijihacanaina. ¿Jëniriahax raca, “¿Tsohuë ëa motsaha?” i mi a pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jama, motsahax ca jari Jesú mëraniquë, nohiria tsayaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jatsi raquëtsi yoxa niquë. Ja jënimahuahacaha ca ja cahëni quiha. Japi mëmë tsi Jesu qui ja joniquë. Johax Jesu tahë tsi quiha ja mëniniquë. Ja jënimahuahacaha ca ja yoaniquë, parayamaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jatsi Jesu ja qui chaniniquë: —Mi jënimahuahacaquë cai, mi chitimihai ca iqui na. Bëpasi tsi cata. Jaboqui jënima xo mia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jari Jesu ja qui chanino tsi quiha huësti huësti ca nohiria bëcaniquë Jairo xobo ax na, naa jodioba catiti xobo chama. Cahëhax, —Rësoquë mi jahini rë. Maestro jari huënahuayamahuë. Iquë rë —i jahini jahëpa qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ja yoacana ca chahahuayamahi tsi jodioba catiti xobo chama qui Jesu chaniniquë: —Raquëyamatsina. E qui roha mi chitimino ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Jatsi jahari nohiria bo Jesú raaniquë, jamë cacatsina. Pedro, Jacobo, Juan, Jacobo noma, tihi ca roha ja boniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairo xobo qui cahëxo tsi quiha pacots-huahai ca nohiria, naa araconacanaibo, huini-huinicanaibo, tihi cabo ja jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Xobo qui jicopama tsi quiha, —¿Jënahuariahax raca nëca tsi araconacanai? Anomaria xo ma pacots-huahaina ra. Rësoyamahi quiha naa baquë. Oxa roha —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jatsi ja osacaniquë. Jatsi xobo cacha nohiria tëquë ja raaniquë. Raaxo tsi quiha jahëpa, jahëhua, ja bëta bëcanish cabo, tihi roha ca ja bëniquë jahi ini ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jatsi jahini mëquë Jesú biniquë. Bichi tsi, —Talita, cumi, naa joihuë caí, iquia —i jahi pistia qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jatsi joitapiniquë jahini. Tapiti mëtsa ja ini quiha ra. Jabi doce ca año ja jayani quiha naa xotaco. Jatsi ratëniquë nohiria tëquë tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jama, nohiria bo Jesú yobaniquë, ja aca ca ja yoayamacano Jasca, jato ja yobaniquë jahi pistia pimati. ");
INSERT INTO caoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jaquirëquë toa mai Jesú jisbayaniquë. Jisbaya tsi quiha jahari jahanahax ja coni yacata, naa Nazaret icanai ca qui ja bacaniquë jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Joiti barí tsi quiha ja cahëcaniquë. Cahëxo tsi quiha jodioba catiti xobo xo tsi tiisimatsi quiha Jesú huaniquë. Jabi toá tsi quiha huëstima ca nohiria iniquë araxëna. Jesu chani nicahi tsi quiha ja ratëyocaniquë. —¿Jahuënia ca naa tiisi ja bini sa? ¿Jënahuariaxo raca naa jisti bo aqui ni pa? ");
INSERT INTO caoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Carpintero roha tsi xo naa ra? Maria baquë yoi tsi xo naa pë. Jahuë noma bo tsi xo Jacobo, José, Judás, Simón ra. ¿Nëá tsi racayamayamahi ni jahuë yoxa cabo ri? ¿Jënahuariahax raca noqui ja oquëna? —nëa tsi nohiria bo nëcaniquë Jesu yoati na. Ja iqui tsi pë jahuë chani ja nicacasyama-caniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jatsi Jesú jato yoaniquë: —Jabi Dios Chani yoati ibo qui nicahi quiha jatiroha ca nohiria ra. Jama, nicacasyamacanaibo tsi xo toa jahuë yacatá ca nohiria, jahuë jimi bo, jahuë xobó cabo pë. Tihi cabo tsi xo toa jahuë chani nicacasyamacanaibo —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jatsi toa xo tsi jisti bo ati mëtsama Jesu iniquë, ja qui ja chitimiyamacani iqui na. Huësti huësti ca iquicanaibo roha ja jënimahuani quiha, jato ó tsi jahuë mëquë tsi janaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ratëni quiha Jesu, ja qui ja chitimicasyamacani iqui na. Jaquirëquë yaca huëtsa bo qui ja caniquë Dios Chani tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jaquirëquë jahuë doce ca rabëti bo ja qui Jesú catianiquë. Catiaxo tsi quiha rabë rabë tsi jato raatsijahuaniquë Dios Chani yoati. Jasca, chama jato qui ja aniquë yoshi bo tsëcati. ");
INSERT INTO caoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jatsi jato ja yobaniquë: —Mëquëya bocana. Coti jihui roha bocana. Sota, mapari, parata, tihi cabo boyamacana. ");
INSERT INTO caoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Jënima tsi xo chinela sahuëhaina; jama, rabë ca camisa bo ma sahuëyamano —nëa tsi Jesu nëcaniquë, jato yobahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nëca tsi ja rëtsaniquë: —Yaca qui cahëhax mato qui joi amahai ca nohiria xobó tsi chitëcana. Shishohi tsi xobo huëtsa rarinayamacana. ");
INSERT INTO caoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Yacatá ca nohiriá pi mato joihuayamano tsi mato chani pi ja nicacasyamacano tsi jato bëta chitëyamacana. Jisbaya tsi mato tahë ca cospo toj-tojhacahuë jato jocha jismaxëna. Toca tsi jato qui Dios caxa ma jismati xo —i jahuë rabëti bo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jatsi ja bocaniquë. Dios Chani ja yoabonacaniquë: —Dios quiri mato quinia yoi ca quima bësocana ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Jasca, yoshi huëstima ca ja tsëcacaniquë. Iquicanaibo ó tsi xëni ja japacaniquë, jato ja jënimahuaquë no. Tihi tsi ja acaniquë, Dios Chani yoaquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jabi Jesu yoati tsi chama Herodés nicaniquë, nëama Jesú ani ca chani pacanani quëshpi na. Nicahax tsi quiha, —Tonia bësotëquë xo Juan yamabo ra. Ja tsi xo toa jisti ati chama jaya xo ra —i Herodes niquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jasca, —Dios Chani yoanish ca Elías yamabo tsi xo naa tonia —i nohiria huëtsa bo niquë. Jama, —Dios Chani yoati ibo-iboria tsi xo naa, naa noba Dios Chani yoanish cabo jascaria —i huëtsa bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Nohiria bá yoahai ca nicahax tsi quiha chama Herodes nëcaniquë: —Juan yamabo xo ra. Jahuë mapo ë tëquëësaniquë rë; jama, jaboqui bëso ja nori —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Jabi siri tsi soldado bo chama Herodés raani quiha Juan qui tsamiti. Juan nëxati ibo chama Herodes ini quiha. Jabi ja bichi ca ahui Herodías iqui tsi quiha preso qui Juan nanëhacani quiha rë. Jabi jahuë noma Felipe ahui chama Herodés bini quiha rë, naa Herodías icanai cato. ");
INSERT INTO caoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jabi jahuë noma ahui ja biquë tsi, —Binoma tsi xo mi noma ahuini ra. Anoma quiha —i ja qui Juan i-ipaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ja tsi xo toa Juan qui jahuë ahui paxa ca Herodías caxa iniquë. Juan ja acasni quiha pë; jama, ati mëtsama ja ini quiha jahuë bënë Herodes iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Shina jiaxëni ca mëstë ca joni Juan iqui ca chama Herodés cahëni quiha. Ja tsi xo toa Juan ja acasyamani quiha, raquëquí na. Japi Juan ó ja bësoniquë. Jasca, ja qui jia quiha Juan chanini ca ini quiha. Nicahax ja shina-huëjënapaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Jama, jahuë ahui qui tsëquëni quiha Juan namëti xabaca, naa jahuë bënë Herodes coni bari no. Toa barí tsi quiha jahuë nohiria chama bo, jahuë capitán bo, Galileá ca yosibo, tihi cabo qui joi Herodés amaniquë, jahuë fiesta qui ja bëcano. ");
INSERT INTO caoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ja oriquicano tsi quiha Herodías jahi jiconiquë jato bax pabëxëna. Jabi ja pabëhai ca qui raniniquë Herodes, ja bëta oriquicanaibo. Ranihax xotaco qui Herodes chaniniquë: —¿Jahuë ó quëëhai? Ea nicamahuë. Jaha mi quëëhai ca mi qui axëquia ra —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Jatsi ja jurar-aniquë: —Mia parayamaquia ra. Jahuëcara mi bënahai ca mi qui axëquia ra, naa ë yonahai ca bëquëx tana —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jatsi xotaco caniquë jahuë jahëhua nicaxëna. —¿Jahuë bënaxëhi ni ëa sa? —i jahuë jahëhua qui ja niquë. Jatsi, —Ashimati ibo Juan mapo bita —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Bamahaxma tsi chama Herodes qui jahari ja joniquë. Johax, —Ashimati ibo Juan mapo ë qui ahuë, ratá no —i chama qui ja niquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Jatsi Herodes cohuëniquë nicahax na. Jama, nohiria bësojó tsi “Mia parayamaquia” i ja ni iqui tsi jaha ja quëëhai ca xotaco qui ja aniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jatsi soldado ja raaniquë Juan mapo biti. ");
INSERT INTO caoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Jatsi preso qui soldado caniquë. Caxo jahuë mapo ja tëquëësaha ca tsi jahari ja bëniquë ratá no. Joxo xotaco qui ja aniquë. Jatsi jahëhua qui jahuë mapo ja aniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jabi Herodés ani ca nicahax Juan banahuacanaibo bëcaniquë jahuë yora bixëna. Bixo tsi quiha ja maihuajahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jatsi Jesu rabëti bo bacaniquë, naa Dios Chani yoatí raahacanish cabo. Jesu ya catixo tsi quiha jatiroha ca ja acanina, ja tiisimacanina, tihi cabo tsi quiha Jesu ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jatsi Jesu cacasniquë. —¿Nohiria yama ca qui nomë canomani? Naa nohiria misco no jisbayano, no joiparino iquish na —i jahuë rabëti bo qui Jesu niquë. Jabi huëstima ca nohiria ini quiha ja qui bëcanaina, bocanaina. Nohiria iqui tsi quiha piti xaba ja nariscaniquë. Jatsi ja yosanacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ja quëshpi tsi iti huëtsa qui ja bocaniquë notí no, jamëjacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Jama ja bocanai ca huëstima cabá jisniquë. Tsohuë cara ja icani ca ja cahëcana ca tsi rëquë ja jabacaniquë ja rërëcanai ca qui. Ja quënibonacani quiha. Quënihax Jesu bëbo ja cahëcani quiha. Jasca basima ca yaca bo ax ja jabacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jatsi tëmahinapama tsi quiha naa nohiria misco Jesú jisniquë. Jato ja noini quiha, jaha bësohamaca oveja jascaria ja icani quëshpi na. Japi huëstima ca jahuë bo jato tiisimatsi quiha Jesú huaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yata tsi quiha ja qui jahuë rabëti bo bëcaniquë yobaxëna. —Caquë bari tia —i Jesu qui jaca niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Basima ca yaca bo, huai bo, tihi cabo qui nohiria raatsana. Toa xo tsi jahuëcara ca ja copicano piti. Yama tsi xo piti nëá no —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jatsi Jesú nëca tsi jato quëbiniquë: —¿Mato tsani? Jato pimacana —iquiina. Jatsi ja chanicaniquë: —¿Jënahuariaxo raca tihiria ca mapari no copina, naa nohiria tëquë pimaxëna? Copixëniria quiha —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jatsi Jesú jato yoaniquë: —¿Jahuë tihi ca mapari jayahi ni nohiria bo ra? Tsayata —iquiina. Cahëhax, —Cinco ca mapari, dos ca sanino, tihi cabo jayacani quiha —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jatsi nohiria bo Jesú tsahomaniquë huasí no. ");
INSERT INTO caoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Maxo cincuenta, maxo cien, toca tsi jato ja tsahomani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Tsahomaxo tsi quiha cinco ca mapari, dos ca sanino, tihi cabo Jesú biniquë. Bichi tsi quiha mana nai qui tsayahax tsi “Gracias” i Dios qui ja niquë piti quëshpi na. Jatsi mapari bo ja tëxënamaniquë. Tëxënamaxo jahuë rabëti bo qui ja aniquë nohiria bo taati. Jaquirëquë sani ja tëxënamaniquë nohiria bo taaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Piniquë nohiria tëquëta. Ja sëyayocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jaquirëquë mapari quësi bo, sanino, naa pihama ca quëësi bo jahuë rabëti bá catianiquë. Doce ca caca rëahacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Jabi toá tsi cinco mil ca mapari picanai ca joni bo ini quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nohiria bo pimaxo tsi noti qui jahuë rabëti bo Jesú jicomaniquë, jabëbo Betsaida qui ja shitacano iquish na. Jasca, nohiria tëquë jahari jato xobo qui ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Jahuë rabëti bo raahax maca bo qui ja caniquë bëhox-xëna. ");
INSERT INTO caoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Bari caquë tsi quiha ia nëpax tsi jari noti ini quiha; jamë pistia maí tsi Jesu iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jatsi noiyamaria tsi ja huasha-huashacanai ca ja jisniquë, yoshi xotohai ca bëcha ja icanai quëshpi na. Jatsi patiari quëonox pari no tsi quiha jato qui Jesu caniquë, jënë cacha cohi na. Copama tsi jato ja tarabicasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jatsi jënë́ tsi Jesu cohai ja jiscaniquë. Bërocamaqui ja iqui ja quëscahuajahuacaniquë. Jatsi ja sai i-icaniquë raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jabi ja jiscaniquë jato tëquëta. Jisi tsi ja ratëyocaniquë. Jatsi Jesu jato qui chanitapiniquë: —Chamacana. Ea yoi xo naa. Raquëyamacana —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jatsi noti qui Jesu jicoquë tsi quiha pasiniquë yoshi xotohaina ra. Jatsi ratëyoniquë jahuë rabëti bo. Shinati ja cahëyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Quëstoria ini quiha jato shinana. Jasca, mapari ja tëxënamaquë tsi quiha tsohuë yoi ja iqui ca ja cahëyamayoicani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jatsi ia ja shitacaniquë. Shitaxo tsi quiha Genesaret mai qui ja rërëcaniquë. Toá tsi jato noti ja nëxacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ja tëmahinacaquë tsi quiha nohiria bá Jesu cahëtapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jatsi toa maí tsi pacanayocaniquë nohiria, iquicanaibo ja iqui ca qui bëxëna. Jato oxatí tsi anoma cabo ja qui ja bëcani quiha jënimahuahacati. ");
INSERT INTO caoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jasca, jatiroha ca Jesu cani ca qui, naa yaca bo, jihuëta bo, tihi cabo xo tsi jato anoma cabo ja janacaniquë bahí no. Jatsi Jesu ja bënariacaniquë jënimahuahacati, jahuë sahuëti quëpë roha motsacatsi na. Jabi jënimahuahacani quiha jahuë sahuëti motsanish cabo tëquëta ra. ");
INSERT INTO caoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jatsi jodioba chama bo, jato yoba tiisimacanaibo, tihi cabo cahëniquë Jerusalén ax na, Jesu tsayacascani na. ");
INSERT INTO caoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jabi jahuë rabëti bo tsayapama tsi quiha chocohama ca mëquënë tsi ja picanai ca ja jiscaniquë. Jodioba jabi, jato yoba, tihi cabo pasomaha ini quiha ja acanaina. Ja quëshpi tsi jodioba chama bo ranimisniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jabi jodioba yoba, naa jato naboyamaba yoba siri bo ja aria-ariacani quiha. Pinox pari tsi quiha ja mëchococani quiha. Jato jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Jasca, jato yoba iqui tsi mercadó ca copini ca jahuë bo ja chocohacani quiha pinox pari. Jato jabi quiha. Jasca, jato canico bo, jato olla bo, jato rato bo, tihi cabo ja chocohacani quiha. Jato naboyamabá ani ca yoba quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Jatsi bëcanish ca jodioba chama bá Jesu nicaniquë: —¿Jënixo tsi noba naboyamabá noqui ani ca yoba ayamahi ni mi rabëti bo? Mëchocoxoma tsi picani quiha pë. Anoma quiha —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jatsi Jesú jato quëbiniquë: —Quiaxëni xo mato ra. Parayamaniquë Isaías yamabo, mato yoati tsi ja quënëquë no: “Jato janá tsi jia tsi ëa ocahuacani quiha naa nohiria; jama, ëa basi jato shina nori. ");
INSERT INTO caoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mahitsa ë qui aracani quiha. ‘Dios yoba tsi xo naa’ icani quiha, jato mahitsa ca yoba nori” nëa tsi quiha Isaías yamabo nëcani quiha Quënëhacanish cabo ó no. ");
INSERT INTO caoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tsayacahuë. Dios yoba niaqui mato pë, mato joni bá tiisimahai ca yoba banahuaxëna —nëa tsi Jesu nëcaniquë jodioba chama bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jatsi Jesú rëtsaniquë, chanihi na: —Mato jabi bo, mato yoba bo, tihi cabo banahuaquí tsi Dios yoba-yobaria niaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Jabi Dios yoba Moisés yamabá mato qui aniquë: “Mato jahëpa, mato jahëhua noicana” iquiina. Jasca, “Namëhacati xo tsohuëcara ca jahuë jahëpa, jahuë jahëhua, tihi cabo ocahuahai cato” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jama, mato qui jënima tsi xo mato noitiria ca nabo nicayamahaina rë. “Jishopë. Mato mëbitimaxëni xo ëa rë, Dios qui noho parata ë aquitaha quëshpi na” iqui mato pë, jato mëbicasyamahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Jatsi mato nabo mëbiyamaqui mato rë. Mato qui jënima xo toca ca chanihaina pë. Jabi toca tsi Dios yoba niaqui mato ri, ma ani ca yoba ó bësocatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jabi tobi huëstima ca toca ca mahitsa ca jabi bo ma acaina rë —nëa tsi Jesu nëcaniquë bëcanish ca jodioba chama bo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jatsi nohiria bo quënatëquëhax tsi quiha Jesu chaniniquë: —Ea nicayocana. Ma cahëno ra. ");
INSERT INTO caoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Nohiria jochamayamahi quiha toa ja qui jicohaina. Jama, nohiria jochamahai ca tsi xo toa yoi ca ja shinahai ca ja chanihaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Jabi naa chani nicaxëti xo jatiroha cabo —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jatsi nohiria bo jisbëria tsi quiha xobo qui Jesu jiconiquë. Toa xo tsi jahuë rabëti bá nicaniquë ja yoaha ca chani yoati na. Jatsi Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","—¿E yoaha ca cahëyamahi ni mato ri ra? ¿Jënahuariaxo raca ma pihai cató mato shina yoshihuana? ");
INSERT INTO caoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Shina qui cayamahi quiha piti ra, jahuë poco qui nori. Cahax jahuë poco ax huajahi quiha —nëa tsi Jesu nëcaniquë. Jabi ja yoaha cató tsi jatiroha ca piti jënima iqui ca Jesú jismani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jatsi ja nëcaniquë: —Nohiria jochamahai ca tsi xo toa ja shinahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ja xara, naa jahuë shina quima ax johi quiha ja shinahai ca yoi cato. Yoi ca shinaquí tsi anoma ca jahuë bo aqui quiha rë. Jahuë shina yoi iqui tsi yomahi quiha nohiria ra. Ja quëshpi tsi tobi toa joni acaina, joni huëtsa ahui bichiina, ");
INSERT INTO caoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yoi ca ó quëëmis-haina. Jasca, jato yoi ca shinahai iqui tsi tobi quiha yoi ca acaina, paramis-haina, ranomis-haina, ranimis-haina, jamë shinamis-haina, yoyohaina. ");
INSERT INTO caoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Jabi joni xara, naa jahuë shina quima ax johi quiha naa yoi ca tëquëta. Ja tsi xo toa nohiria bo jochamahai cato, ja picanai ca nomari —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Toa ax riquicaya tsi quiha mai huëtsa, naa yaca Tiro y Sidón basima ca qui Jesu caniquë. Xobo qui jicoxo tsi quiha ja racahi iqui ca Jesú cahëmacasyamaniquë. Jama, mëri tsi quiha jahuë iti nohiria bá cahëniquë. Jonënoma ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Toatiyá tsi ja racani ca huësti ca yoxá nicaniquë, naa yoshi jaya ca jahi jayanish cato. Nicahax ja qui ja joniquë. Jatsi Jesu bësojó tsi quiha ja mënitapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Jabi carayana naa yoxa ini quiha, naa Sirofenicia maí conish cato. Mënixo tsi quiha Jesu ja bënarianiquë jahuë jahi ó ca yoshi natsëcati. ");
INSERT INTO caoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jatsi quiha Jesu ja qui chaniniquë: —¿Jënahuariaxo mia ë mëbina? Jodiobo qui roha ë raahacani quiha shomahuati. Jato ë mëbipariti xo ra. Noba jabi pasomaha tsi xo toa carayanabo mëbihaina. Noba xocoba mapari ini bo qui niahai jascaria xo —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Jatsi yoxá quëbiniquë: —Jabija, Taitá. Yoiria ca carayana roha ca ëa xo naa ra; jama, ¿jato chama quima ax paquëhax ca quëxë mishni bo piyamayamahi ni ina bo ra? Shomahuahacaqui ina bo ri ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jatsi Jesu yoxa qui chanitëquëniquë: —Jia tsi xo toa mi quëbihana. Ja iqui tsi mi jahi ë jënimahuaquë ra. Cata. Natsëquëquë mi jahi ó ca yoshini ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jatsi jahari jahuë xobo qui yoxa caniquë. Jënima, oxati raca ja ini quiha, xobo qui ja cahëquë no. Yama jahuë yoshi ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tiro mai riquicaya tsi quiha Sidón mai Jesu naconiquë Ia Galilea qui caxëna. Decápolis icanai ca yaca bo ja tarabiniquë caquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Toa xo tsi quiha patoxi ca jaro ca joni nohiria bá bëniquë ja qui. Bëxo tsi quiha Jesu ja bënariacaniquë, jahuë mëquë jaha ja janano. ");
INSERT INTO caoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Japi nohiria misco quima Jesú joni boniquë, jamë pistia ja bëtati. Jatsi joni pahoqui quiní tsi jahuë mëtsis Jesú pahostaniquë. Pahostaxo tsi quiha coshoxo tsi jahuë jana ja motsaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jaquirëquë nai qui tsayapama tsi quiha ja ëësiniquë. Jatsi, —Papëquëhuë ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jatsi nicatapiniquë joni. Bëro tsi quiha ja chaniniquë ra. Jënima quiha jahuë pahoqui, jahuë jana, tihi cabo iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jatsi nohiria bo qui Jesu chaniniquë: —E aca ca yoayamatsacana —iquiina. Jato ja pasimacasni quiha; mahitsa. Jato ja pasima-pasimaquë tsi quiha oquë tsi ja ani ca ja pacanamacaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Jatsi ratëyoniquë nohiria tëquë, ja ani ca nicahax na. —Anomaria tsi xo toa ja acaina ra. Patoxi cabo pasomahi quiha ra. Jaro cabo chanimahi quiha pa —nëa tsi nohiria bo nëcaniquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Jaquirëquë toatiyá tsi quiha nohiria misco catitëquëniquë, Jesu jiscatsi na. Jatsi jato piti ja quëyocaquë tsi quiha jahuë rabëti bo Jesú quënaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Noitiria tsi xo naa nohiria. Tres ca bari no tsi ë bëta ja icaquë. Jaboqui yama tsi xo ja picanaina rë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Paxnacanai ca jato xobo qui jato ë raapino tsi bahí tsi rësocanacaxëcani quiha tonia. Basi-basiria tsi xo toa huësti huësti ca bëcanana —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jatsi jahuë rabëti bá quëbiniquë: —¿Jënahuariaxo raca jato bax mapari bo no bina rë? Xobo yama ca iti tsi xo naa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jatsi Jesú nicaniquë: —¿Jahuë tihi ca mapari yani mato? —iquiina. —Siete ca mapari roha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jatsi nohiria misco ca ja tsahomaniquë maí no. Mapari bichi tsi quiha “Gracias” i Dios qui ja niquë. Jatsi mapari ja tëxënamaniquë. Tëxënamaxo tsi quiha jahuë rabëti bo ja mëaniquë nohiria misco bo taati. Jatsi mapari nohiria bo qui ja mëacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Jasca, huësti huësti ca sani mishni ja jayacaniquë. Naa sani bixo tsi quiha “Gracias” i Dios qui Jesu niquë. Jatsi jahuë rabëti bo qui sani ja mëaniquë nohiria bo taati. ");
INSERT INTO caoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Piniquë nohiria tëquëta. Ja sëyayocaniquë. Jabi tobi cuatro mil ca nohiria ini quiha picanaina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ja picaquë tsi quiha pihama ca quësi mishni bo ja topicaniquë. Jaquirëquë jato xobo qui nohiria bo ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Raahax noti qui ja jiconiquë jahuë rabëti bo ya. Jicoxo ia ja shitacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jatsi jodioba chama bo Jesu qui bëcaniquë ja qui joi mëraxëna. Jesu tanamacasquí tsi quiha Jesu ja nicacaniquë: —Mana ca jisti mi ano ra. Jisti pi mi ano tsi mia chahahuaxëqui noa ra —iquiina. Jabi ja tocacaniquë ja qui quësocastsi na pë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jato qui yosanahi tsi quiha jato qui Jesu nëcaniquë: —Jistí-naxëni xo mato pë. Mato bax ayamaxëquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jato jisbaya tsi quiha noti qui ja jiconiquë. Jatsi ia ja shitaniquë rabëquëx ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ia shitapama tsi quiha, —Jishopë. Mapari piti no shina-bënoquë rë —i Jesu qui jaca niquë. Jabi huësti ca mapari roha ja jayacani quiha notí no. ");
INSERT INTO caoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jatsi Jesú jato yobaniquë: —Jodioba chama bo, Herodes, tihi cabo ó tsi quiniacaxëcahuë, mapari levadura jascaria jaca nori iqui na. Mëri tsi pacanahi quiha jato yoi cato ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jatsi jato xërëquë tsi chaninatsijacaniquë. —¿Jënijaha sa? Toca tsi chanihi quiha pë, mapari no shina-bënoha iqui na, tonia —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jabi mapari yoati tsi ja chaninacanai ca Jesú cahëni quiha. Cahëhi tsi, —¿Jënihax tsi joi i-icanai rë, naa ma shina-bënoha ca mapari yoati na? —i jato qui Jesu niquë—. Ma shina-bënoha ca mapari shinayamaquia ra. ¿Jari cahëyamacanai? Quëstoria xo mato mapo rë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Bëro yama ni mato sa? Jatsi tsayacahuë. ¿Pahoqui jaya ni mato? Jatsi nicacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Cinco mil ca nohiria jaboqui ë pimayamaha? Jasca, ¿cinco ca maparí roha tsi jato tëquë ë pimayamaha? Jaquirëquë ¿jahuë tihi ca caca ma rëaha, naa mapari pihama cató no? —i jato qui Jesu niquë. Jatsi, —Doce ca cacano —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jatsi, —Jasca, siete ca maparí tsi cuatro mil ca nohiria ë pimahitaquë ra. Toatiyá tsi ¿jahuë tihi ca caca ma rëahitaha, pihama ca maparí no? —i Jesu niquë. Jatsi jahuë rabëti bá quëbiniquë: —Siete ca caca no rëahitaquë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jatsi, —¿Jari tsohuë ë nori ca cahëyamacanai? ¿Jari ma pihai ca mapari shinahi ni mato ra? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Betsaida yaca qui ja cahëcaquë tsi quiha bëco ca joni Jesu qui nohiriá bëcaniquë. Bëxo tsi quiha Jesu ja bënariacaniquë, joni jënimahuati. ");
INSERT INTO caoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jatsi yaca cacha Jesú joni mëpiniquë. Mëpixo tsi quiha jahuë bëro qui Jesu coshohaniquë. Jatsi jahuë mëquë jahá janaxo Jesú nicaniquë: —¿Jahuë tsayahai? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jatsi taisniquë joni. Tais-hax tsi quiha, —Nohiria bo jisquia. Jama, ë qui bohohai ca jihui bo jisiria ca xo rë —i Jesu qui joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jatsi joni bëro Jesú motsatëquëniquë. Ja bëpëquëquë tsi quiha jënima jahuë bëro iniquë. Bëroria quiha jatiroha ca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jatsi Jesú joni raaniquë jahuë xobo qui. Raahax, —Yaca qui mi jicotëquëyamano. Mi bax ë aca ca nohiria bo mi yoayamano ra —i joni qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jaquirëquë jahuë rabëti bo ya Jesu caniquë Cesareá ca Filipo mai ó ca yaca bo qui. Bahí copama tsi quiha jahuë rabëti bo Jesú nicaniquë: —¿Tsohuë ni ëa? ¿Jënihi ni nohiria bo ëa yoati na? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Jatsi jahuë rabëti bá quëbiniquë: —“Ashimanish ca Juan yamabo përë xo mia” ii quiha huësti huësti ca nohiria. “Elías yamabo xo mia” ii quiha nohiria huëtsa bo. “Tonia Dios Chani yoanish ca xo mia” ii quiha tëxë bo —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jatsi Jesú jato nicaniquë: —¿Jënihi ni mato ëa yoati na? ¿Tsohuë ni ëa yoi? —iquiina. Jatsi, —Dios raahacanish ca Xabahamati Ibo xo mia ra —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jatsi Jesú jato yobaniquë, Cristo, naa Xabahamati Ibo ja iqui ca yoayamati. ");
INSERT INTO caoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jatsi ja rësoxëhai yoati tsi chanitsi Jesu niquë: —Tënë-tënëxëquia ra, naa Nohiria Baquë ë nori cato. Ea niacaxëcani quiha jodioba yosibo, jato arati ibo ba chama bo, jato yoba tiisimacanaibo rë. Ea namëcaxëcani quiha ra; jama, tres ca bari huinocaquë tsi bësotëquëxëquia ra —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jabi bëro tsi ja rësoxëhai yoati tsi Jesu chaniniquë. Jatsi ori tsi Jesu Pedró boniquë jamë tsi ja qui chanixëna. —Anoma tsi xo toca tsi mi chanihaina ra —i Jesu qui ja niquë, raahahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jama, Jesu bopinaniquë. Bopinaxo tsi quiha Pedro ja raahaniquë, jahuë rabëti bo tsayaquí na. —Ea basihuë, Satanás. Dios shinahai ca jasca ma xo toa mi shinahaina, nohiria bá shinahai jascaria nori —i Pedro qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jatsi jahuë rabëti bo, nohiria misco, tihi cabo Jesú quënaniquë yobati. —Ea pi banahuacasquí tsi ma acatsai ca ma shinayamati xo. Jaquirëquë mato cruz iacana. Iaxo ëa banahuacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jabi xabahamahacayamaxëhi quiha jahuë noma jabi ó quëëmisxëni cato. Jama, xabahamahacaxëhi quiha jahuë noma jabi chihohuahai cato, ëa, noho chani, tihi cabo quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Jabi jatiroha ca maí ca jahuë bo nohiriá bëbomitsa; jama, tënëtiya qui caapiquí tsi ¿jahuë raca ja bëbona? ");
INSERT INTO caoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jabi jahuë shina pi bënoquí tsi ¿jahuë raca Dios qui nohiriá ana ra, jahuë shina bitëquëxëna? ");
INSERT INTO caoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Jabi anoma ca jochahuaxëni tsi xo naa jaboqui bësocanaibo iquia. Jabi ëa, noho chani, tihi cabo qui naa nohiria bo rabino tsi jato qui rabixëquia ëa ri, xaba huëtsá tsi ë joxëquë no. Toa barí tsi ángel bo ya tsi joxëquia ra, noho Jahëpa chamá no ra, naa Nohiria Baquë ë nori cato —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jatsi jahuë chani Jesú rëtsaniquë: —Mato parayamaquia. Chamá tsi joxëhi quiha Diós otohaina ra. Jasca, ja johai ca jisxëqui mato huësti huësti cabo ra, ma rësonox pari —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jatsi seis bari quirëquë, Pedro, Jacobo, Juan, tihi cabo maca qui Jesú boniquë jato bëtarohaxëna. Toá tsi quiha jahuë jaria jabitiniquë jato bësojó no. ");
INSERT INTO caoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Joxonariani quiha jahuë sahuëti; huëa jascaria quiha. ¿Tsohuë raca toca tsi raiti joxohuana? ");
INSERT INTO caoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jatsi Elías yamabo, Moisés yamabo, tihi cabo jisiquiniquë. Jesu ya chanihi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jatsi Jesu qui Pedro chaniniquë: —Noqui jia tsi xo nëá no iquiina. Nëa xo tsi tres ca tapas axëqui noa ra; huësti mi-na, huësti Moisés-na, huësti Elías yamabá-na —nëa tsi Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jabi jahuëcara chaniti Pedró cahëyamani quiha raquëquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jatsi tsëmo joniquë. Joxo tsi quiha jato ja mapaniquë. Jatsi tsëmó ca joi chaniniquë: —Noho Baquë yoi tsi xo naa ra. Noiquia. E qui jia tsi xo toa ja acaina ra. Ja qui nicacana —i joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jatsi nëjo nëjo taistapipama tsi quiha yama ca ja jiscaniquë. Jesu roha jato bëta ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Jatsi maca ax botëjacano tsi quiha jato Jesú yobaniquë: —Ma jisi ca nohiria bo jari yoayamacana. Jariapari tsi rësohax bësotëquëxëquia ra, naa Nohiria Baquë ë nori cato. Jaquirëquë jënima tsi xo nohiria bo ma yoahaina ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jatsi ja bëpacaniquë. Jama, ja yoaha ca ja cahëyamacani quiha. Jaha tsi, —¿Jënihax tsi “Bësotëquëxëquia” i ja a sa? —i jaca niquë chaninahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Cahëcasquí tsi quiha Jesu ja nicacaniquë: —“Xabahamati Ibo jonox pari no tsi joxëhi quiha Elías chama jaya ca pari” ii quiha noba yoba tiisimacanaibo. ¿Jabija ni toa ja yoacanaina? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jatsi Jesú jato quëbiniquë: —Jariapari joxëhi quiha Elías, naa Dios chama jaya cato. Joxo tsi jatiroha ca paxahuaxëhi quiha. Jabija tsi xo toa ja yoacanaina. Jama, “Tënëxëhi quiha Nohiria Baquë ri. Niaxëhi quiha nohiria bo rë” ¿i Dios Chani yoanish cabo yamayamani? ");
INSERT INTO caoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Jabi joniquë Elías ra, naa Dios chama jaya cato. Ja joquë tsi ja qui nohiria bá yosiniquë rë, mato Quënëhacanish cabá yoani ca jascaria —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jatsi maca ax botëxo tsi quiha nohiria misco ja jiscaniquë. Jesu rabëti bo yaxo joi mërahi jodioba chama ini quiha. Jato tëamë tsi nohiria misco mani ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jatsi Jesu jisi tsi nohiria bo shina-risiquiniquë. Ja qui ja jabayocaniquë joihuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jatsi Jesú jahuë rabëti bo nicaniquë: —¿Jënixo tsi joi mëracanai? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jatsi toá ca nohiria xërëquë ca joní quëbiniquë: —Mi qui noho baquë ë bëquë ra, jënimahuahacati. Yoshi jaya xo rë. Jaro quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Noho baquë qui tsamiquí tsi mai qui niahi quiha rë. Jatsi jabacoxhi quiha noho baquë. Xëta mayëquërëhi quiha. Jatsi huishta-huishtahi quiha ra. Anoma quiha. Jabi, “Noho baquë ó ca yoshi tsëcacahuë” i mi rabëti bo qui ë quë. Tsëcatimaxënicana rë —nëa tsi Jesu qui joni nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jatsi Jesú quëbiniquë: —Chitimitimaxëni ca yosaxëni ca nohiria xo mato pë. ¿Jahuë tihi tsi mato tënëxëhi ni ëa ra? Mi baquë nëri bëhuë —nëa tsi joni qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Jatsi Jesu qui jahuë baquë ja bëcaniquë. Jatsi pë Jesu jisi tsi quiha yoshiní baquë caxo amaniquë. Paquëniquë baquë. Maí tsi ja robi-robiniquë, ja bacoxhaina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jatsi pë Jesú jahuë jahëpa nicaniquë: —¿Jahuë tihi tsi nëca tsi ja ini? —iquiina. Jatsi jahuë jahëpa chaniniquë: —Baquë pistia ax rohari. ");
INSERT INTO caoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huëstima tsi chihi, jënë, tihi cabo qui yoshiní noho baquë niani quiha axëna. Japi noqui shinahuë ra. Noqui mëbihuë ra. Mia roha tsi xo toa ati chama jaya cato ra —i jahëpa niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jatsi, —“Ati chama jaya xo mia” ¿i mi a pa? Acacati xo jatiroha cato, Dios qui chitimihai ca bax na iquia —i jahëpa qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jatsi quiha jahëpá quëbitapiniquë: —Dios qui chitimiquia ra. Jama, ëa chamahuahuë ra, oquë tsi ë chitimino iquish na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jatsi ja qui quëtsohai ca nohiria misco anihai ca jisi tsi quiha baquë ó ca yoshi Jesú raahaniquë: —Natsëquëhuë ra, yoshi jaro patoxi cató. Baquë qui jicotëquëpistiayamariaxëhuë iquia —nëa tsi quiha Jesu nëcaniquë yoshi qui. ");
INSERT INTO caoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jatsi yoshiní jahuë baquë sai i-imaniquë. Caxo amahax tsi quiha ja natsëquëniquë ra. Jabi toa tsi pë chaparoha baquë ini quiha maí no. Ja rësoni nohiria bá quëscahuaniquë. Jaha tsi quiha, —Naquë baquë ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jatsi pë Jesú jahuë mëquë achaniquë. Achaxo tsi quiha baquë ja joimaniquë. Niiniquë baquë ra. Jënima quiha ja iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jaquirëquë, xobo qui Jesu jicoquë tsi, —¿Jënixo tsi jahuë yoshi tsëcanoma no iqui? —i Jesu qui jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jatsi Jesú jato yoaniquë: —Bëronoma tsi xo nëca ca yoshi natsëcahaina ra. No bëhoxhai cató tsi ja natsëcahacaxëti xo ra. Yama xo quinia huëtsa —i quiha jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Toa mai ax riquibaya tsi quiha Galilea mai ja nacocaniquë. Nohiria bo basi Jesu chitëniquë jahuë rabëti bo tiisimacatsi na. Chanihi tsi, —Nohiria bo qui ë mëahacaxëti xo. Jatsi ëa acaxëcani quiha. Jama, tres bari quirëquë bësotëquëxëquia ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jabi Jesú yoaha ca jahuë rabëti bá cahëyamaniquë. Jama, —¿Jënihi ni mi yoahaina? No joma —iyama jaca ni quiha raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jatsi Capernaum yaca qui ja cahëcaniquë. Xobo qui jicoxo tsi quiha Jesú jahuë rabëti bo nicaniquë: —Bahí bohopama tsi ¿jahuë yoati tsi joi mëranahi ma iqui? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jatsi ja bëpacaniquë, yoacasyamaquí na. Ja bërabicani quiha jato xërëquë ca oquë ca iqui ca yoati tsi chaninahi ja icani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jatsi Jesu tsahoniquë. Tsahoxo tsi quiha jahuë doce ca rabëti bo ja quënaniquë. Chanihi tsi, —Ja cho ixëti quiha tsohuëcara ca rëquë icatsai cato. Jatiroha cabo ja mëbixëti xo —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jatsi baquë pistia jato nëpax tsi Jesú jananiquë. Baquë icohax ja rëtsaniquë. Chanihi tsi, ");
INSERT INTO caoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Jabi ëa joihuahi quiha tsohuëcara ca noho janë́ tsi nëca ca baquë joihuahai cato. Jasca, ëa raanish ca ri joihuahi quiha ëa joihuahai cato ra —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jatsi Juan chaniniquë: —Mi janë́ tsi yoshi natsëcahai ca joni no jisitaquë ra. “Ayamahuë ra” i ja qui no itaquë; noba maxo quirima ja iqui iqui na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jatsi, —Toa jënëyamacana —i ja qui Jesu niquë—. Ea ocahuatimaxëni tsi xo toa noho janë́ tsi jisti acai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Noba rabëti tsi xo toa noqui pasomahama cato iquia. ");
INSERT INTO caoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Mato parayamaquia. Copihacaxëhi quiha chahahuacanaibo mëbihai cato ra, ëa iqui tsi jënëpaxa roha jato qui ja aquë no. ");
INSERT INTO caoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","‘Jabi jia tsi ë qui chitimicani quiha naa xocobo mishni bo. Japi noitiriaxëhi quiha nëca ca chahahuabëna cabo ë quima bësomahai cato ra. Anomariaxëhi quiha jahuë copi ra. Ja acai quëshpi tsi tërotamë ca rënëti maxax ya nëmi ca ia qui ja niahacati xo iquia. Jama, oquëria ca copi bixëhi quiha ra, ja aca ca yoi ca quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mato mëquënë́ pi mato jochamacasno tsi mërëësicahuë. Oquë tsi xo toa mërëxto tsi nai qui cahaina. Noitiria tsi xo toa tënëtiya qui niahacahaina mëquë ya. ");
INSERT INTO caoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Nocatimaxëni tsi xo toa tënëtiya chihi ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Jasca, yoi ca qui mato tahë́ pi mato bono tsi jorëësicahuë. Oquë tsi xo toa jorëxto tsi nai qui cahaina. Noitiria tsi xo toa tënëtiya qui cahaina tahë ya. ");
INSERT INTO caoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Nocatimaxëni tsi xo toa tënëtiya chihi ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Jocha quiri pi mato bëró mato bësomano tsi bëtsëquëcahuë. Oquë tsi xo Diós otohai ca qui huësti ca bëro ya roha jicohaina. Noitiria tsi xo toa rabë ca bëro ya tënëtiya qui niahacahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nocatimaxëni tsi xo toa tënëtiya chihi ra. ");
INSERT INTO caoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","‘Tënëhai cató tsi rohahuahacaxëti xo jatiroha cabo. ");
INSERT INTO caoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Chopara jia ca jascariacana. Jia tsi xo chopará tëëhuahaina. Jama, jahuë tëë bënopiquí tsi ¿jënahuariaxo ja tëëhuana? —nëa tsi Jesu nëcaniquë nohiria bo tiisimahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jatsi toa ax riquiquiria tsi, jodioba mai qui Jesu caniquë, naa Jordán rabëquëx cato. Ani Jordan ja shitaquë tsi quiha ja qui nohiria misco quëtsotëquëniquë. Jatsi tiisimatsi Jesú huaniquë. Jahuë jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jatsi ja qui huësti huësti ca jodioba chama bo bëcaniquë tanamaxëna. Ja qui joi mëratsijahuacani quiha. Jatsi, —¿Anoma ni joní jahuë ahui niahaina? —i Jesu qui jaca niquë, ja qui quësocascani na. ");
INSERT INTO caoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Quëbihi tsi, —¿Jëni Moisés ni? ¿Jahuë yoba mato qui ja ani? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Jatsi jodioba chama bá quëbiniquë: —Moisés qui jënima ja ini quiha. Jariapari tsi quiha ahui niati papi joni ja huishamani quiha ahui mëati. Ahui qui toa papi mëajahuaquë tsi quiha jënima Moisés qui ini quiha toa jahuë ahui joní niahaina ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jatsi, —Majia —i Jesu niquë—. Mato jochahuaxëni ca quëstoria ca shina iqui tsi toa yoba mato qui Moisés yamabá ani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Dios quinia ma xo toa ahui niahaina ra. Jariapari tsi quiha joni, yoxa, tihi cabo Diós nëhohuaniquë racanabëquiti. ");
INSERT INTO caoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ja tsi xo toa jahuë jahëpa, jahuë jahëhua, tihi cabo jisbayahi quiha joni, jahuë ahui qui riiti. (Jasca, jahuë nabo jisbayahi quiha yoxa ri, jahuë bënë qui riiti.) Jatsi racanabëquicani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Toca tsi huëstinacani quiha dos cabo, naa ahui bënë tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Jabi Diós racanabëquimaha ca nohiria bá bëquëxyamano ra —nëa tsi jodioba chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jatsi xobo qui jicoxo tsi quiha jahuë rabëti bá Jesu nicatëquëniquë, naa joní ahui niahai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Quëbihi tsi, —Jahuë ahui pi niaquí tsi ahui pasomaha jochahi quiha joni, ahui paxa ca ja biquë no. ");
INSERT INTO caoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jascaria jahuë bënë pi niaquí tsi ja pasomaha jochahi quiha yoxa ri, bënë paxa ca ja biquë no —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Huësti huësti ca nohiria bá jato xocobo Jesu qui bëniquë, jato ja shomahuano iquish na. Jama, jato nabo raahatsi jahuë rabëti bá huaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jatsi jato ja raahacahai ca jisi tsi quiha jahuë rabëti bo qui Jesu caxaniquë. Chanihi tsi, —Nëri ë qui xocobo bëcano ra. Jato chitiayamacana. Nëca cabo otocatsi quiha Dios. Ja qui jia quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mato parayamaquia. Bëroria tsi Diós jato otohai ca bichi quiha xocobo ra. Jabi xocobo jascaria pi Diós otohai ca biyamahi tsi Diós otohai ca qui jicoyamaxëhi quiha mato ra —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jatsi xocobo icoxo tsi jato ja shomahuaniquë. Jahuë mëquë jato ó tsi ja janani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Bahí tsi Jesu cano tsi quiha ja qui joni jabaniquë. Ja bësojó tsi ja mëniniquë. Mënihax ja chaniniquë: —¿Jënahuaxëhi ni ëa ra, Maestro jiaxëni cató, bëso-bësopaoxëti? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jatsi Jesu ja qui chaniniquë: —¿“Jiaxëni cato” ëa mi quënaha pa? Yama tsi xo jiaxëni cato ra. Ja huësti ca tsi xo Dios. ");
INSERT INTO caoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jabi Moisés yoba bo cahëqui mia tonia. “Nohiria ayamahuë” ii quiha. Jasca, “Joni huëtsa ahui biyamahuë; yomayamahuë; quiayamahuë; parayamahuë; mi ipa, mi ihua, tihi cabo noihuë,” tihi ca tsi ii quiha jahuë yoba —nëa tsi Jesu nëcaniquë joni qui. ");
INSERT INTO caoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jatsi, —Toa yoba bo tëquë ë nicaquë xocobo xo rohari, Maestró —i Jesu qui joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jatsi noixo joni Jesú bëisniquë. Chanihi tsi, —Huësti roha tsi xo toa mi naris-haina ati. Cata. Mi jahuëmishni bo tëquë iniahuë. Iniaxo toa parata noitiria cabo qui ahuë. Toca pi mi no tsi mana ca rico ca jahuë bo jayaxëqui mia naipá no. Jaquirëquë johuë. Ea mi banahuano ra —i joni qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jatsi joni cohuënaniquë Jesú yoaha ca nicahax na. Cohuë tsi quiha ja bacaniquë, rico-ricoria ja iqui iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jatsi nëjo nëjo tsi quiha jahuë rabëti bo Jesú tsaya-tsayaniquë. Chanihi tsi, —Bëronoma tsi xo toa rico ca joni Diós otohai ca qui jicohaina ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jatsi ratëniquë Jesu rabëti bo, ja yoani ca nicahax na. Jama, jari jasca pi Jesu chaniniquë: —Bëroma tsi xo Diós otohai ca qui jicohaina ra, noho xocobá. ");
INSERT INTO caoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jahuë chama yoí tsi bëronoma tsi xo Diós otohai ca qui rico ca jicohaina iquia, naa sopiri quini camelló nacohai jascaria nori —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jatsi ratëyorianiquë jahuë rabëti bo ja yoani ca nicahax na. Chaninahi tsi, —¿Yama tsi xo toa xabahamahacati mëtsa cato rë? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jatsi Jesú jato yoaniquë: —Jabija. Jamë xabahamatimaxëni tsi xo nohiria. Dios roha tsi xo toa nohiria xabahamahaina. Jatiroha ca ati mëtsa xo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jatsi Pedró quëbiniquë, —Tsayahuë. Jatiroha ca no jisbërianiquë mia banahuaxëna —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jatsi, —Mato parayamaquia —i Jesu niquë—. Copihacaxëhi quiha ëa banahuahai cato ra. Ea, xabahamati chani, tihi cabo iqui tsi jahuë xobo, jahuë xatë bo, jahuë jahëpa, jahuë jahëhua, jahuë ahuini, jahuë xocobo, jahuë mai, tihi cabo pi jisbëriaquí tsi ");
INSERT INTO caoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","cien ca veces huino bixëqui ëa banahuahai cato, jaboqui bësohi na. Xobo bo, xatë bo, jahëhua bo, xocobo, mai bo, tihi cabo bixëhi quiha tënëpiquí na. Jasca, mana ca copi bixëhi quiha bësoti paxa ca tsëquëxëquë no. Jatsi bëso-bësopaoxëqui toa. ");
INSERT INTO caoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jishopë. Toa barí tsi jachoxëhi quiha huëstima ca jaboqui rëquë cabo. Jasca, rëquëxëhi quiha huëstima ca jaboqui jacho cabo. ");
INSERT INTO caoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalén qui jahuë rabëti bo ya capama tsi quiha jato bëbo Jesu cohi iniquë. Shina-huëjë jahuë rabëti bo ini quiha. Jasca, shina-huëjëni quiha bacahai ca nohiria bo ri. Capama tsi quiha jahuë rabëti bo ya roha Jesu chanicananiquë ja rësoxëhai ca yoati na. Chanihi tsi, ");
INSERT INTO caoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Nicapa. Jerusalén qui caqui noa rë. Toa xo tsi arati iboba chama bo, yoba tiisimacanaibo, tihi cabo qui mëahacaxëquia rë. Jatsi ë qui quësocaxëcani quiha, “Namëhacati xo” iquiina. Jaquirëquë ë qui quësoxo tsi carayanabo qui ëa mëacaxëcani quiha acacati. ");
INSERT INTO caoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Jatsi ëa mahuacaxëcani quiha naa carayanabo. Rispichí tsi ëa rashacaxëcani quiha. Rashaxo tsi ëa namëcaxëcani quiha. Jama, tres bari quirëquë bësotëquëxëquia ra —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jatsi Jesu qui Juan, Jacobo, tihi cabo bëcaniquë, naa Zebedeo baquë bo. —Tobi jahuëcara ca no bax mi ano ra, Taitá —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jatsi, —¿Jahuë mato bax axëhi ni ëa? —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Jatsi Jesu ja quëbicaniquë: —Mana xo tsi mi yonano tsi mia tapaí tsi tsahocasqui noa, huësti ca mi mënëcayá no, huëtsa mi mëxojó no —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jatsi Jesú quëbiniquë: —Ma bënahai ca cahëyamaqui mato ra. ¿Tënëti mëtsa ni mato ra, naa ë tënëmahacapaimaria ca jascaria? Anomariaxëhi quiha noho cohuë. Jasca, anomariaxëhi quiha ë tënëhaina ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jatsi, —Jaahuë. Mia jascaria tsi tënëti mëtsa xo noa ra —i Jesu qui jaca niquë. Jatsi, —Tënë-tënëxëqui mato ra, naa ë tënëmahaca-xëhai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jama, noho mënëcayá ca tsahoti, noho mëxojó ca tsahoti, tihi cabo mato qui ati mëtsama xo ëa ra. Dios tsi xo toa tsahoti bo acai cato. Ja shomahuaha cabo qui axëhi quiha ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jabi jaha ja quëëcana ca nicahax Jacobo, Juan, tihi cabo qui jahuë rabëti bo tëxëbo caxaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Japi Jesú jato catianiquë jato qui chanixëna. —¿Jato nohiria yonamisyamayamacahi ni país ca chama bo rë? Chama jayaca xo jato nohiria yonariati ra. ");
INSERT INTO caoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Anoma tsi xo toa ja yonamiscanaina; jama, ma tocayamaxëti xo ra. Mato yonati pari ixëti quiha mato ó ca chama manëcatsai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yonati manëxëti xo toa nohiria bo rëquëninicatsai cato. Jatiroha cabo ja mëbixëti xo iquia. ");
INSERT INTO caoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jabi mai qui ë joyamaniquë mëbihacati; jama, nohiria bo mëbiti nori. Jabi ëmë aquia nohiria bo bax nati, jocha quima huëstima ca nohiria paquëmaxëna —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jatsi Jericó icanai ca yaca qui ja cahëcaniquë. Ja riquicano tsi quiha nohiria misco banahuahi iniquë. Jabi toá tsi naa bahi tapaí quiha Bartimeo, naa Timoteo baquë tsaho iniquë. Bëco ja ini quiha. Toa xo tsi parata bënahi ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Jesu tarabihai ca nicaquí tsi quiha quënatsijahuaniquë. Joi pistiamá tsi quiha, —Ea shinahuë, David yamaba Baquë Jesú —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jatsi raahatsi nohiria bá huaniquë; —Pasihuë, pasihuë —iquiina. Jatsi oquë tsi ja quëna-quënaniquë: —Ea shinahuë ra, David yamaba Baquë́ —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jatsi Jesu niiniquë. Niihax, —“Nëri johuë” i ja qui cana —i Jesu niquë. Japi bëco ca ja quënacaniquë. —Chamahuë. Joihuë. Mia quënahi quiha —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jatsi jahuë capa, naa pocho jasca ca niahax ja niiniquë. Niihax Jesu qui ja joniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jatsi, —¿Jënahuaxëhi ni ëa mi bax na? —i ja qui Jesu niquë. —Taistëquëcasquia ra —i bëco ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jatsi, —Cata. E qui mi chitimihai iqui tsi taisqui mia iquia —i ja qui Jesu niquë. Jatsi taistapiniquë joni. Bahí tsi Jesu ja banahuaniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jabi yaca Betfagé, yaca Betania, naa Maca Olivo Ya quiri bëso ca yaca qui cahëpama tsi quiha rëquë dos ca rabëti bo Jesú raaniquë. Jerusalén basima ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Jato raanox pari tsi quiha jato ja yobaniquë: —Mato bëbo ca yaca qui jicocana. Jicoxo tsi nëxë ca burro jisxëqui mato, naa masohuahama ca burro quiha. Mëriscana. Mërisxo tsi nëri bëcahuë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jabi, “¿Jënixo tsi burro mëriscanai?” i tsohuëcara pi no tsi “Bicatsi quiha Ibo. Tanaxo tsi jahari raaxëhi quiha” i jato qui cana —nëa tsi Jesu nëcaniquë jato raanox pari. ");
INSERT INTO caoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jatsi ja bocaniquë. Bahí ca burro baquë ja tsayacaniquë. Nëxë ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mërisjahuacano tsi quiha, —¿Jënahuariaqui burro baquë mëriscanai ra? —i jato qui toá ca nii ca joni bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jatsi joni bo ja quëbicaniquë, naa Jesú yoaha ca jato yoahahi na. Jatsi, —Bicahuë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jatsi Jesu qui burro baquë ja bëcaniquë. Bëxo tsi quiha jato sahuëti bo ja capohuëcaniquë. Jatsi burro cacha Jesu tsahoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jatsi rëquë huëstima ca nohiria bá jato sahuëti bo poohabonaniquë bahí no. Jasca, mëshi bo nohiria huëtsa bá quëësacaniquë bahí tsi poohaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jatsi quënatsi rëquë bocanaibo, ja cho bocanaibo, tihi cabá huaniquë. —Joihuacana ra. Shomahuahaca ca tsi xo naa Iboba janë́ tsi johai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Shomahuaha ca tsi xo noba chama David yamaba chamá tsi johai cato. Jia tsi ja yonano ra. Naipá cabá ocahuano ra —nëa tsi nohiria bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Toca tsi Jerusalén qui Jesu jiconiquë. Jicohax templo qui Jesu caniquë, naa jodioba arati xobo-xoboria. Jicohax ja nëjo nëjo taisniquë, jatiroha ca tsayahi na. Tsayahax Betania qui ja caniquë, jahuë rabëti bo ya. Caniquë bari ra. ");
INSERT INTO caoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huëaquë Betania ax riquiquiria tsi quiha paxnahi Jesu iniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Bacapama tsi quiha ori pistia ca higuera bimi jihui ja jisniquë. Japi jihui qui ja caniquë bimi mëraxëna. Yama quiha, jahuë pëhi roha. Jari bimitiya ma quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jatsi higuera jihui qui ja chaniniquë pa: —Mi bimi pitëquëpistiayamariaxëhi quiha nohiria ra —i jihui quiina. Jabi ja yoaha ca jahuë rabëti bá nicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jerusalén qui cahëhax templo, naa jodioba arati xobo-xoboria qui Jesu jiconiquë. Jicoxo tsi quiha cacha toá ca iniacanaibo raatsijahuaniquë. Raaquí tsi quiha parata rarinamacanaiba mesa bo ja narabaniquë. Boto iniacanaibo tsahoti bo ja pacanamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Jasca, nohiria, naa jato jahuëmishni bo iniacascanaibo ja quëtianiquë, templo qui ja nacoyamacano iquish na. Tihi tsi ja ani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jaquirëquë jato ja tiisimaniquë. Tiisimahi tsi, —“Bëhoxti xobo quënahacati xo noho xobo” ¿iyamayamahi ni Quënëhacanish cabo? “Nëá tsi bëhoxti quiha jatiroha ca país ca nohiria” ii quiha. Jama, yomacanaiba iti Dios xobo manëmaqui mato pë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jatsi Jesú aca ca nicaxo tsi quiha jodioba chama bo Jesu qui tsamicasniquë, naa arati iboba chama bo, jato yoba yoacanaibo. Ja qui caxa ja icani quiha. Japi Jesu ati quinia mëratsijahuacaniquë. Jama, jari ja qui ja tsamiyamacani quiha nohiria misco iqui na. Jari nohiria qui jia Jesú tiisimahai ca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jatsi quiha yata yaca Jesú jisbayaniquë jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Huëaquë tsi bahí tsi bohopama tsi quiha higuera jihui ja jiscaniquë. Jano tëquë ja ini quiha; bëso yama. ");
INSERT INTO caoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Jatsi Jesú yoahitaha ca Pedró shinaniquë. Shinahax, —Tsayapa, Maestró. Naquë mi yoshihuahitaha ca jihui ra —i Jesu qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jatsi quiha Jesú jato quëbiniquë: —Dios qui chitimicana. ");
INSERT INTO caoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mato parayamaquia. Dios qui chitimiyoipihi tsi “Tsëquëhuë. Ia qui mimë niahacahuë” iti mëtsaxëqui mato naa maca qui. Chitimiyoipimano tsi mato qui nicaxëhi quiha macana ra. Ocapixëhi quiha mi yoahana iquia. ");
INSERT INTO caoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ja tsi xo toa “Chitimiyoicana” mato qui iquia, ma bëhoxquë no. Chitimiquí tsi ma bënahai ca bixëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Jasca, Dios qui bëhoxquí tsi mia ocahuahai cató aca ca shina-bënocana. Jato qui caxayamacana. Tocapimano tsi mato jocha shina-bënoxëqui Dios ri. Mato qui caxayamaxëqui —nëa tsi quiha jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jatsi Jerusalén qui Jesu bacaniquë jahuë rabëti bo ya. Templo, naa jodioba arati xobo-xoboriá tsi ja cono tsi quiha ja qui jodioba chama bo bëcaniquë. Bëcani quiha arati iboba chama bo, jato yoba tiisimacanaibo, jodioba yosibo. ");
INSERT INTO caoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Bëxo tsi quiha Jesu ja nicacaniquë: —¿Tsohuë mi qui chama aquitaha, templo quima iniacanaibo cacha niati pë? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jatsi Jesú jato quëbiniquë: —Mato nicapariquia ëa ri. Ea pi ma quëbino tsi ë qui toca ca ati chama anish ca mato yoaxëquia. ");
INSERT INTO caoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jatsi, ¿tsohuë Juan yamabo qui chama ani, jahuë yonoco ati? ¿Dios ni? ¿Joni ni? Toa nicaquia ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jatsi joi i-ibëquitsijacaniquë: —¿Jënihi ni noa rë? “Dios” ipinono tsi jatsi “¿jënixo tsi Juan yamabo ma chahahuayamani?” i noqui xëhi quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Jasca, ¿jëniriahax raca “Joni” i nona rë? —nëa tsi quiha ja nëcacaniquë chaninahi na. Nohiria bo qui ja raquëcani quiha, “Dios Chani yoati ibo Juan yamabo iniquë nori” i nohiria bo ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ja quëshpi tsi, —Cahëyamaqui noa —i jaca niquë quëbihi na. Jatsi, —E qui toca ca ati chama anish ca mato yoayamaxëquia ëa ri —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jatsi chani huëtsa Jesú yoaniquë nohiria bo tiisimaquí na. Jahuë jabi quiha. Ja nëcaniquë: —Huai joní ani quiha. Axo tsi quiha toa xo uva icanai ca bimi ja bananiquë. Jaquirëquë tëamë ca panë ja aniquë. Jatsi maxaxá ca trapichi ja aniquë jënëria ati. Axo tsi quiha jaha bësoti xobo ja aniquë, naa torre icanai cato. ‘Jaquirëquë joni huëtsa bo qui jahuë huai ja aquëniquë bimi xatë quëshpi na. Aquëhax jahari xobo qui ja cani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jatsi tësatiya tsëquëquë tsi quiha jahuë huaí ca yonococanaibo qui jahuë yonati ja raaniquë, jahuë bimi xatë biti. ");
INSERT INTO caoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Jama, ja cahëquë tsi quiha jahuë yonati qui ja tsamicaniquë pë. Tsamixo jahuë yonati ja sëtiacani quiha. Sëtiahax tsi quiha mëquëya jahari jahuë yonati ja raacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jatsi quiha yonati huëtsa ibobá raaniquë. Ja macoaishacani quiha. Bërabihuajahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jatsi yonati huëtsa ibobá raaniquë. Toa yonati ja acaniquë. Huëtsa bo ja raaquë tsi quiha ja jascapijahua-caniquë. Huësti huësti ca ja sëtiacani quiha. Huëtsa bo ja tëpascani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","‘Jama, tobi ini quiha huësti ca raahama cato ra; naa jahuë baquë yoi quiha. Jabi jahuë baquë ja noini quiha. Jarohari tsi jahuë baquë yoi ja raaniquë, “Noho baquë yoi roha chahahuacaxëcani quiha tonia” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jama, jahuë baquë jisi tsi, “Iboba baquë tsi xo naa johaina ra. ¿Ai canomani? Axo jahuë huai ibohuaxëqui noa ra” i jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jatsi baquë qui tsamixo tsi quiha ja acaniquë. Axo tsi quiha jahuë huai cacha jahuë yora ja niacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jatsi toa cabo Jesú nicaniquë: —¿Jënahuaxëhi ni huai ibo, joxo na? Joxo tsi ¿toa joni bo ayamayamaxëhi ni? Axo tsi joni huëtsa bo qui jahuë huai aquëxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Jasca, ¿Quënëhacanish cabo ó ca ma jisyamani naa yoati na? “Oquënaxëhi quiha yosibá niaha ca Maxaxa ra” ii quiha. “Oquë-oquëria ca tsi manëxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Diós aca ca tsi xo naa ra. Noqui jia tsi xo toa ja acana” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jatsi jodioba chama bo Jesu qui tsamicasniquë, jato yoati tsi ja chaniha ca ja cahëcani quëshpi na. Jama, ja qui tsami-yamajacani quiha nohiria bo qui raquëhi na. Japi jisbaya tsi quiha ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jatsi jodioba chama bo, Herodes yonati bo, tihi cabo Jesu qui raahacaniquë tanamati. Yoi ca chani ja amacasjahuacani quiha ja qui tsamixëna. ");
INSERT INTO caoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jatsi Jesu qui ja bëcaniquë. Chanipama tsi, —Shina jiaxëni ca parayamahai ca joni tsi xo mia ra, maestró. Nohiria shinahai ca chahahuayamaqui mia. Mi qui jaharisi tsi xo nohiria tëquëta. Dios quiniá roha tsi tiisimaqui mia. Japi mia nicacasqui noa: ¿Romanoba chama-chamaria qui impuesto bo no ati ni, naa noqui jodiobo? ¿Mi qui jia ni? ¿Jato qui axëhi ni noa ra? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jama, ja paracascanai ca Jesú jisniquë. Ja tsi xo toa, —¿Jënixo tsi ëa tanamacascanai ra? Parata nëri bëcahuë. Jiscasquia —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Jatsi parata ja qui ja bëcaniquë. Jatsi, —¿Tsohuë bëmana jaya ni naa parata ra? ¿Tsohuë ni naa janë ibo? —i jato qui Jesu niquë. Jatsi, —Romanoba chama-chamaria bá-na —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jatsi, —Romanoba chama-chamaria quiha jahuë jahuë bo tëquë acana. Jasca, Dios qui jahuë jahuë yoi bo acahuë —nëa tsi jato qui Jesu nëcaniquë. Jatsi ja ratëcaniquë ja yoahaha ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jatsi Jesu jisi bocaniquë maxo huëtsa, naa saduceobo icanai cabo. “Yama tsi xo nohiria bësotëquëhaina” inish ca maxo tsi xo naa. Jesu ja nicacaniquë jato ri tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—“Baquë bo yama pi joni rësono tsi jahuë ahui bixëti xo jahuë noma. Bixo tsi jahuë rëquëmë bax xocobo ja saihuati xo” i Moisés yamabo ni quiha, Maestró. ");
INSERT INTO caoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jabi seis ca noma bo jayapaoni quiha joni. Jatsi ahui naa joní bini quiha. Jatsi xocobo yama tsi ja rësoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ja rësoquë tsi quiha jahuë xachacató jahuë ahui biniquë, ja bax xocobo saihuaxëna. Xocobo saihuahaxma tsi quiha ja rësoniquë jaa ri. Jaquirëquë jahuë nomá jahuë ahui biniquë. Xocobo saihuahaxma tsi quiha ja rësoniquë jaa ri. Toca tsi jahuë noma bo tëquëtá toa jasca ca yoxa bini quiha ahui iti. ");
INSERT INTO caoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Xocobo ja saihuapistia-yamariacani quiha. Jarohari tsi quiha rësoniquë yoxa ri. ");
INSERT INTO caoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jabi nohiria bo bësotëquëno tsi ¿tsohuë ahui ixëhi ni naa yoxa sa? Siete ca bënë ja jayani quiha bësoquí na —nëa tsi quiha Jesu qui ja nëcacaniquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jatsi Jesú jato quëbiniquë: —Janyama xo mato ra, Quënëhacanish cabo, Dios chama, tihi cabo ma cahëyamahai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jabi Diós nohiria bësotëquëmano tsi naipá ca ángel bo jascaria icaxëcani quiha ra. Ahui bo, bënë bo biyamacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Jabi, “Bësotëquëxëhi quiha nohiria” ¿ii ni mato sa? ¿Tonia Moisés yamabá quënëni ca ma jisyama-yamani, naa mëshohai ca pëtoro ó ca Dios chanini ca ja quënëni cató no? Toca tsi Moisés qui Diós yoani ca quënëhacani quiha. “Abraham, Isaac, Jacob, tihi cabá-na Dios ca ëa xo naa ra” i Moisés qui Dios ni quiha. Jabi “Abraham yamabo, Isaac yamabo, Jacob yamabo,” iyama ja ni quiha ra, bëso jaca nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bësoyama caba Dios ma xo Dios ra; jama, bësocanaibá-na nori. Japi janyama xo mato ra —nëa tsi Jesu nëcaniquë jato qui, naa “Bësotëquëyamaxëhi quiha nohiria” inish cabo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jabi toá tsi nii quiha maestro iniquë, naa jodioba yoba tiisimahai cato. Saduceobo ya Jesu chaninahai ca ja nicani quiha. Jasca, jia tsi quiha Jesú jato quëbini ca ja jisni quiha. Jisi tsi Jesu qui ja joniquë jaa ri nicaxëna. —¿Jëni ca yoba ni toa oquë-oquëria cato sa? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jatsi quiha Jesú quëbiniquë: —Oquëria ca yoba tsi xo naa, Israel cabá. Nicacahuë. Huësti roha tsi xo nohiria ba Ibo ra. Noba Ibo Dios qui no arahai ca tsi xo naa ra. ");
INSERT INTO caoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Jatsi mato joiti tëquëta, mato shina tëquëta, mato coshi tëquëta, tihi cabá tsi mato Ibo Dios yoi ma noiti xo iquia. ");
INSERT INTO caoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jaquirëquë tobi yoba huëtsa. Oquëria ca yoba tsi xo toa ri. Mabë xatë yoi bo ri ma noixëti xo, mamë ma noihai jascaria. Jabi yama tsi xo toa naa dos ca yoba bo oquë cato ra —nëa tsi Jesu nëcaniquë naa maestro qui. ");
INSERT INTO caoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jatsi jodioba yoba tiisimahai ca joní quëbiniquë: —Jia tsi xo toa mi yoahana, Maestró. Jabija tsi xo. Yama tsi xo Dios huëtsa. Ja huësti ca tsi xo Ibo Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Jabija ra. Jasca, noba joiti tëquëta, noba shina tëquëta, noba coshi tëquëta, tihi cabá tsi Dios no noixëti xo. Jasca, nobë xatë yoi bo no noixëti xo ra. Yama tsi xo toa dos ca yoba oquë cato ra. Dios qui altar ó ca yohina no mëshahaina, jahuëcara huëtsa Dios qui no acaina, tihi cabo no acai ca oquë-oquëria tsi xo toa dos ca yoba no nicahaina ra —nëa tsi quiha Jesu qui joni nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jabi jia tsi toa joní quëbini quiha. Nicahax, —Diós otohai ca qui basima xo mia ra —i ja qui Jesu niquë. Jaquirëquë nohiria bá Jesu nicacasyamani quiha ja qui raquëquí na. ");
INSERT INTO caoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Arati xobo-xoboria xo tsi tiisimapama tsi quiha Jesú nohiria bo nicaniquë: —“David yamaba chahitaxocobo ixëti xo Cristo, naa nohiria bo Xabahamati Ibo” ¿iyamayamacahi ni mato yoba tiisimacanaibo? ¿Jënihax tocacahi ni? ");
INSERT INTO caoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Espíritu Santo rëamëhax tsi ¿David yamabo nëcayamayamani? “‘Mia oquëhuanox pari tsi, jariapari mia pasomaha cabo bëboxëquia, jato mi yonano’ i noho Ibo qui Dios ni quiha” i David yamabo niquë pa. ");
INSERT INTO caoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Noho Ibo” ¿i David yamayamani, Cristo yoati tsi chanihi na? Jatsi, ¿jënahuahax jari jahuë chahitaxocobo ii ni ra? —nëa tsi Jesu nëcaniquë, jato nicahi na. Jabi tobi quiha huëstima ca nohiria mani iniquë. Ja rani-ranicaniquë jahuë chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jatsi jato tiisimatsi quiha Jesú huaniquë: —Yoba tiisimacanaibo qui quiniacaxëcahuë. Jato sahuëti tëtëcaria bá tsi bohocani quiha pë. Nohiria bá jato joihua-joihuahai ca ó pasocani quiha ra nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Jasca, nohiria bo oriquibëquinapino tsi oquë-oquëria ca tsahoti bicascani quiha pë. Jasca, catiti xobo qui jicoxo tsi oquë ca tsahoti bo ó quëëcani quiha tsahoti. ");
INSERT INTO caoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jabi naa joni bo tsi xo toa imanish ca yoxa ba jahuë bo yomacanaibo ra. Yomapama tsi quiha nohiria bo bësojó tsi bëhox-bëhoxcani quiha pa. Anomariaxëhi quiha Diós jato copixëhaina iquia —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Arati xobo tahë tsi tsahopama tsi quiha nohiria bá jato parata caja qui nanëhai ca Jesú tsaya-tsayaniquë. Bëcaniquë huëstima ca rico cabo jato parata axëna. Huëstima ca parata ja acani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jatsi, noitiria ca bënë imanish ca yoxa joniquë. Joxo tsi quiha dos ca parata roha ja nanëniquë. Copiriama ca parata quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Tsayaxo tsi quiha jahuë rabëti bo Jesú quënaniquë. —Anomaria tsi xo toa bënë imanish ca yoxá Dios qui acana ra. Jatiroha ca nohiria huëtsa bá aca ca oquë tsi xo toa ja acana iquia. ");
INSERT INTO caoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Jari huëstima ca parata jayacaxo tëxë bo ra. Narisyamacani quiha. Pistia roha tsi xo toa ja acanana ra. Jama xo naa yoxa iquia. Jatiroha ca ja aquë ra; naa jahuë oriquiti copiti parata quiha —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Arati xobo Jesú jisbayano tsi quiha ja qui chaniniquë jahuë rabëti huësti cato. —Tsayapa, Maestró. Anomaria tsi xo naa xobo ra. Tio bo ria ca jahuë maxax bo ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jatsi quiha Jesú quëbiniquë: —Jabija. Naa xobo tsayacahuë. Jaboqui nii xo. Jama, potas-hacaxëhi quiha naa arati xobo tëquë iquia. Matsami matsami niiyamaxëhi quiha huësti ca maxaxa ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jabi arati xobo bëbo, naa Maca Olivo Ya tsi tsaho quiha Jesu iniquë. Tsahojano tsi quiha Pedro, Jacobo, Juan, Andrés, tihi cabo ja qui bëcaniquë nicaxëna. Yama nohiria huëtsa jato bëta ini quiha. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Jënixo tsi ocapixëhi ni naa mi yoahana rë? ¿Jahuë jisti jisxëhi ni noa ra naa mi yoaha ca jatiyoxëquë no? —i Jesu qui jaca niquë. Jatsi Jesu nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—Quiniacaxëcahuë, ma parahacayamano. ");
INSERT INTO caoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jariapari tsi noho janë́ tsi bëcaxëcani quiha huëstima ca mahitsa ca joni bo. “Ea ti tsi xo nohiria bo Xabahamati Ibo-iboria” i nohiria bo qui xëhi quiha. Toca tsi huëstima ca nohiria bo paracaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","‘Jatsi país ca nianahaina, nohiria huëtsa iquinacatsai ca chani, tihi cabo nicaxëqui mato. Nicahi tsi raquëyamacana. Ocapixëhi quiha ra. Jama, jari tobi jahuë rëso. ");
INSERT INTO caoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jariapari huësti ca país pasomaha nianaxëhi quiha país huëtsa. Jasca, chama huëtsa pasomaha iquinaxëhi quiha chama huëtsa. Jasca, toatiyá tsi biniacaxëcani quiha huëstima ca nohiria. Jasca, huëstima ití tsi yajoriaxëhi quiha mai. Jariapari ca nohiria bá tënëhai ca chitahë roha tsi xo naa ra, naa yoxá jahuë baquë comahai ca pahë jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","‘Quiniacaxëcahuë. Mato qui tsamicaxëcani quiha. Tsamixo tsi policía bo qui mato bocaxëcani quiha quësoxëna. Jasca, catiti xobo xo tsi mato rashacaxëcani quiha. Jasca, chama bo, presidente bo, tihi cabo bësojó tsi niixëqui mato ëa iqui na. Jatsi jato qui Dios Chani ma yoaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Jasca, jatiroha ca nohiria qui yoahacaxëti xo Dios Chani. ");
INSERT INTO caoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jabi mato qui ja tsamipicano tsi policía bo qui mato ja bocano tsi jato qui ma chanixëti ca yoati shina-huëjënayamacana. Toa xaba tsëquëno tsi mato qui acacaxëhi quiha ma yoaxëti cato. Toatiyá tsi ma chanino tsi ma yoaxëti ca mato jismaxëhi quiha Espíritu Santo. Chaniyamayoixëqui mato, Espíritu Santo nori. ");
INSERT INTO caoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Toatiyá tsi jahuë xatë yoi mëaxëhi quiha huëtsa, namëhacati. Jasca, jahuë baquë pasomaha ixëhi quiha jahëpa ri. Jasca, jato nabo qui caxacaxëcani quiha xocobo ri. Caxaquí tsi chama bo qui jato nabo mëacaxëcani quiha namëhacati. ");
INSERT INTO caoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ea tahëhax tsi mato qui caxayocaxëcani quiha nohiria tëquëta. Jama, xabahamahacaxëhi quiha jahuë rëso qui tënëyocanaibo, naa bamayamacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","‘Toatiyá tsi “Quëyomisxëniria ca Yoixëni ca” jisxëqui mato ra. Raquëria ixëhi quiha. Jahuë iti ma tsi niixëhi quiha ra. Jabi naa quënëni ca tsayahai cató cahëno ra. Jatsi naa quëyomisxëniria ca yoixëni ca jisi tsi maca bo qui jabaxëti xo jodioba maí cabo. ");
INSERT INTO caoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Toatiyá tsi jato xobo qui jicoyamaxëti xo cacha ca nohiria, jato jahuë bo bixëna. Ja bamayamacano. ");
INSERT INTO caoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Jasca, jahuë sahuëti biti bacayamaxëti xo huaí ca yonocohai cato. Ja bamayamano. ");
INSERT INTO caoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Toatiyá tsi noitixëhi quiha tohoya ca yoxa bo, baquë pistia jaya cabo ri. ");
INSERT INTO caoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dios qui bëhoxcana, matsitiyá tsi ja ocapiyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Toatiyá tsi anomariaxëhi quiha nohiria bá tënëhaina. Mai nëhohuahacaquë rohari tsi nëca tsi tënëpistia-yamariani quiha nohiria bo ra. Toatiyá tsi oquë-oquëriaxëhi quiha naa nohiria bá tënë-tënëhaina. ");
INSERT INTO caoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jama, toa tënëti xaba Diós chitiayamarohapino tsi yama ca nohiria xabahamahacaquë aquë ra. Ja bini ca nohiria bo bax toa xaba chitiaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","‘Jatsi, “Nëá xo noqui Xabahamati Ibo; toá xo ra” i tsohuëcara pi no tsi jato chahahuayamacahuë. ");
INSERT INTO caoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Toatiyá tsi jisiquixëhi quiha mahitsa ca xabahamati ibo bo. Jasca, jisiquixëhi quiha naa mahitsa ca Dios Chani yoacanaibo ri. Jisiquixo tsi jisti bo acaxëcani quiha pë, Diós bini ca nohiria bo paraxëna tonia. ");
INSERT INTO caoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jatsi quiniacaxëcahuë. Mato yobapariquia ja tocapinox pari. ");
INSERT INTO caoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","‘Toatiyá tsi anomariaxëhi quiha toa tënëtiya ra. Jaquirëquë tsëmonaxëhi quiha bari. Jasca, huahuayamaxëhi quiha oxë. ");
INSERT INTO caoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nai ax paquëxëhi quiha naipá ca huishti bo. Yajohacaxëhi quiha mai. ");
INSERT INTO caoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Jatsi naipá tsi jisiquixëquia, naa Nohiria Baquë ë nori cato. Jatsi araxëhi quiha maí ca nohiria bo tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Jatsi jatiroha ca quinia, naa norte, sur, este, oeste, tihi cabo qui noho ángel bo raaxëquia. Toca tsi noho nohiria bo, naa ë bini cabo catiacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","‘Jabi higuera jihui jisti tsayano. Ja botoxno tsi basima xo oitiya; toa cahëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jascaria, ë yoaha ca jahuë bo ocapiti chitahëno tsi basima tsi xo toa ë johaina. Joti basima xo ëa. ");
INSERT INTO caoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mato parayamaquia. Jabi naatiyá ca bësocanaibo rësonox pari no tsi ocapixëhi quiha ë yoahana. ");
INSERT INTO caoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Huinocaxëhi quiha naipa, mai, tihi cabo; jama, huinoca-pistiayamariaxëhi quiha noho Chani ra. ");
INSERT INTO caoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","‘Jabi yama tsi xo toa ë joxëhai ca bari hora cahëhaina. Cahëyamahi quiha naipá ca ángel bo. Cahëyamaquia ëa ri, naa Dios Baquë ë nori cato. Toa bari cahëhi quiha Jahëpa Dios roha. ");
INSERT INTO caoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Jatsi quiniacaxëcahuë. Jaha bësocahuë, mato ibo johai ca bari ma cahëyamahai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Jabi joni jahuë xobo qui bacahai ca jascaria tsi xo toa ë joxëhaina. Canox pari tsi ¿jahuë xobo ó jahuë yonati bo bësomayamaxëhi ni ibo? Jato yonoco yoi jaya xo jahuë yonati bo tëquëta. Jasca, “Caiti ó bësohuë” i quiha jahuë caiti obëso ca qui. ");
INSERT INTO caoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jatsi jaha ma bësocano mato ri. Ibo johai ca hora cahëyamaqui mato ra. ¿Jënino cara ca tia? ¿Yata ma ni? ¿Baquichá ma ni? ¿Huëatisca ma ni? ¿Baquishmari ma ni? ");
INSERT INTO caoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mëri joquí tsi ma oxahai ca ja jisyamano ra. ");
INSERT INTO caoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ja tsi xo toa jaha bësocahuë. Bacaxëquia ra. “Jaha bësocahuë” iquia jatiroha cabo qui —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jabi tsëquëpaimaria tsi quiha jodioba pascua fiesta iniquë. Dos ca bari roha quiha. Toatiyá tsi levadura yama ca mapari ja pi-pipaocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jasca, toatiyá tsi jodioba chama bo, naa arati ibo bo, yoba tiisimacanaibo, tihi cabo Jesu qui tsamicasniquë. Tsamicasquí tsi quinia mërahi quiha ja icaniquë Jesu ati. —Fiesta no tsi achanoma quiha. Caxanaxëhi quiha yacatá ca nohiria rë —i quiha jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jabi yaca Betaniá tsi quiha Jesu iniquë, naa bonohuaxëni ca Simón xobó no. Oriquijano tsi quiha ja qui yoxa joniquë. Alabastro icanai ca botella ja jayani quiha. Copixëniria ca perojome rëamë ca botella quiha. Joxo tsi quiha ja tërëjëhaniquë. Tërëjëhaxo tsi quiha Jesu mapo qui ja japaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jatsi caxanatsi toá ca nohiria huësti huësti ca niquë tsayahax na. —Jishopë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Iniarohapixo tsi huëstima ca parata, naa huësti ca año sueldo no jayaquë aquë rë. Toa parata noitiria cabo qui ati no iquë aquë rë —i jaca niquë. Jatsi yoxa ja raahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jatsi, —Iquë. Iquë. ¿Jëniriaxo tsi raahacanai? Jiaria tsi xo toa ë bax ja acana ra. ");
INSERT INTO caoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Mato bëtarohaxëhi quiha noitiria cabo. Xaba huëstima ca jayaxo mato jato mëbiti. Jama, ëa ti tsi xo toa mato bëta naamayamahai cato. ");
INSERT INTO caoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ati mëtsa iqui ca naa yoxá aquë ra. Jiaria quiha. Noho mapo qui perojome ja japaquë ra, maihuahacati noho yora shomahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mato parayamaquia. Ja aca ca nicacaxëcani quiha maí ca nohiria bo tëquëta, naa Dios Chani yoahacahai cato xo na. Jatsi naa yoxa shinaxëhi quiha nohiria bo, nicaxo na —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jatsi arati iboba chama bo qui Judas Iscariote, naa Jesu rabëti bo ó ca huësti ca caniquë jato qui mëacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jahuë chani nicahax ranitsi quiha jodioba chama bo ni quiha. Jatsi, —Jesu quëshpi tsi parata mi qui axëqui noa —i jaca niquë ja qui. Japi jato qui Jesu mëati xaba jia ca mëratsi quiha Judás huaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Jabi pascua fiesta chitahë ca barí tsi quiha oveja bo tëpas-hacani quiha nohiria ba jocha quëshpi na. Jatsi, —¿Jahuënia tsi caxëhi ni noa sa, mi bax pascua oriquiti shomahuaxëna piti? —i quiha Jesu qui jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jatsi jahuë rabëti bo dos ca ja raaniquë. Raahax, —Yaca qui bocata. Toá xo joni, naa chomó ca jënë bëhai cato. Toa xo tsi bëchaxëqui mato. Toa joni banahuacana. ");
INSERT INTO caoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Banahuahax jahuënia cara ca qui ja jicohai ca xobo ibo qui chanicana. “Noqui raaquë Maestro ra, naa shomahuahaca ca naquëtë jisti. ¿Jahuënia tsi pascua oriquiti pixëhi ni?” i ja qui cana. ");
INSERT INTO caoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jatsi pistiama ca naquëtë mato jismaxëhi quiha xobo ibo, naa mesa, tsahoti bo, tihi cabo jaya cato. Toa xo tsi pascua oriquiti shomahuacana no bax na —i quiha jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jatsi quiha dos ca rabëti bo bocaniquë yaca qui. Ocapiriajani quiha Jesú yoani jascaria. Xobo qui cahëxo tsi quiha oriquiti ja shomahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jatsi quiha yata, bari caquë tsi quiha xobo qui Jesu cahëniquë jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Jatsi ja oriquicano tsi quiha Jesu chaniniquë: —Mato parayamaquia ra. Jodioba chama bo qui ëa mëaxëhi quiha mato ó ca huësti cato rë, naa ë bëta oriquihai cato —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jatsi quiha ja cohuënacaniquë: —¿Tsohuë cara ni toa sa? Ea ma xo toa ra —i jaca niquë huësti huësti. ");
INSERT INTO caoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jatsi quiha Jesú quëbiniquë: —E bëtaxo tsi pitëxti ca jahuë mapari nacomabëquihai ca tsi xo toa ëa mëaxëhai cato rë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Rësoxëquia Quënëhacanish cabá yoani jascaria, naa Nohiria Baquë ë nori cato. Jama, noiti-noitixëhi quiha toa jodioba chama bo qui ëa mëahai ca joni ra. Ja coyamarohapino tsi shoma ja iquë aquë rë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jatsi oriquipama tsi quiha mapari Jesú biniquë. Bixo tsi quiha “Gracias” i Dios qui ja niquë ja quëshpi na. Bëquëx-xo tsi quiha jato qui mapari ja aniquë piti. Jatsi, —Bicahuë. Picahuë. Noho yora tsi xo naa —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jatsi quiha copá ca jënë ja biniquë. Bichi tsi “Gracias” i ja niquë. Jatsi jënë jato qui ja aniquë. Ja ayocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jatsi shiati acax Jesu nëcaniquë: —Noho jimi tsi xo naa. Dios xabahamati quinia jisti quiha. Huëstima cabo bax japahacaxëhi quiha, jocha masati. ");
INSERT INTO caoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mato parayamaquia. Naa uva bimi jënë mato bëta xo atëquëpistiayamariaxëquia nëa mai xo na, Diós yonahai cato xo tsi ë atëquëxëquë rohari mana xo na, quinia paxá no —i quiha jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Jatsi quiha ja quëquëcaniquë. Quëquëhax jisbaya tsi Maca Olivo Ya qui ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jatsi quiha jato qui Jesu chaniniquë: —Naa baquichá tsi ë quima casoxëqui mato rë, “Oveja obëso ca tëpasmaxëquia. Pacanamahacaxëhi quiha jahuë oveja” i Quënëhacanish cabo ó tsi Dios ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Jama, bësotëquëhax mato bëbo Galilea qui caxëquia —i quiha jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jatsi Pedró quëbiniquë: —Mi qui tëxë bo casomitsa. Jama, mi quima casopistiayamariahai ca ëa xo naa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jatsi Pedro qui Jesu chaniniquë: —Mia parayamaquia. Naa baquichá tsi patiari bënë quëonox pari no tsi tres tsi “Jesu cahëyamaquia” ixëqui mia rë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jatsi quiha Pedro yosananiquë: —Mi bëta rësorohapihi tsi mi quima casopistiayamariaxëquia ra —i Pedro niquë. Jatsi toca tsi chaniniquë Jesu rabëti bo tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jatsi Getsemaní icanai ca qui Jesu caniquë jahuë rabëti bo ya. Cahax, —Nëá tsahocana. Bëhoxpariquia ra —i quiha jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Jatsi Pedro, Jacobo, Juan, tihi cabo ja boniquë ja bëtati. Jatsi Jesu cohuënaniquë. Raquëtsijani quiha. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—Cohuëria ca ëa xo naa ra. Rësoti basima xo ëa rë. E bëta bësocana ra —i quiha jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jatsi ori pistia cahax Jesu mëniniquë. Mënihax bëhoxtsijaniquë. Jatsi jahëpa ja nica-nicaniquë tënëtiya ja nacomahacayamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Ea shinahuë, noho jahëpa-jahëpariá. Mi qui jia pi no tsi naa johai ca tënëtiya mëbihuë ra, ë tënëyamano. Jama, jaha ë quëëhai ca mi ayamano; jama, mi shina roha mi ano ra —i quiha Jesu niquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Bëhohax tsi quiha jahuë rabëti bo qui ja bacaniquë. Bacaxo tsi ja oxacanai ca ja jisniquë. —¿Huësti ca hora roha ë bëta bësoti mëtsa ma ni mato rë? ");
INSERT INTO caoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Bësocana. Bëhoxcana, jochati ma tanamahacayamano ra. Jabija, mato shina tsi xo toa bëhoxcatsaina; jama, mato yora tsi xo chamayama rë —i quiha Pedro qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jatsi Jesu catëquëniquë bëhox-xëna. Jasca ca ja bëhoxtëquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Bëhoxhax ja bacatëquëniquë. Oxahi ja icani ca ja jisniquë. Coshiria ini quiha jato bëro. Bërabiquí tsi quëbiti ja cahëyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tres tsi quiha toca tsi Jesu bacani quiha. Jarohari tsi, —¿Jari oxacanai? ¿Jari joi-joicanai? Iquë ra. Tsëquëquë hora ra. Jochahuaxëni cabo qui mëahacapaimaria xo ëa, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Joicana. ¿Canomani? Tsayacapa. Nëbi johi quiha ëa mëacatsai ca joni rë —i quiha Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jabi jari ja chanino tsi quiha Judas jotapiniquë rë, naa doce ó ca huësti cato. Ja bëta bëcaniquë nohiria misco. Saipi bo, jihui bo, tihi cabo ja jayacani quiha. Jabi arati ibo bo, nohiria yosibo, tihi cabo ini quiha toa jato raati ibo bo ra. Jabi ja raahacacani quiha Jesu qui tsamiti. ");
INSERT INTO caoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Jatsi quiha nohiria misco qui jisti Judás aniquë: —Ma bicatsai ca joni tatsoxëquia ra. Toa joni qui tsamicaxëcahuë. Bicahuë. Jia tsi jaha bësocahuë —i jato qui Judas ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Jatsi jato iti qui cahëhax Jesu qui Judas catapiniquë. Cahax, —“Maestró” i Jesu qui ja niquë joihuahi na. Joihuaxo tsi quiha Jesu ja tatsoniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jatsi Jesu qui joni bo tsaminiquë. Tsamixo tsi quiha achajahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jatsi quiha Jesu tapaí ca nii cató jahuë saipi tsëcaniquë. Tsëcaxo tsi quiha arati ibo-iboria yonati ja paxtianiquë, Jesu paxamacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jatsi quiha jato qui Jesu chaniniquë: —¿Saipi bo, tëpasti jihui bo, tihi cabo jaya ni mato pa? ¿Yomaxëni ca bichii jascaria ëa bichi bëcanai pa? ");
INSERT INTO caoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Jatiroha ca bari mato bëta ë i-ipaoyamëquë ra arati xobó no. Toa xo tsi ë tiisimano tsi ¿jënihax tsi ë qui ma tsamiyamayamëta sa? Jama, jatihuahacaxëti xo Quënëhacanish cabo ra —nëa tsi quiha jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jatsi jahuë rabëti bo jabayoniquë raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Jama, huësti ca shinapayó Jesu banahuaniquë. Sabana rabanaca ja ini quiha. Jatsi toa joni qui soldado bo tsamicasniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ja tsamicaquë tsi quiha toa joni paxaniquë. Jahuë sabana niabëria tsi ja jabaniquë ra. Tsoboco ja ini quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesu qui tsamixo tsi quiha jato arati ibo ba chama-chamaria qui Jesu ja bocaniquë. Toá tsi quiha mani iniquë jodioba yoba cahëxëni cabo. ");
INSERT INTO caoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jabi basi quiha Pedró banahuaniquë. Banahuahax chama xobo huënë qui ja jiconiquë. Jicohax tsi quiha toá ca jaha bësohai ca soldado bo ya ja tsahoniquë, chihí tsi yohohi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jatsi quiha arati ibo bo, nohiria yosibo, tihi cabá Jesu namëcasniquë pë. Ja tsi xo toa ja pasomaha ca joi ja mëracaniquë. Yama a ra. ");
INSERT INTO caoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jama, tobi huëstima ca quiahuacanaibo iniquë, ja qui quësocatsi na. Jamëri jamëri ini quiha ja quiacanaina. Jaharisi iyamani quiha ja quësocanaina ra. ");
INSERT INTO caoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jarohapa tsi quiha dos ca joni niiniquë, mahitsa ja qui quësoxëna. Quiaxëni ca joni bo ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—“Dios arati xobo potasti mëtsa xo ëa ra” i ja ni quiha. Jatsi, “Jaquirëquë tres barí tsi naa xobo nimatëquëxëquia” i ja ni quiha pë —i yosibo qui toa joni bo niquë, Jesu qui quësohi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Jama, jamëri jamëri naa dos ca joni bo quësohai iniquë ra. Jaharisi ma quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jatsi quiha jato arati ibo ba chama-chamaria joiniquë naxërëquë no. Niixo tsi quiha Jesu ja nicaniquë: —¿Jënihai naa jahuë bo yoati na? Mia pasomaha chanicani quiha ra. ¿Jato quëbicasyamahai? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pasi quiha Jesu iniquë. Ja quëbiyamaniquë. Jatsi quiha arati ibo ba chama-chamaria nicatëquëniquë: —¿Dios Baquë, naa johai ca Xabahamati Ibo ni mia ra? —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jatsi, —Jaahuë. Ja tsi xo ëa ra —i Jesu niquë—. Jasca, chamaxëni ca Dios mënëcayá ca Nohiria Baquë tsaho ca jisxëqui mia ra. Naipá ca tsëmo bá tsi ja joxëhai ca jisxëqui mia ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jatsi arati ibo ba chamá jahuë sahuëti jaraxaniquë caxaquí na. Jatsi, —¿Jëniriaxo tsi ja qui quësocanaibo huëtsa bo no nicacasna? ");
INSERT INTO caoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Dios ja ocahuaha ca ma nicaquë ra. ¿Jabija ma ni? —i jato qui ja niquë. Jatsi Jesu qui ja quësocaniquë, “Ja nati xo” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jatsi quiha Jesu bëmana qui coshotsijacaniquë. Jatsi ja bëmapacaniquë raití no. Bëmapaxo tsi ja bëtoxacaniquë. Tocahi tsi, —¿Tsohuë mia aca? —i ja qui jaca niquë pë. Jatsi toá ca soldado bá sëtianiquë jato ri, bixo na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Xobo huënënë́ tsi Pedro niino tsi arati ibo chama yonati jiconiquë. Xotaco ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Jicoxo tsi quiha toá ca chihi tapaí ca Pedro yohohai ca ja jisniquë. Bëis-hax tsi quiha, —Naa Nazarét ca Jesu ya mi iquë mia ri —i Pedro qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Jatsi, —Jesu cahëyamahai ca ëa xo naa ra. E joma toa mi yoahana ra —i Pedro niquë quiahi na. ");
INSERT INTO caoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Quiahax tsi quiha Pedro huajaniquë caiti qui. Jatsi quiha xotacó Pedro tsayatëquëniquë, cacha ja niiquë no. Tsayahax, —Jesu rabëti tsi xo toa ra —i ja niquë toá ca mani cabo qui. ");
INSERT INTO caoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Jatsi, —Jahuë rabëti ma xo ëa ra —i Pedro tëquëniquë. Jaquirëquë, —Jabija. Jahuë rabëti xo mia. Galileá ca joni xo mia ra. Jamëri tsi xo mi joi, mi chanihaina ra —i Pedro qui toá ca manicanaibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jatsi ocahuatsi Pedró huaniquë rë. —Jabija ca pi ë chaniyamarohano tsi Diós ëa copino ra. Parayamahai ca ëa xo naa. ¿Tsohuë cara ni naa Jesu imahaina ra? Toa joni cahëyamaquia —nëa tsi Pedro nëcaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tocajaquë tsi quiha ja qui Jesú yoaha ca ja shinaniquë, naa “Dos tsi patiari quëonox pari no tsi tres tsi ‘Jesu cahëyamaquia’ ixëqui mia” i ja qui Jesu nina. Shinahax aratsijaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Huëatiscano tsi quiha arati ibo ba chama bo, nohiria yosibo, tihi cabo chaninaniquë Jesu namëti yoati na. Jesu ja namëcasni quiha pë. Jatsi quiha Jesu ja nëxacaniquë. Nëxaxo tsi quiha Pilato qui ja mëpijahuacaniquë. Mëpixo tsi quiha ja qui ja mëacaniquë namëhacati. ");
INSERT INTO caoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jatsi, —¿Jodioba rey, naa chama-chamaria ni mia ra? —i quiha ja qui Pilato niquë nicahi na. Jatsi quiha, —Jaahuë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jabi anomaria ini quiha toa ja qui arati ibo ba chama bo quësohaina ra. Mahitsa quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Jatsi quiha Pilató nicatëquëniquë. —¿Tsayahai? Huëstima tsi xo toa mi qui ja quësocanaina rë. ¿Jato quëbiyamahai pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Quëbicasyamaniquë Jesu ra. Jatsi quiha Pilato ratëniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Jabi jatiroha ca jodioba fiesta no tsi quiha huësti ca presó ca joni Pilató paquëmapaoni quiha nohiria bo qui. Jahuë jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Toatiyá tsi cárcel xara gobierno pasomaha ca joni ini quiha, naa Barrabás icanai cato. Iquinaquí tsi nohiria naa joní ani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Jatsi quiha nohiria bëcaniquë Pilato nicaxëna, huësti ca ja paquëmano iquish na, naa ja a-apaoni jascaria. ");
INSERT INTO caoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jatsi quiha, —¿Mato jodioba rey paquëmaxëhi ni ëa ra? —i quiha jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jabi Jesu qui yosaria arati ibo bo iqui ca Pilató cahëniquë. Ja iqui tsi ja qui Jesu mëahacani quiha acacati. ");
INSERT INTO caoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jato qui yoi ini quiha toa Jesu ja paquëmacatsaina. Jatsi quiha arati ibo bá nohiria bo raji-rajimaniquë, Barrabás Pilató paquëmano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jatsi quiha Pilató nicatëquëniquë: —¿Jënahuaxëhi ni ëa ra Jesu qui, naa jodioba chama-chamaria ma quënahana? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jatsi quiha nohiria bá quënarianiquë: —Cruzó tsi tooxahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—¿Jëni ni ra? ¿Jahuë yoi ca ja aca? —i quiha jato qui Pilato niquë. Jama, jato joi ja choshacaniquë quëbihi na: —Cruzó tsi ja tooxahacati xo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Jatsi quiha Pilató Barrabás paquëmaniquë nohiria bo ranihuacatsi na. Paquëmanox pari tsi quiha soldado bo qui pari Jesu ja mëaniquë rispichí tsi rashahacati. Jaquirëquë jodioba chama bo qui Jesu ja mëaniquë cruzó tsi tooxahacati. ");
INSERT INTO caoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jatsi quiha palació ca huënë qui soldado bá Jesu boniquë. Boxo tsi quiha soldado bo tëquë ja quënacaniquë catiti. ");
INSERT INTO caoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jatsi quiha sahuëti shini, naa chama-chamaria sahuëti ja sahuëmacaniquë. Jasca, nishi moxá tsi quiha chaha ja quëcocaniquë ja bax na. Quëcoxo tsi quiha ja mahuajahuacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jaquirëquë joihuatsijahuacaniquë: —¡Viva, viva, jodioba chama-chamariá! —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Jatsi quiha ja bësojó tsi ja mënicaniquë ja qui araxëna. Mahitsa quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mahuaxo tsi quiha sahuëti shini ja tsobocaniquë. Jatsi jahuë sahuëti yoi sahuëmaxo tsi quiha Jesu ja bocaniquë tori, cruzó tsi tooxaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Riquipama tsi quiha tarabihai ca joni, naa Cirene mai ax jonish ca ja bicaniquë Jesu cruz papiti. Simón jahuë janë ini quiha, naa Alejandro, Rufo, tihi caba jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jatsi quiha Gólgota, naa Mapo Xao Ya icanai ca qui Jesu ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Toa xo tsi vino, naa tiahui ya roihacanish ca jënë Jesu qui ja amacaniquë ati. Ayamajahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jaquirëquë quiha cruzó tsi Jesu ja tooxacaniquë. Tooxaxo tsi quiha jahuë sahuëti bo ja oquëxnacaniquë i-ihaicató no. Toca tsi jahuë jahuëcara ca biti ja cahëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Baquishmari mënata barí tsi quiha Jesu tooxahacaniquë cruzó no. ");
INSERT INTO caoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Jasca, papi ó tsi ja qui ja quësocani ca quënëhacaniquë; naa “Jodioba chama-chamaria” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jasca, ja bëta dos ca yomaxëni ca joni bo tooxahacaniquë jato ri; naa huësti ca jahuë mënëcayá no, huëtsa ja mëxojó no. ");
INSERT INTO caoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nëca tsi quiha Quënëhacanish cabo jatihuahacani quiha, naa “Yoixëni cabo ya ja tocahacanina” ini cato. ");
INSERT INTO caoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Jatsi Jesu mahuatsi quiha tarabinish cabá huaniquë. Bëquë-bëquëhi tsi quiha ja nëcacaniquë. —Jë, jë. Mimë xabahamahuë arati xobo potascatsai cató. ¿Tres barí tsi toa xobo nimati mëtsa ni mia pa? Cruz ax botëhuë iqui noa —nëa tsi ja nëcacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jascaria tsi quiha arati ibo ba chama bo, yoba tiisimacanaibo, tihi cabá Jesu mahuaniquë jato ri: —Huëtsa bo ja xabahamaquë; jama, jamë xabahamati mëtsama xo ra. ");
INSERT INTO caoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¿Noba Israél ca rey, naa noba chama-chamaria ni naa joni pa? Jaboqui cruz ax ja botëno ra. Jatsi chahahuaxëqui noa ra noqui ri —i quiha jaca niquë jato ri chaninahi na. Jasca, toá ca ja bëta tooxahacanish cabá Jesu ocahuaniquë jato ri. Anoma jato chani ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Matoroco barí tsi quiha tsëmonaniquë toa mai. Naama ini quiha ja tsëmonina. Tres hora bo quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Jarohapa tsi a las tres quiha joi pistiamá tsi Jesú quënaniquë: —Eloi, Eloi, ¿lama sabactani?, naa “¿Jënixo tsi ëa mi jisbëriaha rë, noho Diós, noho Diós?” —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Toca tsi ja quënaquë tsi quiha, —Elías, naa Dios Chani yoanish ca quënahi quiha tonia —i jaca niquë toá ca niicanaibo. ");
INSERT INTO caoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jatsi quiha huësti ca joni jabaniquë jahuë chani nicahax na, tatë bixëna. Bixo tsi quiha vinagre, naa jënë nopi ca qui ja moosaniquë. Moosaxo tsi rëbiquirihaxo tsi Jesu ja amaniquë. Amapama tsi, —No manaparino ra. No tsayano. Elías jomitsa botëmaxëna —i quiha ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jatsi quiha Jesú quënatëquëniquë. Quënahax ja naniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ja naquë tsi quiha arati xobó ca rotamë ca quëbëti raiti jaxcahacaniquë. Mana ax napata quiri ja jaxcahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jasca, Jesu bësojó ca nii ca soldado ratëniquë ja nahai ca jisi na. Ratëhax, —Jabija xo ra. Dios Baquë yoi naa joni iquë rë —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Jasca, basima xo tsi Jesu nahai ca yoxa bá tsayaniquë. Toá tsi quiha mani iniquë María Magdalena; Jacobo, José, tihi caba jahëhua María; Salomé. ");
INSERT INTO caoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jabi naa yoxa bá Jesu banahuapaoni quiha mëbicasquí na, naa Galilea maí tsi ja iniquë no. Jasca, toá tsi quiha mani iniquë yoxa huëtsa bo ri, naa Jerusalén qui ja bëta bëcanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Capaima quiha bari iniquë. Chitahë-paimaria ini quiha jato joiti bari. ");
INSERT INTO caoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ja tsi xo toa mëri tsi José, naa Arimateá ca racanish ca Pilato qui caniquë Jesu yora baaxëna, maihuacatsi na. Cahi tsi ja raquëniquë. Jabi jodiobá chama shinajiaxëni ca naa joni ini quiha. Jasca, Diós nohiria bo otoxëhai ca ó pasohai ca ja ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jatsi quiha jahuë yora José baaquë tsi quiha Pilato ratëniquë ja rësoha quëscahua-yamahi na. Jatsi capitán quiha ja quënaniquë. —¿Japa Jesu; ja rësoha? —i quiha ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ja rësoha ca nicaxo tsi quiha José qui jahuë yora ja mëaniquë maihuahacati. ");
INSERT INTO caoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Jatsi quiha sabana jiaxëni ca José copiniquë. Jahuë yora botëmaxo tsi quiha ja yaboniquë sabana paxá no. Yaboxo tsi quiha maiquini ó tsi jahuë yora ja jananiquë. Huëyohaca ca quini paxa ca quiha. Janaxo tsi quiha maxax chahitaxëni caiti qui ja taraniquë japaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jabi ja bëta iniquë María Magdalena, José jahëhua María, tihi cabo. Tihi cabá Jesu maihuahaca ca iti jisni quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jodioba bari huinocaquë tsi quiha María Magdalena, Jacobo jahëhua María, Salomé, tihi cabá perojome copiniquë, Jesu yora chëxaxëna. ");
INSERT INTO caoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Copihax tsi quiha domingo baquishmarí tsi quiha Jesu mai jisi ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Capama tsi, —Jishopë. ¿Tsohuë ni toa no bax caití ca maxax bahama tarahaina rë? —i jaca niquë chaninahi na. Pistiama ca maxax ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Jama, taisquí tsi nii ca maxax ja jiscaniquë ra. Bahama ja tarahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jatsi quiha maiquini qui ja jicocaniquë. Jicoxo tsi quiha jato mënëcayá ca joni shinapayo ja jiscaniquë. Sahuëti joxo sahuë tsaho ja ini quiha. Jatsi, ja raquëcaniquë tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jatsi quiha yoxa bo qui ángel chaniniquë. —Raquëyamacana. Jesu, naa tooxahacahitahax ca ma mërahai cahëquia. Yama xo ra. Ja bësotëquëquë ra, ja yoani jascaria. Nëri bëcahuë. Ja janahacahitaha ca ma tsayaparino. ");
INSERT INTO caoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jatsi bocahuë. Pedro, jahuë rabëti bo, tihi cabo yoata. “Mato bëbo Galilea qui cahi quiha. Toa xo tsi Jesu jisxëqui mato, mato ja yoani jascaria” icana jato qui —nëa tsi quiha yoxa bo qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jatsi jisbaya tsi quiha ja jabariacaniquë raquëhi na. Ja mëmë-mëmëcanacaniquë. Raquëhi tsi huëtsa bo qui ja chaniyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Semana jariapari ca barí tsi quiha Jesu bësotëquëniquë. Bësotëquëhax tsi María Magdalena, naa siete ca yoshi jayapaonish ca qui ja jisiquiniquë. Jahá ca yoshi bo ja niani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Jatsi quiha María jisbayaniquë Jesu rabëti bo yoaxëna. Arahi jahuë rabëti bo ini quiha, cohuëhi na. ");
INSERT INTO caoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ja yoaha ca nicaxo tsi ja chahahuayamacaniquë pë. Jatsi, —Bëso xo Jesu ra. Jisquë ëa ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jaquirëquë quiha jamëri ca quiniá tsi dos ca xabachá ca cocohai ca joni bo qui Jesu jisiquiniquë. Jato xobo qui cahi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jato xobo qui cahëxo tsi quiha Jesu ja jiscana ca ja yoacaniquë huëtsa bo qui. Jama, ja yoacana ca ja chahahuayamacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jarohari tsi quiha jahuë rabëti yoi bo oriquino tsi jato qui Jesu jisiquiniquë. Jisiquixo tsi quiha jato ja raahaniquë. Quëstoria ca chahahuatimaxëni ja icani quiha. Jabi bëso Jesu iqui ca jisnish cabo ja chahahuayamacani quiha pë jato chani nicaxo na. ");
INSERT INTO caoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Jatsi quiha, —Jatiroha ca mai qui bocana, jatiroha ca nohiria qui chani jia ca yoati —i jato qui ja niquë—. ");
INSERT INTO caoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Xabahamahacaxëti xo tsohuëcara ca ë qui chitimihai ca ashimahacahax cato. Jama, quësohacaxëti xo tsohuëcara ca ë qui chitimiyamahai cato ra. ");
INSERT INTO caoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Jasca, jisti bo ati mëtsaxëhi quiha ë qui chitimicanaibo. Jariapari tsi yoshi bo natsëcacaxëcani quiha noho janë́ no. Jatsi joi jamëri bo chanicaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Jasca, jato mëquënë́ tsi quiha rono bo topiti mëtsacaxëcani quiha. Jasca, veneno pi ahi tsi rësoyamacaxëcani quiha. Jasca, iquicanaibo jënimahuacaxëcani quiha jato ó tsi mëquë ja janacanai cató no. Tihi ca ati mëtsaxëhi quiha ë qui chitimicanaibo ra —nëa tsi quiha jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jaquirëquë jahuë rabëti bo qui chanixo tsi quiha nai qui Jesu tërohacaniquë. Jatsi quiha jahuë iti Jesú bini quiha Dios mënëcayá no. ");
INSERT INTO caoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jatsi quiha jahuë rabëti bá jisbayaniquë, jatiroha cato xo tsi Dios Chani jia ca yoaxëna. Jato bëta xo tsi Ibo Dios yonocobëquini quiha. Dios Chani ja yoacaquë tsi quiha anomaria ca jisti bo acacaniquë. Toca tsi jahuë Chani Diós oquëhuani quiha ra.");
INSERT INTO caoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Jabi Jesú ani ca jahuë bo yoati tsi huëstima cabá quënëniquë. Noqui xërëquë xo tsi ja ani ca ja quënëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jesu rabëti bo, toatiyá jisnish cabo, tihi cabá yoani ca ja quënëcaniquë no tsayano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jabi ja quënëcani ca tëquë ë tsayarianiquë ëa ri ra. Tsayariaxo tsi jaboqui jatiroha ca rëquë rohari ca jahuë bo yoati tsi quënëbonacasquia ëa ri, Teofiló. ");
INSERT INTO caoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nëca tsi Jesu yoati mi bax quënëcasquia, jabija ca tëquë mi cahëno, mi parahacayamano iquish na. Jia tsi mia ja tiisimacani ca jahuë bo mi cahëyoino ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Jabi jodioba mai xo tsi chama Herodés yonano tsi quiha tobi arati ibo iniquë, naa Zacarías icanai cato. Abías icanai ca maxo ya tsi quiha ja yonoconiquë arati xobó no. Jabi Elisabet jahuë ahuini janë ini quiha. Jasca, arati ibo bo jahuë ahuini jimi bo ini quiha jato ri. Arati ibo ba chahitaxocobo ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Jabi Zacarías, Elisabet, tihi cabá Dios noirianiquë. Quësotimaxëni ca shinajiaxëni ca ja icani quiha. Jasca, Dios yoba bo tëquë ja nicacani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Jasca, baquë yama ja icaniquë rë, tohoyatimaxëni Elisabet ini quëshpi na. Jasca, sirixëni ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Huësti barí tsi quiha jahuë maxo ya Zacarías iniquë arati xobó no. Arati iboba yonoco aqui ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Toatiyá tsi ja raahacaniquë iboba iti qui jicoti, altar xo tsi incienso mëshati. ");
INSERT INTO caoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Jabi incienso mëshajahuano tsi quiha nohiria bo bëhoxhi iniquë cacha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jatsi Zacarías qui ángel jisiquiniquë, naa Ibo quima jonish cato. Incienso ya ca altar mënëcayá nii ángel ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jatsi ángel jisi tsi Zacariás shina-risiquiniquë. Raquëria ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jatsi, —Raquëyamana, Zacariás —i ja qui ángel niquë—. Nicahacaquë mi bëhoxhaina ra. Mi bax baquë comaxëhi quiha mi ahui Elisabet ra. Juan ja janëhacaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ja iqui tsi raniriaxëqui mato ra. Jasca, ranixëhi quiha huëstima cabo, ja coquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jasca, Dios bësojó tsi oquë ca joni ixëhi quiha mi baquë. Vino, jënë shapo, tihi cabo ja ayamano. Espíritu Santo rëamëxëhi quiha ja coquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Huëstima ca Israél ca nohiria jato Ibo Dios qui jahari bëxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jasca, Ibo bëbo caxëhi quiha mi baquë, nohiria shomahuahi na. Elías yamaba jabi, jahuë chama, tihi cabo jayaxëhi quiha ja caquë no. Jatsi jahëpa bo, jahëhua bo, jato xocobo, tihi cabo noinamaxëhi quiha. Jasca, nicamisxëni cabo Dios qui bacamaxëhi quiha, mëstëxëni ca jahuë bo jato shinamaxëna. Toca tsi nohiria bo shomahuaxëhi quiha, Ibo johai ca quëshpi na —nëa tsi quiha ángel nëcaniquë Zacarías qui. ");
INSERT INTO caoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jatsi, —¿Jëniria pi raca ja na? Joni sirixëni xo ëa ra. Sirixëni xo noho ahui ri —i ángel qui Zacarías niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jatsi angél quëbiniquë: —Gabriel xo ëa ra. Dios tapaí nii ca ëa xo naa. E raahacaquë mi qui chaniti, chani jia ca mi qui bëti. ");
INSERT INTO caoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Jatihuahacaxëhi quiha ë yoahana ra. Noho chani mi chahahuayamaha iqui tsi jaro, chaniti mëtsama ixëqui mia ra, mi baquë coquë rohari —nëa tsi ja qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jabi Zacarías ó pasohi nohiria bo iniquë tsëquëti. Yama a. Yopahi tsi, —¿Jëniriahax bamahi ni sa? —itsi jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Jatsi Zacarías tsëquëniquë. Tsëquëhax tsi quiha nohiria bo qui chaniti mëtsama ja iniquë. Jaro quiha. Jatsi ja tënamëha nori nohiria bá cahëniquë. Japi Zacariás jato qui bëëbëëniquë, chaniti mëtsama ja iqui ca jismaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Jaquirëquë arati xobó tsi ja yonocohai ca xaba jatiquë tsi quiha jahuë xobo qui Zacarías caniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jaquirëquë jahuë ahui Elisabet tohoyaniquë. Jatsi cinco oxë no tsi xobó tsi ja chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","—Nëca tsi ëa Diós shomahuaquë ra. Jaboqui pi nohiria yahi tsi bërabiyamaxëquia, baquë ë jayaxëhai quëshpi na —i Elisabet niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Oxë huëtsa huinocaquë tsi quiha Diós jahuë ángel Gabriel raaniquë Nazaret icanai ca yaca qui. Jabi Galilea maí tsi naa yaca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jabi Gabriel raahacani quiha María icanai ca yoxajahi qui Dios Chani bëti. Jari bënë yama María ini quiha. Jasca, jahuë bënë ti ca José ini quiha, naa David yamaba chahitaxocobo huësti ca iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Xobo qui jicohax tsi quiha, —Shoma xo mia ra; yoxa bo huëtsa oquë quiha. Mi bëta xo Ibo ra —i María qui Gabriel niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Angel chani nicahax shinati pi Mariá cahëyamaniquë. —¿Jënihi ni sa? —i ja niquë jahuë shinaná no. ");
INSERT INTO caoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jatsi, —Raquëyamatsihuë, Mariá —i ángel niquë—. Diós mia shomahuaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Tohoyaxëqui mia. Baquë comaxëqui mia ra. Comaxo tsi Jesu mi janëno. ");
INSERT INTO caoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jasca, oquëxëhi quiha mi baquë. Dios-diosria Baquë ja quënahacaxëti xo. Jahuë jahëpa David yamaba yonati chama ja qui axëhi quiha Ibo Dios, jahuë nohiria yonati. ");
INSERT INTO caoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jabi Israél ca nohiria yona-yonapaoxëhi quiha. Jatiyamaxëhi quiha ja yonahaina —nëa tsi María qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jatsi ángel Mariá nicaniquë: —Yoxajahi xo ëa ra. ¿Jënahuariaxo raca baquë ë comana? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Jatsi angél quëbiniquë: —Mi qui joxëhi quiha Espíritu Santo. Tsëmo jascaria tsi mia mapaxëhi quiha Dios chama. Ja quëshpi tsi Dios Baquë jiaxëni ca quënahacaxëti xo mi Baquë, ja coquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","‘Mi rëquëmë Elisabet tsayahuë. “Tohoyatimaxëni xo” i nohiria bo paoni quiha mi rëquëmë yoati na. Jama, seis oxë no tsi ja tohoyaquë, sirixëni ja iqui ri. ");
INSERT INTO caoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Tsayahuë. Jatihuahacaxëti xo Diós yoahai tëquë. Jatiroha ca ati mëtsa xo ra —nëa tsi quiha María qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jatsi Mariá quëbiniquë: —Ibo yonati xo ëa ra. Jabija xo toa mi yoahana ra —iquiina. Jatsi ángel jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Toatiyá tsi bamahaxma tsi quiha Elisabet yaca qui María caniquë. Jabi jodioba mai maca bo xërëquë ó tsi jahuë yaca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Cahëhax Zacarías xobo qui María jiconiquë. Jicoxo tsi quiha Elisabet ja joihuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jatsi María joihuahai ca Elisabét nicaquë tsi quiha jahuë xamá ca baquë mohiniquë. Jatsi Espíritu Santó Elisabet chanimaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—Yoxa huëtsa bo oquë tsi mi shomahuahacaquë ra. Shomahuahacaquë mi baquë ri —itsi María qui Elisabet niquë joi pistiama cató no—. ");
INSERT INTO caoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","E qui shishohi noho Iboba jahëhua joquë pa. Shoma xo ëa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Jabi mi joihuahai ca ë nicaquë tsi rani tsi ëa xara ca baquë mohiquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mi qui angél yoahitaha ca jatihuaxëhi quiha Ibo Dios ra. Raniria xo mia ra, Dios qui mi chitimihai ca quëshpi na —i María qui Elisabet niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jatsi María chaniniquë: —Oquë xo Dios ra iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Noho Xabahamati Ibo Dios tahëhax tsi raniquia. ");
INSERT INTO caoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ea, naa jahuë yonati nori ca ja noiquë ra. Jaboqui “Shomahuahaca ca tsi xo toa” ixëhi quiha nohiria bo ëa yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Jiaria tsi xo ë qui Chamaxëni cató acana. Jiaxëni xo jahuë janë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jasca, ja qui aracanaibo noi-noipaohi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Anomaria tsi xo Diós acana jahuë chamá no. Jamë shinamisxëni cabo, oquë ca manëcascanaibo, tihi cabo pacanamahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nohiria chama-chamaria bo niahi quiha, jato oquë ja bënocano. Noitiria cabo oquëhuahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jasca, jahuë jahuë jia bá tsi paxnacanaibo sëyamaxëhi quiha. Jama, jahuëmishni jayaria cabo mëquëya tsi raaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jahuë Israél ca nohiria mëbihi johi quiha, jato noihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Jabi noba rëquëbo yamabo qui ja yoani ca shina-bënoyamahi quiha Dios ra, “Mato shomahuaxëquia” i Abraham, jahuë chahitaxocobo, tihi cabo qui ja ni quëshpi na —nëa tsi quiha María nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Jatsi tres oxë no tsi quiha Elisabet ya tsi María chitëniquë. Jaquirëquë jahari jahuë xobo qui ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tsëquëniquë Elisabet comati xabaca ra. Jatsi baquë ja comaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Jabi Elisabet Diós shomahuani nori ca jahuë yacatá ca nohiria, jahuë jimibo, tihi cabá nicaniquë. Ja raniyocani quiha jato ri, nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jatsi ocho bari huinocaquë tsi quiha jahuë baquë jibirishahi jahuë jimibo bëcaniquë. Jato jodioba jabi quiha. Jatsi jahuë jahëpa janë, naa Zacarías janë baquë qui ja acascaniquë toatiyá no. ");
INSERT INTO caoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jatsi jahuë jahëhuá quëbiniquë: —Juan ja quënahacaxëti xo ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—Majia. Yama tsi xo mi jimibo xërëquë ó ca toa janë jaya cato ra —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jatsi jato mëquë bá tsi jisti bo ja acacaniquë baquë jahëpa qui. Toca tsi Zacarías ja nicacaniquë: —¿Jahuë janë mi baquë qui axëhi ni noa ra? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Jatsi jahuë mëquënë́ tsi Zacarías bëëbëëhaniquë papi ja qui ja acano. Jatsi, “Jahuë janë tsi xo Juan” i ja quënëni ca ni quiha. Jatsi quiha ja ratëyocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jarohapa tsi chaniti mëtsa Zacarías iniquë pa. Chanitsijaniquë. Dios ocahuatsijahua-niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jatsi yacatá ca nohiria bo shina-risiquiniquë jënipijani ca nicahax na. Jatsi Juan coni chani pacanani quiha, jodioba maí ca maca ó ca nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nicahax ja shina-shinacaniquë. —¿Oquë ca ixëhi ni naa baquë sa? —i jaca ni quiha. Jasca, ja bëta Iboba chama iqui ca ja jiscaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jabi Espíritu Santo rëamë tsi Juan jahëpa Zacarías iniquë. Jatsi ja qui Diós ani ca chani yoatsijahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Oquë xo Ibo, Israél caba Dios. Jahuë nohiria mëbihi ja joquë ra, jocha quima noqui paquëmaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Jabi David yamaba chahitaxocobo noqui raahi quiha, noqui Xabahamati Ibo-iboria iti. ");
INSERT INTO caoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Naama tsi quiha jahuë Chani yoanish cabo Diós chanimani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","“Mato qui caxacanaibo quima mato xabahamaxëquia” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","73","Jabi noqui shomahuacatsi quiha Dios ra, naa noba rëquëbo yamabo ja shomahuariani jascaria. Tobi quiha jato qui ja yoanina, tobi quiha noba rëquëbo yamaba Abraham qui ja yoanina. Tihi ca tsi shina-bënoyamahi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Noqui caxacanaibo quima noqui xabahamacatsi quiha ra, raquëhaxma tsi Dios bax no yonocono iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ja bësojó tsi jocha yama, mëstë, tihi tsi no i-ipaoxëti xo, ja bax yonocohi na —nëa tsi quiha Zacarías nëcaniquë Dios Chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jatsi, —Dios-diosria Chani yoati ibo mi quënahacaxëti xo, noho baquë. Ibo bëbo caxëqui mia, Ibo johai ca quëshpi nohiria bo shomahuahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nohiria xabahamati quinia yoaxëqui mia ra, “Mato jocha mëbixëqui Dios” i jato quiina. ");
INSERT INTO caoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Toca tsi ahi quiha Dios, noqui noiquí na. Ja quëshpi tsi mana ca Huëa nori ca noqui raaxëhi quiha, ");
INSERT INTO caoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tsëmó cabo, bënoria ca rësoti basima cabo, tihi cabo qui huahuaxëti. Bëpasimati quinia ó tsi noqui rëquëninixëhi quiha —nëa tsi Zacarías nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Toatiyá tsi Zacarías baquë Juan shinahaniquë. Dios ja noiriani quiha. Shinahacax tsi quiha xabachá tsi Juan racaniquë. Toá tsi ja ini quiha, Dios Chani yoahi canox pari. Jaquirëquë Israél maí ca nohiria bësojó tsi quiha ja jisiquiniquë, naa jahuë yonoco chitahëhuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Toatiyá tsi quiha romanoba chama-chamaria Augustó jahuë chani raaniquë nohiria tëquë qui. —Tocahacati xo nohiria tëquë —i quiha ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Jabi jariapari ca nohiria tocani ca xaba tsi xo naa. Jasca, toatiyá tsi quiha Siria mai xo tsi chama Cirenió yonani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jatsi jahanahax ja cocani ca yaca qui jatiroha cabo bocaniquë tocahacati. ");
INSERT INTO caoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Caniquë José ri. Jahuë Galileá ca maí ca yaca Nazaret ja jisbayaniquë Belén yaca qui caxëna. Jabi Belén, naa jahuë David yamaba coni ca yaca qui ja cani quiha tocahacati, David yamaba chahitaxocobo huësti ca ja ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Jasca, ja bëta caniquë María ri, naa jahuë ahui ti cato. Jabi tohoya tsi María ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén tsi jacano tsi quiha jahuë baquë comati xaba tsëquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Jatsi jahuë jariapari ca baquë Mariá comaniquë. Comaxo tsi quiha raití tsi Mariá yaboniquë. Yaboxo tsi quiha yohina piti caja ó tsi jahuë Baquë ja jananiquë. Yama ini quiha racati xobó ca xëa rë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jabi yaca basima tsi quiha oveja obëso caba oxti iniquë. Baquicha quiha. Jato oveja ó bësohi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jatsi jato bësojó tsi iboba ángel jisiquiniquë. Jasca, jato tëamë tsi quiha Iboba oquë bajra-bajraniquë. Raquëriatsijacaniquë tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jatsi jato qui ángel chaniniquë: —Raquëyamacana. Chani jia ca mato qui bëquia. Nohiria tëquë ranihuaxëhi quiha ë yoahaina. ");
INSERT INTO caoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jaboqui David yacatá tsi coyaquë Xabahamati Ibo ra. Mato Cristo, naa Diós raaha ca Ibo tsi xo naa. ");
INSERT INTO caoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yabohaca ca baquë jisxëqui mato. Yohina piti cajá tsi raca ixëhi quiha. Tocatsixëhi quiha, noho quiayama ca chani ma cahëno iquish na ra —nëa tsi quiha jato qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Jatsi quiha ángel ya tsi jisiquitapiniquë huëstima ca naipá ca ángel bo. Misco quiha. Dios ocahuahi ja icani quiha. Jabi ja yoacani ca tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—Mana ca Dios oquëhuahacano ra. Ja qui jia cabo, naa jahuë maí ca nohiria xërëquë ó ca rabëti bo bëpasimacatsi quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jatsi quiha nai qui ángel bo bocaniquë. Ja bocaquë tsi quiha oveja obëso cabo chaninaniquë: —¿Belén jisi canomani? Jënipijaha ca no jisno. Jia tsi xo naa Ibobá noqui yoahana ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Jatsi quiha Belén qui ja jabacaniquë baquë mërahi na. María, José, piti cajá ca racahai ca Baquë, tihi cabo ja jiscaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Baquë jisi tsi quiha angél jato yoaha ca ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Jatsi oveja obëso cabá yoani ca qui ratëyoniquë nicanish cabo tëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María qui jia ini quiha ja yoacanina. Jënipijacani ca tëquë ja shina-shinani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Jatsi quiha oveja obëso cabo bacaniquë. Bacahi tsi ja quëquëcanacaniquë. Jia tsi Dios ja ocahuacaniquë, naa ja jiscanina, ja nicacanina, tihi cabo quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Huësti ca semana huinocaquë tsi quiha jato baquë jibirishahacaniquë. Toatiyá tsi Jesu jato baquë ja janëcani quiha. Jabi toa janë baquë qui angél ani quiha, siri, naa María tohoyanox pari no. ");
INSERT INTO caoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Jatsi quiha tsëquëniquë arati xobo xo tsi María bahuëhacati ca xabaca. Jatsi Jerusalén qui José ya María caniquë, Moisés yamabá yoba jatihuaxëna. Cahëxo tsi quiha arati ibo qui jato yobá yoani ca jahuë bo ja acaniquë bahuëhacati. “Tëpas-hacati xo rabë ca botocoa. Jama, toa pi ati mëtsama jaca no tsi tëpas-hacati nori rabë ca corobisa iquë” nëa tsi jato yoba nëcani quiha. Jasca, toa barí tsi Jerusalén qui jato baquë Jesu ja bëcaniquë Dios qui mëaxëna. Jato jodioba jabi quiha. Ja tocacani quiha Iboba yoba quënëni ca tahëhax na, naa “Dios qui mëahacaxëti xo jariapari ca cohax ca baquë” i Dios yoba ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Naatiyá tsi quiha Jerusalén tsi joni iniquë, naa Simeón icanai cato. Joni shinajiaxëni ca naa joni ini quiha, Dios qui aranish ca iquiina. Israél cabo Xabahamati Ibo johai ó ja pasoni quiha. Jasca, Espíritu Santo rëamë tsi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jasca, rësoti ó ja pasoyamani quiha, Ibobá raahai ca Xabahamati Ibo jisquë rohari. Toca ca Espíritu Santó jismani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Jatsi quiha arati xobo qui Simeón caniquë, Espíritu Santó mëpihacahax na. Jabi toá tsi ja ini quiha, jahuë nabo ya Jesu cahëquë no. Jasca, Moisés yoba jatihuahi quiha José, María, tihi cabo bëcaniquë jato baquë Jesu ya. ");
INSERT INTO caoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Jatsi jato baquë pistia quiha Simeón iconiquë jisish na. Icoxo tsi quiha jia tsi Dios ja ocahuaniquë. Ja nëcani quiha: ");
INSERT INTO caoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","—Jarohari tsi ëa mi yoani ca jatihuahacaquë ra. Jaboqui ranihax tsi rësoti mëtsa xo ëa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Noho bëro yoí tsi Xabahamati Ibo ë jisquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Nohiria bo tëquë qui naa baquë mi raaquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Carayanabo qui ja raahacaquë ra, mia ja cahëcano iquish na jato ri. Mi Israél ca nohiria qui ja raahacaquë ra, jato oquëhuaxëna —nëa tsi quiha Simeón nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jatsi Jesu nabo ratëniquë toca tsi jato baquë yoati Simeón chaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jatsi María, José, jato baquë, tihi cabo bax Simeón bëhoxniquë, Diós jato shomahuano. Bëhoxhax tsi quiha Jesu jahëhua qui ja chaniniquë: —Mi Baquë Diós biniquë ra. Ja iqui tsi bënoxëhi quiha huëstima ca Israél cabo. Jasca, ja iqui tsi rani-ranixëhi quiha huëstima cabo. Jabi Dios quima ca jisti ixëhi quiha mi Baquë. Ja pasomaha chanixëhi quiha huëstima cabo rë. Jasca, Dios quinia nohiria bo jismaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Toca tsi nohiria bá shinahai ca jonë ca jahuë bo jisiquimaxëhi quiha mi Baquë. Jasca, cohuëriaxëqui mia ri, naa mi shina saipí nacohai jascaria —nëa tsi quiha María qui Simeón nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Jasca, tobi quiha arati xobó tsi yoxa iniquë, naa Ana icanai cato. Dios Chani yoanish ca yoxa ja ini quiha. Fanuel jahi ja ini quiha, naa Aserbo icanai ca maxo quima conish cato. Jabi sirixëni Ana iniquë. Siete año roha no tsi bënë ja jayani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Rësoni quiha jahuë bënë. Jaquirëquë ochenta año no tsi Dios arati xobo ja jisbayayamani quiha. Toá tsi barihani, baquicha, tihi ca tsi Dios qui ja ara-arani quiha. Jasca, toá tsi samapama tsi ja bëhoxni quiha. Jahuë jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","María, José, tihi cabo ya Simeón chaninano tsi Ana joniquë. Johax Dios qui “Gracias” itsijaniquë jaa ri, baquë tsayahax na. Jatsi Israél cabo Diós xabahamati ó pasocanaibo qui chanitsi quiha Ana niquë baquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Jaquirëquë ja yoahacani ca ati jahuë bo tëquë María, José, tihi cabá jatihuaniquë, naa Iboba yobá yoani cato. Jatihuahax jahari Galilea mai qui ja bocaniquë jato Nazaret yaca qui. ");
INSERT INTO caoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Toatiyá tsi quiha jato baquë Jesu shinahaniquë. Ja coshinani quiha. Ja tiisinani quiha. Jabi jato Baquë Jesu quiha Diós shomahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jabi jatiroha ca xënipá tsi quiha Jerusalén qui Jesu nabo bocaniquë pascua fiesta axëna. Jato jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jatsi doce año bo jatihax jahuë nabo ya Jerusalén qui Jesu caniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Toa fiesta huinocaquë tsi quiha jato xobo qui bacatsi María, José tihi cabo niquë. Jama, Jerusalén tsi chitëhi Jesu iniquë pa. Yopayamani quiha jahuë nabo. ");
INSERT INTO caoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jahuë rabëti bo ya tsi bacahai ja iqui ca ja quëscahuajahuacani quiha. Toca tsi huësti bari ja raacaniquë bahí no. Jatsi yata tsi jato rabëti bo, jato jimibo, tihi cabo xërëquë xo tsi Jesu mëratsijahuacaniquë. Yama a ra. ");
INSERT INTO caoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mahitsa ja mëracaniquë rë. Jarohari tsi quiha jahari Jerusalén qui José, María, bocaniquë mëraxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Tres bari tsi ja raacaniquë Jesu mërahi na. Jarohari tsi arati xobó ca jato baquë ja jiscaniquë. Yoba tiisimacanaibo ya tsaho ja ini quiha. Jato bëta chaninahi Jesu iniquë Quënëhacanish cabo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Jabi Jesu tiisi, ja quëbihaina, tihi cabo qui ja ratëyocaniquë, naa nicacanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Jato bëta ja iqui ca jisi tsi quiha jahuë nabo ratëniquë jato ri. Jatsi quiha ja qui jahuë jahëhua chaniniquë: —¿Jëniriahax noqui mi nëcaha pa? Noba shina jii-jiiquë rë mia mërahi na. Mahitsa mia no mëra-mëraquë ra —i María niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jatsi Jesú jato quëbiniquë: —¿Jëniriaxo tsi ëa mëracanai pa? ¿Noho Jahëpa xobó tsi ë iti nori ca ma cahëyamaha? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jama, ja quëbini ca jahuë nabá cahëyamaniquë. Jato joma quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jatsi quiha jahari Nazaret qui Jesu caniquë jahuë nabo ya. Jato ja nica-nicaniquë ra. Jabi jënipijani ca jahuë jahëhuá shina-shinaniquë. Ja shina-bënoyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jatsi shinahaniquë Jesu. Shinahacax ja tiisinaniquë. Dios, nohiria, tihi cabá toa baquë noiniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jabi quince año bo jatiquë tsi quiha romanoba chama-chamaria Tiberió nohiria bo yonaniquë jaa ri. Jasca, ja namá tsi jodioba mai Poncio Pilató yonani quiha ja bax na. Jasca, chama Tiberio bax Galilea mai Herodés yonani quiha jaa ri. Jasca, Iturea, Traconite, tihi cabo yonani quiha Herodes noma Felipe. Chama Lisaniás Abilinia mai yonani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Jasca, arati ibo-iboria bo Anás, Caifás tihi cabo ini quiha. Jatsi toatiyá tsi quiha Zacariás baquë Juan qui Dios Chani joniquë. Xabachá tsi racahi Juan ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jatsi ani Jordán tapaí ca racahai ca nohiria bo qui Dios Chani Juán yoabonaniquë. Yoabonahax jato qui ja nëcaniquë: —Ashimahacaxëti xo nohiria bo. Mato jocha quima Dios quiri bësocana, mato jocha masahacano ra —i nohiria bo qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jabi Juán acai ca yoati tsi Isaías yamabo chaniniquë ja quënëni cato ó no. Jabi siri tsi ja quënëni ca tsi xo naa: “Xabacha xo tsi quënaxëhi quiha. Quënahax, ‘Rohahuahacacana, Ibo johai ca quëshpi na’ ixëhi quiha. ‘Bahi mëstë ca acana ja bax coti. ");
INSERT INTO caoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Rëahacaxëti quiha quini bo. Michorohacaxëti quiha tëmachi bo. Mëstëhuahacaxëti quiha yoro ca iti bo. Parahuahacaxëti quiha bahi yoi cabo. Toca tsi rohahuahacaxëti quiha mato shinana ra, Ibo johai ca quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jasca, Dios xabahamati quinia jisxëhi quiha carayanabo ri, naa nohiria tëquë’ nëcaxëhi quiha”. Jabi nëca tsi Isaías yamabá quënëni quiha Juan yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jatsi huëstima ca nohiria Juan qui bëcaniquë ashimahacaxëna. Jato ja yoani ca tsi xo naa: —Quiaxëni caba xocobo xo mato ra. Tsëquëti basima tsi xo nohiria qui Dios caxahai ca bari ra. ¿Tsohuë mato yobani, Dios caxa quima ax jabati? ");
INSERT INTO caoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","¿Mato jocha quima Dios quiri ma bësoha pa? No tsayano. Jariapari tsi jabi paxa ca ma jismaxëti xo. “No xabahamahacaxëti xo, Abraham yamaba chahitaxocobo no nori quëshpi na” iyamatsicana. Mato mëbiti mëtsama xo Abraham yamabo ra. Tsayacahuë. Naa maxax bo biti mëtsa xo Dios, Abraham xocobo yoi bo axëna iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jatsi quiniacaxëcahuë. Mato copipaimaria xo Dios ra. Bimi jia ca pi jihuí saihuayamano tsi toa jihui rëraxëhi quiha ibo. Rëraxo tsi chihi qui niahi quiha. Jatsi jabi paxa ca ma saihuaxëti xo —nëa tsi nohiria bo qui Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jatsi, —¿Jënahuaxëhi ni noa ra? —i Juan qui nohiria niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jatsi Juán jato quëbiniquë: —¿Dos ca sahuëti jaya ni mato? Dos ca pi jayaquí tsi noitiria ca qui huësti ca acana. ¿Huëstima ni mato oriquiti? Huëstima pi jayahi tsi huëtsa bo ya xatënacana —i quiha jato qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jatsi impuesto bicanaibo, naa nohiria qui anoma cabo bëcaniquë ashimahacaxëna. —¿Jënahuaxëhi ni noa, maestró? —i Juan qui jaca niquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jatsi, —Gobierno qui nohiriá mëati ca parata roha bicana. Huino ca biyamacahuë —i jato qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Jatsi soldado bá nicaniquë: —¿Jënahuaxëhi ni noa ra? —iquiina. Jato ja quëbiniquë: —Nohiria roayamacana parata bixëna. Mato sueldo quëshpi tsi ranicana —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Toatiyá tsi Xabahamati Ibo ó nohiria bo pasohi ini quiha. Ja quëshpi tsi jato Cristo Juan iqui ca ja quëscahuajahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Japi jato tëquë qui Juan nëcaniquë: —Jënë́ tsi mato ashimaquia. Jama, joxëhi quiha ëa oquëria cato ra. Ea tsi xo oquë yama cato. Espíritu Santó tsi, naa chihi iquiria cató tsi mato ashimaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Joxo tsi jahuë́-na bo tsëcaxëhi quiha, ja otohai ca qui ja jicocano iquish na. Jama, trigo xaca jascaria tsi nocatimaxëni ca chihi qui yoixëni cabo niaxëhi quiha mëshoxëna —nëa tsi Juán nëcaniquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dios Chani yoapama tsi huëstima tsi nohiria Juán yobaniquë, Dios quiri ja bësocano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jasca, chama Herodes pasomaha Juán chanipaoniquë, jahuë noma ahui ja bini iqui na. Jabi jahuë noma ahuini, naa Herodías icanai ca ja bini quiha, jahuë ahui iti. Jasca, huëstima ca yoi ca Herodés ani quiha. Jahuë jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Jatsi pë preso qui Herodés Juan nanëniquë. Anoma toa joni iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nohiria tëquë ashimahacayoquë tsi quiha Jesu ashimahacaniquë jaa ri. Bëhoxjano tsi quiha nai japëquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jatsi ja qui Espíritu Santo botëniquë; boto jisiria ja nori. Jatsi, —Noho Baquë yoi xo mia. Mia noiquia. Ea ranihuaqui mia ra —i quiha naipá ca joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jabi treinta año bo quiha Jesú jayaniquë, jahuë yonoco ja chitahëhuaquë no. Jabi José baquë ja nori ca quëscahua nohiria bá huaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","José jahëpa Elí iniquë. Elí jahëpa Matat iniquë. Matat jahëpa Leví iniquë. Leví jahëpa Melqui iniquë. Melqui jahëpa Jana iniquë. Jana jahëpa José iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José jahëpa Matatías iniquë. Matatías jahëpa Amós iniquë. Amós jahëpa Nahum iniquë. Nahum jahëpa Esli iniquë. Esli jahëpa Nagai iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jahëpa Maat iniquë. Maat jahëpa Matatías iniquë. Matatías jahëpa Semei iniquë. Semei jahëpa José iniquë. José jahëpa Judá iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá jahëpa Joana iniquë. Joana jahëpa Resa iniquë. Resa jahëpa Zorobabel iniquë. Zorobabel jahëpa Salatiel iniquë. Salatiel jahëpa Neri iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri jahëpa Melqui iniquë. Melqui jahëpa Adi iniquë. Adi jahëpa Cosam iniquë. Cosam jahëpa Elmodam iniquë. Elmodam jahëpa Er iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er jahëpa Josué iniquë. Josué jahëpa Eliezer iniquë. Eliezer jahëpa Jorim iniquë. Jorim jahëpa Matat iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat jahëpa Leví iniquë. Leví jahëpa Simeón iniquë. Simeón jahëpa Judá iniquë. Judá jahëpa José iniquë. José jahëpa Jonán iniquë. Jonán jahëpa Eliaquim iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim jahëpa Melea iniquë. Melea jahëpa Mainán iniquë. Mainán jahëpa Matata iniquë. Matata jahëpa Natán iniquë. Natán jahëpa David iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David jahëpa Isaí iniquë. Isaí jahëpa Obed iniquë. Obed jahëpa Booz iniquë. Booz jahëpa Salmón iniquë. Salmón jahëpa Naasón iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón jahëpa Aminadab iniquë. Aminadab jahëpa Aram iniquë. Aram jahëpa Esrom iniquë. Esrom jahëpa Fares iniquë. Fares jahëpa Judá iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá jahëpa Jacob iniquë. Jacob jahëpa Isaac iniquë. Isaac jahëpa Abraham iniquë. Abraham jahëpa Taré iniquë. Taré jahëpa Nacor iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor jahëpa Serug iniquë. Serug jahëpa Ragau iniquë. Ragau jahëpa Peleg iniquë. Peleg jahëpa Heber iniquë. Heber jahëpa Sala iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala jahëpa Cainán iniquë. Cainán jahëpa Arfaxad iniquë. Arfaxad jahëpa Sem iniquë. Sem jahëpa Noé iniquë. Noé jahëpa Lamec iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec jahëpa Matusalén iniquë. Matusalén jahëpa Enoc iniquë. Enoc jahëpa Jared iniquë. Jared jahëpa Mahalaleel iniquë. Mahalaleel jahëpa Cainán iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán jahëpa Enós iniquë. Enós jahëpa Set iniquë. Set jahëpa Adán iniquë. Adán jahëpa Dios iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jatsi quiha ani Jordán Jesú jisbayaniquë. Espíritu Santo rëamë ja ini quiha. Jatsi cuarenta bari no tsi xabaca ax tsi ja mëpihacaniquë Espíritu Santó no. ");
INSERT INTO caoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jabi xabacá ja no tsi quiha Satanás Jesu tanamaniquë jochamaxëna. Cuarenta bari no tsi Jesú piyamani quiha. Ja paxnani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Jatsi ja qui Satanás chaniniquë: —Dios Baquë iipiquí tsi naa maxax yoahuë mapari ja manëno —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jatsi Jesú quëbiniquë: —“Maparí roha tsi bësoyamaxëhi quiha joni, jama, Dios Chaní tsi ja nori” ii quiha Quënëhacanish cabo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jatsi quiha mana Satanás Jesu boniquë tëmachí no. Boxo tsi quiha maí ca chama bá yonahaina, jato oquë, tihi cabo Jesu ja jismaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Jismahax ja nëcaniquë: —Naa nohiria bo yonati chama tëquë, ja yonacanai ca oquë, tihi cabo mi qui axëquia, ë qui ja acacani nori quëshpi na. Jabi tsohuëcara, naa ë qui jia ca qui naa tëquë ati mëtsa xo ëa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Japi ë qui mi arapino tsi jatiroha ca mina-xëhi quiha —i Satanás niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jatsi Jesú quëbiniquë: —“Mato Ibo Dios roha qui ma arano ra. Mato chama roha ca tsi xo toa” ii quiha Quënëhacanish cabo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jaquirëquë Jerusalén ca arati xobo qui Satanás Jesu boniquë. Boxo tsi quiha jodioba arati xobo cacha, naa jahuë quëmapó tsi Satanás niimaniquë. Niimahax ja qui ja chaniniquë: —“Dios Baquë iipiquí tsi mai qui mimë niahacahuë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mato qui jahuë ángel bo raaxëhi quiha Dios, mato ó ja bësocano” ii quiha Quënëhacanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Jasca, “Jato mëquënë́ tsi mia bëcaxëcani quiha ángel bo, mi paquëyamano, mi tahë tëquëyamano iquish na” ii quiha —nëa tsi quiha Jesu qui Satanás nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jatsi Jesú quëbiniquë: —“Mi Ibo Dios tanamayamahuë” ii quiha Quënëhacanish cabo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jabi huëstima ca quiniá tsi Satanás Jesu tanamaniquë jochamaxëna; mahitsa quiha. Jochamati mëtsaxoma tsi quiha ja jisbërianiquë, oquë ca xaba huëtsa manaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jatsi quiha Galilea mai qui Jesu bacaniquë. Espíritu Santo chama jayani quiha. Jabi toa maí tsi quiha chani pacananiquë ja acai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jasca, jato catiti xobo xo tsi Jesú tiisimaniquë. —Anomaria tsi xo toa joni ra —i nohiria bo niquë jahuë chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jatsi quiha Nazaret qui Jesu joniquë, naa jahá ja shinahani ca yacata. Jabi toa barí tsi jato catiti xobo qui ja caniquë tiisimahi na. Jahuë jabi quiha. Jatsi quiha Jesu niiniquë Quënëhacanish cabo nicamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Isaías yamabá quënëni ca libro Jesu qui acacani quiha. Japëcaxo tsi quiha Dios Chani jato ja nicamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","—“E bëta xo Ibobá Shinana ra. Ea ja raaquë, Chani jia ca noitiria cabo qui ë yoano. Ea ja raaquë, ‘Paquëmahacaxëqui mato’ i achiqui cabo qui ë no, ‘Jistëquëxëqui mato’ i bëco cabo qui ë no. Ea ja raaquë cohuë cabo ë mëbino. ");
INSERT INTO caoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","‘Ibobá nohiria bo xabahamati xaba tsi xo naa’ ë iti xo” —nëa tsi Jesu nëcaniquë Dios Chani nicamahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Nicamaxo tsi quiha libro Jesú mapaniquë. Jatsi ibo qui axo tsi quiha ja tsahoniquë. Jatsi xobó ca nohiria tëquëtá tsaya-tsayaniquë ratëquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jatsi, —Jaboqui mato bësojó tsi jatihuahacaquë Isaías yamabá quënënina ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jatsi Jesú yoani ca qui nohiria bo shina-risiquiniquë. —Anomaria tsi xo toa ja chanihaina ra. ¿José baquë ma ni naa sa? —itsi quiha nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jatsi quiha Jesú jato quëbiniquë: —Mato yosiba yoba ëa yoacasqui mato tia, naa “Noqui pari mëbihuë, nohiria huëtsa bo mi mëbinox pari” iquiina. Jasca, “¿Jënahuariaxo raca mi coni yacata xo tsi jisti bo ayamahai rë, naa Capernaum mai xo tsi mi aquitaha jascaria?” itiari ë qui xëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jama, jaha ja coni ca yaca qui Dios Chani yoati ibo jono tsi jahuë chani bicasyamahi quiha jahuë yacatá ca nohiria bo pë iquia ra. Jascaria, ëa bicasyama xo mato rë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ea nicaparicana. Mato parayamaquia. Jabi Elías yamabo bësono tsi quiha huëstima ca bënë imanish cabo racapaoniquë jodioba maí no. Toatiyá tsi quiha tres año y medio no tsi yama oi iniquë. Jasca, oriquiti binianiquë nohiria tëquë rë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Jama, toa nohiria bo qui Elías yamabo raahacayamaniquë mëbiti. Jama, noitiria ca bënë imanish ca, naa carayana qui Elías yamabo raahacaniquë ra, naa Sidón basima ca Sarepta yacatá ca racanish ca yoxa qui. Tocapijaniquë ra, Elías yamabo qui jahuë nohiria bá nicacasyamani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Jasca, Eliseo yamabo bësono tsi quiha huëstima ca leproso bo, naa bonohuaxëni cabo iniquë jodioba maí no. Jama, ja jënimahuahacayama-caniquë, Eliseo yamabo qui ja chitimiyamacani iqui na. Jama, carayana ca Naamán yamabo jënimahuahacaniquë ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jatsi Jesu qui caxarianiquë toa catiti xobó ca nohiria tëquë jahuë chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ja niitapicaniquë ja qui tsamixëna. Niixo tsi quiha yaca cacha Jesu ja xërëcaniquë. Xërëxo tsi quiha tëmachi cacha ja bocaniquë, naa jato yaca rohahuahacani cató no. Toa quëmapo xo tsi rënichi Jesu ja niajahuacascani quiha axëna. ");
INSERT INTO caoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jama, toa nohiria misco Jesu naconiquë pa, jato jisbëriaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jaquirëquë quiha Capernaum yaca qui Jesu caniquë, naa Galileá ca yacata. Toa xo tsi nohiria bo tiisimatsi quiha Jesú huaniquë joiti barí no. ");
INSERT INTO caoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jabi ja tiisimani ca qui nohiria bo ratëniquë, chama ya ja tiisimani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Toa catiti xobó tsi quiha yoshi jayanish ca joni iniquë. Joi pistiamá tsi quiha ja quënaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jishopë. Noqui jisbayahuë ra, Nazarét ca Jesú. Noqui quëyohi mi joquë pë. Mia cahëquia. Dios Baquë jiaxëni ca xo mia ra —i ja qui yoshi niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jatsi quiha Jesú raahaniquë: —Pasihuë. Joni quima ax natsëquëhuë —iquiina. Jatsi pë nohiria bo bësojó tsi yoshiní joni nianiquë mai qui. Niahax joni quima ja natsëquëniquë. Jatsi jënima toa joni ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jatsi nohiria ratëyoniquë. —¿Jahuë chani ni naa sa? Chamá tsi yoshi bo qui ja chaniquë pa. Natsëquëquë jahuë yoshi bo ra —i nohiria bo niquë. Toca tsi ja chaninacani quiha ratëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Jatsi quiha toa maí tsi chani pacananiquë, Jesú ani ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Catiti xobo jisbaya tsi quiha Simón xobo qui Jesu caniquë. Iquihi quiha Simón raisi iniquë rë. Jatsi quiha Jesu qui ja chanicaniquë yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jatsi jahuë naquëtë qui Jesu jiconiquë. Jicohax jahuë oxati tapaí ja niiniquë. Jatsi quiha jahuë iqui qui Jesu chaniniquë ja janacano. Jatsi ja janacatapiniquë ra. Bamahaxma tsi ja niiniquë. Jënima ja ini quiha. Niixo tsi jato qui oriquiti ja taaniquë pa. ");
INSERT INTO caoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Bari chixabano tsi quiha isicanaibo, iquicanaibo, anomaria cabo, tihi cabo nohiria bá Jesu qui bëniquë ja jënimahuahacacano. Jatsi bëcanish cabo tëquë ja motsaniquë jahuë mëquënë́ no. Jato tëquë ja jënimahuani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jasca, huëstima ca yoshi bo natsëcahacani quiha nohiria bo quima. Natsëquëhax ja quënacaniquë: —Dios Baquë xo mia ra —iquiina. Jatsi quiha yoshi bo Jesú raahaniquë. Jato ja pasimani quiha, Dios raahacanish ca Xabahamati Ibo ja iqui ca ja cahëcani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jaquirëquë huëaquë tsi yaca Jesú jisbayaniquë xobo yama ca iti qui caxëna. Jatsi quiha nohiria bá yopaniquë. Yopaxo tsi quiha Jesu mëratsijahuacaniquë. Jisi tsi, —Jari cayamahuë rë. No bëta mi chitëno ra —i ja qui nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jama, —Yaca huëtsa bo qui ë cati xo, “Nohiria bo otocatsi quiha Dios” ixëna. Ja tsi xo toa ë raahacanina —i Jesu jato qui niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Jatsi quiha jodioba mai xo tsi Dios Chani Jesú yoabonaniquë jato catiti xobo xo na. ");
INSERT INTO caoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Huësti barí tsi quiha Genesaret ia quëmapó tsi nii Jesu iniquë, Dios Chani yoahi na. Ja qui nicapama tsi ja qui nohiria bo quëtsoniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jatsi dos ca rërënish ca noti bo Jesú jisniquë. Mëquëya quiha. Basima tsi jato ibo bo ini quiha, jato nishi bo chocohacaina. ");
INSERT INTO caoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jatsi nohiria misco iqui tsi quiha noti qui Jesu jiconiquë jabaxëna. Jabi Simón notí ja ini quiha. Jicohax, —Tori pistia noti chishtëquirimahuë —i Pedro qui ja niquë. Jatsi noti xo tsi nohiria bo ja tiisimaniquë tsahoxo na. ");
INSERT INTO caoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jahuë chani jatihuahax Pedro qui ja chaniniquë: —Tori pistia noti rëboohahuë, naa paxnëmi ca qui. Toa xo tsi mato nishi niacahuë sani bixëna —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jatsi Simón quëbiniquë: —Mahitsa no tanashinaquë rë. Yama a. Jama, “Niahuë” i pi mi no tsi aqui noa tia —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jatsi quiha jato nishi bo ja niacaniquë. Ja niacaquë tsi quiha nishi qui huëstima ca sani rëoconiquë. Tihiria ca racana. Rërëtsë-paimaria jato nishi ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Jaha tsi quiha jato rabëti bo qui jato mëquënë́ tsi ja bëëbëëhacaniquë ja bëcano jato mëbixëna. Jatsi jato rabëti bo bëcaniquë mëbixëna. Jato noti ja rëacani quiha. Huëstima ca sani iqui tsi jëtëquëpaimaria jato noti bo ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Tocapijani ca jisi tsi Jesu bësojó tsi Pedro mëniniquë. —Noqui jisbayahuë, Taitá. Ea tsi xo jochahuaxëni cato ra. E bëtacasyama xo mia tia —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jabi ratëniquë Pedro, ja bëtanish cabo, naa tihiria ca sani ja bicani tahëhax na. ");
INSERT INTO caoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jasca, ratëniquë Jacobo, Juan ri, naa Zebedeo baquë bo. Jabi Pedro ya yonoconabë-quinish cabo ja icani quiha. Jatsi, —Raquëyamahuë, Pedró. Jaboqui rohari tsi joni bo bixëqui mia. Dios quinia jato qui jismaxëqui mia —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jatsi jato noti bo rërëhaxo tsi jatiroha ca ja jisbëriacaniquë Jesu banahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jabi jahuëcaraca yaca shishopama tsi quiha lepra jaya ca joní Jesu bëchaniquë. Bonohuaxëni ca joni ja ini quiha. Jesu jisi tsi ja bësojó ja mëniniquë. —Aapicatsi tsi ëa jënimahuati mëtsa xo mia, Taitá —iriatsi ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jatsi quiha Jesú joni motsaniquë. Motsahax, —Mia jënimahuacasquia ra. Jënima xo mia —i ja qui ja niquë. Jatsi quiha jahuë bono tapoyotapiniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jatsi joni Jesú yobaniquë: —Jënipimiha ca huëtsa bo yoayamaxëhuë. Bamaxoma tsi arati ibo qui mimë jismata. Moisés yoani ca jahuë ja qui ahuë tëpasti, naa mi bahuëxëhai ca quëshpi na. Tocapimino tsi jënima mi nori ca cahëcaxëcani quiha nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Jaquirëquë quiha Jesu yoati tsi chani pacanarianiquë. Ja iqui tsi ja qui huëstima ca nohiria quëtsoniquë jahuë chani nicaxëna. Jasca, ja bëcani quiha jënimahuahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jama, Jesú jato jisbërianiquë nohiria yama ca iti qui caxëna. Jaha tsi quiha Dios qui ja bëhoxniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jesú nohiria bo tiisimano tsi quiha ja tahë tsi fariseobo, yoba tiisimacanaibo, tihi cabo tsaho iniquë. Jabi huëstima ca yaca bo ax ja bëcani quiha. Galileá ca yaca bo, jodioba maí ca yaca bo, Jerusalén, tihi cabo ax ja bëcaniquë Jesu nicaxëna. Jabi Ibo Dios chama Jesú jayani quiha nohiria jënimahuati. ");
INSERT INTO caoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Jatsi quiha joni bá mohiyama ca bëniquë jahuë oxatí no. Xobo qui cahëhax ja jicocas-caniquë, Jesu bësojó noitiria ca joni janaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Jicotimaxëni ja icani quiha nohiria misco iqui na. Jatsi quiha xobo mapasti qui ja bocaniquë. Jaha xo tsi quiha teja bo ja tsëcacaniquë quinihuaxëna. Quinihuaxo tsi quiha naxërëquë tsi joni ja botëmaniquë jahuë oxatí no. Jesu bësojó tsi ja botëmajahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jabi mohiyama ca jënimahuati mëtsa ca Jesu iqui ca joni bá cahëni quiha. Jasca, ja chahahuacanai ca jisi tsi, —Masahacaquë mi jocha, noho baquë —i joni qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jatsi quiha jamë xërëquë tsi chaninatsi fariseobo, yoba tiisimacanaibo, tihi cabo niquë. Shinahax, —Quiaxëni ca joni tsi xo naa ra. Dios pasomaha chanihi quiha pë. ¿Jënahuariaxo raca jocha ja masana? Jaroha xo Dios —i jaca niquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jama, ja shinabëquicanai ca jahuë bo Jesú cahëniquë. Cahëhax, —¿Jëniriahax toca tsi shinacanai pa? ");
INSERT INTO caoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Jënica ni toa bëroria ca yoati? “Masahacaquë mi jocha” ¿iti ni? “Niina. Cohuë” ¿iti ni? ");
INSERT INTO caoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Nohiria ba jocha masati chama ë jaya ca ma cahëno ra —i quiha jato qui Jesu niquë. Jatsi mohitimaxëni ca qui Jesu chaniniquë: —Niina. Mi oxati bihuë. Mi xobo qui cata —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jatsi niitapiniquë joni jato bësojó no. Jatsi jahuë oxati ja bitapiniquë. Bichi tsi quiha jahuë xobo qui ja caniquë. Jia tsi Dios ja ocahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Jasca, shina-risiquiniquë nohiria. Ja ratëyocani quiha. Jatsi Dios ocahuatsijahuacaniquë jato ri: —Anomaria tsi xo naa jaboqui no jisina ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jaquirëquë quiha xobo jisbaya tsi gobierno bax parata binish ca joni Jesú bëchaniquë, naa Leví icanai cato. Jahuë parata biti xobó tsi tsaho ja ini quiha. Jatsi, —E bëta mi jono —i Leví qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Jatsi Leví niiniquë. Niixo tsi quiha jatiroha ca ja jisbërianiquë Jesu banahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jatsi quiha jahuë xobo xo tsi Jesu Leví orihuacasniquë. Toá tsi ini quiha nohiria misco, naa gobierno bax parata bicanaibo, Leví rabëti huëtsa bo. ");
INSERT INTO caoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Jasca, toá tsi fariseobo, yoba tiisimacanaibo, tihi cabo ini quiha jato ri tsaya-tsayaxëna. Jatsi Jesu pasomaha ocahuatsijahuacaniquë jahuë rabëti bo qui: —¿Jënihax tsi gobierno bax parata bicanaibo, jochahuaxëni cabo, tihi cabo ya tsi oriquicanai pa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jatsi quiha Jesú jato quëbiniquë nicaxo na: —Doctor qui bocani quiha anoma cabo roha. Jënima cabo tsi xo cayamahaina. ");
INSERT INTO caoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jasca, jamë shinamisxëni cabo quënahi ë joyamaniquë; jama, noitiria ca jochacanaibo jato jocha quima Dios quiri bësomahi nori —nëa tsi quiha jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Jatsi quiha nëca tsi Jesu qui nohiria bo chaniniquë: —Huëstima tsi xo Juan rabëti bo samacanaina. Jasca, huëstima tsi xo Dios qui ja bëhoxcanaina ra. Tocacani quiha fariseoba jabi acanaibo ri. Jama, mi rabëti bo tsi xo tocayamahaina pa. Mi rabëti bo tsi xo picanaina, jënë acaina rë —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jatsi quiha Jesú quëbiniquë: —¿Joní ahui yano tsi samahi ni ahui yahax cato rabëti bo pa? Iyamacani quiha ra. Cohuëti xaba ma xo. Toa barí tsi ja bëta oriquicani quiha. Jascaria, jaboqui samayamahi quiha noho rabëti bo ri jato bëta ë iquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Jama, jato quima ë mëbihacano tsi samacaxëcani quiha. Jatsi toa barí tsi cohuëcaxëcani quiha. Jatsi samacaxëcani quiha toatiyá no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jatsi joxëhai ca arati quinia paxa ca yoati tsi Jesu chaniniquë nëca cató no: —Jahuë sahuëti paxa ca quima quësi quëësayamahi quiha nohiria, jahuë sahuëtixëni pishpaxëna. Tocapiquí tsi jahuë sahuëti paxa ca yoshihuahi quiha. Jasca, tsocoxëhi quiha quësi, jaha bëquiyamahai quëshpi na. (Jascaria tsi noho tiisi paxa cató tsi mato arati jabi siri shomahuatimaxëni xo mato. Jaharisi ma xo.) ");
INSERT INTO caoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jasca, mato jabi ma xo toa bichi ca sota sirixëni qui jënëria paxa ca rëhuihaina. Anoma quiha. Ma rëhuipino tsi bichi ca sota poshaxëhi quiha naa jënëria paxa cato. Ja poshiquë tsi japaquëxëhi quiha naa jënë rë. Yoshihuahacaxëhi quiha bichi ca sota ri. ");
INSERT INTO caoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Jama, bichi ca sota paxa ca qui jënëria paxa ca rëhuihacaxëti xo. Toca tsi yoshihuahacayamaxëhi quiha sota. Jasca, japaquëyamaxëhi quiha jënë. (Jascaria tsi arati quinia huëtsá tsi noho tiisi paxa ca tiisimahacaxëti quiha. Mato arati jabi siri jaha bëquiyamahi quiha noho tiisi paxa cato ra.) ");
INSERT INTO caoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jama, noho tiisi paxa ca bicasyamaxo nohiria bo rë. Jato arati jabi siri bo noiyoicani quiha pë. “Oquë tsi xo noba arati jabi siri bo” icani quiha rë. Jato arati jabi rarinamacasyamacani quiha ra —nëa tsi Jesu nëcaniquë jahuë tiisi paxa ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Joiti barí tsi quiha jahuë rabëti bo ya huai bo nacohi Jesu iniquë. Nacopama tsi jahuë rabëti bá bimi bëro risaniquë. Risaxo tsi quiha jato mëquënë́ tsi ja huërocaniquë pixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jatsi quiha huësti huësti ca fariseobá Jesu nicaniquë: —¿Jënixo tsi yoba pasomaha ca acanai? Anoma tsi xo yonocohaina joiti barí no ra —i Jesu qui fariseobo rabëroha niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jatsi quiha Jesú jato quëbiniquë: —¿Quënëhacanish cabo ó ca David yamabá ani ca ma tsayayamayamani, naa Dios arati xobo qui ja jicoquë no? ");
INSERT INTO caoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jicoxo tsi quiha Dios bësojó ca janani ca mapari ja bini quiha pixëna. Piniquë quiha jahuë joni bo ri. Jabi arati ibo bá mapari ja picaniquë pa. Roa quiha. Jabi noba jabi pasomaha ja picanai ca iniquë ra; jama, ja jochayamacaniquë iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jascaria, jënima tsi xo toa no acaina iquia, joiti bari Ibo ë nori quëshpi na —nëa tsi fariseobo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Joiti bari huëtsá tsi quiha catiti xobo qui Jesu jiconiquë. Jicoxo tsi nohiria bo ja tiisimaniquë. Jabi toá tsi quiha tsaho iniquë mënëcayá ca mëquë choni jayanish ca joni. ");
INSERT INTO caoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jatsi quiha Jesu tsayatsi fariseobo, yoba tiisimacanaibo, tihi cabá huaniquë. Joiti barí pi Jesú joni jënimahuaxëhai ca ja jiscascani quiha, ja qui quësocatsi na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jama, ja shinacanai ca Jesú cahëni quiha. Jaha tsi mëquë choni jayanish ca joni qui ja chaniniquë: —Niihuë. Nëri johuë —iquiina. Jatsi joni joiniquë. Joihax toá tsi ja niiniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jatsi quiha fariseobo, yoba tiisimacanaibo, tihi cabo qui Jesu chaniniquë: —¿Yoi ni, jia ni, naa joiti barí tsi jia ca acaina? ¿Yoi ca axëhi ni noa? ¿Naa joni mëbixëhi ni noa? ¿Mëbiyamaxëhi ni noa? —i jato qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Bëro boho-bohoquí tsi quiha jato Jesú jisniquë. Jatsi, —Mi mëquë mëstëhuana —i joni qui ja niquë. Jahuë mëquë ja mëstëhuajahuaquë tsi quiha ja jënimahuahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jatsi quiha Jesu qui fariseobo, yoba tiisimacanaibo, tihi cabo caxarianiquë, joiti barí tsi toa joni ja jënimahuani iqui na. Jatsi chaninatsijacaniquë: —¿Jënahuariaxëhi ni noa sa Jesu qui? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Jaquirëquë quiha maca bo qui Jesu caniquë bëhoxhi na. Toa xo tsi quiha baquicha ja raaniquë Dios qui bëhoxquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Huëaquë tsi jahuë rabëti bo ja biniquë. Doce ca joni bo ja bihaca tsi jahuë chani chitahëhuati ibo bo jato ja manëmaniquë. Jabi ja bini ca tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simón, naa Pedro ja janëni cato. Pedro noma Andrés, Jacobo, Juan, Felipe, Bartolomé, ");
INSERT INTO caoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeo baquë Jacobo, gobierno pasomaha ca Simón, ");
INSERT INTO caoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jacobo baquë Judas, Judas Iscariote, naa jodioba chama bo qui Jesu mëanish cato. Tihi cabo Jesú bini quiha jahuë Chani chitahëhuati ibo bo iti. ");
INSERT INTO caoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Maca bo ax jahuë rabëti bo ya botëhax mai para ca ití tsi Jesu niiniquë chanixëna. Toá tsi quiha huëstima ca banahuacanaibo ini quiha jahuë chani nicaxëna. Misco quiha. Jodioba mai, Jerusalén, ia quëpë ca Tiro, Sidón yaca bo, tihi ca iti bo ax huëstima ca nohiria bëcani quiha jënimahuahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Jatsi jënimahuahacani quiha yoshi jayanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jasca, nohiria bá Jesu motsani quiha, ja quima jato jënimahuati chama tsëquëni iqui na. Jabi toca tsi jënimahuahacacani quiha ja motsacanai cató no. ");
INSERT INTO caoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jahuë rabëti bo bëis-hax tsi jato qui Jesu chaniniquë: —Shoma xo mato noitiria cabo, Diós otohai ca qui ma jicoxëhai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","‘Shoma xo mato paxnacanaibo. Sëyahuahacaxëqui mato. Shoma xo mato aracanaibo. Ranixëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","‘Ea tahëhax pi mato qui nohiria caxano tsi mato bëta pi ja rabënacasyamacano tsi shoma xo mato ra. Jasca, shoma xo mato, nohiria bá mato ocahuaquë no, ëa ma chahahuahai ca tahëxo na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Jabi ë bacano tsi raniriaxëqui mato, huëstima ca mato naipá ca copi jiaxëni cabo ma jayaxëhai quëshpi na. Toa barí tsi anomariaxëhi quiha mato copi ra. Jabi Dios Chani yoanish cabo tënëmahacani quiha jato ri, naa jaboqui ma yosihacahai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","‘Jama, noitiria xo toa jahuëmishni bo jayaria cabo. Nëá roha tsi ranicani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","‘Noitiria tsi xo toa jaboqui sëyacanaibo. Paxnacaxëcani quiha. ‘Noitiria tsi xo toa jaboqui shiracanaibo. Toa barí tsi araconacaxëcani quiha, cohuë iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","‘Noitiria xo mato, paraxo tsi jia tsi nohiria bá mato ocahuaquë no. Jabi toca tsi mato mahitsa ca Dios Chani yoanish cabo mato rëquëbo yamabá oquëhuani quiha jato ri. Jato qui jia jato mahitsa ca chani iniquë pë —nëa tsi Jesu nëcaniquë jahuë rabëti bo yobahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","‘Jabi ëa nicacanaibo qui naa yoba aquia: Mato qui caxacanaibo noicana. Jato mëbicana. ");
INSERT INTO caoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mato ocahuacanaibo shomahuacana. Mato ranimisxëni cabo bax bëhoxcana. ");
INSERT INTO caoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tsohuëcaracá pi mato tapaishano tsi ja qui mato tamo huëtsa acana tapaishahacati. Mato sahuëti pi joní bino tsi ja bëta iquinayamacana. Toa joni qui mi camisa ri acana. ");
INSERT INTO caoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Mato jahuë bo pi joní bënano tsi ja qui acana. Acax, “Jahari bicasquia ra” iyamacana jahari bixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Jia tsi nohiria huëtsa shomahuacana, naa mamë ma shomahuahacacatsai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","‘Jabi bëroria tsi xo mato noicanaibo noihaina. Iriama tsi xo toca ca ma noihaina iquia. Jabi jato noicanaibo noihi quiha chahahuayamacanaibo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Bëroria tsi xo mato mëbicanaibo ma mëbihaina. Iriama tsi xo toca ca ma mëbihaina ra. Toca tsi acani quiha chahahuayamacanaibo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Jabi bëroria tsi xo toa mato jahuë bo prestahuahacaina, mato qui nohiria bá parata aquë no. Tocacaqui chahahuayamacanaibo ri parata bixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tocayamacana. Jabi nëcacana: Mato qui caxacanaibo noicana. Jato mëbicana. Mato jahuë bo prestahuahacana, jahari jahuëcara biti ó pasoyamaquí na. ¿Jabi “Gracias” iyamacanaibo, yoixëni cabo, tihi ca nohiria bo mëbiyamayamahi ni Dios ra? Jato mëbihi quiha. Japi tocacana mato ri. Tocapiquí tsi copi jiaxëni ca bixëqui mato ra. Mana ca Dios baquë bo ixëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Jabi noi-noiriahi quiha mato Jahëpa Dios. Japi noicana, ja noihai ca jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","‘Huëtsa bo raniyamacana. Jatsi mato raniyamaxëhi quiha Dios ri. Huëtsa bo qui quësoyamacana, mahitsa. Quësoyamapimano tsi mato qui quësoyamaxëhi quiha Dios ri. Jasca pi nohiria mato pasomaha jochano tsi jato jocha shina-bënocana. Tocapimano tsi mato jocha shina-bënoxëhi quiha Dios ri. ");
INSERT INTO caoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Jasca, huëtsa bo qui acana. Huashiyamacana. Tocapimano tsi mato qui axëhi quiha Dios. Jatsi huëstimaria ca bixëqui mato. Ma acai ca huino quiha. Oquë ca ixëhi quiha. Jia pi nohiria huëtsa bo ma mëbino tsi mëbihacaxëqui mato ri. Jama jia pi huëtsa bo ma mëbiyamano tsi iriamaxëhi quiha ma shomahuahacahai ca ri. ");
INSERT INTO caoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jatsi chani Jesu jato qui yoaniquë: —¿Jënahuariaxo raca bëco ca joní, bëco ca joni huëtsa mëpina? ¿Naporo quini qui paquëyamayamacaxëcahi ni jato tëquëta? Jabi jasca xo mahitsa ca maestro bo ri. Janyama bocani quiha ra. Janyama mëpihacahi quiha jato alumna bo ri rë. ");
INSERT INTO caoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","¿Jënahuariaxo raca jato mahitsa ca maestro oquë tsi alumno bá cahëna? Jama, maestro jia cató pi jahuë alumno bo tiisima-tiisimano tsi ¿jaharisi iyamayamacaxëcahi ni? Jato maestro jascacaxëcani quiha jahuë alumno bo ra. ");
INSERT INTO caoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Jabi mabë xatë bá janyama ca acai ca tsayaxëni xo mato pë. Jato tsaya-tsayaquí tsi yoi ca ma acai ca jisyamaqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Anoma tsi xo toca ca ma acai ri. ¿Jëniriahax raca “Anoma xo mi acaina, ëbë xatë bá” i ma na? ¿Jëniriahax, “Mia ë mëbino ra” i ma na, oquë ca jocha ma aquë no mato ri pë? Jariapari mato shina ó ca jocha tsayaparicana, quiaxëni cabá. Mato oquë ca jocha niahax mabë xatë bo mëbiti mëtsa ixëqui mato ra, jahuë jocha niamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","‘Jabi bimi jia ca saihuatimaxëni tsi xo jihui yoi cato. Jascaria, bimi yoi saihuayamahi quiha jihui jia cato. ");
INSERT INTO caoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ja saihuacanai ca bimí tsi cahëhacahi quiha jatiroha ca jihui. ¿Jënahuariaxo bimi jia ca ronoxë́ saihuana? Bimi jia ca saihuatimaxëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jascaria, jabi jia ca saihuahi quiha joni jiaxëni cato. Jia tsi xo toa ja acaina, shina jia ca ja jaya ca iqui na. Jascaria, jabi yoi ca saihuahi quiha joni yoi cato. Anoma tsi xo toa ja acaina, shina yoi ca ja jaya ca iqui na. Jabi yoi ca jahuë bo pi jahuë shina rëamëno tsi chani yoi ca chanixëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","‘¿Jënihax tsi “Ibobá” ëa quënacanai pë, noho yoba ma ayamaquë no? ");
INSERT INTO caoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tobi ë qui bëcanaibo. Tobi ëa nicacanaibo, naa noho yoba acascanaibo. ");
INSERT INTO caoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Xobo rohahuahai ca joni iquiria ca xo. Jariapari tsi mai huëyohi quiha, maxax bërohuaxëna. Jatsi maxax cacha jahuë xobo rohahuahi quiha. Jatsi jënë baino tsi xobo qui tocaxqui jënë chama; mahitsa. Poxoyamahi quiha xobo, maxax cacha ja rohahuahacani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Jama, mai cacha xobo rohahuahai ca joni iquiria tsi xo noho yoba ayamahai cato. Noho yoba nicahax ja qui yoi quiha. Jabi jënë baino tsi ja qui tocaxqui jënë chama. Jatsi poxohi quiha xobo rë, maxax cacha ja rohahuahacayamani iqui na. Poxoyoxëhi quiha toa xobo ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jahuë chani jatihuahax tsi quiha jahari Jesu caniquë Capernaum yaca qui. ");
INSERT INTO caoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Toá tsi quiha romanoba capitán racaniquë, naa yonati jayanish cato. Jabi iquihi quiha jahuë yonati iniquë; rësopaimaria. Jabi jahuë yonati naa capitán noini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jatsi quiha Jesu yoati tsi capitán nicaniquë. Nicaxo tsi quiha jodioba yosibo rabëroha ca Jesu qui ja raaniquë, jahuë xobo qui joti nicamaxëna, jahuë baquë ja jënimahuano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jatsi quiha Jesu qui naa yosibo bocaniquë. Boxo tsi quiha Jesu ja nicacaniquë: —Capitán bax jahuë yonati mi jënimahuano ra, shinajiaxëni ca joni ja nori ca quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Jasca, noba jimibo noihi quiha naa joni ra. Noba catiti xobo ja aniquë no bax na ra —nëa tsi quiha Jesu qui jodioba yosibo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jaha tsi jato bëta Jesu caniquë. Jahuë xobo ja basimano tsi quiha jahuë rabëti bo capitán raaniquë chani ya. —Mimë huënahuayamana, Ibobá. Noho xobo qui mi jicoyamano, anoma ca joni ë nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ja tsi xo toa ë joyamahaina, noho jocha iqui na ra. Mi niihai cató pi mi chanino tsi jënimahuahacaxëhi quiha noho yonati ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jënima xo mi chani ra. Jabi ëa oquë ca chama bo nama xo ëa. Jato nicati cahëquia. Jasca, ëa nama xo soldado bo ri. Ea nicacani quiha jato ri. “Bocata” i pi ë no tsi bocani quiha. “Bëcahuë” i pi ë no tsi bëcani quiha. Jabi “Jënimahuë” i pi mi no tsi jënimaxëhi quiha noho yonati iquia —nëa tsi capitán raani ca chani nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jatsi quiha Jesu shina-risiquiniquë jahuë chani nicahax na. —Anomaria tsi xo naa joni ë qui chitimihaina ra. Jia tsi xo. Israél cabo chitimihai ca oquë quiha —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jesu jisbaya tsi jahari jato capitán xobo qui yosibo bocaniquë. Jënima quiha capitán yonati iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jisbëria tsi quiha yaca huëtsa, naa Naín icanai ca qui Jesu caniquë. Jasca, jahuë rabëti bo, nohiria misco, tihi cabo ja bëta bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jatsi yaca qui ja basimacano tsi quiha rësohax ca shinapayo ca joni yaca cacha nohiria bá bohi iniquë. Noitiria ini quiha jahuë jahëhua; bënë imanish ca quiha. Jasca, yama ini quiha jahuë baquë huëtsa rë. Jabi jahuë baquë maihuahi bocahi ja icani quiha. Jasca, ja bëta huëstima ca yacatá ca nohiria ini quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jatsi quiha Jesu cohuënaniquë yoxa jisi na. Jatsi, —Arayamahuë, caí —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jatsi quiha joni nanëhacani ca caja qui Jesu caniquë. Cahax caja ja motsaniquë. Jatsi niiniquë caja iahai ca joni bo. Jatsi, —Bësohuë, shinapayó —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jatsi quiha bësoyama ca joni tsahoniquë pa. Ja chanitapiniquë. Jatsi quiha jahuë jahëhua qui jahari baquë Jesú aniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ratëniquë nohiria tëquë. Jia tsi Dios ja ocahuacaniquë: —Noqui xërëquë tsi xo Dios Chani yoati Ibo-iboria ra. Jahuë nohiria yoi bo mëbicatsi quiha Dios ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Jabi toa barí tsi quiha Jesú ani ca huëstima ca nohiria bá nicaniquë. Nëama pacanani quiha toa chani. Jodioba mai, jato tëamë ca mai bo, tihi cabá tsi Jesú ani ca nicahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jabi Jesú ani ca jahuë bo yoati tsi ashimanish ca Juan rabëti bá nicaniquë. Nicaxo tsi quiha Juan ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jatsi quiha dos ca joni, naa jahuë rabëti bo Juán quënaniquë Jesu qui raaxëna. Jabi Xabahamati Ibo Jesu iqui ca ja cahëcasni quiha jaa ri, Jatsi, —“¿Johai ca Xabahamati Ibo ma ni mia? ¿Joni huëtsa ó pasoxëhi ni noa?” i Jesu qui cahuë —nëa tsi quiha Juan jato qui nëcaniquë. Jatsi quiha jahuë rabëti bo Juán raaniquë nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Jesu qui bëhax, —Noqui Juán raaquë. ¿Johai ca Xabahamati Ibo ni mia? ¿Joni huëtsa ó pasoxëhi ni noa? Cahëcatsi quiha Juan ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Jabi ja bëcaquë tsi quiha nohiria bo jënimahuahi Jesu iniquë. Huëstima ca nohiria jënimahuahacani quiha, naa iquicanaibo, yoshi jayanish cabo. Jasca, huëstima ca bëco cabo taismahacani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jatsi Juán raani ca joni bo Jesú quëbiniquë: —Jahari bocata. Ma tsayahana, ma nicahana, tihi cabo Juan yoacata. Taiscani quiha bëco cabo. Tapicani quiha huico choni jaya cabo. Pasohi quiha pasoyamacanaibo. Bësotëquëcani quiha bësoyama cabo. Jasca, xabahamati Chani nicacani quiha noitiria cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Jabi ranixëhi quiha ë qui chitimicanaibo ra —nëa tsi Jesu nëcaniquë Juan rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jatsi quiha Juán raani ca joni bá Jesu jisbërianiquë. Jisbëriajahuacaquë tsi quiha nohiria bo qui chanitsi Jesu niquë Juan yoati na. —¿Jahuë ó ma pasoni jisxëna, naa xabachá ca Juan qui ma bocaquë no? ¿Shinapayo cato, naa yoshiní tëtohuahacahai ca huasi jascaria ca joni ó ma pasoni? ");
INSERT INTO caoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Jahuë jisi ma bocani? ¿Copixëni ca raiti sahuëhaca joni jisti ó ma pasoni? Toca tsi ja iyamani quiha. Xobo-xoboriá tsi racacani quiha copixëni ca sahuëti jaya cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Mato nicaquia. ¿Jahuë ó ma pasoni jisxëna, ja qui cahi na? ¿Dios Chani yoati ibo ó ma pasoni? Jabi Dios Chani yoanish cabo oquë ca ma jisniquë iquia, naa Juan ma jisquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jabi nëca tsi ii quiha Dios Quënëhacanish cabo ó cato Juan yoati na: “Mia bëbo noho Chani bëhai ca raaxëquia. Mia bëbo mi quinia rohahuaxëhi quiha” ii quiha Dios Chani —nëa tsi nohiria bo qui Jesu nëcaniquë Juan yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jatsi quiha Jesu jari nëcaniquë Juan yoati na. —Yama tsi xo Juan oquë ca conish cato ra. Jama, Juan oquë ca tsi xo Diós otohai cato ó ca iriama cato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jabi Juan chani nicahi quiha nohiria tëquë. Jasca, nicahi quiha impuestos bicanaibo ri. Jabi naa nohiria bo tsi xo toa Dios quinia jia ca banahuacanish cabo. Ja tsi xo toa ja ashimahacacanina. ");
INSERT INTO caoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jama, Dios quinia jia ca fariseobo, yoba tiisimacanaibo, tihi cabá nianiquë pë. Jato qui yoi quiha. Ja ashimahacacasyamacani quiha —nëa tsi quiha Jesu nëcaniquë Juan yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jatsi Jesu nëcaniquë toa nohiria bo yoati na: —¿Jahuë jasca ni naa jaboqui bësocanai ca nohiria ra? ¿Jahuë quiri ni naa nohiria pë? ");
INSERT INTO caoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Plazá ca ihihai ca ranihuatimaxëni ca xocobo jascaria ca xo. “Bisto no ino” i pi huësti ca maxo no tsi “Pabëcasyama xo noa ra” ii quiha yosahai ca maxo huëtsa, cohuëcatsi na. Jama, “No nahuarino. No cohuëno” i pi jaca no tsi “Tsiricasqui noa” icani quiha pë. Jabi naa ranihuahacatimaxëni ca xocobo jascaria xo naa nohiria bo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jabi Juan joquë tsi jato qui yoi quiha jahuë jabi iniquë pë. Joxo tsi Juan samaniquë. Jënë ja ayamaniquë. Tocajano tsi “Yoshi jaya xo” iqui mato ja yoati na pë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Jatsi ë joniquë. Ea ti tsi xo oriquihaina. Ea ti tsi xo jënë acaina. Tocahëno tsi “Oriquití-naxëni, jënë́-naxëni tsi xo toa. Jasca, jochacanaibo ya rabënahi quiha pë” iqui mato pë ëa yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Jabi mato qui yoi xo noho jabi ë acaina. Jasca, mato qui yoi tsi xo Juan jabi ri. Jama, tiisiyoi-canaibo qui jia tsi xo noba jabi ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Huësti ca fariseobá quiha Jesu qui joi amaniquë ja bëta ja oriquino. Jatsi quiha jahuë xobo qui Jesu caniquë. Cahax ja tsahoniquë oriquixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Jabi toa yacatá tsi racani quiha jochahuaxëni ipaonish ca yoxa ri. Fariseoba xobó tsi oriquihi Jesu ini nori ca ja nicani quiha. Nicahax toa tsi quiha ja caniquë jisi na. Botiá ca copixëni ca perojome ja bëniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jicohax Jesu tahë tsi ja mëniniquë. Toá tsi quiha ja aracona-niquë. Jatsi jahuë bëho yaxo tsi quiha jahuë tahë bo ashimatsijahuaniquë. Jatsi jahuë boó tsi jahuë tahë ja shinahuaniquë. Shinahuaxo tsi quiha ja tatsoniquë. Jaquirëquë jahuë tahë qui perojome ja japaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jasca, yoxá ani ca fariseobá, naa Jesu qui joi amanish cató jisni quiha. Jisi tsi ja shinaniquë, “Jochahuaxëni ca naa yoxa nori ca cahëyamahi quiha tonia. Dios Chani yoati ibo yoi pi irohaquí tsi motsahai ca yoxa ja cahëquë aquë ra. Jochahuaxëni ca yoxa tsi xo naa” i ja niquë jamë no. ");
INSERT INTO caoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jatsi Jesú quëbiniquë: —Jahuëcara mia yoacasquia ra, Simón —iquiina. —Ihuë, Maestró —i Simón niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jatsi quiha ja qui chani Jesú yoaniquë: —Tobi quiha dos ca joni bo iniquë. Jato qui chamá parata prestahuahaniquë. Jariapari ca joni qui quinientos ca parata ja aniquë. Naa copixëni ca parata quiha. Jasca, joni huëtsa qui nama, naa cincuenta ca parata ja qui ja aniquë. Prestamo quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Jatsi quiha jahari toa parata ibo qui ati mëtsama ja icani quiha, naa dos ca joni bo rë. Noitiria ca joni bo quiha. Jatsi jato noiquí tsi quiha jato cuenta bo chamá nianiquë ra. Shinajiaxëni ca chama ja ini quiha. Jabi jato cuenta bo chamá niaquë tsi quiha ¿jëni ca joní oquë tsi jahuë chama noini? ¿Cuenta chahitaxëni ca jayanish ca ni? ¿Cuenta pistia ca jayanish ca ni? Ea yoahuë —nëa tsi quiha Simón qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—Tonia oquë tsi noiniquë cuenta chahitaxëni ca jayanish cato ra —i Simón niquë. —Oca xo ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jatsi yoxa quiri bësohax Simón qui Jesu chaniniquë: —Mi xobo qui ë jicoquë ra. Jënëpaxa ë qui mi ayamaquë rë, tachocohati; jama, jahuë bëho yaxo tsi noho tahë ja chocohaquë ra. Jaquirëquë jahuë boó tsi noho tahë ja shinahuaquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","E jicoquë tsi ëa mi joihuayamaquë rë, tatsohai cató no. Jama, naa yoxa tsayahuë. E jicoquë rohari tsi noho tahë huëstima tsi ja tatsoquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Noho boo qui xëni mi ayamaquë rë. Jama, noho tahë bo qui copixëni ca perojome ja japaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Jaha tsi masahacaquë jahuë huëstima ca jocha iquia ra, ja noiriaha ca quëshpi na. Jama, ichariama ca masaha ca jocha jaya ca tsi xo toa noiyamariahai cato ra —nëa tsi Simón qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jatsi quiha, —Masahacaquë mi jocha ra —i yoxa qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jatsi chaninatsi mesa tsahonish cabo niquë: —¿Tsohuëcara ni naa joni sa, naa jocha masahai cato? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jatsi quiha yoxa qui Jesu chaniniquë: —Mi xabahamahacaquë ra, mi chitimihai cató no. Bëpasi tsi cata —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jaquirëquë quiha yaca huëtsa, yaca huëtsa qui Jesu caniquë. Dios Chani yoahi ja caniquë Diós otohai ca yoati na. Jasca, ja bëta bocaniquë doce ca banahuacanaibo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Bocaniquë ichariama ca yoxa bo ri, naa ja jënimahuani ca yoxa bo. Jasca, caniquë María Magdalena, naa siete ca yoshi jayanish cato. ");
INSERT INTO caoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jasca, jato bëta caniquë Juana, Chuza ahuini, naa Herodes empleado. Bocaniquë Susana, yoxa huëtsa bo ri. Jabi Jesu, jahuë rabëti bo, tihi cabo naa yoxa bá orihuapaoni quiha jato parata yoí no. ");
INSERT INTO caoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Toatiyá tsi Jesu qui huëstima ca nohiria bëcaniquë. Huëstima ca yaca bo ax ja bëcani quiha jahuë chani nicaxëna. Jatsi bëroria ca chani Jesu jato qui yoaniquë jato tiisimaxëna. Ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Bëro sayahi quiha joni caniquë. Bëro sayajahuano tsi quiha huësti huësti ca bëro bahi tapaí xapaquëniquë. Jahá tsi ja jamahacani quiha. Jasca, jahá ca bëro isa bá piniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Jasca, bëro huëtsa maxax mai qui xapaquëniquë. Jabi shinahacax ja chonini quiha jënë yama pi ja ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Jatsi bëro huëtsa masa xërëquë tsi xapaquëniquë. Bëro ya shinahabëquiniquë quiha toa masara pë. Jatsi banahaca ca mapahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Jatsi bëro huëtsa mai jiaxëni ca qui sayahacaniquë. Shinahaxo tsi huëstima ca bimi ja saihuaniquë. Tihiria ca bimi saini quiha —nëa tsi Jesu nëcaniquë nohiria bo qui. Chanipama tsi, —Ea nicati xo jatiroha cabo ra —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jabi Jesú yoani ca chani jahuë rabëti bá cahëyamaniquë. Ja quëshpi tsi, —¿Jënihi ni naa noqui mi yoahana sa? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jatsi quiha Jesú quëbiniquë: —Mato qui tiisi acacaniquë, naa Diós otohai ca yoati na. Jonë ca jahuë bo ma cahëxëti xo. Jama, naa jonë ca jahuë bo cahëyamaxëhi quiha tëxë bo. Ja tsi xo toa nëca ca chani jato qui chaniquia, nicaxo ja cahëyamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jatsi quiha jahuë chani Jesú bërohuaniquë: —Jabi Dios Chani tsi xo toa sayahaca ca bëro. ");
INSERT INTO caoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Toa bahi tapaí cabo tsi xo toa Dios Chani nicahai ca nohiria bo. Chani ja nicacano tsi johi quiha Satanás. Joxo tsi jato shina ó ca chani tsëcahi quiha rë, ja chahahuayamacano xabahamahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Jabi maxax mai qui sayahaca ca bëro jascaria tsi xo nohiria huëtsa. Ranixo tsi Dios Chani biriacani quiha nicaxo na. Jama, jato shina ó tsi tapoyamahi quiha Dios Chani rë. Naamayamahi quiha ja chahahuacanaina rë. Dios Chani tahëhax pi tënëmahacaquí tsi Dios Chani niacani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Jabi masa xërëquë sayahaca ca bëro jascaria tsi xo nohiria huëtsa. Dios Chani nicacaquë jato ri. Jama, Dios quima jato ninihi quiha maí ca jahuë bo. Toa jahuë bo shina-shinacani quiha pë. Jatsi Dios Chani tsiihaqui quiha toa parata ó ja quëëcanaina. Jasca, tsiihaqui quiha toa jato ranihuahai ca jahuë bo pë. Ja quëshpi tsi jato shina ó ca tsi anitimaxëni tsi xo Dios Chani rë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jama, mai jiaxëni sayahaca ca bëro jascaria xo nohiria huëtsa. Dios Chani nicacanaibo tsi xo naa. Nicahax jato qui jia quiha jahuë Chani ra. Chahahuacani quiha ra. Chahahuaxo tsi anomaria tsi xo toa Dios bax ja acanaina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","¿Caca nama, oxati nama jahuë lamparina janahi ni ibo pa, tsamaxo na? Tocayamahi quiha. Bëroria tsi janahi quiha, naquëtë ja huëano jicocanaibo bax na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Jascaria tsi bërohuahacaxëti xo nohiria bo qui yoahama ca tëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Jatsi quiniacaxëcahuë. Jia tsi Dios Chani nicatsacana. Jia pi ma nicano tsi anixëhi quiha mato tiisi. Jama, ja bichi ca tiisi pistia bënoxëhi quiha nicacasyamacanaibo —nëa tsi quiha Jesu nëcaniquë jahuë chani bërohuahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jabi jahuë jahëhua, jahuë noma bo, tihi cabo Jesu qui bëcaniquë. Jama, ja qui basimatimaxëni quiha ja icaniquë ja qui quëtsoni ca nohiria bo iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Jatsi quiha Jesu qui nohiria bo chaniniquë: —Bëcaquë mi ihua, mi noma bo ra. Xobo cacha niicani quiha. Mia jiscascani quiha —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jatsi quiha Jesú quëbiniquë: —Noho jahëhua yoi, noho noma yoi bo, tihi cabo tsi xo toa Dios Chani nicacanaibo. Tihi cabo tsi xo toa jahuë yoba acanaibo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Toatiyá tsi quiha noti qui Jesu jiconiquë jahuë rabëti bo ya. Jicohax, —¿Ia rabëquëx ca qui canomani? —i jato qui ja niquë. Jatsi shitatsijacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Shitajacano tsi quiha notí tsi oxa Jesu iniquë. Jatsi ianë́ tsi cosporiatsi yoshi niquë. Jato noti rëamëtsi quiha jënë iniquë rë. Jëtëquëpaimaria jato noti ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jatsi Jesu bësomahi ja bocaniquë. —Jisa Maestró. Jëtëquëpaima xo noa ra —i jaca niquë. Jatsi quiha Jesu joiniquë. Joixo tsi quiha yoshini, choca, tihi cabo ja raahaniquë. Jatsi quiha janacaniquë yoshini. Pasiniquë ia ri. ");
INSERT INTO caoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jatsi Jesú jato nicaniquë: —¿Yama ni ë qui ma chitimihaina ra? —iquiina. Raquëhax, —¿Tsohuë cara ni naa sa? Ja qui nicahi quiha yoshini, choca pa —i jaca niquë. Jatsi ja ratëyocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Galilea mai jisbaya tsi quiha ia rabëquëx ca qui ja shitacaniquë Gadara icanai ca mai qui. ");
INSERT INTO caoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Rërëhax Jesu tëmahinaniquë. Toa xo tsi quiha yoshi jaya cató jato bëchaniquë. Tsoboco ja ini quiha. Siri tsi sahuëti ja sahuëyamani quiha. Jasca, jahuë xobó tsi ja racayamani quiha, rësonish caba maí tsi ja chitëcasni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jatsi Jesu tsayahax ja sainiquë. Saihax ja bësojó tsi ja mëniniquë. Jatsi, —Ea huënahuayamahuë Jesú, mana ca Dios Baquë́. Ea tënëmayamahuë iquia —i Jesu qui joni niquë joi pistiamá no. ");
INSERT INTO caoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jabi nëca tsi quiha ja chaniniquë, “Ja quima tsëquëcahuë” i yoshi bo qui Jesu ni nori quëshpi na. Jabi huëstima tsi quiha yoshi bá naa joni qui tsaminiquë rë. Jatsi jahuë yoshi iqui tsi quiha nohiria bá jahuë mëquë bo, jahuë tahë bo, tihi cabo nëxapaoni quiha mëchichó no, ja paxayamano iquish na. Jama, mëchicho ja tësapaoni quiha. Jasca, xabaca, nihi, tihi cabo qui ja jabapaoni quiha yoshi iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jatsi quiha, —¿Jahuë ni mi janë ra? —i toa joni qui Jesu niquë. —Seis Mil —i quiha joni niquë, huëstima ca yoshi ja qui jiconi nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jatsi yoshi bá Jesu bënarianiquë, tënëtiya qui jato ja raayamano. ");
INSERT INTO caoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Jabi basima xo tsi quiha yahua jinaya cabá pihi iniquë. Yahua tirixëni quiha. Jatsi quiha, —Japa toa yahua jinaya cabo qui noqui raatsana. Jato qui no jicono ra —iriatsi jaca niquë Jesu qui. Jatsi, —Bocata —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jatsi quiha joni quima ax ja natsëquë-caniquë. Natsëquëhax yahua qui ja jicocaniquë. Jatsi quiha jabatsi yahua tirixëni niquë. Maca ax rënichihax ia qui ja jabayocaniquë. Ja nëachiyocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Jatsi yahua obëso cabo jabaniquë yaca qui. Jënipijani ca ja yoabonacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Jatsi nohiria bocaniquë ocapijani ca jisi na. Jesu qui ja bëcaniquë. Toá tsi quiha yoshi jayanish ca joni ja jiscaniquë. Jesu tapaí tsaho ja ini quiha. Sahuëti sahuë ja ini quiha. Jënima ja ini quiha. Jatsi ja raquëyocaniquë tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jatsi yoyoxëni ca joni jënimahuahacani nori ca quinia jisnish cabá yoaniquë bëcanish cabo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jatsi pë Jesu bënatsi quiha Gadara maí ca nohiria tëquëtá huaniquë jato ja jisbayano. Ja raquëyocani quiha. Jatsi noti qui ja jicohaca tsi quiha Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jabi yoshi jayanish ca joni Jesu ya cacasniquë jaa ri, —Mi bëta cacasquia —iquiina. Jama, jahari jahuë xobo qui Jesú raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Mi xobo qui cata. Mi bax Diós aca ca yoata —i ja qui Jesu niquë. Jisbaya tsi quiha toa yacata xo tsi ja bax Jesú ani ca ja yoabonaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ia rabëquëx ca ax Jesu bacaquë tsi quiha rani tsi nohiria bá joihuaniquë, ja manacanai ca quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jatsi quiha catiti xobo chama joniquë, naa Jairo icanai cato. Jesu tahë tsi ja mënihaca tsi, —Noho xobo qui johuë ra —iriatsi ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Jabi rësopaimaria quiha jahuë jahi iniquë rë. Doce ca año bo jayani quiha. Jatsi ja bëta Jesu caniquë. Ja cano tsi quiha ja qui nohiria quëtsojahuacaniquë. Huëstima ca nohiria quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Jabi nohiria xërëquë tsi quiha jimihacai ca yoxa iniquë. Doce ca año no tsi ini quiha ja jimihanina rë. Jasca, jahuë parata tëquë doctor bo qui ja mëani quiha jënimahuahacaxëna. Jënimahuahacatimaxëni ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jabi Jesu cho quiha naa yoxa basimaniquë. Basimaxo tsi quiha jahuë sahuëti quëpë ja motsaniquë. Jatsi jënëtapiniquë ja jimihacaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jatsi quiha, —¿Tsohuë ëa motsaha? —i Jesu niquë. —Yama tsi xo toa mia motsahaina ra —i quiha nohiria bo niquë. Jatsi pasi quiha nohiria bo iniquë. Jatsi, —Tsayahuë. Mi qui quëtsocani quiha nohiria bo ra, Maestró. Mia tijihacani quiha. ¿Jënahuariahax “¿Tsohuë ëa motsaha?” i mi na ra? —i Jesu qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jatsi Jesú quëbiniquë: —Ea motsayaquë nohiria iquia. E quima ax noho chama tsëquëquë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jatsi mëmëriatsi quiha yoxa niquë. —Cahëhi quiha rë —i jamë ja niquë. Jatsi Jesu qui johax tsi quiha ja bësojó yoxa mëniniquë. Mënixo tsi nohiria bo bësojo xo tsi ja ani ca ja yoaniquë. —Mia ë motsaquë jënimahuahacaxëna ra. E jënimahuahacatapiquë ra —i Jesu qui yoxa niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jatsi, —Mi jënimahuahacaquë caí, mi chitimiha ca quëshpi na. Bëpasi cata —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Chanijano tsi quiha chama Jairo xobo ax chani bëhai ca cahëniquë. Cahëhax, —Rësoquë mi jahi pistia rë. Maestro jari huënahuayamahuë —i Jairo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jama, nicahax Jesu chaniniquë: —Raquëyamatsina. E qui mi chitimiti xo. Jënimaxëhi quiha mi jahini ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jatsi xobo qui ja cahëniquë. Cahëhax, —Nohiria ë bëta jicoyamano —i ja niquë. Jatsi quiha Pedro, Juan, Jacobo, jahini jahëpa, jahuë jahëhua, tihi cabo roha Jesu ya jiconiquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Jahi tahëhax tsi araconahi nohiria tëquë ini quiha. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","—Arayamacana. Bëso xo ra. Oxa roha —i jato qui Jesu niquë. Jatsi quiha nohiria bá osaniquë, ja rësoni nori ja cahëcani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jatsi xotaco mëquë Jesú biniquë. Bichi tsi, —Bësohuë, caí —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jatsi ja bësotëquëniquë. Ja niitapiniquë. Jatsi quiha, —Pimahuë —i jahuë nabo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ratëniquë jahuë nabo, rani-ranihi na. Jatsi, —Jënipijaha ca yoayamacana —i jahuë nabo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesú jahuë doce ca rabëti bo quënaniquë ja caticano. Quënaxo tsi quiha chama jato qui ja aniquë yoshi bo tsëcati, noitiria cabo jënimahuati. ");
INSERT INTO caoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jatsi quiha jato ja raaniquë Diós otohai ca chani ja yoacano, isicanaibo, iquicanaibo, tihi cabo ja jënimahuacano. ");
INSERT INTO caoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yobapama tsi Jesu nëcaniquë: —Mëquëya bocana. Coti jihui, sota, oriquiti, parata, tihi cabo boyamacana. Rabë ca sahuëti boyamacana; huësti ca roha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tsohuëcaracá xobo qui jicohax toá tsi chitëcana. Chitëquí tsi xobo rarinayamacana. ");
INSERT INTO caoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jasca nohiria bá pi mato joihuayamano tsi toa yaca jisbayacana. Jisbaya tsi mato tahë́ ca cospo totohacahuë jato jocha jismaxëna. Toca tsi jato qui Dios caxa ma jismati xo —i quiha jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jatsi quiha ja bocaniquë. Yaca bo ja nacocani quiha, Dios Chani yoahi na. Jasca, jatiroha ca iti xo tsi quiha noitiria cabo ja jënimahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jatsi quiha chama Herodés nicaniquë jatiroha ca Jesú ani ca yoati na. Nicahax ja shina-risiquiniquë. Shinati pi ja cahëyamani quiha “Bëso xo Juan yamabo ra” i nohiria bo ni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jasca, —Elías yamabo tsi xo naa jisiquihaina tonia —i huëtsa bo niquë. —Bësotëquëquë Dios Chani yoanish ca huësti cato —i quiha huëtsa bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jatsi Herodes nëcaniquë: —Juan mapo ë quëësayamëquë ra. ¿Tsohuëcara ni naa joni sa? Anomaria tsi xo toa nohiria bo chanihai ca ja yoati na —iquiina. Nohiria bo iqui tsi Herodés Jesu jiscasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jatsi quiha Jesu rabëti bo bacaniquë. Bacaxo tsi quiha ja acani ca tëquë Jesu ja yoacaniquë. Jaquirëquë jahuë rabëti bo Jesú boniquë Betsaida yaca quiri. Jato bëta ja icasni quiha jamëpistiá no. ");
INSERT INTO caoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jabi ja bocaquë tsi quiha nohiria bá nicaniquë. Nicaxo tsi quiha ja banahuacaniquë jato ri. Jatsi nohiria Jesú joihuaniquë. Joihuaxo tsi quiha Diós otohai ca yoati jato ja yoaniquë. Jasca, noitiria cabo ja jënimahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jaquirëquë yata tsi quiha ja qui jahuë rabëti bo bëcaniquë. Caquë quiha bari. Bëhax tsi jahuë rabëti bo ja qui chaniniquë: —Basima ca yaca bo, huai bo, tihi cabo qui nohiria raatsana. Oxati bo, piti, tihi cabo ja bicano ra. Yama tsi xo nëá ca racati ra —i Jesu qui jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jatsi quiha, —Jato pimacana —i jato qui Jesu niquë pa. Jatsi, —Yama tsi xo nëá ca piti ra. Cinco ca mapari, dos ca sanino, jaroha tsi xo rë. ¿Naa nohiria tëquë bax mapari copihi caxëhi ni noa pa? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Jabi toá tsi quiha cinco mil ca joni bo mani ini quiha. Huëstima quiha. Jatsi, —Maxo cincuenta, maxo cincuenta, nëca tsi nohiria tsahomatsacana —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jatsi toca tsi ja acaniquë. Nohiria tëquë ja tsahomacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jaquirëquë cinco ca mapari, dos ca sanino, tihi cabo Jesú biniquë. Bixo tsi quiha mana nai qui tsayahax tsi “Gracias” Dios qui i ja niquë piti quëshpi na. Jatsi mapari ja tëxënamaniquë. Tëxënamaxo tsi jahuë rabëti bo qui ja aniquë nohiria bo qui ja taacano. ");
INSERT INTO caoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Piniquë nohiria tëquëta. Ja sëyayocaniquë. Jaquirëquë mapari quësi bo, sanino, naa pihama ca quësi bo ja catiacaniquë ra. Doce ca caca ja rëacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Xaba huëtsá tsi Jesu bëhoxno tsi quiha ja bëta jahuë rabëti bo iniquë. Jatsi jato ja nicaniquë: —¿Tsohuë ni ëa? ¿Jënihi ni nohiria bo ëa yoati na? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Jatsi jahuë rabëti bá quëbiniquë: —“Ashimanish ca Juan yamabo përë xo mia” ii quiha huëstima cabo. “Elías yamabo” ii quiha huëtsa bo. Jasca, “Dios Chani yoanish cabo ó ca huësti cato, naa rësonish cabo quima ax tëronoyamëtax cato” ii quiha tëxë bo —nëa tsi Jesu qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jatsi jato ja nicaniquë: —¿Japa mato tsa ni? ¿Tsohuë ë nori ca icanai? —i Jesu niquë. Jatsi quiha, —Dios raahacanish ca Xabahamati Ibo xo mia ra —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jatsi jahuë rabëti bo Jesú yobaniquë, tsohuë ja iqui ca ja yoayamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yobapama tsi ja nëcaniquë: —Tënë-tënëxëquia naa Nohiria Baquë ë nori cato ra. Jasca, ëa niacaxëcani quiha yosibo, arati ibo-iboria bo, Dios yoba tiisimacanaibo rë. Tihi cabá ëa namëcaxëcani quiha. Jama, tres bari huinocaquë tsi bësotëquëxëquia ra —i jahuë rabëti bo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jaquirëquë Jesu nëcaniquë: —Ea pi banahuacasquí tsi ma acatsai ca ma shinayamaxëti xo. Jatiroha ca barí tsi mato cruz ma iano ra. Iaxo ëa ma banahuano. ");
INSERT INTO caoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jabi xabahamahacayamaxëhi quiha toa jahuë noma jabi ó quëëmisxëni cato. Jama, xabahamahacaxëhi quiha jahuë noma jabi chihohuahai cato ëa tahëxo na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Jatsi jatiroha ca maí ca jahuë bo joní bëbomitsa, ricoria ca iquiina. Jama tënëtiya qui pi caquí tsi ¿jahuëcara ca ja bëbona? ");
INSERT INTO caoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jasca pi ëa, noho chani, tihi cabo qui jaboqui nohiria bërabino tsi jato qui bërabixëquia ëa ri, xaba huëtsa ë joxëquë no. Toa barí tsi Rey jascaria tsi, naa noho ángel bo ya tsi joxëquia ra, noho jahëpa chamá no. ");
INSERT INTO caoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mato parayamaquia, “Diós otohai ca oquë jisxëqui mato ichariama cabo” iquia. Rësonox pari tsi ja otohai ca oquë jiscaxëcani quiha —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nëca tsi chanixo tsi Pedro, Jacobo, Juan, tihi cabo maca qui Jesu boniquë oquëri ca semaná no. Jaha tsi Dios qui ja bëhoxcasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dios qui bëhoxjano tsi quiha jahuë bëmana jaria jabitiniquë. Jasca, joxonaria-niquë jahuë sahuëti. ");
INSERT INTO caoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jatsi jisiquitapiniquë rabë ca joni bo. Ja bëta chanihi ja icani quiha. Moisés yamabo, Elías yamabo, tihi cabo jisiquini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Jabi mana ca oquë ca ja jayacani quiha jato ri. Anomaria jato jaria ini quiha. Jabi chaninahi ja icaniquë, naa Jerusalén tsi Jesu nahai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jabi coshi ini quiha Pedro, Jacobo, Juan, tihi caba bëro. Jatsi ja bësocaniquë. Bësoxo tsi quiha Jesu, ja bëta rabë ca niihai ca joni bo, tihi cabo ja jiscaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Jatsi nai qui Moisés yamabo, Elías yamabo, tihi cabá jisbayano tsi Pedro chaniniquë: —Noqui jia tsi xo nëá no iquiina. Tres ca tapas no ano ra. Huësti mí-na, huësti Moisés yamabá-na, huësti Elías yamabá-na —i ja ni quiha. Jabi toca tsi Pedro chaniniquë, ratëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Jari chanijano tsi quiha tsëmo joniquë. Joxo tsi jato ja mapaniquë. Jatsi tsëmo qui Moisés yamabo, Elías yamabo, tihi cabo jicoquë tsi quiha ja raquëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Jatsi tsëmó ca joi ja nicacaniquë: —Noho Baquë tsi xo naa. E bini ca tsi xo naa noho yonoco ati. Ja qui nicatsacana —i joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jatsi joi pasiquë tsi quiha toá tsi Jesu iniquë. Jamëpistia quiha. Toatiyá tsi ja jiscani ca jahuë bo jahuë rabëti bá yoayamani quiha. Ja bëpacani quiha jënipijani ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Maca quima ax botëxo tsi quiha nohiria huëstima ca ja bëchacaniquë huëaquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jatsi nohiria xërëquë ó ca joní Jesu quënaniquë: —Anoma tsi xo noho baquë ra, Maestró. Noho baquë yoi ra. Tsayapa. ");
INSERT INTO caoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Noho baquë qui yoshini tsamihaca tsi sai-saihitapihi quiha noho baquë rë. Jatsi noho baquë caxo amahi quiha. Jatsi bacoxhi quiha rë. Natohuahi quiha. Natohuaxo tsi jisbayahi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Jasca, “Noho baquë ó ca yoshi tsëcacahuë” i mi rabëti bo qui ë quë. Tsëcatimaxëni ca xo rë —nëa tsi Jesu qui joni nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jatsi Jesú quëbiniquë: —Chitimitimaxëni ca yosaxëni ca nohiria xo mato pë. ¿Jahuë tihi tsi mato tënëxëhi ni ëa pë? Mi baquë nëri bëhuë —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jatsi baquë basimano tsi yoshiní mai qui baquë nianiquë. Caxo ja amahacani quiha. Jatsi yoshi Jesú raahaniquë. Raahaxo tsi quiha ja jënimahuaniquë. Jaquirëquë jahuë jahëpa qui jahari ja aniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jatsi Dios chama-chamaria qui nohiria tëquë ratëyoniquë tsayahax na. Jari Jesú ani ca yoati tsi nohiria chaninano tsi quiha jahuë rabëti bo qui Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Jia tsi ëa nicacana, ma shina-bënoyamano iquish na. Nohiria caxaxëniria cabo qui ë mëahacaxëti xo —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jama, Jesú yoani nori ca ja cahëyamacani quiha. Jato joma quiha. Jari jato qui jonë ini quiha ja yoanina. Jama, Jesu ja nicayama-caniquë ja yoaha ca ja bërohuano, raquëquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jatsi chaninatsi Jesu rabëti bo niquë, tsohuë jato oquë ca ixëti iqui ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jabi ja chaninacanai nori ca Jesú cahëni quiha. Cahëxo tsi quiha baquë pistia ja biniquë. Bixo tsi ja tapaí ja nimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nimahax, —Ea joihuahi quiha tsohuëcara ca noho janë́ tsi naa baquë pistia joihuahai cato. Jasca, ëa raanish ca ri joihuahi quiha ëa joihuahai cato. Nicaparicana. Oquë-oquëriaxëhi quiha mato xërëquë ó ca iriama cato ra, naa baquë pistia jasca cato —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jatsi Juan chaniniquë: —Jisa, Maestró. Mi janë́ tsi yoshi tsëcahai ca joni no tsayahitaquë ra. Tsayaxo toa joni no jënëmacas-hitaquë noba maxo quirim ja iqui iqui na —i Jesu qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jatsi Jesú quëbiniquë: —Jënëmayamacana. Noba rabëti tsi xo toa noqui pasomahama cato ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jabi basima quiha nai qui Jesu tërohacati xaba iniquë. Toatiyá tsi raquëhaxma tsi Jerusalén qui ja cacasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Jatsi rëquë tsi joni bo ja raaniquë jahuë quinia ja rohahuacano. Jatsi, Samariá ca yaca qui ja jicocaniquë, chitëti iti Jesu bax mëraxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jama, jato yaca qui Jesu cahëquë tsi quiha samariabá jato chitëmacasyamani quiha, Jerusalén qui ja bocanai ca ja jiscani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jatsi samariabo qui Jacobo, Juan, tihi cabo caxaniquë. Caxahax, —¿Naipá ca chihi baaxëhi ni noa, Ibobá, jato mëshati, naa Elías yamabá ani jascaria? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jatsi Juan, Jacobo, tihi cabo quiri bësoxo tsi quiha Jesú jato raahaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Jatsi yaca huëtsa qui ja bocaniquë chitëxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Bahí tsi bohocanajacano tsi, —Jahuëniacara qui mi caxëhai ca mia banahuaxëquia —i huësti ca joni Jesu qui niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jatsi Jesú quëbiniquë: —Jato quini bo jaya xo tsaca bo. Jasca, naha jaya xo isa bo. Jama, ëa, naa mana ax johax ca tsi xo toa racati xobo yama cato —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jatsi joni huëtsa qui Jesu chaniniquë: —Ea banahuahuë —iquiina. Jama, —Mi bëta cacasquia ra. Jama, jaboqui canoma xo ëa ra. Rësopaimaria xo noho jahëpa. E maihuaparixëti xo —i joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jatsi Jesú quëbiniquë: —Jato nabo Dios chahahuayamacanaibá maihuano. Mi yonoco tsi xo toa Dios Chani yoahi cati, naa Diós otohai ca yoati na —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Jatsi, —Mi bëta caxëquia, Taitá. Huënayamaxëhuë. Jahari noho xobó cabo qui ë caapariti xo jato joihuaxëna —i joni huëtsa niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jama, ja qui Jesu chaniniquë: —Noho yonoco pi chitahëhuaquí tsi jahari mi jahuë bo qui mi bacayamano. Ibo Dios bax yonocoyoiti mëtsama xo toa jahari bacacatsai cato ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jaquirëquë setenta ca joni bo Ibo Jesú biniquë. Bixo tsi quiha rëquë tsi dos, dos, dos tsi jato ja raaniquë ja shishocatsai ca yaca tëquë qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Raapama tsi ja nëcaniquë: —Huëstima tsi xo toa tësahacati cato ra, ichariama yonococanaibo nori. Ja quëshpi tsi Ibo Dios nicacana, yonati bo ja raano ja bax yonocoti. ");
INSERT INTO caoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jatsi, bocata. Mato raaquia. Cama xërëquë ó ca oveja xocobo jascaria ixëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Jatsi parata, sahuëti, zapato bo, tihi cabo boyamacana. Jasca, bahí tsi bamayamacana, nohiria joihuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jasca, xobo qui jiconox pari tsi “Dios mato shomahuano” icana ibo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Jabi toá pi rabënacatsai ca joni racano tsi toá tsi chitëxëhi quiha ma shomahuahaina. Jama, xobo ibo pi rabënacasyamano tsi ma joihuahai ca jahari bicana. ");
INSERT INTO caoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Jasca, xobo qui jicohax xobo rarinayamacana. Huësti ca ití tsi chitëcana. Toa xo tsi ma taahacahai ca jahuë bo picana. Jabi jahuë yonoco quëshpi tsi orihuahacaxëti xo yonati. ");
INSERT INTO caoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jabi yacatá ca nohiria bá mato joihuano tsi mato qui ja taacanai ca jahuë bo picana ra. ");
INSERT INTO caoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Jasca, toá ca iquicanaibo jënimahuacana. Jënimahuahax, “Mato basima tsi xo Diós otohaina” icana jato qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","‘Jama, yacatá ca nohiria bá pi mato joihuayamano tsi jato calle bo qui bocata. ");
INSERT INTO caoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Toá tsi “Mato yacatá ca cospo jaya xo noba tahë bo pë. Bicasyama xo noa. Bita” i jato qui cana. Jasca, “Mato parayamaqui noa. Jaboqui mato qui basimaria Diós otohai ca joquë ra” i jato qui cana. ");
INSERT INTO caoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Parayamaquia. Copiti barí tsi anomariaxëhi quiha naa yacatá ca nohiria copi ra; naa jochahuaxëni ca Sodoma yaca oquë ja iti quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","‘Noitiriaxëhi quiha mato Corazín cabá. Noitiriaxëhi quiha mato ri, Betsaidá cabá. Mato yaca bo xo tsi huëstima ca jisti bo acacani quiha; mahitsa rë. Jabi jochahuaxëni ca Tiro y Sidón yaca bo xo tsi jasca ca jisti bo acacarohapino tsi naama tsi jato jocha quima Dios quiri ja bësoquë acaniquë ra. Bamaxoma tsi moro ja sahuëquë acaniquë cohuëquí na. Jasca, chihi mishpó tsi ja tsahoquë acaniquë, jato cohuë jismaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nicaparicana. Copiti barí tsi anomariaxëhi quiha mato copi ra; Tiro y Sidón yacatá ca jochahuaxëni ca nohiria oquë ja iti quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","¿Japa mato Capernaum yacatá cabá? ¿Nai qui bocascanai pa? Maj. Tënëtiya qui botëxëqui mato iquia —nëa tsi Jesu nëcaniquë jochahuaxëni ca yaca bo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jatsi Jesú jahuë rabëti bo yobaniquë: —Ea nicayoihi quiha mato chani nicacanaibo. Jasca, ëa niahi quiha mato chani nicacasyamacanaibo. Jasca, ëa raanish ca niahi quiha ëa bicasyamacanaibo —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jatsi rani tsi setenta ca raahacanish cabo bacaniquë. —Noqui nicahi quiha yoshi bo pa, Ibobá, naa mi janë́ tsi jato qui no chaniquë no —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jatsi Jesu jato qui chaniniquë: —Dios Chani ma yoaquë tsi Satanás jahuë chama bënohai ca ë jisitaquë ra. Ja bëbohacahitaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Jabi chama mato qui aquia noqui pasomaha cato chama bëboxëna. Rono, nibo, tihi cabo xërëquë tsi coti mëtsaxëqui mato. Mato ayamacaxëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Jasca, yoshi ma natsëcahai ca iqui tsi ranixëqui mato. Jama, oquë tsi ma ranixëti xo, naipá ca libro ó tsi mato janë bo quënëhacani iqui na —nëa tsi Jesu nëcaniquë jahuë bëcanish ca rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Espíritu Santó tsi Jesu rani-ranitapiniquë. Ranihax ja chaniniquë: —Oquë-oquëria ca xo mia ra, Jahëpá. Mia tsi xo naipa, mai, tihi cabo yonati Ibo-iboria. Mi qui “Gracias” iquia, tiisi jayamacabo qui mi Chani jia ca mi jisiquimahai quëshpi na. Jia tsi xo ra. Jasca, maí ca tiisi jaya cabo quima mi tiisi-tiisiria jonëmahacaquë ra, ja cahëyamacano iquish na. Jabi toca tsi mi acai ca quëshpi tsi “Gracias” mi qui iquia, Jahëpá. ");
INSERT INTO caoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jasca, nicaparicana, joni bá. Chama ë qui noho Jahëpá aniquë, jahuë bo tëquë yonati. Jabi yama tsi xo toa ëa, naa Dios Baquë-baquëria cahëyoihaina. Noho Jahëpa roha tsi xo toa ëa cahëyoihai cato. Jasca, yama tsi xo Jahëpa Dios cahëxëni cato. Jahëpa Dios cahëxëni ca roha ca ëa xo naa, naa jahuë baquë yoi. Jasca, Jahëpa Dios cahëcani quiha chahahuacanaibo ri, naa ë quënani cabo. Jato qui noho jahëpa jisiquimaquia ja cahëcano iquish na —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jatsi jahuë rabëti bo quiri Jesu bësoniquë. Bësohax jato qui ja chaniniquë: —Shoma xo mato ra. Jia tsi xo ma jisina. ");
INSERT INTO caoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Jabi ë acai ca jahuë bo huëstima cabá jiscasniquë, naa Dios Chani yoanish cabo, rësonish ca chama bo ri. Ja jisyamacani quiha rë. Jasca, ë yoahai ca jahuë bo ja nicacas-caniquë, jaboqui ma nicahai jascaria. Jama, nicati mëtsama ja icani quiha —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jatsi jodioba yoba bo cahëxëni ca joni Jesu qui joniquë tanamacatsi na. Johax, —¿Jënahuaxëhi ni ëa, Maestró, bëso-bësopaoxëna? —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jatsi Jesú quëbiniquë: —¿Jënihi ni Moisés quënënina? ¿Jahuë ja quënëni? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jatsi yoba cahëxëni cató quëbiniquë: —“Mato joiti, mato shinana, mato coshi, tihi cabá tsi Dios ma noixëti xo. Jasca, mato rabëti bo ma noixëti xo, mamë ma noihai jascaria” ii quiha —i joni niquë Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jatsi, —Jabija tsi xo toa mi yoahana. Tocapihi tsi bësoxëqui mia ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Jama, tocacasyamani quiha yoba cahëxëni cato rë. Jatsi parahax, —¿Tsohuë ni toa noho rabëti cato sa? —i joni niquë Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jatsi naa chani Jesú yoaniquë ja cahëno iquish na. —Jabi joní Jerusalén jisbayaniquë. Jericó yaca qui cahi ja ini quiha. Bahí tsi ja co-cono tsi yomacanaibo ja qui tsaminiquë rë. Jahuë sahuëti, jahuë parata, tihi cabo ja yoma-cani quiha. Ja sëtiajahuacani quiha. Sëtiaxo tsi quiha bahí tsi ja jisbëriacaniquë rësoti. ");
INSERT INTO caoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Toatiyá tsi quiha toa bahí tsi co-cohi arati ibo iniquë. Noitiria ca joni ja jisniquë ra. Jisi tsi tëtiaquiria tsi bahi qui ja riiniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","‘Jaquirëquë joni huëtsa joniquë. Levita ja ini quiha, naa Dios xobó tsi yonocohai cato. Joni tsayaxo ja tëtianiquë jaa ri, mëbicasyamaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","‘Jaquirëquë joniquë samariabo, naa jodiobo qui yoixëni ca nohiria. Co-copama tsi noitiria ca joni ja jisniquë jaa ri. Jisi tsi, “Noitiria tsi xo naa joni ra” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ja qui caxo tsi quiha jahuë quëësi bo ja chëxaniquë. Chëxaxo tsi ja yaboniquë. Jatsi jahuë burro qui noitiria ca joni ja jananiquë. Janaxo tsi quiha jahuë oxati xobo qui ja boniquë. Jaha xo tsi joni ja shomahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Jatsi huëaquë tsi quiha dos ca parata copixëni cabo xobo ibo qui samariabá aniquë. “Naa noitiria ca joni ó bësona” i ibo qui ja ni quiha. “Naa parata mi narisno tsi mia copixëquia jahari ë joquë no” i ja ni quiha —nëa tsi Jesu nëcaniquë toa chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Chani yoahax, —¿Jahuë shinahai, naa tres ca joni yoati na? ¿Jëni ca ni toa sëtiahacanish ca joni qui rabëti jascaria cato? —i yoba cahëxëni ca qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Jatsi joní quëbiniquë: —Shomahuanish ca samariabo quiha —iquiina. —Cata. Ja ani jasca ca mi ano mia ri ra —i Jesu ja qui niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jahuë rabëti bo ya capama tsi yaca qui Jesu cahëniquë. Jahá tsi quiha racaniquë yoxa, naa Marta icanai cato. Jabi Jesu qui joi ja amani quiha jahuë xobó tsi ja chitëno. ");
INSERT INTO caoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Jabi noma Martá jayani quiha, naa María icanai cato, naa Jesú tiisimahai ca nicacatsai cato. Jesu tahë tsi quiha ja tsahoniquë nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jama, nicatimaxëni Marta ini quiha shishocanaibo ja taahai ca iqui na. Jahuë yonoco shina-shinahi ja ini quiha. Jatsi Jesu qui Marta caniquë. Cahax, —Ea shinahuë, Ibobá. Noho nomá ëa jisbayaquë pë. Emë pistia xo taahai ca ëa xo naa rë. “Mi rëquëmë mëbihuë” ina ja qui —nëa tsi Marta nëcaniquë jahuë noma yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jatsi Jesú quëbiniquë: —Huëstima ca jahuë bo yoati tsi shina-huëjënahi quiha mia rë. Jënima tsi xo mi acaina. ");
INSERT INTO caoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jama, huësti ca jahuë narisqui mia axëna. Oquë tsi xo Mariá acaina, noho chani nicacastsi na. Mëbihacatimaxëni tsi xo toa ja nicahana —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jabi Dios qui bëhoxhi Jesu iniquë. Ja jatiquë tsi quiha, —Bëhoxti noqui ri tiisimana, Ibobá, naa Juan yamabá jahuë rabëti bo tiisimani jascaria —i jahuë rabëti bo ó ca huësti ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jatsi jato Jesú yoani tsi xo naa: —Bëhoxhi tsi nëcacana: “Oquë xo mi janë ra, Jahëpá. Nohiria mi ototsano ra” icana. ");
INSERT INTO caoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jasca, “Jatiroha ca barí tsi piti noqui ana” icana. ");
INSERT INTO caoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jasca, “Noba jocha mëbina, naa noqui yosicanaibo tëquë no noihai ca quëshpi na. Jochati no tanamahacayamano” icana —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jatsi nëca tsi Jesu chaniniquë jahuë rabëti bo qui: —Shinaparicana. Rabëti bo jaya xo mato tëquëta. Jabi mato rabëti xobo qui ma camitsa huëatiscano tsi mapari baaxëna. Cahax, “Tres ca mapari ë qui prestahuahahuë, noho rabëtí. ");
INSERT INTO caoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Noho xobo qui cahëyaquë noho rabëti. Paxnahi quiha. Yama tsi xo ja qui ë ati cato rë” i ja qui ma mitsa. ");
INSERT INTO caoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Jatsi xobo xara nëca tsi ja quëbimitsa, “Jishopë. Quëbëhacaquë caiti rë” iquiina. “Oxatí xo noa, naa ëa, nohó-na bo. Joinoma xo ëa ra, mapari mi qui axëna” i mato qui ja mitsa quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jabi mato rabëti joicasyamamitsa mato qui mapari axëna, mato rabëti ja iquë ri. Jama, naama pi xobo ibo ma quënano tsi joixëhi quiha mapari mato qui axëna iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Jascaria, Dios qui bëhoxpiquí tsi bënacana iquia ra. Mato qui acacaxëhi quiha. Mëracana. Mërapiquí tsi bixëqui mato. Mato bax japëcahacaxëhi quiha jahuë caiti. ");
INSERT INTO caoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bënahai ca qui acacaxëhi quiha. Bixëhi quiha mërahai cato. Japëcahaca-xëhi quiha caiti tsohuëcara ca quënahai ca bax na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Shinaparicahuë. “Sani picasquia” i pi mato xocobo no tsi ¿ja qui rono acaxëcanai pa? ");
INSERT INTO caoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Bachi picasquia” i pi ja no tsi ¿ja qui nibo acaxëcanai pa piti? ");
INSERT INTO caoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Jabi mato xocobo qui jahuë jia cabo ati cahëxëni xo mato, jochacanaibo ma iquii ri. Tocapimano tsi ¿bënacanaibo qui oquë tsi Espíritu Santo ayamayamaxëhi ni mato naipá ca Jahëpa ra? —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jabi joni quima yoshi niahi quiha Jesu iniquë. Yoshi iqui tsi jaro naa joni ini quiha. Jama, yoshi Jesú tsëcaquë tsi quiha chanitsi joni niquë ra. Jatsi ratëniquë nohiria bo ra tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Jama, Jesu pasomaha chanitsi nohiria huësti huësti ca niquë pë. —Naa joni mëbihi quiha Satanás, naa yoshi bo ibo-iboria ra. Satanás chamá tsi yoshi bo tsëcahi quiha tia —i jaca niquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Jatsi, —Naipá ca jisti-jistiria ahuë ra —i Jesu qui huëtsa bo niquë pë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jama, ja shinacanai ca cahëquí tsi jato Jesú quëbiniquë: —Jabi quëyohacaxëhi quiha país ca nohiria bo, ja nianacaquë no ra. Jasca, quëyohacacaxëcani quiha xobó ca nohiria ri, ja iquinacaquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jasca jamë pasomaha pi Satanás iquinano tsi ¿jënahuariahax jahuë chama naamana? Nëcaquia ra, ëa mëbihi quiha Satanás, yoshi bo tsëcati i ma ai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yoshi bo tsëcati pi Satanás ëa mëbino tsi ¿tsohuë ni toa mato nohiria yoi mëbiti ibo-iboria? Yoshi bo tsëcacani quiha jato ri. ¿Tsohuë ni toa jato tsëquëmati ibo ra? ¿Satanás ma ni? Ja tsi xo toa mato qui quësoxëhi quiha mato nohiria yoi bo iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jabi Dios chamá tsi yoshi bo ë tsëcaquë ra, Satanás chamá tsi nomari. E aca cató tsi bëro tsi xo toa mato qui Diós otohai ca johana ra. ");
INSERT INTO caoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","‘Jabi chamaxëni ca joní jahuë xobó ca jahuë bo ó bësono tsi jënima ca xo jahuë jahuëmishni bo. Yomahacatimaxëni ca xo. ");
INSERT INTO caoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Jabi toca xo Satanás ri. Jënima xo jahuë jahuë bo. Jama Satanás oquë ca pi jono tsi bëbohacahi quiha Satanás ra. Joxo tsi Satanás iquinati jahuë bo mëbihi quiha. Jaquirëquë, jahuë jahuë bo bichi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","‘Jabi ëa pasomaha yoi tsi xo ë bëtama cato. Jasca, noho yonoco pasomaha tsi xo toa ëa mëbiyamahai cato. ");
INSERT INTO caoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","‘Jabi joni quima yoshi tsëcahacano tsi xaba qui cahi quiha. Caxo tsi iti huëtsa mërahi quiha chitëxëna. Mahitsa mërahax, “E jisbëriani ca xobo qui jahari caxëquia ra” ii quiha yoshini rë. Jatsi bacahi quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Bacaxo tsi joni tsayahi quiha. Jaboqui jënima xo joni, bahuëhaca ca xobo jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ja jisbëriani ca joni tsayahax catëquëhi quiha pë, naa jabë yoshi huëtsa bo mërahi na. Jatsi siete ca yoshi yoixëni cabo bëhi quiha ja bëtati. Jatsi joni qui jicocani quiha jato tëquëta racaxëna. Jariapari iriama joni iniquë, jama jaboqui noiti-noitiria nori —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nëca tsi Jesu chanino tsi quiha nohiria xërëquë ó ca yoxá quënaniquë: —Shoma xo mi ihua, naa mia comanish cato ra. Shoma xo mia chocho amanish cato ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jatsi, —Jama xo. Shoma tsi xo Dios Chani nicacanaibo. Shoma tsi xo Dios Chani acanaibo iquia —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tocajano tsi quiha ja qui quëtsotsi nohiria misco niquë. Jatsi jato qui ja nëcaniquë: —Anomaria tsi xo no bëta jaboqui bësobëqui-canaibo rë. E acai ca jisti-jistiria roha jiscascani quiha pë, ë qui chitiminox pari. Maj. Jonás jisti roha jato qui axëquia. ");
INSERT INTO caoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jabi sani chahita jatoquë quima Jonás xabahamahacaquë tsi quiha jahuë chani Nínive yacatá ca nohiria bá chahahuaniquë ra. Jato qui jisti Jonás ini quiha jato chahahuamaxëna. Jascaria, naa xaba ó ca bësocanaibo qui jisti ixëquia ëa ri, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Copiti barí tsi bësotëquëxëhi quiha yoxa chama, naa Shiba mai ax jonish cato. Bësotëquëcaxëcani quiha naa xabacá ca nohiria bo ri. Jatsi toa barí tsi jato qui quësoxëhi quiha naa yoxa chama, ëa ja chahahuayamacana iqui na. Naa yoxa chama tsayacana. Nëama ja caniquë chama Salomón yamaba tiisi nicaxëna. Jama, nëá ca Salomón oquë ca jisqui mato ra. Jisi tsi nicayamaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jasca, bësotëquëcaxëcani quiha Nínive yacatá ca nohiria bo ri, copiti barí no. Naa xabacá ca nohiria qui quësocaxëcani quiha jato ri. Jabi jato qui Dios Chani Jonás yoaquë tsi quiha jahuë chani qui ja chitimicaniquë. Jama, nëá ca tsi Jonás oquë ca jisqui mato ra. Toa jahuë chani chahahuayamaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","‘Jabi lamparina tsamaxo tsi ¿caca nama janahi ni ibo pa? Jahuë ití tsi janahi quiha ra. Jatsi naquëtë qui jicoxo tsi huëa jisxëhi quiha nohiria. ");
INSERT INTO caoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jascaria tsi mëbihacaxëhi quiha nohiria, shina jia ca jayapiquí na. Mato quinia bërohuaxëhi quiha mato shinana, ja jënimacaquë no. Jatsi jabi jia ca jayaxëhi quiha mato ra. Jama shina yoi pi jayahi tsi tsëmó tsi coxëqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jatsi quiniacaxëcahuë, mato shina ó ca huëa nocahuahacayamano, ja yoinayamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mato shina pi jënimano tsi, tsëmó pi ma bohoyamano tsi, huahuaxëhi quiha mato jabi jia cato ra, naa lamparina huahuahai jascaria —tihi tsi quiha Jesu niquë nohiria bo qui chanihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jabi jahuë chani Jesu jatihuaquë tsi quiha fariseobá ja qui joi amaniquë jahuë xobó tsi ja oriquino. Jatsi jahuë xobo qui Jesu caniquë. Cahax ja tsahoniquë ja bëta oriquixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Jabi Jesu mëchocoyamani quiha pinox pari. Ja quëshpi tsi fariseobo ratëniquë, jodioba jabi pasomaha ja iqui iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Japi ja qui Jesu chaniniquë: —Yobá-naxëni xo mato fariseobo ra. Mato mëquë chocoharia xo mato. Jodioba jabi bo nicariaqui mato. Jama, mato shina tsi xo toa jahuë bo ó quëëmisxëniria ra. Yoixëni ca xo. ");
INSERT INTO caoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Jatsi, cahëtimaxëni xo mato ra. ¿Mato shina Dios, naa noba yora nëhohuanish cató ayamayamani? ");
INSERT INTO caoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Jariapari mato shina Ibo Dios qui acahuë. Jaquirëquë jiaxëhi quiha mato jabi tëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","‘Noiti xo mato fariseobo ra. Ma tësaha ca yochi bo, naa mente, ruda, tihi cabo quima xatë pistia ca, naa decima ca Dios qui aqui mato, mato yoba bo nicaxëna. Jënima quiha. Jama, mabë xatë yoi bo mëbicasyama xo mato pë. Dios noiyamayoiqui mato iquia. Jabi Dios yoba ma nicaxëti xo ra, yoba huëtsa bo shina-bënoxoma. ");
INSERT INTO caoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","‘Noiti xo mato fariseobo ra. Catiti xobo qui jicoxo tsi oquë ca tsahoti bo bicasqui mato pë. Jasca, yacatá ca bahí tsi bohoquí tsi nohiria bá mato joihuahai ca ó pasoqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","‘Noiti xo mato ra. Mato tsaya-tsayacani quiha nohiria, shina jiaxëni ca ma nori ca quëscahuaquí na. Jama, mato shina tsi xo yoixëniria. Jato qui jonë tsi xo toa mato jabi yoi bo ra —nëa tsi quiha fariseobo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jatsi Moisés yoba cahëxëni cabo huëstitá quëbiniquë: —Jishopë. Noqui ri ocahuaqui mia pë, Maestró, toca tsi mi chaniquë no. Noqui anoma quiha —i Jesu qui joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jatsi Jesú quëbiniquë: —Noiti tsi xo mato ri, yoba cahëxëni cabá. Nicahacatimaxëni ca yoba bo nohiria bo qui aqui mato pë. Jama, jato qui ma acai ca yoba bo nicayamahai ca mato xo naa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","‘Noiti xo mato ra. Mato naborëquëbá Dios Chani yoanish cabo tëpasniquë pë. Jatsi jato bax maihuati xobo aqui mato pa, nohiria bo jato shinamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Jama, mato qui jia tsi xo toa mato naborëquëbá anina iquia. Dios Chani yoanish cabo ja acani quiha. Jaquirëquë jato bax maihuati xobo aqui mato pë, nohiria bo quima mato jabi yoiria ca jonëmaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","‘Jabi mato yoati tsi Diós yoani ca tsi xo naa ra: “Jato qui noho Chani yoati ibo bo, noho Chani chitahëhuati ibo bo, tihi cabo jato qui raaxëquia. Huësti huësti ca tëpascaxëcani quiha pë. Tëxë bo tënëmacaxëcani quiha” i Dios ni quiha jahuë tiisí no. ");
INSERT INTO caoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Jabi toca ja iquë ra. Rëquë rohari tsi tëpas-hacani quiha huëstima ca Dios Chani yoati ibo bo rë. Jabi naa tëpas-hacanish cabo tëquë quëshpi tsi mato copixëhi quiha Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Jabi Abel pari acacani quiha. Jaquirëquë huëstima ca Dios Chani yoati ibo huëtsa bo acacani quiha. Jarohari tsi Zacarías ja acaniquë. Altar, naa arati xobo naxërëquë xo tsi Zacarías ja tëpascani quiha. Mato parayamaquia. Ja tëpas-hacacani quëshpi tsi copihacaxëti xo naa jaboquí ca bësocanaibo. ");
INSERT INTO caoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","‘Noiti xo mato yoba cahëxëni cabá. Mahitsa ca ma tiisimahai ca iqui tsi Dios Chani cahëyamahi quiha nohiria bo ra. Jasca, jabija ca chani cahëcasyama xo mato ri. Jasca, ë qui bëcascanaibo quëtiaqui mato pë, Dios Chani ja chahahuayamacano iquish na —nëa tsi fariseobo, yoba cahëxëni cabo, tihi cabo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Chanixo tsi quiha jato xobo Jesú jisbayaniquë. Jatsi ja qui caxatsi yoba tiisimacanaibo, fariseobo, tihi cabo niquë. Caxaquí tsi huëstima ca jahuë bo yoati tsi ja nica-nicacaniquë tanamacasquí na. Mahitsa ja nica-nicacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jatsi ja tsayamisria-caniquë ja qui quësoxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jabi huëstima ca nohiria bo Jesu qui quëtsoniquë. Tihiria ca inish ca racana. Yama xëa ini quiha tapiti. Jasca, jato huëtsa jamahi ja icani quiha xëa yama iqui na. Jatsi jahuë rabëti bo qui chanitsi Jesu niquë. —Fariseobá tiisimahai ca qui quiniacaxëcahuë. Paramisxëni ca xo. ");
INSERT INTO caoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bërohuahacaxëti xo jato jabi yoi ra. Jonëma quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","‘Jabi raquëxo tsi Dios Chani ma yoa-yoapaoniquë. Jama, jaboqui tsi mato nicacaxëcani quiha nohiria. Jasca, Dios Chani yoahi tsi ma baxëxpaoniquë. Jama, jaboqui bëro-bëroria tsi noho Chani ma yoaxëti xo, raquëxoma. ");
INSERT INTO caoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jabi mato acascanaibo qui raquëyamacana, noho rabëti bá. Mato yora roha tsi ati mëtsa ca xo. Mato aapiquí tsi jaroha tsi xo toa mato ja acanaina. ");
INSERT INTO caoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Jama, Dios qui ma raquëxëti xo iquia ra. Tënëtiya qui nohiria niati chama jaya xo, jato ati. Parayamaquia. Dios qui raquëcana iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","‘¿Mahitsa, naa dos ca parata quëshpi tsi cinco ca chorobo iniayamayamacahi ni? Copiyamaria ca xo. Jabi copiyama ca chorobo shina-bënoyamahi quiha Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Jascaria, mato boo tëquë tocahacani quiha ra. Jatsi raquëyamacana, huëstima ca chorobo oquë ma nori quëshpi na —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","‘Nohiria bësojó pi “Cristó-na xo ëa” i nohiria no tsi Dios ángel bo bësojó tsi “Nohó-na xo toa” ixëquia ëa ri, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jama, nohiria bësojó pi ëa pasomaha nohiria chanino tsi Dios ángel bo bësojó tsi “Nohó-na ma xo toa” ixëquia ëa ri, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","‘Jabi ëa pasomaha pi nohiria chanino tsi iriama tsi xo toa. Jahuë jocha masaxëhi quiha Dios. Jama Espíritu Santo pasomaha pi nohiria chanino tsi masahacayamaxëhi quiha jahuë jocha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","‘Jabi catiti xobó ca chama bo, nohiria chama bo, tihi cabo qui mato ja bocamitsa mato qui quësoxëna. Tocapijahuacano tsi shina-huëjënayamatsicana ma quëbixëhai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Toatiyá tsi mato tiisimaxëhi quiha Espíritu Santo ra. Ma yoaxëti ca mato jismaxëhi quiha. Chaniyamaxëqui mato, Espíritu Santo inori —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jatsi nohiria xërëquë ó ca joni chaniniquë: —Noho rëquëmë qui mi chanino, maestró. Huashicoxëni quiha. Noho jahëpa yamaba jahuëmishni bo ë bëta xatënayamahi quiha pë —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jatsi Jesú quëbiniquë: —Iyamaquia ra, joní. Nohiria jahuëmishni bo tsi yobati ë raahacayamaniquë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jatsi, —Quiniacaxëcahuë. Anoma tsi xo jahuëmishni bo ó quëëmis-haina ra. Huëstima ca pi ma jayano ri tsi ¿jënahuariaxo raca toa jahuë bá mato raniyoihuana? —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jatsi naa chani Jesú nohiria bo qui yoaniquë ja cahëcano iquish na: —Huai jiaxëni ca rico ca joni jayani quiha. Anomaria ja tësani ca bëro ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ja iqui tsi “¿Jënahuaxëhi ni ëa sa? Bimi janati ca xobo narisquia rë” i jamë ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Jarohari tsi, “Noho bimi janati xobo pistia bo poxaxëquia ra. Jaquirëquë xobo chahitaxëni cabo axëquia noho bimi, noho jahuë bo, tihi cabo quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Acax, ‘Mi yonoco jënëna. Huëstima ca año no tsi naamaxëhi quiha mi nanëha ca jahuë bo ra. Shoma xo mia. Oriquihuë. Jënë ahuë. Ranitsihuë’ i ëmë xëquia ra” —nëa tsi rico ca joni nëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Jatsi ja qui Dios chaniniquë: “Naa baquichá tsi rësoxëqui mia, yoyoxëni cató. Mi rësoquë tsi ¿tsohuë ni toa mi janaha ca jahuë bo bichiina ra?” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jabi toca xo parata, jahuëmishni bo, tihi cabo ó quëëmisxëni cabo. Mëquëyariayoi ca xo, Dios shinayamahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jatsi jahuë rabëti bo qui chanitëquëtsi Jesu niquë: —Oriquiti, sahuëti, tihi cabo ti tsi shinayamacana ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mato oriquiti oquë tsi xo ma bësohaina. Jasca, mato sahuëti oquë tsi xo mato yora. ");
INSERT INTO caoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Isa bo tsayacahuë. Bëro banayamacani quiha. Bimi tësayamacani quiha. Jasca, yama tsi xo toa jato xobo qui nanëhaca ca bimi ra. Jama, jari jënima ca xo. Jato pimahi quiha Dios ra. Jabi ¿isa bo oquëyama-yamahi ni mato ra? ");
INSERT INTO caoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Jasca, ¿jënahuariaxo raca ma bësohai ca año bo ma huinomana, ma shina-huëjënahai cató no? ");
INSERT INTO caoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Inoma xo mato ra. Japi oriquiti, sahuëti, tihi cabo yoati tsi shina-shinayamatsacana. ");
INSERT INTO caoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","‘Jasca, huasi joa jiaxëni cabo qui tsayacahuë. Yonocoyamacani quiha oriquiti quëshpi na. Jiaria tsi xo ja jiscanaina. Salomón yamaba raiti oquë-oquëria ca xo iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jabi jiaria tsi naa naamayamahai ca joa, naa mëri tsi nahai ca joa sahuëmahi quiha Dios ra. Tocapiquí tsi ¿mato ri sahuëmacas-yamayamaxëhi ni Dios ra? Iriama tsi xo toa ma chitimihaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Jaha tsi oriquiti, jënë, tihi cabo ó quëëmisyamacana. Jasca, nëca ca jahuë bo yoati tsi shina-huëjënayamacana. ");
INSERT INTO caoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jabi ja picanai ca shina-shinacani quiha Dios cahëyamacanaibo. Jama, mato ó bësohi quiha mato Jahëpa, ma narisyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Jatsi, mato Chama-chamaria pari shinacana. Tocapimano tsi mato qui acacaxëhi quiha, oriquiti, jënë, tihi cabo ma narisyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Raquëyamacana, noho xocobá. Jahuë mana ca jahuë bo mato qui acatsi quiha Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","‘Mato jahuë bo iniacana, noitiria cabo qui parata axëna. Tocapimano tsi oquëxëhi quiha mato mana ca jahuë bo ra. Oquë-oquëria ca jahuë bo quëyotimaxëni tsi xo jotoro ri. ");
INSERT INTO caoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Jabi maí ca jahuëmishni bo pi noiquí tsi toa jahuë bo shinarohaxëqui mato pë. Jama, Dios noiquí tsi Dios jahuë bo shinaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","‘Ma rohahuahacaxëti xo iquia. Jato chama manacanai ca yonati bo jascariacana. Raiti sahuë ca xo. Jasca, chama bax ririhi quiha jato lamparina bo. Jatsi ahui yahai ca joni fiesta ax jato chama bacano tsi ja bax caiti japëcatapicani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Jatsi ranicani quiha yonati bo, ja manacanai ca nori ca jato chamá jisquë no. Ja manacanai nori iqui tsi ranixëhi quiha chama ri. Ja quëshpi tsi jahuë yonati bo tsahomaxëhi quiha pimaxëna. Jahuë sahuëti rarinamaxo tsi jato taaxëhi quiha chama ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Jabi baquicha, baquishmari, tihi pi no tsi chama jono tsi ranicaxëcani quiha yonati bo, ja rohahuahacacani quëshpi na. Jabi manahai ca yonati bo jisxëhi quiha chama, joxo na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Jasca, shinaparicana. Yomaxëni ca johai ca xaba pi cahërohahi tsi jahuë xobo ó ibo bësoquë aquë ra. Jahuë xobo qui jicoti mëtsama yomaxëni ca iquë aquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jascaria tsi ma rohahuahacaxëti xo mato ri. Jabi bacaxëquia, naa Nohiria Baquë ë nori cato. Bacaxëquia jaha ma pasoyamahai ca xabacá no —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jatsi Pedró nicaniquë: —¿Tsohuë qui naa chani mi yoaha? ¿Jatiroha cabo qui mi yoaha sa? ¿Noqui roha quëshpi ma ni? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jatsi Jesú quëbiniquë: —¿Tsohuë ni toa empleado jiaxëni cato, naa chahahuahacati cato? ¿Jënica nohiria bixëhi ni chama, jahuë yonati bo obësoti empleado iti, jato orihuati? ¿Jahuë yonati jia ca biyamayamaxëhi ni? ");
INSERT INTO caoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Jahuë chamá ja qui aca ca yonoco aapihi tsi ranixëhi quiha empleado, jahuë chama joquë no. Ja acai ca jisxëhi quiha jahuë chama ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jisi tsi jahuë empleado qui jatiroha ca axëhi quiha, jahuë jahuë bo tëquë obësoti. ");
INSERT INTO caoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Jama, “Bamaxëhi quiha noho chama” i pi toa yonati no tsi, jahuë chama yonati bo pi ja rashano tsi ¿jënahuariaxëhi ni jahuë chama ra, nicaxo na? Jasca, oriquihaina, jënë acaina, pahëhaina, tihi cabo pi empleadó ano tsi ¿jënahuaxëhi ni chama ra, nicaxo na? ");
INSERT INTO caoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ja quiniaxëti xo ra. Jabi jaha ja pasoyamahai ca barí tsi bacaxëhi quiha toa chama ra. Bacaxo tsi ¿jahuë yonati yoi ca tëpasyamayamaxëhi ni? Nicamisxëni caba copi ja qui axëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","‘Jasca, huëstima tsi rashahacaxëhi quiha jahuë chama shina cahëhai ca yonati, ja yoaha ca ayamapiquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jama, iriama tsi rashahacaxëhi quiha jahuë chama shina cahëyamahax cato, janyama ja aquë no. Jabi huëstima ca tiisi pi joni qui acacarohano tsi huëstima ca ó pasohacaxëhi quiha. “Ariaxëhi quiha” ii quiha nohiria bo ja yoati na. Joni qui pi huëstima ca ati yonoco acacarohano tsi oquë ca yonoco ja ati ca ó pasocaxëcani quiha nohiria bo —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","‘Jabi mai qui ë joniquë maí ca nohiria oquëxnamaxëna. Ea iqui tsi iquinacaxëcani quiha nohiria ra, caxahi na. Jaboqui pi ja oquëxnacano tsi ë raniquë aquë. Ja oquëxna-tapicano ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Jasca, anomariaxëhi quiha ë tënë-tënëhaina rë. Ja iqui tsi shina-huëjënaquia. Mëri tsi ja jatino ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Jasca, nohiria bëpasimahi ë joyamaniquë. Toca tsi quëscahuayamacana. Jama, nohiria iquinamati, nohiria oquëxnamati, tihi ca aqui ë joniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ea iqui tsi oquëxnaxëhi quiha xobó ca cinco cabo. Dos ca pasomahaxëhi quiha tres cabo; tres ca pasomahaxëhi quiha dos cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ea iqui tsi jahuë baquë pasomahaxëhi jahuë jahëpa rë. Jasca, jahuë jahëpa pasomahaxëhi quiha jahuë baquë ri. Ea iqui tsi jahuë jahi pasomahaxëhi quiha jahëhua. Jasca, jahuë jahëhua pasomahaxëhi quiha jahuë jahini. (Jasca, ëa iqui tsi jahuë raisi pasomahaxëhi quiha jahuë raisi ri) —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jatsi nëca tsi nohiria bo qui Jesu chaniniquë: —“Joqui oi” iqui mato, yota tsëmo chëquë johai ca ma jisquë no. Jatsi oi tsi xo. ");
INSERT INTO caoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Jasca, xototsi yota no tsi “Matsinaxëhi quiha rë” iqui mato. Jabija tsi xo toa ma iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Jabi nai tsaya-tsayaquí tsi oi johai, yota johai, tihi cabo cahëxëni xo mato, paramisxëni cabá. Jama, jaboqui no bësohai ca xaba cahëtimaxëni xo mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","‘¿Jia ca jahuë ati mëtsama ni mato sa? ");
INSERT INTO caoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jabi mato pasomaha ca joni pi mato qui caxano tsi bamahaxma tsi ja bëta rabënacana, gobierno chama bo qui mato ja bonox pari. Jabi policía qui chamá mato mëamitsa ra. Jaquirëquë cárcel qui ma nanëhacamitsa. ");
INSERT INTO caoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jatsi tsëquëyamaxëqui mato rë. Jariapari tsi mato múlta copi ma jatihuaxëti xo. (Jascaria tsi bamayamacana rohahuahacaxëna. Joxëhi quiha Dios copiti bari ra) —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Toatiyá tsi huësti huësti ca nohiria bo Jesu qui bëcaniquë Pilató ani ca yoaxëna. Jabi Galileá ca joni bo Pilató tëpasni quiha. Tëpasxo tsi quiha yohina jimi ya jato jimi ja jaxcamënamani quiha pë, Jerusalén ca arati xobo xo na. Toa yohina jimi Dios qui acacati ini quiha nohiria ba jocha quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nicahax Jesú quëbiniquë: —¿Jahuë shinacanai? ¿Galileá ca nohiria oquë ni naa tëpas-hacanish ca joni ba jocha ra? ");
INSERT INTO caoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Iyamahi quiha. Jatsi quiniacaxëcahuë. Mato jocha quima pi Dios quiri bësoyamahi tsi rësoxëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Japa Siloé ca namëhacanish ca joni bo? Toa ax tsi quiha dieciocho ca joni bo acacaniquë jato ri, jato cacha xobo tëtëca poxoniquë no. ¿Ja acacani iqui tsi Jerusalén cabo oquë jato jocha ini? ¿Jahuë shinacanai? ");
INSERT INTO caoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Dios copi ja nomari iquia. Jama, mato quinia pi raninamayamahi tsi rësoxëqui mato tëquë ri —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jatsi naa chani nohiria bo qui Jesu yoaniquë: —Bimi jihui jayaniquë joni ra, jahuë huaí cato. Jahuë bimi bichi ja cani quiha. Yama a ra. ");
INSERT INTO caoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Japi jahuë yonati qui ibo chaniniquë: “Tsayahuë. Tres año no tsi naa jihui qui ë joquë bimi bixëna. Yama xo pë. Rërahuë. Anoma quiha. Noho mai xëa biqui ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jama, jahuë yonatí quëbiniquë: “Jari huësti ca año no tsi ja niino. Ja tëamë tsi mai huëyoxëquia. Jahuë mai jiahuaxëquia. ");
INSERT INTO caoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Oquëri ca xënipá tsi ja bimimitsa ra. Ja bimiyamapino tsi rëraxëquia ra” i yonati ni quiha ibo qui —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jabi jodioba catiti xobo xo tsi tiisimahi Jesu iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Jaha tsi quiha noitiria ca yoxa iniquë. Dieciocho año no tsi tapitimaxëni ja ini quiha. Jabi yoshi iqui tsi tëto ja ini quiha, mëstë niitimaxëni iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisi tsi Jesú quënaniquë: —Mi jënimahuahacaquë, caí —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jatsi yoxa ja motsaniquë jahuë mëquënë́ no. Ja joitapiniquë ra. Joixo tsi quiha Dios ja ocahuaniquë “Gracias” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jama, catiti xobo chama caxaniquë, joiti barí tsi Jesú jënimahuani nori quëshpi na. Jatsi, —Seis tsi xo toa yonocoti bari ra. Toa barí tsi bëcahuë jënimahuahacaxëna. Anoma tsi xo toa joiti barí tsi jënimahuahacahaina ra —i nohiria qui chama niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jatsi Jesú quëbiniquë: —Jisa, mato paracanaibá. ¿Japa mato huëyë bo, mato burro bo? ¿Joiti barí tsi jato mërisyamayamacanai, jënë qui jato mëpixëna? ");
INSERT INTO caoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","¿Japa naa yoxa ra? Abraham yamabo chahitaxocobo xo ra. Huëyë, burro, tihi cabo oquë quiha. Jabi dieciocho año no tsi Satanás iqui tsi mëstë niitimaxëni ja iquë ra, tëto iquiina. ¿Mato qui yoi ni naa tëtohai ca yoxa jënimahuahaina pa? —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nëca tsi Jesu chaniquë tsi quiha ja qui caxahai ca chama bo bërabiniquë. Jama, rani-raniniquë nohiria tëxë. Jato qui jia ini quiha Jesú ani ca tëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jatsi Jesú nicaniquë: —¿Jahuë jasca ni Diós otohaina? ¿Jahuë qui Diós otohai ca jaharisihuaxëhi ni noa? ");
INSERT INTO caoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bëro mishni, naa joní banahai ca mostaza bëro jascaria xo iquia. Shinahaqui quiha mostaza bëro. Shinahacax jihui manëhi quiha. Jaquirëquë toa xo tsi jato naha aqui quiha isa bo —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jatsi Jesú jato nicatëquëniquë: —¿Jahuë qui Diós otohai ca jaharisihuaxëhi ni noa? ");
INSERT INTO caoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Levadura jascaria xo iquia. Jariapari tsi harina somo ca ya tëohai quiha yoxa. Toca tsi harina xara pacanahi quiha jahuë shapo —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jatsi yaca bo xo tsi Jesú tiisima-bonaniquë. Huësti ca yaca jisbaya tsi yaca huëtsa qui ja caniquë Jerusalén quinia ca bahí no. ");
INSERT INTO caoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jatsi, —¿Xabahamahacaxëhi ni ichariama cabo roha, Taitá? —i nohiria niquë. Jatsi Jesú quëbiniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Naipá ca caiti tsi xo natsëo. Jatsi ariacana ja qui jicoxëna. Ja qui jicoti mëtsama icaxëcani quiha huëstima ca jicocas-canaibo ra. ");
INSERT INTO caoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jabi xobo ibobá caiti japano tsi jicotimaxëni-xëhi quiha mato ra. Jatsi, “Noqui jicomahuë, Ibobá” ixëqui mato, cacha niihax na. Jatsi, “Mato cahëyamaquia” i mato qui xëhi quiha Ibo ra. ");
INSERT INTO caoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jatsi jahari quëbixëhi quiha mato. “Mi bëta no oriquipaoniquë ra. Jasca noba yacata xo tsi noqui mi tiisimapaoniquë ra” ixëqui mato, mahitsa. ");
INSERT INTO caoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jatsi, “Mato cahëyamquia. Bocata, mato jochahuaxëni cabá” i mato qui xëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Jatsi, araconaxëqui mato ra. “E ra ma. Jishopë” ixëqui mato, cacha ax na. Toá ca Diós otohai cató ca Abraham, Isaac, Jacob, Dios Chani yoanish cabo, tihi cabo jisxëqui mato. Jato bëtayamaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Toatiyá tsi maí ca iti bo tëquë quima ax bëcaxëcani quiha nohiria bo. Diós otohai cató tsi oriquicaxëcani quiha carayanabo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tsayacahuë. Toa barí tsi mato qui quërasria ca carayanabo pari bixëhi quiha Dios ra. Jama, noitixëhi quiha mato jariapari ca Dios Chani binish cabo. Jachoxëqui mato iquia —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jatsi ja qui huësti huësti ca fariseobo bëcaniquë. —Nëa chitëyamatsihuë. Jabahuë ra. Mia acatsi quiha Herodes ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jatsi Jesú quëbiniquë: —Jahari toa quiaxëni ca qui bocata. “Jaboqui, huëaquë, jari yoshi bo tsëcaxëquia ra. Toa dos ca bari no tsi nohiria bo jënimahuaxëquia. Jama, oquëri ca bari jatixëhi quiha noho yonoco ra” icana ja qui. ");
INSERT INTO caoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Jari noho quiniá tsi ë caxëti xo ra. Jaboqui, huëaquë, oquëri ca bari, tihi tsi xo ë cahaina. Jasca, Jerusalén tsi ë namëhacaxëti xo, naa Dios Chani yoanish ca huëtsa bo acacani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","‘Jisa Jerusalén ca nohiria bá. Dios Chani yoati ibo jari aqui mato rë. Mato qui Diós raahai ca Chani bëcanaibo aqui mato maxaxá no. Jabi mato noiquí tsi mato otocasquia, naa jahuë pëhi namá jahuë xocobo patiarí otohai jascaria. Jama, ëa niacasqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Diós mato niabayaquë iquia. Tsayahuë. Jabi ëa jistëquënox pari tsi “Shoma tsi xo toa Ibobá janë́ tsi johai cato” ixëqui mato ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Huësti ca joiti barí tsi quiha fariseobo chama xobo qui Jesu caniquë ja bëta oriquihi na. Jasca, tobi ini quiha Jesu qui tsayamisxëniria ca jodioba jabinaxëni cabo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jabi Jesu bësojó tsi noitiria ca joni tsaho ini quiha, naa bai ca yora, poyamë, huico, tihi cabo jayanish cato. ");
INSERT INTO caoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jaha tsi jodioba yoba cahëxëni cabo, fariseobo, tihi cabo Jesú nicaniquë: —¿Mato qui jënima ni joiti barí tsi jënimahuahaina? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ja quëbiyamacaniquë. Jatsi Jesú joni biniquë. Bixo tsi joni ja jënimahuaniquë. Jatsi jahari jahuë xobo qui jënima ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Raahax jato qui Jesu chanitëquëniquë: —¿Mato baquë, mato vaca, tihi cabo pi jënë maiquini qui paquërohano tsi bamaxoma tsi ma tsëcayamaquë ana? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jatsi quëbitimaxëni quiha ja icaniquë ra, naa jodioba yoba cahëxëni cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jabi toá ca oquë ca tsahoti bo fariseobá bicasni quiha. Ja acanai ca jisi tsi naa chani jato qui Jesú yoaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Ahui yahai cato fiesta qui pi mato qui nohiriá joi amano tsi toá ca oquë ca tsahoti bo biyamacana. Quiniacaxëcahuë. Mato oquë ca nohiria jomitsa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Jatsi mato qui joxëhi quiha fiesta ibo tia. Johax, “Mi tsahoti joni huëtsa qui acasquia rë” i mato qui xëhi quiha. Tocapijano tsi bërabixëqui mato tia. Jatsi ibo nëama ca tsahoti yoi ca bixëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Jama, mato qui joi amahacano tsi nëama ca tsahoti pari bicana. Jatsi johax, “Ea tahë tsi mi tsahono, noho rabëtí” i mato qui fiesta ibo mitsa. Toca tsi fiesta qui bëcanish cabo bësojo ax tsi oquëhuahacaxëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jatsi quiniacaxëcahuë. Noitihuahacaxëhi quiha jamë oquëhuacatsai cato. Jama, oquëhuahacaxëhi quiha iriama cato, naa oquë bicasyamahai cato —nëa tsi Jesu nëcaniquë oquë ó quëëcanaibo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jatsi oriquiti ja qui joi amati ibo qui Jesu chaniniquë: —Oriquiti taaquí tsi mi rabëti bo, mi xatë bo, mi jimi bo, mi rico ca rabëti bo, tihi cabo qui oriquiti joi amayamahuë. Jato qui oriquiti joi pi mi amano tsi jahari mi qui oriquiti joi amacaxëcani quiha jato ri. Toca tsi copihacaxëqui mia. ");
INSERT INTO caoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jama, oriquiti taaquí tsi noitiria cabo, yora choni jaya cabo, tapiyamacanaibo, bëco cabo, tihi cabo qui oriquiti joi mi amaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Tocapihi tsi shomahuahacaxëhi quiha mia ra, jahari mia copitimaxëni ja icanai iqui na. Jatsi mia copixëhi quiha Dios ra, mëstëxëni cabo bësotëquëxëquë no —nëa tsi ibo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jabi Jesú yoaha ca toá ca oriquihai ca joni huësti cató nicaniquë. Nicahax, —Rani-ranixëhi quiha Diós otohai cato ó ca oriquicanaibo tëquë —i quiha Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jatsi Jesu ja qui naa chani yoaniquë: —Oriquiti, chariquiti, tihi cabo joní ani quiha. Axo tsi quiha huëstima cabo qui oriquiti joi ja amaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Jatsi jahuë oriquiti bari tsëquëquë tsi quiha jahuë yonati ja raaniquë nohiria bo qui joi amati. “‘Bëcahuë, rohahuahacaquë oriquiti ra’ icana jato qui” i jahuë yonati qui ibo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Jama, nohiria bo bëcasyamacani quiha. “Huai copiyaquë ëa ra. E jisi caxëti xo” i jariapari ca joni niquë jahuë yonati qui. ");
INSERT INTO caoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jatsi, “Cinco ca huëyë bo ë copiquë. Jato tanamahi caquia ra. Canoma xo ëa rë” i huëtsa ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jatsi, “Jaboqui ë ahui yaquë ra. Canoma xo ëa rë” i joni huëtsa ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Jatsi yonati bacaniquë jahuë ibo qui. Bacahax, “Bëcasyamacani quiha pë” i ja qui ja niquë. Jatsi ibo caxaniquë. “Yacatá ca bahi tëquë qui cata. Noitiria cabo, yora choni jaya cabo, bëco cabo, tapitimaxëni cabo, tihi cabo nëri bëhuë” i jahuë yonati qui ibo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jatsi bacahax, “Jato ë bëquë ra, mi yoaha jascaria; jama, jari tobi xëa pa” i jahuë chama qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jatsi ibo jahuë yonati qui chanitëquëniquë. “Bahí ca nohiria bo, nëama ca nohiria bo, tihi ca nohiria nëri bëhuë, noho xobo rëamëno iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Noho oriquiti piyamaxëhi quiha ra toa jariapari ca noho joi binish cabo ra” iquiina —nëa tsi joni qui Jesu nëcaniquë toa chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jabi huëstima ca nohiria Jesu qui bëhi iniquë. Jato quiri bësohax ja chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Ea noixëti xo tsohuëcara ca ëa banahuacatsai cato. Jahuë jahëpa, jahuë jahëhua, jahuë ahuini, jahuë xocobo, jahuë xatë bo, tihi cabo oquë tsi ëa ja noixëti xo ra. Jasca, jamë ja noiyamano. Toca pi ëa noiyamahi tsi noho rabëti manëtimaxëni-xëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Jahuë cruz yoi pi iayamahi tsi ëa pi banahuayamahi tsi noho rabëti iti mëtsama xo toa ra. ");
INSERT INTO caoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Jabi ¿jënahuahi ni joni, xobo paxa ca acatsi na? Tsahoxo tsi ¿jahuë xobo pari ati copinaca shinayamayamahi ni? Toa shinaparihi quiha, parata narisyamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Parata pi narisquí tsi jahuë xobo jatihuayamaxëhi quiha. Tocapijano tsi osacaxëcani quiha nohiria. ");
INSERT INTO caoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Jahuë xobo naa joní chitahëhuaniquë. Chitahëhuahax jatihuatimaxëni xo ra” i caxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Jascaria, ¿shinayamayamaxëhi ni chama, ja pasomaha ca país huëtsa iquinacasquë no? Jabi veinte mil ca soldado bo pi chama huëtsá jayano tsi jahuë diez mil ca soldado bo yoi bëbohacamitsa. Japi jato iquinati chama cahëparicatsi quiha iquinanox pari. Shinaparihi quiha chama. ");
INSERT INTO caoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Jatsi bëbotimaxëni pi jahuë soldado bo no tsi toa chama huëtsa qui chani raaxëhi quiha, ja bëta rabënaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jascaria, shina-shinaparicana. Mato jahuë bo tëquë pi jisbëriayamahi tsi noho rabëti bo itimaxëni xo mato ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Jabi chopara tëë tsi xo jënima. Jama jahuë tëë pi bënohi tsi ¿jënahuariahax ja tëënatëquëna? ");
INSERT INTO caoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Mahitsa tsi xo chopara tëëyama cato. Anoma quiha. Ja niahacaxëti xo. Japi pahoqui jayaquí tsi nicacana ra —i Jesu niquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jabi gobierno impuestos bicanaibo, jochacanaibo, tihi cabo Jesu qui bëcaniquë jahuë chani nicacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ja bëcaquë tsi quiha fariseobo, yoba tiisimacanaibo, tihi cabo yosananiquë. —Jochahuaxëni cabo joihuahi quiha naa Jesu pa. Tsayacapa. Jato bëta xo tsi pihi quiha ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jatsi naa chani Jesú jato yoaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Shinaparicana. ¿Cien ca oveja bo pi jayarohaquí tsi jato ó ma bësoquë ayamana? Huësti ca oveja pi bënono tsi ¿noventa y nueve cabo jisbayayamayamacanai, toa huësti ca mëraxëna? Toa bënohai ca oveja ma mëraquë aquë tia. ");
INSERT INTO caoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Bichi tsi rani-raniqui mato. Icoxo tsi jahari xobo qui bëqui mato raniquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jatsi mato xobo qui cahëxo tsi mato tapaí ca racacanaibo quënaqui mato, jato yoaxëna, “E bëta ranicana. Noho bënohax ca oveja jahari ë biquë ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Jascaria tsi, noventa y nueve ca mëstëxëni ca nohiria bo, naa janyama boyamacanaibo quëshpi tsi ranihi quiha naipá cabo. Jama, oquëria tsi xo ja ranicanaina, huësti ca bënohax ca jochahai ca jahari Dios qui joquë no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—Shinaparicana. Diez ca parata jayaquí tsi huësti ca parata yoxá bënomitsa. Bënoxo tsi ¿jahuë lamparina tsamayamayamaxëhi ni, toa huësti ca parata mëraxëna? ");
INSERT INTO caoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Mëraxo tsi jahuë xobo tahë ca racacanaibo, jahuë rabëti bo, tihi cabo quënahi quiha jato yoaxëna, “E bëta ranicana. E bënoha ca parata ë biquë ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jascaria tsi rani-ranixëhi quiha Dios ángel bo ri, jocha quima Dios quiri huësti ca jochahai ca bësoquë no —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jaquirëquë chani huëtsa Jesú yoaniquë. Ja nëcani quiha: —Dos ca baquë joní jayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Baquë nomá jahuë jahëpa jisbayacasni quiha. Canox pari tsi quiha “E bixëti ca jahuë bo xatë jaboqui ë qui ahuë, noho jahëpá” i ja qui ja ni quiha. Jatsi jahuë jahuëmishni bo, jahuë parata, tihi cabo jahuë jahëpá oquëxnamaniquë, jahuë baquë noma qui ati. ");
INSERT INTO caoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jatsi ichariama bari huinocaquë tsi jahuë jahuë bo, jahuë parata, tihi cabo sota qui baquë nomá nanëniquë. Nanëhax nëama ca mai huëtsa qui ja caniquë. Toá tsi jahuë parata ja raaniquë. Ja pahëni quiha. Ja yoyoni quiha. Mëri tsi jahuë parata quëyohacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Toca tsi jahuë parata tëquë ja raaniquë pë. Jatsi biniatsi toá ca maí ca nohiria bá huaniquë, oi yama ca quëshpi na. Paxnatsi joni niquë rë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Paxnaxo tsi quiha yonoco mërahi ja caniquë. Jatsi chancho obëso ca ja manëni quiha. Ja raahacani quiha jato pimati. ");
INSERT INTO caoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Paxnaquí tsi quiha chancho bá pihai ca xëqui xëbo ja picasni quiha. Yama jahuë poco ini quiha. Huashicoxëni jahuë chama ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jatsi jahuë jahëpa xobo shinatsijahuaniquë. “Shomaria tsi xo toa noho jahëpa yonati bo ra. Paxnayamacani quiha. Huëstima tsi xo jato oriquiti ra. Jama, rësopaimaria xo ëa rë, paxnahi na” nëa tsi ja nëcani quiha jamë no. ");
INSERT INTO caoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jatsi “Noho jahëpa qui jahari caquia ra. Cahax ‘Mia, Dios, tihi cabo pasomaha ë jochaquë rë’ ixëquia noho jahëpa qui. ");
INSERT INTO caoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","‘Mi baquë ë quënahacayamati xo. Mi yonati jascaria ëa mi ano ra’ ixëquia” nëa tsi baquë nëcani quiha jamë no. ");
INSERT INTO caoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Jatsi joihax jahuë jahëpa xobo qui catsijaniquë. ‘Jabi nëama ja no tsi quiha jahuë jahëpá jahuë baquë jisniquë. Jisi tsi quiha jahuë baquë qui ja jabaniquë. Jahuë baquë ja tatsoniquë noiquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jatsi jahuë jahëpa qui baquë chaniniquë: “Dios, mia, tihi cabo pasomaha ë jochaquë ra. Mi baquë ë quënahacayamati xo ra. Mi yonati jascaria ëa mi ano” i jahuë jahëpa qui baquë ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jama, jahuë jahëpá jahuë yonati bo quënaniquë. “Saco, naa oquë ca saco nëri bëcana. Noho baquë sahuëmacana. Jasca, jahuë mëquënë́ tsi mëquëraati amacana. Jaquirëquë zapato bo sahuëmacana. ");
INSERT INTO caoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Sahuëmaxo tsi vaca baquë chahitaxëni ca bëcana tëpas-hacati. No oriquino ra. No pabëno ra. ");
INSERT INTO caoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Rësonish ca jascaria noho baquë iniquë, jama jaboqui bëso ja nori ra. Bëno tsi ja iniquë, jaboqui no bëta ja nori. Jahari ja joquë ra” nëa tsi jahuë jahëpa nëcaniquë. Jatsi oriquitsijacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","‘Jabi huaí tsi jahuë baquë rëquëmë iniquë, jahuë noma bacaquë no. Xobo qui jopama tsi quiha música, pabëcanaina, tihi cabo ja nicaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nicaxo jahuë yonati ja quënaniquë. “¿Jënahuacahi ni xobó cabo pa?” i ja qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Jatsi, “Jahari joquë mi noma ra. Vaca baquë chahitaxëni ca mi ipá aquë ra piti, jënima mi noma nori quëshpi na. Jia tsi jahari ja joquë ra” i ja qui yonati niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Jatsi caxaniquë jahuë rëquëmë. Xobo qui ja jicoyamani quiha. Jatsi cacha jahuë jahëpa caniquë ja qui, “Jicohuë, jicohuë” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jatsi jahuë jahëpa qui baquë nëcaniquë: “Huëstima ca año no tsi yonati jascaria mi bax ë yonocoquë ra. Mi yoba tëquë ë nicaquë ra. Toatiyá tsi chibo pistia roha ë qui ayamaqui mia pë, noho rabëti bo ya ë pabëno. ");
INSERT INTO caoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jama, noho noma bacatapiquë tsi vaca chahitaxëni ca aqui mia pë ja bax na. Mëtsaxëniria ca yoxa quëshpi tsi mi parata quëyoria ca baquë tsi xo naa ra” nëa tsi jahuë jahëpa qui baquë rëquëmë nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Jatsi jahëpa chaniniquë: “Jatiroha ca bari tsi ë bëta xo mia ra. Nohó-na jatiroha ca xo mí-na ra. ");
INSERT INTO caoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Jaboqui no oriquino ra. Jaboqui no raniti xo, mi noma bëso nori quëshpi na. Rësonish ca jascaria ja iniquë ra. Bëno tsi ja iniquë ra, jaboqui no bëta ja nori. Jahari ja bacaquë ra” i ja qui jahuë jahëpa ni quiha —nëa tsi Jesu nëcaniquë naa chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jabi naa chani Jesú jahuë rabëti bo qui yoaniquë: —Jabi tobi ini quiha rico inish ca joni. Empleado jayani quiha jahuë yonoco ati. Jabi jahuë empleadó yomahai ca yoati tsi ja yoahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nicaxo tsi quiha jahuë empleado ja quënaniquë. “¿Jahuë ni naa rë, ë nicahana mia yoati na? Mi libro bo, mi cuenta bo, tihi cabo mi jatihuano. Jaboqui rohari tsi noho empleado inoma xo mia ra” i ja qui jahuë chama ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jatsi shinatsi empleadó huaniquë: “¿Jënahuariaxëhi ni ëa rë? Ea tsi xo toa chamayama, huai xëxëti. Jasca, parata bënati bërabipiquia” i jamë ja ni quiha. Shinahax, ");
INSERT INTO caoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“E axëti ca cahëquia ra. Noho yonoco jatiquë tsi huëstima ca rabëti bo jayaxëquia tia. Jato xobo qui ëa joihua-caxëcani quiha ra” i jamë empleado ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Japi jahuë chama ó ca cuenta jaya cabo ja quënaniquë. Quënahax, “¿Jahuë tihi ni toa mi cuenta?” i ja niquë jariapari ca jonish ca qui. ");
INSERT INTO caoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Jatsi joní quëbiniquë: “Noho cuenta tsi xo cien ca aceite lata bo rë” iquiina. Jatsi empleado nëcaniquë: “Nëa xo mi cuenta siri. Bamayamatsihuë. Cuenta paxa ca mi ano. Cincuenta lata bo huishana” i joni qui ja niquë pë, jahuë chama parahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jaquirëquë huëtsa ja nicaniquë: “¿Jahuë tihi ni mi cuenta?” iquiina. “Cien ca medida trigo moto” i joni niquë. Jatsi, “Mi cuenta siri bihuë. Ochenta roha huishana” i joni qui ja niquë pë, jahuë chama parahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Jatsi chamá toa empleado paraxëni cató ani ca nicaniquë. Nicahax, “Anomaria tsi xo toa empleadó acana ra. Nohiria, parata, tihi cabo mëquixëni ca joni tsi xo naa. Cahëxëni quiha” i chama niquë. Jabi Dios xocobo oquë tsi xo toa chahahuayamacanaibá jato jahuë bo, jato parata, jato yonoco, tihi cabo ó ja bësocanaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","‘Jabi bëroria tsi xo toa paratá tsi anoma ca acaina ra. Jama, mato paratá tsi noitiria cabo mëbicana. Tocapiquí tsi rabëti-rabëtiria bo jayaxëqui mato ra. Jatsi ma rësono tsi mato joihuariaxëhi quiha Dios, i-ipaohai ca qui ma cahëxëquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","‘Jabi jia pi jahuë ichariama ca jahuë bo otoquí tsi jia tsi huëstima ca jahuë bo otoxëhi quiha nohiria. Chahahuahacati ca nohiria tsi xo naa. Jama, jia pi jahuë ichariama ca jahuë bo otoyamaquí tsi ¿jënahuariaxo oquë ca jahuë bo ja otona? Chahahuahacatimaxëni ca nohiria tsi xo naa. ");
INSERT INTO caoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Jabi parata, nohiria jahuë bo, tihi cabo pi ó bësoti cahëyamaquí tsi ¿jënahuariaxo raca mana ca jahuë bo ó bësoti ma cahëna? ");
INSERT INTO caoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Jasca pi nohiria huëtsa jahuë bo ó bësoti mëtsama ma ino tsi ¿jënahuariaxo raca mana ca jahuë bo mato qui Diós ana, jaha ma bësono? ");
INSERT INTO caoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","‘Jabi dos ca chama bo bax yonocotimaxëni xo nohiria. Huësti ca chama qui caxaxëhi quiha; chama huëtsa noijahuanori. Huësti ca chama nicaxëhi quiha; chama huëtsa nicacasyama-jahuanori. Japi, ¿jënahuariahax raca Dios bax ma yonocona, parata noihi na? ¿Mato yonayamayamaxëhi ni parata ra? Dos ca ibo jayatimaxëni xo mato ra —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui, tihi ca chani bo yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jabi Jesu chanihai ca toa paratá-naxëni ca fariseobá nicaniquë. Nicaxo tsi quiha Jesu ja osacaniquë parata noiquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jatsi Jesu jato qui chaniquë: —Paraquí tsi nohiria bësojó tsi mamë mëstëhuaqui mato pë. Jama, mato shina yoi bo cahëhi quiha Dios ra. Ma parahai ca iqui tsi jia tsi nohiria bá mato ocahuamitsa. Jama, mahitsa tsi xo toa mato yoati ja shinacanaina. Dios qui quërasria xo toa nohiria bo ma parahaina iquia ra —i jato qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","‘Jabi Moisés quënënina, Dios Chani yoanish cabá quënënina, tihi cabo nohiria bo yoahacaniquë Juan yamabo jonox pari no. Ja joquë tsi quiha chitahëniquë chani paxa cato, naa Diós nohiria bo otohai ca yoati na. Jaha tsi jato chamá tsi Diós otohai ca qui jicocascani quiha jatiroha cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","‘Jabi jatihuahacaniquë Moisés yoba. Jama, naama-naamapaoxëhi quiha Dios yoba-yobaria. Jatihuahacayamaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","‘Jabi jocha ó tsi bësohi quiha ahui niahax ca joni, ahui huëtsa ja biquë no. Jascaria, jocha ó tsi bësohi quiha niahacahax ca yoxa bichi cato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","‘Jabi tobi iniquë quiha rico-ricoria ca joni, naa sahuëti copixëni ca sahuëhai cato. Xobo jiaxëni ca ja jayani quiha. Jasca, jatiroha ca barí tsi jia tsi ja piniquë. Ja paxnayamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jabi jahuë panë caiti ó tsi janahacani quiha joni, naa Lázaro icanai cato. Bonohuaxëni ca naa joni ini quiha. Jasca, yonocotimaxëni ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Jabi joni rico cato mesa quima ax paquëhax ca quësi mishni bo ja picasni quiha, paxnaquí na. Jasca, ja qui ina bo bëcanaca tsi jahuë bono bo ja taxocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Jarohari tsi noitiria ca Lázaro rësoniquë. Ja rësoquë tsi quiha mana, naa Abraham iti icanai ca qui ángel bá boniquë. Jaquirëquë rësoniquë rico ca ri. Rësohax ja maihuahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jatsi tënëtiyá tsi ja bëpëquëniquë tënëhi na. Jaha xo tsi quiha nëama ca Abraham, ja tapaí ca Lázaro, tihi cabo ja jisni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jisi tsi quiha Abraham ja quënaniquë: “Ea shinahuë, noho jahëpa Abrahám. Nëri Lázaro mi raano ra. Jënë qui jahuë mëtsis ja raano, noho jana matsihuaxëna. Naa chihí tsi tënëquia rë” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Jatsi Abrahám quëbiniquë: “Shinaparihuë, noho baquë́. Huëstima ca jahuë jia bo mi jayapaoni quiha bësoquí na. Toatiyá tsi noitiria Lázaro ini quiha. Jama jaboqui nëá xo Lázaro. Shoma xo ra. Jaboqui mia ri tsi xo toa tënëhaina. ");
INSERT INTO caoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Jasca, noqui naxërëquë tsi xo xëa chahitaxëni ra. Shitanoma quiha. Tori canoma xo nëá ca shitacascanaibo. Jasca, yama tsi xo toa nëri bëcanaibo toa nahax na” i ja qui Abraham ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jatsi rico inish ca chaniniquë: “Jishopë. Jatsi noba jahëpa xobo qui Lázaro raahuë, noho jahëpa Abrahám. ");
INSERT INTO caoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Cinco ca noma bo jaya xo ëa ra. Naa tënëtiya iti yoati tsi Lazaró jato yobano ra. Nëri ja bëcamitsa jato ri rë ja rësoquë no” i Abraham qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jatsi Abrahám quëbiniquë: “Moisés quënënina, Dios Chani yoanish cabá quënënina, tihi ca libro bo jayacani quiha. Jato yoba qui ja nicacano ra” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jatsi rico cató quëbitëquëniquë: “Iriama tsi xo jato yoba, noho jahëpa Abrahám. Oquë tsi xo rësonish cabo iti quima ax tërohacahax ca nohiria jato qui shishohi cahaina, jato yobaxëna. Jatsi jato jocha quima Dios quiri bësocaxëcani quiha ra nicahax na” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Jatsi ja qui Abraham chanitëquëniquë: “Moisés, Dios Chani yoanish cabo, tihi caba yoba pi nicayamaquí tsi ¿jënahuariaxo rësonish caba iti quima ax tërohacahax ca ja nicacascana ra?” i Abraham ni quiha —nëa tsi Jesu nëcaniquë nohiria bo qui chanihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jahuë rabëti bo qui Jesu chaniniquë: —Jochati tanamahacarohaxëhi quiha nohiria ra. Jama, noiti-noitixëhi quiha nohiria jochamahai cato. ");
INSERT INTO caoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Anoma tsi xo naa chahahuabëna cabo jochamahaina ra. Ja acai ca quëshpi tsi tërotamë ca rënëti maxaxa jaya tsi ia qui ja niahacarohapino tsi “Anomaria tsi xo toa copi” i no quë aquë. Jama, oquë ca copi bixëhi quiha toa nohiria huëtsa jochamahai cato iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Japi quiniacaxëcahuë. Mabë xatë pi jochano tsi raahacana. Jahuë jocha quima Dios quiri pi ja bësono tsi jahuë jocha shina-bënocana. ");
INSERT INTO caoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jasca, huësti barí pi siete tsi mato pasomaha ja jochano tsi, siete tsi “Jochaquë ëa rë” i pi mato qui ja no tsi jari jahuë jocha ma shina-bënoxëti xo iquia —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jatsi Ibo qui jahuë Chani chitahëhuati ibo bo chaniniquë: —No chitimihai ca mi anihuano —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jatsi, —Mostaza bëro tsayacana. Mishni-mishniria ca bëro tsi xo toa ra. Jama, chahitaxëni ca planta manëhi quiha toa bëro banahacahax na. Jabi mostaza planta jascaria pi ma chitimihai ca anino tsi anomariaxëhi quiha ma acaina. Jatsi “Mimë tsëquëhuë. Ia qui cata” i pi toá ca jihui qui ma no tsi mato bax caxëhi quiha ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Jatsi Jesu nëcaniquë: —Shinaparicana. Yonati mato ó ca huësti cató jayamitsa, naa mato huai xëxëhai cato, vaca ó bësohai cato. Huai ax ja joquë tsi ¿jënicanai ja qui? “Tsahohuë. Piiparihuë” ¿i ja qui canai pa? ");
INSERT INTO caoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Iyamaqui mato ra. Jama, “Noho oriquiti rohahuahuë. Shomahuahacahuë. Jaboqui piquia. Ea mi taano. Ea taaxo tsi piqui mia” iqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Pihax ja qui “Gracias” iyamaqui mato, yonati roha ja nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jabi yonati bo xo mato ri. “Yonati bo roha xo noa. No ati ca yonoco roha no aquë ra” i ma ti xo, Diós mato yoaha ca tëquë jatihuahax na. Jatsi mamë oquëhuayamacana —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalén qui cahi tsi Samaria, Galilea, tihi ca mai bo Jesu naconiquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jëni ca yaca qui ja cahëquë tsi quiha ja qui diez ca lepra jaya cabo bëcaniquë. Noitiria ca joni bo quiha. Bonohuaxëni cabo ja icani quiha. Ja bëcanaca tsi basi xo tsi Jesu ja quënacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Noqui shinahuë, taita Jesú —i quiha jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jatsi Jesú jato jisniquë. Jisi tsi quiha, —Arati ibo bo qui bocata. Jato qui mato yora bo jismacana —i jato qui ja niquë. Capama tsi quiha ja jënimahuahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jatsi huësti ca joni jahari joniquë, ja jënimahuahacani nori jisish na. Jopama tsi Dios oquëhuahi ja ini quiha “Jia xo Dios” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Johax Jesu tahë tsi ja mëniniquë. Mënihax “Gracias” i Jesu qui ja niquë ranihi na. Jabi Samariá ca carayana ca joni, naa “Gracias” inish ca ini quiha, naa jodiobo qui quëras ca nohiria. ");
INSERT INTO caoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jatsi Jesu chaniniquë: —¿Diez ca joni jënimahuahacayamayamaha? ¿Jahuënia ni toa nueve ca tëxë bo rë? ");
INSERT INTO caoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jaroha ca “Gracias” iquii ca ni naa carayana pa? ¿Bëyamacahi ni tëxë bo rë, “Gracias” ixëna? —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jatsi bacanish ca qui Jesu chaniniquë: —Joihuë. Cata. Mi chahahuahai cató mi jënimahuahacaquë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","—¿Jënino tsi nohiria bo otoxëhi ni Dios ra? —i Jesu qui fariseobo niquë. Jatsi Jesú jato quëbiniquë: —Nohiria bo ototi Diós chitahëhuano tsi mato bëró tsi jisyamaxëqui mato. Jisnoma quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ja tsi xo toa yamaxëhi quiha toa “Nëá xo ra. Toá xo ra” iti mëtsa cato, mato xërëquë ó tsi Diós otohai nori ca quëshpi na —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jatsi jahuë rabëti bo qui Jesu chanitëquëniquë: —Tsëquëxëhi quiha ma tënëti xabaca ra. Toatiyá tsi Nohiria Baquë bari, naa ë bacahai ca bari jiscasxëqui mato iquia. Jama, mato ri tsi xo toa bari jisyamaxëhaina. ");
INSERT INTO caoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Toatiyá tsi quiacaxëcani quiha nohiria, “Toá xo Cristo, nëá xo Cristo” iquiina. Tocajacano tsi boyamacana. Jato qui nicayamatsacana. ");
INSERT INTO caoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Toa barí tsi joritsixëhi quiha Nohiria Baquë, naa bajra-bajrahai ca canapa nai shitahai jascaria. Nohiria qui bëroriaxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Jama, ë bacanox pari tsi ë tënëparixëti xo. Jariapari ëa niacaxëcani quiha naa nohiria, ë qui caxaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Jasca, ë bacano tsi ë noho pasoyamacaxëcani quiha nohiria rë. Noé tiyá jascariaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Dios shinayamaquí tsi oi ó ja pasoyamacani quiha. Jënë aqui ja icani quiha. Ahui yahi ja icani quiha. Ja tocacani quiha, jahuë noti chahitaxëni ca qui Noé jicoquë rohari. Jatsi jënë bainiquë. Jatsi ja quëyohacacaniquë jato tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jasca ca ja ini quiha Lot tiyá ca nohiria bo ri. Jocha copi ó ja pasoyamacani quiha jato ri. Toatiyá tsi oriquihi nohiria bo ini quiha, raquëhaxma. Jënë aqui ja icani quiha. Tobi copihaina, iniahaina, banahaina, xobo acaina, tihi cabo aqui ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jama, yaca Sodoma ax Lot tsëquëquë tsi quiha nai ax chihi, mëshohai ca azufre, tihi cabo xapaquëniquë oi jascaria. Quëyohacani quiha toa nohiria tëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jasca, tocatsixëhi quiha Nohiria Baquë jisiquihai ca barí no ra. Toa bari ó pasoyamacaxëcani quiha nohiria pë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","‘Toa bari tsëquëno tsi bamahaxma tsi xobo cacha cabo jabano. Xobo qui ja jicoyamacano jato jahuëmishni bo bixëna. Jasca, jato xobo qui huaí ca yonococanaibo bacayamano. ");
INSERT INTO caoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot ahui shina-bënoyamacana. Ja copihacani quiha yaca qui ja bacacasni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jabi rësoxëhi quiha tsohuëcara ca jahuë shina xabahamacatsai cato. Jama, bësoxëhi quiha tsohuëcara ca jahuë shina chihohuahai cato. ");
INSERT INTO caoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Parayamaquia. Toa baquichá tsi huësti ca oxatí tsi oxa ixëhi quiha dos ca joni bo. Mëbihacaxëti xo huëstita iquia. Jisbëriahacaxëhi quiha huëtsa rë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Toa barí tsi yonoconabëquixëhi quiha dos ca yoxa bo, jato moto acaina. Mëbihacaxëhi quiha huësti cato. Jisbëriahacaxëhi quiha huëtsa rë —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jatsi, —¿Jahuënia tsi ocapixëhi ni naa ra, Ibobá? —i jahuë rabëti bo niquë. Jatsi ja quëbiniquë: —Jatiroha ca iti xo naa. Poico catihai jascaria catixëhi quiha Dios ángel bo, jochacanaibo copixëna —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jatsi naa chani jahuë rabëti bo Jesú yoaniquë, bëhoxti jato tiisimaxëna, ja shina-huëjënayamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Ja nëcaniquë: —Huësti ca yacatá tsi juez, naa copiti ibo-iboria ini quiha. Dios cahëcasyamahai ca ja ini quiha. Jasca, nohiria bo qui ja raquëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Toa yacatá tsi racani quiha bënë imanish ca yoxa ri. Jabi juez, naa nohiria bo copiti ibo-iboria qui naa noitiria ca yoxa caroha-carohaniquë. Cahax, “Ea mëbihuë. Ea yosihai ca mi copino ra” i ja qui yoxa paoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jabi naama tsi naa noitiria ca yoxa juéz mëbicasyamani quiha. Jarohari tsi yoxa qui ja yosananiquë. Yosanahax, “Toa yoxa mëbixëquia pë” i jamë ja ni quiha. “Dios, joni, tihi cabo qui raquëyamaquia. ");
INSERT INTO caoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Jama, yosaria tsi xo naa yoxa ë qui joroha-jorohahaina. Japi ë mëbiyamano tsi jari joroha-jorohaxëhi quiha pë. Toa yoxa mëbixëquia ra, ëa ja yosanamayamano ra” i jamë juez ni quiha —i Jesu niquë naa chani yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jatsi Jesu chanitëquëniquë: —Naa juez yoi cato chani nicacana. “Mia mëbixëquia” ¿i yoxa qui ja yamayamani? ");
INSERT INTO caoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nicacana. ¿Jahuë nohiria yoi bo mëbiyama-yamaxëhi ni Dios ri? Baquicha, barihani, tihi cató tsi mëbixëhi quiha, “Ea mëbihuë ra” i ja qui nohiria quë no. Bamayamaxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Bamaxoma tsi jato mëbixëhi quiha Dios iquia ra. Jama, ëa, naa Nohiria Baquë mai qui bacano tsi ichariama ixëhi quiha toa chahahuacanai ca bëhoxcanaibo iquia —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jabi tobi ini quiha mëstëxëni ca jaca nori ca quëscahuacanaibo. Jato qui naa chani Jesú yoaniquë, naa nohiria huëtsa bo oquë jaca nori ca jascahuacanaibo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ja nëcaniquë: —Dios arati xobo qui dos ca joni bo bocaniquë bëhox-xëna. Caniquë fariseobo, naa nohiria huëtsa bo oquë ja nori ca quëscahuahai cato. Jasca, bëhoxhi caniquë impuestos parata biti ibo ri, naa nohiria bo qui yoixëni cato. ");
INSERT INTO caoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Jabi arati xobó tsi fariseobo niiniquë jamë bëhox-xëna. Ja nëcani quiha: “Paratá-naxëni ma ca ëa xo naa ra, Diós. Jasca, ëa ti tsi xo nohiria parayamahaina. Yoxa mëtsaxëniria ca ma ca ëa xo naa. Mi qui ‘Gracias’ iquia, Diós, nohiria huëtsa jascama ë nori quëshpi na. Jasca, mi qui ‘Gracias’ iquia, naa nëca ca impuesto bichii ca yoixëni ca jascama ë nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Jasca, jatiroha ca semaná tsi dos bari no tsi samaquia ra. Jasca, mi qui noho parata xatë, naa décima ca mi qui aquia ra” tihi ca tsi fariseobo ini quiha, bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jama, ori pistia tsi nii quiha impuesto biti ibo iniquë. Nai qui ja tsayacasyamani quiha rabihi na. Cohuëquí tsi jahuë shipati ja tox-toxhaniquë jahuë jocha iqui na. “Ea shinahuë, Diós, jochahuaxëni ca ë nori quëshpi na” i ja ni quiha bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jabi masahacaquë toa joni jocha iquia ra. Jia tsi jahari jahuë xobo qui ja cani quiha. Jama, toa fariseobo rë. Ja bëhoxhai ca Diós nicayamaniquë. Masahacayamani quiha jahuë jocha. Jatsi quiniacaxëcahuë. Jamë oquëhuamisxënicabo tëquë noitihuaxëhi quiha Dios. Jasca, oquëhuahacaxëhi quiha jato jocha bërohuacanaibo tëquë —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jatsi Jesu qui baquë mishni bo nohiria bá bëniquë, jato ja shomahuano iquish na. Jama, jato jisi tsi jahuë rabëti bá raahaniquë; —Xocobo bëyamacahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jatsi xocobo Jesú quënaniquë: —E qui xocobo bëcano ra. Jato chitiayamacana. Nëca cabá-na tsi xo Diós otohaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mato parayamaquia. Bëroria tsi Chama Dios qui chahahuacani quiha xocobo ra. Jabi xocobo jascaria pi chahahuayamahi tsi nai qui jicoyamaxëqui mato ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jatsi huësti ca jodioba chamá Jesu nicaniquë: —¿Jënahuaxëhi ni ëa, maestro jiaxëni cató, bëso-bësopaoxëna? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jatsi Jesú quëbiniquë: —¿Jënixo tsi jiaxëni ca ëa mi quënaha? Yama tsi xo jiaxëni cato. Jaroha ca jia ca tsi xo Dios. ");
INSERT INTO caoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tonia Moisés yoba cahëqui mia tia. “Joni huëtsa ahui biyamahuë; joni ayamahuë; yomayamahuë; quiahuayamahuë; mi ipa, mi ihua, tihi cabo noihuë” tihi ca tsi ii quiha jahuë yoba —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jatsi chama chaniniquë: —Xocobo xo rohari tsi toa yoba bo tëquë ë nicaniquë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jatsi Jesú quëbiniquë joni nicaxo na. —Jari huësti ca jahuë narisqui mia axëna. Mi jahuë bo tëquë iniahuë. Iniaxo tsi noitiria cabo qui toa parata mëahuë. Tocapimino tsi naipá ca jahuë bo bixëqui mia ra. Jaquirëquë johuë. Ea mi banahuano —i joni qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nicahax cohuënaniquë chama, rico ja ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Cohuë ja ini ca Jesú jisniquë. Jatsi, —Bëroma tsi xo toa rico cabo Diós otohai ca qui jicohaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jato chama yoí tsi Diós otohai ca qui jicocascani quiha; toa quiniá tsi ja jicocanomari —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jatsi, —Yama tsi xo xabahamahacati mëtsa cato rë —i nicanish cabo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jatsi Jesú jato yoaniquë: —Jamë xabahamatimaxëni tsi xo nohiria. Dios roha tsi xo toa nohiria xabahamahaina —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jatsi Pedro chaniniquë: —Noba jahuë bo tëquë no jisbërianiquë mia banahuaxëna —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesú jato quëbiniquë: —Mato parayamaquia. Ibo Diós otohai ca iqui pi jahuë xobo, jahuë ahuini, jabë xatë bo, jahuë nabo, jahuë xocobo, tihi cabo jisbëriaquí tsi huëstima ca huino ca jahari bixëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Jaboqui bësoquí tsi oquë ca copi bixëqui mato ra. Jasca, mato bëso-bësopaomaxëhi quiha Dios ra, toa tsëquëxëhai ca xaba paxá no —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jatsi jahuë doce ca rabëti bo Jesú biniquë jato qui chanixëna. —Jaboqui Jerusalén qui caqui noa. Toá tsi jatihuahacaxëhi quiha Dios Chani yoanish cabá quënënina ëa yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Carayanabo qui ëa mëacaxëcani quiha. Mëaxo ëa mahuacaxëcani quiha pë. Ea yosicaxëcani quiha rë. E qui coshocaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Jatsi ëa rashacaxëcani quiha. Jaquirëquë namëhacaxëquia. Jama, tres barí tsi bësotëquëxëquia —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jama, Jesú yoani ca jahuë rabëti bá cahëyamani quiha. Jato joma quiha. Cahëtimaxëni ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yaca Jericó qui tsi Jesu basimano tsi quiha bahi quëpë́ tsi bëco ca joni tsaho iniquë. Parata bënahi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Tsahoxo tsi nohiria misco tarabihai ca ja nicaniquë. Nicahi tsi, —¿Tsohuë ni toa ëa tarabihaina ra? —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jatsi, —Tarabihi quiha Jesu, naa Nazarét conish cato —i ja qui nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jatsi Jesu quënatsijahuaniquë: —Ea shinahuë, David yamabá Baquë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jatsi, —Pasihuë. Pasihuë —i ja qui rëquë ca nohiria bo niquë. Japi oquë tsi ja quënatëquëniquë: —Ea shinahuë, David Baquë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jatsi Jesu niiniquë. Niihax, —Nëri toa joni bëcana —i ja niquë. Jatsi joni joniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Jahuë ó quëëhai? ¿Jënahuaxëhi ni ëa mi bax na? —i ja qui Jesu niquë. Jatsi, —Taiscasquia, Ibobá —i joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—Taishuë. E qui mi chitimihai cató tsi mi jënimahuahacaquë ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jatsi taisritsijaniquë ra. Taisxo tsi quiha banahuatsijahuaniquë, Dios qui “Gracias” iquiina. Jatsi jia tsi nohiria bá Dios ocahuaniquë, jënima ja iqui jisish na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jatsi yaca Jericó qui Jesu jicohaca tsi nacohi ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Toá tsi racani quiha joni rico cato, naa Zaqueo icanai cato. Impuesto bo bicanaibo obëso ca ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tsohuëcara Jesu iqui ca ja jiscasni quiha. Nohiria misco iqui tsi jisnoma ja iniquë rë, joni pistia ja ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Japi rëquë ja jabaniquë jihui inaxëna, Jesu jiscatsi na. Jabi ja quiri johi Jesu ini quiha toa bahí no. ");
INSERT INTO caoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Toa iti qui joxo tsi quiha mana Jesú tsayaniquë. Tsayahax, —Botëtsihuë, Zaqueó. Jaboqui mi xobó tsi ë chitëti xo —i Zaqueo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jatsi ja botëtapiniquë. Botëhax rani tsi Jesu qui joi ja amaniquë jahuë xobó tsi ja chitëno. ");
INSERT INTO caoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jatsi nohiria bo ranimisniquë ocapijani ca jisi na. Jato qui yoi quiha. —Jochahuaxëni cato xobó tsi chitëhi ja caquë pë —i jaca niquë ranimis-hi na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jatsi Zaqueo niiniquë. Niihax, —Jisa, Ibobá. Noitiria cabo qui noho jahuë mishni bo bëquëx ca axëquia ra. Huëstima cabo ë paraniquë rë, jato parata bichi na. Jaboqui cuatro veces huino jahari jato copixëquia ra —i Zaqueo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jatsi Jesu nëcaniquë Zaqueo yoati na. —Jaboqui naa xobó cabo qui joquë Diós xabahamahai ca chama ra. Abraham yamaba chahitaxocobo yoi tsi xo naa joni ra. ");
INSERT INTO caoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nëca ca bënocanaibo mërahi ë joniquë. Jato xabahamacasquia, naa Nohiria Baquë ë nori cato. ");
INSERT INTO caoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jahuë chani nohiria bá nicano tsi quiha chani huëtsa jato qui ja yoaniquë. Jerusalén qui cahëpaima ja ini quiha. Jasca, Diós otohai ca ó nohiria bo pasoni quiha chitahëti. Ja quëshpi tsi naa chani jato qui Jesú yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—Nëama ca mai huëtsa qui chama caniquë oquë ca chama bixëna. Rey manëhax jahari ja joniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jama, canox pari tsi quiha jahuë diez ca yonati bo ja quënapariniquë. Quënaxo tsi quiha jato qui huësti ca parata copixëni ca ja aniquë jato tëquë qui. Acax tsi quiha, “Naa paratá tsi iniatsacana. Yama ë no tsi ganancia bo ma ano ra” i jato qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jabi toa maí ca nohiria bá jato chama noiyamani quiha. Ja qui caxa ja icani quiha. Jabi jato chama caquë tsi quiha comisión ja raacaniquë, “Naa joni bicasyama xo noa ra, noba rey iti” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jama, rey toa joni manëni quiha. Manëhax ja bacaniquë. Bacaxo tsi quiha jahuë yonati bo ja quënaniquë, naa jahuë parata binish cabo. “Ma anihuani ca parata bo, naa mato ganancia bo jiscasquia ra” i jato qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Jatsi jariapari ca yonati ja qui joniquë. Johax, “Nëá xo mi ganancia. Jaboqui diez ca parata tsi xo ra, Ibobá” i yonati niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jatsi, “Jia tsi xo toa mi acana ra, yonati jiaxëni cató. Diez ca yaca bo mi yonano ra” i ja qui jahuë chama niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jaquirëquë joniquë yonati huëtsa. Johax, “Nëá xo mi ganancia. Jaboqui cinco ca parata tsi xo” i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jatsi, “Cinco ca yaca bo yonaxëqui mia ra” i ja qui jahuë chama niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jaquirëquë ja qui joniquë yonati huëtsa. Johax, “Pañuelo qui mi parata huësti ca ë nanëniquë jaha bësoxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mi qui ë raquëniquë, shinacoshi mi nori iqui na. Jabi mi parata pi ë bënorohano tsi ë qui mi caxaquë aquë ra. Ja tsi xo toa mi parata ó ë bësoquë, mi parata yoi jahari mi qui axëna” i yonati huëtsa niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jatsi chamá toa yonati raahaniquë: “Mi yoaha cató tsi mi qui quësoxëquia, yonati yoixëni cató. Joni shinacoshi ë nori ca cahëqui mia ra. Jabija. Raahacai ca joni ca ëa xo naa. ");
INSERT INTO caoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿Jëniriaxo tsi banco qui noho parata mi ayamani, ganancia biti? Joxo tsi noho parata, jahuë ganancia, tihi cabo ë biquë aquë ra” i yonati yoixëni ca qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jatsi, “Jahuë jahuësti ca parata mëbicahuë. Diez ca parata jaya ca joni qui acahuë” i chama-chamaria niquë toa mani cabo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jatsi toá ca mani cabá quëbiniquë: “Majia. Diez ca parata jaya xo pa” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Jabija” i chama niquë. “Huino ca copi bicaxëcani quiha jaya cabo, naa Dios bax yonococanaibo. Jasca, jahuë pistia roha ca bënoxëhi quiha chiquixëni cato. Mëbihacaxëhi quiha jahuë pistia roha cato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Japi ë qui caxacanaibo, naa ‘Noho chama-chamaria ma xo toa’ iquii cabo nëri bëcana. Bëxo tsi ëa bësojo xo tsi jato tëpascana ra” nëa tsi chama-chamaria nëcani quiha —i Jesu niquë, naa chani nohiria bo yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Chanihax, jato bëbo ca Jerusalén quinia ca bahí tsi Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jabi yaca Betfagé, yaca Betania, tihi cabo qui cahëpaima ja ini quiha, naa Maca Olivo Yá tahë ca yaca bo. Basimapama tsi quiha jahuë rabëti bo dos ca ja raaniquë rëquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—Mato bësojó ca yaca qui jicocana. Jicoxo tsi nëxë ca burro baquë jisxëqui mato. Jaha jari tsahohama ca burro quiha. Mërisxo tsi ë qui bëtsacana. ");
INSERT INTO caoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“¿Jënixo tsi mëriscanai?” i pi tsohuëcara no tsi “Bicatsi quiha Ibo” i jato qui cana —nëa tsi quiha jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jatsi raahacanish ca joni bo bocaniquë. Burro ja jiscani quiha Jesú yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja mëriscano tsi quiha, —¿Jënahuariacanai ra? —i jato qui ibo bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Jatsi, —Bicatsi quiha Ibo —i jato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Japi burro baquë Jesu qui ja bëcaniquë. Bëxo tsi quiha jato sahuëti bo ja capohuëcanaca tsi cacha Jesu ja tsahomacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jerusalén qui ja co-cono tsi quiha jato sahuëti bo nohiria bá poohaniquë bahí no. ");
INSERT INTO caoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Maca Olivo Yá ca bahi rënichihai ca iti qui ja cahëquë tsi quiha Dios ocahuatsi nohiria bá huaniquë. Jerusalén cacha ja icani quiha. Ja rani-ranicani quiha. Jisti bo tëquë ja jiscani ca quëshpi tsi joi pistiamá tsi Dios ja ocahuacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—Shomahuahaca ca tsi xo Ibobá janë́ tsi johai ca chama-chamaria ra. Naipá ca ángel bo ranicano ra. Jia tsi xo manariá ca Dios ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jatsi nohiria bo xërëquë ó ca huësti huësti ca fariseobo Jesu qui chaniniquë. —Mia banahuacanaibo pasimahuë, Taitá. Anoma tsi xo toa ja chanicanaina ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jatsi, —Mato parayamaquia. Ja pasirohapicano tsi naa bahi quëpë ca maxax bá quënaquë aquë ra —i jato qui Jesu niquë, quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén basimapama tsi aratsi Jesu niquë jisish na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Arahax ja nëcani quiha: —Jishopë. Dios xabahamati quinia cahëyamayoiqui mato rë. ¿Jënahuariaxo mato ë cahëmana rë? Mato qui jonë xo rë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tsëquëxëhi quiha xaba yoi ra, naa mato qui caxacanaibo mato qui quëtsoxëquë no. Mato paxati bahi bo quëtiacaxëcani quiha. Jatiroha ca quëpë xo tsi mato tëpascaxëcani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Jasca, mato yacata panë, mato xobo bo, tihi cabo potascaxëcani quiha rë. Jasca, mato ri quëyocaxëcani quiha rë. Matsamí, matsamí niiyamaxëhi quiha mato yacata panë maxax bo ra. Mai qui niahacayocaxëcani quiha jato tëquë, Dios xabahamati quinia ma niani iqui na —nëa tsi Jesu nëcaniquë Jerusalén ca nohiria yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jatsi arati xobo qui Jesu jiconiquë. Jicoxo tsi quiha toá ca iniacanaibo cacha raatsijahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Raapama tsi, —“Dios qui chaniti xobo quënahacati xo noho xobo” ii quiha Quënëhacanish cabo ra; jama, yomacanaiba iti manëmaqui mato pë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jatsi jatiroha ca barí tsi quiha arati xobo xo tsi nohiria tiisimahi ja iniquë. Jabi arati ibo ba chama bo, yoba tiisimacanaibo, nohiria chama bo, tihi cabá Jesu acasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Jari anoma ja icani quiha, jahuë chani nohiria bá nicacasni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Arati xobo xo tsi nohiria bo Jesú tiisimano tsi quiha ja qui arati ibo ba chama bo, yoba tiisimacanaibo, yosibo, tihi cabo bëcaniquë. Dios Chani jia ca yoahi Jesu ini quiha. Bëhax, ");
INSERT INTO caoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Noqui yoahuë. ¿Tsohuë mi qui chama aquitaha, arati xobo quima iniacanaibo niati? ¿Tocati chama jaya ni mia ra? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jatsi Jesú quëbiniquë: —Mato nicapariquia ëa ri. Ea yoacahuë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tsohuë Juan yamabo qui chama ani, nohiria ashimati? ¿Dios ni? ¿Joni ni? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jatsi ja chaninariacaniquë: —“Dios” ipinono tsi “¿Jënixo tsi Juan ma chahahuayamani?” i noqui xëhi quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jama, “Joni quima jahuë chama ja biniquë” ipinono tsi maxaxá tsi noqui axëhi quiha nohiria bo rë —i jaca ni quiha, joi i-iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Japi, —¿Tsohuëcara ni sa? Jahuënia tsi jahuë chama ja bini ca cahëyamaqui noa ra —i Jesu qui jaca niquë, quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jatsi, —Mato quëbiyamaxëquia ëa ri ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jatsi naa chani nohiria bo qui Jesu yoaniquë: —Huai joní aniquë. Axo tsi quiha toa xo tsi uva icanai ca bimi ja bananiquë. Banaxo tsi quiha joni huëtsa bo qui jahuë huai ja aquëniquë bimi xatë quëshpi na. Aquëhax tsi naama tsi quiha ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Jatsi bimitiyá tsi jahuë yonati ja raaniquë jahuë huaí ca bimi xatë biti. Jatsi pë huaí ca yonococanaibá jahuë yonati rashaniquë. Jahari mëquëyá ja raacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jaquirëquë yonati huëtsa ibobá raaniquë. Ja rashahacani quiha jaa ri. Jahuë yonati ja yosicani quiha. Jahari mëquëyá ja raacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jatsi yonati huëtsa ibobá raaniquë. Ja tsacahacani quiha rë. Cacha ja niahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jatsi, “¿Jënahuaxëhi ni ëa rë?” i huai ibo niquë. Jatsi, “Noho baquë yoi jato qui raaxëquia, naa ë noihai ca baquë. Ja qui nicacaxëcani quiha tia” i ibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jama, jahuë baquë jisi tsi quiha “Iboba baquë tsi xo naa ra” i jaca niquë. “No ano ra, jahuë bixëti ca mai mëbixëna” i huaí ca yonococanaibo niquë pë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Japi ibobá baquë ja acaniquë. Axo tsi quiha huai cacha jahuë yora ja niacaniquë. Jatsi, ¿jënahuariaxëhi ni huai ibo toa yonococanaibo qui? ");
INSERT INTO caoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Toa joni bo quëyohi joxëhi quiha ra. Quëyoxo tsi yonococanaibo huëtsa bo qui jahuë huai axëhi quiha —nëa tsi Jesu nëcaniquë toa chani yoahi na. Jatsi, —¡Jishopë! Ocapijayamano ra —i nicanish ca jodiobo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jatsi Jesú jato tsayaniquë. Tsayahax tsi quiha ja nicaniquë: —¿Jënihi ni naa Quënëhacanish cabo ó ca chani ra? “Oquënaxëhi quiha yosibá niaha ca Maxaxa ra. Oquë-oquëria ca manëxëhi quiha ra” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nicacahuë. Noitixëhi quiha naa Maxax icanai ca chahahuayamacanaibo tëquë. Toa Maxax icanai cató tsi quëyohacacaxëcani quiha ra —nëa tsi quiha jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Jatsi Jesu qui ja tsamicascaniquë, naa yoba tiisimacanaibo, arati ibo bo. Jato yoati ja chanihai nori ca ja cahëcani quiha. Jama, jari ja qui ja tsamiyamacani quiha nohiria bo qui raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Jatsi jodioba yoba tiisimacanaibo, arati ibo bo, tihi cabá Jesu tsaya-tsayaniquë acasquí na. Japi Jesu qui joni bo ja raacaniquë ja yoahai ca nicati. Jabi joni shinajiaxëni jisiria cabo ja raacani quiha; yoixëni cabo jaca nori. Romanoba chama-chamaria qui Jesu ja mëacascani quiha, ja namëhacano. ");
INSERT INTO caoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ja tsi xo toa naa bëcanish ca joni bo nëcaniquë: —Jia tsi xo mi chanihaina, maestró. Janyama ca tiisimayamaqui mia ra. Jasca, jatiroha cabo mëbicasqui mia ra. Paraxoma tsi Dios quinia tiisimaqui mia ra. ");
INSERT INTO caoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Japa? ¿Romanoba chama-chamaria qui impuesto bo no ati ni, naa noqui jodiobo? —i ja qui jaca niquë tanamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jama, ja paracascanai ca Jesú cahëni quiha. Cahëhax, ");
INSERT INTO caoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Parata ëa jismacana. ¿Tsohuë bëmana jaria ni naa ra? ¿Tsohuë ni naa quënë ibo? —i jato qui ja niquë. Jatsi, —Romanoba chama-chamaria janë quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Japi romanoba chama-chamaria qui jahuë jahuë bo tëquë acana. Jasca, Dios qui jahuë jahuë yoi bo acahuë —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jabi jia tsi Jesú quëbini quiha nohiria bo bësojo xo na. Ja quëshpi Jesu qui quësotimaxëni ja icani quiha. Jatsi ja pasicaniquë jiaria tsi ja quëbini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jaquirëquë saduceobo Jesu qui bocaniquë jato ri. “Yama tsi xo nohiria bësotëquëxëhaina” icanish cabo tsi xo naa. Jabi Jesu ja tanamacascani quiha jato ri. Ja nëcacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—“Baquë yama pi joni rësono tsi jahuë ahui biti xo jahuë noma. Bixo tsi jahuë rëquëmë bax xocobo ja saihuati xo” ii quiha Moisés yamabá quënënina, maestró —i Jesu qui jaca niquë—. ");
INSERT INTO caoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Jabi seis ca noma bo jayanish ca joni ini quiha. Xocobo saihuahaxma tsi naa joni rësoniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jatsi jahuë ahui jahuë xachacató biniquë. Xocobo saihuahaxma tsi ja rësoniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jaquirëquë jahuë ahui jahuë noma huëtsá biniquë. Xocobo saihuahaxma tsi ja rësoniquë jaa ri. Toca tsi jahuë noma bo tëquë aniquë. Ja rësoyocaniquë, xocobo saihuahaxma. ");
INSERT INTO caoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Jarohari tsi rësoniquë yoxa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","¿Jabi nohiria bo bësotëquëno tsi tsohuë ahui ixëhi ni yoxa sa? Siete ca bënë jayani quiha bësoquí na —nëa tsi Jesu qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jatsi Jesú jato quëbiniquë: —Naa mai xo tsi ahui bo yacani quiha joni bo. Bënë bicani quiha yoxa bo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jama, mana xo tsi ahui bo, bënë bo, tihi cabo jayamaxëhi quiha shomahuahaca cabo, naa bësotëquëxëcanaibo. ");
INSERT INTO caoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Rësotëquëpistia-yamariacaxëcani quiha, ángel bo jascaria iquiina. Dios xocobo ca xo, jahuë rësó tsi ja bësotëquëcaxëcanai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jatsi, “Bësotëquëxëhi ni nohiria bo” ¿icanai pa? Jabi Moisés yoani cato ó ca tsi bëroria tsi xo nohiria bo bësotëquëhaina ra. Toa noqui ja jismani quiha. “Abraham Dios, Isaac Dios, Jacob Dios” i Dios qui Moisés yamabo ni quiha, naa nihi pëtoro mëshohai cato ó tsi ja qui Dios jisiquiniquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","“Abraham yamabá Dios, Isaac yamabá Dios, Jacob yamabá Dios” iyama Moisés yamabo ni quiha, bëso jaca nori quëshpi na. Bësoyamacaba Dios ma xo Dios; jama, bësocanaiba Dios ja nori. Bëso xo Dios jaya cabo tëquë —i saduceobo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Jatsi, —Jabija tsi xo mi quëbihana, maestró —i yoba tiisimacanaibo huësti huësti cabo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jaquirëquë ja nicacasyamacani quiha raquëquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jatsi Jesú toá ca yoba cahëxëni cabo nicaniquë: —“Johai ca Xabahamati Ibo tsi xo David Baquë” ii quiha nohiria bo. ¿Jënahuariahax nëcati mëtsacahi ni? ");
INSERT INTO caoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Jabi nëca tsi libro Salmos ó tsi David yamabá quënëniquë Cristo yoati na, “‘Mia oquëhuanox pari tsi, jariapari mia pasomaha cabo bëboxëquia, jato mi yonano’ i noho Ibo qui Ibo Dios ni quiha” nëa tsi David yamabo nëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Jënahuariahax David baquë Cristo ii ni ra? “Noho Ibo” ¿i David yamabo yamayamani, Cristo yoati chanihi na? —nëa tsi jato qui Jesu nëcaniquë jato nicahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Nohiria tëquëtá nicano tsi quiha jahuë rabëti bo qui Jesu chaniniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Yoba tiisimacanaibo qui quiniacaxëcahuë. Sahuëtiria tëtëcaxëni cabo sahuëcascani quiha. Toca tsi bohocascani quiha pë. Jasca, mercado xo tsi nohiria bá jato joihuahai ca ó pasocani quiha pë. Jasca, jato catiti xobó ca rëquë ca oquëria ca tsahoti bá tsi tsahocascani quiha. Jasca, nohiria oriquiti catino tsi oquë ca tsahoti bá tsi tsahocascani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jasca, bënë imanish ca yoxa bo paracani quiha, jato jahuë bo mëbixëna. Paraquí tsi jato xobo bo mëbicani quiha pë. Mëbihax Dios qui chani tëtëca tsi bëhoxcani quiha ra, nohiria bo paraxëna. Quësohacacaxëcani quiha ra. Oquëxëhi quiha jato copi ra —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Arati xobó tsi niipama tsi parata biti caja qui nohiria rico cabá jato parata nanëhai ca Jesú tsaya-tsayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Tsayajahuano tsi quiha noitiria ca bënë imanish ca yoxá dos ca parata copiriama cabo nanëniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisniquë Jesu. Jisi tsi, —Nohiria huëtsa bá nanëhaca parata huino tsi xo naa noitiria ca yoxá acana ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Narisxoma tsi parata ja acana quiha. Jama naa yoxa ra. Noitiria xo. Jatiroha ca ja jaya ca ja aquë ra; naa jahuë oriquiti copiti parata —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Templo, naa jato arati xobo yoati tsi chanihi quiha huësti huësti ca rabëti bo iniquë. Jahuë maxax jiaria cabo, templó ca jianati jahuë bo, naa nohiria bá anina, tihi cabo yoati tsi chanihi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jatsi Jesu jato qui chaniniquë: —Tsëquëxëhi quiha xabaca ra, naa ma tsayahai ca potas-hacaxëquë no. Poxahacaxëhi quiha jahuë maxax bo tëquë. Yamaxëhi quiha matsami matsami niihai ca maxax bo iquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jatsi, —¿Jënino tsi potas-hacacaxëcahi ni? ¿Jënahuariaxo tsi cahëxëhi ni noa, ocapijaxëquë no, Maestró? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jatsi Jesú yoaniquë: —Quiniacaxëcahuë, ma parahacayamano. Joxëhi quiha huëstima ca noho janë́ tsi chanicanaibo. “Cristo xo ëa” icaxëcani quiha pë. “Tsëquëpaimaria xo jaroha ca bari ra” icaxëcani quiha. Jato banahuayamacana ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jasca pi país bo nianahaina, país ca xërëquë ca nohiria iquinahaina, tihi cabo nicahi tsi raquëyamatsicana. Toca tsi ja ixëti xo. Ocapijano tsi jari basi tsi xo toa jahuë rëso. ");
INSERT INTO caoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jariapari tsi país huëtsa pasomaha nianaxëhi quiha país huëtsa. Chama huëtsa pasomaha iquinaxëhi quiha chama huëtsa. ");
INSERT INTO caoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yajoriaxëhi quiha mai. Oriquiti narisxëhi quiha nohiria bo. Iquicaxëcani quiha huëstima cabo. Jasca, raquëriaxëhi quiha nai qui tsaya-tsayahaina. Jahá tsi jisiquixëhi quiha mana ca jisti-jistiria bo ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Jama, ja tocapinox pari no tsi mato qui pari tsamicaxëcani quiha ra. Mato tënëmacaxëcani quiha. Arati ibo bo qui mato mëacaxëcani quiha. Preso qui mato nanëcaxëcani quiha. Tihi ca tsi acaxëcani quiha noho janë tahëxo na. ");
INSERT INTO caoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jatsi, toatiyá tsi xaba jayaxëqui mato jato qui Dios Chani yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Tocapijano tsi jato bësojo ax tsi ma chanixëti ca yoati tsi shinayamatsacana. ");
INSERT INTO caoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Toatiyá tsi chani-chaniti chama, tiisi, tihi cabo mato qui axëquia. Ja iqui tsi pasimahacaxëhi quiha toa mato qui caxacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jasca, chama bo qui mato mëaxëhi quiha mato nabo, mabë xatë bo, mato jimibo, mato rabëti bo. Jatsi, mato ó ca huësti huësti ca namëcaxëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Noho janë tahëhax tsi mato qui caxacaxëcani quiha jatiroha cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Jama, mato ó bësoxëquia mato ja motsayamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chamatsicana. Xabahamahacaxëhi quiha mato naamapihi na —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","—Soldado bo Jerusalén tëayohai ca jisi tsi quëyohacati basima ja nori ca cahëxëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Jatsi maca bo qui jodioba maí cabo jabaxëti xo. Jisbayaxëti xo Jerusalén cabo. Xabachá cabo yaca qui bacayamaxëti xo ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nohiria bo copiti xaba tsi xo naa. Toatiyá tsi jatihuahacaxëhi quiha Quënëhacanish cabo iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Noitixëhi quiha tohoya cabo, baquë pistia ico cabo rë. Anomariaxëhi quiha toa maí ca nohiria bá tënëhaina iquia. Anomariaxëhi quiha jato qui Dios caxahaina. ");
INSERT INTO caoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Saipí tsi tëpas-hacaxëhi quiha huëstima cabo. Nëxahacaxëhi quiha huëstima cabo, país bo tëquë qui ja bohacacano. Jasca, Jerusalén tsi bohocaxëcani quiha carayanabo jato xaba jatiquë rohari. ");
INSERT INTO caoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","‘Naipá tsi jisiquixëhi quiha jisti bo ra. Yoyoxëhi quiha bari, oxë, huishti bo. Shina-huëjënaxëhi quiha maí ca nohiria tëquëta. Jasca, raquëria ixëhi quiha ia bo ri. Jahuë pacotsa, jahuë yoyohai ca choca bo, tihi cabo qui raquëcaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Toatiyá tsi rësocaxëcani quiha nohiria raquëhi na. Jahuëcara ó pasoti cahëyamacaxëcani quiha, naipá ca jahuë bo yajohacaxëhai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jatsi tsëmó tsi Nohiria Baquë johai ca jiscaxëcani quiha. Noho chama, noho oquë, tihi cabo jiscaxëcani quiha ë joxëquëno. ");
INSERT INTO caoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Naa jahuë bo tëquë ocapiti chitahëno tsi chamacana. Jaha bësocahuë. Joti basima tsi xo ma xabahamahacahaina —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jatsi naa chani Jesú yoaniquë jato cahëmaxëna: —Higuera jihui, jihui huëtsa bo, tihi cabo qui tsayacahuë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ja botoxpicano tsi basima oitiya nori ca cahëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jascaria, ë yoaha ca jahuë bo ocapiti chitahëno tsi basima Diós otohai nori ca cahëxëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Mato parayamaquia. Naa bësohai ca nohiria bo rësonox pari no tsi ocapixëhi quiha ë yoahaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Huinocaxëhi quiha naipá ca jahuë bo, naa mai ri, jama, huinoca-pistiayamariaxëhi quiha noho Chani. Jabija tsi xo naa ë yoahaina. ");
INSERT INTO caoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","‘Quiniacaxëcahuë. Pabëhaina, jënë acaina, maí ca jahuëmishni bo, tihi cabo tsi shina-shinayamacana. Tocapimano tsi mato ratiaxëhi quiha toa bari, jaha ma pasoyamahai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Jatiroha ca maí ca nohiria bo ratiaxëhi quiha ë johaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Japi rohahuahacacahuë. Bëhoxrohacana, chama ma jayacano iquish na, naa jahuë bo tëquë paxaxëna, Nohiria Baquë bësojó tsi niixëna —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Toa bari bo Jesú raaniquë arati xobó no, toa xo tsi nohiria bo tiisimahaina. Jama, Maca Olivo Yá tsi baquicha ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Jabi baquishmarí tsi nohiria bocani quiha arati xobo qui Jesu nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tsëquëti basima quiha jodioba pascua fiesta iniquë. Toatiyá tsi levadura yama ca mapari ja picani quiha. Jato jabi quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jasca, Jesu ati quinia mërahi ini quiha arati iboba chama bo, jato yoba tiisimacanaibo ri. Nohiria bo qui raquëquí tsi quiha bëroxo tsi Jesu ja acasyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jatsi Judas qui Satanás jiconiquë, naa Iscariote icanai cato. Jesu doce ca rabëti bo huësti ca ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Jatsi arati ibo bo, arati xobo obëso cabo, tihi cabo qui Judas caniquë chanixëna. Jato qui Jesu ja mëacasni quiha. Cahax, jato bëta ja chaninaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Jatsi ja ranicaniquë ja yoani ca nicahax na. Ranihax, —Parata mi qui axëqui noa ra —i Judas qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jatsi, —Jënima —i Judas niquë. Japi Jesu qui tsamiti xaba mëratsi-jahuaniquë, nohiria bá cahëyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jatsi jato levadura yama ca mapari piti fiesta tsëquëniquë, naa oveja baquë acacaquë no. ");
INSERT INTO caoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Japi Pedro, Juan, tihi cabo Jesú raaniquë. Raahax, —Bocata. Pascua oriquiti ma rohahuano piti —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jatsi, —¿Jahuëniaxo tsi rohahuaxëhi ni noa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jatsi, —Yaca qui jicocana. Toa xo tsi chomó ca jënë bëhai ca joni bëchaxëqui mato. Toa joni banahuacana, ja jicohai ca xobo qui. ");
INSERT INTO caoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Jatsi toa xobo ibo qui chanicana. “‘¿Jahuënia ni naquëtë?’ ii quiha Maestro” i ja qui cana. “Nëa xo tsi jahuë rabëti bo yaxo tsi pascua oriquiti picatsi quiha” icana. ");
INSERT INTO caoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jatsi mana ca naquëtë chahitaxëni ca mato jismaxëhi quiha; tsahoti bo, mesa, tihi cabo rohahuahaca ca naquëtë quiha. Toa xo tsi oriquiti rohahuacana —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Jatsi Pedro, Juan, tihi cabo bocaniquë. Ja bocanaca tsi naquëtë qui ja cahëcaniquë Jesú yoani jascaria. Cahëxo tsi quiha pascua oriquiti ja rohahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Jatsi tëxë bo ya tsi Jesu joniquë. Tsahohax oriquitsijacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Oriquipama tsi Jesu jato qui chaniniquë: —Naa pascua oriquiti mato bëta oriqui-casquia rësonox pari. ");
INSERT INTO caoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jabi nëa xo tsi naa pascua oriquiti pitëquëpistiayamariaxëquia Diós otohai cato xo tsi ja jatihuahacaxëquë rohari. Jaquirëquë pitëquëxëquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jatsi copá ca jënë ja bihaca tsi “Gracias” i Dios qui ja niquë. —Bicahuë. Ayocana. ");
INSERT INTO caoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nëa xo tsi uva bimi jënë atëquëyamaxëquia Diós otohai joxëquë rohari —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jatsi mapari Jesú biniquë. Bichi tsi quiha “Gracias” i ja niquë. Bëquëx-xo tsi jato qui ja aniquë ja picano. —Noho yora tsi xo naa. Picahuë, ëa shinaquí na —i quiha ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Oriquixo tsi quiha copá ca jënë jato qui ja aniquë ja acano. Acax, —Noho jimí tsi Dios xabahamati quinia paxa ca jismahi quiha naa jënë. Mato bax japahacaxëhi quiha noho jimi ra. ");
INSERT INTO caoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Tsayacahuë. No bëta tsaho tsi xo toa ëa pasomaha cato rë, naa chama bo qui ëa mëacatsai cato. ");
INSERT INTO caoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jabi rësoxëti xo Nohiria Baquë ë nori cato. Diós yoani ca tsi xo naa ra. Jama, noitiriaxëhi quiha toa ëa chama bo qui mëaxëhai cato iquia —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jatsi chaninatsi jahuë rabëti bo niquë: —¿Tsohuë cara ni toa no nohó ca Jesu pasomaha cato sa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jatsi joi i-ibëqui tsi quiha Jesu rabëti bo niquë, naa jato xërëquë ó ca oquë ca ixëti nori ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jatsi jato qui Jesu chaniniquë: —Jato nohiria bo yonahi quiha maí ca chama bo. Yonahi tsi “Nohiria Rabëti bo xo noa” icani quiha pë, jato rabëti bo jaca nomari. ");
INSERT INTO caoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jabi toca ma xo noa ra. Yonati jascaria manëxëti xo mato xërëquë ó ca oquë cato. Tëxë bo ja mëbixëti xo. ");
INSERT INTO caoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mato nicaquia. ¿Tsohuë ni toa oquë cato? ¿Tsaho ca pihai ca ni? ¿Taahai ca ni? Tsayacahuë. Jato yonati bá tsi taahacahai ca ó pasocani quiha tsahohai ca chama bo. Jama, nëá xo ëa, mato xërëquë ó no. Ea ti tsi xo toa mato taahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","‘Mato tsi xo toa ë qui chitimihax cabo, naa ë tënëtiyá no. ");
INSERT INTO caoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Jaboqui yonati chama-chamaria mato qui aquia, noho jahëpa ë qui ani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Noho mesa ax oriquiti tsahoxëqui mato ë yonahai cató no. Jasca, trono bo xo tsi Israél ca doce ca xatë bo ó bësoxëqui mato ra —nëa tsi quiha jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—Ea nicahuë, Simón —i Jesu niquë—. Jochati mato tëquë tanamacatsi quiha Satanás ra. ");
INSERT INTO caoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Jama, mi bax ë bëhoxquë, Simón, mi chahahuahai ca quima mi casoyamano. Jasca, jahari ë quiri bësoxo tsi mibë xatë bo mi chamahuano —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jatsi Pedró quëbiniquë: —Mia jisbëriapistiayamaxëquia ra. Preso qui pi mia ja nanëcano ri tsi mi bëta cahai ca ëa xo naa ra. Mi bëta rësoti qui raquëyamaquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jatsi, —Mia parayamaquia, Pedró. Ea pasomaha chaniti basima xo mia rë. Jaboqui patiari quëonox pari no tsi tres tsi “Jesu cahëyamaquia” ixëqui mia ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jatsi jahuë rabëti bo qui Jesu nëcaniquë: —Mato ë raaquë tsi ¿jahuë ma narisni? Mëquëya ma raahacani quiha. Parata, sota, zapato bo, tihi cabo yahaxma tsi ma bocani quiha —iquiina. Jatsi, —No narisyamahitaquë ra —i jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jatsi Jesú quëbiniquë: —Jaboqui pi parata jayaquí tsi bocahuë. Sota pi jayaquí tsi bocahuë. Saipi pi jayamaquí tsi mato sahuëti iniacahuë copixëna. ");
INSERT INTO caoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Mato parayamaquia. Jatihuahacaxëti xo Quënëhacanish cabo, naa “Caxaxëniria ca jascaria ja tocahacaxëti quiha” iquiina. Parayamaquia. Jatihuahacaxëhi quiha jatiroha ca ëa yoati Quënëhacanish cabo ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jatsi jahuë rabëti bo nëcaniquë: —Tsayapa, Ibobá. Nëá xo dos ca saipi bo ra —iquiina. Jatsi, —Iquë pë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xobo jisbaya tsi quiha Maca Olivo Ya qui Jesu caniquë bëhoxhi na. Jahuë jabi quiha. Jasca, ja bëta bocani quiha jahuë rabëti bo ri. ");
INSERT INTO caoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Cahax, —Bëhoxcana, jochati ma tanamahacayamano ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jatsi ori pistia jamëpistia tsi Jesu caniquë bëhoxhi na. Basima quiha. Mënihax Dios qui chanitsijaniquë: ");
INSERT INTO caoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—Mi qui pi jia no tsi naa johai ca tënëtiya mëbihuë, noho Jahëpá. Tënëcasyamaxo ëa ra. Jama, jaha ë quëëhai ca mi ayamano. Mi shina mi ano ra —i Jesu niquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jatsi ja qui naipá ca ángel jisiquiniquë chamahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Shina jii-jiitsi Jesu niquë bëhoxhi na. Jatsi ja bëhox-bëhoxrianiquë. Niscatsijani quiha. Jimi tioihai jascaria ja niscani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Bëhoxhax ja joiniquë. Joihax jahuë rabëti bo qui ja bacaniquë. Oxa ja icani quiha cohuëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jatsi, —¿Jënihax oxacanai rë? Joicana. Bëhoxcana, jocha qui ma paquëyamano —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jahuë rabëti bo ya jari chanihi Jesu iniquë. Chanijano tsi quiha nohiria misco bëcaniquë. Jato bëta Judas, naa doce ó ca huësti ca iniquë jaa ri. Jato mëpihi ja ini quiha Jesu qui. Cahëhax Jesu qui ja basimaniquë tatsoxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jatsi ja qui Jesu chaniniquë: —¿Ea tatsohai pa? ¿Toca tsi soldado bo qui ëa mëaxëhai rë, naa Nohiria Baquë ë nori cato? —i Judas qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ocapijahai ca jisi tsi, —¿Noba saipí tsi jato tëpasxëhi ni noa, Ibobá? —i ja bëtanish ca rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jatsi jato ó ca huësti cató toá ca arati ibo-iboria yonati paxtianiquë. Jahuë mënëcayá ca pahoqui paxtiahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jatsi, —Iquë ra. Iquë ra. Iquinayamacana —i Jesu niquë. Jatsi yonati pahoqui motsaxo tsi ja jënimahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jënimahuahax arati ibo bo, arati xobo obëso ca capitán bo, yosibo, tihi ca bëcanish cabo qui Jesu chaniniquë: —¿Saipi bo, tëpasti jihui bo, tihi cabo jaya ni mato pa? ¿Yomaxëni ca bichii jascaria ëa bichi ma bëcana pa? ");
INSERT INTO caoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Jatiroha ca barí tsi mato bëta ë i-ipaoyamëquë, arati xobó no. ¿Jëniriaxo tsi ëa ma biyamahita, toá tsi ë iquë no? Jishopë. Jaboqui mato xaba tsi xo naa rë. Jaboqui bëroria tsi yonahi quiha Satanás pë —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jatsi Jesu qui ja tsamicaniquë. Tsamixo tsi ori ja bocaniquë arati ibo ba chama xobo qui. Jesu basi tsi Pedró banahuaniquë raquëquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Arati ibo ba chama xobo qui cahëxo tsi quiha soldado bá chihi maponiquë huënënë xo na. Tsamahax ja tsahocaniquë yohoxëna. Jasca, jato xërëquë tsi Pedro tsahoniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Chihi tapaí tsahojano tsi quiha xotacó Pedro jisniquë, naa toá ca yonati cato. Pedro ja tsaya-tsayani quiha. —Jesu ya naa joni iquë ra —i xotaco niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Jatsi Pedró quëbiniquë: —Jesu cahëyamahai ca ëa xo naa ra, caí —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jaquirëquë joní tsayaniquë. Tsayahax, —Tonia Jesu rabëti huësti ca xo mia ra —i Pedro qui ja niquë. Jatsi, —Jahuë rabëti ma xo ëa ra, joní —i Pedro niquë rë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jaquirëquë huësti ca hora huinocaquë tsi, —Tonia Jesu ya naa joni iquë ra. Nicacapa. Galileá joi jaya xo ra —iriatsi joni huëtsa niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Jatsi Pedró quëbiniquë: —E joma mi chanihaina ra, joní —iquiina. Jari Pedro chanino tsi quiha patiari quëo-quëoniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jatsi Pedro quiri bësohax Jesú bëisniquë cohuëquí na. Jatsi Ibobá yoaha ca Pedró shinaniquë, naa “‘Tres tsi cahëyamaquia’ ixëqui mia rë, patiari quëonox pari no” i Jesu quë no. ");
INSERT INTO caoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jatsi cacha Pedro caniquë. Cahax ja ara-araniquë rabihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jatsi Jesu mahuatsi jaha bëso cabá huaniquë. Ja sëtiacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Bëmapahax, —¿Tsohuë mia aca? Noqui yoahuë ra —itsi quiha jaca niquë nicahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Huëstima tsi Jesu ja ocahuacani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Huëaquë tsi baquishmarí tsi quiha nohiria yosibo, arati ibo ba chama bo, yoba tiisimacanaibo, tihi cabo catiniquë chaninaxëna. Jato bësojó tsi Jesu mëpihacani quiha toá tsi ja niino. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—¿Diós noqui raani ca Xabahamati Ibo ni mia ra? Noqui yoahuë ra —i Jesu qui chama bo niquë. Jatsi Jesú quëbiniquë: —“Jaahuë” i pi ë no tsi ëa chahahuayamaxëqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Jasca pi mato ë nicano tsi quëbiyamaxëqui mato tia. ");
INSERT INTO caoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Jama, basima tsi xo toa Dios chama ë bixëhaina ra, naa Nohiria Baquë ë nori cato. Chamaxëni ca Dios mënëcayá tsi tsahoxëquia ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jatsi, —¿Japa? ¿Dios Baquë ni mia ra? i jaca niquë jato tëquëta. Jatsi, —Jaahuë. Ja xo ëa ra —i Jesu niquë quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Jatsi ja nëcacaniquë: —Jahuë chani yoi ca no nicaquë ra. Jamë quësohi quiha ra. Ja pasomaha ca chanihai ca huëtsa no nicatima xo ra —i toá ca chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Jatsi jodioba chama bo tëquë joiniquë. Joixo tsi quiha Pilato qui Jesu ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Boxo tsi quiha Jesu qui quësotsijacaniquë pë: —Janyama noba nohiria mëpihi quiha naa joni ra. Gobierno pasomaha xo ra. “Romanoba chama-chamaria qui impuestos parata ayamacahuë” i nohiria bo qui quiha. Jasca, “Nohiria Xabahamati Ibo, naa nohiria ba chama xo ëa” ii quiha pë —nëa tsi quiha Pilato qui jodioba chama bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jatsi Pilató Jesu nicaniquë: —¿Jodioba chama-chamaria ni mia? —iquiina. Jatsi, —Jaahuë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jatsi arati iboba chama bo, nohiria misco, tihi cabo qui Pilato chaniniquë: —Yama tsi xo naa joní yoi ca anina iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Jama, jari Jesu ja ocahuacaniquë pë: —Jodioba mai tëquë xo tsi tiisimapama tsi romanobo pasomaha nohiria bo caxahuahi quiha ra. Galilea mai pari tsi ja chitahëhuaniquë tiisimaxëna. Jaquirëquë jodiobá mai qui ja cani quiha. Jarohapa tsi nëa tsi ja johitaquë pë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jato nicahax, —¿Galilea mai quima ax naa joni joni? —i Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","—Jaahuë —i nohiria bo quë tsi chama Herodes qui Pilató Jesu raaniquë, Galileá ca nohiria bo Herodés yonani quëshpi na. Jabi naatiyá tsi Jerusalén tsi Herodes ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jatsi Herodes raniniquë Jesu jiscatsi na. Jistiria Jesú acai ca ja jiscasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Japi Jesu ja nica-nicarianiquë. Mahitsa quiha. Quëbiyamaniquë Jesu. ");
INSERT INTO caoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jabi Herodes ya tsi quiha arati iboba chama bo, yoba tiisimacanaibo, tihi cabo mani iniquë jato ri. Jesu qui ja quëso-quësocaniquë pë. Anomaria ini quiha ja qui ja quësocanaina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jatsi jahuë soldado bo yaxo tsi Jesu mahuatsi Herodés huaniquë. Mahuaxo tsi quiha sahuëti copixëni ca Jesu ja sahuëmacaniquë, chama-chamaria jisiria ca manëmaxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Jabi naama tsi Herodes, Pilato, tihi cabo caxanapaoni quiha. Jaquirëquë tsi quiha ja rabënacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jatsi arati iboba chama bo, rëquëninicanaibo, nohiria bo, tihi cabo Pilató quënaniquë catiti. ");
INSERT INTO caoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—E qui naa joni ma bëquë ra, “Romanoba gobierno pasomaha nohiria bo mëpihai ca tsi xo naa” iquiina. Jama, ë nicaquë mato bësojo xo na. Mahitsa ja qui quësoqui mato pë. Yama tsi xo toa janyama ca ja acana iquia. ");
INSERT INTO caoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jascaria, ja qui quësoyamahi quiha Herodes ri, jahari noqui ja raaha quëshpi na. Ja namëhacatima xo ra. Yama tsi xo toa janyama ca ja anina ra, namëhacati. ");
INSERT INTO caoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Japi rashaxëquia. Rashaxo tsi paquëmaquia —i jato qui Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Jabi Pascua fiestá tsi huësti ca achiqui ca ja paquëmapaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Jatsi quënatsi nohiria tëquëtá huaniquë: —Jesu ahuë ra. Barrabás paquëmahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jabi preso qui Barrabás nanëhacani quiha, yacata xo tsi gobierno pasomaha nohiria bo ja mëpini iqui na. Iquinaxo nohiria bo ja ani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jama, Pilató Jesu paquëmacasni quiha. Mahitsá nohiria bo qui ja chani-chaniniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","—Cruzó tooxahuë. Cruzó tooxahuë —iriatsi nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Jatsi nohiria bo qui Pilato chanitëquëniquë: —¿Jëni ni ra? ¿Jahuë janyama ca ja ani? Ja namëhacayamati xo ra iquia. Yama tsi xo toa janyama ca ja anina ra. Japi ë rashano. Rashaxo tsi paquëmaxëquia —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jama, bamayamaniquë nohiria bo pë. Joi pistiamá tsi quiha, —Cruzó tsi tooxahuë. Cruzó tsi tooxahuë —i jaca niquë. Jarohapa tsi jato joi pacotsa iqui tsi jato qui Jesu ja mëaniquë ja acano. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","—Ja namëhacati xo —i Pilato niquë, jaha ja quëëcani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Jatsi jato qui gobierno pasomaha inish ca Barrabás, naa nohiria ati ibo preso quima ja paquëmaniquë. Jama, Jesu jato qui ja mëaniquë ja namëhacano. ");
INSERT INTO caoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ori cruz Jesu mëpipama tsi quiha joni, naa Simón Cirene icanai ca qui ja tsamicaniquë Jesu cruz iati. Jerusalén qui jicohi ja ini quiha, ja tsamicaquë no. Jabi jahá cruz ja janacani quiha Jesu cho iati. ");
INSERT INTO caoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jabi huëstima ca nohiria bá Jesu banahuaniquë. Jato xërëquë tsi araconacanai ca yoxa bo iniquë jato ri noihi na. ");
INSERT INTO caoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jatsi jato quiri Jesu bësohaca tsi ja chaniniquë: —Ea iqui tsi arayamacahuë, Jerusalén ca jahi bá. Tënëxëqui mato ri. Jasca mato xocobo ri. Ja tahëhax aratsicahuë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Joxëh quiha tënëti xabaca rë. Toatiyá tsi “Shomaria tsi xo baquë yama ca yoxa bo ra” icaxëcani quiha nohiria. ");
INSERT INTO caoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Toatiyá tsi maca bo qui quënaxëhi quiha nohiria, “Noqui maxëni paquëcahuë. Noqui mapacahuë” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Jabi nëca pi ëa, naa mëstëxëni ca ja tënëmacano tsi ¿jënahuariaxëhi ni Dios chahahuayamacanaibo qui? —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jasca dos ca caxaxëniria ca joni bo ri ja bëcaniquë Jesu ya namëxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mapo Xao Ya icanai ca qui cahëxo tsi quiha cruzó tsi Jesu ja tooxacaniquë. Jasca, ja bëta dos ca caxacanaibo tooxahacani quiha jato ri. Huësti ca jahuë mënëcayá no; huësti ca jahuë mëxojó no. ");
INSERT INTO caoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jatsi Jesu chaniniquë: —Jato jocha shina-bënohuë, noho Jahëpá. Ja acanai ca cahëyamacani quiha rë —i Jesu niquë. Jatsi jahuë sahuëti bo soldado bá biniquë. Bixo tsi quiha jato xërëquë xo tsi jahuë sahuëti bo ja oquëxhuacaniquë i-ihai cató no. ");
INSERT INTO caoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jasca toá tsi nohiria bo niiniquë tsayahi na. Toá tsi ini quiha jodioba chama bo jato ri, mahuahi na. ");
INSERT INTO caoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ja qui mahuani quiha soldado bo ri. Ja qui ja bëcanaca tsi mocaria ca jënëria ja qui ja acaniquë ati. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—Jodioba chama-chamaria pi iqui tsi mimë xabahamahuë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jatsi jahuë mapo maxcacha naa chani janahacaniquë: “Jodioba chama-chamaria xo naa” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jatsi Jesu tapaí ca tooxahacanish ca huëstitá ocahuaniquë jaa ri. Mahuahax, —¿Xabahamati Ibo ni mia? Mimë xabahamahuë. Jaquirëquë noqui xabahamahuë ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jama, tooxahacanish ca joni huëtsá raahaniquë: —¿Dios qui raquëyamahai? Nëa rësohi quiha mia ra, naa joni jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","No copihacaquë, no ani ca yoi ca quëshpi na. Jama xo naa joni ra. Yama tsi xo toa janyama ca ja anina ra —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jatsi Jesu qui ja chaniniquë: —Ea shina-bënoyamahuë, Jesú, naa mi otohai ca qui mi jicoquë no —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jatsi ja qui Jesu chaniniquë: —Mia parayamaquia. Jaboqui ë bëta-xëhi quiha mia ra tërohama caba ití no —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jabi matoroco bari tsi ja iniquë, mai tëquë tsëmonaquë no. Tres hora no tsi ja baquishni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Jisiquiyamaniquë bari ra. Jasca, arati xobó ca rotamë ca quëbëti raiti jaxcahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jatsi Jesú quënaniquë: —Mi qui noho shina aquia, noho Jahëpá —iquiina. Chanihax ja naniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ocapijani ca jisi tsi quiha toá ca niihai ca capitán Diós oquëhuaniquë, —Mëstëxëni ca joni ja iquë tia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Jesu namëhai ca jisi tsi jahari jato xobo qui quëtsonish ca nohiria bocaniquë. Cohuë ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jasca, basi tsi quiha Jesu rabëti bo tëquë mani iniquë. Toá tsi ini quiha Galilea ax ja bëta bëcanish ca yoxa bo ri. Basi xo tsi naa jahuë bo tëquë ja tsayacani quiha raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tobi joni shinajiaxëni ca iniquë, naa José icanai cato. Jodioba yobahai ca yosibo xatë ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Jabi Jesu toa jodioba chama bá acasquë tsi quiha jato ati yoba pasomaha ja chanini quiha. Jasca, yaca Arimateá tsi ja raca-racani quiha jodioba maí no. Jabi Diós nohiria bo otohai ca ó pasohi ja ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jabi Pilato qui José caniquë. Caxo tsi quiha Jesu yora ja bënaniquë maihuati. ");
INSERT INTO caoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jatsi Jesu yora ja botëmaniquë. Botëmaxo tsi quiha ja yaboniquë raiti miro cató no. Yaboxo tsi quiha maxax ó ca quini ó tsi, naa huëyohaca ca quini ó tsi ja jananiquë. Maihuati quini paxa ja ini quiha. Jari jaxara janahacayamani quiha yora. ");
INSERT INTO caoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jabi pascua fiesta rohahuati bari ja iniquë, Jesu ja maihuacaquë no. Jodioba joiti bari chitahëpaimaria ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Jabi José ya bocani quiha yoxa bo ri, naa Jesu ya Galilea ax bëcanish cabo. Jahuë mai ja jiscani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jaquirëquë jato xobo qui ja bacacaniquë perojome, yora chëxati, tihi cabo rohahuaxëna. Jama, jahari jahuë yora rohahuahi canoma ja icani quiha, jato joiti bari chitahëni nori iqui na. Japi toa barí tsi quiha ja joicaniquë jato jodioba yoba tahëhax na. ");
INSERT INTO caoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Domingó tsi Jesu maiquini qui yoxa bo bacaniquë. Baquishmari ja ini quiha. Perojome bo ja jayacaniquë, naa ja rohahuahacanish ca perojome yora chëxati. ");
INSERT INTO caoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jahuë maiquini qui cahëxo tsi quiha jahuë maiquini quëbëti maxax chahitaxëni ca ja yopacaniquë. Bahama ja tarahacani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Maiquini qui jicoxo tsi quiha Iboba yora ja yopacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yama a. Jatsi, —¿Jahuënia cara ca jahuë yora sa? —i jaca ni quiha yopahax na. Shinajahuacano tsi quiha jato tapaí niitapiniquë dos ca ángel bo. Joni jisiria ca ja icani quiha. Bajra-bajrani quiha jato raiti, canapa jascaria. ");
INSERT INTO caoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jatsi raquëniquë yoxa bo tsayahax na. Raquëhax jato bësojó ja rënicaniquë. Jatsi jato qui ángel bo chaniniquë: —¿Jëniria xo tsi maiquini xo tsi bësohai ca mëracanai pa? ");
INSERT INTO caoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yama xo ra. Ja tëronojaquë ra. ¿Jahuë mato ja yoani, Galileá tsi mato bëtaquí na? ");
INSERT INTO caoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Jochacanaibo qui mëahacaxëti xo Nohiria Baquë, cruzó tsi ja tooxahacano” ¿i ja yamayamani? “Tres bari quirëquë bësotëquëxëquia” ¿i ja yamayamani? —nëa tsi yoxa bo qui ángel bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Jatsi Jesú yoani ca yoxa bá shinaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Shinaxo tsi quiha jahuë maiquini ja jisbayacaniquë. Jahari jato xobo qui ja bocani quiha. Xobo qui cahëxo tsi ángel jato yoani ca tëquë ja yoacaniquë Jesu once ca rabëti bo qui. Tëxë bo tëquë yoahacani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Jabi Dios Chani chitahëhuati ibo bo yoanish ca yoxa bo tsi xo naa: María Magdalena, Juana, Jacobo jahëhua María, jato bëta ca yoxa huëtsa bo, tihi cabo ini quiha, naa jahuë maiquini qui bocanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Jama, yoxa bo nicaxo tsi quiha Jesu rabëti bá chahahuayamaniquë, ja paracanai ca quëscahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Jama, Pedro joiniquë jisi caxëna. Jahuë maiquini qui ja jabaniquë. Maiquini qui cahëhax ja tëtoniquë jaxara tsayaxëna. Yabohaca ca raiti roha ja jisniquë. Yora yama. Jatsi xobo qui jahari ja caniquë jënipijani ca qui ratëhi na. ");
INSERT INTO caoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Toa barí tsi Emaús icanai ca yaca qui dos ca joni, naa Jesu banahuacanaibo cahi iniquë. Basiriama, naa once kilómetros Jerusalén quima toa yaca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Jerusalén ocapijahitaha ca tëquë yoati chanihi ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Jabi ja chanicano tsi jato qui Jesu riiniquë. Riihax jato bëta cotsijaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesu tsayaquí tsi jahuë bëmana ja cahëyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jatsi jato qui Jesu chaniniquë: —¿Jahuë chanibonacanai? —iquiina. Jatsi ja niicaniquë. Cohuë jato bëmana ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jatsi jato ó ca huësti cató quëbiniquë, naa Cleofás icanai cato. —¿Naa bari no tsi Jerusalén ca jënipijahitaha ca jahuë bo mi nicayamahitaha pa, toá tsi shishoquí na? Tonia mia roha tsi xo toa nicayamahaina ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jatsi, —¿Jahuë jahuë bo ni? —i Jesu niquë. Jatsi ja quëbicaniquë: —Nazarét ca Jesu yoati jahuë bo ra. ¿Toa jahuë bo mi nicayamahitaha pa? Dios Chani yoati ibo-iboria naa joni iquë ra. Anomaria ca jisti bo ja ani quiha. Jasca, Dios, nohiria tëquë, tihi cabo qui jiaria ja yoahai ca chani ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Jama, noba arati ibo bo, noba chama bo, tihi cabá mëaniquë romanobo qui, ja namëhacano iquish na. Japi cruzó tsi ja tooxahacahitaquë rë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Tonia noqui Israél cabo xabahamahai ca tsi xo naa ra” i no paoniquë. Noqui Israél cabo mëbihi jonish ca ja iqui ca quëscahuanohuahitaquë ra. Jatsi ja nahitaquë rë. Jasca, huinocaquë tres bari. ");
INSERT INTO caoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Jama, jaboqui noqui xatë ca yoxa bá noqui ratiaquë. Naa baquishmarí tsi quiha jahari jahuë maiquini qui yoxa bo huësti huësti cabo bocaquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jahuë yora ja yopacana quiha. Yama a. Yopahax jahari ja bëcaquë noqui yoaxëna. “Angel bo no jisquë ra. ‘Bëso xo ra’ icani quiha” i noqui toa yoxa bo quë pa. ");
INSERT INTO caoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Japi jahuë maiquini qui huësti huësti ca joni bo bocaniquë jato ri, jiscatsi na. Yama a ra; naa yoxa bá yoaha jascaria —nëa tsi Jesu qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jatsi jato qui Jesu chaniniquë: —Cahëtimaxëni ca joni xo mato rë. Dios Chani yoanish cabá yoani ca tëquë chahahua-pëniria ca mato xo naa. ");
INSERT INTO caoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Naa jahuë bo tëquë tënëti nori Xabahamati Ibo iyamayamani? Toca tsi jahuë oquë ja biquë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jatsi jamë yoati tsi Quënëhacanish cabá yoani tëquë bërohuatsi Jesú huaniquë. Jariapari tsi jamë yoati Moisés yamabá quënëni ca jahuë bo ja bërohuaniquë. Jaquirëquë jamë yoati Dios Chani yoanish cabá quënëni ca jahuë bo ja bërohuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Jatsi yaca qui ja cahëcaniquë. Ori Jesu cahai ca quëscahuahi tsi, ");
INSERT INTO caoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—No bëta mi chitëno ra. Caquë bari —i Jesu qui jaca niquë. Jatsi jato xobo qui Jesu jiconiquë jato bëta chitëxëna. ");
INSERT INTO caoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jatsi jato bëta Jesu oriquiniquë. Oriquiquí tsi quiha mapari ja biniquë. Ja quëshpi tsi “Gracias” ixo tsi ja bëquëxniquë. Bëquëx-xo tsi quiha jato qui ja mëaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Tocajaquë tsi quiha Jesu ja iqui ca ja cahëtapicaniquë. Jatsi Jesu yamatapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Jatsi chaninatsijacaniquë: —Anomaria iqui quiha jahuë chani ra, naa bahi xo tsi noqui ja yoahana. Dios Chani noqui ja bërohuano tsi ¿noba shina huahanayamaha pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jatsi ja joitapicaniquë. Jerusalén qui bacatsijacaniquë. Jesu once ca rabëtiria bo, Jesu banahuacanaibo huëtsa bo, tihi cabo jisi ja bocani quiha jato yoaxëna. Cahëhax tsi quiha, ");
INSERT INTO caoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—Jabija. Bëso xo ra. Simón qui ja jisiquiquë ra —i jato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jatsi bahi ó ca jënipijaha ca ja yoacaniquë jato ri, naa dos ca joni bo. Yoahax, —Mapari ja bëquëxquë tsi Jesu ja iqui ca no cahëtapiquë ra —i jato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ocapijani ca jahuë bo yoati ja chanicano tsi jato xërëquë tsi Jesu niitapiniquë. Niihax, —Raquëyamacana —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Bërocamaqui ja iqui ca ja quëscahuajahuacani quiha raquëquí na. Mëmëtsijacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Jatsi jato qui Jesu chaniniquë: —¿Jënihax tsi ratëcanai pa? ¿Jënixo tsi ëa yoi ja nori ca shinayamacanai? ");
INSERT INTO caoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Noho mëquënë, noho tahë, tihi cabo tsayacahuë. Ea yoi xo naa ra. Ea motsacahuë. Nami, xao, tihi cabo jayama xo bërocamaqui ra. Nami ë jaya ca jisqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Toca tsi chanipama tsi jahuë mëquënë, jahuë tahë, tihi cabo jato ja jismaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jatsi ja ranicaniquë ra. Jari shinati pi ja cahëyamacani quiha. Ja ratëcaniquë. Jatsi, —¿Jahuë ya ni mato piti? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jatsi ja qui imaha ca sani ja acaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Bichi tsi jato bësojo xo tsi ja piniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Pihax jato qui Jesu chaniniquë: —Mato bëtapama tsi ëmë yoati tsi Quënëhacanish cabo tëquë ë yoayamëquë. “Jatihuahacati iqui quiha ëmë yoati Quënëhacanish cabo tëquë” i mato qui ë yamëquë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Jatsi bëroria tsi Quënëhacanish cabo jato ja tiisimaniquë ja cahëyoicano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Jatsi ja chaniniquë: —Jabi ëa yoati ja quënëcani ca tsi xo naa: “Tënëti nori quiha johai ca Xabahamati Ibo” i jaca ni quiha. “Tres bari quirëquë rësonish cabo quima ja tëronoti nori quiha” i jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Jatsi, “Nohiria bo tëquë qui jahuë xabahamati Chani yoahacaxëti xo, ja quiri bësocanaiba jocha masahacano” i jaca ni quiha. Jabi Jerusalén pari tsi naa chani yoahacaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Jabi naa ma jisxëhai ca jahuë bo ma yoaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jabi jaboqui Espíritu Santo mato qui raaxëquia, noho Jahëpá yoani jascaria. Yacatá tsi chitëcana, mato qui mana ca chama joxëquë rohari. Toa chama ma jayano —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jaquirëquë Jerusalén quima jahuë rabëti bo Jesú boniquë, yaca Betania quiri. Toa xo tsi quiha jahuë mëquë Jesu tëroniquë jato shomahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Chanipama tsi nai qui tëronotsijaniquë. Jato quima ja bichiquiniquë nai qui. ");
INSERT INTO caoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jatsi ja mënicanaca tsi Jesu ja ocahuacaniquë. Ocahuahi tsi rani tsi jahari Jerusalén qui ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Arati xobó tsi ja i-ipaocani quiha Dios oquëhuahi na.");
INSERT INTO caoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Jariapari tsi Cristo, naa Chani icanai ca iniquë. Toatiyá tsi yama mai iniquë. Jabi Dios ya ja iniquë. Jasca, Dios ja iniquë ra, naa Chani inish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jariapari tsi Dios ya ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Jatiroha ca ja nëhohuayoniquë ra. Jasca, yama tsi toa ja ayamanina. ");
INSERT INTO caoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jatiroha ca ja bësomaniquë ra, Bësomati Ibo-iboria ja nori quëshpi na. Jasca, jatiroha ca nohiria qui huahuahi quiha jahuë Chani, jabija ca jismahi na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Tsëmó ca nohiria bo jabija ca Chani jismahai ca Huëa ca tsi xo naa ra. Jabi naa Huëa nocahuayama-pistiariaxëhi quiha tsëmo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Jatsi jahuë Chani bëhai ca Diós raaniquë, naa Juan icanai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jesucristo, naa Huëa inish ca yoati tsi nohiria bo yoahi quiha Juan joniquë. Joxo tsi quiha Dios Chani ja yoaniquë, Huëa inish ca qui nohiria chitimino iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jabi Huëa inish ca Juan iyamaniquë. Jama, Huëa inish ca yoati chanihi quiha ja joniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Jabija ca Huëa-huëaria ca tsi xo toa mai qui jonish cato. Joxo tsi quiha jatiroha cabo qui jabija ca huahuahi quiha, nohiria bá Dios cahëno iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Noba maí tsi quiha Chani icanai ca racaniquë; naa noba mai nëhohuanish cato. Jama, tsohuë ja iqui ca nohiria bá cahëyamaniquë rë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Jasca, jahuë maí ca nohiria bo, naa jodiobo qui ja joniquë. Ja joquë tsi quiha jahuë jimibá biyamaniquë pë. Jato qui yoi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jama, nohiria bá Chani icanai ca biquë tsi jato qui chama ja aniquë Dios baquë bo manëti. Jahuë baquë bo manëcani quiha Xabahamati Ibo ja nori ca ja chahahuacaquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Jatsi cotëquëhi quiha chahahuahi na. Jamëri tsi xo naa cohaina ra. Noba jahëhuá comahai ca jascaria ma xo ra. Nohiria jaha quëëhaina, bënë bá saihuacatsaina, nëca tsi quiha Dios baquë bo manëyamacani quiha. Jama, Dios tsi xo toa jato Comati Ibo-iboria. ");
INSERT INTO caoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Jabi joni naa Chani icanai ca manëniquë. Joni manëhax noqui xërëquë tsi quiha ja racaniquë. Jatsi jahuë oquë no jisniquë, naa ja qui jahuë Jahëpá acacanish ca oquë jiaxëni cato. Jasca, Dios baquë huësti ca ja iqui iqui tsi anomaria jahuë oquë ini quiha ra. Ja quëshpi tsi nohiria bo noiti cahëxëni ja ini quiha. Jasca, jabija ca chaniti cahëxëni ca ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jabi Cristo yoati tsi Juan nëcaniquë: —E cho joxëhi quiha ëa oquë cato. E conox pari no tsi ja iniquë. Jasca, mato qui ë yoani ca joni tsi xo naa —i Juan niquë Jesu yoati na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anomaria tsi xo noqui Cristó noihaina ra. Ja noihai iqui tsi no shomahuariahacaniquë ra, naa noqui tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Jabi jariapari tsi quiha noqui jodiobo qui Moisés yamabá yoba aniquë. Noqui quësohi quiha toa yoba rë. Jama, mai qui Jesucristo joni iqui tsi Diós noqui noihaina, jahuë jabija ca Chani, tihi cabo cahëyoiqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Yama tsi xo toa Dios jisnish cato. Jabi Dios noqui cahëmanish ca tsi xo toa jahuë Baquë yoi roha, naa Dios tahë cato. ");
INSERT INTO caoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jabi arati ibo bo, jato mëbicanaibo, tihi cabo quiha Jerusalén ca jodioba chama bá raaniquë Juan qui. Jato ja raacaniquë Xabahamati Ibo ja iqui ca nicati. Jatsi Juan ja nicacaquë tsi quiha, ");
INSERT INTO caoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","—Cristo, naa jaha ma pasohai ca Xabahamati Ibo ma xo ëa ra —i jato qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jatsi quiha, —¿Tsohuë cara ni mia sa? ¿Elías ma ni mia ra? —i ja qui jaca niquë. Jatsi quiha Juán quëbiniquë: —Elías ma xo ëa —iquiina. Jatsi, —¿Diós raahai ca chani yoati Ibo-iboria ni mia sa? —i jaca niquë. —Toa ma xo ëa ra —i Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jatsi quiha, —¿Tsohuë cara ni mia ra? Noqui yoahuë, noqui raahax cabo no quëbino iquish na. ¿Japa mia ti? ¿Jënihai ra? —i quiha Juan qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jatsi Juán quëbiniquë: —Xabachá ca quënahai ca ëa xo naa. Shomahuahacacahuë, Ibo johai ca bax na iquia ra. Jabi siri tsi quiha ëa yoati tsi Isaías yamabo, naa Dios Chani yoanish ca chaniniquë, naa ë conox pari no —nëa tsi Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Jatsi quiha fariseobá raahacanish cabá nicatëquëniquë: ");
INSERT INTO caoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—Johai ca Xabahamati Ibo, Elías, Dios Chani yoati Ibo-iboria, tihi cabo iyamapiquí tsi ¿jëniriaxo tsi nohiria bo ashimahai pa? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jatsi quiha Juán jato quëbiniquë: —Jënë́ tsi mato ashimaquia. Jama, mato xërëquë tsi bësohi quiha mato bëroma cato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E cho joxëhi quiha ëa oquëria cato. ¿Jënahuariahax raca ja bax ë yonocona rë, iriama ca ë nori quëshpi na? —nëa tsi bëcanish cabo qui Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jabi ani Jordán rabëquëxë, naa Betania mai icanish cató tsi quiha ja qui raahacanish cabo Juán quëbiniquë. Toa xo tsi quiha nohiria bo ashimahi ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huëaquë tsi quiha ja qui Jesu johai ca Juán jisniquë. —Tsayacapa. Dios oveja tsi xo naa ra. Nohiria jocha bixëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jabi mato qui ë yoani ca joni tsi xo naa, “E cho joxëhi quiha ëa oquë cato” i ë quë no. “E conox pari no tsi bëso ja iniquë” i ë ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Toatiyá tsi Xabahamati Ibo ja iqui ca ë cahëyamaniquë rë. Jama, jënë́ tsi ashimahi ë joniquë, Israél cabo qui mato Cristo jismaxëna —nëa tsi quiha nohiria bo qui Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jatsi quiha Juán yoani ca tsi xo naa: —Espíritu Santo ë jisniquë ra, nai ax boto botëhai jascaria. Botëhax jahá tsi ja chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Jari jaha no pasohai ca Xabahamati Ibo ja iqui ca ë cahëyamaniquë rë. Jama, ë qui chaniniquë Dios, naa nohiria bo ashimati ëa raanish cato. “Espíritu Santo botëhai ca jisxëqui mia” i ë qui Dios ni quiha. “Botëhax tsohuëcara ó chitëxëhi quiha. Espíritu Santó tsi nohiria ashimahai ca tsi xo toa” i ë qui Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jatsi Jesu qui Espíritu Santo botëhai ca ë jisniquë. Ja tsi xo toa Dios Baquë ra iquia —nëa tsi quiha jato qui Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huëaquë tsi quiha dos ca jahuë rabëti bo ya Juan nii iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Niixo tsi quiha Jesu tarabihai ca ja tsaya-tsayaniquë. —Tsayacapa. Dios oveja tsi xo toa ra —i quiha jato qui Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Jatsi Jesu quiha Juan rabë ca rabëti bá banahuaniquë ra ja yoani ca nicaxo na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Bopinaxo tsi quiha ja cho banahuacanaibo Jesú jisniquë. Jisi tsi, —¿Jahuë mëracanai? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jatsi quiha, —¿Jahuënia tsi racahai, Maestró? —i jaca niquë Jesu qui. Jatsi, —Jisi bëcahuë —i jato qui Jesu niquë. Jatsi quiha ja bëta ja bocaniquë. Boxo tsi quiha Jesu racahai ca iti ja jiscaniquë. Jisi tsi ja bëta ja chitëcaniquë, yata ja ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jabi Jesu ya canish ca Andrés ini quiha, naa Juan chani nicanish cato. Simón Pedro noma quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jasca, jisbaya tsi quiha jahuë rëquëmë Simón pari Andrés bichi caniquë. —Xabahamati Ibo no jisquë ra —i quiha Simón qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jatsi quiha Jesu qui jahuë rëquëmë ja bëniquë. Ja bëquë tsi quiha Jesú tsayaniquë. —Juan baquë Simón xo mia. Jaboqui janë paxa ca mi qui axëquia. Pedro mi quënahacaxëti xo —i quiha ja qui Jesu niquë. Jabi noba joí tsi “Maxaxa” Pedro janëhacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jatsi huëaquë tsi quiha Galilea mai qui Jesu cacasniquë. Caxo tsi Felipe ja jisniquë. Jatsi, —E bëta johuë —i quiha ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Jabi Betsaida yaca quima Felipe joni quiha. Toa yacatá tsi racani quiha Andrés, Pedro ri. ");
INSERT INTO caoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Jatsi quiha Natanael Felipé bichi caniquë. —Noqui Xabahamati Ibo ë jisquë ra. Jabi naa joni yoati tsi no yoahacani quiha Moisés quënëni cato ó no. Jasca, ja yoati tsi quënëni quiha Dios Chani yoanish cabo ri. Jahuë janë tsi xo Jesu, naa José baquë quiha. Nazaret quima ax johi quiha —nëa tsi quiha Natanael qui Felipe nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Jatsi quiha, —¿Jënahuariahax raca Nazaret quima ax jia ca jona? —i Natanael niquë. Jatsi, —Jisi jopa —i ja qui Felipe niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jatsi ja bëcano tsi quiha Natanael Jesú jisniquë. —Nëá tsi johi quiha Israél ca joni shinajiaxëni cato ra. Quiatimaxëni ca joni tsi xo naa —i quiha Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jatsi quiha, —¿Jënahuariaxo ëa mi cahëha pa? —i Natanael niquë. Jatsi, —Felipé mia quënanox pari no tsi tosa jihui namá mi tsahohai ca ë jisquë ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jatsi Natanaél quëbiniquë: —Dios Baquë xo mia ra, Maestró. Israél caba chama-chamaria xo mia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jatsi, —“Tosa jihui namá mia ë jisquë” i ë a iqui tsi ëa chahahuaqui mia pë. ");
INSERT INTO caoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Mia parayamaquia. Naa jisti oquë cabo jisxëqui mia ra. Nai japëquëhai ca jisxëqui mia. Jasca, Nohiria Baquë quima ax Dios ángel bo tëronohaina, ja qui ja botëcanaina, tihi cabo tsi jisxëqui mia ra —i quiha Natanael qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dos bari quirëquë quiha Galilea maí ca Caná icanish ca yaca xo tsi ahui yahi quiha joni iniquë. Toá tsi quiha Jesu jahëhua iniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jatsi quiha jahuë rabëti bo ya Jesu caniquë jaa ri. Ja qui joi amahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jabi nohiria bo oriquino tsi quiha oriquiti ibobá jënëria binianiquë rë. Jato jënë ja paisacaquë tsi quiha, —Yama xo jato jënë rë —i quiha Jesu qui jahuë jahëhua niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jatsi Jesú quëbiniquë: —Huënayamahuë, caí. Jamëri tsi xo toa mi shinahaina pë. Jari tsëquëyamahi quiha noho yonocoti xabaca ra —i quiha jahuë jahëhua qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jama, toá ca yonati bo qui jahuë jahëhua chaniniquë: —Mato ja yoahai ca acahuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Jabi toá tsi quiha seis maxax ca chomo bo nii ini quiha; naa Jodiobá chocohati jabi quëshpi na. Jabi pistiama naa chomo bo icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jatsi, —Chomo bo tsi jënëpaxa rëatsacana —i yonati bo qui Jesu niquë. Jatsi quiha ja rëacaniquë jahuë quëbichí no. ");
INSERT INTO caoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Rëajahuacaquë tsi quiha, —Huëtacahuë. Oriquiti ibo qui bocahuë —i jato qui Jesu niquë. Huëtaxo tsi quiha jënëria ibo qui yonati bá boniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ja bocaquë tsi quiha jënëria rarinamahacanish ca jënëpaxa ibobá tananiquë. Anomaria ja ini quiha. Tanaxo tsi quiha ahui yahax ca joni ja quënaniquë. Jabi jahuënia ca naa jënëria joha ca ja cahëyamani quiha. Cahëniquë taanish ca yonati bo roha. ");
INSERT INTO caoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Jatsi, —Anomaria tsi xo naa jënëria ra —i ibo niquë—. Jënëria jiaxëni ca pari taahi quiha jatiroha cabo ra. Noba jabi quiha. Jaquirëquë, nohiria bo sëyaquë tsi quiha jënëria yoi ca taacani quiha pë. Jama, ja cho naa jënëria jiaxëni ca mi taaquë pa —i ja ni quiha ahui yahax ca qui. ");
INSERT INTO caoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jabi naa jisti quiha Jesú aniquë Galileá ca Caná yacata xo na. Jahuë jariapari ca jisti quiha. Naa jistí tsi quiha jahuë oquë jiaxëni ca Jesú jismaniquë. Ja iqui tsi jahuë rabëti bá chahahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jaquirëquë jahuë jahëhua, jahuë noma bo, jahuë rabëti bo, tihi cabo ya Jesu caniquë Capernaum mai qui. Toá tsi quiha ichariama ca bari no tsi ja chitëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tsëquëpaimaria jodiobá pascua fiesta ini quiha. Ja quëshpi tsi Jerusalén qui Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Arati xobo qui jicoxo tsi huëyë bo, oveja bo, boto bo, tihi cabo iniacanaibo ja jisniquë. Jasca, toá tsi quiha parata rarinamacanaibo tsaho iniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jaha tsi quiha huacapi Jesú quëconiquë. Quëcoxo tsi quiha arati xobo quima jato tëquë ja raaniquë. Jato oveja bo, jato huëyë bo, tihi cabo ja raaniquë cacha. Raaxo tsi quiha parata rarinamacanaiba parata ja pacanamaniquë. Jasca, jato mesa bo ja narabaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jatsi, —Mato boto bo cacha tsëcacata. Noho Jahëpa xobo tienda jabitihuayamaxëqui mato ra —i quiha boto iniacanaibo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jatsi quiha Dios libro ó ca quënëhacanish ca jahuë bo jahuë rabëti bá shinaniquë, “Mi arati xobo noiquia, Diós. Anomaria tsi xo toa mi xobo ë noihaina ra” i ja nina. ");
INSERT INTO caoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Jatsi arati xobo quima jato Jesú raaquë tsi quiha jodiobá nicaniquë: —¿Cacha jato raati chama ya ni mia sa? ¿Jahuë jisti ati mëtsa ni mia, noqui mi chama jismati? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jatsi Jesú quëbiniquë: —Naa arati xobo potasyocahuë. Tres barí tsi noho chamá tsi niitëquëmaxëquia —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jatsi, —Cuarenta y seis año no tsi ja yonococaniquë, naa arati xobo jatihuaxëna. ¿Jënahuariaxo raca tres barí tsi naa xobo mi nimatëquëna? —i jaca niquë, quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jama, jahuë yora yoati tsi Jesu chanihi ini quiha, jato arati xobo yoati nomari. ");
INSERT INTO caoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Jasca, Jesu bësotëquëquë tsi quiha jodiobo qui ja nëcani ca jahuë rabëti bá shinani quiha. Jaha tsi Quënëhacanish cabo, Jesú yoanina, tihi cabo jahuë rabëti bá chahahuayoini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pascua fiesta no tsi quiha Jerusalén tsi Jesu iniquë. Toá ja no tsi quiha huëstima cabá chahahuaniquë, ja ani ca jistiria cabo jisish na. ");
INSERT INTO caoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jama, jato bëta Jesu rabënabëquiyamaniquë, jatiroha ca joni bá shinahai ca ja cahëni quëshpi na. ¿Mahitsa ja chahahuayamayamacani? ");
INSERT INTO caoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jabi nohiria bá shinahai ca tëquë ja cahëyoini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tobi jodioba chama iniquë, naa Nicodemo icanai cato. Fariseobo, naa jodioba chama ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jabi baquichá tsi quiha Jesu qui ja joniquë chaninaxëna. Johax, —Dios raahacanish ca maestro xo mia, Taitá. Dios mi bëtayamarohapino tsi mi acai ca jisti bo mi ayamaquë aquë ra —i quiha Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jatsi, —Mia parayamaquia. Cotëquëyamapihi tsi Diós otohai ca qui jicotimaxëni xo joni ra —i quiha ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jatsi, —¿Jënahuariahax joni siri ca cotëquëna ra? ¿Jahuë jahëhua xama qui jicoxëti ni, cotëquëti pa? —i Nicodemo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jatsi quiha Jesú quëbiniquë: —Mia parayamaquia. Jënë, Espíritu Santo, tihi cabá tsi cotëquëyamapihi tsi Diós otohai ca qui jicotimaxëni xo joni ra. ");
INSERT INTO caoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jabi nohiria comahi quiha nohiria. Jama, Dios baquë bo jabitiqui noa, Espíritu Santó tsi no cotëquëquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Mi cotëquëpaima xo” i ë no tsi ratëyamana. ");
INSERT INTO caoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Xotohi quiha yoshini jaha ja quëëhai cató no. Xotojano tsi jahuë joi nicaqui noa. Jama, jahuënia ax ja johaina, jahuënia ja cahaina, tihi cabo tsi cahëyoiyamaqui noa. Jabi toca tsi yonocohi quiha Espíritu Santo ri, no cotëquëquë no. Jisnoma xo Espíritu Santo yonocohaina —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jatsi, —¿Jënahuariahi ni sa? —i Nicodemo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jatsi Jesú quëbiniquë: —¿Israél ca nohiria maestro ma ni mia ra? ¿Naa ë chaniha ca cahëyamahai pa? ");
INSERT INTO caoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jabi no cahëhai ca jahuë bo, no jisi ca jahuë bo, tihi roha cabo yoati tsi chaniqui noa ra. Jama, noba chani biyamacani quiha nohiria pë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Naa maí ca jahuë bo yoati ë chanihai ca chahahuayamapiquí tsi ¿jënahuariaxo tsi ëa mi chahahuana, naa Dios naipá ca jahuë bo yoati ë chanixëquë no? ");
INSERT INTO caoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","‘Jabi ëa roha ca tsi xo toa Dios naipá ca jahuë bo jismati mëtsa cato. Yama tsi xo toa nai qui canish ca huëtsa ra. Jaroha ca nai ax jonish ca ëa xo naa, naa Nohiria Baquë cato. ");
INSERT INTO caoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Jabi jihuí tsi Moisés yamabá metal rono tëroni quiha nohiria bo rësoyamano iquish na. Jascaria, jihuí tsi tërohacaxëti xo Nohiria Baquë ri, nohiria bo rësoyamano iquish na. Ea namëxëti ca xo. ");
INSERT INTO caoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Jabi bëso-bësopaoxëhi quiha ë qui chitimicanaibo tëquë ra —nëa tsi quiha Nicodemo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Jabi jatiroha ca maí ca nohiria Diós noiniquë. Noixo tsi quiha jahuë jahuësti baquë ja aniquë no bax na. Jahuë baquë chahahuahi tsi rëso-rësoyamahi quiha noa. Jama, bëso-bësopaoxëqui noa. ");
INSERT INTO caoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Jabi Diós jahuë Baquë mai qui raayamaniquë jato jocha quëshpi nohiria copixëna. Jama, jahuë Baquë ja raaniquë noqui xabahamaxëna jahá no. ");
INSERT INTO caoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Jabi tënëtia qui jahuë Baquë qui chitimicanaibo raayamaxëhi quiha Dios. Jama, chitimiyamacanai ca tsi xo toa Dios copi bixëhaina ra, jahuë jahuësti Baquë qui ja chitimiyamacanai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jabi Diós yoani ca tsi xo naa: Mai qui joniquë Huëa nori cato. Jama, tsëmo ó quëëcani quiha joni bo rë, yoi ca ja acanai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Jabi yoi ca acanaibo qui anoma tsi xo Huëa cato. Jasca, Huëa ca qui bëyamacani quiha pë, jato yoi ca acanai ca jahuë bo bërohuahacamitsa iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jama, Huëa ca qui bëcani quiha jabija ca banahuacanaibo. Bërohuahacahi quiha Diós toa nohiria mëbihaina. ");
INSERT INTO caoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jaquirëquë quiha jodioba mai qui Jesu caniquë jahuë rabëti bo ya. Cahax jato bëta ja chitëniquë. Toa xo tsi quiha nohiria bo Jesú ashimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jabi Enón icanai ca ani xo tsi quiha nohiria bo ashimahi Juan iniquë jaa ri. Salim yaca basima ja ini quiha. Toá tsi quiha huëstima ca jënë ini quiha. Jasca, ja qui nohiria bo cariahi ini quiha ashimahacati. ");
INSERT INTO caoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Jabi toatiyá tsi quiha jari preso qui nanëhama Juan ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jabi ashimati jabi tahëxo tsi quiha joi mërati Juan rabëti bá chitahëhuaniquë jodiobo yaxo na. ");
INSERT INTO caoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Joi mërahax Juan qui ja bocaniquë. —Jisa, maestró. Joquë Jesu, naa ani Jordán rabëquëx ca mi bëta inish cato pa. Jia tsi toa joni yoati mi chaniniquë. Tsayahuë. Jaboqui nëa xo tsi nohiria bo ashimahi quiha pë. Ja qui bocani quiha nohiria tëquë rë —i quiha Juan qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jatsi quiha Juán jato quëbiniquë: —Jia tsi xo Jesu qui nohiria bocanaina iquia. Ja qui jahuë yonoco Diós ani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Jabi toa joni yoati ë yoani ca ma nicaniquë ra. “Dios raahacanish ca Xabahamati Ibo ma xo ëa” ¿iyama ë ni? “E raahacaquë Cristo bëbo cati” i ë ni quiha. Jabi noho yonoco tsi xo toa jahuë quinia shomahuahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ratëyamacana. Jënima tsi xo oquë ca joni qui nohiria bocanaina, naa fiesta ibo ya nohiria bocanai jascaria. ¿Jabi fiesta ibo mëbiyamayamahi ni jahuë rabëti bo? Jabi Iboba rabëti xo ëa ra. Japi Ibo Jesu qui nohiria bocano tsi raniquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jabi oquënaxëti xo Jesu iquia. Anixëti xo jahuë yonoco ra. Jama, iriama ca ëa xo naa. Namahi quiha noho yonoco —nëa tsi quiha jato qui Juan nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Jatsi, —Nai ax jonish ca tsi xo naa joni ra. Jatiroha cabo oquë xo. Maí conish ca roha xo ëa ra. Iriama tsi xo noho tiisimati chama. Jama, noqui oquë tsi xo naa nai ax johax cato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ja jisni ca jahuë bo, ja nicani ca jahuë bo, tihi cabo yoahi quiha. Jama, jahuë chani jia ca biyamacani quiha nohiria pë. ");
INSERT INTO caoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jama, “Jabija ca xo Dios” iti mëtsa xo tsohuëcara ca naa joni chani bichish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Jabi Dios Chani yoahi quiha Jesu, ja qui Espíritu Santo Diós ani quëshpi na. Dios shina jayaria xo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Jasca, jahuë Baquë noihi quiha Jahëpa Dios. Jahuë Baquë qui chama ja aniquë jatiroha ca ja yonano. ");
INSERT INTO caoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Jabi bëso-bësopaoxëhi quiha jahuë Baquë chahahuahai cato. Jama, nai qui jicoyamaxëhi quiha jahuë Baquë chahahuayamahai cato. Ja qui caxa-caxapaoxëhi quiha Dios ra —nëa tsi quiha nohiria bo qui Juan nëcaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jodioba chama bo, naa fariseobo icanai cabo qui chani cahëniquë Jesu yoati na. “Huëstima ca nohiria bëbohi quiha Jesu ra. Huëstima ca ashimahi quiha pa; naa Juan huino quiha” i jato qui nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Jama, jahuë rabëti bá nohiria bo ashimani quiha, Jesu ja nomari. ");
INSERT INTO caoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jabi ja acai ca jodioba chama bá nicaquë tsi quiha toa jodioba mai Jesú jisbayaniquë. Jisbaya tsi quiha Galilea qui jahari catsijaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jabi samaria mai nacoti nori ja ini quiha, jahuë mai qui cahëti. ");
INSERT INTO caoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","Nacopama tsi quiha matoroco barí tsi yaca Sicar icanai ca qui ja cahëniquë. Cahëhax Jacob yamabá ani ca quini, naa jënëpaxa jaya ca quini tapaí Jesu tsahoniquë. Ja joicasni quiha. Basi ja coni quiha. Caquë bari. Jabi José yamaba maí tsi toa jënëpaxa ini quiha, naa jahuë jahëpa Jacob quima ja binina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Tsahojano tsi quiha Samariá ca yoxa joniquë jënëpaxa bichi na. Jodiobo qui yoiria Samaria cabo ini quiha. Jabi ja joquë tsi quiha, —E qui jënëpaxa ahuë —i yoxa qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Jabi jamëpistia Jesu ini quiha. Yaca qui jahuë rabëti bo jiconi quiha piti copiti. ");
INSERT INTO caoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jatsi yoxa ratëniquë ja qui Jesu chanini nori iqui na. —¿Samariá ca yoxa qui chanihi ni mia pa? ¿Jodioba jabi pasomaha ma ni? “E qui jënëpaxa ahuë” ¿i mi a pa? —i quiha Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jatsi Jesú quëbiniquë: —Diós mi qui acatsaina, mi qui chanihai cato, tihi cabo cahërohapiquí tsi ë quima bësomati jënë mi baaquë aquë iquia. Jatsi toa jënë mi qui ë aquë aquë ra —nëa tsi quiha yoxa qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—Yama tsi xo mi jënëpaxa biti cato, Taitá —i yoxa niquë—. Nëmi xo quini ra. ¿Jahuëniaxo raca bësomati jënë mi bina? ");
INSERT INTO caoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Naa maiquiní ca jënëpaxa jiaxëni ca noba Jacob yamabá aniquë. Jasca, naa jënë aniquë jahuë baquë bo. Aniquë jahuë vaca bo ri. ¿Jënahuariaxo raca jënë oquë ca ë qui mi ana? ¿Noba rëquëyamabo Jacob oquë ni mia pa? —nëa tsi quiha yoxa nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jatsi Jesú quëbiniquë: —Tëshinatëquëhi quiha naa maiquiní ca jënë acai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jama, tëshinatëquëpistia-yamariaxëhi quiha ë acai ca jënë acai cato ra. Noho jënë ja aapino tsi rëamë ihipaoxëhi quiha jahuë shinana. Naama-naamapaoxëhai ca jënë xo naa ra —i quiha yoxa qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jatsi, —Toa jënë ë qui ri ahuë, Taitá. E qui mi aapino tsi tëshinatëquëyamaxëquia ra. Jaha tsi naa maiquiní ca jënë bichi joyamaxëquia ra —i ja qui yoxa niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jatsi Jesú quëbiniquë: —Mi bënë bichi cata —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Jatsi, —Bënë yama ca ëa xo naa ra —i ja niquë. Jatsi, —Jabija tsi xo toa mi yoahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Cinco ca bënë bo mi jayani quiha. Jasca, mi bënë ma xo toa mi bëta racahai cato. Jabija ca mi yoaquë ra —i quiha ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jatsi yoxá quëbiniquë: —Tonia Dios Chani yoahai ca xo mia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nëá tsi, naa macaná tsi noba rëquëyamabo arapaoni quiha Dios qui. Jama, “Jerusalén tsi araxëti quiha nohiria tëquëta” ii quiha mato jodiobo pë —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jatsi Jesú quëbiniquë: —Ea chahahuahuë, caí. Johi quiha bari huëtsa ra. Toatiyá tsi naa macana, Jerusalén, tihi cabá tsi Jahëpa Dios qui arayamacaxëcani quiha nohiria. ");
INSERT INTO caoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Jabi ma arahai ca cahëyoiyamaqui mato samariacabo. Jama, no arahai ca cahëqui noa, naa noqui jodiobo. Jabi jodiobo quima johi quiha Diós nohiria bo xabahamahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jasca, joxëhi quiha xaba huëtsa. Toa xaba tsëquëno tsi quinia huëtsá tsi Dios qui aracaxëcani quiha nohiria tëquëta, naa Dios noicanaibo. Jato shinaná tsi Dios qui aracaxëcani quiha ra. Mahitsa iyamaxëhi quiha ja aracanaina ra. Jabi jaboqui rohari tsi naa Dios qui aratí quinia paxa ca chitahëhuahi quiha huësti huësti ca aracanaibo yoi bo ra. Nëca ca aracanaibo jiscatsi quiha Dios. Ja qui jia quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Shina xo Dios. Jisnoma quiha. Jascaria, jisnoma xo naa jabija ca arahai paxa cato. Noba shinaná tsi ja qui no araxëti xo —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jatsi yoxá quëbiniquë: —Xabahamati Ibo raaxëhi quiha Dios ra. Joxëhi quiha Cristo icanai cato. Joquí tsi jahuë bo tëquë yoaxëhi quiha —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jatsi, —Dios raahacanish ca ëa xo naa, naa mi qui chanihai cato —i quiha ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jatsi Jesu rabëti bo bacaniquë. Samariá ca yoxa ya tsi Jesu chanihai ca jisi tsi ja ratëcaniquë. Jesu ja nicacascani quiha yoxa yoati na. Jama, —¿Jënihax tsi naa yoxa ya tsi chanihai pa? ¿Jahuë ó quëëhi ni sa? —iyama jaca ni quiha, bërabihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jatsi yoxa jahari caniquë jahuë yaca qui. Jahuë chomo ja jisbërianiquë maiquini tapaí. ");
INSERT INTO caoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Jahuë yaca qui cahëhax, —Naa joni jisi bëcapa. Jatiroha ca ë ani ca ëa ja yoaquë pa. ¿Tonia Diós raahai ca Xabahamati Ibo ma ni? —i quiha nohiria bo qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Jaha tsi yacatá ca nohiria tëquë jisbayaniquë. Jisbaya tsi quiha Jesu jisi ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Jabi jahuë yaca qui yoxa bacaquë tsi quiha, —Pihuë —i Jesu qui jahuë rabëti bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jatsi Jesú quëbiniquë: —Piti huëtsa jaya xo ëa ra, naa ma cahëyamahaina —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jatsi jato xërëquë tsi quiha chaninatsi jahuë rabëti bo niquë: —¿Tsohuëcaracá ja qui piti bëha pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jatsi jahuë rabëti bo qui Jesu chaniniquë: —Ea raanish ca quima johi quiha noho piti. Jahuë shina acaina, jahuë yonoco jatihuahaina, tihi cabo tsi xo toa noho piti ra. ");
INSERT INTO caoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","“Cuatro oxë tsi bimi tësaxëqui noa” ii quiha mato ra. Jama, johai ca nohiria tirixëni ca tsayacapa. Tësati bimi jascaria ca xo. Dios chahahua-paimaria ca xo. Dios bax ja tësahacapaimaria ca xo iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Jasca, nohiria tësacanaibo qui copi jia ca axëhi quiha Dios. Bëso-bësopaocaxëcani quiha toa ja tësacanaina. Jaha tsi nohiria tësacanaibo ya ranixëhi quiha Dios Chani sayacanaibo ri. ");
INSERT INTO caoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Jabi “Huësti ca joni tsi xo sayahaina. Ja sayaha ca tësahi quiha joni huëtsa” ii quiha nohiria bo. Jabija tsi xo toa ja chanicanaina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Jatsi mato raaquia ma sayahama ca tësati. ¿Tsayayamacanai? Dios bax yonoconiquë huëtsa bo, Dios Chani sayahaina. Jaboqui jato yonoco tësaxëqui mato ra —nëa tsi quiha jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Jabi huëstima ca yacatá ca samariabá chahahuaniquë, —Jatiroha ca ë ani ca ëa naa joní yoaquë pa —i jato qui yoxa quë no. ");
INSERT INTO caoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jatsi Jesu qui caxo tsi quiha samariabá bënarianiquë: —No bëta mi chitëno ra —iquiina. Jatsi dos bari no tsi jato bëta Jesu chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jaha tsi nohiria huëtsa bo chitiminiquë jato ri Jesu chani nicahax na. Huëstima ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","—Jia tsi xo noqui mi yoahitahana. Jama, jaboqui chahahuariaqui noa, naa joni no nicaha quëshpi na. Nohiria bo Xabahamati Ibo yoi ja nori ca cahëqui noa ra —i yoxa qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Dos ca bari huinocaquë tsi quiha samariabo Jesú jisbayaniquë. Jisbaya tsi quiha jahuë mai qui, naa Galilea qui ja caniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Capama tsi quiha, —Dios Chani yoahai ca nicayamahi quiha jahuë maí ca nohiria bo rë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jama, jahuë mai, naa Galilea qui Jesu cahëquë tsi quiha nohiria bá joihuaniquë pa. Jatiroha ca Jesú ani ca ja jiscani quiha Jerusalén qui shishoquí na. Jabi Jerusalén ca pascua fiesta qui ja bocani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jahuë mai qui cahëhax Caná icanai ca yaca qui Jesu caniquë, jënëpaxa quima jënëria ja ani cato. Toá tsi quiha gobierno chama iniquë. Iquihi jahuë baquë ini quiha. Jasca, basi, naa Capernaum yacatá tsi racahi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Jodioba mai ax Galilea qui Jesu joni nori ca ja nicaniquë. Nicahax Caná yaca qui ja caniquë jahuë baquë iqui na. Jatsi, —Noho xobo qui johuë. Rësopaimaria xo noho baquë rë. Noho baquë mi jënimahuano ra —i quiha Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jatsi capitán Jesú quëbiniquë: —¿Jëniriahax ë qui chitimiyamacanai? E qui chitiminox pari tsi jisti jiscatsi quiha mato rë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Jama, —Johuë, Taitá, noho baquë rësonox pari no —i Jesu qui capitán niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jatsi, —Cata. Rësoyamaxëqui mi baquë ra —i capitán qui Jesu niquë. Jatsi jahari jahuë xobo qui capitán caniquë. Jesú yoani ca qui ja chitimini quiha jahuë baquë yoati na. ");
INSERT INTO caoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jahari capama tsi quiha jahuë yonati bo ja bëchaniquë bahi xo na. —Jënima xo mi baquë ra. Bëso xo —i quiha ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jatsi, —¿Jahuë hora jënimati ja tahëha? —i capitán niquë. —Matoroco bari quiha ja chamahitaquë. A la una quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jatsi jasca ca hora ja ini ca ja cahëniquë, naa “Jënima xo mi baquë” i Jesu quë no. Japi Jesu qui ja chitimiyoiniquë. Chitiminiquë jatiroha ca jahuë xobó cabo ri. ");
INSERT INTO caoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jabi segunda jisti tsi xo naa Jesú anina, jodioba mai ax Galilea qui johax na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jaquirëquë Jerusalén tsi quiha jodioba fiesta iniquë. Jatsi caniquë Jesu ri. ");
INSERT INTO caoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jabi Jerusalén tsi ashimati jënëquini ini quiha, naa Betsaida icanai cato. Oveja jicoti caiti basima quiha. Jabi cinco ca pórticos, naa caiti jisiria cabo, naa ashimati iti jayani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Jabi jahuë pórtico namá tsi quiha noitiria cabo racahi ipaoni quiha. Toá tsi quiha bëco cabo, coyamacanaibo, yora choni jaya cabo, tihi cabo iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Toá tsi iniquë cotimaxëni cato. Treinta y ocho año no tsi ja coyamani quiha. Naama quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jabi Jerusalén qui jicopama tsi toa joni raca ca Jesú jisniquë. Naama toca tsi ja ini ca Jesú cahëniquë. Jatsi, —¿Jënimacatsai? —i joni qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jatsi noitiria ca joní quëbiniquë: —Yama tsi xo ashimati jënëquini qui ëa jicomahai cato rë. Angél jënëpaxa roihano tsi mëri tsi jënë qui canoma xo ëa rë. E jicocasno tsi jariapari jënë qui jicohi quiha huëtsa rë —i Jesu qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jatsi Jesu ja qui chaniniquë: —Niihuë. Mi oxati bihuë. Cohuë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jatsi chamatapiniquë joni. Chamaxo tsi quiha jahuë oxati ja biniquë. Bixo ja jisbayaniquë. Jabi joiti barí tsi quiha naa joni jënimahuahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ja quëshpi tsi jodiobá jënimahuahacanish ca joni raahaniquë pë. —Joiti bari tsi xo naa ra. Anoma tsi xo naa mi oxati bëhaina ra —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jatsi joní quëbiniquë: —“Mi oxati bihuë. Cohuë” i ë qui ëa jënimahuahax ca quë ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Jatsi jodiobá nicaniquë: —¿Tsohuë ni naa joni ra, naa “Mi oxati bihuë. Cohuë” i mi qui ax cato? —i jaca niquë ja qui. ");
INSERT INTO caoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Tsohuëcara ja ini joní cahëyamani quiha. Caquë Jesu. Nohiria misco ca qui ja jiconi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jatsi yata tsi quiha jodioba arati xobo xo tsi Jesú toa joni bëchaniquë. Bëchahax tsi, —Tsayapa. Jaboqui jënima xo mia. Jochatëquëyamahuë, jahuëcara oquë ca isihai ca mi bimitsa iqui na —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jatsi jodioba chama bo mërahi joni caniquë, Jesu jistëquëxo na. —Jesu tsi xo toa joni, naa ëa jënimahuahax cato ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jaha tsi Jesu tënëmati jodioba chama bá chitahëhuaniquë rë, joiti barí tsi nohiria ja jënimahuani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jatsi quiha Jesú jato quëbiniquë: —Jatiroha barí tsi jia ca aqui quiha noho Jahëpa ra. Jabi toca xo ëa ri —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jaha tsi Jesu pi jodiobá ariacasniquë, jato joiti bari jabi bo ja janayamani iqui na. Jasca, “Noho Jahëpa xo Dios” i jato qui Jesu ni quiha. Jabi nëca tsi Dios quësca jamë ja ani iqui tsi Jesu jodiobá acasniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jatsi quiha jodiobo Jesú quëbiniquë: —Jabija ca mato yoaquia ra. Yama tsi xo toa jamëpistia xo ë acaina ra, naa Dios Baquë ë nori cato. Jasca, jaha ë quëëhai ca ayamaquia. Noho jahëpá acai ca ë jisi ca roha ca aquia ra. Jatsi noho Jahëpá acai ca jascaria aquia ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Jasca, ëa, naa jahuë Baquë noihi quiha Jahëpa. Jatiroha ca ja acai ca ëa jismahi quiha. Jaboqui naa joni jënimahuahacaquë. Jama, naa ë aca ca oquë ca axëquia. Jatsi ratëyoxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Jasca, noho Jahëpá bësoyama cabo bësomahai jascaria tsi ë qui jia cabo bësomaxëquia ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Jasca, jato jocha quëshpi bo tsi nohiria copixëquia, nohiria bo copiti chama ë qui noho Jahëpá ani quëshpi na. Nohiria bo copiyamaxëhi quiha Jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jabi ë qui chama acacaniquë, ëa nohiria bá oquëhuano, naa noho Jahëpa nohiria bá oquëhuahai jascaria. Jabi ëa oquëhuayamapiquí tsi Jahëpa Dios, naa ëa raanish ca oquëhuayamahi quiha mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","‘Mato parayamaquia. Bëso-bësopaoxëhi quiha noho chani nicahai cato, ëa raanish ca Dios chahahuahai cato. Jahuë jocha quëshpi tsi tënëtiya qui ja raahacayamati xo. Jaboqui bësoyoixëhi quiha ra. Rësonoma quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Mato parayamaquia. Dios Baquë joi nicaxëhi quiha bësoyama cabo ra, toa xaba tsëquëquë no. Jabi jaboqui ëa chahahuati chitahëhuahi quiha huësti huësti cabo ra. Jabi bëso-bësoxëhi quiha ëa nicacanaibo tëquë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nicacapa. E qui nohiria bo bësomati chama noho Jahëpá ani quiha, Bësomati Ibo-iboria ja nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Jasca, nohiria bo copiti chama ë qui ja ani quiha, joni ë manëni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Jabi ë yoahai ca qui ratëyamacana. Tsëquëxëhi quiha bari, naa maihuahacanish cabo tëquë noho joi nicaquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Toa barí tsi tërohacaxëhi quiha jia ca acanaibo. Jasca, tërohacaxëhi quiha yoi ca acanaibo. Bëso-bësopaoxëhi quiha jia ca acanaibo. Jama, copihacaxëti xo toa yoi ca acanaibo jato jocha quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","‘Yama tsi xo toa ëmëpistia xo ë acaina ra. Nohiria copiquí tsi Diós ëa yoahai ca roha aquia. Jaha tsi mëstë tsi xo nohiria ë copihaina. Jaha ë quëëhai ca ayamaquia; jama, jaha noho Jahëpa quëëhai ca nori. ");
INSERT INTO caoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Jabi ëmë yoati tsi ë chanipino tsi noho chani chahahuayamahi quiha nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Jama, tobi ëa yoati chanihai ca huëtsa cato ra. Jia tsi chanihi quiha. Jabija tsi xo toa ëa yoati ja chanihaina iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Jabi ashimati ibo Juan qui joni bo ma raaniquë, ëa yoati nicamati. Jabija tsi xo toa ëa yoati Juan chaninina ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Jabija ca ja yoani quiha. Jama, tobi quiha Juan chanihai ca oquë cato ra. Mato bax nëcatsiquia, ëa ma chahahuano xabahamahacati. ");
INSERT INTO caoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jabi huëa jascaria Juan ini quiha. Nohiria bo qui jahuë chani huahuapaoni quiha. Tanaroha pistia no tsi mato qui jia quiha jahuë huëahai ca chani iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Jama, tobi quiha ëa yoati Juan oquë ca chanihai cato. Ea yoati chani-chaniriahai ca tsi xo toa ë acai ca jisti bo ra. Noho Jahëpá ë qui ani ca chamá tsi toa jisti bo aquia ra. Toa jisti bo aquia, Jahëpa Diós ëa raani ca ma cahëno iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Jasca, ë bax chanihi quiha ëa raanish ca Jahëpa ri. Jabi jahuë joi ma nicapistia-yamariani quiha. Jahuë bëmana ma jisyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Jasca, mato shina qui jicoyamahi quiha jahuë chani rë, ëa, naa Jahëpá raani ca ma chahahuayamahai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Jama, Quënëhacanish cabo tsaya-tsayariaqui mato ra, mato ja bëso-bësopaomacaxëcanai quëscahuaquí na. Mahitsa tsi xo toa ma tsayahaina rë. Jabi ëa yoati chanihai ca tsi xo toa Quënëhacanish cabo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jama, ëa yoati Quënëhacanish cabo chaniquë ri tsi jari ë qui jocasyama xo mato rë, xabahamahacaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","‘Jabi ë qui iriama tsi xo toa ëa ma nicacasyamahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Jama, mato cahëriaquia ra. Yama tsi xo toa mato ó ca Dios noicanaibo iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Jasca, noho Jahëpa chamá tsi johai ca ëa xo naa. Jama, ëa, noho chani, tihi cabo bicasyama xo mato rë. Jama, jahuë chama yoí tsi joni huëtsa joopino tsi toa joni joihuaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Jatsi, ¿jënahuariahax raca ë qui ma chitimina, nohiriá mato qui acai ca oquë ó quëëpiquí na? Mato qui Diós acatsai ca oquë ó quëëyamaqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nicacapa, Jahëpa Dios bësojo ax tsi mato qui quësoyamaxëquia. Mato qui quësoxëhai ca tsi xo Moisés ra, naa ja qui ma chitimihai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Jabi ëa yoati tsi Moisés yamabá quënëni quiha. Moisés quënëni ca chahahuarohapihax tsi ë qui ma chitimiquë aquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Jatsi, ¿jënahuariaxo noho chani ma chahahuana, Moisés quënëni ca ma chahahuayamaquë no? —nëa tsi jodioba chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jaquirëquë quiha ia Galilea Jesu shitaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","3","Shitahax maca qui ja tëmahinaniquë. Tëmahinahax ja tsahoniquë jahuë rabëti bo ya. Jasca, huëstima ca nohiria bá Jesu banahuaniquë, noitiria cabo ja jënimahuahai jiscatsi na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Basima quiha jodioba fiesta ini quiha, naa jato pascua fiesta. ");
INSERT INTO caoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Tsahopama tsi quiha ja qui bëcanai ca nohiria huëstima ca Jesú jisniquë. Jisi tsi Felipe qui ja chaniniquë: —¿Jahuëniá ca mapari copixëhi ni noa naa nohiria bo pimaxëna? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jabi ja nëcaniquë Felipe tanamaxëna, ja ati nori ca ja cahëni quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jatsi Felipé quëbiniquë: —Doscientos ca paratá tsi mapari copixo tsi ¿jënahuariaxo raca jato no sëyamana? Narisxëqui noa ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jatsi Jesu qui chanitsi Andrés, naa Simón Pedro rëquëmë niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Tobi quiha huësti ca baquë nëá no ra. Cinco ca mapari, dos ca sanino, tihi cabo jaya xo ra. ¿Tihi roha cató tsi naa tihiria ca nohiria raca pimahi ni noa pa? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jatsi, —Nohiria tsahomacahuë —i Jesu niquë. Jabi jia toa iti ini quiha, huasi ya. Jatsi, tsahoniquë nohiria. Toá tsi cinco mil ca joni bo ini quiha. Tihiria ca racana quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Tsahomajahuacaquë tsi quiha baquë mapari Jesú biniquë. Jatsi Dios qui “Gracias” ixo tsi tsahonish cabo qui ja mëaniquë. Mëaxo tsi quiha sani nohiria bo qui ja mëaniquë. Jatsi nohiria bá piniquë. Ja sëyacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Sëyajacaquë tsi quiha, —Pihama ca quësi bo catiacahuë, oriquiti yoshihuahacayamano —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Jatsi mapari quësi bo, sani quësi bo, tihi cabo ja catiacaniquë. Catiaxo tsi quiha doce ca caca ja rëacaniquë pa, naa pihama cato. ");
INSERT INTO caoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jatsi nohiria bo ratëniquë. Ja ani ca jisti jisi tsi, —Jabija. Dios Chani yoahai ca, naa jaha no pasohai ca tsi xo naa ra —i nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Japi nohiria bá Jesu bicasniquë, jato rey, naa chama-chamaria manëmaxëna. Ja acascanai ca cahëxo tsi quiha jato ja jisbayaniquë. Jatsi maca bo qui jamëpistia tsi ja paxaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Bari caquë tsi quiha ia qui jahuë rabëti bo botëniquë Jesu manaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joyamaniquë Jesu. Caquë bari. Jarohari tsi quiha noti qui ja jicocaniquë, ia Capernaum shitaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Shitajacano tsi quiha xotoriatsi yoshi niquë rë. Anomaria choca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Pabasi huaaxaxo tsi quiha ianë́ ca tsi Jesu cohai ja jiscaniquë. Jato noti qui basimahi ja ini quiha. Jatsi quiha ja raquëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jatsi jato qui Jesu chaniniquë: —Raquëyamacana. Ea yoi xo naa —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Japi jato noti qui ja jicomacascani quiha. Jicomajahuacaquë tsi quiha mai qui, naa ja rërëcatsai ca iti qui ja cahëtapicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","Huëaquë tsi quiha ia rabëquëx ca chitënish ca nohiria bá Jesu yopaniquë. Jahuë rabëti bo ya notí tsi Jesu cayamani ca ja cahëcani quiha. Jabi Jesu yama tsi jahuë rabëti bá ia shitashinani ca ja shinacani quiha. Jatsi Jesu, jahuë rabëti bo, tihi cabo yopaxo tsi ia ja shitacascani quiha jato ri. Yama ca noti bo ini quiha. Jatsi toá tsi quiha, naa Ibo Jesú mapari jato pimani ca qui Tiberiá ca noti bo rërëniquë. Jatsi toa noti bo qui nohiria jicocaniquë Capernaum qui shitaxëna, toa xo tsi Jesu mëracatsi na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ia shitaxo tsi quiha Jesu ja jiscaniquë. Jisi tsi, —¿Jënino tsi mi joha pa, Maestró? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jatsi Jesú jato quëbiniquë: —E bëta bëyocascaqui mato, mato ë pimahitaha iqui na pë. Mato qui iriama tsi xo toa ë acai ca jisti bo rë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nicacapa. Iriama tsi xo piti ra. Naamayamahi quiha. Jatsi naamayamahai ca ó quëëyamacana. Jama, mana ca piti ó quëëcana. Mato qui toa piti acasquia, naa Nohiria Baquë ë nori cato. Mato bëso-bësopasomaxëhi quiha toa ë acai ca piti ra. Jabi noho Jahëpa Diós ëa raaniquë, mana ca piti nohiria bo qui ati —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jaha tsi nohiria bo chaniniquë: —¿Jënahuaxëhi ni noa Dios ranihuaxëna ra? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jatsi Jesú quëbiniquë: —Ranixëhi quiha Dios, ja raani ca ma chahahuaquë no —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jatsi, —¿Jahuë jisti ati mëtsa ni mia? —i Jesu qui jaca niquë—. Noqui jismahuë, mi qui no chitimino. ¿Jahuë acai ra? ");
INSERT INTO caoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Jabi xabacá tsi racapama tsi naipá ca mapari noba rëquëbo yamabá pini quiha. Jabi “Naipá ca mapari jato qui Moisés yamabá ani quiha piti” ii quiha Quënëhacanish cabo. Moisés ani ca oquë ca jisti mi ano ra, Diós pi mia raani ca no cahëyoino iquish na —nëa tsi Jesu qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jatsi Jesú quëbiniquë: —Mato qui naipá ca mapari Moisés yamabá ayamani quiha ra, noho Jahëpá tsi nori. Jasca, jaboqui naipá ca mapari yoi ca mato qui acatsi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Jabi Diós acai ca mapari tsi xo toa nai ax botënish cato. Maí ca nohiria bësomahi quiha —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jatsi, —Jatiroha barí tsi naa mapari noqui ahuë, taitá —i nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jatsi, —Bësomati Mapari ca ëa xo naa ra —i jato qui Jesu niquë—. Paxnayamaxëhi quiha ë qui johai cato. Tëshinayamaxëhi quiha ë qui chitimihai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jama, mahitsa ëa, noho jisti bo, tihi cabo ma jisquë pë. Jisi tsi jari ë qui chitimicasyamaxo mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Jama, ë qui chitimixëhi quiha huësti huësti cabo, naa jatiroha ca ë qui noho Jahëpá acaina. Tsohuëcara ë qui johai ca niayama-xëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Jabi nai ax ë botëniquë, noho Jahëpa, naa ëa raanish cato shina axëna. Noho shina ayamahai ca ëa xo naa. ");
INSERT INTO caoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ea raanish cato shina tsi xo naa ë qui ja ani cabo ë bënoyamahaina. Jato bësomaxëquia jaroha ca barí no. Ea raanish ca qui jia tsi xo toa. ");
INSERT INTO caoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ea, naa jahuë Baquë cahëcanaibo, ë qui chitimicanaibo, tihi cabo bësomacatsi quiha. Noho Jahëpa qui jia tsi xo toa jaroha ca barí tsi jato ë bësomaxëhaina —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jatsi pë Jesu qui yosanatsi jodiobo niquë, “Nai ax johax ca Mapari xo ëa” i ja ni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Jatsi Jesu pasomaha chanitsijacaniquë pë. —Jesu roha tsi xo naa ra. José baquë quiha. Jahuë jahëpa, jahuë jahëhua, tihi cabo cahëqui noa ra. ¿Jënahuariahax “Nai ax ë botëquë” i ja na? —nëa tsi nohiria bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—Toca tsi chaniyamacana. Anoma quiha —i jato qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yama tsi xo toa ë qui jamëpistia joti mëtsa cato. Ea raanish ca Jahëpa tsi xo toa jato ë qui mëpiti Ibo ra. Jatsi ë qui mëpihacahax cabo bësomaxëquia jaroha ca barí no. ");
INSERT INTO caoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Jabi “Jatiroha cabo tiisimaxëhi quiha Dios” ii quiha Dios Chani yoanish cabo ja quënëcani cabo ó no. Japi noho Jahëpa nicacanaibo, naa jabija ca tiisimahacahax cabo, tihi cabo tsi xo toa ë qui bëcaxëcanaina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","‘Jasca, yama tsi xo toa noho Jahëpa jisish ca ri. Huësti roha ca tsi xo toa noho Jahëpa jisish cato. Jisniquë toa Dios quima ax jonish ca roha. ");
INSERT INTO caoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mato parayamaquia. Bëso-bësopaoxëhi quiha ë qui chitimicanaibo iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Jasca, Bësomati Mapari ca ëa xo naa. ");
INSERT INTO caoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Jabi nai ax paquënish ca mapari mato rëquëbo yamabá pini quiha xaba xo na. Pihax ja rësoyocaniquë ra. Jato bëso-bësopaomayamani quiha toa mapari ra. ");
INSERT INTO caoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jama, tobi quiha nai ax johax ca Mapari huëtsa ra. Rësoyamaxëhi quiha tsohuëcara ca naa Mapari pihai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Mato parayamaquia. Nai ax botënish ca Bësomati Mapari ca ëa xo naa ra. Bëso-bësopaoxëhi quiha tsohuëcara ca naa Mapari pihai cato. Jabi naa Mapari tsi xo noho yora ra. Ja acacani quiha maí ca nohiria bo xabahamati —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jatsi jato xërëquë tsi joi mëranatsi jodiobá huaniquë. —¿Jënahuariaxo raca noqui jahuë yora ja ana? Pinoma quiha —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jatsi Jesú quëbiniquë: —Mato parayamaquia. Pihacati xo Nohiria Baquë. Acacati xo jahuë jimi ra. Jabi xabahamahacatimaxëni tsi xo toa Dios baquë biyamahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Jama, bëso-bësopaoxëhi quiha noho yora pihai cato, noho jimi acai cato. Jaroha ca barí tsi quiha toa bësomaxëquia. ");
INSERT INTO caoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Piti-pitiria tsi xo noho yora ra. Ati-atiria tsi xo noho jimi ra. ");
INSERT INTO caoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","E nohó bësoxëhi quiha noho yora pihai cato, noho jimi acai cato. Jasca, jahá tsi bësoxëquia ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Jabi ëa raanish cato chamá tsi bësoyoiquia ra. Jascaria, noho chamá tsi bësoyoihi quiha ëa pihai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Jabi naa nai ax botënish ca Mapari ca ëa xo naa ra. Mato naboyamabá pini ca mapari jascariama xo. Pihax ja rësoyocaniquë. Jama, bëso-bësopaoxëhi quiha tsohuëcara ca Mapari-maparia pihai cato ");
INSERT INTO caoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","—nëa tsi quiha nohiria bo qui Jesu nëcaniquë, Capernaum ca catiti xobo xo tsi tiisimaquí na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jahuë chani nicahax, —Noqui bëronoma xo ja yoahaina rë. ¿Jënahuariaxo raca no cahëna ra? —i Jesu rabëti bo rabë roha niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jato qui yosa jahuë chani ini quiha. Jatsi ja shinacanai ca cahëhax, —¿Mato ratiahi ni ë yoahana pa? —i jato qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mana, naa naipá tsi ë i-ipaoni quiha. ¿Jahari nai qui cati nori ë irohapino tsi jahuë ma shinaquë ana? ");
INSERT INTO caoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Jabi nohiria bësomahai ca tsi xo noho Shinana. Nohiria bësomayoiyamahi quiha noho yora ra. Pinoma xo toa ra. Jama, noho chani pi chahahuahi tsi bësoxëqui mato ra. Dios quima tsi xo naa mato qui ë yoahana. Jama, tobi quiha mato ó ca chahahuayamacanaibo rë —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Jabi rëquë rohari tsi ja qui chitimiyoi-canaibo, ja pasomaha cabo, tihi cabo Jesú cahëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jatsi Jesu chanitëquëniquë: —Yama tsi xo toa ë qui jamëpistia joti mëtsa cato itëquëquia ra. E qui noho Jahëpá mëpiti xo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jatsi pë huëstima ca banahuacanaibá Jesu jisbërianiquë jahuë chani nicaxo na. Jato jabi siri bo qui ja bacacaniquë pë. Jesu ya ja bocasyamacani quiha jahuë chani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jisbëriajahuacaquë tsi quiha, —¿Ea jisbëriacascanai mato ri rë? —i jahuë doce ca rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jatsi, —¿Tsohuëcara qui no cana, Ibobá? —i Pedro niquë—. Mia roha tsi xo toa bësomati chani jaya cato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jaboqui mi qui chitimiqui noa. Dios quima ax mëstëxëni ca mi nori ca cahëyoiqui noa ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jatsi Jesú quëbiniquë: —Mato tëquë ë biniquë. Doce ca xo mato. Jama, mato ó ca huësti ca tsi xo toa ëa pasomaha cato rë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jabi Judas Iscariote yoati chanihi Jesu ini quiha. Jabi soldado bo qui Jesu mëaxëti ca ja ini quiha; naa Jesu doce ó ca huësti cato pa. ");
INSERT INTO caoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jaquirëquë quiha Galileá tsi Jesu chitëniquë. Jodioba mai qui jiconoma ja ini quiha, jodiobá acasni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jabi tsëquëpaimaria jodioba fiesta ini quiha, naa tapás racatiyá no. ");
INSERT INTO caoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Toatiyá tsi quiha Jesu qui jahuë noma bo chaniniquë: —Jodioba mai qui jahari cata. Mi acai ca jisti bo mia banahuacanaibá jisno ra. Naa mai jisbayahuë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","¿Jënahuariaxo nohiria bá mia cahëna, jonë tsi mi chitëquë no? Jisti bo aapiquí tsi nohiria bo qui mi acai ca jahuë bo jismata —i Jesu qui jahuë noma bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Jabi Jesu qui chitimiyoiyamani quiha jahuë noma bo ri rë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jatsi Jesú jato quëbiniquë: —Canoma xo ëa ra. Jari noho xaba ma xo toa ëmë nohiria bo jismati. Jama, mato qui jia tsi xo jaboqui fiesta qui cahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mato qui caxayama xo nohiria bo. Mato ayamacaxëcani quiha. Jama, ë qui caxariacani quiha, jato yoi ca ja acanai ca pasomaha ë chanihai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Fiesta qui bocata. Jari fiesta qui cayamaquia. Jari noho cati xaba ma xo ra —i jahuë noma bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jahuë noma bo qui chanihax Galileá tsi ja chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jariapari quiha jahuë noma bo Jerusalén qui bocaniquë fiesta qui. Ja bocaquë tsi quiha jonë tsi Jesu caniquë jaa ri. Bëro tsi ja cayamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jabi fiesta no tsi quiha jodiobá Jesu mërahi iniquë. Mërahax, —¿Jahuënia cara ca Jesu tia? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jabi nohiria xërëquë tsi quiha huëstima ca ranimis-hai ca iniquë Jesu yoati na. —Joni shina jiaxëni ca tsi xo naa ra —i jato rabë roha bo niquë, chaninahi na. Jama, —Jia yama xo Jesu ra. Nohiria bo parahi quiha pë —i huëtsa bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Jabi bëro tsi quiha Jesu yoati tsi ja chaniyamacani quiha, jato jodioba chama bo qui raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jatsi fiesta naamano tsi quiha jodioba arati xobo qui Jesu caniquë jaa ri. Caxo tsi quiha nohiria bo tiisimati ja chitahëhuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jatsi jodioba chama bo ratëniquë ja tiisimahai ca nicahax na. —Tiisi jaya xo naa joni pa. ¿Jahuëniá ca tiisi ja bini pa? Noba escuela bo xo tsi ja tiisimahacayamani quiha ra —i chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jaha tsi Jesú jato quëbiniquë: —Nohó-na ma xo naa ë tiisimahaina ra. Dios, naa ëa raanish ca quima johi quiha ë tiisimahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Dios shina aapicasquí tsi jahuënia ca ë tiisimahai ca joha ca cahëxëhi quiha Dios banahuacatsai cato tia. “¿Dios quima ni? ¿Joni quima ni?” ixëhi quiha, cahëcatsi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jama, jamë oquëhuacatsi quiha jahuë chani roha yoacatsai cato. Jama, jahuë raati ibo oquëhuacatsai ca tsi xo toa jabija ca chanihai cato. Parayamahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Jabi mato qui yoba Moisés ayamayamani? ¿Jënahuariaxo jahuë yoba nicayamacanai? ¿Jënixo tsi ëa pi acascanai pë? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jatsi nohiria bá quëbiniquë: —Yoyoxëni xo mia ra. ¿Tsohuëcaracá mia acatsana? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jatsi Jesú jato quëbiniquë: —Joiti barí tsi joni ë jënimahuaquë tsi ma shina-risiquihitaquë pa. ¿Mato qui yoi ni joiti barí tsi joni ë jënimahuahaina sa? ");
INSERT INTO caoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Tsayacahuë. Joiti barí tsi yonocoqui mato ri, Moisés ani ca jibirishati jabi ma aquë no ra. Jabi noba rëquëbo yamabo qui naa jabi acacani quiha Moisés qui nomari ra. ");
INSERT INTO caoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Jabi mato qui jënima tsi xo joiti barí tsi mato baquë bo jibirishahaina, Moisés yoba jatihuati. Jama, joiti barí tsi joni ë jënimahuano tsi ë qui caxaqui mato pë. ¿Jëni ni sa? ");
INSERT INTO caoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Moisés yoba pasomaha joiti barí tsi ë acai nori ca jascahuaqui mato pë. Jaxcamënaqui mato ra. Shinahaxma tsi ë qui quësoyamacana ra —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jatsi Jesu yoati tsi chaninatsi Jerusalén ca nohiria bo niquë: —¿Ja acascanai ca joni ma ni naa pa? ");
INSERT INTO caoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tsayacapa. Bëro tsi nohiria bo qui chanihi quiha ra. ¿Jëniriahax ja qui chaniyamahi ni noba chama bo pa? ¿Tonia Xabahamati Ibo ja nori ca cahëcahi ni sa? —i huësti huësti ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Jama, —Oca ma xo tia. Naa joni coni yaca cahëqui noa, naa noqui tëquëta ra. Jama, Xabahamati Ibo jisiquino tsi jahuënia ja johai ca cahëyamaxëqui noa ra —nëa tsi nohiria huëtsa bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jatsi arati xobó tsi Jesu nëcaniquë nohiria bo tiisimahi na: —¿Ea cahëyoicanai? ¿Jahuënia ax ë joni ca cahëyoicanai? E joyamaniquë ë jocasni iqui na. Jama, ë raahacaniquë. Jabija ca tsi xo toa ëa raanish cato. Toa cahëyamaqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jama, toa cahëquia ja quima ë joni iqui na. Ea ja raaniquë ra —i nohiria bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jatsi jodioba chama bo Jesu qui tsamicasniquë pë. Binoma quiha, jari jahuë rësoti xaba tsëquëyamani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Jama, toá ca nohiria huëstima cabo Jesu qui chitiminiquë ra. —Anomaria tsi xo naa joní jisti bo acaina ra. ¿Jënahuariaxo naa oquë ca jisti bo jaha no pasohai ca Xabahamati Ibobá ana? Ja tsi xo naa ra —i jaca niquë, ja qui chitimihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nëca tsi Jesu yoati tsi nohiria bo baxëxëquë tsi quiha jodioba chama bá ja chanicanai ca nicaniquë rë. Jaha tsi pë soldado bo ja raacaniquë Jesu qui tsamiti. ");
INSERT INTO caoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Japi Jesu nëcaniquë: —Tana roha pistia no tsi mato bëtaxëquia. Jaquirëquë ëa raanish ca qui jahari caxëquia. ");
INSERT INTO caoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","E cano tsi ëa mëraxëqui mato; mahitsa. Jasca, ë cahai ca qui canoma ixëqui mato ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jatsi chaninabëquitsi jodiobo niquë: —¿Jahuënia cacatsi ni naa joni sa? “Mahitsa ëa mëraxëqui mato” ii quiha pa. ¿Tonia pais huëtsa ca jodiobo qui cayamaxëhi ni? ¿Nohiria huëtsa bo tiisimacatsi ni? ");
INSERT INTO caoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Jënihi ni ja yoahana sa, “Ea mëraxëqui mato; mahitsa. E cahai ca qui canoma ixëqui mato” i ja quë no? ¿Jënihi ni sa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Jabi jaroha ca fiesta bari ja ini quiha. Jodiobo qui oquë toa bari ini quiha. Toa barí tsi quiha Jesu niiniquë nohiria bo qui chanixëna. Pistiama ca jahuë joi quiha. —E qui jopaima xo tsohuëcara tëshinahaina. Bësomati jënë ja qui axëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","“Tsohuëcara ë qui chitimino tsi jahuë shina quima huahuaxëhi quiha bësomati jënë” ii quiha Quënëhacanish cabo —nëa tsi Jesu nëcaniquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jabi Espíritu Santo yoati tsi chanihi Jesu ini quiha, naa chahahuacanaibo qui acacati cato. ");
INSERT INTO caoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","—Tonia Dios Chani bëhai ca tsi xo naa joni ra —i huëstima cabo niquë, Jesu chani nicahax na. Jasca, —Nohiria Xabahamati Ibo tsi xo naa ra —i nohiria huëtsa bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jama, —Nohiria Xabahamati Ibo ma xo tia. Galilea mai ax joyamahi quiha jaha no pasohai ca Xabahamati Ibo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Tsayacahuë. Belén, naa noba David yamabo racani cató tsi coxëhi quiha jaha no pasohai ca Xabahamati Ibo ra. David yamaba chahitaxocobo ixëhi quiha ra —nëa tsi quiha huëtsa bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ja iqui tsi jamëri jamëri ini quiha nohiria bá shinahaina Jesu yoati na. Huëstima cabo qui jia ja ini quiha, huëtsa cabo qui yoi ja nori. ");
INSERT INTO caoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Jasca, huësti huësti ca Jesu qui tsamicasniquë. Jama, jari ja qui ja tsamiyamacaniquë raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jatsi raahacanish ca soldado bo jahari bocaniquë jato jodioba chama bo qui. Jesu yama ja bëcani quiha. Jatsi, —¿Jënixo tsi Jesu ma bëyamacana pë? —i soldado bo qui chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jatsi, —Yama tsi xo nëca ca chanihai cato ra. Jiaria tsi xo naa joní yoahaina ra —i soldado bo niquë quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Jaha tsi jodioba chama bá jato raahaniquë: —¿Mato ri ja paraha pa? ");
INSERT INTO caoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Japa noqui? ¿Toa joni chahahuahi ni noa, naa noqui fariseobo, noqui chama bo? Ayamaqui noa; ¿tsayacanai? ");
INSERT INTO caoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jama xo nohiria bo pë. Dios Chani cahëtimaxëni ca xo ra. Yoshihuahacanish cabo tsi xo naa nohiria bo ra —i soldado bo qui chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jatsi Nicodemo, naa baquichá tsi Jesu qui canish ca chaniniquë chama bo qui. Jabi chama Nicodemo ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Naa joni nicahaxma tsi ja qui quësoqui noa pë. ¿Noba yoba pasomaha ma ni naa no acaina? Jariapari ja acai ca no cahëxëti xo —i Nicodemo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Jatsi chama bá Nicodemo ri raahaniquë pë: —¿Yoiria ca galileabo ma ni mia ra? Quënëhacanish cabo tsayahuë. Yama tsi xo Galilea ax johai ca Dios Chani bëhai cato ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Fiesta quirëquë jato xobo qui nohiria boyocaniquë. Jama, Maca Olivo Ya qui Jesu caniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jatsi huëaquë tsi baquishmari tsi quiha jahari arati xobo qui ja bacaniquë. Jatsi ja qui nohiria tëquë bëcani quiha. Jatsi tsahoxo tsi quiha tiisimati Jesú chitahëhuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Tiisimajahuano tsi quiha Dios yoba cahëxëni cabo, fariseobo, tihi cabá jochahuaxëni ca yoxa bëniquë Jesu qui; naa joni huëtsa ya inish cato; naa bënë ma ca ya tsamihacanish ca yoxa quiha. Bëxo tsi quiha nohiria bësojó tsi yoxa ja nimacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Jatsi Jesu qui ja chanicaniquë: —Joni huëtsa, naa jahuë bënë ma ya quiha naa yoxa iquë pë. No jisquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","“Ja qui nohiria bá maxax niano. Namëhacati xo tocacanaibo” ii quiha Moisés yamabo jahuë yoba ó no. ¿Japa mia ti? ¿Jënihai naa yoxa yoati na? —i jaca niquë Jesu qui. ");
INSERT INTO caoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ja nëcacani quiha Jesu tanamaxëna. Jahuëcara ca ja pasomaha ca ja mëracascani quiha pë, ja qui quësocasquí na. Jatsi Jesu tëtohaca tsi mai tsi huishatsijahuaniquë jahuë mëtsisí no. Quëbiyamaniquë Jesu. ");
INSERT INTO caoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Jatsi, —¿Japa naa yoxa? ¿Jënihai? —iriatsi jaca niquë pë. Jaha tsi Jesu niiniquë chanixëna. Chanipama tsi, —Jariapari ja qui maxax niati xo tsohuëcara ca jochayama cato ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jatsi ja tëtotëquëhaca tsi mai tsi ja huishatëquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jahuë chani nicapama tsi quiha huësti huësti tsi yoxa qui quësocanaibá jisbërianiquë. Jariapari bocaniquë yosibo. Jaquirëquë shinapaya bo bocaniquë. Jatsi jamëpistia tsi Jesu iniquë niihai ca yoxa ya. ");
INSERT INTO caoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jatsi Jesu niitëquëniquë. —¿Jahuënia ni mi qui quësocanaibo, yoxa? Yama tsi xo toa mi qui quësocatsai ca huësti cato pa —i yoxa qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—Yama a. Boyocaquë pa, Ibobá —i yoxá niquë. Jatsi, —Mi qui quësoyamaquia ëa ri. Cata. Jaboqui rohari tsi jochayamahuë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jatsi arati xobó ca nohiria bo qui Jesu chanitëquëniquë: —Maí ca nohiria Huëa ca ëa xo naa. Ea pi banahuahi tsi tsëmó tsi coyamaxëhi quiha mato. Mato quinia bërohuaxëquia, naa Huëa ë nori cato. Nohiria Bësomati Ibo ca ëa xo naa —nëa tsi ja nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jatsi jodioba chama bá quëbiniquë: —Mimë yoati tsi chaniqui mia pë. Mahitsa tsi xo toa mi yoahaina ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jatsi, —Emë yoati tsi ë chanipino tsi jari jabija xo noho chani ra, jahuënia ax ë joni ca ë cahëhai quëshpi na. Jasca, ë caxëhai ca cahëquia. Jama, jahuënia ax ë jonina, jahuënia tsi ë caxëhaina, tihi cabo cahëyamaqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ea ma cahëhai ca quëscahuaqui mato, nohiria quiniá tsi ma shinahai quëshpi na. Ja tsi xo toa ë pasomaha tsi xo mato chani. Toca tsi nohiria qui quësoyamaquia. ");
INSERT INTO caoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Quësohë-pino tsi jabija tsi xo toa ë quësohaina, ëmëpistia ax tsi ë quësoyamahai quëshpi na. Ea, ëa raanish cato, tihi caba tsi xo toa nohiria qui quësohaina. ");
INSERT INTO caoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Iriama tsi xo toa huësti roha ca joni jabija ca chanihaina. Oquë tsi xo dos. “Dos ca joni bo iti quiha” ¿iyamayamani mato yoba ra? “Jabija tsi xo dos ca joni ba chani, jasca ca ja chanicaquë no” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Jabi ëa yoati chanihai ca huësti ca ëa xo naa. Ea yoati chanihai ca huëtsa tsi xo naa ëa raanish ca Jahëpa —nëa tsi jodioba chama bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Jatsi Jesu ja nicacaniquë: —¿Jahuënia ni mi ipa ra? —iquiina. Jatsi, —Ea cahëyamaqui mato ra. Jasca, noho Jahëpa cahëyamaqui mato. Ea pi cahërohaquí tsi noho Jahëpa ma cahëquë aquë ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Arati xobó tsi Jesu nëcani quiha nohiria bo tiisimahi na. Nohiria parata biti caja tahë tsi nii ja ini quiha. Jasca, Jesu qui ja tsamiyamacani quiha, jari jahuë rësoti xaba tsëquëyamani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jatsi nohiria bo qui Jesu chanitëquëniquë: —Caxëquia. E cano tsi ëa mëraxëqui mato; mahitsa. Jatsi mato jocha ó tsi rësoxëqui mato rë. Jabi ë cahai ca qui canoma xo mato —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jatsi, —¿Jahuë chanihi ni sa? ¿Jamë ixëhi ni sa? ¿Jëniriahax “E cahai ca qui canoma xo mato” i ja a sa? —i jodiobo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jatsi Jesú jato quëbiniquë: —Maí ca nohiria bo xo mato. Jama, mana ax jonish ca ëa xo naa. Nëá racaqui mato. Nëá racayamahai ca ëa xo naa. ");
INSERT INTO caoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Jabija tsi xo toa “Mato jocha ó tsi rësoxëqui mato” i ë ana. Xabahamati Ibo ë nori ca chahahuayamapihi tsi mato jocha ó tsi rësoxëqui mato ri —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jatsi, —¿Tsohuëcara ni mia ra? —i nohiria bo niquë. Jatsi, —¿Jënahuariahax “Tsohuëcara ni mia” icanai pë? Rëquë rohari tsi mato ë yoani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Jari huëstima tsi xo toa mato yoati tsi ë yoahama cato, naa yoi ca ma acaina. Jama, ëa raanish cató ëa yoahai ca roha chaniquia. Emë yoati chaniyamaquia ra. Jabija tsi xo toa ëa raanish cato chani ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jabi jahuë Jahëpa Dios yoati tsi chanihi ja ini nori jodioba chama bá cahëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jaha tsi, —Jihui ó tsi ëa, naa Nohiria Baquë namëxëqui mato ra. Namëxo tsi jaha ma pasohai ca Xabahamati Ibo ë nori ca cahëxëqui mato ra. Toatiyá tsi ëmë ax tsi ë yonocoyamahai ca cahëxëqui mato, Jahëpá ëa tiisimani ca jahuë bo roha ë yoahai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","E bëtá xo ëa raanish cato ra. Ea jisbëriayamaxëhi quiha, ja qui jia ca ë aroha-arohahai quëshpi na —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Nëcajano tsi quiha huëstima cabo Jesu qui chitiminiquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jatsi ja qui chitimihai ca jodiobo qui Jesu chaniniquë: —E tiisimahai ca nicapihi tsi noho rabëtiria bo ixëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Jabija ca cahëxëqui mato. Jocha quima mato paquëmaxëhi quiha jabija ca Chani —i ja niquë jodiobo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jatsi, —Abraham yamaba chahitaxocobo xo noa ra. Yama tsi xo toa noqui yonahaina. ¿Jënahuariahax “Paquëmahacaxëqui mato” i mi na? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jatsi Jesú quëbiniquë: —Mato parayamaquia. Jocha yonati tsi xo toa jatiroha ca jochacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Jabi noitiria tsi xo yonati. Jahuë chama xobó tsi chitëroha-chitërohayamahi quiha, chama huëtsa qui ja iniahacamitsa iqui na. Jama, jamëri tsi xo chama baquë. Jahuë jahëpa xobó tsi chitëroha-chitërohahi quiha. Chama huëtsa qui iniahacatimaxëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Jasca, jocha quima Dios Baquë́ mato tsëcarohapino tsi shoma-shomaria ixëqui mato, naa chama baquë jascaria iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Jabija. Abraham yamaba chahitaxocobo xo mato iquia ëa ri. Jama, jari mato qui yoi xo noho chani rë. Noho chani bicasyamaquí tsi ëa acasqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Jatsi nicaparicana. Noho Jahëpá ëa jismani ca jahuë bo yoati chaniquia ra. Jama, toa chani nicacasyama xo mato pë, mato jahëpá yoba nicacasquí na —nëa tsi jodiobo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Jatsi, —Noho Jahëpa yoi tsi xo Abraham yamabo ra —i jaca niquë. Jatsi, —Abraham chahitaxocobo yoi bo irohapiquí tsi jia ca ma aquë aquë ra, naa ja ani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Jama, jaboqui ëa acasqui mato pë, jabija ca mato qui ë chaniquë no. Toca tsi Abraham yamabá ayamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Jabi mato jahëpa yoí acai ca jascaria ca aqui mato ra —i jato qui Jesu niquë. Jatsi jodiobá quëbiniquë: —Jia tsi no coniquë ra. Yoma bo ma xo noa. Noba Jahëpa yoi tsi xo Dios ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jato Jesú quëbiniquë: —Dios pi mato jahëpa iirohano tsi ëa ma noiquë aquë ra. Dios quima ax ë joniquë ra. Emëpistia tsi ë joyamani quiha. Jama, Diós ëa raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Jënahuariaxo ë yoahai ca jahuë bo cahëyamacanai pë? Noho chani nicacasyama xo mato iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","¿Tsayacanai? Yoshi-yoshiria tsi xo toa mato jahëpa yoi ra. Mato jahëpa jaha quëëhai ca acasqui mato. Rëquë rohari tsi ati ibo ja ini quiha. Quiamisxëniria quiha. Jabija ca chanitimaxëni quiha. Jahuë jabi tsi xo quiamis-haina ra. Quiati ibo-iboria tsi xo toa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ja tsi xo toa jaboqui tsi jabija ca ë chanino tsi ëa chahahuayamaqui mato pë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Jënahuariahax tsi ë qui ma quësona? Jocha yama ca ëa xo naa. Jabija ca ë yoano tsi ¿jënihax tsi ë qui chitimiyamacanai? ");
INSERT INTO caoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","¿Tsayayamacanai? Dios Chani nicahi quiha Diós-na bo. Tocama xo mato rë. Dios baquë bo ma xo mato ra. Ja tsi xo toa Dios Chani nicayamaqui mato iquia —nëa tsi quiha jodiobo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jatsi jodiobá quëbiniquë caxaquí na: —Dios cahëtimaxëni ca carayana xo mia ra. Mia ri tsi xo toa yoshi jaya cato ra. ¿Jabija ma ni naa no yoahaina mia yoati na? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jatsi, —Yoshi yama ca ëa xo naa ra. Chanipama tsi Noho Jahëpa oquëhuaquia ra. Jama, mato tsi xo toa ëa ocahuahaina pë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Emë oquë bicasyama xo ëa; jama tobi quiha huëtsá ëa oquëhuacatsaina. Ea mëbicatsai ca tsi xo toa. ");
INSERT INTO caoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nicaparicana. Mato parayamaquia ra. Rësopistiayamariaxëhi quiha noho chani nicacanaibo —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jatsi jodiobá quëbiniquë: —Jabija. Mia ri tsi xo yoshi jaya. Rësoniquë Abraham ra. Rësoyoniquë Dios Chani yoanish cabo ri. Jama, “Rësoyamapistiariaxëhi quiha noho chani nicahai cato” ¿i mi a pa? ");
INSERT INTO caoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Abraham yamabo oquë ni mia pa? Ja rësoniquë ra. Rësoyoniquë jaquirëquë ca Dios Chani yoanish cabo ri. ¿Jënahuaria raca jato oquë ca mi ina? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jatsi Jesú jato quëbiniquë: —Emë ë oquëhuapino tsi iriama tsi xo noho oquë ra. Jama, noho Jahëpa tsi xo toa ëa oquëhuahai cato, naa noba Jahëpa ma quënahai ca jascaria cato. ");
INSERT INTO caoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Dios cahëyamaqui mato rë. Jama, Dios cahëhai ca ëa xo naa. “Dios cahëyamaquia” irohapihi tsi quiaxëni ca ë iquë aquë pë, naa quiaxëni cabo ma nori jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Jasca, ë johai ca xaba mato jahëpa Abraham yamabá jiscasni quiha. Jasca, ë noho ja pasoni quiha. E noho pasohi tsi ja rani-ranini quiha —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jatsi jodiobá quëbitëquëniquë: —Jari cincuenta años ma xo mia ra. ¿Jënahuariaxo raca Abraham mi jisni? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jatsi, —Mato parayamaquia. Abraham conox pari no tsi ë iniquë ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Jatsi jodiobá maxax bo topiniquë Jesu axëna. Jama, jato quima Jesu paxaniquë. Paxaxo tsi quiha jato arati xobo ja jisbayaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Copama tsi quiha bëco ca joni Jesú jisniquë. Jahuë coni ca bari rohari tsi quiha bëco ja iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jatsi, —¿Jënihax tsi bëco tsi ja coni? ¿Tsohuë jochani? ¿Naa joni ni? ¿Jahuë nabo ni? —i jaca niquë Jesu nicahi na. ");
INSERT INTO caoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jatsi Jesú quëbiniquë: —Jochayamaniquë naa joni. Jasca, jochayamaniquë jahuë nabo ri. Bëco tsi ja coniquë ra, ja jënimahuahacahai cató tsi Diós jahuë chama jismano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Jatsi ëa raanish cato yonoco ë ati xo. Dios bax yonocoti xaba tsi xo naa ra. Joxëhi quiha baquicha. Ja jono tsi yama tsi xo toa Dios bax ë yonocoxëhaina. ");
INSERT INTO caoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Jama, maí ca nohiria bo yahi tsi maí ca nohiria ba Huëa ca ëa xo naa —nëa tsi quiha Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Chanihax mai tsi Jesú coshohaniquë. Coshohaxo tsi quiha jahuë quëyonó tsi matsa ja biqui-biquihaniquë. Jatsi matsacá tsi joni bëro ja sinoniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Sinohax, —Siloé icanai cato ca jënë́ tsi bëchocota —i bëco ca joni qui Jesu niquë. Jatsi joni caniquë. Bëchocohax tsi quiha ja taistëquëniquë. Jënima jahari ja joni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ja joquë tsi quiha ja tahë́ ca racacanaibo, toa joni cahëxëni cabo, tihi cabo ratëniquë. —¿Parata bënaxëni ca tsahonish ca joni ma ni naa pa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—¿Oca ma ni? —i jato rabë roha niquë. Jatsi, —Jama xo toa. Ja jisiria quiha —i nohiria huëtsa niquë. Jatsi, —Toa joni xo ëa ra —i parata bënaxëni ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jatsi, —¿Jënahuariaxo raca mi bëro jënimahuahacaha pa? —i ja qui nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Jatsi joní quëbiniquë: —Tsohuëcara ca, naa Jesu icanai cató matsa biqui-biquihaquë. Jatsi noho bëro ja sinoquë pa. Sinohax, “Siloé ca jënë́ tsi bëchocota” i ë qui ja quë. Jatsi jënë qui ë caquë. Bëchocohax ë taisquë ra —i jato qui joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jatsi, —¿Jahuënia ni naa joni ra? —i nohiria bo niquë nicahi na. —¿Jahuënia cara ca tia? Cahëyamaquia rë —i joni niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jatsi bëco inish ca joni nohiria bá boniquë jodioba chama bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jabi joiti bari ja ini quiha, naa matsacá tsi Jesú joni bëro taismaquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jatsi fariseobá, naa jodioba chama bá toa joni nicaniquë jato ri: —¿Jënahuariahax mi taismahacaha sa? —iquiina. Jatsi joní quëbiniquë: —Noho bëró tsi matsa naa joní janaquë tsi ë bëchocoquë. Jaboqui taisquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jatsi, —Dios cahëyamahi quiha naa joni ra. Joiti barí tsi yonocohi quiha pë —i jato rabë roha niquë. Jama, —Jistiria naa joní aquë ra. ¿Jënahuariaxo raca jochahuaxëni ca joní nëca ca jisti ana? Tonia Dios cahëhi quiha —i fariseobo huëtsa bo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jatsi bëco inish ca joni qui chama bo chanitëquëniquë: —¿Japa mia ti? ¿Jënihai mia ri naa joni yoati na? ¿Tsohuë ni naa joni, naa mia taismahax cato? —i jaca niquë. Jatsi taismahacanish cató quëbiniquë: —Dios Chani yoati ibo tsi xo naa joni iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jabi bëco ja iqui ca jodioba chama bá chahahuayamani quiha pë. Jaha tsi jahuë jahëpa, jahuë jahëhua, tihi cabo ja bënacaniquë jato nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—¿Mato baquë ni naa? ¿Bëco tsi ja coni? ¿Jënahuahax tsi jaboqui taisti mëtsa ja iqui? —i jahuë nabo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jatsi jahuë nabá quëbiniquë: —Noba baquë yoi xo naa. Jabija, bëco tsi ja coni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","¿Jënahuariahax ja taismahacaha sa? ¿Tsohuëcaracá taisamaha sa? Cahëyamaqui noa ra. Nicacana, shina coshi xo. Jamë xo mato ja yoano —i jahuë jahëpa niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nëca tsi jahuë nabo chanini quiha, jodioba chama bo qui raquëhi na. Jodioba catiti xobo quima ja niahacacasyamacani quiha. Jabi “Niahacati quiha tsohuëcara ca ‘Jaha no pasohai ca Xabahamati Ibo xo naa joni’ icanaina” i jodiobo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Jabi ja tsi xo toa “Shina coshi xo noba baquë. Nicacana” i jato qui jahuë nabo ni quiha. Jasca, arati xobo quima ja niahacacasyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jatsi jodioba chama bá bëco inish ca bënatëquëniquë: —Quiayamahuë. Jochahuaxëni ca Jesu nori ca cahëqui noa ra —i ja qui chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Jatsi, —¿Oca ma ni? Cahëyamaquia. Jabi bëco ca joni ë iquë; jaboqui taisquia ra —i bëco inish ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jatsi, —¿Jënahua mi bax jahuaha? ¿Jënahuaxo tsi mia ja taismaha? —i tëquë chama bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jatsi bëco inish cató jato quëbitëquëniquë: —Ja aca mato ë yoaquë ra. ¿Ea ma nicayamacana? ¿Tonia jahuë rabëti bo manëcascanai pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jatsi toa joni ja raahacaniquë pë: —Jesu rabëti xo mia pë. Jama, Moisés yamabo banahuacanaibo xo noa. ");
INSERT INTO caoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moisés yamabo qui Dios chanini ca cahëqui noa. Naa Jesu cahëyamaqui noa. Tsohuëcara quima jahuë chama ja bini cahëyamaqui noa —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Jatsi joní jato quëbiniquë: —Anomaria tsi xo toa naa joní acana. Noho bëro ja jiahuaquë ra. Jama, ¿jahuënia ax ja joni ca cahëyamacanai pa? ");
INSERT INTO caoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Jochacanaibo nicayamahi quiha Dios ra. Jama, ja qui aracanaibo, jahuë yoba bo nicacanaibo, tihi cabo nicahi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Mai nëhohuahacanitiya rohari tsi bëco conish ca jënimahuahacahai ca nicahama ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dios quima joyamarohapihi tsi ati mëtsama naa joni iquë aquë ra —nëa tsi bëco inish ca nëcaniquë jodiobo chama bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Jatsi, —Jochahuaxëni mi coniquë ra. ¿Noqui tiisimahi ni mia pa? —i jaca niquë. Jatsi quiha jato arati xobo quima toa joni ja niacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jabi jato arati xobo quima ja niahacani ca Jesú nicaniquë. Nicaxo tsi quiha joni mërahi ja caniquë. Bichi tsi quiha, —¿Nohiria Baquë qui chitimihai? —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jatsi joní quëbiniquë: —¿Tsohuë ni toa, Taitá? Toa joni qui chitimicasquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jatsi, —Mi jisquë ra. Ja tsi xo toa mi bëta chanihai cato —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Chitimiquia, Ibobá —i joni niquë. Jatsi Jesu bësojó tsi quiha ja mëniniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jatsi Jesu chaniniquë: —Naa mai qui ë joniquë nohiria ba jocha bërohuaxëna. Bëco cabo, naa jochacanaibo mëbicasquia ra, xabahamati quinia ja jiscano. Jama, ëa iqui tsi bëconayoicani quiha “Bëco yama xo noa” icanaibo. Jato jocha jisyamacani quiha rë —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jatsi, —¿Bëco ni noa pa? —i toa ca chama rabë roha bo niquë, ja yoani ca nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jatsi Jesú quëbiniquë: —Jabija ca cahëyamarohapihi tsi quësohacatima ma iquë aquë. Jama, tobi mato jocha rë, “Bëco yama xo noa” ma iquii iqui na —nëa tsi quiha Jesu nëcaniquë jato qui chanihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","—Mato parayamaquia —i Jesu niquë—. Oveja yomaxëni ca tsi xo toa oveja panë caiti qui jicoyamahai cato. Iti huëtsá tsi matarahi quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jama, panë caiti qui jicohi quiha oveja ototi ibo. ");
INSERT INTO caoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ja jono tsi quiha ja bax caiti japëcahi quiha panë obëso cato. Jicoxo tsi jato janë́ tsi jahuë oveja bo quënahi quiha. Jabi iboba joi cahëhi quiha oveja bo. Quënaxo tsi cacha jato rëquëninihi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Paquëmahax jato bëbo cahi quiha ibo. Jatsi, banahuacani quiha jahuë oveja, jahuë joi cahëquí na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Joni huëtsa banahuayamacani quiha. Ja quima jabacaxëcani quiha jahuë joi cahëyamahi na —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Naa chani pistia Jesú yoaniquë nohiria bo mëbixëna. Jama, ja yoani ca nohiria bá cahëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jatsi quiha jahuë chani Jesú bërohuaniquë ja cahëyoicano. Ja nëcani quiha: —Mato parayamaquia. Oveja panë Caiti ca ëa xo naa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Yomaxëni cabo jascaria tsi xo ëa bëbo bëcanish cabo, naa mahitsa ca tiisimacanaibo. Jato qui nicayamahi quiha noho oveja yoi bo. ");
INSERT INTO caoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Jabi Caiti xo ëa ra. Xabahamahacaxëti xo toa tsohuëcara ë noho jicoti cato. Jahá bësoxëquia. Toa shomahuaxëhi quiha Dios. Yamaxëhi quiha toa ja naris-haina iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","‘Jama, oveja yomahi johi quiha yomaxëni cato. Joxo tsi oveja namëhi quiha. Quëyohi johi quiha rë. Jabi tocahi quiha mahitsa ca tiisimacanaibo pë. Jama, ëa ti tsi xo toa nohiria bësomahi johaina, oquë tsi ja bësocano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jabi oveja ototi ibo jiaxëni ca ëa xo naa. Emë aapiquia oveja bax nati. ");
INSERT INTO caoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jama, oveja jisbëriahi quiha yonati, johai ca cama jisi na. Jishopë, jato obëso ca ma xo toa. Oveja ibo ma quiha. Ja jabano tsi oveja pihi quiha camano. Jatsi jato pacanamahi quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jasca, parata quëshpi roha yonocohi quiha yonati. Oveja noiyamahi quiha rë. Jabi ja tsi xo toa jabahi quiha yonati, cama joquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Jama, oveja ó bësoti jiaxëni ca ëa xo naa. Noho oveja cahëquia, naa ëa noho Jahëpá cahëhai jascaria. Jascaria, ëa cahëcani quiha noho oveja, naa noho Jahëpa ë cahëhai jascaria. Oveja bax ëmë aapiquia nati. ");
INSERT INTO caoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Jasca, oveja huëtsa bo jaya xo ëa ra. Carayana ca nohiria bo ca xo. Jato ri rëquëninixëquia. Noho joi qui nicacaxëcani quiha jato ri. Jatsi huësti ca nohiria maxo icaxëcani quiha jodiobo, carayanabo tëquë. Huësti ca ototi ibo jayacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","‘Jabi ëa noihi quiha noho Jahëpa, oveja bax nati ëmë ë acai iqui na. Rësohax bësotëquëxëquia. ");
INSERT INTO caoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jabi yama tsi xo toa jahuë chamá tsi ëa namëti mëtsa cato. Jama, caxacanaibo qui ëmë aquia nati. Noho chamá tsi ëmë aquia nati. Jasca, noho chamá tsi bësotëquëxëquia. Jabi noho Jahëpá ëa raaniquë nohiria bo bax nati —nëa tsi quiha nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jatsi Jesú yoani ca iqui tsi jodiobo mapëxënaniquë. Rabë ca shinahai ca ja jayacani quiha Jesu tahëxo na. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—Yoshi jaya xo naa joni ra. Yoyoxëni quiha. ¿Jëniriaxo raca ja qui nicacanai pë? —i jodio huëstima cabo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jama, —Nëca tsi chaniti mëtsama xo yoshi jaya cato ra. ¿Jënahuariaxo raca yoyoxëni cató joni bo taismana? —i jodiobo tëxë bo niquë ja yoati na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jabi Jerusalén tsi quiha jodiobo mani iniquë. Dios qui jamë aquëquëti fiesta ja ini quiha. Jatiroha ca xënipá tsi quiha naa fiesta ja i-ipaocani quiha, matsitiyá no. ");
INSERT INTO caoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Toatiyá tsi quiha arati xobó tsi co-cohi Jesu iniquë, naa Salomón Portal icanai cató no. ");
INSERT INTO caoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Co-cojano tsi quiha jodioba chama bo ja qui quëtsoniquë ja qui chanicatsi na. —¿Jaha no pasohai ca Xabahamati Ibo ni mia sa? Bëro tsi noqui yoahuë. Yosanaqui noa ra. ¿Jënino noqui yoahai sa? —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jatsi Jesú jato quëbiniquë: —Mato ë yoahitaquë ra. E yoaquë tsi ëa chahahuayamahitaquë mato pë. Ea yoati tsi jabija ca chanihi quiha ë acai ca jisti bo. Jabi naa jisti bo aquia noho Jahëpa chamá no. ");
INSERT INTO caoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Jama, ëa chahahuayamaqui mato rë, noho oveja ma nomari iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Noho joi nicahi quiha noho oveja yoi bo. Jasca, noho oveja bo cahëquia. Ea banahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Jasca, jato bëso-bësopaomaxëquia. Bënotimaxëni ca xo. Jabi yama tsi xo toa ë quima jato tsëcati mëtsa cato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Jabi ë qui jato noho Jahëpá aniquë, jato ó ë bësono. Jatiroha cabo oquë tsi xo noho Jahëpa ra. Jabi yama tsi xo toa noho Jahëpa quima jato tsëcati mëtsa cato iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Jasca, ëa, noho Jahëpa, tihi ca tsi xo huësti roha cato —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jatsi pë jodiobá maxax bo topitëquëniquë axëna. ");
INSERT INTO caoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jatsi Jesú jato quëbiniquë: —Jisti huëstima cabo ë aquë mato bax na jisti. Ja acacaniquë noho Jahëpa chamá no. ¿Jëni ca jisti jiaxëni ca quëshpi tsi ëa acascanai pë? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jatsi quiha jodiobá quëbiniquë: —Mi acai ca yonoco jia ca quëshpi tsi mia acasyamaxo noa; jama Dios mi ocahuahai quëshpi ja nori. Yoi tsi xo toa mi chanihaina ra. Jasca, Dios manëcasqui mia pë, joni roha mi nori —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jatsi Jesú quëbiniquë: —Yoi ma xo ë chanihana ra. Quënëhacanish cabo ó tsi “dios bo” mato rëquëyamabo quënahacani quiha, “Dios bo xo mato” i jato qui Dios quë no. ");
INSERT INTO caoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Quiayamahi quiha Dios Chani ra. “Dios bo” ja quënahacani quiha, naa Dios Chani bicanish cabo. Dios bo xo nohiria tëquë; jahuë jabi ja jayacanai iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Japi “Dios baquë xo ëa” iti mëtsa xo ëa ri ra. Jabi noho Jahëpa Diós ëa biha ca tsi mai qui ëa ja raaniquë. Jatsi, ¿jënahuariahax raca “Dios ocahuaqui mia pë” i ë qui ma na, “Dios Baquë xo ëa” i ë quë no? ");
INSERT INTO caoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Noho Jahëpa yonoco pi ë ayamano tsi ëa chahahuayamacana. ");
INSERT INTO caoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jama, jahuë yonoco pi ë ano tsi ë acai ca jisti bo chahahuacana, ë qui ma chitimiquë mari. Noho jisti bo chahahuapiquí tsi ë nohó Jahëpa iquiina, jahá ë iquiina, tihi cabo cahëxëqui mato tia —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jatsi Jesu qui ja tsamitëquëcascaniquë namëxëna. Jama, jato quima ja paxaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Paxahax tsi quiha ani Jordán Jesú shitaniquë. Shitahax toa tsi quiha, naa jariapari ca Juán nohiria bo ashimani cató tsi ja chitëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Toatiyá tsi quiha Jesu qui huëstima cabo bëcaniquë. —Jisti bo Juán ayamaniquë. Jama xo naa joni ra. Ariahi quiha ra. Naa joni yoati tsi jabija ca Juán yoani quiha —i nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Toá tsi quiha huëstima cabo ja qui chitiminiquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Jabi iquihi quiha Lázaro iniquë rë. Betania yacatá tsi ja racani quiha jahuë yoxacabo ya; naa María, Marta, tihi cabo ya. ");
INSERT INTO caoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jabi Iboba tahë qui perojomë japanish ca María tsi xo naa. Jasca, jahuë boó tsi María Jesu tahë masani quiha. Toatiyá tsi iquihi jahuë jonica ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Jaha tsi quiha Jesu qui jahuë yoxacabá chani raaniquë: —Iquihi quiha mi rabëtiria rë, Ibobá —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jato chani nicahax, —Iquihi quiha Lázaro rë —i Jesu niquë jahuë rabëti bo qui—. Jama, rësoyamaxëhi quiha. Iquihi quiha, jia tsi Dios yoati tsi nohiria bo chanino iquish na. Dios Baquë oquë jismahacati xo jahá no —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jabi Marta, jahuë noma María, Lázaro, tihi cabo Jesú noini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jabi Lázaro iquihai ca yoati tsi nicahax jato xobo qui Jesu cayamatapiniquë pa. Jari dos bari no tsi quiha ja chitëniquë ja ini cató no. ");
INSERT INTO caoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jaquirëquë quiha, —¿Jahari jodioba mai qui canomani, naa Lázaro racahai ca qui? —i jahuë rabëti bo qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jatsi jahuë rabëti bá quëbiniquë: —Mia manacani quiha pë jodioba chama bo. Maxaxá tsi mia acascani quiha pë. ¿Jahari catëquëhai pa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jatsi Jesú jato quëbiniquë: —Jabi Diós ëa raaniquë jahuë yonoco ati. Jari jatihuahama xo noho yonocoti xabaca ra. Jasca, yama tsi xo toa ëa ati mëtsa cato jaboqui. Jari jatihuahama quiha noho yonocoti xabaca iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jama, Dios bax noho yonocoti xaba jatiquë tsi ë qui tsamixëhi quiha ë qui caxacanaibo —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jatsi, —Oxa xo Lázaro rë. Jaha bësomahi caquia ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jatsi, —Oxapihi tsi chamaxëhi quiha tia, Ibobá —i jaca niquë nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jama ja rësohitaha yoati tsi Jesu chanihi ini quiha. Jama, Lázaro oxahai ca ja quëscahuacani quiha; oxajano mari. ");
INSERT INTO caoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Jatsi bëroria tsi jato qui Jesu chaniniquë: —Nahitaquë Lázaro rë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","E qui jia tsi xo ja bëta ë yamahitahana ja rësoquë no. Ja iqui tsi oquëxëhi quiha ë qui ma chitimihaina ra. ¿Jisi canomani? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jatsi, —¿Jesu ya canomani, ja bëta rësoti? —i Tomás niquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Betania qui cahëxo tsi quiha naama, cuatro bari no tsi ja maihuahacani nori ca Jesú nicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jabi Betania basima Jerusalén ini quiha. Cariama quiha; una hora nama. ");
INSERT INTO caoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jaha tsi Jerusalén ax huëstima ca jodiobo bëcaniquë, Marta, María, tihi cabo bëpasimaxëna, jato jonica rësohitaha iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jatsi Jesu johai ca Martá nicaniquë. Nicaxo tsi quiha Jesu bëchahi ja caniquë. Cayamaniquë María. Xobó tsi ja chitëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jesu bëchahax, —Nëá pi mi rohano tsi noho jonica rësoyamaquë aquitaquë rë, Ibobá. ");
INSERT INTO caoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Jabi jaboqui jahuëcara ca Dios mi bënahai ca mi qui axëhi quiha tia —i Jesu qui Marta niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jatsi, —Bësotëquëxëhi quiha mi jonicato ra —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—Jabija; toca xo tia. Jaroha ca barí tsi bësotëquëxëhi quiha, naa jatiroha cabo bësotëquëxëquë no —i Marta niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jatsi Jesú quëbiniquë: —Rësonish cabo Bësomati Ibo ca ëa xo naa ra. Jabi bësotëquëxëhi quiha ë qui chitimihai ca bësoyama cato. ");
INSERT INTO caoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Bëso-bësopaoxëhi quiha tsohuëcara ca ë qui chitimihai cato. Dios quima aquëquëmahacatimaxëni ixëhi quiha. ¿Jabija ma ni, Martá? —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jatsi, —Jabija xo ra, Ibobá. Dios Baquë, naa nohiria bo jaha pasohai ca Xabahamati Ibo ca mia xo naa —i Marta niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Chanihax jahuë noma bënahi Marta caniquë. Cahax, —Joquë Maestro ra. Mia jiscatsi quiha —i ja qui Marta niquë, baxëxhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Nicahax joitapi María niquë Jesu qui caxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jari yaca cacha Jesu ini quiha, naa Marta ja bëchani cató no. ");
INSERT INTO caoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jabi María jisbayahai ca jisi tsi toá ca jodiobá banahuaniquë jato ri, naa xobó ca María bëpasimacanaibo. Ja banahuacani quiha, Lázaro maí tsi ja aracatsai quëscahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jatsi Jesu qui María cahëniquë. Cahëhax jatahë tsi quiha ja mëniniquë. Jatsi, —Nëá pi mi rohano tsi noho jonica rësoyamaquë aquitaquë rë, Ibobá —i María niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Araconaniquë María rë. Ara-araniquë ja bëta bëcanish ca jodiobo ri. Jaha tsi Jesu cohuërianiquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jatsi, —¿Jahuënia ni jahuë mai? —i Jesu niquë. —Jisi jopa —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jatsi aratsi Jesu niquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jatsi, —Tsayacapa. Lázaro ja noini quiha —i jodiobo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Jatsi, —¿Bëco cabo ja taismayamayamani? ¿Tonia rësohai quima Lázaro jënëmati mëtsa ja iyamayamahitaha? —i huësti huësti ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Cohuëriahax Lázaro mai qui Jesu caniquë. Jabi macaná ca quiní tsi ja maihuahacani quiha. Jasca, jahuë maiquini qui maxax chahitaxëni tarahacani quiha japati. ");
INSERT INTO caoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jatsi, —Tori maxax taracana —i nohiria bo qui Jesu niquë. Jatsi, —Pisi quiha, Ibobá. Ja rësohitaquë. Cuatro bari tsi quiha —i ja qui Marta niquë, naa rësohitahax cato yoxacato. ");
INSERT INTO caoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jatsi Jesú quëbiniquë: —“E qui chitimipiquí tsi Dios chama jisxëqui mia ra” ¿iyama mi qui ë a? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jatsi nohiria bá bahama maxax taraniquë. Jatsi nai qui Jesú tsayahaca tsi jahuë Jahëpa qui ja chaniniquë: —Ea nicaqui mia, noho Jahëpá. Ja quëshpi tsi “Gracias” iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ea mi nicarohahai ca cahëquia. Jama, naa nëá ca niicanai ca nohiria bax bëro tsi ë chaniquë, ëa mi raani ca ja cahëcano —nëa tsi jahuë Jahëpa qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jatsi Jesú quënaniquë: —Huajahuë, Lazaró —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jatsi rësonish ca Lázaro huajaniquë. Raití tsi jahuë tahë bo, jahuë mëquë bo, tihi cabo yabohacani quiha. Jasca, jahuë mapo ri yabohacani quiha raití no. Jatsi, —Yaboco ca mëristsacana. Ja cano ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jabi Jesú ani ca huëstima ca jodiobá, naa María jisi bëcanish cabá jisniquë. Jisi tsi quiha ja qui ja chitimicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Jama, jato huësti huësti cabo bocaniquë Jesú ani ca yoati tsi fariseobo qui yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jatsi arati ibo ba chama bo, fariseobo, tihi cabo jato jodioba chama bá quënaniquë, jato bëta chaninaxëna. —¿Jënahuariaxëhi ni noa rë? Jisti yoi bo aqui quiha naa joni ra. ");
INSERT INTO caoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Naa joni pi no jënëyamano tsi chahahuaxëhi quiha nohiria tëquë pë. Naa Jesu pi ja chahahuacano tsi joxëhi quiha romanoba soldado bo tonia, noba arati xobo potasxëna. Jatsi noqui quëyocaxëcani quiha ra tonia —nëa tsi chama bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Jatsi chanitsi jato huësti ca niquë, naa Caifas icanai cato. Jabi toa xëni no tsi quiha jato arati ibo-iboria ja ini quiha. Jatsi, —¿Jënahuariacascanai pë? ");
INSERT INTO caoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Oquë tsi xo huësti ca joni nohiria bo bax rësohaina iquia. ¿Jesu tahëhax tsi quëyohacaxëti ni noba maí ca nohiria bo ra? Ja rësono iquia —nëa tsi jato qui Caifás nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Jabi jamë yoi tsi chama Caifás chaniyamani quiha. Jama, toa xëni no tsi quiha arati ibo ba chama ja ini iqui tsi Dios quima jahuë chani joni quiha. Ocapixëti ca jahuë bo ja chanini quiha. “Noqui jodiobo ratixëhi quiha naa joni ra nati” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jasca, “Dios xocobo, naa pacanamahacanish ca carayanabo ri catiaxëhi quiha, huësti ca nabo amaxëna” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Jaha tsi toa bari rohari tsi jodioba chama bá Jesu acasni quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Japi nohiria xërëquë tsi quiha bëro tsi Jesu coyamani quiha. Toa chama bo iqui tsi quiha jodioba mai ja jisbayani quiha. Jisbaya tsi xaba basima ca qui ja cani quiha chitëxëna. Toá tsi quiha Efraín icanai ca yacatá tsi ja chitëniquë jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jabi basima jodioba pascua fiesta ini quiha. Jabi fiesta chitahënox pari no tsi huëstima ca nohiria Jerusalén qui bocaniquë jianati jabi axëna. ");
INSERT INTO caoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Arati xobó tsi catihax Jesu yoati tsi ja chaninabëquicaniquë. Jesu mërahi ja icani quiha. Nicahi tsi, —¿Japa? ¿Pascua fiesta qui joyamahi ni Jesu? —i nohiria bo niquë jiscascanina. ");
INSERT INTO caoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jabi jodioba chama bá Jesu bicasniquë pë ja qui tsamicasquí na. Jaha tsi, —Jesu jono tsi noqui yoacaxëcahuë —i nohiria bo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Toatiyá tsi quiha pascua fiesta tsëquëti basima iniquë. Seis bari tsi chitahëpaima ja ini quiha. Jatsi Betania qui Jesu caniquë, naa Lázaro xobo qui, naa Jesú bësotëquëmani ca joni xobo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Toa ax tsi quiha Jesu bax oriquiti shomahuahacaniquë. Jato taahi María ini quiha. Jasca, Jesu ya oriquihi Lázaro ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jatsi nardo icanai ca perojome copixëni cató tsi quiha Mariá Jesu tahë ashimaniquë. Ashimaxo tsi quiha jahuë boó tsi jahuë tahë ja masaniquë. Jatsi xobó tsi jahuë chopish rëamëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jatsi Judas Iscariote, naa Jesu rabëti chaniniquë. Jabi jodioba chama bo qui Jesu mëanish ca ja ini quiha. Jatsi, ");
INSERT INTO caoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Jënixo tsi naa perojome iniayamahacaha pa? Copixëni quiha. Ja iniahacarohapino tsi huëstima ca parata no biquë aquë rë, noitiria cabo ati ra —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jabi nëca tsi Judas chanini quiha, parata yomaxëni ca ja ini quëshpi na. Noitiria cabo ja noiyoiyamani quiha. Jasca, Jesu rabëti ba parata obëso ca ja ini quiha pë. Jaha bësoquí tsi quiha ja yomapaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jatsi Jesu chaniniquë: —Jënëmayamacana. Noho maihuati xaba bax yoxá ano. ");
INSERT INTO caoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Mato bëtarohaxëhi quiha noitiria cabo. Jama, mato bëtayamarohahai ca ëa xo naa ra —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jatsi Betaniá ca Jesu ini ca Jerusalén ca nohiria bá nicaniquë. Nicahax toa tsi quiha ja bocaniquë Jesu jisi na. Nohiria tirixëni quiha. Jasca, Lázaro ri, naa bësotëquëmahacanish ca ja jiscascani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jaha tsi Lázaro ri arati ibo ba chama bá acasniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Jabi Lázaro bësotëquëmahacani iqui tsi huëstima ca jodiobá jato rëquëniniti ibo bo jisbëriani quiha Jesu banahuaxëna. Jisbëria tsi quiha Jesu qui chitimitsijaca-niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Huëaquë tsi quiha Jerusalén qui Jesu johai ca nohiria bá nicaniquë, naa pascua fiesta bëcanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nicaxo tsi quiha xëbini pëhi jascaria cabo ja bicaniquë bahi poohati. Bichi tsi quiha Jesu bëchahi ja bocaniquë. Jatsi quënatsi nohiria bá huaniquë: —Jia xo Dios. Shomahuahaca ca tsi xo naa Iboba janë́ tsi johai cato ra. Noqui Israél caba chama-chamaria Diós shomahuano ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jatsi quiha Jesú burro biniquë. Bichi tsi jacacha ja tsahoni quiha, Quënëhacanish cabá yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Mato chama-chamaria qui raquëyamacana, Israél ca nohiria bá. Burró tsaho joxëhi quiha pa” i Quënëhacanish cabo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jabi toatiyá tsi toa quënëni ca Jesu rabëti bá cahëyamani quiha, naa toca tsi Jerusalén qui ja jicohai yoati na. Jama, nai qui ja tërohacaquë tsi Jesu yoati ja quënëhacani ca ja shinatapicani quiha. Jabi Quënëhacanish cabo jatihuahacani quiha toca tsi Jerusalén qui ja jicoquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Jasca, Jesu ya huëstima ca nohiria bo ini quiha maiquini quima Lázaro ja quënaquë no. Toa xo tsi quiha Lázaro ja bësotëquëmani ca ja tsayacani quiha. Tsayaxo tsi quiha Jerusalén ca nohiria bo ja yoacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Jabi ja tsi xo toa huëstima ca nohiria bëchahi bocaniquë, Jerusalén qui Jesu jicoquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jatsi chaninabëquitsi quiha jodioba chama bo niquë: —¿Jënahuariaxëhi ni noa pë? ¿Tsayacanai? Ja qui jabacani quiha nohiria tëquë pë —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Jabi Jerusalén qui bëcaniquë carayanabo. Rabë roha quiha. Pascua fiesta ati ja bëcaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipe qui basimahax, —Jesu jiscasqui noa, Señór —i quiha jaca niquë ja qui. ");
INSERT INTO caoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Jatsi Andrés yoahi Felipe caniquë. Jatsi Jesu qui ja bobëquicaniquë yoaxëna. Jatsi carayana bëcanai ca ja yoacaquë tsi quiha ");
INSERT INTO caoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesú quëbiniquë: —Joquë hora ra, naa Nohiria Baquë oquënaxëquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mato parayamaquia. Saihuayamaxëhi quiha trigo bëro, maí tsi ma banayamaquë no. Jascaria, Dios xocobo paxa bo sainox pari no tsi rësoparixëti xo Nohiria Baquë. E namëhacaxëti quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Parayamaquia. Quëyohacaxëti xo jahuë shina noixëni cato. Jama, xabahamahacaxëti xo toa jahuë shina noiyamahai cato. Bëso-bësopaoxëhi quiha toa. ");
INSERT INTO caoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ea banahuaxëti xo tsohuëcara ë bax yonococatsaina iquia. Jatsi nai qui ë tërohacano tsi ë bëtaxëhi quiha noho yonoco acai ca ri. Tsohuëcara pi ë bax yonocono tsi toa oquëhuaxëhi quiha noho Jahëpa ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","—Jaboqui shina-huëjënaquia rë. ¿Jënixëhi ni ëa rë noho Jahëpa qui? “Naa tënëti xaba quima ëa tsëcahuë ra, noho Jahëpá” ¿ixëhi ni ëa sa? Iyamaxëquia. E tënëxëti xo rë. Ja tsi xo toa ë joni quiha mai qui. ");
INSERT INTO caoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","E tënëhai cató tsi mi oquë jismahuë, noho Jahëpá, jia tsi nohiria bá mia oquëhuano iquish na —nëa tsi Jesu nëcaniquë. Jatsi naipá ca joi chaniniquë: —Noho oquë ë jismaquë. Noho oquë jismatëquëxëquia mi rësoquë no —i naipá ca joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jabi naipá ca joi toá ca nohiria bá nicaniquë. Nicahax, —Tërëjaquë pa —i jaca niquë. Jama, —Ja qui ángel chaniquë pa —i huëtsa bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jatsi Jesu jato qui chaniniquë: —Chaniyamaquë toa joi ë nicati quëshpi na. Jama, mato bax ja chaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Jaboqui quësohacaxëti xo chahahuayamacanaibo. Jasca, jaboqui bëbohacaxëti xo maí ca nohiria yonamisxëni ca Satanás. ");
INSERT INTO caoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jabi cruzó tsi namëhacaquí tsi nohiria tëquë ë qui bëxëquia —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jabi nëca tsi Jesu chaniniquë ja rësohai ca quinia jismaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Jatsi nohiria bá quëbiniquë: —Jaha no pasohai ca Xabahamati Ibo yoati tsi chanihi quiha Quënëhacanish cabo; “Bëso-bësopaoxëhi quiha Cristo” iquiina. Jatsi, ¿jënahuariahax raca “Namëhacaxëti xo Nohiria Baquë” i mi na? ¿Tsohuë ni naa “Nohiria Baquë” i mi aina? ¿Xabahamati Ibo jascaria ni? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jatsi quiha Jesú quëbiniquë: —Huëa ca ëa xo naa. Mato bëta naamayama-xëquia. Jaboqui tsi xo toa noho chani chahahuati xabaca ra. Jaboqui chahahuacana, jocha tsëmó mato bëbomitsa iqui na. Jabi jahuë quinia cahëyamahi quiha tsëmo ó cohai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Huëa ca jayaquí tsi chahahuacana, jahuë xocobo manëxëna —nëa tsi Jesu nëcaniquë. Jaquirëquë jato Jesú jisbayaniquë. Jisbaya tsi ja jonëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jabi huëstima ca jisti bo Jesú aniquë nohiria bo bësojo xo na. Mahitsa quiha. Jisxo tsi quiha jari Jesu ja chahahuacasyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jasca, jatihuahacati Isaiás quënëni ca ini quiha, naa, “Yama tsi xo toa no yoahai ca chani chahahuahai cato, Ibobá. Mahitsa jato qui Dios chama jismahacaquë rë” i ja quënëni ca nina. ");
INSERT INTO caoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Jabija, chahahuatimaxëni ja icani quiha rë, Diós jato bëro bëcohuani iqui na. Jabi toca tsi Isaías yamabá quënëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Diós jato bëcohuani quiha. Jato shina ja quëstohuariajahuani quiha, jabija ca ja jisyamacano, jato shinaná tsi ja cahëyamacano. Jasca, Dios quiri ja bësoyamacano, jato jocha ja masano iquish na” i ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jabi toca tsi Isaías yamabo chaniniquë ra toatiyá tsi Jesu oquë ja jisni iqui na. Jesu yoati tsi ja chanini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jama, jari huëstima ca jodiobá Jesu chahuaniquë. Jama, chahahuahax ja pasicaniquë pë, fariseobo, naa jato rëquëniniti ibo bo qui raquëhi na. ¿Jato catiti xobo quima ax ja niahacacasyamacani ma ni? ");
INSERT INTO caoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Jishopë. Nohiria bá jato oquëhuahai ca ja noicani quiha. Jato qui iriama Diós acai ca oquë ca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jatsi joi pistiamá tsi quiha nohiria bo qui Jesu chaniniquë: —Ea chahahuaquí tsi noho Jahëpa ri, naa ëa raanish ca chahahuayoiqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Jasca, ëa tsayaquí tsi ëa raanish ca jisqui mato. ");
INSERT INTO caoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Jasca, maí ca nohiria Huëa ca ëa xo naa. Mai qui ë joni quiha, tsëmo ó tsi ë qui chitimihai ca chitëyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Jabi noho chani nicacasyamacanaibo qui jaboqui quësoyamaxëquia. Jaboqui nohiria bo xabahamahi ë joniquë, tënëtiya qui jato raahi mari. ");
INSERT INTO caoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Jama, jaroha ca barí tsi quiha noho chaní tsi quësohacaxëti xo toa noho chani nicayamacanaibo, ëa biyamacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Jasca, jaboqui ë chanino tsi ë quima joyamahi quiha ë yoahaina. Noho Jahëpa quima quiha. Noho Jahëpá yoani ca mato qui ë yoaquë ra. Noho chani ma xo. ");
INSERT INTO caoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Jasca, nohiria bëso-bësopaomaxëhi quiha noho Jahëpa yoba bo ra. E chanihai ca tsi xo toa ë qui noho Jahëpá yoahana ra —nëa tsi nohiria bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Huëaquë tsi chitahëti nori quiha pascua fiesta iniquë. Toatiyá tsi noba mai jisbëriati xaba tsëquëha ca Jesú cahëni quiha. Jahëpa qui bacati xaba ja ini quiha. Jabi jahuë maí ca rabëti bo ja noiriani quiha ra. Jasca, jato ja noiriahai ca jato ja jismani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jabi jahuë rabëti bo ya oriquihi Jesu iniquë. Naama tsi quiha Judas Iscariote, naa Simón baquë Yoshiní bini quiha yoi ca shinamaxëna. Ja tsi xo toa jodioba chama bo qui mëatsi quiha Judás huaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jabi jatiroha ca Jesú cahëni quiha. Ja qui chama Jahëpá anina, Dios quima ja jonina, Dios qui jahari ja cahaina, tihi cabo ja cahëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Jatsi oriquihax mesa quima Jesu joiniquë. Joixo tsi quiha jahuë sacoria ja tsoboniquë. Tsoboxo tsi quiha toalla ja bihaca tsi ja chinëxëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jatsi pitëxti, naa lavamanos icanai ca qui jënëpaxa ja japaniquë. Japaxo tsi quiha jahuë rabëti ba tahë chocohatsijahua-niquë. Chocohaxo ja shinahuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jatsi Simón Pedro qui ja joniquë. —¿Noho tahë chocohahi ni mia pa, noho Ibobá? —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jatsi Jesú quëbiniquë: —Jaboqui tsi ë acai ca cahëyoiyamaqui mia. Jama, bari huëtsa cahëxëqui mia tia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jatsi, —Noho tahë ashimayamapistiariaxëqui mia ra —i Jesu qui Pedro niquë. Jatsi Jesú quëbiniquë: —Mi tahë pi ë ashimayamano tsi ¿jënahuariaxo raca noho yonoco mi ana? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jatsi, —Noho tahë ashimahuë, Ibobá. Jasca, noho mëquënë, noho mapo, tihi cabo ri ashimahuë ra —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jatsi nëca tsi quiha Jesú quëbiniquë: —Ashitëquëyamahi quiha bahuëhacanish cato ra. Ashimahacaxëti xo jahuë tahë roha, ja chëquënaquë no. Jascaria, jënima tsi xo masahacanish ca shina jaya cato. Masahacaxëti xo ja abëna ca jocha roha, ja jochaquë no. Bahuëhaca ca xo mato tëquëta. Jama, nëá xo huësti ca shina masahama ca jaya cato rë —i Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jodioba chama bo qui ja mëacasni ca Jesú cahëni quiha. Ja tsi xo toa, —Nëá xo huësti ca shina masahama ca jaya cato rë —i ja nina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jato tahë ashimaxo tsi quiha jahuë sacoria Jesú sahuëtëquëniquë. Jatsi mesa tahë ja tsahotëquëniquë. Tsahohax, —¿Jënixo tsi mato tahë ë ashimaha? ¿Cahëcanai? —i jato qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Maestro, Ibo, tihi cabo ëa quënaqui mato. Jabija tsi xo toa ma chanihaina, mato Ibo ë nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Jama, ¿jahuë yonati tahë ashimahi ni chama pa? ¿Tsayacanai? Mato tahë yoi ë chocohaquë ra, naa mato Ibo, mato Maestro ra. Toca tsi ma ati xo mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mato tahë ë chocohaquë ra, ototi quinia mato jismaxëna. Mato bax ë aca ca jascaria tsi huëtsa bo bax ma ano mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mato parayamaquia. Yama tsi xo toa jahuë chama oquë ca yonati. Jasca, raanish ca oquë ma xo raahacanish cato, naa jahuë ibo chani bëhai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Jabi naa yoba nicaquë mato. E yoaha ca yoba jabipihi tsi raniriaxëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","‘Mato tëquë yoati tsi chaniyamaquia. E bini cabo cahëriaquia ra. Jama, jatihuahacaxëti xo Quënëhacanish cabo, naa “Mia pasomaha tsi xo toa mi bëta xo pihai cato” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nicaparicana. Jodiobo chama bo qui ëa pi ja mëanox pari no tsi mato yoaquia, Xabahamati Ibo ë nori ca ma cahëno iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mato parayamaquia. Mato raaxëquia, noho chani nohiria bo qui boti. Ea yoi bixëhi quiha mato chani bichi cato. Jasca, ëa raanish ca Jahëpa ri bichi quiha ëa bichi cato —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Chanihax cohuëtsi Jesu niquë. —Mato parayamaquia. Jodioba chama bo qui ëa mëaxëhi quiha mato ó ca huësti cato rë —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jatsi bëisnabëquitsi jahuë rabëti bo niquë, —¿Tsohuë cara ni sa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jabi Jesu tapaí tsaho Juan ini quiha naa Jesu rabëti-rabëtiria. ");
INSERT INTO caoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Jatsi ja qui Simón Pedró jahuë mëquë bëë-bëëhaniquë, —¿Tsohuë yoati ni toa ja chanihaina? Nicahuë, no cahëno ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jatsi Jesu qui Juan xëquëniquë nicaxëna, —¿Tsohuë ni toa mia pasomaha cato rë? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jatsi Jesú quëbiniquë: —Pitëxti qui naa mapari nacomaquia moosaxëna. Nacomaxo tsi toa joni qui axëquia. Jabi ëa pasomaha ca tsi xo toa naa mapari bichi cato ra —i ja niquë. Jatsi quiha mapari Jesú nacomaniquë pitëxti qui. Nacomaxo tsi quiha Judas Iscariote qui ja aniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Jatsi mapari ja biquë tsi quiha jahuë shina qui Satanás jicotapiniquë pë. Jatsi, —Mi acatsai ca ahuë. Bamayamahuë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jabi Judas qui Jesú yoaha ca toá ca tsaho cabá cahëyamani quiha nicaxo na. ");
INSERT INTO caoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jahuëcara ca oriquiti copiti, noitiria cabo qui parata ati ma ni, tihi cabo ati ja raahacani ca ja quëscahuajahuacani quiha. Toca tsi ja shinacani quiha, jato parata obëso ca Judas ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jatsi quiha Jesú ja qui ani ca mapari Judás biniquë. Bichi tsi quiha cacha ja caniquë. Baquicha ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas jisbayaquë tsi, —Tsëquëquë Nohiria Baquë rësoti xabaca ra —i Jesu niquë—. Jaboqui noho oquë jismahacaxëti xo. E rësohai cató tsi jismahacaxëti xo Dios oquë ri. ");
INSERT INTO caoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Jabi ëa iqui tsi Dios oquë jismahacano tsi ë qui jahuë naipá ca oquë axëhi quiha Dios. E qui apaimaria xo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Tanaroha pistia no tsi mato bëtaxëquia rë, noho xocobá. Jasca, ë caquë tsi quiha ëa mëraxëqui mato. Jama, ë cahai ca qui canoma xo mato iquia ra, naa jodiobo ë yoahitaha jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Jaboqui yoba paxa ca mato qui aquia: Noinacana iquia, mato ë noihai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ma noinapino tsi noho rabëti bo ma nori ca cahëcaxëcani quiha jatiroha cabo —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jatsi, —¿Jahuënia tsi cahai, Ibobá? —i Simón Pedro niquë ja qui. Jatsi, —Jaboqui ë cahai ca qui canoma xo mia. Jama, bari huëtsa ëa banahuaxëqui mia ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Jatsi Pedró quëbiniquë: —Jaboqui tsi mi bëta cacasquia, Ibobá. Mi bax ëmë axëquia nati —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jatsi Jesú quëbiniquë: —¿E bax rësoxëhi ni mia pa? Patiari bënë quëonox pari no tsi tres tsi ëa pasomaha chanixëqui mia rë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Shina-motsiquiyamacana. Dios qui chitimicana. Jasca, ë qui ri chitimicana —i jahuë rabëti bo qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","3","Noho Jahëpa racahai cató tsi xo huëstima ca xobo bo ra. Jabi mato xobo bo rohahuahi caquia. Rohahuahax jotëquëxëquia mato bixëna, ë noho ma no. Tocayamarohapino tsi bëro tsi mato ë yoaquë aquë. Quiayamaquia. ");
INSERT INTO caoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Jabi ë cahai ca quinia cahëqui mato —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jatsi Tomás chaniniquë: —¿Jahuënia tsi cahai, Ibobá? Cahëyamaqui noa rë. ¿Jënahuariaxo raca mi cahai ca quinia no cahëna? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jatsi Jesú quëbiniquë: —Dios qui quinia xo ëa ra. Jabija ca xo ëa ra. Bësomati Ibo xo ëa ra. Yama tsi xo Jahëpa Dios qui jamëpistia cahai cato. Jasca, ëa roha tsi xo toa ja qui mëpihai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Jasca, ëa cahëpiquí tsi noho Jahëpa ri cahëxëqui mato. Jaboqui Jahëpa yoi cahëyoiqui mato. Jahëpa ma jisquë ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Jatsi Felipe chaniniquë: —Mi Ipa noqui jismahuë, Ibobá. Jispihi tsi ranixëqui noa ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jatsi Jesú quëbiniquë: —Mato bëta ë naamaquë, Felipé. ¿Jënahuariaxo jari ëa cahëyamahai rë? Jahëpa Dios yoi jisqui ëa jisish cabo ra. Jënihax, “Jahëpa noqui jismahuë” ¿i mi a pa? ");
INSERT INTO caoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Jahëpa Dios ó ë iquiina, ë nohó Jahëpa Dios iquiina, tihi cabo chahahuayamahai, Felipé? E quima joyamahi quiha noho chani, naa mato ë yoahaina. Jahëpa quima quiha. Jabi naa yonoco ati ibo tsi xo Jahëpa ra, naa ë nohó bësohai cato. ");
INSERT INTO caoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Jasca, Jahëpa ó ë iquiina, ë nohó Jahëpa iquiina, tihi cabo chahahuana. Noho chani chahahuacasyamaquí tsi ë acai ca jisti bo quëshpi tsi ëa chahahuana. ");
INSERT INTO caoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mato parayamaquia. Ea chahahuapiquí tsi ë acai ca jisti bo axëqui mia ri ra. Naa ë acai ca jisti bo oquë ca axëqui mia, Jahëpa qui ë cahai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Caxo tsi noho janë́ tsi jahuëcara ca ma bënahai ca mato bax axëquia. Toca tsi axëquia ra, ë acai cató tsi Jahëpa oquë jisiquino iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Jahuëcara pi noho janë́ tsi ma bënano tsi mato bax axëquia —nëa tsi Felipe qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—Ea pi noiquí tsi noho yoba nicaxëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","Jasca, noho Jahëpa nicaxëquia, Mëbiti Ibo huëtsa ca mato qui ati. Espíritu Santo quiha, naa mato bëta chitë-chitëpaoxëhai ca tsi xo naa ra. Jabija ca qui mato mëpixëhi quiha. Jabi Espíritu Santo biyamahi quiha Dios cahëyamacanaibo. Jato qui bëroma quiha. Cahëyamacani quiha rë. Jama, mato ti tsi xo toa Espíritu Santo cahëcanaina, mato ó ja nori iqui na. ");
INSERT INTO caoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","‘Yoma bo iyamaxëqui mato. Toca tsi mato jisbëriayamaxëquia. Jahari mato qui joxëquia. ");
INSERT INTO caoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Tanaroha pistia no tsi ëa jisyamaxëhi quiha nohiria bo. Jama, ë caquë tsi jari ëa jistëquëxëqui mato. Bëso ë nori quëshpi tsi bësoyoixëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Jasca, toa barí tsi quiha Jahëpa ó ë iquiina, ë nohó ma iquiina, mato ó ë iquiina, tihi cabo cahëxëqui mato ra, ë bësotëquëquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","‘Tsohuëcara ca noho yoba bo nicahai ca tsi xo toa ëa noihaina ra. Jasca, ëa noihai ca noixëhi quiha noho Jahëpa. Toa noixëquia ëa ri. Noixo tsi ja qui ëmë jismaxëquia —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jatsi quiha Judas huëtsa chaniniquë, naa Judas Iscariote ma cato: —¿Noqui roha mimë yoi jismaxëhi ni mia pa, Ibobá? ¿Jënixo tsi chahahuayamacanaibo qui mimë jismayamaxëhai, mia ja cahëyoicano? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jatsi Jesú quëbiniquë: —Noho chani nicaxëhi quiha ëa noihai cato. Toa noixëhi quiha noho Jahëpa ra. Ja qui joxëqui noa, naa ëa, noho Jahëpa. Johax jahá bësoxëqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jama, noho chani nicayamaxëhi quiha ëa noiyamahai cato rë. Jasca, noho chani ma xo naa ma nicahaina, noho Jahëpa chani nori. Ea raanish cato chani tsi xo naa ma nicahana iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","‘Jabi nëca tsi chaniquia mato bëtahi na. ");
INSERT INTO caoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jama, Espíritu Santo mato qui noho Jahëpá raano tsi mato tiisimaxëhi quiha. Mato Mëbiti Ibo ixëhi quiha. Joxo tsi ëa yoati tsi mato tiisimaxëhi quiha. Mato ë yoaha ca tëquë mato shinamaxëhi quiha ë jisbayaquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","‘Mato bëpasimaquia. Jia tsi xo toa mato ë bëpasimahaina; Dios cahëyamacanaibá bëpasimahai ca jamëri nori quiha. Shina-huëjënayamacana. Jasca, raquëyamacana. ");
INSERT INTO caoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","¿Jabi mato ë yoaha ca ma nicayamayamaha? “Mato jisbëriayamaxëquia” i ë quë ra. Jasca, “Mato qui jahari joxëquia” i mato qui ë quë ra. Jatsi ëa pi noihi tsi rani-ranixëqui mato ra, jahari noho Jahëpa qui ë cahai tahëhax na. Ea oquëria xo noho Jahëpa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Jaboqui tihi ca tsi mato yoaquia, ja ocanox pari no. Jatsi ocapijaquë tsi ë qui chitimiyoixëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Jabi ichariama bari tsi xo toa mato bëta ë chanihaina rë. Capaima xo ëa ra. Jasca, johi quiha Satanás rë, naa chahahuayamacanaibo yonati ibo-iboria. E axëhai ca yonoco quëtiayamaxëhi quiha ra. Ea yonati mëtsama xo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Jama, Jahëpa Dios ë noihai ca nohiria bá cahëno. Noiquí tsi jatiroha ca noho Jahëpá yoahai ca aquia ra. Iquë tia. Bëcahuë. ¿Canomani? —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","—Bimi saihuahai ca nishi jascaria ca ëa xo naa —i Jesu niquë—. Bimi nishi ototi ibo tsi xo noho Jahëpa ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","E nohó ca mëshí pi bimi saihuayamano tsi toa mëshi mëris-hi quiha noho Jahëpa. Jasca, saihuahai ca mëshi bo rohahuahi quiha, oquë tsi ja saihuacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jabi mato ë yoani ca chaní tsi ma bahuëhacaniquë, naa mëshi rohahuahacahai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","E nohó bësocana, naa mato ó ë bësohai jascaria. Jabi nishi quima mëris-hacapiquí tsi ¿jënahuariaxo raca toa mëshí saihuana? Jascaria, ë nohó bësoyamapiquí tsi saihuati mëtsama ixëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","‘Nishi xo ëa ra. Mato tsi xo mëshi bo. Jabi huëstima ca bimi saihuahi quiha ë nohó bësohai cato. Dios yonoco ariaxëhi quiha, jaha ë bësohai iqui na. Yama ca axëqui mato ë bëtaxoma. ");
INSERT INTO caoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Jabi niahacaxëti xo tsohuëcara ë nohó bësoyamahai cato, naa niahacanish ca mëshi yoi ca jascaria. Bëso-bësopaoyamaxëhi quiha toa rë. Jabi nëca ca mëshi yoi bo catiahi quiha bimi ibo. Catiaxo tsi chihi qui niahi quiha. Toá tsi mëshocaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jama, ë nohó pi ma bësono tsi, mato ó pi noho chani chitëno tsi jaha ma quëëhai ca baati mëtsa ixëqui mato. Baaxo tsi bixëqui mato ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Jabi huëstima ca bimi saihuahi quiha noho rabëti yoi bo ra. Toca tsi Dios jabi jia ca jismacani quiha ra. Jasca, toca tsi noho rabëti bo ma nori ca cahëxëhi quiha nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mato noiquia ra, naa ëa noho Jahëpá noihai jascaria. E noihai cato ó tsi chitëcana. ");
INSERT INTO caoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Noho yoba pi aqui tsi ë nohai cato ó tsi chitëxëqui mato. Jabi noho Jahëpa yoba bo aquia. Jaha tsi ja noihai cato ó tsi chitëxëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","‘Nëcaquia ë ranihai ca ma oquëxnano. Ma rani-raniriano ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Noho yoba tsi xo naa: Noinabëquicana, mato ë noihai jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tsohuëcara pi jahuë rabëti bax rësono tsi anomaria tsi xo toa ja noihaina. Yama tsi xo toa oquë ca noihaina. ");
INSERT INTO caoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Jasca, noho rabëti bo xo mato, noho yoba ahi na. ");
INSERT INTO caoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jaboqui yonati bo mato quënayamaquia. Jahuë chamá shinahai ca cahëyoiyamacani quiha toa bo rë. Jama, noho rabëti bo mato quënaquia ra. Ja tsi xo toa noho Jahëpa quima ë nicaha ca tëquë mato yoaquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ea ma biyamaniquë. Jama, mato ë biniquë. Bixo tsi mato raaquia, huëstima ca huinocayamahai ca bimi saihuahi ma bocano. Jasca, noho janë́ tsi ma baaha ca jahuëcara ca mato qui axëhi quiha noho Jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Jabi noho yoba tsi xo naa: Noinabëquicana. Iquë. ");
INSERT INTO caoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","‘Ratëyamacana. Mato qui pi Dios cahëyamacanaibo caxano tsi ë qui pari ja caxacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Jabi jato maí ca jabi yoi ca pi ma noino tsi mato noicaxëcani quiha Dios cahëyamacanaibo, jató-na ja noicanai jascaria. Jama, maí ca nohiria bo quima mato ë tsëcaniquë ra. Jató-na ma xo mato. Ja tsi xo toa mato qui caxahi quiha maí ca nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Jabi ë yoaha ca shina-bënoyamacana: “Jahuë ibo oquë ma xo yonati” i ë quë ra. Jabi ëa tënëmacaxëcani quiha maí ca nohiria bo. Jasca, mato ri tënëmacaxëcani quiha, noho rabëti bo ma nori iqui na. Jasca, noho chani nicarohapixo tsi mato chani ri ja nicaquë acaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Jasca, ëa raanish ca cahëyamahi quiha maí ca nohiria bo rë. Jaha tsi ëa iqui tsi mato tënëmacaxëcani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Jato qui pi chanihi ë joyamarohano tsi ja quësoyamahacaquë acaquë. Jama, jaboqui jocha jayaca xo rë. “Noho shina ri ma xo” iti mëtsama ca xo ra, noho chani ja nicacana quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Noho Jahëpa qui caxahi quiha tsohuëcara ca ë qui caxahai cato rë. ");
INSERT INTO caoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Jasca, jato xërëquë xo pi jistiria bo ë ayamarohano tsi ja quësoyamahacaquë acaquë. Jama, ë ani ca jistiria bo ja jiscani quiha. Jisi tsi ëa, noho Jahëpa, tihi cabo qui jari caxacani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Jabi jatihuahacati xo Quënëhacanish cabo ra, ja acanai cató no, naa, “Mahitsa ë qui caxacaxëcani quiha rë” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","‘Joxëhi quiha Espíritu Santo, naa mato Mëbiti Ibo ra. Noho Jahëpa ax joxëhi quiha. Jabija ca yoahai ca tsi xo naa. Jabi mato qui Espíritu Santo raaxëquia. Joxo tsi jatiroha ca ëa yoati mato yoaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Jascaria, ëa yoati chanixëqui mato ri, rëquë rohari tsi ë bëta ma ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","‘Jabi mato qui caxacaxëcani quiha maí ca nohiria bo. Toa mato yoaquia, jabija ca quima ma casoyamano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Jato catiti xobo quima mato niacaxëcani quiha rë. Toa xaba tsëquëno tsi mato acaxëcani quiha ra. Axo tsi Dios yonoco ja acanai ca quëscahuacaxëcani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Jasca, ëa, Jahëpa, tihi cabo cahëyamacani quiha rë. Ja tsi xo toa mato acaxëcani quiha pë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Jaboqui mato yobaquia, noho chani ma shinaparino toa xaba tsëquëquë no. ‘Jariapari tsi ë caxëhai ca ë yoayamaniquë, jari mato bëta ë ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jama, jaboqui ëa raanish ca qui capaima xo ëa. Jama, “¿Jahuënia tsi cahai?” iyamaqui mato rë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Jabija ca mato ë yoaha iqui tsi cohuëria xo mato. ");
INSERT INTO caoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jasca, mato qui jia tsi xo ë caxëhaina iquia. E cayamapino tsi mato qui joyamaxëhi quiha Espíritu Santo, naa mato Mëbiti Ibo. Jama, mato qui Espíritu Santo raaxëquia nai qui caquí na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Jato jocha nohiria bo qui bërohuaxëhi quiha joxo na. Jasca, noho mëstë ca jabi, Diós nohiria bo copixëhaina, tihi cabo tsi bërohuaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jasca, jato jocha bërohuaxëhi quiha Espíritu Santo, ë qui ja chitimiyamacanai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Jasca, noho mëstë ca jabi bërohuaxëhi quiha, Jahëpa Dios qui ë caxëhai iqui na. Jabi mëstë ca ë nori iqui tsi Jahëpa qui cati mëtsa xo ëa. Jasca, ë caquë tsi ëa jisyamaxëqui mato. ");
INSERT INTO caoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Jasca, Diós nohiria bo copixëhai ca bërohuaxëhi quiha Espíritu Santo, Satanás, naa maí ca nohiria yonati ibo copihacani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","‘Jari huëstima ca tsi xo toa mato qui ë yoacatsaina. Jaboqui cahënoma xo mato rë. Jaha tsi yoayamaquia. ");
INSERT INTO caoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jama, joxëhi quiha Espíritu Santo. Joxo tsi jatiroha ca jahuë bo tiisimaxëhi quiha. Jabija ca yoahai ca tsi xo naa. Quiayamahi quiha. Jahuë chamá tsi chaniyamaxëhi quiha. Jama, chaniquí tsi ja nicahai ca jahuë bo roha mato qui yoaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Jasca, ëa oquëhuaxëhi quiha. Oquëhuaxo tsi ë noho ca chani bixëhi quiha. Bixo tsi mato cahëmaxëhi quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Jabi noho Jahëpa oquë, jahuë chani, tihi cabo tëquë jaya xo ëa ra. Ja tsi xo toa “Ja qui ë acai ca jahuë bo bixëhi quiha Espíritu Santo. Bixo tsi mato cahëmaxëhi quiha ra” i ë quë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","‘Tanaroha pistia no tsi ëa jisyamaxëqui mato. Jaquirëquë, ichariama bari huinocaquë tsi ëa jistëquëxëqui mato —nëa tsi jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jatsi quiha chaninabëquitsi jahuë rabëti bo niquë: —¿Jënijaha sa? “Tanaroha pistia no tsi ëa jisyamaxëqui mato; jaquirëquë, ichariama ca bari tsi ëa jistëquëxëqui mato” i ja quë pa. Jasca, “Noho Jahëpa qui caquia” i ja quë pa. ");
INSERT INTO caoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Jahuëcara chanihi ni naa sa, “Tanaroha pistia no” i ja quë no? Ja chanihai ca cahëyamaqui noa rë —nëa tsi quiha jahuë rabëti bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jabi jahuë rabëti bá nicacascani ca Jesú cahëniquë. Ja quëshpi tsi jato qui ja chanitëquëniquë: —“Tanaroha pistia no tsi ëa jisyamaxëqui mato. Jaquirëquë, ichariama ca bari tsi ëa jistëquëxëqui mato” i ë quë. ¿Jabija ma ni naa ma nicacatsaina? ");
INSERT INTO caoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mato parayamaquia. E caquë tsi araxëqui mato. Jama, ranixëhi quiha maí ca nohiria. Cohuënaxëqui mato. Jama, ranixëqui mato, ëa ma jistëquëquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jabi pahë ya xo yoxa, jahuë baquë coquë no. Jama, jahuë baquë coquë tsi jahuë comahai ca pahë shina-bënohi quiha. Ranihi quiha, jahuë baquë coha quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jascaria tsi jaboqui cohuë xo mato ri. Jama, ranixëqui mato, mato ë jistëquëquë no. Mato quima mëbitimaxëni ixëhi quiha ma ranixëhaina ra. ");
INSERT INTO caoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","‘Toatiyá tsi ëa nicayamaxëqui mato, jahuëcara bixëna. Jama, Jahëpa Dios nicaxëqui mato ra. Jahuëcara ma nicahai ca mato qui axëhi quiha, noho rabëti bo ma nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jaboqui jari noho janë́ tsi nicayamahi quiha mato, bëhoxquí na. Jama, toatiyá tsi noho janë́ tsi nicatsacana. Nicaxo tsi bixëqui mato. Toca tsi raniriaxëqui mato ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","—Jaboqui mato joma quiha mato ë yoahaina rë. Jama, joxëhi quiha xaba huëtsa. Toatiyá tsi bëroria tsi Jahëpa Dios yoati tsi chanixëquia —i jahuë rabëti bo qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Toatiyá tsi noho janë́ tsi Jahëpa Dios nicaxëqui mato. Noho janë́ tsi ma bëhoxno tsi mato bax nicayamaxëquia, noho Jahëpá mato nicaxëhai quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Mato noiriahi quiha Jahëpa Dios yoi, ëa ma noihai iqui na. Jasca, Dios quima ax ë joni ca chahahuaqui mato. Ja quëshpi tsi mato noiriahi quiha Jahëpa. ");
INSERT INTO caoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Jahëpa Dios ë jisbërianiquë mai qui joxëna. Jaboqui naa mai jisbëriaquia jahari noho Jahëpa Dios qui caxëna —nëa tsi Jesu nëcaniquë jahuë rabëti bo qui. ");
INSERT INTO caoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Jatsi jahuë rabëti bá quëbiniquë: —Jaboqui bëro xo mi chanihaina. Jonë ma xo ra. ");
INSERT INTO caoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jaboqui jatiroha ca cahëhai ca mi nori ca cahëqui noa. Mia pi no nicacasno tsi no shinahai ca cahëqui mia pa. Ja tsi xo toa Dios quima ax mi joni ca cahëqui noa ra —i Jesu qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jatsi quiha Jesú quëbiniquë: —¿Jaboqui chahahuacanai pa? ");
INSERT INTO caoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Jabi basima tsi xo toa hora ra, naa ma pacanamahaca-xëquë no. Jabi joquë toa hora. Toatiyá tsi mato xobo qui jabaxëqui mato pë. Ea jisbëriaxëqui mato rë. Jama, ëmëpistia iyamaxëquia ë bëta Jahëpa nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nëca tsi mato qui chaniquia ma bëpasino, ma raquëyamano iquish na. Nicacana. Mato yosicaxëcani quiha maí ca nohiria. Jama, ranitsicana maí ca yoi ca jahuë bo, maí ca nohiria bo, tihi cabo ë boboni quëshpi na —nëa tsi quiha jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jatsi quiha nai Jesú tsayaniquë bëhoxhi na. Tsayahax, —Tsëquëquë ë rësoti xabaca rë, Jahëpá —i Jahëpa Dios qui ja niquë—. Mi Baquë xo ëa ra. Noho oquë jismahuë, mi oquë ë jismano ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Jasca, ë qui nohiria yonati chama mi aniquë, ë qui mi ani ca nohiria bo tëquë ë bëso-bësopaomano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Jabi bëso-bësopaoti quinia tsi xo naa ra: Mia, ëa, tihi cabo ja cahëyoiti ca xo ra. Mia tsi xo toa jaroha ca Dios yoi. Jasca, ëa ti tsi xo toa mi raani ca baquë yoi. ");
INSERT INTO caoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Jabi naa mai xo tsi mi oquë ë jismaquë ra. Jasca, ë qui mi ani ca yonoco ë jatihuaquë ra. Jaboqui yama tsi xo. ");
INSERT INTO caoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Jatsi jaboqui noho oquë mi jismati xo, Jahëpá, naa mi bëta ë jayapaoni ca oquë. Jabi mai mi nëhohuanox pari no tsi anomaria ini quiha noho oquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","‘Jasca, ë qui mi ani ca maí ca nohiria bo qui tsohuë mi nori ca ë jismaquë ra. Jabi jato qui mi oquë ë jismaquë. Jariapari tsi mi-na bo ja icapaoniquë. Jatsi ë qui jato mi aniquë jato ó bësoti. Jaboqui mi chani nicacani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Jasca, jaboqui ëa yoi cahëriacani quiha. Noho chani, noho tiisi, noho chama, tihi cabo ë qui mi ani ca cahëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","E qui mi ani ca chani jato qui ë aniquë. Mi chani ja bicaniquë ra. Bixo tsi mi quima ax ë joni ca cahëriacani quiha ra. Ea mi raani ca chahahuayoicani quiha iquia. ");
INSERT INTO caoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","‘Jasca, noho rabëti bo bax bëhoxquia. Chahahuayamacanaibo bax bëhoxyamaquia. Jama, ë qui mi ani cabo bax bëhoxquia mi-na bo jaca nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Jabi jatiroha ca nohó-na bo xo mi-na bo ri. Jasca, jatiroha ca mi-na bo xo nohó-na bo ri. Jaboqui ja acanai cató tsi jismahacahi quiha noho oquë. ");
INSERT INTO caoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ea ti tsi xo jisbayahaina. Jama, nëá tsi chitëcahi quiha nohó-na bo. Jisbaya tsi mi qui caquia. Ja quëshpi tsi jia tsi ë qui mi ani cabo ó bësohuë, noho Jahëpa jiaxëni cató. Tocahuë, huësti ca ja icano, huësti ca no nori jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Jato bëtapama tsi jato ë oto-otoniquë, ë qui mi ani ca chamá no. Jënima ca xo. Huësti roha tsi xo toa bënohacahax cato, naa tënëtiyá ca baquë rë. Tocapijaquë, Quënëhacanish cabo jatihuahacano iquish na. Iquë. ");
INSERT INTO caoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Jaboqui mi qui caquia. Jato bëtapama tsi naa jahuë bo jato ë yoaniquë, ë ranihai ca ja xatënacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jasca, mi chani jato qui ë aquë. Ja iqui tsi jato qui caxahi quiha maí ca nohiria bo, jato maí ca jabi yoi bo ja niacani iqui na. Maí ca nohiria bo quirima ca xo, ëa jascaria jaca nori. ");
INSERT INTO caoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mai quima jato tsëcahuë iyamatsiquia. Jama, jato ó bësohuë, Satanás jato yoshihuayamano. ");
INSERT INTO caoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Jaboqui maí ca nohiria ma ca xo. Jató-na ma ca xo, ëa jascaria jaca nori. ");
INSERT INTO caoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Jasca, jabija ca Espíritu Santó tsi jato aquëquëmahuë, mi yonoco ati. Jabija tsi xo mi chani ra. ");
INSERT INTO caoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jabi maí ca nohiria bo qui ëa mi raani jascaria tsi maí ca nohiria bo qui jato ë raaquë ëa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Jato bax ëmë mi qui aquia namëhacati, Espíritu Santó tsi ja aquëquëmahacacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","‘Jabi noho rabëti bo, jato chani iqui tsi ë qui chitimicaxëcanaibo, tihi cabo bax bëhoxquia ra. ");
INSERT INTO caoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bëhoxquia ja huëstinabëquicano. No nohó ja huëstinabëquicano, Jahëpá, naa ë nohó mi nori jascaria. Ja huëstinabëquicano ra, maí ca nohiria bá ëa mi raani ca chahahuano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Jabi ë qui mi ani ca oquë jato qui ë aniquë, ja huëstinabëquicano iquish na, naa huësti ca no nori jascaria. ");
INSERT INTO caoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Jabi jato ó xo ëa. Jasca, ë nohó xo mia ri. Ja iqui tsi ja huëstina-bëquinayoicano ra. Tocapijacano tsi ëa mi raanina, jato ë noi-noihaina, tihi cabo cahëcaxëcani quiha maí ca nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","‘Jabi ëa mi noiniquë mai nëhohuahacanox pari no. Toatiyá tsi oquë ë qui mi aniquë. Toa oquë ja jiscano ra. Ja tsi xo toa ë nori cató tsi noho rabëti bo icano jato ri, noho oquë ja jiscano. ");
INSERT INTO caoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Jishopë, mëstëxëni ca Jahëpá. Mia cahëyamahi quiha maí ca nohiria bo rë. Jama, mia cahëhai ca ëa xo naa. Jasca, ëa mi raani ca cahëhi quiha noho rabëti bo ri. ");
INSERT INTO caoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mi jabi yoi jato ë cahëmaniquë. Jasca, jari mi jabi yoi jato cahëmaxëquia, noiti ja tiisicano, ëa mi noihai jascaria. Jabi jato shina ó tsi bësoxëquia —nëa tsi Jesu nëcaniquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Bëhoxhax tsi quiha pao Cedrón Jesú shitaniquë. Jahuë rabëti bo ri ja boni quiha. Shitahax huerto qui ja jicocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Jabi toa iti Judás cahëni quiha jaa ri, naa Jesu pasomaha inish cato. Huëstima tsi toa huerto qui Jesu ca-capaoni quiha jahuë rabëti bo ya. ");
INSERT INTO caoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Jaha tsi quiha huerto qui Judás caniquë jaa ri, Jesu mërahi na. Huëstima ca soldado bo, jodioba chama bá raani ca policía bo, tihi cabo ja boniquë. Jotati bo, lamparina bo, saipi bo, tihi cabo ja jayacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Huerto qui ja cahëcaquë tsi quiha jato bëchahi Jesu caniquë, ja acascanai ca ja cahëni quëshpi na. Bëchahax, —¿Tsohuë mëracanai? —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Jatsi, —Nazarét ca Jesu mëraqui noa ra —i jaca niquë. Jatsi quiha, —Ja xo ëa ra —i Jesu niquë. Jabi toá tsi quiha soldado bo ya Judas nii iniquë, naa Jesu pasomaha inish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Ja xo ëa ra” i Jesu quë tsi quiha ja chishtëquiri-caniquë. Mai qui ja paquëcaniquë ratëhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jatsi quiha Jesú jato nicatëquëniquë: —¿Tsohuë mëracanai ra? —iquiina. Jatsi quiha, —Nazarét ca Jesu ra —itëquë jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jatsi Jesú quëbiniquë: —“Ja xo ëa ra” i ë quë. Ea pi ma mërano tsi noho rabëti bo ma paquëmano iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Jabi toca tsi ja yoaha ca Jesú jatihuani quiha naa “E qui mi ani cabo bënoyamaxëquia” i ja quë no. ");
INSERT INTO caoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jatsi quiha Simón Pedró jahuë saipi tsëcaniquë. Tsëcaxo tsi quiha Malco, naa arati ibo-iboria yonati ja paxtianiquë. Jahuë mënëcayá ca pahoqui quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Paxtia-jahuaquë tsi quiha, —Mi huaina qui jahari mi saipi nanëhuë. ¿E qui noho Jahëpá ani ca yonoco ayamayamaxëhi ni ëa ra? Aquia ra —i Pedro qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jatsi pë soldado bo, jato capitán, jodiobá policía bo, tihi cabo Jesu qui tsaminiquë. Tsamixo tsi quiha ja nëxacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Nëxaxo tsi Anás xobo qui pari Jesu ja bocaniquë. Caifás raisi ja ini quiha. Jabi toa año no tsi arati ibo ba chama Caifás ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Jabi jodiobo yobanish ca Anás tsi xo naa, “Oquë tsi xo nohiria bo bax huësti ca joni rësohaina” inish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jabi Jesu cho Pedro caniquë. Ja cho ë caniquë ëa ri, naa Jesu rabëti huëtsa. Jabi ëa Anás cahëni quiha, naa arati ibo-iboria iqui cato. Ja quëshpi tsi Jesu ya arati ibo-iboria xobo huënënë́ ca mai qui jicoti mëtsa ë iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jiconoma Pedro ini quiha. Caiti cacha nii quiha. Jatsi cacha ë caniquë, caiti obëso ca xotaco qui chanixëna, huënë qui Pedro jicomacatsi na. Jatsi Pedro ë jicomaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jatsi ë bëta jicojano tsi —Tonia Jesu rabëti xo mia ra —i caití quëmëpi ca xotaco niquë Pedro qui. Jatsi quiha, —Jahuë rabëti ma xo ëa ra —i Pedro niquë rë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jabi matsi iqui tsi toá ca policía bo, yonati bo, tihi cabá chihi maponiquë. Mapohax toá tsi quiha ja yohocaniquë. Jato bëta niiniquë Pedro ri, yohohi na. ");
INSERT INTO caoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Jatsi quiha jahuë rabëti bo, ja tiisimahaina, tihi cabo yoati tsi arati ibo ba chamá Jesu nicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jatsi Jesú quëbiniquë: —Bëroria tsi nohiria bo qui ë chaniniquë ra. Mato catiti xobo bo, arati xobo, tihi cabo xo tsi ë tiisimapaoniquë, naa jodiobo tëquë catihai cato xo na. Jonë tsi ë chaniyamaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ja quëshpi tsi, ¿jëniriaxo tsi ëa nicahai? Noho chani nicanish cabo nicahuë ra. E yoani ca cahëcani quiha ra —i jato chama qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jatsi pë toá ca nii ca soldadó Jesu bëpaishaniquë pë. —¿Toca tsi arati ibo ba chama quëbihi ni mia pa? —i ja qui soldado niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jatsi quiha Jesú quëbiniquë: —Anoma ca pi ë chanirohano tsi ëa nicamahuë. ¿Jëniriaxo tsi ëa mi bëpaishaha pa, jabija ca ë chaniquë no? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jatsi arati ibo-iboria Caifás qui Anás Jesu raaniquë. Jari nëxë Jesu ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jabi chihi tahë tsi quiha jari nii quiha Pedro iniquë, yohohi na. Yohojano tsi quiha ja qui chanitsi toá ca joni bo niquë: —¿Jesu rabëti ma ni mia ra? —i ja qui jaca niquë. Jatsi quiha, —Jahuë rabëti ma xo ëa ra —i Pedro niquë rë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Jatsi quiha Pedro qui ibo-iboria yonati chaniniquë, naa paxtiahacanish cato jimibo: —¿Huerto xo tsi Jesu ya mia ë jisyama-yamaha? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jatsi quiha, —Ea ma xo ra —i Pedro niquë rë. Ja quiaquë tsi quiha patiari bënë quëotapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jaquirëquë Caifás xobo jisbaya tsi quiha romanoba chama xoboria qui Jesu ja bocaniquë. Baquishmari ja ini quiha. Jahuë xoboria qui cahëhax tsi quiha ja jicoyama-caniquë. Carayanaba xobo qui jicohai jodiobo qui yoi ini quiha, jato jabi pasomaha ja ini quëshpi na. Jato qui roa quiha. Jicorohapihi tsi jato pascua fiesta oriquiti mëtsama ja iquë acani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jatsi quiha cacha Pilato caniquë jato qui. —¿Jahuë naa joni qui quësocanai? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Jatsi quiha, —Anoma ca pi ja ayamarohano tsi mi qui no bëyamaquë aquë ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jatsi quiha Pilató jato quëbiniquë: —Bicahuë. Mato yobá tsi copihuë —iquiina. Jatsi quiha, —Naa joni namëcasqui noa ra. Romanoba yoba pasomaha tsi xo toa joni no namëhaina rë —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nëca tsi Jesú yoani ca jatihuahacani quiha, naa ja rësohai ca quinia yoati ja yoaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jatsi jahuë xoboria qui jahari Pilato cahaca tsi Jesu ja bënaniquë. Bënahax, —¿Jodioba chama-chamaria ni mia? —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jatsi quiha Jesú quëbiniquë: —¿Mi quima johi ni mi nicahana? ¿Tonia ëa yoati huëtsa bá mia yoayamayamaha? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jatsi, —¿Jodio ë nori ca shinahai? Mi jimibo, jato arati ibo bo, tihi cabo tsi xo toa ë qui mia mëahax cabo ra. Jatsi, ¿jahuë anoma ca mi aca sa? —nëa tsi Jesu qui Pilato nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jatsi quiha Jesú quëbiniquë: —Maí ca nohiria chama ma xo ëa ra. Nëa xo tsi yonayamaquia. Jasca, nëa xo tsi ë yonarohapino tsi noho yonati bo nianaquë aquë, jodioba chama bo qui ë mëahacayamano. Mai xoma xo ë yonahaina ra —nëa tsi Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jatsi quiha, —¿Chama ni mia pa? —i Pilato niquë. —Jabija. Chama xo ëa ra. Ja tsi xo toa ë conina. Mai qui ë joniquë jabija ca yoaxëna. Jabi noho rabëti bo tsi xo toa jabija ca nicacanaibo tëquë —i Pilato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Jatsi quiha, —¿Jahuë ni toa jabija ca sa? —i Pilato niquë. Chanihax cacha jodiobo qui Pilato catëquëniquë. Cahax, —Yama tsi xo naa joní anoma ca acana iquia —i jato qui ja niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mato pascua fiesta no tsi presó ca achiquinish ca huësti ca ë paquëmapaoniquë. Noba jabi quiha. ¿Japa jaboqui mato jodiobo chama-chamaria mato bax paquëmaxëhi ni ëa? —i jodiobo qui Pilato niquë, Jesu paquëmacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jatsi quiha jato joi jodiobá choshaniquë. Jato qui yoi ini quiha ja yoanina. Jaha tsi, —Naa joni paquëmayamahuë ra. Barrabás paquëmahuë ra —i jaca niquë pë. Jabi yomaxëni ca joni naa Barrabás ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jatsi Pilató Jesu biniquë. Bixo tsi quiha ja rashamaniquë rispichí no. ");
INSERT INTO caoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jaquirëquë moxa chaha soldado bá quëconiquë. Quëcoxo tsi quiha ja machëquërëxacaniquë pë. Jatsi quiha raiti shini ja sahuëmacaniquë; naa chama-chamaria sahuëti. ");
INSERT INTO caoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Sahuëmahax ja qui soldado bo bocaniquë joihuaxëna. —¡Viva! ¡Viva, jodioba chama-chamariá! —i jaca niquë pë. Joihuaxo tsi quiha ja bëpaishacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jaquirëquë cacha Pilato catëquëniquë jodiobo qui. —Cacha mato qui Jesu boquia. Yama tsi xo toa anoma ca ja acana iquia. Ja bësoxëti xo ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jatsi xobo cacha Jesu caniquë. Moxa chaha, raiti shini, tihi cabo sahuë ja ini quiha. Jatsi, —Nëá xo mato joni ra —i jato qui Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Jatsi quiha arati ibo bo, jato yonati bo, tihi cabá Jesu jisniquë. Jisi tsi, —Cruzó tsi tooxahuë. Cruzó tsi tooxahuë —i jaca niquë pë. Jatsi quiha, —Bocahuë. Acasyamaxo ëa ra. Mamëxo tsi cruzó tsi tooxacahuë pë. Yama tsi xo anoma ca ja acana iquia ra —i jato qui Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jatsi jodiobá quëbiniquë: —“Ja namëhacati xo” ii quiha noba yoba ra, “Dios Baquë xo ëa” i ja ni quëshpi na —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Nicahax raquëriatsi Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Raquëhi tsi jahuë xoboria qui ja jicotëquëniquë Jesu qui chanitëquëhi na. —¿Jahuënia ax mi joni? —i ja qui Pilato niquë. Quëbiyamaniquë Jesu; pasi quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—¿Ea quëbiyamahai pa? ¿Noho chama cahëyamahai? Mia paquëmati chama, mia cruzó tsi tooxamati chama, tihi cabo jaya xo ëa ra —i Jesu qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jatsi Jesú quëbiniquë: —Mana quima mi qui chama ayamahacarohapino tsi ëa namëti chama mi jayamaquë aquë ra. Jaha tsi mi jocha oquë tsi xo toa mi qui ëa mëahax cato jocha ra —nëa tsi quiha Pilato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jatsi quiha Pilató Jesu paquëmacasniquë nicaxo na. Jama, jahari jodiobá quënaniquë: —Paquëmapihi tsi romanoba chama-chamaria rabëti ma xo mia pë. Romanoba chama pasomaha tsi xo toa “Chama-chamaria xo ëa” iquii cato. Tocahi quiha naa Jesu ra —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Jesu qui ja quësocanai ca nicaxo tsi quiha Pilató Jesu boniquë, cacha xo copixëna pë. Bohax tsi quiha jahuë copiti tsahotí ja tsahoniquë ja qui quësoxëna. Tsahohax, ");
INSERT INTO caoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","—Nëá xo mato chama-chamaria Jesu ra —i jodiobo qui ja niquë. Jabi pascua fiesta chiho ca bari ja ini quiha. Matoroco bari quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jatsi quënatsi quiha nohiria bá huaniquë: —Ahuë ra. Ahuë ra. Cruzó tsi tooxahuë ra —i jaca niquë. Jatsi quiha, —¿Mato chama-chamaria tooxaxëhi ni ëa pa? —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Chanixo tsi jato qui Pilató Jesu mëaniquë cruzó tsi tooxahacati. ");
INSERT INTO caoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jatsi jodiobá Jesu biniquë. Yaca cacha ja mëpihacani quiha jahuë cruz iahaina. Mapo Xao Ya icanai ca maca qui tsi quiha ja bocaniquë, naa jodioba joí tsi “Gólgata” quënahacanish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Toa xo tsi Jesu soldado bá tooxaniquë cruzó no. Jasca, ja bëta dos ca joni huëtsa bo ja tooxacaniquë, huësti ca jahuë mënëcayá no, huëtsa jahuë mëxojó no. Nëpax tsi quiha Jesu cruz iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Jatsi quiha papi ó tsi Pilató quënëniquë cruzó tsi janahacati chani. “Nazarét ca Jesu. Jodioba chama-chamaria” i ja quënëni ca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jabi Jerusalén basima tsi Jesu tooxahacani quiha. Ja quëshpi tsi huëstima ca jodiobá Pilató quënëni ca jisniquë. Tres ca joi bá tsi jahuë chani quënëhacani quiha, naa jodioba joi, griego joi, romanoba joi. ");
INSERT INTO caoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jabi arati ibo bo qui anoma ini quiha Pilató quënënina. Jatsi quiha Pilato qui ja chanicaniquë: —Mi quënëha ca rarinamahuë. “Jodioba chama-chamaria” quënëyamana rë. Jama, “‘Jodioba chama-chamaria xo ëa’ ii quiha naa joni” quënëhuë —nëa tsi quiha Pilato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jatsi quiha, —E quënëha ca rarinamayamaquia ra —i Pilato niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jatsi cruzó tsi Jesu tooxaxo tsi quiha jahuë raiti soldado bá biniquë. Bixo tsi cuatro ca maa ca ja oquëxhuacaniquë jamë bax na. Jabi cuatro ca soldado bo ja icani quiha, naa jahuë raiti ó quëënish cabo. Jatsi quiha jahuë camisaria jiaxëni ca ja bicaniquë, naa quëshëquë yama cato. ");
INSERT INTO caoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Bichi tsi soldado bo nëcaniquë: —Jahuë camisaria no jaxcayamano ra. Suerte bo no niaparino. Toca tsi jahuë camisaria biti ca cahëxëqui noa ra —i jaca niquë. Toca tsi ja acanai cató tsi Quënëhacanish cabo jatihuahacani quiha. Jabi Quënëhacanish cabá yoani ca tsi xo naa: “Jato xërëquë xo tsi noho sahuëti bo ja oquëxhuacaniquë. Noho camisaria quëshpi tsi suerte bo ja niacaquë” iquiina. Jabi toca tsi soldado bá aniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jabi cruz tapaí quiha Jesu jahëhua María, jahuë jahëhua noma, Cleofas ahuini María, María Magdalena, tihi cabo iniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jasca, jahuë jahëhua tapaí nii ë iniquë, ëa ri. Jatsi noqui, naa ëa, jahuë jahëhua María, tihi cabo Jesú jisniquë. Jisi tsi, —Jaboqui mi baquë tsi xo toa, caí —i jahëhua qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jatsi ë qui ja chaniniquë: —Noho jahëhua mi otono, mi ihua ó mi bësohai jascaria —iquiina. Japi noho xobo qui Jesu jahëhua ë boniquë racati. ");
INSERT INTO caoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jaquirëquë jahuë maí ca yonoco jatihuahacani ca Jesú cahëniquë. Jatsi, —Tëshinaquia —i ja niquë, Quënëhacanish cabá yoani ca jatihuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Jabi toá tsi nii quiha chomo iniquë. Nopi ca jënë jayani quiha. Jatsi toa jënëria qui tatë ja moosacaniquë. Moosaxo tsi quiha tahuá tsi tatë ja rëbiquiriahacaniquë. Jatsi jahuë jana qui ja tërocaniquë nopi ca jënë amaxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jënëria acax tsi, —Jatiquë noho yonoco ra —i Jesu niquë. Jatsi ja tëpiniquë. Tëpihax ja naniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Jabi chitahëpaimaria quiha jodioba joiti bari iniquë. Ja quëshpi tsi Pilato qui jodiobo chaniniquë: —Cruzó tsi tooxahacanish caba huico bo tëcaritsacahuë, ja rësohuënicano. Jato yora bo botëmahacaxëti xo —iquiina. Jabi jodiobo qui anoma ini quiha cruzó tsi yora rotamëhaina, naa jato joiti barí no. Bari-bariria jato jodioba joiti bari ini quiha. Jato qui roa quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Jaha tsi quiha soldado bo bocaniquë jato huico bo tëcaxëna. Jatsi Jesu ya ca tooxahacanish ca joni ba huico pari ja tëcacaniquë, mëri tsi ja rësocano. ");
INSERT INTO caoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Tëcahax Jesu qui ja bocaniquë. Ja qui cahëxo tsi quiha bësoyama ja iqui ca ja jiscaniquë. Ja quëshpi tsi jahuë huico bo ja tëcayamacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Jama, soldado huëstitá Jesu yora quëpë tsacaniquë jahuë saipí no. Jatsi jimi, jënëpaxa, tihi cabo xapaquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Jasca, ja rësohai ca ë jisniquë ëa ri. Jabija tsi xo naa ë quënëhaina. Quiayamaquia. Parayamaquia, ja qui ma chitimicano mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jabi nëca tsi Jesu naniquë Quënëhacanish cabo jatihuahacano iquish na, naa “Jahuë xao bo tëcayamacaxëcani quiha” ini cato ó no. ");
INSERT INTO caoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Jasca, “Ja tsacani ca qui tsayaxëhi quiha nohiria bo” ii quiha Quënëhacanish caba iti huëtsa ó no. ");
INSERT INTO caoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jaquirëquë quiha raquëhax tsi Arimatiá ca racanish ca José caniquë Pilato qui. Caxo tsi quiha Jesu yora ja bënaniquë maihuaxëna. Jatsi quiha, —Bihuë —i ja qui Pilato niquë. Jatsi quiha Jesu yora bichi ja caniquë. Jabi Jesu rabëti ja iqui ca ja yoayamaniquë jodioba chama bo qui raquëhi na. ");
INSERT INTO caoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Jasca, ja bëta Nicodemo caniquë jaa ri, naa baquichá Jesu qui canish cato. Yora maihuati shomahuati perojome, naa mirra, áloes roihacani ca chëxëti ja bëcaniquë. Ihuë ini quiha ja bëcani ca chëxëti. ");
INSERT INTO caoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Jatsi Jesu yora ja bicaniquë. Bixo tsi quiha ja yabocaniquë, chëxëtí tsi cohohuahaina. ");
INSERT INTO caoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jabi cruzó tsi Jesu tooxahacani ca basima huerto ini quiha. Toá tsi maiquini paxa ca ini quiha, naa maihuahama cato. ");
INSERT INTO caoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ja bamayamacaniquë, jato jodioba joiti bari chitahëpaimaria ini quëshpi na. Jaha tsi toa maiquini qui mëri tsi Jesu ja maihuacaniquë, cruz basima ja ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingo baquishmari, jari mitsëmono tsi quiha maiquini qui María Magdalena caniquë. Caxo tsi quini quëbëti maxax chahitaxëni ja yopaniquë. Bahama ja tarahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Yopahax jahari ja jabaniquë Simón Pedro, ëa, tihi cabo yoaxëna. Jabahax, —Maiquini quima noba Iboba yora ja tsëcacahitaquë rë. ¿Jahuënia cara jahuë yora ja janacahitaha sa? Cahëyamaqui noa rë —i ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jatsi quiha Pedro, ëa, tihi cabo jahuë maiquini qui bocaniquë jisxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","No jabanabëquiniquë. Jatsi Pedro ë xononiquë. Jariapari jahuë maiquini qui ë cahëniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Cahëxo tsi ë naisniquë. Jahá ca jahuë yora yabohacanish ca raiti ë jisniquë caiti xo na. Jari quini qui ë jicoyamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jatsi ë cho Pedro joniquë. Johax quini qui ja jiconiquë jisxëna. Yabohacanish ca raiti ja jisniquë jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jatsi Jesu bëmana yabohacaha ca raiti pistia ja jisniquë. Iti huëtsá tsi ja ini quiha pa; yabohaca roha. Raiti tëxë basi jahuë mapo raiti ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jatsi maiquini qui ë jiconiquë ëa ri. Jicoxo tsi niabëriahacanish ca raiti pistia ë jisniquë ëa ri. Jisi tsi Jesu bëso iqui ca ë cahëniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Toatiyá tsi jari Jesu yoati Quënëhacanish cabo no cahëyamariani quiha, naa “Rësonish cabo quima ja tërohacati xo” iquii cato. ");
INSERT INTO caoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tsayahax jahari noba xobo qui no caniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jabi jahari quiha jahuë maiquini qui María Magdalena caniquë. Toá tsi arahi ja iniquë, quini quëmëpi nii iquiina. Arapama tsi quiha ja rëniniquë naisxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Naisxo tsi quiha dos ca ángel bo ja jisniquë. Raiti joxo sahuë ja icani quiha. Jasca, Jesu janahacani cató tsi tsaho ja icani quiha; huësti ca jahuë matoró no, huësti ca jahuë tahë rësó no. ");
INSERT INTO caoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Jatsi quiha, —¿Jënihax tsi arahai, caí? —i ja qui ángel bo niquë. —Noho Iboba yora ja bocahitaquë rë. Ja janacana ca iti cahëyamaquia rë —i María niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Chanipama tsi quiha ja bopinaniquë. Jatsi Jesu ja jisniquë pa. Jama, Jesu ja iqui ca ja cahëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jatsi quiha, —¿Jënihax tsi arahai, caí? ¿Tsohuë mërahai? —i ja qui Jesu niquë. Jabi toa mai obëso ca ja iqui ca María jascahuani quiha. Ja quëshpi tsi ja qui chanitsi María niquë: —¿Jahuë yora mi bichi? ¿Jahuënia tsi mi janaha? Ea yoahuë; ë bichi cano —i ja qui María niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jatsi quiha, —Mariá —i ja qui Jesu niquë. Ja qui bësohax tsi, —Maestro pa —i María niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—Ea achariayamahuë. Jari noho Jahëpa qui ë tëronoyamaquë ra —i ja qui Jesu niquë—. Dios, naa noho Jahëpa qui caquia. Jabi mato Dios, mato Jahëpa xo noho Jahëpa ri. Ja qui ë cahai ca yoati tsi ëbë xatë bo yoata —nëa tsi María Magdalena qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jatsi quiha Jesu rabëti bo qui María caniquë yoacatsi na. —Ibo Jesu ë jisquë ra —i jato qui ja niquë. Jatsi ja qui Jesú yoaha ca jato qui ja yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jabi domingó tsi quiha manihi Jesu rabëti bo iniquë. Caquë quiha bari. Mitsëmono quiha. Jasca, xobo caiti quëbëhacani quiha, jato jimibo qui ja raquëcani iqui na. Ja manicano tsi quiha jato xërëquë tsi Jesu niitapiniquë pa. —Joquë ëa ra. Raquëyamacana —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Chanixo tsi quiha jahuë mëquë bo, jahuë taquëpë, tihi cabo jato ja jismaniquë. Jatsi quiha jahuë rabëti bo ranirianiquë jato Ibo jisi na. ");
INSERT INTO caoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jatsi jato qui Jesu chanitëquëniquë: —Raquëyamacana. Mato raaquia noho chani yoati, naa ëa noho Jahëpá raani jascaria —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Jatsi quiha jato ja xoohaniquë. Xoohacax tsi, —Espíritu Santo bicahuë —i jato qui ja niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Masahacati xo toa nohiria jocha ma shina-bënohaina. Jama, jato jocha pi ma shina-bënoyamano tsi masahacayamaxëqui mato —nëa tsi quiha jahuë rabëti bo qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jabi jato bëta Tomás, naa Gemelo icanai ca iyamani quiha, naa jato qui Jesu jisiquiquë no. Jabi doce ca rabëti bo ó ca huësti ca ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ja quëshpi tsi, —Ibo no jisquë ra —i Tomás qui jaca niquë. —¿Ocama ni? —i Tomás niquë—. Chahahuanox pari tsi jahuë mëquë tsayacasquia ra. Jasca, clavó tsacahitaha ca iti jiscasquia. Jahuë clavo quiní tsi noho mëtsis ë raaparino ra —nëa tsi quiha jato qui ja nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jatsi huësti semana huinocaniquë. Naquëtë tsi manihi quiha ja itëquëcaniquë. Toatiyá tsi jato bëtá Tomás iniquë jaa ri. Jasca, quëbëhacani quiha xobo caiti. Ja manicano tsi quiha naquëtë tsi jato xërëquë tsi Jesu jisiquitapiniquë. Nii quiha. Jatsi, —Joquë ëa ra. Raquëyamacana —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jatsi quiha Tomás qui Jesu chaniniquë: —Nëá mi mëtsis raahuë. Noho mëquë tsayahuë. Nëa mi mëquënë́ tsi noho taquëpë mamëpa. ¿Jari chahahuayamacatsai pa? Ea chahahuahuë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jatsi quiha, —Noho Ibobá, noho Diós —i Tomás niquë quëbihi na. ");
INSERT INTO caoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jatsi quiha, —Chahahuaqui mia, ëa mi jisi iqui na. Jama, shoma tsi xo toa ëa jis-haxma tsi ë qui chitimicanaibo ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jabi huëstima ca jisti huëtsa bo Jesú aniquë jahuë rabëti bo bësojo xo na. Naa libro ó tsi tihi ca jahuë bo quënëyamaxëquia; huëstima quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Jama, naa jisti bo quënëhacaquë jaha no pasohai ca Xabahamati Ibo Jesu nori ca ma cahëno. Jasca, Dios Baquë ja nori ca ma cahëno. Jabi bëso-bësopaoxëhi quiha ja qui chitimicanaibo. ");
INSERT INTO caoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jaquirëquë noqui, naa jahuë rabëti bo qui Jesu jisiquitëquëniquë ia Tiberias quëmapó no. Jabi nëca tsi noqui ja jisiquiniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro, Tomás, Natanael, naa Galileá ca yacatá racanish cato, Zebedeo baquë bo, Jesu dos ca rabëti bo, tihi cabo no iniquë ia quëmapó no. ");
INSERT INTO caoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Jatsi, —Sani ai caquia ra —i noqui Pedro niquë. Jatsi, —Mi bëta caqui noa noqui ri —i no niquë. Jatsi noti qui no jiconiquë noqui tëquëta. Jicoxo tsi mahitsa no tana-tanashinaniquë rë. Yama quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Huëaquë tsi quëmapó ca joni nii ca no jisniquë. Jesu ja iqui ca no cahëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jatsi, —¿Japa? ¿Mëquë ya ni mato, joni bá? —i noqui ja niquë. —Yamaha rë —i no niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jatsi, —Noti mënëcayá tsi mato nishi niatsacana. Toá ca bixëqui mato ra —i noqui ja niquë. Jatsi mënëcaya ó tsi noba nishi no nianiquë. Anomaria sani ini quiha. Jahari nishi xërëtimaxëni no iniquë rë, tihiria ca sani ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jatsi Pedro qui ë chaniniquë: —Tonia Ibo tsi xo toa ra —iquiina. Jatsi Pedró jahuë sahuëti sahuëniquë. Tsoboco ja ini quiha. Sahuëhax jënë qui ja biisiniquë Jesu qui caxëna. ");
INSERT INTO caoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Notí tsi noqui tëxë chitëniquë, sani rëamë ca nishi xërëhi na. Quëmapo basima no ini quiha, cien metros roha. ");
INSERT INTO caoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rërëxo tsi chihi rëxquë no jisniquë. Jahá ca sani imahi ja ini quiha. Toá tsi mapari ini quiha jaa ri. ");
INSERT INTO caoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jatsi noqui Jesu chaniniquë: —Ma bichi ca sani tihi roha ca nëri bëcana —i noqui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jatsi noti qui Pedro jiconiquë sani bixëna. Quëmapo qui nishi ja xërëniquë. Rëamë tsi nishi ini quiha; ciento cincuenta y tres sani quiha. Tësëyamaniquë nishi pa, huëstima ja iquë ri. ");
INSERT INTO caoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jatsi, —Nëri bëcahuë. ¿Sani piyamacanai? —i noqui Jesu niquë. Jabi Ibo Jesu yoi ja iqui ca no cahëniquë. Ja tsi xo toa “¿Ibo yoi ni mia?” iyamanoniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jatsi mapari bichi Jesu caniquë. Bixo tsi noqui ja mëaniquë. Sani noqui ja aniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jabi tres tsi ja iniquë, naa noqui Jesu jisiquihaina bësotëquëhax na. ");
INSERT INTO caoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","No oriquiquë tsi quiha Simón Pedro Jesú nicaniquë: —¿Tëxë bo oquë tsi ëa noihai, Jonás baquë Pedró? —iquiina. Jatsi, —Jaahuë, Ibobá. Mia noiquia. Toa cahëqui mia ra —i Pedro niquë. Jatsi Jesú quëbiniquë: —Noho oveja bo, naa ëa chahahuacanaibo tiisimana —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jatsi Jesú Pedro nicatëquëniquë: —¿Ea noiyoihai? —iquiina. —Jaahuë, Ibobá. Mia noiquia. Toa cahëqui mia ra —i Pedro niquë. Jatsi, —Noho oveja bo obëso mi ino ra —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jatsi quiha Jesú Pedro nicatëquëniquë pa: —¿Ea noiyoihai, Jonás baquë Pedró? —iquiina. Jatsi Pedro cohuëniquë, tres tsi “¿Ea noihai?” i Jesu ni iqui na. —Jatiroha ca cahëqui mia, noho Ibobá. Mia noiyoiquia. Toa cahëqui mia ra —i Jesu qui Pedro niquë. Jatsi quiha, —Noho oveja bo tiisimana —i ja qui Jesu niquë—. ");
INSERT INTO caoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jabi jaha mi quëëhai ca mi a-apaoniquë, shinapayo mi iquë no. Jama, mi sirinaquë tsi mia nëxacaxëcani quiha nohiria bo. Mi cacasyamahai ca qui mia mëpicaxëcani quiha mia namëxëna —nëa tsi quiha Pedro qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jabi Pedro rësohai quinia Jesú jismani quiha nëca tsi ja chaniquë no. Jabi Pedro rësohai cató tsi Dios oquë jismahacaxëti ini quiha. Jatsi, —Ea banahuahuë —i ja qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jatsi bopinaxo tsi ëa yoi Pedró jisniquë. Jato cho banahuahi ë ini quiha. Jabi Jesu rabëtiria ë ini quiha ëa ri. Jabi no oriquino tsi Jesu tapai tsahonish ca ëa xo naa, naa “¿Tsohuë ni toa mia pasomaha cato, Ibobá?” iquish cato. ");
INSERT INTO caoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Jatsi ëa jisi tsi, —¿Japa toa joni, Ibobá? ¿Jënahuariahax rësoxëhi ni? —i Pedro niquë ëa yoati na. ");
INSERT INTO caoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jatsi quiha Jesú Pedro quëbiniquë: —Toa joni shinayamahuë. Mi shina ma xo ja rësohaina. Ja bësopino tsi jahari ë joxëquë rohari noho shina tsi xo toa. Ea mi banahuati xo iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jatsi pë “Rësoyamaxëhi quiha Juan” itsi nohiria bo niquë. Jabi toa mahitsa ca chani rëtsamani quiha chahahuacanaibo xërëquë no rë. Jabi “Rësoyamaxëqui Juan” iyamaniquë Jesu. Jama, “Mi shina ma xo ja rësohaina. Ja bësopino tsi jahari ë joxëquë rohari noho shina tsi xo toa. Ea mi banahuati xo iquia” i Pedro qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jabi Juan xo ëa, naa carta quënëhai cato. Jabija tsi xo naa ë quënëhaina ra. Jabija ca ë quënëhai ca nori ca cahëqui mato ri. ");
INSERT INTO caoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jabi huëstimaria tsi xo toa Jesú anina ra. ¿Jënahuariaxo raca ja ani ca tëquë no quënëna? Jatiroha ca ë quënërohapino tsi xëa narisquë aquë janati ra.");
INSERT INTO caoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Noho jariapari ca cartá tsi Jesú yoati mi qui ë quënëniquë. Quënëxo tsi jatiroha ca Jesú anina, ja tiisimayonina, tihi cabo mi bax ë quënëniquë, naa jahuë yonoco ja chitahëhuatiya rohari ja tërononiquë rohari. ");
INSERT INTO caoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Tihi tsi ë quënëni quiha. Jama, tërononox pari tsi quiha ja bini ca rabëti bo Jesú tiisimaniquë Espíritu Santo chamá no. ");
INSERT INTO caoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jasca, bësohax huëstima tsi quiha jato qui ja jisiquiniquë. Cuarenta bari no tsi quiha jato bëta ja ini quiha. Jato bëtapama tsi quiha Diós otohai ca yoati ja chani-chaniniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jahuë rabëti bo ya rabënapama tsi quiha jato qui ja nëcaniquë: —Jari Jerusalén ax riquiyamacana. Nëa xo tsi manaparicana, naa noho Jahëpá mato qui raacatsai ca quëshpi na. “Espíritu Santo raaquia” i ja ni quiha, naa mato ë yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jënë́ tsi mato Juan yamabá ashimaniquë. Jama, ichariama bari no tsi Espíritu Santó tsi ashimahacaxëqui mato ra —nëa tsi jato qui Jesu nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jabi Jesu ya rabënapama tsi quiha jahuë rabëti bá nicaniquë: —¿Jaboqui tsi Israél cabo qui jato mai jahari axëhai, Ibobá? —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jatsi Jesú jato quëbiniquë: —Bari bo, fecha bo, tihi cabo janati Ibo tsi xo noho Jahëpa ra. Toa bari fecha bo cahënoma xo mato ra. ");
INSERT INTO caoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Jama, ma cahëxëti ca tsi xo naa: Mato qui Espíritu Santo jono tsi chama bixëqui mato. Jatsi caxëqui mato ëa yoati chanixëna. Jatsi Jerusalén, jatiroha ca jodioba mai, samariaba mai, nëama ca carayanaba mai, tihi cató tsi ëa yoati chanixëqui mato ra —i jato qui Jesu niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Chanihax tsi quiha nai qui ja tërohacaniquë. Ja tëronono tsi quiha ja tsaya-tsayacaniquë. Jatsi quiha tsëmo qui ja jiconiquë. Caquë ra. Jisnoma ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jabi ja tëronohai ca ja tsaya-tsayacano tsi quiha dos ca ángel bo jisiquiniquë jato tahë no. ");
INSERT INTO caoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jisiquihax ja nëcacaniquë: —¿Jëniriahax nëá tsi niicanai pa, naa nai tsaya-tsayacanaina, Galileá ca joni bá? Jotëquëxëhi quiha naa mato ó ax tëronohax ca Jesu yoi ra. Ja tëronohai ca ma jisquë. Toca tsi jahari joxëhi quiha ja bacaxëquë no —i jato qui ángel bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Maca Olivo Ya jisbëria tsi quiha Jerusalén qui ja bacacaniquë, naa jahuë Chani chitahëhuati ibo bo. Cariama quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yaca qui cahëhax tsi quiha jato naquëtë qui ja jicocaniquë. Mana jato racati ini quiha. Toá tsi ja manicaniquë, naa Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo baquë Jacobo, Simón, naa gobierno pasomaha chaninish cato, Jacobo noma Judas. ");
INSERT INTO caoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Toá tsi iniquë yoxa bo ri, naa Jesu jahëhua, jahuë noma bo, tihi cabo. ");
INSERT INTO caoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Toatiyá tsi quiha Pedro niiniquë chahahuacanaibo qui chanixëna. Toá tsi ciento veinte ca nohiria mani ini quiha. Niihax ja nëcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Jatihuahacati nori quiha Quënëhacanish cabo iquë ra, naa Espíritu Santó David yamabo chanimanina. Jabi Judas yamabá, naa Jesu qui tsamicanish cabo mëpinish cató ani ca yoati David yamabo chanini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jasca, no bëta Judas yamabo yonocobëquinapaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Jama, ja ani ca yoi ca quëshpi tsi parata ja bini quiha pë. Bixo tsi quiha mai pistia ja copini quiha. Toá tsi ja rësoniquë paquëhax na. Poshini quiha jahuë jatoquë. Jatsi jahuë poco xapaquëni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jatsi quiha “Mai Jimi Ya” toa mai Jerusalén ca nohiria bá quënaniquë nicaxo na. Jato joí tsi quiha “Acéldama” ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tsayacahuë. Nëca tsi quiha salmos libro ó tsi David yamabá quënëni quiha: “Yoshihuahacaxëti xo jahuë xobo. Toá tsi nohiria racayamano” i ja ni quiha. ‘Jasca, “Jahuë yonoco huëtsá bino” ii quiha Judas yoati na. ");
INSERT INTO caoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","‘Ja tsi xo toa huësti ca joni no bixëti xo jahuë yonoco iti ja bino iquish na. Jasca, no bëta inish ca ja iti nori quiha, naa Jesu ya co-copaonish cato. ");
INSERT INTO caoNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Juan yamabá Jesu ashimani ca jisni ca ja iti xo. Jasca, jatiroha ca Jesú ayonina, no quima ax ja mëbihacanina, tihi cabo jisti nori ja iti xo. Jasca, “Bëso xo Jesu” i ja xëti nori quiha no bëta —nëa tsi Pedro nëcaniquë jato qui. ");
INSERT INTO caoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Jatsi quiha dos ca joni bo ja bicaniquë. Bichi tsi quiha ja bëhoxcaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","—Jatiroha ca joni ba shina naispiqui mia ra. Nëá xo dos ca joni bo. ¿Jëni ca joni mi bichi? Noqui jismahuë ra, ");
INSERT INTO caoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","naa Chani chitahëhuati iboba yonoco ja ano. Jabi naa yonoco Judás niabëriani quiha rë jahuë iti qui caxëna —nëa tsi ja nëcacaniquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jatsi quiha suerte bo ja acaniquë cahëxëna. Bëboniquë Matías. Bëbohax once ca Chani chitahëhuati ibo bo qui ja riiniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Fiesta Pentecostés icanai ca bari tsëquëquë tsi quiha naquëtë tsi chahahuacanaibo tëquë mani iniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Manipama tsi quiha nai ax johai ca yoshi chamaxëni ca pacotsa ja nicacaniquë. Rëamëni quiha xobo, naa ja tsahocanai cató no. ");
INSERT INTO caoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jatsi quiha chihi jana jisiria ca ja jiscaniquë. Jatiroha cabo qui naa chihi jana japacaniquë mapëxëhax na. Jato mapo tëquë ó nii ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Jatsi quiha Espíritu Santo ja rëahacacaniquë. Rëamëhax joi jamërí tsi chanitsijacaniquë, naa Espíritu Santó jato chanimahai cató no. ");
INSERT INTO caoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Toatiyá tsi quiha Jerusalén tsi huëstima ca jodiobo racahi iniquë, naa país huëtsa bo ax bëcanish cabo. Dios noicanaibo ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Naa yoshini pacotsa ja nicacaniquë jato ri. Nicahax tsi quiha ja quëtsocaniquë. Jatsi ja shina-risiquicaniquë, jato joi yoi bá tsi ja chanicanai nori quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jatsi ja ratë-ratëcaniquë: —Jisna. ¿Galileá ca joni bo ma ni naa chanicanaibo pa? ");
INSERT INTO caoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Jënahuariaxo raca noba joi yoí tsi nicahi ni noa sa? ");
INSERT INTO caoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nëá xo Partia joi jaya cabo. Nëá xo Media joi jaya cabo. Nëá xo Elam joi jaya cabo. Jasca, nëá xo Mesopotamia, Judea, Capadocia, Ponto, Asia, tihi ca maí ca nohiria joi bo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Jasca, nëá xo Frigia, Panfilia, Egipto, tihi ca mai ax bëcanish cabo. Nëá xo Africa ó ca Cirene ori ax becanish cabo ra. Jasca, nëá xo Roma ax bëcanish cabo, jodioba arati jabi binish ca carayanabo ri. ");
INSERT INTO caoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Jasca, tobi Creta, Arabia, tihi ca mai ax bëcanish cabo. Noba joi yoi bá tsi chanicani quiha pa. Anomaria ca Diós aca ca noba joí tsi yoacani quiha ra —nëa tsi quiha naa nohiria nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Jatsi quiha ja ratëyocaniquë. Ratëhax, —¿Jënahuaria ni sa? ¿Jënipihi ni? —i jaca niquë chaninahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Jama, huëtsa bá osa-osacaniquë nicaxo na. —Huëstima ca jënë ja ayocaquë iqui noa. Pahëquë naa joni bo ra —i jaca niquë rë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jatsi quiha Pedro niiniquë once ca Chani chitahëhuati ibo bo ya. Niihax chanitsijaniquë joi pistiamá no. —Ea nicacana, ëbë xatë bá, Jerusalén ca racacanaibá. ");
INSERT INTO caoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Naa joni bo pahëha ca quëscahuaqui mato pë. Pahëyama ca xo iquia. ¿Jënahuariahax ja pahëcana? Tsayacapa. Huëaquë tsi, naa a las nueve roha tsi xo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jama, ma jisi ca yoati Joel yamabá quënëniquë ra. Ja yoani ca tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Jaroha ca barí tsi nohiria bo tëquë qui noho Shina japaxëquia ra” ii quiha Dios. “Jasca, ëa yoati tsi chanicaxëcani quiha mato baquë bo, mato jahi bo ri. Jasca, tënamëcaxëcani quiha mato shinapayo bo. Jasca, namacaxëcani quiha mato siri bo. ");
INSERT INTO caoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Jasca, noho yonati bo, naa joni bo, yoxa bo, tihi cabo qui noho Shina japaxëquia ra toa barí no. Jatsi ëa yoati tsi chanicaxëcani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Jatsi naipá ca jistiria bo, maí ca jisti bo, tihi cabo jismaxëquia. Tobixëhi quiha jimi, chihi, chihicohini ");
INSERT INTO caoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Jasca, tsëmonaxëhi quiha bari. Shininaxëhi quiha oxë, naa jimi jascaria. Tocaxëhi quiha ra, Ibo johai ca bari tsëquënox pari no. Anomariaxëhi quiha toa bari ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Jasca, xabahamahacacaxëcani quiha Iboba janë quënacaxëcanaibo tëquë” ii quiha Dios; nëa tsi Joel yamabá quënëniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","‘Ea nicaparicana, Israél ca joni bá. Jahuë Jesu, naa Nazarét ca Jesu qui chama Diós aniquë ra. Toca tsi quiha Diós raani ca ja iqui ca ma jismahacaniquë, Dios chamá tsi jistiria bo ja ani cató no. Jisti bo ja aniquë ra mato bëtaquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jabi naa joni mato qui mëahacaniquë, Dios shinana, naa jaha ja quëëni ca ja ini quëshpi na. Jatsi carayanabo yaxo tsi cruzó tsi naa joni ma tooxaniquë. Naa joni ma namëniquë iquia. ");
INSERT INTO caoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jama, jahuë Jesu Diós bësotëquëmaniquë iquia. Bësoyama caba iti quima ax ja paquëmahacani quiha ra. Bëbotimaxëni ja rësohai ca ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Jabi Jesu yoati tsi David yamabo nëcaniquë: “Ea bësojó ca Ibo ë jisquë. Ea jisbëriayamahi quiha. Ja iqui tsi shina-motsiquiyamaxëquia ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ja tsi xo toa shina-raniquia. Anomaria xo noho Ibo iquia ranihi na. Rësohax bësotëquëti ó pasoquia ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bësoyama caba iti ó tsi ëa jisbëriayamaxëqui mia ra. Jasca, mi chama iqui tsi poroyamaxëhi quiha mi yonati jiaxëni cato. ");
INSERT INTO caoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Bësoti quinia ëa mi jismaquë. Jasca, ëa ranihuaxëqui mia, mi bëta ë xëquë no” i jahuë Jahëpa Dios qui Jesu ni quiha David yamabá quënëni cató no. ");
INSERT INTO caoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","‘Bëró tsi mato qui chaniquia, ëbë xatë bá. Nicacana. Siri tsi David yamabo yoi rësoniquë. Ja maihuahacaniquë. Jasca, tobi quiha no bëta jahuë mai. ");
INSERT INTO caoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jabi Dios shina cahëxëni ca David yamabo iniquë iquia. “Mi chahitaxocobo huësti ca janaxëquia, mi trono xo tsi ja yonano” i ja qui Dios ni ca ja cahëniquë. Jasca, quiayamahai ca Dios ini ca ja cahëniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Jabi rëquë ca xaba tsayahi David iniquë Cristo qui. Diós axëti nori ca cahëhax tsi quiha Cristo bësotëquëxëhai ca yoati ja chaniniquë. Bësoyama cabo iti ó tsi ja niabëriahacayamaxëhaina, jahuë yora poroyamaxëhaina, tihi cabo yoati David chanini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Dios tsi xo toa naa Jesu icanai ca Bësotëquëmati Ibo. Ja bësotëquëyamëquë ra. Tihi ca tsi xo toa no yoahaina ra, naa noqui tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jasca, jahuë Jesu Diós oquë-oquëhuaniquë ra. Jaboqui Dios mënëcayá tsi tsaho xo ra. Jaquirëquë Espíritu Santo jahuë Jahëpa quima Jesú biniquë. Bixo tsi quiha noqui ja japaniquë, naa Diós yoani jascaria. Jabi noqui Espíritu Santo japahacahai ca tsi xo toa ma tsaya-tsayahaina, ma nica-nicahaina ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tsayacahuë. Nai qui tëronoyamaniquë noba David yamabo. Jama, nëca tsi ja quënëniquë noba Jesu yoati na: “‘Noho mënëcayá tsi tsahotsina, ");
INSERT INTO caoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mi chama nama tsi mia pasomaha cabo ë janaxëquë rohari’ i noho Ibo qui Ibo Dios ni quiha” nëa tsi David yamabo nëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","‘Jatsi jatiroha ca Israél ca nohiria bá jabija ca cahëno ra. Ma tooxani ca Jesu Diós oquëhuaniquë ra. Noba chama, noqui Xabahamati Ibo, tihi cabo Diós jahuë Jesu manëmaniquë —nëa tsi nohiria bo qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Jatsi Pedró yoani ca nicahax tsi quiha ja cohuënacaniquë. Cohuënahax, —¿Jënahuaxëhi ni noa ra, noba xatë bá? —i Pedro, Chani chitahëhuati ibo bo, tihi cabo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jatsi Pedró quëbiniquë: —Mato jocha quima Dios quiri bësocana. Jasca, Jesu janë́ tsi ma ashimahacaxëti xo. Tocacana, mato jocha masahacano iquish na. Jatsi mato qui Espíritu Santo axëhi quiha Dios ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Mato, mato xocobo, carayanabo, tihi cabo qui Espíritu Santo acatsi quiha, mato qui jahuë Chani acacani iqui na. Bixëhi quiha noba Ibo, Diós quënani cabo tëquë —nëa tsi nohiria bo qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Chanipama tsi quiha jato ja yoba-yobaniquë: —Jochahuaxëniria ca nohiria bo quima tsëquëcana, xabahamahacaxëna —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Jatsi quiha ashimahacaniquë jahuë chani chahahuanish cabo. Toa barí tsi quiha chahahuacanaiba maxo qui tres mil ca nohiria riiniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Chahahuaxo tsi quiha Chani chitahëhuati ibobá tiisimani ca ja nica-nicacaniquë. Jia tsi quiha ja rabëna-rabënabëquicaniquë. Rabënaxo tsi quiha Dios shiati ja nëtocaniquë. Jasca, Dios qui ja bëhox-bëhoxcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Toatiyá tsi quiha huëstima ca jisti bo jahuë Chani chitahëhuati ibobá aniquë. Jatsi ratëyoniquë nohiria tëquë, tsayahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jasca, racanabëquiniquë chahahuacanaibo tëquë. Racanabëquihax tsi quiha jato jahuë bo tëquë ja xatënacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Jato jahuë bo iniaxo tsi quiha noitiria cabo qui parata ja acaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Jasca, jatiroha ca barí tsi quiha jodioba arati xobó tsi ja cati-caticaniquë Dios qui araxëna. Jasca, jato xobo xo tsi quiha shiati ja pi-pipaocaniquë. Jasca, ja oriquibëquinapaocaniquë ranihax na. Ja huashiyamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Jasca, jia tsi Dios ja ocahua-ocahuacaniquë. Nohiria qui jia jato jabi ini quiha. Jasca, jatiroha ca barí tsi quiha nohiria xabahamahacaniquë. Jatsi iglesia qui ja riicaniquë chahahuahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Huësti barí tsi quiha Pedro, Juan, tihi cabo jodioba arati xobo-xoboria qui bocaniquë bëhoxhi na. A las tres ja ini quiha, naa jato bëhoxti hora. ");
INSERT INTO caoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Jabi toá tsi arati xobo caití tsi quiha, naa “Caiti Jiaria” icanai cató tsi quiha joni noitiria ca tsaho iniquë. Catëjo ca tahë yoi jayanish ca ja ini quiha. Jatiroha barí tsi toá tsi ja janahacani quiha, parata bënariati. ");
INSERT INTO caoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Jatsi arati xobo-xoboria qui Pedro, Juan, tihi cabo jicohai ca ja jisniquë. Jisi tsi, —E qui parata ahuë —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jatsi joni Pedro Juan bëisniquë. Bëis-hax ja qui Pedro chaniniquë: —Noqui bëishuë iquia —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Jatsi quiha joni tsaya-tsayaniquë. Parata ó ja pasoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jatsi Pedro ja qui nëcaniquë: —Parata yama ca ëa xo naa. Jama, mia mëbicasquia. Nazarét ca Jesucristo tsi xo toa chama jaya cato. Jahuë janë́ tsi tapitsina iquia —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jatsi jahuë mëquë mënëcayá tsi Pedró biniquë. Bixo tsi quiha toa joni ja joimaniquë. Chamatapini quiha jahuë tahë. Jënima jahuë jopoto ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Jatsi joni biisiniquë. Jahuë tahë́ tsi ja niiniquë. Jatsi co-cotsijaniquë. Jatsi quiha Pedro, Juan, tihi cabo ya arati xobo qui ja jiconiquë jaa ri. Co-copama tsi quiha Dios ja ocahua-ocahuaniquë, biisi-biisixo na. ");
INSERT INTO caoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ja cohaina, Dios ja ocahuahaina, tihi ca tsi quiha toá ca maní ca nohiria bá jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Parata bënaxëniria cato, naa “Caiti Jiaria” icanai cató ca tsahopaohax ca joni ja iqui ca cahëhax tsi ja ratëyocaniquë. —¿Jënahuariahax ja jënimahuahacaha sa? —i jaca niquë tsayahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Pedro, Juan, tihi cabo parata bënaxëniria cató achaniquë. Achajahuano tsi quiha jato qui nohiria bo jabayoniquë tsayacatsi na. Portal de Salomón icanai cató tsi ja quëtsocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Jatsi nohiria bo jisi tsi quiha jato qui Pedro chaniniquë. Ja nëcaniquë: —¿Jëniriahax ratëcanai pa? ¿Jëniriaxo tsi noqui tsaya-tsayacanai sa? Noba chamá tsi naa joni no tapimayamaquë ra. ¿Jënahuariaxo noba mëstë ca jabí tsi naa joni no jënimahuana ra? ");
INSERT INTO caoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Dios, naa noba Abraham yamabo, noba Isaac yamabo, noba Jacob yamabo, tihi caba Diós jahuë yonati Jesu oquëhuaniquë ra. Jabi naa jasca ca Jesu Pilato qui ma mëaniquë pë, ja namëhacano. Jatsi Pilató paquëmacasquë tsi quiha “Anoma. Paquëmayamahuë” i ja qui ma niquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Mato ti tsi xo toa jocha yama ca Mëstëxëniria ca niati ibo-iboria bo iquia. Niaxo ati ibo-iboria ca joni ma baaniquë rë, paquëmahacati. ");
INSERT INTO caoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Mato ti tsi xo toa nohiria Bësomati Ibo-iboria acanaibo iquia. Jama, naa acacanish ca Jesu Diós bësotëquëmaniquë ra. Jabija tsi xo naa no yoahaina iquia. Parayamaqui noa. ");
INSERT INTO caoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Naa joni, naa ma tsayahai ca joni jënimahuahacaquë ra, naa jasca ca Jesu janë́ no. Naa ma cahëhai ca joni tapimahacaquë ra, toa janë qui ja chitimiha cató no. Tsayacahuë. ");
INSERT INTO caoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","‘Jisa, noho xatë bá. Tonia cahëxoma tsi ma tocaniquë iquia, naa mato rëquëniniti ibobá ani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Jama, toca ca quiniá tsi quiha ja yoacani ca Diós jatihuaniquë, ma tocani cató no. Naama tsi quiha Cristo yoati tsi jahuë Chani yoanish cabo chanini quiha, “Tënëxëti xo Cristo” iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Jatsi jaboqui mato jocha quima Dios quiri bësocana ra, mato jocha masahacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jatsi mato ranihuaxëhi quiha Ibo Dios. Jasca, mato bax ja bini ca Xabahamati Ibo, naa jahuë Jesu mato qui raaxëhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jama, jaboqui naipá tsi ja chitëpariti xo ra. Jariapari tsi tsëquëxëti xo jatiroha ca paxahuahacatiya, naa Dios Chani yoanish cabá tsi Diós yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés yoani ca nicacana. Ja nëcani quiha: “Mato qui Dios Chani Yoati Ibo-iboria raaxëhi quiha Dios ra, naa mato qui ëa ja raani jascaria. Mato jimibo huësti ca yoi ixëhi quiha naa joni ra. Ja yoahai ca tëquë ma nicaxëti xo. ");
INSERT INTO caoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Jasca, Dios nohiria bo quima aquëquëmahacaxëti xo toa joni chani nicayamacanaibo. Nicayamahax quëyohacacaxëcani quiha” tihi ca tsi i Moisés ni quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","‘Jabi naa xaba yoati tsi Dios Chani yoanish cabo tëquë chanipaoni quiha, naa Samuel yamabo tiya rohari cabo. ");
INSERT INTO caoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Jasca, naa Dios Chani yoacanish caba chahitaxocobo xo mato ra. Mato qui Dios Chani acacani quiha jaari, naa mato naborëquëbo qui ja acacani jascaria. Jariapari tsi quiha Abraham yamabo qui Dios Chani acacaniquë, naa “Chahitaxocobo jayaxëqui mia. Toa baquë́ tsi shomahuahacaxëhi quiha maí ca nohiria bo tëquë” i ja qui Dios nina. ");
INSERT INTO caoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Jatsi mato jodiobo qui pari tsi quiha jahuë yonati yoi Diós raaniquë mato shomahuaxëna. Mato jocha quima mato casomacatsi quiha ra —nëa tsi quiha Pedro nëcaniquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Jari nohiria bo qui ja chanicano tsi quiha bëcaniquë arati ibo bo, arati xobo obëso ca capitán. Jasca, bëcaniquë saduceobo icanai ca chama bo ri, naa “Bësotëquëyamaxëhi quiha nohiria” icanaibo. ");
INSERT INTO caoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jato qui yoi ini quiha toa nohiria bo qui Pedro, Juan, tihi cabá tiisimanina, Jesu bësotëquëmahacani nori yoahi ja icani quëshpi na. Jato qui yoi toa chani ini quiha, nohiria bësotëquëyamaxëhai ja quëscahuacani quëshpi na. Jatsi Pedro, Juan, tihi cabo qui ja caxacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Caxahax tsi quiha jato qui ja tsamicaniquë. Caquë quiha bari. Ja iqui tsi preso qui jato ja nanëcaniquë huëaquë copixëna. ");
INSERT INTO caoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Jama, huëstima cabá chahahuaniquë jato chani nicaxo na. Cinco mil ca joni bo tahë ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Huëaquë tsi quiha jodioba chama bo catiniquë, naa jato yosibo, jato yoba tiisimacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Toá tsi quiha Anás, naa jato arati ibo-iboria iniquë jaa ri. Jasca, toá tsi quiha Anás jimibo iniquë jato ri, naa Caifás, Juan, Alejandro, tihi cabo. ");
INSERT INTO caoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Catixo tsi quiha jato nëpax tsi Pedro Juan ja nimacaniquë nicaxëna. Nimahax, —¿Jënahuaxo tsi naa joni ma jënimahuahitaha sa? ¿Jahuë chama ya ni mato ra? ¿Tsohuë ni toa naa chama mato qui ati ibo ra? —i jato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jatsi quiha Espíritu Santo rëamëxo tsi Pedró quëbiniquë: —Noqui nicacana, nohiria chama bá, yosibá. ");
INSERT INTO caoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","¿Naa noitiria ca joni no mëbihitaha ca yoati tsi noqui nicacanai sa? “¿Jënahuariahax naa joni jënimahuahacaha sa?” ¿ii ni mato ra? ");
INSERT INTO caoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Jënima quiha. Ma cahëyoti xo. Cahëxëti xo Israél ca nohiria bo tëquë ri. Nazaret ca Jesucristo chamá tsi ja jënimahuahacahitaquë ra, naa ma tooxani ca jasca cato chamá no. Ja tsi xo toa Diós bësomanina. Jesu chama iqui tsi mato bësojó tsi nii quiha naa joni ra. ");
INSERT INTO caoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jabi naa jasca ca Jesu yoati tsi chanihi quiha Quënëhacanish cabo ra. “Oquënaxëhi quiha yosibá niaha ca Maxaxa ra. Oquë-oquëria ca manëxëhi quiha” ii quiha ra. Jabi Jesu tsi xo naa maxaxa ra, naa ma niani cato. Jama, naa maxax jascaria tsi ja oquënani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Oquë-oquëria ca tsi xo naa ra. Yama tsi xo Xabahamati Ibo huëtsa ra. Ja huësti ca tsi xo Jesu. Jaroha ca tsi xo toa Diós noqui acana noqui xabahamati —nëa tsi quiha chama bo qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Chama ya tsi Pedro, Juan, tihi cabo chanini nori ca jisi tsi toa chama bo ratërianiquë. Jasca, escuela qui ja boyamacani nori ca nicaquí tsi Jesu rabëti bo ja icani nori ca ja cahëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Jama, Pedro, Juan, tihi cabo ya niihai ca jënimahuahacahitahax ca joni jisi tsi quëbiti ja cahëyamacani quiha. Ja iqui tsi jato qui quësoti mëtsama ja icaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jatsi quiha naquëtë cacha jato ja raacaniquë jamëhax chaninaxëna. Raahax, ");
INSERT INTO caoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Jënahuariaxëhi ni noa sa, naa joni bo qui? Naa anomaria ca jisti naa joni bá acahitaha ca cahëhi quiha Jerusalén ca nohiria bo tëquë rë. ¿Jënahuariahax “Oca ma xo” i no na ra? ");
INSERT INTO caoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Naa jahuë bo nohiria bo qui pacanamitsa rë. Jato no jënëxëti xo ra. Jatsi jato no yobano, Jesucristo janë́ tsi ja chanitëquëpistiariacano —i jaca niquë chaninahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jatsi quiha Pedro, Juan, tihi cabo ja quënacaniquë. Quënaxo tsi quiha jato ja yobacaniquë: —Nohiria bo qui Jesu yoati tsi ma chanitëquëyamano ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Jama, Pedro, Juan, tihi cabá quëbiniquë: —Shinaparicana. ¿Tsohuë nicayoixëhi ni noa ra? ¿Mato ni? ¿Dios ni? ");
INSERT INTO caoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","¿Jënahuariaxo no chanihai ca no jënëna ra? No jisnina, no nicanina, tihi cabo yoati tsi no chaniti xo ra —i jato qui Pedro Juan niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Yobatëquëxo tsi quiha chama bá jato paquëmaniquë. Jabi nohiria bo qui raquëquí tsi Pedro, Juan ja copiyamacani quiha. Jabi naa jënimahuahacanish ca joni quëshpi tsi Dios ocahuahi nohiria bo iniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Anomaria toa jisti ini quiha. Cuarenta año bo huino toa jënimahuahacanish ca joni ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Jisbëria tsi quiha jato nohiria yoi bo qui Pedro Juan bocaniquë. Jatsi quiha arati ibo bo, yosibo, tihi cabá yoani ca jato ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jatsi quiha Dios qui ja bëhoxyocaniquë nicahax na: —Mia ri tsi xo Ibo-iboria. Mia ri tsi xo toa naipa, mai, ia, tihi cabo Nëhohuati Ibo ra. Jahá cabo tëquë mi ani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Jasca, mia ri tsi xo toa Espíritu Santó tsi noqui chaninish cato, naa noba naborëquëbo David yamabo mi chanimaniquë no: “¿Jënihax tsi caxahi ni carayanabo pë? ¿Jënixo mahitsa tsi shina-shinahi ni nohiria bo ra, Dios pasomaha yoi ca axëna? ");
INSERT INTO caoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Shomahuahacacani quiha maí ca rey bo rë, iquinaxëna. Caticani quiha país ca chama bo rë, Ibo Dios, jahuë Xabahamati Ibo, tihi cabo pasomaha iquinaxëna” i David yamabo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Tocapiyamëquë ja yoanina iquia. Naa noba yaca yoí tsi Herodes, Poncio Pilato, tihi cabo chaniyamëquë carayanabo, Israél ca nohiria bo, tihi cabo ya. Chaninaxo tsi quiha mi yonati mëstëxëni ca Jesu, naa noqui mi raani ca ja namëcasjahuacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jatsi quiha ja tocacaniquë. Jabi mi planes, naa mi chamá tsi acacani ca planes roha ja acani quiha, mi shina ja ini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Jabi jaboqui mi yonati bo roamiscani quiha pë, Ibobá. Jama, noqui, naa mi yonati bo mi chamahuano, raquëxoma tsi mi chani no yoano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jasca, mi chamá tsi noitiria cabo mi jënimahuano. Jasca, mi yonati jiaxëni ca Jesu janë́ tsi jisti-jistiriabo mi ano ra” —nëa tsi ja nëcacaniquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ja bëhoxcaquë tsi quiha yajo-yajohacaniquë ja caticani ca xobo ra. Jasca, Espíritu Santó tsi ja rëahacacaniquë. Rëamëhi tsi raquëhaxma tsi quiha Dios Chani chanitsijacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Toatiyá tsi quiha jia tsi chahahuacanaibo rabënabëquicaniquë. Jaharisi quiha ja shinacanai ca ini quiha. Jasca, jato jahuë bo tëquë ja xatënacaniquë. “Nohó-na xo naa, nohó-na xo toa” iyama jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jasca, chama-chamariá tsi quiha Dios Chani chitahëhuati ibo bo chaniniquë, Ibo Jesu bësotëquëmahacani nori ca yoahi na. Toatiyá tsi quiha jia tsi Diós jato mëbiniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Jasca, toatiyá tsi quiha chahahuacanaibá narisyamaniquë. Jato xobo bo, jato mai bo, tihi cabo ja iniacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Iniaxo tsi quiha toa parata Chani chitahëhuati ibo bo qui ja acaniquë. Jaquirëquë quiha noitiria cabo qui toa parata acacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Jabi tocaniquë José, naa Chipre ó conish cato. Arati xobó ca yonati ja ini quiha. Jabi naa José qui janë huëtsa Chani chitahëhuati ibo bá ani quiha, naa Bernabé cato. Noba joí tsi “Nohiria mëbiti ibo” iqui noa. ");
INSERT INTO caoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jabi jahuë mai Bernabé inianiquë jaa ri. Iniaxo tsi quiha Chani chitahëhuati ibo bo qui jahuë parata ja mëaniquë, noitiria cabo qui acacati. ");
INSERT INTO caoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Jatsi quiha joni huëtsa, naa Ananías icanai cató jahuë mai inianiquë jaa ri, jahuë ahui Safira yaxo na. ");
INSERT INTO caoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Iniaxo tsi quiha parata xatë ja jananiquë jamë bax na. Jahuë ahui qui jia ini quiha ja anina. Jatsi quiha parata tëxë ja bëniquë Chani chitahëhuati ibo bo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ja bëquë tsi quiha ja qui Pedro chaniniquë: —¿Jënahuariahax mi shina qui Satanás jicoha pa? Parata xatë mi jonëquë pë iniaxo na. Toca tsi Espíritu Santo qui mi quiaquë rë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Toa mai inianox pari tsi ¿mí-na ja iyamayamani? Jasca, ja iniahacaquë tsi jari mi parata ja iquë ra. Jama, noqui paracasquí tsi toa parata xatë roha noqui mi bëquë rë. Anoma tsi xo toca ca mi shinahaina iquia. Dios qui mi quiaquë rë, joni qui nomari —nëa tsi quiha ja qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jatsi quiha Ananías rësoniquë, Pedro chani nicahax na. Mai qui ja paquëniquë. Jatsi quiha nohiria tëquë raquë-raquëniquë nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jatsi joixo tsi quiha shinapayo bá jahuë yora yaboniquë raití no. Yaboxo tsi cacha boxo tsi ja maihuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tres hora quirëquë Ananias ahui jiconiquë, naa Safira icanai cato. Jari jahuë bënë rësoha nori ca ja nicayamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jatsi Pedró nicaniquë: —Ea yoahuë. ¿Tihi roha ca parata ma bichi, mato mai quëshpi na? —iquiina. Jatsi quiha, —Jabija. Tihi roha ca parata no bichitaquë —i Pedro qui ja niquë. Ja quiani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Jatsi Pedró quëbiniquë: —Jishopë. ¿Jëniriaxo nëca tsi mi shinaha pa. Espíritu Santo tanamaqui mia pë. Nicapa. Bëcani quiha rë mi bënë maihuahax cabo. Mia bichi bëcani quiha maihuaxëna —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jatsi ja rësotapiniquë. Jatahë tsi quiha ja paquëniquë. Jatsi quiha shinapayobá jiconiquë. Jicoxo tsi ja jiscaniquë. Cacha boxo tsi quiha jahuë bënë ya raquëpina tsi ja maihuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Jatsi raquë-raquëniquë chahahuacanaibo tëquë. Jasca, raquëyoniquë nicanish ca nohiria huëtsa bo ri. ");
INSERT INTO caoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Toatiyá tsi quiha Salomón Portal icanai cató tsi chahahuacanaibo catihi ipaoniquë araxëna. Toa xo tsi huëstima ca jisti bo Dios Chani chitahëhuati ibobá ani quiha, nohiria bo xërëquë xo na. ");
INSERT INTO caoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Jama, jato bëta arati catiyamani quiha nohiria tëxë rë, jato chama bo qui raquëhi na. Jama, nohiria bo qui shinajiaxëni cabo chahahuacanaibo ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Toatiyá tsi jato qui riini quiha huëstima ca chahahuacanaibo paxa cabo, naa Ibo qui chitimicanish ca joni bo yoxa bo tëquëta. Jatiroha ca barí tsi jato maxo anini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Jasca, Chani chitahëhuati ibobá acani ca jisti bo iqui tsi isicanaibo, iquicanaibo, tihi cabo nohiria bá bëcani quiha ja jënimahuahacacano. Bahí tsi jato oxati, jato huana bo, tihi cabo ó tsi ja janahacacani quiha Pedro ja manacano. Pedro tëbaquishi jato matarahai ca ó ja quëëcani quiha jënimahuahacati. ");
INSERT INTO caoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jasca, Jerusalén ca tëamë ca yaca huëtsa bo quima ax nohiria bëcani quiha. Isicanaibo, yoshi jaya cabo, tihi cabo ja bëcani quiha. Ja jënimahuahaca-caniquë jato tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Jatsi quiha Dios Chani chitahëhuati ibo bo qui arati ibo-iboria yosananiquë. Jato qui yosananiquë jahuë rabëti bo ri, naa saduceobo, naa “Bësotëquëyamaxëhi quiha nohiria” icanaibo. ");
INSERT INTO caoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yosanahax tsi quiha jato qui ja tsamicaniquë. Tsamixo tsi preso qui jato ja nanëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jatsi toa baquichá tsi quiha Ibo Diós raani ca angél preso caiti japëcaniquë. Japëcaxo tsi quiha preso cacha jato ja bëniquë ra. Jatsi jato qui ja yoaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Bocata. Arati xobo nabirí tsi niixo xabahamati quinia paxa ca yoacana —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jatsi huëaquë tsi quiha arati xobo qui ja jicocaniquë, naa ja yoahacacani jascaria. Jicoxo tsi nohiria bo tiisimatsijahuacaniquë. Jatsi quiha arati ibo ba cahëniquë jato rabëti bo ya. Cahëxo tsi quiha jodioba chama bo, yosibo, tihi cabo ja quënacaniquë chaninaxëna. Jatsi quiha preso qui policía ja raacaniquë Chani chitahëhuati bo bëti. ");
INSERT INTO caoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Preso qui cahëxo tsi quiha Chani chitahëhuati ibo bo policía yopaniquë. Yama a ra. Jatsi ja bacacaniquë chama bo yoaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Preso qui no cahëquë. Jënima toa caiti bo iquë ra. Pëyëhama quiha jahuë candado iquë iqui noa. Jasca, caiti cacha jari nii iqui quiha jaha bësoti soldado bo ra. Jama, caiti japëcaxo tsi yama ca no jisquë pa. Mëquëya toa jato presó ca naquëtë iquë pa —i chama bo qui jaca niquë bacahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Jatsi ja yoacani ca nicahax tsi quiha ja shina-risiquiyocaniquë, naa soldado ba capitán, arati ibo-iboria bo. Nicahax, —¿Jënahuaria ni sa? —i jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Jatsi quiha chani paxa jaya ca joni jiconiquë. Jicohax, —Jisi bocata. Arati xobo nabirí tsi nii quiha nanëhacahitahax ca joni bo ra. Toa xo tsi nohiria bo tiisimacani quiha ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jatsi mëri tsi capitán caniquë jahuë soldado bo ya. Jahari chama bo qui jato ja bëcaniquë. Ishima tsi toa Chani chitahëhuati ibo bo ja bëcani quiha nohiria bo qui raquëquí na. Nohiria bá jato acai ca ja quëscahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Bëxo tsi quiha chama bo bësojó tsi jato ja nimacaniquë. Jatsi arati ibo ba chama bá jato nicaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—“Jesu yoati tsi nohiria bo tiisimayamacana” ¿i mato qui no yamayamahitaha ra? ¿Jënahuariacanai ra? Jerusalén tsi pacanahi quiha mato chani ra. Anoma tsi xo toa ma tiisimahaina. Jasca, noqui quësocasqui mato pë, toa Jesu nani quëshpi na —nëa tsi quiha arati ibo ba chama nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jatsi Pedro, Dios Chani chitahëhuati ibo bo, tihi cabá quëbiniquë: —Jariapari tsi Dios no nicaxëti xo ra, joni bo nomari. ");
INSERT INTO caoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Noba naborëquëba Diós jahuë Jesu bësomayamëquë ra, naa cruzó tsi ma tooxayamëta ca jasca cato. ");
INSERT INTO caoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bësomaxo tsi quiha ja oquëhuayamëquë, jahuë mënëcayá ja ino. Chama jahuë Jesu qui ja ayamëquë Rëquëniniti Ibo, Xabahamati Ibo, tihi cabo iti. ");
INSERT INTO caoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jabi toca xo ra. Jabija ca cahëxo tsi nohiria bo yoa-yoaqui noa ra, paraxoma. Tocahi quiha Espíritu Santo ri. Jasca, jahuë Chani nicacanaibo qui Espíritu Santo aqui Dios ra —nëa tsi quiha ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jatsi quiha catinish ca yosibo caxa-caxaniquë ja yoacani ca nicahax na. Itsisnaniquë jato shinana ra. Jato ja acascani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Jama, jato ó niini quiha huësti ca chama, naa Gamaliel icanai cato. Yoba tiisimanish ca joni ja ini quiha. Jasca, nohiria qui shinajiaxëni ca naa joni ini quiha. Yosibo bësojó niixo tsi quiha naquëtë cacha Chani chitahëhuati Ibo bo ja raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Raahax chanitsijaniquë: —Jisa, Israél ca joni bá. Quiniacaxëcahuë, anoma ca naa joni bo qui ma ayamano. ");
INSERT INTO caoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tobi ini quiha Teudas icanai cato. Joni-joniria ja ini ca ja quëscahuani quiha ra. Jasca, ja bëta cuatrocientos ca joni bo riini quiha nianaxëna. Toa joni acacaniquë ra. Jatsi pacanamahacani quiha jahuë rabëti bo tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jaquirëquë tobi iniquë Galileá ca Judas. Nohiria censo ini cató tsi toa joni jisiquini quiha. Joni bo misco ja mëpini quiha jaa ri. Jama, toa joni acacaniquë jaa ri. Jabayoni quiha jahuë rabëti bo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Jatsi noho yoba tsi xo naa: Naa joni bo no motsayamano. Jato paquëmacana iquia. Jato chama yoí pi ja chanicano tsi quëyohacaxëhi quiha ja acaina iquia. Pacanaxëhi quiha jato rabëti bo ri. ");
INSERT INTO caoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Jama, Dios yonoco pi ja acano tsi yama tsi xo toa jato yonoco quëyoti mëtsa cato ra. Jatsi quiniacaxëcahuë, Dios yoi pasomaha iquinahi ma imitsa iqui na —nëa tsi yosibo qui Gamaliel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jatsi quiha yosibo qui jia quiha jahuë yoba iniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jatsi Dios Chani chitahëhuati ibo bo jahari ja quënacaniquë. Quënaxo tsi quiha jato ja rashacaniquë. Jatsi quiha jato ja yobaniquë, Jesu janë́ tsi ja chaniyamacano. Yobaxo tsi quiha jato ja paquëmacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jatsi quiha jatiroha ca barí tsi arati xobo xo tsi Xabahamati Ibo Jesu iqui ca ja yoa-yoacaniquë. Jasca, chahahuacanaiba xobo xo tsi tiisimatsijahuacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Toatiyá tsi chahahuacanaiba maxo anino tsi quiha jodioba joi chanicanaibo qui carayana ca joi chanihai ca jodiobá joi mëraniquë. —Piti biyamahi quiha noba bënë imanish ca yoxa bo rë, barihaní tsi piti ja acaquë no —nëa tsi quiha jato jimibo qui ja nëcacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Jatsi quiha chahahuacanaibo tëquë Dios Chani chitahëhuati ibo bá quënaniquë ja caticano. —Noqui yoi tsi xo Dios Chani no yoahai ca jënëhaina rë, piti, parata, tihi cabo otoxëna. Anoma quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jatsi siete ca joni shinajiaxëni cabo mëracana, nobë xatë bá, toa ototi yonoco ati. Espíritu Santo rëamë ca joni ja ixëti ca xo. Jasca, tiisi ja jayacaxëti xo. Jato qui naa ototi yonoco mëaxëqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Mëaxo tsi xaba jayaxëqui noa bëhoxti, Dios Chani tiisimati —nëa tsi quiha jato qui Chani chitahëhuati ibo bo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jatsi raniniquë chahahuacanaibo tëquë, nicahax na. Jatsi quiha siete ca joni bo ja bicaniquë ja yoahacacani jascaria. Jatsi Esteban ja bicaniquë, naa Dios qui chitiminish ca Espíritu Santó rëamënish ca joni. Jasca, Felipe, Prócoro, Nicanor, Timón, Parmenas, Antioquía ó ca conish ca Nicolás, naa jodioba jabi binish ca carayana, tihi cabo quiha ja bicaniquë toa yonoco ja otocano. ");
INSERT INTO caoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jatsi quiha Chani chitahëhuati ibo bo bësojó ja janahacacaniquë. Jatsi jato bax ja bëhoxcana ca tsi jato mëquë jato ó ja janacaniquë shomahuaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Toatiyá tsi quiha Dios Chani pacananiquë. Ani-aniniquë Jerusalén ca chahahuacanaibo. Jasca, Cristo qui chitiminiquë huëstima ca jodioba arati ibo bo ri ra. ");
INSERT INTO caoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Toatiyá tsi quiha chamaxëniria ca jisti bo Estebán aqui iniquë nohiria xërëquë xo na. Diós toa joni shomahuariani quiha, jahuë yonoco ja aquë no. Jasca, Espíritu Santo chama jayani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jama, ja qui caxa iniquë catiti xobó ca nohiria bo, naa Paquëmahacanish ca Yonati bo icanai ca maxo. Esteban qui tsi quiha joi mëratsijahuacaniquë. Jasca, jato maxo qui riiniquë jodiobo huëtsa bo ri, naa Cirene, Alejandría, Cilicia, Asia, tihi cabo mai ax bëcanish cabo. Esteban qui caxa ja icani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Jabi Esteban qui joi ja mëracano tsi quiha Espíritu Santo tiisí tsi jato ja quëbiniquë. Esteban bëbotimaxëni ja icani quiha, ja quëbihai ca iqui na. ");
INSERT INTO caoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Jatsi quiha parata joni bo qui ja acaniquë quiahuamaxëna. Acax tsi quiha, —“Moisés yamabo, Dios, tihi cabo pasomaha chanihi quiha Esteban ra. No nicaquë ra. Anoma quiha” tihi ca tsi icana —i joni bo qui jaca niquë pë. ");
INSERT INTO caoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jatsi ja quiacaniquë Esteban qui nohiria bo caxahuaxëna. Jatsi quiha itsisnaniquë nohiria bo, yosibo, Dios yoba tiisimacanaibo tëquëta. Caxahi tsi quiha Esteban qui ja tsamicaniquë. Ratëniquë Esteban. Tsamixo tsi quiha jodioba chama bo qui ja boniquë ja qui quësoxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jatsi quiha chama bo qui chanitsi quiha quiacanaibo niquë. —Noba arati xobo, Moisés yoba, tihi cabo pasomaha chanihi quiha naa joni ra. Anoma tsi xo toa ja chani-chanihaina ra. ");
INSERT INTO caoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Jasca, “Noba arati xobo potasxëhi quiha naa Nazarét ca Jesu” ii quiha pë. Jasca, “Noqui Moisés yamabá ani ca jabi bo rarinamaxëhi quiha ra” tihi ca tsi ii quiha ra. No nicahitaquë ra —i quiha jaca niquë quiahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Jatsi quiha toá ca naquëtë ca tsahonish ca chama bá Esteban bëisniquë. Bëis-xo tsi quiha ángel bëmana jisiria ca jahuë bëmana manëhai ca ja jiscaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Jatsi quiha arati ibo-iboriá Esteban nicaniquë: —¿Jabija ni naa mi qui ja quësocanaina? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jatsi Estebán quëbiniquë: —Ea nicaparicana, ëbë xatë bá, noho jahëpa bá. Mesopotamia maí tsi Abraham yamabo racano tsi quiha noba oquë-oquëria ca Dios ja qui jisiquiniquë ra, naa Harán racahi ja canox pari no. ");
INSERT INTO caoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Toatiyá tsi quiha, “Mi mai, mi jimibo, tihi cabo jisbëriana. Mai huëtsa, naa mi qui ë jismaxëhai ca mai qui cata” i ja qui noba Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jaha tsi quiha Abraham riquiniquë Caldea mai ax na. Riquicaya tsi quiha Harán mai icanai ca qui ja caniquë racahi na. Jatsi Abraham jahëpa rësoniquë. Ja rësoquë tsi quiha nëri naa mai qui, naa ma racahai ca qui Diós raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Raaxo tsi quiha naa mai yoi ja qui Diós ayamaniquë ibohuati. Mai mishni roha ca ja qui acacayamani quiha toatiyá no. Jama, “Mia, mi chahitaxocobo, tihi cabo qui naa mai axëquia, ibohuati” i ja qui Dios ni quiha, baquë Abrahám jayanox pari no. ");
INSERT INTO caoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Jasca, “Naa mai niabayacaxëcani quiha mi chahitaxocobo carayanaba maí tsi racaxëna. Toá tsi carayanaba yonati bo icaxëcani quiha mi chahitaxocobo. Cuatrocientos ca año no tsi jato yosicaxëcani quiha toa carayanabo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jasca, toa carayanabo copixëquia, naa jato yonamisxëniria cabo. Jaquirëquë toa carayanaba mai jisbayacaxëcani quiha mi chahitaxocobo naa mai ó tsi ë qui araxëna” nëa tsi noba Abraham yamabo qui Dios nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Jatsi quiha Abraham yamabo qui jabi paxa ca, naa jibirishati jabi Diós aniquë, ja parayamahai ca jismaxëna. Jatsi quiha Abraham yamabá jahuë baquë Isaac jibirishaniquë, huësti ca semana ja jayaniquë no. Jasca, Isaac yamabá jahuë baquë Jacob jibirishaniquë jaa ri. Jaquirëquë Jacob yamabá jahuë doce ca baquë bo ri jibirishaniquë ja cocaquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","‘Jabi Jacob doce ca baquë bo noba naborëquëbo ini quiha. Jatsi quiha jato noma José qui noba naborëquëbo yosananiquë. Yosanaxo tsi quiha carayana ca comerciante bo qui jato noma ja iniacaniquë, Egipto mai qui ja bocano. Toá tsi quiha yonati José iniquë rë. Jatsi, ja bëta Dios ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Toá tsi José tënë-tënëni quiha. Jatsi Diós José mëbirianiquë. Tiisi ja qui ja ani quiha. Jatsi José tiisi Faraón jisniquë, naa Egipto chama-chamaria. Jisi tsi quiha jahuë mai tëquë, jahuë xobó cabo, tihi cabo José qui ja mëaniquë otojahuano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","‘Toatiyá tsi quiha Egipto, Canaán, tihi ca maí ca nohiria bá tënë-tënëniquë. Piti ja biniacani quiha. Jasca, binianiquë José rëquëmë bo ri, naa noba naborëquëbo. Yama ja jayacani quiha piti. ");
INSERT INTO caoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jatsi Egipto ó ca piti ini ca nicaxo tsi quiha jahuë baquë bo Jacob yamabá raaniquë, Egipto mai qui ja shishocano. Toa xo tsi quiha trigo ja copicaniquë piti. ");
INSERT INTO caoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jaquirëquë jahuë rëquëmë bo biniatëquëniquë. Biniahax Egipto qui ja bacatëquëcaniquë. Toatiyá tsi quiha “Mato noma xo ëa ra” i jato qui José ni quiha. Jasca, Faraón qui jahuë rëquëmë bo ja boniquë cahëmaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jaquirëquë quiha jahuë jahëpa qui chani José raaniquë Egipto mai qui ja jono. Jatsi quiha ja bëyocaniquë Jacób-nabo tëquëta, naa setenta y cinco ca nohiria. ");
INSERT INTO caoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Egipto mai qui cahëhax toá tsi ja racacaniquë. Jasca, toá tsi ja rësoyocaniquë, naa Jacob, noba naborëquëbo. ");
INSERT INTO caoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jatsi xëni huëtsa quiha Jacob xao bo, noba naborëquëba xao bo, tihi cabo jahari ja bëcaniquë Canaán mai qui. Toá tsi quiha, naa Siquem icanai cato ax tsi quiha ja maihuahacaniquë. Jabi toa Siquem ó ca maihuati mai noba Abraham yamabá copini quiha Hamor icanai ca baquë bo quima. ");
INSERT INTO caoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","‘Jatsi quiha cuatrocientos ca año bo, naa Abraham yamabo qui Diós yoani ca chani jatipaimano tsi quiha noba jimibo ani-aniniquë. Huëstima tsi ja icani quiha Egipto maí no. ");
INSERT INTO caoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jasca, toatiyá tsi quiha noba jimibo yonatsi Egipto chama huëtsá huaniquë. José-nabo jaca nori ca ja cahëyamani quiha rë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Jasca, noba jimibo qui caxa ja ini quiha. Caxaxo tsi quiha jato ja para-paraniquë. Jasca, jato cobëna ca baquë bo ja niabëriama-niquë rë, jato rësomacatsi na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Toatiyá tsi quiha noba Moisés coniquë ra. Jiaria ca baquë ja ini quiha. Toa baquë Diós shomahuaniquë. Tres oxë no tsi quiha ja shinahamahacaniquë jahuë xobó no. ");
INSERT INTO caoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jatsi quiha xobo cacha ja jonëcaniquë Faraón qui raquëquí na. Jatsi Faraón jahiní jisniquë. Jisi tsi quiha Moisés pistia jahuë xobo qui ja boniquë shinahamaxëna. Jahuë baquë jascaria tsi ja shinahamahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jatsi quiha Egipto tiisi, jato jabi bo, tihi cabo Moisés tiisimahacaniquë. Toca tsi quiha joni-joniria ja manëniquë. Oquënaniquë jahuë chani, ja acai ca tëquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","‘Cuarenta año bo jayaxo tsi quiha jahuë jimibo Moisés jiscasniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Jato tsaya-tsayaquí tsi quiha noitiria ca rashahacahai ca joni, naa jahuë jimibo ja jisniquë. Jatsi jabë xatë ja mëbicasniquë. Jatsi quiha toa rashahai ca Egipto ca carayana Moisés tëpasniquë copixëna. ");
INSERT INTO caoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Tëpasxo tsi quiha jato rëquëniniti ibo iti ó ja pasoniquë, toa mai quima ax jato tsëcaxëna. “Diós raani ca joni tsi xo naa ra noqui mëbiti” i jaca ti ó ja pasoni quiha. Jabi Moisés ja bicasyama-caniquë jato rëquëniniti ibo iti. ");
INSERT INTO caoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Jatsi huëaquë dos ca jimibo iquinahai ca Moisés jisniquë. Jato rabënamacatsi tsi “¿Jëniriahax iquinacanai rë? Mabë xatë bo xo mato ra” i jato qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jatsi quiha joni huëtsa yosihai ca joní Moises shitijihaniquë. Shitijihacax tsi “¿Noba chama ni mia pa? ¿Tsohuëcaracá mi qui chama aca pa, noqui yobati? ");
INSERT INTO caoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tonia ëa acasqui mia ra, naa Egipto mi aquitaha jascaria” i Moisés qui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jatsi Moisés raquëniquë nicahax na. Raquëhax tsi quiha Madián mai qui ja jabaniquë. Toá tsi ja racaniquë carayanabo ya. Ahui bichi tsi dos ca baquë bo ja saihuaniquë toa xo na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","‘Jaquirëquë cuarenta año bo huinocaquë tsi quiha Moisés qui ángel jisiquiniquë, mëshohai ca pëtoro ó no. Sinaí xabacha tahë tsi Moisés ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Chihi jisi tsi quiha ja ratëniquë, “¿Jahuë ni naa sa?” iquiina. Jatsi pëtoro qui ja basimaniquë tsayaxëna. Basimaxo tsi quiha Iboba joi ja nicaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Mi naborëquëba Dios xo ëa ra. Abraham, Isaac, Jacob, tihi caba Dios xo ëa ra” i ja qui Dios ni quiha. Jatsi mëmë-mëmëniquë Moisés raquëhi na. Pëtoro qui ja tsayacasyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jatsi quiha, “Mi zapato bo tsobohuë. Roa xo naa mai ra, naa mi niihai cato. ");
INSERT INTO caoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Noho Egiptó ca nohiria bá tënëhai ca jisquia ra. Ja ëësicanai ca nicaquia ra. Ja tsi xo toa ë botëquë jato paquëmaxëna. ¿Canomani? Jahari Egipto mai qui mia raaquia ra” i ja qui Ibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","‘Jabi noba jimibá niani ca joni Diós biniquë ra, jato rëquëniniti ibo iti. “¿Noba chama ni mia pa? ¿Tsohuëcaracá mi qui chama aca pa, noqui yobati?” i jaca ni quiha naa joni tsayahax na. Jama, jato qui Moisés raahacaniquë ra jato rëquëniniti ibo iti. Toa pëtoró ca jisiquihai ca angél noba Moisés jahari raaniquë noba jimibo ja xabahamano. ");
INSERT INTO caoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jabi naa jasca ca Moisés noba jimibo mëpiniquë ra Egipto mai quima. Jasca, jisti-jistiria bo ja aniquë ra, Egipto, Ia Shini, Sinaí xabaca, tihi cabo xo na. Cuarenta año no tsi quiha ja tocaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Jasca, “Mato qui jahuë chani yoati ibo huëtsa raaxëhi quiha Dios mato mëbiti. Mato quima tsëquëxëhi quiha naa joni ra” i jahuë jimibo qui Moisés yamabo ni quiha. Toca ca yoanish ca Moisés tsi xo naa ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Jasca, xabachá tsi Dios qui arati noba jimibo catiquë tsi quiha Maca Sinaí ca ángel ya tsi chaniniquë Moisés roha, noba jimibo nomari. Toa xo tsi quiha Dios yoba yoi ja biniquë noqui ati ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","‘Jama, naa Moisés noba jimibá banahuacasyamaniquë pë. Jato qui yoi quiha. Jahari Egipto mai qui ja bacacascaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Jatsi quiha “Dios bo noqui mi ano ra, noba rëquëniniti ibo bo iti. Yama xo Moisés ra. ¿Jahuënia caraca tia?” i Aarón qui jaca ni quiha, Moisés banahuacasyamahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Toatiyá tsi quiha ídolo ja acaniquë pë. Toro baquë jahuë jaria ini quiha. Axo tsi quiha tëpas-hacanish ca yohina bo ja qui ja bëcaniquë pë toa ídolo ranihuaxëna. Jato qui jia ini quiha ja acanina. ");
INSERT INTO caoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","‘Jatsi jato quima Dios casoniquë. Jato noma jabi qui jato ja mëaniquë, oxë, bari, huishtima, tihi cabo qui ja aracano. Jabi ja tocacani ca Dios Chani yoanish cató yoani quiha: “Cuarenta xëni no tsi quiha yohina bo ma tëpasniquë; mahitsa. E qui ja acacayamacaniquë rë, Israél cabá; mato mahitsa ca dios bo qui ja acacani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Jatsi Moloc icanai ca dios qui ma ara-araniquë rë, jahuë arati tapasa mato bëta bohi na. Jasca, Renfán icanai ca huishti qui ma ara-araniquë rë. Tihi ca ídolo bo ma aniquë rë, arati. Ja quëshpi tsi Babilonia mai oquëri mato pacanamaxëquia ra” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","‘Jasca, xabachá racapama tsi quiha arati oxti noba naboyamabá jayapaoniquë. Jabi Moisés jisni ca planes jascaria tsi toa arati oxti acacaniquë, naa Diós Moises yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Toa arati oxti noba naboyamabá jayapaoniquë. Jatsi Moisés quirëquë quiha Josue yaxo tsi noba naboyamabá toa arati oxti bëniquë noba mai qui. Jatsi carayanaba mai quiha noba naborëquëbá biniquë ra. Toa mai ó tsi noba naborëquëbo rëquë bocaquë tsi quiha toa carayanabo Diós jabamaniquë. Jatsi toá tsi huëstima ca xëni no tsi quiha toa arati oxti chitëniquë. David yamabá yonati chitahëhuaquë tsi jari tobi toa arati oxti i-ipaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Toatiyá tsi arati xobo paxa ca David yamabá acasniquë. “Noba Jacob yamaba Dios bax arati xobo acasquia, racati” i ja ni quiha. Jasca, Diós noba David shomahuarianiquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Jama, toa arati xobo David yamabá ayamani quiha, jahuë baquë Salomón ja nori. ");
INSERT INTO caoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Jasca, joni bá acai ca xobó tsi racayoiyamahi quiha Dios ra. Jabi nëcahi quiha Dios ra: ");
INSERT INTO caoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Naipa xo tsi yonaquia; noho tsahoti jascaria xo ra. Mai xo tsi yonaquia; noho tahë iti jascaria xo ra. ¿Jënahuariaxo raca ë bax xobo ma ana ra? Jatiroha ca iti ó xo ëa ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Jasca, ¿noho mëquënë́ tsi jatiroha ca acacayamani?” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","‘Jisa, jonibá. Noba naborëquëbo jascaria xo mato rë. Mahitsa ca dios bo, jabi bo, tihi cabo ja banahuacaniquë. Jishopë, tocaqui mato ri iquia, naa carayanabo jascaria. Mato shina qui jicotimaxëni xo Dios Chani rë. Jasca, Espíritu Santo joi nicacasyamaxo mato jaari ra. ");
INSERT INTO caoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Jisa; ëa yoacana. ¿Jëni ca Dios Chani yoati ibo mato naborëquëbá tënëmayamayamani? Dios Chani yoanish cabo tëquë ja acaniquë iquia. “Joxëhi quiha Mëstëxëni ca Yonati” i jaca quë tsi quiha tihi cabo mato naborëquëbá aniquë rë. Jaboqui tsi naa Mëstëxëni ca ma ayamëquë mato ri ra. Carayanabo qui ma mëayamëquë iquia, ja acacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Jabi tocayamëquë mato, naa Dios yoba binish cabo ra. Jabi angél mato qui ani ca yoba nicayamaqui mato rë —nëa tsi quiha toa chama bo qui Esteban nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Esteban chani nicapama tsi quiha itsisnarianiquë jato shinana. Caxaxëniria ja icani quiha ra. Esteban qui anomaria ini quiha ja caxacanaina. ");
INSERT INTO caoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jama, nai Esteban bëisniquë. Espíritu Santo rëamë ja ini quiha. Bëisquí tsi quiha Dios oquë-oquëria, ja mënëcayá ca nii ca Jesu, tihi cabo ja jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Jisi tsi quiha, —Tsayapa. Japëquëhi quiha naipa ra. Nohiria Baquë, naa Jesucristo jisquia ra. Toá xo ra; Dios mënëcayá tsi nii xo —nëa tsi quiha Esteban nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jatsi quiha jato joi ja choshacaniquë jahuë chani nicacasyamaxo na. Jasca, ja pamapoicaniquë. Joi choshapama tsi quiha ja qui ja jabayocaniquë axëna. ");
INSERT INTO caoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Tsamixo tsi quiha yaca cacha ja xërëcaniquë axëna. Toa xo tsi quiha Esteban ja acaniquë maxaxá no. Jasca, ati ibo bá jato sahuëti bo janani quiha shinapayo tapaí, naa Pablo icanai cato. ");
INSERT INTO caoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tsobocoxo tsi quiha Esteban qui maxax bo ja niacaniquë. Rësopama tsi quiha Esteban bëhoxniquë: —Noho shina bihuë, Ibo Jesú —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jatsi quiha ja mëniniquë. Mënihax, —Jato jocha shina-bënohuë, Ibobá —iriatsi ja niquë. Jatsi ja naniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Jabi toá tsi quiha Pablo ini quiha. Ja qui jia ini quiha ja acanaina. Toa barí tsi quiha Jerusalén ca chahahuacanaibo tënëmati nohiria chama bá chitahëhuaniquë pë. Jatsi pacanamahacayoniquë chahahuacanaibo tëquë. Jodioba maí ca departamento huëtsa bo, Samaria mai, tihi cabo qui ja jabayocani quiha. Jerusalén tsi chitëniquë Chani chitahëhuati ibo bo roha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jatsi quiha Dios noixëni ca joni bá Esteban maihuaniquë. Maihuahax ja ara-araconacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jatsi chahahuacanaibo quëyotsi Pabló huaniquë. Quëyopama tsi quiha xobo, xobo huëtsa, xobo huëtsa, tihi cabo qui Pablo jiconiquë chahahuacanaibo tsëcaxëna. Tsëcaxo tsi quiha preso qui jato ja nanëniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jabapama tsi quiha Dios Chani chahahuacanaibá yoabonaniquë. Jatiroha ca iti xo tsi ja yoacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Toatiyá tsi quiha Samaria maí ca yaca qui Felipe caniquë. Caxo tsi quiha Xabahamati Ibo Jesu ini ca ja yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Jia tsi quiha jahuë chani ja nicacaniquë. Ja acai ca jisti bo jisi tsi ja yoani ca ja chahahuacaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jatsi jënimahuahacaniquë yoshi jayanish ca huëstima cabo. Tsëquëpama tsi jato joi ja choshacani quiha. Jasca, yora choni jayanish cabo, tapiyamacanaibo, tihi cabo jënimahuahacaniquë jato ri. ");
INSERT INTO caoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Jatsi quiha rani-raniquë toa yacatá ca nohiria bo. ");
INSERT INTO caoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jama tobi quiha Simón icanai ca iniquë toa yacatá no, naa yobë i-ipaonish cato. Ja ani cató tsi quiha Samariá ca nohiria bo ratë-ratëniquë. Jasca, jamë shinamisxëniria ca joni ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Jasca, ja qui chama bo, nohiria bo, tihi ca nohiria tëquëtá chahahuapaoni quiha. —Anomaria tsi xo naa joni chama ra. Tonia Dios chama jaya xo ra —i nohiria bo paoniquë ja yoati na. ");
INSERT INTO caoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yobë ja ini iqui tsi nohiria bá chahahuapaoniquë. Naama tsi ja qui ja nicacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Jama, Dios Chani Felipé yoaquë tsi quiha ja quima Dios quiri ja bësocaniquë. Diós nohiria bo otocatsaina, Xabahamati Ibo Jesu iquiina, tihi cabo Felipé yoa-yoaniquë. Jatsi chahahuahax tsi quiha toa nohiria ashimahacaniquë, naa joni bo, yoxa bo, tihi cabo tëquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Jatsi quiha Jesu qui chitiminiquë Simón ri. Ja ashimahacaniquë jaa ri. Ashimahacaxo tsi quiha Felipe ja banahuaniquë. Ja ratë-ratëniquë acacanish ca jistiria bo jisi na. ");
INSERT INTO caoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jatsi quiha Samariá ca nohiria bá Dios Chani chahahuani nori ca Jerusalén ca Dios Chani yoati ibo bá nicaniquë. Nicaxo tsi quiha Pedro, Juan, tihi cabo ja raacaniquë ja tsayacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samaria mai qui cahëhax chahahuacanaibo bax ja bëhoxcaniquë, Espíritu Santo ja bicano. ");
INSERT INTO caoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jari jato qui Espíritu Santo botëyamani quiha. Ibo Jesu janë́ roha tsi ja ashimahacacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jatsi quiha nohiria ó tsi jato mëquë Pedro, Juan, tihi cabá jananiquë. Jatsi Espíritu Santo ja bicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Dios Chani yoati ibo bá jato mëquë nohiria ó janahai cató tsi Espíritu Santo acacani nori ca Simón jisniquë. Jisi tsi quiha Pedro, Juan, tihi cabo qui parata ja acasniquë toca ca chama bixëna. ");
INSERT INTO caoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","—Toca ca chama ë qui ri acana. Espíritu Santo nohiria bá bino ra, noho mëquë jato ó ë janahai cató no —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jatsi Pedró quëbiniquë: —Mi parata ya tënëtiya qui cata. ¿Jënahuariaxo raca Diós acai ca chama paratá tsi copiti mi jascahuana? ");
INSERT INTO caoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","No bëta yonoconabëquitimaxëni xo mia ra, Dios basi mi shinahai ca nori iqui na. Anoma quiha. Jatsi ");
INSERT INTO caoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","mi shinahai ca yoi ca quima casohuë. Mëri tsi Dios qui bëhoxhuë, mi shinahai ca yoi ca ja masano ra. ");
INSERT INTO caoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yosaria ca mi nori ca jisquia ra. Mia yonahi quiha mi shina ó ca jocha ra —nëa tsi Simón qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Jatsi Simón raquëniquë. Raquëhax, —E bax bëhoxcana ra, naa mi yoaha ca Diós ëa copiyamano —i Simón niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jatsi toa yacata xo tsi Iboba Chani yoahax Jerusalén qui ja bacacaniquë. Bacapama tsi quiha huëstima ca Samariá ca yaca bo xo tsi Dios Chani ja yoabonacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Jatsi quiha Felipe qui Ibobá raani ca ángel chaniniquë: —Niihuë. Sur quinia tsi cata. Toá xo Jerusalén quima Gaza quinia ca bahi ra —iquiina. Xabachá ca nacohai ca bahi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jatsi quiha Felipe caniquë. Bahi qui cahëxo tsi quiha Etiopía maí ca carayana ja jisniquë. Jahari bahí tsi cohi ja ini quiha. Jabi chama naa joni ini quiha, naa jahuë país ca parata obësoti ibo-iboria. Jahuë país ca yoxa chama bax ja yonoconi quiha, naa Candace icanai cato. Jabi Jerusalén qui naa joni caniquë arahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jatsi quiha jahuë mai qui bacapama tsi quiha Dios papi tsayahi ja iniquë; caritá tsi tsaho. Dios Chani yoati ibo Isaías yamabá quënëni ca tsayahi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jatsi quiha Espíritu Santo Felipe qui chaniniquë: —Cata. Toa johai ca carita mi bëchano —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Jatsi Felipe carita jisi caniquë. Capama tsi quiha joni joi ja nicaniquë. Isaiás quënëni ca tsayahi ja ini quiha, joi bëro cató no. —¿Japa mi tsayahai ca cahëhai? —i joni qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jatsi joní quëbiniquë: —¿Jënahuariaxo raca ë cahëna rë? Yama tsi xo toa ë qui naa chani bërohuahaina rë —iquiina. Jatsi Felipe qui joi ja amaniquë ja bëta ja tsahono. ");
INSERT INTO caoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Jabi ja tsayani ca tsi xo naa: “Namëhacati ja mëpihacaquë ra, oveja jascaria. Namëjahuacano tsi quiha ja pasiquë, naa oveja jascaria jahuë rani maxcohacaquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ja bërabihuahacaquë ra. Ja qui chama bá nicayamaquë rë. Yoanoma tsi xo toa ja bëta bësobëquicanaibá acana ra. Mëri tsi naa joni acacaquë ra” i ja tsayani ca ni quiha, naa Dios papi ó cato. ");
INSERT INTO caoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Jatsi chamá Felipe nicaniquë: —Ea mëbihuë. ¿Tsohuë yoati tsi chanihi ni Isaías sa? ¿Jamë yoati ni? ¿Joni huëtsa yoati ni? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jatsi quiha ja tsayahai ca nori ca bërohuati Felipé chitahëhuaniquë. Toa chani bërohuapama tsi quiha Jesu yoati chani jia ca ja yoaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Bahí tsi copama tsi quiha jënë toro pistia ca qui ja cahëcaniquë. Cahëhax, —Tsayapa. Toá xo jënë ra. ¿E ashimahacati ma ni? —i Felipe qui chama niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Jatsi, —Jesu qui pi mi chitimiyoino tsi ¿ai canomani? —i Felipe niquë. Jatsi chamá quëbiniquë: —Jaahuë. Dios Baquë yoi ca Jesu nori ca chahahuaquia ra —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jatsi jahuë carita ja mënimahaca tsi jënë qui ja bocaniquë. Toa xo tsi quiha Felipé chama ashimaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jatsi tëmahinajacano tsi quiha Espíritu Santó Felipe mëbitapiniquë. Jistëquëyamani quiha Etiopiá ca chama. Jatsi chama rëtsaminiquë jahuë mai qui. Rani tsi ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jatsi Azoto yacatá tsi Felipe jisiquitapiniquë pa. Toa xo tsi quiha Dios Chani ja yoaniquë. Yoaxo riquiquiria tsi quiha Dios Chani ja yoabonaniquë Cesarea qui caquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Toatiyá tsi quiha chahahuacanaibo Pabló quëyocasniquë. Anomaria ini quiha jato ja roahaina. Quëyocatsi tsi jodioba arati ibo bo qui ja caniquë, ja shinahai ca yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Caxo tsi quiha carta bo, naa Damasco yacatá ca chama bo qui joihuati carta ja baaniquë. Jabi Damascó ca chahahuacanaibo tëquë, naa joni bo, yoxa bo tëquë, tihi cabo qui ja tsamicasni quiha, jahari Jerusalén qui boxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jatsi Damasco yaca qui basimajano tsi quiha ja qui mana ca huëa-huëaria ja qui huahuatapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Mai qui paquëxo tsi quiha ja qui chanihai ca joi Pabló nicaniquë. —Jisa Pabló. ¿Jënixo tsi noho rabëti bo tënëma-tënëmahai rë? —i ja qui joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jatsi, —¿Tsohuë ni mia, Ibobá? —i Pablo niquë. Jatsi, —Jesu xo ëa ra. Noho rabëti bo tënëmaqui mia rë. Niitsina. Yaca qui mi jicono ra. ");
INSERT INTO caoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Toa ax tsi mi qui yoahacaxëti xo toa mi axëti cato —i ja qui joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jabi toa joi nicacaniquë Pablo banahuahai ca joni bo ri. Nicahax ja shina-risiquicaniquë. Yama ca ja jiscani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jatsi quiha Pablo joiniquë. Niihax ja bëpëquëniquë. Bëco quiha ja iniquë ra. Ja taisyamani quiha. Jatsi quiha Damasco yaca qui Pablo ja mëpicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Jatsi tres bari tsi quiha ja taisyamaniquë. Jasca, piti, jënë, tihi cabo ja ayamaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jabi Damasco yacatá tsi racaniquë Ananías icanai cato; naa Ibo qui chitiminish ca joni. Naa joni qui noba Ibo jisiquiniquë ja tënamëhai cató no. Jisiquihax, —Ananiás —i ja qui Ibo niquë. Jatsi, —Nëá xo ëa, Ibobá —i ja qui Ananías niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Jatsi, —Mëstëxëni icanai ca bahi qui catá. Toá xo xobo ra. Jahuë ibo tsi xo Judas. Jahá chitëhi quiha Pablo, naa Tarsó racapaonish cato. Jaha xo tsi nicahuë. Jaboqui bëhoxhi quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Jasca, ja tënamëhai cató tsi mia ja jisquë ra. Jahuë naquëtë qui mi jicohaina, mi mëquënë́ tsi jahuë bëro mi motsahaina taismaxëna, tihi ca tsi ja jisquë tënamëquí na —nëa tsi quiha Ibo nëcaniquë Pablo yoati na. ");
INSERT INTO caoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jatsi Ananiás quëbiniquë: —Jishopë, Ibobá. Huëstima ca nohiria bá ëa yobayamëquë naa joni yoati na. “Jerusalén ca chahahuacanaibo tënëmahi quiha” icani quiha ra. Anoma xo naa joni iquia. ");
INSERT INTO caoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Jasca, nëri ja johitaquë rë noqui, naa mi qui chitimicanaibo qui tsamixëna. Carta jaya quiha arati ibo ba chama bo jismati. Preso qui noqui bocatsi quiha iquia —i Ibo qui Ananías niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Jama, Ibo nëcaniquë: —Cata. Toa joni ë biniquë, carayanabo, país ca chama bo, jodiobo, tihi cabo qui noho Chani ja bono. ");
INSERT INTO caoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Jasca, noho janë iqui tsi ja tënë-tënëxëhai ca ja qui jismaxëquia —i Ananías qui Ibo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jatsi quiha Pablo mërahi Ananías caniquë. Jahuë xobo qui jicoxo tsi quiha Pablo ó tsi jahuë mëquë ja jananiquë. Janahax, —Jisa, ëbë xatë Pabló. Ibo Jesú ëa raaquë, naa bahí tsi mi qui jisiquihitahax ca jasca cato. Ea ja raaquë ra, mi taistëquëno, Espíritu Santo mi rëahacano iquish na —nëa tsi quiha Pablo qui Ananías nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Jatsi quiha Pablo taistapiniquë ra. Jahuëcaraca, naa sani tsapa jascaria ca jahuë bëro quima ririquiniquë. Jatsi jënima quiha jahuë bëro iniquë. Jatsi Pablo joiniquë. Jasca, ja ashimahacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jatsi ja oriquiniquë. Oriquihax ja chamaniquë. Jatsi quiha toa Damascó ca chahahuacanaibo ya ja chitëniquë ichariama ca barí no. ");
INSERT INTO caoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Chahahuaxo tsi quiha jodioba catiti xobo bo xo tsi Dios Chani yoati Pablo chitahëhuaniquë. Yoahi tsi, —Dios Baquë yoi xo Jesu ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Jatsi ratëyocaniquë jahuë chani nicanish cabo. —Jia ma. ¿Jerusalén ca Jesu qui chitiminish cabo tënëmapaonish ca ma ni naa sa? ¿Nëá ca chahahuacanaibo qui tsamihi ja joyamayamahitaha? ¿Jerusalén ca arati iboba chama bo qui ja bocasyamayamahitaha? —nëa tsi quiha nohiria bo nëcaniquë jahuë chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jama, raquëxoma tsi quiha Dios Chani Pabló yoa-yoaniquë. Cristo, naa jato Xabahamati Ibo Jesu iqui ca jato ja jismani quiha. Jama, toa Damascó ca jodiobá jahuë chani chahahuayoicasyamaniquë rë. Pablo chani quëbitimaxëni ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jatsi quiha jodioba chama bá Pablo acasniquë huëstima ca bari quirëquë. Ati planes ja acani quiha shinaxo na. ");
INSERT INTO caoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jama, ja acascanai ca Pabló nicaniquë. Jatsi ja quinia-quinianiquë. Jatiroha ca bari, jatiroha ca baquicha, tihi cató tsi quiha yacatá ca caiti bo ó ja bësocaniquë axëna. ");
INSERT INTO caoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jama, quinia huëtsá tsi quiha Pablo paxaniquë ra. Baquichá tsi quiha yacatá ca panë xo tsi Pablo chahahuacanaibá botëmaniquë mai qui. Cacanó tsi ja botëni quiha. Toca tsi quiha Pablo paxaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jatsi Jerusalén qui cahëhax tsi quiha Jerusalén ca chahahuacanaibo qui Pablo riicasniquë. Jama, ja qui ja raquëcaniquë. Chahahuahai ca ja iqui ca ja quëscahuayamacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Jatsi quiha Bernabé Pablo mëbiniquë. Chani chitahëhuati ibo-iboria bo qui Pablo ja boni quiha. Boxo tsi quiha Pablo qui ocapijani ca jato qui ja yoaniquë. Yoaquí tsi quiha Damasco quinia ca bahí tsi ja qui Ibo jisiquinina, ja qui Ibo chaninina, Damasco xo tsi Ibo Chani ja yoanina, tihi cabo jato qui ja bërohuaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jatsi quiha Chani chitahëhuati ibo bo ya Pablo co-coniquë. Jasca, toa xo tsi Iboba Chani ja yoa-yoaniquë raquëxoma. ");
INSERT INTO caoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Jama, ja bëta joi mëraniquë carayanaba joi chanihai ca jodiobo. Jato qui yoi ini quiha ja chanihaina. Ja iqui tsi Pablo ja acascani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jama, ja acascanai ca chahahuacanaibá nicaniquë. Nicaxo tsi quiha Pablo ja mëbicaniquë ja paxano iquish na. Jatsi Cesarea yaca qui ja bocaniquë. Toa xo tsi quiha Tarso yaca qui ja raacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jaquirëquë quiha chahahuacanaibo, naa jodioba maí cabo, Galileá cabo, Samariá cabo, tihi cabo nohiria bá yosiyamaniquë. Jia tsi quiha ja raca-racacani quiha. Jatsi chamananiquë ja chitimicanaina ra. Jasca, Espíritu Santó jato mëbiniquë. Chahahuaniquë huëstima cabo. Jia tsi Iboba yoba ja banahuariacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Toatiyá tsi quiha chahahuacanaibo qui shishohi Pedro caniquë, naa yaca huëtsá ca racacanaibo qui. Jabi Lida icanai ca yaca qui ja cani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Caxo tsi quiha Eneas icanai ca joni ja bëchaniquë toa xo na. Noitiria ca joni ja ini quiha. Ocho año no tsi jahuë oxati raca ja ini quiha. Choni jahuë yora ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Jatsi quiha Pedro ja qui chaniniquë: —Mia jënimahuahi quiha Jesucristo, Eneás. Joihuë. Mi oxati shomahuahuë —i ja qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Jatsi jënimahuahacanish ca Lida, Sarón, tihi ca yacatá ca racacanaibá jisniquë. Jisi tsi quiha Ibo quiri ja bësoyocaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jasca, Jope icanai ca yacatá tsi quiha shinajiaxëni ca yoxa racaniquë. Tabita jahuë janë ini quiha. Jabi Carayanaba joí tsi quiha Dorcas ja quënahacani quiha. Jasca, noitiria cabo mëbihi naa yoxa i-ipaoni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Toatiyá tsi ja rësoniquë iquihax na. Jatsi jahuë rabëti bá jahuë yora ashimahaca tsi quiha mana ca naquëtë ó tsi ja janacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jatsi Lida yacatá tsi Pedro iqui ca ja nicacaniquë. Basima ja ini quiha. Nicaxo tsi quiha dos ca joni bo ja qui ja raacaniquë chani ya, Pedro bicasquí na. Cahëhax, —Mëri tsi Jope qui johuë —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Jatsi jato bëta Pedro caniquë nicahax na. Ja cahëquë tsi quiha mana ca naquëtë qui nohiria bá boniquë. Toá tsi bënë imanish ca yoxa bo mani ini quiha. Arapama tsi quiha Dorcás quëshani ca saco bo, sahuëti bo, tihi cabo Pedro qui ja jismacaniquë. Noitiria cabo bax ja ani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Naquëtë qui jicoxo tsi quiha Pedró nohiria bo raaniquë cacha. Raahax ja mëniniquë bëhox-xëna. Bëhoxhax tsi quiha bësoyama ca yoxa quiri ja bësoniquë. —Tsahohuë, Tabitá —i ja qui ja niquë. Jatsi quiha ja bëpëquëniquë. Pedro jisi tsi quiha ja tsahoniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jatsi Pedró mëhachahaca tsi ja nimaniquë. Jatsi toá ca mani ca chahahuacanaibo, bënë imanish ca yoxa bo, tihi cabo ja quënaniquë. Quënahax, —Nëá xo mato Tabita ra. Bëso xo ra —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Jatsi ocapijani ca Jope yacatá ca nohiria bo nicayoniquë. Jatsi quiha Ibo qui huëstima ca nohiria chitiminiquë. ");
INSERT INTO caoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jatsi naama tsi quiha Jope ó tsi Pedro chitëniquë tiisimahi na. Simón icanai ca joni ya ja chitëni quiha, naa yohina bichi shomahuati ibo ya. ");
INSERT INTO caoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Jabi Cesarea yacatá tsi quiha carayana ca Cornelio racaniquë. Soldado capitán ja ini quiha. Jabi huëstima ca soldado bo ja yonani quiha, naa Italia mai ax bëcanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Jasca, shinajiaxëni ca Dios qui arahai ca joni ja ini quiha. Jasca, Dios qui aracani quiha jahuë ahuini, jahuë xocobo ri. Jasca, noitiria cabo qui parata ja ani quiha. Dios qui ja bëhoxrohani quiha. Tihi tsi ja ani quiha Dios noiquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Toatiyá tsi quiha yata, a las tres tsi bëhoxpama tsi Cornelio tënamëniquë. Jahuë xobo qui jicohai ca ángel ja jisniquë, naa Diós raani ca ángel. Jicohax, —Cornelió —i ja qui ángel niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jatsi ángel Cornelió tais-taisniquë raquëhax na. Jatsi, —¿Jahuë ni, Taitá? —i Cornelio niquë. Jatsi angél quëbiniquë: —Mi bëhoxhaina, noitiria cabo mi mëbihaina, tihi cabo Dios qui jia quiha. Jaboqui mia shinahi quiha Dios. ");
INSERT INTO caoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jaboqui joni bo Jope yaca qui mi raano. Toá xo joni, naa Simón Pedro icanai cato. Bichi ja bocano ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simón ya, naa yohina bichi shomahuati ibo ya racahi quiha; naa ia quëpë ca xobó cato —nëa tsi quiha Cornelio qui ángel nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jatsi quiha ja qui chaninish ca angél jisbayaniquë. Jisbayajahuaquë tsi quiha dos ca yonati bo, huësti ca soldado, naa Dios qui arahai cato, tihi cabo ja quënaniquë, Pedro qui ja bocano. ");
INSERT INTO caoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Quënaxo tsi quiha angél yoaha ca jato qui ja yoaniquë. Yoaxo tsi quiha Jope qui jato ja raaniquë Pedro ja bicano. ");
INSERT INTO caoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Huëaquë tsi quiha, naa matoroco barí tsi quiha Jope basima ja icaniquë. Jasca, matoroco bari tsi quiha xobo cacha Pedro caniquë bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bëhoxpama tsi quiha ja paxnaniquë. Ja oriquicasni quiha. Jari ja bëtë-bëtëcano tsi quiha Pedro tënamëniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jatsi nai japëquëhai ca ja jisniquë. Japëquëjaquë tsi quiha jahuëcara ca, naa raiti jahëhuaxëni ca mai qui botëhai ca ja jisniquë. Jahuë cuatro ca papotó tsi ja botëmani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Jabi jaxara tsi quiha yohina bo, rono bo, isa bo, tihi cabo iniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Jatsi quiha chanihai ca joi Pedró nicaniquë: —Joihuë, Pedró. Tëpashuë. Mi pino ra —i ja qui joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Jama, picasyamaniquë Pedro. —Jishopë, Ibobá. Pinoma xo ra. Noba jabi pasomaha tsi xo toa no pihaina iquia —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Jatsi joi chanitëquëniquë: —“Jënima tsi xo naa piti ra” ii quiha Dios. Jatsi “Pinoma” iyamahuë —i ja qui joi niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Trés tsi joi nëcani quiha. Jatsi nai qui raiti chahita tërohacatapiniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Jatsi quiha Pedro shina-shinaniquë ja jisni ca yoati na. Shinajahuano tsi quiha Cornelió raani ca joni bo jahuë xobo qui cahëniquë. Caiti cacha nii quiha ja icaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Cahëhax, —¿Nëa racahi ni Simón Pedro ra? —i jaca niquë quënahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Nicayamahi quiha Pedro. Ja tënamëhai ca yoati shinahi ja ini quiha. Jatsi ja qui Espíritu Santo chaniniquë: —Jisa. Mia bënahi quiha tres ca joni bo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Joihuë. Jato qui botëtsina. Raquëhaxma tsi jato bëta cata, jato ë raahitaha quëshpi na —i Pedro qui Espíritu Santo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Jatsi quiha joni bo qui Pedro botëniquë. Botëhax, —Pedro xo ëa ra. ¿Jënihax tsi ma bëcana? —i jato qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Jatsi ja quëbicaniquë: —Noqui capitán Cornelió raahitaquë ra. Shinajiaxëni ca Dios qui arahai ca joni quiha. Jasca, jodiobo nohiria bo qui jia quiha. Jabi ja qui ángel chanihitaquë ra. “Pedro qui chani raahuë, mi xobo qui ja jono iquish na” i ja qui ja ita quiha. Johuë. Mi chani nicacatsi quiha —i Pedro qui joni bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Jatsi quiha joni bo qui joi Pedró amaniquë ja bëta baquichá oxati. Jatsi huëaquë tsi baquishmari tsi quiha jato bëta Pedro caniquë. Jasca, bocani quiha Jopé ca chahahuacanaibo rabë cato. ");
INSERT INTO caoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Oxabaya riquibaya tsi huëaquë tsi quiha Cesarea yaca qui ja cahëcaniquë. Jabi Pedro ó Cornelio pasoni quiha. Jaha pasoquí tsi quiha jahuë jimi bo, jahuë rabëti bo, tihi cabo ja catiani quiha, Pedro chani ja nicacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Jatsi jahuë xobo qui Pedro cahëquë tsi quiha ja bësojó tsi Cornelio mëniniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Jama, Pedró joimaniquë. Joimahax, —Niihuë. Joni roha xo ëa ri ra —i ja qui Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Jatsi Cornelio xobo qui Pedro jiconiquë. Jicoxo tsi quiha huëstima ca nohiria mani ca ja jisniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jatsi jato qui Pedró chaniniquë: —Noqui jodioba yoba pasomaha tsi xo toa mato carayanabo ya no rabënabëquihaina ra. Dios qui yoi ë quëscahuani quiha. Jama, yama tsi xo toa yoi cato, jënima xo carayanabo tëquë, tihi cabo ëa Diós jismahitaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ja tsi xo toa carayana ca Cornelió ëa bënaquë tsi ë jotapihitaquë. “Jishopë. Cacasyama xo ëa” i jato qui ë yamahitaquë ra. Jatsi jaboqui mia nicacasquia. ¿Jënixo tsi ëa mi bënaha? —nëa tsi ja qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Jatsi quiha Cornelió quëbiniquë: —Bari huëtsa, naa matoroco bari bëhoxpama tsi ëa bësojó ca niihai ca joni, naa bajra-bajrahai ca sahuëti sahuë ca ë jisitaquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","“Mi bëhoxhaina, noitiria cabo mi mëbihaina, tihi cabo Dios qui jia quiha” i ë qui ja itaha quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jasca, “Jope yaca qui joni bo mi raano. Toá xo joni ra, naa Simón Pedro icanai cato. Bichi ja bocano. Simón ya, naa yohina bichi shomahuati ibo ya racahi quiha; naa ia quëpë ca xobó cato” i ë qui ja itaha quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ja yoaha ca nicaxo tsi bamaxoma tsi joni bo mi qui ë raatapihitaquë mia biti. Noqui jia tsi xo mi johana ra. Jaboqui nëá xo noa, noqui tëquëta, Dios bësojó no. Ibo Dios Chani, naa mi yoaxëti ca nicariacasqui noa ra. Ihuë —nëa tsi Pedro qui Cornelio nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jatsi chaniti Pedró chitahëhuaniquë: —Jabija ca ë cahëyamaniquë rë. Oquë noqui jodiobo iqui ca ë quëscahuani quiha rë. Jama xo ra. Yama tsi xo toa oquë ca nohiria bo Dios qui iquia. Jaharisi ca xo ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Jaboqui nohiria bo tëquë, naa ja qui aracascanaibo, jia ca acanaibo, tihi cabo bichi quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Jabi jodiobo qui pari jahuë Chani Diós raani quiha. Jariapari tsi Dios ya rabënamati Chani jato qui jahuë Jesucristó yoani quiha. Jabi jahuë baquë tsi xo toa jatiroha caba Ibo-iboria, naa jodiobo, carayanabo tëquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","¿Jodioba mai ó tsi ocapijani ca ma nicayamayamani? Jabi jariapari tsi quiha ashimati ibo Juan yamabá Jesu ashimaniquë Galilea xo na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Jatsi quiha jahuë Jesu qui chama Diós aniquë Espíritu Santó no. Toa chamá tsi huëstima ca jia ca jahuë bo Jesú ani quiha. Jasca, yoshi jaya cabo ja jënimahuaniquë. Co-copama tsi quiha jia tsi ja tocaniquë, Dios ja bëta ini iqui na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Jabi naa Jesu ya no bohopaoniquë ra. Jatiroha ca ja anina, naa jodioba mai, Jerusalén, tihi cabo xo ja ayoni ca no jisniquë ra. Jatsi quiha naa Jesu ja acaniquë ra, cruzó tsi tooxacanai cató no. ");
INSERT INTO caoNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Jatsi tres bari tsi ja raaniquë mai xo na. Jaquirëquë jahuë Jesu Diós bësotëquëmaniquë. Bësomaxo tsi quiha jahuë Jesu Diós jismaniquë nohiria bo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jatsi Jesu no jisniquë, naa jahuë rabëti bo. Jisyamahi quiha nohiria tëxë. Jama, noqui, naa ja bëta i-ibëquipaonish cabá jisniquë. Rëquë Diós noqui bini quiha tihi cabo no yoano. Jasca, naa bësotëquëmahacanish ca Jesu ya no oriquiniquë. Ja bëta jënë no aniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jatsi nohiria bo qui jahuë chani yoatí Jesú noqui raaniquë. “Jatiroha ca nohiria bo, naa bësoyama cabo, bëso cabo, tihi cabo copixëquia ja acanai ca quëshpi na. Tocati chama Diós ë qui ani quiha” i noqui Jesu ni quiha. Jasca, naa Chani yoatí no raahacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Jabi Jesu jonox pari no tsi Dios Chani yoati ibo bo chani-chanipaoniquë ja yoati na. “Jahuë chamá tsi masahacaxëhi quiha toa ja qui chitimicanaiba jocha ra” i jaca paoni quiha —nëa tsi Cornelio, jahuë xobó cabo, tihi cabo qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Jari Pedro chanino tsi quiha ja qui nicacanaibo qui Espíritu Santo botëniquë; naa carayanabo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Jatsi Pedro ya bëcanish ca jodiobo ratëniquë, carayanabo qui Espíritu Santo Diós ani ca jisi na. ");
INSERT INTO caoNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Jasca, jamëri ca joi bá tsi Dios ja ocahuahai ca ja nicacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Jatsi Pedró chaniniquë: —¿Tobi ni toa jato ë ashimahai ca jënëmacatsai cato pa? Noqui jodiobo jascariá tsi naa carayanabá Espíritu Santo biquë jato ri ra. ");
INSERT INTO caoNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jatsi Jesucristo janë́ tsi jato ashimaxëquia ra —i jahuë jimibo qui Pedro niquë. Jato ja ashimaquë tsi quiha Pedro ja nicacaniquë tihi ca bari tsi ja chitëno. ");
INSERT INTO caoNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jatsi quiha Dios Chani carayanabá bini ca Dios Chani chitahëhuati ibo bo, jodioba maí ca chahahuacanaibo, tihi cabá nicaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Jatsi Jerusalén qui Pedro bacaquë tsi quiha ja qui jodioba chahahuacanaibo quësoniquë. Quësohax, ");
INSERT INTO caoNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","—¿Jëniriahax carayanabo qui shishohi mi cahitaha rë? ¿Jëniriahax jato bëta tsi mi oriquihitaha? Anoma quiha —i Pedro qui jaca niquë ja qui quësocatsi na. ");
INSERT INTO caoNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Jatsi quiha ja qui ocapijani ca jato qui bërohuati Pedró chitahëhuaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Huësti barí tsi Jope qui shishopama tsi ë tënamëhitaquë bëhoxhi na. Tënamëquí tsi jahuëcara ca, naa raiti jahëhuaxëni ca mai qui botëhai ca ë jisitaquë. Jahuë cuatro ca papotó acha quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","E tsaya-tsayahitaquë ra. Tsayaquí tsi ja xara ca huëstima ca yohina bo, rono bo, isa bo, tihi cabo ë jisitaquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jatsi ë qui chanihai ca joi ë nicahitaquë. “Tëpashuë. Pihuë, Pedró” i ë qui joi itaha quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Jama, ë quëbiniquë: “Jishopë, Ibobá. Anoma ra. Noba jabi pasomaha ca ë piyamapistiarianiquë ra” i ë itaquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Jatsi mana ca joi ë qui chanitëquëhitaquë pa. “‘Jënima tsi xo naa piti ra’ ii quiha Dios ra. ‘Pinoma’ iyamahuë” i ë qui joi ita quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tres tsi quiha ja ocaniquë ra. Jaquirëquë mana ja tërohacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","‘Toatiyá tsi quiha noho racahai ca xobo qui tres ca joni cahëhitaquë. Cesarea yaca quima ja raahacacahitaha quiha ëa biti. ");
INSERT INTO caoNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Jatsi quiha “Raquëhaxma tsi jato bëta cata” i ë qui Espíritu Santo itaha quiha. Jatsi ë cahitaquë. Jasca, ëa chimatihitaquë seis ca xatë bo ri. Jatsi carayana ca Cornelio xobo qui no jicohitaquë, naa noqui tëquëta. ");
INSERT INTO caoNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Jatsi quiha jahuë xobó ca niihai ca ángel ja jisi ca yoati noqui ja yoahitaquë. “Jope yaca qui joni bo raahuë Pedro biti. ");
INSERT INTO caoNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Mato qui chani yoaxëhi quiha, mia, mí-nabo, tihi cabo xabahamati” i ja qui ángel itaha quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Jicoxo tsi quiha Dios Chani yoatí ë chitahëhuahitaquë. Jatsi naa carayanabo qui Espíritu Santo botëniquë, naa noqui ja botëni jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jatsi Ibo Jesú noqui yoani ca ë shinahitaquë: “Jënë́ tsi ashimahi quiha ashimati ibo Juan. Jama, Espíritu Santó tsi ashimahacaxëqui mato ra” i noqui ja ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Jatsi jato qui Espíritu Santo Diós aca nori ca ë cahëhitaquë ra, naa noqui ja ani jascaria, naa noba Ibo Jesucristo qui no chitiminiquë no. Jatsi ¿jënahuariaxo raca Diós acai ca ë jënëna? —nëa tsi quiha Jerusalén ca yosibo qui Pedro nëcaniquë carayanabá chahahuacanai ca yoati na. ");
INSERT INTO caoNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Jatsi Pedró yoaha ca nicahax tsi quiha ja rani-ranicaniquë. Jënëni quiha ja qui ja quësocanaina. —Carayanabo xabahamacatsi quiha Dios ra. Jato bësomacatsi quiha pa —i jaca niquë Dios ocahuahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Esteban axo tsi quiha chahahuacanaibo huëtsa ri yositsi nohiria bá huaniquë. Ja iqui tsi nëama ja jabacaniquë. Fenicia mai, Chipre mai, Antioquía yacata, tihi cabo qui ja jabacaniquë. Toa xo tsi quiha jato jimibo qui, naa jodiobo qui roha Dios Chani ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Jasca, toatiyá tsi quiha Antioquía yaca qui huësti huësti ca chahahuahai ca jodiobo bocaniquë, carayanabo qui Ibo Jesu Chani jia ca yoaxëna. Carayanaba mai, naa Chipre, Cirene, tihi cató ca racahai ca jodiobo bocani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Jia tsi Ibobá jato mëbini quiha. Jatsi quiha huëstima ca carayanabá chahahuaniquë. Ibo quiri ja bësocani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jabi Ibo quiri carayanabo bësoni ca nicaxo tsi quiha jato qui Bernabé Jerusalén ca iglesiá raaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Cahëxo tsi quiha Diós toá ca carayanabo xabahamani ca ja jisniquë. Jatsi quiha ja raniniquë. Jasca, jia tsi jato ja yobaniquë, Ibo quima ja casoyamacano iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Jabi shinajiaxëni ca joni Bernabé ini quiha. Espíritu Santo rëamë ja ini quiha. Jasca, chamaxëni Ibo qui ja chitimihai ca ini quiha. Ja iqui tsi huëstima ca carayanabo Ibo quiri bësoniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Jaquirëquë riquicaya tsi Tarso yaca qui Bernabé caniquë, Pablo mëraxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Jatsi Pablo ja jisniquë. Jaquirëquë quiha Pablo ja bëniquë jahari Antioquía qui. Jatsi toa xo tsi quiha huësti ca año ja raacaniquë chahahuahai ca carayanabo ya. Huëstima ca nohiria bo tiisimahi ja icani quiha. Jabi Antioquiá pari tsi “Cristiano bo” chahahuacanaibo quënahacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Jasca, toatiyá tsi quiha Jerusalén ax huësti huësti ca Dios Chani yoati ibo bo bëcaniquë Antioquía qui. ");
INSERT INTO caoNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jabi jato maxo ó tsi huësti ca joni, naa Agabo icanai ca ini quiha. Cahëhax iglesiá tsi Agabo niiniquë chahahuacanaibo yobaxëna. —Basima tsi xo nohiria bá piti biniatiya iquia ra. Paxnacaxëcani quiha naa carayanaba mai tëquë ó ca nohiria bo rë —i jato qui ja niquë. Jabi ocapijani quiha, carayana ca chama Claudió yonaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jatsi jodioba maí ca chahahuacanaibá tënë-tënëniquë biniaquí na. Jatsi quiha Antioquiá ca chahahuacanaibá ofrenda raaniquë jato mëbicasquí na. Parata ati tiisi jayaquí tsi jato qui ja acani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ofrenda catiaxo tsi quiha Bernabé, Pablo, tihi cabo qui ja acaniquë Jerusalén ca yosibo qui ja bocano. ");
INSERT INTO caoNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Toatiyá tsi quiha chahahuacanaibo tënëmatsi chama Herodés huaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Jariapari tsi quiha Jacobo, naa Juan rëquëmë ja tëpasniquë saipí no. ");
INSERT INTO caoNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Jaha tsi shina-raniniquë jodiobo ra. Ja rani-ranicanai ca jisi tsi Pedro qui ja tsaminiquë jaa ri. Jabi ocapijani quiha jodioba fiestá no, naa levadura yama ca mapari ja picaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Tsamixo tsi quiha preso qui Pedro ja nanëniquë. Nanëxo tsi quiha huëstima ca soldado bo ja jananiquë Pedro ó bësoti. Cuatro ca maxo bo ja janani quiha. Jasca, jatiroha ca maxo ó tsi cuatro ca soldado bo ini quiha. Jabi pascua fiesta quirëquë jodiobo qui Pedro ja mëacasni quiha nohiria bo bësojó xo tsi copixëna. ");
INSERT INTO caoNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Jama, presó ca Pedro ó soldado bo bësono tsi quiha ja bax iglesiá ca nohiria bo bëhox-bëhoxniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jatsi huëaquë tsi baquishmarí tsi quiha tsëcahacati Pedro iniquë. Huëaquë tsi jodiobo bësojo xo tsi Pedro Herodés copicasni quiha. Jama, toa baquichá tsi quiha oxa Pedro iniquë, dos ca soldado bo naxërëquë no. Jasca, cadená tsi nëxë ja ini quiha. Jasca, naquëtë cacha nii ini quiha dos ca jaha bësohai ca soldado bo. ");
INSERT INTO caoNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Jatsi jahuë naquëtë tsi quiha Iboba ángel jisiquitapiniquë. Toá tsi nii ja ini quiha. Jasca, naquëtë qui huahuani quiha huëana. Jatsi angél Pedro pipaisahaca tsi quiha ja bësomaniquë. —Mëri, mëri, niitsina —i ja qui ángel niquë. Jatsi jahuë mëquënë́ ca cadena xapaquëniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Jatsi, —Mi saco, mi zapato bo, tihi cabo sahuëhuë ra —i ja qui ángel niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Jatsi quiha ángel Pedró banahuaniquë. Toca tsi quiha preso quima ja tsëquëniquë. Jabi angél aca ca ja cahëyoiyamani quiha, ja tënamëhai nori ca quëscahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Toca tsi quiha jariapari ca soldado ba maxo ja huinocaniquë. Jaquirëquë maxo huëtsa ja huinocaniquë. Huinohax preso caiti qui ja cahëcaniquë, naa yaca qui huajati cato. Jatsi quiha jato bax caiti japëquëniquë ra; jamë no. Jatsi ja huajacaniquë. Huajahax tsi quiha bahí tsi ja bocani quiha. Jatsi calle huësti cató tsi angél Pedro jisbërianiquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jatsi Pedro bësoyoiniquë. —Jabija pa. Ibobá huësti ca ángel raaquë pa, ëa tsëcati, Herodes, jodioba chama bo, tihi cabá ëa ayamano iquish na —i Pedro niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ocapijaha ca shinapama tsi María, naa Juan Marcos jahëhua xobo qui Pedro caniquë. Toá tsi quiha huëstima ca nohiria mani ini quiha, bëhoxhi na. ");
INSERT INTO caoNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Xobo qui cahëxo tsi quiha caiti ja tox-toxhaniquë. Jatsi Rode, naa xobó ca yonati caniquë, tsohuëcara joha ca jisi na. ");
INSERT INTO caoNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Caxo Pedro quënahai ca joi ja nicaniquë. Nicahax jahari ja jabaniquë ranihi na. Caiti japëcati ja shina-bënoni quiha. —Joquë Pedro ra. Caití nii xo pa —i jato qui ja niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Jatsi, —¿Jënahuariahax raca nëbi ja ina ra? Cahëyamaqui mia ra —i ja qui nohiria niquë. Jama, —Jisi bëcahuë. Mato parayamaquia. Joquë ra —iria tsi ja niquë. Jatsi, —Tonia jahuë ángel mi nicaquë. Yama xo ra —i ja qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nëcajacano tsi quiha jari caiti tox-toxhahi quiha Pedro iniquë jicocatsi na. Jarohari tsi caiti ja japëcacaniquë. Japëcaxo tsi quiha Pedro pa ja jiscaniquë. Ja ratëyocaniquë jisi na. ");
INSERT INTO caoNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Jatsi quiha Pedró jahuë mëquë bëë-bëëhaniquë jato pasimaxëna. Ja pasicaquë tsi quiha ocapijaha ca jato ja yoaniquë: —Preso quima Ibobá ëa tsëcayaquë ra. Jaboqui Jacobo, chahahuacanaibo huëtsa bo, tihi cabo yoacata —i jato qui ja niquë. Yoaxo tsi quiha jato ja jisbayaniquë xobo huëtsá racaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Huëaquë baquishmarí tsi quiha soldado bá Pedro yopaniquë. Yopahax ja shina-motsiquicaniquë, —¿Jahuënia caraca Pedro sa? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jatsi Herodés jahuë soldado bo raaniquë Pedro mërati. Mahitsa ja mëra-mëracani quiha. Jatsi Pedro ó bësoni ca soldado bo ja nica-nicaniquë. Mahitsa quiha. Ja cahëyamacani quiha. Jatsi caxaxo tsi cacha jato Herodés raaniquë namëhacati. Jaquirëquë jodioba mai Herodés jisbayaniquë jahuë xobo-xoboriá tsi racaxëna, naa Cesarea yacatá cató no. ");
INSERT INTO caoNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Toatiyá tsi quiha Tiro, Sidón, tihi ca yacatá ca nohiria bo qui caxaxëniria quiha Herodes iniquë. Ja iqui tsi tihi ca yaca ax nohiria maxo Herodes qui jisi bocaniquë ja bëta chaninaxëna, ja bëta iquinacasyamahi na. Cahëhax tsi quiha Herodes palacio ototi ibo, naa Blasto icanai ca ya pari ja chaninacaniquë. Jatsi Blasto qui jia ini quiha toa jaha ja quëëcanaina. Jatsi quiha Blastó jato mëbiniquë jato yacatá cabo ya Herodes rabënamaxëna. Jabi Herodes ya ja rabënacascani quiha jahuë mai xo tsi jato piti ja copicascani quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Jatsi jato qui Herodés xaba aniquë jato bëta chaniti. Toa barí tsi quiha jahuë sahuëti-sahuëtiria ja sahuëniquë. Sahuëhax tsi quiha jahuë tronó tsi ja tsahoniquë. Tsahohax Tiro, Sidón, tihi ca yaca ax jonish ca maxo qui chanitsijaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Chanijano tsi quiha, —Anomaria tsi xo toa ja yoahaina ra. Joni ma xo naa chanihaina, Dios ja nori —i nohiria bo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Jatsi quiha Ibobá raani ca angél Herodes tëpastapiniquë, jia tsi Dios ja ocahuayamani iqui na. Xëná jahuë poco piyoni quiha. Jatsi Herodes naniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Toatiyá tsi quiha Dios Chani pacananiquë. Mëri ja rëtsamini quiha. Huëstima ca chahahuacanaibo paxa cabo ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Jasca, jato yonoco jatihuahax Jerusalén qui Pablo, Bernabé, tihi cabo bacaniquë. Juan Marcos ja bocani quiha jato bëta. ");
INSERT INTO caoNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Jabi Antioquiá ca iglesia naxërëquë tsi quiha Dios Chani yoati ibo bo, tiisimacanaibo, tihi cabo iniquë. Jabi toá ini quiha Bernabé, Simón naa Negro icanish cato, Cirene ax jonish ca Lucio. Tobi ini quiha Manaén, naa Herodes ya shinahamahacanish cato. Jasca, tobi ini quiha Pablo. Tihi cabo Dios Chani yoati ibo-iboria bo ini quiha toa iglesia ó no. ");
INSERT INTO caoNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Jatsi huësti barí tsi Ibo qui culto ja acano tsi quiha jato qui Espíritu Santo chaniniquë: —E bax Bernabé, Pablo, tihi cabo tsëcacana jato qui ë axëhai ca yonoco axëna —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Jatsi ja samacaniquë. Ja bëhoxcaniquë. Jatsi jato mëquë Bernabé, Pablo, tihi cabo ó ja janacaniquë Dios Chani yoatí shomahuacasquí na. Shomahuaxo tsi quiha jato ja raacaniquë Dios yonoco ja acano. ");
INSERT INTO caoNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Jaquirëquë quiha Seleucia yaca qui Bernabé, Pablo, tihi cabo bocaniquë barco bixëna. Espíritu Santó tsi ja raahacani quiha. Barco qui jicoxo tsi quiha Chipre tësëbë qui ja shitacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Shitahax Salamina icanai ca qui ja rërëcaniquë. Jatsi toa jodioba catiti xobo xo tsi quiha Dios Chani yoatí ja chitahëhuacaniquë. Jabi jato bëta Juan Marcos ini quiha jaa ri, jato mëbixëna. ");
INSERT INTO caoNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Jatsi riquibayá tsi tësëbë ja shitacana ca tsi Pafos yaca qui ja cahëcaniquë. Toa xo tsi quiha yobë ja bëchacaniquë, naa quiamisxëni ca joni ra. Dios Chani yoahai ja nori ca toa yobëcá quëscahuani quiha mahitsa ja nori. Barjesús jahuë janë ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Jabi toa tësëbë ototi ibo, naa Sergio Paulo bax toa yobë yonoconi quiha. Jasca, tiisi naa mai ototi ibo ini quiha. Jatsi quiha Chipre ototi ibobá Bernabe, Pablo, tihi cabo quënaniquë jato bëta chaninacasquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Jama, toa yobëcá jato quëtianiquë pë, jahuë chama ya ja chaninayamacano iquish na. Jabi Ibo quima jahuë chama ja casomacasni quiha pë. Yobë qui yoi jato chani ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Jatsi quiha Pabló yobë bëisniquë, Espíritu Santo chama jayaquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","—Paraxëni ca quiamisxëni ca xo mia ra. Mia ri tsi xo toa Yoshini baquë-baquëria. Mia ri tsi xo toa Dios yoi pasomaharia cato ra. Anomaria tsi xo toa Iboba jabija ca quinia mi yoshihuacatsaina iquia ra. ");
INSERT INTO caoNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Jaha bësopa. Jaboqui mia copixëhi quiha Ibo-iboria. Bëcoxëqui mia ra. Huëstima ca bari no tsi bari huëahai ca jisyamaxëqui mia ra —i yobë qui Pablo niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Jatsi ocapijani ca Chipre ototi chamá jisniquë. Jisi tsi quiha Ibo qui ja chitiminiquë, Iboba Chani qui ja ranini quëshpi na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Jaquirëquë Pafos ax riquibaya tsi quiha Pablo, jahuë rabëti bo, tihi cabo bocaniquë Perge qui, naa Panfilia maí ca yaca qui. Perge qui ja cahëcaquë tsi quiha Juan Marcós jisbërianiquë, jahari Jerusalén qui cacasquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Jatsi Perge ax riquibaya tsi Pisidia mai qui Pablo, Bernabé, tihi cabo bocaniquë. Yaca Antioquía qui ja cahëcaniquë. Cahëhax tsi quiha jodioba catiti xobo qui ja bocaniquë joiti barí no. Jicohax ja tsahocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Jatsi Moisés yoba, Dios Chani yoati ibo bá quënënina, tihi cabo toá ca yosibá nicamaniquë. Nicamaxo tsi quiha Pablo qui joi ja acaniquë jato bësojó tsi ja chanicano iquish na. —Noqui pi chamahuati chani jayaquí tsi noqui mi yoano ra —i Pablo qui jaca ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Jatsi Pablo niiniquë. Chaninox pari tsi quiha jato ja pasimaniquë, jahuë mëquë bëë-bëëhacaina. Jatsi jahuë chani ja chitahëhuaniquë: —Ea nicaparicana, Israél ca joni bá. Ea nicacana mato ri, Dios qui aracanai ca carayanabá. ");
INSERT INTO caoNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Siri tsi quiha noba rëquëyamabo Diós quënani quiha. Quënaxo tsi quiha jato ja shomahuarianiquë, carayana ca Egiptó tsi ja racacaniquë no. Toá tsi ja anicani quiha. Jatsi toa carayana ca mai quima Diós jato mëpiniquë jahuë chamá no. ");
INSERT INTO caoNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Jaquirëquë cuarenta ca año no tsi quiha jato ja oto-otoniquë, xabachá tsi ja icaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Jaquirëquë quiha siete ca carayana ca nohiria bo ja quëyocani quiha, naa Canaan maí ca racapaonish cabo. Jatsi quiha toa mai noba rëquëyamabo qui Diós aniquë ibohuati. ");
INSERT INTO caoNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Toca tsi quiha cuatrocientos cincuenta ca año bo huinocaniquë. Jaquirëquë quiha noba jimibo qui ototi ibo bo, naa juez bo, Diós aniquë jato obësoti. Jarohari tsi noba jimibo Samuel yamabá jato otoniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Jaquirëquë rey, naa chama-chamaria ó quiha noba jimibo quëëniquë, jato ja yonano. Jatsi quiha Saulo yamabo, naa Cis baquë jato qui Diós aniquë jato obësoti. Jabi Benjamin maxo quima Saulo joni quiha. Jatsi cuarenta ca año no tsi quiha noba jimibo Saulo yamabá yonaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Jaquirëquë Saulo quima jahuë yonati chama jahari Diós biniquë. Bixo tsi quiha toa chama noba David yamabo qui ja aniquë noba jimibo yonati. Jatsi jia tsi quiha David yoati tsi Diós chaniniquë: “Isaí baquë David ë biquë ra, ja yonano. E qui jiaria ca joni quiha. Jaha ë quëëhai ca jatiroha ca axëhi quiha ra” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jaquirëquë David yamaba chahitaxocobo huësti ca Diós biniquë, noqui Xabahamati Ibo iti. Jesu Diós biniquë ra, naa ja yoani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jabi Jesú jahuë yonoco chitahëhuanox pari no tsi quiha Dios Chani Juan yamabá yoaniquë. Jato jocha quima nohiria casoti, jatsi ja ashimahacacati, tihi cabo Juan chanini quiha noba jimibo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jahuë yonoco jatihuapama tsi quiha “Yama ca ëa xo naa ra. Nohiria Xabahamati Ibo, naa jaha ma pasohai ca ma xo ëa ra. Jama, ë cho joxëhi quiha. Ea oquë-oquëria ca tsi xo naa ra” i nohiria bo qui Juan yamabo ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","‘Jabi ëa nicaparicana, Abraham chahitaxocobá. Jasca, ëa nicaparicana mato ri, Dios qui aracanai ca carayanabá. Noqui tëquë qui Dios xabahamati Chani raahacaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jabi Xabahamati Ibo Jesu ini ca Jerusalén ca nohiria bo, jato chama bo, tihi cabá cahëyamaniquë rë. Jabi jatiroha ca joiti barí tsi mahitsa Dios Chani yoanish cabá quënëni ca ja nicacaniquë. Jasca, ja quënëcani ca ja jatihuacaniquë ra, Jesu namëhacati ja raacaniquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jariapari tsi Jesu qui ja quësoriacascani quiha namëcastsi na. Quësonoma ja ini quiha jocha yama ja ini iqui na. Jatsi carayana ca Pilato qui Jesu ja mëacaniquë namëhacati. ");
INSERT INTO caoNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Toca tsi jatiroha ca Jesu yoati quënëhacani ca ja jatihuacani quiha. Namëxo tsi quiha cruz quima botëmaxo tsi maiquini qui jahuë yora ja nanëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Jama, Diós jahuë Jesu bësotëquëmaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Jaquirëquë huëstima ca bari no tsi quiha jahuë rabëti bo ya Jesu co-coniquë, naa Galilea ax Jerusalén qui ja bëta bocanish cabo. ");
INSERT INTO caoNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","‘Jaquirëquë nëri no johitaquë ra mato qui naa Chani jia ca yoaxëna. Jabi siri tsi noba naborëquëbo qui naa Chani Diós yoaparini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Jama, no bax, naa jato chahitaxocobo bax toa Chani ja jatihuani quiha, jahuë Jesu ja bësomani cató no. Jabi Jesu bësotëquëxëti nori yoati Diós noqui yoani quiha, salmo libro ó no. Toa ó tsi “Noho baquë xo mia ra. Jaboqui mia bësomaquia ra” i Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","¿Tsayacanai? Jahuë baquë yoi ja bësomaniquë ra. Jasca, rësotëquëyamapistiariaxëhi quiha noqui ja ani ca Jesu. Jariapari “Paraxoma tsi mato qui huëstima ca jahuë jia cabo, naa nohiria xabahamati quinia, Xabahamati Ibo, tihi cabo axëquia, mato David yamabo qui ë yoani jascaria” i noqui Dios ni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Jasca, iti huëtsa ó tsi “Rësotëquëyamaxëqui mi mëstëxëni cato. Ea poromayamaxëqui mia, Diós” ii quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Jabi David yamabo yoati chaniyamahi quiha naa ja quënëcanina ra. David yamabo tsayacapa. Bësoquí tsi jia tsi jahuë nohiria bo ja otoni quiha, Dios shina aquí na. Jama, ja rësoniquë. Jahuë naboyamabo ya ja maihuahacaniquë. Jatsi, ¿jahuë yora poroyamayamani? Iniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Jama, poroyamaniquë naa bësotëquëmahacanish cato ra, naa Diós bësomani cato. ");
INSERT INTO caoNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Tihi tsi xo toa Dios Chani jia cato iquia ra. Jatsi ëa nicacana, ëbë xatë bá. Naa bësotëquëmahacanish ca Jesu mato yoaqui noa ra. Ja tsi xo toa nohiria jocha masati Ibo-iboria ra. ");
INSERT INTO caoNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jasca, mëstëhuahacaxëhi quiha jatiroha ca ja qui chitimicanaibo. Anomaria tsi xo toa Jesú acaina, Moisés yobá acai oquë-oquëria. Nicaparicana. ¿Jënahuariaxo raca toa Moisés yobá noqui mëstëhuana ra? ");
INSERT INTO caoNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Jatsi quiniacaxëcahuë, ma chahahuacasyamamitsa iqui na, naa Dios Chani yoanish cabá yoani jascaria: ");
INSERT INTO caoNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Tsayacahuë, jabija ca nicacasyamacanaibá. Mato xabacá tsi anomariaxëhi quiha toa ë axëhaina ra. Jama, chahahuayamaxëqui mato rë, toa chani ma nicaxëquë no. Japi ratëhax rësocahuë iquia ra” i Dios ni quiha ja quënëcani cato ó no. Jatsi quiniacaxëcana, ma tocayamano ra —nëa tsi Pablo nëcaniquë, Chani jia ca yoahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Jatsi jodioba catiti xobo Pablo, Bernabé, tihi cabá jisbayano tsi quiha jato qui nohiria bá joi amaniquë, joiti bari huëtsá tsi jasca ca jahuë bo yoati ja chanicano. ");
INSERT INTO caoNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Jasca, Pablo, Bernabé, tihi cabo qui huëstima ca jodiobo, huëstima ca jodioba jabi binish ca carayanabo, tihi cabo riiniquë. Jatsi quiha Bernabé yaxo tsi quiha jia tsi Pabló jato yobarianiquë, ja nicacana ca Dios Chani ja chahahuayoicano. ");
INSERT INTO caoNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Jatsi joiti bari paxa tsëquëquë tsi quiha yacatá ca nohiria bo tëquë, naa carayanabo bëcaniquë Iboba Chani nicaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Jatsi carayanabo huëstima ca jisi tsi jodiobo yosananiquë pë. Yosanahax tsi quiha Pabló yoahai ca chani pasomaha chanitsijacaniquë caxahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Jatsi raquëhaxma tsi quiha Pablo, Bernabé, tihi cabo chaniniquë: —Mato jodiobo qui pari Dios Chani yoatí nori no iquë ra. Jama, naa Chani jia ca bicasyama xo mato iqui noa. Tsayacahuë. Mato bëso-bësopaomacatsi quiha Dios ra, jama, mato qui yoi jahuë Chani nori. Ja tsi xo toa carayanabo qui caxëqui noa tia. ");
INSERT INTO caoNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jatsi jaboqui jato qui no cati xo naa Ibo Jesú noqui yoani quëshpi na: “Carayanabo bax huëa mia manëmaquia ra, noho xabahamati quinia nëamaria cabá cahëno iquish na” i noqui Ibo ni quiha —nëa tsi jodiobo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Jatsi quiha carayanabo rani-raniniquë Pablo chani nicahax na. Nicaxo tsi quiha Ibo qui “Gracias” i jaca niquë. Jatsi chahahuaniquë huëstima ca carayanabo, naa Diós bini cabo. Bëso-bësopaoti ja quënahacacani quiha jato ri. ");
INSERT INTO caoNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Jaquirëquë quiha toa mai tëquë ó tsi quiha Iboba Chani pacananiquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Jama, jodiobo qui yoi ini quiha toa chani paxa cato. Ja iqui tsi yacatá ca carayanaba chama bo, jodioba jabi binish ca yoxa bo, tihi cabo naa jodiobá caxahuaniquë Pablo, Bernabé, tihi cabo qui. Toca tsi Pablo Bernabé tënëmati ja chitahëhuacaniquë. Tënëmaxo tsi quiha jato mai quima jato ja niacaniquë pë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Jatsi quiha Pabló Bernabé jisbayaniquë. Riquibaya tsi quiha jato tahë́ ca mai pari ja pojpohacaniquë jato shina yoi ca ja ini ca jismaxëna. Pojpohacax tsi Iconio, naa yaca huëtsa qui ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jama, rani-ranini quiha toá ca chahahuabëna cabo, Espíritu Santo jayahi na. ");
INSERT INTO caoNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Iconio qui cahax tsi quiha jodioba catiti xobo qui Pablo Bernabé jiconiquë. Jicoxo tsi quiha chama ya Dios Chani ja yoacaniquë. Jaha tsi quiha huëstima ca jodiobo, carayanabo, tihi cabá chahahuaniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Jaha tsi yosanani quiha chahahuacasyamahai ca jodiobo. Yosanaxo tsi quiha toa yacatá ca carayanabo ja itsisnahuayocaniquë chahahuacanaibo pasomaha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Ja quëshpi tsi naama tsi quiha Pablo Bernabé chitëni quiha toá ca chahahuacanaibo mëbixëna. Raquëxoma tsi Ibo yoati ja yoacani quiha. Jasca, yoapama tsi quiha jisti bo ati mëtsa ja icani quiha, Diós jato qui ani ca chamá no. Toca tsi jabija ca jato chani ini ca Diós jismani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Jatsi quiha jahuëcara shinati yacatá ca carayanabá cahëyamaniquë. Ja mapëxnacani quiha. Huëstima cabá jodiobo mëbicasni quiha. Nohiria tëxë bá Pablo, Bernabé, tihi cabo mëbicasni quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jarohari tsi quiha toa jodiobo yaxo tsi quiha yacatá ca carayanabo, jato chama bo, tihi cabá planes ani quiha Pablo, Bernabé, tihi cabo axëna. ");
INSERT INTO caoNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","7","Jama, ja acascani ca Pabló Bernabé nicaniquë. Nicahax tsi quiha mai huëtsa, naa Laconia icanai ca qui ja jabacaniquë. Toa maí ca dos ca yaca bo, naa Listra, Derbe, jato tëamë ca nohiria, tihi cabo xo tsi quiha Dios Chani ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Jabi Listra ó tsi joni, naa tahë choni jaya ca racaniquë. Toca tsi ja coni quiha rë. Tapipistiayamariani quiha naa joni ra. ");
INSERT INTO caoNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Toa xo tsi Dios Chani Pabló yoaquë tsi quiha jato chani naa joní nicaniquë. Nicaxo tsi quiha ja chahahuaniquë. Jatsi jënimahuahacati chahahuati mëtsa ja ini ca Pabló jisniquë. Jisi tsi quiha ");
INSERT INTO caoNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","joni qui ja quënaniquë: —Mi tahë tsi niihuë ra —iquiina. Jatsi mëri tsi ja niiniquë. Tapiti ja chitahëniquë ra. ");
INSERT INTO caoNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Jabi Pabló ani ca nohiria bá jisniquë. Jisi tsi quiha quënatsijahuacaniquë jato joí no: —Noqui botëquë dios bo ra. Joni jaria bo jaya ca xo —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Jatsi dios “Júpiter” Bernabé quënahacaniquë. Jatsi dios “Mercurio” Pablo quënahacaniquë, chaniti ibo ja ini quëshpi na. Jabi botënish ca dios bo ja icani ca ja quëscahuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Jatsi jato dios Júpiter arati ibo joniquë jato arati xobo ax na. Jabi yaca cacha jato arati xobo ini quiha. Jatsi huëyë bo, jianati joa bo, tihi cabo jato arati ibobá bëniquë yacata jicoti qui. Jatsi nohiria bo yaxo tsi quiha huëyë bo ja tëpascasniquë Pablo, Bernabé bax na, dios bo ja icani ca quëscahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Jatsi quiha ja acascani ca Pabló Bernabé nicaniquë. Nicaxo tsi quiha jaraxatsi jato sahuëti bo jahuacaniquë cohuëquí na. Nohiria misco qui jabapama tsi quiha ja quëna-quënacaniquë: ");
INSERT INTO caoNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Ayamacahuë, joni bá. Maí ca nohiria yoi bo xo noa ra, naa mato jascaria. Chani jia ca yoahi no johitaquë ra. Mato mahitsa ca jahuë bo quima bëso ca Dios quiri, naa naipa, mai, ia bo, tihi cabo nëhohuanish ca quiri bësocana iqui noa ra. ");
INSERT INTO caoNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Jariapari tsi mato carayanabo qui Dios caxayamapaoni quiha, mato quinia yoi cato ó tsi ma bohoquë no. ");
INSERT INTO caoNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Toatiyá tsi quiha bëso ja ini ca cahëti mëtsa ma i-ipaoniquë iquia, mato bax ja ani cató no. Mato qui naipá ca oi ja raani quiha. Jasca, ma banani ca shinahamahi quiha. Ma piti ca mato qui aqui quiha, ma narisyamano iquish na. Jasca, mato ranihuahi quiha —nëa tsi nohiria bo qui Pablo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Pablo chani nicaxo tsi quiha jari jato bax huëyë bo ja acascaniquë pë. Jarohari tsi quiha nohiria bo ja jënëcaniquë ja ayamacano iquish na. Bëroma ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jatsi quiha Antioquía, Iconio, tihi ca yaca bo ax tsi quiha huësti huësti ca jodiobo cahëniquë. Cahëxo tsi quiha Pablo ja ocahuacaniquë jahuë chani nohiria bá nicayamano iquish na. Jatsi Pablo qui yacatá ca nohiria bo caxaniquë. Caxaxo tsi quiha Pablo ja acaniquë maxaxá no. Axo tsi quiha yaca cacha jahuë yora ja xërëcaniquë, bësoyama ja ini ca quëscahuaquí na. ");
INSERT INTO caoNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Jama, jahuë yora tëamë tsi chahahuacanaibo quëtsoquë tsi quiha Pablo niiniquë. Joihax jahari yaca qui ja caniquë chahahuacanaibo ya. Jatsi huëaquë tsi quiha Derbe icanai ca yaca qui Pablo caniquë Bernabé ya. ");
INSERT INTO caoNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Derbe qui cahëxo tsi quiha Dios Chani ja yoacaniquë. Yoapama tsi quiha huëstima ca chahahuacanaibo ja bëbocaniquë. Jaquirëquë quiha Listra, Iconio, Antioquía, tihi ca yaca bo qui jahari ja bacacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Bacaxo tsi quiha chahahuacanaibo ja chamahuacaniquë. Chamahuaxo tsi quiha jato ja yobacaniquë Ibo quima ja casoyamacano. —Diós otohai ca qui jiconox pari tsi huëstima tsi no tënëxëti xo ra —i jato qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yobaxo tsi quiha jatiroha ca iglesia ó tsi yosibo ja janacaniquë chahahuacanaibo ja otocano. Jabi Ibo qui mëanox pari tsi quiha ja samacana ca tsi ja bëhoxcaniquë. Jia tsi toá ca nohiria bo Ibo qui chitimini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Derbe jisbëria tsi quiha Pisidia mai ja natanicaniquë. Natanihax tsi quiha Panfilia mai qui ja cahëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Toa xo tsi, naa Perga yacata xo tsi quiha Dios Chani ja yoacaniquë. Yoahax Atalia yaca qui ja bocaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Jahá ca barco qui jicohax tsi quiha jahari Antioquía qui ja bocaniquë, naa Dios qui ja acacacani cató no. Jabi jato qui toa acacani ca yonoco ja jatihuacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Jatsi Antioquía qui cahëxo tsi quiha chahahuacanaibo tëquë ja catiacaniquë. Jatsi jato bax Diós anina, carayanabo Diós jahuë Chani nicamanina, carayanabá chahahuahaina, tihi cabo quiha jato ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Jaquirëquë quiha naama tsi ja chitëcaniquë toá no, chahahuacanaibo ya. ");
INSERT INTO caoNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Toatiyá tsi quiha Antioquía qui cahëniquë huësti huësti ca jodiobo jato mai ax na. Cahëxo tsi quiha carayana ca chahahuacanaibo tiisimatsijahuacaniquë. Ja nëcacaniquë: —Ma jibirishahacati xo ra. Moisés yamabá noqui toa jabi ani quiha ati. Xabahamahacati-maxëni xo mato ra, toa jabi acaxma —nëa tsi ja nëcacani quiha chahahuacanaibo qui. ");
INSERT INTO caoNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Jatsi quiha jibirishati jabi tahëxo tsi jato qui Pablo, Bernabé, tihi cabá joi mëraniquë. Jato qui yoi jato yoba ini quiha. Jaha tsi Pablo, Bernabé, iglesiá ca xatë huëtsa bo, tihi cabo Jerusalén qui raahacaniquë, toá ca Chani chitahëhuanish cabo, yosibo, tihi cabo ya ja chaninacano iquish na, naa toa Moisés jabi yoati na. ");
INSERT INTO caoNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Jatsi iglesiá ca xatë bá jato raaniquë. Fenicia, Samaria, tihi ca mai bo natanipama tsi quiha carayanabo Ibo qui bësocanai ca ja yoabonacaniquë. Jatsi raniniquë iglesiá ca xatë bo toa chani nicahax na. ");
INSERT INTO caoNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Jatsi Jerusalén qui cahëxo tsi quiha iglesiá ca xatë bo, yosibo, Chani chitahëhuati ibo bo, tihi cabo ja joihuacaniquë. Joihuaxo tsi quiha jatiroha ca jato bax Diós ani ca ja yoacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Jatsi niiniquë huësti huësti ca chahahuanish ca fariseobo chanixëna: —Jibirishahacaxëti xo chahahuahai ca carayanabo ra. Jasca, Moisés yoba ja nicaxëti xo jato ri ra —i toá ca xatë bo qui jaca niquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jatsi Chani chitahëhuati ibo bo, yosibo, tihi cabo catiniquë jibirishati jabi, Moisés yoba, tihi cabo yoati tsi chaninaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Naama tsi quiha ja chaninacani quiha. Jatsi Pedro niiniquë chanixëna: —Ea nicaparicana, ëbë xatë bá. Naama tsi quiha mato ó ca ëa Diós biniquë, carayanabo qui jahuë Chani Jia ca yoatí, ja chahahuacano jato ri iquish na. ");
INSERT INTO caoNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Jatsi Diós, naa nohiria ba shina cahëxëni cató carayanabo qui Espíritu Santo aniquë, noqui jodiobo qui ja ani jascaria. Dios qui jia ja ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ja qui oquë noqui jodiobo iyamani quiha, ja qui ja chitimihai cató tsi jato shina ja bahuëni iqui na. ");
INSERT INTO caoNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Jatsi ¿jëniriaxo tsi Dios tanamacascanai sa? Naa chahahuahai ca carayanabo qui noba jodioba jabi bo pi ma ano tsi caxaxëhi quiha Dios tonia. Toa jabi bo banahuatimaxëniria noba naborëquëbo ini quiha jato ri. Jasca, banahuatimaxëniria xo noqui ri ra. ");
INSERT INTO caoNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Toa jabi no acai cató tsi noqui xabahamayamahi quiha Dios ra. Jama, jahuë Jesucristo noihai cató tsi xabahamahacahi quiha noa iquia, naa carayanabo xabahamahacahai jascaria —nëa tsi iglesiá ca chama bo qui Pedro nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Jatsi pasicaniquë catinish cabo. Jaquirëquë quiha Pablo, Bernabé, tihi cabo chaniniquë. Chanixo tsi quiha carayanabo xërëquë xo tsi Diós jato amani ca jistiria bo ja yoacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jato chani ja jatihuacaquë tsi quiha Jacobo chaniniquë: —Ea nicaparicana, ëbë xatë bá. ");
INSERT INTO caoNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Carayanabo Diós otocatsai ca noqui Simón yoaquë ra. “Carayanabo quima jahuë nohiria yoi bo tsëcahi quiha jahuë́-na bo iti” i ja a quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Jabija tsi xo toa ja yoahana ra. Tocaxëti xo i Dios Chani yoati ibo-iboria ni quiha, Quënëhacanish cabo ó no. Jabi ja quënëcani ca tsi xo naa: ");
INSERT INTO caoNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","“‘Mato jocha iqui tsi mato ë jisbërianiquë; jama, bacaxëquia. Bacaxo tsi noho nohiria yoi bo catiaxëquia ë qui ja aracano iquish na, naa David yamabá yonani cató tsi ja arapaocani jascaria. ");
INSERT INTO caoNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Jatsi Ibo yoi chahahuacaxëcani quiha nohiria huëtsa. Nohó-naxëhi quiha carayanabo ri’ ");
INSERT INTO caoNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","nëa tsi Ibo, naa noqui jahuë planes yoanish ca nëcani quiha”. ");
INSERT INTO caoNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","‘Jabi naa quënëni ca iqui tsi noho yoba tsi xo naa: Dios quiri bësocanai ca carayanabo no yosanamayamano. “Noba jodioba jabi bo ma ati xo” i jato qui no yamano ra. ");
INSERT INTO caoNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Jama, carta ó ca yoba huëtsa jato qui no raano. Idolo bo qui acacaha ca piti ja piyamacano. Jasca, anoma ca chotahai ca ja quiniacano. Jasca, jimihuahama ca nami, jimi, tihi cabo ja piyamacano. Tihi ca yoba bo roha jato qui no quënëxëti xo iquia. Tihi tsi xo toa ja ayamacaxëcanaina iquia. ");
INSERT INTO caoNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Jabi jatiroha ca barí tsi quiha tihi ca jahuë bo pasomaha ca yoba yoahacani quiha jatiroha ca yacata ax na. Naama tsi quiha noba nohiria qui toa Moisés yoba acacani quiha —nëa tsi jato qui Jacobo nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jatsi iglesiá ca chahahuacanaibo ya tsi quiha Dios Chani chitahëhuati ibobo, yosibo, tihi cabá jato ó ca huësti huësti ca joni bo biniquë Antioquía yaca qui jato yoba boti. Pablo, Bernabé, tihi cabo ya jato ja raacani quiha. Jatsi Judas ja bicaniquë, naa Barsabás quënahacanish cato. Jaquirëquë Silas ja bicaniquë. Tihi cabo ja bicaniquë jato yoba boti. Jato xatë bo rëquëniniti ibo bo ja icani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Raapama tsi jato bëta naa carta ja raacaniquë: “Mabë xatë bo, naa Dios Chani chitahëhuati ibo-iboria bo, nëá ca yosibo, tihi cabo tsi xo naa carta quënëcanaina. Mato carayanabo joihuaqui noa, naa Antioquía yacata, Siria, Cilicia mai, tihi cató ca racacanaibo. ");
INSERT INTO caoNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Jishopë. Noba maxo ó ca xatë bo, naa chama yama cabo mato qui bocani ca no nicahitaquë rë. ‘Jibirishahacaxëti xo chahahuahai ca carayanabo. Jasca, jodioba yoba bo ma banahuaxëti xo’ ¿i mato qui ja yamayamacani? Toca tsi ma shina-motsiquini ca no nicahitaquë. Anoma quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Jaha tsi nëá ca dos ca joni shinajiaxënia ca no biquë mato qui raaxëna. Shinaxo tsi Pablo, Bernabé, tihi cabo ya jato raaqui noa. ");
INSERT INTO caoNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ibo Jesucristo tahëhax tsi huëstima tsi naa dos ca joni bo acacaquë ani quiha ra. ");
INSERT INTO caoNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Jaha tsi Judas, Silas, tihi cabo mato qui raaqui noa noba yoba boti. No quënëha ca jasca ca mato yoacaxëcani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nicacana. Noba jodioba jabi bo mato qui acasyama xo noa. Mato qui yosariaxëhi quiha iqui noa. Jama, tobi quiha yoba pistia mato qui no acatsaina, naa noqui, Espíritu Santo, tihi cabo qui jia cato. ");
INSERT INTO caoNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Idolo bo qui acacahax ca oriquiti, jimi, jimihuahama ca nami, tihi cabo piyamacana. Jasca, anoma ca chotahai ca basicana. Tihi cabo ayamapiquí tsi jia tsi axëqui mato. Iquë” nëa tsi jato carta nëcaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Jatsi Pablo, Bernabé, chani bocanai ca joni bo, tihi cabo bocaniquë Antioquía qui. Cahëxo tsi quiha chahahuacanaibo ja catiacaniquë jato carta nicamaxëna. ");
INSERT INTO caoNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Toa yoba nicacaniquë iglesiá ca nohiria bo. Nicahax ja rani-ranicaniquë. Jato qui jia toa yoba ini quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jasca, carta nicamaxo tsi quiha jia tsi chahahuacanaibo ja chamahuacaniquë, Dios Chani yoati ibo bo ja icani iqui na. ");
INSERT INTO caoNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Ichariama bari no tsi ja chitëcani quiha. Jatsi jia tsi jahari Jerusalén qui ja raahacacani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Jama, Antioquiá tsi Pablo Bernabé chitëniquë. Toá tsi quiha Iboba Chani ja tiisimacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Jaquirëquë Bernabé qui Pablo chaniniquë: —¿Iboba Chani no yoani cabo qui jahari canoma ni, toá ca yacatá ca xatë bo qui shishoxëna? ¿Jënijacanai ca jisi canomani? —iquiina. ");
INSERT INTO caoNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Jatsi Juan Marcos Bernabé bocasni quiha, ja bëta ja cano. ");
INSERT INTO caoNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Jama, Pablo qui yoi ja ini quiha. Marcos ja bocasyamani quiha, Panfilia ó tsi jato ja niabëriani iqui na. Toatiyá tsi quiha jato bëta Marcos chitëyamani quiha. ");
INSERT INTO caoNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ja iqui tsi Pablo Bernabé joi mërananiquë. Joi mëranahax tsi quiha jato jamë ca quiniá tsi ja bocaniquë. Ori tsi naa Chipre qui barcó tsi quiha Bernabé caniquë Marcos ya. ");
INSERT INTO caoNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Jatsi Silas Pabló biniquë ja bëta ja cano. Jabi ja bocanox pari no tsi toá ca iglesiá cabo jato bax bëhoxniquë, Diós jato mëbiriano. ");
INSERT INTO caoNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Jatsi Siria, Cilicia, tihi ca mai bo ja nacocaniquë. Nacopama tsi quiha chahahuanish cabo ja chamahuabonacaniquë. ");
INSERT INTO caoNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Derbe, Listra, tihi ca yaca qui cahëxo tsi quiha Timoteo, naa Jesu qui chitiminish ca shinapayo ca Pablo, Silas, tihi cabá bëchaniquë. Chahahuahai ca jodio Timoteo jahëhua ini quiha. Jahuë jahëpa carayana ini quiha. ");
INSERT INTO c