﻿USE sofia;
DROP TABLE IF EXISTS sofia.cam_vpl;
CREATE TABLE cam_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cam_vpl WRITE;
INSERT INTO cam_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wo Iésu *Kériso, ke e wie mu ko *Davita, pa piebehi *Abérama. Ke woélé-ni ni watihe Iésu: ");
INSERT INTO cam_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abérama Isaaka Iakobo *Juda (me lépwo âjiénen) ");
INSERT INTO cam_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Pérès (me Zéra; nyaa telu, ke wo Tamar) Esron Ram ");
INSERT INTO cam_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab Nachon Salma ");
INSERT INTO cam_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Booz (nyaa ten, ke wo Rahab) Obed (nyaa ten, ke wo Rut) Jessé ");
INSERT INTO cam_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Davita. Wo Davita, ke pa daame ne *Isaraéla. Ke é alecehen, ke ni béé watihe Iésu, ke wo: *Solomona (nyaa ten, ke ê mwode Uri ânebun) ");
INSERT INTO cam_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboam Abia Asa ");
INSERT INTO cam_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafat Joram Ozias ");
INSERT INTO cam_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Iotam Akaz Ézékia ");
INSERT INTO cam_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manassé Amon Josias ");
INSERT INTO cam_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iékonia (me ni âjiénen). Ke é ha a benaamwon naa, ke lé pawie lépwo Isaraéla mu ha amu telé, ke lé péélé nge *Babulona me lépwo *apenem tice ja kon. ");
INSERT INTO cam_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ke é ne alecehen, ke ni béé watihe Iésu, ke wo: Salatiel Zorobabel ");
INSERT INTO cam_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abihoud Éliakim Azor ");
INSERT INTO cam_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadok Akim Élioud ");
INSERT INTO cam_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Élazar Matan Iakobo ");
INSERT INTO cam_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Josef. Ê mwode Josef, ke wo Maria, ê nyaa te Iésu na pii kon pie Kériso. ");
INSERT INTO cam_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Woélé naa ati a jéhi ni watihe Iésu Kériso. Tabuhi mu ko Abérama, die ko Davita, ke pwo 14 ni niide apulie. Ke tabuhi mu ko Davita, die ko a bwo pé wie a bele Isaraéla mu Juda nge Babulona, ke pwo 14 ni niide apulie. Ke é mulang, ke 14 mwo ni niide apulie die ko a bwo pituie te pa *Mesia. ");
INSERT INTO cam_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Weengi a jepule ko a bwo pituie te Iésu Kériso, pa Mesia: Wo Maria, ê nyaa ten, ke mwo te ju pinimelu kolu me Josef. Ke é ânebuhe a bwo piaten delu, ke caa pwoapulie kon, na e pwaadeniin bé na a *Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ke e niimihi wo Josef pie, me e ne mwo Maria. Kehe icehi ana pa apulie na e te pipwoiipieng, ke time e uce pii pwaatihi, beme time uce tanim Maria ne he pwahamii ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","É he e ko pitautinaado ne ko anaa, ke e bwo alihi ne ha a niûn pa *âcélo te Padaame, na e pii ten pie: «Josef, pa piebehi Davita, go nemwo pwo me mwotiko me go pé Maria. Be mepwo é ne ko pa cuwo ewa aiu na e kon, ke e pwaadeniin bé na a Jenen Iitihi. Ke mepie e bo pituie, ke go bo ne me a niin pie Iésu. Be o bo weeng pana e bo *celuimi a bele ten mu he ni ta pwo ten.» ");
INSERT INTO cam_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ke ati ni naado naa, ke e tuie, beme pacuwohi ali e pii wo Padaame, na e pwaadeniin bé wo pa *péroféta ten pie: ");
INSERT INTO cam_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","O bo pwoapulie ko êgi toomwo, ke e bo picile pa ewa aiu. Ke bo ne me a niin pie Émanuéla, a bwopiinen pie, e pelenye wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ke me e ûmiê wo Josef, ke e pwo ana e pii ten wo pali âcélo. Ke e pé Maria ê mwoden ne pelen. ");
INSERT INTO cam_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Kehe icehi ana time lu uce pipule dieli ko a bwo piâbeele ewa te Maria. Ke wo Josef, ke e ne me a nii pali cuwo ewa pie Iésu. ");
INSERT INTO cam_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","E piâbeele wo Iésu ne Bétéléma ne *Judé, ha a benaamwon de pa daame *Érode. Ke ni béé maagoi, nina lé pitemang na lé cémun ne ko ni ceni, ke lé âbé mu he na e caama lang a téale. Ke lé tuie nge *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ke lé tahimwo ni apulie Iérusaléma pie: «E wé wo pa cuwo ewa na e mwo te ju piâbeele, pana me e bo daame he lépwo *Juif? Be geme alihi a ceni ten he e tuie, a ine a bwo piâbeele ten. Ke geme ko âbé me geme pipaunueng ke me geme ne ten ni âpipati teme.» ");
INSERT INTO cam_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ke wo pa daame Érode, ke e téne a jepule ko a bwo tehenebé te lépwo maagoi me nina lé pii. Ke hauli a pwonimen. Ke ati lépwo Iérusaléma, ke mwotilé. ");
INSERT INTO cam_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ke e tapiti ati ni caa te lépwo *apwoâpwailo, me ni *dotéén ko patén. Ke e tahimwolé pie: «He é wé ace duaan celi e bo piâbeele ne hen wo pali *Mesia li geé ko ucéieng?» ");
INSERT INTO cam_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ke lé hegi ne ten pie: «É ne Bétéléma ne Judé, be weengi a pwooti te Padué, li e caa tii wo pa péroféta, pie: ");
INSERT INTO cam_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","*Adéihi a amu Bétéléma, a amu mu *Juda! Piubwo go koja ni béé amu. Be e bo wie mu pelem pa daame na ubwo nang; pana e bo wéihi a bele tong, a bele *Isaraéla.» Miché 5.1 ");
INSERT INTO cam_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","É mulang, ke e tode lépwo maagoi wo Érode. É he te piwoélé cehi, ke e pii telé pie: «Geé pii tong ehi ace benaamwon celi geé tabuhi alihi hen ali ceni.» ");
INSERT INTO cam_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Me lé pii ten ke e pahedelé ngemwo Bétéléma, ke e pii telé pie: «Geé â hane ehi pali cuwo ewa, ke mepie geé tooeng, ke geé mwojuia mwobé me geé pii tong. Be nimung mwo me é ân me é pipaunueng, ke me é ne ten ni âpipati tong.» ");
INSERT INTO cam_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Nebwén, ke lé engen wo lépwo maagoi. Ke lé te tai alihi mwo ali ceni. Ke lé âcehin, ke me e tehene nge he bebenihe a mwa na e mu hen wo pali cuwo nahi ewa, ke e cuwo. ");
INSERT INTO cam_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ke me lé alihi pie e cuwo lang ali ceni, ke lé te junihe pipwodéén kuti. ");
INSERT INTO cam_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ke lé taa ha ali mwa, ke lé too pali cuwo ewa me Maria, ê nyaa ten. Ke lé tidihi jililé, ke lé pipaunu pali cuwo ewa. Ke lé tuu ni âne élele telé, ke lé ne ten ni muko pétaapwo âpipati telé, na te junihe ubwo ni cuhin: mwani megele†, me ni encens, me ni tabe ûde na a niin pie myrrhe. ");
INSERT INTO cam_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","É alecehen, ke e pii telé wo Padué ne he ni niûlé pie, me time lé uce mwojuia ngemwo pele Érode. Kehe lé pé ace céiu pwaaden celi ité, me lé mwojuia ngemwo ha amu telé. ");
INSERT INTO cam_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","É he lé caa mwojuia ngemwo wo lépwo maagoi, ke pwo a niû Josef. E ali pa *âcélo na e pii ten pie: «Go piepin! Go cuwoda, ke go pé lu téénemeewa, ke go celuimilu nge *Aigupito! Be e pwo me e hane pali cuwo ewa wo Érode, beme e taunueng. Ke geé mu lang dieli ha a tan na é bo paciheko mwo.» ");
INSERT INTO cam_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ke e cuwoda wo Josef, ke e pé luli téénemeewa, ke lé engen he bwén, nge ha amu Aigupito. ");
INSERT INTO cam_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ke lé mu lang dieli ko a bwo mele te Érode. Ati ni naado naa, ke e tuie, beme pacuwohi ali e pii wo Padaame, na e pwaadeniin bé wo pa péroféta ten, pie: É caa todebé pa naîng, ke é pawieeng mu Aigupito. ");
INSERT INTO cam_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wo Érode, ke e alihi pie lé pipwohuô ten wo lépwo maagoi. Ke e te junihe okéé kuti. Ke e pwo me taunu ati ni nahi ewa aiu na élé neole koja a alo jo, ha ati a Bétéléma, me ni béé duaan ko jijen. Be e temehi mu ko lépwo maagoi ali benaamwon li e tuie hen ali ceni. ");
INSERT INTO cam_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ke me wonaa, ke e pacuwohi ali e pii wo Padué, na e pwaadeniin bé wo péroféta Iérémia pie: ");
INSERT INTO cam_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Nye téne ni pwoé, me ni pihemun ne Rama, he e é niimi ni naîn wo Rachel†. Pwocoon me lé tanyuueng, be caa tielé ati. Jérémie 31.15 ");
INSERT INTO cam_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","É ne alecehe a bwo mele te Érode, ke pwo a niû Josef ne Aigupito. Ke e ali pa âcélo te Padaame ");
INSERT INTO cam_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","he e pii ten pie: «Go cuwoda, ke go pé luli téénemeewa, ke go mwojuia imilu ngemwo ha amu Isaraéla, be lé caa mele wo lépwoli nimelé me lé taunu pali cuwo ewa.» ");
INSERT INTO cam_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ke e cuwoda wo Josef, ke e péélu mwojuia ngemwo ha amu Isaraéla. ");
INSERT INTO cam_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kehe icehi ana e téne pie wo Arkélaos, pa naî Érode, ke e caa te pé mwo a pwodaame ne Judé, alecehe a bwo mele te caa ten. Ke mwoti Josef me e mwojuia ngemwo lang. Ke e pii ten mwo wo Padaame ne ha a niûn pie, me lé â ha amu Galilé. ");
INSERT INTO cam_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ke lé mu ha a céiu mwopopwaalé na pii kon pie Nazaret, beme e pacuwohi ana lé caa pii wo lépwo péroféta pie, wo pa Mesia, ke o pa apulie mu Nazaret. ");
INSERT INTO cam_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Alecehe ni jo na hiwon, ke e cuwoda wo pa céiu apulie na a niin pie *Ioane pa apipuu apulie. Ke e mu ha a da ne *Judé, ke e patemehi te ni apulie na lé âbé céiieng, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Geé pininim, ke geé taatééhi ni mulihewé! Be caa é mwonu a *Mwametau he Miiden!» ");
INSERT INTO cam_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wo Ioane, ke weeng pali e caa pipwojepule kon wo péroféta Isaia pie: Pwo pa apulie ha a da na e toii da pie: “E âbé wo Padaame! Pwopweehi a pwaadeniin! Pwo me belece a duaan na e engen hen!” Ésaïe 40.3 ");
INSERT INTO cam_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Wo Ioane, ke e cuwohe a epwén na pwo ko pumii chameau, ke a taihenan a iiwota. Ke e wii koléé, ke e ûdu duhimepu. ");
INSERT INTO cam_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ke te junihe hiwon ni apulie na lé âbé céiieng ne ha a da, mu *Iérusaléma, me ati a amu Judé, me ni piduaa éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ke lé pii beetihi ni ta pwo telé ne he pwahamii ni apulie ati. Ke e puulé ne ha a éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Hiwon mwo ni apulie mu he lupwo dihe pwoiitihi te lépwo *Juif, wo lépwo *Farasaio, me lépwo *Saducéen, na lé âbé céii Ioane, beme puulé. Ke me e alilé, ke e pii telé pie: «Wogewé ni nahi bwien, me ni agele! Woo na e pii tewé pie, geé o cela ko ni cuhinaado na e bo ne tewé wo Padué? ");
INSERT INTO cam_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Geé mi pwo ce huô celi wâé, beme a béhabwiinen pie, caa taatééhi ni mulihewé! ");
INSERT INTO cam_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","É mu ko ade na geé niimihi pie, o celuimikewé mu ko ana wo *Abérama ke pa watihewé? Ûhu! Be é pii tewé pie: Mepie nime Padué, ke o jan ne kon me e bitehi ni péi ce, me ni piebehi Abérama! ");
INSERT INTO cam_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","«E caa te pwopweehi a gi ten wo Padué. Ke e bo tahagéi ne ko ni waan ati ni acuwo na time uce wâé ni acehin, ke e bo cini ne pwo miû!» ");
INSERT INTO cam_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","«Woéo, ke é puukewé ko a tabe, beme o a béhabwiinen pie geé caa pitaatééhi ni mulihewé. Kehe icehi ana wo pana e bo âbé alecehung, ke e bo puukewé ko a *Jenen Iitihi me a miû. Weeng, ke te junihe pwojunuun kojaéo, ke time uce jan ne kong me é tuwo ni tai ko ni dihibwaan. ");
INSERT INTO cam_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","E caa te mi pipwopweeng, beme e tauti ni apulie, ke e bo pineité nina wâé jélé me nina ta jélé, pwohewii a bwo pineitééhi na a pidenaado koja a piin. Ke e ne ehi ni pidenaado, kehe e cini ni piin ne ha a miû na te tice paceli jan me e taunuhi.» ");
INSERT INTO cam_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","É alecehen, ke e engen wo Iésu mu ha amu Galilé, ke e â ha a éémwa Ioridano beme e puueng wo Ioane. ");
INSERT INTO cam_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kehe icehi ana time uce nime Ioane me e pwo, ke e pii te Iésu pie: «Kona é ko ade na go âbé céiiéo? Pana time uce jan me é puuko. Wâé heme go puuéo.» ");
INSERT INTO cam_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ke e hegi ne ten wo Iésu pie: «Te wâé ana go pii, kehe icehi ana é jenaa, ke wâé heme genyu pacuwohi ana *mwomwon ne he pwahamii Padué.» É mulang na e puueng wo Ioane pwohewii a bwopiinen den. ");
INSERT INTO cam_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ke me e wie mu he tabe wo Iésu, ke e te tehi kuti a miiden, ke e alihi a Jenen Iitihi te Padué, he e opé ne huîin pwohewii a meni pwojo. ");
INSERT INTO cam_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ke pwo a pwocihe bé mu he miiden na e pii pie: «Wo panaa, ke pa Naîng na te céiu nang na te nihe eânimung den, weeng kuti pana é caa pipégalieng ne ha a pwonimung.» ");
INSERT INTO cam_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","É alecehen, ke e pé Iésu na a *Jenen Iitihi te Padué, nge ha a da, beme e tacebwénieng wo *Caatana, pa apipé ne konye. ");
INSERT INTO cam_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ke time e uce wiinaado wo Iésu he na 40 ni tan, be e *pipaciile, ke caa menen. ");
INSERT INTO cam_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ke e tooeng wo Caatana, pa atacebwénikenye, ke e pii ten pie: «Hemepie wogo pa *Naî Padué, ke go taatééhi ni péi ce me pwoloa!» ");
INSERT INTO cam_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ke e hegi ne ten wo Iésu pie: «Caa te tii ne he ni *tii iitihi pie: Time e uce mulie cehi ko a pwoloa wo pa apulie, kehe e te mulie mwo ko ni pwooti na e pii wo Padué.» ");
INSERT INTO cam_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ke e pé Iésu nge ha a pwomwo ubwo iitihi, *Iérusaléma, ke e pééeng da pwo puni a *mwaiitihi. ");
INSERT INTO cam_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ke e pii ten pie: «Hemepie wogo pa Naî Padué, ke go téele mu éni! Be caa te tii ne he ni tii iitihi pie: E bo pahede ni âcélo ten wo Padaame Padué beme lé wéiko. Ke lé bo hegiko, ke o time uce tanahi ni am ne ko ni péi.» Psaume 91.11−12 ");
INSERT INTO cam_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ke e hegi ne ten wo Iésu pie: «Ûhu, be caa te tii ne mwo he ni tii iitihi pie: Go nemwo tacebwéni Padaame Padué hem.» ");
INSERT INTO cam_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","E pééeng mwo wo Caatana, da pwo a céiu juwole na te junihe e daaité. Ke e habwii ten ati ni amu, me ni mwametau pwo bwohemwo, me ni wâé telé, me ni naamuulé. ");
INSERT INTO cam_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ke e pii ten pie: «Mepie go tidihi jilim he pwahamiing, me go pipaunuéo, ke é bo ne tem ati ninaa.» ");
INSERT INTO cam_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ke e pii ten wo Iésu pie: «Go engen kojaéo, go Caatana! Be caa te tii ne he ni tii iitihi pie: Go pipaunu Padaame Padué hem, ke te weeng cehi na me go penem den.» ");
INSERT INTO cam_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nebwén, ke e ne Iésu wo Caatana. Ke lé âbé too Iésu ne ni *âcélo, ke lé penem den. ");
INSERT INTO cam_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","É ne alecehen, ke e téne wo Iésu pie, lé caa ne *Ioane pa apipuu apulie he karépu. Ke e engen wo Iésu, ke e â ha amu Galilé. ");
INSERT INTO cam_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ke time e uce mu Nazaret, kehe e â pimu Kapernaüm, a behi a bajié Galilé, ha a duaan Zabulon me Neftali. ");
INSERT INTO cam_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","É nelang he na e pacuwohi ali e pii wo Padué, na e pipwaadeniin bé wo péroféta Isaia pie: ");
INSERT INTO cam_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Téne, wogeu lupwo amu Zabulon me Neftali, wogeu mwonuhi a jié; ne gaale cemwo ko a Ioridano; lupwo duaan ne Galilé; amu na pihiwon ni bele hen, na time lé uce bele tong: ");
INSERT INTO cam_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Lé alihi a pwéélang na ubwo ne nina lé mu ha a melepiing. A pwéélang na pwomelaan ko nina lé mu ha a bwén iitihi. Lé o mulie cemwo! Ésaïe 8.23―9.1 ");
INSERT INTO cam_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ke te tabuhi kuti mulang, ke e patemehi a pwooti te ni apulie wo Iésu. Ke e pii telé: «Geé pininim, ke geé taatééhi ni mulihewé! Be caa é mwonu a *Mwametau he Miiden!» ");
INSERT INTO cam_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","É ha a céiu tan ke e uti a nicepwon Galilé wo Iésu. Ke e ali lupwo apulie na lupwo apwotau, wo Simon na pii kon pie Pétéru, me André pa âjiénen, he lu ko ne pua ha a jié. ");
INSERT INTO cam_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ke e pii telu pie: «Geu âbé céing, be é bo pwo me wogeu lupwo apwotauhi apulie.» ");
INSERT INTO cam_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ke lu te necu kuti li pua telu, ke lu âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ke lé te ju piân, ke e ali Cang me Ioane, lupwo naî Zébédé, he lé teko pwoni pua ne pwo ong me caa telu. Ke e todelu wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ke lu ne caa telu, me ali ong, ke lu âcéin. ");
INSERT INTO cam_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","E engen pitihi a amu Galilé wo Iésu, ke e pacémuni ni apulie ne he ni *mwotapitihi te ni *Juif, ke e pipatemehi a *Pwooti Wâé ko a Mwametau he Miiden. Ke e pwo me tieden ati ni cunu me ni picani te ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ke lé téne jepule kon, pitihi a province Siri. Ke lé pébé céiieng ni béén na lé mu he ni picani, me ni béé bwo pwo cunu, me ni béén na pwo duéé kolé, me nina éjén jélé, me ni béén na tebwomwa jélé. Ke e te tai pwo me tieden ni cunu kolé naa wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Hiwon ni apulie na lé âcéi Iésu: ni apulie bé mu Galilé, ke é mu ha a céiu duaan ko a Dix Villes. Ke lé âbé mu mwo Iérusaléma, me ati a amu *Judé, ke é ne gaale cemwo ne ko a éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Me e ali ni apulie na hiwon wo Iésu, he lé ko âbé, ke e taa pwo juwole, ke e tebwo, beme pacémunilé. Ke lé âbé tebwo pelen ne nina lé âcéin. ");
INSERT INTO cam_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«*Adéi nina lé pwo me piwahin jélé, be o bo a delé a *Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Adéi nina lé é, be e bo pwopweehi ne kolé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Adéi nina bwala ni pwonimelé, be bo a delé a bwohemwo ati! ");
INSERT INTO cam_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Adéi nina menelé me nimelé me lé ûdu ko ana te nime Padué kon, be e bo ne telé ati nina nimelé kon! ");
INSERT INTO cam_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Adéi nina lé pipati, be e bo pipatilé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Adéi nina mang ni pwonimelé ne ko Padué, be lé o bo alieng! ");
INSERT INTO cam_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Adéi nina lé pébé a péém, be e bo pii kolé wo Padué pie ni naîn! ");
INSERT INTO cam_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Adéi nina pitéétilé ko a bwo piténedehi nen delé a pwooti te Padué, be o bo a delé a Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Adéikewé, heme lé pitakewé, ke heme lé pwotahi ne kowé, ke hemepie lé getikewé, watihen woéo. ");
INSERT INTO cam_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Be lé caa te wonaa te ni péroféta na lé ânebuhewé. Kehe geé pipwodéén me pituume, be geé bo hegi a ceme ni penem dewé na ubwo ne jeda he *miiden!» ");
INSERT INTO cam_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Wogewé ni jié pwo a bwohemwo. Kehe mepie patieden a neme a jié, ke he genye o woté ace bwopwonen me nye ne mwo ace nemen? O caa te piticenaado ne kon, ke o tahi ole pwomwo, ke lé o engen pwon ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","«Wogewé ni pwéélang pwo bwohemwo, pwohewii a pwomwo ubwo na e mu pwo juwole, be o pwocoon me nye neduwohi. ");
INSERT INTO cam_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ke piwien mwo ne ko a mwomiû, be time nye uce ne miû ko a mwomiû, me nye talui ko ace cio! Kehe genye ne da ko miiden, beme e pwéélang ati ko ni apulie na lé mu ha a mwa. ");
INSERT INTO cam_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ke wâé heme wonaa a pwéélang kowé! Wâé heme tuie ne he pwahamii ati ni apulie. Ke é mulang, ke lé o alihi ni naado na wâé na geé pwo, ke lé o pipaunu Padué Caa tewé na e jeda he miiden.» ");
INSERT INTO cam_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Geé nemwo niimihi pie é tuie me é pwo me tieden ni *patén de Moosé, me ni bwopiinen de ni péroféta. Kehe time é uce âbé beme é pétaabwon, kehe é tuie beme é punuun. ");
INSERT INTO cam_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Geé téne ehi, be é pii tewé a juuju pie: Hemepie e mwo teko mu a miiden me a bwohemwo, ke time o uce pétaabwon ace céiu atii mu ko ni patén, dieli ko ace bwo pacuwohi na ati ni naado. ");
INSERT INTO cam_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","«É mu ko anaa, ke wo pace apulie celi e tahi taabwon ace céiu patén celi te ju wahin, ke me e picaa te ni béén me lé pipwohewiieng, ke wo panaa, ke te junihe wahin nang ne ha a Mwametau he Miiden. Kehe wo pa apulie na e âcehi ni patén, ke me e picaa te ni béén me lé wonaa, ke wo panaa, ke te junihe ubwo nang ne ha a Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Éa, wâé heme ubwo a bwo piténedehi ne ni patén de Padué tewé, koja a bwo piténedehi nen de ni *dotéén ko patén, me ni *Farasaio. Be mepie time uce wonaa, ke o time geé uce taa ha a Mwametau he Miiden.» ");
INSERT INTO cam_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Geé te temehi pie, e caa pii wo Padué te ni watihenye, pie: Go nemwo taunuhi apulie. Be wo paceli e taunu pace céiu, ke o pééeng nge céii pa atautinaado, me e pwocuhinaado ten. ");
INSERT INTO cam_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kehe woéo, ke é pii pie: Hemepie go okéé ne ko pace céiu acéihi béém, ke go bo cuwo he pwahamii Padué, ke e bo tautiko. Ke heme go pii te pace céiu béém pie: “Pipenem a punim!”, ke mepie go pii me ta nang, ke go ucéihi a cuhinaado na te junihe ubwo, ne ha a miû. ");
INSERT INTO cam_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","«Ke é hemepie go pébé a âpipati tem ne ha a *mwaiitihi, ke me e âbé ne ha a pwonimem aceli piehadeniiu me pa béém acéihi, ");
INSERT INTO cam_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ke wâé heme go mwo ne lang a âpipati tem. Ke go mwojuia ngemwo me geu mi pipwopweehi me pa âjiénem. Ke nebwén, ke go bo mwojuia mwo me go bwobe ne a âpipati tem. ");
INSERT INTO cam_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","«Me mwo ko wogo he pwaaden nge ha a mwotautinaado, me pana e neko ha a tautinaado, ke geu mi pipwopweehi me weeng. Be koli e bo neko te pa atautinaado me e pwocuhinaado tem, ke me e neko te ni pwoli, me lé neko he karépu. ");
INSERT INTO cam_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ke é pii tem a juuju pie: O time go uce wie mu he karépu, hemepie mwo time go uce téele pwocuhi ati ni cuhinaado tem!» ");
INSERT INTO cam_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Geé te temehi pie, e caa pii wo Padué pie: Go nemwo pibune. ");
INSERT INTO cam_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","«Kehe woéo, ke é pii pie: Hemepie go te ju ome ê mwode pace céiu, ke me nimem kon, ke pwohewiin heme geu caa teko pipule me weeng. ");
INSERT INTO cam_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Be hemepie watihen a naamiim ne pwo jui me go tupwo ne ha a ta, ke go pétaabwon, ke go tahi nge ité kojako! Be o wâé ne kom hemepie tieden ace céiu duaa éém, kojan heme hején a éém, ke me o tahiko ne ha a miû! ");
INSERT INTO cam_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ke mepie watihen a im ne pwo jui me go pwo ana ta, ke go tahagéi, ke go tahi taabwon nge ité kojako! Be wâé hemepie tieden ace céiu duaa éém, kojan hemepie hején a éém, ke me go â ha a miû!» ");
INSERT INTO cam_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Geé te temehi pie, caa pii mwo pie: Wo pana e cibéé ê mwoden, ke wâé heme e pwo ace tii me pitahagéi piaten. ");
INSERT INTO cam_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kehe woéo, ke é pii pie: Go nemwo cibéé ê mwodem na time uce ê abune aiu. Be koli go bo cineeng me e bune aiu, hemepie lu piaten mwo me pace céiu. Ke wo pace céiu apulie celi e pééeng me ê mwoden, ke e bune toomwo.» ");
INSERT INTO cam_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Geé te temehi mwo pie, e caa pii wo Padué te ni watihenye pie: Go nemwo gele ne ha a *piapwo tem. Wâé heme go pajuujuhi a piapwo tem ne he pwahamii Padué. ");
INSERT INTO cam_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kehe woéo, ke é pii pie: Go nemwo piapwo! Go nemwo piapwo da he miiden, be atebwo iitihi te Padué, ");
INSERT INTO cam_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ai, é pwo bwohemwo, be é he na nelang ni an, ai é *Iérusaléma, be a pwomwo ubwo te Padaame ubwo. ");
INSERT INTO cam_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ke go nemwo piapwo ne pwo punim, be time uce jan me go pwo me pwojo ai bwiile ace apun celi céiu. ");
INSERT INTO cam_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kehe go te ju pii cehi pie “éa”, heme nimem, ke “ûhu”, heme muhi tem. Be ni béé behin, ke e âbé mu ko *Caatana, pana ta nang.» ");
INSERT INTO cam_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Geé te temehi pie, caa pii pie: Naamiim me de a naamiing, ke a pecuwom me de a pecuwong. ");
INSERT INTO cam_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","«Kehe woéo, ke é pii pie: Mepie e pwo aceli ta ne kom wo pace céiu apulie, ke go nemwo taacu ne ten. Ke me e ahi a kwoom ne pwo jui, ke go ne ten mwo a céiu. ");
INSERT INTO cam_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ke mepie e pééko nge ha a mwotautinaado wo pace céiu apulie, ke me e pé a cimii tem, ke go ne ten mwo a palito tem. ");
INSERT INTO cam_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ke mepie e cuwokom wo pace céiu apulie me go engen he celi céiu kilomètre, ke go engen he celi alo me weeng. ");
INSERT INTO cam_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ke é hemepie e ilehi kojako ace céiu naado wo pace céiu apulie, ke go ne ten. Ke é hemepie e ilehi, ke me e bo te ne tem mwo, ke go nemwo biteko ne kon.» ");
INSERT INTO cam_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Geé te temehi pie, caa pii pie: Go pwo me eânimem de ni béén. Ke: “Go tééti ni béén na lé téétiko.” ");
INSERT INTO cam_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kehe icehi ana woéo, ke é pii pie: Geé pwo me eânimewé te nina lé téétikewé, {ke geé adéi lépwona lé apwokewé}, ke geé pwoiitihi me de nina lé pwo me geé mu he ni picani. ");
INSERT INTO cam_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Be, me geé wonaa, ke wogewé lépwo naî Padué, pa Caa tewé na e jeda he miiden. Be e pwo me téale ne ko nina wâé jélé, me nina ta jélé. Ke e pwo me ute ne ko nina wâé jélé, me ni béén na time uce wâé jélé. ");
INSERT INTO cam_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","«Be mepie te ju eânimewé cehi te nina eânimelé tewé, ke o ade ace cemewé mu pele Padué? Be wo lépwo *atai mwani cuhi puni apulie, ke lé te pwo mwo anaa! ");
INSERT INTO cam_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ke mepie geé te pwobwocu me adéi cehi ni bééwé, ke ade aceli geé pwo celi nihe piwâé? Be lé te pwo mwo anaa ne ni béén na time lé uce temehi Padué! ");
INSERT INTO cam_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ke wogewé, ke wâé heme geé pwoiipikewé ati ne he ni pipwoééhe, pwohewii pa Caa tewé na e jeda he miiden.» ");
INSERT INTO cam_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","E pii mwo wo Iésu pie: «Wâé heme go pwo ana te nime Padué kon, me pajuujuhi ni patén. Kehe icehi ana go pipwocileko! Go nemwo pwo ne he pwahamii ni apulie, beme lé pipii me wâé go. Be me wonaa, ke o time go uce hegi ace cemem ne pele Caa na e jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ke me go ne mwani te ni béén na tice delé, ke go nemwo pihabwiiko, me pwohewii ni apipulekenye. Be lé pwo ne he ni *mwotapitihi, ke é ne he ni apimu te ni apulie ne ha a pwomwo ubwo. Be lé hane beme lé pipaunulé ne ni apulie. Ke é pii a juuju pie: Lé caa te hegi a cemelé! ");
INSERT INTO cam_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","4","«Ke wogo, ke go nemwo pihabwiiko heme go pwo ana wâé. Me go ne mwani te ni béén na tice delé ko a im ne pwo jui, ke wâé heme time e uce temehi na a im ne pwo eaamu! Be e bo ne a cemem wo Padué Caa tem na e alihi ati ni naado.» ");
INSERT INTO cam_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«Me geé pwoiitihi, ke geé nemwo pwohewii lépwo apipulekenye. Be lé cuwo heme lé pwoiitihi ne he ni mwotapitihi, me ni apimu te ni apulie ne he ni pwomwo ubwo. Be wâé telé heme lé alilé ne ni apulie. Kehe é pii tewé a juuju pie: Lé caa te hegi a cemelé. ");
INSERT INTO cam_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kehe wogo, ke me go pwoiitihi, ke go taa ha a nemwa tem, ke go capuhi a pomwa, ke go pwoiitihi te Padué Caa tem na time genye uce alieng. Be e te alihi ana go pwo ne ha aduwo, ke e bo ne a cemem. ");
INSERT INTO cam_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«Ke me geé pwoiitihi, ke geé nemwo pwo jame cihe pwohewii ni béé apulie na time lé uce temehi pa ju Dué. Be lé te niimihi pie, e o te ténelé ko nina hiwon na lé pii. ");
INSERT INTO cam_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ke geé nemwo pipwohewiilé, be e te temehi nina nimewé kon wo Padué Caa tewé, ânebuhe ni bwo pi-ile tewé. ");
INSERT INTO cam_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«Kehe geé woni ko ace bwo pwoiitihi tewé: “Caa teme jeda he miiden, wâé heme paciitihi a niim. ");
INSERT INTO cam_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Wâé heme e âbé a Mwametau tem. Wâé heme pwo ana te nimem kon ne éni pwo bwohemwo, me pwohewii ne jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Go ne teme ce wiinaado celi jan ne kome ati he ni tan. ");
INSERT INTO cam_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Go pineuhi ni ta pwo teme, pwohewiin he geme pineuhi ni ta na lé pwo teme. ");
INSERT INTO cam_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Go nemwo nekeme he ni tacebwén. Go celuimikeme koja a ta. {Be te etem a Mwametau, me a junuum me *a wâé tem, dieli mwo. Amen!}” ");
INSERT INTO cam_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«Be é pii tewé pie: Me geé pineuhi ne te ni béén ni ta pwo telé, ke e o pineukewé mwo wo Padué Caa tewé jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ke mepie time geé uce pineuhi ni ta pwo te ni béén, ke time e o uce pineukewé ko ni ta pwo tewé wo Caa tewé.» ");
INSERT INTO cam_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«Me geé *pipaciile (me geé patupwo wiinaado, beme geé pwoiitihi), ke geé nemwo pihabwiikewé, pwohewii ni apipulekenye. Be lé habwii ne he ni pwahamiilé pie lé pipaciile, beme lé o alilé ati ne ni apulie. É pii tewé a juuju pie: Lé caa te hegi ni cemelé. ");
INSERT INTO cam_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kehe wogo, ke me go pipaciile, ke go puu a pwahamiim, ke go timi a punim. ");
INSERT INTO cam_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Ke o time lé uce alihi ne ni apulie pie go pipaciile. Kehe te icehi Padué Caa tem, na time genye uce alieng, na e alihi ana go pwo ne ha aduwo, ke e bo ne ace cemem.» ");
INSERT INTO cam_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Geé nemwo hane ni wâé pwo bwohemwo, be koli bo bune kojakewé, ai koli bo muti, ke nyaale tieden. ");
INSERT INTO cam_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kehe geé taineibuhi ni naamuuwé ne pele Padué ne he miiden. Be time o uce paale, ke time o uce ili ne naado. Ke time o uce nyaale, ke muti, ke te tice abune lang. ");
INSERT INTO cam_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Be é he na e lang ni naamuum, ke e lang a pwonimem. ");
INSERT INTO cam_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Go téne, ni naamiim, ke a pwéélang ko a éém. Ke me te wâé ni naamiim, ke e te mu ha a pwéélang ati a éém. ");
INSERT INTO cam_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ke me ta ni naamiim, ke ati a éém, ke e mu ha a melepiing. Ke me e â melepiing na a pwéélang na e kom, ke o te junihe melepiing kuti!» ");
INSERT INTO cam_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Te tice pace apulie celi jan ne kon me pa apipenem de lupwoce daame celi alo julu, ati ha a pwonimen. Be e o pipenem ehi te pace céiu, ke e o tééti pa céiu. Kehe time uce jan me geé tai pipenem de Padué me a mwani.» ");
INSERT INTO cam_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«Weengaa a watihen me é pii tewé pie: Geé nemwo gia ko ni mulihewé me ni ééwé. Geé nemwo tee pitahimwokewé pie: “Genye o bo wii de?” ke “Genye o bo cuwohe ce de?” Be a mulihewé, ke junihe pwonaado ne kon koja a wiinaado; ke a ééwé, ke junihe pwonaado ne kon koja a epwén! ");
INSERT INTO cam_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","«Geé omehi ni meni, be time lé uce picemi, me pitii âdaanu, ke time lé uce pine ehi wiinaado ne ko ni tan. Be te wo Padué Caa tewé jeda he miiden na e pawiinaadonilé. Kona wogewé, ke time geé uce piwéden koja ni meni? Uhuu! ");
INSERT INTO cam_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Time uce é mu ko a bwo gia, celi geé o mwo ne mwo aceli céiu tan, ne he ni mulihewé! ");
INSERT INTO cam_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","«É mu ko ade na geé gia mwo ko ce epwénewé? Geé cuwoteeke alihi ni muun, be lé cim ne he meté, ke time lé uce péi ke wolinaado. ");
INSERT INTO cam_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ke é pii tewé pie: Wo pa daame *Solomona, ati ha a wâé ten, ke ni epwénen, ke time uce junihe wâé koja a muun na te ju céiu. ");
INSERT INTO cam_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","«Ke geé cuwoteeke alihi ni meté: E cim jenaa, ke o cini meé ne pwo miû. Kehe wo Padué, ke e te ne ni epwénelé. Ke kona time e o uce ne ce epwénewé celi piwéden? Te junihe wahin kuti ni céihi tewé! ");
INSERT INTO cam_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","«Geé nemwo gia me geé pii pie: “Genye o wii de, me ûdu de?” ke “Nye o cuwohe ce de?” ");
INSERT INTO cam_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Be ni béén na time lé uce temehi Padué, ke time lé uce mwaale ko a bwo hane ninaa. Kehe icehi ana wogewé, ke e te temehi nina nimewé kon wo Padué Caa tewé na e jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Geé hane ânebun a *Mwametau he Miiden, ke geé pwo nina nime Padué kon, ke e bo ne tewé ati nina tice tewé. ");
INSERT INTO cam_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ke é pii mwo tewé pie: Geé nemwo gia ko a tan meé, be a tan meé, ke e bo te pwo a penem den. A gia jenaa, ke te é jenaa.» ");
INSERT INTO cam_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","E pii mwo wo Iésu pie: «Geé nemwo tauti ni béén, beme e o nemwo tautikewé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Be e o bo tautikewé wo Padué pwohewii a bwo tautilé tewé, ke e o bo pwo tewé nina geé pwo telé! ");
INSERT INTO cam_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","4","Go te ju alihi ehi a meté na e hamii pa âjiénem. Kehe time go uce alihi a ba-acuwo na ubwo na e hamiim! Ke go woté ko ace bwopiinen de pa béém pie: “Go ne me é pétaabwon a meté na e hamiim”? ");
INSERT INTO cam_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","«Wogo, ke pa apipulekenye, kehe bwi go! Go mi pétaabwon a ba-acuwo na ubwo na e hamiim! Ke é mulang, ke go bwobe ali ehi ace bwo pétaabwon na a meté na e hamii pa âjiénem! ");
INSERT INTO cam_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«Geé wéihi ehi nina wâé, na e âbé mu ko Padué. Be time nye uce ne te ni wotaahen nina iitihi, be koli lé o bitelé ne mwo konye me lé wiikenye. Ke time genye uce tahi ne te ni puwokwo ni perle na te junihe ubwo ni cuhin, be lé o bo caaite.» ");
INSERT INTO cam_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Wâé heme geé tee ilehi taaci koja Padué be e bo ne tewé. Ke geé tee hane taaci, be geé bo tooli. Ke geé tee cii taaci a pomwa, be e o bo tehi ne tewé. ");
INSERT INTO cam_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Éa, be wo pana e ilehi, ke o bo ne ten. Ke wo pana e hane, ke e o tooli. Ke wo pana e cii a pomwa, ke o tehi ne ten. ");
INSERT INTO cam_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","«He woo mu hadeniiwé, celi e o ne ace péi te pa naîn, hemepie e ilehi kojaeng ace pwoloa? ");
INSERT INTO cam_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ke he woo celi e o ne ten ace bwien, hemepie e ilehi ace ikua? ");
INSERT INTO cam_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Be wogewé lépwo apulie na ta gewé, kehe geé temehi ne nina wâé te ni naîwé. Ke me wonaa, ke wo Padué Caa tewé jeda he miiden na te junihe wâé nang ke e bo ne ce naado celi te junihe wâé wéden te lépwona lé ilehi kojaeng.» ");
INSERT INTO cam_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«Geé pwo ne te ni béén ce naado celi nimewé me lé pwo ne tewé. Weengaa kuti a âne ni *patén de Moosé, me ati ni tii te ni péroféta.» ");
INSERT INTO cam_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Geé taa ha a pomwa na picu. Be ubwo a pomwa nge ha a duaan na e patiedenikenye ne hen dieli mwo. Be ticecoon a bwo â ha a pwaaden naa, ke hiwon nina lé â hen. ");
INSERT INTO cam_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ke te junihe picu a pomwa nge ha *a ju mulip, ke pwocoon a bwo â hen. Ke time uce hiwon nina lé tooli.» ");
INSERT INTO cam_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Geé pipwocile lépwo péroféta agele! Be lé o âbé céiikewé he lé pwohewii ni muto, kehe icehi ana lépwo wota apiwii. ");
INSERT INTO cam_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Geé o te temehilé mu ko ni bwo penem delé. Be time genye uce tabwo ace tabe megele mu ko ace éé muceni! Ke time genye mu uce tabwo ace majing mu ko ace acuwo celi pwo dan! ");
INSERT INTO cam_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Be a acuwo na wâé, ke e te ne ni acehin na wâé me wii ke pwocoon me e ne ce acehin celi ta. Ke a acuwo na ta, ke e ne ni acehin na ta, ke pwocoon me e ne ce acehin celi wâé. ");
INSERT INTO cam_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ke o tahagéi a acuwo na time e uce ne ce acehin celi wâé, ke o tahieng da pwo miû. ");
INSERT INTO cam_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","«Ke te piwien ne ko lépwo péroféta agele, be geé o temehilé mu ko ni penem delé.» ");
INSERT INTO cam_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Mepie nimem me go tuie da ha a *Mwametau he Miiden, ke time go uce ju cuwo ko pii cehi pie: “Padaame, Padaame!” Wâé heme go pwo mwo ana nime Caa tong kon na e jeda he miiden! ");
INSERT INTO cam_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Be é ha a Tan na e bo tauti ni apulie hen wo Padué, ke o hiwon nina lé o pii tong pie: “Padaame, Padaame, geme mu patemehi a pwooti tem, ke peni ni duéé ne he niim. Ke hiwon ni penem na geme pwo ko a junuum!” ");
INSERT INTO cam_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","«Ke é bo te ju pii telé gaale pie: Time é uce temehikewé. Geé engen kojaéo, be wogewé, ke lépwo apwo ne nina ta! Be time geé mu uce pwo nina nimung kon.» ");
INSERT INTO cam_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«Wo pana e téne a pwooti tong, ke me e piténedehi, ke e pwohewii pa apulie na e tauti ehi ni naado, ke e bahi a mwa ten ne pwo a péi. ");
INSERT INTO cam_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ke e cuwo ole a ute, ke e téte a jaa, ke udan, ke e tatééhi a mwa, kehe icehi ana time e uce tupwo, be caa bahi ne pwo a péi. ");
INSERT INTO cam_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kehe wo pana e téne ni pwooti tong, ke time e uce ténedehi, ke e pwohewii pa muti na e pacuuli a mwa ten ne ha a won. ");
INSERT INTO cam_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ke e cuwo ole a ute, ke e téte a jaa, ke udan, ke e tanahi ati a mwa, ke e tupwo.» ");
INSERT INTO cam_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ke me e pii ati ni pwooti naa wo Iésu, ke lé téetihi a bwo cihe ten ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Be time e uce pwohewii ni *dotéén ko patén delé. Be e te pacémunilé mu ha a pihuô na e te ne ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","É alecehen, ke e opé mu pwo juwole wo Iésu, ke lé âcéin ne ni apulie na te junihe hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ke e âbé ne kon wo pa céiu katia. Ke e tidihi jilin he pwahamiin, ke e pii ten pie: «Padaame, hemepie te nimem, ke go pwo me tieden a katia kong!» ");
INSERT INTO cam_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ke e cine ngen a in wo Iésu, ke e ti kon, ke e pii ten pie: «Éa, te nimung! Caa wâé go!» Ke te tieden kuti kojaeng a katia kon. ");
INSERT INTO cam_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ke e pii ten pie: «Go nemwo pwojepule kon! Kehe go â pihabwiiko ne te pa *apwoâpwailo. Ke go ne te Padué ali âpwailo li e pii wo *Moosé ne he li patén den. Be me wonaa, ke me lé alihi ati ne ni apulie pie caa wâé go.» ");
INSERT INTO cam_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","E ân wo Iésu, ke e taa Kapernaüm, ke e âbé beniieng wo pa céiu caa te coda te lépwo Roma. Ke e ileeng beme e picani ten. ");
INSERT INTO cam_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Ke e pii pie: «Au Padaame, pa eabwé tong, ke e tee ko pule pwomwo, be tebwomwa nang, ke te junihe cunu nang kuti.» ");
INSERT INTO cam_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ke e hegi ne ten wo Iésu pie: «Wâé, é bo ân, be é bo pwo me tieden a cunu kon.» ");
INSERT INTO cam_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ke e hegi ne ten wo paje pie: «Ûhu, time uce jan ne kom, me go tuie nge ha a pomwa tong, be te junihe pwonaado ne kom. Kehe go te ju cihe cehi, beme o tieden a cunu ko pa eabwé tong. ");
INSERT INTO cam_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Be woéo, ke é piténede pa apihuô tong, ke é uce pihuô te ni coda. Ke me é pii te pace céiu pie: “Go engen!”, ke e engen. Ke me é pii te pace céiu pie: “Go âbé!”, ke e âbé. Ke me é pii te pa eabwé tong pie: “Go pwo ani”, ke e te pwo.» ");
INSERT INTO cam_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ke e te junihe téele wo Iésu, ke e picedi pali caa te coda. Ke e pii te lépwona lé ko âcéin pie: «Geé te ju tabemi ehi: Time é uce téele too pace apulie celi ubwo ace céihi ten pwohewii paje, ke piwien mwo ne ha a *Isaraéla, a bele te Padué. ");
INSERT INTO cam_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Éa, o bo hiwon celi lé o bo âbé ha a *Mwametau he Miiden, mu pwo a bwohemwo ati. Ke o pwo ce atebwo telé ne ha a piwiinaado ubwo me ni watihenye, *Abérama, Isaaka, me Iakobo. ");
INSERT INTO cam_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ke hemepwo é ne ko lépwona me lé taa ha a Mwametau, ke time uce jan ne kolé me lé taa. Ke o bo tahilé ole pwomwo ha a melepiing ité koja Padué! Ke lé bo é ko piwii pecuwo.» ");
INSERT INTO cam_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ke nebwén, ke e pii wo Iésu te pali caa te coda pie: «Go mwojuia ngemwo ha a pomwa tem! Be é ko a céihi tem, ke e o tuie ana go ilehi!» Ke é ha a benaamwon naa, ke caa te tieden kuti ali cunu ko pali eabwé. ");
INSERT INTO cam_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","E â ha a pomwa te Pétéru wo Iésu, ke e too ê mwaa Pétéru he e teko pule, be e pwopilijing. ");
INSERT INTO cam_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ke e pétaa ko a in wo Iésu, ke te tieden kuti kojaeng ali pilijing. Ke e cuwoda wo ênaa, ke e pwo me lé wiinaado. ");
INSERT INTO cam_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","É he babwén, ke lé pébé céii Iésu ni apulie na hiwon jélé, na pwo ni duéé kolé. É mu ko a pwooti ten, ke e peni ni duéé, me lé wie mu kolé. Ke e pwo me tieden ati ni cunu ko ni béén. ");
INSERT INTO cam_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","É nelang he na e pacuwohi ali e pii wo Padué, na e pwaadeniin bé wo péroféta Isaia pie: E caa pé ni picani tenye, ke e pé kojakenye ni cunu konye. Ésaïe 53.4 ");
INSERT INTO cam_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","É ha a céiu tan, ke hiwon ni apulie na élé aujeni Iésu. Ke me e alilé, ke e pii te lépwo acémun den pie, me lé tai gaale ko a céiu duaan ne gaale cemwo ko a jié. ");
INSERT INTO cam_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ke é mulang, ke e âbé céiieng wo pa céiu *dotéén ko patén, ke e pii ten pie: «Pa apipune, nimung me é âcéim, na ati he ce piduaan celi go bo â hen.» ");
INSERT INTO cam_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ke e hegi ne ten wo Iésu pie: «Ni wota apiaba, ke pwo ni amwaale telé; ke ni meni, ke pwo ni mwonahilé. Kehe woéo, pa *Nahi Apulie, ke te tice duaan celi me é mwaale hen.» ");
INSERT INTO cam_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ke piwien mwo ne ko pace céiu apulie celi nimen me e âcéi Iésu, be e pii ten pie: «O te jan me é mwo mi â pineduwo caa tong?» ");
INSERT INTO cam_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ke e hegi ne ten wo Iésu pie: «Ûhu, go âbé céing, ke go necu ni amele, me lé te pineduwolé!» ");
INSERT INTO cam_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","E taa pwo ong wo Iésu, ke lé âcéin wo lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Alecehen, ke e tabuhi tahieng me ubwo a dan, ke e taa jié ha ali ong. Ke mepwo wo Iésu, ke e teko pule ha ali ong. ");
INSERT INTO cam_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ke lé paûmiêeng wo lépwo acémun den, ke lé pii ten pie: «Padaame! Go celuimikenye, be genye o caa mwiiê!» ");
INSERT INTO cam_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ke e pii telé pie: «É mu ko ade na mwotikewé? Te junihe wahin kuti ni céihi tewé!» Ke e cuwoda, ke e cihe okéé ne ko ali dan me a jié. Ke e cuwo ali ta-amu, ke te ju au kuti. ");
INSERT INTO cam_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ke lé téetihi, ke lé pipii telé pie: «He woo pa apulie ce, na lu piténedeeng a dan me a jié?» ");
INSERT INTO cam_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lé tuie ngen wo Iésu me lépwo acémun den ha a duaan ne gaale cemwo ne pejié Galilé ne ha amu Gadara. É ne ha amu naa, ke pwo lupwo apulie na pwo duéé kolu. Ke te junihe mwoti ni apulie kolu, be lupwo a-okéé, ke te junihe pwo niihelu. Ke time lé mu uce piâ ha a duaan naa. Ke me lu ali Iésu, ke lu te wie kuti mu he iitihi, ke lu opé beniieng. ");
INSERT INTO cam_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ke lu toii da pie: «Pa *Naî Padué, ade aceli nimem me go pwo temu? Nimem me go pwocuhinaado temu, ânebuhe ace benaamwon ko pwocuhinaado?» ");
INSERT INTO cam_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","31","Ke lé cuwokon ne li duéé, ke lé pii ten pie: «Mepie go pawiekeme, ke go pwo me geme gaale he ni puwokwo ne!» Be pwo a pubu puwokwo, na lé teko um ne gaale cemwo. ");
INSERT INTO cam_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ke e hegi ne telé pie: «Geé ân!» Ke lé wie mu ko lupwoli apulie, ke lé taa he li puwokwo. Ke lé te téte kuti ne li puwokwo mu pwo ali juwole ole he jié. Ke lé tai mwiiê nelang. ");
INSERT INTO cam_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ke wo lépwo awéihi puwokwo, ke lé te téte kuti nge ha a mwopopwaalé. Ke lé piuti ati a jepule ko ana e tuie ne ko lupwo apulie naa. ");
INSERT INTO cam_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ke lé te tai âbé kuti céii Iésu ne ni apulie mu ha a mwopopwaalé. Ke me lé alieng, ke lé wâgo kon pie, me e engen mu ha amu telé. ");
INSERT INTO cam_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","E mwojuia mwo wo Iésu pwo ong ne ha a mwopopwaalé Kapernaüm he na e pimu lang. ");
INSERT INTO cam_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ke lé âbé céiieng ne ni apulie, he lé pipaadoimibé ne pwo a apule pace céiu béélé na tebwomwa nang. Ke me e alihi a céihi telé wo Iésu, ke e pii te pali tebwomwa pie: «Go mwoiu, go pa bééng! Be caa pineuhi ni ta pwo tem!» ");
INSERT INTO cam_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ke wo lépwo béé *dotéén ko patén na lé mu lang, ke lé piniimihi pie, ‘E pii me ta Padué wo pa apulie ce be e pwo me piwielu me weeng!’ ");
INSERT INTO cam_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","E te temehi nina lé niimihi wo Iésu, ke e pii pie: «É ko ade na ta ni pwonimewé? ");
INSERT INTO cam_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ade aceli piticecoon? Me é pii ten pie: “Caa pineuhi ni ta pwo tem”, ai me é pii ten pie: “Go cuwoda, ke go engen”? ");
INSERT INTO cam_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ke hemepie jan me é pwo me e engen ne ânebuhewé ati ke geé bo temehi pie, pwo mwomwon dong, woéo, pa Nahi Apulie, me é pineuhi ni ta pwo te ni apulie ne pwo bwohemwo.» Ke e pii te pali tebwomwa pie: «Go cuwoda, ke go pé apule tem, ke go âmwo pelem.» ");
INSERT INTO cam_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ke e te cuwoda kuti wo pali, ke e âmwo ha a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ke me lé alihi anaa ne ni apulie, ke mwotilé. Ke lé pipaunu Padué, be e ne ni *pipwojunuun na ubwo te ni apulie! ");
INSERT INTO cam_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","E engen wo Iésu, ke e ali pa apulie na pii kon pie Mataio, pa *atai mwani cuhi puni apulie me de lépwo Roma he e ko tebwo ha a mwotai mwani ten. Ke e pii ten wo Iésu pie: «Go âbé céing!» Ke e te cuwoda kuti wo panaa, ke e âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","É alecehen, ke lé wiinaado pele Mataio wo Iésu me lépwo acémun den. Ke hiwon ni apulie na lé piwiinaado me woélé: wo lépwo atai mwani, me ni béé apulie na ta ni mulihelé. ");
INSERT INTO cam_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ke me lé alihi anaa wo lépwo *Farasaio, ke lé pii te lépwo *acémun de Iésu pie: «É mu ko ade na wo pa caa tewé, ke lé piwiinaado me lépwo atai mwani, ke ni béé apulie na ta jélé?» ");
INSERT INTO cam_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ke e te ténelé wo Iésu, ke e pii telé pie: «Time lé uce hane ce dotéén wo lépwona te wâé jélé, kehe te icehi lépwona cunu jélé. ");
INSERT INTO cam_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wâé heme geé temehi a bwopiinen na e pii wo Padué pie: Time uce a *âpwailo ko wota ana wâé tong. Kehe nimung ko a pipwoééhe. «Be time é uce âbé tode nina lé niimihi pie wâé ni mulihelé. Kehe é âbé tode nina lé temehi pie ta ni mulihelé.» ");
INSERT INTO cam_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Lé tuiebé pele Iésu wo lépwo béé acémun de *Ioane pa apipuu apulip. Ke lé pii ten pie: «Wogeme, me lépwo Farasaio, ke geme te cuwo ko *pipaciile. Be geme patupwo wiinaado beme geme pwoiitihi. Kehe é ko ade na time lé uce pipaciile wo lépwo acémun dem?» ");
INSERT INTO cam_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ke e hegi ne telé wo Iésu pie: «Kona te piwahin lépwona todelé ne ko a piaten, heme e mwo teko mu pelelé wo pa apiaten? Ûhu! Be e o bo âbé a tan na o bo pé kojalé pa apiaten. Ke é mulang na lé o bobe pipaciile. ");
INSERT INTO cam_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","«Te tice pace céiu apulie celi me e pé ace memwaanu celi mwo te ju wâé, me e woli ne ko ace memwaanu celi ukéiu. Be mepie e puu a mwaanu, ke bo nihe ubwo a tie kon. ");
INSERT INTO cam_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ke geé niimihi a *mwotabe na pwo ko iiwota. Be time nye uce pé ace tabe megele celi mwo coho, me nye pa a mwotabe na caa ukéiu. Be pwocoon me cibu, ke e bo pabuwohi, ke genye o patieden a tabe megele me ni mwotabe. Ûhu! Wâé heme nye ne a tabe megele na mwo coho ne ha a mwotabe na mwo coho, beme cile ehi a tabe megele, me ali mwotabe.» ");
INSERT INTO cam_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Me e mwo ko pii telé anaa wo Iésu, ke e âbé céiieng wo pa céiu apulie na piubwo nang ne ha amu. Ke e tidihi jilin he pwahamii Iésu, ke e pii ten pie: «E mwo teko ju mele ê naîng! Go âbé ne ni im huîin, beme e o mulie mwo.» ");
INSERT INTO cam_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ke lé cuwoda wo Iésu me lépwo acémun den, ke lé âcéin. ");
INSERT INTO cam_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","É he lé ko â he pwaaden, ke e tuiebé ê toomwo na caa 12 ni jo na cunu nang hen, be e mu tuie ni benaamwon na e mu téte kon a cewéle. E piâbé alecehe Iésu, ke e ti ko a baaé epwénen. ");
INSERT INTO cam_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Be e pipii ten pie: “Mepie é te ju ti ko a epwénen cehi, ke o caa te tieden a cunu kong.” ");
INSERT INTO cam_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ke e biteeng wo Iésu, ke me e alieng, ke e pii ten pie: «Go mwoiu, go êje! Be caa wâé go, mu ko a céihi tem!» Ke te tieden kuti ali cunu kon. ");
INSERT INTO cam_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","E tuie wo Iésu nge ha a pomwa te pa apulie na piubwo nang. Ke e ali lépwo acuu oopwé he lé caa ko piwâam ne ko a pineduwo, ke te junihe ubwo kuti ni pwocihe lang. ");
INSERT INTO cam_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ke e pii telé pie: «Geé engen! Geé ko pii pie e caa mele; kehe woéo, ke é pii pie e teko ju puluta!» Ke lé pihoonieng. ");
INSERT INTO cam_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ke e tai pawielé wo Iésu, ke e taa ha ali mwa. Ke e pétaa ko a i êgi cuwo nahi toomwo, ke e te cuwoda kuti. ");
INSERT INTO cam_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ke lé te piuti kuti pitihi a duaan naa a jepule kon. ");
INSERT INTO cam_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","É mulang, ke e engen wo Iésu. Ke lu âcéin wo lupwo bwi na alo julu, he lu ko toii céin pie: «Pa *Naî Davita, go pipwoééhemu!» ");
INSERT INTO cam_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ke me e tehene nge pelen wo Iésu, ke lu âbé céiieng wo lupwoje. Ke e pii telu pie: «Kona geu caa teko céihi kuti pie, jan ne kong me é pwo anaa?» Ke lu hegi ne ten pie: «Éa, go Padaame.» ");
INSERT INTO cam_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ke e pétaa ko ni naamiilu wo Iésu, ke e pii telu pie: «Wâé heme pwo ne teu ana geu céihi ne kon!» ");
INSERT INTO cam_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ke lu caa te niê kuti. Ke e pii mwoiuhi telu pie: «Geu nemwo pwojepule ko nina é pwo teu!» ");
INSERT INTO cam_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kehe icehi ana he lu wie, ke lu pwojepule ko nina e pwo wo Iésu, pitihi a amu naa. ");
INSERT INTO cam_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ke me lu engen koja Iésu wo lupwoje, ke lé pébé céiieng pa apulie na huuhu nang, be pwo duéé kon. ");
INSERT INTO cam_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ke e peni ali duéé wo Iésu, ke e te cihe kuti wo pali huuhu. Ke lé téetieng ati ne ni apulie na lé mu lang, ke lé pii pie: «Time genye mu uce alihi celi wonaa, ne ha amu *Isaraéla!» ");
INSERT INTO cam_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kehe icehi ana lé pii wo lépwo Farasaio pie: «E peni ni duéé ko a junuu *Caatana, pa daame he ni duéé!» ");
INSERT INTO cam_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","E engen he ni pwomwo ubwo ke ni mwopopwaalé wo Iésu. Ke e pacémuni ni apulie ne he ni *mwotapitihi. Ke e patemehi a Pwooti Wâé ko a Mwametau he Miiden. Ke e pwo me tieden ni cunu me ni picani. ");
INSERT INTO cam_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ke me e alihi a pubu apulie, ke e te junihe pipwoééhelé. Be caa mwaale jélé, ke pitupwo jélé, pwohewii ni muto na tice awéilé. ");
INSERT INTO cam_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ke e pii te lépwo acémun den pie: «Nihe ubwo a pitii âdaanu na me pwo, kehe icehi ana time uce hiwon ni apenem. ");
INSERT INTO cam_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Geé pwoiitihi, me ilehi koja pa eapwihi apwoamu, me e ne mwobé ce béé apenem, beme lé pitii âdaanu.» ");
INSERT INTO cam_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","E tode lépwo 12 *apostolo ten wo Iésu, ke e ne telé a pihuô beme lé peni ni duéé, ke me lé pwo me tieden ni cunu me ni picani te ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Weengi ni nii lépwo 12 apostolo: Simon, na pii mwo kon pie Pétéru; André, pa âjiénen; Cang, pa naî Zébédé; Ioane, pa âjiéne Cang; ");
INSERT INTO cam_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip; Bartélemi; Toma; Mataio, pa *atai mwani cuhi puni apulie; Cang, pa naî Alfé; Tadé; ");
INSERT INTO cam_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, pa Zélote; Judas Iscariot, pana e bwo pipwohuô te Iésu. ");
INSERT INTO cam_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","E pahede lépwo 12 apostolo naa wo Iésu, me lé â he ni amu. Ke e ne ni pihuô telé, ke e pii telé pie: «Geé nemwo â pele ni apulie na time uce lépwo *Juif. Ke geé nemwo taa he ni mwopopwaalé ha amu *Samari. ");
INSERT INTO cam_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kehe geé te â céii cehi ni apulie *Isaraéla, be lé pwohewii ni muto na lé pipatieden. ");
INSERT INTO cam_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ke geé pipatemehi nge he pwaaden pie: “Caa é mwonu a *Mwametau he Miiden.” ");
INSERT INTO cam_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","«Ke geé pwo me tieden ni cunu, ke geé pwo me lé mulie ni amele, ke geé pwo me wâé ni katia, ke geé peni ni duéé mu ko ni apulie. Be ana geé hegi he te tice cuhin, ke wâé heme geé ne mwo, me te tice cuhin. ");
INSERT INTO cam_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ke me geé engen, ke geé nemwo pé ce mwani megele, ai mwani pwojo. ");
INSERT INTO cam_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ke geé nemwo pé ce élele, me ce dihibwaawé, me ce bwajaawé. Geé te cuwohe ace epwén celi te céiu, be wo pa apenem, ke wâé heme e hegi a wiinaado ten me a cemen. ");
INSERT INTO cam_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","«Hemepie geé taa ha ace céiu pwomwo ubwo, ai ace céiu mwopopwaalé, ke geé hane pace apulie celi jan ne kon me e hegikewé. Ke geé mu pelen dieli geé bo engemwo mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ke me geé taa ha ace céiu pwomwo, ke geé *adéi a pwomwo naa. ");
INSERT INTO cam_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ke me lé hegikewé ehi, ke e o mu pelelé a adéihi, ke mepie time lé uce hegikewé ehi, ke geé te pémwojuiéhi mwo a adéihi tewé. ");
INSERT INTO cam_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","«Ke mepie te tice apulie celi lé hegikewé me tabemi ni pwooti tewé ne ha ace céiu duaan, ke geé wie mulang, ke geé tagiliihi ni muu pule ko ni awé beme geé habwii pie time uce wâé ni huô telé. ");
INSERT INTO cam_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ke é pii tewé a juuju pie: É ha ace Tan celi e bo tauti ni apulie hen wo Padué, ke o te junihe ubwo ace cuhinaado telé koja lépwo *Sodome me Gomore li te junihe ta ni huô telé.» ");
INSERT INTO cam_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Geé téne! É pahedekewé pwohewii ni muto nge ha awieme ni wota apiwii. Wâé heme geé piengen cile pwohewii ni bwien, ke me bwala gewé pwohewii pa meni pwojo. ");
INSERT INTO cam_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Be lé o imwikewé, ke lé o péékewé nge he ni mwotautinaado. Ke lé o tatikewé ko bwaliiwota ne he ni *mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ke lé o teuukewé nge he pwahamii ni gupéno me ni daame, beme lé tautikewé, wonaa mu kong. Wonaa beme ne tewé beme geé cihe telé kong, é ne mwo he pwahamii nina time uce ni Juif. ");
INSERT INTO cam_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","«É heme lé bo péékewé, ke geé nemwo pwo me gia gewé ko ce bwopiinen telé. Be é ha a benaamwon naa, ke wo Padué, ke e bo te ne tewé ce pwooti celi me geé pii. ");
INSERT INTO cam_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Be time o uce wogewé celi geé o cihe, kehe a Jene pa Caa tewé na e bo cihe kowé. ");
INSERT INTO cam_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","«É ha a benaamwon naa ke wo pa céiu apulie, ke e o bo ne pa âjiénen beme taunueng. Ke e o wonaa mwo wo pa caa te ewa ne ko pa naîn. Ke ni ewa, ke lé bo cuwode ni nyaa me caa telé, beme lé taunulé. ");
INSERT INTO cam_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ke lé o téétikewé mu kong ati ne ni apulie. Kehe wo paceli e bo cumang die ha anebwén ko a mulihen ke e o bo celuimieng wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","«Ke me lé pwo me geé picani ne ha ace céiu pwomwo ubwo, ke geé cela nge ha ace céiu. É pii tewé a juuju pie: Mwo time geé uce engen ati he ni pwomwo ubwo Isaraéla, ke é o caa mwojuia mwo, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«É pii tewé pie: Wo pa acémun, ke time e uce piwéden koja pa apacémunieng. Ke wo pa apenem, ke time e uce piubwo nang koja pa daame hen. ");
INSERT INTO cam_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Be wo pa acémun, ke wâé heme e pwohewii pa apacémunieng. Ke wo pa apenem, ke wâé heme e pwohewii pa daame hen. Be mepie lé pii ko pa eapwihi pwomwo pie, Caatana, ke lé o te junihe pii me ta mwo nina élé ha a pwomwo naa.» ");
INSERT INTO cam_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«Geé nemwo pwo me mwotikewé ko ni apulie. Be ati ni naado na neduwohi, ke o bo habwii. ");
INSERT INTO cam_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ke ni naado na é pii tewé neduwohi, ke geé pii beetihi ne ha a pwéélang. Ke ni naado na pii ne he pwojéénewé, ke geé pii beetihi ne ha awiemewé. ");
INSERT INTO cam_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Geé nemwo pwo me mwotikewé ko ni apulie na lé taunuhi a ééwé, be time o uce jan me lé taunuhi a jenewé. Wâé heme geé pwo me mwotikewé ko Padué. Be te weeng cehi na jan me e taunuhi a ééwé me a jenewé ne ha a miû. ");
INSERT INTO cam_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","«Geé cuwoteeke alihi ni meni na wahin jélé: Nye icuhi lupwoce meni celi alo, ne ko a mwani celi te céiu. Kehe icehi ana te tice mu kolé celi e o tupwo ti ne he pule, hemepie time e uce temehi wo Padué Caa tewé. ");
INSERT INTO cam_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ke wogewé, ke e te tai temehi ati ni jéhi ni apuniwé. ");
INSERT INTO cam_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ke é mu ko anaa, na é pii tewé pie: Geé nemwo pwo me mwotikewé! Be te junihe pwonaado ne kowé ne he pwahamii Padué, koja ni meni na te nihe hiwon jélé!» ");
INSERT INTO cam_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Wo pa apulie na e pii ne he pwahamii ni apulie pie, weeng pa apulie tong, ke woéo mwo, ke é o pii mwo pie weeng ke pa apulie tong, ne he pwahamii Caa tong jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kehe wo pana e pii, ne he pwahamii ni apulie, pie time e uce temehiéo, ke woéo mwo, ke é o te pii, ne he pwahamii Caa tong jeda he miiden, pie time é uce temehieng.» ");
INSERT INTO cam_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Geé nemwo niimihi pie é âbé beme é pébé a péém ne pwo bwohemwo. Ûhu! Woéo pa watihen me time lé uce piténelé ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Be é âbé me é pineité lupwo pwéénemeewa, me lu téénemeewa, me lu amwaan. ");
INSERT INTO cam_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ke wo lépwona lé mu ha a mwa te pa apulie, ke bo woélé lépwona lé pwotahi ne kon.» ");
INSERT INTO cam_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","«Wo paceli te junihe eânimen de lu nyaa me caa ten kojaéo, ke time uce jan me pa acémun dong. Ke wo pana te junihe eânimen de pa naîn, me ê naîn kojaéo, ke time uce jan me pa acémun dong. ");
INSERT INTO cam_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Wo pana time e uce canihi a *kuricé ten, me e âbé céing, ke time uce jan me pa acémun dong. ");
INSERT INTO cam_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ke wo pana nimen me e cile a mulihen, ke e o patieden. Kehe wo pana e patieden a mulihen mu kong, ke e o bo tooli *a ju mulip.» ");
INSERT INTO cam_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Hemepie e hegikewé wo pace céiu apulie, ke woéo pana e hegiéo. Ke wo pana e hegiéo, ke e hegi mwo pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ke mepie e hegi pace péroféta mu ko ana pa péroféta, ke o bo pwo ace cemen celi pwohewii ana ne te ni péroféta. Ke mepie e hegi pace céiu apulie celi e *mwomwon ne he pwahamii Padué, be e mwomwon, ke o bo pwo ace cemen celi pwohewii ana ne te pana e mwomwon. É pii tewé a juuju pie: ");
INSERT INTO cam_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mepie e ne ace mwoûdu ko tabe bwala te ace pibéé ni cuwo nahi ewa ce, be pa acémun dong, ke e bo hegi mwo ace cuhin.» ");
INSERT INTO cam_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","É he e pii ati ni pihuô naa wo Iésu te lépwo 12 acémun den, ke e engen mulang, ke e â he ni béé pwomwo ubwo ne ha a duaan naa. Ke e pacémuni ni apulie, ke e pipatemehi telé a Pwooti Wâé. ");
INSERT INTO cam_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","É he e mu he karépu wo *Ioane pa apipuu apulie, ke e téne a jepule ko Kériso, me nina e pwo. Ke e pahede lépwo béé acémun den, ");
INSERT INTO cam_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","beme lé â tahimwo Iésu pie: «He caa te wogo kuti pali *Mesia li me e bo tuiebé? Ai, me geme mwo te ucéi pace céiu?» ");
INSERT INTO cam_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ke e hegi ne telé wo Iésu pie: «Geé mwojuia mwo, me geé â piuti te Ioane nina geé téne, me nina geé alihi. ");
INSERT INTO cam_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Be lé caa niê mwo wo lépwo bwi; ke lé caa engen ehi wo lépwo tebwa; ke caa wâé mwo wo lépwona katia jélé; ke lé caa téne mwo wo lépwona bwéjé jélé; ke lé caa mulie cemwo wo lépwo amele; ke lé caa hegi a Pwooti Wâé wo lépwona tice delé! ");
INSERT INTO cam_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Adéi pana e ali temehiéo, me céihi ne kong!» ");
INSERT INTO cam_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ke me lé mwojuia mwo wo lépwo acémun de Ioane, ke e pii wo Iésu te ni apulie na lé mu lang pie: «É he li geé â ha a da me geé téne Ioane, ke he ade aceli geé â alihi? Pa apulie na pipwoééhen na e pwohewii a womeéle celi e papenemihi na a dan? ");
INSERT INTO cam_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ûhu! Ke kona he ade aceli geé â alihi? Pace céiu apulie celi e cuwohe ace epwén celi nihe wâé? Ûhu! Be nina te junihe wâé ni epwénelé, ke nina lé mu he ni pwomwo he daame! ");
INSERT INTO cam_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Te ade aceli geé â alihi? Pace céiu péroféta? Éa, ke é pii tewé pie: Wo panaa, ke pa péroféta ubwo! ");
INSERT INTO cam_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Be te wo Ioane kuti, na e piieng wo Padué ne he ni tii iitihi pie: É bo neole pa apipépwooti tong. E bo ânebuhem, me e pwopweehi a pwaadeniim.» Malachie 3.1 ");
INSERT INTO cam_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","E pii mwo wo Iésu pie: «É pii tewé a juuju pie: Te tice pace apulie pwo bwohemwo, celi e piwéden koja Ioane pa apipuu apulie. Kehe icehi ana wo pana te nihe wahin nang ne ha a *Mwametau he Miiden, ke te nihe piubwo nang koja Ioane. ");
INSERT INTO cam_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tabuhi ha a benaamwon na e pipuu apulie wo Ioane dieli jenaa, ke lé hane ne ni apulie, me lé ne, ne éni pwo bwohemwo, a Mwametau he Miiden ko ni niihelé. ");
INSERT INTO cam_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Be é ânebuhe Ioane, ke ni *patén de Moosé, me ati ni péroféta, ke lé pipatemehi te ni apulie pie e o caa ne a Mwametau ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Geé céihi ne ko nina é pii tewé: Wo Ioane, ke wo péroféta *Élia li me e bo âmwobé. ");
INSERT INTO cam_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","«Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","«É bo pipwohewii ne ko ace de ni apulie jenaa? Lé pwohewii ni cuwo nahi ewa na lé pidaataa ha apimu te ni apulie. Be muhi te ni béén me lé jele me ni béélé. Ke lé pii telé ni béélé pie: “Geme cuu oopwé tewé, ke time geé uce pwolu. Ke geme pwo a nyebi ko mele, ke time geé uce é!” «Ni apulie jenaa, ke pwohewii ni cuwo nahi ewa naa, ");
INSERT INTO cam_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","be e tuiebé wo Ioane pa apipuu apulie, ke e pawie wiinaado he ni béé benaamwon, ke time e uce ûdu tabe megele, ke lé pii ne ni apulie pie: “Pwo duéé kon!” ");
INSERT INTO cam_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","«Ke é tuiebé, woéo pa Nahi Apulie, ke é wiinaado me ûdu pwohewii ni béén. Ke lé pii ne ni apulie pie: “Wo paje, ke te junihe pa aûdu, ke pa awiinaado! Ke e pabéé ni atai mwani, me ni béé apulie na ta jélé!” «Kehe a juuju ana nye mu pii pie: “Nye alihi temehi a pitemang ne he ni bwomu te nina lé mulie ha a pitemang.”» ");
INSERT INTO cam_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ke e cihe me mwoiu te ni apulie wo Iésu ne he ni pwomwo ubwo ko ni *pipwojunuun na hiwon na e caa pwo ne hen, be time lé uce pitaatééhi ni mulihelé. ");
INSERT INTO cam_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ke e pii telé pie: «Geé pipwocile, wogewé ni apulie Korazin me Betsaïda! Be o bo ne cuhinaado tewé! Be é caa pwo ni naado na nihe ubwo ne pelewé ke time geé uce céihi! Geé cuwoteeke niimihi lupwo pwomwo ubwo Tir me Sidon ânebun be te nihe ta ni huô te ni apulie lang. Kehe icehi ana hemepie lé alihi ana é pwo ne pelewé, ke wieli caa te é bwolihi celi lé taatééhi ni mulihelé. Ke me lé o habwii ko ace bwo cuwohe cang delé, me pitimilé he dep. ");
INSERT INTO cam_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Be é pii tewé a juuju pie: É ha ace Tan celi e bo tauti ni apulie wo Padué, ke o te junihe ubwo ace cuhinaado tewé koja lépwo Tir me Sidon. ");
INSERT INTO cam_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","«Ke te piwien ne mwo kowé, wogewé ni apulie Kapernaüm. Be geé niimihi pie pwonaado ne kowé, ke geé pwohewii Padué. Ûhu! E bo nekewé ole céii lépwo amele! Be e pwo ni naado na te junihe ubwo ne pelewé. É hemepie e pwo ni naado naa ne *Sodome, ke wieli me e o mwo teko mu jenaa a pwomwo ubwo naa. ");
INSERT INTO cam_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ke é pii tewé a juuju pie: É ha ace Tan celi e bo tauti ni apulie wo Padué, ke o te junihe ubwo ace cuhinaado tewé koja lépwo *Sodome!» ");
INSERT INTO cam_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","É ha a benaamwon naa, ke e pii wo Iésu pie: «É pwo-olé tem, go Caa, Padaame he a miiden me a bwohemwo, be go neduwohi ni naado naa koja lépwo atemehinaado me lépwo apitemang, ke go habwii te lépwona time lé uce cémun. ");
INSERT INTO cam_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Be te âcehi ana te nimem kon.» ");
INSERT INTO cam_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ke e pii te lépwona lé téneeng pie: «Ati nina e pele Caa tong, ke e caa ne tong. E caa te pihabwiieng dong, beme é temehieng ehi. Te weeng cehi na e temehiéo, woéo pa Naîn. Ke te woéo cehi na é temehieng, ke é habwiieng te ni béén beme lé temehieng mwo.» ");
INSERT INTO cam_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","«Geé âbé céiiéo, wogewé nina junihe téé ni âneule tewé, ke mwaale gewé. Be é bo ne ce mwaale tewé. ");
INSERT INTO cam_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Geé pé a âneule na é ne tewé, ke geé engen ne ko ni pihuô tong. Be pana bwala a pating, ke é pwo me piwahin jo. Ke me geé âbé céiiéo, ke geé o tooli a ju mwaale. ");
INSERT INTO cam_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Éa, be a âneule na é ne tewé, ke te ju pwia, ke ni pihuô tong, ke te ju ticecoon a bwo âcehin.» ");
INSERT INTO cam_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","É ha a céiu *tan iitihi, ke lé uti a pwaaden na e pitahagéi ni apwoamu wo Iésu me lépwo acémun den. Ke mene lépwo acémun den, ke lé te pwo me tabwo ni ace blé, ke lé wii. ");
INSERT INTO cam_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ke me lé alihi anaa wo lépwo *Farasaio, ke lé pii te Iésu pie: «Go alihi ana lé pwo ne ni acémun dem! Be a naado na iitihi, ha a *tan iitihi!» ");
INSERT INTO cam_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ke e hegi ne telé wo Iésu pie: «Kona time geé mu uce pine ne he ni tii iitihi ana e pwo wo pa daame *Davita? Be é ha a céiu tan, ke menelé, woélé me ni béén. ");
INSERT INTO cam_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ke e taa ha a *mwaiitihi na pwo ko mwaanu. Ke e pé ni pwoloa na ne me de Padué, ke lé eni me ni béén. Kehe ni pwoloa naa, ke te ni *apwoâpwailo cehi na pwo mwomwon delé me lé eni. ");
INSERT INTO cam_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","«Ke geé pine ne mwo he ni *patén de Moosé pie: Lé penem ha a mwaiitihi he ni tan iitihi wo lépwo apwoâpwailo. Ke time uce ta ne he pwahamii Padué! ");
INSERT INTO cam_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ke é pii tewé pie: E éni ana junihe piwéden koja a mwaiitihi! ");
INSERT INTO cam_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Be e pii wo Padué ne he ni tii iitihi pie: Time uce a âpwailo ko wota ana wâé tong. Kehe nimung ko a pipwoééhe. «Ke wogewé, ke time geé uce temehi ace bwomune a pwooti naa, be geé tauti ni apulie ce, na time lé uce pwo celi ta ne he pwahamii Padué. ");
INSERT INTO cam_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ke woéo pa Nahi Apulie, ke pa eapwihi a tan iitihi.» ");
INSERT INTO cam_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","É alecehen, ke e taa ha a *mwotapitihi wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kehe e ko mu lang wo pa apulie na mele a in. Ke nime ni Farasaio me lé alihi aceli e o pwo wo Iésu, beme lé o bo pipé ne kon. Ke lé te pwo me tahimwoeng pie: «He te pwo mwomwon denye, me genye pwo me tieden ace cunu ko pace céiu apulie ha a tan iitihi?» ");
INSERT INTO cam_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ke e hegi ne telé pie: «É hemepie e tupwo ne ha ace pwon ace muto tewé celi te ju céiu nang, ha ace tan iitihi, ke kona geé o pwo de? Geé â céieng da mu ha a pwon! ");
INSERT INTO cam_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Be te junihe pipwonaado ne ko pa apulie koja a muto! Ke é mu ko anaa, na te ne me nye pwo ana wâé ha a tan iitihi.» ");
INSERT INTO cam_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ke e pii te pali apulie pie: «Go cinebé a im.» Ke e cine ngen a in, ke caa te wâé mwo kuti, pwohewii a céiu. ");
INSERT INTO cam_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ke wo lépwo Farasaio na lé mu lang, ke lé wie mu ha ali mwotapitihi. Ke lé â pwopitihi, beme lé hane ace bwopwonen me lé taunu Iésu. ");
INSERT INTO cam_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Me e téne wo Iésu pie, lé ko pihane ace bwopwonen me lé taunueng, ke e engen mu ha a duaan naa. Ke hiwon ni béén na lé âcéin, ke e pwo me tieden ni cunu kolé. ");
INSERT INTO cam_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ke e cihe me mwoiu ne kolé pie: «Geé nemwo pipatemehiéo!» ");
INSERT INTO cam_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ke ni naado naa, ke e tuie, beme e pacuwohi ali e pii wo Padué, na e pwaadeniin bé wo péroféta Isaia pie: ");
INSERT INTO cam_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Weengi pa eabwé tong, na é caa pipégalieng, pana te junihe eânimung den. É ne kon a *Jenen Iitihi tong, ke e bo pipatemehi te ni bele a juuju ke a bwo celuimilé. ");
INSERT INTO cam_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Time e o uce cihe okéé, ke time e o uce cihe me ubwo, ke time nye o uce téneeng heme e wiikau pwo pwaaden. ");
INSERT INTO cam_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Time e o uce tubwi ni womeéle na caa hajii. Time e o uce taunuhi ace miû celi caa tice niihen. Time e o uce tanahi ni apulie na tice niihelé. E o wonaa a bwo penem den, dieli e o bo â piwéden a mwomwon ke a juuju. ");
INSERT INTO cam_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ke lé bo tai céihi ne kon ati ni bele. Ésaïe 42.1−4 ");
INSERT INTO cam_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Lé pébé céii Iésu pa céiu apulie na bwi nang, ke huuhu nang, be pwo duéé kon. Ke e pwo me wâé nang wo Iésu. Ke e cihe, ke e niê mwo. ");
INSERT INTO cam_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ke lé téetihi ati ne ni apulie, ke lé pipii telé pie: «Mepwo wo paje, ke wieli wo pali piebehi Davita, pali *Mesia li genye tee ko ucéieng?» ");
INSERT INTO cam_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kehe icehi ana lé pii wo lépwo Farasaio pie: «Ûhu! Wo pa apulie ce, ke e penem ko a junuu Caatana, pa daame he ni duéé! Be é mu ko anaa, na e peni ni duéé.» ");
INSERT INTO cam_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ke e te temehi ni bwo niimihinaado telé wo Iésu, ke e pii telé pie: «Hemepie e te pipwopa ne mwo kon ace céiu mwametau, ke a mwametau naa, ke o tanahi. Ke mepie e te pipwopa ne kon mwo ace céiu pwomwo ubwo, ai ace céiu pwomwoiu, ke o pwocoon me e mu mang! ");
INSERT INTO cam_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ke mepie e cibéé ni duéé wo Caatana, pa daame he ni duéé, ke e o te pipwopa ne mwo kon! Ke kona e o woté ko ace bwopwonen me e cumang a mwametau ten? ");
INSERT INTO cam_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Geé pii pie, é peni ni duéé ko a junuu Caatana. Ke hemepie wonaa, ke kona woo celi e ne te ni bééwé ce junuun me lé peni ni duéé? Be lé habwii pie, geé getiéo. ");
INSERT INTO cam_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","«Ûhu! É peni ni duéé ko a Jenen Iitihi te Padué. Ke é hemepie nimewé kon, ke te jan me geé alihi temehi pie e caa tuiebé pelewé na a *Mwametau te Padué! ");
INSERT INTO cam_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","«É hemepie nimenye me nye taa ha a mwa te pace céiu apulie na pwo niihen, me nye pé ni naamuun, ke wâé heme nye mi cieeng. É mulang, ke genye bwobe pé ni naamuun mu ha a mwa ten. ");
INSERT INTO cam_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Wo pana time uce pa bééng, ke e cubwoniéo. Ke wo pana time e uce picani tong me gemu taineibuhi, ke e papiidenihi.» ");
INSERT INTO cam_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","«É pii tewé pie: O jan me pineu ni apulie na lé cihe me ta ne ko Padué. Kehe wo paceli e cihe me ta ne ko a Jenen Iitihi, ke time o uce pineuhi ni ta pwo ten. ");
INSERT INTO cam_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ke o jan me pineu paceli e cihe me ta ne kong, pa Nahi Apulie. Kehe mepie e cihe me ta ne ko a Jenen Iitihi, ke o time uce jan me pineuhi ni ta pwo ten, ne ha a mulie ce, ke é ne mwo ha a *mulie dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«A acuwo na wâé, ke e te ne ni acehin na wâé me wii. Ke a acuwo na ta, ke e te ne ni acehin na ta. Be nye o te temehi a acuwo mu ko ni acehin. ");
INSERT INTO cam_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ke wonaa mwo ne kowé be geé o woté ko ace bwopiine ce naado celi wâé, wogewé ni nahi bwien, ke ni agele? Be nina e paobaanihi a pwonime pa apulie, ke weengaa nina e wie pwon heme e cihe. ");
INSERT INTO cam_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ni naado na wâé, ke e te âbé mu ko pa apulie na wâé nang, be wâé a pwonimen. Kehe ni naado na ta, ke e te âbé mu ko pa apulie na ta nang, be ta a pwonimen. ");
INSERT INTO cam_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","«Éa, é pii tewé a juuju pie: O bo pwo a Tan na e bo tauti ni apulie hen wo Padué. E bo muko pétaapwo tautilé ko ni pwooti ta na lé pipii hauli. ");
INSERT INTO cam_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Te é mu ko ni pwooti na go pii, na e bo te pihuôhi wo Padué pie, o pwocuhinaado tem, ai o celuimiko.» ");
INSERT INTO cam_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","É ha a céiu tan, ke lé âbé céii Iésu ne ni béé *dotéén ko patén me ni béé Farasaio, ke lé pii ten pie: «Pa apipune, go pwo ace *pipwojunuun me geme alihi.» ");
INSERT INTO cam_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ke e hegi ne telé pie: «É mu ko ade na geé tee cuwo ko ilehi ce pipwojunuun, wogewé ni apulie jenaa? Te junihe ta gewé be time geé uce piténede Padué! O te tice mwo ace céiu pipwojunuun celi geé mwo alihi mwo, koja ali e too péroféta Jonas ânebun. ");
INSERT INTO cam_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Be li cié li tan den, ke cié bwénin tina ali pilehe ikua. Ke te piwien ne mwo kong, pa Nahi Apulie, be cié ni tan, ke cié ni bwéning, tina a pule. ");
INSERT INTO cam_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","«E â Ninive wo Jonas, ke e pwopune te ni apulie lang. Ke lé téne a pune ten, ke lé pininim, ke lé pitaatééhi ni mulihelé. Kehe te e éni pelewé wo pa céiu apulie na e te nihe piwéden koja Jonas. Ke é ha a Tan na e bo tauti ni apulie hen wo Padué, ke wo lépwo Ninive, ke lé o cuwoda ânebuhewé, wogewé ni apulie jenaa, ke lé o pipé ne kowé! Be muhi tewé me geé pininim, ke me geé bitekewé! ");
INSERT INTO cam_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","«Ke geé te temehi mwo a jepule ko ê toomwo daame ha amu Saba bwolihi. Be li e âbé mu ha amu ten na te junihe e ité, beme e téne pa daame *Solomona na oba nang ko a pitemang. Kehe te e éni pelewé pa céiu apulie na e te junihe piwéden koja Solomona! Ke é ha a Tan na e bo tauti ni apulie hen wo Padué, ke e bo cuwoda ânebuhewé ê toomwo daame naa, ke e bo pipé ne kowé, wogewé ni apulie jenaa. Be muhi tewé me geé téne.» ");
INSERT INTO cam_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Geé cuwoteeke téne ani: Hemepie pwo duéé ko pace céiu apulie, ke me e wie mu kon, ke e â wé? E âdé ke âbé he ni duaan na ticie hen. Be e hane ace duaan celi me e mu hen, kehe icehi ana time e uce tooli. ");
INSERT INTO cam_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ke e niimihi pie, ‘É o mwojuia ngemwo ha ali pomwa tong.’ Ke e mwojuia, ke e tooli ali mwa he tice ânen, ke te ju balé hen ehi, ke pwoiipihi ehi. ");
INSERT INTO cam_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ke e â hane ni duéé béén na 7 jélé, na te junihe ta jélé kojaeng. Ke lé taa pimu ha ali mwa. Ke wo pa apulie naa, ke bwo junihe ta nang mwo kojan ânebun! Ke o wonaa celi e o tuie ne kowé, wogewé ni apulie na ta gewé jenaa.» ");
INSERT INTO cam_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","É he e mwo teko cihe ne ko ni apulie wo Iésu, ke lé tuiebé wo nyaa ten me lépwo ciéén, ke lé âbé cuwo pwomwo, be lé haneeng beme lé picihe. ");
INSERT INTO cam_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ke e pii ten wo pa céiu apulie pie: «Aje, élé âoté pwomwo wo nyaa tem me lépwo ciéém. Be lé ko haneko me lé cihe tem.» ");
INSERT INTO cam_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ke e hegi ne ten wo Iésu pie: «He woo êce nyaa tong? Ke wooélé lépwoce ciééng?» ");
INSERT INTO cam_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ke e hiido lépwo acémun den, ke e pii pie: «Geé alihi, be woélé-ni ni nyaa tong me ni ciééng. ");
INSERT INTO cam_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Be wo pana e pwo ana te nime Caa tong kon, Padué na e jeda he miiden, ke te weengaa kuti pa âjiénung, ke ê pwaadeniing, ke ê nyaa tong.» ");
INSERT INTO cam_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","É ha a tan naa, ke e wie mu ha a mwa he na e pimu lang wo Iésu, ke e ole ticepwon. Ke e tebwo, beme e pacémuni ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ke caa â hiwon ni apulie na lé âbé céiieng. Ke é mu ko anaa, ke e taa pwo a céiu ong, ke e tebwo. Ke lé te mu jeda ticepwon ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ke e pwo-ocine he e pacémunilé ko ni naado na hiwon. Ke e pii telé pie: «Geé téne! E bwo mu wo pa céiu apulie, ke e bwo wie ha a céiu tan, beme e tagiliihi ni âdaanu. ");
INSERT INTO cam_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ke é he e ko tagiliihi, ke lé tupwo nge pwo pwaaden ni béé pidenaado. Ke lé âbé ne ni meni, ke lé wii ati. ");
INSERT INTO cam_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ke ni béén, ke lé tupwo ne ha a wii péi. Ke lé piepin ko cim, be time uce hiwon ni pule lang. ");
INSERT INTO cam_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kehe icehi ana me e niê na a téale, ke éle li nahi âdaanu, ke lé meiu, be te tice waan. ");
INSERT INTO cam_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ke ni béén, ke lé tupwo ne ha awieme ni mwawi ubwo. Ke me lé tai picim, ke lé taunuhi li pidenaado. ");
INSERT INTO cam_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ke ni béén, ke lé tupwo ne ha a pule na wâé. Ke lé aca; ke ni béén ke 100 ni acehin, ke ni béén 60, ke ni béén 30.» ");
INSERT INTO cam_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ke e pii mwo telé wo Iésu pie: «Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Lé âbé mwonu Iésu wo lépwo acémun den, ke lé tahimwoeng pie: «É mu ko ade na go mu pwo-ocine te ni béén, heme go cihe ne kolé?» ");
INSERT INTO cam_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ke e hegi ne telé pie: «E ne tewé wo Padué, me geé temehi a ju bwomune a Mwametau ten. Kehe icehi ana time uce jan ne ko ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Be wo pana caa pwo ne ten, ke o ne mwo pwon ce béén, beme pihiwon den. Kehe wo pana te tice ten, ke o pétaabwon kojaeng a nehinaado na mwo e pelen. ");
INSERT INTO cam_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","É mu ko anaa, na é pwo-ocine telé, heme é pacihelé. Be lé omehi, kehe time lé uce alihi temehi; ke lé téne, ke time lé uce téne temehi. ");
INSERT INTO cam_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ke weengaa a bwo pacuwohi na ali e pii wo Padué ne kolé, na e pwaadeniin bé wo péroféta Isaia pie: Geé o te téne taaci, kehe time geé uce téne temehi. Geé o te omehi taaci, kehe time geé uce alihi temehi. ");
INSERT INTO cam_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mwoiu a puni a puapulie ce. Capuhi ni pwonimelé. Bwéjé ni pwojéénelé. Bwi ni naamiilé. Be time uce nimelé me lé alihi ko ni naamiilé, ke me lé téne ko ni pwojéénelé, ke me lé temehi ko ni pwonimelé. Te muhi telé me lé bitelé bé céiiéo, me lé taatééhi ni mulihelé, ke me é o pwo me wâé jélé!» Ésaïe 6.9−10 ");
INSERT INTO cam_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«Ke hemepwo wogewé, ke geé pipwodéén, be geé alihi ko ni naamiiwé, ke geé téne ko ni pwojéénewé. ");
INSERT INTO cam_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","É pii tewé a juuju pie: Hiwon ni péroféta, ke hiwon ni apulie na mwomwon jélé, na te nihe nimelé me lé alihi nina geé alihi, kehe time lé uce alihi temehi. Ke nimelé me lé téne nina geé téne, kehe time lé uce téne.» ");
INSERT INTO cam_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Geé téne a bwopiine a ocine ko pa apicemi: ");
INSERT INTO cam_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ni béé pidenaado, ke lé tupwo nge pwo pwaaden. A pwaaden ke ni apulie na lé téne a pwooti ko a Mwametau, ke time lé uce temehi. Ke e tuiebé wo *Caatana, pana ta nang, ke e céi mwo a pwooti na caa cemi ne he ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","«Ke ni béé pidenaado, ke lé tupwo ne ha a wii péi. A wii péi ke ni apulie na lé téne a pwooti, ke lé epin me lé hegi ha a pipwodéén. ");
INSERT INTO cam_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kehe icehi ana te tice waan ne kolé a pwooti na lé téne. Ke lé te pitaatééhi ni bwo niimihinaado telé. Hemepie e tuie ne kolé a tacebwén me pwo nina ta ne kolé, watihen a pwooti te Padué, ke lé patieden ni céihi telé. ");
INSERT INTO cam_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","«Ke ni béé pidenaado, ke lé tupwo ne he ni mwawi ubwo. A pule naa ke ni apulie na lé téne a pwooti, kehe icehi ana pinekepé ni pwonimelé ne ko ni naado na e tuie ne pwo a bwohemwo ce. Ke lé téte cehi mwani me ni naamuu bwohemwo. É mu ko ninaa, ke e taunuhi a pwooti, ke te tice acehin. ");
INSERT INTO cam_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","«Ke ni béé pidenaado, ke lé tupwo ne ha a pule na wâé. A pule naa ke ni apulie na lé téne a pwooti, ke lé temehi, ke pwo acehi a pwooti ne kolé: ni béén ke 100 acehin, ke ni béén ke 60, ke ni béén ke 30.» ");
INSERT INTO cam_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","E pwo mwo a céiu ocine wo Iésu, ke e pii te ni apulie pie: «A *Mwametau he Miiden ke pwohewii ani: «E bwo mu wo pa céiu apulie, pa apwo âdaanu. Ke e bwo tagiliihi ni pidenaado na wâé ne ha apwoamu ten. ");
INSERT INTO cam_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kehe icehi ana é he bwén, he e ko pule, ke e bwo tehenebé wo pa apipwokon, ke e tagiliihi ni âdaanu na ta, ha awieme ni âdaanu na wâé, ke e engen. ");
INSERT INTO cam_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","«Ke lé cim ne li âdaanu li wâé, ke lé aca. Ke lé te cim mwo li âdaanu li ta. ");
INSERT INTO cam_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ke me lé alihi anaa ne ni apenem ha apwoamu, ke lé pii te pali eapwihi ali apwoamu pie: “Go te alihi, go pa daame, be li go tagiliihi li âdaanu li wâé ha ali apwoamu tem. Ke kona lé âbé mu wé ne ni âdaanu na ta na élé hen?” ");
INSERT INTO cam_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","«Ke e hegi ne telé pie: “Ûhu, wo pa apipwokon na e pwo anaa.” «Ke lé pii ten pie: “Kona o te nimem me geme â tewii taabwon ni âdaanu na ta?” ");
INSERT INTO cam_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","«Ke e hegi ne telé pie: “Ûhu! Be mepie geé tewii ni âdaanu na ta, ke geé o tewii ne pehi ni âdaanu na wâé. ");
INSERT INTO cam_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kehe geé te nelé me lé te picim ibu, die ha a pitii âdaanu. Ke é bo pii te ni apenem dong pie, me lé mi taineibuhi ni âdaanu na ta, me lé cini, ke me lé ne ni âdaanu na wâé ha a mwoâdaanu tong.”» ");
INSERT INTO cam_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","E pwo mwo a céiu ocine telé wo Iésu, ke e pii telé pie: «A Mwametau he Miiden, ke pwohewii a pide moutarde na e cemi wo pa céiu apulie ha a cereda ten. ");
INSERT INTO cam_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","A cuwo nahi pidenaado na te junihe wahin. Kehe icehi ana me e cim, ke te junihe ubwo nang koja ati ni naado na nye cemi he ni cereda. Ke lé âbé ne ni meni, ke lé pwo ni mwonahilé ne he ni dihen, be caa â acuwo na junihe ubwo.» ");
INSERT INTO cam_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","E pwo telé mwo a céiu ocine wo Iésu, ke e pii pie: «A Mwametau he Miiden, ke e pwohewii mwo a nyaa te pwoloa na e pé ê céiu toomwo, ke e iluuhi neibu me a 25 kilo ko farine dieli e â cibu da ali pwoloa!» ");
INSERT INTO cam_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ati ninaa, ke e pii telé he ocine wo Iésu. Be e te cuwo ko pwo-ocine telé heme e pacihe ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E wonaa, beme e pacuwohi ali e pii wo Padué na e pwaadeniin bé wo pa péroféta ten pie: É bo pwo-ocine heme é pacihelé. É bo pii ni naado na neduwohi mu ha atabuhi ko a bwohemwo. Psaume 78.2 ");
INSERT INTO cam_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lé engen koja ni apulie wo Iésu me lépwo acémun den, ke lé â pwomwo. Ke é nelang, ke lé pii ten pie: «Go cuwoteeke pii teme ace bwopiine ali ocine li go pii ne ko ni meté na ta.» ");
INSERT INTO cam_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ke e hegi ne telé pie: «Wo pana e tagiliihi ni pidenaado na wâé, ke woéo pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","39","A apwoamu, ke a bwohemwo. A pide âdaanu na wâé, ke ni nahi a Mwametau. Wo pa apipwokon, ke wo Caatana, pana ta nang. Ke a pide âdaanu na e cemi, ke ni naîn, ke ni apulie na e kolé a duéé. Ke a pitii âdaanu, ke anebwén ko a bwohemwo. Ke ni apenem, ke ni *âcélo. ");
INSERT INTO cam_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ke lé bo tai ni pidenaado na ta, ke lé cini ne pwo miû. O wonaa ace bwopwonen ne ko ni naî Caatana ha anebwén ko a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","«Be woéo pa Nahi Apulie, ke é bo nebé ni âcélo tong. Ke lé bo pétaabwon mu ha a Mwametau tong nina lé pwo nina ta, me lépwona lé pwo me tieden ni céihi te ni béén. ");
INSERT INTO cam_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ke lé o bo tahilé da pwo a miû na ubwo. Ke é nelang he na lé o é me piwii pecuwo. ");
INSERT INTO cam_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","«Ke ni béén na mwomwon jélé ne he pwahamii Padué, ke o pwomelaan jélé pwohewii a téale ne ha a Mwametau te Caa telé. Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«A Mwametau he Miiden, ke pwohewii ni mwani megele na te junihe pwonaado ne kon, na neduwohi ha apwoamu. Ke e tooli wo pa apenem ha apwoamu. Ke e te junihe pipwodéén kuti, ke e te neduwohi mwo. Ke e icuhi ati nina eten, ke e pwocuhi a apwoamu naa.» ");
INSERT INTO cam_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«A Mwametau he Miiden, ke pwohewii mwo a perle na te junihe wâé, ke te junihe ubwo a cuhin. Pwo pa céiu a-icu, na e hane perle. ");
INSERT INTO cam_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ke e tooli a perle naa. Ke e te icuhi ati kuti nina e pelen, beme e pwocuhin.» ");
INSERT INTO cam_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«A Mwametau he Miiden, ke pwohewii mwo a pua, heme nye tahi ole he jié, ke e pé ni muko pétaapwo ikua. ");
INSERT INTO cam_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ke genye pé da huâiu, ke genye tai ni ikua na wâé, ke genye ne he ni élele. Ke genye tahi taabwon ni ikua na ta. ");
INSERT INTO cam_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ke o wonaa ha anebwén ko a bwohemwo, be e bo pahede ni âcélo ten wo Padué. Ke lé o pineité nina lé *mwomwon ne he pwahamiin, me ni béén na time lé uce piténedeeng. ");
INSERT INTO cam_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ke lé o bo tahi ni béén na time lé uce piténedeeng ne ha a miû na ubwo. Ke é nelang he na lé o bo é me piwii pecuwo.» ");
INSERT INTO cam_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","E tahimwo ni acémun den wo Iésu pie: «Kona geé te temehi ni ocine naa?» Ke lé hegi ne ten pie: «Éa.» ");
INSERT INTO cam_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ke e pii telé pie: «Wo pa *dotéén ko patén na caa pa apulie ha a Mwametau he Miiden, ke e pwohewii pa céiu eapwihi pwomwo na e pipégali mu he ni wâé ten nina mwo coho, me nina caa bwolihi.» ");
INSERT INTO cam_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Me e pii ati ni ocine naa wo Iésu, ke e engen mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ke e â Nazaret, he na ubwo nang ne hen. Ke e pacémuni ni apulie ko a pwooti te Padué ne ha a *mwotapitihi. Ke lé te junihe téetieng, ke lé pitahimwolé pie: «He woo na e pacémunieng? Kona e âbé mu wé ni bwo temehinaado ten, ke ni *pipwojunuun na e pwo? ");
INSERT INTO cam_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Be pali naî pali apenem ko ba-acuwo! Pali naî Maria, ke pa cuwo Cang, me José, me Simon, me Jude! ");
INSERT INTO cam_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ke lé teko mulie pelenye ni toomwo pwaadeniin! Ke he woo na e ne ten ni naado na e pwo?» ");
INSERT INTO cam_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ke lé pitaaba ne kon wo lépwo Nazaret, ke te muhi telé me lé céihi ne kon. Ke e pii telé pie: «Au, mwolihi! Be wo pa péroféta, ke lé te paciitieng ati ne he ni amu, kehe te icehi ne ha amu ten!» ");
INSERT INTO cam_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ke time e uce pwo ce pipwojunuun celi hiwon nelang wo Iésu, be time lé uce céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","É ha a benaamwon naa, ke e piténe ni jepule ko Iésu wo *Érode Antipas, gupéno ne Galilé. ");
INSERT INTO cam_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ke e pii te ni eabwé ten pie: «Wo pa apulie naa, ke wo *Ioane pa apipuu apulip, he e caa mulie cemwo mu ha amele! Ke weengaa a watihen me e pwo ni *pipwojunuun.» ");
INSERT INTO cam_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Weengi a jepule ko a bwo mele te Ioane: Wo Érode, ke lu piaten me Érodiade, ê mwode Filip, pa âjiénen. Ke e mu te cuwo ko pii ten wo Ioane pie: «Te tice mwomwon dem me go pé ê toomwo naa.» Ke e te pwo me imwi Ioane wo Érode, ke e cieeng, ke e neeng he karépu. ");
INSERT INTO cam_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nime Érode me e taunueng, kehe icehi ana mwotieng ko ni apulie, be a hiwon kolé, ke lé niimihi pie pa péroféta te Padué. ");
INSERT INTO cam_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ke é ha a tan na lé pipaunuhi a bwo âbeele te Érode, ke e pwolu he pwahamii ni apulie wo ê naî Érodiade. Ke te junihe wâé te Érode. ");
INSERT INTO cam_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ke e *piapwo ne ten pie: «É o ne tem ati celi go o ilehi kojaéo.» ");
INSERT INTO cam_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ke e cineeng wo nyaa ten, beme e pii te pa daame Érode pie: «Go ne tong a puni Ioane ne ha ace tam.» ");
INSERT INTO cam_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Ke te junihe piwahin Érode. Kehe icehi ana e caa mi piapwo ne he pwahamii ni apulie ati. Ke e pahede ni coda ten nge ha a karépu, beme lé â tahagéi a hene Ioane. ");
INSERT INTO cam_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ke lé pébé a punin ne ha ace tam, ke lé ne te êgi ewa toomwo. Ke wo êje, ke e pé nge céii nyaa ten. ");
INSERT INTO cam_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ke é alecehen, ke lé âbé wo lépwo acémun de Ioane, ke lé pé a één, ke lé â neduwohi, ke lé â pipatemehi te Iésu ana e tuie ne ko Ioane. ");
INSERT INTO cam_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Me e téne ana e tuie ne ko Ioane wo Iésu, ke e te piengen cehi pwo ong, ke e â ha a céiu duaan na e ité, na te piticie hen. Kehe icehi ana lé piténe ne ni apulie, ke lé wie mu he ni mwopopwaalé, ke lé piâcéin nge ticepwon. ");
INSERT INTO cam_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ke me e ele ole mu pwo ali ong wo Iésu, ke e alihi a pubu apulie na te junihe ubwo, ke e te junihe pipwoééhelé. Ke e pwo me wâé ni béén na cunu jélé. ");
INSERT INTO cam_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","E caa pwo me e nuule a téale, ke lé âbé céiieng wo lépwo acémun den, ke lé pii ten pie: «O caa babwén, kehe apiticie éni. Go ne ngemwo ni apulie ce, nge he ni mwopopwaalé na e mwonu, beme lé o pé ce wiinaado telé.» ");
INSERT INTO cam_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ke e hegi ne telé wo Iésu pie: «Ûhu, wâé heme lé mu éni, ke me geé ne ce wiinaado telé.» ");
INSERT INTO cam_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ke lé pii ten pie: «Time uce jan, be te ju nim ni pwoloa, ke alo lupwo ikua na e peleme!» ");
INSERT INTO cam_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ke e pii telé pie, me lé pébé céiieng. ");
INSERT INTO cam_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ke nebwén, ke e pii te ni apulie pie, me lé tebwo he ni meté. Ke e pé li pwoloa li nim me lupwoli ikua. Ke e alehede da he miiden, ke e pwo-olé te Padué. Ke e ebii li pwoloa, ke e ne te lépwo acémun den, ke lé pipatihi ne ko ni apulie. Ke e wonaa mwo ko lupwoli ikua. ");
INSERT INTO cam_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ke lé tai wiinaado ati, ke caa pwoluu jélé. Ke lé taineibuhi mwo ni nehi wiinaado telé, ke lé paobaanihi ni élele na 12 kon. ");
INSERT INTO cam_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","A jéhi ni apulie aiu na lé wiinaado, ke e pwo 5000 jélé, ke time uce pine ni ewa me ni toomwo. ");
INSERT INTO cam_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Te ju é alecehen, ke e pii wo Iésu te lépwo acémun den pie: «Geé taa pwo ong, ke geé mi gaale ângedé ko a céiu goon.» Ke e mwo te mu wo Iésu, ke e pamwojuiéhi mwo ni pubu apulie. ");
INSERT INTO cam_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ke me e caa pinelé ati, ke e taa pwo juwole, beme e pwoiitihi, ke bwénieng nelang. ");
INSERT INTO cam_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ke mepwo wo lépwo acémun den na lé mu pwo ali ong, ke caa élé ité koja a nicepwon. Ke e âbédelé na a dan; ke ni jié, ke taii ne ko ali ong. ");
INSERT INTO cam_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ke caa é pwopwometan, ke e âbé céiilé pwo bwotabe wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ke me lé alieng, he e ko engen pwo bwotabe, ke te junihe mwotilé, ke lé haa da ko miiden, be lé niimihi pie a duéé! ");
INSERT INTO cam_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kehe icehi ana e te pwome pacihelé wo Iésu, ke e pii telé pie: «Geé nemwo pwo me mwotikewé! Be woéo! Geé mwoiu!» ");
INSERT INTO cam_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ke e pii ten wo Pétéru pie: «Padaame, mepie te wogo, ke go pwo me é oté céiiko ne pwo bwotabe.» ");
INSERT INTO cam_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ke e pii ten wo Iésu pie: «Îgo, go opé!» Ke e ole mu pwo ong wo Pétéru, ke e â céii Iésu pwo bwotabe. ");
INSERT INTO cam_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kehe icehi ana mwotieng ko a dan me ni jié be ubwo, ke e te tabuhi kopi neole ha a tabe. Ke e toii da pie: «Padaame, go celuimiéo!» ");
INSERT INTO cam_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ke e te pétaa nge ko a in kuti wo Iésu, ke e pii ten pie: «Te junihe wahin kuti a céihi tem! É ko ade na pinekepé ne tem?» ");
INSERT INTO cam_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ke me lu taa pwo ong, ke e cuwo ali dan. ");
INSERT INTO cam_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ke lé tidihi jililé ati nina lé mu pwo ong, ke lé pipaunu Iésu, ke lé pii pie: «A juuju pie wogo, ke pa *Naî Padué!» ");
INSERT INTO cam_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Lé caa nebwén ko tahagéi jié wo Iésu me lépwo acémun den. Ke lé tuie gaale ha a duaan na e mwonuhi Génésaret. ");
INSERT INTO cam_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ke lé ali temehi Iésu ne ni apulie lang. Ke lé pipii ngen pitihi a duaan naa a bwo tuie ten. Ke lé tai pébé céiieng ati ni cunu. ");
INSERT INTO cam_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ke lé pii ten pie: «Te jan heme lé te ju ti cehi ko a baaé epwénem?» Ke caa te wâé ati nina lé ti kon. ");
INSERT INTO cam_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Lé âbé mu *Iérusaléma ne ni béé *Farasaio me ni béé *dotéén ko patén, ke lé âbé too Iésu. Ke lé pii ten pie: ");
INSERT INTO cam_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Time lé uce piténedehi a ju bwomu wo lépwo acémun dem, be time lé uce mi puu ni ilé ânebuhe a wiinaado pwohewii ni watihenye. Kehe é mu ko ade, go paje?» ");
INSERT INTO cam_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ke e hegi ne telé pie: «Lépwoje! É mu ko ni ju bwomu tewé, ke time geé uce piténedehi nina nime Padué kon. Kehe é mu ko ade? ");
INSERT INTO cam_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Be e pii wo Padué pie: Go paciiti lu nyaa me caa tem. E pii mwo pie: Geé taunu pa apulie na e pipii me ta lu nyaa me caa ten. ");
INSERT INTO cam_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","«Kehe icehi ana wogewé, ke geé te pii te ni apulie pie, te wâé heme lé pii te lu nyaa me caa telé pie: “Nimung me é ne teu ace céiu naado me bépicani teu, kehe icehi ana time uce jan, be é caa pwo me âpipati iitihi te Padué.” ");
INSERT INTO cam_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","«Ke é nelang he na geé pacémunilé, me time lé uce paciiti lu nyaa me caa telé! Ke me wonaa, ke geé caaite ne he pule ni pwooti te Padué ko ni bwomu tewé! ");
INSERT INTO cam_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Geé te ju gahe pwo! E te juuju wo péroféta Isaia, na e pwaadeni a pwooti te Padué ne kowé pie: ");
INSERT INTO cam_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Lé te ju pipaunuéo ko pwolé wo lépwo apulie ce, kehe te e ité kojaéo ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Lé pwoiitihi me *pwoâpwailo tong kehe te piticenaado ne kon. Ana lé pacémuni ni apulie kon, ke te ni patén delé ni apulie, kehe time uce a pwooti tong.» Ésaïe 29.13 ");
INSERT INTO cam_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","É alecehen, ke e tode ni apulie wo Iésu, ke e pii telé pie: «Lépwoje! Geé tabemiéo, ke geé temehi ehi ana me é pii tewé: ");
INSERT INTO cam_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Time uce ana e taa pwo pa apulip ana e pwo me ta nang ne he pwahamii Padué. Kehe te icehi ana e wie mu pwon, ana e pwo me ta nang.» ");
INSERT INTO cam_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ke lé âmwonu Iésu wo lépwo acémun den, ke lé pii ten pie: «Ni pwooti tem, ke te junihe ti ko ni Farasaio, he go te temehi?» ");
INSERT INTO cam_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ke e hegi ne telé pie: «Wo lépwo Farasaio naa, ke lé pwohewii ni acuwo na time uce ni âcemi he Caa tong jeda he miiden. Ke e o bo taawii. ");
INSERT INTO cam_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Geé nelé! Be wo lépwo bwi, ke lé te pé lépwo bwi. Be wo pa bwi, ke me e pé pa céiu bwi, ke lu o tai tupwo ole ha ace pwon!» ");
INSERT INTO cam_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ke e pii te Iésu wo Pétéru pie: «Go patemehi ehi teme a ocine naa.» ");
INSERT INTO cam_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ke e hegi ne ten wo Iésu pie: «Kona wogewé mwo, lépwo acémun dong, ke time uce téele jan me geé temehi anaa? ");
INSERT INTO cam_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Geé téne, ati ni naado na ta pwo pa apulie, ke me e â tinan, ke é alecehen, ke e te wie mwo mu ha a één. He time geé uce temehi anaa? ");
INSERT INTO cam_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","19","Kehe te icehi ni pwooti na e wie mu pwo ni apulie, ke ni bwo niimihinaado na ta na lé wie mu he ni pwonimelé, ke weengaa kuti nina e ne me lé pwo ana ta: Lé taunuhi apulie; Lé pibune; Lé pipule me ni apulie hauli; Lé bune; Lé pigeti ni béén; Lé pipii me ta ni béén. ");
INSERT INTO cam_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","«Weengaa nina ta genye kon, ne he pwahamii Padué. Kehe time uce ta genye ko ace bwo time uce puu ne ni inye.» ");
INSERT INTO cam_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","É alecehen, ke e engen mu ha a duaan naa wo Iésu, ke e â ha a céiu duaan na e mwonuhi lupwo pwomwo ubwo Tir me Sidon. ");
INSERT INTO cam_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ke e âbé céii Iésu wo ê céiu toomwo mu ha amu naa, beme e cihe ne kon. Kehe time uce ê *Juif, be ê piebehi lépwo *Kanana a bele na lé téétihi wo lépwo Juif. Ke e toii da pie: «Padaame, pa *Naî Davita, go pipwoééhung me picani tong! Be pwo duéé ko ê naîng, ke te junihe cunu nang.» ");
INSERT INTO cam_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Kehe icehi ana time e uce hegi ne ten wo Iésu ko ace céiu pwooti. Ke lé âbé mwonueng wo lépwo acémun den, ke lé pii ten pie: «Go pwo me engen wo ê toomwo ne! Be e tee ko cuwo ko cihe céinye!» ");
INSERT INTO cam_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ke e pii ten wo Iésu pie: «Wo Padué, ke e te neéo bé cehi ne ko ni apulie *Isaraéla, na lé pwohewii ni nahi muto na lé pipatieden.» ");
INSERT INTO cam_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kehe icehi ana wo êgi toomwo, ke e âbé tidihi jilin ânebuhe Iésu, ke e pii ten pie: «Padaame, go picani tong!» ");
INSERT INTO cam_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ke e hegi ne ten wo Iésu pie: «Time uce wâé heme nye pé ni wiinaado te ni cuwo ewa, me nye tahi ne te ni ‘nahi wotaahen’.» ");
INSERT INTO cam_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ke e pii ten wo êje pie: «Go te juuju, go Padaame, kehe icehi ana ni nahi wotaahen mwo, ke lé te eni ni mewiinaado na lé tupwo mu pwo taap te pa caa telé.» ");
INSERT INTO cam_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ke e hegi ne ten wo Iésu pie: «Êje, te junihe ubwo a céihi tem! Wâé heme pwohewii ana nimem kon!» Ke caa te tieden kuti ali cunu ko êgi naîn! ");
INSERT INTO cam_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","É alecehen, ke e engen wo Iésu mu ha a duaan naa. Ke e uti a nicepwon Galilé. Ke é mulang, ke e taa pwo juwole, ke e tebwo. ");
INSERT INTO cam_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ke lé âbé céiieng ne ni apulie na te junihe hiwon jélé, ke lé pébé céiieng nina tebwa jélé, ke nina bwi jélé, me ni tebwomwa, me ni huuhu, ke hiwon mwo ni béé cunu. Ke lé tai nelé ânebuhe Iésu, ke e tai pwo me tieden ni pétaapwo cunu kolé. ");
INSERT INTO cam_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ke ni huuhu, ke lé caa cihe. Ke ni tebwomwa, ke lé caa engen. Ke ni bwi, ke lé caa niê. Ke lé téetihi ne ni apulie, ke lé pipaunu Padué he lépwo Isaraéla! ");
INSERT INTO cam_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","E tode ni acémun den wo Iésu, ke e pii telé pie: «É te junihe pipwoééhe ni apulie ce! Be caa cié ni tan denye me woélé, ke tice wiinaado telé. Ke time uce wâé me é pamwojuiélé, be koli bo tice niihelé nge he pwaaden.» ");
INSERT INTO cam_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ke lé pii ten wo lépwo acémun den pie: «Genye o woté ko ace bwo ne wiinaado telé ati, ne éni ha a duaan na apiticie? Be go alihi, be te junihe hiwon jélé!» ");
INSERT INTO cam_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ke e tahimwolé wo Iésu pie: «Kona niile ce pwoloa celi e pelewé?» Ke lé pii ten pie: «7 ni pwoloa, ke pwo ni cuwo nahi ikua.» ");
INSERT INTO cam_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ke nebwén, ke e pii te ni apulie pie me lé tebwo. ");
INSERT INTO cam_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ke e pé li pwoloa li 7, me li nahi ikua, ke e pwo-olé te Padué. Ke e ebii, ke e ne te lépwo acémun den, ke lé pipwopii ne ko ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ke lé wiinaado dieli caa tai pwoluu jélé. Ke é alecehen, ke lé tai ni nehi wiinaado telé wo lépwo acémun den, ke e pwo 7 ni élele na oba! ");
INSERT INTO cam_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Pwo 4000 ni aiu na lé wiinaado, ke time uce pine ni toomwo me ni cuwo ewa! ");
INSERT INTO cam_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ke nebwén, ke e pii telé wo Iésu pie, me lé mwojuia ngemwo pelelé. Ke e taa pwo ong, ke e â ha a duaan ne Magadan. ");
INSERT INTO cam_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","É ha a céiu tan, ke lé âbé céii Iésu ne ni béé *Farasaio, me ni *Saducéen, be nimelé me lé pipwohuô ten. Ke lé pii ten pie: «Go habwii teme ace *pipwojunuun de Padué celi e kom.» Be nimelé me lé habwii pie time e uce penem ko a junuu Padué. ");
INSERT INTO cam_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ke e hegi ne telé pie: «Me e megele a miiden heme e nuule a téale, ke geé pii pie, o wâé amu. ");
INSERT INTO cam_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","«Ke me pipiing a amu ko a acaama, ke geé pii pie, o ute. Be geé caa te temehi heme wâé a amu, ai é heme ta a amu. Kehe icehi ana me geé alihi ni naado na e ko tuie jenaa, ke time geé uce temehi ace bwopiinen! Be hemepie geé ko alihi ehi, ke geé temehi ehi ana nime Padué me geé pwo. ");
INSERT INTO cam_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","É mu ko ade na geé tee cuwo ko ilehi ce pipwojunuun, wogewé ni apulie jenaa? Te junihe ta gewé be time geé uce piténede Padué! O te tice mwo ace céiu pipwojunuun celi geé mwo alihi mwo, koja ali e too péroféta Jonas ânebun.» Ke e engen kojalé wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","É he lé hagéi a *jié Galilé wo lépwo *acémun de Iésu, ke lé neuhi me lé pé pwoloa. ");
INSERT INTO cam_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ke e pii telé wo Iésu pie: «Geé pipwocilekewé ne ko a ‘nyaa te pwoloa’ te ni Farasaio me ni Saducéen!» ");
INSERT INTO cam_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ke lé pipii telé wo lépwo acémun den pie: «Wieli é mu ko ana time genye uce pé pwoloa?» ");
INSERT INTO cam_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ke e te téne wo Iésu, ke e pii telé pie: «Te junihe wahin kuti ni céihi tewé! É mu ko ade na geé tee cuwo ko cihe ko a pwoloa? ");
INSERT INTO cam_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Mwo te time geé uce temehi kuti? Kona time geé uce niimihi li nim pwoloa te li 5000 apulie? É ha a tan naa, ke li geé tai mwo celi niile élele? ");
INSERT INTO cam_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ai, li 7 pwoloa ne te li 4000 apulie, ke a tan naa, ke niile ce élele celi geé tai mwo? ");
INSERT INTO cam_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","«É caa te pii tewé pie: Geé pipwocilekewé ko a ‘nyaa te pwoloa’ te ni Farasaio, me ni Saducéen. Kehe time é uce pii tewé ce pwoloa celi me nye eni! Ke kona time geé uce temehi anaa?» ");
INSERT INTO cam_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ke lé bwobe temehi wo lépwo acémun den pie, e pii telé pie, me lé pipwocile ni cémun de ni Farasaio me ni Saducéen. ");
INSERT INTO cam_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ke lé engen wo Iésu me lépwo acémun den, ke lé tuie nge ha a céiu duaan ko a pwomwo ubwo Césaré-Filip. Ke e tahimwolé pie: «Kona lé pii pie woté ne kong ne ni apulie? Lé pii pie woéo ke woo, woéo pa Nahi Apulie?» ");
INSERT INTO cam_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ke lé hegi ne ten pie: «Lé pii ne ni béén pie wogo, ke wo *Ioane pa apipuu apulie. Ke lé pii ne ni béén pie péroféta *Élia. Ke lé pii mwo wo lépwo béén pie Iérémia, ai pace céiu pibéé ni péroféta ânebun.» ");
INSERT INTO cam_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ke e tahimwolé wo Iésu pie: «Ke kona wogewé ke?» ");
INSERT INTO cam_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ke e hegi ne ten wo Simon Pétéru pie: «Wogo, ke pa *Mesia, pa *Naî Padué na e mulip.» ");
INSERT INTO cam_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ke e pii ten wo Iésu pie: «Adéiko go Simon pa naî Jonas, be time uce wo pace céiu apulie paceli e pwo me go temehi anaa, kehe te wo Caa jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ke é pii tem jenaa ni pie: A niim pie Pétéru, a bwopiinen pie ‘a péi’. Ke é pwo a péi naa, ke é o bahi a *Mwaiitihi tong. Ke a junuu a melepiing, ke tice niihe ne kon. ");
INSERT INTO cam_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","É bo ne tem ni kilé ko a *Mwametau he Miiden, ke ati nina go paciitihi† ne éni pwo bwohemwo, ke e o te paciitihi ne mwo jeda he miiden wo Padué. Ke ati nina go pii pie wâé ne éni pwo bwohemwo, ke e o te pii pie wâé ne mwo jeda he miiden.» ");
INSERT INTO cam_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ke e paciitihi ko lépwo acémun den wo Iésu pie, me lé nemwo pii te ni apulie pie weeng pa Mesia. ");
INSERT INTO cam_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tabuhi ha a tan naa, ke e pii beetihi te ni acémun den wo Iésu pie: «Wâé heme é â *Iérusaléma, beme é mu he ni picani na ubwo na lé o pwo wo lépwo apihuô, me lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén. Ke lé bo pwo me é mele. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é o bo mulie cemwo.» ");
INSERT INTO cam_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ke e tode Iésu nge ha a céiu duaan wo Pétéru, ke e cihe me ubwo ne kon, ke e pii ten pie: «Ûhu, Padaame! O te tice celi e o tooko celi wonaa!» ");
INSERT INTO cam_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ke e biteeng wo Iésu ne kon, ke e pii pie: «*Caatana, go engen mu he pwahamiing! Be go teko pwobwoniéo koja ana te nime Padué kon. Be time go uce niimihi pwohewii Padué, kehe go niimihi pwohewii ni apulie!» ");
INSERT INTO cam_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","E pii te ni acémun den wo Iésu pie: «Wo paceli nimen me e âbé céing beme pa acémun dong ke me e nemwo bo uce piniimieng mwo. Kehe wâé heme e canihi a *kuricé ten, ke me e âbé céing. ");
INSERT INTO cam_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Be wo pana nimen me e celuimi a mulihen, ke e o patieden. Kehe wo pana e patieden a mulihen mu kong, ke o celuimieng. ");
INSERT INTO cam_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","He ade ne te pa apulie, hemepie e hegi ati ni naamuu a bwohemwo, ke me e patieden a mulihen? Kona ace de aceli o jan me e ne, beme e pwocuhi mwo a mulihen? ");
INSERT INTO cam_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","28","«Geé tabemi ehi: É pii tewé ati anaa, be é o bo mwojuia mwobé, me é ne a pwodaame tong, woéo pa Nahi Apulie. Ke geme bo âbé me ni *âcélo tong ha a junuu Padué, me a bwo ubwo na a wâé ten. Ke é bo ne ce ceme ni penem de ni apulie. Ke pwo lépwo béén na élé éni jenaa, na lé o mwo te alihi anaa, ânebuhe ce bwo mele telé.» ");
INSERT INTO cam_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Alecehe ni tan na 6, ke wo Iésu, ke e pé Pétéru, me lupwo pwénaâjién wo Cang me Ioane. Ke lé taa pwo a juwole na te nihe ubwo. ");
INSERT INTO cam_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ke pitaatééhi a bwo alieng ne he pwahamiilé. Be pwodaadii a pwahamiin pwohewii a téale, ke pwojo pwomelaa ni epwénen pwohewii a pwéélang. ");
INSERT INTO cam_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ke lé te ali kuti *Moosé me *Élia, lupwo alo péroféta ânebun na piubwo julu he lé ko picihe me weeng. ");
INSERT INTO cam_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ke e pii te Iésu wo Pétéru pie: «Padaame, te nihe wâé heme genye ko mu éni. Hemepie nimem, ke é o pacuuli ce mwa mwaanu celi cié ne éni, beme a dem a céiu, ke me a de Moosé a céiu, ke me a de Élia a céiu.» ");
INSERT INTO cam_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","É he e mwo teko cihe, ke e te âbé kuti a menii na pwomelaan, ke e taluilé. Ke lé téne a pwocihe bé mu ha ali menii, na e pii pie: «Wo paje, ke pa Naîng na te céiu nang na te junihe eânimung den. Ke geé piténedeeng!» ");
INSERT INTO cam_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ke me lé téne a pwocihe naa wo lépwo acémun den, ke lé tidihi jililé, ke lé miibule, be mwotilé. ");
INSERT INTO cam_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ke e âbé céiilé wo Iésu, ke e ti kolé, ke e pii telé pie: «Geé cuwoda! Ke geé nemwo pwo me mwotikewé!» ");
INSERT INTO cam_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ke me lé alehede, ke lé alihi pie, caa te piwoélé cehi me Iésu. ");
INSERT INTO cam_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ke me lé homwobé mu pwo juwole, ke e pii mwoiuhi telé wo Iésu pie: «Geé nemwo pii te ce béé apulie nina geé alihi, dieli ha ace tan celi é bo mulie cemwo mu ha amele, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ke lé tahimwo Iésu pie: «Lé pii wo lépwo *dotéén ko patén pie, wo Élia, ke pana me e mi âbé ânebuhe pa *Mesia. Ke he wonaa be woté?» ");
INSERT INTO cam_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ke e hegi ne telé wo Iésu pie: «Éa kuti, e mi âbé wo Élia, beme e pine ehi ati ni naado he ni amu nen. ");
INSERT INTO cam_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Kehe icehi ana é pii tewé pie: E caa te âbé wo Élia, kehe time lé uce temehieng ne ni apulie, ke lé te pwo ten nina nimelé kon. Ke te pwohewii ne mwo kong, be é bo mu he ni picani mu kolé, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ke lé bwo temehi wo lépwo acémun den pie, e cihe telé ko *Ioane pa apipuu apulip. ");
INSERT INTO cam_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Me lé homwobé mu pwo juwole wo Iésu me lépwo acémun den na cié jélé, ke lé tooli a pubu apulie. Ke e âbé céii Iésu wo pa céiu apulie, ke e tidihi jilin ânebuhen. ");
INSERT INTO cam_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ke e pii ten pie: «Padaame, go pipwoééhe pa naîng, be e kon a duéé na e pwo me éjén nang, ke te junihe cunu nang kon. É he ni béé benaamwon, ke e mu tahieng da pwo miû, ai é he tabe. ");
INSERT INTO cam_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ke é caa pééeng bé céii lépwo acémun dem, ke time uce jan me lé pwo me wâé nang.» ");
INSERT INTO cam_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ke e pii telé wo Iésu pie: «É te junihe pipwoééhewé wogewé ni apulie jenaa! Mwo te time geé uce téele céihi, be wogewé ni apwo mwoiu pun! O é dieli éniile celi é o mwo te mu pelewé, ke me é mwo tee picani ne kowé? Geé pébé éni pa cuwo ewa naa!» ");
INSERT INTO cam_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ke e peni ali duéé wo Iésu, ke e pii ten pie: «Go wie!» Ke e wie, ke te wâé kuti pali cuwo nahi ewa. ");
INSERT INTO cam_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","É alecehen, ke me lé bwo te pimu cehi wo Iésu me lépwo acémun den, ke lé âbé mwonueng, ke lé tahimwoeng pie: «É ko ade na time uce jan me geme pwo me e wie ali duéé?» ");
INSERT INTO cam_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ke e hegi ne telé pie: «Wonaa be te junihe wahin kuti a céihi tewé. Kehe é pii tewé a juuju pie: Hemepie a céihi tewé, ke me te ju wahin pwohewii a pide moutarde, ke o te jan me geé pii te a juwole ce pie: “Go engen mulang”, ke e o te engen! Ke o te tice aceli o pwocoon ne kowé. ");
INSERT INTO cam_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","{Be o te icehi mu ko a pwoiitihi te Padué, me a pipatupwo wiinaado, na o jan me geé pawiehi a bwo pwo duéé naa.}» ");
INSERT INTO cam_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","É alecehen, ke lé pipwotapitihi ne Galilé wo Iésu me lépwo acémun den. Ke e pii telé pie: «O bo icuéo te ni apulie, woéo pa Nahi Apulie. Ke lé bo imwiéo, ");
INSERT INTO cam_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ke lé o bo pwo me é mele, kehe é ha a béciéhe ni tan alecehen, ke é bo mulie cemwo mu ha amele.» Ke me lé téne anaa, ke te junihe piwahin jélé kuti. ");
INSERT INTO cam_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lé tehene nge Kapernaüm wo Iésu me lépwo acémun den. Ke lé âbé céii Pétéru wo lépwo *atai mwani cuhi puni apulie ko a *mwaiitihi, ke lé tahimwoeng pie: «Kona wo pa caa tewé, ke e te ne mwo a cuhi puni apulie ko a mwaiitihi?» ");
INSERT INTO cam_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ke e hegi ne telé wo Pétéru pie: «Éa! E te pwocuhin mwo!» É alecehen, ke lu taa ha a mwa me Iésu. Ke e te pwome cihe wo Iésu, ke e pii te Simon Pétéru pie: «Simon, de ace bwo alihi nen dem? Woo paceli e o pwocuhi puni apulie ne te pa daame? Wo pa eapwihi amu, ai wo pa aâbé?» ");
INSERT INTO cam_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ke e hegi ne ten wo Pétéru pie: «Wo pa aâbé.» Ke e pii ten wo Iésu pie: «Éa kuti, beme wo pa eapwihi amu, ke time e o uce pwocuhin. ");
INSERT INTO cam_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kehe icehi ana genyu nemwo pwotahinaado ne kolé. Go â tapwé, ke ace ikua celi go céi, ke go waa a pwon, be go o tooli a mwani, ke go pébé me a cuhi puni apulie tenyu ko a mwaiitihi.» ");
INSERT INTO cam_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","É ha a benaamwon naa, ke lé âbé céii Iésu wo lépwo acémun den, ke lé tahimwoeng pie: «Kona woo paceli piubwo nang ne ha a *Mwametau he Miiden?» ");
INSERT INTO cam_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ke e tode pa cuwo nahi ewa, ke e neeng ha awiemelé. ");
INSERT INTO cam_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ke e pii telé pie: «Geé tabemi ehi, be é o pii tewé a juuju pie: Mepie time geé uce pwo me piwahin gewé, me geé pwohewii ni cuwo ewa, ke time geé o uce taa ha a Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ke hemepie pwo pace apulie celi e pwo me piwahin nang pwohewii pa cuwo nahi ewa ce, ke o bo piubwo nang ne ha a Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ke wo pana e hegi ne he niing pace cuwo nahi ewa pwohewii paje, ke e hegiéo.» ");
INSERT INTO cam_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«Go nemwo pwotahi a céihi te pa apulie na e céihi ne kong pwohewii a cuwo nahi ewa, be o te junihe ubwo a cuhinaado tem. Ke wâé heme cie ace pilehe péi ne ko a henem, ke o tahiko ole ha anumwihi! ");
INSERT INTO cam_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","O te cuwo ko pwo ni bwomunen me nye tupwo ne ha a ta ne pwo a bwohemwo ce. Kehe go pipwocile, be o te junihe ubwo a cuhinaado te pana e pwo me lé tupwo ne ha a ta wo lépwo béén. ");
INSERT INTO cam_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«Mepie a watihen a im, ai a am, me go pwo ana ta, ke go tahagéi, ke go tahi taabwon nge ité kojako. Be wâé heme go taa ha *a ju mulip pele Padué, hemepie te céiu a im, ai te céiu a am. Kehe te junihe pwoééhem heme go te cile lupwo im, me am, ke me tahiko ne ha a miû na te tice pwonehin. ");
INSERT INTO cam_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ke me watihen a naamiim me go pwo ana ta, ke go tuu tahi nge ité kojako. Be wâé heme go taa ha a ju mulip pele Padué, hemepie te céiu a naamiim. Kehe te junihe pwoééhem me go tee cile lupwo naamiim, ke me tahiko ne ha a miû. ");
INSERT INTO cam_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Geé pipwocilekewé, beme geé nemwo tééti ni cuwo nahi ewa na lé céihi ne kong! Be é pii tewé a juuju pie: Ni *âcélo na lé te wéilé, ke te élé pele Caa tong jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","{Be woéo pa Nahi Apulie, ke é âbé me é *celuimi nina lé pipatieden.}» ");
INSERT INTO cam_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«Ade ace bwo niimihinaado tewé ne ko a jepule ce? «Pwo pa céiu apulie, na pwo 100 ni muto ten. Ke mepie tieden aceli te ju céiu nang, ke e o pwo de? E o necu nelang li 99 muto, ke e o â hane ali muto li e pipatieden. ");
INSERT INTO cam_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ke me e tooeng, ke a tan naa ke e te junihe pipwodéén ko a muto na te ju céiu, koja nina 99 na lé te mu. Ke geé tabemi ehi, be é pii tewé a juuju pie: ");
INSERT INTO cam_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","O wonaa ne ko Caa tewé na e jeda he miiden, be time uce nimen me e patieden paceli te ju céiu nang mu ko ni naîn.» ");
INSERT INTO cam_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Mepie e pwo {tem} aceli ta wo pa céiu acéihi béém, ke go â tooeng, ke geu mi picihe ehi, ke go habwii ten ana ta na e pwo. Ke me e piténedeko, ke caa wâé, be go caa pééeng koja a ta. ");
INSERT INTO cam_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ke me time e uce piténedeko, ke go pé pace ai wo lupwoce acéihi me geé picihe me weeng, beme lu bo pajuujuhi a picihe tewé pwohewii ana caa te tii ne he ni tii iitihi pie: Wâé heme alo ai cié ni *apajuujuhi nen. ");
INSERT INTO cam_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ke mepie muhi ten me e ténedekewé, ke go â pii te ni apwoiitihi. Ke mepie muhi ten me e ténede ni apwoiitihi, ke geé nemwo pipéce ne kon, be e bo â pwohewii nina time lé uce céihi, me ni *atai mwani cuhi puni apulie. ");
INSERT INTO cam_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","«Geé tabemi ehi, be é o pii tewé a juuju pie: Ati nina geé paciitihi ne éni pwo bwohemwo, ke e o te paciitihi ne mwo jeda he miiden wo Padué. Ke ati nina geé pii pie wâé ne éni pwo bwohemwo, ke e o te pii pie wâé ne mwo jeda he miiden.» ");
INSERT INTO cam_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«A céiu mwo, ke wo lupwoceli alo julu mu kowé, ke me céiu julu ne ko aceli lu pwoiitihi ne kon, ke e o bo pwo ne telu wo Caa tong jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Be mepie alo ai me cié celi lé neibulé ne he niing, ke woéo ha awiemelé.» ");
INSERT INTO cam_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","E âbé céii Iésu wo Pétéru, ke e tahimwoeng pie: «Padaame, hemepie e te cuwo ko pwotahi ne kong wo pa bééng, ke o oniile jo ko pineueng? Dieli ko 7?» ");
INSERT INTO cam_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ke e hegi ne ten wo Iésu pie: «Time é uce pii tem pie, é dieli ko 7, ai é dieli ko 7000. Kehe go te pineueng taaci. ");
INSERT INTO cam_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Be a Mwametau he Miiden, ke pwohewii ani: «E bwo mu wo pa céiu daame, ke nimen me e temehi ace jéhi ce kérédi te ni eabwé ten. ");
INSERT INTO cam_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ke e tabuhi mu ko pa céiu, ke lé pébé céiieng pana e caa taa pwo ni milliard na hiwon ni kérédi ten. ");
INSERT INTO cam_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ke caa time uce jan me e wodehin. Ke e pii wo pa daame pie: “Me icueng beme pa *apenem tice ja kon. Ke icu mwo mwoden, me ni naîn, me ni naamuun! Icuhi ati, beme e pwocuhi ni kérédi ten!” ");
INSERT INTO cam_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","«Kehe icehi ana wo paje, ke e tidihi jilin he pwahamii pa daame, ke e é, me pii ten pie: “É ileko pie, go nemwo wele, be é bo te pwocuhi ne tem ati!” ");
INSERT INTO cam_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","«Ke e te pipwoééhen wo pa daame, ke e ciitili taabwon ni kérédi ten, ke e neeng me e engen. ");
INSERT INTO cam_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«Ke nebwén, ke e engen wo pali eabwé, ke pitapitilu me pa béén ko penem, na e pé kojaeng a mwani péi na te ju céiu. Ke e imwi pali, ke e pwoti henen, ke e pii ten pie: “Go piepin me go wodehi ni mwani tong!” ");
INSERT INTO cam_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","«Ke e tidihi wo pali he pwahamiin, ke e pii ten pie: “É ileko pie, go nemwo wele, be é bo te wodehin ne mwo tem!” ");
INSERT INTO cam_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","«Kehe icehi ana muhi te paje, ke e neeng da he karépu, ucéihi ace bwo wodehi ne ni kérédi ten. ");
INSERT INTO cam_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","«Ke lé téetihi ne ni béélu ko penem, ke te junihe muhi telé, ke lé â pitéteiminaado te pa daame helé. ");
INSERT INTO cam_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","«Ke e tode pali eabwé wo pa daame, ke e pii ten pie: “Wogo, ke pa eabwé na piticenaado ne kom! Be li é ciitili ati li kérédi tem li te junihe ubwo, be he li go ko âbé é ne kong! ");
INSERT INTO cam_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ke wogo mwo, ke me go pipwoééhe pa béém, pwohewii a bwo pipwoééhem dong!” ");
INSERT INTO cam_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","«Ke e te junihe okéé wo pa daame, ke e pwo me imwi pali eabwé, ke e neeng he karépu. Ke e pwocuhinaado ten, ucéihi ace bwo wodehi na ati ni kérédi ten.» ");
INSERT INTO cam_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ke e panebwénihi a ocine naa wo Iésu, ke e pii pie: «O wonaa ana e o pwo tewé wo Caa tong jeda he miiden, hemepie time geé uce pineu pa bééwé acéihi he ni ju pwonimewé.» ");
INSERT INTO cam_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Me e pii ati anaa wo Iésu, ke e engen mu ha amu Galilé, ha a duaan *Judé ne gaale cemwo ne ko a éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ke hiwon ni apulie na lé âcéin, ke e pwo me wâé nina cunu jélé. ");
INSERT INTO cam_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ke lé âbé céiieng ne ni béé *Farasaio, ke lé pwo me lé pipwohuô ten, ke lé tahimwoeng pie: «Kona te pwo mwomwon de pa apulie ne he ni patén, me e cibéé ê mwoden? He ade ace watihen me e cibééeng?» ");
INSERT INTO cam_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ke e hegi ne telé wo Iésu pie: «Kona time geé uce pine ana caa te tii ne he ni tii iitihi? Be caa tii pie, é ha atabuhi kon, me e tabuhi a bwohemwo wo Padué, ke e ne pa aiu me ê toomwo. ");
INSERT INTO cam_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ke e pii wo Padué pie: Ke é mu ko anaa, ke e patupwo lu nyaa me caa ten wo pa aiu, beme lu pimu me ê mwoden. Ke me wonaa, ke caa céiu julu. ");
INSERT INTO cam_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","«É ko anaa na é pii tewé pie: Caa time bo uce alo mwo lupwoce apulie, kehe caa te ju céiu julu. Ke geé nemwo pineitééhi mwo nina e caa pineibuhi wo Padué!» ");
INSERT INTO cam_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ke lé hegi ne ten wo lépwo Farasaio pie: «Ke me wonaa, ke kona é ko ade na e pii wo *Moosé pie, pwo mwomwon de pa apulie me e pawie mwo ê mwoden, hemepie e pwo ace tii me pitahagéi piaten?» ");
INSERT INTO cam_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ke e pii telé wo Iésu pie: «E ne a mwomwon dewé, be te junihe mwoiu ni puniwé! Kehe icehi ana é ha atabuhi kon, ke time uce wonaa. ");
INSERT INTO cam_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","É ko anaa na é pii tewé pie: Go nemwo cibéé ê mwodem na time uce ê abune aiu. Be, me go cibééeng, ke me go piaten mwo, ke go bune toomwo koja ê mwodem ânebun.» ");
INSERT INTO cam_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lé pii te Iésu wo lépwo acémun den pie: «Heme wonaa, ke wâé heme tice piaten!» ");
INSERT INTO cam_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ke e hegi ne telé pie: «A pwooti naa, ke time e uce ne, me de ati ni apulie, kehe wo Padué, ke e te ne cehi te ni béén me lé hegi. ");
INSERT INTO cam_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Be te pwo ni béén na time lé uce piaten, be time uce jan me lé pwo, mu he ni bwo âbeele telé. Ke pwo ni béén na te tice naîlé ko nina lé pwo ne ko ni éélé ni apulie. Ke pwo ni béén na time lé uce piaten, be watihen a *Mwametau he Miiden. Be nimelé me lé pipwoeabwé ehi te Padué. Wo paceli nimen me e hegi a pwooti naa, ke wâé heme e hegi!» ");
INSERT INTO cam_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","É alecehen, ke lé âbé céii Iésu ne ni béé apulie, ke lé pébé céiieng ni cuwo ewa, beme e ne ni in huîilé, ke me e pwoiitihi me delé. Kehe icehi ana lé cihe me ubwo ne kolé wo lépwo acémun den, ke lé pacuwolé. ");
INSERT INTO cam_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kehe icehi ana e pii telé wo Iésu pie: «Geé ne ni cuwo nahi ewa me lé âbé céiiéo! Geé nemwo pacuwolé! Be a Mwametau he Miiden, ke a de ni apulie na lé pwohewii ni cuwo nahi ewa.» ");
INSERT INTO cam_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ke e ne ni in wo Iésu pwo puni ni cuwo ewa ke e adéilé. Ke é alecehen, ke e engen mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","É he e mwo ko wonaa wo Iésu, ke e te tuie kuti wo pa céiu apulie, ke e tahimwoeng pie: «Pa apipune, he ade aceli me é pwo celi o wâé, beme é hegi a *mulie dieli mwo ne pele Padué?» ");
INSERT INTO cam_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ke e hegi ne ten wo Iésu pie: «Kona é mu ko ade na go tahimwoéo ko aceli wâé? Te céiu pana wâé nang. Ke hemepie nimem me pwo ne tem *a ju mulip, ke go piténedehi ni patén den.» ");
INSERT INTO cam_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ke e pii ten wo pali pie: «Kona de ce patén den?» Ke e hegi ne ten wo Iésu pie: «Go nemwo taunuhi apulie; Go nemwo pibune; Go nemwo bune; Go nemwo geti ni apulie; ");
INSERT INTO cam_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Go paciiti lu nyaa me caa tem; Go pwo me eânimem de ni béén, pwohewii a bwo pieânimem dem.» ");
INSERT INTO cam_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ke e hegi ne ten wo pali apulie pie: «É caa te ténedehi kuti ninaa, ke he ade aceli me é pwo mwo?» ");
INSERT INTO cam_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ke e hegi ne ten wo Iésu pie: «Mepie nimem me te junihe wâé ehi ni huô tem ne he pwahamii Padué, ke go engen, ke go â icuhi ati ni den, ke go ne ni cuhin ne te nina tice delé, be me wonaa, ke o pwo ce dem ne pele Padué. Ke nebwén, ke go âbé céing.» ");
INSERT INTO cam_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kehe me e téne anaa wo paje, ke te junihe piwahin nang, be te junihe pwo den, ke e engen. ");
INSERT INTO cam_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ke e pii wo Iésu te lépwo acémun den pie: «Geé tabemi ehi, be é pii tewé a juuju pie: Wo pa apulie na te junihe pwo den, ke te junihe pwocoon den me e taa ha a Mwametau he Miiden. ");
INSERT INTO cam_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kona a chameau, ke te jan ne kon me e taa ha a pwon ko a diti? Ûhu, pwocoon, kehe é pii tewé pie: Wo pa apulie na te junihe pwo den, ke mwo te junihe pwocoon ne kon me e taa ha a *Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ke lé te junihe téetihi wo lépwo acémun den, ke lé pii pie: «Ke kona woo paceli jan me e piceluimieng?» ");
INSERT INTO cam_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ke e omelé wo Iésu, ke e pii telé pie: «Ana time uce jan ne ko pa apulie me e pwo, ke jan ne ko Padué. Be ati ni naado, ke te tai jan ne ko Padué.» ");
INSERT INTO cam_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ke e pii ten wo Pétéru pie: «Wogeme, ke geme caa patupwo ati ni naado, beme geme âcéim. Ke he ade aceli geme o hegi?» ");
INSERT INTO cam_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ke e hegi ne telé wo Iésu pie: «Geé tabemi ehi, be é o pii tewé a juuju pie: E bo taatééhi me mwo coho ati ni naado wo Padué. Ke é ha a tan naa, ke woéo pa Nahi Apulie, ke é o bo tebwo pwo atebwo tong ne ha *a wâé tong. Ke wogewé na geé âcéing, ke geé tebwo pwo ni 12 atebwo te lépwo daame, beme geé o pihuô te ni 12 pwomwoiu *Isaraéla. ");
INSERT INTO cam_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","«Ke wo paceli e patupwo a pomwa ten me ni âjiénen, me ni toomwo pwaadeniin, me lu nyaa me caa ten, me ni naîn, me ni apwoamu ten, watihen a niing, ke e o bo hegi celi piwéden, celi te junihe ubwo ke hiwon, ke o pwo den ko a mulie dieli mwo ne pele Padué. ");
INSERT INTO cam_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ke hiwon nina lé ânebun jenaa, na lé bo alece. Ke hiwon nina lé alece jenaa, na lé bo ânebun.» ");
INSERT INTO cam_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","E pii mwo telé wo Iésu pie: «A *Mwametau he Miiden, ke pwohewii ani: «E bwo mu wo pa eapwihi a ni tabe megele, ke e bwo wie he mwo ju acaama ne ha apwojenep, beme e hane ce apenem den. ");
INSERT INTO cam_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ke e too ni béén, ke lé caa piténelé pie, me e pwocuhilé ko a cuhi a tan na céiu ko penem. Ke e nelé nge ha apwoamu. ");
INSERT INTO cam_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","É nge ko 9 inetéale ha acaama, ke e wie mwo ne ha apwojenep, ke e ali mwo ni béén na te tice celi lé pwo. ");
INSERT INTO cam_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ke e pii telé pie: “Wogewé mwo, geé âmwo penem ha ali apwoamu tong, be é bo te ne ace cuhikewé celi jan.” ");
INSERT INTO cam_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","«Ke lé engen. Ke e wie mwo he te ju goahen wo pali, ke e pé mwobé ni béé apenem. Ke piwien mwo ko cié inetéale alecehe a goahen. ");
INSERT INTO cam_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","«Ke nebwén, ke e wie mwo nge ko nim inetéale, ke e too mwo ni béén na lé teko pitabée, ke e tahimwolé pie: “Lépwoje, kona geé teko pwo de? Te tice aceli geé pwo?” ");
INSERT INTO cam_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","«Ke lé hegi ne ten pie: “Wonaa, be te tice paceli me e péékeme me geme penem.” «Ke e pii telé pie: “Wogewé mwo, ke geé â penem ha apwoamu tong.” ");
INSERT INTO cam_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","«Ke â babwén, ke e pii te pa caa te penem den pie: “Go todebé lépwo apenem, ke go pwocuhilé, ke go mi pwocuhi lépwoli lé bwo penem alece, ke go bwo panebwénihi ne ko lépwoli lé mi penem.” ");
INSERT INTO cam_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«Ke lé mi âbé wo lépwoli lé bwo penem alece, ke lé pé ni cuhilé pwohewii a cuhi penem he na céiu tan. ");
INSERT INTO cam_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ke me lé alihi anaa wo lépwoli lé mi penem, ke lé piniimihi pie: ‘Wâé, be genye o hegi celi piwéden!’ «Kehe icehi ana lé te hegi mwo, pwohewii ana lé te hegi wo lépwo apenem alece. ");
INSERT INTO cam_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ke lé okéé ne ko pali eapwihi apwoamu, ");
INSERT INTO cam_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ke lé pii ten pie: “Wo lépwoje, ke lépwoli lé bwo tuie alece, ke te céiu a inetéale na lé penem hen, ke go ne me te piwie a cuhikeme! Kehe wogeme, ke geme picani ko ni bwo mwaale geme, ke cinikeme na a téale!” ");
INSERT INTO cam_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","«Ke e hegi ne te pa céiu béélé wo pali eapwihi apwoamu, ke e pii ten pie: “Pa bééng, go nemwo niimihi pie é pihaamiko, be li genyu caa te piténekenyu ne ko a cuhiko. ");
INSERT INTO cam_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Go pé ni mwani tem, ke go engen, be nimung me é ne te nina lé alecehem celi piwien me wogo. ");
INSERT INTO cam_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Te pwo mwomwon dong me é pihuôhi ni mwani tong. É ko ade na go piniimihi tahi he é pwo ana wâé ne ko ni béén?”» ");
INSERT INTO cam_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ke e panebwénihi a ocine naa wo Iésu, ke e pii pie: «Wo lépwona lé alece, ke lé o bo ânebun, ke nina lé ânebun, ke lé bo alece.» ");
INSERT INTO cam_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lé mwo ko engen me lé â *Iérusaléma wo Iésu me lépwo 12 acémun den me ni béé apulie. Ke e pé itéhi ni acémun den, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Geé téne, genye o caa taa Iérusaléma. Ke é nelang he na o neéo, woéo pa Nahi Apulie, te lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén. Ke lé bo tautiéo die ko ace bwo taunuéo, ");
INSERT INTO cam_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ke lé o neéo te nina te tice céihi telé. Ke woélé, ke lé o pihooniéo, ke lé o ahiéo ko a bwaliiwota, ke lé o cemeiteéo ne ko a *kuricé, dieli ko a bwo mele tong. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é o mulie cemwo mu ha amele.» ");
INSERT INTO cam_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","É alecehe anaa, ke lé âbé céii Iésu wo mwode Zébédé me lupwo naîn. Ke e tidihi jilin he pwahamiin wo êje, beme e ilehi kojaeng a céiu naado. ");
INSERT INTO cam_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ke e pii ten wo Iésu pie: «De aceli nimem kon?» Ke e hegi ne ten pie: «É hemepie go bo mu ha a Mwametau tem me ha *a wâé tem, ke wâé heme go pwo me lu tebwo ko ni piduaam wo lupwo naîng ce: wo pa céiu ne pwo juim, ke wo pa céiu ne pwo eaamum.» ");
INSERT INTO cam_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ke e pii te lupwoli pwénaâjién wo Iésu pie: «Time geu uce temehi ana geu ko ilehi! Kona geu o te ûdu a tabe ko picani na é o ûdu?» Ke lu hegi ne ten pie: «Éa, o te jan ne komu!» ");
INSERT INTO cam_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ke e pii telu pie: «Éa kuti, geu o te ûdu a tabe na é o ûdu. Kehe time o uce woéo na é pihuôhi pie, woo paceli e o tebwo pwo a ing ne pwo jui, ke é pwo eaamung. Be te wo Caa tong na e caa te piwâamihi ni atebwo naa, me de ni béén na e caa te pipégalilé.» ");
INSERT INTO cam_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Me lé téne a pwocihe naa wo lépwo 10 acémun béélu, ke lé te junihe okéé ne ko lupwo pwénaâjién naa. ");
INSERT INTO cam_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ke e todelé wo Iésu, ke e pii telé pie: «Geé temehi pie, é ne pele ni béén na time uce ni apulie te Padué, ke lé caaite ni apulie wo lépwo daame me lépwo apihuô. Ke lé pwo me piubwo jélé. ");
INSERT INTO cam_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kehe wogewé, ke geé nemwo pwohewiilé! Be wo pana nimen me piubwo nang ne hadeniiwé, ke wâé heme e pipwoeabwé tewé. ");
INSERT INTO cam_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ke wo pana nimen me e pihuô tewé, ke wâé heme pa céiu *apenem tice ja kon ne pelewé. ");
INSERT INTO cam_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wâé heme geé pipwohewiiéo, woéo pa Nahi Apulie, be time é uce âbé beme lé pipwoeabwé tong. Kehe é âbé beme é pipwoeabwé te ni apulie, ke me é patupwo a mulihung, beme cuhi a bwo *celuimi ni apulie na hiwon jélé.» ");
INSERT INTO cam_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","É alecehe a bwo â Iériko telé, ke lé wie wo Iésu me lépwo acémun den. Ke te junihe hiwon ni apulie na lé âcéilé. ");
INSERT INTO cam_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Pwo lupwo bwi na lu tebwo ko a jije pwaaden. Ke me lu téne pie e tuie wo Iésu, ke lu te toii da kuti pie: «{Padaame,} pa *Naî Davita, go pipwoééhemu!» ");
INSERT INTO cam_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ke lé pihaalu ne ni apulie, beme lu nemwo cihe. Kehe icehi ana lu bwo junihe cihe da ko miiden kuti, ke lu pii pie: «Padaame, pa Naî Davita, go pipwoééhemu, ke go picani temu!» ");
INSERT INTO cam_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ke e â cuwo wo Iésu, ke e todelu, ke e tahimwolu pie: «Ade aceli nimeu me é pwo me deu?» ");
INSERT INTO cam_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ke lu hegi ne ten pie: «Padaame, me go tehi ni naamiimu, me gemu niê.» ");
INSERT INTO cam_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ke e te junihe pipwoééhelu wo Iésu, ke e pétaa ko ni naamiilu. Ke lu caa te niê kuti pwohewiin ânebun. Ke lu âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","É he lé mwo ko engen me lé â *Iérusaléma wo Iésu me lépwo acémun den, ke lé caa âmwonuhi Betfagé, a mwopopwaalé na e mwonuhi a juwole ko ni Olivier. Ke e mi ne ngen lupwo alo acémun den wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Ke e pii telu pie: «Geu â ha a mwopopwaalé na e ânebuhenye. Ke geu bo tooli nelang a buriko na lé taaeng, me a naîn. Ke geu tuwolu, ke geu péélu bé céiiéo. ");
INSERT INTO cam_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ke mepie lé tahimwokeu ko aceli geu pwo, ke geu hegi ne telé pie: “Nime Padaame kolu.” Ke lé o nelu teu.» ");
INSERT INTO cam_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E tuie a bwopwonen naa, beme e pacuwohi ali e pii wo Padué, na e pwaadeniin bé wo pa péroféta ten pie: ");
INSERT INTO cam_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Go pii te Iérusaléma, pie: Go alihi, go ê toomwo *Sion, be e âbé céiiko wo Padaame hem! Te junihe bwala a pwonimen, be e âbé ha a péém. E tebwo pwo a nahi buriko, a wota na e pé ni âneule. Ésaïe 62.11; Zakari 9.9 ");
INSERT INTO cam_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ke lu engen wo lupwoli acémun, ke lu te tai pwo ati nina e pii telu wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ke lu pébé ali nyaa te buriko me ali naîn, ke lé ne ni epwén huîilu wo lépwo acémun den. Ke e bwo taa tebwo huîi ali nahi buriko wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Hiwon ni apulie na lé talihi ni mwaanu telé nge pwo a pwaaden ânebuhe Iésu beme lé pipaunueng. Ke ni béén, ke lé tahagéi ni mii acuwo na mwo wamin, ke lé ne pwo a pwaaden. ");
INSERT INTO cam_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ke hiwon ni apulie na lé ânebun ke lé alecehe Iésu. Ke lé tai toii da pie: «Osana! Pipwoun de Padué! Pipaunu pa *Naî Davita! *Adéi pa apulie na e âbé ne he nii Padaame! Psaume 118.26 Osana me adéihi! Paunu Padaame na e daaité!» ");
INSERT INTO cam_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","É he e tehene nge Iérusaléma wo Iésu, ke te junihe emegéi na ati ni apulie ha a pwomwo ubwo, ke lé pitahimwolé pie: «He woo pa apulie ce?» ");
INSERT INTO cam_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ke lé hegi ne telé ne ni apulie na lé âcéin pie: «Wo Iésu mu Nazaret é Galilé, pali péroféta li genye tee ko ucéieng.» ");
INSERT INTO cam_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","E taa ha a *mwaiitihi wo Iésu, ke e peni wie nina lé pwojenep nelang. Ke e tamiibutihi ni taap te lépwo ataatééhi mwani, ke ni atebwo te lépwo a-icuhi meni. ");
INSERT INTO cam_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ke e pii telé pie: «E pii ne he ni tii iitihi wo Padué pie: A mwa tong, ke bo toii kon pie a mwo ko pwoiitihi. Kehe wogewé, ke geé ko pwo me ataduwo te lépwo abune!» ");
INSERT INTO cam_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lé âbé céii Iésu ne ha a mwaiitihi ni bwi me ni tebwa, ke e pwo me wâé jélé. ");
INSERT INTO cam_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ke lé téetihi ne ni caa te lépwo *apwoâpwailo me ni *dotéén ko patén, he lé alihi ni naado na wâé na e pwo wo Iésu. Ke lé alihi mwo ni cuwo nahi ewa na lé cihe da ko miiden ne ha a mwaiitihi, ke lé pii pie: «Osana! Pa Naî Davita!» Ke lé te junihe okéé ne ko Iésu wo lépwo apihuô naa. ");
INSERT INTO cam_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ke lé pii te Iésu pie: «He go teko téne nina lé pii ne ni cuwo nahi ewa ce?» Ke e hegi ne telé wo Iésu pie: «Éa, time geé mu uce pine ni pwooti na tii ne he ni tii iitihi, na e pii pie: É mu pwo ni ewa me ni cuwo nahi ewa na lé mwo âbeele, ke lé bo pii a wâé tem, âcehi ana te nimem kon.» Psaume 8.3 ");
INSERT INTO cam_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ke e nelé wo Iésu, ke e wie mu ha a pwomwo ubwo beme e â Bétani, ke e pule lang. ");
INSERT INTO cam_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","É ha acaama hen, he e mwojuia ngemwo ha a pwomwo ubwo, ke menen. ");
INSERT INTO cam_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ke e alihi a *majing ne ko jije pwaaden, ke e piâmwonuhi, kehe e te ju tooli cehi ni madihin. Ke e pii ten pie: «O time o bo uce pwo mwo ce acehiko!» Ke caa te meiu kuti. ");
INSERT INTO cam_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Heme lé alihi anaa wo lépwo acémun den, ke lé te nihe téetihi, ke lé pii pie: «Woté ace bwomunen me e piepin ko meiu?» ");
INSERT INTO cam_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ke e hegi ne telé wo Iésu pie: «É pii tewé a juuju: Hemepie pwo ace céihi tewé, ke mepie time uce pinekepé tewé, ke o jan me geé pwo ana é pwo te pa majing ce. Ke o te jan mwo me geé pii te pa juwole ce pie: “Go engen mulang, ke go ole ha a jié!”, ke e o te pwo. ");
INSERT INTO cam_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","«Ati nina geé ilehi mu ko a pwoiitihi, ke geé bo hegi, hemepie geé céihi ne kon.» ");
INSERT INTO cam_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","E taa ha a mwaiitihi wo Iésu, ke e pacémuni ni apulie. Ke lé âmwonueng wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô, ke lé tahimwoeng pie: «Woo na e ne tem a pihuô me go pwo nina go ko pwo? Woo na e pahedeko?» ");
INSERT INTO cam_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ke e hegi ne telé pie: «Woéo mwo, ke é o mwo tahimwokewé ko a céiu naado. Ke hemepie geé hegi ne tong, ke é bo pii tewé pana e ne tong a pihuô me é pwo ni naado naa. ");
INSERT INTO cam_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wooélé na e ne a pihuô te Ioane me e *pipuu apulie? Wo Padué, ai ni apulie?» Ke lé te junihe picihe kon, ke lé pipii telé pie: «Mepie genye hegi ne ten pie: “É mu ko Padué”, ke e o pii tenye pie: “Ke é mu ko ade na time geé uce céihi ne ko nina e pii tewé wo Ioane?” ");
INSERT INTO cam_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ke mepie genye hegi ne ten pie: “É mu ko ni apulie”, ke é mulang, ke genye pipwocilekenye ne ko ni apulie na lé céihi ne ko Ioane!» Be lé tai céihi ne kon pie pa péroféta te Padué. ");
INSERT INTO cam_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ke é mu ko anaa, ke lé hegi ne te Iésu wo lépwo apihuô pie: «Meniing, time geme uce temehi.» Ke e pii telé pie: «Ke woéo mwo, ke time é o uce pii tewé pie, he wooélé na e ne tong a pihuô me é pwo nina é ko pwo.» ");
INSERT INTO cam_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","E pwo-ocine telé wo Iésu pie: «Ade celi geé niimihi ne ko a jepule ce? «Lé bwo mu wo pa céiu apulie, me lupwo naîn. Ke e pii te pa bécéiuhen pie: Pa naîng, go â penem ha apwoamu jenaa. ");
INSERT INTO cam_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","«Ke e hegi ne ten wo paje pie: “Te muhi tong.” «Kehe icehi ana é alecehen, ke e pininim ne ko ali bwo hegi ne ten den. Ke e bwo te â penem ha ali apwoamu. ");
INSERT INTO cam_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","«Ke e pii te pali céiu wo caa telu pie: “Pa naîng, go â penem ha apwoamu jenaa.” «Ke e hegi ne ten pie: “Éa, wâé go caa. É o caa ân.” Kehe icehi ana time e uce ân. ");
INSERT INTO cam_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","«Ke woo hadenii lupwonaa celi e piténede caa telu?» Ke lé hegi ne ten wo lépwo caa te lépwo apwoâpwailo me lépwo apihuô pie: «Wo pa bécéiuhen.» Ke e pii telé wo Iésu pie: «Geé tabemi ehi, be é o pii tewé a juuju pie: Lé o ânebuhewé ne ha a *Mwametau te Padué wo lépwo *atai mwani cuhi puni apulie, me ni toomwo pwopwaaden. ");
INSERT INTO cam_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Be e âbé céiikewé wo Ioane pa apipuu apulie, beme e habwii tewé, wogewé a bele *Isaraéla, a pwaaden na *mwomwon ne he pwahamii Padué. Ke time geé uce céihi ne kon. Kehe icehi ana wo lépwo atai mwani me ni toomwo pwopwaaden, ke lé te céihi ne kon. Ke me geé alihi pie lé céihi, ke time geé uce pininim, me geé céihi ne kon.» ");
INSERT INTO cam_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Geé tabemi a céiu ocine: E bwo mu wo pa eapwihi a ni tabe megele. Ke e cemi apwoamu ten, ke e bwo pwo a aba beme babé kon. Ke e bwo ini a pwon, beme acaai ace tabe megele, ke me e bo céi ne hen a tabe hen. Ke e bahi a mwa na te junihe bwali da ko miiden, beme a mwowéa ko ali ni éé tabe megele. Ke nebwén, ke e niimihi pie me e mwo â pitabée ha ace céiu amu, ke e pwocuhi ni béé apulie, beme lé wéihi ali ni tabe megele ten, ke e engen. ");
INSERT INTO cam_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","«Pwo ni wole alecehen ke tuie nge ha a benaamwon ko tabwo ace tabe megele. Ke e ne ngen ni apenem den, beme lé â hegi ce den mu ko a pitii âdaanu, koja lépwoli awéihi ni éé tabe megele. ");
INSERT INTO cam_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kehe icehi ana lé imwilé wo lépwoli awéihi ni tabe megele. Ke lé pitati pa bécéiuhen, ke lé taunu pa béalohen, ke lé taunu mwo pa béciéhen ko péi. ");
INSERT INTO cam_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ke e ne mwobé ni béé apenem. Kehe icehi ana te piwie ana lé pwo telé. ");
INSERT INTO cam_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ke nebwén, ke e ne ngen pa naîn, be e piniimihi pie lé o paciitieng. ");
INSERT INTO cam_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","«Kehe icehi ana me lé alieng he e tehene ngen, ke lé pipii telé pie: “Geé téne! Te weengaa kuti pana e bo eapwihi ali ni tabe megele ha ace céiu tan! Wâé heme nye ju taunueng, beme bo a denye ali ni tabe megele!” ");
INSERT INTO cam_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ke lé imwieng, ke lé teuueng wie koja a apwoamu, ke lé taunueng.» ");
INSERT INTO cam_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ke wo Iésu, ke e tahimwo lépwona lé ko tabemieng pie: «Ke kona mepie e tehenebé wo pali eapwihi ali apwoamu, ke e o woté te ni apenem naa?» ");
INSERT INTO cam_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ke lé hegi ne te Iésu wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô pie: «E bo taunu lépwona lé pwotahinaado, ke e bo uce ne te ce béén a apwoamu, beme lé bo uce wéa kon. Ke é ha a benaamwon celi lé tabwo ace tabe megele hen, ke lé o bo ne ten ce den.» ");
INSERT INTO cam_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ke e te pii telé mwo wo Iésu pie: «Kona time geé uce pine ana tii ne he ni tii iitihi? Ali péi li lé tahi taabwon wo lépwo abahi mwa, ke te anaa kuti a ju paamwa. Be te ni âpihuô te Padaame. Ke nye téetihi a wâé ten, na nye caa ko alihi! Psaume 118.22−23 ");
INSERT INTO cam_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","«{Hemepie e tupwo wo pace céiu apulie ne pwo a péi naa, ke o tatubwi ati a één. Ke mepie e tupwo ali péi ne huîi pace céiu apulie, ke o te ju tagetieng.} Weengaa a watihen me é pii tewé pie: Ke e o pé kojakewé a *adéihi ko a Mwametau ten wo Padué. Ke e o ne te ace céiu bele, celi e bo ne ce acehi ni penem de lépwo ju nahi a Mwametau.» ");
INSERT INTO cam_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lé temehi wo lépwo apihuô te lépwo apwoâpwailo me lépwo *Farasaio, pie e ko pwo-ocine ne kolé wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ke te nimelé me lé imwieng. Kehe icehi ana mwotilé ko ni apulie, be te junihe hiwon ni béén na lé niimihi pie pa péroféta te Padué. ");
INSERT INTO cam_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ke e pwo-ocine telé mwo wo Iésu, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«A *Mwametau he Miiden, ke pwohewii ani: «E bwo mu wo pa céiu daame. Ke e piwâam ko a piwiinaado na te junihe ubwo ko pa naîn na e piaten. ");
INSERT INTO cam_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ke e pahede ni eabwé ten, me lé â tode nina lé pahede céiilé ne ko a piwiinaado. Kehe icehi ana wo lépwonaa, ke time uce nimelé me lé âbé wiinaado. ");
INSERT INTO cam_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","«Ke e pahede mwo ni béé eabwé ten, me lé â pii telé pie: “É caa pipwopweehi ati. Be é caa pwo me lé taunuhi paaci me ni wota tong na géréén jélé. Geé âbé me nye piwiinaado ibu ko a piaten!” ");
INSERT INTO cam_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","«Kehe icehi ana time lé uce pipéce ne kolé wo lépwona todelé. Ke lé tee muko engen ne ko ni penem delé, be e â ha apwoamu ten wo pa céiu, ke e â mu ha a magaha ten wo pa céiu. ");
INSERT INTO cam_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ke wo lépwo béén, ke lé imwi lépwoli eabwé, ke lé pwotahinaado ne kolé, ke lé taunulé. ");
INSERT INTO cam_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ke e te junihe okéé kuti wo pa daame. Ke e pahede ni coda ten me lé â taunu ni pwéréca naa, ke lé cini a pwomwo ubwo telé. ");
INSERT INTO cam_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","«Ke e todebé ni béé eabwé ten, ke e pii telé pie: “Caa nebwén ali wiinaado ko piaten, kehe icehi ana wo lépwoli é caa todelé, ke time uce jan ne kolé. ");
INSERT INTO cam_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ke geé â ati he ni dihe pwaaden, ke geé todebé ati ce apulie celi geé toolé.” ");
INSERT INTO cam_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","«Ke lé engen uti ni pwaaden wo lépwoli eabwé, ke lé tode ati ni apulie na lé toolé, nina ta jélé, me nina wâé jélé, ke caa te ju â oba ali mwowiinaado. ");
INSERT INTO cam_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","«Ke e taa wo pa daame, beme e ali lépwoli lé ko wiinaado. Ke e ali pa apulie na time e uce cuwohe ace epwén ko piwiinaado. ");
INSERT INTO cam_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ke e pii ten pie: “Pa bééng, go woté ko ace bwo taabé tem éni, he te tice epwénem ko piwiinaado?” «Ke time e uce temehi ace bwo hegi nen ne ten wo paje. ");
INSERT INTO cam_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","«Ke e pii te li eabwé ten wo pa daame pie: “Geé cie ni in me ni an, ke geé tahieng wie ne ha a melepiing, he na lé bo é nelang, ke lé piwii pecuwo.”» ");
INSERT INTO cam_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ke e pii wo Iésu pie: «Hiwon ni apulie na e todelé wo Padué, kehe time uce hiwon nina e pipégalilé.» ");
INSERT INTO cam_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","É ha a céiu tan, ke lé pitapitilé wo lépwo *Farasaio, beme lé hane ace bwopwonen me lé pipwohuô te Iésu ko ace bwo hegi nen den ne telé. ");
INSERT INTO cam_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ke lé pahede ngen ni béé acémun delé, me ni béén na élé ha a duaan de *Érode. Ke lé â pii te Iésu pie: «Pa apipune, geme temehi pie go pii a juuju, be go te patemehi ati ni naado na nime Padué me genye pwo. Be time uce mwotiko ko pa apulie, ke time go uce pipwoinen ne kolé. ");
INSERT INTO cam_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ke anaa kuti ana nimeme me geme tahimwoko pie: He te wâé heme nye pwocuhi puni apulie te pa daame he lépwo Roma? Ai time uce wâé?» ");
INSERT INTO cam_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kehe e te temehi a bwo pipwohuô telé wo Iésu, ke e pii telé pie: «Lépwoje, wogewé ke lépwo agele! É ko ade na geé pihaamiéo? ");
INSERT INTO cam_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Geé cuwoteeke habwii tong ace mwani *cuhi puni apulie!» Ke lé ne ten a mwani péi. ");
INSERT INTO cam_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ke e pii telé pie: «A démee, ke a nii-î ana e pwo a mwani ce?» ");
INSERT INTO cam_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ke lé hegi ne ten pie: «A de pa daame he lépwo Roma.» Ke e pii telé wo Iésu pie: «Ke caa wâé, ke geé ne mwo te pa daame nina te ni den, ke geé ne te Padué nina te ni de Padué.» ");
INSERT INTO cam_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ke lé te junihe téetihi a bwo hegi nen den. Ke lé cepewieeng, ke lé engen. ");
INSERT INTO cam_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mwo te é ha a tan naa, ke lé âmwobé céii Iésu wo lépwo béé *Saducéen. Woélé, ke te a céiu dihe pwoiitihi te lépwo *Juif na time lé uce céihi pie, lé o mulie cemwo wo lépwo amele. Lé âbé too Iésu, ke lé pwo me lé habwii pie lé juuju ke lé tahimwoeng pie: ");
INSERT INTO cam_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«Pa apipune, e caa pii wo *Moosé ne he ni patén pie: Hemepie e mele wo pace céiu apulie celi te tice naîn, ke wâé heme e pé ê depweleten wo pa ciéén me lu piaten. Be me wonaa, ke me bo pwo ce piebehi pa amele. ");
INSERT INTO cam_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","«Ke te wâé. Kehe go cuwoteeke niimihi ani: Pwo lépwo pwénaâjién na 7 jélé, ke e piaten wo pa cuwolé, kehe icehi ana e mele he mwo te tice naîn. Ke lu piaten wo pa béalohen me êgi depwele. ");
INSERT INTO cam_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ke te piwien ne mwo ko pa béalohen, ke pa béciéhen, die ko pa bé7 hen. ");
INSERT INTO cam_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ke é alecehelé ati, ke e bwobe mele wo êgi toomwo. ");
INSERT INTO cam_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ke go ko pii pie lé o bo mulie cemwo ne ni amele, ha ace céiu tan. Ke hemepie wonaa, ke o bo wooélé mu hadeniilé celi bo pa aiu he ê toomwo naa, ha a benaamwon naa? Be caa te tai lépwo aiu hen ati! Ke go cuwoteeke hegi!» ");
INSERT INTO cam_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ke e hegi ne telé wo Iésu pie: «Geé pipweéo, be time geé uce temehi ni tii iitihi, me a junuu Padué. ");
INSERT INTO cam_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Be mepie lé mulie cemwo ne ni amele, ke time lé o bo uce piaten mwo. Kehe lé mulie pwohewii ni *âcélo ne pele Padué. ");
INSERT INTO cam_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","He time geé uce pine ali e pii wo Padué ne ko a mulie cemwo? Be e pii pie: ");
INSERT INTO cam_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Woéo Padué he *Abérama, ke Padué he Isaaka, ke Padué he Iakobo. A bwopiinen pie, lé teko tai mulie pele Padué! Be time uce Padué he ni amele, kehe Padué he nina lé mulie!» ");
INSERT INTO cam_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ke lé téne anaa ne ni apulie na hiwon jélé, ke lé te junihe téetihi a bwo pacémunilé te Iésu. ");
INSERT INTO cam_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Me lé téne wo lépwo Farasaio pie e capuhi ni pwo lépwo Saducéen wo Iésu, ke lé pitaineibulé, beme lé â ali Iésu. ");
INSERT INTO cam_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ke pwo pa céiu béélé, pa céiu *dotéén ko patén, na nimen me e pipwohuô te Iésu, ke e tahimwoeng pie: ");
INSERT INTO cam_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Pa apipune, kona ade patén celi e piwéden na ati he ni patén?» ");
INSERT INTO cam_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ke e hegi ne ten wo Iésu pie: «Weengi: Go pwo me eânimem de Padaame Padué hem, ati ne ha a ju pwonimem, me a mulihem, me a bwo niimihinaado tem. ");
INSERT INTO cam_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Weengaa a patén na junihe piwéden ne ha ati ni patén. ");
INSERT INTO cam_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ke weengi a béalohe ni patén, na pwohewii ali ânebun: Go pwo me eânimem de ni béén, pwohewii a bwo pieânimem dem. ");
INSERT INTO cam_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","«Ati ni *patén de Moosé, me ni cémun de ni péroféta, ke lé te tai âbé mu ko lupwo patén naa.» ");
INSERT INTO cam_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lé mu aujeni Iésu wo lépwo Farasaio, ke e tahimwolé pie: ");
INSERT INTO cam_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«De ace bwo niimihinaado tewé ne ko pa *Mesia? Pa piebehii?» Ke lé hegi ne ten pie: «Pa piebehi *Davita.» A bwopiinen pie pa apulie na wahin nang kojaeng. ");
INSERT INTO cam_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ke e pii telé pie: «Wo Davita, ke he caa ju tilieng na a *Jenen Iitihi, ke e pii ko pa Mesia pie: “Padaame hung”. Kehe é mu ko ade? ");
INSERT INTO cam_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Be e pii pie: Pwooti te Padaame Padué, na e pacihe pa daame hung: “Go âbé tebwo éni pwo a juing. É ne tem a pihuô, ke o pipaunuko dieli mwo. É pwo me go caaite nina lé pipwopa ne kom.” Psaume 110.1 ");
INSERT INTO cam_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«Ke me e ko pii wo Davita pie: Padaame hung, ke a bwopiinen pie, wo pa Mesia. Ke me wonaa, ke ade ace watihen me geé niimihi pie, wo pa Mesia, ke time uce pace apulie celi piubwo nang koja Davita?» ");
INSERT INTO cam_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ke te tice paceli e hegi ne ten. Ke é alecehe anaa, ke te tice paceli e bo uce tahimwoeng mwo ko ce béé naado. ");
INSERT INTO cam_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","É alecehen, ke lé tabemi Iésu wo lépwo acémun den me ni apulie na lé mu lang, he e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Geé te ali lépwo *dotéén ko patén me lépwo *Farasaio, be a penem delé me lé pacémuni ni apulie ko ni *patén de Moosé. ");
INSERT INTO cam_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","«Ke wâé heme geé piténedehi ati nina lé pii tewé. Kehe icehi ana geé nemwo pipwohewiilé, be time lé uce pwo nina lé pii tewé! ");
INSERT INTO cam_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Be ni pihuô telé, ke pwohewii ni âneule na te junihe téé, na lé ne me lé taawon ne ni apulie. Be te muhi telé me lé ti kon ko a mwodéilé na te ju céiu! ");
INSERT INTO cam_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","«Ati ni huô telé, ke lé pwo, beme lé alilé ne ni apulie pie lé teko âcehi ni pihuô te Padué. Ke lé pwo me piubwo ni cuwo nahi élele iitihi na mu pwo bwaadelé, ke é ko ni ilé. Ke lé pwo me bwali ni baaé epwénelé. ");
INSERT INTO cam_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ke lé te cuwo ko pipégali ni atebwo ânebun ne he ni piwiinaado ubwo, ke é ne he ni *mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Be wâé telé heme lé pipaunulé ne ni apulie, ke me lé pii telé pie ‘Pa daame’. ");
INSERT INTO cam_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«Kehe wogewé, ke geé nemwo pwo me lé pii kowé pie ‘Pa daame’. Be te céiu Pa daame. Be wogewé, ke lépwo pwénaâjién. ");
INSERT INTO cam_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ke geé nemwo pii ko pace céiu apulie éni pwo bwohemwo pie ‘Caa’, be te céiu pa Caa tewé, na e jeda he miiden. ");
INSERT INTO cam_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ke geé nemwo pwo me pitoii kowé pie ‘Pa apihuô’, be te céiu Pa apihuô, na wo Kériso, pa *Mesia. ");
INSERT INTO cam_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Wo pace apulie celi piubwo nang ne pelewé, ke wâé heme e pwo me piwahin nang. ");
INSERT INTO cam_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Be wo pana e pwo me piubwo nang, ke o neeng ole. Ke wo pana e pwo me piwahin nang, ke o pineeng da.» ");
INSERT INTO cam_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","E pacihe mwo lépwo Farasaio me lépwo dotéén ko patén wo Iésu, ke e pii telé pie: «Geé pipwocile, wogewé lépwo apipulekenye ke lépwo apihaami! Be o te junihe ubwo a cuhinaado tewé! Be time geé uce taa ha a *Mwametau he Miiden wogewé, ke geé capuhi a pomwa ne ko ni béén na nimelé me lé taa. { ");
INSERT INTO cam_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«Geé pwo ni jame pwoiitihi beme nye o niimihi pie, ni apulie na wâé gewé. Kehe icehi ana geé pé ati koja ni depwele ni delé. Ke é mu ko anaa kuti, na o bo ne tewé a cuhinaado na junihe ubwo koja a cuhinaado te ni béén.} ");
INSERT INTO cam_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«Wogewé, ke lépwo apulie na te junihe ta gewé! Be geé téte pitihi a bwohemwo me a jié, beme geé tooli ace apulie celi te ju céiu nang, ke me e hegi a pwoiitihi tewé. Ke me geé caa pééeng, ke geé pwo me pa apulie na te junihe ta nang kojakewé, ke jan me e â ha a miû, pwohewiikewé! ");
INSERT INTO cam_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«Geé pwocilekewé, wogewé lépwo bwi na geé pipé lépwo bwi. Be geé pitalupe heme geé pacémuni ni apulie ko ni *piapwo. Be geé pii telé pie: “Mepie go piapwo cehi ne ko nii ‘a *mwaiitihi’, ke te piticenaado ne kon, kehe mepie go piapwo ne ko ce mwani megele celi e mu ha a mwaiitihi, ke wâé heme go pwo ana go piapwo ne kon.” ");
INSERT INTO cam_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","«Wogewé, ke lépwo pitice pwonimewé, ke bwi gewé! Ade aceli junihe pwonaado ne kon? A mwani megele ai a mwaiitihi? É pii tewé pie: Te a mwaiitihi cehi ana pipwonaado ne kon, be a duaan na e mu hen wo Padué! ");
INSERT INTO cam_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","«Ke piwien mwo, heme geé pii pie: “Hemepie go te ju piapwo cehi ne ko *apwoâpwailo, ke o te piticenaado ne kon. Ke heme go piapwo ne ko a âpwailo na e mu pwon, ke wâé heme go pacuwohi a piapwo naa.” ");
INSERT INTO cam_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","«Woté? Kona te tice aceli geé temehi? Ade aceli junihe pipwonaado ne kon? A âpwailo, ai a apwoâpwailo, na e pwo me iitihi a âpwailo? ");
INSERT INTO cam_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Geé téne, wo pana e piapwo ne ko a apwoâpwailo, ke e piapwo ati ne ko nina e pwon. ");
INSERT INTO cam_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ke wo pana e piapwo ne ko a mwaiitihi, ke e piapwo ne ko a nii Padué, be a mwa ten. ");
INSERT INTO cam_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ke wo pana e piapwo ne ko a miiden, ke e piapwo ne ko a atebwo iitihi te Padué na e daaité.» ");
INSERT INTO cam_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«Geé ne te Padué ana te ju céiu mu ko nina 10, é mu ko ni pétaapwo âdaanu. Ke te wâé. Kehe geé pipwocile! Be time geé uce âcehi ni junaado ne he ni patén: a ju céihi ne ko Padué, me a bwo pipwoiipi ni apulie, me a bwo pipwoééhelé. Wâé heme geé pacuwohi ati nina ubwo, me ati ni nahi patén. ");
INSERT INTO cam_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wogewé ni bwi na geé pé ni bwi! Geé tapulicéihi a tabe beme geé pétaabwon a nabu, kehe icehi ana geé nemihi a chameau! ");
INSERT INTO cam_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«O te junihe ubwo a cuhinaado tewé, be geé te ju gahe pwo! Be geé puu ehi pwo mwojéi ni mwoûdu me ni tam, kehe icehi ana te ju oba kuti ni pwonimewé ko nina ta. Be geé te junihe tapi, ke geé tee cuwo ko hane nina wâé me dewé, ke geé bune ni apulie! ");
INSERT INTO cam_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wogewé ni bwi! Geé mi puu ni ne ni tamewé. Ke é mulang, ke o wâé ati ni tam. ");
INSERT INTO cam_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«Wogewé lépwo apineduwohi na a ta! Be geé pwohewii ni bwomu na timi me pwojo pwomwo, ke te ju wâé bwo alihi nen. Kehe icehi ana é henen, ke te ju oba ko duapulie, me ati ni naado na caa muti. ");
INSERT INTO cam_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Wogewé mwo, be é ne pwomwo, ke te junihe wâé gewé ne ko ni apulie, kehe é jengedé ne kowé, ke te ju oba ko gele me nina ta.» ");
INSERT INTO cam_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«O te junihe ubwo a cuhinaado tewé, wogewé lépwo dotéén ko patén me lépwo Farasaio! Be geé pwonaamuu ni bwomuhe lépwo péroféta, me ni apulie na mwomwon jélé ne he pwahamii Padué. Kehe te wo lépwo watihewé kuti li lé taunulé! ");
INSERT INTO cam_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ke geé pipii tewé pie: “Hemepie teko wogenye he ni benaamwon naa, ke wieli me time nye uce taunulé!” ");
INSERT INTO cam_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","«Kehe icehi ana heme geé ko pii anaa, ke geé pihabwiikewé pie, wogewé, ke te ni ju naî lépwona lé taunulé. ");
INSERT INTO cam_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Te wâé, ke geé te panebwénihi ni penem de ni watihewé! ");
INSERT INTO cam_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wogewé ni nahi bwien! Ke e bo pwocuhinaado tewé wo Padué, ke e bo tahikewé ne ha a miû! Ke time geé o uce piceluimikewé koja anaa! ");
INSERT INTO cam_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","«Geé tabemi ehi, be é o pahede ni péroféta me nina lé pitemang, ke nina me lé pacémunikewé. Ke geé o tahi bwaliiwota ko ce béén ne he ni mwotapitihi. Ke geé o pwotahinaado ne ko ce béén nge he ni amu. Ke geé o cemeite ce béén ne ko ce *kuricé. Ke geé o taunu ce béén ko ce béé bwopwonen. ");
INSERT INTO cam_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","«Ke é mu ko anaa, na e bo tautikewé wo Padué ko a bwo taunu lépwona lé céihi ne kon: tabuhi mu ko Abel, pa apulie na e mwomwon, die ko Zakari†, pa naî Baraki. Be geé taunu Zakari ne ha awieme apwoâpwailo me a duaan na junihe iitihi. ");
INSERT INTO cam_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","É pii tewé a juuju pie: E bo pwocuhinaado tewé wo Padué, wogewé ni apulie jenaa, ko ati nina lé pwo ne ni watihewé.» ");
INSERT INTO cam_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","E pii mwo wo Iésu pie: «Au, mwolikewé wogewé lépwo *Iérusaléma! Be geé taunu lépwo péroféta na e nelé bé céiikewé wo Padué be geé ahi ni béén ko péi, ke geé taunu ce béén ko ce béé bwopwonen. Mu te cuwo ko nimung me é taineibukewé, pwohewii a nyaa te ja, heme e taineibuhi ni naîn haahi ni puuin. Kehe icehi ana te muhi tewé. ");
INSERT INTO cam_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ke geé téne, é o mwo engen kojakewé ke e o patupwo a mwaiitihi tewé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ke é pii tewé pie: O caa time geé bo uce aliéo mwo dieli ha ace tan celi geé o bo pii pie: *Adéi pa apulie na e âbé ne he nii Padaame!» ");
INSERT INTO cam_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","É alecehen, he e ko wie mu ha a *mwaiitihi wo Iésu, ke lé ko picedi ni aba kon wo lépwo acémun den. Ke lé piâbé mwonu Iésu beme lé habwii ten. ");
INSERT INTO cam_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ke e pii telé pie: «Geé te alihi ati ninaa? Ke é pii tewé a juuju pie: O time e bo uce mu éni mwo ace céiu péi pwo ace céiu. Be ati, ke o tai tanahi taabwon.» ");
INSERT INTO cam_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","É alecehen ke e tebwo pwo a juwole ko ni Olivier wo Iésu ne he bebenihe a mwaiitihi. Ke lé âbé mwonueng wo lépwo acémun den, ke te piwoélé cehi me weeng, ke lé tahimwoeng pie: «He éniile celi e o bo tuie ana go ko pii? Ke o ade ace inenaado ko ace bwo mwojuia cemwo tem, ke a pwonehi a bwohemwo?» ");
INSERT INTO cam_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ke e hegi ne telé pie: «Geé pipwocile, beme geé nemwo pipweéo! ");
INSERT INTO cam_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Be o hiwon nina lé o âbé heme lé pé a niing. Ke lé o pii tewé pie: “Woéo pa *Mesia”, ke lé o pipwohuô te ce apulie celi hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","«Ke geé o téne heme lé cihe ko ce pa celi e mwonu ai e ité. Kehe geé nemwo pwo me mwotikewé! Be e o mi tuie ninaa, kehe icehi ana time uce téele a pwonehi a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Be a céiu amu, ke e bo pipwopa me a céiu amu. Ke a céiu mwametau, ke e bo pipwopa me a céiu mwametau. Ke o bo pwo ni menele na ubwo ne he ni pétaapwo piduaan, ke ni penem bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","É ne he ni bwomunen naa, ke o pwohewii ni bécéiuhe picani ko a piâbeele ewa.» ");
INSERT INTO cam_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","«É ha a benaamwon naa ke lé o bo téétikewé mu kong ati ne ni apulie pwo bwohemwo. Ke lé o bo imwikewé, ke pwotahi ne kowé, dieli lé o bo taunukewé, mu ko ana wogewé ke ni apulie tong. ");
INSERT INTO cam_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","«Ke o bo hiwon nina lé o bo patieden ni céihi telé. Ke lé o bo pitéétilé nina pibéélé, ke lé o bo pi-iculé mwo. ");
INSERT INTO cam_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","O hiwon ni péroféta agele na lé o bo tuiebé, ke lé o bo pipwohuô te ce apulie celi hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ke a ta, ke o bo piubwo da ne pwo a bwohemwo, ke o bo hiwon nina lé o bo patieden ni pwonimelé ne ko Padué, ke é ne ko ni béélé. ");
INSERT INTO cam_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kehe icehi ana wo pana e cumang die ha anebwén ko a mulihen ke e bo celuimieng wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ke o bo pipatemehi ati ne pwo a bwohemwo a Pwooti Wâé ko a Mwametau, beme lé o bo téne ne nina time lé uce téele temehi Padué. Ke é alecehe anaa, ke o caa a pwonehi a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Geé bo alihi ali naado li e caa cihe kon wo péroféta Daniéla, he e bo mu ha a duaan na iitihi: ali naado li e pwotahi ati ni naado, na nihe mwakile nang, ke muhi tenye kon.» Wo paceli e pine anaa, ke wâé heme e temehi beme e bo cihe kon! ");
INSERT INTO cam_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","«Ke é ha a benaamwon naa, ke wâé heme lé tai cela da pwo ni juwole ne nina lé mu *Judé! ");
INSERT INTO cam_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ke wo pana e âoté pwomwo, ke e nemwo taamwo hane ce naado mu ha a mwa ten. ");
INSERT INTO cam_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ke wo pana e mu ha apwoamu, ke e nemwo mwojuia ngemwo pelen, me e pé ce epwénen. ");
INSERT INTO cam_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Au, mwolihi! Be é he ni tan naa, ke o pwoééhe ni toomwo na pigiaa jélé, me nina lé mwo paditihi ewa. ");
INSERT INTO cam_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","«Ke geé pwoiitihi te Padué pie, me a bwo cela tewé, ke me time e o uce tuie ha ace benaamwon celi ta-amu hen, ai é ha ace *tan iitihi. ");
INSERT INTO cam_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Be, é ha a benaamwon naa, ke lé o te junihe mu he ni picani ne ni apulie. Be mwo te tice pace apulie celi e caa mu he ce picani celi wonaa, tabuhi ha atabuhi ko a bwohemwo, dieli jenaa. Ke o te tice mwo pace céiu apulie celi e o bo mu he ce picani celi wonaa. ");
INSERT INTO cam_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","«É hemepie time e uce niimihi wo Padué pie, me e pineole a jéhi ni tan naa, ke wieli me o te tice pace céiu apulie celi e o celuimi a mulihen! Kehe icehi ana e te niimihi pie me e pineole, wonaa mu ko nina e caa pipégalilé.» ");
INSERT INTO cam_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«Mepie e pii tewé wo pace céiu apulie pie: “Geé alihi! E éni wo pa *Mesia!”, ai “E ha a duaan ce!”, ke geé nemwo céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Be lé o bo tehenebé ce ‘mesia’ me ce ‘péroféta’ celi ni agele. Ke lé o pwo ce *pipwojunuun celi lé o téetihi ne ni apulie, beme a bwopwonen me lé pipwohuô telé. Ke lé o te hane mwo me lé pipwohuô te nina e caa pipégalilé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ke é ko anaa na é caa mi pii tewé ni naado na o bo tuie! ");
INSERT INTO cam_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","«Ke mepie lé pii tewé pie: “Geé alihi, e ha a melé wo pa Mesia!”, ke geé nemwo ân. Ke me lé pii tewé pie: “Geé alihi, be e taduwo éni!”, ke geé nemwo céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Be a bwo âmwobé tong, woéo pa Nahi Apulie, ke o pwohewii a ilehi heme e pwéélang ati a miiden, mu ha a céiu baaéén die ha a céiu baaéén. ");
INSERT INTO cam_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Be pwohewii ana nye mu pii pie: “É he na e lang a déhi wota, ke lé taineibulé nelang ne ni bwaaoléé.”» ");
INSERT INTO cam_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«É he ni tan naa, ke lé o te junihe mu he ni picani ne ni apulie. Ke é alecehe anaa, ke: O time e uce niê na a téale. O bwén ne ha a wole. Lé o bo tupwo ne ni ceni. O éjén ni pipwojunuun he miiden. Ésaïe 13.10; 34.4 ");
INSERT INTO cam_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","«Ke é mulang, ke e o tuie a inenaado ne jeda he miiden, ko a bwo tuie tong, woéo pa Nahi Apulie. Ke lé o haa ko ni bwo mwotilé ati ne ni bele pwo a bwohemwo, be lé aliéo, he é âbé pwo ni nii, ne ha ati a junuung me a bwo ubwo jo. ");
INSERT INTO cam_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ke me e cuu a tutu na ubwo wo pa céiu *âcélo ke é o pawiebé ni âcélo tong, beme lé neibu nina é caa pipégalilé. Ke lé o taineibulé ne ha a céiu behi amu, die ha a céiu behin, pitihi a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Wâé heme geé temehi a inenaado ko a majing. Be, me e tile, ke geé caa temehi pie, caa é mwonu a cim naado. ");
INSERT INTO cam_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","«Wonaa mwo, heme geé alihi ati ni naado naa, ke geé o temehi pie, o caa pacuwohi ati. ");
INSERT INTO cam_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","É pii tewé a juuju pie: Time o uce bwolihi. Be lé o mwo te alihi anaa ne ni béé apulie jenaa, ânebuhe ace bwo mele telé. ");
INSERT INTO cam_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Be o tieden a miiden me a bwohemwo, kehe o time uce tieden a pwooti tong.» ");
INSERT INTO cam_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Te tice pace apulie celi e temehi ace tan me ace inetéale celi e o tuie hen ni naado naa. Te tice paceli e temehi, heme woéo pa Naîn, heme ni âcélo te Padué. Kehe te wo Caa cehi na e temehi. ");
INSERT INTO cam_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","«A tan na é bo âbé hen, woéo pa Nahi Apulie, ke o pwohewii a benaamwon de Noé. ");
INSERT INTO cam_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Be lé teko wiinaado me ûdu ne ni apulie; ke lé piaten, ke lé ne ni naîlé toomwo me lé aten. Ke te tice aceli lé temehi dieli ha a tan na e taa ha ali ong wo Noé. Ke e te âbé kuti ali jaa, ke e tai péélé ati. «Ke o te piwien mwo me a bwo âmwobé tong, woéo pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Be é ha a tan naa, ke lupwo apulie na lu mu ha apwoamu, ke o pé pace céiu, ke o ne pa céiu. ");
INSERT INTO cam_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ke alo lu toomwo na lu ko cemeii blé ibu, ke o pé ê céiu, ke o ne ê céiu. ");
INSERT INTO cam_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Wâé heme geé tee ûmiê, be time geé uce temehi ace benaamwon celi e o tuie mwobé hen wo Padaame hewé! ");
INSERT INTO cam_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Geé cuwoteeke niimihi ani: Wo pa eapwihi pwomwo, ke time e uce temehi ace inetéale celi e o taa ha a mwa ten wo pa abune na e âbé he bwén. Be hemepie e teko wéa, ke me time e o uce neeng me e taa pelen. ");
INSERT INTO cam_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Weengaa kuti ana é pii tewé pie: Geé te piwâam. Be é o bo âbé, woéo pa Nahi Apulie, kehe time geé uce temehi ace benaamwon.» ");
INSERT INTO cam_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«He wooélé pa eabwé na e piténedehi, ke e pipwoiipieng? Wo pana e pii ten wo pa daame hen pie: “É ne tem a penem na pwonaado kon: Go ne ce wiinaado te lépwo apenem dong he ce benaamwon celi wâé.” ");
INSERT INTO cam_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","«Ke o te nihe wâé ne ko pa eabwé naa, hemepie e tuiebé wo pa daame, hemepie e teko penem ehi! ");
INSERT INTO cam_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","É pii tewé a juuju pie: E o ne ten a pihuô ati ne ko ni den. ");
INSERT INTO cam_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Kehe icehi ana wieli pa apulie ta wo pa apenem naa, ke wieli e piniimihi pie: ‘O bwoli pa caa tong me e âmwobé.’ ");
INSERT INTO cam_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ke e ahi lépwo béén ko penem. Ke e te nihe wiinaado me ûdu me lépwo apiolo. ");
INSERT INTO cam_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ke e o bo âmwobé wo pa caa ten ha a tan na time e uce ucéieng, ke é ha a inetéale na time e uce temehi. ");
INSERT INTO cam_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ke e bo ne a cuhinaado na junihe ubwo te pa apenem naa, woélé me lépwo béé apenem na ta jélé, ke lé o é ke piwii pecuwo.» ");
INSERT INTO cam_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","E pii mwo wo Iésu pie: «A *Mwametau he Miiden, ke pwohewii ani: «Lé bwo mu ne ni ewa toomwo na 10 jélé. Ke lé bwo pé ni mwomiû helé, beme lé â ucéi pa apiaten. ");
INSERT INTO cam_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nim léna lé piténedehi, ke nim léna lé pilééng. ");
INSERT INTO cam_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","4","«Léli ewa toomwo li lé piténedehi, ke lé âbé imi ni mwomiû helé, ne pehi ni tabe hen. Kehe wo léli ewa toomwo li lé pilééng, ke lé âbé imi ni mwomiû helé, kehe icehi ana tice tabe hen. ");
INSERT INTO cam_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","«Ke caa bwén ke time e uce epin ko âbé wo pali apiaten. Ke caa nime léli ewa toomwo me lé pule, ke lé pule. ");
INSERT INTO cam_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","«É ha awieme bwén, ke lé téne a pwocihe na e pii pie: “Neko pa apiaten! Geé wie me nye â beniieng.” ");
INSERT INTO cam_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","«Ke lé tai ûmiê wo léli ewa toomwo, ke lé pwopweehi li mwomiû helé. ");
INSERT INTO cam_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ke lé pii te léli apiténedehi wo léli ewa toomwo apilééng pie: “Au! Caa tice tabe he ni mwomiû heme! Geé ne ce tabe he ni mwomiû heme ko ni nehi tabe tewé.” ");
INSERT INTO cam_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","«Ke lé hegi ne telé pie: “Ûhu! Caa time uce jan. Kehe geé â pele ni a-icu me geé pwocuhi ce tabe he miû tewé.” ");
INSERT INTO cam_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","«Kehe icehi ana me lé mwo ko engen, ke e tuiebé wo pali apiaten. Ke wo léli ewa toomwo li lé caa te piwâam, ke lé caa tai taa me pali apiaten ha ali mwopiaten. Ke e capuhi a pomwa. ");
INSERT INTO cam_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","«Mepwo é ne ko léli ewa toomwo apilééng, ke lé bwo tehenebé, ke lé toii pie: “Pa daame, pa daame, tehi a pomwa!” ");
INSERT INTO cam_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","«Kehe icehi ana e hegi ne telé wo pali apiaten pie: “Geé engen kojaéo be time é uce temehikewé.”» ");
INSERT INTO cam_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ke e panebwénihi a ocine naa wo Iésu, ke e pii pie: «Geé ûmiê, be time geé uce temehi ace tan me ace inetéale celi é o tehenebé hen.» ");
INSERT INTO cam_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","E pii mwo wo Iésu pie: «A Mwametau he Miiden, ke pwohewii ani: «E bwo mu wo pa céiu apulie. Ke nimen me e â pitabée, ke e tode ni eabwé ten, ke e pawie ne telé ni naamuun. ");
INSERT INTO cam_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","«Ke e muko pétaapwo ne telé nina jan me lé pwo. E ne te pa céiu nina 5 million, ke wo pa céiu ke 2 million, ke wo pa béciéhen ke 1 million, ke e engen. ");
INSERT INTO cam_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ke e engen wo pa eabwé na e hegi nina 5 million, ke e â penem ko ni mwani naa, ke e tooli mwo nina 5 million. ");
INSERT INTO cam_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ke wonaa ne mwo ko pana e ne ten nina 2 million, ke e te hane béén mwo, ke e tooli mwo nina 2 million. ");
INSERT INTO cam_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ke mepwo wo pali e ne ten ana 1 million, ke e â ini a pwon, ke e neduwohi ali mwani te pali caa ten, ke time e uce penem kon.» ");
INSERT INTO cam_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«Caa bwolihi a bwo engen de pali daame, ke e mwojuia mwobé. Ke e tode lépwoli eabwé ten, ke e tahimwolé ko aceli lé pwo ko li mwani ten. ");
INSERT INTO cam_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","«Ke e hegi ne ten wo pali eabwé li e ne ten li 5 million pie: “Padaame, li go ne tong li 5 million. Ke weengi nina 5 million mwo, ni âpenem dong beme ni béén.” ");
INSERT INTO cam_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","«Ke e pii ten wo pali daame pie: “Wâé! Wogo pa eabwé na wâé go. Be go piténedehi ne he ni naado na wahin, ke é bo ne tem ce naado celi ubwo. Ke go taabé me genyu pipwodéén ibu.” ");
INSERT INTO cam_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","«Ke e âbé wo pali béalohe eabwé, ke e pii te pali daame hen pie: “Pa daame, weengi li 2 million li go ne tong. Ke weengi nina 2 million mwo, ni âpenem dong beme ni béén.” ");
INSERT INTO cam_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","«Ke e pii ten wo pali daame pie: “Wâé! Wogo mwo pa eabwé na wâé go, be go piténedehi ne ko a naado na wahin, ke é bo ne tem ce naado celi ubwo. Kehe go taabé me genyu pipwodéén ibu.”» ");
INSERT INTO cam_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","«Ke e âbé wo pa béciéhen, ke e pii ten pie: “Pa daame, é caa temehi pie, wogo, ke pa apulie na go okéé, be go tii ni âdaanu na time go uce cemi, ke go taineibuhi nina time go uce penem kon. ");
INSERT INTO cam_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ke mwotiéo, ke é neduwohi ni mwani tem, be koli é o patieden. Ke weengi, ke go te pé mwo.” ");
INSERT INTO cam_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","«Ke e hegi ne ten wo pali daame hen pie: “Wogo ke pa eabwé na ta go, be pa apwoemaan! Woté? Go caa te temehi pie, é tii nina time é uce cemi, ke é taineibuhi nina time é uce penem kon. ");
INSERT INTO cam_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","É mu ko ade na time go uce ne ha a mwomwani a mwani tong?! Be, mepie go wonaa, ke wieli me é céi ne pehi celi e taa ne pwon!” ");
INSERT INTO cam_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","«Ke e pii te lépwo béé eabwé ten pie: “Geé pé kojaeng a 1 million na eten, ke geé ne te pana hiwon ni mwani ten! ");
INSERT INTO cam_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Be wo pana caa pwo ne ten, ke o ne mwo pwon ce béén, beme pihiwon den. Kehe wo pana tice ten, ke o pétaabwon kojaeng a nehinaado na mwo e pelen. ");
INSERT INTO cam_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ke wo pa eabwé piticenaado ne kon naa, ke o tahieng ole ha a melepiing, he na lé o é nelang, ke piwii pecuwo.”» ");
INSERT INTO cam_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","E pii mwo wo Iésu pie: «É heme é âmwobé, woéo pa Nahi Apulie, ne ha a junuung me *a wâé tong, woéo me ni *âcélo tong, ke é o tebwo pwo atebwo tong he daame. ");
INSERT INTO cam_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","«Ke é o taineibuhi ne he pwahamiin ati ni bele. Ke é bo pineité ni apulie, pwohewii pa awéihi muto heme e pineitééhi ni muto me ni nani. ");
INSERT INTO cam_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ke é o bo ne ni muto pwo juing. Ke ni nani, ke é bo nelé pwo eaamung.» ");
INSERT INTO cam_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","«Ke, woéo pa daame, ke é bo pii te nina lé mu pwo juing pie: “Geé âbé, wogewé na e adéikewé wo Caa tong, me geé hegi a Mwametau na e caa pipwopweehi me dewé, ânebuhe atabuhi ko a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","É mu ko ana, he li menung, ke geé pwo me é wiinaado, ke é he nimung me é ûdu, ke geé pwo me é ûdu, ke he é mwo coho, ke geé hegiéo. ");
INSERT INTO cam_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ke é he tice naamuung, ke geé ne ni naamuung. Ke é he li cunu jo, ke geé âbé caniêéo. Ke é he li é mu he karépu, ke geé âbé die pelong.” ");
INSERT INTO cam_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","«Ke lé o hegi ne tong nina mwomwon jélé pie: “Pa daame, he éniile celi geme aliko he celi menem, ke geme pwo me go wiinaado? Ke éniile celi nimem me go ûdu, ke geme pwo me go ûdu? ");
INSERT INTO cam_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ke éniile celi go mwo coho, ke geme hegiko? Ke éniile celi tice naamuum, ke geme ne ce naamuum? ");
INSERT INTO cam_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ke éniile celi cunu go, ke geme caniêko? Ke go mu he karépu, ke geme âdé die pelem? He éniile naa?” ");
INSERT INTO cam_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","«Ke e hegi ne telé pie: “É pii tewé a juuju pie: É ati he ni benaamwon na geé pwo ninaa ne te lépwo âjiénung na wahin jélé, ke woéo pana geé ko pwo tong.”» ");
INSERT INTO cam_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","«Ke é bo pii te nina lé mu pwo eaamung pie: “Geé engen kojaéo, be e apwokewé wo Padué! Geé â ha a miû na e te éle dieli mwo, na e caa pipwopweehi wo Padué, me de *Caatana me ni duéé ten. ");
INSERT INTO cam_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Be é he li menung, ke time geé uce pwo me é wiinaado. Ke é he nimung me é ûdu, ke time geé uce pwo me é ûdu. ");
INSERT INTO cam_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ke é he li é coho, ke time geé uce hegiéo. Ke é he li tice naamuung, ke time geé uce ne ce epwénung. Ke é he li cunu jo, ke time geé uce caniêéo. Ke é he li é mu he karépu, ke time geé uce âbé die pelong.” ");
INSERT INTO cam_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","«Ke lé o hegi ne tong pie: “Pa daame, he éniile celi geme aliko, he celi menem, ke nimem me go ûdu, ke go coho, ke tice naamuum, ke cunu go, ke go mu he karépu? Ke time geme uce picani tem? He éniile naa?” ");
INSERT INTO cam_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","«Ke é o hegi ne telé pie: “É pii tewé a juuju pie: Ati he ni benaamwon na muhi tewé me geé picani te ni âjiénung na wahin jélé, ke woéo pana time uce nimewé me geé picani tong.” ");
INSERT INTO cam_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","«Ke lé bo engen, me lé hegi a cuhinaado dieli mwo. Ke mepwo nina lé piténede Padué, ke lé bo engen me lé hegi a *mulie dieli mwo ne pele Padué.» ");
INSERT INTO cam_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","É he e nebwén ko pwocémun ko ninaa wo Iésu, ke e pii te lépwo acémun den pie: ");
INSERT INTO cam_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Lépwoli, geé temehi pie é he na alo tan, ke caa a tan ko Pacika. Ke o icuéo, ke cemeiteéo ne ko a *kuricé, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","He e ko pii anaa wo Iésu ke lé ko pitapitilé wo lépwo caa te lépwo *apwoâpwailo, me lépwo apihuô te lépwo *Juif, ne pele Kaïfe, pa daame helé. ");
INSERT INTO cam_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Be nimelé me lé taunu Iésu. Ke lé pihane ace bwopwonen me lé pipwohuô ten, me lé imwieng neduwohi. ");
INSERT INTO cam_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Be lé pipii telé pie: «O time uce wâé heme nye imwieng ha a piwiinaado ubwo ne he pwahamii ni apulie, be koli lé bo okéé.» ");
INSERT INTO cam_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","É ha a benaamwon naa, ke e mu Bétani wo Iésu ha a mwa te Simon, pa katia. ");
INSERT INTO cam_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","É he lé mwo ko wiinaado, ke e tuiebé ê céiu toomwo, imi a mwotabe péi na oba ko tabe ûde na te junihe ubwo a cuhin, ke e cepulicéihi ne pwo puni Iésu. ");
INSERT INTO cam_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ke me lé alieng wo lépwo acémun den, ke te junihe time uce wâé telé. Ke lé pipii telé pie: «He e pihoonihi a tabe ûde ne, kona woté? ");
INSERT INTO cam_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ana te junihe ubwo a cuhin! É ko ade na time e uce icuhi, ke me genye ne a mwani te nina tice delé?» ");
INSERT INTO cam_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","E te temehi nina lé niimihi wo Iésu, ke e pii telé pie: «É mu ko ade na geé ili ê toomwo ce? Ana e pwo tong, ke te junihe wâé. ");
INSERT INTO cam_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Be o tee élé pelewé wo lépwona tice delé, kehe woéo, ke time é o uce tee mu pelewé. ");
INSERT INTO cam_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wo ênaa, ke e tapulicéihi ne kong a tabe ûde, be e caa mi pipwopweehi a bwo ole tong he pwon. ");
INSERT INTO cam_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ke é pii tewé a juuju pie: É heme bo pipii beetihi a Pwooti Wâé ne he ni piduaan ati ne pwo a bwohemwo, ke lé bo tee piuti mwo a jepule ko ana e pwo ê toomwo ce, beme tee pipaniimieng.» ");
INSERT INTO cam_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","E â too ni caa te lépwo apwoâpwailo wo pa céiu béé lépwo 12 *apostolo na a niin pie Judas Iscariot. ");
INSERT INTO cam_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Ke e pii telé pie: «Ade aceli geé bo ne tong, hemepie é ne Iésu tewé?» Ke lé ne ten nina 30 mwani péi. ");
INSERT INTO cam_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ke e tabuhi pihane ace pwaaden me e icu Iésu telé. ");
INSERT INTO cam_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","É ha a bécéiuhe tan ko ‘pieni pwoloa tice nyaa ten’, ke lé âbé céii Iésu wo lépwo acémun den, ke lé pii ten pie: «Geme o â piwâam ko a wiinaado ko Pacika. Kona é wé, he celi nimem me genye piwiinaado nelang?» ");
INSERT INTO cam_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ke e hegi ne telé pie: «Geé â ha a pwomwo ubwo, pele pa apulie na é bo piieng dewé ke geé pii ten pie: “E pii wo Padaame pie: ‘Caa tuie a benaamwon dong. Ke é pelem he na me é wii a wiinaado ko Pacika, wogeme me ni acémun dong.’”» ");
INSERT INTO cam_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ke lé pwo ana e pii wo Iésu, ke lé piwâamihi a wiinaado ko Pacika. ");
INSERT INTO cam_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Caa babwén, ke lé tebwo pwo taap wo Iésu me lépwo 12 apostolo ten. ");
INSERT INTO cam_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ke é he lé ko wiinaado, ke e pii telé pie: «É pii tewé a juuju pie: E bo pi-icuéo wo pa bééwé.» ");
INSERT INTO cam_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ke te junihe piwahin jélé kuti, ke lé muko pétaapwo tahimwoeng pie: «Padaame, he time uce woéo?» ");
INSERT INTO cam_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ke e hegi ne telé wo Iésu pie: «Wo pana gemu tai pétaa ole ha a tam me weeng, ke weeng pana e bo pi-icuéo. ");
INSERT INTO cam_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","«É bo mele, woéo pa Nahi Apulie, pwohewii ana e caa pii beetihi ne ni tii iitihi. Kehe wo pa apulie na e pi-icuéo, ke o te junihe pwoééhen! Au, mwolihi! Be wo panaa, ke wieli me o te wâé ne kon, hemepie time e uce ko âbeele!» ");
INSERT INTO cam_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ke e tahimwo Iésu wo Judas, pana e icueng, pie: «Kona time uce woéo, go Padaame?» Ke e hegi ne ten wo Iésu pie: «Go caa teko pii.» ");
INSERT INTO cam_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","É he lé ko piwiinaado ibu, ke e pé a pwoloa wo Iésu, ke e pipwo-olé te Padué. Ke e ebii, ke e pwopatihi ne ko lépwo acémun den, ke e pii telé pie: «Geé pé, ke geé eni, be ani, ke a ééng.» ");
INSERT INTO cam_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ke é alecehen, ke e pé a mwoûdu ko tabe megele. Ke e pwo-olé te Padué, ke e ne telé. Ke e pii pie: «Geé tai ûdu. ");
INSERT INTO cam_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Be ani, ke a cewéhung na e o caa tée me de ni apulie, beme pineuhi ni ta pwo telé. Be a pipwoâpwailo na e pacuwohi a *piapwo na e pwo wo Padué pie e ne a péém ne ha awiemelé me weeng. ");
INSERT INTO cam_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","«Ke é pii tewé pie: O caa time é bo uce ûdu mwo ace tabe megele ne éni pwo bwohemwo dieli ha ace tan celi genye bo ûdu ace tabe megele celi mwo coho me wogewé, ne ha a Mwametau te Caa tong.» ");
INSERT INTO cam_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ke lé nyebihi a psaume ko a tan ubwo naa, ke é mulang, ke lé taa pwo a juwole ko ni Olivier. ");
INSERT INTO cam_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ke e pii wo Iésu te lépwo acémun den pie: «É jenaa he bwén, ke geé o bo tai engen kojaéo. Be caa te tii ne he ni tii iitihi pie: O bo taunu pa awéihi muto, ke lé o pipiiden ne ni muto. Zakari 13.7 ");
INSERT INTO cam_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«Kehe icehi ana é hemepie é mulie cemwo mu ha amele, ke é bo ânebuhewé ne Galilé.» ");
INSERT INTO cam_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ke e pii ten wo Pétéru pie: «Wieli lé o engen kojako wo lépwoje, kehe time o uce woéo!» ");
INSERT INTO cam_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ke e hegi ne ten wo Iésu pie: «É pii tem a juuju pie: É ha a bwén jenaa, ânebuhe a bwo to te a ja, ke o caa ocié go ko piwotétaa kong pie, time go uce temehiéo.» ");
INSERT INTO cam_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ke e pii wo Pétéru pie: «Ûhu! Piwien hemepie genyu tai mele, kehe time é o uce wotétaa kom!» Ke tai woélé ati, ke lé te tai pii ten ana céiu. ");
INSERT INTO cam_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ke é mulang, ke lé â ha a céiu duaan na cemi acuwo hen na pii kon pie Getsémané. Ke e pii te lépwo acémun den wo Iésu pie: «Geé tebwo éni, be é mwo â pwoiitihi.» ");
INSERT INTO cam_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ke e pé Pétéru me lupwo naî Zébédé. Ke caa tabuhi piwahin Iésu, ke pinekepé ten. ");
INSERT INTO cam_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ke e pii telé pie: «Te junihe téé ke piwahin a pwonimung. Kehe geé tee mu éni, ke genye tai piûmiê ibu. Geé nemwo pule!» ");
INSERT INTO cam_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ke e te ju piâdé kojalé, ke e tidihi jilin, ke e miibule. Ke e pwoiitihi da céii Padué, ke e pii pie: «Caa, hemepie te jan, ke go pé kojaéo ni picani me ni téé ce! Kehe icehi ana go nemwo pwo ana nimung kon, kehe ana nimem kon.» ");
INSERT INTO cam_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ke me e mwojuia mwobé céii lépwo acémun den na cié jélé, ke e alihi pie lé teko pule. Ke e pii te Pétéru pie: «Be he time uce jan me nye piûmiê ibu, he na te ju céiu inetéale? ");
INSERT INTO cam_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","«Geé te ûmiê, ke geé pwoiitihi, beme o te pwo niihewé, hemepie tacebwénikewé. Be nimewé me geé pwo ana wâé, kehe icehi ana tice niihewé.» ");
INSERT INTO cam_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ke e engemwo kojalé wo Iésu, ke e pwoiitihi mwo, ke e pii pie: «Caa wé, mepie time uce jan me pé kojaéo ni picani me ni téé ce, ke é ilehi kojako pie, go picani tong, beme é piténedehi ana te nimem kon.» ");
INSERT INTO cam_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ke me e mwojuia mwobé céii lépwo acémun den, ke e toolé mwo he lé teko pule. Be caa te junihe emaan jélé, ke lé tee ko pipucing. ");
INSERT INTO cam_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ke e engemwo kojalé, ke e âmwo pwoiitihi, ke e te pii mwo ana e caa mi pii. ");
INSERT INTO cam_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ke me e mwojuia mwobé céiilé, ke e toolé mwo he lé teko pule, ke e pii telé pie: «Woté? Geé mwo teko mwaale, ke pule mwo? Wâé ne kowé! Kehe icehi ana o caa neéo, woéo pa Nahi Apulie, ne te lépwona lé pwo nina ta! ");
INSERT INTO cam_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Geé cuwoda! Me nye engen! Be caa e lang wo pana e icuéo!» ");
INSERT INTO cam_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","É he e mwo ko pii anaa wo Iésu, ke e te ju tehenebé wo Judas, pali céiu béé lépwoli 12 apostolo ten. Ke lé âbé céin ne ni apulie na te junihe hiwon jélé, imi ni teua me ni ba-acuwo. Be lé nelé ngen wo lépwo caa te lépwo apwoâpwailo, me ni apihuô te a bele te lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ke wo Judas, pana e icu Iésu, ke e caa pipatemehi telé ana me e pwo: «Wo pa apulie na é o mwomwaaueng, ke te weeng kuti. Ke geé imwieng.» ");
INSERT INTO cam_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ke he lé tehenebé, ke e te â céii Iésu kuti, ke e pii ten pie: «Bwocu tem, go pa apipune!» Ke e mwomwaaueng. ");
INSERT INTO cam_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ke e pii ten wo Iésu pie: «Îgo, go pwo ana me go pwo.» Ke lé te imwi Iésu kuti. ");
INSERT INTO cam_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kehe icehi ana wo pa apulie na e mu pele Iésu, ke e te pwome céi kuti a teua ten mu ha a mwon, ke e te tahi kuti ole pwo a puni pa apenem de pa *daame he lépwo apwoâpwailo. Kehe icehi ana e te ju tahagéi a jéénen. ");
INSERT INTO cam_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ke e pii ten wo Iésu pie: «Go ne homwo a teua tem ne ha a mwon! Be wo lépwona lé pwopa ko teua, ke lé o te mele ko teua. ");
INSERT INTO cam_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","«Go téne, hemepie nimung, ke é o tode Caa tong, beme e nebé céiiéo a céiu mwocoda ko ni *âcélo na te junihe hiwon jélé, beme lé pwopaing! ");
INSERT INTO cam_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Kehe me wonaa, ke wieli me time e o uce pacuwohi ana e pii ne he ni tii iitihi! Be e pii pie, ke o wonaa a bwo engen ne ni naado.» ");
INSERT INTO cam_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ke e pii te lépwona lé imwieng, pie: «Woté? Geé âbé pééo ko teua me beba-acuwo, pwohewiin heme woéo pace ataunuhi apulie! Ati he ni tan, ke é te mu hadeniiwé, he é teko pacémuni ni apulie ne ha a *mwaiitihi, kehe icehi ana time geé uce imwiéo! ");
INSERT INTO cam_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","«Kehe ati ninaa, ke e tai pacuwohi a pwooti na lé pii wo lépwo péroféta ne he ni tii iitihi.» Ke ati lépwo acémun den, ke lé cepewieeng, ke lé cela. ");
INSERT INTO cam_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Lé pé Iésu nge céii Kaïfe, pa daame he lépwo apwoâpwailo. Be lé pitapitilé ne pelen wo lépwo *dotéén ko patén me lépwo apihuô te lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ke e pi-ilipuwolé ngen wo Pétéru. Ke e tuie nge pele pa daame he lépwo apwoâpwailo, ke e tebwo pwo napwomwo, ne pele ni apenem, ni awéa. Be nimen me e alihi aceli e o tuie ne ko Iésu. ");
INSERT INTO cam_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Wo lépwo caa te lépwo apwoâpwailo, me ati a *mwohuô te lépwo Juif, ke lé hane ce apulie beme lé pipé ne ko Iésu, be nimelé me lé pwocuhinaado ten, me e mele. ");
INSERT INTO cam_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ke hiwon ni agele na lé âbé pipé ne ko Iésu, kehe icehi ana time lé uce tooli ace ju watihen me lé taunueng. Ke é he caa e mwonu me nebwén a pitautinaado telé, ke lu tehenebé wo lupwo alo apulie. ");
INSERT INTO cam_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ke lu pii pie: «E pipii den wo panaa pie, me e bo paniihi a mwaiitihi te Padué, ke me e bo pacuuli mwo, he na cié ni tan.» ");
INSERT INTO cam_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ke e te cuwoda kuti wo pa daame he lépwo apwoâpwailo, ke e tahimwo Iésu pie: «Kona te tice béhegi nen dem? He time go uce téne nina lé ko pipé ne kom?» ");
INSERT INTO cam_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kehe icehi ana time e uce hegi wo Iésu. Ke e te tahimwoeng mwo wo pali daame pie: «É ne he nii Padué na e mulip, ke é ileko pie, go hegi. Kona te wogo kuti, pa *Mesia, pa *Naî Padué?» ");
INSERT INTO cam_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ke e hegi ne ten wo Iésu pie: «Go caa teko pii. Ke é pii tewé pie: Tabuhi jenaa ni, ke geé bo aliéo, woéo pa Nahi Apulie, heme é tebwo *pwo a jui Padué na te junihe pwojunuun beme é pihuôhi ati ni naado. Ke geé bo aliéo, heme é âbé he ni nii, mu he miiden.» ");
INSERT INTO cam_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ke te junihe emegéi na pali daame he lépwo apwoâpwailo, ke e te nihe okéé ke e pitie ni epwénen, ke e pii te ni béé atautinaado pie: «E cihe me ta ne ko Padué be e pwo me piwielu me weeng! Caa jan! Necu ce béé bwo pipé ne kon, be e caa teko pipé ne kon mwo! Be geé caa te téne ana e pii. ");
INSERT INTO cam_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ke ade aceli geé niimihi ne kon?» Ke lé tai hegi ne ten ati pie: «Wâé heme e mele.» ");
INSERT INTO cam_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ke lé cumi ne he pwahamiin, ke lé nuô i kon. Ke lé tahi pale ni ilé ne kon wo lépwo béén, ");
INSERT INTO cam_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ke lé pii ten pie: «He woo na e ahiko? Go cuwoteeke pihane, go ‘Mesia’, hemepie wogo ke pace péroféta celi go temehi ati ce naado!» ");
INSERT INTO cam_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Mepwo wo Pétéru, ke e tee tebwo jeoté pwomwo. Ke e âbé céiieng wo ê céiu eabwé, ke e pii ten pie: «Éé, wogo, ke pa céiu béé Iésu, mu Galilé!» ");
INSERT INTO cam_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ke e wotétaa ne he pwahamii ni apulie, ke e pii pie: «Ûhu! Time é uce temehi ana go ko pii!» ");
INSERT INTO cam_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ke e te â wie kuti ha a pwobabé. Ke e alieng wo ê céiu toomwo na e penem lang, ke e pii te nina lé mu lang pie: «Uhuu, wo paje, ke pa béé Iésu mu Nazaret!» ");
INSERT INTO cam_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ke e pii mwo wo Pétéru pie: «Ûhu! É piapwo pie time é uce temehieng!» ");
INSERT INTO cam_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","É alecehen, ke nina lé mu lang, ke lé âbé céii Pétéru ke lé pii ten pie: «Uhuu! Wogo ke pa céiu acémun den! Be nye téne ne he patim.» ");
INSERT INTO cam_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ke e te junihe pimwoiu wo Pétéru, ke e pii pie: «Geé téne! Time é uce temehi panaa. Wâé heme e pwocuhinaado tong wo Padué, hemepie é gele!» Ke me e mwo ko pii anaa, ke e te to kuti ali ja. ");
INSERT INTO cam_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ke e bwo niimihi ali e pii ten wo Iésu, pie: «Ânebuhe a bwo to te a ja, ke go ocié ko piwotétaa pie, time go uce temehiéo.» Ke e wie wo Pétéru ke e te junihe é kuti. ");
INSERT INTO cam_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","É he mwo te junihe acaama, ke lé pitapitilé neibu wo lépwo caa te lépwo *apwoâpwailo, me lépwo apihuô te a bele te lépwo *Juif. Ke lé piténelé ko ace bwo taunu Iésu. ");
INSERT INTO cam_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ke lé cieeng, ke lé pééeng nge céii *Pilate, pa gupéno te lépwo Roma. ");
INSERT INTO cam_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Mepwo wo Judas, pali e icu Iésu, ke e alihi pie, lé o caa taunueng. Ke e bwo pininim ne ko ana e pwo te Iésu, ke te junihe piwahin nang kon. Ke e mwojuia ngemwo pele lépwo caa te lépwo apwoâpwailo, me lépwo apihuô. Ke e ne mwo telé li 30 mwani péi li lé ne ten. ");
INSERT INTO cam_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ke e pii telé pie: «Au, é pwo ana ta. Be é icu pa céiu apulie na te tice ta pwo ten, me e mele.» Ke lé hegi ne ten pie: «Te tice aceli geme alihi ne kon!» ");
INSERT INTO cam_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ke e tahi nge céiilé ne ha a *mwaiitihi li mwani. Ke e â piwogéi henen. ");
INSERT INTO cam_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ke lé tai li mwani wo lépwo caa te lépwo apwoâpwailo, ke lé pii pie: «Ade aceli genye o pwo ko ni mwani ce? Genye nemwo ne pehi ni âpipati ko mwaiitihi, be ni mwani cuhi cewéle.» ");
INSERT INTO cam_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ke lé piténelé pie, me lé pwocuhi a pule na a niin pie ‘a pule te pa apwo ila pule’ beme a iitihi te ni coho. ");
INSERT INTO cam_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","É mu ko anaa, na ni apulie, ke lé pii ko a duaan naa pie, ‘a ninaado na pwo cewéle hen’. Ke lé mwo teko pii kon dieli jenaa. ");
INSERT INTO cam_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ati ninaa, ke e tuie, beme e pacuwohi li ocine li e pwo wo péroféta Iérémia, ne he ni tii ten: Lé pé li 30 mwani péi, wonaa a jéhin na lé niimihi na a bele *Isaraéla me lé pwocuhin me den. ");
INSERT INTO cam_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ke lé pwocuhi ali pule te pali apwo ila pule. Be weengaa ana te nime Padaame kon. ");
INSERT INTO cam_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Lé pé Iésu nge he pwahamii Pilate, pa gupéno te lépwo Roma. Ke e tahimwoeng wo Pilate pie: «Kona te wogo kuti pa daame he lépwo Juif?» Ke e hegi ne ten wo Iésu pie: «A juuju a bwopiinen dem.» ");
INSERT INTO cam_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ke nebwén, ke lé pipé ne kon wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô te a bele. Kehe time e uce hegilé. ");
INSERT INTO cam_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ke e te pwo me pii ten wo Pilate pie: «Kona time go uce téne nina ta na lé pii ne kon?» ");
INSERT INTO cam_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kehe icehi ana time e uce hegi ne telé wo Iésu. Ke e te junihe téele kon wo Pilate. ");
INSERT INTO cam_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Caa te cemang ne ko Pilate, ha a tan ko *Pacika, me e pawie mu he karépu pace céiu apulie celi nime a bele kon. ");
INSERT INTO cam_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ke é ha a jo naa, ke pwo pa céiu apwokarépu na pii kon pie Barabas, na lé te junihe temehieng ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ke hiwon ni apulie na lé tehenebé pele Pilate, ke e pii telé pie: «Kona nimewé me é pawie Barabas, ai wo Iésu, na pii kon pie ‘pa *Mesia’?» ");
INSERT INTO cam_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Be e te temehi pie, lé ne Iésu ten wo lépwo caa te lépwo apwoâpwailo ha a pipwokon delé. ");
INSERT INTO cam_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ke nebwén, ke e tebwo pwo atebwo ten, beme e tauti Iésu. Ke é ha a benaamwon naa, ke e tehenebé wo pa céiu apulie na e pébé céiieng a pwooti te mwoden. Be e pii pie: «É tibwén, ke pwo a niûng ne ko pa Iésu naa, ke te junihe time wâé jo kon. Go patuwoeng, ke go nemwo ti kon, be pa apulie iitihi!» ");
INSERT INTO cam_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","21","Ke e pii mwo te lépwo apulie wo Pilate pie: «É bo patupwo ne tewé pace céiu apwokarépu. Ke he woo hadenii lupwoje, celi nimewé kon?» Ke lé hegi ne ten pie: «Barabas!» Be lé cinelé wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô, beme lé pii anaa, ke me e mele wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ke e pii telé wo Pilate pie: «Ke he ade aceli é o pwo te Iésu, pana pii kon pie ‘Mesia’?» Ke lé hegi ne ten pie: «Pwo me cemeiteeng ne ko a *kuricé!» ");
INSERT INTO cam_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ke e tahimwolé mwo pie: «Kona ade aceli e pwo celi ta?» Kehe icehi ana lé bwo nihe cihe me ubwo pie: «Pwo me cemeiteeng ne ko a kuricé!» ");
INSERT INTO cam_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ke e alihi wo Pilate pie time lé uce tabemieng, be caa junihe ubwo a bwo iluulé. Ke e pé a mwotabe, ke e puu ni in ne he pwahamiilé ati, ke e pii telé pie: «Time uce woéo pa watihe a bwo mele te pa apulie ce. Kehe te wogewé cehi!» ");
INSERT INTO cam_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ke lé tai hegi ne ten pie: «Éa, te wogeme lépwo watihen, wogeme me ni naîme! Ke hemepie geme pwo aceli ta, ke wâé heme geme te hegi a cuhinaado ko a bwo mele ten.» ");
INSERT INTO cam_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ke e pawie ne telé Barabas wo Pilate. Ke e pwo me ahi Iésu ko a bwaliiwota. Ke e patupwoeng ne te ni coda, beme lé â cemeiteeng ne ko a kuricé. ");
INSERT INTO cam_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ke lé pé wie Iésu wo lépwo coda, ke lé â pwo a céiu napwomwo na ubwo. Ke lé tode ati ni mwocoda. ");
INSERT INTO cam_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ke lé céi ni epwénen, ke lé ne kon a epwén na megele pwohewii a epwéne pa apulie na piubwo nang beme lé pihoonieng. ");
INSERT INTO cam_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ke lé péi a kuron ko ni mii acuwo na pwo dan, ke lé neole pwo punin. Ke lé ne ha a in ne pwo jui a bewomeéle pwohewii a bwaja pa daame. Ke lé tidihi jililé he pwahamiin, ke lé pii ten pie: «Bwocu, go pa daame he lépwo Juif! Adéiko!» ");
INSERT INTO cam_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ke lé cumi ne kon, ke lé pé ali bewomeéle, ke lé tati a punin kon. ");
INSERT INTO cam_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ke me lé caa nebwén ko a bwo pihoonieng, ke lé céi mu mwo kon ali epwén megele, ke lé te ne mwo kon ni epwénen. Ke é mulang, ke lé pééeng wie, beme lé â cemeiteeng ne ko a kuricé. ");
INSERT INTO cam_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Me lé ko wie mu ha a pwomwo ubwo, ke pitapitilé me pa apulie mu ha a pwomwo ubwo Cirène na pii kon pie Simon. Ke lé cuwokon, beme e canihi ali kuricé te Iésu. ");
INSERT INTO cam_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ke lé tuie nge pwo a céiu tihi juwole na pii kon pie Golgota, a bwopiinen pie ‘pwo a piipuni apulie’. ");
INSERT INTO cam_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ke wo lépwo béén, ke lé pineibuhi a tabe megele me a tabe na maga. Ke lé ne te Iésu, ke me e nemi, ke time uce nimen me e ûdu. ");
INSERT INTO cam_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nebwén, ke lé cemeiteeng ne ko ali kuricé wo lépwo coda. Ke lé pipii ne kolé ni epwénen. Ke lé picéi metii ne ko {a epwén bwali ten}. ");
INSERT INTO cam_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ke lé tebwo beme lé wéa kon. ");
INSERT INTO cam_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ke lé cemeite ne pwo punin a eaa acuwo na tii ne kon a watihe a bwo mele ten, pie: iésu pa daame he lépwo juif. ");
INSERT INTO cam_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ke lé cemeite mwo lupwo alo apulie na lu pwotahinaado, ne he ni piduaa Iésu: wo pa céiu ne pwo juin, ke wo pa céiu ne pwo eaamun. ");
INSERT INTO cam_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Me lé alieng wo lépwona lé âdé ke âbé ha a duaan naa, ke lé tagiliihi ni punilé, ke lé pijeta kon. ");
INSERT INTO cam_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ke lé pii pie: «Kona time uce wogo kuti pana me go tanahi ali mwaiitihi, ke me go bo pacuuli mwo he na cié ni tan? Ke wâé, be mepie wogo pa *Naî Padué, ke go piceluimiko mwo, ke go opé mu ko a kuricé naa!» ");
INSERT INTO cam_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ke lé pihoonieng mwo wo lépwo caa te lépwo apwoâpwailo, me lépwo *dotéén ko patén me lépwo apihuô, ke lé pii pie: ");
INSERT INTO cam_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«E niimihi pie pa daame henye, lépwo Isaraéla. Ke e temehi me e celuimi ni béén, kehe time e uce temehi me e piceluimieng mwo! Hemepie e ole mu ko a kuricé naa, ke wieli genye o bo céihi ne kon! ");
INSERT INTO cam_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","«E céihi ne ko Padué, ke e pii pie, weeng, ke pa Naîn. Ke mepie eânime Padué ten, ke wâé hemepie e celuimieng jenaa!» ");
INSERT INTO cam_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ke te piwien ne mwo ko lupwona lu pwotahinaado na cemeitelu ne he ni piduaa Iésu. Be lu te pihoonieng mwo. ");
INSERT INTO cam_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","É he te ju goahen ehi, ke te ju melepiing ati ha amu, die ko cié inetéale alecehe goahen. ");
INSERT INTO cam_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ke me teko ju cié ni inetéale, ke e toii me ubwo wo Iésu pie: «Éli, Éli, lama sabaktani?» A bwopiinen pie: «Padué hung, Padué hung, é mu ko ade na go pawieéo?» ");
INSERT INTO cam_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ke me lé téneeng ne ni béén na lé mu lang, ke lé niimihi pie, e tode péroféta *Élia beme e picani ten. ");
INSERT INTO cam_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ke e te téte kuti wo pa céiu béélé, imi a mwaanu, ke e pate ha a tabe megele na maga. Ke e ne ko a ba-acuwo, ke e ne te Iésu beme e ûdu. ");
INSERT INTO cam_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kehe lé pii ten wo lépwo béén pie: «Go mwo cuwo lang, be wieli nye o ali Élia, hemepie e âbé celuimieng!» ");
INSERT INTO cam_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Kehe icehi ana e cihe da me ubwo wo Iésu, ke ele a nenehen. ");
INSERT INTO cam_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ke a mwaanu na e capuhi bwonihi a duaan na junihe iitihi ne ha a mwaiitihi, ke te tie ne ha awiemen kuti, mu jeda die jeoté ko a baaéén. Ke penem a bwohemwo, ke buwo ni péi. ");
INSERT INTO cam_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ke te tehi kuti ni bwomu, ke lé mulie cemwo mu ha amele a hiwon ko apulie te Padué. ");
INSERT INTO cam_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ke é alecehen, he e mulie cemwo mu ha amele wo Iésu, ke lé wie mu he ni bwomu. Ke lé taa *Iérusaléma, a pwomwo ubwo iitihi, ke lé pihabwiilé te ni apulie na hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wo lépwo coda roma na lé wéa ko Iésu, me pa caa telé, ke lé téetihi a bwo éjén na a bwohemwo, me ati nina e tuie. Ke te junihe ubwo kuti a bwo mwotilé, ke lé pii pie: «A juuju pie, wo pa apulie ce, ke pa Naî Padué!» ");
INSERT INTO cam_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Hiwon ni toomwo na lé mu lang, na lé omehi mu ité. Woélé kuti na lé âcéi Iésu mu Galilé beme lé picani ten. ");
INSERT INTO cam_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","É hadeniilé, ke e lang wo Maria mu Magdala, me Maria nyaa te Cang me José, me nyaa te lupwo naî Zébédé. ");
INSERT INTO cam_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","É he babwén, ke e tehenebé wo pa céiu apulie na pii kon pie Josef, pa apulie mu ha a mwopopwaalé Arimaté, pana te junihe pwo den. Weeng mwo, ke pa apulie na e mu te âmwo céi Iésu. ");
INSERT INTO cam_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ke e â pele pa daame Pilate, ke e ilehi a éé Iésu. Ke e pii te lépwo coda wo Pilate pie, me lé neeng den. ");
INSERT INTO cam_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ke e pé a éé Iésu wo Josef, ke e tawii ko a mwaanu na mwo te ju wamin. ");
INSERT INTO cam_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ke e pééeng ngen, ke e neeng he iitihi na e mwo te ju pwo, a pwon na e ini ne ha a péi, beme te a den, weeng Josef. Ke nebwén, ke e papitibehi a pilehe péi, ke e capuhi bwonihi ali pwon. Ke e engen. ");
INSERT INTO cam_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ke wo Maria mu Magdala me ê céiu Maria, ke lu teko tebwo ânebuhe ali mwa péi. ");
INSERT INTO cam_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ati ninaa, ke lé pwo he paciile a tan ânebuhe a *tan iitihi te lépwo Juif. He paciile ke lé mu piwâamihi a piwiinaado ko a tan iitihi. Ke é ha acaama hen, é he capéto a tan iitihi, ke lé pitapitilé ne pele Pilate wo lépwo caa te lépwo apwoâpwailo, me lépwo *Farasaio. ");
INSERT INTO cam_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ke lé pii ten pie: «Go te alihi, go pa daame, be wo pali ageti ni apulie li, wo Iésu, ke li e mi pii ânebuhe a bwo mele ten, pie: “É ha a béciéhe ni tan alecehe a bwo mele tong, ke é o mulie cemwo mu ha amele.” ");
INSERT INTO cam_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","«Kehe wâé heme go pii te ni coda pie, me lé wéihi ehi ali mwa péi he na cié ni tan. Be koli lé bo bune a één wo lépwo acémun den, ke lé bo pii te a bele pie, e caa mulie cemwo mu ha amele. Ke mepie wonaa, ke a jepule gele naa, ke o te junihe ubwo kojan ânebun!» ");
INSERT INTO cam_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ke e pii telé wo Pilate pie: «Wâé. Woélé-ni ni béé coda. Ke hemepie nimewé, ke geé pwo me lé wéihi a mwa péi!» ");
INSERT INTO cam_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ke lé engen, ke lé â piwâamihi a bwo wéihi na ali mwa péi. Ke lé pwomangihi a péi bwonihi a pomwa hen. Ke lé ne li coda, beme lé wéihi. ");
INSERT INTO cam_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Caa nebwén a *tan iitihi te lépwo *Juif. Ke é he pwoiitihi, he mwo te ju acaama, ânebuhe a bwo taa tuie te a téale, ke lu engen me lu â he iitihi wo Maria mu Magdala me ê céiu Maria. ");
INSERT INTO cam_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ke te penem kuti a bwohemwo. Be e ole mu he miiden wo pa céiu *âcélo te Padaame, ke e papitibehi ali pilehe péi mu ha a pwo ali mwa péi, ke e tebwo pwon. ");
INSERT INTO cam_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Te ju pwomelaan pwohewii a ilehi, ke te junihe pwojo a epwénen. ");
INSERT INTO cam_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ke te junihe ele jene lépwo coda na lé wéihi ali mwa péi, ke éjén jélé ko a bwo mwotilé, ke lé tupwo pwohewii nina lé caa mele. ");
INSERT INTO cam_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ke e pii te luli toomwo wo pali âcélo pie: «Geu nemwo pwo me mwotikeu. Be é te temehi pie geu hane Iésu, pali lé cemeiteeng ne ko a *kuricé. ");
INSERT INTO cam_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Caa time uce e éni! Be e caa mulie cemwo mu ha amele, pwohewii ali e caa mi pii. Geu âbé me geu alihi ali duaan li lé neeng hen. ");
INSERT INTO cam_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ke geu epin, me geu â pii te lépwo acémun den pie: “E caa mulie cemwo mu ha amele wo Iésu, ke e mi â ânebuhewé ne Galilé. Ke geé bo alieng nelang.” Weengaa ana me é pii teu.» ");
INSERT INTO cam_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ke lu engen he epin mu ha ali iitihi. Ke te pimwotilu, kehe icehi ana lu te junihe pipwodéén mwo. Ke lu téte nge pipatemehi a jepule ne te lépwo *acémun de Iésu. ");
INSERT INTO cam_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ke é nge he pwaaden, ke lu téeti Iésu he pitapitilé. Ke e pii telu pie: «Bwocu teu!» Ke lu téte ne kon, ke lu imwi ni an, ke lu pipaunueng. ");
INSERT INTO cam_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ke e pii telu pie: «Geu nemwo pwo me mwotikeu, kehe geu â pii te lépwoli bééng pie me lé â Galilé, be lé bo aliéo nelang.» ");
INSERT INTO cam_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","É he lu ko â he pwaaden wo luli toomwo, ke lé téte nge ha a pwomwo ubwo wo lépwo béé coda, li lé wéihi ali mwa péi. Ke lé too lépwo caa te lépwo *apwoâpwailo, ke lé piuti telé ati nina e tuie. ");
INSERT INTO cam_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ke wo lépwonaa, ke lé tode ati ni béélé, me lépwo apihuô, beme lé pitapitilé, ke me lé picihe ko a jepule naa. Ke lé piniimihi ibuhi pie, me lé ne ace mwani celi te junihe ubwo ne te lépwo coda. ");
INSERT INTO cam_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ke lé pii telé pie: «Weengi ana me geé uti: Lé bune a één wo lépwo acémun den he geé mwo ko pule. ");
INSERT INTO cam_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ke mepie e téne anaa wo gupéno pa daame hewé, ke bo wogeme na geme bo cihe ne kon, beme e o nemwo okéé ne kowé.» ");
INSERT INTO cam_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ke lé pé ali mwani wo lépwo coda, ke lé pwo ana lé pii telé. É mu ko anaa, na lé mwo tee ko piuti wo lépwo Juif, dieli jenaa. ");
INSERT INTO cam_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Lé â ha amu Galilé wo lépwo 11 acémun de Iésu. Ke lé â pwo a juwole na e pii telé wo Iésu pie me lé bo â lang. ");
INSERT INTO cam_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ke e âbé benilé wo Iésu, ke lé pipaunueng. Kehe icehi ana pwo ni béén na time lé uce mwomwohi pie weeng. ");
INSERT INTO cam_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ke e âmwonulé wo Iésu, ke e pii telé pie: «Wo Padué, ke e ne tong ati ni *pipwojunuun ne jeda he miiden, ke éni pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","É mu ko anaa, na é pii tewé pie: Geé engen pitihi a bwohemwo. Ke geé pwo me lé céihi ne kong, beme lé âbé céing. Ke geé puulé ne he nii Caa, me pa Naîn, me a *Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ke geé pacémunilé, beme lé piténedehi ati ni pihuô na é caa ne tewé. Ke woéo, ke é o tee mu pelewé ati he ni tan, die ha a pwonehi a bwohemwo.»");
INSERT INTO cam_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","E tabuhi ne éni a *Pwooti Wâé te Iésu Kériso, pa *Naî Padué. ");
INSERT INTO cam_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Be caa tii ne ha a tii te *péroféta Isaia a pwooti te Padué pie: É bo neole pa apipépwooti tong. E bo ânebuhem, me e pwopweehi a pwaadeniim. Malachie 3.1 ");
INSERT INTO cam_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pwo pa apulie ha a da na e toii da pie: “E âbé wo Padaame! Pwopweehi a pwaadeniin! Pwo me belece a duaan na e engen hen!” Ésaïe 40.3 ");
INSERT INTO cam_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Wo *Ioane pa apipuu apulie, ke e tuie ne ha a da, ke e patemehi te ni apulie pie: «Geé pininim, ke geé bitekewé. Ke geé pwo me puukewé, beme geé habwii pie pitaatééhi ni mulihewé. Be me wonaa, ke e bo pineuhi ni ta pwo tewé wo Padué.» ");
INSERT INTO cam_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Te junihe hiwon ni apulie na lé âbé céii Ioane ne ha a da mu *Judé, ke é ha a pwomwo ubwo *Iérusaléma. Ke lé pii beetihi ni ta pwo telé, ne he pwahamii ni apulie ati. Ke e puulé ne ha a éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","E cuwohe a epwén na pwo ko pumii chameau, ke a taihenan a iiwota. Ke e wii koléé, ke e ûdu duhimepu. ");
INSERT INTO cam_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E toii pie: «Wo pana e bo âbé alecehung, ke te junihe pwojunuun kojaéo. Time uce jan ne kong me é ciiéo, ke me é tuwo ni tai ko ni dihibwaan. ");
INSERT INTO cam_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Woéo, ke é puukewé ko a tabe, ke weeng, ke e bo puukewé ko a *Jenen Iitihi.» ");
INSERT INTO cam_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","É ha a benaamwon naa, ke e tuiebé wo Iésu mu Nazaret, a mwopopwaalé ne Galilé. Ke e puueng wo Ioane ne ha a éémwa Ioridano. ");
INSERT INTO cam_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Te ju é ha a benaamwon na e wie mu he tabe wo Iésu, ke e alihi a miiden he tehi, ke e alihi a Jenen Iitihi he e opé ne huîin, pwohewii a meni pwojo. ");
INSERT INTO cam_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ke pwo a pwocihe bé mu he miiden, na e pii ten pie: «Wogo pa Naîng na te céiu go na te nihe eânimung dem. Wogo kuti, na é caa pipégaliko ne ha a pwonimung.» ");
INSERT INTO cam_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","13","Te ju é alecehe anaa, ke e pé Iésu nge ha a da na a Jenen Iitihi, beme e tacebwénieng wo *Caatana. Ke e mu lang he na 40 ni tan. E mu pele ni wota apiaba, ke ni *âcélo, ke lé penem den. ");
INSERT INTO cam_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","É ha a céiu tan, ke lé imwi Ioane, ke lé neeng he karépu. E engen wo Iésu, ke e â Galilé, me e â pipatemehi a Pwooti Wâé te Padué. ");
INSERT INTO cam_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ke e pii telé pie: «E caa tuie a benaamwon na e caa pipégali wo Padué, ke caa é mwonu a Mwametau ten. Geé taatééhi ni mulihewé, ke geé céihi ne ko a Pwooti Wâé!» ");
INSERT INTO cam_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","É ha a céiu tan ke e uti a nicepwon ne Galilé wo Iésu. Ke e ali Simon me André, lupwo pwénaâjién, na lu ko ne pua, be lupwo apwotau. ");
INSERT INTO cam_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ke e pii telu pie: «Geu âbé céing, be é bo pwo me wogeu lupwo apwotauhi apulie.» ");
INSERT INTO cam_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ke lu te necu kuti ni pua telu, ke lu âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ke lé te ju piân, ke e ali Cang me Ioane, lupwo naî Zébédé, he lu ko tebwo ha a ongelu, ke lu ko pwoni ni pua telu. ");
INSERT INTO cam_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","E te pwome todelu wo Iésu, ke lu ne caa telu Zébédé me ni apenem den ne ha a ong, ke lu âcéin. ");
INSERT INTO cam_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Lé tuiebé ha a pwomwo ubwo ne Kapernaüm wo Iésu me ni acémun den. Ke é ha a *tan iitihi, ke e taa ha a *mwotapitihi te ni *Juif ke e pacémunilé. ");
INSERT INTO cam_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","He lé téne, ke lé téetihi a bwo cihe ten, be time e uce pwohewii ni *dotéén ko patén. Be e te pacémunilé mu ha a pihuô na e te ne ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","He e mwo ko cihe wo Iésu ke e taa ha a mwotapitihi wo pa apulie na pwo duéé kon. Ke e wiikau ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Iésu mu Nazaret, te tice celi go pwo peleme. Go âbé pwotahi ne kome? É te temehiko, be wogo pa apulie na e pipégaliko wo Padué, ke e neko bé.» ");
INSERT INTO cam_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ke e heni ali duéé wo Iésu, ke e pii ten pie: «Go capuhi a pwom, ke go wie mu ko pa apulie naa!» ");
INSERT INTO cam_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ke e pegili pali apulie na ali duéé, ke e wie, he wiikau mu kon. ");
INSERT INTO cam_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ke lé te nihe tai téetihi ne ni apulie, ke lé te pitahimwolé pie: «He ade celi e ko pwo wo pa apulie ce? E pacémunikenye ko ace céiu bwomunen celi mwo coho. Be pwojunuun, ke e pihuôhi mwo ni duéé, ke lé te piténedeeng!» ");
INSERT INTO cam_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ke e te engen kuti a jepule ko Iésu, pitihi amu Galilé. ");
INSERT INTO cam_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","E wie mu ha a mwotapitihi wo Iésu. Ke e te pwome â pele Simon Pétéru me André. Ke lu piâcéin wo Cang me Ioane. ");
INSERT INTO cam_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ke me lé tehene ngen, ke nina lé mu lang ke lé te pwome pii te Iésu pie: «E tee ko pule ê mwaa Simon, be e pwopilijing.» ");
INSERT INTO cam_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ke e âbé céiieng wo Iésu, ke e pétaa ko a in, ke e pwiieng da, ke te tieden kuti kojaeng ali pilijing. Ke e cuwoda, ke e pwo me lé wiinaado. ");
INSERT INTO cam_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","É he babwén, alecehe a bwo nuule na a téale, ke lé pébé céii Iésu ati ni cunu me lépwona pwo ni duéé kolé. ");
INSERT INTO cam_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ke lé pitaineibulé ne ko a pomwa ati ne ni apulie ha a pwomwo ubwo. ");
INSERT INTO cam_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ke e pwo me tieden ati ni pétaapwo cunu wo Iésu. Ke e pawiehi mwo ni duéé na hiwon, ke time e uce nelé me lé cihe, be lé te temehieng. ");
INSERT INTO cam_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","É ha acaama, he mwo te melepiing, ke e caama wo Iésu, ke e â ha apiticie, ke e pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ke lé haneeng wo Simon me lépwo béén, ");
INSERT INTO cam_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ke me lé tooeng, ke lé pii ten pie: «Lé ko haneko ati ne ni apulie.» ");
INSERT INTO cam_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ke e hegi ne telé pie: «Genye engen mu éni, ke genye â he ni béé mwopopwaalé ko jijenye. Be é nelang mwo, he na me é â pipatemehi a Pwooti Wâé, be anaa kuti a watihen me é opé.» ");
INSERT INTO cam_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ke e engen pitihi a amu Galilé wo Iésu, ke e pipatemehi a Pwooti Wâé ne he ni mwotapitihi, ke e pawiehi ni duéé. ");
INSERT INTO cam_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","E âbé mwonu Iésu wo pana katia nang. Ke e tidihi jilin ânebuhen, ke e ileeng me e pwo me wâé nang, ke e pii pie: «Hemepie te nimem, ke go pwo me tieden a katia kong!» ");
INSERT INTO cam_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","E te nihe pipwoééhen wo Iésu, ke e cine ngen a in, ke e ti ko pali katia, ke e pii ten pie: «Éa, te nimung! Caa wâé go!» ");
INSERT INTO cam_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ke e te engen kuti ali katia, ke caa wâé nang. ");
INSERT INTO cam_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ke e pii me mwoiu ten wo Iésu pie: «Go engen. ");
INSERT INTO cam_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ke go nemwo pii te ni apulie! Kehe go â pihabwiiko ne te pa *apwoâpwailo, ke go ne te Padué ali âpwailo li e pii wo *Moosé ne he li patén den. Be me wonaa, ke me lé alihi ati ne ni apulie pie caa wâé go.» ");
INSERT INTO cam_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Kehe e engen wo pali, ke e â piuti te ni apulie ati nina e pwo ne kon wo Iésu. É mu ko anaa, ke caa pwocoon me e wie ne ha a pwomwo ubwo wo Iésu. Ke e â mu ha apiticie. Ke ni apulie, ke lé bwo tuiebé ne kon mu he ni piduaan. ");
INSERT INTO cam_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","E âmwobé wo Iésu ne Kapernaüm he ni tan alecehen. Ke lé téne pie caa e mwo pwomwo. ");
INSERT INTO cam_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ke hiwon ni apulie na lé pitaineibulé ne ha a mwa, ke â pitice ahilé, piwien die ha a pomwa, ke é pwomwo. ");
INSERT INTO cam_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ke lé âbé céiieng ni béé apulie he lé pébé céiieng pa apulie na tebwomwa nang; paa jélé na lé pipaadoimieng. ");
INSERT INTO cam_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kehe pwocoon me lé âmwonueng, wonaa mu ko a pubu apulie. Ke lé temeeng da pwo mwa, ke lé tapwii a céiu duaa mwa ne he bebenihe Iésu, ke lé neole pali tebwomwa pwo apule ten. ");
INSERT INTO cam_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ke me e alihi a céihi telé wo Iésu, ke e pii te pali tebwomwa pie: «Pa naîng, caa pineuhi ni ta pwo tem!» ");
INSERT INTO cam_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Lé mu lang mwo ne ni béé *dotéén ko patén, ke lé pitautinaado ne he ni pwonimelé: ");
INSERT INTO cam_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","‘Woté? Pa apulie ce, ke e cihe pwohewiin heme wo Padué! Be he wooélé na e temehi me e pineuhi ni ta pwo ten? Te icehi Padué!’ ");
INSERT INTO cam_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ke e te ju temehi ni bwo niimihinaado telé wo Iésu, ke e pii telé pie: «É mu ko ade na wonaa ni bwo niimihinaado tewé? ");
INSERT INTO cam_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ade aceli piticecoon? Me é pii te paje pie: “Caa pineuhi ni ta pwo tem”, ai me é pii ten pie: “Go cuwoda, ke go pé apule tem, ke go engen”? ");
INSERT INTO cam_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ke mepie jan me é pwo me e engen ne ânebuhewé ati ke geé bo temehi pie, pwo mwomwon dong, woéo, pa *Nahi Apulie, me é pineuhi ni ta pwo te ni apulie ne pwo bwohemwo.» Ke e pii te pali tebwomwa pie: ");
INSERT INTO cam_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Aje, go cuwoda, ke go pé apule tem, ke go âmwo pelem!» ");
INSERT INTO cam_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ke e te cuwoda kuti wo pali, ke e te pé kuti ali apule ten, ke e wie ne he pwahamii ni apulie. Lé te nihe téetihi ne ni apulie, ke lé pii pie: «Time genye mu uce téele alihi ace naado celi wonaa! Te a juuju pie wo Padué, ke te junihe ubwo nang.» ");
INSERT INTO cam_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","E mwojuia ngemwo ticepwon ne Galilé wo Iésu. Ke lé âbé céiieng ne ni apulie na hiwon jélé. Ke e pacémunilé ko a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","É he e ko ân, ke e ali Lévi (Mataio), pa naî Alfé, he e ko tebwo ha a mwotai mwani me de lépwo Roma. Ke e pii ten wo Iésu pie: «Go âbé céing!» Ke e te cuwoda kuti wo paje, ke e âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","É alecehen, ke lé wiinaado wo Iésu me lépwo acémun den pele Lévi. Ke hiwon ni atai mwani me ni apulie na ta ni mulihelé, na lé tai taa pwo taap me woélé, be te nihe hiwon jélé na lé âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ke me lé alihi anaa wo lépwo dotéén ko patén me lépwo *Farasaio, ke lé pii te lépwo acémun den pie: «É mu ko ade na wo pa caa tewé, ke lé piwiinaado me ûdu me lépwo atai mwani, ke ni béé apulie na ta jélé?» ");
INSERT INTO cam_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ke e ténelé wo Iésu, ke e pii telé pie: «Time lé uce hane ce dotéén wo lépwona te wâé jélé, kehe te icehi lépwona cunu jélé. Ke time é uce âbé tode nina lé niimihi pie wâé ni mulihelé. Kehe é âbé tode nina lé temehi pie ta ni mulihelé.» ");
INSERT INTO cam_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","É ha a céiu tan, ke lé ko *pipaciile wo lépwo acémun de *Ioane pa apipuu apulie me lépwo Farasaio. Be lé patupwo wiinaado beme lé pwoiitihi. Ke lé tuiebé pele Iésu ni béé apulie, ke lé pii ten pie: «É mu ko ade na lé te pipaciile wo lépwonaa, ke lé te wiinaado ne ni acémun dem?» ");
INSERT INTO cam_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ke e hegi ne telé wo Iésu pie: «Kona lé te pipatupwo wiinaado wo lépwona todelé ne ko a piaten, heme e mwo teko mu pelelé wo pa apiaten? Ûhu! Heme e mwo teko mu pelelé wo pa apiaten, ke lé mwo te wiinaado ke ûdu. ");
INSERT INTO cam_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kehe e o bo âbé a tan na o bo pé kojalé pa apiaten. Ke é mulang na lé o bobe pipaciile. ");
INSERT INTO cam_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","«Te tice pace apulie celi me e pé ace memwaanu celi mwo te ju wâé, me e woli ne ko ace memwaanu celi ukéiu. Be mepie e puu a mwaanu, ke bo nihe ubwo a tie kon. ");
INSERT INTO cam_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","«Ke geé niimihi a *mwotabe na pwo ko iiwota. Be time nye uce pé ace tabe megele celi mwo coho, me nye pa a mwotabe na caa ukéiu. Be pwocoon me cibu, ke e bo pabuwohi, ke genye o patieden a tabe megele, me ni mwotabe. Ûhu! Wâé heme nye ne a tabe megele na mwo coho, ne ha a mwotabe na mwo coho!» ");
INSERT INTO cam_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","É ha a céiu *tan iitihi, ke lé uti a pwaaden na e pitahagéi ni apwoamu wo Iésu me lépwo acémun den. Ke é nge he pwaaden, ke lé tabwo ni ace blé wo lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ke lé pii te Iésu wo lépwo béé Farasaio pie: «Aje, é mu ko ade na lé wonaa wo lépwo acémun dem ha a tan iitihi! Be iitihi!» ");
INSERT INTO cam_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ke e hegi ne telé pie: «Kona time geé mu uce pine ne he ni *tii iitihi ana e pwo wo pa daame *Davita, ha a benaamwon de Abiatar, pa *daame he lépwo apwoâpwailo? Be é ha a céiu tan, ke menelé, woélé me ni béén, be tice celi lé wii. Ke e taa ha a *mwaiitihi na pwo ko mwaanu wo Davita. Ke e pé a pwoloa na ne me de Padué, na te icehi lépwo apwoâpwailo na jan ne kolé me lé eni. Ke e eni, ke e ne mwo te lépwo béén.» ");
INSERT INTO cam_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ke e pii mwo wo Iésu pie: «Wo Padué, ke e pwo a tan iitihi me de ni apulie. Kehe time e uce pwo ni apulie me de a tan iitihi! ");
INSERT INTO cam_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","«É mu ko anaa, ke woéo pa Nahi Apulie, ke pa eapwihi a tan iitihi.» ");
INSERT INTO cam_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","É alecehe anaa, ke e â taamwo ha a *mwotapitihi wo Iésu, ha a *tan iitihi. Pwo pa apulie na e mu lang na mele a in. ");
INSERT INTO cam_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ke lé te ju ome Iésu wo lépwo *Farasaio, beme lé alihi pie, he e o te pwo me wâé nang ha a tan iitihi. Wonaa beme lé pipé ne kon. ");
INSERT INTO cam_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ke e pii te pali cunu wo Iésu pie: «Go cuwoda ânebuhelé ati.» ");
INSERT INTO cam_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ke e pii te lépwona lé mu lang pie: «Woté? He te ne me pwo ana wâé, ha a tan iitihi, ai ana ta? Me celuimi a mulip, ai me taunuhi?» Ke time lé uce cihe. ");
INSERT INTO cam_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ke e te ju omelé he okéé, be lé pwo me e mu he ni picani ko a bwo mwoiu ne ni pwonimelé. Ke e pii te pali apulie pie: «Go cinebé a im.» Ke e cine ngen a in, ke caa te wâé mwo kuti. ");
INSERT INTO cam_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Wo lépwo Farasaio, ke lé te pwome â wie mu ha ali mwotapitihi, ke lé picihe me lépwo béé *Érode Antipas, ke lé tai hane ace bwopwonen me lé taunu Iésu. ");
INSERT INTO cam_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Lé â ticepwon ne Galilé wo Iésu me ni acémun den. Ke hiwon ni apulie na lé âcéilé: ni apulie na lé âbé mu Galilé, mu *Judé, ");
INSERT INTO cam_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mu *Iérusaléma, mu Idumé, ke é ha a céiu duaan mu ko a éémwa Ioridano, ke é he ni duaan mu ko a Tir ke é mu Sidon. Ke lé tai âbé ali Iésu, be lé téne nina e pwo. ");
INSERT INTO cam_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ke e pii te lépwo acémun den wo Iésu pie: «Geé pipwopweehi ace cuwo nahi ong, be é kon heme nihe hiwon ni apulie, be koli lé bo haiteéo!» ");
INSERT INTO cam_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Be e caa pwo me wâé ni apulie na hiwon jélé. Ke nina lé mu he ni picani ko ni cunu kolé, ke lé téte ne kon, beme lé ti kon. ");
INSERT INTO cam_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ke é he lé alieng ne ni apulie na pwo duéé kolé, ke lé tupwo ke lé tidihi jililé ânebuhen, ke lé toii pie: «Wogo ke pa *Naî Padué!» ");
INSERT INTO cam_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ke e cihe me mwoiu ne kolé pie: «Geé nemwo pipatemehiéo!» ");
INSERT INTO cam_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","É alecehen, ke e taa pwo juwole wo Iésu. Ke e tode ni apulie na te nimen kolé, ke lé âbé céiieng. ");
INSERT INTO cam_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ke e pipégali mu hadeniilé lépwona 12 jélé beme ni béén, ke me lé â patemehi a *Mwametau te Padué. {Ke e ne me niilé pie *apostolo.} ");
INSERT INTO cam_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ke e ne telé a pihuô beme lé peni ni duéé. ");
INSERT INTO cam_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Weengi ni nii lépwo 12 apostolo: Simon, na e toii me a niin pie Pétéru; ");
INSERT INTO cam_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Cang, pa naî Zébédé; Ioane pa ciéé Cang (e toii niilu wo Iésu pie Boanergès, a bwopiinen pie ‘lupwo nahi tikekele’); ");
INSERT INTO cam_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","André; Filip; Bartélemi; Mataio; Toma; Cang, naî Alfé; Tadé; Simon, pa Zélote; ");
INSERT INTO cam_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iscariot, pana e bwo icu Iésu. ");
INSERT INTO cam_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ke e mwojuia ngemwo pwomwo wo Iésu. Ke hiwon ni apulie na lé pitapitilé nelang. Ke tice bwopwonen me lé wiinaado wo Iésu me lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ke é he lé téne anaa ne ni apulie mu ha a pwomwoiu ten, ke lé âbé pééeng kojalé. Be lé pipii telé pie: «Pa apiolo!» ");
INSERT INTO cam_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pwo lépwo *dotéén ko patén na lé ole mu Iérusaléma. Ke lé pipii pie: «E ko Iésu wo Caatana, pa caa te ni duéé. Be weeng na e ne ten a pihuô me e peni ni duéé.» ");
INSERT INTO cam_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","E todelé wo Iésu, ke e tahimwolé pie: «Kona e o woté ko ace bwopwonen me e te pipawieeng mu ko pa apulie wo Caatana?» Ke e pii telé ni ocine ce: ");
INSERT INTO cam_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","«É hemepie e te pipwopa ne kon ace céiu mwametau, ke o pwocoon me e mu mang. ");
INSERT INTO cam_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ke me lé pipiéi hadeniilé ne ni apulie ha a pwomwoiu, ke a pwomwoiu naa, ke o pwocoon me e mu mang. ");
INSERT INTO cam_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ke é hemepie e pipwopa ne mwo kon wo Caatana, ke mepie time e uce piténedeeng mwo, ke o caa time uce bwolihi a pihuô ten. O caa te wonaa a bwo pipatieden den. ");
INSERT INTO cam_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","É hemepie nimenye me nye taa ha a mwa te pace céiu apulie na pwo niihen, me nye pé ni naamuun, ke wâé heme nye mi cieeng. É mulang, ke genye bwobe pé ni naamuun mu ha a mwa ten.» ");
INSERT INTO cam_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","«Geé téne ehi, be é pii tewé a juuju pie: O te jan me pineu pa apulie na e pwo nina ta, te piwien hemepie e cihe me ta ne ko Padué. ");
INSERT INTO cam_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kehe wo pana e cihe me ta ne ko a *Jenen Iitihi, ke o time uce jan me pineuhi ni ta pwo ten. Ke ni ta pwo ten, ke o tee mu dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","E pii anaa wo Iésu, be me de lépwo dotéén ko patén. Be lé pii pie pwo duéé kon. ");
INSERT INTO cam_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ke é alecehen, ke lé tehenebé wo nyaa te Iésu me lépwo âjiénen. Ke lé âbé tebwo pwomwo. Ke lé pahede pa céiu apulie me e taa tode Iésu. ");
INSERT INTO cam_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Hiwon ni apulie na lé mu aujeni Iésu, ke lé pii ten pie: «Aje, élé âoté pwomwo wo nyaa tem me lépwo ciéém. Be lé ko haneko.» ");
INSERT INTO cam_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ke e pii telé pie: «He woo êce nyaa tong? Ke wooélé lépwoce ciééng?» ");
INSERT INTO cam_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ke e te ju ome ni apulie na lé ko tebwo aujenieng, ke e pii telé pie: «Geé alihi, be woélé-ni ni nyaa tong me ni âjiénung. ");
INSERT INTO cam_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Be wo pana e pwo ana nime Padué kon, ke te weengaa kuti pa ciééng, ke ê pwaadeniing, ke ê nyaa tong.» ");
INSERT INTO cam_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","E pacémuni ni apulie mwo ko a pwooti wo Iésu, ne ticepwon ne Galilé. Ke hiwon nina lé taineibulé ne kon. Ke é mu ko anaa, ke e taa ha a céiu ong, na e teko mu he tabe, ke e tebwo. Ke lé te mu jeda huâiu ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ke e pwo-ocine he e pacémunilé ko ni naado na hiwon. Ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Geé téne! E bwo mu wo pa céiu apulie, ke e bwo wie ha a céiu tan, beme e tagiliihi ni âdaanu. ");
INSERT INTO cam_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ke é he e ko tagiliihi, ke lé tupwo nge pwo pwaaden ni béé pidenaado. Ke lé âbé ne ni meni, ke lé wii ati. ");
INSERT INTO cam_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","«Ke ni béén, ke lé tupwo ne ha a wii péi. Ke lé piepin ko cim, be time uce hiwon ni pule lang. ");
INSERT INTO cam_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kehe icehi ana me e niê na a téale, ke éle li nahi âdaanu, ke lé meiu, be te tice waan. ");
INSERT INTO cam_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ke ni béén, ke lé tupwo ne ha awieme ni mwawi ubwo. Ke me lé tai picim, ke lé taunuhi li pidenaado, ke te tice acehin. ");
INSERT INTO cam_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","«Ke ni béén, ke lé tupwo ne ha a pule na wâé. Ke lé cim, ke piubwo jélé da, ke lé aca. Ke ni béén, ke 30 ni acehin; ke ni béén 60; ke ni béén mwo, ke lé taa die pwo 100.» ");
INSERT INTO cam_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ke e pii mwo wo Iésu pie: «Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","É he lé te pimu cehi wo Iésu me lépwo 12 *apostolo ten me lépwo béén, ke lé tahimwoeng pie: «É mu ko ade na go pii ni ocine naa?» ");
INSERT INTO cam_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ke e hegi ne telé pie: «Wogewé na e ne tewé wo Padué, me geé temehi a ju bwomune a Mwametau ten. Kehe ni béé apulie, ke lé te ju téne cehi ni ocine. ");
INSERT INTO cam_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Be e pii ne kolé wo Padué pie: Mwoiu a puni a puapulie ce. Be lé tee omehi taaci, kehe time lé uce alihi temehi. Lé tee téne taaci, ke time lé uce téne temehi. Te muhi telé me lé bitelé bé céiiéo, ke me é pineuhi ni ta pwo telé.» Ésaïe 6.9−10 ");
INSERT INTO cam_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","É alecehen, ke e pii te nina lé mu lang wo Iésu pie: «Kona time geé uce temehi a ocine ko pa apicemi? Ke geé bo woté ko ace bwo temehi ne ni béé ocine ko a Mwametau? ");
INSERT INTO cam_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Pa apicemi, ke e cemi a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ke ni béé pidenaado, ke lé tupwo nge pwo pwaaden. A pwaaden, ke ni apulie na lé téne a pwooti, kehe e pwome âbé pé kojalé a pwooti wo *Caatana, na caa cemi ne he ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","«Ke ni béé pidenaado, ke lé tupwo ne ha a wii péi. A wii péi ke ni apulie na lé téne a pwooti, ke lé pwome hegi ko a pipwodéén. ");
INSERT INTO cam_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kehe icehi ana te tice waan ne kolé a pwooti na lé téne. Ke lé te pitaatééhi ni bwo niimihinaado telé. Hemepie e tuie ne kolé a tacebwén, me pwo nina ta ne kolé, watihen a pwooti te Padué, ke lé patieden ni céihi telé. ");
INSERT INTO cam_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","«Ke ni béé pidenaado, ke lé tupwo ne he ni mwawi ubwo. A pule naa ke ni apulie na lé téne a pwooti, ");
INSERT INTO cam_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","kehe icehi ana pinekepé ni pwonimelé ne ko ni naado na e tuie ne pwo a bwohemwo ce. Ke lé téte cehi mwani me ni pétaapwo naamuu bwohemwo. É mu ko ninaa, ke e taunuhi a pwooti, ke te tice acehin. ");
INSERT INTO cam_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","«Ke ni béé pidenaado, ke lé tupwo ne ha a pule na wâé. Ke a pule naa ke ni apulie na lé téne a pwooti, ke lé hegi ne he ni pwonimelé. Ke pwo acehi a pwooti ne kolé. Ke ni béén, ke 30 ni acehin; ke ni béén, ke 60, ke ni béén mwo, ke lé taa die pwo 100.» ");
INSERT INTO cam_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","E pii telé mwo wo Iésu pie: «Time nye uce ne miû ko a mwomiû, me nye talui ko ace cio, ai me nye ne haahi ace apule. Kehe genye ne da ko miiden. ");
INSERT INTO cam_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ati ni naado na neduwohi, ke o bo habwii ne ha a pwéélang, beme nye alihi ehi. ");
INSERT INTO cam_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ke e pii telé mwo pie: «Geé pipwocile nina geé téne! Be e o bo pwo tewé wo Padué nina geé pwo te lépwo béén. Ke e o bo pwo celi nihe piubwo koja nina geé pwo. ");
INSERT INTO cam_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Be wo pana caa pwo ne ten, ke o ne mwo pwon ce béén. Kehe wo pana tice ten, ke o pétaabwon kojaeng a nehinaado na mwo e pelen.» ");
INSERT INTO cam_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ke e pii mwo wo Iésu pie: «Mepwo a *Mwametau te Padué, ke pwohewii ani: «E bwo mu wo pa céiu apulie, ke e bwo cemi ni âdaanu ne ha apwoamu ten. ");
INSERT INTO cam_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ke é alecehen, ke e mwo pwome mwaale, ke e pule he bwén, ke e ûmiê ha acaama. Ke é ha a benaamwon naa, ke lé cim li âdaanu, ke piubwo jélé da. Kehe icehi ana wo paje, ke time e uce temehi ace bwo cim nen. ");
INSERT INTO cam_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Be te a penem de a pule me e pwo me cim ni âdaanu. Ke e ne me piubwo jélé da, dieli lé ne ni acehilé, me ni piden. ");
INSERT INTO cam_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ke me caa pun ni âdaanu ha apwoamu, ke wo pa apulie naa, ke e bo pipwopweeng me e pitii âdaanu.» ");
INSERT INTO cam_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ke e pii mwo wo Iésu pie: «He a Mwametau te Padué, ke he pwohewii ace de? Weengi a ocine, me geé temehi: ");
INSERT INTO cam_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","«A Mwametau te Padué, ke e pwohewii a pide moutarde na genye cemi he pule; a cuwo nahi pidenaado na te junihe wahin. ");
INSERT INTO cam_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Kehe icehi ana me e cim, ke te junihe ubwo nang koja ati ni naado na nye cemi he ni cereda. Be bwo ubwo ni dihen, ke lé âbé ne ni meni, ke lé te pwo mwonahilé ne ha a boom kon.» ");
INSERT INTO cam_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","É he e pii te ni apulie a pwooti te Padué wo Iésu, ke e pii ni ocine na pwohewii a ocine ce. Ke e pwo a bwopiinen, beme lé pé ce delé mu ko ni bwo téne temehi nen delé. ");
INSERT INTO cam_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Be e te cuwo ko pwo-ocine telé, kehe me bwo te piwoélé cehi me lépwo acémun den, ke e bwo te pipatemehi telé ati. ");
INSERT INTO cam_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","É ha a babwén naa, ke e pii wo Iésu te lépwo acémun den pie: «Nye gaale ângedé ko a céiu goon.» ");
INSERT INTO cam_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ke lé pééeng pwo a ong na lé tebwo hen, ke lé cepewie ni apulie. Kehe icehi ana lé âcéilé ni béén ne he ni béé ong. ");
INSERT INTO cam_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","É alecehen, ke e tabuhi tahieng a dan. Ke te piubwo da a bwo tahieng. Ke te piubwo ni pihijié, ke e taii ne ha a ong. ");
INSERT INTO cam_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Kehe wo Iésu, ke e teko pule alecehe ali ong, pwo a paapun. Lé paûmiêeng wo lépwo acémun den, ke lé pii ten pie: «Pa apipune, genye o caa mwiiê! Woté! Time uce junaado ne tem?» ");
INSERT INTO cam_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ke e ûmiê, ke e heni ali dan. Ke e pii te ali jié pie: «Go cuwo!» Ke caa te ju wâé mwo a amu, ke e cuwo ali dan. ");
INSERT INTO cam_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ke e pii telé pie: «É mu ko ade na mwotikewé? Time geé uce téele céihi kuti?» ");
INSERT INTO cam_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kehe te nihe mwotilé, ke lé pipii telé pie: «Éé! Be he woo pa apulie ce, me lu piténedeeng a dan me a jié?» ");
INSERT INTO cam_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ke lé tehene nge Gadara wo Iésu me lépwo acémun den ko a goon ne gaale cemwo pejié ne Galilé. ");
INSERT INTO cam_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ke me e ole mu pwo ali ong wo Iésu, ke e te wiebé kuti mu ha a iitihi wo pa apulie na pwo duéé kon. Ke e âbé beni Iésu. ");
INSERT INTO cam_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Be wo panaa, ke pa apimu he iitihi. Ke te tice bwopwonen me lé imwieng, me lé cie lupwo in me lupwo an; piwien mwo heme cieeng ko ace itihe toki. Be lé te cuwo ko cieeng kon, ke e te cuwo ko tahagéi. Ke te tice pace apulie celi pwo niihen me e imwieng me e ju mu. ");
INSERT INTO cam_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Téteda he ni benaamwon, heme bwén ke pwang, ke e teme da ni pwowiikau ne ha ali iitihi, ke é ne pwo ni juwole. Ke e pitanahieng ko ni péi. ");
INSERT INTO cam_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Me e ali Iésu mu ité, ke e téte beniieng, ke e tidihi jilin ânebuhen, ");
INSERT INTO cam_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ke e toii da pie: «Iésu, pa *Naî Padué na nihe e daaité, ade aceli nimem me go pwo tong? É ileko ne he nii Padué pie go nemwo pwo tong aceli ta!» ");
INSERT INTO cam_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","E pii anaa, be e pii ten wo Iésu pie: «Duéé, go wie mu ko pa apulie ce!» ");
INSERT INTO cam_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ke e tahimwoeng wo Iésu pie: «He piwoté ace niim?» Ke lé hegi ne ten ne ni duéé pie: «A niime pie Bwehi duéé, be hiwon geme.» ");
INSERT INTO cam_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ke e wâgo ko Iésu wo pali, ke e pii ten pie: «Hemepie go pawiehi ni duéé mu kong ke go nemwo cibéélé mu éni ha amu!» ");
INSERT INTO cam_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","12","Ke lé wâgo kon mwo ne li duéé ke lé pii ten pie: «Me geme ân, ke me geme taa he ni puwokwo ne!» Be pwo a bwehi puwokwo na nihe hiwon jélé na lé ko um gaale hamwo juwole. ");
INSERT INTO cam_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ke e ne telé ana lé ilehi wo Iésu. Ke lé wie mu ko pali apulie, ke lé gaale he li puwokwo. Ke lé te tai téte kuti li puwokwo mu hamwo juwole, ke lé ole he jié, ke lé mwiiê. Caa te piâmwonuhi a 2000. ");
INSERT INTO cam_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wo lépwo awéihi puwokwo, ke lé téte ngen, ke lé â piuti a jepule naa, ne ha a mwopopwaalé ke é na ati ha amu. Ke lé âbé ni apulie, beme lé alihi nina e ko tuie. ");
INSERT INTO cam_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ke lé tehenebé pele Iésu, ke lé ali pali apulie li pwo duéé kon, he e caa ko tebwo, ke e caa cuwohe ni epwén, be caa ju wâé nang. Ke lé téetieng, ke te junihe mwotilé. ");
INSERT INTO cam_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ke lépwona lé alihi nina e tuie, ke lé piuti te lépwo béén ali jepule ko pa apulie naa, me ni puwokwo. ");
INSERT INTO cam_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ke lé wâgo ko Iésu wo lépwo apulie mu ha amu naa, ke lé pii ten pie: «Nimeme me go engen mu ha amu teme.» ");
INSERT INTO cam_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ke me e taa pwo ali ong wo Iésu, ke wo pali lé wie mu kon li duéé, ke e ileeng pie: «Nimung me é âdé céim.» ");
INSERT INTO cam_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Kehe icehi ana te muhi te Iésu, ke e pii ten pie: «Go mwojuia ne ha a pomwa tem, pele lépwo béém. Ke go uti telé a bwo pipwoééhem de Padaame, ke ati ni naado na e pwo me dem!» ");
INSERT INTO cam_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ke e mwojuia mwo wo paje, ke e uti ne ha a duaan na pii kon pie Dix Villes ni naado na e pwo me den wo Iésu. Ke lé tai téetihi ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","E taa pwo ali ong wo Iésu, ke e gaale ko a goon ne gaale cemwo. Ke me e ole mu pwo ong, ke hiwon ni apulie na lé mu aujenieng ne ticepwon. ");
INSERT INTO cam_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ke e tuiebé wo Jaïrus, pa céiu caa te *mwotapitihi, ke e ali Iésu, ke e â tidihi jilin ânebuhen. ");
INSERT INTO cam_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ke e pii ten pie: «Go âbé epin, be e caa pwo me e mele ê naîng! Go âbé me go ne ni im huîin, beme tieden a cunu kon, ke me wâé nang mwo.» ");
INSERT INTO cam_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ke e âcéin wo Iésu. Ke te nihe hiwon mwo ni apulie na lé ân, ke lé caa ju pitité. ");
INSERT INTO cam_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ke e mu hadenii ni apulie naa ê céiu toomwo na caa 12 ni jo na cunu nang hen, be e mu tuie ni benaamwon na e mu téte kon a cewéle. ");
INSERT INTO cam_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Caa junihe hiwon ni dotéén na e mu â alilé, ke lé bwo pwo me junihe cunu nang kuti. Ke e caa ju patieden ati ni mwani ten, kehe icehi ana time uce wâé nang, kehe bwo junihe cunu nang kuti. ");
INSERT INTO cam_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ke e téne a jepule ko Iésu, ke e âbé ne ha a tapitihi naa. Ke e piâbé alecehe Iésu, ke e ti ko a epwénen. ");
INSERT INTO cam_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Be e niimihi pie, ‘Mepie é te ju ti ko a epwénen cehi, ke o caa te pitieden a cunu kong.’ ");
INSERT INTO cam_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ke me e pwo, ke e te cuwo kuti a bwo téte kon na ali cewéle. Ke e téne ne kon pie caa tieden a cunu kon. ");
INSERT INTO cam_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ke wo Iésu mwo, ke e téne pie, e engen kojaeng a céiu duaa niihen, ke e biteeng, ke e tahimwo ni apulie pie: «He woo na e ti ko a epwénung?» ");
INSERT INTO cam_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ke lé hegi ne ten wo lépwo acémun den pie: «Go ko cuwo ha awieme ni apulie na lé ko pitité! Ke é mu ko ade na go tahimwohi pie, woo na e ti kom?» ");
INSERT INTO cam_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kehe icehi ana e te piniê aujenieng wo Iésu, beme e niê hane pie, he woo na e pwo anaa. ");
INSERT INTO cam_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ke e te ju éjén êgi toomwo ko a bwo mwotieng, be e temehi ana e ko tuie ne kon. Ke e âbé ke e tidihi jilin ânebuhe Iésu, ke e pii ten ati a juuju. ");
INSERT INTO cam_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ke e pii ten wo Iésu pie: «Adéiko go êje! Caa wâé go mwo ko a céihi tem! Ke go engen, ke me e mu pelem a péém. Be caa te tieden a cunu kom!» ");
INSERT INTO cam_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","É he e mwo ko pii anaa wo Iésu, ke lé tehenebé ni béé apulie mu pele Jaïrus, pali eapwihi mwotapitihi, ke lé pii ten pie: «Au! E caa mele wo êgi naîm. Kehe go nemwo pahauli pa apipune.» ");
INSERT INTO cam_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","E téne ni pwocihe naa wo Iésu, kehe time e uce pipéce ne kon, ke e pii te Jaïrus pie: «Go nemwo pwo me mwotiko! Kehe go céihi ne kong!» ");
INSERT INTO cam_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E te ju pé cehi Pétéru, me Cang me Ioane, lupwo pwénaâjién. Be time uce nimen me lé âcéin ne ce béé apulie. ");
INSERT INTO cam_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ke lé tuie nge ha a pomwa te Jaïrus. Ke te junihe hiwon kuti ni pwocihe lang. Ke wo Iésu, ke e ali ni apulie he lé ko é, ke lé pihemun. ");
INSERT INTO cam_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ke e taa ha ali mwa, ke e pii telé pie: «É mu ko ade na geé te junihe pié ne da kon? Kona geé é kona woté? Geé ko pii pie e caa mele ê cuwo ewa ne; kehe woéo, ke é pii pie e teko ju puluta!» ");
INSERT INTO cam_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ke lé pihoonieng. Ke e tai pawielé wo Iésu, ke e pé lu nyaa me caa te êgi ewa, me lépwo acémun den na cié jélé. Ke lé taa ha a céiu nemwa na lé ne êgi cuwo nahi ewa hen. ");
INSERT INTO cam_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ke e pétaa ko a in, ke e pii ten pie: «Talita, koumi!» A bwopiinen pie: «Ê naîng, go cuwoda!» ");
INSERT INTO cam_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ke e te cuwoda kuti, ke e engen! Ê cuwo nahi toomwo naa, ke 12 ni jo hen. Ke lé te junihe téetihi ne nina lé mu lang. ");
INSERT INTO cam_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ke e pii telé wo Iésu pie: «Geé ne celi e wii.» Ke e pii mwoiuhi telé pie: «Geé nemwo pii te ce béé apulie ana e tuie ne éni.» ");
INSERT INTO cam_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","E engen mu ha a duaan naa wo Iésu, ke e â Nazaret, he na ubwo nang ne hen. Ke lé âcéin wo lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","É ha a tan ko pwoiitihi, ke e taa ha a *mwotapitihi, ke e pacémuni ni apulie na hiwon jélé ko a pwooti te Padué. Ke me lé téne, ke lé te junihe téetieng, ke lé pitahimwolé pie: «Kona woo na e picaa ten nina e ko pii? E âbé mu wé ni bwo temehinaado ten, ke ni *pipwojunuun na e pwo? ");
INSERT INTO cam_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Be pali apenem ko ba-acuwo, pali naî Maria, ke pa cuwo Cang, me José, me Jude, me Simon! Ke lé teko mulie pelenye ni toomwo pwaadeniin!» Be lé pitaaba ne kon wo lépwo Nazaret, ke te muhi telé me lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ke e pii telé wo Iésu pie: «Au, mwolihi! Be wo pa péroféta, ke lé te paciitieng ati ne he ni amu, kehe te icehi ne ha amu ten, ne pele ni âjiénen!» ");
INSERT INTO cam_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ke te tice bwopwonen me e pwo celi pwojunuun nelang. Kehe icehi ana te pwo ni béé cunu na e ne ni in huîilé, ke wâé jélé. ");
INSERT INTO cam_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E te junihe téetihi, be te ju time lé uce céihi kuti ne ni apulie. É alecehe anaa, ke e â patemehi a Pwooti Wâé wo Iésu, ati ne he ni mwopopwaalé na élé aujenihi a Nazaret. ");
INSERT INTO cam_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ke e tode lépwo 12 *apostolo ten, ke e nelé ngen he pialo. Ke e ne telé a pihuô beme lé peni ni duéé. ");
INSERT INTO cam_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ke e pii telé pie: «Geé nemwo pé ce naado hemepie geé engen: mepie ace pwoloa, ke ace élele, ke ace mwani ne he ni mwomwani tewé. Kehe geé te ju pé cehi ce bwajaawé, ");
INSERT INTO cam_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","me ce dihibwaawé, ke te picéiu ce epwénewé.» ");
INSERT INTO cam_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ke e pii telé mwo pie: «Mepie lé hegikewé ne ha ace céiu pwomwo, ke wâé heme geé mu lang, dieli geé bo engemwo mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ke heme time uce nime ni apulie me lé hegikewé ne ha ace céiu duaan, ke me te muhi telé me lé tabemikewé, ke geé engen mulang. Ke geé tagiliihi ni muu pule ko ni awé, beme geé habwii pie time uce wâé ni huô telé be muhi telé ko a pwooti te Padué.» ");
INSERT INTO cam_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ke lé ân wo lépwo apostolo, ke lé patemehi te ni apulie pie: «Geé pitaatééhi ni mulihewé.» ");
INSERT INTO cam_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ke lé peni ni duéé na hiwon mu ko ni apulie. Ke lé ne huile ko ni apulie na cunu jélé, ke lé pwoiitihi ne kolé, ke wâé jélé. ");
INSERT INTO cam_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","E téne a jepule ko Iésu wo pa daame *Érode Antipas, be caa nihe piân a jepule kon. Be lé pii ne kon wo lépwo béén pie: «Wo *Ioane pa apipuu apulie, he e caa mulie cemwo mu ha amele! Anaa kuti a watihen me e pwo ni pipwojunuun.» ");
INSERT INTO cam_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kehe lé pii ne ni béén pie: «Wo péroféta Élia.» Ke lé pii ne ni béén mwo pie: «Pa céiu péroféta ha a céiu benaamwo amu.» ");
INSERT INTO cam_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Kehe me e téne anaa wo Érode, ke e pii pie: «Éé! E caa mulie cemwo mu ha amele wo Ioane pa apipuu apulie, pali é pwo me tahagéi henen!» ");
INSERT INTO cam_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Weengi a jepule ko a bwo mele te Ioane: Wo Érode, ke lu piaten me Érodiade, ê mwode Filip, pa âjiénen. Ke e mu te cuwo ko pii ten wo Ioane pie: «Te tice mwomwon dem me go pé ê mwode pa âjiénem!» Ke e te pwo me imwi Ioane wo Érode, ke e cieeng, ke e neeng he karépu. ");
INSERT INTO cam_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ke e tééti Ioane wo êje Érodiade, ke nimen me e pwo me e mele. Kehe icehi ana te pwocoon den me e pwo, ");
INSERT INTO cam_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","be e te paciiti Ioane wo Érode, be e te temehi pie, pa apulie na e mwomwon, ke e iitihi, ke e te pipwopain. Te nime Érode me e tabemieng, kehe icehi ana heme e téneeng, ke caa time e uce temehi aceli me e pwo. ");
INSERT INTO cam_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ke mepwo êje Érodiade, ke e hane ace bwopwonen me e pwo me e mele wo Ioane. Ke te ju cuwo ehi ne kon a tan na lé pipaunuhi a bwo âbeele te pa daame Érode. Be e pwo a piwiinaado ubwo wo Érode, ke e tode ati ni gupéno, ke ni caa te coda, me ni apulie na piubwo jélé ne ha amu Galilé. ");
INSERT INTO cam_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ke e taa ha a mwa naa ê naî Érodiade, ke e pwolu. Ke lé te junihe pipwodéén wo Érode, me lépwona lé piwiinaado me weeng. Ke e pii te êgi ewa pie: «Go ileéo ko celi nimem kon, be é o caa te ne tem.» ");
INSERT INTO cam_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ke e *piapwo ne ten pie: «É o te ne tem ati celi go o ilehi kojaéo, te piwien heme a awieme a mwametau tong.» ");
INSERT INTO cam_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ke e wie wo êgi toomwo, ke e pii te nyaa ten pie: «He ace de celi me é ilehi koja pa daame?» Ke e hegi ne ten pie: «Go ilehi kojaeng a puni Ioane pa apipuu apulie.» ");
INSERT INTO cam_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ke e te pwome téte wo êgi toomwo, ke e â too pa daame Érode, ke e pii ten pie: «Nimung me go ne tong a puni Ioane ne ha ace tam.» ");
INSERT INTO cam_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ke te junihe piwahin Érode. Kehe icehi ana pwocoon den me e tapihi, be e caa piapwo ne ânebuhe ni béén na e caa todelé. ");
INSERT INTO cam_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ke e te pwome pii te pa céiu coda pie: «Go ân, ke go pébé céiiéo a puni Ioane.» Ke e engen wo pali coda, ke e â ha ali karépu, ke e â tahagéi a hene Ioane. ");
INSERT INTO cam_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ke e pébé ali punin ne ha a tam, ke e ne te êgi ewa toomwo. Ke e pé wo êgi, ke e â ne te nyaa ten. ");
INSERT INTO cam_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ke me lé téne anaa wo lépwo acémun de Ioane, ke lé â pé a één, ke lé â ne ha a iitihi. ");
INSERT INTO cam_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lé mwojuia mwo wo lépwo apostolo, ke lé pipitilé ne ko Iésu. Ke lé uti ten ati ni naado na lé pwo, ke ni naado na lé patemehi te ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ke e pii telé pie: «Geé âbé céing ne ha a céiu duaan na tice apulie hen, beme geé o mwo mwaale.» Be tice benaamwon me lé wiinaado, be hiwon ni apulie na lé âbé céiilé. ");
INSERT INTO cam_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ke lé te piân cehi pwo a céiu ong, ne ha a céiu duaan na tice apulie hen. ");
INSERT INTO cam_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Kehe icehi ana te junihe hiwon ni apulie na lé alilé he lé engen, ke lé te temehilé. Ke lé tétebé mu ati he ni mwopopwaalé, ke lé tuiebé ânebuhe Iésu me lépwo acémun den ne ko a céiu goon. ");
INSERT INTO cam_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ke me e ole mu pwo ali ong wo Iésu, ke e ali li apulie he te nihe hiwon jélé. Ke e te nihe pipwoééhelé, be lé pwohewii ni muto na tice awéilé. Ke e picaa telé ni naado na hiwon. ");
INSERT INTO cam_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ke e caa pwo me e nuule a téale, ke lé âbé céiieng wo lépwo acémun den, ke lé pii ten pie: «O caa babwén, kehe apiticie éni. ");
INSERT INTO cam_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Go ne ngemwo ni apulie ce, nge he ni mwopopwaalé me ni pwomwo na e mwonu, beme lé pwocuhi celi me lé wii.» ");
INSERT INTO cam_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Kehe icehi ana e hegi ne telé wo Iésu pie: «Ûhu! Geé ne ce wiinaado telé!» Ke lé tahimwoeng pie: «Kona geme â pwocuhi pwoloa me de ati ni apulie? Nihe ubwo a cuhin!» ");
INSERT INTO cam_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ke e pii telé pie: «Be he niile ce pwoloa celi e pelewé? Geé â alihi.» Ke lé pitahimwolé, ke lé pii ten pie: «Nim ni pwoloa, ke alo ni ikua.» ");
INSERT INTO cam_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ke e pii telé pie: «Geé pii te ni apulie ce pie: “Geé pwo ce pubuuwé, ke geé tebwo he ni meté.”» ");
INSERT INTO cam_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ke lé pwo ni pubuulé me pi 100, ke pi 50, ke lé tebwo. ");
INSERT INTO cam_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ke e pé li pwoloa li nim me lupwoli ikua wo Iésu, ke e alehede da he miiden, ke e pwo-olé te Padué. Ke e ebii li pwoloa, ke e ne te lépwo acémun den, ke lé patihi ne ko ni apulie. Ke lé wonaa mwo ko lupwoli ikua. ");
INSERT INTO cam_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ke lé tai wiinaado ati, ke caa pwoluu jélé. ");
INSERT INTO cam_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ke lé taineibuhi mwo ni nehi mepwoloa, me ni ne-ikua, ke lé pwo na 12 ni élele kon. ");
INSERT INTO cam_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ke a jéhi ni apulie aiu na lé wiinaado, ke pwo 5000 jélé. ");
INSERT INTO cam_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Te ju é alecehen, ke e pii wo Iésu te lépwo acémun den pie: «Geé taa pwo ong, ke geé mi gaale ângedé ko a céiu goon, ha a mwopopwaalé Betsaïda. Be é mwo tee mu, beme é pamwojuiéhi mwo ni apulie.» ");
INSERT INTO cam_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ke me e caa pinelé ati, ke e taa pwo juwole, beme e pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","É he caa bwén, ke caa élé ha awieme jié wo lépwo acémun den, pwo ong. Ke e te pimu cehi âdaalé ha a meiuhi wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Caa é pwopwometan, ke e alihi pie pwocoon a bwo tahi kaale telé, be âbédelé na a dan. Ke e âbé céiilé pwo bwotabe. Be nimen me e wédenilé. ");
INSERT INTO cam_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Ke me lé alieng he e ko engen pwo bwotabe, ke te junihe mwotilé, ke lé haa da ko miiden, be lé niimihi pie a duéé! Kehe icehi ana e te pwome pacihelé wo Iésu, ke e pii telé pie: «Geé nemwo pwo me mwotikewé. Be woéo! Geé mwoiu!» ");
INSERT INTO cam_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ke e taa céiilé ne pwo ali ong. Ke e cuwo ali dan. Ke te junihe emegéi nalé. ");
INSERT INTO cam_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Be time lé uce temehi ni pipwojunuun na e tuie he li e pipwopatihi ni pwoloa wo Iésu. Be capuhi ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lé caa nebwén ko tahagéi jié wo Iésu me lépwo acémun den, ke lé tuie gaale ha a duaan na e mwonuhi Génésaret, ke lé taa ali ong. ");
INSERT INTO cam_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ke me lé ele ole, ke lé alihi temehi Iésu ne ni apulie lang. ");
INSERT INTO cam_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ke lé téte nge ati ha amu telé, ke lé pébé céiieng ni cunu ne pwo ni apule telé ati ne he na lé téne pie e lang. ");
INSERT INTO cam_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","É ati he na e â lang wo Iésu, he ni mwopopwaalé, ke ni pwomwo ubwo, me ni amu, ke lé pébé ni cunu ne he ni apimu te ni apulie ati. Ke lé piwâgo ko Iésu, ke lé pii ten pie: «Te jan heme lé te ju ti cehi ko a baaé epwénem?» Ke caa te wâé ati nina lé ti kon. ");
INSERT INTO cam_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Lé âbé wo lépwo *Farasaio, me ni béé *dotéén ko patén na lé âbé mu *Iérusaléma. Ke lé pitapitilé ati ne ko Iésu. ");
INSERT INTO cam_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ke lé alihi pie, lé â wiinaado wo lépwo béé acémun den, kehe time lé uce puu ni ilé pwohewii a bwopwonen de ni ukéiu telé. ");
INSERT INTO cam_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","4","Be wo lépwo *Juif, ke lé te engen ne ko a huô ha a bwomu te ni ukéiu telé: Lé mi puu ehi ni ilé, ânebuhe ni bwo wiinaado telé. Ke lé wonaa mwo, he lé mwojuia mwobé mu he ni apimu te ni apulie ati. Ke hiwon ni béé bwomu na lé âcehin mwo, pwohewii a bwo puu mwoûdu, me mwotabe, me ila. Ke mepwo é ne ko lépwo Farasaio, ke lé mwo te junihe pipaunuhi. ");
INSERT INTO cam_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","É mu ko anaa, na lé pii te Iésu, woélé me ni dotéén ko patén pie: «Wo lépwo acémun dem, ke time lé uce mulie pwohewii a bwomu te ni watihenye. Be lé wiinaado ko ni ilé na tooli. Kehe é mu ko ade, go paje?» ");
INSERT INTO cam_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ke e hegi ne telé wo Iésu pie: «Geé te ju gahe pwo! E te juuju wo péroféta Isaia, na e pwaadeni a pwooti te Padué ne kowé. Be e tii pie: Lé te ju pipaunuéo ko pwolé wo lépwo apulie ce, kehe te e ité kojaéo ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Lé pwoiitihi me *pwoâpwailo tong kehe te piticenaado ne kon. Ana lé pacémuni ni apulie kon, ke te ni patén delé ni apulie, kehe time uce a pwooti tong.» Ésaïe 29.13 ");
INSERT INTO cam_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ke e pii mwo telé wo Iésu pie: «Geé caa patupwo ni pihuô te Padué. Ke geé caa tai engen ne ko ni pihuô tewé lépwo apulie. ");
INSERT INTO cam_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Geé tahi taabwon ni pihuô ten, ke geé bwo te wéihi nina te ni pihuô me ni bwomu tewé! ");
INSERT INTO cam_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Be e caa pii wo *Moosé pie: Go paciiti lu nyaa me caa tem. E pii mwo pie: Geé taunu pa apulie na e pipii me ta lu nyaa me caa ten. ");
INSERT INTO cam_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","«Kehe icehi ana wogewé, ke geé te pii te ni apulie pie, te wâé heme lé pii te lu nyaa me caa telé pie: “Nimung me é ne teu ace céiu naado me bépicani teu, kehe icehi ana time uce jan, be é caa pwo me âpipati iitihi te Padué.” ");
INSERT INTO cam_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","«Ke wonaa ana geé picaa telé, me lé tapi lu nyaa me caa telé! ");
INSERT INTO cam_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ke geé caaite ne he pule ni pwooti te Padué ko ni bwomu tewé! Ke hiwon mwo ni naado na wonaa na geé pwo mwo.» ");
INSERT INTO cam_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","É alecehen, ke e tode mwo ni apulie wo Iésu, ke e pii telé pie: «Lépwoli! Geé tabemiéo. Ke geé temehi ehi ana me é pii tewé: ");
INSERT INTO cam_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Time uce ana e taa pwo pa apulie ana e pwo me ta nang ne he pwahamii Padué. Kehe te icehi ana e wie mu ha a pwonimen ana e pwo me ta nang. { ");
INSERT INTO cam_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!}» ");
INSERT INTO cam_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","É mulang, ke e engen koja ni apulie wo Iésu, ke e âmwo pelen. Ke lé tahimwoeng wo lépwo acémun den ko a ocine na e mwo ko ju nebwén ko pii. ");
INSERT INTO cam_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ke e hegi ne telé pie: «Kona wogewé mwo, ke time uce téele jan me geé temehi anaa? Geé téne, te tice ace céiu naado celi e taabé mu pwomwo celi e pwo me ta pa apulie ne he pwahamii Padué. ");
INSERT INTO cam_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Be ni naado mu pwomwo, ke time lé uce taa ha a pwonimen. Be lé te ju taa ha a nan cehi, ke é alecehen, ke lé te wie mwo mu ha a één.» E habwii nelang wo Iésu pie, e caa ne me jan me nye wii ati mu ko ni wiinaado. ");
INSERT INTO cam_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","21","Ke e pii telé mwo pie: «Nina lé wie mu he pwonime ni apulie, ke te weengaa kuti, nina e ne me lé pwo ana ta: Lé pipule me ni apulie hauli; Lé bune; Lé taunuhi apulie; ");
INSERT INTO cam_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Lé pibune; Lé pwo me tai pwo delé ati ko ni naado; Lé pwotahinaado ne ko ni béén; Lé pigeti ni béén; Lé mulie hauli; Lé pitaaba; Lé cihe me ta ne ko ni béén; Lé pipaunulé. «Ke te tice aceli lé temehi ne ko nina wâé. ");
INSERT INTO cam_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ati ni ta naa, ke nina lé wie mu he pwonime pa apulie. Ke te weengaa kuti nina e pwo me ta ne kon ne he pwahamii Padué.» ");
INSERT INTO cam_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","É alecehen, ke e engen mu ha a duaan naa wo Iésu. Ke e â ha a duaan na e mwonuhi lupwo pwomwo ubwo Tir me Sidon. É nelang, ke e mu ha a céiu pwomwo, ke time uce nimen me lé temehi ne ni apulie pie e lang. Kehe icehi ana e piengen a jepule. ");
INSERT INTO cam_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","É mu ko anaa, na e piténe a pwooti kon wo ê céiu toomwo mu ha amu naa. Kehe time uce ê Juif, be ê piebehi lépwo Fénisi ha a province Siri. Ke e âbé céii Iésu, ke e tidihi jilin he pwahamiin, ke e pii ten pie: «Padaame, é ileko pie go pawiehi a duéé na e ko ê naîng.» ");
INSERT INTO cam_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ke e hegi ne ten wo Iésu pie: «Nye ne me lé wiinaado ânebun ne ni cuwo nahi ewa. Be time uce wâé heme nye pé ni wiinaado telé, me nye tahi taabwon ne te ni nahi wotaahen.» ");
INSERT INTO cam_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ke e pii ten wo êje pie: «Go te juuju, go Padaame. Kehe icehi ana ni nahi wotaahen mwo, ke lé te eni ni mewiinaado na lé patupwohi ne ni cuwo nahi ewa mu pwo taap.» ");
INSERT INTO cam_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ke e pii ten wo Iésu pie: «É mu ko a bwo hegi nen dem, ke jan me go mwojuia ngemwo pelem. Be e caa wie ali duéé mu ko ê naîm.» ");
INSERT INTO cam_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ke e mwojuia ngemwo ha a pomwa ten wo êje. Ke e ali êgi naîn, he e teko pule pwo ali apule. Be e caa wie ali duéé mu kon! ");
INSERT INTO cam_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","É mulang, ke e engen mu ha a piduaan ne Tir wo Iésu, beme e mwojuia ngemwo ticepwon ne Galilé. Ke e pitahagéi ngen ni duaan Sidon me Dix Villes. ");
INSERT INTO cam_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ke lé pébé céiieng pa apulie na huuhu nang ke bwéjé nang. Ke lé wâgo ko Iésu, ke lé ileeng pie: «Go ne lupwo im huîin, beme wâé nang!» ");
INSERT INTO cam_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ke e pééeng wo Iésu, ke lu â ité koja ni apulie. Ke e cine gaale ni mwodéin he ni pwojééne paje. Ke e pwo me titi ni mwodéin ko ni tabepwon, ke e ti ko a upehen. ");
INSERT INTO cam_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ke e alehede da he miiden, ke e pwo me taa nene kon, ke e pii te pali apulie pie: «Efata!» A bwopiinen pie: «Go tehiko!» ");
INSERT INTO cam_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ke te tehi kuti lupwo pwojéénen. Ke te wâé kuti ali upehen, ke caa jan me e cihe ehi. ");
INSERT INTO cam_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ke e pii wo Iésu te lépwona lé alihi anaa pie: «Geé nemwo pwojepule kon!» Kehe icehi ana me e ko pii anaa telé, ke lé bwo junihe pwojepule kuti kon, ne te ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Be lé te junihe téele, ke lé tai pii pie: «Geé alihi! Be te junihe wâé kuti ni naado na e pwo! Be e pwo me lé ténekenye ne nina bwéjé jélé; ke e pwo me lé cihe ne nina huuhu jélé.» ");
INSERT INTO cam_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","É ha a benaamwon naa, ke lé pitapitilé ne pele Iésu ni apulie na hiwon jélé. Ke tice wiinaado telé. Ke e tode ni acémun den wo Iésu, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«É te junihe pipwoééhe ni apulie ce, be caa cié ni tan denye me woélé, ke tice wiinaado telé. ");
INSERT INTO cam_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ke hemepie é pamwojuiélé, ke o tice niihelé nge he pwaaden, be hiwon lépwona lé âbé mu ité.» ");
INSERT INTO cam_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ke lé pii ten wo lépwo acémun den pie: «Genye o woté ko ace bwopwonen me lé wiinaado, ne éni ha a piticie?» ");
INSERT INTO cam_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ke e tahimwolé pie: «Kona niile ce pwoloa celi e pelewé?» Ke lé pii ten pie: «7 ni pwoloa.» ");
INSERT INTO cam_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ke e pii te ni apulie pie me lé tebwo. Ke e pé li pwoloa li 7, ke e pwo-olé te Padué. Ke e ebii, ke e ne te lépwo acémun den, ke lé patihi ne ko ni apulie. ");
INSERT INTO cam_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ke te pwo mwo ni cuwo ikua telé. Ke e pwo-olé te Padué, ke e pii te lépwo acémun den pie me lé patihi mwo. ");
INSERT INTO cam_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ke lé wiinaado dieli caa pwoluu jélé. Ke é alecehen, ke lé tai ni nehi wiinaado wo lépwo acémun den, ke e pwo 7 ni élele na oba. ");
INSERT INTO cam_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","É nge ha a 4000 ni apulie na lé wiinaado. Ke e pii telé wo Iésu pie, me lé mwojuia ngemwo pelelé. ");
INSERT INTO cam_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ke e taa pwo ong, weeng me lépwo acémun den. Ke lé â ha a céiu duaan na pii kon pie Dalmanouta. ");
INSERT INTO cam_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","É ha a céiu tan, ke lé tehenebé pele Iésu wo lépwo béé *Farasaio, be nimelé me lé pipwohuô ten. Ke lé pitaacunaado me weeng, ke lé pii ten pie: «Go habwii teme ace *pipwojunuun de Padué celi e kom.» Be nimelé me lé habwii pie time e uce penem ko a junuu Padué. ");
INSERT INTO cam_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ke pitaa nenehe Iésu, ke e pii pie: «É mu ko ade na geé tee cuwo ko ilehi ce pipwojunuun, wogewé ni apulie jenaa? É pii tewé a juuju pie: O te tice ace céiu pipwojunuun celi geé o mwo alihi.» ");
INSERT INTO cam_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ke e jéin ne kolé, ke e engen kojalé. Ke e taa pwo ong, ke lé gaale ko a céiu goon, weeng me lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Lé tuie gaale ko a céiu goon. Ke lé alihi wo lépwo acémun den pie, lé pineuhi me lé pé ce pwoloa. Be te ju céiu a nehi pwoloa telé. ");
INSERT INTO cam_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ke e pii telé wo Iésu pie: «Geé pipwocile a ‘nyaa te pwoloa’ te lépwo Farasaio, me a ‘nyaa te pwoloa’ te *Érode!» ");
INSERT INTO cam_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ke lé pipii telé wo lépwo acémun den pie: «Wieli é mu ko ana time genye uce pé pwoloa?» ");
INSERT INTO cam_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","E te téne wo Iésu, ke e pii telé pie: «É mu ko ade na geé tee cuwo ko cihe ko a pwoloa? Be he time geé uce téele temehi? Woté, mwo tee ko capuhi ni pwonimewé? ");
INSERT INTO cam_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pwo ni naamiiwé, ke he time geé uce alihi? Pwo ni pwojéénewé, ke he time geé uce téne? ");
INSERT INTO cam_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Kona time geé uce niimihi ali tan li é ebii li nim pwoloa ne te li 5000 apulie? Ke niile ni élele na geé paobaanihi ko ni nehi pwoloa?» Ke lé hegi ne ten pie: «12 ni élele.» ");
INSERT INTO cam_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«Ai, li 7 pwoloa ne te li 4000 apulie, ke a tan naa, ke niile ni élele li geé tai mwo?» Lé hegi ne ten pie: «7 ni élele.» ");
INSERT INTO cam_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ke e pii telé pie: «Kona time geé uce téele temehi kuti?!» ");
INSERT INTO cam_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Lé tuie nge ha a mwopopwaalé Betsaïda wo Iésu me lépwo acémun den. Ke wo lépwo apulie lang, ke lé pébé pana bwi nang. Ke lé ile Iésu me e pétaa kon. ");
INSERT INTO cam_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ke e pétaa ko a in wo Iésu, ke e pééeng wie mu ha a mwopopwaalé. Ke e ne a tabepwon ko ni naamii pali apulie. Ke e ne ni in ne huîin, ke e tahimwoeng pie: «Go ko alihi ce de?» ");
INSERT INTO cam_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ke e tehi lupwo naamiin wo pali bwi, ke e pii pie: «É ali ni apulie, kehe icehi ana me é alilé, ke lé pwohewii ni acuwo na lé engen.» ");
INSERT INTO cam_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ke e ne mwo lupwo in wo Iésu ne ko ni naamiin, ke e bwo niê ehi wo paje. Ke caa wâé nang, ke e caa alihi pwaatihi ni naado. ");
INSERT INTO cam_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ke e pii ten wo Iésu pie: «Go mwojuia ne mwo pelem, kehe go nemwo taamwo ha a mwopopwaalé.» ");
INSERT INTO cam_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Lé engen wo Iésu me lépwo acémun den, nge he ni amu na e mwonuhi a pwomwo ubwo Césaré-Filip. Ke é he lé mwo ko â he pwaaden, ke e tahimwolé pie: «Kona lé pii pie woté ne kong ne ni apulie? Lé pii pie woéo, ke woo?» ");
INSERT INTO cam_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ke lé hegi ne ten pie: «Lé pii ne ni béén pie, wogo ke wo *Ioane pa apipuu apulie. Ke lé pii ne ni béén pie, wo péroféta *Élia. Ke lé pii mwo wo lépwo béén pie, pa céiu béé ni péroféta ânebun.» ");
INSERT INTO cam_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ke e tahimwolé wo Iésu pie: «Ke kona wogewé ke?» Ke e hegi ne ten wo Pétéru pie: «Wogo ke pa *Mesia na go âbé mu pele Padué!» ");
INSERT INTO cam_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ke e te paciitihi kolé kuti me lé nemwo patemehi. ");
INSERT INTO cam_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","É alecehen, ke e pii beetihi te ni acémun den wo Iésu pie: «E bo tuie a benaamwon na é bo te nihe mu he ni picani hen, woéo pa Nahi Apulie. Be wo lépwo apihuô, me lépwo caa te lépwo *apwoâpwailo, me ni *dotéén ko patén, ke o te muhi telé kong. Ke lé bo pwo me é mele. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é o bo mulie cemwo.» ");
INSERT INTO cam_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","E pii pwaatihi ne telé a pwooti naa. Kehe icehi ana e todeeng nge ha a céiu duaan wo Pétéru, ke e tabuhi pééleeng. ");
INSERT INTO cam_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ke e biteeng wo Iésu, ke e ome lépwo acémun den. Ke e pééle Pétéru, ke e pii ten pie: «*Caatana, go engen mu he pwahamiing! Be time go uce niimihi pwohewii Padué, kehe go niimihi pwohewii ni apulie!» ");
INSERT INTO cam_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","É nelang, ke e tode ni apulie me lépwo acémun den wo Iésu, ke e pii telé pie: «Wo paceli nimen me e âbé céing beme pa acémun dong ke me e nemwo bo uce piniimieng mwo. Kehe wâé heme e canihi a *kuricé ten, ke me e âbé céing. ");
INSERT INTO cam_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Be wo pana nimen me celuimi a mulihen, ke e o patieden. Kehe wo pana e patieden a mulihen mu kong me a Pwooti Wâé, ke o celuimieng. ");
INSERT INTO cam_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","He ade ne te pa apulie, hemepie e hegi ati ni naamuu a bwohemwo, ke me e patieden a mulihen? ");
INSERT INTO cam_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kona ade aceli o jan me e ne, beme e pwocuhi mwo a mulihen? ");
INSERT INTO cam_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","«Be wo lépwo apulie jenaa, ke caa te lépwo apwo ne nina ta, ke time uce mwomwon jélé ne pele Padué. Ke wo lépwo béén, ke tanim jélé kong me a pwooti tong, ne ânebuhe ni apulie. Ke heme wonaa, ke woéo pa Nahi Apulie, ke o bo tanim jo kolé, hemepie geme bo âbé me ni *âcélo iitihi. É ha a tan naa, ke e bo habwii a bwo ubwo na a wâé ten wo pa Caa tong.» ");
INSERT INTO cam_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","E pii telé mwo wo Iésu pie: «É pii tewé a juuju pie: E bo ne éni a Mwametau ten wo Padué, ati ne ha a junuun. Ke pwo lépwo béén na élé éni jenaa, na lé o mwo te alihi anaa, ânebuhe ce bwo mele telé.» ");
INSERT INTO cam_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","É alecehe ni tan na 6, ke e pé Pétéru me Cang me Ioane wo Iésu, ke lé taa pwo a juwole na nihe ubwo, ke lé te pimu cehi lang. Ke pitaatééhi a bwo ali Iésu ne he pwahamiilé. ");
INSERT INTO cam_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ke â pwojo pwomelaa ni epwénen. Ke te tice pace apulie, éni pwo bwohemwo, celi jan ne kon, me pwo ace epwén celi pwojo pwohewii anaa. ");
INSERT INTO cam_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ke lé ali mwo *Élia me *Moosé lupwo alo péroféta ânebun na piubwo julu he lé ko picihe me weeng. ");
INSERT INTO cam_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Ke te nihe mwoti Pétéru me lupwo béén. Ke e pii te Iésu pie: «Pa apipune, te nihe wâé heme genye ko mu éni. Wâé heme geme pacuuli ce mwa mwaanu celi cié, beme a dem a céiu, ke me a de Élia a céiu, ke me a de Moosé a céiu.» E pii anaa, be caa time e uce temehi aceli me e pii, be te junihe mwotieng. ");
INSERT INTO cam_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ke e te âbé kuti a menii, ke e taluilé. Ke lé téne a pwocihe bé mu ha ali menii, na e pii pie: «Wo paje, ke pa Naîng na te céiu nang na te junihe eânimung den. Ke geé piténedeeng.» ");
INSERT INTO cam_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ke lé piniê aujenilé, kehe icehi ana caa te piwoélé cehi me Iésu. ");
INSERT INTO cam_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ke lé homwobé mu pwo juwole, ke e pii mwoiuhi telé wo Iésu pie: «Geé nemwo pii te ce béé apulie nina geé alihi, dieli ha ace tan celi é bo mulie cemwo mu ha amele, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ke lé piténedehi a pwocihe naa. Kehe icehi ana lé pitahimwolé pie: «He a bwopiine ace de, ana e pii pie: “É bo mulie cemwo mu ha amele”?» ");
INSERT INTO cam_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ke é alecehen, ke lé tahimwo Iésu pie: «Lé pii wo lépwo *dotéén ko patén pie: “Wo Élia pana me e mi âbé, ânebuhe pa *Mesia.” Ke he wonaa be woté?» ");
INSERT INTO cam_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ke e hegi ne telé wo Iésu pie: «Éa kuti, e mi âbé wo Élia, beme e pine ehi ni naado he ni amu nen. Ke lé caa tii mwo ne kong ne he ni tii iitihi pie, e bo mu he ni picani wo pa Nahi Apulie, ke lé bo téétieng. Wonaa mu ko ace de? ");
INSERT INTO cam_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","É pii tewé pie: E caa te âbé wo Élia, ke lé caa te pwo ten nina nimelé kon ne ni apulie. Be caa te tii ne he ni tii iitihi.» ");
INSERT INTO cam_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Me lé homwobé mu pwo juwole wo Iésu me lépwo acémun den na cié jélé, ke lé â too lépwo béé acémun béélé. Ke lé ali ni apulie na te junihe hiwon jélé, na lé mu aujenilé. Be lé picihe me lépwo dotéén ko patén. ");
INSERT INTO cam_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ke me lé ali Iésu ne ni apulie, ke lé te junihe téele. Ke lé téte nge céiieng, beme lé pwobwocu ten. ");
INSERT INTO cam_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ke e tahimwo lépwo acémun den pie: «Kona ace de celi geé ko pipii me woélé?» ");
INSERT INTO cam_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ke e hegi ne ten wo pa céiu mu ko ni apulie naa, ke e pii pie: «Pa apipune, é pwo me é pébé céiiko pa naîng. Be pwo duéé kon, ke e mu pwo me time e cihe. ");
INSERT INTO cam_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Pwo ni béé benaamwon na e mu pééeng, ke e tahieng ole pwo bwohemwo. Ke mu téte ni tabepwon, ke e mu piwii pecuwo, ke mu te ju mwoiu a één. Ke é ile lépwo acémun dem pie, me lé peni ali duéé, kehe icehi ana time uce jan me lé pwo.» ");
INSERT INTO cam_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ke e pii telé wo Iésu pie: «É te junihe pipwoééhewé wogewé ni apulie jenaa! Mwo te time geé uce téele céihi, be wogewé ni apwo mwoiu pun! O é dieli éniile celi é o mwo tee mu pelewé, ke me é mwo tee picani ne kowé? Geé pébé éni pa cuwo ewa naa!» ");
INSERT INTO cam_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ke lé pééeng bé. Ke me e ali Iésu na ali duéé, ke e te pwo me éjén ati kuti pali cuwo ewa. Ke e tupwo, ke e ngaulieng nge pwo bwohemwo. Ke téte ni tabepwon. ");
INSERT INTO cam_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ke wo Iésu, ke e tahimwo pali caa te pali cuwo ewa pie: «Tabuhi éniile celi wonaa nang?» Ke e hegi ne ten pie: «Te tabuhi ha a bwo mwo te wahin nang. ");
INSERT INTO cam_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ke a duéé naa, ke pwo ni benaamwon na e mu tahieng da pwo miû, ke é he tabe, beme e mele. Kehe go pipwoééheme me picani teme, hemepie te jan me go pwo.» ");
INSERT INTO cam_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ke e hegi ne ten wo Iésu pie: «É mu ko ade na go pii tong pie: “É hemepie te jan me go pwo”? Te tai jan ati ne ko pana e céihi!» ");
INSERT INTO cam_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ke e te toii kuti wo pali pie: «Uhuu! É céihi! Kehe icehi ana go picani tong, be time uce junihe ubwo a céihi tong!» ");
INSERT INTO cam_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ke e alihi wo Iésu pie, hiwon ni apulie na lé teko âbé ne kolu. Ke e te epin kuti ko peni ali duéé, ke e pii ten pie: «Wogo pa duéé na go pwo me time e cihe, ke me time e ténekenye, ke é pii tem pie: Go wie mu ko paje! Ke me time go bo uce taamwo kon!» ");
INSERT INTO cam_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ke e wiikau na ali duéé, ke e te pwo me éjén kuti pali cuwo ewa, ke e te wie kuti. Kehe icehi ana mepwo wo pali cuwo ewa, ke pwohewiin heme e caa mele. Ke hiwon ni apulie na lé pii pie e caa mele. ");
INSERT INTO cam_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kehe icehi ana e pétaa ole wo Iésu, ke e pwiieng. ");
INSERT INTO cam_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","É alecehen, ke e mwojuia ngemwo pwomwo wo Iésu. Ke me lé te pimu cehi me lépwo acémun den, ke lé tahimwoeng pie: «É ko ade na time uce jan me geme pwo me e wie ali duéé?» ");
INSERT INTO cam_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ke e hegi ne telé pie: «Te é ko a pwopwoiitihi te Padué cehi na o jan me nye pawie a bwo pwo duéé naa.» ");
INSERT INTO cam_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Lé wie mu ha a duaan naa wo Iésu me lépwo acémun den, ke lé pitahagéi epin a amu Galilé. Be time uce nime Iésu me lé temehi ne ni apulie pie e mu lang. ");
INSERT INTO cam_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Be e ko pacémunihi ne te lépwo acémun den pie: «O bo icuéo te ni apulie, woéo pa Nahi Apulie. Ke lé o imwiéo, ke lé o bo pwo me é mele; kehe é ha a béciéhe ni tan alecehen, ke é bo mulie cemwo mu ha amele.» ");
INSERT INTO cam_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kehe icehi ana time lé uce temehi ana e pii. Ke mwotilé me lé tahimwoeng kon. ");
INSERT INTO cam_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Lé tuie nge ha a mwopopwaalé Kapernaüm. Ke me lé taa ha a mwa, ke e tahimwolé wo Iésu pie: «Kona ace de celi geé ko pipii he li genye ko âbé?» ");
INSERT INTO cam_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Kehe icehi ana time lé uce hegi ne ten. Be he lé ko âbé he pwaaden, ke lé pitahimwolé pie: «Kona woo paceli piubwo nang ne ha awiemenye?» ");
INSERT INTO cam_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ke e tebwo wo Iésu. Ke e pwo me lé aujenieng, ke e pii telé pie: «É hemepie pwo pace céiu apulie celi nimen me pa bécéiuhen, ke wâé heme pa bénebwénen, ke me e pwo me piwahin nang, ke me e penem me de ati ni apulie!» ");
INSERT INTO cam_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ke e pé pa cuwo nahi ewa, ke e neeng ha awiemelé, ke e mwomwaaueng, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Wo pana e hegi ne he niing, pace cuwo nahi ewa pwohewii paje, ke e hegiéo. Ke wo pana e hegiéo, ke time e uce hegiéo cehi, kehe e hegi mwo pana e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ke e pii wo Ioane te Iésu pie: «Pa apipune, geme ali pa céiu apulie na e peni ni duéé ne he niim. Ke geme pii ten pie me e nemwo pwo. Be time uce pa béénye.» ");
INSERT INTO cam_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ke e hegi ne telé pie: «Geé nemwo tanyuueng! Be wo pana e pwo ni *pipwojunuun ne he niing, ke o pwocoon me e uce pii celi ta ne kong. ");
INSERT INTO cam_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Be wo pana time e uce âbédekenye, ke pa béénye. ");
INSERT INTO cam_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ke é pii tewé a juuju pie: Wo paceli e ne tewé ace mwoûdu ko ju tabe, be wogewé lépwo béé *Kériso, ke wo panaa, ke e bo hegi mwo ace cuhin.» ");
INSERT INTO cam_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«Go nemwo pwotahi a céihi te pa apulie na e céihi ne kong pwohewii a cuwo nahi ewa, be o te junihe ubwo a cuhinaado tem. Ke wâé heme cie ace pilehe péi ne ko a henem, ke o tahiko ole he jié! ");
INSERT INTO cam_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","«Mepie watihen a im me go pwo ana ta, ke go tahagéi. Be wâé heme go taa ha *a ju mulip pele Padué, hemepie te céiu a im. Kehe te junihe pwoééhem heme go te cile lupwo im, ke me tahiko ne ha a miû na te tice paceli jan me e taunuhi! { ");
INSERT INTO cam_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","É ha a duaan naa, ke time lé uce mele ne ni ûnele kolé, ke o tee éle a miû, ke o te tice anebwén kon.} ");
INSERT INTO cam_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","«Ke mepie watihen a am me go pwo ana ta, ke go tahagéi. Be wâé heme go taa ha a ju mulip pele Padué, hemepie te céiu a am. Kehe te junihe pwoééhem heme go cile lupwo am, ke me tahiko ne ha a miû! { ");
INSERT INTO cam_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","É ha a duaan naa, ke time lé uce mele ne ni ûnele kolé, ke o tee éle a miû, ke o te tice anebwén kon.} ");
INSERT INTO cam_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","«Ke mepie watihen a naamiim me go pwo ana ta, ke go tuu tahi taabwon. Be wâé heme go taa ha a *Mwametau te Padué, hemepie te céiu a naamiim. Kehe te junihe pwoééhem heme go tee cile lupwo naamiim, ke me tahiko ne ha a miû! ");
INSERT INTO cam_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","É ha a duaan naa, ke time lé uce mele ne ni ûnele kolé, ke o tee éle a miû, ke o te tice anebwén kon. ");
INSERT INTO cam_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","«Muko pétaapwo ni apulie, ke e bo ne telé a miû me a jié beme pétaabwon ni ta pwo telé. ");
INSERT INTO cam_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","A jié, ke a céiu naado na wâé, kehe mepie e patieden a nemen, ke he genye bo pwo nemenaado ko ace de? Wâé heme e mu kowé a jié, ke me geé mulie ne ha a wâé me ni bééwé.» ");
INSERT INTO cam_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","É mulang, ke e engen mu ha a duaan naa wo Iésu. Ke e pitahagéi a amu *Judé. Ke e gaale ko a céiu goo a éémwa Ioridano. Ke é ati he ni duaan na e mu â hen ke lé âbé ne ni apulie, ke lé mu aujenieng. Ke e pacémunilé ko a pwooti, be ana caa te cemang ne kon me e pwo. ");
INSERT INTO cam_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ke lé âbé céiieng wo lépwo béé *Farasaio. Ke lé pwo me lé pipwohuô ten, ke lé tahimwoeng pie: «Kona te pwo mwomwon de pa apulie ne he ni patén me e cibéé ê mwoden?» ");
INSERT INTO cam_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ke e uce tahimwolé wo Iésu pie: «Kona e pii pie woté ne he ni patén den wo *Moosé?» ");
INSERT INTO cam_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ke lé hegi ne ten pie: «Time e uce paciitihi wo Moosé ko pa apulie me e pamwojuia ê mwoden, ke wâé heme e pwo ace tii me pitahagéi piaten.» ");
INSERT INTO cam_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ke e pii telé wo Iésu pie: «Geé téne, e tii me dewé a patén naa, be te nihe mwoiu ni puniwé! ");
INSERT INTO cam_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Kehe icehi ana é ha atabuhi kon, he e tabuhi a bwohemwo wo Padué, ke e ne pa aiu me ê toomwo. ");
INSERT INTO cam_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","É mu ko anaa, ke e patupwo lu nyaa me caa ten wo pa aiu, beme lu pimu me ê mwoden. ");
INSERT INTO cam_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ke me wonaa, ke caa céiu julu. «É ko anaa, na é pii tewé pie: Caa time bo uce alo mwo lupwoce apulie, kehe caa te ju céiu julu. ");
INSERT INTO cam_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ke geé nemwo pineitééhi mwo nina e caa pineibuhi wo Padué.» ");
INSERT INTO cam_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ke lé engen kojalé wo Iésu me lépwo acémun den, ke me lé mwojuia ngemwo pwomwo, ke lé tahimwoeng mwo ko ali pitahagéi piaten. ");
INSERT INTO cam_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ke e pii telé pie: «Mepie e cibéé ê mwoden wo pace apulie, ke me e piaten mwo, ke pa apibune. ");
INSERT INTO cam_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ke hemepie e engen koja pa aiu hen ê toomwo beme e piaten mwo, ke ê apibune.» ");
INSERT INTO cam_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Lé âbé céii Iésu wo lépwo apulie, ke lé pébé céiieng ni cuwo nahi ewa, beme e ti kolé ke me adéilé. Kehe icehi ana lé cihe me ubwo ne kolé wo lépwo acémun den, ke lé pacuwolé. ");
INSERT INTO cam_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ke me e alihi anaa wo Iésu, ke time uce wâé ne kon, ke e pii telé pie: «Geé ne ni cuwo nahi ewa me lé âbé céiiéo. Geé nemwo pacuwolé, be a *Mwametau te Padué, ke a de ni apulie na lé pwohewii ni cuwo nahi ewa. ");
INSERT INTO cam_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Éa, é pii tewé a juuju pie: Wo pa apulie na time e uce hegi a Mwametau te Padué pwohewii ni cuwo nahi ewa, ke wo panaa, ke o pwocoon ne kon me e taa hen.» ");
INSERT INTO cam_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ke e te pé kuti li cuwo nahi ewa, ke e haailé, ke e ne ni in huîilé, ke e adéilé. ");
INSERT INTO cam_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","É he e mwo ko pwo me e engen wo Iésu, ke e téte tehenebé wo pa céiu apulie. Ke e â tidihi jilin he pwahamiin, ke e tahimwoeng pie: «Pa apipune, wogo pa apulie na te junihe wâé go kuti. He ade aceli me é pwo, beme é hegi a *mulie dieli mwo ne pele Padué?» ");
INSERT INTO cam_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ke e hegi ne ten wo Iésu pie: «Kona é mu ko ade na go pii kong pie, woéo ke pa apulie na wâé jo? Be te tice pace apulie celi wâé nang, kehe te icehi Padué. ");
INSERT INTO cam_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ke é ne ko a bwo tahimwohi nen dem ke go temehi ehi ni patén: Go nemwo taunuhi apulie; Go nemwo pibune; Go nemwo bune; Go nemwo pii ce pwooti celi ni gele ne ko ce béé apulie; Go nemwo pwo ce huô celi ta ne ko ce béén; Go paciiti lu nyaa me caa tem.» ");
INSERT INTO cam_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ke e hegi ne ten wo pali apulie pie: «Pa apipune, é caa te ténedehi kuti ninaa, ha a bwo mwo wahin jo.» ");
INSERT INTO cam_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ke e te ju omeeng wo Iésu, be te junihe eânimen den, ke e pii ten pie: «Go téne, te ju céiu cehi a naado na mwo tieden kojako: Go engen, ke go â icuhi ati ni dem, ke go pé ni cuhin, ke go ne te nina tice delé. Be me wonaa, ke o pwo ce dem ne pele Padué na e jeda he miiden. Ke nebwén, ke go âbé céing.» ");
INSERT INTO cam_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kehe me e téne anaa wo paje, ke te junihe piwahin nang, be te junihe pwo den. Ke e engen. ");
INSERT INTO cam_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ke wo Iésu, ke e ome lépwo acémun den na élé aujenieng, ke e pii telé pie: «Geé téne, wo lépwona te junihe pwo delé, ke te junihe pwocoon ne kolé me lé taa ha a Mwametau te Padué!» ");
INSERT INTO cam_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ke lé te junihe téele ko a pwocihe naa, kehe icehi ana e bwo pii telé mwo pie: «Lépwo bééng, uhuu! Te junihe pwocoon ne ko pace apulie me e taa ha a Mwametau te Padué. ");
INSERT INTO cam_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kona a chameau, ke o te jan ne kon me e taa ha a pwon ko a diti? Ûhu, pwocoon, kehe é pii tewé pie: Wo pa apulie na pwo den, ke mwo te junihe pwocoon ne kon me e taa ha a Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ke lé te junihe téele kuti wo lépwo acémun den, ke lé te pipii telé mwo pie: «Ke kona woo paceli jan me e piceluimieng?» ");
INSERT INTO cam_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ke e omelé wo Iésu, ke e pii telé pie: «Ana time uce jan ne ko pa apulie me e pwo, ke jan ne ko Padué. Be ati ni naado, ke te tai jan ne ko Padué.» ");
INSERT INTO cam_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ke e hegi ne ten wo Pétéru pie: «Wogeme, ke geme caa patupwo ati ni naado, beme geme âcéim!» ");
INSERT INTO cam_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ke e pii telé wo Iésu pie: «É pii tewé a juuju pie: Wo paceli e patupwo a pomwa ten, me ni âjiénen, me ni toomwo pwaadeniin, me lu nyaa me caa ten, me ni naîn, me apwoamu ten, watihen woéo me a Pwooti Wâé, ");
INSERT INTO cam_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ke o tabuhi jenaa, ke e bo hegi ce naado celi piwéden, celi te junihe ubwo ke hiwon. Ke o pwo ne ten ce pwomwo, me ce âjiénen, me ce ewa pwaadeniin, me ce nyaa me caa ten, me ce naîn, me ce apwoamu ten. Kehe e o bo hegi mwo ni picani me ni téé, wonaa mu ko ana pa apulie tong. Kehe é alecehen, ke o pwo den ko a mulie dieli mwo ne pele Padué. ");
INSERT INTO cam_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Te junihe hiwon nina lé ânebun jenaa, na lé o bo alece. Ke hiwon nina lé alece jenaa, na lé o bo uce ânebun.» ");
INSERT INTO cam_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","É he lé ko taa *Iérusaléma, ke e ânebun wo Iésu, ke lé alecehen wo lépwo 12 acémun den, me ni béé apulie. Ke â pinekepé ne telé, ke mwotilé. Ke e pé itéhi lépwo acémun den wo Iésu, ke e patemehi telé ni naado na e bo tuie ne kon: ");
INSERT INTO cam_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«Geé téne, genye o caa taa Iérusaléma. Ke é nelang he na o neéo, woéo pa Nahi Apulie, te lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén. Ke lé bo tautiéo die ko ace bwo taunuéo, ke lé o neéo te nina te tice céihi telé. ");
INSERT INTO cam_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ke lé o pihooniéo wo lépwonaa, ke lé o cumi ne kong, ke lé o ahiéo ko a bwaliiwota, ke lé o pwo me é mele. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é o mulie cemwo mu ha amele.» ");
INSERT INTO cam_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","É alecehen, ke lu âbé céii Iésu wo Cang me Ioane, lupwo naî Zébédé, ke lu pii ten pie: «Pa apipune, pwo a céiu naado na me gemu ilehi kojako, be nimemu me go ne temu.» ");
INSERT INTO cam_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ke e pii telu pie: «De aceli nimeu kon?» ");
INSERT INTO cam_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ke lu hegi ne ten pie: «É hemepie go bo mu ha a Mwametau tem me *a wâé tem, ke go patupwo ne temu, beme mu tebwo he ni piduaam: wo pa céiu ne pwo juim, ke wo pa céiu ne pwo eaamum.» ");
INSERT INTO cam_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ke e hegi ne telu pie: «Time geu uce temehi ana geu ko ilehi! Kona geu o te ûdu a tabe ko picani na é o ûdu? Kona te jan me geu mulie he ni picani pwohewiiéo?» ");
INSERT INTO cam_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ke lu hegi ne ten pie: «Éa, o te jan ne komu!» Ke e pii telu pie: «Éa kuti, geu o ûdu a tabe na é o ûdu, ke geu bo mulie he ni picani pwohewiiéo. ");
INSERT INTO cam_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kehe time uce woéo na é pihuô pie, woo paceli e o tebwo pwo a ing ne pwo jui, ke é pwo eaamung. Be te wo Padué na e caa te piwâamihi ni atebwo naa, me de ni béén na e caa te pipégalilé.» ");
INSERT INTO cam_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Me lé téne a pwocihe naa wo lépwo 10 acémun béélu, ke lé okéé ne ko Ioane me Cang. ");
INSERT INTO cam_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ke e todelé bé wo Iésu, ke e pii telé pie: «Geé temehi pie, é ne pele ni béén na time uce ni apulie te Padué, ke lé caaite ni apulie wo lépwo daame me lépwo apihuô. Ke lé pwo me piubwo jélé. ");
INSERT INTO cam_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kehe wogewé, ke geé nemwo pwohewiilé! Be wo pana nimen me piubwo nang ne hadeniiwé, ke wâé heme e pipwoeabwé tewé. ");
INSERT INTO cam_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ke wo pana nimen me e ânebun, ke o wâé heme pa céiu *apenem tice ja kon te ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Be woéo, pa Nahi Apulie, ke time é uce âbé beme lé pipwoeabwé tong. Kehe é âbé beme é pipwoeabwé te ni apulie, ke me é patupwo a mulihung, beme cuhi a bwo *celuimi ni apulie na hiwon jélé.» ");
INSERT INTO cam_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Lé tuie nge ha a mwopopwaalé Iériko wo Iésu me lépwo acémun den. Ke me lé wie mu ha a mwopopwaalé, ke te nihe hiwon ni apulie na lé âcéilé. Ke pwo pa bwi na e tebwo ko a jije pwaaden, na a niin pie Bartimé, pa naî Timé. Wo panaa, ke pa a-ile, be pana te tice den. ");
INSERT INTO cam_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ke é heme e téne pie e tuie wo Iésu, pa apulie Nazaret, ke e toii da pie: «Iésu, pa *Naî Davita, go pipwoééhung!» ");
INSERT INTO cam_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Hiwon ni apulie na lé pihaaeng, beme e nemwo cihe. Kehe icehi ana e bwo te junihe cihe da ko miiden kuti, ke e pii pie: «Pa Naî Davita, go pipwoééhung, ke go picani tong!» ");
INSERT INTO cam_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ke e â cuwo wo Iésu, ke e pii telé pie: «Geé todeeng.» Ke lé todeeng, ke lé pii ten pie: «Go mwoiu! Ke go cuwoda, be e todeko!» ");
INSERT INTO cam_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ke e te pwome tahi taabwon kuti a palito ten, ke e cuwoda, ke e âde Iésu. ");
INSERT INTO cam_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ke e tahimwoeng wo Iésu pie: «Ade aceli nimem me é pwo me dem?» Ke e hegi ne ten pie: «Pa apipune, me é niê mwo!» ");
INSERT INTO cam_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ke e pii ten wo Iésu pie: «Go engen, be caa wâé go mwo mu ko a céihi tem.» Ke e te niê kuti pwohewiin ânebun. Ke e âcéi Iésu nge he pwaaden. ");
INSERT INTO cam_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Lé âmwonuhi *Iérusaléma wo Iésu me lépwo acémun den. Ke lé tuie nge mwonuhi lupwo mwopopwaalé Bétani me Betfagé die pwo a juwole ko ni Olivier. Ke e mi ne ngen lupwo alo acémun den wo Iésu, ");
INSERT INTO cam_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ke e pii telu pie: «Geu â ha a mwopopwaalé na e ânebuhenye. Ke geu bo tooli nelang a nahi buriko na lé taaeng, na mwo te tice apulie celi lé mu tebwo huîin. Ke geu tuwoeng, ke geu pééeng bé. ");
INSERT INTO cam_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ke mepie lé tahimwokeu pie: “É mu ko ade na geu tuwoeng?”, ke geu hegi ne telé pie: “Nime Padaame kon. Ke e o te neeng bé.”» ");
INSERT INTO cam_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ke lu ân, ke lu tooli ali nahi buriko ne ko jije pwaaden, na lé taaeng mwonuhi a pomwa ko a céiu mwa. Ke lu tuwoeng. ");
INSERT INTO cam_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ke wo lépwona lé mu lang, ke lé tahimwolu pie: «He ade ana geu ko pwo? É mu ko ade na geu ko tuwo a nahi buriko naa?» ");
INSERT INTO cam_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ke lu hegi ne telé ko ali e pii telu wo Iésu, ke lé te nelu. ");
INSERT INTO cam_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ke lu pébé céii Iésu ali buriko. Ke lé ne ni epwén huîin wo lépwo acémun den, ke e bwo taa tebwo huîin wo Iésu. ");
INSERT INTO cam_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Hiwon ni apulie na lé talihi ni mwaanu telé nge pwo a pwaaden ânebuhe Iésu beme lé pipaunueng. Ke wo lépwo béén, ke lé ne ni dihe acuwo na mwo wamin na lé tahagéi nge he ni apwoamu. ");
INSERT INTO cam_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ke lépwona lé ânebuhe Iésu, me lépwona lé alecehen, ke lé tai toii da pie: «Osana! Pipwoun de Padué! *Adéi pa apulie na e âbé ne he nii Padaame! Psaume 118.26 ");
INSERT INTO cam_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Wâé hemepie adéihi a mwametau na e mwo ju tuie, a mwametau te *Davita, pa watihenye! Osana! me adéihi! Paunu Padué na e daaité!» ");
INSERT INTO cam_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ke e tuie nge Iérusaléma wo Iésu, ke e taa ha a *mwaiitihi, ke e alihi nina lé ko pwo nelang wo lépwona lé teko mu lang. Ke nebwén, ke lé â Bétani me lépwo 12 acémun den, be caa bwén. ");
INSERT INTO cam_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","É ha acaama hen, he lé wie mu Bétani, ke mene Iésu. ");
INSERT INTO cam_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ke e alihi mu ité a *majing, na te junihe bupwi. Ke e piâmwonuhi beme e alihi pie, te pwo ce acehin. Kehe me e piân, ke e te ju tooli cehi ni madihin, be time uce a benaamwon ko ni ace majing. ");
INSERT INTO cam_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ke e pii ten pie: «É jenaa, ke te tice paceli e bo wii mwo ce acehiko!» Ke lé téneeng wo lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lé tehene nge Iérusaléma. Ke e taa ha a mwaiitihi wo Iésu, ke e peni wie lépwona lé pwojenep nelang. Ke e pwii taabwon ni taap te lépwo ataatééhi mwani, ke ni atebwo te lépwo a-icuhi meni. ");
INSERT INTO cam_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ke e pii telé pie: «Geé nemwo pé da haulihi ce naado ne ha a mwaiitihi! ");
INSERT INTO cam_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Be e pii wo Padué ne he ni tii iitihi pie: A mwa tong, ke bo toii kon pie a mwo ko pwoiitihi me de ati ni amu. Kehe wogewé, ke geé ko pwo me ataduwo te lépwo abune!» ");
INSERT INTO cam_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wo lépwo caa te lépwo *apwoâpwailo me lépwo *dotéén ko patén, ke lé téne a jepule ko ana e pwo wo Iésu. Ke lé hane ace bwopwonen beme lé taunueng, be mwotilé kon. Be caa junihe hiwon ni apulie na lé â céiieng be lé picedihi nina e pii. ");
INSERT INTO cam_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ke é he babwén, ke lé wie mu ha ali pwomwo ubwo wo Iésu me lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","É ha acaama hen, ke lé â he pwaaden wo Iésu me lépwo acémun den, ke lé alihi ali éé majing li e piapwohi, he caa meiu ati, die ko ni waan. ");
INSERT INTO cam_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ke wo Pétéru, ke e niimihi ali e pii wo Iésu. Ke e pii ten pie: «Pa apipune, go alihi! E caa meiu ali acuwo li go piapwohi haabwén.» ");
INSERT INTO cam_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ke e pii wo Iésu telé pie: «Wâé heme geé céihi ne ko Padué! ");
INSERT INTO cam_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Be é pii tewé a juuju pie: O te jan me geé pii te a juwole ce pie: “Go pwiiko, ke go engen mulang, ke go téele ole he jié!”, ke e o pwo wo Padué! Kehe icehi ana wâé heme geé céihi pie, o tuie ana geé pii. Geé nemwo pwo me pinekepé ni pwonimewé! ");
INSERT INTO cam_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Anaa kuti a watihen me é pii tewé pie: Heme geé pwoiitihi me ilehi ace céiu naado, ke wâé heme geé céihi pie geé caa hegi. Ke me wonaa, ke e o ne tewé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","«Ke mepie geé cuwoda me geé pwoiitihi, ke wâé heme geé pineu mwo lépwona lé pwo tewé nina ta. Be me wonaa, ke wo Caa tewé na e jeda he *miiden, ke e o pineukewé mwo ko ni ta pwo tewé. { ");
INSERT INTO cam_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Kehe mepie time geé uce pineu lépwo béén, ke wo pa Caa tewé na e jeda he miiden, ke time e o uce pineukewé ko ni ta pwo tewé.}» ");
INSERT INTO cam_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Lé taamwo Iérusaléma wo Iésu me lépwo acémun den. Ke me e ko engen ha ali mwaiitihi wo Iésu, ke lé âbé mwonueng ne ni béé caa te lépwo apwoâpwailo, me lépwo dotéén ko patén me lépwo apihuô. ");
INSERT INTO cam_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ke lé tahimwoeng pie: «De ne ace pihuô me go pwo nina go ko pwo? Woo na e pahedeko?» ");
INSERT INTO cam_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ke e hegi ne telé pie: «Woéo mwo, ke é o mwo tahimwokewé ko a céiu naado. Ke mepie geé hegi ne tong, ke é bo pii tewé pana e ne tong a pihuô me é pwo ni naado naa. ");
INSERT INTO cam_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kona wo Ioane, ke e *pipuu apulie mu ko a pihuô te Padué, ai é mu ko a pihuô te ni apulie? Geé hegi ne tong!» ");
INSERT INTO cam_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ke lé te junihe picihe kon, ke lé pipii telé pie: «Mepie genye hegi ne ten pie: “É mu ko Padué”, ke e o pii tenye pie: “Ke é mu ko ade na time geé uce céihi ne ko nina e pii tewé wo Ioane?” ");
INSERT INTO cam_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ke mepie genye hegi ne ten pie: “É mu ko ni apulie”, ke ade aceli e o tuie ne konye?» Be mwotilé ko ni apulie na lé caa ju céihi ati pie, wo Ioane, ke pa péroféta te Padué. ");
INSERT INTO cam_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ke é mu ko anaa, ke lé hegi ne te Iésu pie: «Meniing, time geme uce temehi.» Ke e pii telé pie: «Ke woéo mwo, ke time é o uce pii tewé pie, he wooélé na e ne tong a pihuô me é pwo nina é ko pwo.» ");
INSERT INTO cam_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","E pacihe ni apulie wo Iésu, ke e piuti telé ni ocine: «E bwo mu wo pa eapwihi a ni tabe megele. Ke e bwo cemi apwoamu ten, ke e bwo pwo a aba, beme a babé kon. Ke e ini a pwon, beme acaai ace tabe megele, ke me e bo céi ne hen a tabe hen. Ke e bahi a mwa na te junihe bwali da ko miiden, beme a mwowéa ko ali ni éé tabe megele. Ke nebwén, ke e niimihi pie me e mwo â pitabée ha ace céiu amu, ke e pwocuhi ni béé apulie, beme lé wéihi ali ni tabe megele ten, ke e engen. ");
INSERT INTO cam_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","«Pwo ni wole alecehen ke tuie nge ha a benaamwon ko tabwo ace tabe megele. Ke e ne ngen pa céiu apenem den, beme lé ne ten ace den mu ko ali ni éé tabe megele ten. ");
INSERT INTO cam_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Kehe icehi ana lé pitatieng, ke lé neeng ngemwo, he te tice celi lé ne ten. ");
INSERT INTO cam_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ke é mulang, ke e ne ngemwo pa céiu apenem den. Ke lé piahieng ko péi, ke lé tanahi a punin, ke lé piciheta ne kon. ");
INSERT INTO cam_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","«Ke nebwén, ke e ne ngemwo pa béciéhe ni apenem den, kehe icehi ana lé taunueng. Ke hiwon ni béé apenem den na e nelé ngemwo, ke lé piahi ni béén, ke lé taunu ni béén. ");
INSERT INTO cam_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","«Ke nebwén, ke caa te tice apulie celi me e nelé ngen, ju nehi céiu pa ju naîn, na te nihe eânimen den. Ke e neeng nge céii lépwo awéa ko ali ni éé tabe megele. Be e piniimihi pie, lé o paciitieng, be te pa naîn. ");
INSERT INTO cam_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","«Kehe icehi ana lé pipii telé pie: “Geé téne, te weengaa kuti pana e bo eapwihi ali ni tabe megele ha ace céiu tan. Wâé heme nye ju taunueng, beme bo a denye ali ni tabe megele!” ");
INSERT INTO cam_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","«Ke lé imwieng, ke lé taunueng, ke lé pé a één, ke lé tahi ne ité koja ali apwoamu.» ");
INSERT INTO cam_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ke wo Iésu, ke e tahimwo lépwona lé ko tabemieng pie: «Ke e bo pwo de wo pali eapwihi ali ni tabe megele? E bo âbé, ke e bo taunu li apulie na ta jélé. Ke e bo uce ne te ce béén ali ni tabe megele, beme lé bo uce wéa kon. ");
INSERT INTO cam_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kona time geé uce pine ana tii ne he ni tii iitihi? Ali péi li lé tahi taabwon wo lépwo abahi mwa, ke te anaa kuti a ju paamwa. ");
INSERT INTO cam_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Be te ni âpihuô te Padaame. Ke nye téetihi a wâé ten, na nye caa ko alihi!» Psaume 118.22−23 ");
INSERT INTO cam_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ke he lé téne anaa wo lépwo apihuô te lépwo *Juif, ke lé hane me lé imwi Iésu. Be lé te temehi pie, e ko pwo-ocine ne kolé. Kehe icehi ana mwotilé, be hiwon ni apulie na wâé telé nang. Ke lé neeng, ke lé engen. ");
INSERT INTO cam_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Wo lépwo caa te pwoiitihi, ke nimelé me lé pipwohuô te Iésu, ke lé ne nge céiieng ni *Farasaio, ke ni apulie mu pele *Érode beme lé tahimwoeng ko ce naado. Be lé hane pwaaden beme lé pipé ne kon, mu ko ace bwo hegi nen den. ");
INSERT INTO cam_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ke lé â pii ten pie: «Pa apipune, geme temehi pie go pii a juuju. Ke time uce mwotiko ko ni apulie, ke time go uce pipwoinen ne kolé, kehe go te patemehi ati ni naado na nime Padué me genye pwo. Ke anaa kuti ana nimeme me geme tahimwoko pie: He te wâé heme nye pwocuhi puni apulie te pa daame he lépwo Roma? Ai time uce wâé?» ");
INSERT INTO cam_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ke e te temehi wo Iésu pie lépwo apulie naa, ke lépwo agele, ke e pii telé pie: «É ko ade na geé pihaamiéo? Geé cuwoteeke habwii tong ace céiu mwani péi.» ");
INSERT INTO cam_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ke lé ne ten a mwani péi. Ke e pii telé pie: «A démee, ke a nii-î ana e pwo a mwani ce?» Ke lé hegi ne ten pie: «A de pa daame he lépwo Roma.» ");
INSERT INTO cam_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ke e pii telé wo Iésu pie: «Ke caa wâé, ke geé ne te pa daame nina te ni den, ke geé ne te Padué nina te ni de Padué.» Ke lé nihe téetihi a bwo hegi nen den. ");
INSERT INTO cam_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lé âmwobé céii Iésu wo lépwo béé *Saducéen. Woélé, ke te a céiu dihe pwoiitihi te lépwo Juif na time lé uce céihi pie, lé o mulie cemwo wo lépwo amele. Lé âbé too Iésu ke lé pwo me lé habwii pie lé juuju ke lé tahimwoeng pie: ");
INSERT INTO cam_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Pa apipune, e caa tii me denye wo *Moosé ne he ni patén pie: Hemepie e mele wo pace céiu apulie celi te tice naîn, ke wâé heme e pé ê depweleten wo pa ciéén me lu piaten. Be me wonaa, ke me bo pwo ce piebehi pa amele.» ");
INSERT INTO cam_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","«Ke te wâé. Kehe go cuwoteeke niimihi ani: Pwo lépwo pwénaâjién na 7 jélé, ke e piaten wo pa cuwolé, kehe icehi ana e mele he mwo te tice naîn. ");
INSERT INTO cam_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ke wo pa béalohen, ke lu piaten me êgi depwele, kehe icehi ana e te mele mwo wo paje, he te tice naîlu. Ke te piwien ne ko pa béciéhen. ");
INSERT INTO cam_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ke te wonaa mwo ne ko lépwoli 7 jélé. Be lé te tai mele, ke he te tice naîlé. Ke é alecehelé ati, ke e bwobe mele wo êgi toomwo. ");
INSERT INTO cam_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ke go ko pii pie lé bo mulie cemwo ne ni amele ha ace céiu tan. Ke hemepie wonaa, ke o bo wooélé mu hadeniilé celi bo pa aiu he ê toomwo naa, ha a benaamwon naa? Be caa te tai lépwo aiu hen ati! Ke go cuwoteeke hegi!» ");
INSERT INTO cam_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","E hegi ne telé wo Iésu pie: «Geé pipweéo, be time geé uce temehi ni tii iitihi, me a junuu Padué. ");
INSERT INTO cam_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Be mepie lé mulie cemwo ne ni amele, ke time lé o bo uce piaten mwo, kehe lé mulie pwohewii ni *âcélo ne pele Padué. ");
INSERT INTO cam_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","«Geé ko tahimwoéo ko a bwo mulie cemwo mu ha amele. He time geé uce pine ne he ni tii te Moosé a jepule ko ali nahi acuwo li e éle kon ali miû? Be é nelang he na e pii ten wo Padué pie: Woéo Padué he *Abérama, ke Padué he Isaaka, ke Padué he Iakobo. ");
INSERT INTO cam_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","A bwopiinen pie, lé teko tai mulie pele Padué! Be time uce Padué he ni amele, kehe Padué he nina lé mulie! Geé te nihe pipweéo!» ");
INSERT INTO cam_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","É he lé mwo ko picihe, ke e tabemilé wo pa céiu *dotéén ko patén, ke e alihi pie, e te ju hegi ehi ne te lépwo Saducéen wo Iésu. Ke e âbé mwonueng, ke e tahimwoeng pie: «Kona ade patén celi e piwéden na ati he ni patén?» ");
INSERT INTO cam_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ke e hegi ne ten wo Iésu pie: «Weengi: Geé téne wogewé lépwo *Isaraéla! Wo Padaame Padué, ke te weengaa kuti pa ju Daame henye, na te céiu nang! ");
INSERT INTO cam_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ke go pwo me eânimem den ati ne ha a ju pwonimem, me a mulihem, me a bwo niimihinaado tem, me a niihem. ");
INSERT INTO cam_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","«Ke weengi a béalohe ni patén: Go pwo me eânimem de ni béén, pwohewii a bwo pieânimem dem. Be te tice ace céiu patén, celi piwéden koja lupwo patén naa.» ");
INSERT INTO cam_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ke e pii ten wo pa dotéén ko patén pie: «Éa kuti! Te junihe a juuju, go pa apipune, ana go ko pii! Be wo Padaame, ke te weeng kuti pa ju Dué henye! Ke te tice mwo pace céiu! ");
INSERT INTO cam_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ke wâé heme eânimenye ten mwo ati ne he ni ju pwonimenye, me ni pitemang, me ni niihenye. Ke wâé mwo, heme eânimenye mwo te ni béén pwohewii a bwo pieânimenye tenye. Te junihe a junaado ana koja ni *âpwailo te Padué, me ni béé âpipati.» ");
INSERT INTO cam_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ke e alihi wo Iésu pie e hegi ha a pitemang den, ke e pii ten pie: «Time uce wogo ité koja a *Mwametau te Padué.» Ke caa mwoti ni apulie me lé tahimwo Iésu ko ce béé naado. ");
INSERT INTO cam_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","É he e ko pacémunilé ne ha a *mwaiitihi wo Iésu, ke e pii te nina lé ko tabemieng pie: «Lé pii wo lépwo dotéén ko patén pie, wo pa *Mesia, ke pa piebehi *Davita. Te a juuju anaa, kehe icehi ana te junihe ubwo nang koja Davita. ");
INSERT INTO cam_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Be te wo Davita na e pii anaa he caa ju tilieng na a *Jenen Iitihi, be e pii pie: Pwooti te Padaame Padué, na e pacihe pa daame hung: “Go âbé tebwo éni pwo a juing. É ne tem a pihuô, ke o pipaunuko dieli mwo. É pwo me go caaite nina lé pipwopa ne kom.” Psaume 110.1 ");
INSERT INTO cam_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«Ke me e ko pii wo Davita pie: Padaame hung, ke a bwopiinen pie, wo pa Mesia. Ke me wonaa, ke ade ace watihen me geé niimihi pie, wo pa Mesia, ke time uce pace apulie celi piubwo nang koja Davita?» Lé tabemi Iésu ni apulie na hiwon jélé, ke lé te junihe pipwodéén. ");
INSERT INTO cam_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ke e pacémunilé mwo pie: «Geé pipwocile! Geé nemwo pipwohewii lépwo dotéén ko patén! Be te junihe wâé telé me lé engen he ni epwén na bwali. Ke wâé telé heme nye tee pwobwocu telé, me pipaunulé ne he pwahamii ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lé te hane ni atebwo ânebun, ne he ni *mwotapitihi, ke é ne mwo he ni apiwiinaado na ubwo. ");
INSERT INTO cam_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ke lé te nihe pwo ni jame pwoiitihi, beme nye o niimihi pie ni apulie na wâé jélé. Kehe icehi ana me lé ko wonaa, ke lé pé ati koja ni depwele ni delé! Ke te é mu ko anaa kuti, na o bo ne telé a cuhinaado na te junihe ubwo koja ni cuhinaado te ni béén.» ");
INSERT INTO cam_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","É mulang, ke e taa ha a mwaiitihi wo Iésu. Ke e tebwo he bebenihe a duaan na lé mu ne mwani hen me de a mwaiitihi. Ke e ali nina lé ko ne. Ke te pwo ni béén na te nihe pwo delé, ke lé ne ni mwani na te nihe hiwon. ");
INSERT INTO cam_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ke e tuiebé ê depwele na te tice den, ke e ne lupwo cuwo nahi mwani péi. ");
INSERT INTO cam_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ke e tode lépwo acémun den wo Iésu, ke e pii telé pie: «É pii tewé a juuju pie: Ê depwele ce tice naamuun, ke e ne nina te junihe piwéden koja ni béén. ");
INSERT INTO cam_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Be lé ne ni mwani na pikaoole mu ko ni cuhilé. Ke hemepwo weeng, ke te tice den. Kehe icehi ana e te ne ati ni mwani na jan me e mulie kon.» ");
INSERT INTO cam_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","É alecehen, ke e wie mu ha a *mwaiitihi wo Iésu. Ke e âbé céiieng wo pa céiu béé lépwo acémun den, ke e pii ten pie: «Pa apipune, te junihe wâé a mwa ce, ke ni péi ko a aba kon!» ");
INSERT INTO cam_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ke e pii ten wo Iésu pie: «Go te alihi ni pilehe mwa ce, be o time e bo uce mu éni mwo ace céiu péi pwo ace céiu mwo. Be ati ke o bo tai tanahi taabwon.» ");
INSERT INTO cam_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","É alecehen ke e tebwo pwo a juwole ko ni Olivier wo Iésu ne he bebenihe a mwaiitihi. Ke lé âbé mwonueng wo Pétéru me Cang, me Ioane, ke wo André. Ke te piwoélé cehi me weeng, ke lé tahimwoeng pie: ");
INSERT INTO cam_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«He éniile celi e o bo tuie ana go ko pii? Ke o ade ace inenaado kon, me geme o temehi pie, caa é mwonu, ke o bo tuie ni naado naa?» ");
INSERT INTO cam_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ke e pii telé pie: «Geé pipwocile, beme geé nemwo pipweéo! ");
INSERT INTO cam_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Be o hiwon nina lé o âbé heme lé pé a niing. Ke lé o bo pii tewé pie: “Woéo pa *Mesia!” Ke lé o pipwohuô te ce apulie celi hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ke me geé téne heme lé cihe ko ce pa celi e mwonu, ai e ité, ke geé nemwo pwo me mwotikewé! Be e o mi tuie ninaa, kehe icehi ana time uce téele a pwonehi a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","«Be a céiu amu, ke e bo pipwopa me a céiu amu. Ke a céiu mwametau, ke e bo pipwopa me a céiu mwametau. Ke o bo pwo ni penem bwohemwo ne he ni pétaapwo piduaan, ke ni menele na ubwo. É ne he ni bwomunen naa, ke o pwohewii ni bécéiuhe picani ko a piâbeele ewa.» ");
INSERT INTO cam_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«Kehe wogewé, ke geé pipwocilekewé, be lé bo péékewé nge he ni mwopitautinaado. Ke lé bo ahikewé ne he ni *mwotapitihi. Ke lé bo teuukewé nge he pwahamii ni gupéno me ni daame, beme lé tautikewé, wonaa mu kong. Wonaa beme ne tewé, beme geé cihe telé kong. ");
INSERT INTO cam_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Be wâé heme mwo mi patemehi a Pwooti Wâé ati nge he ni amu. ");
INSERT INTO cam_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","«É heme lé bo péékewé ngen me tautikewé, ke geé nemwo pwo me gia gewé, ke geé nemwo mi pihane celi me geé bo pii. Be geé te ju pii cehi celi o bo ne tewé ha a inetéale naa. Be time uce wogewé celi geé o cihe, kehe a *Jenen Iitihi na e bo cihe. ");
INSERT INTO cam_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","«É ha a benaamwon naa ke wo pa céiu apulie, ke e o bo ne pa âjiénen beme taunueng. Ke e o wonaa mwo wo pa caa te ewa ne ko pa naîn. Ke ni ewa, ke lé bo cuwode ni nyaa me caa telé, beme lé taunulé. ");
INSERT INTO cam_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","«Lé o téétikewé ne ni apulie ati, wonaa mu ko a niing. Kehe wo pana e cumang die ha anebwén ko a mulihen ke e bo celuimieng wo Padué.» ");
INSERT INTO cam_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ke geé o bo alihi a naado na ta, na e bo tuiebé ne ha a duaan na time uce ace amu nen: ali naado li e pwotahi ati ni naado, na te nihe mwakile nang, ke muhi tenye kon.» Wo paceli e pine anaa, ke wâé heme e temehi beme e bo cihe kon! «Ke é ha a benaamwon naa, ke wâé heme lé cela da pwo ni juwole ne nina lé mu *Judé! ");
INSERT INTO cam_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ke wo pana e âoté pwomwo, ke e nemwo taamwo hane ce naado mu ha a mwa ten. ");
INSERT INTO cam_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ke wo pana e mu ha apwoamu, ke e nemwo mwojuia ngemwo pelen, me e pé ce epwénen. ");
INSERT INTO cam_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Au, mwolihi! Be é he ni tan naa, ke o pwoééhe ni toomwo na pigiaa jélé, me nina lé mwo paditihi ewa. ");
INSERT INTO cam_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","«Ke geé pwoiitihi te Padué pie, me time e uce tuie ne kowé ni naado naa ha a benaamwon na ta-amu hen! ");
INSERT INTO cam_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Be é ha a benaamwon naa, ke lé o mu he ni picani ne ni apulie. Be mwo te tice pace apulie celi e caa mu he ce picani celi wonaa, tabuhi ha a tan na e tabuhi ati ni naado wo Padué, dieli jenaa. Ke o te tice mwo pace céiu apulie celi e o bo mu he ce picani celi wonaa. ");
INSERT INTO cam_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","«É hemepie time e uce niimihi wo Padué pie, me e pineole a jéhi ni tan naa, ke wieli me o te tice pace céiu apulie, celi e o celuimi a mulihen! Kehe icehi ana e te niimihi pie me e pineole, wonaa mu ko nina e caa pipégalilé.» ");
INSERT INTO cam_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«Ke mepie e pii tewé wo pace céiu apulie pie: “Geé alihi! E éni wo pa Mesia!” ai “E ha a duaan ce!”, ke geé nemwo céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Be lé o bo tehenebé ce ‘mesia’ me ce ‘péroféta’ celi ni agele. Ke lé o pwo ce *pipwojunuun celi lé o téetihi ne ni apulie, beme a bwopwonen me lé pipwohuô telé. Ke lé o te hane mwo me lé pipwohuô te nina e caa pipégalilé wo Padué. ");
INSERT INTO cam_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ke me wonaa, ke wogewé, ke geé o pipwocile! Be é caa mi patemehi tewé ni naado na o bo tuie!» ");
INSERT INTO cam_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«É he ni tan naa, ke lé o te junihe mu he ni picani ne ni apulie. Ke é alecehe anaa, ke: O time e uce niê na a téale. O bwén ne ha a wole. ");
INSERT INTO cam_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Lé o bo tupwo ne ni ceni. O éjén ni pipwojunuun he miiden. Ésaïe 13.10; 34.4 ");
INSERT INTO cam_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","«Ke nebwén, ke lé o bobe aliéo, woéo pa Nahi Apulie, heme é âbé he ni nii, ne ha ati a junuung me a bwo ubwo jo. ");
INSERT INTO cam_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ke é o pawiebé ni *âcélo, beme lé neibu nina é caa pipégalilé. Ke lé o taineibulé ne ha a céiu behi amu, die ha a céiu behin, pitihi a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«Wâé heme geé temehi a inenaado ko a *majing. Be, me e tile, ke geé caa temehi pie, caa é mwonu a cim naado. ");
INSERT INTO cam_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Wonaa mwo heme geé alihi pie, e caa ko tuie li é caa pii, ke geé o temehi pie, o caa pacuwohi ati. ");
INSERT INTO cam_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ke é pii tewé a juuju pie: Time o uce bwolihi. Be lé o mwo te alihi anaa ne ni béé apulie jenaa, ânebuhe ace bwo mele telé. ");
INSERT INTO cam_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Be o tieden a miiden me a bwohemwo, kehe o time uce tieden a pwooti tong.» ");
INSERT INTO cam_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«Te tice pace apulie, celi e o temehi ace tan me ace inetéale, celi o tuie hen ni naado naa. Te tice paceli e temehi, heme woéo pa Naîn, heme ni âcélo te Padué. Kehe te wo Caa cehi, na e temehi. ");
INSERT INTO cam_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Geé pipwocile, ke geé nemwo tee pule! Be time geé uce temehi ace benaamwon celi e o tuie hen ninaa. ");
INSERT INTO cam_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Be o pwohewii ne ko pa apulie na e engen mu ha amu ten. Ke e ne te lépwo apenem den a pihuô ne ko ati ni naamuun die ko a pomwa ten. Ke e pipatihi ne kolé ni pétaapwo penem delé. Ke e pii te pa awéihi pomwa pie: “Go mu ke go tee ûmiê.” ");
INSERT INTO cam_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","«Ke te piwien ne mwo kowé. Wâé heme geé tee ûmiê! Be time geé uce temehi ace benaamwon celi e o tuie mwobé hen wo pali eapwihi pwomwo. Be wieli é ko a babwén, ai é ha awieme bwén, ai é heme ko to a ja, ai é ko acaama. ");
INSERT INTO cam_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ke hemepie e pwome tehenebé, ke o time uce wâé heme e tookewé heme geé tee ko pule! ");
INSERT INTO cam_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ana é pii tewé, ke a pwooti me de ni apulie ati: Wâé heme geé tee ûmiê!» ");
INSERT INTO cam_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nehin alo ni tan, ke o cuwo lupwo tan ubwo te lépwo *Juif: a tan ko a *Pacika a céiu, ke a tan na lé eni a pwoloa na te tice nyaa ten. Ke nime lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén, me lé taunu Iésu. Ke lé pihane ace bwopwonen beme lé pipwohuô ten, me lé imwieng neduwohi. ");
INSERT INTO cam_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ke lé pipii telé pie: «O time uce wâé heme nye imwieng ha a piwiinaado ubwo, ne he pwahamii ni apulie, be koli lé bo okéé.» ");
INSERT INTO cam_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","É ha a benaamwon naa, ke e mu Bétani wo Iésu, ha a mwa te Simon, pa katia. É he lé mwo ko wiinaado, ke e tuiebé ê céiu toomwo, imi a mwotabe péi na te junihe wâé, na oba ko tabe ûde na te junihe ubwo a cuhin. Ke e taii ali mwotabe, ke e cepulicéihi ali tabe ûde ne pwo puni Iésu. ");
INSERT INTO cam_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ke me lé alieng wo lépwona lé mu lang, ke te nihe time uce wâé telé, ke lé pipii telé pie: «Éé! E te nihe pihoonihi a tabe ûde ne. ");
INSERT INTO cam_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Be pwo million ko a cuhin! Ke é ko ade na time e uce icuhi, ke me genye ne a mwani te nina tice delé?» Ke lé te nihe cihe ne ko êgi toomwo. ");
INSERT INTO cam_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ke e pii telé wo Iésu pie: «Geé neeng! É mu ko ade na geé ilieng? E pwo ana nihe wâé ne kong. ");
INSERT INTO cam_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Be o tee élé pelewé wo lépwona te tice delé, ke heme nimewé, ke te jan me geé bo te pwopweehi ne kolé. Kehe woéo, ke time nye uce cuwo ko pimu ibu. ");
INSERT INTO cam_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ênaa, ke e pwo ana jan me pwo. Be é he e ne a tabe ûde ne ko a ééng, ke e caa mi pipwopweehi cawi a bwo ole tong he pwon. ");
INSERT INTO cam_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ke é pii tewé a juuju pie: É heme bo pipii beetihi a Pwooti Wâé ne he ni piduaan ati ne pwo a bwohemwo, ke lé bo tee piuti mwo a jepule ko ana e pwo ê toomwo ce, beme tee pipaniimieng.» ");
INSERT INTO cam_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wo Judas Iscariot, pa céiu béé lépwo 12 *apostolo, ke e â too ni caa te lépwo apwoâpwailo. Ke e pii telé pie: «É bo ne Iésu tewé.» ");
INSERT INTO cam_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ke te nihe piwâénimelé, ke lé pii ten pie: «Geme bo ne ce mwani tem hemepie go pwo.» Ke e pihane ace pwaaden me e icu Iésu telé. ");
INSERT INTO cam_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","E caa tuie a bécéiuhe tan ko ‘pieni pwoloa tice nyaa ten’, a tan na nye taunuhi a nahi muto me de a Pacika. Ke lé pii te Iésu wo lépwo acémun den pie: «Geme o â piwâam ko a wiinaado ko a Pacika. Kona é wé he celi nimem me genye piwiinaado nelang?» ");
INSERT INTO cam_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ke e ne ngen lupwo alo mu kolé, ke e pii telu pie: «Geu â ha a pwomwo ubwo, ke o pitapitikewé me pa apulie na e pé a mwotabe, ke geu âcéin. ");
INSERT INTO cam_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ke me e â taa ha a mwa, ke geu pii te pa eapwihin lang pie: “E tahimwohibé wo pa apipune teme pie: ‘E wé ace nemwa celi me geme o pieni ibuhi ne hen a wiinaado ko a Pacika, me ni béé acémun dong?’” ");
INSERT INTO cam_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","«Ke e o habwii teu a céiu nemwa na e ko miiden, a nemwa ubwo na caa pipwopweehi. Ke geu piwâamihi a wiinaado tenye nelang.» ");
INSERT INTO cam_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ke lu â ha a pwomwo ubwo, ke lu te tai tooli pwohewii ana e pii telu wo Iésu. Ke lu piwâamihi a wiinaado ko Pacika. ");
INSERT INTO cam_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","É he babwén, ke lé tuie wo Iésu me lépwo 12 apostolo ten. ");
INSERT INTO cam_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ke lé tebwo, ke lé wiinaado. Ke é he lé ko wiinaado, ke e pii telé wo Iésu pie: «É pii tewé a juuju pie: E bo pi-icuéo wo pa céiu bééwé, pana nye te piwiinaado ibu me weeng.» ");
INSERT INTO cam_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ke te piwahin jélé, ke lé muko pétaapwo tahimwoeng pie: «He time uce woéo?!» ");
INSERT INTO cam_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ke e pii telé pie: «Wo pa céiu bééwé, wogewé lépwo 12 apostolo, pana gemu tai pétaa ole ha a tam. ");
INSERT INTO cam_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","É bo mele, woéo pa Nahi Apulie, pwohewii ana e caa pii beetihi ne ni tii iitihi. Kehe wo pa apulie na e pi-icuéo, ke o te junihe pwoééhen. Au, mwolihi! Be wo panaa, ke wieli me o te wâé ne kon hemepie time e uce ko âbeele!» ");
INSERT INTO cam_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ke é he lé ko piwiinaado ibu, ke e pé a pwoloa wo Iésu, ke e pipwo-olé te Padué. Ke e ebii, ke e pwopatihi ne ko lépwo acémun den, ke e pii telé pie: «Geé pé, be ani ke a ééng.» ");
INSERT INTO cam_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ke é alecehen, ke e pé a mwoûdu ko tabe megele. Ke e pwo-olé te Padué, ke e ne telé. Ke lé tai ûdu. ");
INSERT INTO cam_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ke e pii telé pie: «Ani ke a cewéhung na e o caa tée me de ati ni apulie. Be a pipwoâpwailo na e pacuwohi a *piapwo na e pwo wo Padué pie e ne a péém ne ha awiemelé me weeng. ");
INSERT INTO cam_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ke é pii tewé a juuju pie: O caa time é bo uce ûdu mwo ace tabe megele ne éni pwo bwohemwo dieli ha ace tan celi é bo ûdu ace tabe megele celi mwo coho, ne ha a *Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ke lé nyebihi a psaume ko a tan ubwo naa. Ke é mulang, ke lé taa pwo a juwole ko ni Olivier. ");
INSERT INTO cam_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ke e pii wo Iésu te lépwo acémun den pie: «Geé o bo tai engen kojaéo. Be caa te tii ne he ni tii iitihi pie: O bo taunu pa awéihi muto, ke lé o pipiiden ne ni muto. Zakari 13.7 ");
INSERT INTO cam_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","«Kehe icehi ana é hemepie é mulie cemwo mu ha amele, ke é bo ânebuhewé ne Galilé.» ");
INSERT INTO cam_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ke e pii ten wo Pétéru pie: «Wieli lé o engen kojako wo lépwoje, kehe time o uce woéo!» ");
INSERT INTO cam_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ke e hegi ne ten wo Iésu pie: «É pii tem a juuju pie: É ha a bwén jenaa, ânebuhe a bwo okelo ko to te a ja, ke wogo, ke o caa ocié go ko piwotétaa kong pie, time go uce temehiéo.» ");
INSERT INTO cam_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ke wo Pétéru, ke e te nene ko pii pie: «Ûhu! Te piwien hemepie genyu tai mele, kehe time é uce piwotétaa kom!» Ke tai woélé ati, ke te céiu ana lé pii. ");
INSERT INTO cam_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ke é mulang, ke lé â ha a céiu duaan na cemi acuwo hen na pii kon pie Getsémané. Ke e pii te lépwo acémun den wo Iésu pie: «Geé tebwo éni, be é mwo â pwoiitihi.» ");
INSERT INTO cam_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ke e pé Pétéru, me Cang, me Ioane. Ke tabuhi pinekepé ten, ke mwotieng. ");
INSERT INTO cam_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ke e pii telé pie: «Te junihe téé ke piwahin a pwonimung. Kehe geé tee mu éni, ke geé ûmiê! Geé nemwo pule!» ");
INSERT INTO cam_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ke e te ju piâdé kojalé, ke e tidihi jilin, ke e ilehi koja Padué me e pétaabwon kojaeng ni picani ko a benaamwon naa, hemepie te jan. ");
INSERT INTO cam_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ke e pii pie: «Abba, Caa! Jan ne kom ati ni naado. Go pé kojaéo ni picani me ni téé ce! Kehe icehi ana go nemwo pwo ana nimung kon, kehe ana nimem kon.» ");
INSERT INTO cam_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ke e mwojuia mwobé céii lépwo acémun den na cié jélé, ke e alihi pie lé teko pule. Ke e pii te Pétéru pie: «Simon, woté, go tee ko pule? Time uce jan me go ûmiê he na te ju céiu inetéale? ");
INSERT INTO cam_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Geé te ûmiê, ke geé pwoiitihi, beme o te pwo niihewé hemepie tacebwénikewé. Be nimewé me geé pwo ana wâé, kehe icehi ana tice niihewé.» ");
INSERT INTO cam_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ke e engemwo kojalé wo Iésu, ke e â pwoiitihi, ke e te pii mwo ana e caa te pii. ");
INSERT INTO cam_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ke me e mwojuia mwobé céii lépwo acémun den, ke e toolé mwo he lé teko pule. Be caa te junihe emaan jélé, ke lé tee ko pipucing. Ke time lé uce temehi ace bwo hegi nen ne ten. ");
INSERT INTO cam_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Caa a béociéhe a bwo engen den kojalé, ke e mwojuia mwo. Ke e pii telé pie: «Kona geé mwo teko mwaale, ke pule mwo? Caa nebwén! Caa weengi a benaamwon! Be o caa neéo, woéo pa Nahi Apulie, ne te lépwona lé pwo nina ta. ");
INSERT INTO cam_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Geé cuwoda! Me nye engen! Be caa e lang wo pana e icuéo!» ");
INSERT INTO cam_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","É he e mwo ko pii anaa wo Iésu, ke e te ju tehenebé kuti wo Judas, pali céiu béé lépwoli 12 apostolo ten. Ke lé âbé céin ne ni apulie na hiwon jélé, imi ni teua me ni ba-acuwo. Be lé nelé ngen wo lépwo caa te lépwo apwoâpwailo, me lépwo dotéén ko patén me lépwo apihuô. ");
INSERT INTO cam_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ke wo Judas, pana e pi-icu Iésu, ke e caa patemehi telé ana me e pwo: «Wo pa apulie na é o mwomwaaueng, ke te weeng kuti. Geé imwieng, ke geé pééeng ngen, ke geé wéieng ehi.» ");
INSERT INTO cam_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ke he lé tehenebé, ke e te âde Iésu kuti, ke e pii ten pie: «Bwocu tem, go pa apipune!» Ke e mwomwaaueng. ");
INSERT INTO cam_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ke lé te imwi Iésu kuti. ");
INSERT INTO cam_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kehe icehi ana wo pa apulie na e mu pele Iésu, ke e te pwome céi kuti a teua ten mu ha a mwon, ke e te tahi kuti ole pwo a puni pa apenem de pa *daame he lépwo apwoâpwailo. Kehe icehi ana e te ju tahagéi a jéénen. ");
INSERT INTO cam_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ke e pii ten wo Iésu pie: «Woté? Geé âbé pééo ko teua, me beba-acuwo, pwohewiin heme woéo pace ataunuhi apulie?! ");
INSERT INTO cam_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ati he ni tan, ke é te mu hadeniiwé, he é teko pacémuni ni apulie ne ha a *mwaiitihi, kehe icehi ana time geé uce imwiéo! Kehe wâé me wonaa, be é jenaa, ke o caa pacuwohi ni naado na caa te tii ne he ni tii iitihi.» ");
INSERT INTO cam_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ke ati ni acémun den, ke lé neeng, ke lé cela. ");
INSERT INTO cam_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kehe icehi ana pwo pa ewa aiu na e piâcéin. E tawiieng ko a ciite. Ke me lé pwo me lé imwieng wo lépwo béé apulie, ");
INSERT INTO cam_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ke lé te ju pé cehi a ciite ten, ke e cela, he te tice mwaanu kon. ");
INSERT INTO cam_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Lé pé Iésu nge céii pa daame he lépwo apwoâpwailo. Be lé pitapitilé nelang wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô, me lépwo dotéén ko patén. ");
INSERT INTO cam_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ke e pi-ilipuwolé ngen wo Pétéru, ke e â taa pele pa daame he lépwo apwoâpwailo. Ke e tebwo pwo napwomwo ne pele ni apenem, ni awéa, ke e pwocadéu. ");
INSERT INTO cam_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Wo lépwo caa te lépwo apwoâpwailo, me ati a *mwohuô te lépwo Juif, ke lé hane ce apulie beme lé pipé ne ko Iésu, be nimelé me lé pwocuhinaado ten me e mele. Kehe icehi ana time lé uce tooli. ");
INSERT INTO cam_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Be hiwon nina lé pipé ne kon, kehe icehi ana time lé uce piténelé. ");
INSERT INTO cam_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ke nebwén, ke lé cuwoda ne ni béén mu kolé, ke lé pii pie: ");
INSERT INTO cam_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Geme te téne he e pii pie: “É o paniihi a mwaiitihi te Padué ce, na lé bahi wo lépwo apulie. Ke é he na cié ni tan, ke é o bo pacuuli mwo ace céiu mwaiitihi na time uce bahi ko ni i apulie.”» ");
INSERT INTO cam_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kehe icehi ana wo lépwona lé pipé ne kon, ke time lé uce piténelé mwo. ");
INSERT INTO cam_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nebwén, ke e cuwoda ânebuhe ati lépwo apihuô wo pa daame he lépwo apwoâpwailo. Ke e tahimwo Iésu pie: «Kona te tice béhegi nen dem? He time go uce téne nina lé ko pipé ne kom?» ");
INSERT INTO cam_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kehe icehi ana time e uce hegi wo Iésu. Ke e tahimwoeng mwo wo pali daame pie: «Kona woté? Te a juuju pie wogo, ke pa *Mesia, pa *Naî Padué, wo Padué na nye paciitieng?» ");
INSERT INTO cam_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ke e hegi ne ten wo Iésu pie: «Éa, te woéo kuti. Ke geé bo aliéo, woéo pa Nahi Apulie, heme é tebwo *pwo a jui Padué na te junihe pwojunuun beme é pihuôhi ati ni naado. Ke geé bo aliéo heme é âbé he ni nii, mu he miiden.» ");
INSERT INTO cam_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ke me e téne anaa wo pa daame he lépwo apwoâpwailo, ke e te nihe okéé, ke e pitie ni epwénen, ke e pii te ni béé atautinaado pie: «Caa jan! Necu ce béé bwo pipé ne kon be e caa teko pipé ne kon mwo! ");
INSERT INTO cam_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Be geé caa téneeng, he e pwo me piwielu me Padué! Ke he ade aceli geé niimihi ne kon?» Ke lé tai hegi ne ten ati pie: «Wâé heme e mele!» ");
INSERT INTO cam_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ke lé cumi ne kon wo lépwo béén, ke lé tawii a pwahamiin, ke lé nuô i kon, ke lé pii ten pie: «He woo na e ahiko? Go cuwoteeke pihane, hemepie wogo pace péroféta celi go temehi ati ce naado!» Ke lé pééeng ne ni apenem, ke lé taii punin. ");
INSERT INTO cam_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mepwo wo Pétéru, ke e te mu jeoté pwomwo. Ke e tehenebé ê céiu apenem de pa daame he lépwo apwoâpwailo. ");
INSERT INTO cam_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ke e ali Pétéru he e ko pwocadéu. Ke e te ju omeeng ehi, ke e pii ten pie: «Éé! Wogo ke pa céiu béé Iésu mu Nazaret!» ");
INSERT INTO cam_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ke e hegi ne ten wo Pétéru pie: «Ûhu! Time é uce temehieng, ke time é uce temehi aceli nimem me go pii.» Ke e â pwo napwomwo. {Ke e to ali ja.} ");
INSERT INTO cam_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kehe wo êje, ke e te omeeng mwo, ke e pii mwo te ni apulie na lé mu lang pie: «Uhuu! Weeng ke pa céiu béé lépwo *acémun de Iésu!» ");
INSERT INTO cam_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ke e pii mwo wo Pétéru pie: «Ûhu! Time é uce temehieng!» Ke é alecehen, ke lépwona lé mu lang, ke lé pii ten mwo pie: «Uhuu! A juuju pie wogo pa céiu acémun den! Be wogo mwo, ke pa âbé mu Galilé!» ");
INSERT INTO cam_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ke e pii mwoiuhi wo Pétéru pie: «Éé! Geé téne! Time é uce temehi panaa! Wâé heme e pwocuhinaado tong wo Padué, hemepie é gele!» ");
INSERT INTO cam_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ke é he e mwo ko pii anaa, ke e okelo ko to na ali ja. Ke e bwo niimihi ali e caa pii ten wo Iésu pie: «Ânebuhe a bwo okelo ko to te a ja, ke go caa ocié ko piwotétaa kong pie, time go uce temehiéo.» Ke e é wo Pétéru. ");
INSERT INTO cam_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","É he mwo te junihe acaama, ke lé pitapitilé neibu ati ni *mwohuô te lépwo *Juif: wo lépwo caa te lépwo *apwoâpwailo, me lépwo apihuô, me lépwo *dotéén ko patén. Be nimelé me lé temehi aceli me lé pwo te Iésu. Ke lé cieeng, ke lé pééeng nge céii *Pilate pa gupéno te lépwo Roma. ");
INSERT INTO cam_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ke e tahimwoeng wo Pilate pie: «Kona te wogo kuti pa daame he lépwo Juif?» Ke e hegi ne ten wo Iésu pie: «A juuju a bwopiinen dem.» ");
INSERT INTO cam_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ke lé pipé ne ko Iésu wo lépwo caa te lépwo apwoâpwailo, ke hiwon ni naado na lé pipé ne kon. ");
INSERT INTO cam_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ke e tahimwoeng mwo wo Pilate pie: «Kona woté? Te tice celi go hegi kon? Go teko téne ati ni naado na lé ko pii ne kom?» ");
INSERT INTO cam_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kehe icehi ana time e uce hegi. Ke e te junihe téele kon wo Pilate. ");
INSERT INTO cam_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Caa te cemang ne ko Pilate, ha a tan ko *Pacika, me e pawie mu he karépu pace céiu apulie celi nime a bele kon. ");
INSERT INTO cam_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ke é ha a jo naa ke pwo pa céiu apulie na pii kon pie Barabas, na lé pimu ibu he karépu me lépwo béén. Be lé taunuhi apulie he lé pwobwoni lépwo Roma. ");
INSERT INTO cam_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ke lé tehenebé pele Pilate ni apulie na hiwon jélé, ke lé ilehi kojaeng pie: «Go pwo ne teme a naado na caa te cemang ne kom me go pwo!» ");
INSERT INTO cam_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ke e hegi ne telé pie: «Kona nimewé me é pawie mwo Iésu, pa daame he lépwo Juif?» ");
INSERT INTO cam_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Be e te temehi pie, lé ne Iésu ten wo lépwo caa te lépwo apwoâpwailo ha a pipwokon delé. ");
INSERT INTO cam_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kehe icehi ana wo lépwonaa, ke lé cine ni apulie beme lé pii pie: «Ne teme Barabas!» ");
INSERT INTO cam_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ke e tahimwolé mwo wo Pilate pie: «Kona ade celi me é pwo te pana geé pii kon pie ‘Pa daame he lépwo Juif’?» ");
INSERT INTO cam_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ke lé cihe me ubwo pie: «Cemeiteeng ne ko a *kuricé!» ");
INSERT INTO cam_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ke e tahimwolé mwo pie: «Kona ade aceli e pwo celi ta?» Kehe icehi ana lé bwo te nihe cihe da me ubwo pie: «Cemeiteeng ne ko a kuricé!» ");
INSERT INTO cam_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ke wo Pilate ke e pawie ne telé Barabas, be nimen me lé piwâéeng ne ni apulie. Ke e patupwo Iésu ne te ni coda. Ke lé ahieng ko a bwaliiwota, ke lé â cemeiteeng ne ko a kuricé. ");
INSERT INTO cam_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Lé pé wie Iésu, ke lé â pwo a céiu napwomwo na ubwo. Ke lé tode ati ni mwocoda. ");
INSERT INTO cam_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ke lé pwo me e cuwohe a epwén na te junihe megele pwohewii a epwéne pa apulie na piubwo nang, beme lé pihoonieng. Ke lé péi a kuron ko ni mii acuwo na pwo dan, ke lé neole pwo punin. ");
INSERT INTO cam_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ke lé cuwo aujenieng, ke lé pii ten pie: «Bwocu, go pa daame he lépwo Juif! Adéiko!» ");
INSERT INTO cam_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ke lé ahi a punin ko a bewomeéle. Ke lé cumi ne kon, ke lé tidihi jililé he pwahamiin. ");
INSERT INTO cam_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ke me lé caa nebwén a bwo pihoonieng, ke lé céi mu kon ali epwén megele. Ke lé te ne mwo kon ni epwénen. Ke é mulang, ke lé pééeng ngen, beme lé â cemeiteeng ne ko a kuricé. ");
INSERT INTO cam_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Pwo pa céiu apulie mu ha a pwomwo ubwo Cirène na pii kon pie Simon, pa caa te Alexandre me Rufus. E piâbé lang, be e mwojuia mwobé mu ha apwoamu. Ke lé cuwokon wo lépwo coda, beme e canihi ali kuricé te Iésu. ");
INSERT INTO cam_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ke lé pé Iésu nge pwo a céiu tihi juwole na pii kon pie Golgota, a bwopiinen pie ‘pwo a piipuni apulie’. ");
INSERT INTO cam_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ke wo lépwo béén, ke lé pineibuhi a tabe megele me a tabe na maga. Ke lé ne te Iésu, kehe icehi ana te muhi ten me e ûdu. ");
INSERT INTO cam_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","É he ko 9 ni inetéale ko acaama, ke lé cemeiteeng ne ko ali kuricé wo lépwo coda. Ke lé picéi metii, beme lé pipii ne kolé ni epwénen. ");
INSERT INTO cam_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ke lé cemeite ne pwo punin a eaa acuwo na tii ne kon a watihe a bwo mele ten, pie: pa daame he lépwo juif. ");
INSERT INTO cam_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ke lé cemeite mwo lupwo alo apulie na lu pwotahinaado, ne he ni piduaa Iésu: wo pa céiu ne pwo juin, ke wo pa céiu ne pwo eaamun. { ");
INSERT INTO cam_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ke wonaa, caa *pajuujuhi ana caa mi tii ne he ni tii iitihi ne kon pie: Lé pwo me e pwocuhinaado; be lé pii pie, pa apwotahinaado.} ");
INSERT INTO cam_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Me lé alieng wo lépwona lé âdé ke âbé ha a duaan naa, ke lé tagiliihi ni punilé, ke lé pijeta kon. Ke lé pii pie: «Aje, kona time uce wogo kuti pana me go tanahi ali *mwaiitihi, ke me go bo pacuuli mwo he na cié ni tan? ");
INSERT INTO cam_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Go piceluimiko mwo, ke go opé mu ko a kuricé naa!» ");
INSERT INTO cam_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","32","Ke lé pihoonieng mwo wo lépwo caa te lépwo apwoâpwailo me lépwo dotéén ko patén. Ke lé pipii telé pie: «E niimihi pie pa daame henye, lépwo *Isaraéla. Ke e temehi me e celuimi ni béén, kehe time e uce temehi me e piceluimieng mwo! Hemepie e ole mu ko a kuricé naa, ke wieli genye o bo céihi ne kon!» Ke lu pihoonieng mwo lupwo alo na cemeitelu ne ko ni kuricé ne he ni piduaan. ");
INSERT INTO cam_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","É he te ju goahen ehi, ke te ju melepiing ati ha amu, die ko cié inetéale alecehe a goahen. ");
INSERT INTO cam_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ke me teko ju cié ni inetéale, ke e toii me ubwo wo Iésu pie: «Éloï, Éloï, lama sabaktani?» A bwopiinen pie: «Padué hung, Padué hung, é mu ko ade na go pawieéo?» ");
INSERT INTO cam_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ke me lé téneeng ne ni béén na lé mu lang, ke lé niimihi pie, e tode péroféta *Élia beme e picani ten. ");
INSERT INTO cam_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ke wo pa céiu béélé, ke te téte kuti imi a mwaanu, ke e pate ha a tabe megele na maga. Ke e ne ko a ba-acuwo, ke e ne te Iésu beme e ûdu. Kehe lé pii ten wo lépwo béén pie: «Go mwo cuwo lang, be wieli nye o ali *Élia, hemepie e âbé neeng ole mu ko a kuricé!» ");
INSERT INTO cam_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kehe icehi ana e cihe da me ubwo wo Iésu, ke ele a nenehen. ");
INSERT INTO cam_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ke a mwaanu na e capuhi bwonihi a duaan na junihe iitihi ne ha a mwaiitihi, ke te ju tie ne ha awiemen kuti, mu jeda die jeoté ko a baaéén. ");
INSERT INTO cam_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Pwo pa caa te coda roma na e cuwo ânebuhe Iésu, ke me e alihi a bwo mele ten, ke e pii pie: «A juuju pie wo pa apulie ce, ke pa *Naî Padué!» ");
INSERT INTO cam_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Pwo ni béé toomwo na lé mu lang mwo, na lé omehi mu ité: woélé me Maria Magdala, me Salomé, me Maria, nyaa te José me Cang (wo pana lé pii kon pie: Ewa Aiu). ");
INSERT INTO cam_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Woélé kuti, na lé âcéi Iésu, ke lé picani ten, he e mwo tee mu ha amu Galilé. Ke hiwon ni béé toomwo na lé mu mwo lang, na lé taa céin mwo ne *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ati ni naado naa, ke tai pwo heme paciile a tan ânebuhe a *tan iitihi te lépwo Juif. É he ni paciile, ke lé pwopweehi a piwiinaado ko a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","É he babwén, ke e tehenebé wo Josef, pa apulie mu ha a mwopopwaalé Arimaté, pa céiu apulie na pwo a niin ne ha a mwopitautinaado te lépwo Juif. Wo pali e teko mwoiu ko ucéihi ace bwo tuiebé na a *Mwametau te Padué. E pipamwoiueng, ke e â pele pa daame Pilate, ke e ilehi a éé Iésu. Be nimen me e pé a één ânebuhe a bwo tabuhi na a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ke me e téne wo Pilate pie e caa mele wo Iésu, ke e téetihi. Ke e tode pa caa te coda, ke e tahimwoeng pie: «Kona caa bwolihi ace bwo mele ten?» ");
INSERT INTO cam_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ke e piuti ten. Ke wo Pilate, ke e ne a pihuô te Josef, beme e pé a éé Iésu. ");
INSERT INTO cam_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ke e engen wo Josef, ke e â patuwo a éé Iésu mu ko a kuricé. Ke e tawiieng ko a mwaanu na e pwocuhin. Ke e pééeng, ke e neeng he iitihi, ha a pwon na ini ne ha a péi. Ke nebwén, ke e papitibehi a pilehe péi, beme e capuhi bwonihi ali pwon. ");
INSERT INTO cam_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ke wo Maria Magdala, me Maria nyaa te José me Cang, ke lu te alihi a duaan na e ne Iésu hen. ");
INSERT INTO cam_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","É he capéto ko a babwén he caa nebwén a *tan iitihi te lépwo *Juif, ke lé pwocuhi a tabe ûde wo Maria Magdala, me Salomé, ke wo Maria nyaa te José me Cang, beme lé â timi a éé Iésu kon. ");
INSERT INTO cam_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","He pwoiitihi, he e taawie na a téale, ke lé â he iitihi. ");
INSERT INTO cam_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","4","É nge he pwaaden, ke lé pipii telé pie: «De e bo titééhi ne tenye ali péi mu ha ali pomwa ko ali mwa péi? Be te nihe ubwo!» Ke me lé tehene ngen, ke lé alihi pie caa titééhi! ");
INSERT INTO cam_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ke lé taa ha ali mwa péi, ke lé ali pa nahi aiu he e ko tebwo pwo jui, ke e ne a jame epwén na pwojo. Ke lé téetihi, ke nihe mwotilé. ");
INSERT INTO cam_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ke e pii telé pie: «Geé nemwo pwo me mwotikewé! Geé hane Iésu, pa mu Nazaret, pali lé cemeiteeng ne ko a *kuricé. Kehe e caa mulie cemwo mu ha amele, ke caa time uce e éni! Be éni ali duaan li lé neeng hen. ");
INSERT INTO cam_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kehe geé mwojuia, ke geé â pii te Pétéru me lépwo béé acémun pie: “E ucéikewé ne Galilé wo Iésu, ke geé bo alieng nelang, pwohewii ana e caa pii tewé.”» ");
INSERT INTO cam_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Lé te â wie kuti mu ha ali mwa péi wo léli toomwo, ke lé te téte kuti. Be te nihe emegéi nalé, ke éjén jélé, ke time lé uce pii te ni apulie hauli, be te nihe mwotilé. ");
INSERT INTO cam_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","E caa mulie mwo wo Iésu he pwoiitihi, he mwo nihe acaama. Ke e te mi pihabwiieng de Maria Magdala, êgi toomwo li e pwo me wâé nang, li e pwo me lé engen kojaeng li 7 duéé. ");
INSERT INTO cam_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ke e âbé wo êje, ke e piuti ana e alihi te lépwo béé Iésu, na élé ha a piwahin. ");
INSERT INTO cam_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ke lé téne he e pii telé pie: «E caa mulie cemwo wo Iésu! Be é alieng!» Kehe icehi ana time lé uce céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Pwo lupwo alo *acémun de Iésu, na lu piâ pwo pwaaden mu ha a pwomwo ubwo. Ke e pihabwiieng delu wo Iésu, kehe caa ité a bwo alieng. ");
INSERT INTO cam_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ke lu mwojuia mwo, beme lu â piuti te lépwoli béé acémun, kehe icehi ana time lé uce céihi ne kolu! ");
INSERT INTO cam_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ke a bénebwénen, ke e pihabwiieng de lépwo 11 *apostolo ten wo Iésu, he lé mwo ko wiinaado. Ke e péélelé, ke e pii telé pie: «Te junihe mwoiu ni puniwé! Muhi tewé me geé céihi he lé pii tewé pie, é caa mulie cemwo!» ");
INSERT INTO cam_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ke e pii telé mwo pie: «Geé engen pitihi a bwohemwo, ke geé â patemehi a Pwooti Wâé te ati ni apulie. ");
INSERT INTO cam_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ke wo pana e bo céihi ne kong, ke o bo puueng, ke o bo celuimieng, ke e bo mulie. Ke wo pana time e uce céihi, ke o bo tautieng, ke o bo pwocuhinaado ten. ");
INSERT INTO cam_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Weengi a béhabwiinen ne ko nina lé céihi: Lé o bo peni ni duéé ne he niing; Ke lé o bo cihe he ni béé pati apulie na te ité; ");
INSERT INTO cam_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ke o te jan me lé imwi ni bwien ne he ni ilé; Ke me lé ûdu ace tabe celi nye mele kon, ke time lé o uce mele; Ke lé o bo ne ni ilé ko ni cunu, ke bwo wâé jélé.» ");
INSERT INTO cam_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","É alecehe a bwo picihe telé naa, ke céida he miiden Padaame Iésu, ke e tebwo *pwo a jui Padué. ");
INSERT INTO cam_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ke wo lépwo acémun den, ke lé engen pitihi a bwohemwo, beme lé patemehi a Pwooti Wâé. Ke e picani telé wo Padaame. Ke e *pajuujuhi a Pwooti na lé patemehi, be e ne telé a junuun, beme lé pwo ni inenaado na lé téetihi ne ni apulie.");
INSERT INTO cam_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Bwocu tem, go pa daame Téofile. É tii a tii ce, beme é piuti tem ati ni naado na e caa pwo wo Padué ne peleme, ne alecehe a bwo pituie te Iésu. Hiwon ni apipajuujuhi na lé alihi ni naado naa, ke lé patemehi a *Pwooti Wâé. Ke wo lépwo béén, ke lé pwo me lé piuti ne he tii. Ke woéo mwo, ke me é hane ehi, beme é tii ke cile ehi a jepule be me dem, ne ko ati ni naado naa. ");
INSERT INTO cam_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Be me wonaa, ke me go bwobe alihi pie, a juuju a pwooti na go caa hegi. ");
INSERT INTO cam_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","É ha a benaamwon na e mwo daame ne *Judé wo Érode pa Bécéiuhen, ke pwo pa céiu apulie lang, na pii kon pie Zakari, pa *apwoâpwailo mu ha a pwomwoiu te Abia mu ha amu te *Aarona. Ke ê mwoden, wo Élisabet, ê piebehi Aarona. ");
INSERT INTO cam_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ke tai woilu, ke mwomwon julu ne ânebuhe Padaame Padué. Be lu piténedehi ati ni patén me ni pihuô ten, ke te tice celi me tautilu kon. ");
INSERT INTO cam_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kehe icehi ana te tice naîlu, be pwocoon me pwo naî Élisabet. Caa tai ukéiu julu. ");
INSERT INTO cam_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ha a céiu tan, ke e pwo a penem den wo Zakari, ne ha a *mwaiitihi te Padué. Be te a tan na lé penem ibu hen me ni béén. ");
INSERT INTO cam_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Âcehi a bwopwonen de lépwo apwoâpwailo, ke lé picéi metii, beme lé pipégali pace apulie mu kolé, na me e taa ha a duaan na iitihi, ne ha a mwaiitihi. É lang, he na cini encens ni dep na ûde wâé heme nye cini beme âpipati te Padué. Ke é ha a tan naa, ke hiwon ni metii te Zakari. Ke e taa pwo a penem den. ");
INSERT INTO cam_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nihe hiwon ni apulie na lé ko pwoiitihi ne jeoté pwomwo, he e mwo ko cini encens. ");
INSERT INTO cam_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ke é he e ko wonaa, ke e te âbeetieng kuti wo pa céiu *âcélo te Padaame, na e cuwo pwo jui ne ko apwoâpwailo na mu cini encens ne pwon. ");
INSERT INTO cam_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ke e téetieng wo Zakari, ke te nihe mwotieng. ");
INSERT INTO cam_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kehe e pii ten wo pali âcélo pie: «Go nemwo pwo me mwotiko, go Zakari, be e caa téne ni pwopwoiitihi teu wo Padué. Ke bo pwoapulie ko mwodem, ke e bo picile ewa, ke go bo pitoii kon pie Ioane. ");
INSERT INTO cam_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ke bo piwâénimeu, ke bo hiwon mwo ni béén na lé bo pipwodéén mwo. ");
INSERT INTO cam_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Pa naîm naa, ke bo pa apulie na nihe ubwo nang ne ale Padaame. Ke iitihi me e ûdu tabe megele, me ace céiu bwimwoiu, be caa ju tilieng na a *Jenen Iitihi, he e mwo te mu tina nyaa ten. ");
INSERT INTO cam_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","«Ke nihe hiwon lépwona mu ha a puapulie *Isaraéla na e bo péélé ngemwo pele Padaame Padué helé. ");
INSERT INTO cam_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","E bo mu kon a junuu a Jenen Iitihi, pwohewii *péroféta Élia ânebun. Ke e bo cile ehi me pwopweehi a puapulie ten, ânebuhe a bwo tuie te Padaame. Ke é mu kon, ke wo lépwo caa, ke lé bo pinenimelé ne ko ni naîlé. Ke lé bo pininim wo lépwona time lé uce piténede Padué, ke lé o pwohewii lépwo apulie na lé mwomwon ne ale Padué.» ");
INSERT INTO cam_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","E pii wo Zakari te pali âcélo pie: «É o woté ko ace bwo céihi ne ko ana go ko pii? Be caa te nihe ukéiu jo, ke ê mwodong, ke caa te ukéiu nang mwo.» ");
INSERT INTO cam_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ke e hegi ne ten pie: «Woéo, Gabriel, pa âcélo na é mu cuwo ale Padué, beme pa apenem den. Weeng na e neéo bé, beme é pipatemehi tem a jepule wâé ce. ");
INSERT INTO cam_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wâé heme go temehi pie, lé o bo tuie ati ni naado na é pii tem, ha a benaamwon na e caa ne wo Padué. Kehe icehi ana wogo, ke time go uce céihi ne kon! Ke o huuhu go, die ha a tan na o bo cuwo ati nina é pii tem!» ");
INSERT INTO cam_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ke é he lu tee ko picihe wo Zakari me pali âcélo, ke e mwo ko ucéieng a pubu apulie. Ke lé téetihi, be te nihe bwolieng lang. ");
INSERT INTO cam_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Me e wie mulang, ke caa huuhu nang. Ke e te ju pwo inenaado telé ko a in. Ke lé temehi pie pwo celi e alihi, celi e âbé mu ko Padué. ");
INSERT INTO cam_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nebwén, ke e panebwénihi a penem den wo Zakari ne *huâ iitihi, ke e âmwo ha a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","É alecehen, ke pwoapulie ko mwoden Élisabet, ke e te mu huâ he na nim ni wole. Ke e tee niimihi pie, ");
INSERT INTO cam_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","‘Te nihe wâé Padaame ne kong, be é ânebun, ke te nihe tanim jo, be êna te tice naîng. Ke e piwâééo, ke e pwii mu huîing a bwo tanim jo.’ ");
INSERT INTO cam_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Caa 6 ni wole na pwoapulie ko Élisabet. Ke wo Padué, ke e neopé pa âcélo ten, wo Gabriel, ne Nazaret ne Galilé, ");
INSERT INTO cam_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ne pele ê céiu ewa toomwo na pii kon pie Maria. Wo ênaa, ke lu picihe me pa apulie na pii kon pie Josef, pa piebehi pa daame *Davita. ");
INSERT INTO cam_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ke e âbeetieng pa âcélo, ke e pii ten pie: «Adéiko, go Maria! Be e pelem wo Padaame Padué, ke wâé ten go.» ");
INSERT INTO cam_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ke e téetihi wo Maria, be time e uce temehi nina e pii ten. Ke e piniimihi pie: ‘É ko ade na e adéiéo wo Padué?’ ");
INSERT INTO cam_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ke e pii ten wo pali âcélo pie: «Go nemwo pwo me mwotiko, go Maria! Be e piwâéko wo Padué, ke e pipégaliko. ");
INSERT INTO cam_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ke bo pwoapulie kom, ke go bo picile pa cuwo nahi aiu, ke go bo toii niin pie Iésu. ");
INSERT INTO cam_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ke bo pa apulie na nihe ubwo nang ne he pwahamii Padué. Ke o bo toii kon pie ‘Pa *Naî Padué na e daaité’. Ke wo Padué, Padaame hen, ke e bo ne ten a pwodaame te pa daame Davita, pa watihen. ");
INSERT INTO cam_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ke bo pa daame he a puapulie Isaraéla dieli mwo, ke o te tice anebwén ko a pihuô ten.» ");
INSERT INTO cam_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ke e pii wo Maria te pali âcélo pie: «Kona anaa, ke o woté ace bwopwonen?! Be time gemu uce pipule me pa aiu hung, ai pace céiu aiu!» ");
INSERT INTO cam_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","E hegi ne ten wo pali âcélo pie: «E bo opé ne kom a Jenen Iitihi, ke bo e pelem a junuu Padué na nihe e daaité. Ke wo pa cuwo nahi ewa na go bo picileeng, ke weeng kuti na e pipégalieng wo Padué, ke bo toii kon pie pa Naî Padué. ");
INSERT INTO cam_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","«Go téne, lé mu pii ânebun ko ê béém Élisabet pie: “Te tice naîn”! Kehe icehi ana e bo picile ewa, be ko pwoapulie kon ni, caa 6 ni wolen. ");
INSERT INTO cam_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Be te tice aceli pwocoon ne te Padué!» ");
INSERT INTO cam_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ke e hegi ne ten wo Maria pie: «Woéo ê apipenem de Padaame, ke me e pwo ne tong ana nimen kon.» Ke me wonaa, ke e engen kojaeng pali âcélo. ");
INSERT INTO cam_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","40","É he ni tan alecehen, ke e engen wo Maria me e â caniê Élisabet. A mwopopwaalé ten, ke e mu pwo a juwole ne ha a céiu duaan ko a Judé. E taa ha a mwa wo Maria, ke e pwobwocu ten. ");
INSERT INTO cam_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Me e téne a bwo pwobwocu te Maria wo Élisabet, ke e pipenem a ewa na e kon, ke caa ju tili Élisabet na a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ke e toii da pie: «E te nihe adéiko wo Padué, ke e ne me ubwo go koja ati ni ewa toomwo! E te junihe *adéi a ewa na e kom. ");
INSERT INTO cam_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nihe a naado na nihe ubwo ne kong! Be go âbé caniêéo, wogo ê nyaa te Padaame hung! ");
INSERT INTO cam_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","«Go téne, go ê ju bééng, heme é téne a pwocihe tem, ke e pipwodéén ali cuwo ewa li e kong, ke e pipenem ne tinang! ");
INSERT INTO cam_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Adéiko, be go caa céihi pie, e bo te pacuwohi nina e pii tem wo Padaame.» ");
INSERT INTO cam_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","E pii wo Maria pie: «Pipwodéén a pwonimung, ke é pipaunu Padaame. ");
INSERT INTO cam_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Piwâénimung kon, be pa aceluimiéo! ");
INSERT INTO cam_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","E pwo me pwonaado ne kong, ê apipenem den na wahin jo. Lé o pii kong pie: “Adéi êje!” ati ne ni niide apulie. ");
INSERT INTO cam_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Be e picani tong ko a juin, wo pana nihe ubwo nang. E adéiéo wo Pana iitihi a niin. ");
INSERT INTO cam_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ubwo a bwo wâé nang me de nina lé paciitieng. E picani telé dieli mwo. ");
INSERT INTO cam_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E penem ko a junuun, e ta papiideni nina lé cibehede. ");
INSERT INTO cam_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","E patupwo ni daame mu pwo ni atebwo telé, ke e eti da lépwona wahin jélé. ");
INSERT INTO cam_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","E ne ni naamuu nina tice delé; e pamwojuiéhi nina pwo delé, heme tice âne ilé. ");
INSERT INTO cam_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","E picani te a puapulie ten, a puapulie Isaraéla, pa apipenem den, be e pipwoééhen. ");
INSERT INTO cam_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Be e *piapwo ne te ni watihenye, ne te *Abérama me ni piebehieng. Ke e pacuwohi nina e caa pii. O time e uce neulé dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","E mwo te mu pele Élisabet wo Maria he na cié ni wole. Ke e bwo mwojuia ngemwo pelen. ");
INSERT INTO cam_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tuie nge ha a benaamwon na me e picile ewa hen wo Élisabet, ke e picile pa ewa aiu. ");
INSERT INTO cam_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ke lé téne a jepule kon ne nina lé mu mwonueng, me a pwomwoiu ten, ke lé temehi pie e te junihe adéieng wo Padaame. Ke lé tai pipwodéén ati, ibu me weeng. ");
INSERT INTO cam_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Alecehe a naadenitan na céiu, ke lé âbé me lé *pwotegoop te ali cuwo nahi ewa pwohewii ana e pii ne ni *patén de Moosé. Nimelé me lé ne ten a nii caa ten: Zakari. ");
INSERT INTO cam_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kehe icehi ana e pii telé wo nyaa ten pie: «Ûhu! O pii kon pie Ioane.» ");
INSERT INTO cam_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ke lé pii ten pie: «É mu ko ade? Be te tice ha a pwomwoiu tem celi e pé a nii apulie naa.» ");
INSERT INTO cam_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ke lé te ju pwo inenaado te caa ten, Zakari, beme lé tahimwoeng pie: «O nimem me pii pie woté kon?» ");
INSERT INTO cam_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","65","Ke e pwo inenaado telé wo Zakari, beme lé ne ten ace metii, beme e pwotii ne hen, ke e tii pie ‘Ioane’. Ke me e tii a nii Ioane, ke e te cihe mwo kuti, ke e pipaunu Padué. Ke lé téetihi ne nina lé téneeng ke mwotilé. Ke lé piuti a jepule kon ne ha ati ni piduaan ko a juwole ne ha amu Judé. ");
INSERT INTO cam_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ke é he lé téne a pwooti naa ne ni apulie, ke lé te nihe pitautinaado, ke lé pii pie: «Éé! O te nihe ubwo celi e bo pwo wo pa cuwo nahi ewa naa!» Be e pelen wo Padaame. ");
INSERT INTO cam_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wo Zakari, pali Caa te ewa, ke caa ju tilieng na a Jenen Iitihi, ke e pipatemehi a pwooti na e ne ten wo Padué. Ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Pipaunu Padaame, Padué he a puapulie Isaraéla! E celuimikenye, me tuwokenye mu he ni ta pwo tenye. ");
INSERT INTO cam_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Be e nebé pa *aceluimikenye, na nihe pwojunuun, wo pa piebehi Davita, pa apipenem den. ");
INSERT INTO cam_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Lé pipatemehieng bwolihi ne ni péroféta na e pipégalilé. ");
INSERT INTO cam_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Be e caa pii pie: “É bo celuimikewé koja nina lé pii me ta gewé.” ");
INSERT INTO cam_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ubwo a pipwoééhe ten ne ko lépwo watihenye. E te pacuwohi a piapwo ten, ");
INSERT INTO cam_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","na e ne te Abérama, caa tenye, ne ha a bwo eânimen den. Be e ko pii ne konye pie: ");
INSERT INTO cam_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","“É celuimi ni naîm, koja lépwona lé pii me ta jélé, ke lé o pipenem dong, be o time o uce mwotilé. ");
INSERT INTO cam_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ke o bo wâé tong jélé. Ke o wâé ni pwonimelé, na ati he ni mulihelé ne éni pwo bwohemwo.”» ");
INSERT INTO cam_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ke e pii mwo wo Zakari ko pa naîn Ioane pie: «Wogo pa naîng: O bo pii kom pie pa péroféta, pa apipépwooti te Padué na e mu âda he miiden. Go bo â ânebuhe Padaame, me go pwopweehi a pwaadeniin. ");
INSERT INTO cam_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Go o pii te a puapulie ten pie: E bo celuimikewé! E bo pineuhi ni ta pwo tewé! ");
INSERT INTO cam_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nihe ubwo a bwo wâé nang! E pébé pelenye a pwéélang, a bwo caama te a téale. ");
INSERT INTO cam_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","A pwéélang na e pwoeihi nina lé mu ha a melepiing. Ke e habwii telé a pwaaden mu ha amele nge ha a péém.» ");
INSERT INTO cam_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Caa ubwo pali ewa aiu, Ioane, ke piubwo ngen mwo a junuu a Jenen Iitihi ne kon. Ke e mulie ne ha a da, die ha a tan na e bo pihabwiieng de a puapulie Isaraéla. ");
INSERT INTO cam_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","É ha a benaamwo amu naa, he e daame ubwo te lépwo Roma wo Auguste, ke e mwo gupéno ne Siri wo Kirinius, pa apenem den. Ke e huôhi wo Auguste pie, me pine a jéhi ni apulie na ati he ni amu na lé mu ko a mwohuô ten. Ke he bwo te a bécéiuhen me lé pwo anaa. ");
INSERT INTO cam_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ke lé engen ati ni apulie, ke lé caa muko pipiiden nge he ni mwopopwaalé te ni ukéiu telé, beme lé tii ni niilé. ");
INSERT INTO cam_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Ke wo Josef, ke e engen mu Nazaret ne Galilé beme e â Bétéléma ha amu *Judé, beme e â tii a niin. Be he li e tuie nelang wo pa daame *Davita, pa watihen. Ke e pé Maria ê mwoden, na caa pigiaa nang, be e ucéihi a bécéiuhe naîn. ");
INSERT INTO cam_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ke me lu mu Bétéléma, ke e tuiebé a benaamwon na me e caa picile ewa hen wo Maria. ");
INSERT INTO cam_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ke e picile pa bécéiuhe naîn. Ke e taluieng ha a pwotuun, ke e neeng ha a mwowiewota, be tice ahilu be nihe hiwon ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","É ha a bwén naa, ke pwo ni apulie na lé wéihi ni muto telé ne ha a céiu duaa juwole. ");
INSERT INTO cam_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ke e te tuiebé kuti pa céiu *âcélo te Padaame, ke e cuwo ânebuhelé, ke te pwéélang aujenilé kuti a bwo ubwo na a wâé te Padaame. Ke te junihe mwotilé kuti. ");
INSERT INTO cam_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ke e pii telé wo pali âcélo pie: «Geé nemwo pwo me mwotikewé, be é pébé céiikewé a pwooti na wâé, na lé o te nihe pipwodéén kon ati ne ni apulie! ");
INSERT INTO cam_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Be é ha a bwén ce, ke e caa âbeele pa aceluimikewé, ne ha a mwopopwaalé te Davita: wo pali *Mesia, Padaame li geé teko ucéieng. ");
INSERT INTO cam_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Weengi a inen beme geé ali temehieng: Geé o too pa cuwo ewa na taluieng ko a pwotuun, ke e pule ha a mwowiewota.» ");
INSERT INTO cam_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ke me wonaa, ke lé te tuie opé kuti mu he miiden ni béé âcélo na nihe hiwon jélé. Ke lé aujeni pali âcélo, ke lé pwonyebi me pipaunu Padué: ");
INSERT INTO cam_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Pipaunu Padué jeda he miiden! Péém ne éni pwo bwohemwo, me de ati nina wâé ten jélé!» ");
INSERT INTO cam_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","É alecehen, ke li âcélo, ke lé engen kojalé, ke lé mwojuia daamwo he miiden. Ke lé pipii telé wo lépwo awéihi muto pie: «Genye â Bétéléma, me nye alihi aceli e tuie, ana e ko pii tenye wo Padaame.» ");
INSERT INTO cam_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ke lé te piepin ko engen kuti, ke lé too Maria me Josef, me pali cuwo ewa he e ko pule ha a mwowiewota. ");
INSERT INTO cam_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ke me lé caa alieng, ke lé â uti ati te ni apulie li e pii telé wo pali âcélo ne ko pali cuwo ewa. ");
INSERT INTO cam_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ke lé te nihe téetihi ati ne nina lé téne. ");
INSERT INTO cam_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ke e te ju cile ehi ati ni naado naa wo Maria, ke e bo tee pitautinaado ne ha a pwonimen. ");
INSERT INTO cam_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Lé mwojuia ngemwo li awéihi muto, ke lé nihe pwonyebi me paunu Padué ko ati ni naado na lé alihi me téne. Be te tai cuwo ati li e pii telé wo pali âcélo. ");
INSERT INTO cam_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","É alecehe a naadenitan na céiu, ke lu pé ngen pali naîlu wo Josef me Maria, beme *pwotegoop ten pwohewii ni *patén de Moosé. Ke lu ne me a niin pie Iésu, ali nii apulie li e caa mi pii wo pali âcélo, ânebuhe a bwo pwoapulie ko Maria. ");
INSERT INTO cam_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Tuiebé a benaamwon na wo Maria, ke me e *pwoâpwailo ko a bwo wâé nang ne pele Padué, alecehe a bwo picile ewa ten. Be e caa tii ne he ni patén de Moosé pie: Wâé heme e ne lupwoce uiajaap, ai lupwoce bun. É mu ko anaa, na lu â *huâ iitihi ne *Iérusaléma wo Maria me Josef, beme lu pwoâpwailo. Ke lu pé ngen ali cuwo ewa, beme lu neeng de Padaame. Be caa tii mwo ne he ni patén pie: Pa bécéiuhe ewa aiu, ke a de Padaame. ");
INSERT INTO cam_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","É ha a benaamwon naa ke pwo pa céiu apulie ne Iérusaléma na pii kon pie Siméon, pa apulie na e mwomwon, ke e pipwoiipieng ne ale Padué. Ke e tee ucéihi a bwo tuie te pa Mesia, pa aceluimi na a puapulie *Isaraéla. Ke e huîin a *Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ke e caa pii ten a Jenen Iitihi pie: «Go téne go Siméon, go o mwo te alihi a bwo tuie te pa Mesia te Padaame Padué, ânebuhe ace bwo mele tem!» ");
INSERT INTO cam_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ke e pahedeeng nge ha ali *mwaiitihi. Ke he te ju é ha a benaamwon naa kuti, na lu ko pé ngen Iésu wo lu nyaa me caa ten, beme lu habwiieng te Padaame pwohewii li patén. ");
INSERT INTO cam_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ke e pé pali cuwo ewa wo Siméon, ke e *adéi Padué, ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Jenaa ni, go Padaame, ke é pipwodéén woéo pa apipenem dem! Go pééo ne pelem, ne ha a péém dem. Be caa pacuwohi ana go caa pii. ");
INSERT INTO cam_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ni naamiing, ke lé ali pa aceluimi ati ni puapulie na go neeng deme, ");
INSERT INTO cam_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","na go caa pipwopweeng ne ânebuhe ni puapulie. ");
INSERT INTO cam_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Pa pwéélang ko a bwohemwo, ke a bwo ubwo na a wâé te a puapulie tem, Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wo lu nyaa me caa te pali cuwo ewa, ke lu téetihi nina e pii ne kon wo Siméon. ");
INSERT INTO cam_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ke e adéilu, ke e pii te Maria pie: «É mu ko pa naîm, ke bo hiwon ne Isaraéla nina lé bo tupwo, ke hiwon mwo nina lé bo cuwoda. Ke bo pa inenaado te Padué, ke lé bo téétieng ni béé apulie. ");
INSERT INTO cam_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Be o bo pwéélang ko ni bwo niimihinaado na e ha aduwo ne te ni apulie. Ke me wogo, go êje, ke o te nihe cunu go kon, pwohewiin heme e woli a pwonimem ace teua.» ");
INSERT INTO cam_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","É ha a benaamwon naa, ke e ko mu huâ iitihi ê céiu toomwo péroféta na pii kon pie Anne, ê naî Fanuel, mu ha a pwomwoiu te Asser. Wo ênaa, ke lu pimu me pa aiu hen, he na te ju 7 ni jo, ke e mele kojaeng wo panaa. Ke wo Anne, ke caa ukéiu nang, ne ha a bwo depwele ten. Be caa 84 ni jo hen jenaa. ");
INSERT INTO cam_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ke e mu huâ iitihi heme bwén ke pwang, beme e pipenem de Padué, ke me e pwoiitihi ke pipatupwo wiinaado me ûdu. ");
INSERT INTO cam_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ke e tuiebé he lé ko mu lang wo Siméon me pali cuwo ewa, me lu nyaa me caa ten. Ke me e alilé, ke e pwo-olé te Padué, ke e pwojepule ko Iésu te ati ni apulie na lé ucéihi ace bwo tuiebé te pa Mesia beme e celuimi ni apulie Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wo lu nyaa me caa te Iésu, ke lu pacuwohi nina e pii ne he ni patén de Padué: ni naado na nye mu pwo heme e tuie a cuwo ewa. É he lu caa pacuwohi ati, ke lu mwojuia mwo ne Nazaret ne ha amu Galilé. ");
INSERT INTO cam_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Piubwo da Iésu, pali cuwo ewa, ne ha a bwo temehinaado, me a pitemang. Ke e te mu pelen a adéihi te Padué. ");
INSERT INTO cam_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","É téteda he ni jo, ke te cemang me lu â Iérusaléma wo lu nyaa me caa te Iésu, ne ko a pwoiitihi ko a *Pacika. Ke é he 12 ni jo he Iésu, ke e âcéilu. ");
INSERT INTO cam_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","É alecehen, ke lu caa mwojuia mwo. Kehe icehi ana e te mu Iérusaléma wo Iésu. Ke time lu uce alihi pie tieeng, ");
INSERT INTO cam_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","be lu niimihi pie, e pele ni béélé ko a engen. Kehe icehi ana é alecehe ana céiu tan, ke lu bwo alihi pie tieeng. Ke lu tabuhi haneeng ne ha awieme ni pwomwoiu telu me ni béélu. ");
INSERT INTO cam_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ke time lu uce alieng, ke lu mwojuia mwo ne Iérusaléma me lu â haneeng. ");
INSERT INTO cam_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","É ha a béciéhe ni tan, ke lu bwo tooeng ne huâ iitihi, he e ko tebwo ha awieme ni apacémuni ni *Juif. Be e ko tabemilé, ke e tahimwolé ko ni *tii iitihi. ");
INSERT INTO cam_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ke ati nina lé tabemieng, ke lé nihe téetihi a bwo temehinaado ten me a bwo hegi nen den. ");
INSERT INTO cam_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ke é heme lu alieng wo lu nyaa me caa ten, ke lu te nihe téetieng, ke e pii ten wo nyaa ten pie: «É mu ko ade na go pwo temu anaa? Go téne, nihe mwotikemu me caa tem, ke gemu mwojuia mwo beme gemu haneko!» ");
INSERT INTO cam_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ke e hegi ne telu pie: «É mu ko ade na geu haneéo? Kona geu pineuhi pie, wâé heme é pwo ni penem de Caa tong? É mu ko anaa, na woéo éni ha a mwa ten.» ");
INSERT INTO cam_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kehe icehi ana time lu uce temehi ana nimen me e pii telu. ");
INSERT INTO cam_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","É alecehen, ke lu mwojuia ngemwo me weeng ne Nazaret. Ke e te nihe piténede lu nyaa me caa ten. Ke wo nyaa ten, ke e te cile ne ha a pwonimen ati ni naado naa. ");
INSERT INTO cam_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ke piubwo da Iésu, ke ubwo mwo a bwo temehinaado ten. Ke nihe wâé te Padué nang, ke ni apulie mwo. ");
INSERT INTO cam_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","E tabuhi pipatemehi a pwooti te Padué wo Ioane, he caa 15 ni jo na e daame ubwo te lépwo Roma wo Tibère. Woélé-ni ni gupéno te daame Tibère nelang: Wo Ponce *Pilate, pa gupéno ne ha amu *Judé; Wo Érode Antipas ne Galilé; Wo Filip, pa ciéé *Érode Antipas, ne Ituré die Trakonite; Wo Lisanias, ne Abilène. ");
INSERT INTO cam_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ke wo Hanne me Kaïfe, ke lupwo *daame he lépwo apwoâpwailo. Ke é ha a benaamwon naa, ke e ko mu ha a da wo Ioane pali naî Zakari. Ke e paciheeng wo Padué beme e pipatemehi a pwooti ten. ");
INSERT INTO cam_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","E engen ati he ni piduaan ko a éémwa Ioridano, ke e patemehi te ni apulie pie: «Geé pininim, ke geé bitekewé. Ke geé pwo me puukewé, beme geé habwii pie pitaatééhi ni mulihewé. Be me wonaa, ke e bo pineuhi ni ta pwo tewé wo Padué.» ");
INSERT INTO cam_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Be caa tii ne ha a tii te péroféta Isaia pie: Pwo pa apulie ha a da na e toii da pie: “E âbé wo Padaame! Pwopweehi a pwaadeniin! Pwo me belece a duaan na e engen hen! ");
INSERT INTO cam_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Bo pa ni atebwolu, tatibe ni juwole me ni bwojuwole, pamwomwonihi ni acine pwaaden; pwopweehi a engen den. ");
INSERT INTO cam_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Lé bo alihi ne ni apulie ana e pwo wo Padaame: Be e âbé me celuimikenye!” Ésaïe 40.3−5 ");
INSERT INTO cam_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Hiwon ni apulie na lé âbé céii Ioane, beme e puulé ne ha a éémwa. Ke e pii te ni béén mu kolé pie: «Wogewé ni nahi bwien, me ni agele. Woo na e pii tewé pie, geé o cela ko ni cuhinaado na e bo ne tewé wo Padué? ");
INSERT INTO cam_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Geé mi pwo ce huô celi wâé, beme a béhabwiinen pie, geé caa taatééhi ni mulihewé! É mu ko ade na geé te niimihi pie, o celuimikewé mu ko ana wo *Abérama ke pa watihewé? Ûhu! Be é pii tewé pie: Mepie nime Padué, ke o te jan ne kon, me e bitehi ni péi ce, me ni piebehi Abérama! ");
INSERT INTO cam_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","«E caa te pwopweehi a gi ten wo Padué. Ke e bo tahagéi ne ko ni waan ati ni acuwo na time uce wâé ni acehin, ke e bo cini ne pwo miû!» ");
INSERT INTO cam_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Hiwon nina mu ko ni béén na lé téne Ioane, na lé tahimwoeng pie: «He ade aceli me geme pwo beme pitaatééhi ni muliheme?» ");
INSERT INTO cam_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ke e hegi ne telé pie: «Hemepie alo ce epwénem, ke go ne a céiu te pana tice ten. Ke é hemepie pwo ce wiinaado tem, ke go pati pana tice ten.» ");
INSERT INTO cam_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Pwo lépwo *atai mwani cuhi puni apulie, na lé âmwobé, beme e puulé wo Ioane. Ke lé tahimwoeng pie: «Pa apipune, ade aceli me geme pwo?» ");
INSERT INTO cam_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ke e hegi ne telé pie: «Me geé tai mwani *cuhi puni apulie beme de lépwo Roma ke geé nemwo uce pé ce mwani celi piwéden koja ni jéhi cuhi puni apulie.» ");
INSERT INTO cam_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ke pwo ni béé coda mwo na lé tahimwo Ioane pie: «Ke wogeme, ke o ade aceli me geme pwo?» Ke e hegi ne telé pie: «Geé necu ni bwopemikewé na ta ne ko ni apulie: Geé nemwo pwohuu telé, ke geé nemwo wâgo kolé me lé ne ce mwani tewé. Wâé heme geé ju pipwodéén cehi ko ni cuhikewé.» ");
INSERT INTO cam_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ati ni apulie, ke lé ucéihi ne ha a pipwodéén aceli e o bo tuie, ke lé pitahimwolé pie: «Wieli wo Ioane pa *Mesia?» ");
INSERT INTO cam_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ke e hegi ne telé ati pie: «Woéo, ke é puukewé ko a tabe. Kehe icehi ana wo pana e bo âbé alecehung, ke e bo puukewé ko a *Jenen Iitihi me a miû. Weeng, ke te junihe pwojunuun kojaéo. Ke time uce jan ne kong me é tuwo ni tai ko ni dihibwaan. ");
INSERT INTO cam_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ke e caa te mi pipwopweeng beme e tauti ni apulie. Ke e bo pineitééhi nina wâé jélé me nina ta jélé, pwohewii a bwo pineitééhi na a pidenaado koja a piin. Ke e ne ehi ni pidenaado, kehe e cini ni piin ne ha a miû na te tice paceli jan me e taunuhi!» ");
INSERT INTO cam_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Hiwon ni bwomunen na e pwo wo Ioane na wonaa, beme e pacihe a puapulie te lépwo *Juif me e pipatemehi telé a Pwooti Wâé. ");
INSERT INTO cam_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","E mu tee pii te gupéno Érode wo Ioane pie, time uce wâé a huô te Érode, be lu pimu me Érodiade, ê mwode pa âjiénen. Ke hiwon mwo ni béé naado na ta na e pwo wo Érode. ");
INSERT INTO cam_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ke é mu ko ana e pii wo Ioane, ke e neeng he karépu. Ke me wonaa, ke e ne behin mwo ko ni huô ten na nihe ta. ");
INSERT INTO cam_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","É ha a benaamwon na e puu ni apulie hen wo Ioane, ke e puu mwo Iésu. Ke é he e mwo ko pwoiitihi wo Iésu, ke e te tehi kuti a miiden. ");
INSERT INTO cam_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ke e te opé kuti ne huîin a Jenen Iitihi pwohewii a meni pwojo. Ke pwo a pwocihe bé mu he miiden, na e pii ten pie: «Wogo pa Naîng na te céiu go, na te nihe eânimung dem. Wogo kuti, na é caa pipégaliko ha a pwonimung.» ");
INSERT INTO cam_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","He ko 30 ngelang ni jo he Iésu, ke e tabuhi patemehi a Pwooti Wâé. Ne he ni bwo niimihinaado te ni béé apulie, ke te pa naî Josef pa naî Éli. Woélé-ni ni watihen: Wo Josef, pa naî Éli, ");
INSERT INTO cam_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","pa naî Matat, pa naî Lévi, pa naî Melki, pa naî Janaï, pa naî Josef, ");
INSERT INTO cam_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","pa naî Matatias, pa naî Amos, pa naî Nahoum, pa naî Esli, pa naî Nagaï, ");
INSERT INTO cam_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","pa naî Mahat, pa naî Matatias, pa naî Séméïn, pa naî Iosek, pa naî Ioda, ");
INSERT INTO cam_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","pa naî Ioanan, pa naî Résa, pa naî Zorobabel, pa naî Salatiel, pa naî Néri, ");
INSERT INTO cam_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","pa naî Melki, pa naî Adi, pa naî Kosam, pa naî Elmadam, pa naî Er, ");
INSERT INTO cam_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","pa naî Iéchoua, pa naî Éliézer, pa naî Iorim, pa naî Matat, pa naî Lévi, ");
INSERT INTO cam_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","pa naî Siméon, pa naî Juda, pa naî Josef, pa naî Ionam, pa naî Éliakim, ");
INSERT INTO cam_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","pa naî Méléa, pa naî Mena, pa naî Matata, pa naî Natan, pa naî *Davita, ");
INSERT INTO cam_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","pa naî Jessé, pa naî Obed, pa naî Booz, pa naî Sala, pa naî Nachon, ");
INSERT INTO cam_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","pa naî Aminadab, pa naî Admin, pa naî Arni, pa naî Esron, pa naî Pérès, pa naî *Juda, ");
INSERT INTO cam_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","pa naî Iakobo, pa naî Isaaka, pa naî Abérama, pa naî Téra, pa naî Nahor, ");
INSERT INTO cam_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","pa naî Seroug, pa naî Réhou, pa naî Péleg, pa naî Éber, pa naî Chéla, ");
INSERT INTO cam_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","pa naî Kénan, pa naî Arpaxad, pa naî Sem, pa naî Noé, pa naî Lémek, ");
INSERT INTO cam_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","pa naî Matusalem, pa naî Énoka, pa naî Iéred, pa naî Malalél, pa naî Kénan, ");
INSERT INTO cam_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","pa naî Énos, pa naî Set, pa naî *Adamu, pa bécéiuhe naî Padué ne éni pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","E mwojuia mwo wo Iésu mu ha a éémwa Ioridano. Ke he caa ju tilieng na a *Jenen Iitihi, ke e pééeng nge ha a melé. ");
INSERT INTO cam_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ke e mu lang wo Iésu he na 40 ni tan. Ke e pwo me tacebwénieng nelang wo *Caatana, pa apipé ne konye. Ke é ha a benaamwon naa, ke time e uce wiinaado, ke caa nihe menen. ");
INSERT INTO cam_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ke e â céiieng wo Caatana, ke e pii ten pie: «Hemepie wogo pa *Naî Padué, ke go taatééhi ni péi ce me pwoloa!» ");
INSERT INTO cam_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ke e pii ten wo Iésu pie: «Caa te tii ne he ni tii iitihi pie: Time e uce mulie cehi ko a pwoloa wo pa apulie.» ");
INSERT INTO cam_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ke e pééeng da pwo a juwole wo Caatana, ke e habwii ten, ha a cuwo benaamwon naa, ati ni amu me ni mwametau pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ke e pii ten pie: «É o bo ne tem *a wâé te ati ni mwametau ce, me ni pihuô, be caa ne tong, ke é o te ne te paceli te nimung me é ne ten. ");
INSERT INTO cam_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ke é bo tai ne tem ati, hemepie go tidihi jilim ne ânebuhung me go pipaunuéo.» ");
INSERT INTO cam_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ke e hegi ne ten wo Iésu pie: «Caa te tii ne he ni tii iitihi, pie: Go pipaunu Padaame Padué hem, ke te weeng cehi na me go penem den.» ");
INSERT INTO cam_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ke e pé Iésu nge *Iérusaléma. Ke e pééeng da pwo a puni a *mwaiitihi, ke e pii ten pie: «Hemepie wogo pa Naî Padué, ke go téele mu éni! ");
INSERT INTO cam_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Be caa te tii ne he ni tii iitihi pie: E bo pahede ni âcélo ten wo Padaame Padué, beme lé wéiko. ");
INSERT INTO cam_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ke lé bo hegiko, ke o time uce tanahi ni am ne ko ni péi.» Psaume 91.11−12 ");
INSERT INTO cam_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ke e hegi ne ten wo Iésu pie: «Ûhu, be caa te tii ne mwo he ni tii iitihi pie: Go nemwo tacebwéni Padaame Padué hem.» ");
INSERT INTO cam_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Heme e tacebwénieng ati wo Caatana, ke e engen kojaeng. Ke e ucéihi mwo ace céiu tan. ");
INSERT INTO cam_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","E mwojuia mwo ne ha amu Galilé wo Iésu, he caa ju tilieng na a Jenen Iitihi. Ke lé caa tabuhi pwojepule kon ne ha ati ni piduaan naa. ");
INSERT INTO cam_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ke e pacémuni ni apulie ne he ni *mwotapitihi te ni *Juif, ke lé nihe pipii me wâé nang. ");
INSERT INTO cam_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","E mwojuia mwobé wo Iésu ne Nazaret, he na ubwo nang ne hen. Ke é ha a *tan iitihi, ke e taa ha a mwotapitihi, pwohewii ana mu te cemang me e pwo. Ke e cuwoda me e pine ni tii iitihi. ");
INSERT INTO cam_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ke e ilehi koja pa céiu apenem a tii te péroféta Isaia. Ke e pale, ke e pipégali ni pwooti na e pine telé: ");
INSERT INTO cam_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","E kong a Jene Padaame. E neéo ngen, me é pé ngen: a Pwooti Wâé te nina tice delé; a bwo pawie ni apwocuhinaado; a bwo tehi ni naamii lépwo bwi; ke a bwo tuwo lépwona cielé. ");
INSERT INTO cam_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Weengi a benaamwon den me e pipatemehi a pipwoééhe ke a wâé te Padaame. Ésaïe 61.1−2 ");
INSERT INTO cam_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","E capipihi ali tii wo Iésu, ke e ne te mwo pali apenem, ke e tebwo. Ke lé te ju omeeng ati ne ni apulie na élé ha ali mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ke e pii telé pie: «Geé caa te téne nina e pipatemehi ne ni tii iitihi. Ke é jenaa, ke e caa pacuwohi ne ânebuhewé ati.» ");
INSERT INTO cam_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Lé picedi Iésu, me pii me wâé nang, be lé te junihe téetihi ni pwooti ten na pwojunuun. Kehe icehi ana é alecehen ke lé pipii telé pie: «É mu ko ade na e wonaa a bwo cihe ten? He te pa apulie pwohewiikenye. Be te pali naî Josef!» ");
INSERT INTO cam_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ke e hegi ne telé pie: «Geé caa te téne ni naado na é pwo ne Kapernaüm. Ke nimewé me é pwo mwo celi wonaa ne éni ha amu tong. «Wieli geé pii tong a ocine ce: “Dotéén, go te pipwo mwo me tieden a cunu kom!” ");
INSERT INTO cam_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","«Kehe icehi ana é pii tewé pie: “Au, mwolihi! Wo pa péroféta, ke time lé uce hegieng ehi ne ha amu ten.” ");
INSERT INTO cam_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","«Te a juuju, be pwohewii a benaamwon de péroféta *Élia. Be li time uce ute, ke pwo a menele na nihe ubwo ne ha ati ni amu, he na cié ni jo ke pwo a behin. Ke nihe hiwon ni depwele ne ha amu *Isaraéla na menelé. ");
INSERT INTO cam_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Kehe icehi ana time e uce ne ngen Élia wo Padué, beme e picani te êce céiu depwele ne Isaraéla, amu ten. Kehe e neeng nge pele ê céiu depwele ne ha a mwopopwaalé Sarepta, ne ha a céiu duaan ko a Sidon. ");
INSERT INTO cam_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","«Ke geé te niimi mwo péroféta Élisé. Be li e pwo me tieden a katia ko Naaman, pa apulie mu Siri. Kehe icehi ana nihe hiwon ni katia ne Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ke é he lé téne anaa wo lépwo apulie ne ha ali mwotapitihi, ke lé te nihe okéé ne ko Iésu. ");
INSERT INTO cam_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ke lé te cuwoda kuti, ke lé teuueng da pwo a juwole, he na e mu lang a mwopopwaalé telé, beme lé bo cibetééeng ole jeoté. ");
INSERT INTO cam_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kehe e te â ha awiemelé, ke e engen kojalé. ");
INSERT INTO cam_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","E tuie wo Iésu ne Kapernaüm ne Galilé, ke e taa ha a mwotapitihi, ha a céiu tan iitihi. Ke e pacémuni ni apulie ko a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ke lé téetihi a bwo cihe ten, be e te pacémunilé mu ha a pihuô na e te ne ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","É he e mwo ko cihe wo Iésu ke e taa ha a mwotapitihi wo pa apulie na pwo duéé kon. Ke e wiikau, ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Éé! Iésu mu Nazaret, te tice celi go pwo peleme! Go âbé pwotahi ne kome? É te temehiko, be wogo pa apulie na e pipégaliko wo Padué, ke e neko bé!» ");
INSERT INTO cam_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ke e te heni kuti ali duéé wo Iésu, ke e pii ten pie: «Go capuhi a pwom, ke go wie mu ko pa apulie naa!» Ke e tahi ole pali apulie na ali duéé, ne ânebuhe nina lé mu lang. Ke e wie mu kon, ke time e uce pwotahinaado ne kon. ");
INSERT INTO cam_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ke lé te nihe tai téetihi ne ni apulie, ke lé pitahimwolé pie: «He ade celi e ko pwo wo pa apulie ce? Be pwojunuu nina e pii. Ke e pihuôhi mwo ni duéé, ke lé pitabemieng, ke lé wie!» ");
INSERT INTO cam_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ke te piân a jepule ko Iésu, pitihi amu naa. ");
INSERT INTO cam_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","E wie mu ha a mwotapitihi wo Iésu, ke e â pele Simon Pétéru. Ke lé pii ten pie, te nihe cunu êgi mwaa Simon, be e pwopilijing. ");
INSERT INTO cam_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ke e âbé céiieng wo Iésu, ke e ole nge huîin. Ke e pwohuu te ali pilijing, ke te tieden kojaeng kuti. Ke e cuwoda wo ênaa, ke e pwo me lé wiinaado. ");
INSERT INTO cam_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","É he capéto ko a babwén, he caa nebwén a tan iitihi telé ke lé pébé céii Iésu ati ni cunu. Ke e ne ni in huîilé ati, ke te muko tieden kuti ni cunu kolé. ");
INSERT INTO cam_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ke lé wie mwo ni duéé, he lé cihe da ko miiden ko pii pie: «Wogo ke pa Naî Padué!» Kehe icehi ana e cihe me mwoiu ne kolé, ke time e uce nelé me lé patemehieng. Be lé caa temehi pie, weeng pa *Mesia. ");
INSERT INTO cam_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","É ha acaama hen, ke e engen wo Iésu, ke e â ha a céiu duaan na ticie hen. Kehe icehi ana lé haneeng ne ni apulie, beme lé ileeng pie, me e mwo mu pelelé. ");
INSERT INTO cam_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ke e hegi ne telé pie: «Ûhu. Be wâé heme é pipatemehi mwo a Pwooti Wâé ne he ni béé mwopopwaalé. Be weengaa a watihen me é opé.» ");
INSERT INTO cam_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ke e â pitihi a *Judé, ke e pipatemehi a Pwooti Wâé ne he ni mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","É ha a céiu tan, ke e mu jeoté ticepwon ne Galilé wo Iésu. Ke e patemehi a pwooti te Padué. Ke hiwon ni apulie na lé tebwo aujenieng, beme lé tabemieng. ");
INSERT INTO cam_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ke e alihi lupwo ong na lu ko mu jeoté ha a tabe mwonuhi ticepwon. Be lé caa ole mu pwon wo lépwo apwotau, ke lé ko puu ni pua telé. ");
INSERT INTO cam_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ke e taa pwo a céiu ong, a onge Simon Pétéru. Ke e pii ten pie: «Go picéi oté ali ong.» Ke e tebwo, ke e pacémunihi mwo ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ke me e cihe ati, ke e pii te Simon me ni béén pie: «Geé taabé me genye te ju piole he na numwihi lang. Ke geé bwobe ne ni pua tewé.» ");
INSERT INTO cam_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ke e hegi ne ten wo Simon pie: «Pa apipune, go téne, geme tee ko pwotau jame a bwén ce, ke te tice celi geme pé. Kehe icehi ana é mu ko ana go pii teme, ke é o pwo.» ");
INSERT INTO cam_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ke lé patupwo li pua telé. Ke te nihe hiwon kuti ni ikua na lé cuwo hen, ke pwo me e tie li pua telé. ");
INSERT INTO cam_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ke lé pwo inenaado nge céii ni béélé na lé mu pwo a céiu ong, beme lé âbé picani telé. Ke oba lupwoli ong ko ikua, ke lu pwo me lu mwiiê. ");
INSERT INTO cam_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Ke te junihe mwotilé ati ko ana e tuie: wo Simon Pétéru, me Cang me Ioane (lupwo naî Zébédé) me ati ni béélé. Ke e tupwo tidihi jilin ânebuhe Iésu wo Simon, ke e pii pie: «Padaame, go piâdé ité kojaéo, be woéo, ke pa apulie na ta jo!» Kehe e pii ten wo Iésu pie: «Go nemwo pwo me mwotiko! Tabuhi jenaa, ke bo wogo pa apwotauhi apulie.» ");
INSERT INTO cam_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ke lé mwojuia daamwo ticepwon, ke lé céida huâiu lupwoli ong. Ke lé necu ati, ke lé âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","É he e mu ha a céiu mwopopwaalé wo Iésu, ke e tuiebé wo pa céiu katia. Ke me e ali Iésu, ke e tidihi jilin me pimiibule ne ânebuhen, ke e ilehi kojaeng pie: «Padaame, hemepie te nimem, ke go pwo me tieden a katia kong!» ");
INSERT INTO cam_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ke e cine ngen a in, ke e ti kon, ke e pii ten pie: «Éa, te nimung! Caa wâé go!» Ke te tieden kuti kojaeng a katia kon. ");
INSERT INTO cam_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ke e pii ten pie: «Go nemwo uce uti, kehe go â pihabwiiko ne te pa *apwoâpwailo. Ke go ne te Padué ali âpwailo li e pii wo *Moosé ne he li patén den. Be me wonaa, ke me lé alihi ati ne ni apulie pie caa wâé go.» ");
INSERT INTO cam_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kehe icehi ana caa piân a jepule ko Iésu. Ke nihe hiwon nina lé âbé céiieng me lé téneeng, me ilehi kojaeng pie, me e pwo me tieden ni cunu kolé. ");
INSERT INTO cam_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kehe e mu â he ni duaan na te ticie hen, beme e pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","É ha a céiu tan, ke e pacémuni ni apulie wo Iésu. Ke lé tabemieng ni béé *Farasaio me ni *dotéén ko patén, na lé âbé céiieng mu he ni mwopopwaalé mu Galilé, me *Judé, me *Iérusaléma. Ke e mu ko Iésu a junuu Padaame Padué, beme e pwo me wâé nina cunu jélé. ");
INSERT INTO cam_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ke lé tuiebé ni béé apulie he lé pipaadoimi pa céiu béélé ne pwo apule ten, pana tebwomwa nang. Be nimelé me lé pééeng da huâ, me neeng ânebuhe Iésu. ");
INSERT INTO cam_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Kehe icehi ana tice ace bwopwonen, be junihe hiwon ni apulie. Ke lé pééeng da pwo mwa, ke lé tapwii a céiu duaa mwa. Ke lé neeng ole ne pwo apule ten ne ânebuhe Iésu me ni apulie na élé aujenieng. ");
INSERT INTO cam_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ke e téetihi a céihi telé wo Iésu. Ke e pii te pali tebwomwa pie: «Pa bééng, caa pineuhi ni ta pwo tem.» ");
INSERT INTO cam_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wo lépwo Farasaio me ni dotéén ko patén, ke lé pipii telé pie: «Wooélé pa apulie ce? Be e pwo me piwielu me Padué, me piciheta ne ko a niin! Be he wooélé na e temehi me e pineuhi ni ta? Te icehi Padué!» ");
INSERT INTO cam_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kehe icehi ana e te temehi wo Iésu nina lé niimihi, ke e pii telé pie: «É mu ko ade na wonaa ni pwonimewé? ");
INSERT INTO cam_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ade aceli piticecoon? Me é pii ten pie: “Caa pineuhi ni ta pwo tem”, ai me é pii ten pie: “Go cuwoda, ke go engen”? ");
INSERT INTO cam_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ke hemepie jan me é pwo me e engen ne ânebuhewé ati ke geé bo temehi pie, pwo mwomwon dong, woéo pa *Nahi Apulie, me é pineuhi ni ta pwo te ni apulie ne pwo a bwohemwo.» Ke e pii te pali tebwomwa pie: «Aje, go cuwoda, ke go pé apule tem, ke go âmwo pelem.» ");
INSERT INTO cam_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ke e te cuwoda kuti ne ha awieme ni apulie. Ke e pé apule ten, ke e âmwo pelen, he e pipwoun de Padué. ");
INSERT INTO cam_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ke lé nihe téetihi ati ne nina lé alihi anaa. Ke te junihe mwotilé, ke lé pii éwaanihi telé pie: «Éé! Te nihe ité kuti nina nye alihi jenaa!» Ke lé pipwoun de Padué. ");
INSERT INTO cam_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","É alecehen, ke me e â he pwaaden wo Iésu, ke e ali Lévi (Mataio), pa *atai mwani cuhi puni apulie me de lépwo Roma he e teko tebwo ha a mwopenem den. Ke e pii ten wo Iésu pie: «Go âbé céing!» ");
INSERT INTO cam_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ke e te cuwoda kuti wo Lévi, ke e necu ati, ke e âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ke é alecehen, ke e pwo a piwiinaado na ubwo wo Lévi ne pelen, beme e pipwoun de Iésu. Ke e tode mwo lépwo atai mwani béén, ke hiwon mwo ni béé apulie. ");
INSERT INTO cam_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ke lé mu lang mwo wo lépwo Farasaio ke ni béélé, lépwo dotéén ko patén. Ke lé tai pihuu ne ko lépwo *acémun de Iésu, ke lé pii telé pie: «É mu ko ade na geé piwiinaado me ûdu me lépwo atai mwani, ke ni béé apulie na ta jélé?» ");
INSERT INTO cam_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ke e pii telé wo Iésu pie: «Time lé uce hane ce dotéén wo lépwona te wâé jélé, kehe te icehi lépwona cunu jélé. ");
INSERT INTO cam_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Be time é uce âbé tode nina lé niimihi pie wâé ni mulihelé. Kehe é âbé tode nina lé temehi pie ta ni mulihelé, beme lé bitelé, ke me lé pitaatééhi ni mulihelé.» ");
INSERT INTO cam_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lé pii te Iésu ne ni béé Farasaio pie: «Geme te cuwo ko *pipaciile, wogeme ni Farasaio, me lépwo acémun de *Ioane pa apipuu apulip. Be geme patupwo wiinaado beme geme pwoiitihi. Kehe é mu ko ade na time lé uce pipaciile wo lépwo acémun dem?» ");
INSERT INTO cam_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ke e hegi ne telé pie: «Kona lé te pipatupwo wiinaado wo lépwona todelé ne ko a piaten, heme e mwo teko mu pelelé wo pa apiaten? Ûhu! ");
INSERT INTO cam_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kehe e o bo âbé a tan na o bo pé kojalé pa apiaten. Ke é mulang na lé o bobe pipaciile.» ");
INSERT INTO cam_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ke e pii telé mwo a ocine ce wo Iésu pie: «Te tice pace céiu apulie celi e tie ace me-epwén celi mwo ju wamin, me e woli ne ko a epwén na caa ukéiu. Be o bo tie ali epwén li mwo ju wamin! A céiu mwo: Ke time uce piwie lupwo memwaanu ne ko a epwén, be caa ukéiu. ");
INSERT INTO cam_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","«Geé niimihi a *mwotabe na pwo ko iiwota. Be time nye uce pé ace tabe megele celi mwo coho, me nye pa a mwotabe na caa ukéiu. Be pwocoon me cibu, ke e bo pabuwohi, ke genye o patieden a tabe megele me ni mwotabe. ");
INSERT INTO cam_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ûhu! Wâé heme nye ne a tabe megele na mwo coho, ne ha a mwotabe na mwo coho! ");
INSERT INTO cam_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kehe icehi ana wo lépwona lé mu ûdu ni tabe megele na caa ukéiu, ke muhi telé ko ni tabe megele na mwo ju coho. Be lé pii pie: “Nihe wâé a neme ni tabe megele na caa ukéiu!”» ");
INSERT INTO cam_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","É ha a céiu *tan iitihi, ke lé uti a pwaaden na e pitahagéi nge he ni apwoamu wo Iésu me lépwo acémun den. Ke é nge he pwaaden, ke lé tabwo ni ace blé wo lépwo acémun den. Ke lé elelehi ne he ni ilé, ke lé wii ni piden. ");
INSERT INTO cam_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ke lé pii telé wo lépwo béé *Farasaio pie: «Lépwoje, é mu ko ade na geé pwo anaa? A naado na paciitihi ha a tan iitihi!» ");
INSERT INTO cam_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ke e hegi ne telé wo Iésu pie: «Kona time geé mu uce pine ne he ni tii iitihi, ana e pwo wo pa daame *Davita? Be é ha a céiu tan, ke menelé, woélé me ni béén. ");
INSERT INTO cam_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ke e taa ha a mwaiitihi na pwo ko mwaanu. Ke e pé ni pwoloa na ne me de Padué, ke e eni. Ke e ne me lé eni mwo wo lépwo béén. Kehe ni pwoloa naa, ke te ni *apwoâpwailo cehi, na pwo mwomwon delé me lé eni.» ");
INSERT INTO cam_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ke e pii telé mwo wo Iésu pie: «Woéo, pa Nahi Apulie, ke pa eapwihi a tan iitihi.» ");
INSERT INTO cam_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","É ha a céiu tan iitihi, ke e taa ha a *mwotapitihi wo Iésu, ke e pacémuni ni apulie. E mu lang mwo wo pa apulie na mele a in ne pwo jui. ");
INSERT INTO cam_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ke lé te ju ome Iésu wo lépwo *dotéén ko patén me lépwo Farasaio, beme lé alihi pie, he e o te pwo me wâé pa apulie naa, ha a tan iitihi? Be lé hane ace bwopwonen me lé bo pipé ne kon. ");
INSERT INTO cam_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kehe e te temehi ni âniimihinaado telé wo Iésu, ke e pii te pali cunu pie: «Go cuwoda, ke go âbé éni, ânebuhe ni apulie ati!» Ke e cuwoda wo paje ke e âbé céii Iésu, ne ânebuhe ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ke e pii wo Iésu te nina lé mu lang pie: «Woté? He te ne me pwo ana wâé ha a tan iitihi, ai ana ta? Me celuimi a mulip, ai me taunuhi?» ");
INSERT INTO cam_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ke e te ju ome taatéélé wo Iésu. Ke e pii te pali apulie pie: «Go cinebé a im!» Ke e cine ngen a in, ke caa te wâé mwo kuti. ");
INSERT INTO cam_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ke lé te nihe okéé kuti wo lépwo Farasaio me lépwo dotéén ko patén. Ke lé picihe ko aceli me lé pwo te Iésu. ");
INSERT INTO cam_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","É ha a céiu tan, ke e taa pwo juwole wo Iésu. Ke e pwoiitihi te Padué jame a bwén. ");
INSERT INTO cam_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","É pwopwometan, ke e tode ati nina lé mu âcéin. Ke e bwo pipégali mu pelelé lépwo apulie na 12 jélé, ke e ne ni niilé pie *apostolo: ");
INSERT INTO cam_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Woélé-ni: Simon (e ne me a niin wo Iésu pie Pétéru); André, pa ciéén; Cang; Ioane; Filip; Bartélemi; ");
INSERT INTO cam_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mataio; Toma; Cang, pa naî Alfé; Simon, pa Zélote; ");
INSERT INTO cam_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Jude, pa naî pa céiu apulie na pii kon pie Cang; Judas Iscariot, pana e bwo icu Iésu. ");
INSERT INTO cam_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Lé mwojuia mwo mu pwo juwole wo Iésu me ni 12 apostolo ten. Ke lé cuwo ha a duaan na te ju pule ehi. Ke hiwon ni apulie na lé âbé céiilé. Be wo lépwo béén na lé mu âcéi Iésu, me ni béé apulie mu *Iérusaléma, ke é mu ati ha amu *Judé, ke é pejié mwonuhi lupwo pwomwo ubwo Tir me Sidon. ");
INSERT INTO cam_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Be lé tai âbé beme lé tabemi Iésu, ke me e pwo me tieden ni cunu kolé. Ke e peni ni duéé na hiwon mu kolé. ");
INSERT INTO cam_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ke hiwon nina lé hane me lé ti kon. Be pwo a *pipwojunuun na e wie mu kon, ke te tai tieden ni cunu kolé. ");
INSERT INTO cam_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","E biteeng wo Iésu nge céii lépwo acémun den, ke e pii telé pie: «Adéikewé, wogewé na tice dewé, be o bo a dewé a *Mwametau te Padué! ");
INSERT INTO cam_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Adéikewé, wogewé na mwo menewé jenaa, be o bo pwoluu gewé! Adéikewé, wogewé na geé é jenaa, be geé o bo piap. ");
INSERT INTO cam_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Adéikewé heme lé téétikewé, me muhi telé kowé, me lé pihoonikewé, me lé pii me ta gewé, mu ko ana wogewé, ke wo lépwo apulie tong, woéo pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Be lé te wonaa te lépwo péroféta wo lépwo watihelé. Ke é pii tewé pie: Geé pipwodéén, me piwâénimewé, be o ubwo a cemewé ne jeda he miiden* ko ni penem dewé!» ");
INSERT INTO cam_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","«Weengi ni pwooti tong ne kowé wogewé na pwo dewé: O bo pwo ni picani me ni téé ne kowé. Be ni naamuuwé, ke o caa te ninaa kuti ni ja ko ni pipwodéén dewé. ");
INSERT INTO cam_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O bo pwo ni picani me ni téé ne kowé, wogewé na pwoluu gewé. Be o bo menewé. O bo pwo ni picani me ni téé ne kowé, wogewé na geé pipwodéén jenaa. Be geé bo é me pihemun. ");
INSERT INTO cam_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","O bo pwo ni picani me ni téé ne kowé, wogewé na lé pii me wâé gewé ne ni apulie. Kehe time uce a bwopiinen pie wâé gewé! Be o junihe ubwo ni cuhinaado tewé koja lépwo péroféta agele li lé nihe pii me ubwo jélé wo lépwo apulie.» ");
INSERT INTO cam_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«É pii tewé, wogewé na geé tabemiéo pie: Geé pwo me eânimewé te nina lé téétikewé, ke geé pwo nina wâé ne ko nina muhi telé kowé. ");
INSERT INTO cam_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ke geé *adéi nina lé piapwokewé, ke geé pwoiitihi me de nina lé pii me ta gewé. ");
INSERT INTO cam_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ke mepie e ahi a céiu kwoom wo pace céiu apulie, ke go ne ten mwo a céiu. Ke hemepie e pé ace palito tem, ke go ne ten mwo a cimii tem. ");
INSERT INTO cam_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ke é hemepie e ilehi kojako ace céiu naado wo pace céiu apulie, ke go ne ten. Ke é hemepie e pé ace dem, ke go nemwo ilehi mwo kojaeng. ");
INSERT INTO cam_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","É pii tewé mwo pie: Go pwo ne te ni béén ce naado celi nimem me lé pwo ne tem.» ");
INSERT INTO cam_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","«Be mepie te ju eânimem cehi te nina eânimelé tem, ke kona é mu ko ade na go uce ucéihi ace cemem koja Padué? Be lé te wonaa mwo wo lépwo apulie ta. ");
INSERT INTO cam_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ke hemepie go pwo nina wâé te nina lé pwo ana wâé tem, kona é mu ko ade na go ucéi ace cemem? Be lé te wonaa mwo wo lépwo apulie ta. ");
INSERT INTO cam_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ke é hemepie go te ne mwani cehi te ni béén na lé bo wodehi ne tem, ke é ko ade na go ucéihi ace cemem? Be lé te wonaa mwo wo lépwo apulie ta. ");
INSERT INTO cam_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","«Geé téne! Geé pwo me eânimewé te nina lé téétikewé. Ke geé pwo celi wâé ne ko ni apulie, ke geé ne telé me piticenaado ne kon. Be mepie geé wonaa, ke o nihe ubwo ce cemewé celi e bo ne tewé wo Padué, ne he miiden. Be geé habwii ne he ni bwomu tewé pie wogewé, ke ni ju naîn. Be weeng, ke te eânimen de lépwona time lé uce pwo-olé ten, me lépwona lé pwo nina ta. ");
INSERT INTO cam_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Wâé heme go pipwoééhe pwohewii pa Caa tem, be e pipwoééhe.» ");
INSERT INTO cam_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Geé nemwo tauti ni béén, ke o time e uce tautikewé wo Padué. Geé nemwo pwo me lé pwocuhinaado wo lépwo béén, beme time geé uce pwocuhinaado. Ke mepie geé pineuhi ni ta pwo telé, ke weeng, ke e o pineuhi ni ta pwo tewé. ");
INSERT INTO cam_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Geé ne, be e o bo ne tewé mwo wo Padué. Ke o te piubwo a ja kon ne tem mwo. Ke geé bo hegi ni naado na pieda ke nina nihe piwéden. Be e o bo ne tem pwohewii a bwo ne nen dem ne te lépwo béén.» ");
INSERT INTO cam_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ke e pii telé a ocine ce wo Iésu, pie: «Kona wo pa bwi, ke o te jan ne kon me e pé pace céiu bwi? Ûhu! Be lu o tai tupwo ne ha ace pwon! ");
INSERT INTO cam_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ke é pii tewé pie: Wo pa acémun, ke time e uce piwéden koja pa apacémunieng. Kehe icehi ana mepie e nihe cémun ehi, ke e bo pwohewii pa apacémunieng. ");
INSERT INTO cam_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","«Go te ju alihi ehi a meté na e hamii pa âjiénem, kehe time go uce alihi a ba-acuwo na ubwo na e hamiim! Ke go woté ko ace bwopiinen de pa béém pie: “Go ne me é pétaabwon a meté na e hamiim”? «Wogo, ke pa apipulekenye, kehe bwi go! Go mi pétaabwon a ba-acuwo na ubwo na e hamiim! Ke é mulang, ke go bwobe ali ehi ace bwo pétaabwon na a meté na e hamii pa âjiénem.» ");
INSERT INTO cam_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«A acuwo na wâé, ke pwocoon me e ne ce acehin celi ta. Ke a acuwo na ta, ke pwocoon me e ne ce acehin celi wâé. ");
INSERT INTO cam_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Be genye alihi temehi a acuwo mu ko ni acehin. Be time genye mu uce tabwo ace majing mu ko ace éé muceni! Ke time genye mu uce tabwo ace tabe megele mu ko ace acuwo celi pwo dan. ");
INSERT INTO cam_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ni naado na wâé, ke e âbé mu ko pa apulie na wâé nang, be wâé a pwonimen. Kehe ni naado na ta, ke e âbé mu ko pa apulie na ta nang, be ta a pwonimen. Be genye cihe mu ko nina e mu he ni pwonimenye.» ");
INSERT INTO cam_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«É mu ko ade na geé tee pii pie: “Padaame, Padaame!”, he time geé uce piténedeéo? ");
INSERT INTO cam_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Geé téne a ocine ce: «Pa apulie na e téne ati ni pwooti tong, ke me e piténedeéo, ");
INSERT INTO cam_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ke e pwohewii pa apulie na e pwo a mwa ten. Ke e ini ole die ko a péi, beme e ne pwon a mwa ten. Ke me ujaa, ke me e téte a tabe ne ko ali mwa, ke time e uce tanahi, be e bahi ne pwo a péi. ");
INSERT INTO cam_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kehe wo pana e téne ni pwooti tong, ke me time e uce ténedehi, ke e pwohewii pa apulie na e pacuuli a mwa ten, ke time e uce ne ace paan. Ke me e âbé a jaa, ke me e ti ko ali mwa, ke e te tupwo kuti, ke e te tanahi ati.» ");
INSERT INTO cam_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","É heme e ko pii ati ninaa wo Iésu te ni apulie, ke e mwojuia ngemwo Kapernaüm. ");
INSERT INTO cam_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ke pwo pa céiu caa te coda roma na e mu lang, ke pwo pa apenem den na te nihe ubwo a pwonimen kon, ke nihe cunu nang, ke e caa pwo me e mele. ");
INSERT INTO cam_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ke me e téne a jepule ko Iésu, ke e ne nge céiieng ni béé apulie na piubwo jélé ne pele lépwo Juif, beme lé ilehi kojaeng pie, me e pwo me tieden a cunu kon. ");
INSERT INTO cam_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ke lé â too Iésu wo lépwonaa, ke lé wâgo kon me e picani te pali caa te coda, ke lé pii ten pie: «Go téne go Padaame, wo panaa, ke pa apulie na nihe wâé nang, ke wâé heme go picani ten. ");
INSERT INTO cam_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Be e pipwoééhe a bele tenye wogenye lépwo *Juif die ko ana e pwo a *mwotapitihi tenye.» ");
INSERT INTO cam_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ke e âcéilé wo Iésu. Kehe me lé âmwonuhi ali pomwa te pali caa te coda, ke e nebé céii Iésu ni béén, beme lé pébé céiieng a pwooti ten ce: «Go téne go Padaame, time uce jan ne kom, me go tuie nge ha a pomwa tong, be te junihe pwonaado ne kom. ");
INSERT INTO cam_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ke time uce jan ne kong mwo me é âdé céiiko. Wâé heme go ju pii ace pwooti, ke o tieden a cunu ko pa apenem dong. ");
INSERT INTO cam_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Be woéo, ke é piténede pa apihuô tong, ke é uce pihuô te ni coda. Ke me é pii te pace céiu pie, me e ân, ke e ân. Ke me é pii te pace céiu pie: “Go âbé!”, ke e âbé. Ke me é pii te pa apipenem dong pie: “Go pwo ani!”, ke e te pwo.» ");
INSERT INTO cam_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ke e te junihe téele wo Iésu, ke e picedi pali caa te coda. Ke e biteeng nge céii ni apulie na nihe hiwon jélé na lé âcéin. Ke e pii telé pie: «Geé te ju tabemi ehi: Time é uce téele too pace apulie celi ubwo ace céihi ten pwohewii paje, ke piwien mwo ne ha a bele te Padué, *Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ke heme lé mwojuia ngemwo pele pali caa te coda wo lépwoli béén, ke lé too pali apenem den he caa wâé nang mwo. ");
INSERT INTO cam_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","É alecehen, ke e engen wo Iésu nge ha a mwopopwaalé na pii kon pie Naïn. Ke lé âcéin ni acémun den, me ni béé apulie na hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","É heme lé tuie nge ha a pomwa ko ali mwopopwaalé, ke lé too ni apulie he lé ko pipaadoimi nge he iitihi pa apulie na e caa mele. Pana te céiu nang ne te nyaa ten, êgi depwele. Ke hiwon ni apulie na lé âcéilé. ");
INSERT INTO cam_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ke me e alieng wo Padaame, ke te nihe ubwo a bwo pwoééhen, ke e pii ten pie: «Êje, go nemwo é.» ");
INSERT INTO cam_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ke e gaaté, ke e ti ko ali piélele. Ke lé cuwo wo lépwoli lé pé. Ke e pii te pali amele pie: «Aje, é pii tem pie: Go ûmiê!» ");
INSERT INTO cam_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ke e te caama tebwo kuti, ke e cihe! Ke e neeng ole wo Iésu, ke e neeng de céii nyaa ten. ");
INSERT INTO cam_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ati nina lé mu lang, ke te nihe mwotilé, ke lé picedi Padué. Ke lé pipii telé pie: «E opé penem pelenye wo Padué! Be e nebé céiikenye pa céiu péroféta ten, na nihe ubwo nang.» ");
INSERT INTO cam_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ke lé piuti nina e pwo wo Iésu ne ha ati ni piduaan ne ko a *Judé. ");
INSERT INTO cam_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Wo lépwo acémun de Ioane pa apipuu apulie ke lé uti ten ati nina e pwo wo Iésu. Ke e tode lupwona alo julu wo Ioane, ");
INSERT INTO cam_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ke e nelu nge céii Padaame Iésu, beme lu tahimwoeng pie: «He caa te wogo kuti pali *Mesia li me e bo tuiebé? Ai, me geme mwo te ucéi pace céiu mwo?» ");
INSERT INTO cam_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","21","Ke lu engen, ke é he lu tehene nge pele Iésu, ke lu alihi pie, e pwo me tieden ni cunu ko ni béé apulie. Ke e pawiehi ni duéé, ke e pwo me lé niê mwo ni béén na bwi jélé. Ke lu pii ten pie: «E nekemu bé céiiko wo Ioane, beme gemu tahimwoko pie: Caa te wogo kuti pali Mesia li me e bo tuiebé? Ai, me geme mwo te ucéi pace céiu?» ");
INSERT INTO cam_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ke e hegi ne telu pie: «Geu mwojuia mwo me geu â piuti te Ioane nina geu alihi, me nina geu téne. Be lé caa niê mwo wo lépwo bwi; ke lé caa engen ehi wo lépwo tebwa; ke caa wâé mwo wo lépwona katia jélé; ke lé caa téne mwo wo lépwona bwéjé jélé; ke lé caa mulie cemwo wo lépwo amele; ke lé caa hegi a Pwooti Wâé wo lépwona tice delé! ");
INSERT INTO cam_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","*Adéi pana e alihi temehiéo, me céihi ne kong!» ");
INSERT INTO cam_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","É heme lu caa mwojuia mwo wo lupwoli acémun de Ioane, ke e pii wo Iésu te ni apulie na lé mu lang pie: «É he li geé â ha a da me geé téne Ioane ke he ade aceli geé â alihi? Pa apulie na pipwoééhen na e pwohewii a womeéle celi e papenemihi na a dan? ");
INSERT INTO cam_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ûhu! Ke kona he ade aceli geé â alihi? Pace céiu apulie celi e cuwohe ace epwén celi nihe wâé? Ûhu! Wo lépwona lé wonaa, ke nina lé mu he ni pwomwo he daame, ke nihe hiwon ni naamuulé. ");
INSERT INTO cam_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Te ade aceli geé â alihi? Pace céiu péroféta? Éa, ke é pii tewé pie: Wo panaa, ke pa péroféta ubwo! ");
INSERT INTO cam_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Be te wo Ioane kuti na e piieng wo Padué ne he ni tii iitihi pie: É bo neole pa apipépwooti tong. E bo ânebuhem, me e pwopweehi a pwaadeniim. Malachie 3.1 ");
INSERT INTO cam_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«Geé téne ehi: Te tice pace apulie pwo bwohemwo celi e piwéden koja *Ioane pa apipuu apulie. Kehe icehi ana é pii tewé pie: Wo pana nihe wahin nang ne ha a *Mwametau te Padué, ke nihe pieda koja Ioane.» ");
INSERT INTO cam_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Lé téne anaa wo lépwo *atai mwani cuhi puni apulie, ke ni béén mwo, ke lé caa tai alihi pie, wo Padué, ke wâé nang ke mwomwon nang. Ke lé â céii Ioane beme e puulé. ");
INSERT INTO cam_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kehe icehi ana wo lépwo *Farasaio, me lépwo *dotéén ko patén, ke time lé uce piténedehi ana nime Padué me lé pwo, be muhi telé me lé â céii Ioane me e puulé. ");
INSERT INTO cam_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ke e pii mwo wo Iésu pie: «É bo pipwohewii ne ko ace de ni apulie jenaa? ");
INSERT INTO cam_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Lé pwohewii ni cuwo nahi ewa na lé pidaataa ha apimu te ni apulie. Be muhi te ni béén me lé jele me ni béélé. Ke lé pii telé ne ni béélé pie: “Geme cuu oopwé tewé, ke time geé uce pwolu. Ke geme pwo a nyebi ko mele, ke time geé uce é!” ");
INSERT INTO cam_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«Be e tuiebé wo Ioane pa apipuu apulie, ke time e uce eni pwoloa, ke time e uce ûdu tabe megele, ke geé pii pie “Pwo duéé kon!” ");
INSERT INTO cam_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","«Ke é tuiebé, woéo pa Nahi Apulie, ke é wiinaado me ûdu pwohewii ni béén. Ke geé pii pie: “Wo paje, ke te nihe pa aûdu, ke pa awiinaado! Ke e pabéé ni atai mwani, me ni béé apulie na ta jélé.” ");
INSERT INTO cam_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","«Ke a juuju ana nye mu pii pie: “Nye alihi a pitemang ne he ni bwomu te nina lé mulie ha a pitemang.”» ");
INSERT INTO cam_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","É ha a céiu tan, ke e tode Iésu wo pa céiu Farasaio beme lé piwiinaado. Ke é he lé mwo ko tebwo pwo taap, ");
INSERT INTO cam_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ke e tuiebé ê céiu toomwo pwopwaaden, be e téne pie, e lang wo Iésu. E pébé a mwotabe péi na oba ko tabe ûde. ");
INSERT INTO cam_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ke e tidihi jilin me pimiibule ne ânebuhe Iésu, ke e é. Ke tée ni tabehaamiin ne pwo lupwo a Iésu, ke e tahi ko ni apunin. Ke e mwomwaauhi ni a Iésu, ke e céihi ne pwon ali tabe ûde. ");
INSERT INTO cam_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Me e alihi anaa wo pali eapwihi pwomwo, pali Farasaio, ke te junihe muhi ten, ke e niimihi pie, ‘Mepie pa céiu péroféta wo paje, ke e o te temehi pie ê toomwo ce, ke ê toomwo pwopwaaden.’ ");
INSERT INTO cam_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kehe icehi ana e te temehi âniimihinaado ten wo Iésu, ke e pii ten pie: «Go téne, go Simon, be pwo ana nimung me é pii tem!» Ke e hegi ne ten wo paje pie: «Go cihe!» ");
INSERT INTO cam_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ke e pii ten wo Iésu a ocine. «E bwo mu wo pa céiu apulie. Ke pwo lupwo alo apulie na lu pwo kérédi ten, be wo pa céiu, ke 500000†, ke wo pa céiu ke 50000. ");
INSERT INTO cam_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","«Kehe icehi ana time uce jan me lu pwocuhin. Ke e pii telu pie: “Caa wâé! Geu necu ni kérédi teu.” Ke e tai pineulu die ko ni kérédi telu.» E panebwénihi a ocine ten wo Iésu, ke e tahimwo Simon, pali Farasaio, pie: «Wooélé mu ko lupwonaa, na e junihe alihi a bwo wâé pali eapwihi mwani?» ");
INSERT INTO cam_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ke e hegi ne ten wo Simon pie: «Wieli wo pali nihe hiwon ni kérédi ten.» Ke e pii ten wo Iésu pie: «Go juuju.» ");
INSERT INTO cam_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","46","Ke e biteeng wo Iésu nge céii êgi toomwo, ke e pii te Simon pie: «Aje, heme é taabé éni ha a pomwa tem, ke time go uce pwopweehi ne kong pwohewii ana nye mu te pwo. Be time go uce ne ace tabe me a bépuu ne ni ang. Ke time go uce céihi tabe ûde ne pwo a puning. Kehe go te ali ê toomwo ce? Tabuhi he li e taabé éni, ke time e uce cuwo ko a bwo pwo ne nina wâé. Be e puu ni ang ko ni tabehaamiin, ke e tahi ko ni apunin. Ke e céihi a tabe ûde na te junihe ubwo a cuhin ne pwo lupwo ang. ");
INSERT INTO cam_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Be nihe ubwo a pipwoééhe ten, be nihe hiwon ni ta pwo ten na caa pineuhi. Kehe go téne, wo pa apulie na time uce pineuhi ni ta pwo ten na hiwon, ke time uce ubwo ne kon a pipwoééhe.» ");
INSERT INTO cam_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ke e pii te êgi toomwo pie: «Êje, caa pineuhi ni ta pwo tem.» ");
INSERT INTO cam_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ke wo lépwona lé teko tai tebwo pwo taap me weeng, ke lé pipii telé pie: «Wooélé pa apulie ce, na jan me e pineuhi ni ta?» ");
INSERT INTO cam_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ke e pii te êgi toomwo wo Iésu pie: «Adéiko go êje! E caa celuimiko na a céihi tem! Ke go engen, be e bo mu pelem a péém.» ");
INSERT INTO cam_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","É alecehen, ke lé engen wo Iésu me lépwo 12 acémun den, ke lé â nge he ni pwomwo ubwo me ni mwopopwaalé. Ke e patemehi ngelang a Pwooti Wâé ko a Mwametau te Padué. ");
INSERT INTO cam_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Pwo mwo ni toomwo na lé âcéi Iésu: wo léli toomwo li e pwo me tieden ni cunu kolé, me pawiehi mu kolé ni duéé: Wo Maria mu Magdala li e pawiehi mu kon ni duéé li 7; ");
INSERT INTO cam_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Wo Jeanne, êgi mwode Chuza, pa caa te lépwo apipenem de pa daame *Érode; Wo Suzane; Hiwon mwo ni toomwo na lé mu ne mwani me ni delé, beme ni bépicani te Iésu, me ni acémun den. ");
INSERT INTO cam_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nihe hiwon ni apulie na lé âbé céii Iésu mu he ni muko mwopopwaalé. Ke e pii telé a ocine ce: ");
INSERT INTO cam_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«E bwo mu wo pa céiu apulie, ke e bwo wie ha a céiu tan, beme e tagiliihi ni âdaanu. Ke é he e ko tagiliihi, ke lé tupwo nge pwo pwaaden ni béé pidenaado, ke lé engen pwon ne ni apulie. Ke lé âbé ne ni meni, ke lé wii ati. ");
INSERT INTO cam_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ke ni béén, ke lé tupwo ne ha a wii péi. Ke lé te pwome cim, kehe icehi ana lé meiu, be te tice tabe lang. ");
INSERT INTO cam_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ke ni béén, ke lé tupwo ne ha awieme ni mwawi ubwo. Ke me lé tai picim, ke lé taunuhi li pidenaado. ");
INSERT INTO cam_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ke ni béén, ke lé tupwo ne ha a pule na wâé. Ke lé cim, ke piubwo jélé da, ke lé ne ni acehin na nihe hiwon, die ko 100.» Ke e pii me ubwo wo Iésu pie: «Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Lé tahimwo Iésu wo lépwo acémun den ko ace bwopiine a ocine naa. ");
INSERT INTO cam_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ke e hegi ne telé pie: «E ne tewé wo Padué me geé temehi a ju bwomune a Mwametau ten. Kehe ni béé apulie, ke lé te ju téne cehi ni ocine beme: Lé tee omehi taaci, kehe time lé uce alihi temehi; ke lé tee téne taaci, kehe time lé uce téne temehi.» ");
INSERT INTO cam_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","E pii telé mwo wo Iésu pie: «Weengi a bwopiine a ocine naa: Ni pide âdaanu, ke a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","«Ke ni béé pidenaado, ke lé tupwo nge pwo pwaaden. A pwaaden, ke ni apulie na lé téne a pwooti, kehe icehi ana e tuiebé mwo wo *Caatana, ke e céi cemwohi a pwooti mu he ni pwonimelé. Be koli lé bo céihi ne kon, ke bo celuimilé. ");
INSERT INTO cam_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","«Ke ni béé pidenaado, ke lé tupwo ne ha a wii péi. A wii péi ke ni apulie na lé hegi a pwooti ne ha a pipwodéén, ke lé tabuhi céihi ne kon ha a céiu benaamwon. Kehe icehi ana time e uce pwo waan ne kolé a pwooti na lé téne. Ke me e tuie ne kolé ni tacebwén, ke lé patieden ni céihi telé. ");
INSERT INTO cam_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","«Ke ni béé pidenaado, ke lé tupwo ne he ni mwawi ubwo. A pule naa ke ni apulie na lé téne a pwooti, kehe icehi ana me lé caa engen, ke pinekepé ne telé ne ko ni naado na e tuie ne pwo a bwohemwo ce. Ke lé téte cehi a mwani me ni naamuu bwohemwo, me ni naado na wâé telé. É mu ko ninaa, ke time lé uce ne ce acehin celi megele. ");
INSERT INTO cam_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","«Ke ni béé pidenaado, ke lé tupwo ne ha a pule na wâé. Ke a pule naa ke ni apulie na lé téne a pwooti, ke lé hegi ne he ni pwonimelé na wâé, ke lé ténedehi, ke lé cumang ne kon, ke pwo acehi a pwooti ne kolé.» ");
INSERT INTO cam_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","E pii telé mwo wo Iésu pie: «Time nye uce ne miû ko a mwomiû, me nye talui ko ace cio, ai me nye ne haahi ace apule! Kehe genye ne da ko miiden, beme lé o alihi ehi, ne nina lé â taabé ha a mwa. ");
INSERT INTO cam_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ati ni naado na neduwohi, ke o bo habwii ne ha a pwéélang, beme nye alihi ehi. ");
INSERT INTO cam_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Geé cile ni pwooti na geé téne beme piubwo da nina geé temehi. Be wo pana caa pwo ne ten, ke o ne mwo pwon ce béén. Kehe wo pana te tice ten, ke o pétaabwon kojaeng a nehinaado na e niimihi pie e pelen.» ");
INSERT INTO cam_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","É alecehen, ke lé tuiebé wo nyaa te Iésu me lépwo ciéén, beme lé alieng. Kehe icehi ana pwocoon me lé â céiieng ko a bwo hiwon ni apulie na lé aujenieng. ");
INSERT INTO cam_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ke e pii te Iésu wo pa céiu apulie pie: «Aje, élé âoté pwomwo wo nyaa tem me lépwo ciéém. Be nimelé me lé aliko.» ");
INSERT INTO cam_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ke e hegi ne telé pie: «Ê nyaa tong me ni ciééng, ke ni apulie na lé téne a pwooti te Padué, ke lé piténedehi.» ");
INSERT INTO cam_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","É ha a céiu tan, ke lé taa pwo a céiu ong wo Iésu me lépwo acémun den. Ke e pii telé pie: «Genye gaale ângedé ko a céiu duaa jié.» Ke lé engen. ");
INSERT INTO cam_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ke me lé ko ân, ke e pule wo Iésu. Ke e tabuhi tahieng me ubwo a dan he jié. Ke ubwo a tabe, ke e taa ha ali ong. ");
INSERT INTO cam_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ke lé paûmiê Iésu, ke lé pii ten pie: «Pa apipune, genye o caa mwiiê!» Ke e cihe me mwoiu ne ko ali dan me ali jié. Ke e te cuwo kuti ali udan, ke caa te ju au mwo. ");
INSERT INTO cam_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ke e pii telé pie: «É ko ade na time geé uce céihi?» Kehe icehi ana te nihe mwotilé. Ke lé téetieng, ke lé pipii telé pie: «É! Kona woo pa apulie ce na e pihuôhi a dan me a jié, ke lu piténedeeng?» ");
INSERT INTO cam_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Lé tuie nge ha amu Gadara wo Iésu me lépwo acémun den, he bebenihe a amu Galilé. ");
INSERT INTO cam_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","É ha amu naa, ke pwo pa apulie na pwo ni duéé kon. Caa nihe bwolihi na e pimu ha a iitihi, ke te tice naamuun. Ke hiwon ni benaamwon na lé mu pahaulieng li duéé beme e pwotahinaado. Ke wo lépwo apulie lang, ke lé mu cie lupwo in me lupwo an, ke lé taa kon a itihe toki. Kehe icehi ana e mu te tahagéi. Ke lé mu cineeng nge ha a melé ne li duéé. Ke heme e ole mu pwo ali ong wo Iésu, ke e te âbé beniieng kuti wo paje. Ke wo Iésu, ke e cibéé wie ni duéé mu kon. Kehe icehi ana e tidihi jilin, me pimiibule ne ânebuhen, ke e toii da pie: «Iésu, pa *Naî Padué na nihe e daaité! Ade aceli nimem me go pwo tong? É ilehi kojako pie: Go nemwo pwo tong aceli ta.» ");
INSERT INTO cam_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ke e tahimwoeng wo Iésu pie: «He pii e woté ace niim?» Ke e hegi ne ten pie: «Bwehi duéé!» Be nihe hiwon ni duéé na élé kon. ");
INSERT INTO cam_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ke lé wâgo ko Iésu, me pii ten pie: «Go nemwo tahikeme ne ha a pwon na tice anebwén kon!» ");
INSERT INTO cam_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ke he pwo a pubu puwokwo na nihe hiwon jélé na lé ko um gaale hamwo a juwole, ke lé pii ten ne li duéé pie: «Kehe go nekeme me geme taa he ni puwokwo ne.» Ke e te pwo ne telé ana lé ilehi wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ke lé wie mu ko pali apulie, ke lé gaale he li puwokwo. Ke lé te téte kuti li puwokwo mu pwo juwole, ke lé téele ne he tabe, ke lé mwiiê. ");
INSERT INTO cam_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Me lé alihi ana e tuie wo lépwo awéihi puwokwo, ke lé te téte kuti, beme lé â uti a jepule naa, ne he ni mwopopwaalé ke é na ati ha amu. ");
INSERT INTO cam_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ke lé âbé ni apulie, beme lé alihi ana e tuie. Ke me lé âbé mwonu Iésu, ke lé ali pali apulie li e pawiehi li duéé mu kon, he e caa ko tebwo ânebuhe Iésu. Ke e caa cuwohe ni epwén, be caa ju wâé nang. Ke te junihe emegéi nalé. ");
INSERT INTO cam_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ke wo lépwona lé alihi nina e tuie, ke lé piuti te lépwo béén ali jepule ko a bwo wâé nang mwo. ");
INSERT INTO cam_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ke te junihe mwoti ati ni apulie ha amu naa, é Gadara. Ke lé pii te Iésu pie me e engen kojalé. Ke e taa pwo ong. ");
INSERT INTO cam_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Me e pwo me e engen ke e âbé ileeng wo pali apulie li lé wie mu kon li duéé pie, me e âcéin. Kehe icehi ana e hegi ne ten pie: ");
INSERT INTO cam_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Go mwojuia ngemwo pelem, ke go uti ati ni naado na e pwo ne kom wo Padué!» Ke e mwojuia mwo wo paje. Ke e â uti ne ha a mwopopwaalé ati ni naado na e pwo ne kon wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","E tuie gaapé wo Iésu mu ko a céiu duaan ko a jié. Ke lé hegieng ne ni apulie lang, be lé tee ko ucéieng. ");
INSERT INTO cam_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ke e tuiebé wo pa céiu apulie na a niin pie Jaïrus, pa céiu caa te *mwotapitihi. Ke e tidihi jilin ne ânebuhe Iésu, ke e wâgo kon pie, me e âcéin die ha a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Be pwo ê naîn na te céiu nang na caa 12 ni jo hen, na e caa pwo me e mele. Ke e âcéin wo Iésu. É he e mwo ko â he pwaaden ke hiwon ni apulie na lé aujenieng, ke lé picemelé. ");
INSERT INTO cam_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ke e mu ha awieme ni apulie naa ê céiu toomwo na caa 12 ni jo na cunu nang hen, be e mu tuie ni benaamwon na e mu téte kon a cewéle. Ke e caa te ju patieden ni mwani ten ne ko ni dotéén, kehe icehi ana time uce jan me lé pwo me tieden a cunu kon. ");
INSERT INTO cam_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ke e piâbé alecehe Iésu, ke e ti ko a baaé epwénen. Ke e te cuwo kuti a bwo téte na ali cewéle. ");
INSERT INTO cam_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ke e pii wo Iésu pie: «Wooélé na e ti ko a epwénung?» Ke lé tai hegi ne ten pie: «Time uce wogeme!» Ke e pii ten wo Pétéru pie: «Pa apwopune, é mu ko ade na go pii anaa? Be go alihi, te nihe hiwon ni apulie éni na lé aujenikenye, ke lé picemeko!» ");
INSERT INTO cam_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kehe icehi ana e pii mwo wo Iésu pie: «Pwo pace céiu apulie celi e ti ko a epwénung, be é téne pie e engen mu kong a céiu duaa niihung.» ");
INSERT INTO cam_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ke te ju éjén êgi toomwo ko a bwo mwotieng. Be e alihi pie e temehi ana e ko tuie wo Iésu. Ke e tidihi jilin me pimiibule ne ânebuhen. Ke e pii ten, ne ânebuhe ati ni apulie, a watihen me e ti kon, ke a bwo tieden na a cunu kon. ");
INSERT INTO cam_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ke e pii ten wo Iésu pie: «Adéiko go êje! Caa wâé go mwo ko a céihi tem! Ke go engen, ke me e mu pelem a péém.» ");
INSERT INTO cam_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","He e mwo ko pii anaa wo Iésu, ke e tehenebé wo pa céiu apulie mu pele Jaïrus, pali eapwihi mwotapitihi. Ke e pii ten pie: «Au! E caa mele wo êgi naîm. Kehe go nemwo pahauli pa apipune.» ");
INSERT INTO cam_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ke e téne ni pwocihe naa wo Iésu. Kehe icehi ana e pii ten pie: «Go nemwo pwo me mwotiko! Kehe go céihi, be bo wâé nang mwo!» ");
INSERT INTO cam_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","É heme lé tuie nge ha a pomwa ten, ke e paciitihi ko ni apulie me lé nemwo taa huâ, te icehi Pétéru, me Ioane, me Cang, me lu nyaa me caa te êgi cuwo nahi toomwo. ");
INSERT INTO cam_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Be lé tai é ke pihemun ko êgi nahi toomwo. Ke e pii telé wo Iésu pie: «Geé nemwo é! Geé ko pii pie e caa mele; kehe woéo, ke é pii pie e teko ju puluta!» ");
INSERT INTO cam_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ke lé pihoonieng, be lé temehi pie e caa te mele. ");
INSERT INTO cam_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ke e taa ha ali mwa. Ke e pétaa ko a in, ke e toii da pie: «Ê naîng, go cuwoda!» ");
INSERT INTO cam_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ke e caa mulie mwo, ke e te caamada kuti. Ke e pii wo Iésu te lu nyaa me caa ten pie: «Geu ne celi e wii.» ");
INSERT INTO cam_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Lu te nihe téetihi, kehe icehi ana e pii telu wo Iésu pie: «Geu nemwo pii te ce béé apulie ana tuie ne éni.» ");
INSERT INTO cam_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","E todebé ni 12 *apostolo ten wo Iésu, ke e nelé ngen beme lé â patemehi a *Mwametau te Padué. Ke e ne telé a pihuô me a junuun, beme lé pawiehi ni duéé, ke me lé pwo me tieden ni cunu ko ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ke e pii telé pie: «Geé nemwo pé ce naado hemepie geé engen: mepie ace bwaja, me ace élele, me ace pwoloa, me ce mwani. Ke geé te cuwohe cehi ace epwén celi te céiu. ");
INSERT INTO cam_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","«Ke mepie lé hegikewé ne ha ace céiu pwomwo, ke wâé heme geé mu lang, dieli geé bo engemwo mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ke mepie time uce nime ni apulie me lé hegikewé ne ha ace céiu duaan, ke geé engen mulang. Ke geé tagiliihi ni muu pule ko ni awé, beme geé habwii pie time uce wâé ni huô telé be muhi telé ko a pwooti te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ke lé engen wo lépwo apostolo nge he ni mwopopwaalé, ke lé patemehi a Pwooti Wâé, ke lé pwo me tieden ni cunu ko ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","9","E téne ni jepule ko Iésu wo *Érode Antipas, gupéno ne Galilé. Be e téne pie e pwo ni *pipwojunuun. Ke e pii pie: «É pwo me tahagéi hene *Ioane pa apipuu apulie. Ke he wooélé pa apulie ce?» Ke e hane me e alieng. Ke tabuhi pinekepé ten, be lé pii ne ni béé apulie pie: «Weeng, ke wo Ioane pa apipuu apulie, he e caa mulie cemwo mu ha amele!» Ke lé pii ne ni béén pie, wo péroféta Élia, ai pace céiu péroféta ânebun na e caa mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lé mwojuia mwo wo lépwo apostolo mu he ni mwopopwaalé, ke lé pitapitilé ne pele Iésu. Ke lé uti ten ati ni naado na lé pwo. Ke e péélé nge ha a céiu duaan na te piticie hen, mwonuhi a mwopopwaalé Betsaïda. ");
INSERT INTO cam_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kehe icehi ana hiwon ni apulie na lé téne pie lé â lang, ke lé âcéilé. Ke e hegilé wo Iésu, ke e pacémunilé ko a Mwametau te Padué, ke e pwo me tieden ni cunu kolé. ");
INSERT INTO cam_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ke é he babwén, ke lé âbé céiieng wo lépwo acémun den, ke lé pii ten pie: «Go ne ngemwo ni apulie ce, nge he ni mwopopwaalé, me ni pwomwo na e mwonu, beme lé pé ce wiinaado telé, ke me lé pule ngelang. Be apiticie éni.» ");
INSERT INTO cam_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Ke e hegi ne telé wo Iésu pie: «Ûhu! Geé ne ce wiinaado telé!» Ke lé pii ten pie: «Te ju nim ni pwoloa, ke alo ni ikua na e peleme! Kona nimem me geme â pwocuhi ce wiinaado me delé ati?!» ");
INSERT INTO cam_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Be élé nge ha a 5000 ni apulie aiu. Ke e pii te ni acémun den pie: «Geé pii te ni apulie pie, me lé pwo ce pubuulé, me pi 50. Ke me lé tebwo.» ");
INSERT INTO cam_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ke lé ténedehi, ke lé pwo me lé tai tebwo ne li apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ke e pé li pwoloa li nim me lupwoli ikua wo Iésu. Ke e alehede da he miiden, ke e pwo-olé te Padué. Ke e ebii li pwoloa, ke e ne te lépwo acémun den, me lé pwopatihi ne ha a pubu apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ke lé tai wiinaado ati, ke caa pwoluu jélé. Ke lé taineibuhi mwo ni nehi mepwoloa, ke lé paobaanihi ni élele na 12 kon. ");
INSERT INTO cam_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","É ha a céiu tan, ke e te pwoiitihi wo Iésu ne ha a céiu duaan na apiticie, weeng me ni acémun den. Ke e tahimwolé pie: «Kona lé pii pie woté ne kong ne ni apulie? Lé pii pie woéo, ke woo?» ");
INSERT INTO cam_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ke lé hegi ne ten pie: «Lé pii ne ni béén pie, wogo, ke wo Ioane pa apipuu apulie. Ke lé pii ne ni béén pie, wo péroféta Élia. Ke lé pii mwo wo lépwo béén pie, pa céiu béé lépwo péroféta ânebun na e caa mulie cemwo.» ");
INSERT INTO cam_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ke e tahimwolé wo Iésu pie: «Ke kona wogewé ke?» Ke e hegi ne ten wo Pétéru pie: «Wogo, ke pa *Mesia, na go âbé mu pele Padué!» ");
INSERT INTO cam_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Kehe icehi ana e te junihe paciitihi kolé me lé nemwo pii anaa te ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E pii telé pie: «O bo tuie ni benaamwon na é bo nihe mu he ni picani hen, woéo, pa Nahi Apulie. Be wo lépwo apihuô, me lépwo caa te lépwo *apwoâpwailo, me ni *dotéén ko patén, ke o te muhi telé kong. Ke lé bo pwo me é mele. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é bo mulie cemwo.» ");
INSERT INTO cam_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E pii te ati ni apulie wo Iésu pie: «Wo paceli nimen me e âbé céing beme pa acémun dong ke me e nemwo bo uce piniimieng mwo. Kehe wâé heme e canihi téteda he ni tan a *kuricé ten, ke me e âbé céing. ");
INSERT INTO cam_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Be wo pana nimen me e celuimi a mulihen, ke e o patieden. Kehe wo pana e patieden a mulihen mu kong, ke o celuimieng. ");
INSERT INTO cam_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","He ade ne te pa apulie, hemepie e hegi ati ni naamuu a bwohemwo, ke me e patieden a mulihen? ");
INSERT INTO cam_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","«Wo lépwo béén, ke tanim jélé kong me a pwooti tong, ne ânebuhe ni apulie. Ke heme wonaa, ke woéo pa Nahi Apulie, ke o bo tanim jo kolé, hemepie é bo âmwobé. É ha a tan naa, ke o bo habwii a bwo ubwo na a wâé teme, woéo me Caa tong, me ni *âcélo iitihi. ");
INSERT INTO cam_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ke é pii tewé a juuju pie: E bo ne éni a Mwametau ten wo Padué, ati ne ha a junuun. Ke pwo lépwo béén na élé éni jenaa na lé o mwo te alihi anaa, ânebuhe ce bwo mele telé.» ");
INSERT INTO cam_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","É he na 8 ni tan alecehe a bwopiine ni pwooti naa te Iésu, ke e pé Pétéru, me Ioane, me Cang. Ke lé taa pwo juwole beme lé pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ke é he e mwo ko pwoiitihi wo Iésu, ke pitaatééhi a bwo alihi na a pwahamiin. Ke â pwojo ni epwénen, pwohewii a pwéélang ko a ilehi. ");
INSERT INTO cam_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ke lé te ali kuti lupwo apulie na lé picihe me weeng: wo *Moosé, me Élia, lupwo alo péroféta ânebun na piubwo julu. ");
INSERT INTO cam_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ke lu âbeetieng ne ha a bwo ubwo na a wâé te Padué. Ke lé picihe ko a bwo â mele ten ne *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ke me lé mwo ko wonaa, ke wo Pétéru me lupwo acémun béén, he lé mwo ko pule ko a bwo mwaale jélé. Ke me lé ûmiê, ke lé alihi *a wâé te Iésu, ke lé ali lupwoli apulie, li lu mu pelen. ");
INSERT INTO cam_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ke me lu engen koja Iésu wo Moosé me Élia, ke e pii ten wo Pétéru pie: «Éé! Pa apipune, te nihe wâé heme genye ko mu éni. Wâé heme geme pacuuli ce mwa mwaanu celi cié, beme a dem a céiu, ke me a de Moosé a céiu, ke me a de Élia a céiu.» E pii anaa, be time e uce temehi aceli e ko pii ko a bwo emegéi nan. ");
INSERT INTO cam_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","É he e mwo tee ko cihe, ke e te âbé kuti a menii, ke e taluilé ko a démen. Ke te nihe mwoti lépwo acémun den. ");
INSERT INTO cam_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ke lé téne a pwocihe bé mu ha ali menii, na e pii pie: «Wo paje, ke pa Naîng na te céiu nang na é caa pipégalieng. Ke geé piténedeeng!» ");
INSERT INTO cam_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ke é alecehen, ke lé alihi pie, caa te piwoélé cehi me Iésu. Ke lé te cile me delé ha a benaamwon naa, ke time lé uce piuti te ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","É ha acaama hen, ke lé homwobé mu pwo juwole wo Iésu me lépwo acémun den na cié jélé. Ke lé âbé céii Iésu ne ni apulie na nihe hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Pwo pa céiu béélé, na e toii da pie: «Pa apipune, é ileko pie, go picani te pa naîng, na te ju céiu nang. ");
INSERT INTO cam_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Be e mu pééeng a duéé, ke e mu pwo me e wiikau, ke e mu pegiliieng, ke e mu tahieng ole pwo bwohemwo, ke e pwo me téte ni tabepwon. Ke e mu te nihe pwotahinaado ne kon, ânebuhe a bwo wie mu kon. ");
INSERT INTO cam_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ke é ile ni acémun dem pie, me lé peni ali duéé, kehe icehi ana time uce jan ne kolé.» ");
INSERT INTO cam_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ke e pii telé wo Iésu pie: «É pipwoééhewé wogewé ni apulie jenaa! Mwo te time geé uce téele céihi, be wogewé ni apwo mwoiu pun! O é dieli éniile celi é o mwo tee mu pelewé, ke me é mwo tee picani ne kowé? Pébé éni pa cuwo ewa naa!» ");
INSERT INTO cam_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","He lé mwo ko pééeng bé, ke e tahieng ole pwo bwohemwo na ali duéé, ke e pegiliieng. Ke e te penieng kuti wo Iésu. Ke e pwo me tieden ali cunu ko pali ewa aiu, ke e neeng de caa ten. ");
INSERT INTO cam_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ke lé te nihe téetihi ati ne ni apulie na lé alihi a inenaado naa ko a junuu Padué. Ni béé apulie, ke lé picedihi ati nina e pwo wo Iésu. Ke e pii te ni acémun den pie: ");
INSERT INTO cam_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Ke wogewé, ke geé téne ehi ani: O bo icuéo te ni apulie, woéo pa Nahi Apulie. Ke lé bo imwiéo, ke lé bo pwo me é mele.» ");
INSERT INTO cam_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kehe icehi ana time lé uce temehi ana e pii. Be time uce pwaale ne telé a bwopiinen. Kehe mwotilé me lé tahimwoeng kon. ");
INSERT INTO cam_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","É alecehen, ke lé tabuhi picihe wo lépwo acémun den, ke lé pitahimwolé pie: «Kona woo paceli piubwo nang ne ha awiemenye?» ");
INSERT INTO cam_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kehe icehi ana e te temehi ni pwonimelé wo Iésu. Ke e pé pa cuwo nahi ewa, ke e neeng cebwon. ");
INSERT INTO cam_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ke e pii telé pie: «Wo pana e hegi ne he niing pace cuwo nahi ewa pwohewii paje, ke e hegiéo. Ke wo pana e hegiéo, ke e hegi mwo pana e neéo bé. Be wo pana nihe piwahin nang mu hadeniiwé ati, ke weeng pana piubwo nang.» ");
INSERT INTO cam_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","E pii wo Ioane te Iésu pie: «Pa apwopune, geme ali pa céiu apulie na e peni ni duéé ne he niim. Ke geme pii ten pie me e nemwo pwo, be time uce pa béénye.» ");
INSERT INTO cam_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ke e hegi ne telé pie: «Geé nemwo tanyuueng! Be wo pana time e uce âbédekenye, ke pa béénye.» ");
INSERT INTO cam_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","E o caa tuie a benaamwon na me ece a bwohemwo ce wo Iésu. Ke e te nihe pipamwoiueng, beme e â Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ke e ne ngen lépwo apipépwooti ten, me lé â ha a céiu mwopopwaalé ne ha amu ne *Samari, beme lé bo piwâam ko ace bwo tuie ngen den. ");
INSERT INTO cam_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kehe icehi ana wo lépwo apulie lang, ke muhi telé me lé hegieng, be e engen me e â Iérusaléma a pwomwo ubwo na e ha amu *Judé. ");
INSERT INTO cam_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","É heme lu téne anaa wo lupwo acémun den, wo Cang me Ioane, ke lu pii ten pie: «Padaame, hemepie nimem, ke gemu o ilehi a miû me e opé mu he miiden, beme e bo cinilé!» ");
INSERT INTO cam_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ke e biteeng wo Iésu, ke e henilu {pie: «Time geu uce temehi pie he ade jenenaado na e cihe kou. ");
INSERT INTO cam_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Be woéo pa Nahi Apulie, ke time é uce âbé beme lé mele wo lépwo apulie, kehe é âbé beme é celuimilé.»} Ke lé â ha a céiu mwopopwaalé. ");
INSERT INTO cam_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","É he lé ko â he pwaaden, ke e âbé céii Iésu wo pa céiu apulie, ke e pii ten pie: «Nimung me é âcéim na ati he ce piduaan celi go bo â hen.» ");
INSERT INTO cam_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ke e hegi ne ten wo Iésu pie: «Ni wota apiaba, ke pwo ni amwaale telé; ke ni meni, ke pwo ni mwonahilé. Kehe woéo, pa Nahi Apulie, ke te tice duaan celi me é mwaale hen.» ");
INSERT INTO cam_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ke e pii te pa céiu apulie wo Iésu pie: «Go âbé céing.» Kehe icehi ana e pii pie: «Mwo cuwo lang, beme é mwo â pineduwo caa tong.» ");
INSERT INTO cam_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ke e hegi ne ten wo Iésu pie: «Go necu ni amele me lé te pineduwolé! Kehe wogo, ke go pipatemehi a Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","E pii te Iésu wo pa céiu apulie pie: «Padaame, é bo te âdé céim. Kehe icehi ana go mwo neéo beme é mwo â pine a pwomwoiu tong.» ");
INSERT INTO cam_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ke e hegi ne ten wo Iésu pie: «Wo pana e ne a in ko a béum, ke me e niê ocemwo, ke time uce jan ne kon, me e taa ha a Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","E pipégali ni apulie na 70 jélé wo Padaame Iésu. Ke e nelé ngen he pialo ânebuhen, nge he ni mwopopwaalé me ni duaan na e niimihi pie me e â lang. ");
INSERT INTO cam_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ke e pii telé pie: «Nihe ubwo a pitii âdaanu na me pwo, kehe icehi ana time uce hiwon ni apenem. Geé pwoiitihi, me ilehi koja pa eapwihi apwoamu, me e ne mwobé ce béé apenem, beme lé pitii âdaanu. ");
INSERT INTO cam_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Geé engen ke geé pipwocile! Be é pahedekewé pwohewii ni nahi muto nge ha awieme ni wota apiwii. ");
INSERT INTO cam_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ke heme geé ân, ke geé nemwo pé ce mwani, me ce élele, me ce dihibwaawé. Ke geé nemwo tee pwojepule me ni béé apulie nge he pwaaden. ");
INSERT INTO cam_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","«Ke me geé taa ha ace céiu pwomwo, ke geé mi pii pie: “Me e mu ha a pwomwo ce a péém!” ");
INSERT INTO cam_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ke mepie pwo pace apulie celi e mu lang, celi e mu kon a péém, ke e bo mu pelen a péém. Ke me time uce wonaa, ke e o te mwojuia ne mwo kowé. ");
INSERT INTO cam_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Me geé mu ha ace pwomwo, ke geé wii ke ûdu celi lé bo ne tewé. Be wo pa apenem, ke o wâé heme e hegi a cuhieng. Ke geé nemwo piâdé ke âbé nge he ni pwomwo; geé mu ha ace pwomwo celi céiu dieli geé bo engen mu ha a duaan naa. ");
INSERT INTO cam_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«Ke é heme geé taa ha ace céiu mwopopwaalé, ke mepie lé hegikewé, ke geé wii celi lé bo ne tewé. ");
INSERT INTO cam_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ke geé pwo me tieden ni cunu ko ni apulie lang, ke geé pii telé pie: “E caa âbé mwonukewé a *Mwametau te Padué!”» ");
INSERT INTO cam_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","«É hemepie time lé uce hegikewé ne ha ace mwopopwaalé, ke geé â ha apimu ubwo te ni apulie, ke geé pipatemehi telé pie: ");
INSERT INTO cam_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Geme tagiliihi ni muu pule ko amu tewé, mu ko ni ame beme ine a pitautinaado te Padué! Ke geé pipwocile, be caa é mwonu a Mwametau ten!” ");
INSERT INTO cam_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","«Ke é pii tewé a juuju pie: É ha ace Tan celi e bo tauti ni apulie hen wo Padué, ke o te junihe ubwo ace cuhinaado telé koja lépwo *Sodome li te junihe ta ni huô telé. ");
INSERT INTO cam_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Geé pipwocile, wogewé ni apulie Korazin me Betsaïda! Be o bo ne cuhinaado tewé! Be é caa pwo ni naado na nihe ubwo ne pelewé ke time geé uce céihi! Geé cuwoteeke niimihi lupwo pwomwo ubwo Tir me Sidon ânebun be te nihe ta ni huô te ni apulie lang. Kehe icehi ana hemepie lé alihi ana é pwo ne pelewé, ke wieli caa te é bwolihi celi lé taatééhi ni mulihelé. Ke me lé o habwii ko ace bwo cuwohe cang delé, me pitimilé he dep. ");
INSERT INTO cam_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ke o te nihe ubwo ce cuhinaado tewé koja lépwo Tir me Sidon. ");
INSERT INTO cam_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","«Ke te piwien ne kowé, wogewé lépwo apulie Kapernaüm. Be geé niimihi pie pwonaado ne kowé, ke geé pwohewii Padué. Ûhu! E bo nekewé ole céii lépwo amele!» ");
INSERT INTO cam_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ke e pii mwo wo Iésu te lépwo apulie ten pie: «Hemepie e piténedekewé wo pace céiu apulie, ke woéo na e piténedeéo. Ke mepie time e uce hegikewé wo pace céiu apulie, ke woéo na time e uce hegiéo, ke time e uce hegi mwo pana e neéo bé.» Ke lé engen wo lépwo apulie te Iésu na 70 jélé. ");
INSERT INTO cam_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","He lé mwojuia mwobé, ke lé te junihe pipwodéén, ke lé pii pie: «Padaame, lé piténedekeme ni duéé heme geme pii telé pie me lé wie ne he niim!» ");
INSERT INTO cam_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ke e hegi ne telé wo Iésu pie: «Geé téne! É ali *Caatana, he e tupwo mu he miiden pwohewii a ilehi! ");
INSERT INTO cam_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ke é caa ne tewé a pihuô me geé engen pwo ni bwien, me ni atinip, ke me geé â ati pwo a junuu Caatana. Ke o te tice celi e tatéékewé. ");
INSERT INTO cam_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kehe icehi ana geé nemwo pipwodéén cehi mu ko ana lé piténedekewé ne ni duéé! Kehe wâé heme geé pipwodéén ne ko ana e caa tii ni niiwé wo Padué ne ha a tii ten ne he miiden.» ");
INSERT INTO cam_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ke é ha a cuwo benaamwon naa, ke e te nihe pipwodéén wo Iésu, mu ko a *Jenen Iitihi. Ke e pii te Padué pie: «É pwo-olé tem, go Caa, Padaame he a miiden me a bwohemwo, be go neduwohi ni naado naa koja lépwo atemehinaado me lépwo apitemang, ke go habwii te lépwona time lé uce cémun. Be te âcehi ana te nimem kon.» ");
INSERT INTO cam_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ke e pii te lépwona lé téneeng pie: «Ati nina e pele Caa tong, ke e caa ne tong. E caa te pihabwiieng dong, beme é temehieng ehi. Te weeng cehi na e temehiéo, woéo pa Naîn. Ke te woéo cehi na é temehieng, ke é habwiieng te ni béén, beme lé temehieng mwo.» ");
INSERT INTO cam_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ke e biteeng nge céii ni acémun den wo Iésu, ke e pii telé pie: «Nihe piwâénimewé heme geé alihi ni naado na geé alihi. ");
INSERT INTO cam_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Be é pii tewé pie: Hiwon ni péroféta me ni daame na te nihe nimelé me lé alihi nina geé alihi, kehe time lé uce alihi. Ke nimelé me lé téne nina geé téne, kehe time lé uce téne.» ");
INSERT INTO cam_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ha a céiu tan ke e âmwobé céii Iésu wo pa céiu *dotéén ko patén. Be nimen me e tacebwénieng, ke e tahimwoeng pie: «Pa apipune, he ade aceli me é pwo, beme é hegi a *mulie dieli mwo ne pele Padué?» ");
INSERT INTO cam_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ke e hegi ne ten wo Iésu pie: «He ade aceli tii ne he ni patén? Ke go woté ko ace bwo temehi nen dem?» ");
INSERT INTO cam_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ke e pii ten wo pali apulie pie: «Go pwo me eânimem de Padaame Padué hem, ati ne ha a ju pwonimem, me a mulihem, me a niihem, me a bwo niimihinaado tem. Ke go pwo me eânimem de ni béén, pwohewii a bwo pieânimem dem.» ");
INSERT INTO cam_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ke e hegi ne ten wo Iésu pie: «Go te ju hegi ehi; ke me go wonaa ace bwomu tem, ke go o taa ha *a ju mulip.» ");
INSERT INTO cam_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kehe icehi ana nime pali me e habwii pie e juuju. Ke e tahimwo Iésu mwo pie: «Ke kona woo pace apulie celi me eânimung den?» ");
INSERT INTO cam_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ke e pwo a ocine wo Iésu beme e hegi ne ten. E pii pie: «Pwo pa apulie pa âjiénenye, wogenye lépwo *Juif. Ke é ha a céiu tan ke e ole mu *Iérusaléma me e â Iériko. Ke me e â he pwaaden, ke lé ahieng wo lépwo abune, ke lé pé ati ni mwani ten me ni epwénen. Ke lé bwo neeng, he e caa pwo me e mele. ");
INSERT INTO cam_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","«Ke nebwén, ke e âbé ha a pwaaden naa wo pa *apwoâpwailo, pa âjiénenye. Ke heme e ali pali apulie, ke e te padep kon, ke e te ân. ");
INSERT INTO cam_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ke e tuiebé mwo wo pa apipenem ko a *mwaiitihi, pa âjiénenye ke e te pwohewii pana e ânebun, ke e te uti a pwaadeniin. ");
INSERT INTO cam_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","«Ke heme e âbé wo pa céiu béé lépwo *Samari, lépwona geé pitéétilé ke e ali pali apulie, ke nihe ubwo a bwo eânimen den. ");
INSERT INTO cam_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ke e âmwonueng, ke e céihi a huile me a tabe megele beme e ciie ni ahinaado kon, ke e tawii. Ke e temeeng da pwo a buriko ten. Ke e pééeng nge ha a mwa te ni aâdé ke âbé, ke e cileeng nelang. ");
INSERT INTO cam_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","«É ha acaama hen, ke e ne ni mwani te pali eapwihi pwomwo, ke e pii ten pie: “Go cile ehi paje. Ke mepie time uce jan ni mwani ce, ke go bo pwocuhi ni nehin, ke é bo wodehi ne tem hemepie é bo mwojuia mwobé.” «Ke nebwén, ke e engen.» ");
INSERT INTO cam_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ke e tahimwo pali dotéén ko patén wo Iésu pie: «É mu ko lépwo apulie na cié jélé naa, ke woo paceli eânimen de pali apulie li tanahieng? Ade ace âniimihinaado tem?» ");
INSERT INTO cam_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ke e hegi ne ten wo pali dotéén ko patén pie: «Wo pana e pwopweehi ne kon, ke e picani ten.» Ke e pii ten wo Iésu pie: «Go engen, ke go pipwohewiieng.» ");
INSERT INTO cam_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Lé â pwo pwaaden wo Iésu me ni acémun den. Ke lé tuie nge ha a céiu mwopopwaalé na e mu hen ê céiu toomwo na pii kon pie Marte. Ke e hegilé ne ha a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ke pwo ê ciéén na pii kon pie Maria, na e tebwo ânebuhe Iésu, beme e tabemi ati ni pwooti ten. ");
INSERT INTO cam_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ke wo Marte, ke pipééeng a pwoila, ke e âbé pii te Iésu pie: «Padaame, e te neéo ê ciééng me é te pipenem cehi! Kona te piticenaado ne kon ne tem? Go pii ten pie, me e âbé picani tong!» ");
INSERT INTO cam_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ke e pii ten wo Padaame pie: «Au êje, Marte, go te junihe gia ko ni naado na nihe hiwon na piticenaado ne kon. ");
INSERT INTO cam_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kehe go téne, te ju céiu cehi a naado na pwonaado ne kon. Ke e caa tooli wo Maria. Ke o time bo uce pé kojaeng mwo.» ");
INSERT INTO cam_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","É ha a céiu tan, ke e pwoiitihi ne ha a céiu duaan wo Iésu. Ke é he e caa nebwén, ke e pii ten wo pa céiu acémun den pie: «Padaame, go pacémunikeme ko a bwo pwoiitihi, be e wonaa wo *Ioane pa apipuu apulie te lépwo acémun den.» ");
INSERT INTO cam_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ke e hegi ne ten pie: «Weengi a bwo pwoiitihi tewé: “Caa teme jeda he miiden, wâé heme paciitihi a niim. Wâé heme e âbé a Mwametau tem. ");
INSERT INTO cam_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Go ne teme ce wiinaado celi jan ne kome, ati he ni tan. ");
INSERT INTO cam_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Go pineuhi ni ta pwo teme, pwohewiin he geme pineuhi ni ta na lé pwo teme. Go nemwo nekeme he ni tacebwén.”» ");
INSERT INTO cam_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","E pacémuni mwo lépwo acémun den wo Iésu ke e pii telé a ocine ce ko a bwo pwoiitihi: «Geé cuwoteeke niimihi ani: E tuiebé wo pa céiu apulie ne pelem ha awieme bwén, kehe te tice wiinaado ha a pomwa tem. Ke go téte nge pele pa béém, ke go ilehi kojaeng ce pwoloa celi cié. ");
INSERT INTO cam_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","«Kehe icehi ana e caa pule wo paje, ke time e uce wie ne kom, ke e te ju pii ole pie: “Neéo! Be é caa pule me ni naîng, ke é caa kiléhi a pomwa. Pwocoon me é cuwoda me é ne tem ce pwoloa!”» ");
INSERT INTO cam_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ke e pii wo Iésu pie: «Wieli time e uce picani tem be te pa béém, kehe icehi ana hemepie go te mwoiu ko ilehi, ke e o te picani tem, ke e bo ne tem ana nimem kon.» ");
INSERT INTO cam_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«É mu ko anaa, na é pii tewé pie: Wâé heme geé tee ilehi taaci koja Padué be e bo ne tewé. Ke geé tee hane taaci, be geé bo tooli. Ke geé tee cii taaci a pomwa, be e o bo tehi ne tewé. ");
INSERT INTO cam_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Éa, be wo pana e ilehi, ke o bo ne ten. Ke wo pana e hane, ke e o tooli. Ke wo pana e cii a pomwa, ke o tehi ne ten. ");
INSERT INTO cam_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","«{He woo mu hadeniiwé celi e o ne ace péi te pa naîn, hemepie e ilehi kojaeng ace pwoloa? Ke} he woo celi e o ne ten ace bwien, hemepie e ilehi ace ikua? ");
INSERT INTO cam_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ke woo paceli e o ne ace atinip te pace naîn, hemepie e ilehi ace pihija? ");
INSERT INTO cam_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Be wogewé lépwo apulie na ta gewé, kehe geé temehi ne nina wâé te ni naîwé. Ke me wonaa, ke wo Padué Caa jeda he miiden na te junihe wâé nang ke e bo ne a *Jenen Iitihi ne te lépwona lé ilehi kojaeng.» ");
INSERT INTO cam_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","É ha a céiu tan, ke e cibéé a duéé wo Iésu mu ko pa apulie na huuhu nang. Ke me e wie mu kon ali duéé, ke e te cihe kuti wo pali apulie. Ke lé téetihi ne ni apulie na lé mu lang. ");
INSERT INTO cam_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kehe lé pii ne ni béén pie: «E peni ni duéé ko a junuu Caatana, pa daame he ni duéé!» ");
INSERT INTO cam_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ke lé pwo me lé pipwohuô te Iésu wo lépwo béén, ke lé pii ten pie: «Go habwii teme ace *pipwojunuun de Padué celi e kom.» Be nimelé me lé habwii pie, time e uce penem ko a junuu Padué. ");
INSERT INTO cam_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ke e te temehi ni bwo niimihinaado telé wo Iésu. Ke e pii telé pie: «Hemepie e pipwopa ne mwo kon ace céiu mwametau, ke a mwametau naa, ke o tanahi. Ke mepie e te pipwopa ne kon mwo ace céiu pwomwoiu, ke a pwomwoiu naa, ke o tanahi. ");
INSERT INTO cam_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ke é hemepie e pipwopa ne mwo kon wo Caatana, ke kona e o woté ko ace bwopwonen me e cumang a mwametau ten? Geé ko pii pie, é cibéé ni duéé ko a junuu Caatana: ");
INSERT INTO cam_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ke hemepie wonaa, ke kona woo celi e ne te ni bééwé ce junuun me lé peni ni duéé?! Be lé habwii pie geé getiéo! ");
INSERT INTO cam_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ûhu! É peni ni duéé ko a junuu Padué. Ke é hemepie nimewé kon, ke te jan me geé alihi temehi pie e caa tuiebé pelewé na a *Mwametau te Padué! ");
INSERT INTO cam_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«Wo pa apulie na pwo niihen, ke pwo ni pihe pa ten, ke o jan ne kon me e wéihi a pomwa ten me ni naamuun. Ke time uce mwotieng, ");
INSERT INTO cam_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","be e céihi ne ko ni pihe pa ten. Kehe icehi ana hemepie e tuiebé wo pa apulie na junihe pwo niihen kojaeng, ke me lu pipwopa, ke e piwéden wo pana junihe pwo niihen. Ke e pé kojaeng ni pihe pa ten me ni wâé ten, ke e patihi ne ko lépwo béén. ");
INSERT INTO cam_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","«Ke wo pana time uce pa bééng, ke e cubwoniéo. Ke wo pana time e uce picani tong me gemu taineibuhi, ke e papiidenihi.» ");
INSERT INTO cam_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«Geé cuwoteeke téne ani: Hemepie pwo duéé ko pace céiu apulie; ke me e wie mu kon, ke e â wé? E âdé ke âbé he ni duaan na ticie hen. Be e hane ace duaan celi me e mu hen, kehe icehi ana time e uce tooli. Ke e niimihi pie, me e mwojuia ngemwo ha ali mwa li e wie mu hen. ");
INSERT INTO cam_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","«Ke e mwojuia, ke e tooli ali mwa he te ju balé hen ehi, ke pwoiipihi ehi. ");
INSERT INTO cam_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ke e â hane ni duéé béén na 7 jélé, na te junihe ta jélé kojaeng. Ke lé taa pimu ha ali mwa. Ke wo pa apulie naa, ke bwo junihe ta nang mwo kojan ânebun!» ");
INSERT INTO cam_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hiwon ni apulie na lé ko tabemi Iésu. He e mwo tee ko pacihelé, ke e te cihe da ko miiden kuti ê céiu toomwo mu hadeniilé, ke e pii pie: «*Adéi ê toomwo na go âbeele mu kon, ke e paditiko!» ");
INSERT INTO cam_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ke e hegi wo Iésu pie: «Nihe ubwo a adéihi te nina lé téne a pwooti te Padué, ke lé piténedehi!» ");
INSERT INTO cam_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Caa â junihe hiwon ni apulie na lé tabemi Iésu, ke lé te ju â pititéélé ne kon. Ke e pii telé pie: «Te junihe ta ni apulie jenaa, be time lé uce piténede Padué. Ke lé te cuwo ko ilehi kojaeng ce inenaado, ke ce pipwojunuun. Kehe o te tice inenaado celi lé bo uce alihi mwo koja ali e too péroféta Jonas ânebun. ");
INSERT INTO cam_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Be weengaa a inenaado ne te ni apulie Ninive beme habwii pie, te wo Padué na e ne Jonas nge céiilé, beme e mi pii telé pie e o bo pwocuhinaado telé. Ke wonaa ana e o tooéo woéo pa Nahi Apulie, ke o a inenaado te ni apulie jenaa. ");
INSERT INTO cam_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","«Ke geé te temehi mwo a jepule ko ê toomwo daame ha amu Saba bwolihi. Be li e âbé mu ha amu ten na te junihe e ité, beme e téne pa daame *Solomona na oba nang ko a pitemang. Kehe te e éni pelewé pa céiu apulie na e te junihe piwéden koja Solomona! Ke é ha a Tan na e bo tauti ni apulie hen wo Padué, ke e bo cuwoda ânebuhewé ê toomwo daame naa, ke e bo pipé ne kowé, wogewé ni apulie jenaa. Be muhi tewé me geé téne. ");
INSERT INTO cam_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","«Ke é ne ko ni apulie Ninive na lé téne a pune te péroféta Jonas, ke lé pininim, ke lé pitaatééhi ni mulihelé. Kehe te e éni pelewé wo pa céiu apulie na e te nihe piwéden koja Jonas! Ke é ha a Tan na e bo tauti ni apulie hen wo Padué, ke wo lépwo Ninive, ke lé o cuwoda ânebuhewé, wogewé ni apulie jenaa, ke lé o pipé ne kowé. Be muhi tewé me geé pininim, ke me geé bitekewé!» ");
INSERT INTO cam_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Time nye uce ne miû ko a mwomiû, me nye talui ko ace cio! Kehe genye ne da ko miiden, beme lé o alihi ehi ne nina lé â taabé huâ. ");
INSERT INTO cam_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Geé téne! Ni naamiinye, ke a pwéélang ko ni éénye. Ke me te wâé ni naamiinye, ke e mu ha a pwéélang ati a éénye. Kehe me ta ni naamiinye, ke a éénye, ke e mu ha a melepiing. ");
INSERT INTO cam_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Geé pipwocile a pwéélang na e kowé, be koli e â melepiing. ");
INSERT INTO cam_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mepie e mu kom a pwéélang, ke o te tice ace céiu duaan mu kom celi e o mu ha a melepiing. Be e pwohewii a miû na e pwéélang kom.» ");
INSERT INTO cam_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","É he e mwo ko panebwénihi a pune naa wo Iésu, ke e âbé céiieng wo pa céiu *Farasaio, ke e todeeng bé ne pelen, beme lé piwiinaado me ni béé Farasaio béén. Ke lé tehene nge pwomwo, ke lé tebwo pwo taap. ");
INSERT INTO cam_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ke wo Iésu, ke time e uce puu lupwo in ânebuhe a wiinaado pwohewii ana te a bwomu te lépwo *Juif. Ke e téetihi wo pa Farasaio, ke time uce wâé ten. ");
INSERT INTO cam_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ke e pii ten wo Padaame Iésu pie: «Wogewé lépwo Farasaio, ke geé te ju puu ehi pwo mwojéi ni mwoûdu me ni tam. Kehe icehi ana te ju oba kuti ni pwonimewé ko nina ta. Be geé te junihe tapi, ke geé tee cuwo ko hane nina wâé me dewé, ke geé bune ni apulie! ");
INSERT INTO cam_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Geé pipatieden! Be kona time geé uce temehi pie, wo Padué na e pwo a mwojéi a tam, ke te weeng mwo pana e pwo a ne a tam? ");
INSERT INTO cam_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wâé heme geé ne te lépwona tice delé nina e mu he ni tamewé. Be me wonaa, ke geé puu ni iwé ke ni pwonimewé mwo! ");
INSERT INTO cam_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","«Te ni bwomu tewé na geé ne te Padué ana te ju céiu mu ko a 10, é mu ko ni pétaapwo âdaanu. Ke te wâé. Kehe geé pipwocile! Be time geé uce âcehi ni junaado ne he ni patén: a bwo pipwoiipi ni apulie, me a bwo eânimewé te Padué. Wâé heme geé pacuwohi ati nina ubwo, me ati ni nahi patén. ");
INSERT INTO cam_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","«O te junihe ubwo a cuhinaado tewé, wogewé lépwo Farasaio! Be geé te hane ni atebwo na e mu ânebun ne he ni *mwotapitihi. Be te junihe wâé tewé heme lé te pwobwocu tewé, me pipaunukewé ne he pwahamii ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","«Geé pwohewii ni bwomu na time uce pwopweehi. Be, me genye engen pwon, ke time genye uce temehi pie genye ko engen pwo ce bwomu!» ");
INSERT INTO cam_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wo pa céiu *dotéén ko patén, ke e téne a pwooti te Iésu naa, ne ko lépwo Farasaio ke e pii ten pie: «Padaame, me go pii anaa, ke go pii me ta geme mwo, wogeme lépwo dotéén ko patén!» ");
INSERT INTO cam_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ke e hegi ne ten pie: «Te piwien ne mwo kowé! Geé pipwocilekewé, wogewé lépwo dotéén ko patén! Be ni pihuô tewé, ke pwohewii ni âneule na te junihe téé, na geé pwo me lé taawon ne ni apulie. Be muhi tewé me geé pétaa kon ko a mwodéiwé na te ju céiu! ");
INSERT INTO cam_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","«Éa! O te junihe ubwo a cuhinaado tewé. Be lé taunu lépwo péroféta te Padué wo lépwo watihewé. Ke é jenaa ni, ke é he geé bahi ni bwomuhelé, ke geé habwii pie, wogewé mwo ko a bwo taunulé! ");
INSERT INTO cam_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Be weengi ana e pii ne kowé wo Padué, pana e temehi ati: “É bo ne lé céiikewé lépwo péroféta tong, me ni *apostolo tong. Ke geé o pwotahi ne kolé, dieli geé o taunu ce béén.” ");
INSERT INTO cam_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","«Ke e bo tautikewé wo Padué ko a bwo taunu ati lépwo péroféta ten, mu ha atabuhi ko a bwohemwo, ");
INSERT INTO cam_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","tabuhi mu ko Abel, die ko Zakari, li lé taunueng ne ha awieme *apwoâpwailo me a duaan na junihe iitihi! Ke é pii tewé pie: Wogewé lépwo apulie jenaa na e bo tautikewé kon! ");
INSERT INTO cam_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","«Wogewé lépwo dotéén ko patén, ke a panewé me geé tehi ne te ni apulie ni bwo temehinaado mu he ni tii iitihi. Kehe icehi ana geé neduwohi kolé! Muhi tewé me geé taa ha a Mwametau te Padué, ke geé pacuwo ni béén na nimelé me lé taa hen. Ke é pii tewé pie: O te junihe ubwo ace cuhinaado tewé!» ");
INSERT INTO cam_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","E panebwénihi ana e pii wo Iésu, ke e wie mu ha a mwa te pali Farasaio. Ke lé te junihe okéé kuti wo lépwo Farasaio me lépwo dotéén ko patén. Ke tabuhi mu ha a benaamwon naa, ke lé te cuwo ko tacebwénieng, beme lé téne celi e pii. ");
INSERT INTO cam_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Be lé hane pwaaden beme lé pipé ne kon mu ko ace bwo hegi nen den. ");
INSERT INTO cam_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","É ha a benaamwon na e ko pacihe lépwo *Farasaio wo Iésu, ke caa pihiwon ni apulie na lé âbé tabemieng. Ke lé tabuhi pititéélé. É ânebuhe a bwo pacihelé ten, ke e mi pacémuni ni acémun den. Ke e pii telé pie: «Geé pipwocile a ‘nyaa te pwoloa’ te lépwo Farasaio, be lé habwii a duaan na wâé, kehe lé neduwohi ni ta pwo telé. ");
INSERT INTO cam_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ati ni naado na neduwohi, ke o bo habwii ne ha a pwéélang, beme nye alihi ehi. ");
INSERT INTO cam_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ke ni naado na geé pii neduwohi ne ha a melepiing, ke o pii pwaatihi ne ha a pwéélang. Ke ni naado na geé pihuu ko pii ne ha a nemwa, ke o bo toii da ne ha a pubu apulie.» ");
INSERT INTO cam_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Geé nemwo pwo me mwotikewé ko ni apulie, wogewé ni bééng. Be hemepie lé taunuhi ni ééwé, ke o te tice ace céiu naado celi lé o pwo te a jenewé. ");
INSERT INTO cam_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kehe geé pipwocilekewé, ke wâé heme geé pwo me mwotikewé ko Padué! Be weeng na jan ne kon me e taunuhi a ééwé, ke me e tahikewé ne ha a miû. ");
INSERT INTO cam_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«Geé cuwoteeke alihi ni meni na wahin jélé: Nye icuhi ni meni na nim ne ko nina alo mwani, kehe icehi ana te tice mu kolé celi e pineulé wo Padué. ");
INSERT INTO cam_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ke wogewé, ke e te tai temehi ati ni jéhi ni apuniwé. Ke é pii tewé pie: Geé nemwo pwo me mwotikewé! Be te junihe pwonaado ne kowé ne he pwahamii Padué koja ni meni na nihe hiwon jélé!» ");
INSERT INTO cam_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«É pii tewé pie: Wo pa apulie na e pii ne he pwahamii ni apulie pie, weeng pa apulie tong, ke woéo mwo, ke é o pii mwo pie weeng ke pa apulie tong, ne he pwahamii ni *âcélo te Padué. ");
INSERT INTO cam_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kehe wo pana e pii, ne he pwahamii ni apulie, pie time e uce temehiéo, ke woéo mwo, ke é o te pii, ne he pwahamii ni âcélo te Padué, pie time é uce temehieng. ");
INSERT INTO cam_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ke o pineu ati lépwona lé cihe me ta ne kong, pa Nahi Apulie. Kehe icehi ana wo pa apulie na e cihe me ta ne ko a *Jenen Iitihi, ke o time uce jan me pineuhi ni ta pwo ten.» ");
INSERT INTO cam_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«Geé téne, lé o bo imwikewé beme lé pitautikewé ne he ni *mwotapitihi, ke é ne he pwahamii ni daame me lépwo gupéno. Ke é ati he ni benaamwon naa, ke geé nemwo pwo me gia gewé ko ce bwopiinen telé. ");
INSERT INTO cam_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Be a Jenen Iitihi, ke e o bo te patemehi tewé celi me geé bo pii, hemepie geé bo cuwo he pwahamiilé.» ");
INSERT INTO cam_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Pwo pa céiu mu ha a pubu apulie na e pii te Iésu pie: «Pa apipune, e caa mele wo caa tong koja ni naamuun. Go pii te pa âjiénung pie, me gemu pipwopatihi ne komu!» ");
INSERT INTO cam_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ke e hegi ne ten wo Iésu pie: «Aje, time é uce âbé me é tauti ni naado na wonaa!» ");
INSERT INTO cam_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ke e pii te ni apulie pie: «Geé pipwocilekewé me geé nemwo tee hane me pihiwon dewé ni naado! Be a ju mulihe pa apulie, ke time uce é mu ko ni naado na eten.» ");
INSERT INTO cam_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ke e uti telé a ocine ce: «E bwo mu wo pa apulie na junihe pwo den, ke pwo ni pule ten na e ne ni âdaanu na junihe wâé. ");
INSERT INTO cam_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ke e bwo pitahimwoeng pie: “É bo pwo de? Be caa pitice ahi ni âpenem dong ne ha ali pié tong.” ");
INSERT INTO cam_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","«Ke e bwo pipii ten pie: “Weengi ana me é bo pwo: É o tatii ni pié tong, ke é bo pwo celi piubwo, ke é bo ne ehi hen ni âpenem dong, ke ni naamuung. ");
INSERT INTO cam_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke é alecehen ke é o pipii tong pie: ‘Nihe hiwon ni naamuung he ni jo na hiwon. Ke é o mwaale, ke é o wiinaado, ke é o ûdu, ke é o pipwodéén!’” ");
INSERT INTO cam_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","«Kehe icehi ana e pii ten wo Padué pie: “Wogo, ke pa apiolo! É jenaa he bwén, ke é o pé mwo kojako a mulihem. Ke bo ni dee ati ni naamuum na go tapihi?”» ");
INSERT INTO cam_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","E pii mwo wo Iésu pie: «Weengaa ana e o bo tuie ne ko pana e hane ni naamuun ne éni pwo bwohemwo. Be o time uce pwo den ne pele Padué!» ");
INSERT INTO cam_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","E biteeng wo Iésu ne ko lépwo acémun den, ke e pii telé pie: «Weengaa a watihen me é pii tewé pie: Geé nemwo gia ko ni mulihewé, me ni ééwé. Geé nemwo tee pitahimwokewé pie: “Genye o bo wii de?” ke “Genye o bo cuwohe ce de?” ");
INSERT INTO cam_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Be a mulihewé, ke junihe pwonaado ne kon koja a wiinaado. Ke a ééwé, ke junihe pwonaado ne kon koja ni epwénewé. ");
INSERT INTO cam_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Geé omehi ni meni, be time lé uce picemi âdaanu, ke time lé uce pitii âdaanu, ke te tice béé awéa telé he ni tan. Be wo Padué, ke e te ne ni wiinaado telé. Kona wogewé, ke time geé uce piwéden koja ni meni? Uhuu! ");
INSERT INTO cam_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Time uce é mu ko a bwo gia celi geé o mwo ne mwo aceli céiu tan ne he ni mulihewé! ");
INSERT INTO cam_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ke hemepie time uce jan me geé pwo me bwali a mulihewé, é mu ko ade na geé pwo me pinekepé tewé ne ko ni nehin? ");
INSERT INTO cam_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«Geé cuwoteeke alihi ni muun he meté, be lé cim, ke time lé uce péi ke wolinaado. Ke é pii tewé pie: Wo pa daame *Solomona ati ha *a wâé ten ke ni epwénen, ke time uce junihe wâé koja a muun na te ju céiu. ");
INSERT INTO cam_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Geé cuwoteeke alihi ni meté: E cim jenaa, ke o cini meé ne pwo miû. Kehe wo Padué, ke e te ne ni epwénelé. Ke kona time e o uce ne ce epwénewé celi piwéden? Te junihe wahin kuti ni céihi tewé! ");
INSERT INTO cam_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","«Éa kuti, é pii tewé pie: Geé nemwo pwo me pinekepé tewé, ke geé nemwo gia ko celi me geé wii me ûdu. ");
INSERT INTO cam_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Be wo lépwona time lé uce temehi Padué, ke time lé uce mwaale ko a bwo hane ninaa. Kehe wogewé, ke wo Padué Caa tewé, ke e te temehi nina nimewé kon. ");
INSERT INTO cam_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Geé hane ânebun a Mwametau ten. Ke e o bo ne tewé ati nina tice tewé.» ");
INSERT INTO cam_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Geé nemwo pwo me mwotikewé, wogewé lépwo ju bééng, wogewé a pubu apulie tong. Be wâé te Caa tewé me e bo ne tewé a Mwametau ten. ");
INSERT INTO cam_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Geé icuhi nina etewé, ke geé ne ni cuhin ne te lépwona tice delé. Be me wonaa, ke o pwo ce naamuuwé ne pele Padué celi time uce bumedén, ke o time uce ta nelang. Be o pwocoon me lé pé wo lépwo abune. Ke te tice dale celi me lé wii, ke te tice ôbe celi me lé ili. ");
INSERT INTO cam_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Be é he na e lang ni naamuum, ke e lang a pwonimem.» ");
INSERT INTO cam_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","E pii mwo wo Iésu pie: «Geé ûmiê, ke geé ne ni epwénewé he penem, ke geé cile ehi ni mwomiû hewé me te pwéélang. ");
INSERT INTO cam_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Geé pwohewii ni apenem na lé ucéi pa caa telé heme e mwojuia mwo mu ha a piaten. Ke me e tehenebé, ke me e cii pomwa, ke lé o bo tehi ne ten. ");
INSERT INTO cam_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Be o nihe wâé ne ko lépwona e toolé heme lé tee ko ûmiê, ke lé ucéieng. «Ke é pii tewé a juuju pie: E bo cuwohe a epwén ko penem wo pa daame. Ke e pwo me lé tebwo pwo taap, ke e bo ne ce wiinaado telé! ");
INSERT INTO cam_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","É he li lé tee ko ucéieng, ke time lé uce temehi pie, e bo tuie ha ace benaamwon celi woté é ha awieme bwén ai é pwopwometan. Ke o adéilé, hemepie e tuiebé, ke me e toolé heme lé teko ûmiê! ");
INSERT INTO cam_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","«Geé cuwoteeke niimihi ani: Wo pa eapwihi pwomwo, ke time e uce temehi ace inetéale celi e o âbé hen wo pa abune me e taa ha a mwa ten. Be hemepie e te temehi, ke wieli e o te pacuwoeng. ");
INSERT INTO cam_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Wogewé mwo, ke geé te piwâam. Be é o bo âbé, woéo pa Nahi Apulie, kehe time geé uce temehi ace benaamwon.» ");
INSERT INTO cam_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","E tahimwo Iésu wo Pétéru pie: «Padaame, kona a ocine na go pii, ke te a deme cehi, wogeme lépwo acémun dem ai a de ati ni apulie?» ");
INSERT INTO cam_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ke e hegi ne ten wo Padaame pie: «He wooélé pa apenem na e piténedehi ke e pipwoiipieng? Wo pana e pii ten wo pa daame hen pie: “É ne tem a penem na pwonaado ne kon: Go ne ce wiinaado te lépwo apenem dong he ce benaamwon celi wâé.” ");
INSERT INTO cam_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","«Ke o te nihe wâé ne ko pa apenem naa, hemepie e tuiebé wo pa daame, hemepie e teko penem ehi! ");
INSERT INTO cam_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","É pii tewé a juuju pie: E o ne ten a pihuô ati ne ko ni den. ");
INSERT INTO cam_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kehe icehi ana wieli e piniimihi wo pa apenem naa pie, ‘O bwoli pa caa tong me e âmwobé.’ Ke e ahi ni béén ko penem, ke e te nihe wiinaado me ûdu, ke e piolo. ");
INSERT INTO cam_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ke e o bo âmwobé wo pa caa ten, ha a tan na time e uce ucéieng, ke é ha a inetéale na time e uce temehi. Ke e bo ne a cuhinaado na junihe ubwo te pa apenem naa, woélé me lépwo béén ko penem na time lé uce piténedehi. ");
INSERT INTO cam_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","«O junihe ubwo a cuhinaado ten, é mu ko ana e te temehi ana nime pa daame hen kon, ke time e uce pwo, ke tice aceli e pipwopweehi me den. ");
INSERT INTO cam_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Kehe time uce nihe ubwo ace cuhinaado te lépwona time lé uce temehi pie, ta nina lé pwo. Be wo pana e hegi nina hiwon, ke o ilehi kojaeng nina hiwon.» ");
INSERT INTO cam_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«É âbé, beme é pébé a miû ne pwo a bwohemwo; ke nihe nimung me caa ko éle. ");
INSERT INTO cam_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Be o puuéo ko a puu apulie ko ni picani na nihe ubwo. Be é teko ucéihi ne he ni téé beme panebwénihi. ");
INSERT INTO cam_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Geé nemwo niimihi pie é âbé beme é pébé a péém ne pwo a bwohemwo. Ûhu! É pii tewé pie, woéo pa watihen me time lé uce piténelé ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tabuhi jenaa, heme nim ni apulie na lé mulie ha a pwomwo na céiu, ke o time lé uce piténelé. Be o bo cié celi lé âbé céing, ke o bo alo lupwona lu piâdeéo, ai o cié celi lé piâdeéo, ke o alo lupwoceli lu âbé céing. ");
INSERT INTO cam_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Be o time lu uce piténelu wo pa caa me pa naîn, ke ê nyaa ma ê naîn; ke o time lu uce piténelu lu amwaan.» ");
INSERT INTO cam_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","E pii mwo wo Iésu te ni apulie na hiwon pie: «É hemepie geé alihi ni nii na e âbé mu ha ale amu, ke geé pii pie e o ute. Ke e o tuie. ");
INSERT INTO cam_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ke hemepie e tahieng a dan mu paaéémwa, ke geé pii pie: “O te nihe éle”. Ke o te wonaa. ");
INSERT INTO cam_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","57","Wogewé lépwo bwi! Geé te ju gahe pwo! Geé te nihe temehi me geé pii pie, wâé a amu, ai ta a amu. Ke é mu ko ade na time geé uce alihi temehi a juuju ne he ni naado na e ko tuie jenaa? Be hemepie geé ko alihi ehi ke geé temehi ehi ana mwomwon me geé pwo. ");
INSERT INTO cam_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","«Weengi ana mwomwon: É hemepie e pitéteiminaado ne kom wo pace céiu, ke geu mi pipwopweehi heme mwo ko wogeu nge he pwaaden nge ha a mwotautinaado. Be koli e bo neko te pa atautinaado; ke wo panaa, ke e o bo neko te ni pwoli, ke lé bo neko nge he karépu. ");
INSERT INTO cam_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ke é pii tem a juuju pie: O time go uce wie mu he karépu, hemepie mwo time go uce téele pwocuhi ati ni cuhinaado tem.» ");
INSERT INTO cam_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ha a benaamwon naa, ke lé âbé céii Iésu ne ni béé apulie, ke lé pii ten pie: «Wo pa daame *Pilate, ke e pwo me taunu ni béé apulie mu Galilé, he lé *pwoâpwailo te Padué ne *huâ iitihi ne Iérusaléma.» ");
INSERT INTO cam_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ke e hegi ne telé wo Iésu pie: «Kona geé niimihi pie lé mele be te junihe ta jélé koja ni béén? ");
INSERT INTO cam_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ûhu! Ke é pii tewé pie: Geé pipwocilekewé, ke geé pitaatééhi ni mulihewé wogewé ati, be koli geé o tai mele pwohewii ni apulie naa! ");
INSERT INTO cam_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ke geé cuwoteeke niimi lépwoli 18 apulie li e tupwo ne huîilé ali aba ne Siloé, ke taitelé. Kona te junihe ta jélé koja ni béé apulie *Iérusaléma? ");
INSERT INTO cam_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ûhu! É pii tewé mwo pie: Wâé heme geé pininim, ke me geé bitekewé. Be koli geé o tai epin ko mele pwohewii ni apulie naa!» ");
INSERT INTO cam_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","E pii telé a ocine ce wo Iésu: «E bwo mu wo pa céiu apulie, ke e bwo cemi a acuwo *majing ha apwoamu ten. Kehe icehi ana me e mu â omehi ce acehin, ke mu te tice. ");
INSERT INTO cam_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","«Ke e te pwo me pii te pa apenem den pie: “Go alihi! Be caa cié ni jo na é âbé hane ce acehin, ke te tice. Tahagéieng taabwon! Be time uce wâé heme cepwotee picim heme tee ko tice acehin!” ");
INSERT INTO cam_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","«Ke e hegi ne ten wo pali apenem den pie: “Padaame, mwo te ju neme neeng, beme é mwo pwopweehi kon. É o mwo ini aujenieng, ke me é ne pule kon. Ke genyu bo alihi ha a jo naa. ");
INSERT INTO cam_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ke mepie pwo ce acehin, ke wâé; ke mepie te tice, ke go bo tahagéi taabwon.”» ");
INSERT INTO cam_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","É ha a céiu *tan iitihi, ke e mu ha a *mwotapitihi wo Iésu, ke e pacémuni ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ke e mu mwo lang ê céiu toomwo na caa 18 ni jo na cunu nang hen. Be e mu kon a duéé, ke cii a duun, ke pwocoon me e pamwiieng. ");
INSERT INTO cam_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ke e alieng wo Iésu, ke e todeeng, ke e pii ten pie: «Êje, caa tieden a cunu kom!» ");
INSERT INTO cam_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ke e ne ni in huîin, ke e caa te pamwiieng kuti, ke e te junihe pipaunu Padué! ");
INSERT INTO cam_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kehe icehi ana e te junihe okéé wo pa apihuô ne ha a mwotapitihi, be e pwo me wâé nang wo Iésu ha a tan iitihi. Ke e pééle ni apulie wo panaa, ke e pii telé pie: «Lépwoje, 6 ni tan na nye penem hen. Ke heme nimewé me tieden ni cunu kowé, ke geé âbé ha a naadenitan! Ke geé necu a tan iitihi!» ");
INSERT INTO cam_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ke e hegi ne ten wo Padaame Iésu pie: «Wogo pa apulie ta! Tai wogewé ati, ke kona time geé mu uce tuwo ni wota tewé me paûdulé he ni tan iitihi? Uhuu! ");
INSERT INTO cam_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mepwo é ne ko ê toomwo ce, ke ê piebehi *Abérama, pa watihenye. Ke e cieeng wo *Caatana he na 18 ni jo. Ke woté, o te tice mwomwon dong me é tuwo a cunu kon ha a tan iitihi?» ");
INSERT INTO cam_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Ke tanim ati nina lé piâde Iésu. Kehe icehi hiwon ni apulie na lé te junihe pipwodéén ko nina wâé na e pwo. ");
INSERT INTO cam_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","E pii mwo wo Iésu pie: «Mepwo a *Mwametau te Padué, ke he pwohewii ace de? Weengi a ocine me pwo me geé temehi: ");
INSERT INTO cam_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","«A Mwametau te Padué, ke pwohewii a pide moutarde na e cemi wo pa céiu apulie ha a cereda ten. Te junihe wahin kehe me e cim, ke te junihe ubwo nang, ke lé âbé ne ni meni, ke lé pwo ni mwonahilé ne he ni dihen.» ");
INSERT INTO cam_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","E pii mwo wo Iésu pie: «Ade aceli é o pipwohewii ne kon, a Mwametau te Padué? ");
INSERT INTO cam_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","A Mwametau te Padué, ke pwohewii a nyaa te pwoloa na e pé ê céiu toomwo, ke e iluuhi neibu me a 25 kilo ko farine, dieli e â cibu da ali pwoloa!» ");
INSERT INTO cam_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","E pacémuni ni apulie wo Iésu ne he ni mwopopwaalé me ni amu, he e ko â Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ke e tahimwoeng wo pa céiu apulie pie: «Padaame, kona te ju mehin celi e o te celuimilé wo Padué?» Ke e pii te ni apulie wo Iésu pie: ");
INSERT INTO cam_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Te junihe picu kuti a pomwa da ha *a ju mulip. Kehe geé hane ace bwopwonen me geé taa hen. Be hiwon nina nimelé me lé taa, kehe icehi ana pwocoon ne kolé. ");
INSERT INTO cam_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Be, me e capuhi ke kiléhi a pomwa wo pa eapwihi pwomwo, ke time o uce jan me geé taa. Geé o te cuwo âoté pwomwo, ke geé o te cii taaci a pomwa, me pii ten pie: “Padaame, Padaame, go tehi ne teme!” «Kehe icehi ana e o hegi ne tewé pie: “Ûhu, time é uce temehikewé.” ");
INSERT INTO cam_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","«Ke geé o bo pii ten pie: “Te wogeme kuti li genye mu piwiinaado me ûdu me wogo. Ke go pwocémun nge he ni pwaaden ne he ni pwomwo ubwo teme!” ");
INSERT INTO cam_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","«Ke e bo te ju pii tewé gaale, pie: “Ûhu, time é uce temehikewé! Geé engen kojaéo, wogewé nina ta ni huô tewé!” ");
INSERT INTO cam_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«Ke o bo tahikewé ole pwomwo. Ke geé bo é me piwii pecuwo. Be geé bo ali lépwo watihewé: wo Abérama, me Isaaka, me Iakobo, me ati ni péroféta, na tai élé ha a Mwametau te Padué. ");
INSERT INTO cam_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ke o bo hiwon ce béén celi lé o bo âbé ha a Mwametau, mu pwo a bwohemwo ati. Ke o pwo ce atebwo telé ne ha a piwiinaado ubwo. ");
INSERT INTO cam_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Be hiwon nina lé alece jenaa na lé bo ânebun ha a benaamwon naa. Ke hiwon nina lé ânebun jenaa na lé o bo alece ne jeda ha a Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","É he e mwo ko pii anaa wo Iésu, ke lé te tuiebé kuti ne ni béé *Farasaio, ke lé pii ten pie: «Aje, geme téne pie, e pwo me e taunuko wo pa daame *Érode Antipas! Kehe wâé heme go engen mu éni!» ");
INSERT INTO cam_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","33","Ke e hegi ne telé pie: «Geé pii te pa wota apiaba naa pie, é jenaa ke é meé, ke é o mwo te mi pwo ni penem dong, be é o mwo peni ni duéé, ke é o mwo cile ni cunu. Ke é ha a béciéhe ni tan alecehen, ke é bo panebwénihi ati. Kehe é o mwo te mi cuwo ha a pwobenele ko a pwaadeniing nge Iérusaléma. Be time o uce wâé hemepie taunu pace céiu péroféta te Padué ne pwomwo koja Iérusaléma a pwomwo ubwo iitihi ten! ");
INSERT INTO cam_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«Au, mwolikewé wogewé lépwo Iérusaléma! Geé taunu lépwo péroféta na e nelé bé céiikewé wo Padué, be geé ahi ni béén ko péi, ke geé taunu ce béén ko ce béé bwopwonen. Mu te cuwo ko nimung me é taineibukewé, pwohewii a nyaa te ja heme e taineibuhi ni naîn haahi ni puuin. Kehe icehi ana te muhi tewé. ");
INSERT INTO cam_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ke geé téne, é o mwo engen kojakewé, ke e o pwo me ticie ha a *mwaiitihi tewé wo Padué! Ke é pii tewé pie: O caa time geé bo uce aliéo mwo, dieli ha ace tan celi geé o bo pii pie: *Adéi pa apulie na e âbé ne he nii Padaame!» ");
INSERT INTO cam_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","2","É ha a céiu *tan iitihi, ke e mu ha a pomwa te pa céiu *Farasaio wo Iésu, ke lé piwiinaado. Ke e mu lang mwo wo pa céiu apulie na cunu nang, be cibu ni miin. Ke lé wéa ko Iésu ati wo lépwo apulie beme lé alihi heme e pwo me tieden a cunu kon. ");
INSERT INTO cam_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ke e tahimwo lépwo *dotéén ko patén me lépwo Farasaio pie: «Kona te pwo mwomwon denye me nye pwo me tieden a cunu ko pace céiu apulie ha a tan iitihi, ai iitihi?» ");
INSERT INTO cam_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ke time lé uce hegi ne ten. Ke e biteeng nge céii pali cunu, ke e pwo me wâé nang, ke e pii ten pie, me e mwojuia ngemwo pelen. ");
INSERT INTO cam_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ke e tahimwo ati ni apulie pie: «É hemepie e tupwo ne ha ace pwomiidu wo pace naîm ai ace wota tem, ha a tan iitihi, ke kona go o pwo de? Geé â céieng da mu ha a pwon!» ");
INSERT INTO cam_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ke time uce jan me lé hegi ne ten. ");
INSERT INTO cam_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","E ome nina todelé ne ha ali piwiinaado wo Iésu, ke e alihi pie lé pipégali ni atebwo na e mu ânebun. Ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Go pipwocile! Be é hemepie todeko ne ko ace piwiinaado ko piaten, ke go nemwo â tebwo pwo a atebwo te lépwo apulie na piubwo jélé. Be koli e bo tode pace céiu apulie celi nihe pieda kojako ");
INSERT INTO cam_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","wo pali eapwihi ali piwiinaado! Ke koli e bo pii tem pie: “Go cuwoda, ke go engen mu ha atebwo naa.” Ke o bo tanim go me go â hane ace atebwo tem. ");
INSERT INTO cam_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","«Wâé heme go â tebwo âuté ha a bénebwéne atebwo. Ke e o bo pii tem wo pana e todeko pie: “Pa bééng, go âbé, me go tebwo pwo a atebwo te lépwona piubwo jélé.” Ke lé bo alihi nelang a bwo pipaunuko te pa eapwihi a piwiinaado. ");
INSERT INTO cam_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Be wo pana e pwo me piubwo nang, ke o neeng ole, ke wo pana e pwo me piwahin nang, ke bo neeng da.» ");
INSERT INTO cam_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","É nelang, ke e pii wo Iésu te pana e todeeng pie: «É hemepie go piwâam ko ace piwiinaado celi woni ke go nemwo tode cehi lépwona lé o wodehi ne mwo tem nina go pwo: é hemepie wo lépwo béém, me lépwo âjiénem, me lépwona pwo ni naamuulé. ");
INSERT INTO cam_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","«Be wâé heme go tode lépwona tice naamuulé, ke wo lépwona cunu jélé, ke wo lépwona tebwa jélé, ke wo lépwona bwi jélé. ");
INSERT INTO cam_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ke o adéiko, be time uce jan me lé wodehi ne tem, kehe wo Padué, ke e o bo ne tem a ceme ni penem dem, ha a tan na lé bo mulie cemwo mu ha amele wo lépwona lé pwo nina wâé.» ");
INSERT INTO cam_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Pwo pa céiu apulie na lu mu pwo taap me Iésu. Ke me e téne a bwo pipune ten, ke e pii ten pie: «Padaame, te junihe *adéi lépwona lé mu ha a piwiinaado ubwo ne ha a *Mwametau te Padué!» ");
INSERT INTO cam_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ke e pwo-ocine wo Iésu, beme e hegi ne ten. Ke e pii pie: «E bwo mu wo pa céiu apulie, ke e pipwopweehi a piwiinaado na nihe ubwo. Ke e tode lépwona nihe hiwon jélé beme lé piwiinaado. ");
INSERT INTO cam_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ke nebwén, ke cuwo ali tan ko piwiinaado. Ke e pahede pa céiu apenem den, me â tode lépwona me lé piwiinaado me weeng. ");
INSERT INTO cam_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","«Ke e ân, ke e too pa céiu béélé kehe icehi ana e hegi ne ten wo paje pie: “Au, go â pii te pa daame pie, me e pineuéo, be time uce jan me é âdé wiinaado, be é âbé mu ha apwocuhi a apwoamu, ke wâé heme é â cedi.” ");
INSERT INTO cam_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","«Ke nebwén, ke e ali pa béalohen mu ko lépwona todelé. Ke e hegi ne ten wo paje pie: “Au, go â pii te pa daame pie, me e pineuéo, be time uce jan ne kong me é âbé. Be é âbé mu ha apwocuhi ni paaci na 10, beme lé um. Ke wâé heme é mwo â picaalé.” ");
INSERT INTO cam_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","«Ke e ân, ke e too pa béciéhen, ke e hegi ne ten wo paje pie: “É mwo ko ju piaten, kehe time uce jan me é âbé.” «Be te tai pipéélé, ke te tai muhi telé me lé âbé, be lé tai pii pie, pwo ni penem delé.» ");
INSERT INTO cam_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«Ke e mwojuia mwo wo pali apenem, ke e piuti te pali daame hen a bwo hegi nen de lépwo apulie naa. «Ke e te junihe okéé kuti wo pali daame, ke e pii ten pie: “Go epin nge ha ati ni amu, ke go todebé nina tice naamuulé, me ni tebwa, me ni tebwomwa, me ni bwi.” ");
INSERT INTO cam_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","«Ke e an wo pa apenem. Me e mwojuia cemwo, ke e pii te pali apihuô pie: “Pa apihuô, geme caa pwo ali go pii, kehe mwo te pwo ni nehi atebwo.” ");
INSERT INTO cam_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","«Ke e hegi ne ten pie: “Go â ati pwo ni pwaaden, ke é mwonuhi ni ninaado. Ke go tode celi pitapitikewé, beme oba a mwa tong! ");
INSERT INTO cam_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ke mepwo é ne ko lépwoli é mi todelé, ke o te tice celi lé wii mu ko a piwiinaado tong!”» ");
INSERT INTO cam_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","É alecehen, ke e engen wo Iésu, ke hiwon ni apulie na lé âcéin. Ke e biteeng nge céiilé, ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Wo paceli e âbé céing, ke wâé heme nihe eânimen dong koja pa caa ten me nyaa ten, me ê mwoden, me ni naîn, me ni âjiénen, me ni iitieng, die mwo ko a mulihen. Be wo pana te junihe eânimen de ati ninaa kojaéo, ke time uce jan me pa acémun dong. ");
INSERT INTO cam_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Wo paceli time e uce canihi a *kuricé ten, me e âbé céing, ke time uce jan me pa acémun dong.» ");
INSERT INTO cam_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«Hemepie nime pace céiu apulie me e pacuuli ace mwa, ke e o tabuhi tebwo, ke e o pihane pie, ‘He o niile ace cuhin? He o te jan ce mwani tong beme panebwénihi?’ ");
INSERT INTO cam_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","«Be hemepie e te ju pwo cehi a paamwa, ke me time e uce panebwénihi a mwa, ke lé o te nihe pihoonieng ati ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Be lé o pii pie: “Pa apulie ce, ke e tabuhi pacuuli, ke time e uce panebwénihi!” ");
INSERT INTO cam_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«Ke wo pace céiu daame, ke heme e â pwopa ne ko pace céiu daame, ke wâé heme e mi pitahimwoeng pie: ‘Pwo ni coda tong na 10000. He o te jan me é â pwopa ne ko pana e âbé pwopa ne kong ko ni coda ten na 20000 jélé?’ ");
INSERT INTO cam_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","«Ke me time uce jan ne kon, ke e o ne ngen ce apitéteimipwooti nge céii pa céiu daame heme e mwo ko e ité, ke e o ileeng me lu pwo a péém.» ");
INSERT INTO cam_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ke e pii mwo wo Iésu pie: «O wonaa mu hadeniiwé hemepie pwo paceli time e uce necu ati ni den. Be wo pa apulie naa, ke time uce jan ne kon me pa eabwé tong.» ");
INSERT INTO cam_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Éa, a jié ke a naado na wâé, kehe mepie e patieden a nemen, ke he nye o woté ace bwopwonen me genye ne mwo ace nemen? ");
INSERT INTO cam_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Caa time uce jan me genye penem kon, ke genye tahi ole pwomwo. Wo paceli pwo ce pwojéénen me e téne, ke wâé heme e téne!» ");
INSERT INTO cam_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Lé âbé céii Iésu ni apulie na ta ni mulihelé: wo lépwo *atai mwani cuhi puni apulie me lépwo béén mwo. Be nimelé me lé téne a bwo pipune ten. ");
INSERT INTO cam_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ke junihe time uce wâé te lépwo *Farasaio, me lépwo *dotéén ko patén. Ke lé pipii telé pie: «Kee! Wo paje, ke lé pimu ibu me lépwona ta ni mulihelé, ke lé piwiinaado me weeng!» ");
INSERT INTO cam_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ke e pii telé wo Iésu a ocine ce: ");
INSERT INTO cam_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Geé cuwoteeke téne ani: Pace céiu bééwé, ke 100 ni muto ten. Ke mepie tieden aceli te ju céiu nang, ke e o pwo de? E o necu nelang li 99 muto, ke e o â hane ali muto li e pipatieden, dieli e bo tooeng. ");
INSERT INTO cam_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ke me e tooeng, ke e te nihe pipwodéén, ke e canihieng ne pwo lupwo pieaan. ");
INSERT INTO cam_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","«Ke é he e tuiebé pwomwo, ke e tode lépwo béén, ke nina lé mu ko jijen, ke e pii telé pie: “Geé âbé beme nye pipwodéén ibu! Be é caa tooli mwo ali muto tong li tieden!” ");
INSERT INTO cam_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","«É pii tewé pie, te piwien ne jeda he miiden, be wo Padué, ke e te junihe pipwodéén kuti ko pace apulie ta celi te ju céiu nang celi e pitaatééhi a mulihen, koja lépwona 99 na wâé ni mulihelé, ke time lé uce niimihi pie me lé mwo pininim mwo.» ");
INSERT INTO cam_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","E pwo a céiu ocine wo Iésu, ke e pii pie: «E bwo mu ê toomwo na 10 ni mwani péi ten na nihe ubwo a cuhin. Ke é ha a céiu tan, ke e patieden ana céiu. E bwo ne miû ko a mwomiû, ke e bwo balé ehi ha ali mwa ten. Ke e hane ali mwani ten, dieli e bwo te â tooli! ");
INSERT INTO cam_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","«Ke me e tooli ali mwani ten, ke e tode lépwo béén, me nina lé mu ko jijen, ke e pii telé pie: “Geé âbé me nye pipwodéén, be é caa tooli mwo ali mwani péi tong!” ");
INSERT INTO cam_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","«Kehe é pii tewé pie: O nihe ubwo a pipwodéén de lépwo *âcélo te Padué ko pace apulie celi te ju céiu nang na ta nang celi e pitaatééhi a mulihen.» ");
INSERT INTO cam_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","E uti telé mwo a céiu ocine wo Iésu: «Lé bwo mu lupwo ewa aiu me caa telu. ");
INSERT INTO cam_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ke e pii te caa telu wo pa béalohen pie: “Go ne tong ni dong mu ko ni naamuum.” «Ke e te ne ten wo pali caa telu. ");
INSERT INTO cam_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","«Ke nebwén, ke wo paje, ke e pé ati li den, ke e icuhi. Ke e pé li mwani, ke e â ha amu na nihe éité. Ke e hane a mulie na wâé ten, ke e pipwohauli ko li mwani ten. ");
INSERT INTO cam_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Âdé li wole, ke âdé, ke âdé, ke âdé… Ke e â patieden ati li mwani ten. Ke e tuie a menele na nihe ubwo ne ha amu naa. Ke te junihe menen kuti. ");
INSERT INTO cam_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ke e hane ace penem den, beme e wiinaado. Ke e picile puwokwo te pa céiu apulie ne ha amu naa. ");
INSERT INTO cam_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kehe icehi ana caa junihe menen, ke caa nimen me e eni mu ko li e puwokwo. Be te tice apulie celi me lé ne celi me e wii.» ");
INSERT INTO cam_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«Ke e tuie nge ha a céiu benaamwon, ke e pininim, ke e niimihi pie, ‘É ne pele caa tong, ke nihe hiwon ni wiinaado me de ati ni apulie, die ko lépwo apenem den. Ke te nihe hiwon mwo kojalé! Ke woéo ne éni, ke é ko metihi menele! ");
INSERT INTO cam_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Caa jan! É o mwojuia ngemwo céii caa, ke é o pii ten pie: Caa, go pineuéo, be é pitalupe ne he pwahamii Padué, ke é ne he pwahamiim. ");
INSERT INTO cam_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Caa time uce jan me woéo pa naîm. Kehe go pwo me pa céiu apenem dem.’ ");
INSERT INTO cam_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ke e cuwoda, ke e engen me e mwojuia ne mwo pele caa ten.» «É he e mwo ko âbé he pwaaden, ke e temehieng wo caa ten, ke e te nihe pipwoééhen. Ke e téte beniieng, ke e haaieng, ke e mwomwaaueng. ");
INSERT INTO cam_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ke wo pa naîn, ke e pii ten pie: “Caa, go pineuéo, be é pitalupe ne he pwahamii Padué, ke é ne he pwahamiim, ke caa time uce jan me go pii kong pie pa naîm…” ");
INSERT INTO cam_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","«He e mwo tee ko cihe ke e caa pii te ni apenem den wo caa ten pie: “Geé epin! Geé pébé ace epwén celi nihe wâé, beme e cuwo hen wo pali naîng. Ke geé ne ce tai ko in, ke ce dihibwaan. ");
INSERT INTO cam_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Geé pébé ali nahi paaci li nihe wâé a bwo ubwo nang, ke geé taunueng. Be é jenaa, ke genye o piwiinaado ibu, ke genye pipwodéén! ");
INSERT INTO cam_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Geé alihi, wo pa naîng ce, ke e caa mele, kehe e caa mulie mwo! Ke tieeng, ke é caa tooeng mwo!” «Ke lé tabuhi pipwodéén.» ");
INSERT INTO cam_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«He lé ko wonaa, ke he e tee ko penem he ni apwoamu wo pa cuwon. Ke me e mwojuia ne mwo pwomwo, ke e téne ni pwopwonyebi, ke ni tihi bweje. ");
INSERT INTO cam_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ke e tode pa céiu apipenem, ke e tahimwoeng pie: “Woté? É mu ko ade na geé ko junihe pipwodéén?” ");
INSERT INTO cam_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","«Ke e hegi ne ten pie: “E caa mwojuia mwobé wo pali ciéém. Ke te junihe piwâénime caa teu. Ke e pii pie me taunuhi ali nahi paaci, beme nye piwiinaado, me pipwodéén be e caa too mwo pa naîn he teko wâé nang!” ");
INSERT INTO cam_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","«Kehe icehi ana e okéé wo pali cuwon, ke muhi ten me e taa pwomwo. Ke e â wie wo caa ten, ke e wâgo kon me e taa céiilé. ");
INSERT INTO cam_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","«Kehe icehi ana e hegi ne ten pie: “Go téne go caa, caa nihe hiwon ni jo na é ko penem dem, ke time é uce téele pwoemaan, ke me muhi tong me é piténedeko. Ke time go uce téele ne tong ace cuwo nahi nani me geme piwiinaado me lépwo bééng! ");
INSERT INTO cam_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ke wo pane, ke e caa patieden ati ni mwani tem ne ko ni toomwo pwopwaaden, ke me e mwojuia, ke go pwo me lé taunuhi ali paaci li nihe wâé a bwo ubwo nang, beme a den!”» ");
INSERT INTO cam_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«Ke e hegi ne ten wo caa ten pie: “Go téne go pali naîng, go teko mu pelong, ke tai ati ni dong, ke ni dem. ");
INSERT INTO cam_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kehe icehi ana wâé heme nye pwo a piwiinaado jenaa me pipwodéén. Be pa ciéém ce, ke e caa mele, ke e caa mulie mwo! Pana caa tieeng, ke nye caa tooeng mwo!”» ");
INSERT INTO cam_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","E pacémuni lépwo acémun den wo Iésu, ke e pii telé a ocine ce: «E bwo mu wo pa céiu apenem de pa céiu apulie na pwo den. Be pa apiwéihi ne ni mwani ten. «Ke é ha a céiu tan, ke lé âbé pitéteiminaado te pali daame hen ne ni béé apulie, ke lé pii ten pie: “E te nihe pihoonihi li mwani tem wo pali apenem dem.” ");
INSERT INTO cam_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","«Ke e todeeng wo pali daame, ke e pii ten pie: “Aje! Lé pitéteiminaado ne tong kom! Go pii pwaatihi tong aceli go pwo ko li mwani tong. Be o time go uce tee wéihi!” ");
INSERT INTO cam_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","«Ke e te pitautinaado wo pali apenem, ke e pipii ten pie: ‘É te ju nebwén kuti! Ke é bo pwo de? Caa tice niihung me é penem he pule. Ke te nihe tanim jo me é ile.’ ");
INSERT INTO cam_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","«Ke e te niimihi kuti ana me e pwo, beme pwo ce béén celi me lé picani ten, hemepie caa tice penem den. ");
INSERT INTO cam_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«Ke e tode he picéiu lépwona pwo ni kérédi telé ne pele pali daame hen. Ke e tahimwo pa bécéiuhen pie: “Niile ce kérédi tem?” ");
INSERT INTO cam_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","«Ke e hegi ne ten pie: “100 piibwi ko géréén.” «Ke e pii ten wo pali apenem pie: “Ûhu! Go te ju wodehi cehi celi 50, go pali bééng. Neko a metii bépajuujuhi nen pie caa nebwén ati li kérédi tem.” ");
INSERT INTO cam_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","«Ke e tode mwo pa céiu, ke e tahimwoeng pie: “Wogo paje, ke niile ce kérédi tem?” «Ke e hegi ne ten pie: “100 ni cang ko blé.” «Ke e pii ten wo pali apenem pie: “Ûhu! Neko a metii tem, ke go te ju tii cehi pie 80, ke nebwén ati a kérédi tem.” ");
INSERT INTO cam_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«Ke é he e téne anaa wo pali daame, ke e te nihe téele, ke e picedi pali apulie ko a bwo pipwocileeng, ke te piwien hemepie pa apipwohuô.» Ke e panebwénihi nelang a ocine naa wo Iésu, ke e pii pie: «Geé alihi, wo lépwo apulie éni pwo bwohemwo, ke lé te nihe temehi me lé pipwocilelé, koja ni apulie te Padué na mwomwon ke juuju ni huô telé. ");
INSERT INTO cam_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ke é o pii tewé pie: A mwani, ke pa apipaupaakenye! Wâé heme go pé ni mwani tem, beme go picani te lépwo apulie kon ne éni pwo bwohemwo, beme o pwo ce béém. Be é alecehen, hemepie go caa mele koja ni mwani tem, ke wo Padué, ke e o te hegiko ehi ne ha a pomwa ten ne jeda he miiden dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","E pacihelé mwo wo Iésu ko a mwani, ke e pii pie: «Hemepie go temehi pwoiipihi ace cuwo nahi naado, ke go te temehi mwo me go pwoiipihi ni naado na ubwo. Ke é hemepie time go uce temehi me go pwoiipihi ni naado na wahin, ke o time go bo uce temehi me go pwoiipihi ni naado na ubwo. ");
INSERT INTO cam_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","12","Ke é hemepie time go uce temehi me go pwoiipihi ni naado na te ju wahin ne éni pwo bwohemwo, pwohewii a mwani, ke é mu ko ade na go niimihi pie wo Padué, ke e o bo ne tem, me go papenemihi nina wâé na ni junaado ne he miiden? ");
INSERT INTO cam_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","«Te tice pace apulie celi jan ne kon me pa apipenem de lupwoce daame celi alo julu, ati ha a pwonimen. Be e o pipenem ehi te pace céiu, ke e o tééti pa céiu. Kehe time uce jan me geé tai apipenem de Padué me a mwani!» ");
INSERT INTO cam_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Ke he lé téne a pwooti naa wo lépwo béé *Farasaio, ke lé pihoonieng, be wâé telé a mwani. ");
INSERT INTO cam_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ke e pii telé pie: «Geé pipwocile, be geé te nihe pihabwiikewé ne he pwahamii ni apulie, kehe icehi ana e te temehi ni pwonimewé wo Padué. Ke nina pwonaado ne kon ne te pa apulie, ke te junihe ta ne he pwahamii Padué.» ");
INSERT INTO cam_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","E pacémuni ni apulie wo Iésu ko ni béé pwooti, ke e pii telé pie: «Lé pihuôkenye ne ni *patén de Moosé, me ni pwooti te lépwo péroféta, die ha a benaamwon na e pipune wo *Ioane pa apipuu apulie. Kehe icehi ana é jenaa, ke é ko patemehi a Pwooti Wâé ko a *Mwametau te Padué. Ke te nihe hiwon ni apulie na lé ko pipwopa hane beme lé taa hen. ");
INSERT INTO cam_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kehe icehi ana hemepie e mwo teko mu a miiden me a bwohemwo, ke o te tice ace céiu atii celi e o pétaabwon mu ko ni patén. ");
INSERT INTO cam_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«É mu ko anaa, na é pii pie: Hemepie go cibéé ê mwodem, beme go piaten mwo, ke pa apibune be go engen koja êgi mwodem ânebun. Ke piwien mwo heme go piaten me êce céiu toomwo celi e caa tahagéi piaten.» ");
INSERT INTO cam_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","E pii wo Iésu a ocine ce: «Lu bwo mu wo lupwo apulie na alo julu. Wo pa céiu, ke pa apulie na nihe pwo den. Ke e mu cuwohe ni epwén na te nihe wâé ne kon, ke te nihe ubwo ni cuhin. Ati he ni tan, ke e te pwo nina te wâé ten, ke e mu pwo ni piwiinaado na ubwo. ");
INSERT INTO cam_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","«Ke wo Lazare, ke tice den, ke tome ahinaado kon, be e pwo katia, ke lé mu tami ni ahinaado kon ne ni wotaahen. Ke e tee pule ha a pomwa ko a babé ko ali mwa te pali pwo den. Ke te nihe nimen me e eni ni mewiinaado na e mu tupwo mu pwo a taap te pali pwo den. ");
INSERT INTO cam_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«Ke nebwén, ke lu mele wo lupwoli apulie, ke lé âbé wo lépwo *âcélo, ke lé pé Lazare nge pele *Abérama ne he miiden. ");
INSERT INTO cam_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kehe é ne ko pali pwo den, ke lé pééeng ole céii lépwo amele. Ke te nihe cunu nang, ke e te nihe mu he ni picani nelang. «Ke me e alehede, ke e ali Lazare me Abérama, ke he nihe woilu ité kojaeng. ");
INSERT INTO cam_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ke e toii da céii Abérama pie: “Au, caa, go pipwoééhung! Ke go neopé Lazare, beme e te ju neole ha a tabe a mwodéin, ke me e ne pwo a upehung. Be é te nihe mu he ni picani ne ha a miû ce.” ");
INSERT INTO cam_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","«Ke e hegi ne ten wo Abérama pie: “Pa naîng, go teko niimihi he li go mwo mulie pwo bwohemwo. Ke te tice celi tieden pelem, ke go mulie ha a pipwodéén. Kehe wo Lazare, ke e mu he ni cunu me ni picani. Ke go alihi, jenaa, ke e pipwodéén, ke wogo, ke go mu he ni cunu me ni picani. ");
INSERT INTO cam_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ke a céiu mwo, ke pwo a pwon na nihe ubwo ne ha awiemenye. Ke pwocoon me geme oté céiikewé, ke pwocoon me geé taabé céiikeme.” ");
INSERT INTO cam_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","«Ke e hegi ne ten wo pali pwo naamuun pie: “Ke me wonaa, go caa, ke é ileko pie, go pahede Lazare nge ha a pomwa te caa tong, ne pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Be mwo élé lang wo lépwo âjiénung na nim jélé; be wâé heme e pacihelé ko a duaan ce é ko mu hen. Be koli lé bo opé ne éni, he ni cunu me ni picani hemepie lé bo mele.” ");
INSERT INTO cam_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","«Ke e hegi ne ten wo Abérama pie: “Ûhu! Be caa te e pelelé wo Moosé me lépwo péroféta. Kehe wâé heme lé piténedehi!” ");
INSERT INTO cam_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","«Ke e pii ten wo pali pie: “Ûhu go caa. Be te nihe wâé heme e mwojuia mu ha amele wo pace céiu apulie me e pacihelé, beme lé pininim, ke me lé bitelé.” ");
INSERT INTO cam_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","«Kehe icehi ana e hegi ne ten wo Abérama pie: “Mepie time lé uce piténede Moosé me lépwo péroféta, ke time lé o uce piténede pace apulie celi e mulie cemwo mu ha amele!”» ");
INSERT INTO cam_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","E pii te lépwo acémun den wo Iésu pie: «O te cuwo ko pwo ni bwomunen me nye tupwo ne ha a ta. Kehe o te junihe ubwo a cuhinaado te pana e pwo me lé tupwo ne ha a ta wo lépwo béén!» ");
INSERT INTO cam_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","«Geé pipwocile! Go nemwo pwotahi a céihi te pa apulie na e céihi ne kong pwohewii a cuwo nahi ewa, be o te junihe ubwo a cuhinaado tem. Ke wâé heme cie ace pilehe péi ne ko a henem, ke me tahiko ole he jié! ");
INSERT INTO cam_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Hemepie e pwo aceli ta {ne kom} wo pa céiu acéihi béém, ke go paciheeng ehi. Ke mepie e pininim, ke me e biteeng, ke go pineuhi ni ta pwo ten. ");
INSERT INTO cam_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ke mepie e tee pwo celi ta ne kom, ke mepie e te âmwobé pii tem pie e pininim, ke go pineueng.» ");
INSERT INTO cam_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","É ha a céiu tan, ke lé pii te Padaame Iésu wo lépwo *apostolo pie: «Ne teme a céihi celi nihe ubwo!» ");
INSERT INTO cam_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ke e pii telé pie: «Hemepie a céihi tewé, ke me te ju wahin pwohewii a pide moutarde, ke o te jan me geé pii te a acuwo ce pie: “Go tawii ni waam mu éni, ke go ole cuwo he jié!”, ke e o te pitabemikewé.» ");
INSERT INTO cam_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","E pacémunilé mwo wo Iésu, ke e pii telé pie: «Geé cuwoteeke niimihi a bwomunen ce: Pwo pa apenem de pa daame, na e umi ni apwoamu, ke e wéihi muto. Ke me e âmwobé mu he ni apwoamu, ke time e uce pii ten wo pa daame pie: “Go â wiinaado.” ");
INSERT INTO cam_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kehe e pii ten pie: “Go piwâam ko a wiinaado tong! Ke é alecehen, ke go taatééhi ni epwénem, ke go âbé penem dong, beme é wiinaado ke me é ûdu. Ke é alecehe anaa, ke go bwobe wiinaado ke ûdu.” ");
INSERT INTO cam_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Time e uce olééhi ne te pa apenem den wo pa daame be e pwo nina e ilehi! ");
INSERT INTO cam_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","«Te piwien ne mwo kowé jenaa, heme geé pwo ati nina e pii wo Padué, be wâé heme geé pii pie: “Wogeme lépwo apenem na piticenaado ne kome. Ke geme te ju pwo cehi nina me geme pwo.”» ");
INSERT INTO cam_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","E mwo ko â he pwaaden nge *Iérusaléma mu Galilé wo Iésu. Ke e tuie nge ha a céiu duaan na e mwonuhi a amu *Samari. ");
INSERT INTO cam_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ke e â taa ha a céiu mwopopwaalé. Ke me e tehene ngen, ke lé âbé beniieng lépwo katia na 10 jélé. ");
INSERT INTO cam_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Ke lé te pimu ité koja Iésu, ke lé cihe da ko miiden ko pii pie: «Iésu, Padaame, go pipwoééheme!» ");
INSERT INTO cam_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ke e alilé wo Iésu, ke e pii telé pie: «Geé ân, ke geé pihabwiikewé ne te lépwo *apwoâpwailo.» Ke me lé mwo ko ân, ke caa te wâé jélé kuti. ");
INSERT INTO cam_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ke heme e alihi wo pa céiu béélé pie caa wâé nang, ke e mwojuia, ke e cihe da ko miiden, ke e pii pie: «Wâé Padué!» ");
INSERT INTO cam_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ke e tidihi jilin ne ânebuhe Iésu, ke e ti pwo bwohemwo a bwaaden, ke e pwo-olé ten. Pa apulie naa, ke pa apulie mu Samari. ");
INSERT INTO cam_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ke e pii ten wo Iésu pie: «Tai wogewé lépwona 10 gewé, ke time uce tai wâé gewé? Ke kona élé wé lépwona 9 jélé? ");
INSERT INTO cam_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","É mu hadeniilé ati, ke te tice paceli e mwojuia cemwo beme e pipaunu Padué, kehe te icehi wogo pa aâbé! ");
INSERT INTO cam_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Go cuwoda, ke go engen, be e caa pwo me wâé go na a céihi tem.» ");
INSERT INTO cam_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","É ha a céiu tan ke lé tahimwo Iésu ni béé *Farasaio pie: «He éniile celi e o bo âbé a *Mwametau te Padué?» Ke e pii telé pie: «A Mwametau te Padué, ke o time e uce âbé pwohewii ace céiu naado celi genye alihi. ");
INSERT INTO cam_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ke o time uce jan me geé pii pie: “E éni” ai “E lang”. Be a Mwametau te Padué, ke caa e ha awiemewé.» ");
INSERT INTO cam_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","É alecehen, ke e pii te lépwo acémun den wo Iésu pie: «E o âbé a benaamwon na o nimewé me geé aliéo, woéo pa Nahi Apulie, ha ace tan celi ju céiu, kehe o time geé uce aliéo. ");
INSERT INTO cam_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Pwo ni apulie na lé o pii tewé pie: “E jeoté” ai “E éni”, kehe geé nemwo ân; geé nemwo téte ngen. ");
INSERT INTO cam_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Be a bwo âmwobé tong, woéo pa Nahi Apulie, ke o pwohewii a ilehi heme e pwéélang ati ha a miiden, mu ha a céiu baaéén die ha a céiu baaéén. ");
INSERT INTO cam_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Kehe, é ânebuhe ninaa, ke wâé heme é mu he ni picani, ke me lé téétiéo ne ni apulie jenaa.» ");
INSERT INTO cam_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«A tan na é bo âbé hen, woéo pa Nahi Apulie, ke o pwohewii a benaamwon de Noé. ");
INSERT INTO cam_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Be lé teko wiinaado me ûdu ne ni apulie, ke lé piaten, ke lé ne ni naîlé toomwo me lé aten. Ke te tice aceli lé temehi dieli ha a tan na e taa ha ali ong wo Noé. Ke e te âbé kuti ali tilihi amu, ke lé tai mele ati ni apulie naa. ");
INSERT INTO cam_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","«Ai o pwohewii a benaamwon de Lota. Be lé teko wiinaado me ûdu ne ni apulie, ke lé icuhinaado me pwocuhinaado, ke lé cemi, ke lé pacuuli ni mwa. ");
INSERT INTO cam_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ke é ha a tan na e wie mu *Sodome wo Lota, ke wo Padué, ke e pwo me tupwo mu he miiden a miû, ke a muu pule na éle. Ke lé tai mele ne ni apulie naa. ");
INSERT INTO cam_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ke é pii tewé pie, o piwie a bwo téetihi nen de ni apulie ha a tan na é o pihabwiiéo, woéo pa Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","«É ha a tan naa, ke wo pana e âoté pwomwo, ke e nemwo taamwo hane ni naamuun ne ha a mwa ten. Ke wo pana e mu ha apwoamu, ke e nemwo mwojuia ngemwo pelen. ");
INSERT INTO cam_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Geé te piniimi êgi mwode Lota li e niê ocemwo. Be lé mele ibu me lépwo Sodome. ");
INSERT INTO cam_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","«Be wo paceli e hane me e cile a mulihen, ke e o patieden. Kehe wo paceli e patieden a mulihen, ke e o cile dieli mwo. ");
INSERT INTO cam_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Éa, é pii tewé pie: É ha a bwén naa, ke alo ni apulie ne pwo ace apule, ke o pé pace céiu, ke o ne pa céiu. ");
INSERT INTO cam_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ke alo lu toomwo na lu ko cemeii blé ibu, ke o pé ê céiu, ke o ne ê céiu. { ");
INSERT INTO cam_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","«Ke wo lupwo apulie na lu mu ha apwoamu, ke o pé pa céiu, ke o ne pa céiu.»} ");
INSERT INTO cam_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ke me lé téne anaa wo lépwo acémun den, ke lé tahimwo Iésu pie: «Padaame, e o bo tuie ne wé anaa?» Ke e pii telé pie: «Geé ûmiê, me geé alihi ni béhabwiinen. Be pwohewii ana nye mu pii pie: “É he na e lang a déhi wota, ke lé taineibulé nelang ne ni bwaaoléé.”» ");
INSERT INTO cam_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","E pii a ocine ce wo Iésu te lépwo acémun den, beme e habwii telé pie, wâé heme nye cuwo ko pwoiitihi, kehe me nye nemwo pwo me mwaale genye. ");
INSERT INTO cam_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","3","Ke e pii telé pie: «E bwo mu wo ê céiu depwele na te tice den. Ke é ha a céiu tan, ke e â céii pa céiu atautinaado, pa apulie na nihe ubwo nang beme e ilehi kojaeng pie, me e cuwoko pa céiu apulie me e uje ne mwo ten ana te a den. Ke e pii ten wo êje pie: “Pa daame, go picani tong, ke go pwo ana mwomwon me dong!” «Kehe icehi ana wo pa atautinaado, ke time uce pa apaciiti Padué, ke time e uce paciiti lépwo apulie mwo. ");
INSERT INTO cam_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Ke muhi ten, ke e pamwojuia êgi depwele. Kehe e te cuwo ko âbé céiieng wo êje ati he ni tan, dieli e o bo te â téneeng. «Ke nebwén, ke e pii ten wo pa atautinaado pie: “Te tice aceli é alihi ne ko Padué. Ke te tice aceli é alihi ne ko lépwo apulie na lé pwohewii ê depwele ce. Kehe icehi ana te junihe mwaale jo kon! Ke é o caa ne ten a mwomwon, beme o time e uce tee âbé iliéo!”» ");
INSERT INTO cam_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ke e pii mwo wo Padaame Iésu pie: «Geé cuwoteeke alihi ana e tuie! ");
INSERT INTO cam_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","E picani ten wo pa atautinaado naa, na ta nang. Ke kona wo Padué, ke o time e uce téne ni apulie ten, ke me e picani telé, heme lé todeeng heme bwén ke pwang? ");
INSERT INTO cam_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Uhuu! E o te ju piepin ko ténelé. Kehe icehi ana me é o mwojuia cemwo ne éni pwo bwohemwo woéo pa Nahi Apulie, ke he é o mwo te too ce apulie celi lé céihi?» ");
INSERT INTO cam_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Pwo ni apulie na lé niimihi pie lé *mwomwon ne he pwahamii Padué, ke lé tééti ni béén. Ke e pii a ocine ce wo Iésu ne kolé pie: ");
INSERT INTO cam_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Lu bwo mu wo lupwo apulie na alo julu: Pa *Farasaio pa céiu, pa apulie na ubwo nang ne ha a pwoiitihi. Ke pa *atai mwani cuhi puni apulie pa céiu, pana e mu bune he ni mwani naa. Ke é ha a céiu tan, ke lu â pwoiitihi ne *huâ iitihi. ");
INSERT INTO cam_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","«Ke e cuwoda wo pa Farasaio, ke e pwoiitihi pii pie: “Padué hung, é pipwo-olé tem, be time é uce pwohewii nina ta ni mulihelé. Be time lé uce juuju, ke lé bune, ke lé pibune. Ke time é uce wonaa! Ke é pipwo-olé tem, be time é uce pwohewii pa atai mwani naa. ");
INSERT INTO cam_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Be é te piténedehi ati ni patén ko a pwoiitihi. Be é mu patupwo wiinaado, beme é pwoiitihi tem, é he na alo tan ha a naadenitan. Ke é mu ne tem a âpipati ko ni âpenem dong.” ");
INSERT INTO cam_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","«Ke mepwo é ne ko pa atai mwani cuhi puni apulie, ke te time uce jan ne kon me e alehede da he miiden he e pwoiitihi. Ke e picii a bwaangen, be piwahin nang. Ke e pii te Padué pie: “Padué, go pipwoééhung. Be woéo ke pa apulie na ta jo!”» ");
INSERT INTO cam_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ke e pii wo Iésu pie: «Wooélé mu ko lupwonaa, na e pwo me wâé a pwonimen wo Padué? Wooélé pana e mwomwon ne he pwahamiin? Te wo pa atai mwani cehi, kehe time uce wo pa Farasaio. Be wo pana e pwo me piubwo nang, ke o neeng ole, ke wo pana e pwo me piwahin nang, ke bo neeng da.» ");
INSERT INTO cam_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Lé âbé céii Iésu wo lépwo béé apulie, ke lé pébé céiieng ni cuwo nahi ewa, beme e ti kolé ke me adéilé. Kehe icehi ana he lé alihi anaa wo lépwo acémun den, ke lé cihe me ubwo ne kolé, ke lé pacuwolé. ");
INSERT INTO cam_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kehe e pii telé wo Iésu pie: «Geé ne ni cuwo nahi ewa me lé âbé céiiéo. Geé nemwo pacuwolé, be a *Mwametau te Padué, ke a de ni apulie na lé pwohewii ni cuwo nahi ewa. ");
INSERT INTO cam_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Éa, é pii tewé a juuju pie: Wo pa apulie na time e uce hegi a Mwametau te Padué pwohewii ni cuwo nahi ewa, ke wo panaa, ke o pwocoon ne kon me e taa hen.» ");
INSERT INTO cam_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","E âbé céii Iésu wo pa céiu apihuô ko pwoiitihi te lépwo *Juif, ke e tahimwoeng pie: «Pa apipune, wogo pa apulie na te junihe wâé go kuti. He ade aceli me é pwo, beme é hegi a *mulie dieli mwo ne pele Padué?» ");
INSERT INTO cam_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ke e hegi ne ten wo Iésu pie: «Kona é mu ko ade na go pii kong pie, woéo ke pa apulie na wâé jo? Be te tice pace apulie celi wâé nang, kehe te icehi Padué. ");
INSERT INTO cam_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ke hemepwo é ne ko a bwo tahimwohi nen dem ke go temehi ehi ni patén: Go nemwo pibune; Go nemwo taunuhi apulie; Go nemwo bune; Go nemwo pii ce pwooti celi ni gele ne ko ce béé apulie; Go paciiti lu nyaa me caa tem.» ");
INSERT INTO cam_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ke e hegi ne ten wo pali apulie pie: «É caa te ténedehi kuti ninaa, ha a bwo mwo wahin jo.» ");
INSERT INTO cam_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ke e pii ten wo Iésu pie: «Go téne, te ju céiu cehi a naado na mwo tieden kojako: Go engen, ke go â icuhi ati ni dem, ke go pé ni cuhin, ke go ne te nina tice delé. Be me wonaa, ke o pwo ce dem ne pele Padué. Ke nebwén, ke go âbé céing.» ");
INSERT INTO cam_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kehe me e téne anaa wo paje, ke te junihe piwahin nang, be te junihe pwo den. ");
INSERT INTO cam_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ke e piniê céin wo Iésu, ke e pii te lépwo acémun den pie: «Geé alihi, wo lépwona te junihe pwo delé, ke te junihe pwocoon ne kolé me lé taa ha a Mwametau te Padué! ");
INSERT INTO cam_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","«Kona a chameau, ke o te jan ne kon, me e taa ha a pwon ko a diti? Ke é pii tewé pie: Wo pa apulie na pwo den, ke mwo te junihe pwocoon ne kon, me e taa ha a Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lé te junihe téele kuti wo lépwona lé téne anaa, ke lé te pipii telé pie: «Ke kona woo paceli jan me e piceluimieng?» ");
INSERT INTO cam_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Ke e pii telé pie: «Ana time uce jan ne ko pa apulie me e pwo, ke te tai jan ne ko Padué.» ");
INSERT INTO cam_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ke e pii ten wo Pétéru pie: «Wogeme, ke geme caa patupwo ati ni deme, beme geme âcéim!» ");
INSERT INTO cam_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ke e pii telé wo Iésu pie: «É pii tewé a juuju pie: Wo paceli e patupwo a pomwa ten, ai ê mwoden, ai ni âjiénen, ai lu acileeng, ai ni naîn, watihen a Mwametau te Padué, ");
INSERT INTO cam_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ke o tabuhi jenaa, ke e bo hegi ce naado celi piwéden, celi te junihe ubwo ke hiwon. Ke é alecehen, ke e bo hegi a mulie dieli mwo ne pele Padué.» ");
INSERT INTO cam_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","E pé itéhi lépwo 12 acémun den wo Iésu, ke e pii telé pie: «Geé téne, genye o caa taa *Iérusaléma, ke é nelang he na o caa pajuujuhi ati nina lé tii wo lépwo péroféta ne kong, woéo pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","«Be o neéo te nina te tice céihi telé. Ke lé bo pihooniéo, ke lé bo pwotahi ne kong, ke lé bo cumi ne kong, ");
INSERT INTO cam_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ke lé o ahiéo ko a bwaliiwota. Ke lé o pwo me é mele. Kehe icehi ana é ha a béciéhe ni tan alecehen, ke é o mulie cemwo mu ha amele.» ");
INSERT INTO cam_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kehe time lé uce temehi ana e pii wo lépwo acémun den. Be neduwohi kojalé a bwopiinen. ");
INSERT INTO cam_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Lé mwo teko â Iérusaléma wo Iésu me lépwo acémun den. É he lé ko piâmwonuhi Iériko, ke pwo pa bwi na e tebwo ko a jije pwaaden, ke e ile be pana te tice den. ");
INSERT INTO cam_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","É he e téne a pubu apulie he ko âbé, ke e tahimwohi pie, he ade. ");
INSERT INTO cam_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ke lé pii ten pie, wo Iésu mu Nazaret na e ko âdé. ");
INSERT INTO cam_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ke e cihe da ko miiden ko pii pie: «Iésu, pa *Naî Davita, go pipwoééhung!» ");
INSERT INTO cam_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ke wo lépwona lé engen ânebuhe Iésu, ke lé pihaaeng, beme e nemwo cihe. Kehe icehi ana e bwo junihe cihe da ko miiden kuti, ke e pii pie: «Pa Naî Davita, go pipwoééhung, ke go picani tong!» ");
INSERT INTO cam_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ke e â cuwo wo Iésu, ke e pii pie, me lé pééeng bé céiieng. Ke me e âbé mwonueng wo pali bwi, ke e tahimwoeng wo Iésu pie: ");
INSERT INTO cam_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Ade aceli nimem me é pwo me dem?» Ke e hegi ne ten pie: «Padaame, me é niê mwo!» ");
INSERT INTO cam_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ke e pii ten wo Iésu pie: «Niê mwo! Be caa wâé go mwo mu ko a céihi tem!» ");
INSERT INTO cam_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ke e te niê kuti, pwohewiin ânebun. Ke e âcéi Iésu, ke e pipaunu Padué. Ke lé tai pipwoun de Padué ati ni apulie na lé alihi anaa. ");
INSERT INTO cam_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","E â taa Iériko wo Iésu, ke e pitahagéi a pwomwo ubwo, ");
INSERT INTO cam_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","he e ko mu lang wo pa apulie na pii kon pie Zaché, pa caa te lépwo *atai mwani cuhi puni apulie. Pa apulie na piubwo nang, ke junihe pwo den. ");
INSERT INTO cam_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E hane me e ali Iésu. Kehe pwocoon, wonaa mu ko a pubu apulie, be ju bahin nang. ");
INSERT INTO cam_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ke e téte nge ânebuhe ni apulie, ke e â taa pwo a acuwo sycomore, beme e ali Iésu, heme e âbé lang. ");
INSERT INTO cam_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Me e tehenebé wo Iésu ha a duaan naa, ke e eti da ni naamiin, ke e pii ten pie: «Pa daame Zaché, go epin ko ole, beme é mu ha a mwa tem jenaa!» ");
INSERT INTO cam_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ke e te epin kuti ko a bwo ole ten wo Zaché, ke e hegi Iésu ne pelen ne ha a pipwodéén. ");
INSERT INTO cam_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","He lé alihi anaa wo lépwo apulie, ke lé pihuu, ke lé pii pie: «E â mu pele pa apulie na ta nang.» ");
INSERT INTO cam_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ke e cuwo ânebuhe Padaame Iésu wo Zaché, ke e pii ten pie: «Go alihi, go Padaame, é o bo ne te lépwona tice delé a céiu duaa ni dong. Ke mepie é pwotahinaado ne ko pace céiu, ke é o bo ne ten me opaa mu ko ana me é ne.» ");
INSERT INTO cam_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ke e hegi ne ten wo Iésu ne he pwahamii ni apulie pie: «E celuimikewé wo Padué, wogo me a mwa tem! Be go habwii pie pa ju piebehi *Abérama! ");
INSERT INTO cam_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Be woéo, pa Nahi Apulie, ke é âbé hane ke *celuimi lépwona lé pipatieden.» ");
INSERT INTO cam_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hiwon ni apulie na lé ko téne a pwooti te Iésu. Ke e piuti telé a céiu ocine beme lé temehi a ju bwomunen ne ha a *Mwametau te Padué. Be caa e mwonu *Iérusaléma, ke lé niimihi pie, wieli e o caa pacuwohi a Mwametau he e â taa ha a pwomwo ubwo. ");
INSERT INTO cam_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ke e pii pie: «E bwo mu wo pa céiu apulie na e mu ha a pwomwoiu na nihe pwonaado ne kon. Ke lé bwo todeeng beme pa daame ha amu ten. Ke e bwo pipwopweehi a bwo engen den nge ha a céiu amu na éité, beme e ali pa daame ubwo nelang, me hegi a pihuô ten. ");
INSERT INTO cam_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ke e tode lépwona 10 jélé mu ko lépwo eabwé ten, ke e muko pétaapwo ne telé ni mwani megele na hiwon, ke e pii telé pie: “Geé penem kon dieli é bo âmwobé.” Ke nebwén, ke e engen, beme e hegi a pihuô ten. ");
INSERT INTO cam_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«Kehe lé téétieng ni béé apulie ha amu ten, ke lé ne ni apulie nge ha amu na e â hen, beme lé pii te pa daame ubwo pie: “Te muhi teme me pa apulie ce, ke me e pihuô teme.”» ");
INSERT INTO cam_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","«E caa te pwo me e daame. Ke nebwén, ke e mwojuia mwo. Ke e todebé ne pelen lépwo eabwé ten li e ne telé li mwani, beme e temehi pie, he niile celi e taa ne mwo pwon. ");
INSERT INTO cam_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ke e âbé wo pa bécéiuhen, ke e pii pie: “Pa daame, go ne tong ana 1 million, ke e taa ne pwon nina 10 million.” ");
INSERT INTO cam_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","«Ke e pii ten wo pa daame pie: “Wâé! Wogo pa eabwé na wâé go; be go piténedehi ne he ni naado na wahin. Ke go pé a pihuô ne ko nina 10 ni pwomwo ubwo.” ");
INSERT INTO cam_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","«Ke e âbé wo pa béalohen, ke e pii pie: “Pa daame, go ne tong ana 1 million, ke e taa ne mwo pwon nina 5 million.” ");
INSERT INTO cam_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","«Ke e pii ten wo pa daame pie: “Wâé! Wogo mwo, go pihuô ne pwo nina nim ni pwomwo ubwo.”» ");
INSERT INTO cam_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","«E âbé wo pa céiu, ke e pii ten pie: “Pa daame, go ne tong ana 1 million ke é cile ne ha a mwaanu. ");
INSERT INTO cam_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Be mwotiéo kom, be pa apulie na go okéé ne ko lépwona time lé uce penem ehi. Ke go taineibuhi nina time go uce penem kon, ke go tii ni âdaanu na time go uce cemi.” ");
INSERT INTO cam_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","«Ke e pii ten wo pa daame pie: “É tautiko mu ko nina go pii, pa eabwé na ta go! Be go te temehi pie woéo, ke pa a-okéé, ke é taineibuhi nina time é uce penem kon, ke é tii ni âdaanu na time é uce cemi. ");
INSERT INTO cam_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","É mu ko ade na time go uce ne ha a mwomwani a mwani tong?! Be hemepie go ko wonaa, ke wieli é o te céi ne pehi celi e taa ne pwon!” ");
INSERT INTO cam_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","«Ke e pii te lépwona lé mu lang wo pa daame pie: “Geé pé kojaeng a 1 million na eten, ke geé ne te pana eten nina 10 million.”» ");
INSERT INTO cam_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","«Kehe lé pii ten pie: “Pa daame, caa eten ni mwani na te junihe hiwon wéden!” ");
INSERT INTO cam_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","«E hegi ne telé wo pa daame pie: “Wo pana caa pwo ne ten, ke o ne mwo pwon ce béén. Kehe wo pana te tice ten, ke o pétaabwon kojaeng a nehinaado na mwo e pelen. ");
INSERT INTO cam_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","É ne ko lépwona ta jélé ne kong, ke lépwona te muhi telé me é pihuô ne kolé, geé péélé bé ne éni, ke geé taunulé ne ânebuhung!”» ");
INSERT INTO cam_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","É alecehe a bwo piuti nen den a ocine naa, ke e engen wo Iésu beme e taa Iérusaléma. Ke lé alecehen wo lépwo 12 acémun den. ");
INSERT INTO cam_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ke lé piâmwonuhi lupwo mwopopwaalé, Betfagé me Bétani, die pwo a juwole ko ni Olivier. Ke e mi ne ngen lupwo alo acémun den wo Iésu, ");
INSERT INTO cam_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ke e pii telu pie: «Geu â ha a mwopopwaalé na e ânebuhenye. Ke me geu â taa hen, ke geu bo tooli a nahi buriko na lé taaeng, na mwo te tice apulie celi lé mu tebwo huîin. Ke geu tuwoeng, ke geu pééeng bé. ");
INSERT INTO cam_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ke mepie lé tahimwokeu pie: “É mu ko ade na geu tuwoeng?”, ke geu hegi ne telé pie: “Nime Padaame kon.”» ");
INSERT INTO cam_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ke lu ân, ke lu tooli ali nahi buriko, pwohewii nina e pii telu wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","É he lé mwo ko tuwoeng, ke lé tuiebé wo lépwo eapwihin, ke lé pii telu pie: «É mu ko ade na geu tuwo a nahi buriko naa?» ");
INSERT INTO cam_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ke lu hegi pie: «Nime Padaame kon.» ");
INSERT INTO cam_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ke lu pébé céii Iésu ali buriko. Ke lé tai ne ni epwén huîin wo lépwo acémun den, ke lé pwo me e taa tebwo huîin wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","É heme e ko piân, ke ni apulie, ke lé talihi ni mwaanu telé nge pwo a pwaaden ânebuhe Iésu beme lé pipaunueng. ");
INSERT INTO cam_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ke lé piâmwonuhi a duaan he na e mu lang a ole ko a pwaaden mu ko a juwole ko ni Olivier ke e â Iérusaléma. Ke lé tai pipwodéén wo lépwo apulie, ke lé cihe da ko miiden, beme lé pipaunu Padué mu ko ni *pipwojunuun na lé alihi. ");
INSERT INTO cam_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ke lé toii da pie: *Adéi Padaame ce! E âbé ne he nii Padué! A péém ne he miiden! Wâé ne he ni duaan na daaité! ");
INSERT INTO cam_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Kehe icehi ana wo lépwo béé *Farasaio na lé mu lang, ke lé pii te Iésu pie: «Aje, go pacihe lépwo acémun dem!» ");
INSERT INTO cam_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ke e hegi ne telé pie: «É pii tewé pie, mepie time lé cihe, ke ni péi ce, ke lé bo pipaunu Padué!» ");
INSERT INTO cam_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","E ko piâmwonuhi Iérusaléma wo Iésu, ke me e alihi a pwomwo ubwo, ke e é pain. ");
INSERT INTO cam_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ke e pii pie: «Au, mwolihi! Iérusaléma, nihe nimung me wogo mwo, ke me go tooli a péém jenaa. Kehe icehi ana te muhi tem, ke é jenaa, ke caa pwocoon me go alihi. ");
INSERT INTO cam_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Be o caa time uce bwolihi, ke lé o âbé céiiko wo lépwona muhi telé kom. Ke lé o cubwoniko na ati he ni piduaan. Ke lé bo pwopa ne kom. Ke o time uce jan me go taunulé be hiwon ni babé ataduwo telé na lé pwo aujeniko. ");
INSERT INTO cam_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ke lé bo tanahi ni goomwa babé bwonihi a amu tem. Ke time e bo uce mu mwo ace céiu péi pwo ace céiu. Ke lé bo caaitekewé, me ati ni apulie tem. Wonaa be time go uce alihi temehi ali benaamwon li e âbé céiiko hen wo Padué beme e celuimiko.» ");
INSERT INTO cam_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Lé tuie nge Iérusaléma ke e taa *huâ iitihi wo Iésu. Ke e peni wie lépwona lé pwojenep nelang. ");
INSERT INTO cam_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ke e pii telé pie: «Geé caa te temehi ali e pii wo Padué ne he ni tii iitihi pie: A mwa tong, ke bo toii kon pie a mwo ko pwoiitihi. Kehe wogewé, ke geé ko pwo me ataduwo te lépwo abune!» ");
INSERT INTO cam_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ke é alecehen, ke e pacémuni ni apulie ne huâ iitihi wo Iésu, ati he ni tan. Ke é ne ko lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén me lépwo apihuô, ke lé tabuhi hane ace bwopwonen beme lé taunueng. ");
INSERT INTO cam_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kehe icehi ana time lé uce tooli, be nihe hiwon ni apulie na lé cedihi ni pwooti na e pacémunilé kon. ");
INSERT INTO cam_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","E mu pacémuni lépwo apulie ne *huâ iitihi wo Iésu, ke e patemehi telé a Pwooti Wâé. Ke é ha a céiu tan he e mwo teko wonaa, ke lé âbé céiieng wo lépwo béé caa te lépwo *apwoâpwailo, me lépwo béé *dotéén ko patén, me lépwo béé apihuô. ");
INSERT INTO cam_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ke lé tahimwoeng pie: «Aje, wooélé na e ne a pihuô tem me go pwo nina go ko pwo? Wooélé na e pahedeko?» ");
INSERT INTO cam_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ke e hegi ne telé pie: «Woéo mwo, ke é o mwo tahimwokewé ko a céiu naado. Weengi: ");
INSERT INTO cam_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wooélé na e ne a pihuô te Ioane me e *pipuu apulie? Wo Padué, ai ni apulie?» ");
INSERT INTO cam_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ke lé te nihe picihe kon, ke lé pipii telé pie: «Mepie genye hegi ne ten pie: “É mu ko Padué”, ke e o pii tenye pie: “Ke é mu ko ade na time geé uce céihi ne ko nina e pii tewé wo Ioane?” ");
INSERT INTO cam_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ke mepie genye hegi ne ten pie: “É mu ko ni apulie”, ke wieli lé bo ahikenye ko péi ne ni apulie. Be lé tai céihi me ubwo pie, wo Ioane, ke pa péroféta te Padué.» ");
INSERT INTO cam_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ke é mu ko anaa, ke lé hegi ne te Iésu pie: «Meniing, time geme uce temehi.» ");
INSERT INTO cam_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ke e pii telé pie: «Ke woéo mwo, ke time é o uce pii tewé pie, he wooélé na e ne tong a pihuô me é pwo nina é ko pwo.» ");
INSERT INTO cam_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wo Iésu, ke e piuti te lépwo apulie a ocine ce: «E bwo mu wo pa eapwihi a ni tabe megele. Ke e bwo cemi apwoamu ten. Ke nebwén, ke e niimihi pie me e mwo â pitabée ha ace céiu amu, ke e pwocuhi ni béé apulie, beme lé wéihi ali ni tabe megele ten. Ke e engen, ke te nihe bwolihi a bwo mu ten ha amu naa. ");
INSERT INTO cam_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Pwo ni wole alecehen ke tuie nge ha a benaamwon ko tabwo ace tabe megele. Ke e ne ngen pa céiu apenem den, beme e hegi koja lépwoli awéa ko ali ni tabe megele, ace den mu ko a pitii âdaanu. Kehe icehi ana lé ahieng, ke lé neeng ngemwo, he te tice celi lé ne ten. ");
INSERT INTO cam_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","«Ke é mulang, ke e ne mwobé pa céiu apenem den. Ke lé piciheta ne kon, ke lé ahieng mwo. Ke lé pamwojuieeng mwo, he te tice celi lé ne ten. ");
INSERT INTO cam_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ke nebwén, ke e ne ngemwo pa béciéhe ni apenem den, ke lé piahieng, ke lé picibééeng. ");
INSERT INTO cam_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","«Ke nebwén, ke e pipii ten wo pali eapwihi ali ni tabe megele pie: “He ade aceli me é bo pwo? É bo ne ngen pali ju naîng na nihe eânimung den. Be wieli lé bo paciitieng”. ");
INSERT INTO cam_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","«Kehe icehi ana me lé alieng he e tehene ngen, ke lé pipii telé pie: “Geé téne, te weengaa kuti pana e bo eapwihi ali ni tabe megele ha ace céiu tan. Wâé heme nye taunueng, beme bo a denye ali ni tabe megele!” ");
INSERT INTO cam_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","«Ke lé teuueng wie koja a apwoamu, ke lé taunueng.» Ke wo Iésu, ke e tahimwo lépwona lé ko tabemieng pie: «Ke e bo pwo de wo pali eapwihi ali ni tabe megele? ");
INSERT INTO cam_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","E bo âbé, ke e bo taunu li apulie na ta jélé. Ke e bo uce ne te ce béén ali ni tabe megele, beme lé bo uce wéa kon!» Kehe icehi ana wo lépwona lé tabemi ali ocine, ke lé téetihi, ke lé pii pie: «Ûhu! Pwocoon! Time o uce wonaa!» ");
INSERT INTO cam_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ke e omelé wo Iésu, ke e hegi ne telé pie: «Geé cuwoteeke niimihi ali caa tii ne he ni tii iitihi, pie: Ali péi li lé tahi taabwon wo lépwo abahi mwa, ke te anaa kuti a ju paamwa.» Psaume 118.22 ");
INSERT INTO cam_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«Hemepie e tupwo wo pace céiu apulie ne pwo a péi naa, ke o tatubwi ati a één. Ke mepie e tupwo ali péi ne huîi pace céiu apulie, ke e o ju tagetieng.» ");
INSERT INTO cam_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","20","Lé temehi wo lépwo dotéén ko patén me lépwo caa te lépwo apwoâpwailo, pie e ko pwo-ocine ne kolé wo Iésu. Ke nimelé me lé imwieng, beme lé icueng ne te pa gupéno te lépwo Roma. Kehe icehi ana mwotilé, be hiwon ni apulie na wâé telé nang. Ke lé neeng, kehe lé te piwéa kon. Ke é ha a céiu tan ke lé ne nge céiieng ni béé apulie, beme lé tahimwoeng ko ce naado. Ke woélé, ke lé pii ten pie, nimelé me lé temehi a juuju. Kehe icehi ana lé hane me lé pipé ne kon ko aceli e bo hegi ne telé kon. ");
INSERT INTO cam_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Weengi ana lé pipii me weeng: «Pa apipune, geme temehi pie, go pii a juuju, ke time go uce pipwoinen ne ko ni apulie. Be go te patemehi ati ni naado na nime Padué kon me genye pwo. ");
INSERT INTO cam_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Be anaa kuti ana nimeme me geme tahimwoko pie: He wâé heme nye pwocuhi puni apulie te pa daame he lépwo Roma? Ai time uce wâé?» ");
INSERT INTO cam_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Kehe e te temehi a pipwohuô telé wo Iésu, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Geé cuwoteeke habwii tong ace céiu mwani péi. A démee, ke a nii-î ana e pwo a mwani ce?» Ke lé hegi ne ten pie: «A de pa daame he lépwo Roma.» ");
INSERT INTO cam_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ke e pii telé wo Iésu pie: «Ke caa wâé, ke geé ne mwo te pa daame nina te ni den, ke geé ne te Padué nina te ni de Padué.» ");
INSERT INTO cam_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ke lé te nihe téetihi a bwo hegi nen den, be time uce jan me lé pipé ne kon ne he pwahamii ni apulie. Ke te tice aceli me lé bo uce pii mwo. ");
INSERT INTO cam_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Lé âmwobé céii Iésu wo lépwo béé *Saducéen. Woélé, ke te a céiu dihe pwoiitihi te lépwo *Juif na time lé uce céihi pie, lé o mulie cemwo wo lépwo amele. Lé âbé too Iésu, ke lé pwo me lé habwii pie lé juuju ke lé tahimwoeng pie: ");
INSERT INTO cam_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Pa apipune, e caa tii me denye wo *Moosé ne he ni patén pie: Hemepie e mele wo pace céiu apulie celi te tice naîn, ke wâé heme e pé ê depwele ten wo pa ciéén me lu piaten. Be me wonaa, ke me bo pwo ce piebehi pa amele. ");
INSERT INTO cam_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","«Ke te wâé. Kehe go cuwoteeke niimihi ani: Pwo lépwo pwénaâjién na 7 jélé, ke e piaten wo pa cuwolé, kehe icehi ana e mele he mwo te tice naîn. ");
INSERT INTO cam_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ke wo pa béalohen, ke lu piaten me êgi depwele, kehe icehi ana he e mele mwo wo paje, ke te tice naîlu. ");
INSERT INTO cam_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ke te piwien ne ko pa béciéhen, ke te wonaa mwo ne ko lépwoli 7 jélé. Be lé te tai mele, ke he te tice naîlé. ");
INSERT INTO cam_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ke é alecehelé ati, ke e bwobe mele wo êgi toomwo. ");
INSERT INTO cam_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ke go ko pii pie lé bo mulie cemwo ne ni amele ha ace céiu tan. Ke hemepie wonaa, ke o bo wooélé mu hadeniilé celi bo pa aiu he ê toomwo naa, ha a benaamwon naa? Be caa te tai lépwo aiu hen ati! Ke go cuwoteeke hegi!» ");
INSERT INTO cam_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ke e hegi ne telé wo Iésu pie: «Geé pitalupe! Be nye mwo te piaten cehi ha a benaamwon na nye mwo tee ko mu éni pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","36","Ke o time uce wonaa, he ce benaamwon celi e lang. Be e bo pitaigali ni naîn wo Padué, ke caa te woélé kuti lépwona e piniimihi pie wâé me lé pimu ibu me weeng. Ke e bo pwo me lé mulie cemwo mu ha amele, ke lé bo pwohewii ni *âcélo ten. Be time lé bo uce mele mwo, ke time lé bo uce piaten mwo. ");
INSERT INTO cam_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","«Geé ko tahimwoéo ko a bwo mulie cemwo mu ha amele. He time geé uce temehi ali e pii wo Moosé, he e pwojepule ko ali nahi acuwo li e éle kon ali miû? Be e pii ko Padué pie, Padué he *Abérama, ke Padué he Isaaka, ke Padué he Iakobo. ");
INSERT INTO cam_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","A bwopiinen pie lé teko tai mulie pele Padué! Be time uce Padué he ni amele, kehe Padué he nina lé mulie.» ");
INSERT INTO cam_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wo lépwo dotéén ko patén, ke me lé téne ana e pii wo Iésu te lépwo Saducéen, ke lé pii ten pie: «Nihe wâé kuti ali bwo hegi nen dem, go pa apipune!» ");
INSERT INTO cam_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Be te nihe pipwocoon delé, me lé tahimwo Iésu ko ce béé naado. ");
INSERT INTO cam_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Kehe icehi ana e pii telé pie: «É mu ko ade na lé pii wo lépwo apulie pie, wo pa *Mesia, ke pa apulie na wahin nang koja *Davita?» ");
INSERT INTO cam_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","«Time uce wonaa. Be te wo Davita na e pii ne ha a tii *Psaumes, pie: Pwooti te Padaame Padué, na e pacihe pa daame hung: “Go âbé tebwo éni pwo a juing. É ne tem a pihuô, ke o pipaunuko dieli mwo. É pwo me go caaite nina lé pipwopa ne kom.” Psaume 110.1 ");
INSERT INTO cam_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«Be, me e ko pii wo Davita pie: Padaame hung, ke a bwopiinen pie, wo pa Mesia. Ke me wonaa, ke ade ace watihen me geé niimihi pie, wo pa Mesia, ke time uce pace apulie celi piubwo nang koja Davita?» ");
INSERT INTO cam_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hiwon ni apulie na lé ko tabemi nina e ko pii wo Iésu, ke é ne he pwahamiilé ati, ke e pii te lépwo acémun den pie: ");
INSERT INTO cam_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Geé pipwocile! Geé nemwo pipwohewii lépwo béé dotéén ko patén! Be te junihe wâé telé me lé engen he ni epwén na bwali. Ke wâé telé heme nye tee pwobwocu telé, me pipaunulé ne he pwahamii ni apulie ati. Ke lé te hane ni atebwo ânebun ne he ni *mwotapitihi, ke é ne mwo he ni apiwiinaado na ubwo. ");
INSERT INTO cam_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","«Ke lé te nihe pwo ni jame pwoiitihi, beme nye o niimihi pie ni apulie na wâé jélé. Kehe icehi ana me lé ko wonaa, ke lé pé ati koja ni depwele ni delé! Ke te é mu ko anaa kuti, na o bo ne telé a cuhinaado na te junihe ubwo koja a cuhinaado te ni béén.» ");
INSERT INTO cam_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","E mu *huâ iitihi wo Iésu. Ke e ome ni apulie na te nihe pwo delé na lé ko ne mwani, ne ko a *mwaiitihi. ");
INSERT INTO cam_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ke e alihi mwo ê depwele na tice den na e ne lupwo cuwo nahi mwani péi. ");
INSERT INTO cam_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ke e pii wo Iésu te lépwo acémun den pie: «É pii tewé a juuju pie: Ê depwele ce tice naamuun, ke e ne nina te junihe piwéden koja ni béén. ");
INSERT INTO cam_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Be lé ne ni mwani na piwéden mu ko ni âpenem delé. Kehe wo ênaa, ke te ju tice den, ke e te ne ati ni mwani na jan me e mulie kon.» ");
INSERT INTO cam_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ke é alecehen, ke lé cihe ko ali mwaiitihi ne ni apulie, ke lé pii pie: «Junihe wâé kuti ko ni péi na e gaale kon, ke ni naado na lé ne te Padué mwo!» ");
INSERT INTO cam_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ke e hegi ne telé wo Iésu pie: «Geé te alihi ati ninaa: Be o bo âbé ace tan, celi o bo tanahi taabwon ati ninaa. Ke o time bo uce mu mwo ace céiu péi pwo ace céiu mwo.» ");
INSERT INTO cam_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Lé tahimwo Iésu wo lépwo acémun den pie: «Pa apipune, he éniile celi e o bo tuie ana go ko pii? Ke o ade ace inenaado kon, me geme o temehi pie, caa é mwonu ni naado naa, ke o bo tuie?» ");
INSERT INTO cam_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ke e hegi ne telé wo Iésu pie: «Geé pipwocile, beme geé nemwo pipweéo! Be o hiwon nina lé o âbé heme lé pé a niing. Ke lé o bo pii tewé pie: “Woéo pa *Mesia. Be e caa tuie a benaamwon.” Kehe geé nemwo âcéilé. ");
INSERT INTO cam_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Me geé téne heme lé cihe ko ce pa, ke ce naado na ta ne pwo a bwohemwo, ke geé nemwo pwo me mwotikewé. Be e o mi tuie ninaa, kehe icehi ana time uce téele a pwonehi a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ke e pii telé mwo wo Iésu pie: «A céiu amu, ke e bo pipwopa me a céiu amu. Ke a céiu mwametau, ke e bo pipwopa me a céiu mwametau. ");
INSERT INTO cam_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ke o bo pwo ni penem bwohemwo ne he ni pétaapwo piduaan, ke ni menele, ke ni cunu na nihe ubwo, ke ni naado na te junihe ité ne jeda he miiden. Ke o bo nihe mwoti ni apulie.» ");
INSERT INTO cam_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«Ke ânebuhe ninaa, ke lé bo pwo me geé mu he ni picani. Be lé bo imwikewé, ke lé bo péékewé nge he ni *mwotapitihi beme tautikewé. Ke lé bo tahikewé nge he karépu. Ke lé bo teuukewé nge he pwahamii ni daame me ni gupéno, beme lé tautikewé, watihen a niing. ");
INSERT INTO cam_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ha a benaamwon naa, ke o ne tewé me wogewé lépwo apajuujuéo. ");
INSERT INTO cam_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Geé te ju niimihi ehi pie geé nemwo mi pipwopweehi celi me geé bo pii hemepie lé bo tautikewé. ");
INSERT INTO cam_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Be é bo te ne tewé ce pwooti, ke ce bwo temehinaado. Ke wo lépwona lé pii me ta gewé, ke o bo pwocoon ne kolé me lé hegi ne tewé. ");
INSERT INTO cam_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","17","«Ke lé o bo icukewé mwo ni ukéiu tewé ke ni âjiénewé ke ni bééwé. Ke lé o téétikewé mu kong ati ne ni apulie. Ke lé o bo taunu ni béén mu kowé. ");
INSERT INTO cam_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","19","Kehe wo pana e cumang, ke e bo celuimieng wo Padué. Ke o te tice celi lé o pwo me tatééhi *a ju mulip na e kowé.» ");
INSERT INTO cam_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«Me geé alihi ni mwocoda na lé mu aujenihi *Iérusaléma, ke geé o caa temehi pie, o caa tanahi taabwon a aba. ");
INSERT INTO cam_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Wo lépwona élé pwomwo koja a pwomwo ubwo, ke lé nemwo taa hen! Ke me lé cela epin! Ke ati lépwona lé mu ha amu *Judé, ke wâé heme lé tai cela da pwo ni juwole! ");
INSERT INTO cam_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","23","Au, mwolihi! Be é he ni tan naa, ke o te junihe pwoééhe ni toomwo na pigiaa jélé, me nina lé paditihi ewa. Be lé o te junihe mu he ni picani. Be weengaa a benaamwon na wo Padué, ke e o pwo me lé pwocuhinaado na a bele ten, lépwo *Juif. Ke o wonaa ace bwo pacuwohi ati ne ni pwooti te lépwo péroféta ne he ni tii iitihi. «Ke o te junihe ubwo a pwo-okéé ten, ke lé o te junihe picani ne ni apulie lang, ha a benaamwon naa. ");
INSERT INTO cam_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ke o te junihe hiwon nina o taunulé ko teua. Ke o hiwon mwo nina lé o cielé me péélé nge he ni amu na hiwon, beme ni *apenem tice ja kon de ni apulie lang. Be a benaamwon naa, ke a benaamwon de nina time uce ni Juif. Ke lé o tanahi taabwon ati Iérusaléma. Ke lé o caaite a pule ten me a bele ten, dieli ha a tan na e bo pacuwohi anaa wo Padué.» ");
INSERT INTO cam_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","«É alecehe anaa ke o pwo ni inenaado na ité ne ha a téale, me a wole, me ni ceni. Be lé o penem ni junuunaado he miiden. Ke o te ité mwo a jié, be o bo â ni pilehe pihijié, ke o te junihe ubwo a één. Ke lé o téetihi ati ninaa ne ni apulie pwo bwohemwo. Ke o te junihe mwotilé, ke o cenim jélé, be lé o alihi pie, o caa tuie a benaamwon na caa junihe ta a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ke nebwén, ke lé o bobe aliéo, woéo pa Nahi Apulie, heme é âbé he ni nii, ne ha ati a junuung me a bwo ubwo jo. ");
INSERT INTO cam_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Anaa kuti na é pii tewé pie: Heme geé alihi pie, e caa tabuhi cuwo ni naado naa, ke geé mwoiu me pipwodéén! Be o caa time uce bwolihi, ke e o caa celuimikewé wo Padué!» ");
INSERT INTO cam_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","E pacihelé mwo wo Iésu ko ana e o tuie. Ke e pii telé a ocine ce: «Geé cuwoteeke alihi a majing, be te a céiu acuwo. ");
INSERT INTO cam_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Be, me e tile, ke geé caa temehi pie, caa é mwonu a cim naado. ");
INSERT INTO cam_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Wonaa mwo, heme geé alihi pie e caa ko tuie li é caa pii, ke geé o temehi pie, e o ju téele ne a Mwametau ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ke é pii tewé a juuju pie: Time o uce bwolihi. Be lé o mwo te alihi anaa ne ni béé apulie jenaa, ânebuhe ace bwo mele telé. ");
INSERT INTO cam_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Be o tieden a miiden me a bwohemwo, kehe time o uce tieden a pwooti tong.» ");
INSERT INTO cam_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Geé pipwocile! Geé nemwo mulie ha a mulie hauli, ke geé nemwo junihe ûdu me wiinaado! Ke geé nemwo gia ko ni naado ne éni pwo bwohemwo. Be, mepie geé te mu ko ni naado naa, ke wieli geé o bo téele, ke pitice bwopemikewé heme é âmwobé, ");
INSERT INTO cam_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","pwohewii ati ni béé apulie pwo bwohemwo. Be é o bo tai péélé ati, pwohewii pa apwotau, heme e tahi a pua ten ne ko a bwehi ikua. ");
INSERT INTO cam_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Geé ûmiê! Ke wâé heme geé pwoiitihi te Padué, me ilehi kojaeng pie, me e wéikewé koja ati ni naado na ta na o bo tuie. Ke é bo pipwodéén kowé woéo pa Nahi Apulie, na geé cuwo ânebuhung.» ");
INSERT INTO cam_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","38","É ha a benaamwon na e mu Iérusaléma hen wo Iésu ke e mu taa huâ iitihi he ni tan ati, beme e pacémuni ni apulie. Be lé mu pitapitilé nelang ati he ni acaama, beme lé téneeng. Ke me babwén, ke e mu mwojuia ngemwo pwo a juwole ko ni Olivier, ke e mu lang heme bwén. ");
INSERT INTO cam_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Caa é mwonu a tan ubwo te lépwo *Juif, na pii kon pie a tan ko *Pacika, a tan na lé eni a pwoloa na te tice nyaa ten. ");
INSERT INTO cam_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ke wo lépwo caa te lépwo *apwoâpwailo, me lépwo *dotéén ko patén, ke lé pihane ace bwopwonen beme lé taunu Iésu. Kehe icehi ana mwotilé ko ni apulie. Be te junihe hiwon nina lé mu ko Iésu. ");
INSERT INTO cam_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ke é ha a benaamwon naa, ke wo *Caatana, ke e te taa kuti ko Judas Iscariot, pa céiu béé lépwo 12 *apostolo te Iésu. ");
INSERT INTO cam_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ke e engen, ke e â too lépwo caa te lépwo apwoâpwailo, me lépwo caa te lépwo awéihi *mwaiitihi. Ke e pii telé pie, me e bo patupwo Iésu ne telé. ");
INSERT INTO cam_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ke lé te junihe pipwodéén kuti, ke lé pii ten pie, me lé bo ne ten ce mwani. ");
INSERT INTO cam_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ke é alecehen, ke e pihane pwaaden, ité koja a pubu apulie, beme e icu Iésu telé. ");
INSERT INTO cam_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","E caa tuie a bécéiuhe tan ko ‘pieni pwoloa tice nyaa ten’, a tan na lé mu taunuhi a nahi muto me de a Pacika. ");
INSERT INTO cam_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ke wo Iésu, ke e patupwo nge *Iérusaléma Pétéru me Ioane, ke e pii telu pie: «Geu mi â ha a pwomwo ubwo, ke geu piwâam ko a wiinaado tenye ko Pacika.» ");
INSERT INTO cam_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ke lu tahimwoeng pie: «É wé he celi nimem me genye piwiinaado nelang?» ");
INSERT INTO cam_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ke e hegi ne telu pie: «Mepie geu â taa ha a pwomwo ubwo, ke o pitapitikewé me pa apulie na e pé a mwotabe, ke geu âcéin. Ke me e â taa ha a mwa, ");
INSERT INTO cam_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ke geu pii te pa eapwihin lang pie: “E tahimwohibé wo pa apipune teme pie, e wé ace nemwa, celi me geme o pieni ibuhi ne hen a wiinaado ko a Pacika?” ");
INSERT INTO cam_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","«Ke e o habwii teu a céiu nemwa na e ko miiden, a nemwa ubwo na caa pipwopweehi. Ke geu piwâamihi a wiinaado tenye nelang.» ");
INSERT INTO cam_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ke nebwén, ke lu engen wo Ioane me Pétéru, ke lu te tai tooli pwohewii ana e pii telu wo Iésu. Ke lu piwâamihi a wiinaado ko Pacika. ");
INSERT INTO cam_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","É he babwén, ha a benaamwon na lé piwiinaado hen, ke lé tebwo pwo taap wo Iésu me lépwo 12 apostolo ten. ");
INSERT INTO cam_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ke e pii telé pie: «Caa bwolihi na é ucéihi a benaamwon ce, me nye piwii ibuhi a wiinaado ko Pacika, ânebuhe a bwo mu he ni picani tong. ");
INSERT INTO cam_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Be é pii tewé pie: O time é bo uce wii mwo a wiinaado ce me wogewé ne éni pwo bwohemwo. É bo wiinaado mwo ne ha a *Mwametau te Padué, hemepie é bo panebwénihi a penem ko a ju Pacika.» ");
INSERT INTO cam_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ke e pé a mwoûdu ko tabe megele. Ke e pwo-olé te Padué, ke e pii telé pie: «Geé pé, ke geé piûdu hadeniiwé. ");
INSERT INTO cam_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Be é pii tewé a juuju pie: O caa time é bo uce ûdu mwo ace tabe megele ne éni pwo bwohemwo dieli ha ace tan celi e bobe ne a Mwametau ten wo Padué.» ");
INSERT INTO cam_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ke e pé a pwoloa, ke e pipwo-olé te Padué. Ke e ebii, ke e pwopatihi ne kolé, ke e pii telé pie: «Ani, ke a ééng na é patupwo me dewé. Geé pwo ani beme geé pipaniimiéo.» ");
INSERT INTO cam_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","É alecehe a piwiinaado, ke e pé ali mwoûdu ko tabe megele, ke e pii telé pie: «A mwoûdu ce, ke a inenaado ko a *piapwo na mwo coho, na e pwo wo Padué ko a cewéhung na o caa tée. Be o wonaa a bwo ne a péém ne ha awiemewé me weeng.» ");
INSERT INTO cam_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","22","E pii telé mwo pie: «Wâé heme é mele, woéo pa Nahi Apulie, beme pacuwohi a bwo niimihinaado te Padué ha atabuhi kon. Kehe wo pa apulie na e pi-icuéo, ke o te junihe pwoééhen! Ke geé alihi, wogewé lépwo bééng, be teko e pelenye ne éni, be nye teko wiinaado me weeng.» ");
INSERT INTO cam_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ke lé téetihi a pwooti naa wo lépwo acémun den, ke lé caa tabuhi pitahimwolé pie: «He woo celi e bo pwo anaa?» ");
INSERT INTO cam_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","É alecehen, ke lé tabuhi pipééle, be lé pihane pace apulie celi piubwo nang ne pelelé. ");
INSERT INTO cam_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ke e pii wo Iésu pie: «É ne pele ni béén na time uce ni apulie te Padué, ke lé caaite ni apulie wo lépwo daame me lépwo apihuô. Ke lé pipwo me ubwo jélé. Ke nimelé me nye tee pipaunulé, me pipwo-olé telé taaci. ");
INSERT INTO cam_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kehe wogewé, ke geé nemwo pwohewiilé! Be wo pana piubwo nang ne hadeniiwé, ke wâé heme e pwohewii pa cuwo nahi ewa. Ke wo pa apihuô, ke wâé heme pwohewii pa eabwé. ");
INSERT INTO cam_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","«Be é ne pele ni apulie pwo bwohemwo, ke wo pa daame pana piubwo nang, ke e te tebwo pwo taap, ke lé ne me e wiinaado wo lépwo eabwé ten. Kehe geé téne, time uce wonaa ne ha awiemenye. Be é caa â eabwé tewé. ");
INSERT INTO cam_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«Ke wogewé na geé mu pelong he é mu he ni picani me ni téé. ");
INSERT INTO cam_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ke é bo ne tewé a Mwametau na e caa ne tong wo Caa tong. ");
INSERT INTO cam_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ke genye bo piwiinaado ibu me woéo. Ke geé bo tebwo pwo ni atebwo te lépwo daame, beme geé o pihuô te ni 12 pwomwoiu *Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","E biteeng wo Iésu ne ko Simon Pétéru, ke e pii pie: «Go téne! E ilehi wo Caatana pie, me e tai tacebwénikewé, wogo me lépwo béém ke me e pwo me pinekepé ni pwonimewé ha ace céiu benaamwon. ");
INSERT INTO cam_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kehe woéo, ke é caa pwoiitihi me dem, ke é ilehi pie, me time go uce patieden a céihi tem. Ke mepie go mwojuia mwobé céiiéo, ke go pamwoiu lépwo ju béém ce.» ");
INSERT INTO cam_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Ke e hegi ne ten wo Pétéru pie: «Ûhu go Padaame! Te jan ne kong mwo me é mu he ni picani pwohewiiko, heme é ne he karépu, ai heme nyu tai mele!» ");
INSERT INTO cam_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ke e pii ten wo Iésu pie: «Uhuu, go Pétéru, be é pii tem pie: É jenaa, ânebuhe a bwo to te a ja, ke o caa ocié go ko piwotétaa kong pie, time go uce temehiéo.» ");
INSERT INTO cam_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","E pii mwo wo Iésu te lépwo acémun den pie: «É he li é pahedekewé beme geé â patemehi a Pwooti Wâé ke te tice mwani, me élele, me dihibwaawé celi geé pé céiwé, ke kona pwo ce naado celi tice tewé?» Ke lé hegi ne ten pie: «Ûhu.» ");
INSERT INTO cam_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ke e pii telé pie: «Kehe icehi ana é jenaa ni, ke é pii tewé pie, wâé heme geé pé ce mwani me ce élele tewé! Ke mepie tice teua tewé, ke wâé heme geé icuhi ni epwénewé, beme o pwocuhin kon. ");
INSERT INTO cam_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Be lé o caa pwotahi ne kong, pwohewiin hemepie woéo, ke pace apulie ta. Be pwo a céiu pwooti kong na tii ne he ni tii iitihi, pie: Lé pwo me e pwocuhinaado; be lé pii pie, pa apwotahinaado. Ke e o caa te cuwo a pwooti naa.» ");
INSERT INTO cam_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ke lé pii ten wo lépwo acémun den pie: «Weengi lupwo alo teua, go Padaame!» Ke e hegi ne telé pie: «Caa te jan!» ");
INSERT INTO cam_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Lé wie mu huâ wo Iésu me lépwo acémun den, ke lé â pwo a juwole ko ni Olivier. Be mu te cemang me lé â lang. ");
INSERT INTO cam_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ke me lé tehene ngen, ke e pii telé pie: «Geé pwoiitihi, beme o te pwo niihewé hemepie tacebwénikewé.» ");
INSERT INTO cam_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ke e te ju piâdé kojalé, ke e tidihi jilin, ke e pwoiitihi da céii Padué. ");
INSERT INTO cam_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ke e pii pie: «Caa, hemepie nimem, ke go pé kojaéo ni picani me ni téé ce! Kehe icehi ana go nemwo pwo ana nimung kon, kehe ana nimem kon.» { ");
INSERT INTO cam_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ke e pihabwiieng den wo pa céiu *âcélo bé mu he miiden, ke e pamwoiueng. ");
INSERT INTO cam_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ke e pwoiitihi mwo wo Iésu, be e caa junihe mu he ni picani. Ke a tii kon, ke e caa â pwohewii ni pihicewéle na tupwo ne pwo bwohemwo.} ");
INSERT INTO cam_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ke nebwén, ke e cuwoda, ke e mwojuia mwobé céii lépwo acémun den. Kehe icehi ana e alihi pie lé teko pule. Be te junihe emaan jélé ko a bwo piwahin jélé. ");
INSERT INTO cam_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ke e pii telé pie: «He geé tee ko pule kona woté? Geé ûmiê, ke geé pwoiitihi, beme o te pwo niihewé hemepie tacebwénikewé.» ");
INSERT INTO cam_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","É he e mwo ko pii anaa wo Iésu, ke e te ju tehenebé wo Judas, pali céiu béé lépwoli 12 apostolo ten. Ke lé âbé céin ni apulie na hiwon jélé. Ke e te âde Iésu kuti, ke e mwomwaaueng. ");
INSERT INTO cam_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ke e pii ten wo Iésu pie: «Judas, kona é mu ko a bwo mwomwaauéo na go icuéo, woéo pa Nahi Apulie?» ");
INSERT INTO cam_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ke me lé alihi ana o pwo wo lépwo *acémun de Iésu, ke lé tahimwoeng pie: «Padaame, he me geme tahi ni teua?» ");
INSERT INTO cam_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ke e pé a teua ten wo pa céiu béélé, ke e te tahi kuti ole pwo puni pa apenem de pa *daame he lépwo apwoâpwailo. Kehe icehi ana e te ju tahagéi a jéénen ne pwo jui. ");
INSERT INTO cam_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ke e pii telé wo Iésu pie: «Ûhu! Caa jan! Geé nemwo pwobwonilé!» Ke e pétaa ko ali jééne pali eabwé. Ke caa te ju wâé mwo. ");
INSERT INTO cam_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ke e pacihe lépwo apihuô te lépwona lé âbé imwieng, lépwo caa te lépwo apwoâpwailo, me lépwo caa te lépwo awéihi mwaiitihi. Ke e pii telé pie: «Woté? Geé âbé pééo ko teua me beba-acuwo, pwohewiin heme woéo pace ataunuhi apulie?! ");
INSERT INTO cam_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ati ni tan, ke é te mu hadeniiwé ne *huâ iitihi, kehe icehi ana time geé uce imwiéo! Kehe wâé me wonaa! Be ani, ke caa te a benaamwon dewé, a benaamwon na e pihuô na a junuu a melepiing.» ");
INSERT INTO cam_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ke lé imwi Iésu. Lé pé ngen Iésu ha a pomwa te pa daame he lépwo apwoâpwailo. Ke e pi-ilipuwoeng ngen wo Pétéru. ");
INSERT INTO cam_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E too ni béé awéa pwo napwomwo. Be lé patéi miû, ke lé cadéu. Ke e cuwo ko cadéu pelelé wo Pétéru. ");
INSERT INTO cam_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ke e alieng ê céiu eabwé he e ko tebwo ko ali miû. Ke e te ju omeeng ehi, ke e pii pie: «Éé, wo paje, ke pa céiu béé Iésu mu Nazaret!» ");
INSERT INTO cam_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kehe icehi ana e piwotétaa wo Pétéru, ke e pii ten pie: «Ûhu! Time é uce temehieng!» ");
INSERT INTO cam_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ke te ju é alecehe a cuwo benaamwon naa, ke pwo mwo pa céiu apulie na e temehieng mwo, ke e pii ten pie: «Aje, kona time uce wogo pa céiu béé Iésu?» Ke e hegi ne ten wo Pétéru pie: «Ûhu!» ");
INSERT INTO cam_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ke te ju céiu inetéale alecehen, ke pwo pa céiu apulie na e caa te ju pii mwoiuhi te lépwo béén pie: «Uhuu! Te a juuju, be pa céiu béén! Be weeng mwo, ke pa aâbé mu Galilé!» ");
INSERT INTO cam_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ke e hegi ne ten wo Pétéru pie: «Time é uce temehi aceli nimem me go pii!» Ke me e mwo ko pii anaa, ke e to ali ja. ");
INSERT INTO cam_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ke e biteeng wo Iésu, ke e ome Pétéru. Ke e bwo niimihi wo Pétéru ali e caa mi pii ten wo Iésu pie: «Ânebuhe a bwo to te a ja, ke o ocié go ko piwotétaa pie, time go uce temehiéo.» ");
INSERT INTO cam_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ke e te wie kuti mu pwo napwomwo wo Pétéru, ke e te junihe é kuti. ");
INSERT INTO cam_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Lé pihooni Iésu wo lépwo awéa, ke lé ahieng. ");
INSERT INTO cam_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ke lé tawii a pwahamiin, ke lé tahimwoeng pie: «He woo na e ahiko? Go cuwoteeke pihane, hemepie wogo ke pace péroféta celi go temehi ati ce naado!» ");
INSERT INTO cam_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ke lé pijeta kon, ke lé pii ten ni naado na te junihe ta. ");
INSERT INTO cam_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","É pwopwometan, ke lé pitapitilé neibu ati ne ni *mwohuô te lépwo Juif: lépwo caa te lépwo apwoâpwailo, me lépwo apihuô, me lépwo dotéén ko patén. Ke lé pii te lépwo awéa pie me lé pébé Iésu he pwahamiilé. ");
INSERT INTO cam_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ke lé pii ten pie: «Hemepie wogo ke pa *Mesia, ke go pii teme!» Ke e hegi ne telé wo Iésu pie: «Mepie é pii tewé a juuju, ke o time geé uce céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","«Ke mepie é tahimwokewé ko ace céiu naado, ke o time geé uce hegi ne tong. ");
INSERT INTO cam_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kehe icehi ana e o caa tuie a benaamwon na woéo pa Nahi Apulie, ke é o bo tebwo *pwo a jui Padué na te junihe pwojunuun beme é pihuôhi ati ni naado.» ");
INSERT INTO cam_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ke me lé téne anaa, ke lé te junihe okéé kuti ke lé pii pie: «Aje, he wogo ke pa *Naî Padué?» Ke e hegi ne telé wo Iésu pie: «Geé mwo teko ju pii!» ");
INSERT INTO cam_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ke lé pipii pie: «Caa jan! Be geé caa teko téne ana e ko pii. Necu ce béé bwo pipé ne kon. Be e caa teko pipé ne kon mwo!» ");
INSERT INTO cam_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Lé tai cuwoda ati ni *mwohuô te lépwo *Juif, ke lé pé Iésu nge céii *Pilate pa gupéno te lépwo Roma. ");
INSERT INTO cam_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ke lé pipé ne ko Iésu, ke lé pii pie: «Wo pa apulie ce, ke e pine ânepuni a bele teme, beme lé pwobwoni César, pa daame. Be e pii telé pie, me lé nemwo pwocuhi puni apulie ne ten. Ke e pii pie, weeng, ke pa *Mesia, pa céiu daame ubwo.» ");
INSERT INTO cam_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ke e tahimwoeng wo Pilate pie: «Kona te wogo kuti pa daame he lépwo Juif?» Ke e hegi ne ten wo Iésu pie: «A juuju a bwopiinen dem.» ");
INSERT INTO cam_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E biteeng wo Pilate ne ko lépwo caa te lépwo *apwoâpwailo, me ni béé apulie na lé mu lang. Ke e pii telé pie: «Time é uce tooli ace watihen me e pwocuhinaado.» ");
INSERT INTO cam_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Kehe icehi ana lé te junihe pii mwoiuhi ten pie: «Uhuu, go te alihi, be e pahauli pitihi a amu ko ni bwo pipune ten, tabuhi mu Galilé, die éni *Iérusaléma!» ");
INSERT INTO cam_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ke e pii telé wo Pilate pie: «Woté? Geé pii pie, pa apulie Galilé?» ");
INSERT INTO cam_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ke me lé pii ten pie: «Éa», ke e pawie Iésu nge pele *Érode Antipas. Be weeng pana e gupéno ne Galilé, ke, é ha a benaamwon naa, ke e ko pimu Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","E te junihe pipwodéén kuti wo Érode he e ali Iésu, be caa te junihe bwolihi a bwo téne nen den a jepule kon. Ke te junihe nimen me e alihi ace *pipwojunuun celi e pwo. ");
INSERT INTO cam_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ke e tahimwoeng mwo ko ni naado na hiwon. Kehe icehi ana time e uce hegi ne ten wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","É he ko wonaa, ke lé tee ko mu lang wo lépwo caa te lépwo apwoâpwailo, me lépwo *dotéén ko patén, ke lé te junihe cihe da me ubwo me pipé ne kon. ");
INSERT INTO cam_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Caa â emaan Érode kon ke e pijeta kon, ke e pihoonieng, weeng me ni coda ten. Ke lé pwo me e cuwohe a epwén he daame. Ke lé pawieeng ngemwo céii Pilate. ");
INSERT INTO cam_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Tabuhi ha a tan naa, ke lu piténelu wo Érode me Pilate. Be é ânebun, ke lupwona te pita julu. ");
INSERT INTO cam_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wo Pilate ke e taineibu ni apulie, me ni apihuô telé, me ni caa te lépwo apwoâpwailo. ");
INSERT INTO cam_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Ke e pii telé pie: «Geé caa pébé pa apulie ce, ke geé pii pie: “E pine ânepuni ni apulie, beme hauli a amu.” Ke é ko tahimwoeng kon ne he pwahamiiwé. Kehe icehi ana time é uce tooli aceli ta ne kon, celi jan me é pwocuhinaado ten kon. ");
INSERT INTO cam_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","«Ke wo pa daame Érode Antipas mwo, ke time e uce tooli ace ta celi e pwo, ke e neeng mwobé éni. Be te tice watihen me e mele. ");
INSERT INTO cam_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Heme wonaa, ke é o te ju pwo me tatieng cehi, ke é o te neeng ngemwo.» { ");
INSERT INTO cam_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Be te a pane Pilate me e pawie pace céiu apulie mu he karépu, ati he ni jo, ha a tan ko *Pacika.} ");
INSERT INTO cam_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ke lé te tai toii da ko miiden ne ni apulie pie: «Pwo me e mele wo pa apulie naa! Ke go pawie Barabas!» ");
INSERT INTO cam_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Be e mu he karépu wo Barabas, be pa ataunuhi apulie. Ke wo pa céiu béé mwo lépwona lé pwo me lé pwobwoni lépwo Roma ne Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Te nime Pilate me e pawie Iésu, ke e pwo me e cihe ne ko ni apulie beme e pacuwolé. ");
INSERT INTO cam_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kehe icehi ana lé bwo te junihe cihe me toii da pie: «Cemeiteeng! Cemeiteeng ne ko a *kuricé!» ");
INSERT INTO cam_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","E mwo ocié ko tahimwolé wo Pilate pie: «Ade ace watihen me e mele? Te tice ace ta celi é tooli ne kon. É o te ju pwo me tatieng cehi, ke é o caa te pawieeng mwo.» ");
INSERT INTO cam_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kehe icehi ana lé bwo te junihe pwole, ke lé toii da pie: «Cemeiteeng!» ");
INSERT INTO cam_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ke e te pihuôhi wo Pilate pie, me e pwo ana nimelé kon. ");
INSERT INTO cam_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ke e pawie Barabas, pali pwéréca, ke e ne Iésu te ni coda ten beme lé taunueng. ");
INSERT INTO cam_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","É he lé pé ngen Iésu wo lépwo coda roma, ke pitapitilé me pa apulie mu ha a pwomwo ubwo Cirène, na pii kon pie Simon, he e ko mwojuia mwobé mu ha apwoamu. Ke lé wâgo kon, beme e canihi ali kuricé céi Iésu. ");
INSERT INTO cam_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Te junihe hiwon ni apulie na lé âcéi Iésu. Ke lé é me pihemun ni toomwo. ");
INSERT INTO cam_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ke e biteeng ne kolé wo Iésu, ke e pii telé pie: «Léli ewa Iérusaléma, geé nemwo é niimiéo, kehe geé pié niimikewé me ni naîwé! ");
INSERT INTO cam_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Be e o caa tuie a benaamwon na geé bo pii pie: “Nihe wâé ne ko ni toomwo na time uce jan me pwo naîlé, me nina time lé uce téele piâbeele ewa, me nina time lé uce paditihi ewa!” ");
INSERT INTO cam_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","«Be o te junihe ubwo ace bwo mu he ni picani te ni apulie. Ke o bo nimelé me tupwo ne huîilé ni juwole, beme neduwolé koja ni téé naa! ");
INSERT INTO cam_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","«Be “Me lé cini a acuwo na mwo wamin, ke lé o bo woté ko a acuwo na caa meiu?” Be lé pwotahi ne kong jenaa, ke lé bo nihe pwotahi ne kowé alece.» ");
INSERT INTO cam_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ke ni coda, ke lé tai pé Iésu me lupwo apwotahinaado, beme o tai taunulé. ");
INSERT INTO cam_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lé pé Iésu ngen, ke lé tuie nge ha a duaan na pii kon pie ‘Piipuni Apulie’. Ke lé cemeiteeng ne ko ali kuricé. Ke lé cemeite mwo lupwoli apwotahinaado: wo pa céiu ne pwo juin, ke wo pa céiu ne pwo eaamun. ");
INSERT INTO cam_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ke e pii te Padué wo Iésu pie: «Caa, go pineulé, be time lé uce temehi ana lé pwo.» Ke wo lépwo coda, ke lé picéi metii ne ko ni epwénen. ");
INSERT INTO cam_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Hiwon ni apulie na lé cuwo lang, ke lé tee tai alihi ati nina e tuie. Ke wo lépwo apihuô te lépwo Juif, ke lé pihooni Iésu, ke lé pii pie: «E pipii kon pie, pa Mesia! Ke e temehi me e celuimi ni béén, kehe icehi ana time e uce temehi me e piceluimieng mwo!» ");
INSERT INTO cam_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ke lé te pihoonieng mwo wo lépwo coda, ke lé pébé céiieng a tabe megele na maga, ");
INSERT INTO cam_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ke lé pii ten pie: «Aje, hemepie wogo pa daame he lépwo Juif, ke go piceluimiko mwo!» ");
INSERT INTO cam_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ke lé cemeite ne pwo punin a eaa acuwo na tii ne kon pie: pa apulie ce, ke pa daame he lépwo juif. ");
INSERT INTO cam_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ke mepwo wo pali céiu apwotahinaado li cemeiteeng ne ha a céiu duaa Iésu, ke e te junihe pitaahieng, ke e pii ten pie: «Woté go paje? Go pii pie, wogo pa Mesia. Ke go piceluimiko mwo, ke go celuimikemu mwo!» ");
INSERT INTO cam_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Kehe icehi ana e hegi ne ten wo pali béén li e mu ha ali céiu duaa Iésu, ke e pii ten pie: «Wogo, ke go pwocuhinaado pwohewii pa apulie naa. Ke he time uce mwotiko ko Padué? ");
INSERT INTO cam_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Go te téne, be te mwomwon ne konyu a bwo pwocuhinaado tenyu, be lupwo apwotahinaado. Ke hemepwo é ne kon, ke te tice aceli e pwotahi!» ");
INSERT INTO cam_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ke e pii te Iésu pie: «Au, Iésu, go bo niimiéo heme go caa tebwo ha a Mwametau tem.» ");
INSERT INTO cam_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ke e hegi ne ten wo Iésu pie: «É pii tem a juuju pie: É jenaa ni, ke wogo pelong ne ha amu tong na e hen a péém.» ");
INSERT INTO cam_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","É he te ju goahen ehi, ke te ju melepiing ati ha amu, die ko cié inetéale alecehe a goahen. Ke te tie kuti a mwaanu na capuhi bwonihi a duaan na junihe iitihi ne *huâ iitihi. ");
INSERT INTO cam_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ke e cihe da me ubwo wo Iésu pie: «Caa, é ne mwo a mulihung he naatiim!» Ke ele a nenehen. ");
INSERT INTO cam_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ke me e alihi a bwo mele ten wo pa caa te coda roma, ke e pipaunu Padué, ke e pii pie: «Te a juuju pie, wo pa apulie ce, ke te tice ta celi e pwo!» ");
INSERT INTO cam_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ke tai ni apulie na lé mu lang, ke lé alihi ni naado na tuie, ke lé mwojuia mwo he nihe téé ni pwonimelé. ");
INSERT INTO cam_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Lé mu lang mwo ati nina lé temehi Iésu, ke ni toomwo na lé âbé céin mu Galilé. Ke lé tee cuwo ité, ke lé omehi a bwomune ni naado. ");
INSERT INTO cam_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Pwo pa céiu apulie na pii kon pie Josef, pa apulie mu Arimaté ne *Judé. Pa apulie na wâé me mwomwon nang. E teko mwoiu ko ucéihi ace bwo tuiebé na a *Mwametau te Padué. Pa apulie ha a mwopitautinaado te lépwo Juif, kehe icehi ana time e uce mu he nina lé pwo te Iésu wo lépwo béén. ");
INSERT INTO cam_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ke e â pele Pilate, ke e ilehi a éé Iésu. ");
INSERT INTO cam_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ke e neeng ole mu ko a kuricé, ke e tawiieng ko a mwaanu. Ke e neeng ha a pwon na lé ini ne ha a péi, é he na mwo te tice celi lé nelé lang. ");
INSERT INTO cam_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ati ni naado naa, ke pacuwohi he paciile, ha a tan ânebuhe a *tan iitihi te lépwo Juif. A paciile, ke lé pipwopweehi a piwiinaado ko a tan iitihi. Be o caa tabuhi a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Lé toomwo na lé âbé mu Galilé me Iésu, ke lé âcéi Josef, ke lé alihi he na neduwo Iésu nelang. ");
INSERT INTO cam_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ke lé mwojuia ngemwo, ke lé pwopweehi ni tabe ûde me de a éé Iésu. Ke lé mwaale ha a tan iitihi, pwohewii ana pii ne he ni patén. ");
INSERT INTO cam_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","É he pwoiitihi, he mwo te ju acaama, ke lé â he iitihi wo léli toomwo. Ke lé pé ngen ni huile me ni tabe ûde na lé caa pipwopweehi. ");
INSERT INTO cam_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ke lé tooli ali péi he caa papitibehi mu ânebuhe ali mwa péi. ");
INSERT INTO cam_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ke lé taa hen, kehe icehi ana time lé uce tooli a éé Padaame Iésu. ");
INSERT INTO cam_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","É he lé mwo ko pitahimwolé ko aceli e tuie, ke lu te âbeetilé kuti wo lupwo apulie na alo julu, na pwomelaa ni epwénelu. ");
INSERT INTO cam_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ke te junihe mwotilé, ke lé miibule be time uce jan me lé omelu. Kehe icehi ana lu pii telé pie: «É mu ko ade na geé hane hadenii nina lé mele pana e caa mulie cemwo? ");
INSERT INTO cam_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","{Caa time uce e éni, be e caa mulie cemwo!} He geé te piniimihi a bwo cihe ten ne kowé he e mwo mu Galilé? ");
INSERT INTO cam_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Be li e pii pie, weeng pa Nahi Apulie, ke o neeng te lépwo apulie na ta jélé, beme lé cemeiteeng ne ko a *kuricé, ke e bo mulie mwo ha a béciéhe ni tan alecehen.» ");
INSERT INTO cam_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ke wo léli toomwo, ke lé bwo piniimihi ana e caa pii telé wo Iésu. ");
INSERT INTO cam_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ke lé mwojuia cemwo mu ko a bwomu, ke lé patemehi ati ninaa ne te lépwo 11 *apostolo, ke ati ni béé apulie te Iésu. ");
INSERT INTO cam_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Lé toomwo naa, ke wo Maria mu Magdala, ke wo Jeanne, me Maria ê nyaa te Cang, ke ni béé toomwo na lé mu pelelé. Kehe icehi ana he lé piuti a jepule naa ne te lépwo apostolo, ");
INSERT INTO cam_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ke time lé uce mwomwolé, be lé niimihi pie lé pihaamilé. ");
INSERT INTO cam_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kehe e cuwoda wo Pétéru, ke e téte nge ko a bwomuhe Iésu. Ke e pioole da, ke e te ju alihi ni mwaanu neole pwo bwohemwo. Ke e mwojuia ngemwo pelen, ne ha a bwo emegéi nan ne ko ana e tuie. ");
INSERT INTO cam_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mwo te é ha a tan naa, ke lu ko â he pwaaden wo lupwo alo béé Iésu, beme lu â ha a mwopopwaalé Émaüs, alo ni inetéale mulang die *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","15","É he lu ko â he pwaaden, ke lu tee ko picihe ko nina e tuie ne ko Iésu. É he lu mwo ko wonaa, ke e piâbé mwonulu wo pa céiu apulie, ke lé tai piengen ibu. Te wo Iésu kuti, ");
INSERT INTO cam_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","kehe time lu uce ali temehieng. ");
INSERT INTO cam_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","E pii telu pie: «He ace de celi geu ko picihe kon bé he pwaaden?» Ke lu â cuwo ha a bwo piwahin julu. ");
INSERT INTO cam_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ke wo pa céiu na pii kon pie Kléopas, ke e hegi ne ten pie: «Kona time go uce temehi ana tuie he ni tan ce? Ati ni apulie Iérusaléma, ke lé te temehi, ke he te wogo cehi?» ");
INSERT INTO cam_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ke e tahimwolu pie: «Kona ade celi e tuie?» Ke lu hegi ne ten pie: «Ana e tehenebé ne ko Iésu mu Nazaret, pana pa péroféta na e piwéden. Be te junihe pwojunuun ne he ni penem den, ke é ne he ni pwooti ten ne ânebuhe Padué, ke é ne ânebuhe ni apulie. ");
INSERT INTO cam_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ke geme céihi pie me weeng pa *Mesia, pana e bo celuimi a bele *Isaraéla. Kehe icehi ana wo lépwo apihuô tenye, ke wo lépwo caa te lépwo *apwoâpwailo, ke lé neeng beme cemeiteeng ne ko a kuricé. Ke caa cié ni tan alecehe a bwo mele ten jenaa. ");
INSERT INTO cam_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","«Ke é jenaa, ke lé âbé ni béé toomwo mu hadeniime, ke lé piuti a jepule na e pwo me geme téetihi. Be lé pii pie, lé â die ko a bwomuhe Iésu he mwo ju acaama, ke time lé uce tooli a één. Ke pwo lupwo *âcélo na lu âbeetilé, ke lu pii telé pie, e caa mulie mwo wo Iésu! ");
INSERT INTO cam_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ke wo lépwo béén mu kome, ke lé â ko a bwomuhen, ke lé tooli ni naado pwohewii nina lé pii ne ni toomwo; be te a juuju pie, tieden a éé Iésu!» ");
INSERT INTO cam_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ke e pii telu wo Iésu pie: «Au, mwolikewé! Be te tice aceli geé temehi! Junihe bwolihi me geé céihi ne ko nina lé pii wo lépwo péroféta ânebun! ");
INSERT INTO cam_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Be lé pii pie, o wâé heme e mu he ni picani wo pa Mesia, ânebuhe a bwo habwii na a bwo ubwo na a wâé ten.» ");
INSERT INTO cam_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ke é he lé ko â he pwaaden ke e patemehi telu ati nina tii ne kon ne he ni tii iitihi. Be e tabuhi mu ko ni tii te *Moosé, die ko ni tii te lépwo péroféta. ");
INSERT INTO cam_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nebwén, ke lé piâmwonuhi a mwopopwaalé na me lu â hen. Ke wo paje, ke e pwo me e engen kojalu. ");
INSERT INTO cam_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kehe icehi ana lu cuwokon, ke lu pii ten pie: «Ûhu, go mwo mu pelemu, be caa bwén.» Ke lé taa pwomwo, ke lé mu lang. ");
INSERT INTO cam_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","É he lé ko mu pwo taap, ke e pé a pwoloa wo paje, ke e pwoiitihi ne kon. Nebwén, ke e ebii, ke e ne telu. ");
INSERT INTO cam_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ke te tehi kuti ni naamiilu, ke lu temehieng; kehe icehi ana te ju pwo é tieeng ne ânebuhelu. ");
INSERT INTO cam_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ke lu pipii telu pie: «Wii! Te junihe ité kuti a pipwodéén na e mu he ni pwonimenyu, he e patemehi tenyu bé lang he pwaaden ni tii iitihi!» ");
INSERT INTO cam_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ke lu te cuwoda kuti, ke lu epin ko mwojuia ngemwo Iérusaléma. Ke lu too lépwo 11 apostolo me lépwo béélé he lé teko pimu ibu. ");
INSERT INTO cam_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kehe icehi ana woélé, ke lé mi pii telu pie: «Éé! E caa mulie mwo wo Padaame! Be e alieng wo Simon Pétéru!» ");
INSERT INTO cam_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ke wo lupwoli apulie mwo, ke lu uti telé ana toolu nge he pwaaden. Ke lu pii mwo pie: «Gemu te temehieng kuti he e ebii a pwoloa!» ");
INSERT INTO cam_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","É he lu ko wonaa a bwo uti nen, ke e te pihabwiieng kuti ne ha awiemelé wo Iésu, ke e pii telé pie: «Bwocu tewé! Ke adéikewé!» ");
INSERT INTO cam_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ke te junihe mwotilé kuti, be lé niimihi pie lé alihi ace duéé. ");
INSERT INTO cam_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kehe e pii telé pie: «É mu ko ade na mwotikewé ke pihauli ni pwonimewé? É mu ko ade na time geé uce céihi pie woéo?» ");
INSERT INTO cam_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","40","Ke e habwii telé ni in me ni an, ke e pii telé pie: «Geé alihi ni ing ke ni ang, ke geé ti kong, be te ju woéo kuti! Be a jenenaado ke te tice mehieng, ke te tice duun!» ");
INSERT INTO cam_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ke lé te junihe téetihi ninaa, ke piwâénimelé, kehe icehi ana time lé uce téele mwomwohi ehi, be mwo te junihe emegéi nalé. Ke e pii telé wo Iésu pie: «Te pwo celi me nye wii ne éni?» ");
INSERT INTO cam_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ke lé ne ten a me-ikua na cini. ");
INSERT INTO cam_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ke e wii ne he pwahamiilé. ");
INSERT INTO cam_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ke e pii telé pie: «Geé te niimihi ali é pii tewé he li é mwo tee mu pelewé, pie: Wâé heme panebwénihi ati nina lé tii ne kong wo Moosé ke wo lépwo péroféta, ke é ne ha a tii *Psaumes.» ");
INSERT INTO cam_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ke e tehi ni bwo temehi ne ni tii iitihi telé. ");
INSERT INTO cam_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ke e pii telé pie: «Caa te tii ne he ni tii iitihi pie, e o mu he ni picani wo pa Mesia, ke e o mele. Kehe e o mwojuia cemwo mu hadenii ni amele ha a béciéhe ni tan alecehen. ");
INSERT INTO cam_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","«Ke é pahedekewé, beme geé pipatemehi te ati ni bele, tabuhi mu Iérusaléma, a pwooti ko a bwo pininim. Ke geé pii telé ne he niing pie: “Geé bitekewé, ke geé pitaatééhi ni mulihewé, ke e bo pineuhi ni ta pwo tewé wo Padué!” ");
INSERT INTO cam_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","«Be te wogewé ni *apajuujuhi na ati ninaa. ");
INSERT INTO cam_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kehe geé mwo te ju mu éni ha a pwomwo ubwo, ucéihi a junuu Padué. Be é bo nebé ne huîiwé a *Jenen Iitihi be weengaa ana e caa mi pii wo Caa tong.» ");
INSERT INTO cam_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","E pé lépwo acémun den wo Iésu nge ha a céiu duaan ko a Bétani, ke e pwii ni in, ke e adéilé. ");
INSERT INTO cam_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","He e ko adéilé, ke e engen kojalé, ke e céieng da he miiden wo Padué. ");
INSERT INTO cam_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ke lé pipaunueng. Ke é alecehen, ke lé mwojuia ngemwo Iérusaléma he lé te junihe pipwodéén. ");
INSERT INTO cam_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ke lé tee mu *huâ iitihi téteda, ke lé tee pipaunu ke *adéi Padué.");
INSERT INTO cam_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Ha atabuhi kon, ke a Pwooti. Ke a Pwooti, ke e pele Padué. Ke a Pwooti, ke Padué. ");
INSERT INTO cam_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E te mu pele Padué ha atabuhi kon. ");
INSERT INTO cam_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tai ni naado ati, ke lé tabuhi mu kon. Te tice celi e tabuhi heme tieeng. ");
INSERT INTO cam_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","É mu kon, ke pwo a mulip, a pwéélang te ni apulie. ");
INSERT INTO cam_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","E pwéélang ha a melepiing. Ke time e uce hegieng na a melepiing. ");
INSERT INTO cam_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wo Padué, ke e pahede pa apulip na pii kon pie Ioane. ");
INSERT INTO cam_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E âbé beme e *pajuujuhi a pwéélang, beme lé céihi ne kon ne ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Time e uce âbé mu kon a pwéélang, kehe e tuie beme e pajuujuhi a pwéélang. ");
INSERT INTO cam_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","A pwéélang naa, ke a ju pwéélang na e tuie ne pwo a bwohemwo, beme e pwéélang ko ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ke a Pwooti, ke e caa mu pwo a bwohemwo. Ke e tabuhi a bwohemwo wo Padué ko a Pwooti. Ke time lé uce temehieng ne pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E tuie ne pele ni béén, ke time lé uce hegieng. ");
INSERT INTO cam_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nina lé hegieng, ke lé céihi ne ko a niin, ke e ne telé a pihuô beme lé naî Padué. ");
INSERT INTO cam_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Time lé uce âbeele mu ko ana nime pa apulie kon, kehe lé âbeele mu ko Padué. ");
INSERT INTO cam_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ke e pé a éé apulie a Pwooti, ke e mu hadeniinye, ke ubwo a pwonimen konye. Ke genye caa alihi a bwo ubwo na a wâé ten, a wâé te pa Naîn na te céiu nang, na e âbé mu ko Caa. ");
INSERT INTO cam_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","E pajuujueng wo Ioane, ke e pii me ubwo pie: «Weeng pana é piieng pie, e bo âbé céing wo pa apulie na te nihe pwonaado ne kon kojaéo, be e caa te mi mu ânebuhung.» ");
INSERT INTO cam_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nye caa tai hegi ati a *adéihi, ko a bwo eânimen denye. ");
INSERT INTO cam_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Mepwo é ne ko ni patén, ke e ne tenye mu ko *Moosé. Kehe wo Iésu *Kériso, ke a pwaaden ko a *pipwoééhe tice ja kon, ke a *juuju. ");
INSERT INTO cam_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Te tice pace apulie celi e ali Padué, kehe te pa Naîn na te céiu nang, be e mu ko Caa, ke weeng na e pipatemehieng denye. ");
INSERT INTO cam_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wo lépwo apihuô juif ne *Iérusaléma, ke lé pahede lépwo béé *apwoâpwailo me lépwo béé apipenem ko a *mwaiitihi me lé â tahimwo Ioane pie: «Wogo, ke he woo?» ");
INSERT INTO cam_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ke time e uce waaneduwohi kolé, kehe e te pii telé pie: «Woéo, ke time uce pa Mesia.» ");
INSERT INTO cam_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ke lé tahimwoeng mwo pie: «Wogo ke he woo? He wogo ke wo péroféta *Élia na me e mi ânebuhen?» Ke e pii telé pie: «Ûhu!» Ke lé tahimwoeng mwo pie: «Kona wogo ke he pa Péroféta na e piieng wo Moosé?» Ke e pii telé pie: «Ûhu!» ");
INSERT INTO cam_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ke lé pii ten pie: «Kona wogo, ke he woo? Go pii teme, beme geme â pii te lépwona lé pahedekeme bé. Kona wogo, ke he go pii pie woté ne kom?» ");
INSERT INTO cam_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ke e hegi ne telé pie: «Woéo, ke wo pali e piieng wo péroféta Isaia: Pwo pa apulie ha a da na e toii da pie: “E âbé wo Padaame! Pwopweehi a pwaadeniin!”» Ésaïe 40.3 ");
INSERT INTO cam_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Mepwo é ne ko ni apulie na pahedelé ngen, ke lé mu hadeniilé ne ni Farasaio. Woélé, ke a céiu dihe pwoiitihi te lépwo *Juif. ");
INSERT INTO cam_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ke lé tahimwoeng mwo pie: «É mu ko ade na go puu ni apulie, hemepie time uce wogo wo Kériso, ke time uce wogo wo Élia, ke time uce wogo pa Péroféta?» ");
INSERT INTO cam_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ke e hegi ne telé wo Ioane pie: «É puu ni apulie ko a tabe, kehe e ha awiemewé wo pa apulie na time geé uce temehieng. ");
INSERT INTO cam_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Weeng na e âbé alecehung. Ke time uce jan ne kong me e tuwo ni tai ko ni dihibwaan.» ");
INSERT INTO cam_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tai ninaa, ke tuie ne Bétani, ko a céiu goon ne Ioridano, he na e pipuu apulie nelang wo *Ioane pa apipuu apulie. ");
INSERT INTO cam_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","É ha acaama hen, ke e ali Iésu wo Ioane, he e âbé céiieng. Ke e pii pie: «Weengi pa *Nahi Muto te Padué. Weeng na e pétaabwon ni ta pwo te ni apulie pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Weeng na é caa mi piieng, pie: Pwo pana e bo âbé alecehung, na te nihe pwonaado ne kon kojaéo, be e caa te mi mu lang ânebuhung. ");
INSERT INTO cam_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","«Time é uce mi temehieng ânebun, ke é âbé puu ni apulie ne ha a tabe, beme e patemehieng te lépwo *Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Weengi ana e uti wo Ioane: «É alihi a *Jenen Iitihi he e opé mu he miiden pwohewii a meni pwojo, ke e ole huîin. ");
INSERT INTO cam_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Time é uce mi temehieng. Kehe pana e pahedeéo me é puu ni apulie ko a tabe, ke e pii tong pie: “Pana go bo alihi heme e ole huîin a Jenen Iitihi, ke weeng pana e bo puu ni apulie ko a Jenen Iitihi.” ");
INSERT INTO cam_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","«É alihi, ke é pajuujuhi pie: Weeng pa *Naî Padué.» ");
INSERT INTO cam_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","É ha acaama hen, ke e mwo te mu lang wo Ioane me lupwo acémun den. ");
INSERT INTO cam_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ke e ali Iésu, ke e pii pie: «Neko ali Nahi Muto te Padué!» ");
INSERT INTO cam_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Lu caa téne wo lupwo acémun den a bwopiinen naa, ke lu âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","E biteeng wo Iésu, ke e alilu he lu ko âcéin, ke e pii telu pie: «Geu hanee?» Ke lu pii ten pie: «Rabi (pa apipune), é wé he celi go mu lang?» ");
INSERT INTO cam_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ke e hegi ne telu wo Iésu pie: «Geu âbé me geu alihi.» Ke lé tai miân, beme lé alihi he celi e mu lang. He babwén ko paa inetéale ko alecehe goahen, ke lé mu lang ha a tan naa. ");
INSERT INTO cam_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","41","Wo André, pa céiu béélé, ke e â too Simon Pétéru, pa âjiénen, ke e pii ten pie: «Gemu caa too pa Mesia pana pipégalieng.» A bwopiinen pie ‘Kériso’ he pwo *grek. ");
INSERT INTO cam_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ke e pééeng nge céii Iésu. Ke e alieng wo Iésu, ke e pii ten pie: «Wogo Simon, pa naî Jonas. Bo a niim pie Céfas†.» Ai Pétéru: a bwopiinen pie ‘a péi’. ");
INSERT INTO cam_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","É ha acaama hen, ke e â Galilé wo Iésu. Ke e too Filip, ke e pii ten pie: «Go âbé céing!» ");
INSERT INTO cam_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Wo Filip, ke pa apulie Betsaïda, a mwopopwaalé te André me Pétéru. ");
INSERT INTO cam_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","E ân wo Filip, ke e too Natanaël, ke e pii ten pie: «Geme caa too pali e piieng wo Moosé ne he ni patén, ke lé cihe mwo kon ne ni péroféta! Wo Iésu mu Nazaret, pa naî Josef.» ");
INSERT INTO cam_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ke e pii ten wo Natanaël pie: «He te jan me e âbé mu Nazaret aceli wâé?» Ke e hegi ne ten wo Filip pie: «Âbé me go alihi!» ");
INSERT INTO cam_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","E ali Natanaël wo Iésu, he e âbé beniieng, ke e pii ne kon pie: «Weengi pa ju Isaraéla, na te tice pipwohuô kon.» ");
INSERT INTO cam_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","E pii ten wo Natanaël pie: «Go temehiéo mu wé?» Ke e hegi ne ten wo Iésu pie: «Ânebuhe a bwo todeko te Filip, he go ko mu haahi a majing, ke é caa te aliko.» ");
INSERT INTO cam_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","E hegi ne ten wo Natanaël, ke e pii ten pie: «Pa apipune, wogo pa Naî Padué, pa daame Isaraéla!» ");
INSERT INTO cam_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","E hegi ne ten wo Iésu pie: «Go céihi be he é pii tem pie, é aliko ne haahi a majing? Go bo alihi ce naado celi nihe ubwo koja anaa!» ");
INSERT INTO cam_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E pii mwo pie: «É pii tewé a juuju pie: Geé bo alihi a miiden heme tehi, ke lé bo taa ke ole ne ni *âcélo te Padué, huîi pa *Nahi Apulie.» ");
INSERT INTO cam_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Alo ni tan alecehen, ke lé pwo a piaten ne Kana, a mwopopwaalé ne Galilé. E mu lang wo nyaa te Iésu. ");
INSERT INTO cam_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ke lé te tode mwo Iésu me ni acémun den, ne ko a piaten. ");
INSERT INTO cam_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ke me caa tice tabe megele, ke e pii te Iésu wo nyaa ten pie: «Caa tice tabe megele telé!» ");
INSERT INTO cam_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ke e hegi ne ten wo Iésu pie: «Nyaa, time uce wogo na me go pii tong aceli me é pwo. Be time uce téele tuie a benaamwon dong.» ");
INSERT INTO cam_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E pii te lépwo apenem wo nyaa ten pie: «Geé pwo ati nina e pii tewé.» ");
INSERT INTO cam_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","E mu lang ni mwotabe péi na 6, beme ni bépiwon de lépwo *Juif, be te a bwomu telé. É he ni pétaapwo mwotabe, ke jan me nye neole hen celi 100 litre. ");
INSERT INTO cam_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E pii te lépwo apenem wo Iésu pie: «Geé pa ko tabe ni mwotabe ce.» Ke lé pa ke oba. ");
INSERT INTO cam_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ke e pii telé mwo wo Iésu pie: «Geé tai, ke geé pé nge céii pa eapwihi piwiinaado.» Ke lé pé ngen. ");
INSERT INTO cam_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ke e nemi a tabe wo paje, ke e téele, be caa taatééhi me a tabe megele. Ke time e uce temehi pie, he lé pé mu wé. Kehe lé te temehi cehi ne ni apenem. Ke e tode pa apiaten, ");
INSERT INTO cam_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ke e pii ten pie: «Tai ni apulie, ke lé mi pipatihi a ju tabe megele, ke ana time uce ju wâé, ke lé bo ne heme lé caa nihe ûdu wo lépwo ajelu. Kehe wogo, ke go patihi a ju tabe megele, die ha a benaamwon ce!» ");
INSERT INTO cam_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Weengaa a bécéiuhe *inenaado na pwojunuun na e pwo wo Iésu. Anaa, ke e tuie ne Kana ne Galilé. Be e habwii a bwo ubwo na a wâé ten, ke lé céihi ne kon ne ni acémun den. ");
INSERT INTO cam_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Alecehen, ke lé ole Kapernaüm me nyaa ten me ni ciéén, ke ni acémun den. Time uce ju hiwon ni tan na lé mu lang hen. ");
INSERT INTO cam_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Caa e mwonu a Pacika te lépwo Juif: a *pipwodéén ko a bwo celuimilé mu *Aigupito. Ke wo Iésu, ke e taa *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","E taa ha a *mwaiitihi, ke e too lépwo a-icuhi paaci, me muto, me meni, ke lépwo ataatééhi mwani, he lé ko tebwo pwo ni taap telé. ");
INSERT INTO cam_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ke e pwo a bwaliiwota, ke e cibéélé mu ha a mwaiitihi me ni muto ke paaci. Ke e tahi taabwon ni mwani te lépwo ataatééhi mwani, ke e puwo ni taap. ");
INSERT INTO cam_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ke e pii te ni a-icuhi meni pie: «Geé pétaabwon ninaa mu éni! Geé nemwo pé a mwa te Caa tong me a mwopi-icu tewé!» ");
INSERT INTO cam_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ke lé niimihi ne ni acémun den a pwooti na caa te tii ne he ni *tii iitihi pie: Nihe ubwo a pwonimung ko a mwaiitihi tem. ");
INSERT INTO cam_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ke lé pii ten wo lépwo apihuô juif pie: «Ade ace inenaado celi go pwo, beme habwii teme pie te pwo mwomwon dem me go pwo anaa?» ");
INSERT INTO cam_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","E hegi ne telé wo Iésu pie: «Geé tatii taabwon a mwaiitihi ce, be é he na cié ni tan, ke é bo pacuuli mwo.» ");
INSERT INTO cam_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Lé pii ten wo lépwo Juif pie: «Lé pacuuli a mwaiitihi ce he na 46 ni jo, ke he wogo, ke é he na cié ni tan, ke go bo pacuuli?» ");
INSERT INTO cam_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Kehe a mwaiitihi na e cihe kon, ke a één. ");
INSERT INTO cam_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ke é he e caa mulie cemwo mu ha amele, ke lé niimihi mwo nina e caa pii telé ne ni acémun den. Ke lé céihi ne ko nina e pii ne ni tii iitihi, ke é ne ko a pwooti te Iésu. ");
INSERT INTO cam_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","É he ni tan na e mu Iérusaléma wo Iésu ne ko a Pacika, ke hiwon nina lé céihi ne kon, he lé alihi ni inenaado na pwojunuun na e pwo. ");
INSERT INTO cam_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Kehe time e uce mwomwolé, be e te tai temehilé ati. ");
INSERT INTO cam_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ke time uce a junaado ne ten heme lé piuti ten ni bwomu te ni apulie, be e te temehi ati ni pwonime apulie. ");
INSERT INTO cam_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Pwo pa apulie na a niin pie Nikodème, pace béé ni *Farasaio, ke pa apihuô te ni *Juif. ");
INSERT INTO cam_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ke e âbé too Iésu he bwén, ke e pii ten pie: «Pa apipune, geme caa temehi pie wogo, ke pa apipune na e neko bé wo Padué. Te tice pace apulie celi e pwo ce inenaado celi pwojunuun pwohewiiko, heme time e uce mu pelen wo Padué.» ");
INSERT INTO cam_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ke e hegi ne ten wo Iésu pie: «É pii tem a juuju pie: Te tice pace apulie celi e alihi a *Mwametau te Padué, heme time e uce âbeele mwo.» ");
INSERT INTO cam_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ke e pii ten wo Nikodème pie: «He e o woté ko ace bwomunen me e âbeele mwo, heme caa ukéiu nang? Te jan me e mwojuia ne mwo tina nyaa ten, ke me e bo âbeele mwo?» ");
INSERT INTO cam_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ke e hegi ne ten wo Iésu pie: «É pii tem a juuju pie: Te tice pace apulie celi e taa ha a Mwametau te Padué, heme time e uce âbeele mu ko a tabe me a *Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nina lé âbeele mu ko pa apulie, ke e te mu kolé a mulie pwo bwohemwo; ke nina lé âbeele mu ko a Jenen Iitihi, ke e te mu kolé a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Go nemwo téetihi ana é pii tem: Wâé heme geé âbeele mwo. ");
INSERT INTO cam_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","«A dan, ke e cuu nge he na te nimen me e cuu ngelang, ke go téne a tihin. Kehe time go uce temehi he celi e âbé mulang, ke é he celi me e â lang. Wonaa ni apulie na lé âbeele mu ko a Jenen Iitihi.» ");
INSERT INTO cam_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ke e tahimwoeng wo Nikodème pie: «Woté ace bwopwonen?» ");
INSERT INTO cam_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ke e hegi ne ten wo Iésu pie: «Wogo pa apipune na lé nihe pipaunuko ne ha amu *Isaraéla, ke time go uce temehi ninaa? ");
INSERT INTO cam_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","É pii tem a juuju pie: Geme pii ni naado na geme te temehi. Geme uti ni naado na geme alihi. Ke time geé uce hegi nina geme uti. ");
INSERT INTO cam_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Me é pii tewé ni naado na e pwo bwohemwo, ke time geé uce céihi ne ko nina é pii. Kona hemepie é bo cihe tewé ko ni naado na e he *miiden, ke geé bo woté ko ace bwo céihi ne kon? ");
INSERT INTO cam_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Te tice pace apulie celi e taa he miiden, kehe te icehi pa Nahi Apulie na e opé mu he miiden. ");
INSERT INTO cam_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«Wo *Moosé, ke e eti da a bwien toki ko a ba-acuwo, ne ha a da. Ke wâé heme wonaa a bwo eti da pa Nahi Apulie, ");
INSERT INTO cam_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","be me wonaa, ke ni apulie na lé céihi ne kon, ke me etelé a mulie na tice anebwén kon.» ");
INSERT INTO cam_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","«Te nihe eânime Padué ko a bwohemwo, ke e ne pa Naîn na te ju céiu nang, be mepie lé céihi ne kon, ke me time lé uce mele, kehe o etelé a *mulie dieli mwo. ");
INSERT INTO cam_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Be time e uce neopé pa Naîn beme e tauti a bwohemwo, kehe me e *celuimi a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pana e céihi ne kon, ke time uce tautieng, kehe pana time e uce céihi ne kon, ke caa tautieng, be time e céihi ne ko a nii pa *Naî Padué na te céiu nang. ");
INSERT INTO cam_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«A tautinaado naa, ke weengi: Caa tuie a pwéélang ne pwo bwohemwo, kehe nime ni apulie ko a melepiing koja a pwéélang. Be ni penem delé, ke ta. ");
INSERT INTO cam_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Wo pa apulie na e pwo nina ta, ke muhi ten ko a pwéélang. Ke time e uce âbé ne ha a pwéélang, be koli genye bo alihi nina e pwo na ta. ");
INSERT INTO cam_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Kehe wo pana e penem ha a juuju, ke e âbé ha a pwéélang, beme nye alihi ni penem den na e pwo mu ko Padué.» ");
INSERT INTO cam_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","É alecehe ni pwooti naa, ke lé tai â ha amu *Judé wo Iésu me ni acémun den. Ke e mu pelelé, ke e *puu apulie. ");
INSERT INTO cam_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Wo Ioane mwo, ke e puu ni apulie ne Aïnon, cebwo Salim, be nihe ubwo a tabe lang. Ke lé âbé me puulé nelang. ");
INSERT INTO cam_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","É ha a benaamwon naa, ke mwo time uce ne Ioane he karépu. ");
INSERT INTO cam_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ke lé pipééle wo lépwo acémun de Ioane me pa Juif, mu ko a bwo puu ne ni éélé pwohewii a patén de ni Juif. ");
INSERT INTO cam_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ke lé â too Ioane, ke lé pii ten pie: «Pa apipune, e ko puu apulie wo pali e mu pipabéém ne ko a céiu goo a éémwa Ioridano, wo pali go mu pipajuujueng, ke caa hiwon nina lé âcéin.» ");
INSERT INTO cam_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ke e pii telé wo Ioane pie: «Pwocoon me e pwo ace céiu naado wo pa apulie, heme time uce ne ten mu he miiden. ");
INSERT INTO cam_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Geé caa te téne he é pii pie, time uce woéo pa *Mesia, kehe woéo pana neéo bé ânebuhen. ");
INSERT INTO cam_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","«Wo pana eten ê apiaten, ke pa apiaten. Ke wo pa béé pa apiaten, ke e mu pelen, ke e tabemieng, ke piwâénimen heme e téne a patin. Pwohewii ne kong, be piwâénimung. Ke é jenaa, ke hején a bwo piwâénimung. ");
INSERT INTO cam_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Wâé heme piubwo nang da, ke me piwahin jo ole.» ");
INSERT INTO cam_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Wo pa apulie na e âbé mu he miiden, ke te nihe e daaité koja ni apulie ati. Ke pana e âbé mu pwo bwohemwo, ke te pa apulie pwo bwohemwo. Ke e te pwo a bwo cihe pwo bwohemwo. Kehe wo pana e âbé mu he miiden, ke te nihe e daaité koja ni apulie ati. ");
INSERT INTO cam_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ke e te uti nina e alihi ke téne. Ke te tice paceli e hegi nina e uti. ");
INSERT INTO cam_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Be wo pa apulie na e hegi nina e uti, ke e *pajuujuhi pie wo Padué, ke e pii a juuju. ");
INSERT INTO cam_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Be wo pa apulie na e pahedeeng wo Padué, ke e pii ni pwooti te Padué. Be time e uce ne jahi a Jenen Iitihi wo Padué. ");
INSERT INTO cam_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ke eânime Padué Caa te pa Naîn, ke e ne ten ni pihuô ne ko ni naado ati. ");
INSERT INTO cam_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pana e céihi ne ko pa Naîn, ke eten a mulie na tice anebwén kon. Paceli time uce nimen me e céihi ne ko pa Naîn, ke time o uce eten a mulie na tice anebwén kon. Kehe o mu huîin a okéé te Padué. ");
INSERT INTO cam_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Lé téne wo lépwo *Farasaio pie, caa hiwon ni *acémun de Iésu, ke e puu ni apulie na hiwon koja Ioane. (Kehe icehi ana time uce wo Iésu na e puu ni apulie, kehe te ni acémun den.) É he e téne anaa wo Iésu, ");
INSERT INTO cam_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ke e engen mu *Judé, ke e mwojuia ne mwo Galilé. ");
INSERT INTO cam_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ke wâé heme e pitahagéi a amu *Samari. ");
INSERT INTO cam_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ke e tuie nge ha amu Samari, ha a céiu duaan na pii kon pie Sichar, cebwo a apwoamu na e ne wo Iakobo te Josef, pa naîn ha a céiu benaamwon. ");
INSERT INTO cam_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","E lang a pwomiidu te Iakobo. Caa mwaale Iésu ko a engen, ke e tebwo ko a jije a pwomiidu. Be caa goahen. ");
INSERT INTO cam_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Lé â ha a mwopopwaalé wo lépwo acémun den, beme lé â pwocuhi ce wiinaado telé. Ke e âbé ê toomwo Samari, beme e tai tabe, ke e pii ten wo Iésu pie: «He te jan me go ne me é ûdu?» ");
INSERT INTO cam_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ke e pii ten wo êje pie: «É mu ko ade, na wogo pa *Juif, ke go ileéo me é ne ace ûdem, woéo ê toomwo Samari?» Be time uce pibéé ni Juif me ni apulie Samari. ");
INSERT INTO cam_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ke e hegi ne ten wo Iésu pie: «Hemepie go te temehi a âpipati te Padué, ke wo pana e pii tem pie: “Nebé ace ûdong”, ke é nelang, ke me go ileeng me e ne ace ûdem, ke e o ne tem a tabe mulip.» ");
INSERT INTO cam_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","E pii ten êgi toomwo pie: «Pa daame, te tice mwotai tabe tem, kehe a pwomiidu, ke te junihe tebwolu. He é mu wé he celi go o pé mulang a tabe mulie na go ko pii? ");
INSERT INTO cam_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","He piubwo go koja pa caa teme Iakobo, na e ne teme a pwomiidu ce? E caa ûdu mu kon me lépwo naîn, me ni wota ten.» ");
INSERT INTO cam_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ke e hegi ne ten wo Iésu pie: «Mepie go ûdu mu ko a tabe ce, ke o mwo te nimem me go ûdu mwo. ");
INSERT INTO cam_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Kehe wo paceli e ûdu a tabe na é ne ten, ke o caa time uce nimen me e ûdu, be a tabe na é ne ten, ke pwohewii acaamatabe na e taawie, ke e tee téte dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ke e pii mwo ten êgi toomwo pie: «Pa daame, go ne tong a tabe naa, beme time bo uce nimung mwo me é ûdu, ke me time é bo uce âmwobé tai éni.» ");
INSERT INTO cam_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ke e pii ten wo Iésu pie: «Go â tode pa aiu hem, ke geu âbé ne éni.» ");
INSERT INTO cam_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ke e pii ten êgi toomwo pie: «Te tice aiu hung.» Ke e pii ten wo Iésu pie: «Te a juuju ana go pii pie te tice aiu hem. ");
INSERT INTO cam_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Be nim ni aiu hem, ke wo pana geu mu jenaa, ke time uce pa aiu hem. É ko anaa, ke go pii a juuju.» ");
INSERT INTO cam_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ke e pii êgi toomwo pie: «Pa daame, é alihi pie wogo, ke pa *péroféta. ");
INSERT INTO cam_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ni caa teme, ke lé pipaunu Padué ne pwo a juwole ce, ke geé pii wogewé lépwo Juif pie, a duaan na me genye pipaunu Padué ne hen, ke é *Iérusaléma.» ");
INSERT INTO cam_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","E hegi ne ten wo Iésu pie: «Êje, go céihi ne ko ana é pii, be o caa tuie a benaamwon na caa time o uce é pwo a juwole ce, ai é ne Iérusaléma, na geé pipaunu Caa. ");
INSERT INTO cam_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Be wogewé ni Samari, ke geé pipaunu pana time geé uce temehieng. Kehe wogeme ni Juif, ke geme pipaunu pana geme temehieng, be a bwo *celuimi ne ni apulie, ke e âbé mu ko ni Juif. ");
INSERT INTO cam_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kehe o caa tuie a benaamwon, ke caa éni, he na lé o pipaunu Caa ne ni apulie, ha a *Jenen Iitihi ke a juuju. Be anaa kuti a pipwoun na nime Caa kon. ");
INSERT INTO cam_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Be wo Padué, ke te a Jenen. Ke wâé heme nina lé pipaunueng, ke lé pipaunueng ne ha a Jenen Iitihi ke a *juuju.» ");
INSERT INTO cam_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ke e pii ten êgi toomwo pie: «É te temehi pie e o tuie pa *Mesia na pii kon pie Kériso. Hemepie e bo tuie, ke e bo patemehi tenye ati ni naado.» ");
INSERT INTO cam_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","E pii ten wo Iésu pie: «Woéo kuti pana é ko cihe tem.» ");
INSERT INTO cam_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","É he lu mwo ko picihe, ke lé tuiebé ne ni acémun den. Ke lé te nihe téele ko ana e pacihe ê toomwo. Ke te tice paceli e tahimwoeng pie: «Ade aceli go tahimwoeng kon?» ai «Ade aceli geu pipii?» ");
INSERT INTO cam_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ke e necu lang a mwotabe ten êgi toomwo. Ke e â ha a mwopopwaalé ten, ke e pii te ni apulie pie: ");
INSERT INTO cam_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Geé âbé ali pa apulie na e pii tong ati ni naado na é pwo. Wieli wo pa Mesia?» ");
INSERT INTO cam_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Lé tai wie mu ha a mwopopwaalé telé, ke lé âbé céii Iésu. ");
INSERT INTO cam_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","É ha a benaamwon naa, ke ni acémun den, ke lé wâgo kon, ke lé pii ten pie: «Pa apipune, go wiinaado!» ");
INSERT INTO cam_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ke e pii telé pie: «A wiinaado na é wii, ke time geé uce temehi.» ");
INSERT INTO cam_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ke lé pitahimwolé ne ni acémun den pie: «He wo paceli e pébé céiieng ce wiinaado?» ");
INSERT INTO cam_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ke e pii telé wo Iésu pie: «A wiinaado tong, ke me é pwo ana nime Padué kon, pana e pahedeéo, ke me é pwo ni penem na e ne tong. ");
INSERT INTO cam_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","«Geé mu pii pie: “O mwo paa ni wole, ke o caa a pitii âdaanu†.” Kehe é pii tewé pie: Geé eti ni naamiiwé, me geé alihi ni apwoamu, be caa a benaamwon ko pitii âdaanu. ");
INSERT INTO cam_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","«Wo pana e pitii âdaanu, ke pwo a cemen, ke e taineibuhi ni acehin ne ko a mulie na tice anebwén kon. Be lu tai pipwodéén ibu wo pana e cemi me pana e tii. ");
INSERT INTO cam_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","É ko anaa, ke a juuju: “E cemi wo pa céiu, ke e tii wo pa céiu.” ");
INSERT INTO cam_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","«É pahedekewé me geé â tii âdaanu he na time geé uce penem lang. Lé penem ne ni béén, ke wogewé, ke geé bo uce pitii âdaanu.» ");
INSERT INTO cam_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Hiwon ni apulie Samari mu ha a mwopopwaalé naa, na lé céihi ne ko Iésu, wonaa mu ko ana e pii wo êgi toomwo pie: «E pii tong ati ni naado na é pwo.» ");
INSERT INTO cam_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Lé âbé tooeng ni apulie Samari, ke lé cuwokon me e mwo mu pelelé. Ke e mu pelelé he na alo ni tan. ");
INSERT INTO cam_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Te nihe hiwon mwo ni apulie na lé céihi mu ko a pwooti ten. ");
INSERT INTO cam_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ke lé pii te êgi toomwo pie: «Time uce é mu ko nina go pii teme cehi na geme céihi. Be geme caa téne temehi pie te ju weeng kuti pa apulie na e celuimi a bwohemwo!» ");
INSERT INTO cam_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Alecehe lupwo tan naa, ke e engen mulang wo Iésu beme e â Galilé. ");
INSERT INTO cam_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Be e caa pii pie: «Wo pa péroféta, ke time lé uce paciitieng ne ha amu ten.» ");
INSERT INTO cam_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ke e âbé ne Galilé, ke lé hegieng ehi nelang. Be lé alihi ati ni naado li e pwo ne Iérusaléma ha a tan ko *Pacika, be lé mu lang ha a tan naa. ");
INSERT INTO cam_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","E mwojuia ne mwo Kana é Galilé, he li e taatééhi nelang a tabe beme a tabe megele. E mu lang wo pace céiu apulie na piubwo nang, pa apihuô te pa daame *Érode. Ke cunu pa naîn ne ha a mwopopwaalé Kapernaüm. ");
INSERT INTO cam_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","E téne pie wo Iésu ke e âbé mu Judé ke e tuiebé Galilé. Ke e âbé beniieng ke e ileeng me e ole, ke me e pwo me wâé pa naîn, be ubwo a cunu kon. ");
INSERT INTO cam_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ke e pii ten wo Iésu pie: «Me time geé uce alihi ni *inenaado na pwojunuun, ke time geé o uce céihi!» ");
INSERT INTO cam_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pa apihuô, ke e pii te Iésu pie: «Padaame, go ole pelong ânebuhe a bwo mele te pa naîng!» ");
INSERT INTO cam_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ke e hegi ne ten wo Iésu pie: «Go âmwo pelem, be caa wâé pa naîm.» E céihi ne ko a pwooti te Iésu, ke e ân. ");
INSERT INTO cam_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","É he e mwo ko â he pwaaden, ke lé âbé beniieng ne ni apenem den me lé pii ten pie: «Pa naîm, ke caa wâé nang.» ");
INSERT INTO cam_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ke e tahimwolé pie: «He ade inetéale celi wâé nang hen?» Ke lé hegi ne ten pie: «É haabwén, ko céiu inetéale ko alecehe goahen, na tieden kojaeng ali pilijing.» ");
INSERT INTO cam_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ke e temehi wo caa ten pie ha a inetéale naa, na e pii ten wo Iésu pie: «Pa naîm, ke caa wâé nang.» Ke lé tai céihi ne ko Iésu, weeng me a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Weengaa a béalohe inenaado na pwojunuun na e pwo wo Iésu, he e mwojuia mu Judé ne Galilé. ");
INSERT INTO cam_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Alecehe a tan naa, ke a *tan ko pipwodéén de ni *Juif. Ke e taa *Iérusaléma wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","É Iérusaléma mwonuhi a Pomwa te ni Muto, ke pwo a mwopiwon, a niin he pwo *ébéru pie Bétesda, na nim ni pomwa kon. ");
INSERT INTO cam_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ke é he ni mwa naa, ke te nihe hiwon ni cunu na lé pule hen: ni bwi, nina tebwa, ke ni tebwomwa. {Be lé ucéihi a bwo penem na a tabe. ");
INSERT INTO cam_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Be e opé wo pa *âcélo, beme e pwo me penem a tabe, he ni béé benaamwon. Ke wo pa bécéiuhe apulie na e ole, heme mwo ko penem a tabe, ke caa te tieden a cunu kon.} ");
INSERT INTO cam_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","E mu hadenii lépwo apulie naa, wo pana cunu nang he na 38 ni jo. ");
INSERT INTO cam_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ke e alieng wo Iésu he e ko pule, ke e te temehi pie caa nihe bwolihi a bwo cunu nang. Ke e pii ten pie: «Nimem me wâé go?» ");
INSERT INTO cam_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ke e hegi ne ten wo pali cunu pie: «Pa daame, te tice celi me lé neéo ole ha a tabe, ha a benaamwon na e ko pipenem a tabe. Ke me é pwo me é ole, ke e caa mi ole wo pace céiu ânebuhung.» ");
INSERT INTO cam_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ke e pii ten wo Iésu pie: «Go cuwoda, ke go pé a talihi tem, ke go engen!» ");
INSERT INTO cam_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ke te wâé nang kuti. Ke e pé a talihi ten, ke e engen. A tan naa, ke a *tan iitihi te lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ke lé pii wo lépwo apihuô juif te pali cunu pie: «É jenaa, ke a tan iitihi, ke iitihi me go pé a talihi tem!» ");
INSERT INTO cam_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","12","Ke e pii telé pie: «Wo pana e pwo me wâé jo, ke e pii tong pie: “Go pé a talihi tem, ke go engen!”» Ke lé tahimwoeng pie: «Wooélé pa apulie na e pii anaa?» ");
INSERT INTO cam_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ke time e uce temehi pie he wooélé. Be wo Iésu, ke caa te tieeng hadenii ni apulie na élé lang. ");
INSERT INTO cam_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ke é alecehen, ke e too pali cunu wo Iésu ne ha a *mwaiitihi, ke e pii ten pie: «Go téne, caa wâé go. Kehe go nemwo pwo ce naado celi ta, be koli e bo tooko aceli nihe ta.» ");
INSERT INTO cam_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ke e engen wo pali, ke e â uti te ni apihuô juif pie: «Wo Iésu na e pwo me wâé jo.» ");
INSERT INTO cam_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","É mu ko anaa, na lé hane Iésu ne ni apihuô juif, beme lé pwotahinaado ne kon, be e pwo ninaa ha a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ke e pii telé wo Iésu pie: «Wo Caa, ke e pwo ni naado dieli jenaa. Ke woéo mwo.» ");
INSERT INTO cam_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","É mu ko anaa, ke ni apihuô juif, ke lé hane ace bwopwonen beme lé taunueng; time uce é mu ko ana e pwo ha a tan iitihi cehi, kehe é mu ko ana e pii mwo pie wo Padué, ke pa ju Caa ten, ke e pii mwo pie, piwielu me Padué. ");
INSERT INTO cam_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","E pii mwo telé wo Iésu pie: «É pii tewé a juuju pie: Wo pa Naîn, ke pwocoon me e pwo ace céiu naado mu kon. E te pwo ni naado na e alihi heme e pwo wo Caa ten. Ke tai ni naado na e pwo wo Caa ten, ke e te pwo mwo wo pa Naîn. ");
INSERT INTO cam_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Be eânime Caa te pa Naîn, ke e habwii ten ati nina e pwo, ke e o habwii ten ni naado na te nihe ubwo koja ninaa, beme geé téele kon. ");
INSERT INTO cam_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Be mepwo wo Caa, ke e pwo me lé mulie cemwo ni amele, ke e ne a mulip. Piwien mwo ne ko pa Naîn, be e ne a mulip ne te lépwona e pipégalilé. ");
INSERT INTO cam_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","«Time e uce tauti apulie wo Caa, kehe e ne a pitautinaado ne te pa Naîn, ");
INSERT INTO cam_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","beme lé tai pipaunueng, pwohewii a bwo pipaunu Caa. Wo paceli time e uce pipaunu pa *Naî Padué, ke time e uce pipaunu Caa na e pahedeeng bé. ");
INSERT INTO cam_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«É pii tewé a juuju pie: Wo paceli e ténedehi a pwooti tong, ke e céihi ne ko pana e pahedeéo bé, ke o eten a mulie na tice anebwén kon. Ke o caa time uce pwocuhinaado ten, be e caa engen koja a mele me e â ha a mulie.» ");
INSERT INTO cam_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","«É pii tewé a juuju pie: E bo tuie a céiu tan, ke caa e éni, ke ni amele, ke lé téne a pwocihe te pa Naî Padué. Ke nina lé ténedehi, ke lé o mulie. ");
INSERT INTO cam_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Be wo Caa, ke eten a mulie, ke pa Naîn, ke te eten mwo a mulie. Te wo Caa ten na e ne ten anaa.» ");
INSERT INTO cam_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","«E ne ten mwo a pihuô beme e tautinaado, mu ko ana weeng pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Geé nemwo téetihi, be o tuie a benaamwon na tai nina lé caa mele, ke lé o téne a patin, ke lé o mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nina lé pwo ni penem na wâé, ke lé o mulie cemwo ne ko a mulie. Kehe nina lé pwo nina ta, ke lé o mulie cemwo ne ko a pwocuhinaado.» ");
INSERT INTO cam_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","E pii telé mwo wo Iésu pie: «Pwocoon me é pwo ace naado mu kong. É tauti mu ko ana e pii wo Padué. Ke a juuju a tautinaado tong, be time é uce hane ana nimung kon, kehe ana nime pana e neéo bé kon. ");
INSERT INTO cam_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Hemepie te woéo na é piutiéo, ke o te ju piticenaado ne ko nina é pii. ");
INSERT INTO cam_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Te pwo pa céiu na e pajuujuéo, ke é te temehi pie ana e pii ne kong, ke a juuju.» ");
INSERT INTO cam_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","«Geé pahede ni apulie nge céii Ioane, ke a jepule na e piuti tewé ne kong, ke a juuju. ");
INSERT INTO cam_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","«É ne kong, ke time uce a junaado ne tong me e pajuujuéo wo pace apulie. Kehe é pii anaa beme celuimikewé. ");
INSERT INTO cam_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Wo Ioane, ke e pwohewii a mwomiû na nye patéi, ke e pwéélang. Ke nimewé me geé pipwodéén ha a cuwo benaamwon naa, ne ko a pwéélang kon.» ");
INSERT INTO cam_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","«Pwo ni bépajuujuéo na junihe ubwo koja Ioane: ni penem na e ne tong wo Caa beme é pacuwohi. Be lé habwii pie wo Caa na e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","«E pajuujuéo wo Caa, be weeng na é pahedeéo bé. Time geé mu uce téne a patin, ke time geé mu uce alihi a pwahamiin. ");
INSERT INTO cam_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ke time uce e kowé a pwooti ten, be time geé uce céihi ne ko pana e neeng bé.» ");
INSERT INTO cam_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","«Geé hane bwoluhi ne he ni tii iitihi, be geé niimihi pie geé o tooli ne hen a mulie na tice anebwén kon. Kehe woélé na lé cihe kong! ");
INSERT INTO cam_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ke time uce nimewé me geé âbé céiiéo beme etewé *a ju mulip. ");
INSERT INTO cam_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«Time é uce hane me lé pipaunuéo ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Be é te temehi pie time uce e kowé a pwonime ko Padué. ");
INSERT INTO cam_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","É âbé ne he nii Caa tong, ke time geé uce hegiéo. Hemepie e âbé wo pace céiu celi e te piâbé mu kon, ke geé o hegieng. ");
INSERT INTO cam_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Woté ace bwo céihi tewé, wogewé na geé hegi *a wâé mu ko ni bééwé? Ke time uce nimewé me geé hane a wâé na e âbé mu ko Padué na te céiu nang. ");
INSERT INTO cam_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Geé nemwo niimihi pie é o pipé ne kowé ne he pwahamii Caa; kehe wo *Moosé pana e o pipé ne kowé, be geé ne kon a céihi tewé! ");
INSERT INTO cam_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","«Be mepie geé céihi ne ko Moosé, ke wieli geé o te céihi ne mwo kong, be e caa cihe kong ne he ni tii ten. ");
INSERT INTO cam_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ke hemepie time geé uce céihi ne ko nina e tii, ke o woté ace bwo céihi tewé ne ko ni pwooti tong?» ");
INSERT INTO cam_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","É alecehen, ke e engen wo Iésu, ke e hagéi a céiu duaa *jié Galilé, na te pii kon mwo pie a jié Tibériade. ");
INSERT INTO cam_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ke lé âcéin ne ni apulie na hiwon jélé, be lé alihi ni *inenaado na pwojunuun, he e pwo me wâé ni cunu. ");
INSERT INTO cam_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ke e taa pwo juwole, ke e tebwo me ni acémun den. ");
INSERT INTO cam_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Te ju piéânebuhe a *Pacika, a *pipwodéén de lépwo *Juif. ");
INSERT INTO cam_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ke me e eti ni naamiin wo Iésu, ke e ali ni apulie na hiwon jélé na lé âbé céiieng. Ke e pii te Filip pie: «He genye bo pwocuhin mu wé ce pwoloa, beme lé wiinaado ne ni apulie ce?» ");
INSERT INTO cam_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","E pii anaa, beme e téne aceli me e o pii wo Filip, kehe e caa te temehi ana me e bo pwo. ");
INSERT INTO cam_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ke e hegi ne ten wo Filip pie: «Hemepie genye pwocuhi ce pwoloa ko ni million, ke time uce jan me nye ne telé ce cuwo nahi mepwoloa!» ");
INSERT INTO cam_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ke e â céii Iésu wo pa céiu acémun na pii kon pie André, pa âjiéne Simon Pétéru, ke e pii ten pie: ");
INSERT INTO cam_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«E éni pa cuwo nahi ewa aiu, na nim ni pwoloa ten, ke alo lupwo ikua. Kona he o te jan ne ko ni apulie na nihe hiwon jélé? Ûhu!» ");
INSERT INTO cam_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","E pii wo Iésu pie: «Pwo me lé tebwo ati ne ni apulie.» Ha a duaan naa, ke hiwon ni meté, ke lé tebwo ni apulie. Ke âmwonuhi a 5000 ni apulie aiu. ");
INSERT INTO cam_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ke e pé li pwoloa wo Iésu, ke e olééhi ne te Padué. Ke e patihi ne ko ni apulie na élé lang. Ke e patihi mwo li ikua ne telé. Ke lé wiinaado dieli â pwoluu jélé. ");
INSERT INTO cam_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Caa pwoluu jélé, ke e pii te ni acémun den pie: «Geé tai ni nehi wiinaado, beme te tice celi genye patieden.» ");
INSERT INTO cam_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Lé tai ni nehi li pwoloa li nim, ke lé paobaanihi ni élele na 12, alecehe a bwo wiinaado telé. ");
INSERT INTO cam_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ke ni apulie, ke lé alihi a inenaado na pwojunuun na e pwo wo Iésu, ke lé pii pie: «Pa apulie ce, ke te pa ju Péroféta na me e âbé ne pwo bwohemwo!» ");
INSERT INTO cam_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ke e temehi wo Iésu pie lé o âbé pééeng beme lé etieng me pa daame helé. Ke e piâ ité kojalé, ke e â taa pwo juwole, he te piweeng cehi. ");
INSERT INTO cam_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","He caa babwén, ke lé ole ko a bajié wo lépwo *acémun de Iésu. ");
INSERT INTO cam_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Caa bwén, kehe time e uce téele â toolé. Ke lé taa pwo ong, beme lé â Kapernaüm. ");
INSERT INTO cam_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ke e te nihe tahieng a dan, ke ubwo ni pihijié. ");
INSERT INTO cam_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ke lé caa kaatihi a ong he na nim kilomètre. Ke lé ali Iésu he e engen pwo bwotabe, ke e âbé mwonuhi a ong. Ke te junihe mwotilé. ");
INSERT INTO cam_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ke e pii telé wo Iésu pie: «Geé nemwo pwo me mwotikewé! Be *Woéo!» ");
INSERT INTO cam_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ke nimelé me lé pééeng pwo ong, kehe lé caa tuie nge he na me lé â lang. ");
INSERT INTO cam_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","24","É ha acaama hen, ke lé mwo te mu ko a céiu goon ne li apulie li lé eni ali pwoloa. Ke lé alihi pie te tie Iésu. Ke lé te temehi pie time e uce taa pwo ong, be lé caa te piengen cehi ni acémun den. Ke te céiu a ong na e engen. É he lé mwo ko haneeng ke lé tuie ne ni ong bé mu ha a pwomwo ubwo Tibériade. Ke lé taa pwo li ong ne ni apulie, ke lé â Kapernaüm, me lé â haneeng lang. ");
INSERT INTO cam_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ke lé too Iésu ne ko a céiu goon. Ke lé pii ten pie: «Pa apipune, he éniile celi go âbé éni?» ");
INSERT INTO cam_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ke e pii telé wo Iésu pie: «É pii tewé a juuju pie: Geé haneéo, time uce é mu ko a bwo alihi nen dewé ni inenaado na pwojunuun na é pwo, kehe é mu ko ana geé eni ni pwoloa, ke pwoluu gewé. ");
INSERT INTO cam_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Geé nemwo penem ne ko a wiinaado na o tieden, kehe geé penem ne ko a wiinaado na e o mu, na e ne a mulip ne pele Padué dieli mwo. A wiinaado naa, ke wo pa Nahi Apulie na e bo ne tewé. Be wo Padué Caa na e ne a pihuô te pa Naîn.» ");
INSERT INTO cam_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ke lé pii ten pie: «He ade aceli me geme pwo, beme geme pwo ni penem de Padué?» ");
INSERT INTO cam_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ke e pii telé wo Iésu pie: «A penem de Padué, ke me geé céihi ne ko pana e neeng bé.» ");
INSERT INTO cam_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ke lé pii ten mwo pie: «Ade ace inenaado celi go pwo me geme alihi, ke me geme céihi ne ko nina go pii? Go pwo de? ");
INSERT INTO cam_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Lé eni a pwoloa ne ha a melé ne ni watihenye, pwohewii ana caa tii ne he ni tii iitihi pie: E ne telé a pwoloa mu he miiden me lé eni.» ");
INSERT INTO cam_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ke e hegi ne telé wo Iésu pie: «É pii tewé a juuju pie: Time uce wo *Moosé na e ne tewé a pwoloa na e âbé mu he miiden. Kehe wo Caa tong. Ke é jenaa ni, ke e ne tewé a ju pwoloa mu he miiden. ");
INSERT INTO cam_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Éa, a pwoloa te Padué, ke wo pana e opé mu he miiden, ke e ne a mulie ne pwo bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ke lé pii ten pie: «Pa apipune, go te cuwo ko ne teme a pwoloa naa!» ");
INSERT INTO cam_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ke e hegi ne telé wo Iésu pie: «Woéo, ke pa pwoloa na é ne a mulip. Wo paceli e âbé céiiéo, ke time o uce menen, ke wo paceli e céihi ne kong, ke time o uce nimen me e ûdu. ");
INSERT INTO cam_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","É caa mi pii tewé pie: Geé aliéo, kehe time geé uce céihi ne kong. ");
INSERT INTO cam_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ati ni apulie na e ne tong wo Caa, ke lé âbé céiiéo. Ke time é o uce ne pwomwo paceli e âbé céiiéo. ");
INSERT INTO cam_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","«Ke time é uce opé mu he miiden me é pwo ana nimung kon, kehe me é pwo ana nime Padué, na e neéo opé. ");
INSERT INTO cam_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Neko ana nime Padué kon, ke me time é uce patieden paceli te ju céiu nang, mu ko ni apulie na e ne tong; kehe me é pwo me lé mulie cemwo ha a Tan Alece. ");
INSERT INTO cam_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ana nime Caa tong kon: Ke wo paceli e ali pa Naîn, ke me céihi ne kon, ke o ne ten a mulie na tice anebwén kon. Ke é bo pwo me e mulie cemwo ha a Tan Alece.» ");
INSERT INTO cam_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Lé pipii Iésu wo lépwo Juif, mu ko ana e pii pie: «Woéo, ke pa pwoloa na é opé mu he miiden.» ");
INSERT INTO cam_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ke lé pipii mwo pie: «He time uce wo Iésu pali naî Josef, li genye te temehi lu nyaa me caa ten? É mu ko ade na e pii pie: “É opé mu he miiden”?» ");
INSERT INTO cam_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ke e pii telé wo Iésu pie: «Geé nemwo tee pipii apulie! ");
INSERT INTO cam_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Te tice paceli e âbé céiiéo, heme time uce neeng bé wo Caa, pana e neéo bé. Ke me é bo pwo me e mulie cemwo ha a Tan Alece. ");
INSERT INTO cam_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Neko ana e tii wo pa céiu péroféta: Lé o te tai picaa mu ko Padué. É mu ko anaa, na wo paceli e téne Caa, ke e hegi ni pune ten, ke e o âbé céiiéo. ");
INSERT INTO cam_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Te tice paceli e ali Caa, te icehi pana e âbé mu ko Padué.» ");
INSERT INTO cam_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","«É pii tewé a juuju pie: Wo paceli e céihi ne kong ke o eten a mulie na tice anebwén kon. ");
INSERT INTO cam_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","A pwoloa na e ne a mulie, ke woéo. ");
INSERT INTO cam_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Lé eni a manne ne ha a melé ne ni caa tewé, ke lé tai mele. ");
INSERT INTO cam_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Weengi a pwoloa na e opé mu he miiden. Wo paceli e o eni, ke time e o uce mele. ");
INSERT INTO cam_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Woéo, ke pa pwoloa ko a mulip, na é opé mu he miiden. Mepie pwo paceli e eni mu ko a pwoloa naa, ke e o *mulie dieli mwo. A pwoloa na é ne ten, ke a ééng, na é bo ne, me a mulie ne pwo bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","É mu ko ana e pii wo Iésu, ke lé pidaataa kon ne ni Juif, ke lé pii pie: «E o woté ko ace bwopwonen me e ne tenye a één beme a wiinaado?» ");
INSERT INTO cam_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ke e pii telé wo Iésu pie: «É pii tewé a juuju pie: Mepie time geé uce wii a éé pa Nahi Apulie, ke me time geé uce ûdu a cewéhen, ke o time uce e kowé a mulie. ");
INSERT INTO cam_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Wo paceli e wii a ééng, ke e ûdu a cewéhung, ke eten a mulie na tice anebwén kon. Ke é bo pwo me e mulie cemwo ha a Tan Alece. ");
INSERT INTO cam_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Be a ééng, ke te a ju wiinaado; ke a cewéhung, ke te a ju tabe. ");
INSERT INTO cam_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Wo paceli e wii a ééng ke e ûdu a cewéhung, ke e o mu kong, ke é o mu kon. ");
INSERT INTO cam_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","«E mulie wo Caa na e neéo bé. Ke woéo, ke é mulie ko Caa. Ke wo paceli e wii a ééng, ke e o mulie mu kong. ");
INSERT INTO cam_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Weengi a pwoloa na e opé mu he miiden. Time uce pwohewii ni watihewé na lé eni a manne, ke lé tai mele. Be wo paceli e eni a pwoloa ce, ke e o mulie dieli mwo.» ");
INSERT INTO cam_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E pii telé ninaa wo Iésu ne ha a *mwotapitihi te ni Juif ne Kapernaüm. ");
INSERT INTO cam_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ke me lé téne ana e pii wo Iésu, ke hiwon ni acémun den na lé pii pie: «Te nihe binyi ni pwooti ten. He woo paceli me e tee tabemieng?» ");
INSERT INTO cam_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Kehe e te temehi pie lé pipiieng ko nina e pii, ke e tahimwolé pie: «Woté? Ni pwooti naa, ke te nihe téé ne tewé? ");
INSERT INTO cam_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Ke mepie geé ali pa Nahi Apulie heme e taamwo he na e mu lang ânebun, ke geé bo pii pie woté? ");
INSERT INTO cam_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","A *Jenen Iitihi, ke e ne a mulie. Kehe wo pa apulie, ke te tice aceli jan me e pwo. Ni pwooti na é pii tewé, ke e âbé mu ko a Jenen Iitihi, ke e ne a mulip. ");
INSERT INTO cam_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pwo ni béén mu hadeniiwé na time lé uce céihi.» Be e te temehilé wo Iésu ha atabuhi kon. Ke e te temehi mwo pana e bo icueng. ");
INSERT INTO cam_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ke e pii ne mwo pwon pie: «É mu ko anaa, na é pii tewé pie: Te tice paceli e o âbé céiiéo, hemepie time e uce neeng bé wo Caa.» ");
INSERT INTO cam_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ke é ha a benaamwon naa, ke hiwon ni acémun den na lé engen kojaeng. ");
INSERT INTO cam_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ke e pii wo Iésu te lépwo 12 *apostolo ten pie: «Ke wogewé, ke time uce nimewé mwo me geé âcéilé?» ");
INSERT INTO cam_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ke e hegi ne ten wo Pétéru pie: «Padaame, he me geme â céii-i? Be te e pelem cehi ni pwooti ko a mulie na tice anebwén kon. ");
INSERT INTO cam_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ke geme caa céihi, ke geme caa temehi pie wogo ke wo Kériso, pa *Naî Padué.» ");
INSERT INTO cam_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ke e hegi ne telé wo Iésu pie: «Woéo na é pipégalikewé, wogewé ni 12. Ke pwo pa duéé hadeniiwé!» ");
INSERT INTO cam_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","E cihe ko Judas Iscariot, pa naî Simon, pa béé lépwo 12 apostolo. Be weeng pana e o bo icueng. ");
INSERT INTO cam_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Alecehe anaa, ke e engen ati ha amu Galilé wo Iésu, be time uce nimen me e â *Judé, be lé hane me lé taunueng ne ni apihuô juif. ");
INSERT INTO cam_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ke caa e mwonu a *tan ko pipwodéén de ni *Juif ko Mwa mwaanu. ");
INSERT INTO cam_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ke lé pii te Iésu ne ni âjiénen pie: «Go engen mu éni, ke go â Judé, beme lé alihi ne ni apulie tem ni naado na go pwo. ");
INSERT INTO cam_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Te tice paceli e penem ha aduwo, heme nimen me lé temehieng. Go pwo ni naado na ubwo, ke go pihabwiiko ne te ni apulie!» ");
INSERT INTO cam_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Be ni âjiénen mwo, ke time lé uce ju téele céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ke e pii telé wo Iésu pie: «Time e uce téele tuie a benaamwon dong. Kehe wogewé, ke te é ati he ni benaamwon. ");
INSERT INTO cam_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Te tice watihen me lé téétikewé ne ni apulie, kehe woéo, ke lé téétiéo, be é te cuwo ko pii beetihi ni naado na ta na lé pwo. ");
INSERT INTO cam_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Geé taa wogewé, ne ko a *pipwodéén naa. Kehe woéo, ke time é o uce téele taa, be time e uce téele tuie a benaamwon dong.» ");
INSERT INTO cam_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ke me e pii telé anaa, ke e mwo te mu Galilé. ");
INSERT INTO cam_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kehe icehi ana me lé caa taa wo lépwo âjiénen ne ko a pipwodéén, ke e bwo te pitaa céilé wo Iésu, kehe icehi ana time e uce pihabwiieng. ");
INSERT INTO cam_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ni apihuô juif, ke lé haneeng ha a benaamwon ko a pipwodéén, ke lé tahimwohi pie: «He e wé naa?» ");
INSERT INTO cam_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Lé te nihe picihe kon ne ni apulie. Ke lé pii ne ni béén pie: «Pa apulie na wâé nang.» Ke ni béén, ke lé pii pie: «Ûhu! E pwo me lé pipatieden ne ni apulie.» ");
INSERT INTO cam_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ke te tice paceli e cihe pwaatihi ne kon, be mwotilé ko lépwo apihuô juif. ");
INSERT INTO cam_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ha awieme a pipwodéén, ke e taa ha a *mwaiitihi wo Iésu. Ke e pacémunilé. ");
INSERT INTO cam_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Lé te nihe téele ne ni apihuô juif, ke lé pii pie: «He e woté ace bwo temehi nen den ni patén, he time e uce cémun?» ");
INSERT INTO cam_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ke e hegi ne telé wo Iésu pie: «Ni pune, ke time uce é mu kong, kehe é mu ko pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Hemepie nime pace apulie me e pwo nina nime Padué kon, ke e o te temehi pie ni pune naa, ke e âbé mu ko Padué, ai e âbé mu kong. ");
INSERT INTO cam_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Wo pana e te picihe mu kon, ke e hane me lé pipaunueng. Ke wo pana e hane me lé pipaunu pana e neeng bé, ke e mwomwon, ke te tice gele kon.» ");
INSERT INTO cam_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","«Kona time e uce ne tewé ni patén wo *Moosé? Ke te tice paceli e âcehi ni patén mu kowé. Ade ace watihen me nimewé me geé taunuéo?» ");
INSERT INTO cam_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ke lé hegi ne ten pie: «E kom a iténaado! He woo paceli e hane me e taunuko?» ");
INSERT INTO cam_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ke e hegi ne telé wo Iésu pie: «É pwo a penem na te ju céiu ha a *tan iitihi ke geé tai téetihi. ");
INSERT INTO cam_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ke wogewé mwo, ke geé te penem mwo ha a tan iitihi, be geé *pwotegoop te pa ewa aiu, âcehi ni *patén de Moosé. Kehe time e uce âbé mu ko Moosé na a tegoop, be e te âbé mu ko ni watihenye ânebuhen. ");
INSERT INTO cam_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","É ha a tan iitihi, ke geé pwotegoop te pa ewa aiu, beme time geé uce caada ni patén. Woéo, ke é ha a tan iitihi, ke é pwo me wâé pa apulie. Ke geé okéé ne kong kona woté? ");
INSERT INTO cam_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Geé nemwo tauti ni naado ne ha a bwo alihi nen. Kehe geé tauti ne ha a mwomwon.» ");
INSERT INTO cam_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Lé pii ne ni béé apulie mu *Iérusaléma pie: «He time uce wo pali lé hane me lé taunueng? ");
INSERT INTO cam_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Geé alihi! Be e cihe ânebuhe ni apulie! Te tice paceli e cihe ten. Wieli ni apihuô tenye, ke lé caa temehi pie weeng pa *Mesia? ");
INSERT INTO cam_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Kehe wo pa apulie ce, ke genye te temehi he na e âbé mulang. Kehe wo Kériso, ke mepie e tuie, ke te tice paceli e temehi he celi e âbé mulang.» ");
INSERT INTO cam_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","É ha a benaamwon naa, he e mwo ko pipune ne *huâ iitihi wo Iésu, ke e cihe me ubwo, ke e pii telé pie: «Geé te temehiéo. Ke geé te temehi he na é âbé mulang. Time é uce piâbé mu kong, kehe a juuju a pwooti te pana e neéo bé. Ke time geé uce temehieng. ");
INSERT INTO cam_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Woéo, ke é te temehieng, be é âbé mu kon, ke weeng na e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Lé hane beme lé imwieng, kehe te tice bwopwonen, be time e uce téele tuie a benaamwon den. ");
INSERT INTO cam_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Hiwon ni apulie na lé céihi ne kon, ke lé pii pie: «Hemepie e tuie wo pa Mesia, ke he o te hiwon ce inenaado celi pwojunuun celi e pwo koja pa apulie ce?» ");
INSERT INTO cam_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ni *Farasaio, ke lé téne ni apulie he lé ko pii éwaan kon. Ke lé piténelé me ni caa te lépwo *apwoâpwailo, beme lé pahede ni awéihi mwaiitihi me lé imwieng. ");
INSERT INTO cam_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ke e pii telé wo Iésu pie: «É o mwo mu pelewé ha a benaamwon ce, ke é alecehen, ke é o caa âmwo too pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Geé bo haneéo, ke time geé o uce tooéo, be pwocoon me geé â he na é â lang.» ");
INSERT INTO cam_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ke lé pitahimwolé ne ni Juif pie: «He e o â wé? Ha ace céiu duaan celi me time genye o uce tooeng hen? Pele ni Juif na lé mulie hadenii lépwona time uce lépwo Juif? He e o picaalé? ");
INSERT INTO cam_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","E pii tenye pie: “Geé bo haneéo, ke time geé o uce tooéo, be pwocoon me geé â he na é â lang.” Ke he a bwopiinen pie woté ni pwooti naa?» ");
INSERT INTO cam_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Caa tuie a bénebwéne tan ko a pipwodéén, a tan na nihe pipwonaado ne kon. Ke e cuwoda wo Iésu, ke e toii pie: «Mepie pwo paceli nimen me e ûdu, ke jan me e âbé céiiéo, ke me e ûdu. ");
INSERT INTO cam_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ke wo paceli e céihi ne kong, ke o bo téte he pwonimen a éémwa. Ke a tabe naa, ke e ne a mulip. Genye pine anaa ne he ni tii iitihi.» ");
INSERT INTO cam_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","E pii anaa ne ko a *Jenen Iitihi, na me lé bo hegi ne nina lé céihi ne kon. É ha a benaamwon naa, ke mwo time e uce téele âbé na a Jenen Iitihi, be mwo time e uce téele hegi *a wâé ten wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","É he lé téne ni pwooti te Iésu, ke lé pii ne ni béén pie: «A juuju pie te weeng kuti pa Péroféta!» ");
INSERT INTO cam_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ke lé pii mwo ne ni béén pie: «Weeng pali Mesia!» Kehe pwo ni béén na lé pii pie: «He te é mu Galilé he celi me e âbé mulang wo pa Mesia? Ûhu! ");
INSERT INTO cam_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Be nye pine ne he ni tii iitihi pie, wo pali Mesia, ke e wie mu ko a pwomwoiu te *Davita. Ke e o âbé mu Bétéléma, a mwopopwaalé te Davita.» ");
INSERT INTO cam_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","É mu ko Iésu, ke time lé uce piténelé ne ni apulie. ");
INSERT INTO cam_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ke nime ni béén me lé imwieng, kehe te tice bwopwonen. ");
INSERT INTO cam_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","É he lé âmwobé ne ni awéihi mwaiitihi, ke lé tahimwolé wo lépwo caa te ni apwoâpwailo me ni Farasaio pie: «He time geé uce pébé Iésu be woté?» ");
INSERT INTO cam_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ke lé hegi ne ni awéihi mwaiitihi pie: «Te tice pace apulie celi e cihe pwohewii pa apulie ce!» ");
INSERT INTO cam_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ke lé pii telé ne ni Farasaio pie: «Wogewé mwo, ke e te pahaulikewé mwo! ");
INSERT INTO cam_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Be te tice pace apihuô, ke te tice pace Farasaio celi e céihi ne kon! ");
INSERT INTO cam_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Kehe ni apulie ce ke te tice aceli lé temehi! Ke lé ko céihi ne kon, be time lé uce temehi ni patén de Moosé. Ke e nelé nge ité wo Padué!» ");
INSERT INTO cam_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Kehe icehi ana e cuwoda wo Nikodème, pali e âbé too Iésu he bwén. Ke e pii te ni Farasaio béén pie: ");
INSERT INTO cam_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Ne he ni patén denye, ke pwocoon me nye pwo me e pwocuhinaado wo paceli time nye uce téele téne ke temehi aceli e pwo.» ");
INSERT INTO cam_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ke lé hegi ne ten wo lépwo béén pie: «He wogo mwo, ke pa aâbé mu Galilé? Pine ehi ni tii iitihi, ke go bo temehi pie, te tice péroféta celi lé âbé mu Galilé!» { ");
INSERT INTO cam_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","É nelang, ke lé pétaapwo âmwo he ni pomwa telé.} ");
INSERT INTO cam_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","E engen wo Iésu, ke e taa pwo a juwole ko ni Olivier. ");
INSERT INTO cam_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","É ha acaama hen, he mwo te ju acaama, ke e mwojuia ngemwo ha a *mwaiitihi. Ke lé âbé ne kon ne ni apulie na hiwon jélé. Ke e tebwowo Iésu, ke e punelé. ");
INSERT INTO cam_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ke lé âbé céiieng ni *dotéén ko patén me ni *Farasaio, ke lé pébé céiieng ê toomwo na lé tooeng he lu pibune me pa aiu na time uce pa aiu hen. Ke lé pwo me e cuwo ânebuhelé ati. ");
INSERT INTO cam_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ke lé pii ten pie: «Pa apipune, geme mwo te ju téetedo ê toomwo ce, he e ko bune aiu. ");
INSERT INTO cam_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ne he ni *patén de Moosé, ke e pii pie me taunuhi ko péi ni toomwo na lé pwo anaa. Ke kona wogo, ke ade aceli go pii ne kon?» ");
INSERT INTO cam_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Lé pii ten anaa beme lé tacebwénieng, be pwo aceli me lé pipé ne kon kon. Kehe e ciieng wo Iésu, ke e pwotii ko a mwodéin, neole pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ke lé teko cuwo ko tahimwoeng. Ke e etieng wo Iésu, ke e pii telé pie: «Wo pace bééwé celi mwo te tice ta pwo ten, ke me e tabuhi tahi kon ace bécéiuhe péi.» ");
INSERT INTO cam_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ke e te ciieng mwo wo Iésu, ke e te pwotii ne mwo pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ke me lé téne ni pwooti naa, ke lé engen he picéiuhi, tabuhi mu ko pana piukéiu nang. Ke lu te pimu cehi wo Iésu me êgi toomwo, he e mwo teko cuwo ânebuhen. ");
INSERT INTO cam_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ke e etieng wo Iésu, ke e pii ten pie: «He élé wé wo lépwoli lé tautiko? Te tice paceli e pwocuhinaado tem?» ");
INSERT INTO cam_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ke e hegi ne ten wo êgi toomwo pie: «Pa apipune, caa tielé.» Ke e pii ten wo Iésu pie: «Woéo mwo, ke time é uce pwocuhinaado tem. Kehe go engen, ke tabuhi ni, ke time go bo uce pwo mwo ce naado celi ta.» ");
INSERT INTO cam_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","E pii mwo telé wo Iésu pie: «Woéo, ke é pwéélang pwo a bwohemwo. Wo paceli e âbé céing, ke time e bo uce engemwo ha a melepiing, kehe o eten a pwéélang ko a mulip.» ");
INSERT INTO cam_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ke lé pii ten ne ni Farasaio pie: «Go te pipajuujuko, be ana go pii, ke time uce pwonaado ne kon!» ");
INSERT INTO cam_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ke e hegi ne telé wo Iésu pie: «Éa, é te pipajuujuéo, kehe nina é pii ne kong, ke te ni juuju. É te temehi he na é âbé mulang, ke é te temehi he na me é â lang. Kehe wogewé, ke time geé uce temehi he na é âbé mulang, ai é he celi é â lang. ");
INSERT INTO cam_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Geé tauti pwohewii a bwohemwo. Kehe woéo, ke time é uce tauti pace apulie. ");
INSERT INTO cam_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Heme é tauti, ke é tauti ne ha a mwomwon, be time uce woéo cehi na é tauti; kehe te tai wogemu me Caa, na e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ne he ni patén dewé, ke genye pine pie: “Mepie lu pii aceli céiu wo lupwoce apulie, ke genye céihi ne ko ana lu pii.” ");
INSERT INTO cam_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","É te pipajuujuéo, ke e te pajuujuéo mwo wo Caa na e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lé tahimwoeng ne ni Farasaio pie: «He e wé wo caa tem?» Ke e hegi ne telé wo Iésu pie: «Time geé uce temehiéo, ke time geé uce temehi mwo pa Caa tong. Hemepie geé temehiéo, ke me geé o te temehi mwo pa Caa tong.» ");
INSERT INTO cam_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ke e pii telé ni pwooti naa wo Iésu, ha a benaamwon na e pacémunilé ne ha a mwaiitihi, é he na e lang ni âpipati ni mwani. Te tice paceli me e imwieng, be mwo time uce téele a benaamwon den. ");
INSERT INTO cam_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","E pii telé mwo wo Iésu pie: «É o engen, ke geé bo haneéo, kehe geé bo mele ne he ni ta pwo tewé. Be o pwocoon me geé â he na me é â lang.» ");
INSERT INTO cam_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ke lé pii ne ni *Juif pie: «He e o â pitaunueng? Be e ko pii pie: “Time geé uce â he na me é â lang.”» ");
INSERT INTO cam_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ke e pii telé wo Iésu pie: «Wogewé, ke geé âbé mu pwo bwohemwo, kehe woéo, ke é opé mu he miiden. Ke wogewé, ke lépwo apulie pwo bwohemwo, kehe woéo, ke time uce pa apulie éni pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","É mu ko anaa, ke é pii tewé pie, geé bo mele ne he ni ta pwo tewé. Éa, geé o bo mele ne he ni ta pwo tewé, hemepie time geé uce céihi pie, ‘*Woéo ânebun, ke é jenaa, ke é dieli mwo’.» ");
INSERT INTO cam_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ke lé tahimwoeng pie: «Wogo, ke he woo?» Ke e hegi ne telé wo Iésu pie: «É caa te cuwo ko pii tewé mu ha atabuhi kon. ");
INSERT INTO cam_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Hiwon ni naado na me é pii ne kowé, ke me é tauti ne kowé. Kehe é te pii pwaatihi cehi ana é téne mu ko pana e neéo bé, be pana e pii a juuju.» ");
INSERT INTO cam_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Time lé uce temehi pie e ko cihe telé ko Padué Caa. ");
INSERT INTO cam_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ke e pii telé wo Iésu pie: «Hemepie geé pieti da pa Nahi Apulie, ke geé o temehi pie woéo, ke te ‘Woéo ânebun, ke é jenaa, ke é dieli mwo’. Ke geé o temehi pie time é uce pipwo ni naado mu kong, kehe é pii ni naado na é picaa mu ko Caa. ");
INSERT INTO cam_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Wo pana e neéo bé, ke te e pelong. Time e uce pineéo cehi, be é te cuwo ko pwo nina wâé ten.» ");
INSERT INTO cam_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","É ha a benaamwon na e pii anaa wo Iésu, ke hiwon ni apulie na lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ke e pii te ni Juif na lé céihi ne kon wo Iésu pie: «Hemepie geé cumang ne ko ni pwooti na é pii tewé, ke a juuju pie wogewé, ke ni acémun dong. ");
INSERT INTO cam_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Geé o temehi a *juuju. Ke a juuju, ke e bo tuwokewé.» ");
INSERT INTO cam_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ke lé pii ten pie: «Wogeme ne ha a pwomwoiu te *Abérama, ke time geme mu uce téele â penem tice ja kon de pace apulie. Ke go o woté ko ace bwopiinen deme pie, o bo tuwokeme?» ");
INSERT INTO cam_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","35","Ke e hegi ne telé wo Iésu pie: «Éa, é pii tewé a juuju pie: Wo pana e pwo nina ta, ke pa *apenem tice ja kon de ni ta pwo ten. Ke wo pa apenem tice ja kon, ke time e uce mu taaci ha a pwomwoiu te pa caa ten. Be te pa naîn cehi na e mu ha a pwomwoiu dieli mwo. ");
INSERT INTO cam_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Hemepie e tuwokewé wo pa Naî Padué ke o caa te tice aceli o mwo toole gewé kon. ");
INSERT INTO cam_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","É te temehi pie wogewé ha a pwomwoiu te Abérama. Kehe geé hane me geé taunuéo, be time geé uce hegi ni pwooti tong. ");
INSERT INTO cam_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Woéo, ke é pii ni naado na é alihi ne pele Caa tong. Kehe wogewé, ke geé te pwo nina geé picaa mu ko pa caa tewé.» ");
INSERT INTO cam_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ke lé hegi ne ten pie: «Wo Abérama pa caa teme!» Ke e pii telé wo Iésu pie: «Hemepie wogewé ni ju naî Abérama, ke geé o pwo ni penem na e pwo. ");
INSERT INTO cam_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Woéo, ke é pii tewé a juuju na é téne mu pele Caa. Ke é jenaa, ke geé hane beme é mele. Abérama, ke time e uce pwo anaa! ");
INSERT INTO cam_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Wogewé, ke geé te pwohewii pa caa tewé.» Ke lé hegi ne ten pie: «Wogeme, ke time uce ni ewa mu ko pace céiu apulie. Te céiu pa caa teme, ke wo Padué.» ");
INSERT INTO cam_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ke e pii telé wo Iésu pie: «Hemepie wo Padué, ke pa Caa tewé, ke o eânimewé tong. Be woéo, ke é âbé mu ko Padué. Ke woéo éni mu kon. Time é uce piâbé mu kong, kehe wo Padué na e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","É mu ko ade na time geé uce téne temehi nina é pii tewé? Be time geé uce tabemi ni pwooti tong. ");
INSERT INTO cam_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","«Be te wo *Caatana pa caa tewé! Ke nimewé me geé pwo nina nimen kon. Weeng, ke pa ataunuhi apulie mu ha atabuhi kon. Time e uce mu ha a juuju, be te tice juuju kon. E te pii ni gele, be te pa agele. Be weeng, ke pa caa te a gele. ");
INSERT INTO cam_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","«Ke woéo, ke é pii a juuju. Ke é mu ko anaa, na time geé uce céihi ne ko ana é pii. ");
INSERT INTO cam_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Hadeniiwé, ke te tice paceli jan me e pii pie pwo ni ta pwo tong. É pii a juuju, ke time geé uce céihi ne ko ana é pii kona woté? ");
INSERT INTO cam_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Pa apulie te Padué, ke e tabemi ni pwooti te Padué. Kehe wogewé, ke time geé uce tabemi, be time geé uce apulie te Padué.» ");
INSERT INTO cam_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ke lé pii te Iésu ne ni Juif pie: «Te a juuju pie wogo, ke pa apulie *Samari, be e kom a jenenaado!» ");
INSERT INTO cam_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","E hegi ne telé wo Iésu pie: «Ûhu, te tice jenenaado kong, be é pipaunu Caa tong. Kehe wogewé, ke time geé uce pipaunuéo. ");
INSERT INTO cam_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Time é uce hane *a wâé tong, kehe pwo pana e hane a wâé tong, ke e tauti. ");
INSERT INTO cam_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Éa, é pii tewé a juuju pie: Hemepie pwo paceli e ténedehi ni pwooti tong, ke time e o uce mele.» ");
INSERT INTO cam_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ke lé pii te Iésu ne ni Juif pie: «É jenaa, ke geme caa temehi pie, e kom a jenenaado. E caa mele wo Abérama me ni péroféta, ke go pii wogo pie: “Hemepie pwo paceli e ténedehi ni pwooti tong, ke time e o uce mele.” ");
INSERT INTO cam_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","«He te junihe piubwo go koja Abérama, pa caa teme, na e caa mele me ni péroféta? He go pipééko me pa de?» ");
INSERT INTO cam_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ke e hegi ne telé wo Iésu pie: «Time é uce pwo me é pipaunuéo, be mepie é pipaunuéo, ke o te piticenaado ne kon. Te wo Caa tong na e te ne tong a wâé. Weeng na geé pii kon pie Padué hewé! ");
INSERT INTO cam_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Kehe time geé uce temehieng. Kehe woéo, ke é te temehieng. Hemepie é pii pie time é uce temehieng, ke é o gele pwohewiikewé. Kehe é te temehieng, ke é te ténedehi ni pwooti ten. ");
INSERT INTO cam_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abérama, pa caa tewé, ke e pipwodéén, be e niimihi pie e o alihi a tan na é tuie hen. Ke e caa alihi, ke te nihe ubwo a bwo piwâénimen.» ");
INSERT INTO cam_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ke lé pii te Iésu ne ni Juif pie: «Mwo time uce 50 ni jo hem, ke he go caa ali Abérama?» ");
INSERT INTO cam_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ke e hegi ne telé wo Iésu pie: «Éa, é pii tewé pie ânebuhe a bwo tuie te Abérama, ke caa te woéo lang.» ");
INSERT INTO cam_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ke lé pé ni péi beme lé tahi ko Iésu, kehe e taduwo kolé, ke e wie mu ha a mwaiitihi. ");
INSERT INTO cam_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","He e ko â pwo pwaaden wo Iésu, ke e ali pa apulie na bwi nang, tabuhi ha a bwo âbeele ten. ");
INSERT INTO cam_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ke lé tahimwo Iésu wo lépwo acémun den pie: «Pa apipune, he é mu ko ade na wo pa apulie ce, ke e âbeele he bwi nang? Wonaa mu ko ni ta pwo ten, ai ni ta pwo te lu nyaa me caa ten?» ");
INSERT INTO cam_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ke e hegi ne telé wo Iésu pie: «Time uce weeng, ke time uce wo lu nyaa me caa ten. A bwo bwi nang, ke pwo beme e habwii a junuun wo Padué ne kon. ");
INSERT INTO cam_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","He mwo pwang, ke wâé heme genye pwo ni penem de pana e neéo bé. Be, me e tuie a bwén, ke te tice paceli jan me e penem. ");
INSERT INTO cam_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","He mwo woéo pwo bwohemwo, ke woéo pa pwéélang pwo bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","E caa pii anaa wo Iésu, ke e cumi ole pwo bwohemwo, ke é ko a cumihen, ke e pwo me titi a pule, ke e pé ke e ne ko ni naamii pali bwi. ");
INSERT INTO cam_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ke e pii ten pie: «Go â puuko ne he tabe ne Siloé.» Siloé, a bwopiinen pie ‘pahedeeng’. Ke wo pali bwi, ke e â puu a pwahamiin. Ke me e mwojuia mwobé, ke e caa niê ehi. ");
INSERT INTO cam_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Pa apulie naa, ke pa a-ile. Ke lé pitahimwolé ne ni apulie na lé alieng ânebun me ni béén pie: «He woo paje? He time uce wo pali bwi li e mu tee tebwo, ke e ile?» ");
INSERT INTO cam_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ke lé pii wo lépwo béén pie: «Éa, weeng.» Kehe lé pii ne ni béén pie: «Ûhu! Time uce weeng. Kehe pana te ju pwohewiieng.» É nelang, ke e pii telé pie: «Te woéo.» ");
INSERT INTO cam_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ke lé tahimwoeng ne ni apulie pie: «Go woté ko ace bwopwonen me go niê?» ");
INSERT INTO cam_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ke e hegi ne telé pie: «Wo pa apulie na pii kon pie Iésu, ke e pé a hepule, ke e ne ko ni naamiing, ke e pii tong pie me é â puuéo ne he tabe ne Siloé. Ke é ân ke é puuéo, ke é caa niê!» ");
INSERT INTO cam_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ke lé tahimwoeng pie: «He e wé naa wo pa apulie naa?» Ke e hegi ne telé pie: «Time é uce temehi.» ");
INSERT INTO cam_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Lé pé pali bwi nge céii ni *Farasaio. ");
INSERT INTO cam_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","A tan na e pé a hepule hen wo Iésu ke e pwo me e niê wo pali bwi, ke é ha a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ke lé uce tahimwo pali apulie ne ni Farasaio pie: «Go caa niê jenaa? He ade aceli e pwo tem?» Ke e pii telé pie: «E ne ko lupwo naamiing ni hepule, ke é â puuéo, ke é jenaa, ke é caa niê.» ");
INSERT INTO cam_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ke lé pii ne ni béélé pie: «Time e uce âbé mu ko Padué wo pana e pwo anaa, be time e uce paciitihi a tan iitihi!» Kehe lé pii ne ni béén pie: «Wo pace apulie celi pwo ce ta pwo ten, ke pwocoon me e pwo ace inenaado celi pwojunuun celi wonaa.» Ke time lé uce piténelé wo lépwo Farasaio. ");
INSERT INTO cam_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ke lé tahimwo mwo pali bwi pie: «Wogo, ke he ade aceli go pii ne ko pana e pwo me go niê?» Ke e hegi ne telé pie: «Pa péroféta.» ");
INSERT INTO cam_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Kehe time uce nimelé me lé céihi pie bwi nang ânebun, ke é jenaa ke e caa niê ehi. Ke lé tode lu nyaa me caa ten, ");
INSERT INTO cam_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ke lé tahimwolu pie: «Wo paje, ke he te pa naîu? Ke geu pii pie bwi nang, he e mwo âbeele? É jenaa, ke e caa niê. He ade aceli e tuie ne kon?» ");
INSERT INTO cam_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Lu nyaa me caa ten, ke lu hegi pie: «Gemu temehi pie te pa naîmu, ke e âbeele he te bwi nang. ");
INSERT INTO cam_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ke é jenaa, ke e caa niê. Kehe time gemu uce temehi aceli e tuie ne kon. Ke time gemu uce temehi pie he woo paceli e pwo me e niê. Geé te tahimwoeng, be caa te ubwo nang! Ke e o te hegi ne tewé!» ");
INSERT INTO cam_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Lu pii pie wonaa wo lu nyaa me caa ten, be mwotilu ko ni apihuô juif. Be lé caa mi pii pie, hemepie lé pii pie wo Iésu, ke pa *Mesia, ke lé o pawielé mu ha a *mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","É mu ko anaa, ke lu pii wo lu nyaa me caa ten pie: «Caa te ubwo nang! Ke geé te tahimwoeng!» ");
INSERT INTO cam_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ke lé tode mwo pali bwi ne ni Farasaio a béokelohen, ke lé pii ten pie: «Go pii a juuju ne he pwahamii Padué! Geme te temehi pie, pana e pwo me go niê, ke pa apulie na ta nang.» ");
INSERT INTO cam_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ke e hegi ne telé pie: «Time é uce temehi pie pace apulie celi ta nang. Te céiu ana é temehi pie, bwi jo, ke é jenaa, ke é caa niê.» ");
INSERT INTO cam_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ke lé tahimwoeng mwo pie: «He ade aceli e pwo tem? He e woté ko ace bwopwonen me go niê?» ");
INSERT INTO cam_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ke e hegi ne telé pie: «É caa pii tewé, ke time geé uce tabemiéo. Kona nimewé me geé téne mwo kona woté? Me geé pipwoeabwé te Iésu mwo, wogewé?» ");
INSERT INTO cam_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ke lé pipiitaeng, ke lé pii ten pie: «Te wogo pa eabwé te pa apulie naa! Wogeme, ke ni eabwé te *Moosé! ");
INSERT INTO cam_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Wogeme, ke geme temehi pie e cihe ne ko Moosé wo Padué, kehe wo panaa, ke time geme uce temehi pie e âbé mu wé!» ");
INSERT INTO cam_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ke e pii telé wo pali bwi pie: «Te ité! Be e pwo me é niê, kehe icehi ana wogewé, ke time geé uce temehi he celi e âbé mulang! ");
INSERT INTO cam_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Genye te temehi pie wo Padué, ke time e uce pitabemi nina ta jélé, kehe e te pitabemi pana e ténedeeng, ke e pwo nina e pii. ");
INSERT INTO cam_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Time genye uce téele téne pie, pwo pace apulie celi e pwo me e niê wo paceli bwi nang tabuhi ha a bwo âbeele ten. ");
INSERT INTO cam_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Hemepie time e uce âbé mu ko Padué, ke o time uce jan ne kon me e pwo aceli wonaa.» ");
INSERT INTO cam_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ke lé hegi ne ten pie: «Wogo, na go âbeele ne ha a ta, ke nimem me go pacémunikeme?» Ke lé neeng wie. ");
INSERT INTO cam_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ke e téne wo Iésu pie lé pawie pali bwi. Ke e â tooeng, ke e pii ten pie: «He go te céihi ne ko pa Nahi Apulie?» ");
INSERT INTO cam_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ke e hegi ne ten wo pali apulie pie: «Pa apipune, he woo panaa, beme é céihi ne kon?» ");
INSERT INTO cam_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ke e pii ten wo Iésu pie: «Go caa alieng jenaa, be weeng na e ko cihe tem.» ");
INSERT INTO cam_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ke e pii ten wo pali apulie pie: «Padaame, é céihi.» Ke e tidihi jilin he pwahamii Iésu. ");
INSERT INTO cam_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ke e pii wo Iésu pie: «É tuie ne pwo bwohemwo beme lé niê ne ni bwi, ke me bwi nina lé niê. Weengaa a tautinaado.» ");
INSERT INTO cam_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","É he lé téne anaa ne ni béé Farasaio na lé mu lang, ke lé tahimwoeng pie: «He bwi geme mwo?» ");
INSERT INTO cam_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ke e hegi ne telé wo Iésu pie: «Hemepie bwi gewé, ke o te tice ta pwo tewé. É jenaa, ke geé pii pie: “Geme caa niê.” É mu ko anaa, ke geé o te mu he ni ta pwo tewé.» ");
INSERT INTO cam_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","E pii mwo wo Iésu pie: «É pii tewé a juuju pie: Wo pana e taa pwo a goomwa babé te ni muto, ke me time e uce taa ha a pomwa kon, ke wo panaa, ke pa abune, ke pa apulie ta. ");
INSERT INTO cam_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kehe wo pana e taa ha a pomwa, ke pa ju awéihi muto. ");
INSERT INTO cam_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ke e tehi ne ten a pomwa wo pa awéihi nen. Ke lé téne temehi a patin ne ni muto, he e toii ni niilé, ke e péélé wie. ");
INSERT INTO cam_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ke me e caa tai pawielé, ke e engen ânebuhelé. Ke lé âcéin, be lé téne temehi a patin. ");
INSERT INTO cam_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Time lé uce âcéi pace céiu apulie, kehe lé o cela kon, be time lé uce téne temehi ni pati ni béé apulie.» ");
INSERT INTO cam_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ke wo lépwona lé téne a ocine naa, ke time lé uce temehi aceli nimen me e pii telé. ");
INSERT INTO cam_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ke e pii mwo telé wo Iésu pie: «Éa, é pii tewé a juuju pie: *Woéo pa pomwa te ni muto. ");
INSERT INTO cam_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Wo lépwona lé âbé ânebuhung, ke ni abune, ke ni apulie ta. Ke ni muto, ke time lé uce ténedelé. ");
INSERT INTO cam_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Woéo pa pomwa. Wo paceli e taabé kong, ke o celuimieng. Ke e o taa ke e o wie, ke e o te tooli ce wiinaado ten. ");
INSERT INTO cam_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","«Wo pa abune, ke e te ju âbé beme e bune, ke me e taunuhi, ke pwotahi. Kehe woéo, ke é âbé me é pamulipi ni apulip, ke me hején a mulihelé.» ");
INSERT INTO cam_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«Woéo pa ju awéihi muto. Ke pa ju awéihi muto, ke e patupwo a mulihen me delé. ");
INSERT INTO cam_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wo pana e cile muto me pwocuhieng, ke time uce pa ju awéihi muto, be time uce ni muto ten. Ke me e alihi a wota apiwii, ke e necu ni muto, ke e cela. Ke ali wota apiwii, ke e pé ni muto, ke e pwo me lé pipiiden ne ni béén. ");
INSERT INTO cam_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ke e cela wo pana e penem me pwocuhieng, be time e uce cile ehi ni muto.» ");
INSERT INTO cam_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","«Woéo, ke pa ju awéihi muto, ke é te temehi ni muto tong, ke lé te temehiéo. ");
INSERT INTO cam_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Pwohewii a bwo temehiéo te Caa, ke a bwo temehi Caa tong. Ke é patupwo a mulihung me delé. ");
INSERT INTO cam_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mwo te pwo ni béé muto tong na mwo tielé ha a babé. Woélé mwo, ke me é péélé bé. Ke lé o téne a pating, ke o te céiu a pubuulé, ke o te céiu pa awéilé. ");
INSERT INTO cam_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","«Eânime Caa tong, be é patupwo a mulihung, beme é bo hegi mwo. ");
INSERT INTO cam_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Te tice paceli e o pé a mulihung, kehe é te ne mu kong. Etong me é ne, ke etong me é pé mwo. A pihuô naa, ke é hegi mu ko Caa.» ");
INSERT INTO cam_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ke time lé uce piténelé mwo ne ni Juif mu ko ni pwooti te Iésu. ");
INSERT INTO cam_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Be hiwon ni béén mu kolé na lé pii pie: «Pwo ace jenenaado kon! Pihauli nang! É mu ko ade na geé tabemieng?» ");
INSERT INTO cam_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Kehe lé pii ne ni béén pie: «Mepie e kon ace jenenaado, ke time e o uce wonaa ko ace bwo cihe ten. Kona a duéé, ke o te jan me e tehi ni naamii ni bwi?» ");
INSERT INTO cam_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","É ha a benaamwon ko ta-amu, é ne *Iérusaléma, ke a *pipwodéén ko a bwo tehi ne mwo a *mwaiitihi. ");
INSERT INTO cam_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ke e mu lang wo Iésu, ke e âdé ke âbé ha a mwaiitihi, ne ha a ‘Mwa te Solomona’. ");
INSERT INTO cam_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ke lé pitaineibulé ne ko Iésu ne ni Juif, ke lé pii ten pie: «He go pwo me geme ucéiko dieli éniile? Mepie wogo pa *Mesia, ke go pii ehi teme!» ");
INSERT INTO cam_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ke e hegi ne telé wo Iésu pie: «É caa pii tewé, kehe time geé uce céihi ne ko ana é pii. Ke lé pajuujuéo mwo ni penem na é pwo mu ko Caa. ");
INSERT INTO cam_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ke time geé uce céihi, be time uce wogewé ni muto tong.» ");
INSERT INTO cam_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","«Lé téne temehi a pating ne ni muto tong. Ke é temehilé, ke lé âbé céing. ");
INSERT INTO cam_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ke é ne telé a mulip ne pele Padué dieli mwo. Time lé uce mele, ke te tice paceli e bo péélé mu ha a naatiing. ");
INSERT INTO cam_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Be wo Caa na e nelé tong, ke e daaité koja ati ni naado. Ke o te tice paceli e o péélé mu ha a naatii Caa. ");
INSERT INTO cam_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Wogemu me Caa, ke te céiu gemu.» ");
INSERT INTO cam_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ke lé pé mwo ni péi ne ni Juif, beme lé taunueng. ");
INSERT INTO cam_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ke e pii telé pie: «Hiwon ni naado na wâé na é pwo mu ko Caa, ne he pwahamiiwé. Ke he ade mu he nina é pwo, celi nimewé me geé taunuéo kon?» ");
INSERT INTO cam_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ke lé hegi ne ten pie: «Time uce é mu ko ace naado celi wâé celi go pwo, na nimeme me geme taunuko, kehe é mu ko ana go cihe me ta ne ko Padué. Kehe wogo, ke pa apulie, ke nimem me go pwo me wogo Padué!» ");
INSERT INTO cam_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ke e pii telé wo Iésu pie: «Caa tii ne he ni patén dewé pie, e pii wo Padué pie: Wogewé, ke ni naî Padué! ");
INSERT INTO cam_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ke pwocoon me tili taabwon ana tii ne he ni tii iitihi. Hemepie e toii ko ni apulie pie naî Padué, ");
INSERT INTO cam_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ke é ko ade na geé pii pie é picihe hauli ne ko Padué me é pii pie, woéo pa Naîn? Be wo Caa na e pipégaliéo, ke e pahedeéo bé ne pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","«Mepie time é uce pwo ni penem na e ne tong wo Caa, ke geé nemwo céihi ne kong! ");
INSERT INTO cam_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Kehe icehi ana mepie é pwo, ke wâé heme geé céihi. Be mepie pwocoon ne kowé me geé céihi ne kong, ke geé céihi ne kong mu ko ni naado na é pwo. Beme geé téne temehi pie e kong wo Caa, ke woéo, ke é mu ko Caa.» ");
INSERT INTO cam_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ke lé hane mwo me lé imwi Iésu, kehe pwocoon ne kolé. ");
INSERT INTO cam_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ke e engen wo Iésu, ke e mwojuia ngemwo ko a céiu goo a éémwa Ioridano, he na e mi *puu apulie nelang wo Ioane. Ke e mu lang. ");
INSERT INTO cam_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Hiwon ni apulie na lé âbé tooeng, ke lé pipii telé pie: «Te tice inenaado celi pwojunuun celi e pwo wo Ioane, kehe te ni juuju ati nina e pii ne ko Iésu.» ");
INSERT INTO cam_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","É nelang, ke hiwon ni apulie na lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Pwo pa céiu apulie na cunu nang, na pii kon pie Lazare. E mu Bétani, a mwopopwaalé te Maria me ê béén Marte. ");
INSERT INTO cam_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Wo Maria, ke êgi toomwo li e céihi ne pwo ni a Padaame a tabe ûde, ke e tahi ko ni apunin. Ke ê iiti Lazare, pali cunu nang. ");
INSERT INTO cam_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lu ténaâjién, ke lu pahede pa céiu apulie, me e â pii te Iésu pie: «Padaame, pali eânimem den, ke cunu nang.» ");
INSERT INTO cam_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Me e téne anaa wo Iésu, ke e pii pie: «A cunu na e ko Lazare, ke time e o uce metihi, kehe a bwopwonen me e habwii a junuun wo Padué. Be é mu ko anaa, ke lé o alihi a junuu pa Naîn.» ");
INSERT INTO cam_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Junihe eânimen de Marte me ê béén, ke wo Lazare. ");
INSERT INTO cam_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","He e téne pie cunu Lazare, ke e mwo mu lang he na alo ni tan. ");
INSERT INTO cam_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ke é alecehen, ke e pii te ni acémun den pie: «Genye âmwo *Judé.» ");
INSERT INTO cam_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ke lé pii ten ne ni acémun den pie: «Pa apipune, ha ali céiu tan, ke lé haneko ne ni *Juif na lé mu lang, beme lé ahiko ko péi me lé taunuko. Ke nimem me go mwojuia ngemwo lang?» ");
INSERT INTO cam_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ke e hegi ne telé wo Iésu pie: «Ha a tan, ke 12 ni inetéale. Hemepie genye engen heme pwang, ke time genye uce tupwo, be te pwéélang he na genye â lang. ");
INSERT INTO cam_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kehe mepie genye engen he bwén, ke genye o tupwo, be time uce e konye a pwéélang.» ");
INSERT INTO cam_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ke e pii mwo wo Iésu pie: «E caa puluta wo pa béénye Lazare, kehe é o â paûmiêeng.» ");
INSERT INTO cam_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Lé pii ten ne ni acémun den pie: «Padaame, mepie e puluta, ke o wâé nang!» ");
INSERT INTO cam_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Nime Iésu me e pii pie, e caa mele, kehe lé niimihi ne ni acémun den pie, e teko ju pule. ");
INSERT INTO cam_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ke e pii telé ehi pie: «E caa mele. ");
INSERT INTO cam_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Time é uce mu lang, kehe é pipwodéén. Wonaa mu kowé, beme geé céihi ne kong. Kehe genye â pele Lazare!» ");
INSERT INTO cam_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ke wo Toma, pana pii kon mwo pie ‘pa Péidu’, ke e pii te ni béé acémun pie: «Genye tai ân, beme genye tai mele me Iésu!» ");
INSERT INTO cam_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ke é he e tehene ngen wo Iésu, ke e téne pie caa paa ni tan na lé ne Lazare ha a mwa péi. ");
INSERT INTO cam_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bétani, ke é mwonuhi *Iérusaléma, he na cié ni kilomètre ngelang. ");
INSERT INTO cam_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","É mu ko anaa, ke hiwon ni Juif na lé âbé too Marte me Maria, beme lé tuie ne kolu ko a bwo mele te Lazare. ");
INSERT INTO cam_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","E téne wo Marte pie e tuie wo Iésu, ke e âbé beniieng. Kehe wo Maria, ke e te mu pwomwo. ");
INSERT INTO cam_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ke e pii wo Marte te Iésu pie: «Hemepie teko wogo éni, ke me time e o uce mele wo pa iitiéo. ");
INSERT INTO cam_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Kehe é ha a benaamwon ce, ke é te temehi pie tai ni naado na go ilehi koja Padué, ke e o te tai ne tem ati.» ");
INSERT INTO cam_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ke e pii ten wo Iésu pie: «Pa iitiko, ke e o mulie cemwo mu ha amele.» ");
INSERT INTO cam_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","E hegi ne ten wo Marte pie: «É te temehi pie e o mulie cemwo hemepie lé o mulie cemwo ne ni amele ha a *Tan Alece.» ");
INSERT INTO cam_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ke e pii ten wo Iésu pie: «*Woéo pa mulie cemwo ke pa mulip. Wo pana e céihi ne kong, ke eten a mulie, te piwien hemepie e caa mele. ");
INSERT INTO cam_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ke tai nina lé mulie heme lé céihi ne kong, ke time lé o uce mele. Go te céihi ne ko anaa?» ");
INSERT INTO cam_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ke e pii ten wo Marte pie: «Éa, go Padaame! É céihi pie wogo, ke pa *Mesia, pa *Naî Padué na me e âbé ne pwo a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","He e caa pii anaa wo Marte, ke e â tode ê ciéén, Maria, ke e pii ten pie: «E éni wo Padaame, kehe e todeko.» ");
INSERT INTO cam_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","He e téne anaa wo Maria, ke e te caama kuti ke e â too Iésu. ");
INSERT INTO cam_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Be time e uce téele taa ha a mwopopwaalé, kehe mwo te é he na e tooeng lang wo Marte. ");
INSERT INTO cam_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ni Juif na lé âbé tuie ne ko Maria ne ha a pomwa ten, ke lé alieng he e te caama kuti ke e â wie. Ke lé âcéin, be lé niimihi pie e â é, he iitihi. ");
INSERT INTO cam_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Me e tehene nge ha a duaan na e mu hen wo Iésu, ke e tidihi jilin ko an, ke e pii ten pie: «Padaame, mepie te wogo éni, ke me time e o uce mele wo pa iitiéo!» ");
INSERT INTO cam_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ke me e alieng wo Iésu he e é me ni Juif na lé âbé céin, ke te nihe penem a pwonimen, ke piwahin nang. ");
INSERT INTO cam_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ke e tahimwolé pie: «He geé neduwoeng wé?» Ke lé pii ten pie: «Padaame, go âbé ke go bo alihi.» ");
INSERT INTO cam_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ke e é wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ke lé pii ne ni Juif pie: «Geé alihi, be te junihe eânimen den!» ");
INSERT INTO cam_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ke lé pii ne ni béén pie: «Weeng pana e tehi ni naamii pa bwi. Kona pwocoon me e pwo me time e uce mele wo Lazare?» ");
INSERT INTO cam_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ke te nihe penem a pwonime Iésu. Ke e â ko a bwomu, a mwa péi na capuhi ko a pilehe péi. ");
INSERT INTO cam_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ke e pii pie: «Geé pétaabwon a péi!» Kehe wo Marte, ê iiti pali e caa mele, ke e pii ten pie: «Padaame, caa ûde nang, be caa paa ni tan na e lang.» ");
INSERT INTO cam_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ke e pii ten wo Iésu pie: «É caa pii tem pie, mepie go céihi, ke go o alihi a bwo ubwo na a wâé te Padué.» ");
INSERT INTO cam_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ke lé pétaabwon ali péi. Ke e eti ni naamiin wo Iésu, ke e pii pie: «Caa, é olééhi ne tem, be go téneéo. ");
INSERT INTO cam_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ke woéo, ke é te temehi pie go te téneéo. Kehe é cihe, beme lé céihi ne ni apulie na élé aujeniéo pie, wogo na go pahedeéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ke é alecehe anaa, ke e cihe da ko miiden, ke e pii pie: «Lazare, go wie mulang!» ");
INSERT INTO cam_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ke e wie wo pali amele! Ni an me ni in, ke cie ko ni mwaanu. Ke a pwahamiin, ke tawii mwo ko a mwaanu. Ke e pii telé wo Iésu pie: «Geé tuwo mu kon nina lé cieeng kon, ke neeng me e engen.» ");
INSERT INTO cam_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Hiwon ni Juif na lé â pele Maria, ke lé alihi nina e pwo wo Iésu, ke lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kehe ni béén, ke lé â too ni *Farasaio, ke lé uti telé nina e pwo wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ke lé taineibuhi a *mwohuô wo lépwo caa te lépwo *apwoâpwailo me ni Farasaio, ke lé pii pie: «He ade aceli genye o pwo? Be hiwon ni *inenaado na pwojunuun na e pwo wo pa apulie ce. ");
INSERT INTO cam_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","«Hemepie genye te neeng me e pwo, ke lé o tai céihi ne kon ne ni apulie ati. Ke lé o âbé ni coda roma, ke lé o tanahi a *mwaiitihi tenye ke a bele tenye!» ");
INSERT INTO cam_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ha a jo naa, ke wo pa *daame he lépwo apwoâpwailo, na pii kon pie Kaïfe. Ke e pii telé pie: «Te tice aceli geé temehi? ");
INSERT INTO cam_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wâé hemepie e mele wo pana céiu nang me de a puapulie, beme time uce tanahi a amu ati. Ai, kona te time geé uce temehi anaa?» ");
INSERT INTO cam_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Time e uce âbé mu kon ni pwooti naa, be weeng, ke pa daame he lépwo apwoâpwailo ha a jo naa, ke e mi pii pie, e bo mele me de a bele juif wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Kehe time e uce pwo cehi me de a bele juif, kehe me e taineibuhi me céiu ni naî Padué na élé ati he ni piduaan ne pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ke tabuhi ha a tan naa, ke lé pitaineibulé ne ni apihuô juif, beme lé pwo me e mele wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","É mu ko anaa, ke caa time e uce âdé ke âbé he pwahamiilé wo Iésu. Kehe e engen mulang, ke e â ha a céiu duaan ko a melé, ne ha a céiu mwopopwaalé na pii kon pie Éfraïm. Ke e mu lang me ni acémun den. ");
INSERT INTO cam_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Caa e mwonu a tan ko *Pacika, a *pipwodéén de ni Juif, ke hiwon ni apulie na lé engen mu he ni amu telé, beme lé taa Iérusaléma ânebuhe a Pacika, beme lé pwo a *pwoiitihi ko a bwo wâé genye ne pele Padué, pwohewii a patén de ni Juif. ");
INSERT INTO cam_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Lé hane Iésu, ke lé pipii telé ne ha a mwaiitihi pie: «Geé niimihi pie woté? E o te âbé ne ko a pipwodéén?» ");
INSERT INTO cam_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ke ni caa te lépwo apwoâpwailo me ni Farasaio, ke lé huôhi pie, hemepie pwo pace apulie celi e temehi he celi e lang wo Iésu, ke me e âbé pii telé, beme lé imwieng. ");
INSERT INTO cam_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Mwo 6 ni tan ânebuhe a *Pacika, a *pipwodéén de lépwo *Juif, ke e tehene nge Bétani wo Iésu. Ke e mu pele Lazare, pali e pwo me e mulie cemwo wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ke lé tebwo pwo taap me ni béén, ko a wiinaado na lé caa mi piwâam kon. Ke wo Marte, ke e âdé ke âbé, beme e wéihi a taap. ");
INSERT INTO cam_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mepwo é ne ko Maria, ke e pé a mwotabe na oba† ko tabe ûde na te junihe ubwo a cuhin. Ke e céihi ne pwo ni a Iésu, ke e tahi ni an ko ni apunin. Ke te ju ûde wâé ha ali mwa. ");
INSERT INTO cam_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kehe time uce wâé te Judas Iscariot, pa céiu *acémun de Iésu, pali e bwo icueng. Ke e pii pie: ");
INSERT INTO cam_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Woté? É ko ade na time e uce icuhi a tabe ûde ce, ke me nye ne a mwani te nina tice delé? Be pwo million ko a cuhin!» ");
INSERT INTO cam_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Time e uce pii anaa hemepie eânimen de nina tice delé, kehe e wonaa be pa abune. Ke weeng na e cile a mwomwani telé, ke e mu pé mu kon. ");
INSERT INTO cam_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ke e pii wo Iésu pie: «Go neeng! Be e caa mi pwo anaa ne ko a tan na lé o bo neduwoéo hen. ");
INSERT INTO cam_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Be o tee élé pelewé wo lépwona tice delé, kehe woéo, ke time é o uce tee mu pelewé.» ");
INSERT INTO cam_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Hiwon ni Juif na lé téne pie e mu Bétani wo Iésu, ke lé âbé nelang. Time uce é mu kon cehi, kehe nimelé me lé ali mwo Lazare, pana e pwo me e mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kehe lé picihe wo lépwo caa te lépwo *apwoâpwailo, me lé taunu mwo Lazare. ");
INSERT INTO cam_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Be wonaa mu ko Lazare, me hiwon ni Juif na lé wie mu pelelé, ke lé céihi ne ko Iésu. ");
INSERT INTO cam_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ha acaama hen, ke hiwon ni apulie na lé âbé ne ko a pipwodéén ko a tan ko Pacika, be lé téne pie e taa *Iérusaléma wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ke lé pé ni madi alica, ke lé â beniieng, ke lé toii me ubwo pie: «Osana!Pipwoun de Padué! *Adéi pa apulie na e âbé ne he nii Padaame! Psaume 118.26 *Adéi Padaame he ni *Isaraéla!» ");
INSERT INTO cam_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ke e pé a nahi buriko wo Iésu, ke e tebwo huîin, pwohewii ana caa te tii ne he ni tii iitihi pie: ");
INSERT INTO cam_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Wogo ê nahi toomwo Sion, go nemwo pwo me mwotiko! Be e âbé wo Padaame hem, he e tebwo huîi a nahi buriko. Zakari 9.9 ");
INSERT INTO cam_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","É ha a benaamwon naa, ke time lé uce téele temehi ne ni acémun den celi e o tuie. Ke é he e caa mu ha *a wâé ten wo Iésu, ke lé bo piniimihi mwo pie ninaa, ke caa mi tii ne kon, ke lé bwo *pajuujuhi ne kon ana caa pii. ");
INSERT INTO cam_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tai nina lé mu pele Iésu he e tode Lazare me e wie mu ha a bwomuhen, ke e pwo me e mulie cemwo, ke lé â uti nina e pwo. ");
INSERT INTO cam_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","É mu ko anaa, na e âbé beniieng a pubu apulie, be lé téne pie e pwo a *pipwojunuun naa. ");
INSERT INTO cam_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lé pipii telé ne ni *Farasaio pie: «Geé te alihi, te tice aceli jan me genye pwo. Be tai ni apulie, ke lé tai âcéin!» ");
INSERT INTO cam_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Pwo ni apulie na time uce ni Juif na lé taa Iérusaléma ha a pipwodéén, beme lé pipaunu Padué. ");
INSERT INTO cam_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ke lé âbé too Filip, pa aâbé Betsaïda ne Galilé, ke lé pii ten pie: «Nimeme me geme ali Iésu.» ");
INSERT INTO cam_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ke e ân wo Filip, ke e pii te André, ke lu â pii te Iésu. ");
INSERT INTO cam_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ke e hegi ne telu wo Iésu, pie: «Caa tuie a benaamwon me pipaunu pa Nahi Apulie. ");
INSERT INTO cam_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","É pii tewé a juuju pie: Hemepie time e uce tupwo ne he pule a pide blé, ke me time e uce mele, ke e te mu cehi. Ke hemepie e mele, ke o hiwon ce acehin. ");
INSERT INTO cam_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","«Wo paceli eânimen ko a mulihen, ke e o patieden. Kehe wo paceli te nihe eânimen de Padué koja a mulihen ne éni pwo bwohemwo, ke eten a mulie na tice anebwén kon. ");
INSERT INTO cam_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","«Wo paceli nimen me e pipwoeabwé tong, ke e âbé céing. Ke é he na woéo lang, ke o e lang mwo wo pa eabwé tong. Ke wo Caa, ke e o bo ne a ceme ni penem den.» ");
INSERT INTO cam_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«É jenaa, ke téé a pwonimung, ke me é pii pie woté: “Caa, go neéo nge ité koja ni picani na e o tuie ne kong ha a benaamwon ce”? Kehe é mu ko anaa, na é âbé. ");
INSERT INTO cam_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","29","Caa, go habwii pie wogo Padué na ubwo go!» Ke ni apulie na lé mu lang, ke lé téne a pwocihe mu he miiden: «É caa te habwii a wâé tong, ke é o mwo te habwii mwo.» Ke lé niimihi ne ni béén pie a tikekele. Ke lé pii ne ni béén pie a *âcélo na e cihe ten. ");
INSERT INTO cam_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ke e pii telé wo Iésu pie: «Time e uce âbé a pwocihe naa me dong, kehe me dewé. ");
INSERT INTO cam_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","É jenaa, ke o pwo a tautinaado ne pwo a bwohemwo ce. É jenaa, ke e o tahi wie pa daame he a ta ne pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ke woéo, hemepie pineéo da mu pwo bwohemwo, ke é bo céibé ni apulie ati.» ");
INSERT INTO cam_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","É mu ko ni pwooti ten, ke e caa mi pii a bwo mele ten. ");
INSERT INTO cam_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ke lé hegi ne ten ne ni apulie pie: «Geme picaa ne he ni tii ko patén pie, pa *Mesia, ke e o *mulie dieli mwo. Kehe woté ace bwomunen me go pii pie, wâé heme ne da pa Nahi Apulie? He woo pa Nahi Apulie naa?» ");
INSERT INTO cam_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ke e pii telé wo Iésu pie: «A pwéélang, ke time uce bwolieng hadeniiwé. Geé engen he mwo e pelewé a pwéélang, beme time e cetéékewé na a melepiing. Be wo paceli e engen ha a melepiing, ke time e uce temehi he na e â lang. ");
INSERT INTO cam_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","He mwo ko wogewé ha a pwéélang, ke geé hegi a pwéélang, beme wogewé ni nahi a pwéélang.» Ke me e caa pii anaa wo Iésu, ke e â taduwo ité kojalé. ");
INSERT INTO cam_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Hiwon ni inenaado na e pwo ne he pwahamiilé, kehe time lé uce céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Caa pacuwohi a pwooti na e pii wo péroféta Isaia: Padaame, he woo paceli e céihi ne ko ni pwooti teme? He go habwii ne tee a junuum? Ésaïe 53.1 ");
INSERT INTO cam_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ke e pii wo Isaia a watihen me time lé uce céihi: ");
INSERT INTO cam_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","E pii wo Padué pie: É pwo me mwoiu ni punilé, beme time uce nimelé me lé alihi ko ni naamiilé, ke me lé temehi ko ni pwonimelé. Te muhi telé me lé bitelé bé céiiéo, ke me é o uce pwo me wâé jélé. Ésaïe 6.10 ");
INSERT INTO cam_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","E pii anaa wo Isaia be e caa mi alihi a junuu a wâé te Iésu, ke e cihe kon. ");
INSERT INTO cam_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ke é hadenii ni apihuô juif, ke hiwon nina lé céihi ne kon. Ke time lé uce pii pwaatihi, be mwotilé ko ni Farasaio. Be koli lé bo pawielé mu ha a *mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Be wâé telé a bwo pipaunulé te ni apulie, koja a bwo pipaunulé te Padué. ");
INSERT INTO cam_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ke e pii da me ubwo wo Iésu pie: «Wo pana e céihi ne kong, ke time e uce céihi ne kong cehi, kehe é ne mwo ko pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ke wo pana e aliéo, ke e ali mwo pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Woéo, ke pa pwéélang, na é âbé ne pwo bwohemwo, beme wo paceli e céihi ne kong, ke me time e o uce mu ha a melepiing. ");
INSERT INTO cam_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","«Hemepie pwo paceli e téne ni pwooti tong ke me time e uce piténedehi, ke time uce woéo na é tautieng. Be time é uce âbé me é tauti a bwohemwo, kehe me é *celuimi a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","«Wo pana muhi ten kong, ke me time e uce hegi ni pwooti tong, ke o bo tautieng. A pwooti na é toii, ke e bo te tautieng ha a *Tan Alece. ");
INSERT INTO cam_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Be time é uce cihe mu ko ace bwo niimihi nen dong, kehe wo Caa na e neéo bé, ke e pii tong ati nina me é pii ke me é patemehi. ");
INSERT INTO cam_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ke é temehi pie, a pihuô ten, ke a mulie dieli mwo. Nina é toii, ke é patemehi pwohewii ana e pii tong wo Caa.» ");
INSERT INTO cam_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ânebuhe a *pipwodéén ko a *Pacika, ke e temehi wo Iésu pie, e caa tuie a benaamwon den: Me e engen mu pwo a bwohemwo me e taa too Caa. Ke te nihe ubwo a pwonimen ko ni ju béén, mu ha atabuhi kon die ha a pwonehin. ");
INSERT INTO cam_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","É he babwén, he lé wiinaado me ni acémun den, ke wo Caatana, ke e caa ne ha a pwonime Judas Iscariot, pa naî Simon, a bwo niimihinaado pie, me e icu Iésu. ");
INSERT INTO cam_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Wo Iésu, ke e te temehi pie, e caa ne ten me e pihuôhi ati ni naado wo Caa, e âbé mu ko Padué, ke e o te mwojuia ngemwo céii Padué. ");
INSERT INTO cam_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ke e caama mu pwo taap, ke e céi a céiu epwénen, ke e pé a mwaanu, ke e cieeng kon. ");
INSERT INTO cam_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ke e tapulicéihi a tabe ne ha a tam ubwo, ke e puu ni a ni acémun den. Ke e tahi ko a mwaanu na e cieeng kon. ");
INSERT INTO cam_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Me e tuie nge ko Simon Pétéru, ke e pii ten wo Pétéru pie: «He wogo Padaame, na me go puu ni ang?» ");
INSERT INTO cam_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ke e hegi ne ten wo Iésu pie: «Ana é pwo jenaa, ke time go uce téele temehi. Kehe go bo te temehi.» ");
INSERT INTO cam_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ke e pii ten wo Pétéru pie: «Ûhu! Time go o uce puu ni ang!» Ke e hegi ne ten wo Iésu pie: «Hemepie time é uce puu ni am, ke o te tice dem mu kong.» ");
INSERT INTO cam_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ke e pii ten wo Simon Pétéru pie: «Time uce ni ang cehi, go Padaame, kehe ni ing mwo me a puning!» ");
INSERT INTO cam_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ke e pii ten wo Iésu pie: «Wo pana e caa puu ati a één, ke caa tice tooli kon. Ke te ju puu cehi ni an. Caa tice tooli kowé, kehe time uce tai wogewé ati.» ");
INSERT INTO cam_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Be e caa te temehi pana e bo icueng. Weengaa a watihen me e pii pie: «Time uce tai wogewé ati.» ");
INSERT INTO cam_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Alecehe a bwo puu ne ni alé, ke e cuwo mwo ha a epwénen, ke e âmwo tebwo pwo taap, ke e pii telé pie: «Geé te temehi ana é pwo tewé? ");
INSERT INTO cam_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Geé toii kong pie pa apipune tewé ke pa daame hewé. Éa, geé te ju pii ehi, be woéo. ");
INSERT INTO cam_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","É puu ni awé, woéo pa apipune tewé ke pa daame hewé. Wogewé mwo, ke geé pipuu ni awé. ");
INSERT INTO cam_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Be é caa habwii tewé beme geé bo pwo, pwohewii ana é pwo tewé. ");
INSERT INTO cam_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","É pii tewé a juuju pie: Wo pa apenem, ke time uce ubwo nang koja pa daame hen. Ke pa *apostolo, ke time uce ubwo nang koja pana e pahedeeng bé. ");
INSERT INTO cam_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","«Hemepie geé temehi ninaa, ke o adéikewé, hemepie geé pwo.» ");
INSERT INTO cam_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«Time é uce pii anaa ne kowé ati. É te temehi nina é pipégalilé. Kehe wâé heme e cuwo nina caa tii: Wo pana gemu piwiinaado ibu me weeng, ke weeng pana e o icuéo. ");
INSERT INTO cam_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«É mi pii tewé anaa jenaa, ânebuhe ace bwo tuie nen, be mepie e bo tuie, ke geé céihi pie, ‘Woéo ânebun, ke é jenaa, ke é dieli mwo’. ");
INSERT INTO cam_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","É pii tewé a juuju pie: Wo paceli e hegi pana é neeng lé, ke e hegiéo. Ke wo pana e hegiéo, ke e hegi mwo pana e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","He e caa pii ni pwooti naa wo Iésu, ke e téne he abwobwo a pwonimen, ke e pii telé pie: «É pii tewé a juuju pie: E bo pi-icuéo wo pa céiu bééwé.» ");
INSERT INTO cam_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ke lé piomelé wo lépwo acémun den, be time lé uce temehi pie he e pii ne koo. ");
INSERT INTO cam_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wo pa acémun den, na nihe eânime Iésu ten, ke e tebwo pwo taap, cebwo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ke e pwo inenaado ten wo Simon Pétéru me e tahimwohi pie he e ko cihe koo wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Pa acémun den naa, ke e pioole nge céii Iésu, ke e tahimwoeng pie: «Padaame, he wooélé?» ");
INSERT INTO cam_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ke e hegi ne ten wo Iésu pie: «Wo pana é o bo ne ten a mepwoloa na é pate.» Ke e pate a mepwoloa, ke e ne te Judas, pa naî Simon Iscariot. ");
INSERT INTO cam_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ke me e te pé kuti ali mepwoloa wo Judas me e eni, ke e te taa he pwonimen kuti wo Caatana. Ke e pii ten wo Iésu pie: «Go epin ko pwo aceli me go pwo!» ");
INSERT INTO cam_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Te tice pace béélé ne pwo taap celi e temehi pie he e pii ten anaa be woté. ");
INSERT INTO cam_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Be lé niimihi pie e pii ten, me e pwocuhi nina nimelé kon ne ko a pipwodéén, ai me e pati nina tice delé. Be pa acile mwani telé. ");
INSERT INTO cam_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","He e caa pé a mepwoloa wo Judas, ke e te â wie kuti, he caa melepiing. ");
INSERT INTO cam_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","32","É he e wie wo Judas, ke e pii telé wo Iésu pie: «É jenaa, ke o caa habwii a wâé te pa Nahi Apulie. Ke o paunu Padué, mu ko pa Naîn. Ke heme wonaa, ke wo Padué, ke e o paunu pa Naîn. Ke e o te ju téele pihabwii ne kon a bwo ubwo na a wâé ten.» ");
INSERT INTO cam_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","«Ni naîng, é mwo te mu pelewé ha ace cuwo nahi benaamwon. Geé bo haneéo, kehe é pii tewé jenaa nina é caa pii te ni apihuô juif pie: “Pwocoon me geé â he na é â lang.” ");
INSERT INTO cam_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","É ne tewé a patén na mwo coho: Geé pwo me pieânimewé tewé. Pwohewii a bwo eânimung dewé, ke wogewé mwo, ke geé pwo me pieânimewé tewé. ");
INSERT INTO cam_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Be me wonaa, ke lé bo temehi pie, wogewé, ke ni acémun dong, hemepie pieânimewé tewé.» ");
INSERT INTO cam_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ke e pii ten wo Simon Pétéru pie: «Padaame, he go â wé?» Ke e hegi ne ten wo Iésu pie: «He na é â lang, ke pwocoon me go âbé céing jenaa. Kehe go bo âbé céing ha ace céiu tan.» ");
INSERT INTO cam_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ke e pii ten wo Pétéru pie: «Padaame, he ade aceli pwocoon ne kong me é âdé céim jenaa? Te jan me é mele me dem jenaa!» ");
INSERT INTO cam_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ke e hegi ne ten wo Iésu pie: «He o te jan me go mele me dong? É pii tem a juuju pie: Ânebuhe a bwo to te a ja, ke o caa ocié go ko piwotétaa kong pie, time go uce temehiéo.» ");
INSERT INTO cam_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«Geé nemwo pwo me pinekepé ni pwonimewé. Geé céihi ne ko Padué, ke geé céihi ne mwo kong. ");
INSERT INTO cam_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Hiwon ni pwomwo ne pele Caa. Hemepie time uce wonaa, ke time é o uce pii tewé pie, é â pwopweehi he celi geé bo mu lang. ");
INSERT INTO cam_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","«Ke mepie é caa pwopweehi he celi me geé bo mu lang, ke é bo âmwobé, ke é bo péékewé, beme geé mu pelong, ne he na é mu lang. ");
INSERT INTO cam_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Geé te temehi he na é â lang, be geé te temehi a pwaaden.» ");
INSERT INTO cam_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ke e pii ten wo Toma pie: «Padaame, time geme uce temehi he celi go â lang. Geme o woté ko ace bwo temehi na a pwaaden?» ");
INSERT INTO cam_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ke e pii ten wo Iésu pie: «Woéo, ke é pwaaden, ke é juuju, ke é mulip. Te tice paceli e â too Caa, hemepie time e uce mi âbé tooéo. ");
INSERT INTO cam_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Hemepie geé temehiéo, ke geé o te temehi mwo Caa tong. Ke é jenaa, ke geé caa temehieng, ke geé caa alieng.» ");
INSERT INTO cam_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ke e pii ten wo Filip pie: «Padaame, mepie go habwii teme Caa, ke caa te jan.» ");
INSERT INTO cam_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ke e pii ten wo Iésu pie: «Caa bwolihi na é mu pelewé, ke time go uce téele temehiéo, go Filip? Wo pana e aliéo, ke e ali Caa. É mu ko ade na go pii mwo tong, pie me é habwii Caa? ");
INSERT INTO cam_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","He time go uce céihi pie woéo ko Caa, ke wo Caa ke e kong? Ni pwooti na é pii tewé, ke time é uce pii mu kong. Te wo Caa na e mulie kong, ke e pwo ni penem. ");
INSERT INTO cam_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Geé céihi ne ko ana é pii pie: Woéo ko Caa, ke wo Caa, ke e kong. Ai geé céihi mu ko nina é pwo.» ");
INSERT INTO cam_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","«É pii tewé a juuju pie: Paceli e céihi ne kong, ke e o pwo mwo ni penem na é pwo. Ke e o bo pwo mwo celi nihe ubwo koja nina é pwo, be é caa âmwo pele Caa. ");
INSERT INTO cam_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tai nina geé bo ilehi ne he niing, ke é o bo pwo, beme a bwo pipaunu Caa, ke me habwii ne ko pa Naîn. ");
INSERT INTO cam_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Hemepie geé ilehi ace céiu naado ne he niing, ke é o bo pwo ne tewé.» ");
INSERT INTO cam_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Hemepie eânimewé tong, ke geé o ténedehi ni patén dong. ");
INSERT INTO cam_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ke woéo, ke é bo ile Caa, beme e bo ne tewé paceli e wéikewé, ke me e mu pelewé dieli mwo: ");
INSERT INTO cam_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","a *Jenen Iitihi na e *juuju. Pwocoon me lé hegieng ne pwo bwohemwo, be time lé alieng, ke time lé temehieng. Kehe wogewé, ke geé te temehieng be e pelewé, ke e kowé.» ");
INSERT INTO cam_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","«Time é uce nekewé me tice nyaa me caa tewé, kehe é bo âmwobé. ");
INSERT INTO cam_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Caa time uce bwolihi, ke ni apulie, ke o caa time lé uce aliéo. Kehe wogewé, ke geé bo te aliéo mwo, be é mulie, ke geé bo te mulie mwo. ");
INSERT INTO cam_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","É ha a tan naa, ke geé bo temehi pie woéo ko Caa, ke wogewé kong, ke woéo kowé. ");
INSERT INTO cam_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Wo pana e kon ni patén dong ke me e ténedehi, ke weeng pana eânimen dong. Wo pana eânimen dong, ke o eânime Caa ten. Ke woéo mwo, ke o eânimung den, ke é o bo pihabwiiéo ten.» ");
INSERT INTO cam_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ke e pii ten wo Jude (time uce Judas† Iscariot, kehe pa céiu) pie: «Padaame, go woté ko ace bwopwonen me go bo pipatemehiko ne teme, koja ni apulie pwo bwohemwo?» ");
INSERT INTO cam_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ke e hegi ne ten wo Iésu pie: «Hemepie eânime pace apulie tong, ke e o ténedehi a pwooti tong. Ke o eânime Caa ten, ke gemu bo âbé ne kon, ke gemu bo mu pelen. ");
INSERT INTO cam_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ke wo paceli time uce eânimen dong, ke me time e uce ténedehi a pwooti tong. Ke ni pwooti na é pii tewé, ke time e uce âbé mu kong, kehe e âbé mu ko Caa, na e neéo bé.» ");
INSERT INTO cam_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«É pii tewé ninaa, he é mwo teko mu pelewé. ");
INSERT INTO cam_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Pana e bo picani tewé, ke a Jenen Iitihi, na e neeng bé wo Padué ne he niing, ke e o pacémunikewé ko ni naado ati, ke e bo paniimihi tewé ati nina é caa pii. ");
INSERT INTO cam_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«É ne pelewé a péém, ke é ne tewé mwo a péém dong. Time é uce ne tewé pwohewii a bwo ne nen de a bwohemwo. Beme time uce pinekepé ni pwonimewé, ke me time uce mwotikewé. ");
INSERT INTO cam_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Geé caa téne ana é pii tewé pie: É o caa engen, kehe é bo mwojuia mwobé céiikewé. «Hemepie eânimewé tong, ke geé bo pipwodéén, be é â céii Caa! Be wo Caa tong, ke te nihe ubwo nang kojaéo. ");
INSERT INTO cam_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","É pii tewé ninaa jenaa, ânebuhe ace bwo tuie ne ni naado naa, be mepie lé bo tuie, ke me geé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Caa time é bo uce nihe cihe tewé mwo, be e o caa tuie wo pa daame he a ta ne pwo a bwohemwo. Kehe o te tice aceli jan me e pwo ne kong. ");
INSERT INTO cam_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ke ni apulie pwo bwohemwo, ke lé o bo temehi pie eânimung de Caa, ke é o pwo nina e patupwo ne tong me é pwo. «Geé caama, me genye engen mu éni!» ");
INSERT INTO cam_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Woéo, ke pa ju éé tabe megele, ke wo Caa tong, ke pa awéihi na a ni tabe megele. ");
INSERT INTO cam_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Tai ni dihen na lé mu kong na tice acehin, ke e pétaabwon. Ke ni dihen na pwo acehin, ke e pwopweehi kon, beme nihe aca. ");
INSERT INTO cam_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","«É jenaa, ke caa tice tooli kowé, wonaa mu ko a pwooti na é pii tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Geé mu kong, ke é o bo mu kowé. Be pwocoon me e aca na a dihe tabe megele, hemepie time uce paati ko a watihen. Ke o te wonaa ne mwo kowé, hemepie time geé uce mu kong. ");
INSERT INTO cam_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«Woéo, ke pa watihen, ke wogewé ni dihen. Wo paceli e mu kong, ke é o mu kon, ke o hiwon ni acehi ni penem den. Pwocoon me geé pwo ace céiu naado hemepie tieéo kowé. ");
INSERT INTO cam_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Hemepie pwo paceli time e uce mu kong, ke o tahieng wie, pwohewii ni dihe tabe megele na caa meiu. Ke genye tai, ke genye tahi ne pwo miû, beme éle.» ");
INSERT INTO cam_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","«Hemepie geé mu kong, ke me e mu kowé ni pwooti tong, ke celi geé o ilehi, ke é bo ne tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ke weengaa a bwo pipaunu Caa, hemepie hiwon ni acehi ni penem dewé. Ke me wonaa, ke geé habwii pie wogewé, ke ni acémun dong. ");
INSERT INTO cam_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«Pwohewii a bwo eânime Caa tong, woéo mwo, ke te eânimung mwo tewé. Geé mu ha a pipwoééhe tong. ");
INSERT INTO cam_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Hemepie geé ténedehi ni patén dong, ke geé mu ha a pipwoééhe tong, pwohewii a bwo piténedehi nen dong ni patén de Caa, ke é mu ha a pipwoééhe ten. ");
INSERT INTO cam_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","«É caa mi pii tewé ninaa, beme e mu kowé a pipwodéén dong, ke me hején a pipwodéén dewé.» ");
INSERT INTO cam_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","«Weengi a patén dong: Wâé heme pieânimewé tewé, pwohewii a bwo eânimung dewé. ");
INSERT INTO cam_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mepie e patieden a mulihen wo pace céiu apulie me de ni ju béén, ke a inen pie junihe ubwo a bwo eânimen delé. ");
INSERT INTO cam_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wogewé, ke ni bééng, hemepie geé pwo nina é pii tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Caa time é uce toii kowé pie ni apenem dong, be time e uce temehi wo pa apenem aceli e pwo wo pa daame hen. Kehe é caa toii kowé pie ni bééng, be é caa patemehi tewé nina é picaa mu ko Caa. ");
INSERT INTO cam_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Time uce wogewé na geé pipégaliéo, kehe woéo na é pipégalikewé. Ke é nekewé beme geé ân, ke me pwo ce acehi ni penem dewé. Ni acehi ni penem dewé naa, ke me o mu dieli mwo. Ke nina geé bo ilehi koja Caa ne he niing, ke e bo ne tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ana é pii tewé me geé pwo: Wâé heme pieânimewé tewé.» ");
INSERT INTO cam_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Hemepie e téétikewé na a bwohemwo, ke wâé heme geé temehi pie e mi téétiéo ânebuhewé. ");
INSERT INTO cam_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Hemepie wogewé ni béé a bwohemwo, ke o eânime a bwohemwo tewé, ke o wogewé mwo ni apulie ten. Kehe time geé uce béé a bwohemwo, be é caa pipégalikewé mu pwo a bwohemwo. Ke é mu ko anaa, na e téétikewé na a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Geé niimihi a pwooti na é caa pii tewé: Wo pa apenem, ke time uce ubwo nang koja pa daame hen. «Lé pwo nina ta ne kong, ke lé o te pwo tewé mwo. Me time lé uce ténedehi a pwooti tong, ke time lé o uce ténedehi mwo ni pwooti tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","«Ke lé o bo tai pwo tewé ati ninaa mu kong, be time lé uce temehi pana e neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Hemepie time é uce âbé, ke me time é uce cihe telé, ke o te tice ta pwo telé. Kehe é jenaa, ke caa te tice aceli me lé pii beme pineulé ko ni ta pwo telé. ");
INSERT INTO cam_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","«Pana e téétiéo, ke e te tééti mwo Caa tong. ");
INSERT INTO cam_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mepie time é uce pwo ne hadeniilé ni penem na te tice paceli jan me e pwo, ke me o te tice ta pwo telé. Kehe é jenaa, ke lé caa alihi, ke lé téétikemu me Caa, ");
INSERT INTO cam_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","beme e tuie ana tii ne he ni tii iitihi telé pie: Lé téétiéo he te tice watihen.» ");
INSERT INTO cam_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«Hemepie e bo tuie a *Jenen Iitihi, pana e bo picani tewé ne he nii Caa, a Jenen Iitihi na e juuju, na e bo âbé mu ko Caa, ke e bo âbé patemehiéo ne tewé. ");
INSERT INTO cam_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ke wogewé mwo, ke geé o bo patemehiéo, be geé caa mu pelong ha atabuhi kon.» ");
INSERT INTO cam_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«É pii tewé ninaa be me wonaa, ke me time geé uce patieden ni céihi tewé. ");
INSERT INTO cam_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Lé bo pawiekewé mu he ni *mwotapitihi. Ke o tuie a benaamwon na ni apulie, ke lé bo taunukewé, ke lé niimihi pie lé pipwoeabwé te Padué. ");
INSERT INTO cam_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wonaa ni bwopemilé, be time lé uce temehi Caa, ke time lé uce temehiéo. ");
INSERT INTO cam_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","É pii tewé ni pwooti naa, beme geé bo piniimihi nina é pii tewé, hemepie e bo tuie a tan naa.» «Time é uce mi pii tewé ni pwooti naa, he é mwo mu pelewé. ");
INSERT INTO cam_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","É jenaa, ke é caa âmwo pele pana e neéo bé, ke te tice paceli e tahimwoéo mu hadeniiwé pie: “Go â wé?” ");
INSERT INTO cam_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","«Ke piwahin ni pwonimewé ko ni pwooti na é pii tewé. ");
INSERT INTO cam_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Kehe é pii tewé a juuju pie: Wâé ne kowé hemepie é engen, be mepie time é uce engen, ke time e o uce tuie wo pana me e bo picani tewé. Kehe é engen, ke é bo neeng bé céiikewé.» ");
INSERT INTO cam_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","«Ke hemepie e bo âbé, ke e o patemehi ne te ni apulie pwo bwohemwo, a ta, ke a mwomwon, ke a tautinaado. ");
INSERT INTO cam_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Be lé pitalupe ne ha a ta, be time lé uce céihi ne kong. ");
INSERT INTO cam_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ke lé pitalupe ne ha a mwomwon, be é â pele Caa tong, ke time geé o bo uce aliéo mwo. ");
INSERT INTO cam_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ke lé pitalupe mwo ne ha a tautinaado, be caa tauti pa daame he a ta ne pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«Hiwon nina me é pii tewé mwo, kehe o mwo nihe pwocoon ne kowé jenaa. ");
INSERT INTO cam_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ke hemepie e bo tuie wo pa bépicani tewé, a *Jenen Iitihi na e *juuju, ke e o bo péékewé ne ha a juuju. Be time e o bo uce picihe mu kon, kehe e o bo pii nina e téne. Ke e o bo mi pii tewé nina o bo tuie. ");
INSERT INTO cam_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","E o bo habwii *a wâé tong, be e bo pé mu ko ni dong, ke e bo patemehi tewé. ");
INSERT INTO cam_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tai ni de Caa, ke te ni dong mwo. É mu ko anaa, na é pii pie: E pé mu ko ni dong, ke e bo patemehi tewé.» ");
INSERT INTO cam_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Mwo pwo a cuwo benaamwon na o caa time geé uce aliéo. Ke bo pwo mwo a benaamwon na geé bo aliéo mwo.» ");
INSERT INTO cam_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ke lé pipii telé ni béé acémun den pie: «Ade aceli nimen me e pii tenye? É mu ko ade na e pii pie: “Mwo pwo a cuwo benaamwon na o caa time geé uce aliéo, ke bo pwo mwo a benaamwon na geé bo aliéo mwo”, ke “É â pele Caa”? ");
INSERT INTO cam_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ke he a bwopiinen pie woté: “Mwo pwo a cuwo benaamwon”? Time nye uce temehi pie e cihe ko ace de.» ");
INSERT INTO cam_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ke e temehi wo Iésu pie nimelé me lé tahimwoeng, ke e pii telé pie: «Geé pitahimwokewé ko ana é pii pie: “Mwo pwo a cuwo benaamwon na o caa time geé bo uce aliéo, ke bo pwo mwo a benaamwon na geé bo aliéo mwo.” ");
INSERT INTO cam_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","É pii tewé a juuju pie: Geé bo é, ke geé bo mu ha a piwahin. Ke lé o bo pipwodéén ni apulie pwo bwohemwo. Geé bo mu ha a piwahin, kehe a piwahin naa, ke o bo taatééhi me a pipwodéén. ");
INSERT INTO cam_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","«Hemepie e picile ewa ê toomwo, ke e mu he ni picani, be caa a benaamwon na cunu nang hen. Ke hemepie e caa tuie a cuwo nahi ewa, ke e caa pineuhi a bwo cunu nang, é mu ko a pipwodéén ko a ewa na e âbeele. ");
INSERT INTO cam_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Wogewé mwo jenaa, ke mwo wogewé ha a piwahin, kehe é o bo tookewé mwo, ke o bo pipwodéén mwo ni pwonimewé. Te tice paceli jan me e pé kojakewé a pipwodéén naa.» ");
INSERT INTO cam_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","«É ha a tan naa, ke caa time geé uce tahimwoéo ko a céiu naado. É pii tewé a juuju pie: Tai nina geé bo ilehi koja Caa ne he niing, ke e bo ne tewé. ");
INSERT INTO cam_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Dieli jenaa, ke mwo te tice aceli geé ilehi ne he niing. Geé ilehi, beme geé o bo hegi, ke me hején a pipwodéén dewé.» ");
INSERT INTO cam_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«É cihe tewé ko ninaa ne he ocine. E âbé a benaamwon na time é bo uce cihe ne mwo kowé he ocine, kehe é o caa cihe pwaatihi tewé ko Caa. ");
INSERT INTO cam_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","É ha a tan naa, ke geé o ilehi ne he niing. «Ke time é uce pii tewé pie, é o bo pwoiitihi te Caa me dewé. ");
INSERT INTO cam_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Be eânime Caa tewé, be eânimewé tong, ke geé céihi pie é âbé mu ko Padué. ");
INSERT INTO cam_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","É wie mu ko Caa, ke é âbé ne pwo a bwohemwo. É jenaa, ke é ece a bwohemwo, ke é mwojuia ne mwo pele Caa.» ");
INSERT INTO cam_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ke lé pii ten ne ni acémun den pie: «Go te alihi, é jenaa, ke go cihe pwaatihi, ke time go uce cihe he ocine! ");
INSERT INTO cam_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","É jenaa, ke geme temehi pie go temehi ati ni naado, ke time uce junaado me geme tahimwoko be go te temehi ni âniimihinaado teme. É mu ko anaa, ke geme céihi pie, go âbé mu ko Padué.» ");
INSERT INTO cam_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ke e hegi ne telé wo Iésu pie: «He é jenaa na geé bwobe céihi? ");
INSERT INTO cam_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Weengi a benaamwon, ke e caa tuie. Geé o bo pipiiden ne he ni piduaan, ke geé o bo neéo cehi. Kehe time uce woéo cehi, be te e pelong wo Caa. ");
INSERT INTO cam_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","É caa pii tewé anaa, beme e kowé a péém mu kong. Geé o bo mu he ni picani ne pwo a bwohemwo. Kehe geé mwoiu, be woéo, ke é caa piwéden koja a bwohemwo!» ");
INSERT INTO cam_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Alecehe ni pwooti naa, ke e eti ni naamiin wo Iésu, ke e pii pie: «Caa, a benaamwon, ke caa tuie. Go habwii *a wâé te pa Naîm, beme e habwii a wâé tem wo pa Naîm. ");
INSERT INTO cam_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Go caa ne ten a pihuô ne ko ni apulie ati, beme e ne a mulie na tice anebwén kon ne te nina go nelé ten. ");
INSERT INTO cam_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Be a mulie na tice anebwén kon, ke me lé temehiko, wogo Padué na go juuju, ke pana go nebé, Iésu Kériso. ");
INSERT INTO cam_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","«É habwii a wâé tem ne pwo a bwohemwo, ke é panebwénihi ana go ne tong me é pwo. ");
INSERT INTO cam_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Caa, é jenaa, ke go habwii a wâé tong ne pelem: a wâé na go caa ne tong, he mwo te tieden a bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«É patemehiko ne te ni apulie na go nelé tong ne pwo bwohemwo: te ni apulie tem, ke he go caa nelé tong. Lé caa te ténedehi ni pwooti tem. ");
INSERT INTO cam_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ke é jenaa, ke lé caa te temehi pie, tai ni naado na go ne tong, ke e te tai âbé mu kom. ");
INSERT INTO cam_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Be é caa ne telé ni pwooti na go ne tong, ke lé caa hegi. Be lé caa te temehi pie é âbé mu kom, ke lé caa céihi pie wogo na go neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","«É ne kolé na é pwoiitihi. Kehe time é uce pwoiitihi ne ko a bwohemwo, kehe é ne ko nina go nelé tong, be ni apulie tem. ");
INSERT INTO cam_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tai nina etong, ke etem; ke nina etem, ke etong. Ke a wâé tong, ke e kolé. ");
INSERT INTO cam_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","«É jenaa, ke caa time uce woéo pwo bwohemwo, kehe woélé, ke te élé pwo bwohemwo. Ke é caa âmwo lé céiiko. Caa, go cilelé ne ha a niim na iitihi, a niim na go ne tong, beme céiu jélé pwohewiikenyu. ");
INSERT INTO cam_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","He mwo woéo pelelé ne pwo bwohemwo, ke é cilelé ne he niim. É wéi ni apulie na go nelé tong, ke te tice paceli tieeng, te icehi pa nahi apipatieden, beme *pajuujuhi a pwooti na caa tii.» ");
INSERT INTO cam_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«É jenaa, ke é caa âdé céiiko, ke é pii ni pwooti naa ne pwo bwohemwo, beme e mu kolé a pipwodéén dong, a pipwodéén na hején. ");
INSERT INTO cam_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","É ne telé a pwooti tem. «Ke e téétilé na a bwohemwo, be time uce ni apulie pwo bwohemwo, pwohewiiéo, be time é uce âbé mu pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Time é uce ileko me go péélé mu pwo a bwohemwo, kehe me go wéilé ne ko *Caatana pana ta nang. ");
INSERT INTO cam_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Time uce ni apulie pwo bwohemwo, pwohewiiéo, be time é uce âbé mu pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","«Pacémunilé ko a *juuju, be a pwooti tem, ke a juuju. ");
INSERT INTO cam_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","«Pwohewii a bwo neéo bé ne pwo bwohemwo, ke é nelé ngemwo pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","É pineéo tem me delé, beme woélé mwo, ke me lé pinelé tem ha a juuju.» ");
INSERT INTO cam_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Time é uce pwoiitihi ne kolé cehi, kehe é ne mwo ko nina lé bo céihi ne kong mu ko ni pwooti telé. ");
INSERT INTO cam_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","É ilehi me céiu jélé pwohewii a bwo céiu genyu, go Caa, be wogo kong, ke woéo kom, ke me céiu jélé ne konyu. Ke me e céihi na a bwohemwo pie, wogo na go neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","«É ne telé a wâé na go ne tong, beme céiu jélé pwohewii a bwo céiu genyu: ");
INSERT INTO cam_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","woéo kolé, ke wogo kong, beme te ju céiu jélé. Ke me e temehi na a bwohemwo pie, wogo na go neéo bé, ke me eânimem delé pwohewii a bwo eânimem dong. ");
INSERT INTO cam_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«Caa, nimung me nina go nelé tong, ke me lé mu mwo pelong ne he na é mu lang, beme lé alihi a wâé tong, a wâé na go ne tong. Be eânimem dong ânebuhe atabuhi ko a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Caa, wogo na go mwomwon. Time e uce temehiko na a bwohemwo, kehe woéo, ke é te temehiko. Ke ni apulie tong, ke lé temehi pie wogo na go neéo bé. ");
INSERT INTO cam_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","É pwo me lé temehi a niim. Ke é bo pwo mwo me lé temehi, beme a pwonimem kong, ke me e kolé, ke me é mu kolé.» ");
INSERT INTO cam_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Alecehe a bwopiine ni pwooti naa, ke lé tahagéi a dihen Cédron wo Iésu me ni acémun den. Ke lé â taa ha a duaan na cemi acuwo hen. ");
INSERT INTO cam_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Wo Judas, pali e bwo pipwohuô ten, ke e te temehi mwo a duaan naa, be wo Iésu me ni acémun den, ke lé mu âbé nelang. ");
INSERT INTO cam_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","E pébé ni coda roma wo Judas me ni awéihi *mwaiitihi. Be lé pahedelé ngen ne ni caa te ni *apwoâpwailo me ni *Farasaio. Lé ân imi ni ei helé, me ni teua. ");
INSERT INTO cam_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","E caa te temehi wo Iésu ati nina me lé pwo ne kon. Ke e â benilé, ke e pii telé pie: «He geé hanee?» ");
INSERT INTO cam_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","6","Ke lé hegi ne ten pie: «Wo Iésu mu Nazaret.» Ke e pii telé pie: «*Woéo.» Ke lé te pitidicemwo kuti, ke lé tai tupwo ne pwo bwohemwo, woélé me Judas, pali e icueng. ");
INSERT INTO cam_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ke e tahimwolé mwo wo Iésu pie: «He geé hanee?» Ke lé pii mwo pie: «Wo Iésu mu Nazaret.» ");
INSERT INTO cam_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Ke e hegi ne telé pie: «É caa ko pii tewé pie Woéo. Hemepie geé ko haneéo, ke geé ne lépwoje me lé engen!» ");
INSERT INTO cam_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E pii anaa, beme e cuwo a pwooti na e pii pie: «Te tice pace apulie celi tieeng mu ko nina go nelé tong.» ");
INSERT INTO cam_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ke e te céi kuti a teua ten wo Simon Pétéru mu ha a mwon, ke e tahi ko Malkus, pa apenem de pa *daame he lépwo apwoâpwailo, ke e tahagéi a jéénen ne pwo jui. ");
INSERT INTO cam_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ke e pii wo Iésu te Pétéru pie: «Go ne homwo a teua tem ha a mwon! Woté, pwocoon me é ûdu a tabe ha a mwotabe ko picani na e ne tong wo Caa?» ");
INSERT INTO cam_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lé imwi Iésu ne ni coda, me pa caa telé, me ni awéihi mwaiitihi, ke lé cieeng. ");
INSERT INTO cam_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Lé mi pééeng nge céii Hanne, be pa mwaa Kaïfe, pa daame he lépwo apwoâpwailo ha a jo naa. ");
INSERT INTO cam_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kehe wo Kaïfe li e ne ali pihuô, ne te ni *Juif pie: «Wâé hemepie e mele wo pana céiu nang me de a puapulie ati.» ");
INSERT INTO cam_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Lu âcéi Iésu wo Simon Pétéru me pa céiu acémun den. Wo panaa, ke e te temehieng wo pali daame he lépwo apwoâpwailo. Ke e â taa pwo napwomwo pele pa daame he lépwo apwoâpwailo. ");
INSERT INTO cam_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","E cuwo pwomwo cebwo a pomwa wo Pétéru, ke wo pali acémun béén, ke e cihe ne ko ê toomwo awéihi pomwa, beme e pwo me e taa wo Pétéru. ");
INSERT INTO cam_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ke e pii te Pétéru wo êje pie: «He time uce wogo pa céiu *acémun de Iésu?» Ke e hegi ne ten pie: «Ûhu!» ");
INSERT INTO cam_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ke e â pwocadéu pele ni apenem me ni awéa na lé caa patéi miû, be ubwo a bwala. ");
INSERT INTO cam_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wo Hanne pali daame he lépwo apwoâpwailo ânebun ke e tahimwo Iésu ko lépwo acémun den, ke é ko ni cémun na e ne telé. ");
INSERT INTO cam_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ke e hegi ne ten wo Iésu pie: «É mu te cihe pwaatihi ne tewé. É mu te pacémuni ni apulie ne he ni *mwotapitihi, ke é ne *huâ iitihi, he na lé mu te pipitilé nelang ne ni Juif. Ke te tice celi é pipii neduwohi. ");
INSERT INTO cam_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","É mu ko ade na go tahimwoéo ko nina é pii? Go tahimwo lépwona lé téneéo, be lé te temehi nina é pii.» ");
INSERT INTO cam_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","He e ko pii anaa wo Iésu, ke e tahi kon a in wo pa céiu awéihi mwaiitihi, ke e pii ten pie: «Go wonaa a bwo hegi ne te pa daame he lépwo apwoâpwailo?» ");
INSERT INTO cam_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ke e pii ten wo Iésu pie: «Hemepie ta ace bwo hegi nen, ke go pii tong aceli ta celi é pii. Ke hemepie wâé ace bwo hegi nen dong ne ten, ke é mu ko ade na go ahiéo?» ");
INSERT INTO cam_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ke wo Hanne, ke e ne Iésu, he teko cieeng, nge céii Kaïfe, pa daame he lépwo apwoâpwailo ha a benaamwon naa. ");
INSERT INTO cam_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Mepwo wo Simon Pétéru, ke e mwo ko pwocadéu. Ke lé pii ten pie: «Wogo, ke he time uce pace céiu acémun den?» Ke e hegi ne telé pie: «Ûhu, time é uce béélé.» ");
INSERT INTO cam_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","E mu hadeniilé wo pa céiu apenem de pa daame he lépwo apwoâpwailo, pa béé pali e tahagéi ali jéénen wo Pétéru. Ke e pii mwo ten pie: «He time uce wogo pana é alikeu me Iésu, ne ha ali duaan li cemi acuwo hen?» ");
INSERT INTO cam_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ke e piwotétaa mwo wo Pétéru, ke e pii pie: «Ûhu!» Ke e te to kuti ali ja. ");
INSERT INTO cam_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","He mwo ju acaama, ke lé pé Iésu mu pele Kaïfe, nge he pomwa te *Pilate, pa gupéno te lépwo Roma. Time lé uce taa ha a mwa wo lépwo apihuô juif be time uce pa Juif wo Pilate beme time e uce mu kolé a ta, hemepie lé pé a wiinaado ko *Pacika. ");
INSERT INTO cam_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ke e wie benilé wo Pilate, ke e pii pie: «Ade aceli ta celi e pwo pa apulie ce, beme geé pipé ne kon?» ");
INSERT INTO cam_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ke lé hegi ne ten pie: «Hemepie paceli te tice ta pwo ten, ke me time geme o uce neeng dem.» ");
INSERT INTO cam_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","É mu ko anaa, ke e pii telé wo Pilate pie: «Geé pééeng, ke geé tautieng âcehi ni patén dewé.» Ke lé pii wo lépwo Juif pie: «Te tice mwomwon deme me geme taunu pace céiu apulie.» ");
INSERT INTO cam_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","E tuiebé ninaa, beme cuwo ni pwooti na e caa pii wo Iésu. Be e caa mi pii telé a bwomune ace bwo mele ten. ");
INSERT INTO cam_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","E taa ha a mwa wo Pilate, ke e tode Iésu ke e pii ten pie: «He wogo pa daame he ni Juif?» ");
INSERT INTO cam_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ke e hegi ne ten wo Iésu pie: «He go te pipii a pwooti na mu kom, ai lé pii tem ne ce béén?» ");
INSERT INTO cam_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ke e hegi ne ten wo Pilate pie: «Kona woéo, ke he pa Juif? Be lé neko tong na a puapulie tem me ni caa te lépwo apwoâpwailo. Ke he ade aceli go pwo?» ");
INSERT INTO cam_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ke e hegi wo Iésu pie: «Time uce e éni pwo bwohemwo a Mwametau tong. Be hemepie wonaa, ke wieli lé o pwopaing ne ni eabwé tong, beme time uce neéo te ni apihuô juif. Be a Mwametau tong, ke time uce e éni pwo bwohemwo.» ");
INSERT INTO cam_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ke e tahimwoeng wo Pilate pie: «Wogo, ke he pa daame?» Ke e hegi ne ten wo Iésu pie: «A *juuju a bwopiinen dem. Woéo, ke é âbeele ke é âbé ne éni pwo bwohemwo, beme é patemehi a juuju. Ke lé téne a pating ati ne ni apulie na e kolé a juuju.» ");
INSERT INTO cam_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ke e hegi ne ten wo Pilate pie: «A juuju, ke he ade?» He e caa pii ni pwooti naa, ke e wie mwo, ke e â beni lépwo Juif. Ke e pii telé pie: «É ne kong, ke te tice aceli ta celi jan me e pwocuhinaado kon wo pa apulie ce. ");
INSERT INTO cam_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Caa te cemang ne kowé, me é pwo me e wie mu he karépu wo pace céiu apulie, ha a tan ko Pacika. Ke woté? Nimewé me é patupwo ne tewé mwo pa daame he ni Juif?» ");
INSERT INTO cam_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ke lé tai toii da ko miiden ko pii pie: «Ûhu! Time uce weeng, kehe wo Barabas.» Wo panaa, ke pa apulie na te junihe ta nang. ");
INSERT INTO cam_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ke e pahede ni coda wo *Pilate me lé pé Iésu, ke me lé ahieng ko bwaliiwota. ");
INSERT INTO cam_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ke lé pihoonieng ne ni coda: Lé péi a kuron ko ni mii acuwo na pwo dan, ke lé neole pwo punin. Ke lé pwo me e cuwohe a epwén na te junihe megele pwohewii a epwéne pa apulie na piubwo nang. ");
INSERT INTO cam_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ke lé âbé mwonueng, ke lé pii pie: «Bwocu, go pa daame he ni *Juif! Adéiko!» Ke lé ahi a pwahamiin. ");
INSERT INTO cam_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","E wie mwo wo Pilate, ke e pii te ni Juif pie: «Geé téne, é pééeng wie, beme geé temehi pie te tice aceli é tooli ne kon celi ta ke me e pwocuhinaado.» ");
INSERT INTO cam_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ke e wie wo Iésu, he e pwo punin ali kuron li pwo dan, imi a epwén na megele. Ke e pii telé wo Pilate pie: «Weengi pali apulie!» ");
INSERT INTO cam_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","He lé alieng ne ni caa te ni *apwoâpwailo me ni awéihi *mwaiitihi, ke lé toii da pie: «Cemeiteeng! Cemeiteeng ne ko a *kuricé!» Ke e pii telé wo Pilate pie: «Geé te pééeng me geé cemeiteeng, be é ne tong, ke te tice ace ta celi é tooli ne kon beme e pwocuhinaado.» ");
INSERT INTO cam_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ke lé hegi ne ten ne ni Juif pie: «Pwo a patén deme, ke é ne ha a patén naa, ke tii pie wâé heme e mele, be e pii pie weeng, ke pa *Naî Padué.» ");
INSERT INTO cam_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","He e téne a pwooti naa wo Pilate, ke te nihe mwotieng. ");
INSERT INTO cam_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ke e taa huâ, ke e pii te Iésu pie: «Wogo, ke he pa apulie mu wé?» Ke time e uce hegi ne ten wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ke e pii ten wo Pilate pie: «He woéo na muhi tem me go cihe tong? He time go uce temehi pie jan ne kong me é patupwoko, ke jan ne kong me é cemeiteko?» ");
INSERT INTO cam_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ke e hegi ne ten wo Iésu pie: «Te tice aceli jan ne kom me go pwo tong, hemepie time uce ne tem mu he miiden ace pihuô ne kong. É mu ko anaa, ke te nihe ubwo a ta pwo te pana e icuéo ne tem.» ");
INSERT INTO cam_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ke e hane wo Pilate me e patupwoeng. Kehe lé wiikau ne ni Juif, ke lé pii pie: «Hemepie go patupwoeng, ke time uce wogo pa béé pa daame ubwo César. Be wo pana e pii pie weeng pa daame, ke pa apwobwoni César!» ");
INSERT INTO cam_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","He e caa téne ni pwooti naa, ke e pé wie Iésu wo Pilate, ke e tebwo pwo atebwo te pa atautinaado, ne he na pii kon lang pie ‘Cour pavée’; he pwo *ébéru, ke lé pii pie Gabata. ");
INSERT INTO cam_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","A tan naa, ke a tan na lé piwâam ne ko a *Pacika hen. Ke caa goahen. Ke e pii wo Pilate te ni Juif pie: «Neko pa daame hewé!» ");
INSERT INTO cam_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ke lé wiikau ke lé pii pie: «Me taunueng! Me taunueng! Cemeiteeng ne ko a kuricé!» Ke e pii telé wo Pilate pie: «Me é cemeite pa daame hewé ne ko a kuricé?» Ke lé hegi ne ni caa te ni apwoâpwailo pie: «Te tice pace céiu daame heme koja pa daame ubwo César!» ");
INSERT INTO cam_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ke e neeng delé beme lé cemeiteeng ne ko a kuricé. Ke lé pé Iésu ngen wo lépwo coda. ");
INSERT INTO cam_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","E pé a kuricé ten wo Iésu, ke e wie mu ha a pwomwo ubwo, beme e â ha a céiu duaan na pii kon pie Golgota he pwo ébéru, a bwopiinen pie ‘pwo a piipuni apulie’. ");
INSERT INTO cam_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","É nelang he na lé o cemeiteeng ne ko a kuricé, me lupwo alo apulie, woilu he lupwo piduaan, ke wo Iésu ha awiemelu. ");
INSERT INTO cam_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ke e pwo me lé tii ne ko a ba-acuwo a céiu atii wo Pilate, pie: iésu mu nazaret, pa daame he lépwo juif, ke lé cemeite ne ko a kuricé. ");
INSERT INTO cam_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Lé tii he pwo ébéru, *grek, ke latin, be a duaan na lé cemeite Iésu ne ko a kuricé ne hen, ke é mwonuhi a pwomwo ubwo. Ke hiwon ni Juif na lé pine. ");
INSERT INTO cam_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kehe lé pii te Pilate ne ni caa te ni apwoâpwailo, pie: «Go nemwo tii pie “Pa daame he ni Juif”, kehe go tii pie “E pii pie woéo pa daame he ni Juif.”» ");
INSERT INTO cam_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ke e hegi ne telé wo Pilate pie: «Ana é tii, ke é caa te tii.» ");
INSERT INTO cam_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","He lé caa cemeite Iésu ne ko a kuricé, ke lé pé ni epwénen ne ni coda, ke lé pipii me paa ni mwoto kon, me pipétaalé. Ke lé pé mwo a epwénen na te tice awoli kon, a mwaanu na hején, ");
INSERT INTO cam_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ke lé pipii telé pie: «Genye nemwo tie, kehe genye céi metii ne kon, beme genye temehi pie woo paceli e bo pé.» Beme pacuwohi a pwooti na caa tii ne he ni tii iitihi pie: Lé pipatihi ne kolé ni epwénung, ke lé picéi metii ne kon. Psaume 22.19 Weengaa ana lé pwo ne ni coda. ");
INSERT INTO cam_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Lé cuwo mwonuhi a kuricé te Iésu wo nyaa ten, ke ê ciéé nyaa ten, ke wo Maria mwode Klopas, ke wo Maria mu Magdala. ");
INSERT INTO cam_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ke e ali nyaa ten wo Iésu ne cebwo pa acémun den na te nihe eânimen den, ke e pii te nyaa ten pie: «Nyaa, neko pa naîm.» ");
INSERT INTO cam_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ke e pii te pali acémun den pie: «Neko nyaa tem.» Ke tabuhi ha a tan naa, ke e pé nyaa ten wo pali acémun den ne he pomwa ten. ");
INSERT INTO cam_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Alecehe anaa, ke e temehi wo Iésu pie caa cuwo ati ni penem na e ne ten wo Caa. Ke e pii pie: «Nimung me é ûdu», beme e pajuujuhi ana caa te tii ne he ni tii iitihi. ");
INSERT INTO cam_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","E mu lang a mwotabe na oba ko a tabe megele na maga. Ke lé pate hen a mwaanu ne ni coda, ke lé cie ne ko a dihe hysope, ke lé ne mwonuhi a pwon. ");
INSERT INTO cam_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ke me e ûdu a tabe maga wo Iésu, ke e pii pie: «É caa tai pacuwohi.» Ke e miibule, ke e ne a jenen. ");
INSERT INTO cam_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","He paciile a tan na lé piwâam ko a *tan iitihi telé wo lépwo Juif. Ke te time uce wâé te ni apihuô, hemepie lé mwo te mu ko a kuricé ni éé Iésu me lupwo alo béén, ha a tan iitihi. Be a tan iitihi naa, ke te nihe pwonaado ne kon. Ke lé ile Pilate me e tatubwi ni alé beme lé epin ko mele ke me lé pé ni éélé mulang. ");
INSERT INTO cam_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ke lé âbé ne ni coda beme lé tatubwi ni a pa bécéiuhen, ke lé tatubwi mwo ni a pa béalohen, lupwo apwocuhinaado na cemeitelu ne ko ni piduaa Iésu. ");
INSERT INTO cam_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ke me lé âbé mwonu Iésu, ke lé alihi pie e caa mele, ke time lé uce tatubwi ni an. ");
INSERT INTO cam_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Kehe pwo pa coda na e woli a céiu duaan ko a da, ke e te wie kuti a cewéle me a tabe. ");
INSERT INTO cam_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wo pana e alihi ninaa, ke e uti, ke ana e uti, ke a juuju. E te temehi pie e pii a juuju. E pajuujuhi beme geé céihi mwo wogewé. ");
INSERT INTO cam_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","E tuie anaa, beme pajuujuhi nina tii ne he ni tii iitihi, pie: Te tice ace duun celi tatubwi. ");
INSERT INTO cam_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ke: Lé o bo alieng wo lépwona lé wolieng. ");
INSERT INTO cam_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Pwo pa céiu apulie mu Arimaté na pii kon pie Josef. Pa céiu *acémun de Iésu, na e te pineduwoeng, be mwotieng ko ni apihuô juif. Ke e â ilehi a éé Iésu koja Pilate. Ke e te neeng wo Pilate, me e â pé a éé Iésu. ");
INSERT INTO cam_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ke e âbé céin wo Nikodème, pali e caa mi too Iésu he bwén. E pébé lupwo tabe ûde na e pineibuhi, na 30 kilo, a myrrhe ke a aloès. ");
INSERT INTO cam_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ke lu pé a éé Iésu, ke lu tawii ko ni mwaanu, ke lu céihi a tabe ûde, be te a bwomu te ni Juif heme lé pineduwohi apulie. ");
INSERT INTO cam_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","42","Ke lu pééeng nge ha ali duaan li cemi acuwo hen, be e mwonuhi a duaan na lé taunu Iésu ne hen, ke e lang mwo a bwomu na mwo te tice apulie hen. Lu piepin ko neduwoeng lang be o caa tabuhi a tan iitihi he babwén, ke iitihi me lé neduwo ni amele ha a tan iitihi. ");
INSERT INTO cam_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","He pwoiitihi pwopwometan, ke e â he iitihi wo Maria mu Magdala. Ke e alihi pie caa titééhi ali péi mu ânebuhe a bwomuhe Iésu. ");
INSERT INTO cam_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ke e téte hane Simon Pétéru, ke pa céiu acémun den na eânime Iésu ten. Ke e pii telu pie: «Lé caa pé Padaame mu ha ali mwa péi, ke time geme uce temehi he celi lé neeng lang!» ");
INSERT INTO cam_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Lu wie wo Pétéru me pa céiu acémun den, ke lu â ha ali mwa péi. ");
INSERT INTO cam_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Lu tai téte, kehe e piepin wo pa céiu acémun den koja Pétéru, ke e mi tuie ngen. ");
INSERT INTO cam_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","E â pioole da, ke e alihi ni mwaanu na lé mu pwo bwohemwo, kehe time e uce taa. ");
INSERT INTO cam_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ke e tehenebé wo Simon Pétéru, ke e taa ha ali mwa péi he li lé ne Iésu lang. Ke e alihi ni mwaanu na lé mu pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kehe a mwaanu na lé tawii a puni Iésu kon, ke time e uce mu he ni béé mwaanu. Be te capipihi, ke ne ha a céiu duaan. ");
INSERT INTO cam_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","E bwo uce alecehe Pétéru wo pali béén, ke e taa ha ali mwa péi, ke e alihi pie te tie Iésu lang ke e céihi pie e mulie cemwo mu ha amele. ");
INSERT INTO cam_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kehe time lu uce téele temehi pie, caa mi tii ne he ni tii iitihi pie, e o bo mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ke lu mwojuia ne mwo pelelu. ");
INSERT INTO cam_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mepwo é ne ko Maria, ke e teko cuwo ko é pwomwo, cebwo ali mwa péi. He e ko é, ke e pioole da, ");
INSERT INTO cam_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ke e ali lupwo *âcélo na lu cuwohe ni epwén na pwojo, na lu ko tebwo he li e mu lang a éé Iésu. Pa céiu, ke e tebwo he na e lang a punin, ke wo pa céiu, ke e tebwo he na e mu lang ni an. ");
INSERT INTO cam_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ke lu pii ten pie: «Êje, he go é kona woté?» Ke e hegi ne telu pie: «É é niimi Padaame hung, be time é uce temehi he celi lé neeng lang.» ");
INSERT INTO cam_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","He e ko pii anaa, ke e biteeng, ke e ali Iésu he e ko cuwo, kehe time e uce temehi pie weeng. ");
INSERT INTO cam_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ke e pii ten wo Iésu pie: «Êje, he go é kona woté? He go hanee?» E niimihi pie pana e cihe ten, ke pa apenem he ni ni acuwo. Ke e pii ten pie: «Hemepie wogo na go pééeng, ke go pii tong he celi go neeng lang, beme é bo â pééeng.» ");
INSERT INTO cam_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ke e pii ten wo Iésu pie: «Maria!» Ke e niê ocemwo, ke e pii ten he pwo *ébéru pie: «Rabouni!», a bwopiinen pie ‘pa apipune’. ");
INSERT INTO cam_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ke e pii ten wo Iésu pie: «Go nemwo ti kong, be mwo time é uce téele taa pele Caa. Kehe go â too ni bééng, ke go pii telé pie, é o caa taa pele Caa tong, pa Caa tewé mwo; céii Padué hung, Padué hewé mwo.» ");
INSERT INTO cam_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ke e te engen kuti wo Maria, ke e â patemehi te ni *acémun de Iésu pie: «É ali Padaame!» Ke e uti telé a bwo picihe telu. ");
INSERT INTO cam_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ha a babwén naa, ke lé pimu ibu ne ni acémun den, ke lé capuhi ni pomwa, be mwotilé ko ni apihuô juif. Ke e te pihabwiieng kuti ne ha awiemelé wo Iésu, ke e pii telé pie: «Me e mu pelewé a péém!» ");
INSERT INTO cam_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","He e caa pii telé ninaa, ke e habwii ni naatiin, ke a duaan. Ke te nihe piwâénime ni acémun den, he lé ali Padaame. ");
INSERT INTO cam_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ke e pii telé mwo wo Iésu pie: «Me e mu pelewé a péém! Pwohewii a bwo neéo bé te Caa, woéo mwo, ke é nekewé ngen.» ");
INSERT INTO cam_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Alecehe ni pwooti naa, ke e cuulé, ke e pii telé pie: «Geé hegi a *Jenen Iitihi! ");
INSERT INTO cam_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ni apulie na geé pineuhi ni ta pwo telé, ke o te pineuhi, kehe nina time geé uce pineuhi ni ta pwo telé, ke e o te mu kolé.» ");
INSERT INTO cam_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Toma, na pii kon pie ‘pa Péidu’, pa céiu béé ni 12 acémun den, ke tieeng hadeniilé he e âbé wo Iésu. ");
INSERT INTO cam_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ni béé acémun de Iésu, ke lé pii te Toma pie: «Geme ali Padaame!» Kehe e pii telé pie: «Hemepie time é uce alihi ne he naatiin a ahi toki, ke me time é uce ne kon a mwodéing, ke me time é uce ne ko a duaan a ing, ke time é uce céihi!» ");
INSERT INTO cam_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Alecehe a naadenitan na céiu, ke lé pitoolé mwo ne ha a mwa wo lépwo acémun de Iésu, ke e mu pelelé wo Toma. Ke lé tai capuhi ni pomwa ko kilé. Ke e âbé wo Iésu, ke e cuwo hadeniilé. Ke e pii pie: «Me e mu pelewé a péém!» ");
INSERT INTO cam_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ke e pii te Toma pie: «Nebé éni a mwodéim, ke go alihi ni ing. Ne mwobé a im, ke go ne ko a duaang. Nemwo pwo me pinekepé a pwonimem, kehe go céihi!» ");
INSERT INTO cam_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ke e hegi ne ten wo Toma pie: «Padaame hung ke Padué hung!» ");
INSERT INTO cam_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ke e pii ten wo Iésu pie: «Go céihi be go aliéo. *Adéi lépwona time lé uce alihi, kehe lé céihi!» ");
INSERT INTO cam_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Hiwon ni béé *inenaado na pwojunuun na e pwo wo Iésu, ne he pwahamii ni acémun den, kehe time uce tii ati ne ha a tii ce. ");
INSERT INTO cam_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Kehe nina tii ne éni, ke e ne beme geé céihi pie wo Iésu, ke pa *Mesia, pa *Naî Padué. Ke mepie geé céihi, ke etewé a mulie ne he niin. ");
INSERT INTO cam_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Alecehe anaa, ke e pihabwiieng wo Iésu ne te ni acémun den, ne ko jije a *jié Galilé. Woni a bwo pihabwiieng ne telé: ");
INSERT INTO cam_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pétéru, Toma na pii kon pie ‘pa Péidu’, Natanaël na e âbé mu Kana ne Galilé, lupwo naî Zébédé, me lupwo alo *acémun de Iésu, ke lé pitoolé nelang. ");
INSERT INTO cam_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ke e pii telé wo Simon Pétéru pie: «É mwo â pwotau.» Ke lé hegi ne ten pie: «Geme âdé céim.» Ke lé wie, ke lé taa pwo ong. Ke é ha a bwén naa, ke te tice âpéhelé. ");
INSERT INTO cam_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","He mwo ju acaama, ke e mu ticepwon wo Iésu. Kehe time lé uce temehi ne ni acémun den pie weeng. ");
INSERT INTO cam_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ke e pii telé pie: «Lépwoje, te tice ikua tewé?» Ke lé hegi ne ten pie: «Ûhu.» ");
INSERT INTO cam_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ke e pii telé pie: «Geé tahi a pua nge pwo jui ne ko a ong, ke geé bo tooli.» Ke lé tahi a pua, ke te nihe pwocoon me lé céida mwobé, be te junihe hiwon ni ikua. ");
INSERT INTO cam_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ke e pii te Pétéru wo pa acémun na eânime Iésu ten, pie: «Wo Padaame!» Ke me e te téne anaa wo Pétéru, ke e epin ko apilihi kon ni epwénen, ke e téele ole he tabe. ");
INSERT INTO cam_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ke lé âbé pwo ong ni béé acémun den, he lé ko céi a pua, be te nihe oba ko ikua. Be time uce élé ité kojan ticepwon. ");
INSERT INTO cam_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","He lé caa ole mu pwo ong, ke lé alihi ni daapi na éle, na e pwon ni ikua, ke pwo ni pwoloa cebwon. ");
INSERT INTO cam_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ke e pii telé wo Iésu pie: «Geé pébé ce béé ikua mu ko ni âpéhewé.» ");
INSERT INTO cam_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ke e taa pwo ong wo Simon Pétéru, ke e céi ali pua, ke te ju oba ko ni pilehe ikua na 153. Kehe time uce tie a pua. ");
INSERT INTO cam_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ke e pii telé wo Iésu pie: «Geé âbé pé celi me geé wii!» Ke te tice pace acémun den celi e tahimwoeng pie: «Wogo, ke he woo?» Be lé te tai temehi pie wo Padaame. ");
INSERT INTO cam_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ke e âbé mwonulé wo Iésu, ke e pé a pwoloa ke e patihi ne kolé, ke e pé mwo a ikua, ke e ne telé. ");
INSERT INTO cam_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Caa a béciéhe ni bwo pihabwiieng ne te ni acémun den, tabuhi he e mulie cemwo mu ha amele. ");
INSERT INTO cam_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Alecehe a bwo wiinaado telé, ke e tahimwo Simon Pétéru wo Iésu pie: «Simon, pa naî Jonas, te eânimem dong koja lépwoje?» Ke e hegi ne ten pie: «Éa, go Padaame, go te temehi pie eânimung dem.» Ke e pii ten wo Iésu pie: «Go ne ce wiinaado te ni nahi muto tong.» ");
INSERT INTO cam_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ke e pii ten mwo a béokelohen pie: «Simon, pa naî Jonas, te eânimem dong?» Ke e hegi wo Pétéru pie: «Éa, go Padaame, go te temehi pie eânimung dem.» Ke e pii ten wo Iésu pie: «Go wéihi ehi ni muto tong.» ");
INSERT INTO cam_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ke e pii ten mwo a béociéhen pie: «Simon, pa naî Jonas, te eânimem dong?» Ke ju piwahin a pwonime Pétéru ko ana e caa ocié ko pii ten pie: «Te eânimem kong?» Ke e hegi ne ten pie: «Padaame, go te temehi ati ni naado, ke go te temehi pie eânimung dem!» Ke e pii ten wo Iésu pie: «Go ne ce wiinaado te ni muto tong. ");
INSERT INTO cam_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","É pii tem a juuju pie: He mwo ewa go, ke go te pine cehi a taihenam, ke go â he na nimem me go â lang. Ke hemepie bo caa ukéiu go, ke go bo eti ni im, beme e cie a taihenam wo pace céiu apulie. Ke e o bo pééko nge he na time uce nimem me go â lang.» ");
INSERT INTO cam_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","E pii anaa, beme e patemehi te Pétéru ace bwo mele ten, beme e habwii *a wâé te Padué. Ke e pii ten pie: «Go âbé céing!» ");
INSERT INTO cam_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ke e niê ocemwo wo Pétéru, ke e ali pa céiu acémun den he e âbé céilé, pali te nihe eânime Iésu ten, pali e pioole nge céii Iésu he li lé wiinaado, ke e pii ten pie: «Padaame, he woo paceli e bo icuko?» ");
INSERT INTO cam_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","He e alieng, ke e pii te Iésu wo Pétéru pie: «Padaame, wo paje, ke ade aceli e bo tuie ne kon?» ");
INSERT INTO cam_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ke e pii ten wo Iésu pie: «Hemepie nimung me e mulie dieli hemepie é bo âmwobé, ke te tice aceli me go pii ne kon. Kehe wogo, ke go âbé céing!» ");
INSERT INTO cam_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","É mulang, ke a bwopiinen naa, ke lé caa pii ne ni acéihi pie, pa acémun naa, ke time e o uce mele. Kehe time e uce pii wo Iésu te Pétéru, pie: «Time e o uce mele.» Kehe e pii pie: «Hemepie nimung me e mulie dieli hemepie é bo âmwobé, ke te tice aceli me go pii ne kon.» ");
INSERT INTO cam_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Te wo pa acémun naa, na e uti ni pwooti ce, ke e tii mwo. Ke geme temehi pie nina e uti, ke ni juuju. ");
INSERT INTO cam_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Nihe hiwon ni béé naado na é pwo wo Iésu. Kehe mepie lé tii ati nina e pwo, ke é niimihi pie time uce jan ne ko a bwohemwo ati me e mu hen ni tii na lé tii ne kon!");
INSERT INTO cam_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Téofile, é pii ne ha a bécéiuhe tii tong, ati nina e pwo wo Iésu, ke pacémunihi mu ha atabuhi kon, ");
INSERT INTO cam_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","die ha a tan na céieng da he *miiden. Ânebuhe anaa, ke e mi ne ni pihuô ten, mu ko a *Jenen Iitihi, ne te lépwo *apostolo na e caa pipégalilé. ");
INSERT INTO cam_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Alecehe a bwo mele ten, ke e pihabwiieng delé pie e caa mulie cemwo. Ke e ne telé ni béé alihi nen, ke e pihabwiieng delé, he na 40 ni tan, ke e cihe ko a *Mwametau te Padué. ");
INSERT INTO cam_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","É he lé ko pimu ibu, ke e pii telé pie: «Geé nemwo engen mu *Iérusaléma, kehe geé ucéihi ana e caa mi pii wo Caa, ke ali é caa pii tewé mwo. ");
INSERT INTO cam_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Be e *pipuu apulie ko a tabe wo Ioane, kehe ju lupwoce tan, ke o puukewé ko a Jenen Iitihi.» ");
INSERT INTO cam_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lé pimu ibu wo Iésu me lépwo apostolo, ke lé tahimwoeng pie: «Pa daame, caa é ha a benaamwon ce, na go pacuuli mwo a mwametau te *Isaraéla?» ");
INSERT INTO cam_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","E hegi ne telé wo Iésu pie: «Time uce wogewé na me geé temehi ce tan, ai ce benaamwon celi e ne wo Caa, ne he ni âpihuô ten. ");
INSERT INTO cam_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kehe geé bo hegi a junuu a Jenen Iitihi na e bo opé ne huîiwé. Ke bo wogewé lépwo apajuujuéo ne Iérusaléma, ati ha a *Judé ke é *Samari die pwo a bwohemwo ati.» ");
INSERT INTO cam_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","É alecehe a bwopiine ninaa telé, ke e céieng da kojalé ne he miiden wo Padué. Ke é he lé mwo ko omeeng, ke tieeng ne ha a menii. ");
INSERT INTO cam_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ke é he lé mwo ko niê da he miiden he e ko taa, ke pwo lupwo apulie na pwomelaa ni epwénelu, na lu âbeetilé. ");
INSERT INTO cam_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ke lu pii telé pie: «Lépwo apulie Galilé, é mu ko ade na geé ko cuwo ko niê da he miiden? Wo Iésu na e céieng da he miiden mu ha awiemewé, ke e bo âmwobé, pwohewii a bwo alieng he e ko taa he miiden.» ");
INSERT INTO cam_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ke lé mwojuia mwo mu pwo a juwole ko ni Olivier wo lépwo apostolo, beme lé âmwo Iérusaléma, he na céiu kilomètre. ");
INSERT INTO cam_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","É he lé tuie ngen, ke lé taa ha a nemwa na e mu ko miiden ne ha a pwomwo na lé mu te cuwo ko mu hen. Wo lépwonaa, ke wo Pétéru, Ioane, Cang, André, Filip, Toma, Bartélemi, Mataio, Cang pali naî Alfé, Simon pali Zélote, ke wo Jude pali naî Cang. ");
INSERT INTO cam_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Lé pitaineibulé, ke lé tee pwoiitihi taaci, woélé me ni toomwo, me Maria nyaa te Iésu me lépwo ciéé Iésu. ");
INSERT INTO cam_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","É ha a céiu tan, ke piâmwonuhi a 120 lépwo acéihi na lé pimu ibu. Ke e cuwoda mu hadeniilé wo Pétéru, ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Lépwo âjiénung, wâé heme e cuwo a pwooti, na e caa pii na a Jenen Iitihi na e cihe ko *Davita. Be e caa mi pii ânebun ana e pwo wo Judas, be e bo pwaaden beme lé imwi Iésu. ");
INSERT INTO cam_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Kehe wo Judas, ke te pa céiu bééme, ne he ni penem de lépwo apostolo.» ");
INSERT INTO cam_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(E pwocuhi a pule ko a cuhi a bwo icu Iésu, é nelang na e tupwo, ke tehi a nan, ke â wie ni oohen. ");
INSERT INTO cam_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ke lé tai temehi a jepule naa ati ne ni apulie ha a pwomwo ubwo Iérusaléma, ke lé ne me nii a duaan naa pie, Akeldama, a bwopiinen he pwo patilé pie ‘a ninaado na pwo cewéle hen’.) ");
INSERT INTO cam_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","E pii mwo wo Pétéru pie: «Be caa tii ne ha a tii *Psaumes te Davita pie: Wâé heme tice apulie ha a pomwa ten. Me time lé bo uce mu mwo lang ne ce apulie. Psaume 69.26 «Ke e tii mwo pie: Wâé heme e wodehieng ne ha a penem den wo pace céiu. Psaume 109.8 ");
INSERT INTO cam_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","«Wâé heme pwo pace céiu bééme, beme pa céiu *apajuujuhi na a bwo mulie cemwo te Iésu. Wâé heme pa apulie naa, ke pa céiu béé lépwona lé mu cuwo ko âbé céinye, he ni benaamwon na e mwo mu pelenye wo Padaame henye, tabuhi he li e pipuu apulie wo Ioane, die ha a benaamwon li e taamwo he miiden wo Iésu.» ");
INSERT INTO cam_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ke lé pipégali lupwo apulie na alo julu: Wo Josef na pii kon pie Barsabas, ke Justus, ke pa céiu na pii kon pie Matias. ");
INSERT INTO cam_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ke lé tai pwoiitihi, ke lé pii pie: «Padaame, wogo pana go temehi ni pwonime ati ni apulie, go habwii teme pace apulie celi go caa pipégalieng mu hadenii lupwo apulie ce, ");
INSERT INTO cam_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","me pa apostolo bééme, beme e pé ni penem de Judas. Be e caa necu ni penem den wo Judas, ke e caa â ha a duaan den be e caa hegi a cuhi a penem den na ta.» ");
INSERT INTO cam_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ke lé céi metii ne kolu, ke hiwon ni metii te Matias. Ke lé pééeng me pa béé lépwo 11 apostolo. ");
INSERT INTO cam_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","É ha a tan ko Pentekote a tan ubwo ko pitii âdaanu ke lé pimu ibu ha a céiu duaan ne ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ke lé te téne kuti, ana e opé mu he miiden, na pwo huu hen, pwohewii a huu he a dan na junihe ubwo. Ke e te paai kuti a mwa na lé mu hen. ");
INSERT INTO cam_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ke lé alihi ni naado na e âbé, na pwohewii ni duwele miû, ke lé muko pétaapwo â ti kolé. ");
INSERT INTO cam_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ke e te ole huîilé kuti a *Jenen Iitihi. Ke lé cihe he ni muko pétaapwo pwooti, na e ne telé na a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","É ne *Iérusaléma ha a benaamwon naa, ke lé mulie nelang wo lépwo *Juif na te junihe eânimelé ko a pwoiitihi, na lé âbé mu he ni amu pitihi a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ke lé tai téte, ke lé tai â mu, he na lé téne nelang ali huu he naado. Ke te junihe emegéi nalé, be lé téne nina lé céihi he lé cihe he ni pétaapwo pwooti. ");
INSERT INTO cam_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Lé tai téetihi ati, ke te junihe emegéi nalé, ke lé pitahimwolé pie: «Kona ni apulie ce, na lé ko cihe, ke time uce tai ni apulie Galilé? ");
INSERT INTO cam_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ke é mu ko ade na nye ténelé, he lé ko cihe he ni patinye?» ");
INSERT INTO cam_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Be hadeniilé, ke pwo ni apulie na lé âbé mu he ni amu: é Parte, ke é Médi, ke é Élam, ke é Mésopotami, ke é *Judé. Ke pwo ni béén na lé âbé mu he ni béé province roma: Kapados†, ke é Pont, ke é Asia, ");
INSERT INTO cam_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ke é Frigi, ke é Pamfili. Ke ni béén, ke lé âbé mu *Aigupito, ke é he ni nahi amu ko a Libi, cebwo Cirène. Ke ni béén mwo, ke lé âbé mu *Rome, ");
INSERT INTO cam_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ke é mu Krète, ke é mu ha amu Arabi. Ke tai woélé ati, ke lé tai âbé ati mu he ni béé amu naa. Ke pwo ni béén mu pelelé na te ni ju Juif; ke ni béén na lé céihi ne ko a pwoiitihi te lépwo Juif. Ke lé pitahimwolé pie: «Kona ade ace watihen me nye téne ni apulie Galilé naa, na lé ko pii ne he ni béé patinye ni naado na ubwo na e pwo wo Padué?» ");
INSERT INTO cam_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ke lé te junihe téetihi ati, kehe time lé uce temehi aceli lé ko pii, ke lé pipii telé pie: «De ace bwopiine ani?» ");
INSERT INTO cam_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Kehe icehi ana pwo ni béén na lé pihooni nina lé céihi, ke lé pii pie: «Lé te junihe piolo kuti ko tabe megele!» ");
INSERT INTO cam_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ke e cuwoda wo Pétéru me lépwo 11 *apostolo béén, ke e toii da, beme lé temehi ehi pie: «Wogenye lépwo Juif, me wogewé ati na wogewé éni Iérusaléma, geé tabemi heme é pii ehi tewé ana e ko tuie. ");
INSERT INTO cam_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ke time lé uce piolo ni apulie ce, pwohewii a bwo niimihi nen dewé, be mwo teko ju 9 inetéale ko acaama, ha a benaamwon ce. ");
INSERT INTO cam_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ûhu! Weengi kuti ali e caa pii wo *péroféta Joël pie: ");
INSERT INTO cam_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","E pii wo Padué pie: “É he *ni bénebwéne tan, ke é bo neoté a Jenung ne ko ati ni niide apulip. Ni ewa aiu me ewa toomwo tewé, ke lé bo patemehi a pwooti tong. Ke é bo habwii ni naado ne he ni jene ni nahi ewa tewé. Ke mepwo é ne ko ni ukéiu tewé, ke é bo pacihelé ne he ni niûlé. ");
INSERT INTO cam_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","É he ni tan naa, ke é bo neole a Jenung ne ko ni eabwé tong, aiu me toomwo. Ke lé bo patemehi a pwooti tong.” ");
INSERT INTO cam_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","“É bo pwo me tuie ni naado ne he miiden me pwo bwohemwo na te junihe ité ke time geé mu uce téele alihi: a cewéle, ke a miû, ke ahu. ");
INSERT INTO cam_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","O biteeng na a téale me bwén; ke o megele a wole me pwohewii a cewéle, ânebuhe a tan de Padaame, a tan na ubwo, ke pwojunuun. ");
INSERT INTO cam_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ke é o *celuimi nina lé tode Padaame.”» Joël 3.1−5 ");
INSERT INTO cam_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","E pii mwo wo Pétéru pie: «Lépwo apulie *Isaraéla, geé tabemi a pwooti na me é pii tewé: Wo Iésu, pa apulie Nazaret, ke pa apulie na e caa te mi pipégalieng wo Padué. Ke wo Padué, ke e caa pihabwiieng dewé. Geé te temehi ehi pie e ne me e pwo ni naado na te junihe ité, me ni *pipwojunuun, ne ha awiemewé. ");
INSERT INTO cam_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wo panaa, ke pa apulie na e pineeng dewé, pali geé pwo me e mele, ke geé neeng me lé cemeiteeng ne ko a *kuricé wo lépwo apulie na ta jélé, âcehi ana e mi temehi wo Padué, ke ana nimen kon. ");
INSERT INTO cam_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Kehe icehi ana wo Padué, ke e celuimieng mwo, ke e pééeng koja ni picani ko a mele, ke e pamulipieng mwo, be te tice mwomwon de a mele ne kon. ");
INSERT INTO cam_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Be e caa te mi piuti wo *Davita, he e pii pie: É te cuwo ko te ali taaci Padaame ânebuhung. Be e tebwo pwo a juing, ke time é uce pipenem. ");
INSERT INTO cam_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","É te junihe pipwodéén me pietieng be é temehi pie, é hemepie é mele, ke o te wâé ne kong. ");
INSERT INTO cam_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Be wogo Padué, ke time go uce patupwo a jenung ne ha amele, ke time o uce nyaale a ééng, be go caa pipégaliéo me é eabwé tem. ");
INSERT INTO cam_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Go caa habwii tong a pwaaden nge ha a mulip, ke é o te junihe pipwodéén be go o tee mu pelong.» Psaume 16.8−11 ");
INSERT INTO cam_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","E pii mwo wo Pétéru pie: «Lépwo âjiénung, time uce piwâ jo me é pii pwaatihi tewé pie, pa watihenye Davita, ke e mele, ke neduwoeng. Ke nye mwo teko alihi a bwomuhen dieli jenaa. ");
INSERT INTO cam_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Kehe icehi ana wo Davita, ke te pa péroféta, ke e te temehi nina e pii wo Padué ânebun, he e pii ten pie: É bo pipégali pace apulie mu ko ni piebehiko, ke é bo pwo me e tebwo pwo a atebwo tem. Psaume 132.11 ");
INSERT INTO cam_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","«Ke e caa te temehi ânebun wo Davita ana e bo tuie, ke e caa te mi pii a bwo mulie cemwo te pa *Mesia. Ke a bwopiinen ce, na pii ne ko Iésu: O time e uce patupwo a jenen ne ha amele, ke time o uce nyaale a één. ");
INSERT INTO cam_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","E caa pamulipi mwo pa Iésu naa wo Padué, ke wogeme kuti lépwo *apajuujuhi nen. ");
INSERT INTO cam_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","«Ke e neeng da wo Padué Caa ne *pwo a juin beme e pihuôhi ati ni naado ke e ne ten a Jenen Iitihi na e caa nebwén ko pii ânebun. Ke é mulang, na e neopé kome a Jenen Iitihi, pwohewii ana geé ko alihi ke téne jenaa. ");
INSERT INTO cam_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Be time e uce taa he miiden wo Davita, kehe icehi ana e pii pie: Pwooti te Padaame Padué, na e pacihe pa daame hung: “Go âbé tebwo éni pwo a juing. É ne tem a pihuô, ke o pipaunuko dieli mwo. ");
INSERT INTO cam_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","É pwo me go caaite nina lé pwopa ne kom.” Psaume 110.1 ");
INSERT INTO cam_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«Wogewé a bele Isaraéla, wâé heme geé temehi pie, wo pali Iésu li geé cemeiteeng ne ko a kuricé, ke e neeng wo Padué me pa Mesia ke me Padaame.» ");
INSERT INTO cam_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","É alecehe a bwo téne nen delé a pwooti naa, ke tai tatééhi ke gini ni pwonimelé, ke lé pii te Pétéru me ni béé apostolo pie: «Lépwo âjiéneme, me geme pwo de?» ");
INSERT INTO cam_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Ke e pii telé wo Pétéru pie: «Geé pininim, ke geé bitekewé, ke me puukewé ne he nii Iésu *Kériso, beme o pineuhi ni ta pwo tewé, ke me geé hegi a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Be a *piapwo ânebun naa, ke a dewé me ni naîwé, me ati ni apulie na junihe élé mwo ité, na e bo todelé wo Padué, Padaame henye.» ");
INSERT INTO cam_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ke te junihe hiwon ni pwooti na e pajuujuhi ne telé, ke e pamwoiulé kon wo Pétéru. Ke e pii telé mwo pie: «Geé cela ko ni apulie na ta ni huô telé, beme geé o mulie.» ");
INSERT INTO cam_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Hiwon ni apulie mu pelelé na lé hegi a pwooti te Pétéru. Ke lé céihi ne ko Iésu, ke puulé. É ha a tan naa, ke lé caa âmwonuhi a 3000. Ke bo ni béé nina lé caa mi céihi ânebun. ");
INSERT INTO cam_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ati nina lé céihi, ke lé te cuwo ko pimu ibu me lépwo apostolo, ke lé téne ehi ni naado na lé pii. Ke lé ebii ibuhi a pwoloa, ke lé pipwoiitihi ibu. ");
INSERT INTO cam_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ke mepwo ni apulie, ke lé téetihi, ke mwotilé, be wo Padué, ke e habwii ne ko lépwo apostolo ni pipwojunuun na junihe hiwon. ");
INSERT INTO cam_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ati nina lé céihi, ke te céiu a pwonimelé, ke lé pwo me ni naamuulé, ke me tai ni delé. ");
INSERT INTO cam_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Lé icuhi ni pule telé, me ni wâé telé, ke lé pipwopii ne kolé ni cuhin, beme cuhi nina tice telé. ");
INSERT INTO cam_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ati he ni tan, ke lé te tai pipwoiitihi ibu *huâ iitihi, ke lé piwiinaado ibu ne he ni pomwa telé, ha a pipwodéén, ke a piwâénime. ");
INSERT INTO cam_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ke lé pipaunu Padué. Ke ati ni apulie, ke lé pipwodéén kolé. Ke wo Padaame, ke é ati he ni tan, ke e ne me pihiwon da nina e celuimilé. ");
INSERT INTO cam_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","É ha a benaamwon ko pwoiitihi, ko cié inetéale alecehe a wiinaado, ke lu taa ha a *mwaiitihi te lépwo *Juif wo Pétéru me Ioane. ");
INSERT INTO cam_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","É ko jije a pomwa ko a mwaiitihi, ke pwo pana tebwomwa nang ha a bwo piâbeele ten. É ati he ni tan, ke lé pééeng bé, ke lé âbé neeng ha a pomwa na pii kon pie a Pomwa Wâé, beme e ilehi mwani koja ni apulie na lé taa *huâ iitihi. ");
INSERT INTO cam_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ke me e ali Pétéru me Ioane, he lu pwo me lu â taa huâ iitihi, ke e ilelu ko mwani. ");
INSERT INTO cam_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ke lu te ju omeeng ehi, ke e pii ten wo Pétéru pie: «Go omekemu!» ");
INSERT INTO cam_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ke e te ju omelu ehi, ucéihi aceli me lu ne ten. ");
INSERT INTO cam_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kehe icehi ana e pii ten mwo wo Pétéru pie: «Te tice mwani tong, kehe icehi ana etong, ke é o ne tem: É ne he nii Iésu Kériso mu Nazaret, ke go cuwoda ke go engen!» ");
INSERT INTO cam_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ke e pétaa ole ko a in ne pwo juin wo Pétéru, ke e pwiieng. Ke caa te ju wâé mwo lupwo an. ");
INSERT INTO cam_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ke e te cuwoda kuti, ke e engen. Ke lé taa me weeng ha ali mwaiitihi. Ke e te junihe pipwodéén, ke e téele, ke e pipaunu Padué. ");
INSERT INTO cam_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ati ni apulie na lé alieng he e engen, ke lé pipaunu Padué. ");
INSERT INTO cam_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Be lé ali temehieng, pie pali e mu tee tebwo ha a Pomwa Wâé, beme e ilehi mwani. Lé téetihi ati ne ni apulie, ke lé wéhaahi, ana e tuie ne kon. ");
INSERT INTO cam_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Time e uce engen koja Pétéru me Ioane wo pali tebwomwa. Ke lé téetieng ati ne ni apulie, ke lé tétebé céiilé ne ha a mwa na tice goomwa kon, na pii kon pie ‘Mwa te Solomona’. ");
INSERT INTO cam_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ke me e alihi anaa wo Pétéru, ke e pii te a bele pie: «Lépwoli *Isaraéla, é ko ade na geé téetihi a bwo wâé paje? É ko ade na geé omekemu, pwohewiin heme wogemu na gemu pwo me e engen wo pa apulie ce, ko ace junuumu, me ace âpipwoiipihinaado temu? ");
INSERT INTO cam_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","«Wo Padué he *Abérama, me Isaaka, me Iakobo, wo Padué he lépwo watihenye, ke e habwii pie te junihe ubwo Iésu, pa eabwé ten. Ke wogewé kuti, ke geé icueng te ni daame hewé, ke geé téétieng ne ânebuhe gupéno *Pilate, he e caa te niimihi pie me e pawieeng mwo. ");
INSERT INTO cam_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Muhi tewé me pawie pa apulie na e pipégalieng wo Padué, pa apulie na mwomwon nang, ke geé bo pawie pa ataunuhi apulie. ");
INSERT INTO cam_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","«Ke geé pwo me e mele wo pa Caa te a mulip. Kehe icehi ana wo Padué, ke e pwo me e mulie cemwo mu ha amele. Ke wogeme ni *apajuujuhi nen. ");
INSERT INTO cam_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","«Geé caa ko alihi temehi pa apulie ce. Be caa wâé nang ko a nii Iésu, be gemu céihi ne kon. Ke a céihi ten ne ko Iésu na e ne me wâé nang ne ânebuhewé ati.» ");
INSERT INTO cam_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«Kehe icehi wogewé lépwo bééng, na é temehi pie ana geé pwo me lépwo daame hewé, ke time geé uce temehi. ");
INSERT INTO cam_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kehe icehi ana wo Padué na e pacuwohi ana lé caa patemehi ânebun ati ne ni péroféta ten. Ke lé caa pii pie, e bo mu he ni picani wo pa Mesia. ");
INSERT INTO cam_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","«Geé pininim, ke geé bitekewé bé céii Padué, beme e bo ciitili ni ta pwo tewé, ");
INSERT INTO cam_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ke me e bo ne tewé a pipwowâé ten, ke e bo pawiebé céiikewé pa Mesia ten, wo Iésu, na e caa pipégalieng ânebun me dewé. ");
INSERT INTO cam_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","«Kehe icehi ana ha a benaamwon ce, ke e mwo te mu he miiden dieli ha ace tan celi e bo pine ehi ati ni naado wo Padué. Ke e caa mi pahede lépwo péroféta beme lé â pii beetihi anaa. ");
INSERT INTO cam_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","E pii wo *Moosé pie: Wo Padué Padaame hewé, ke e bo pwo me e cuwoda mu hadeniiwé pace péroféta celi pwohewiiéo. Wâé heme geé bo piténedehi ati nina e bo pii tewé. ");
INSERT INTO cam_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Pana time e uce pitabemi pa péroféta naa, ke e bo pawieeng mu hadenii a bele. ");
INSERT INTO cam_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","«Ke ati lépwo péroféta, na tabuhi mu ko Samuel, ke lé tai pii beetihi ni tan ce. ");
INSERT INTO cam_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","«Wogewé lépwo naî lépwo péroféta, a bwopiinen ce, ke te a dewé mwo. Be wo Padué, ke e caa pwo a *piapwo ten, ne te lépwo caa tenye. Ke e pii te Abérama pie: É mu ko lépwo piebehiko, ke é bo *adéi ati ni pwomwoiu ne pwo a bwohemwo. ");
INSERT INTO cam_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","«Be te mi é ne tewé ânebun, na e nebé Iésu, pa apenem den, wo Padué, beme e ne tewé a adéihi, me geé bitekewé he picéiu, mu he ni ta pwo tewé.» ");
INSERT INTO cam_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","É he lu mwo ko cihe te a puapulie wo Pétéru me Ioane, ke lé pwome tehenebé wo lépwo *apwoâpwailo, me pa apihuô te lépwo awéihi *mwaiitihi, me lépwo *Saducéen. ");
INSERT INTO cam_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ke lé te nihe okéé ne kolu, he lu pacémunihi a puapulie, be lu cihe telé ko a bwo mulie cemwo te Iésu mu ha amele. Be time lé uce céihi pie pwo ace mulie cemwo wo lépwo Saducéen. ");
INSERT INTO cam_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ke lé imwilu, ke lé nelu he karépu die ko acaama, be he caa babwén. ");
INSERT INTO cam_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ke hiwon nina lé téne a pwooti, ke lé céihi ne kon. Ke caa e mwonuhi 5000 a jéhi ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","É ha acaama hen, ke wo lépwo apihuô, me lépwo ukéiu, me lépwo *dotéén ko patén, ke lé pitaineibulé ne *Iérusaléma, ");
INSERT INTO cam_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","me Hanne† pa *daame he lépwo apwoâpwailo, me ati ni pwomwoiu ten: wo Kaïfe, me Jean, me Alexandre, me ni béén mwo. ");
INSERT INTO cam_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Lé ne Pétéru me Ioane ne ha awiemelé, ke lé tahimwolu pie: «É mu ko a junuu-û, ai é ne he nii-î na geu pwo me tieden a cunu?» ");
INSERT INTO cam_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ke caa ju tili Pétéru na a *Jenen Iitihi, ke e pii telé pie: «Lépwo apihuô, me lépwo ukéiu te lépwo *Isaraéla, ");
INSERT INTO cam_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","geé tahimwokemu jenaa, beme gemu pii tewé ace watihen me tieden a cunu ko pa apulie ce. ");
INSERT INTO cam_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wâé heme geé temehi ati wogewé a puapulie Isaraéla, pie, é mu ko a nii Iésu Kériso mu Nazaret, pana geé cemeiteeng ne ko a *kuricé, ke wo Padué, ke e pwo me e mulie cemwo mu ha amele. É mu kon, na wo pa apulie ce, ke e éni ânebuhewé he caa ju wâé nang. ");
INSERT INTO cam_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Caa te tii ne he ni *tii iitihi pie: Ali péi li geé tahi taabwon, wogewé lépwo abahi mwa, ke te anaa kuti a ju paamwa! Psaume 118.22 «A péi naa, ke wo Iésu. ");
INSERT INTO cam_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Be te tice ne haahi a miiden ace céiu nii apulie celi ne te lépwo apulie, me e celuimikenye, kehe te céiu cehi a nii Iésu na e celuimikenye.» ");
INSERT INTO cam_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ni *mwohuô, ke lé alihi a bwo cumang de Pétéru me Ioane, ke lé téetihi, be lé temehi pie lupwo apulie mu hadenii ni apulie, na time lu uce nihe temehinaado, ke lé temehi pie lupwona lu mu âcéi Iésu. ");
INSERT INTO cam_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ke me lé ali pali apulie, he caa ju wâé nang ne pelelu, ke te tice aceli me lé mwo pii mwo. ");
INSERT INTO cam_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Lé pawielu mu ha ali mwohuô, beme lé mwo picihe hadeniilé. ");
INSERT INTO cam_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Ke lé pitahimwolé pie: «Genye bo woté te lupwo apulie ce? Be lé caa tai temehi ati ne ni apulie Iérusaléma a *pipwojunuun na lu pwo, ke pwocoon me genye waaneduwohi. ");
INSERT INTO cam_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kehe me time lé uce pipii ngen a jepule naa hadenii ni apulie. Genye pa-abwobwolu, ke paciitihi kolu me lu nemwo cihe ko a nii Iésu, ne te ni apulie.» ");
INSERT INTO cam_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ke lé tode Pétéru me Ioane mwo, ke lé paciitihi kolu, me lu nemwo cihe mwo, ke pwocémun ne he nii Iésu. ");
INSERT INTO cam_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Kehe lu hegi ne telé pie: «Geé cuwoteeke pitauti pie, he te mwomwon ne ânebuhe Padué me gemu ténedekewé, ai wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Be wogemu, ke time uce jan me time gemu pii ni naado na gemu alihi, me ni naado na gemu téne.» ");
INSERT INTO cam_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ke é alecehe a bwo pa-abwobwolu, ke lé pawielu, be time lé uce temehi ace bwopwonen celi me lé pwo, beme lu pwocuhinaado. Wonaa mu ko ni apulie, be lé tai pipwoun de Padué ko ni naado na e pwo. ");
INSERT INTO cam_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Be e caa wédenihi a 40 ni jo he pali apulie li wâé nang. ");
INSERT INTO cam_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Alecehe a bwo pawie Pétéru, me Ioane, ke lu â too lépwo béélu, ke lu piuti telé ati ni naado na lé pii telu wo lépwo caa te lépwo apwoâpwailo me lépwo apihuô. ");
INSERT INTO cam_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ke heme lé téne ati ninaa, ke lé tai pwoun de Padué ne he ni pwonimelé na te céiu. Ke lé pii pie: «Padaame, wogo na go tabuhi a miiden me a bwohemwo, a jié me ati ni naado na e hen. ");
INSERT INTO cam_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Wogo na go nebé a Jenen Iitihi me e cihe ko pa caa teme, pa apipenem dem *Davita, pie: É mu ko ade na lé tee okéé ne ni bele, ke lé pwo ni bwo niimihinaado na te piticenaado ne kon? ");
INSERT INTO cam_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wo lépwo daame ubwo ne pwo bwohemwo, ke lé pwo me lé pwopa ne ko Padaame Padué. Ke wo lépwo apihuô, ke lé pineibulé bwoni Padué me pa Mesiaten. Psaume 2.1−2 ");
INSERT INTO cam_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«Te a juuju, be wo pa daame Érode Antipas me gupéno Ponce *Pilate, ke lé picuwo ibu me lépwo apulie, me ni pwomwoiu Isaraéla ne ha a pwomwo ubwo ce. Ke lé pipwobwoni pa apipenem iitihi tem, wo Iésu, na go pipégalieng me pa Mesia. ");
INSERT INTO cam_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kehe icehi ana me lé wonaa, ke lé pwo me cuwo ati nina go caa ne ânebun, âcehi nina nimem kon, me a junuum. ");
INSERT INTO cam_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","«Kehe é jenaa, go Padaame, ke go alihi a bwo pwohuu telé. Geme ilehi kojako pie go pwo me geme mwoiu, wogeme lépwo apipenem dem, beme time uce piwâ geme, me geme pii a pwooti tem. ");
INSERT INTO cam_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Wâé heme go nebé a junuum beme wâé lépwona cunu jélé, me pwo ce inen, ke ce junuun ne he nii Iésu, pa apipenem iitihi tem.» ");
INSERT INTO cam_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ke me lé pwoiitihi ati, ke te éjén kuti ali duaan li lé mu hen. Ke e ole huîilé ati a Jenen Iitihi, ke caa time uce piwâ jélé me lé pii beetihi a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Te tai ati kuti lépwo acéihi, ke te céiu a pwonimelé, ke céiu ni bwo niimihinaado telé. Te tice pace céiu béélé celi e pii pie: «Ni wâé tong, ke te ni dong cehi», kehe caa te tai ni delé. ");
INSERT INTO cam_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ke lé cihe mwoiuhi wo lépwo *apostolo, ke lé *pajuujuhi a bwo mulie cemwo te Padaame Iésu. Ke e neopé ne huîilé ati a pipwowâé ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Te tice pace céiu mu ha awiemelé celi pwo celi tieden kojaeng. Be te ati lépwona pwo ni apwoamu telé, ke ni mwa telé, ke lé icuhi, ke lé pébé ni cuhin, ");
INSERT INTO cam_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ke lé ne te lépwo apostolo. Ke lé bo pipatihi ne kolé, âcehi nina tice telé. ");
INSERT INTO cam_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Pwohewii ne ko Josef, pa apulie mu ha a pwomwoiu te Lévi, na e piâbeele ne pwo a één Chipre. Wo panaa, ke lé pitoii niin wo lépwo apostolo pie Barnabas, a bwopiinen pie ‘pa apipamwoiukenye’. ");
INSERT INTO cam_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Be e icuhi a apwoamu ten, ke e pébé ni cuhin, ke e ne te lépwo apostolo. ");
INSERT INTO cam_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pwo pa aiu na pii kon pie Ananias, me ê mwoden na pii kon pie Safira, ke lu icuhi a mepule telu. ");
INSERT INTO cam_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Lu piténelu me mwoden, ke e pébé a mwani céii lépwo apostolo wo Ananias, kehe icehi ana lu neduwohi a céiu duaan, ke time lu uce ne telé ati. ");
INSERT INTO cam_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ke e pii ten wo Pétéru pie: «Ananias, é mu ko ade me go pitabemi *Caatana, me e ganye a pwonimem, me go pigeti a *Jenen Iitihi, beme go imwi a céiu duaan cuhi a céiu mepule. ");
INSERT INTO cam_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","É ânebuhe a bwo icuhi nen, ke te a dem ali pule! Ke é alecehe a bwo icuhi nen, ke te a dem mwo ali mwani kon! Wonaa a bwo niimihinaado tem kona woté? Be time uce ni apulie na go getilé, kehe go geti Padué!» ");
INSERT INTO cam_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ke me e téne ni pwooti naa wo Ananias, ke ele a nenehen, ke e tupwo ole. Ke nihe mwoti lépwona lé téne a jepule naa. ");
INSERT INTO cam_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ke lé âbé ni ewa aiu, ke lé pwoiipieng, ke pééeng wie, me lé â pineeng he iitihi. ");
INSERT INTO cam_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","É he ko cié inetéale ha a pwocehin, ke e tuiebé wo mwode Ananias. Mwo te tice aceli e temehi mu ko ali e mi tuie nelang. ");
INSERT INTO cam_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ke e tahimwoeng wo Pétéru pie: «Te a cuhi ali mepule li geu icuhi?» Ke e hegi ne ten pie: «Éa, te a cuhin anaa kuti!» ");
INSERT INTO cam_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ke e pii ten wo Pétéru pie: «Geu woté ko ace bwopwonen me geu piténekeu, me geu tacebwénihi a Jenen Iitihi te Padaame? Go alihi, be wo lépwona lé mwo te ju âbé mu ha a pineduwo pali aiu hem, ke nekolé nelang he pomwa. Ke lé o bo caa pééko mwo.» ");
INSERT INTO cam_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ke ele a nenehen, ke e tupwo ole ko ni a Pétéru. Ke lé taabé li apulie ewa, ke lé alieng he e caa mele, ke lé pééeng, ke lé â neduwoeng cebwo pali aiu hen. ");
INSERT INTO cam_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ke nihe mwoti ati lépwo acéihi die ko ati nina lé téne ni bwomunen naa. ");
INSERT INTO cam_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Hiwon ni inenaado na pwo ne ha awieme a pubu apulie, mu ko lépwo apostolo. Ke wo lépwo acéihi, ke lé tai pimu ibu ne ha a ‘Mwa te Solomona’. ");
INSERT INTO cam_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ke piwâ ni béén me lé âbé céiilé, kehe ni apulie, ke lé te junihe picedilé. ");
INSERT INTO cam_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","E taa a jéhi ni aiu me ni toomwo na lé céihi ne ko Padaame, ke nihe hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pwo ni cunu na lé péélé bé ne pwo pwaaden, ke lé nelé pwo ni apule, ke e pwo ni talihi, be lé niimihi pie, me e âbé wo Pétéru, ke me e ti ko ce béén a démen. ");
INSERT INTO cam_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Hiwon ni apulie na lé âbé ne *Iérusaléma, ni apulie na lé âbé mu he ni béé duaan ko jijen. Lé pébé nina cunu jélé, me nina pwo duéé kolé, ke te tai wâé jélé ati. ");
INSERT INTO cam_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","É he ko wonaa, ke lé te tai cuwoda wo pa *daame he lépwo apwoâpwailo me lépwo *Saducéen, be lé te nihe pitaaba ne ko lépwo *apostolo. ");
INSERT INTO cam_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ke lé te imwilé kuti, ke lé nelé da he karépu. ");
INSERT INTO cam_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ke é he bwén, ke pwo pa *âcélo te Padaame, na e tehi ati ni pomwa ko a karépu, ke e pawielé. Ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Geé â mu *huâ iitihi, ke geé patemehi te ni puapulie ati ni pwooti ko a mulie na mwo coho.» ");
INSERT INTO cam_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","22","Ke me lé te téne kuti anaa, ke lé taa huâ iitihi he mwo te ju acaama, ke lé pacémuni ni apulie. É ha a benaamwon naa, ke wo pa daame he lépwo apwoâpwailo me ni béén, ke lé tode ati lépwo apihuô, wo lépwo ukéiu te a bele *Isaraéla, beme lé pipitilé. Ke lé ne me lé â pébé lépwo apostolo, mu he karépu. Kehe icehi ana me lé tuie nge he karépu wo lépwo awéihi *mwaiitihi, ke time lé toolé. Ke lé mwojuia mwo, ke lé pwojepule te lépwona lé pahedelé, ke lé pii te a *mwohuô pie: ");
INSERT INTO cam_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«Geme tuie nge ha ali karépu, ke he te ju capuhi ehi ni pomwa kon, ke wo lépwo awéihi nen, ke he lé teko cuwo he ni awéa telé. Kehe icehi ana me geme tehi ni pomwa, ke he caa te tice apulie hen!» ");
INSERT INTO cam_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ke lé téne ni pwooti naa wo pa apihuô te lépwo awéihi mwaiitihi, me lépwo caa te lépwo apwoâpwailo. Ke time lé temehi aceli me lé pii ne ko a bwo tie lépwo apostolo, me aceli e bo tuie. ");
INSERT INTO cam_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","É he mwo ko wonaa, ke e tehenebé wo pa céiu apulie, ke e pii telé pie: «Lépwoli apulie li geé nelé he karépu, ke élé huâ iitihi ni, ke lé ko pacémuni ni apulie!» ");
INSERT INTO cam_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ke lé engen wo lépwo awéihi mwaiitihi me pa apihuô telé, ke lé te ju â péélé bé ehi, be mwotilé ko a bele, be koli lé bo ahilé ko péi. ");
INSERT INTO cam_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","É alecehe a bwo pébé lépwo apostolo, ke lé péélé nge céii a mwohuô, ke e tahimwolé wo pa daame he lépwo apwoâpwailo pie: ");
INSERT INTO cam_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«Kona he li time geme uce paciitihi kowé me time geé uce pwocémun ne he nii pa apulie naa? Ke é jenaa ni, ke geé patemehi pitihi Iérusaléma ko ni cémun dewé! Ke mwo te nimewé mwo me geme watihe a bwo mele ten?» ");
INSERT INTO cam_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ke e hegi ne telé wo Pétéru, he woélé me lépwo apostolo béén pie: «Wâé heme nye piténede Padué koja ni apulie. ");
INSERT INTO cam_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wogewé kuti na geé taunu Iésu, be geé ne me cemeiteeng ne ko a *kuricé. Kehe icehi ana e te pamulipieng mwo wo Padué he ni caa tenye. ");
INSERT INTO cam_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ke e ne da Iésu ne *pwo a juin beme e pihuôhi ati ni naado. Ke e neeng me Padaame, ke me pa aceluimi, beme e temehi na a bele Isaraéla pie, jan me e pininim beme e o neuhi ni ta pwo ten. ");
INSERT INTO cam_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ke wogeme kuti lépwo *apajuujuhi ati ni naado naa, wogeme me a Jenen Iitihi, na e ne wo Padué ne te nina lé piténedeeng.» ");
INSERT INTO cam_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ke me lé téne ni pwooti naa na a mwohuô, ke lé te junihe okéé, ke lé pwo me lé taunu lépwo apostolo. ");
INSERT INTO cam_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Kehe icehi ana e cuwoda mu hadeniilé wo pa *Farasaio na pii kon pie Gamaliel, pa *dotéén ko patén, na lé te junihe picedieng ati na a bele. Ke e ilehi pie me lé mwo te ju neme pawie lépwo apostolo. ");
INSERT INTO cam_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ke e pii te a mwohuô pie: «Lépwo bééng Isaraéla, geé pipwocilekewé ko celi geé ko niimihi pie me geé pwo te ni apulie naa. ");
INSERT INTO cam_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Time uce téele bwolihi a benaamwon na e tuie hen wo Teudas, pa apulie na e te piniimihi pie te junihe pwonaado ne kon. Ke e nge pwo 400 ni apulie na lé âcéin. Kehe icehi ana me lé taunueng, ke lé caa te pipiiden ati, ke caa te tice patilé. ");
INSERT INTO cam_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","«É alecehen, ha a benaamwon na pine a jéhi ni apulie hen, ke e cuwoda wo Judas, pa apulie Galilé, ke hiwon ni apulie na lé âcéin. Kehe icehi ana e te mele mwo, ke ni apulie naa, ke lé caa te pipiiden mwo. ");
INSERT INTO cam_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","«Ke é jenaa ni, ke é pii tewé pie, me geé nemwo ili lépwonaa. Kehe wâé heme geé nelé me lé engen, be mepie nina lé pwo, ke mepie e te âbé mu ko ni apulie, ke o tieden. ");
INSERT INTO cam_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ke hemepie e te âbé mu ko Padué, ke o time uce jan me geé pacuwohi. Geé nemwo pwoabwobwo me geé pipwobwoni Padué!» Ke wo lépwo apihuô, ke lé engen ne ko nina e pii wo Gamaliel. ");
INSERT INTO cam_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ke lé tode mwo lépwo apostolo, ke lé nelé me ahilé. Ke lé pawielé, ke lé paciitihi kolé me lé nemwo bo uce cihe mwo ko a nii Iésu. ");
INSERT INTO cam_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ke lé wie koja a mwohuô wo lépwo apostolo, ke lé te junihe pipwodéén, be wo Padué ne ha a tautinaado ten, ke te jan me ahilé ne ko a nii Iésu. ");
INSERT INTO cam_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ke é he ni tan ati, ne huâ iitihi, ke é ne he ni pwomwo, ke lé te cuwo ko pacémuni ni apulie. Ke lé patemehi a *Pwooti Wâé ko Iésu, pa *Mesia. ");
INSERT INTO cam_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","É ha a benaamwon naa, ke e taa a jéhi lépwo acéihi. Lépwona lé cihe he pwo *grek, ke lé pihuu ne ko lépwona lé cihe he pwo *ébéru, be nihe time uce wâé a bwo patihi wiinaado na lé pwo he ni tan, ne ko ni depwele telé. ");
INSERT INTO cam_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Lé tode ati lépwo acéihi wo lépwo 12 *apostolo, ke lé pii telé pie: «Time uce wâé heme geme cuwo koja a bwo patemehi na a pwooti te Padué, ke me geme uce patihi a wiinaado ne pwo ni taap. ");
INSERT INTO cam_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","É mu ko anaa, ke wogewé lépwo bééme ko a céihi, geé pipégali lépwoce apulie celi 7 mu hadeniiwé, celi wâé ni huô telé me ni bwopemilé, na tililé na a *Jenen Iitihi, ke a pitemang, beme o a penem delé. ");
INSERT INTO cam_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Be wogeme, ke geme o caa ju mu ne ko a pwoiitihi, ke é ne ha a cihe ko a pwooti te Padué.» ");
INSERT INTO cam_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","É ne ha a bwopiinen naa, ke tai wâé ne ko lépwo acéihi. Lé pine ni apulie ce: Étienne, pa apulie na nihe ubwo a céihi ten, ke tilieng na a Jenen Iitihi; Filip; Prokore; Nikanor; Timon; Parménas; Nikola, pa apulie mu Antioche; pana e céihi ne ko a pwoiitihi te lépwo *Juif. ");
INSERT INTO cam_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Lé péélé bé céii lépwo apostolo, ke lé pwoiitihi telé, ke lé ne ni ilé huîilé. ");
INSERT INTO cam_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ke e piubwo ngen a pwooti te Padué. Ke e taa me ubwo a jéhi lépwo acéihi ne *Iérusaléma. Ke hiwon lépwo *apwoâpwailo na lé céihi. ");
INSERT INTO cam_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wo Étienne, ke pa apulie na nihe ubwo a *adéihi te Padué ne kon. Ke e pwo ne ha awieme ni bele ni *inenaado na pwojunuun, be nihe ubwo a junuu Padué ne kon. ");
INSERT INTO cam_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ke pwo ni béé apulie na lé pwobwonieng: lépwo béé Juif mu Cirène, mu Alexandri, na lé âbé mu ha a *mwotapitihi te lépwo affranchi, a bwopiinen pie lépwo apenem na tuwolé. Ke pwo mwo lépwo béé Juif mu he lupwo province é Silisi ke é Asia, ke lé picihe me Étienne. ");
INSERT INTO cam_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Kehe icehi ana te tice aceli me lé pwo ten, be e cihe ha a bwo temehi nen na e ne ten a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ke lé pwocuhi ni apulie, beme lé pii pie: «Geme téne he e pii ni pwooti na ta ne ko *Moosé me Padué.» ");
INSERT INTO cam_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ke lé pwo me okéé ni pwonime ali bele, ke wo lépwo apihuô, me lépwo *dotéén ko patén. Ke lé pwome gaaté, ke lé imwi Étienne, ke lé pééeng nge céii a *mwohuô. ");
INSERT INTO cam_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ke lé ne mwo lépwo apulie na lé gele, me lé pii pie: «Pa apulie ce, ke time uce mwaale nang me e tee cihe me ta ne ko a *mwaiitihi ke ni patén. ");
INSERT INTO cam_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Geme téne he e pii wo Étienne pie wo Iésu mu Nazaret naa, na me e bo paniihi a mwaiitihi ce, ke e o bo taatééhi ni huô li e ne tenye wo Moosé!» ");
INSERT INTO cam_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ke lé ome Étienne ati ni mwohuô, be e pwéélang a pwahamiin pwohewii a pwahamii *âcélo. ");
INSERT INTO cam_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ke e tahimwo Étienne wo pa *daame he lépwo apwoâpwailo pie: «Te a juuju kuti ana lé ko pii ne kom?» ");
INSERT INTO cam_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ke e hegi ne ten pie: «Lépwo âjiénung me lépwo caa, geé téne, wo Padué na ubwo nang ne ha *a wâé ten, ke e pihabwiieng de pa caa tenye *Abérama, he e mwo te mu ha amu Mésopotami, ânebuhe a bwo engen den me e â mu Aran. ");
INSERT INTO cam_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Ke e pii ten wo Padué pie: Go engen koja a pwomwoiu tem me a amu tem, ke go â ha amu na é bo habwii tem. ");
INSERT INTO cam_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","«Ke e engen wo Abérama mu ha amu te lépwo Babulona, ke e â mu Aran. Ke é alecehen, ke e mele wo caa ten. Ke wo Padué, ke e pééeng bé ne ha amu ce, na geé caa tee ko mu hen jenaa. ");
INSERT INTO cam_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","«Kehe te tice ace céiu duaan celi e ne ten. Kehe icehi ana e caa te mi pii ten pie: É bo ne tem me ni piebehiko a amu ce. Ke é ha a benaamwon naa, ke he mwo te tice naî Abérama. ");
INSERT INTO cam_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","«Ke e pii ten wo Padué pie: Ni naî ni naîm, ke lé o bo mulie ne ha amu na mwo coho, ke lé bo penem tice ja kon ne ha amu naa, ke o bo pwotahinaado ne kolé he na 400 ni jo. ");
INSERT INTO cam_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Kehe icehi ana e pii mwo wo Padué pie: É bo pwocuhinaado te a bele naa, na lé pwo me lé penem tice ja kon. Ke é alecehen, ke lé bo wie, ke lé bo pipaunuéo, ne ha a duaan ce.» ");
INSERT INTO cam_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","«É alecehen, ke wo Padué, ke e pacuwohi a *piapwo telu me Abérama. Ke a ine a piapwo, ke a *tegoop. Ke wo Abérama, ke e pwotegoop te Isaaka, pa naîn, ha a bécéiuhe naadenitan den. Ke wo Isaaka, ke e pwotegoop te Iakobo pa naîn, ke wo Iakobo, ke e pwo te ni naîn na 12 jélé: wo lépwona lé bo watihe ni 12 pwomwoiu te a bele tenye *Isaraéla.» ");
INSERT INTO cam_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«Ke lé pitaaba ne ko Josef wo lépwo âjiénen naa. Ke lé icueng, ke e caa â *apenem tice ja kon ne ha amu *Aigupito. Kehe icehi ana e te mu pelen wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Ke e te celuimieng koja ni picani me ni téé. Ke e ne ten a bwo temehinaado. Ke e ne me e piwâé Josef wo Faraô, pa daame ne Aigupito. Wo Faraô, ke e ne me e gupéno ne ha amu Aigupito, ke me e pihuôhi ni den ne ha a pomwa ten. ");
INSERT INTO cam_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«Ke e tuiebé a menele na ubwo, na ati ha amu Aigupito, ke é Kanana. Ke te junihe pwoééhe ni apulie. Ke caa tice wiinaado te lépwo caa tenye. ");
INSERT INTO cam_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ke me e temehi pie pwo wiinaado Aigupito wo Iakobo, ke e tabuhi pawie ole ni naîn, lépwo caa tenye. ");
INSERT INTO cam_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","«É ha a béalohe bwo ole telé, ke e pipatemehieng de lépwo âjiénen wo Josef. É mulang, ke e bwobe temehi a pwomwoiu ten wo Faraô. ");
INSERT INTO cam_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ke wo Josef, ke e todebé caa ten Iakobo, me ati a pwomwoiu ten, ke pwo 75 jélé ati. ");
INSERT INTO cam_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ke e ole Aigupito wo Iakobo, ke e bwo mele nelang, woélé me lépwo caa tenye. ");
INSERT INTO cam_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ke lé te pédaamwo ni duulé ne ha amu Sichem, ke nelé ha a iitihi na e pwocuhin ko mwani wo Abérama koja ni piebehi Amor, pa apulie ha amu Sichem. ");
INSERT INTO cam_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«Ke caa é mwonu a benaamwon na o caa cuwo a piapwo ânebun na e pii wo Padué te Abérama. Ke mepwo ali bele Isaraéla, ke piubwo ke pihiwon jélé ne Aigupito. ");
INSERT INTO cam_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kehe icehi ana e â cuwoda wo pa céiu daame ne Aigupito, na e pwo me piticenaado ne ko ni penem de Josef. ");
INSERT INTO cam_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ke e pipwohuô te ali bele tenye, ke e pwo me ta ne kolé, ke e pwohuu telé, me lé engen koja ni naîlé, beme lé mele.» ");
INSERT INTO cam_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","«É ha a benaamwon naa, ke e pituie wo *Moosé, pa cuwo ewa na te junihe wâé nang ne hamii Padué. Ke lu picileeng he na cié ni wole wo lu nyaa ten me caa ten. ");
INSERT INTO cam_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ke caa time uce jan me lu pineduwoeng ke lu pééeng, ke lu neeng ole he éémwa. Ke e tooeng ê naî pa daame Faraô, ke e pééeng me pa naîn. ");
INSERT INTO cam_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ke lé pacémunieng ne ha ati ni pitemang de lépwo Aigupito, ke pa acihe ehi, ke e penem ehi. ");
INSERT INTO cam_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«É he ko 40 ni jo hen, ke e âbé ne he pwonimen pie me e â caniê lépwo âjiénen, a bele Isaraéla. ");
INSERT INTO cam_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ke e too pa céiu Aigupito, he e ko ahi pa céiu apulie Isaraéla. Ke e pwopain ko pali e ko ahieng, ke e taunu pali Aigupito. ");
INSERT INTO cam_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E te niimihi pie wo lépwo âjiénen, ke lé o te temehi pie wo Padué ke nimen me e celuimilé. Kehe icehi ana time lé uce temehi. ");
INSERT INTO cam_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","«Ke é ha a tan alecehen, ke e ali lupwo apulie Isaraéla na lu ko piokéé, ke e picuwo hadeniilu, ke e pii telu pie: “Lupwo bééng, wogeu, ke lupwo âjién. É ko ade na pita geu?” ");
INSERT INTO cam_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kehe icehi ana wo pa apulie na e ahi pa béén, ke e pitité Moosé, ke e pii ten pie: Woo paceli e etiko me go daame heme, ke me go pa atautikeme? ");
INSERT INTO cam_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Woté? Go pwo me go taunuéo, pwohewii ali bwo taunu pali Aigupito haabwén? ");
INSERT INTO cam_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","«Ke me e téne anaa wo Moosé, ke e te cela kuti, ke e â coho ne ha amu Madian. Ke lu pituie nelang wo lupwo naîn. ");
INSERT INTO cam_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«É alecehe nina 40 ni jo, ke e pihabwiieng de Moosé wo pa céiu *âcélo ne ha a melé e mwonuhi a juwole Sinaï. E âbé ha a duwele miû ko a nahi acuwo na éle. ");
INSERT INTO cam_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ke me e alihi anaa wo Moosé, ke e te junihe téetihi kuti, ke e âbé mwonuhi, beme e alihi ehi. Ke e téne a pwocihe te Padaame na e pii ten pie: ");
INSERT INTO cam_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Woéo Padué he lépwo watihem: Padué he Abérama, ke Padué he Isaaka, ke Padué he Iakobo. Ke te éjén kuti Moosé ko a bwo mwotieng, ke pwocoon den me e omehi. ");
INSERT INTO cam_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","«Ke e pii ten wo Padaame pie: Go céi ni dihibwaam, be mepwo a duaan na go ko cuwo hen, ke a duaan na iitihi. ");
INSERT INTO cam_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","É caa alihi a picani me a téé te a bele tong Isaraéla, ne Aigupito, ke é téne a pwocewé ten. Ke é opé beme é pawielé. Ke é jenaa, ke go engen, be é bo neko nge Aigupito. ");
INSERT INTO cam_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«E ne te Moosé a mwomwon naa wo Padué kehe icehi ana time lé uce temehieng, ke lé pii pie: Woo paceli e etiko me go daame heme, ke me go pa atautikeme? Weeng kuti na e neeng wo Padué me e pihuô, ke me e pipéélé, be weeng pana e pipégalieng wo pa âcélo te Padué, li e pihabwiieng ne ha ali nahi acuwo. ");
INSERT INTO cam_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","«Ke wo Moosé, ke e pwo me e wie a bele ten mu Aigupito. Ke e pwo ni *inenaado na pwojunuun, ne ha amu Aigupito, ke é ne ha a jié Megele, ke é ne ha a melé he na 40 ni jo. ");
INSERT INTO cam_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Wo pa Moosé naa kuti, na e pii te a bele Isaraéla pie: Wo Padué, ke e bo pwo me e cuwoda mu hadeniiwé wo pace péroféta celi e pwohewiiéo. ");
INSERT INTO cam_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Mwo te wo Moosé mwo, na e mu pele lépwo caa tenye, ke lé tai mu ha a melé. Ke te weeng mwo na e mu pele pali âcélo, he li e paciheeng ne pwo a juwole Sinaï. Ke e ne ten wo pali âcélo ni pwooti mulip, beme e bo ne tenye.» ");
INSERT INTO cam_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«Kehe icehi ana wo lépwo caa tenye, ke muhi telé me lé piténedeeng, be muhi telé kon, be nimelé me lé mwojuia ngemwo Aigupito. ");
INSERT INTO cam_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ke lé pii te *Aarona pa cuwo Moosé pie: Go pwo ce *déme duéé henye celi me lé ânebuhenye. Be mepwo wo pa Moosé naa, pali e pawiekenye mu ha amu Aigupito, ke time genye uce temehi celi e ko tooeng. ");
INSERT INTO cam_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","É he ni tan naa, ke lé pwo a nahi paaci me a déme duéé helé, ke lé pwo a tan ubwo, ke lé pwoâpwailo ten. Ke lé te junihe pipwodéén ko ana lé pwo. ");
INSERT INTO cam_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ke e biteeng wo Padué kojalé, ke e patupwolé me lé pwoiitihi te a téale, me a wole, me ni ceni. Genye pine anaa ne he ni tii te lépwo péroféta pie: Bele Isaraéla, kona geé mu te pwoâpwailo tong he na 40 ni jo ne ha a melé? Ûhu! ");
INSERT INTO cam_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Be li geé pé ali mwa mwaanu te ali duéé Molok†, ne pehi ali ceni te ali duéé Réfan, ni démenaado na geé pwo, me geé pipaunuhi. Watihen kuti ninaa, na é pwo me péékewé nge ité koja Babulona.» Amos 5.25−27 ");
INSERT INTO cam_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«Ne ha a melé, ke wo lépwo caa tenye, ke lé pwo a mwa mwaanu na e mu hen ni patén de Padué. Lé pacuuli a mwa mwaanu naa, pwohewii a bwomunen na e pii te Moosé wo Padué, he e habwii ten. ");
INSERT INTO cam_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","É alecehen, ke uce ni naîlé na lé pé céilé, he lé âcéi Iosua, ke lé pipwoeapwihi a amu Kanana ke lé mu lang. Be wo Padué, ke e caa peni ni bele na lé te mi mu lang ânebuhelé. Ke mepwo a mwa mwaanu naa, ke e mu lang dieli ha a benaamwon de pa daame *Davita. ");
INSERT INTO cam_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ke mepwo wo Davita, ke te junihe wâé nang ne he pwahamii Padué. Ke e ilehi kojaeng, pie me e pacuuli ace *mwaiitihi te a bele Isaraéla. ");
INSERT INTO cam_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ke wo *Solomona na e bo bahi a mwaiitihi te Padué. ");
INSERT INTO cam_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","«Kehe icehi ana wo Padué na nihe e daaité, ke time e uce mu he ni mwa na lé pwo ne ni apulie. Be e pii wo pa céiu péroféta pie: ");
INSERT INTO cam_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","E pii wo Padué pie: “A miiden, ke atebwo tong, ke a bwohemwo, ke aca tong. Ke he ace mwa celi woté celi me geé bahi me dong? É wé ace duaan celi o jan me é mu hen? ");
INSERT INTO cam_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","He time uce a ing na e pwo ati ni naado naa?”» Ésaïe 66.1−2 ");
INSERT INTO cam_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","E pii mwo wo Étienne te lépwo apihuô pie: «Te junihe mwoiu ni puniwé! Be muhi tewé me geé téne a pwooti te Padué! Ûhu! Geé te cuwo ko pipwobwonihi a *Jenen Iitihi, pwohewii lépwo caa tewé. ");
INSERT INTO cam_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Be lé pwotahi ne ko ni péroféta ati. Ke lé taunu ni béén na lé te mi piuti ânebun a bwo tuie te pana mwomwon nang, na e pipégalieng wo Padué. Ke te wogewé mwo na geé icueng, ke geé taunueng. ");
INSERT INTO cam_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Wogewé lépwona geé hegi ni patén de Padué na lé pipwaadeniin bé ne pelewé ne ni âcélo, ke time geé uce âcehin.» ");
INSERT INTO cam_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ke me lé téne ni pwooti naa wo lépwo apihuô, ke lé te junihe okéé kuti, ke lé piwii pecuwo ne ko Étienne. ");
INSERT INTO cam_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ke e ole kon a Jenen Iitihi, ke e niê da he miiden, ke e alihi a wâé te Padué, ke e ali Iésu na e pihuô ne *pwo a jui Padué. ");
INSERT INTO cam_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ke e pii pie: «Geé téne! É alihi a miiden he tehi. Ke e cuwo pwo a jui Padué wo pa *Nahi Apulie!» ");
INSERT INTO cam_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ke lé te cihe kuti me ubwo, ke lé capuhi ni pwojéénelé, ke lé te tai tétebé ne kon. ");
INSERT INTO cam_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ke lé céieng wie koja a pwomwo ubwo, ke lé ahieng ko péi, beme lé taunueng. Ke lé ne ni epwénelé ko ni a pa ewa aiu na pii kon pie Saulo. ");
INSERT INTO cam_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Me lé ko ahieng ko péi, ke e pwoiitihi pii pie: «Padaame Iésu, go hegi a jenung.» ");
INSERT INTO cam_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ke e tidihi jilin, ke e toii da pie: «Padaame, go pineulé ko a ta na lé pwo tong!» Ke é alecehe ni pwooti naa, ke e mele. ");
INSERT INTO cam_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Wo Saulo, ke e mu lang, ke te céiu jélé ko a bwo taunu Étienne. Ke é ha a tan naa, ke te nihe ubwo ngen a bwo pwotahinaado ne ko lépwo acéihi na lé mu *Iérusaléma. Ke lé muko pipiiden ati, ne he ni piduaan, ne ha a *Judé me ha a *Samari. Te icehi lépwo *apostolo na lé mu Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Pwo lépwo apulie na lé nihe pipwoiipilé ne ko Padué, ke lé pineduwo Étienne, ke lé te nihe é niimieng me ubwo. ");
INSERT INTO cam_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wo Saulo, ke e te nihe pwotahinaado ne ko lépwo acéihi. E taa he ni mwa, ke e céi wie ni aiu me ni toomwo, ke e nelé he karépu. ");
INSERT INTO cam_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Lépwoli acéihi li lé pipiiden, ke lé pétaapwo â he ni piduaan, ke lé cihe ko a Pwooti Wâé. ");
INSERT INTO cam_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","E ole wo Filip ne ha a pwomwo ubwo mu ko a *Samari, ke e cihe telé ko pa *Mesia. ");
INSERT INTO cam_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lé tabemi ehi nina e pii telé ati ne ni apulie na lé mu lang. Ke lé alihi ni *inenaado na pwojunuun na e pwo. ");
INSERT INTO cam_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Be ni duéé, ke lé wie mu ko ni apulie na cunu jélé, ke lé cihe me ubwo, ke hiwon ni tebwomwa me ni tebwa na wâé jélé. ");
INSERT INTO cam_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ke nihe ubwo a pipwodéén ne ha amu naa. ");
INSERT INTO cam_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","E te mi mu ha amu naa, pa apulie na pii kon pie Simon, pana e pwo pwoduéé. Ke e pipééeng me nihe pwonaado ne kon. Ke lé te nihe téele ko nina e pwo wo lépwo apulie ne ha amu Samari. ");
INSERT INTO cam_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Woélé ati, tabuhi mu ko lépwo cuwo nahi ewa die ko lépwo ukéiu, ke lé te nihe tabemieng ehi, ke lé tai pii ati pie: «Wo paje, ke e mu huîin a Junuu Padué na nye pii pie a Junuun Ubwo.» ");
INSERT INTO cam_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ke lé te nihe tabemieng kuti, be caa te nihe bwali a benaamwon, na e pwo me lé téele ko a bwo pwo pwoduéé ten. ");
INSERT INTO cam_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ke é he lé céihi ne ko Filip, na e pii telé a Pwooti Wâé ko a *Mwametau te Padué ke a nii Iésu Kériso, ke ni aiu me ni toomwo, ke puulé. ");
INSERT INTO cam_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ke e céihi mwo wo Simon, ke é alecehe a bwo puueng, ke caa time e uce engen koja Filip. E alihi nina pwojunuun me ni inenaado na ubwo na e pwo, ke te nihe emegéi nan mwo. ");
INSERT INTO cam_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lépwo apostolo na lé mu Iérusaléma, ke lé téne pie, lé caa hegi a pwooti te Padué wo lépwo apulie Samari. Ke lé ne nge céiilé Pétéru me Ioane. ");
INSERT INTO cam_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ke me lu tehene nge pelelé, ke lu pwoiitihi telé me lé hegi a *Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Be time e uce téele ole ko pace pibéélé. Mwo te ju puulé cehi ne he nii Padaame Iésu. ");
INSERT INTO cam_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ke lu ne ni ilu huîilé wo Pétéru me Ioane, ke lé hegi a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","É he e alihi wo Simon pie e ole huîi lépwo acéihi a Jenen Iitihi, he lu ne ni ilu huîilé wo lupwo apostolo, ke nimen me e ne telu ni mwani. ");
INSERT INTO cam_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ke e pii telu pie: «Geu ne tong a junuun naa, be mepie pwo pace céiu apulie celi me é ne a ing huîin, ke me e hegi a Jenen Iitihi.» ");
INSERT INTO cam_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kehe e pii ten wo Pétéru pie: «Wâé heme tiekeu me a mwani tem, be go niimihi pie, a âpipati te Padué, ke ace naado celi nye pwocuhin ko mwani! ");
INSERT INTO cam_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ke o te tice dem mu ko ni penem demu! Be é ne te Padué, ke te nihe ta a pwonimem. ");
INSERT INTO cam_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Go biteko koja ni âniimihinaado tem na ta, ke go pwoiitihi te Padué, beme e pineuhi ni bwo niimihi nen dem. ");
INSERT INTO cam_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Be é alihi pie e he pwonimem a pitaaba ke a pipwokon, ke e caa tiliko a ta.» ");
INSERT INTO cam_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ke e hegi ne telu wo Simon pie: «Lupwoje, geu pwoiitihi me dong, beme time uce tooéo ni naado na geu ko pii!» ");
INSERT INTO cam_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ke lu pii beetihi a pwooti te Padué wo Pétéru me Ioane. Ke é alecehen, ke lu mwojuia ne Iérusaléma. Ke é nge he pwaaden, ke lu pii beetihi a Pwooti Wâé ne he ni cuwo nahi amu na hiwon ne Samari. ");
INSERT INTO cam_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ke é ne ko Filip, ke e paciheeng a *âcélo te Padaame, ke e pii ten pie: «Go caamada, ke go â ha a pwaaden na e ole mu Iérusaléma ne Gaza, a pwaaden na time lé mu uce cuwo ko engen hen.» ");
INSERT INTO cam_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ke e te cuwoda kuti wo Filip, ke e engen, ke é he e mwo ko â he pwaaden, ke pitapitilu me pa céiu apulie Étiopi. Wo panaa, ke pa apulie na piubwo nang ne he ni pihuô ko ni mwani te Kandace, ê toomwo daame ne Étiopi. Be e mwojuia mu ha a pipwoun de Padué ne Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ke e ko pine, ne ha a otuun den, a tii na e tii wo péroféta Isaia. ");
INSERT INTO cam_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ke e pii te Filip a Jenen Iitihi pie: «Piâmwonuhi a otuun na e ko âbé!» ");
INSERT INTO cam_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ke e téte ngen wo Filip, ke e téne pali Étiopi he e ko pine a tii te péroféta Isaia. Ke e tahimwoeng wo Filip pie: «Go teko temehi ana go ko pine?» ");
INSERT INTO cam_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ke e hegi ne ten pie: «He me é woté ko ace bwo temehi nen, he te tice paceli me e patemehi tong?» Ke e ile Filip me e taa tebwo pelen. ");
INSERT INTO cam_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ke a niide a tii na e ko pine, ke e pii pie: Pwohewii a muto na lé teuueng ngen ne ha a mwotaunuhi wota. E pwohewii ne ko a nahi muto na e te ju mu me nye tali ni pumiin, be time e uce cihe. ");
INSERT INTO cam_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ke lé pwo me piwahin nang, ke lé pwo me ta ne kon. Ke de e bo pwojepule ko ni piebehieng? Te tice. Be caa tieden a mulihen mu éni pwo bwohemwo. Ésaïe 53.7−8 ");
INSERT INTO cam_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ke e tahimwo Filip wo pali apihuô pie: «He woo paceli e ko cihe kon wo pa péroféta ce? Ai e teko picihe kon mwo, ai e ko pii pace céiu mwo? É ileko pie, go pii tong.» ");
INSERT INTO cam_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ke e tabuhi pii pwaatihi ten wo Filip mu ko a bwopiinen naa, ke e pii beetihi ten a Pwooti Wâé ko Iésu. ");
INSERT INTO cam_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ke é he lu ko â he pwaaden, ke lu alihi a pihitabe, ke e pii te Filip wo pali apihuô pie: «Ade aceli e pacuwohi me puuéo, he caa neko a tabe?» { ");
INSERT INTO cam_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ke e hegi ne ten wo Filip pie: «Hemepie go céihi ati ne he pwonimem, ke jan me puuko.» Ke e hegi ne ten wo pali apihuô pie: «É céihi pie wo Iésu Kériso, ke pa *Naî Padué.»} ");
INSERT INTO cam_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ke e pacuwohi ali otuun, ke lu ole me Filip ne ha ali pihitabe, ke e puueng wo Filip. ");
INSERT INTO cam_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ke é he lu taamwo mu ha a tabe, ke e pé Filip a Jenen Iitihi, ke caa time e bo uce alieng mwo wo pali apihuô. Kehe icehi ana nihe piwâénimen, ke e te uti a pwaadeniin. ");
INSERT INTO cam_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ke e bwo ne Filip ne Azot ali Jenen Iitihi. Ke é mulang, ke e â Césaré wo Filip, ke é nge he pwaaden, ke e patemehi a Pwooti Wâé na ati he ni cuwo nahi amu. ");
INSERT INTO cam_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","É ha a benaamwon naa, ke e te junihe okéé wo Saulo. Ke nimen me e taunu nina lé céihi ne ko Padaame Iésu ke e hane ace bwopwonen. Ke e â too pa *daame he lépwo apwoâpwailo. ");
INSERT INTO cam_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Ke e ileeng pie me e tii ace tii te lépwo apihuô te ni *mwotapitihi te ni *Juif ne Damas. A tii naa, ke e ne a mwomwon den me e imwi nina lé céihi na e toolé, ni aiu me ni toomwo na lé âcéi Iésu, beme e péélé bé ne *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ke é he e ko â ha a pwaaden nge Damas, ke me e âmwonuhi lang, ke e te opé kuti mu he miiden a pwéélang, ke e pwéélang aujenieng. ");
INSERT INTO cam_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ke e te tupwo kuti ne pwo bwohemwo, ke e téne a pwocihe na e pii ten pie: «Saulo, Saulo, é ko ade na go pwotahi ne kong?» ");
INSERT INTO cam_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Te junihe mwoti Saulo kuti ke e tahimwohi pie: «Wogo ke woo, go pa daame?» Ke e hegi ne ten wo Padaame pie: «Woéo Iésu, pana go ko pwotahi ne kong. ");
INSERT INTO cam_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Go cuwoda, ke go taa ha a pwomwo ubwo Damas be o bo pii tem nelang aceli me go pwo.» ");
INSERT INTO cam_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ke lé cuwo ne ni apulie na lé âcéin, ke te junihe emegéi nalé, ke time lé temehi aceli me lé pii. Be lé te téne a pwocihe, kehe icehi ana te tice apulie celi lé alihi. ");
INSERT INTO cam_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ke me e cuwoda mu pwo bwohemwo wo Saulo, ke he e teko niê, kehe icehi ana caa time e uce alikenye. Ke lé bwo te ju pétaa ko in, ke lé pééeng nge Damas. ");
INSERT INTO cam_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ke cié ni tan na e mu hen, ke time e uce alikenye, ke time e uce wiinaado, me ûdu. ");
INSERT INTO cam_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","E mu Damas wo pa céiu acéihi na pii kon pie Ananias. Ke e pihabwiieng den wo Padaame, ke e pii ten pie: «Ananias!» Ke e hegi ne ten pie: «Padaame, woéo-ni!» ");
INSERT INTO cam_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ke e pii ten wo Padaame pie: «Go cuwoda, ke go â ha a pwaaden na pii kon pie ‘Mwomwon ko pwaaden’. Ke go hane ha a pomwa te Judas, pa apulie mu Tarse na pii kon pie Saulo. Be e ko pwoiitihi, ke é ne me e alihi ne ha a jenen ");
INSERT INTO cam_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","pa apulie na a niin pie Ananias na e ko taabé, ke e ne ni in huîin, beme e niê mwo.» ");
INSERT INTO cam_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ke e hegi ne ten wo Ananias pie: «Padaame, hiwon ni apulie na lé pii tong ati ni naado na ta na e pwo wo pa apulie naa, te ni naîm na lé céihi ne ko Iésu ne Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ke e éni, imi a mwomwon na lé ne ten wo lépwo caa te lépwo apwoâpwailo, beme e imwi ati ni apulie na lé pipaunuko.» ");
INSERT INTO cam_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Kehe icehi ana e hegi ne ten wo Padaame pie: «Go ân, be é caa pipégali pa apulie naa, beme pa bépenem dong. E bo pipatemehi a niing ne he pwahamii ni bele me ni daame helé, ke é ne mwo he pwahamii a bele *Isaraéla. ");
INSERT INTO cam_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ke é bo habwii ten ati ni picani ke ni téé na e bo mu hen, watihen a niing.» ");
INSERT INTO cam_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ke e te wie kuti wo Ananias, ke e engen. Ke e â taa ha a mwa na e mu hen wo Saulo, ke e ne lupwo in huîin. Ke e pii ten pie: «Saulo, pa bééng: E pahedeéo wo Padaame Iésu, wo Padaame li e pihabwiieng dem ne pwo pwaaden. Ke e neéo bé, beme go niê mwo, ke me tiliko na a *Jenen Iitihi.» ");
INSERT INTO cam_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ke e te tupwo kuti mu hamii Saulo nina pwohewii ni ude-ikua, ke e caa niê mwo. Ke é alecehen, ke e cuwoda, ke puueng. ");
INSERT INTO cam_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ke e wiinaado, ke pwo niihen mwo. Mwo te pwo mwo ni tan de Saulo ne Damas pele ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ke e te pwome patemehi kuti a pwooti nge he ni mwotapitihi. Ke e pii beetihi telé pie, te wo Iésu kuti pa *Naî Padué. ");
INSERT INTO cam_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ati nina lé tabemieng, ke lé te junihe téele. Ke lé pii pie: «He time uce weeng kuti, pali te junihe pwo niihen me e pwotahi ne ko nina lé pwoiitihi ne he nii Iésu ne Iérusaléma? Ke li e pwo me e âmwobé imwilé ne mwo éni, ke me e péélé nge céii ni caa te lépwo apwoâpwailo!» ");
INSERT INTO cam_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kehe icehi ana te piubwo da a junuu Padué ne ko ni bwo cihe te Saulo. Ke e patemehi te lépwo Juif mu Damas, pie wo Iésu, ke pa *Mesia. Ke time lé temehi ace bwo hegi nen den. ");
INSERT INTO cam_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Caa pwo a benaamwon de Saulo pelelé, ke lé pipitilé wo lépwo Juif, ke lé piténelé beme lé taunueng. ");
INSERT INTO cam_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ke é ati he ni bwén, ke pwang, ke lé wéa kon ne he ni pomwa ko a pwomwo ubwo, beme lé taunueng. Kehe icehi ana e caa â temehi anaa wo Saulo. ");
INSERT INTO cam_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ke é he bwén, ke lé pwo me e cela wo lépwo acémun den; ke lé neeng ole ha a élele tai, ke lé neeng ole ko a goomwa babé ko a pwomwo ubwo. ");
INSERT INTO cam_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Ke é he e â Iérusaléma wo Saulo, ke e hane ace bwopwonen beme e â too lépwo acéihi. Kehe icehi ana tai mwotilé kon, be time lé uce mwomwohi pie caa pa céiu acéihi. ");
INSERT INTO cam_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ke e picani ten wo Barnabas, ke e pééeng nge céii lépwo apostolo, ke e piuti telé pie: «Wo Saulo, ke e ali Padaame ne pwo pwaaden, ke e paciheeng wo Padaame. Ke time uce piwâ nang me e patemehi a Pwooti Wâé ne he nii Iésu ne Damas.» ");
INSERT INTO cam_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Tabuhi mulang, ke e caa mu pele lépwo *apostolo wo Saulo. Ke e âdé ke âbé me lépwo apostolo ne Iérusaléma, ke e patemehi mwoiuhi nelang a Pwooti Wâé ne he nii Padaame. ");
INSERT INTO cam_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ke e pacihe mwo lépwo Juif na lé cihe he pwo *grek. Kehe icehi ana lé pééleeng ko ana e pii telé, ke lé hane ace bwopwonen beme lé taunueng. ");
INSERT INTO cam_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Ke me lé temehi anaa wo lépwo acéihi, ke lé pééeng nge Césaré. É mulang, ke lé pwo me e â Tarse. ");
INSERT INTO cam_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","É ha a benaamwon naa, ke lé mulie ne ha a péém wo lépwo acéihi ati he ni amu *Judé, Galilé, ke *Samari. Lé pipamwoiulé, ke paciiti Padué. Ke e pitaa a jéhilé, be e picani telé na a Jenen Iitihi. ");
INSERT INTO cam_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Wo Pétéru, ke e caniê ngemwo ni acéihi ati he ni amu, ke e ole die pele lépwona lé mu Lida. ");
INSERT INTO cam_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ke é nelang, ke e too pa céiu apulie na pii kon pie Éné, na e caa pwo 8 ni jo ko a pule pwo apule ten, be tebwomwa nang. ");
INSERT INTO cam_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ke e pii ten wo Pétéru pie: «Éné, e pwo me wâé go ni wo Iésu Kériso! Go cuwoda, ke go capipihi apule tem!» Ke e te cuwoda kuti. ");
INSERT INTO cam_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ke me lé alihi anaa, ke lé céihi ne ko Padaame ati ne ni apulie Lida me Saron. ");
INSERT INTO cam_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","É ne pele lépwo acéihi ne Jopé, ke pwo ê toomwo na pii kon pie Tabita he pwo *ébéru ke Dorkas he pwo grek. Ke ênaa, ke te a penem den me e pwo nina wâé. Ke e picani te nina pwoééhelé. ");
INSERT INTO cam_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ke é ha a benaamwon naa, ke cunu nang, ke e mele. É alecehe a bwo papiwonieng, ke lé pééeng da ha a nemwa na e da ko miiden. ");
INSERT INTO cam_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ke me lé temehi ne ni acéihi na élé Jopé pie, wo Pétéru ke e Lida, ke lé pahede ngen lupwo alo béélé me lu â pii ten pie, me e piepin bé pelelé. Be time uce e ité Lida me â Jopé. ");
INSERT INTO cam_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ke e te âcéilu kuti wo Pétéru. Ke me e tehene ngen, ke lé pééeng da ha a nemwa na e ko miiden. Ke ati ni toomwo depwele, ke lé é bé beniieng, ke lé habwii ten ni epwén na e pwo wo Dorkas, he e mwo mulie. ");
INSERT INTO cam_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ke e pawielé ati wo Pétéru, ke e tidihi jilin, ke e pwoiitihi, ke e biteeng ne ko ali éé apulip, ke e pii ten pie: «Tabita, go cuwoda!» Ke e te niê kuti wo Tabita, ke me e ali Pétéru, ke e te caama tebwo kuti. ");
INSERT INTO cam_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ke e pétaa ngen wo Pétéru, ke e pwiieng. Ke é alecehen, ke e tode ati ni acéihi, ni toomwo depwele me ni béé apulie, ke e habwii Tabita telé, pie e caa mulie mwo. ");
INSERT INTO cam_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ke lé téne a jepule naa, ati ne ni apulie Jopé, ke te junihe hiwon nina lé céihi ne ko Padaame. ");
INSERT INTO cam_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Caa pibwoli Pétéru Jopé, ke e pimu pele pa apulie na pii kon pie Simon, pa apenem ko iiwota. ");
INSERT INTO cam_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pwo pa apulie na e mu Césaré na pii kon pie Korneï. Pa Roma, pa céiu caa te ni 100 coda ne ha a mwocoda te lépwo Itali. ");
INSERT INTO cam_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Pa apulie naa, ke e céihi ne ko a pwoiitihi te lépwo *Juif, weeng me ni apulie na lé mu ha a pomwa ten. E te nihe pati lépwo Juif na tice delé, ke e te pwoiitihi te Padué. ");
INSERT INTO cam_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","É ha a céiu tan, he ko cié inetéale ko alecehe a goahen, ke e pwoiitihi, ke e te ju ali ehi pa *âcélo te Padué, he e ko â taadeeng ne huâ, ke e pii ten pie: «Korneï!» ");
INSERT INTO cam_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ke e te ju omeeng ehi wo Korneï, ke te nihe mwotieng, ke e pii pie: «Ade, go Padaame?» Ke e pii wo pali âcélo pie: «E caa hegi a pwopwoiitihi tem wo Padué. Ke e alihi ati ni âpipati tem ne pele nina pwoééhelé, ke time e uce pineuko. ");
INSERT INTO cam_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Wâé heme go ne nge Jopé ce apulie, beme lé â todebé Simon, pana te pii kon mwo pie Pétéru. ");
INSERT INTO cam_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","E pimu pele Simon, pa apenem ko iiwota, na e mu pejié.» ");
INSERT INTO cam_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ke e caa te engemwo wo pali âcélo li e paciheeng. Ke wo Korneï, ke e tode lupwo apulie na alo julu, mu pele lépwo apenem den. Ke e tode mwo pa céiu coda ten, mu hadenii ni coda na e pihuô telé, pa coda na caa nihe bwolieng pelen; pana e te pipwoiipieng ne ha a pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Alecehe a bwo uti telé ati nina e tuie ne kon wo Korneï, ke e nelé nge Jopé. ");
INSERT INTO cam_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","A tan alecehen, he e teko ju goahen ehi, ke lé piâmwonuhi a pwomwo ubwo Jopé. É ha a benaamwon naa, ke e taa pwo mwa he na belece lang wo Pétéru, beme pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ke menen, ke nimen me e wiinaado. Ke é he lé mwo ko piwâam ko a wiinaado ten, ke e habwii ni naado wo Padué te Pétéru ne ha a jenen. ");
INSERT INTO cam_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ke e alihi a miiden he tehi, ke e opé mulang ana pwohewii a cehitaap na nihe ubwo, na cie ni uhin na paa. Ke e opé die pwo bwohemwo. ");
INSERT INTO cam_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ke e mu hen ati ni pétaapwo wota na pipaa ni alé, ke ni paile me ni âmutaa me ni bwien, me ni meni mwo. ");
INSERT INTO cam_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ke e pii ten a pwocihe pie: «Go cuwoda, go Pétéru, ke go taunuhi, ke go wii!» ");
INSERT INTO cam_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Kehe icehi ana e pii wo Pétéru pie: «Ûhu! Te muhi tong, go Padaame, be time é mu uce wii ni naado na iitihi ne he ni patén.» ");
INSERT INTO cam_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ke e téne mwo ali pwocihe, he e pii ten pie: «Go nemwo pii me ta, nina e pii wo Padué pie te wâé.» ");
INSERT INTO cam_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Ke ocié ko tuie ni naado naa, ke e caa te taamwo he miiden ali cehitaap. ");
INSERT INTO cam_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ke é ha a benaamwon naa, ke wo lépwoli apulie li e nelé bé wo Korneï, ke lé pitahimwohi he celi e lang ace pomwa te Simon. Ke lé piân, ke lé tuie nge ha ali pomwa, ha a benaamwon na wo Pétéru he e mwo ko pihane ace bwopiine ali e ko habwii ten wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ke lé to, ke lé tahimwohi pie: «Be he te éni kuti, he celi e pimu lang wo Simon, na pii kon pie Pétéru?» ");
INSERT INTO cam_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","E mwo tee ko pitautinaado wo Pétéru ne ko ali e alihi, ke e pii ten na a *Jenen Iitihi pie: «Élé éni wo lépwo apulie na cié jélé na lé haneko. ");
INSERT INTO cam_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Go cuwoda me go ole, ke go nemwo uce pwo me piwâ go me go âcéilé, be woéo na é nelé bé.» ");
INSERT INTO cam_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Ke e ole wo Pétéru, ke e pii te lépwo apulie naa pie: «Woéo-ni pali apulie li geé ko haneéo. Ade ace watihen me geé âbé?» ");
INSERT INTO cam_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Ke lé hegi ne ten pie: «E pahedekeme wo Korneï, pa caa te coda, pa apulie na mwomwon nang, ke e céihi ne ko a pwoiitihi te lépwo Juif. Ke ati lépwo Juif, ke lé pipii me wâé nang. E pihabwiieng den wo pa âcélo te Padué, ke e pii ten pie me e pwo me go âbé ne ha a pomwa te Korneï, beme e téne celi go pii ten.» ");
INSERT INTO cam_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ke e tanyuulé wo Pétéru me lé mwo pule. É ha acaama hen, ke e caa te âcéi lépwo apulie na cié jélé naa wo Pétéru. Ke lé âcéilé mwo wo lépwo béé acéihi na lé mu Jopé. ");
INSERT INTO cam_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","É ha a tan alecehen, ke lé tuie nge Césaré. Ke e teko ucéilé lang wo Korneï me lépwo apulie ha a pwomwoiu ten, me lépwo ju béén na e te todelé bé. ");
INSERT INTO cam_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Me e taa wo Pétéru, ke e â beniieng wo Korneï, ke e tidihi jilin, ke e miibule ne ko ni a Pétéru. ");
INSERT INTO cam_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kehe icehi ana e pwiieng da wo Pétéru, ke e pii ten pie: «Go cuwoda, be woéo, ke te pa apulie pwohewiiko!» ");
INSERT INTO cam_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","E tee ko cihe ko taa huâ wo Pétéru. Ke e too ni apulie na hiwon jélé, na lé caa teko mu lang. ");
INSERT INTO cam_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ke e pii telé pie: «Geé caa te tai temehi pie wo pa Juif, ke iitihi me pibéélu me pa coho. Ke e paciitihi kon mwo me e taa pelen. Kehe icehi ana wo Padué, ke e habwii tong pie, me é nemwo niimihi pie me ta pa apulie, ke me é nemwo pwo me muhi tong kon. ");
INSERT INTO cam_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ke me geé todeéo bé, ke te tice aceli me mwo pitoole jo kon. Ke é tahimwokewé pie: De ace watihen me geé pwo me é âbé?» ");
INSERT INTO cam_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ke e pii ten wo Korneï pie: «Caa cié ni tan jenaa, na é pwoiitihi ne éni, ke é ko cié inetéale ko alecehe a goahen. Ke e te piâbeetiéo kuti wo pa apulie na pwomelaa a epwénen. ");
INSERT INTO cam_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Ke e pii tong pie: “Korneï, e caa hegi a pwopwoiitihi tem wo Padué. Ke e caa alihi ati ni âpipati tem ne pele nina pwoééhelé, ke time e uce pineuko. ");
INSERT INTO cam_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Wâé heme go ne nge Jopé ce apulie, beme lé â todebé Simon, pana te pii kon mwo pie Pétéru. E pimu pele Simon, pa apenem ko iiwota, na e mu pejié.” ");
INSERT INTO cam_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Ke anaa, na é pawie epin lé ni apulie, beme lé todeko, ke te junihe wâé kuti na go âbé. Be é jenaa, ke caa tai wogeme éni ati he pwahamii Padué, beme geme téne ati ce naado celi e caa ne tem wo Padaame beme go pii teme.» ");
INSERT INTO cam_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","E pii beetihi telé wo Pétéru pie: «É bwo teko temehi kuti pie, mepwo wo Padué, ke time e uce pipwoinen ne ko ni apulie. ");
INSERT INTO cam_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Be é ati he ni amu, ke wo pa apulie na e paciiti Padué, me e pwo nina wâé, me pipati, ke e piwâéeng wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","E caa pawie a pwooti, me de a bele *Isaraéla: a Pwooti Wâé ko a péém, na e pwaadeniin bé wo Iésu Kériso, Padaame he ati ni apulie. ");
INSERT INTO cam_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","«Geé caa te temehi ana e tuie ânebun ne Galilé, ke é mulang, die ati he ni piduaan ko a *Judé, ne alecehe a bwo patemehi na a pipuu apulip te Ioane. ");
INSERT INTO cam_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Geé caa temehi pie wo Padué, ke e neole a junuu a Jenen Iitihi ne ko Iésu, pa apulie mu Nazaret. E engen ati he ni piduaan me e pwo nina wâé. Ke e pwo me wâé nina cunu jélé me ati ni béén na e kolé a junuu *Caatana, be e pelen wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","«Wogeme kuti lépwo *apajuujuhi na ati nina e pwo, ne *Iérusaléma, die ha ati a amu te lépwo Juif. Lé cemeiteeng ne ko a *kuricé, ke e mele. ");
INSERT INTO cam_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","«Kehe icehi ana wo Padué, ke e pwo me e mulie mwo, ha a béciéhe ni tan. Ke e pwo me e piâbeetikeme. ");
INSERT INTO cam_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wogeme ni béén na e caa pipégalikeme ânebun, beme geme bo lépwo apé na a juuju te Iésu. Wogeme ni béén na geme tai piwiinaado me ûdu me weeng, alecehe a bwo mulie cemwo ten koja ni amele. Time e uce pwo me e pihabwiieng de ati a bele. ");
INSERT INTO cam_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Ke e caa pahedekeme, beme geme â patemehi te a bele a Pwooti Wâé, me pii beetihi pie caa te weeng kuti, pana e caa neeng wo Padué me pa atauti nina lé mulie, me nina lé mele. ");
INSERT INTO cam_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","«Ke, ati ni péroféta, ke lé caa mi pii pie, paceli e céihi ne kon, ke o pineuhi ni ta pwo ten ne he niin.» ");
INSERT INTO cam_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","É he e mwo ko cihe wo Pétéru, ke e ole a Jenen Iitihi ne huîi ati nina lé tabemi a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Wo lépwo Juif na lé céihi, li lé âbé céi Pétéru, ke lé téele, he e homwo mwo a Jenen Iitihi ne huîi ni béén na time uce ni Juif. ");
INSERT INTO cam_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Be lé ténelé he lé ko cihe he ni pwooti na te pi-ité, me pipaunu Padué. Ke e pii wo Pétéru pie: ");
INSERT INTO cam_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Woté, o te jan me time nye uce puu lépwona lé caa hegi a Jenen Iitihi, pwohewiikenye?» ");
INSERT INTO cam_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ke e ne a mwomwon wo Pétéru, beme puulé ne he nii Padaame Iésu. Ke lé ileeng pie me e mwo pwo mwo lupwoce tan pelelé. ");
INSERT INTO cam_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Lépwo *apostolo me lépwo acéihi na lé mu *Judé, ke lé téne pie lépwo béén na time uce lépwo *Juif, ke lé caa hegi a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ke é he e taa *Iérusaléma wo Pétéru, ke wo lépwo acéihi juif, ke lé taapwii ten nina e pwo, ");
INSERT INTO cam_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","ke lé pii ten pie: «É ko ade na go â taa pele lépwona mwo time uce *tegoop jélé, me geé piwiinaado ibu?» ");
INSERT INTO cam_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ke wo Pétéru ke e piuti telé ehi ni naado na e tuie ne kon, ha atabuhi ko a jepule naa. Ke e pii telé pie: ");
INSERT INTO cam_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«É mu ha a pwomwo ubwo Jopé, ke é ha a benaamwon na é ko pwoiitihi hen, ke é alihi a céiu naado na pwohewii a cehitaap na nihe ubwo na cie ni uhin na paa, he e ko opé mu he miiden die pelong. ");
INSERT INTO cam_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Ke me é omehi a cehitaap naa, ke é alihi ne hen ni wota na pipaa ni alé, me ni wota apiaba, ke ni paile me ni âmutaa me ni bwien, me ni meni mwo. ");
INSERT INTO cam_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ke é téne a pwocihe na e pii tong pie: “Go cuwoda go Pétéru, ke go taunuhi, ke go wii.” ");
INSERT INTO cam_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","«Kehe é pii pie: “Ûhu, go Padaame, be time é mu uce wii ni naado na iitihi ne he ni patén.” ");
INSERT INTO cam_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","«Ke é téne mwo ali pwocihe mu he miiden, na e pii pie: “Go nemwo pii me ta nina e pii wo Padué pie te wâé.” ");
INSERT INTO cam_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ke ocié ko tuie ni naado naa, ke é alecehen, ke tai céilé daamwo he miiden.» ");
INSERT INTO cam_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","«Ke lé te pwome tehenebé wo lépwo apulie na cié jélé, na nelé bé céiiéo mu Césaré. Ke lé âbé cuwo he pomwa ko a mwa na é mu hen. ");
INSERT INTO cam_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ke e pii tong a *Jenen Iitihi pie, me é nemwo pwo me piwâ jo me é âcéilé. Ke lé âbé céing lépwo acéihi na 6 jélé na élé éni, ke geme taa ha a mwa te Korneï. ");
INSERT INTO cam_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","«Ke e piuti teme wo Korneï a bwo alihi nen den ne ha a mwa ten, pa *âcélo na e âbeetieng, ke e pii pie: “Ne ngen lépwoce ne Jopé, beme lé pwo me e âbé wo Simon, pana lé pii mwo kon pie Pétéru. ");
INSERT INTO cam_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Pana e bo pii tem ni pwooti te Padué, na e bo celuimiko, wogo, ke tai ati a pwomwoiu tem.”» ");
INSERT INTO cam_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","«Ke me é tabuhi cihe te Korneï me lépwo béén, ke e ole kolé a Jenen Iitihi, pwohewii ne konye ha atabuhi kon. ");
INSERT INTO cam_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Ke é niimihi ali pwooti te Padaame: “E *puu apulie ko a tabe wo Ioane, kehe bo puukewé ko a Jenen Iitihi.” ");
INSERT INTO cam_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","«Wo Padué, ke e ne telé a âpipati na pwohewii ana ne tenye, wogenye na nye caa céihi ne ko Padaame Iésu Kériso. Woéo ke he woo, me é cubwoni Padué?» ");
INSERT INTO cam_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Alecehe a bwo téne na anaa, ke caa nebwén na lé okéé. Ke lé pipwoun de Padué, ke lé pii pie: «Wo Padué, ke e caa ne mwo a pininim ne pele lépwona time uce lépwo Juif, beme lé mulie.» ");
INSERT INTO cam_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Alecehe a bwo mele te Étienne, ke lé tabuhi pwo me lé mu he ni picani wo lépwo acéihi, ke lé pipiiden nge he ni amu, é Fénisi, ke é Antioche, ke é pwo a één Chipre. Ke lé te â cihe te lépwo Juif cehi, ko a Pwooti Wâé. ");
INSERT INTO cam_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kehe icehi ana wo lépwo béén mu pelelé, lépwo apulie mu Chipre, ke é Cirène, ke lé âbé ne Antioche, ke lé cihe ko a Pwooti Wâé te Padaame Iésu te lépwona time uce lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ke e mu huîilé a junuu Padué, ke hiwon mwo ni apulie na lé bitelé ne ko Padaame, ke lé céihi. ");
INSERT INTO cam_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ke lé téne anaa wo lépwo acéihi ne Iérusaléma. Ke lé ne Barnabas nge Antioche. ");
INSERT INTO cam_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ke me e tehene ngen, ke e alihi a *adéihi te Padué ne huîi a bele, ke e te junihe pipwodéén. Ke e pamwoiulé ati, beme lé cumang ati he ni pwonimelé, ne ko Padaame. ");
INSERT INTO cam_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Be wo Barnabas, ke pa apulie na te nihe wâé nang, ke tilieng na a Jenen Iitihi, ke te nihe ubwo a céihi ten. Ke a hiwon ko apulie, ke lé céihi ne ko Padaame. ");
INSERT INTO cam_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ke é mulang, ke e â Tarse wo Barnabas, beme e â hane Saulo. ");
INSERT INTO cam_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ke me e tooeng, ke e pééeng bé ne Antioche ne Siri. É he na céiu jo, ke lu mu he ni pitihi ko pwoiitihi, ke lu pacémunihi a hiwon ko apulie. Ke é mu Antioche he na lé tabuhi pii ko lépwo acéihi pie, lépwo chrétien a bwopiinen pie ‘lépwo acéihi ne ko Kériso’. ");
INSERT INTO cam_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","É ha a benaamwon naa, ke lé opé mu Iérusaléma ne Antioche wo lépwo péroféta. ");
INSERT INTO cam_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Pa céiu béélé, ke a niin pie Agabus. Ke e mu kon a junuu a Jenen Iitihi. Ke e cuwoda, ke e pii telé pie: «O bo pwo ace menele celi nihe ubwo ati ne pwo a bwohemwo.» Ke o cuwo a bwopiinen naa, ha a benaamwon de Klaude, pa daame ubwo te lépwo Roma. ");
INSERT INTO cam_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ke é ne ko lépwo acéihi, ke lé piténelé beme lé ne ngen ce bépicani te lépwo acéihi na lé mu Judé. Ke lé te muko ne, na te jan me lé ne âcehi nina lé pé mu ko ni penem delé. ");
INSERT INTO cam_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ke lu pé ngen ni âpipati naa wo Barnabas me Saulo, nge céii lépwo apihuô te ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","É ha a benaamwon naa, ke e pwotahi ne ko ni béé acéihi wo pa daame *Érode Agripa Ier. ");
INSERT INTO cam_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ke e ne a mwomwon beme lé taunu Cang, pa âjiéne Ioane, ko teua. ");
INSERT INTO cam_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ke me e alihi pie wâé te lépwo Juif, ke e ne me imwi mwo Pétéru, ha a céiu tan ubwo telé, a tan ko pieni pwoloa na tice nyaa ten. ");
INSERT INTO cam_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ke e pwo me tahieng da he karépu, ke e ne me lé wéieng nina paa ni bele na pipaa ni coda ne hen. Be nimen me e tauti Pétéru ne he pwahamii ni apulie ati, alecehe a tan ubwo ko *Pacika. ");
INSERT INTO cam_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ke lé wéi Pétéru ne he karépu. Ke mepwo ni acéihi, ke lé te mwoiu ko pwoiitihi me den. ");
INSERT INTO cam_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","É ha a bwén ânebuhe a bwo tautieng, ke wo Pétéru, ke e pule ha awieme lupwo alo coda. Ke cieeng ko ni itihe toki ne ko lupwoli coda. Ke pwo mwo ni coda na lé cuwo he pomwa ko a karépu, beme lé wéieng. ");
INSERT INTO cam_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kehe icehi ana e te tuie kuti wo pa céiu *âcélo te Padaame, ke te ju pwéélang kuti ha ali karépu. Ke wo pali âcélo, ke e ti ko a céiu duaa Pétéru, ke e paûmiêeng. Ke e pii ten pie: «Go cuwoda epin!» Ke e te tupwo kuti mu ko lupwo i Pétéru li itihe toki. ");
INSERT INTO cam_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ke e pii ten wo pali âcélo pie: «Go cieko ko a taihenam, ke go cuwohe lupwo dihibwaam.» Ke e te piténedeeng wo Pétéru. Ke e pii ten mwo wo pali âcélo pie: «Go cuwohe a palito tem, ke go âbé céing.» ");
INSERT INTO cam_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ke e âcéin mu he karépu wo Pétéru. Kehe icehi ana time e uce temehi pie, nina e pwo ten wo pali âcélo, ke te ni juuju. Be e niimihi pie a niûn. ");
INSERT INTO cam_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lu wédeni ni coda na lé wéa ânebun, ke lu wédeni mwo nina lé cuwo lang. Ke lu tehene nge ko a pomwa toki: a babé ko a pwomwo ubwo. Ke e te pitehi cehi ne ânebuhelu, ke lu wie, ke lu â ha a céiu pwaaden. É mulang, ke te tie kuti pali âcélo. ");
INSERT INTO cam_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Ke e bwo mwojuia mwo a pwonime Pétéru, ke e pii pie: «Te a juuju kuti! É jenaa ni, ke é bwobe temehi pie, e pawiebé pa âcélo ten wo Padaame, beme e celuimiéo mu ha a pihuô te Érode! Ke e celuimiéo koja ni ta na lé pwo me lé pwo tong na a bele te lépwo *Juif na lé pipwobwonikeme.» ");
INSERT INTO cam_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","É alecehe anaa, ke e â ha a pomwa te Maria, nyaa te Ioane na pii kon mwo pie Maréko. Lé teko mu lang a céiu a hiwon ko ni acéihi, be lé teko pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Ke e cii a pomwa wo Pétéru, ke e âbé wo Roda me e tehi. Wo êje, ke ê eabwé ha a pwomwo naa. ");
INSERT INTO cam_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ke e téne temehi a pati Pétéru, ke te junihe piwâénimen. Ke e téte ngen, ke e pii pie: «Éé, wo Pétéru na e âoté pwomwo!» Ke e pineuhi me e tehi ali pomwa! ");
INSERT INTO cam_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ke lé pii ten pie: «Go piolo, go êje!» Ke e hegi ne telé pie: «Uhuu! É te juuju.» Ke lé pii ten mwo pie: «Ûhu! Wieli a jenen.» ");
INSERT INTO cam_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","É he lé mwo ko picihe, ke e tee mwoiu ko cii ali pomwa wo Pétéru! Ke me lé tehi ali pomwa, ke lé te junihe téetieng kuti. ");
INSERT INTO cam_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ke e pwo inenaado telé ko a in, pie me lé nemwo cihe. Ke e piuti telé a bwo pawieeng mu he karépu. Ke e pii telé mwo pie: «Wâé heme geé bo pii te Cang, me ni béé acéihi béénye.» Ke e wie kojalé, ke e â ha a céiu duaan. ");
INSERT INTO cam_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Ke me pwang daabé, ke lé âdé ke âbé wo lépwo coda. Ke lé te junihe gia, be time lé uce temehi he celi e lang wo Pétéru, ke te junihe mwotilé. ");
INSERT INTO cam_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ke e pwo me lé haneeng wo Érode, kehe icehi ana time lé uce tooeng. Ke e pwo me tahimwo lépwo awéa, ke e ne a mwomwon beme taunulé. É alecehen, ke e ole wo Érode mu *Judé ne Césaré, beme e pimu lang. ");
INSERT INTO cam_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","E te nihe okéé wo pa daame naa, wo Érode, ne ko lépwo apulie Tir me lépwo apulie Sidon. Ke lé piténelé wo lépwonaa, ke lé âbé alieng beme lé ilehi kojaeng a péém. Be lupwo amu naa, ke lé mulie mu ko a amu te Érode. Ke lé ne me pa pwaadeniilé wo Blaste, pa apenem de pa daame, ke pa caa te penem he mwodaame. ");
INSERT INTO cam_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ke é ha a tan na e caa pipégali wo Érode, ke e cuwohe ni epwénen he daame, ke e taa tebwo pwo atebwo he daame, ke e cihe te ni apulie naa. ");
INSERT INTO cam_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ke lé te nihe picedieng, ke lé pii pie: «Éé! Time uce wo pa apulie na e cihe, kehe caa te wo padué!» ");
INSERT INTO cam_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ke é ha a benaamwon naa, ke e ahi Érode wo pa âcélo te Padaame, be time uce nime Érode me e pipwoun de Padaame, kehe te nimen me e te pipwoun den. Ke lé wiieng ne ni béle, ke e mele. ");
INSERT INTO cam_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Ke a pwooti te Padué, ke caa nihe piân. ");
INSERT INTO cam_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Wo Barnabas me Saulo, ke lu caa panebwénihi ni penem delu ne ko lépwo acéihi ne *Iérusaléma. Ke lu engemwo, woélé me Ioane na pii kon mwo pie Maréko. ");
INSERT INTO cam_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","É ne pele ni acéihi ne Antioche ha a province Siri, ke caa pwo ni péroféta me ni béén na lé pacémuni ni acéihi: wo Barnabas, Siméon, pana lé pii kon pie ‘pa Apulie Bwiile’; Lucius mu Cirène; Manaën, pana lé picilelu ibu me gupéno *Érode Antipas; ke wo Saulo. ");
INSERT INTO cam_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ke pwo a benaamwon na lé patupwo wiinaado me ûdu, beme lé pwoiitihi te Padaame. Ke e pii telé na a *Jenen Iitihi pie: «Geé pineité Barnabas me Saulo ne ko a penem na é todelu ne kon.» ");
INSERT INTO cam_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","É alecehe a bwo time wiinaado telé me pwoiitihi telé, ke lé ne ni ilé ne huîilu beme adéilu ke lé nelu me lu engen. ");
INSERT INTO cam_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","E pahede Barnabas me Saulo na a Jenen Iitihi. Ke lu ole Sélusi, ke é mulang, ke lu engen pwo ong, nge pwo a één Chipre. ");
INSERT INTO cam_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Ke me lu tehene nge Salamine, ke lu patemehi a pwooti te Padué ne he ni *mwotapitihi te lépwo *Juif. Ke e âcéilu wo Ioane-Maréko, beme e picani telu. ");
INSERT INTO cam_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ke me lu caa â engen pitihi a één, die ha a pwomwo ubwo Pafos, ke lu too pa céiu Juif na pii kon pie Bar-Iésu. Wo pa apulie naa, ke pa apwotuté, ke e pii pie weeng, ke pa péroféta te Padué. ");
INSERT INTO cam_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Wo panaa, ke pa béé Sergius Paulus, pa gupéno pwo a één naa, pa apulie na e pitemang. Ke e tode Barnabas me Saulo wo pa gupéno, be te junihe nimen me e téne a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Kehe icehi ana wo pali apwotuté, na pii kon mwo he pwo *grek pie Élimas, ke e hane beme e bitehi a bwo temehi nen de gupéno, beme e nemwo céihi ne ko a pwooti. ");
INSERT INTO cam_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ke wo Saulo, pana lé mu pii kon mwo pie Paulo, ke caa ju tilieng na a Jenen Iitihi, ke e te ju ome Élimas, ke e pii ten pie: ");
INSERT INTO cam_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","«Pa naî *Caatana! Wogo ke pa apipwobwonihi ne nina mwomwon! Te junihe ubwo kuti a pipwohuô ne kom! Woté? Mwo te time go uce nebwén kuti a bwo bitehi ne ni pwaadeni Padaame na mwomwon? ");
INSERT INTO cam_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Go téne: É jenaa ke a okéé te Padaame, ke e kom ke o bwi go, ke o pwo a benaamwon na time go uce alikenye.» Ke e te âbé kuti huîin a bwén, ke e pingaulieng hane ce apulie me lé pipééeng. ");
INSERT INTO cam_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ke wo gupéno, ke e téetihi ana e ko tuie, me a junuu a pwooti te Padué. Ke e te céihi kuti. ");
INSERT INTO cam_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","É alecehen, ke wo Paulo me lépwo béén, ke lé taa pwo ong mu Pafos nge Perge ha a province Pamfili. Ke e engen kojalu mulang wo Ioane-Maréko, ke e mwojuia ngemwo *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ke é mu Perge, ke lu engen, ke lu uti a pwaaden nge Antioche, ha a céiu duaa Pisidi. Ke me lu tehene ngelang, ke lu taa ha a mwotapitihi ha a *tan iitihi, ke lu tebwo. ");
INSERT INTO cam_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ke mepwo ni apulie na lé ko pwoiitihi lang, ke lé ko pine a tii ko *patén de Moosé, me ni tii te lépwo péroféta. Ke é alecehen, ke lé pii telu wo lépwo apihuô ne ha a mwotapitihi pie: «Lupwo âjiéneme, mepie pwo ce pwooti teu me bépamwoiu a bele, ke geu cihe.» ");
INSERT INTO cam_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ke e cuwoda wo Paulo, ke e pwo inenaado beme lé nemwo cihe, ke e pii pie: «Geé téne, ati wogewé lépwo *Isaraéla, me wogewé mwo na geé ko pipwoiitihi ibu. ");
INSERT INTO cam_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","E pipégali lépwo caa tenye wo Padué he a bele Isaraéla. Ke e pwo me piubwo da a bele, ha a benaamwon na lé mwo apulie coho ne *Aigupito. Ke e pwo me lé wie ko a niihen me junuun. ");
INSERT INTO cam_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Ke e wéilé, he na e mwonuhi na 40 ni jo ne ha a melé. ");
INSERT INTO cam_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","«Ke me e pwo me lé mele ne ni 7 mwametau mu ha amu *Kanana, ke e patupwo ne telé amu beme lépwo ju eapwihin. ");
INSERT INTO cam_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","A benaamwon naa, ke é mwonu na 450 ni jo. Ke é alecehe a bwo pipégalilé ten ne Aigupito, ke e ne ni apihuô te ni watihenye, die ha a benaamwon de péroféta Samuel. ");
INSERT INTO cam_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","«Ke mepwo ni watihenye, ke lé ilehi koja Padué pace daame helé. Ke e ne telé Saül, pa naî Kis mu ha a pwomwoiu te *Benjamin. Ke e daame helé he na 40 ni jo.» ");
INSERT INTO cam_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","«É alecehen, ke e pé kojaeng a pihuô wo Padué, ke e ne te *Davita beme pa daame he lépwo caa tenye. E pii ne kon wo Padué pie: É caa too Davita, pa naî Jessé, pa apulie na te junihe eânimung den, na e bo pacuwohi ati nina nimung kon. ");
INSERT INTO cam_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","«Ke é ne he ni pihuô te Padué, ke e bo wie mu ha a pwomwoiu te Davita wo Iésu, beme pa apiceluimi *Isaraéla. ");
INSERT INTO cam_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","«Ânebuhe a bwo tuie te Iésu, ke e âbé wo *Ioane pa apipuu apulie, ke e pipatemehi ati te a bele Isaraéla. Ke e pii telé pie: “Geé pininim, ke geé bitekewé, ke me puukewé!” ");
INSERT INTO cam_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ke me e panebwénihi ni penem den, ke e pii telé wo Ioane pie: “Kona geé ko niimihi pie, woéo ke woo? Be time uce woéo pa *Mesia. Be e bo âbé alecehung wo pana o te junihe time uce jan ne kong me é tuwo ni tai ko ni dihibwaan.”» ");
INSERT INTO cam_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Ke e pii mwo wo Paulo pie: «Geé tabemiéo, wogewé lépwo âjiénung, lépwo piebehi *Abérama, me wogewé mwo na geé paciiti Padué. E caa patupwobé céiikenye ati a pwooti ce, beme celuimikenye. ");
INSERT INTO cam_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Kehe icehi ana ni apulie Iérusaléma, me ni daame helé, ke time lé uce temehi Iésu, pana e âbé beme e celuimikenye. Time lé uce temehi a pwooti na lé mu caa pii ânebun wo lépwo péroféta, na lé mu pine ati he ni tan iitihi. Kehe icehi ana lé pacuwohi a pwooti naa, be lé pwo beme e mele wo Iésu. ");
INSERT INTO cam_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","«Be lé te temehi pie, te tice aceli e pwo wo Iésu celi jan me taunueng kon, kehe icehi ana lé te ilehi koja *Pilate pie, wâé heme e mele ne ko a *kuricé. ");
INSERT INTO cam_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Be lé pacuwohi ati ni naado na pii ne kon ne ni tii iitihi. Ke é alecehen, ke lé neeng ole mu ko a kuricé, ke lé neeng he iitihi.» ");
INSERT INTO cam_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","«Kehe icehi ana wo Padué, ke e te pamulipieng mwo, mu ha awieme ni amele. ");
INSERT INTO cam_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Ke é he ni tan na junihe hiwon, ke e pihabwiieng wo Iésu te ni apulie na lé tai taa me weeng mu Galilé, me lé taa Iérusaléma. Ke é jenaa ni, ke caa lépwo apajuujueng ne ha awieme a bele Isaraéla. ");
INSERT INTO cam_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«Ke wogeme, ke geme pipatemehi tewé a Pwooti Wâé naa. Be e caa mi pii ânebun wo Padué te ni watihenye. ");
INSERT INTO cam_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ke, é jenaa ni, ke e pwo me denye ni naîlé me ni béén mwo. Be e pwo me e mulie cemwo wo Iésu. «Be nye pine ne ha a béalohe psaume te Davita pie: É jenaa, ke é pii beetihi: Wogo pa naîng, ke woéo pa caa tem. Psaume 2.7 ");
INSERT INTO cam_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«Éa, wo Padué ke e pamulipieng mwo, mu ha amele, beme time e uce mwojuia mwo ne he iitihi, beme time uce nyaale pule nang. E caa mi pii wo Padué pie: É bo ne tewé a *adéihi na é caa mi pii te Davita. ");
INSERT INTO cam_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«Ke a juuju, be nye pine ne mwo ha a céiu duaa tii te *Psaumes pie: Ke time go uce neeng me nyaale pule pa apipenem iitihi tem na go caa pipégalieng. Psaume 16.10 ");
INSERT INTO cam_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«Ke e pipenem de Padué wo Davita, die ha a mele ten, beme e pacuwohi nina nime Padué kon. Ke me e mele, ke neduwoeng pwohewii lépwo caa ten, ke nyaale pule nang, ne he iitihi. ");
INSERT INTO cam_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Kehe icehi ana wo pana e caa pamulipieng wo Padué, ke time uce nyaale pule nang.» ");
INSERT INTO cam_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","«Wâé heme geé temehi ehi ni, wogewé lépwo âjiénung, pie é ko a nii Iésu, na geme patemehi tewé jenaa, a bwo pineuhi na a ta. Be time uce jan ni patén de Moosé me pineuhi ni ta. Kehe icehi ana wo pana e céihi ne ko Iésu, ke caa mwomwon nang, be caa piticenaado ne ko ni ta na e pwo. ");
INSERT INTO cam_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ke geé pipwocile, be koli e bo tuie ne kowé ana lé caa pii wo lépwo péroféta: ");
INSERT INTO cam_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Geé pipwocilekewé, wogewé lépwo apipaunukewé! Wâé heme geé téetihi, ke me geé pipiiden! Be é o caa pwo ne pelewé ce naado celi junihe ubwo. Ke mepie lé piuti tewé, ke o time geé uce céihi ne kon.» Habakuk 1.5 ");
INSERT INTO cam_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","43","Ke é alecehe a pitihi, ke lu pwo me lu wie mu ha a mwotapitihi wo Paulo me Barnabas. Ke lé ilehi kojalu ne ni apulie pie me lu mwo ne ce behi ni pwooti telu, ha a tan iitihi alecehen. Ke hiwon ni apulie na lé âcéi Paulo me Barnabas: wo lépwo Juif, me ni béén na lé céihi ne ko a pwoiitihi te lépwo Juif. Ke lé pipwojepule ibu, ke lu pamwoiulé, beme lé imwi mangihi ni *pipwoééhe tice ja kon de Padué. ");
INSERT INTO cam_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","É ha a tan iitihi alecehen, ke lé pipitilé a hiwon ko ni apulie Antioche ne Pisidi, beme lé téne a pwooti te Padaame. ");
INSERT INTO cam_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ke lé teko ali ni apulie naa wo lépwo apihuô te lépwo Juif, ke lé pipwokon ne ko Paulo, ke lé pigetieng, ke lé pipiitaeng. ");
INSERT INTO cam_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Kehe icehi ana lu pii mwoiuhi telé wo Paulo me Barnabas pie: «Gemu mi âbé céiikewé, be wogewé ninaa, na me geé mi téne a pwooti te Padué. Kehe geé téétihi, ke é mulang, na gemu bitekemu nge céii nina time uce ni Juif. Be wieli time uce a dewé a *mulie dieli mwo ne pele Padué! ");
INSERT INTO cam_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Be weengi ana e caa pii teme wo Padaame: É neko bé, me go pwéélang de ni béé bele, beme go pii te a bwohemwo ati pie, e caa âbé celuimikewé wo Padué!» Ésaïe 49.6 ");
INSERT INTO cam_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Ke me lé téne anaa wo lépwona time uce lépwo Juif, ke lé te junihe pipwodéén. Ke lé pii pie: «Te junihe wâé kuti a pwooti te Padaame!» Ke lé céihi ne nina e caa pipégalilé wo Padué, beme e mu kolé a mulie na tice pwonehin. ");
INSERT INTO cam_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Ke e â pitihi a amu a pwooti te Padaame. ");
INSERT INTO cam_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Pwo ni toomwo na piubwo jélé ne ha amu naa, na wâé telé a pwoiitihi te lépwo Juif. Ke wo lépwo Juif, ke lé pine ânepuni ni toomwo naa, me ni apihuô ha amu, beme lé pwotahi ne ko Paulo me Barnabas. Ke lé pawielu mu ha amu telé. ");
INSERT INTO cam_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ke lu tagiliihi ni muu pule ko alu beme lu habwii pie time uce wâé ni huô telé ke lu engen kojalé, ke lu â Ikone. ");
INSERT INTO cam_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ke ni acéihi na lé mu Antioche, ke caa ju tililé na a Jenen Iitihi, ke lé te junihe pipwodéén. ");
INSERT INTO cam_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Piwie nina tuie ne Ikone me Antioche. Be lu taa wo Paulo me Barnabas ha a *mwotapitihi te lépwo *Juif, ke lu patemehi a pwooti te Padué; ke hiwon ni apulie na lé céihi: wo lépwo Juif, me lépwona time uce lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Kehe icehi ana wo lépwo béé Juif, ke te muhi telé me lé céihi ne ko a pwooti na lu pipatemehi. Ke lé pine da puni lépwona time uce lépwo Juif na lé mu lang, beme lé okéé ne ko Paulo me Barnabas. ");
INSERT INTO cam_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kehe icehi ana time lu uce engen, ke lu mwo te mu lang. Ke time uce piabwobwo julu me lu pii mwoiuhi a pwooti te Padaame, be lupwona lu céihi ne kon. Ke e *pajuujuhi ni pwooti na lu pii wo Padué, ke e ne me lu pwo ni *pipwojunuun me ni inenaado na piwéden. ");
INSERT INTO cam_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ke lé pipiiden wo lépwo apulie ha amu naa. Be a céiu duaan, ke lé mu ko lépwo apihuô te lépwo Juif; ke a céiu duaan, ke lé âcéi lépwo *apostolo. ");
INSERT INTO cam_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ke lé piténelé wo lépwo Juif me lépwona time uce lépwo Juif, me lépwo apihuô telé, beme lé pwotahinaado ne ko Paulo me Barnabas, ke me lé taunulu ko péi. ");
INSERT INTO cam_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Kehe icehi ana me lu temehi anaa, ke lu cela nge he ni pwomwo ubwo Listre me Derbe ne Likaoni, me ni béé duaan ko jijen. ");
INSERT INTO cam_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ke lu patemehi nelang a Pwooti Wâé. ");
INSERT INTO cam_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","É ha a benaamwon naa, ke e mu ha a pwomwo ubwo Listre wo pa apulie na tebwomwa nang he mwo wahin nang. Ke time uce jan me e cuwoda me engen. ");
INSERT INTO cam_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ke é ha a céiu tan, ke e tabemi Paulo he e ko cihe ko a Pwooti Wâé. Ke e te ju omeeng wo Paulo, be e alihi pie e céihi wo paje beme wâé nang. ");
INSERT INTO cam_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Ke e te nihe cihe da ko miiden wo Paulo, ke e pii ten pie: «Go caama, me go cuwo!» Ke e te cuwoda kuti, ke e engen. ");
INSERT INTO cam_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ke hiwon ni apulie mu ha amu Likaoni na lé alihi ana e pwo wo Paulo. Ke lé cihe da ko miiden he patilé pie: «Éé! Ni duéé henye, ke lé caa pé ni éé apulie, ke lé opé céiikenye!» ");
INSERT INTO cam_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ke lé ne telu ni nii ni duéé helé; lé pii ko Barnabas pie Zeus a nii pa daame he ni duéé helé; ke wo Paulo pie Ermès, be te weeng, pa apébé na a pwooti. ");
INSERT INTO cam_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ke pwo a *mwaiitihi te Zeus, na e mu ha ata ne ha a pwomwo ubwo. Ke wo pa apwoâpwailo te Zeus, ke e pébé ni caa te paaci na pwo itihe muun kolé, ke lé ne he ni pomwa. Be nimen me woélé ati me a pubu apulie, ke me lé *pwoâpwailo te lupwo apostolo. ");
INSERT INTO cam_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Kehe icehi ana me lu téne anaa, ke te junihe time uce wâé telu, ke lu tie ni epwénelu. Ke lu téte nge ha awieme ni apulie, ke lu toii da pie: ");
INSERT INTO cam_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Ûhu! Lépwo béému, é mu ko ade na geé pwo anaa? Wogemu, ke te lupwo apulie pwohewiikewé! Ke gemu âbé patemehi tewé a Pwooti Wâé! Wâé heme geé necu ni duéé hewé, na piticenaado ne kolé! Ke geé bitekewé ne ko Padué na e mulip. Be weeng na e pwo a miiden me a bwohemwo me a jié, me ati ni naado na e hen. ");
INSERT INTO cam_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","«Ke é he ni benaamwon na e caa âdé, ke e mwo te ne ni puapulie me lé mwo te pwo nina te wâé telé. ");
INSERT INTO cam_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Kehe icehi ana e mu te habwii tenye a pipwoééhe ten, ke e pwo ni naado na wâé, me denye. Be e ne tenye a ute, bé mu he miiden, me ni benaamwon ko a pitii âdaanu. Ke weeng na e ne tenye ni wiinaado na nihe hiwon, ke e ne mwo me nye nihe pipwodéén.» ");
INSERT INTO cam_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ke lu caa te patemehi telé ni pwooti naa wo Paulo me Barnabas, kehe icehi ana lu mwo te pwobwonilé beme time lé uce pwoâpwailo telu. ");
INSERT INTO cam_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","É ha a benaamwon naa, ke lé âbé mu Antioche ne Pisidi, ke é mu Ikone, wo lépwo béé Juif. Ke lé taa pine puni lépwo béé apulie, beme lé taunu Paulo. Ke lé te junihe ahieng ko péi, ke lé céieng wie koja a pwomwo ubwo, be lé piniimihi pie e caa mele. ");
INSERT INTO cam_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kehe icehi ana me lé mu aujenieng wo lépwo acéihi, ke e cuwoda, ke e taa ha a pwomwo ubwo. Ke é ha a tan alecehen, ke lu â Derbe wo Paulo me Barnabas. ");
INSERT INTO cam_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","É mulang, ke lu pipatemehi a Pwooti Wâé ne Derbe wo Paulo me Barnabas. Ke hiwon ni apulie na lé céihi. Ke lu mwojuia mwobé ne Listre, ne Ikone me Antioche ne Pisidi. ");
INSERT INTO cam_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Lu pamwoiu lépwo acéihi beme lé cumang ne he ni céihi telé ne ko Padaame. Ke lé pii telé pie: «Nye mulie ne he ni picani, me genye â ha a pwaaden nge ha a *Mwametau te Padué.» ");
INSERT INTO cam_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ke lu pipégali lépwo béé apulie, beme lépwo apihuô te ni béé acéihi ne he ni béé duaan. Ke pwo a céiu benaamwon na lu pipatupwo wiinaado me ûdu, ke lu pwoiitihi, beme lu nelé te Padaame na lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ke nebwén, ke lu pinelé ke lu pitahagéi ole Pisidi, ke lu tuie nge ha a province Pamfili. ");
INSERT INTO cam_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Ke é nelang, ke lu pipatemehi a Pwooti Wâé ne Perge. Ke é mulang, ke lu ole ne Atali. ");
INSERT INTO cam_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Ke lu taa pwo ong me lu mwojuia ngemwo Antioche ha a province Siri. Be wo lépwo acéihi ne ha a duaan naa, ke li lé caa nebwén ko nelu te Padué ha a pipwoééhe, ne ko a penem na lu ko pwo. ");
INSERT INTO cam_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ke me lu tuie ngemwo lang, ke lu neibu lépwo acéihi. Ke lu uti telé ati ni jéhinaado na e ne telu me lu pwo wo Padué. Ke lu uti mwo a bwo tehi na a pomwa ko a céihi te lépwona time uce lépwo Juif, me lé céihi. ");
INSERT INTO cam_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ke lu mwo mu me bwolihi pelelé. ");
INSERT INTO cam_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Pwo ni béé apulie, na lé âbé mu *Judé me lé â Antioche. Ke lé mwo pacémuni ni acéihi, ke lé pii telé pie: «Mepie time uce pipwotegoop tewé, pwohewii ana pii ne he ni *patén de Moosé, ke o time uce celuimikewé.» ");
INSERT INTO cam_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kehe icehi ana wo Paulo me Barnabas, ke te junihe time lé uce piténelé me woélé, ke lé te nihe picihe ko a bwo niimihinaado naa. Ke lé pihuô ibu pie wâé hemepie lé taa *Iérusaléma, woilu me ni béén mu kolé, beme lé o picihe wo lépwo *apostolo, me lépwo apihuô te ni acéihi, ko ace bwopiine a pwooti naa. ");
INSERT INTO cam_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ke é mu ko anaa, na lé pawielé ngen wo lépwo acéihi Antioche. Ke lé engen wo lépwoje, ke lé tahagéi Fénisi me *Samari. Ke lé piuti a bwo pininim de lépwona time uce lépwo *Juif. Ke lé te junihe pipwodéén kon wo lépwo acéihi na lé mu lang. ");
INSERT INTO cam_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ke me lé tuie nge Iérusaléma, ke lé hegilé ati ne ni acéihi, me ni apostolo, me ni apihuô telé. Ke lé piuti telé ati ni naado na lé pwo me Padué. ");
INSERT INTO cam_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Kehe icehi ana pwo ni béé *Farasaio na lé caa céihi ne ko Iésu, ke lé cuwoda, ke lé pii telé pie: «Wâé heme lé *pwotegoop te ni acéihi na time uce ni Juif, ke wâé heme lé âcehin ehi ni patén de Moosé.» ");
INSERT INTO cam_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Lé pipitilé wo lépwo apostolo me lépwo apihuô, beme lé picihe ko a pwooti naa. ");
INSERT INTO cam_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lé te junihe picihe kon, ke é ha a céiu benaamwon, ke e cuwoda wo Pétéru, ke e pii telé pie: «Lépwo acéihi bééng, geé temehi pie caa bwolihi na e pipégaliéo wo Padué mu ha awiemewé, beme é patemehi a pwooti te nina time uce ni Juif. Be nimen me lé téne a pwooti ko a mulip, ke me lé céihi ne kon. ");
INSERT INTO cam_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Wo Padué, ke e te temehi ni pwonime ni apulie. Ke e ne telé mwo a *Jenen Iitihi, pwohewii ne konye. E tee ko habwii tenye pie, e te hegilé mwo. ");
INSERT INTO cam_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Time e uce pipwoinen ne konye me woélé. E pwo me wâé ni pwonimelé, be lé céihi. ");
INSERT INTO cam_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","«Ke é jenaa ni, ke é mu ko ade na geé mwo teko tacebwéni Padué? É ko ade na geé ne huîi ni acéihi a âneule, na time uce jan me lé canihi wo lépwo watihenye, ke wogenye mwo? ");
INSERT INTO cam_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Genye céihi pie caa celuimikenye, ko a *pipwoééhe tice ja kon te Padaame Iésu. Tai wogenye me woélé.» ");
INSERT INTO cam_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Ke te ju tice pwocihe ha ali tapitihi, ke lé tabemi Barnabas me Paulo. Ke lu piuti telé ni *pipwojunuun me ni inenaado na e ne me lu pwo wo Padué, ne ha awieme nina time uce ni Juif. ");
INSERT INTO cam_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ke me lu caa cihe ati, ke e uce cihe wo Cang, ke e pii pie: «Lépwo acéihi bééng, geé tabemiéo. ");
INSERT INTO cam_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","E piuti wo Simon Pétéru a bwo tabuhi pipégali nen de Padué ace bele ten, mu hadenii ni béén na time uce ni Juif, beme a bele ten. ");
INSERT INTO cam_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Be caa pwohewii a bwopiinen de ni péroféta, na nye pine ne he ni tii iitihi pie: ");
INSERT INTO cam_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","E pii wo Padaame pie: “É alecehe anaa, ke é bo âmwobé, ke é bo bahi mwo a mwa te *Davita na e caa tupwo. É bo pwo me e cuwo mwo, ");
INSERT INTO cam_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","beme lé o bo haneéo ati ne ni apulie pwo bwohemwo. Éa, beme lé o bo haneéo ati ne ni bele na é todelé beme lé bele tong. ");
INSERT INTO cam_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Woéo Padaame, na é pii ni pwooti naa. É caa te mi pii beetihi ânebun.”» Amos 9.11−12 ");
INSERT INTO cam_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","E pii mwo wo Cang pie: «É niimihi pie, me time uce ne mwo ace céiu âneule huîi nina time uce ni Juif, na lé caa céihi ne ko Padué. ");
INSERT INTO cam_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Wâé heme nye pwotii nge céiilé, me nye pii telé pie: “Geé nemwo wii ni mewota na *pwoâpwailo kon ne te ni *déme duéé. Geé nemwo pibune, ke geé nemwo pipule hauli. Geé nemwo wii ni mewota na mwo cewéle, me ni wota na ebunuhi be time e uce wie a cewéhelé.” ");
INSERT INTO cam_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Be tabuhi bwolihi, ke pwo ni apulie na lé patemehi ni patén de Moosé ne he ni pwomwo ubwo. Ke lé pine ni patén ne he ni *mwotapitihi, ati he ni *tan iitihi.» ");
INSERT INTO cam_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ke wo lépwo apostolo, me lépwo apihuô, me ati ni acéihi, ke lé piténelé beme lé tii a tii nge céii ni acéihi ne Antioche. Ke lé pipégali Silas me Jude, na pii kon mwo pie Barsabas, lupwo apulie na lé céihi ne kolu, beme lu âcéi Paulo me Barnabas beme lé pé ngen ali tii. ");
INSERT INTO cam_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ke lé ne telé ali tii na pii ne hen pie: Bwocu tewé, wogewé ni acéihi ne Antioche, ke Siri, ke Silisi! Wogeme lépwo apostolo, me lépwo apihuô, na geme tii a tii ce. Time geé uce Juif, kehe icehi ana geé céihi ne ko Kériso, ke é mu ko anaa, na wogewé, ke caa lépwo âjiéneme ne he niin. ");
INSERT INTO cam_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Geme téne pie, pwo ce béén celi lé engen mu peleme, ke lé âdé pahaulikewé ko ni pwooti telé, ke lé pwo me penem ni pwonimewé. Kehe icehi ana time uce wogeme celi geme ne a mwomwon delé. ");
INSERT INTO cam_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ke é mu ko anaa, na geme pitapitikeme, ke me niimihi pie wâé hemepie geme pipégali lupwoce apulie mu peleme, me geme nelu lé céiikewé, beme lu âdé céi lupwo acéihi bééme, lupwona te junihe eânimeme telu: wo Paulo me Barnabas, ");
INSERT INTO cam_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","lupwo apulie na time uce piwâ julu me lu patupwo ni mulihelu ne he nii Padaame Iésu Kériso. ");
INSERT INTO cam_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Geme ne lé Jude me Silas, beme lu mwo ju pii pwaatihi tewé, nina tii ne ha a tii ce. ");
INSERT INTO cam_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Be geme piténekeme, wogeme me a Jenen Iitihi, pie time uce wâé heme geme ne mwo huîiwé ace âneule. Kehe icehi ana weengi a junaado: ");
INSERT INTO cam_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Geé nemwo wii ni mewota na pwoâpwailo kon ne te ni déme duéé; Geé nemwo wii ni mewota na mwo cewéle, me ni wota na ebunuhi be time e uce wie a cewéhelé; Geé nemwo pibune, ke geé nemwo pipule hauli. Wâé heme geé nebwén koja ni naado naa. Adéikewé! ");
INSERT INTO cam_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ke lé patupwo ngen Paulo, Barnabas, Jude me Silas. Ke lé â Antioche ne Siri, ke lé tapiti ati ni acéihi, beme lé ne telé ali tii. ");
INSERT INTO cam_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Ke me lé pine ali tii wo lépwo acéihi, ke te junihe piwâénimelé kuti. ");
INSERT INTO cam_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Mepwo é ne ko Jude me Silas, lupwo péroféta, ke lu mwo te junihe pacihelé ke pamwoiulé. ");
INSERT INTO cam_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Lu mwo mu lang ha a céiu benaamwon, ke lé pinelu wo lépwo acéihi mu Antioche, me lu mwojuia ngemwo pele lépwona lé nelu bé. { ");
INSERT INTO cam_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Kehe icehi ana e niimihi wo Silas pie wâé hemepie e mwo mu.} ");
INSERT INTO cam_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ke wo Paulo me Barnabas, ke lu tee mu Antioche. Ke lu pacémunihi me pii beetihi a pwooti te Padaame, woilu me ni apulie na hiwon jélé. ");
INSERT INTO cam_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","É alecehe a céiu benaamwon, ke e pii wo Paulo te Barnabas pie: «Genyu mwojuia ngemwo, he li pwomwo ubwo li genyu patemehi nge hen a pwooti te Padaame. Wâé heme genyu caniê ni acéihi na ko élé hen, beme genyu alihi pie he ko woté jélé.» ");
INSERT INTO cam_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ke nime Barnabas me e pé mwo Ioane, na pii kon mwo pie Maréko. ");
INSERT INTO cam_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Kehe icehi ana muhi te Paulo, be e te pipwoité engen kojalu wo panaa. Be tabuhi mu ha a province Pamfili, ke time e uce picani telu, die ha anebwén ko ni penem delu. ");
INSERT INTO cam_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Lu te junihe picihe, ke lu te junihe piokéé, dieli lu â pipiiden. Ke e pé Ioane-Maréko wo Barnabas, ke lu engen pwo ong nge Chipre. ");
INSERT INTO cam_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ke e pé Silas wo Paulo, ke lé nelu wo lépwo acéihi, ne ha a pipwoééhe te Padaame. Ke lu engen. ");
INSERT INTO cam_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ke lu tahagéi lupwo province Siri me Silisi, ke lu pamwoiu ngen ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","E engen wo Paulo mulang nge he ni pwomwo ubwo Derbe me Listre. E pimu Listre wo pa acéihi na pii kon pie Timoté, pa naî ê toomwo *Juif, na e caa céihi ne ko Iésu. Ke hemepwo pa caa ten, ke time uce pa Juif. ");
INSERT INTO cam_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ke lé pii wo lépwo acéihi mu Listre ke é mu Ikone pie, te junihe pa apulie wâé wo Timoté. ");
INSERT INTO cam_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Nime Paulo me e pééeng. Ke e *pwotegoop ten, mu ko lépwo Juif na lé mu ha a duaan naa. Be lé te temehi ati pie, wo caa ten, ke time uce pa Juif. ");
INSERT INTO cam_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","É he ni pwomwo ubwo na lé â hen, ke lu pii te ni acéihi wo Paulo me Silas pie, me lé ténedehi ni pihuô te lépwo apostolo me lépwo apihuô te ni acéihi ne *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Ni acéihi, ke piubwo jélé da ne ha a céihi, ke e pitaamwo a jéhilé téteda he ni tan. ");
INSERT INTO cam_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ke e pwobwoni Paulo me Silas a *Jenen Iitihi, beme lu nemwo patemehi a pwooti te Padué ne ha a province Asia. Ke lé pitahagéi a Frigi, me a province Galat me lépwo béélu. ");
INSERT INTO cam_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ke me lé tehene nge mwonuhi a duaan Misi, ke lé pwo me lé taa ha a province Bitini, kehe icehi ana time e uce tehi ne telé na a Jene Iésu. ");
INSERT INTO cam_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ke é mulang, ke lé uce tahagéi Misi, ke lé tuie ole Troas ha atii ne ong. ");
INSERT INTO cam_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ke é he bwén, ke wo Paulo, ke e alihi ne he niûn pa apulie mu ha a province Macédoine, na e ko cuwo, ke e wâgo kon ke e pii ten pie: «Go âbé ne Macédoine, me go picani teme!» ");
INSERT INTO cam_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","É ne alecehe ana e habwii ten, ke geme hane me geme piepin nge Macédoine, be geme caa temehi pie, wo Padaame na e todekeme, me geme patemehi a Pwooti Wâé nelang. ");
INSERT INTO cam_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Geme taa pwo ong ne Troas, ke geme caa te â ko a één Samotrace. Ke é ha acaama hen, ke geme tuie ne Néapolis. ");
INSERT INTO cam_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ke é mulang, ke geme â Filipi, a pwomwo ubwo ne ha a céiu duaan ko a province Macédoine. Filipi, ke a colonie te lépwo Roma. Mwo te pwo ni tan deme nelang. ");
INSERT INTO cam_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","É ha a *tan iitihi, ke geme wie koja a pwomwo ubwo, ke geme âmwonuhi a éémwa, be geme niimihi pie e lang ace duaan celi lé mu pwoiitihi ne hen wo lépwo Juif. Geme tebwo, ke geme cihe ne ko ni toomwo na lé ko pitapitilé nelang. ");
INSERT INTO cam_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Wo ê céiu, ke a niin pie Lidi, ê apulie mu Tiatire, ê a-icuhi mwaanu megele, na te junihe ubwo a cuhin. Time uce ê Juif, kehe icehi ana e céihi ne ko a pwoiitihi te lépwo Juif. Ke e te ju tabemi ehi ni pwooti te Paulo. Ke e tehi a pwonimen wo Padaame beme e hegi a pwooti. ");
INSERT INTO cam_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ke puueng me ni apulie na lé mu ha a pomwa ten. Ke é alecehen, ke e pii teme pie: «Mepie geé *pipajuujuhi pie, é céihi me mang ne ko Padaame, ke geé âbé céing ne ha a pomwa tong!» Ke e cuwokome beme geme âcéin. ");
INSERT INTO cam_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","É ha a céiu tan, he geme â ha a duaan na lé mu pwoiitihi ne hen, ke e âbé benikeme ê toomwo na pwo duéé kon. A duéé naa, ke e patemehi ten me e pii te ni apulie nina e bo tuie. Ke te junihe hiwon ni mwani na lé hegi mu ko nina e pii, wo lépwona e penem delé. ");
INSERT INTO cam_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ke e âbé céime, wogeme me Paulo, ke e toii pie: «Wo lépwo apulie ce, ke lépwo eabwé te Padué na nihe e daaité, ke lé patemehi tewé a pwaaden nge ha a mulip.» ");
INSERT INTO cam_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","E te wonaa ati he ni tan, ke e caa â okéé wo Paulo. Ke e te biteeng kuti, ke e pii te ali duéé pie: «Go wie mu ko ê toomwo naa, ne he nii Iésu Kériso!» Ke e te wie kuti mu kon. ");
INSERT INTO cam_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ke me lé alihi wo lépwo apihuô ten pie, caa tieden ali apé mwani telé, ke lé te imwi kuti Paulo me Silas, ke lé teuulu nge ha apimu ibu te ni apulie ne he pwahamii ni apihuô ha amu. ");
INSERT INTO cam_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Lé habwiilu te lépwo atautinaado te lépwo Roma, ke lé pii telé pie: «Wo lupwo apulie ce, ke lu pahauli a pwomwo ubwo. Be lupwo Juif, ");
INSERT INTO cam_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ke lu ko patemehi ni huô na mwo coho, na tice mwomwon denye me nye hegi, ke me genye mulie hen, wogenye lépwo Roma.» ");
INSERT INTO cam_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ke lé te okéé kuti ne kolu ne ni apulie. Ke wo lépwo atautinaado, ke lé céi tie ni epwénelu, ke lé pwo me ahilu ko beba-acuwo. ");
INSERT INTO cam_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ke lé nihe ahilu, ke lé tahilu da he karépu, ke lé pii te pa awéa kolu pie me e wéa ehi kolu. ");
INSERT INTO cam_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","É mulang, ke e nelu ha a bénebwéne nemwa ne ha a karépu wo pa awéa kolu, ke e cie mwo ni alu ne ko ni ba-acuwo. ");
INSERT INTO cam_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","É ha awieme bwén, ke lu teko pwoiitihi, me pwonyebi, me pipaunu Padué wo Paulo me Silas. Ke lé teko tabemilu wo lépwo béélu ko pwokarépu. ");
INSERT INTO cam_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ke e te tuie kuti a penem bwohemwo, na te junihe ubwo. Ke e papenemihi ni goomwa ko a karépu. Ke te tai tehi kuti ati ni pomwa, ke tupwo mwo ni itihe toki, na lé cie lépwo a-mu he karépu kon. ");
INSERT INTO cam_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Ke me e ûmiê wo pali awéa, ke te junihe emegéi nan kuti. Be e alihi ni pomwa ubwo ko ali karépu he tehi, ke e te céi kuti a teua ten, beme e piwolieng hen, be e niimihi pie lé caa cela wo lépwo a-mu he karépu. ");
INSERT INTO cam_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kehe icehi ana e henieng wo Paulo, ke e pii ten pie: «Go nemwo pipwotako, be te tai wogeme éni ati!» ");
INSERT INTO cam_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Ke e te ilehi kuti ace miû wo pali awéa, ke e taa epin ha ali karépu, ke e tidihi jilin ko ni a Paulo me Silas, ke éjén nang ko a bwo mwotieng. ");
INSERT INTO cam_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ke e pawielu, ke e pii telu pie: «Lupwo daame, ade aceli me é pwo, beme o celuimiéo?» ");
INSERT INTO cam_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ke lu hegi ne ten pie: «Go céihi ne ko Padaame Iésu, ke o celuimiko, wogo me ni apulie na lé mu ha a pomwa tem.» ");
INSERT INTO cam_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","34","Ke e pé Paulo me Silas nge ha a pomwa ten, he mwo bwén, ke e puu ni ahinaado kolu, ke e pwo me lu wiinaado. Ke lu patemehi te paje me ni apulie na lé mu ha a pomwa ten, a pwooti te Padaame. Ke lé céihi ne kon, ke puulé. Ke lé nihe pipwodéén. ");
INSERT INTO cam_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","É he pwang, ke lé pahede lépwo apipépwooti wo lépwo atautinaado te lépwo Roma, beme lé pii te pa awéa ko a karépu pie me e patupwolu. ");
INSERT INTO cam_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Ke e pii te Paulo wo pa awéa pie: «Lé piibé céiiéo a pwooti wo lépwo atautinaado, pie me é patupwokeu. Geu wie, ke geu engen ha a péém.» ");
INSERT INTO cam_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ke e pii wo Paulo te lépwo apipépwooti pie: «Lépwoje, wogemu ke lupwo Roma, kehe icehi ana lé pijeta komu, ke lé ahikemu ne he pwahamii ni apulie ati, ke lé tahikemu ne he karépu! Ke é jenaa ni, ke lé pwo me lé pipwoneduwohi a bwo pawiekemu? Ûhu! Time uce wonaa! Wâé heme lé te âbé woélé, me lé pawiekemu.» ");
INSERT INTO cam_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Ke lé engen wo lépwo apipépwooti, ke lé pémwojuiéhi nge céii lépwo atautinaado te lépwo Roma a bwopiinen de Paulo. Ke te junihe mwoti lépwo atautinaado he lé téne pie lupwo Roma. ");
INSERT INTO cam_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ke lé âbé pimiibule ne telu. Ke lé pawielu, ke lé cuwokolu pie me lu engen mu ha a pwomwo ubwo. ");
INSERT INTO cam_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ke lu engen wo Paulo me Silas, ke lu taa too Lidi. É alecehe a bwo ali ni acéihi, ke lu pamwoiulé, ke lu engen. ");
INSERT INTO cam_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Lu â Amfipolis me Apoloni wo Paulo me Silas, ke lu tehene nge Tésalonik, he na e mu lang a céiu *mwotapitihi te lépwo *Juif. ");
INSERT INTO cam_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ke e taa ha a mwotapitihi wo Paulo, pwohewii ana e mu te pwo. Ke é he na cié ni *tan iitihi, ke e pwopune ko a pwooti mu he ni tii iitihi. ");
INSERT INTO cam_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","E pii pwaatihi ke habwii telé pie, wo pa *Mesia, ke e o bo mu he ni picani ke e bo mele. Kehe icehi ana e o bo mulie cemwo. Ke e pii telé mwo wo Paulo pie: «Wo pa Iésu na é patemehieng dewé, ke weeng kuti pa Mesia.» ");
INSERT INTO cam_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Wo lépwo béén mu kolé, ke e ti kolé ni pwooti naa, ke lé âcéi Paulo me Silas. Ke hiwon ni béén mu ko lépwo *Grek na lé âcéilu: nina wâé telé a pwoiitihi te lépwo Juif, wonaa mwo mu pele ni toomwo na piubwo jélé. ");
INSERT INTO cam_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kehe icehi ana lé te junihe pipwokon wo lépwo Juif, ke lé tode ni apulie na te tice aceli wâé ne kolé, ke lé pine ânepuni ni apulie ha a pwomwo ubwo, beme lé okéé. Ke lé â hanelu ha a pomwa te pa apulie na pii kon pie Jason, beme lé péélu ole pwo pwaaden, ne he pwahamii ati ni apulie beme tautilu. ");
INSERT INTO cam_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","7","Kehe icehi ana time lé toolu, ke lé uce teuu ngen Jason me lépwo béé acéihi pele lépwo apihuô ne ha a pwomwo ubwo, ke lé toii pie: «Wo paje, ke e hegi lupwo apulie ta, wo Paulo me Silas, lupwoli lu pahaulihi a bwohemwo ati, ke é jenaa ni, ke lu tuie ne éni! Wo lépwoje me lépwo béélé, ke lé cubwonihi ni patén de César, pa daame ubwo te lépwo Roma. Be lé pii pie, te céiu pa daame ubwo, ke wo panaa, ke wo Iésu.» ");
INSERT INTO cam_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ke me lé téne anaa ne ni apulie me lépwo apihuô, ke te junihe pahaulilé kuti. ");
INSERT INTO cam_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ke lé bwo pawie Jason me lépwo béén, na lé pwocuhi ni cuhinaado telé. ");
INSERT INTO cam_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","É he babwén, ke wo lépwo acéihi, ke lé te pwome pwo me lu engen kuti mu Tésalonik wo Paulo me Silas, me lu â ha a pwomwo ubwo Béré. Ke me lu tehene ngen, ke lu taa ha a mwotapitihi te lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Wo lépwo Juif na lé mu Béré, ke te junihe wâé jélé koja lépwo Juif na lé mu Tésalonik: Be lé hegi a pwooti ha a pipwodéén. Ke ati he ni tan, ke lé te omehi ehi ni tii iitihi, beme lé alihi pie, teko ni juuju kuti ni pwooti na e ko pii telé wo Paulo. ");
INSERT INTO cam_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Hiwon nina lé céihi mu kolé, ke é mu pele lépwo Grek, ke hiwon mwo ni toomwo na piubwo jélé, ke pwo mwo ni aiu. ");
INSERT INTO cam_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kehe icehi ana lé téne wo lépwo Juif mu Tésalonik pie wo Paulo, ke e ko patemehi a pwooti te Padué ne Béré. Ke lé âbé pine ânepuni ni apulie lang, ke lé pwo me lé okéé ne kolu. ");
INSERT INTO cam_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ke lé te pwome téele kuti wo lépwo acéihi, ke lé pé Paulo, ke lé pééeng nge ha atii ne ong. Ke mepwo wo Silas me Timoté, ke lu mwo tee mu Béré. ");
INSERT INTO cam_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Lé pé Paulo die Atène wo lépwo acéihi. Ke e pahedelé mwo pie me lé mwojuia ngemwo Béré, me lé â pii te Silas me Timoté pie me lu piepin ko âbé tooeng. ");
INSERT INTO cam_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wo Paulo, ke e mwo te ju pwome piucéi Silas me Timoté ne Atène. Ke e alihi pie, te junihe hiwon ni *déme duéé na lé mwo te pipaunuhi ne ni apulie ha a pwomwo ubwo naa. Ke te junihe téé kuti a pwonimen. ");
INSERT INTO cam_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ke é ne ha a mwotapitihi, ke e pacihe ni Juif, me ni béén na wâé telé a pwoiitihi te lépwo Juif. Ke ati he ni tan, ke e pacihe mwo ni béén na e toolé ne ha apwojenep. ");
INSERT INTO cam_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ke lé picihe mwo me weeng ni béé caa te lépwo épicurien me lépwo stoïcien. Wo lépwo béén, ke lé pii pie: «He ade ana e teko cihe ko pii tenye wo pane?» Ke wo lépwo béén mwo, ke lé pii pie: «Pwohewiin heme e pipatemehi ce duéé celi te pi-ité.» Be lé téne Paulo he e ko pipatemehi Iésu me a mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ke lé pééeng céilé, ke lé pééeng nge ha a mwohuô ha a pwomwo ubwo na a niin pie Aréopage, ke lé pii te Paulo pie: «Nimeme me geme temehi ehi ni naado naa, na mwo coho, na go ko pii teme. ");
INSERT INTO cam_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Be go pwo me geme téne ni naado na te ité, ke nimeme me geme temehi ce bwopiinen.» ");
INSERT INTO cam_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Be ati ni apulie éni Atène, me ni béén na ni aâbé na lé mulie ne éni, ke lé te uti ke tabemi ni jepule na mwo coho. ");
INSERT INTO cam_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Ke e cuwoda wo Paulo, ke e pii pie: «Lépwo Atène, é alihi pie geé te junihe pwoiitihi te ni duéé. ");
INSERT INTO cam_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Be me é ko engen ha a pwomwo ubwo tewé, ke é alihi ni démenaado na geé bahi me geé pipaunuhi, me pwoiitihi ne kon. Ke é te tooli mwo a *apwoâpwailo na tii ne kon pie: A de Padué na time nye uce temehieng. «Geé téne, wo Pana geé pipaunueng na time geé uce temehieng, ke weeng kuti na é âbé pipatemehieng dewé. ");
INSERT INTO cam_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Wo Padué na e pwo a bwohemwo, me ati ni naado na e pwon, ke weeng Padaame he a miiden me a bwohemwo. Ke time e uce mu he ni *mwaiitihi na lé bahi wo lépwo apulie. ");
INSERT INTO cam_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ke time uce jan me nye picani ten me e mulie, be tai pwo ne ten ati. Be weeng Pana e ne tenye a mulie, me a nenehenye, me ati ni naado. ");
INSERT INTO cam_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ke e pwo me ni apulie ati, ke me lé wie mu ko pa apulie na te céiu nang, beme lé mulie pitihi a bwohemwo. Ke e caa nebwén ko ne telé ni picé ko a amu telé, ke e caa nebwén ko ne telé ni benaamwon ne ha a jo. ");
INSERT INTO cam_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","«E wonaa a bwo ne nen den wo Padué beme lé o haneeng ne ni apulie. Be time uce e ité kojakenye. Piwien hemepie binyi me lé haneeng wo lépwo apulie, kehe lé o te tooeng. ");
INSERT INTO cam_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Be caa nebwén ko pii pie: “Nye mulie mu kon, nye piâdé ke âbé, ke genye apulie mu kon.” Pwohewii ana lé pii mwo wo lépwo béé apwotii tewé pie: “Wogenye mwo ni naîn.” ");
INSERT INTO cam_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«É mu ko anaa, ke wogenye ni naîn, ke genye nemwo niimihi pie wo Padué, ke e pwohewii ni duéé na pwo ko péi, ai nina pwo ko mwani megele, me mwani pwojo! Time e uce pwohewii ni naado na lé pwo wo lépwo apulie, pwohewii ni bwo niimihinaado telé, be time lé uce temehieng! ");
INSERT INTO cam_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ke wo Padué, ke caa time e uce ne me pwonaado ne ko ni benaamwon na time lé uce temehieng. «Kehe icehi ana é jenaa ni, ke e cuwoko ati ni apulie pwo bwohemwo beme lé pininim, beme o taatééhi ni mulihelé. ");
INSERT INTO cam_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Be e caa nebwén ko ne a Tan na e bo tauti ati ni apulie pwo bwohemwo ha a juuju. E bo pipwaadeniin bé wo pa apulie, na e caa nebwén ko pipégalieng ne ko a Tan naa. Ke e pamulipieng mwo mu ha amele, beme e habwii tenye ati pie, weengaa kuti, pa atautinaado na caa pipégalieng.» ");
INSERT INTO cam_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Me lé téneeng wo lépwo Grek he e ko cihe ko a mulie cemwo mu ha amele, ke lé pipiilé. Ke lé pihoonieng wo lépwo béén, kehe lé pii ne ni béén pie: «Geme bo tabemiko mwo ko anaa ha ace céiu tan.» ");
INSERT INTO cam_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ke e engen kojalé wo Paulo. ");
INSERT INTO cam_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kehe icehi ana ni béén na lé âcéi Paulo, ke caa ni acéihi. Wonaa ne ko Denys, pa céiu âne a mwohuô te lépwo Atène, me ê céiu toomwo na pii kon pie Damaris, me ni béé apulie mwo. ");
INSERT INTO cam_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","E engen wo Paulo mu Atène, ke e â Korénit. ");
INSERT INTO cam_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Ke e too pa céiu *Juif nelang na pii kon pie Akilas, pa apulie mu ha a province Pont, he lu mwo ko tehenebé mu Itali me Priscile, ê mwoden. Be lé piténedehi a âpihuô te Klaude, pa daame ubwo te lépwo Roma, be e caa te pii ati te lépwo Juif pie me lé wie mu *Rome. Ke e â caniêlu wo Paulo. ");
INSERT INTO cam_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Ke e â pimu pelelu beme lé pipenem ibu. Be piwie ni penem delé, be ni apwo mwa mwaanu. ");
INSERT INTO cam_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ke é he ni *tan iitihi, ke e patemehi a pwooti ne te lépwo Juif me lépwo *Grek wo Paulo ne ha a *mwotapitihi. Ke e hane me lé céihi ne ko ni pwooti na e pii. ");
INSERT INTO cam_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Me lu tehenebé mu ha a province Macédoine wo Silas me Timoté, ke é ati he ni tan, ke e tee pipatemehi a pwooti wo Paulo. Ke e pii te lépwo Juif pie: «Wo Iésu, ke te weeng kuti pa *Mesia.» ");
INSERT INTO cam_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kehe icehi ana lé piâdeeng, ke lé pipiitaeng. Ke e tagiliihi taabwon ni muu pule ko ni epwénen wo Paulo, ke e pii telé pie: «Hemepie tiekewé koja a mulihe Padué, ke bo te é mu kowé, kehe time uce woéo pa watihen. É jenaa ni, ke é o â céii ni béén na time uce ni Juif.» ");
INSERT INTO cam_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Ke e engen kojalé, ke e â pele pa céiu na pii kon pie Titius Justus, pa apulie na e céihi ne ko a pwoiitihi te lépwo Juif. A pomwa ten, ke e te ju mu mwonuhi a mwotapitihi. ");
INSERT INTO cam_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ke wo Krispus, pa daame he a mwotapitihi, ke e céihi ne ko Padaame, tai woélé ati me a pomwa ten. Ke hiwon ni Korénit na lé téne Paulo, ke lé céihi, ke puulé. ");
INSERT INTO cam_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","É ha a céiu bwén, ke e pihabwiieng ha a jenen wo Padaame ne te Paulo, ke e pii ten pie: «Go nemwo pwo me mwotiko, kehe go patemehi a pwooti, ke go nemwo pwo me tice patim! ");
INSERT INTO cam_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Be é teko mu pelem, ke o te tice pace céiu apulie celi e o imwiko, me e pwo tem celi ta, be hiwon ni apulie tong ne ha a pwomwo ubwo naa.» ");
INSERT INTO cam_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Ke e mu lang wo Paulo he na céiu jo, ke 6 ni wole. Ke e pacémuni ni Korénit ko a pwooti te Padué. ");
INSERT INTO cam_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","É ha a benaamwon na e gupéno ne ha a province Akaï wo Galion, ke lé tai piâde Paulo wo lépwo Juif, ke lé imwieng, ke lé pééeng nge he mwotautinaado ânebuhe pa gupéno. ");
INSERT INTO cam_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Ke lé pii pie: «Wo pa apulie ce, ke e te cuwoko ni apulie beme lé pipaunu Padué, ne he ni bwopwonen na te ité koja ni patén de a pwoiitihi teme.» ");
INSERT INTO cam_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ke é he e mwo ko pwo me e cihe wo Paulo, ke e pii wo Galion te lépwo Juif pie: «Lépwoje, hemepie e taunuhi apulie wo paje, ai hemepie e pwo aceli te junihe ta, ke é o te tabemikewé. ");
INSERT INTO cam_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kehe icehi ana wogewé, ke geé picihe ko ni pwooti, me ni nii apulie me ni patén dewé. Ke anaa, ke te piwogewé. Time uce nimung me pa apitauti ne ni naado naa.» ");
INSERT INTO cam_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ke e pamwojuiélé mu he mwotautinaado. ");
INSERT INTO cam_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ke tai woélé ati, ke lé uce imwi Sostène, pa daame he a mwotapitihi, ke lé piahieng ne he pwahamii a mwopitautinaado. Kehe icehi ana te tice aceli e alihi ne kon wo Galion. ");
INSERT INTO cam_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Mwo te neme bwolihi a bwo mu te Paulo ne Korénit. Ke é mulang, ke e pine ni acéihi. Ke e engen kojalé ne Cenkré na e mwonu. É he e mu lang, ke e tali me tice apunin, pwohewii a patén de lépwo Juif, beme e habwii pie e caa panebwénihi a *piapwo li e pwo. Nebwén, ke lé taa pwo ong nge ha a province Siri, woélé me Priscile me Akilas. ");
INSERT INTO cam_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Ke me lé tehene nge Éféso, ke e engen kojalu wo Paulo, ke e taa ha a mwotapitihi, ke lé picihe me lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Ke lé ileeng pie me e mwo neme mu pelelé. ");
INSERT INTO cam_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Kehe icehi ana e pii telé pie: «Hemepie mwo te nime Padué, ke é o bo mwojuia mwobé céiikewé.» Ke e engen kojalé pwo ong mu Éféso. ");
INSERT INTO cam_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ke me e tehene nge Césaré, ke e taa *Iérusaléma wo Paulo, ke e pwobwocu te ni acéihi. Ke nebwén, ke e ole Antioche ha a province Siri he li e tabuhi a bwo engen den mulang. ");
INSERT INTO cam_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Mwo te pwome bwolihi a bwo mu ten Antioche. Ke é alecehen, ke e engemwo. Ke e â pitahagéi Galat me Frigi, ke e pamwoiu ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","É ha a benaamwon naa, ke e âbé ne Éféso wo pa céiu Juif na pii kon pie Apolos, pa apulie Alexandri. Wo panaa, ke pa apulie na e cihe ehi, ke e temehi ehi ni tii iitihi. ");
INSERT INTO cam_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Ke caa pacémunieng ne ko *a bwo âcéi Padaame. Ke e patemehi a Pwooti Wâé te Kériso ha a ju pwonimen, kehe icehi ana e te ju temehi cehi a *pipuu apulie te Ioane. ");
INSERT INTO cam_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ke e te cihe ne ha a mwotapitihi, ke te tice aceli mwotieng kon. Ke me lu téneeng wo Priscile me Akilas, ke lu pééeng nge pelelu, ke lu pacémunieng ko a pwaadeni Padué. ");
INSERT INTO cam_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Ke nime Apolos me e â Akaï, ke lé pamwoiueng wo lépwo acéihi, ke lé pwotii nge céii ni acéihi na élé lang, beme lé hegieng ehi. Ke me e tehene ngen, ke e caa picani ko ni huô na ubwo, me de nina lé caa céihi, mu ko a pipwoééhe te Padué. ");
INSERT INTO cam_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ke lé picihe me lépwo Juif ne he pwahamii ni apulie ati. Ke te tice aceli me lé pwo ten, be e *pajuujuhi ne telé ko ni tii iitihi pie wo Iésu, ke te weeng kuti pa Mesia. ");
INSERT INTO cam_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","É ha a benaamwon na e mwo teko mu Korénit wo Apolos, ke wo Paulo, ke e pitahagéi ni piduaan ne pwo juwole, ke e â ole Éféso. Ke e too ni béé acéihi lang, ke e tahimwolé pie: ");
INSERT INTO cam_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","«Kona é he li geé céihi, ke e te opé kowé a *Jenen Iitihi?» Ke lé hegi ne ten pie: «Time geme uce temehi pie pwo ace Jenen Iitihi!» ");
INSERT INTO cam_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ke e pii telé pie: «He ace de *pipuu apulie celi puukewé kon?» Ke lé hegi ne ten pie: «Ko a pipuu apulie te Ioane.» ");
INSERT INTO cam_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ke e pii telé wo Paulo pie: «Wo Ioane, ke e puu nina lé pininim, ke lé bitelé ne ko Padué. Ke e pii te lépwo *Juif pie me lé céihi ne ko pa apulie na e bo âbé céin: wo Iésu.» ");
INSERT INTO cam_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ke me lé téne anaa ne ni acéihi, ke lé pwo me puulé ne he nii Padaame Iésu. ");
INSERT INTO cam_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Ke me e ne lupwo in huîilé wo Paulo, ke e ole kolé a Jenen Iitihi, ke lé cihe he ni pwooti na te pétaa ko pi-ité, ke lé pii beetihi ni pwooti na e ne telé wo Padué. ");
INSERT INTO cam_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Piâmwonuhi a 12 a jéhi lépwo apulie naa. ");
INSERT INTO cam_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ke é mulang, ke e taa ha a *mwotapitihi wo Paulo he ni wole na cié. Ke time uce piwâ nang me e patemehi a pwooti nelang. Ke e patemehi, te ni béén na lé ko tabemieng, a *Mwametau te Padué, ke e hane me lé céihi ne ko nina e pii telé. ");
INSERT INTO cam_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Kehe icehi ana hiwon ni béén na lé pwo me mwoiu ni punilé, ke muhi telé me lé céihi. Ke lé pihoonieng ko *a bwo âcéi Padaame, ne he pwahamii ati ni apulie. Ke e engen kojalé wo Paulo, ke e pé ni acéihi, ke e pacémunilé ati he ni tan, ne ha a céiu mwotapitihi te Tiranus. ");
INSERT INTO cam_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","E wonaa a bwo penem den wo Paulo he na alo ni jo. Ke ati nina lé mu ha a province Asia, ni Juif me nina time uce ni Juif, ke lé téne a pwooti te Padaame. ");
INSERT INTO cam_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Ke wo Padué, ke e pwo me e pipwaadeniin bé wo Paulo ni *pipwojunuun na te junihe ité kuti. ");
INSERT INTO cam_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ke lé pé ni epwén me ni memwaanu na e ti kon wo Paulo, ke lé pé nge céii ni cunu, ke caa te wâé jélé kuti! Ke ni duéé na lé mu ko ni béén, ke lé wie, ke lé engen. ");
INSERT INTO cam_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ke te pwo mwo a céiu duaa juif na lé te piengen he ni amu. Ke lé pihane me lé pawiehi ni duéé mu ko ni apulie, ne he nii Padaame Iésu. Ke lé pii telé pie: «É ne he nii Padaame Iésu na e pipatemehieng wo Paulo, ke geé wie!» ");
INSERT INTO cam_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Lépwonaa, ke lépwo 7 naî Séva, pana e te pineeng me pa céiu caa te lépwo *apwoâpwailo. ");
INSERT INTO cam_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kehe icehi ana e hegi ne telé ali duéé pie: «É te temehi Iésu, ke é te temehi mwo Paulo. Ke kona wogewé, ke woo?» ");
INSERT INTO cam_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ke wo pa apulie na e mu kon ali duéé, ke e téele gaale, ke e imwilé, ke e te junihe ahilé kuti. Ke lé cela imi ni ahinaado kolé mu ha a pomwa ten, he caa tice naamuulé! ");
INSERT INTO cam_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Ke lé téne a jepule naa wo lépwo Éféso: wo lépwo Juif, me ni béén na time uce ni Juif mwo. Ke te junihe abwobwo jélé, ke lé tai paciiti Padaame Iésu. Ke lé pii pie: «Nihe ubwo a nii Padaame Iésu!» ");
INSERT INTO cam_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ke hiwon mu ko ni béén na lé caa céihi, na lé âbé pii beetihi ne he pwahamii ati ni apulie ni naado na lé pwo. ");
INSERT INTO cam_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ke a hiwon ko ni apulie na lé mu pacihe ni duéé, ke lé pébé ni tii telé, ke lé cini ne he pwahamii ni apulie. Ke te junihe ubwo a cuhi ati ni tii naa: E taa pwo 50 million. ");
INSERT INTO cam_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ke é mu ko a niihe Padaame, ke a pwooti ten, ke e piân, ke pipamwoiulé ngen. ");
INSERT INTO cam_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ke é alecehe ni naado naa, ke e niimihi wo Paulo pie me e pitahagéi ngen lupwo province Macédoine me Akaï, beme e â *Iérusaléma. Ke e pii mwo pie: «Hemepie é tehene ngen, ke wâé mwo hemepie é â *Rome.» ");
INSERT INTO cam_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ke e ne nge Macédoine lupwo alo apulie mu ko lépwo apicani ten, wo Timoté me Éraste. Ke weeng, ke e mwo tee mu ha a province Asia. ");
INSERT INTO cam_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","É ha a benaamwon naa, ke e penem a amu ko a bwo âcéi Padaame na e pacémunihi wo Paulo. ");
INSERT INTO cam_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Be pwo pa céiu apulie na pii kon pie Démétrius, pa apenem ko ni mwani pwojo. Ke e pwo ko mwani pwojo ni cuwo nahi *mwaiitihi te Artémis, ê céiu duéé. É mu ko a penem naa, ke te junihe ubwo a mwani na lé hegi me lépwo béén. ");
INSERT INTO cam_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ke e taineibu ni apenem den me ni béé apulie na piwie ni penem delé, ke e pii telé pie: «Lépwoli wé, geé temehi pie, ni wâé tenye, ke e âbé mu ko a penem denye ce. ");
INSERT INTO cam_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kehe e pii wo Paulo pie, ni duéé na lé pwo ne ni apulie, ke time uce ni duéé. Ke caa hiwon ni apulie na lé mwomwohi ana e pii, éni pelenye, ke é ati ha a province Asia. Geé caa teko téne he e ko pii, ke geé alihi ninaa. ");
INSERT INTO cam_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Be koli o pwotahi ni penem denye. Ke o tieden a bwo pipaunuhi na a mwaiitihi te ê duéé henye, Artémis! Ke o caa time nye uce pii pie wo Artémis, ke ê duéé henye ubwo! Kehe lé pipaunueng ati ni apulie ne éni Asia, ke é pwo a bwohemwo ati.» ");
INSERT INTO cam_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Ke me lé téne ni pwooti naa, ke lé te junihe okéé kuti, ke lé toii da pie: «Junihe ubwo Artémis tenye ni Éféso!» ");
INSERT INTO cam_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ke me e téne anaa na a pwomwo ubwo, ke hauli jélé. Tai ati ni apulie, ke lé piepin nge ha a mwotapitihi. Ke lé pé Gaïus me Aristarke, lupwo apulie ha a province Macédoine, lupwo béé Paulo ko pipatemehi a pwooti. ");
INSERT INTO cam_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ke nime Paulo me e â beni ni apulie, beme lé picihe, kehe icehi ana lé pacuwoeng wo lépwo acéihi. ");
INSERT INTO cam_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ke te pwo lépwo béé Paulo, lépwo apulie na piubwo jélé bé mu Asia. Ke lé pahede pa apulie me e â pii ten pie: «Go nemwo pihabwiiko te ni apulie ne ha a mwotapitihi!» ");
INSERT INTO cam_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","É ne ko ni apulie Éféso, ke caa time lé uce piténelé. Be lé pii ne ni béén pie woni, ke lé pii ne ni béén pie wonaa. Ke mepwo a ubwo kolé, ke time lé uce temehi pie, é mu ko ade na lé ko pipitilé. ");
INSERT INTO cam_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ke mepwo ni béé Juif, ke lé pé pa céiu apulie na pii kon pie Alexandre, ke lé piuti ten a watihe a pitapitihi te ni apulie naa. Ke lé cineeng beme pa apicihe telé ne he pwahamii a bele. Ke e eti da a in wo Alexandre, beme e ilehi koja ni apulie pie me e cihe. ");
INSERT INTO cam_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Kehe icehi ana me lé temehi pie pa Juif, ke lé toii da he na alo inetéale pie: «Junihe ubwo Artémis tenye ni Éféso!» ");
INSERT INTO cam_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ke e bwo pacuwolé wo pa apwotii te a mwohuô ha a pwomwo ubwo, ke e pii telé pie: «Lépwoli mu Éféso, nye tai temehi ati pie a pwomwo ubwo ce, ke pa apiwéihi mwaiitihi te Artémis, me a démen na iitihi na pwo ko péi, na e tupwo opé mu he miiden! ");
INSERT INTO cam_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Te tice pace céiu celi me e piwotétaa ko anaa. Wâé heme bwala gewé, kehe geé nemwo wele hauli. ");
INSERT INTO cam_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Be geé pébé éni ni apulie ce. Kehe icehi ana te tice aceli lé pwotahi ne ko a mwaiitihi, ke te tice aceli ta celi lé pii ne ko Artémis, ê duéé toomwo tenye. ");
INSERT INTO cam_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","«Wo Démétrius me ni apenem den, ke wieli nimelé me lé hane a ta ne ko pace céiu. Wâé, kehe icehi ana te pwo ni atautinaado, ke te pwo mwo ni tan ko pitautinaado. Geé â ânebuhe lépwo atautinaado! ");
INSERT INTO cam_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ke me mwo te pwo ce naado celi nimewé me geé tahimwohi, ke genye bo picihe ibu, ko ace bwopwonen celi wâé, ha ace tan ko mwohuô. ");
INSERT INTO cam_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Be ni apihuô te ni Roma, ke wieli lé o tahimwokenye pie: “É ko ade na geé pitapitikewé?” Ke o tice aceli genye hegi ne telé kon.» ");
INSERT INTO cam_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Ke é alecehe a bwo cihe ten, ke e pii telé pie me lé pipiiden. ");
INSERT INTO cam_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Me caa nebwén nina e he pipuwohelé, ke e tapiti ni acéihi wo Paulo, ke e pamwoiulé. É alecehen, ke e pinelé, ke e â ha a province Macédoine. ");
INSERT INTO cam_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ke e pitahagéi a Macédoine, ke e te junihe pamwoiu ni acéihi na lé mu lang, ko ni pwooti na hiwon. Ke é mulang, ke e â Grèce. ");
INSERT INTO cam_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ke e mwo mu lang he na cié wole. Ke é ha a benaamwon na me e taa pwo ong nge ha a province Siri, ke e téne pie lé pwo me lé pipwohuô ten wo lépwo *Juif. Ke e niimihi pie me e mwojuia ngemwo Macédoine. ");
INSERT INTO cam_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Hiwon ni apulie na lé âcéin: wo Sopater mu Béré, pa naî Pirus, ke wo Aristarke me Sekond mu Tésalonik, ke wo Gaïus mu Derbe. Ke pwo Timoté; ke wo Tichike, me Trofime, mu ha a province Asia. ");
INSERT INTO cam_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Ke lé piânebuheme, ke lé bwo ucéikeme ne Troas. ");
INSERT INTO cam_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ke mepwo é ne kome, ke geme taa pwo ong mu Filipi, alecehe a tan ubwo te ni Juif, a *Pacika. Ke é alecehe ni tan na nim, ke geme bwo toolé ne Troas. Ke geme mwo mu lang he na céiu naadenitan. ");
INSERT INTO cam_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","É he capéto ko a babwén, ke geme pimu ibu me geme pé wiinaado, ke geme ebii a pwoloa. Ke e pacihe ni acéihi wo Paulo, die ko awieme bwén, be e o caa engen ko acaama. ");
INSERT INTO cam_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Geme tai mu ha a nemwa ko miiden. Ke te junihe hiwon ni miû lang na pwéélang. ");
INSERT INTO cam_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Pwo pa ewa aiu, na pii kon pie Eutike, na e tebwo ha a pomwa-he-puwo. Ke e te pwo jame cihe wo Paulo, ke e pawie pule wo paje, ke e tupwo mu ha a béciéhe ni nemwa da ko miiden. Ke me lé pwiieng, ke he e caa mele. ");
INSERT INTO cam_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Ke e ole wo Paulo, ke e ciieng, ke e haaieng, ke e pii pie: «Geé nemwo pwo me mwotikewé, be e mwo teko mulie!» ");
INSERT INTO cam_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ke me e taamwo wo Paulo, ke e ebii a pwoloa, ke lé eni. Ke e mwo te cihe die pwopwometan. Ke é alecehen, ke e engen kojalé. ");
INSERT INTO cam_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ke wo lépwo acéihi, ke lé pipé ngemwo pali ewa aiu nge pelen. Ke te junihe wâé ne kolé. ");
INSERT INTO cam_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Geme ânebuhe Paulo pwo ong, be weeng ke nimen me e engen pwo amu die Assos, ke geme bo pééeng mulang. ");
INSERT INTO cam_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Ke me e âbé tookeme, ke e taabé céiikeme ne pwo ong, ke geme â Mitilène. ");
INSERT INTO cam_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","É mulang, ke geme caa engen pwo ong, ke geme tuie nge Kio, ha acaama. É ha a tan alecehen, ke geme tuie nge Samos, ke é ha a tan alecehen mwo, ke é Milet. ");
INSERT INTO cam_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Be e caa te pihuôhi wo Paulo pie time e o uce cuwo Éféso, be time uce nimen me e patieden tan ne Asia. Be e piwele, beme e tehene nge *Iérusaléma, hemepie te jan, ha a tan ko Pentekote. ");
INSERT INTO cam_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Ke me geme tehene nge Milet, ke e patupwo pwooti wo Paulo nge céii ni apihuô te lépwo acéihi ne Éféso, beme lé âbé beniieng ne Milet. ");
INSERT INTO cam_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Ke me lé pimu ibu, ke e pii telé pie: «Geé caa te alihi a mulie na é mu hen ne ha awiemewé, tabuhi ha a tan na é tuiebé pelewé ne ha a province Asia. ");
INSERT INTO cam_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Ke é penem de Padué, ke time é uce pipii dong. Ke é he ni béé tan, ke é mu é, be é te junihe picani ko ni huô na ta na lé pwo tong wo lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Geé caa temehi, be é caa te pii tewé ati nina wâé me dewé, ke te tice aceli é neduwohi kowé. Be é patemehi me pacémunikewé, ne ânebuhe ati ni apulie, ke é ne mwo he ni pomwa tewé. ");
INSERT INTO cam_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","É pii mwoiuhi te ni Juif, me nina time uce ni Juif mwo, pie me lé pininim, me bitelé ne ko Padué, ke me lé céihi ne ko Padaame henye, Iésu Kériso.» ");
INSERT INTO cam_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","«Ke é jenaa, ke é o mwo â Iérusaléma, be e teko cuwokong a *Jenen Iitihi, kehe time é uce temehi aceli e o tuie ne kong. ");
INSERT INTO cam_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kehe icehi ana e mu te paténeéo ne he ni amu, na a Jenen Iitihi pie, a karépu me a picani, ke lu teko ucéiéo. ");
INSERT INTO cam_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Kehe icehi ana te piticenaado ne kon, heme é mele, ai heme é mulie. Be weengi ana te junihe pwonaado ne kon: Me é panebwénihi a penem na e ne tong wo Padaame Iésu, pie me é pipatemehi a Pwooti Wâé, ko a pipwoééhe te Padué. ");
INSERT INTO cam_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","«É patemehi nge pelewé a *Mwametau te Padué. Ke é jenaa ni, ke é temehi pie, o caa time nye bo uce pialikenye mwo. ");
INSERT INTO cam_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","É mu ko anaa, na é pii mwoiuhi tewé jenaa ni pie, mepie pwo pace céiu pibééwé celi o tieeng pele Padué, ke time uce woéo pa watihen. ");
INSERT INTO cam_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Be é caa patemehi tewé, ati nina nime Padué me e pwo. Ke te tice celi é neduwohi kowé.» ");
INSERT INTO cam_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","«Geé pipwocilekewé, ke geé pwoiipihi ehi mwo ni naî Padué, na e caa nebwén ko nelé tewé na a Jenen Iitihi. Ke geé wéi ni acéihi, woélé na e caa pwocuhilé wo Padué, ko a bwo mele te pa Naîn. ");
INSERT INTO cam_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Be é te temehi pie, é alecehe a bwo engen dong, ke lé o tuiebé ni apulie na ni agele. Ke lé o pwohewii ni wota apiwii, ke lé o papiidenihi a pubuuwé. ");
INSERT INTO cam_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ke te é mu hadeniiwé mwo, na lé o cuwoda nina lé pacémunihi a gele, beme lé teuu ni acéihi céilé.» ");
INSERT INTO cam_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","«Geé te ûmiê, ke geé te niimihi pie, caa cié ni jo na é mu pelewé: Ke pwo ni béé benaamwon, na é mu â é, heme é mu pamwoiukewé, heme bwén ke pwang. ");
INSERT INTO cam_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Ke é jenaa ni, ke é nekewé te Padué, me a pwooti he a pipwoééhe ten. Be weeng na eten a junuun me e pamwoiukewé, me ne tewé ni pipwowâé na e caa nebwén ko pipwopweehi me de ni apulie ten. ");
INSERT INTO cam_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","«É he é mwo ko mu pelewé, ke time uce nimung ko ce mwani pwojo, me ce mwani megele, me ce epwéne ce béé apulie. ");
INSERT INTO cam_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Be geé caa te temehi pie, te lupwo naatiing ce na é penem kon, be me deme, me ni bééng. ");
INSERT INTO cam_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Ke é caa habwii tewé ati a bwo penem, me nye picani te nina cunu jélé me nina tice delé. Ke genye penem niimihi ni pwooti te Padaame Iésu na e pii pie: “Te junihe ubwo a pipwodéén de pana e ne, koja pana e hegi.”» ");
INSERT INTO cam_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ke é alecehe a bwo cihe ten naa, ke e tidihi jilin wo Paulo, ke lé tai pwoiitihi ibu. ");
INSERT INTO cam_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Ke lé mwomwaaueng beme lé pineeng, ke lé te ju tai é ati. ");
INSERT INTO cam_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Be te junihe piwahin ni pwonimelé ko ana e pii telé pie, o caa time lé bo uce pialilé mwo. Ke é mulang, ke lé pipééeng ole die pwo ong. ");
INSERT INTO cam_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Geme pinekeme me ni apihuô te ni acéihi ne Éféso, ke geme taa pwo ong, ke geme téte mwomwon nge Kos†. Ke é ha acaama, ke geme â taa Rode, ke é mulang, ke geme â Patara. ");
INSERT INTO cam_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","É nelang, ke geme tooli a ong nge Fénisi, ke geme taa pwon, ke geme engen. ");
INSERT INTO cam_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Ke geme alihi a één Chipre, ke geme neeng pwo eaamu. Ke geme â ha a province Siri, ke geme ti ha a céiu pwomwo ubwo nelang, na pii kon pie Tir, é lang he na me eaatihi nelang ni âicu. ");
INSERT INTO cam_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ke me geme too ni acéihi lang, ke geme mu pelelé he na céiu naadenitan. Ke e cinelé na a *Jenen Iitihi, pie me lé pii te Paulo pie me e nemwo taa *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Kehe icehi ana é alecehe a naadenitan na céiu, ke geme cuwo ha a pwobenele ko a engen deme. Ke lé pipéékeme ne ni a-mu lang, woélé me ni mwodelé, me ni naîlé. Lé pipéékeme die ticepwon. Ke me geme tehene ole, ke geme tidihi jilime, ke geme pwoiitihi. ");
INSERT INTO cam_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nebwén, ke geme taa pwo ong, ke lé mwojuia ngemwo pelelé. ");
INSERT INTO cam_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Ke geme engen mu Tir, ke geme â Tolémaïs, atii ne ong. É mulang, ke geme â pwobwocu te ni acéihi, ke geme mwo te ju ne me mu pelelé he na céiu tan. ");
INSERT INTO cam_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Geme â Césaré ha acaama. Ke me geme tehene ngelang, ke geme pimu pele Filip, pa apipatemehi na a Pwooti Wâé, pa céiu béé ni 7 dikone li pipégalilé ne Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Wo panaa, ke paa ni naîn toomwo na ni péroféta, na lé pébé a pwooti mu pele Padué. ");
INSERT INTO cam_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Ke caa junihe hiwon ni tan deme ha a duaan naa. Ke, é ha a benaamwon naa, ke e tuie opé mu *Judé wo pa céiu péroféta, na pii kon pie Agabus. ");
INSERT INTO cam_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ke me e tookeme, ke e pé a taihena Paulo, ke e cie lupwo an ke lupwo in kon, ke e pii pie: «Weengi ana e pii na a Jenen Iitihi: “Wo pa apulie na den a taihena ce, ke lé o woni ko ace bwo cieeng wo lépwo *Juif ne Iérusaléma. Ke lé o bo neeng de nina time uce ni Juif.”» ");
INSERT INTO cam_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Me geme téne anaa, wogeme me ni a-mu lang, ke geme cuwoko Paulo pie me e nemwo taa Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Kehe icehi ana e hegi ne teme pie: «É ko ade na geé é, me pwo me piwahin a pwonimung? Hemepie cieéo me taunuéo ne ko a nii Iésu ne Iérusaléma, ke é caa te pipwopweeéo.» ");
INSERT INTO cam_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Ke he time uce jan me geme taatééhi a bwo niimihinaado ten, ke geme nebwén a bwo cuwokon, ke geme pii pie: «Wâé hemepie e cuwo ana nime Padaame kon.» ");
INSERT INTO cam_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","É alecehe ni tan naa, ke geme pipwopweekeme, ke geme taa Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Ke lé âbé céime ne ni béé acéihi mu Césaré, ke lé péékeme nge céii pa apulie na pii kon pie Mnason, beme geme pimu pelen. Wo panaa, ke pa apulie pwo a één Chipre, pana caa bwolieng ha a céihi. ");
INSERT INTO cam_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Ke me geme tehene nge Iérusaléma, ke lé hegikeme ha a pipwodéén ne ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","A tan alecehen, ke e ole pele Cang wo Paulo, ke geme ole céin. Ke lé tai pitapitilé nelang wo lépwo apihuô te ni acéihi. ");
INSERT INTO cam_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Ke me e pwobwocu telé ati wo Paulo, ke e piuti telé ati ni naado na e pwo wo Padué, ne ha awieme ni béén na time uce ni Juif, ha a benaamwon na e pipatemehi telé a pwooti. ");
INSERT INTO cam_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Ke me lé téne anaa, ke lé te junihe pipaunu Padué. Ke é alecehen, ke lé pii te Paulo pie: «Go téne, go pa acéihi bééme, caa te junihe hiwon ni Juif na lé caa céihi ne ko Iésu na lé mwo teko âcehi ni *patén de Moosé. ");
INSERT INTO cam_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Ke lé téne pie wogo na go picaa te ni Juif pie, he lé pimulie ibu me ni béé apulie, ke me lé bitelé koja ni patén de Moosé. Ke lé téne mwo pie, go pii pie, me lé nemwo *pwotegoop te ni naîlé, ke me lé nemwo âcehi a bwomu te ni Juif. ");
INSERT INTO cam_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Nye o bo pwo de? Be {lé o pitaineibulé ne ni apulie be} lé o caa temehi pie wogo éni. ");
INSERT INTO cam_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","«É mu ko anaa, ke wâé heme go pwo ana geme pii tem: Be élé éni hadeniime lépwo apulie na paa jélé na lé pwo ni *piapwo te Padué. ");
INSERT INTO cam_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Wâé heme go péélé céim, beme geé pwo a pwoiitihi tenye† na e pwo me wâé genye ne pele Padué. Ke go pwocuhi nina tice telé ko a penem naa, beme lé o pwo me tice iwo ni punilé. Ke lé o temehi ne ni apulie pie ana lé téne ne kom, ke a gele. Ke o te wogo mwo, ke go o habwii pie, pana go te pipwoiipiko mwo, ne ko ni patén.» ");
INSERT INTO cam_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","«Ke mepwo é ne ko nina time uce ni Juif na lé caa céihi, ke geme caa pwotii nge céiilé. Ke geme pii telé a huô teme: “Geé nemwo wii ni mewota na *pwoâpwailo kon ne te ni *déme duéé. Geé nemwo wii ni mewota na mwo cewéle, me ni wota na ebunuhi, be time e uce wie a cewéhelé. Ke geé nemwo pibune, ke geé nemwo pipule hauli.”» ");
INSERT INTO cam_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Ke e ko a bwo niimihinaado telé, ke é ha a tan alecehen, ke e pé ni apulie na paa wo Paulo. Ke lé tabuhi me weeng a *pwoiitihi ko a bwo wâé genye ne pele Padué, pwohewii a patén de ni Juif. Ke é alecehen, ke e taa *huâ iitihi wo Paulo, ke e pii beetihi a tan na lé o bo muko pétaapwo pwoâpwailo hen, beme lé habwii pie lé caa panebwénihi a piapwo telé. ");
INSERT INTO cam_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Ke é ha a bé7 he ni tan naa, he lé o caa panebwénihi a piapwo telé, ke ni Juif mu ha a province Asia, ke me lé ali Paulo ne ha a *mwaiitihi, ke lé pine ânepuni ni apulie beme lé imwieng. ");
INSERT INTO cam_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ke lé pii pie: «Lépwo *Isaraéla, geé âbé picani teme! Weengi pa apulie na e piuti pitihi ati pie me pihoonihi a bele tenye, me ni patén de Moosé me a mwaiitihi ce! Ke é jenaa, ke e caa pwo me tice junuu mwo a duaan ce iitihi, be e caa ne da lang nina time uce ni Juif!» ");
INSERT INTO cam_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Lé pii anaa be lé alilu neibu me Trofime, pa apulie mu Éféso, ne Iérusaléma, ke lé niimihi pie, e pééeng da huâ iitihi wo Paulo. ");
INSERT INTO cam_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ke ati a pwomwo ubwo naa, ke iluuhi, ke lé téelebé ati ne ni apulie, ke lé imwi Paulo. Ke lé teuueng wie mu huâ iitihi, ke lé te pwome capuhi kuti ni pomwa. ");
INSERT INTO cam_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Ke lé caa pihane beme lé taunueng. Kehe icehi ana e téne wo pa apihuô te ni coda roma pie, lé ko iluulé ati wo lépwo Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Ke e te pwome pé kuti ni coda, me ni caa telé, ke lé téte nge céiilé. Ke me lé alilé ne ni apulie, ke lé te nebwén kuti na lé ahi Paulo. ");
INSERT INTO cam_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","E te ân kuti wo pali apihuô te ni coda, ke e te imwi kuti Paulo, ke e cieeng ko lupwo itihe toki. Ke e tahimwo ni apulie pie: «He woo paje? Ke ade aceli e pwo?» ");
INSERT INTO cam_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ke lé pii ne ni béén pie woni, ke lé pii ne ni béén pie wonaa. Ke time e uce temehi wo pali pie woo celi e juuju, be lé te junihe iluulé, ke e pii pie me pé Paulo da ha a mwocoda. ");
INSERT INTO cam_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Ke me lé tuie nge ko a aca, ke lé caa te ju pitemeeng, be lé te junihe okéé ne ni apulie, ke nimelé me lé ahieng. ");
INSERT INTO cam_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Be lé tai âcéin ati, ke lé toii pie: «Neeng, beme geme taunueng!» ");
INSERT INTO cam_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ke é ha a benaamwon na ko ne da Paulo he mwocoda, ke e pii te pa apihuô te ni coda he pwo *grek pie: «He o te jan me é pii tem a céiu naado?» Ke e hegi ne ten pie: «Kona go te temehi pwo grek? ");
INSERT INTO cam_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Kona time uce wogo pa *Aigupito, pali e pwo me e penem a amu? Pana e pé nge jengedé ha a melé li 4000 pwéréca?» ");
INSERT INTO cam_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Ke e pii ten wo Paulo pie: «Ûhu! Woéo ke pa Juif, pana é tuie ne Tarse, a pwomwo ubwo ko a province Silisi, a pwomwo na te junihe ubwo. Ke é ilehi kojako pie, he time uce jan me é pacihe ni apulie ce?» ");
INSERT INTO cam_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Ke e pii wo paje pie: «Îgo!» Ke e cuwo pwo ali aca wo Paulo, ke e pwo inenaado te ni apulie ko a in. Ke me te ju tice pwocihe kuti, ke e pacihelé wo Paulo, ha a pati ni Juif. ");
INSERT INTO cam_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Ke e pii wo Paulo pie: «Lépwo âjiénung me lépwo caa, geé téne ana me é pii tewé ni, beme é pipwopaing.» ");
INSERT INTO cam_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Ke me lé téne he e pacihelé he pwo patilé, ke bwo te junihe tice patilé kuti. Ke e pii wo Paulo pie: ");
INSERT INTO cam_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Woéo ke pa *Juif. É pituie ne Tarse ha a province Silisi, kehe icehi ana picileéo ne éni *Iérusaléma. Ke wo Gamaliel na e pacémuniéo. Ke e picaa tong ehi ni patén de ni watihenye. Pana é ûmiê me de Padué pwohewiikewé ati jenaa. ");
INSERT INTO cam_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","É pwotahi, me pwo me taunu ni béén na lé âcéi Padaame Iésu. Ke é pwo me imwi ni aiu me ni toomwo mwo, ke é tahilé ne he karépu. ");
INSERT INTO cam_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","«Jan me lé pajuujuéo wo pa *daame he lépwo apwoâpwailo me ni *mwohuô. Be é hegi kojalé ni tii, beme é ne te ni âjiénenye, ni Juif na lé mu Damas. Ni tii naa, ke lé ne mwomwon dong, me é â lang, me é â imwi nina lé céihi ne ko Iésu, ke me é péélé bé ne Iérusaléma beme lé pwocuhinaado.» ");
INSERT INTO cam_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Kehe icehi ana me é ko â he pwaaden, he teko ju goahen ehi, he é ko âmwonuhi Damas, ke e te âbé kuti mu jeda he miiden a pwéélang na te junihe ubwo, ke e pwoeihiéo. ");
INSERT INTO cam_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Ke é te tupwo kuti ne pwo bwohemwo. Ke é téne a pwocihe na e pii pie: “Saulo, Saulo, é ko ade na go pwotahi ne kong?” ");
INSERT INTO cam_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","«Ke é hegi ne ten pie: “Wogo, ke woo, go pa daame?” «Ke e hegi ne tong pie: “Woéo Iésu mu Nazaret, pana go ko pwotahi ne kong.” ");
INSERT INTO cam_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","«Lé te alihi a pwéélang wo lépwona lé âcéing, kehe icehi ana time lé uce téne a pwocihe te pana e paciheéo. ");
INSERT INTO cam_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","«Ke é pii pie: “Padaame, ade aceli me é pwo?” Ke e hegi ne tong wo Padaame pie: “Go cuwoda, ke go â Damas, be o bo pii tem nelang aceli me go pwo.” ");
INSERT INTO cam_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","«Ke me é niê, ke caa time é alikenye. Ke lé bwo te ju pétaa ko ing ne ni bééng, ke lé pééo nge Damas. ");
INSERT INTO cam_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","«Ke pwo pa céiu apulie lang, na pii kon pie Ananias. Wo panaa, ke pa apulie na e te junihe pipwoiipieng me âcehi ni *patén de Moosé. Ke lé te junihe piwâéeng ati ne ni Juif na lé mu Damas. ");
INSERT INTO cam_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ke e âbé beniéo wo panaa, ke e pii tong pie: “Saulo, pa acéihi bééng, go niê mwo!” «Ke é caa te ju niê ehi mwo, ke é alieng. ");
INSERT INTO cam_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Ke e pii tong pie: “E caa pipégaliko wo Padué he ni watihenye, beme go temehi ana nimen kon, beme go ali Pana e mwomwon, wo Iésu, ke me go téne a patin heme e cihe tem. ");
INSERT INTO cam_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Be go bo pa apé na a juuju ten, ne pele ni apulie ati, ko ni naado na go alihi me téne. ");
INSERT INTO cam_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ke é jenaa, ke he ade aceli go ucéihi? Go cuwoda me puuko. Ke go pwoiitihi te Padaame, beme e pineuhi ni ta pwo tem.”» ");
INSERT INTO cam_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«Ke é alecehen, ke é caa mwojuia mwo ne Iérusaléma. Ke é ha a céiu tan, he é mwo ko pwoiitihi ne *huâ iitihi, ke e pihabwiieng dong ne ha a jenung wo Padaame, ke é alieng. ");
INSERT INTO cam_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ke e pii tong pie: “Go piepin, ke go wie epin mu Iérusaléma, be o time lé uce hegi a bwo pajuujuéo tem ne ni apulie éni.” ");
INSERT INTO cam_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","«Ke é hegi ne ten pie: “Padaame, lé te temehi pie é â he ni *mwotapitihi, ke é pwo me imwi nina lé céihi ne kom. Ke é pwo me ahilé, ke é nelé da he karépu. ");
INSERT INTO cam_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ke é he taunu Étienne, pa eabwé tem, ke é te mu lang mwo. Be woéo pa céiu na é te picani telé ne ko a bwo niimihinaado telé, ke é wéihi mwo ni epwéne lépwona lé taunueng.” ");
INSERT INTO cam_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","«Kehe icehi ana e pii tong wo Padaame pie: “Go wie mu Iérusaléma be é bo neko nge, he na e éité lang, pele nina time uce ni Juif.”» ");
INSERT INTO cam_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Lé tabemi Paulo die lang ne ni Juif, kehe icehi ana me e pii pie e â céii nina time uce ni Juif, ke lé te okéé kuti ke lé toii da pie: «Taunueng! Be time uce jan me e mulie!» ");
INSERT INTO cam_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ke lé te wiikau kuti, ke lé céi taabwon ni epwénelé, ke lé pwo muu pule. ");
INSERT INTO cam_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Wo pa apihuô te ni coda roma, ke e pwo me lé pé da Paulo he mwocoda, beme tatieng ko bwaliiwota, beme e pii telé ace watihen me lé uu ke me lé okéé ne kon ne ni Juif. ");
INSERT INTO cam_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Kehe icehi ana me lé cieeng beme lé tatieng, ke e pii wo Paulo te pa céiu caa te coda na e mu lang pie: «Kona te pwo mwomwon dewé me geé tati pana e mu ha a tii tewé, ni Roma, na mwo time uce tautieng?» ");
INSERT INTO cam_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Ke e téetihi wo pali caa te coda he e téne anaa, ke e â paténe pa apihuô telé, pie: «Go pipwocile aceli me go pwo te pa apulie ce, be pa Roma!» ");
INSERT INTO cam_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Ke e âbé too Paulo wo pali apihuô, ke e tahimwoeng pie: «Go paje, te wogo kuti ha a tii tenye ni Roma?» «Éa.» ");
INSERT INTO cam_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ke e pii wo pali apihuô te ni coda pie: «Te junihe hiwon ni mwani na é ne beme é Roma!» Ke e pii wo Paulo pie: «Woéo ke é he é pituie, ke é caa te Roma.» ");
INSERT INTO cam_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ke me e téne anaa, ke te junihe mwotieng kuti. Be iitihi me lé cie pana e ha a tii telé. Ke lé te neeng kuti ne ni coda na lé pwo me lé tatieng, ke lé engen. ");
INSERT INTO cam_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Nime pa apihuô te ni coda me e temehi ace watihen me lé tééti Paulo ne ni Juif. Ke é ha acaama, ke e pihuôhi ne te ni *apwoâpwailo, me ati a mwohuô te ni Juif, pie me lé pipitilé. Ke me lé pipitilé, ke e te pwo me tuwo ni itihe toki ko Paulo, ke lé pééeng bé, ke lé neeng ha awiemelé. ");
INSERT INTO cam_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Ke e te ju ome ni *mwohuô wo Paulo, ke e pii telé pie: «Lépwo âjiénung, time uce pipenem a pwonimung ne he pwahamii Padué, ko a mulihung dieli jenaa.» ");
INSERT INTO cam_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Ke me e téne anaa wo Ananias, pa *daame he lépwo apwoâpwailo, ke e okéé. Ke e pahede nina lé mu mwonu Paulo pie me lé ahi a pwon. ");
INSERT INTO cam_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ke e pii ten wo Paulo pie: «E bo pwocuhin ne tem wo Padué! Be nimem me go tautiéo ko ni patén, kehe icehi ana go piâ ité koja ni patén, be go pwo me lé ahiéo! Wogo, ke te ju wâé a pwom, kehe icehi ana a pwonimem, ke te junihe melepiing hen!» ");
INSERT INTO cam_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Ke ni béén na lé mu cebwo Paulo, ke lé pii ten pie: «Éé! Go ko pii me ta pa daame he lépwo apwoâpwailo te Padué!» ");
INSERT INTO cam_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Ke e hegi ne telé wo Paulo pie: «Pineuéo wogewé lépwo bééng, be time é uce temehi pie, weeng pa daame he lépwo apwoâpwailo! A juuju pie caa te tii ne he ni tii iitihi pie: Go nemwo cihe me ta ne ko pa apihuô te a bele tem.» ");
INSERT INTO cam_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","E te temehi wo Paulo pie, nina lé mu ha a mwohuô, ke pwo ni *Farasaio, me ni *Saducéen. Ke e pii telé pie: «Lépwo âjiénung! Woéo ke pa Farasaio, ke wo caa tong ke pa Farasaio, ke é céihi ne ko a bwo mulie cemwo te ni amele. Ke é ko anaa na lé tautiéo.» ");
INSERT INTO cam_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Ke me e pii anaa, ke ni Farasaio me ni Saducéen, ke lé te piokéé kuti ke lé pipiiden. ");
INSERT INTO cam_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Be lé pii ne ni Saducéen pie, te tice mulie cemwo te ni amele, te tice *âcélo, ke te tice duéé. Ke mepwo é ne ko ni Farasaio, ke lé céihi ne ko ati ninaa. ");
INSERT INTO cam_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ke me lé caa ko junihe picihe da, ke lé te cuwoda kuti ni béé *dotéén ko patén mu ha awieme ni Farasaio. Ke lé pii pie: «Te tice aceli geme alihi celi ta, celi e pwo wo pa apulie ce. Wieli e cihe ne kon na ace âcélo?» ");
INSERT INTO cam_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ke me caa â piubwo da ali bwo piokéé telé, ke e niimihi wo pa apihuô te ni coda pie, lé o pitanahi Paulo, ke e pii te ni coda ten pie me lé ole pééeng daamwo he mwocoda. ");
INSERT INTO cam_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","É he bwén, ke e piâbeeti Paulo wo Padaame, ke e pii ten pie: «Go mwoiu! Be go caa pajuujuéo ne *Iérusaléma, ke wâé mwo heme go pajuujuéo ne *Rome.» ");
INSERT INTO cam_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","É ha acaama hen, ke lé pine huô ne ni béé *Juif, ke lé *piapwo pie, o time lé uce wiinaado me ûdu ânebuhe ace bwo taunu Paulo. ");
INSERT INTO cam_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Ni apulie naa, ke eda koja a 40 jélé. ");
INSERT INTO cam_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ke lé â too ni caa te ni apwoâpwailo me ni apihuô, ke lé pii telé pie: «Geme caa piapwo pie, time geme o uce wiinaado, dieli heme geme bo taunu Paulo. ");
INSERT INTO cam_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Ke anaa, wâé heme geé neme ilehi koja pa apihuô te ni coda pie, me e pébé céiikewé Paulo, wogewé me ati ni mwohuô. Ke geé pii ten pie, nimewé me geé temehi ehi aceli e pwo. Ke wogeme, ke geme pipwopweekeme, beme geme taunueng ânebuhe ace bwo tuiebé ten ne éni.» ");
INSERT INTO cam_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Kehe icehi ana wo pa acim ko Paulo, ke e téne pie lé pwo me lé pipwohuô te Paulo. Ke e taa paténeeng ne he mwocoda. ");
INSERT INTO cam_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ke me e téne a pwooti naa wo Paulo, ke e tode pa céiu caa te coda, ke e pii ten pie: «Go pé ngen pa ewa aiu ce pele pa apihuô tewé, be pwo a céiu naado na nimen me e pii ten.» ");
INSERT INTO cam_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Ke e pé paje, ke e pééeng nge céii pa apihuô ten, ke e pii ten pie: «E todeéo wo Paulo, pa apwokarépu, ke e pahedeéo me é pébé céiiko pa ewa aiu ce, be pwo ace naado celi nimen me e pii tem.» ");
INSERT INTO cam_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Ke e pétaa ko i pali nahi aiu wo pali apihuô, ke lu tabuhi gaaté cuwo, ke e tahimwoeng pie: «Ade aceli nimem me go pii tong?» ");
INSERT INTO cam_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Ke e hegi ne ten pie: «Lé mi piténelé wo lépwo Juif beme lé ilehi kojako pie, me go bo pwo me e âbé meé wo Paulo ne ânebuhe a mwohuô telé. Be wieli lé o pii tem pie, nimelé me lé temehi ehi aceli e pwo. ");
INSERT INTO cam_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Kehe icehi ana go nemwo piténedelé! Be lé o pipwohuô ten. Be piwoélé da koja 40 lépwona lé caa piapwo pie, o time lé o uce wiinaado ke ûdu, die ko ace bwo taunueng. Ke é ha a benaamwon ce, ke lé caa nebwén ko pipwopweelé, ke lé ju ucéihi aceli me go pii.» ");
INSERT INTO cam_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Ke e hegi ne ten wo pa apihuô pie: «Go nemwo uti a bwo picihe tenyu!» Ke e neeng me e engen. ");
INSERT INTO cam_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","E tode lupwo caa te coda ten wo pa apihuô, ke e pii telu pie: «Geu pipwopweehi celi 200 coda celi lé pé teua, ke 70 coda celi lé tebwo pwo haricaan, ke 200 coda celi lé nuô da, beme lé â Césaré heme 9 inetéale ko a babwén. ");
INSERT INTO cam_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Geé pwopweehi mwo ce haricaan, beme lé pé Paulo nge pele pa gupéno Félix. Ke geé wéieng ehi, beme time uce tuie ne kon celi ta.» ");
INSERT INTO cam_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ke nebwén, ke e tii a tii ce: ");
INSERT INTO cam_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Klaude Lisias ne te gupéno Félix, bwocu! ");
INSERT INTO cam_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Pa apulie ce, na lé imwieng wo lépwo Juif beme lé o bo taunueng. Ke é âbé me ni coda, beme é pééeng kojalé, be é temehi pie pa Roma. ");
INSERT INTO cam_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Nimung me é temehi ace watihen celi lé imwieng kon, ke é pwo me e tautieng a mwohuô telé. ");
INSERT INTO cam_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ke é alihi pie heme lé pipé ne kon, ke te é mu ko ni patén delé, kehe te tice aceli me pipé ne kon kon, celi jan me taunueng kon, ai me e pwokarépu kon. ");
INSERT INTO cam_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","É he patemehi tong ana me lé pwo ne ko pa apulie ce, ke é te pwome neeng lé céiiko, me lépwona lé pipé ne kon. Ke é pwo ko pii telé pie, me lé patemehi tem celi lé pipé ne kon kon. ");
INSERT INTO cam_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","É he bwén, ke wo lépwo coda, ke lé pwo ana e pii telé wo pa apihuô telé, ke lé pé Paulo nge ha a pwomwo ubwo Antipatris. ");
INSERT INTO cam_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","É ha acaama, ke lé mwojuia mwobé ne he mwocoda wo lépwo béé coda, ke lé te ne lépwo atebwo pwo haricaan me lé ân me weeng. ");
INSERT INTO cam_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","É he lé tehene nge Césaré, ke lé ne te gupéno ali tii, ke lé ne Paulo ten. ");
INSERT INTO cam_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","E pine a tii wo pali gupéno, ke e tahimwo Paulo pie: «He go âbé mu ha ace duaan celi woté?» Ke e hegi ne ten wo Paulo pie: «É âbé mu Silisi.» ");
INSERT INTO cam_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Ke e pii pie: «É bo tautiko hemepie lé bo âbé pipatemehilé wo lépwona lé pipé ne kom.» Ke e huôhi pie me lé ne Paulo ha a karépu ne ha a mwodaame na e pwo wo *Érode pa Bécéiuhen. ");
INSERT INTO cam_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Ke nim ni tan alecehen, ke lé tuie ole Césaré wo Ananias, pa *daame he lépwo apwoâpwailo, me ni béé ukéiu te ni *Juif, me pa avoka na pii kon pie Tertule. Ke lé too gupéno Félix, ke lé pitéteiminaado ten ne ko Paulo. ");
INSERT INTO cam_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Ke e todebé Paulo wo pali gupéno beme e cuwo ânebuhen. Ke e pipé ne ko Paulo wo Tertule ne he pwahamii pali gupéno ke e pii pie: «Gupéno Félix, é hemepie geme mulie ha a péém, ke wonaa mu kom, ke é mu ko ni bwo huô tem, me a bwo pé ehi nen dem a amu teme. ");
INSERT INTO cam_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Geme pwo-olé tem, he ni ju pwonimeme, ko ni naado naa. ");
INSERT INTO cam_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Time uce nimung me é pé kojako ce benaamwon celi bwali, é mu ko anaa, na é ileko pie go te ju picani, beme go tabemi ehi celi é o pii tem. ");
INSERT INTO cam_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","«Geme alihi pie wo pa apulie ce, ke te junihe pa apulie ta kuti, be e hane pwo-okéé ko lépwo Juif ati pwo a bwohemwo, be pa caa te a céiu pubu apulie Nazaréen. ");
INSERT INTO cam_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Weeng mwo, ke e te hane me e pwo ni naado beme e habwii pie time e uce pipaunuhi a *mwaiitihi. Ke é mu ko anaa, na geme imwieng {be nimeme me geme tautieng âcehi ni patén deme. ");
INSERT INTO cam_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","«Kehe icehi ana wo pa apihuô te ni coda, Lisias, ke e âbé, ke e te pwome pééeng kojakeme. ");
INSERT INTO cam_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ke e pii te lépwona lé tauti Paulo pie me lé âbé céiiko, beme lé pii tem ni naado na ni watihe a bwo tautieng.} Tahimwo pa apulie ce, be go bo alihi pie ati nina geme pipé ne kon, ke te ni juuju.» ");
INSERT INTO cam_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Lé piténelé wo lépwo Juif, ke lé pii pie ana e pii wo avoka Tertule, ke te a juuju. ");
INSERT INTO cam_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wo gupéno, ke e pwo inenaado te Paulo pie me e cihe. Ke e pii wo Paulo pie: «É te temehi pie, wogo pa apihuô, ke go tauti a amu teme lépwo Juif, he ni jo na hiwon. Ke time uce pinekepé ne tong me é pipwopaing ne he pwahamiim. ");
INSERT INTO cam_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","«Go tahimwohi lé, be time uce téele wédenihi celi 12 ni tan na é tuiebé ne *Iérusaléma, me é pipaunu Padué. ");
INSERT INTO cam_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Ke time é uce pine puni ke cine ni apulie ne *huâ iitihi, ke é ne he ni *mwotapitihi, ke é ne ha a pwomwo ubwo Iérusaléma. Ke te tice apulie celi lé pii pie lé aliéo, he celi é ko pwo ninaa. ");
INSERT INTO cam_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ke é jenaa, ke ni apulie ce, ke time uce jan me lé *pajuujuhi ne tem, nina lé tautiéo kon. ");
INSERT INTO cam_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","«A juuju pie pana é âcéi Padaame nge ha a pwaaden na mwo coho he é pipwoeabwé te Padué he ni watihenye. Kehe é ne telé, ke a pwaaden naa, ke a gele. Kehe icehi ana woéo, ke é céihi ne ko ati ni *patén de Moosé, me ati ni tii te lépwo péroféta. ");
INSERT INTO cam_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Be geme céihi, woéo me ni apulie ce, pie lé o bo mulie mwo na ati nina lé mele ne ha a wâé me a ta. ");
INSERT INTO cam_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Ke é mulang na é te pihane me te tice celi me e pipé ne kong a pwonimung, ne he pwahamii Padué me ni apulie.» ");
INSERT INTO cam_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«É ne alecehe ni jo na hiwon na tieéo mu Iérusaléma, ke é mwojuia mwobé, beme é pébé ni mwani bépicani te a bele tong, ke me é pwoâpwailo te Padué. ");
INSERT INTO cam_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Anaa kuti ana é mu ne kon, ne huâ iitihi, ke lé tooéo he é ko panebwénihi a *pwoiitihi ko a bwo wâé genye ne pele Padué. Te tice apulie bééng, ke time é uce cine ni apulie me lé pipwohauli. ");
INSERT INTO cam_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","«Kehe icehi ana lé mu lang ne ni béé Juif mu ha a province Asia. Ke hemepie é pwo aceli ta ha a tan naa, ke é mu ko ade na time lé uce mu éni jenaa, beme lé pipé ne kong? ");
INSERT INTO cam_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Mwo te wo lépwo apulie ce mwo, na lé pééo nge ânebuhe a *mwohuô, he ade aceli ta celi lé te alihi ne kong? ");
INSERT INTO cam_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ai he nimelé me lé tautiéo, ko ali pwooti li é pii ne ha awiemelé, pie: “É céihi pie, lé o mulie mwo ne ni amele”? Ke é mu ko anaa, na é ko mu éni jenaa ne ânebuhewé.» ");
INSERT INTO cam_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Ke mepwo é ne ko gupéno Félix, ke e te junihe téne ni pwooti ko *a bwo âcéi Padaame. Ke e picéi ngemwo a bwo tauti Paulo. Ke e pii te lépwo Juif pie: «O bo tauti cawi Paulo, hemepie e tuiebé wo Lisias, pa apihuô te ni coda.» ");
INSERT INTO cam_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ke e pii te pa céiu caa te coda pie me e wéi Paulo ne he karépu, ke me time e uce cieeng me pwohauli ten, ke me e te patupwo ne te ni béén me lé âbé caniêeng. Ke e engen wo Félix. ");
INSERT INTO cam_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Pwo ni tan he pwocehin, ke lu tuiebé wo Félix me Drusile, ê mwoden, ê toomwo Juif. Ke lu pwo me e âbé wo Paulo, ke lu tabemieng he e cihe ko a céihi ne ko Iésu Kériso. ");
INSERT INTO cam_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Kehe icehi ana me e cihe ko a mulie ha a *mwomwon ne he pwahamii Padaame, me a bwo pipwoiipikenye, me a tautinaado te Padué na e bo âbé, ke mwoti Félix, ke e pii te Paulo pie: «É jenaa ni, ke genye o mwo pacuwohi ali pitihi tenye. Ke wâé heme go mwo engen kojaéo, ke hemepie pwo ace benaamwon dong, ke é bo todeko mwo.» ");
INSERT INTO cam_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Be e te niimihi wo gupéno Félix pie, me e bo ne ten ce mwani wo Paulo. É mu ko anaa, na e pwo me lé te cuwo ko pébé céiieng Paulo, beme lu picihe. ");
INSERT INTO cam_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Caa âdé na alo jo, ke e taatéé gupéno Félix wo Porcius Festus. Kehe icehi ana wo Félix, ke e te pwo me e te mu he karépu wo Paulo, beme lé te piwâéeng wo lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","E tuie ne ha a province *Judé wo gupéno Festus, ke cié ni tan alecehen, ke e taa mu Césaré ne *Iérusaléma. ");
INSERT INTO cam_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ke lé pitéteiminaado ten ne ko Paulo wo lépwo caa te lépwo *apwoâpwailo, me ni apulie na piubwo jélé mu pele lépwo *Juif. ");
INSERT INTO cam_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Lé cuwokon me ileeng pie me e pwo me e âbé ne Iérusaléma wo Paulo. Be wo lépwoje, ke lé te pwo a céiu huô, beme lé bo taunueng ne pwo pwaaden. ");
INSERT INTO cam_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ke e hegi ne telé wo Festus pie: «Ûhu, be lé wéieng ne Césaré, ke woéo, ke time uce bwoliéo Iérusaléma ke é o caa te engemwo. ");
INSERT INTO cam_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ke wâé heme lé opé céing ne Césaré wo lépwo apihuô tewé. Ke mepie pwo ace naado celi ta celi e pwo wo pa apulie naa, ke lé bo pii nelang.» ");
INSERT INTO cam_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","E te ju mu pelelé he na 8 ai 10 ni tan wo Festus, ke e homwo Césaré. Ke é ha acaama hen, ke e taa he mwopitautinaado, ke e pihuôhi ne telé pie me lé pébé Paulo. ");
INSERT INTO cam_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Ke me e tehenebé wo Paulo, ke lé aujenieng wo lépwo Juif na lé opé mu Iérusaléma. Ke hiwon ni naado na lé pipé ne kon kon na te nihe ta. Kehe icehi ana time uce jan me lé *pajuujuhi. ");
INSERT INTO cam_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Ke e hegi wo Paulo me pipwopain, ke e pii pie: «Te tice aceli é pwotahi ne ko ni patén de lépwo Juif, ke é ne ko a *mwaiitihi, die ko pa daame ubwo César.» ");
INSERT INTO cam_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Nime Festus me lé piwâéeng wo lépwo Juif, ke e hegi ne te Paulo pie: «Nimem me go taa Iérusaléma, beme é bo tautiko nelang?» ");
INSERT INTO cam_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Ke e pii ten wo Paulo pie: «É cuwo ânebuhe a mwotautinaado te César, ke o bo te tautiéo nelang. Be go caa te temehi ehi pie, te tice aceli é pwo celi ta ne ko lépwo Juif. ");
INSERT INTO cam_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ke mepie é pwo aceli time uce mwomwon, celi jan me taunuéo kon, ke time uce piwâ jo hemepie taunuéo. Ke mepie nina lé pii ne kong, ke me ni gele, ke te tice pace apulie celi pwo mwomwon den me e pééo nge céiilé. Ûhu! Nimung me e tautiéo wo César!» ");
INSERT INTO cam_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Ke é ne alecehe a bwo picihe te Festus me lépwo apwopitihi, ke e pii te Paulo pie: «Mepie te nimem me e tautiko wo César, ke go bwo te ân!» ");
INSERT INTO cam_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","É he ni tan alecehen, ke lu tuie ne Césaré wo pa daame *Agripa me Bérénice, ê toomwo pwaadeniin, me lu â pwobwocu te Festus. ");
INSERT INTO cam_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Mwo te hiwon ni tan na lé mwo te mu hen, ke e piuti te pa daame wo Festus nina lé pwo te Paulo, ke e pii ten pie: «Pwo pa apulie na e neeng he karépu wo Félix. ");
INSERT INTO cam_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","É he é mu Iérusaléma, ke lé pitéteiminaado wo lépwo caa te lépwo apwoâpwailo, me lépwo apihuô te lépwo Juif, me ilehi pie me e pwocuhinaado. ");
INSERT INTO cam_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","«Ke é hegi ne telé pie: “Wogeme lépwo Roma, ke time mu uce wonaa ni huô teme. Be time geme mu uce pwocuhinaado te pa apulie, ânebuhe a bwo tautieng. Be wâé heme e mwo te picihe me lépwona lé pipé ne kon, beme e te pii ce pwooti bépipwopain.” ");
INSERT INTO cam_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ke é mulang na lé tai tuiebé pelong. Time é mwo uce ucéihi, ke é ha acaama, ke é mu he mwotautinaado, ke é ilehi pie me pébé pa apulie naa.» ");
INSERT INTO cam_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","«Lé tehenebé wo lépwo apipé ne kon. É ko niimihi pie, junihe ubwo a ta na e pwo. Kehe icehi ana lé pipé ne kon, ke te piticenaado ne kon. ");
INSERT INTO cam_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Be lé te pipééle ko nina te é ha a pwoiitihi telé, ne ko pace Iésu celi e mele, pana e pii wo Paulo pie e mulie cemwo. ");
INSERT INTO cam_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","«Ke time é uce temehi aceli me é pwo, ne ha a bwo picihe telé. Ke é tahimwo Paulo pie, nimen me e â Iérusaléma, me bo tautieng nelang ko ni naado naa. ");
INSERT INTO cam_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Kehe icehi ana e ilehi me e tautieng wo César. Ke é ne a mwomwon pie me wéieng dieli ha ace bwo pawieeng dong, nge céii César.» ");
INSERT INTO cam_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Ke e pii wo *Agripa te Festus pie: «Woéo mwo, ke nimung me é téne pa apulie naa.» Ke e hegi ne ten wo Festus pie: «Wâé, be é meé, ke go bo te téneeng.» ");
INSERT INTO cam_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","É ha acaama hen, ke lu tuie nge he mwopitautinaado wo Agripa me Bérénice, woélé me ni apihuô te ni coda me ni apulie na piubwo jélé ne ha a pwomwo ubwo. Ke lé te junihe pipaunulu ne ni apulie, pwohewii a bwopwonen delé. Ke e ne a mwomwon wo Festus pie me lé pébé Paulo. ");
INSERT INTO cam_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ke e pii wo Festus pie: «Padaame Agripa me tai wogewé ati na wogewé éni peleme, geé ali pa apulie ce. Be pa watihe picihe te ati ni Juif, ne Iérusaléma, ke éni, ke lé caa âbé tooéo ne kon. Ke lé tai pii tong ati pie, wâé heme taunueng. ");
INSERT INTO cam_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","«Ke hemepwo é ne kong, ke é tooli pie te tice aceli e pwo celi ta celi me jan me taunueng kon, kehe icehi ana te weeng mwo na e ilehi pie me e â too pa daame César. Ke é niimihi pie me é te patupwoeng ngen. ");
INSERT INTO cam_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","«Kehe icehi ana time é uce temehi aceli me é tii nge céii pa daame César ne kon, ke anaa a watihen me é pwo me e cuwo ânebuhewé ati. Te wogo cehi, go pa daame Agripa, na é pine ne kom. Be mepie geé tahimwoeng ati, ke