﻿USE sofia;
DROP TABLE IF EXISTS sofia.cak_vpl;
CREATE TABLE cak_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cak_vpl WRITE;
INSERT INTO cak_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chupan ri vuj re' tz'iban-vi can quibi' ri ojer tak rati't-rumama' ri Jesucristo. Rija' riy-rumam can ri rey David, y riy-rumam can ri Abraham. ");
INSERT INTO cak_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham jari' rutata' ri Isaac; ri Isaac jari' rutata' ri Jacob; ri Jacob xec'uje' eq'uiy ralc'ua'l, y jun chique ri ralc'ua'l xubinaj Judá. ");
INSERT INTO cak_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ri Judá xec'uje' ca'i' ralc'ua'l riq'uin ri ixok Tamar, y ri alabo ri' Fares y Zara quibi' xyo'ox. Ri Fares jari' rutata' ri Esrom; ri Esrom jari' rutata' ri Aram. ");
INSERT INTO cak_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri Aram jari' rutata' ri Aminadab; ri Aminadab jari' rutata' ri Naasón; ri Naasón jari' rutata' ri Salmón. ");
INSERT INTO cak_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri Salmón jari' rutata' ri Booz, y ri rute' ri Booz ja ri Rahab; ri Booz jari' rutata' ri Obed, y ri rute' ri Obed ja ri Rut; ri Obed jari' rutata' ri Isaí. ");
INSERT INTO cak_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri Isaí jari' rutata' ri David ri xoc rey. Ri rey David jari' rutata' ri Salomón ri xalex chuk'a' ri ixok Betsabé, ri rixayil can ri Urías. ");
INSERT INTO cak_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri Salomón jari' rutata' ri Roboam; ri Roboam jari' rutata' ri Abías; ri Abías jari' rutata' ri Asa. ");
INSERT INTO cak_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri Asa jari' rutata' ri Josafat; ri Josafat jari' rutata' ri Joram; ri Joram jari' rutata' ri Uzías. ");
INSERT INTO cak_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri Uzías jari' rutata' ri Jotam; ri Jotam jari' rutata' ri Acaz; ri Acaz jari' rutata' ri Ezequías. ");
INSERT INTO cak_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri Ezequías jari' rutata' ri Manasés; ri Manasés jari' rutata' ri Amón; ri Amón jari' rutata' ri Josías. ");
INSERT INTO cak_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ri Josías xec'uje' eq'uiy ralc'ua'l, y jun chique ri ralc'ua'l xubinaj Jeconías. Jari' tiempo tok ri israelitas xe'uc'uax pa roch'ulef Babilonia. ");
INSERT INTO cak_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tok ec'o chic quila' pa Babilonia, ri Jeconías xc'uje' jun ralc'ua'l ri xubinaj Salatiel; ri Salatiel jari' rutata' ri Zorobabel. ");
INSERT INTO cak_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri Zorobabel jari' rutata' ri Abiud; ri Abiud jari' rutata' ri Eliaquim; ri Eliaquim jari' rutata' ri Azor. ");
INSERT INTO cak_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri Azor jari' rutata' ri Sadoc; ri Sadoc jari' rutata' ri Aquim; ri Aquim jari' rutata' ri Eliud. ");
INSERT INTO cak_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri Eliud jari' rutata' ri Eleazar; ri Eleazar jari' rutata' ri Matán; ri Matán jari' rutata' ri Jacob. ");
INSERT INTO cak_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ri Jacob jari' rutata' ri José; y ri José jari' xoc rachijil ri María, ri achok chuk'a' xalex-vi ri Jesús. Y ri Jesús, jari' ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chuvech re roch'ulef xek'ax-e catorce solaj vinak ri nitiquer-pe riq'uin ri Abraham c'a riq'uin ri rey David. Catorce chic solaj xek'ax-e chuvech re roch'ulef ri nitiquer-pe riq'uin ri rey David c'a chupan ri tiempo tok ri israelitas xe'uc'uax pa roch'ulef Babilonia. Y catorce chic solaj xek'ax-e chuvech re roch'ulef ri nitiquer-pe riq'uin ri tiempo tok ri israelitas xe'uc'uax pa Babilonia c'a chupan ri tiempo tok xalex ri Jesucristo choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Tok xalex ri Jesucristo, quire' ri xbanataj: Ri María ri xoc rute', jun xten c'utun chic roma ri José. Pero tok man jani tiquic'uaj-qui' chiri', xna'ex chi ri María quiri' chic rubanon roma ruchuk'a' ri Lok'olaj Espíritu xka pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jac'a ri José ri ne'oc rachijil, jun achi choj ruc'aslen chuvech ri Dios, y xa nupokonaj nuya' chi q'uix ri María chiquivech ri vinak, romari' xunojij chi ekal neruya' rutzijol chi xa man nic'ule' ta chic riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Quiri' ri xunojij rija' pa ránima, pero pa ruvaran, ri José xutz'et jun ángel richin ri Ajaf, y ri ángel quire' xu'ij che: José, rat ri rat riy-rumam can ri rey David, man taxi'ij-avi' chi yac'ule' riq'uin ri María, roma ri ac'ual ri royo'en chi nalex chuk'a', can richin vi ri Lok'olaj Espíritu. ");
INSERT INTO cak_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri María xtalex ch'uti ral ala', y rat Jesús rubi' xtaya'. Roma ri ac'ual ri xtalex, jari' xquecolo ri rutinamit chupan ri quimac. ");
INSERT INTO cak_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel re' xbanataj richin quiri' nibanataj ri ruk'alajrisan can ri Ajaf chuvech ri jun profeta ri xtzijon ri ruch'abel ri Dios ojer can. Y quire' ri ru'in can: ");
INSERT INTO cak_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Titz'eta' na pe', c'o jun xten ri kitzij chi c'a ruyon na, ri xtipe alanic chirij, y xtalex jun ral ala'. Ri ac'ual ri xtalex xtubinaj Emanuel. Y Emanuel nu'ij tzij, Dios c'o kiq'uin. ");
INSERT INTO cak_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tok ri José xc'astaj, can xu'on na vi ri xbix che roma ri ángel richin ri Ajaf. Rija' xuq'uen ri María richin xoc rixayil. ");
INSERT INTO cak_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ri José man xc'uje' ta apu riq'uin ri María c'a xalex na ri na'ey ral. Y tok ri José xuya' rubi' ri ac'ual, Jesús rubi' xuya'. ");
INSERT INTO cak_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Alaxnak chic chiri' ri Jesús pa Belén pa departamento Judea pa ru-tiempo ri rey Herodes, tok xepe aj-nic'oy quij ch'umila' quire' achique lugar ntel-vi-pe ri k'ij, xe'eka ri pa tinamit Jerusalem, ");
INSERT INTO cak_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y quire' niquic'utula' chique ri aj chiri': ¿Achique c'a lugar c'o-vi ri qui-Rey ri israelitas ri c'a ja oc xalex? Roma roj c'a ja achique lugar ntel-vi-pe ri k'ij, chiri' katz'eton-vi-pe ri ruch'umil, y roj petenak richin nukaya' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tok ri rey Herodes xrac'axaj re', can man nril ta achique nunojij, y quiri' mismo conojel ri vinak pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Rija' tok erumolon conojel ri nima'k tak quik'ij sacerdotes israelitas y ri q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, nuc'utula' chique ri achique chi lugar nalex-vi ri Jun ri nitak-pe chucolic ri rutinamit ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ri achi'a' ri xerumol quire' xqui'ij che ri rey Herodes: Vave' pa departamento Judea nalex-vi, y ja ri pa Belén. Roma ri rutz'iban can ri jun profeta ojer, quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Rat Belén, ri ratc'o pa roch'ulef Judá, Mana-ta rat ri más co'ol ak'ij chiquicojol ri lugares c'o quik'ij chiri' pa Judá, Roma ja aviq'uin rat xtipe-vi ri Jun ri xtuc'uan bey, Y xqueruyuk'uj ri nutinamit Israel, nicha' ri Dios. Quiri' xqui'ij-apu che ri rey Herodes. ");
INSERT INTO cak_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Jari' tok ri rey Herodes ruyon xeroyoj ri aj-nic'oy quij ch'umila', y xuc'utuj utz-utz ruchojmil chique ri ajani tiempo quitz'eton-pe ri ch'umil. ");
INSERT INTO cak_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rija' xerutak c'a e pa Belén y xu'ij-e chique: Quixbin y tic'utuj utz-utz rutzijol ri ac'ual, y tok ivilon chic, tu'iya' can rutzijol chuve, richin quiri' ja jun yin nenya' ruk'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tok quic'axan chic ri xu'ij-e ri Herodes chique, rije' xebe. Jac'a ri ch'umil ri quitz'eton-pe, ruc'uan-e quibey, y c'a ja xpa'e' pa ruvi' ri lugar ri c'o-vi ri ac'ual. ");
INSERT INTO cak_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tok xquitz'et chi xpa'e' ri ch'umil, ri cánima can jani na xquicot. ");
INSERT INTO cak_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tok xe'oc-apu ri pa jay, xquitz'et ri ac'ual y ri María ri rute', jac'ari' xexuque-ka richin xquiya' ruk'ij ri ac'ual. Xequijakala' c'a ri quiyacabal y xquisipala' can oro, pon y mirra che. ");
INSERT INTO cak_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero pa cachic' xk'alajrises chiquivech chi can man chic quek'ax riq'uin ri rey Herodes richin nequiya' can rutzijol che. Romari', tok xetzolij-e pa quiroch'ulef, xa jun vi chic bey xebe-vi. ");
INSERT INTO cak_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tok ri aj-nic'oy quij ch'umila' xe'el yan e chiri', jari' tok jun ángel richin ri Ajaf xuc'ut-ri' chuvech ri José pa rachic', y quire' xu'ij che: Cacataj, tac'uaj-e ri ac'ual y ri rute' y quixenimaj c'a pa roch'ulef Egipto. Chiri' quixc'uje-vi, c'a ja tok xtinya' rutzijol chave, roma ri rey Herodes xturucanoj ri ac'ual vave' richin nrojo' nucamisaj, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jac'ari' xcataj ri José, y quiri' chak'a' xuc'uaj-e ri ac'ual y ri te'ej c'a pan Egipto. ");
INSERT INTO cak_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chiri' xec'uje-vi c'a (xcom, xquen) na ri rey Herodes, richin nibanataj ri ruch'abel ri Ajaf ri xel pa ruchi' ri profeta ojer can, tok xu'ij: Pan Egipto c'o-vi ri Nuc'ajol tok xinvoyoj. Quiri' ru'in can ri profeta ojer. ");
INSERT INTO cak_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Jac'a tok ri rey Herodes xuna'ej chi ri aj-nic'oy quij ch'umila' xa man xuquiya' ta chic rutzijol che, jani na xcataj royoval. Romari' ri ajani tiempo rac'axan can quiq'uin chi quitz'eton-pe ri ch'umil, ja riq'uin ri' xu'ij chi quecamises ri ch'utik alabo ri ec'o pa Belén y ri ec'o pa tak lugares ri ec'o-pe chunakaj ri Belén, conojel ri caca' quijuna' pa xulan. ");
INSERT INTO cak_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Riq'uin ri', xbanataj ri ru'in can ri profeta Jeremías, tok quire' xu'ij: ");
INSERT INTO cak_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pa tinamit Ramá xc'axataj nimalaj bis. Najin ok'ej. Y nic'axataj chi nijik'ik' ok'ej. Ri' ja ri Raquel yerok'ej ri ral. Rija' nis-ta man xrojo' ta xbochi'ix ri ránima, roma ri ral ri xecamises. Quiri' ri tz'iban can roma ri Jeremías. ");
INSERT INTO cak_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tok caminak chic ri rey Herodes, xuc'ut-ri' jun ángel richin ri Ajaf Dios chuvech ri José pa rachic' chiri' pan Egipto, ");
INSERT INTO cak_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","y xu'ij che: Cacataj, tac'uaj-e ri ac'ual y ri rute' y quixtzolij pan Israel. Roma vacami ecaminak chic ri xecanon rucamic ri ch'uti ac'ual, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xcataj c'a ri José, xuc'uaj-e ri ac'ual y ri te'ej, y xetzolij pan Israel. ");
INSERT INTO cak_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero roma xrac'axaj chi ja ri Arquelao ri ruc'ajol ri rey Herodes nibano gobernar pa departamento Judea, romari' ri José nuxi'ij-ri' chi ni'e chiri'. Pero pa jun rachic' xk'alajrises chuvech ri achique utz chi nu'on, y romari' xuc'uaj ri ac'ual y ri te'ej pa departamento Galilea. ");
INSERT INTO cak_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tok (xe'apon, xe'ebos) chiri', xec'uje' pa tinamit Nazaret, richin nibanataj ri tz'iban can coma ri profetas ojer, chi ri ac'ual can xti'ix na vi nazareno che. ");
INSERT INTO cak_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ja tiempo ri' tok ri Juan ri Bautista xutz'uc rutzijosic ruch'abel ri Dios pa chakijlaj tz'iran ulef chiri' pa departamento Judea. ");
INSERT INTO cak_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Rija' quire' nu'ij chique ri vinak: Tijala' ino'oj y tiya' can ri imac, roma nakaj chic c'o-vi chi c'o che'el yixoc ruvinak ri aj-chicaj gobierno, nicha' chique. ");
INSERT INTO cak_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Quiri' xu'on ri Juan ri Bautista, roma ja rija' ri k'alajrisan can roma ri profeta Isaías ojer, tok xu'ij: Pa chakijlaj tz'iran ulef c'o jun xtich'o riq'uin ruchuk'a' y xtubila': Tibana-apu rubanic ri bey ri xtik'ax-vi ri Ajaf, Utz-utz tichojmij-apu. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri Juan ri Bautista rusumal camello ocunak rutziak, nuxim rupan riq'uin jun tz'un, y ja ri ch'utik chicop ri ni'ix langostas chique y cab richin pa juyu' ocunak ruvay. ");
INSERT INTO cak_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ri aj pa tinamit Jerusalem, ri aj pa tak tinamit richin ri Judea, y ri ec'o pa tak tinamit chunakaj ri rakan-ya' Jordán, conojel re' nequimolo-qui' riq'uin, ");
INSERT INTO cak_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","can niquik'alajrisaj ri quimac, y ye'an-e bautizar roma rija' pa rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Tok ri Juan xutz'et chi eq'uiy chique ri achi'a' fariseos y saduceos nequimolo-qui' riq'uin richin yeru'on-e bautizar, rija' xu'ij chique: Rix xa rix achel itzel tak cumatz. ¿Achique xyo'on rutzijol chive chi yixenimaj chuvech ri castigo ri xtutak-pe ri Dios más chikavech apu? ");
INSERT INTO cak_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rix nic'atzin nik'alajin iviq'uin chi kitzij ijalon ino'oj y iyo'on can ri mac. ");
INSERT INTO cak_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man tinojij-ka pan ivánima chi roma rix riy-rumam can ri Abraham, romari' xquixcolotaj, man quiri' ta. Roma yin nin-ij chi xa ta ri Dios nrojo', rija' yeru'on riy-rumam ri Abraham chique ri abaj ri ye'itz'et vave'. ");
INSERT INTO cak_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Y rix xa rix achel ri che' ri yo'on chic apu icaj chirij ri quixe'; xa achique na che', xe xa man nuya' ta utzulaj ruvech, nichoy y nic'ak pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Can kitzij na vi chi yin pa ya' yixin-en-vi bautizar, richin nik'alajin chi kitzij ijalon ino'oj y kitzij iyo'on can ri mac. Pero c'o Jun xtuka chuvij ri man achel ta oc yin. Rija' can c'o ruk'ij y romari' nis-ta chuc'uaxic ri ruxajab chutzalanen, man nuc'ul ta chi ja yin yibano. Y rija' xquixru'on bautizar riq'uin ri Lok'olaj Espíritu y riq'uin k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Rija' rubanon chic rubanic richin yerelesaj-e ri yeniman ri Dios chiquicojol ri man yeniman ta, achel tok jun achi ruc'uan chic jun che' pa ruk'a' richin nuc'ak pa cak'ik' ri trigo ch'eyon chic. Rija' xtuyec ri trigo, jac'a ri (ruxeq'uelal, rupuxq'uil) xtuporoj chupan ri k'ak' ri man jun bey xtichup. ");
INSERT INTO cak_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Chupan tak ri k'ij ri', ri Jesús xel-pe pa departamento Galilea richin ni'an bautizar roma ri Juan ri Bautista pa rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Jac'a ri Juan man nrojo' ta nu'on bautizar ri Jesús, y quire' xu'ij che: Ja yin nic'atzin chi rat yina'an bautizar, ¿y vacami ja rat ri xape viq'uin richin yatin-en-e bautizar? xcha' ri Juan. ");
INSERT INTO cak_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jac'a ri Jesús quire' xu'ij che: Roj nic'atzin chi nika'an ronojel ri nika chuvech ri Dios. Romari' vacami nic'atzin chi rat yina'an bautizar, xcha' ri Jesús. C'ajari' tok ri Juan xniman. ");
INSERT INTO cak_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tok ri Jesús banon chic bautizar, xel-pe pa ya'. Jari' tok xjakataj ri rocaj chuvech y xutz'et ri Lok'olaj Espíritu richin ri Dios chi xulan-pe achel jun paloma pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y c'o c'a jun kulaj petenak chicaj ri quire' xu'ij-pe: Jare' ri Nuc'ajol; yin can ninjo' y niquicot vánima riq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jac'ari' tok ri Jesús xuc'uax pa chakijlaj tz'iran ulef roma ri Lok'olaj Espíritu richin chi ri itzel nutij ruk'ij chi nutakchi'ij pa mac. ");
INSERT INTO cak_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús cuarenta k'ij y cuarenta ak'a' xu'on coch'on vayijal, romari' xpe ruvayijal. ");
INSERT INTO cak_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xpe c'a ri itzel ri nrojo' nutakchi'ij pa mac ri Jesús, xu'ij che: Si kitzij chi rat Ruc'ajol ri Dios, ta'ij chique ri abaj re' chi que'oc pan. ");
INSERT INTO cak_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jac'a ri Jesús xu'ij che ri itzel: Chupan ri tz'iban can quire' nu'ij: Ri vinak man xe ta pan nic'atzin che ri quic'aslen, ja jun ronojel ri ch'abel ri ntel pa ruchi' ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jac'ari' tok ri itzel xuc'uaj ri Jesús pa lok'olaj tinamit Jerusalem, y ja ri más naj e pa ruvi' racho ri Dios xujotoba-vi-e. ");
INSERT INTO cak_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y xu'ij che: Si kitzij chi rat Ruc'ajol ri Dios, tatorij-ka-avi' vave', roma chupan ri tz'iban can nu'ij: Ri Dios xtu'ij chique ri ru-ángeles chi xcatquichajij; y, Xcatquili'ej pa quik'a', Richin man (xtapak'ij, xtacopij) ta avakan chuvech abaj, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jac'a ri Jesús xu'ij che ri itzel: Chupan ri tz'iban can, juc'an chic nu'ij: Man tatij ak'ij chirij ri Avajaf Dios richin nu'on ri nanojij rat, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jac'ari' ri itzel xuc'uaj chic ri Jesús chuvech jun juyu' naj jotol chicaj, y ronojel ri nimalaj tak cuchuk'a' ri aj-roch'ulef tak gobierno xuc'ut chuvech y ri quibeyomal. ");
INSERT INTO cak_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y xu'ij che ri Jesús: Ronojel ri xinc'ut chavech xtinya' chave, si yaxuque' chinuvech richin naya' nuk'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jac'a ri Jesús xu'ij che: Catel quila' rat Satanás. Roma chupan ri tz'iban can nu'ij: Ja chuvech ri Avajaf Dios caxuque-vi, y xaxe rija' taya' ruk'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","C'ajari' tok ri itzel xuya' can, y xe'uka ángeles riq'uin ri Jesús richin xquilij. ");
INSERT INTO cak_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tok ri Jesús xrac'axaj chi ri Juan ri Bautista yo'on pa cárcel, rija' xtzolij pa departamento Galilea. ");
INSERT INTO cak_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero man xc'uje' ta chic pa tinamit Nazaret, xa pa Capernaum xc'uje-vi, jun tinamit c'o chuchi' jun lago chiri' mismo pa Galilea. Ri Capernaum re' pa qui-lugar ri quiy-quimam can ri Zabulón y ri Neftalí c'o-vi. ");
INSERT INTO cak_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Chiri' xc'uje-vi ri Jesús richin nibanataj ri ru'in can ri profeta Isaías, tok quire' xu'ij: ");
INSERT INTO cak_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Chila' pa Galilea ri achique lugar juba' ma quiyon chic man israelitas ta ec'o, Ri lugar ri xyo'ox chique ri quiy-quimam can ri Zabulón y ri Neftalí ojer, Ri c'o-apu juc'an che ri rakan-ya' Jordán, ri nik'ax-vi ri bey ri ni'e c'a chuchi' mar, Pa quivi' ri aj chiri' quire' nin-ij: ");
INSERT INTO cak_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri tinamit ri xa pa k'eku'n c'o-vi ri quic'aslen, vacami niquitz'et ri Nimalaj Sakil. Conojel ri xa pa rumujal ri camic ec'o-vi, Vacami c'o chic quiq'uin ri niyo'on sakil pa quic'aslen. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ja k'ij ri' tok ri Jesús xutz'uc rutzijosic ruch'abel ri Dios, y quire' nu'ij chique ri ye'ac'axan: Tijala' ino'oj y tiya' can ri imac, roma nakaj chic c'o-vi chi c'o che'el yixoc ruvinak ri aj-chicaj gobierno, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","C'o jun k'ij ri Jesús nibin chuchi' ri lago Galilea, jari' xerutz'et ca'i' achi'a' quichak'-quinimal qui' chi yequic'akala-ka ya'l pa ya' richin yequelesaj quer, roma jari' quisamaj. Jun chique rije' rubinan Simón, y ni'ix Pedro che, y ri jun chic rubinan Andrés. ");
INSERT INTO cak_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y ri Jesús quire' xu'ij chique: Quixampe, quinitzekle'ej y xtinc'ut chivech achique ruchojmil ni'en richin ye'icanoj tzekle'ey vichin. ");
INSERT INTO cak_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jac'ari' rije' xequiyala' can ri ya'l y xquitzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tok xebin juba' más, ri Jesús xerutz'et chic ca'i' achi'a' mismo quichak'-quinimal qui', jun rubinan Jacobo y ri jun chic Juan. Rije' eruc'ajol jun achi rubinan Zebedeo y junan yesamaj riq'uin ri quitata' pa canoa, yequic'ojoj ri ya'l ri yequicusaj richin yequelesaj quer pa ya'. Ri Jesús xeroyoj richin niquitzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Jac'ari' rije' xquiya' can ri canoa y ri quitata' y xquitzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús ronojel tinamit richin ri Galilea xbin-vi, yerutijoj ri israelitas riq'uin ri ruch'abel ri Dios pa tak qui-sinagoga; nutzijoj ri utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc pa ruk'a' ri Dios richin yeru'on gobernar, y nu'on chi yec'achoj riq'uin jalajoj tak yabil y k'axomal. ");
INSERT INTO cak_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Pa ronojel tinamit richin ri roch'ulef Siria xbe-vi rutzijol ri Jesús, y ri yeyavej pa ruk'a' jalajoj ruvech yabil xe'uc'uax-apu chuvech. Ec'o nik'axo qui-cuerpo. Ec'o ocunak itzel tak espíritu quiq'uin. Ec'o (ch'uja', moxa') y ec'o caminak quik'a-cakan. Conojel re' xu'on chique chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Man juba' ta oc xetzekle'en richin ri Jesús; ec'o epetenak pa tak tinamit richin ri Galilea, pa tak tinamit richin ri Decápolis, pa tak tinamit richin ri Judea, pa Jerusalem, y ec'o epetenak juc'an che ri rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Tok ri Jesús xutz'et chi ri vinak eq'uiy, xjote-e juba' chuvech ri juyu', xtz'uye' c'a ka, y ri yetzekle'en richin xquimol-apu-qui' chirij. ");
INSERT INTO cak_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Rija' xch'o c'a chique richin yerutijoj, y xu'ij: ");
INSERT INTO cak_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Utzulaj tzij rubanon ri Dios chique ri niquina' chi nic'atzin ruchuk'a' ri Dios pa cánima, roma eruvinak ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Utzulaj tzij rubanon ri Dios chique ri ntok' cánima, roma rije' xtibochi'ix ri cánima. ");
INSERT INTO cak_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Utzulaj tzij rubanon ri Dios chique ri (ch'uch'uj, me'l oc) cánima, roma xtoc quichin ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Utzulaj tzij rubanon ri Dios chique ri nivayijan cánima chirij ri chojmilaj c'aslen, roma rije' xtinojses cánima riq'uin ri niquirayij. ");
INSERT INTO cak_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Utzulaj tzij rubanon ri Dios chique ri yepokonan, roma ja jun rije' xtipokonex quivech. ");
INSERT INTO cak_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Utzulaj tzij rubanon ri Dios chique ri ch'ajch'oj cánima, roma rije' xtequitz'eta' ruvech rija'. ");
INSERT INTO cak_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Utzulaj tzij rubanon ri Dios chique ri yekasan ruvi' oyoval, roma rije' xti'ix chique chi eralc'ua'l ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Utzulaj tzij rubanon ri Dios chique ri ni'an pokon chique roma quic'uan jun chojmilaj c'aslen, roma can erichin vi ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Y rix utzulaj tzij nu'on ri Dios chive tok voma yin yixyo'ox chi q'uix, ni'an pokon chive, y ni'ix ronojel itzel tak tzij chivij, y xa tz'ucun tak tzij. ");
INSERT INTO cak_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Quixquicot y titze'en ivech, roma chila' chicaj c'o jun nimalaj rajil-ruq'uexel xtiyo'ox chive. Quiri' nin-ij chive, roma ri profetas ojer can, quiri' mismo ri pokon x-an-e chique. ");
INSERT INTO cak_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ri ic'aslen rix nic'atzin chi ratz'amil quic'aslen ri vinak choch'ulef. Si ri atz'an re' niq'uis-e ri ratz'amil, ¿achique chic xtiyo'ox riq'uin richin nitzolij-pe ri ratz'amil? Man jun chic nic'atzin-vi; xa nitorix-e, y ri vinak xa yek'ax pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ri ic'aslen rix nic'atzin richin sakil pa quic'aslen ri vinak choch'ulef. Jun tinamit c'o pa ruvi' juyu', manak che'el man ta k'alaj. Quiri' mismo ri ic'aslen rix. ");
INSERT INTO cak_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tok nitzij jun candil, man chuxe' ta cajón niyo'ox-vi, xa niyo'ox pa (ruc'ojle'el, ru-lugar) richin nu'on sakil pa quivi' conojel ri ec'o pa jay. ");
INSERT INTO cak_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quiri' ta c'a nik'alajin ri ic'aslen rix chiquivech ri vinak; can ta achel jun sakil, richin nik'alajin chiquivech ri utz ye'ibanala', y riq'uin ri' rije' xtiquiya' ruk'ij ri Itata' ri c'o chicaj. ");
INSERT INTO cak_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man ti'ij rix chi yin xipe richin man jun rakale'n nunbana' che ri nu'ij ri ley ri xyo'ox che ri Moisés, nis-ta che ri tz'iban can coma ri profetas ojer. Yin man richin ta ri' xipe; yin xipe richin nik'alajin riq'uin ri nuc'aslen ronojel ri nu'ij chupan ri ley. ");
INSERT INTO cak_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yin kitzij nin-ij chive chi na'ey chi niq'uis ri caj y ri roch'ulef, man jun ch'uti rutza'n letra che ri tz'iban can chupan ri ley ri xyo'ox che ri Moisés ri man ta xtibanataj. Can nibanataj na vi ronojel. ");
INSERT INTO cak_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Roma c'a ri', xa achique na vinak ri man jun rakale'n nu'on che jun chique ri mandamientos re', masque ja ri mandamiento ri más manak oc rakale'n nik'alajin, y nuc'ut chiquivech ch'aka' chic chi ri mandamiento manak rakale'n; ri quiri' nibano, man jun ruk'ij xtic'uje' chiquicojol ri erichin ri aj-chicaj gobierno. Jac'a ri nibano ronojel ri nu'ij chupan ri mandamientos re', y quiri' mismo nuc'ut chiquivech ch'aka' chic, rija' can xtic'uje' ruk'ij chiquicojol ri erichin ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ri yixtajin rix pan ic'aslen, nic'atzin chi más choj que chuvech ri yetajin ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' fariseos. Roma si man quiri' ta xti'en, man xquixoc ta chiquicojol ri erichin ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Rix ivac'axan chi ri kavinak ojer can, quire' xbix chique: Man cacamisan. Y xa achique na ri nicamisan, can xtiyo'ox na vi castigo pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Jac'a yin nin-ij, chi xa achique na ri nipe royoval che chic jun, utz chi nik'at castigo pa ruvi'. Y ri ni'in nacanic che chic jun, utz chi nuc'uax chiquivech ri achi'a' junan niqui'en gobernar richin ni'an castigar. Y jac'a ri ni'in manak ano'oj che jun, ruyon nunim-ri' chupan ri k'ak' ri jani na nic'at. ");
INSERT INTO cak_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Romari', si ratc'o chic apu chuvech ri altar richin c'o naya' chuvech ri Dios, y jari' nuka pan avi' chi c'o jun c'o ruyacon pa ránima chavij, ");
INSERT INTO cak_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taya' can chiri' chuvech ri altar ri achique naya' chuvech ri Dios, cabin, y tachojmirisaj ri achique ocunak chi'icojol riq'uin ri jun. C'ajari' catzolij y taya' che ri Dios ri najo' naya' che. ");
INSERT INTO cak_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Tatija' ak'ij tachojmirisaj-avi' riq'uin ri sujunel chavij, utz ri c'a ja rix benak pa bey richin yixec'ojox chuvech juez. Roma si man quiri' ta xta'an, ri sujunel chavij xcarujach pa ruk'a' ri nic'ojon ivichin, y riq'uin juba' ri nic'ojon ivichin xcarujach-e pa ruk'a' ri chajiy cárcel, y xcatetz'apis can. ");
INSERT INTO cak_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kitzij nin-ij chave chi rat man xcatel ta pe ri pa cárcel, c'a ja tok atojon chic can ri ruq'uisbel centavo che ri ajani xk'at chavij. ");
INSERT INTO cak_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Rix ivac'axan chi quire' bin can ojer: Man tac'amala-ka-avi' riq'uin jun ri mana-ta achok riq'uin rat c'ulan-vi. ");
INSERT INTO cak_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Jac'a yin nin-ij: Si jun achi nutz'et-apu jun ixok richin nurayij ruvech, ri quiri' nibano, xa xu'on yan mac pa ránima riq'uin ri ixok. ");
INSERT INTO cak_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Roma c'a ri', si ri runak'-avech derecha nibano chave chi naxutuj can ri Dios, tavelesaj-e y tatorij-e. Roma, más utz chave chi jun chique rutz'akat ri a-cuerpo nasetz can, y mani chi ronojel ri a-cuerpo nic'ak pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Y si ja ri ak'a' derecha nibano chave chi naxutuj can ri Dios, tachoyo-e y tatorij-e. Roma más utz chave chi jun chique rutz'akat ri a-cuerpo nasetz can, y mani chi ronojel ri a-cuerpo nic'ak pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jun chic ri xbix ojer can, ja chi ri achi ri nrojo' nuya' can ri rixayil, tujacha' jun vuj che ri achok chupan nu'ij-vi chi nuya' can. ");
INSERT INTO cak_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Jac'a yin nin-ij chive: Ri achi ri nuya' can ri rixayil, y si ri ixok xa manak mac rubanon riq'uin chic jun achi; ja mismo ri rachijil nibano chi nika pa mac ri ixok tok ni'e chic riq'uin jun achi. Ja jun ri achi ri nic'amo ri ixok yo'on can, nika pa mac. ");
INSERT INTO cak_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jun chic ri ivac'axan, ja chi xbix chique ri kavinak ojer can chi man tiquitzolij-qui' chiquij riq'uin ri qui'in chi niqui'en, xa ronojel ri can chuvech Dios qui'in-vi chi niqui'en, tiquibana' c'a. ");
INSERT INTO cak_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Jac'a yin nin-ij chive: Man jun bey ti'en jurar. Man tic'uxlaj ri caj richin ni'en jurar, roma ja chiri' c'o-vi rutz'uyubal ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Man tic'uxlaj ri roch'ulef, roma chiri' nuya-vi rakan ri Dios. Man tic'uxlaj ri tinamit Jerusalem richin ni'en jurar, roma ri tinamit ri' richin ri Nimalaj Rey. ");
INSERT INTO cak_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Man tic'uxlaj ri (ijolon, ivi') richin ni'en jurar, roma rix man yixtiquer ta nijal ru-color ri rusumal tak ivi'. Man yixtiquer ta ni'en xak che ri sak, nis-ta sak che ri xak. ");
INSERT INTO cak_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Romari' xa achique na ri ni'ij, si ja', ja' quixcha'. Si manak, manak quixcha'. Roma si xa niya' ruvi' ri itzij richin yixnimex, xa riq'uin ri itzel petenak-vi. ");
INSERT INTO cak_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Rix ivac'axan ri bin can ojer, chi xa achique na ri niq'uiso ruk'ij runak'-ruvech jun chic vinak, quiri' mismo ti'an che ri xbano. Y ri nik'ajo-e jun eyaj, can quiri' mismo ti'an che ri xbano. ");
INSERT INTO cak_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Jac'a yin nin-ij chive: Man jun bey ti'en ruq'uexel che ri nibano man utz ta chive. Xa achique na ri nuya' jutz'aj k'a' chi'ak'o'tz derecha, taya' chic apu ri jun ak'o'tz chuvech. ");
INSERT INTO cak_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Si c'o jun nrojo' yarusujuj richin nrojo' numaj-e jun atziak ri manak más rajil, man tapokonaj naya-e jun ri más c'o rajil che. ");
INSERT INTO cak_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Xa achique na ri ni'in chave chi tac'uaj jun eka'n c'a pa jun kilómetro, rat tac'uaj chi ca'i' kilómetro. ");
INSERT INTO cak_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ri c'o nic'utun chave, man taq'ueq'uej chi c'o naya-e che, y ri c'o nrojo' nukaj-e chave, man taq'ueq'uej naya-e che. ");
INSERT INTO cak_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Rix ivac'axan ri bin can ojer, chi que'ajo' conojel, jac'a ri itzel yarutz'et, itzel tatz'eta'. ");
INSERT INTO cak_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Jac'a yin nin-ij chive: Que'ijo' ri itzel yixquitz'et, y riq'uin utzulaj tak tzij titzolij ruvech quitzij ri yeyok'on ivichin. Tibana' utz quiq'uin ri man utz ta quino'oj iviq'uin, y tibana' orar pa quivi' ri yebano pokon chive y yixquiyok'. ");
INSERT INTO cak_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Richin quiri' nik'alajin chi rix ralc'ua'l ri Itata' ri c'o chicaj. Roma rija' nu'on chi ntel-pe ri k'ij pa quivi' ri utz quino'oj y pa quivi' ri man utz ta, y nu'on chi nika ri job pa quivi' ri choj quic'aslen y pa quivi' ri man choj ta. ");
INSERT INTO cak_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Roma si xaxe ri yixcajo' rix ri ye'ijo', ¿achique rajil-ruq'uexel xtiyo'ox chive? Man jun. Roma hasta ri vinak ec'uluy impuestos, quiri' mismo niqui'en. ");
INSERT INTO cak_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y si xaxe quiq'uin ri iveteman quivech nibanala-vi saludar ivi', xa junan yixtajin quiq'uin ri man quiniman ta ri Dios, ri quiyon chiquivech niquibanala-ka saludar qui'. ");
INSERT INTO cak_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rix c'a, tz'akat tibana' che ri ic'aslen, achel ri Itata' chicaj tz'akat riq'uin ronojel. ");
INSERT INTO cak_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tok pa rubi' ri Dios rix nijo' ni'en jun favor, man tivelesaj rutzijol xaxe richin yixna'ex. Roma si quiri' ni'en, man jun rajil-ruq'uexel xtiyo'ox chive roma ri Itata' ri c'o chicaj. ");
INSERT INTO cak_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tok rat naya' limosna, man tavelesaj rutzijol achel niqui'en ri vinak ri xa ca'i' rupalaj ri yetajin riq'uin. Rije' tok niquiya' limosna ri pa tak sinagogas, y ri pa tak bey, niqui'en chi nik'ojomex trompeta chiquivech, roma nicajo' chi niyo'ox quik'ij coma ri yetz'eto quichin. Kitzij nin-ij chive chi riq'uin ri niyo'ox quik'ij coma ri vinak, xaxe oc ri' ri rajil-ruq'uexel niquic'ul-e. ");
INSERT INTO cak_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Jac'a rat tok naya' limosna, man jun achok che tatzijoj-vi, ");
INSERT INTO cak_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","richin quiri' nis-ta jun chic jun teteman chi rat naya' limosna. Si quiri' na'an, ri Atata' ri k'alaj chuvech ronojel ri man niquitz'et ta ri vinak, xtuya' chave jun utzulaj rajil-ruq'uexel ri chiquivech conojel xtik'alajin-vi. ");
INSERT INTO cak_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tok rat na'an orar, man ta'an achel niqui'en ri vinak ri xa ca'i' rupalaj ri yetajin riq'uin. Roma rije' can nika chiquivech niqui'en orar pa tak esquinas ri achique lugar niquimol-vi-qui' ri vinak, y ri pa tak sinagogas, roma nicajo' chi quetz'et. Kitzij nin-ij chive, chi riq'uin ri niyo'ox quik'ij coma ri vinak, xaxe oc ri' ri rajil-ruq'uexel niquic'ul-e. ");
INSERT INTO cak_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jac'a rat tok na'an orar, xa catoc pan avacho y tatz'apij ruchi' ri jay y jari' cach'o riq'uin ri Atata' ri man jun nitiquer nitz'eto richin. Si quiri' na'an, ri Atata' ri k'alaj chuvech ri man niquitz'et ta ri vinak, xtuya' chave jun utzulaj rajil-ruq'uexel ri chiquivech conojel xtik'alajin-vi. ");
INSERT INTO cak_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tok rix ni'en orar, man xaxe quixvolol achel niqui'en ri man queteman ta ruvech ri Dios. Roma rije' niquinojij chi riq'uin niquicamuluj rubixic ri jalajoj ch'abel ri yequibila', romari' ye'ac'axex. ");
INSERT INTO cak_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Romari' rix tok ni'en orar, man ti'en achel niqui'en rije'. Roma ri Itata' rix can reteman chic ri achique nic'atzin chive, tok man jani tic'utuj che. ");
INSERT INTO cak_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Roma c'a ri', tok rix ni'en orar, quire' ti'ij: Katata' Dios ri ratc'o chicaj, Xtinimirises ta c'a ri lok'olaj abi'. ");
INSERT INTO cak_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Can ta nic'uje' yan ruchuk'a' ri a-gobierno pa quivi' conojel, Y achel yanimex ri chicaj, can ta quiri' mismo choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ri kavay ri nic'atzin k'ij-k'ij, ja jun ri vacami taya' chike. ");
INSERT INTO cak_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y tabana' perdonar ri kamac, achel roj kabanon perdonar ri quibanon mac chike. ");
INSERT INTO cak_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Man kojaya' richin chi nicanox chikij chi nkuka pa mac, xa kojacolo' chuvech ri itzel. Quiri' ri nikac'utuj chave, roma ja rat yabano gobernar ronojel, c'o avuchuk'a', y c'o ak'ij richin jumul. Amén. ");
INSERT INTO cak_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Si rix ye'iben perdonar ri c'o man utz ta niqui'en chive, ri aj-chicaj Itata' xquixru'on perdonar. ");
INSERT INTO cak_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero si rix man ni'en ta perdonar ri yebano man utz ta chive, (chuka', ka) ri Itata' man xquixru'on ta perdonar riq'uin ri man utz ta ri ni'en. ");
INSERT INTO cak_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tok rix ni'en coch'on vayijal, man ti'en achel niqui'en ri vinak ri xa ca'i' rupalaj ri yetajin riq'uin. Rije' bis-bis quivech niqui'en roma nicajo' chi quena'ex chi niqui'en coch'on vayijal chuvech ri Dios, pero kitzij nin-ij chive chi riq'uin ri yena'ex, xaxe oc ri' ri rajil-ruq'uexel niquic'ul-e. ");
INSERT INTO cak_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jac'a rat tok na'an coch'on vayijal, jabel tabana' abanic, taya' juba' ak'on pan (ajolon, avi') y jabel tach'aja' avech. ");
INSERT INTO cak_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Richin quiri', man cak'alajin chiquivech ri vinak chi na'an coch'on vayijal chuvech ri Dios. Can ta xe ri Atata' ri man jun nitiquer nitz'eto richin ri etemayon. Y rija' ri k'alaj chuvech ri man niquitz'et ta ri vinak, xtuya' jun utzulaj rajil-ruq'uexel chave, ri chiquivech conojel xtik'alajin-vi. ");
INSERT INTO cak_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man ti'e ivánima chuyaquic beyomal choch'ulef, roma xa nichicopir, nipusir y ec'o elek'oma' yejok'o ruchi' tak jay richin ye'elak'. ");
INSERT INTO cak_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Más utz ti'e ivánima chuyaquic beyomal chila' chicaj, ri achique lugar man jun jut nichicopirisan, man nipusir ta ri beyomal, ni man jun elek'on nijok'o ruchi' jay richin nelak'. ");
INSERT INTO cak_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Quiri' nin-ij chive roma xa achique na chi beyomal yixtajin chuyaquic, jari' nic'utu achok pa ruvi' benak-vi ri ivánima. ");
INSERT INTO cak_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri runak'-avech yec'atzin chave achel nic'atzin ri candil. Roma c'a ri', si ri avech ye'acusaj richin ri utz, ronojel ri a-cuerpo c'o pa sakil. ");
INSERT INTO cak_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero si ri avech man ye'acusaj ta richin ri utz, ronojel ri a-cuerpo c'o pa k'eku'n. Romari', si ri sakil ri ruyo'on ri Dios pan avánima xa xtoc jun k'eku'n, rat xcac'uje' pa jun nimalaj k'eku'n. ");
INSERT INTO cak_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man jun samajinel nitiquer nisamaj quiq'uin eca'i' rajaf. O itzel nutz'et can jun chique ri rajaf, y nrojo' ri jun chic, o nunimaj rutzij ri jun y nuxutuj can ri jun chic. Romari' rix, manak che'el ni'en ri nika chuvech ri Dios, tok xa benak ivánima pa ruvi' beyomal richin ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Roma c'a ri', yin nin-ij chive: Man tich'ujirisaj-ivi' chunojixic ri achique nic'atzin chive k'ij-k'ij, ri achique lugar xtivil-vi ri achique nitij y nikum; ni man tinojij achique lugar xtiq'uen-vi itziak richin nicusaj. Roma man xe ta ri achique nitij nic'atzin che ri ic'aslen, y man xe ta ri tziek nic'atzin che ri i-cuerpo. ");
INSERT INTO cak_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Que'itz'eta' c'a ri ch'utik chicop ri yeropop yebe chicaj, manak tico'n niqui'en, manak cosecha niquelesaj, nis-ta manak quic'ujay richin yeyacon-vi. Pero ri aj-chicaj Itata' yerutzuk. Y rix más c'o ivakale'n que chiquivech ri ch'utik chicop ri'. ");
INSERT INTO cak_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Y man jun chive rix ri masque xtutij ruk'ij chunojixic, ri can ta xtitiquer xtunimirisaj chic juba' rupalen. ");
INSERT INTO cak_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Y rix, ¿achique roma nich'ujirisaj-ivi' chunojixic ri itziak? Tivelesaj na pe ejemplo chirij quiq'uiyilen ri cotz'i'j lirio ri ec'o pa tak juyu'. Rije' man yesamaj ta, ni man yequemon ta richin yequibanala-ka quitziak. ");
INSERT INTO cak_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero yin nin-ij chive chi nis-ta ri ojer rey Salomón, masque jun nimalaj beyon, pero man xucusaj ta jun tziek ri can ta más jabel que chuvech rucotz'ijal jun lirio. ");
INSERT INTO cak_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ri Dios nu'on chique ri (k'ayis, k'os) pa tak juyu' chi jabel oc yetzu'un roma ri quicotz'ijal, y xa cha'anin yeporox pa k'ak'. Y si ri Dios jabel yeruvik ri cotz'i'j, más na quiri' xtu'on iviq'uin rix. Xa ja rix ri man can ta cukul ic'u'x riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Roma c'a ri', man tich'ujirisaj-ivi' y man quire' xti'ij: ¿Achique c'a xtikatij? ¿Achique c'a xtikakum? y ¿achique c'a lugar xtikaq'uen-vi katziak? ");
INSERT INTO cak_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Roma ri man quiniman ta ri Dios, yexule-yejote' chunojixic achique lugar niquiq'uen-vi ri achique nic'atzin chique. Jac'a ri aj-chicaj Itata' reteman chi ronojel re' nic'atzin chive. ");
INSERT INTO cak_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Roma c'a ri', tijacha-ivi' pa ruk'a' ri Dios richin yixru'on gobernar, y ticanoj ri chojmilaj c'aslen ri nrojo' rija'. Y ronojel ri nic'atzin, rija' xtuya-pe chive. ");
INSERT INTO cak_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Roma c'a ri', man tich'ujirisaj-ivi' chunojixic rij ri chua'k-cabij, roma ronojel k'ij can c'o-vi c'ayef nuq'uen-pe, y man nic'atzin ta ninojij yan ronojel richin man tumol-pe-ri' chivij. ");
INSERT INTO cak_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man tinic'oj rij quic'aslen ri vinak, richin quiri' man xtinic'ox ta rij ri ic'aslen rix. ");
INSERT INTO cak_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Roma ja achel runic'oxic rij quic'aslen ni'en rix, quiri' runic'oxic xti'an rij ri ic'aslen rix, y ja achel retexic quic'aslen ni'en rix, quiri' retexic xti'an ri ic'aslen rix. ");
INSERT INTO cak_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Y rat, ¿achique roma ja ri ch'uti q'uin ocunak pa ruvech jun chic ri natz'et y man nana' ta ka ri che' ocunak pan avech? ");
INSERT INTO cak_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Y, ¿achique ak'a' rat richin quire' na'ij che ri jun chic: Taya' lugar chuve chi ninvelesaj ri ch'uti q'uin ocunak pan avech, yacha' che, y xa jun che' ocunak pan avech? ");
INSERT INTO cak_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Rat xa ca'i' rupalaj ri yatajin riq'uin. Na'ey tavelesaj ri che' ocunak pan avech, y quiri' xcatzu'un utz, richin yatiquer navelesaj ri q'uin pa ruvech ri jun chic. ");
INSERT INTO cak_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ronojel ri can lok'olaj vi, man que'iya' chiquivech vinak ri e'achel tz'i', ni man tiya' ri can c'o rakale'n chiquivech ri e'achel ak. Roma ri chicop re', xa niquixak' che akan ri niyo'ox chiquivech, y c'o che'el chi yecataj chirij ri niyo'on chique y niquixil chi eyaj. ");
INSERT INTO cak_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tic'utuj c'a ri nic'atzin y xtiyo'ox-pe chive; ticanoj c'a ri achique nijo' y xtivil. Quixch'o-apu chuchi' ri jay y can xtijak-vi-pe chivech. ");
INSERT INTO cak_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Roma xa achique na jun ri nic'utun, can nuc'ul-vi; ri nicanon, nril; y ri nich'o-apu chuchi' jay, can nijak-vi-pe chuvech. ");
INSERT INTO cak_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Rix ri rix tata'aj, ¿achique ta jun chive nuya' jun abaj pa ruk'a' ri ralc'ua'l, tok ri ac'ual xa jun pan nuc'utuj? ");
INSERT INTO cak_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O nuya' cami jun cumatz pa ruk'a', tok ri ac'ual xa jun quer nuc'utuj? ");
INSERT INTO cak_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Rix masque man can ta utz ino'oj, pero iveteman niya' utz tak sipanic chique ri ivalc'ua'l. ¡Cuánto más ri Itata' chicaj! Rija' can nuya-pe utz tak sipanic chique ri yec'utun che. ");
INSERT INTO cak_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Roma c'a ri', achel nika chivech rix chi can ta utz quino'oj niqui'en ri vinak iviq'uin, quiri' mismo tibana' rix quiq'uin rije'. Roma jari' ruc'u'x ri ley ri xyo'ox che ri Moisés, y ruc'u'x ri quitz'iban can ri profetas ojer. ");
INSERT INTO cak_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quixoc c'a chupan ri puerta co'ol ruvech. Roma jani na (nim, tij) ruvech ri puerta y ri bey ri ni'e chupan ri lugar quichin ri manak chic che'el yecolotaj, y más eq'uiy ri ye'oc chiri'. ");
INSERT INTO cak_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero co'ol oc ruvech ri puerta y co'ol oc ruvech ri bey ri ni'e chupan ri lugar quichin ri c'o quic'aslen richin jumul, y man eq'uiy ta ri ye'ilo richin. ");
INSERT INTO cak_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Rix tibana' cuenta ivi' chiquivech ri niquik'ebaj-qui' chi eyo'ol rubixic ri nu'ij-pe ri Dios pa cánima, ri achel ovejas ri man jun oc quimac ye'oc chi'icojol, pero pa tak cánima xa e'achel c'uxunel tak utuva'. ");
INSERT INTO cak_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Pero riq'uin nitz'et ri achique chi c'aslen quic'uan, rix nivetemaj quivech. Achel jun mata q'uix, man nuya' ta uva, y jun mata (xulu-quiej, zarza), man nuya' ta higo. ");
INSERT INTO cak_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quiri' mismo xa achique na che', si utz, utz ruvech nuya'. Jac'a ri che' man utz ta, man utz ta ruvech nuya'. ");
INSERT INTO cak_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Jun che' utz, manak che'el nuya' itzel tak ruvech, y jun che' man utz ta, manak che'el nuya' utzulaj tak ruvech. ");
INSERT INTO cak_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y ronojel che' ri man nuya' ta utzulaj tak ruvech, nikases y niyo'ox pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Roma c'a ri', rix xtivetemaj achique chi vinak ri ec'o chi'icojol riq'uin nitz'et ri achique chi c'aslen quic'uan. ");
INSERT INTO cak_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man conojel ta ri ye'in ¡Ajaf! ¡Ajaf! chuve, ri xque'oc richin ri aj-chicaj gobierno. Xaxe ri yebano ri nurayij ri Nata' chicaj. ");
INSERT INTO cak_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y tok xterila' ri k'ij ri', eq'uiy ri xque'in chuve: ¡Ajaf! ¡Ajaf! Roj pan abi' xkatzijoj ruch'abel ri Dios, pan abi' xekelesaj itzel tak espíritu pa cánima ri vinak, y pan abi' xekabanala' q'uiy milagros, xquecha'. ");
INSERT INTO cak_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jac'a yin quire' xtin-ij chique ri xque'in quiri': Yin man jun bey xin-ij chi rix vichin. Quixel-e viq'uin, rix ri rix banoy itzel tak no'oj, xquicha' chique. ");
INSERT INTO cak_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Xa achique na jun nac'axan ri ch'abel re yitajin chubixic, y nu'on ri nu'ij, ninjunumaj riq'uin jun achi ri jabel ninojin, roma chupan abaj xupaba-vi ri racho. ");
INSERT INTO cak_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xpe c'a job, xepe cak'ik', xumol-pe-ri' rakan tak ya', y ronojel ri' xberuc'aka-ri' chirij ri jay ri', pero man xtzak ta, roma chupan abaj tz'uyul-vi. ");
INSERT INTO cak_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero xa achique na jun nac'axan ri ch'abel re yitajin chubixic y xa man nu'on ta ri nu'ij ri ch'abel ri', ninjunumaj riq'uin jun nacanic achi ri xupaba' racho pa ruvi' (sanayi, sanayil). ");
INSERT INTO cak_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xpe c'a job, xepe cak'ik', xumol-pe-ri' rakan tak ya', y ronojel ri' xberuc'aka-ri' chirij ri jay ri', y xa xtzak, chi ronojel xvuluvu'. Quiri' ri ch'abel ri xeru'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y tok xtane' chubixic re', ri vinak can achique na xquina' che ruchojmil ruch'abel ri Dios ri achok riq'uin yerutijoj-vi. ");
INSERT INTO cak_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Roma nik'alajin chi riq'uin ri Dios petenak-vi, y man achel ta yetijon ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Tok ri Jesús kajnak chic pe pa ruvi' ri juyu', eq'uiy vinak xetzekle'en richin. ");
INSERT INTO cak_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Xpe c'a jun achi niyavej riq'uin ri yabil lepra, xuxuque' chuvech y xu'ij che: Ajaf, si rat najo', yin veteman chi yatiquer na'an chi yin yic'achoj riq'uin ri nuyabil, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ri Jesús xuya' c'a apu ruk'a' chirij, y xu'ij che: Ninjo', cac'achoj c'a, xcha'. Can jari' xq'uis-e ri lepra chirij, ");
INSERT INTO cak_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","y ri Jesús xu'ij che: C'o axiquin, man jun achok che tatzijoj-vi ri xbanataj aviq'uin, xa choj cabin, te'ac'utu-avi' chuvech ri sacerdote israelita, y taya' ri sipanic ri ru'in can ri Moisés, richin nik'alajin chiquivech rije' chi rat ch'ajch'oj chic, xcha-e che. ");
INSERT INTO cak_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tok ja ntoc-apu ri Jesús pa tinamit Capernaum, c'o c'a jun uc'uay quichin soldados xjel-apu riq'uin richin nuc'utuj ruquemelal chuvech, ");
INSERT INTO cak_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","y quire' nu'ij: Ajaf, yin c'o jun nusamajinel chivacho, cotz'ol roma caminak ruk'a-rakan, y can nijilo pa ruk'a' ri k'axomal, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xu'ij che: Yin yi'e richin nenc'achojrisaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jac'a ri uc'uay quichin soldados xu'ij che ri Jesús: Ajaf, rat can c'o ak'ij, romari' chuve yin man nuc'ul ta chi yatoc pa vacho. Xaxe ta'ij chi nic'achoj ri nusamajinel, y yin veteman chi can xtic'achoj-vi. ");
INSERT INTO cak_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yin quiri' nin-ij, roma ja jun yin yinc'o chuxe' rutzij jun chic, y jari' ri ni'in chuve ri achique nic'atzin chi nin-en. Y ec'o soldados eyo'on pa nuk'a'. Tok nin-ij che jun chi ti'e, can ni'e-vi; y si nin-ij che jun chic chi tipe, can nipe-vi. Tok nin-ij che ri nusamajinel chi tubana' jun samaj, can nu'on-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ri Jesús can achique na xuna' tok xrac'axaj ri ch'abel ri', y xu'ij chique ri ebenak chirij: Kitzij nin-ij chive chi nis-ta chiquicojol ri nuvinak israelitas man vilon ta jun ri can nunimaj chi nibanataj ri nin-ij che, achel nunimaj ri jun achi re'. ");
INSERT INTO cak_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yin nin-ij chive chi c'o q'uiy xquepe quire' achique lugar ntel-vi-pe ri k'ij y quila' achique lugar nika-vi-ka, conojel re' xquetz'uye' riq'uin ri Abraham, ri Isaac, y ri Jacob chupan ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jac'a ri achok chique xsuj na'ey chi ye'oc ruvinak ri aj-chicaj gobierno, chupan ri más roch' che ri k'eku'n xque'ec'ak-vi can. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jac'ari' tok ri Jesús xu'ij che ri uc'uay quichin soldados: Vacami, catzolij. Rat roma xanimaj chi ri asamajinel nic'achoj, can quiri' vi xtibanataj, xcha-e che. Y ri samajinel ja hora ri' xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cak_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tok ri Jesús xbe chiracho ri Pedro, xutz'et chi ri rujite' ri Pedro cotz'ol choch'at y nijino pa c'atan. ");
INSERT INTO cak_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpe ri Jesús (xutz'om, xuchop) apu ruk'a' rujite' ri Pedro, y jari' xq'uis-e ri c'atan chirij ri ixok. Xcataj c'a pe y ja yan chic yerilij ri Jesús y ri ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tok xoc-pe ri ak'a' chupan ri k'ij ri', eq'uiy vinak ri c'o itzel tak espíritu quiq'uin xe'uc'uax-apu chuvech ri Jesús. Jac'a ri Jesús xaxe jun ch'abel xc'atzin chi xu'ij chique ri itzel tak espíritu richin xerelesaj-e quiq'uin ri vinak, y xu'on chique conojel ri yeyavej chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Quiri' xu'on richin nibanataj ri ru'in can ri profeta Isaías tok xu'ij: Ja rija' xelesan-e ri kayabil y xuq'uen-e ri kak'axomal. Quiri' ru'in can ri Isaías. ");
INSERT INTO cak_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tok ri Jesús xutz'et chi eq'uiy vinak quimolon-qui' chirij, rija' xu'ij chique ri ru-discípulos: Kuk'ax-apu juc'an ruchi' ri lago, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","C'o c'a jun achi q'uiy reteman chirij ri ley xjel-apu riq'uin ri Jesús y xu'ij che: Tijonel, yin yatintzekle'ej xa achique na lugar yabe-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Y ri Jesús xu'ij che: Ri xivan c'o quijul yec'uje-vi, y ri chicop yeropop pa cak'ik' c'o quisoc. Jac'a yin ri xitak-pe richin xinalex chi'icojol, man jun lugar richin yinuxlan-vi juba', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jac'ari' c'o chic jun tzekle'ey richin ri Jesús ri xu'ij-apu che: Ajaf, taya' na c'a lugar chuve chi ninmuk na can ri nata' na'ey, c'ajari' xcatintzekle'ej, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero ri Jesús xu'ij che: Rat quinatzekle'ej, y ri ecaminak chupan ri quimac, ja rije' quemuku ri qui'anima'i', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tok ri Jesús xoc-e chupan ri canoa, ri ru-discípulos xebe chirij. ");
INSERT INTO cak_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","C'ate xquina', xtiquer-pe jun nimalaj cak'ik' pa ruvi' ri ya', y roma ruchuk'a' ri cak'ik', ri ya' can achel chovon tak boloj nu'on nijote' chicaj, y ri canoa juba' ma numuk ya'. Jac'a ri Jesús xa niver benak. ");
INSERT INTO cak_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Xepe ri discípulos, xquic'asoj y xqui'ij che: ¡Ajaf! Kojato'. Vacami nkujik', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Y ri Jesús xu'ij chique: ¿Achique roma ixi'in-ivi'? ¿La man cukul ta ic'u'x viq'uin? xcha'. Xcataj-pe rija', cof xch'o che ri cak'ik' y ri ya', y jabel li'an xu'on-ka ruvi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ri discípulos achique na xquina' tok xquitz'et ri xu'on ri Jesús y niquibila' c'a: ¿Achique c'a chi achi re' chi hasta ri cak'ik' y ri ya' niquinimaj rutzij? yecha'. ");
INSERT INTO cak_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Tok ri Jesús y ri ru-discípulos ec'o chic apu pa jun lugar quichin ri aj-Gadara ri juc'an apu ruchi' ya', chupan ri camposanto xe'el-pe ca'i' achi'a' ri c'o itzel tak espíritu quiq'uin ri xuquic'ulu'. Ri achi'a' ri' jani na exibinel, y romari' man jun chic vinak nik'ax chupan ri bey ri'. ");
INSERT INTO cak_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri ca'i' achi'a' ri' riq'uin cuchuk'a' xqui'ij-apu che ri Jesús: Rat Jesús, ri Ruc'ajol ri Dios, ¿achique najo' chike? ¿Ja yan xape vave' richin nkojaya' pa k'axomal tok xa man jani tuka ri tiempo? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Más quila' apu juba' che ri lugar ri', ec'o q'uiy ak yeva'. ");
INSERT INTO cak_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y ri itzel tak espíritu ri ec'o quiq'uin ri ca'i' achi'a', niquic'utula' quiquemelal chuvech ri Jesús, y niqui'ij: Si nkojavelesaj-e quiq'uin ri achi'a', taya' lugar chike chi nkujoc quiq'uin la ak ec'o chila', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xu'ij: Quixel c'a, xcha'. Xe'el c'a e ri itzel tak espíritu quiq'uin ri achi'a' y xe'oc quiq'uin ri ak, y conojel ri ak niquitelela-qui' xebe chuvech jun rak'aric juyu' c'a pa ya', y chiri' xejik'-vi. ");
INSERT INTO cak_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Jac'a ri yeyuk'un quichin ri ak xe'enimaj. Xebe pa tinamit y xequiya' rutzijol ronojel ri xbanataj chiri', y ri xbanataj quiq'uin ri ca'i' achi'a' c'o itzel tak espíritu quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Juba' ma conojel vinak richin ri tinamit xepe chutz'etic ri Jesús. Y tok xquitz'et, rije' quire' xqui'ij che: Tabana' favor, catel-e chupan ri lugar re rojc'o-vi, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jac'ari' tok ri Jesús y ri ebenak chirij xe'oc-pe pa canoa richin xek'ax-pe ri juc'an ruchi' ri ya', xepe c'a chupan ri tinamit ri can tic'uje-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jac'ari' tok xuc'uax-apu chuvech ri Jesús jun ri caminak ruk'a-rakan cotz'ol-e chuvech ruvaro'el. Tok ri Jesús xerutz'et ri ecanoy richin, chi riq'uin ronojel cánima epetenak riq'uin, rija' xu'ij che ri caminak ruk'a-rakan: Valc'ua'l, tiquicot ri avánima; ri amac xe'an yan perdonar, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jari' tok ec'o achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés xqui'ij-ka pa tak cánima chirij ri Jesús: Ri achi re' itzel nich'o chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ri Jesús reteman ri niquinojij ri achi'a' ri'. Romari' quire' xu'ij chique: ¿Achique roma xa itzel ri ninojij pa tak ivánima? ");
INSERT INTO cak_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Roma, ¿achique ri más man c'ayef ta richin nin-ij che ri niyavej re'? ¿Ja chi xe'an yan perdonar ri rumac, o ja chi ticataj y tuc'uaj-e ri ruvaro'el? ");
INSERT INTO cak_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vacami c'a, richin chi rix nivetemaj chi yin ri xitak-pe richin xinalex chi'icojol yo'on-pe uchuk'a' chuve richin nin-en perdonar mac pa ruvi' ri roch'ulef, titz'eta' c'a, xcha'. Jac'ari' xu'ij che ri caminak ruk'a-rakan: Cacataj, tac'uaj-e la avaro'el y cabin chi'avacho, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xcataj c'a e ri xc'achojrises y xbe chiracho. ");
INSERT INTO cak_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tok ri quimolon-apu-qui' chiri' xquitz'et re', can achique na xquina' y xquiya' ruk'ij ri Dios ri ruyo'on-pe ri nimalaj uchuk'a' ri' chiquicojol. ");
INSERT INTO cak_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Tok ri Jesús xel-pe chiri', xutz'et jun achi rubinan Mateo, tz'uyul ri achique lugar nuc'ul-vi can ri impuestos, y xu'ij che: Quinatzekle'ej, xcha'. Xcataj c'a pe ri Mateo y xutzekle'ej ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y jun k'ij tok ri Jesús tz'uyul chuchi' mesa pa jay, eq'uiy c'uluy tak impuestos y vinak ri ni'ix aj-mac chique xe'uka, y ja jun rije' xetz'uye-apu chuchi' ri mesa riq'uin ri Jesús y ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Tok ri achi'a' fariseos xquitz'et ri najin chiri', quire' xqui'ij chique ri ru-discípulos ri Jesús: ¿Achique roma ri Itijonel niva' quiq'uin la c'uluy tak impuestos y quiq'uin la aj-mac tak vinak? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tok ri Jesús xrac'axaj ri tzij re', rija' xu'ij: Man chique ta ri utz niquina' nic'atzin-vi ri aj-k'omanel, xa chique ri yeyavej. ");
INSERT INTO cak_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Roma c'a ri', rix titz'eta' y tivetemaj achique ruchojmil ri ruch'abel ri Dios tz'iban can ri nu'ij: Yin ninjo' chi rix yixpokonan, y mani ye'icamisaj chicop chinuvech. Quiri' nin-ij chive, roma yin man xipe ta chicoyoxic ri niquinojij chi can choj ri quic'aslen; yin xipe chicoyoxic ri aj-mac, richin tiquijala' quino'oj y tiquiya' can ri mac, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tok xe'uka ru-discípulos ri Juan ri Bautista riq'uin ri Jesús, xqui'ij che: Roj q'uiy (mul, paj) nika'an coch'on vayijal. Quiri' mismo niqui'en ri yetzekle'en quichin ri achi'a' fariseos. Jac'a ri a-discípulos rat, ¿achique roma man niqui'en ta coch'on vayijal? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xu'ij chique: ¿Utz cami chi yebison ri ec'o pa jun c'ulubic tok c'a c'o na ri ala' ri c'o pa ruc'ulubic quiq'uin? Pero xque'erila' k'ij chi ri ala' xteleses-e chiquicojol; c'ajari' xtiqui'en coch'on vayijal. ");
INSERT INTO cak_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Man jun vinak xtucusaj jun c'ac'ac' c'ojobel richin nuc'ojoj jun tziek ri xa tzia'k chic. Roma ri c'ac'ac' c'ojobel c'a nuc'ol na ri' y xa nujec' ri tzia'k chic, y romari' más nirak'ach'itaj-ka. ");
INSERT INTO cak_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y man jun niyaco c'ac'ac' vino chupan tzia'k tak tz'un. Roma ri c'ac'ac' vino yerubojij-e ri tz'un, y nitix-e ri vino, y ri tz'un man jun chic yec'atzin-vi. Man quiri' ta ni'an. Ri c'ac'ac' vino niyac chupan c'ac'ac' tak tz'un, y quiri' nis-ta ri tz'un man yebojbo' ta, y nis-ta ri vino man nitix ta e; chi ca'i' niyaque' utz. Quiri' ri ejemplo xutzijoj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ri Jesús c'a najin na chutzijosic ronojel re', tok c'o jun achi c'o ruk'ij xuxuque' chuvech, y quire' xu'ij che: Ri numi'al c'a ja oc (xcom, xquen) ka. Tabana' favor, jo' chuvij richin na'aya' ri ak'a' pa ruvi'; yin veteman chi nic'astaj chic, xcha' ri achi. ");
INSERT INTO cak_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xcataj c'a e ri Jesús, y xutzekle'ej-e ri achi junan riq'uin ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jac'ari' tok jun ixok ri ja doce juna' nibin ruquiq'uel roma jun yabil xjel-apu chirij ri Jesús y (xutz'om, xuchop) apu ruchi' ri rutziak. ");
INSERT INTO cak_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Roma rija' can ru'in-pe pa ránima: Xa riq'uin ta juba' (nintz'om, ninchop) apu ruchi' ri rutziak, yic'achoj. Quiri' ru'in-pe pa ránima. ");
INSERT INTO cak_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús xtzu'un-apu riq'uin ri ixok, y quire' xu'ij che: Numi'al, roma ronojel avánima xape viq'uin, romari' xacolotaj chuvech ri ayabil. Caquicot, xcha' che. Y ri ixok ja hora ri' xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cak_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tok ri Jesús xoc-apu pa racho ri achi c'o ruk'ij, xerutz'et-apu ri yek'ojoman xul roma ri ámna, y man juba' ta oc vinak ri yech'ujlan riq'uin ok'ej. ");
INSERT INTO cak_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jac'ari' tok rija' xu'ij chique: Quixel na e juba', roma ri xten re' man caminak ta, xa niver, xcha'. Pero rije' xa xetze'en-ka chirij. ");
INSERT INTO cak_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jac'a tok e'elesan chic pe ri ec'o pa jay, xoc-apu ri Jesús, (xutz'om, xuchop) apu ruk'a' ri xten, y ri xten jari' xcataj-pe. ");
INSERT INTO cak_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbanataj chiri', xbe rutzijol chi naj chi nakaj chupan ri roch'ulef ri'. ");
INSERT INTO cak_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tok ri Jesús elenak chic pe chiri', ec'o ca'i' man yetzu'un ta xetzekle'en richin y riq'uin cuchuk'a' niqui'ij: ¡Tapokonaj kavech rat ri rat riy-rumam can ri rey David! yecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tok ri Jesús xoc-apu ri pa jay ri can nic'uje-vi, xe'oc-apu ri ca'i' ri' riq'uin. Y ri Jesús xuc'utuj chique: ¿Ninimaj rix chi yin yitiquer nin-en chive chi yixtzu'un? xcha' chique. Y rije' xqui'ij: Ja', Ajaf. Nikanimaj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jac'ari' ri Jesús xuya-apu ruk'a' chi tak runak'-quivech y xu'ij chique: Roma rix ninimaj chi yin yitiquer nin-en chive chi yixtzu'un, tibanataj c'a ri nijo', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y ri quivech, jari' xejakataj. Jac'a ri Jesús quire' xu'ij-e chique: C'o ixiquin, man jun achok che titzijoj-vi ri xbanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Jac'a rije' xa chi naj chi nakaj chupan ri lugar ri' xquelesaj-vi rutzijol ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ri ca'i' ri xc'achoj runak'-quivech ja ye'el-e riq'uin ri Jesús chiri', tok ec'o chic ch'aka' quic'amon-apu jun mem ri ocunak itzel espíritu riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tok ri Jesús relesan chic e ri itzel espíritu, ri mem xch'o. Jac'a ri xetz'eto, achique na xquina' y niqui'ij: Man jun bey tz'eton chi quire' nibanataj vave' pa roch'ulef Israel, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Jac'a ri achi'a' fariseos xa quire' niqui'ij: Ja ri cajaval ri itzel tak espíritu niyo'on ruchuk'a' ri Jesús richin yerelesaj itzel tak espíritu, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Pa ronojel tak tinamit y aldeas nik'ax-vi ri Jesús, yerutijoj ri israelitas ri niquimol-qui' pa tak qui-sinagoga. Nutzijoj chique ri utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc pa ruk'a' ri Ajaf Dios richin yeru'on gobernar, y nu'on chique ri yeyavej chi yec'achoj chuvech ronojel ruvech yabil y k'axomal. ");
INSERT INTO cak_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tok xerutz'et chi eq'uiy ri vinak, xupokonaj quivech, roma ecosnak chucanoxic ruchojmil ri c'aslen, y man jun nito'on quichin, xa e'achel ovejas ri manak quiyuk'unel. ");
INSERT INTO cak_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jac'ari' tok ri Jesús xu'ij chique ri ru-discípulos: Can kitzij chi ri vinak e'achel jun mama li'aj tico'n ri nic'atzin nimol ruvech, pero ri yemolo man eq'uiy ta. ");
INSERT INTO cak_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Roma c'a ri' rix, tic'utuj che Rajaf ri samaj chi querutaka-pe más rusamajela' pa rutico'n. ");
INSERT INTO cak_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ri Jesús xeroyoj ri doce ru-discípulos y xu'on-e chique chi c'o quik'a' chi yequelesaj itzel tak espíritu y ronojel ruvech yabil y k'axomal quiq'uin ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Y jare' quibi' ri doce apóstoles: ri na'ey ja ri Simón ri ni'ix Pedro che y ri Andrés ri quichak'-quinimal qui' riq'uin. Jun chic, ja ri Jacobo y ri Juan ri eruc'ajol ri Zebedeo. ");
INSERT INTO cak_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","C'o ri Felipe, c'o ri Bartolomé, c'o ri Tomás, y jun chic, ja ri Mateo ri c'uluy impuestos. C'o ri Jacobo ri ruc'ajol ri Alfeo, ri Lebeo ri ni'ix Tadeo che, ");
INSERT INTO cak_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ri Simón ri c'o quiq'uin ri achi'a' ri ni'ix cananista chique, y ri Judas Iscariote ri xtijacho-e richin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ja doce achi'a' ri' ri xerutak-e ri Jesús, y quire' ruchojmil ri samaj xu'ij-e chique: Vacami yixbe, pero man quixbe quiq'uin ri man israelitas ta, y man quixoc pa tak tinamit quichin ri aj-Samaria. ");
INSERT INTO cak_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ja quiq'uin ri kavinak israelitas ri e'achel ovejas esatznak can quixbin-vi. ");
INSERT INTO cak_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tok rix benak chiri', quire' ti'ij tok nitzijoj ri ruch'abel ri Dios: Vacami, ri aj-chicaj gobierno nik'alajin chic chi'icojol, quixcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ri yeyavej y ri c'o ri yabil lepra chiquij, que'ic'achojrisaj can. Que'ic'asoj ri anima'i'. Que'ivelesaj ri itzel tak espíritu pa tak cánima ri vinak. Y roma ronojel ri uchuk'a' re' xa sipan chive, rix man jun rajil tic'utuj chique ri ye'ito' riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Man jun ruvech méra tiya-e pa tak (ipas, ic'an), achel ri banon che oro, che plata, y che cobre. ");
INSERT INTO cak_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Man tic'uaj-e morral richin ri ibey, ni jun chic solaj itziak, nis-ta jun chic par xajab, nis-ta ch'ami'y. Roma jun samajinel can utz vi chi nitzuk roma ri samaj ri nu'on. ");
INSERT INTO cak_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Xa achique na tinamit o aldea ri xquixoc-vi, na'ey na tivetemaj achique chi vinak ri utz chi yixc'uje' pa racho. Chiri' c'a chiracho quixc'uje-vi, c'a quixel na pe chupan ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y tok yixoc-apu ri pa jay ri yixec'uje-vi, que'ibana' saludar ri ec'o chiri'. ");
INSERT INTO cak_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si ri ec'o chupan ri jay ri' utz niquic'ul ivech, ri uxlanen richin ri Dios ri nirayij pa quivi', can xtika-vi pa quivi'. Pero si man utz ta niquic'ul ivech, ri uxlanen richin ri Dios man xtika ta can pa quivi', xa xtitzolij chic pe iviq'uin. ");
INSERT INTO cak_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y xa achique na jun ri man nuc'ul ta ivech, y man nrac'axaj ta ri ruch'abel ri Dios ri nitzijoj rix, tok yixel-pe ri pa jay o ri pa tinamit, (tiquiraj, titota') can ri pokolaj chi tak ivakan chiquivech ri aj chiri', richin tiquina'ej chi can man utz ta ri xqui'en. ");
INSERT INTO cak_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yin kitzij nin-ij chive chi tok xtuka ri k'ij chi xtinic'ox ronojel ch'utik-nima'k, más q'uiy castigo xtika pa quivi' ri man niquic'ul ta ivech, que chuvech ri xtika pa quivi' ri aj-Sodoma y ri aj-Gomorra. ");
INSERT INTO cak_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vacami c'a, yin yixintak achel ovejas chiquicojol vinak ri e'achel utuva'. Romari' tibana' achel nu'on ri cumatz, roma jun cumatz cha'anin nujec'-ri' tok nuna'ej chi c'o petenak. Y tibana' achel nu'on jun paloma, roma rija' can man jun oc rumac. ");
INSERT INTO cak_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tibana' cuenta ivi' chiquivech ri itzel yixquitz'et. Roma rije' xquixquijach pa quik'a' ri achi'a' junan niqui'en gobernar; y xquixquich'ey pa tak qui-sinagoga. ");
INSERT INTO cak_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Rix hasta chiquivech gobernadores y chiquivech reyes xquixuc'uax-vi voma yin, richin quiri' xquinik'alajrisaj chiquivech rije' y chiquivech ri man israelitas ta. ");
INSERT INTO cak_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero tok xquixjach pa quik'a' ri yebano gobernar, man tich'ujirisaj-ivi' riq'uin ri achique rubanic xquixch'o chiquivech, nis-ta ri achique chi ch'abel xti'ij. Roma chupan ri hora ri' xtiyo'ox-pe ch'abel chive ri xtic'atzin chi xti'ij. ");
INSERT INTO cak_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Roma mana-ta rix ri xquixch'o, ja ri Lok'olaj Espíritu richin ri Itata' Dios ri xtiyo'on ch'abel pa tak ivánima ri xtic'atzin chi xti'ij. ");
INSERT INTO cak_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ec'o quichak'-quinimal qui' ri xtiquisujuj-qui' pa camic. Quiri' mismo xtiqui'en ri tata'aj quiq'uin ri calc'ua'l. Ec'o ac'ola' xquecataj chiquij quite-quitata' y xquequijach pa camic. ");
INSERT INTO cak_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Itzel xquixtz'et coma conojel roma ri nubi' yin. Jac'a ri xtucoch' ruvech chupan ri k'axomal c'a pa ruq'uisbel, xticolotaj. ");
INSERT INTO cak_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Tok ni'an pokon chive pa jun tinamit, quixenimaj y quixbin pa jun chic tinamit. Roma yin kitzij nin-ij chive chi rix c'a man jani quixk'ax chupan ronojel tinamit ri ec'o vave' pan Israel, tok yin ri xitak-pe richin xinalex chi'icojol yipe chic jun bey. ");
INSERT INTO cak_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Man jun discípulo ri más reteman que chuvech ri rutijonel. Y man jun samajinel ri más c'o ruk'ij que chuvech ri rajaf. ");
INSERT INTO cak_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ri discípulo can nuk'asaj na vi achel nuk'asaj ri rutijonel, y quiri' mismo ri samajinel can nuk'asaj na vi achel nuk'asaj ri rajaf. Roma si ri vinak xinquicusaj chi Beelzebú yin ri yin Tata'aj chi'icojol, rix ri rix valc'ua'l, xa más chuvech ri' xquixquicusaj-vi. ");
INSERT INTO cak_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Roma c'a ri', rix man tixi'ij-ivi' chiquivech ri vinak, roma man jun achique ri banon che'elek'el ri man ta xtek'alajin-pe, y man jun ri evan ri man ta xtitemetaj. ");
INSERT INTO cak_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ronojel ri nin-ij chive tok rojc'o kayon, tivelesaj rutzijol chosakil. Ri xin-ij chive pa tak ixiquin, man tivevaj-ka, xa tivelesaj rutzijol pa ruvi' tak jay. ");
INSERT INTO cak_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixi'ij-ivi' chiquivech ri yecamisan ri cuerpo, pero ri ivánima man yetiquer ta niquicamisaj. Rix tixi'ij-ivi' chuvech ri Jun ri c'o ruk'a' richin nuq'uis ruk'ij ri ivánima y ri i-cuerpo riq'uin ri xquixruya' pa k'ak' richin jumul. ");
INSERT INTO cak_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Rix iveteman chi ca'i' ch'utik tak ch'ip-ch'ip tok yec'ayix, man q'uiy ta oc cajil, pero nis-ta jun chique rije' xtitzak pan ulef si ri Itata' chicaj man nuya' ta lugar. ");
INSERT INTO cak_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y rix hasta ri rusumal ivi' ajlan ronojel. ");
INSERT INTO cak_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Roma c'a ri', man tixi'ij-ivi'. Más c'o ivakale'n rix que chiquivech q'uiy ch'ip-ch'ip. ");
INSERT INTO cak_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Xa achique na ri can chiquivech vinak nu'ij-vi chi vichin yin, ja jun yin xtin-ij chi ri jun ri' vichin yin, y can chuvech ri Nata' ri c'o chicaj xtin-ij-vi. ");
INSERT INTO cak_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Y xa achique na ri can chiquivech vinak xtu'ij-vi chi xa manak ru-cuenta chuve yin, quiri' mismo yin can chuvech ri Nata' ri c'o chicaj xtin-ij-vi chi ri jun ri' manak nu-cuenta che. ");
INSERT INTO cak_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man tinojij chi riq'uin ri xipe yin choch'ulef tok manak chic oyoval chiquicojol ri vinak. Man quiri' ta. Yin xipe richin chi voma yin, más xticataj oyoval chiquicojol ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Xipe richin nin-en chi man junan ta niquinojij chiquivech ri achi riq'uin ri rutata', ri xten riq'uin ri rute', y ri alibetz riq'uin ri ralite'. ");
INSERT INTO cak_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Romari' ri itzel xquetz'eto richin jun, xa ja mismo ri ec'o riq'uin pa racho. ");
INSERT INTO cak_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri más xquerojo' rute-rutata' que chinuvech yin, man nuc'ul ta chi ntoc vichin yin. Ri te'ej-tata'aj ri más yecajo' quimi'al-calc'ua'l que chinuvech yin, man nuc'ul ta chi ye'oc vichin yin. ");
INSERT INTO cak_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ri nupokonaj nuya-ri' chuvech ri camic richin yirutzekle'ej, man nuc'ul ta chi ntoc vichin yin. ");
INSERT INTO cak_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ruc'aslen voma yin, can xtril-vi. ");
INSERT INTO cak_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri nic'ulu ivech rix, ja yin ri nuc'ul nuvech; y ri nic'ulu nuvech yin, nuc'ul ruvech ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri utz nuc'ul ruvech jun profeta, roma ri profeta jun tzijoy ruch'abel ri Dios, junan rajil-ruq'uexel xtiyo'ox che riq'uin ri profeta. Y ri neka jun choj ruc'aslen riq'uin, y utz nuc'ul ruvech roma choj ruc'aslen ri neka riq'uin, junan rajil-ruq'uexel xtiyo'ox che riq'uin ri choj ruc'aslen. ");
INSERT INTO cak_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y xa achique na ri nisipan juba' ruraxya' jun chique ri yetzekle'en vichin, masque ri tzekle'ey vichin can manak oc ruk'ij, ri nisipan ri ya' can c'o rajil-ruq'uexel xtiyo'ox che. Quiri' ri ch'abel ri xeru'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Tok ri Jesús xuq'uis-e rubixic chique ri doce ru-discípulos ri achique nic'atzin chi nequibana', rija' xbe pa tak quitinamit ri vinak richin xe'erutijoj y richin xutzijoj ri ruch'abel ri Dios chique. ");
INSERT INTO cak_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tok ri Juan ri Bautista xrac'axaj pa cárcel ri utzulaj tak samaj yerubanala' ri Jesucristo, xerutak-e ca'i' ru-discípulos riq'uin ");
INSERT INTO cak_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","richin xquic'utuj che: ¿Ja rat ri Jun ri sujun-pe roma ri Dios chi nipe? ¿O c'a nikoyo'ej chic jun? ");
INSERT INTO cak_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jac'a ri Jesús xu'ij-pe chique ri ca'i' discípulos: Vacami quixtzolij y titzijoj che ri xitz'et can y ri xivac'axaj-e vave', ");
INSERT INTO cak_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","chi ri vinak man yetzu'un ta, vacami yetzu'un chic, ri man utz ta cakan, vacami utz yebin; ri c'o yabil lepra chiquij, yec'achoj; ri man ye'ac'axan ta, vacami ye'ac'axan chic, ri anima'i' yec'astaj; y chique ri man jun oc quichajin, nitzijos ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj. ");
INSERT INTO cak_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Y ti'ij che ri Juan chi utzulaj tzij banon che ri man nril ta jun roma chi nuxutuj can ri Dios, riq'uin ri yitajin yin, xcha-e ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tok ja yetzolij-e ri ru-discípulos ri Juan, ri Jesús (xutz'om, xuchop) nich'o pa ruvi' ruc'aslen ri Juan, y quire' xu'ij chique ri ec'o-apu riq'uin: ¿Achique ri xe'itz'eta' rix ri pa chakijlaj tz'iran ulef? ¿Xitz'et cami jun achi chiri', ri man cof ta pa'el riq'uin ri achique nutzijoj, achel jun aj pa ruk'a' cak'ik'? Man quiri' ta. ");
INSERT INTO cak_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nis-ta man xitz'et ta can jun achi ri ruyon nima'k tak cajil tziek yerucusaj. Roma ri yecusan nima'k tak cajil tziek, pa tak cacho reyes yec'uje-vi. ");
INSERT INTO cak_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pero, ¿achique ri xe'itz'eta' rix ri pa chakijlaj tz'iran ulef? Can kitzij chi xitz'et can jun profeta, pero man xe ta ri samaj richin jun profeta yo'on pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Quiri' nin-ij chive, roma ri tz'iban can ja ri Juan ri nuc'uxlaj tok nu'ij: Xtintak jun yo'ol utzulaj atzijol na'ey chavech, Richin nuchojmirisaj-apu ri abey. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yin can kitzij nin-ij chive: Chiquicojol conojel ri e'alaxnak vave' choch'ulef, man jun chic jun ri más c'o ruk'ij que chuvech ri Juan ri Bautista. Pero ri más manak oc ruk'ij chiquicojol ri erichin ri aj-chicaj gobierno, más c'o ruk'ij que chuvech ri Juan. ");
INSERT INTO cak_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xe tok xutz'uc-pe samaj ri Juan ri Bautista, jari' tok eq'uiy ri riq'uin uchuk'a' nicajo' ye'oc ruvinak ri aj-chicaj gobierno, y c'a quiri' na najin ri vacami. Y ri más niquitij quik'ij can ye'oc-vi. ");
INSERT INTO cak_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Quiri' nibanataj roma chupan ri ley ri xyo'ox che ri Moisés y chupan ri tz'iban can coma conojel ri profetas ojer, c'o k'alajrisan can pa ruvi' ri aj-chicaj gobierno. Pero c'a ja pa ru-tiempo ri Juan xbanataj-vi. ");
INSERT INTO cak_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si rix ninimaj o man ninimaj ta, pero ri nu'ij chupan ri tz'iban can chi nipe ri Elías, ri' ja ri Juan. ");
INSERT INTO cak_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij. ");
INSERT INTO cak_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Pero, ¿achok riq'uin cami yenjunumaj-vi ri vinak richin ri vacami? Re' ejunan quiq'uin ri ac'ola' ri ye'etz'an pa tak c'ayibel y riq'uin cuchuk'a' yesiq'uin chiquivech, y niqui'ij: ");
INSERT INTO cak_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Xkak'ojomaj xul chivech, y rix man xixxojo ta. Xkabixaj bix richin bis chivech y man xixok' ta. Quiri' ri vinak re'. ");
INSERT INTO cak_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Roma tok xuka ri Juan ri Bautista, man nutij ta pan y man nukum ta vino, y eq'uiy ye'in chi c'o itzel espíritu riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jac'a tok xinuka yin ri xitak-pe richin xinalex chi'icojol, xa ronojel nintij y ninkum, y eq'uiy ye'in chi xe va'in voma y yin kumuy vino, yin (cachbil, cach'il) ri c'uluy impuestos y ri vinak aj-mac yixcha' chique. Pero ri no'oj ri petenak riq'uin ri Dios nik'alajin pa tak quic'aslen ri yebano ri rusamaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jac'ari' tok ri Jesús c'o xu'ij chiquij ri ec'o pa tak tinamit ri rubanon-vi-pe q'uiy milagros, roma man jun bey xquijal quino'oj richin ta xquiya' can ri quimac. ");
INSERT INTO cak_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Rija' quire' xu'ij: Ninvok'ej ivech rix aj-Corazín, y rix aj-Betsaida, roma xa ta ja ri pa tinamit Tiro y pa tinamit Sidón xe'an-vi ri milagros ri xe'an pan itinamit rix, rije' xquijal yan ta quino'oj y xquiya' yan ta can ri quimac, y quicusalo'n ta chic quitziak richin bis, y quiyalo'n ta chic chaj chiquij, richin retal chi yebison roma ri mac quibanalo'n. ");
INSERT INTO cak_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Roma c'a ri', nin-ij chive chi tok xtuka ri k'ij chi xtinic'ox ronojel ch'utik-nima'k, ja rix aj-Corazín y rix aj-Betsaida ri más q'uiy castigo xtika pan ivi' que chuvech ri xtika pa quivi' ri aj-Tiro y ri aj-Sidón. ");
INSERT INTO cak_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y rix aj-Capernaum, ninojij chi xquixjoto'ex chila' chicaj, pero xa man quiri' ta. Roma xa c'a chupan ri lugar quichin ri anima'i' xquixkases-vi-ka. Roma xa ta ronojel ri milagros ri xe'an chivech rix can ta chiquivech ri aj-Sodoma xe'an-vi, rije' man ta xc'at ri quitinamit, xa c'a ec'o ta ri vacami. ");
INSERT INTO cak_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero yin nin-ij chive chi tok xtuka ri k'ij chi xtinic'ox ronojel ch'utik-nima'k, ja rix ri rixc'o pa tinamit Capernaum ri más q'uiy castigo xtika pan ivi' que chuvech ri xtika pa quivi' ri aj-Sodoma. ");
INSERT INTO cak_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ja tiempo ri' tok ri Jesús quire' xu'ij: Nata' Dios, rat ri Rajaf ri caj y ri roch'ulef, matiox ninya' chave roma man xak'alajrisaj ta ruchojmil ri yitajin chubixic chiquivech ri vinak ri niquina' chi q'uiy queteman y can c'o quino'oj. Xa ja chiquivech ri achel ac'ola' quibanon che ri cánima xak'alajrisaj-vi. ");
INSERT INTO cak_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can quiri' vi Nata' Dios, roma rat jari' ri xka chavech chi xa'an. Quiri' xu'ij ri Jesús pa ru-oración. ");
INSERT INTO cak_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","C'ajari' rija' xu'ij: Ri Nata' Dios ronojel ruyo'on-pe pa nuk'a'. Y man jun chic etemayon (yin achique, ayincu'x) yin, xaxe ri Nata'. Y man jun etemayon (achique, acu'x) ri Nata', xaxe yin ri Ruc'ajol, y ri achok che xtinjo' xtink'alajrisaj-vi. ");
INSERT INTO cak_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixampe viq'uin chi'ivonojel rix ri rix cosnak chic chuxe' ralal ri eka'n ri yo'on chivij, y yin xtin-en chive chi xtivil ri kitzij uxlanen richin ri ivánima. ");
INSERT INTO cak_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tiya-e ri nu-yugo yin chirij ikul, y titijoj-pe-ivi' viq'uin, roma yin (ch'uch'uj, me'l oc) vánima y nukasan-vi'. Si rix quiri' xti'en, ri ivánima xtril ri kitzij uxlanen. ");
INSERT INTO cak_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Roma ri nu-yugo ri xtinya' chirij ikul, manak cosic ruc'amon-pe chive, y ri eka'n ri xtinya' chivij man al ta richin nic'uaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chupan ri tiempo ri', pa jun sábado ri k'ij richin uxlanen, ri Jesús y ri ru-discípulos yek'ax pa jun juyu' ticon trigo chuvech. Ri discípulos roma xpe vayijal quiq'uin, yequik'upula-e rutza'n ri trigo ebenak y yequitij. ");
INSERT INTO cak_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Tok ri achi'a' fariseos xequitz'et-pe, quire' xqui'ij che ri Jesús: Que'atz'eta' la a-discípulos, ru-ley ri Dios man juba' nuya' lugar chi ni'an achel ri yetajin riq'uin. Roma vacami k'ij richin uxlanen, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ri Jesús xu'ij chique: ¿Man jun bey ibanon leer chupan ruch'abel ri Dios ri achique xqui'en ri David y ri ebenak chirij chupan ri ojer can tiempo tok yevayijan chiri'? ");
INSERT INTO cak_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Roma ri David xoc pa racho ri Dios chucanoxic achique niquitij, y ja ri pan ri sujun chic chuvech ri Dios ri xquitij, masque ru-ley ri Dios nu'ij chi ri pan ri' nis-ta ri David, nis-ta ri ebenak chirij c'o quik'a' che, roma xaxe ri sacerdotes israelitas c'o quik'a' che. ");
INSERT INTO cak_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Y man ibanon ta leer rix ri nu'ij chupan ri ley ri xyo'ox che ri Moisés? Chiri' nu'ij chi ri sacerdotes israelitas nic'atzin yesamaj pa racho ri Dios chupan ri sábado ri xa k'ij richin uxlanen, y ri' man mac ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero vacami, rix nitz'et Jun ri más c'o ruk'ij que chuvech ri racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Y rix man ta xi'ij chi ri nu-discípulos mac ri yetajin, xa ta iveteman achique nu'ij tzij ri tz'iban can ri nu'ij: Yin ninjo' chi rix yixpokonan, y mani ye'icamisaj chicop chinuvech. ");
INSERT INTO cak_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Quiri' nin-ij chive, roma ri Rajaf ri sábado ri k'ij richin uxlanen, ja yin ri xitak-pe richin xinalex chi'icojol, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Tok ri Jesús xel-pe chupan ri juyu' ri c'o-vi ri trigo, xbe pa qui-sinagoga ri aj chiri'. ");
INSERT INTO cak_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chiquicojol ri quimolon-qui' chiri', c'o jun ri caminak jun ruk'a', y ri fariseos quire' xquic'utuj-apu che ri Jesús: ¿Utz cami nic'achojrises jun vinak pa jun sábado ri k'ij richin uxlanen? xecha'. Quiri' xquic'utuj-apu, xaxe roma nicajo' niquisujuj. ");
INSERT INTO cak_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jac'a ri Jesús xu'ij chique: Si jun chive rix c'o jun ru-oveja, y si pa jun sábado ri k'ij richin uxlanen nitzak-ka ri oveja pa jun jul, rija' man nuya' ta can richin chuca'n k'ij, xa nuq'uen-ka ri oveja pa jul richin nrelesaj-pe. ");
INSERT INTO cak_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Y jun vinak más c'o rakale'n que chuvech jun oveja, y romari' can ruyuken-vi-ri' riq'uin ru-ley ri Dios chi ni'an favor che jun vinak chupan ri sábado ri k'ij richin uxlanen. ");
INSERT INTO cak_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jac'ari' tok ri Jesús xu'ij che ri caminak ruk'a': Tayuku' la ak'a', xcha'. Ja c'a xuyuk ri ruk'a', xc'achojrises, xcanaj can achel ri jun chic ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Tok xe'el yan e ri achi'a' fariseos chiri', xequimolo-qui' richin niquinojij achique niqui'en richin niquicamisaj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús reteman ri niquinojij chirij, romari' xel-e chiri', y eq'uiy xetzekle'en-e richin. Y conojel ri yeyavej nu'on chique chi yec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero yerupaxa'aj-e chi man tiquiya' rutzijol chi ja rija' ri yec'achojrisan riq'uin ri quiyabil. ");
INSERT INTO cak_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Riq'uin ri quiri' xu'ij ri Jesús, xbanataj ri k'alajrisan can chuvech ri profeta Isaías ri quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jare' ri Nusamajinel ri nucha'on. Yin ninjo' rija', y niquicot vánima riq'uin. Y xtinya-pe ri nu-Espíritu pa ruvi'; Y rija' xtuc'ut ri chojmilaj bey richin ri Dios chiquivech ri man israelitas ta. ");
INSERT INTO cak_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man jun bey (xtich'ojin, xtich'ojoquin), ni man xtisiq'uin ta, Ni man xtutzijoj ta ri' chiquivech ri vinak pa tak bey. ");
INSERT INTO cak_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Si ruc'aslen jun vinak paxnak chic achel jun aj, rija' man xtuk'aj ta ka jumul. Y si achel jun k'ak' boxon ri xaxe chic sib nu'on, rija' man xtuchup ta ka jumul. Quiri' xtu'on-apu c'a jampe xtu'on chi ja ri choj ri xtitakchi'in pa quivi' ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri man israelitas ta, tok xtiquic'axaj ri utzulaj nuch'abel ri xtutzijoj rija' chique, xtiquiya' cánima riq'uin. Quiri' ri ruk'alajrisan can ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jac'ari' xuc'uax-apu chuvech ri Jesús jun ri man nich'o ta ni man nitzu'un ta roma ocunak itzel espíritu riq'uin, y ri Jesús xu'on che chi xc'achoj, y romari' xtiquer xtzu'un y xch'o. ");
INSERT INTO cak_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Conojel ri vinak xsatz quic'u'x tok xquitz'et y quire' niquibila' chirij ri Jesús: ¿Mana-ta cami re' ri jun riy-rumam ri David ri bin can chi nipe? yecha'. ");
INSERT INTO cak_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Jac'a ri achi'a' fariseos tok xquic'axaj ri niqui'ij ri vinak, quire' xqui'ij chirij ri Jesús: Rija' yerelesaj itzel tak espíritu, pero xa ja ri Beelzebú ri cajaf ri itzel tak espíritu niyo'on ruchuk'a' richin yerelesaj, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero ri Jesús reteman ri niquinojij, y romari' xu'ij chique: Xa achique na jun rey ri nicataj chiquij ri mismo ruvinak, man juba' xtilayoj chi rey. Y xa achique na tinamit o jay, si ri ec'o chupan xa niquibanala-ka oyoval chiquivech, xtijachataj-e quivech. ");
INSERT INTO cak_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Si ri Satanás yerelesaj-e ri rusamajela', xa chirij rija' mismo catajnak-vi. Y si quiri' nu'on, man juba' xtilayoj ri ru-gobierno. ");
INSERT INTO cak_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Y si yin riq'uin ruchuk'a' ri Beelzebú yenvelesaj-vi itzel tak espíritu achel ri ninojij rix, ¿achique niyo'on cuchuk'a' ri yetzekle'en ivichin rix chi yequelesaj itzel tak espíritu? Romari' ja rije' que'in si kitzij o man kitzij ta ri yixtajin chubixic chuvij. ");
INSERT INTO cak_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Si yin riq'uin ru-Espíritu ri Dios yenvelesaj-vi itzel tak espíritu, jari' retal chi ri ru-gobierno ri Dios c'o chic chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ninya' na pe jun ejemplo chivech. Tok c'o jun rajaf-jay ri jani na ruchuk'a', y c'o jun nrojo' nelak'-e pa racho, nic'atzin chi na'ey nuxim ri rajaf-jay, y c'ajari' c'o che'el nuq'uen-e ronojel ri nrojo'. ");
INSERT INTO cak_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jun ri man nika ta chuvech ri nin-en yin, xa itzel yirutz'et. Y ri man nimolon ta viq'uin yin, xa niquiran-e. ");
INSERT INTO cak_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Romari' yin nin-ij chive: Ronojel ruvech mac y ronojel yok'onic tak tzij ri yequibila' ri vinak, can c'a ye'an na perdonar ri ebiyon richin. Jac'a ri ye'in yok'onic tak tzij chirij ri Lok'olaj Espíritu man xque'an ta perdonar. ");
INSERT INTO cak_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Xa achique na ri ni'in jun tzij chuvij yin ri xitak-pe richin xinalex chi'icojol, c'a ni'an na perdonar. Jac'a ri ni'in xa achique na tzij chirij ri Lok'olaj Espíritu, man xti'an ta perdonar ri vacami, y nis-ta chupan ri jun chic tiempo chikavech apu. ");
INSERT INTO cak_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Rix pa ruchojmil ti'ij ri achique nitz'et viq'uin yin, achel ni'en riq'uin jun che', yixtiquer ni'ij si utz o man utz ta riq'uin ri ruvech ri nuya'. ");
INSERT INTO cak_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Rix ri rix achel cumatz, ¿achel xquixtiquer xti'ij ri utz, tok xa ivichin vi chi man rix utz ta? Roma ja ri achique nojnak pa ránima ri vinak ri ye'el pa ruchi'. ");
INSERT INTO cak_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun vinak utz, ja ri utz ri ruyacon pa ránima ri nu'ij. Jac'a ri vinak itzel ruc'aslen, ja ri itzel ri ruyacon pa ránima ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Jac'a yin nin-ij chive chi tok xtuka ri k'ij chi xtinic'ox ronojel ch'utik-nima'k, ri xequibila' tzij ri man jun yec'atzin-vi, can xtequijacha' cuenta roma ri xequibila'. ");
INSERT INTO cak_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Quiri' nin-ij chive, roma ja mismo ri ch'abel ri nibila' rix vave' choch'ulef, jari' ri xtic'atzin-ka chivij, richin xti'ix chi choj ri xi'en, o chi xquixtak pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","C'o c'a chique ri achi'a' q'uiy queteman chirij ri ley y chique ri fariseos ri quire' xqui'ij-apu che ri Jesús: Tijonel, roj nikajo' nikatz'et chi rat na'an jun milagro chikavech, xecha-apu che. ");
INSERT INTO cak_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero ri Jesús quire' xu'ij chique: Ri vinak itzel cánima y man niquinimaj ta ri Dios, niquitij quik'ij niquic'utuj chi ti'an jun milagro chiquivech, pero mana-ta ri niquic'utuj rije' ri xtibanataj. Ri retal ri xtiquitz'et xaxe ri achel xbanataj riq'uin ri profeta Jonás ojer can. ");
INSERT INTO cak_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Roma achel xc'uje' ri Jonás chupan jun mama quer oxi' k'ij y oxi' ak'a', quiri' mismo yin ri xitak-pe richin xinalex chi'icojol, xquic'uje' oxi' k'ij y oxi' ak'a' pa ruc'u'x ri ulef. ");
INSERT INTO cak_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y tok xtinic'ox ronojel ch'utik-nima'k, ri achi'a' aj-Nínive xquecataj-apu richin xtiqui'ij chi tika castigo pa quivi' ri vinak ri ec'o vacami. Roma ri xec'uje' pa tinamit Nínive ojer, xe xquic'axaj ruch'abel ri Dios ri xutzijoj ri Jonás, ja xquijal quino'oj y xquiya' can ri quimac. Jac'a ri vacami yinc'o yin ri más c'o nuk'ij que chuvech ri Jonás, y man yinquinimaj ta ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tok xtinic'ox ronojel ch'utik-nima'k, xticataj-apu ri jun reina ri xu'on gobernar pa roch'ulef Sabá richin xtu'ij-apu chi tika castigo pa quivi' ri vinak ri ec'o vacami. Roma ri reina ri' tok xc'ase' choch'ulef, chi naj xpe-vi richin xurac'axaj vave' pan Israel ri nimalaj no'oj ri yo'on che ri rey Salomón. Jac'a ri vacami yinc'o yin ri más c'o nuk'ij que chuvech ri rey Salomón, y man yinquinimaj ta ri vinak, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tok jun itzel espíritu ntel-e pa ránima jun vinak, nixule-nijote' chucanoxic uxlanen pa chaki'j tak lugar, pero roma man nril ta, ");
INSERT INTO cak_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","quire' nu'ij-ka: Más utz yitzolij chic pa ránima ri vinak ri xinel-vi-pe, nicha'. Tok nitzolij, nril ránima ri vinak achel jun jay ri manak rajaf, jabel meson y nuc'un can ronojel. ");
INSERT INTO cak_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Jac'ari' ni'e y ye'eruc'ama' vuku' chic itzel tak espíritu más e'itzel chuvech rija'. Conojel re' ye'oc pa ránima ri vinak y niqui'en-ka cacho chiri', y ri ruc'aslen ri vinak ri' más c'ayef nu'on que chuvech ri rubanon na'ey. Quiri' xtibanataj quiq'uin ri vinak itzel quic'aslen ri ec'o vacami. ");
INSERT INTO cak_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Tok ri Jesús c'a nich'o na quiq'uin ri vinak chiri', ri rute' y ri eruchak' ec'o-e chojay roma nicajo' yech'o riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Jari' tok c'o jun x-in-apu che ri Jesús: Ri ate' y ri e'achak' ec'o chojay, y nicajo' yech'o aviq'uin, xcha-apu che. ");
INSERT INTO cak_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero ri Jesús quire' xu'ij che ri x-in-apu quiri': ¿Achique c'a ri nte' y ri enchak' nanojij rat? ");
INSERT INTO cak_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y riq'uin c'a ruk'a' xeruc'ut ri ru-discípulos y xu'ij: Jare' ri nte' y ri enchak'. ");
INSERT INTO cak_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Roma xa achique na jun nibano ri nurayij ri Nata' chicaj, jari' ri nte', vana' y nchak', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ri k'ij ri' xel-e ri Jesús pa jay, y xbetz'uye' chuchi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Jari' tok jani na q'uiy vinak xquimol-apu-qui' riq'uin, romari' xoc-apu pa jun canoa y chiri' xtz'uye-vi, jac'a ri quimolon-apu-qui' epa'el-apu chuchi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Rija' jalajoj xu'ij chique riq'uin ejemplos, y jun ri xu'ij jare': C'o jun ticonel xbe chuquiraxic semilla. ");
INSERT INTO cak_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tok ja nuquiraj chiri', c'o che ri semilla xeka pa bey, y xepe ri chicop c'o quixic', xquitij-e ri semilla. ");
INSERT INTO cak_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","C'o ch'aka' che ri semilla xeka chiquicojol tak abaj, y roma chiri' man pin ta ulef c'o, xa cha'anin xe'el-pe roma man naj ta xec'uje-vi-ka ri semilla. ");
INSERT INTO cak_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Jac'a tok xel-pe ri k'ij y xpe ruchuk'a', ri ch'utik tico'n xec'at chuvech, y xechakij-ka roma manak ni'e-vi-ka ri quixe'. ");
INSERT INTO cak_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ch'aka' che ri semilla xeka achique lugar ye'el-pe q'uix, y junan xe'el-pe quiq'uin. Pero ri q'uix más cha'anin xeq'uiy, y ri ch'utik tico'n xek'aner-ka chucojol. ");
INSERT INTO cak_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero c'o che ri semilla xeka pa ruch'acul ri ulef. C'o xquiya' a cien, c'o xquiya' a sesenta y c'o xquiya' a treinta. ");
INSERT INTO cak_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jac'ari' tok ri discípulos xejel-apu riq'uin ri Jesús y xquic'utuj che: ¿Achique roma riq'uin ejemplos yach'o-vi chiquivech ri vinak? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xu'ij: Roma chive rix yo'on lugar chi nivetemaj ri man can ta ojer ri' k'alajrisan can chirij ri aj-chicaj gobierno. Jac'a rije', man yo'on ta lugar chique. ");
INSERT INTO cak_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Roma xa achique na ri c'o chic c'o riq'uin, xtiyo'ox más che, richin quiri' nic'uje' más riq'uin. Pero ri man jun c'o riq'uin, hasta ri juba' c'o riq'uin xteleses che. ");
INSERT INTO cak_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa romari' tok yin yencusaj ejemplos richin yich'o quiq'uin, roma rije' masque niquitz'et ri najin chiquivech, pero xa achel man yetzu'un ta, y masque niquic'axaj ri ni'ix chique, pero xa man (nik'ax, nino') ta chiquivech. ");
INSERT INTO cak_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Pa cánima ri vinak re' najin-vi ri rutz'iban can ri profeta Isaías ojer, ri quire' nu'ij: Rix xaxe choj xtivac'axaj ri ni'ix chive y man (xtik'ax, xtino') ta chivech. Xtitz'et ri najin chivech, pero xa man xtiya' ta pa cuenta. ");
INSERT INTO cak_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Roma ri cánima ri vinak re' xcovir. C'ayef ntoc pa quixiquin ri niquic'axaj. Quiyupun runak'-quivech Roma man nicajo' ta yetzu'un, Man nicajo' ta niquic'axaj, Richin ntoc pa tak cánima, Nis-ta nicajo' niquijal quino'oj, Richin chi yin ninchojmirisaj ri quic'aslen. Quiri' nu'ij ruch'abel ri Dios ri rutz'iban can ri Isaías, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jac'a rix nu-discípulos, utzulaj tzij banon che ri ivech, roma yixtiquer nitz'et ri najin chivech y utzulaj tzij banon che ri ixiquin, roma (nik'ax, nino') chivech ri nivac'axaj. ");
INSERT INTO cak_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Roma yin kitzij nin-ij chive chi q'uiy profetas y vinak choj quic'aslen ojer ri xcajo' xquitz'et ri nitz'et rix vacami, y man xquitz'et ta e. Xcajo' xquic'axaj-e ri nivac'axaj rix vacami, y man xquic'axaj ta e. ");
INSERT INTO cak_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Roma c'a ri', rix tivac'axaj achique nu'ij tzij ri ejemplo pa ruvi' ri ticonel. ");
INSERT INTO cak_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tok jun vinak nrac'axaj ri ch'abel ri nik'alajrisan ri ru-gobierno ri Ajaf Dios, y man (nik'ax, nino') ta chuvech, nipe ri itzel y nrelesaj-e ri ticon can pa ránima. Jari' ri semilla ri xka pa bey. ");
INSERT INTO cak_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri semilla ri xeka chiquicojol tak abaj, nich'o pa ruvi' ri vinak ri nrac'axaj ruch'abel ri Dios y can niquicot nuc'ul, ");
INSERT INTO cak_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","pero man nuq'uen ta ka ruvech pa ránima, xa juba' oc k'ij nuya' ránima riq'uin ri Dios, roma tok niyo'ox pa k'axomal o pa pokonal roma runiman ruch'abel ri Dios, xa cha'anin nril jun roma chi nuxutuj can ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ri semilla ri xeka chiquicojol tak q'uix, jari' nu'ij tzij chi ec'o ye'ac'axan ruch'abel ri Dios, pero xa roma ni'e cánima pa ruvi' ri roch'ulef, y roma yesatz pa ruvi' ri beyomal, jari' nibano chi nijik' ri ruch'abel ri Dios, y man jun samaj nu'on pa cánima. ");
INSERT INTO cak_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jac'a ri semilla ri xeka pa ruch'acul ri ulef nich'o pa ruvi' ri nac'axan ruch'abel ri Dios y (nik'ax, nino') chuvech, y pa ruc'aslen can c'o utz nik'alajin, achel ruvech ri tico'n ri c'o nuya' a cien, c'o nuya' a sesenta y c'o nuya' a treinta, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Xutzijoj chic jun ejemplo ri Jesús chiquivech, y quire' xu'ij: Ri nibanataj chupan ri aj-chicaj gobierno junan riq'uin ri xbanataj riq'uin jun ticonel ri xutic utzulaj ruvech semilla pa rujuyu'. ");
INSERT INTO cak_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Jac'a tok xril hora richin varan, chupan ri tico'n xoc jun ri royoval che rajaf ri juyu', xerutica' c'a can (rucavach, ruq'uexevach) trigo chucojol ri kitzij trigo, y ja xbe. ");
INSERT INTO cak_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tok xq'uiy-pe ri trigo y xe'el-pe quitza'n, c'ajari' xk'alajin-pe ri man kitzij ta trigo chucojol. ");
INSERT INTO cak_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Xepe c'a ri rusamajela' rajaf ri juyu' y xqui'ij che: Ajaf, junan na c'a ruvech ri semilla ri xatic-ka. Pero, ¿achel chi c'o ri man kitzij ta trigo chucojol? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Jac'a rija' quire' xu'ij chique: Re' rusamaj jun ri royoval chuve, xcha'. Y ri rusamajela' xqui'ij: ¿Najo' chi nku'e chuc'ukic? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Y rija' xu'ij chique: Quiri' tubana', man xa chuc'ukic ri man kitzij ta trigo, ja jun ri trigo xquec'ukutaj-pe. ");
INSERT INTO cak_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Más utz tiya' lugar chi junan yeq'uiy riq'uin ri trigo, c'a terila' na ri k'ij richin ri k'atoj. Tok xti'an ri k'atoj, yin xtin-ij chique ri yek'aton chi na'ey tiquimolo' ruchi' ri man kitzij ta trigo, y quequibana' pa tak manojo richin yeporox; jac'a ri trigo tiquimolo' richin niyac, xcha' rajaf ri juyu'. Quiri' ri ejemplo ri xu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xutzijoj chic jun ejemplo chiquivech, y quire' xu'ij: Ri aj-chicaj gobierno achel jun ch'uti ruvech ru-semilla mostaza ri nerutica' jun ticonel pa rujuyu'. ");
INSERT INTO cak_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Masque ja semilla ri' ri más co'ol oc chiquivech ronojel quivech semilla, pero tok niq'uiy, más (nim, tij) ntel chiquivech ronojel quivech tico'n, juba' ma ne'oc achel che', y hasta ri chicop c'o quixic' niqui'en quisoc chuk'a', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xutzijoj chic jun ejemplo chiquivech, y quire' xu'ij: Ri aj-chicaj gobierno junan riq'uin ri levadura ri neruc'ama-pe jun ixok y nuyok' chucojol oxi' medida harina richin nuquiraj-ri' chupan ronojel, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ronojel re' riq'uin ejemplos xutzijoj-vi ri Jesús chique ri vinak. Man jun achique xutzijoj ri man ta xucusaj ejemplos richin xch'o chiquivech, ");
INSERT INTO cak_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","richin quiri' nibanataj ri ru'in can jun chique ri profetas ojer, ri quire' xu'ij: Yin riq'uin ejemplos xquich'o-vi chiquivech ri vinak. Q'uiy ri man eteman ta ruchojmil xe tok x-an ri roch'ulef, xtinc'ut ruchojmil. Quiri' nu'ij chupan ri tz'iban can, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Tok ri Jesús xch'o yan can chique ri vinak, rija' xtzolij chic ri pa jay. Xejel c'a apu ri ru-discípulos riq'uin y quire' xqui'ij che: Ta'ij chike achique nu'ij tzij ri ejemplo chirij ri (rucavach, ruq'uexevach) ri trigo ri xel-pe chucojol ri kitzij trigo ri pa juyu', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús quire' xu'ij chique: Ri ticonel richin ri utzulaj semilla, ja yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri juyu' ri x-an-vi ri ticoj, ja ri roch'ulef. Ri utzulaj semilla ja ri ye'oc ruvinak ri ru-gobierno ri Ajaf Dios. Y ri man kitzij ta chi trigo, ja ri vinak ri erichin ri itzel. ");
INSERT INTO cak_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri royoval che ri rajaf ri juyu' ri xtico can ri man kitzij ta chi trigo, ja ri itzel. Ri k'atoj, ja ri xtibanataj pa ruq'uisbel ri tiempo ri rojc'o-vi; y ri yek'aton, ja ri ángeles. ");
INSERT INTO cak_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Y achel ni'an che ri man kitzij ta chi trigo, yec'uk-e y yeporox pa k'ak', quiri' mismo xtibanataj pa ruq'uisbel che ri tiempo ri rojc'o-vi. ");
INSERT INTO cak_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yin ri xitak-pe richin xinalex chi'icojol xquentak ri nu-ángeles richin xquequelesaj-e pa nu-gobierno conojel ri xaxe richin yequitzak ch'aka' chic yec'atzin, y quiri' mismo conojel ri ebanoy mac. ");
INSERT INTO cak_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Conojel ri xque'eleses-e, xque'ec'ak chupan ri nimalaj k'ak' ri achel jun horno. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jac'a ri xquic'uaj jun c'aslen choj, can xquetz'intz'ot achel ri k'ij pa ru-gobierno ri Quitata' Dios. Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij. ");
INSERT INTO cak_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri aj-chicaj gobierno achel jun beyomal mukul can pa jun juyu' ri nril jun vinak. Ri nilo richin ri beyomal, nrevaj chic can jun bey, y niquicot ránima neruc'ayij ronojel ri c'o riq'uin y nulok' c'a ri juyu' ri evan-vi ri beyomal. ");
INSERT INTO cak_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri aj-chicaj gobierno achel jun c'ayiy y lok'oy perlas ri yerucanoj utzulaj tak perlas. ");
INSERT INTO cak_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Rija' tok nril jun perla más utz chuvech ri erilon chic, ni'e chuc'ayixic ronojel ri c'o riq'uin richin nulok' ri perla ri'. ");
INSERT INTO cak_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","(Chuka', ka) ri aj-chicaj gobierno junan riq'uin jun ya'l ri yo'on-ka pa ya', roma ronojel quivech quer niquiya-pe-qui' chupan. ");
INSERT INTO cak_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Tok ninoj ri ya'l riq'uin quer, ri samajela' niquelesaj-e chuchi' ri ya', y yetz'uye' c'a richin yequicha'. Ri utz chi yetij, yequiya' pa tak chaquech, y ri man utz ta, yequitorij can. ");
INSERT INTO cak_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quiri' ri xtibanataj chupan ri ruq'uisbel che ri tiempo. Ri ángeles xque'el richin yequelesaj ri man utz ta quic'aslen chiquicojol ri choj quic'aslen. ");
INSERT INTO cak_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ri man utz ta quic'aslen, xquequic'ak chupan ri nimalaj k'ak' ri achel jun horno. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri Jesús xu'ij chique ri ru-discípulos: ¿(Xk'ax, xno') chivech ronojel re xin-ij? xcha'. Y ri discípulos xqui'ij: Ja', Ajaf, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Y ri Jesús xu'ij c'a chique: Riq'uin ri (xk'ax, xno') chivech, yin nin-ij chive chi conojel ri q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, y quitijon-qui' chirij ruchojmil ri aj-chicaj gobierno, rije' ejunan riq'uin jun tata'aj ri chucojol rubeyomal nrelesaj-vi-pe ri c'ate ruyacon y ri c'o chic chi tiempo ruyacon. ");
INSERT INTO cak_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Tok ri Jesús xuq'uis rubixic ri ejemplos, xel-pe chiri'. ");
INSERT INTO cak_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tok c'o chic pa tinamit ri xq'uiy-vi, rija' xerutijoj ri niquimol-qui' ri pa qui-sinagoga. Y roma ri ch'abel ri yeru'ij chique, can achique na xquina', y quire' niqui'ij: ¿Achique c'a lugar petenak-vi ri utzulaj no'oj ri c'o riq'uin y ri uchuk'a' richin nu'on milagros? ");
INSERT INTO cak_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Rija' xa ruc'ajol ri jun achi samajiy-che'. Ri rute' rubinan María, ri eruchak' ja ri Jacobo, ri José, ri Simón y ri Judas. ");
INSERT INTO cak_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ri rana' xa vave' chikacojol ec'o-vi. ¿Achique c'a lugar petenak-vi ronojel ri yerubanala'? yecha' chiquivech. ");
INSERT INTO cak_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y ri vinak man xquiya' ta pa cuenta ri Jesús. Pero rija' xu'ij chique: Nis-ta jun profeta ri man ta niyo'ox ruk'ij, pero man coma ta ri aj-rutinamit, ni man coma ta ri aj pa racho, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y ri Jesús man q'uiy ta milagros xu'on ri pa rutinamit, roma ri ruvinak man niquinimaj ta (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupan ri tiempo ri', ri Herodes ri nibano gobernar ri rucaj parte richin ri roch'ulef ri c'o-vi, xrac'axaj chi ri Jesús can q'uiy rutzijol chiquicojol ri vinak, ");
INSERT INTO cak_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","y quire' xu'ij chique ri rusamajela': Ri achi ri ni'ix Jesús che, xa ja ri Juan ri Bautista xc'astaj-pe chiquicojol ri anima'i', y romari' ocunak nimalaj uchuk'a' riq'uin richin nitiquer yerubanala' milagros, xcha' ri Herodes. ");
INSERT INTO cak_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Quiri' nu'ij ri rey Herodes, roma ja rija' x-in chi (xtz'am, xchap) ri Juan, xxim pa cadena y xyo'ox pa cárcel. Quiri' xu'on ri Herodes, roma ri Juan ru'in che chi man juba' utz chuvech ru-ley ri Dios chi rubanon-ka rixayil che ri Herodías, rixayil ri Felipe ri mismo runimal ri Herodes. ");
INSERT INTO cak_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Chupan ri tiempo ri' ri Herodes xrojo' chi xucamisaj ri Juan, pero xa nuxi'ij-ri' chiquivech ri tinamit, roma chiquivech rije' ri Juan ri Bautista can profeta vi richin ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Jac'a tok ri Herodes xuq'uis chic jun rujuna', c'o jun nimak'ij x-an, y ri xten ral ri Herodías xxojo chiquivech conojel ri ec'o-apu chiri', y ri Herodes can xka chuvech. ");
INSERT INTO cak_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Romari' can xuya' rutzij che ri xten chi xa achique na nuc'utuj, can xtuya-vi che. ");
INSERT INTO cak_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jac'a tok ri xten yo'on chic pe runo'oj roma ri rute', rija' quire' xu'ij che ri Herodes: Yin ninjo' chi naya-pe chinuvech pa jun plato (rujolon, ruvi') ri Juan ri Bautista, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tok xrac'axaj quiri', ri rey Herodes xpe bis pa ránima, pero roma ruyo'on chic rutzij che, y can chiquivech ri ec'o-apu riq'uin chuchi' mesa ru'in-vi, romari' xu'ij chi tiyo'ox che ri xten ri achique xuc'utuj. ");
INSERT INTO cak_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutak c'a rucumic (rujolon, ruvi') ri Juan ri Bautista pa cárcel. ");
INSERT INTO cak_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Xyo'ox c'a pe pa jun plato, xc'an-pe che ri xten, y ri xten xberuya' che ri rute'. ");
INSERT INTO cak_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","(Xe'apon, xe'ebos) c'a ru-discípulos ri Juan ri Bautista, xequic'ama' ri ru-cuerpo y xquimuk. Y xequi'ij che ri Jesús ronojel ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tok ri Jesús xrac'axaj ri xbanataj, rija' xoc-e pa jun canoa richin xbe pa jun lugar manak vinak, richin nic'uje' ruyon. Jac'a tok ri vinak xquina'ej, chicakan xe'el-vi-e ri pa tak tinamit richin xbequila'. ");
INSERT INTO cak_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y tok ri Jesús xel-pe ri pa canoa, xutz'et chi eq'uiy vinak coyo'en. Rija' xupokonaj quivech, y xu'on chi xec'achoj ri yeyavej chiquicojol. ");
INSERT INTO cak_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tok ja xk'ak'ij-ka chiri', ri ru-discípulos xejel-apu riq'uin y xqui'ij che: Ri rojc'o-vi xa manak vinak y ja xk'ak'ij-ka, romari' más utz ye'atak-e ri vinak pa tak aldeas richin nequilok'o' achique niquitij, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero ri Jesús xu'ij chique ri ru-discípulos: Man nic'atzin ta chi c'a yebe na, ja rix quixtzuku quichin, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Jac'a ri discípulos xqui'ij: Roj xaxe vo'o' pan y ca'i' quer c'o kiq'uin, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Y ri Jesús xu'ij chique: Tic'ama-pe vave'. ");
INSERT INTO cak_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jac'ari' xu'ij chi quetz'uye' conojel ri vinak chosabána; y xeruli'ej c'a ri vo'o' pan y ri ca'i' quer, xtzu'un c'a e chicaj y xumatioxij che ri Dios, xeruper c'a ri quer y ri pan, y jari' xuya-e chique ri ru-discípulos y ri discípulos xquiyala' chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Conojel xeva' y jabel xnoj quipan, y xquimol ri ruchi' tak pan y ri quer ri man xq'uis ta, y c'a xnoj na doce chaquech. ");
INSERT INTO cak_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ri xeva', jun cami vo'o' mil achi'a', jac'a ri ixoki' y ri ac'ola' man xe'ajlex ta. ");
INSERT INTO cak_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ri Jesús xerucusaj-e ri ru-discípulos chupan ri canoa y xu'ij-e chique chi quek'ax-apu juc'an ruchi' ri lago richin quenabeyaj-e chuvech, chupan chi rija' c'a nich'o na can chique ri vinak richin yerutak-e chi tak cacho. ");
INSERT INTO cak_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tok xerutak yan can chi tak cacho, rija' ruyon xjote-e chuvech jun juyu' richin nerubana' orar. Y tok xoc-pe ri ak'a', c'a chiri' na c'o-vi ruyon. ");
INSERT INTO cak_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Jac'a ri canoa ri ebenak-vi ri discípulos pa nic'aj chic ya' c'o-vi-apu, pero roma nibolko't ri ya', man nuya' ta lugar che ri canoa chi choj nibin, roma ri cak'ik' nurutz'ajij-ri' chuvech. ");
INSERT INTO cak_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jac'a chupan ri rucaj parte richin ri ak'a', ri Jesús nibin chirakan pa ruvi' ri ya' benak-apu quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jac'a ri ru-discípulos tok xquitz'et chi c'o jun nibin chirakan pa ruvi' ri ya', xquixi'ij-qui' y xqui'ij: ¡La' jun xibinel! xecha'. Riq'uin cuchuk'a' xesiq'uin roma quixi'in-qui'. ");
INSERT INTO cak_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ri Jesús cha'anin xch'o-pe chique, y xu'ij: ¡Ticovij-ivi'; man tixi'ij-ivi'! Xa ja yin, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jac'ari' tok ri Pedro quire' xu'ij-apu che ri Jesús: Ajaf, si ja rat, tabana' chi yin yibin pa ruvi' ri ya' yi'e-apu aviq'uin, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Ajaf xu'ij-pe che: Catampe c'a. Jac'ari' xel-e ri Pedro ri pa canoa, ja nibin pa ruvi' ri ya' xbe-apu riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero tok xutz'et chi jani na ruchuk'a' ri cak'ik', más xuxi'ij-pe-ri'. Rija' xuna' chi ja ni'e-ka chuxe' ri ya', y riq'uin c'a ruchuk'a' xu'ij: ¡Ajaf, quinacolo'! ");
INSERT INTO cak_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jari' tok ri Jesús (xutz'om, xuchop) ri Pedro y xu'ij che: ¡Pedro, rat man can ta cukul ac'u'x viq'uin! ¿Achique roma caca' ac'u'x xa'an-ka? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tok rije' ejotol chic e ri pa canoa, ri cak'ik' xtane-ka. ");
INSERT INTO cak_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jac'ari' tok ri ebenak pa canoa xquiya' ruk'ij ri Jesús y xqui'ij che: Can kitzij na vi chi ja rat ri Ruc'ajol ri Dios, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tok quik'asan chic ruvi' ri ya', xebe'el pa Genesaret. ");
INSERT INTO cak_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y tok ri achi'a' aj chiri' xquetemaj ruvech ri Jesús, xquelesaj rutzijol ri pa tak lugar ri ec'o-pe chunakaj ri quitinamit, y ri vinak xequic'amala-pe conojel ri yeyavej ri ec'o quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Niquic'utula' favor che ri Jesús, chi tuya' lugar chique ri yeyavej chi masque xaxe juba' ruchi' ri rutziak (niquitz'om, niquichop) apu. Y conojel ri (yetz'amo, yechapo) apu, yec'achoj riq'uin ri quiyabil. ");
INSERT INTO cak_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ec'o c'a achi'a' fariseos, y ca'i-oxi' achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, ri epetenak pa tinamit Jerusalem xejel-apu riq'uin ri Jesús, y xquic'utuj che: ");
INSERT INTO cak_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Achique roma ri a-discípulos man niquinimaj ta ri qui'in can ri nimalaj tak kamama'? Roma tok yeva', man niqui'en ta ri ch'ajoj k'a' achel qui'in can ri kamama', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jac'a ri Jesús quire' xu'ij chique: Y rix, ¿achique roma nik'aj ru-mandamiento ri Dios riq'uin ni'en ri quic'utun can ri imama' ojer? ");
INSERT INTO cak_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Roma quire' ru'in can ri Dios chi ti'an: Taya' quik'ij ri ate-atata', y ri itzel nich'o chirij rute' o rutata', man roma chic q'ues, xa ticamises. Quiri' ru'in can ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Jac'a rix xa quire' nic'ut chiquivech ri vinak: Vacami quire' ti'ij che ri ite' o che ri itata': Yin man yitiquer ta chic yixinto' roma ri nuchajin ri c'o ta che'el yixinto' che, xa nusujun chic che ri Dios. Quiri' ni'ij rix chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Junan nu'ij chi rix ni'ij chique chi man tiquiya' chic quik'ij quite-quitata'. Y riq'uin ri', xa iyo'on can juc'an ri ru-mandamiento ri Dios, riq'uin ni'en ri achel quic'utun can ri imama' ojer. ");
INSERT INTO cak_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Rix xa ca'i' rupalaj ri itzij. Can pa ruchojmil ri ru'in can ri profeta Isaías chivij chupan ri rutz'iban can ri quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ri vinak re' xaxe riq'uin quichi' niquiya-vi nuk'ij, Jac'a ri cánima naj c'o-vi-e viq'uin. ");
INSERT INTO cak_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Man jun nic'atzin-vi chi niquiya' nuk'ij, Roma xa yepaxa'an riq'uin quitzij vinak y niqui'ij chi jari' ri nic'atzin chi ni'an. Quiri' rutz'iban can ri Isaías, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jac'ari' xeroyoj-apu ri quimolon-qui' chiri', y xu'ij chique: Tivac'axaj c'a ri xtin-ij y (tik'ax, tino') chivech. ");
INSERT INTO cak_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mana-ta ri achique ntoc pa ruchi' jun vinak ri nibano chi man ch'ajch'oj ta chuvech ri Dios, xa ja ri ch'abel ri ye'el pa ruchi' ri nibano, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Xejel c'a apu ri ru-discípulos riq'uin, y xqui'ij che: Ri fariseos xa xpe coyoval tok xquic'axaj ri xa'ij, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero rija' xu'ij chique: Ri niquic'ut ri fariseos, xa achel jun tico'n, pero ronojel tico'n ri mana-ta ri Nata' chicaj tiquiyon, xa xtic'uk-e. ");
INSERT INTO cak_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xa que'iya' can quila'. Roma rije' achel man yetzu'un ta, equiyuken chiquik'a' vinak ri mismo achel rije'. Y si c'o jun man nitzu'un ta nuyukej-e chuk'a' jun chic mismo man nitzu'un ta, chi ca'i' ye'etzak pa jul, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jari' tok ri Pedro quire' xu'ij-apu che ri Jesús: Ta'ij chike achique ruchojmil ri jun ejemplo re', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xu'ij: ¿Ja jun rix man jani quixcovin tivetemaj ruchojmil ri achique nin-ij? ");
INSERT INTO cak_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man iveteman ta chi ri achique yerutij jun vinak, xa chupan ni'e-vi-ka y xa ntel chic can? ");
INSERT INTO cak_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero ri yerubila' jun vinak, can pa ránima ye'el-vi-pe, y jari' ri nibano chi man ch'ajch'oj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Roma pa ránima ntel-vi-pe chi yerunojij ri man utz ta, chi nicamisan, chi nic'uje' quiq'uin ri mana-ta achok riq'uin c'ulan-vi, chi nucusaj ri ru-cuerpo richin nic'uje' xa achok riq'uin na, chi nelak', y chi yerubanala' tz'ucun tak tzij y yok'onic tak tzij. ");
INSERT INTO cak_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ja ronojel re' nibano chi jun vinak man ch'ajch'oj ta chuvech ri Dios. Pero si man nuch'aj ta ruk'a' tok niva', ri' man nu'on ta che chi man ta ch'ajch'oj chuvech ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Tok ri Jesús xel-e chiri', xbe chupan ri lugar ri c'o-vi ri ca'i' tinamit Tiro y Sidón. ");
INSERT INTO cak_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y c'o c'a jun ixok man israelita ta ri elenak-pe chupan ri lugar ri benak-vi-apu ri Jesús ri xuruc'ulu' y riq'uin ruchuk'a' nuc'utula' favor che y nubila': ¡Ajaf, rat ri rat riy-rumam can ri rey David, tapokonaj nuvech! Roma ri val xten c'o jun itzel espíritu ocunak riq'uin, y jani na k'axomal nuk'asaj pa ruk'a', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ri Jesús man jun rutzolic rutzij xu'on ri ixok. Y ri discípulos xejel-apu riq'uin ri Jesús richin xquic'utuj favor che, y quire' xqui'ij: Ta'ij che ri ixok re' chi tic'uje' can, roma jani na nisiq'uin petenak chikij, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jac'a ri Jesús xu'ij: Yin xaxe quiq'uin ri kavinak israelitas ri e'achel ovejas esatznak can yin takon-vi-pe, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Pero ri ixok jari' xxuque-ka chirakan ri Jesús, y xu'ij che: ¡Ajaf, quinato'! xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jac'a ri Jesús xu'ij che ri ixok: Man utz ta chi ri pan quichin ri ac'ola' neleses chique richin niyo'ox chiquivech ch'utik tz'i', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero ri ixok xu'ij: Ajaf, can kitzij ri na'ij. Pero hasta ri ch'utik tz'i' niyo'ox lugar chique chi yequisic' ri ruchi' tak pan ri yetzak-ka chuxe' qui-mesa ri cajaf, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jari' tok ri Jesús xu'ij che ri ixok: Can k'alaj chi cukul ac'u'x viq'uin; tibanataj c'a ri achel najo', xcha'. Ja hora ri' xel-e ri itzel espíritu riq'uin ri xten. ");
INSERT INTO cak_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús xel-pe chupan ri lugar ri c'o-vi ri ca'i' tinamit Tiro y Sidón tzekle'en coma ri ru-discípulos. Xbe c'a chunakaj ri lago Galilea, y xjote-e pa ruvi' jun juyu' y chiri' xtz'uye-vi-ka. ");
INSERT INTO cak_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y eq'uiy ri xquimol-apu-qui' riq'uin equic'amon-apu ri man utz ta cakan, ri man yetzu'un ta, ri man yech'o ta, ri man utz ta quik'a', y ch'aka' chic más ri c'o jalajoj ruvech yabil quiq'uin. Conojel c'a re' xeyo'ox-apu chuvech ri Jesús y rija' xu'on chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Roma ri xu'on ri Jesús, ri ajani chi vinak ec'o-apu chiri', can achique na xquina'. Roma xquitz'et chi ri man yech'o ta rubanon can, vacami xa yech'o. Ri man utz ta quik'a', xec'achoj. Ri man utz ta cakan, vacami xa choj yebin. Ri man yetzu'un ta, yetzu'un chic. Romari' ri vinak can xquiya-vi ruk'ij ri Dios, ri qui-Dios ri israelitas. ");
INSERT INTO cak_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: Yin ninpokonaj quivech ri vinak re', roma ja oxi' k'ij ec'o-pe viq'uin y vacami manak chic niquitij. Y man ninjo' ta chi quicoch'on vayijal yentak-e chi tak cacho, roma riq'uin juba' xa xque'etukutu' pa tak bey, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jac'ari' quire' xqui'ij-apu ri discípulos che ri Jesús: Pa jun chakijlaj tz'iran ulef achel ri rojc'o-vi, ¿achique lugar xtekac'ama-vi-pe q'uiy pan richin yekatzuk conojel re'? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero ri Jesús xuc'utuj chique: ¿Ajani pan c'o iviq'uin? xcha'. Vuku' pan y ca'i-oxi' ch'utik quer, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xu'ij chique ri vinak chi quetz'uye' pan ulef. ");
INSERT INTO cak_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jac'ari' xeruli'ej ri vuku' pan y ri quer y xumatioxij che ri Dios. Xeruper c'a y xuyala-e chique ri ru-discípulos richin chi xquiyala' chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Conojel xeva' y jabel xnoj quipan. Y c'a xnoj na vuku' chaquech riq'uin ri ruchi' tak pan y ruchi' tak quer ri xemolotaj. ");
INSERT INTO cak_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","(Caji', quiji') mil achi'a' ri xeva' chiri'. Y nis-ta xe'ajlex ri ixoki' y ri ac'ola'. ");
INSERT INTO cak_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Tok ri Jesús erutakon chic can ri vinak chi tak cacho, xoc-e pa canoa y (xapon, xebos) chunakaj ri lugar ri c'o-vi ri tinamit Magdala. ");
INSERT INTO cak_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xepe c'a ri achi'a' fariseos y saduceos riq'uin ri Jesús richin niquicanoj achique ta niqui'en richin nika pa quik'a', y quire' xqui'ij che: Roj nikajo' chi can chikavech na'an-vi jun milagro chuvech ri rocaj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero ri Jesús xu'ij chique: Tok rix nitz'et ri rocaj nik'ak'ij chi quiek rubanon, rix ni'ij chi utz k'ij nerubana' chua'k. ");
INSERT INTO cak_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y tok nitz'et ri rocaj nisakar chi mukul y quiek rubanon, rix ni'ij chi camic job nipe. Yixtiquer ni'ij achique nerubana' ri k'ij. Jac'a ri najin chivech vacami, jun retal ri tiempo ri rojc'o-vi, y rix man juba' yixtiquer ni'ij achique nuq'uen-pe. Chiri' nic'ut-vi-ivi' chi xa choj nibananej chi rix uc'uay bey chuvech ri tinamit. ");
INSERT INTO cak_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri vinak itzel cánima y man niquinimaj ta ri Dios, niquitij quik'ij niquic'utuj chi ni'an jun milagro chiquivech, pero mana-ta ri niquic'utuj ri xtibanataj. Ri retal ri xtiquitz'et, xaxe ri achel xbanataj riq'uin ri profeta Jonás ojer can, xcha' ri Jesús. Y xeruya' c'a can, y xbe. ");
INSERT INTO cak_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ri ru-discípulos ri Jesús, tok xek'ax yan apu juc'an ruchi' ri ya', xquina'ej chi man jun pan quic'amon-e. ");
INSERT INTO cak_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ri Jesús xu'ij c'a chique: Tibana' cuenta ivi' chuvech ri levadura quichin ri achi'a' fariseos y ri saduceos, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jac'a ri discípulos quire' xqui'ij-ka ekal chiquivech: Rija' quiri' xu'ij chike roma man jun pan xkaq'uen-pe, xecha-ka chiquivech. ");
INSERT INTO cak_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ri Jesús xa reteman ri achique c'o pa tak cánima ri ru-discípulos, romari' xu'ij chique: Can k'alaj chi rix man can ta cukul ic'u'x viq'uin, romari' ja yan ri pan ri xinojij-ka cha'anin. ");
INSERT INTO cak_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿C'a man jani (tik'ax, tino') chivech, ni man nuka ta pan ivi' ri vo'o' pan ri xentzuk vo'o' mil vinak riq'uin? ¿Y man nuka ta pan ivi' ri ajani chaquech xe'inojsaj riq'uin ri man xq'uis ta? ");
INSERT INTO cak_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Y man nuka ta pan ivi' tok xentzuk (caji', quiji') mil vinak riq'uin ri vuku' pan? ¿Y man nuka ta pan ivi' ri ajani chaquech xe'inojsaj riq'uin ri man xq'uis ta? ");
INSERT INTO cak_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Achique roma man (nik'ax, nino') ta chivech chi mana-ta roma ximestaj can ri pan tok xin-ij chi tibana' cuenta ivi' chuvech ri qui-levadura ri fariseos y saduceos? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","C'ajari' (xk'ax, xno') chiquivech chi mana-ta ri levadura ri niyo'ox riq'uin ri pan ri xuc'uxlaj ri Jesús chique, xa ja ri achique niquic'ut ri achi'a' fariseos y ri saduceos. ");
INSERT INTO cak_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Tok ri Jesús (xapon, xebos) pa jun lugar ri c'o pa ru-cuenta ri tinamit rubinan Cesarea ri ni'ix richin ri Felipe che, quire' c'a xuc'utuj chique ri ru-discípulos: Yin ri xitak-pe richin xinalex chi'icojol, ¿(yin achique, ayincu'x) yin pa quivech ri vinak? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rije' xqui'ij che: Ec'o ye'in chi ja rat ri Juan ri Bautista. Ec'o ye'in chi ja rat ri profeta Elías ri xc'uje' ojer can, y ec'o ye'in chi ja rat ri profeta Jeremías, o jun chic chique ri profetas ri xec'uje' ojer can, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Rija' xuc'utuj c'a chique: Jac'a chivech rix, ¿(yin achique, ayincu'x) yin? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro xu'ij-apu: Ja rat ri Jun ri takon-pe chucolic rutinamit ri Dios, ri rat Ruc'ajol ri c'aslic Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jac'a ri Jesús quire' xu'ij che ri Pedro: Utzulaj tzij rubanon ri Dios chave rat Simón, ri rat ruc'ajol ri Jonás, roma ri xa'ij, man aj-roch'ulef ta xk'alajrisan chavech, xa ja ri Nata' Dios chicaj. ");
INSERT INTO cak_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yin nin-ij chave chi rat, rat Pedro. Y pa ruvi' c'a re abaj re' xtinpaba-vi ri nu-iglesia. Y ri ruchuk'a' ri camic man xtitiquer ta chirij. ");
INSERT INTO cak_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Chave c'a rat xtinya-vi ri uchuk'a' richin najak bey chiquivech ri xque'oc ruvinak ri aj-chicaj gobierno; y ronojel ri xta'ij rat chi utz nibanataj vave' choch'ulef, quiri' mismo xti'ix ri chicaj; y ri xta'ij rat chi man utz ta nibanataj vave' choch'ulef, quiri' mismo ri chicaj xti'ix chi can man utz ta chi nibanataj. ");
INSERT INTO cak_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jac'ari' tok ri Jesús quire' xu'ij chique ri ru-discípulos: Nis-ta jun achok che titzijoj-vi chi ja yin ri yin takon-pe roma ri Dios chucolic ri rutinamit, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chupan tak ri k'ij ri' ri Jesús xutz'uc nutzijoj chique ri ru-discípulos, chi rija' nic'atzin ni'e pa tinamit Jerusalem richin nik'ax pa k'axomal pa quik'a' ri nima'k quijuna' achi'a' c'o quik'ij, pa quik'a' ri nima'k tak quik'ij sacerdotes israelitas y pa quik'a' ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. Xu'ij chique chi xticamises pero chi rox k'ij xtic'asos-pe. ");
INSERT INTO cak_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Jac'ari' tok ri Pedro xuc'uaj-e juba' quila', xuch'olij, y quire' xu'ij che: Ajaf, ¿achique roma quiri' nanojij? Man ta nrojo' Dios chi quiri' nibanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jac'a ri Jesús xtzu'un-apu riq'uin ri Pedro y xu'ij che: ¡Catel-e chinuvech, rat Satanás! Rat xa rat jun k'atoy nubey, roma ri nanojij xa junan riq'uin ri niquinojij ri vinak, y man nanojij ta ri achique nrojo' ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jac'ari' tok ri Jesús quire' xu'ij chique ri ru-discípulos: Si c'o jun nrojo' yirutzekle'ej, tuya' can juc'an ri nurayij rija', man tupokonaj nuk'asaj c'ayef voma yin, masque necamises, y quirutzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Roma xa achique na ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ruc'aslen voma yin, can xtril-vi. ");
INSERT INTO cak_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Roma, ¿achique utz nuq'uen-pe che jun vinak si nic'uje' ronojel beyomal richin ri roch'ulef riq'uin, y xa man nicolotaj ta? Y, ¿achique chi beyomal nitiquer nuya' jun vinak richin nulok' ri c'aslen ri richin jumul? Man jun. ");
INSERT INTO cak_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Roma yin ri xitak-pe richin xinalex chi'icojol xa xquipe chic jun bey, epetenak ri nu-ángeles chuvij, riq'uin chic ruk'ij ri Nata'. Jac'ari' tok xtinya' ruq'uexel chique chiquijununal ri vinak ri achique xequibanala' choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y kitzij nin-ij chive chi ec'o jujun chive ri rixc'o vave' vacami ri man jani (quecom, quequen) e, tok xquinquitz'et yin ri xitak-pe richin xinalex chi'icojol chi yin Rey chic yin petenak richin nin-en gobernar, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tok k'axnak chic vaki' k'ij, ri Jesús xuc'uaj ri Pedro y xeruc'uaj ri ca'i' quichak'-quinimal qui' ri Jacobo y ri Juan chuvech jun juyu' naj jotol chicaj pa jun lugar ri man jun ninakon quichin. ");
INSERT INTO cak_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chiri' ri Jesús xjalataj ruvech chiquivech ri oxi' discípulos ri'; ri (ruvech, rupalaj) nitz'intz'ot achel ri k'ij, y ri rutziak jani na sak-sak xu'on. ");
INSERT INTO cak_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","C'ate xquitz'et, yetzijon yan chic ri Moisés y ri Elías riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Jac'ari' tok ri Pedro xu'ij-apu che ri Jesús: Ajaf, utz ri rojc'o vave'. Si rat najo', nika'an oxi' tak jay, jun avichin rat, jun richin ri Moisés, y jun chic richin ri Elías. ");
INSERT INTO cak_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","C'a quiri' na nich'o-apu ri Pedro, tok jari' xerumuk jun sutz' nitz'intz'ot. Y c'o c'a Jun xch'o-pe chupan ri sutz' y xu'ij: Jare' ri Nuc'ajol; yin can ninjo' y niquicot vánima riq'uin. Tinimaj ri rutzij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tok ri oxi' discípulos xquic'axaj quiri', xexuque-ka, xquiya-ka nic'aj-quivech pan ulef y jani na xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Xjel c'a apu ri Jesús quiq'uin, xuya-ka ruk'a' chiquij, y xu'ij chique: Quixcataj y man tixi'ij-ivi', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Y tok xetzu'un-pe, man jun chic jun xquitz'et, xa ruyon ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Tok exulan-pe chuvech ri juyu', ri Jesús xu'ij chique ri oxi' ru-discípulos: C'o ixiquin, man jun yan achok che titzijoj-vi ri xitz'et, c'a ja tok yin ri xitak-pe richin xinalex chi'icojol, yin c'ason chic pe chiquicojol ri anima'i', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri oxi' discípulos xquic'utuj c'a apu che ri Jesús: Pero, ¿achique roma ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés niqui'ij chi na'ey nuka ri Elías y c'ajari' nuka ri Jun ri nitak-pe chucolic rutinamit ri Dios? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xu'ij chique: Can kitzij vi chi na'ey nuka ri Elías y nu'on can ruchojmil ronojel. ");
INSERT INTO cak_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero yin nin-ij chive chi ri Elías xuka yan, y ri vinak man xquetemaj ta ruvech, xa xqui'en-e che xa achique na ri xcajo'. Quiri' mismo yin ri xitak-pe richin xinalex chi'icojol, ec'o xquebano chuve chi xtink'asaj k'axomal, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jac'ari' (xk'ax, xno') chiquivech ri discípulos chi xa ja ri Juan ri Bautista ri xutzijoj chique. ");
INSERT INTO cak_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tok ri Jesús y ri oxi' ru-discípulos xe'eka ri achique lugar quimolon-qui' eq'uiy vinak, c'o jun achi xuxuque' chuvech, y quire' xu'ij che: ");
INSERT INTO cak_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tapokonaj ruvech ri nuc'ajol, roma rija' nu'on ataque y can q'uiy k'axomal nuk'asaj pa ruk'a' ri yabil, roma q'uiy (mul, paj) nitzak pa k'ak' y pa ya'. ");
INSERT INTO cak_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinq'uen-pe chiquivech la a-discípulos, pero man xetiquer ta xqui'en chi xc'achoj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús jari' xu'ij: ¡Oh, rix vinak ri rixc'o vacami! Nis-ta jun chive ri can ta cukul ruc'u'x riq'uin ri Dios. Xa ivonojel rix satznak. ¿Rix ninojij chi yin jumul yic'uje' iviq'uin? ¿O jumul xquixincoch'? Tic'ama-pe ri ala' vave', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Xpe ri Jesús xuch'olij ri itzel espíritu. Jac'ari' xel-e ri itzel espíritu riq'uin ri ala', y xcolotaj chuvech ri yabil. ");
INSERT INTO cak_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jac'ari' quiyon xejel-apu ri discípulos riq'uin ri Jesús, y xquic'utuj che: ¿Achique roma roj man xojtiquer ta xkelesaj ri itzel espíritu? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xu'ij chique: Man xixtiquer ta xivelesaj, roma man can ta ninimaj achique nitiquer nu'on ruchuk'a' ri Dios. Roma yin kitzij nin-ij chive chi masque achel jun ch'uti ruvech ru-semilla mostaza, si quiri' ninimaj pan ivánima, yixtiquer ni'ij che ri jun juyu' re' chi tel-e vave' y tik'ax quila', y can xtik'ax-vi. Y riq'uin ri', man jun achique ri man ta xquixtiquer xti'en. ");
INSERT INTO cak_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jac'a ri jun ruvech itzel espíritu re', ntel, pero nrojo' oración y coch'on vayijal, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Tok ri Jesús y ri ru-discípulos ec'o chic pa departamento Galilea, rija' quire' xu'ij: Yin ri xitak-pe richin xinalex chi'icojol, can xquijach-vi pa quik'a' ri vinak. ");
INSERT INTO cak_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Xquinquicamisaj, pero chi rox k'ij xquic'astaj-pe, xcha'. Tok ri discípulos xquic'axaj ri xu'ij ri Jesús, jani na xebison. ");
INSERT INTO cak_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jac'a tok ri Jesús y ri ru-discípulos (xe'apon, xe'ebos) pa tinamit Capernaum, ri yec'utun ri impuesto richin ri racho ri Dios xejel-apu riq'uin ri Pedro y xquic'utuj che: ¿Ri Itijonel rix nutoj ri impuesto richin ri racho ri Dios, o xa manak? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ja', nuya', xcha' ri Pedro. Y tok xoc-apu pa jay, na'ey xch'o-pe ri Jesús y xu'ij che: Simón Pedro, ¿achique nanojij rat? Ri reyes pa ruvi' ri roch'ulef, ¿achok chique niquic'utuj-vi ri impuestos? ¿Chique ri calc'ua'l o chique ri man ecalc'ua'l ta? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Chique ri man calc'ua'l ta niquic'utuj-vi, xcha' ri Pedro. Y ri Jesús xu'ij: Romari' ri calc'ua'l man nic'atzin ta chi niquitoj impuestos. ");
INSERT INTO cak_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero richin man jun vi tiquinojij ri yec'utun impuesto, más utz cabin-apu pa ruvi' ri ya', tac'uaj ri ch'uti bak (tz'ama'el, chapabel) quer y taya-ka pa ya'. Ri na'ey quer xtuya-pe-ri', tajaka' pa ruchi' y chiri' xtavil-vi jun méra ri nu'on kichin roj ca'i' aviq'uin. Jari' tac'uaj y ta'aya' chique ri yec'utun ri impuesto richin ri racho ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chupan tak ri k'ij ri', ri discípulos xejel-apu riq'uin ri Jesús, y xquic'utuj che: Chupan ri aj-chicaj gobierno, ¿achique ri más xtic'uje' ruk'ij? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ri Jesús xroyoj jun ch'uti ac'ual, xuya' chiri' pa quinic'ajal, ");
INSERT INTO cak_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","y quire' xu'ij chique ri ru-discípulos: Can kitzij nin-ij chive, si rix man nijal ta ino'oj, y man ni'en ta achel ránima jun ac'ual, man xquixoc ta ruvinak ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Roma c'a ri', xa achique na ri más co'ol oc nuna-ka-ri' achel ri jun ch'uti ac'ual re', jari' ri más xtic'uje' ruk'ij chiquicojol ri erichin ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Y xa achique na jun ri pa nubi' yin nuc'ul ruvech jun ac'ual achel re', junan nu'ij chi ja yin nuc'ul nuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Y ri ec'o-pe re' ri man jani ruchuk'a' cánima riq'uin ri Dios, pero cukul quic'u'x viq'uin; xa achique na jun nibano che jun chique rije' chi nuxutuj can ri Dios, más utz che ri nibano quiri' chi na'ey ta xxim-e chukul jun nimalaj abaj ri nibolkotix roma ruchuk'a' jun avaj chujoq'uic trigo, y x-an che chi xjik' c'a chuxe' mar. ");
INSERT INTO cak_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tok'ex quivech ri vinak choch'ulef roma jumul c'o nibano chique chi niquixutuj can ri Dios. Can quiri' na vi nibanataj pa ruvi' ri roch'ulef, pero, ¡tok'ex ruvech ri nibano che jun chic chi nuxutuj can ri Dios! ");
INSERT INTO cak_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Roma c'a ri', si jun ak'a' o jun avakan nibano chave chi naxutuj can ri Dios, tachoyo-e y tatorij-e; más utz chave chi xe jun ak'a' o xe jun avakan c'o y yatoc chupan ri c'aslen ri richin jumul, que chuvech tz'akat ak'a' o avakan y xa yatec'ak chupan ri k'ak' ri man juba' nichup-ka. ");
INSERT INTO cak_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Quiri' mismo jun runak'-avech, si jari' nibano chave chi naxutuj can ri Dios, tavelesaj-e y tatorij-e; más utz chave chi xe jun runak'-avech c'o y yatoc chupan ri c'aslen ri richin jumul, que chuvech c'o ri ca'i' y xa yatec'ak chupan ri k'ak' ri jani na nic'at. ");
INSERT INTO cak_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Rix man ti'en chi can man jun oc ruk'ij jun chique ri man jani ruchuk'a' cánima riq'uin ri Dios achel ri ec'o-pe re', roma yin nin-ij chi rije' ec'o qui-ángeles ri jumul yo'on lugar chique chi ec'o-apu chuvech ri Nata' chicaj. ");
INSERT INTO cak_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Roma yin ri xitak-pe richin xinalex chi'icojol, xipe richin yencol ri esatznak pa mac. ");
INSERT INTO cak_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tinojij na pe jabel ri xtin-ij chive: Si c'o jun ec'o cien ru-ovejas y nisatz can jun pa juyu' tok yeruyuk'uj, yeruya' can juba' ri noventa y nueve, y ni'e pa tak juyu' richin nerucanoj ri satznak can. ");
INSERT INTO cak_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Si nril-pe ri ru-oveja satznak can, yin kitzij nin-ij chi rija' más niquicot ránima pa ruvi' ri ru-oveja xril, que pa quivi' ri noventa y nueve ri man xesatz ta. ");
INSERT INTO cak_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Quiri' mismo nibanataj riq'uin ri Itata' chicaj. Rija' man nurayij ta chi nisatz can jun chique ri ec'o-pe re' ri man jani ruchuk'a' cánima riq'uin ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Roma c'a ri', si c'o jun avach'alal nu'on ri man utz ta chave, ayon cabin riq'uin y ta'ij che ri xu'on. Si nunimaj ri na'ij che, junan chic ivánima nu'on jun bey. ");
INSERT INTO cak_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero si man nrojo' ta nrac'axaj ri na'ij che, tac'uaj jun o ca'i' chic más, richin quiri' chiquivech rije' na'ij-vi che ri man utz ta ri xu'on. Richin quiri' ronojel ri xti'ij chiri' chivech, c'o jun o ca'i' más ye'ac'axan. ");
INSERT INTO cak_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si man nrojo' ta nrac'axaj ri xi'ij rix che, rat c'ajari' ta'ij chique conojel ri niquimol-qui' pa rubi' ri Dios. Y tok rije' xech'o yan che, si man niniman ta tzij, tibana' che achel jun c'uluy impuesto o achel jun vinak ri man runiman ta ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yin kitzij nin-ij chive, chi ronojel ri xti'ij rix chi utz nibanataj vave' choch'ulef, quiri' mismo xti'ix ri chicaj; y ri xti'ij rix chi man utz ta chi nibanataj vave' choch'ulef, quiri' mismo ri chicaj xti'ix chi can man utz ta chi nibanataj. ");
INSERT INTO cak_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Roma c'a ri', nin-ij chic chive: Si vave' choch'ulef ec'o ca'i' junan cánima niqui'en richin c'o niquic'utuj che ri Dios chi tubana', ri Nata' Dios ri c'o chicaj can xtu'on-vi. ");
INSERT INTO cak_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Roma xa achique na lugar quimolon-vi-qui' ca'i-oxi' pa nubi', yin can yinc'o-vi pa quinic'ajal, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Jari' tok ri Pedro xjel-apu riq'uin ri Jesús y xu'ij che: Ajaf, ¿ajani cami (mul, paj) utz chi nin-en perdonar ri nibano ri man utz ta chuve? ¿Jun cami vuku' (mul, paj)? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jac'a ri Jesús xu'ij che ri Pedro: Yin man nin-ij ta chave chi vuku' (mul, paj) utz na'an perdonar. Yin nin-ij chave chi hasta vukutak setenta (mul, paj) utz na'an perdonar. ");
INSERT INTO cak_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Roma c'a ri', tivac'axaj ri ejemplo re': Ri aj-chicaj gobierno, junan riq'uin ri xu'on jun rey, tok rija' xrojo' xretemaj ajani quic'as chiquijununal ri rusamajela'. ");
INSERT INTO cak_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tok ri rey ri' (xutz'om, xuchop) rutz'etic ri ajantak quic'as ri samajela', xepabex jun samajinel chuvech ri chi millones ruc'as riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Y ri samajinel roma man nitiquer ta nutoj ri c'as, ri rey xu'ij chi tic'ayix junan riq'uin ri rixayil, ri ralc'ua'l, y ri achique eruchajilo'n richin jari' ntoc pa ruq'uexel ri c'as. ");
INSERT INTO cak_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Jac'ari' xxuque-ka ri samajinel chuvech ri rey, nuquemelaj-ri' nuc'utuj ru-favor che, y quire' nu'ij: Vajaf, tabana' favor, can c'a quinavoyo'ej na, y yin xtintzolij ronojel chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rajaf ri samajinel xsilon ránima richin xupokonaj ruvech, romari' xusok'opij-e y xu'on perdonar ri c'as. ");
INSERT INTO cak_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Jac'a tok xel-pe ri samajinel ri x-an-pe perdonar ruc'as roma ri rajaf, rija' xuc'ul jun chic samajinel ri kajayon juba' méra che, rajil cami (caji', quiji') ic' samaj. Pero can xe xquic'ul-qui', rija' ja (xutz'om, xuchop) ri jun chic samajinel y juba' ma nutz'apij-ka ruxla', y nu'ij che: Tatojo-pe ri c'as abanon viq'uin, nicha' che. ");
INSERT INTO cak_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Can jari' xxuque-ka ri jun chic samajinel chuvech, nuquemelaj-ri' nuc'utuj ru-favor che, y quire' nu'ij: Tabana' favor, can c'a quinavoyo'ej na, y yin xtintzolij ronojel chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Jac'a ri samajinel ri chi millones ruc'as, man xka ta chuvech ri xu'ij ri jun chic samajinel che, xa xuc'uaj-e y xberuya' pa cárcel, c'a tutojo' na ri c'as. ");
INSERT INTO cak_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tok ri ch'aka' chic samajela' ri junan yesamaj quiq'uin xquitz'et ri xbanataj, xk'axo cánima. Xebe c'a riq'uin ri rey ri cajaf y xquitzijoj ronojel ri xu'on ri jun samajinel che ri jun chic. ");
INSERT INTO cak_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Jac'ari' tok ri cajaf xroyoj ri samajinel ri man utz ta runo'oj, y xu'ij che: Rat, xa rat jun itzel samajinel. Yin xin-en perdonar ronojel ri ac'as, roma rat xac'utuj quemelal chuve. ");
INSERT INTO cak_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Achique roma man xapokonaj ta ruvech ri jun chic samajinel achel ri xin-en yin aviq'uin? ");
INSERT INTO cak_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ri rey xcataj c'a royoval, romari' xujach-e ri itzel rusamajinel pa quik'a' ri yeyo'on pa k'axomal ri presos, richin tic'uje' chiri' c'a tutojo' na can ronojel ri ruc'as. ");
INSERT INTO cak_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Quiri' mismo xtu'on ri Nata' Dios ri c'o chicaj chive rix, si chi'ijununal man ni'en ta perdonar riq'uin ronojel ivánima jun ri banayon man utz ta chive, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Tok ri Jesús xtane' chubixic ri ch'abel ri', xuya' can ri departamento Galilea, y xbe pa departamento Judea, pa tak lugares ri ec'o-apu juc'an ruchi' ri rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Man juba' ta oc xetzekle'en richin, y chiri' xu'on chique ri yeyavej chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jac'ari' xe'eka achi'a' fariseos riq'uin richin niquicanoj achique ta niqui'en richin nika pa quik'a', y quire' c'a xquic'utuj che: Ri ley ri xuya' ri Dios che ri Moisés, ¿nuya' cami lugar chi jun achi nuya' can ri rixayil xa achique na roma? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jac'a ri Jesús quire' rutzolic quitzij xu'on: ¿Man itz'eton ta rix ruch'abel ri Dios ri nu'ij chi ri Jun ri xbano quichin ri vinak pa na'ey, xe jun achi y jun ixok xu'on? ");
INSERT INTO cak_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ri Dios xu'ij chi ri ala' man xtic'uje' ta chic quiq'uin ri rute-rutata', xa xtiquic'uaj-qui' riq'uin ri rixayil, y xe jun xtiqui'en ri eca'i'. Quiri' nu'ij ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Re' nu'ij tzij chi man eca'i' ta chic, xa jun quibanon. Romari', ri xa jun rubanon ri Dios chique, man jun vinak tijacho quivech, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jac'a ri fariseos xqui'ij: Si quiri', ¿achique roma ri Moisés rutz'iban can chi ri achi ri nrojo' nuya' can ri rixayil, tujacha' jun vuj che ri rixayil ri achok chupan nu'ij-vi chi nuya' can, y quiri' nujach can jumul? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xu'ij chique: Roma rucovil ri ivánima rix vinak tok ri Moisés xuya' lugar chi ri achi c'o che'el nuya' can ri rixayil. Pero pa na'ey man quiri' ta. ");
INSERT INTO cak_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Jac'a yin nin-ij chive: Xa achique na achi ri nuya' can ri rixayil tok ri ixok xa manak mac rubanon riq'uin chic jun achi, y nuq'uen chic jun ixok, ja nika pa mac. Ja jun ri achi ri nic'amo ri ixok yo'on can, nika pa mac, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jac'ari' quire' xqui'ij ri discípulos: Si jun achi siempre nic'atzin chi ximil riq'uin ri rixayil, más utz man ta nic'ule', xecha' rije'. ");
INSERT INTO cak_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jac'a ri Jesús xu'ij: Man conojel ta niquicoch' yec'uje' quiyon, xaxe ri achok chique yo'on-vi-pe, ri yetiquer. ");
INSERT INTO cak_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Roma ec'o achi'a' ri can pa calaxic pe yek'alajin chi man xque'ec'ule' ta vi, ec'o ri man yec'ule' ta roma banon cak'on, y ec'o ri can pa cánima nalex-vi-pe chi yec'uje' quiyon, roma ri cánima nurayij chi más q'uiy yetiquer niqui'en pa ru-cuenta ri aj-chicaj gobierno. Jac'a ri nuna' chi nitiquer nic'uje' ruyon, man tic'ule', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ec'o c'a jujun ac'ola' xe'eyo'ox chuvech ri Jesús, richin nuya' ruk'a' pa quivi' y richin nuc'utuj ru-favor ri Dios pa quivi'. Jac'a ri discípulos xa xequich'olij ri e'uc'uayon-apu ri ac'ola'. ");
INSERT INTO cak_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ri Jesús xu'ij chique ri ru-discípulos: Tiya' lugar chique ri ac'ola' chi yepe viq'uin, y man que'ik'at. Roma ri xque'oc ruvinak ri aj-chicaj gobierno, ja ri yebano che ri cánima achel cánima ri ac'ola'. ");
INSERT INTO cak_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y tok ri Jesús xuyala' yan ruk'a' pa quivi' ri ac'ola', rija' xuya' can ri lugar ri', y xbe. ");
INSERT INTO cak_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jac'ari' tok c'o jun xuch'o riq'uin ri Jesús y xu'ij che: Utzulaj Tijonel, ¿achique utz nin-en yin richin quiri' ninvil ri c'aslen ri richin jumul? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xu'ij che: ¿Achique roma rat na'ij chi yin utz? Man jun chic jun utz, xaxe ri Dios. Jac'a rat, si najo' navil ri c'aslen ri richin jumul, que'animaj ri mandamientos, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","¿Achique c'a chi mandamientos ri na'ij? xcha'. Y ri Jesús xu'ij che: Man cacamisan; man tac'amala-ka-avi' riq'uin jun ri mana-ta achok riq'uin rat c'ulan-vi; man catelak'; man tatz'uc tzij. ");
INSERT INTO cak_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taya' quik'ij ri ate-atata'. Y achel najo-ka-avi' rat, quiri' mismo que'ajo' conojel. Quiri' nu'ij ri mandamientos, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jac'a ri ala' ri xuch'o riq'uin quire' xu'ij: Ronojel ri na'ij, c'a yin ac'ual na chiri' nubanon-pe y c'a quiri' na vacami. ¿Achique chic más ri man nubanon ta? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xu'ij che: Si rat najo' na'an tz'akat che ri ac'aslen, cabin, tac'ayij ri achajin, y ri rajil tajacha' chiquivech ri vinak ri man jun oc quichajin. Si quiri' na'an, xtic'uje' abeyomal chicaj. Y catampe c'a, quinatzekle'ej, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tok ri ala' xrac'axaj ri xu'ij ri Jesús, nibison ránima xtzolij-e, roma can q'uiy beyomal c'o riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jac'ari' tok ri Jesús xu'ij chique ri ru-discípulos: Can kitzij nin-ij chive chi jun beyon, c'ayef richin ntoc ruvinak ri aj-chicaj gobierno. ");
INSERT INTO cak_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Y jun chic, xa más man c'ayef ta chi nik'ax jun chicop camello pa ch'uti rujulil jun bak richin t'iso'n, que chuvech ntoc jun beyon chiquicojol ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tok ri discípulos xquic'axaj quiri', can achique na xquina', romari' niquibila' chiquivech: Si kitzij achel ri nu'ij, man jun xticolotaj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xerutz'et-apu ri ru-discípulos y xu'ij chique: Chivech rix aj-roch'ulef, manak che'el nibanataj achel ri xin-ij, pero chuvech ri Dios, xa ronojel c'o che'el nibanataj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jari' tok ri Pedro xu'ij che ri Jesús: Tatz'eta' c'a, roj kayo'on can ronojel richin rat katzekle'en. ¿Y achique c'a ri xtiyo'ox chike? ");
INSERT INTO cak_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xu'ij chique: Can kitzij nin-ij chive chi chupan ri k'ij tok ronojel c'ac'ac' chic rubanon, tok yin ri xitak-pe richin xinalex chi'icojol xquitz'uye' pa jun lok'olaj tz'uyubel riq'uin nimalaj nuk'ij, ja jun rix ri xixtzekle'en vichin xquixtz'uye-apu pa doce tz'uyubel c'o quik'ij richin ni'ij ri achique nic'atzin chi ni'an pa quivi' ri erichin ri doce tinamit richin ri Israel. ");
INSERT INTO cak_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xa achique na jun ri ruyo'on can racho, rute-rutata', rixayil, ralc'ua'l, runimal, ruchak', rana', o rujuyu' roma ri nubi' yin; xtuc'ul jujun ciento más ruvi' che ri ruyo'on can. Y xtiyo'ox che ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero q'uiy chique ri ec'o na'ey vacami, xa xquecanaj can ruq'uisbel, y q'uiy chique ri ec'o can ruq'uisbel, xa xqueyo'ox yan chic na'ey. ");
INSERT INTO cak_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Quiri' ri nin-ij chive, roma ri xtibanataj chupan ri aj-chicaj gobierno, junan riq'uin ri xu'on jun tata'aj. Rija' cumaj yan sakar xel-e chiquicanoxic samajela' richin yerutak pa rujuyu' ri ticon uva chuvech. ");
INSERT INTO cak_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tok ch'ovinak chic quiq'uin, xecanaj chiquivech chi rija' xtuya' ri nuch'ec jun samajinel jun k'ij chique, y jac'ari' xerutak-e ri pa rujuyu' ri c'o-vi ri uva. ");
INSERT INTO cak_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Richin cami las nueve chiri', ri tata'aj xel chic e jun bey, y pa c'ayibel xerutz'et epa'el jujun chic más ri manak quisamaj. ");
INSERT INTO cak_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xch'o c'a quiq'uin y xu'ij chique: Ja jun rix quixesamaj pa nujuyu' ri ticon uva chuvech, y yin veteman xtintoj rajil ri isamaj, xcha'. Y can xebe na vi. ");
INSERT INTO cak_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Pa nic'aj k'ij cami chiri', xel chic e jun bey, y quiri' mismo richin a las tres xk'ak'ij, y ri xeril, xerutak-e pa rusamaj y xu'ij chique chi xquerutoj roma ri samaj xtequibana'. ");
INSERT INTO cak_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Richin cami las cinco xk'ak'ij-ka, rija' xel chic e jun bey y c'a c'o ri manak quisamaj xeril. Rija' xuc'utuj chique: ¿Achique roma chi jun k'ij rixc'o vave' y manak isamaj? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Roma man jun xyo'on kasamaj, xecha'. Y ri tata'aj rajaf ri juyu' xu'ij chique: Ja jun rix quixesamaj ri pa nujuyu' ri ticon-vi uva, y yin veteman xtintoj rajil ri isamaj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ja nika-ka ri k'ij chiri', ri rajaf ri tico'n xu'ij che ri uc'uay quichin ri samajela': Que'avoyoj-pe conojel ri samajela' richin ye'atoj-e. Na'ey que'atojo-e ri samajela' xe'uka pa ruq'uisbel, y ja ri xe'uka na'ey, jari' que'atojo' pa ruq'uisbel, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tok ri samajela' ri xe'oc pa samaj juba' ma richin a las cinco xk'ak'ij xepe richin yetoj-e, rajil jun k'ij samaj ri xyo'ox-e chique chiquijununal. ");
INSERT INTO cak_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jac'a tok xepe ri samajela' ri xe'oc na'ey pa samaj richin yetoj-e, xquinojij chi más q'uiy cajil xtiyo'ox-pe chique que chiquivech ri man jun k'ij ta xesamaj. Pero xa rajil jun k'ij samaj ri xyo'ox-pe chique conojel. ");
INSERT INTO cak_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tok xquic'ul-pe ri cajil, ri na'ey xe'oc pa samaj xa man xka ta chiquivech, y xa yech'o chirij rajaf ri samaj. ");
INSERT INTO cak_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Rije' quire' c'a xequi'ij che: Ri ruq'uisbel tak samajela' xaxe oc jun hora xesamaj, y junan kajil xaya' chike quiq'uin, tok roj chi jun k'ij xkatij kak'ij xojsamaj y xojc'uje' chuxe' ruk'ak'al ri k'ij, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ri rajaf ri samaj xu'ij che jun chique ri samajela' ri': Rat nusamajinel, riq'uin ri junan xentoj ri ch'aka' chic samajela', chave rat man jun itzel xin-en. Roma xojcanaj aviq'uin chi ri avajil ri ninya', ja achel nuch'ec jun samajinel jun k'ij. ¿Nuka pan avi'? ");
INSERT INTO cak_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Roma c'a ri', rat xaxe tac'uaj ri avajil y cabin. Pero yin pa vánima nalex-vi-pe chi ninya' che re jun re xoc ruq'uisbel pa samaj ri achel xinya' chave rat. ");
INSERT INTO cak_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Roma ronojel ri c'o viq'uin yin, ri ley nuya' lugar chuve richin nin-en riq'uin ri achel ninjo' nin-en. ¿O xa nikukut avánima rat chique ri ch'aka' chic, roma yin xin-en jun favor chique? xcha' ri tata'aj rajaf ri samaj. ");
INSERT INTO cak_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ri ejemplo re' nuc'ut chikavech chi ri ec'o na'ey vacami, xa xquecanaj can ruq'uisbel, y ri ec'o can ruq'uisbel, xa xqueyo'ox yan chic chi na'ey. Roma masque eq'uiy ri xque'oyox, pero xa juba' oc ri xquecha'ox chiquicojol. Quiri' xu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Tok ri Jesús jotol-e pa tinamit Jerusalem, quiri' pa bey xeroyoj-e juba' juc'an ri doce ru-discípulos y quire' xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Rix iveteman chi pa tinamit Jerusalem roj jotol-vi-e, y chiri' yin ri xitak-pe richin xinalex chi'icojol xquijach pa quik'a' ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, y rije' xtiqui'ij chi quicamises. ");
INSERT INTO cak_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Xquinquijach pa quik'a' vinak man israelitas ta richin yinquitze'ej, yinquich'ey y richin yinquibajij chuvech cruz richin yinquicamisaj. Pero chi rox k'ij xquic'astaj-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jac'ari' tok ri quite' ri eruc'ajol ri Zebedeo xjel-apu riq'uin ri Jesús junan riq'uin ri ral. Ri ixok xxuque' c'a ka chuvech ri Jesús richin nuc'utuj jun favor che. ");
INSERT INTO cak_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","¿Achique c'a ri najo'? xcha' ri Jesús che. Y ri ixok xu'ij: Yin ninjo' chi tok rat rey chic chiri', tabana' chique ri ca'i' val re' chi yetz'uye-apu aviq'uin; jun pan a-derecha y jun pan a-izquierda, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jac'a ri Jesús xu'ij chique: Rix man iveteman ta ri achique nic'utuj. ¿Nicoch' cami rix ri achel xti'an chuve yin? Roma yin can achel xqui'an bautizar chupan jun nimalaj k'axomal, xcha'. Y ri ca'i' discípulos eral ri ixok xqui'ij: Nikacoch', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xu'ij chique: Can kitzij vi chi rix xtik'asaj ri achel xti'an chuve yin. Xquix-an bautizar chupan k'axomal ri achel xtink'asaj yin. Jac'a ri nijo' rix chi jun nitz'uye' pa nu-derecha y jun pa nu-izquierda, man pa nuk'a' ta yin c'o-vi richin ninya'. Roma ri lugar ri', ja chique ri achok coma banon rubanic roma ri Nata' xtiyo'ox-vi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tok ri lajuj chic discípulos xquic'axaj ri achique niquic'utuj ri ca'i' discípulos ri quichak'-quinimal qui', xa xpe coyoval chique. ");
INSERT INTO cak_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jac'ari' tok ri Jesús xeroyoj ri ru-discípulos, y xu'ij chique: Rix iveteman chi ri yebano gobernar choch'ulef ecajaf ri vinak niquina-qui'. Nima'k quik'ij niquina-qui', y can ja rije' ye'in ri achique nic'atzin chi ni'an. ");
INSERT INTO cak_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Jac'a chi'icojol rix man quiri' ta. Roma ri nrojo' nic'uje' ruk'ij chive, nic'atzin chi rija' achel jun isamajinel. ");
INSERT INTO cak_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Y si jun chive nrojo' chi ja rija' na'ey, tubana' achel jun lok'on samajinel chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Achel yin ri xitak-pe richin xinalex chi'icojol, man xipe ta richin yito'ox; yin xipe richin yito'on y richin ninya' nuc'aslen coma eq'uiy richin yecolotaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Tok ri Jesús y ri ru-discípulos xe'el-pe pa tinamit Jericó, eq'uiy vinak xepe chiquij. ");
INSERT INTO cak_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chuchi' bey chiri' ec'o ca'i' man yetzu'un ta etz'uyul. Tok xquic'axaj chi ja ri Jesús ri nik'ax chiri', cof xech'o y xqui'ij: ¡Ajaf, rat ri rat riy-rumam can ri rey David, tapokonaj kavech! xecha'. ");
INSERT INTO cak_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Jac'a ri vinak xequich'olij richin quetane-ka. Pero rije' xa más cof xech'o-pe y xqui'ij: ¡Ajaf, rat ri rat riy-rumam can ri rey David, tapokonaj kavech! xecha'. ");
INSERT INTO cak_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Xpa'e' c'a ka ri Jesús, xeroyoj y xuc'utuj chique: ¿Achique nijo' chi nin-en chive? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Rije' xqui'ij: Ajaf, roj nikajo' nkutzu'un, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús xupokonaj quivech, y romari' xuya-apu ruk'a' chi tak runak'-quivech. Can jari' xetzu'un chic y xquitzekle'ej-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Tok ri Jesús, ri ru-discípulos y ri ajani ebenak quiq'uin nakaj chic ec'o-vi-apu che ri tinamit Jerusalem, ri achique lugar c'o-vi ri aldea Betfagé ri c'o-apu chunakaj ri juyu' Olivos, ri Jesús xerutak-apu ca'i' ru-discípulos, ");
INSERT INTO cak_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","y xu'ij c'a e chique: Quixbin-apu chupan la aldea la c'o-apu la'; xe xquixoc-apu, jari' nivil jun burra yukul, y jun alaj burro riq'uin. Tisolo-pe y que'ic'ama-pe chuve. ");
INSERT INTO cak_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Si c'o jun ri c'o achique xtu'ij-pe chive, rix ti'ij che: Yec'atzin che ri Ajaf, pero xa cha'anin xquerutzolij-pe, quixcha' can. Quiri' xu'ij-e ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ronojel re' xbanataj, richin quiri' nibanataj ri tz'iban can roma ri jun profeta ojer can. Ri ruch'abel ri Dios ri rutz'iban can ri profeta quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' c'a rutzijol chique ri ec'o pa tinamit Sion, y quire' ti'ij: Titz'eta', ja petenak ri i-Rey iviq'uin, (Ch'uch'uj, me'l oc) ránima petenak, (ch'ocol, tz'uyul) pe chirij jun alaj burro, Ral jun burra richin eka'n. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Xebe c'a ri ca'i' discípulos, xequibana' ri achel bin-e chique roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquiq'uen-pe ri burra y ri ral y xquiya-e jujun quitziak chiquij ri avaj, y (xch'oque', xtz'uye') c'a e ri Jesús pa ruvi' ri tziek. ");
INSERT INTO cak_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y man juba' ta oc vinak ebenak chirij, y eq'uiy chique niquiriq'uila' jujun quitziak pa rubey richin niquiya' ruk'ij. Ch'aka' xequichoyola' ruk'a' tak che' y yequiyala-ka pa rubey ebenak. ");
INSERT INTO cak_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ri ebenak chuvech y ri ebenak chirij, riq'uin cuchuk'a' quire' niqui'ij: ¡Matiox chi petenak re riy-rumam can ri rey David! ¡Nimalaj favor c'o pa ruvi' re petenak pa rubi' ri Ajaf! ¡Matiox che ri Dios chicaj! yecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tok ri Jesús xoc-apu pa tinamit Jerusalem, conojel ri vinak xepe chutz'etic y niquibila' chiquivech: ¿Achique cami achi re'? yecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Re' jare' ri Jesús, ri profeta ri nitzijon ri ch'abel ri ni'ix che roma ri Dios. Rija' aj pa tinamit Nazaret, ri tinamit ri c'o pa Galilea, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Chiri' pa tinamit Jerusalem, ri Jesús xoc pa racho ri Dios y xerokotaj-pe conojel ri yec'ayin y ri yelok'on chiri'. Xuticmayila' can qui-mesas ri eq'uexoy ruvech méra, y ri quich'acat ri yec'ayin palomas, ");
INSERT INTO cak_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","y quire' xu'ij chique: Chupan ri tz'iban can, ri Dios nu'ij: Ri vacho, jay richin oración. Jac'a rix xa quijul elek'oma' ibanon che, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chiri' pa racho ri Dios, ec'o man yetzu'un ta y ec'o man utz ta cakan ri xejel-apu riq'uin ri Jesús, y rija' xu'on chique chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jac'a ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' q'uiy queteman chirij ri ley, xa xcataj coyoval tok xquitz'et ri nimalaj tak milagros ri yerubanala', y chi ri ch'utik alabo chiri' chuvech racho ri Dios riq'uin cuchuk'a' quire' niquibila': ¡Matiox chi xuka ri ka-Rey, ri riy-rumam can ri David! yecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Roma c'a ri', quire' xqui'ij che ri Jesús: ¿Navac'axaj ri yetajin chubixic ri ac'ola'? xecha'. Jac'a ri Jesús xu'ij chique: Ja', ninvac'axaj. ¿Man itz'eton ta c'a ri tz'iban can chupan ruch'abel ri Dios c'a? Chiri' nu'ij: Rat Dios, ja pa quichi' ri ch'utik ac'ola' y ri c'a yetz'uman na, Chiri' ayo'on-vi chi rat tz'akat ak'ij nac'ul. Quiri' ri tz'iban can, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y tok eruyo'on chic can ri achi'a' ri', xel-e ri pa Jerusalem, xec'uje' jun ak'a' pan aldea Betania. ");
INSERT INTO cak_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Cumaj yan chuca'n k'ij, ri Jesús nivayijan xtzolij-pe pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","C'o c'a jun mata higo xutz'et-apu chuchi' bey, y xjote-apu chuxe'. Pero man jun ch'uti ruvech xril, xa ruyon ruxak. Roma c'a ri', ri Jesús quire' xu'ij che ri che': Man jun bey chic xtaya' avech, xcha' che. Y ri che' cha'anin xchakij-ka. ");
INSERT INTO cak_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tok ri discípulos xquitz'et chi can xchakij-vi-ka ri mata higo, xquibila' chiquivech: ¿Achel chi can cha'anin xchakij-ka ri mata higo? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Quire' c'a rutzolic quitzij xu'on: Can kitzij nin-ij chive: Si rix cukul ic'u'x, y man caca' ta ni'en-ka che ri ivánima, man xe ta che jun mata higo xti'en chi nichakij-ka, ja jun re jun juyu' re', si xti'ij che chi tel-e vave' y tik'ax chupan ri mar, can quiri' vi xtibanataj. ");
INSERT INTO cak_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ronojel ri nic'utuj rix tok ni'en orar, si cukul ic'u'x nic'utuj, can xtiyo'ox-vi-pe chive, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tok ri Jesús ja yerutijoj ri vinak chiri' pa racho ri Dios, ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij chiquicojol ri vinak, xejel-apu riq'uin y xquic'utuj che: ¿Achique ak'a' rat chi ye'abanala' ronojel re yatajin riq'uin? ¿Y (achique, acu'x) x-in chave chi quire' que'abanala'? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xu'ij chique ri achi'a' ri': Quiri' mismo yin c'o jun ninjo' ninc'utuj chive, y si xti'ij-pe chuve ri achique xtinc'utuj chive, yin xtin-ij chive ri achok riq'uin petenak-vi chi c'o nuk'a' richin yenbanala' quire'. ");
INSERT INTO cak_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jac'ari' xuc'utuj chique: Tok ri Juan xeru'on bautizar ri vinak, ¿Dios cami biyon-pe che, o xa vinak? xcha'. Jac'a rije' quire' niquic'utula-ka chiquivech: Si xtika'ij chi ri Juan ja ri Dios takayon-pe, ri Jesús xtu'ij chike chi achique roma man xkanimaj ta. ");
INSERT INTO cak_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y si xtika'ij chi xa vinak xe'in che ri Juan, roj nikaxi'ij-ki' chi ri tinamit yecataj-pe chikij, roma chiquivech conojel, ri Juan can profeta vi, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jac'ari' xqui'ij-apu che ri Jesús: Roj man keteman ta, xecha'. Y ri Jesús xu'ij chique: Quiri' mismo xtin-en yin; man xtin-ij ta chive ri achok riq'uin petenak-vi chi c'o nuk'a' chi yenbanala' quire', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jac'ari' tok ri Jesús xu'ij: Vacami c'a, rix ti'ij-pe ri achique ninojij pa ruvi' ri xtin-ij chive: C'o jun achi ec'o ca'i' ruc'ajol. Rija' xbe-apu riq'uin ri na'ey ruc'ajol y quire' xu'ij che: Nuc'ajol, vacami cabin, catesamaj ri pa juyu' ri katicon-vi uva, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jac'a ri ala' xu'ij che ri rutata': Manak samaj ninjo' nin-en yin, xcha'. Pero c'a juba' tu'ij quiri', xunojij-ka chi man utz ta ri xu'ij, y xa xbe ri pa samaj. ");
INSERT INTO cak_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Xbe c'a apu ri tata'aj riq'uin ri jun chic ruc'ajol, y achel xu'ij che ri na'ey ruc'ajol, quiri' mismo xu'ij che ri ruca'n. Ri ala' ri' xu'ij che ri rutata': Utz c'a, ja yi'e, xcha'. Pero xa man xerubana' ta ri samaj. ");
INSERT INTO cak_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Achique chique ri ca'i' alabo re' ri xbano ri nrojo' ri tata'aj, ninojij rix? xcha' ri Jesús. Y ri achi'a' ri' xqui'ij: Ja ri na'ey ala', xecha'. Ri Jesús xu'ij chique: Yin kitzij nin-ij chive chi xa ja ri c'uluy tak impuestos y ri ixoki' man utz ta quic'aslen, jari' ri xque'oc na'ey chivech rix chiquicojol ri erichin ri ru-gobierno ri Ajaf Dios. ");
INSERT INTO cak_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Roma tok xpe ri Juan ri Bautista, xuc'ut jun chojmilaj bey chivech, y rix man xinimaj ta. Xaxe ri c'uluy tak impuestos y ri ixoki' man utz ta quic'aslen ri xeniman. Jac'a rix, masque xitz'et chi rije' xquinimaj, pero rix man xijal ta ino'oj richin ta xinimaj. ");
INSERT INTO cak_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tivac'axaj na pe jun chic ejemplo: C'o jun tata'aj xutic uva chuvech jun rujuyu' y xuc'ojoj rij. Xu'on can jun achel pila ri pa rujuyu' richin niyitz'-vi ri uva, xu'on jun garita quichin ri chajinel y xuya' can ri rujuyu' pa (k'uch, cuchubal) chique ca'i-oxi' achi'a' ri xquesamajin ruvech, c'ajari' xbe naj. ");
INSERT INTO cak_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tok xril k'ij chi nich'up ruvech ri uva, ri tata'aj re' xerutak-e jujun rusamajela' quiq'uin ri yesamajin ruvech ri juyu' richin nequic'ama' ri parte che ri tico'n ri can richin vi rija'. ");
INSERT INTO cak_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ri yesamajin ruvech ri juyu', xa chi oyoval xequic'ul-vi ri samajela'. Jun xquich'ey-pe, jun xquic'ak-pe che abaj y jun xquicamisaj. ");
INSERT INTO cak_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ri rajaf ri juyu' xerutak chic e ch'aka' samajela', más eq'uiy que chuvech ri xerutak na'ey. Jac'a ri yesamajin ruvech ri juyu', mismo chi oyoval xequic'ul-vi, achel xqui'en-pe chique ri xetak na'ey. ");
INSERT INTO cak_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pa ruq'uisbel, ri rajaf ri juyu' xutak-e ri ruc'ajol quiq'uin roma quire' nunojij: Si ja ri nuc'ajol ri xteka quiq'uin, can xqueniman-vi chuvech, xcha-ka pa ránima. ");
INSERT INTO cak_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ri yesamajin ruvech ri juyu', tok xquitz'et chi ja ruc'ajol rajaf ri juyu' ri tzalan-apu quiq'uin, quire' niquibila' chiquivech: Jare' ntoc can rajaf ri juyu' re'. Quire' quixampe, tikacamisaj, y tikabana-ka kichin che ri juyu' ri xtiyo'ox che ri c'ajol re', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","(Xquitz'om, xquichop) ruc'ajol rajaf ri juyu', xquelesaj-pe ri pa juyu' y xquicamisaj. ");
INSERT INTO cak_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tok xtipe rajaf ri juyu' ri ticon uva chuvech, ¿achique cami xtu'on chique ri yesamajin ruvech ri rujuyu'? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rije' xqui'ij: Ri rajaf ri juyu' man jun chic quipokonaxic xtu'on ri itzel tak achi'a' ri', xa xquerucamisaj; y ri rujuyu' xtuya' chic pa (k'uch, cuchubal) chique ch'aka' chic samajela' ri can c'o che ri tico'n xtiquiya' che ri rajaf tok nril k'ij richin ri ch'upuj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Y ri Jesús xu'ij c'a chique: ¿Man jun bey ibanon leer ri nu'ij chupan ri ruch'abel ri Dios? Ri tz'iban can quire' nu'ij: Ri abaj ri man juba' xcajo' xquicusaj ri banoy tak jay, Xa jari' xc'atzin richin ruchuk'a' ruxiquini'l ri jay. Ja ri Ajaf xbano quiri' che, Y roj ntel-e runak'-kavech nikatz'et. Quiri' nu'ij ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Xa roma c'a ri' nin-ij chive chi rix man chic xtiyo'ox ta lugar chive chi xquixc'uje' chiquicojol ri erichin ri ru-gobierno ri Ajaf Dios. Xa ch'aka' chic ri xquec'uje' can pan iq'uexel, ri can queteman xtiquisamajij ri ruyo'on can ri Dios chique richin c'o utz nuq'uen-pe che ri gobierno ri'. ");
INSERT INTO cak_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ri xtitzak pa ruvi' ri abaj re', xtimulumu' chuvech, y ri xtika ri abaj re' chirij, nichiquicho' chuxe', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tok ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' fariseos xquic'axaj ri ejemplo ri xerutzijoj ri Jesús, (xk'ax, xno') chiquivech chi xa chiquij rije' xch'o-vi-ka. ");
INSERT INTO cak_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Pero masque niquitij quik'ij chi nicajo' (niquitz'om, niquichop), xa niquixi'ij-qui' chiquivech ri tinamit; roma chiquivech ri vinak, ri Jesús can profeta vi. ");
INSERT INTO cak_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ri Jesús xch'o chic jun bey chique ri quimolon-apu-qui', y riq'uin ejemplos quire' xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Chupan ri aj chicaj gobierno, ri Dios vacami nu'on junan riq'uin ri xu'on jun rey pa runimak'ij ruc'ulubic ri ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ri rey xerutak rusamajela' richin xecoyoj ri yo'on rutzijol chique chi yepe chupan ri c'ulubic. Jac'a ri xe'oyox man xcajo' ta xepe. ");
INSERT INTO cak_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Xerutak chic ch'aka' samajela' y xu'ij-e chique: Te'ibij chique ri nuyo'on rutzijol chique, chi quepe chupan re nimak'ij, roma nubanon chic rubanic ronojel richin ri va'in. Ri achij tak nuváquix y ri ch'aka' chic chicop ri xentiojirisaj richin yec'atzin chupan ri k'ij re', xin-en yan quibanic y ronojel c'o chic, quixcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ri xe'oyox, xa achel mana-ta chique xe'an-vi tzij. Ec'o xa xe'esamaj pa tak juyu', ec'o xe'ec'ayin, ec'o xe'elok'on. ");
INSERT INTO cak_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Pero ch'aka' chique rije' (xequitz'om, xequichop) rusamajela' ri rey, juye' quivech xqui'en y xequicamisaj. ");
INSERT INTO cak_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tok ri rey xrac'axaj ri achique xbanataj quiq'uin ri rusamajela', xcataj royoval. Xerutak c'a e ru-soldados richin xe'equicamisaj ri xebano ri camic y richin xquiporoj can ri quitinamit. ");
INSERT INTO cak_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jac'ari' tok ri rey quire' chic xu'ij chique ri rusamajela': Ronojel ri nic'atzin chupan ruc'ulubic ri nuc'ajol banon chic rubanic, pero roma xa man xepe ta ri xyo'ox rutzijol chique, chiri' xk'alajin-vi chi rije' can man nuc'ul ta vi chi yepe chupan ri nimak'ij re'. ");
INSERT INTO cak_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vacami c'a, quixbin pa tak rucrusil tak bey, que'ivoyoj-pe conojel ri ye'ivil-pe richin yepe chupan ri c'ulubic, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Xebe c'a ri samajela' pa tak rucrusil tak bey, xequimol-pe conojel ri xequil, utz man utz quic'aslen, y xnoj ri jay ri x-an-vi ri c'ulubic. ");
INSERT INTO cak_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tok ri rey xoc-apu richin yerutz'et conojel ri xeroyoj, xutz'et chi c'o jun man rucusan ta ri tziek ri niyo'ox chique ri ye'oyox pa jun c'ulubic. ");
INSERT INTO cak_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Y ri rey xuc'utuj che: Amigo, ¿achel xatiquer xatoc-pe vave' tok man acusan ta ri tziek ri nic'atzin chupan ri c'ulubic? xcha' che. Jac'a ri achok che xch'o-vi ri rey, man jun ch'abel xtiquer xu'ij. ");
INSERT INTO cak_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Jac'ari' tok ri rey xu'ij chique ri rusamajela': Tixima-e ruk'a-rakan ri jun re', y chupan ri más roch' che ri k'eku'n te'ic'aka-vi can. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Roma masque eq'uiy ri ye'oyox, pero xa juba' oc ri xquecha'ox can. Quiri' ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ri achi'a' fariseos xequimolo-qui' juc'an chic, richin niqui'ij chiquivech achique ta niqui'en richin nika ri Jesús pa quik'a' riq'uin ri achique yerutzijoj. ");
INSERT INTO cak_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xequitak-e jujun tzekle'ey quichin rije' y ca'i-oxi' ruvinak ri rey Herodes riq'uin ri Jesús richin xqui'ij che: Tijonel, roj keteman chi rat ja ri kitzij nika chavech, chi pa ruchojmil nac'ut rubey ri Dios, y keteman chi utz man utz jun vinak chavech, rat man najal ta ruchojmil ri kitzij. ");
INSERT INTO cak_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Vacami c'a, ta'ij chike: ¿Nuya' cami lugar ru-ley ri Dios chi nitoj impuesto che ri rey César, o xa manak? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ri Jesús reteman ri itzel ri niquinojij pa cánima. Romari' xu'ij chique: ¿Achique roma nitij ik'ij richin nijo' yika pan ik'a'? Rix xa ca'i' rupalaj ri yixtajin riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu-pe ri méra ri nicuses richin nitoj ri impuesto, xcha' chique. Y rije' xquiya-apu jun denario che. ");
INSERT INTO cak_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jac'ari' ri Jesús xuc'utuj chique: ¿Achok ruvech y achok rubi' re c'o chuvech? xcha'. ");
INSERT INTO cak_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Richin ri rey César, xecha'. Y ri Jesús xu'ij c'a chique: Tiya' che ri César ri can richin vi ri César, y tiya' che ri Dios ri can richin vi ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tok xquic'axaj ri xu'ij ri Jesús, can achique na xquina'. Xa xquiya' can, y xebe. ");
INSERT INTO cak_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chupan ri k'ij ri', ec'o achi'a' saduceos xe'ech'o riq'uin ri Jesús. Ri saduceos man niquinimaj ta chi ri anima'i' xquec'astaj chic, y romari' quire' xquic'utuj che: ");
INSERT INTO cak_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Tijonel, ri Moisés quire' rutz'iban can: Tok c'o jun achi c'o rixayil, pero man jun ralc'ua'l chiri' tok (nicom, niquen) e, nic'atzin chi jun ruchak' o runimal ri ámna nic'ule' riq'uin ri ixok, richin nic'uje' ral ri xa pa rubi' ri na'ey rachijil xtiyo'ox-vi-ka. ");
INSERT INTO cak_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Chikacojol roj c'o jun bey quire' xbanataj: Ec'o vuku' achi'a' quichak'-quinimal qui'. Ri na'ey xc'ule', pero (xcom, xquen) e y man jun ralc'ua'l xc'uje'. Ri rixayil xoc can rixayil ri ruchak'. ");
INSERT INTO cak_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Quiri' mismo xbanataj riq'uin ri ruca'n achi, (xcom, xquen) e chuvech ri ixok, y man jun ralc'ua'l xc'uje'. Ri rox achel xqui'en-e ri ca'i' na'ey tak achi'a', quiri' mismo xu'on-e, y ri ixok c'a xc'uje' na can. Chi vuku' achi'a' quiri' xqui'en-e; ");
INSERT INTO cak_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","y c'a pa ruq'uisbel (xcom, xquen) e ri ixok. ");
INSERT INTO cak_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Rat na'ij chi c'o na jun k'ij xquec'astaj-pe ri anima'i'. Tok xtuka ri k'ij ri', ¿achique chique ri vuku' achi'a' re' xtoc rachijil ri ixok, tok chi vuku' achi'a' xe'oc rachijil? xecha' ri saduceos. ");
INSERT INTO cak_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jac'a ri Jesús xu'ij chique: Rix xa rix satznak riq'uin ri ni'ij, xa man iveteman ta ri nu'ij ruch'abel ri Dios, ni man iveteman ta achique nitiquer nu'on ruchuk'a' ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roma tok xtuka ri k'ij chi ri anima'i' xquec'astaj-e, man xquec'ule' ta chic, ni manak chic xtiquiya' quitzij richin c'ulubic, xa xque'oc achel ru-ángeles ri Dios chicaj. ");
INSERT INTO cak_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero chi ri anima'i' yec'astaj, can yec'astaj-vi. ¿Man ibanon ta c'a leer ri ru'in can ri Dios chive? Rija' nu'ij: ");
INSERT INTO cak_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja yin ru-Dios ri Abraham, ru-Dios ri Isaac y ru-Dios ri Jacob. Roma ri Dios man qui-Dios ta ri manak quic'aslen; rija' qui-Dios ri c'o quic'aslen, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Can achique na xquina' ri ajani quimolon-qui' tok xquic'axaj ruchojmil ruch'abel ri Dios ri achok riq'uin yerutijoj-vi. ");
INSERT INTO cak_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ri achi'a' fariseos cha'anin xquimol-qui' richin niquinojij achique xtiqui'en, tok xquic'axaj chi ri Jesús xutz'apij quichi' ri achi'a' saduceos riq'uin ri xu'ij. ");
INSERT INTO cak_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Y jun chique ri fariseos ri q'uiy reteman chirij ri ley ri xyo'ox che ri Moisés, xaxe richin can ta nika ri Jesús pa ruk'a', quire' xuc'utuj-apu che: ");
INSERT INTO cak_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Tijonel, ¿achique chique ri mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés ri más c'o rakale'n? ");
INSERT INTO cak_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xu'ij che: Ja ri tajo' ri Avajaf Dios riq'uin ronojel avánima, riq'uin ronojel ac'aslen, y riq'uin ronojel ano'oj. ");
INSERT INTO cak_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jari' ri na'ey y ri más c'o rakale'n chique ri mandamientos. ");
INSERT INTO cak_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y ri ruca'n juba' ma junan y quire' nu'ij: Achel najo-ka-avi' rat, quiri' mismo que'ajo' conojel. ");
INSERT INTO cak_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ja ca'i' mandamientos re' ri ocunak ruc'u'x ronojel ri nu'ij chupan ri ley ri xyo'ox che ri Moisés, y ruc'u'x ronojel ri qui'in can ri profetas ojer can, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","C'a quiri' na quimolon-qui' ri achi'a' fariseos chuvech, tok ri Jesús quire' xuc'utuj chique: ");
INSERT INTO cak_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Achique ninojij rix chirij ri Jun ri nitak-pe chucolic rutinamit ri Dios y achok ralc'ua'l? Rije' xqui'ij: Ralc'ua'l ri rey David, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xu'ij chique: Si xaxe choj jun ralc'ua'l ri rey David, ¿achique roma ri David xu'ij Vajaf che? Roma ri David tok uc'uan roma ri Lok'olaj Espíritu, xu'ij: ");
INSERT INTO cak_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Ajaf Dios quire' xu'ij che ri Vajaf: Catz'uye-pe pa nu-derecha C'a ja tok xquenya' chuxe' avakan ri itzel yatquitz'et. Quiri' xu'ij. ");
INSERT INTO cak_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Si ri rey David nu'ij Vajaf che, ¿achique roma ni'ix chi xa choj jun riy-rumam can ri rey David? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun xtiquer xtzolin-apu ruvech rutzij riq'uin ri xuc'utuj chique. Ja k'ij ri' xtiquer-e chi nis-ta jun chic xucovij-ri' richin c'o más xuc'utuj-apu che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jac'ari' tok ri Jesús xch'o chiquivech ri quimolon-qui' riq'uin y chiquivech ri ru-discípulos, y quire' xu'ij: ");
INSERT INTO cak_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ja ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés y ri achi'a' fariseos ri ec'o can pa ruq'uexel ri Moisés richin yixquitijoj. ");
INSERT INTO cak_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Romari' ronojel ri niqui'ij chive, rix tinimaj y tibana'. Pero man ti'en achel niqui'en rije'. Roma rije' niquitzijoj ri ru-ley ri Dios, pero man niquinimaj ta ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Roma rije' can yequitakchi'ij ri vinak chuxe' eka'n ri man juba' ta oc ralal y c'ayef ruc'uaxic, pero rije' nis-ta niquisiloj jun ch'uti ruvi-quik'a' richin niquic'uaj ri eka'n. ");
INSERT INTO cak_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ronojel ri niqui'en, xaxe roma nicajo' chi utz quetz'et coma ri vinak. Roma rije' nic'aj-quivech y chirij tak quik'a' yequiya-apu jun pedazo tz'un ri achok chuvech tz'iban-vi jujun versículo richin ruch'abel ri Dios, y chovon niqui'en-ka che retz'eba'l ri ruchi' tak quitziak. ");
INSERT INTO cak_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Tok ye'oyox richin jun va'in, nika chiquivech chi yetz'uye' pa na'ey tak ch'aquet, y quiri' mismo yequibanala' ri pa tak sinagogas. ");
INSERT INTO cak_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nika chiquivech chi ye'an saludar ri niquimol-vi-qui' ri vinak. Y nika chiquivech ni'ix chique coma ri vinak chi etijonel pa ruvi' ri ley. ");
INSERT INTO cak_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jac'a rix man tirayij chi ni'ix chive chi rix tijonel, roma xaxe Jun ri Kitzij Tijonel. Jac'a rix xa chi'ivonojel junan ivech. ");
INSERT INTO cak_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y man ti'ij katata' che jun vinak vave' choch'ulef roma c'o ruk'ij. Roma xaxe Jun ri Tata'aj pan ivi', y ri' chicaj c'o-vi. ");
INSERT INTO cak_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni man tirayij chi ri vinak niqui'ij uc'uay bey chive. Roma xaxe jun Uc'uay bey c'o, y ri' ja ri Jun ri takon-pe chucolic rutinamit ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ri más c'o ruk'ij chive rix, nic'atzin chi rija' jun ri nito'on ivichin. ");
INSERT INTO cak_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Roma ri niquina-qui' chi can c'o quik'ij, xa xti'an chique chi manak oc quik'ij. Jac'a ri co'ol oc niquina-ka-qui', xa xti'an chique chi c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Pero, ¡tok'ex ivech rix fariseos y rix ri q'uiy iveteman chirij ri ley! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma ik'aton bey chiquivech ri nicajo' ye'oc ruvinak ri aj-chicaj gobierno. Quiri' nin-ij chive roma rix man yixoc ta ruvinak, y ri nicajo' ye'oc ruvinak, man niya' ta lugar chique. ");
INSERT INTO cak_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma jabel yixno' (chubanic, cho'onic) richin c'o nivelek'aj chique ri malcani' tak ixoki'. Nibananej riq'uin ri ye'ibanala' layoj tak oraciones. Romari', más q'uiy castigo xtika pan ivi'. ");
INSERT INTO cak_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma rix nik'asala' ya' y nik'asala' roch'ulef richin ye'icanoj tzekle'ey ivichin, y tok ivilon chic jun ri ikasan chic ránima richin yixrunimaj, xa ni'en che ri vinak ri' chi ca'i' tanto más itzel ruc'aslen que chivech rix, y romari' ja jun rija' ni'e pa k'ak'. ");
INSERT INTO cak_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Tok'ex ivech rix ri nina-ka-ivi' chi rix uc'uay bey! Roma rix ni'ij chi jun vinak ri nuc'uxlaj ri racho ri Dios richin nu'on jurar, man jun nu'on masque man nu'on ta ri nu'ij, yixcha'. Pero si jun vinak nuc'uxlaj ri oro ri c'o pa racho ri Dios richin nu'on jurar, nic'atzin chi nu'on ri nu'ij. Quiri' ri nic'ut rix. ");
INSERT INTO cak_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Xa rix nacanak tak vinak, y xa man yixtzu'un ta, roma, ¿achique ri más c'o rakale'n? ¿Ja ri oro ri c'o pa racho ri Dios o ja ri racho ri Dios ri nibano lok'olaj che ri oro ri c'o chiri'? ");
INSERT INTO cak_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jun chic, rix ni'ij: Ri nic'uxlan ri altar richin nu'on jurar, man jun nu'on masque man nu'on ta ri nu'ij, yixcha'. Jac'a ri nic'uxlan ri sipanic ri nic'uje' pa ruvi' ri altar, nic'atzin chi nu'on ri nu'ij, yixcha'. ");
INSERT INTO cak_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Rix xa man jun ruchojmil ri itzij y xa man yixtzu'un ta, roma, ¿achique ri más c'o rakale'n? ¿Ja ri sipanic o ja ri altar? Ja ri altar ri más c'o rakale'n, roma jari' ri nibano lok'olaj che ri sipanic. ");
INSERT INTO cak_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri nic'uxlan ri altar richin nu'on jurar, man xe ta ri altar nuc'uxlaj, xa ja jun ri sipanic ri nisuj pa ruvi' ri altar. ");
INSERT INTO cak_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri nic'uxlan racho ri Dios richin nu'on jurar, man xe ta ri jay nuc'uxlaj, xa ja jun ri rajaf ri jay. ");
INSERT INTO cak_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri nic'uxlan ri caj richin nu'on jurar, nuc'uxlaj ri lok'olaj rutz'uyubal ri Dios, y ri Dios ri tz'uyul chupan. ");
INSERT INTO cak_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma hasta ronojel quivech ichaj achel ri alavina, ri anís y ri comino nivajlaj cakan richin nivelesaj ri diezmo riq'uin, richin niya' che ri Dios. Pero xa iyo'on can juc'an ri más nic'atzin ri nu'ij chupan ri ley, chi rix choj quiq'uin ri vinak, chi yixpokonan, y chi cukul ic'u'x riq'uin ri Dios. Ja ta re' ri más utz chi ibanon-pe, y man tiya' can rubanic re yixtajin riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rix ni'ij chi rix uc'uay bey, y xa man yixtzu'un ta. Xa rix achel jun vinak ri man nrojo' ta nubik'-ka jun us, pero nis-ta nuna'ej tok nubik'-ka jun camello. ");
INSERT INTO cak_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma xa rix achel jun vaso o jun lak ri jabel ch'ajch'oj rij, jac'a ri rupan xa ch'abak. Can nic'ut-ivi' chi rix choj riq'uin ri ni'en, jac'a pan ivánima, xa nojnak elak' y ri man choj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rat ri rat fariseo, xa man yatzu'un ta. Na'ey tabana' ch'ajch'oj che ri avánima, richin quiri' ja jun ri achique na'an, ch'ajch'oj xtitz'etetaj. ");
INSERT INTO cak_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma ri ivánima nojnak riq'uin ronojel ri netzelan, xa rix achel panteones ri jabel ok'oman quij, romari' ch'ajch'oj yek'alajin, jac'a ri quipan, xa nojnak riq'uin quibakil anima'i'. ");
INSERT INTO cak_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Quiri' ri nibananej rix chiquivech ri vinak, achel can choj ri ic'aslen. Pero xa ca'i' rupalaj ri yixtajin riq'uin y ri ivánima xa nojnak riq'uin ri mac ri ye'irayij. ");
INSERT INTO cak_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos! Can ivichin vi chi ca'i' rupalaj ri yixtajin riq'uin. Roma ye'ibanala' rubanic quivi' ri lugar ri emukul-vi ri profetas, y ye'ivik quivi' ri lugar ri emukul-vi ri chojmilaj tak ralc'ua'l ri Dios, ");
INSERT INTO cak_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","y quire' ni'ij: Xa ta roj xojc'uje' pa qui-tiempo ri kati't-kamama', man ta junan katzij xka'an quiq'uin rije' richin xequicamisaj ri profetas, yixcha'. ");
INSERT INTO cak_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero riq'uin ri quiri' ni'ij, iyon nic'ut-ka-ivi' chi xiq'uen can quino'oj ri xecamisan quichin ri profetas. ");
INSERT INTO cak_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tiq'uisa' c'a rubanic ronojel quino'oj ri quic'utun can rije' chivech. ");
INSERT INTO cak_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Rix xa rix achel itzel tak cumatz. Manak che'el xticol-ivi' chuvech ri k'ak', xa c'a chiri' xquixeka-vi. ");
INSERT INTO cak_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Roma c'a ri', richin nik'alajin-pe ri itzel tak ino'oj, chi'icojol rix yentak ri xqueyo'on rutzijol ri nin-ij-pe pa cánima, yentak achi'a' c'o runo'oj ri Dios quiq'uin, y yentak achi'a' q'uiy queteman chirij ri ley. Pero ec'o chique rije' xque'ibajij chuvech cruz, ec'o xque'icamisaj, y ec'o xque'ich'ey ri pa tak i-sinagoga, y xquixbe chiquicanoxic ri pa tak tinamit richin ni'en pokon chique. ");
INSERT INTO cak_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Quiri' xti'en, richin quiri' pan ivi' rix nika-vi ralal quicamic conojel ri chojmilaj tak vinak ri ecamisan-e choch'ulef. Nitiquer-pe riq'uin rucamic ri chojmilaj achi Abel, y hasta numaj rucamic ri jun ruc'ajol ri Berequías rubinan Zacarías ri xcamises coma ri ivati't-imama' chucojol ri altar y ri racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kitzij nin-ij chive chi ja pan ivi' rix xtika-vi ralal ronojel ri camic re', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jac'ari' tok ri Jesús xu'ij: ¡Aj-Jerusalem! ¡Aj-Jerusalem! Rix ri ye'icamisaj ru-profetas ri Dios y ye'ic'akala' che abaj ri yerutak ri Dios chi'icojol, yin q'uiy (mul, paj) xinjo' xixinmol achel nu'on jun ec' chique ri ch'utik ral, yerumol chuxe' ruxic', pero rix man xijo' ta. ");
INSERT INTO cak_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vacami c'a, ri itinamit xtixutux can roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quiri' nin-ij chive, roma rix man xquinitz'et ta chic, c'a chupan ri k'ij tok quire' xti'ij: ¡Nimalaj favor c'o pa ruvi' re petenak pa rubi' ri Ajaf! xquixcha' chuve, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Tok ri Jesús xel-pe pa racho ri Dios y ja ni'e chiri', ri ru-discípulos xejel-apu riq'uin richin niquic'ut chuvech ri jalajoj jay richin ri racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jac'a rija' xu'ij chique: Ronojel ri nitz'et rix vave', yin kitzij nin-ij chive chi c'o na jun k'ij tok man jun chic abaj xtic'uje' can pa ruvi' jun chic abaj ri man ta xquevulutaj-pe, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tok ri Jesús tz'uyul chorak'aric che ri juyu' Olivos, ri ru-discípulos xejel-apu quiyon riq'uin y xquic'utuj che: Ta'ij chike, ¿achique tiempo xquebanataj ri xa'ij-ka chirij racho ri Dios? Y, ¿achique retal xtik'alajin richin nina'ex chi rat yape chic jun bey y chi nuka yan ri ruq'uisbel k'ij richin ri tiempo ri rojc'o-vi? Quiri' ri xquic'utuj che. ");
INSERT INTO cak_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y ri Jesús xu'ij chique: Rix tibana' cuenta ivi' richin man jun tisatzo ino'oj. ");
INSERT INTO cak_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Roma c'o q'uiy xquepe ri xtiquik'ebaj-qui' chirij ri nubi' yin, y xtiqui'ij: Ja yin ri Jun ri yin takon-pe chucolic rutinamit ri Dios, xquecha'. Y eq'uiy ri xtisatz quino'oj pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Xtivac'axaj chi yetajin guerras pa ruvi' ri roch'ulef, y xtivac'axaj rutzijol chi nitiquer-pe más guerra. Pero man tisatz ivánima, roma nic'atzin chi can yebanataj na vi ronojel re'. Pero man ja yan ta ri' ri k'ij tok nitz'akat ronojel ri runojin ri Dios chi nibanataj choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Roma ec'o tinamit xquecataj chiquij ch'aka' chic tinamit. Ec'o reyes xquequitak soldados chiquij ch'aka' chic reyes. Xquepe yabil, vayijal y cobrakan xa achique na lugar pa ruvi' ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ronojel re' xaxe yan jun tz'ucubel richin ri k'axomal choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Chupan tak ri k'ij ri', rix xquixjach pa quik'a' vinak richin nik'asaj k'axomal, y xquixcamises. Itzel xquixtz'et coma conojel vinak roma iniman ri nubi' yin. ");
INSERT INTO cak_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ri tiempo ri' eq'uiy xquetzak, y chiquivech ka rije' mismo xquequijach-qui' pa quik'a' vinak, y xa itzel xtiquitz'etela-ka-qui' chiquivech. ");
INSERT INTO cak_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Xquek'alajin-pe eq'uiy ri xtiquik'ebaj-qui' chi eyo'ol rubixic ri nu'ij-pe ri Dios pa cánima, y eq'uiy ri xtisatz quino'oj pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Y roma xtiq'uiyer ri itzel tak no'oj pa ruvi' ri roch'ulef, eq'uiy chique ri tzekle'ey vichin xtich'ich'ur-ka ri cánima chi ye'ojo'on. ");
INSERT INTO cak_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Jac'a ri cof xtic'uje' chirakan ri Dios c'a pa ruq'uisbel, can xticolotaj-vi. ");
INSERT INTO cak_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y pa ruvi' ronojel ri roch'ulef xtitzijos-vi re utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar, richin chi conojel ye'ac'axan. Y c'ajari' xtuka ri ruq'uisbel k'ij richin ri tiempo ri rojc'o-vi. ");
INSERT INTO cak_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Roma c'a ri', tok xtitz'et chi chupan ri lok'olaj lugar ja najin ri ru'in can ri profeta Daniel tok xu'ij chi xtibanataj camic tak ch'o'oj ri jani na itzel chuvech ri Dios, ri nibano leer re', (tik'ax, tino') c'a chuvech, ");
INSERT INTO cak_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","jac'ari' tok ri ec'o pa Judea que'enimaj-e pa tak juyu'. ");
INSERT INTO cak_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri c'o-e pa terraza che ri racho, man chic tika-pe richin c'o neruc'ama-pe ri pa jay. ");
INSERT INTO cak_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri nisamaj pa juyu', man chic titzolij-pe chiracho chuc'amic jun rutziak. ");
INSERT INTO cak_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Pero tok'ex quivech ri ixoki' ri quiri' quibanon, y ri ixoki' ri c'a yetz'uman na ac'ola' chiquik'a' chupan tak ri k'ij ri'. ");
INSERT INTO cak_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Jac'a rix tic'utuj che ri Dios chi tok xtic'atzin chi yixenimaj-e, man chupan ta ru-tiempo tef, ni man chupan ta jun sábado ri k'ij richin uxlanen. ");
INSERT INTO cak_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Roma chupan tak ri k'ij ri' xtipe nimalaj k'axomal pa ruvi' ri roch'ulef ri man jun bey quiri' banatajnak xe tok banon can roma ri Dios c'a vacami, y nis-ta xtibanataj chic jun k'axomal quiri'. ");
INSERT INTO cak_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Si man ta ni'an co'ol che ri tiempo richin ri k'axomal ri', man jun nic'ase' can. Pero coma ri echa'on roma ri Dios, xti'an co'ol che ri tiempo ri'. ");
INSERT INTO cak_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan tak ri k'ij ri', xa achique na jun ri quire' xtu'ij chive: Titz'eta', jare' ri Jun ri takon-pe chucolic rutinamit ri Dios, o si xtu'ij chive: Titz'eta', ja c'o chila', xticha', rix man tinimaj ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Roma ec'o vinak xquecataj-pe ri xtiquik'ebaj-qui' chi ja rije' ri etakon-pe chucolic rutinamit ri Dios, y ec'o xtiquik'ebaj-qui' chi eyo'ol rubixic ri nu'ij-pe ri Dios pa cánima, y xtiquibanala' nimalaj tak retal y xquequibanala' ri man jun bey etz'eton. Y riq'uin ri quiri' niqui'en, xtiquisetz quino'oj ri vinak, y xa ta yetiquer, hasta ri echa'on chic roma ri Dios yequisetz. ");
INSERT INTO cak_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Titz'eta' c'a ivi', yin ja xinya' can rutzijol chive. ");
INSERT INTO cak_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Roma c'a ri', si c'o xque'in chive: Jo' pa chakijlaj tz'iran ulef, roma quila' c'o-vi ri Jun ri nitak-pe chucolic rutinamit ri Dios, xquixuche'ex, man quixbe. Y si xti'ix chive: Jo', katz'eta', roma ja ruyonin-ri' chila' pa jun cuarto, xquixuche'ex, rix man tinimaj. ");
INSERT INTO cak_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Roma can achel ri coyopa' nik'alajin ri achique lugar ntel-vi-pe ri k'ij y nek'alajin hasta achique lugar nika-vi-ka ri k'ij, quiri' yin ri xitak-pe richin xinalex chi'icojol tok xquipe chic jun bey, xa chiquivech conojel xquik'alajin-vi. ");
INSERT INTO cak_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Y xtibanataj achel nibanataj quiq'uin ri c'uch. Roma xa achique na lugar c'o-vi jun cuerpo caminak, chiri' yeka-vi ri chicop ri'. ");
INSERT INTO cak_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Tok c'a ja oc yek'ax-ka ri k'axomal richin tak ri k'ij ri', ri k'ij xtik'uk'umer ruvech, ri ic' man xtitzu'un ta chic, ri ch'umila' xquetzak-e chuvech ri rocaj, y ronojel ri nimalaj tak uchuk'a' ri erichin chicaj xquesilon. ");
INSERT INTO cak_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jac'ari' tok chila' chicaj xtitz'etetaj vetal yin ri xitak-pe richin xinalex chi'icojol. Conojel quivech vinak choch'ulef xtitiquer-pe ruk'axon cánima tok xquinquitz'et yin ri xitak-pe richin xinalex chi'icojol, chi riq'uin uchuk'a' y nimalaj nuk'ij yin petenak pa ruvi' sutz' ri chicaj. ");
INSERT INTO cak_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Xquentak ri nu-ángeles riq'uin nimalaj rukul trompeta chiquimolic ri enucha'on chic. Chi naj chi nakaj chuvech ri rocaj xquebe-vi; c'a juc'an chic ruchi', hasta ri jun chic ruchi'. ");
INSERT INTO cak_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Tivelesaj ejemplo chirij ri che' higo. Tok ja yejotayin-pe ri ruk'a' y ye'el-pe c'ac'ac' tak ruxak, rix iveteman chi nuka yan ru-tiempo ri job. ");
INSERT INTO cak_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Quiri' mismo, tok xtitz'et chi yebanataj chic ronojel ri xin-ij yan ka chive, tivetemaj chi nakaj chic yinc'o-vi-pe, achel xa chuchi' chic jay. ");
INSERT INTO cak_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kitzij nin-ij chive chi ronojel re' xtibanataj tok ri vinak richin ri vacami c'a man jani queq'uis-e choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ri roch'ulef y ri caj can xqueq'uis na vi, pero ri nuch'abel man xtiq'uis ta, xa can xquebanataj-vi ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jac'a ri k'ij y ri hora chi yin xquipe, man jun etemayon, nis-ta ri ángeles ri erichin chicaj; xaxe ri Nata' ri reteman. ");
INSERT INTO cak_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Roma achel ri yetajin ri vinak pa ru-tiempo ri Noé, quiri' mismo tok xquipe chic yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roma chupan ri tiempo na'ey chi xu'on ri camic job, ri vinak ja pa ruvi' ri va'in, ri kumuj ya', ri yec'ule' y ri yequiyala' quimi'al pa c'ulubic benak-vi ri cánima, y c'a quiri' na yetajin tok ri Noé xoc chupan ri arca. ");
INSERT INTO cak_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Man juba' xquinojij ri achique petenak pa quivi', c'a xtiquer na pe ri camic job ri xerekaj-e conojel. Quiri' mismo tok xquipe chic yin ri xitak-pe richin xinalex chi'icojol, ri vinak man juba' xtiquinojij ri achique petenak pa quivi'. ");
INSERT INTO cak_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chupan ri tiempo ri' xtibanataj chi eca'i' junan yesamaj pa juyu', jun xtuc'uax-e y ri jun chic xtiyo'ox can. ");
INSERT INTO cak_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Eca'i' ixoki' junan yeque'en, jun xtuc'uax-e y ri jun chic xtiyo'ox can. ");
INSERT INTO cak_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Roma c'a ri', quinivoyo'ej-apu, roma man iveteman ta achique hora xquipe yin ri Ivajaf. ");
INSERT INTO cak_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Tivac'axaj c'a ri nin-ij chive: Xa ta jun tata'aj reteman achique hora ntoc-apu jun elek'on pa racho, can ta nic'ase', y man ta nuya' lugar chi ni'an-e elak' ri pa racho. ");
INSERT INTO cak_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Roma c'a ri', quixc'ase', roma yin ri xitak-pe richin xinalex chi'icojol xquipe chupan ri hora tok man jun yan achique inojin chiri'. ");
INSERT INTO cak_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Roma jun samajinel ri jabel ninojin y can nu'on-apu ronojel ri bin can che, ja samajinel ri' xtucha' ri rajaf richin nuya' can pa quivi' ri ch'aka' chic samajela' richin yerutzuk-apu tok nril ri hora. ");
INSERT INTO cak_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Utzulaj tzij che ri samajinel ri najin riq'uin ri samaj ri bin can che tok nitzolij-pe ri rajaf. ");
INSERT INTO cak_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can kitzij nin-ij chive chi ri rajaf nujach ronojel ri c'o riq'uin pa ruk'a' ri samajinel ri', richin nuchajij. ");
INSERT INTO cak_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero si ri samajinel ri' man utz ta runo'oj nu'on-ka, y xa quire' nu'ij-ka pa ránima: Ri vajaf ri' xa man jani tuka, nicha-ka, ");
INSERT INTO cak_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y nutz'uc quich'eyic ri ch'aka' chic samajela' y xe va'in y tijoj-ya' nu'on quiq'uin ri k'abarela', ");
INSERT INTO cak_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","xtipe ri rajaf chupan ri k'ij y ri hora tok ri samajinel man jun runa'en chiri', ");
INSERT INTO cak_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","y camic chi ch'eyoji'l xtu'on che ri samajinel, y xtuya-apu chiquicojol ri vinak ca'i' rupalaj ri yetajin riq'uin. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chupan ri tiempo tok xquipe chic yin ri xitak-pe richin xinalex chi'icojol, chupan ri aj-chicaj gobierno xtibanataj achel xbanataj quiq'uin lajuj xtani' ri xquic'uaj qui-candil chiquijununal richin necoyo'ej ri ala' ri xtic'ule'. ");
INSERT INTO cak_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Vo'o' chique ri xtani' ri' niquinojij utz ri achique niqui'en. Jac'a ri vo'o' chic, man juba' niquinojij ri achique niqui'en. ");
INSERT INTO cak_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri vo'o' xtani' ri man juba' niquinojij ri achique niqui'en, tok xebe richin necoyo'ej ri ala' ri xtic'ule', xquic'uaj-e qui-candil pero man xquic'uaj ta yacabel aceite. ");
INSERT INTO cak_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jac'a ri vo'o' chic xtani' ri niquinojij utz ri achique niqui'en, xquic'uaj qui-candil y ch'aka' chic yacabel nojnak-e riq'uin aceite. Xebe c'a richin necoyo'ej ri ala' ri xtic'ule'. ");
INSERT INTO cak_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Jac'a ri ala' ri nic'ule' xa man jun nuka, romari' ri lajuj xtani' xa xpe quivaran. Na'ey xe (yevixcu'r, ye'uxcurulan), y c'ajari' xever-ka jumul. ");
INSERT INTO cak_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pero pa nic'aj ak'a' chiri', jari' tok xc'axataj jun kulaj ri riq'uin ruchuk'a' nu'ij: ¡Ja petenak ri ala' ri xtic'ule'. Tibana' ibanic y quixel-pe chuc'ulic! ");
INSERT INTO cak_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Jac'ari' junanin xecataj conojel ri xtani' ri coyo'en ri ala' ri xtic'ule', y xquibanala' rubanic ri qui-candil. ");
INSERT INTO cak_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ri vo'o' xtani' ri man juba' niquinojij ri achique niqui'en, xqui'ij chique ri vo'o' chic: Tiya' juba' ivaceite chike, roma ri ka-candil roj xa ye'echup, roma xa man q'uiy ta chic aceite c'o chupan, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Jac'a ri vo'o' xtani' ri yenojin utz, xqui'ij chique: Richin chi roj man neq'uis ri kaceite, y nis-ta rix man neq'uis ri ivaceite, más utz quixbin quiq'uin ri yec'ayin aceite, y te'ilok'o' ivichin chique, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","C'a ja ebenak ri vo'o' xtani' chulok'ic ri aceite, jari' tok xuka ri ala' ri xtic'ule'. Ri vo'o' chic xtani' ri yenojin utz, junan xe'oc-apu riq'uin ri ala' ri achique lugar ni'an-vi ri c'ulubic. Y xtz'apitaj c'a ri puerta. ");
INSERT INTO cak_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jari' tok xetzolij-pe ri vo'o' chic xtani' ri ebenak chulok'ic aceite, xech'o c'a apu chuchi' ri puerta y quire' xqui'ij-apu: ¡Rat aj-c'ulubel, tabana' favor, tajaka' ri puerta chikavech! xecha-apu. ");
INSERT INTO cak_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Jac'a rija' quire' xu'ij-pe chique: Kitzij nin-ij chive chi yin man veteman ta ivech, xcha-pe. ");
INSERT INTO cak_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Roma c'a ri', yin, xcha' ri Jesús, nin-ij chive chi quinivoyo'ej-apu, roma man iveteman ta achique k'ij, achique hora tok xquipe chic jun bey yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Quiri' nin-ij chive roma chupan ri aj-chicaj gobierno nibanataj achel xu'on jun cajaf samajela' na'ey chi xbe naj. Xeroyoj ri rusamajela' y xuya' can ri rubeyomal pa quik'a' richin niquisamajij. ");
INSERT INTO cak_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa ruk'a' jun xuya' can vo'o' ruvech méra ri ni'ix talento chique, pa ruk'a' jun chic xuya' can ca'i', y pa ruk'a' jun chic xuya' can jun, achel xutz'et rija' chi yetiquer niquisamajij chiquijununal. C'ajari' xbe naj. ");
INSERT INTO cak_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ri samajinel ri yo'on can vo'o' talento pa ruk'a' richin tusamajij, can xu'on-vi ri bin can che, y xuch'ec chic vo'o' chirij. ");
INSERT INTO cak_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Quiri' mismo ri jun chic samajinel ri yo'on can ca'i' talento pa ruk'a', xuch'ec chic ca'i' chirij. ");
INSERT INTO cak_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jac'a ri rox samajinel ri xe oc jun talento yo'on pa ruk'a', xa xuc'ot jun jul pan ulef y chiri' xumuk-vi ri ruméra ri rajaf. ");
INSERT INTO cak_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Tok k'axnak chic q'uiy tiempo, c'ajari' xtzolij-pe cajaf ri samajela' y xuc'utuj chique chiquijununal ri achique quibanon riq'uin ri méra ri ruyo'on can pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tok (xapon, xebos) ri samajinel ri yo'on can vo'o' talento pa ruk'a', rija' ruc'uan chic apu vo'o' talento más, y quire' xu'ij-apu: Vajaf, jare' ri vo'o' talento ri ayo'on can pa nuk'a', pero yin xinch'ec chic vo'o' más pa ruvi', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ri rajaf xu'ij che ri samajinel: Utz ri xa'an. Rat jun utzulaj samajinel ri can na'an ri ni'ix chave. Riq'uin ri utz rucusasic xa'an ri juba' xinya' can pan ak'a', vacami yatinya' pa ruvi' más q'uiy. Catampe, caquicot junan viq'uin yin ri Avajaf, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tok (xapon, xebos) ri samajinel ri yo'on can ca'i' talento pa ruk'a', rija' quire' xu'ij-apu: Vajaf, jare' ri ca'i' talento ri ayo'on can pa nuk'a', pero yin xinch'ec chic ca'i' más pa ruvi', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri rajaf xu'ij che: Utz ri xa'an. Rat jun utzulaj samajinel ri can na'an ri ni'ix chave. Riq'uin ri utz rucusasic xa'an ri juba' xinya' can pan ak'a', vacami yatinya' pa ruvi' más q'uiy. Catampe, caquicot junan viq'uin yin ri Avajaf, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jac'a tok (xapon, xebos) ri samajinel ri yo'on can jun talento pa ruk'a', quire' xu'ij-apu: Vajaf, yin veteman chi rat, rat jun vinak ri man napokonaj ta quivech ri asamajela', y can najo' nac'ol ruvech tico'n ri xa mana-ta rat xasamajin, y najo' yach'acon chirij ri mana-ta rat rat tiquiyon-ka. ");
INSERT INTO cak_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Romari' yin xinxi'ij-vi' chi xinsamajij ri talento ri ayo'on can pa nuk'a'. Xa xinc'ot jun jul pan ulef y chiri' xinmuk-vi. Vacami c'a, jare' ri ayo'on can pa nuk'a', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Jac'a ri rajaf xu'ij che: Rat xa rat jun itzel samajinel, y xe k'oral avoma. Rat na'ij chi yin man ninpokonaj ta quivech ri nusamajela', y can ninjo' ninc'ol ruvech tico'n ri xa mana-ta yin xisamajin, y ninjo' yich'acon chirij ri mana-ta yin yin tiquiyon-ka. ");
INSERT INTO cak_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Si rat quiri' na'ij, ¿achique roma man xaya' ta ri numéra pa banco? Richin quiri' ri xinuka vacami, ja ta xinc'ul ri numéra, y ri ajani ruch'acon-pe. ");
INSERT INTO cak_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vacami c'a, tic'ama' can ri talento che, y tiya' che ri nusamajinel ri c'o lajuj riq'uin. ");
INSERT INTO cak_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Roma xa achique na ri utz rusamajisic nu'on che ri yo'on can pa ruk'a', xtuc'ul más, richin más q'uiy xtu'on-ka riq'uin. Jac'a ri man nusamajij ta ri juba' yo'on can pa ruk'a', hasta ri juba' c'o riq'uin neleses che. ");
INSERT INTO cak_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri samajinel ri man jun utz nunojij, chupan ri más roch' che ri k'eku'n te'ic'aka-vi can. Chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj. ");
INSERT INTO cak_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Tok xtipe chic jun bey ri Jun ri xtak-pe richin xalex chiquicojol ri vinak, xtipe riq'uin nimalaj ruk'ij, y conojel ri lok'olaj tak ángeles xquepe riq'uin. Rija' xtitz'uye' c'a pa rutz'uyubal ri c'o nimalaj ruk'ij. ");
INSERT INTO cak_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Xquemol c'a apu conojel vinak chuvech, y rija' xtujach quivech, achel nu'on jun yuk'unel. Juc'an yeruya-vi ri ovejas, y juc'an chic yeruya-vi ri cabras. ");
INSERT INTO cak_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri ovejas xqueruya' pa ru-derecha, jac'a ri cabras xqueruya' pa ru-izquierda. ");
INSERT INTO cak_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y ri Rey xtu'ij c'a chique ri ec'o pa ru-derecha: Vacami c'a, rix ri yo'on ri ru-favor ri Nata' Dios chive, quixampe, tibana' ivichin che ri achique lugar nu'on-vi gobernar rija', ri can ivichin vi rix rubanon rubanic xe tok x-an ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Roma tok yin xivayijan, rix xinitzuk. Tok yin xinna' chakij-chi', xiya' nuya'. Masque naj yin petenak-vi, xic'ul nuvech pan ivacho. ");
INSERT INTO cak_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tok xq'uis-ka nutziak, xiya' nutziak. Tok yin xiyavej, xinichajij. Tok xitz'ape' pa cárcel, xine'itz'eta' richin xiya' ruchuk'a' ri vánima, xticha' ri Rey. ");
INSERT INTO cak_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jac'a ri xquic'uaj jun chojmilaj c'aslen, tok xtiquic'axaj quiri', xtiqui'ij: Ajaf, ¿achique c'a k'ij ri' tok rat xavayijan y xatkatzuk, o xkaya' aya' roma xana' chakij-chi'? ");
INSERT INTO cak_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y achique c'a k'ij ri' tok rat petenak naj y xkac'ul avech pa kacho, o manak chic atziak y roj xkaya' atziak? ");
INSERT INTO cak_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Y achique c'a k'ij ri' tok rat xayavej y xatkachajij, o xekaya' ruchuk'a' ri avánima pa cárcel? xquecha' rije'. ");
INSERT INTO cak_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey xtu'ij chique: Yin kitzij nin-ij chive, chi riq'uin xito' jun chique ri más manak oc ruk'ij chiquicojol conojel ri yin quiniman, junan nu'ij chi chuve yin xi'en-vi ri favor, xticha' ri Rey. ");
INSERT INTO cak_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Jac'a chique ri ec'o pa ru-izquierda, ri Rey xtu'ij: Rix, ri can richin vi chi nika castigo pan ivi', quixel-e chinuvech. Vacami xquixbe chupan ri k'ak' ri man jun bey xtichup, ri can richin vi ri itzel y ri ru-ángeles banon. ");
INSERT INTO cak_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Roma tok yin xivayijan, man xinitzuk ta; tok xinna' chakij-chi', man juba' nuya' xisipaj. ");
INSERT INTO cak_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tok naj yin petenak-vi, man xic'ul ta nuvech pan ivacho. Tok xq'uis-ka nutziak, man xiya' ta jun chic nutziak. Tok xiyavej, man xine'itz'eta' ta. Tok xic'uje' pa cárcel, man xe'iya' ta ruchuk'a' ri vánima. Quiri' xtu'ij ri Rey chique. ");
INSERT INTO cak_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Jac'ari' tok rije' quire' xtiqui'ij che: Ajaf, roj man jun bey xatkatz'et chi yavayijan, o chi c'o achakij-chi', o chi naj rat petenak-vi richin nic'atzin avacho, o can ta xq'uis-ka atziak jumul, o xayavej, o can ta ratc'o pa cárcel. Roj man jun bey xatkatz'et chi quiri' xak'asaj, y romari' man jun favor xka'an chave, xquecha'. ");
INSERT INTO cak_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Jac'ari' tok ri Rey xtu'ij chique: Yin kitzij nin-ij chive chi roma man jun favor xi'en che jun chique ri más manak oc quik'ij chiquicojol ri yin quiniman re', junan nu'ij chi chuve yin man jun favor xi'en, xticha' chique. ");
INSERT INTO cak_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ri man jun favor xqui'en re', can xquebe-vi chupan ri castigo ri richin jumul. Jac'a ri xquic'uaj jun chojmilaj c'aslen chuvech ri Dios, xtiquil ri c'aslen ri richin jumul. Quiri' xu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tok ri Jesús ru'in chic ka ronojel ri', quire' xu'ij chique ri ru-discípulos: ");
INSERT INTO cak_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Rix iveteman chi pa ca'i' k'ij apu nkunimak'ijun pa kanimak'ij pascua. Chiri', yin ri xitak-pe richin xinalex chi'icojol xquijach-e richin yibajix chuvech cruz, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jac'a ri nima'k tak quik'ij sacerdotes israelitas, ri achi'a' q'uiy queteman chirij ri ley y ri nima'k quijuna' achi'a' c'o quik'ij chiquicojol ri quivinak, ja hora ri' quimolon-qui' chojay richin ri racho ri nimalaj sacerdote rubinan Caifás. ");
INSERT INTO cak_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Rije' niquicanola' achique niqui'en richin can ta che'elek'el nika ri Jesús pa quik'a' richin niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero niqui'ij chiquivech chi mana-ta chupan ri nimak'ij tok (xtiquitz'om, xtiquichop), richin man quecataj ri tinamit. ");
INSERT INTO cak_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ri Jesús pa Betania c'o-vi chiracho jun achi rubinan Simón, ri ni'ix leproso che roma ri itzel tak ch'a'c chirij. ");
INSERT INTO cak_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Tok ri Jesús tz'uyul-apu chuchi' ri mesa, jari' xoc-apu jun ixok ruc'amon-apu jun yacabel banon che jun abaj rubinan alabastro. Ri yacabel nojnak riq'uin jun jubulaj ak'on ri jani na rajil, y ri ixok (xuk'ej, xuk'ij) ri ak'on pa (rujolon, ruvi') ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tok ri discípulos xquitz'et ri x-an che ri ak'on, xpe coyoval y xquibila': ¿Achique roma xaxe quiri' xtix-e la jubulaj ak'on la'? ");
INSERT INTO cak_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Roma c'o ta che'el xc'ayix chi nimalaj rajil y ri méra xjach ta chiquivech ri man jun oc quichajin, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jac'a ri Jesús xa reteman ri niquibila' ri ru-discípulos, romari' xu'ij chique: ¿Achique roma ninak ri ixok re' tok rija' xa jun utzulaj favor ri xu'on chuve? ");
INSERT INTO cak_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri man jun oc quichajin, xa jumul ec'o chi'icojol, jac'a yin man jumul ta xquic'uje' iviq'uin. ");
INSERT INTO cak_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ri ixok re' riq'uin ri xuya' ri jubulaj ak'on re' chirij ri nu-cuerpo, richin numukic xu'on. ");
INSERT INTO cak_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yin kitzij nin-ij chive, chi xa achique na lugar pa ruvi' ri roch'ulef xtitzijos-vi re utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, chiri' xtitzijos-vi ri favor ri xu'on ri ixok re', richin c'uxle'el richin rija', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jac'ari' tok ri Judas Iscariote, jun chique ri doce ru-discípulos ri Jesús, xbe quiq'uin ri nima'k tak quik'ij sacerdotes israelitas. ");
INSERT INTO cak_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Rija' quire' xu'ij chique: Si yin ninjach ri Jesús pan ik'a', ¿achique niya' chuve? xcha' chique. Y rije' xqui'ij chi niquiya' treinta ruvech méra ri banon riq'uin plata che. ");
INSERT INTO cak_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Jac'ari' tok ri Judas nucanoj rubeyal achique ta nu'on richin nujach ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chupan ri na'ey k'ij richin ri nimak'ij tok nitij ri pan manak levadura riq'uin, ri discípulos xejel-apu riq'uin ri Jesús, y xquic'utuj che: ¿Achique lugar najo' na'an-vi ri va'in chupan ri pascua re', richin nekabana' rubanic ronojel ri nic'atzin? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Rija' quire' xu'ij-e chique ri discípulos: Quixbin pa tinamit Jerusalem, chiracho jun ri quire-quire' rubi', y ti'ij che: Ri Tijonel quire' ru'in-pe: Ri k'ij richin yinel-e chi'icojol xa nakaj chic c'o-vi, y pan avacho ninjo' nin-en-vi ri va'in richin ri pascua quiq'uin ri nu-discípulos, quixcha' che. ");
INSERT INTO cak_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri discípulos can xequibana-vi ri achel xu'ij-e ri Jesús chique, y xqui'en rubanic ronojel ri xtic'atzin chique chupan ri va'in richin ri pascua. ");
INSERT INTO cak_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jac'a tok xk'ok'a-ka chupan ri k'ij ri', ri Jesús xtz'uye-apu chuchi' mesa junan quiq'uin ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Tok ja yeva' chiri', ri Jesús xu'ij: Kitzij nin-ij chive, chi jun chive rix xquijacho-e pa quik'a' ri vinak, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tok ri discípulos xquic'axaj ri xu'ij ri Jesús, xpe bis pa cánima. Rije' chiquijununal quire' xquic'utuj-apu che: ¿La yin cami xquibano quiri', Ajaf? xecha'. ");
INSERT INTO cak_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús xu'ij chique: Ja ri jun ri nuya-pe ruk'a' viq'uin chupan re lak, jari' ri xtijacho-e vichin. ");
INSERT INTO cak_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Can kitzij na vi chi yin ri xitak-pe richin xinalex chi'icojol xquicamises, roma can quiri' vi tz'iban can chupan ruch'abel ri Dios. Pero, ¡tok'ex ruvech ri xtijacho-e vichin! Xa más utz che man ta xalex, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jac'ari' xch'o-apu ri Judas, ri xtijacho-e richin, y xu'ij: Tijonel, ¿ja cami yin xquibano quiri'? xcha'. Ja rat mismo ya'in, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ja yeva' chiri' tok ri Jesús xuq'uen-apu ri pan richin ri pascua y xumatioxij che ri Dios. Xuper c'a, xuya' chique ri ru-discípulos, y xu'ij: (Titz'ama', tichapa') y titija' ri pan re', roma jare' ri nu-cuerpo. ");
INSERT INTO cak_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jari' xuq'uen-apu ri vaso richin ri pascua, y tok rumatioxin chic che ri Dios, xuya' chique, y xu'ij: Tikumu' juba' chi'ivonojel, roma ri c'o chupan ri vaso re', ");
INSERT INTO cak_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","c'uxle'el richin ri nuquiq'uel ri xtibin richin nic'achoj ri c'ac'ac' ruvujil c'aslen ri nusuj ri Dios. Can xtibin-vi ri nuquiq'uel coma eq'uiy, richin xti'an perdonar ri quimac. ");
INSERT INTO cak_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Y yin nin-ij chive chi ja vacami nitiquer-e chi man chic xtinkum ta re ruya'al-uva re', c'a terila' na ri k'ij tok junan iviq'uin xtikakum chupan ri ru-gobierno ri Nata' Dios, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Tok xquibixaj yan ri bix richin ri pascua, ri Jesús y ri ru-discípulos xe'el-e chiri' pa jay y xebe ri pa juyu' Olivos. ");
INSERT INTO cak_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Tok ebenak pa bey, ri Jesús xu'ij chique ri ru-discípulos: Chi'ivonojel rix caca' ic'u'x xquinixutuj can chupan ri ak'a' re'. Roma ri tz'iban can nu'ij: Tok yin xtinya' lugar chi xticamises ri Yuk'unel, ri ovejas xa xtiquirex-e quivech. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero tok yin c'astajnak chic pe chiquicojol ri anima'i', xquinabeyaj-e chivech chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Jac'a ri Pedro quire' c'a xu'ij-apu che: Masque conojel caca' quic'u'x xcatquixutuj can, pero yin man jun bey xcatinxutuj can, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ri Jesús xu'ij che ri Pedro: Yin kitzij nin-ij chave, chi chupan ri ak'a' re', na'ey chi nitzirikin-pe quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chi xa man aveteman ta nuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xu'ij che: Masque hasta nic'atzin chi junan yicamises aviq'uin, pero man xtin-ij ta chi man veteman ta avech, xcha'. Can quiri' mismo xqui'ij conojel ri discípulos. ");
INSERT INTO cak_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jac'ari' tok ri Jesús y ri ru-discípulos (xe'apon, xe'ebos) pa jun lugar rubinan Getsemaní. Y rija' xu'ij chique: Quixtz'uye' na can vave', chupan chi yin nenbana' orar más juba' quila', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Xaxe c'a ri Pedro y ri eca'i' ruc'ajol ri Zebedeo ri xeruc'uaj riq'uin. Y jari' xtiquer-pe nimalaj bis y k'axomal pa ránima. ");
INSERT INTO cak_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jac'ari' tok xu'ij chique ri oxi' ru-discípulos: Jani na nibison ri vánima, nuya-ka camic chuve ninna'. Quixc'uje' can vave', y quixc'ase' junan viq'uin, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Rija' xbin chic apu juba' más y chiri' xjupe-vi-ka pan ulef y quire' nu'ij chupan ri ru-oración: Nata', can ta c'o che'el, naj tik'ax-vi ri k'axomal re' chuve. Pero man ta'an ri ninrayij yin, xa ja ri najo' rat ri tibanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jac'a tok xtzolij-pe quiq'uin ri oxi' ru-discípulos, xa yever xu'urila', y xu'ij che ri Pedro: ¿Man xatiquer ta xac'ase' jun ch'uti hora viq'uin? ");
INSERT INTO cak_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Quixc'ase' y tibana' orar, richin quiri' man yixtzak pa mac. Yin veteman chi ri ivánima nurayij chi q'ues viq'uin re hora re', pero ri i-cuerpo xa nuk'oraj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xbe chic apu jun bey richin nerubana' orar, y quire' nu'ij: Nata', si manak che'el chi man ta yik'ax chupan ri jun k'axomal re', can tibanataj ri narayij rat, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tok xtzolij chic pe quiq'uin ri oxi' ru-discípulos, xa yever chic jun bey xu'urila', roma rije' al-al runak' tak quivech roma varan. ");
INSERT INTO cak_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xeruya' chic can jun bey y xbe chic apu richin nerubana' orar. Ja rox oración riq'uin ri' ri nerubana'. Y xucamuluj chic rubixic ri ru-oración. ");
INSERT INTO cak_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Jac'a tok xtzolij-pe quiq'uin ri oxi' discípulos, quire' xu'ij chique: Vacami quixver, titz'akatisaj ri ivaran. Roma yin ri xitak-pe richin xinalex chi'icojol, ja xril hora richin yijach-e pa quik'a' aj-mac tak vinak. ");
INSERT INTO cak_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Co quixcataj! Jo'. Titz'eta', ja petenak la xtijacho-e vichin, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","C'a nich'o na ri Jesús quiq'uin ri ru-discípulos chiri', jari' xuka ri Judas, jun chique ri doce ru-discípulos, eruc'amon-pe q'uiy vinak ri quic'amalo'n-pe che' y espada. Re' etakon-pe coma ri nima'k tak quik'ij sacerdotes israelitas y coma ri nima'k quijuna' achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri xtijacho-e ri Jesús, ru'in chic pe chique ri achique retal xtu'on richin nuc'ut ri Jesús chiquivech. Rija' quire' ru'in-pe chique: Ja ri (xtintz'ubaj, xtintz'ub) apu chivech, jari' ri Jesús. Rix (titz'ama', tichapa'). ");
INSERT INTO cak_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ja xchojmin-apu riq'uin ri Jesús y xu'ij che: Xok'ok'a' Nutijonel, xcha'. Jari' (xutz'ubaj, xutz'ub) apu. ");
INSERT INTO cak_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Y ri Jesús xu'ij che: Rat ri rat (vachbil, vach'il), tabana' ri achique roma rat petenak, xcha' che. Jac'ari' xejel-apu ri vinak riq'uin ri Jesús y ja (xquitz'om, xquichop). ");
INSERT INTO cak_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero jun chique ri ec'o riq'uin ri Jesús chiri', xbe ruk'a' riq'uin ri ru-espada, xrelesaj y xusoc jun rusamajinel ri nimalaj sacerdote israelita; jun ruxiquin xutzaq'uij-e. ");
INSERT INTO cak_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús xu'ij che ri xbano quiri': Tayaca-ka la espada. Roma conojel ri yecataj riq'uin espada, xa che espada xquecamises-vi. ");
INSERT INTO cak_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Riq'uin juba' rat nanojij chi yin vacami manak che'el nin-en orar richin ninc'utuj nuto'ic che ri Nata' Dios. Pero xa ta quiri' nin-en, rija' yerutak-pe más setenta y dos mil ángeles chinuto'ic. ");
INSERT INTO cak_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero si quiri' nin-en, man nibanataj ta ri tz'iban can chupan ri ruch'abel ri Dios ri nu'ij chi nic'atzin yik'ax chupan ri k'axomal re', xcha' rija'. ");
INSERT INTO cak_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ja hora ri' tok ri Jesús xu'ij chique ri vinak: Yin mana-ta yin elek'on chi rix ic'amalo'n-pe che' y espada richin yinu'ic'ama'. K'ij-k'ij xitz'uye' iviq'uin pa racho ri Dios richin xixintijoj riq'uin ri ruch'abel, y xa man (xinitz'om, xinichop) ta. ");
INSERT INTO cak_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero ronojel re' nibanataj, richin tz'akat nibanataj ri tz'iban can ojer coma ri profetas chupan ruch'abel ri Dios, xcha'. Jac'ari' tok conojel ri discípulos xquiya' can ruyon y xe'enimaj. ");
INSERT INTO cak_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xe'ec'amo ri Jesús, xquic'uaj chuvech ri Caifás ri nimalaj sacerdote israelita ri achique lugar quimolon-vi-qui' ri achi'a' q'uiy queteman chirij ri ley y ri nima'k quijuna' achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Jac'a ri Pedro xutzekle'ej-e ri Jesús c'a chojay che racho ri nimalaj sacerdote israelita, pero c'a naj c'o-vi can. Xoc c'a apu y xtz'uye-apu quiq'uin ri chajinel richin nrojo' nutz'et c'a pa ruq'uisbel ri achique xtibanataj riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jac'a ri nima'k tak quik'ij sacerdotes israelitas, ri nima'k quijuna' achi'a' c'o quik'ij, y conojel ri achi'a' junan niqui'en gobernar, niquicanola' jun tz'ucun tzij chirij ri Jesús, richin niquitak pa camic. ");
INSERT INTO cak_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Pero masque eq'uiy tz'ucuy tak tzij xquimol-apu-qui' chirij, man xetiquer ta xquisujuj. Xa c'a pa ruq'uisbel xe'eka ca'i' tz'ucuy tak tzij, ");
INSERT INTO cak_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","y quire' xqui'ij-apu: Ri achi re' ru'in: Yin yitiquer (ninvulaj, ninvulij) ri racho ri Dios y chi oxi' k'ij ninpaba' chic jun bey. Quiri' ru'in, xecha-apu. ");
INSERT INTO cak_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ri Caifás ri nimalaj sacerdote israelita, xpa'e' y xu'ij che ri Jesús: ¿Man jun achique na'ij riq'uin ronojel ri niqui'ij re' chavij? xcha' che. ");
INSERT INTO cak_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jac'a ri Jesús man jun tzij xu'ij. Jac'ari' tok ri nimalaj sacerdote xu'ij: Chuvech ri c'aslic Dios ta'ij chike si ja rat ri Jun ri xtutak-pe rija' chucolic ri rutinamit y si ja rat ri Ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ri Jesús xu'ij che: Ja', can achel ri xa'ij. Y nin-ij chive chi ja vacami nitiquer-e chi xquinitz'et yin ri xitak-pe richin xinalex chi'icojol, chi yin tz'uyul-apu pa ru-derecha ri Dios, ri achique lugar c'o-vi ri nimalaj ruchuk'a'. Y xquinitz'et chi yin petenak pa sutz' ri chicaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jac'ari' tok ri nimalaj sacerdote israelita xurak'ach'ij-ka ri rutziak chirij, y xu'ij: Itzel xu'on chuvech ri Dios ri achi re' riq'uin ri xeru'ij. ¿Achique chic más sujunel koyo'en? Rix mismo xivac'axaj ri itzel xu'on chuvech ri Dios riq'uin ri xeru'ij. ");
INSERT INTO cak_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Achique ni'ij rix pa ruvi'? xcha'. Conojel xqui'ij: ¡Tika camic pa ruvi'! xecha'. ");
INSERT INTO cak_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jac'ari' xquichubaj (rupalaj, ruvech) ri Jesús, xquiya' c'olon tak k'a' che y ec'o xquipak'ila' che k'a'. ");
INSERT INTO cak_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Y quire' niquibila': Si kitzij chi ja rat ri Jun ri takon-pe roma ri Dios chucolic rutinamit, tavila' achique yech'eyon avichin, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri Pedro tz'uyul chiri' chojay tok c'o jun aj-ic' xjel-apu riq'uin y xu'ij che: Ja jun rat ratc'o riq'uin ri Jesús ri aj pa departamento Galilea, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Jac'a ri Pedro chiquivech conojel xu'ij che ri aj-ic': Man veteman ta ri achique yatajin chubixic, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ja ntel-e chi bey chiri', tok c'o chic jun aj-ic' xtz'eto-apu richin y xu'ij chique ri ec'o chiri': Ja jun ri achi re' c'o riq'uin ri Jesús ri aj-Nazaret, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Jun bey chic ri Pedro xrevaj ri kitzij y xu'ij: Chuvech Dios nin-ij chi yin man veteman ta ruvech ri achi ri', xcha'. ");
INSERT INTO cak_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mier juba' chiri', xejel-apu riq'uin ri Pedro ri quimolon-qui' y xqui'ij che: Can kitzij vi chi rat, rat jun chique ri ec'o riq'uin ri Jesús. Roma ja ri achel na'an yach'o nic'utu avichin, xecha' che. ");
INSERT INTO cak_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Jac'ari' tok ri Pedro xu'ij: Yin chuvech Dios nin-ij chive chi man veteman ta ruvech ri achi ri'. Si man kitzij ta ri nin-ij, tika castigo pa nuvi', xcha'. Jari' tok xtzirikin-pe quimama' ri ec'. ");
INSERT INTO cak_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Jac'ari' tok ri Pedro xuc'uxlaj-pe chi ri Jesús quire' ru'in can che: Na'ey chi nitzirikin-pe quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chique ri yec'utun chave chi man aveteman ta nuvech. Xel c'a e ri Pedro y xujik' ok'ej. ");
INSERT INTO cak_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Tok xsakar-pe, conojel ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij chiquicojol ri quivinak, xquimol-qui' richin niquinojij achique ta niqui'en richin niquitak ri Jesús pa camic. ");
INSERT INTO cak_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xquixim c'a e ri Jesús y xbequijacha' pa ruk'a' ri gobernador Pilato. ");
INSERT INTO cak_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Jac'a ri Judas ri xjacho-e richin ri Jesús, tok xutz'et chi xa nitak ri Jesús pa camic, rija' riq'uin bis xerutzolij ri treinta ruvech méra banon riq'uin plata chique ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xu'ij c'a chique ri achi'a' ri': Yin mac xin-en tok xinjach ri Jesús pan ik'a', rija' man aj-mac ta richin nicamises. Jac'a rije' quire' xqui'ij che ri Judas: ¿Achique ka-cuenta roj si ri Jesús aj-mac o man aj-mac ta? ¡Ri' chavech vi rat ri'! Xa achique na xta'an, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ri Judas xerutorij can ri méra pa racho ri Dios, xel c'a pe, y xberujitz'aj rukul. ");
INSERT INTO cak_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Jac'a ri nima'k tak quik'ij sacerdotes israelitas xquimol ri méra ri xutorij can ri Judas y quire' xqui'ij: Ru-ley ri Dios man nuya' ta lugar chi nikaya-ka ri méra re' riq'uin ri méra richin pa racho ri Dios, roma re', rajil ruc'aslen jun achi ri xtibin ruquiq'uel. ");
INSERT INTO cak_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tok xetzijon yan pa ruvi' ri achique niqui'en riq'uin ri méra, xquilok' jun juyu' ri richin jun banoy bojo'y, richin ntoc camposanto quichin ri epetenak pa jun chic tinamit ri (yecom, yequen) pa Jerusalem. ");
INSERT INTO cak_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Romari' ri juyu' ri', c'a vacami ni'ix Juyu' richin Quic' che. ");
INSERT INTO cak_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Y riq'uin ri' xbanataj ri rutz'iban can ri profeta Jeremías ojer. Rija' quire' xu'ij: Ri eriy-rumam can ri achi Israel xquimol-e ri treinta ruvech méra ri banon che plata, ri juba' rajil xquiya' rije' chuvech ri Jun ri nimalaj rakale'n. ");
INSERT INTO cak_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Che ri' xquitoj-vi rujuyu' ri aj-banoy bojo'y, achel ru'in ri Ajaf chuve. Quiri' ru'in can ri profeta Jeremías. ");
INSERT INTO cak_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jac'a tok paban-apu ri Jesús chuvech ri gobernador, ri gobernador xuc'utuj che: ¿Ja rat ri Rey quichin ri israelitas? xcha'. Ja', achel ri na'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Jac'a tok yesujun-apu ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij chirij ri Jesús, rija' man jun rutzolic quitzij xu'on. ");
INSERT INTO cak_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ri Pilato xu'ij che ri Jesús: ¿Man navac'axaj ta ri ajani chi sujunic niqui'en-pe chavij? ");
INSERT INTO cak_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús man jun ch'abel xu'ij che ri Pilato. Y romari' ri gobernador can achique na xuna' che. ");
INSERT INTO cak_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ronojel juna' chupan ri nimak'ij pascua, ri gobernador can nucol-vi-e jun preso; pero ja ri tinamit yec'utun-apu ri achique preso nicol-e. ");
INSERT INTO cak_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan ri tiempo ri', c'o jun kajnak pa cárcel rubinan Barrabás, ri chi naj chi nakaj benak-vi rutzijol chi itzel chi achi. ");
INSERT INTO cak_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Romari' ri Pilato quire' xuc'utuj-pe chique ri quimolon-apu-qui': ¿Achique ri nijo' chi nincol-e? ¿Ja ri Barrabás, o ja ri Jesús ri ni'ix chi takon-pe chucolic rutinamit ri Dios? ");
INSERT INTO cak_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Rija' quiri' xuc'utuj chique, roma reteman chi xaxe roma eq'uiy yetzekle'en richin ri Jesús tok yekukut pa cánima xequijacha' pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y quiri' tz'uyul ri Pilato pa rutz'uyubal ri nic'ojon-vi, tok ri rixayil quire' rutakon-e rubixic che: Man ja jun rat taju-apu-avi' quiq'uin ri vinak ri yec'utun rucamic ri chojmilaj achi ri'. Roma yin can nuxi'in-vi' xic'astaj roma c'o achic' xin-en chirij ri achi ri'. Quiri' ri rutakon-e rubixic ri rixayil ri Pilato. ");
INSERT INTO cak_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij, xquiya' quino'oj ri vinak, chi tiquic'utuj-apu che ri Pilato chi ja ri Barrabás ticol-e y ri Jesús ticamises. ");
INSERT INTO cak_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Jac'ari' tok ri gobernador xuc'utuj chic pe jun bey chique: ¿Achique chique ri ca'i' ri nijo' chi nincol-e? xcha'. Ja ri Barrabás, xecha-apu. ");
INSERT INTO cak_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Rija' xuc'utuj chic pe: ¿Y achique nin-en che ri Jesús, ri ni'ix chi takon-pe roma ri Dios chucolic rutinamit? xcha'. ¡Tirip chuvech cruz! xecha-apu conojel. ");
INSERT INTO cak_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Y ri gobernador xu'ij-pe chique: Pero, ¿achique rumac rubanon chivech? Jac'a rije' xa más riq'uin cuchuk'a' xesiq'uin y xqui'ij-apu: ¡Tirip chuvech cruz! xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Tok ri Pilato xutz'et chi xa man yek'ilitaj ta ka ri vinak, roma xa más nicataj coyoval, rija' xuc'utuj juba' ya' richin xuch'aj ruk'a' chiquivech, y xu'ij: Yin man jun numac che ri rucamic ri jun chojmilaj achi re'. Can rix vi, achique na xti'en, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Y conojel ri vinak xqui'ij: Pa kavi' c'a roj y pa quivi' ri ekami'al-kalc'ua'l tika-vi rucamic ri achi re', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Jac'ari' tok ri Pilato xucol-e ri Barrabás, y xu'ij chi tich'ay ri Jesús. Tok banon chic ri xu'ij, jari' xujach-e richin tibajix chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jac'ari' tok ri soldados richin ri gobernador xquic'uaj ri Jesús pa nimajay ri nic'uje-vi ri gobernador, y xecoyoj-apu ri ch'aka' chic soldados chirij. ");
INSERT INTO cak_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tok quelesan chic e rutziak ri Jesús chirij, xquiya' jun tziek quiek chirij, ");
INSERT INTO cak_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","y xquiya-ka jun corona pa (rujolon, ruvi') banon che rakan tak xic'a'y c'o quiq'uixal, y xquiya' jun aj pa ruk'a' derecha. Jac'ari' richin yetze'en chirij, yexuque-apu chuvech y niqui'ij che: ¡Caquicot rat ri rat Rey quichin ri israelitas! yecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niquichubaj ri Jesús, niquimaj-e ri aj pa ruk'a' y niquipoj (rujolon, ruvi') che. ");
INSERT INTO cak_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tok xetane' chi yetze'en chirij, xquelesaj-e ri tziek quiek chirij, xquiya-e ri can rutziak vi, y xquic'uaj c'a e richin nequibajij chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Tok ja ye'el-e chuchi' ri tinamit, xquic'ul jun achi rubinan Simón, aj pa tinamit Cirene. Ri soldados xqui'en che ri Simón chi tuc'uaj-e ru-cruz ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y (xe'apon, xe'ebos) pa jun lugar rubinan Gólgota. Gólgota nu'ij tzij, lugar richin rubakil (rujolon, ruvi') ámna. ");
INSERT INTO cak_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tok ec'o chic chiri', ri soldados xquiya' jun ch'amilaj vino ri yo'on c'ayilaj mirra riq'uin che ri Jesús, pero tok rija' rutojto'en chic, man xrojo' ta xutij. ");
INSERT INTO cak_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Jac'a tok quibajin chic ri Jesús chuvech cruz, chi etz'anen xquijach-vi-e ri rutziak chiquivech, richin nibanataj ri ruch'abel ri profeta ojer tok xu'ij: Xquijachala' ri nutziak chiquivech; xqui'en etz'anen tzakoj chirij. Quiri' ru'in can. ");
INSERT INTO cak_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ri soldados etz'uyul chiri' quichajin-apu ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Xquibajij c'a jun pedazo tabla chutza'n e ri cruz ri nu'ij-vi ri achique roma nicamises ri Jesús. Chiri' nu'ij: JARE' RI JESUS RI REY QUICHIN RI ISRAELITAS. ");
INSERT INTO cak_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jac'ari' junan riq'uin ri Jesús xequibajij ca'i' elek'oma' chuvech qui-cruz y chi tak rutzalanen xequiya-vi. ");
INSERT INTO cak_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri yek'ax chiri', yequibila' can tzij chupalaj ri Jesús, y niquisiquisa' can (quijolon, quivi') chuvech. ");
INSERT INTO cak_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Y quire' niqui'ij can che: Rat ri na'ij chi (navulaj, navulij) racho ri Dios y chi oxi' k'ij napaba' chic jun bey, vacami tacolo-avi' ayon. Si kitzij chi rat Ruc'ajol ri Dios, caka-pe chuvech la cruz, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Quiri' mismo ri nima'k tak quik'ij sacerdotes, ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, ri achi'a' fariseos y ri nima'k quijuna' achi'a' c'o quik'ij, richin man jun ruk'ij niqui'en ri Jesús, quire' niquibila': ");
INSERT INTO cak_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Rija' xerucol ch'aka' chic, pero man nitiquer ta nucol-ri' ruyon. Si kitzij chi rija' Rey richin ri tinamit Israel, tika-pe chuvech la cruz, c'ajari' xtikanimaj-apu. ");
INSERT INTO cak_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Rija' nu'ij chi ruyo'on ránima riq'uin ri Dios, y si kitzij chi ri Dios nrojo' ri Jesús, vacami tucolo'. Roma ri Jesús nu'ij chi Ruc'ajol ri Dios, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Quiri' mismo ri elek'oma' ri ebajin chuvech qui-cruz chi tak rutzalanen, yequibila-apu tzij che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tok xnic'ajar ri k'ij, xk'uk'umer ruvech ronojel ri roch'ulef, y c'a richin las tres xk'ak'ij xq'uis-e ri k'eku'n. ");
INSERT INTO cak_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Richin cami las tres nik'ak'ij, ri Jesús riq'uin ronojel ruchuk'a' xu'ij: Elí, Elí, ¿lama sabactani? xcha'. Ri ch'abel ri' nu'ij tzij: Nu-Dios yin, nu-Dios yin, ¿achique roma xinaya' can nuyon? ");
INSERT INTO cak_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ec'o chique ri ec'o-apu chiri' tok xquic'axaj ri xu'ij, niquibila': Re' ja ri profeta Elías nroyoj, yecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Jun chique rije' cha'anin xeruc'ama-pe jun esponja, xumuba' pa jun ch'amilaj vino, y xuya' chutza'n jun aj richin xutz'ub ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ri ch'aka' chic niqui'ij: Jun taya-vi, tikoyo'ej na, k'alaj c'a ri' xtipe ri Elías chucolic, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero tok riq'uin ronojel ruchuk'a' ch'ovinak chic pe jun bey ri Jesús, jari' xujach ránima pa ruk'a' ri Dios y (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Jari' tok ri pinilaj tziek ri achok che jachon-vi rupan ri racho ri Dios xel pa ca'i'. Tixilil xpe pa ruvi' c'a chuxe' ka. Ri roch'ulef xsilon y ri chovon tak abaj xepax. ");
INSERT INTO cak_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri quijul ri anima'i' xejakataj, y eq'uiy lok'olaj tak ralc'ua'l ri Dios riq'uin qui-cuerpo xeyac-pe ri achique lugar emukun-vi, ");
INSERT INTO cak_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","xe'el-pe chiri' pa camposanto, xe'oc-apu pa lok'olaj tinamit Jerusalem tok c'astajnak chic pe ri Jesús chiquicojol ri anima'i', y xetz'etetaj coma eq'uiy vinak. ");
INSERT INTO cak_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri capitán y ri ec'o riq'uin richin quichajin ri Jesús, tok xquitz'et ri xu'on ri cobrakan, y ri xebanataj, jani na xquixi'ij-qui' y xquibila': Can kitzij chi ri achi re' Ruc'ajol ri Dios, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Chiri' eq'uiy ixoki' yetzu'un-apu chi naj. Rije' c'a pa Galilea quitzekle'en-vi-pe ri Jesús y can quilin-vi-pe. ");
INSERT INTO cak_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chiquicojol rije' c'o ri María Magdalena, c'o ri María ri quite' ri Jacobo y ri José, y c'o ri quite' ri eruc'ajol ri Zebedeo. ");
INSERT INTO cak_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tok ja nika-ka ri k'ij chiri', c'o jun tzekle'ey richin ri Jesús (xapon, xebos) chiri', jun achi beyon rubinan José, aj pa tinamit Arimatea. ");
INSERT INTO cak_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Rija' xbe-apu riq'uin ri Pilato ri gobernador richin xuc'utuj ru-cuerpo ri Jesús, y ri Pilato xu'ij chi tiyo'ox-pe che. ");
INSERT INTO cak_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Xbe c'a ri José, xubolkotij-e ri cuerpo pa jun ch'ajch'oj tziek. ");
INSERT INTO cak_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jac'ari' xberuya' chupan jun jul ri c'a juba' tic'ot-apu chuvech jun juyu' ruyon abaj, ri ruc'oton ri José richin ru-panteón rija' mismo. Jac'ari' xubolkotij-apu jun mama setesic abaj chuchi' ri jul richin xutz'apij can, y xbe. ");
INSERT INTO cak_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Jac'a ri María Magdalena y ri jun chic ixok mismo rubinan María, chi ca'i' xetz'uye' can chuvech ri jul ri xyo'ox-vi can ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri chuca'n k'ij, tok xk'ax yan ri k'ij chi ri israelitas niquibanala' rubanic ronojel ri nic'atzin chique chupan ri nimak'ij, jari' tok ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' fariseos xequimolo-qui' chuvech ri Pilato ri gobernador. ");
INSERT INTO cak_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Rije' quire' xqui'ij che: Nimalaj gobernador, roj nuka pa kavi' ri ru'in can ri Jesús tok c'a q'ues na. Ri tz'ucuy tzij ri' xu'ij chi xtic'astaj-pe chi rox k'ij. ");
INSERT INTO cak_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Romari' más utz ye'atak soldados richin nequichajij ri lugar ri xyo'ox-vi, hasta titz'akat na ri oxi' k'ij. Richin quiri' man quepe ri ru-discípulos chak'a' y niquelek'aj-e ri ru-cuerpo, y niqui'ij yan chic chique ri vinak chi ri Jesús can xc'astaj-vi-e. Roma si nisatz-e ri cuerpo, más jun nimalaj tz'ucun tzij xtibanataj, que chuvech ri na'ey, xecha'. ");
INSERT INTO cak_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xu'ij c'a chique ri achi'a' ri': Quixbin c'a y que'ic'uaj-e la soldados la'. Rix iveteman achel ni'en can che, xcha-e chique. ");
INSERT INTO cak_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Jac'ari' xebe ri achique lugar yo'on-vi can ru-cuerpo ri Jesús, xquiya' jun retal chirij ri abaj ri tz'apiyon ruchi' ri jul. Utz-utz xqui'en can rubanic y xequiya' can ri soldados chiri'. ");
INSERT INTO cak_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Tok xk'ax yan ri k'ij richin uxlanen, cumaj yan sakar chupan ri na'ey k'ij richin ri semana, ri María Magdalena y ri jun chic ixok mismo María rubi', xebe richin nequitz'eta' ri jul ri yo'on-vi can ru-cuerpo ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Y c'o c'a jun nimalaj cobrakan xu'on, roma c'o jun ángel richin ri Ajaf ri xka-pe chicaj, y tok xuka, xrelesaj ri abaj ri achok che tz'apin-vi can ruchi' ri jul, y xtz'uye-ka pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri rusakil ri ángel achel rusakil ri coyopa'. Y ri rutziak sak-sak, achel ri tef ri nika. ");
INSERT INTO cak_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ri soldados ri xetz'eto ri ángel, roma xquixi'ij-qui', yebarbot y achel ámna xqui'en-ka. ");
INSERT INTO cak_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Jac'a ri ángel quire' xu'ij chique ri ca'i' ixoki': Man tixi'ij-ivi', yin veteman chi ja ri Jesús ri xcamises chuvech cruz ri nicanoj. ");
INSERT INTO cak_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rija' man c'o ta chic vave', xa xc'astaj yan e, achel ri ru'in can chive. Quixampe, titz'eta' ri achique lugar xli'ex-vi ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Vacami quixtzolij cha'anin, y ti'ij chique ri ru-discípulos chi xc'astaj yan e chiquicojol ri anima'i'. Vacami xtinabeyaj-e chivech chila' pa Galilea, y chiri' xtitz'et-vi. Tiya' na pe pa cuenta ri nin-ij-e chive, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Jac'ari' tok ri ca'i' ixoki' quixi'in-qui' xe'el-pe ri pa jul, y jani na yequicot cha'anin xebe richin nequiya' rutzijol chique ri ru-discípulos ri Jesús. Jac'a tok ebenak ri pa bey richin nequiya' rutzijol, ");
INSERT INTO cak_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","c'ate retal xuc'ut-ri' ri Jesús chiquivech y xu'ij chique: ¡Quixquicot! xcha'. Ri ixoki' xejel-apu riq'uin, xexuque-ka richin xquik'etej ri rakan, y xquiya' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jac'a ri Jesús xu'ij chique: Man chic tixi'ij-ivi'. Vacami quixbin y te'iya' rutzijol chique ri e'ocunak nchak' chi quebin pa Galilea y chiri' c'a xquinquitz'et-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Tok ri ixoki' ri' ebenak chupan ri bey, ec'o chique ri soldados ri xechajin chuchi' ri jul xebe pa tinamit Jerusalem richin xquiya' rutzijol chique ri nima'k tak quik'ij sacerdotes israelitas ronojel ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Jac'ari' tok ri sacerdotes ri' xquimol-qui' quiq'uin ri nima'k quijuna' achi'a' c'o quik'ij, y tok xech'o yan pa ruvi' ri achique niqui'en, rije' xquiya' q'uiy méra chique ri soldados, ");
INSERT INTO cak_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y xqui'ij-e chique: Rix quire' ri tzij tivelesaj rutzijol: Roj ja nkuver chiri', tok xe'eka ru-discípulos ri Jesús y xquelek'aj-e ri ru-cuerpo, quixcha'. ");
INSERT INTO cak_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Si ri gobernador xtrac'axaj chi xa xixver-ka, roj mismo xkojekasan ránima, y quiri' xquixkacol pa ruk'a', xecha'. ");
INSERT INTO cak_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados xquic'ul c'a ri méra ri xyo'ox chique, y can xqui'en-vi ri achel xbix-e chique. Y ronojel ri tz'ucun tzij ri x-an chiri', c'a c'o na rutzijol chiquicojol ri israelitas c'a vacami. ");
INSERT INTO cak_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jac'a ri once ru-discípulos ri Jesús xebe pa Galilea pa ruvi' ri juyu' ri bin-vi can chique roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Tok xquitz'et ruvech, xquiya' ruk'ij. Pero ec'o jujun ri man can ta niquinimaj chi ja ri Jesús ri c'o quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Rija' xjel c'a pe y xu'ij chique: Ronojel uchuk'a' richin chicaj y richin choch'ulef pa nuk'a' yin jachon-vi can. ");
INSERT INTO cak_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Roma c'a ri', quixbin y que'itijoj ronojel quivech vinak richin ye'oc tzekle'ey vichin; que'ibana' bautizar pa rubi' ri Dios ri Itata', pa nubi' yin ri Ruc'ajol, y pa rubi' ri Lok'olaj Espíritu. ");
INSERT INTO cak_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Tic'utu' chiquivech chi tiquibana' ronojel ri achok riq'uin rix nupaxa'an-vi. Y yin xquic'uje' iviq'uin k'ij-k'ij c'a pa ruq'uisbel che ru-tiempo re roch'ulef. Amén.");
INSERT INTO cak_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Chupan ri vuj re' nilitaj-vi ri achique modo xtiquer-pe rutzijosic ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, ri ruch'abel ri Jesucristo ri Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Achel nu'ij ruch'abel ri Dios ri tz'iban can ojer roma ri profeta Isaías, chi ri Dios quire' xu'ij che ri Jesucristo: Xtintak jun yo'ol utzulaj atzijol na'ey chavech, Richin nuchojmirisaj ri abey. ");
INSERT INTO cak_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Pa chakijlaj tz'iran ulef xtich'o-vi, y riq'uin ruchuk'a' xtubila': Tibana' rubanic ri bey ri xtik'ax-vi ri Ajaf, Utz-utz tichojmij-apu. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri achi ri xuc'uxlaj can ri profeta Isaías chi nipe, ja ri Juan ri Bautista. Ri Juan re' pa chakijlaj tz'iran ulef yeru'on-vi bautizar ri vinak, y nu'ij chique chi tiquijala' quino'oj, tiquiya' can ri mac y tiquibana' bautizar qui' richin chi ri Dios nu'on perdonar ri quimac. ");
INSERT INTO cak_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y ri vinak aj pa tak tinamit richin ri Judea, y ri aj pa tinamit Jerusalem nequimolo-qui' riq'uin, can niquik'alajrisaj ri quimac, y ye'an-e bautizar roma rija' pa rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri Juan ri Bautista rusumal camello ocunak rutziak, y nuxim rupan riq'uin jun tz'un; y ja ri ch'utik chicop ri ni'ix langostas chique y cab richin pa juyu' ocunak ruvay. ");
INSERT INTO cak_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan quire' ri ruch'abel ri Dios ri nu'ij chique ri vinak: Chuvij yin xtuka Jun ri más c'o ruchuk'a' ri Dios riq'uin que chinuvech yin, y nis-ta richin yixuque-ka chirakan chusolic ximibel ruxajab, man nuc'ul ta chi ja yin yibano. ");
INSERT INTO cak_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Can kitzij na vi chi yin riq'uin ya' rix nubanon-vi bautizar. Pero ri Jun ri xtipe más chikavech apu, riq'uin ri Lok'olaj Espíritu xquixru'on bautizar. ");
INSERT INTO cak_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chupan tak ri k'ij ri', ri Jesús xel-pe pa Nazaret, jun tinamit richin ri Galilea richin x-an bautizar roma ri Juan pa rakan-ya' Jordán. ");
INSERT INTO cak_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y tok ja ntel-pe pa ya' ri Jesús chiri', xutz'et chi xjakataj ri rocaj, y xutz'et ri Lok'olaj Espíritu chi xulan-pe pa ruvi' achel jun paloma. ");
INSERT INTO cak_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jac'ari' xac'axex jun kulaj petenak chicaj ri quire' nu'ij: Ja rat ri Nuc'ajol, y can yatinjo' y niquicot vánima aviq'uin, nicha' ri ch'abel ri'. ");
INSERT INTO cak_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Jari' tok ri Lok'olaj Espíritu xu'on che ri Jesús chi xbe pa chakijlaj tz'iran ulef. ");
INSERT INTO cak_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Cuarenta k'ij xc'uje' chiri', y ri Satanás nutij ruk'ij chirij richin nrojo' nutakchi'ij pa mac. Chiquicojol itzel tak chicop c'o-vi ri Jesús, y c'o c'a ángeles xepe riq'uin richin niquilij. ");
INSERT INTO cak_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Tok ri Juan yo'on chic pa cárcel, ri Jesús xbe pa departamento Galilea. Rija' nutzijoj chique ri vinak ri utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc pa ruk'a' ri Dios richin yeru'on gobernar. ");
INSERT INTO cak_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ri Jesús quire' nu'ij: Ri tiempo xtz'akat yan, y nakaj chic c'o-vi chi c'o che'el yixoc pa ruk'a' ri Dios richin yixru'on gobernar. Roma c'a ri', tijala' ino'oj y tiya' can ri imac, y tinimaj ri utzulaj ch'abel ri nu'ij achique ruchojmil yixcolotaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","C'o jun k'ij ri Jesús nibin chuchi' ri lago Galilea, jari' xerutz'et ca'i' achi'a' quichak'-quinimal qui' chi yequic'akala-ka ya'l pa ya' richin yequelesaj quer, roma jari' quisamaj. Jun chique rije' rubinan Simón, y ri jun chic Andrés. ");
INSERT INTO cak_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Rija' quire' xu'ij chique: Quixampe, quinitzekle'ej, y xtinc'ut chivech achique ruchojmil ni'en richin ye'icanoj tzekle'ey vichin. ");
INSERT INTO cak_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri ca'i' achi'a' re', jari' xequiyala' can ri quiya'l y xquitzekle'ej ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tok xebin chic apu juba' más chuchi' ri lago, ri Jesús xerutz'et chic ca'i' achi'a' mismo quichak'-quinimal qui', jun rubinan Jacobo y ri jun chic Juan, eruc'ajol jun achi rubinan Zebedeo. Ja jun rije' pa canoa ec'o-vi, yequic'ojoj ri ya'l ri yequicusaj richin yequelesaj quer pa ya'. ");
INSERT INTO cak_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xe xerutz'et ri Jesús, ja xeroyoj, y rije' jari' xquiya' can ri Zebedeo ri quitata' y ri erusamajela' chiri' pa canoa, y xquitzekle'ej-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri achi'a' re xeroyoj ri Jesús, junan yan chic xe'oc-apu pa tinamit Capernaum riq'uin, y pa tak sábado ri k'ij richin uxlanen, ri Jesús ni'e pa sinagoga richin nitijon. ");
INSERT INTO cak_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ri niquimol-qui' chiri' can achique na niquina' che ruchojmil ruch'abel ri Dios ri achok riq'uin yerutijoj-vi. Roma nik'alajin chi riq'uin ri Dios petenak-vi, y man achel ta yetijon ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pero chiri' pa qui-sinagoga ri aj-Capernaum, c'o-apu jun achi ri ocunak itzel espíritu pa ránima ri riq'uin ruchuk'a' nisiq'uin-pe, ");
INSERT INTO cak_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","y quire' nu'ij-pe che ri Jesús: ¿Achique c'a ri najo' chike, rat Jesús aj-Nazaret? ¿Xatuka richin nkojaq'uis? Yin veteman (rat achique, aratcu'x) rat. Veteman chi ja rat ri lok'olaj ri rat petenak riq'uin ri Dios, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ri Jesús quire' xu'ij che ri itzel espíritu richin xuch'olij: ¡Man cach'o chic, catel-e riq'uin! xcha'. ");
INSERT INTO cak_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzel espíritu jari' xuquiyica' can ri achok riq'uin ocunak-vi, y nisiq'uin riq'uin ruchuk'a' xel-e. ");
INSERT INTO cak_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Conojel ri quimolon-qui' can achique na xquina' tok xquitz'et ri xu'on ri Jesús, y niquibila' chiquivech: ¿Achique re' c'a? ¿Jun cami c'ac'ac' ruchojmil ruch'abel ri Dios ri nrojo' nkurutijoj riq'uin? Roma hasta c'o ruk'a' chique ri itzel tak espíritu chi nich'o chique, y can niquinimaj rutzij, yecha' chiquivech. ");
INSERT INTO cak_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Cha'anin c'a xel rutzijol ri Jesús ri pa tak tinamit ri ec'o chiri' pa Galilea. ");
INSERT INTO cak_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tok ri Jesús, ri Jacobo y ri Juan xe'el-pe pa sinagoga, xebe chicacho ri Simón y Andrés. ");
INSERT INTO cak_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Jac'a tok xe'oc-apu ri pa jay, xyo'ox rutzijol che ri Jesús chi ri rujite' ri Simón cotz'ol nijino pa c'atan. ");
INSERT INTO cak_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Xjel c'a apu ri Jesús riq'uin, (xutz'om, xuchop) apu chiruk'a' y xuyec. Cha'anin c'a xq'uis-e ri c'atan chirij, y ri ixok ja yan chic yerilij ri Jesús y ri ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Tok xoc-pe ri ak'a' chupan ri k'ij ri', y ja xk'ok'a-ka, xe'uc'uax-apu chuvech ri Jesús conojel ri c'o jalajoj ruvech yabil quiq'uin y ri ocunak itzel tak espíritu quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Juba' ma chi jun tinamit xquimol-apu-qui' chuchi' ri jay ri c'o-vi ri Jesús, ");
INSERT INTO cak_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","y eq'uiy ri xu'on chique chi xec'achoj riq'uin jalajoj ruvech yabil. Xerelesaj eq'uiy itzel tak espíritu, y man xuya' ta lugar chique ri itzel tak espíritu chi xech'o, roma rije' queteman (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ri Jesús cumaj xcataj ri chuca'n k'ij, c'a k'eku'n na xel-e ri pa tinamit, xbe pa jun lugar manak vinak, y chiri' nu'on-vi orar. ");
INSERT INTO cak_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jac'a ri Simón y ri ec'o can riq'uin, xebe chucanoxic. ");
INSERT INTO cak_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tok xquil, xqui'ij che: Conojel yatquicanoj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jac'a ri Jesús xu'ij chique: Jo' ri pa tak lugar ri ec'o-pe nakaj, richin chi ja jun chiri' nentzijoj-vi ri ruch'abel ri Dios, roma yin richin ri' yin petenak, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Pa ronojel c'a tinamit richin ri Galilea nutzijola-vi ri ruch'abel ri Dios pa tak qui-sinagogas ri aj chiri', y yerelesaj itzel tak espíritu quiq'uin ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'o c'a jun niyavej riq'uin ri yabil lepra (xapon, xebos) riq'uin ri Jesús, xxuque' chuvech y riq'uin quemelal quire' nu'ij: Si rat najo', yin veteman chi yatiquer na'an chi yin yic'achoj riq'uin ri nuyabil, nicha'. ");
INSERT INTO cak_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ri Jesús xupokonaj c'a ruvech, xuya-apu ruk'a' chirij, y xu'ij che: Ninjo', cac'achoj c'a, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xe xu'ij ri Jesús quiri', jari' xq'uis-e ri lepra chirij ri niyavej, y xch'ajch'ojir can. ");
INSERT INTO cak_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jac'ari' tok ri Jesús cof xupaxa'aj-e, y xu'ij che chi tibin, ");
INSERT INTO cak_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","y quire' xu'ij-e che: C'o axiquin, man jun achok che tatzijoj-vi nis-ta juba' che ri achique xbanataj aviq'uin. Choj te'ac'utu-avi' chuvech ri sacerdote israelita, y taya' ri sipanic ri ru'in can ri Moisés, richin nik'alajin chiquivech rije' chi rat ch'ajch'oj chic. ");
INSERT INTO cak_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ri xch'ajch'ojir can riq'uin ri lepra, xe xel-e riq'uin ri Jesús, ja yan nutzijoj chique ri vinak ri achique xbanataj riq'uin ri ruyabil. Romari' ri Jesús manak chic che'el ntoc-apu ri pa tinamit chiquivech ri vinak, xa xc'atzin chi xcanaj can ri pa tak lugar manak vinak. Pero eq'uiy vinak ri jalajoj lugar quepe-vi ri nequimolo-qui' riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Tok xk'ax yan ca'i-oxi' k'ij, ri Jesús xtzolij ri pa tinamit Capernaum, y xc'axataj chi rija' c'o pa jun jay chiri' pa tinamit. ");
INSERT INTO cak_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Romari' cha'anin xquimol-apu-qui' eq'uiy vinak ri achique lugar c'o-vi. Xquinojsaj-apu-qui' pa jay, ronojel chuchi' ri jay niquipitz'ila-vi-qui'. Y ri Jesús nutzijoj ri ruch'abel ri Dios chique. ");
INSERT INTO cak_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jac'ari' tok ec'o (xe'apon, xe'ebos) riq'uin, quic'amon-apu jun ri caminak ruk'a-rakan; (ecaji', yaquiji') chique rije' ec'amayon-pe richin. ");
INSERT INTO cak_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Y roma man juba' ta oc ri quimolon-apu-qui' chiri', ri e'uc'uayon-apu ri niyavej man xetiquer ta xe'oc-apu ri pa jay ri c'o-vi ri Jesús, romari' xejote' pa ruvi' ri jay y ja ri pa ruchojmil ri Jesús xquelesaj-vi-e juba' ruvi' ri jay. Chiri' c'a xquikasaj-vi-ka ri varo'el ri achok chuvech c'o-vi-e ri caminak ruk'a-rakan. ");
INSERT INTO cak_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Tok ri Jesús xutz'et chi riq'uin ronojel cánima epetenak, rija' xu'ij che ri caminak ruk'a-rakan: Valc'ua'l, ri amac xe'an yan perdonar, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chiquicojol ri quimolon-apu-qui' pa jay, etz'uyul-apu jujun achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. Rije' quire' niquinojij pa tak cánima: ");
INSERT INTO cak_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Achique roma quila' nu'ij la achi la'? Xa itzel nu'on chuvech ri Dios, roma xaxe ri Dios nibano perdonar mac, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jac'a ri Jesús pa ránima reteman-vi ri yetajin chunojixic pa tak cánima. Romari' cha'anin xu'ij chique: ¿Achique roma quire' ninojij rix pan ivánima? ");
INSERT INTO cak_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Achique c'a ri más man c'ayef ta richin nin-ij che re caminak ruk'a-rakan? ¿Ja chi xe'an yan perdonar ri rumac, o ja ri nin-ij che chi ticataj y tuc'uaj-e ri ruvaro'el? ");
INSERT INTO cak_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vacami c'a, richin chi rix nivetemaj chi yin ri xitak-pe richin xinalex chi'icojol yo'on-pe uchuk'a' chuve richin nin-en perdonar mac pa ruvi' ri roch'ulef, titz'eta' c'a. Jac'ari' tok ri Jesús xu'ij che ri caminak ruk'a-rakan: ");
INSERT INTO cak_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nin-ij c'a chave: Cacataj, tac'uaj-e la avaro'el y cabin chi'avacho, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Jari' tok ri niyavej xcataj-e, xuc'ol-e ri ruvaro'el, y chiquivech conojel xel-vi-e, y conojel can achique na xquina', niquiya' ruk'ij ri Dios y niqui'ij: Man jun bey katz'eton chi quire' nibanataj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Xbe chic c'a ri Jesús jun bey chuchi' ri lago, y eq'uiy vinak ri xequimolo-qui' riq'uin, y xerutijoj riq'uin ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jac'ari' pa rubey xutz'et ri Leví, ruc'ajol jun achi rubinan Alfeo. Ri Leví tz'uyul ri achique lugar nuc'ul-vi can ri impuestos, y ri Jesús xu'ij che: Quinatzekle'ej, xcha'. Ja c'a xcataj-pe, y xutzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y c'o jun k'ij ri Jesús c'o-apu chuchi' mesa chiracho rija', eq'uiy c'a c'uluy tak impuestos y vinak ri ni'ix aj-mac chique ec'o-apu chuchi' mesa junan riq'uin ri Jesús y ri ru-discípulos, roma eq'uiy ri ebenak chirij. ");
INSERT INTO cak_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Tok ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés y ri achi'a' fariseos xquitz'et chi ri Jesús niva' quiq'uin c'uluy tak impuestos y quiq'uin vinak ni'ix aj-mac chique, rije' xquic'utuj chique ri discípulos: ¿Achique roma niva' y nukum ruya' quiq'uin la c'uluy tak impuestos y quiq'uin la aj-mac tak vinak? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tok ri Jesús xrac'axaj ri tzij re', quire' xu'ij: Man chique ta ri utz niquina' nic'atzin-vi ri aj-k'omanel, xa chique ri yeyavej. Y yin man xipe ta chicoyoxic ri niquinojij chi choj quic'aslen, yin xipe chicoyoxic ri aj-mac, richin tiquijala' quino'oj y tiquiya' can ri mac, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri ru-discípulos ri Juan ri Bautista y ri yetzekle'en quichin ri achi'a' fariseos, can c'o k'ij niqui'en coch'on vayijal. Y c'o c'a ri quire' xec'utun-apu che ri Jesús: Ri ru-discípulos ri Juan y ri yetzekle'en quichin ri fariseos, c'o k'ij niqui'en coch'on vayijal. Jac'a ri a-discípulos rat, ¿achique roma man niqui'en ta coch'on vayijal? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ri Jesús xu'ij chique: ¿Utz cami chi ri ec'o pa jun c'ulubic man yeva' ta tok c'a c'o na ri ala' ri c'o pa ruc'ulubic quiq'uin? Manak che'el man ta xqueva', roma c'a c'o na ri ala' aj-c'ulubel quiq'uin. ");
INSERT INTO cak_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xque'erila' k'ij chi ri ala' xteleses-e chiquicojol, ja chupan tak ri k'ij ri' xtiqui'en coch'on vayijal. ");
INSERT INTO cak_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Man jun vinak xtucusaj jun c'ac'ac' c'ojobel richin nuc'ojoj jun tziek ri xa tzia'k chic. Roma ri c'ac'ac' c'ojobel c'a nuc'ol na ri' y xa nujec' ri tzia'k chic, romari' más nirak'ach'itaj-ka. ");
INSERT INTO cak_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y man jun niyaco c'ac'ac' vino chupan tzia'k tak tz'un. Roma ri c'ac'ac' vino yerubojij-e ri tz'un, y nitix-e ri vino y ri tz'un man jun chic yec'atzin-vi. Ri ruchojmil, ja chi ri c'ac'ac' vino niyac chupan c'ac'ac' tak tz'un. Quiri' ri ejemplo xutzijoj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun sábado ri k'ij richin uxlanen, ri Jesús y ri ru-discípulos yek'ax pa jun juyu' ri ticon trigo chuvech, y ri discípulos yequik'upula-e rutza'n ri trigo ebenak. ");
INSERT INTO cak_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Roma c'a ri', ri achi'a' fariseos quire' xqui'ij che ri Jesús: Que'atz'eta' la a-discípulos; ru-ley ri Dios man juba' nuya' lugar chi ni'an achel ri yetajin riq'uin. ¿Achique roma yequik'up rutza'n ri trigo vacami, tok ri k'ij re' richin uxlanen? ");
INSERT INTO cak_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero ri Jesús xu'ij chique: ¿Man jun bey ibanon leer ruch'abel ri Dios ri achique xqui'en ri David y ri ebenak chirij chupan ri ojer can tiempo tok yevayijan chiri'? ");
INSERT INTO cak_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xoc pa racho ri Dios chucanoxic achique niquitij chupan ri tiempo tok ja ri Abiatar ri nimalaj sacerdote. Y masque ru-ley ri Dios nu'ij chi xaxe ri sacerdotes israelitas c'o quik'a' che ri pan ri sujun chic chuvech ri Dios, pero ri David xutij y hasta xuya' chique ri ebenak chirij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","(Chuka', ka) quire' xu'ij chique: Ri sábado ri k'ij richin uxlanen, xa richin jun favor chique ri vinak tok xyo'ox, y man xeyo'ox ta ri vinak richin jun favor che ri k'ij ri'. ");
INSERT INTO cak_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Roma c'a ri', rix tivetemaj chi ri Rajaf ri k'ij richin uxlanen, ja yin ri xitak-pe richin xinalex chi'icojol, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ri Jesús xoc chic apu jun bey pa sinagoga, y chiquicojol ri quimolon-qui' chiri', c'o jun achi caminak jun ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Y c'o c'a ri xe niquitz'et-apu ri Jesús, k'alaj ri' si nu'on chi nic'achoj ri niyavej chupan ri sábado ri k'ij richin uxlanen, richin quiri' c'o roma niquisujuj. ");
INSERT INTO cak_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jac'ari' tok ri Jesús quire' xu'ij che ri achi caminak ruk'a': Cacataj y cak'ax-pe pa nic'aj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y ri Jesús xu'ij chique ri ec'o chiri': ¿Achique ri más ruyuken-ri' riq'uin ru-ley ri Dios chi ni'an chupan ri sábado ri k'ij richin uxlanen? ¿Ja ri utz o ja ri man utz ta? ¿Ja ri nicol jun vinak chuvech ri camic o nicamises? xcha' chique. Jac'a rije' man xech'o ta apu. ");
INSERT INTO cak_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jac'ari' xbison-ka ri Jesús roma rucovil cánima ri quimolon-qui' chiri'. Romari' rija' royoval nich'icch'ot ruvech chique y xu'ij che ri caminak ruk'a': Tayuku' la ak'a', xcha'. Tok ri niyavej xuyuk ruk'a', ja xc'achoj. ");
INSERT INTO cak_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Tok xe'el-e ri achi'a' fariseos chiri', xequimolo-qui' quiq'uin ruvinak ri rey Herodes, richin niquinojij achique ta niqui'en richin niquicamisaj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Xel-e chiri' ri Jesús y xbe chuchi' ri lago junan quiq'uin ri ru-discípulos, y man juba' ta oc chi vinak xetzekle'en-e richin. Ec'o aj pa tak tinamit richin ri Galilea, aj pa tak tinamit richin ri Judea, ");
INSERT INTO cak_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","aj-Jerusalem, aj pa tak tinamit richin ri Idumea, aj juc'an apu ruchi' ri rakan-ya' Jordán, y aj pa tak lugares chiquinakaj ri tinamit Tiro y ri tinamit Sidón. Y jani na chic más vinak xe'uka riq'uin ri Jesús tok xquic'axaj ri jalajoj tak milagros yerubanala'. ");
INSERT INTO cak_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Eq'uiy c'a ri xquimol-apu-qui' riq'uin, romari' ri Jesús xu'ij chique ri ru-discípulos chi tiquiya-pe jun canoa chiri' nakaj, richin man tiquipitz'. ");
INSERT INTO cak_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ri Jesús q'uiy eruc'achojrisan-pe riq'uin ri quiyabil, y jari' xbano chi conojel ri yeyavej niquinimila-qui' chirij, richin nicajo' (niquitz'om, niquichop) apu. ");
INSERT INTO cak_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tok ri itzel tak espíritu niquitz'et ri Jesús, niquikasaj-ka-qui' pan ulef chuvech, y riq'uin cuchuk'a' niqui'ij: Ja rat ri Ruc'ajol ri Dios, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ri Jesús jani na xeruch'olij-e richin man tiquelesaj rutzijol (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","C'ajari' tok ri Jesús xjote-e pa ruvi' jun juyu' y xeroyoj-e ri xrojo' chi xeroyoj-e, y rije' can xebe na vi apu riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chiquicojol ri xeroyoj-e, xerucha' doce richin ye'oc (rachbil, rach'il), richin yerutak chutzijosic ri ruch'abel ri Dios, ");
INSERT INTO cak_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","y chi c'o quik'a' chi yequic'achojrisaj ri yeyavej y chi yequelesaj itzel tak espíritu. ");
INSERT INTO cak_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Xucha' ri Simón y xuya' chic jun rubi' y xu'ij Pedro che. ");
INSERT INTO cak_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Xucha' ri Jacobo ri ruc'ajol ri Zebedeo y quiri' mismo ri Juan ri quichak'-quinimal qui' riq'uin ri Jacobo, y xu'ij Boanerges chique. Boanerges nu'ij tzij: ralc'ua'l rayo. ");
INSERT INTO cak_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xerucha' ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri Alfeo, ri Tadeo, ri Simón ri c'o quiq'uin ri achi'a' ni'ix cananista chique, ");
INSERT INTO cak_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xtijacho-e richin ri Jesús. Conojel re' xetzolij-pe pa jun jay. ");
INSERT INTO cak_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Xquimol chic apu qui' jun bey eq'uiy vinak chiri', y romari' ri Jesús y ri ru-discípulos nis-ta manak tiempo richin yeva'. ");
INSERT INTO cak_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tok ri queteman ruvech ri Jesús xquina'ej-pe, xepe riq'uin richin nuquic'ama', roma xquinojij chi xa (xch'ujir, xmoxer). ");
INSERT INTO cak_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Jac'a ri achi'a' ri epetenak pa tinamit Jerusalem ri q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, niquitzijoj chi ri Jesús ja ri Beelzebú ri cajaf ri itzel tak espíritu c'o riq'uin, y jari' niyo'on ruchuk'a' richin yerelesaj itzel tak espíritu. ");
INSERT INTO cak_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Romari' ri Jesús xeroyoj y xutzijoj jun ejemplo chiquivech. Rija' quire' xu'ij chique: Manak che'el chi ja mismo ri Satanás ye'elesan-e ri rusamajela'. ");
INSERT INTO cak_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Roma si jun rey nicataj chiquij ri mismo ruvinak, man juba' xtilayoj chi rey. ");
INSERT INTO cak_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Quiri' mismo pa jun jay, si ri rajaf xa niquibanala-ka oyoval chiquivech, xa xtijachataj-e quivech. ");
INSERT INTO cak_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y si ri Satanás nicataj chirij rija' mismo y nujachala-ka-ri' quiq'uin ri rusamajela', man juba' xtilayoj, xa chiri' xq'uis-vi ruk'ij ri ru-gobierno. ");
INSERT INTO cak_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Pero man jun nitiquer ntoc pa racho jun rajaf-jay ri jani na ruchuk'a' richin nelak'-e, si na'ey man nuxim ta ri rajaf-jay. Jac'a si nuxim, c'ajari' c'o che'el nuq'uen-e ronojel ri nrojo'. ");
INSERT INTO cak_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Yin kitzij nin-ij chive chi ronojel mac ri yequibanala' ri vinak choch'ulef, can c'a ye'an na perdonar, hasta ronojel ri yok'onic tak tzij ri yequibila'. ");
INSERT INTO cak_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Jac'a ri niyok'on ri Lok'olaj Espíritu, man jun bey xti'an perdonar, xa xtrakalej ri mac ri' richin jumul. ");
INSERT INTO cak_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Quiri' xu'ij ri Jesús chique ri achi'a' ri', roma niqui'ij chi ri Jesús c'o itzel espíritu riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jac'ari' xe'eka ri rute' y ri eruchak' ri Jesús ri achique lugar c'o-vi rija', pero xaxe chojay xec'uje-vi, y xquitak royoxic. ");
INSERT INTO cak_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chutzalanen ri Jesús eq'uiy etz'uyul-apu, y xqui'ij-apu che: Ri ate' y ri e'achak' ec'o chojay, y yatquicanoj. ");
INSERT INTO cak_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jac'a ri Jesús xu'ij chique: ¿Achique c'a ri nte' y ri enchak' ninojij rix? ");
INSERT INTO cak_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jac'ari' xerutz'et conojel ri etz'uyul riq'uin y xu'ij: Jare' ri nte' y ri enchak'. ");
INSERT INTO cak_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Roma xa achique na jun nibano ri nurayij ri Dios, jari' ri nte', ri vana' y ri nchak', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jun bey chic ri Jesús xutz'uc quitijoxic ri vinak chiri' chuchi' ri lago. Y jani na q'uiy xquimol-apu-qui' riq'uin, romari' xc'atzin chi xoc-apu pa jun canoa ri c'o pa ruvi' ri ya', y chiri' xtz'uye-vi-ka. Conojel ri quimolon-apu-qui' epa'el-apu chuchi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Y pa ruvi' q'uiy cosas xerutijoj-vi, y ronojel riq'uin ejemplos. Rija' richin yerutijoj riq'uin ruchojmil ri ruch'abel ri Dios, quire' xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tivac'axaj ri xtin-ij chive: C'o jun ticonel xbe chuquiraxic semilla. ");
INSERT INTO cak_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tok ja nuquiraj chiri', c'o che ri semilla xeka pa bey, y xepe ri chicop c'o quixic', xquitij-e ri semilla. ");
INSERT INTO cak_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ch'aka' che ri semilla xeka chiquicojol tak abaj, y roma chiri' man pin ta ulef c'o, xa cha'anin xe'el-pe, roma man naj ta xec'uje-vi-ka ri semilla. ");
INSERT INTO cak_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Jac'a tok xel-pe ri k'ij, ri ch'utik tico'n xec'at chuvech, y xechakij-ka roma manak ni'e-vi-ka ri quixe'. ");
INSERT INTO cak_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","C'o ch'aka' che ri semilla xeka achique lugar ye'el-vi-pe q'uix y junan xe'el-pe riq'uin. Pero ri q'uix más cha'anin xeq'uiy, y ri ch'utik tico'n xek'aner-ka chucojol y man jun xquiya'. ");
INSERT INTO cak_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero c'o che ri semilla xeka pa ruch'acul ri ulef, y tok xe'el-pe y xeq'uiy, jabel xquiya', roma c'o xquiya' a treinta, c'o xquiya' a sesenta y c'o xquiya' a cien. ");
INSERT INTO cak_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jac'ari' tok ri Jesús xu'ij: Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jac'a tok xcanaj can ruyon quiq'uin ri ru-discípulos, y ri más chic ri ec'o-apu riq'uin, rije' xquic'utuj ruchojmil ri ejemplo che. ");
INSERT INTO cak_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ri Jesús quire' xu'ij chique: Chive rix yo'on lugar chi c'o nivetemaj chirij ru-gobierno ri Dios, ri man can ta ojer ri' k'alajrisan can. Jac'a ri man yinquinimaj ta, riq'uin ejemplos yich'o-vi chique, ");
INSERT INTO cak_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","richin quiri' masque niquitz'et ri najin chiquivech, pero xa achel man yetzu'un ta; masque niquic'axaj ri ni'ix chique, pero xa man (nik'ax, nino') ta chiquivech, richin quiri' man tiquijal quino'oj, y man ti'an perdonar ri quimac roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jac'ari' tok xu'ij: ¿Man (nik'ax, nino') ta c'a chivech ri ejemplo ri xintzijoj-ka chive c'a? Si quiri', ¿achel (xtik'ax, xtino') chivech ri ch'aka' chic ejemplos? ");
INSERT INTO cak_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri ticonel, jun rusamajinel ri Dios ri nitico ri ruch'abel ri Dios pa cánima ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri semilla ri xeka pa bey, jari' nu'ij tzij chi ec'o vinak nitic can ruch'abel ri Dios pa cánima, pero tok quic'axan chic, ja nipe ri Satanás y nrelesaj-e ri ticon can pa cánima. ");
INSERT INTO cak_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri semilla ri xeka chiquicojol tak abaj, nich'o pa quivi' ri ye'ac'axan ruch'abel ri Dios y can yequicot niquic'ul, ");
INSERT INTO cak_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","pero man nuq'uen ta ka ruvech pa cánima, xa juba' oc k'ij niquiya' cánima riq'uin ri Dios, roma tok yeyo'ox pa k'axomal o pa pokonal roma quiniman ruch'abel ri Dios, xa cha'anin niquil jun roma chi niquixutuj can ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y ri semilla ri xeka chiquicojol tak q'uix, jari' nu'ij tzij chi ec'o ye'ac'axan ruch'abel ri Dios, ");
INSERT INTO cak_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero roma ni'e cánima pa ruvi' ri roch'ulef y nisatz cánima pa ruvi' beyomal, y roma yequirayij jalajoj tak cosas; jari' ri ntoc quiq'uin ri nibano chi nijik' ri ruch'abel ri Dios, y man jun samaj nu'on pa cánima. ");
INSERT INTO cak_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jac'a ri semilla ri xeka pa ruch'acul ri ulef, nich'o pa quivi' ri ye'ac'axan ruch'abel ri Dios, y can niquic'ul pa tak cánima ri niquic'axaj, y pa quic'aslen c'o utz nik'alajin, achel ruvech ri tico'n ri c'o niquiya' a treinta, c'o niquiya' a sesenta y c'o niquiya' a cien. ");
INSERT INTO cak_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jac'ari' tok ri Jesús xu'ij chic chique: Tok nic'amer-pe jun candil richin nu'on sakil pa jay, man niyo'ox ta apu chuxe' cajón, o chuxe' ch'at, xa niyo'ox pa (ruc'ojle'el, ru-lugar). ");
INSERT INTO cak_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Roma man jun ri evan ri man ta xtek'alajin-pe, ni man jun achique banon che'elek'el ri man ta xtel chosakil. ");
INSERT INTO cak_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si c'o jun (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jac'ari' tok ri Jesús xu'ij chic chique: Tiya' jabel ixiquin che ri nivac'axaj, roma ja ri ajani ixiquin niya' che ri nivac'axaj viq'uin, quiri' ri xtivetemaj. Y hasta xtivetemaj más chuvech ri ivac'axan. ");
INSERT INTO cak_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Roma ri c'o chic riq'uin, xtiyo'ox más che. Jac'a ri man jun oc ruchajin, hasta ri juba' c'o riq'uin, xteleses che. ");
INSERT INTO cak_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jac'ari' tok ri Jesús xu'ij: Nintzijoj na jun ejemplo chive: Ri ru-gobierno ri Ajaf Dios, achel tok jun vinak nerutica' semilla pa jun juyu'. ");
INSERT INTO cak_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tok ruticon chic can ri semilla, man nujal ta rubanic ri ruc'aslen; chak'a' niver, chuca'n k'ij nicataj-pe y quiri' ri ruc'aslen jumul. Jac'a ri semilla ruyon ntel-pe y niq'uiy, y ri ticonel nis-ta reteman rubeyal ruq'uiyilen. ");
INSERT INTO cak_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Roma ja ri roch'ulef nibano chi nuya' ri tico'n. Na'ey ntel-pe ri ch'uti alaj trigo, c'ajari' nuc'ut-pe-ri' ri ch'uti rutza'n, y pa ruq'uisbel ninoj-pe rupan ri rutza'n. ");
INSERT INTO cak_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tok ri tico'n utz chic richin nik'at, yetak samajela' chupan richin nequik'ata', roma ruk'ijul chic richin nik'at. ");
INSERT INTO cak_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jac'ari' tok ri Jesús xu'ij: ¿Achok riq'uin cami nikajunumaj-vi ri ru-gobierno ri Dios? ¿Achique ta cami ejemplo nikacusaj richin más k'alaj nu'on chivech? ");
INSERT INTO cak_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ri ru-gobierno ri Dios xa achel jun ch'uti ruvech ru-semilla mostaza tok niyo'ox can chupan ri ulef, masque ja semilla ri' ri más co'ol chiquivech ch'aka' chic semilla ri ec'o choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero tok ntel-pe, xa jari' ri más (nim, tij) ntel chiquivech ronojel quivech tico'n, y can yec'uje' chovon tak ruk'a'. Romari' ri chicop c'o quixic' hasta c'o che'el niquimujaj-qui' pa tak ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ri Jesús q'uiy ejemplos achel re' ri xerucusaj richin xutzijoj ruch'abel ri Dios chique ri vinak, y xaxe ri ajani yetiquer niquetemaj ri nutzijoj chique. ");
INSERT INTO cak_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Y man jun ri xutzijoj ri man ta xucusaj ejemplos. Pero tok quiyon ec'o riq'uin ri ru-discípulos, rija' nuchojmij ronojel chiquivech. ");
INSERT INTO cak_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tok xoc-pe ri ak'a' chupan ri k'ij ri', ri Jesús xu'ij chique ri ru-discípulos: Kuk'ax-apu juc'an ruchi' ri lago, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Y tok rije' xequitak yan can ri vinak chi tak cacho, ri Jesús quiri' tz'uyul pa canoa xquic'uaj pa ruvi' ri ya'. Y ec'o ch'aka' chic canoas ri xetzekle'en-e richin. ");
INSERT INTO cak_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Jac'a tok ebenak chic pa ruvi' ri ya', xtiquer-pe jun nimalaj cak'ik' ri nu'on chi nicataj ri ya' chicaj; choj nika-ka chupan ri canoa ri ebenak-vi, romari' ri canoa ninoj-pe riq'uin ya'. ");
INSERT INTO cak_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jac'a ri Jesús c'a chirij can niver-vi pa ruvi' jun ch'aquet-vi'aj. Y ri discípulos xquic'asoj y xqui'ij che: ¡Ajaf! ¿Man nuya' ta pena chave chi xa nkujik'? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Xcataj c'a pe ri Jesús, cof xch'o che ri cak'ik', y quire' xu'ij che ri ya': Catane-ka y casiso-ka, xcha'. Ri cak'ik' xq'uis-e, y jabel li'an xu'on-ka ruvi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jac'ari' tok quire' xu'ij chique: ¿Achique roma ixi'in-ivi'? ¿Man cukul ta ic'u'x viq'uin? ");
INSERT INTO cak_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jac'a ri discípulos jani na quixi'in-qui' y niquic'utula' chiquivech: ¿Achique c'a chi achi re' chi hasta ri cak'ik' y ri ya' niquinimaj rutzij? yecha'. ");
INSERT INTO cak_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ri Jesús y ri ru-discípulos xek'ax yan apu juc'an ruchi' ri lago, y (xe'apon, xe'ebos) pa jun lugar quichin ri aj-Gadara. ");
INSERT INTO cak_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Tok ri Jesús xel-e chupan ri canoa, jari' xuc'ul roma jun achi ri elenak-pe pa camposanto. Ri achi ri' c'o itzel espíritu riq'uin, ");
INSERT INTO cak_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","y ja ri pa camposanto c'o-vi jumul. Man jun vinak nitiquer niximo richin, nis-ta riq'uin cadena. ");
INSERT INTO cak_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Q'uiy (mul, paj) ximilo'n ruk'a-rakan che ch'ich' y che cadena, jac'a rija' man c'ayef ta chi eruc'ojpilo'n ri cadena y erumutun ri ch'ich'. Can man jun nitiquer chirij. ");
INSERT INTO cak_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi chak'a' chi pak'ij nibiyaj pa tak juyu' y ri pa camposanto, nisiq'uin y nusocola-ri' che abaj. ");
INSERT INTO cak_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Tok ri achi ri' xutz'et-apu ri Jesús chi naj, junanin xbe-apu riq'uin y xxuque' chuvech. ");
INSERT INTO cak_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rija' riq'uin ronojel ruchuk'a' xu'ij-apu che: Rat Jesús ri Ruc'ajol ri nimalaj Dios pa ruvi' ronojel, ¿achique najo' chuve? Taya' atzij chuvech ri Dios chi man yinaya' pa k'axomal, nicha'. ");
INSERT INTO cak_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Quiri' xu'ij-pe, roma ri Jesús xu'ij che ri itzel espíritu chi tel-e riq'uin ri achi. ");
INSERT INTO cak_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y ri Jesús xuc'utuj che: ¿Achique abi'? xcha'. Legión nubi', roma roj q'uiy, xcha-pe ri itzel espíritu. ");
INSERT INTO cak_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y jani na nuc'utula-apu quemelal che ri Jesús chi man querelesaj-e chupan ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chiri' chorak'aric jun juyu', eq'uiy ak yeva'. ");
INSERT INTO cak_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y conojel ri itzel tak espíritu ri ec'o riq'uin ri achi, niquic'utula' quiquemelal chuvech ri Jesús, y niqui'ij: Taya' lugar chike chi nkujoc quiq'uin la ak ec'o chila', xecha'. ");
INSERT INTO cak_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús xu'ij chique chi utz. Xe'el c'a e ri itzel tak espíritu riq'uin ri achi, y xe'oc quiq'uin ri ak. Ri ak ec'o cami ca'i' mil, y conojel c'a niquitelela-qui' xebe chuvech jun rak'aric juyu' c'a pa ya', y chiri' xejik'-vi. ");
INSERT INTO cak_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ri yeyuk'un quichin ri ak xe'enimaj, y xbequiya' rutzijol pa tinamit y ri pa tak juyu', y ri vinak xepe c'a richin nuquitz'eta' ri achique xbanataj. ");
INSERT INTO cak_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tok xe'uka ri c'o-vi ri Jesús, xquitz'et chi tz'uyul ri achi ri xec'uje' q'uiy itzel tak espíritu riq'uin, rucusan rutziak y man nich'ujyej ta chic achel ri rubanon-pe, y romari' xa xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri xetz'eto ri achique xbanataj riq'uin ri achi ri xec'uje' itzel tak espíritu riq'uin, y ri achique xbanataj quiq'uin ri ak, xquitzijoj ronojel chique ri xequimolo-qui' chiri'. ");
INSERT INTO cak_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Romari' ri aj chiri' xquic'utuj favor che ri Jesús chi tel-e chupan ri qui-lugar. ");
INSERT INTO cak_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jac'a tok ntoc-e ri Jesús pa canoa chiri', ri achi ri xec'uje' itzel tak espíritu riq'uin, nuc'utula' quemelal che chi tuya' lugar chi ni'e chirij. ");
INSERT INTO cak_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jac'a ri Jesús man xuya' ta lugar, xa quire' xu'ij-e che: Cabin chi'avacho quiq'uin ri achak'-animal, y tatzijoj chique ri nimalaj favor xu'on ri Ajaf aviq'uin, y ri nimalaj rupokonaxic avech xu'on, xuche'ex. ");
INSERT INTO cak_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Xel c'a e ri achi chiri', xbe pa tak tinamit richin ri Decápolis, y nutzijola' ri nimalaj favor ri xu'on ri Jesús riq'uin. Y conojel ri ye'ac'axan, can achique na niquina'. ");
INSERT INTO cak_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Xe'oc c'a e ri Jesús y ri ru-discípulos pa canoa richin xek'ax chic apu juc'an ruchi' ri lago. Jac'a tok (xe'apon, xe'ebos) juc'an, eq'uiy vinak ri xuquimolo-qui' riq'uin. Y rija' chuchi' ri ya' xc'uje-vi. ");
INSERT INTO cak_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Y c'o c'a jun achi rubinan Jairo ri can c'o ruk'ij chupan ri sinagoga ri xjel-apu chiri', y tok xutz'et ri Jesús, ja xbexuque' chuvech. ");
INSERT INTO cak_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Rija' riq'uin quemelal quire' nu'ij che: Ri numi'al xe chic nijilo. Tabana' favor, jo' chuvij richin na'aya' ri ak'a' pa ruvi' richin nic'achoj y nic'ase' can, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xbe c'a ri Jesús chirij ri achi, y eq'uiy vinak etzekleyon-e richin, y can niquipitz'ila' ebenak. ");
INSERT INTO cak_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pero c'o c'a jun ixok ri ja doce juna' nibin ruquiq'uel roma jun yabil. ");
INSERT INTO cak_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ri ixok re' q'uiy c'ayef ruk'asan roma ri jalajoj aj-k'omanela' benak-vi; ronojel ruméra ruq'uison chic, y man jun ak'on rutaken ri yabil, xa más nuya-pe ruchuk'a' ri yabil chirij. ");
INSERT INTO cak_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Tok ri ixok re' xrac'axaj rutzijol ri Jesús, xjel-apu chirij chiquicojol ri vinak y (xutz'om, xuchop) apu ruchi' ri rutziak. ");
INSERT INTO cak_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Quiri' xu'on roma quire' ru'in-pe pa ránima: Xa riq'uin ta juba' (nintz'om, ninchop) apu ruchi' ri rutziak, yic'achoj. ");
INSERT INTO cak_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y xe quiri' xu'on ri ixok, jari' xtane' chi nibin ri ruquiq'uel. Can xuna' chi xc'achoj riq'uin ri ruk'axomal. ");
INSERT INTO cak_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús can jari' xuna' chi c'o uchuk'a' xel-e riq'uin. Xtzu'un c'a can chirij chiquicojol ri vinak, y xu'ij: ¿Achique (xtz'amo, xchapon) pe ri nutziak? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ri ru-discípulos xqui'ij che: Rat natz'et chi la vinak yatquipitz'ila' epetenak, ¿y c'a najo' navetemaj (achique, acu'x) xuya-apu ruk'a' chavij? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús c'ula' nitzu'un richin nrojo' nretemaj (achique, acu'x) ri xuya-apu ruk'a' chirij. ");
INSERT INTO cak_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Jac'ari' tok ri ixok roma xuna'ej chi xa xc'achoj riq'uin ri ruyabil, nibarbot ruxi'in-ri' xbexuque' chuvech y xu'ij che ronojel ri ruk'asan pa ruk'a' ri yabil. ");
INSERT INTO cak_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jac'a ri Jesús xu'ij che ri ixok: Numi'al, roma riq'uin ronojel avánima xape viq'uin, romari' xacolotaj chuvech ri ayabil. Vacami catzolij, ri avánima xril uxlanen. Ri yabil ri rat ruyo'on-pe pa c'ayef man chic xtitzolij ta pe. ");
INSERT INTO cak_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","C'a nich'o na ri Jesús riq'uin ri ixok chiri', tok ec'o e'elenak-pe chiracho ri achi c'o ruk'ij pa sinagoga ri quire' xqui'ij che: Jairo, ri ami'al (xcom, xquen) yan ka. ¿Achique chic roma ni'e ri Tijonel chavij? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Tok ri Jesús xrac'axaj ri xe'ix che ri achi, rija' quire' xu'ij che: Man taxi'ij-avi', xaxe tanimaj pan avánima chi nic'achoj ri ami'al, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús man xuya' ta lugar chi xebe chic ch'aka' chirij, xaxe ri Pedro, y ri ca'i' quichak'-quinimal qui' quibinan Jacobo y Juan. ");
INSERT INTO cak_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jac'a tok (xapon, xebos) chiracho ri achi c'o ruk'ij pa sinagoga, ri Jesús xutz'et chi yech'ujlan, y xutz'et ri ye'ok' y jani na sic' niqui'en. ");
INSERT INTO cak_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tok xoc-apu ri pa jay, rija' xu'ij chique: ¿Achique roma yixok' y yixch'ujlan? Ri xten re' man caminak ta, xa niver, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jac'a rije' xa xetze'en chirij ri Jesús. Xpe c'a rija' xerelesaj-pe conojel ri vinak. Xaxe ri te'ej-tata'aj y ri oxi' discípulos xerucusaj-apu ri achique lugar c'o-vi ru-cuerpo ri xten. ");
INSERT INTO cak_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jac'ari' (xutz'om, xuchop) apu ruk'a' ri xten y xu'ij che: Talita cumi, xcha'. Ri tzij re' nu'ij: Nóya, chave nin-ij-vi chi cacataj. ");
INSERT INTO cak_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Xe xu'ij quiri' ri Jesús, jari' xcataj-pe ri xten, y nibin, roma doce chic rujuna'. Y ri ec'o chiri' jani na xquixi'ij-qui' tok xquitz'et ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ri Jesús xu'ij chique chi man jun tiquelesaj rutzijol, y xu'ij chi tiquitzuku' ri xten. ");
INSERT INTO cak_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Xel c'a e ri Jesús chiri' y xbe pa rutinamit, y ri ru-discípulos xebe chirij. ");
INSERT INTO cak_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Tok xuka ri sábado ri k'ij richin uxlanen, ri Jesús yerutijoj ri quimolon-qui' pa sinagoga. Eq'uiy xsatz quic'u'x tok xquic'axaj ri ch'abel ri xu'ij chique, y niquibila': ¿Achique c'a lugar petenak-vi ronojel ri reteman? Y, ¿achel yo'on-pe ri no'oj re' che, y ri uchuk'a' ri nibano chi yebanataj re milagros chuk'a'? ");
INSERT INTO cak_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Roma ri achi re' xa jun samajiy-che', ral ri María, quinimal ri Jacobo, ri José, ri Judas y ri Simón. Ri rana' xa vave' chikacojol ec'o-vi, xecha'. Y ri vinak xa itzel xquina' che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Pero ri Jesús quire' xu'ij chique ri vinak: Nis-ta jun profeta ri man ta niyo'ox ruk'ij, pero man coma ta ri aj-rutinamit, man coma ta ri (eralpachel, yaraj-c'uaxel) ni man coma ta ri aj pa racho, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y manak che'el xu'on jun milagro ri Jesús chiri' pa rutinamit, xaxe ca'i-oxi' yeyavej ri xuya' ruk'a' pa quivi' richin xu'on chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ri Jesús can achique na xuna', roma ri ruvinak man niquinimaj ta achique rija'. Y xbe pa tak aldeas ri ec'o chiri' nakaj richin yerutijoj ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ri Jesús xeroyoj ri doce ru-discípulos, xerutak-e chi caca', y xu'on-e chique chi c'o quik'a' chi yequelesaj itzel tak espíritu. ");
INSERT INTO cak_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rija' xu'ij-e chique chi man jun achique tiquic'uaj richin ri quibey; xaxe ch'ami'y. Man tiquic'uaj morral, nis-ta pan, nis-ta méra pa tak (quipas, quic'an). ");
INSERT INTO cak_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xaxe quixajab tiquicusaj-e, y man tiquic'uaj jun chic solaj quitziak. ");
INSERT INTO cak_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y xu'ij-e chique: Xa achique na jay yixoc-vi, chiri' quixc'uje-vi, c'a ja tok xquixel-pe chupan ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Pero si c'o jun lugar man xtic'ul ta ivech, y man xticajo' ta xtiquic'axaj ri ruch'abel ri Dios ri nitzijoj rix, tok yixel-pe chiri', (tiquiraj, titota') can ri pokolaj pa tak ivakan chiquivech ri aj chiri', richin tiquina'ej chi man utz ta ri xqui'en. Jac'a yin kitzij nin-ij chive, chi tok xtuka ri k'ij chi xtinic'ox ronojel ch'utik-nima'k, más q'uiy castigo xtika pa quivi' ri man niquic'ul ta ivech, que chuvech ri xtika pa quivi' ri aj-Sodoma y ri aj-Gomorra, xcha-e chique. ");
INSERT INTO cak_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xebe c'a ri discípulos, niquitzijoj chique ri vinak chi tiquijala' quino'oj y tiquiya' can ri quimac. ");
INSERT INTO cak_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Q'uiy c'a itzel tak espíritu yequelesaj, y eq'uiy yeyavej niquiyala' can aceite olivo pa quivi' y yequic'achojrisaj can. ");
INSERT INTO cak_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri rey Herodes xrac'axaj chi ri Jesús q'uiy rutzijol chiquicojol ri vinak, pero nu'ij chi ri Jesús xa ja ri Juan ri Bautista ri xc'astaj-pe chiquicojol ri anima'i', y romari' ocunak nimalaj uchuk'a' riq'uin richin nitiquer yerubanala' milagros. Quiri' ri nunojij ri Herodes. ");
INSERT INTO cak_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Jac'a ch'aka' niqui'ij chi ri Jesús ja ri profeta Elías, ri xc'uje' ojer can. Ch'aka' chic niqui'ij chi jun profeta o jun chique ri profetas ri xec'uje' ojer can. ");
INSERT INTO cak_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tok ri rey Herodes xrac'axaj quiri', rija' nu'ij: Ri Jesús xa ja ri Juan ri Bautista ri xin-ij yin chi xcumix-e (rujolon, ruvi'), y vacami xc'astaj chic pe chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ri Herodes quiri' nunojij, roma ja rija' x-in chi (xtz'am, xchap) ri Juan y xxim pa cadena ri pa cárcel. Quiri' xu'on che ri Juan, roma ri Herodes rubanon-ka rixayil che ri Herodías, rixayil ri Felipe ri mismo runimal ri Herodes, ");
INSERT INTO cak_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","y ri Juan quire' ru'in che: Man juba' utz chuvech ru-ley ri Dios chi abanon-ka avixayil che ri Herodías, rixayil ri animal. Quiri' ru'in che. ");
INSERT INTO cak_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Romari' ri Herodías nikukut riq'uin royoval chirij ri Juan; can rurayin rucamic, pero man rilon ta achique nu'on richin nucamisaj. ");
INSERT INTO cak_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Roma ri Herodes ruchajin utz ri Juan richin man jun achique ti'an che, roma reteman chi jun chojmilaj achi cha'on roma ri Dios. Y tok ri Herodes nrac'axaj ri nutzijoj ri Juan che, can man nril ta achique nu'on riq'uin ri ni'ix che, pero nika chuvech nrac'axaj. ");
INSERT INTO cak_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero xuka c'a jun k'ij chi ri Juan nika pa ruk'a' ri Herodías, y ri' ja ri k'ij tok ri Herodes xu'on nimak'ij roma xuq'uis chic jun rujuna'. Ri Herodes xeroyoj ri nima'k tak quik'ij chupan ri ru-gobierno, ri e'uc'uay quichin ri soldados y ri vinak ri can c'o quik'ij pa departamento Galilea richin jun va'in. ");
INSERT INTO cak_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Najin ri nimak'ij chiri', tok xoc-apu ri xten ral ri Herodías, y xxojo chiquivech ri etz'uyul chuchi' mesa, y xka chuvech ri Herodes y chiquivech conojel. Jac'ari' tok ri rey Herodes xu'ij che ri xten: Tac'utuj ri achique najo' y yin xtinya' chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Can xuya' rutzij che y xu'ij: Xa achique na ri xtac'utuj, yin xtinya' chave, masque nic'aj che ronojel ri nin-en gobernar pa ruvi' nac'utuj, can xtinya' chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Xel c'a e ri xten, y quire' xu'ij che ri rute': Ri rey Herodes c'o xusuj chuve, y ¿achique cami ninc'utuj che, yacha' rat? Jac'a ri rute' quire' xu'ij che: Ja ri (rujolon, ruvi') ri Juan ri Bautista tac'utuj, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Xoc chic apu cha'anin ri xten riq'uin ri rey Herodes y xu'ij che: Yin ninjo' chi vacami mismo naya-pe pa jun plato ri (rujolon, ruvi') ri Juan ri Bautista, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ri rey Herodes xpe nimalaj bis pa ránima tok xrac'axaj quiri', pero roma ruyo'on chic rutzij che, y can chiquivech ri ec'o-apu riq'uin chuchi' mesa ru'in-vi, rija' man xrojo' ta xu'ij che ri xten chi manak che'el. ");
INSERT INTO cak_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Jac'ari' xutak-e jun soldado, y xu'ij chi tic'amer-pe (rujolon, ruvi') ri Juan ri Bautista. ");
INSERT INTO cak_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Xbe c'a ri soldado, xucumij-e (rujolon, ruvi') ri Juan chiri' pa cárcel, xuya' c'a pe pa jun plato, xuq'uen-pe che ri xten, y ri xten xberuya' che ri rute'. ");
INSERT INTO cak_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tok ru-discípulos ri Juan ri Bautista xquic'axaj ri xbanataj, xebe chuc'amic ri ru-cuerpo richin xquimuk. ");
INSERT INTO cak_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Tok xetzolij-pe ri apóstoles, xquimol-apu-qui' riq'uin ri Jesús, y xquitzijoj che ronojel ri achique chi samaj ri xequibana' y ri achique ruchojmil ri ruch'abel ri Dios ri xquiya' chiquivech ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ri Jesús xu'ij c'a chique: Jo' kayon achique lugar manak vinak richin nkujuxlan juba'. Quiri' xu'ij chique roma can eq'uiy vinak ye'el-ye'oc quiq'uin, y romari' nis-ta manak tiempo richin yeva'. ");
INSERT INTO cak_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Can xe'oc na vi e ri Jesús y ri ru-discípulos pa jun canoa y xebe pa jun lugar manak vinak. ");
INSERT INTO cak_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero eq'uiy xetz'eto quichin tok xe'oc-e chupan ri canoa, y xa xquetemaj-e ruvech. Eq'uiy c'a xe'el-e chicakan ri pa tak tinamit richin xbequila' ri Jesús ri lugar ri xbe-vi, y xa ja yan chic rije' ec'o-apu na'ey. Tok ri Jesús y ri ru-discípulos (xe'apon, xe'ebos), ri vinak xquimol-apu-qui' chiquij. ");
INSERT INTO cak_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tok xel-e ri Jesús ri pa canoa, xutz'et chi eq'uiy vinak coyo'en, y xupokonaj quivech roma e'achel ovejas ri manak quiyuk'unel; y (xutz'om, xuchop) c'a yerutijoj pa ruvi' q'uiy tak cosas. ");
INSERT INTO cak_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jac'a tok xk'ak'ij-ka, ri ru-discípulos xejel-apu riq'uin y xqui'ij che: Ri rojc'o-vi manak vinak y ja xk'ak'ij-ka; ");
INSERT INTO cak_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","romari' más utz ye'atak-e ri vinak pa tak lugares nakaj y pa tak aldeas richin nequilok'o' pan roma manak achique richin niquitij, xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jac'a ri Jesús xu'ij chique ri ru-discípulos: Rix quixtzuku quichin, xcha'. Y rije' xqui'ij che: ¿Najo' chi nekalok'o' pan che rajil vakxaki' ic' samaj richin yekatzuk conojel re'? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jac'a ri Jesús xu'ij chique: Te'itz'eta' ajani pan c'o iviq'uin, xcha'. Tok quitz'eton chic, rije' xqui'ij: Vo'o' pan y ca'i' quer, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jac'ari' xu'ij chique chi tiquibana' chi quetz'uye' conojel chi tak botzaj chosabána rex. ");
INSERT INTO cak_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y can quiri' vi xqui'en; chi a cien y chi nic'aj tak ciento xquic'uaj-qui', xetz'uye' pa ruvi' ri sabána. ");
INSERT INTO cak_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xeruli'ej ri vo'o' pan y ri ca'i' quer, xtzu'un c'a e chicaj y xumatioxij che ri Dios. Jac'ari' xeruper ri pan, xuya-e chique ri ru-discípulos richin chi niquiya' chiquivech ri vinak, y xujachala' ri quer chiquivech conojel. ");
INSERT INTO cak_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Conojel xeva' y jabel xnoj quipan. ");
INSERT INTO cak_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","C'ajari' xquimol ri ruchi' tak pan y ri quer ri man xq'uis ta, y c'a xnoj na doce chaquech. ");
INSERT INTO cak_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Y ri xeva', evo'o' mil achi'a'. ");
INSERT INTO cak_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ri Jesús xerucusaj-e ri ru-discípulos chupan ri canoa, richin quenabeyaj-e chuvech c'a pa Betsaida, ri c'o-apu juc'an ruchi' ri lago; roma rija' c'a nich'o na can chique ri vinak richin yerutak-e chi tak cacho. ");
INSERT INTO cak_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y tok erutakon chic can chi tak cacho, rija' xbe-e chuvech jun juyu' richin nerubana' orar. ");
INSERT INTO cak_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tok xoc-pe ri ak'a', ri Jesús c'a c'o na chiri', jac'a ri canoa ri ebenak-vi ri discípulos, pa nic'aj chic ya' c'o-vi-apu. ");
INSERT INTO cak_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Rija' xerutz'et-apu ri ru-discípulos chi c'ayef ebenak y k'alaj chi ecosnak chic, roma ri cak'ik' nurutz'ajij-ri' chuvech ri canoa. Y c'a cumaj na sakar chupan ri rucaj parte richin ri ak'a', rija' nibin pa ruvi' ri ya' benak-apu quiq'uin, y xunojij chi nik'ax-e chiquivech. ");
INSERT INTO cak_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Jac'a rije' tok xquitz'et chi c'o jun nibin pa ruvi' ri ya', xquinojij-ka chi jun xibinel, y xesiq'uin ");
INSERT INTO cak_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","roma conojel xetz'eto richin y xquixi'ij-qui'. Jac'a ri Jesús cha'anin xch'o-pe chique y xu'ij: ¡Ticovij-ivi', man tixi'ij-ivi'! Xa ja yin, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xoc c'a e quiq'uin pa canoa, jac'ari' xtane-ka ri cak'ik'. Ri discípulos jani na xsatz quic'u'x y achique na xquina' tok xquitz'et ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Rije' quiri' xqui'en roma man (k'axnak, novinak) ta chiquivech ri achique chi uchuk'a' c'o riq'uin ri Jesús, masque rije' xquitz'et tok xu'on chi xq'uiyer ruvech ri pan richin xerutzuk ri vinak. Roma ri cánima cof rubanon jumul. ");
INSERT INTO cak_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tok quik'asan chic ruvi' ri lago, (xe'apon, xe'ebos) pa Genesaret y xquixim can ri canoa chiri'. ");
INSERT INTO cak_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jac'a tok xe'el-e chupan ri canoa, cha'anin xetemex ruvech ri Jesús coma ri ec'o chiri'. ");
INSERT INTO cak_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Pa ronojel c'a lugar ri ec'o-pe nakaj xequiyala-vi rutzijol, romari' ri vinak can ja ri achique lugar xquic'axaj chi c'o-vi, chiri' xequic'uaj-vi ri yeyavej chuvech tak varo'el. ");
INSERT INTO cak_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Xa achique na juyu', aldea o tinamit ntoc-vi ri Jesús, ri vinak xequiyala' ri yeyavej chuchi' tak bey ri nik'ax-vi rija', y niquic'utula' favor che chi tuya' lugar chique ri yeyavej chi masque xaxe juba' ruchi' rutziak (niquitz'om, niquichop) apu. Y conojel ri (yetz'amo, yechapo) apu, yec'achoj riq'uin ri quiyabil. ");
INSERT INTO cak_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Riq'uin ri Jesús chiri', xquimol-apu-qui' achi'a' fariseos y ca'i-oxi' achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés ri epetenak pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Rije' xequitz'et chi ec'o chique ri ru-discípulos ri Jesús yeva', pero man ch'ajch'oj ta quik'a'. Quiri' xqui'ij rije' roma ri discípulos man xquich'aj ta ka quik'a' achel niqui'en ri achi'a' ri'. ");
INSERT INTO cak_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Roma ri achi'a' fariseos y conojel ri israelitas, ley quibanon che ri bin can coma ri ojer tak quivinak, y romari' si man niqui'en ta utz-utz pa ruchojmil ri ch'ajoj-k'a' achel c'utun can chiquivech, man yeva' ta. ");
INSERT INTO cak_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tok yetzolij-pe ri pa tak c'ayibel, man yeva' ta si man niquich'ajch'ojij ta qui' na'ey. Jalajoj tak costumbres ri quic'ulun can quiq'uin ri ojer tak quivinak ri quibanon ley chique achel ri ch'ajoj tak kumbel-ya', ch'ajoj tak bojo'y, ch'ajoj tak lak ri ebanon che ch'ich' y ri ch'ajoj ri yequi'en che ri lugar yerak'e-vi tok yeva'. ");
INSERT INTO cak_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Romari' ri achi'a' fariseos y ri achi'a' q'uiy queteman chirij ri ley xquic'utuj che ri Jesús: ¿Achique roma ri a-discípulos man niquinimaj ta ri qui'in can ri nimalaj tak kamama'? Roma tok yeva' man niqui'en ta ri ch'ajoj-k'a' achel qui'in can ri kamama', xecha'. ");
INSERT INTO cak_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero ri Jesús xu'ij chique ri achi'a' ri': Rix xa ca'i' rupalaj ri itzij. Can pa choj ru'in can ri profeta Isaías chivij chupan ri rutz'iban can ri nu'ij: Ri vinak re' xaxe riq'uin quichi' niquiya-vi nuk'ij, Jac'a ri cánima naj c'o-vi-e viq'uin. ");
INSERT INTO cak_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Man jun nic'atzin-vi chi niquiya' nuk'ij, Roma xa yepaxa'an riq'uin quitzij vinak y niqui'ij chi jari' ri nic'atzin chi ni'an. Quiri' rutz'iban can ri Isaías. ");
INSERT INTO cak_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Riq'uin ri yixtajin, rix xa iyo'on can juc'an ri ru'in can ri Dios, y xa ja ri qui'in can ri ivinak ojer ri yixtajin riq'uin, achel ri ch'ajoj tak bojo'y y ch'ajoj tak kumbel-ya'. Y q'uiy chic más achel ri' ri ye'ibanala', xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jac'ari' tok ri Jesús xu'ij chique: Rix jabel ivilon ruchojmil richin iyo'on can juc'an ri ru'in can ri Dios, riq'uin ni'en ri quic'utun can ri ivati't-imama' ojer. ");
INSERT INTO cak_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Roma ri erutz'iban can ri Moisés nu'ij: Taya' quik'ij ri ate-atata'. Y ri itzel nich'o chirij rute' o rutata', man roma chic q'ues, xa ticamises. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jac'a rix niya' quino'oj ri vinak y quire' ni'ij chique: Vacami quire' ti'ij chique ri ite-itata': Yin man yitiquer ta chic yixinto', roma ri c'o viq'uin ri c'o ta che'el nincusaj richin yixinto', xa nusujun chic che ri Dios. Quiri' quino'oj niya' rix ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Junan nu'ij chi rix man niya' ta chic lugar chique chi yequito' ri quite-quitata'. ");
INSERT INTO cak_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Xa iyo'on can juc'an ri ru'in can ri Dios riq'uin ni'en ri quic'utun can ri ivati't-imama' ojer. Y q'uiy chic más achel re' ri ye'ibanala'. Quiri' xu'ij ri Jesús chique ri fariseos y chique ri achi'a' q'uiy queteman chirij ri ley. ");
INSERT INTO cak_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jac'ari' xeroyoj-apu conojel ri quimolon-qui' chiri' y xu'ij chique: Tivac'axaj c'a chi'ivonojel ri xtin-ij y (tik'ax, tino') chivech: ");
INSERT INTO cak_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Man jun achique ntoc pa ruchi' ri vinak ri nibano che chi man ch'ajch'oj ta chuvech ri Dios, xa ja ri ntel-pe riq'uin ri ránima ri nibano chi man ch'ajch'oj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha' ri Jesús chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Tok ri Jesús xeruya' can, rija' xbe ri pa jay, y chiri' ri discípulos xquic'utuj ruchojmil ri ejemplo che. ");
INSERT INTO cak_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jac'a rija' xu'ij chique: ¿Ja jun rix man iveteman ta ruchojmil ri achique xin-ij? Tivetemaj c'a chi jun vinak, mana-ta ri achique yerutij-ka ri nibano che chi man ch'ajch'oj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Roma ri nutij-ka, man pa ránima ta ni'e-vi, xa chupan ni'e-vi-ka, y xa ntel-e. Riq'uin ri quiri' xu'ij ri Jesús, xu'on chi ronojel ri nitij pa ruvi' ri roch'ulef, can utz vi richin yetij. ");
INSERT INTO cak_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jari' tok ri Jesús quire' chic xu'ij: Ja ri achique ntel-pe pa ránima jun vinak, jari' ri nibano che chi man ch'ajch'oj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Roma pa ránima ntel-vi-pe chi ja ri man utz ta yerunojij, chi nuc'amala-ri' quiq'uin ri mana-ta achok riq'uin c'ulan-vi, chi nucusaj ri ru-cuerpo richin nic'uje' xa achok riq'uin na, chi nicamisan, ");
INSERT INTO cak_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","chi nelak', chi ni'e ránima pa ruvi' méra, chi yerubanala' itzel tak no'oj, chi nusetz quino'oj vinak, chi man nuk'at ta ri' yerubanala' mac ri nuyec q'uix, chi nikukut pa ránima chiquij ri utz ec'o, chi yerubila' tzij chiquij ch'aka' chic, chi nuna-ri' chi c'o ruk'ij, y chi man jun runo'oj riq'uin ri yerunojij. ");
INSERT INTO cak_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel itzel tak no'oj achel re' pa ránima ri vinak ntel-vi-pe, y jari' ri nibano che chi man ch'ajch'oj ta chuvech ri Dios. Quiri' xu'ij ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xcataj c'a e ri Jesús chiri', xel-e pa roch'ulef Israel, xbe chupan ri lugar ri c'o-vi ri tinamit Tiro y ri tinamit Sidón. Tok c'o chic chiri', xoc pa jun jay, y man nrojo' ta nina'ex chi chiri' c'o-vi. Pero man xtiquer ta xrevaj-ri' chiquivech ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Roma c'o jun ixok c'o jun ral xten ri ocunak jun itzel espíritu riq'uin. Ri ixok ri' tok xrac'axaj chi chiri' c'o-vi ri Jesús, xbe riq'uin y xxuque' chuvech. ");
INSERT INTO cak_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri ixok ri' man israelita ta, xa vinak aj-Sirofenicia, y nuc'utuj ruquemelal che chi trelesaj ri itzel espíritu riq'uin ri ral. ");
INSERT INTO cak_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jac'a ri Jesús xu'ij che: Nic'atzin chi na'ey na ri ralc'ua'l ri tata'aj quetzuk can utz-utz. Roma man utz ta chi ri pan quichin ri ac'ola' neleses chique richin niyo'ox chiquivech ch'utik tz'i', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero ri ixok xu'ij: Ajaf, can kitzij ri na'ij. Pero hasta ri ch'utik tz'i' ri yec'uje-apu chuxe' ri mesa, yequisic' ri ruchi' tak pan ri yequitzakala-ka ri ac'ola', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Roma ri ch'abel ri xa'ij, vacami catzolij, ri itzel espíritu xel yan e riq'uin ri aval, xcha' ri Jesús che. ");
INSERT INTO cak_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tok ri ixok xtzolij chiracho, xa relic cotz'ol ri ral choch'at xerila', roma ri itzel espíritu elenak chic e riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tok ri Jesús y ri ru-discípulos xe'el-pe chupan ri lugar ri c'o-vi ri tinamit Tiro, rija' c'a xk'ax na pa tinamit Sidón y chupan ri lugar rubinan Decápolis richin xxule-ka ri achique lugar c'o-vi ri lago Galilea. ");
INSERT INTO cak_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Tok c'o chic chiri', c'o jun man nac'axan ta ni man ntel ta utz rutzij ri xbeyo'ox chuvech. Ri ec'amayon-pe, niquiquemelaj-qui' niquic'utuj favor che ri Jesús chi tuya' ruk'a' pa ruvi' ri niyavej. ");
INSERT INTO cak_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xuc'uaj-e ruyon juc'an y xuju' ri ruvi-ruk'a' pa tak ruxiquin, xchuban c'a, y xuya-apu ruvi' ruk'a' chutza'n ri rak' ri niyavej. ");
INSERT INTO cak_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Xtzu'un c'a e ri Jesús chicaj, xjik'ijo' y xu'ij: Efata. Ri tzij ri' nu'ij: Tijakataj. ");
INSERT INTO cak_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Xe quiri' xu'ij ri Jesús, ja xejakataj ruxiquin ri niyavej y xsok'opitaj ri rak', y xtiquer xch'o utz. ");
INSERT INTO cak_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xu'ij chique ri vinak chi nis-ta jun achok che tiquitzijoj-vi ri xbanataj. Jac'a tok quiri' nu'ij-e chique, xa más niquelesaj rutzijol. ");
INSERT INTO cak_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y ri vinak can achique na niquina' niqui'ij: Jabel ri xu'on. Roma nu'on chique ri man ye'ac'axan ta chi yec'achoj; y nu'on chique ri man yech'o ta chi yech'o, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupan tak ri k'ij ri', xquimol chic apu qui' eq'uiy vinak riq'uin ri Jesús, y manak chic niquitij. Romari' ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yin ninpokonaj quivech ri vinak re', roma ja oxi' k'ij ec'o-pe viq'uin y vacami manak chic niquitij. ");
INSERT INTO cak_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Si xe quiri' quicoch'on vayijal yentak-e chi tak cacho, xa ye'etukutu' pa tak bey. Roma ec'o ri c'a naj epetenak-vi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Jac'a ri ru-discípulos xqui'ij-apu che: Pa jun chakijlaj tz'iran ulef achel ri rojc'o-vi, ¿achique lugar xtilitaj-vi q'uiy pan richin yetzuk conojel re'? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Y ri Jesús xuc'utuj chique: ¿Ajani pan c'o iviq'uin? xcha'. Vuku', xecha'. ");
INSERT INTO cak_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jac'ari' ri Jesús xu'ij chique ri vinak chi quetz'uye' pan ulef. Xeruli'ej ri vuku' pan, xumatioxij che ri Dios, xeruper c'a y xuyala-e chique ri ru-discípulos richin chi tiquiya' chiquivech ri vinak. Y ri discípulos can quiri' vi xqui'en. ");
INSERT INTO cak_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","(Chuka', ka) ec'o ca'i-oxi' ch'utik quer quiq'uin. Tok rumatioxin chic ri Jesús che ri Dios, jac'ari' xutak rujachic chique ri ec'o chiri'. ");
INSERT INTO cak_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Conojel xeva' y jabel xnoj quipan. Pero c'a xnoj na vuku' chaquech riq'uin ri ruchi' tak pan y ri ruchi' tak quer ri xemolotaj. ");
INSERT INTO cak_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xeva' chiri', jun cami (caji', quiji') mil vinak, y ri Jesús xerutakala' can chi tak cacho. ");
INSERT INTO cak_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jari' tok rija' xoc-e pa canoa quiq'uin ri ru-discípulos, y (xapon, xebos) pa jun lugar rubinan Dalmanuta. ");
INSERT INTO cak_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Xepe c'a achi'a' fariseos y (xquitz'om, xquichop) che tzij ri Jesús richin niquic'utuj che chi tubana' jun milagro chuvech ri rocaj, pero xaxe richin nicajo' chi nika pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ri Jesús xjik'ijo' ránima roma bis, y jac'ari' xu'ij: ¿Achique roma ri vinak richin ri vacami nicajo' niquitz'et chi c'o nibanataj chuvech ri rocaj? Kitzij nin-ij chi mana-ta ri nicajo' rije' ri xtibanataj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Xeruya' c'a can ri achi'a' fariseos, y xoc chic e jun bey ri pa canoa quiq'uin ri ru-discípulos richin yek'ax-apu juc'an ruchi-ya'. ");
INSERT INTO cak_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Tok ebenak chupan ri canoa, ri discípulos xquina'ej chi xquimestaj can pan richin niquitij, y ri pa canoa xaxe oc jun rutza'n pan c'o. ");
INSERT INTO cak_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jac'a ri Jesús richin xerupaxa'aj quire' xu'ij chique: Tibana' cuenta ivi' chuvech ri levadura quichin ri fariseos y ri levadura richin ri Herodes, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero ri discípulos xa niquich'olila-qui' chiquivech, y niqui'ij: Rija' quiri' xu'ij chike roma man jun pan xkaq'uen-pe, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero tok ri Jesús xuna'ej ri niqui'ij ri ru-discípulos, rija' xu'ij chique: ¿Achique roma rix nich'olila-ivi' roma ri manak pan xiq'uen-pe? ¿Man (xk'ax, xno') ta chivech ri xin-ij? Rix c'a cof na ibanon che ri ivánima. ");
INSERT INTO cak_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rix c'o runak' tak ivech, pero achel xa man yixtzu'un ta. C'o ixiquin, pero achel xa man yixac'axan ta, xa imestan ri nubanon chivech. ");
INSERT INTO cak_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tok yin xenper ri vo'o' pan chiquivech ri vo'o' mil vinak, ¿c'a ajani chaquech xenoj riq'uin ri ruchi' tak pan ri xe'imol? xcha' chique. Y ri discípulos xqui'ij: Doce. ");
INSERT INTO cak_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xu'ij c'a ri Jesús chique: Tok xentzuk ri (caji', quiji') mil vinak riq'uin ri vuku' pan ri xenper chiquivech, ¿c'a ajani chaquech xenoj riq'uin ri ruchi' tak pan ri xe'imol? xcha' chique. Vuku', xecha' ri discípulos. ");
INSERT INTO cak_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xu'ij chique: Si quiri', ¿achique roma man jani (tik'ax, tino') chivech ri xin-ij? ");
INSERT INTO cak_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jac'ari' (xapon, xebos) ri Jesús pa Betsaida. Chiri' ec'o ec'amayon-pe jun ri man nitzu'un ta chuvech, y niquiquemelaj-qui' niquic'utuj favor che chi tuya' ruk'a' pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ri Jesús xuyukej c'a e ri man nitzu'un ta y xrelesaj-e chuchi' ri aldea. Xuchubaj c'a apu runak'-ruvech, y xuya' ruk'a' pa ruvi'. Jac'ari' xuc'utuj che si c'o nutz'et. ");
INSERT INTO cak_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Tok ri man nitzu'un ta xujak ri runak'-ruvech, xu'ij: Yentz'et ri achi'a' achel tak che', pero yentz'et chi yebin, nicha'. ");
INSERT INTO cak_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jac'ari' tok ri Jesús xuya' chic apu ruk'a' chi tak runak'-ruvech ri man nitzu'un ta, y xu'on chi xtzu'un. Y can xtzu'un utz, chi naj chi nakaj jabel nutz'et ronojel. ");
INSERT INTO cak_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","C'ajari' xutak-e chiracho ri nitzu'un chic, y quire' xu'ij-e che: Man catek'ax-pe ri pan aldea, ni man tatzijoj chique ri ec'o chiri' ri xbanataj aviq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ri Jesús y ri ru-discípulos xebe ri pa tak aldeas ri ec'o pa ru-cuenta ri tinamit rubinan Cesarea ri ni'ix richin ri Felipe che. Tok ebenak pa bey, ri Jesús quire' c'a xuc'utuj chique ri ru-discípulos: ¿(Yin achique, ayincu'x) yin niquinojij ri vinak? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rije' xqui'ij: Ec'o ye'in chi ja rat ri Juan ri Bautista. Ec'o ye'in chi ja rat ri profeta Elías. Y ec'o ye'in chi rat jun chique ri profetas ri xec'uje' ojer can, xecha' ri discípulos. ");
INSERT INTO cak_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y rija' xuc'utuj chique: Jac'a chivech rix, ¿(yin achique, ayincu'x) yin? xcha'. Ri Pedro xu'ij-apu che: Ja rat ri Jun ri takon-pe chucolic rutinamit ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y ri Jesús xu'ij chique chi nis-ta jun achok che tiquitzijoj-vi. ");
INSERT INTO cak_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ri Jesús jac'ari' xutz'uc-e rutzijosic chiquivech ri ru-discípulos chi rija' ri xtak-pe richin xalex chiquicojol, nic'atzin chi nik'ax chupan q'uiy k'axomal. Itzel xtitz'et coma ri nima'k quijuna' achi'a' c'o quik'ij, coma ri nima'k tak quik'ij sacerdotes, y coma ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés; xticamises, pero chi rox k'ij xtic'astaj-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Can k'alaj rubixic ri ch'abel ri xeru'ij ri Jesús chique ri ru-discípulos, y tok ri Pedro xrac'axaj, xuc'uaj-e juba' quila' y xuch'olij. ");
INSERT INTO cak_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jac'a ri Jesús xtzu'un can chirij richin xerutz'et ri ch'aka' chic ru-discípulos y xu'ij che ri Pedro: ¡Catel-e chinuvech, rat Satanás! Roma ri nanojij xa junan riq'uin ri niquinojij ri vinak, y man nanojij ta ri achique nrojo' ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Tok ri Jesús eroyon chic pe ri vinak y ri más chic ru-discípulos, quire' xu'ij chique: Si c'o jun nrojo' yirutzekle'ej, tuya' can juc'an ri nurayij rija', man tupokonaj nuk'asaj c'ayef voma yin, masque necamises, y quirutzekle'ej. ");
INSERT INTO cak_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Roma xa achique na ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ruc'aslen voma yin, y roma ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, can xtril-vi. ");
INSERT INTO cak_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Roma, ¿achique utz nuq'uen-pe che jun vinak si nic'uje' ronojel beyomal richin ri roch'ulef riq'uin, y xa man nicolotaj ta? ");
INSERT INTO cak_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Y, ¿achique chi beyomal nitiquer nuya' jun vinak pa ruq'uexel ri ránima richin nril ri c'aslen ri richin jumul? Man jun. ");
INSERT INTO cak_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Roma ri xa xtiq'uix xtu'ij chiquivech ri aj-mac tak vinak itzel quic'aslen ri ec'o chupan ri tiempo re' chi yin runiman yin y ri nuch'abel, yin ri xitak-pe richin xinalex chi'icojol, tok xquipe chic jun bey riq'uin chic ruk'ij ri Nata', y epetenak ri lok'olaj ángeles chuvij, xquiq'uix xtin-ij chi ri jun ri' vichin yin. ");
INSERT INTO cak_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Quire' chic xu'ij ri Jesús chique ri ec'o riq'uin: Yin kitzij nin-ij chive chi ec'o jujun chive ri rixc'o vave' vacami ri man jani (quecom, quequen) chiri' tok xtiquitz'et ri ru-gobierno ri Dios chi petenak chic riq'uin ruchuk'a', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Tok k'axnak chic vaki' k'ij, ri Jesús quiyon ri Pedro, ri Jacobo y ri Juan xeruc'uaj chuvech jun juyu' naj jotol chicaj, pa jun lugar man jun ninakon quichin, y tok ec'o chiri', ri Jesús xjalataj ruvech chiquivech ri oxi' ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ri rutziak can nitz'intz'ot, sak-sak xu'on achel ri tef ri nika. Nis-ta jun ch'ajoy-tziek nitiquer quiri' nu'on che rusakil jun tziek. ");
INSERT INTO cak_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jac'a tok xquitz'et, yetzijon yan chic ri Elías y ri Moisés riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Jac'ari' tok ri Pedro xu'ij-apu che ri Jesús: Tijonel, utz ri rojc'o vave'; tikabana' oxi' tak jay, jun avichin rat, jun richin ri Moisés y jun chic richin ri Elías. ");
INSERT INTO cak_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro runojin man runojin quiri' xu'ij-apu. Roma chi oxi' discípulos quixi'in-qui'. ");
INSERT INTO cak_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Jac'ari' tok xka jun sutz' pa quivi' y xerumuk. Chupan c'a ri sutz' c'o Jun xch'o-pe ri xu'ij: Jare' ri Nuc'ajol, y yin can ninjo'. Tinimaj ri rutzij, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Jac'a tok xetzu'un chic apu ri oxi' discípulos, man jun chic jun xquitz'et, xa ruyon ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Tok exulan-pe chuvech ri juyu', ri Jesús xu'ij chique ri oxi' ru-discípulos: C'o ixiquin, man jun yan achok che titzijoj-vi ri xitz'et, c'a ja tok yin ri xitak-pe richin xinalex chi'icojol, yin c'astajnak chic pe chiquicojol ri anima'i', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Can xe vi quiq'uin rije' xcanaj-vi can ri ch'abel ri xu'ij ri Jesús, pero niquic'utula' chiquivech achique nu'ij tzij ri xu'ij chi c'a ja tok c'astajnak chic pe chiquicojol ri anima'i' chiri'. ");
INSERT INTO cak_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Jac'ari' tok ri oxi' discípulos xquic'utuj-apu che ri Jesús: ¿Achique roma ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés niqui'ij chi na'ey nuka ri Elías y c'ajari' nuka ri Jun ri nitak-pe chucolic ri rutinamit ri Dios? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jac'a ri Jesús xu'ij chique: Can kitzij vi chi na'ey nuka ri Elías, y nu'on can ruchojmil ronojel. Y romari' can xtibanataj na vi ri tz'iban can chuvij yin ri xitak-pe richin xinalex chi'icojol, chi xquik'ax na vi chupan q'uiy k'axomal y man jun nuk'ij xti'an chuve. ");
INSERT INTO cak_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Xaxe nin-ij chive chi ri Elías xuka yan. Y ri vinak xqui'en-e che xa achique na ri xcajo', can achel ri tz'iban can chirij, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Tok ri Jesús xtzolij-pe ri achique lugar ec'o-vi ri ch'aka' chic ru-discípulos, rija' xutz'et chi eq'uiy vinak quimolon-qui' chiquij, y jujun achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés ri niquich'olila-qui' quiq'uin ri discípulos. ");
INSERT INTO cak_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Pero tok conojel xquitz'et chi ja ri Jesús petenak, xel cánima xquitz'et y junanin xebe-apu riq'uin richin xequibana' saludar. ");
INSERT INTO cak_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xuc'utuj chique: ¿Achique roma nich'olila-ivi' quiq'uin ri nu-discípulos? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jun chique ri ec'o chiri' quire' rutzolic rutzij ri Jesús xu'on: Tijonel, nuc'amon-pe re nuc'ajol chavech ri mem rubanon roma jun itzel espíritu. ");
INSERT INTO cak_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Tok nuya' ruchuk'a' ri itzel espíritu, nu'on che chi nitzak pan ulef, chi nivokon pa ruchi', y chi nujach'ach'ej (rorey, rey), y romari' rucajman chic pa ruk'a'. Yin xich'o yan chique ri a-discípulos chi tiquelesaj ri itzel espíritu riq'uin, pero man xetiquer ta, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jac'a ri Jesús xu'ij chique: ¡Oh rix vinak ri rixc'o vacami! Nis-ta jun chive ri can ta cukul ruc'u'x riq'uin ri Dios. ¿Rix ninojij chi yin jumul yic'uje' iviq'uin? ¿O ninojij chi jumul xquixincoch'? Tic'ama-pe ri ala' vave', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xquiq'uen c'a pe ri ala' chuvech ri Jesús. Jac'a tok ri itzel espíritu xutz'et ri Jesús, xuquiyica' ri ala' riq'uin ruchuk'a', xutorij pan ulef. Chiri' nubolkotila-vi-ri' ri ala' y nivokon pa ruchi'. ");
INSERT INTO cak_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xuc'utuj che ri tata'aj: ¿C'o chic chi tiempo quire' nu'on ri ac'ajol? xcha'. Ri tata'aj xu'ij: C'a co'ol na chiri' tok ocunak riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Q'uiy (mul, paj) nutorij pa k'ak' y pa tak ya', richin nrojo' nucamisaj. Pero si rat c'o yatiquer na'an, tapokonaj kavech, y kojato', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jac'a ri Jesús xu'ij che: Aviq'uin rat c'o-vi, roma xa achique na ri cukul ruc'u'x viq'uin chi nibanataj ri nuc'utuj, ronojel nibanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Can jari' xch'o-apu rutata' ri ala' riq'uin ruchuk'a' y xu'ij: Yin cukul nuc'u'x aviq'uin, pero taya' más ruchuk'a' ri vánima, richin quiri' más cukul nuc'u'x aviq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tok ri Jesús xutz'et chi más eq'uiy vinak niquimol-apu-qui', rija' xuch'olij ri itzel espíritu, y quire' xu'ij che: Rat itzel espíritu ri abanon che ri ala' re' chi man nac'axan ta y man nich'o ta, catel-e y man catzolij chic pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jac'ari' tok ri itzel espíritu riq'uin ruchuk'a' xuquiyica' ri ala', y nisiq'uin xel-e. Achel jun caminak xpoq'ue' can ri ala' pan ulef, romari' eq'uiy chique ri ec'o-apu xquinojij chi kitzij caminak. ");
INSERT INTO cak_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús jari' (xutz'om, xuchop) apu ruk'a' richin xuyec, y ri ala' jari' xcataj-pe. ");
INSERT INTO cak_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Tok ri Jesús xoc-apu ri pa jay, ri ru-discípulos quire' xquic'utuj che quiyon: ¿Achique roma roj man xojtiquer ta xkelesaj-e ri itzel espíritu? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ri jun ruvech espíritu re', ntel, pero nrojo' oración y coch'on vayijal, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Tok xe'el-pe chiri', ja ri bey ri nik'ax pa departamento Galilea xquiq'uen-pe. Pero ri Jesús man nrojo' ta chi nina'ex chi nik'ax chiri'. ");
INSERT INTO cak_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Roma yerutijoj ri ru-discípulos benak y quire' nu'ij chique: Yin ri xitak-pe richin xinalex chi'icojol, xa xquijach-e pa quik'a' ri vinak y xquinquicamisaj. Pero chi rox k'ij xquic'astaj-pe. ");
INSERT INTO cak_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ri ru-discípulos man (nik'ax, nino') ta chiquivech ri najin chubixic ri Jesús chique, y xa niquixi'ij-qui' niquic'utuj-apu che. ");
INSERT INTO cak_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","(Xapon, xebos) c'a ri Jesús pa tinamit Capernaum. Y tok c'o chic ri pa jay, rija' quire' xuc'utuj chique ri ru-discípulos: ¿Achique c'a ri nichok'omayila' chivech tok roj petenak pa bey? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Jac'a ri discípulos man xech'o ta apu, roma tok ebenak ri pa bey, xa niquichok'omayila' chiquivech pa ruvi' ri achique más xtic'uje' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Xtz'uye' c'a ka ri Jesús, xeroyoj-apu ri doce discípulos y xu'ij chique: Si c'o jun nrojo' nic'uje' ruk'ij, nic'atzin chi ja rija' ri ruq'uisbel chique conojel y achel quisamajinel conojel. ");
INSERT INTO cak_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xeruc'ama' c'a pe jun ch'uti ac'ual ri Jesús, xuya' chiri' pa quinic'ajal. Xuch'elej c'a, y xu'ij chique ri ru-discípulos: ");
INSERT INTO cak_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri pa nubi' yin nuc'ul ruvech jun ac'ual achel re', man xe ta ri ac'ual nuc'ul ruvech, junan nu'ij chi ja yin nuc'ul nuvech. Y ri yiruc'ul pa ránima, man xe ta yin yiruc'ul, xa can nuc'ul ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ri Juan xu'ij-pe che ri Jesús: Tijonel, roj c'o jun katz'eton can ri pan abi' rat yerelesaj itzel tak espíritu. Pero roma man petenak ta chikacojol richin ta junan rat katzekle'en, roj xka'ij che chi man chic tu'on quiri', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jac'a ri Jesús xu'ij: Man tik'at chuvech. Roma si pa nubi' yin yerubanala' milagros, man cha'anin ta xtijalataj runo'oj richin yerubila' yan chic itzel tak ch'abel chuvij. ");
INSERT INTO cak_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Roma xa achique na ri man nicataj ta chikij, xa junan ránima kiq'uin. ");
INSERT INTO cak_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y xa achique na ri pa nubi' yin nusipaj juba' iya' roma rix, rix vichin yin ri xitak-pe chucolic rutinamit ri Dios, kitzij nin-ij chive chi can c'o rajil-ruq'uexel xtiyo'ox che. ");
INSERT INTO cak_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Y ri ec'o-pe re' ri man jani ruchuk'a' cánima riq'uin ri Dios, pero cukul quic'u'x viq'uin; xa achique na jun nibano che jun chique rije' chi nuxutuj can ri Dios, más utz che ri nibano quiri' chi na'ey ta xxim-e jun abaj joc'oy trigo chukul y xec'ak can pa mar. ");
INSERT INTO cak_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Romari', si jun ak'a' nibano chave chi naxutuj can ri Dios, tachoyo-e; más utz chave chi xe jun ak'a' c'o, y yatoc chupan ri c'aslen ri richin jumul, que chuvech tz'akat ca'i' ak'a' y xa yabe chupan ri lugar ri c'o-vi ri k'ak' ri man juba' nichup-ka, ");
INSERT INTO cak_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ri achique lugar man (yecom, yequen) ta ka ri quijutil ri cuerpo, y nis-ta ri k'ak' man nichup ta ka. ");
INSERT INTO cak_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y si jun avakan nibano chave chi naxutuj can ri Dios, tachoyo-e; más utz chave chi xe jun avakan c'o, y yatoc chupan ri c'aslen ri richin jumul, que chuvech tz'akat ca'i' avakan y xa yatec'ak chupan ri lugar ri c'o-vi ri k'ak' ri man juba' nichup-ka, ");
INSERT INTO cak_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ri achique lugar man (yecom, yequen) ta ka ri quijutil ri cuerpo, y nis-ta ri k'ak' man nichup ta ka. ");
INSERT INTO cak_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Quiri' mismo jun runak'-avech, si jari' nibano chave chi naxutuj can ri Dios, tavelesaj-e; más utz chave chi xe jun runak'-avech c'o, y yatoc pa ruk'a' ri Dios richin yaru'on gobernar, que chuvech c'o ri ca'i' runak'-avech y xa yatec'ak pa k'ak', ");
INSERT INTO cak_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ri achique lugar man (yecom, yequen) ta ka ri quijutil ri cuerpo, y nis-ta ri k'ak' man nichup ta ka. ");
INSERT INTO cak_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Roma can xtipe na vi k'axomal pa quic'aslen conojel vinak, achel can ta pa k'ak' yek'ax-vi, y si c'o jun man nupokonaj ta ri' roma yin rutzekle'en, can c'o ratz'amil ri ruc'aslen, achel yetz'amis ri sipanic ri yeyo'ox pa ruvi' ru-altar ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ri atz'an can utz vi, pero si niq'uis-e ri ratz'amil, ¿achique chic xtiyo'ox riq'uin richin nitzolij-pe ri ratz'amil? Roma c'a ri', rix jumul tic'uje' ratz'amil ri ic'aslen, y tic'uje' uxlanen chi'icojol, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xel c'a e ri Jesús chiri', xbe pa departamento Judea, pa tak lugares ri ec'o-apu juc'an che ri rakan-ya' Jordán. Xequimolo' chic c'a qui' ri vinak riq'uin, y rija' xerutijoj chic jun bey achel rubanon-pe. ");
INSERT INTO cak_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xejel c'a apu jujun achi'a' fariseos riq'uin, roma nicajo' chi can ta nika pa quik'a', y xquic'utuj che si ru-ley ri Dios nuya' lugar chi jun achi nuya' can ri rixayil. ");
INSERT INTO cak_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jac'a ri Jesús xu'ij chique: ¿Achique ru'in can ri Moisés chive chi ni'en pa ruvi' ri nic'utuj? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rije' xqui'ij: Ri Moisés xuya' lugar chi ri achi c'o che'el nujach jun vuj che ri rixayil ri achok chupan nu'ij-vi chi nuya' can, y quiri' nujach can jumul, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y ri Jesús xu'ij chique: Roma rucovil ri ivánima rix vinak tok ri Moisés xutz'ibaj ri jun mandamiento ri'. ");
INSERT INTO cak_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero pa na'ey, ri Dios tok xeru'on ri vinak pa ruvi' ri roch'ulef, xe jun achi y jun ixok xu'on. ");
INSERT INTO cak_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Romari' ri ala' man xtic'uje' ta chic quiq'uin ri rute-rutata', xa xtiquic'uaj-qui' riq'uin ri rixayil, ");
INSERT INTO cak_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y xe jun xtiqui'en ri eca'i'. Romari', man eca'i' ta chic, xaxe jun quibanon. ");
INSERT INTO cak_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Roma c'a ri', ri xa jun rubanon ri Dios chique, man jun vinak tijacho quivech, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jac'a tok ri Jesús y ri ru-discípulos ec'o chic pa jay, ri discípulos xquic'utuj che ri achique ruchojmil ri c'a ja oc xu'ij-ka. ");
INSERT INTO cak_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ri Jesús xu'ij c'a chique: Xa achique na achi ri nuya' can ri rixayil y nuq'uen chic jun ixok, mac nu'on chuvech ri rixayil. ");
INSERT INTO cak_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Quiri' mismo ri ixok ri nuya' can ri rachijil y ni'e chic riq'uin jun achi, ri ixok ri' mac ri nu'on. Quiri' xu'ij chique. ");
INSERT INTO cak_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ec'o c'a ac'ola' xe'eyo'ox chuvech ri Jesús, richin nuya' ruk'a' pa quivi'. Pero ri ru-discípulos xa xequich'olij ri yeyo'on-apu ri ac'ola' chuvech. ");
INSERT INTO cak_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jac'a ri Jesús tok xutz'et ri yetajin ri ru-discípulos, man xka ta chuvech, y romari' xu'ij chique: Tiya' lugar chique ri ac'ola' chi yepe viq'uin, y man que'ik'at. Roma ri ye'oc pa ruk'a' ri Dios richin yeru'on gobernar, ja ri yebano che ri cánima achel cánima re ac'ola'. ");
INSERT INTO cak_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Can kitzij nin-ij chive, ri man nu'on ta achel ránima jun ac'ual richin nuc'ul pa ránima ru-gobierno ri Dios, man ntoc ta chiquicojol ri ye'an gobernar roma rija', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y chiquijununal xeruch'elej ri ac'ola', nuyala' ruk'a' pa quivi' y nuc'utuj ru-favor ri Dios pa quivi'. ");
INSERT INTO cak_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tok ri Jesús xel-e chiri' richin (xutz'om, xuchop) chic e rubey, jari' tok junanin xuka jun achi riq'uin, y ja xxuque-ka chuvech, y xu'ij che: Utzulaj Tijonel, ¿achique nic'atzin nin-en yin richin quiri' c'o nuk'a' che ri c'aslen ri richin jumul? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ri Jesús xu'ij che: ¿Achique roma rat na'ij chi yin utz? Man jun vinak utz, xaxe Jun utz, y ri' ja ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rat aveteman ruchojmil ri mandamientos ri xuya' ri Dios che ri Moisés ojer can. Chiri' nu'ij: Man tac'amala-ka-avi' riq'uin jun ri mana-ta achok riq'uin rat c'ulan-vi; man cacamisan; man catelak'; man tatz'uc tzij; man tasetz runo'oj jun vinak roma c'o najo' navelek'aj-e che; taya' quik'ij ri ate-atata'. Quiri' xu'ij ri Jesús che. ");
INSERT INTO cak_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tijonel, ronojel ri na'ij, yin c'a yin ac'ual na chiri' nubanon-pe, y c'a quiri' na vacami, xcha' ri achi. ");
INSERT INTO cak_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y ri Jesús xutz'et ruvech ri achi, y pa ránima xel-vi-pe chi xrojo', y xu'ij che: C'a c'o chic jun man abanon ta. Cabin, tac'ayij ronojel ri achajin, y ri rajil tajacha' chiquivech ri man jun oc quichajin, y xtic'uje' abeyomal chila' chicaj. C'ajari' catzolij y quinatzekle'ej; man tapokonaj nak'asaj c'ayef voma yin, masque yacamises, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ri achi tok xrac'axaj ri xu'ij ri Jesús, achel xubolkotij-ri' ri ránima xuna', y nibison xtzolij-e, roma can q'uiy beyomal c'o riq'uin. ");
INSERT INTO cak_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jac'ari' tok ri Jesús xtzu'un xe tak ruxiquin, y quire' c'a xu'ij chique ri ru-discípulos: Ri c'o quibeyomal, c'ayef chi ye'oc pa ruk'a' ri Dios richin yeru'on gobernar, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ri ru-discípulos can achique na xquina' tok xquic'axaj ri xu'ij ri Jesús. Jac'a rija' quire' chic xu'ij chique jun bey: Valc'ua'l, nin-ij c'a chive chi ri benak cánima pa ruvi' beyomal, c'ayef chi ye'oc pa ruk'a' ri Dios richin yeru'on gobernar. ");
INSERT INTO cak_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa más man c'ayef ta chi nik'ax jun camello pa ch'uti rujulil jun bak richin t'iso'n, que chuvech ntoc jun beyon chiquicojol ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jac'a ri discípulos más jun vi xuna' ri cánima tok xquic'axaj ri xu'ij ri Jesús, y xquibila' chiquivech: Si kitzij achel ri nu'ij, man jun xticolotaj, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y ri Jesús xerutz'et c'a apu ri ru-discípulos y xu'ij chique: Chivech rix aj-roch'ulef manak che'el nibanataj ri achel xin-ij, pero chuvech ri Dios xa ronojel c'o che'el nibanataj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jari' tok ri Pedro xu'ij-apu che: Tatz'eta' c'a, roj kayo'on can ronojel richin rat katzekle'en, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Y ri Jesús quire' xu'ij: Kitzij nin-ij chive chi xa achique na ri ruyo'on can racho, rute-rutata', rixayil, ralc'ua'l, ruchak', runimal, rana' o rujuyu' voma yin, y roma ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, ");
INSERT INTO cak_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ri nibano quiri', xtuc'ul jujun ciento más ruvi' che ri ruyo'on can chupan ri tiempo ri rojc'o-vi vacami. Roma can xtiyo'ox racho, ruchak', runimal, rana', rute', ralc'ua'l, y rujuyu', junan riq'uin k'axomal roma yin rutzekle'en; y chupan ri jun chic tiempo ri petenak chikavech apu, xtiyo'ox che ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero q'uiy chique ri ec'o na'ey vacami, xa xquecanaj can ruq'uisbel. Y q'uiy chique ri ec'o can ruq'uisbel, xa xqueyo'ox yan chic chi na'ey, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús y ri etzekle'ey richin ejotol-e pa tinamit Jerusalem, y ja rija' k'axnak-e chiquivech, pero rije' man niquil ta achique niquinojij chirij y xa quixi'in-qui' ebenak. Jac'ari' tok rija' xeroyoj chic e jun bey juc'an ri doce ru-discípulos richin xutz'uc-e rubixic chique ri achique xteruk'asaj. ");
INSERT INTO cak_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rija' quire' xu'ij chique: Rix iveteman chi pa tinamit Jerusalem roj jotol-vi-e. Chiri' yin ri xitak-pe richin xinalex chi'icojol, xquijach pa quik'a' ri nima'k tak quik'ij sacerdotes israelitas y pa quik'a' ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. Rije' xtiqui'ij chi quicamises, y xquinquijach pa quik'a' ri man israelitas ta. ");
INSERT INTO cak_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ri vinak ri' xquinquitze'ej, xquinquich'ey, xquinquichubaj, y xquinquicamisaj. Pero chi rox k'ij xquic'astaj-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jac'ari' tok ri Jacobo y ri Juan, ri eruc'ajol ri Zebedeo, xejel c'a apu riq'uin ri Jesús y xqui'ij che: Tijonel, roj nikajo' chi na'an ri achique xtikac'utuj chave, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y, ¿achique c'a ri nijo'? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rije' xqui'ij: Tok rat c'o chic ak'ij chiri', nikajo' chi naya' lugar chike chi jun nitz'uye-apu pan a-derecha y jun pan a-izquierda, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ri Jesús xu'ij chique: Rix man iveteman ta ri achique nic'utuj. ¿Nicoch' cami rix ri achel xti'an chuve yin? Roma yin can achel xqui'an bautizar chupan jun nimalaj k'axomal, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Nikacoch', xecha' rije'. Y ri Jesús xu'ij chique: Can kitzij vi chi rix xtik'asaj ri achel xti'an chuve yin, y xquix-an bautizar chupan k'axomal achel ri xtink'asaj yin, ");
INSERT INTO cak_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","jac'a ri nijo' rix chi jun nitz'uye' pa nu-derecha y jun pa nu-izquierda, man pa nuk'a' ta yin c'o-vi richin ninya'. Roma ri lugar ri' ja chique ri achok coma banon rubanic xtiyo'ox-vi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ri lajuj chic discípulos xpe coyoval chique ri Jacobo y ri Juan tok xquic'axaj ri achique niquic'utuj. ");
INSERT INTO cak_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: Rix iveteman chi ri ni'ix chi e-gobernantes choch'ulef, can ecajaf ri vinak niquina-qui'. Can nima'k quik'ij niquina-qui', y can ja rije' ye'in ri achique nic'atzin chi ni'an. ");
INSERT INTO cak_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Jac'a chi'icojol rix man quiri' ta. Roma ri nrojo' nic'uje' ruk'ij chive, nic'atzin chi rija' achel jun isamajinel. ");
INSERT INTO cak_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Y si jun chive nrojo' chi ja rija' na'ey, tubana' achel jun lok'on samajinel chi'icojol. ");
INSERT INTO cak_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Roma yin ri xitak-pe richin xinalex chi'icojol, man xipe ta richin yito'ox; yin xipe richin yito'on y richin ninya' nuc'aslen coma eq'uiy richin yecolotaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jac'ari' tok ri Jesús y ri ru-discípulos (xe'apon, xe'ebos) pa tinamit Jericó. Jac'a tok ye'el-pe chiri' junan quiq'uin eq'uiy vinak, chuchi' bey c'o jun achi tz'uyul man nitzu'un ta nu'on limosna rubinan Bartimeo, ruc'ajol jun achi rubinan Timeo. ");
INSERT INTO cak_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tok rija' xrac'axaj chi ja ri Jesús aj-Nazaret ri nik'ax chiri', riq'uin ruchuk'a' xch'o y xu'ij: ¡Jesús, rat ri rat riy-rumam can ri rey David, tapokonaj nuvech! xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pero eq'uiy xech'olin richin, chi titane-ka. Jac'a rija' xa más cof xch'o-pe y nu'ij: ¡Rat ri rat riy-rumam can ri rey David, tapokonaj nuvech! nicha'. ");
INSERT INTO cak_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Xpa'e' c'a ka ri Jesús y xu'ij chi toyox-pe. Ja c'a xcoyoj-pe ri man nitzu'un ta, y xqui'ij che: Tiquicot ri avánima, cacataj; ri Jesús yaroyoj, xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri achi xe xrac'axaj quiri', ja xuc'ak can ri ruk'u', xpa'e' c'a, y xbe-apu riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","¿Achique ri najo' chi nin-en chave? xcha' ri Jesús. Tijonel, yin ninjo' yitzu'un chic jun bey, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús xu'ij che: Catzolij, vacami xacolotaj roma nanimaj chi yin yitiquer nin-en chave chi yatzu'un. Jac'ari' xtzu'un chic, y xutzekle'ej c'a e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Tok nakaj chic ec'o-vi-apu che ri tinamit Jerusalem, ri achique lugar ec'o-vi ri ca'i' aldea Betfagé y Betania ri ec'o-apu chuvech ri juyu' Olivos, ri Jesús xerutak-apu ca'i' ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Rija' xu'ij-e chique: Quixbin-apu chupan la aldea la c'o-apu chivech. Xe xquixoc-apu, jari' nivil jun alaj burro ximil can chiri', ri c'a man jani (tich'oque', titz'uye') jun vinak chirij. Tisolo-pe y tic'ama-pe chuve. ");
INSERT INTO cak_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si c'o jun xti'in-pe chive chi achique roma nisol-pe ri burro, ti'ij che chi nic'atzin che ri Ajaf, pero cha'anin xtutzolij-pe, quixcha' can che. ");
INSERT INTO cak_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xebe c'a ri ca'i' discípulos, xquil ri alaj burro ximon can chuchi' jun puerta ri achique lugar nuc'ul-vi-ri' ca'i' bey, y xquisol-pe. ");
INSERT INTO cak_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero ec'o jujun chique ri ec'o chiri' quire' xqui'ij-pe chique ri ca'i' discípulos: ¿Achique roma nisol ri ch'uti alaj burro? xecha-pe chique. ");
INSERT INTO cak_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jac'ari' xqui'ij-apu ri ru'in-e ri Jesús chique. C'ajari' xyo'ox-pe lugar chique chi xquisol-pe ri alaj burro. ");
INSERT INTO cak_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xquiq'uen c'a pe che ri Jesús y xquiya-e jujun quitziak chirij ri burro y ri Jesús (xch'oque', xtz'uye') e chirij. ");
INSERT INTO cak_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Q'uiy chique ri ebenak chirij niquiriq'uila' jujun quitziak pa rubey richin niquiya' ruk'ij. Ch'aka' yequichoyola' ruk'a' tak che' y yequiya-ka pa rubey ebenak. ");
INSERT INTO cak_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri ebenak chuvech y ri ebenak chirij riq'uin cuchuk'a' quire' niqui'ij: ¡Matiox chi petenak ri Colonel re'! ¡Nimalaj favor c'o pa ruvi' re petenak pa rubi' ri Ajaf! ");
INSERT INTO cak_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox chi xtzolij chic pe ru-gobierno ri kamama' David! ¡Matiox che ri Dios chicaj! Quiri' niqui'ij ri vinak. ");
INSERT INTO cak_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xoc c'a apu ri Jesús pa tinamit Jerusalem, xek'ax-pe pa racho ri Dios, y tok rutz'eton chic can ronojel ri c'o chiri', xbe pa Betania junan quiq'uin ri doce ru-discípulos roma ja xoc-pe ri ak'a'. ");
INSERT INTO cak_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chuca'n k'ij, tok xe'el-pe ri pa Betania, ri Jesús nivayijan chiri'. ");
INSERT INTO cak_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Xutz'et c'a apu chi naj jun mata higo ri jabel rex ruxak, y xbe c'a apu chuxe' richin nutz'et si c'o ruvech. Pero tok xjel-apu chuxe', xutz'et chi xa ruyon ruxak roma man ruk'ijul ta richin c'o ruvech. ");
INSERT INTO cak_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jac'ari' tok ri Jesús quire' xu'ij che ri che': Man jun chic xtitijo jun avech, xcha' che. Y ri ru-discípulos xquic'axaj ri xu'ij. ");
INSERT INTO cak_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Tok (xe'apon, xe'ebos) pa tinamit Jerusalem, ri Jesús xoc pa racho ri Dios y (xutz'om, xuchop) pe cokotaxic ri yec'ayin y ri yelok'on chiri', y xuticmayila' can qui-mesas ri eq'uexoy ruvech méra, y ri quich'acat ri yec'ayin palomas. ");
INSERT INTO cak_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Man nuya' ta lugar chique ri quic'ualo'n eka'n chi yek'ax chiri' pa racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rija' yerutijoj, y quire' nu'ij chique: Chupan ri tz'iban can, ri Dios nu'ij: Ri vacho, jay richin oración quichin conojel quivech vinak. Jac'a rix xa quijul elek'oma' ibanon che, xcha' rija'. ");
INSERT INTO cak_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tok ri nima'k tak quik'ij sacerdotes y ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés xquic'axaj ri achique xu'on ri Jesús pa racho ri Dios, rije' niquicanola' achique ta niqui'en richin niquicamisaj, roma xa quixi'in-qui' chi conojel ri vinak elenak cánima pa ruvi' ruchojmil ruch'abel ri Dios ri achok riq'uin yerutijoj-vi. ");
INSERT INTO cak_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jac'a tok xoc-pe ri ak'a', ri Jesús xa xel-e ri chiri' pa tinamit Jerusalem junan quiq'uin ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Cumaj yan sakar chuca'n k'ij, tok ri Jesús y ri ru-discípulos xek'ax chic jun bey ri achique lugar c'o-vi ri jun mata higo, xquitz'et chi hasta ri rakan ri che' xchakij-ka. ");
INSERT INTO cak_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ri Pedro xuka chuc'u'x ri achique xu'ij ri Jesús che ri mata higo, y romari' xu'ij che: Tijonel, tatz'eta' la higo la xa'ij che chi man jun chic xtitijo jun ruvech; can xchakij-vi-ka, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jac'ari' tok ri Jesús xu'ij chique conojel ri ru-discípulos: Rix nic'atzin chi cukul ic'u'x riq'uin ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Roma yin kitzij nin-ij chive chi xa achique na ri ni'in che ri juyu' re' chi tel-e vave' y tik'ax chupan ri mar, can quiri' vi xtibanataj, si man caca' ta ruc'u'x nich'o che, y si riq'uin ronojel ránima nunimaj chi nibanataj. ");
INSERT INTO cak_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Roma c'a ri', nin-ij chive chi ronojel ri nic'utuj tok ni'en orar, tinimaj chi can xtiyo'ox-vi-pe chive, y can quiri' vi xtibanataj. ");
INSERT INTO cak_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jac'a tok ni'en orar, si c'o iyacon pan ivánima chirij jun ri c'o man utz ta rubanon chive, tibana' perdonar, richin quiri' ri Itata' ri c'o chicaj xtu'on perdonar ri man utz ta ri ni'en. ");
INSERT INTO cak_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roma si rix man ni'en ta perdonar, quiri' mismo ri Itata' ri c'o chicaj man xtu'on ta perdonar ri man utz ta ri ni'en. ");
INSERT INTO cak_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús y ri ru-discípulos xetzolij chic jun bey ri pa tinamit Jerusalem, y tok ri Jesús nibin chiri' pa racho ri Dios, jari' tok ri nima'k tak quik'ij sacerdotes, ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, y ri nima'k quijuna' achi'a' c'o quik'ij xejel-apu riq'uin, ");
INSERT INTO cak_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","y xquic'utuj che: ¿Achique ak'a' rat chi ye'abanala' ronojel re yatajin riq'uin? ¿Y (achique, acu'x) x-in chave chi quire' que'abanala'? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ri Jesús xu'ij: Quiri' mismo yin c'o jun ninjo' ninc'utuj chive. Ti'ij-pe chuve ri ninc'utuj chive, y yin xtin-ij chive ri achok riq'uin petenak-vi chi c'o nuk'a' chi quire' yenbanala'. ");
INSERT INTO cak_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tok ri Juan xeru'on bautizar ri vinak, ¿Dios cami biyon-pe che, o xa vinak? Ti'ij-pe chuve, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jac'a rije' niquichok'omayila' chiquivech y niqui'ij: Si xtika'ij che chi ri Juan ja ri Dios takayon-pe, ri Jesús xtu'ij chike chi achique roma man xkanimaj ta. ");
INSERT INTO cak_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y si xtika'ij chi xa vinak xe'in che ri Juan, c'ayef chike. Rije' quiri' niqui'ij roma niquixi'ij-qui' chi yecataj-pe ri tinamit chiquij, roma chiquivech conojel, ri Juan can profeta vi. ");
INSERT INTO cak_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Romari' quire' xqui'ij-apu che ri Jesús: Roj man keteman ta, xecha'. Quiri' mismo xtin-en yin; man xtin-ij ta chive achok riq'uin petenak-vi chi c'o nuk'a' chi yenbanala' quire', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ri Jesús xch'o chic c'a jun bey chique riq'uin ejemplos, y quire' xu'ij: C'o jun achi xutic uva chuvech ri rujuyu' y xuc'ojoj rij. Xu'on can jun achel pila ri pa rujuyu' richin niyitz'-vi ri uva, xu'on can jun garita quichin ri chajinel, xuya' c'a can ri rujuyu' pa (k'uch, cuchubal) chique ca'i-oxi' achi'a' ri xquesamajin ruvech, y xbe naj. ");
INSERT INTO cak_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Jac'a tok xril ruk'ijul, ri rajaf ri juyu' xutak-e jun rusamajinel quiq'uin ri yesamajin ruvech ri juyu', richin c'o che ruvech ri uva niyo'ox-pe che. ");
INSERT INTO cak_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero rije' xa chi oyoval xquic'ul-vi ri samajinel, xquich'ey-pe, y man jun ruvech ri uva xquiya-pe che. ");
INSERT INTO cak_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ri rajaf ri juyu' xutak chic e jun samajinel quiq'uin, pero xa xquic'akala-pe abaj chirij, y socotajnak (rujolon, ruvi') xcokotaj-pe. ");
INSERT INTO cak_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ri rajaf ri juyu' xutak chic e jun rusamajinel, pero xa xquicamisaj. Y c'a xerutak na q'uiy rusamajela' quiq'uin, pero ec'o xequich'ey-pe, y ch'aka' xequicamisaj. ");
INSERT INTO cak_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Ri rajaf ri juyu' c'o jun ruc'ajol ri can nrojo', y jari' xutak-e pa ruq'uisbel, roma quire' nunojij: Si ja ri nuc'ajol ri xteka quiq'uin, can xqueniman-vi chuvech, xcha-ka pa ránima. ");
INSERT INTO cak_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Jac'a ri yesamajin ruvech ri juyu' tok xquitz'et, quire' niquibila' chiquivech: Jare' xtoc can rajaf ri juyu' re'. Quire' quixampe, kacamisaj, richin quiri' pa kak'a' roj nic'uje-vi can ri juyu', xecha'. ");
INSERT INTO cak_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","(Xquitz'om, xquichop) c'a ri ala', xquicamisaj y xquelesaj-pe chupan ri juyu' ri tiquil-vi ri uva. ");
INSERT INTO cak_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Vacami c'a, ¿achique cami xtu'on rajaf ri juyu' chique ninojij rix? Rija' xtipe, xquerucamisaj, y ri juyu' ri tiquil-vi ri uva xtuya' chic pa (k'uch, cuchubal) chique ch'aka' samajela'. ");
INSERT INTO cak_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Man jun bey ibanon leer ri tz'iban can chupan ruch'abel ri Dios? Chiri' nu'ij: Ri abaj ri man juba' xcajo' xquicusaj ri banoy tak jay, Xa jari' xc'atzin richin ruchuk'a' ruxiquini'l ri jay. ");
INSERT INTO cak_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja ri Ajaf xbano quiri' che, Y roj ntel-e runak'-kavech nikatz'et. Quiri' nu'ij ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jac'ari' tok ri achok chique xutzijoj-vi ri ejemplo xcajo' chi can ta (xquitz'om, xquichop) ri Jesús, roma xquina'ej chi ja rije' ri xerutzijoj chupan ri ejemplo. Pero xa niquixi'ij-qui' chiquivech ri tinamit. Romari' xquiya' can ri Jesús y xebe. ");
INSERT INTO cak_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jac'ari' xequitak ca'i-oxi' achi'a' fariseos y ca'i-oxi' ruvinak ri rey Herodes riq'uin ri Jesús, roma nicajo' chi can ta nika pa quik'a' riq'uin ri yerubila'. ");
INSERT INTO cak_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tok ri etakon-e ec'o chic apu riq'uin ri Jesús, xqui'ij che: Tijonel, roj keteman chi rat xe ri kitzij na'ij, y man jun achok chuvech naxi'ij-vi-avi', roma mana-ta ri achique rubanic jun vinak ri natz'et, y pa ruchojmil nac'ut rubey ri Dios. Vacami c'a, ta'ij chike: ¿Nuya' cami lugar ru-ley ri Dios chi nitoj impuesto che ri rey César, o manak? ¿Utz cami nikatoj o man nikatoj ta? xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jac'a ri Jesús reteman chi xa ca'i' rupalaj quitzij riq'uin ri quiri' niquic'utuj che. Romari' xu'ij chique: ¿Achique roma nitij ik'ij richin nijo' yika pan ik'a'? Tic'ama-pe ri méra richin nintz'et ruvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xquiya' c'a apu ri méra che. Jac'ari' tok rija' xuc'utuj chique: ¿Achok ruvech y achok rubi' re c'o chuvech? xcha'. Y rije' xqui'ij: Richin ri rey César, xecha'. ");
INSERT INTO cak_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jari' tok ri Jesús xu'ij chique: Tiya' che ri César ri can richin vi ri César, y tiya' che ri Dios ri can richin vi ri Dios, xcha'. Tok rije' xquic'axaj quiri', can achique na xquina' che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jari' tok ec'o achi'a' saduceos xe'ech'o riq'uin ri Jesús. Ri saduceos man niquinimaj ta chi ri anima'i' xquec'astaj chic, y romari' quire' c'a xquic'utuj che: ");
INSERT INTO cak_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tijonel, ri Moisés rutz'iban can chike chi jun achi tok c'o jun ruchak' o runimal (nicom, niquen) e, nic'atzin chi rija' nic'ule' riq'uin ri ixok xmalcanij can, si ri ixok manak ral xc'uje', richin nic'uje' ral ri xa pa rubi' ri ámna niyo'ox-vi-ka. ");
INSERT INTO cak_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Quiri' xbanataj jun bey quiq'uin vuku' achi'a' quichak'-quinimal qui'. Ri na'ey xc'ule', pero (xcom, xquen) e, y man jun ralc'ua'l xc'uje'. ");
INSERT INTO cak_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ri ruca'n achi xc'ule' riq'uin ri malca'n-ixok, pero xa (xcom, xquen) e, y man jun ralc'ua'l xc'uje'. Quiri' mismo xu'on-e ri rox achi. ");
INSERT INTO cak_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Chi vuku' achi'a' quiri' xqui'en-e, y man jun xc'uje' ralc'ua'l riq'uin ri ixok. Y c'a pa ruq'uisbel (xcom, xquen) e ri ixok. ");
INSERT INTO cak_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Rat na'ij chi c'o na jun k'ij xquec'astaj-pe ri anima'i'. Si kitzij chi xquec'astaj-pe, ¿achique chique ri vuku' achi'a' re' xtoc rachijil ri ixok, tok chi vuku' achi'a' xe'oc rachijil? xecha' ri saduceos. ");
INSERT INTO cak_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jac'a ri Jesús xu'ij chique: Rix, rix satznak riq'uin ri ni'ij, xa man iveteman ta ri nu'ij ruch'abel ri Dios, ni man iveteman ta achique nitiquer nu'on ruchuk'a' ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roma tok xtuka ri k'ij chi ri anima'i' xquec'astaj-e, man xquec'ule' ta chic, ni manak chic xtiquiya' quitzij richin c'ulubic, xa xque'oc achel ri ángeles ri erichin chicaj. ");
INSERT INTO cak_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero chi ri anima'i' yec'astaj, can yec'astaj-vi. ¿Man ibanon ta c'a leer ri rutz'iban can ri Moisés, chi ri Dios quire' xu'ij che tok xch'o-pe chupan ri (xulu-quiej, zarza): Ja yin ru-Dios ri Abraham, ru-Dios ri Isaac y ru-Dios ri Jacob? ");
INSERT INTO cak_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Roma ri Dios man qui-Dios ta ri manak quic'aslen. Rija' qui-Dios ri c'o quic'aslen, romari' nin-ij chi rix xa rix satznak riq'uin ri ni'ij, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","C'o c'a jun chique ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, xjel-apu ri achique lugar yetzijon-vi ri Jesús quiq'uin ri achi'a' saduceos. Rija' xrac'axaj ri niqui'ij chiquivech, y roma utz nrac'axaj ri nu'ij ri Jesús, quire' c'a xuc'utuj-apu che: ¿Achique chique ri mandamientos ri xuya' ri Dios pa ruk'a' ri Moisés ri más c'o rakale'n? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xu'ij che: Ri mandamiento más c'o rakale'n ja ri nu'ij: Tivac'axaj c'a rix israelitas: Ri Ajaf ka-Dios xaxe jun. ");
INSERT INTO cak_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Tijo' ri Ivajaf Dios riq'uin ronojel ivánima, riq'uin ronojel ic'aslen, riq'uin ronojel ino'oj y riq'uin ronojel ivuchuk'a'. Jare' ri mandamiento ri más c'o rakale'n. ");
INSERT INTO cak_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ri ruca'n juba' ma junan, y quire' nu'ij: Achel najo-ka-avi' rat, quiri' mismo que'ajo' conojel. Y manak chic jun mandamiento ri más c'o rakale'n que chuvech ri ca'i' re', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ri achi q'uiy reteman chirij ri ley, xu'ij che ri Jesús: Tijonel, can quiri' vi. Can kitzij ri xa'ij chi ri Dios xaxe jun, y man jun chic jun. ");
INSERT INTO cak_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Y si nikajo' ri Dios riq'uin ronojel kánima, riq'uin ronojel kano'oj, riq'uin ronojel kac'aslen, y riq'uin ronojel kuchuk'a', y si achel nikajo-ka-ki' roj, quiri' mismo yekajo' conojel; ri quiri' nika'an, más c'o rakale'n que chuvech ri yekaporoj avaj y yekacamisaj chicop chuvech, xcha' ri achi q'uiy reteman chirij ri ley. ");
INSERT INTO cak_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Tok ri Jesús xutz'et chi ri achi can xucusaj runo'oj richin xch'o, xu'ij che: Nakaj-nakaj ratc'o-vi richin yatoc chiquicojol ri ye'an gobernar roma ri Dios, xcha'. Y jari' xtiquer-e chi nis-ta jun chic xucovij-ri' richin c'o más xuc'utuj-apu che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Tok ri Jesús yerutijoj ri quimolon-qui' pa racho ri Dios, quire' xu'ij: ¿Achique roma ri achi'a' q'uiy queteman chirij ri ley, niqui'ij chi ri Jun ri nitak-pe chucolic rutinamit ri Dios xa choj jun riy-rumam can ri rey David? ");
INSERT INTO cak_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tok mismo ri rey David quire' xu'ij tok uc'uan roma ri Lok'olaj Espíritu: Ri Ajaf Dios quire' xu'ij che ri Vajaf: Catz'uye-pe pa nu-derecha, C'a ja tok xquenya' chuxe' avakan ri itzel yatquitz'et. Quiri' xu'ij. ");
INSERT INTO cak_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Si ri rey David, Vajaf xcha' che, ¿achique roma ni'ix chi xa choj jun riy-rumam can? xcha' ri Jesús. Y ri jani na chi vinak ri ye'ac'axan-apu, can nika chiquivech ri nu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Tok ri Jesús yerutijoj ri vinak chiri', quire' nu'ij chique: Man ti'en rix achel niqui'en ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. Roma rije' nika chiquivech niquicusaj jucujak tak tziek richin quetz'etetaj chi c'o quik'ij, nika chiquivech chi ye'an saludar ri niquimol-vi-qui' ri vinak, ");
INSERT INTO cak_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","y nika chiquivech chi yetz'uye' ri pa na'ey tak ch'aquet ri pa tak sinagogas y ri pa tak va'in. ");
INSERT INTO cak_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Jabel yeno' (chubanic, cho'onic) richin c'o niquelek'aj chique ri malcani' tak ixoki'. Y xaxe richin quenimex, yelayoj riq'uin ri oración. Romari', más q'uiy castigo xtika pa quivi', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Tz'uyul yan chic ri Jesús chuvech ri caja ri niyo'ox-vi can ofrendas pa racho ri Dios, rija' yerutz'et ri tinamit ri niquijalala-qui' chi nequiya' can méra chiri', y man juba' ta oc ri beyoma' ri can q'uiy méra niquiyala' can. ");
INSERT INTO cak_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Y c'o c'a jun malca'n-ixok ri kitzij chi man jun oc ruchajin ri xberuya' can ru-ofrenda. Rija' xuya' can ca'i' ruvech tak méra ri man rubanon ta nis-ta jun centavo. ");
INSERT INTO cak_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jac'ari' tok ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: Kitzij nin-ij chive chi ja la malca'n-ixok la man jun oc ruchajin ri xyo'on can más q'uiy ofrenda pa caja que chiquivech conojel. ");
INSERT INTO cak_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Roma conojel ri xeyo'on can méra, xa ruvi' che ri quibeyomal xquiya' can. Jac'a ri ixok re', xuya' can ronojel ri juba' c'o riq'uin, ronojel ri nic'atzin che chi nutzuk-ri', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Tok ri Jesús ja ntel-pe pa racho ri Dios chiri', jun chique ri ru-discípulos xu'ij che: Tijonel, que'atz'eta' la nimalaj tak abaj ecusan riq'uin racho ri Dios, y la nimalaj tak jay ebanon, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jac'a ri Jesús xu'ij che ri ru-discípulo: Rat ye'atz'et ronojel ri nimalaj tak jay ri ebanon rubanic, pero c'o na jun k'ij tok man jun chique ri abaj ecusan xtic'uje' can pa ruvi' jun chic abaj ri man ta xquevulutaj-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tok ri Jesús xtz'uye-ka chorak'aric che ri juyu' Olivos, y chuvech apu c'o-vi ri juyu' ri c'o-vi ri racho ri Dios, jari' tok ri Pedro, ri Jacobo, ri Juan y ri Andrés quiyon quire' xquic'utuj che: ");
INSERT INTO cak_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ta'ij c'a chike: ¿Achique tiempo xquebanataj ri xa'ij-ka chirij racho ri Dios? ¿Y achique retal xtik'alajin richin nina'ex chi yebanataj yan? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ri Jesús xu'ij chique: Rix tibana' cuenta ivi' richin man jun tisatzo ino'oj. ");
INSERT INTO cak_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Roma c'o q'uiy xquepe ri xtiquik'ebaj-qui' chirij ri nubi' yin, y xtiqui'ij: Ja yin ri Jun ri yin takon-pe chucolic rutinamit ri Dios, xquecha'. Can eq'uiy xtiquisetz quino'oj. ");
INSERT INTO cak_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Jac'a tok xtivac'axaj chi c'o roch'ulef yetajin riq'uin guerra chiquivech, y xtivac'axaj chi riq'uin juba' nitiquer-pe más guerra, man c'a tisatz ivánima, roma nic'atzin chi can quiri' na vi yebanataj. Pero man ja yan ta ri' ri k'ij tok nitz'akat ronojel ri runojin ri Dios chi nibanataj choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Roma ec'o tinamit xquecataj chiquij ch'aka' chic tinamit. Ec'o reyes xquequitak soldados chiquij ch'aka' chic reyes. Xquebanataj cobrakan pa jalajoj tak lugares. Xquepe vayijal, y ec'o vinak xquecataj chi oyoval. Ronojel re' xaxe yan jun tz'ucubel richin ri k'axomal choch'ulef. ");
INSERT INTO cak_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero rix tibana' cuenta ivi'. Roma ec'o xquejacho ivichin pa quik'a' ri junan niqui'en gobernar. Xquixch'ay pa tak sinagoga. Xquixuc'uax chiquivech gobernadores y reyes roma yin iniman, richin xtiya' nutzijol yin chiquivech rije'. ");
INSERT INTO cak_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pero na'ey nic'atzin chi nitzijos chique conojel quivech vinak ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj. ");
INSERT INTO cak_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jac'a tok xquixuc'uax richin yixejach pa quik'a' gobernadores, rix man tich'ujirisaj-ivi' riq'uin ri achique xti'ij, ni man tinojij q'uiy chirij. Rix xaxe ri ch'abel ri xtiyo'ox chive chupan ri hora ri', jari' ti'ij. Roma mana-ta rix ri xquixch'o, xa ja ri Lok'olaj Espíritu xtich'o. ");
INSERT INTO cak_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Xtibanataj chi ec'o quichak'-quinimal qui' ri xtiquisujuj-qui' pa camic. Quiri' mismo xtiqui'en ri tata'aj quiq'uin ri calc'ua'l, y ec'o ac'ola' xquecataj chiquij ri quite-quitata' y xquequijach pa camic. ");
INSERT INTO cak_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Rix xa itzel xquixtz'et coma conojel roma iniman ri nubi' yin. Jac'a ri cof xtic'uje' chirakan ri Dios c'a pa ruq'uisbel, can xticolotaj-vi. ");
INSERT INTO cak_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pero tok xtitz'et chi chupan ri lugar ri man utz ta chi yebanataj, ja najin camic tak ch'o'oj ri xa jani na itzel chuvech ri Dios, ri achok pa ruvi' c'o rutz'iban can ri profeta Daniel, jac'ari' tok ri ec'o pa Judea que'enimaj-e pa tak juyu'. Ri nibano leer (tik'ax, tino') chuvech. ");
INSERT INTO cak_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri c'o-e pa terraza che ri racho, man chic tika-pe ri pa jay, ni man chic toc-apu ri pa jay chuc'amic ru-cosas. ");
INSERT INTO cak_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri nisamaj pa juyu', man chic titzolij-pe chiracho chuc'amic jun rutziak. ");
INSERT INTO cak_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Pero tok'ex quivech ri ixoki' ri quiri' quibanon, y ri ixoki' ri c'a yetz'uman na ac'ola' chiquik'a' chupan tak ri k'ij ri'. ");
INSERT INTO cak_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Roma c'a ri', tic'utuj che ri Dios chi tok xtic'atzin chi yixenimaj-e, man chupan ta ru-tiempo tef. ");
INSERT INTO cak_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Roma ri k'ij ri', can erichin vi k'axomal ri man jun bey quiri' banatajnak pa ruvi' ri roch'ulef xe tok banon can roma ri Dios c'a vacami, y nis-ta xtibanataj chic jun k'axomal quiri'. ");
INSERT INTO cak_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Si ri Ajaf Dios man ta nu'on co'ol che ri tiempo richin ri k'axomal ri', man jun nic'ase' can. Pero coma ri echa'on ri xerucha' rija', tok xti'an co'ol che ri tiempo ri'. ");
INSERT INTO cak_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan tak ri k'ij ri', xa achique na jun ri quire' xtu'ij chive: Titz'eta', jare' ri Jun ri takon-pe chucolic rutinamit ri Dios, o si xtu'ij chive: Titz'eta', ja c'o chila', xticha', rix man tinimaj ri nu'ij chive. ");
INSERT INTO cak_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Roma ec'o xquecataj-pe ri xtiquik'ebaj-qui' chi etakon-pe chucolic rutinamit ri Dios, y ec'o ri xtiquik'ebaj-qui' chi eyo'ol rubixic ri nu'ij-pe ri Dios pa cánima, y xtiquibanala' nimalaj tak retal y xquequibanala' ri man jun bey etz'eton richin niquisetz quino'oj ri echa'on chic roma ri Dios, xa ta yetiquer. ");
INSERT INTO cak_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero rix quixtzu'un juba'; yin ja xinya' can rutzijol ronojel chive. ");
INSERT INTO cak_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jac'a chupan tak ri k'ij tok k'axnak chic ri k'axomal ri', ri k'ij xtik'uk'umer ruvech, ri ic' man xtitzu'un ta chic, ");
INSERT INTO cak_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ri ch'umila' xquetzak-e chuvech ri rocaj, y ronojel ri nimalaj tak uchuk'a' ri ec'o chicaj xquesilon. ");
INSERT INTO cak_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","C'ajari' xquitz'etetaj yin ri xitak-pe richin xinalex chi'icojol, chi yin petenak pa tak sutz' riq'uin nimalaj uchuk'a' y nimalaj nuk'ij. ");
INSERT INTO cak_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y xquentak ri nu-ángeles chiquimolic ri enucha'on chic. Chi naj chi nakaj xquebe-vi pa ruvi' ri roch'ulef, y man jun lugar chuxe' ri rocaj ri man ta xquebe-vi. ");
INSERT INTO cak_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Tivelesaj ejemplo chirij ri che' higo. Tok ja yejotayin-pe ri ruk'a' y ye'el-pe c'ac'ac' tak ruxak, rix iveteman chi nuka yan ru-tiempo ri job. ");
INSERT INTO cak_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Quiri' mismo, tok xtitz'et chi yebanataj chic ronojel ri xin-ij yan ka chive, tivetemaj chi nakaj chic yinc'o-vi-pe, achel xa chuchi' chic jay. ");
INSERT INTO cak_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y yin kitzij nin-ij chive chi ronojel re' xtibanataj tok ri vinak richin ri vacami c'a man jani queq'uis-e chuvech re roch'ulef. ");
INSERT INTO cak_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ri roch'ulef y ri caj can xqueq'uis na vi, pero ri nuch'abel man xtiq'uis ta, xa can xquebanataj-vi ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jac'a ri k'ij y ri hora chi yin xquipe, man jun etemayon, nis-ta ri ángeles ri ec'o chicaj, nis-ta yin ri Ruc'ajol ri Dios, xaxe ri Nata' ri reteman. ");
INSERT INTO cak_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Roma c'a ri' rix, tibana' cuenta ri ic'aslen, quinivoyo'ej-apu, y tibana' orar, roma man iveteman ta ajan xquipe. ");
INSERT INTO cak_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Achel tok jun vinak ni'e naj y nuya' can ri racho pa quik'a' ri rusamajela' richin niquichajij. Rija' yeruya' can pa ruvi' ronojel, chiquijununal nuyala' can quisamaj. Jac'a che ri chajinel chuchi' ri puerta nu'ij can chi tic'ase' utz-utz tok nichajin. ");
INSERT INTO cak_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Quiri' mismo rix, quinivoyo'ej-apu, roma man iveteman ta ajan xquipe yin ri rajaf ri jay. Riq'uin juba' ja tok ntoc-pe ri ak'a', o pa nic'aj ak'a', o ja tok nitzirikin-pe quimama' ri ec' cumaj yan, o ja tok sak chic chiri'. ");
INSERT INTO cak_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Man xa c'ate retal xquinuka y xa yixver xquixunvila'. ");
INSERT INTO cak_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Pero achel ri nin-ij chive rix chi quinivoyo'ej-apu, quiri' mismo nin-ij chique conojel, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ri israelitas c'o ca'i' nimak'ij rutzekle'en-ri' niqui'en; jun ja ri pascua, y ri jun chic, ja tok niquitij ri pan manak levadura riq'uin. Xa ca'i' chic k'ij nrojo' chi nuka ruk'ijul chiri' tok ri nima'k tak quik'ij sacerdotes y ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés niquicanola' achique ta niqui'en chi che'elek'el nika ri Jesús pa quik'a' richin niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Pero niqui'ij chiquivech chi mana-ta chupan ri nimak'ij richin man quecataj-pe ri tinamit. ");
INSERT INTO cak_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Pan aldea Betania c'o-vi ri Jesús chiracho jun achi rubinan Simón, ri ni'ix leproso che roma xec'uje' itzel tak ch'a'c chirij. Jac'a tok tz'uyul-apu ri Jesús chuchi' mesa chiri', xoc-apu jun ixok ruc'amon-apu jun yacabel banon che jun abaj rubinan alabastro ri nojnak riq'uin jun jubulaj ak'on rubinan nardo ri jani na rajil. Ri ixok xuk'up-e rukul ri yacabel, y (xuk'ej, xuk'ij) ri ak'on pa (rujolon, ruvi') ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tok xquitz'et ri x-an che ri ak'on, ec'o jujun xcataj coyoval y xquibila': ¿Achique roma xaxe quiri' xtix-e la jubulaj ak'on la'? ");
INSERT INTO cak_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roma c'o ta che'el xc'ayix y xyo'ox ta más que chuvech nuch'ec jun samajinel jun juna', y ri méra xjach ta chiquivech ri man jun oc quichajin, yecha'. Can yejasloj-apu chirij ri ixok. ");
INSERT INTO cak_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xu'ij chique: Jun tiya-vi, ¿achique roma ninak? Rija' xa jun utzulaj favor ri xu'on chuve. ");
INSERT INTO cak_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Roma ri man jun oc quichajin, xa jumul ec'o chi'icojol, y xa achique na k'ij c'o che'el ni'en jun favor chique. Jac'a yin man jumul ta xquic'uje' iviq'uin. ");
INSERT INTO cak_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ri ixok re' xu'on ri achique xtiquer xu'on. Roma rija' richin yan rumukic ri nu-cuerpo xu'on tok xuya' ri ak'on chirij. ");
INSERT INTO cak_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yin kitzij nin-ij chive, chi xa achique na lugar pa ruvi' ri roch'ulef xtitzijos-vi re utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, chiri' xtitzijos-vi ri favor ri xu'on ri ixok re', richin c'uxle'el richin rija', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jac'ari' tok ri Judas Iscariote, jun chique ri doce ru-discípulos ri Jesús, xbe quiq'uin ri nima'k tak quik'ij sacerdotes richin xu'ij chique chi nujach ri Jesús pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tok rije' xquic'axaj quiri', xequicot y xquiya' quitzij chi niquiya' méra che. Jac'a ri Judas nucanoj achique ta nu'on richin nujach ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Tok xuka ri na'ey k'ij richin ri nimak'ij tok nitij ri pan manak levadura riq'uin, ri k'ij tok yecamises ri ovejas richin ri pascua, ri discípulos jari' xquic'utuj che ri Jesús: ¿Achique lugar najo' na'an-vi ri va'in chupan ri pascua re', richin nekabana' rubanic ronojel ri nic'atzin? xecha'. ");
INSERT INTO cak_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jac'ari' xerutak-e ca'i' chique ri ru-discípulos, y xu'ij-e chique: Quixbin pa tinamit Jerusalem; chiri' xtic'ul-ivi' riq'uin jun ri ruc'amon-pe jun (cucu', k'e'l) ya'. Rix titzekle'ej-e. ");
INSERT INTO cak_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ri jay ri xtoc-vi-apu, rix quixoc-apu chirij, y quire' ti'ij che ri rajaf-jay: Ri Tijonel quire' ru'in-pe: ¿Achique lugar c'o-vi ri cuarto vave' chi'avacho ri utz chi nin-en-vi ri va'in richin ri pascua quiq'uin ri nu-discípulos? quixcha' che. ");
INSERT INTO cak_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Jari' tok ri rajaf-jay xtuc'ut jun mama cuarto chivech pa ruca'n piso che ri racho ri nuc'un chic rupan. Ja chiri' tibana-vi rubanic ronojel ri xtic'atzin chike, xcha-e chique. ");
INSERT INTO cak_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebe c'a ri ca'i' discípulos, xe'oc-apu pa tinamit Jerusalem, y can xquil-vi ri achel ru'in-e ri Jesús chique. Chiri' xqui'en rubanic ronojel ri xtic'atzin chique chupan ri va'in richin ri pascua. ");
INSERT INTO cak_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jac'a tok xk'ok'a-ka, (xapon, xebos) ri Jesús junan quiq'uin ri doce ru-discípulos chiri' pa jay. ");
INSERT INTO cak_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Tok etz'uyul chuchi' ri mesa y ja yeva' chiri', ri Jesús xu'ij chique: Kitzij nin-ij chive, chi jun chive rix ri yixva' vave' viq'uin xquijacho-e pa quik'a' ri vinak, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Xpe c'a bis pa cánima tok xquic'axaj quiri', y chiquijununal quire' niquic'utuj-apu che: ¿La yin cami ri'? nicha' jun. ¿La yin cami ri'? nicha' chic jun. ");
INSERT INTO cak_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Quire' c'a xu'ij ri Jesús chique: Xa jun mismo chive rix ri rix doce, y ri' ja ri numuba-pe ri pan viq'uin chupan re lak. ");
INSERT INTO cak_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can kitzij na vi chi yin ri xitak-pe richin xinalex chi'icojol xquicamises, roma can quiri' vi tz'iban can chupan ri ruch'abel ri Dios. Pero, ¡tok'ex ruvech ri xtijacho-e vichin! Xa más utz che rija' man ta xalex, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y tok yeva' chiri', ri Jesús xuq'uen-apu ri pan richin ri pascua, xumatioxij che ri Dios, xuper c'a, xuya' chique, y xu'ij: (Titz'ama', tichapa') y titija' ri pan re', roma jare' ri nu-cuerpo. ");
INSERT INTO cak_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jac'ari' xuq'uen-apu ri vaso richin ri pascua, y tok rumatioxin chic che ri Dios, xuya' chique, y conojel xquikum juba' ri c'o chupan. ");
INSERT INTO cak_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Jac'ari' ri Jesús xu'ij chique: Ri c'o chupan ri vaso re', c'uxle'el richin ri nuquiq'uel ri xtibin richin nic'achoj ri c'ac'ac' ruvujil c'aslen ri nusuj ri Dios. Can xtibin-vi ri nuquiq'uel coma eq'uiy. ");
INSERT INTO cak_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kitzij nin-ij chive chi man chic xtinkum ta ruya'al-uva, c'a terila' na ri k'ij tok junan iviq'uin xtikakum jun chic ruya'al-uva chupan ru-gobierno ri Dios, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Tok xquibixaj yan ri bix richin ri pascua, ri Jesús y ri ru-discípulos xe'el-e chiri' pa jay richin xebe ri pa juyu' Olivos. ");
INSERT INTO cak_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Tok ebenak pa bey, quire' xu'ij chique: Chi'ivonojel rix caca' ic'u'x xquinixutuj can chupan ri ak'a' re'. Roma ri tz'iban can nu'ij: Tok yin xtinya' lugar chi xticamises ri Yuk'unel, ri ovejas xa xtiquiquiraj-e-qui'. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero tok yin c'astajnak chic pe chiquicojol ri anima'i', xquinabeyaj-e chivech chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Jac'a ri Pedro xu'ij: Masque conojel caca' quic'u'x xcatquixutuj can, pero yin man quiri' ta xtin-en, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pero ri Jesús xu'ij che: Yin kitzij nin-ij chave, chi rat chupan ri ak'a' re', na'ey chi nitzirikin-pe (camul, capaj) quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chi xa man aveteman ta nuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Jac'a ri Pedro más nutij ruk'ij nu'ij-apu che ri Jesús: Si hasta nic'atzin chi yin junan yicamises aviq'uin, can quiri' vi c'a ri', pero man xtin-ij ta chi man veteman ta avech. Y quiri' mismo xqui'ij conojel. ");
INSERT INTO cak_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri ru-discípulos (xe'apon, xe'ebos) pa jun lugar rubinan Getsemaní. Y rija' xu'ij chique: Chupan chi yin nenbana' orar, quixtz'uye' na can juba' vave'. ");
INSERT INTO cak_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Rija' xaxe ri Pedro, ri Jacobo y ri Juan xeruc'uaj riq'uin. Jac'ari' tok xtiquer-pe bis y k'axomal pa ránima. ");
INSERT INTO cak_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xu'ij c'a chique ri oxi' ru-discípulos: Jani na nibison ri vánima, nuya-ka camic chuve ninna'. Quixc'uje' can vave', y quixc'ase', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Rija' xbin chic apu juba' más y chiri' xjupe-vi-ka pan ulef nu'on orar. Nuc'utuj si c'o ta che'el chi naj nik'ax-vi ri k'axomal richin ri hora ri' che. ");
INSERT INTO cak_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Quire' nu'ij chupan ri ru-oración: Papá, rat ri rat Nata', yin veteman chi ronojel yatiquer na'an. Tabana' chi naj nik'ax-vi chuve ri jun k'axomal re'. Pero man ta'an ri ninrayij yin, xa ja ri najo' rat ri tibanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y tok xtzolij-pe quiq'uin ri oxi' ru-discípulos, xa yever xu'urila', y xu'ij che ri Pedro: Simón, ¿xa xaver-ka? ¿Man xatiquer ta xac'ase' jun ch'uti hora? ");
INSERT INTO cak_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Quixc'ase' y tibana' orar, richin quiri' man yixtzak pa mac. Yin veteman chi ri ivánima nurayij chi q'ues viq'uin re hora re'. Jac'a ri i-cuerpo xa nuk'oraj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jac'ari' xbe chic apu jun bey richin nerubana' orar, y xucamuluj chic rubixic ri ru-oración. ");
INSERT INTO cak_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tok xtzolij chic pe jun bey quiq'uin ri oxi' ru-discípulos, xa yever chic jun bey xu'urila', roma rije' al-al ri runak' tak quivech riq'uin ri varan. Man niquil ta chic achique niqui'ij-apu che. ");
INSERT INTO cak_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tok xtzolij-pe chi rox (mul, paj) quiq'uin ri oxi' ru-discípulos, quire' xu'ij chique: Vacami quixver, titz'akatisaj ri ivaran. Pero manak chic che'el, roma yin ri xitak-pe richin xinalex chi'icojol ja xril hora richin yijach-e pa quik'a' aj-mac tak vinak. ");
INSERT INTO cak_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Co quixcataj! Jo'. Titz'eta', ja petenak la xtijacho-e vichin, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","C'a quiri' na nich'o ri Jesús chique ri ru-discípulos, tok xuka ri Judas, jun chique ri doce ru-discípulos, eruc'amon-pe q'uiy vinak ri quic'ualo'n che' y espada. Re' etakon-pe coma ri nima'k tak quik'ij sacerdotes israelitas, coma ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés y coma ri nima'k quijuna' achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri xtijacho-e ri Jesús, ru'in chic pe chique ri achique retal xtu'on richin nuc'ut ri Jesús chiquivech. Rija' quire' ru'in-pe: Ja ri (xtintz'ubaj, xtintz'ub) chivech, jari' ri Jesús. Rix (titz'ama', tichapa'), y man tiya' lugar chi ni'e. Quiri' ru'in-pe chique. ");
INSERT INTO cak_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Romari' tok (xapon, xebos), ja xchojmin-apu riq'uin ri Jesús, y xu'ij che: Nutijonel, Nutijonel, xcha', y jari' (xutz'ubaj, xutz'ub). ");
INSERT INTO cak_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jari' tok ri vinak (xquitz'om, xquichop) ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Pero jun chique ri ec'o riq'uin ri Jesús chiri' xrelesaj espada y xusoc rusamajinel ri nimalaj sacerdote israelita; jun ruxiquin xutzaq'uij-e. ");
INSERT INTO cak_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jac'a ri Jesús xu'ij chique ri vinak: Yin mana-ta yin elek'on chi rix ic'amalo'n-pe che' y espada richin yinu'ic'ama'. ");
INSERT INTO cak_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yin k'ij-k'ij xic'uje' iviq'uin pa racho ri Dios richin xixintijoj riq'uin ri ruch'abel, y man (xinitz'om, xinichop) ta. Pero can quiri' na vi, richin quiri' nibanataj ri tz'iban can chupan ruch'abel ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Jari' tok conojel ri discípulos xe'enimaj y xquiya' can ruyon. ");
INSERT INTO cak_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero c'o c'a jun ala' benak chirij ri Jesús ri xaxe jun mama tziek rusalcamun-e chirij, pero xa (xtz'am, xchap) coma ri vinak ec'amayon-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Jac'a rija' xa xujolij-e-ri' chupan ri tziek y quiri' ch'anel xenimaj chiquivech. ");
INSERT INTO cak_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jac'ari' xuc'uax ri Jesús chiracho ri nimalaj sacerdote israelita. Xquimol c'a qui' ri nima'k tak quik'ij sacerdotes, ri nima'k quijuna' achi'a' c'o quik'ij y ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Jac'a ri Pedro xutzekle'ej-e ri Jesús c'a chojay che racho ri nimalaj sacerdote israelita, pero c'a naj c'o-vi can. Y ri chojay rija' xtz'uye-apu quiq'uin ri chajinel, numak'-apu-ri' chuchi' k'ak'. ");
INSERT INTO cak_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Pero juc'an chic, ri nima'k tak quik'ij sacerdotes y conojel ri achi'a' junan niqui'en gobernar niquicanola' jun tz'ucun tzij chirij ri Jesús, richin niquitak pa camic, pero man jun tzij xquil chirij. ");
INSERT INTO cak_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Roma eq'uiy vinak ri jalajoj tak tz'ucun tzij yequibila-apu chirij, pero man juba' junan ri yequibila-apu, roma xa jun vi nu'ij la jun, y jun vi chic nu'ij la jun. ");
INSERT INTO cak_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jac'ari' xepa'e-apu ch'aka' chic ri xqui'ij-apu jujun tz'ucun tak tzij chirij ri Jesús. Rije' quire' xqui'ij: ");
INSERT INTO cak_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Roj kac'axan tok rija' quire' ru'in: Ri racho ri Dios ri banon coma achi'a', yin (ninvulaj, ninvulij), y chi oxi' k'ij ninpaba' chic jun ri man achi'a' ta xquepaban. Quiri' ru'in, xecha-apu. ");
INSERT INTO cak_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero nis-ta ri eca'i' ri', man junan ta ri xqui'ij-apu. ");
INSERT INTO cak_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Xpa'e' c'a ri Caifás ri nimalaj sacerdote israelita pa quinic'ajal y xuc'utuj che ri Jesús: ¿Man jun achique na'ij riq'uin ronojel ri niqui'ij re' chavij? xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jac'a ri Jesús man jun tzij xu'ij; man jun rutzolic ch'abel xu'on. Romari' ri nimalaj sacerdote xuc'utuj chic apu jun bey che, y xu'ij: ¿Ja rat ri Jun ri nitak-pe chucolic rutinamit ri Dios? ¿Ja rat ri Ruc'ajol ri Dios ri can utz vi chi niyo'ox ruk'ij? xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xu'ij: Ja', ja yin. Y can xquinitz'et yin ri xitak-pe richin xinalex chi'icojol, chi yin tz'uyul-apu pa ru-derecha ri Dios, ri achique lugar c'o-vi ri nimalaj ruchuk'a'. Y xquinitz'et chi yin petenak pa sutz' ri chicaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jac'ari' tok ri nimalaj sacerdote israelita xurak'ach'ij-ka ri rutziak chirij, y xu'ij: ¿Achique chic más sujunel koyo'en chirij re achi re'? ");
INSERT INTO cak_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rix mismo xivac'axaj ri itzel xu'on chuvech ri Dios riq'uin ri xeru'ij. ¿Achique ni'ij rix pa ruvi'? xcha'. Conojel xqui'ij chi can utz vi chi nika camic pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jac'ari' ec'o (xquitz'om, xquichop) chi niquichubaj ri Jesús y chi niquitz'apij ruvech riq'uin jun tziek. Niquiyala' c'olon tak k'a' che, y niquibila': Tavila' achique yech'eyon avichin, yecha'. Ja jun ri yechajin racho ri Dios, xquipak'ila' che k'a'. ");
INSERT INTO cak_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Jac'a ri chojay ka, xeka jun raj-ic' ri nimalaj sacerdote riq'uin ri Pedro, ");
INSERT INTO cak_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","y xutz'et chi ri Pedro rumak'on-apu-ri' chi k'ak', y quire' c'a xu'ij che: Ja jun rat ratc'o riq'uin ri Jesús ri aj-Nazaret, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ri Pedro xa quire' xu'ij: Yin man veteman ta ruvech ri Jesús, nis-ta veteman ri achique yatajin chubixic, xcha' che ri aj-ic'. Xel c'a e ri Pedro chuchi' bey, y jari' tok xtzirikin-pe quimama' ri ec'. ");
INSERT INTO cak_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Jac'a tok ri aj-ic' xutz'et chic apu jun bey ri Pedro, xu'ij chique ri ec'o chiri': La achi la' jun chique ri ec'o riq'uin ri Jesús, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ri Pedro xa xu'ij chic jun bey chi man quiri' ta. Mier juba' chiri', ri ec'o chiri' xqui'ij chic jun bey che: Can kitzij vi chi rat, rat jun chique ri ec'o riq'uin ri Jesús. Roma rat pa Galilea yape-vi, y ri achel na'an yach'o, ja achel yech'o rije', xecha' che. ");
INSERT INTO cak_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Jac'ari' tok ri Pedro xu'ij: Yin chuvech Dios nin-ij chive chi man veteman ta ruvech ri achi ri nic'uxlaj-pe chuve. Y si man kitzij ta ri nin-ij, tika castigo pa nuvi', xcha'. ");
INSERT INTO cak_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Jari' tok xtzirikin chic pe quimama' ri ec' jun bey, y ri Pedro xuc'uxlaj c'a pe chi ri Jesús quire' ru'in can che: Na'ey chi nitzirikin-pe (camul, capaj) quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chique ri yec'utun chave chi man aveteman ta nuvech. Jari' nunojij rij ri Pedro, xujik' ok'ej. ");
INSERT INTO cak_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ja yan ri cumaj sakar, xquinojij achique niqui'en ri nima'k tak quik'ij sacerdotes israelitas y ri nima'k quijuna' achi'a' c'o quik'ij, ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' junan niqui'en gobernar. Romari' quiximon-e ri Jesús xequijacha' pa ruk'a' ri gobernador Pilato. ");
INSERT INTO cak_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y rija' quire' xuc'utuj che ri Jesús: ¿Ja rat ri Rey quichin ri israelitas? xcha'. Ja', quiri', achel ri na'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jac'a ri nima'k tak quik'ij sacerdotes q'uiy sujunic niqui'en-apu chirij. ");
INSERT INTO cak_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Y ri Pilato quire' chic xuc'utuj che ri Jesús: ¿Man jun achique na'ij richin nato-avi'? Tavac'axaj c'a ri ajani chi sujunic niqui'en-pe chavij, xcha' che. ");
INSERT INTO cak_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jac'a ri Jesús, masque quiri' xbix che, man jun rutzolic ri tzij xu'on, y romari' ri Pilato can achique na xuna' che. ");
INSERT INTO cak_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ri Pilato ronojel juna' chupan ri nimak'ij pascua can nucol-vi-e jun preso; pero ja ri tinamit yec'utun-apu ri achique preso nicol-e. ");
INSERT INTO cak_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Chupan tak ri k'ij ri', c'o jun kajnak pa cárcel rubinan Barrabás, etz'apel junan quiq'uin ch'aka' chic ri xequibanala' camic tok xecataj chirij ri gobierno. ");
INSERT INTO cak_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xepe c'a ri vinak, xquic'utuj che ri Pilato chi achel nu'on ronojel juna' chi nucol-e jun preso, quiri' tubana' vacami. ");
INSERT INTO cak_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Jac'a rija' quire' xu'ij-pe chique: ¿Nijo' chi nincol-e ri Rey quichin ri israelitas? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Quiri' xuc'utuj chique, roma reteman chi xaxe roma eq'uiy yetzekle'en richin ri Jesús tok ri nima'k tak quik'ij sacerdotes yekukut pa cánima xquijach pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Jac'a ri nima'k tak quik'ij sacerdotes xquiya' quino'oj ri vinak, chi tiqui'ij-apu che ri Pilato chi ja ri Barrabás tucolo-e. ");
INSERT INTO cak_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Jac'ari' tok ri Pilato xuc'utuj chic pe jun bey chique: ¿Y achique nijo' chi nin-en riq'uin ri achi ri ni'ij chi Rey quichin ri israelitas? xcha'. ");
INSERT INTO cak_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Xesiq'uin chic apu jun bey ri vinak y xqui'ij: ¡Taripa' chuvech cruz! xecha'. ");
INSERT INTO cak_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Jac'a ri Pilato quire' xu'ij-pe chique: Pero, ¿achique rumac rubanon chivech? xcha'. Pero rije' xa más riq'uin uchuk'a' xesiq'uin-apu y xqui'ij: ¡Taripa' chuvech cruz! xecha'. ");
INSERT INTO cak_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato roma nrojo' chi nika-ka cánima ri vinak, xucol-pe ri Barrabás, y jac'ari' xu'ij chi tich'ay ri Jesús. Tok banon chic ri xu'ij, jari' xujach-e richin tibajix chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Jac'ari' tok ri soldados xquic'uaj ri Jesús chojay che ri nimajay ri nic'uje-vi ri gobernador. Xecoyoj conojel ri soldados chirij, ");
INSERT INTO cak_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","y xquiya' jun tziek morado chirij y xquiya-ka jun corona pa (rujolon, ruvi'), banon che rakan tak xic'a'y c'o quiq'uixal. ");
INSERT INTO cak_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jac'ari' niqui'en-apu saludar ri Jesús, pero xaxe richin yetze'en chirij, y niqui'ij che: ¡Caquicot rat ri rat Rey quichin ri israelitas! yecha'. ");
INSERT INTO cak_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Niquipoj (rujolon, ruvi') che jun aj y niquichubaj. Yexuque-apu chuvech achel can ta niquiya' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Tok xetane' chi yetze'en chirij, xquelesaj-e ri tziek morado chirij. Jac'ari' xquiya-e ri can rutziak vi, y xquic'uaj c'a e richin nequibajij chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jac'a tok ebenak pa bey, xquic'ul jun achi aj-Cirene ri petenak pa juyu', nik'ax chiri' richin ntoc-apu pa tinamit. Ri achi re' rubinan Simón, quitata' ri Alejandro y ri Rufo, y ri soldados xqui'en che chi xuc'uaj ru-cruz ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","C'a pa jun lugar rubinan Gólgota xquic'uaj-vi ri Jesús. Gólgota nu'ij tzij, lugar richin rubakil (rujolon, ruvi') ámna. ");
INSERT INTO cak_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Chiri', rije' xquiya' jun ch'amilaj vino ri yo'on c'ayilaj mirra riq'uin che ri Jesús, pero rija' man xutij ta. ");
INSERT INTO cak_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jac'a tok quibajin chic chuvech ri cruz, chuvi' etz'anen xquijach-vi-e ri rutziak chiquivech, richin quiri' xa achique na rutziak niquich'ec-e chiquijununal. ");
INSERT INTO cak_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Richin a las nueve nisakar tok xquibajij ri Jesús chuvech ri cruz. ");
INSERT INTO cak_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y chutza'n-e ri cruz, chuvech jun pedazo tabla tz'iban ri achique roma nicamises. Chiri' nu'ij: QUI-REY RI ISRAELITAS. ");
INSERT INTO cak_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Jac'ari' junan riq'uin ri Jesús xequibajij ca'i' elek'oma' chuvech qui-cruz y chi tak rutzalanen xequiya-vi. ");
INSERT INTO cak_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Riq'uin c'a ri' xbanataj ri tz'iban can chupan ri ruch'abel ri Dios ri nu'ij: Achel ni'an chique ri vinak itzel quic'aslen, quiri' x-an-e che. Quiri' ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri yek'ax chiri', yequibila' can tzij chupalaj ri Jesús, niquisiquisa' can (quijolon, quivi') chuvech, y quire' niqui'ij can che: ¡Ah! Rat ri na'ij chi (navulaj, navulij) racho ri Dios y chi oxi' k'ij napaba' chic jun bey, ");
INSERT INTO cak_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","vacami, tacolo-avi' ayon y caka-pe chuvech la cruz, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Quiri' mismo ri nima'k tak quik'ij sacerdotes, y ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, richin man jun ruk'ij niqui'en ri Jesús, quire' niquibila' chiquivech: Rija' xerucol ch'aka' chic, pero man nitiquer ta nucol-ri' ruyon. ");
INSERT INTO cak_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Rija' ru'in chi takon-pe chucolic rutinamit ri Dios, y ru'in chi ka-Rey roj israelitas. Si quiri', tika-pe chuvech la cruz, richin chi nikatz'et chi kitzij ri nu'ij y c'ajari' xtikanimaj-apu, yecha'. Quiri' mismo ri elek'oma' ri ebajin chuvech qui-cruz chi tak rutzalanen, niquibila-apu tzij che. ");
INSERT INTO cak_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tok xnic'ajar ri k'ij, xk'uk'umer ruvech ronojel ri roch'ulef, y c'a richin las tres xk'ak'ij xq'uis-e ri k'eku'n. ");
INSERT INTO cak_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Richin las tres nik'ak'ij, ri Jesús riq'uin ronojel ruchuk'a' xu'ij: Eloi, Eloi, ¿lama sabactani? xcha'. Ri ch'abel ri' nu'ij tzij: Nu-Dios yin, nu-Dios yin, ¿achique roma xinaya' can nuyon? ");
INSERT INTO cak_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ec'o chique ri ec'o-apu chiri', tok xquic'axaj ri xu'ij, niquibila': ¿Xivac'axaj? Ja ri profeta Elías nroyoj, yecha'. ");
INSERT INTO cak_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Jun chique rije' cha'anin xeruc'ama-pe jun esponja, xumuba' pa jun ch'amilaj vino, xuya' chutza'n jun aj richin xutz'ub ri Jesús, y xu'ij: Tikoyo'ej na, k'alaj c'a ri' xtipe ri Elías chucolic, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero ri Jesús jari' xch'o riq'uin ronojel ruchuk'a' y (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jac'ari' tok ri pinilaj tziek ri achok che jachon-vi rupan ri racho ri Dios xel pa ca'i'. Tixilil xpe pa ruvi' c'a chuxe' ka. ");
INSERT INTO cak_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jac'a ri uc'uay quichin soldados ri pa'el-apu chuvech ri lugar ri xbajix-vi ri Jesús, tok xutz'et chi ri Jesús riq'uin ruchuk'a' xch'o y c'ajari' (xcom, xquen), rija' xu'ij: Can kitzij vi chi ri achi re' Ruc'ajol ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","(Chuka', ka) ec'o jujun ixoki' ri yetzu'un-apu chi naj. Chiquicojol rije' c'o ri María Magdalena, c'o ri María quite' ri José y ri Jacobo ri c'a c'ajol na, y jun chic ixok rubinan Salomé. ");
INSERT INTO cak_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Rije' jumul ebenak chirij y quilin-pe ri Jesús tok c'a c'o na pa Galilea. Y ec'o-apu más chic ixoki' ri xquitzekle'ej-pe ri Jesús tok xjote-pe pa Jerusalem. ");
INSERT INTO cak_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tok ja nika-ka ri k'ij chiri', conojel ri israelitas niquitij quik'ij niquibanala' can rubanic ri nic'atzin chi niqui'en na'ey chi nitiquer-ka ri k'ij richin uxlanen. ");
INSERT INTO cak_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jari' xbano che jun achi rubinan José, aj pa tinamit Arimatea, chi xucovij ránima xbe-apu riq'uin ri Pilato richin xuc'utuj ru-cuerpo ri Jesús. Ri José re' jun chique ri achi'a' junan niqui'en gobernar, y royo'en ri k'ij tok ja ri Dios nibano gobernar pa ruvi' ronojel. ");
INSERT INTO cak_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jac'a ri Pilato man nunimaj ta chi ri Jesús caminak chic ri hora ri'. Romari' xroyoj ri uc'uay quichin ri soldados richin xuc'utuj che si kitzij chi (xcom, xquen) yan ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Tok rac'axan chic ruch'abel ri uc'uay quichin ri soldados, ri Pilato xuya' lugar che ri José chi xuc'uaj-e ru-cuerpo ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ri José xulok' jun mama tziek, xukasaj c'a ru-cuerpo ri Jesús chuvech ri cruz, xubolkotij-e chupan ri tziek, y xberuya' chupan jun jul c'oton-apu chuvech jun juyu' ruyon abaj. Jac'ari' xubolkotij-apu jun mama setesic abaj chuchi' ri jul. ");
INSERT INTO cak_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Jac'a ri María Magdalena y ri María ri quite' ri José y ri Jacobo, xquitz'et can jabel achique lugar xyo'ox-vi can ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Tok xk'ax yan ri k'ij richin uxlanen, ri María Magdalena, y ri María quite' ri José y ri Jacobo, y ri ixok rubinan Salomé xequilok' jubulaj tak ak'on richin nequiya' can chirij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sakar yan chupan ri na'ey k'ij richin ri semana, xebe chuchi' ri jul. Xa elenak chic pe juba' ri k'ij chiri' tok (xe'apon, xe'ebos). ");
INSERT INTO cak_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Jac'a tok ebenak pa bey, niquibila' chiquivech: ¿Achique xtelesan-e ri abaj ri achok che tz'apin-vi can ruchi' ri jul chikavech? yecha'. ");
INSERT INTO cak_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tok xetzu'un-apu, xquitz'et chi ri abaj, masque mama antiva, xa elesan chic e. ");
INSERT INTO cak_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Jac'a tok xe'oc-apu chupan ri jul, xquitz'et jun achel ala' tz'uyul-apu pa qui-derecha, rucusan jun sak tziek ri neka c'a chirakan ka, y xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jac'a rija' xu'ij-pe chique: Man tixi'ij-ivi'. Rix nicanoj ri Jesús aj-Nazaret, ri xcamises chuvech cruz. Rija' xc'astaj yan e, man c'o ta chic vave'. Titz'eta' ri achique lugar xquili'a-vi. ");
INSERT INTO cak_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vacami quixtzolij y ti'ij che ri Pedro y chique ri ch'aka' chic ru-discípulos, chi ri Jesús xtinabeyaj-e chivech chila' pa Galilea. Chiri' xtitz'et-vi, achel ri ru'in can chive. ");
INSERT INTO cak_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Jac'a ri ixoki' roma yebarbot y quixi'in-qui', man niquina' ta xe'enimaj-pe ri pa jul, y man jun achok che xquitzijoj-vi ri xquitz'et, roma quixi'in-qui'. ");
INSERT INTO cak_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tok ri Jesús xc'astaj yan pe chiquicojol ri anima'i' chiri', ri sakar che ri na'ey k'ij richin ri semana, na'ey xuc'ut-ri' chuvech ri María Magdalena ri achok riq'uin xerelesaj vuku' itzel tak espíritu. ");
INSERT INTO cak_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ri María re' xbe quiq'uin ri xetzekle'en ri Jesús richin xuya' rutzijol chique, pero chi bis y ok'ej xeril-vi. ");
INSERT INTO cak_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jac'a tok xquic'axaj chi xc'astaj-pe ri Jesús chiquicojol ri anima'i', y chi ri María xutz'et ruvech, xa man xquinimaj ta. ");
INSERT INTO cak_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Chirij ri', ri Jesús xuc'ut-ri' chiquivech ca'i' tzekle'ey richin tok rije' ebenak pa bey richin yebe pa juyu', pero jun yan chic vi titzu'un tok xuc'ut-ri' chiquivech. ");
INSERT INTO cak_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri ca'i' re' xquiya' rutzijol chique ri ch'aka' tzekle'ey richin ri Jesús, pero ja jun rije' man xenimex ta. ");
INSERT INTO cak_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","C'ajari' c'a ri Jesús xuc'ut-ri' chiquivech ri once ru-discípulos tok etz'uyul chuchi' mesa. Rija' xeruch'olij riq'uin ri man quiniman ta ri bin chique chi rija' xc'astaj yan, y riq'uin ri cof quibanon che ri cánima. Quiri' xu'on quiq'uin ri discípulos roma rije' man xequinimaj ta ri xetz'eto richin ri Jesús chi xc'astaj yan pe chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xu'ij chique: Quixbin c'a chi naj chi nakaj pa ruvi' ri roch'ulef y chique conojel titzijoj-vi ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj. ");
INSERT INTO cak_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri niniman ri ch'abel y nu'on bautizar ri', xticolotaj. Jac'a ri man niniman ta, xtika nimalaj castigo pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Can c'o retal xtik'alajin-pe chiquicojol ri xqueniman. Pa nubi' yin xquequelesaj itzel tak espíritu y xquech'o pa jalajoj tak ruvech ch'abel ri man quich'abel ta. ");
INSERT INTO cak_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Masque (xquequitz'om, xquequichop) cumatz y xquequikum ak'on ri nuq'uen-pe camic, man jun xtu'on chique. Xtiquiyala' quik'a' pa quivi' ri yeyavej, y ri yeyavej xquec'achoj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tok ri Ajaf Jesús xch'o yan can chique ri ru-discípulos, xc'ul chicaj, y xtz'uye-apu pa ru-derecha ri Dios. ");
INSERT INTO cak_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jac'a ri discípulos xebe chi naj chi nakaj chutzijosic ri bin can chique chi tiquitzijoj. Y ri Ajaf can c'o-vi quiq'uin richin yeruto', y can nu'on chique chi q'uiy milagros yequibanala' richin tik'alajin chi ja ri kitzij ri niquitzijoj. Amén.");
INSERT INTO cak_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Eq'uiy yan quitijon quik'ij richin niquitz'ibaj chi jujun chi jujun pa ruchojmil ri ninimex chikacojol chi kitzij chi xebanataj. ");
INSERT INTO cak_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ri xtz'ibes, can junan riq'uin ri achel xquitzijoj chike ri xe'oc samajela' richin rutzijosic ronojel ri xebanataj, ri can riq'uin quivech quitz'eton-pe xe tok xtiquer-pe. ");
INSERT INTO cak_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Romari' ja jun yin riq'uin ri nuchayun chic ronojel ruxe'el-pe ri xebanataj, can utz ninna' chi nintz'ibaj pa ruchojmil ronojel chave rat nimalaj Teófilo, ");
INSERT INTO cak_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","richin quiri' navetemaj chi can kitzij vi ronojel ri c'utun-pe chavech. ");
INSERT INTO cak_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chupan tak ri juna' tok ja ri Herodes rey chiri' pa Judea, xc'uje' jun sacerdote israelita rubinan Zacarías, y rija' jun chique ri jun botzaj sacerdotes ri erichin ri Abías ni'ix chique. Ri rixayil ri Zacarías, rubinan Elisabet. Ri Elisabet re', riy-rumam can ri nimalaj sacerdote rubinan Aarón. ");
INSERT INTO cak_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri Zacarías y ri rixayil, quic'uan jun chojmilaj c'aslen chuvech ri Dios, y manak roma ni'an tzij chirij ruc'uaxic ri quic'aslen chupan ronojel ri nu'ij ri mandamientos, y chupan ri ruchila'en can ri Ajaf chi tiquibana'. ");
INSERT INTO cak_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero ri Zacarías y ri Elisabet manak calc'ua'l, roma ri Elisabet can richin vi man alanel ta, y chi ca'i' eri'j chic. ");
INSERT INTO cak_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Tok xril semana chi ja ri botzaj sacerdotes ri c'o-vi ri Zacarías xkaj-en chi niqui'en ri samaj pa racho ri Dios, ");
INSERT INTO cak_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","y can achel vi niqui'en ri sacerdotes chi niquiya' pan etz'anen ri achok pa ruvi' xtika-vi chi ntoc-apu pa racho ri Dios richin nuporoj pon, pa ruvi' c'a ri Zacarías xka-vi. ");
INSERT INTO cak_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y man juba' ta oc israelitas ri quimolon-apu-qui' chiri' chojay niqui'en orar tok najin ruporoxic ri pon. ");
INSERT INTO cak_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jac'ari' xuc'ut-ri' jun ángel richin ri Ajaf Dios chuvech ri Zacarías. Pa derecha che ri altar ri niporox-vi ri pon, chiri' xpa'e-vi ri ángel. ");
INSERT INTO cak_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ri Zacarías jani na xuxi'ij-ri' tok xutz'et ri ángel, y man nril ta achique nu'on. ");
INSERT INTO cak_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Jac'a ri ángel xu'ij che: Zacarías, man taxi'ij-avi', ri Dios xrac'axaj ri a-oración. Ri avixayil Elisabet xtalex jun ch'uti ral, y rat Juan rubi' ri ac'ual xtaya'. ");
INSERT INTO cak_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Jani na xcaquicot y qui' avánima xtana', y eq'uiy ri xquequicot roma ralaxic ri ac'ual. ");
INSERT INTO cak_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Roma chuvech ri Dios ri avalc'ua'l re' can xtic'uje' ruk'ij. Rija' man xtukum ta vino, y nis-ta jun chic ruvech ya' ri nik'abarisan, y can nojnak chic pe ri Lok'olaj Espíritu pa ránima xtu'alex chuk'a' ri rute'. ");
INSERT INTO cak_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eq'uiy chique ri avinak israelitas xtu'on chique chi nitzolij chic pe cánima riq'uin ri Ajaf, ri can qui-Dios vi. ");
INSERT INTO cak_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja ri Juan ri avalc'ua'l ri xtinabeyaj chuvech ri Ajaf, y xtic'uje' ruchuk'a' ri Lok'olaj Espíritu riq'uin, achel xc'uje' riq'uin ri profeta Elías, richin xtu'on chique ri te'ej-tata'aj chi xquecajo' ri calc'ua'l, y richin xtu'on chique ri man yeniman ta tzij chi xtitzolij-pe cánima chupan ri bey quichin ri choj quic'aslen. Quiri' xtu'on richin nuchojmirisaj-apu cánima jun tinamit ri xticajo' xtiqui'en ri nurayij ri Ajaf, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Jac'ari' tok ri Zacarías xuc'utuj che: ¿Achel xtinvetemaj yin chi kitzij ri na'ij? Roma xa yin ri'j chic y quiri' mismo ri vixayil, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Jac'a ri ángel xu'ij che: Ja yin ri ángel Gabriel ri jumul yinc'o-apu chuvech ri Dios richin nin-en ri nrojo', y yin takon-pe aviq'uin richin nunya-ka utzulaj rutzijol chave chi xtic'uje' avalc'ua'l. ");
INSERT INTO cak_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Pero rat roma man xanimaj ta ri xin-ij chave, vacami xcacanaj can mem, y man xcatiquer ta xcach'o, c'a terila' na ri k'ij tok xtibanataj ri achel xin-ij chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Jac'a ri israelitas ri coyo'en ri Zacarías chojay, satznak cánima riq'uin ri xlayoj-ka chupan ri lok'olaj racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Pero tok xel-pe, man nitiquer ta nich'o. Jac'ari' xquina'ej chi c'o xk'alajrises-pe chuvech chupan ri lok'olaj jay. Ri Zacarías xaxe ruk'a' nu'on richin nich'o chique, y layoj tiempo xcanaj can mem. ");
INSERT INTO cak_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Tok xtz'akat ri ajani k'ij xsamaj pa racho ri Dios, xbe chiracho. ");
INSERT INTO cak_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","C'a juba' tibanataj quiri' pa racho ri Dios, ri Elisabet ri rixayil ri Zacarías jari' xuna'ej chi man ruyon ta chic, y man xel ta pa bey vo'o' ic'. Ri Elisabet quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ri Ajaf quire' favor ruyo'on chuve chupan tak re k'ij ri yiruc'uxlaj-pe richin nrelesaj nuq'uix chiquivech ri vinak ri yinquitzijoj roma manak val. ");
INSERT INTO cak_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Vaki' ic' ruchajin ri Elisabet chi quiri' chic rubanon, jari' tok ri Dios xutak ri ángel Gabriel pa jun tinamit rubinan Nazaret ri c'o pa departamento Galilea, ");
INSERT INTO cak_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","riq'uin jun xten rubinan María ri c'utun chic richin nic'ule' riq'uin jun ala' rubinan José. Ri José re' riy-rumam can ri rey David. ");
INSERT INTO cak_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Tok ri ángel xoc-apu ri achique lugar c'o-vi ri María, xu'ij che: ¡Tiquicot ri avánima rat ri más nimalaj ru-favor ri Dios avilon! Ri Ajaf can c'o aviq'uin. Y chiquicojol ri ixoki', ja rat ri más utzulaj tzij x-an chave, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Jac'a ri María tok xrac'axaj ri saludo ri xu'ij ri ángel, can achique na xuna', y xunojij-ka pa ránima chi achique roma chi quiri' jun saludo xuc'ul rija'. ");
INSERT INTO cak_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Jari' tok ri ángel xu'ij che: María, man taxi'ij-avi'. Rat avilon ri ru-favor ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Rat vacami, quiri' xta'an-pe, y xtalex jun ch'uti aval ala', y Jesús rubi' xtaya'. ");
INSERT INTO cak_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rija' xtic'uje' nimalaj ruk'ij, y xtubinaj Ruc'ajol ri nimalaj Dios ri c'o pa ruvi' ronojel. Rija' jun riy-rumam can ri rey David, y ri Ajaf Dios xtu'on che chi xtitz'uye' can chi Rey pa ru-lugar ri David. ");
INSERT INTO cak_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ri Jesús jumul xtu'on gobernar pan ivi' rix ri rix riy-rumam can ri Jacob, y ri ru-gobierno man jun bey xtiq'uis, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Jac'a ri María quire' xu'ij che ri ángel: ¿Achel tok xtic'uje' val yin tok xa man jani quic'ule' riq'uin ri xtoc vachijil? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Quire' c'a rutzolic rutzij ri María xu'on ri ángel: Ja ri Lok'olaj Espíritu xtika pan avi', y xcarumujaj ri ruchuk'a' ri nimalaj Dios ri c'o pa ruvi' ronojel. Roma c'a ri', rat xtic'uje' ac'ual chi'ak'a' ri xtubinaj Lok'olaj y Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tavac'axaj c'a, chi ja jun ri Elisabet ri (avalpachel, avaj-c'uaxel) xtic'uje' ac'ual chuk'a', roma ja yan chic vaki' ic' quiri' rubanon, masque rija' ri'j chic y ni'ix chi man alanel ta. ");
INSERT INTO cak_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Roma ri Dios man jun c'ayef chuvech. ");
INSERT INTO cak_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Jac'ari' tok ri María xu'ij: Yin, yin jun rusamajinel ri Ajaf. Tibanataj c'a ri achel xa'ij chuve, xcha' ri María che ri ángel. Jac'ari' xel-e ri ángel chuvech ri María. ");
INSERT INTO cak_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Chupan tak ri k'ij ri', ri María xu'on-e rubanic y cha'anin xbe pa jun tinamit ri c'o pa tak (c'achelaj, montaña) richin ri departamento Judea. ");
INSERT INTO cak_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tok c'o chic chiri' pa tinamit, rija' xbe chicacho ri Zacarías y ri Elisabet, y chiri' pa jay xu'on saludar ri Elisabet. ");
INSERT INTO cak_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tok ri Elisabet xrac'axaj ri xu'ij ri María, ri ch'uti ac'ual ri royo'en, xsilon xuna' rija'. Y ri Elisabet xnoj ri Lok'olaj Espíritu pa ránima, ");
INSERT INTO cak_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","romari' riq'uin ruchuk'a' xu'ij: Chikacojol roj ixoki', ja rat ri más utzulaj tzij x-an chave, y utzulaj tzij ruc'ulun-pe ri ac'ual ri xtalex chi'ak'a'. ");
INSERT INTO cak_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Achel chi ri rute' ri Vajaf yinurutz'eta'? ¡Yin can nisatz nuc'u'x! ");
INSERT INTO cak_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Quiri' nin-ij chave, roma xe xinvac'axaj ri ach'abel richin xina'an saludar, ja xsilon ri ac'ual ri xtalex chinuk'a' roma niquicot. ");
INSERT INTO cak_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Y rat, utzulaj tzij banon chave chi xanimaj, roma can xtibanataj na vi ri bin chave roma ri Ajaf, xcha' ri Elisabet. ");
INSERT INTO cak_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Jac'ari' quire' xu'ij ri María: Yin riq'uin ronojel vánima ninya' ruk'ij ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri vánima niquicot nuc'ak-ri' roma ri Dios ri Nucolonel. ");
INSERT INTO cak_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Roma xuya' ruvech chuvij yin ri rusamajinel chi xa man jun oc nuk'ij. Pero ja vacami nitiquer-e chi ronojel solaj vinak xtiqui'ij chi can utzulaj tzij rubanon ri Dios chuve. ");
INSERT INTO cak_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Roma ri Dios ri c'o ronojel uchuk'a' pa ruk'a', q'uiy favores rubanon chuve. Lok'olaj rubi' rija', ");
INSERT INTO cak_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Y ri c'o ruk'ij rija' chiquivech, ri chi solaj chi solaj yek'ax-e choch'ulef, rija' can nupokonaj quivech. ");
INSERT INTO cak_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Riq'uin ruchuk'a' rubanon q'uiy samaj. Ri xquinojij chi can c'o quik'ij, xukasaj quik'ij. ");
INSERT INTO cak_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ri nima'k tak gobernadores, xerelesaj pa tak quitz'uyubal, Y xu'on chi xc'uje' quik'ij ri man jun oc quik'ij. ");
INSERT INTO cak_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri niquik'asaj vayijal, xuya' ronojel ri nic'atzin chique. Jac'a ri beyoma', choj quiri' xerutak-e, man jun xuya-e chique. ");
INSERT INTO cak_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xojruto' roj israelitas ri roj rusamajela' Roma man rumestan ta chi rupokonan kavech, ");
INSERT INTO cak_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Quiri' rubanon kiq'uin, achel ri xusuj chique ri kati't-kamama' ojer. Achel ru'in can che ri kamama' Abraham y chike roj ri roj riy-rumam can. Quiri' xu'ij ri María. ");
INSERT INTO cak_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y xc'uje' cami oxi' ic' ri María riq'uin ri Elisabet, c'ajari' xtzolij chiracho. ");
INSERT INTO cak_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tok xril k'ij chi ri Elisabet nalex ri ch'uti ral, ch'uti ala' ri xalex. ");
INSERT INTO cak_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tok ri ru-vecinos y ri (ralpachel, raj-c'uaxel) xquic'axaj chi ri Ajaf jani na xupokonaj ruvech ri Elisabet, xequicot riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jac'a tok xtz'akat vakxaki' ruk'ij ri ch'uti ala', rije' xepe roma ni'an circuncidar ri ac'ual, achel nu'ij chupan ri ley ri xyo'ox che ri Moisés. Can ja rubi' ri rutata' niquibila' che, romari' Zacarías yecha' che ri ch'uti ala'. ");
INSERT INTO cak_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Jac'a ri rute' ri ch'uti ac'ual quire' rutzolic quitzij xu'on: Ri ac'ual man xtubinaj ta achel rubi' ri rutata'; Juan xtubinaj ri ac'ual. ");
INSERT INTO cak_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jac'ari' xqui'ij che ri Elisabet: ¿Achique roma najo' chi Juan nubinaj ri aval, tok man jun (ivalpachel, ivaj-c'uaxel) quiri' rubi'? yecha'. ");
INSERT INTO cak_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Jac'ari' tok xqui'en-apu quik'a' che ri Zacarías ri rutata' ri ac'ual, richin niquic'utuj achique rubi' nrojo' nuya' ri ac'ual. ");
INSERT INTO cak_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Y ri Zacarías xuc'utuj jun pedazo tabla, y quire' xutz'ibaj chuvech: Ri ac'ual Juan xtubinaj. Jari' xbano chique conojel chi can achique na xquina'. ");
INSERT INTO cak_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Jac'ari' tok xtiquer chic xch'o ri Zacarías. Xsok'opitaj chic ri rak', y riq'uin ruch'abel nuyala' ruk'ij ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jac'a ri qui-vecinos chiconojel xquixi'ij-qui', y pa ronojel tak tinamit ri pa tak (c'achelaj, montaña) richin ri Judea xbe-vi rutzijol ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y conojel ri xe'ac'axan niquiyec-ka pa tak cánima ri nitzijos chique, y niqui'ij: ¿Achique cami samaj ruc'amon-pe ri ch'uti ac'ual re'? yecha'. Roma nik'alajin chi ruchuk'a' ri Ajaf c'o riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jac'ari' tok ri Zacarías, ri rutata' ri ch'uti ac'ual, xnoj ri Lok'olaj Espíritu pa ránima, romari' quire' xuk'alajrisaj: ");
INSERT INTO cak_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Tiyo'ox c'a ruk'ij ri Ajaf Dios kichin roj israelitas, Roma roj ruc'uxlan-pe ri roj rutinamit, y roj rulok'on pa quik'a' ri ec'o pa kavi'. ");
INSERT INTO cak_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ruyacon-pe jun Kacolonel ri c'o nimalaj ruchuk'a', Jun riy-rumam can ri David ri rusamajinel ri Dios ojer. ");
INSERT INTO cak_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Re' ruyuken-ri' riq'uin ri quik'alajrisan-pe ri chojmilaj tak profetas ojer, tok ri Dios xuya' ch'abel chique richin xel pa quichi', ");
INSERT INTO cak_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Chi can nkurucol chiquivech ri itzel nkojquitz'et, y nkurucol pa quik'a' ri man nkojcajo' ta, ");
INSERT INTO cak_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Richin nibanataj ri xusuj chique ri kati't-kamama' ojer chi nupokonaj quivech, Y richin nik'alajin chi man rumestan ta ri lok'olaj ruvujil c'aslen ri xu'on ojer can. ");
INSERT INTO cak_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Can xuya-vi rutzij che ri kamama' Abraham, Chi can xtuya-vi chike roj ri roj riy-rumam can ri Abraham, ");
INSERT INTO cak_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Chi tok ri Ajaf Dios roj rucolon chic chiquivech ri itzel nkojquitz'et chiri', Manak xtikaxi'ij ta ki' nika'an ri nrojo' rija' ");
INSERT INTO cak_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Riq'uin jun chojmilaj y ch'ajch'oj c'aslen chuvech, ri ajani k'ij nkuc'ase-e choch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Jac'a rat ch'uti nuc'ajol, xcha' ri Zacarías, xti'ix chave chi rat jun ru-profeta ri nimalaj Dios ri c'o pa ruvi' ronojel, Roma ja rat ri xcanabeyaj chuvech ri Ajaf richin nachojmirisaj ri rubey, ");
INSERT INTO cak_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Y ja rat xcayo'on rutzijol chique ri rutinamit, Chi ri Dios nu'on perdonar quimac richin yecolotaj. ");
INSERT INTO cak_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Quiri' nu'on ri ka-Dios kiq'uin roma can nkurojo' y nupokonaj kavech. Romari', c'a chicaj nutak-vi-pe ri Jun ri niyo'on sakil pa kánima. Ri Jun ri' achel ri k'ij tok ntel-pe, ");
INSERT INTO cak_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Richin nuyic'aj cánima ri ec'o pa k'eku'n, y ri ec'o chuxe' rumujal ri camic, Y nkuruc'uaj chupan ri bey ri nic'amo-pe uxlanen pa kánima. Quiri' xu'ij ri Zacarías. ");
INSERT INTO cak_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y ri ac'ual niq'uiy, y quiri' mismo ri ruc'aslen benak pa jotol chuvech ri Dios, y pa tak chakijlaj tz'iran ulef xc'uje-vi, c'a xerila' na ri k'ij richin xuc'ut-ri' chiquivech ri ruvinak israelitas richin xutz'uc samaj chiquicojol. ");
INSERT INTO cak_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chupan tak ri k'ij ri', ri rey Augusto César xutak rubixic chique conojel vinak chi nic'atzin niquitz'ibaj quibi'. ");
INSERT INTO cak_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ri na'ey tz'iban (bi'aj, binaj) re', x-an pa ru-tiempo ri Cirenio ri gobernador pa roch'ulef Siria. ");
INSERT INTO cak_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Conojel ri man ec'o ta pa tak quitinamit, xc'atzin chi xequitz'ibaj quibi' pa tak quitinamit. ");
INSERT INTO cak_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","C'o c'a jun achi rubinan José xel-pe pa tinamit Nazaret ri c'o pa ru-cuenta ri Galilea y xbe pa Belén, ri rutinamit can ri rey David chiri' pa departamento Judea. Quiri' xu'on ri José roma rija' riy-rumam can ri David, ");
INSERT INTO cak_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","y xc'atzin chi chiri' xequitz'ibaj-vi quibi' junan riq'uin ri María ri jachon chic che richin nic'ule' riq'uin. Jac'a ri María xa juba' chic nrojo' chi nic'achoj riq'uin ac'ual. ");
INSERT INTO cak_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Chiri' pa Belén ec'o-vi rije' tok xtz'akat k'ij chi ri María xalex ral. ");
INSERT INTO cak_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ch'uti ala' ri na'ey ral ri María, y xubolkotij pa tziek, y xucotz'oba' pa jun quivayibal quiej-váquix, roma manak chic qui-lugar xquil pa posada. ");
INSERT INTO cak_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chunakaj apu ri Belén ec'o yuk'unel yec'uje' pa tak juyu' ri niquijalala-qui' richin yequivaraj ri botzaj tak cavaj. ");
INSERT INTO cak_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","C'ate xquitz'et, c'o jun ángel richin ri Ajaf xuc'ut-ri' chiquivech. Y ri rusakil ri Ajaf xerusakarisaj y jani na xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Jac'a ri ángel xu'ij chique: Man tixi'ij-ivi'. Roma yin jun utzulaj rutzijol nuc'amon-pe chive richin chi yixquicot chi nimalaj ivonojel. ");
INSERT INTO cak_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Roma vacami pa Belén ri rutinamit ri rey David, xalex jun Colonel ivichin rix, ri takon-pe chucolic rutinamit ri Dios, y can Ajaf vi. ");
INSERT INTO cak_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal chi ja ri ch'uti ac'ual xivil, k'alaj bolkotin pa tziek y cotz'oban pa jun quivayibal quiej-váquix, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","C'ate c'a xquitz'et, riq'uin ri ángel xe'epapo' chi miles ángeles ri epetenak chicaj, ri niquiya' ruk'ij ri Dios, y niqui'ij: ");
INSERT INTO cak_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Nimalaj ruk'ij nuc'ul ri Dios chicaj! ¡Y ri vave' choch'ulef uxlanen niquic'ul pa cánima ri yec'ulu ri ru-favor! ");
INSERT INTO cak_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Tok ri ángeles xetzolij-e chicaj, ri yuk'unel jari' xquibila-ka chiquivech: Vacami, jo' c'a pa Belén chutz'etic ri achique xbanataj, ri xutak-pe rutzijol ri Ajaf chike. ");
INSERT INTO cak_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Xebe c'a cha'anin chutz'etic, y can xequil-vi ri María, ri José y ri ac'ual cotz'oban pa jun quivayibal quiej-váquix. ");
INSERT INTO cak_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Tok xquitz'et ri ac'ual, xquitzijoj-apu ri xbix chique roma ri ángel chirij ri ch'uti ac'ual re', ");
INSERT INTO cak_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","y conojel ri ye'ac'axan, can achique na xquina', roma ri niquitzijoj ri yuk'unel. ");
INSERT INTO cak_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Jac'a ri María yeruyec-ka pa ránima ronojel ri niqui'ij ri yuk'unel, y can q'uiy nunojij chirij. ");
INSERT INTO cak_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ri yuk'unel niquiyala' ruk'ij y niquinimirisaj rubi' ri Dios xetzolij-e, roma ronojel ri xquic'axaj y xquitz'et, ja achel ru'in can ri ángel chique. ");
INSERT INTO cak_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Tok xtz'akat vakxaki' k'ij richin chi ri ac'ual ni'an circuncidar, ja k'ij ri' xquiya' rubi', y JESUS rubi' xquiya', roma quiri' ru'in can ri ángel chi tubinaj ri ac'ual tok ri María man jani retal chi nic'uje' ac'ual chuk'a'. ");
INSERT INTO cak_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Tok xtz'akat k'ij chi niquich'ajch'ojrisaj-qui' achel nu'ij ri ley ri xyo'ox che ri Moisés, ri José y ri María xquic'uaj ri Jesús pa tinamit Jerusalem, richin xquijach ri ruc'aslen pa ruk'a' ri Ajaf Dios. ");
INSERT INTO cak_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quiri' xqui'en roma ri ley richin ri Ajaf nu'ij: Ri na'ey ral ri te'ej nalex, si ch'uti ala', ri ruc'aslen ri ac'ual ri' can richin vi ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Y richin niquich'ajch'ojrisaj-qui', xqui'en achel nu'ij ri ley chi quequisuju' ca'i' ixcura' o ca'i' ch'utik palomas chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chiri' pa tinamit Jerusalem ri tiempo ri', c'o jun achi rubinan Simeón. Ri achi re' choj ruc'aslen y can nuya' ruk'ij ri Dios, c'o ri Lok'olaj Espíritu riq'uin y can royo'en chi xtipe ri Jun ri xtucolo quichin ri israelitas. ");
INSERT INTO cak_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ri Lok'olaj Espíritu ruk'alajrisan che ri Simeón chi man xtutz'et ta ruvech ri camic c'a ja tok rutz'eton chic can ri Jun ri xtutak-pe ri Ajaf chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Chupan ri k'ij tok ri te'ej-tata'aj xquic'uaj ri ac'ual pa racho ri Dios richin niqui'en ri achel nu'ij ri ley, ja k'ij ri' tok ri Lok'olaj Espíritu xu'on che ri Simeón chi xbe pa racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xuch'elej ri ac'ual, y quire' xu'ij richin xuya' ruk'ij ri Dios: ");
INSERT INTO cak_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, vacami utz chic richin yinac'ol-e choch'ulef; c'o chic uxlanen pa vánima yi'e, Roma xbanataj ri achel xa'ij chuve. ");
INSERT INTO cak_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Roma riq'uin nuvech xintz'et can ri Colonel ri petenak aviq'uin. ");
INSERT INTO cak_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Rat xaya-pe quichin conojel quivech vinak. ");
INSERT INTO cak_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja rija' niyo'on Sakil pa cánima ri man israelitas ta, Y roma rija' xtic'uje' kak'ij roj ri atinamit Israel, xcha' ri Simeón. ");
INSERT INTO cak_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri José y ri rute' ri Jesús, can achique na xquina' xquic'axaj ri nu'ij ri Simeón pa ruvi' ri ac'ual. ");
INSERT INTO cak_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ri Simeón xuc'utuj ru-favor ri Dios pa quivi', y quire' xu'ij che ri María: Tatz'eta' na pe', ri ac'ual re' yo'on-pe richin chi eq'uiy israelitas xquecolotaj, pero eq'uiy ri xquetzak, y yo'on-pe richin jun retal chiquivech ri vinak roma ri Dios, pero ec'o ri xa xtiquipaba-qui' chuvech ri xtu'ij. ");
INSERT INTO cak_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Roma rija' xtek'alajin-pe ri achique c'o pa tak cánima ri vinak, y roma ri itzel ri xti'an che ri Jesús, rat achel jun espada xtuk'asaj rupan ri avánima xtana', xcha' ri Simeón. ");
INSERT INTO cak_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","(Chuka', ka) chiri' c'o jun ixok ri'j chic rubinan Ana, riy-rumam can jun chique ri doce tata'aj quichin ri israelitas rubinan Aser, y rumi'al can jun achi rubinan Fanuel. Ri Ana re' jun profeta, y xaxe vuku' juna' xquic'uaj-qui' riq'uin ri rachijil, ");
INSERT INTO cak_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","roma xa cha'anin xmalcanij can, y man xc'ule' ta chic jun bey. Rija' ochenta y cuatro chic rujuna', k'ij-k'ij ni'e-apu pa racho ri Dios, chi chak'a' chi pak'ij nuya' ruk'ij ri Dios riq'uin coch'on vayijal y oración. ");
INSERT INTO cak_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ri Ana jari' xjel-apu chiri', xutz'et ri najin y xuya' matiox che ri Dios. Y can nutzijoj ri ac'ual Jesús chique conojel ri aj-Jerusalem ri coyo'en quicolic pa quik'a' ri ec'o pa quivi'. ");
INSERT INTO cak_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Tok xqui'en yan can ronojel ri nu'ij chupan ri ley ri xuya' ri Ajaf, ri José y ri María xetzolij pa cacho ri c'o pa Nazaret, jun tinamit ri c'o pa ru-cuenta ri Galilea. ");
INSERT INTO cak_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jac'a ri ac'ual niq'uiy, nic'uje-pe ruchuk'a', niq'uiyer ri no'oj c'o riq'uin y c'o ru-favor ri Dios pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri rute-rutata' ri Jesús, juna-juna' yebe pa tinamit Jerusalem, tok nuka ruk'ijul ri nimak'ij pascua. ");
INSERT INTO cak_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Tok doce chic rujuna' ri Jesús, xejote-e pa Jerusalem roma ri nimak'ij pascua, achel quibanon-pe juna-juna'. ");
INSERT INTO cak_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tok xek'ax ruk'ijul ri nimak'ij, ja etzolijnak chicacho chiri', man xquina'ej ta chi ri Jesús xa xc'uje' can pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Rije' xquinojij chi ri ac'ual benak chiquicojol ri junan epetenak quiq'uin, y quiri' xebin jun k'ij. Xa c'a ja tok xquic'utula' chique ri (calpachel, caj-c'uaxel) y chique ri queteman quivech, c'ajari' xquina'ej chi xa man petenak ta quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Y roma man xquil ta, ri José y ri María niquicanola' ri ac'ual xetzolij chic jun bey c'a pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Oxi' k'ij tisatz can ri ac'ual chiri', c'ajari' xquil pa racho ri Dios, tz'uyul-apu chiquicojol ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, nrac'axaj ri niqui'ij y c'o nuc'utula-apu chique. ");
INSERT INTO cak_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Conojel ri ye'ac'axan ri nu'ij ri ac'ual can achique na niquina', roma ronojel ri nic'utux-apu che, ronojel pa ruchojmil nutzolij-pe rubixic chique ri achi'a' ri'; can k'alaj chi jabel (nik'ax, nino') chuvech ri ni'ix. ");
INSERT INTO cak_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Tok ri José y ri María xquitz'et ri ac'ual, achique na xquina'. Y ri rute' xu'ij che ri Jesús: ¡Val! ¿Achique roma quire' xa'an chike? Tatz'eta' la atata' y yin, rat kacanon pa ronojel lugar. Avoma nik'axo ri kánima roma man jun yatkil, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jari' tok rija' xu'ij chique: ¿Achique roma yinicanoj? ¿Man iveteman ta c'a chi ja ri nrojo' ri Nata' Dios, jari' ri nic'atzin chi nin-en? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jac'a ri xu'ij ri Jesús chique ri José y ri María man (xk'ax, xno') ta chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","C'ajari' xtzolij-pe chiquij ri rute-rutata' richin xepe chicacho ri pa tinamit Nazaret, y can nunimaj quitzij. Ronojel ri xbanataj pa Jerusalem riq'uin ri ac'ual, ri María yeruyec pa ránima. ");
INSERT INTO cak_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jac'a ri Jesús can niq'uiy ri no'oj c'o riq'uin, niq'uiy rupalen, y can utz nitz'etetaj roma ri Dios y coma ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","C'o yan quince juna' toc rey ri jun achi Tiberio César rubi', y chiquicojol ri gobernadores ri ec'o pa ruk'a', c'o ri Poncio Pilato ri nu'on gobernar pa departamento Judea. Jun chic, ja ri Herodes ri nu'on gobernar pa departamento Galilea. Jun chic, ja ri Felipe ri runimal ri Herodes ri nu'on gobernar pa quivi' ri lugares quibinan Iturea y Traconite. Jun chic, ja ri Lisanias ri nu'on gobernar pa ruvi' ri lugar rubinan Abilinia. ");
INSERT INTO cak_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ri tiempo ri', ja ri Anás y ri Caifás ri enimalaj tak sacerdotes chiri' pan Israel, y ja tiempo ri' xch'o ri Dios che ri Juan ri ruc'ajol ri Zacarías pa chakijlaj tz'iran ulef. ");
INSERT INTO cak_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ri Juan ronojel tinamit ri ec'o chunakaj ri rakan-ya' Jordán xk'ax-vi. Rija' nutzijoj chique ri vinak chi tiquijala' quino'oj, tiquiya' can ri mac y tiquibana' bautizar qui' richin chi ri Dios nu'on perdonar ri quimac. ");
INSERT INTO cak_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ri nutzijoj ri Juan, ja achel ri rutz'iban can ri profeta Isaías ojer, ri quire' nu'ij: Pa chakijlaj tz'iran ulef c'o jun ri xtich'o riq'uin ruchuk'a' y xtubila': Tibana-apu rubanic ri bey ri xtik'ax-vi ri Ajaf, Utz-utz tichojmij-apu. ");
INSERT INTO cak_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ronojel sivan nic'atzin chi yenojses; Chi ch'uti'k chi nima'k tak juyu' quekases. Ri cotocak tak bey, choj ti'an chique, Y ri cujcak tak bey, li'an ti'an chique. ");
INSERT INTO cak_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conojel vinak xtiquitz'et ri achique nu'on ri Dios richin nicolon. Quiri' ri rutz'iban can ri Isaías. ");
INSERT INTO cak_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y ri Juan quire' nu'ij chique ri nequimolo-qui' riq'uin richin ye'an-e bautizar: Rix xa rix achel itzel tak cumatz. ¿Achique xyo'on rutzijol chive chi quixenimaj chuvech ri castigo ri xtutak-pe ri Dios más chikavech apu? ");
INSERT INTO cak_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rix nic'atzin nik'alajin iviq'uin chi kitzij ijalon ino'oj y iyo'on can ri mac. Y man iyon titz'uc-ka runojixic pan ivánima chi roma rix riy-rumam can ri Abraham, romari' xquixcolotaj. Roma yin nin-ij chi xa ta ri Dios nrojo', rija' yeru'on riy-rumam ri Abraham chique ri abaj ri ye'itz'et vave'. ");
INSERT INTO cak_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jac'a rix xa rix achel ri che' ri yo'on chic apu icaj chirij ri quixe'; xa achique na che' xe xa man nuya' ta utzulaj ruvech, nichoy-e y nic'ak pa k'ak', xcha' ri Juan. ");
INSERT INTO cak_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jac'ari' tok ri quimolon-apu-qui' xquic'utuj che: Si quiri', ¿achique nic'atzin chi nika'an? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y ri Juan xu'ij chique: Ri c'o ca'i' rutziak, tuya' jun che ri manak rutziak. Y ri c'o pan riq'uin, tuya' che ri manak oc nutij, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Quiri' mismo ec'o jujun c'uluy tak impuestos xe'eka riq'uin ri Juan richin ye'an-e bautizar, ri quire' xquic'utuj che: Tijonel, y roj, ¿achique nic'atzin chi nika'an? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ri Juan xu'ij chique: Rix man tic'utuj ruvi' ri impuestos, xaxe ri bin chive, xe ri' tic'utuj, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","(Chuka', ka) ec'o soldados ri quire' xquic'utuj-apu che ri Juan: Y roj, ¿achique nic'atzin chi nika'an? xecha'. Rija' xu'ij chique: Man roma ta chi rix soldados ye'imajla' qui-cosas ri vinak, ni man jun achique tik'ebaj chiquij, y ticuker ic'u'x riq'uin ri ajani nich'ec, xcha' ri Juan. ");
INSERT INTO cak_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Ri israelitas coyo'en chi nik'alajin chiquivech achique chi achi ri Juan, y niquibila' pa tak cánima chi riq'uin juba', ja rija' ri Jun ri takon-pe chucolic rutinamit ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jac'a ri Juan quire' xu'ij chique conojel ri ec'o-apu chiri': Can kitzij na vi chi yin pa ya' yixin-en-vi bautizar. Pero c'o Jun xtipe ri más c'o ruk'ij y más c'o uchuk'a' pa ruk'a' que chinuvech yin. Rija' riq'uin ri Lok'olaj Espíritu y riq'uin k'ak' xquixru'on bautizar. Y nis-ta chusolic ximibel ruxajab, man nuc'ul ta chi ja yin yibano. ");
INSERT INTO cak_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Rija' rubanon chic rubanic richin yerelesaj-e ri yeniman ri Dios chiquicojol ri man yeniman ta, achel tok jun achi ruc'uan chic jun che' pa ruk'a' richin nuc'ak pa cak'ik' ri ru-trigo ch'eyon chic. Rija' xtuyec ri trigo, jac'a ri (ruxeq'uelal, rupuxq'uil) xtuporoj chupan ri k'ak' ri man jun bey xtichup, xcha' ri Juan. ");
INSERT INTO cak_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Riq'uin ch'abel achel re' y riq'uin q'uiy chic más ri xubila', ri Juan xutzijoj ri utzulaj ruch'abel ri Jesucristo chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","C'o c'a jun k'ij ri Herodes ri nibano gobernar ri rucaj parte richin ri roch'ulef ri c'o-vi, xch'olix roma ri Juan, roma ri Herodes rubanon-ka rixayil che ri Herodías rixayil ri Felipe ri mismo runimal ri Herodes, y (chuka', ka) roma ch'aka' chic itzel tak no'oj ri rubanalo'n. ");
INSERT INTO cak_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y pa ruvi' ri' ri Herodes xutz'apij ri Juan pa cárcel. ");
INSERT INTO cak_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Tok ri Juan yeru'on bautizar ri vinak, ja jun ri Jesús x-an bautizar, y tok ri Jesús najin riq'uin oración chiri', xjakataj ri rocaj. ");
INSERT INTO cak_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y ri Lok'olaj Espíritu can k'alaj achel ru-cuerpo jun paloma ri xka-pe pa ruvi'. Y xc'axataj jun kulaj petenak c'a chicaj ri quire' xu'ij: Ja rat ri Nuc'ajol; yin can yatinjo' y niquicot vánima aviq'uin, xcha' ri ch'abel ri'. ");
INSERT INTO cak_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jun cami treinta rujuna' ri Jesús chiri' tok (xutz'om, xuchop) ri samaj ri yo'on-pe che roma ri Dios. Chiquivech ri vinak, ri Jesús xa ruc'ajol ri José. Y ri José ruc'ajol can ri Elí. ");
INSERT INTO cak_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ri Elí re', ruc'ajol can ri Matat, y ri Matat ruc'ajol can ri Leví, y ri Leví ruc'ajol can ri Melqui, y ri Melqui ruc'ajol can ri Jana, y ri Jana ruc'ajol can jun chic achi xubinaj José. ");
INSERT INTO cak_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ri José re', ruc'ajol can ri Matatías, y ri Matatías ruc'ajol can ri Amós, y ri Amós ruc'ajol can ri Nahum, y ri Nahum ruc'ajol can ri Esli, y ri Esli ruc'ajol can ri Nagai. ");
INSERT INTO cak_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ri Nagai re', ruc'ajol can ri Maat, y ri Maat ruc'ajol can jun chic achi xubinaj Matatías, y ri Matatías re', ruc'ajol can ri Semei, y ri Semei ruc'ajol can jun chic achi xubinaj José, y ri José re', ruc'ajol can ri Judá. ");
INSERT INTO cak_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ri Judá re', ruc'ajol can ri Joana, y ri Joana ruc'ajol can ri Resa, y ri Resa ruc'ajol can ri Zorobabel, y ri Zorobabel ruc'ajol can ri Salatiel, y ri Salatiel ruc'ajol can ri Neri. ");
INSERT INTO cak_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ri Neri re', ruc'ajol can jun chic achi xubinaj Melqui, y ri Melqui ruc'ajol can ri Adi, y ri Adi ruc'ajol can ri Cosam, y ri Cosam ruc'ajol can ri Elmodam, y ri Elmodam ruc'ajol can ri Er. ");
INSERT INTO cak_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ri Er re', ruc'ajol can ri Josué, y ri Josué ruc'ajol can ri Eliezer, y ri Eliezer ruc'ajol can ri Jorim, y ri Jorim ruc'ajol can jun chic achi xubinaj Matat. ");
INSERT INTO cak_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ri Matat re', ruc'ajol can jun chic achi xubinaj Leví, y ri Leví ruc'ajol can ri Simeón, y ri Simeón ruc'ajol can jun chic achi xubinaj Judá, y ri Judá ruc'ajol can jun chic achi xubinaj José, y ri José ruc'ajol can ri Jonán, y ri Jonán ruc'ajol can ri Eliaquim. ");
INSERT INTO cak_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ri Eliaquim re', ruc'ajol can ri Melea, y ri Melea ruc'ajol can ri Mainán, y ri Mainán ruc'ajol can ri Matata, y ri Matata ruc'ajol can ri Natán. ");
INSERT INTO cak_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ri Natán re', ruc'ajol can ri David, y ri David ruc'ajol can ri Isaí, y ri Isaí ruc'ajol can ri Obed, y ri Obed ruc'ajol can ri Booz, y ri Booz ruc'ajol can ri Salmón, y ri Salmón ruc'ajol can ri Naasón. ");
INSERT INTO cak_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ri Naasón re', ruc'ajol can ri Aminadab, y ri Aminadab ruc'ajol can ri Aram, y ri Aram ruc'ajol can ri Esrom, y ri Esrom ruc'ajol can ri Fares, y ri Fares ruc'ajol can jun chic achi xubinaj Judá. ");
INSERT INTO cak_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ri Judá re', ruc'ajol can ri Jacob, y ri Jacob ruc'ajol can ri Isaac, y ri Isaac ruc'ajol can ri Abraham, y ri Abraham ruc'ajol can ri Taré, y ri Taré ruc'ajol can ri Nacor. ");
INSERT INTO cak_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ri Nacor re', ruc'ajol can ri Serug, y ri Serug ruc'ajol can ri Ragau, y ri Ragau ruc'ajol can ri Peleg, y ri Peleg ruc'ajol can ri Heber, y ri Heber ruc'ajol can ri Sala. ");
INSERT INTO cak_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ri Sala re', ruc'ajol can ri Cainán, y ri Cainán ruc'ajol can ri Arfaxad, y ri Arfaxad ruc'ajol can ri Sem, y ri Sem ruc'ajol can ri Noé, y ri Noé ruc'ajol can ri Lamec. ");
INSERT INTO cak_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ri Lamec re', ruc'ajol can ri Matusalén, y ri Matusalén ruc'ajol can ri Enoc, y ri Enoc ruc'ajol can ri Jared, y ri Jared ruc'ajol can ri Mahalaleel, y ri Mahalaleel ruc'ajol can jun chic achi xubinaj Cainán. ");
INSERT INTO cak_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ri Cainán re', ruc'ajol can ri Enós, y ri Enós ruc'ajol can jun achi xubinaj Set, y ri Set ruc'ajol can ri Adán, y ri Adán ralc'ua'l ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Tok ri Jesús banon chic bautizar, rija' nojnak ri Lok'olaj Espíritu pa ránima xuya' can ri rakan-ya' Jordán, y xuc'uax roma ri Espíritu pa chakijlaj tz'iran ulef. ");
INSERT INTO cak_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chiri' xc'uje-vi cuarenta k'ij, y chupan tak ri k'ij ri', man jun achique xutij. Y tok xek'ax ri k'ij ri', xpe ruvayijal, jac'a ri itzel nutij ruk'ij chirij richin nrojo' nutakchi'ij pa mac. ");
INSERT INTO cak_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Romari' quire' xu'ij che ri Jesús: Si kitzij chi rat Ruc'ajol ri Dios, ta'ij che ri abaj re' chi toc pan. ");
INSERT INTO cak_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jac'a ri Jesús xu'ij che: Chupan ri tz'iban can quire' nu'ij: Ri vinak man xe ta pan nic'atzin che ri quic'aslen, ja jun ronojel ruch'abel ri Dios, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jac'ari' tok ri itzel xuc'uaj ri Jesús chuvech jun juyu' naj jotol chicaj, y pa jun ch'uti rato xuc'ut ronojel ri nimalaj tak cuchuk'a' ri aj-roch'ulef tak gobierno chuvech. ");
INSERT INTO cak_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y xu'ij c'a che: Yin ninjach pan ak'a' ri nimalaj tak uchuk'a' re', y ri nimalaj tak quibeyomal richin na'an gobernar pa quivi', roma pa nuk'a' yin jachon-vi, y c'o nuk'a' chi ninya' che xa achok che na ri ninjo' ninya-vi. ");
INSERT INTO cak_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Roma c'a ri', si rat yaxuque' chinuvech richin naya' nuk'ij, ronojel re' xtoc avichin, xcha' ri itzel. ");
INSERT INTO cak_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jac'a ri Jesús richin xutzolij rutzij, quire' xu'ij: Catel-e viq'uin rat Satanás, roma chupan ri tz'iban can quire' nu'ij: Ja chuvech ri Avajaf Dios caxuque-vi, y xaxe rija' taya' ruk'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jac'ari' tok ri itzel xuc'uaj ri Jesús pa tinamit Jerusalem, xujotoba-e hasta ri más naj e pa ruvi' ri racho ri Dios, y xu'ij che: Si kitzij chi rat Ruc'ajol ri Dios, tatorij-ka-avi' vave', ");
INSERT INTO cak_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","roma chupan ri tz'iban can quire' nu'ij: Ri Dios xtu'ij chique ri ru-ángeles chi xcatquichajij; ");
INSERT INTO cak_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","y, Xcatquili'ej pa quik'a', Richin man (xtapak'ij, xtacopij) ta avakan chuvech abaj, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jac'a ri Jesús richin xutzolij rutzij ri itzel, quire' xu'ij: Bin can roma ri Dios: Man tatij ak'ij chirij ri Avajaf Dios richin nu'on ri nanojij rat, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y tok ri itzel man xril ta chic achique nu'on richin nrojo' nutakchi'ij pa mac, xuya' can jun ca'i-oxi' k'ij. ");
INSERT INTO cak_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nojnak ruchuk'a' ri Lok'olaj Espíritu pa ránima, ri Jesús xtzolij pa departamento Galilea, y xbe rutzijol pa ronojel tak tinamit ri ec'o-pe nakaj. ");
INSERT INTO cak_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y pa tak qui-sinagogas yerutijoj-vi ri niquimol-qui' chiri', y ri ye'ac'axan, can niquiya' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xbe chic pa Nazaret, ri tinamit ri xq'uiy-vi, y can achel rubanon-pe, xoc-apu pa sinagoga chupan ri sábado ri k'ij richin uxlanen, y xpa'e' c'a richin nu'on leer ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Xyo'ox c'a apu che ri boton vuj ri tz'iban-vi ri ruk'alajrisan can ri profeta Isaías, y tok xuric'-ka, quire' ri ch'abel xril-ka: ");
INSERT INTO cak_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Lok'olaj Espíritu richin ri Ajaf, c'o pa nuvi' yin, Roma yin rucha'on richin nintzijoj chique ri man jun oc quichajin, ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj. Xirutak-pe richin nin-en chique ri nik'axo cánima chi yec'achoj. Xirutak-pe richin nin-ij chique ri etz'apel chi vacami yecolotaj Y richin nin-ij chique ri man yetzu'un ta, chi xquetzu'un chic. Xirutak-pe richin yencol ri ec'o chuxe' ralal quitzij ch'aka' chic. ");
INSERT INTO cak_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xirutak-pe richin nintzijoj chi ja tiempo re' tok ri Ajaf nuya' ri favor. ");
INSERT INTO cak_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jac'ari' tok ri Jesús xubot can ri vuj ri xu'on leer chiquivech, y xuya' can pa ruk'a' ri samajinel chiri', y xtz'uye' c'a ka. Conojel ri ec'o chiri', benak runak'-quivech chirij. ");
INSERT INTO cak_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jari' tok quire' rubixic xutz'uc-apu chique: Ja chivech rix vacami xbanataj-vi ri ru'in can ri Dios chupan re vuj re', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Conojel ri quimolon-qui' chiri', utz rutzijol niqui'en ri Jesús. Can achique na xquina' tok xquic'axaj ri utzulaj tak ch'abel ri xeru'ij chique, y quire' niquibila' chiquivech: ¿Mana-ta re' ri ruc'ajol ri José c'a? yecha'. ");
INSERT INTO cak_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jac'a ri Jesús xu'ij chique: Yin veteman chi rix quire' nijo' ni'ij chuve: Rat aj-k'omanel, tavok'omaj-ka-avi' ayon, roma kac'axan chi q'uiy milagros ye'abanala' pa Capernaum. Quiri' mismo que'abanala' vave' pan atinamit. Quiri' ri c'o pan ivánima, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y c'a quire' na xu'ij chique: Nis-ta jun profeta ninimex coma ri aj pa rutinamit. ");
INSERT INTO cak_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Rix iveteman ri xbanataj pa ru-tiempo ri profeta Elías, tok oxi' juna' riq'uin nic'aj man xu'on ta job, y romari' xpe nimalaj vayijal pa ruvi' ronojel ri roch'ulef. Kitzij nin-ij chive chi ri tiempo ri' vave' pan Israel ec'o q'uiy malcani' tak ixoki', ");
INSERT INTO cak_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","pero ri Dios man riq'uin ta jun malca'n-ixok vave' pa karoch'ulef Israel xutak-vi ri Elías, xa xutak riq'uin jun malca'n-ixok pa Sarepta, jun tinamit ri c'o chunakaj ri tinamit Sidón. ");
INSERT INTO cak_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Quiri' mismo pa ru-tiempo ri profeta Eliseo, vave' pan Israel eq'uiy vinak yeyavej riq'uin ri yabil lepra. Pero man jun chique rije' xc'achojrises riq'uin ri yabil ri', xaxe ri Naamán, aj pa roch'ulef Siria. ");
INSERT INTO cak_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tok xquic'axaj ri xu'ij ri Jesús, ri quimolon-qui' chiri' pa sinagoga yekukut riq'uin coyoval. ");
INSERT INTO cak_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xecataj c'a, y xquelesaj-e chuchi' ri tinamit. Ri quitinamit chuvech juyu' c'o-vi, y ja ri más pa jotol-e xquic'uaj-vi-e richin niquichicmayij-ka pa sivan. ");
INSERT INTO cak_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jac'a ri Jesús choj xel-pe chiquicojol y xbe. ");
INSERT INTO cak_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Xxule' c'a ka ri Jesús pa tinamit Capernaum ri c'o pa departamento Galilea, y pa tak sábado ri k'ij richin uxlanen, yerutijoj ri niquimol-qui' chiri'. ");
INSERT INTO cak_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ri ye'ac'axan richin, can achique na niquina' che ruchojmil ruch'abel ri Dios ri achok riq'uin yerutijoj-vi, roma nik'alajin chi ri yeru'ij ri Jesús riq'uin ri Dios petenak-vi. ");
INSERT INTO cak_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ri k'ij ri' chiri' pa sinagoga, c'o-apu jun achi ri ocunak itzel espíritu riq'uin, ri riq'uin ruchuk'a' xsiq'uin-pe, ");
INSERT INTO cak_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","y xu'ij: ¡Kojaya' can! ¿Achique roma no'aju-avi' chikacojol rat Jesús aj-Nazaret? ¿Xatuka richin nkojaq'uis? Yin veteman (rat achique, aratcu'x) rat. Veteman chi ja rat ri Lok'olaj ri rat petenak riq'uin ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero ri Jesús xuch'olij ri itzel espíritu, y quire' xu'ij che: ¡Man cach'o chic; catel-e riq'uin! xcha'. Ri itzel espíritu can chiquivech ri ec'o-apu chiri' xutorij pan ulef ri achok riq'uin ocunak-vi, xel c'a e pa ránima, y man jun chic ch'o'oj xu'on can che. ");
INSERT INTO cak_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Conojel ri quimolon-qui', achique na xquina' tok xquitz'et ri xu'on ri Jesús, y niquibila' chiquivech: ¿Achique c'a chi ch'abel nucusaj ri achi re'? Roma can c'o ruk'a' chique ri itzel tak espíritu y c'o ruchuk'a' ri ruch'abel richin nu'ij chique chi que'el-e, yecha' chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ri yerubanala' ri Jesús xbe rutzijol pa ronojel tak lugar ri ec'o-pe chunakaj ri tinamit Capernaum. ");
INSERT INTO cak_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Xcataj c'a pe ri Jesús, xel-pe pa sinagoga y choj xbe chiracho ri jun ru-discípulo rubinan Simón. Jac'a ri rujite' ri Simón nijino pa jun nimalaj c'atan, y ri ec'o chiri' xquic'utuj favor che ri Jesús pa ruvi' ri niyavej. ");
INSERT INTO cak_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Xluque' c'a ka ri Jesús riq'uin ri niyavej y xu'ij chi tiq'uis-e ri c'atan chirij, y can quiri' vi xbanataj. Jac'ari' xcataj-pe cha'anin ri ixok y ja yan chic yerilij ri Jesús y ri ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tok xka yan ka ri k'ij chupan ri k'ij ri', conojel ri c'o yeyavej quiq'uin, xequic'uaj-apu chuvech ri Jesús. Ri yeyavej, jalajoj ruvech yabil ntoc chique, y ri Jesús xuya' ruk'a' pa quivi' chiquijununal richin chi xec'achoj. ");
INSERT INTO cak_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Y ec'o itzel tak espíritu xe'el-e quiq'uin eq'uiy. Tok ye'el-e ri itzel tak espíritu, yesiq'uin riq'uin uchuk'a' y niqui'ij: ¡Ja rat ri Ruc'ajol ri Dios! yecha'. Jac'a ri Jesús xeruch'olij y man xuya' ta lugar chique richin xech'o más, roma ri itzel tak espíritu queteman chi ri Jesús, jari' ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tok xsakar-pe chuca'n k'ij, ri Jesús xel-e pa tinamit, xbe pa jun lugar manak vinak. Pero ri vinak xequicanoj, y tok xquil, xquik'at richin man yeruya' can. ");
INSERT INTO cak_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jac'a ri Jesús xu'ij chique: Yin nic'atzin chi ja jun pa ch'aka' chic tinamit nentzijoj-vi ri utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar, roma yin, richin ri' tok xitak-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y pa tak sinagoga richin ri departamento Galilea nutzijola-vi ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jun k'ij tok ri Jesús c'o chuchi' ri lago Genesaret, eq'uiy vinak niquipitz' roma nicajo' niquic'axaj ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jari' tok ri Jesús xutz'et-apu ca'i' canoas ri eyo'on can chuchi' ri ya', y ri cajaf xa ekajnak-pe richin niquich'aj ri ya'l (tz'ama'el, chapabel) quer. ");
INSERT INTO cak_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jun chique ri canoas re' richin ri Simón. Chupan c'a ri' xoc-vi-apu ri Jesús, y xuc'utuj favor che chi que'oc-apu juba' más pa ruvi' ri ya'. Chiri' c'a xtz'uye-vi-ka richin yerutijoj ri quimolon-apu-qui' riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jac'a tok xtane' richin nich'o, xu'ij che ri Simón: Jo-apu ri achique lugar más naj ka rupan ri ya', y que'iya-ka la ya'l pa ya', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Jac'a ri Simón xu'ij che: Tijonel, roj junak'a' xojc'ase' richin xekacanoj quer, y man jun xuya-ri' chi kak'a'. Pero roma ja rat ya'in chi tikaya-ka ri ya'l pa ya', can quiri' vi xtika'an, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Tok xquiya-ka ri ya'l, q'uiy quer xquiya-pe-qui' chupan, y ri ya'l juba' ma nirak'ach'itaj riq'uin calal ri quer. ");
INSERT INTO cak_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Romari' riq'uin quik'a' xecoyoj-apu ri ch'aka' chic (cachbil, cach'il) ri ec'o-apu chupan ri jun chic canoa richin yequito', y xepe c'a ri ch'aka' chiquito'ic. Chi ca'i' canoas juba' ma yebe chuxe' ya' roma xequinojsaj riq'uin quer. ");
INSERT INTO cak_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Jac'a tok ri Simón Pedro xutz'et chi jun milagro ri xbanataj, xxuque-ka chuvech ri Jesús, y xu'ij che: Ajaf, más utz quinaya' can, roma yin xa yin jun achi aj-mac. ");
INSERT INTO cak_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quiri' xu'ij ri Simón, roma riq'uin xquiya-qui' jani na quer chiquik'a', can achique na xuna' rija', y quiri' mismo conojel ri ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ja jun ri Jacobo y ri Juan, achique na xquina' riq'uin ri xbanataj. Rije' eruc'ajol ri Zebedeo, y (erachbil, jerach'il) ri Simón. Jac'a ri Jesús xu'ij che ri Simón: Man taxi'ij-avi'. Roma ja vacami nitiquer-e chi rat xtavetemaj xque'acanoj tzekle'ey vichin, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jac'ari' xequiq'uen-pe ri canoas chuchi' ya', xquiya' can ronojel y xquitzekle'ej-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Tok ri Jesús c'o pa jun tinamit, c'o jun achi q'uisnak rij riq'uin ri yabil lepra xberuc'utu-ri' chuvech. Ri achi re' xe xutz'et ri Jesús, xxuque-ka, xuya-ka nic'aj-ruvech pan ulef, y riq'uin quemelal xu'ij che: Ajaf, si rat najo', yin veteman chi yatiquer na'an chi yin yic'achoj riq'uin ri nuyabil, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ri Jesús xuya' c'a apu ruk'a' chirij y xu'ij che: Ninjo', cac'achoj c'a. Can jari' xq'uis-e ri lepra chirij ri achi. ");
INSERT INTO cak_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xu'ij che: Man jun achok che tatzijoj-vi ri xbanataj aviq'uin, xa choj cabin, te'ac'utu-avi' chuvech ri sacerdote israelita, y taya' ri sipanic ri ru'in can ri Moisés, richin nik'alajin chiquivech rije' chi rat ch'ajch'oj chic, xcha-e che. ");
INSERT INTO cak_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero xa más xbe rutzijol ri Jesús, y jani na eq'uiy nequimolo-qui' riq'uin richin niquic'axaj ri nuc'ut rija', y richin yec'achoj riq'uin ri quiyabil. ");
INSERT INTO cak_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jac'a rija' can ni'e-vi pa tak chakijlaj tz'iran ulef richin nerubana' orar. ");
INSERT INTO cak_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jun k'ij tok ri Jesús yerutijoj ri quimolon-qui' riq'uin, ec'o achi'a' fariseos y achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés etz'uyul-apu chiri'. Chique ri achi'a' re', ec'o epetenak pa tak aldeas richin ri Galilea, pa tinamit Jerusalem, y pa ch'aka' chic tinamit richin ri Judea. Y ri Jesús c'o ruchuk'a' ri Ajaf Dios riq'uin richin nu'on chi yec'achoj ri yeyavej. ");
INSERT INTO cak_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Pero c'o jun ri caminak ruk'a-rakan ri uc'uan-apu chuvech jun varo'el coma achi'a'. Rije' xquitij quik'ij chi xquicusaj-apu ri niyavej pa jay richin nequiya' chuvech ri Jesús, ");
INSERT INTO cak_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero man niquil ta achique niqui'en richin niquicusaj-apu, roma man juba' ta oc ri quimolon-apu-qui' chiri'. Romari' xejote' pa ruvi' ri jay, xquelesaj-e juba' ruvi', y quiri' cotz'ol ri niyavej chuvech ri varo'el xquikasaj-ka chuvech ri Jesús chiquicojol ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Tok ri Jesús xutz'et chi ri achi'a' riq'uin ronojel cánima quic'amon-apu ri caminak ruk'a-rakan, rija' xu'ij che: Ri amac xe'an yan perdonar, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Jac'a ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, y ri achi'a' fariseos quire' niqui'ij pa tak cánima chirij ri Jesús: ¿Achique chi achi re' ri itzel nich'o chuvech ri Dios? Roma xaxe ri Dios nibano perdonar mac, yecha' pa tak cánima. ");
INSERT INTO cak_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero ri Jesús xuna'ej ri niquinojij ri achi'a' ri'. Romari' xu'ij chique: ¿Achique c'a ri ninojij pa tak ivánima rix? ");
INSERT INTO cak_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Achique c'a ri más man c'ayef ta richin nin-ij che re jun re'? ¿Ja chi xe'an yan perdonar ri rumac, o ja chi ticataj y tuc'uaj-e ri ruvaro'el? ");
INSERT INTO cak_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Pero richin nivetemaj chi yin ri xitak-pe richin xinalex chi'icojol yo'on-pe uchuk'a' chuve richin nin-en perdonar mac pa ruvi' ri roch'ulef, titz'eta' c'a. Jac'ari' xu'ij che ri caminak ruk'a-rakan: Nin-ij c'a chave: Cacataj, tac'uaj-e la avaro'el y cabin chi'avacho, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Can jari' xpa'e' ri caminak ruk'a-rakan chiquivech ri quimolon-qui' chiri', xuc'ol-e ri ruvaro'el ri achok chuvech cotz'oban-vi-pe, y nuya' ruk'ij ri Dios xtzolij-e chiracho. ");
INSERT INTO cak_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Conojel ri xetz'eto, jani na satznak cánima xquiya' ruk'ij ri Dios, y quixi'in-qui' niqui'ij: Vacami xekatz'et milagros ri man jun bey etz'eton, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tok xbanataj yan ronojel re', ri Jesús xel-pe chiri', xutz'et jun achi c'uluy impuestos rubinan Leví tz'uyul ri achique lugar nuc'ul-vi can ri impuestos, y xu'ij che: Quinatzekle'ej, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Xcataj c'a pe ri Leví, xuya' can ronojel, y ja xutzekle'ej. ");
INSERT INTO cak_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Chupan tak ri k'ij ri' rija' xu'on jun nimalaj ruquil-vey chiracho roma ri Jesús, y eq'uiy c'uluy tak impuestos y ch'aka' chic vinak ri ec'o-apu chuchi' mesa riq'uin ri Jesús y ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' fariseos ri ec'o-apu chiri', xa quire' (niquich'ojij, niquich'ojoquij) apu chique ri discípulos: ¿Achique roma rix yixva' y nikum iya' quiq'uin la c'uluy impuestos y quiq'uin la aj-mac tak vinak? yecha'. ");
INSERT INTO cak_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero ri Jesús xu'ij: Man chique ta ri utz niquina' nic'atzin-vi ri aj-k'omanel, xa chique ri yeyavej. ");
INSERT INTO cak_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Quiri' mismo yin man xipe ta chicoyoxic ri niquinojij chi choj ri quic'aslen; yin xipe chicoyoxic ri aj-mac, richin tiquijala' quino'oj y tiquiya' can ri mac, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ri achi'a' fariseos y ri achi'a' q'uiy queteman chirij ri ley quire' xqui'ij che ri Jesús: Ri ru-discípulos ri Juan q'uiy (mul, paj) niqui'en coch'on vayijal, y quiri' mismo ri yetzekle'en kichin roj fariseos. Jac'a ri a-discípulos rat xaxe yeva' y yequikumula' ya', xecha' che. ");
INSERT INTO cak_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jac'a ri Jesús xu'ij chique: ¿Achique ni'ij rix? ¿La c'o cami che'el ni'en chique ri ec'o pa jun c'ulubic chi man yeva' ta, tok c'a c'o na ri ala' ri c'o pa ruc'ulubic quiq'uin? Manak. ");
INSERT INTO cak_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xque'erila' k'ij chi ri ala' xteleses-e chiquicojol, ja chupan tak ri k'ij ri' xtiqui'en coch'on vayijal. ");
INSERT INTO cak_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Y quire' chic jun ejemplo xu'ij chique ri quimolon-qui': Man jun vinak nuk'at-ka jun tziek c'ac'ac' richin nrelesaj-e jun c'ojobel riq'uin richin nuc'ojoj jun tziek ri xa tzia'k chic. Roma si quiri' nu'on, xa nuq'uis ruk'ij ri c'ac'ac' tziek, y ri tziek ri nuc'ojoj che, man juba' xtuc'ul-ri' riq'uin ri c'ac'ac' c'ojobel. ");
INSERT INTO cak_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y man jun niyaco c'ac'ac' vino chupan tzia'k tak tz'un. Roma ri c'ac'ac' vino xa yerubojij-e ri tz'un, y niq'uis-e ri vino, y ri tz'un man jun chic xquec'atzin-vi. ");
INSERT INTO cak_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ri ruchojmil, ja chi ri c'ac'ac' vino niyac chupan c'ac'ac' tak tz'un, y quiri' nis-ta ri tz'un man yebojbo' ta, y nis-ta ri vino man nitix ta e; chi ca'i' yeyaque' utz. ");
INSERT INTO cak_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Man jun ri rukumun ri vino ri c'o chic chi tiempo yaquel, c'a ja ta ri' xtrojo' xtujal riq'uin jun vino ri man layoj ta yaquel. Roma ri quiri' nibano xa xtu'ij: Ri vino ri c'o chic chi tiempo yaquel, jari' ri más utz, xticha'. ");
INSERT INTO cak_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun sábado ri k'ij richin uxlanen, ri Jesús y ri ru-discípulos xek'ax pa jun juyu' ticon trigo chuvech. Ri discípulos yequik'upula-e rutza'n ri trigo ebenak, yequibil pa quik'a' y yequitij. ");
INSERT INTO cak_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ec'o c'a jujun achi'a' fariseos chiri', ri quire' xqui'ij chique ri discípulos: Ri ru-ley ri Dios man juba' nuya' lugar chi ni'an achel ri yixtajin riq'uin, roma vacami k'ij richin uxlanen, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero ri Jesús quire' rutzolic quitzij xu'on ri fariseos: ¿Nis-ta ri xu'on ri David y ri ebenak chirij ri ojer can, tok yevayijan chiri', man ibanon ta leer? ");
INSERT INTO cak_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xoc pa racho ri Dios, xuq'uen-apu ri pan ri sujun chic chuvech ri Dios, xutij, y ja jun chique ri ebenak chirij xuya-vi, masque ru-ley ri Dios nu'ij chi xaxe ri sacerdotes israelitas c'o quik'a' che. ");
INSERT INTO cak_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jac'ari' xu'ij chic chique: Ri Rajaf ri sábado ri k'ij richin uxlanen, ja yin ri xitak-pe richin xinalex chi'icojol, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic sábado ri k'ij richin uxlanen, ri Jesús xoc-apu pa sinagoga, y yerutijoj ri quimolon-qui'. Chiri' c'o jun ri caminak ruk'a' derecha. ");
INSERT INTO cak_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Jac'a ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' fariseos xe niquitz'et-apu ri Jesús, k'alaj ri' si nu'on chi nic'achoj ri niyavej chupan ri sábado ri k'ij richin uxlanen, richin quiri' c'o roma niquisujuj. ");
INSERT INTO cak_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ri Jesús reteman ri niquinojij conojel ri achi'a' ri', romari' xu'ij che ri achi caminak ruk'a': Cacataj y cak'ax-pe pa nic'aj, xcha'. Xcataj c'a pe ri achi, y xpa'e' ri achique lugar xbix-vi che roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jari' tok ri Jesús xu'ij chique ri ec'o chiri': Yin c'o ninjo' ninc'utuj chive: ¿Achique ri más ruyuken-ri' riq'uin ru-ley ri Dios chi ni'an chupan ri sábado ri k'ij richin uxlanen? ¿Ja ri utz o ja ri man utz ta? ¿Ja ri nicol jun vinak chuvech ri camic o nicamises? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nich'icch'ot ruvech chique conojel ri quimolon-qui' chiri', jac'ari' xu'ij che ri achi caminak ruk'a': Tayuku' la ak'a', xcha' che. Can quiri' na vi xu'on ri achi, y ja xc'achoj ri ruk'a'. ");
INSERT INTO cak_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' fariseos, jani na coyoval xcataj, y niquic'utula' chiquivech achique ta yetiquer niqui'en che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Chupan tak ri k'ij ri', ri Jesús xjote-e chuvech jun juyu' richin nerubana' orar; junak'a' xch'o riq'uin ri Dios pan oración. ");
INSERT INTO cak_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Jac'a tok xsakar-pe, xeroyoj-apu ri yetzekle'en richin, xerucha' doce chiquicojol, y xu'ij apóstoles chique. ");
INSERT INTO cak_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Xucha' ri Simón, ri xu'ij Pedro che; xucha' ri Andrés ri quichak'-quinimal qui' riq'uin ri Simón; xerucha' ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cak_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri Alfeo, ri Simón ri c'o quiq'uin ri achi'a' ni'ix celadores chique, ");
INSERT INTO cak_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri quichak'-quinimal qui' riq'uin ri Jacobo, y ri Judas Iscariote ri xticataj chirij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jac'ari' xxule-pe chuvech ri juyu' junan quiq'uin ri ru-apóstoles, y xuc'uje-ka pa jun tak'aj ulef ri quimolon-vi-qui' ch'aka' chic ru-discípulos y man juba' ta oc chi vinak. Ec'o aj pa jalajoj tak lugares richin ri Judea, ec'o aj-Jerusalem, y ec'o aj chunakaj ri mar ri c'o-vi ri tinamit Tiro y ri tinamit Sidón. Conojel re' epetenak richin niquic'axaj ri Jesús, y richin yec'achojrises-e riq'uin ri quiyabil. ");
INSERT INTO cak_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ri niquik'asaj k'axomal pa quik'a' itzel tak espíritu, ri Jesús yerelesaj ri espíritu ri' quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y conojel niquitij quik'ij (niquitz'om, niquichop) apu, roma rija' c'o uchuk'a' ntel riq'uin ri nic'achojrisan quichin conojel. ");
INSERT INTO cak_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jac'ari' tok ri Jesús xerutz'et ri yetzekle'en richin y xu'ij chique: Utzulaj tzij nu'on ri Dios chive rix ri man jun oc ichajin, roma rix, rix ruvinak ri ru-gobierno rija'. ");
INSERT INTO cak_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Rix ri nivayijan ivánima vacami, utzulaj tzij nu'on ri Dios chive, roma xtinojses ivánima riq'uin ri nirayij. Rix ri yixok' vacami, utzulaj tzij nu'on ri Dios chive, roma xtujal ri ivok'ej riq'uin tze'en. ");
INSERT INTO cak_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Utzulaj tzij xtu'on ri Dios chive rix tok ri vinak itzel yixquitz'et, tok yixquelesaj-pe chiquicojol, tok yixquiya' chi q'uix, y tok itzel yech'o chivij roma iniman ri nubi' yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Quixropin roma yixquicot tok quiri' xti'an chive, roma ri chicaj c'o jun nimalaj rajil-ruq'uexel xtiyo'ox chive. Quiri' nin-ij chive, roma ri vinak ri itzel yixquitz'et rix vacami, ri cati't-quimama' rije' quiri' mismo xqui'en-e chique ri profetas ojer. ");
INSERT INTO cak_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jac'a rix beyoma', ¡tok'ex ivech! Roma xaxe chupan re c'aslen choch'ulef xquixquicot-vi. ");
INSERT INTO cak_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rix ri c'o ronojel chivech vacami, ¡tok'ex ivech! Roma xtuka jun k'ij tok xtik'asaj vayijal. Rix ri jabel yixtze'en vacami, ¡tok'ex ivech! Roma xtuka jun k'ij tok xquixok' roma bis. ");
INSERT INTO cak_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Rix, tok utz itzijol niqui'en conojel, ¡tok'ex ivech! Roma ri quite-quitata' ri vinak ri' utz quitzijol xqui'en-e ri xquik'ebaj-qui' chi eru-profetas ri Dios ojer. ");
INSERT INTO cak_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jac'a rix ri iyo'on ixiquin riq'uin ri yitajin chubixic, nin-ij c'a chive: Que'ijo' ri itzel yixquitz'et, y tibana' utz chique ri man yixcajo' ta. ");
INSERT INTO cak_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ri yeyok'on ivichin, titzolij ruvech quitzij riq'uin utzulaj tak tzij, y tibana' orar pa quivi' ri yebano k'eban tzij chivij. ");
INSERT INTO cak_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ri niyo'on jutz'aj k'a' chi'ak'o'tz, taya' chic apu ri jun ak'o'tz chuvech, y ri nimajo-e jun atziak manak más rajil, man tapokonaj naya-e jun ri más c'o rajil che. ");
INSERT INTO cak_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xa achique na jun ri c'o nuc'utuj chave, man taq'ueq'uej naya-e che, y ri c'o numaj-e chave, man chic tac'utuj che chi nutzolij chave. ");
INSERT INTO cak_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y achel nika chivech rix chi can ta utz quino'oj niqui'en ri vinak iviq'uin, quiri' mismo tibana' rix chique. ");
INSERT INTO cak_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Roma si xaxe ri yixcajo' rix ri ye'ijo', ¿achique utz nik'alajin iviq'uin? Man jun. Roma xa quiri' mismo niqui'en ri man quiniman ta ri Dios, xaxe ri ye'ojo'on quichin ri yecajo'. ");
INSERT INTO cak_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y si xaxe chique ri yebano favor chive ni'en-vi favor, ¿achique utz nik'alajin iviq'uin? Man jun. Roma ri man quiniman ta ri Dios, quiri' mismo niqui'en. ");
INSERT INTO cak_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Si rix niya' jun cosa pa kajic, y nivoyo'ej chi nitzolis chic chive, ¿achique utz nik'alajin iviq'uin? Man jun. Roma ri man quiniman ta ri Dios yequiya' qui-cosas pa kajic chique ri ejunan quiq'uin, roma queteman chi nitzolis ruq'uexel chique. ");
INSERT INTO cak_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero rix man ti'en quiri'. Xa que'ijo' ri itzel yixquitz'et, y tibana' ri utz, y tok rix niya' jun cosa pa kajic, man tivoyo'ej chi nitzolis chic chive. Richin quiri' (nim, tij) rajil-ruq'uexel xtiyo'ox chive, y xtik'alajin chi rix ralc'ua'l chic ri nimalaj Dios ri c'o pa ruvi' ronojel. Roma rija' utz runo'oj quiq'uin ri man jun bey yematioxin, y quiq'uin ri itzel quino'oj. ");
INSERT INTO cak_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Rix c'a, quixpokonan, achel nipokonan ri Itata' Dios. ");
INSERT INTO cak_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man tinic'oj rij quic'aslen ri vinak, richin quiri' man xtinic'ox ta rij ri ic'aslen rix. Man tirayij chi nika castigo pa quivi' ch'aka' chic, y man xtirayix ta chi nika castigo pan ivi' rix. Tibana' perdonar, y xquix-an perdonar. ");
INSERT INTO cak_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Quixsipan, y c'o xtisipes chive. Ri xticuses richin netex-pe ri achique nisipes-pe chive, utz-utz nibiy-pe rupan, utz-utz ninojses-pe y hasta nipulput ruvi', richin (nik'ej, nik'ij) pe chupan ri itziak ri achok chupan nich'okej-vi-pe. Roma achel ri niya' rix chique ch'aka' chic, quiri' mismo rajil-ruq'uexel xtiyo'ox chive. ");
INSERT INTO cak_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Quire' c'a jun ejemplo xutzijoj ri Jesús chique: ¿Nitiquer cami jun man nitzu'un ta nuyukej chuk'a' jun chic ri mismo man nitzu'un ta? Manak, xa chi ca'i' ye'etzak pa jul. ");
INSERT INTO cak_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Man jun discípulo ri más q'uiy reteman que chuvech ri rutijonel, jac'a si nitijox utz-utz, nitiquer nretemaj ri achel reteman ri rutijonel. ");
INSERT INTO cak_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Y rat, ¿achique roma ja ri ch'uti q'uin ocunak pa ruvech jun chic ri natz'et y man nana' ta ka ri che' ocunak pan avech? ");
INSERT INTO cak_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y, ¿achique ak'a' richin na'ij che ri jun chic ri': Taya' lugar chuve chi ninvelesaj ri ch'uti q'uin ocunak pan avech, y man nana' ta ka ri che' ocunak pan avech? Rat xa ca'i' rupalaj ri yatajin riq'uin. Na'ey tavelesaj ri che' ocunak pan avech, y quiri' xcatzu'un utz, richin yatiquer navelesaj ri q'uin pa ruvech ri jun chic. ");
INSERT INTO cak_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Quiri' nin-ij chive roma mana-ta ri che' utz ri nuya' itzel tak ruvech, ni mana-ta ri itzel che' ri nuya' utzulaj tak ruvech. ");
INSERT INTO cak_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Roma ronojel che' nitemetaj achique chi che' riq'uin ri ruvech ri nuya'. Ri q'uix man nuya' ta higo, nis-ta ri (xulu-quiej, zarza) man nuya' ta uva. ");
INSERT INTO cak_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Quiri' mismo jun vinak. Ri vinak utz, ja ri utz ri ruyacon pa ránima ri nu'ij, jac'a ri vinak itzel ruc'aslen, ja ri itzel ri ruyacon pa ránima ri nu'ij. Roma ja ri achique nojnak pa ránima ri vinak ri ye'el pa ruchi'. ");
INSERT INTO cak_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Achique roma rix Ajaf, Ajaf, yixcha' chuve, y xa man ni'en ta ri nin-ij yin? ");
INSERT INTO cak_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Xa achique na jun ri nipe viq'uin, y nrac'axaj ri nuch'abel y nu'on ri nin-ij che, nin-ij c'a chive achok riq'uin junan vi. ");
INSERT INTO cak_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Rija' junan riq'uin jun ri xupaba' jun jay. Na'ey, xuc'ot-ka naj ri jul richin rutz'uyubal ri jay, y c'a chupan abaj xutz'uyuba-vi-ka. Tok xq'uiy-pe ri rakan-ya', xberuc'aka-ri' chirij ri jay, pero man xtiquer ta xusiloj, roma chupan abaj tz'uyul-vi. ");
INSERT INTO cak_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ri xac'axan ri nuch'abel, y man nu'on ta ri nin-ij che, junan riq'uin jun ri xa pa ruvi' ulef xupaba-vi ri racho, y man jun rutz'uyubal xuya-ka. Xq'uiy-pe ri rakan-ya', xberuc'aka-ri' chirij ri jay, y xa xtzak; chi ronojel xvuluvu'. ");
INSERT INTO cak_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tok ri Jesús xtane' chi nich'o chiquivech ri ye'ac'axan richin, rija' xbe pa tinamit Capernaum. ");
INSERT INTO cak_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","C'o c'a jun uc'uay quichin soldados c'o jun rusamajinel ri (nicom yan, mayaj chic) pa ruk'a' yabil, y rija' can rupokonan ri rusamajinel. ");
INSERT INTO cak_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Tok rija' xrac'axaj rutzijol ri Jesús, xerutak-e ca'i-oxi' nima'k quijuna' achi'a' c'o quik'ij chiquicojol ri israelitas richin nequic'utuj favor che ri Jesús chi tipe juba' richin nurubana' chi nic'achoj ri samajinel. ");
INSERT INTO cak_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Tok (xe'apon, xe'ebos) ri etakon-e, riq'uin quemelal niquic'utuj favor che ri Jesús, y niqui'ij: Ri achi uc'uay quichin soldados can nuc'ul-vi chi rat na'an ri favor che, ");
INSERT INTO cak_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","roma rija' utz runo'oj kiq'uin roj israelitas, y rubanon jun sinagoga richin nikamol-vi-ki', xecha'. ");
INSERT INTO cak_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Xbe c'a ri Jesús chiquij ri achi'a' etakon-pe, y tok nakaj chic ec'o-vi-apu che ri jay, ri uc'uay quichin soldados xerutak-pe jujun ru-amigos richin xuquic'ulu' ri Jesús, y quire' xuqui'ij che: Ri roj takayon-pe quire' nrojo' nu'ij chave: Ajaf, man taya-ka más samaj chavij, roma rat c'o ak'ij, y romari' chuve yin man nuc'ul ta chi yatoc pa vacho. ");
INSERT INTO cak_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Romari' ri vánima nuna' chi nis-ta nuc'ul chi yin yinech'o aviq'uin. Pero xaxe ta'ij chi nic'achoj ri nusamajinel, y yin veteman chi can xtic'achoj-vi. ");
INSERT INTO cak_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Quiri' nin-ij chave, roma ja jun yin yinc'o chuxe' rutzij jun chic, y jari' ri ni'in chuve ri achique nic'atzin chi nin-en. Y ec'o soldados eyo'on pa nuk'a'. Tok nin-ij che jun chi ti'e, can ni'e-vi; y si nin-ij che jun chic chi tipe, can nipe-vi. Tok nin-ij che ri nusamajinel chi tubana' jun samaj, can nu'on-vi. Quiri' ru'in-pe ri achi roj takayon-pe, xecha' ri achi'a' che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Can achique na xuna' ri Jesús chirij ri uc'uay quichin soldados roma ri ch'abel ri rutakon-e rubixic. Xtzu'un c'a can chirij, y quire' xu'ij chique ri ebenak chirij: Yin nin-ij chive chi nis-ta chiquicojol ri nuvinak israelitas man vilon ta jun ri can nunimaj chi nibanataj ri nin-ij che, achel nunimaj ri jun achi re', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jac'a tok xetzolij ri achi'a' ri xetak-e, xquitz'et chi ri samajinel man niyavej ta chic. ");
INSERT INTO cak_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pa jun chic k'ij, ri Jesús xbe pa jun tinamit rubinan Naín, ebenak q'uiy ru-discípulos y man juba' ta oc vinak chirij. ");
INSERT INTO cak_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tok c'o chic apu nakaj che ruchi' ri tinamit, jari' epetenak q'uiy vinak chumukic jun ala', juney oc ral jun ixok malca'n. ");
INSERT INTO cak_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Tok ri Ajaf Jesús xutz'et ri ixok, xupokonaj ruvech, y xu'ij che: Man chic catok'. ");
INSERT INTO cak_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Xjel-apu ri Jesús riq'uin ri ámna, xuya-apu ruk'a' chirij ri caja, y ri eteleyon-e xepa'e-ka. Xch'o c'a che ri ámna y xu'ij: Rat ala', chave nin-ij-vi chi cacataj. ");
INSERT INTO cak_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Jac'ari' xtz'uye' ri ámna y xch'o-pe; y ri Jesús xujach-e che ri rute'. ");
INSERT INTO cak_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Xquixi'ij-qui' conojel roma ri xbanataj, y richin niquiya' ruk'ij ri Dios, quire' niquibila': Jun nimalaj profeta xk'alajin-pe chikacojol. Ri Dios xutak-pe jun ri niyo'on favor chikacojol ri roj rutinamit, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Chi naj chi nakaj chiri' pa departamento Judea y pa tak tinamit ri ec'o-pe chunakaj ri Judea xbe-vi rutzijol ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ronojel c'a re xbanataj xyo'ox rutzijol che ri Juan ri Bautista coma ri ru-discípulos. Rija' xeroyoj eca'i' chique, ");
INSERT INTO cak_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xerutak-e riq'uin ri Jesús, richin chi quire' nequic'utuj che: ¿Ja rat ri Jun ri sujun-pe roma ri Dios chi nipe? ¿O c'a nikoyo'ej chic jun? ");
INSERT INTO cak_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ri erutakon-e quire' xqui'ij che ri Jesús: Ri Juan ri Bautista roj rutakon-pe aviq'uin richin nukac'utuj quire' chave: ¿Ja rat ri Jun ri sujun-pe roma ri Dios chi nipe? ¿O c'a nikoyo'ej chic jun? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja hora ri' ri Jesús xu'on chi xec'achoj eq'uiy yeyavej y eq'uiy ri c'o jalajoj tak k'axomal quiq'uin; eq'uiy xerelesaj itzel tak espíritu quiq'uin, y eq'uiy ri man yetzu'un ta xu'on chique chi xetzu'un. ");
INSERT INTO cak_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jac'ari' xu'ij-pe chique ri eca'i' etakon-e riq'uin: Vacami quixtzolij y titzijoj che ri Juan ri xitz'et can y ri xivac'axaj-e vave'; chi ri man yetzu'un ta, vacami yetzu'un chic; ri man utz ta cakan, vacami utz yebin; ri c'o yabil lepra chiquij, yec'achoj; ri man ye'ac'axan ta, vacami ye'ac'axan chic; ri anima'i' yec'astaj; y chique ri man jun oc quichajin, nitzijos ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj. ");
INSERT INTO cak_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ti'ij che ri Juan chi utzulaj tzij banon che ri man nril ta jun roma chi nuxutuj can ri Dios riq'uin ri yitajin yin, xcha-e ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Tok xetzolij-e ru-discípulos ri Juan, ri Jesús (xutz'om, xuchop) nich'o pa ruvi' ruc'aslen ri Juan, y quire' nu'ij chique ri ec'o-apu riq'uin: ¿Achique ri xe'itz'eta' rix ri pa chakijlaj tz'iran ulef? ¿Xitz'et cami jun achi chiri', ri man cof ta pa'el riq'uin ri achique nutzijoj, achel jun aj pa ruk'a' cak'ik'? Man quiri' ta. ");
INSERT INTO cak_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nis-ta man xitz'et ta can jun achi ri ruyon nima'k tak cajil tziek yerucusaj. Tuka pan ivi', ri yecusan utzulaj tak tziek y xa ronojel c'o quik'a' che, pa qui-palacio reyes yec'uje-vi. ");
INSERT INTO cak_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Y, ¿achique ri xe'itz'eta' c'a? Rix kitzij chi xitz'et can jun profeta, pero man xe ta ri samaj richin profeta yo'on pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Roma ri tz'iban can, ja ri Juan ri nuc'uxlaj tok nu'ij: Xtintak jun yo'ol utzulaj atzijol na'ey chavech, Richin nuchojmirisaj-apu ri abey. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jac'a yin nin-ij chi chiquicojol conojel ri ek'axnak-e choch'ulef, man jun chic jun profeta más c'o ruk'ij que chuvech ri Juan ri Bautista. Pero ri más manak oc ruk'ij chiquicojol ri erichin ri ru-gobierno ri Ajaf Dios, más c'o ruk'ij que chuvech ri Juan. ");
INSERT INTO cak_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tok conojel ri vinak y ri c'uluy tak impuestos ri ebanon bautizar roma ri Juan xquic'axaj ri ch'abel ri xu'ij ri Jesús, xqui'ij chi ri Dios can choj pa ruvi' ronojel. ");
INSERT INTO cak_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Jac'a ri achi'a' fariseos y ri q'uiy queteman chirij ri ley, man xcajo' ta xe'an bautizar roma ri Juan. Quiyon xquixutuj ri runojin ránima ri Dios pa quivi'. ");
INSERT INTO cak_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jari' tok ri Jesús quire' xu'ij: ¿Achok riq'uin cami yenjunumaj-vi ri vinak ri ec'o vacami? ¿Y achok riq'uin cami ejunan vi? ");
INSERT INTO cak_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ejunan quiq'uin ri ac'ola' ye'etz'an pa tak c'ayibel y riq'uin cuchuk'a' yesiq'uin chiquivech, y niqui'ij: Xkak'ojomaj xul chivech y man xixxojo ta. Xkabixaj bix richin bis chivech y man xixok' ta. Quiri' ri vinak re'. ");
INSERT INTO cak_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Roma tok xuka ri Juan ri Bautista, man nutij ta pan y man nukum ta vino. Y rix ni'ij chi c'o itzel espíritu riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y tok xinuka yin ri xitak-pe richin xinalex chi'icojol, xa ronojel nintij y ninkum y rix ni'ij chi xe va'in nin-en y yin kumuy vino, yin (cachbil, cach'il) ri c'uluy impuestos y ri vinak aj-mac yixcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri no'oj ri petenak riq'uin ri Dios nik'alajin pa tak quic'aslen conojel ri yebano ri rusamaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jun chique ri achi'a' fariseos xuc'utuj favor che ri Jesús richin teva' chiracho. Y chiri' chiracho ri fariseo, ri Jesús xtz'uye-apu chuchi' mesa. ");
INSERT INTO cak_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y c'o c'a jun ixok man utz ta ruc'aslen aj chiri' pa tinamit. Rija' tok xrac'axaj chi ri Jesús niva' chuchi' mesa chiracho ri fariseo, xbe-apu chiri', ruc'amon-apu jun yacabel banon riq'uin jun abaj rubinan alabastro ri nojnak riq'uin jun jubulaj ak'on. ");
INSERT INTO cak_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ri ixok ntok' xjel-apu chirij ri Jesús, y ri rok'ej yeka chirij rakan ri Jesús. Ri ixok yerusula' riq'uin ri rusumal tak ruvi', yerutz'ubula' y (xuk'ej, xuk'ij) ri jubulaj ak'on chiquij. ");
INSERT INTO cak_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Jac'a tok ri fariseo ri xoyon richin ri Jesús nutz'et ri achique nu'on ri ixok, quire' nunojij: Xa ta kitzij chi ri achi re' jun profeta, can ta nuna'ej achique la (nitz'amo, nichapo) apu richin, y achique chi ixok, roma la' xa itzel ruc'aslen, xcha-ka pa ránima. ");
INSERT INTO cak_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jac'a ri Jesús xu'ij che ri fariseo: Simón, yin c'o jun ninjo' nin-ij chave, xcha'. Ta'ij c'a, Tijonel, xcha' ri Simón. ");
INSERT INTO cak_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ri Jesús xu'ij che: C'o eca'i' xc'uje' quic'as riq'uin jun ri niyo'on méra pa kajic. Jun c'o ruc'as achel rajil jun samajinel jun juna' riq'uin nic'aj, y ri jun chic, achel rajil jun samajinel ca'i' ic'. ");
INSERT INTO cak_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero ri ca'i' re' roma man yetiquer ta niquitzolij ri quic'as, romari' ri niyo'on méra pa kajic, xu'ij chique chi tiq'uis quiri' ri quic'as. Jac'ari' xuc'utuj ri Jesús che ri fariseo: Pan avech rat, ¿achique chique ri ca'i' re' más xtrojo' ri xbano perdonar ri quic'as? ");
INSERT INTO cak_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xu'ij: Yin nin-ij chi ja ri más q'uiy ruc'as x-an perdonar, xcha'. Ja', quiri', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jac'ari' xtzu'un-ka riq'uin ri ixok y xu'ij che ri Simón: ¿Natz'et ri ixok re'? Tok yin xinoc-pe pan avacho, man xaya' ta nuya' richin xinch'aj vakan. Jac'a rija' xeruch'aj vakan riq'uin ri ruya'al tak ruvech, y xeruchakirisaj riq'uin ri rusumal tak ruvi'. ");
INSERT INTO cak_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tok xinoc-pe pan avacho man (xinatz'ubaj, xinatz'ub) ta richin xac'ul nuvech. Jac'a rija', xe tok xinoc-pe, jari' yerutz'ubula' ri vakan. ");
INSERT INTO cak_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rat man (xak'ej, xak'ij) ta aceite pa (nujolon, nuvi') tok xinoc-pe. Jac'a rija', (xuk'ej, xuk'ij) jubulaj ak'on chirij ri vakan. ");
INSERT INTO cak_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Romari' nin-ij chave, chi ri ixok re' xuc'ut chi can yirojo', y chiri' nik'alajin-vi chi can q'uiy rumac xe'an perdonar. Jac'a ri man q'uiy ta rumac erubanalo'n, y x-an perdonar, man can ta nrojo' ri achique xbano perdonar richin, xcha' che ri Simón. ");
INSERT INTO cak_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jac'ari' xu'ij ri Jesús che ri ixok: Ri amac xe'an yan perdonar, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jac'a ri junan etz'uyul-apu riq'uin ri Jesús chuchi' ri mesa, quire' niquibila' chiquivech: ¿Achique chi achi re' chi can nu'on perdonar mac? yecha'. ");
INSERT INTO cak_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xu'ij che ri ixok: Roma ronojel avánima xape viq'uin, romari' xacolotaj. Vacami catzolij; ri avánima xril uxlanen, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tok k'axnak chic ca'i-oxi' k'ij tibanataj re', ri Jesús xbe pa ronojel tak tinamit y aldeas chutzijosic ri utzulaj ch'abel ri nu'ij achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar, y ri doce ru-discípulos ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","(Chuka', ka) ebenak jujun ixoki' ri eruc'achojrisan y relesan itzel tak espíritu quiq'uin. Jun chique ri ixoki' ri', ja ri María ri ni'ix Magdalena che, ri achok riq'uin elesan-vi vuku' itzel tak espíritu roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jun chic ja ri Juana, rixayil jun achi rubinan Chuza, ri nisamaj riq'uin ri rey Herodes; jun chic rubinan Susana, y más chic ixoki'. Conojel ri ixoki' re' yequilij ri Jesús y ri ru-discípulos riq'uin ri quichajin. ");
INSERT INTO cak_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","C'o jun k'ij q'uiy vinak xquimol-apu-qui' riq'uin ri Jesús; jalajoj tak tinamit ye'el-vi-pe richin yebin-apu riq'uin. Jari' tok rija' xutzijoj ri ejemplo re': ");
INSERT INTO cak_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o jun ticonel xbe chuquiraxic semilla. Y tok ja nuquiraj chiri', c'o che ri semilla xeka pa bey, xepatzalo's can, y xepe ri chicop c'o quixic', xquitij-e ri semilla. ");
INSERT INTO cak_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ch'aka' che ri semilla xeka chiquicojol tak abaj, y tok xe'el-pe, xa xechakij-ka, roma manak ruraxal ri ulef. ");
INSERT INTO cak_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ch'aka' che ri semilla xeka achique lugar ye'el-vi-pe q'uix, y ri q'uix ri junan xe'el-pe quiq'uin ri tico'n, xqui'en chi xek'aner-ka. ");
INSERT INTO cak_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y ch'aka' che ri semilla xeka pa ruch'acul ri ulef, xe'el-pe, y xquiya' a cien quivech. Tok ri Jesús xuq'uis rubixic ri ejemplo re', riq'uin ruchuk'a' xu'ij: Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jac'a ri discípulos quire' xquic'utuj che ri Jesús: ¿Achique nu'ij tzij ri ejemplo re'? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ri Jesús xu'ij chique: Chive rix yo'on lugar chi nivetemaj ri man can ta ojer ri' k'alajrisan can chirij ru-gobierno ri Dios. Jac'a chique ri vinak, xa riq'uin ejemplos yich'o-vi, richin quiri' masque niquitz'et ri najin chiquivech, pero xa achel man yetzu'un ta, y masque niquic'axaj ri ni'ix chique, pero xa man (nik'ax, nino') ta chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y ja nin-ij-apu ruchojmil ri ejemplo chive: Ri semilla ja ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri semilla ri xeka pa bey, jari' nu'ij tzij chi ec'o vinak tok quic'axan chic ruch'abel ri Dios, ja nipe ri itzel y nrelesaj-e ri ch'abel ri' pa cánima, richin man tiquinimaj ri Dios, y man quecolotaj. ");
INSERT INTO cak_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ri semilla ri xeka chiquicojol tak abaj, nich'o pa quivi' ri ye'ac'axan ruch'abel ri Dios; can yequicot niquic'ul, pero man nuq'uen ta ka ruvech pa cánima. Romari' xa juba' oc k'ij niquiya' cánima riq'uin ri Dios, y tok yepe c'ayef pa quic'aslen, xa niquiya' can ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Y ri semilla ri xeka chiquicojol tak q'uix, jari' nu'ij tzij chi ec'o ye'ac'axan ruch'abel ri Dios, pero riq'uin benak ri tiempo, xa (nik'ayisan, nik'osmer) pe ri quic'aslen, roma ni'e cánima pa ruvi' ri achique nic'atzin chique choch'ulef, pa ruvi' beyomal, y pa ruvi' ri niquina' rije' chi nu'on chique chi yequicot. Rije' e'achel jun tico'n ri man jun ruvech nuya'. ");
INSERT INTO cak_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Jac'a ri semilla ri xeka pa ruch'acul ri ulef, jari' nu'ij tzij chi ec'o ye'ac'axan ruch'abel ri Dios, y riq'uin jun utzulaj y chojmilaj cánima niquic'axaj y niqui'en ri nu'ij. Y riq'uin ri jumul ec'o chupan rubey ri Dios, nu'on chi c'o utz nik'alajin pa quic'aslen, achel jun tico'n ri can c'o nuya'. ");
INSERT INTO cak_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Man jun vinak nutzij jun candil y nujuba' jun bojo'y pa ruvi', o nuya-apu chuxe' ch'at, xa nuya' pa (ruc'ojle'el, ru-lugar) richin quiri' sak niquitz'et ri ye'oc-apu pa jay. ");
INSERT INTO cak_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Quiri' nin-ij chive roma man jun ri evan ri man ta xtek'alajin-pe, ni man jun ri banon che'elek'el ri man ta xtetemex y xtel-pe chosakil. ");
INSERT INTO cak_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Roma c'a ri', tiya' ixiquin y tiyaca-ka pa tak ivánima ri nin-ij chive. Roma xa achique na ri c'o ruch'abel ri Dios ruyacon pa ránima, xtiyo'ox más che. Jac'a ri man jun ruch'abel ri Dios pa ránima, ronojel ri nunojij chi c'o chic pa ránima, xa neleses-e che, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jac'ari' xe'eka ri rute' y ri eruchak' ri Jesús ri achique lugar c'o-vi rija'. Pero man xetiquer ta xe'oc-apu riq'uin, roma eq'uiy vinak quimolon-qui' riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Quire' c'a xbix-apu che ri Jesús: Ri ate' y ri e'achak' ec'o chojay y nicajo' yatquitz'et. ");
INSERT INTO cak_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jac'a rija' xu'ij chique ri xeyo'on-apu rutzijol che: Ri nte' y ri enchak', ja ri ye'ac'axan y ri yebano ri nu'ij ri ruch'abel ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Xbanataj jun k'ij chi ri Jesús y ri ru-discípulos xe'oc-e pa jun canoa, y rija' xu'ij chique: Jo-apu ri juc'an ruchi' ri lago, xcha' chique. Y can xebe na vi. ");
INSERT INTO cak_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tok ebenak pa ruvi' ri ya', ri Jesús xver-ka. Jac'ari' xtiquer-pe jun nimalaj cak'ik', y romari' ri canoa ri ebenak-vi ninoj-pe riq'uin ya', y juba' ma ni'e-ka chuxe' ya'. ");
INSERT INTO cak_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xejel c'a apu ri discípulos riq'uin ri Jesús, xquic'asoj y xqui'ij che: ¡Tijonel, tijonel! ¡Kojato' vacami nkujik'! xecha' che. Xcataj c'a pe ri Jesús, cof xch'o che ri cak'ik' y ri ya' nibolko't, jac'ari' xetane-ka y li'an xu'on-ka ruvi' ri ya'. ");
INSERT INTO cak_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jac'a ri Jesús xu'ij chique: ¿Can man juba' cukul ic'u'x viq'uin? Pero rije' xa quixi'in-qui', can achique na xquina', y niquic'utula' chiquivech: ¿Achique chi achi re' chi hasta chique ri cak'ik' y ri ya' nich'o-vi y can niquinimaj rutzij? yecha'. ");
INSERT INTO cak_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Juc'an apu ruchi' ri lago pa jun lugar quichin ri aj-Gadara, ri c'o-apu chuvech ri Galilea, xe'el-vi ri Jesús y ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jac'a tok ri Jesús xka-ka pan ulef, c'o jun achi aj pa tinamit ri xuc'ulu richin. Ri achi re' c'o chic chi tiempo quec'uje' itzel tak espíritu pa ránima. Manak rutziak nucusaj, ni man nic'uje' ta chiracho, xa pa camposanto nic'uje-vi. ");
INSERT INTO cak_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Xe xutz'et ri Jesús, nisiq'uin xxuque-ka chuvech y riq'uin ruchuk'a' xu'ij-apu che: Rat Jesús, ri Ruc'ajol ri nimalaj Dios pa ruvi' ronojel, ¿achique najo' chuve? Ninc'utuj quemelal chave chi man quinaya' pa k'axomal, nicha'. ");
INSERT INTO cak_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Quiri' nu'ij-pe, roma ri Jesús xu'ij che ri itzel espíritu chi tel-e riq'uin ri achi. Roma ri itzel espíritu, q'uiy (mul, paj) nuya-pe ruchuk'a' chupan ru-cuerpo ri achi, y masque nixim ruk'a-rakan riq'uin cadenas richin nichajix, yeruc'ojpij, y ri itzel espíritu nu'on che chi ni'e pa tak lugares manak vinak. ");
INSERT INTO cak_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xuc'utuj che: ¿Achique abi'? Legión, xcha'. Quiri' xu'ij ri achi roma q'uiy itzel tak espíritu ocunak riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y re' niquic'utula' quemelal che ri Jesús chi man querutak chupan ri nimalaj jul ri ruyon k'eku'n benak-ka rupan. ");
INSERT INTO cak_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ec'o c'a q'uiy ak yeva' pa ruvi' jun juyu' chiri' nakaj, y ri itzel tak espíritu niquic'utula' che ri Jesús chi tuya' lugar chi ye'oc quiq'uin ri ak. Y ri Jesús xu'ij chique chi utz. ");
INSERT INTO cak_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Tok e'elenak chic e ri itzel tak espíritu riq'uin ri achi, xe'oc quiq'uin ri ak, y conojel ri ak niquitelela-qui' xebe chuvech jun rak'aric juyu' c'a pa ya', y chiri' xejik'-vi. ");
INSERT INTO cak_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ri yeyuk'un quichin ri ak, tok xquitz'et ri xbanataj, xe'enimaj y xbequiya' rutzijol pa tinamit y ri pa tak juyu'. ");
INSERT INTO cak_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xepe c'a ri vinak chutz'etic ri xbanataj, y tok xe'uka ri c'o-vi ri Jesús, xquitz'et chi ri achi achok riq'uin xe'el-vi-e ri itzel tak espíritu, tz'uyul chirakan ri Jesús. Rucusan rutziak, y man nich'ujyej ta chic achel ri rubanon-pe, y romari' xa xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ri xetz'eto ri achique xbanataj richin xcolotaj ri achi pa quik'a' ri itzel tak espíritu, xquitzijoj ronojel chique ri xequimolo-qui' chiri'. ");
INSERT INTO cak_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Jac'ari' conojel ri vinak erichin ri lugar Gadara, xquic'utuj favor che ri Jesús chi tel-e chiri', roma quixi'in-qui'. Jari' xoc chic e ri Jesús pa canoa y xtzolij. ");
INSERT INTO cak_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Jac'a ri achi ri xe'el-e itzel tak espíritu riq'uin, nuc'utula' quemelal che ri Jesús chi tuya' lugar che chi ni'e chirij. Pero ri Jesús quire' xu'ij can che: ");
INSERT INTO cak_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolij chi'avacho, tatzijoj ri nimalaj favor ri xu'on ri Dios aviq'uin, xcha'. Xtzolij c'a ri achi, y chi jun tinamit xutzijoj-vi ronojel ri nimalaj favor ri xu'on ri Jesús riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tok ri Jesús y ri ru-discípulos xetzolij chic jun bey ri juc'an apu ruchi' ri lago, jani na q'uiy vinak yequicot xquic'ul ruvech, roma conojel ja rija' coyo'en. ");
INSERT INTO cak_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jac'ari' tok xjel-apu riq'uin ri Jesús jun achi c'o ruk'ij pa sinagoga rubinan Jairo. Ri achi re' xxuque-ka chuvech ri Jesús y riq'uin quemelal nuc'utuj che chi ti'e chirij chiracho, ");
INSERT INTO cak_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","roma (nicom yan, mayaj chic) ri juney rumi'al, jun xten ri c'o cami doce rujuna'. Jac'a tok ri Jesús benak chiracho ri Jairo, ri vinak niquipitz'ila' ebenak. ");
INSERT INTO cak_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Y c'o c'a jun ixok ri ja doce juna' nibin ruquiq'uel roma jun yabil. Rija' ronojel ri ruchajin ruq'uison chiquivech aj-k'omanela', pero nis-ta jun aj-k'omanel xtiquer xbano che chi xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cak_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok re' xjel-apu chirij ri Jesús, (xutz'om, xuchop) apu ruchi' ri rutziak, y jari' xtane' chi nibin ri ruquiq'uel. ");
INSERT INTO cak_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jac'ari' xuc'utuj ri Jesús: ¿(Achique, acu'x) c'a ri xuya-pe ruk'a' chuvij? Conojel niqui'ij chi mana-ta rije', romari' ri Pedro y ri ec'o-apu riq'uin xqui'ij che ri Jesús: Tijonel, la vinak yatquipitz'ila-yatquinimila' epetenak, ¿y rat najo' navetemaj (achique, acu'x) ri xuya-apu ruk'a' chavij? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jac'a ri Jesús xu'ij: C'o jun xuya-pe ruk'a' chuvij, roma yin xinna' chi c'o uchuk'a' xel-e viq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tok ri ixok xutz'et chi xna'ex ri xu'on, nibarbot xbexuque' chuvech ri Jesús, y chiquivech conojel xu'ij-vi che ri Jesús ri achique roma (xutz'om, xuchop) apu ruchi' ri rutziak, y chi can jari' xc'achoj xuna' rija'. ");
INSERT INTO cak_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xu'ij che: Numi'al, roma ronojel avánima xape viq'uin, romari' xacolotaj chuvech ri ayabil. Vacami catzolij, ri avánima xril uxlanen. ");
INSERT INTO cak_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","C'a nich'o na ri Jesús riq'uin ri ixok, tok (xapon, xebos) jun ri elenak-pe chiracho ri achi c'o ruk'ij pa sinagoga, y quire' xu'ij che ri Jairo: Ri ami'al ja (xcom, xquen) ka. Man chic tanak ri Tijonel, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Tok ri Jesús xrac'axaj ri xbix che ri Jairo, rija' xu'ij che: Man taxi'ij-avi', xaxe tanimaj pan avánima, y ri ami'al can xtic'achoj-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Tok ja ntoc-apu chiracho ri Jairo, ri Jesús man jun achok che xuya' lugar chi xoc-apu ri pa jay; xaxe ri Pedro, ri Jacobo, ri Juan y ri rute-rutata' ri xten ri xe'oc-apu. ");
INSERT INTO cak_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel nicok'ej y niquibisoj ri xten. Pero ri Jesús xu'ij chique: Man chic quixok', rija' man caminak ta, xa niver, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero rije' xa xetze'en chirij ri Jesús, roma queteman chi ri xten kitzij chi caminak chic. ");
INSERT INTO cak_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jac'a ri Jesús (xutz'om, xuchop) apu ruk'a' ri ámna, y xu'ij che: Nóya, cacataj. ");
INSERT INTO cak_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jac'ari' xtzolij-pe ránima ri xten, y xcataj-pe. Y ri Jesús xu'ij chi titzuk. ");
INSERT INTO cak_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ri te'ej-tata'aj xa satznak quic'u'x, jac'a ri Jesús xu'ij chique chi man tiquitzijoj ri xbanataj chiri'. ");
INSERT INTO cak_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeroyoj ri doce ru-discípulos, y xuya-e uchuk'a' pa quik'a' y xu'on-e chique chi c'o quik'a' chi yequelesaj conojel itzel tak espíritu y yabil. ");
INSERT INTO cak_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xerutak richin niquiya' rutzijol ri achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar, y richin niqui'en chique ri yeyavej chi yec'achoj. ");
INSERT INTO cak_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y xu'ij-e chique: Man jun achique tic'uaj richin ri ibey. Man tic'uaj ch'ami'y, ni morral, ni pan, ni méra, nis-ta jun chic solaj itziak. ");
INSERT INTO cak_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Xa achique na jay yixoc-vi, chiri' quixc'uje-vi, c'a ja tok xquixel-pe chupan ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ri ajani man xtiquic'ul ta ivech, tok yixel-pe chupan ri tinamit ri', (tiquiraj, titota') can ri pokolaj chi tak ivakan chiquivech, richin tiquina'ej chi can man utz ta ri xqui'en, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jac'ari' chi jujun chi jujun ri aldeas xebe-vi ri discípulos chutzijosic ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak, y xa achique na lugar yek'ax-vi, yequic'achojrisaj can ri yeyavej. ");
INSERT INTO cak_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri Herodes ri nibano gobernar ri rucaj parte richin ri roch'ulef ri c'o-vi, xrac'axaj ronojel ri yerubanala' ri Jesús. Pero man nril ta achique nunimaj, roma ec'o ye'in chi ri Jesús ja ri Juan ri Bautista ri xc'astaj chic pe chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ec'o ye'in chi ja ri Elías ri xuruc'utu-ri'. Ec'o ye'in chi jun chique ri profetas ri xec'uje' ojer can xc'astaj-pe. ");
INSERT INTO cak_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Jac'a ri Herodes nu'ij: Mana-ta ri Juan ri Bautista, roma yin mismo xi'in chi xcumix-e (rujolon, ruvi'). Pero, ¿achique c'a chi achi ri yerubanala' ri achel ninvac'axaj? nicha'. Y nutij ruk'ij richin nrojo' nutz'et ruvech. ");
INSERT INTO cak_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Tok xetzolij-pe ri apóstoles, xquitzijoj che ri Jesús ri ajani xequibana'. Y ri Jesús xeruc'uaj-e quiyon pa jun lugar manak vinak richin ri tinamit Betsaida. ");
INSERT INTO cak_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jac'a ri vinak tok xequina'ej, xebe richin xe'equila', y ri Jesús jabel xuc'ul quivech, xutzijoj chique ri achique ruchojmil ye'oc pa ruk'a' ri Dios richin yeru'on gobernar; y xu'on chi xec'achoj ri nic'atzin quito'ic chuvech yabil. ");
INSERT INTO cak_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jac'a tok xk'ak'ij-ka, ri doce apóstoles xejel-apu riq'uin ri Jesús y xqui'ij che: Más utz que'ataka-e ri vinak pa tak aldeas y pa tak lugares ri ec'o-pe nakaj, richin nequicanoj achique niquitij y achique lugar ye'ever-vi. Roma vave' man jun vinak, xecha' che. ");
INSERT INTO cak_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jac'a ri Jesús xu'ij chique ri ru-discípulos: Rix quixtzuku quichin, xcha'. Jac'a rije' xqui'ij: Xe oc vo'o' pan y ca'i' quer c'o kiq'uin. Xaxe si nku'e chulok'ic ri achique xtikaya' chique conojel richin yekatzuk, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Quiri' xqui'ij roma ec'o cami vo'o' mil achi'a' chiri'. Jac'a ri Jesús xu'ij chique ri ru-discípulos: Tibana' chique chi quetz'uye' chi nic'aj tak ciento, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y can quiri' vi xqui'en ri discípulos chique conojel. ");
INSERT INTO cak_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jari' tok ri Jesús xeruli'ej ri vo'o' pan y ri ca'i' quer, xtzu'un c'a e chicaj, xumatioxij che ri Dios, xeruper c'a ri pan y ri quer, y xuya-e chique ri ru-discípulos richin xquijach chiquivech ri etz'uyul chiri'. ");
INSERT INTO cak_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Xeva' c'a conojel y jabel xnoj quipan. Xemol c'a ri ruchi' tak pan y ri quer ri man xq'uis ta, y c'a xu'on na doce chaquech. ");
INSERT INTO cak_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","C'o jun k'ij ri Jesús nu'on orar pa jun lugar manak vinak, y ec'o-apu ri ru-discípulos riq'uin. Rija' quire' c'a xuc'utuj chique: ¿(Yin achique, ayincu'x) yin niquinojij ri vinak? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rije' xqui'ij: Ec'o ye'in chi ja rat ri Juan ri Bautista. Ec'o ye'in chi ja rat ri profeta Elías. Y ec'o ye'in chi rat jun chique ri ojer tak profetas ri xac'astaj-pe chiquicojol ri anima'i', xecha' ri discípulos. ");
INSERT INTO cak_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jac'a chique rije' xuc'utuj: Jac'a chivech rix, ¿(yin achique, ayincu'x) yin? xcha'. Y ri Pedro xu'ij-apu: Ja rat ri Jun ri rat richin ri Dios ri rat takon-pe chucolic ri rutinamit, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jac'a ri Jesús cof-cof xerupaxa'aj ri ru-discípulos chi nis-ta jun achok che tiquitzijoj-vi. ");
INSERT INTO cak_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Quire' xu'ij chique: Can nic'atzin na vi chi yin ri xitak-pe richin xinalex chi'icojol, yik'ax chupan q'uiy k'axomal. Itzel xquitz'et coma ri nima'k quijuna' achi'a' c'o quik'ij, coma ri nima'k tak quik'ij sacerdotes israelitas, y coma ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés. Xquicamises, pero chi rox k'ij xquic'asos-pe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jac'ari' quire' xu'ij chique conojel: Si c'o jun nrojo' yirutzekle'ej, tuya' can juc'an ri nurayij rija', k'ij-k'ij man tupokonaj nuk'asaj c'ayef voma yin, masque necamises, y quirutzekle'ej. ");
INSERT INTO cak_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roma xa achique na ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ruc'aslen voma yin, can xtril-vi. ");
INSERT INTO cak_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Roma, ¿achique utz nuq'uen-pe che jun vinak si nic'uje' ronojel beyomal richin ri roch'ulef riq'uin, y xa ruyon nusetz-ka-ri', o xa ruyon nuya-apu-ri' chupan ri camic ri richin jumul? ");
INSERT INTO cak_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Roma ri xa xtiq'uix xtu'ij chi yin runiman yin y ri nuch'abel, yin ri xitak-pe richin xinalex chi'icojol xquiq'uix xtin-ij chi ri jun ri' vichin yin chupan ri k'ij tok xquipe chic jun bey riq'uin nimalaj nuk'ij, riq'uin ruk'ij ri Nata' y riq'uin quik'ij ri lok'olaj ángeles. ");
INSERT INTO cak_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kitzij c'a nin-ij chive chi ec'o jujun chive ri rixc'o vave' vacami ri man jani (quecom, quequen) chiri', tok xtiquitz'et ri ru-gobierno ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jun cami vakxaki' k'ij tik'ax chi ri Jesús xch'o chiquivech ri vinak, jari' tok rija' xeruc'uaj ri Pedro, ri Juan y ri Jacobo chuvech jun juyu' richin nerubana' orar. ");
INSERT INTO cak_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jac'a tok nu'on orar chiri', xjalataj ri (ruvech, rupalaj), ri rutziak sak-sak xu'on y nitz'intz'ot. ");
INSERT INTO cak_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","C'ate xquitz'et, yetzijon yan chic ca'i' achi'a' riq'uin, y ri' ja ri Moisés y ri Elías. ");
INSERT INTO cak_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Pa jun lok'olaj sakil ec'o-vi ri ca'i' re', y yetzijon chirij ri camic ri xtuk'asaj ri Jesús pa Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jac'a ri Pedro y ri ca'i' chic discípulos jani na ruchuk'a' quivaran, pero tok xetzu'un-pe utz-utz, xquitz'et ri nimalaj rusakil ri Jesús, y xequitz'et ri ca'i' achi'a' epa'el riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ja yebe ri ca'i' achi'a' chiri', ri Pedro xu'ij-apu che ri Jesús: Tijonel, utz ri rojc'o vave', tikabana' oxi' tak jay, jun avichin rat, jun richin ri Moisés y jun richin ri Elías, xcha'. Runojin man runojin quiri' xu'ij-apu. ");
INSERT INTO cak_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","C'a quiri' na nich'o-apu ri Pedro, tok jari' xerumuk jun sutz', y ri discípulos xquixi'ij-qui' tok xka ri sutz' pa quivi'. ");
INSERT INTO cak_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","C'o c'a Jun xch'o-pe chupan ri sutz' y xu'ij: Jare' ri Nuc'ajol, y yin can ninjo'. Tinimaj ri rutzij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tok xtane' ri ch'abel ri', ri discípulos xquitz'et chi xa ruyon chic ri Jesús c'o. Y rije' xquiyec pa cánima ri xquitz'et; man jun achok che xquitzijoj-vi chupan tak ri k'ij ri'. ");
INSERT INTO cak_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chuca'n k'ij, tok ri Jesús y ri oxi' ru-discípulos xeka-pe ri pa juyu', man juba' ta oc vinak xec'ulu-apu richin, ");
INSERT INTO cak_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","y chiquicojol c'o jun achi nisiq'uin xu'ij-apu che ri Jesús: Tijonel, tabana' favor, te'atz'eta' juba' ri valc'ua'l, roma juney oc c'o viq'uin. ");
INSERT INTO cak_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rija' c'o jun itzel espíritu (nitz'amo, nichapon) richin, c'ate retal nu'on che chi nisiq'uin-pe, nuquiyica' riq'uin ruchuk'a', y nu'on chi nivokon pa ruchi'. Mulan chic ruk'a-rakan ri nuc'ajol, c'arunaj nuya' can. ");
INSERT INTO cak_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yin xinc'utuj quemelal chique la a-discípulos chi tiquelesaj ri itzel espíritu riq'uin, pero man xetiquer ta, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jac'ari' quire' xu'ij ri Jesús: ¡Oh rix vinak ri rixc'o vacami! Nis-ta jun chive ri can ta cukul ruc'u'x riq'uin ri Dios, xa chi'ivonojel rix satznak. ¿Rix ninojij chi yin jumul yic'uje' iviq'uin richin yixincoch'? Tac'ama-pe ri ac'ajol vave', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ja nijel-apu ri ala' riq'uin ri Jesús chiri', tok ri itzel espíritu xutorij pan ulef, xuquiyica' riq'uin ruchuk'a'. Jac'a ri Jesús xuch'olij ri itzel espíritu, xuc'achojrisaj ri ala', y xujach-e che ri rutata'. ");
INSERT INTO cak_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chiconojel can achique na xquina' tok xquitz'et ri nimalaj ruchuk'a' ri Dios. C'a quiri' na benak cánima conojel chirij ronojel ri yerubanala' ri Jesús, tok rija' xu'ij chique ri ru-discípulos: ");
INSERT INTO cak_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tibana' che ri ch'abel re' chi ntoc pan ixiquin roma xtibanataj chi yin ri xitak-pe richin xinalex chi'icojol, xquijach pa quik'a' vinak, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jac'a ri discípulos man (nik'ax, nino') ta chiquivech ri najin chubixic ri Jesús, roma ri nu'ij, achel evan can rij chiquivech, y xa niquixi'ij-qui' niquic'utuj-apu ruchojmil che. ");
INSERT INTO cak_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jac'ari' tok ri discípulos niquichok'omayila' chiquivech ri achique chique rije' ri más xtic'uje' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jac'a ri Jesús xa reteman ri achique niquibila' pa tak cánima, romari' xeruc'ama-pe jun ch'uti ac'ual, xupaba-apu riq'uin, ");
INSERT INTO cak_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","y xu'ij chique: Xa achique na ri pa nubi' yin nuc'ul ruvech jun ac'ual achel re', junan nu'ij chi ja yin ri nuc'ul nuvech. Y xa achique na ri yiruc'ul pa ránima, junan nu'ij chi ja ri takayon-pe vichin ri nuc'ul. Roma ri más manak oc ruk'ij nu'on chi'icojol rix, jari' ri más c'o ruk'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ri Juan xu'ij c'a apu che ri Jesús: Tijonel, roj c'o jun katz'eton can chi pan abi' rat yerelesaj itzel tak espíritu. Pero roma man petenak ta chikacojol richin ta junan rat katzekle'en, xka'ij che chi man chic tu'on quiri', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jac'a ri Jesús xu'ij che ri Juan: Man tik'at chuvech, roma xa achique na ri man nicataj ta chikij, xa junan ránima kiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Tok ja nril ruk'ijul chi ri Jesús nitzolij-e chicaj, rija' xa jun xu'on che ri ránima richin xbe pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y ec'o achi'a' xerutak-e na'ey chuvech. Ri ebenak xe'oc pa jun aldea quichin ri aj pa departamento Samaria richin xequibana' rubanic ronojel ri xtic'atzin che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri aj chiri' man xcajo' ta xquic'ul ruvech ri Jesús, roma rija' can k'alaj chi pa Jerusalem benak-vi. ");
INSERT INTO cak_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tok ri ca'i' discípulos Jacobo y Juan xquitz'et chi ri vinak man xcajo' ta xquic'ul ruvech ri Jesús, quire' xqui'ij: Ajaf, ¿najo' chi nika'an chi tika-pe k'ak' chicaj, achel xu'on ri profeta Elías ojer can, richin yeruq'uis ri vinak re'? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Xtzu'un c'a can ri Jesús chirij, xeruch'olij, y xu'ij chique: Rix man iveteman ta achique Espíritu uc'uayon ivichin. ");
INSERT INTO cak_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Roma yin ri xitak-pe richin xinalex chi'icojol, man yin petenak ta chiquicamisasic vinak, xa richin yencol chupan ri quimac, xcha'. Jac'ari' junan quiq'uin ri ru-discípulos xebe chic pa jun aldea. ");
INSERT INTO cak_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Tok ebenak pa bey, c'o jun xquic'ul ri quire' xu'ij che ri Jesús: Ajaf, yin yatintzekle'ej xa achique na lugar yabe-vi. ");
INSERT INTO cak_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero ri Jesús xu'ij che: Ri xivan c'o quijul yec'uje-vi, y ri chicop yeropop pa cak'ik' c'o quisoc. Jac'a yin ri xitak-pe richin xinalex chi'icojol, man jun lugar richin yinuxlan-vi juba', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jac'a che chic jun xu'ij: Quinatzekle'ej, xcha'. Pero ri jun ri' quire' xu'ij che ri Jesús: Ajaf, taya' na c'a lugar chuve chi ninmuk na can ri nata' na'ey, c'ajari' xcatintzekle'ej, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jac'a ri Jesús xu'ij che: Ri ecaminak chupan ri quimac, ja rije' quemuku ri qui'anima'i'. Jac'a rat, cabin, tatzijoj chi naj chi nakaj ri achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar. ");
INSERT INTO cak_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","(Chuka', ka) c'o chic jun ri quire' xu'ij: Yatintzekle'ej, Ajaf, pero na'ey taya' lugar chuve chi yinech'o na can chique ri ec'o viq'uin chivacho, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jac'a ri Jesús xu'ij che: Nis-ta jun ri nisamajin ri arado, y nitzu'un can chirij, choj ntel ri rusamaj. Quiri' mismo ri nrojo' nu'on samaj richin ru-gobierno ri Ajaf Dios, si c'a benak na ránima pa ruvi' ri roch'ulef, manak che'el nu'on ri samaj ri', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tok xbanataj yan ronojel re', ri Ajaf Jesús xerucha' chic setenta discípulos richin yenabeyaj chuvech, y chi caca' xerutak ri pa tak tinamit y ri pa tak lugares ri xtik'ax-vi rija'. ");
INSERT INTO cak_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y quire' c'a xu'ij-e chique: Kitzij nin-ij chive chi ri vinak e'achel jun mama li'aj tico'n ri utz chic nimol ruvech, pero ri yemolo man eq'uiy ta. Roma c'a ri', tic'utuj che Rajaf ri samaj chi querutaka-pe más rusamajela' pa rutico'n. ");
INSERT INTO cak_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Quixbin c'a, vacami yin yixintak-e rix ri rix achel ch'utik ovejas chiquicojol vinak ri e'achel utuva'. ");
INSERT INTO cak_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pero man tic'uaj méra, nis-ta morral, nis-ta jun chic par xajab. Ni man quixpataj pa tak bey richin ye'iben saludar vinak. ");
INSERT INTO cak_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Xa achique na jay ri yixoc-vi, na'ey quire' ti'ij chique ri ec'o chiri': Ri uxlanen richin ri Dios tic'uje' iviq'uin chupan ri jay re', quixcha'. ");
INSERT INTO cak_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y si chupan ri jay ri', c'o jun c'o uxlanen pa ránima, ri uxlanen ri (ic'uan, ivuc'a'n) apu rix xtika pa ruvi' ri nic'ulu ivech. Pero si nis-ta jun c'o uxlanen pa ránima, ri uxlanen man xtika ta can pa quivi', xa xtitzolij chic pe iviq'uin. ");
INSERT INTO cak_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ri jay ri utz nic'ul-vi ivech, chiri' quixc'uje-vi. Titija' y tikumu' ri xtiquisipaj chive. Roma jun samajinel can utz vi chi nitoj roma ri samaj ri nu'on. Man tijalala' ri jay ri yixc'uje-vi. ");
INSERT INTO cak_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Xa achique na tinamit yixoc-vi, si utz nic'ul ivech, rix titija' ronojel ri niquisipaj chive. ");
INSERT INTO cak_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ri yeyavej ri ec'o chiri', tibana' chique chi yec'achoj can, y quire' ti'ij can chique conojel: Nakaj chic c'o-vi chi c'o che'el yixoc pa ruk'a' ri Dios richin yixru'on gobernar, quixcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero xa achique na tinamit yixoc-vi, si man nic'ul ta ivech, quixel pa tak bey richin ri tinamit y quire' ti'ij can chique ri vinak: ");
INSERT INTO cak_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hasta ri pokolaj richin ri itinamit ri c'o-e chikakan, (nikaquiraj, nikatota') can chivech, richin retal chi can man utz ta ri xi'en. Pero tivetemaj c'a chi nakaj xc'uje-vi chive chi c'o che'el xixoc pa ruk'a' ri Dios richin xixru'on gobernar, quixcha' can chique. ");
INSERT INTO cak_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jac'a yin nin-ij chive chi tok xtuka ri k'ij richin ri castigo, más q'uiy castigo xtika pa quivi' ri tinamit ri man niquic'ul ta ivech, que chuvech ri xtika pa quivi' ri aj-Sodoma, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jac'a ri Jesús quire' xu'ij chiquij jujun tinamit: Ninvok'ej ivech rix aj-Corazín, y rix aj-Betsaida, roma xa ta ja ri pa tinamit Tiro y pa tinamit Sidón xe'an-vi ri milagros ri xe'an chivech rix, rije' xquijal yan ta quino'oj, xquiya' yan ta can ri quimac, etz'uyul ta chic quicusalo'n quitziak richin bis, y quiyalo'n ta chic chaj chiquij, richin nik'alajin chi yebison roma ri mac quibanalo'n. ");
INSERT INTO cak_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Roma c'a ri', tok xtinic'ox ronojel ch'utik-nima'k, ja rix aj-Corazín y rix aj-Betsaida ri más q'uiy castigo xtika pan ivi', que chuvech ri xtika pa quivi' ri aj-Tiro y ri aj-Sidón. ");
INSERT INTO cak_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y rix aj-Capernaum ri ninojij chi xquixjoto'ex chicaj, xa c'a chupan ri lugar quichin ri anima'i' xquixkases-vi-ka. ");
INSERT INTO cak_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jac'ari' tok ri Jesús quire' chic xu'ij chique ri setenta ri yerutak: Xa achique na jun ri utz nrac'axaj ri ruch'abel ri Dios ri nitzijoj rix, ja yin yirac'axaj. Jac'a ri man nrojo' ta nrac'axaj ri nitzijoj rix, ja yin ri man nrojo' ta yirac'axaj. Y ri man nrojo' ta yirac'axaj yin, man nrojo' ta nrac'axaj ri takayon-pe vichin. Quiri' ri xu'ij-e ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Yequicot c'a xetzolij-pe ri setenta riq'uin ri Jesús, y xqui'ij che: Ajaf, hasta ri itzel tak espíritu xquinimaj tzij tok pan abi' xojch'o chique, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xu'ij chique: Ja', roma yin xintz'et chi ri Satanás xtzak-pe chicaj achel jun rayo. ");
INSERT INTO cak_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tivac'axaj c'a: Yin nuyo'on uchuk'a' pan ik'a' richin ye'ipatz cumatz y (sina'j, alacrán) che akan, y richin yixtiquer chirij ruchuk'a' ri itzel, y man jun xquetiquer xtiqui'en chive. ");
INSERT INTO cak_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero rix man quixquicot roma ri itzel tak espíritu yixquinimaj, xa quixquicot chi ri ibi' tz'iban chila' chicaj. ");
INSERT INTO cak_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Chupan ri hora ri', ri Lok'olaj Espíritu xu'on che ri Jesús chi xquicot pa ránima, romari' xu'ij: Ninya' ak'ij, Nata' Dios, rat ri Rajaf ri caj y ri roch'ulef, roma man xak'alajrisaj ta ruchojmil ri ach'abel chiquivech ri niquina' chi q'uiy queteman y can c'o quino'oj. Xa ja chiquivech ri achel ac'ola' quibanon che ri cánima xak'alajrisaj-vi. Can quiri' vi, Nata' Dios, roma jari' ri xka chavech chi xa'an. Quiri' ri xu'ij ri Jesús pa ru-oración. ");
INSERT INTO cak_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y xu'ij: Ri Nata' Dios ronojel ruyo'on-pe pa nuk'a', y man jun etemayon (yin achique, ayincu'x) yin, xaxe ri Nata'. Nis-ta man jun etemayon (achique, acu'x) ri Nata', xaxe yin ri Ruc'ajol, y ri achok che xtinjo' xtink'alajrisaj-vi. ");
INSERT INTO cak_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Jac'ari' xtzu'un-apu quiq'uin ri ru-discípulos y quire' xu'ij chique quiyon: Utzulaj tzij rubanon ri Dios chique ri yetz'eto riq'uin quivech ri yixtajin chutz'etic rix. ");
INSERT INTO cak_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Roma yin nin-ij chive chi q'uiy profetas y q'uiy reyes ojer ri xcajo' xquitz'et ri nitz'et rix vacami, y man xquitz'et ta e. Xcajo' xquic'axaj ri nivac'axaj rix vacami, y man xquic'axaj ta e, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Xcataj c'a apu jun achi q'uiy reteman chirij ri ley ri xyo'ox che ri Moisés y richin nrojo' nretemaj ajani reteman ri Jesús, quire' xuc'utuj-apu che: Tijonel, ¿Achique ri nic'atzin nin-en yin richin ninvil ri c'aslen ri richin jumul? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús quire' xu'ij che: ¿Achique tz'iban can chupan ri ley ri xuya' ri Dios che ri Moisés? ¿Achique navetemaj rat tok na'an leer? ");
INSERT INTO cak_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Quire' c'a xu'ij ri achi che ri Jesús: Ri ley nu'ij chi tajo' ri Ajaf ri a-Dios riq'uin ronojel avánima, riq'uin ronojel ac'aslen, riq'uin ronojel avuchuk'a', y riq'uin ronojel ano'oj, y achel najo-ka-avi' rat, quiri' mismo que'ajo' conojel. ");
INSERT INTO cak_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Can pa ruchojmil ri xa'ij. Vacami c'a, tabana' achel ri xa'ij y navil ri c'aslen ri richin jumul, xcha' ri Jesús che. ");
INSERT INTO cak_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ri achi q'uiy reteman chirij ri ley can xrojo' utz nik'alajin chuvech ri Jesús riq'uin ri yerubila', romari' xuc'utuj chic apu che: Y, ¿(achique, acu'x) c'a ri' ri utz chi ninjo' achel ninjo-ka-vi' yin? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Quire' c'a rutzolic rutzij xu'on ri Jesús: C'o jun achi elenak-pe pa tinamit Jerusalem richin ni'e-ka pa tinamit Jericó. Pero pa bey xe'el-pe elek'oma' chirij, xquich'ey, xquisoc, y hasta ri rutziak rucusan xquelek'aj-e, c'ajari' xebe. Jac'a ri achi achel caminak xpoq'ue' can chiri' pa bey. ");
INSERT INTO cak_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ja yan chic ri' xulan-ka jun sacerdote israelita chupan ri bey ri poc'ol-vi ri achi, y tok xutz'et, xa xujech'aj-apu-ri' ri juc'an ruchi' bey richin xk'ax. ");
INSERT INTO cak_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Quiri' mismo xu'on jun achi levita tok xk'ax chunakaj ri achi poc'ol pa bey. Xe xutz'et, xa ja ri jun chic apu ruchi' bey xk'ax-vi. ");
INSERT INTO cak_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o c'a jun achi aj pa departamento Samaria xk'ax chiri', y tok xk'ax chunakaj, xsilon ri ránima richin xupokonaj ruvech ri achi tok xutz'et chi poc'ol chiri' pa bey. ");
INSERT INTO cak_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xjel c'a apu riq'uin, xerok'omaj ri rusocotajic riq'uin aceite y vino, xerupisla' riq'uin tziek. Jac'ari' xuya-e chirij ri ruquiej, xuq'uen-pe pa jun posada, y xuchajij. ");
INSERT INTO cak_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chuca'n k'ij, ri achi aj-Samaria xrelesaj méra richin rajil ca'i' k'ij samaj, y jari' xuya' can che rajaf ri posada, y xu'ij can che: Ja yi'e yin, pero ninjo' chi nachajij ri jun achi re'. Ri ajani más méra xtacusaj richin navok'omaj, yin xtintoj chave tok xquitzolij-pe. ");
INSERT INTO cak_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Vacami c'a ta'ij chuve: ¿Achique chique ri oxi' achi'a' re' ri xuc'ut-ri' chi kitzij yerojo' conojel, riq'uin ri xu'on riq'uin ri xka pa quik'a' elek'oma'? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Yin nin-ij chi ja ri xpokonan ruvech ri ch'eyon can, xcha' ri achi. Y ri Jesús xu'ij che: Vacami c'a, cabin y tabana' achel xu'on ri jun ri', xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tok ri Jesús y ri ru-discípulos ebenak chupan ri bey, xe'oc-apu pa jun aldea. Chiri' c'o jun ixok rubinan Marta, ri xc'ulu-apu richin ri Jesús pa racho. ");
INSERT INTO cak_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri Marta re' quichak'-quinimal qui' riq'uin jun chic ixok rubinan María, y ri María re' chirakan ri Jesús xtz'uye-vi-apu, richin nrac'axaj ri nutzijoj. ");
INSERT INTO cak_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jac'a ri Marta xa chirij ri samaj pa jay nich'ujyej-vi. Roma c'a ri', xjel-apu riq'uin ri Jesús y xu'ij che: Ajaf, ¿utz cami chave rat chi ri María nuyon yin ruyo'on can chuvech ri samaj? Ta'ij juba' che chi quiruto', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jac'a ri Ajaf Jesús xu'ij che: Marta, Marta, rat xa ayon nach'ujirisaj-avi', y xa pa ruvi' ri jalajoj samaj ri c'o chavech benak-vi ri avánima. ");
INSERT INTO cak_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xaxe jun ri más nic'atzin y más utz, y jari' ri xucha' ri María. Y ri xucha' rija', man xteleses ta che, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","C'o c'a jun k'ij ri Jesús nu'on orar pa jun lugar, y tok xtane' riq'uin ri oración, jun chique ri ru-discípulos xu'ij che: Ajaf, kojatijoj riq'uin ri oración, achel xu'on ri Juan ri Bautista quiq'uin ri ru-discípulos, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Quire' c'a xu'ij ri Jesús chique: Tok xti'en orar, quire' ti'ij: Katata' Dios ri ratc'o chicaj, Xtinimirises ta c'a ri lok'olaj abi', Can ta nic'uje' yan ruchuk'a' ri a-gobierno pa quivi' conojel, Y achel yanimex ri chicaj, can ta quiri' mismo choch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ri kavay ri nic'atzin k'ij-k'ij, ja jun ri vacami taya' chike. ");
INSERT INTO cak_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y tabana' perdonar ri kamac, roma ja jun roj yeka'an perdonar conojel ri yebano mac chike. Man kojaya' richin chi nicanox chikij chi nkuka pa mac, xa kojacolo' chuvech ri itzel. Quiri' ti'ij tok ni'en orar, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y pa ruvi' ri', quire' xu'ij chique: Xa ta jun chive rix ni'e chiracho jun ru-amigo pa nic'aj ak'a', y nu'ij che: Amigo, tabana' favor, ninjal oxi' panes chave. ");
INSERT INTO cak_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Roma c'o jun nu-amigo petenak naj xuka viq'uin, y yin man jun achique c'o viq'uin richin ninya' che; xa ta quiri' neru'ij che, ");
INSERT INTO cak_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","y si ri achok che nic'utux-vi-apu ri pan, c'a pa ruch'at nich'o-vi-pe y nu'ij-pe: Tabana' favor, man quinanak, roma yin xintz'apij yan can ruchi' ri jay y ri ac'ola' viq'uin yever-vi, romari' manak che'el yicataj-e richin nenya-e chave ri najo', nicha' ta pe. ");
INSERT INTO cak_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Xa ta quiri' nibanataj, yin nin-ij chi ri amigo nicataj-pe y nuruya-e ri achique nic'utux-apu che, pero man roma ta chi amigo. Rija' nuruya-e xaxe roma ri nic'utun-apu man nitane' ta ka chuc'utuxic. ");
INSERT INTO cak_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y yin nin-ij chive: Tic'utuj c'a ri nic'atzin, y xtiyo'ox-pe chive; ticanoj c'a ri achique nijo', y xtivil. Quixch'o-apu chuchi' ri jay, y can xtijak-vi-pe chivech. ");
INSERT INTO cak_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Roma xa achique na jun ri nic'utun, can nuc'ul-vi; ri nicanon, nril; y ri nich'o-apu chuchi' jay, can nijak-vi-pe chuvech. ");
INSERT INTO cak_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Achel ri rix tata'aj, ¿achique ta jun chive nuya' jun abaj pa ruk'a' ri ralc'ua'l, tok ri ac'ual xa jun pan nuc'utuj? ¿O nuya' cami jun cumatz pa ruk'a', tok ri ac'ual xa jun quer nuc'utuj? ");
INSERT INTO cak_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O nuya' cami jun (sina'j, alacrán) pa ruk'a', tok ri ac'ual xa jun sakmalo' nuc'utuj? ");
INSERT INTO cak_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rix masque man can ta utz ino'oj, pero iveteman niya' utz tak sipanic chique ri ivalc'ua'l. ¡Cuánto más ri Itata' chicaj! Rija' can nuya-vi-pe ri Lok'olaj Espíritu chique ri yec'utun che, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","C'o c'a jun k'ij ri Jesús nrelesaj jun itzel espíritu ri mem rubanon che ri vinak achok riq'uin ocunak-vi. Tok elenak chic e ri itzel espíritu, ri mem xtiquer xch'o, y ri xetz'eto, can achique na xquina'. ");
INSERT INTO cak_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero ec'o chique ri xetz'eto ri niqui'ij: Re Jesús ja ri Beelzebú ri cajaf ri itzel tak espíritu niyo'on ruchuk'a' richin yerelesaj itzel tak espíritu, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ec'o chic ch'aka' xaxe roma nicajo' chi nika ri Jesús pa quik'a' xqui'ij che chi tubana' jun milagro chuvech ri rocaj. ");
INSERT INTO cak_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús reteman ri niquinojij chirij, y romari' xu'ij chique: Xa achique na jun rey ri xa nicataj chiquij ri mismo ruvinak, man juba' xtilayoj chi rey. Quiri' mismo pa jun jay, si ri rajaf niquibanala-ka oyoval chiquivech, xa xtijachataj-e quivech. ");
INSERT INTO cak_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y quiri' mismo ri Satanás, si nicataj chiquij ri rusamajela', man juba' xtilayoj ri ru-gobierno. Quiri' nin-ij chive roma rix ni'ij chi yin riq'uin ruchuk'a' ri Beelzebú yenvelesaj itzel tak espíritu. ");
INSERT INTO cak_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Si rix ninojij chi yin riq'uin ruchuk'a' ri Beelzebú yenvelesaj-vi itzel tak espíritu, ¿achique niyo'on cuchuk'a' ri yetzekle'en ivichin rix chi yequelesaj itzel tak espíritu? Romari', ja rije' que'in si kitzij o man kitzij ta ri yixtajin chubixic chuvij. ");
INSERT INTO cak_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jac'a si yin riq'uin ruchuk'a' ri Dios yenvelesaj-vi itzel tak espíritu, jari' retal chi ri ru-gobierno ri Dios c'o chic chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jun achi ri can c'o ruchuk'a', man jun ntoc che ronojel ri c'o riq'uin, tok nuchajij ri racho chiquivech ri elek'oma', y can c'o riq'uin ri achok chique nuto-vi-ri'. ");
INSERT INTO cak_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tok nuka chic jun ri más c'o ruchuk'a' que chuvech rija', jari' nitiquer chirij. Ri jun ri nuka nrelesaj che ronojel ri achok riq'uin cukul-vi ruc'u'x richin nuto-ri', y nujachala' ri ajani xrelek'aj-e chiquivech ri (rachbil, rach'il). ");
INSERT INTO cak_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jun ri man nika ta chuvech ri nin-en yin, xa itzel yirutz'et, y ri man nimolon ta junan viq'uin, xa niquiran-e. ");
INSERT INTO cak_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tok jun itzel espíritu ntel-e pa ránima jun vinak, ri espíritu re' nixule-nijote' chucanoxic uxlanen pa chaki'j tak lugar, pero roma man nril ta, rija' quire' nu'ij-ka: Más utz yitzolij chic pa ránima ri vinak ri xinel-vi-pe, nicha'. ");
INSERT INTO cak_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tok nitzolij, nril ránima ri vinak achel jun jay jabel meson y nuc'un can ronojel. ");
INSERT INTO cak_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Jac'ari' ni'e y ye'eruc'ama' vuku' chic itzel tak espíritu más e'itzel chuvech rija'. Conojel c'a ye'oc pa ránima ri vinak y niqui'en-ka cacho chiri', y ri ruc'aslen ri vinak ri' más c'ayef nu'on que chuvech ri rubanon na'ey. ");
INSERT INTO cak_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Tok ri Jesús najin chubixic re', c'o jun ixok xsiq'uin-pe chiquicojol ri vinak ri quimolon-qui', y xu'ij: Utzulaj tzij rubanon ri Dios che ri te'ej ri xalan avichin y ri tz'un ri xatz'umaj, xcha-apu che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jac'a ri Jesús xu'ij: Más utzulaj tzij rubanon ri Dios chique ri ye'ac'axan ri ruch'abel y niqui'en ronojel ri nu'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tok más chic eq'uiy quimolon-apu-qui' chirij ri Jesús, rija' xu'ij chique: Ri vinak richin ri vacami, itzel cánima, roma niquitij quik'ij niquic'utuj chi ti'an jun milagro chiquivech, pero mana-ta ri niquic'utuj rije' ri xtibanataj. Ri retal ri xtiquitz'et, xaxe ri achel xbanataj riq'uin ri profeta Jonás ojer can. ");
INSERT INTO cak_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Roma rija' xoc retal chiquivech ri aj-Nínive; quiri' mismo yin ri xitak-pe richin xinalex chi'icojol, yin retal chiquivech ri vinak erichin ri vacami. ");
INSERT INTO cak_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y tok xtinic'ox ronojel ch'utik-nima'k, xticataj-apu ri jun reina ri xu'on gobernar pa roch'ulef Sabá richin xtu'ij-apu chi tika castigo pa quivi' ri ec'o vacami. Roma ri reina ri', tok xc'ase' choch'ulef, chi naj xpe-vi richin xurac'axaj vave' pan Israel ri nimalaj no'oj yo'on che ri rey Salomón. Jac'a ri vacami yinc'o yin ri más c'o nuk'ij que chuvech ri rey Salomón, y man yinquinimaj ta ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y tok xtinic'ox ronojel ch'utik-nima'k, ri achi'a' aj-Nínive xquecataj-apu richin xtiqui'ij chi tika castigo pa quivi' ri vinak ri ec'o vacami. Roma ri xec'uje' pa tinamit Nínive ojer, xe xquic'axaj ruch'abel ri Dios ri xutzijoj ri Jonás, ja xquijal quino'oj y xquiya' can ri quimac. Jac'a ri vacami yinc'o yin ri más c'o nuk'ij que chuvech ri Jonás, y man yinquinimaj ta ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Man jun vinak nrevaj jun candil tzijon, nis-ta man nuya' ta apu chuxe' cajón, xa nuya' pa (ruc'ojle'el, ru-lugar), richin quiri' sak niquitz'et ri ye'oc-apu pa jay. ");
INSERT INTO cak_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Quiri' mismo ri runak'-avech yec'atzin chave achel nic'atzin ri candil. Tok ri avech ye'acusaj richin ri utz, ronojel ri a-cuerpo c'o pa sakil. Pero tok ri avech man ye'acusaj ta richin ri utz, ronojel ri a-cuerpo c'o pa k'eku'n. ");
INSERT INTO cak_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Roma c'a ri', tabana' cuenta ri ac'aslen, richin man tichup ri sakil ri ruyo'on ri Dios pan avánima, y xa ntoc chic k'eku'n jun bey. ");
INSERT INTO cak_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roma si ronojel ri ac'aslen c'o pa sakil, y man jun retal k'eku'n aviq'uin, ronojel jabel nik'alajin, achel tok tzijon jun candil ri nuya' ronojel chosakil chavech. ");
INSERT INTO cak_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Tok ri Jesús xtane' richin nich'o chiquivech ri vinak, jun chique ri achi'a' fariseos xu'ij che: Tabana' favor, jo' chuvij chivacho richin yateva' viq'uin, xcha'. Tok xoc-apu ri Jesús pa jay, xtz'uye-apu chuchi' mesa. ");
INSERT INTO cak_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Tok ri fariseo xutz'et chi ri Jesús man xu'on ta ka ri ch'ajoj-k'a' achel niqui'en rije', can achique na xuna'. ");
INSERT INTO cak_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jac'a ri Ajaf Jesús quire' xu'ij che: Rix fariseos rix achel jun vaso o jun lak ri jabel ch'ajch'oj rij, jac'a ri rupan xa ch'abak. Can nic'ut-ivi' chi rix choj riq'uin ri ni'en, jac'a ri pan ivánima, xa nojnak elak' y itzel tak no'oj. ");
INSERT INTO cak_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xa rix nacanak. ¿Man iveteman ta c'a chi ri xbano ri ka-cuerpo, jari' mismo xbano ri kánima? ");
INSERT INTO cak_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Que'ito' ri nic'atzin quito'ic, pero pan ivánima tel-vi-pe. Si quiri' xti'en, ronojel ch'ajch'oj xtu'on chivech. ");
INSERT INTO cak_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Jac'a rix fariseos, ¡tok'ex ivech! Roma hasta ronojel quivech ichaj achel ri alavina y ri ruda, nivajlaj cakan richin nivelesaj can diezmo riq'uin richin niya' che ri Dios. Pero iyo'on can juc'an chi nijo' ri Dios y chi rix choj quiq'uin ri vinak. Ja ta re' ri más utz chi ibanon-pe, y man tiya' can rubanic ri can yixtajin-vi riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Tok'ex ivech rix fariseos! Roma nika chivech yixtz'uye' ri pa na'ey tak ch'aquet ri pa tak sinagogas, y nika chivech chi yix-an saludar ri pa tak bey ri niquimol-vi-qui' ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley y rix fariseos ri xa ca'i' rupalaj ri yixtajin riq'uin! Roma xa rix achel quijul anima'i' ri man k'alaj ta chic pa ruvi' ulef, y ri vinak ri yek'ax chiri' nis-ta queteman chi xa pa quivi' anima'i' yek'ax-vi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jun c'a chique ri achi'a' q'uiy queteman chirij ri ley quire' xu'ij-apu che ri Jesús: Tijonel, tok rat na'ij quiri', man xe ta chic chique ri fariseos na'ij-vi, xa ja jun chike roj na'ij-vi. ");
INSERT INTO cak_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jac'a ri Jesús xu'ij che: Ja jun rix ri q'uiy iveteman chirij ri ley, ¡tok'ex ivech! Roma nibananej chiquitijoxic ri vinak; achel eka'n ri c'ayef ruc'uaxic ri ni'ij chique chi tiquic'uaj, jac'a rix man juba' ye'ito' chuc'uaxic ri eka'n ri'. ");
INSERT INTO cak_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Tok'ex ivech! Roma ye'ibanala' rubanic quivi' ri lugar ri emukul-vi ri profetas, y xa ja mismo ri ivati't-imama' xecamisan-e quichin. ");
INSERT INTO cak_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Riq'uin re' nik'alajin chi rix nika chivech ri itzel tak no'oj ri xequibanala' ri ivati't-imama' ojer, roma can kitzij vi chi ja rije' xecamisan-e ri profetas. Y rix vacami ye'ibanala' rubanic quivi' ri lugar ri emukul-vi ri profetas ri'. ");
INSERT INTO cak_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Roma c'a ri', ri Dios riq'uin nimalaj no'oj quire' ru'in chivij: Xquentak profetas y apóstoles quiq'uin. Pero ec'o chique ri xquentak ri xquequicamisaj, y ec'o xquequicanoj richin niqui'en pokon chique. Quiri' ri ru'in ri Dios chivij, ");
INSERT INTO cak_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","richin quiri', ja chive rix ri rixc'o vacami xtuc'utuj-vi rutojic quicamic conojel ri profetas ri ecamisan-e, xe tok x-an ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitiquer-pe riq'uin rucamic ri Abel, y hasta numaj rucamic ri profeta Zacarías ri xcamises chucojol ri altar y ri racho ri Dios. Kitzij nin-ij chive chi ja chive rix ri rixc'o vacami xtic'utux-vi rutojic quicamic ri erusamajela'. ");
INSERT INTO cak_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Tok'ex ivech rix ri q'uiy iveteman chirij ri ley! Roma man xiya' ta lugar chi ri vinak xquetemaj achique ruchojmil ye'oc pa ruk'a' ri Dios; rix mismo man xixoc ta, y ri xcajo' xe'oc, man xiya' ta lugar chique. ");
INSERT INTO cak_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tok ri Jesús xu'ij ronojel re', ri achi'a' q'uiy queteman chirij ri ley y ri achi'a' fariseos, xquitz'uc-apu ruc'otoxic jalajoj tak ch'abel che, richin chi q'uiy tubila' chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jalajoj niquic'utula-apu che ri Jesús, roma nicajo' chi can ta c'o jun tzij man pa ruchojmil ta ntel pa ruchi' richin niquisujuj. ");
INSERT INTO cak_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jari' ri najin chiri', tok chi miles vinak xquimol-apu-qui', hasta xaxe chic niquinimila-qui'. Jac'ari' tok ri Jesús na'ey chique ri ru-discípulos xch'o-vi y xu'ij: Tibana' cuenta ivi' rix chuvech ri qui-levadura ri fariseos, roma rije' xa ca'i' rupalaj ri yetajin riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Quiri' nin-ij chive, roma man jun ri banon che'elek'el ri man ta xtina'ex, ni man jun ri evan ri man ta xtitemetaj. ");
INSERT INTO cak_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Roma c'a ri', ronojel ri ibilo'n pa tak k'eku'n, xa xtel rutzijol chosakil. Y ronojel ri ijaslo'n pan ixiquin pa tak ivacho, xtisiq'uis rubixic pa ruvi' tak jay. ");
INSERT INTO cak_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jac'a chive rix ri rix (vachbil, vach'il) yin nin-ij: Man tixi'ij-ivi' chiquivech ri yecamisan ri cuerpo, y tok quicamisan chic, man jun chic achique xquetiquer xtiqui'en. ");
INSERT INTO cak_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero nin-ij chive ri achok chuvech nic'atzin chi nixi'ij-vi-ivi': Tixi'ij-ivi' chuvech ri Jun ri c'o ruk'a' richin nrelesaj ri aj-roch'ulef c'aslen, y tok relesan chic, c'o ruk'a' richin yixruc'ak pa k'ak'. Chuvech rija' tixi'ij-vi-ivi'. ");
INSERT INTO cak_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Rix iveteman chi vo'o' ch'utik tak ch'ip-ch'ip tok yec'ayix, xaxe oc ca'i-oxi' centavos cajil, pero nis-ta jun chique rije' mestan roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y rix hasta ri rusumal-ivi' ajlan ronojel; xa más c'o ivakale'n que chiquivech q'uiy ch'ip-ch'ip. Romari' man tixi'ij-ivi'. ");
INSERT INTO cak_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Yin nin-ij chive chi xa achique na jun ri can chiquivech vinak nu'ij-vi chi rija' vichin yin, yin ri xitak-pe richin xinalex chi'icojol, can chiquivech ri ru-ángeles ri Dios xtin-ij-vi chi ri jun ri' vichin yin. ");
INSERT INTO cak_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jac'a ri can chiquivech vinak xtu'ij-vi chi xa manak ru-cuenta chuve yin, quiri' mismo yin, can chiquivech ri ru-ángeles ri Dios xtin-ij-vi chi ri jun ri' manak nu-cuenta che. ");
INSERT INTO cak_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y xa achique na ri ni'in jun tzij chuvij yin ri xitak-pe richin xinalex chi'icojol, c'a ni'an na perdonar. Jac'a ri niyok'on ri Lok'olaj Espíritu, man c'a xti'an ta perdonar. ");
INSERT INTO cak_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Rix tok yixuc'uax pa tak sinagogas, o chiquivech ri yec'ojon vinak, o chiquivech ch'aka' chic autoridades, man tich'ujirisaj-ivi' riq'uin ri achique rubanic xquixch'o, nis-ta ri achique chi ch'abel xticusaj richin nito-ivi', o riq'uin ri achique nic'atzin chi ni'ij. ");
INSERT INTO cak_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roma ri Lok'olaj Espíritu ja hora ri' xtuya' ch'abel chive ri nic'atzin chi xti'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","C'o c'a jun chiquicojol ri quimolon-apu-qui' chiri' ri quire' xu'ij-apu che ri Jesús: Tijonel, tabana' favor, ta'ij che ri nunimal chi tikajacha' chikavech ri herencia ri rubanon-ka richin rija' che. ");
INSERT INTO cak_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ri Jesús xu'ij che: ¿Rix ninojij chi yin, yin c'ojoy ivichin y yin jachoy herencia chivech? ");
INSERT INTO cak_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jac'ari' chique conojel xu'ij-vi: Tibana' cuenta ri ic'aslen, man xa ti'e ivánima pa ruvi' méra. Roma jun vinak masque can q'uiy rubeyomal, pero ri beyomal man nitiquer ta nuya' ruc'aslen. ");
INSERT INTO cak_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jac'ari' xutzijoj jun ejemplo chique, y xu'ij: C'o jun beyon ri jani na tico'n nuya' ri rujuyu'. ");
INSERT INTO cak_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Romari' rija' quire' nunojij pa ránima: ¿Achique cami nin-en? Roma manak chic lugar chupan ri nuc'ujay richin ninyec-vi ronojel ri nu-cosecha. ");
INSERT INTO cak_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Pero quire' xtin-en: Xquenyoj ri cocoj tak nuc'ujay, xtin-en más chovon chique, y chupan ri' xtinyec-vi ronojel ri ninmol ruchi', y ronojel ri nuchajin. ");
INSERT INTO cak_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y xtin-ij che ri vánima: Vánima, vacami q'uiy beyomal ayacon richin q'uiy juna'. Caquicot, catuxlan, cava' y cakumun. Quiri' nunojij ri beyon pa ránima. ");
INSERT INTO cak_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios quire' xu'ij che: Nacanic, chupan ri ak'a' re' xtuc'amer ri avánima. Y ronojel ri amolon, ¿achique xtoc can rajaf? ");
INSERT INTO cak_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quiri' nibanataj riq'uin jun vinak ri numol beyomal richin ri roch'ulef, y xa manak ri beyomal ri petenak riq'uin ri Dios riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jac'ari' tok ri Jesús quire' xu'ij chique ri ru-discípulos: Man tich'ujirisaj-ivi' chunojixic ri achique nic'atzin chive k'ij-k'ij, ri achique lugar xtivil-vi ri achique nitij, nis-ta ri achique lugar xtiq'uen-vi itziak. ");
INSERT INTO cak_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Roma man xaxe ta ri achique nitij nic'atzin che ri ic'aslen, y man xaxe ta ri tziek nicusaj ri nic'atzin che ri i-cuerpo. ");
INSERT INTO cak_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tivelesaj na pe ejemplo chiquij ri ko'ch. Ri chicop re' manak tico'n niqui'en, manak rumolic ruvech tico'n niqui'en, ni manak jun jay richin quiyacon-vi ri achique niquitij, nis-ta c'o quic'ujay. Pero ri Dios can yerutzuk-vi. Y rix más c'o ivakale'n que chiquivech ri chicop ri'. ");
INSERT INTO cak_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Y man jun chive rix ri masque xtutij ruk'ij chunojixic, ri can ta xtitiquer xtunimirisaj chic juba' ri rupalen. ");
INSERT INTO cak_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Roma c'a ri', riq'uin ri man yixtiquer ta ni'en ri man can ta c'ayef, ¿achique roma nich'ujirisaj-ivi' chucanoxic ri más chic achique yec'atzin chive? ");
INSERT INTO cak_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tivelesaj na pe ejemplo chirij quiq'uiyilen ri cotz'i'j lirios. Rije' man yesamaj ta, ni man yequemon ta richin niquibanala-ka quitziak. Pero yin nin-ij chive chi nis-ta ri ojer rey Salomón, masque rija' jun nimalaj beyon, pero man xucusaj ta jun tziek ri can ta más jabel que chuvech rucotz'ijal jun lirio. ");
INSERT INTO cak_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ri Dios nu'on chique ri (k'ayis, k'os) pa tak juyu' chi jabel oc yetzu'un roma ri quicotz'ijal, y xa cha'anin yeporox pa k'ak'. Si ri Dios jabel yeruvik ri cotz'i'j, más quiri' xtu'on iviq'uin rix. Xa ja rix ri man can ta cukul ic'u'x riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Romari' man tisatz ivánima chucanoxic ri achique nitij, y achique nikum, ni man tich'ujirisaj ri ivánima. ");
INSERT INTO cak_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Roma ri benak cánima pa ruvi' ri roch'ulef niquich'ujirisaj cánima chucanoxic re'. Jac'a rix c'o jun Itata' ri reteman chi nic'atzin ronojel re' chive. ");
INSERT INTO cak_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Roma c'a ri', tijacha-ivi' pa ruk'a' ri Dios richin yixru'on gobernar, y ronojel ri nic'atzin, rija' xtuya-pe chive. ");
INSERT INTO cak_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Rix ri rix achel jun ch'uti botzaj oveja, man tixi'ij-ivi', roma ri Itata' Dios ruyo'on chic pa ránima chi yixrucusaj chupan ri ru-gobierno. ");
INSERT INTO cak_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayij ri achique ichajin y ri rajil tiya' chique ri man jun oc quichajin. Tibana' jun iyacona'al ri man nitziakir ta, tibana' ibeyomal ri man jun bey xtiq'uis, pero ja ri chila' chicaj ri achique lugar man jun elek'on ntoc, ni man jun jut nichicopirisan. ");
INSERT INTO cak_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Quiri' nin-ij chive, roma xa achique na chi beyomal yixtajin chuyaquic, jari' nic'utu achok pa ruvi' benak-vi ri ivánima. ");
INSERT INTO cak_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tibana-apu ibanic jumul, y titzije' jumul ri i-candil. ");
INSERT INTO cak_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' achel niqui'en ri samajela' ri jumul coyo'en chi nitzolij-pe ri cajaf ri benak pa jun c'ulubic. Roma tok nuka y nich'o-apu chuchi' ri puerta, ri samajela' cha'anin niquijak-pe ruchi' ri jay chuvech. ");
INSERT INTO cak_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Utzulaj tzij ri' ri samajela' ri eq'ues utz-utz pa ruvi' ri quisamaj tok nuka ri cajaf. Kitzij nin-ij chive chi rija' xterubana-pe rubanic, y xquerutz'uyuba' chuchi' mesa richin yerilij-apu. ");
INSERT INTO cak_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y masque pa nic'aj ak'a' o más chic nic'aj ak'a' xtuka ri cajaf, xa utzulaj tzij ri' ri samajela' si eq'ues pa ruvi' ri quisamaj ye'ilitaj ri hora ri'. ");
INSERT INTO cak_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Tivac'axaj c'a ri nin-ij chive: Xa ta jun tata'aj reteman achique hora ntoc-apu jun elek'on pa racho, can ta nic'ase' y man ta nuya' lugar chi ni'an-e elak' ri pa racho. ");
INSERT INTO cak_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Roma c'a ri', quixc'ase', roma yin ri xitak-pe richin xinalex chi'icojol xquipe chupan ri hora tok man jun achique inojin chiri', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jari' tok ri Pedro quire' xu'ij-apu che ri Jesús: Ajaf, ¿xaxe chike roj a-discípulos xatzijoj-vi ri ejemplo re'? ¿O coma conojel xatzijoj? ");
INSERT INTO cak_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf xu'ij: Pa jun jay, ja ri samajinel ri jabel ninojin y nu'on-apu ronojel ri bin can che, ja samajinel ri' xtucha' ri rajaf richin nuya' can pa quivi' ri ch'aka' chic samajela', richin tok nril k'ij, nujach ri nic'atzin chique richin niquilij-qui'. ");
INSERT INTO cak_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Utzulaj tzij che ri samajinel ri najin riq'uin ri samaj ri bin can che tok nitzolij-pe ri rajaf. ");
INSERT INTO cak_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can kitzij nin-ij chive chi ri rajaf nujach ronojel ri c'o riq'uin pa ruk'a' ri samajinel ri' richin nuchajij. ");
INSERT INTO cak_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero si ri samajinel ri' xa quire' nu'ij-ka pa ránima: Ri vajaf ri' man jani nuka, nicha-ka; y nutz'uc quich'eyic ri ch'aka' chic samajela' chi achi'a' chi ixoki', y nutz'uc chi xe va'in y tijoj-ya' nu'on, y nik'abariyej, ");
INSERT INTO cak_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","xtipe ri rajaf chupan ri k'ij y ri hora tok ri samajinel man jun runa'en chiri', camic chi ch'eyoji'l xtu'on che, y ja chiquicojol ri samajela' man yeniman ta tzij xtuya-vi-apu. ");
INSERT INTO cak_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri samajinel ri reteman achique nrojo' ri rajaf, pero man nunojij ta apu ri achique nrojo' ri samaj, ni man nu'on ta ri nrojo' ri rajaf, can q'uiy ch'eyoji'l xti'an che. ");
INSERT INTO cak_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jac'a ri samajinel ri man reteman ta achique nrojo' ri rajaf, y c'o man utz ta yerubanala-apu, masque ri samajinel re' can utz ta chi ni'an castigar, pero ri castigo ri xtika pa ruvi' man can ta q'uiy. Roma tok jun samajinel q'uiy yo'on che, q'uiy nic'utux che, y ri samajinel q'uiy jachon can pan ruk'a', más q'uiy ri nic'utux che, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yin xipe re choch'ulef richin nunya' k'ak' chiquicojol ri vinak, y ninrayij chi ri k'ak' can ta nic'at chic. ");
INSERT INTO cak_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero na'ey can achel xqui'an bautizar chupan jun nimalaj k'axomal, y ri vánima jani na nik'axo, c'a quik'ax na chupan ri k'axomal ri'. ");
INSERT INTO cak_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Rix ninojij chi riq'uin ri xipe yin choch'ulef tok manak chic oyoval chiquicojol ri vinak? Man quiri' ta. Yin xipe richin chi voma yin más xticataj oyoval chiquicojol ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Roma ja vacami nitiquer-e chi ri jay ri ec'o-vi vo'o' vinak, oxi' xquecataj chiquij ri eca'i', y ri eca'i' xquecataj chiquij ri oxi' voma yin. ");
INSERT INTO cak_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tata'aj xticataj chirij ri ruc'ajol, y ri c'ajol xticataj chirij ri rutata'. Ri te'ej xticataj chirij ri ral xten, y ri xten xticataj chirij ri rute'. Ri alite' xticataj chirij ri rali', y ri alibetz xticataj chirij ri ralite'. ");
INSERT INTO cak_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ri Jesús quire' chic xu'ij chique ri vinak: Tok rix nitz'et chi nimuke-pe ri achique lugar nixule-vi-ka la k'ij, cha'anin ni'ij chi nipe job, y can nipe-vi. ");
INSERT INTO cak_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Quiri' mismo tok nitiquer-pe cak'ik' quire' pa sur, rix ni'ij chi nerubana' c'atan, y can nipe-vi ri c'atan. ");
INSERT INTO cak_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Rix xa nic'ut-ivi' chi ca'i' rupalaj ri yixtajin riq'uin! Roma xa riq'uin nitz'et ri rocaj y ri roch'ulef, yixtiquer ni'ij achique nerubana' ri k'ij. Si iveteman ronojel ri', ¿achique roma man yixtiquer ta ni'ij achique nuq'uen-pe ri tiempo ri rojc'o-vi? ");
INSERT INTO cak_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Y, ¿achique roma man ninojij ta ka rix mismo ri achique utz chi ni'en? ");
INSERT INTO cak_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tok rat benak chuvech juez, más utz tatija' ak'ij tachojmirisaj-avi' riq'uin ri sujunel chavij, utz ri c'a ja rix benak pa bey richin yixec'ojox. Roma si man quiri' ta xta'an, ri sujunel chavij xa xcaruc'uaj chuvech ri nic'ojon ivichin, y riq'uin juba' ri nic'ojon ivichin xcarujach-e pa ruk'a' ri chajiy cárcel, y ri chajiy cárcel yaterutz'apij can. ");
INSERT INTO cak_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kitzij nin-ij chive chi rat man xcatel ta pe ri pa cárcel, c'a ja tok atojon chic can ri ruq'uisbel centavo che ri ajani xk'at chavij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chupan ri tiempo ri' ec'o ca'i-oxi' achi'a' chiri' ri xech'o riq'uin ri Jesús. Rije' xquitzijoj che chi ri Pilato xutak quicamisasic jujun israelitas aj pa departamento Galilea, tok ja yequisuj chicop pa ruvi' ru-altar ri Dios chiri', y romari' ri quiquiq'uel xa jun xu'on riq'uin quiquiq'uel ri chicop. ");
INSERT INTO cak_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jac'a ri Jesús quire' xu'ij chique: ¿Rix ninojij chi ri achi'a' ri quiri' chi camic xquik'asaj-e, más c'o quimac que chiquivech ri ch'aka' chic aj-Galilea? ");
INSERT INTO cak_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man quiri' ta. Y si rix man nijal ta ino'oj richin niya' can ri mac, ja jun rix man xquixcolotaj ta chuvech ri camic. ");
INSERT INTO cak_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","O ri dieciocho vinak ri xerucamisaj ri torre tok xtzak chiquij ri achique lugar c'o-vi ri ya' Siloé, ¿rix ninojij chi rije' más c'o quimac que chiquivech conojel ri vinak pa tinamit Jerusalem? ");
INSERT INTO cak_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man quiri' ta. Y si rix man nijal ta ino'oj richin niya' can ri mac, ja jun rix man xquixcolotaj ta chuvech ri camic. ");
INSERT INTO cak_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Xutzijoj chic c'a ri ejemplo re' chique, y xu'ij: C'o jun achi ruticon jun mata higo chucojol ri rutico'n, y c'o c'a jun k'ij xerucanoj ruvech ri higo. Pero man jun ch'uti ruvech xerila'. ");
INSERT INTO cak_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ri rajaf ri juyu' xu'ij che ri rusamajinel ri nisamaj pa tico'n: Ri jun mata higo re' más utz nachoy-e. Roma ja oxi' juna' riq'uin re' ri juna-juna' yipe chucanoxic ruvech, y man jun bey nutz'eton jun ch'uti ruvech. ¿Achique nic'atzin ruk'etbeyan ri ulef? ");
INSERT INTO cak_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Jac'a ri nisamajin ri tico'n xu'ij: Vajaf, taya' chic na can ri juna' re'; ninsirirej na rubu'ic ruxe', y ninya' na abono chuxe'. ");
INSERT INTO cak_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Si nuya' ruvech, utz c'a ri'. Si manak, c'ajari' tachoyo-e, xcha' ri nisamajin ri tico'n. ");
INSERT INTO cak_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun sábado ri k'ij richin uxlanen, ri Jesús yerutijoj ri quimolon-qui' pa jun sinagoga. ");
INSERT INTO cak_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","C'o c'a jun ixok chiquicojol ri ja dieciocho juna' ocunak jun itzel espíritu richin yabil riq'uin, romari' luculic rij, y man juba' nitiquer nipa'e' choj. ");
INSERT INTO cak_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jac'a ri Jesús tok xutz'et ri ixok, xroyoj y xu'ij che: Vacami xacolotaj chuvech ri ayabil, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jac'ari' xuya' ruk'a' pa ruvi', y ri ixok jari' xtiquer xpa'e' choj, y nuya' ruk'ij ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jac'a ri achi principal chiri' pa sinagoga, itzel xuna' chi ri Jesús chupan ri sábado ri k'ij richin uxlanen xuc'achojrisaj ri ixok. Romari' xu'ij chique ri quimolon-qui' chiri': Vaki' k'ij utz chi ni'an samaj, y ja chupan tak ri k'ij ri' quixpe riq'uin ri Jesús richin yixc'achojrises, y mana-ta chupan ri k'ij richin uxlanen, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jac'a ri Ajaf Jesús quire' xu'ij che ri achi: Rat xa ca'i' rupalaj ri yatajin riq'uin. Roma rix masque chupan ri sábado ri k'ij richin uxlanen, pero ye'isol-e ri iquiej y ri iváquix richin ne'iya' quiya'. ");
INSERT INTO cak_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Y ri ixok re' riy-rumam can ri Abraham, ri ja dieciocho juna' ruximon ri Satanás chupan ri yabil. ¿Man utz ta cami chi nicol chuvech ri ruyabil chupan ri k'ij richin uxlanen? ");
INSERT INTO cak_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tok ri Jesús xu'ij quiri', conojel ri itzel niquina' che, xeq'uix-ka. Pero conojel ri quimolon-qui' niquicot cánima roma ri nimalaj tak milagros ri yerubanala' ri Jesús chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jac'ari' tok ri Jesús xu'ij: ¿Achok riq'uin ta cami junan ri ru-gobierno ri Dios? Y, ¿achok riq'uin ta cami ninjunumaj-vi? ");
INSERT INTO cak_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yin nin-ij chi junan riq'uin jun ch'uti ruvech ru-semilla mostaza ri xuch'ic can jun vinak pa ruxolal. Tok xq'uiy, hasta achel rupalen jun che' xu'on, y ri chicop c'o quixic' hasta xqui'en quisoc chuk'a'. ");
INSERT INTO cak_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y ri Jesús xu'ij chic jun bey: ¿Achok riq'uin cami ninjunumaj-vi ru-gobierno ri Dios? ");
INSERT INTO cak_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Yin nin-ij chi junan riq'uin ri levadura neruc'ama-pe jun ixok y nuyok' chucojol oxi' medida harina richin nuquiraj-ri' chupan ronojel, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Tok ri Jesús benak pa bey richin ni'e pa tinamit Jerusalem, rija' nik'ax pa tak tinamit y aldeas richin yerutijoj can ri vinak riq'uin ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Jac'ari' tok c'o jun ri quire' x-in-apu che: Ajaf, ¿can juba' cami oc ri xquecolotaj? Y ri Jesús quire' c'a xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Rix titija' ik'ij chi yixoc chupan ri puerta co'ol oc ruvech. Roma nin-ij chive chi eq'uiy xtiquitij quik'ij chi ye'oc chiri', pero man xquetiquer ta. ");
INSERT INTO cak_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Roma si xticataj-pe ri rajaf-jay richin xturutz'apij ri puerta, y c'ajari' xtijo' xquixoc-apu, rix masque quire' xti'ij-apu chuchi' ri puerta: Ajaf, Ajaf, tajaka' ri puerta chikavech xquixcha', pero rija' xa xtu'ij-pe chive: Yin man veteman ta achique lugar quixpe-vi, xticha-pe. ");
INSERT INTO cak_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Jac'ari' rix quire' xti'ij-apu che: Ja roj ri xojva' y xkakum kaya' chavech, y ja ri pa tak bey ri niquimol-vi-qui' ri vinak pa tak katinamit xatijon-vi pa ruvi' ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Jac'a rija' xtu'ij-pe chive: Yin man veteman ta achique lugar quixpe-vi. Quixel-e chinuvech ivonojel rix ri rix banoy itzel tak no'oj, xticha' ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y tok xque'itz'et ri Abraham, ri Isaac, ri Jacob y conojel ri profetas ri xec'uje' ojer can, chi ec'o pa ru-gobierno ri Ajaf Dios, y nitz'et chi rix xa xixeleses can, chiri' c'a xtoc-vi ok'ej y jach'ach'en eyaj ivoma. ");
INSERT INTO cak_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Roma ec'o xquepe quire' pa norte, quire' pa sur, quire' achique lugar ntel-vi-pe ri k'ij, y quila' achique lugar nika-vi-ka; conojel re' xquetz'uye-apu chuchi' ru-mesa ri Dios ri nibano chic gobernar pa quivi'. ");
INSERT INTO cak_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y tivetemaj chi c'o ri ec'o can ruq'uisbel vacami, xa xqueyo'ox yan chic chi na'ey. Y c'o ri ec'o na'ey, xa xquecanaj can ruq'uisbel, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chupan ri k'ij ri', ec'o achi'a' fariseos xe'eka riq'uin ri Jesús, y quire' xqui'ij che: Catel-e vave', roma ri Herodes nrojo' yarucamisaj, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jac'a ri Jesús xu'ij chique: Quixbin y ti'ij che ri jun satzoy quino'oj vinak ri', chi yin vacami y chua'k c'a yenvelesaj na itzel tak espíritu y c'a nin-en na chique ri yeyavej chi yec'achoj, y c'a cabij ninq'uis rubanic ri samaj. ");
INSERT INTO cak_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero vacami, c'a nic'atzin na yi'e chupan ri nubey, quiri' ri chua'k-cabij. Roma manak che'el chi jun profeta man ta pa Jerusalem xticamises-vi. ");
INSERT INTO cak_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jac'ari' tok ri Jesús xu'ij: ¡Aj-Jerusalem, aj-Jerusalem! Rix ri ye'icamisaj ru-profetas ri Dios y ye'ic'akala' che abaj ri yerutak chi'icojol, yin q'uiy (mul, paj) xinjo' xixinmol achel nu'on jun ec' chique ri ch'utik ral, yerumol chuxe' ruxic', pero rix xa man xijo' ta. ");
INSERT INTO cak_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vacami c'a, ri itinamit xtixutux can roma ri Dios. Nin-ij c'a chive chi rix man xquinitz'et ta chic, c'a ja tok xtuka ri tiempo tok xti'ij: ¡Nimalaj favor c'o pa ruvi' re petenak pa rubi' ri Ajaf Dios! xquixcha'. ");
INSERT INTO cak_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Chupan jun sábado ri k'ij richin uxlanen, xbanataj chi tok ri Jesús c'o chic pa racho jun achi c'o ruk'ij chiquicojol ri achi'a' fariseos richin niva' chiri', ri ec'o chiri', xe nich'icch'ot-apu quivech chirij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jac'ari' c'ate retal c'o-apu chuvech ri Jesús jun achi sipojnak. ");
INSERT INTO cak_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Xch'o c'a ri Jesús chique ri achi'a' q'uiy queteman chirij ri ley y chique ri fariseos, y quire' xu'ij: ¿Utz cami nic'achojrises jun niyavej pa jun sábado ri k'ij richin uxlanen, o man utz ta? ");
INSERT INTO cak_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jac'a rije' man jun achique xqui'ij. Jac'ari' tok ri Jesús (xutz'om, xuchop) apu chuk'a' ri niyavej, xu'on chi xc'achoj, xu'ij che chi ti'e, ");
INSERT INTO cak_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","y xu'ij chique ri achi'a' q'uiy queteman chirij ri ley y chique ri fariseos: Si jun chive rix nitzak-ka jun ruquiej o jun ruváquix pa jun jul c'oton, ¿man cha'anin ta cami nrelesaj-pe, masque pa jun sábado ri k'ij richin uxlanen? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jac'a rije' man jun rutzolic rutzij xetiquer xqui'en-apu. ");
INSERT INTO cak_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Tok ri Jesús xerutz'et ri ula' ri e'oyon pa jun va'in chi yequicha' ri na'ey tak ch'aquet chuchi' mesa, rija' xutzijoj ri jun ejemplo re' chique: ");
INSERT INTO cak_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tok rat oyon pa jun c'ulubic, man c'a catz'uye-apu ri pa na'ey tak ch'aquet. Roma riq'uin juba' c'o chic jun ula' oyon ri más c'o ruk'ij que chavech rat, ");
INSERT INTO cak_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y riq'uin juba' xtipe ri xoyon ivichin chi rix ca'i', y xtu'ij chave: Tabana' favor, taya' can ri ch'aquet re' che ri jun re'. Jac'ari' rat riq'uin q'uix xcatetz'uye' pa jun ruq'uisbel ch'aquet. ");
INSERT INTO cak_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Romari' tok c'o jun noyon avichin pa jun nimak'ij, más utz catz'uye' pa jun ruq'uisbel ch'aquet, richin quiri' tok yarutz'et-pe ri xoyon avichin, xtu'ij chave: Rat amigo, cajel-pe más quire', xticha'. Tok quiri' xti'ix chave, rat xtic'uje' ak'ij chiquivech conojel ri junan rix oyon quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Roma xa achique na ri ruyon nuya-ka ruk'ij, xa xti'an che chi manak ruk'ij. Jac'a ri co'ol oc nuna-ka-ri', xti'an che chi can c'o ruk'ij. ");
INSERT INTO cak_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jac'ari' tok ri Jesús xu'ij che ri xoyon richin: Tok rat na'an jun va'in pak'ij o nik'ok'a', man que'avoyoj ri (avachbil, avach'il), ri achak'-animal, ri (avalpachel, avaj-c'uaxel), o ri beyoma' tak a-vecinos, roma rije' yetiquer yatcoyoj chic rat richin jun va'in, y riq'uin ri' nitzolis yan rajil-ruq'uexel chave. ");
INSERT INTO cak_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Jac'a rat, tok na'an jun nimalaj ruquil-vey chi'avacho, que'avoyoj ri manak oc quichajin, ri man utz ta quik'a' o cakan, y ri man yetzu'un ta. ");
INSERT INTO cak_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Si quiri' na'an, rat utzulaj tzij xti'an chave roma ri Dios, roma ri xe'avoyoj, manak achok che xtiquitzolij-vi rajil-ruq'uexel chave, pero rat xtiyo'ox rajil-ruq'uexel chave chupan ri k'ij tok xquec'astaj-e ri xe'uc'uan-e choj c'aslen choch'ulef, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jun chique ri etz'uyul chiri' chuchi' mesa tok xrac'axaj ri xu'ij ri Jesús, quire' xu'ij-apu che: Utzulaj tzij ri' ri xtiva' pa ru-gobierno ri Ajaf Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jac'a ri Jesús xu'ij: C'o jun bey jun achi najin riq'uin rubanic jun nimalaj ruquil-vey chiracho, y chique eq'uiy ruyo'on-vi rutzijol chi ye'eva' riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Tok xril hora richin ri va'in, rija' xutak-e jun rusamajinel richin xeru'ij chique conojel ri yo'on rutzijol chique: Vacami quixampe, roma ronojel chic banon rubanic. ");
INSERT INTO cak_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero chiquijununal c'o-vi xqui'ij-pe. Ri na'ey xu'ij-pe: Tabana' favor, ta'ij che ri avajaf chi tucuyu' juba' numac, pero man yitiquer ta, roma c'a ja xinlok' jun nujuyu', y nic'atzin nentz'eta'. ");
INSERT INTO cak_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jun chic quire' xu'ij-pe: Tabana' favor, ta'ij che ri avajaf chi tucuyu' juba' numac, pero man yitiquer ta, roma ec'o lajuj váquix richin samaj xenlok', y nic'atzin yentojto'ej. ");
INSERT INTO cak_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jun chic xu'ij-pe: Quinacuyu', pero yin c'a ja xic'ule' y romari' manak che'el yi'e, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y tok xtzolij-pe ri samajinel, xuru'ij che ri rajaf ronojel ri xqui'ij-pe ri xe'oyox. Romari' ri rajaf xpe royoval, y xu'ij che ri rusamajinel: Vacami cabin ri pa tak bey y ri pa tak lugar ri niquimol-vi-qui' ri vinak pa tinamit, y que'ac'ama-pe ri manak oc quichajin, ri man utz ta quik'a' o cakan, y ri man yetzu'un ta. ");
INSERT INTO cak_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jac'a tok xtzolij chic pe ri samajinel, xuru'ij che ri rajaf: Ja xin-en achel ri xa'ij-e chuve, pero c'a c'o na q'uiy ch'aquet, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Jac'ari' tok ri rajaf xu'ij che: Vacami cabin pa tak bey ri yebe pa ch'aka' chic tinamit, pa rakan tak coral y tza'n tak jay, y xa achique na vinak xque'ac'ul, tabana' chique chi que'oc-pe pa jay, richin quiri' ninoj ri vacho. ");
INSERT INTO cak_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Roma yin kitzij nin-ij chive chi nis-ta jun chique ri xenvoyoj na'ey, ri xtuva' viq'uin. Quiri' xu'ij ri achi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Eq'uiy c'a vinak etzekleyon-e ri Jesús, y tok xtzu'un can chirij, quire' xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Si c'o jun nipe viq'uin, nic'atzin chi más yirojo' yin que chuvech ri rute-rutata', rixayil, ralc'ua'l, eruchak', erunimal, y hasta chuvech ri ruc'aslen rija' mismo. Roma si man quiri' ta nu'on, man nitiquer ta ntoc nu-discípulo. ");
INSERT INTO cak_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri nupokonaj nuya-ri' chuvech ri camic richin yirutzekle'ej, man nitiquer ta ntoc nu-discípulo. ");
INSERT INTO cak_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Roma si c'o jun chive rix nrojo' nupaba' jun torre, ¿man nitz'uye' ta cami na'ey richin nrajlaj ri ajani méra xtic'atzin che, richin nutz'et si nu'on ri méra richin nuq'uis rubanic ri samaj? ");
INSERT INTO cak_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Roma si xaxe juba' rutz'uyubal ri samaj nuya-ka y man nitiquer ta nuq'uis rubanic, ri vinak ri xquetz'eto ri samaj, xa xquetze'en chirij. ");
INSERT INTO cak_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Ri vinak xa quire' xtiqui'ij chirij: La jun achi la' xrojo' xupaba' jun torre, y xa man xtiquer ta xuq'uis rubanic, xquecha'. ");
INSERT INTO cak_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O si c'o jun rey nerubana' guerra riq'uin jun chic rey, ¿man nitz'uye' ta cami juba' na'ey richin nunojij si riq'uin ri lajuj mil ru-soldados yetiquer nequibana' guerra riq'uin ri jun chic rey ri eruc'amon-pe veinte mil soldados? ");
INSERT INTO cak_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si nuna' chi xa man nitiquer ta, utz ri c'a naj petenak-vi ri jun chic rey, ja yan yerutak achi'a' richin nequic'utuj che chi tiq'uis quiri' ri oyoval. ");
INSERT INTO cak_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Romari', xa achique na jun chive rix ri man nuya' ta can ronojel ri achique ruchajin, man nitiquer ta ntoc nu-discípulo. ");
INSERT INTO cak_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atz'an can utz vi, pero si niq'uis-e ri ratz'amil, ¿achique chic xtiyo'ox riq'uin richin nitzolij-pe ri ratz'amil? ");
INSERT INTO cak_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ri atz'an ri man natz'amin ta chic, nis-ta richin niyo'ox riq'uin ulef, y nis-ta richin abono xtic'atzin, xa choj nitorix-e. Ri (nik'ax, nino') chuvech ri yitajin chubixic, trelesaj no'oj chirij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Conojel ri c'uluy tak impuestos y ri vinak ni'ix aj-mac chique, yejel-apu riq'uin ri Jesús richin niquic'axaj ri nutzijoj. ");
INSERT INTO cak_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Jac'a ri achi'a' fariseos y ri achi'a' q'uiy queteman chirij ri ley quire' niquijasja-apu chirij: Ri Jesús xa nuc'ul quivech ri aj-mac, y hasta junan niva' quiq'uin, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Roma c'a ri', ri Jesús xutzijoj re jun ejemplo re' chiquivech: ");
INSERT INTO cak_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Si jun chive rix ec'o cien ru-ovejas, y si nisatz can jun tok yeruyuk'uj, rija' yeruya' can juba' ri noventa y nueve ri pa juyu' y ni'e chucanoxic ri jun satznak can hasta que xtril-pe. ");
INSERT INTO cak_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Tok nril, niquicot nuya-pe chuvi' rutele'n. ");
INSERT INTO cak_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y tok nuka chiracho, yerumol ri ru-amigos y ri ru-vecinos, y nu'ij chique: Quixquicot junan viq'uin, roma xinvil-pe ri nu-oveja satznak. ");
INSERT INTO cak_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kitzij nin-ij chive, chi quiri' mismo ri ec'o chicaj más yequicot pa ruvi' jun aj-mac ri nujal runo'oj y nuya' can ri mac, que pa quivi' noventa y nueve ri choj quic'aslen, y man nic'atzin ta chi c'a niquijal na quino'oj richin niquiya' can ri mac. ");
INSERT INTO cak_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Y si c'o jun ixok ri c'o lajuj méra rubinan dracma riq'uin, y si nutzak jun chiri' pa racho, ¿man nutzij ta cami jun candil, y numes rupan ri racho chucanoxic ri ruméra c'a xtril na? ");
INSERT INTO cak_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tok nril, yeroyoj ri ru-amigas y ri ru-vecinas, y nu'ij chique: Quixquicot junan viq'uin, roma ja xinvil ri numéra nutzakon, nicha'. ");
INSERT INTO cak_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kitzij nin-ij chive, chi quiri' mismo ri ru-ángeles ri Dios, jani na yequicot tok jun aj-mac nujal runo'oj y nuya' can ri mac, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Xch'o chic jun bey ri Jesús y xu'ij: C'o jun achi ec'o ca'i' ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jun k'ij ri chak'ila'tz xu'ij che ri rutata': Papá, taya' ri verencia ri nin-en tocar yin, xcha', y ri tata'aj can xujach na vi ri herencia chiquivech ri eca'i'. ");
INSERT INTO cak_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ca'i-oxi' k'ij tiyo'ox ri ru-herencia chiri', ri chak'ila'tz ja xuc'ayila' can ronojel ri achique xyo'ox che. Xunuc'-e ri méra rajil ri herencia ri xuc'ayij, y pa jun departamento naj-naj xbe-vi. Chiri' c'a, rija' xa achique na chi itzel c'aslen xuq'uis-vi ri ruméra. ");
INSERT INTO cak_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tok xuq'uis ronojel ri ruméra, xtiquer jun nimalaj vayijal chupan ri lugar ri', y ri ala' manak chic achok che nuk'asaj-vi-ri'. ");
INSERT INTO cak_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Xberusuju' c'a ri' pa samaj riq'uin jun achi aj chiri', y ri samaj xyo'ox chuk'a', ja ri yeruyuk'uj ak. ");
INSERT INTO cak_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ri ala' bala ta nrojo' nutij-ka ri niquitij ri ak richin ninoj rupan, pero man jun niyo'on che rija'. ");
INSERT INTO cak_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Jac'ari' tok achel xc'astaj ruvech, y xu'ij-ka pa ránima: Chiracho ri nata' ri'... man jun vayijal niquik'asaj ri rusamajela'. Jac'a yin roma vayijal, juba' ma nipa'e-ka vánima. ");
INSERT INTO cak_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más utz quicataj na, richin yitzolij riq'uin ri nata', y nin-ij che: Papá, yin veteman chi xin-en mac chuvech ri Dios, y chavech rat, ");
INSERT INTO cak_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","romari' man utz ta chi c'a ni'ix na chi yin ac'ajol. Masque xa achel ta oc jun asamajinel tabana' chuve. Quiri' xtin-ij che, xcha-ka pa ránima. ");
INSERT INTO cak_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Xcataj c'a pe, (xutz'om, xuchop) pe bey richin nitzolij-pe riq'uin ri rutata', y tok c'a naj na c'o-vi chiri', ri rutata' xutz'et chi ja ri ruc'ajol ri petenak. Xjik'ijo' ránima ri tata'aj richin xupokonaj ruvech, junanin xbe-apu riq'uin richin xuk'etej, y (xutz'ubaj, xutz'ub). ");
INSERT INTO cak_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Jac'ari' tok ri ala' xu'ij che ri rutata': Papá, yin xin-en mac chuvech ri Dios, y quiri' mismo chavech rat, romari' man utz ta chi c'a ni'ix na chi yin ac'ajol, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ri tata'aj xu'ij chique ri rusamajela': Tivelesaj-pe cha'anin ri tziek más utz y tijala' ri rutziak. Tiya' jun (mitk'a', anillo) chuvi' ruk'a' y tiya' ruxajab. ");
INSERT INTO cak_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Tic'ama-pe ri tiojlaj váquix, y ticamisaj, kuva' c'a y tikabana' nimak'ij. ");
INSERT INTO cak_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Roma ri jun nuc'ajol re' caminak chic, pero vacami xc'astaj chic pe. Satznak-e, y vacami xilitaj, xcha' ri tata'aj. Jac'ari' xtiquer-ka ri nimak'ij. ");
INSERT INTO cak_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Jac'a ri (nimala'tz, nimalaxel) ruc'ajol xa benak pa juyu'. Tok xtzolij-pe y xuka chunakaj ri cacho, xrac'axaj chi najin k'ojon y xojoj pa jay. ");
INSERT INTO cak_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Romari' rija' xroyoj jun chique ri samajela' y xuc'utuj che: ¿Achique ri' ri najin? ");
INSERT INTO cak_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri samajinel xu'ij che: Ja ri achak' xtzolij-pe, y ri atata' xu'ij chi ticamises ri tiojlaj váquix, roma ri achak' tz'akat ruk'a-rakan xtzolij-pe. ");
INSERT INTO cak_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tok xrac'axaj quiri', xcataj royoval, man nrojo' ta ntoc-apu. Xel c'a pe ri rutata', nubochila' ri ruc'ajol richin ntoc-apu. ");
INSERT INTO cak_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Jac'a ri ala' quire' xu'ij che ri rutata': Tuka chi'ac'u'x chi yin q'uiy juna' yin samajnak-pe aviq'uin; man jun bey man ta nuniman atzij. Pero rat nis-ta jun ch'uti cabra ayo'on chuve richin ta nubanon jun nimak'ij quiq'uin ri (vachbil, vach'il). ");
INSERT INTO cak_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Jac'a tok xtzolij-pe ri jun ac'ajol re xeruq'uisa' abeyomal quiq'uin ixoki' man utz ta quic'aslen, rat xa'ij chi xcamises ri tiojlaj váquix, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri tata'aj xu'ij che: Nuc'ajol, rat jumul ratc'o viq'uin. Romari' ronojel ri c'o viq'uin, avichin rat. ");
INSERT INTO cak_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero vacami can utz vi chi nika'an nimak'ij y nkuquicot. Roma ri achak', chinuvech yin caminak chic e, y vacami xc'astaj chic pe. Satznak-e, y xilitaj chic, xcha' ri tata'aj. Quiri' ri xu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Xch'o chic ri Jesús chique ri ru-discípulos, y quire' xu'ij: C'o jun achi beyon ruyo'on jun administrador pa ruvi' ri rubeyomal. Pero jun k'ij xesujus ri administrador chuvech, chi xa nuq'uis ri beyomal jachon pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Roma c'a ri', xroyoj ri administrador, y quire' xu'ij che: ¿Achique c'a ri yatajin riq'uin ri xutzijos chuve? Vacami ninjo' nac'ut chinuvech rutz'ibasic chi jujun chi jujun ri achique abanon riq'uin ri numéra, roma vacami manak chic asamaj viq'uin, xcha' ri rajaf che. ");
INSERT INTO cak_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Jac'a ri administrador xu'ij-ka pa ránima: ¿Achique nin-en? Roma ri vajaf yirelesaj-e pa samaj. Yinesamaj ta chirakan azadón, man yitiquer ta. Ninc'utuj ta limosna pa tak bey, yiq'uix. ");
INSERT INTO cak_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah! Ya veteman chic ri achique utz chi nin-en, richin quiri' tok ri vajaf xtrelesaj nusamaj, xa ec'o yec'ulu nuvech pa tak cacho, nicha'. ");
INSERT INTO cak_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Jac'ari' xeroyoj chi jujun chi jujun ri c'o quic'as riq'uin ri rajaf y quire' xu'ij che ri na'ey: ¿Ajani ac'as riq'uin ri vajaf? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Yin jun ciento barril aceite nuc'as, xcha' ri achi c'o ruc'as. Y ri administrador xu'ij che: Jare' ri vuj richin ri ac'as. Catz'uye' c'a ka cha'anin, y tatz'ibaj-ka chi xaxe chic nic'aj ciento barril ac'as. ");
INSERT INTO cak_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jac'ari' xuc'utuj chic che jun: Y rat, ¿ajani ac'as riq'uin ri vajaf? xcha'. Yin cuatrocientos cuarenta quintal trigo nuc'as, xcha'. Y ri administrador xu'ij che: Jare' ri vuj richin ri ac'as. Tatz'ibaj-ka chi xaxe chic trescientos cincuenta quintal ac'as, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y ri rajaf xunimirisaj rubi' ri administrador ri man pa ruchojmil ta nisamaj roma can xno' (chubanic, cho'onic). Quiri' xu'ij, roma ri vinak ri c'a benak na cánima pa ruvi' ri roch'ulef, más yeno' riq'uin ri trato ri niqui'en chiquivech, que chuvech ri erichin ri sakil. ");
INSERT INTO cak_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jac'a yin nin-ij chive: Riq'uin aj-roch'ulef beyomal tibana-vi favor chique ri vinak, richin ye'oc amigos, richin quiri' tok xtiq'uis ri beyomal re', c'o xtic'ulu ivech chupan tak ri jay ri man jun bey xqueq'uis, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Roma jun vinak, si pa ruchojmil rusamajisic nu'on ri juba' jachon can pa ruk'a', quiri' mismo xtu'on pa ruvi' jun nimalaj beyomal. Pero si jun vinak xa ni'e-ka ruk'a' pa ruvi' ri juba' jachon can pa ruk'a', quiri' mismo xtu'on pa ruvi' jun nimalaj beyomal. ");
INSERT INTO cak_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y si man pa ruchojmil ta rusamajisic ni'en rix ri beyomal richin ri roch'ulef, ¿achique xtiyo'on chive ri kitzij beyomal? ");
INSERT INTO cak_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Y si man pa ruchojmil ta rusamajisic ni'en ri beyomal ri xa man ivichin ta rix, ¿achique xtiyo'on chive ri can ivichin rix yacon-apu? ");
INSERT INTO cak_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Man jun samajinel nitiquer nisamaj quiq'uin eca'i' rajaf. O itzel nutz'et can jun chique ri rajaf, y nrojo' ri jun chic; o nunimaj rutzij ri jun y nuxutuj can ri jun chic. Romari' rix, manak che'el ni'en ri nika chuvech ri Dios, tok xa benak ivánima pa ruvi' ri beyomal richin ri roch'ulef, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Jac'a ri achi'a' fariseos ri xa benak cánima pa ruvi' méra, niquic'axaj-apu ri nu'ij ri Jesús, romari' niquinich'ina-apu quitza'n chirij. ");
INSERT INTO cak_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Roma c'a ri', ri Jesús xu'ij chique: Rix iyon ni'en-ka chi can rix utz chiquivech ri vinak, pero ri Dios reteman ri achique c'o pa tak ivánima. Quiri' nin-ij chive roma ri can utz chiquivech ri vinak, xa jani na itzel chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ronojel ri nu'ij chupan ri ley ri xyo'ox che ri Moisés y ri quitz'iban can ri profetas ojer, c'a jari' na nicuses tok xuka ri Juan ri Bautista. Pero riq'uin rija' xtz'ucutaj-vi-pe rutzijosic ri achique ruchojmil ye'oc ri vinak pa ruk'a' ri Dios richin yeru'on gobernar, y conojel niquitij quik'ij richin ye'oc chiri'. ");
INSERT INTO cak_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero yin nin-ij chive chi más man c'ayef ta chi niq'uis ri caj y ri roch'ulef, que chuvech man ta nibanataj jun ch'uti rutza'n letra che ri tz'iban can chupan ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y xa achique na achi ri nuya' can ri rixayil y nuq'uen chic jun ixok, ri achi ri' nika pa mac. Y xa achique na achi nic'amo ri ixok yo'on can roma ri rachijil, ja jun ri achi ri' nika pa mac. ");
INSERT INTO cak_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jac'ari' tok ri Jesús xu'ij: C'o jun beyon xc'uje' ri ruyon nima'k tak cajil tziek yerucusala', y man jun ruq'ueq'uexic nu'on ri méra richin nubanala' nimak'ij k'ij-k'ij. ");
INSERT INTO cak_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero (chuka', ka) c'o jun c'utuy limosna rubinan Lázaro ri nojnak rij riq'uin ch'a'c, ri nic'uje-apu chuchi' racho ri beyon. ");
INSERT INTO cak_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro re' bala ta nrojo' nutij ri ruchi' tak pan ri yetzak-ka chuxe' ru-mesa ri beyon, y hasta ri tz'i' yejel-pe riq'uin richin niquirak' ri ch'a'c chirij. ");
INSERT INTO cak_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Pero c'o jun k'ij (xcom, xquen) ri c'utuy limosna, y xuc'uax coma ri ángeles c'a chupan ri lugar ri c'o-vi ri Abraham. (Chuka', ka) c'o jun k'ij (xcom, xquen) ri beyon, y xmuk. ");
INSERT INTO cak_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Jac'a tok ri beyon c'o chic pa k'axomal chupan ri lugar ri ec'o-vi ri anima'i', xtzu'un c'a pe y chi naj xutz'et-pe ri Abraham, y ri Lázaro rak'el-apu choruc'u'x ri Abraham. ");
INSERT INTO cak_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Jac'ari' tok riq'uin ruchuk'a' xsiq'uin, y xu'ij-pe: Nata' Abraham, tapokonaj nuvech, tataka-pe juba' ri Lázaro viq'uin, y tuch'eke'a-pe ruvi-ruk'a' pa ya' richin nuruya-ka chutza'n ri vak', roma yin man nincoch' ta ri k'axomal yinc'o-vi chupan ri k'ak' re', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ri Abraham xu'ij che: Valc'ua'l, tuka chi'ac'u'x chi rat xatz'uye' yan pe pa ruvi' beyomal chuvech ri roch'ulef, jac'a re Lázaro, juye' ruvech xu'on-pe. Pero rija' vacami, jabel ruc'aslen xurila' vave', jac'a rat xa pa k'axomal ratc'o-vi. ");
INSERT INTO cak_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y pa ruvi' ronojel re', xa c'o jun paral sivan chikacojol aviq'uin, romari', xa ta ri ec'o vave' nicajo' yek'ax-apu iviq'uin, manak che'el, y si ri ec'o chiri' nicajo' yek'ax-pe vave', (chuka', ka) manak che'el, xcha' ri Abraham. ");
INSERT INTO cak_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Jac'ari' xu'ij ri beyon: Si quiri', tabana' favor, nata' Abraham, tataka-e juba' ri Lázaro chiracho ri nata', ");
INSERT INTO cak_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","roma c'a ec'o na vo'o' chic kachak'-kanimal ki' quiq'uin, y ninjo' chi rija' neru'ij rubeyal ronojel chique, richin quiri' man quepe chupan ri lugar richin k'axomal re', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Jac'a ri Abraham xu'ij-pe che: Rije' pa quik'a' c'o-vi ruch'abel ri Dios ri rutz'iban can ri Moisés, y ri quitz'iban can ri profetas ojer; jari' tiquiya' quixiquin riq'uin y tiquinimaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Jac'ari' tok xu'ij ri beyon: Ja', can kitzij nata' Abraham. Pero si c'o jun ámna nic'astaj-e y nech'o quiq'uin, rije' niquijal quino'oj, niquiya' can ri mac y niquinimaj ri Dios, xcha' ri beyon. ");
INSERT INTO cak_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ri Abraham xu'ij-pe che: Si man niquinimaj ta ruch'abel ri Dios ri rutz'iban can ri Moisés, ni man niquinimaj ta ri quitz'iban can ri profetas, masque nic'astaj-e jun ámna, rije' man niquijal ta quino'oj, ni man niquiya' ta can ri mac, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jac'ari' tok ri Jesús xu'ij chique ri ru-discípulos: Manak che'el chi man ta manak nibano chique ri vinak chi niquil jun roma chi niquixutuj can ri Dios. Pero, ¡tok'ex ruvech ri ntoc tzakoy richin jun chic! ");
INSERT INTO cak_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más utz che can ta na'ey xxim-e jun abaj joc'oy trigo chukul y xec'ak chupan ri mar, que chuvech nu'on che jun ri man can ta c'o ruchuk'a' ránima riq'uin ri Dios, achel re ec'o-pe re', chi nuxutuj can ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Romari', rix tibana' cuenta ivi' chivech. Si rat c'o jun nibano ri man utz ta chave, ta'ij che, y si nuc'utuj rucuyubel mac chavech, tabana' perdonar. ");
INSERT INTO cak_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y si pa jun k'ij nu'on vuku' mac chave, y roma ri mac rija' vuku' (mul, paj) nitzolij-pe aviq'uin richin nuruc'utuj chave chi tacuyu-tasatza' rumac, rat tabana' perdonar, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jac'ari' tok ri apóstoles xqui'ij che ri Ajaf Jesús: Taya' más ruchuk'a' kánima richin nikanimaj ri na'ij chike. ");
INSERT INTO cak_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Y ri Ajaf Jesús xu'ij chique: Si rix ninimaj chi ri Dios can c'o-vi nitiquer nu'on, y masque achel oc jun ch'uti ruvech ru-semilla mostaza quiri' oc ninimaj pan ivánima, yixtiquer ni'ij che re sicómoro re': Tac'uku-e-avi' vave' y te'atica-avi' chupan ri mar, yixcha' che, y can xtunimaj-vi itzij. ");
INSERT INTO cak_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Si rix c'o jun isamajinel itakon-e pa juyu' richin nerubu' ri ulef o richin neyuk'un, tok nitzolij-pe, rix man ni'ij ta che: Catoc-pe pa jay, catz'uye' chuchi' ri mesa y cava'. Man quiri' ta ni'ij che. ");
INSERT INTO cak_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Rix xa quire' ni'ij che: Tabana' abanic richin na'an-pe rubanic ri achique nintij ri nik'ok'a' vacami, y c'a tincolaj na yin, c'ajari' xcava' y xtakum aya' rat, yixcha' che. ");
INSERT INTO cak_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿La namatioxij cami che ri asamajinel roma xu'on-pe ronojel ri xa'ij che? Man jun. ");
INSERT INTO cak_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y achel ri samajinel ri', quiri' mismo rix. Tok ibanon chic ri samaj ri nu'ij ri Dios chive, ti'ij: Roj, xa roj relic samajela' y riq'uin ri samaj kabanon, man jun favor kabanon che ri Dios. Roj can kac'as vi chi nika'an ri samaj, quixcha'. Quiri' xu'ij ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Tok ri Jesús benak pa bey richin ni'e pa tinamit Jerusalem, ja ri pa (quic'ulba't, qui-mojón) ri Samaria y ri Galilea nik'ax-vi. ");
INSERT INTO cak_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Tok ja ntoc-apu pa jun aldea chiri', xe'el-pe lajuj achi'a' c'o lepra chiquij chuc'ulic, pero c'a naj xepa'e-vi. ");
INSERT INTO cak_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jac'ari' xesiq'uin-pe riq'uin cuchuk'a' y xqui'ij: ¡Jesús, Tijonel, tapokonaj kavech riq'uin ri kayabil! xecha'. ");
INSERT INTO cak_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Tok ri Jesús xerutz'et, xu'ij chique: Quixbin y te'ic'utu-ivi' chiquivech ri sacerdotes israelitas. Tok ebenak pa bey chiri', jari' xq'uis-e ri lepra chiquij y xech'ajch'ojir can. ");
INSERT INTO cak_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jun chique ri lajuj achi'a', tok xutz'et chi xc'achoj riq'uin ri ruyabil, xtzolij-pe, y jani na nisiq'uin nuya' ruk'ij ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rija' xxuque-ka, xuya-ka nic'aj-ruvech pan ulef chuvech ri Jesús, y numatioxij che. Ri achi re' aj pa departamento Samaria. ");
INSERT INTO cak_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Chutzolic tzij ri Jesús xu'ij: ¿Man lajuj ta ri xech'ajch'ojir-e riq'uin ri quiyabil? ¿Y ri beleje' chic? ");
INSERT INTO cak_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Man jun chic más xtzolij-pe richin nuruya' ruk'ij ri Dios? ¿Xaxe re jun achi man israelita ta re xtzolij-pe? ");
INSERT INTO cak_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jac'ari' xu'ij che: Cacataj y cabin. Riq'uin ri xcuke' ac'u'x riq'uin ri xin-ij-e chave, romari' xacolotaj chuvech ri ayabil, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Jac'a tok ri achi'a' fariseos xquic'utuj che ri Jesús chi ajan xtuka ri tiempo tok ja ri Dios xtibano gobernar, ri Jesús quire' xu'ij chique: Ru-gobierno ri Ajaf Dios, man jun retal na'ey chi nuka. ");
INSERT INTO cak_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Man jun xtiyo'on rutzijol y xtu'ij, ja c'o vave', o ja c'o chila', roma ru-gobierno ri Dios xa c'o chic chi'icojol, xcha' ri Jesús chique ri fariseos. ");
INSERT INTO cak_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jac'a chique ri ru-discípulos xu'ij: Xterila' k'ij tok rix bala ta xtijo' chi xtuka ta chic jun k'ij achel re k'ij re yinc'o iviq'uin yin ri xitak-pe richin xinalex chi'icojol. Pero man xtitz'et ta chic. ");
INSERT INTO cak_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ec'o c'a xque'in chive: Ja ri c'o vave'. Ja c'o chila', xquecha' chive. Pero rix man c'a quixbe, ni man que'itzekle'ej. ");
INSERT INTO cak_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Roma can achel ri coyopa' ri niyiq'uiyo', nik'alajin ri juc'an ruchi' ri rocaj hasta ri juc'an chic ruchi', quiri' yin ri xitak-pe richin xinalex chi'icojol tok xquipe chic jun bey, chiquivech conojel xquik'alajin-vi. ");
INSERT INTO cak_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nic'atzin chi na'ey na yik'ax chupan q'uiy k'axomal, itzel xquitz'et coma ri vinak ri ec'o vacami. ");
INSERT INTO cak_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y achel xbanataj pa ru-tiempo ri Noé, quiri' mismo xtibanataj chupan ri k'ij tok xquipe chic jun bey yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Roma pa ru-tiempo ri Noé, ri vinak ja pa ruvi' ri va'in, ri kumuj ya', ri yec'ule' y ri yequiyala' quimi'al pa c'ulubic benak-vi ri cánima, c'a ja tok xuka ri k'ij chi ri Noé xoc chupan ri arca, y xtiquer-pe ri camic job ri xq'uiso quichin conojel. ");
INSERT INTO cak_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Quiri' mismo pa ru-tiempo ri Lot. Ri vinak ja pa ruvi' ri va'in, ri kumuj ya', ri lok'oj, ri c'ayij, ri banoj tico'n y ri banoj tak jay benak-vi ri cánima. ");
INSERT INTO cak_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Jac'a ri k'ij tok xel-pe ri Lot pa Sodoma, xka-pe k'ak' y azufre chicaj pa ruvi' ri tinamit, y xuq'uis quik'ij conojel ri xecanaj can chiri'. ");
INSERT INTO cak_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Quiri' mismo xtibanataj chupan ri k'ij tok yin ri xitak-pe richin xinalex chi'icojol xquinuk'alajin. ");
INSERT INTO cak_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri k'ij ri', ri c'o-e pa terraza che ri racho, y ru-cosas xa ec'o can pa jay, man chic tika-pe ri pa jay richin yerelesaj-e. Ri nisamaj pa juyu', man chic titzolij-pe chiracho chuc'amic ri ruyo'on can pa jay. ");
INSERT INTO cak_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Tuka chi'ic'u'x ri xuk'asaj rixayil ri Lot. ");
INSERT INTO cak_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Roma xa achique na ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ri ruc'aslen, can xtril-vi. ");
INSERT INTO cak_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tivac'axaj c'a ri nin-ij chive: Ri ak'a' tok xtibanataj ri', eca'i' yever junan chuvech jun ch'at; jun xtuc'uax-e y ri jun chic xtiyo'ox can. ");
INSERT INTO cak_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Eca'i' ixoki' junan yejoc'on chuvech ca', jun xtuc'uax-e y ri jun chic xtiyo'ox can. ");
INSERT INTO cak_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eca'i' achi'a' ri junan yesamaj pa juyu', jun xtuc'uax-e y ri jun chic xtiyo'ox can. ");
INSERT INTO cak_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jari' tok ri discípulos xquic'utuj-apu che: Ajaf, ¿achique c'a lugar xtibanataj-vi ri quiri'? Ri Jesús xu'ij chique: Xa achique na lugar c'o-vi jun cuerpo caminak, chiri' yeka-vi ri c'uch, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jac'ari' tok ri Jesús xutzijoj c'a jun ejemplo chiquivech ri ru-discípulos richin nuc'ut chiquivech chi nic'atzin chi jumul niqui'en orar y man tiyamayo' ri cánima. ");
INSERT INTO cak_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Rija' xu'ij chique: Pa jun tinamit xc'uje' jun c'ojoy quichin vinak ri man nuxi'ij ta ri' chuvech ri Dios, y man jun cakale'n ri vinak chuvech. ");
INSERT INTO cak_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan ri tinamit ri', c'o jun malca'n-ixok ri ntel-ntoc riq'uin richin nuc'utuj che chi tuto' pa ruk'a' ri nibano oyoval che. ");
INSERT INTO cak_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y ri c'ojoy quichin vinak, q'uiy k'ij man nrojo' ta yeruc'ojoj achel ri nic'utux che roma ri ixok. Pero c'o jun k'ij quire' xunojij: Yin masque man ninxi'ij ta vi' chuvech ri Dios, nis-ta man jun cakale'n ri vinak chinuvech, ");
INSERT INTO cak_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero roma ri ixok re' ntel-ntoc viq'uin, más utz quenc'ojoj na achel nu'ij ri ley, man c'ate roma ri jumul nuka vave' xa xtik'ax nuc'u'x pa ruk'a'. Quiri' ri ejemplo xutzijoj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jari' tok ri Ajaf Jesús xu'ij: Tivac'axaj ri xu'ij ri c'ojoy quichin vinak ri man pa ruchojmil ta nic'ojon. ");
INSERT INTO cak_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Más quiri' xtu'on ri Dios chiquito'ic ri erucha'on chic, ri chi chak'a' chi pak'ij niqui'en orar. Man c'arunaj ta xtuya-pe ri niquic'utuj che. ");
INSERT INTO cak_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nin-ij c'a chive chi ri Dios cha'anin xqueruc'ojoj y pa ruchojmil xtu'on pa qui-cuenta. Jac'a tok yin ri xitak-pe richin xinalex chi'icojol xquipe chic jun bey, ¿c'a ec'o cami vinak ri c'a cukul na quic'u'x riq'uin ri Dios? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jac'ari' tok ri Jesús xutzijoj jun ejemplo chique ri vinak ri niquina-ka-qui' chi can choj ri quic'aslen, y man jun cakale'n niqui'en chique ch'aka' chic. Rija' quire' xu'ij: ");
INSERT INTO cak_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Ec'o ca'i' achi'a' xebe pa racho ri Dios richin xequibana' orar. Jun fariseo, y ri jun chic, c'uluy impuesto. ");
INSERT INTO cak_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri fariseo pa'el nu'on orar, y ri ru-oración ri nu'on xa richin ruyon nuya-ka ruk'ij, y quire' c'a nu'ij: Matiox ninya' chave, Nata' Dios, roma yin man yin junan ta quiq'uin ri ebanoy elak', nis-ta quiq'uin ri man choj ta yequibanala', y nis-ta quiq'uin ri niquic'amala-ka-qui' quiq'uin ri mana-ta achok riq'uin ec'ulan-vi, ni man yin junan ta riq'uin la jun c'uluy impuesto la'. ");
INSERT INTO cak_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yin ca'i' k'ij nin-en coch'on vayijal pa jun semana, y ronojel ri ninch'ec, ninvelesaj diezmo riq'uin richin ninya' chave rat. Quiri' nu'ij ri fariseo pa ru-oración. ");
INSERT INTO cak_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Jac'a ri c'uluy impuesto, c'a naj xpa'e-vi-apu richin nu'on orar. Rija' nis-ta nrojo' nuyec ri ruvech chicaj y can nutinila' roruc'u'x, y quire' nu'ij: Dios, tapokonaj nuvech, roma xa yin jun aj-mac chavech, nicha' pa ru-oración. ");
INSERT INTO cak_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Can kitzij nin-ij chive chi ri achi c'uluy impuesto man jun rumac rakalen xtzolij chiracho. Jac'a ri achi fariseo man quiri' ta. Roma xa achique na ri nuna' chi can c'o ruk'ij, xa xtikases ruk'ij. Jac'a ri nukasaj-ri', xti'an che chi can c'o ruk'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ja jun ri ac'ola' yec'amer-pe riq'uin ri Jesús richin nuya' ruk'a' pa quivi'. Tok ri discípulos xquitz'et ri', xqui'ij chique ri vinak chi man chic quequiq'uen-pe. ");
INSERT INTO cak_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jac'a ri Jesús xeroyoj-apu ri discípulos riq'uin, y xu'ij chique: Tiya' lugar chique ri ac'ola' chi yepe viq'uin yin, y man que'ik'at. Roma ri xque'oc pa ruk'a' ri Dios richin yeru'on gobernar, ja ri yebano che ri cánima achel cánima ri ac'ola'. ");
INSERT INTO cak_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Can kitzij nin-ij chive, ri man nu'on ta achel ránima jun ac'ual richin nuc'ul pa ránima ru-gobierno ri Dios, man ntoc ta chiquicojol ri ye'an gobernar roma rija', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","C'o c'a jun achi nitakchi'in pa quivi' ri vinak ri quire' xuc'utuj che ri Jesús: Tijonel, ¿achique nic'atzin chi nin-en yin richin quiri' c'o nuk'a' che ri utzulaj c'aslen ri richin jumul? xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jac'a ri Jesús xu'ij che: ¿Achique roma rat na'ij chi yin utz? Man jun utz, xaxe ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rat aveteman ruchojmil ri mandamientos. Chiri' nu'ij: Man tac'amala-ka-avi' riq'uin jun ri mana-ta achok riq'uin rat c'ulan-vi; man cacamisan; man catelak'; man tatz'uc tzij; taya' quik'ij ri ate-atata', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ronojel ri na'ij, yin c'a yin ac'ual na chiri' nubanon-pe, y c'a quiri' na vacami, xcha' ri achi che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ri Jesús tok xrac'axaj quiri', xu'ij che: C'a c'o chic jun man abanon ta. Tac'ayij ronojel ri achajin y ri rajil tajacha' chiquivech ri man jun oc quichajin, y xtic'uje' abeyomal chila' chicaj. C'ajari' catampe, quinatzekle'ej, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Tok ri achi xrac'axaj ri xu'ij ri Jesús, jani na xbison, roma rija' jun nimalaj beyon. ");
INSERT INTO cak_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Tok ri Jesús xutz'et chi xpe bis pa ránima, quire' xu'ij: Ri c'o quibeyomal, c'ayef chi ye'oc chiquicojol ri ye'an gobernar roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Más man c'ayef ta chi nik'ax jun chicop camello pa ch'uti rujulil jun bak richin t'iso'n, que chuvech ntoc jun beyon chiquicojol ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Jac'a ri ye'ac'axan-apu richin ri Jesús, quire' niquibila': Si kitzij achel ri nu'ij, man jun xticolotaj, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jac'a ri Jesús xu'ij chique: Ri manak che'el nibanataj pa quivech ri vinak, chuvech ri Dios c'o che'el nibanataj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jac'ari' tok ri Pedro xu'ij-apu: Tatz'eta' c'a, roj kayo'on can ronojel ri c'o kiq'uin richin rat katzekle'en, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xu'ij chique: Nis-ta jun chique ri ruyo'on can racho, rute-rutata', ruchak', runimal, rixayil o ralc'ua'l, roma ru-gobierno ri Dios, ");
INSERT INTO cak_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ri man ta xtuc'ul más jani na q'uiy chupan ri tiempo re', y chupan ri jun chic tiempo ri petenak chikavech apu, xtuc'ul ri c'aslen ri richin jumul, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jac'ari' xeruc'uaj-e quiyon ri doce ru-discípulos juc'an y quire' xu'ij chique: Rix iveteman chi pa tinamit Jerusalem roj jotol-vi-e, y chiri' xquebanataj-vi ronojel ri quitz'iban can ri profetas chi nibanataj viq'uin yin ri xitak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquijach pa quik'a' vinak man israelitas ta, xtitze'es nuvech, xquiyo'ox chi q'uix, xquichubex, ");
INSERT INTO cak_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","y tok yin quich'eyon chic, xquinquicamisaj. Pero chi rox k'ij, xquic'astaj-pe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jac'a ri discípulos man juba' (xk'ax, xno') chiquivech ri c'a ja oc xu'ij-ka ri Jesús chique. Roma xa can evan-vi chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tok ri Jesús ja ntoc-apu pa tinamit Jericó, chiri' chuchi' bey tz'uyul jun achi man nitzu'un ta nu'on limosna. ");
INSERT INTO cak_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jac'a tok ri achi ri' xrac'axaj chi q'uiy vinak yek'ax chiri', rija' xuc'utuj achique ri najin. ");
INSERT INTO cak_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y ri ec'o chiri' xqui'ij che chi ja ri Jesús aj-Nazaret ri nik'ax chiri'. ");
INSERT INTO cak_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Jac'ari' tok ri achi riq'uin ruchuk'a' xu'ij: ¡Jesús, rat ri rat riy-rumam can ri rey David, tapokonaj nuvech! xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Jac'a ri enabeynak chuvech ri Jesús, xquich'olij richin titane-ka. Pero rija' xa más cof xch'o-pe y xu'ij: ¡Rat ri rat riy-rumam can ri rey David, tapokonaj nuvech! xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Xpa'e-ka ri Jesús, xu'ij chi tic'amer-pe ri achi chuvech. Tok c'o chic apu ri achi, ri Jesús xuc'utuj che: ");
INSERT INTO cak_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Achique najo' chi nin-en chave? Ri achi xu'ij: Ajaf, yin ninjo' yitzu'un chic jun bey, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xu'ij che: Catzu'un chic c'a. Rat roma nanimaj chi yac'achoj, romari' xatzu'un chic, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jac'ari' xtzu'un chic jun bey ri achi, y nuyala' ruk'ij ri Dios benak chirij ri Jesús. Conojel c'a ri xetz'eto ri xbanataj, niquiyala' ruk'ij ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Tok ocunak chic apu ri Jesús pa tinamit Jericó, rija' ja nik'ax-e chiri' benak. ");
INSERT INTO cak_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Chiri' pa tinamit c'o jun achi beyon rubinan Zaqueo, jun uc'uay quibey ri c'uluy tak impuestos. ");
INSERT INTO cak_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rija' can nutij ruk'ij nrojo' nutz'et-e ri Jesús, pero man nitiquer ta, roma eq'uiy vinak, y rija' xa co'ol oc rupalen. ");
INSERT INTO cak_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Romari' junanin xnabeyaj-e, xjote' chuk'a' jun che' sicómoro, richin nitiquer nutz'et-e ri Jesús, roma ja ri chiri' nik'ax-vi-e. ");
INSERT INTO cak_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jac'a tok nik'ax ri Jesús chiri' chuxe' ri che', rija' xtzu'un-e chuk'a', xutz'et-e ri Zaqueo, y xu'ij-e che: Zaqueo, caka-pe chiri' cha'anin, roma vacami nic'atzin yinuxlan chi'avacho, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Junanin c'a xka-pe ri Zaqueo chuk'a' ri che', y niquicot xuc'ul ruvech ri Jesús chiracho. ");
INSERT INTO cak_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tok ri vinak xquitz'et re', conojel yejasloj-apu chirij ri Jesús, y niquibila' chi xa chiracho jun achi aj-mac xc'uje-vi-ka. ");
INSERT INTO cak_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Xpa'e' c'a ri Zaqueo, xu'ij che ri Ajaf: Ajaf, vacami nic'aj che ri nubeyomal ninjach chiquivech ri man jun oc quichajin. Y ri xk'ax ruvi' ri impuesto ri xinc'utuj chique, cajcaj ruq'uexel xtintzolij chique chuvech ri ajani velek'an, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xu'ij che: Vacami xril k'ij chi ri ec'o chupan ri jay re' yecolotaj, xcha'. Roma ja jun rat Zaqueo, rat jun chique ri eriy-rumam ri Abraham. ");
INSERT INTO cak_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Roma yin ri xitak-pe richin xinalex chi'icojol, xipe richin yencanoj y yencol ri esatznak, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Tok ri vinak quic'axan chic ka ronojel ri xu'ij ri Jesús, rije' xquinojij chi xe xtoc-apu ri pa tinamit Jerusalem, jari' nitiquer-e ru-gobierno ri Dios pa quivi'. Y roma quiri' niquinojij, y roma xa nakaj chic ec'o-vi che ri Jerusalem, romari' ri Jesús xutzijoj jun ejemplo chique. ");
INSERT INTO cak_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Rija' quire' xu'ij: C'o jun achi c'o ruk'ij xbe pa jun roch'ulef naj, richin nijach-pe autoridad pa ruk'a' richin ntoc-pe rey, c'ajari' nitzolij-pe. ");
INSERT INTO cak_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero na'ey chi xbe, xeroyoj lajuj rusamajela' y chiquijununal xuya' can méra pa quik'a' ri achel nuch'ec jun samajinel oxi' ic', y xu'ij can chique: Tisamajij ri méra re', c'a ja tok xquitzolij-pe yin, xcha' can. ");
INSERT INTO cak_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Jac'a ri ruvinak xa itzel niquitz'et ri achi c'o ruk'ij, romari' tok benak chic, rije' xequicha' achi'a' richin xequitak-e chirij, richin xbequi'ij: Roj man nikajo' ta chi ri achi re' ntoc rey pa kavi'. Quiri' xqui'ij ri etakon-e. ");
INSERT INTO cak_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero tok ri achi rey chic chiri', jari' xtzolij-pe, y xutak c'a coyoxic ri rusamajela' ri ruyo'on can méra pa quik'a', richin nrojo' nretemaj achique chi ch'acoj xqui'en chiquijununal. ");
INSERT INTO cak_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Xpe ri na'ey samajinel y quire' xu'ij: Ajaf, ri améra ri ayo'on can pa nuk'a', xuch'ec chic lajuj pa ruvi', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Jac'ari' tok ri rey xu'ij che: Can utz ri xa'an, utzulaj samajinel. Rat roma utz rusamajisic xa'an ri juba' méra xinya' can pan ak'a', vacami yatinya' pa ruvi' lajuj tinamit richin na'an gobernar pa quivi', xcha' ri rey. ");
INSERT INTO cak_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Xpe ri ruca'n samajinel, xu'ij: Ajaf, ri améra ri ayo'on can pa nuk'a', xuch'ec chic vo'o' pa ruvi', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Jac'ari' tok ri rey xu'ij che: Ja jun rat yatinya' chi na'an gobernar, y pa quivi' vo'o' tinamit yatinya-vi, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Xpe chic c'a jun samajinel, xu'ij: Ajaf, jare' ri méra ri ayo'on can pa nuk'a'. Yin xinyec ri améra pa jun páya. ");
INSERT INTO cak_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Roma ninxi'ij-vi' chavech. Roma rat man jun asamajinel napokonaj ruvech, najo' nac'ul rajil samaj ri mana-ta rat rat banayon, y najo' nac'ol ruvech tico'n ri mana-ta rat rat tiquiyon-ka, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Jac'a ri rey xu'ij che: Rat xa rat jun itzel samajinel. Ja mismo ri atzij xtincusaj chavij richin ninc'ut chavech achique ri amac. Rat na'ij chi yin man jun nusamajinel ninpokonaj ruvech, y ninjo' ninc'ul rajil samaj ri mana-ta yin yin banayon, y ninjo' ninc'ol ruvech tico'n ri mana-ta yin yin tiquiyon-ka. ");
INSERT INTO cak_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Si rat quiri' na'ij, ¿achique roma man xaya' ta ri numéra pa banco? Richin quiri' ri xitzolij-pe vacami, ja ta xinc'ul ri numéra y ri ajani ruch'acon-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Jac'ari' xu'ij chique ri ec'o chiri': Tic'ama' can la méra che, y tiya' che ri nusamajinel ri c'o chic lajuj riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Jac'a rije' xqui'ij: Ajaf, pero la' c'o chic lajuj riq'uin, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero yin nin-ij chi conojel ri utz rusamajisic niqui'en che ri yo'on can pa quik'a', xtiquic'ul más. Jac'a ri man niquisamajij ta ri juba' yo'on can pa quik'a', hasta ri juba' c'o quiq'uin xteleses chique. ");
INSERT INTO cak_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Pero ri itzel yinquitz'et y man xcajo' ta chi yin xinoc rey pa quivi', que'ic'ama-pe, y chinuvech que'icamisaj-vi, xcha' ri rey. Quiri' ri ejemplo ri xu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Tok ri Jesús xtane' chubixic ri ch'abel re', (xutz'om, xuchop) chic e bey richin nijote-e pa tinamit Jerusalem, y ja rija' k'axnak-e chiquivech ri ebenak riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jac'a tok nakaj chic c'o-vi-apu chique ri ca'i' aldea Betfagé y Betania ri achique lugar c'o-vi ri juyu' rubinan Olivos, ri Jesús xerutak-apu ca'i' ru-discípulos chiri', ");
INSERT INTO cak_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y quire' xu'ij-e chique: Quixbin-apu chupan la aldea la', y xa can xe xquixoc-apu, chiri' nivil jun alaj burro ximil, ri c'a man jani (tich'oque', titz'uye') jun vinak chirij. Tisolo-pe y tic'ama-pe chuve. ");
INSERT INTO cak_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si c'o jun xti'in-pe chive chi achique roma nisol-pe ri alaj burro, rix quire' ti'ij che: Nic'atzin che ri Ajaf, quixcha' can. ");
INSERT INTO cak_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xebe c'a ri ca'i' discípulos ri xetak-e, y can xquil-vi ri achel bin-e chique roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ja niquisol ri alaj burro chiri', tok ri erajaf xqui'ij-pe: ¿Achique roma nisol ri ch'uti avaj? xecha-pe. ");
INSERT INTO cak_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y rije' xqui'ij-apu: Roma ri Ajaf nic'atzin che, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jac'ari' xquiq'uen-pe ri ch'uti avaj che ri Jesús. Tok quiyo'on chic e jujun quitziak chirij ri alaj burro, xquiya-e ri Jesús chirij. ");
INSERT INTO cak_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jac'a ri vinak niquiriq'uila-ka jujun quitziak pa rubey ri Jesús, y quiri' niquibanala' ebenak. ");
INSERT INTO cak_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Tok nakaj chic ec'o-vi che ri xulan ruvech bey richin ri juyu' Olivos, conojel tzekle'ey richin ri Jesús jani na yequicot xetiquer-pe chi riq'uin cuchuk'a' niquiya' ruk'ij ri Dios roma ronojel ri nimalaj tak milagros ri quitz'eton riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Rije' niquibila': ¡Nimalaj favor c'o pa ruvi' ri Rey re petenak pa rubi' ri Ajaf. Chila' chicaj chojmirisan chic ri uxlanen richin ri kánima. Y nimalaj ruk'ij nuc'ul ri Dios chiri'! yecha'. ");
INSERT INTO cak_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Chiquicojol ri ebenak chirij ri Jesús, ec'o jujun achi'a' fariseos ri quire' xqui'ij-apu che: Tijonel, ta'ij chique la tzekle'ey avichin chi quetane-ka, xecha-apu che. ");
INSERT INTO cak_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jac'a ri Jesús xu'ij chique: Si rije' yetane-ka, xa ja ri abaj xquech'o-pe richin niquiya' nuk'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y tok ri Jesús c'o chic apu nakaj che ri tinamit Jerusalem, xrok'ej ruvech tok xutz'et, ");
INSERT INTO cak_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xu'ij: ¡Oh aj-Jerusalem! Ja jun ta c'a rix, masque c'a ja ta ri k'ij re' nivetemaj achique nuq'uen-pe pan ivánima ri uxlanen ruchojmirisan ri Dios chi'icojol riq'uin rija'. Pero vacami xa evan chivech. ");
INSERT INTO cak_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Roma xa xque'uka k'ij c'ayef pan ivi', tok ri vinak coyoval chive xtiquitz'apij rij ri itinamit riq'uin jun chic muro, y xa xquixquiya' pa nic'aj. Xquixquilatz'atz'ej richin manak chic che'el xquixenimaj-e. ");
INSERT INTO cak_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","(Xtiquivulaj, xtiquivulij) ri itinamit, y ja jun rix xquixquitorij pan ulef. Man jun abaj xtiquiya' can pa ruvi' jun chic abaj. Quiri' xtibanataj iviq'uin roma man xijo' ta xivetemaj chi ja ri Dios ri xuka yan iviq'uin chi'ito'ic, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Tok ri Jesús xoc-apu pa racho ri Dios, (xutz'om, xuchop) pe cokotaxic ri yec'ayin y ri yelok'on chiri', ");
INSERT INTO cak_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","y xu'ij chique: Chupan ri tz'iban can, ri Dios nu'ij: Ri vacho, jay richin oración. Jac'a rix xa quijul elek'oma' ibanon che, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ri Jesús k'ij-k'ij yerutijoj ri niquimol-qui' chiri' pa racho ri Dios. Pero ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' q'uiy queteman chirij ri ley y ri israelitas c'o quik'ij, niquicanola' achique ta niqui'en richin niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero man niquil ta achique niqui'en che, roma ri tinamit benak cánima riq'uin ri nu'ij ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun chique ri k'ij tok ri Jesús ja yerutijoj ri vinak pa racho ri Dios, y ja nutzijoj ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj, jari' tok xe'eka ri nima'k tak quik'ij sacerdotes israelitas, ri achi'a' q'uiy queteman chirij ri ley, y ri nima'k quijuna' achi'a' c'o quik'ij riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Rije' quire' xqui'ij che: Ta'ij chike: ¿Achique ak'a' rat chi ye'abanala' ronojel ri yatajin riq'uin? Y, ¿achique x-in chave chi quire' que'abanala'? xecha' che. ");
INSERT INTO cak_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ri Jesús xu'ij chique: Quiri' mismo yin, c'o jun ninjo' ninc'utuj chive. Ti'ij-pe chuve: ");
INSERT INTO cak_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Tok ri Juan xeru'on bautizar ri vinak, ¿Dios cami biyon-pe che, o xa vinak? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jac'a rije' niquichok'omayila' chiquivech y niqui'ij: Si xtika'ij chi ri Juan ja ri Dios takayon-pe, ri Jesús xtu'ij chike chi achique roma man xkanimaj ta. ");
INSERT INTO cak_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jac'a si xtika'ij chi xa vinak xe'in che ri Juan, chi jun tinamit nkojquic'ak che abaj, roma chiquivech rije', ri Juan can profeta vi. ");
INSERT INTO cak_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jac'ari' xqui'ij-apu che ri Jesús chi man queteman ta achique x-in che ri Juan chi querubana' bautizar ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xu'ij chique: Quiri' mismo xtin-en yin, man xtin-ij ta chive ri achok riq'uin petenak-vi chi c'o nuk'a' chi yenbanala' quire', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jac'ari' tok ri Jesús quire' jun ejemplo xutz'uc rutzijosic chiquivech conojel: C'o jun achi xutic uva chuvech ri rujuyu', xuya' c'a can pa (k'uch, cuchubal) chique achi'a' ri xquesamajin ruvech y xbe layoj tiempo pa jun chic lugar. ");
INSERT INTO cak_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tok xril ruk'ijul, ri rajaf ri juyu' xutak-e jun rusamajinel quiq'uin ri yesamajin ruvech ri juyu' richin c'o che ri uva niquiya-pe che. Pero rije' xa xquich'ey-pe ri samajinel y man jun ruvech ri uva xquiya-pe che. ");
INSERT INTO cak_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ri rajaf ri juyu' xutak chic jun samajinel quiq'uin, pero ri yesamajin ruvech ri juyu', xa juye' ruvech xqui'en y xquich'ey-pe y man jun ruvech ri uva xquiya-pe che. ");
INSERT INTO cak_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ri rajaf ri juyu' xutak chic e jun rox samajinel, pero ja jun ri samajinel ri' socotajnak xcokotaj-pe. ");
INSERT INTO cak_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Jac'ari' tok ri rajaf ri juyu' quire' xunojij: ¿Achique nin-en vacami? Nintak na c'a e ri nuc'ajol ri can ninjo'; riq'uin juba' tok xtiquitz'et chi ja ri nuc'ajol ri xteka quiq'uin, xqueniman chuvech, xcha-ka pa ránima. ");
INSERT INTO cak_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Jac'a ri yesamajin ruvech ri juyu', tok xquitz'et chi ja ruc'ajol rajaf ri juyu' ri xeka quiq'uin, layoj xenojin pa ruvi' ri achique xtiqui'en, y xqui'ij: Jare' ntoc can rajaf ri juyu' re'. Quire' quixampe, kacamisaj, richin quiri' pa kak'a' roj nic'uje-vi can ri juyu', xecha'. ");
INSERT INTO cak_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Xquelesaj c'a pe ruc'ajol rajaf ri juyu' chiri' chupan ri juyu' ri tiquil-vi ri uva y xquicamisaj. Jac'ari' tok ri Jesús xu'ij: ¿Achique cami xtu'on rajaf ri juyu' chique ri achi'a' ri'? ");
INSERT INTO cak_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Rija' xtipe y xquerucamisaj, y ri juyu' xtuya' chic can pa (k'uch, cuchubal) chique ch'aka' samajela', xcha' ri Jesús. Tok rije' xquic'axaj ronojel re', xqui'ij: ¡Man ta xtrojo' Dios chi quiri' nibanataj! xecha'. ");
INSERT INTO cak_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jac'a ri Jesús xerutz'et conojel, y xu'ij: Ti'ij na c'a chuve achique ruchojmil ri ruch'abel ri Dios ri tz'iban can ri nu'ij: Ri abaj ri man juba' xcajo' xquicusaj ri banoy tak jay, Xa jari' xc'atzin richin ruchuk'a' ruxiquini'l ri jay. ");
INSERT INTO cak_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Xa achique na jun xtitzak pa ruvi' ri abaj re', xtimulumu' chuvech. Jac'a ri achok chirij xtika-vi, nichiquicho' chuxe', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ri nima'k tak quik'ij sacerdotes israelitas, y ri achi'a' q'uiy queteman chirij ri ley, ja hora ri' xcajo' xjel quik'a' chirij ri Jesús, roma xquina'ej chi xa chiquij rije' nich'o-vi ri ejemplo ri xutzijoj. Pero xa niquixi'ij-qui' chiquivech ri tinamit. ");
INSERT INTO cak_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Roma c'a ri', ec'o xequitak-pe ri niquibananej-apu chuvech ri Jesús chi can echojmilaj tak achi'a', pero xaxe richin niquiya-apu pa cuenta ri Jesús. Roma nicajo' chi can ta nika pa quik'a' riq'uin ri yerubila', richin quiri' niquijach pa ruk'a' ri achi c'o ruk'a' richin nu'on gobernar. ");
INSERT INTO cak_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ri xetak-apu riq'uin ri Jesús, xquic'utuj che: Tijonel, roj keteman chi rat pa ruchojmil yatzijon y pa ruchojmil ye'atijoj ri vinak. Y man na'an ta chi jun vinak más c'o ruk'ij que chuvech jun chic, xa pa ruchojmil nac'ut rubey ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ta'ij c'a chike: Ri impuesto ri nu'ij ri rey César chi tikatojo', ¿nuya' cami lugar ru-ley ri Dios chi nikatoj, o xa manak? xecha' che. ");
INSERT INTO cak_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jac'a ri Jesús reteman chi xa itzel tak no'oj c'o pa cánima chirij. Romari' xu'ij chique: ¿Achique roma nitij ik'ij chuvij chi nijo' yika pan ik'a'? ");
INSERT INTO cak_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'utu-pe jun méra chinuvech, xcha'. Jac'ari' xuc'utuj chique: ¿Achok ruvech y achok rubi' re c'o chuvech? xcha'. Richin ri rey César, xecha' che. ");
INSERT INTO cak_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xu'ij c'a chique: Tiya' che ri César ri can richin vi ri César y tiya' che ri Dios ri can richin vi ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y man jun ch'abel xquil ri man ta pa ruchojmil xu'ij ri Jesús chiquivech. Can achique na xquina' xquic'axaj ri xu'ij, romari' man chic xech'o ta apu. ");
INSERT INTO cak_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ec'o c'a jujun achi'a' saduceos xe'ech'o riq'uin ri Jesús. Ri saduceos man niquinimaj ta chi ri anima'i' xquec'astaj chic, y romari' quire' c'a xquic'utuj che ri Jesús: ");
INSERT INTO cak_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Tijonel, ri Moisés quire' rutz'iban can chike: Jun achi tok c'o jun ruchak' o runimal (nicom, niquen) e, nic'atzin chi rija' nic'ule' riq'uin ri ixok xmalcanij can, si ri ixok manak ral xc'uje', richin nic'uje' ral ri xa pa rubi' ri ámna niyo'ox-vi-ka. ");
INSERT INTO cak_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Quiri' xbanataj jun bey quiq'uin vuku' achi'a' quichak'-quinimal qui'. Ri na'ey xc'ule', pero (xcom, xquen) e, y man jun ralc'ua'l xc'uje'. ");
INSERT INTO cak_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Ri ruca'n achi xc'ule' riq'uin ri malca'n-ixok, pero xa (xcom, xquen) e, y man jun ralc'ua'l xc'uje'. ");
INSERT INTO cak_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Xpe ri rox achi xc'ule' riq'uin ri malca'n-ixok, y xa achel xqui'en-e ri eca'i' na'ey, quiri' mismo xu'on-e rija'. Chi vuku' achi'a' quiri' xqui'en-e, y man jun xc'uje' ralc'ua'l riq'uin ri ixok. ");
INSERT INTO cak_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisbel (xcom, xquen) e ri ixok. ");
INSERT INTO cak_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Rat na'ij chi c'o na jun k'ij xquec'astaj-pe ri anima'i'. Tok xtuka ri k'ij ri', ¿achique chique ri vuku' achi'a' re' xtoc rachijil ri ixok tok chi vuku' xe'oc-e rachijil? xecha' ri saduceos. ");
INSERT INTO cak_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús xu'ij chique: Vave' choch'ulef ri vinak c'a yec'ule' na, y c'a niquiya' na quitzij richin c'ulubic. ");
INSERT INTO cak_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jac'a ri xtik'alajin pa quic'aslen chi can utz vi chi xtiyo'ox lugar chique chi xquec'uje' chupan ri jun chic apu tiempo, y chi yec'astaj-e chiquicojol ri anima'i', man chic xquec'ule' ta, ni manak chic xtiquiya' quitzij richin c'ulubic. ");
INSERT INTO cak_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Roma rije' manak chic ruk'a' ri camic chique, roma xa xque'oc achel ri ángeles y eralc'ua'l ri Dios roma yeyac-e chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Jac'a chi ri anima'i' yec'astaj, can yec'astaj-vi. Roma hasta chupan ri rutz'iban can ri Moisés ri nich'o pa ruvi' ri (xulu-quiej, zarza), nik'alajin-vi tok nu'ij chi ri Dios can ru-Dios ri Abraham, ru-Dios ri Isaac, y ru-Dios ri Jacob. ");
INSERT INTO cak_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Roma ri Dios man qui-Dios ta ri ecaminak, rija' qui-Dios ri c'o quic'aslen. Roma chuvech rija' eq'ues chiconojel, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y c'o chique ri achi'a' q'uiy queteman chirij ri ley ri xqui'ij-apu che ri Jesús: Tijonel, can kitzij vi ri xa'ij, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Quiri' xqui'ij-apu, roma man chic xquicovij ta qui' richin c'o más xquic'utuj-apu che ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jac'ari' tok ri Jesús xu'ij chique: ¿Achique roma ni'ix chi ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit xa choj jun riy-rumam can ri rey David? ");
INSERT INTO cak_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tok mismo ri rey David quire' ru'in can chupan ri vuj Salmos: Ri Ajaf Dios quire' xu'ij che ri Vajaf: Catz'uye-pe pa nu-derecha, ");
INSERT INTO cak_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","C'a ja tok xquenya' chuxe' avakan ri itzel yatquitz'et. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y si ri rey David Vajaf nicha' che, ¿achique roma ni'ix chi xa choj jun riy-rumam can ri rey David? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Conojel ri quimolon-qui' chiri' xquic'axaj tok ri Jesús quire' xu'ij chique ri ru-discípulos: ");
INSERT INTO cak_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Man c'a ti'en achel niqui'en ri achi'a' q'uiy queteman chirij ri ley. Roma rije' nika chiquivech niquicusaj jucujak tak tziek richin quetz'etetaj chi c'o quik'ij; nika chiquivech chi ye'an saludar ri niquimol-vi-qui' ri vinak ri pa tak bey, y nika chiquivech yetz'uye' ri pa na'ey tak ch'aquet ri pa tak sinagogas y ri pa tak va'in. ");
INSERT INTO cak_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Jabel yeno' (chubanic, cho'onic) richin c'o niquelek'aj chique ri malcani' tak ixoki'. Y xaxe richin quenimex, yelayoj riq'uin ri oración. Romari', más q'uiy castigo xtika pa quivi', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri Jesús xtzu'un c'a apu y xerutz'et ri beyoma' ri niquiyala' can qui-ofrenda chupan ri caja ri niyo'ox-vi ri ofrenda pa racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","(Chuka', ka) xutz'et chi c'o jun malca'n-ixok ri man jun oc ruchajin ri xuya' can ca'i' ruvech tak méra. ");
INSERT INTO cak_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jac'ari' quire' xu'ij chique ri ru-discípulos: Kitzij nin-ij chive chi la malca'n-ixok la man jun oc ruchajin, más q'uiy ofrenda xuya' que chiquivech conojel ri xquiya' can méra. ");
INSERT INTO cak_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Roma conojel ri xeyo'on can méra richin ru-ofrenda ri Dios, xa ruvi' che ri quibeyomal xquiya' can. Jac'a ri ixok re', ronojel ri juba' c'o riq'uin richin nutzuk-ri' xuya' can chi ofrenda, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ec'o jujun yetzijon chiquivech, y niqui'ij chi ri racho ri Dios, ruyon nima'k tak cajil abaj cusan riq'uin, y niqui'ij chi ruyon sipanic ri achok che vikon-vi. Jac'a ri Jesús xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ronojel ri nitz'et re', c'o na jun k'ij tok man jun chic abaj xtic'uje' can pa ruvi' jun chic abaj ri man ta xquevulutaj-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jac'ari' tok ri discípulos quire' xquic'utuj che ri Jesús: Tijonel, ¿achique tiempo xquebanataj ri xa'ij-ka chirij racho ri Dios? Y, ¿achique retal xtik'alajin richin nina'ex chi juba' chic nrojo' chi yebanataj? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jac'a ri Jesús xu'ij chique: Rix tibana' cuenta ivi' richin quiri' man jun tisatzo ino'oj. Roma c'o q'uiy xquepe ri xtiquik'ebaj-qui' chirij ri nubi' yin, y xtiqui'ij: Ja yin ri Jun ri yin takon-pe chucolic rutinamit ri Dios. Ja tiempo re' xuka, xquecha'. Pero rix man que'itzekle'ej. ");
INSERT INTO cak_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Tok xtivac'axaj chi c'o guerras najin choch'ulef, y chi ec'o yecataj chiquij ri qui-gobierno, man c'a tixi'ij-ivi'. Roma nic'atzin chi na'ey na nibanataj quiri', pero man ja yan ta ri' ri k'ij tok nitz'akat ronojel ri runojin ri Dios chi nibanataj choch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","(Chuka', ka) quire' xu'ij chique: Ec'o tinamit xquecataj chiquij ch'aka' chic tinamit. Ec'o reyes xquequitak soldados chiquij ch'aka' chic reyes. ");
INSERT INTO cak_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xquebanataj nimalaj tak cobrakan, xquepe vayijal y yabil pa jalajoj tak lugares choch'ulef, y xquebanataj ri jani na nixibin y nimalaj tak retal ri chicaj. ");
INSERT INTO cak_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero na'ey chi nibanataj ronojel re', rix xti'an pokon chive. (Xquixtz'am, xquixchap) y xquixjach pa tak sinagoga y pa tak cárcel. Xquixuc'uax chiquivech reyes y gobernadores roma ri nubi' yin. ");
INSERT INTO cak_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jac'ari' xquixtiquer xtiya' nutzijol yin chiquivech rije'. ");
INSERT INTO cak_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Roma c'a ri', rix tiya' pan ivánima chi man nic'atzin yan ta ninojij ri achique xti'ij richin nito-ivi'; ");
INSERT INTO cak_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","roma yin xtinya' ch'abel y no'oj chive ri nis-ta jun chique conojel ri xquecataj chivij ri xticaney ch'abel riq'uin o xtitiquer xtutzolij ruvech itzij. ");
INSERT INTO cak_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Hasta ja jun ri ite-itata', ri ichak'-inimal, ri (ivalpachel, ivaj-c'uaxel) o ri i-amigos ri xquixjacho richin yixyo'ox pa k'axomal, y ec'o chive xquecamises. ");
INSERT INTO cak_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Itzel xquixtz'et coma conojel roma iniman ri nubi' yin. ");
INSERT INTO cak_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero nis-ta jun rusumal ivi' ri choj quiri' xtisatz can. ");
INSERT INTO cak_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Rix riq'uin ri cof xquixc'uje' chirakan ri Dios chupan ri pokon ri xti'an chive, can xquixcolotaj-vi. ");
INSERT INTO cak_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Pero tok xtitz'et chi ri tinamit Jerusalem yo'on pa nic'aj coma soldados, tivetemaj chi ja xril k'ij chi ri tinamit niq'uis ruk'ij. ");
INSERT INTO cak_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Tok xtitz'et quiri', ri ec'o pa Judea, que'enimaj-e pa tak juyu'. Ri ec'o pa tinamit Jerusalem, que'el-pe chiri'. Ri ec'o pa tak juyu', man chic quetzolij-apu pa tinamit. ");
INSERT INTO cak_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Roma ja tak k'ij ri', richin niyo'ox rajil-ruq'uexel ri man utz ta ri ebanalo'n, richin quiri' nibanataj ronojel ri tz'iban can chupan ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Pero, ¡tok'ex quivech ri ixoki' ri quiri' quibanon y ri c'a yetz'uman na ac'ola' chiquik'a' chupan tak ri k'ij ri'! Roma xa xtipe jun nimalaj k'axomal pa ruvi' ri qui-lugar ri israelitas, y can xtika na vi royoval ri Dios pa quivi' ri tinamit re'. ");
INSERT INTO cak_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ec'o c'a xquecamises chutza'n espada. Jac'a ri xquecolotaj chuvech ri camic, xque'uc'uax preso juc'an tak roch'ulef. Y ri tinamit Jerusalem xtoc pa quik'a' man israelitas ta, c'a ja xtitz'akat ri k'ij ri yo'on chique ri vinak ri'. ");
INSERT INTO cak_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","C'o c'a retal xquebanataj chuvech ri k'ij, ri ic' y ri ch'umila'. Re choch'ulef, ri vinak man juba' ta oc ruk'axon cánima, y man niquil ta achique niqui'en, roma ri mar nik'ajan y nibolkotilan. ");
INSERT INTO cak_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Xqueyamayo-ka pan ulef roma niquinojij ri xquebanataj choch'ulef y roma quixi'in-qui'. Roma ronojel ri uchuk'a' ri erichin chicaj xquesilon. ");
INSERT INTO cak_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Jac'ari' xquinquitz'et yin ri xitak-pe richin xinalex chi'icojol, chi yin petenak pa jun sutz', riq'uin uchuk'a' y nimalaj nuk'ij. ");
INSERT INTO cak_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jac'a rix, tok xtitz'et chi ronojel re' najin chic, quixquicot y tic'uje' más ruchuk'a' ri ivánima, roma xa nakaj chic c'o-vi icolic ri xtu'on ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jac'ari' tok rija' xu'ij chic jun ejemplo chique: Titz'eta' ri che' higo o xa achique na jun che'. ");
INSERT INTO cak_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tok nitz'et chi ja yejotayin-pe ri ruk'a' y ye'el-pe c'ac'ac' tak ruxak, rix iveteman chi nuka yan ru-tiempo ri job. ");
INSERT INTO cak_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Quiri' mismo, tok xtitz'et chi yebanataj chic ronojel ri xin-ij yan ka chive, tivetemaj chi nakaj chic c'o-vi ri k'ij chi conojel ye'an gobernar roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kitzij nin-ij chive chi ronojel re' xquebanataj tok ri vinak richin ri vacami c'a man jani queq'uis-e choch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ri roch'ulef y ri caj can xqueq'uis na vi, pero ri nuch'abel man xtiq'uis ta, xa can xquebanataj-vi ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jac'a rix tibana' cuenta ivi'. Man ti'e ivánima chirij ri va'in; man quixk'aber; man xaxe ri nic'atzin chive chuvech ri roch'ulef ri tinojij, roma riq'uin juba' man jun ina'en chiri' tok xtuka ri k'ij chi yin xquinuka. ");
INSERT INTO cak_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xa xtibanataj achel nu'on jun (pata'y, trampa) tok nika jun chicop chupan. Quiri' xtu'on tok xtuka ri k'ij ri' pa quivi' conojel vinak ri ec'o choch'ulef. ");
INSERT INTO cak_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Roma c'a ri', quinivoyo'ej-apu, jumul c'a tic'utuj che ri Dios chi rix yixtz'etetaj chi man nuc'ul ta chi yixk'ax chupan ronojel re k'axomal ri xtipe, y tz'akat ta c'a ri ic'aslen ne'ic'utu-ivi' chinuvech yin ri xitak-pe richin xinalex chi'icojol, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pak'ij, ri Jesús yerutijoj ri vinak chiri' pa racho ri Dios, y chak'a' ntel-e pa tinamit richin nec'uje' pa juyu' Olivos. ");
INSERT INTO cak_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nisakar-nisakar eq'uiy vinak nequimolo-qui' riq'uin richin niquic'axaj ri nutzijoj rija' pa racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Juba' chic nrojo' chi nuka ruk'ijul ri quinimak'ij ri israelitas tok niquitij ri pan manak levadura riq'uin, jun nimak'ij ri ni'ix pascua che. ");
INSERT INTO cak_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ri nima'k tak quik'ij sacerdotes israelitas, y ri achi'a' q'uiy queteman chirij ri ley niquicanola' achique ta niqui'en richin niquicamisaj ri Jesús, pero xa niquixi'ij-qui' chiquivech ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Jac'ari' tok ri Satanás xoc pa ránima ri Judas ri ni'ix Iscariote che. Rija' jun chique ri doce ru-discípulos ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ri Judas ri' xbe quiq'uin ri nima'k tak quik'ij sacerdotes israelitas, y quiq'uin ri e'uc'uayon quichin ri yechajin ri racho ri Dios richin xu'ij chique ri achel xtu'on richin nujach ri Jesús pa quik'a'. ");
INSERT INTO cak_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rije' xequicot xquic'axaj y xecanaj riq'uin chi niquiya' méra che. ");
INSERT INTO cak_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Xuya' c'a rutzij ri Judas chique richin nujach ri Jesús pa quik'a', y nucanola' c'a achel xtu'on chi can ta che'elek'el chiquivech ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tok xuka ri k'ij chi nitij ri pan manak levadura riq'uin, ri k'ij tok nic'atzin chi yecamises ri ovejas richin ri pascua, ");
INSERT INTO cak_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ja k'ij ri' ri Jesús xerutak-e ri Pedro y ri Juan, y xu'ij-e chique: Quixbin y tibana' rubanic ri xtikatij chupan ri pascua re'. ");
INSERT INTO cak_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Jac'a rije' xquic'utuj che: ¿Achique lugar najo' chi nika'an-vi rubanic? ");
INSERT INTO cak_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Rija' xu'ij-e chique: Titz'eta' c'a, tok xquixoc-apu pa tinamit Jerusalem, xtic'ul jun achi ruc'amon-pe jun (cucu', k'e'l) ya'. Titzekle'ej-e, c'a achique na jay xtoc-vi. ");
INSERT INTO cak_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y quire' ti'ij che ri rajaf-jay: Ri Tijonel quire' nu'ij chave: ¿Achique lugar c'o-vi ri cuarto vave' chi'avacho ri utz chi nin-en-vi ri va'in richin ri pascua quiq'uin ri nu-discípulos? quixcha' che. ");
INSERT INTO cak_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Jac'ari' xtuc'ut jun mama cuarto chivech pa ruca'n piso che ri racho. Ja chiri' tibana-vi rubanic ronojel, xcha-e chique. ");
INSERT INTO cak_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xebe c'a ri ca'i' discípulos, y can xquil-vi ri achel ru'in-e ri Jesús chique. Chiri' c'a xqui'en-vi rubanic ronojel ri xtic'atzin chique chupan ri nimak'ij pascua. ");
INSERT INTO cak_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Tok xril hora richin ri va'in, ri Jesús xtz'uye-apu chuchi' ri mesa y ja jun ri apóstoles xetz'uye-apu riq'uin. ");
INSERT INTO cak_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Rija' xu'ij c'a chique: Jani na rurayin ri vánima chi junan nika'an can ri va'in richin ri jun pascua re' na'ey chuvech ri nucamic. ");
INSERT INTO cak_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Roma yin nin-ij chive chi man chic xtintij ta re pascua c'a ja tok xtitz'akat ronojel ri nuc'ut ri jun va'in re' chi xtibanataj pa ru-gobierno ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jac'ari' xuq'uen-apu ri vaso richin ri pascua, y tok rumatioxin chic che ri Dios, xu'ij: (Titz'ama', tichapa') re' y tikumu' can juba' rupan chi'ijununal. ");
INSERT INTO cak_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Roma yin nin-ij chive chi man chic xtinkum ta re ruya'al-uva c'a xtuka na ri k'ij tok tz'akat xtu'on gobernar ri Dios pa ruvi' ronojel. ");
INSERT INTO cak_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jari' xuq'uen-apu ri pan richin ri pascua, xumatioxij che ri Dios, xuper c'a, xuya' chique ri ru-apóstoles y xu'ij: Jare' ri nu-cuerpo ri xtijach-e ivoma rix, y jun bey, jun bey tok nitij, richin c'uxle'el vichin yin tibana', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Quiri' mismo xu'on tok evayinak chic, xuq'uen-apu ri vaso y xu'ij: Ri vaso re', jare' retal ri c'ac'ac' ruvujil c'aslen ri xtic'achoj riq'uin ri nuquiq'uel ri xtibin ivoma rix. ");
INSERT INTO cak_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Pero ri achi ri xquijacho-e pa quik'a' ri vinak, xa c'o-pe vave' viq'uin chuchi' mesa. ");
INSERT INTO cak_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can kitzij na vi chi yin ri xitak-pe richin xinalex chi'icojol xquicamises, roma can quiri' vi runojin-pe ri Dios pa nuvi'. Pero, ¡tok'ex ruvech ri achi ri xtijacho-e vichin! xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jac'ari' tok ri discípulos xquitz'uc-ka ruc'utuxic chiquivech chi achique chique rije' ri xtijacho-e pa camic. ");
INSERT INTO cak_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Pero (chuka', ka) ri discípulos niquichok'omayila' chiquivech chi achique chique rije' ri más c'o ruk'ij. ");
INSERT INTO cak_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jac'a ri Jesús xu'ij chique: Ri reyes ri yebano gobernar choch'ulef, can ecajaf ri vinak niquina-qui', y ri c'o qui-autoridad, nika chiquivech ni'ix chique chi ebanoy favor. ");
INSERT INTO cak_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jac'a chi'icojol rix man tibanataj quiri'. Roma ri na'ey chi'icojol rix, xa tubana' chi ja rija' ri más co'ol chivech. Y ri uc'uay ivichin, toc-ka jun ri nito'on chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Quiri' nin-ij chive, roma chuvech ri roch'ulef, ja ri nilix-apu pa mesa ri más c'o ruk'ij que chuvech ri nilin-apu. Pero yin, yin achel ri yinilin-apu pa ruvi' mesa yinc'o chi'icojol. ");
INSERT INTO cak_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Y rix can rixc'o-pe viq'uin chupan ri k'axomal ri nuk'asan-pe. ");
INSERT INTO cak_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Roma c'a ri', yin xtinya' autoridad pan ik'a' richin ni'en gobernar achel rubanon-pe ri Nata' Dios chuve yin, ");
INSERT INTO cak_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","richin quiri' junan xquixva' y xtikum iya' viq'uin pa ruvi' ri nu-mesa chupan ri nu-gobierno, y xquixtz'uye' pa tak tz'uyubel c'o quik'ij richin ni'ij ri achique nic'atzin chi ni'an pa quivi' ri erichin ri doce tinamit richin ri Israel, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Xch'o chic ri Ajaf Jesús, y quire' xu'ij: Simón, Simón, tavac'axaj ri nin-ij chave: Ri Satanás xixruc'utuj richin yixruchayuj achel ni'an che ri trigo, y xyo'ox lugar che. ");
INSERT INTO cak_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero yin nubanon orar avoma, richin man tichup-ka jumul chi rat cukul ac'u'x viq'uin chupan ri chayuj ri xti'an chave. Y tok xtitzolij-pe avánima viq'uin, que'ato' ri ch'aka' chic nu-discípulos richin nic'uje' chic pe ruchuk'a' ri cánima chirakan ri Dios, xcha' che. ");
INSERT INTO cak_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Jac'a ri Simón xu'ij: Ajaf, yin nubanon che ri vánima chi yatintzekle'ej pa cárcel, o hasta pa camic, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero ri Jesús xu'ij che: Pedro, yin nin-ij chave chi chupan ri ak'a' re', na'ey chi nitzirikin-pe quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chi xa man aveteman ta nuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jac'ari' tok ri Jesús xuc'utuj chique ri ru-discípulos: Tok xixintak ri jun bey can, rix manak morral, méra, nis-ta jun chic par ixajab xic'uaj. ¿C'o cami xc'atzin chive y man ta xivil? Man jun, xecha' rije'. ");
INSERT INTO cak_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y xu'ij c'a chique: Jac'a ri vacami, ri c'o ru-morral, tutzalej-e. Ri c'o ruméra, tuc'uaj. Ri manak ru-espada, tuc'ayij jun rutziak y tulok'o' jun. ");
INSERT INTO cak_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quiri' nin-ij chive, roma can nic'atzin chi nibanataj viq'uin yin ri tz'iban can ri nu'ij: Achel jun aj-mac x-an che. Roma ri tz'iban can chupan ruch'abel ri Dios chuvij yin, can c'a yebanataj na, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jari' tok ri discípulos xqui'ij che: Ajaf, vave' c'o ca'i' espada, xecha'. Jac'a rija' xu'ij chique: Man chic tic'uxlaj-pe ri', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ri Jesús xel-e pa tinamit y xjote-e chuvech ri juyu' Olivos ri can ni'e-vi siempre. Y ja jun ri discípulos ebenak chirij. ");
INSERT INTO cak_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Tok c'o chic chiri', rija' xu'ij chique: Rix tibana' orar richin man yixtzak pa mac. ");
INSERT INTO cak_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jac'a rija' xbin-apu achel cami nika-vi jun abaj tok nac'ak, y chiri' xxuque-vi-ka richin nu'on orar. ");
INSERT INTO cak_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Nu'ij c'a pa ru-oración: ¡Papá! Si naya' pan avánima chi quiri', tabana' chi naj nik'ax-vi ri k'axomal re' chuve. Pero man ta'an ri ninrayij yin, xa ja ri najo' rat ri tibanataj, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Jac'ari' tok jun ángel petenak chicaj xuc'ut-ri' chuvech richin nuruya-ka ruchuk'a'. ");
INSERT INTO cak_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Riq'uin ri nimalaj ruk'axon ri ránima, ri Jesús más riq'uin uchuk'a' nu'on orar, y ri rutz'ajob can achel nima'k tak tz'uj quic' yeka pan ulef. ");
INSERT INTO cak_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jac'a tok xcataj-pe riq'uin ri oración, y xpe quiq'uin ri ru-discípulos, xa yever roma bis xu'urila'. ");
INSERT INTO cak_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Jac'ari' xu'ij chique: ¿Achique roma xa yixver? Quixcataj, tibana' orar, richin man yixtzak pa mac, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","C'a nich'o na ri Jesús quiq'uin chiri', tok xe'epapo' q'uiy vinak quiq'uin, y ja ri Judas, jun chique ri doce discípulos ri uc'uayon-apu quibey. Rija' xjel-apu riq'uin ri Jesús richin (xutz'ubaj, xutz'ub). ");
INSERT INTO cak_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jari' tok ri Jesús xu'ij che: Judas, ¿riq'uin jun tz'ub yinajach-e yin ri xitak-pe richin xinalex chi'icojol? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Tok ri discípulos xquitz'et ri xtebanataj, xquic'utuj che: Ajaf, ¿nkucataj chiquij riq'uin espada? xecha'. ");
INSERT INTO cak_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Jun chique rije' xusoc jun rusamajinel ri nimalaj sacerdote israelita; xutzaq'uij-e ruxiquin derecha che ri espada. ");
INSERT INTO cak_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jac'a ri Jesús xu'ij chique ri ru-discípulos: Tik'ata-ivi'. Man chic ti'en quila'. Xuya' c'a apu ruk'a' xe ruxiquin ri samajinel y xu'on che chi xc'achoj. ");
INSERT INTO cak_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jac'ari' xu'ij chique ri nima'k tak quik'ij sacerdotes israelitas, chique ri achi'a' uc'uay quichin ri yechajin racho ri Dios, y chique ri nima'k quijuna' achi'a' c'o quik'ij ri ebenak c'amoy richin: Yin mana-ta yin elek'on chi rix ic'amalo'n-pe che' y espada richin yinu'ic'ama'. ");
INSERT INTO cak_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","K'ij-k'ij xic'uje' iviq'uin pa racho ri Dios, y man (xinitz'om, xinichop) ta. Pero jare' ri hora yo'on chive, richin nuya' ruchuk'a' rajaf ri k'eku'n, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Tok c'o chic ri Jesús pa quik'a', xquic'uaj-e chojay che racho ri nimalaj sacerdote israelita. Jac'a ri Pedro xutzekle'ej ri Jesús, pero c'a naj c'o-vi can. ");
INSERT INTO cak_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Chiri' chojay, ri samajela' xquibox k'ak', y xetz'uye-apu chuchi'. Ja jun ri Pedro xtz'uye-apu chiquicojol. ");
INSERT INTO cak_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y c'o c'a jun aj-ic' chiri' ri xutz'et-apu chi tz'uyul ri Pedro chik'ak', layoj juba' xutz'et, jac'ari' xu'ij: Ja jun ri jun achi re' c'o riq'uin ri Jesús, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ri Pedro xa quire' xu'ij che: Ixok, yin man veteman ta ruvech ri Jesús, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Mier juba' chiri', c'o chic jun xtz'eto-pe richin ri Pedro, y xu'ij che: Rat, rat jun chique ri ec'o riq'uin ri Jesús, xcha'. Ri' man yin ta ri', xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Xk'ax cami jun hora chiri', tok c'o chic jun ri can xuya' ruchuk'a' rutzij richin xu'ij: Ri jun achi re', kitzij chi ja jun rija' c'o riq'uin ri Jesús, roma aj pa departamento Galilea, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero ri Pedro xu'ij che ri achi: Yin man veteman ta ri achique na'ij, xcha'. C'a nich'o na ri Pedro chiri', tok xtzirikin-pe quimama' ri ec'. ");
INSERT INTO cak_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Xtzu'un c'a pe ri Ajaf Jesús chirij y xutz'et-pe ri Pedro. Jari' tok ri Pedro xuc'uxlaj-pe chi ri Ajaf quire' ru'in can che: Na'ey chi nitzirikin-pe quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chique ri yec'utun chave chi man aveteman ta nuvech. ");
INSERT INTO cak_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Xel c'a e ri Pedro, xujik' ok'ej. ");
INSERT INTO cak_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ri achi'a' ri yechajin richin ri Jesús, yetze'en chirij y niquich'ey. ");
INSERT INTO cak_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xquitz'apij ruvech riq'uin jun tziek, niquiya' k'a' chupalaj, y niquic'utula-apu che: Tavila' achique yech'eyon avichin, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Q'uiy tak tzij niquibila' chupalaj. ");
INSERT INTO cak_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tok xsakar-pe, xquimol-qui' ri nima'k quijuna' achi'a' c'o quik'ij, ri nima'k tak quik'ij sacerdotes israelitas, y ri achi'a' q'uiy queteman chirij ri ley, xquic'uaj-apu ri Jesús ri achique lugar niquimol-vi-qui' richin niqui'en gobernar, y quire' xqui'ij che: ");
INSERT INTO cak_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ta'ij chike: ¿Ja rat ri Jun ri takon-pe roma ri Dios chucolic rutinamit? xecha' che. Ri Jesús xu'ij chique: Si nin-ij chive chi ja yin ri', man yininimaj ta. ");
INSERT INTO cak_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y si c'o ninc'utuj chive, rix man jun xti'ij-pe chuve, ni man xquinisok'opij ta e. ");
INSERT INTO cak_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero ja vacami nitiquer-e chi yin ri xitak-pe richin xinalex chi'icojol, xquinetz'uye' pa ru-derecha ri Dios ri achique lugar c'o-vi nimalaj ruchuk'a', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jac'ari' tok conojel xec'utun-apu che: ¿Ja rat ri Ruc'ajol ri Dios? xecha'. Rix mismo yix-in chi quiri', xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y rije' xqui'ij: ¿Achique chic más sujunic koyo'en chirij ri achi re'? Roma ja roj mismo riq'uin kaxiquin xkac'axaj ri xu'ij, xecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Quebuchma'y xecataj-e conojel, xquiq'uen-e ri Jesús richin xequijacha' pa ruk'a' ri gobernador Pilato. ");
INSERT INTO cak_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chiri' chuvech ri gobernador, niquisujuj-apu ri Jesús, y quire' c'a niqui'ij-apu: Roj katz'eton chi ri achi re' nuya' quino'oj vinak, nubila' chique chi can man tiquitoj ri impuestos che ri rey César. Nu'ij chi rija' jun rey, y chi ja rija' ri Jun ri takon-pe chucolic rutinamit ri Dios, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Jac'a ri Pilato xuc'utuj che: ¿Ja rat ri Rey quichin ri israelitas? xcha'. Ja', quiri', achel ri na'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Jac'ari' tok ri Pilato xu'ij chique ri nima'k tak quik'ij sacerdotes israelitas, y chique conojel ri quimolon-apu-qui' chiri': Yin man jun ch'o'oj ninvil chirij ri jun achi re', xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero rije' xa más riq'uin cuchuk'a' niquisujuj-apu y niquibila-apu: Rija' pa ronojel tinamit richin ri Judea yerutijoj-vi ri vinak richin eruyacon. Chila' pa Galilea rutz'ucun-vi-pe ri quiri' nubanala', y vacami ja xuka vave' pa tinamit Jerusalem, xecha-apu. ");
INSERT INTO cak_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Tok ri Pilato xrac'axaj chi ri Jesús pa departamento Galilea elenak-vi-pe, rija' xuc'utuj si aj-Galilea. ");
INSERT INTO cak_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tok xbix che chi ja', rija' xu'ij chi tejach ri Jesús pa ruk'a' ri Herodes ri yec'ojon ri vinak pa Galilea, tuc'ul ri Herodes c'o yan chic chiri' pa tinamit Jerusalem chupan tak ri k'ij ri'. ");
INSERT INTO cak_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Tok ri Herodes xutz'et ri Jesús, jani na xquicot ránima, roma riq'uin ri rac'axan chirij, c'o chic chi k'ij rurayin chi nutz'et ruvech. Bala ta nrojo' chi ri Jesús nu'on jun milagro chuvech. ");
INSERT INTO cak_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jalajoj xeruc'utula' ri Herodes che, pero ri Jesús man jun rutzolic rutzij xu'on. ");
INSERT INTO cak_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Jac'a ri nima'k tak quik'ij sacerdotes israelitas, y ri achi'a' q'uiy queteman chirij ri ley yesiq'uin niquisujuj-apu ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Jac'ari' tok ri Herodes junan quiq'uin ri ru-soldados xuya' jun tziek nitz'intz'ot chirij ri Jesús richin nitze'en chirij y man jun ruk'ij nu'on che. C'ajari' xutzolij chic e che ri Pilato. ");
INSERT INTO cak_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Pilato y ri Herodes c'o oyoval chiquivech ri rubanon-pe, pero ja k'ij ri' xech'o chic chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Jac'ari' tok ri Pilato xeroyoj ri nima'k tak quik'ij sacerdotes israelitas, ri achi'a' junan niqui'en gobernar, y ri tinamit, ");
INSERT INTO cak_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","y xu'ij chique: Rix xu'iya' ri Jesús pa nuk'a', y nisujuj chi nuyala' quino'oj vinak. Pero chivech rix mismo xinc'utuj-vi che, y yin nintz'et chi xa man jun chique ri achel ni'ij rix erubanon. ");
INSERT INTO cak_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Nis-ta ri Herodes manak achique xril chirij tok xixintak-e riq'uin. Chiri' nik'alajin-vi chi ri achi re' man jun achique rubanon richin quiri' nitak pa camic. ");
INSERT INTO cak_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Vacami c'a, xtin-ij chi tich'ay y c'ajari' xtincol-e, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ri Pilato nrojo' man nrojo', juna-juna' nucol-e jun preso chupan ri nimak'ij pascua. ");
INSERT INTO cak_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero ri vinak junan quitzij xqui'ij-apu riq'uin cuchuk'a': ¡Tacamisaj la achi c'o-apu chavech y tasok'opij-e ri Barrabás chikavech! xecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ri Barrabás re' tz'apel pa cárcel roma xcataj chirij ri gobierno richin ri tinamit, y roma rubanon camic. ");
INSERT INTO cak_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jun bey chic ri Pilato xch'o-pe chique ri vinak, roma nrojo' nucol-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero rije' xech'o chic apu riq'uin cuchuk'a', y xqui'ij: ¡Ticamises chuvech cruz! ¡Ticamises chuvech cruz! yecha-apu. ");
INSERT INTO cak_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Chi rox (mul, paj) ri Pilato xu'ij-pe chique: Pero, ¿achique mac rubanon ri achi re' chivech? Roma yin man jun ch'o'oj ninvil chirij chi can ta utz nitak pa camic. Romari' xtintak-e richin nich'ay y c'ajari' xtincol-e, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Jac'a ri vinak y ri nima'k tak quik'ij sacerdotes israelitas man yetane' ta ka, xa más riq'uin cuchuk'a' niquic'utuj-apu chi tirip ri Jesús chuvech cruz. Can nik'alajin chi ja ri quitzij rije' ri xtech'acomaj. ");
INSERT INTO cak_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Jac'ari' tok ri Pilato xu'ij chi ti'an ri niquic'utuj-apu ri vinak, ");
INSERT INTO cak_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","y xucol-pe ri achi tz'apel roma xcataj chirij ri gobierno y rubanon camic, achel ri niquic'utuj-apu. Jac'a ri Jesús xujach-e richin ti'an che achel nicajo' ri vinak. ");
INSERT INTO cak_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tok ri soldados ja quic'amon-e ri Jesús, (xquitz'om, xquichop) jun achi rubinan Simón aj pa tinamit Cirene tzolijnak-pe pa juyu', y chirij c'a ri Simón re' xquiya-vi-e ri cruz richin tuc'uaj chirij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y man juba' ta oc vinak ebenak chirij, y ec'o ixoki' ri nicok'ej y niquibisoj ri Jesús ebenak. ");
INSERT INTO cak_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jac'a ri Jesús xtzu'un can chirij, y xu'ij chique: Ixoki' aj-Jerusalem, man quinivok'ej yin, xa tivok'ej-ivi' rix, y que'ivok'ej ri ival. ");
INSERT INTO cak_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Roma xque'uka k'ij tok xti'ix chi utzulaj tzij rubanon ri Dios chique ri ixoki' man e'alanel ta, ri man jun bey xc'uje' ac'ual chiquik'a', y nis-ta jun bey xtz'uman jun ac'ual choquic'u'x. ");
INSERT INTO cak_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Chupan tak ri k'ij ri' ec'o xquech'o chique ri chovon tak juyu' y xtiquibila': Quixtzak-pe chikij, xquecha'. Y xquech'o chique ri cocoj tak juyu' y xtiquibila': Kojimuku', xquecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roma si chuve yin ri yin achel jun che' rex ni'an chi nink'asaj k'axomal, tinojij na pe achique xti'an chique ri e'achel chaki'j tak che', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","(Chuka', ka) ec'amon-e ca'i' elek'oma' junan riq'uin ri Jesús richin ye'ecamises. ");
INSERT INTO cak_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Tok (xe'apon, xe'ebos) chupan ri lugar ri ni'ix lugar richin rubakil (rujolon, ruvi') ámna che, ri soldados xquibajij ri Jesús y ri ca'i' elek'oma' chuvech qui-cruz. Chi tak rutzalanen ri Jesús xequiya-vi ri elek'oma'. Quiri' xqui'en ri soldados. ");
INSERT INTO cak_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jac'a ri Jesús xu'ij: Nata' Dios, que'abana' perdonar, roma man queteman ta achique yetajin riq'uin, xcha'. Y chuvi' etz'anen xquijach-vi-e ri rutziak chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Jani na chi vinak yetz'eto-apu richin ri Jesús, y hasta ri yebano gobernar chiquicojol ri israelitas yetze'en-apu chirij, y niquibila': Rija' xerucol ch'aka' chic. Vacami tucolo-ri' ruyon, si kitzij chi ja rija' ri cha'on-pe roma ri Dios y takon-pe chucolic rutinamit, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ja jun ri soldados yetze'en-apu chirij ri Jesús. Yejel-apu riq'uin, niquisuj-apu ch'amilaj vino che, ");
INSERT INTO cak_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y niquibila-apu che: Si ja rat ri Rey quichin ri israelitas, tacolo-avi' ayon, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chutza'n e ri cruz, chuvech jun pedazo tabla, c'o tz'iban pa griego, pa latín y pan hebreo. Ri tz'iban quire' nu'ij: JARE' RI REY QUICHIN RI ISRAELITAS. ");
INSERT INTO cak_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Pero jun chique ri ca'i' elek'oma' ri ec'o chuvech qui-cruz, quire' tzij ri xu'ij-apu che ri Jesús: Si kitzij chi ja rat ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit, tacolo-avi' ayon y kojacolo' roj, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jac'a ri jun chic elek'on xa xuch'olij, y xu'ij che: Rat ratc'o chupan ri mismo k'axomal junan kiq'uin, y, ¿nis-ta man naxi'ij ta avi' chuvech ri Dios? ");
INSERT INTO cak_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Rat y yin can utz ri ni'an chike, roma ja nikatoj ronojel ri man utz ta kabanalo'n. Pero rija' man jun rumac. ");
INSERT INTO cak_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Jac'ari' xu'ij-apu che ri Jesús: Quinac'uxlaj c'a tok na'an chic gobernar pa ruvi' ronojel, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xu'ij che: Kitzij nin-ij chave: Vacami mismo yatec'uje' viq'uin chupan ri lugar jabel (nic'ases, ch'u'l), xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Pa nic'aj k'ij cami chiri', xk'uk'umer ruvech ronojel ri roch'ulef, y c'a richin a las tres xk'ak'ij xq'uis-e ri k'eku'n. ");
INSERT INTO cak_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri k'ij xk'uk'umer ruvech, y ri pinilaj tziek ri achok che jachon-vi rupan ri racho ri Dios, xel pa nic'aj. ");
INSERT INTO cak_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jac'ari' tok ri Jesús riq'uin ronojel ruchuk'a' xu'ij: Nata', pan ak'a' ninjach-vi ri vánima, xcha'. Tok ru'in chic quiri', jari' (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jac'a ri uc'uay quichin ri soldados tok xutz'et ri xbanataj, xuya' ruk'ij ri Dios, y xu'ij: Can kitzij vi chi ri achi re' jun chojmilaj achi, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Chi nimalaj conojel ri ec'o-apu chiri', tok xquitz'et ri xbanataj, jani na xk'axo cánima y romari' niquitinila-ka roquic'u'x xetzolij. ");
INSERT INTO cak_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jac'a conojel ri queteman ruvech ri Jesús, y ri ixoki' ri c'a pa Galilea quitzekle'en-vi-pe, niquitz'et-apu chi naj ri najin chiri'. ");
INSERT INTO cak_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","C'o c'a jun achi rubinan José, aj pa tinamit Arimatea, jun tinamit richin ri Judea. Ri José re' jun chique ri achi'a' junan niqui'en gobernar chiquicojol ri israelitas, y jun utzulaj y chojmilaj achi. ");
INSERT INTO cak_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Rija' riq'uin ronojel ránima royo'en ri k'ij tok ja ri Dios xtibano gobernar pa ruvi' ronojel, y man juba' junan rutzij xu'on quiq'uin ri (rachbil, rach'il) ri junan niqui'en gobernar, riq'uin ri xecanaj chiquivech pa ruvi' ri Jesús, nis-ta riq'uin ri achique rubeyal xquicanoj richin xquiya' pa camic. ");
INSERT INTO cak_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xbe c'a ri José riq'uin ri gobernador Pilato, xuc'utuj ri ru-cuerpo ri Jesús richin numuk. ");
INSERT INTO cak_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Tok ri José rukasan chic pe ru-cuerpo ri Jesús chuvech cruz, xubolkotij-e pa jun tziek, y xberuya' can chupan jun jul c'oton-apu chuvech jun juyu' ruyon abaj, ri c'a man jani tiyo'ox ámna chupan. ");
INSERT INTO cak_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ri k'ij ri', ri israelitas niquibanala' can rubanic ronojel ri nic'atzin chi niqui'en na'ey chi nitiquer-ka ri k'ij richin uxlanen. ");
INSERT INTO cak_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Pero ri ixoki' ri c'a pa Galilea epetenak-vi chirij ri Jesús, tok xc'amer-e ri ru-cuerpo, xquitzekle'ej-e, y xquitz'et can ri jul ri xyo'ox-vi, y ri achel x-an can che. ");
INSERT INTO cak_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Tok xetzolij chi tak cacho, xequibanala' rubanic jubulaj tak ak'on y aceite richin nequiya' chirij ri cuerpo, pero xe'uxlan chupan ri k'ij richin uxlanen, achel nu'ij chupan ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cumaj-cumaj yan sakar chupan ri na'ey k'ij richin ri semana, ri ixoki' xebe c'a chuchi' ri jul ri yo'on-vi can ri Jesús. Rije' quic'amalo'n-e ri jubulaj tak ak'on ri quibanon-e rubanic, y ec'o ch'aka' chic ixoki' ri ebenak chiquij. ");
INSERT INTO cak_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Tok (xe'apon, xe'ebos), xquitz'et chi ri abaj ri achok che tz'apin-vi can ruchi' ri jul, xa elesan-e. ");
INSERT INTO cak_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Rije' xe'oc-apu chupan ri jul, pero ri ru-cuerpo ri Ajaf Jesús xa man jun chic. ");
INSERT INTO cak_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Romari' man niquil ta achique niquinojij, y c'a quiri' na yetajin chunojixic, jari' tok xe'epapo' quiq'uin ca'i' achel achi'a' nitz'intz'ot quitziak. ");
INSERT INTO cak_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ri ixoki' xeluque-ka pan ulef roma quixi'in-qui', y ri achel achi'a' xqui'ij chique: ¿Achique roma chiquicojol anima'i' nicanoj-vi ri q'ues? ");
INSERT INTO cak_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ri ru-cuerpo man c'o ta chic vave'. Rija' xc'astaj-e. Tuka chi'ic'u'x ri xu'ij chive tok c'a c'o na chila' pa Galilea. ");
INSERT INTO cak_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Rija' quire' ru'in: Yin ri xitak-pe richin xinalex chi'icojol, can xquijach na vi pa quik'a' aj-mac. Xquicamises chuvech cruz, y chi rox k'ij xquic'astaj-pe. Quiri' ru'in ri Jesús, xecha' ri achel achi'a'. ");
INSERT INTO cak_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","C'ajari' xuka chiquic'u'x ri ixoki' ri ch'abel ri ru'in can ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jac'ari' xe'el-pe chuchi' ri jul, xquitzijoj ronojel ri xquitz'et chique ri once apóstoles y chique ri quimolon-qui' quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri xe'eyo'on rutzijol chique ri apóstoles, ja ri María Magdalena, ri Juana, ri María rute' ri Jacobo, y ch'aka' chic ixoki'. ");
INSERT INTO cak_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero pa quivech ri apóstoles, xa nojin tak tzij ri yequibila' ri ixoki', y man xequinimaj ta. ");
INSERT INTO cak_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Xcataj c'a e ri Pedro, junanin xbe chuchi' ri jul. Tok xtzu'un-apu chupan, xe chic ri tziek xutz'et chiri'. Jac'ari' ruyon xtzolij-e, pero jani na nunojila' rij ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chupan c'a ri k'ij ri', c'o ca'i' tzekle'ey richin ri Jesús ebenak chupan ri bey ri ni'e pan aldea Emaús, ri c'o cami once kilómetros quicojol riq'uin ri tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Rije' niquitzijola' chiquivech ri xbanataj pa Jerusalem ebenak. ");
INSERT INTO cak_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y c'a quiri' na yetzijon y niquic'utula' chiquivech ri xbanataj chiri', jari' tok xjel-apu ri Jesús y junan xbe quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero ri ca'i' achi'a' ri' c'o banayon chique chi man niquetemaj ta ruvech ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jac'ari' xuc'utuj ri Jesús chique: ¿Achique c'a ri nitzijoj chivech ri rix petenak? Y, ¿achique roma yixbison? ");
INSERT INTO cak_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun chique rije' rubinan Cleofas, quire' xu'ij-apu che ri Jesús: Man jun la'k vinak ri c'o chiri' pa tinamit Jerusalem ri man ta reteman ri achique xbanataj chupan ri ca'i-oxi' k'ij can. ¿Achel chi rat man aveteman ta? xcha'. ");
INSERT INTO cak_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xuc'utuj chique: ¿Achique ri xbanataj c'a? Rije' xqui'ij: Ri x-an che ri Jesús aj-Nazaret, jun profeta ri xk'alajin chiquivech ri vinak y chuvech ri Dios chi can c'o ruchuk'a' roma ri milagros ri xerubanala' y roma ri ch'abel ri xutzijoj. ");
INSERT INTO cak_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ri nima'k tak quik'ij sacerdotes israelitas, y ri achi'a' junan niqui'en gobernar ri katinamit, xquic'utuj rucamic y xqui'ij chi tibajix chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jac'a roj can cukul kac'u'x riq'uin chi ja rija' xkojelesan pa quik'a' ri ec'o pa kavi' roj israelitas. Y vacami man keteman ta achique xtika'an, roma ja yan chic oxi' k'ij riq'uin re' ticamises. ");
INSERT INTO cak_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero ec'o ixoki' chikacojol ri cumaj yan xebe chuchi' ri jul, y xojequixibij. ");
INSERT INTO cak_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Roma xqui'ij chike chi ri ru-cuerpo ri Jesús man c'o ta chic chiri' pa jul, y chi c'o ángeles xquic'ut-qui' chiquivech, y chi ri ángeles xqui'ij chi ri Jesús xc'astaj-e. ");
INSERT INTO cak_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Romari' ec'o chike roj ri xebe chuchi' ri jul, y can achel ri xqui'ij ri ixoki', can quiri' vi xquil, pero ri Jesús man xquitz'et ta ruvech. ");
INSERT INTO cak_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jac'ari' tok ri Jesús xu'ij chique: ¡Ah! Rix achel xan rubanon ri ivánima. Hasta ri vacami man jani tinimaj ri qui'in can ri profetas ojer. ");
INSERT INTO cak_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Rije' qui'in can chi ri Jun ri nutak-pe ri Dios chucolic ri rutinamit can nuk'asaj na vi k'axomal, y c'ajari' nic'uje' chic ruk'ij chila' chicaj, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Jac'ari' xutzijoj-apu chique ri nu'ij ri ruch'abel ri Dios pa ruvi' rija'. Xutz'uc-e riq'uin ri erutz'iban can ri Moisés, c'ajari' xch'o pa ruvi' ri quitz'iban can ri ch'aka' chic profetas ojer. ");
INSERT INTO cak_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y tok nakaj chic ec'o-vi che ri aldea Emaús, ri Jesús xu'on chi choj nik'ax. ");
INSERT INTO cak_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero rije' xqui'ij che chi tic'uje-ka ri lugar ri yec'uje-vi-ka rije', y romari' xqui'ij: Cac'uje-ka vave', roma ri k'ij xka yan ka, y nik'uk'umer yan pe, xecha'. Jac'ari' xoc-apu ri pa jay richin nic'uje-ka chiri'. ");
INSERT INTO cak_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jac'a tok xtz'uye-apu chuchi' ri mesa quiq'uin ri ca'i' achi'a' ri', ri Jesús xuq'uen-apu jun pan, xumatioxij c'a che ri Dios, xuper c'a y xuya' chique. ");
INSERT INTO cak_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","C'ajari' achel xjakataj quivech, y xquetemaj ruvech chi ja ri Jesús ri c'o quiq'uin. Pero tok xquitz'et, man jun chic quiq'uin. ");
INSERT INTO cak_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Rije' niquibila' chiquivech: Can nuna-vi ri kánima tok nitzijon chike roj petenak, riq'uin ri nuk'alajrisaj chikavech ruchojmil ri ruch'abel ri Dios, yecha'. ");
INSERT INTO cak_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Xecataj c'a e chuchi' ri mesa, xetzolij pa tinamit Jerusalem, y quimolon-qui' ri once discípulos xequil junan quiq'uin ri más chic tzekle'ey richin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Jac'a ri quimolon-qui' xqui'ij chique: Ri Ajaf Jesús can kitzij chi xc'astaj yan e, y xuc'ut yan ri' chuvech ri Simón. ");
INSERT INTO cak_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Jari' tok ri ca'i' achi'a' xquitzijoj-apu ri achique xbanataj quiq'uin tok ebenak chupan ri bey ri ni'e pan Emaús, chi rije' xquetemaj ruvech ri Jesús tok xuper ri pan chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","C'a yetzijon na ri quimolon-qui' pa ruvi' ri xebanataj, tok xbepapo' ri Jesús pa quinic'ajal, y xu'ij chique: Ri uxlanen ri petenak riq'uin ri Dios tic'uje' c'a pa tak ivánima chi'ivonojel, xcha'. ");
INSERT INTO cak_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jac'a rije' xa xquixi'ij-qui', roma niquinojij chi xa jun ámna ri niquitz'et. ");
INSERT INTO cak_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ri Jesús xu'ij chique: ¿Achique roma ixi'in-ivi' y jalajoj ninojij-ka pa tak ivánima chuvij? ");
INSERT INTO cak_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Que'itz'eta' ri nuk'a-vakan, can ja vi yin. Quinitz'eta', (quinitz'ama', quinichapa'), roma jun espíritu manak ruch'acul, manak rubakil achel ri yinitz'et-pe, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Tok xu'ij quiri' chique, xeruc'ut ri ruk'a-rakan chiquivech. ");
INSERT INTO cak_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Jac'a rije' roma yequicot man niquinimaj ta chi ja ri Jesús ri c'o-apu quiq'uin, ni man niquil ta achique niquinojij. Romari' ri Jesús xuc'utuj si chiri' manak juba' achique richin nitij. ");
INSERT INTO cak_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jari' tok xquiya' juba' sa'on quer che, y cab c'o pa cera. ");
INSERT INTO cak_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","(Xutz'om, xuchop) c'a apu rija' y chiquivech xutij-vi. ");
INSERT INTO cak_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jac'ari' xu'ij chique: Ri xebanataj chupan ri ca'i-oxi' k'ij re', jare' ri nuyo'on-pe rutzijol chive na'ey chuvech ri nucamic, y vacami nincamuluj chic rubixic chive, chi can xc'atzin na vi chi xebanataj ri tz'iban can pa ruvi' ri nuc'aslen yin, achel nilitaj chupan ri ley ri xyo'ox che ri Moisés, chupan ri quitz'iban can ri profetas ojer y chupan ri Salmos. ");
INSERT INTO cak_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ajari' xu'on chique chi (xk'ax, xno') chiquivech ri tz'iban can chupan ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xu'ij c'a chique: Can tz'iban-vi can y romari' xc'atzin chi ri Jun ri xutak-pe ri Dios chucolic ri rutinamit, chuvi' k'axomal xcamises-vi, y chi rox k'ij xc'astaj-pe chiquicojol ri anima'i', ");
INSERT INTO cak_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y chi pa rubi' rija' titzijos-vi chique conojel quivech vinak chi nic'atzin niquijal quino'oj y niquiya' can ri quimac, y quiri' ri Dios yeru'on perdonar. Y bin can chi vave' pa Jerusalem nitiquer-vi-e rutzijosic. ");
INSERT INTO cak_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Rix ri xitz'et ronojel re', titzijoj ri xitz'et. ");
INSERT INTO cak_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jac'a yin, can xtintak-vi-pe ri rusujun ri Nata' Dios chi nuya-pe chive. Pero quixc'uje' pa Jerusalem, c'a ja tok xtiyo'ox chive ri ruchuk'a' ri Lok'olaj Espíritu ri xtika-pe chicaj, xcha' ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","C'o c'a jun k'ij ri Jesús xerelesaj-e ri ru-discípulos ri pa Jerusalem, y xeruc'uaj pan aldea Betania. Chiri' xeruyec ri ruk'a' chicaj y xuc'utuj ru-favor ri Dios pa quivi'. ");
INSERT INTO cak_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y tok ja nuc'utuj ru-favor ri Dios pa quivi' chiri', xujach-e-ri' quiq'uin, y ja nijoto'ex-e chicaj benak. ");
INSERT INTO cak_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jac'a ri discípulos ejupul pan ulef xquiya' ruk'ij ri Jesús, y jani na yequicot xetzolij pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","K'ij-k'ij ec'o pa racho ri Dios, niquiya' ruk'ij y niquinimirisaj rubi'. Amén.");
INSERT INTO cak_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tok xtiquer-pe ronojel, can c'o chic vi ri Jun ri achok riq'uin niketemaj-vi ri c'o pa ránima ri Dios. Rija' xa jun rubanon riq'uin ri Dios, y can Dios vi. ");
INSERT INTO cak_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na'ey chi xc'uje' ri roch'ulef, rija' can xe vi jun rubanon riq'uin ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y roma rija' tok xc'uje' ronojel, y man jun ri banon ri man ta rija' banayon. ");
INSERT INTO cak_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ri c'aslen can riq'uin vi rija' c'o-vi-pe, y ja c'aslen ri' sakil richin quic'aslen ri vinak. ");
INSERT INTO cak_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ri Sakil re' niyic'an pa k'eku'n, y ri k'eku'n man tiquernak ta ruchupun. ");
INSERT INTO cak_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","C'o c'a jun achi rubinan Juan ri xtak-pe roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Rija' xpe richin xuruya' rutzijol ri Sakil, richin quiri' conojel tiquiya' cánima riq'uin ri Sakil ri nutzijoj. ");
INSERT INTO cak_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Pero mana-ta ri Juan ri Sakil; xaxe xuruya' rutzijol ri Sakil. ");
INSERT INTO cak_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ja tiempo ri' nijel-pe choch'ulef ri kitzij Sakil ri nibano sakil pa cánima conojel vinak. ");
INSERT INTO cak_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ri Sakil ri' xc'uje' choch'ulef ri banon roma rija' mismo, pero ri ec'o choch'ulef man xquiya' ta pa cuenta (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xuc'uje' chiquicojol ri rutinamit, pero rije' man xquic'ul ta ruvech. ");
INSERT INTO cak_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jac'a ri xec'ulu ruvech y xcuke' quic'u'x riq'uin, xu'on chique chi c'o quik'a' richin ye'oc ralc'ua'l ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Pero ri rutz'uquic ri c'aslen quichin ri ye'oc ralc'ua'l, man nipe ta riq'uin quiquiq'uel vinak, ni man riq'uin ta nicajo' niqui'en ri te'ej-tata'aj, nis-ta roma jun tata'aj nurayij chi nic'uje' ralc'ua'l. Roma rutz'uquic ri c'aslen re' riq'uin ri Dios petenak-vi. ");
INSERT INTO cak_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Jun ri achok riq'uin niketemaj-vi ri c'o pa ránima ri Dios, xoc vinak achel roj. Rija' xc'uje' chikacojol y roj xkatz'et ri nimalaj ruk'ij ri can richin vi ri juney Ruc'ajol ri Dios ri can nojnak-pe ri kitzij y ri ru-favor ri Dios pa ránima. ");
INSERT INTO cak_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri Juan can ruyo'on-vi-pe rutzijol y riq'uin ruchuk'a' quire' ru'in chique ri vinak: Jare' ri Jun ri nuyo'on-pe rutzijol chive, tok xin-ij: Ri Jun ri xtuka chuvij yin, más c'o ruk'ij chinuvech, roma rija' can c'o chic vi na'ey chinuvech yin. ");
INSERT INTO cak_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Quiri' nik'alajin, roma riq'uin rija' kac'ulun-vi ronojel ruvech favores, y man xe ta jun bey ruyo'on-pe pa kavi', xa can quitzeklelo'n-pe-qui' yeruya-pe pa kavi'. ");
INSERT INTO cak_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios ja ri Moisés xucusaj richin xuya-pe ri ley chike. Jac'a richin xuk'alajin ri ru-favor y ri kitzij, ja ri Jesucristo ri xucusaj. ");
INSERT INTO cak_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ri Dios man jun vinak tz'eteyon ruvech, xaxe ri juney Ruc'ajol ri (nojovex, nojo'ox) roma ri Tata'aj, jari' ri tz'eteyon richin. Y ja ri Ruc'ajol xuk'alajrisan-ka runo'oj ri Dios chikavech vave' choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ri achi'a' israelitas c'o quik'ij chiri' pa tinamit Jerusalem, xequitak-e achi'a' sacerdotes y achi'a' ri ni'ix levitas chique riq'uin ri Juan ri Bautista richin xquic'utuj che ri (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri Juan man xrevaj ta chiquivech, xa quire' xu'ij chique: Mana-ta yin ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Jac'ari' tok ri achi'a' etakon-e xquic'utuj chic che: ¿(Achique, aratcu'x) c'a rat? ¿Mana-ta rat ri profeta Elías ri xc'uje' ojer can? Ri Juan xu'ij chi mana-ta. Xquic'utuj chic c'a jun bey che: ¿Mana-ta rat ri profeta ri bin-pe chi nipe? xecha'. Y xu'ij chi mana-ta. ");
INSERT INTO cak_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jac'ari' tok xqui'ij chic che: Ta'ij c'a chike rat achique chi achi rat, richin jari' neka'ij chique ri etakayon-pe kichin. ¿Achique na'ij-ka chavij rat? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ja yin ri jun ri ruc'uxlan can ri profeta Isaías tok xu'ij: Pa chakijlaj tz'iran ulef c'o jun xtich'o riq'uin ruchuk'a' y xtubila': Tibana-apu rubanic ri bey ri xtik'ax-vi ri Ajaf, utz-utz tichojmij-apu. Quiri' xu'ij ri Juan chique. ");
INSERT INTO cak_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achi'a' ri etakon-e riq'uin ri Juan, jun botzaj chique ri achi'a' ri ni'ix fariseos chique. ");
INSERT INTO cak_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Rije' quire' chic c'a xquic'utuj che ri Juan: ¿Achique roma ye'aben bautizar ri vinak, tok xa mana-ta rat ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit, ni mana-ta rat ri Elías, ni mana-ta rat ri profeta ri bin can chi nipe? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri Juan xu'ij chique: Yin riq'uin ya' nin-en-vi bautizar, pero chi'icojol rix c'o Jun ri man iyo'on ta pa cuenta (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Rija' xtipe chuvij yin, y más c'o ruk'ij que chinuvech yin. Y nis-ta richin rusolic ximibel ruxajab, man nuc'ul ta chi ja yin yibano. ");
INSERT INTO cak_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronojel re' xbanataj ri chiri' pa Betábara, ri juc'an-apu ruchi' ri rakan-ya' Jordán, ri lugar ri nu'on-vi bautizar ri Juan. ");
INSERT INTO cak_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chuca'n k'ij ri Juan ri Bautista xutz'et chi ri Jesús choj petenak riq'uin, y rija' quire' xu'ij chique ri quimolon-qui' riq'uin: Titz'eta', jare' ri Alaj Oveja richin ri Dios ri nelesan quimac ri vinak. ");
INSERT INTO cak_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jare' ri nutzijon-pe yin chive, tok xin-ij chi chuvij yin xtuka Jun achi más c'o ruk'ij chinuvech, roma rija' can c'o-vi na'ey chinuvech yin. ");
INSERT INTO cak_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yin na'ey man veteman ta (achique, acu'x) rija', jac'a ri vacami, yin riq'uin ya' yen-en-vi bautizar ri vinak, richin quiri' ri israelitas niquetemaj (achique, acu'x) rija'. ");
INSERT INTO cak_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y quire' chic jun xuk'alajrisaj ri Juan: Yin xintz'et ri Lok'olaj Espíritu chi xulan-pe chicaj achel jun paloma y xc'uje' pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Pa na'ey yin man veteman ta (achique, acu'x) rija', pero ja ri Dios ri yin takayon-pe richin yen-en bautizar ri vinak riq'uin ya', jari' biyon-pe chuve: Tok xtatz'et jun achi ri nika-pe ri Lok'olaj Espíritu pa ruvi' y nic'uje' riq'uin, jari' ri nibano bautizar riq'uin ri Lok'olaj Espíritu. Quiri' ri xu'ij chuve. ");
INSERT INTO cak_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Y yin nin-ij chi nutz'eton chic ruvech, romari' nintzijoj chive chi ja rija' ri Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chuca'n k'ij ec'o chic chiri' jun bey ri Juan y ca'i' ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tok xutz'et chi ja ri Jesús ri nik'ax-e chiri', ri Juan quire' xu'ij: Titz'eta', ja la' ri Alaj Oveja richin ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ri ca'i' ru-discípulos ri Juan xquic'axaj ri xu'ij, jac'ari' xquitzekle'ej-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jac'a tok ri Jesús xtzu'un can chirij y xutz'et chi tzekle'en-e coma ri ca'i' ru-discípulos ri Juan, rija' xuc'utuj chique: ¿Achique nicanoj? Rije' xqui'ij: Rabí, roj nikajo' niketemaj achique lugar c'o-vi ri avacho, xecha'. Rabí nu'ij tzij tijonel. ");
INSERT INTO cak_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jo' c'a, te'itz'eta', xcha' ri Jesús chique. Jac'ari' xebe chirij, xquitz'et ri racho, y roma las cuatro chic, chiri' xec'uje-vi-ka c'a chuca'n k'ij. ");
INSERT INTO cak_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jun chique ri ca'i' ri xe'ac'axan ri xu'ij ri Juan y xutzekle'ej-e ri Jesús, ja ri Andrés, ri quichak'-quinimal qui' riq'uin ri Simón Pedro. ");
INSERT INTO cak_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés na'ey xucanoj ri Simón ri quichak'-quinimal qui' riq'uin, y tok xril, quire' xu'ij che: ¡Vacami xkil ri Mesías! xcha' che. Mesías, nu'ij tzij jun ri takon-pe roma ri Dios chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ri Andrés xuq'uen-apu ri Simón riq'uin ri Jesús. Jac'a tok ri Jesús xutz'et ri Simón, quire' xu'ij che: Rat Simón ri ruc'ajol ri Jonás, vacami xtabinaj Cefas, xcha' che. Cefas nu'ij tzij, Pedro. ");
INSERT INTO cak_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chuca'n k'ij, ri Jesús xunojij chi ni'e pa Galilea, y ja k'ij ri' tok rija' xuc'ul ri Felipe, y xu'ij che: Jo', quinatzekle'ej, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri Felipe aj-Betsaida, ri quitinamit ri Andrés y ri Pedro. ");
INSERT INTO cak_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri Felipe xerucanoj ri Natanael, y tok xril, quire' xu'ij che: Ja xkil ri Jun ri ruc'uxlan can ri Moisés chupan ri ley ri xuya' ri Dios che, y ri quic'uxlan can ri profetas ojer. Y ri' ja ri Jesús aj-Nazaret, ruc'ajol ri José, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ri Natanael xu'ij che: ¿C'o cami juba' utz ntel-pe pa tinamit Nazaret? xcha'. Y ri Felipe xu'ij che: Si man nanimaj ta, jo' tikatz'eta', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Tok ri Jesús xutz'et chi tzalan-pe ri Natanael riq'uin, quire' xu'ij chirij: Tatz'eta' la Natanael. La' kitzij chi jun israelita ri ruyon kitzij ntel pa ránima. ");
INSERT INTO cak_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Jac'ari' tok ri Natanael xuc'utuj che ri Jesús: ¿Achel aveteman rat nuno'oj? Ri Jesús xu'ij che: Na'ey chi ri Felipe xateroyoj, yin rat nutz'eton chic chi chuxe' ri jun mata higo ratc'o-vi, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael xu'ij: Tijonel, ja rat ri Ruc'ajol ri Dios y ja rat ri Rey richin ri tinamit Israel, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Quire' c'a xu'ij ri Jesús che: Rat xanimaj chi ja yin ri Ruc'ajol ri Dios xaxe roma xin-ij chave chi xatintz'et chuxe' ri jun mata higo. Pero c'a c'o na más nima'k tak milagros chuvech re' ri xque'atz'et. ");
INSERT INTO cak_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y quire' chic xu'ij che: Kitzij-kitzij nin-ij chive chi rix xtitz'et chi ri caj xtijakataj, y ri ángeles richin ri Dios xquexule-xquejote' viq'uin yin ri xitak-pe richin xinalex chi'icojol, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Chi rox k'ij, x-an jun c'ulubic pa tinamit Caná chiri' pa departamento Galilea, y ri María rute' ri Jesús c'o-apu chiri'. ");
INSERT INTO cak_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ja jun c'a ri Jesús y ri ru-discípulos xe'oyox ri pa c'ulubic. ");
INSERT INTO cak_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y chiri' pa c'ulubic, xa xq'uis ri vino, y ri rute' ri Jesús quire' xu'ij che: Xq'uis ri qui-vino, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jac'a ri Jesús xu'ij: Nte', ¿achique roma chuve yin na'ij-vi ri'? Roma ri hora vichin yin man jani tuka, xcha' rija'. ");
INSERT INTO cak_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jac'ari' quire' xu'ij ri rute' ri Jesús chique ri yejachon pa c'ulubic: Ronojel ri xtu'ij ri Jesús chive, tibana', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","C'o c'a vaki' chovon tak (cucu', k'e'l) chiri', banon che abaj. Chupan tak (cucu', k'e'l) achel ri' niquiya-vi ya' ri israelitas richin niquich'ajch'ojij-qui' chuvech ri Dios, achel nu'ij ri qui-ley. Ri (cucu', k'e'l) ri' cajcaj ciento vaso ya' ntoc chupan. ");
INSERT INTO cak_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jac'ari' tok ri Jesús xu'ij chique ri yejachon pa c'ulubic: Que'inojsaj che ya' ri (cucu', k'e'l) re', xcha'. Y rije' xequinojsaj hasta chukul e. ");
INSERT INTO cak_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'ajari' xu'ij chique: Vacami tipaja-e juba' y te'iya' che ri pa'el chuvech ri nimak'ij, xcha'. Y can quiri' vi xqui'en. ");
INSERT INTO cak_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Jac'a ri pa'el chuvech ri nimak'ij man reteman ta achique lugar c'amon-vi-pe ri vino ri'; xaxe ri xe'epajo-pe ri ya' ri queteman. Pero tok rija' rutojto'en chic ri ya' ri x-an vino che, xroyoj ri ala' ri c'o pa ruc'ulubic, ");
INSERT INTO cak_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y quire' xu'ij che: Tok c'o jun nimak'ij achel re', conojel vinak ja ri utz vino niquiya' na'ey, y tok siquirnak chic pa quichi' ri ec'o pa nimak'ij, c'ajari' niquiya' jun vino ri man can ta utz. Pero rat man quiri' ta xa'an. Rat xa c'a ja xavelesaj-pe ri vino más utz, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ja c'a re' ri na'ey milagro ri xu'on ri Jesús, y ja ri pa tinamit Caná ri c'o pa Galilea xu'on-vi. Riq'uin ri' xuc'ut chi rija' can c'o ruk'ij, y ri ru-discípulos xcuke' quic'u'x riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tok xq'uis ri nimak'ij richin ri c'ulubic, ri Jesús, ri rute', ri eruchak' y ri ru-discípulos xexule-ka pa tinamit Capernaum, y chiri' xec'uje-vi ca'i-oxi' k'ij. ");
INSERT INTO cak_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nakaj chic c'o-vi ruk'ijul ri quinimak'ij ri israelitas rubinan Pascua, y ri Jesús xbe pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chiri' chojay che racho ri Dios etz'uyul-vi xeril ri yec'ayin váquix, ri yec'ayin ovejas, ri yec'ayin palomas, y ri eq'uexoy ruvech méra. ");
INSERT INTO cak_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Y xu'on c'a jun (ch'eyebel, ch'ey-el) riq'uin ca'i-oxi' ruvech colo', xerokotaj-pe conojel, y ja jun ri ovejas y ri váquix xerokotaj-pe. Xujopij c'a can ri quiméra ri eq'uexoy ruvech méra y xuticmayila' can ri qui-mesas. ");
INSERT INTO cak_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jac'ari' xu'ij chique ri yec'ayin palomas: Que'ivelesaj-e re' vave', y man chic ti'en c'ayibel che racho ri Nata' Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jac'ari' tok xuka pa quivi' ri ru-discípulos ri ruch'abel ri Dios ri tz'iban can ri quire' nu'ij: Jani na nik'axo ri vánima roma ri yequibanala' ri vinak chupan ri vacho, nicha'. ");
INSERT INTO cak_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y roma ri xu'on ri Jesús pa racho ri Dios, romari' tok ri achi'a' c'o quik'ij chiquicojol ri israelitas quire' xqui'ij che: ¿Achique jun retal nac'ut chikavech ri nic'utu chi kitzij c'o ak'a' richin xe'avokotaj-e ri vinak vave'? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y rija' xu'ij chique: Tiyojo' ri racho ri Dios re', y yin xtin-en chi xtipa'e' chic chi oxi' k'ij, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jac'ari' tok ri achi'a' israelitas c'o quik'ij xqui'ij che ri Jesús: Ri jun jay re', cuarenta y seis juna' xqui'en ri kate-katata' chirij richin xquipaba'. ¿Y rat na'ij chi napaba' chi oxi' k'ij? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri racho ri Dios ri xu'ij ri Jesús chique, xa ja ri ru-cuerpo. ");
INSERT INTO cak_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ja tok c'ason chic pe ri Jesús chiquicojol ri anima'i', jari' xuka pa quivi' ri ru-discípulos chi rija' ru'in can re', y xquinimaj chi kitzij ri nu'ij ri ruch'abel ri Dios ri tz'iban can, y xquinimaj ri ch'abel ri ru'in can ri Jesús chique. ");
INSERT INTO cak_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Tok ri Jesús c'o chiri' pa tinamit Jerusalem roma ri nimak'ij pascua, eq'uiy xquinimaj (achique, acu'x) rija' tok xquitz'et ri milagros ri xeru'on chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man cukul ta ruc'u'x quiq'uin, roma rija' reteman cánima conojel. ");
INSERT INTO cak_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Man nic'atzin ta chi c'o jun ni'in che achique chi c'aslen quic'uan, roma rija' reteman ri achique c'o pa cánima ri vinak. ");
INSERT INTO cak_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","C'o c'a jun chique ri achi'a' fariseos c'o ruk'ij chiquicojol ri ruvinak israelitas rubinan Nicodemo. ");
INSERT INTO cak_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rija' pa jun xok'ok'a' xbe riq'uin ri Jesús y xu'ij che: Rabí, roj keteman chi rat, rat jun Tijonel ri takon-pe roma ri Dios. Roma xaxe ri c'o Dios riq'uin nibano milagros ri achel na'an rat, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jac'a ri Jesús xu'ij che: Yin kitzij-kitzij nin-ij chave: Ri man xtalex ta chic jun bey, man nitiquer ta ntoc chiquicojol ri ye'an gobernar roma ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xu'ij che ri Jesús: ¿C'o cami che'el nalex chic jun bey jun achi ri xa ri'j chic? ¿C'o cami che'el nu'on chic ka co'ol richin nalex chic jun bey riq'uin ri rute'? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Y ri Jesús xu'ij: Kitzij-kitzij nin-ij chave: Ri man xtuc'uaj ta ri alaxic ri petenak riq'uin ri Lok'olaj Espíritu y riq'uin ya', man nitiquer ta ntoc chiquicojol ri ye'an gobernar roma ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Roma ri ye'alex chiquik'a' ri quite-quitata', xaxe ri aj-roch'ulef c'aslen niquic'uaj. Jac'a ri niquic'uaj ri alaxic ri petenak riq'uin ri Lok'olaj Espíritu, can ja ruc'aslen ri Lok'olaj Espíritu niquic'uaj. ");
INSERT INTO cak_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Man jun vi tuna' ri avánima navac'axaj ri xin-ij chave rat, Nicodemo, chi rix nic'atzin chi yixalex chic jun bey. ");
INSERT INTO cak_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri cak'ik' jalajoj rubey nik'ax-vi y navac'axaj, pero man aveteman ta achique lugar petenak-vi, y nis-ta aveteman ri ni'e-vi. Quiri' mismo ri niquic'uaj ri alaxic ri petenak riq'uin ri Lok'olaj Espíritu, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jac'ari' xuc'utuj ri Nicodemo che ri Jesús: ¿Achel c'a nibanataj ri alaxic ri na'ij? ");
INSERT INTO cak_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Quire' c'a xu'ij ri Jesús che: ¿Man aveteman ta achel nibanataj re', y xa rat tijonel chiquicojol ri israelitas? ");
INSERT INTO cak_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yin kitzij-kitzij nin-ij chave, chi ja ri achique keteman y katz'eton ri nikatzijoj. Jac'a rix man ninimaj ta ri nikatzijoj chive. ");
INSERT INTO cak_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yin xa ja ri yebanataj choch'ulef ri nintzijoj, y rix man nijo' ta ninimaj, y xa ta yich'o chirij ri achique yebanataj chicaj, más c'ayef chi rix ninimaj. ");
INSERT INTO cak_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nis-ta jun ocunak chila' chicaj, xaxe ri Jun ri kajnak-pe chicaj richin xalex chiquicojol ri vinak, y can chicaj c'o-vi. ");
INSERT INTO cak_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y achel xu'on ri Moisés ojer can pa chakijlaj tz'iran ulef, chi xuya' ruvachibel jun cumatz chutza'n jun che' richin xecolotaj ri vinak chuvech ri camic, quiri' mismo yin ri xitak-pe richin xinalex chi'icojol, xquijoto'ex chuvech jun che', ");
INSERT INTO cak_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","richin quiri' xa achique na ri xtuya' ránima viq'uin, man xti'e ta chupan ri camic ri richin jumul, xa xtic'uje' ruc'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Roma ri Dios conojel vinak yerojo', romari' hasta xutak-pe ri juney Ruc'ajol vave' choch'ulef richin quiri' xa achique na ri nuya' ránima riq'uin, man xti'e ta chupan ri camic ri richin jumul, xa xtic'uje' ruc'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Roma ri Dios man xutak ta pe ri Ruc'ajol chuvech ri roch'ulef richin nuruya' castigo pa quivi' ri vinak, xa richin yerucol chupan ri quimac. ");
INSERT INTO cak_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ri nuya' ránima riq'uin ri Ruc'ajol ri Dios, man xtika ta ri castigo pa ruvi'. Jac'a ri man nuya' ta ránima riq'uin, ri castigo ri richin jumul can c'o chic pa ruvi', roma man nunimaj ta ri juney Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ri achique roma c'o chic castigo pa ruvi', jare': ri Sakil richin ri Dios xuka choch'ulef, pero ri vinak más xcajo' ri k'eku'n que chuvech ri Sakil, roma rije' xa itzel ri yequibanala'. ");
INSERT INTO cak_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Roma conojel ri yequibanala' ri xa itzel, itzel niquitz'et ri Sakil, y man yejel ta apu riq'uin, roma man nicajo' ta chi ntel chosakil ronojel ri man utz ta ri yetajin riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jac'a ri uc'uan quic'aslen roma ri kitzij richin ri Dios, xa yejel-apu riq'uin ri Sakil, richin ntel chosakil chi ja ri Dios ri uc'uayon quichin (chubanic, cho'onic) ri achique yequibanala'. ");
INSERT INTO cak_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tok xbanataj yan ronojel re', ri Jesús y ri ru-discípulos xebe pa jun lugar richin ri departamento Judea, y chiri' xlayoj-vi quiq'uin, y nu'on bautizar. ");
INSERT INTO cak_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ja jun ri Juan ri Bautista, c'o yeru'on bautizar chupan ri lugar rubinan Enón, ri c'o-apu chunakaj ri tinamit Salim, roma chiri' jabel ya' c'o. Y c'a c'o na nequimolo-qui' riq'uin richin ye'an-e bautizar, ");
INSERT INTO cak_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","roma ri Juan c'a man jani titz'apis pa cárcel ri tiempo ri'. ");
INSERT INTO cak_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Romari' ec'o israelitas xquich'olila-qui' quiq'uin ru-discípulos ri Juan chi achique chi bautismo ri más utz. ");
INSERT INTO cak_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xe'ech'o c'a ri discípulos ri' riq'uin ri Juan y xqui'ij che: Tijonel, ri Jun ri (xapon, xebos) aviq'uin ri juc'an-apu ruchi' ri rakan-ya' Jordán, ri xa'ij chi ja Rija' ri yecolo ri vinak chupan ri quimac, vacami xa riq'uin rija' yebe-vi-apu conojel richin ye'an bautizar, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jac'a ri Juan xu'ij chique ri ru-discípulos: Man jun vinak nitiquer nu'on jun cosa, si man ta ri Dios chicaj niyo'on-pe che. ");
INSERT INTO cak_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Rix mismo riq'uin ixiquin ivac'axan ri nu'in: Mana-ta yin ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit. Yin xaxe yin takon-pe na'ey richin ninya' rutzijol chi can nipe na vi rija'. ");
INSERT INTO cak_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Tok jun ala' nic'ule', can ni'e na vi ri xten chirij, jac'a ri jun chic ala' ri peyon richin nu'on rubanic ronojel ri nic'atzin chupan ri c'ulubic, tok nrac'axaj rukul ri ala' ri xc'ule' chi nitzijon riq'uin ri xten, ri ala' peyon niquicot. Quiri' mismo yin, yiquicot ninvac'axaj chi ri vinak vacami ja ri Jesucristo ri quitzekle'en. ");
INSERT INTO cak_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Roma rija' can nic'atzin-vi chi ninimer ruk'ij. Jac'a yin can utz vi chi nich'utuner nuk'ij. ");
INSERT INTO cak_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri petenak chicaj, ja rija' ri c'o pa quivi' conojel. Jac'a ri ec'o choch'ulef, xaxe ri achique c'o choch'ulef yetiquer niquitzijoj, roma can e'aj-roch'ulef vi. Jac'a ri Jun ri kajnak-pe chicaj, ja rija' ri c'o pa quivi' conojel. ");
INSERT INTO cak_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Rija' ja ri rutz'eton can y rac'axan-pe, jari' nuya' rutzijol. Pero man jun nrojo' nunimaj ri nuk'alajrisaj rija'. ");
INSERT INTO cak_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Jac'a ri nic'ulu pa ránima ri nuk'alajrisaj ri Jun ri petenak chicaj, nuk'alajrisaj chi ri Dios can kitzij vi ri nu'ij. ");
INSERT INTO cak_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Roma ri Jun ri xutak-pe ri Dios choch'ulef, ja ri ch'abel ri bin-pe che roma ri Dios ri nutzijoj. Roma ri Dios tz'akat nuya-pe ri Lok'olaj Espíritu, y man nretaj ta pe. ");
INSERT INTO cak_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Tata'aj can nrojo' ri Ruc'ajol, y ronojel pa ruk'a' ri Ruc'ajol rujachon-vi. ");
INSERT INTO cak_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ri nuya' ránima riq'uin ri Ruc'ajol ri Dios, c'o chic ri c'aslen ri richin jumul riq'uin. Jac'a ri man nrojo' ta nuya' ránima riq'uin ri Ruc'ajol ri Dios, man xtril ta ri c'aslen ri richin jumul, xa c'o chic royoval ri Dios pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Ajaf Jesús xretemaj chi ri achi'a' fariseos quic'axan chi rija' más eq'uiy vinak yeru'on bautizar y más eq'uiy yetzekle'en richin que chuvech ri Juan ri Bautista. ");
INSERT INTO cak_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero mana-ta ri Jesús ri yebano bautizar ri vinak, xa ja ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y tok ri Jesús xrac'axaj chi quiri' rutzijol quic'axan ri fariseos, rija' xel-e chiri' pa Judea y xtzolij chic jun bey pa Galilea. ");
INSERT INTO cak_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jac'a richin ni'e pa Galilea, rija' nuna' ránima chi nic'atzin nik'ax pa departamento Samaria. ");
INSERT INTO cak_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chiri' pa Samaria rija' (xapon, xebos) chunakaj jun tinamit rubinan Sicar, ri c'o chunakaj ri juyu' ri xuya' can ri Jacob che ri ruc'ajol rubinan José. ");
INSERT INTO cak_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chiri' c'o-vi ri pozo ri Richin Jacob ni'ix che, y cosnak roma ri binen rubanon, ri Jesús xtz'uye-ka chuchi' ri pozo pa nic'aj cami k'ij chiri'. ");
INSERT INTO cak_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Jari' tok (xapon, xebos) jun ixok aj chiri' pa departamento Samaria chuchi' ri pozo richin nrelesaj ruya'. Y ri Jesús xu'ij che: Ixok, tabana' favor, tasipaj juba' nuya' richin ninkum, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ri hora ri' ri discípulos ebenak pa tinamit richin xequilok'o' ri achique niquitij. ");
INSERT INTO cak_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Quire' c'a rutzolic rutzij ri Jesús xu'on ri ixok: Rat, rat jun israelita, y, ¿achel chi chuve yin nac'utuj-vi aya', tok yin, yin jun ixok aj-Samaria? Ri ixok quiri' xu'ij, roma ri israelitas man nicajo' ta qui' quiq'uin ri aj-Samaria. ");
INSERT INTO cak_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jac'a ri Jesús xu'ij che ri ixok: Xa ta rat aveteman achique sipanic nuya' ri Dios, y achique chi achi ri nic'utun juba' ruya' chave; rat ta yac'utun aya' che, y rija' nuya' ri ya' ri niyo'on c'aslen chave, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jac'ari' xu'ij ri ixok che: Ri pozo naj kajnak ka rupan, y rat man jun achok che navelesaj-vi ri ya'. ¿Achique lugar naq'uen-vi ri ya' ri niyo'on c'aslen ri nasuj? ");
INSERT INTO cak_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿La más cami c'o ak'ij rat chuvech ri kamama' Jacob ri ruyo'on can ri pozo re' chike? Roma rija' y ri ralc'ua'l vave' xquelesaj-vi quiya' richin xquikum y richin xquiya' chique ri cavaj, xcha' ri ixok. ");
INSERT INTO cak_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xu'ij che: Xa achique na xtikumu ri ya' richin ri pozo re', nitzolij chic pe ri ruchakij-chi'. ");
INSERT INTO cak_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jac'a ri nikumu ri ya' ri niyo'on c'aslen ri ninya' yin che, ri ránima man jun bey chic xtuna' chakij-chi'. Roma ri ya' ri ninya' yin che, can achel jun alaxbel-ya' xtu'on pa ruc'aslen, y can xtichoxin-pe richin nuc'uaj chupan ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jari' tok ri ixok quire' xu'ij: Tabana' favor, tasipaj ri ya' ri' chuve yin, richin quiri' man jun bey chic xtichakij nuchi', y nis-ta xtic'atzin chic chi nunvelesaj nuya' vave', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jac'a ri Jesús xu'ij: Te'avoyoj ri avachijil y yape chic vave', xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xu'ij: Yin manak vachijil, xcha'. Y ri Jesús xu'ij: Can kitzij ri na'ij chi manak avachijil. ");
INSERT INTO cak_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Roma evo'o' yan avachijil quec'uje', y ri achi ri c'o aviq'uin vacami, man avachijil ta. Kitzij ri xa'ij. ");
INSERT INTO cak_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jari' tok ri ixok quire' xu'ij: Yin nintz'et chi rat, rat jun profeta. ");
INSERT INTO cak_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri kate-katata' ri xec'uje' ojer can, pa ruvi' re jun juyu' re' xquiya-vi ruk'ij ri Dios. Jac'a rix israelitas ni'ij chi conojel vinak nic'atzin chi ja ri pa Jerusalem niquiya-vi ruk'ij ri Dios, xcha' ri ixok. ");
INSERT INTO cak_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jac'a ri Jesús xu'ij: Tanimaj ri xtin-ij chave, chi xtuka na jun k'ij tok mana-ta chic pa ruvi' ri juyu' re', nis-ta pa Jerusalem xtiya-vi ruk'ij ri Katata' Dios. ");
INSERT INTO cak_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Rix aj-Samaria nis-ta iveteman ri achique niya' ruk'ij. Jac'a roj israelitas keteman ri achique nikaya' ruk'ij, roma ri xticolo quichin ri vinak chupan ri quimac, chikacojol roj israelitas xtutak-vi-pe ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Jac'a ri k'ij ri xin-ij chave chi nipe, ja vacami ri', tok ri kitzij yeyo'on ruk'ij ri Katata' Dios, can e'uc'uan roma ri Lok'olaj Espíritu y roma ri kitzij tok xtiquiya' ruk'ij. Roma ri Dios ja ri yebano quiri' ri yerucanoj richin niquiya' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios can Espíritu vi. Romari' ri vinak ri yeyo'on ruk'ij, nic'atzin chi niquiya' ruk'ij achel nrojo' ri Lok'olaj Espíritu y achel nrojo' ri kitzij richin ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jac'ari' xu'ij ri ixok: Yin veteman chi c'o na jun k'ij xtuka choch'ulef ri Jun ri xtutak-pe ri Dios chucolic ri rutinamit, ri ni'ix Cristo che. Tok xtuka ri Jun ri', ronojel xtuk'alajrisaj chikavech, xcha' ri ixok. ");
INSERT INTO cak_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xu'ij che: Ri Jun ri na'ij rat, ja yin ri yitzijon aviq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jac'ari' tok xetzolij-pe ri ru-discípulos, y can achique na xquina' tok xquitz'et chi ri Jesús nitzijon riq'uin jun ixok. Pero nis-ta jun chique rije' xc'utun-apu che ri achique nuc'utuj che ri ixok o ri achique nutzijoj che. ");
INSERT INTO cak_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Xuya' c'a can (rucucu', ruk'e'l) ri ixok chiri', xbe pa tinamit, y quire' xu'ij chique ri vinak: ");
INSERT INTO cak_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","¡Nuvinak! Quire' quixampe, tu'itz'eta'. Roma yin c'o jun achi xtzijon viq'uin, y xa ronojel ri achique enubanalo'n pa nuc'aslen, xeru'ij chuve. ¿Mana-ta cami rija' ri Jun ri ni'ix chi nitak-pe roma ri Dios chucolic ri rutinamit? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Xe'el c'a pe ri vinak pa tinamit y xebe ri achique lugar c'o-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ja benak ri ixok chiri', ri discípulos quire' favor xquic'utuj che ri Jesús: Tijonel, tatija' juba' re xekalok'o', xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Jac'a rija' xu'ij chique: Yin c'o achok che nintzuk-vi-vi' ri man iveteman ta rix, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Romari' ri discípulos niquibila' chiquivech: ¿C'o cami jun xc'amo-pe ri achique xutij? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xu'ij chique: Ri nintzuku'ej-vi yin, ja ri nin-en ri nurayij ri takayon-pe vichin, y ninq'uis can rubanic ronojel ri samaj ri ru'in-pe chuve. ");
INSERT INTO cak_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rix ni'ij chi c'a nrojo' na (caji', quiji') ic' richin nemol ruvech ri tico'n. Jac'a yin nin-ij chive: Que'itz'eta' la vinak epetenak. Rije' e'achel jun tico'n ri utz chic richin nimol ruvech. ");
INSERT INTO cak_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri nimolo ruvech ri tico'n, c'o rajil-ruq'uexel nuc'ul, y c'aslen ri richin jumul xtiquic'ul ri xqueniman ruch'abel ri Dios. Riq'uin ri', xtiquicot cánima ri etiquiyon ruch'abel ri Dios junan quiq'uin ri xquemolo ruvech ri tico'n. ");
INSERT INTO cak_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vave' kitzij nibanataj achel nu'ij ri jun tzij: Jun vi nitico ri tico'n y jun vi ri nimolo ruvech. ");
INSERT INTO cak_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yin xixintak chumolic ruvech ri tico'n ri mana-ta rix rix tiquiyon. Xa ch'aka' chic rusamajela' ri Dios etiquiyon ri ch'abel pa tak cánima ri vinak, jac'a rix xaxe chic yixto'on-apu richin nimol ruvech ri tico'n ri'. Quiri' xu'ij ri Jesús chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Chupan ri k'ij ri', eq'uiy aj chiri' pa tinamit Sicar ri c'o pa departamento Samaria xquinimaj ri Jesús, roma ri ixok quire' xu'ij chique: Ri achi ri', ronojel ri enubanalo'n pa nuc'aslen xu'ij chuve, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Romari' xebe ri aj-Samaria, xquic'utuj favor che ri Jesús chi tic'uje-ka chiri' pa quitinamit, y rija' xc'uje-ka ca'i' k'ij chiri'. ");
INSERT INTO cak_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Eq'uiy chic más xeniman richin ri Jesús tok xquic'axaj ri ch'abel ri nu'ij chique. ");
INSERT INTO cak_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Quire' c'a niqui'ij che ri ixok: Vacami nikanimaj, man xe ta chic roma ri xa'ij chike; nikanimaj roma ja roj mismo xojac'axan, y xketemaj chi can kitzij vi chi ja rija' ri Jun ri takon-pe chucolic rutinamit ri Dios, ri Colonel quichin ri vinak choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tok xk'ax ri ca'i' k'ij, ri Jesús xel-pe pa tinamit Sicar, y xbe pa departamento Galilea. ");
INSERT INTO cak_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Roma ja mismo ri Jesús biyon chi jun profeta man jun ruk'ij chiquivech ri aj-rutinamit. ");
INSERT INTO cak_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero tok (xapon, xebos) pa departamento Galilea, ri aj chiri' jabel xquic'ul ruvech, roma xquitz'et ri milagros ri xerubanala' pa Jerusalem chupan ri nimak'ij. Roma ri vinak re' (chuka', ka) xec'uje' chiri' pa nimak'ij. ");
INSERT INTO cak_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Xtzolij chic c'a ri Jesús pa tinamit Caná chiri' pa departamento Galilea, ri achique lugar xu'on vino che ri ya'. Y pa jun chic tinamit rubinan Capernaum, mismo pa Galilea, c'o jun tata'aj nisamaj riq'uin ri rey, y ri tata'aj ri' niyavej jun ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Tok ri tata'aj xrac'axaj chi pa departamento Judea elenak-vi-pe ri Jesús, y xa c'o chic chiri' pa Galilea, xbe-apu riq'uin, y xuc'utuj quemelal che chi ti'e chirij richin nerubana' che ri ruc'ajol chi nic'achoj, roma ri ala' (nicom yan, mayaj chic). ");
INSERT INTO cak_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jac'a ri Jesús xu'ij che: Si rix man nitz'et ta retal ri ruchuk'a' ri Dios y si man yebanataj ta ri man jun bey etz'eton chivech, man ninimaj ta, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero rusamajinel ri rey xu'ij che ri Jesús: Ajaf, tabana' favor, jo-ka chuvij pa tinamit Capernaum, na'ey chi nijik'ijo-ka jumul ri nuc'ajol, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jac'a ri Jesús xu'ij che: Catzolij. Ri ac'ajol nic'ase', xcha'. Y rija' xunimaj ri xu'ij ri Jesús, y xbe. ");
INSERT INTO cak_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tok xulan-ka chiracho, xuc'ul-e coma ri rusamajela' y rije' xqui'ij che: ¡Ri ac'ajol xtzolij-pe ruvech! xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Jac'ari' xuc'utuj chique ri rusamajela' chi achique hora xtzolij ruvech ri ruc'ajol. Xk'ak'ij ivir a la una xq'uis-e ri c'atan chirij, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jari' xuka pa ruvi' rutata' ri ala' chi ja hora ri' tok ri Jesús xu'ij che chi ri ruc'ajol xa nic'ase', roma c'a ri', xuya' ránima riq'uin ri Jesús, y quiri' mismo conojel ri ec'o riq'uin pa racho. ");
INSERT INTO cak_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ja ruca'n milagro re' ri xu'on ri Jesús pa Galilea tok elenak chic pe pa Judea. ");
INSERT INTO cak_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tok xbanataj yan ronojel re', jari' xril ruk'ijul jun quinimak'ij ri israelitas, romari' ri Jesús xbe-e pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chiri' pa tinamit Jerusalem, chunakaj apu ri puerta rubinan Quichin Ovejas, c'o jun atinibel, y c'o vo'o' galeras banon chuchi'. Pa quich'abel ri israelitas, Betesda rubi' ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chupan ri galeras, eq'uiy yeyavej ecotz'ol. C'o man yetzu'un ta, c'o man utz ta cakan, c'o caminak quik'a-cakan, y conojel rije' coyo'en chi nisilon-pe ri ya'. ");
INSERT INTO cak_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roma ri ya' re' c'o k'ij nusilos-ka roma jun ángel ri nipe chicaj, y ri na'ey chique ri yeyavej ri nika-ka chupan ri ya' tok nisilos can, nic'achoj riq'uin xa achique na yabil. ");
INSERT INTO cak_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chiri' c'o c'a jun achi ri ja treinta y ocho juna' tiyavej. ");
INSERT INTO cak_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Tok ri Jesús xutz'et chi cotz'ol chiri', y xretemaj chi c'o chic chi juna' tiyavej, quire' xuc'utuj che: ¿Najo' yac'achoj? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Quire' c'a xu'ij ri niyavej che ri Jesús: Ajaf, tok nusilos-ka ri ya', man jun nibano favor chuve richin yiruya-ka ri pa ya'. C'a ja oc nintij nuk'ij yi'e-apu, ja yan ri' nika-ka jun na'ey chinuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jac'a ri Jesús xu'ij che: Cacataj, tac'olo-e la avaro'el y cabin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ja hora ri' xc'achoj ri achi niyavej. Xuc'ol c'a e ri ruvaro'el y ja xbin. Pero ri k'ij ri' sábado, k'ij richin uxlanen. ");
INSERT INTO cak_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Romari' ri achi'a' israelitas c'o quik'ij xqui'ij che ri achi xc'achojrises: Vacami sábado, k'ij richin uxlanen, man juba' utz chuvech ru-ley ri Dios chi rat (ac'uan, avuc'a'n) la avaro'el. ");
INSERT INTO cak_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Jac'a rija' xu'ij chique: Ja ri xc'achojrisan vichin quire' xu'ij chuve: Tac'olo-e la avaro'el y cabin, xcha' chuve. ");
INSERT INTO cak_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achi'a' xquic'utuj che: ¿Achique x-in chave chi tac'olo' la avaro'el y cabin? ");
INSERT INTO cak_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri achi xc'achojrises man reteman ta achique x-in quiri' che, roma ri Jesús xa xuk'ok'ola-ri' chiquicojol ri vinak xel-pe chiri'. ");
INSERT INTO cak_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","C'ate juba' chiri', ri Jesús xril ri achi pa racho ri Dios, y xu'ij che: Rat vacami xac'achoj riq'uin ri ayabil; man ta'an chic mac, richin quiri' man tipe más c'ayef pan ac'aslen, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xtzolij c'a e ri achi, xberuya' rutzijol chique ri achi'a' israelitas c'o quik'ij chi ja ri Jesús ri xc'achojrisan richin. ");
INSERT INTO cak_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Romari' ri achi'a' ri' nicajo' niqui'en c'ayef che ri Jesús, y niquicanola' achique ta niqui'en richin niquicamisaj, roma ri Jesús ja jun chupan ri sábado ri k'ij richin uxlanen yerubanala' milagros. ");
INSERT INTO cak_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xu'ij: Ri Nata' Dios c'a nisamaj na ri k'ij re', y quiri' yin, c'a yisamaj na. ");
INSERT INTO cak_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y roma ri xu'ij ri Jesús, ri achi'a' israelitas c'o quik'ij más niquicanoj achique ta niqui'en richin niquicamisaj, roma yerubanala' milagros chupan ri sábado ri k'ij richin uxlanen, y hasta nujunumaj-ri' riq'uin ri Dios riq'uin ri nu'ij chi ja ri Dios Rutata'. ");
INSERT INTO cak_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Quire' c'a rutzolic quitzij xu'on ri Jesús: Kitzij-kitzij nin-ij chive, chi yin ri Ruc'ajol ri Dios manak che'el nuyon nin-en-ka ri samaj; nic'atzin chi nintz'et ri achique nu'on ri Nata'. Roma achel ri samaj nu'on ri Nata', quiri' mismo nin-en yin ri Ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Roma ri Nata' Dios can yirojo' yin ri Ruc'ajol, y ronojel ri rusamaj rija' nuc'ut chinuvech. Pero c'a c'o na más chovon tak samaj xtuc'ut chinuvech richin chi rix can achique na xtina' tok xtitz'et. ");
INSERT INTO cak_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Roma can achel nu'on ri Nata' Dios yeruyec-pe ri anima'i' y nuya' quic'aslen, quiri' mismo nin-en yin, ninya' c'aslen chique ri achok chique ninjo' ninya-vi. ");
INSERT INTO cak_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Roma mana-ta ri Nata' Dios ri xtinic'on cánima conojel, xa pa nuk'a' yin ri Ruc'ajol rujachon-vi richin ja yin xquinic'on cánima conojel. ");
INSERT INTO cak_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Richin quiri' conojel xqueyo'on nuk'ij yin ri Ruc'ajol ri Nata', achel ni'an che rija'. Xa achique na jun ri man xtuya' ta nuk'ij yin ri Ruc'ajol, man nuya' ta ruk'ij ri Nata' ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Yin kitzij-kitzij nin-ij chive, chi ri nac'axan ri nuch'abel y nunimaj ri takayon-pe vichin, c'o chic ruc'aslen ri richin jumul. Man xti'e ta chupan ri lugar richin castigo, xa xel yan pe chupan ri camic, y xk'ax-apu chupan ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kitzij-kitzij nin-ij chive, chi nuka na jun k'ij, y ja k'ij re' chi ri ecaminak chuvech ri Dios, xtiquic'axaj nuch'abel yin ri Ruc'ajol ri Dios. Ri xqueniman, xtiquil quic'aslen. ");
INSERT INTO cak_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Roma achel ri Nata' Dios yo'ol c'aslen, quiri' mismo rubanon chuve yin ri Ruc'ajol, chi yin yo'ol c'aslen. ");
INSERT INTO cak_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Pa nuk'a' yin rujachon-vi chi ninnic'oj ronojel ch'utik-nima'k, roma ja yin ri xirutak-pe richin xinalex chi'icojol. ");
INSERT INTO cak_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man jun vi tivac'axaj ri achique xin-ij chive, roma xtuka na jun k'ij tok conojel ri anima'i' xtiquic'axaj ri nuch'abel. ");
INSERT INTO cak_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ri xebano ri utz, xque'el-e y xquec'astaj richin niquil c'aslen. Jac'a ri xebano ri man utz ta, xquec'astaj richin niyo'ox castigo pa quivi'. ");
INSERT INTO cak_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yin manak che'el nuyon nin-en-ka jun samaj; yin ja achel vac'axan-pe riq'uin ri Nata', jari' ruchojmil nincusaj richin ninnic'oj ronojel ch'utik-nima'k. Y can pa ruchojmil nin-en-vi, roma man benak ta vánima pa ruvi' ri achel ninjo' nin-en yin che, xa pa ruvi' ri achel nrojo' ri Nata' Dios ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y si xa nuyon yin yich'o-ka utz chuvij, man jun rakale'n ri nin-ij-ka chuvij. ");
INSERT INTO cak_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero c'o chic jun ri nich'o utz chuvij, y yin veteman chi ri nu'ij rija' chuvij, can kitzij vi. ");
INSERT INTO cak_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Rix c'o xe'itak-e riq'uin ri Juan ri Bautista, y rija' xuk'alajrisaj-pe ri kitzij chivech. ");
INSERT INTO cak_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero yin man nic'atzin ta chi c'a jun na vinak nik'alajrisan (yin achique, ayincu'x) yin. Ninc'uxlaj chive ri xu'ij ri Juan, richin chi rix yixcolotaj. ");
INSERT INTO cak_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ri Juan ri Bautista achel jun k'ak' tok jabel nic'at, y jabel sakil nuya'. Y rix xirayij y xixquicot riq'uin ri sakil ri' jun ca'i-oxi' k'ij. ");
INSERT INTO cak_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero ri más nik'alajrisan vichin yin que chuvech ri nuk'alajrisaj ri Juan, ja ri samaj ri yitajin riq'uin, roma ri samaj ri' can ja ri Nata' biyon-pe chuve chi nin-en, y jari' nik'alajrisan chi ja ri Nata' Dios takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y ri Nata' Dios ri yin takayon-pe, ja jun rija' nik'alajrisan vichin. Jac'a rix man jun bey ivac'axan achel nu'on nich'o, ni man jun bey itz'eton ruvech. ");
INSERT INTO cak_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri ruch'abel rija' man ocunak ta pan ivánima, roma ri Jun ri xutak-pe rija' richin nic'uje' chi'icojol, rix man ninimaj ta rutzij. ");
INSERT INTO cak_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Rix can ninic'oj ruch'abel ri Dios ri tz'iban can, roma ninojij chi chiri' nivil-vi c'aslen ri richin jumul. Pero ri ch'abel ri' ja yin ri yiruk'alajrisaj. ");
INSERT INTO cak_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jac'a rix man nijo' ta niya' ivánima viq'uin richin nivil ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yin man ninc'ul ta nuk'ij quiq'uin vinak. ");
INSERT INTO cak_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero yin veteman chi rix man nijo' ta ri Dios pan ivánima. ");
INSERT INTO cak_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yin pa rubi' ri Nata' Dios yin petenak-vi, y man yininimaj ta. Pero xa ta nipe jun ri ruyon runojin-pe chi petenak, jari' ninimaj-apu rutzij. ");
INSERT INTO cak_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Romari', ¿achel xtiya' ivánima viq'uin, tok xa iyon chivech nic'ulula-ka ik'ij, y man nicanoj ta ik'ij ri petenak riq'uin ri juney Dios? ");
INSERT INTO cak_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Man ti'ij-ka pa tak ivánima chi ja yin ri xquisujun chivij chuvech ri Nata' Dios. Ri xtisujun ivichin, ja ri Moisés, masque rix c'a ivoyo'en na chi ja rija' xtito'on ivichin. ");
INSERT INTO cak_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Roma xa ta rix ninimaj ri erutz'iban can ri Moisés, can ta yininimaj yin, roma ri rutz'iban can rija', jari' nic'utu ri (yin achique, ayincu'x) yin. ");
INSERT INTO cak_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero si man ninimaj ta ri rutz'iban can ri Moisés, man xtinimaj ta ri ch'abel ri nintzijoj yin chive, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tok xbanataj yan ronojel re', ri Jesús xk'ax-apu juc'an ruchi' ri lago Galilea, ri ni'ix Tiberias che. ");
INSERT INTO cak_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Man juba' ta oc xetzekle'en-e richin, roma quitz'eton ri milagros ri yerubanala' quiq'uin ri yeyavej. ");
INSERT INTO cak_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jac'a ri Jesús xjote-e chuvech jun juyu', y chiri' c'a xtz'uye-vi-ka chiquicojol ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri k'ij ri', xa nakaj chic c'o-vi ri pascua, jun quinimak'ij ri israelitas. ");
INSERT INTO cak_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ri Jesús xuyec c'a pe ruvech y xutz'et chi eq'uiy etzalan-apu riq'uin, jac'ari' xu'ij che ri Felipe: ¿Achique c'a lugar xtekalok'o-vi pan richin yeva' conojel ri vinak re'? ");
INSERT INTO cak_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quiri' xu'ij ri Jesús che ri Felipe richin nrojo' nretemaj achique na nunojij. Pero ri Jesús xa reteman achique xtu'on richin yerutzuk. ");
INSERT INTO cak_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ri Felipe xu'ij: Xa ta che rajil vakxaki' ic' samaj nikalok' pan, nis-ta ri' man yeru'on ta, masque jujun bik' oc nikaya' chique chiquijununal, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Jun chique ri discípulos rubinan Andrés, ri quichak'-quinimal qui' riq'uin ri Simón Pedro, quire' xu'ij-apu: ");
INSERT INTO cak_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Vave' c'o jun ala' c'o vo'o' pan banon che cebada y ca'i' ch'utik quer riq'uin. Pero, ¿achique oc xqueru'on-vi conojel ri vinak ri juba' re'? xcha' ri Andrés. ");
INSERT INTO cak_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jac'ari' tok ri Jesús xu'ij: Tibana' chi quetz'uye' conojel, xcha'. Ri lugar ri', jabel sabána c'o. Y xetz'uye' c'a ri achi'a', jun cami vo'o' mil. ");
INSERT INTO cak_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jac'ari' ri Jesús xeruli'ej ri vo'o' pan, xumatioxij che ri Dios, xujachala-e chique ri ru-discípulos, y ri discípulos xquijachala' chique ri etz'uyul. Quiri' mismo xqui'en riq'uin ri quer, xquiyala' chique xa ajani na quer xcajo'. ");
INSERT INTO cak_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tok conojel xnoj yan quipan, ri Jesús xu'ij chique ri ru-discípulos: Timolo-pe ronojel ri ruchi' tak pan y quer ri man xq'uis ta, richin quiri' man xaxe choj quepoq'ue' can pan ulef, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri discípulos xequimolo' c'a pe, y c'a xquinojsaj na doce chaquech che ri ruchi' ri vo'o' tak pan ri banon che cebada ri man xquiq'uis ta ri xeva' chiri'. ");
INSERT INTO cak_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Jac'a tok quitz'eton chic ri milagro ri xu'on ri Jesús, ri vinak xqui'ij: Ri achi re', jare' ri profeta ri q'uiy yan tiempo c'o rutzijol chi nipe chuvech ri roch'ulef, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero ri Jesús xuna'ej chi ri vinak nicajo' nuquic'ama' richin niquicusaj chi rey, romari' rija' ruyon chic xtzolij-e chuvech ri juyu'. ");
INSERT INTO cak_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Jac'a tok xoc-pe ri ak'a', xexule-ka ri discípulos chuchi' ri lago. ");
INSERT INTO cak_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Chiri' xe'oc-e pa jun canoa y ja ebenak pa ruvi' ri ya' richin yebe pa tinamit Capernaum. Xa k'eku'n chic ri hora ri' y ri Jesús c'a man jani teka quiq'uin. ");
INSERT INTO cak_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xtiquer c'a pe ruvi' ri mar nicataj chicaj, roma jun nimalaj cak'ik' ri jani na ruchuk'a'. ");
INSERT INTO cak_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Jac'a tok quiyo'on chic can jun vo'o' o vaki' kilómetros ruchi' ri ya', ri discípulos xquitz'et chi ri Jesús benak-apu chirakan pa ruvi' ri ya' y xa nijel-apu quiq'uin. Rije' xquixi'ij-qui'. ");
INSERT INTO cak_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xu'ij chique: Ja yin; man tixi'ij-ivi', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","C'ajari' yequicot xquic'ul-apu ri Jesús chupan ri canoa, y xa jari' xbequila' ruchi' ri ya' ri achique lugar nicajo' yebe-vi. ");
INSERT INTO cak_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chuca'n k'ij, ri xec'uje' can juc'an apu ruchi' ri ya' xuka pa quivi' chi xaxe jun canoa xc'uje' chiri' chuchi' ri ya', y chi ri Jesús xa man xoc ta e quiq'uin ri ru-discípulos chupan ri jun canoa ri', xa quiyon xebe ri discípulos. ");
INSERT INTO cak_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Jac'a ri k'ij ri', ec'o chic ch'aka' canoas ri epetenak pa tinamit Tiberias ri xe'eka chiri' chunakaj ri lugar ri xetzuk-vi ri vinak riq'uin ri pan ri xumatioxij na'ey ri Ajaf Jesús che ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Jac'a ri vinak, tok xquitz'et chi ri Jesús y ri ru-discípulos man ec'o ta chic chiri', xe'oc c'a e pa tak canoas y xebe pa tinamit Capernaum chucanoxic ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tok ri vinak re' xbequila' ri Jesús ri juc'an apu ruchi' ri ya', xquic'utuj che: Tijonel, ¿achique c'a hora xatuka vave' c'a? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jac'a ri Jesús xu'ij chique ri vinak: Yin kitzij-kitzij nin-ij chive chi rix yinicanoj, pero man roma ta ninojij rij ri achique nic'atzin-vi chi xen-en milagros chivech. Rix yinicanoj xaxe roma xixintzuk riq'uin ri pan ri xa jani na ic'u'x xijo' xitij. ");
INSERT INTO cak_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Rix titija' ik'ij, pero man xaxe richin ninojsaj ri pamaj ri xa niq'uis. Rix más titija' ik'ij chucanoxic ri ninojsan ri ivánima, ri xtinya' chive yin ri xitak-pe richin xinalex chi'icojol. Roma ri ninya' yin chive, nuya' c'aslen ri richin jumul. Quiri' nin-ij chive, roma ri milagros ri yenbanala' yin chivech, jari' yerucusaj ri Dios ri Tata'aj richin retal chi ja rija' takayon-pe vichin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Romari' quire' xquic'utuj che ri Jesús: ¿Achok chirij nic'atzin nikatij-vi kak'ij richin nika'an ri nrojo' ri Dios chike? ");
INSERT INTO cak_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xu'ij chique: Ri nrojo' ri Dios chi ni'en, ja chi rix yininimaj yin ri xitak-pe roma rija'. ");
INSERT INTO cak_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jac'ari' xqui'ij che: ¿Achique c'a jun retal na'an chikavech richin nikatz'et y yatkanimaj? Y, ¿achique ta c'a jun na'an chikavech c'a? ");
INSERT INTO cak_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Roma ri ojer tak kati't-kamama', ja ri maná ri xka-pe chicaj xquitij ri pa chakijlaj tz'iran ulef, achel nu'ij ri tz'iban can: Pan ri petenak chicaj xuya' chique richin xquitij. ");
INSERT INTO cak_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Romari' ri Jesús xu'ij chique: Tivac'axaj c'a ri xtin-ij chive: Ri pan ri xka-pe chicaj, mana-ta ri Moisés xyo'on, pero ri Nata' Dios jari' niyo'on ri kitzij Pan ri richin chicaj chive. ");
INSERT INTO cak_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roma ri Pan ri nuya' ri Dios, ja ri Jun ri petenak chicaj ri c'amayon-pe c'aslen chique conojel choch'ulef, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tok xquic'axaj quiri', rije' xqui'ij che ri Jesús: Ronojel c'a k'ij taya' ri Pan re' chike, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Xu'ij c'a ri Jesús chique: Ja yin ri Pan ri niyo'on c'aslen ri richin jumul. Ri nipe viq'uin, man chic xtivayijan ta ri ránima. Y ri nuya' ránima viq'uin, man jun bey chic xtic'uje' ruchakij-chi' ri ránima. ");
INSERT INTO cak_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero can achel ri nu'in chive: Rix masque xitz'et ri xenbanala' yin chivech, xa man xiya' ta ivánima viq'uin. ");
INSERT INTO cak_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel ri eyo'on-pe chuve roma ri Nata', can xquinquicanoj richin yepe viq'uin, y ri yepe viq'uin, yin man yentzolij ta e. ");
INSERT INTO cak_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Roma yin man richin ta nin-en ri achique ninjo' tok yin kajnak-pe chicaj, xa richin nin-en ri achique nrojo' ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri nrojo' ri Nata' Dios ri takayon-pe vichin, ja chi conojel ri eruyo'on chic chuve, man nis-ta jun chique rije' xtinsetz can, xa xquenc'asoj-e chiquicojol ri anima'i' ri pa ruq'uisbel k'ij. ");
INSERT INTO cak_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Roma ri Nata' ri takayon-pe vichin, nurayij chi conojel ri xtiquetemaj (yin achique, ayincu'x) yin ri Ruc'ajol y niquiya' cánima viq'uin, xtic'uje' quic'aslen ri richin jumul. Y yin xquenc'asoj-e chiquicojol ri anima'i' ri pa ruq'uisbel k'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jac'a ri israelitas ri ec'o-apu chiri', xa yejasjot-apu chirij ri Jesús, roma rija' xu'ij: Ja yin ri Pan ri yin kajnak-pe chicaj. ");
INSERT INTO cak_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Rije' quire' niqui'ij: ¿Mana-ta re' ri Jesús ri ruc'ajol ri José c'a? Pero roj keteman quivech ri rute-rutata'. ¿Achique roma rija' nu'ij chi chicaj kajnak-vi-pe? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xu'ij c'a chique: Man c'a quixjasjot. ");
INSERT INTO cak_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Man jun nipe viq'uin, si man ta ri Nata' ri takayon-pe vichin ri nibochi'in ri ránima. Y ri nipe viq'uin, yin xtinc'asoj-e chiquicojol ri anima'i' ri pa ruq'uisbel k'ij. ");
INSERT INTO cak_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Roma ri tz'iban can coma ri profetas ojer, quire' nu'ij: Conojel c'o xtuc'ut ri Dios chiquivech, y roma c'a ri', xa achique na jun xac'axan richin ri Nata' y c'o xretemaj, ri jun ri' nipe viq'uin y nuya' ránima viq'uin. ");
INSERT INTO cak_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero ri Dios man jun vinak tz'eteyon ruvech, xaxe yin ri yin petenak chicaj riq'uin rija', ri yin tz'eteyon ruvech. ");
INSERT INTO cak_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kitzij-kitzij nin-ij chive: Ri nuya' ránima viq'uin, can c'o-vi ruc'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja yin ri Pan ri niyo'on c'aslen. ");
INSERT INTO cak_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri ivati't-imama' ojer xquitij ri maná ri pa chakijlaj tz'iran ulef, pero ri maná, man xtiquer ta xeruto' chuvech ri camic. ");
INSERT INTO cak_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jac'a ri Pan ri niyo'on c'aslen ri nin-ij yin chive, chicaj kajnak-vi-pe, richin quiri' ri xtitijo richin, man xti'e ta chupan ri camic ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja yin ri c'aslic Pan ri xika-pe chicaj. Xa achique na jun xtitijo ri Pan re', xtic'ase' richin jumul. Ri Pan c'a ri xtinya' yin che, ja ri nu-cuerpo ri xtinjach pa camic richin nuq'uen-pe c'aslen chique ri vinak choch'ulef, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Roma c'a ri', ri israelitas ri ec'o-apu chiri', xa niquich'olila-qui' y quire' niquibila' chiquivech: ¿Achel chi rija' nuya' ri ru-cuerpo chike richin nikatzuk-ki' che? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jac'a ri Jesús xu'ij chique: Kitzij-kitzij nin-ij chive: Si rix man nitzuk ta ivi' che ri nu-cuerpo y man nikum ta ri nuquiq'uel yin ri xitak-pe richin xinalex chi'icojol, can manak vi ic'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri xtutzuk-ri' che ri nu-cuerpo y xtukum ri nuquiq'uel, can c'o chic ruc'aslen ri richin jumul, y yin xtinc'asoj-e chiquicojol ri anima'i' ri pa ruq'uisbel k'ij. ");
INSERT INTO cak_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Roma ri nu-cuerpo yin, jari' ri kitzij ninojsan ri ránima, y ri nuquiq'uel jari' ri kitzij nelesan ruchakij-chi' ri ránima. ");
INSERT INTO cak_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri xtutzuk-ri' che ri nu-cuerpo y xtukum ri nuquiq'uel, rija' xtic'uje' viq'uin y yin xquic'uje' riq'uin rija'. ");
INSERT INTO cak_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Can achel yin rutakon-pe ri c'aslic Nata', y yin roma rija' c'o nuc'aslen, quiri' mismo ri xtutzuk-ri' che ri nu-cuerpo, voma yin xtic'uje' ruc'aslen. ");
INSERT INTO cak_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri Pan ri nin-ij chive chi kajnak-pe chicaj, man junan ta riq'uin ri maná ri xquitij ri ivati't-imama' ojer, roma ri maná man xtiquer ta xeruto' chuvech ri camic. Jac'a ri nutzuk-ri' che ri Pan ri kajnak-pe chicaj, xtic'uje' ruc'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jare' ri xeru'ij ri Jesús richin xerutijoj ri quimolon-qui' pa sinagoga ri pa tinamit Capernaum. ");
INSERT INTO cak_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jac'a tok quic'axan chic ri xu'ij ri Jesús, eq'uiy chique ri yetzekle'en richin xqui'ij: C'ayef ri tzij xeru'ij. ¿Achique xtiniman richin? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jac'a ri Jesús reteman ri niquijasja' chiquivech ri yetzekle'en richin, y romari' xu'ij chique: ¿Caca' cami ivánima nu'on chive riq'uin ri xin-ij? ");
INSERT INTO cak_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Achique ta nibanataj iviq'uin xa ta yinitz'et yin ri xitak-pe richin xinalex chi'icojol chi yitzolij chic e ri achique lugar yinc'o-vi na'ey? ");
INSERT INTO cak_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri niyo'on ri c'aslen ri richin jumul, ja ri Espíritu y mana-ta ri cuerpo. Ri ch'abel ri achok riq'uin rix nutijon-vi, richin ruc'aslen ri ivánima ri nuq'uen-pe chive ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero ec'o chive ri man xtiquiya' ta cánima viq'uin. Quiri' xu'ij ri Jesús, roma reteman (achique, ajecu'x) man xtiquiya' ta cánima riq'uin, y ri jun ri xtijacho-e richin. ");
INSERT INTO cak_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y quire' chic xu'ij: Romari' achel ri nu'in chive, chi nis-ta jun xtipe viq'uin ri man ta samajnak chic ri Nata' pa ránima, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tok xquic'axaj quiri', eq'uiy chique ri yetzekle'en richin xetzolij can, man xquitzekle'ej ta chic. ");
INSERT INTO cak_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Roma c'a ri', ri Jesús quire' xu'ij chique ri doce ru-discípulos: ¿Ja jun rix nijo' yixtzolij can? ");
INSERT INTO cak_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ri Simón Pedro quire' rutzolic rutzij xu'on: Ajaf, ¿achok chirij chic c'a jun xku'e-vi tok aviq'uin rat nilitaj-vi ch'abel ri richin c'aslen richin jumul? ");
INSERT INTO cak_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Roj cukul kac'u'x y kaniman chi ja rat ri Jun ri rat takon-pe roma ri Dios chucolic ri rutinamit, ri rat Ruc'ajol ri c'aslic Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jac'ari' xu'ij ri Jesús chique: ¿Mana-ta yin mismo xicha'on ivichin ri rix doce c'a? Pero xa c'o jun itzel-vinak xel chive, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tok ri Jesús xu'ij quiri', ja ri Judas Iscariote ri xtijacho-e richin ri xrojo' xu'ij. Ri Judas re', jun chique ri doce discípulos y ruc'ajol jun achi rubinan Simón. ");
INSERT INTO cak_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tok xbanataj yan ronojel re', ri Jesús pa ronojel Galilea (xutz'om, xuchop) vi binen chutzijosic ruch'abel ri Dios. Man nrojo' ta chic benak pa tak tinamit richin ri Judea, roma ri achi'a' israelitas c'o quik'ij niquicanola' achique niqui'en richin niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Chupan tak ri k'ij ri', xa nakaj chic ruk'ijul ri jun quinimak'ij ri israelitas ri ni'ix tabernáculos che; jun nimak'ij c'uxle'el richin ri xquik'asaj ri cati't-quimama' pa chakijlaj tz'iran ulef. ");
INSERT INTO cak_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Roma c'a ri', ri eruchak' ri Jesús xqui'ij che: Catel-e juba' vave' pa Galilea y cabin pa Judea, richin quiri' ri xetzekle'en avichin chiri', tiquitz'eta' ri milagros ri ye'abanala'. ");
INSERT INTO cak_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Roma si jun nrojo' chi netemex ri achique nitiquer nu'on, man nu'on ta che'elek'el. Roma c'a ri', si rat yatiquer na'an milagros, te'ac'utu-avi' chiquivech ri vinak, xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Quiri' xqui'ij che ri Jesús, roma masque mismo eruchak', xa man niquinimaj ta. ");
INSERT INTO cak_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jac'a ri Jesús xu'ij chique: Yin man jani tril tiempo richin yi'e ri pa Judea. Jac'a rix xa achique na k'ij c'o che'el yixbe. ");
INSERT INTO cak_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Roma ri vinak ri c'a benak na cánima riq'uin ri roch'ulef, man jun roma itzel yixquitz'et. Jac'a yin xa itzel yinquitz'et, roma man ninvevaj ta chiquivech chi ri yetajin, can itzel vi chi no'oj. ");
INSERT INTO cak_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quixbin-e rix ri pa nimak'ij. Yin man yi'e yan ta e chupan ri nimak'ij re', roma ri k'ij vichin yin, man jani tuka. ");
INSERT INTO cak_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Quiri' ri xu'ij ri Jesús chique, y c'a xc'uje' na can chiri' pa departamento Galilea. ");
INSERT INTO cak_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Tok ebenak chic ri ruchak' chupan ri nimak'ij, c'ajari' xbe rija', pero man chiquivech ta ri vinak, xa che'elek'el. ");
INSERT INTO cak_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jac'a ri achi'a' israelitas c'o quik'ij niquicanola' ri Jesús ri pa nimak'ij, y quire' niqui'ij chique ri vinak: ¿Man itz'eton ta ri jun achi ri'? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Eq'uiy chique ri yenimak'ijun yejasloj chiquivech chirij ri Jesús. Ch'aka' niqui'ij chi jun utzulaj achi, y ch'aka' chic niqui'ij chi xa jun satzoy quino'oj vinak. ");
INSERT INTO cak_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero nis-ta jun cof nich'o, roma quixi'in-qui' chiquivech ri achi'a' israelitas c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Pa runic'ajal ri nimak'ij, c'ajari' xjote-e ri Jesús pa tinamit Jerusalem, xoc-apu pa racho ri Dios, y yerutijoj ri quimolon-qui' chiri'. ");
INSERT INTO cak_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Romari' ri achi'a' israelitas c'o quik'ij, can achique na niquina' che ri Jesús. ¿Achel chi re achi re' can q'uiy reteman chirij ruch'abel ri Dios tok xa man jun bey xutijoj-ri'? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Quire' rutzolic quitzij xu'on ri Jesús: Ri achok riq'uin yixintijoj-vi, man vichin ta yin, xa richin ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jac'a ri nirayin nu'on ri nrojo' ri Dios, xtretemaj si riq'uin ri Dios petenak-vi ri ninc'ut yin, o xa nuyon yin nutz'ucun-ka. ");
INSERT INTO cak_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Roma xa achique na jun ri ruyon nutz'uc-ka ri achique nuc'ut, ruyon nucanoj-ka ruk'ij chiquivech vinak. Pero si c'o jun nrojo' chi ja ri takayon-pe richin ri niyo'ox ruk'ij, nik'alajin chi ja ri kitzij ri nuc'ut, y man jun bey nu'on ri man choj ta. ");
INSERT INTO cak_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ri ley chive rix israelitas xuya-vi ri Moisés ojer can, pero man jun chive rix nibano ronojel ri nu'ij. Quiri' nik'alajin roma rix nicanoj achique ta ni'en richin yinicamisaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Jac'ari' xqui'ij ri vinak che: Rat xa c'o cami itzel espíritu ocunak aviq'uin. ¿Achique ta jun nrojo' nicamisan avichin? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xu'ij chique: Xaxe roma yin xin-en jun milagro chupan jun sábado ri k'ij richin uxlanen, ¿xaxe romari' rix nisatz ic'u'x? ");
INSERT INTO cak_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Roma chupan ri ley ri xuya' ri Dios che ri Moisés nu'ij chi nic'atzin ni'an ri circuncisión, y rix masque chupan jun sábado ri k'ij richin uxlanen, can ni'en-vi ri circuncisión chique ri ch'utik alabo. Pero man riq'uin ta ri Moisés xtz'ucutaj-vi-pe, xa quiq'uin ri más ojer tak ivati't-imama'. ");
INSERT INTO cak_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si rix chupan jun sábado ri k'ij richin uxlanen ni'en circuncidar jun ch'uti ala' richin man nik'aj ruvi' ri ley ri xuya' ri Dios che ri Moisés, ¿achique roma xpe ivoyoval chuve chi xin-en chi xc'achoj jun achi pa jun mismo sábado ri k'ij richin uxlanen? ");
INSERT INTO cak_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Rix man cha'anin yan ti'ij chirij jun chi man utz ta ri najin riq'uin, xaxe roma quiri' pan ivech rix. Na'ey tivetemaj utz-utz, richin quiri' yixtiquer ni'ij si utz, o xa man utz ta, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Roma ri xu'ij ri Jesús, ec'o chique ri aj chiri' pa Jerusalem ri niquibila': ¿Mana-ta cami ri achi re' ri nicanox richin nicamises? ");
INSERT INTO cak_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Titz'eta' c'a, ja la nich'o chiquivech la vinak y man jun achique ni'ix che. Riq'uin juba' ri yebano gobernar chikacojol niquinimaj chi ja rija' ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero roj keteman achique lugar tipe-vi ri achi re'. Jac'a tok xtuka ri Jun ri nutak-pe ri Dios chucolic rutinamit, man jun xteteman aj achique lugar, yecha' ri vinak aj-Jerusalem. ");
INSERT INTO cak_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Romari' ri Jesús, ri najin chiquitijoxic ri vinak chiri' pa racho ri Dios, riq'uin ruchuk'a' xu'ij: Rix ni'ij chi iveteman (achique, ayincu'x) yin y iveteman yin aj achique lugar, pero yin man nuyon ta nunojin-pe chi xipe. Y ri takayon-pe vichin, kitzij chi c'aslic Dios, y rix man iveteman ta runo'oj. ");
INSERT INTO cak_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Jac'a yin veteman runo'oj, roma riq'uin rija' yin petenak-vi; y ja rija' takayon-pe vichin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jac'ari' tok ec'o xcajo' chi can ta (xquitz'om, xquichop) yan e ri Jesús, pero man jun chique rije' xjel ruk'a' chirij, roma man jani tril hora. ");
INSERT INTO cak_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Pero eq'uiy chique ri vinak xeniman richin, y quire' niqui'ij: Tok xtipe ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit, ¿c'o cami más nima'k tak milagros xturubana' que chuvech ri jun re'? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri achi'a' fariseos xquic'axaj chi ri vinak quiri' niquijasja' chiquivech chirij ri Jesús. Romari' ri nima'k tak quik'ij sacerdotes israelitas y ri fariseos, ec'o chique ri yechajin racho ri Dios xequitak-e richin nequic'ama'. ");
INSERT INTO cak_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jari' tok ri Jesús quire' xu'ij: Yin xa juba' chic tiempo yic'uje' iviq'uin, c'ajari' yitzolij-e riq'uin ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rix xquinicanoj, pero man xquinivil ta; y ri achique lugar xquinec'uje-vi yin, man xquixtiquer ta xquixbe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jac'a ri achi'a' israelitas c'o quik'ij quire' niquibila' chiquivech: ¿Achique cami lugar xti'e-vi ri Jesús chi roj man xtikil ta chic? ¿Ni'e cami quiq'uin ri kavinak israelitas ri ec'o pa ch'aka' chic tinamit, o quiq'uin ri man israelitas ta richin yerutijoj? ");
INSERT INTO cak_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Achique cami ruchojmil ri nu'ij chi xtikacanoj y man xtikil ta, y chi ri lugar ri xtec'uje-vi rija', man xkutiquer ta xku'e roj? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ri más nimalaj k'ij richin ri jun semana nimak'ij, ja ri ruq'uisbel k'ij. Y ja chupan ri k'ij ri', ri Jesús xpa'e' y riq'uin ruchuk'a' xu'ij: Si c'o jun c'o ruchakij-chi' ri ránima, tipe c'a viq'uin, y tutija' ri Ya' ri ninya' yin. ");
INSERT INTO cak_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri xtuya' ránima viq'uin, xtibanataj riq'uin achel nu'ij ruch'abel ri Dios, chi ri pa ránima can achel c'aslic tak Ya' xque'alex-pe. ");
INSERT INTO cak_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Ya' ri xu'ij ri Jesús ja ri Lok'olaj Espíritu, ri xa juba' chic k'ij nitiquer-pe chi niyo'ox pa cánima ri niquiya' cánima riq'uin ri Jesús. Y quiri' xu'ij, roma ri Lok'olaj Espíritu man jani tika-pe, roma man jani titzolij-e chicaj ri Jesús richin ninimirises chic ruk'ij. ");
INSERT INTO cak_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","C'o chique ri vinak tok xquic'axaj ri ch'abel ri xeru'ij ri Jesús, xqui'ij: Can kitzij vi chi ri Jesús jare' ri profeta ri oyo'en chi nipe. ");
INSERT INTO cak_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ch'aka' niqui'ij chi ri Jesús jari' ri Jun ri nitak-pe roma ri Dios chucolic ri rutinamit. Pero ch'aka' chic xa quire' niqui'ij: ¿Pa Galilea cami nipe-vi ri Jun ri xtitak-pe roma ri Dios c'a? ");
INSERT INTO cak_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Roma ruch'abel ri Dios ri tz'iban can nu'ij chi ri Jun riy-rumam can ri rey David ri nitak-pe chucolic rutinamit ri Dios, pan aldea Belén ri xc'uje-vi ri David nipe-vi, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Xa xjachataj quivech ri vinak roma man junan ta niquinojij chirij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ec'o c'a ri can xcajo' chi xquic'uaj-e chiquivech ri autoridad, pero xa man jun xjel ruk'a' chirij. ");
INSERT INTO cak_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Tok xetzolij-pe ri achi'a' etakon-e coma ri nima'k tak quik'ij sacerdotes israelitas, y coma ri achi'a' fariseos, rije' quire' xc'utux chique: ¿Achique roma man xiq'uen ta pe ri Jesús? xe'uche'ex. ");
INSERT INTO cak_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Jac'ari' xqui'ij: Roma ri achel nich'o rija', man jun chic jun vinak ri quiri' nich'o, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Romari' ri achi'a' fariseos xqui'ij chique: ¿Ja jun rix xixka pa ruk'a'? ");
INSERT INTO cak_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tiya' na pe pa cuenta, man jun chique ri achi'a' junan niqui'en gobernar, ni man jun chique ri fariseos niquinimaj ri nu'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ri yeniman-apu ri Jesús xa ja ri vinak man jun queteman chirij ri ley ri ruyo'on can ri Moisés. Can ta nika castigo pa quivi', yecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Jac'a ri Nicodemo ri xch'o riq'uin ri Jesús chak'a', quire' xu'ij chique ri ch'aka' chic fariseos ri ec'o chiri': ");
INSERT INTO cak_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Chupan ri ka-ley nu'ij chi roj man jun kak'a' richin nika'ij chi jun vinak c'o rumac, si man nikaya' ta lugar che na'ey chi nuto-ri', y niketemaj si kitzij c'o achique rubanon, xcha' ri Nicodemo. ");
INSERT INTO cak_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Jac'a rije' xqui'ij: Rat man rat ta vinak richin ri departamento Galilea richin nato-pe ri Jesús. Tanic'oj rupan ruch'abel ri Dios; chiri' xtatz'et-vi chi pa Galilea man jun bey xtel-pe jun profeta, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jac'ari' chiquijununal xebe chi tak cacho. ");
INSERT INTO cak_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Xbe c'a ri Jesús ri pa juyu' rubinan Olivos. ");
INSERT INTO cak_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Jac'a tok xsakar-pe chuca'n k'ij, xtzolij chic pa racho ri Dios, y chi jun tinamit xquimol-apu-qui' riq'uin, y rija' xtz'uye' richin yerutijoj. ");
INSERT INTO cak_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Jac'ari' tok ri achi'a' fariseos y ri achi'a' q'uiy queteman chirij ri ley quic'amon-pe jun ixok ri xilitaj chi najin riq'uin mac riq'uin jun achi, y xquipaba' pa nic'aj chuvech ri Jesús, ");
INSERT INTO cak_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y quire' xqui'ij che: Tijonel, ri jun ixok re' najin riq'uin mac riq'uin jun achi tok xilitaj. ");
INSERT INTO cak_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Roj keteman chi ri ley ri xuya' ri Dios che ri Moisés nu'ij chi ri ixoki' quire' yebano, nic'atzin chi yekac'ak che abaj richin yekacamisaj. Jac'a rat, ¿achique na'ij? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Quiri' xqui'ij ri achi'a' ri' che ri Jesús, xaxe roma nicajo' chi nika pa quik'a', richin quiri' yetiquer niquisujuj. Jac'a ri Jesús xa xluque-ka pan ulef, nitz'iban riq'uin ruvi-ruk'a' pan ulef. ");
INSERT INTO cak_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero ri achi'a' ri' roma man yetane' ta ka chi niquic'utuj-apu che ri Jesús ri achique ni'an che ri ixok, romari' ri Jesús xpa'e' y xu'ij: Si c'o jun chive rix man jun mac rubanon, jari' tic'ako ri na'ey abaj chirij ri ixok re', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jac'ari' xluque' chic ka, y xtz'iban chic ka pan ulef. ");
INSERT INTO cak_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Jac'a ri yesujun chirij ri ixok, tok xquic'axaj ri xu'ij ri Jesús, xquina-ka pa cánima chi rije' xa ebanoy mac. Roma c'a ri', chi jujun chi jujun xe'el-e. Na'ey xebe ri más eri'j chic y c'ajari' xe'el-e ri más c'a ac'ola' na. Ruyon chic ri ixok xc'uje' can chuvech ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Xpa'e' c'a ri Jesús, y quire' xuc'utuj che ri ixok: ¿Achique xbanataj quiq'uin ri ec'amayon-pe avichin? ¿Man jun chic xcanaj can richin nrojo' yarucamisaj? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Man jun chic, xcha' ri ixok. Jac'ari' xu'ij ri Jesús che: Nis-ta yin man nin-ij ta chi cacamises; catzolij c'a y man ta'an chic mac, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xch'o chic ri Jesús jun bey chiquivech ri vinak, y xu'ij: Ja yin ri Sakil richin quic'aslen ri vinak choch'ulef. Ri nitzekle'en vichin, man xtibin ta chic pa k'eku'n, xa xtril ri sakil richin ri c'aslen ri richin jumul, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jac'ari' tok ri achi'a' fariseos xqui'ij-apu che ri Jesús: Rat xa ayon chavech natzijoj-ka-avi', y romari' man kitzij ta ri natzijoj, xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jac'a ri Jesús quire' xu'ij chique: Masque yin nuyon nintzijoj-ka-vi', pero can kitzij vi ri nin-ij. Roma yin veteman ri achique lugar yin petenak-vi, y ri achique lugar xquitzolij-vi. Pero rix man iveteman ta achique lugar quipe-vi y man iveteman ta achique lugar xqui'e-vi. ");
INSERT INTO cak_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rix xa aj-roch'ulef no'oj nicusaj richin ninic'oj rij ri nuc'aslen. Jac'a yin man richin ta ninnic'oj rij quic'aslen ri vinak yinc'o. ");
INSERT INTO cak_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Jac'a si yin ninnic'oj rij ruc'aslen jun, pa ruchojmil nin-en-vi, roma man nuyon ta yin yibano, xa c'o viq'uin ri Nata' ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan ri ley ri ibanon-ka ivichin rix che, chiri' nu'ij chi tok eca'i' junan niqui'ij, nik'alajin chi kitzij ri niqui'ij. ");
INSERT INTO cak_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yin mismo yik'alajrisan ri (yin achique, ayincu'x) yin, y ja jun ri Nata' ri yin takayon-pe ri nik'alajrisan vichin, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Romari' ri achi'a' fariseos xqui'ij che ri Jesús: ¿Achique lugar c'o-vi ri Atata' c'a? xecha'. Quire' c'a rutzolic quitzij xu'on ri Jesús: Rix man jun bey jelenak-apu ivánima riq'uin ri Nata', y nis-ta viq'uin yin. Xa ta jelenak-pe ivánima viq'uin yin, quiri' ta mismo ibanon riq'uin ri Nata', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ja ch'abel re' xeru'ij ri Jesús tok yerutijoj ri vinak pa racho ri Dios ri achique lugar niyo'ox-vi can méra, y nis-ta jun xjel ruk'a' chirij, roma man jani tril hora chi ri Jesús (nitz'am, nichap). ");
INSERT INTO cak_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jac'ari' xu'ij chic jun bey chique: Yin yitzolij ri achique lugar yin petenak-vi. Rix xquinicanoj, pero xa iyon (xquixcom, xquixquen) ka chupan ri imac. Ri lugar ri yi'e-vi yin, rix man yixtiquer ta yixbe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Romari' ri achi'a' israelitas c'o quik'ij quire' niquibila' chiquivech: ¿Xtucamisaj cami ri' ruyon ri Jesús? Roma nu'ij chi roj man nkutiquer ta nku'e ri achique lugar ni'e-vi rija', yecha' chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jac'a ri Jesús xu'ij chique: Rix, rix richin ri vave', jac'a yin, yin richin chicaj. Rix, rix richin ri roch'ulef, jac'a yin, man yin richin ta ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Romari' xin-ij chive chi iyon (yixcom, yixquen) ka chupan ri imac. Roma si man ninimaj ta (yin achique, ayincu'x) yin, can (xquixcom xquixquen) na vi chupan ri imac, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jac'ari' tok rije' xquic'utuj chic che ri Jesús: ¿(Achique, aratcu'x) c'a rat c'a? Y ri Jesús xu'ij chique: Xe tok xich'o iviq'uin pa na'ey, ja yan ri' xin-ij chive (yin achique, ayincu'x) yin. ");
INSERT INTO cak_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yin q'uiy yitiquer nin-ij chivij, y q'uiy yitiquer nincusaj chivij richin ninya' castigo pan ivi'. Pero ri takayon-pe vichin, ronojel ri nu'ij can kitzij vi; y yin ja ri vac'axan-pe riq'uin rija' ri nintzijoj vave' choch'ulef, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero rije' man (xk'ax, xno') ta chiquivech chi ri Jesús ja ri aj-chicaj Tata'aj ri nutzijoj chique. ");
INSERT INTO cak_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jari' tok ri Jesús xu'ij chic chique: Ri k'ij tok xquinijotoba' chicaj yin ri xitak-pe richin xinalex chi'icojol, c'ajari' xtivetemaj ri (yin achique, ayincu'x) yin. Y xtivetemaj chi ronojel ri nin-en, man nuyon ta yin nintz'uc-ka, xa ja achel ruc'utun-pe ri Nata' chinuvech, quiri' mismo ruchojmil nin-en yich'o. ");
INSERT INTO cak_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Roma ri takayon-pe vichin, jumul c'o viq'uin y man yin ruyo'on ta can nuyon ri Nata'. Roma yin jumul nin-en ri nika chuvech rija', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Riq'uin ri quiri' xu'ij ri Jesús, eq'uiy xeniman richin. ");
INSERT INTO cak_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jac'ari' tok ri Jesús xu'ij chique ri achi'a' israelitas ri xeniman richin: Si rix cof yixc'uje' chupan ri nuch'abel, xquixoc kitzij tzekle'ey vichin, ");
INSERT INTO cak_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","(chuka', ka) xtivetemaj achique ri kitzij, y ri kitzij xquixrucol. ");
INSERT INTO cak_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jac'a rije' xqui'ij che: Roj, roj riy-rumam can ri Abraham, y man jun bey rojc'o chuxe' quitzij vinak. ¿Achique roma na'ij chike chi xkucolotaj? ");
INSERT INTO cak_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xu'ij chique: Kitzij-kitzij nin-ij chive chi conojel ri c'a yebano na mac, chuxe' rutzij ri mac ec'o-vi. ");
INSERT INTO cak_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y jun lok'on samajinel ri c'o chuxe' rutzij rajaf-jay, man jumul ta xtic'uje' chiracho rajaf ri jay. Ja ralc'ua'l rajaf ri jay, jari' ri xtic'uje' jumul chiracho ri tata'aj. ");
INSERT INTO cak_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Romari' si ja ri Ruc'ajol ri Dios ri xticolo ivichin, can kitzij chi xquixcolotaj. ");
INSERT INTO cak_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yin veteman chi rix, rix riy-rumam can ri Abraham, pero xa nicanola' achique ta ni'en richin yinicamisaj, roma man iyo'on ta lugar chi ocunak ri nuch'abel pan ivánima. ");
INSERT INTO cak_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yin ja ri nutz'eton riq'uin ri Nata' ri nink'alajrisaj. Quiri' mismo rix, ja ri achel nivac'axaj-apu riq'uin ri jun ri ocunak itata' ri yixtajin riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Quire' rutzolic rutzij ri Jesús xqui'en: Ri katata' roj ja ri Abraham, xecha'. Jac'a ri Jesús xu'ij chique: Xa ta kitzij chi rix riy-rumam can ri Abraham, can ta ja achel xerubanala' rija' ri ye'ibanala'. ");
INSERT INTO cak_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero ri Abraham man jun bey xu'on ri achel nibanala' rix vacami. Roma rix xa nicanola' achique ta ni'en richin yinicamisaj, tok yin ja ri kitzij ri vac'axan-pe riq'uin ri Dios ri nintzijoj chive. ");
INSERT INTO cak_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rix ja ri achel nu'on ri jun ri ocunak itata' ri yixtajin riq'uin, xcha' ri Jesús chique. Y rije' xqui'ij che: Roj man roma ta xu'on mac ri kate' che'elek'el tok xojalex. Roj xaxe jun Katata', y ri' ja ri Dios, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jac'a ri Jesús xu'ij chique ri vinak ri': Xa ta ja ri Dios ri Itata', can ta yinijo'; roma yin riq'uin rija' yin elenak-vi-pe richin xinuka chi'icojol. Ja ri Dios takayon-pe vichin y man nuyon ta yin xinojin-pe chi xipe choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Achique roma man (nik'ax, nino') ta chivech ri nin-ij? Quiri' nibanataj iviq'uin, roma rix man nijo' ta nivac'axaj ri nin-ij. ");
INSERT INTO cak_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Rix, rix ralc'ua'l ri itzel, y roma ja rija' ocunak itata', ja ri nika chuvech rija' ri nijo' ni'en. Ri itzel can camisanel vi xe tok xec'uje' vinak pa ruvi' ri roch'ulef, y man xc'uje' ta chupan ri kitzij, roma man jun kitzij riq'uin. Ja ri tz'ucun tak tzij ri nu'ij, jari' nic'utu ri achique rija', roma rija' can tz'ucuy vi tzij, y rajaf ronojel tz'ucun tak tzij. ");
INSERT INTO cak_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Jac'a yin roma nin-ij ri kitzij, rix man yininimaj ta. ");
INSERT INTO cak_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿C'o cami jun chive nitiquer niyo'on chosakil chi yin kitzij c'o mac nubanon? Si ja ri kitzij yitajin chubixic chive, ¿achique roma rix man yininimaj ta? ");
INSERT INTO cak_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Roma jun ri kitzij runiman ri Dios, nuyec pa ránima ri ruch'abel ri Dios ri nrac'axaj. Jac'a rix man quiri' ta ni'en, roma man rix richin ta ri Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Quire' c'a rutzolic rutzij ri Jesús xqui'en ri achi'a' israelitas c'o quik'ij: Can kitzij vi ri ka'in chavij chi rat, xa rat aj-Samaria y xa c'o la'k itzel espíritu aviq'uin, xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jac'a ri Jesús xu'ij chique: Yin manak itzel espíritu viq'uin. Pa ruq'uexel chi quiri', yin ninya' ruk'ij ri Nata', jac'a rix xa nijo' yiniya' chi q'uix. ");
INSERT INTO cak_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Pero yin man nuyon ta nincanoj-ka nuk'ij. C'o Jun nrojo' chi yin niyo'ox nuk'ij, y ja Rija' ri xti'in achique ni'in ri kitzij, si ja yin o ja rix. ");
INSERT INTO cak_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kitzij-kitzij ri nin-ij chive: Xa achique na jun niniman ri nuch'abel, ri vinak ri' man xtutz'et ta ruvech ri camic ri richin jumul, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Quire' c'a xqui'ij ri achi'a' israelitas c'o quik'ij che: Vacami keteman chi kitzij c'o itzel espíritu aviq'uin; roma na'ij chi ri xqueniman ri ach'abel, man xtiquitz'et ta ruvech ri camic. Tatz'eta' c'a ri katata' Abraham y ri profetas ojer can, conojel (xecom, xequen). ");
INSERT INTO cak_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Más cami c'o ak'ij rat que chuvech ri katata' Abraham? Rija' (xcom, xquen), y quiri' mismo ri profetas. ¿Achique ta c'a más abanon rat chiquivech rije'? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xu'ij: Si nuyon yin ninya-ka nuk'ij, man jun nic'atzin-vi. Pero ri niyo'on nuk'ij yin, ja ri Nata' ri ni'ij rix chi i-Dios. ");
INSERT INTO cak_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y rix man iveteman ta runo'oj, jac'a yin veteman runo'oj. Y si nin-ij chi man veteman ta runo'oj, yinoc jun tz'ucuy-tzij achel rix, pero yin kitzij veteman runo'oj, y ninnimaj ri ruch'abel. ");
INSERT INTO cak_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham ri ojer itata' xquicot ránima tok (xk'ax, xno') chuvech chi xtutz'et can ri k'ij tok yin xquic'uje' chuvech re roch'ulef, y can xutz'et na vi y romari' xquicot ránima, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jari' tok ri achi'a' israelitas c'o quik'ij xqui'ij che: Rat c'a man jani nic'aj ciento ajuna', ¿y na'ij chi atz'eton ruvech ri kamama' Abraham? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xu'ij chique: Kitzij-kitzij nin-ij chive, chi na'ey chi xalex ri Abraham, yin yinc'o chic, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tok xquic'axaj quiri', xquisiq'uila' abaj richin niquic'ak chirij. Pero ri Jesús xrevaj-ri' chiquivech, y c'ajari' xel-pe pa racho ri Dios. Chiquicojol ri vinak xk'ax-vi-pe richin xbe. ");
INSERT INTO cak_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Tok ri Jesús nik'ax pa jun lugar, xutz'et jun achi man nitzu'un ta xalex. ");
INSERT INTO cak_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri discípulos xquic'utuj che: Tijonel, ¿Ja cami ri rute-rutata' c'o quimac o ja ri achi re', richin quiri' man nitzu'un ta xalex? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xu'ij: Nis-ta rija' y nis-ta ri rute-rutata'. Rija' man nitzu'un ta xalex, richin quiri' tok xtetzu'un, nek'alajin rusamaj ri Dios riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Yin nic'atzin chi nin-en rusamaj ri takayon-pe vichin, utz ri c'a man jani toc-pe ri ak'a', roma tok xtoc-pe ri ak'a', man jun chic xtitiquer xtisamaj. ");
INSERT INTO cak_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ri ajani k'ij c'a yinc'o na choch'ulef, ja yin sakil richin quic'aslen ri vinak, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tok ru'in chic quiri', ri Jesús xchuban-ka pan ulef, xu'on juq'uet ch'abak che ri (ruchub, ruc'axaj), y xuquil-apu chi runak'-ruvech ri achi man nitzu'un ta. ");
INSERT INTO cak_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y quire' c'a xu'ij che: Vacami cabin, te'ach'aja-avi' pan atinibel Siloé. Siloé nu'ij tzij, Takon-e. Ri achi can xbe na vi, xuch'aj-ri', y tok xtzolij-pe, nitzu'un yan chic. ");
INSERT INTO cak_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Jac'a ri ru-vecinos y ri más chic vinak ri quitz'eton-pe chi can man nitzu'un ta vi, niquibila' c'a: ¿Mana-ta cami re' ri achi nitz'uye' chi tak bey y nuc'utuj limosna? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ec'o ye'in chi ja rija'. Ch'aka' niqui'ij chi quila' nitzu'un, jac'a rija' nu'ij: Ja yin ri', nicha'. ");
INSERT INTO cak_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Roma c'a ri', ri ec'o-apu chiri' quire' xqui'ij che ri achi: ¿Achique x-an chave richin xatiquer xatzu'un? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achi xu'ij chique: Ja ri jun achi rubinan Jesús xbano juq'uet ch'abak y xuquil-apu chi runak' tak nuvech, y xu'ij chuve: Cabin, te'ach'aja-avi' pan atinibel Siloé, xcha' chuve. Yin xi'e c'a, xinch'aj-vi', y jari' xitzu'un. ");
INSERT INTO cak_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Jac'ari' tok ri vinak xquic'utuj che: ¿Achique lugar c'o-vi ri Jesús c'a? xecha' che. Man veteman ta, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Jac'ari' xquiq'uen-apu ri achi nitzu'un chic chiquivech ri achi'a' fariseos. ");
INSERT INTO cak_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pa jun sábado ri k'ij richin uxlanen tok ri Jesús xu'on ri juq'uet ch'abak y xu'on chi xtzu'un ri achi man nitzu'un ta. ");
INSERT INTO cak_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Romari' ja jun ri achi'a' fariseos xec'utun che ri achi ri achique x-an che richin xtzu'un. Rija' xu'ij c'a chique: Ri xbano chuve chi xitzu'un, xuquil juq'uet ch'abak chi runak' tak nuvech, y tok xench'aj, jari' xitzu'un, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Jac'ari' tok ec'o chique ri fariseos xqui'ij: Ri achi Jesús man riq'uin ta ri Dios petenak-vi; roma man nuxlan ta chupan ri sábado ri k'ij richin uxlanen, yecha'. Pero ch'aka' chique ri fariseos niqui'ij: ¿Nitiquer cami jun achi aj-mac yeru'on milagros, achel xu'on ri Jesús riq'uin ri achi re'? Can k'alaj chi ri achi'a' fariseos man junan ta niquinojij. ");
INSERT INTO cak_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Jac'ari' tok quire' chic xquic'utuj che ri achi: ¿Achique chi achi ri xjako ri avech nanojij rat? xecha' che. Rija' xu'ij: Yin ninnojij chi rija' jun profeta, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ri achi'a' israelitas c'o quik'ij man niquinimaj ta chi can man nitzu'un ta vi xalex, y man niquinimaj ta chi roma jun milagro tok xtzu'un, romari' xecoyoj ri rute-rutata', ");
INSERT INTO cak_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","y quire' xquic'utuj chique: ¿Kitzij chi jare' ri ivalc'ua'l ri ni'ij chi man nitzu'un ta xalex? Pero, ¿achel chi vacami nitzu'un? xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Jac'ari' tok quire' xqui'ij ri rute-rutata' ri achi: Kitzij chi ja kalc'ua'l re' y can man nitzu'un ta vi xalex. ");
INSERT INTO cak_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jac'a ri achique x-an richin xtzu'un, man keteman ta, y ri (achique, acu'x) xbano che chi xtzu'un, man keteman ta. Rija' c'o chic rujuna', che rija' tic'utuj-vi, ja rija' mismo ti'in chive. ");
INSERT INTO cak_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quiri' xqui'ij rute-rutata' ri achi, roma xa quixi'in-qui' chiquivech ri achi'a' israelitas c'o quik'ij. Roma ri achi'a' ri' quelesan rutzijol chi xa achique na xti'in chi ri Jesús jari' ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit, nokotex-pe ri pa sinagoga. ");
INSERT INTO cak_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Romari' ri te'ej-tata'aj xaxe xqui'ij: Rija' c'o chic rujuna', che rija' tic'utuj-vi, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Jac'ari' tok ri achi'a' israelitas xcoyoj chic jun bey ri achi ri man nitzu'un ta vi xalex, y xqui'ij che: Ja ri Dios taya' ruk'ij. Roj keteman chi ri achi ri xbano chave chi xatzu'un xa jun aj-mac, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Romari' ri achi quire' xu'ij chique: Si rija' aj-mac, yin man veteman ta. Ri veteman, ja chi yin na'ey man yitzu'un ta, jac'a ri vacami xa yitzu'un chic, xcha' rija'. ");
INSERT INTO cak_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Jac'ari' tok ri achi'a' israelitas xquic'utuj chic jun bey che ri achi: ¿Achique ri xu'on chave? ¿Achique xu'on rija' chi rat xatiquer xatzu'un? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jac'a rija' xu'ij chique: Yin xin-ij yan chive, pero rix man xijo' ta xivac'axaj. ¿Achique roma vacami nijo' chi nincamuluj chic rubixic chive? ¿Ja jun rix nijo' yixoc tzekle'ey richin? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Jac'ari' tok chi oyoval xech'o-vi che y xqui'ij: Rat, rat jun tzekle'ey richin rija', pero roj, roj tzekle'ey richin ri Moisés. ");
INSERT INTO cak_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Roj keteman chi ri Moisés xch'o ri Dios che, jac'a ri achi re' nis-ta keteman achique lugar tipe-vi, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Quire' c'a rutzolic quitzij xu'on ri achi: Romari' nisatz nuc'u'x yin, roma rix man iveteman ta achique lugar nipe-vi, y rija' xu'on chuve chi xitzu'un. ");
INSERT INTO cak_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Roj keteman chi ri Dios man yerac'axaj ta ri ebanoy mac. Pero si jun vinak nuya' ruk'ij ri Dios y nu'on ri nrojo' ri Dios, can nac'axex-vi y niyo'ox che ri nuc'utuj. ");
INSERT INTO cak_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xe tok xec'uje' vinak pa ruvi' ri roch'ulef, man jun bey elenak rutzijol chi c'o ta jun jakayon ruvech jun vinak ri can man nitzu'un ta vi xalex. ");
INSERT INTO cak_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si man ta riq'uin ri Dios petenak-vi ri xbano chuve chi xitzu'un, man ta nitiquer nu'on milagro, xcha' ri achi. ");
INSERT INTO cak_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Quire' c'a rutzolic rutzij xqui'en ri achi: Rat can rat aj-mac vi xatalex, ¿y can najo' nkojatijoj roj? xecha' ri achi'a' israelitas. Jac'ari' xquelesaj-pe ri achi chiri'. ");
INSERT INTO cak_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Tok ri Jesús xrac'axaj chi xeleses-pe ri achi ri pa sinagoga, xerucanoj, y tok xril, xu'ij che: ¿Naya' avánima rat riq'uin ri Ruc'ajol ri Dios? xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ri achi quire' c'a xu'ij: Ta'ij c'a chuve (achique, acu'x) ri Ruc'ajol ri Dios, richin quiri' ninya' vánima riq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xu'ij che: Rat atz'eton chic ruvech ri Ruc'ajol ri Dios. Ja yin ri yich'o aviq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Y ri achi xu'ij: Ninnimaj, Ajaf, xcha'. Y xuya' ruk'ij ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xu'ij: Yin xipe choch'ulef richin nink'alajrisaj achique rubanon cánima ri vinak, richin quiri' ri man yetzu'un ta, xtijakataj quivech. Jac'a ri niquinojij chi yetzu'un, xtin-en chique chi xtik'uk'umer ronojel chiquivech, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jac'ari' jujun chique ri fariseos ri ec'o-apu chunakaj ri Jesús, tok xquic'axaj ri xu'ij, quire' xqui'ij-apu che: Ni modo ja jun roj man nkutzu'un ta, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jac'a ri Jesús xu'ij chique: Más utz man ta yixtzu'un, richin quiri' manak ta imac nivakalej. Pero roma rix ni'ij chi xa yixtzu'un, romari' can c'o mac nivakalej. ");
INSERT INTO cak_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Kitzij-kitzij nin-ij chive: Ri mana-ta chuchi' coral ntoc-vi-apu quiq'uin ri ovejas, y xa juc'an niropin-vi-ka, ri quiri' nibano, re' xa jun vinak ri ntoc ruvi' ruk'a' che'elek'el y jun camisanel elek'on. ");
INSERT INTO cak_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jac'a ri chuchi' coral ntoc-vi-apu, k'alaj chi ja rija' ri yuk'unel quichin ri ovejas. ");
INSERT INTO cak_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ri chajinel quichin ri ovejas nujak-pe ruchi' ri coral chuvech ri yuk'unel, y ri ovejas niquic'axaj ruch'abel ri quiyuk'unel. Rija' chiquijununal nu'ij-apu quibi' ri ru-ovejas y yerelesaj-e. ");
INSERT INTO cak_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tok ri yuk'unel yerelesaj-e conojel ri ru-ovejas, ninabeyaj chiquivech y ri ovejas yebe chirij roma queteman ri rukul. ");
INSERT INTO cak_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jac'a ri mana-ta quiyuk'unel, man niquitzekle'ej ta, xa ye'enimaj chuvech, roma man queteman ta quikul ri man quiyuk'unel ta. ");
INSERT INTO cak_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri ch'abel re xu'ij ri Jesús chique ri achi'a' fariseos, jun ch'abel ri revan juba' ri' ri achique nuc'ut, pero rije' man (xk'ax, xno') ta chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jac'ari' xch'o chic jun bey ri Jesús chique ri achi'a' fariseos, y xu'ij: Kitzij-kitzij nin-ij chive chi ja yin ri Ruchi' quicoral ri ovejas. ");
INSERT INTO cak_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Conojel ri xepe na'ey chinuvech, xa vinak ri ntoc ruvi' quik'a' che'elek'el y ecamisanel tak elek'oma'. Pero ri nu-ovejas xa man xequitzekle'ej ta. ");
INSERT INTO cak_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja yin Ruchi' ri coral. Ri ntoc-pe viq'uin yin, nicolotaj; y c'o che'el ntel-ntoc ri pa coral, y siempre nril ruvay. ");
INSERT INTO cak_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jun elek'on xaxe richin nurubana' elak', nucamisan y nuruq'uisa' ruk'ij ronojel tok nipe. Jac'a yin xipe richin chi rix nivil ri kitzij c'aslen; jun utzulaj c'aslen ri tz'akat yixquicot riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja yin ri utzulaj Yuk'unel. Ri utzulaj Yuk'unel, nuya' ruc'aslen coma ri ru-ovejas. ");
INSERT INTO cak_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jac'a ri xa roma ch'acoj méra yeruyuk'uj ri ovejas y mana-ta kitzij cajaf, rija' tok nutz'et chi nipe jun utif, xa ja rija' ri nucol-e-ri', y yeruya' can quiyon ri ovejas. Y ri utif c'o ovejas yeruc'uaj-e, y ri más chic yeruquiraj-e. ");
INSERT INTO cak_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nenimaj-e ri yuk'unel ri xa roma ch'acoj méra niyuk'un, roma man nik'axo ta che si utz o man utz ta ec'o ri ovejas. ");
INSERT INTO cak_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ja yin ri utzulaj Yuk'unel, y veteman quino'oj ri nu-ovejas, y rije' queteman nuno'oj yin. ");
INSERT INTO cak_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Achel kabanon roj riq'uin ri Nata'. Rija' reteman nuno'oj yin, y yin veteman runo'oj rija', y yin ninya' ri nuc'aslen coma ri ovejas. ");
INSERT INTO cak_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y ec'o chic ch'aka' nu-ovejas ri man erichin ta ri jun coral re', ja jun rije' nic'atzin chi yenq'uen-pe richin yenyuk'uj; y xtiquinimaj ri nin-ij chique. Xaxe jun xtiqui'en, y xaxe jun xtiyuk'un quichin. ");
INSERT INTO cak_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nata' yirojo' roma ninjach ri nuc'aslen pa camic richin chi nic'uje' chic e ri c'aslen ri' jun bey. ");
INSERT INTO cak_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Man jun xtitiquer xtelesan ri nuc'aslen, ja yin mismo yijacho pa camic. Pa nuk'a' yin c'o-vi richin ninya' ri nuc'aslen pa camic, y pa nuk'a' yin c'o-vi richin nin-en chi nic'uje' chic e jun bey. Ri mandamiento re' riq'uin ri Nata' nuc'ulun-vi-pe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jun bey chic man junan ta niquinojij ri achi'a' israelitas c'o quik'ij chirij ri Jesús roma ri ch'abel re xeru'ij. ");
INSERT INTO cak_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Eq'uiy chique rije' quire' xqui'ij: Ri Jesús xa c'o itzel espíritu riq'uin, xa (xch'ujir, xmoxer), y rix ninimaj chic apu ri achique nu'ij, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Pero ch'aka' chic niqui'ij: Jun ri c'o itzel espíritu riq'uin, man nitiquer ta nitzijon achel nitzijon ri Jesús. ¿Nitiquer cami jun itzel espíritu nu'on che jun vinak man nitzu'un ta chi nitzu'un? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa ru-tiempo tef, jari' nik'ases ruk'ijul ri nimak'ij rubinan Dedicación chiri' pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús nibin chiri' pa racho ri Dios chuchi' ri corredor ri richin Salomón ni'ix che. ");
INSERT INTO cak_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achi'a' israelitas c'o quik'ij xquimol-apu-qui' chirij ri Jesús, y xqui'ij che: ¿C'a achique cami k'ij navelesaj-e ri tz'apiyon richin ri kánima? Si ja rat ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit, ta'ij c'a chike. ");
INSERT INTO cak_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Quire' c'a rutzolic quitzij xu'on ri Jesús: Yin nu'in chic chive ri (yin achique, ayincu'x) yin y rix man iniman ta. Ronojel ri yen-en pa rubi' ri Nata' Dios, jari' nik'alajrisan vichin. ");
INSERT INTO cak_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero rix man yininimaj ta, roma man rix nu-ovejas ta, achel ri xin-ij yan chive. ");
INSERT INTO cak_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu-ovejas queteman ri nukul; rije' yinquitzekle'ej, y yin veteman quino'oj rije'. ");
INSERT INTO cak_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yin ninya' chique ri c'aslen ri richin jumul, y man jun bey xtiq'uis ri c'aslen ri' quiq'uin, ni man jun xtelesan-e quichin pa nuk'a'. ");
INSERT INTO cak_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri Nata' Dios ri xeyo'on pa nuk'a', más c'o ruchuk'a' que chuvech xa achique na, y man jun xtelesan-e quichin pa ruk'a' rija'. ");
INSERT INTO cak_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yin y ri Nata' xa roj jun, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jac'ari' tok ri achi'a' israelitas c'o quik'ij xequisiq'uila' chic pe abaj chirij ri Jesús, richin niquic'ak chirij. ");
INSERT INTO cak_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jac'a ri Jesús xu'ij chique ri achi'a' ri': Yin q'uiy utzulaj tak samaj ri petenak riq'uin ri Nata' ri enubanon chivech. ¿Achique chique ri samaj re' ri nu'on chive chi nijo' yinic'ak che abaj? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jac'ari' tok ri achi'a' israelitas c'o quik'ij xqui'ij che ri Jesús: Roj man roma ta ri utzulaj tak samaj tok yatkac'ak che abaj, xa roma rat itzel na'an chuvech ri Dios riq'uin ri najunumaj-avi' riq'uin. Y rat xa rat jun achi aj-roch'ulef, xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xu'ij c'a chique: Ri ley ri yo'on can pan ik'a' nu'ij: Yin nu'in chi rix, rix dios. ");
INSERT INTO cak_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Roj keteman chi ri nu'ij chupan ruch'abel ri Dios, manak che'el chi man ta kitzij. Romari' si ri Dios xu'ij dios chique ri achok chique xuya-vi ri ruch'abel, ");
INSERT INTO cak_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿achique roma rix ni'ij chi itzel xin-en chuvech ri Dios tok xin-ij chi yin Ruc'ajol, tok xa ja yin ri xirucha' richin xirutak-pe choch'ulef? ");
INSERT INTO cak_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si man nin-en ta ri samaj ri ru'in-pe ri Nata' Dios chi nin-en, man quininimaj. ");
INSERT INTO cak_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero si nin-en, quininimaj roma ri samaj, masque man yininimaj ta yin, pero tinimaj ri nin-en chivech, richin quiri' nivetemaj y ninimaj chi ri Nata' Dios c'o viq'uin, y yin riq'uin rija'. Quiri' xu'ij ri Jesús chique ri achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Romari', jun bey chic xcajo' (xquitz'om, xquichop), pero ri Jesús xa xbe chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jac'ari' xk'ax chic apu ri Jesús juc'an ruchi' ri rakan-ya' Jordán, ri achique lugar xu'on-vi bautizar ri Juan ri Bautista pa na'ey, y chiri' xc'uje-vi. ");
INSERT INTO cak_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Man juba' ta oc vinak nequimolo-qui' riq'uin, y quire' niquibila': Ri Juan ri Bautista kitzij chi nis-ta jun milagro xu'on richin ta xuc'ut-ri' achique takayon-pe richin, pero ronojel ri xu'ij ri Juan chirij ri achi re', can kitzij vi, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y eq'uiy xeniman richin ri Jesús chupan ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","C'o c'a jun achi niyavej rubinan Lázaro, aj pa Betania, ri aldea ri c'o-vi cacho ri María y ri Marta ri quichak'-quinimal qui'. ");
INSERT INTO cak_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ri María re', jare' ri xyo'on jubulaj ak'on chirij rakan ri Ajaf Jesús y xerusu' riq'uin ri rusumal tak ruvi'. Rija' rana' ri Lázaro ri niyavej. ");
INSERT INTO cak_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Roma c'a ri', ri ca'i' rana' quire' rubixic xquitak-e che ri Jesús: Ajaf, nikaya' rutzijol chave chi ri kaxibal Lázaro, ri jani na najo', vacami niyavej. ");
INSERT INTO cak_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Tok ri Jesús xrac'axaj ri takon-e rubixic che, rija' xu'ij: Ri yabil ri c'o riq'uin ri Lázaro man richin ta camic, xa richin nik'alajin ri nimalaj ruk'ij ri Dios, richin quiri' ja jun ri Ruc'ajol ri Dios niyo'ox ruk'ij, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús yerojo' ri Marta, ri María, y ri Lázaro. ");
INSERT INTO cak_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jac'a tok xrac'axaj chi ri Lázaro niyavej, c'a xc'uje' na ca'i' k'ij chupan ri lugar ri c'o-vi. ");
INSERT INTO cak_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","C'ajari' tok xu'ij chique ri ru-discípulos: Vacami kutzolij pa departamento Judea, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Quire' c'a niqui'ij ri ru-discípulos che: Tijonel, ri achi'a' israelitas c'o quik'ij ivir-cabijir quic'ualo'n abaj chavij richin nicajo' yatquicamisaj. Y, ¿vacami rat najo' chic yatzolij chila'? ");
INSERT INTO cak_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jac'a ri Jesús xu'ij chique: Ri k'ij ruc'uan doce horas, y ri nibin pak'ij, man (nupak'ij, nucopij) ta rakan, roma xa sakil rubanon ruvech ri hora. ");
INSERT INTO cak_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero ri nibin chak'a', (nupak'ij, nucopij) rakan, roma rija' man jun sakil riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tok ru'in chic quiri', ri Jesús quire' chic xu'ij chique ri ru-discípulos: Ri Lázaro ri keteman ruvech, xa niver. Pero vacami yi'e richin nenc'asoj, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jac'ari' tok ri ru-discípulos xqui'ij che: Ajaf, si ri Lázaro niver, nic'achoj, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tok ri Jesús xu'ij chi niver, xa chirij rucamic ri Lázaro xch'o-vi, pero ri discípulos xquinojij chi pa ruvi' uxlanen y varan nich'o-vi. ");
INSERT INTO cak_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'ajari' tok ri Jesús xuk'alajrisaj ronojel chiquivech. Rija' xu'ij: Ri Lázaro xa (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y yin yiquicot roma utz chive rix chi man yinc'o ta pa Betania tok (xcom, xquen), richin quiri' más xticuker ri ivánima viq'uin. Vacami c'a, jo' tekatz'eta', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jac'a ri Tomás ri discípulo ri ni'ix Gemelo che, quire' xu'ij chique ri ch'aka' chic discípulos: Jo' chirij ri Jesús, richin quiri' junan nkucamises riq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Tok ri Jesús y ri ru-discípulos xe'eka ri pa Betania, xyo'ox rutzijol chique chi ri Lázaro ja (caji', quiji') k'ij timuk. ");
INSERT INTO cak_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri Betania man naj ta quicojol riq'uin ri tinamit Jerusalem, xa jun cami oxi' kilómetro. ");
INSERT INTO cak_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ja roma rucamic ri quixibal ri Marta y ri María, eq'uiy israelitas ekajnak chicacho richin niquiya' ruchuk'a' cánima. ");
INSERT INTO cak_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tok ri Marta xrac'axaj chi ri Jesús petenak pa bey, xel-e richin xeruc'ulu', jac'a ri María xcanaj can pa jay. ");
INSERT INTO cak_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jac'ari' tok ri Marta xu'ij che ri Jesús: Ajaf, xa ta vave' ratc'o-vi, ri nuxibal man ta (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero yin veteman chi ri Dios c'a nuya' na chave xa achique na ri nac'utuj che, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jac'ari' tok ri Jesús xu'ij che ri Marta: Ri axibal Lázaro xtic'astaj, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ja', yin veteman chi xtic'astaj chupan ri k'ij tok conojel ri anima'i' xquec'astaj pa ruq'uisbel k'ij, xcha' ri Marta. ");
INSERT INTO cak_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xu'ij che: Ja yin ri yic'ason quichin ri anima'i' y ja yin ri quic'aslen. Xa achique na ri ruyo'on ránima viq'uin, masque caminak chic, xtic'astaj chic jun bey. ");
INSERT INTO cak_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y conojel ri quilon quic'aslen viq'uin y quiyo'on cánima viq'uin, man (yecom, yequen) ta richin jumul. ¿Nanimaj re'? xcha' ri Jesús che ri Marta. ");
INSERT INTO cak_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ja', Ajaf. Yin ninnimaj ronojel ri na'ij; roma veteman chi ja rat ri Jun ri takon-pe chucolic rutinamit ri Dios, y can rat Ruc'ajol vi ri Dios ri rat petenak choch'ulef, xcha' ri Marta. ");
INSERT INTO cak_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tok ri Marta ru'in chic quiri' che ri Jesús, xtzolij richin xroyoj-pe ri ruchak', y xaxe pa ruxiquin quire' xu'ij che: Ri Tijonel c'o chic vave' y yaroyoj, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María xe xrac'axaj ri xu'ij ri Marta che, cha'anin xcataj y xbe ri achique lugar c'o-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús c'a man jani toc-apu ri pan aldea Betania, xa c'a ja c'o ri achique lugar xuc'ul-vi roma ri Marta. ");
INSERT INTO cak_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Jac'a ri israelitas ri epetenak richin niquiya' ruchuk'a' ránima ri María, tok xquitz'et chi junanin xcataj-e y xbe, rije' xquitzekle'ej-e y niqui'ij: Ri María xa ja ri achique lugar mukun-vi ri ruxibal ni'e-vi richin ne'ok', yecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jac'a ri María tok (xapon, xebos) ri achique lugar c'o-vi ri Jesús, xe xutz'et, ja xxuque-ka chuvech y xu'ij che: Ajaf, xa ta vave' ratc'o-vi, ri nuxibal man ta (xcom, xquen), xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jac'a ri Jesús tok xutz'et chi ri María y ri israelitas ri ec'o riq'uin ye'ok', rija' xjik'ijo' ránima, y nibarbot. ");
INSERT INTO cak_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Jari' tok xuc'utuj: ¿Achique lugar ximuk-vi ri Lázaro? xcha'. Rije' xqui'ij: Ajaf, jo', nekac'utu' chavech, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ri Jesús xok'. ");
INSERT INTO cak_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jac'ari' xqui'ij ri israelitas ri ec'o-apu chiri': Titz'eta' la Jesús, nrok'ej ri Lázaro. Nik'alajin chi can kitzij xrojo', yecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero ec'o ch'aka' niquibila': Ri achi re', ¿man xtiquer ta cami xu'on chi man ta (xcom, xquen) ri Lázaro, tok xa xtiquer xu'on che ri achi man nitzu'un ta chi xtzu'un? yecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Riq'uin ri quiri' nibilo'x, ri Jesús xjik'ijo' chic jun bey ránima xjel-apu chuchi' ri jul ri mukun-vi ri Lázaro. Ri jul ri' c'oton chuvech jun juyu', y tz'apin can ruchi' riq'uin jun abaj. ");
INSERT INTO cak_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jac'ari' tok ri Jesús xu'ij: Tivelesaj la abaj chuchi' ri jul, xcha'. Jac'a ri Marta, ri rana' ri Lázaro xu'ij che ri Jesús: Ajaf, ri nuxibal ja (caji', quiji') k'ij tikamuk y yin nin-ij chi chuf chic ruxla', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xu'ij che ri Marta: Yin xin-ij yan chave: Si xtanimaj, xtatz'et ri nimalaj ruk'ij ri Dios, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jari' tok xquelesaj-e ri abaj chuchi' ri jul. Xtzu'un c'a e ri Jesús chicaj y xu'ij: Nata', matiox ninya' chave roma xinavac'axaj-pe. ");
INSERT INTO cak_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yin veteman chi rat can yinavac'axaj-vi. Pero yin xin-ij re' coma ri quimolon-pe-qui' viq'uin vacami, richin quiri' tiquinimaj chi ja rat xatako-pe vichin choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tok ri Jesús ru'in chic ka quiri', jari' tok riq'uin ruchuk'a' xu'ij: ¡Lázaro, cacataj, catel-pe! xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Jac'ari' tok ri ámna Lázaro xel-pe ri pa jul. Ri ruk'a-rakan ebolkotin pa tak tziek, y ri ruvech tz'apin-e riq'uin jun tziek lab oc. Ri Jesús xu'ij: Que'isolo' can la tziek chirij, y tiya' lugar che chi ni'e, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Eq'uiy c'a chique ri israelitas ri epetenak chiquitz'etic ri María xquinimaj ri Jesús tok xquitz'et ri xu'on. ");
INSERT INTO cak_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero ec'o ch'aka' xebe quiq'uin ri achi'a' fariseos y xquitzijoj ri achique xu'on ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Jac'ari' ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' fariseos xecoyoj ri achi'a' junan niqui'en gobernar quiq'uin, y xqui'ij chique: ¿Achique nika'an? Roma ri achi re' q'uiy milagros yerubanala' chiquivech ri vinak. ");
INSERT INTO cak_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si xtikaya' lugar che, conojel xqueniman richin, y xquepe ri vinak romanos, xtuquiq'uisa' can ruk'ij ri jay ri nikaya-vi ruk'ij ri Dios y quiri' mismo ri katinamit, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero ri Caifás ri nimalaj sacerdote chiquicojol ri israelitas chupan ri tiempo ri', quire' xu'ij: Rix man iveteman ta ruchojmil re'. ");
INSERT INTO cak_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Tiya' na pe pa cuenta, más utz chi xe ri jun achi re' (nicom, niquen) pa kaq'uexel konojel y mani niq'uis ronojel ri katinamit, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Tok ri Caifás xu'ij quiri', man ruyon ta rija' xnojin-pe ri ch'abel ri xeru'ij. Xa roma ja rija' ri nimalaj sacerdote chiquicojol ri israelitas ri juna' ri', romari' ri Dios xuya' lugar chi xuk'alajrisaj yan chi ri Jesús (xticom, xtiquen) pa quiq'uexel ri israelitas. ");
INSERT INTO cak_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero ri Jesús man xe ta coma ri israelitas tok (xticom, xtiquen), xa richin junan cánima nu'on chique conojel ri ralc'ua'l ri Dios ri quiquiran-qui' choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ja k'ij ri' xtiquer-e chi ri achi'a' junan niqui'en gobernar xquitz'uc runojixic achique ta niqui'en richin niquicamisaj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Roma c'a ri', ri Jesús man can ta chic xuc'ut-ri' chiquivech ri israelitas, xa xbe pa tinamit Efraín, jun tinamit ri c'o chunakaj ri chakijlaj tz'iran ulef. Chiri' c'a xc'uje-vi quiq'uin ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Jac'a ri k'ij richin ri jun quinimak'ij ri israelitas rubinan pascua, xa nakaj chic c'o-vi. Romari' eq'uiy vinak xe'el-pe pa tak quitinamit, y xebe pa tinamit Jerusalem, richin nequich'ajch'ojij-qui' achel nu'ij chupan ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Rije' niquicanola' ri Jesús, y quimolon-qui' pa racho ri Dios, quire' niquic'utula' chiquivech: ¿Achique ninojij rix? ¿Nipe cami chupan ri nimak'ij? yecha' chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jac'a ri nima'k tak quik'ij sacerdotes israelitas y ri achi'a' fariseos, quiyo'on rutzijol chique ri vinak chi xa achique na jun xtitz'eto achique lugar c'o-vi ri Jesús, tuya' rutzijol chique richin (niquitz'om, niquichop). ");
INSERT INTO cak_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tok xaxe chic vaki' k'ij nrojo' chi nitiquer ri nimak'ij pascua, ri Jesús xbe pa Betania, ri c'o-vi ri Lázaro ri (xcom, xquen) y xc'asos chic roma ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chiri' x-an jun utzulaj va'in roma ri Jesús. Ja ri Marta ri nilin-apu pa mesa, y tz'uyul yan chic apu ri Lázaro chiquicojol ri ec'o-apu chuchi' ri mesa riq'uin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Jac'ari' tok ri María xberuc'ama-pe jun nic'aj litro nardo, jun c'aslic jubulaj ak'on ri man juba' ta oc rajil. (Xuk'ej, xuk'ij) c'a chirij rakan ri Jesús y riq'uin ri rusumal tak ruvi' xerusula-vi. Ronojel rupan ri jay nijubub riq'uin ruxla' ri ak'on. ");
INSERT INTO cak_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Jari' tok xch'o-apu jun chique ri ru-discípulos ri Jesús rubinan Judas Iscariote, ralc'ua'l jun achi rubinan Simón. Ri Judas ri', jari' ri xtijacho-e richin ri Jesús. Rija' xu'ij: ");
INSERT INTO cak_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Achique roma man xc'ayix ta ri jubulaj ak'on re'? Roma re' rajil achel nuch'ec jun samajinel jun juna', y ri méra ri', xjach ta chiquivech ri man jun oc quichajin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Rija' quiri' xu'ij-apu, pero man roma ta chi kitzij nrojo' yeruto' ri man jun oc quichajin. Xa roma rija' can elek'on vi, y ja rija' uc'uayon ri méra ri niquicusaj ri Jesús y ri ru-discípulos, y xa can c'o-vi nrelek'aj-e chucojol. ");
INSERT INTO cak_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jac'a ri Jesús xu'ij che ri Judas: Jun taya-vi ri María, roma ri ak'on re' ruyacon-pe rija' richin ri k'ij chi yin yimuk. ");
INSERT INTO cak_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Roma ri man jun oc quichajin, jumul ec'o chi'icojol, jac'a yin man jumul ta xquic'uje' iviq'uin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Eq'uiy c'a vinak israelitas xena'en chi ri Jesús c'o pa Betania, roma c'a ri' xepe, pero man xe ta roma ri Jesús, xa ja jun roma ri Lázaro ri xuc'asoj-pe chiquicojol ri anima'i' nicajo' niquitz'et can. ");
INSERT INTO cak_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Jac'a ri nima'k tak quik'ij sacerdotes israelitas xqui'ij chiquivech chi ja jun ri Lázaro xtiquicamisaj, ");
INSERT INTO cak_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","roma chirij rija' niquik'ebaj-vi chi eq'uiy quivinak ri ye'el-e quiq'uin richin niquinimaj ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jac'a ri chuca'n k'ij, tok xquic'axaj chi petenak ri Jesús, eq'uiy chique ri vinak ri ec'o chiri' pa tinamit Jerusalem roma ri nimak'ij, ");
INSERT INTO cak_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","xequic'amala-pe ruk'a' tak palma y xebe chuc'ulic, y riq'uin cuchuk'a' niquibila': ¡Matiox chi petenak ri Colonel re'! ¡Nimalaj favor c'o pa ruvi' re ka-Rey roj israelitas re petenak pa rubi' ri Ajaf! yecha'. ");
INSERT INTO cak_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri Jesús rilon-pe jun alaj burro, y (ch'ocol, tz'uyul) e chirij benak. Achel nu'ij chupan ruch'abel ri Dios ri tz'iban can: ");
INSERT INTO cak_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man tuxi'ij-ri' ri ivánima rix ri rix richin ri tinamit Sion. Titz'eta' ja petenak ri i-Rey iviq'uin, (Ch'ocol, tz'uyul) pe chirij jun ch'uti burro ral jun burra. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Pero ri discípulos pa na'ey man juba' (xk'ax, xno') chiquivech, y c'a ja tok ri Jesús ruc'ulun chic nimalaj ruk'ij chicaj, c'ajari' tok xuka pa quivi' chi ronojel ri xbanataj riq'uin, can ja achel ri tz'iban can ojer. ");
INSERT INTO cak_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri xetz'eto richin ri Jesús tok xusiq'uij-apu rubi' ri Lázaro richin xuc'asoj chiquicojol ri anima'i', niquitzijoj chique ri ch'aka' chic vinak ronojel ri quitz'eton. ");
INSERT INTO cak_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Roma c'a ri', ri vinak xepe richin nuquic'ulu' ri Jesús roma xquic'axaj rutzijol ri milagro ri xu'on riq'uin ri Lázaro. ");
INSERT INTO cak_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jac'a ri achi'a' fariseos niquibila' chiquivech: Titz'eta' c'a, manak chic achique nika'an, roma xa conojel vinak ebenak chirij, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Chiquicojol ri ec'o-e pa tinamit Jerusalem richin niquiya' ruk'ij ri Dios chupan ri nimak'ij ri', ec'o jujun vinak griegos. ");
INSERT INTO cak_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Rije' xejel-apu riq'uin ri Felipe ri aj-Betsaida, ri tinamit c'o pa Galilea richin xquic'utuj quiquemelal che, y quire' xqui'ij: Roj nikajo' nkuch'o juba' riq'uin ri Jesús, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xbe-apu riq'uin ri Andrés richin xu'ij che. C'ajari' chi ca'i' xebe-apu riq'uin ri Jesús richin xqui'ij che ri favor ri niquic'utuj ri vinak griegos. ");
INSERT INTO cak_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jac'a ri Jesús xu'ij chique ri ca'i' discípulos: Ja xril k'ij chi yin ri xitak-pe richin xinalex chi'icojol xtic'uje' chic nuk'ij jun bey. ");
INSERT INTO cak_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kitzij-kitzij nin-ij chive: Si jun ch'uti ruvech trigo nikapokonaj nikamuk-ka pan ulef, man niq'uiyer ta ruvech. Can kitzij na vi, tok nimuk-ka jun semilla, xa niq'uis chuxe' ulef, pero tok xtel-pe, q'uiy ruvech xtuya'. ");
INSERT INTO cak_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quiri' mismo ri nupokonaj ruc'aslen choch'ulef, man xtril ta ri c'aslen ri richin jumul. Jac'a ri man nupokonaj ta ruc'aslen choch'ulef, can nuchajij-apu-ri' richin ri c'aslen ri richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ri nrojo' nu'on ri nusamaj, quirutzekle'ej. Y ri lugar yinc'o-vi yin, chiri' mismo xtic'uje-vi ri nibano ri nusamaj. Si c'o jun nibano ri nusamaj, xti'an che roma ri Nata' chi xtic'uje' ruk'ij. ");
INSERT INTO cak_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yin vacami can nik'axo ri vánima. ¿Pero xtin-ij cami che ri Nata': Quinacolo' chuvech ri k'axomal richin ri hora re', tok xa richin yik'ax chupan ri c'a yinc'o na? ");
INSERT INTO cak_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jac'ari' tok ri Jesús xu'ij: Nata', tabana' chi nik'alajin ri nimalaj ak'ij, xcha'. Jac'ari' xch'o-pe jun kulaj chicaj ri quire' xu'ij: Yin nuk'alajrisan chic, y c'a xtink'alajrisaj chic na jun bey, xcha-pe. ");
INSERT INTO cak_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Roma c'a ri', ri ec'o chiri' y xquic'axaj ri ch'abel, niqui'ij chi jun rayo xk'ajan. Ch'aka' chic niqui'ij: Jun ángel xch'o-pe che, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Quire' c'a xu'ij ri Jesús chique: Ri kulaj ri xivac'axaj, man voma ta yin xch'o-pe, xa ivoma rix. ");
INSERT INTO cak_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vacami, ja xril k'ij chi ninic'ox ri achique c'o pa cánima conojel aj-choch'ulef, y ri itzel ri c'o ruk'a' che ri roch'ulef, xteleses ri uchuk'a' ri' pa ruk'a'. ");
INSERT INTO cak_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Jac'a yin riq'uin ri xquijoto'ex chicaj, xtinbochi'ij cánima conojel richin yinquinimaj, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Riq'uin ri quiri' xu'ij, xuk'alajrisaj ri achique chi camic xteruk'asaj. ");
INSERT INTO cak_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Romari' ri vinak xqui'ij che: Roj kac'axan chupan ru-ley ri Dios, chi ri Jun ri xtutak-pe chucolic ri rutinamit, xa richin jumul xtic'uje'. ¿Achique roma rat na'ij chi ri Jun ri nalex chikacojol nic'atzin chi nijoto'ex chicaj? ¿(Achique, acu'x) c'a ri Jun ri na'ij chi nalex chikacojol? xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jac'ari' tok ri Jesús xu'ij chique: Ri Sakil c'a nic'uje' chic juba' iviq'uin. Quixbin c'a chupan ri Sakil ri', utz ri c'a c'o na, richin quiri' man xa (quixrutz'om, quixruchop) k'eku'n. Roma ri nibin pa k'eku'n, man reteman ta achique lugar benak-vi. ");
INSERT INTO cak_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Y utz ri c'a yinc'o na yin ri yiyo'on Sakil pan ibey, tiya' ivánima viq'uin, richin nik'alajin ri Sakil pan ic'aslen. Quiri' xu'ij ri Jesús chique, jac'ari' xbe chiquivech y man jun xeteman achique lugar xbe-vi. ");
INSERT INTO cak_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús masque q'uiy milagros xerubanala' chiquivech ri vinak, pero rije' man xquinimaj ta, ");
INSERT INTO cak_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","richin quiri' nibanataj ri rutz'iban can ri profeta Isaías, tok xu'ij: Ajaf, man eq'uiy ta xeniman ri ach'abel ri kayo'on rutzijol. Man eq'uiy ta ri (k'axnak, novinak) chiquivech ri nimalaj avuchuk'a'. Quiri' ri rutz'iban can ri Isaías. ");
INSERT INTO cak_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Y ri vinak re' man yetiquer ta niquinimaj, roma ri profeta Isaías c'o chic jun tzij ru'in can ri quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Ri Dios rubanon chique achel man yetzu'un ta, y rucovirisan ri cánima Richin man jun achique niquitz'et riq'uin ri quivech, richin quiri' man ntoc ta pa cánima, Ni man niquijal ta quino'oj richin chi yin ninchojmirisaj ri quic'aslen, nicha' ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Quiri' xu'ij ri profeta Isaías ojer can, tok xutz'et ri nimalaj Sakil richin ri Ajaf Jesús, y xutzijoj achique rubanic ri xutz'et. ");
INSERT INTO cak_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero masque quiri' nu'ij ri tz'iban can, eq'uiy chique ri achi'a' ri junan niqui'en gobernar chiquicojol ri israelitas xeniman richin ri Jesús. Pero coma ri achi'a' fariseos, rije' man xquik'alajrisaj ta qui' chi xquinimaj ri Jesús, richin man ye'okotex-pe ri pa sinagoga. ");
INSERT INTO cak_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rije' man xcajo' ta xquik'alajrisaj-qui', roma más nicajo' chi c'o quik'ij chiquivech ri vinak, que c'o quik'ij chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jari' tok ri Jesús riq'uin ruchuk'a' xu'ij: Ri xtuya' ránima viq'uin, man xe ta viq'uin yin nuya-vi ri ránima, ja jun riq'uin ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri nitz'eto nuvech, nutz'et ruvech ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja yin ri Sakil ri xipe choch'ulef, richin quiri' xa achique na jun ri xtuya' ránima viq'uin, man xtic'uje' ta chic chupan ri k'eku'n. ");
INSERT INTO cak_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ri nac'axan ri nuch'abel y man nunimaj ta, mana-ta yin xquiyo'on castigo pa ruvi'. Roma yin man richin ta chi ninya' castigo pa quivi' ri vinak tok xipe choch'ulef. Yin xipe richin yencol. ");
INSERT INTO cak_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero xa achique na jun ri manak nuk'ij chuvech y man nuc'ul ta ri nuch'abel pa ránima, c'o xtiyo'on castigo pa ruvi'; ja ri ch'abel ri xintzijoj ri xtiyo'on castigo pa ruvi' pa ruq'uisbel k'ij. ");
INSERT INTO cak_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Roma ri ch'abel ri xintzijoj chivech, man nuch'abel ta yin, ja ri Nata' ri takayon-pe vichin ri biyon-pe chuve, y yin rupaxa'an-pe riq'uin ri achique nin-ij y achique ninc'ut. ");
INSERT INTO cak_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yin veteman chi ri ru-mandamiento ri Nata' Dios nuq'uen-pe ri c'aslen ri richin jumul. Romari' ri ch'abel ri nintzijoj yin, can ja achel ru'in-pe ri Nata' chuve, quiri' rubixic nin-en. ");
INSERT INTO cak_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Tok juba' chic k'ij nrojo' richin ri nimak'ij pascua, ri Jesús reteman chi ja xuka hora richin ntel-e choch'ulef y nitzolij riq'uin ri Rutata'. Ri Jesús jumul xerojo' conojel ri erichin rija' ri ec'o vave' choch'ulef, y c'a quiri' na xerojo' c'a pa ruq'uisbel. ");
INSERT INTO cak_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jac'a ri Judas Iscariote, ri ruc'ajol jun achi Simón, yo'on chic pe pa ránima roma ri itzel chi nujach ri Jesús. Y tok niqui'en va'in ri Jesús quiq'uin ri ru-discípulos richin ri jun ak'a' ri', ");
INSERT INTO cak_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ri Jesús riq'uin reteman chi ronojel jachon pa ruk'a' roma ri Rutata', y riq'uin reteman chi riq'uin ri Dios petenak-vi y chiri' chic nitzolij-vi; ");
INSERT INTO cak_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","roma c'a ri', xcataj-pe ri pa va'in, xrelesaj can ri rutziak ruk'u'n, xuq'uen-pe jun toalla, y xuxim-apu xerupan. ");
INSERT INTO cak_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jac'ari' xuya' ya' chupan jun palangana y (xutz'om, xuchop) ruch'ajic cakan ri ru-discípulos chiquijununal, y nusula' ri cakan riq'uin ri toalla ri ruximon xerupan. ");
INSERT INTO cak_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jac'ari' xjel-apu riq'uin ri Simón Pedro richin nuch'aj ri rakan, y ri Pedro quire' xu'ij che: Ajaf, man utz ta ninna' yin chi rat nach'aj vakan, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xu'ij che: Ri yitajin riq'uin vacami, rat man aveteman ta achique roma, pero nerila' na jun k'ij tok (xtik'ax, xtino') chavech, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jac'a ri Pedro xu'ij: Yin man jun bey xtinya' lugar chave chi rat nach'aj vakan, xcha'. Quire' c'a xu'ij ri Jesús che: Si man xtinch'aj ta ri avakan, mana-ta chic rat nu-discípulo, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ri Simón Pedro xu'ij: Ajaf, si quiri', man xaxe ri vakan tach'aja', ja jun ri nuk'a' y ri (nujolon, nuvi'), xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xu'ij che: Ri atininak chic, man nic'atzin ta natin chic jun bey; xaxe ri rakan nic'atzin chi nich'aj, roma xa ch'ajch'oj chic. Y rix, rix ch'ajch'oj chic, pero man chi'ivonojel ta, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús roma reteman chic (achique, acu'x) xtijacho-e richin pa quik'a' ri vinak, romari' xu'ij: Man chi'ivonojel ta rix ch'ajch'oj. ");
INSERT INTO cak_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Tok ri Jesús xuq'uis ruch'ajic cakan ri discípulos, xucusaj chic apu ri rutziak ri relesan can chirij, xtz'uye' chic apu chuchi' ri mesa y xu'ij: ¿Iveteman achique roma xinch'aj ri ivakan? ");
INSERT INTO cak_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rix, Katijonel y Kajaf yixcha' chuve. Kitzij ri ni'ij, roma can quiri' vi. ");
INSERT INTO cak_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y si yin ri Tijonel y ri Ajaf xinch'aj ivakan, quiri' mismo rix, nic'atzin chi nich'ajla' ivakan chivech. ");
INSERT INTO cak_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yin jun ejemplo ri xinc'ut can chivech, richin quiri' achel ri xin-en yin iviq'uin, quiri' mismo tibana' rix chivech. ");
INSERT INTO cak_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kitzij-kitzij nin-ij chive: Man jun samajinel ri más c'o ruk'ij que chuvech ri rajaf; y quiri' mismo jun ri nitak-e, mana-ta rija' ri más c'o ruk'ij, xa ja ri nitako-e richin ri más c'o ruk'ij. ");
INSERT INTO cak_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Si rix xivetemaj ronojel re', can utzulaj tzij xti'an chive, si ni'en ri xivetemaj. ");
INSERT INTO cak_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Man chivij ta chi'ivonojel nin-ij-vi chi man rix ch'ajch'oj ta, roma yin veteman ino'oj chi'ivonojel ri xixincha'. Pero nic'atzin chi nibanataj ri tz'iban can chupan ri ruch'abel ri Dios ri nu'ij: Ri jun ri junan xva' viq'uin, xa xcataj chuvij. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cak_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Yin ja yan ninya-apu rutzijol chive ri xtibanataj, richin quiri' tok xtibanataj, rix xtinimaj (yin achique, ayincu'x) yin. ");
INSERT INTO cak_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kitzij-kitzij nin-ij chive: Ri xtic'ulu ruvech ri nusamajinel ri nintak-e yin, ja yin ri nuc'ul nuvech, y ri nic'ulu nuvech yin, nuc'ul ruvech ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Tok ri Jesús ru'in chic ronojel re', xubolkotij-ri' ri ránima xuna', y quire' c'a xuk'alajrisaj: Kitzij-kitzij nin-ij chive, chi jun chive rix ri xtijacho-e vichin, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jac'ari' tok ri discípulos xe niquitz'etela' quivech, roma man queteman ta achok chirij xch'o-vi-ka ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Y ri jun discípulo ri jani na (nojovex, nojo'ox) roma ri Jesús, rak'el-apu choruc'u'x ri Jesús, ");
INSERT INTO cak_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","y che c'a ri discípulo ri' xu'on-vi-apu retal ri Simón Pedro richin tuc'utuj-apu che ri Jesús ri achok chirij xch'o-vi-ka tok xu'ij chi jun chique rije' xtijacho-e richin. ");
INSERT INTO cak_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Más c'a xrak'e-ka ri discípulo ri' choruc'u'x ri Jesús, y xuc'utuj-apu che: Ajaf, ¿achique c'a chike roj ri c'a ja xa'ij-ka? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Y ri Jesús xu'ij: Ja ri achok che xtinmuba-vi-apu ri pan, xcha'. Jac'ari' xumuba-ka ri pan y xuya-apu che ri Judas Iscariote ri ruc'ajol ri Simón. ");
INSERT INTO cak_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Tok ri Judas Iscariote rutijon chic ka ri juba' pan, xoc ri Satanás pa ránima. Jac'ari' tok ri Jesús xu'ij che: Ri anojin chi na'an, tabana' cha'anin, xcha-e che. ");
INSERT INTO cak_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero nis-ta jun chique ri ec'o-apu chuchi' ri mesa ri (xk'ax, xno') chuvech ri achique roma quiri' xu'ij-e che ri Judas. ");
INSERT INTO cak_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Roma ec'o chique rije' xquinojij chi xtak-e roma ri Jesús richin xerulok'o' ri xtic'atzin chique chupan ri nimak'ij o chi terusipaj juba' quiméra ri vinak ri man jun oc quichajin, roma ja rija' yacayon ri méra. ");
INSERT INTO cak_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Tok ri Judas xuq'uis-e ri juba' pan, xel-e, pero chak'a' chic chiri'. ");
INSERT INTO cak_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Tok elenak chic e ri Judas, ri Jesús xu'ij: Vacami xtik'alajin ruk'ij ri Jun ri xtak-pe richin xalex chi'icojol. Quiri' mismo ri Dios; xtik'alajin ri nimalaj ruk'ij voma yin. ");
INSERT INTO cak_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Si voma yin nik'alajin nimalaj ruk'ij ri Dios, quiri' mismo xtu'on ri Dios chi nik'alajin ri nimalaj nuk'ij yin, y cha'anin yan xtu'on. ");
INSERT INTO cak_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Rix ri rix achel ch'utik valc'ua'l, yin c'a yic'uje' na juba' más iviq'uin. Xquinicanoj, pero achel nu'in chique ri kavinak israelitas, quiri' mismo nin-ij can chive vacami, chi ri lugar ri xqui'e-vi, rix man xquixtiquer ta xquixbe. ");
INSERT INTO cak_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Y c'o jun c'ac'ac' mandamiento nin-ij can chive, chi can tijo-ivi' chivech, achel nubanon yin iviq'uin. Quiri' mismo tibana' rix, tijo-ivi' chivech. ");
INSERT INTO cak_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si nijo-ivi' chivech, chiri' xtik'alajin-vi chiquivech conojel chi can rix nu-discípulos vi, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jac'ari' tok ri Simón Pedro xu'ij che ri Jesús: Ajaf, ¿achique lugar yabe-vi c'a? xcha'. Ri Jesús xu'ij che: Ri lugar xqui'e-vi yin, rat man yatiquer ta yinatzekle'ej vacami. Pero más chikavech apu, can xquinatzekle'ej-vi, xcha' che ri Pedro. ");
INSERT INTO cak_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Y ri Pedro xu'ij che: Ajaf, ¿achique roma man yitiquer ta yatintzekle'ej vacami? Yin hasta ri nuc'aslen xtinya' avoma, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Quire' c'a rutzolic rutzij xu'on ri Jesús: ¿Can kitzij cami naya' ri ac'aslen voma? Yin kitzij-kitzij nin-ij chave, chi na'ey chi nitzirikin-pe quimama' ri ec', rat (oxmul, oxpaj) yan ta'ij chi xa man aveteman ta nuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Xch'o c'a ri Jesús y xu'ij: Man c'a tisatz ivánima. Rix cukul ic'u'x riq'uin ri Dios, quiri' mismo tibana' viq'uin yin. ");
INSERT INTO cak_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chiracho ri Nata', q'uiy lugar richin yixc'uje-vi. Si man ta kitzij chi quiri', yin xin-ij yan ta chive. Vacami c'a, yi'e richin nenbana' rubanic jun i-lugar rix. ");
INSERT INTO cak_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Si yi'e richin nenbana' rubanic jun i-lugar, yipe chic jun bey, y yixinc'uaj viq'uin; richin quiri' ri lugar yinec'uje-vi yin, chiri' mismo yixec'uje-vi rix. ");
INSERT INTO cak_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Rix iveteman ri lugar ri yi'e-vi yin, y quiri' mismo ri bey xa iveteman, xcha' chique ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Quire' c'a xu'ij-apu ri Tomás che ri Jesús: Ajaf, roj man keteman ta achique lugar yabe-vi. ¿Achel c'a niketemaj ri bey? ");
INSERT INTO cak_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jac'ari' xu'ij ri Jesús: Ja yin ri bey, ja yin ri kitzij, ja yin ri c'aslen, y xaxe voma yin (napon, nebos) jun riq'uin ri Nata'. ");
INSERT INTO cak_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xa ta rix ijelesan-pe utz-utz ivánima viq'uin yin, quiri' ta mismo ibanon riq'uin ri Nata'. Pero vacami iveteman chic runo'oj y itz'eton chic ruvech voma yin, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Xch'o c'a apu ri Felipe che ri Jesús y xu'ij: Ajaf, tac'utu' ri Atata' chikavech, y riq'uin ri' xticuker kac'u'x, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xu'ij che: Felipe, ¿man jani tavetemaj nuno'oj yin, tok q'uiy yan tiempo quic'uje' iviq'uin? Ri reteman nuno'oj yin, ja jun runo'oj ri Nata' reteman. ¿Achique roma rat na'ij chi najo' ninc'ut ri Nata' chivech? ");
INSERT INTO cak_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Man nanimaj ta rat chi yin xa jun nubanon riq'uin ri Nata', y ri Nata' xa jun rubanon viq'uin yin? Ri ch'abel ri xink'alajrisaj chivech, man nuyon ta yin xinojin-pe, ja ri Nata' ri xa jun kabanon riq'uin, jari' ri nisamaj pa vánima chi nin-en ri samaj re'. ");
INSERT INTO cak_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Rix quininimaj riq'uin ri nin-ij chive, chi xa jun nubanon riq'uin ri Nata' y rija' xa jun rubanon viq'uin yin. Si man ninimaj ta ri', quininimaj c'a roma ri milagros ri enubanon chivech. ");
INSERT INTO cak_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kitzij-kitzij nin-ij chive: Ri xtuya' ránima viq'uin, ri samaj ri xen-en yin xquerubanala' rija'; y c'o más chovon chuvech re' xquerubanala'. Roma yin yi'e riq'uin ri Nata'. ");
INSERT INTO cak_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronojel c'a ri xtic'utuj che ri Nata' pa nubi' yin, can xtinya-vi-pe chive, richin quiri' nik'alajin ri nimalaj ruk'ij ri Nata' voma yin. ");
INSERT INTO cak_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Si c'o ri xtic'utuj pa nubi', yin xtinya-pe chive. ");
INSERT INTO cak_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Si yinijo', que'inimaj ri nu-mandamiento. ");
INSERT INTO cak_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y yin xtinc'utuj che ri Nata', y rija' xtutak-pe jun chic Bochinel richin ri ivánima richin xtic'uje' iviq'uin jumul. ");
INSERT INTO cak_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ri' ja ri Lok'olaj Espíritu ri nik'alajrisan ri kitzij. Rija' manak che'el nic'ul pa tak cánima coma ri vinak ri c'a benak na cánima riq'uin ri roch'ulef, roma rije' man niquitz'et ta ni man queteman ta runo'oj. Jac'a rix iveteman runo'oj, roma vacami c'o chi'icojol y ri chikavech apu xtic'uje' pa tak ivánima. ");
INSERT INTO cak_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yin man xquixinya' ta can iyon achel jun ac'ual caminak rute-rutata', xa xquipe iviq'uin. ");
INSERT INTO cak_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ri c'a benak na cánima riq'uin ri roch'ulef, xa juba' chic xquinquitz'et. Jac'a rix can c'a xquinitz'et na. Y roma yin c'o nuc'aslen richin jumul, ja jun rix xtic'uje' ic'aslen richin jumul. ");
INSERT INTO cak_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ja chupan ri k'ij ri' xtivetemaj chi yin jun nubanon riq'uin ri Nata', y chi rix jun ibanon viq'uin, y yin jun nubanon iviq'uin rix. ");
INSERT INTO cak_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ri ec'o ri nu-mandamiento pa ránima y nu'on ri niqui'ij, rija' can yirojo'. Y ri yirojo', (xtojovex, xtojo'ox) roma ri Nata' Dios; quiri' mismo yin, can xtinjo' y xtink'alajrisaj-vi' chuvech, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jac'ari' tok ri discípulo rubinan Judas, pero mana-ta ri Judas Iscariote, quire' xuc'utuj-apu che ri Jesús: Ajaf, ¿achique roma xaxe chikavech roj nak'alajrisaj-vi-avi', y man chiquivech ta ri c'a benak na cánima riq'uin ri roch'ulef? ");
INSERT INTO cak_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Quire' c'a xu'ij ri Jesús che: Ri yirojo' yin, nu'on ri nu'ij ri nuch'abel, y (xtojovex, xtojo'ox) roma ri Nata'. Can xkupe riq'uin y xtika'an kacho pa ránima. ");
INSERT INTO cak_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jac'a ri man yirojo' ta, man nunimaj ta ri nu'ij ri nuch'abel. Y ri ch'abel ri ivac'axan viq'uin, man vichin ta yin, re' richin ri Nata' ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","C'a yitajin na chubixic ronojel re' chive, utz ri c'a yinc'o na iviq'uin. ");
INSERT INTO cak_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jac'a ri Lok'olaj Espíritu ri Bochinel richin ri ivánima, tok nitak-pe roma ri Nata' pa nubi' yin, xquixrutijoj riq'uin ronojel, y xtuc'uxlaj chive ronojel ri ch'abel ri enu'in can chive. ");
INSERT INTO cak_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ri uxlanen c'o pa vánima, ninya' can chi'icojol; chupan ri uxlanen ri' yixinya-vi can, y ri rubeyal richin ninya' can yin chive man junan ta riq'uin rubeyal ri nuya' ri roch'ulef. Roma c'a ri', man tisatz ivánima, ni man tixi'ij-ivi'. ");
INSERT INTO cak_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Rix ivac'axan ri nu'in chive: Yin yi'e, y yipe chic jun bey iviq'uin. Quiri' ri nu'in chive. Xa ta yinijo', can ta niquicot ri ivánima chi yin yi'e riq'uin ri Nata', roma rija' más c'o ruk'ij que chinuvech yin. ");
INSERT INTO cak_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ronojel c'a re' ninya' yan can rutzijol chive, richin quiri' tok xtuka ri k'ij richin nibanataj, rix xtinimaj ri nu'in can chive. ");
INSERT INTO cak_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Vacami man layoj ta chic xquitzijon iviq'uin, roma ri itzel ri c'o ruk'a' che ri roch'ulef, xa nik'alajin yan pe. Pero rija' man jun ruk'a' chuve. ");
INSERT INTO cak_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero nic'atzin chi ri vinak ri c'a benak na cánima riq'uin ri roch'ulef niquetemaj chi yin kitzij ninjo' ri Nata', y ri yitajin riq'uin, can ja achel ru'in-pe chuve. Vacami, quixcataj c'a, jo', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jac'ari' xu'ij chic ri Jesús: Ja yin ri kitzij rakan uva, y ja ri Nata' ri nisamajin ri uva re'. ");
INSERT INTO cak_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Conojel ri e'achel ruk'a' ri uva ri man niquiya' ta quivech roma man jumul ta junan cánima viq'uin yin, ri Nata' yeruchoy-e. Jac'a ri ruk'a' ri niquiya' quivech, rija' jumul yerunic'oj y yeruch'ajch'ojij, richin más niquiya' quivech. ");
INSERT INTO cak_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jac'a rix, rix ch'ajch'oj chic, roma ri ch'abel nutzijon chivech. ");
INSERT INTO cak_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Jumul c'a junan ivánima tibana' viq'uin, quiri' mismo yin xa jun vánima xtin-en iviq'uin. Achel jun ruk'a' uva man nitiquer ta nuya' ruvech, si xa jok'otajnak-e riq'uin ri rakan, quiri' mismo ri ic'aslen rix, man xtuya' ta ruvech, si man jumul ta junan ivánima ni'en viq'uin. ");
INSERT INTO cak_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja yin rakan ri uva, y rix ri ruk'a'. Ri jumul junan ránima nu'on viq'uin, y yin riq'uin rija', ri ruc'aslen achel ruk'a' ri uva ri quiyil ruvech. Roma iyon rix man jun achique xquixtiquer xti'en. ");
INSERT INTO cak_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ri man jumul ta junan ránima nu'on viq'uin, xa xtichoy-e achel ni'an chique ri ruk'a' tak uva ri xa man niquiya' ta quivech. Tok echaki'j chic, nimol ruchi' y yetorix pa k'ak' richin yec'at. ");
INSERT INTO cak_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Si rix jumul junan ivánima ni'en viq'uin, y xtic'uje' ri nuch'abel pan ivánima, xa achique na ri nurayij ri ivánima, tic'utuj che ri Dios, y rija' can xtuya-vi-pe chive. ");
INSERT INTO cak_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ri Nata' can xtuc'ul nimalaj ruk'ij tok ri ic'aslen rix achel ruk'a' ri uva ri quiyil ruvech. Chiri' c'a xtik'alajin-vi chi kitzij rix tzekle'ey vichin. ");
INSERT INTO cak_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Achel c'a yirojo' ri Nata' yin, quiri' mismo yixinjo' rix. Jumul c'a quixc'uje' chupan ri (ajovabel, amor) ri nuchajin yin pan ivi'. ");
INSERT INTO cak_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si rix ye'inimaj ri nu-mandamiento, jumul xquixc'uje' chupan ri (ajovabel, amor) ri'. Achel nubanon yin riq'uin ri Nata', yennimaj ri ru-mandamiento, romari' jumul yinc'o chupan ri (rajovabel, ru-amor) rija'. ");
INSERT INTO cak_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ronojel re' nin-ij can chive, richin quiri' ri ivánima xtiquicot, achel niquicot vánima yin. Can ta tz'akat xtiquicot ri ivánima. ");
INSERT INTO cak_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ri nu-mandamiento ri ninya' can chive, quire' nu'ij: Tijo-ivi' chivech achel yixinjo' yin. ");
INSERT INTO cak_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ri nujach ruc'aslen pa quiq'uexel ri ru-amigos, pa ruvi' ri' man jun chic más nitiquer nu'on richin nuc'ut chi kitzij yerojo'. ");
INSERT INTO cak_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y rix, rix nu-amigos, si ni'en ri nin-ij chive chi tibana'. ");
INSERT INTO cak_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Vacami man nin-ij ta chic nusamajela' chive, roma jun samajinel man reteman ta achique nunojij ri rajaf. Vacami nin-ij nu-amigos chive, roma ronojel ri ru'in-pe ri Nata' chuve, yin nuk'alajrisan chivech. ");
INSERT INTO cak_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mana-ta rix xixcha'on vichin, xa ja yin xicha'on ivichin richin ne'ibana' ri nusamaj richin chi más yeq'uiyer ri yeniman vichin, y chi ja jun ri yeniman, jumul junan cánima niqui'en viq'uin, richin quiri' ri achique xtic'utuj che ri Nata' pa nubi' yin, can xtuya-vi-pe chive. ");
INSERT INTO cak_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Vacami c'a, yixinpaxa'aj can chi tijo-ivi' chivech. ");
INSERT INTO cak_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Si ri c'a benak na cánima riq'uin ri roch'ulef itzel yixquitz'et, tuka pan ivi' chi quiri' mismo xqui'en chuve yin na'ey que chivech rix. ");
INSERT INTO cak_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xa ta c'a rix richin ri roch'ulef, can ta yixcajo' ri c'a benak na cánima riq'uin ri roch'ulef. Pero roma man rix richin ta chic ri roch'ulef, roma yin xixincha-pe chiquicojol, romari' itzel yixquitz'et. ");
INSERT INTO cak_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Man timestaj ri nu'in chive: Mana-ta ri samajinel ri más c'o ruk'ij que chuvech ri rajaf. Si yin ri Ivajaf yinquicanoj richin niqui'en pokon chuve, junan xtiqui'en chive rix, y si rije' niqui'en ri nu'ij ri nuch'abel, quiri' mismo xtiqui'en riq'uin ri ich'abel rix. ");
INSERT INTO cak_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero ronojel re' xtik'asaj pa quik'a' ri vinak, roma iniman ri nubi' yin, roma rije' man jelenak ta apu cánima riq'uin ri takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Man ta xipe yin chuvech ri roch'ulef richin xitzijon chiquivech, man ta nicakalej mac. Jac'a ri vacami, rije' manak che'el xtiqui'ij chi manak quimac. ");
INSERT INTO cak_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ri itzel yinquitz'et yin, itzel niquitz'et ri Nata'. ");
INSERT INTO cak_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Si man ta nubanalo'n nima'k tak milagros ri man jun chic banayon chiquivech, man ta nicakalej mac. Pero rije' masque quitz'eton ri milagros ri nubanon chiquivech, xa itzel yinquitz'et yin y quiri' mismo ri Nata'. ");
INSERT INTO cak_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Pero itzel yinquitz'et richin nibanataj ri tz'iban can chupan ri ley ri yo'on chique ri nu'ij: Ri vinak itzel yinquitz'et, y xa manak roma quiri' niqui'en chuve. Quiri' nu'ij chupan ru-ley ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jac'a tok xtipe ri Bochinel richin ri ivánima, ri xtintak-pe pa rubi' ri Nata', xtuk'alajrisaj ri (yin achique, ayincu'x) yin. Y ri' ja ri Lok'olaj Espíritu ri nik'alajrisan ri kitzij, ri riq'uin ri Nata' nipe-vi. ");
INSERT INTO cak_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Quiri' mismo rix, xquinik'alajrisaj chiquivech ri vinak, roma can rixc'o-pe viq'uin xe tok xintz'uc ri nusamaj vave' choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ronojel ri yitajin chubixic chive, richin chi man jun xquixtzako. ");
INSERT INTO cak_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Xquixokotex-e pa tak sinagogas, y hasta xtuka na jun k'ij chi xa achique na jun xquixcamisan, xtunojij chi riq'uin ri', najin riq'uin rusamaj ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Quiri' xquequibanala' ri vinak, roma man jun bey jelenak-apu cánima riq'uin ri Nata', y nis-ta viq'uin yin. ");
INSERT INTO cak_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Pero ronojel re' nuyo'on can rutzijol chive, richin quiri' tok xtuka ri k'ij, rix xtic'uxlaj chi can nuyo'on-vi can rutzijol chive. Ronojel re' man xinya' yan ta rutzijol chive pa na'ey, roma yinc'o iviq'uin, ");
INSERT INTO cak_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","jac'a ri vacami yitzolij-e riq'uin ri takayon-pe vichin. Y nis-ta jun chive rix nic'utun-pe chuve: ¿Achique lugar xcabe-vi? ");
INSERT INTO cak_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pa ruq'uexel chi xic'utuj, xa xnoj bis pan ivánima, roma xin-ij chive chi yitzolij-e. ");
INSERT INTO cak_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Jac'a yin nin-ij ri kitzij chive: Utz chive rix chi yin yinel-e chi'icojol, roma si man yi'e ta, man nuka ta ri Bochinel richin ri ivánima. Pero si yi'e, can xtintak-vi-pe iviq'uin. ");
INSERT INTO cak_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Tok xtuka rija', xtuya' chosakil chiquivech ri vinak choch'ulef chi can e'aj-mac vi, chi yin pa ruchojmil nin-en ronojel chuvech ri Nata', y chi can xtinic'ox-vi ronojel ch'utik-nima'k. ");
INSERT INTO cak_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Xtiquiya' pa cuenta chi can e'aj-mac vi, roma man yinquinimaj ta. ");
INSERT INTO cak_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Y xtiquiya' pa cuenta chi yin pa ruchojmil nin-en ronojel chuvech ri Nata' roma riq'uin rija' yi'e-vi y man yinitz'et ta chic. ");
INSERT INTO cak_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y xtiquiya' pa cuenta chi can xtinic'ox na vi ronojel ch'utik-nima'k, roma vacami k'aton chic can castigo pa ruvi' ri itzel ri c'o ruk'a' che ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","C'a c'o na q'uiy ri nic'atzin chi nin-ij can chive, pero man nin-ij yan ta can chive, roma rix man yixtiquer ta riq'uin. ");
INSERT INTO cak_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jac'a tok xtuka ri Lok'olaj Espíritu ri nik'alajrisan ri kitzij, can xquixrutijoj y xquixruc'uaj chupan ri kitzij. Roma ri ch'abel ri xtu'ij chive, mana-ta ruch'abel rija', xa ja ri rac'axan-pe ri xtu'ij chive, y xqueruk'alajrisaj chivech ri xquebanataj ri más chivech apu. ");
INSERT INTO cak_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Rija' can xtuya' nuk'ij yin riq'uin ri yiruk'alajrisaj yin y ri nusamaj chivech. ");
INSERT INTO cak_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel ri c'o riq'uin ri Nata' Dios vichin yin, romari' xin-ij chi ja yin y ri nusamaj ri xtuk'alajrisaj ri Lok'olaj Espíritu chivech. ");
INSERT INTO cak_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Rix vacami xa juba' chic xquinitz'et, y jac'ari' man xquinitz'et ta juba'. Pero juba' chic apu, xquinitz'et chic jun bey, roma yin yitzolij-e riq'uin ri Nata' Dios, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jac'ari' tok ec'o chique ri discípulos niquic'utula' chiquivech: ¿Achique cami ri xrojo' xu'ij chike? Roma xu'ij: Xa juba' chic xquinitz'et, y jac'ari' man xquinitz'et ta juba'. Pero juba' chic apu, xquinitz'et chic jun bey, roma yin yitzolij-e riq'uin ri Nata' Dios, xcha', yecha' ri discípulos chiquivech. ");
INSERT INTO cak_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Roma c'a ri', quire' niquibila' chiquivech: ¿Achique c'a nu'ij tzij ri xu'ij chi xa juba' chic xquinitz'et? Achique na ruchojmil ri nubila' chike, yecha'. ");
INSERT INTO cak_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jac'a ri Jesús xuna'ej chi ri ru-discípulos c'o nicajo' niquic'utuj che, romari' xu'ij: ¿Rix nijo' nivetemaj achique ri xin-ij, chi xa juba' chic xquinitz'et y jac'ari' man xquinitz'et ta juba', pero juba' chic apu xquinitz'et chic jun bey? ");
INSERT INTO cak_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Yin kitzij-kitzij nin-ij chive: Rix xquixok' y xquixbison voma yin. Pero ri vinak ri c'a benak na cánima riq'uin ri roch'ulef xa xquequicot. Pero masque yixbison, ri bis ri' xa xtijalataj. Pa ruq'uexel ri bis xa xquixquicot. ");
INSERT INTO cak_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Achel jun ixok nuk'asaj k'axomal roma nalex jun ch'uti ral. Pero tok alaxnak chic ri ac'ual, ri te'ej man nuka ta chic pa ruvi' ri k'axomal ri xuk'asaj, xa niquicot ránima chi xalex chic jun ac'ual choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quiri' mismo rix, vacami c'o bis pa tak ivánima, pero xquixintz'et chic jun bey, y xtiquicot chic jun bey ri ivánima, y ri (quicoten, gozo) ri' man jun xtelesan iviq'uin. ");
INSERT INTO cak_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chupan ri k'ij ri', man jun chic achique xtic'utuj chuve. Kitzij-kitzij nin-ij chive, chi ronojel ri xtic'utuj che ri Nata' pa nubi' yin, can xtuya-vi-pe chive. ");
INSERT INTO cak_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","C'a vacami man jun achique ic'utun che ri Nata' pa nubi' yin. Tic'utuj c'a, y xtiyo'ox chive, richin quiri' tz'akat xtiquicot ri ivánima. ");
INSERT INTO cak_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ronojel ri ch'abel re nu'in chive, xa revan juba' ri' ri achique nuc'ut, pero nuka na jun k'ij tok man quiri' ta chic xtin-en xquich'o iviq'uin, xa can k'alaj-k'alaj xtin-en che ri nin-ij chive pa ruvi' ri Nata' Dios. ");
INSERT INTO cak_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chupan ri k'ij ri', rix pa nubi' xtic'utuj-vi ri nijo', y man nic'atzin ta chi c'a yin na yic'utun che ri Nata' pan iq'uexel. ");
INSERT INTO cak_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Roma ri Nata' can yixrojo'; roma rix can yinijo' yin y can ninimaj chi yin riq'uin rija' yin petenak-vi. ");
INSERT INTO cak_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yin riq'uin ri Nata' Dios yin petenak-vi richin xinuka choch'ulef. Y vacami ninya' chic can ri roch'ulef y yitzolij chic e riq'uin rija', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Quire' c'a xqui'ij ri ru-discípulos che: Vacami k'alaj-k'alaj ruchojmil ronojel ri na'ij chike, y man nacusaj ta chic ch'abel ri revan-ri' ri achique nuc'ut. ");
INSERT INTO cak_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vacami keteman chi rat ronojel aveteman. Roma na'ey chi nic'utux chave, aveteman chic ri xtic'utux. Romari' nikanimaj chi riq'uin ri Dios rat petenak-vi, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Quire' c'a xu'ij ri Jesús chique: ¿Yininimaj vacami? ");
INSERT INTO cak_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yin kitzij nin-ij chive chi nuka na jun hora, y vacami ja xuka, chi rix xtiquiraj-e-ivi'. Chi'ijununal xquixbe chic chupan tak ri ibey, y xa xquiniya' can nuyon. Pero man nuyon ta yic'uje' can, roma ri Nata' can c'o viq'uin. ");
INSERT INTO cak_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ronojel re' nin-ij can chive richin quiri' voma yin xtic'uje' uxlanen pa tak ivánima. Chuvech ri roch'ulef rix can c'o c'ayef xtik'asaj, pero tic'uje' ruchuk'a' ri ivánima roma yin xitiquer yan chirij ronojel ri xa itzel pa ruvi' ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Tok ru'in chic ronojel re' chique ri ru-discípulos, ri Jesús xtzu'un-e chicaj richin xu'on orar, y xu'ij: Nata' Dios, ri hora ja xril. Vacami c'a, tabana' chi nik'alajin nuk'ij yin ri Ac'ajol; richin quiri' voma yin ri Ac'ajol, ja jun rat xtik'alajin ri nimalaj ak'ij. ");
INSERT INTO cak_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Roma rat abanon chuve chi c'o nuk'a' chique conojel, richin ninya' ri c'aslen ri richin jumul chique conojel ri xe'aya' chuve. ");
INSERT INTO cak_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ri c'aslen ri richin jumul jare': Ja chi pa cánima quiniman-vi ri tzak achique rat, ri rat kitzij Dios, y man jun chic jun, y chi pa cánima quiniman-vi ri tzak achique yin ri Jesucristo ri yin atakon-pe choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yin nunimirisan ak'ij vave' choch'ulef, y xinq'uis yan can rubanic ri samaj ri abin-pe chuve chi nin-en. ");
INSERT INTO cak_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vacami c'a, Nata' Dios, tabana' chi nic'uje' chic nuk'ij chiri' aviq'uin, achel ri nuk'ij xc'uje' chiri' aviq'uin tok man jani c'o ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Yin rat nuk'alajrisan-pe chiquivech ri achi'a' ri xe'aya' chuve, ri xe'acha-pe chiquicojol ri vinak ri c'a benak na cánima riq'uin ri roch'ulef. Ri achi'a' re', e'avichin rat, y xe'aya' chuve yin. Rije' quiyacon pa cánima ri ach'abel. ");
INSERT INTO cak_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","C'a ja vacami xquetemaj chi ronojel ri ayo'on-pe chuve, aviq'uin rat petenak-vi, ");
INSERT INTO cak_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","roma ronojel ri ch'abel ri abin-pe chuve, nu'in chique rije', y rije' xquic'ul pa cánima. Xquetemaj chi kitzij aviq'uin rat yin petenak-vi, y xquinimaj chi ja rat rat takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Yin pa qui-cuenta rije' ninc'utuj-vi; man pa qui-cuenta ta ri c'a benak na cánima riq'uin ri roch'ulef. Yin pa qui-cuenta ri achi'a' ri xe'aya' chuve ninc'utuj-vi, roma rije' e'avichin rat. ");
INSERT INTO cak_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Conojel ri evichin yin, e'avichin rat, y ri e'avichin rat, evichin yin. Coma rije' tok nik'alajin chi yin c'o nuk'ij. ");
INSERT INTO cak_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yin man yic'uje' ta chic vave' choch'ulef, jac'a rije' c'a yec'uje' na can. Yin aviq'uin rat, Lok'olaj Nata', yitzolij-vi-e. Conojel c'a ri achi'a' ri xe'aya' chuve, que'achajij pan abi' rat mismo, richin quiri' xa jun cánima xtiqui'en, achel kabanon roj aviq'uin rat. ");
INSERT INTO cak_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ri ajani k'ij yinc'o-pe quiq'uin chuvech ri roch'ulef, pan abi' enuchajin-vi-pe. Conojel ri xe'aya' chuve, yin xenchajij, y man jun chique rije' xsatz can, xaxe ri jun ri can richin vi chi manak che'el nicolotaj, richin quiri' nibanataj ri tz'iban can chupan ri ach'abel. ");
INSERT INTO cak_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Vacami c'a, aviq'uin rat Nata' Dios, yitzolij-vi-e, pero ronojel re', vave' choch'ulef nin-ij-vi-e chave chiquivech, richin quiri' ja jun rije' tz'akat yequicot, achel yiquicot yin. ");
INSERT INTO cak_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ri achi'a' ri xe'aya' chuve, yin nuyo'on ri ach'abel chique. Jac'a ri vinak ri c'a benak na cánima riq'uin ri roch'ulef, xa itzel xequitz'et, roma ri xe'aya' chuve man riq'uin ta chic ri roch'ulef benak-vi ri cánima, achel yin, man jun bey xbe vánima riq'uin ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ri ninc'utuj chave, Nata' Dios, mana-ta chi ye'avelesaj-e choch'ulef, xa que'ato' richin man quetzak pa ruk'a' ri itzel. ");
INSERT INTO cak_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rije' man benak ta chic cánima riq'uin ri roch'ulef, achel yin man jun bey xbe vánima riq'uin ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Vacami c'a, tabana' chi más niquijach-qui' pan ak'a' roma nisamaj ri kitzij avichin rat pa cánima. Ri ach'abel, jari' ri kitzij. ");
INSERT INTO cak_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Y achel ri xa'an rat chi xinatak-pe vave' choch'ulef richin xin-en ri asamaj, quiri' mismo enutakon ri achi'a' ri xe'aya' chuve richin niqui'en ri asamaj choch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yin coma rije' ninjach-vi' pan ak'a' richin nin-en ri narayij rat; richin quiri' ja jun rije' nisamaj ri kitzij pa cánima y más niquijach-qui' pan ak'a'. ");
INSERT INTO cak_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nata' Dios, yin man xe ta pa qui-cuenta ri xe'aya' chuve ninc'utuj-vi ri quemelal chave, xa ja jun pa qui-cuenta ri xqueniman vichin roma ri ch'abel ri xtiquitzijoj rije', ");
INSERT INTO cak_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","richin chi conojel xa jun cánima xtiqui'en, achel kabanon roj aviq'uin, xa jun kabanon. Achel ri abanon rat, Nata' Dios, ratc'o viq'uin, y yin yinc'o aviq'uin, quiri' ninjo' chi niqui'en rije' kiq'uin, richin quiri' nik'alajin chiquivech ri c'a benak na cánima riq'uin ri roch'ulef, chi ja rat rat takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Y achel ri abanon chuve yin chi c'o nuk'ij, quiri' mismo nubanon yin chique rije'; richin quiri' xa jun cánima xtiqui'en, achel kabanon roj aviq'uin, xa jun kabanon. ");
INSERT INTO cak_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yin xquic'uje' quiq'uin rije' y rat viq'uin yin, richin quiri' rije' tz'akat cánima xa jun xtiqui'en. Y coma ta c'a rije' xtik'alajin chiquivech ri c'a benak na cánima riq'uin ri roch'ulef, chi ja rat rat takayon-pe vichin, y chi can ye'ajo-vi, achel yinajo' yin. ");
INSERT INTO cak_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nata' Dios, conojel ri xe'aya' chuve, ninjo' chi ri achique lugar yinc'o-vi yin, chiri' viq'uin ye'ec'uje-vi rije'; richin quiri' rije' niquitz'et ri nuk'ij ri ayo'on rat. Roma rat can yinajo-vi, achel abanon-pe chuve xe tok man jani ti'an ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Rat ri rat choj pa ruvi' ronojel, Nata' Dios, ri c'a benak na cánima riq'uin ri roch'ulef man jelenak ta apu cánima aviq'uin. Pero ri vánima yin aviq'uin rat c'o-vi, y ri achi'a' ri xe'aya' chuve, xquetemaj chi ja rat rat takayon-pe vichin. ");
INSERT INTO cak_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yin rat nuk'alajrisan chique rije', y c'a yatink'alajrisaj na más chique, richin quiri' ri (ajovabel, amor) ri achajin pa nuvi' yin, xtic'uje' pa cánima, y quiri' mismo yin xquic'uje' pa cánima. ");
INSERT INTO cak_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Tok ri Jesús xuq'uis rubixic ronojel re', xel-pe chiri' quiq'uin ri ru-discípulos y xek'ax-apu juc'an che ri rubey-ya' rubinan Cedrón, pa jun juyu' ticon che' chuvech, y chiri' xe'oc-vi-apu ri Jesús y ri ru-discípulos. ");
INSERT INTO cak_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Chiri' q'uiy (mul, paj) xquimol-qui' ri Jesús junan quiq'uin ri ru-discípulos, romari' ri Judas ri xtijacho-e richin jabel reteman ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Roma c'a ri', ri Judas xeruc'uaj q'uiy soldados y achi'a' chajinel richin racho ri Dios ri etakon-e coma ri nima'k tak quik'ij sacerdotes israelitas y coma ri achi'a' fariseos. Conojel ri ebenak chirij ri Judas quitzijon antorchas, quic'ualo'n lámparas y quic'ualo'n ri achok che yecamisan-vi. ");
INSERT INTO cak_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jac'a ri Jesús roma reteman chic ronojel ri achique xteruk'asaj, romari' xbe chiquic'ulic, y xuc'utuj c'a chique: ¿Achique nicanoj? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rije' xqui'ij: Ja ri Jesús aj-Nazaret, xecha'. Ja yin ri', xcha' ri Jesús chique. Y ri Judas ri nijacho-e richin, can c'o-apu quiq'uin ri vinak ri'. ");
INSERT INTO cak_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Tok ri Jesús xu'ij: Ja yin ri'; ri vinak pa c'avalen xetzak pan ulef. ");
INSERT INTO cak_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Romari' ri Jesús xuc'utuj chic jun bey chique: ¿Achique nicanoj? xcha'. Y rije' xqui'ij chic: Ja ri Jesús aj-Nazaret, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Xin-ij yan chive chi ja yin ri'. Si ja yin ri yinicanoj, tiya' lugar chique ri ec'o viq'uin chi quebe, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Quiri' xu'ij, richin nibanataj ri ru'in pa ru-oración tok xu'ij: Nata' Dios, ri achi'a' ri xe'aya' chuve, man jun chique rije' xinsetz can. Quiri' ri ru'in. ");
INSERT INTO cak_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Jac'a ri Simón Pedro rutzalen jun espada, xrelesaj y xusoc jun rusamajinel ri nimalaj sacerdote israelita; xutzaq'uij-e ri ruxiquin derecha. Ri samajinel ri' rubinan Malco. ");
INSERT INTO cak_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero ri Jesús xu'ij che ri Pedro: Tayaca-ka la espada pa ru-lugar. Roma yin can yik'ax na vi chupan ri k'axomal ri ru'in-pe ri Nata' chi nink'asaj, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Jac'ari' tok ri soldados, y ri uc'uay quichin, y ri yechajin racho ri Dios ri etakon-pe coma ri achi'a' israelitas c'o quik'ij, (xquitz'om, xquichop) ri Jesús y xquixim. ");
INSERT INTO cak_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Quic'amon c'a e ri Jesús, na'ey xebe chuvech ri Anás ri rujinan ri Caifás ri nimalaj sacerdote israelita ri tiempo ri'. ");
INSERT INTO cak_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ja ri Caifás yayon quino'oj ri achi'a' israelitas c'o quik'ij chi más utz chi xe jun (nicom, niquen) pa ruq'uexel ronojel ri tinamit. ");
INSERT INTO cak_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro y jun chic discípulo quitzekle'en-e ri Jesús. Ri jun chic discípulo ri' xa eteman ruvech roma ri nimalaj sacerdote israelita, romari' choj xoc-apu chojay che racho ri sacerdote ri achique lugar c'o-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Jac'a ri Pedro xa xpa'e' can chuchi' ri puerta, pero ri discípulo ri eteman ruvech roma ri rajaf ri jay, xel chic pe y xuch'o-e riq'uin ri ixok jakoy ruchi' ri puerta, y xucusaj-apu ri Pedro. ");
INSERT INTO cak_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jac'ari' tok ri aj-ic' ri nijako ruchi' ri puerta xu'ij che ri Pedro: ¿Man ja jun ta rat, rat jun ru-discípulo ri achi re'? Y ri Pedro xu'ij: Manak, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ri samajela' chupan ri jay ri' y ri yechajin racho ri Dios, quiboxon k'ak' roma c'o tef, y epa'el-apu chuchi' ri k'ak' niquimak'-qui'. Ja jun ri Pedro pa'el-apu quiq'uin, numak'-apu-ri'. ");
INSERT INTO cak_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri nimalaj sacerdote israelita rubinan Anás c'o xuc'utuj che ri Jesús pa ruvi' ri yetzekle'en richin y pa ruvi' ri achique chi (tijonic, enseñanza) nuya'. ");
INSERT INTO cak_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Quire' c'a rutzolic rutzij xu'on ri Jesús: Yin chiquivech conojel yin ch'ovinak-vi-pe; jumul xentijoj ri vinak pa tak sinagogas y pa racho ri Dios, y man jun bey xich'o che'elek'el. ");
INSERT INTO cak_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Achique roma rat chuve yin nac'utuj-vi? Tac'utuj chique ri yin quic'axan ri achique enu'in. Tatz'eta' na pe', rije' jabel queteman achique nu'in yin chique. ");
INSERT INTO cak_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jac'a tok ri Jesús ru'in chic ka re', jun chique ri yechajin racho ri Dios ri c'o-apu chiri' chunakaj xuya' jubic k'a' che, y xu'ij che: ¿Achique roma nac'ulula'j-apu la nimalaj sacerdote? ");
INSERT INTO cak_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pero ri Jesús xu'ij che: Si c'o jun tzij man utz ta xin-ij-apu, ta'ij c'a achique ri man utz ta xin-ij. Y si ri xin-ij xa utz, ¿achique roma xaya' jubic k'a' chuve? xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jari' tok ri Anás xutak-apu ri Jesús chuvech ri Caifás ri nimalaj sacerdote israelita. Ximil c'a xuc'uax-e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Jac'a ri Pedro pa'el-apu chuchi' k'ak' numak'-apu-ri'. Jac'ari' tok xc'utux-apu che: ¿La mana-ta cami rat jun chique ru-discípulos ri achi c'amon-pe vave'? xuche'ex. Jac'a ri Pedro xa xrevaj y quire' xu'ij: Man yin ta ri', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ri nimalaj sacerdote c'o jun chique ri rusamajela' (calpachel, caj-c'uaxel) qui' riq'uin ri achi ri xeleses-e ruxiquin roma ri Pedro, y ri samajinel ri' quire' xu'ij-apu che ri Pedro: ¿La mana-ta rat ri xatintz'et chi ratc'o riq'uin ri Jesús chupan ri juyu' ri ticon che' chuvech? xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Jun bey chic ri Pedro xu'ij chi mana-ta rija', jac'ari' tok xtzirikin-pe quimama' ri ec'. ");
INSERT INTO cak_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Cumaj yan sakar xe'el-pe chuvech ri Caifás, quic'amon-e ri Jesús ebenak pa nimajay ri nic'uje-vi ri gobernador. Ri ec'amayon-e ri Jesús man xe'oc ta apu ri pa jay, roma chiquivech rije' si ye'oc-apu, nitzeletaj ri quic'aslen, y manak che'el niquitij ri achique nitij chupan ri nimak'ij pascua. ");
INSERT INTO cak_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jac'ari' xel-pe ri Pilato ri gobernador y xuc'utuj chique: ¿Achique c'a chi sujunic ic'amon-pe chirij ri jun achi re'? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Rije' xqui'ij: Xa ta ri achi re' man ta itzel chi achi, man ta xukajacha' pan ak'a', xecha' che. ");
INSERT INTO cak_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Jari' tok ri Pilato xu'ij chique: Tic'ama-e rix y ja achel nu'ij ri i-ley, quiri' ri castigo tiya' pa ruvi', xcha' chique. Pero ri achi'a' israelitas c'o quik'ij xqui'ij che: Roj man jun ley pa kak'a' richin nika'ij chi ticamises jun vinak, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Quiri' xqui'ij richin nibanataj ri ru'in ri Jesús tok xuk'alajrisaj ri achique chi camic xtuk'asaj. ");
INSERT INTO cak_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Jari' tok ri Pilato xoc chic apu chupan ri nimajay ri nic'uje-vi, xroyoj ri Jesús, y xuc'utuj che: ¿Ja rat ri Rey quichin ri israelitas? xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jac'a ri Jesús xu'ij che: Ri nac'utuj chuve, ¿ayon anojin-pe, o xa ch'aka' chic ebiyon-pe chave? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Jac'ari' tok ri Pilato xu'ij che: Yin man yin ta israelita chi rat quiri' na'ij-pe chuve. Ri xejacho avichin pa nuk'a' ja ri avinak y ri nima'k tak quik'ij sacerdotes israelitas. ¿Achique c'a ri xa'an chiquivech, richin quiri' rat quic'amon-pe vave'? ");
INSERT INTO cak_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Quire' c'a xu'ij ri Jesús che ri Pilato: Ri nu-gobierno man aj-roch'ulef ta, roma xa ta aj-roch'ulef gobierno, ri yetzekle'en vichin, niqui'en ta chic oyoval richin man ta yijach-e pa quik'a' ri achi'a' israelitas c'o quik'ij. Pero ri nu-gobierno yin man aj-roch'ulef ta. ");
INSERT INTO cak_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Romari' ri Pilato xu'ij che: ¿Can kitzij chi rat, rat rey? xcha' che. Y ri Jesús xu'ij: Rat mismo ya'in chi yin rey, y yin can richin vi ri' tok xinalex y richin ri' yin petenak choch'ulef richin nin-ij ruchojmil ri kitzij. Conojel ri yeniman richin ri kitzij, niqui'en ri nu'ij ri nuch'abel, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Quire' chic xuc'utuj ri Pilato che: ¿Achique ruchojmil ri kitzij c'a? Tok ru'in chic quiri' che ri Jesús, ri Pilato xel chic e richin xech'o chiquivech ri israelitas y xu'ij chique: Yin man jun ch'o'oj ninvil chirij ri jun achi re'. ");
INSERT INTO cak_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero rix juna-juna' ivoyo'en chi yin nincol-e jun preso chupan ri nimak'ij pascua. Vacami, ¿nijo' rix chi yin nincol-e ri Rey quichin ri israelitas? xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Jac'a ri vinak riq'uin cuchuk'a' quire' niqui'ij-apu: Man tacol-e ri achi re', ja ri Barrabás tacolo-e, xecha-apu. Y ri Barrabás xa jun elek'on. ");
INSERT INTO cak_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Jac'ari' tok ri gobernador Pilato xujach-e ri Jesús richin nich'ay. ");
INSERT INTO cak_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Jac'a ri soldados xquibach'uj rakan tak xic'a'y c'o quiq'uixal; achel jun corona xqui'en che, y xquiya-ka pa (rujolon, ruvi') ri Jesús. Xquiya' jun tziek morado chirij, ");
INSERT INTO cak_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","y niqui'ij che: ¡Caquicot rat ri rat Rey quichin ri israelitas! yecha'. Y niquiyala' k'a' che. ");
INSERT INTO cak_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jac'ari' tok ri Pilato xel chic pe jun bey richin xuch'o chiquivech ri vinak, y quire' c'a xu'ij chique: Titz'eta' c'a, yin ja ninvelesaj-pe ri achi chivech, richin tivetemaj chi rija' man jun ch'o'oj ninvil chirij, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jac'ari' xel-pe ri Jesús rucusan-pe ri corona banon riq'uin q'uix y ri tziek morado. Y jari' tok ri Pilato xu'ij: ¡Jare' ri achi! xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Tok ri nima'k tak quik'ij sacerdotes israelitas y ri yechajin racho ri Dios xquitz'et ri Jesús, riq'uin cuchuk'a' quire' niqui'ij-apu: ¡Tirip chuvech cruz! ¡Tirip chuvech cruz! yecha'. Jac'ari' tok ri Pilato xu'ij chique: Tu'ic'ama-e rix y tiripa' chuvech cruz, roma yin man jun ch'o'oj ninvil chirij, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero ri achi'a' israelitas c'o quik'ij xqui'ij-apu che ri gobernador: Rija' can nubananej chi Ruc'ajol ri Dios, y ri ka-ley roj israelitas nu'ij chi jun ri quiri' nu'on, nic'atzin chi nika camic pa ruvi', xecha'. ");
INSERT INTO cak_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ri Pilato xa ruxi'in-ri', y tok xrac'axaj ri xqui'ij ri vinak chi ri Jesús Ruc'ajol ri Dios, más xuxi'ij-pe-ri'. ");
INSERT INTO cak_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Jari' tok rija' xoc chic apu chupan ri nimajay ri nic'uje-vi y xuc'utuj che ri Jesús: ¿Achique lugar rat petenak-vi? xcha' che. Jac'a ri Jesús man xutzolij ta ruvech rutzij ri Pilato. ");
INSERT INTO cak_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jari' tok ri Pilato xu'ij che: ¿Achique roma man yach'o ta pe? ¿La man aveteman ta chi pa nuk'a' yin c'o-vi richin nin-ij chi yabajix chuvech cruz y richin nin-ij chi yacol-e? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Quire' c'a xu'ij ri Jesús: Rat man jun ak'a' chuve si man ta ri Dios chicaj ruyo'on lugar chave. Roma c'a ri', rat navakalej mac si yinatak pa camic, pero más c'o rumac ri xjacho vichin pan ak'a', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ja hora ri' xtiquer-e chi ri Pilato nutij ruk'ij richin nucol-e ri Jesús. Pero ri israelitas riq'uin cuchuk'a' xech'o-apu, y xqui'ij: Si xtacol-e, k'alaj chi man junan ta avánima riq'uin ri rey César. Roma xa achique na ri ruyon nucusaj-ka-ri' chi rey, xa enemigo chirij ri César, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Tok ri Pilato xrac'axaj ri xqui'ij, xu'ij chi teleses-pe ri Jesús. Jac'ari' xtz'uye' ri Pilato ri achique lugar nuya-vi rutzij pa quivi' ri ni'an sujunic chiquij, ri lugar ri ni'ix Empedrado che, y pan hebreo ni'ix Gabata che. ");
INSERT INTO cak_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ri k'ij ri', jari' nitiquer-ka ri nimak'ij pascua, y ri israelitas niquibanala' chic rubanic ri xtic'atzin chique. Y pa nic'aj k'ij cami chiri' ri Pilato xu'ij chique: ¡Jare' ri i-Rey! xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Jac'a rije' más riq'uin cuchuk'a' xesiq'uin-apu y xqui'ij: ¡Taq'uisa' ruk'ij! ¡Taq'uisa' ruk'ij! ¡Taripa' chuvech cruz! xecha-apu. Ri Pilato xu'ij-pe chique: ¿Ja ri i-Rey nijo' chi ninrip chuvech cruz? Jac'ari' xech'o-apu ri nima'k tak quik'ij sacerdotes israelitas y xqui'ij: ¡Roj xaxe ri César ka-rey! xecha'. ");
INSERT INTO cak_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Jac'ari' xujach-e pa quik'a', richin nebajix chuvech cruz, y rije' xquiq'uen c'a e ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ri Jesús ruc'amon-e ru-cruz xel-e pa tinamit richin ni'e chupan ri lugar ri ni'ix lugar richin rubakil (rujolon, ruvi') ámna che. Pa quich'abel ri israelitas, Gólgota rubi' ri lugar ri'. ");
INSERT INTO cak_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chiri' xquibajij-vi ri Jesús chuvech cruz, y xequibajij chic eca'i' chic chuvech qui-cruz junan riq'uin. Chi tak rutzalanen xequiya-vi, y pa quinic'ajal xc'uje-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri gobernador Pilato quire' xutz'ibaj chuvech jun pedazo tabla ri xuya-e chutza'n ri cruz: JESUS AJ-NAZARET, QUI-REY RI ISRAELITAS. ");
INSERT INTO cak_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Eq'uiy c'a israelitas ri yebano can leer ri tz'iban chuvech ri tabla, roma ri lugar ri xbajix-vi ri Jesús chuvech ri cruz, xa nakaj c'o-vi che ri tinamit Jerusalem. Pan oxi' ch'abel tz'iban-vi; pan hebreo, pa griego y pa latín. ");
INSERT INTO cak_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Jac'a ri nima'k tak quik'ij sacerdotes israelitas quire' xqui'ij che ri Pilato: Man ta xatz'ibaj ri nu'ij: Qui-Rey ri israelitas; más utz tajala', y tatz'ibaj chi xa ja rija' x-in chi qui-rey ri israelitas, xecha'. ");
INSERT INTO cak_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Jac'a ri Pilato quire' xu'ij chique: Ri xintz'ibaj yan, nutz'iban chic; man jun roma xtinjal, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Tok ri soldados quibajin chic ri Jesús chuvech ri cruz, xequic'ama-pe ri rutziak ri quich'ilon can chirij richin xquijach chiquivech. (Caji', quiji') tanto xqui'en che, jujun quichin chiquijununal. Jac'ari' xequic'ama-pe ri jun chic rutziak ri manak rut'isel roma xaxe jun quemoj banon che. ");
INSERT INTO cak_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Roma c'a ri', ri soldados quire' xqui'ij chiquivech: Man tikaretz ri jun tziek re'. Xa kujetz'an chirij, richin quiri' achique na xtich'acon-e, xecha'. Ronojel ri xbanataj riq'uin rutziak ri Jesús, can richin nibanataj ri tz'iban can chupan ruch'abel ri Dios ri nu'ij: Xquijachala' ri nutziak chiquivech, Y c'o che ri xe'etz'an chirij. Romari' can quiri' vi xqui'en ri soldados. ");
INSERT INTO cak_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chiri' chirakan ri cruz ri bajin-vi ri Jesús c'o-apu ri rute', c'o-apu ri María rixayil ri Cleofas, c'o-apu ri María Magdalena, y jun chic ixok quichak'-quinimal qui' riq'uin rute' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ja jun ri discípulo ri can (nojovex, nojo'ox) pa'el-apu chiri'. Y quire' c'a xu'ij-pe ri Jesús che ri rute' tok xutz'et-pe: Nte', vacami ja discípulo la' ntoc can aval, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","C'ajari' xu'ij-pe che ri discípulo: Vacami ja la' ntoc can ate', xcha'. Roma c'a ri', ja hora ri' ri discípulo ri' xuc'uaj ri María chiracho. ");
INSERT INTO cak_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ri Jesús roma reteman chi ronojel xc'achoj yan y richin nibanataj ri tz'iban can chupan ruch'abel ri Dios, quire' xu'ij: Can nichakij nuchi', xcha'. ");
INSERT INTO cak_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chiri' c'o jun xára nojnak riq'uin jun ch'amilaj vino. Ri soldados xquimuba-e jun esponja chupan, xquiya-e chutza'n jun che' hisopo, y xquijelesaj-apu chiruchi' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Tok rutz'ubun chic can ri ch'amilaj vino, rija' xu'ij: Xc'achoj c'a ronojel, xcha'. Jac'ari' xulucuba-pe ri (rujolon, ruvi') y xujach c'a ránima pa ruk'a' ri Dios. ");
INSERT INTO cak_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ri k'ij ri', conojel ri israelitas niquibanala' chic rubanic ronojel ri nic'atzin chique, roma ja tok nika-ka ri k'ij, jari' nitiquer-ka ri nimak'ij pascua. Ri na'ey k'ij richin ri nimak'ij, jun nimalaj k'ij y k'ij richin uxlanen. Romari' ri achi'a' israelitas c'o quik'ij nicajo' chi cha'anin (yecom, yequen) ri achi'a' ebajin chuvech cruz, richin quiri' yekases-pe y yemuk na'ey chuvech ri nimak'ij. Roma c'a ri', riq'uin quemelal xquic'utuj che ri Pilato chi tik'ajlo'x cakan ri ebajin chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xepe c'a ri soldados, xquik'aj rakan ri na'ey y quiri' mismo xqui'en riq'uin ri jun chic ri ebajin chutzalanen ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jac'a tok xejel-apu riq'uin ri Jesús y xquitz'et chi xa caminak chic, man xquik'aj ta ri rakan. ");
INSERT INTO cak_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Pero jun chique ri soldados xuju' rutza'n ri ru-lanza chuc'alc'a'x ri Jesús, y xel-pe quic' y ya'. ");
INSERT INTO cak_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri xtz'eto ri xbanataj, jari' nitzijon richin, y ri nutzijoj can kitzij vi. Rija' reteman chi can kitzij ri nutzijoj chupan ri vuj re', richin quiri' can ta chi'ivonojel rix ninimaj. ");
INSERT INTO cak_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ronojel re' xbanataj, richin nitzakon ri tz'iban can chupan ruch'abel ri Dios ri nu'ij: Nis-ta jun rubakil xtiquik'aj. ");
INSERT INTO cak_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y juc'an chic quire' nu'ij: Xtiquitz'et ri Jun ri xquitek'a' ri ru-cuerpo. ");
INSERT INTO cak_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Tok xbanataj ronojel re', c'o jun achi rubinan José aj pa tinamit Arimatea, ri riq'uin quemelal xuc'utuj ru-cuerpo ri Jesús che ri gobernador Pilato, y ri Pilato xu'ij chi utz. Ri José jun tzekle'ey richin ri Jesús, pero man ruk'alajrisan ta ri' coma ri achi'a' israelitas c'o quik'ij. Xpe c'a, xukasaj-pe ru-cuerpo ri Jesús y xuq'uen-e. ");
INSERT INTO cak_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ja jun c'a ri Nicodemo (xapon, xebos), ruc'uan-apu mirra ri yo'on sábila riq'uin. Juba' ma jun quintal ri ak'on ruc'uan-apu. Ri Nicodemo re', jare' ri xch'o riq'uin ri Jesús pa jun xok'ok'a'. ");
INSERT INTO cak_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ri José y ri Nicodemo, xquibolkotij c'a ri ru-cuerpo ri Jesús pa tak tziek, y xquiya' jubulaj ak'on chirij. Rije' quiri' xqui'en che ru-cuerpo ri Jesús, roma ri israelitas can quiri' vi niqui'en chique ri qui'anima'i'. ");
INSERT INTO cak_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chunakaj ri lugar ri xbajix-vi ri Jesús chuvech cruz, c'o jun juyu' ticon ruvech. Chiri' c'o jun quijul anima'i' ri c'a juba' tic'ot ri man jani tiyo'ox jun ámna chupan. ");
INSERT INTO cak_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chiri' xquiya-vi ri Jesús, roma ri jul ri' nakaj c'o-vi, y roma ri israelitas niquitij quik'ij niquibanala' can rubanic ronojel ri nic'atzin chi niqui'en na'ey chi nitiquer-ka ri nimak'ij pascua. ");
INSERT INTO cak_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Cumaj-cumaj yan sakar chupan ri na'ey k'ij richin ri semana, can c'a k'eku'n na chiri', ri María Magdalena xbe chuchi' ri jul ri xyo'ox-vi ri Jesús, y xutz'et chi ri abaj achok che tz'apin-vi can ruchi' ri jul, xa elesan-e. ");
INSERT INTO cak_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jac'ari' junanin xbe quiq'uin ri Simón Pedro y ri jun chic discípulo ri can (nojovex, nojo'ox) roma ri Jesús, y quire' xu'ij chique: Ri ru-cuerpo ri Ajaf Jesús ec'o xe'elesan-e ri pa jul, y vacami man keteman ta achique lugar xyo'ox-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Jari' xe'el-e ri Pedro y ri jun chic discípulo richin xebe chuchi' ri jul. ");
INSERT INTO cak_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Chi ca'i' junanin ebenak, pero ri jun chic discípulo más anin nibin chuvech ri Pedro, romari' na'ey (xapon, xebos) chuchi' ri jul. ");
INSERT INTO cak_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xluque' c'a ka richin ninachan-apu chupan, xutz'et chi chiri' ec'o-vi can ri tziek, pero man xoc ta apu ri pa jul. ");
INSERT INTO cak_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Jac'a ri Simón Pedro tok xerila' ri jun chic discípulo, choj xoc-apu chupan ri jul, y xutz'et ri tziek eyo'on can chiri', ");
INSERT INTO cak_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","y xutz'et ri tziek ri xpis (rujolon, ruvi') ri Jesús che, pero man quiq'uin ta ri ch'aka' chic tziek c'o-vi, xa juc'an chic busun-vi can. ");
INSERT INTO cak_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","C'ajari' xoc-apu ri jun chic discípulo ri c'o-apu na'ey chuchi' ri jul, y tok xerutz'et ri tziek, xunimaj chi can xc'astaj na vi e. ");
INSERT INTO cak_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Quiri' xbanataj quiq'uin ri discípulos, roma man (k'axnak, novinak) ta chiquivech ri tz'iban can chi ri Jesús can nic'atzin-vi chi nic'astaj chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","C'ajari' xetzolij-e chi tak cacho ri ca'i' discípulos. ");
INSERT INTO cak_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Jac'a ri María Magdalena ntok' xc'uje' can chuchi' ri jul. Y quiri' pa rok'ej xluque-ka richin ninachan-apu chupan ri jul. ");
INSERT INTO cak_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Jac'ari' tok xerutz'et-apu ca'i' ángeles sak tak quitziak. Jun tz'uyul ri lugar ri xli'e-vi (rujolon, ruvi') ri Jesús, y ri jun chic tz'uyul ri xli'e-vi ri rakan. ");
INSERT INTO cak_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ri ca'i' ángeles quire' xquic'utuj che ri María Magdalena: Ixok, ¿achique roma yatok'? xecha' che. Y rija' xu'ij chique: Yin yinok' roma ec'o xe'elesan-e ru-cuerpo ri Vajaf Jesús y man veteman ta achique lugar xquiya-vi, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tok ru'in chic ka quiri', jari' xtzu'un can chirij, xutz'et chi ja ri Jesús pa'el-apu chiri', pero man xretemaj ta ruvech. ");
INSERT INTO cak_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ri Jesús xu'ij che: Ixok, ¿achique roma yatok'? y, ¿achique c'a ri nacanoj? xcha' che. Ri María Magdalena xunojij chi ja ri achi samajiy tico'n chiri' ri nich'o-pe, romari' xu'ij che: ¡Achi! Si ja rat xac'amo-e ri cuerpo, ta'ij chuve achique lugar xaya-vi, y yin xtinq'uen-e, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jari' tok ri Jesús quire' xu'ij che: ¡María! xcha'. Rija' c'ajari' xutz'et-apu utz-utz chi ja ri Jesús, y xu'ij che: ¡Raboni! xcha'. Ri ch'abel ri' nu'ij tzij Tijonel. ");
INSERT INTO cak_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jac'a ri Jesús xu'ij che: Man (quinatz'om, quinachop) pe roma yin man jani quijote-e riq'uin ri Nata'. Pero cabin quiq'uin ri e'ocunak nchak' y ta'ij chique chi yin can yi'e riq'uin ri Nata', ri Itata' mismo rix. Yi'e riq'uin ri nu-Dios, ri i-Dios mismo rix, xcha' che. ");
INSERT INTO cak_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Can xbe na vi ri María Magdalena quiq'uin ri discípulos richin xu'ij chique ri bin-e che, y quire' xu'ij: ¡Xintz'et ruvech ri Ajaf! xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tok xk'ok'a-pe chupan ri k'ij ri', ri na'ey k'ij richin ri semana, ri discípulos quimolon-qui', pero quitz'apilo'n ruchi' ri jay ri quimolon-vi-qui' roma quixi'in-qui' chiquivech ri israelitas. C'ate xquitz'et, c'o chic ri Jesús pa quinic'ajal, y quire' xu'ij chique: Ri uxlanen ri petenak riq'uin ri Dios tic'uje' pa tak ivánima chi'ivonojel, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tok ru'in chic quiri' chique, jari' xuc'utula' rusocotajic ri ruk'a' y ri ruc'alc'a'x chiquivech, y ri discípulos jani na xequicot tok xquitz'et chi can ja vi ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jac'ari' ri Jesús quire' chic xu'ij chique: Tuxlan c'a ri ivánima chi'ivonojel. Vacami can yixintak-e achel xirutak-pe yin ri Nata', richin nin-en ri rusamaj. ");
INSERT INTO cak_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Tok ru'in chic quiri', (xxupun, xvupun) pa quivi' y xu'ij chique: Tic'ulu' c'a ri Lok'olaj Espíritu. ");
INSERT INTO cak_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Si rix ni'en perdonar rumac jun vinak, ja jun ri Dios nu'on perdonar ri mac ri'. Pero si rix man xti'en ta perdonar, ri Dios man xtu'on ta perdonar ri mac ri', xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jun chique ri doce ru-discípulos ri Jesús man c'o ta quiq'uin ri ch'aka' chic discípulos tok ri Jesús xuka chiquicojol, y ri' ja ri Tomás ri ni'ix Gemelo che. ");
INSERT INTO cak_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Romari' ri ch'aka' chic discípulos quire' xqui'ij che: Roj xkatz'et ri Ajaf, xecha' che. Jac'a rija' xa quire' xu'ij chique: Si yin man nintz'et ta ri lugar ri xe'oc-vi ri clavos pa tak ruk'a', y man ninju' ta apu ri ruvi' nuk'a' chupan ri socotajic ri xqui'en ri clavos, y man ninya' ta apu nuk'a' chupan ri socotajic ri xu'on ri lanza chuc'alc'a'x, man ninnimaj ta, xcha' ri Tomás. ");
INSERT INTO cak_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tik'ax vakxaki' k'ij chiri', rije' quimolon chic qui' jun bey y c'o yan chic ri Tomás chiquicojol chiri'. Jari' tok ri Jesús xepapo' chic jun bey pa quinic'ajal, y ri ruchi' ri jay xa tz'apel. Rija' xu'ij chique: Tuxlan ri ivánima chi'ivonojel, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jac'ari' xu'ij che ri Tomás: Taju-pe la ruvi' ak'a' vave' y que'atz'eta' rusocotajic ri nuk'a'. Tajelesaj-pe la ak'a' chi nuc'alc'a'x y taju-pe chupan ri socotajic ri xu'on ri lanza. Tanimaj c'a, y man ta'an achel niqui'en ri man yinquinimaj ta. ");
INSERT INTO cak_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Jac'ari' xu'ij ri Tomás che ri Jesús: ¡Ja rat ri Vajaf y nu-Dios yin! xcha'. ");
INSERT INTO cak_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Y ri Jesús xu'ij c'a che ri Tomás: C'a ja tok xinatz'et Tomás, c'ajari' xinanimaj. Pero utzulaj tzij ri' ri yinquinimaj masque man yin quitz'eton ta, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús c'a c'o q'uiy milagros xerubanala' chiquivech ri ru-discípulos ri man etz'iban ta can chupan ri vuj re'. ");
INSERT INTO cak_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ri etz'iban can, etz'iban richin chi rix tinimaj chi ri Jesús jari' ri Jun ri takon-pe chucolic rutinamit ri Dios, y chi can Ruc'ajol vi. (Chuka', ka) etz'iban can richin chi tok rix iniman chic chiri', nivil jun jabel c'aslen pa rubi' rija'. ");
INSERT INTO cak_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tok xbanataj yan ronojel re', ri Jesús xuc'ut chic ri' jun bey chiquivech ri ru-discípulos, ja yan chic chuchi' ri lago rubinan Tiberias. Quire' c'a xbanataj tok xuc'ut-ri' chiquivech: ");
INSERT INTO cak_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chiri' chuchi' ri ya' c'o ri Simón Pedro, ri Tomás ri ni'ix Gemelo che, ri Natanael aj pa tinamit Caná ri c'o quila' pa Galilea, ri eca'i' ruc'ajol ri Zebedeo y ca'i' chic discípulos más. ");
INSERT INTO cak_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ri Simón Pedro quire' xu'ij chique ri ch'aka' chic discípulos ri ec'o chiri' riq'uin: Yin (ye'entz'ama', yebenchapa') quer, xcha' chique. Ja jun roj nku'e chavij, xecha' che. Xe'oc c'a e conojel pa jun canoa y xebe. Junak'a' xec'ase', pero nis-ta jun ch'uti quer xuya-ri' chiquik'a'. ");
INSERT INTO cak_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Xa juba' chic nrojo' chi nisakar-pe, ri Jesús pa'el chiri' chuchi' ri ya'. Pero ri discípulos man queteman ta chi ja ri Jesús ri c'o chiri'. ");
INSERT INTO cak_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jari' tok ri Jesús quire' xu'ij-apu chique: Valc'ua'l, ¿manak achique iviq'uin richin nitij? xcha-apu chique. Man jun, xecha-pe ri discípulos. ");
INSERT INTO cak_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Quire' c'a xu'ij-apu ri Jesús chique: Tiya-ka la ya'l pa derecha che ri canoa y chiri' xque'ivil-vi quer, xcha'. Can quiri' na vi xqui'en, jari' tok man yetiquer yan ta chic niquelesaj-pe ri ya'l pa ya', roma can q'uiy quer xquiya-pe-qui'. ");
INSERT INTO cak_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jari' tok ri discípulo ri can (nojovex, nojo'ox) roma ri Jesús quire' xu'ij-apu che ri Pedro: ¡Ja ri Ajaf Jesús la xch'o-pe! xcha'. Xe xrac'axaj quiri' ri Simón Pedro, ja xucusaj-pe ri rutziak ri relesan-e chirij y xuc'ak-pe-ri' pa ya' richin ntel-pe. ");
INSERT INTO cak_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jac'a ri ch'aka' chic discípulos, c'a pa canoa xepe-vi, quijec'on-pe ri ya'l nojnak riq'uin quer, roma xa man can ta naj e'ocunak-apu pa ruvi' ri ya'. Xa jun cami oxi' rakan-c'an. ");
INSERT INTO cak_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Tok xe'el-pe chuchi' ri ya', xquitz'et chi c'o k'ak' boxon y jabel chic rachak-k'ak' kajnak y c'o jun quer sa'on-ka, y pan. ");
INSERT INTO cak_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xu'ij c'a chique: Que'ic'ama' c'a pe ca'i-oxi' quer ri c'a ja oc xe'ivelesaj-pe pa ya', xcha' chique. ");
INSERT INTO cak_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro ja xjote-apu chupan ri canoa, y xrelesaj-pe ri ya'l c'a chuchi' ri ya', nojnak riq'uin chovon tak quer. Jun ciento riq'uin nic'aj y oxi' chic más chi ronojel. Masque can q'uiy ri quer, ri ya'l man xrak'ach'itaj ta ruvech. ");
INSERT INTO cak_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jac'ari' tok ri Jesús quire' xu'ij chique ri ru-discípulos: Quixampe c'a, quixva', xcha'. Pero nis-ta jun chique ri discípulos ri ec'o chiri' xucovij-ri' richin ta xuc'utuj-apu che ri (achique, acu'x) rija', roma xa xquina'ej chi ja rija' ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jac'ari' tok ri Jesús xjel-apu quiq'uin, (xutz'om, xuchop) ri pan y xuya' chique, y quiri' mismo xu'on riq'uin ri quer. ");
INSERT INTO cak_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ja (oxmul, oxpaj) riq'uin ri' ri tuc'ut-ri' ri Jesús chiquivech ri ru-discípulos, tok xc'astaj yan pe chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Tok xeva' yan conojel, ri Jesús xuc'utuj che ri Simón Pedro: Simón, rat ri ruc'ajol ri Jonás, ¿yinajo' cami más que chiquivech conojel re'? xcha' che. Ja', Ajaf, rat aveteman chi can yatinjo-vi, xcha' ri Pedro. Y ri Jesús xu'ij che: Si yinajo', que'ayuk'uj y que'achajij ri yeniman nutzij roma rije' e'achel nu-ovejas. ");
INSERT INTO cak_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jac'ari' tok ri Jesús quire' chic xu'ij-apu jun bey che: Simón, rat ri ruc'ajol ri Jonás, ¿kitzij yinajo'? xcha'. Ja', Ajaf, rat aveteman chi can yatinjo-vi, xcha' ri Pedro. Y ri Jesús xu'ij: Si yinajo', que'ayuk'uj y que'achajij ri nu-ovejas. ");
INSERT INTO cak_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Chi rox (mul, paj) ri Jesús xu'ij che: Simón, rat ri ruc'ajol ri Jonás, ¿can kitzij chi yinajo'? Y ri Pedro xpe bis pa ránima, roma ja (oxmul, oxpaj) riq'uin ri' ri quire' xc'utux che roma ri Jesús: ¿Kitzij yinajo'? Jac'ari' tok ri Pedro xu'ij: Ajaf, rat ronojel aveteman. Aveteman chi yatinjo'. Y ri Jesús xu'ij chic che: Que'ayuk'uj y que'achajij c'a ri nu-ovejas. ");
INSERT INTO cak_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kitzij-kitzij nin-ij chave: Tok c'a rat ala' na, ayon rat xaya' ri atziak chavij, y xabe xa achique na lugar. Jac'a tok xcarijix, xque'aric' ak'a' y xa jun chic xtiyo'on ri atziak chavij y xcaruc'uaj achique lugar man nika ta chavech, xcha' che ri Pedro. ");
INSERT INTO cak_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Tok ri Jesús quiri' xu'ij che ri Pedro, xuk'alajrisaj chuvech ri achique chi camic xtuk'asaj ri Pedro richin nuya' nimalaj ruk'ij ri Dios. Y tok ri Jesús ru'in chic quiri' che ri Pedro, xu'ij c'a che: Quinatzekle'ej, xcha'. ");
INSERT INTO cak_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Tok ri Jesús y ri Pedro ebenak, xtzu'un can ri Pedro chirij y xutz'et chi ri discípulo ri can (nojovex, nojo'ox) roma ri Jesús tzakal-e chiquij. Ri discípulo ri xutz'et can ri Pedro, ja ri jun ri xrak'e-apu choruc'u'x ri Jesús ri pa va'in chak'a' richin quire' xuc'utuj-apu: Ajaf, ¿achique c'a ri xtijacho-e avichin? ");
INSERT INTO cak_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Tok ri Pedro xutz'et ri discípulo ri', xuc'utuj che ri Jesús: Ajaf, y ri jun (kachbil, kach'il) re', ¿achique xtibanataj riq'uin? xcha'. ");
INSERT INTO cak_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Quire' c'a xu'ij ri Jesús che ri Pedro: Si ninjo' chi rija' c'a q'ues na tok xquipe chic jun bey, ¿achique nic'atzin chi rat nac'utuj ri'? Rat xaxe quinatzekle'ej, xcha' che ri Pedro. ");
INSERT INTO cak_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ri jun tzij re' xbe rutzijol chiquicojol ri quiniman ri Jesús. Y rije' xquinojij chi ri jun discípulo ri' man (nicom, niquen) ta. Pero xa man quiri' ta ri xrojo' xu'ij ri Jesús, roma rija' xa xu'ij: Si ninjo' chi rija' c'a q'ues na tok xquipe chic jun bey, ¿achique nic'atzin chi rat nac'utuj ri'? ");
INSERT INTO cak_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ja discípulo re' ri tz'ibayon can ri c'o chupan ri vuj re'. Y keteman chi ronojel ri nuk'alajrisaj, can kitzij; roma rija' riq'uin ruvech xutz'et. ");
INSERT INTO cak_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","C'a c'o na más chic ch'aka' achique xerubanala' ri Ajaf Jesús ri man tz'iban ta can chuvech vuj. Roma xa ta chi jujun chi jujun etz'iban can ronojel, yin ninnojij chi choch'ulef man nuc'ul ta chi niyac ronojel ri vuj ri yetz'ibes. Amén.");
INSERT INTO cak_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nimalaj Teófilo, chupan ri jun na'ey vuj ri xintak-e chave, nutz'iban-e ronojel ri samaj ri xutz'uc can ri Jesús, y ronojel ri xu'ij richin xerutijoj ri vinak, ");
INSERT INTO cak_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","c'a ja tok xril k'ij chi rija' xc'ul chila' chicaj. Pero na'ey chi xbe, rija' uc'uan roma ri Lok'olaj Espíritu xerupaxa'aj can ri apóstoles ri erucha'on riq'uin ri achique nic'atzin chi niqui'en can. ");
INSERT INTO cak_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chupan cuarenta k'ij chirij can ri nimalaj k'axomal y ri camic ri xuk'asaj, jalajoj rubanic xu'on richin xuc'utula-ri' chiquivech, richin xquetemaj chi kitzij xc'astaj chiquicojol ri anima'i', y c'o xu'ij can chique pa ruvi' ru-gobierno ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Jun k'ij tok ri Jesús c'o quiq'uin, quire' xu'ij chique: Man quixel-e pa tinamit Jerusalem, xa tivoyo'ej ri rusujun-pe ri Dios chi nuya', achel ri ivac'axan-pe viq'uin yin. ");
INSERT INTO cak_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Roma ri Juan ri Bautista riq'uin ya' xu'on-vi bautizar, jac'a rix, juba' más chikavech apu xquix-an bautizar riq'uin ri Lok'olaj Espíritu, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jac'ari' tok ri quimolon-qui' xquic'utuj-apu che ri Jesús: Ajaf, ¿ja cami xril k'ij chi nak'asaj chic jun bey ri gobierno pa kak'a' roj israelitas? xecha' che. ");
INSERT INTO cak_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jac'a rija' xu'ij chique: Man ivichin ta rix chi nivetemaj achique tiempo y achique k'ij xtibanataj. Ri' xe pa ruk'a' ri Dios c'o-vi. ");
INSERT INTO cak_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero xtiyo'ox uchuk'a' chive tok xtika-pe ri Lok'olaj Espíritu pan ivi'. Y ri itz'eton y ri ivac'axan viq'uin, rix xtitzijoj pa Jerusalem, pa ronojel tak lugares richin ri Judea, pa departamento Samaria, y pa ruvi' ronojel ri roch'ulef, chi naj chi nakaj xtiya-vi rutzijol, xcha' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Tok ru'in chic ri ch'abel ri', can chiquivech xc'amer-vi-e chicaj y jun sutz' xevan chiquivech. ");
INSERT INTO cak_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","C'a quiri' na benak quivech chirij ri Jesús ri benak chicaj chiquivech, jari' tok xe'epapo' eca'i' achi'a' quiq'uin ri quicusan sak tak tziek. ");
INSERT INTO cak_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Ri ca'i' achi'a' ri' xqui'ij chique: Rix tata'aj ri rix richin ri departamento Galilea, ¿achique roma yixtzu'un-e chicaj? Roma ri Jesús ri xc'amer-e chivech richin xc'ul chicaj, nipe chic jun bey. Y achel xu'on tok xbe chicaj, quiri' mismo xtu'on tok xtipe, xecha' chique. ");
INSERT INTO cak_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ri tzekle'ey richin ri Jesús, xeka-pe pa ruvi' ri juyu' Olivos, y xetzolij pa tinamit Jerusalem ri man naj ta quicojol, xaxe cami jun kilómetro. ");
INSERT INTO cak_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Tok ec'o chic chiri' pa Jerusalem, xejote-e ri pa ruca'n piso che ri lugar ri can ec'o-vi-pe, y jare' ri quibi': ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo ruc'ajol ri Alfeo, ri Simón ri c'o quiq'uin ri achi'a' ni'ix celadores chique, y ri Judas ruc'ajol jun achi rubinan Jacobo. ");
INSERT INTO cak_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Conojel rije' k'ij-k'ij xa jun cánima niquiquemelaj-qui' chuvech ri Dios niqui'en orar junan quiq'uin ri ixoki', ri María ri rute' ri Jesús, y ri eruchak' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chupan tak ri k'ij ri' ri quiniman ri Jesucristo quimolon-qui' jun cami ciento veinte. Xpa'e' c'a ri Pedro chiquivech, y xu'ij chique: ");
INSERT INTO cak_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Rix tata'aj, ri kachak'-kanimal ki' iviq'uin, can xc'atzin chi xtzakon ri tz'iban can chupan ruch'abel ri Dios chirij ri Judas. Roma ri Lok'olaj Espíritu xuya' pa ruchi' ri rey David chi ru'in can ri achique xterubana' ri Judas ri xoc uc'uay quibey ri vinak ri xe'uc'uan richin ri Jesús pa cárcel, ");
INSERT INTO cak_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","y ri Judas, mismo jun apóstol chikacojol y junan xsamaj kiq'uin chupan ri samaj re'. ");
INSERT INTO cak_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ri méra ri xuc'ul rija' tok xujach-e ri Jesús, xcuses richin xlok' jun juyu'. Jac'a ri Judas xa xujitz'aj rukul, y tok xtzak pan ulef, xcubucu' y xuquiraj-e-ri' rixco'l. ");
INSERT INTO cak_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ri xuk'asaj ri Judas, chi ch'uti'k chi nima'k xe'ac'axan vave' pa Jerusalem. Romari' Acéldama xubinaj ri juyu' ri'. Roma pa quich'abel ri aj-Jerusalem, Acéldama nu'ij tzij juyu' richin quic'. ");
INSERT INTO cak_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Xa romari' chupan ri vuj Salmos quire' nu'ij chirij ri Judas: Man jun c'a tic'uje' chupan ri racho, Ti'an can tolonic jay che; y: Toc chic jun pa ruq'uexel richin nipa'e' can chuvech ri rusamaj, nicha'. ");
INSERT INTO cak_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Romari' nic'atzin chi ri Judas nikacanoj jun ruq'uexel chiquicojol ri achi'a' ri (xojcachbilaj, xojcach'ilaj) chupan ronojel ri tiempo tok xel-xoc ri Ajaf Jesús chikacojol, ");
INSERT INTO cak_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","richin nutzijoj junan kiq'uin chi ri Jesús can xc'astaj na vi chiquicojol ri anima'i'. Romari' nrojo' jun ri can c'o-pe kiq'uin xe tok x-an bautizar ri Jesús roma ri Juan, c'a ja tok xc'amer-e ri Jesús chikacojol richin xc'ul chila' chicaj, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xquiya' c'a apu quibi' ca'i' achi'a', jun rubinan José Barsabás y ni'ix Justo che, y ri jun chic rubinan Matías. ");
INSERT INTO cak_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Jac'ari' xqui'en orar, y xqui'ij: Ajaf, rat ri natz'et cánima conojel, tac'utu' c'a chikavech achique chique ri ca'i' achi'a' re' acha'on ");
INSERT INTO cak_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","richin nipa'e' can chuvech ri samaj y ntoc apóstol pa ruq'uexel ri Judas ri xyo'on can ri samaj re' roma rumac, richin xbe chupan ri lugar ri can richin vi rija', xecha'. ");
INSERT INTO cak_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Jac'ari' xquiya' pan etz'anen ri ca'i' (bi'aj, binaj), y ja ri Matías xkaj-en richin xoc apóstol junan quiq'uin ri once chic apóstoles. ");
INSERT INTO cak_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Tok xril ruk'ijul ri quinimak'ij ri israelitas rubinan Pentecostés, conojel ri quiniman ri Ajaf Jesús junan cánima quibanon quimolon-qui'. ");
INSERT INTO cak_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","C'ate xquina', xk'ajan-pe jun achel nimalaj cak'ik' chicaj ri petenak riq'uin ruchuk'a', y xunojsaj ri jay ri etz'uyul-vi. ");
INSERT INTO cak_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Jac'ari' xquitz'et xrepero' achel ruxak-k'ak', y nujachala-ri' xka pa quivi' chiquijununal. ");
INSERT INTO cak_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ri Lok'olaj Espíritu xunojsaj ri cánima conojel y xech'o-pe pa jalajoj tak ruvech ch'abel, achel xuya' ri Lok'olaj Espíritu chique chiquijununal. ");
INSERT INTO cak_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chupan tak ri k'ij ri' chiri' pa tinamit Jerusalem, ec'o achi'a' israelitas eyo'ol ruk'ij ri Dios epetenak pa ronojel ruvi' ri roch'ulef. ");
INSERT INTO cak_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Y roma ri xk'ajan, man juba' ta oc vinak xquimol-apu-qui' chiri', y man niquil ta achique niquinojij roma can pa quich'abel chiquijununal ri ye'ac'axan yech'o-vi ri tzekle'ey richin ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Rije' satznak cánima y man niquil ta achique niquinojij chirij ri najin chiquivech, y niquibila': ¿Man erichin ta ri departamento Galilea re yech'o re' c'a? ");
INSERT INTO cak_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Achel chi ja ri ch'abel ri roj q'uiyinak-vi-pe chikajununal nikac'axaj chi yech'o-vi? ");
INSERT INTO cak_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Roma chikacojol roj ec'o aj vave' pa departamento Judea, ec'o epetenak pa jalajoj tak roch'ulef, achel ri Partia, ri Media, ri Elam, ri Mesopotamia, ri Capadocia, ri Ponto, ri Asia, ");
INSERT INTO cak_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ri Frigia, ri Panfilia, ri Egipto, y ri lugares más quila' che ri tinamit Cirene richin ri roch'ulef Africa. C'o epetenak pa tinamit Roma, y chique rije' ec'o ri can kitzij chi israelitas pa calaxic, y ec'o man israelitas ta ri niquiya' ruk'ij ri kitzij Dios junan quiq'uin ri israelitas. ");
INSERT INTO cak_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","C'o epetenak pa roch'ulef Creta, y pa roch'ulef Arabia. Can pa tak kach'abel chikajununal nikac'axaj-vi ri nimalaj rusamaj ri Dios ri niquitzijoj, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Conojel rije' satznak cánima man niquil ta achique niquinojij, y niquibila' chiquivech: ¿Achique cami ruchojmil ronojel re'? yecha'. ");
INSERT INTO cak_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero ec'o chique ri xquimol-apu-qui' ri xa yetze'en-apu chiquij ri quiniman ri Ajaf Jesús, y niqui'ij: La' xa xek'aber, yecha'. ");
INSERT INTO cak_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Jac'ari' ri Pedro ri c'o-apu junan quiq'uin ri once chic apóstoles xpa'e' chiquivech ri quimolon-qui' chiri', y quire' xu'ij: Nuvinak israelitas ri rix tata'aj ri rixc'o vave' pa Jerusalem ri k'ij re', tivac'axaj y tivetemaj ri xtin-ij chive: ");
INSERT INTO cak_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ri kamolon-ki' vave' vacami, man roj k'abarela' ta, achel ri ninojij rix. Roma xa c'a ja las nueve nisakar. ");
INSERT INTO cak_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ri xitz'et rix kiq'uin vacami, ja ri ru'in can ri profeta Joel ojer ri quire' nu'ij: ");
INSERT INTO cak_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Chupan ri ruq'uisbel tak k'ij, yin, nicha' ri Dios, Xtintak-pe ri Lok'olaj Espíritu pa quivi' conojel, Y ri ivalc'ua'l chi xtani' chi alabo xtiquiya' rubixic ri xtin-ij-pe pa cánima. Ri c'ajola' pa jun achel achic' xtiquitz'et ri man jani tibanataj, Y ri achi'a' c'o chic quijuna', xticachic'aj ri xquebanataj ri más chiquivech apu. ");
INSERT INTO cak_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ja jun pa quivi' ri nusamajela', chi achi'a' chi ixoki' Xtintak-pe ri Lok'olaj Espíritu, y rije' xtiquiya' rubixic ri xtin-ij-pe yin pa cánima. ");
INSERT INTO cak_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Xtin-en chi xquebanataj ri man jun bey etz'eton chuvech ri rocaj; Y nimalaj tak retal ruchuk'a' ri Dios choch'ulef. Xtitz'etetaj quic', k'ak', y sib ri jani na nibukuk. ");
INSERT INTO cak_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ri k'ij xtik'uk'umer ruvech Y ri ic' xtoc achel quic'. Quiri' xtibanataj na'ey chi nuka ri k'ij tok ri Ajaf xtu'on ri ru'in can, Ri nimalaj k'ij ri can c'o ruk'ij. ");
INSERT INTO cak_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y xa achique na ri xtic'utun che ri Ajaf chi tucolo', can xticolotaj-vi. Quiri' nu'ij ri Dios chupan ri rutz'iban can ri profeta Joel, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Jac'ari' quire' chic xu'ij: Nuvinak israelitas ri rix tata'aj, tivac'axaj ri ch'abel ri xtin-ij chive: Ri Jesús aj-Nazaret, can xk'alajin chi'icojol chi riq'uin ri Dios petenak-vi, roma ri Dios xu'on chi xerubanala' nima'k tak samaj ri xa achique na xina' rix che, nimalaj tak retal ri ruchuk'a' ri man jun bey tz'eton chi'icojol. Y ri' jabel iveteman rix. ");
INSERT INTO cak_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ri Jesús re' xjach pan ik'a', roma can quiri' vi runojin-pe ri Dios chi nibanataj. Xjel ik'a' chirij richin xiya' pa quik'a' vinak ri manak Dios pa quivech, richin quiri' xicamisaj chuvech cruz. ");
INSERT INTO cak_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Jac'a ri Dios xu'on chi xc'astaj-pe ri Jesús, xrelesaj-pe pa ruk'a' ri k'axomal richin ri camic, roma manak che'el chi ri Jesús nicanaj can jumul pa ruk'a' ri camic. ");
INSERT INTO cak_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Romari' ri rey David ja ruch'abel ri Jesús nucamuluj tok xu'ij: Yin jumul nintz'et ri Ajaf Dios chinuvech. Rija' can c'o-pe pa nu-derecha, romari' man jun roma xtinxi'ij-vi'. ");
INSERT INTO cak_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Romari' niquicot ri vánima, y can qui' nuc'u'x yich'o. Y yin masque xtimuk ri nu-cuerpo, c'a c'o na nuyo'on-vi-apu nuvech. ");
INSERT INTO cak_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Roma rat nu-Dios, man xtaya' ta can jumul ri vánima chupan ri lugar quichin ri anima'i'. Ni man xtaya' ta lugar chi nik'ey-ka ri nu-cuerpo yin ri Lok'olaj Ac'ajol. ");
INSERT INTO cak_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ac'utun rubey ri c'aslen chinuvech, Y roma can aviq'uin xquic'uje-vi-apu, jari' xtibano chi tz'akat xtiquicot ri vánima. Quiri' ri rutz'iban can ri David, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Y rix vach'alal ri rix tata'aj, iveteman chi ri rey David ri kamama' ojer can (xcom, xquen) y xmuk, y ri lugar ri xmuk-vi, c'a quiri' na k'alaj ri vacami. ");
INSERT INTO cak_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Pero roma ri David can ru-profeta vi ri Dios, y reteman chi ri Dios ruyo'on rutzij che, chi jun chique ri riy-rumam can ri xtutz'uyuba' can chi Rey pa ruq'uexel ri David, ");
INSERT INTO cak_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","romari' can achel xutz'et yan e ri xquebanataj tok xu'ij chi ri Jun ri xtitak-pe roma ri Dios chucolic rutinamit, can xtic'astaj na vi e chupan ri lugar quichin ri anima'i', y chi ri ru-cuerpo man xtik'ey ta. ");
INSERT INTO cak_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ri nintzijoj chive ja ri Jesús ri xuc'asoj-pe ri Dios chiquicojol ri anima'i', y roj can riq'uin kavech xkatz'et tok c'astajnak chic pe chiri'. ");
INSERT INTO cak_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Y xc'amer c'a e chicaj roma ruchuk'a' ri Dios, y tok xuc'ul yan ri Lok'olaj Espíritu ri sujun che roma ri Rutata', xuya-pe pa kavi', y jari' ri nitz'et y nivac'axaj rix vacami. ");
INSERT INTO cak_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Quiri' nin-ij chive roma mana-ta ri David ri xbe chicaj, pero ja rija' mismo biyon can: Ri Ajaf Dios quire' xu'ij che ri Vajaf: Catz'uye-pe pa nu-derecha, ");
INSERT INTO cak_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","C'a ja tok xquenya' chuxe' avakan ri itzel yatquitz'et. Quiri' ri rutz'iban can ri David. ");
INSERT INTO cak_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Roma c'a ri', tivetemaj chi'ivonojel rix nuvinak israelitas, chi ri Jesús ri xicamisaj chuvech cruz, can banon che roma ri Dios chi ja rija' Rajaf ronojel, y chi ja rija' ri Jun ri takon-pe chucolic ri rutinamit, xcha' ri Pedro chique. ");
INSERT INTO cak_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Tok ri quimolon-qui' xquic'axaj ri xu'ij ri Pedro, jani na xk'axo ri cánima, y xquic'utuj che ri Pedro y ri ch'aka' chic apóstoles: Rix tata'aj ri kachak'-kanimal ki' chikavech iviq'uin, ¿vacami achique nika'an? xecha'. ");
INSERT INTO cak_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Jari' tok ri Pedro xu'ij chique: Tijala' ino'oj, tiya' can ri mac, y pa rubi' ri Ajaf Jesucristo tibana' bautizar ivi', richin ni'an perdonar ri imac. Y ri Dios xtuya-xtusipaj ri Lok'olaj Espíritu chive. ");
INSERT INTO cak_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Roma ri Lok'olaj Espíritu ri rusujun ri Dios ojer, chive rix y chique ri ivalc'ua'l sujun-vi, y chique conojel ri ec'o chi naj chi nakaj, y chique xa achique na quivech vinak ri yeroyoj ri Kajaf Dios. ");
INSERT INTO cak_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Y c'a c'o na más ch'abel xu'ij ri Pedro chique richin nukasaj cánima y richin yerupaxa'aj. Rija' quire' xu'ij chique: Tiya' can rix ri itzel tak mac ri achel yetajin ri solaj vinak richin ri vacami, richin quiri' yixcolotaj, nicha' chique. ");
INSERT INTO cak_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Roma c'a ri', ri xec'ulu pa cánima ri ch'abel ri xutzijoj ri Pedro, xe'an bautizar, y chupan ri k'ij ri', ec'o cami oxi' mil xeniman ri Jesucristo y xe'oc (cachbil, cach'il) ri quiniman chic. ");
INSERT INTO cak_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Rije' man niquiya' ta can chi niquitijoj-qui' riq'uin ri niquic'ut ri apóstoles, chi junan cánima niquimol-qui', chi yeva' junan, niquiper ri pan c'uxle'el richin rucamic ri Ajaf Jesús, y chi niqui'en orar. Jumul quiri' niqui'en. ");
INSERT INTO cak_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jalajoj tak retal y q'uiy milagros yebanataj chiquik'a' ri apóstoles, y ri vinak jani na niquixi'ij-qui' roma. ");
INSERT INTO cak_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jac'a ri quiniman ri Jesucristo junan ec'o conojel, y ronojel ri achique c'o quiq'uin xa jun cánima pa ruvi'. ");
INSERT INTO cak_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yequic'ayij quijuyu' y qui-cosas, y ri rajil niquijach chiquivech conojel achel ri nic'atzin chique chiquijununal. ");
INSERT INTO cak_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","K'ij-k'ij junan cánima ec'o pa racho ri Dios; can yequicot y (ch'uch'uj, me'l) cánima niquimol-qui' chi tak jay richin niqui'en va'in. ");
INSERT INTO cak_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rije' niquiya' ruk'ij ri Dios, utz yetz'et coma ri vinak, y ri Ajaf k'ij-k'ij nu'on chi más yeq'uiyer, roma nisamaj pa cánima ri can quichin vi chi yecolotaj. ");
INSERT INTO cak_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","C'o jun k'ij richin a las tres xk'ak'ij, ri Pedro y ri Juan junan xejote-e pa racho ri Dios, ri hora richin oración. ");
INSERT INTO cak_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Chiri' chuchi' racho ri Dios k'ij-k'ij neyo'ox can jun achi man nitiquer ta nibin roma can quiri' vi xalex, y chuchi' ri puerta ri Jabel Oc Nitzu'un ni'ix che niyo'ox-vi can, richin nuc'utuj can ru-limosna chique ri ye'oc-apu chiri'. ");
INSERT INTO cak_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Tok ri achi re' xerutz'et ri Pedro y ri Juan chi ye'oc-apu pa racho ri Dios, rija' xuc'utuj-apu ru-limosna chique. ");
INSERT INTO cak_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Jac'a ri Pedro y ri Juan xbe quivech chirij ri achi, y ri Pedro xu'ij che: Kojatz'eta-pe, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Y ri achi nich'icch'ot ruvech chiquij, royo'en ri achique xtiyo'ox can che. ");
INSERT INTO cak_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Jac'a ri Pedro xu'ij che: Yin manak oro ni plata viq'uin richin xtinya' chave, pero ri c'o viq'uin, jari' xtinya' chave. Pa rubi' ri Jesucristo aj-Nazaret cacataj y cabin, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jac'ari' tok ri Pedro (xutz'om, xuchop) chiruk'a' derecha ri achi richin xupaba', y can jari' xec'uje-pe ruchuk'a' ri rakan, y ri rukul tak rakan. ");
INSERT INTO cak_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xropin c'a richin xpa'e', y xbin. Xoc c'a apu chiquij ri Pedro y ri Juan pa racho ri Dios; nibin, niropin y nuya' ruk'ij ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eq'uiy c'a vinak xetz'eto chi nibin y nuya' ruk'ij ri Dios, ");
INSERT INTO cak_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","y xquetemaj ruvech chi ja achi ri' ri nitz'uye' chuchi' racho ri Dios, nuc'utuj limosna chuchi' ri puerta ri Jabel Oc Nitzu'un ni'ix che. Rije' man niquil ta achique niquinojij, y xquixi'ij-qui' roma ri xbanataj riq'uin. ");
INSERT INTO cak_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ri achi ri x-an che chi xc'achoj man yerusok'opij ta can ri Pedro y ri Juan, y chi jun tinamit satznak quic'u'x xuquimolo-qui' quiq'uin chuchi' ri corredor rubinan Richin ri Salomón. ");
INSERT INTO cak_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Tok ri Pedro xerutz'et ri vinak, xu'ij chique: Nuvinak israelitas ri rix tata'aj, ¿achique roma rix can achique na nuna' ri ivánima riq'uin ri xbanataj? Y, ¿achique roma ja chikij roj iyo'on-vi ivech? Ri achi re' xtiquer xbin, pero man roma ta chi roj, roj utz chuvech ri Dios, ni man kuchuk'a' ta roj xbano chi xc'achoj. ");
INSERT INTO cak_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tivac'axaj c'a ri nin-ij chive: Ri qui-Dios ri Abraham, ri Isaac, y ri Jacob, ri eruxe'el can ri katinamit, ja mismo Dios ri', xbano che ri Jesús ri Ruc'ajol chi c'o ruk'ij. Y ja Jesús re' ri xijach rix y man xiya' ta lugar chi xsok'opis-e, tok ri Pilato ru'in chic chi nucol-e. ");
INSERT INTO cak_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Rix ja ri Jun ri can lok'olaj vi y choj ruc'aslen ri man xijo' ta chi xcol-e. Xa ja ri jun camisanel ri xic'utuj chi ticol-e. ");
INSERT INTO cak_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Y ri Jesús ri niyo'on c'aslen xa xicamisaj, pero ri Dios xu'on chi xc'astaj-pe chiquicojol ri anima'i'. Quiri' nika'ij chive, roma roj riq'uin kavech xkatz'et tok rija' xc'astaj yan pe chiri'. ");
INSERT INTO cak_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Y ri achi re nitz'et-pe rix vave' y xa iveteman ruvech, ja pa rubi' ri Jesús xc'achoj-vi roma ri Jesús rubanon chike chi cukul kac'u'x chi nic'achoj, y roma cukul kac'u'x riq'uin ri Jesús tok tz'akat xechojmir ruk'a-rakan ri achi re xc'achoj chivech chi'ivonojel. ");
INSERT INTO cak_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Jac'a yin veteman chi rix nuvinak, y ri yebano gobernar pan ivi', xa roma man iveteman ta si utz o man utz ta ri yixtajin, romari' tok xic'utuj chi tika camic pa ruvi' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ronojel ri xbanataj, xa richin nitzakon ri bin can coma conojel ri profetas ojer, roma rije' quitz'iban can chi ri Jun ri xtutak-pe ri Dios chucolic ri rutinamit, can nuk'asaj na vi k'axomal. ");
INSERT INTO cak_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vacami c'a, tijala' ino'oj, tiya' can ri mac, y titzolij-pe ivánima richin yix-an perdonar, richin quiri' ri Ajaf Dios xtu'on chi xquepe tiempos tok ri ivánima (nic'ases, ch'u'l) xtuna'. ");
INSERT INTO cak_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Y xtutak-pe ri Jesucristo, ri ojer-ojer ri' ruyo'on-pe rutzijol chi nutak-pe iviq'uin. ");
INSERT INTO cak_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero vacami, nic'atzin chi nic'uje' chila' chicaj, c'a terila' na ri k'ij tok xti'an ruchojmil ronojel, achel ruyo'on-pe rutzijol ri Dios chike pa quichi' ri lok'olaj tak profetas ri can ec'o-vi-pe ojer. ");
INSERT INTO cak_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Roma ri Moisés ojer can quire' xu'ij chique ri kati't-kamama': Ri Ajaf Dios mismo chi'icojol rix xtuyec-vi-pe jun profeta, achel xu'on chuve yin. Ronojel c'a ri xtutzijoj ri profeta ri' chive, rix xtiya' ixiquin riq'uin, ");
INSERT INTO cak_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","y xa achique na ri man xtiniman ta richin, xteleses-e chiquicojol rutinamit ri Dios. Quiri' nu'ij ri rutz'iban can ri Moisés. ");
INSERT INTO cak_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Quiri' mismo ri ajani profetas ech'ovinak-pe, ri nitiquer-pe riq'uin ri profeta Samuel, c'o qui'in can chirij ri k'ij ri rojc'o-vi. ");
INSERT INTO cak_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ivichin rix ri rusujun can ri Dios chupan ri ruch'abel ri quitz'iban can ri profetas. Y ri xusuj chique ri kati't-kamama' ojer, tok xu'on ri na'ey ruvujil c'aslen riq'uin ri Abraham, ri nu'ij chi roma jun riy-rumam ri Abraham tok conojel vinak choch'ulef xtiquic'ul favor. ");
INSERT INTO cak_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Roma c'a ri', tok ri Dios ruc'ason chic pe ri Ruc'ajol chiquicojol ri anima'i', na'ey xutak-pe chi'icojol, richin chi riq'uin ri ru-favor ri nuya' pan ivi', chi'ijununal niya' can ivij chuvech ri itzel tak no'oj ri ye'ibanala'. ");
INSERT INTO cak_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Tok ja yech'o ri Pedro y ri Juan chiquivech ri vinak, jari' xe'uka ri sacerdotes israelitas, ri achi'a' saduceos, y ri uc'uay quichin ri yechajin ri racho ri Dios quiq'uin, ");
INSERT INTO cak_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","roma catajnak coyoval chiquij ri Pedro y ri Juan chi yequitijoj ri vinak, y chi niquitzijoj chi riq'uin xc'astaj-e ri Jesús, ja jun ri anima'i' xquec'astaj-e. ");
INSERT INTO cak_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","(Xequitz'om, xequichop) c'a ri ca'i' apóstoles y xequiya' pa cárcel richin chuca'n k'ij, roma xk'ak'ij yan ka. ");
INSERT INTO cak_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero chiquicojol ri xe'ac'axan ruch'abel ri Dios ri k'ij ri', eq'uiy xeniman. Xaxe achi'a' ec'o cami vo'o' mil. ");
INSERT INTO cak_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Jac'a ri chuca'n k'ij, chiri' pa tinamit Jerusalem xquimol-qui' ri yebano gobernar chiquicojol ri israelitas, ri nima'k quijuna' achi'a' c'o quik'ij, ri achi'a' q'uiy queteman chirij ri ley ri xyo'ox che ri Moisés, ");
INSERT INTO cak_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ri nimalaj sacerdote Anás, ri Caifás, ri Juan, ri Alejandro, y conojel quiy-quimam ri nimalaj tak sacerdotes. ");
INSERT INTO cak_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Rije' xequipaba' c'a ri Pedro y ri Juan pa quinic'ajal y quire' xquic'utuj chique: ¿Achique chi uchuk'a' ri nicusaj rix? ¿Y achok pa rubi' xi'en chi xc'achoj ri achi ri'? xecha' chique. ");
INSERT INTO cak_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jac'a ri Pedro, nojnak ri Lok'olaj Espíritu pa ránima, xu'ij chique: Rix ri yixbano gobernar chupan ri katinamit, y rix achi'a' ri nima'k ijuna' y c'o ik'ij pan Israel, tivac'axaj ri nin-ij chive: ");
INSERT INTO cak_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Riq'uin ri nic'utuj rix pa ruvi' ri favor x-an che ri jun achi niyavej, ri nijo' nivetemaj achique x-an chi xc'achoj, ");
INSERT INTO cak_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","tivetemaj c'a chi'ivonojel ri rixc'o-pe vave', y conojel ri kavinak israelitas, chi ri achi c'o chivech vacami, utz chic ruk'a-rakan roma rubi' ri Jesucristo aj-Nazaret, ri xic'utuj rix chi xcamises chuvech cruz, pero ri Dios xu'on chi xc'astaj-pe chiquicojol ri anima'i'. ");
INSERT INTO cak_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Y ri Jesús, jari' ri abaj ri man jun rakale'n xi'en che rix ri rix banoy tak jay, pero xa ja rija' ri xcuses richin ruchuk'a' ruxiquini'l ri jay. ");
INSERT INTO cak_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Y man jun chic achok pa rubi' xquecolotaj-vi ri vinak. Roma man jun chic (bi'aj, binaj) yo'on-pe chuvech ri roch'ulef chike richin nkucolotaj, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jac'a ri yebano gobernar chiquicojol ri israelitas, tok xquitz'et chi ri Pedro y ri Juan man niquixi'ij ta qui' yech'o, y tok xquetemaj chi xa erelic tak achi'a' ri man q'uiy ta qui-estudio, rije' man niquil ta achique niqui'ij. Y xk'alajin chiquivech chi ri ca'i' ri' (erachbil, jerach'il) can ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Y roma niquitz'et chi pa'el-apu chiri' ri achi ri x-an che chi xc'achoj, rije' man jun chic xetiquer xqui'ij chique ri ca'i' apóstoles. ");
INSERT INTO cak_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jac'ari' xqui'ij chi que'eleses-e ri Pedro y ri Juan chiri' pa jay, richin quiri' quiyon yenojin can. ");
INSERT INTO cak_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Rije' niquibila' chiquivech: ¿Achique c'a nika'an chique? Roma conojel vinak vave' pa Jerusalem queteman chi xbanataj jun nimalaj milagro, y manak che'el xtika'ij chi man kitzij ta. ");
INSERT INTO cak_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero xaxe richin man ti'e más rutzijol ri xbanataj, quekaxibij, richin quiri' man jun chic achok che tiquitzijoj-vi rubi' ri Jesús, yecha'. ");
INSERT INTO cak_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jac'ari' xecoyoj chic ri Pedro y ri Juan, y xqui'ij chique chi nis-ta jun chic ch'abel tel pa quichi' y chi man chic quetijon pa rubi' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ri Pedro y ri Juan quire' xqui'ij-apu chique: Ti'ij na c'a rix: ¿Más cami utz chuvech ri Dios chi ja rix yixkanimaj na'ey que chuvech ri Dios? ");
INSERT INTO cak_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Roma roj man nkutiquer ta nkutane' chutzijosic ri achique xkatz'et y xkac'axaj riq'uin ri Jesús, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Jac'ari' tok ri achi'a' junan niqui'en gobernar xqui'ij chique ri Pedro y ri Juan: Si man yixniman ta tzij, nitij pokon pa kak'a', xecha' chique. C'ajari' xequisok'opij-e, roma man xquil ta jun roma richin xequi'en castigar, roma ri tinamit can niquiya' ruk'ij ri Dios riq'uin ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Roma ri achi ri achok riq'uin xbanataj-vi ri milagro chi xc'achoj, más chic cuarenta rujuna'. ");
INSERT INTO cak_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Tok ri Pedro y ri Juan xesok'opis yan pe, xetzolij quiq'uin ri más tzekle'ey richin ri Jesús, y xquiya' rutzijol ronojel ri bin-pe chique coma ri nima'k tak quik'ij sacerdotes y ri nima'k quijuna' achi'a' c'o quik'ij. ");
INSERT INTO cak_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Jac'a ri quiniman ri Jesús tok xquic'axaj, junan xech'o riq'uin ri Dios y xqui'ij: Nimalaj Ajaf Dios, ja rat ri xabano ronojel, xabano ri caj y ri ec'o chiri', ri roch'ulef y ri ec'o chuvech, ri mar y ri ec'o chupan, ");
INSERT INTO cak_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","y ja rat xabano chi xel ri ach'abel pa ruchi' ri asamajinel David, tok xu'ij: ¿Achique roma ri man israelitas ta niquipaba-qui' chuvech ri Dios? ¿Achique roma ri vinak pa tak tinamit niquitz'uc-pe tzij ri xa man jun nic'atzin-vi? ");
INSERT INTO cak_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Roma ri reyes pa ruvi' ri roch'ulef xquimol-qui', Ri gobernadores xetz'uye' richin junan quitzij xqui'en Chirij ri Ajaf Dios y chirij ri Jun ri xutak-pe chucolic ri rutinamit. ");
INSERT INTO cak_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ajaf, can xbanataj-vi re rutz'iban can ri David, riq'uin ri xquimol-qui' ri rey Herodes, ri gobernador Poncio Pilato, ri israelitas y ri man israelitas ta, vave' pa tinamit Jerusalem richin xecataj chirij ri Jesús ri Lok'olaj Ac'ajol ri xatak-pe. ");
INSERT INTO cak_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Y riq'uin ri quiri' xqui'en, xtz'akat ri chojmirisan-pe ojer roma ri nimalaj avuchuk'a' y ri nimalaj ano'oj. ");
INSERT INTO cak_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Vacami c'a, Ajaf, tatz'eta' ri achique niqui'ij ri vinak re' richin nkojquixibij, y chutzijosic ri ach'abel, tabana' chike roj asamajela' chi man ta nikaxi'ij-ki', ");
INSERT INTO cak_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","junan riq'uin ri naya' ak'a' pa quivi' ri yeyavej richin yec'achoj, y nac'utula' retal ri avuchuk'a', y ye'abanala' ri man jun bey etz'eton. Quiri' tabana' pa rubi' ri Jesús ri Lok'olaj Ac'ajol, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Y tok xetane' riq'uin ri oración, ri lugar ri quimolon-vi-qui' xsilon. Conojel xnoj ri Lok'olaj Espíritu pa cánima, y man niquixi'ij ta qui' niquitzijoj ri ruch'abel ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Conojel ri quiniman ri Jesucristo junan niquinojij y xa jun cánima quibanon. Man jun ni'in chi xe richin rija' ri ruchajin, roma xa jun cánima quibanon pa ruvi' ronojel ri achique c'o quiq'uin. ");
INSERT INTO cak_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Riq'uin ruchuk'a' ri Dios ri apóstoles niquitzijoj chi ri Ajaf Jesús can xc'astaj-vi-e chiquicojol ri anima'i', y can c'o ru-favor ri Dios pa quivi' conojel. ");
INSERT INTO cak_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Y chiquicojol ri quiniman ri Jesucristo, man jun ri man ta manak nucusaj, roma ri c'o quijuyu' o cacho, yequic'ayila' y ri rajil nequiya' ");
INSERT INTO cak_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","chiquivech ri apóstoles, y rije' niquijach ri rajil chiquivech ri nic'atzin quito'ic. ");
INSERT INTO cak_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Quiri' c'a xu'on jun achi rubinan José alaxnak pa roch'ulef Chipre y riy-rumam can ri Leví. Ri José re' xyo'ox chic jun rubi' coma ri apóstoles y xqui'ij Bernabé che, roma Bernabé nu'ij tzij yo'ol ruchuk'a' cánima conojel. ");
INSERT INTO cak_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Rija' xuc'ayij jun rujuyu', y ri rajil xberujacha' pa quik'a' ri apóstoles. ");
INSERT INTO cak_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Pero c'o c'a jun achi rubinan Ananías ri junan quitzij xqui'en riq'uin ri rixayil Safira richin xquic'ayij jun quijuyu'. ");
INSERT INTO cak_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Rije' junan quitzij xqui'en chi c'o niquiq'uen can che ri rajil ri juyu', y ri más chic, ri Ananías xberuya' pa quik'a' ri apóstoles. ");
INSERT INTO cak_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pero ri Pedro xu'ij che ri Ananías: ¿Achique roma xaya' lugar chi xnoj ri Satanás pan avánima, richin xatz'uc tzij chuvech ri Lok'olaj Espíritu, y c'o xaq'uen can che rajil ri juyu' ri xac'ayij? ");
INSERT INTO cak_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Si man ta xac'ayij ri ajuyu', man jun ni'in chave chi man ta avichin. Y tok xac'ayij, pan ak'a' rat c'o-vi ronojel ri rajil. ¿Achique roma xanojij ri tz'ucun tzij re'? Rat man chiquivech ta vinak xatz'uc-vi tzij, xa chuvech ri Dios, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Tok ri Ananías xrac'axaj ri xu'ij ri Pedro, xtzak-ka pan ulef y (xcom, xquen). Y roma ri xbanataj, conojel ri xe'ac'axan jani na xquixi'ij can qui'. ");
INSERT INTO cak_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jac'ari' ec'o c'ajola' tak achi'a' xecataj-pe, xquibolkotij-e ru-cuerpo ri Ananías pa jun tziek y xebe chumukic. ");
INSERT INTO cak_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jun cami oxi' hora tibanataj quiri', jari' xoc-apu rixayil ri Ananías ri achique lugar c'o-vi ri Pedro, jac'a ri xta Safira man reteman ta achique xbanataj chiri'. ");
INSERT INTO cak_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Jac'ari' tok ri Pedro xuc'utuj che: Ta'ij chuve, ¿Kitzij chi ri ajani méra ic'amon-pe, chi quiri' xiya-vi ri juyu'? Ja', chi quiri', xcha' ri Safira. ");
INSERT INTO cak_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Y ri Pedro xu'ij che: ¿Achique roma junan itzij xi'en riq'uin ri Ananías richin xinak ruchuk'a' ri Lok'olaj Espíritu richin ri Ajaf Dios pan ivi' riq'uin ri xitz'uc tzij chuvech? Roma ri xe'emuku ri avachijil, ja ec'o chic pe chuchi' puerta richin yatuquic'ama' richin yatequimuku', xcha'. ");
INSERT INTO cak_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jac'ari' xtzak-ka ri ixok chirakan ri Pedro, y (xcom, xquen), y tok xe'oc-apu ri c'ajola' tak achi'a', xquitz'et chi xa caminak chic, jac'ari' xquelesaj-e chiri' y xbequimuku' chunakaj ri rachijil. ");
INSERT INTO cak_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y xoc c'a nimalaj (ximbiri'il, ximbiri'y) pa cánima conojel ri quiniman ri Jesucristo y pa cánima conojel ri xe'ac'axan ri xbanataj. ");
INSERT INTO cak_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Xa jun cánima quimolon-qui' conojel ri quiniman ri Jesucristo chuchi' jun corredor ri Richin Salomón chiri' pa racho ri Dios. Y q'uiy retal ruchuk'a' ri Dios y q'uiy ri man jun bey etz'eton ri yebanataj chiquik'a' ri apóstoles chiquicojol ri tinamit. ");
INSERT INTO cak_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Y ri tinamit utz yequitz'et ri quiniman ri Jesucristo, jac'a chique ri man quiniman ta, nis-ta jun nucovij-ri' chi xe nuk'ebaj-ri' chi ntoc (cachbil, cach'il). ");
INSERT INTO cak_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero k'ij-k'ij más eq'uiy yeniman ri Ajaf, chi achi'a' chi ixoki'. ");
INSERT INTO cak_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Roma c'a ri', hasta ri yeyavej ye'eleses-pe pa tak bey y yeyalo'x chuvech tak ch'at y varo'el, richin quiri' tok nik'ax ri Pedro, masque xa ja ri rumujal nik'ax pa quivi' jujun chique richin yec'achoj. ");
INSERT INTO cak_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Y ja jun ri pa tak tinamit chunakaj ri Jerusalem yepe-vi eq'uiy vinak equic'amon-pe yeyavej y ri ocunak itzel tak espíritu quiq'uin, y conojel yec'achoj-e. ");
INSERT INTO cak_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Xcataj c'a ri nimalaj sacerdote y conojel ri achi'a' saduceos ri ec'o riq'uin roma jani na itzel niquina' chique ri apóstoles. ");
INSERT INTO cak_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","(Xequitz'om, xequichop) y xequiya' pa cárcel richin ri tinamit. ");
INSERT INTO cak_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Jac'a chupan ri ak'a' ri', jun ángel richin ri Ajaf Dios xujak-e ruchi' ri cárcel chiquivech ri apóstoles. Y tok xerelesaj-e, xu'ij-e chique: ");
INSERT INTO cak_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Quixbin c'a, quixpa'e' pa racho ri Dios, y man quixtane' chutzijosic ri ch'abel richin ri c'aslen ri nuya' ri Jesucristo, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Tok ri apóstoles xquic'axaj ri xbix chique, sakar chuca'n k'ij xebe pa racho ri Dios, y yequitijoj ri ec'o chiri'. Jac'a ri nimalaj sacerdote y ri ch'aka' chic ri ec'o riq'uin, chupan ri misma hora ri', xecoyoj ri achi'a' junan niqui'en gobernar, y ri nima'k quijuna' achi'a' c'o quik'ij chiquicojol ri israelitas. Xquimol c'a qui', jac'ari' xqui'ij chi quec'amer-pe ri apóstoles ri ec'o pa cárcel. ");
INSERT INTO cak_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Jac'a ri (justusi', aj-ch'ami'y) ri xetak-e man xequil ta ri apóstoles ri pa cárcel; xetzolij c'a richin xquiya' rutzijol. ");
INSERT INTO cak_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Rije' quire' xqui'ij: Ri cárcel tz'apel utz ruchi', y ri yechajin, chuchi' ri puerta epa'el-vi. Pero tok xkajak-apu, man jun chique ri achi'a' xekil chiri', xecha'. ");
INSERT INTO cak_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Tok ri nimalaj sacerdote, y ri uc'uay quichin ri yechajin racho ri Dios, y ri nima'k tak quik'ij sacerdotes xquic'axaj ri niqui'ij ri chajinela', man niquil ta achique niqui'ij. Achique na rubeyal ronojel re', y achique na ruc'amon-pe, yecha'. ");
INSERT INTO cak_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Pero c'o c'a jun quire' rutzijol xuruya' chique: Ri achi'a' ri xe'iya' pa cárcel, ja epa'el chiquivech ri quimolon-qui' pa racho ri Dios, yequitijoj, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Jac'ari' xebe ri uc'uay quichin ri chajinel y ri (justusi', aj-ch'ami'y) richin xe'equic'ama' ri apóstoles. Pero xe relic xequiq'uen-pe, roma niquixi'ij-qui' chi yec'ak chi abaj coma ri vinak. ");
INSERT INTO cak_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Tok xequiq'uen-pe, choj xe'equipaba' chiquivech ri achi'a' junan niqui'en gobernar. Jac'a ri nimalaj sacerdote xu'ij chique ri apóstoles: ");
INSERT INTO cak_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Roj ka'in-e chive chi man chic quixtijon pa ruvi' ri (bi'aj, binaj) re'. Jac'a ri vacami xa chi jun tinamit Jerusalem inojsan che ri achok pa ruvi' yixtijon-vi, y nijo' niya' chikij roj rucamic ri achi ri nitzijoj rubi', xcha'. ");
INSERT INTO cak_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Jac'a ri Pedro y ri ch'aka' chic apóstoles quire' xqui'ij-apu: Nic'atzin ninimex na'ey ri nu'ij ri Dios que chuvech ri niqui'ij ri achi'a'. ");
INSERT INTO cak_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ri qui-Dios ri kati't-kamama', chiquicojol ri anima'i' xuc'asoj-vi-pe ri Jesús ri xicamisaj rix tok xitzekeba' chuvech jun che'. ");
INSERT INTO cak_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Y roma ja rija' Ruxe'el ronojel y Colonel, ri Dios xunimirisaj ruk'ij tok xutz'uyuba-apu pa ru-derecha, richin quiri' roma rija' roj israelitas nikajal kano'oj, nikaya' can ri mac y nkujeleses chuxe' rutojic ri kamac. ");
INSERT INTO cak_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Y roj can riq'uin kavech katz'eton-pe ronojel re nika'ij chive, y ja jun ri Lok'olaj Espíritu ri nuya' ri Dios chique ri yeniman nuk'alajrisaj chi can kitzij vi, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jac'a tok ri achi'a' junan niqui'en gobernar xquic'axaj ri xqui'ij ri apóstoles, jani na coyoval xcataj y xcajo' xequicamisaj. ");
INSERT INTO cak_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero c'o jun fariseo chiquicojol rubinan Gamaliel ri can c'o rakale'n chiquivech ri vinak, y jun tijonel pa ruvi' ri ley ri xyo'ox che ri Moisés. Rija' xpa'e', y xu'ij chi que'eleses-e juba' ri apóstoles chiri'. ");
INSERT INTO cak_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Jari' tok rija' xu'ij chique ri achi'a' ri junan niqui'en gobernar riq'uin: Nuvinak israelitas, tinojij utz-utz ri achique xti'en chique ri achi'a' re'. ");
INSERT INTO cak_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Roma c'o jun bey xc'uje' jun achi xubinaj Teudas ri xu'ij chi rija' jun achi c'o rakale'n, y c'o cami jun (caji', quiji') ciento achi'a' xetzekle'en richin. Pero tok xcamises, conojel ri xeniman rutzij xquiquiraj-qui' y xeq'uis. ");
INSERT INTO cak_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Caminak chic ri Teudas chiri', xcataj chic pe jun achi aj pa departamento Galilea xubinaj Judas chupan tak ri k'ij tok x-an ri tz'iban (bi'aj, binaj). Ja jun ri Judas re' q'uiy vinak xukasaj cánima richin xquitzekle'ej, pero tok xcamises, conojel ri xeniman rutzij, xa achique na lugar xexule-xejote-vi. ");
INSERT INTO cak_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Romari' nin-ij chive chi más utz que'iya' can ri achi'a' re', roma si ri yetajin rije' xa quino'oj vinak, xa yeq'uis. ");
INSERT INTO cak_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero si riq'uin Dios petenak-vi ri achique yetajin, man jun xquixtiquer xti'en richin xque'iq'uis. Tibana' c'a cuenta ivi', man xa tek'alajin-pe chi yixtajin chi oyoval riq'uin ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Y xquinimaj c'a rutzij ri Gamaliel. Jac'ari' xecoyoj chic ri apóstoles, y xqui'ij chi quech'ay. C'ajari' c'a xqui'ij chique chi man chic tiquitzijoj rubi' ri Jesús, y xequisok'opij c'a e. ");
INSERT INTO cak_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xe'el c'a e ri apóstoles chiquivech ri achi'a' junan niqui'en gobernar, y niquicot cánima roma ri Dios erucha'on richin niquik'asaj k'axomal roma rubi' ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","K'ij-k'ij chi tak jay y pa racho ri Dios man yetane' ta chi yequitijoj ri vinak y chi niquich'abalij ri Jesucristo. ");
INSERT INTO cak_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chupan ri tiempo ri', más yeq'uiyer ri yeniman ri Jesucristo, y ri yech'o griego yejasloj chiquij ri yech'o arameo. Ri yech'o griego niqui'ij chi ri malcani' tak ixoki' chiquicojol rije', man yeyo'ox ta pa cuenta tok nijach ri achique nic'atzin chique k'ij-k'ij. ");
INSERT INTO cak_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Roma c'a ri', ri doce apóstoles xecoyoj conojel ri quiniman, y xqui'ij chique: Man utz ta chi roj nikaya' can rutzijosic ruch'abel ri Dios xaxe roma nikajach ri achique nic'atzin k'ij-k'ij. ");
INSERT INTO cak_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Romari' que'icanoj vuku' achi'a' chi'icojol, ri k'alaj chi choj quic'aslen, y nojnak ri Lok'olaj Espíritu y utzulaj no'oj pa cánima, richin yekaya' chuvech ri samaj ri'. ");
INSERT INTO cak_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jac'a roj xtikajach-ki' chupan ri oración y chupan rutzijosic ruch'abel ri Dios, xecha' chique. ");
INSERT INTO cak_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Conojel xka chiquivech ri xqui'ij ri apóstoles, y xquicha' ri Esteban, jun achi ri can cukul ruc'u'x riq'uin ri Dios y nojnak ri Lok'olaj Espíritu pa ránima. (Chuka', ka) xequicha' ri Felipe, ri Prócoro, ri Nicanor, ri Timón, ri Parmenas y jun achi man israelita ta aj-Antioquía rubinan Nicolás, ri can nuya' ruk'ij ri kitzij Dios junan quiq'uin ri israelitas. ");
INSERT INTO cak_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ja vuku' achi'a' re' ri xec'amer-apu chiquivech ri apóstoles, y ri apóstoles xqui'en orar y xquiya' quik'a' pa quivi', retal chi jare' yepa'e' can chuvech ri samaj. ");
INSERT INTO cak_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jac'a ri ruch'abel ri Dios riq'uin ruchuk'a' benak, y jani na yeq'uiyer ri yeniman ri Jesucristo chiri' pa tinamit Jerusalem. Y ja jun ri sacerdotes israelitas, eq'uiy yeniman. ");
INSERT INTO cak_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ri Esteban nojnak ru-favor y ruchuk'a' ri Dios pa ránima yerubanala' nimalaj tak milagros ri man jun bey etz'eton y nimalaj tak retal ruchuk'a' ri Dios chiquicojol ri aj chiri'. ");
INSERT INTO cak_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jac'ari' xecataj-pe jujun vinak ri erichin jun sinagoga quichin ri man ec'o ta chic chuxe' quitzij ch'aka', ni'ix che, y jujun aj-Cirene, aj-Alejandría, aj pa roch'ulef Cilicia y aj pa roch'ulef Asia. Conojel re' niquich'olila-qui' riq'uin ri Esteban. ");
INSERT INTO cak_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Pero ri xecataj chirij, man xetiquer ta chic xquitzolij rutzij, roma ri Esteban riq'uin tz'akat no'oj nich'o-vi quiq'uin y ja ri Lok'olaj Espíritu uc'uayon richin chubixic. ");
INSERT INTO cak_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Roma c'a ri', che'elek'el xquiya' méra chique ca'i-oxi' richin tiqui'ij chi quic'axan chi ri Esteban itzel nich'o chirij ri ley ri xyo'ox che ri Moisés y chirij ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Y pa ruvi' ri', xquiya' quino'oj ri nima'k tak quijuna' achi'a' c'o quik'ij, ri achi'a' q'uiy queteman chirij ri ley, y ri vinak; jac'ari' xbequic'ama' ri Esteban, y xquic'uaj chiquivech ri achi'a' junan niqui'en gobernar. ");
INSERT INTO cak_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Chiri' xequiya-apu tz'ucuy tak tzij richin xqui'ij: Ri jun achi re' xa jumul nich'o itzel chirij ri lok'olaj lugar re' y chirij ri ley ri xyo'ox che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Roj kac'axan tok rija' ru'in chi ri Jesús aj-Nazaret (xtuvulaj, xtuvulij) ri jay re', y chi ri ruc'utun can ri Moisés, ri can kabanon-vi-pe, xquerujal-e rubeyal chikavech, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Conojel ri achi'a' junan niqui'en gobernar ri etz'uyul chiri', xbe quivech chirij ri Esteban, y xquitz'et ri (ruvech, rupalaj) chi can achel nitzu'un jun ángel. ");
INSERT INTO cak_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ri nimalaj sacerdote xuc'utuj che ri Esteban: ¿Kitzij ri niqui'ij chavij? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Jac'ari' xu'ij ri Esteban: Nuvinak israelitas ri rix tata'aj, y ri rix principal chupan ri katinamit, tivac'axaj na c'a ri nin-ij chive: Ojer can, quila' chupan ri roch'ulef Mesopotamia, ri Dios ri c'o nimalaj ruk'ij, xuc'ut-ri' chuvech ri katata' Abraham, tok ri Abraham c'a man jani tec'uje' pa tinamit Harán, ");
INSERT INTO cak_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","y xu'ij che: Catel-e vave' pan aroch'ulef y chiquicojol ri (avalpachel, avaj-c'uaxel), y cabin chupan ri roch'ulef ri xtinc'ut chavech. Quiri' xbix che ri Abraham. ");
INSERT INTO cak_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jac'ari' xel-pe chiri' chupan ri quiroch'ulef ri ruvinak ri ni'ix caldeos chique, y xbec'uje' pa tinamit Harán. Tok caminak chic rutata' ri Abraham chiri', ri Dios xuq'uen-pe ri Abraham chupan ri roch'ulef Canaán ri rixc'o-vi vacami. ");
INSERT INTO cak_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Y man jun juyu' xuya' che vave', nis-ta richin nuya-vi ri rakan. Pero xu'ij che chi c'o na jun k'ij xtuya' ri roch'ulef re' che y chique ri riy-rumam ri xque'ec'uje' chirij can rija', masque ri Abraham man jun ralc'ua'l chiri'. ");
INSERT INTO cak_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Quire' c'a xu'ij ri Dios che: Ri aviy-amam xque'ec'uje' pa jun chic roch'ulef, ri man quiroch'ulef ta, y xti'an lok'on tak samajela' chique, y xti'an chique chi niquik'asaj k'axomal (caji', quiji') ciento juna'. ");
INSERT INTO cak_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Jac'a ri vinak ri xquebano lok'on tak samajela' chique ri aviy-amam, yin xquenya' pa k'axomal. C'ajari' xque'el-pe ri aviy-amam chiri' y xque'oc nusamajela' yin chupan ri lugar re', xcha' ri Dios che ri Abraham. ");
INSERT INTO cak_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Y ri Dios xuya' rutzij che ri Abraham chi can nu'on na vi ronojel re xu'ij, y richin retal chi quiri' xecanaj chiquivech, xu'ij che ri Abraham chi tiquibana' circuncidar qui' rija' y conojel ri alabo ri xque'alex riq'uin. Romari', tok ri Abraham xalex ri ruc'ajol Isaac, vakxaki' ruk'ij chiri' xu'on circuncidar. Quiri' mismo xu'on ri Isaac che ri ruc'ajol rubinan Jacob, y quiri' mismo xu'on ri Jacob chique ri doce ruc'ajol ri xe'oc tata'aj richin ri tinamit Israel. ");
INSERT INTO cak_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Ri eruc'ajol ri Jacob, c'o jun k'ij itzel niquina' che ri José ri quichak', xecataj chirij, y xquic'ayij-e richin xc'amer-e pa roch'ulef Egipto. Jac'a ri Dios man jun bey xuya' can ri José. ");
INSERT INTO cak_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Xucol chupan ronojel k'axomal ri nuk'asaj. Xuya' utzulaj no'oj che y xu'on chi utz xtz'et roma ri Faraón ri rey pan Egipto. Ri rey xuya' ri José chi gobernador pa ruvi' ri Egipto, y xujach rupan ri racho pa ruk'a' richin nuchajij. ");
INSERT INTO cak_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ja tiempo ri', xpe vayijal y nimalaj k'axomal chiri' pan Egipto y pa roch'ulef Canaán. Y ri kati't-kamama' man niquil ta chic achique niquitij. ");
INSERT INTO cak_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Tok ri Jacob xrac'axaj chi pa roch'ulef Egipto c'o trigo, xerutak-e ri ruc'ajol ri ekati't-kamama' roj chulok'ic juba' ri trigo ri'. Jari' ri na'ey (mul, paj) xerutak-e. ");
INSERT INTO cak_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jac'a tok xerutak chic e jun bey, jari' tok ri José xuk'alajrisaj-pe-ri' chiquivech ri ruchak'-runimal. C'ajari' tok ri Faraón xretemaj quivech ri (ralpachel, raj-c'uaxel) ri José. ");
INSERT INTO cak_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ri José xu'ij c'a chi tec'amer ri Jacob ri rutata', junan quiq'uin conojel ri (ralpachel, raj-c'uaxel). E-setenta y cinco chiconojel. ");
INSERT INTO cak_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Quiri' xbanataj tok ri Jacob xxule-ka pa roch'ulef Egipto, y chiri' pan Egipto (xcom, xquen) vi rija' y ri eruc'ajol, ri ekati't-kamama' can roj israelitas. ");
INSERT INTO cak_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Y xe'uc'uax c'a pa tinamit Siquem, y xemuk pa jun lugar ri rulok'on can ri Abraham chique ralc'ua'l jun achi xubinaj Hamor chiri' pa Siquem. ");
INSERT INTO cak_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Jac'a tok nijel-pe ri tiempo chi nibanataj ri rusujun ri Dios che ri Abraham, ri achok che ruyo'on-vi rutzij chi can nu'on-vi ri rusujun, ri rutinamit ri Dios jani na yeq'uiyer chiri' pan Egipto, ");
INSERT INTO cak_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","c'a ja tok xoc chic jun rey chiri' pan Egipto ri man xretemaj ta e ruvech ri José. ");
INSERT INTO cak_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ri rey re' xno' (chubanic, cho'onic) chi itzel runo'oj xu'on chique ri kati't-kamama', roma xu'on chique chi xequipoc'a' can quiyon ri calc'ua'l ri c'a ja ye'alex, richin chi ri ac'ola' ri' (quecom, quequen), roma man xrojo' ta chi xeq'uiyer más. ");
INSERT INTO cak_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ja chupan tak ri k'ij ri' xalex ri Moisés, jun ac'ual jabel oc chuvech ri Dios, y oxi' ic' xilix pa racho ri rutata'. ");
INSERT INTO cak_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero c'o jun k'ij ja jun ri Moisés xpoq'uex can pa ruk'a' ri camic, pero xa ja ri rumi'al ri rey Faraón xilo richin, y achel ral xu'on che chi xuq'uiytisaj. ");
INSERT INTO cak_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Romari' ri Moisés xtijox riq'uin ronojel ruvech estudio quichin ri aj pa roch'ulef Egipto, y tok nich'o, ri rutzij can c'o ruchuk'a' navac'axaj, y quiri' ronojel ri yerubanala'. ");
INSERT INTO cak_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Jac'a tok ri Moisés cuarenta chic rujuna', xpe pa ránima chi xc'atzin nutz'et ri achique quibanon ri ruvinak israelitas. ");
INSERT INTO cak_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Y xutz'et c'a chi jun aj chiri' pan Egipto nik'ax ruvi' ri pokon nu'on che jun israelita, y ri Moisés richin nuto' ri ruvinak, xu'on ruq'uexel che ri aj-Egipto, xa xucamisaj. ");
INSERT INTO cak_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Rija' xunojij chi ri israelitas (xtik'ax, xtino') chiquivech chi ja rija' ri xtucusaj ri Dios richin yerucol-e pa quik'a' ri aj-Egipto, pero ri israelitas man quiri' ta xquinojij. ");
INSERT INTO cak_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chuca'n k'ij, ri Moisés xe'erila' ca'i' israelitas niqui'en oyoval chiquivech. Rija' xrojo' xerubochi'ij chi eca'i' y quire' xu'ij chique: Nuvinak, rix xa ichak'-inimal ivi'; ¿achique roma ni'en oyoval chivech? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero ri nibano pokon che ri jun chic ruvinak, xunim-e ri Moisés, y xu'ij che: ¿Achique ni'in chave chi rat uc'uay kabey y rat (c'ojoy, juez) kichin? ");
INSERT INTO cak_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O xa najo' yinacamisaj achel xa'an che ri jun aj-Egipto ivir? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Tok ri Moisés xrac'axaj quiri', xenimaj-e, xc'uje' pa jun roch'ulef rubinan Madián chiquicojol vinak man israelitas ta, y chiri' rija' xec'uje' ca'i' ruc'ajol. ");
INSERT INTO cak_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Cuarenta juna' tic'uje' ri Moisés chiri' pa Madián, tok xuc'ut-ri' jun ángel chuvech chupan jun mata (xulu-quiej, zarza) nijino pa k'ak' chiri' chupan ri chakijlaj tz'iran ulef ri c'o-vi ri juyu' Sinaí. ");
INSERT INTO cak_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tok ri Moisés xutz'et ri k'ak' nic'at, achique na xuna', y richin nutz'et utz-utz, xjel-apu más riq'uin, y jari' xch'o-pe ri Ajaf che, y xu'ij: ");
INSERT INTO cak_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Ja yin ru-Dios ri Abraham, ru-Dios ri Isaac y ru-Dios ri Jacob ri ojer tak avati't-amama', xcha'. Y ri Moisés nibarbot man xu'on ta chic ámna xtzu'un-apu. ");
INSERT INTO cak_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Jac'a ri Ajaf xu'ij-pe che: Tavelesaj la axajab chi'avakan, roma lok'olaj rubanon ri ulef ri rat pa'el-vi. ");
INSERT INTO cak_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yin nutz'eton ri k'axomal ri niquik'asaj ri nutinamit pa roch'ulef Egipto, y ninvac'axaj ri cok'ej. Roma c'a ri', xika-pe richin yencol. Vacami tabana' abanic richin yatintak-e pan Egipto, xcha' che ri Moisés. ");
INSERT INTO cak_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Ja Moisés re' ri man jun rakale'n xqui'en ri kavinak, tok xqui'ij che: ¿Achique ni'in chave chi rat uc'uay bey y rat juez? xecha' che. Pero ja rija' ri xutak ri Dios richin nuc'uan quibey y yerucol-e pa quik'a' ri aj-Egipto riq'uin ruk'a' ri ángel ri xuc'ut-ri' chuvech chupan ri (xulu-quiej, zarza). ");
INSERT INTO cak_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ja Moisés re' xelesan-pe quichin ri kati't-kamama' pa roch'ulef Egipto ri xerubanala-vi ri man jun bey etz'eton y retal ruchuk'a' ri Dios. Quiri' mismo xerubanala' pa Mar Rojo, y pa chakijlaj tz'iran ulef chupan cuarenta juna'. ");
INSERT INTO cak_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ja mismo ri Moisés ri quire' x-in chique ri kavinak ri tiempo ri': Ri Kajaf Dios xtuyec chic jun profeta chi'icojol rix mismo achel xu'on chuve yin, y rix xtiya' ixiquin riq'uin ronojel ri xtu'ij chive. Quiri' ru'in can ri Moisés. ");
INSERT INTO cak_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Y ja Moisés re' ri xc'uje' chiquicojol ri rutinamit ri Dios pa chakijlaj tz'iran ulef. Che rija' xbix-vi roma ri ángel pa ruvi' ri juyu' Sinaí chi tuk'asaj ri ch'abel chique ri kati't-kamama', y che rija' mismo xjach-vi ch'abel richin c'aslen richin tuya' chike. ");
INSERT INTO cak_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Jac'a ri kati't-kamama' man xcajo' ta xquinimaj ri xu'ij ri Moisés, xa xquiya-e juc'an, y ri cánima xa xtzolij chic pa roch'ulef Egipto. ");
INSERT INTO cak_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Roma c'a ri', quire' xqui'ij che ri Aarón: Que'abana' ka-dios richin jari' ye'uc'uan kichin. Roma ri Moisés ri xojelesan-pe pan Egipto, achique na xbanataj riq'uin, xecha'. ");
INSERT INTO cak_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Chupan tak ri k'ij ri', xqui'en ruvachibel jun alaj váquix, y xequicamisaj chicop chuvech richin niquiya' ruk'ij. Can xel cánima chirij ri xa ja rije' xebano-ka. ");
INSERT INTO cak_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Jac'a ri Dios xeruya' can, xerosk'opij richin xquiya' quik'ij ronojel ri yetz'etetaj chuvech ri rocaj, achel ri ch'umila', ri ic' y ri k'ij. Achel nu'ij chupan ri vuj ri quitz'iban can ri profetas, tok ri Dios quire' xu'ij: Rix israelitas, ¿chinuvech cami yin xe'isuj-vi ri chicop ri xe'icamisaj Chupan ri cuarenta juna' pa chakijlaj tz'iran ulef? Man chinuvech ta yin. ");
INSERT INTO cak_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pa ruq'uexel chi xiya' nuk'ij, xa xitelelej racho ri dios Moloc, Quiri' mismo xi'en riq'uin ri ch'umil richin ri i-dios Renfán, Ronojel re', xa rix mismo xixbano-ka, richin xiya' quik'ij. Roma c'a ri', yin xtin-en chive chi xquixec'uje' más quila' che ri roch'ulef Babilonia. Quiri' nu'ij ruch'abel ri Dios ri quitz'iban can ri profetas. ");
INSERT INTO cak_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ri ojer tak kati't-kamama', tok xebin pa chakijlaj tz'iran ulef, quic'uan ri racho ri Dios ri banon che tz'un ri achok chupan yaquel-vi ri tz'ajtz'ak tak abaj ri tz'iban-vi ri ru-ley ri Dios. Ri jay ri', tzak ja achel xuc'ut ri Dios chuvech ri Moisés, quiri' banon che. ");
INSERT INTO cak_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ri jay ri' pa quik'a' ri jun chic solaj kavinak xyo'ox-vi can. Rije' xquiq'uen-pe chupan re roch'ulef quichin man israelitas ta, tok ja ri Josué uc'uayon-pe quibey. Pero ja mismo ri Dios xe'elesan ri man israelitas ta pa quibey, y ri racho ri Dios ri quic'amon-pe tok xe'uka, c'a xcuses na pa ru-tiempo ri rey David ");
INSERT INTO cak_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ri xc'ulu ru-favor ri Dios pa ruc'aslen y xuc'utuj che chi nrojo' nu'on jun jay richin ri Dios ri ru-Dios ri Jacob. ");
INSERT INTO cak_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero xa c'a ja ri Salomón xbano ri racho ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Masque ri nimalaj Dios ri c'o pa ruvi' ronojel, man nic'uje' ta chupan jay banon coma aj-roch'ulef, achel nu'ij chupan ruch'abel ri Dios ri rutz'iban can ri profeta ri nu'ij: ");
INSERT INTO cak_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ja ri caj ri nutz'uyubal, Y ja pa ruvi' ri roch'ulef nuyo'on-vi ri vakan. ¿Achique c'a chi jay ri ni'en chuve? nicha' ri Ajaf. ¿Y achique c'a lugar c'o-vi ri jay richin yinuxlan chupan? ");
INSERT INTO cak_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Tuka chi'ic'u'x chi ja yin ri yin banayon ronojel. Quiri' rutz'iban can ru-profeta ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Jac'a rix xa cof rij-ivi' richin niya' ruk'ij ri Dios, man ijakon ta ri ivánima chuvech, achel xa tz'apel ri ixiquin, man jun bey nika chivech, ni man niya' ta lugar chi ja ri Lok'olaj Espíritu nuc'uan ivichin, xa rix junan quiq'uin ri ojer tak ivati't-imama'. ");
INSERT INTO cak_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Roma rije' man jun chique ri profetas ri man ta xequiya' pa k'axomal, y xequicamisaj ri xeyo'on rutzijol chi xtipe na Jun ri can choj. Y vacami ri xuka ri Jun ri', xa ja rix xixjacho-e pa quik'a' ri itzel yetz'eto richin, y xic'utuj chi ticamises. ");
INSERT INTO cak_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Chive rix xyo'ox-vi ri ley ri quic'amon-pe ri ángeles, pero rix man xinimaj ta, xcha' ri Esteban. ");
INSERT INTO cak_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jac'a tok xquic'axaj ri tzij re', man juba' ta oc coyoval xcataj, y niquijach'ach'ela' (roquey, quey) chirij. ");
INSERT INTO cak_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Jac'a ri Esteban nojnak ri Lok'olaj Espíritu pa ránima, xtzu'un c'a e chicaj, y xtiquer xutz'et ri lugar c'o-vi ri Dios, y xutz'et chi pa ru-derecha ri Dios pa'el-vi ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Y xu'ij c'a: Yin nintz'et chi la caj jakal y nintz'et ri Jesús ri xu'alex-ka chikacojol chi pa'el-apu pa ru-derecha ri Dios, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Jac'a richin man niquic'axaj más ri nu'ij ri Esteban, xquitz'apila' quixiquin, yesiq'uin junan xebe chirij. ");
INSERT INTO cak_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xquelesaj-e chuchi' ri tinamit, y chiri' (xquitz'om, xquichop) ruc'akic che abaj. Ri xetz'ucun tzij chirij ri Esteban xquich'ilila-e jujun quitziak chiquij y xquisovila' can chirakan jun ala' rubinan Saulo. ");
INSERT INTO cak_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tok yetajin chuc'akic che abaj, ri Esteban xusiq'uij ri Ajaf y xu'ij: Ajaf Jesús, tac'ulu' ri vánima, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Xxuque' c'a ka, y riq'uin ruchuk'a' xu'ij: Vajaf, man ta'an chi nika rajil ri mac re' pa quivi', xcha'. Tok ru'in chic quiri', (xcom, xquen). ");
INSERT INTO cak_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri Saulo xka chuvech chi xcamises ri Esteban. Y ri quiniman ri Jesucristo chiri' pa tinamit Jerusalem, ja k'ij ri' xtiquer chi ni'an pokon chique, y xquiquiraj-e-qui' pa tak tinamit richin ri departamento Judea y richin ri departamento Samaria. Xaxe chic ri apóstoles xec'uje' can ri pa Jerusalem. ");
INSERT INTO cak_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ec'o c'a achi'a' eyo'ol ruk'ij ri Dios ri xquic'uaj ru-cuerpo ri Esteban richin xquimuk y jani na xcok'ej roma ri x-an che. ");
INSERT INTO cak_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jac'a ri Saulo juye' quivech nu'on ri quiniman ri Jesucristo. Rija' hasta ntoc chi tak tak jay y chi achi'a' chi ixoki' yerujirirej-pe pan ulef y yerujach richin quetz'apis pa tak cárcel. ");
INSERT INTO cak_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jac'a ri quiniman ri Jesucristo ri xquiquiraj-e-qui', xa achique na lugar yek'ax-vi, niquitzijoj can ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak. ");
INSERT INTO cak_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Jun chique ri xquiquiraj-e-qui' ja ri Felipe. Rija' xxule-ka pa jun tinamit richin ri Samaria, y chiri' nutzijoj ri Jesucristo chique ri vinak. ");
INSERT INTO cak_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Ri aj-Samaria xa jun cánima niquiya' quixiquin che ri nu'ij ri Felipe riq'uin niquitz'et ri milagros ri yerubanala' chiquivech. ");
INSERT INTO cak_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Roma eq'uiy vinak ri ocunak itzel tak espíritu quiq'uin, yesiq'uin ye'el-e ri itzel tak espíritu re'. Eq'uiy ri caminak quik'a-cakan y eq'uiy ri man utz ta cakan ri xec'achoj. ");
INSERT INTO cak_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Romari' jani na yequicot ri ec'o chupan ri tinamit ri'. ");
INSERT INTO cak_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Pero c'o c'a jun achi aj-k'ij rubinan Simón nik'ijun chiri' pa tinamit rubanon can, y rubanon chique ri vinak pa departamento Samaria chi ekajnak pa ruk'a' roma ruk'eban-ri' chi rija' can c'o ruk'ij. ");
INSERT INTO cak_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chi ch'uti'k chi nima'k niquiya' quixiquin che ri nu'ij ri aj-k'ij re' y niqui'ij chi c'o ruchuk'a' ri nimalaj Dios riq'uin. ");
INSERT INTO cak_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Can niquiya' quixiquin riq'uin ri yeru'ij roma riq'uin ri nik'ijun chiquivech, rubanon chique chi ekajnak pa ruk'a' q'uiy tiempo. ");
INSERT INTO cak_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero tok xquic'axaj ri utzulaj ch'abel ri nu'ij ri achique ruchojmil ye'oc pa ruk'a' ri Dios richin yeru'on gobernar y ri rubi' ri Jesucristo, ri vinak xquinimaj, y chi achi'a' chi ixoki' xe'an bautizar. ");
INSERT INTO cak_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ja jun ri Simón ri aj-k'ij xunimaj ruch'abel ri Dios y xu'on bautizar ri'. Jumul rutzekle'en ri Felipe, y can ntel ránima yerutz'et ri nimalaj tak retal y milagros ri yebanataj. ");
INSERT INTO cak_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jac'a tok ri apóstoles ri ec'o can pa tinamit Jerusalem xquic'axaj chi ri aj pa departamento Samaria niquinimaj ruch'abel ri Dios, rije' xequitak-ka ri Pedro y ri Juan quiq'uin. ");
INSERT INTO cak_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Tok xe'eka ri etakon-ka, xqui'en orar pa quivi' ri xeniman chiri' pa Samaria, richin chi niquic'ul ri Lok'olaj Espíritu pa cánima. ");
INSERT INTO cak_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Roma man jun chique ri kajnak-pe ri Lok'olaj Espíritu pa ruvi', xaxe ebanon bautizar pa rubi' ri Ajaf Jesús. ");
INSERT INTO cak_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Jac'ari' ri Pedro y ri Juan xquiya' quik'a' pa quivi', y xquic'ul ri Lok'olaj Espíritu pa cánima. ");
INSERT INTO cak_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Pero ri Simón ri aj-k'ij, tok xutz'et chi ri xeniman pa Samaria niquic'ul ri Lok'olaj Espíritu pa cánima tok ri apóstoles niquiya' quik'a' pa quivi', rija' xusuj méra chique ri apóstoles, ");
INSERT INTO cak_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","y xu'ij chique: Tiya' chuve ri uchuk'a' ri achel c'o iviq'uin rix, richin quiri' tok yin ninya' nuk'a' pa ruvi' xa achique na vinak, can xtuc'ul ri Lok'olaj Espíritu pa ránima, xcha' chique. ");
INSERT INTO cak_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Jac'a ri Pedro xu'ij che ri Simón: Ri améra y rat chi junan xquixq'uis pa k'ak', roma rat nanojij chi riq'uin méra nalok'-vi ri rusipanic ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Rat manak ak'a' che ri samaj re', roma ri avánima xa man choj ta chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Rat nic'atzin najal ano'oj y naya' can ri itzel no'oj re c'o pan avánima, y tac'utuj aquemelal che ri Dios; riq'uin juba' rija' xcaru'on perdonar riq'uin ri nanojij. ");
INSERT INTO cak_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Roma yin nintz'et chi q'uey-q'uey ri avánima roma yakukut, y c'a rat ximil na pa ruk'a' itzel tak no'oj, xcha' ri Pedro. ");
INSERT INTO cak_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Quire' c'a rutzolic quitzij xu'on ri Simón: Tibana' favor, tic'utuj iquemelal che ri Ajaf voma yin, richin quiri' man ta nipe pa nuvi' ri achel xi'ij-ka. ");
INSERT INTO cak_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jac'a tok quik'alajrisan chic can ruch'abel ri Dios chiri' pa departamento Samaria, xetzolij pa tinamit Jerusalem. Y ronojel tak aldeas ri yek'ax-vi, niquitzijoj can ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak. ");
INSERT INTO cak_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","C'o c'a jun ángel richin ri Ajaf Dios xch'o riq'uin ri Felipe, y xu'ij che: Vacami tabana-e abanic, y cabin quire' pa sur, c'a na'avila' na ri bey ri ntel-e pa tinamit Jerusalem ri ni'e-ka pa tinamit Gaza, jun bey ri manak utz vinak yek'ax chuvech. ");
INSERT INTO cak_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Jac'ari' xcataj-e ri Felipe y xbe chupan ri bey ri xbix-e che, y tu'on, ja yan chic ri' petenak chupan ri bey jun achi eunuco, gobernador pa ruvi' ronojel rubeyomal ri ixok rubinan Candace, reina pa quivi' ri aj pa roch'ulef Etiopía. Ri achi eunuco xpe pa Jerusalem richin xuruya' ruk'ij ri Dios, ");
INSERT INTO cak_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","y ja benak richin nitzolij pa roch'ulef Etiopía, tz'uyul-e pa ru-carruaje, nu'on leer ri vuj rutz'iban can ri profeta Isaías benak. ");
INSERT INTO cak_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Jac'ari' tok ri Lok'olaj Espíritu xu'ij che ri Felipe: Ta'avila' ri carruaje y cajel-apu chunakaj. ");
INSERT INTO cak_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Xjel c'a apu ri Felipe chunakaj ri carruaje, y xrac'axaj chi ri eunuco nu'on leer ri vuj ri rutz'iban can ri profeta Isaías. Ri Felipe xuc'utuj-apu che: ¿(Nik'ax, nino') chavech ri na'an leer? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Jac'a ri eunuco xu'ij-pe: ¿Achel (xtik'ax, xtino') chinuvech si man jun ni'in ruchojmil chuve? xcha'. Jac'ari' xuc'utuj favor che ri Felipe chi tijote-e ri pa carruaje, y titz'uye-e riq'uin. ");
INSERT INTO cak_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ri ruch'abel ri Dios ri nu'on leer ri eunuco benak, ja ri nu'ij: Achel jun oveja xuc'uax richin necamises. Y achel jun alaj oveja tok nisoques rij, man nisiq'uin ta, Rija' man jun ch'abel xu'ij. ");
INSERT INTO cak_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Y quiri' kasan ruk'ij, man pa ruchojmil ta xk'at castigo pa ruvi'. ¿Achique ta jun xtitzijon ri achique quino'oj ri vinak ri xec'uje' ri tiempo ri'? Roma rija' xa xc'ojpix-e ri ruc'aslen vave' choch'ulef. Jari' nu'on leer ri eunuco benak. ");
INSERT INTO cak_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Quire' c'a xu'ij ri eunuco che ri Felipe: Tabana' favor, ta'ij chuve: ¿Achok chirij nich'o-vi ri profeta re'? ¿Chirij cami rija' mismo, o xa chirij chic jun? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Jac'ari' tok ri Felipe riq'uin ri mismo versículo ri rutz'iban can ri Isaías xutz'uc-vi-apu rubixic ri utzulaj ch'abel richin ri Jesús ri nu'ij achique ruchojmil nicolotaj jun vinak. ");
INSERT INTO cak_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Quiri' ebenak chupan ri bey, xquil jun ya', y ri eunuco xu'ij che ri Felipe: Tatz'eta' la ya'. ¿La c'o cami jun roma chi yin man yi'an ta bautizar? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Y ri Felipe xu'ij che: Si riq'uin ronojel avánima nanimaj, utz ya'an bautizar, xcha'. Ri eunuco xu'ij: Yin ninnimaj chi ri Jesucristo jari' ri Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Jac'ari' xu'ij chi tipa'e' ri carruaje. Xeka c'a ka ri eca'i' chupan ri ya', y ri Felipe xu'on bautizar ri achi. ");
INSERT INTO cak_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jac'a tok xe'el-pe ri pa ya', ri Felipe xc'amer-e chiri' roma ri Lok'olaj Espíritu richin ri Ajaf Dios. Y ri eunuco man chic xutz'et ta, xa niquicot ránima xbe chupan ri rubey. ");
INSERT INTO cak_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Jac'a ri Felipe pa jun yan chic tinamit rubinan Azoto xepapo-vi. Y ronojel tinamit ri nik'ax-vi, nutzijoj can ri utzulaj ch'abel ri nu'ij achique ruchojmil yecolotaj ri vinak. Quiri' nubanala' benak c'a (xapon, xebos) na pa tinamit Cesarea. ");
INSERT INTO cak_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Jac'a ri Saulo c'a quiri' pa royoval nubila' chiquij ri quiniman ri Ajaf Jesús chi can nurayij quicamic. Romari' xbe riq'uin ri nimalaj sacerdote israelita, ");
INSERT INTO cak_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","richin xuc'utuj chi ti'an-e vuj chuk'a' ri nu'ij-vi chi rija' c'o ruk'a' chi ntoc pa tak sinagoga ri pa tinamit Damasco richin yerucanoj y yerelesaj-pe xa achique na achi o ixok ri xa ja ri Bey ri ruc'utun can ri Jesús ri quitzekle'en, y yeruq'uen-pe richin yeyo'ox pa cárcel pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Jac'a tok benak chupan ri bey richin ni'e pa Damasco, y xa nakaj chic c'o-vi-apu che ri tinamit chiri', c'ate nuna', xrepero' xe tak ruxiquin jun sakil petenak chicaj. ");
INSERT INTO cak_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ri Saulo xtzak pan ulef, y xrac'axaj jun kulaj ri nich'o-pe che, y nu'ij: Saulo, Saulo, ¿achique roma najo' na'an pokon chuve? xcha'. ");
INSERT INTO cak_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Jac'a ri Saulo xu'ij: ¿(Achique, aratcu'x) c'a rat, Ajaf? Y ri nich'o-pe, xu'ij: Ja yin ri Jesús ri najo' na'an pokon chuve, pero xa c'ayef chave, roma xa ayon naya-avi' chutza'n jun che' bak rutza'n riq'uin ri yatajin, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ri Saulo ruxi'in-ri' y nibarbot xu'ij: Ajaf, ¿achique c'a ri najo' chi nin-en? Y ri Ajaf Jesús xu'ij-pe che: Cacataj, cabin-apu pa tinamit, y chiri' xti'ix-vi chave ri achique utz chi na'an, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Jac'a ri achi'a' ri ebenak riq'uin, xepa'e-ka, y xenacano', roma niquic'axaj chi c'o jun nich'o-pe riq'uin ri Saulo, pero man jun achique niquitz'et. ");
INSERT INTO cak_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Xusic' c'a ri' ri Saulo pan ulef, y masque erujakon ri runak'-ruvech, pero xa man nitzu'un ta. Romari' xyukex-e chuk'a' richin xc'amer-e pa Damasco. ");
INSERT INTO cak_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Oxi' k'ij man xtzu'un ta; man jun achique xutij, nis-ta xukum. ");
INSERT INTO cak_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Jac'a ri chiri' pa Damasco c'o jun achi runiman ri Jesucristo rubinan Ananías. Ri Ajaf pa jun achel achic' quire' xu'ij che: ¡Ananías! xcha'. Y ri Ananías xu'ij: Ja ri yinc'o vave', Ajaf, xcha'. ");
INSERT INTO cak_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ri Ajaf xu'ij che: Ninjo' chi yacataj-e richin yabe chiracho ri Judas. Ri bey ri nac'uaj ja ri ni'ix Choj che, y chiri' chiracho ri Judas tac'utuj-vi jun achi aj-Tarso rubinan Saulo, roma rija' ja najin riq'uin oración. ");
INSERT INTO cak_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Rija' pa jun achel achic' rutz'eton chi c'o jun achi rubinan Ananías xoc-apu ri pa jay riq'uin, y xuya' ruk'a' pa ruvi' richin nitzu'un chic jun bey, xcha' ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jac'a ri Ananías xu'ij: Ajaf, eq'uiy ebiyon chuve chi ri achi Saulo jani na jun pokon rubanon chique ri e'acha'on chic rat ri ec'o pa Jerusalem. ");
INSERT INTO cak_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y ri vave' pa Damasco, rija' c'o ruk'a' chi yeruxim-e ri ye'in chi e'avichin chic rat, Ajaf, roma ja ri nima'k tak quik'ij sacerdotes ebanayon-pe vuj chuk'a' ri quiri' nu'ij, xcha' ri Ananías. ");
INSERT INTO cak_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Pero ri Ajaf Jesucristo xu'ij che: Ta'acanoj, roma ri Saulo nucha'on chic richin nutzijoj ri nubi' yin chiquivech ri man israelitas ta, chiquivech reyes y chiquivech ri israelitas. ");
INSERT INTO cak_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Y yin xtinc'ut chuvech ri ajani chi k'axomal nic'atzin chi xteruk'asaj roma ri nubi', xcha' ri Ajaf. ");
INSERT INTO cak_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Jac'ari' xbe ri Ananías, xoc-apu ri pa jay ri c'o-vi ri Saulo. Tok ruyo'on ruk'a' pa ruvi' chiri', xu'ij che: Vach'alal Saulo, ri Ajaf Jesús ri xuc'ut-ri' chavech tok rat petenak pa bey, xirutak-pe aviq'uin richin yatzu'un chic jun bey, y richin ninoj ri Lok'olaj Espíritu pan avánima, xcha' ri Ananías. ");
INSERT INTO cak_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Can xe xbix quiri', jari' xetzak-e achel rusolotal quer pa tak runak'-ruvech ri Saulo, y xtiquer chic xtzu'un. Xcataj c'a e y x-an bautizar. ");
INSERT INTO cak_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Y tok xva', xc'uje' chic pe ruchuk'a'. Ri Saulo xc'uje' jun tiempo quiq'uin ri quiniman ri Jesucristo chiri' pa tinamit Damasco. ");
INSERT INTO cak_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Y ja yan nutzijoj ri pa tak sinagogas chi ri Jesucristo jari' ri Ruc'ajol ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Y conojel ri ye'ac'axan richin, man niquil ta achique niquinojij y quire' niquibila': ¿Mana-ta ri achi re' ri juye' quivech nu'on ri ye'in chi erichin ri Jesús ri ec'o pa tinamit Jerusalem? Y, ¿man ta cami richin yeruxim-e ri ye'in chi erichin ri (bi'aj, binaj) ri', richin ye'eruya' pa quik'a' ri nima'k tak quik'ij sacerdotes israelitas, tok xuka vave' pa Damasco? yecha'. ");
INSERT INTO cak_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Jac'a ri Saulo más xuc'ul uchuk'a', y jabel rucusasic nu'on ri tz'iban can richin nuk'alajrisaj chi ri Jesús jari' ri Jun ri takon-pe roma ri Dios chucolic ri rutinamit. Y riq'uin ri nuk'alajrisaj, xa más nusuk' quino'oj ri israelitas ri ec'o chiri' pa Damasco. ");
INSERT INTO cak_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","C'o chic chi k'ij tic'uje' ri Saulo chiri' pa Damasco, tok ri israelitas quimolon-qui' xecanaj chiquivech achique niqui'en richin niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jac'a ri nojin chirij ri Saulo xyo'ox rutzijol che, y ri nicajo' yecamisan richin, chi chak'a' chi pak'ij quik'ele'en chuchi' tak ri puertas ri ye'el-ye'oc-vi ri vinak pa tinamit. ");
INSERT INTO cak_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Jac'a ri quiniman chic ri Jesús, chak'a' xquelesaj-e ri Saulo chirij ri muro ri tz'apiyon rij ri tinamit. Chupan jun chaquech xquikasaj-vi-ka richin xquelesaj-e. ");
INSERT INTO cak_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Tok ri Saulo (xapon, xebos) pa tinamit Jerusalem, xrojo' xc'uje' chiquicojol ri quiniman ri Jesús chiri', pero conojel niquixi'ij-qui' chuvech, roma man niquinimaj ta chi kitzij xunimaj yan ri Jesús. ");
INSERT INTO cak_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero ri Bernabé xuc'uaj ri Saulo, xberuc'utu' chiquivech ri apóstoles, y xutzijoj chique chi ri Ajaf xuc'ut-ri' chuvech ri Saulo y xch'o riq'uin pa rubey ri tinamit Damasco, y chi ri Saulo man xuxi'ij ta ri' xutzijoj ri Ajaf Jesús chiri' pa Damasco. ");
INSERT INTO cak_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","C'ajari' xquic'ul ruvech ri Saulo; junan c'a ntel-ntoc quiq'uin ri pa tinamit Jerusalem. ");
INSERT INTO cak_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Rija' man nuxi'ij ta ri' nitzijon pa rubi' ri Ajaf y hasta nuch'olila-ri' quiq'uin ri israelitas ri yech'o griego, jac'a rije' xa niquicanola' achique niqui'en richin nicajo' niquicamisaj. ");
INSERT INTO cak_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Tok ri quiniman ri Jesucristo xquina'ej ri ninojix chirij ri Saulo, xquiq'uen-ka pa tinamit Cesarea, y xquitak-e pa jun chic tinamit rubinan Tarso. ");
INSERT INTO cak_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Jac'a ri quiniman ri niquimol-qui' richin niquiya' ruk'ij ri Jesucristo pa jalajoj tak lugares quichin ri oxi' departamento quibinan Judea, Galilea y Samaria, man ni'an ta chic pokon chique. Riq'uin niquichajij ri quic'aslen chuvech ri Ajaf, can niq'uiy ri quic'aslen chirakan, y riq'uin niquic'ul cuchuk'a' riq'uin ri Lok'olaj Espíritu, yeq'uiyer. ");
INSERT INTO cak_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ri Pedro jalajoj ni'e-vi chiquitz'etic conojel ri quiniman ri Jesucristo, y ja jun ri ec'o pa tinamit Lida xe'erutz'eta-ka. ");
INSERT INTO cak_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chiri' xril jun achi rubinan Eneas ri ja vakxaki' juna' kajnak chuvech ruvaro'el, roma caminak ruk'a-rakan. ");
INSERT INTO cak_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ri Pedro xu'ij che: Ri Jesucristo nu'on chave chi yac'achoj. Cacataj c'a, tanuc'u' la avaro'el, xcha' che. Y ri Eneas can jac'ari' xpa'e'. ");
INSERT INTO cak_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Conojel ri ec'o pa Lida y pa Sarón xquitz'et chi ri Eneas xc'achoj, romari' xquijal quino'oj y xquinimaj ri Ajaf Jesús. ");
INSERT INTO cak_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chiri' pa tinamit Jope c'o jun ixok runiman ri Jesús rubinan Tabita, y pa ch'abel griego ni'ix Dorcas che. Ri ixok re' banoy jalajoj tak favores y can yeruto' ri man jun oc achique quichajin. ");
INSERT INTO cak_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Jac'a chupan tak ri k'ij ri', ri Dorcas xyavej y (xcom, xquen). Tok atinisan chic, xjoto'ex-e pa ruca'n piso che ri jay. ");
INSERT INTO cak_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ri tinamit Jope man naj ta quicojol riq'uin ri tinamit Lida, romari' ri quiniman ri Jesucristo, tok xquic'axaj chi ri Pedro c'o chiri' pa Lida, xequitak-e ca'i' achi'a' riq'uin richin xquic'utuj quemelal che chi tipe cha'anin pa Jope. ");
INSERT INTO cak_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Xu'on-pe rubanic ri Pedro richin xpe quiq'uin ri etakon-e, y tok xe'eka, xquiq'uen-e ri achique lugar c'o-vi ri ámna. Xquimol c'a apu qui' ri malcani' tak ixoki' chirij ri Pedro y niquic'utula-apu chuvech ri quitziak ri xerubanala' ri Dorcas chique tok c'a q'ues na. ");
INSERT INTO cak_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Jac'a ri Pedro xerelesaj-pe conojel ri pa jay, c'ajari' xxuque' richin nu'on orar. Xtzu'un c'a apu riq'uin ri ámna, y xu'ij: Tabita, cacataj. Ri ixok jari' xtzu'un-pe, y tok xutz'et-pe ri Pedro, xtz'uye'. ");
INSERT INTO cak_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ri Pedro (xutz'om, xuchop) c'a chiruk'a' ri ixok richin xpa'e', y xeroyoj c'a ri malcani' tak ixoki' y ri echa'on roma ri Dios, y q'ues yan chic ri Dorcas xuc'ut chiquivech. ");
INSERT INTO cak_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ri xbanataj chiri' xbe rutzijol chupan ronojel ri tinamit Jope, y romari' q'uiy xeniman ri Ajaf Jesús. ");
INSERT INTO cak_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Jac'a ri Pedro c'a xc'uje' na q'uiy k'ij chiri' chiracho jun achi rubinan Simón ri nitzaco quitz'umal chicop. ");
INSERT INTO cak_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pa tinamit Cesarea c'o jun uc'uay quichin soldados rubinan Cornelio ri c'o pa quivi' cien soldados ri aj-Italia ni'ix chique. ");
INSERT INTO cak_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rija' jun yo'ol ruk'ij ri Dios y ruchajin ruc'aslen chuvech, junan quiq'uin ri ec'o riq'uin pa racho, y can yeruto' ri man jun oc achique quichajin y k'ij-k'ij nu'on orar. ");
INSERT INTO cak_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Pa jun achel achic' richin cami las tres xk'ak'ij, rija' jabel xutz'et chi xoc-apu jun ángel richin ri Dios riq'uin, ri quire' xu'ij che: ¡Cornelio! xcha'. ");
INSERT INTO cak_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jac'a rija' can nutz'et-apu utz-utz ruvech ri ángel, y ruxi'in-ri' xu'ij che: ¿Achique ri', Ajaf? xcha'. Y ri ángel xu'ij: Ri a-oraciones y ri quito'ic abanon ri man jun oc quichajin, jun utzulaj c'uxle'el avichin chuvech ri Dios. ");
INSERT INTO cak_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Vacami c'a, que'ataka-e achi'a' pa tinamit Jope richin necoyoj jun achi rubinan Simón, ri ni'ix Pedro che. ");
INSERT INTO cak_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Rija' roxkonen-ri' pa racho jun achi mismo Simón rubi' tzacoy quitz'umal chicop, y c'o racho chunakaj ri mar. Ri Pedro re' xturu'ij chave ri achique nic'atzin chi na'an, xcha' ri ángel. ");
INSERT INTO cak_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Tok benak chic ri ángel ri xch'o riq'uin, ri Cornelio xeroyoj ca'i' rusamajela', y jun soldado yo'ol ruk'ij ri Dios ri jumul ec'o riq'uin ri Cornelio richin niqui'en ri rusamaj, ");
INSERT INTO cak_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","y tok ru'in chic e ronojel rubeyal chique ri xbix can che, xerutak-e pa tinamit Jope. ");
INSERT INTO cak_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chuca'n k'ij, ri oxi' achi'a' etakon-e roma ri Co