﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakYNT_vpl;
CREATE TABLE cakYNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakYNT_vpl WRITE;
INSERT INTO cakYNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Re jun libro re nitiquir-a vova', jun libro re anche' tz'iban-va can re quibe' re rate't-rumoma' re Jesucristo. Can k'alaj che reja' rey-rumam can re Rey David, y rey-rumam can chuka' re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ja re Abraham jare' re rutota' re Isaac; re Isaac jare' re rutota' re Jacob; re Jacob jare' re rutota' re Judá y chuka' re nic'aj chic ruch'alal re Judá. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Y re Judá jare' re quirta' re Fares y re Zara, y re quite' re je ca'e' ac'ola' re' ja re ixok xubini'aj Tamar; y re Fares jare' re rutota' re Esrom; y re Esrom jare' re rutota' re Aram. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y re Aram jare' re rutota' re Aminadab; re Aminadab jare' re rutota' re Naasón; y re Naasón jare' re rutota' re Salmón. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y re Salmón xoc ruchijil re ixok xubini'aj Rahab, y re Rahab y re Salmón xc'ue' jun cajc'ual xubini'aj Booz; y re Booz xoc ruchijil re ixok xubini'aj Rut, y reje' xc'ue' jun cajc'ual xubini'aj Obed; y re Obed jare' re rutota' re Isaí. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y re Isaí jare' re rutota' re Rey David; y re Rey David jare' re rutota' re Salomón, y re rute' re Salomón ja re ixok xubini'aj Betsabé re ruxayil can re Urías. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Re Salomón jare' re rutota' re Roboam; re Roboam jare' re rutota' re Abías; y re Abías jare' re rutota' re Asa. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y re Asa jare' re rutota' re Josafat; re Josafat jare' re rutota' re Joram; y re Joram jare' re rutota' re Uzías. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y re Uzías jare' re rutota' re Jotam; re Jotam jare' re rutota' re Acaz; y re Acaz jare' re rutota' re Ezequías. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y re Ezequías jare' re rutota' re Manasés; re Manasés jare' re rutota' re Amón; y re Amón jare' re rutota' re Josías. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y re Josías jare' re rutota' re Jeconías y quirta' chuka' re nic'aj chic ruch'alal re Jeconías. Y ja chupan re tiempo re' tak re kavinak yoj re yoj israelitas re xe'c'ue' ajuer can, xban chique che xe'bec'ue' chupan re nación Babilonia, roma xe'ch'acataj pa quik'a' re ejército chin re Babilonia. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y tak jec'o chic pa Babilonia, re Jeconías xc'ue' jun rajc'ual xubini'aj Salatiel; y re Salatiel xc'ue' jun rajc'ual xubini'aj Zorobabel. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y re Zorobabel xc'ue' jun rajc'ual xubini'aj Abiud; re Abiud xc'ue' jun rajc'ual xubini'aj Eliaquim; y re Eliaquim xc'ue' jun rajc'ual xubini'aj Azor. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y re Azor xc'ue' jun rajc'ual xubini'aj Sadoc; re Sadoc xc'ue' jun rajc'ual xubini'aj Aquim; y re Aquim xc'ue' jun rajc'ual xubini'aj Eliud. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y re Eliud xc'ue' jun rajc'ual xubini'aj Eleazar; y re Eleazar xc'ue' jun rajc'ual xubini'aj Matán; y re Matán xc'ue' jun rajc'ual xubini'aj Jacob. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y re Jacob xc'ue' jun rajc'ual xubini'aj José, y ja José re' re xoc ruchijil re María. Y ja María re' re xoc rute' re Jesús re nibex Cristo cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Y catorce generaciones re xe'c'ue', nitiquir-pa riq'uin re Abraham hasta c'a riq'uin re Rey David. Y riq'uin re Rey David nitiquir chic-pa catorce generaciones, hasta c'a chupan re tiempo tak re kavinak yoj re yoj israelitas xe'c'ue' ajuer can, xban chique che xe'bec'ue' pa Babilonia. Y riq'uin chic re' nitiquir chic-a catorce generaciones y c'aja re ruq'uisibal cha re catorce generaciones re' tak xbalax re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y ja quire' rubanic tak re Jesucristo xalax vova' chach re ruch'ulef: Re María re xoc rute' re Jesucristo, jun k'apoj ixok y c'utun chic roma re José chin ye'c'ule' riq'uin. Pero tak c'amaje-na tiquic'am-qui', re José xunabej che re María niyavaj chic. Pero re María quire' xuc'alvachij roma re ru-poder re Espíritu Santo xka pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jac'a re José re ndoc ruchijil re María, jun ache choj ruc'aslen y mare' man xrajo-ta xuya' ruq'uex re María chiquivach re vinak, mare' xunojij che xaxe tal choj quire' nuya' can y man nulisaj-ta rutzijol. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ja quire' re xunojij reja' pa ránma, che xaxe tal choj quire' nuya' can. Pero pa ruvaran xutz'at jun ángel chin re Ajaf, y re ángel re' xubij cha: José, rat re yat rey-rumam can re Rey David, man taxibij-avi' chin nac'am re María chin yac'ule' riq'uin re ac'utun chic chin ndoc avxayil, roma ja re Espíritu Santo re xka pa rue', mare' vocame niyavaj chic. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Re ac'ual re xtic'ue' riq'uin re María, ch'et ala', y Jesús rube' re xtaya'. Y ja quire' re rube' xtaya' roma reja' xque'rucol re vinak chupan re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel re' can bin chic can roma jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Can ancha'l re xubij re Ajaf cha re profeta re', can quire-va xbanataj. Y re profeta re' ja quire' rubin can: ");
INSERT INTO cakYNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Xtitz'at-na-pa', che xtic'ue' jun xtan re xaxe tal choj xtipa alanic chij, y astapa' manak ache riq'uin. Y can xtic'ue-va jun ac'ual riq'uin, y re ch'et ala' re xtic'ue' riq'uin xtubini'aj Emanuel. Re be'aj re' ndel che tzij che re Dios c'o kaq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tak xuna' rach re José, can xuban-va re xbex cha roma re ángel chin re Ajaf. Reja' can xuc'am re María chin xoc ruxayil. ");
INSERT INTO cakYNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Re ral re María man rajc'ual-ta ache, roma re María can niyavaj chic-va tak xquic'am-qui' riq'uin re José. Y tak re José xuya' rube' re ac'ual, Jesús rube' xuya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Re Jesús xalax chupan re aldea rubini'an Belén, re aldea re' chin re Judea. Tak xalax re Jesús, ja re Rey Herodes nuban gobernar chire', y jare' tak jun ca'e-oxe' achi'a' re camas quitaman chiquij re ch'umil, xe'beka pa Jerusalén. Re achi'a' re', pan oriente je'pitinak-va, ");
INSERT INTO cakYNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquic'utula' rutzijol: ¿Anche' como c'o-va re ac'ual re xalax, re qui-Rey re israelitas? Roma yoj can c'a quila pan oriente katz'eton-va-pa re ch'umil chin re ac'ual, y yoj can yojpitinak chuyi'ic ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tak re Rey Herodes xuc'axaj re xquibij re achi'a' re', xsatz ruc'o'x. Y can quire' chuka' xquiban re vinak re jec'o pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y re Rey Herodes xe'rumol conojel re principal tak sacerdotes y re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas, c'are' xuc'utuj chique che anche' c'a nalax-va re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xe'pa re principal tak sacerdotes y re achi'a' re je'atamayon re ley xquibij cha re Rey: Re Cristo nalax chupan re aldea rubini'an Belén vova' pa Judea. Roma jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha, rutz'iban can re andex xubij re Dios cha. Y ja quire' nubij re rutz'iban can: ");
INSERT INTO cakYNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y rat Belén re yatc'o pa Judá, rat man can-ta yat co'ol chiquicojol re namalaj tak tenemit chire' pa Judá, roma ja chire' aviq'uin rat xtipo-va re ec'uay-bey, y can xque'ruchajij c'a re vinak aj-Israel re nutenemit, nicha' re Dios. Quire' xquibij-apo cha re Rey Herodes. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Y tak rion c'o re Rey Herodes che' xe'rayoj re achi'a' re camas quitaman chiquij re ch'umil, y otz ruc'utuxic xuban chique jampa' tak xquitz'at re ch'umil chin re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y c'are' c'a xe'rutak-a chupan re aldea rubini'an Belén y xubij-a chique: Quixbiyin chila' y ticanoj re ac'ual, y tak xtivel xtiya' rutzijol chua, chin yimba chuka' yen chuyi'ic ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y tak re achi'a' re camas quitaman chiquij re ch'umil xquic'axaj re tzij re xe'rubij-a re Rey Herodes chique, xe'ba. Y re ch'umil re quitz'etom-pa pan oriente, can ruc'uan c'a-a quibey. Y re ch'umil re' xbepa'e' pa rue' re lugar re anche' c'o-va re ac'ual. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y re achi'a' re camas quitaman chiquij re ch'umil, xquina' che re cánma camas niqui'cot tak xquitz'at chic re ch'umil chin re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jac'a tak re achi'a' re' xe'oc-apo pa jay, can xquitz'at-va re ac'ual y re María re rute' re ac'ual, y can jare' tak xe'xuque' y re nic'aj tak quivach c'a pan ulef xquikasaj-va-ka chin xquiya' ruk'ij re ac'ual. Y chuka' can xe'quijakala' quive' re anche' je'quic'uan-va-a re k'anapuak, pom y mirra, y jare' re xe'quisipila' can cha re ac'ual. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero re achi'a' re camas quitaman chiquij re ch'umil, pa cachic' xbex chique, che man chic que'tzolaj chupan re bey re anche' je'pitinak-va, chin che man tuc'axaj rutzijol re Rey Herodes. Y can quire-va xquiban re achi'a' re', roma can xe'tzolaj-va chupan re qui-nación re anche' je'pitinak-va, pero jun chic-va bey xquic'uaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y re achi'a' re camas quitaman chiquij re ch'umil xe'tzolaj. Y jare' tak re José xutz'at pa ruvaran jun ángel chin re Ajaf Dios. Y re ángel re' xubij cha: Cayacataj. Tac'uaj-a re ac'ual y chibil re rute' y quixnumaj-a. Quixbiyin c'a pan Egipto y quixec'ue' chire', y c'a xtinya-na chic rutzijol chava tak otz che yixtzolaj chic-pa jun bey. Roma re Rey Herodes can xtucanoj re ac'ual chin che nuquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y re José can jare' tak xc'astaj, xuc'uaj-a re ac'ual y re te'ej. Can chupan re mismo ak'a' re' xquitz'am-a bey chin xe'ba c'a pan Egipto. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Can chila-va pan Egipto xe'c'ue-va y c'a xcom-na re Rey Herodes c'are' xe'tzolaj chic jun bey pan Israel. Chin quire' can nibanataj re rubin can re Ajaf Dios cha re rusamajel re xc'ue' ajuer can, re xbex profeta cha. Y ja quire' nubij re tz'iban can: Pan Egipto c'a c'o-va re nuc'ajol tak xinvayoj. Ja quire' rubin can re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y can jare' tak re Rey Herodes xunabej che re achi'a' re camas quitaman chiquij re ch'umil man xquiban-ta ancha'l re rubin-a chique. Y reja' camas xyacataj ruyoval y xutak quiquimisasic conojel re ch'utak alabo re jec'o chupan re aldea rubini'an Belén y re jec'o pa tak lugar re jec'o-apo chunakaj re aldea re'. Re ch'utak alabo re xutak quiquimisasic ja re c'o ca'ca' quijuna' y re c'a jun ca'e' k'ij ca'lax-va. Roma reja' can rutaman can chiquij re achi'a' re camas quitaman chiquij re ch'umil. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vova' can xbanataj ancha'l re rutz'iban can re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha, re xubini'aj Jeremías: ");
INSERT INTO cakYNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Che chire' pa Ramá xc'axataj ok'ej. Can c'o bis. Y c'o c'a jun re can nujek'aj ok'ej. Y re' ja re Raquel ye'rok'ej re ral. Can man nak'ax-ta c'a-a re bis chuc'o'x roma xe'com re ral. Quire' nubij re tz'iban can roma re Jeremías. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y tak quiminak chic-a re Rey Herodes, c'ajare' tak re José pa ruvaran xutz'at chic jun bey re ángel chin re Ajaf Dios chire' pan Egipto. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Y re ángel chin re Ajaf xubij cha: Cayacataj. Tac'uaj-a re ac'ual chibil re rute' y quixtzolaj chic jun bey chupan re i-nación Israel. Roma re xe'jovan che xcom-ta re ac'ual chila' pan Israel, xa xe'com-yan. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y re José can xuban-va re xubij re ángel cha pa ruvaran. Xuc'uaj-a re ac'ual y re te'ej. Xe'tzolaj chupan re qui-nación Israel. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero roma re José xuc'axaj che ja re Arquelao re ruc'ajol can re Rey Herodes, re nibano gobernar pa Judea, xuxibij-ri' che ye'c'ue-ka chire' pa Judea. Pero re José pa rachic' xbex cha re ruc'amon che nuban, y mare' reja' c'a pa Galilea xuc'uaj-va re ac'ual y re te'ej. ");
INSERT INTO cakYNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xe'bapon c'a chupan re aldea rubini'an Nazaret y chire' xe'c'ue-va-ka, chin quire' can nibanataj ancha'l re tz'iban can coma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Re je ru-profetas re Dios quitz'iban can che re Jesús can xtibex nazareno cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Y xapon re k'ij tak re Juan Bautista xutz'am rutzijosic re ruch'abal re Dios chiquivach re vinak, y ja chupan re lugar re anche' manak vinak re nibex desierto cha re c'o pa Judea, chire' nutzijoj-va re ruch'abal re Dios, ");
INSERT INTO cakYNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","y reja' nubij chique re vinak: Tijalataj re ic'aslen chach re Dios, roma xa can nakaj chic c'o-va-pa re k'ij chin che yojoc pa ruk'a' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Can ja-va chij re Juan Bautista ch'ovenak-va can re Isaías, re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y re rutz'iban can reja' ja quire' nubij: Xtic'ue' c'a jun ache chupan jun lugar re anche' manak vinak re nibex desierto cha, y ja reja' re xtitzijon re ruch'abal re Dios chiquivach re vinak re xque'bapon riq'uin. Y xtubila' chique: Tichojmersaj rubey re ic'aslen, roma re Ajaf xa can nipa-yan. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Re tziak re nucusaj re Juan Bautista riq'uin rusumal camello banon-va, y jun tz'um re aconak ximibal-rupan. Y re ruay ja re sac' y re cab re niquiya' ch'utak chicop pa tak k'os. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y camas je q'uiy vinak re ye'bapon riq'uin re Juan Bautista. Jec'o que'pa pa tenemit Jerusalén, y jec'o je'pitinak pa tak nic'aj chic tenemit chin re Judea. Y jec'o je'pitinak re jec'o chunakaj re rakan-ya' rubini'an Jordán. Can conojel re vinak re' ye'bapon riq'uin re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Y reja' can ye'ruban-a bautizar re vinak re' chire' pa rakan-ya' Jordán. Can ye'quicholola' c'a re quimac chach re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y tak reja' xutz'at che je q'uiy chique re achi'a' fariseos y chuka' je q'uiy chique re achi'a' saduceos re ye'bapon riq'uin chin che ye'ruban-a bautizar, reja' xubij chique: Yex can yix ancha'l itzel tak cumatz re yixnumaj chach re ruyoval re Dios re nika pan ive', roma nijo' yixcolotaj chach re namalaj castigo re xtutak-pa re Dios re tiempo pitinak. ¿Anchique xbin chiva che quire' tibana'? ");
INSERT INTO cakYNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Yex tiene que nic'ut che katzij xjalataj re ic'aslen chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man tinojij-ka che xaxe roma yex can yix rey-rumam, can re Abraham, mare' xquixcolotaj, man quire-ta. Roma xe-ta re Dios nrajo', hasta re aboj re ye'tz'etela' vova' nuban chique che can-ta ye'oc rey-rumam re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Re castigo re nuya' re Dios nipa-yan. Reja' xtuban ancha'l nuban jun ache re ruc'uan chic ricaj chin che ye'rukasaj re che' re xa manak otz quivach niquiya'. Y ronojel re che' re xque'rukasaj xtunem quik'ak'al. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Y yen, ya' nincusaj chin yiximban bautizar tak nijalataj ic'aslen chach re Dios. Pero c'o c'a Jun re xtipa re tiempo pitinak, re man ancha'l-ta-oc yen. Roma reja' camas-va ruk'ij y ru-poder, mare' yen can man ruc'amon-ta che ninlisaj y ninya' re ruxajab charakan. Re Jun re xtipa, can xquixruban-va bautizar riq'uin re Espíritu Santo y riq'uin k'ak'. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y can ancha'l nuban jun ache cha re ru-trigo tak nuban trillar. Y tak xuban-yan trillar nuxipuj rach chin quire' rion re runak' re trigo nic'ue' can y nuyac, y re rij nuparoj. Y ja quire' xtuban re Jun re xtipa, xcha' re Juan. Re Jun re xtipa c'o autoridad pa ruk'a', chin nuban juzgar pa quive' re vinak re jec'o chach re ruch'ulef. Re vinak re ye'niman richin, xque'ruc'uaj chila' chicaj. Jac'a re vinak re man ye'niman-ta richin, xque'rutak chupan re k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y tak re Juan ntajin chubanic rusamaj re Dios chire' chuchi' re rakan-ya' Jordán, jare' tak re Jesús xapon riq'uin. Re Jesús c'a pa Galilea pitinak-va. Reja' pitinak chin che niban-a bautizar roma re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero re Juan man nrajo-ta nuban bautizar re Jesús, roma nubij cha: Ja yen re ruc'amon che yinaban bautizar y mana-ta yen re xquimbano bautizar avichin rat, xcha' re Juan cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero re Jesús xubij cha re Juan Bautista: Yoj can ruc'amon che nakaban ronojel re nubij re Dios chaka. Mare' vocame nic'atzin che rat yinaban bautizar. C'ajare' tak re Juan Bautista xuban bautizar re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y tak re Jesús banon chic bautizar, xel-pa pa ya'. Y reja' xutz'at che re rocaj xjakataj y xutz'at chuka' che re Espíritu Santo chin re Dios nika-pa pa rue' ancha'l jun paloma. Can choj xka-pa pa rue' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y xc'axataj re nibex-pa chila' chicaj: Jare' re Nuc'ajol, y yen camas ninjo' y yinqui'cot riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Y jare' tak re Jesús xban cha roma re Espíritu Santo che xba chupan jun lugar re anche' manak vinak re nibex desierto cha, chin che nitojtobex roma re itzel. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Y reja' cuarenta k'ij y cuarenta ak'a' re man viynak-ta, y tak xe'k'ax-yan re k'ij re', c'are' xpa ch'umunic rupan. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y re itzel xjelon-apo riq'uin re Jesús chin nutojtobej, y xubij cha: Rat nabij che yat Ruc'ajol re Dios y nich'umun apan, tabana' c'a chique re aboj re' che que'oc vay. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero re Jesús xubij cha: Tz'iban can chupan re ruch'abal re Dios, che re ache man xe-ta riq'uin re vay nuvel-va ruc'aslen, xa can nuvel chuka' ruc'aslen riq'uin re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y jare' tak re itzel xuc'uaj-a re Jesús c'a chupan re lok'olaj tenemit Jerusalén, y xuban cha che xjote-a c'a pa rue' re rachoch re Dios roma camas naj jotal chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","C'are' re itzel xubij cha re Jesús: Tatorij-ka-avi' vova', rat re yabin che yat Ruc'ajol re Dios. Roma chupan re ruch'abal re Dios re tz'iban can, nubij: Re Dios can xque'rutak re ru-ángeles chin yatquichajij. Y xcatquili'ej pa quik'a', chin quire' man xtasoc-ta avakan chach aboj. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero re Jesús xubij cha re itzel: Yen can man nintojtobej-ta re Dios. Roma chupan re ruch'abal re Dios re tz'iban can nubij che man takatojtobej re Kajaf Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y re itzel xuc'uaj re Jesús c'a pa rue' jun loma re camas naj jotal chicaj y can xuc'ut ronojel naciones chin re ruch'ulef chach, y ronojel re quibiyomal y re quik'ij re naciones re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y c'are' re itzel xubij cha re Jesús: Can ronojel re xinc'ut chavach xtoc avichin, vo xa rat xcaxuque' chinoch y naya' nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero re Jesús jare' tak xubij cha: Rat Satanás, man chic quinanak, mejor cabiyin. Yen mana-ta re najo' rat re nimban. Roma chupan re ruch'abal re Dios re tz'iban can, nubij: Xaxe re Kajaf Dios takaya' ruk'ij, y xaxe chuka' reja' re takasamajij, xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y jare' tak re itzel xba y xuya' can re Jesús. Y re ángeles xe'bapon riq'uin re Jesús chin xquivilij. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y tak re Jesús xuc'axaj che re Juan Bautista c'o pa cárcel, jare' tak re Jesús xtzolaj chic pa Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero re Jesús man xc'ue-ta chic chupan re aldea rubini'an Nazaret, sino que reja' xa chupan re tenemit rubini'an Capernaum chire' xbec'ue-va, y re jun tenemit re' chuchi' jun lago c'o-va. Re tenemit Capernaum chiquicojol re ca'e' lugar quibini'an Zabulón y Neftalí c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Re Jesús xapon chupan re jun tenemit re', chin quire' can nibanataj re tz'iban can roma re Isaías rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y ja quire' nubij re rutz'iban can: ");
INSERT INTO cakYNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Re vinak re jec'o chupan re lugar rubini'an Zabulón y re jec'o chupan re lugar rubini'an Neftalí; re c'o chuchi' re jun lago, re c'o-apo juc'an ruchi' re rakan-ya' Jordán. Chupan re Galilea re', xa can bama quion man je israelitas-ta jec'o. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Re quic'aslen re vinak re' can pa k'oko'm c'o-va, pero can xapon re Namalaj Sakil quiq'uin. Y chuka' re vinak re' can c'o chic re rumuch'uch'il re camic pa quive', pero can xapon chuka' quiq'uin re nisekresan quichin. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y tak re Jesús xapon pa tenemit Capernaum, can jare' tak xutz'am rutzijosic re ruch'abal re Dios y nubij chique re vinak: Tijalataj re ic'aslen chach re Dios, roma xa can nakaj chic c'o-va-pa re k'ij chin che yixoc pa ruk'a' re Dios, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y jun k'ij tak re Jesús binak chuchi' re lago rubini'an Galilea, xe'rutz'at je ca'e' achi'a' quichak'-qui'. Re jun ja re Simón re nibex chuka' Pedro cha, y re jun chic ja re Andrés. Y reje' je aj-tz'amoy-car, mare' tak niquiya-ka re quiya'l chapabal-car pa ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y jare' tak re Jesús xubij chique: Jo', jo' chuij, y xtinc'ut chivach andex niban chin ye'tz'am vinak chin che ye'tzake' chuij. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Re je ca'e' achi'a' re', can jare' xquiya' can re quiya'l chin chapabal-car y xe'ba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Y c'a ba' c'a que'biyin che', tak re Jesús xe'rutz'at chic je ca'e' achi'a' chuka' quichak'-qui'. Y re je ca'e' achi'a' re', ja re Jacobo y re Juan re je rajc'ual re jun ache rubini'an Zebedeo. Reje' can ja pa canoa ye'samaj-va riq'uin re quirta'. Ye'quic'ajoj re quiya'l chapabal-car. Y xpa re Jesús xe'rayoj chin che ye'ba chij. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y can jare' tak re Jacobo y re Juan xquiya' can re quirta' y re canoa y xe'ba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Y re Jesús ronojel tenemit chin re Galilea xbiyaj-va, ye'rutijoj re vinak riq'uin re ruch'abal re Dios pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y chuka' nutzijoj re utzulaj ch'abal chin re Dios re nich'o chij tak re vinak xque'oc pa ruk'a' re Dios, re nibex evangelio cha. Y can ronojel rach yabil y k'axomal quic'uan re vinak ye'ruc'achojsaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Re Jesús xapon rutzijol pa tak ronojel tenemit chin re Siria. Y re yava'i' xe'c'am-pa riq'uin re Jesús. Re yava'i' re' man junan-ta rach yabil ndoc chique. Roma jec'o re ye'yavaj re camas nik'axo re quiyabilal. Jec'o ye'yavaj roma ja re itzel tak espíritu je'aconak quiq'uin. Jec'o re c'o ruyabil quijalom y jec'o chuka' re siquirnak qui-cuerpo. Y conojel re yava'i' re' xe'ruc'achojsaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y re Jesús camas-va je q'uiy vinak re aj-chire' pa tak tenemit chin re Galilea xe'tzake' chij, chuka' re ye'pa pa tak tenemit re jec'o pa Decápolis, re ye'pa pa Jerusalén y re jec'o pa tak nic'aj chic tenemit chire' pa Judea, y chibil chuka' re vinak re ye'pa c'a juc'an chic-apo ruchi' re rakan-ya' Jordán, can conojel c'a re vinak re' can xe'tzake' chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y tak re Jesús xe'rutz'at che camas je q'uiy vinak re quimalon-qui', jare' tak reja' xjote-a pa rue' re loma, y xtz'uye' c'a-ka. Y c'are' xquimol-apo-qui' re ru-discípulos riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y jare' tak re Jesús can ye'rutijoj re vinak, y xubij: ");
INSERT INTO cakYNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Otz-ibanoj yex re meba' ivánma chach re Dios, roma can yixoc-va pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Otz-ibanoj yex re ndok' ivánma chach re Dios, roma xtuban chiva che man chic xquixok'-ta, xa xquixqui'cot. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Otz-ibanoj yex re camas nicoch'on re ivánma, roma can xtoc ivichin re ruch'ulef chin re Dios, re rusujun can reja' chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Otz-ibanoj yex re nich'umun y nic'at ivánma roma nijo' nic'uaj jun c'aslen choj riq'uin re Dios, roma re Dios xtuban chiva che xtich'uch'o' re ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Otz-ibanoj yex re can nalax-pa pan ivánma che nijoyovaj quivach re nic'aj chic vinak, roma re Dios can xtujoyovaj chuka' ivach re quire' yixbano. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Otz-ibanoj yex re ch'ajch'oj ivánma chach re Dios, roma yex can xtitz'at-va rach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Yex re camas ch'o'l re ivánma, y tak c'o ayoval can nitaj ik'ij che niq'uis-a re ayoval, otz-ibanoj roma can xtibex chiva che yix rajc'ual re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Yex re camas tijoj-pokonal nik'asaj pa quik'a' nic'aj chic vinak, roma can choj-va re ic'aslen chach re Dios, otz-ibanoj roma can yixc'o chic pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Otz chuka' quibanoj re ye'ch'olix y nitz'uculas tzij chiquij y niban ronojel rach etzelal chique nutzij yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mare' yex can quixtze'en y quixqui'cot, roma nem re rajal-ruq'uixel xtic'ul chila' chicaj roma re tijoj-pokonal itz'amon ruk'asasic, roma quire' chuka' re tijoj-pokonal xquik'asaj re je rusamajela' re Dios xe'c'ue' ajuer can, re xbex profetas chique, y reje' más nabey xe'c'ue' que chivach yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja yex re rutzayil re quic'aslen re vinak re jec'o chach re ruch'ulef. Pero xe-ta re atz'am niq'uis-ta-a re rutzayil, ¿andex como rubanic nakaban chin quire' nitzolaj-ta chic-pa re rutzayil? Man jun. Xa camanak chic ndoc-va, xa nich'akex-a y can ye'k'ax re vinak chij. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Can jac'a chuka' yex re yixsekresan re quic'aslen re vinak chach re ruch'ulef y can jabal yixk'alajin, can ancha'l jun tenemit tak pa rue' jun loma c'o-va, can jabal nik'alajin y man nitiquir-ta nrevaj-ri'. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yex tak nitzaj jun lámpara, man chuxe-ta jun cajón niya-va-apo, man quire-ta. Yex can nicanoj jun ruc'ojlebal anche' niya-apo, chin quire' can ye'rusekresaj conojel re jec'o pa jay. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Y can-ta quire' nuban re ic'aslen chiquivach re vinak, can-ta ancha'l re sakil chin jun lámpara. Chin quire' re vinak tak niquitz'at che re ibanabal camas otz, reje' can xtiquiya' ruk'ij re Dios re Irta' re c'o chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man tinojij che yen ximpa chin che man jun ruk'ij nimban cha re ley chin re Moisés, y man tinojij che can quire' chuka' nimban cha re je'quitz'iban can re achi'a' re je rusamajela' re Dios re xe'cue' ajuer can, re xbex profetas chique. Man chin-ta re' tak ximpa, yen ximpa chin che can nimban re andex ndel-va che tzij re nubij re ley, y chuka' re je'quitz'ibalon can re profetas. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Roma can katzij nimbij chiva che ronojel re tz'iban chupan re ley, can xque'banataj-va. Re ruch'ulef y re rocaj xque'q'uis. Pero re je'tz'iban chupan re ley can xque'banataj-va, y man jun cosa re man-ta xtibanataj re xe-ta tal choj quire' xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mare' xabanchique vinak re man nrajo-ta nuban re nubij chupan re ley, astapa' jun tzij re can ancha'l che camanak rajkalen, y vo xa can quire' chuka' xtuc'ut chiquivach re nic'aj chic vinak che tiquibana', re nibano quire', xa camanak ruk'ij xtic'ue' chiquicojol re jec'o pa ruk'a' re Dios. Jac'a re vinak re nibano ronojel re nubij chupan re ley y can quire' chuka' xtuc'ut chiquivach re nic'aj chic vinak che tiquibana', reja' can xtic'ue' ruk'ij chiquicojol re jec'o pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Yex re nijo' yixoc pa ruk'a' re Dios, can nic'atzin che re ic'aslen más choj que chach re quic'aslen re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas y chach re quic'aslen re achi'a' fariseos. Roma reje' niquinojij che choj re quic'aslen, pero man quire-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Yex jabal itaman, roma ic'axan re xbex chique re kavinak ajuer can, che man que'quimisan. Y xabanchique vinak re niquimisan, can c'o rumac y tiene que niban juzgar. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero yen nimbij, che xabanchique vinak astapa' xaxe nipa ruyoval cha jun chic vinak, can nimacun-va y can tiban juzgar. Chuka' re nibin cha jun chic vinak, che manak nic'atzin-va. Re nibin quire', can aj-mac chuka', mare' can ruc'amon che nic'uax chiquivach re achi'a' re pa camon ye'bano juzgar. Y jac'a re nibin nacanic cha jun chic vinak, re nibin quire' xa can yaben chic chupan re k'ak' re c'o chupan re infierno. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mare' vo xa rat can yatc'o chic-apo chach re altar chin naya' jun ofrenda cha re Dios y jare' tak ne'ka cha'c'o'x che rat c'o jun cosa re man otz-ta abanon cha jun vinak, ");
INSERT INTO cakYNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taya' can re ofrenda chire' anche' c'o-va re altar y can jare' cabiyin riq'uin re jun vinak re', ta'bana' rubiyal re man otz-ta c'o chi'icojol. Y tak c'achojnak chic rubiyal y junan chic ivach riq'uin, c'ajare' catzolaj y taya' re a-ofrenda cha re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Y vo xa c'o jun chiva yex nisujus chiquivach re autoridades roma c'o ruc'as, tucanoj rubanic chin che nuban rubiyal riq'uin re xsujun richin tak je'binak pa cabildo. Pero vo xa man nic'achoj-ta rubiyal re anchok riq'uin c'o-va ruc'as, can ye'bo-va chach re juez, y re juez xtujach-a pa ruk'a' re policía, y re policía nuc'uaj-a, chin no'rtz'apij can pa cárcel. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y can katzij nimbij, che xabanchique vinak ndoc pa cárcel roma c'as, cama-va xtel-ta-pa pa cárcel, vo xa man rutajon-ta can ronojel re ruc'as re anchok riq'uin c'o-va ruc'as. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Yex jabal itaman, roma can ic'axan re tzij re bin ajuer can, che re ache c'ulan, man timacun riq'uin jun chic ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero yen nimbij che quire' chuka' re ache re nurayij rach jun ixok, re nibano quire', pa ránma xa can xmacun-yan riq'uin re jun ixok re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Xa mare' vo xa ja re anak'avach re c'o pan avajquik'a' re nibano chava che yamacun, más otz che nalisaj-a y natorij-a. Roma más otz che manak jun anak'avach, que chach c'o-ta che ca'e' anak'avach, y yaba pan infierno. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuka' vo xa ja re ak'a' re c'o pan avajquik'a' re nibano chava che yamacun, más otz che nachoy-a y natorij-a. Roma más otz che manak jun ak'a', que chach c'o-ta che ca'e' ak'a', y yaba pan infierno. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Chuka' ajuer can xbex: Re ache re nrajo' nujach-ri' riq'uin re ruxayil, tubana' jun vuj, y chupan re vuj nubij che xquijach-qui', y re vuj re' tuya' cha re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero yen nimbij chiva: Re ache re nujach-ri' riq'uin re ruxayil y man roma-ta che re ixok xmacun riq'uin jun chic ache, re ache re xujach-ri' can nuban cha re ruxayil che nimacun tak niba riq'uin jun chic ache. Y quire' chuka' re jun chic ache re nic'amo-apo richin re ixok yi'on can, can nimacun, roma re ixok re' can c'o-va re nabey ruchijil. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Y chuka' yex can jabal itaman, roma ic'axan re xbex chique re kavinak ajuer can, che tak c'o jun cosa niquiban jurar cha re Dios can tiquibana' cumplir, y tak c'o niquisuj cha re Ajaf can tiquibana' chuka' cumplir. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero yen nimbij chiva, che man jun bey tiban jurar, y chuka' can man otz-ta chin nicusaj rube' re rocaj chin niban jurar. Roma ja chire' c'o-va re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Y man ticusaj rube' re ruch'ulef, roma ja chire' nuya-va rakan re Dios. Y chuka' man ticusaj rube' re tenemit Jerusalén, roma re tenemit re' chin re Dios re Namalaj Rey. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Y man tiban jurar ancha'l niquiban jurar re nic'aj chic vinak, reje' niquibij che vo xa man katzij-ta re niquibij, pues titzaq'uis-a re quijalom. Yex man jun bey tibij quire', roma re ic'aslen mana-ta yex re yix rajaf. Re Rajaf re ic'aslen ja re Dios, y xaxe reja' re nitiquir nijalo re ru-color re rusumal-ive'. Xaxe reja' re nitiquir nibano k'ak cha re sak y nitiquir chuka' nuban sak cha re k'ak. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mare' man jun bey tiban jurar. Ronojel re nibij, can choj tibij, vo xa katzij re nibij o xa man katzij-ta. Y vo xa niban jurar, can nik'alajin che ja re itzel c'o pan ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Y yex can jabal itaman, roma ic'axan re xbex chique re kavinak ajuer can, che re nilisan jun nak'arach jun vinak, can quire' chuka' ruq'uixel tiban cha re xbano. Re nik'ajo roray jun vinak, can quire' chuka' ruq'uixel tiban cha re xbano. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero yen nimbij chiva, che man titzolij ruq'uixel cha re anchique xbano re etzelal chiva. Vo xa c'o jun re xch'ayo avichin, man taya' ruq'uixel cha. Otz che naya' chic jun bey-avi' pa ruk'a' chin yatruch'ay. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y vo xa c'o jun vinak re can nuc'uaj jun chiva yex pa cabildo roma nrajo' numoj-a jun rutziak, re anchok cha niban-va quire' man tupokonaj nuya' can cha, y en lugar che nupokonaj, xa tuya' can chuka' re ruk'u' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O vo xa c'o jun chiva yex niban cha roma jun vinak che tuc'uaj-a jun ejka'n jun kilómetro, xa can tiqui'cot tuc'uaj-a re ejka'n re xya-a chij, y man xe-ta re jun kilómetro re xbex cha tuc'uaj-a re ejka'n, xa can tusuju-ri' che nuc'uaj-a re ejka'n ca'e' kilómetro. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y vo xa c'o jun chiva yex c'o jun cosa nuc'utuj jun vinak cha, can tuya-a cha. Y vo xa c'o chuka' jun nrajo' nukaj-a jun cosa chava, man jun bey tanojij che man naya-ta-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Y yex jabal itaman, roma ic'axan re tzij bin ajuer can, che can ruc'amon-va najo' re camas otz yatrutz'at, jac'a re camas itzel yatrutz'at can tatzelaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero yen nimbij chiva: Can que'ijo' re itzel yixquitz'at, can tic'utuj cha re Dios che que'rubana' bendecir re vinak re niquirayij itzel tak cosas chivij, xaxe re otz tibana' quiq'uin re itzel quina'oj iviq'uin, y can tibana' orar pa quive' re vinak ye'yok'o ivichin y re vinak re ye'bano ronojel rach etzelal chiva nutzij yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chin quire' nik'alajin che yex can yix rajc'ual re Dios re Irta' re c'o chila' chicaj. Roma reja' camas otz runa'oj quiq'uin conojel. Reja' can c'a chila' chicaj nubam-pa cha re k'ij che nuya-pa rusakil pa quive' re vinak otz quic'aslen y pa quive' re vinak re man otz-ta quic'aslen, can c'a chila' chuka' nubam-pa che c'o job nika pa quive' re vinak choj quic'aslen y re man choj-ta quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Roma vo xa yex xaxe re vinak re ye'jovan ivichin re ye'jo', manak rajal-ruq'uixel xtic'ul, roma hasta jun vinak re man choj-ta ruc'aslen nitiquir nuban quire', reja' can nitiquir ye'rajo' xaxe re ye'jovan richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y vo xaxe chivach-ka yex mismo niyala-va ruxnokil-ivach, man jun rajkalen re quire' niban. Roma hasta re vinak re man quitaman-ta rach re Dios quire' niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yex can quixoc tz'akat riq'uin re ibanabal ancha'l re Irta' re c'o chila' chicaj. Reja' can tz'akat riq'uin re rubanabal. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Can jabal tichajij-ivi', che man tibananej chiquivach re vinak che can yixtajin chubanic re nrajo' re Dios. Roma vo xa quire' xtiban, can man jun c'a rajal-ruq'uixel xtic'ul riq'uin re Irta' re c'o chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tak yex ye'to' re vinak camas je meba', man c'a tilisaj rutzijol, can ancha'l tak nik'ajan jun trompeta re can nic'axax coma conojel vinak. Man tiban quire'. Man tiban ancha'l niquiban re vinak re xa ca'e' quipalaj, can niquilisaj rutzijol pa tak calles y pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, chin che nitamax che otz re ye'tajin chubanic. Can katzij nimbij che re vinak re ye'bano quire', xaxe che niya' quik'ij coma re vinak, reje' can xquic'ul-yan c'a rajal-ruq'uixel re quibanabal. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Y tak yex ye'to' re camas je meba', man c'a titzijoj cha jun chic vinak. Can man jun ndoc-va che nutamaj jun chic vinak re yixtajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Chin quire' can man jun chic vinak titaman re andex niya'. Pero re Irta' re c'o chila' chicaj, reja' sí rutaman. Reja' can nutz'at re man nitz'et-ta coma re vinak y xtuya' rajal-ruq'uixel chiva. Y re rajal-ruq'uixel re xtuya' chiva, can xtitz'et coma re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tak yex niban orar, man tiban ancha'l niquiban re vinak re xa ca'e' quipalaj. Roma re vinak re' camas niquijo' che ja re anche' jec'o vinak, chire' niquiban-va orar. Re pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, re pa tak esquinas, xaxe chin que'tz'et. Reje' can ye'pa'e' tak niquiban orar. Y can katzij nimbij chiva, che re vinak re ye'bano quire', xaxe che niya' quik'ij coma re vinak, reje' xa can xquic'ul-yan rajal re quibanabal. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Y tak jun chiva yex nuban orar, otz toc pa jay y tutz'apij ru-puerta y c'are' tich'o riq'uin re Rutota' re c'o chila' chicaj. Y astapa' man nutz'at-ta re anchok riq'uin nich'o-va, can rutaman che c'o nic'axan richin. Y re nic'axam-pa richin can nutz'at re man nitz'et-ta coma re vinak y nuya' rajal-ruq'uixel cha. Y re rajal-ruq'uixel re xtuya' cha, can xtitz'et coma re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yex tak niban orar, man tiban ancha'l niquiban re vinak re man quitaman-ta rach re Dios. Roma reje' camas ye'yaloj tak niquiban orar, y camas ye'quibanala' repetir re mismo ch'abal, reje' niquinojij che xa roma quire' niquiban mare' re Dios can ye'ruc'axaj-pa. Jac'a yex tak niban orar man tiban quire'. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Man c'a quixoc ancha'l reje'. Roma re Irta' re c'o chila' chicaj can c'amaje-na tic'utuj cha, reja' can rutaman chic re andex nic'atzin chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tak yex niban orar, tibana' jun oración ancha'l re': Karta' Dios yatc'o chila' chicaj, can-ta conojel re vinak niquiya' ruk'ij re abe'. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y xte'ka-yan-ta re k'ij tak ja rat re xcabano gobernar. Y xe-ta re najo' rat re nakaban vova' chuch'ulef, ancha'l niquiban re jec'o aviq'uin chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y taya' chuka' re kavay re nic'atzin chaka k'ij-k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y can ancha'l nakacuy quimac re vinak re c'o etzelal niquiban chaka, quire-ta xtaban kaq'uin yoj, xtacuy-ta ronojel re man otz-ta re yojtajin chubanic chavach. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man taya' k'ij che re itzel nuban-ta chaka che yojtzak pa mac, can kojacola' chach. Xaxe chava rat nakac'utuj-va re', roma ja rat re yatc'o pa kave', c'o a-poder y c'o ak'ij chin nojel tiempo. Amén. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Vo xa yex nicuy quimac re vinak re c'o etzelal niquiban chiva, re Irta' re c'o chila' chicaj can xquixrucuy chuka' yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Y vo xa man nicuy-ta quimac re vinak re c'o etzelal niquiban chiva, chuka' re Irta' re c'o chila' chicaj man xtucuy-ta re imac re yixtajin chubanic chach. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tak yex niban ayuno, man tiban ancha'l niquiban re vinak re xa ca'e' quipalaj, roma reje' can niquiban cha re quipalaj che ye'bison. Can jalatajnak re quitzubal, chin che can niquitz'at re vinak che reje' quitz'amon rubanic ayuno. Y can katzij nimbij chiva, che re quire' ye'bano, xaxe che niya' quik'ij coma re vinak, reje' can xquic'ul-yan c'a re rajal re quibanabal. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jac'a tak yex niban ayuno, man tiban che can nik'alajin che man yixviynak-ta, xa can jabal ruch'ajic re ipalaj tibana', tiya' ba' ak'om pan ive' y jabal rujiquic tibana' cha re ive'. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chin quire', man nik'alajin-ta chiquivach re vinak che man yixviynak-ta roma itz'amon rubanic ayuno. Xa can xe-ta c'a re Irta' re c'o chila' chicaj atamayon, roma reja' can c'o-apo iviq'uin. Reja' can nutz'at re man nitz'et-ta coma re vinak y reja' xtuya' rajal-ruq'uixel chiva. Re rajal-ruq'uixel re xtuya' chiva, can xtitz'et coma re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man tirayij re biyomal re c'o vova' chach re ruch'ulef, roma re biyomal re c'o vova' xa nichocoper y chuka' xa nipuser, y chuka' jec'o elek'oma' re ye'lek'an richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mare' can tirayij re biyomal re anche' man nichocoper-ta y chuka' man nipuser-ta. Re anche' manak elek'oma' ye'lek'an. Can jac'a re biyomal re c'o chila' chicaj tirayij. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Roma re ivánma can nic'ue' anche' c'o-va re ibiyomal, roma can jare' re nirayij. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Re anak'avach can ye'oc chava, ancha'l ndoc jun lámpara. Y vo xa re anak'avach je otz, can nojel a-cuerpo c'o pa sakil. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero vo xa re anak'avach man je otz-ta, ronojel re a-cuerpo c'o pa k'oko'm. Y quire' chuka' riq'uin re Sakil re ruyi'on re Dios pan avánma, vo xa nijalataj re Sakil re', can xtik'alajin c'a-pa che pa k'oko'm yatc'o-va, y re k'oko'm re' can xak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Y man jun vinak nibano che je ca'e-ta ru-patrón, roma man nitiquir-ta nisamaj quiq'uin che je ca'e' al mismo tiempo. Roma vo xa nrajo' jun chique re je ca'e' ru-patrón, tiene que nutzelaj re jun chic. Y vo xa nunimaj rutzij re jun, man nitiquir-ta nuban quire' riq'uin re jun chic. Mare' manak modo che jun vinak re can ruyi'on ránma riq'uin re biyomal re nitiquir-ta nuban re nrajo' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Yen nimbij chiva, che man quixel ch'o'j chucanoxic re ndoc chiva k'ij-k'ij, che anche' xte'vila-va-pa re andex nitaj y re nikum, y anche' xte'c'ama-va-pa itziak. Roma mana-ta re vay re c'o más rajkalen que chach re ic'aslen, y chuka' mana-ta re tziak re c'o más rajkalen que chach re i-cuerpo. Roma re Dios can nuya-va-pa re ivay chin c'o ic'aslen y re itziak chin nicusaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Titz'eta-na-pa' ch'utak chicop c'o quixic' re ye'ba pa cak'ik', reje' man ye'ticon-ta y manak cosecha niquilisaj juna-juna', y manak chuka' cachoch chin niquiyacala' qui-cosecha. Pero reje' ye'va', roma ja re Irta' re c'o chila' chicaj re nitzuku quichin. C'alapa' c'a yex che re Dios man-ta xtuya' ivay, roma yex c'o más ivajkalen que chiquivach re ch'utak chicop c'o quixic' re ye'ba pa cak'ik'. Xa mare' man tinojij más re andex ndoc chiva k'ij-k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Man jun chiva yex re nitiquir-ta nuban che niq'uiy ba' más rakan, astapa' can elinak ch'o'j chubanic quire'. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y anchique roma tak can yixe'linak ch'o'j chin nivel itziak? Re Dios nuya' itziak. Xaxe titz'eta' re cotz'e'j quibini'an lirio, re jec'o pa tak k'os. Titz'eta' tak ye'q'uiy. Reje' man ye'samaj-ta, y man ye'quimon-ta chin niquiban quitziak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Y c'o jun Rey xuban gobernar pan Israel jun bey can xubini'aj Salomón. Reja' camas rubiyomal y rion tziak re camas je caro re xe'rucusaj, pero man jun bey xucusaj-ta jun rutziak ancha'l jun cotz'e'j. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Roma re Dios ja re cotz'e'j jare' re quitziak nuya' chique re k'ayis re jec'o pak'os. Y astapa' re k'ayis man can-ta niyaloj, roma jun tiempo-oc re jabal nitzu'un, y tak nichakij-ka nich'akex pa k'ak', pero man riq'uin re' re Dios can nuvak-va jabal, y vo xa re Dios nuvak jabal re k'ayis, c'alapa' yex che man-ta xtuya' itziak, astapa' yex man can-ta ibanon confiar-ivi' riq'uin re Dios, pero reja' can nuya-va itziak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mare' yex man quixel ch'o'j chucanoxic re ivay, re nikum y re itziak. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Re vinak re can je'elinak ch'o'j chucanoxic quivay, re niquikum y re quitziak, ja re vinak re man quitaman-ta rach re Dios. Jac'a yex c'o re Irta' chila' chicaj y can rutaman chic che jare' re nic'atzin chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mare' re ruc'amon che niban yex ja che tinimaj rutzij re Dios y can titija' ik'ij che nic'uaj jun c'aslen choj chach, can ancha'l re nrajo' reja'. Y vo xa xtiban quire', re Dios xtuya' jun ic'aslen jabal y xtuya' chuka' re nic'atzin chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Yex man quixel ch'o'j chunojexic re andex che problemas re xque'ruc'am-pa re k'ij chua'k. Yex xaxe re nitz'at jare' tinojij, roma ronojel k'ij can c'o-va cosas re ye'quic'am-pa, y man nic'atzin-ta che ninojij-yan-apo re xque'ruc'am-pa re k'ij chua'k, roma vo xa quire' niban xa can xtak'ax rue' re problemas re numol-ri' chivij. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man tiban che ye'tzu' re vinak y c'are' itzel yixch'o chiquij, chin che re Dios man xtuban-ta quire' chiva yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Roma vo xa xtiban che ye'tzu' re vinak y c'are' itzel yixch'o chiquij, can quire' chuka' xtuban re Dios chiva yex. Can ancha'l rubanic niban yex chique re vinak, can quire' chuka' rubanic xtiban chiva yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Y rat anchique roma cha'nin natz'at re ch'et k'ayis c'o pa rach jun vinak y man nana-ta-ka-avi' che xa más nem re che' c'o pan avach rat? Re ejemplo re' ndel che tzij che man takabij che la jun vinak la' camas rumac, y jac'a re kamac yoj can nakaban che más ba-oc. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","Y chuka' man tabij cha jun vinak: Taya' k'ij chua chin ninlisaj-a re ch'et k'ayis k'atarnak pan avach, y man nana-ta-ka-avi' rat che xa más nem re che' k'atarnak pan avach. Re ejemplo re' ndel che tzij che man tabij cha jun vinak che man chic camacun, tak rat xa c'a yamacun. Man naya-ta-ka pa cuenta re amac. Xa ca'e' apalaj. Nabey tachojmersaj re ac'aslen rat, c'are' otz nato' y nabij cha jun chic vinak che tuchojmersaj re ruc'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Re ruch'abal re Dios y ronojel re camas quijkalen, ancha'l re aboj nibex perlas chique, man tiya' chique re vinak re niquiban ancha'l niquiban re tz'e' y re ak. Roma re chicop re', astapa' camas rajkalen re nuya' jun vinak chique, reje' xa niquixak'ela' rue' y hasta c'o bey ye'yacataj chij re xyi'o-apo chique chin che niquijixc'aj che eyaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Can tic'utuj re nic'atzin y re Dios xtuya-pa chiva. Ticanoj re nijo' y xtivel. Ticocaj-apo re ruchi-jay y xte'jak chivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mare' vo xa can riq'uin ronojel ivánma nic'utuj cha re Dios, reja' can xtuya-va-pa chiva re nic'utuj cha. Vo xa yex can nicanoj, can xtivel-va. Y vo xa yex xticocaj-apo re ruchi-jay, can xtijak-va-pa chivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Y man jun tata'aj nibano cha jun rajc'ual che tak re ac'ual nuc'utuj jun vay cha, reja' xa jun aboj nuya' pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Chuka' man jun bey nuya' jun cumatz pa ruk'a', tak re ac'ual xa jun car nuc'utuj cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yex astapa' itzel ina'oj, pero chique re ivajc'ual man jun bey quire' niban. Roma yex ja re otz tak cosas re niya' chique. C'alapa' re Irta' Dios re c'o chila' chicaj, che man-ta nuya-pa re nic'utuj cha. Y ronojel re nuya-pa reja', can je otz-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Yex can otz ina'oj tibana' quiq'uin re vinak, roma yex man nika-ta chivach che re vinak itzel quina'oj niquiban iviq'uin. Quire' nubij re tz'iban chupan re ley chin re Moisés, y quire' chuka' nubij re quitz'iban can re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chupan re puerta camas co'ol-oc rach, chire' quixoc-va. Roma re bey y re puerta re camas nem quivach, can ye'k'alajin che jare' re bey chin re itzel c'aslen, y jare' re nic'amo-pa re camic chin jumul, y camas je q'uiy vinak re ye'oc chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero re bey y re puerta re camas co'ol-oc quivach, ja bey re' re nic'amo-pa c'aslen, y man je q'uiy-ta re ye'vilo richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Mare' nic'atzin che nichajij-ivi' chiquivach re ye'bin che reje' can niquisekresaj re nibex chique roma re Dios y xa man katzij-ta re niquibij. Roma tak c'aja-oc ye'bapon iviq'uin, can jabal re c'aslen re niquic'ut, can ancha'l re ch'utak ovejas, roma ch'utak chicop re' camas je manso, y can man jun cosa re man otz-ta nitz'et chiquij. Jac'a tak ne'el-pa re etzelal re c'o pa tak cánma, xa can je ancha'l chic re chicop nibex utif chique, roma re chicop re' can ye'c'uxun, y ja quire' niquiban chique re anchok quiq'uin ye'bapon-va-apo roma can ye'quiq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Can xtitamaj-va quivach, can ancha'l tak nitamaj rach jun che', roma tak natamaj rach jun che' xa riq'uin natz'at re rach nuya'. Y ja quire' chuka' tak nivachin jun k'ayis re camas ruq'uixal, re k'ayis re' man nuya-ta uva ni xe-ta higo. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Y chuka' itaman che jun utzulaj che' otz rach nuya', jac'a re man utzulaj che-ta, man otz-ta rach ye'ruya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Man jun utzulaj che' xtuya-ta rach man otz-ta, y chuka' man jun che' re man otz-ta, xtuya-ta rach otz. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y nojel che' re manak otz quivach niquiya', ye'choy y c'are' ninim quik'ak'al. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mare' can xtitamaj quivach re vinak ye'bapon iviq'uin, xaxe titz'eta' andex rubanic re quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Camas je q'uiy vinak re ye'bin ¡Ajaf! ¡Ajaf! chua, pero man conojel-ta chique reje' xque'oc pa ruk'a' re Dios. Roma re xque'oc pa ruk'a' re Dios xaxe re can riq'uin ronojel cánma niquiban re nurayij re Nata' Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupan re k'ij tak yen xtimban juzgar pa quive' re vinak, camas je q'uiy re xque'bin chua: ¡Ajaf! ¡Ajaf! xque'cha', yoj pan abe' rat xkatzijoj-va re ruch'abal re Dios, y jec'o je q'uiy vinak re c'o itzel tak espíritu quiq'uin pan abe' rat xe'kalisaj-va y pan abe' chuka' rat xe'kabanala' q'uiy milagros, xque'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Jare' tak yen xtimbij chique: Yen cama-va ntaman-ta ivach, mare' can man ruc'amon-ta che yixc'ue' viq'uin, roma yex xa yix banoy-etzelal, xquincha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y xabanchique vinak re nuc'axaj re nuch'abal y nuban re nimbij cha, can junan riq'uin re jun ache re can jabal xunojij tak xupoba' jun rachoch, nabey xuban-ka re jul chin re cimiento, y anche' xbo'rvila-va-ka re aboj chire' xuya-va-ka re ru-cimiento re jay re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Y tak c'achojnak chic re jay, xpa job y re rakan tak ya' xe'beq'uiy-pa y xpa jun cak'ik' camas ruchuk'a' chij re jun jay re', y re jay re' man xtzak-ta roma pa rue' aboj xuban-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero re vinak re nuc'axaj re nuch'abal y man nuban-ta re nimbij cha, junan riq'uin re jun ache nacanic re xupoba' jun rachoch, y manak ru-cimiento xuban, xaxe tal choj xutz'uyuba-ka pa rue' ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Y tak xpa job, xe'beq'uiy-pa re rakan tak ya' y xpa jun cak'ik' camas ruchuk'a' chij re jun jay re', re jay xtzak y xq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y tak re Jesús xtane' che tzij, re vinak xsatz quic'o'x y can anchique-la xquina' tak xquic'axaj re enseñanza re nuc'ut re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Roma re Jesús tak nuc'ut re ruch'abal re Dios, can ancha'l jun re c'o autoridad pa ruk'a', y man ancha'l-ta-oc re niquic'ut re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y tak re Jesús xka-yam-pa pa rue' re loma, re vinak re je'binak chij camas je q'uiy. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y c'o jun ache xapon riq'uin re Jesús, y re ache re' niyavaj y ja re yabil rubini'an lepra c'o chij, reja' xbexuque' chach y xubij cha: Ajaf, yen ntaman che rat yatiquir yinac'achojsaj cha re nuyabil, pero man ntaman-ta andex nanojij pa nue'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Y re Jesús can jare' xutz'am-apo re ache niyavaj y xubij cha: Ninjo' che yac'achoj. Tiq'uis-a re yabil re' chavij. Y can xe xubij quire' re Jesús, can jare' xq'uis-a re lepra chij re ache. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","C'are' re Jesús xubij cha re ache re', che man tatzijoj chique re vinak che xac'achoj, vocame choj cabiyin pa rachoch re Dios chin ta'c'utu-avi' chach re sacerdote, y can taya' re ofrenda re nubij re rutz'iban can re Moisés, y re rutz'iban can re Moisés nubij re nic'atzin re naya' cha re Dios. Chin quire' niquitamaj che yat ch'ajch'oj chic, xcho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y tak re Jesús c'o chic pa tenemit Capernaum, c'o jun ache xapon riq'uin. Y re ache re' jun capitán y xuc'utuj jun utzil cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Y re capitán ja quire' xubij: Ajaf, c'o jun nusamajel niyavaj, siquirnak ru-cuerpo, y camas banayon roma can rukasan chuch'at y can nuquimisaj ruk'axon re yabil ruc'alvachin. Reja' pa vachoch c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","C'are' re Jesús xubij cha re capitán: Jo' y xtinc'achojsaj re ache niyavaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y xpa re capitán xubij cha re Jesús: Ajaf, yen xa yin jun ache aj-mac y mare' can man ruc'amon-ta che rat yatoc pa vachoch. Xaxe tabij che nic'achoj y xtic'achoj re nusamajel. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yen can ntaman-va che quire' xtibanataj, roma ancha'l nbanon yen can c'o jun re nibano mandar pa nue'. Y chuka' jec'o soldados je'yi'on pa nuk'a' chin nimban mandar pa quive'. Tak nimban mandar pa rue' jun soldado re jec'o pa nuk'a' che tiba, can nibo-va, y tak nimban chic mandar pa rue' jun chique re soldados re jec'o pa nuk'a' che tipa, can nipo-va. Y tak nimban mandar pa rue' re nu-mozo che tubana' jun cosa, can nuban-va, ja nojel re' xubij re capitán cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y tak xuc'axaj quire' re Jesús, can anchique-la xuna' y xubij chique re je'tzakatal chij: Can katzij nimbij chiva che re jun ache re', can katzij rubanon confiar-ri' viq'uin. Y man jun chique re nuvinak israelita re nvilon re can rubanon-ta confiar-ri' viq'uin, ancha'l re jun ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Y yen nimbij chiva che camas je q'uiy vinak xque'pa pan oriente y quire' chuka' xtiquiban re xque'pa pan occidente, y re vinak re' can quibanon confiar-qui' viq'uin. Reje' xque'tz'uye' riq'uin re Abraham, re Isaac, re Jacob y re nic'aj chic re can jec'o chic pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Jac'a re vinak re can banon chique che xque'oc pa ruk'a' re Dios, xa man chic xque'oc-ta, xa xque'lisas can y xque'ch'akex chupan re lugar camas k'oko'm, roma can man xquiban-ta confiar-qui' viq'uin. Y c'aja chire' c'a xtipo-va re ok'ej chiquivach y xtiquikach'ach'ej rocay roma xe'lisas can. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'are' re Jesús xubij-a cha re capitán: Catzolaj cha'vachoch. Roma xanimaj che yen yintiquir ninc'achojsaj re asamajel, can xtibanataj re xarayij, xcha-a cha. Y can jare' xc'achoj re ru-mozo re capitán cha re ruyabil. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y tak re Jesús xapon pa rachoch re ru-discípulo rubini'an Pedro, xutz'at che re rujete' kejnak chuch'at roma jun namalaj c'atan tz'amayon richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpa reja' xutz'am chuk'a' re ixok y can jare' xc'achoj-a. Re ixok re' xbeyacataj-pa y xutz'am ruyi'ic quivay re Jesús y re je'binak chij. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Y tak xk'ok'a-ka chupan re k'ij re', camas je q'uiy vinak re xe'c'uax-apo chach re Jesús re c'o itzel tak espíritu quiq'uin, chin che re Jesús ye'rulisaj-ta-a re itzel tak espíritu re c'o quiq'uin. Y reja' xubij chique re itzel tak espíritu che que'el-a, y can xe'ruc'achojsaj-a chuka' conojel re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chin quire' can nibanataj re rubin can re Isaías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re Isaías ja quire' rubin can chij re Jesús: Konojel xe'rulisaj-a re kayabilal, y ja reja' re xc'uan ronojel kak'axomal. Quire' rubin can re Isaías. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Y tak re Jesús xutz'at che camas je q'uiy vinak niquimol-apo-qui' chiquij, jare' tak reja' xubij chique re ru-discípulos che tiquic'ama-pa jun canoa roma can nic'atzin che yojba c'a juc'an-apo ruchi-ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y c'o c'a jun ache re atamayon re ley kachin yoj re yoj israelitas re xapon-apo riq'uin re Jesús y xubij cha: Rat can yat jun Maestro, y yen ninjo' yatintzekelbej xabanche' xcabo-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xpa re Jesús xubij cha re ache re': Re utif can c'o quijul anche' ye'c'ue-va, y quire' chuka' re ch'utak chicop c'o quixic' re ye'ba pa cak'ik', can c'o chuka' quisoc. Jac'a yen re xinalax chi'icojol, manak anche' yinc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Can ja chuka' re' tak jun chic re can tzekelbey-va chin re Jesús, xubij-apo cha: Ajaf, yen ninjo' yimba chavij. Pero nabey taya' k'ij chua che c'a timuku-na-a re nata', c'are' xquimba chic chavij. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Pero re Jesús xubij cha re ache re': Rat catzake' chuij, re vinak ye'com que'muk coma re vinak re can je quiminak chupan re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Re Jesús xoc-a pa jun canoa, y can je'binak chuka' re ru-discípulos chij. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y chak c'ata' xpa jun cak'ik' re camas ruchuk'a' y nuban cha re ya' che camas nisilon y can nubolk'otela-ri' y camas naj niba chicaj. Y can nuban che re canoa che niba chuxe' ya'. Y re Jesús nivar chupan re canoa. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y c'are' re discípulos xquic'asoj re Jesús y xquibij cha: ¡Ajaf! ¡Ajaf! kojato'. Vocame yojcom, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xpa re Jesús xubij chique re ru-discípulos: Can man ibanon-ta confiar-ivi' viq'uin, ¿anchique roma tak camas ixibin-ivi'? Y c'are' xbeyacataj-pa y xubij, che tiq'uis-a re cak'ik' y titane-ka re nubolk'otela-ri' re ya'. Y quire' xbanataj. Re cak'ik' xq'uis-a y chuka' re ya' xtane-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y re discípulos xsatz quic'o'x tak xquitz'at re xuban re Jesús y niquibila' chiquivach: ¿Anchique como che ache re'? Roma re cak'ik' y re ya' can niquinimaj chuka' rutzij. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y tak re Jesús y re ru-discípulos xe'bapon-yan-apo c'a juc'an chic re ruchi-ya', re anche' c'o-va re jun lugar rubini'an Gadara, jec'o je ca'e' achi'a' xe'bapon riq'uin re Jesús. Re je ca'e' achi'a' re' c'o itzel tak espíritu quiq'uin y ja re camposanto chin re lugar re' re aconak cachoch. Man jun vinak nitiquir quiq'uin roma camas quichuk'a' y mare' man chic jun vinak nak'ax chupan re bey re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Re je ca'e' achi'a' re', re c'o itzel tak espíritu quiq'uin, can cof xe'ch'o-apo cha re Jesús, y xquibij: Rat Jesús re Ruc'ajol re Dios, ¿anchique roma tak yojanak? ¿Anchique roma can yojach'ujersaj-yan, tak xa c'amaje-na tapon re tiempo? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y nakaj-apo ba', camas je q'uiy ak ye'va'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Y re itzel tak espíritu re jec'o quiq'uin re je ca'e' achi'a' re' xquic'utuj utzil cha re Jesús. Y xquibij cha: Vo xa yojalisaj-a vova' quiq'uin re achi'a' re', taya' k'ij chaka chin che yoje'oc chiquipan la ak jec'o chila', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Y re Jesús xubij chique: Otz quixbiyin, xcha' chique. Y re itzel tak espíritu can jare' xe'el-a quiq'uin re je ca'e' achi'a' re' y xe'be'oc chiquipan re ak. Y conojel re ak re' xquitz'am anin chach peña y c'a pa ya' xe'beka-va. Y conojel re ak re' xe'jik' y xe'com pa ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y re ye'chajin quichin re ak xe xquitz'at can quire', xe'numaj y xe'ba pa tenemit, chin xbequiya' rutzijol re andex xquic'alvachij re ak y xbequibij chuka' re xbanataj quiq'uin re je ca'e' achi'a' re c'o itzel tak espíritu quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Y tak xquic'axaj re vinak re xbebex chique, xa can bama conojel re jec'o chupan re tenemit re' xe'pa chutz'etic re Jesús, y chuka' chin xquic'utuj utzil cha re Jesús che tel-a chire' chupan re qui-lugar, roma reje' man niquijo-ta che nic'ue-ka chire' quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","C'are' re Jesús y re can je'tzakatal-va chij, xquiya' can re lugar re'. Xe'oc-a pa canoa y xe'ba c'a juc'an chic-apo re ruchi-ya'. Y re Jesús can xapon chupan re tenemit re anche' can tic'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y tak reja' c'o chic pa tenemit, xquic'uaj-apo jun ache siquirnak ru-cuerpo chach re Jesús, re ache re' quiliban-a chach jun camilla. Y tak re Jesús xe'rutz'at che can riq'uin ronojel cánma xe'bapon c'a riq'uin-apo, xpa re Jesús xubij cha re ache siquirnak ru-cuerpo: Vajc'ual, tiqui'cot re avánma roma re amac xe'cuyutaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y jare' tak jec'o nic'aj chique re achi'a' je'atamayon re ley kachin yoj re yoj israelitas re jec'o-apo chire', xquibij-ka pa tak cánma chij re Jesús: Re' jun itzel ache. Can nuban che ja reja' re Dios, roma nubij che can nucuy mac. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero re Jesús can rutaman re niquinojij pa tak cánma re achi'a' re', mare' reja' xubij chique: ¿Anchique roma xa ja re itzel tak nojebal xinojij cha'nin? ");
INSERT INTO cakYNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Roma vo xa yen yintiquir nimban cha re jun ache re' re siquirnak ru-cuerpo, chin che nibiyin-a y niba, can yintiquir chuka' nimbij cha che nincuy rumac. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Y vocame, chin che yex nitamaj che yen re xinalax chi'icojol can c'o poder pa nuk'a' chin che nincuy mac, titz'eta' c'a, xcha' chique. Y jare' tak re Jesús xubij cha re ache siquirnak ru-cuerpo: Chava rat nimbij-va: Cayacataj, y tac'uaj-a la a-camilla y cabiyin cha'vachoch. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y can jare' tak re ache siquirnak ru-cuerpo xyacataj-a y xba charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Re vinak re quimalon-apo-qui' chire', tak xquitz'at che re ache siquirnak xpa'e-a, xsatz quic'o'x, roma man jun bey quitz'eton che quire-ta nibanataj. Y re vinak re' xquiya' ruk'ij re Dios, re ya'yom-pa re namalaj poder re' chiquicojol re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y tak xk'ax re Jesús re anche' nimban-va cobrar re impuestos, re Jesús xinrutz'at yen re Mateo che yintz'uyul chach jun ch'acat, y ja chua yen re nitoj-va can re impuestos. Y re Jesús xubij chua: Jo' chuij. Y can xe xinc'axaj quire' can ja xineyacataj-pa y can xintzekelbej re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y tak re Jesús tz'uyul chic chach mesa chire' pa jay, je q'uiy chique re molay tak impuestos y chuka' re vinak re nibex aj-maqui' chique, xe'tz'uye-apo chach mesa riq'uin re Jesús y re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y re achi'a' fariseos re xe'tz'eto re', xquibij chique re ru-discípulos re Jesús: ¿Anchique roma re Jesús re i-Maestro niva' quiq'uin re molay tak impuestos y quiq'uin chuka' la aj-maqui'? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tak re Jesús xuc'axaj-pa re tzij re niquibila' re achi'a' fariseos, reja' xubij chique: Jun doctor mana-ta re je otz ye'ruk'omaj. Reja' ja re ye'yavaj jare' re ye'ruk'omaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yen man ximpa-ta chiquicanoxic vinak re choj quic'aslen. Yen ximpa chiquicanoxic re c'o quimac, re nic'atzin che nijalataj quic'aslen chach re Dios. Y yex man chak xaxe tal choj quire' titorola-pa re itzij nabey, xa quixbiyin chutz'etic y chutamaxic re andex ne'c'ulun-va che tzij re nubij re Dios: Re más nika chinoch yen ja-ta che yex nijoyovaj quivach re vinak, que chach ye'sujula' chicop je'quimisan chinoch. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Y re ye'tzekelben chin re Juan Bautista xe'beka riq'uin re Jesús, xquibij cha: Yoj can kacha'on k'ij chin nakaban ayuno. Y quire' chuka' niquiban re fariseos. ¿Y anchique roma tak re a-discípulos rat man quire-ta niquiban? ");
INSERT INTO cakYNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Xpa re Jesús xubij chique: Re je'banon invitar pa jun c'ulubic siempre ye'va', roma re ala' xc'ule' c'o quiq'uin, y quire' chuka' niquiban re nu-discípulos, reje' ye'qui'cot roma yinc'o quiq'uin, pero xtapon re k'ij tak re ala' re' xtilisas-a chiquicojol, y c'ajare' tak xtiquiban ayuno. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Y chuka' man jun vinak nicusan jun c'ojobal c'ac'a chin nuc'ajoj jun tziak re tzia'k chic. Roma jun c'ojobal c'ac'a man otz-ta nuban riq'uin re tziak re tzia'k chic, roma nuc'ol-ri', y mare' re tziak re tzia'k chic xa más niretzetaj-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y quire' chuka' man jun vinak niyi'o vino c'ac'a chupan jun tz'um tzia'k chic chin nuyac-apo. Roma re tz'um tzia'k chic man chic nuyuk-ta-ri', mare' vo xa niyac vino chupan re tz'um re' nurokch'ij-ri' y nitix-a re vino c'o chupan. Y re tz'um re' manak chic ndoc-va. Pero chupan jun c'ac'a tz'um, otz niyac c'ac'a vino chupan, roma re tz'um re' nuyuk-ri' y man nurokch'ij-ta-ri'. Ja quire' nubij re ejemplo re xubij re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y tak re Jesús c'a ntajin chutzijosic ronojel re' chiquivach re vinak, c'o jun ache camas ruk'ij xapon riq'uin y xbexuque' chach y c'are' xubij cha: Re numi'al can c'aja-oc nicom-ka, tabana' utzil natz'eta-ta ba' chin che na'ya' ak'a' pa rue' che nuna' chic rach, xcha' re ache cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xpa re Jesús xyacataj-a je ruchibil re ru-discípulos xe'ba chij re ache. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y c'o c'a jun ixok niyavaj. Re ixok re' doce juna' tuc'alvachij-va jun yabil, y re yabil re rubanon re ixok re' ja re nibiyin ruq'uiq'uel. Xpa re ixok re' xjelon-apo chij can re Jesús, y xtiquir xbo'rtz'ama' can ba' ruchi-rutziak. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Roma re ixok re' can rubim-pa pa ránma che xa riq'uin xquintiquir xte'ntz'ama' can ba' ruchi-rutziak re Jesús, can yinc'achoj. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero re Jesús cha'nin xunabej mare' xtzu'un can chij. Y tak xutz'at anchique xtz'amo ruchi-rutziak, c'are' xubij cha re ixok re': Numi'al, xac'achoj, roma xaban confiar-avi' viq'uin. Vocame man chic cabison, xcha' cha re ixok. Y can jare' xc'achoj re ixok cha re ruyabil ruc'alvachin. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y tak xoc-apo re Jesús pa rachoch re ache camas ruk'ij, re Jesús xutz'at che re vinak can je'elinak ch'o'j y chuka' jec'o chic re musiqueros chin ne'muk can re xtan. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpa reja' xubij chique re vinak: Tibana' utzil quixel-a ba' y kojc'ue-na can kayon, roma re xtan xa man quiminak-ta, reja' xa nivar, xcha' chique. Pero reje' xa xe'tze'en chij re Jesús, roma quitaman che quiminak chic re xtan. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y tak je'elinak chic-a re vinak, re Jesús xoc-apo chupan re cuarto re anche' c'o-va re xtan quiminak. C'are' re Jesús xutz'am ruk'a' re xtan, y re xtan can xc'astaj chic-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Y re xbanataj chire', can xba rutzijol pa tak tenemit re jec'o chupan re lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y tak re Jesús elinak chic-a chire', jec'o je ca'e' moyi' can je'tzakatal chij y cof ye'ch'o y niquibij cha: ¡Tajoyovaj kavach y kojato', rat re yat rey-rumam can re Rey David! ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tak re Jesús xapon pa jay, re je ca'e' moyi' can xe'bapon chuka' riq'uin. Y re Jesús xuc'utuj chique: ¿Y yex can ninimaj che yen yintiquir nimban chiva che yixtiquir yixtzu'un? Y re moyi' xquibij: Ja', Ajaf. Nakanimaj che quire' nibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpa re Jesús xutz'am re quinak'avach che je ca'e' y xubij chique: Roma yex ninimaj che yen yintiquir yixinc'achojsaj, can tibanataj re nirayij. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y jare' tak reje' xquina' che re quinak'avach can xjakataj, y xe'tzu'un. Pero re Jesús camas xuchalabej-a chique: Can tic'axaj-a jabal re xtimbij-a chiva, che re xbanataj iviq'uin, can man-ta jun vinak xtic'axan. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero tak reje' je'elinak chic-a chire' riq'uin re Jesús, xa xquitz'am rutzijosic chupan ronojel re lugar re', re xuban re Jesús quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y tak xe'el-pa re je ca'e' achi'a' re je moyi' rubanon can, jare' tak jec'o chic nic'aj vinak xe'oc can riq'uin re Jesús, y re vinak re' quic'uan-apo jun ache re can mem rubanon pa ruk'a' jun itzel espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y re Jesús can xulisaj-a re itzel espíritu riq'uin re ache. Re ache can jare' xch'o chic jun bey. Y re vinak re xe'tz'eto re xbanataj xsatz quic'o'x y xquibij: Man jun bey katz'eton che quire-ta banatajnak vova' pa nación Israel, ye'cha' c'a chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero re achi'a' fariseos niquibij che re Jesús xa ja re quijoval re itzel tak espíritu re c'o riq'uin, mare' tak nitiquir ye'rulisaj-a re itzel tak espíritu, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Re Jesús ronojel tenemit y aldea nibiyaj-va, ye'rutijoj re vinak riq'uin re ruch'abal re Dios, pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y chuka' nutzijoj re utzulaj ch'abal chin re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios, re nibex evangelio cha. Y can ronojel rach yabil y k'axomal quic'uan re vinak ye'ruc'achojsaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y tak xe'rutz'at che je q'uiy vinak, reja' camas xujoyovaj quivach, roma can quion-oc jec'o y quiquiran-qui', can ancha'l niquiban re ovejas tak man jun nichajin quichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jare' tak re Jesús xubij chaka yoj re yoj ru-discípulos: Can katzij-va che re samaj chin nitzijos re ruch'abal re Dios, camas nem, jac'a re samajela' man je q'uiy-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mare' tic'utuj cha re Rajaf re samaj, che que'rutaka-pa más samajela' chiquicojol re vinak re nic'atzin che niquic'axaj re ruch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y re Jesús xojrayoj che yoj doce re yoj ru-discípulos, y xuya' poder chaka chin che yojtiquir ye'kalisaj re itzel tak espíritu, y chin chuka' che yojtiquir ye'kac'achojsaj xabanchique rach yabil y k'axomal re ndoc chique re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Y ja quire' re kabe' cada jun chaka yoj re yoj doce discípulos re yojtak chubanic re samaj, y re nabey be'aj ja chin re Simón re nibex chuka' Pedro cha, re Andrés re ruch'alal re Simón Pedro, y re Jacobo y re Juan re je ca'e' ruc'ajol jun ache rubini'an Zebedeo, ");
INSERT INTO cakYNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","re Felipe, re Bartolomé, re Tomás, y yen Mateo re molay-impuestos, y re Jacobo ruc'ajol jun ache rubini'an Alfeo, re Lebeo re nibex chuka' Tadeo cha, ");
INSERT INTO cakYNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","y re jun Simón re c'o quiq'uin re achi'a' re je richin re jun partido nibex cananista chique, y re Judas Iscariote re xjacho chin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y ja yoj doce achi'a' re' re xojrutak-a re Jesús chutzijosic re ruch'abal re Dios, xojrupaxabaj-a, y ja quire' re xubila-a chaka: Man quixba quiq'uin re vinak re man je israelitas-ta. Y chuka' man quixoc-apo pa tak tenemit re jec'o chire' pa Samaria. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xa ja quiq'uin re kavinak israelitas re je'satzanak pa quimac quixoc-va-apo. Roma reje' can ancha'l niquiban re ovejas je'satzanak quire' quibanon. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y mare' yex can te'itzijoj re ruch'abal re Dios y tibij chique, che nakaj chic c'o-va re k'ij chin che yixoc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'ic'achojsaj re ye'yavaj. Re vinak re c'o yabil rubini'an lepra chiquij, can tibana' chique che can nich'ojch'ojer re qui-cuerpo. Que'ic'asoj re je quiminak chic. Can que'lisaj chuka' re itzel tak espíritu. Y tak yex niban ronojel re utzil re', man tibij chique che can tiquitojo' chiva roma re utzil xiban chique, roma can tiya' pa cuenta che ronojel re poder re', xa sipan chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Man tinimila-a mero pa tak ximibal-ipan. Can man jun rach mero tic'uaj-a. Man tic'uaj-a mero re banon cha re jun ch'ich' re nibex cobre cha, man tic'uaj-a chuka' re banon cha sakapuak, y ni xe-ta re banon cha k'anapuak. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Y man tic'uaj-a chuka' iya'l. Man tic'uaj-a chuka' jun chic itziak, xa can xe re c'o chivij. Chuka' man tic'uaj-a jun chic c'ulaj ixajab, y chuka' man tic'uaj-a ich'ama'y. Can man jun re ximbij-yan-ka tic'uaj-a. Roma re samajel xabanchique lugar napon-va, can ruc'amon che nuc'ul re nic'atzin cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Y tak yixapon pa jun tenemit o pa jun aldea, re niban nabey ja che ticanoj jun vinak re c'o i-confianza riq'uin chin che yixapon pa rachoch. Y can chire' quixc'ue-va-ka, y c'aja tak yixel-a chupan re tenemit re', c'ajare' otz niya' can re jay re anche' xixc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y tak yixoc-apo pa jay re anche' nic'utuj-va i-posada, can tiya' ruxnokil-quivach re je rajaf re jay. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Y tibij chique: Can ja-ta re paz re pitinak riq'uin re Dios re nic'ue' pa tak ivánma. Y vo xa can ruc'amon-va che yex yixc'ue' chire' pa cachoch, re cánma re vinak re' can xtuna' re paz re pitinak riq'uin re Dios, y vo xa man ruc'amon-ta che yex yixc'ue' quiq'uin pa tak cachoch, re cánma re vinak re' can man xtuna-ta re paz re pitinak riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y vo xa man otz-ta yixquic'ul, y can man niquijo-ta niquic'axaj chuka' re ruch'abal re Dios re nitzijoj yex chique, can quixel-pa quiq'uin chire' pa cachoch o sea pa quitenemit. Y titavaj can re pokolaj c'o pa tak ivakan chiquivach re vinak, chin tiquitamaj che man otz-ta re xquiban chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Roma yen can katzij nimbij chiva, che chupan re k'ij tak xtibanataj re juicio, re castigo re xtika pa quive' re vinak re xe'c'ue' pa tenemit Sodoma y Gomorra man can-ta xtak'ax rue', que chach re xtika pa quive' re vinak chin re tenemit re man otz-ta ic'ulic xtiquiban. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vocame yixintak-a, y yex itaman che xa ancha'l ch'utak ovejas re yixe'ka chiquicojol re vinak re je ancha'l utif. Pero can tibana' ancha'l nuban re cumatz, roma reja' can cha'nin nuna' tak c'o jun pitinak. Y can tibana' chuka' ancha'l nuban jun paloma, roma reja' can man jun etzelal c'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Can tichajij-i'vi', chin che man xe tal choj quire' ne'iliba-ivi' pa quik'a' re vinak re ye'tzelan ivichin. Roma reje' can xquixquijach pa quik'a' re achi'a' re pa camon ye'bano juzgar, y chuka' re vinak re' xtiquiban chiva che yixch'ay chire' pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Y xquixquic'uaj chuka' chiquivach re achi'a' re ye'bano gobernar, y chuka' xquixc'uax chiquivach reyes y chiquivach chuka' re nic'aj chic ye'bano juzgar chach re ruch'ulef. Y xa nutzij yen tak quire' xtiban chiva, pero can xquixtiquir xquinitzijoj chiquivach reje' y chiquivach chuka' re vinak man je israelitas-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Pero tak re vinak xquixquijach pa quik'a' re autoridades, man timay re andex che tzij re xtibij chique y re andex xtiban tak xquixch'o chiquivach. Roma chupan re hora re', re Dios xtuya' ch'abal chiva y can xtuc'ut chivach andex xtiban tak xquixch'o. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Roma ja re Espíritu Santo chin re Dios re xtibano chiva re andex che tzij nibij. Mana-ta c'a yex re xquixch'o, xa can ja re Espíritu chin re Irta' Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y can xtibanataj, vo xa jec'o je ca'e' achi'a' quich'alal-qui', re jun xtiyacataj chij re jun chic ruch'alal y xtujach chin che niquimisas. Y can jec'o-va chuka' tata'aj re xque'yacataj chiquij re cajc'ual. Y re cajc'ual xque'yacataj chuka' chiquij re quite-quirta' y xque'quijach chin che que'quimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Can conojel-va xque'tzelan ivichin roma ibanon confiar-ivi' viq'uin. Pero re man xtutzolij-ta-ri' chij y xtucoch' xtuk'asaj ronojel re' c'a pa ruq'uisibal, can xticolotaj-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y tak re vinak re jec'o chupan jun tenemit yixquiya' pa tijoj-pokonal, otz yixel-a chupan re tenemit re' y quixnumaj-a chiquivach y quixbiyin pa jun chic tenemit. Roma can katzij nimbij chiva che yex can c'amaje-na quixapon pa tak ronojel tenemit re jec'o vova' pan Israel, tak yen re xinalax chi'icojol xquimpa chic jun bey. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Man jun vinak re c'aja nutijoj-ri', re c'o-ta más ruk'ij que chach re nitijon richin. Y chuka' man jun mozo re c'o-ta más ruk'ij que chach re ru-patrón. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Re jun vinak re nitijox roma jun maestro can niqui'cot tak napon ancha'l re ru-maestro. Y re mozo ancha'l re ru-patrón. Y mare' vo xa yen re ancha'l tata'aj chi'icojol xbex Beelzebú re cajaf re itzel tak espíritu chua, c'alapa' chiva yex che man-ta quire' xtibex chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Man tixibij-ivi' chiquivach re vinak, roma can nic'atzin che nisekresas ivoma yex, re man can-ta jabal sekresam-pa. Can nic'atzin che nitamax re tz'apin rij. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ronojel re tzij re ye'mbij chiva, man que'c'ue' can pa k'oko'm, xa can tilisaj-pa pa sakil. Re ximbij chiva pa tak ixquin, man tivovaj y man xaxe pan ivánma yex tic'ue-va-ka, xa quixjote' c'a pa rue' re ivachoch y c'a chire' tiya-va-pa rutzijol. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixibij-ivi' chiquivach re vinak re ye'quimisan re i-cuerpo, roma después man jun chic andex ye'tiquir niquiban chiva, roma re ivánma man ye'tiquir-ta niquiquimisaj. Pero chach re jun re nitiquir nutak re ivánma y re i-cuerpo pan infierno, chach reja' sí can ruc'amon che nixibij-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yex can jabal itaman che tak ye'lok' je ca'e' ch'utak chicop c'o quixic' re ye'ba pa cak'ik', xaxe-oc jun centavo cajal. Pero man jun chique reje' re xtitzak-ta pan ulef vo xa man ru-voluntad-ta re Irta' Dios, man riq'uin re' che ch'utak chicop re' camas ba-oc cajal. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","C'alapa' c'a yex. Roma hasta re rusumal-ive' ejelan. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Re Dios man jun bey yixrumistaj-ta can. Re Dios camas yixrajo', roma yex camas-va yixjovax que chiquivach re ch'utak chicop re c'o quixic' re ye'ba pa cak'ik', y mare' man tixibij-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Xabanchique vinak re man niq'uex-ta nubij che yinruniman chic, yen chuka' man xquinq'uex-ta xtimbij che re vinak re' vichin chic yen. Y re tzij re' can chach c'a re Nata' Dios re c'o chila' chicaj xtimbij-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Jac'a re vinak re niq'uex nubij che yinruniman chic, yen chuka' can xquinq'uex xtimbij-apo cha re Nata' Dios re c'o chila' chicaj, che re vinak re' vichin yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man tinojij che yen ximpa chach re ruch'ulef chin che junan ivach nimban chiva. Man quire-ta. Xa nutzij yen xque'jalajo' re vinak y xtiquitz'amala-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Yen ximpa chach re ruch'ulef chin che nitz'ucutaj ayoval chiquicojol re vinak. Quire' xtibanataj pa tak jay. Re ache man xtika-ta chach re nubij re rutota' cha. Re ixok man xtika-ta chach re nubij re rute' cha. Y quire' chuka' re elibatz man xtika-ta chach re nubij re rulite' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Re vinak re rubanon confiar-ri' viq'uin, can jac'a re jec'o pa rachoch re xque'tzelan richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Re vinak re xa ja re rute-rutota' re más xque'rajo' que chinoch yen, can man ruc'amon-ta che nitzake' chuij. Re te'ej-tata'aj re xa ja re cajc'ual re más ye'quijo' que chinoch yen, can man ruc'amon-ta che yinquitzekelbej. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun vinak re can nrajo' nitzake' chuij, nic'atzin che man tupokonaj nuk'asaj tijoj-pokonal nutzij yen, can ancha'l che binak chuxe' ru-cruz. Jac'a re vinak re camas nupokonaj nuk'asaj tijoj-pokonal nutzij yen y man nrajo-ta yinrutzekelbej, man ruc'amon-ta che ndoc vichin yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Roma xa ja re c'aslen chin vova' chuch'ulef re nrajo' y mare' man xtuvel-ta ruc'aslen re man niq'uis-ta. Jac'a re vinak re man nupokonaj-ta nuk'asaj tijoj-pokonal y astapa' niquimisas nutzij yen, can xtuvel ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Re jun vinak re can otz yixruc'ul yex re yixintak-a pa samaj, can jac'a chuka' yen re yinruc'ul. Y re nic'ulu vichin yen, can nuc'ul chuka' re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Re vinak re otz nuc'axaj re ruch'abal re Dios, mare' otz ruc'ulic nuban jun rusamajel re Dios re nibex profeta cha, re vinak re nic'axan re ch'abal can junan rajal-ruq'uixel xtuc'ul riq'uin re profeta re nitzijon re ch'abal. Y quire' chuka' re vinak re otz nutz'at jun c'aslen choj y mare' can niqui'cot nuc'ul jun vinak re can choj-va ruc'aslen, re vinak quire' nibano, can junan rajal-ruq'uixel xtuc'ul riq'uin re vinak choj ruc'aslen. Re vinak re runiman chic re Jesucristo can man niq'uex-ta nubij che runiman chic. ");
INSERT INTO cakYNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y xabanchique vinak ye'rajo' re vinak re yinquitzekelben yen re manak can-ta quik'ij, can c'o rajal-ruq'uixel xtuc'ul. Y can katzij nimbij chiva, che astapa' xa ba' rax-ya' re nuya' chique, can c'o rajal-ruq'uixel xtuc'ul. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y tak re Jesús xuq'uis rubixic chaka yoj re yoj doce ru-discípulos re andex che samaj nakabana', reja' xba pa tak nic'aj chic tenemit re jec'o chire' pan Israel, chuc'utic y chutzijosic re ruch'abal re Dios chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Re samaj re nuban re Cristo xapon rutzijol riq'uin re Juan Bautista pa cárcel, mare' tak xpa re Juan xe'rutak-a je ca'e' chique re achi'a' can je tzekelbey-va richin, c'a riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Y xbequic'utuj cha: ¿La ja como rat re Cristo re bin che nitak-pa roma re Dios? ¿O jun chic-va, y can c'amaje-na te'ka? Ja quire' xbequibij re je ca'e' achi'a' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y re Jesús xubij chique: Vocame quixtzolaj y titzijoj cha re xitz'at can y re xic'axaj-a vova'. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Te'itzijoj cha re andex rubanic tak re moyi' ye'tiquir ye'tzu'un, andex rubanic tak re vinak je cojos choj ye'biyin-a y andex rubanic tak ye'c'achoj-a re c'o yabil rubini'an lepra chiquij. Titzijoj chuka' cha re andex rubanic tak ye'c'achoj-a re je tocon, re je quiminak chic ye'c'astaj, y re vinak re meba' cánma chach re Dios, nimbij re utzulaj ch'abal chin re Dios chique, re nibex evangelio cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Y tibij chuka' cha, che otz-rubanoj re jun vinak ancha'l reja', re rubanon confiar-ri' viq'uin y man jun bey yinrumalij-ta can, xe'cho'x-a re je ca'e' achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y tak xe'tzolaj re je ca'e' achi'a' re je'rutakon-a re Juan Bautista, re Jesús xutz'am can tzij chij re Juan chiquivach re vinak re jec'o chire'. Y ja quire' re nubila': ¿Andex re' re xbe'itz'eta' chupan re lugar re anche' manak vinak re nibex desierto cha? Yex man xitz'at-ta jun ache chire', re ancha'l aj, re niba quila niba quila pa ruk'a' re cak'ik'. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Andex re xbe'tz'eta' chire'? Yex chuka' man xitz'at-ta chire' jun ache re jabal ruvekon-ri'. Re achi'a' re jabal quivekon-qui', rion pa tak cachoch reyes ye'c'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pero andex re xbe'itz'eta' chire' chupan re lugar anche' manak vinak re nibex desierto cha? Yex xbe'itz'eta' jun ache rusamajel re Dios re nibex profeta cha. Re ache re xitz'at chire' can ja-va re' re rusamaj. Pero can c'o-va más ruk'ij que chach xabanchique profeta. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Y chij c'a re Juan nich'o-va re Dios chupan re ruch'abal re tz'iban can, y nubij: Xtintak c'a jun ache nabey, chin che nuchojmersaj re bey anche' xtapon-va re Cristo. Quire' nubij re Dios chupan re ruch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Y tic'axaj jabal re xtimbij chiva vocame: Jenipa' achi'a' re je rusamajela' re Dios re nibex profetas chique re je'alaxnak chach re ruch'ulef, man jun re c'o-ta más ruk'ij que chach re Juan Bautista. Roma reja' can c'o-va más ruk'ij. Jac'a vocame conojel re vinak re ye'oc pa ruk'a' re Dios, camas c'a nem quik'ij. Y re vinak re más ba-oc ruk'ij chiquicojol re ye'oc pa ruk'a' re Dios, jare' re más nem ruk'ij que chach re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Y desde que re Juan Bautista xutz'am rutzijosic re ruch'abal re Dios c'a chupan re k'ij re', re vinak camas niquiban chin che ye'oc pa ruk'a' re Dios. Can niquivach'-qui' chij y re más ye'bano quire', ja re can riq'uin ronojel cánma ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Roma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, c'o cosas quibin can chij tak re vinak ye'oc pa ruk'a' re Dios. Y quire' chuka' nubij chupan re ley chin re Moisés. Pero c'aja chupan re tiempo chin re Juan xe'banataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Vo xa yex ninimaj o man ninimaj-ta, pero re nimbij chiva yen che re nubij re ruch'abal re Dios re tz'iban can che nipa chic jun bey re Elías man quire-ta, roma re' xa chij re Juan nich'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij! ");
INSERT INTO cakYNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Re vinak chin re tiempo re' can je junan quiq'uin re ac'ola' re ye'tz'an pa tak q'uiybal y jun pa quichi' niquibila' chiquivach: ");
INSERT INTO cakYNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Xkak'ojmaj xul chivach, pero man xixajo-ta. Xkabixaj bix re can nuyac abis, pero man xixok'-ta, quire' niquibila' re ac'ola' tak ye'tz'an. Y ja quire' quibanon re vinak chin re tiempo re', man jun re nika chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Roma tak xpa re Juan Bautista, reja' man nutaj-ta xcana-vay y man nukum-ta chuka' ruyi'al-uva. Y je q'uiy ye'bin che reja' c'o itzel espíritu riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y tak xineka yen re xinalax chi'icojol, nintaj xcana-vay y ninkum chuka' ruyi'al-uva. Y je q'uiy ye'bin che xaxe va'in ninjo' nimban, y chuka' niquibij che yen xa yin jun k'abarel, y chuka' niquibij che xa yin quichibil re molay tak impuestos y re vinak re nibex aj-maqui' chique. Pero re runa'oj re Dios can nik'alajin pa quic'aslen re vinak re ye'niman richin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jec'o tenemit re camas q'uiy milagros xban chiquivach roma re Jesús. Pero man riq'uin re' re vinak re jec'o chupan re tenemit re' cama-va xjalataj-ta re quic'aslen chach re Dios. Y mare' re Jesús q'uiy cosas xubij chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Reja' xubij: Ninvok'ej quivach re jec'o pa tenemit Corazín, y chuka' ninvok'ej quivach re jec'o pa tenemit Betsaida, roma camas q'uiy milagros xe'ban chiquivach y man riq'uin re' xquinimaj-ta re ruch'abal re Dios. Roma xe-ta chupan re tenemit Tiro y Sidón xe'ban-va re milagros re', re vinak re' xjalataj-yan-ta re quic'aslen chach re Dios, y quicusalon-ta chic tziak ancha'l niquicusaj re vinak tak c'o jun nicom chiquivach, y xquiyala-yan-ta chaj chiquij, chin quire' nik'alajin che ye'bison roma camas mac re je'quibanalon. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero chupan re k'ij tak re Dios xtuban juzgar, yen nimbij chiva che ja re vinak jec'o pa tenemit Corazín y re jec'o pa tenemit Betsaida re c'o más castigo xtika pa quive', que chiquivach re aj-Tiro y re aj-Sidón. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y re vinak jec'o pa tenemit Capernaum niquinojij che xque'ba chila' chicaj riq'uin re Dios y can xtiya' quik'ij. Pero xa man quire-ta. Xa xtikasas quik'ij, roma c'a pan infierno xque'beka-va. Roma xe-ta ronojel re milagros re xban chiquivach re aj-Capernaum, ja-ta re' re xban chiquivach re aj-Sodoma, xquinimaj-ta re Dios y man-ta xe'q'uis. Xa c'a jec'o-ta re k'ij vocame. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero chupan re k'ij tak re Dios xtuban juzgar, yen nimbij chiva che ja re jec'o pa tenemit Capernaum re c'o más castigo xtika pa quive', que chiquivach re xe'c'ue' pa Sodoma. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y ja mismo hora re' tak re Jesús xubij: Nintioxij chava Nata' Dios, rat re yat Rajaf re rocaj y re ruch'ulef, roma man xasekresaj-ta re andex ndel-va che tzij re ach'abal chiquivach re vinak re can niquina' che camas quitaman. Xa ja chiquivach re vinak re manak más quitaman, xa ja chiquivach reje' xasekresaj-va re andex ndel-va che tzij re ach'abal. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can ja-va c'a quire' Nata' Dios, roma ja quire' re xarayij rat che naban, xcha' re Jesús chupan re ru-oración. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y c'are' reja' xubij: Re Nata' Dios can ronojel ruyi'om-pa pa nuk'a'. Y man jun chic atamayon yin anchique yen, xaxe re Nata' re atamayon. Y man jun chuka' atamayon anchique re' re Nata', xaxe yen re Ruc'ajol, y re vinak anchok cha xtinjo' xtinc'ut-va, xtutamaj rach anchique re' re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixampa viq'uin chiyixnojel yex re camas itijon ik'ij chucanoxic re rubey re Dios, y camas yixcosnak chuc'uaxic re ejka'n camas ralal c'o chivij, roma yen can xtimban chiva che yixuxlan chach ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Y jac'a re nu-yugo yen re tiya-a chij ive' yex, roma ja re vichin yen re man c'ayef-ta ruc'uaxic y man al-ta. Quinitz'eta' yen, che yen can ch'o'l re vánma y can nbanon che manak nuk'ij. Y quire' chuka' tibana' yex. Can tic'uaj re nu-yugo yen, chin che re ivánma can-ta xtuna' che xte'xulan, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Y chupan re tiempo re' pa jun k'ij chin uxlanen, re Jesús y yoj re yoj ru-discípulos xojak'ax chupan jun ulef ticon trigo chach. Y yoj re yoj discípulos xe'kach'upula' rue-trigo chin xkataj, roma camas nich'umun kapan. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y re achi'a' fariseos xojquitz'at che quire' katz'amon rubanic, mare' xquibij cha re Jesús: Ca'tz'eta' re a-discípulos roma man otz-ta ye'tajin chubanic. Can man ruc'amon-ta che ye'samaj chupan jun k'ij chin uxlanen ancha'l re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero re Jesús xubij chique: Yex can ibanon leer re tz'iban can chij re xquiban re David y re ruchibil ajuer can, tak camas xch'umun quipan. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Re David xba chucanoxic vay chire' pa rachoch re Dios, y can ja re lok'olaj tak xcana-vay re xe'beya-pa cha. Y re xcana-vay re' xaxe re sacerdotes re ye'tijo richin. Pero reja' xutaj y chuka' re je'binak riq'uin can xquitaj. Pero astapa' reje' quire' xquiban manak quimac xel chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yen ninojij che yex can ibanon-va leer chuka' re nubij chupan re ley chin re Moisés. Y chuka' can itaman che re sacerdotes can ye'samaj-va pa rachoch re Dios chupan re k'ij chin uxlanen y reje' man xajan-ta tak quire' niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Y vocame, yex nitz'at che c'o Jun vova' re c'o más ruk'ij que chach re rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xe-ta yex itaman-ta andex ndel-va che tzij re nubij chupan re ruch'abal re Dios, man-ta xibij che re nu-discípulos man otz-ta re ye'tajin chubanic. Roma chupan re ruch'abal re Dios nubij: Re más nika chinoch yen ja-ta che yex yixjoyovan, que chach ye'sujula' chicop je'quimisan chinoch. Quire' nubij re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Y jac'a yen re xinalax chi'icojol re Rajaf re k'ij chin uxlanen, pa nuk'a' yen c'o-va chin nimbij andex otz che nimban chupan re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y tak xtzolaj-yam-pa re Jesús y chibil chuka' yoj re yoj ru-discípulos, xojba chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y chire' chiquicojol re vinak re quimalon-qui', c'o jun ache chake'j jun ruk'a'. Xe'pa re vinak re' xquic'utuj cha re Jesús: ¿Ruc'amon como che nic'achojsas jun niyavaj pa jun k'ij chin uxlanen? Quire' re xquibij cha roma niquijo' ye'yacataj chij y c'are' niquisujuj. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xpa re Jesús xubij chique: C'o-ta jun chiva yex achi'a' re c'o-ta jun ru-oveja y nitzak-ta pa jun pozo chupan jun k'ij chin uxlanen, ¿andex-ta como nuban riq'uin? ¿La xaxe-ta como tal quire' nuya' can chire'? ¿Peja' que man xtuban-ta quire'? Xa can nutaj ruk'ij chin nulisaj-a chupan re pozo. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","C'alapa' jun vinak che man-ta otz niban jun utzil cha, roma camas-va ruk'ij que chach jun oveja. Xa mare' tak can ruc'amon-va che niban re otz tak banabal chupan jun k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Y c'ajare' tak re Jesús xubij cha re ache chake'j ruk'a': Tayuku' la ak'a'. Y re ache can xe xuyuk re ruk'a', can jare' xc'achoj, y can ancha'l re jun chic ruk'a' quire' xuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y re achi'a' fariseos can xe xquitz'at can che quire' xuban riq'uin re ache niyavaj, xe'ba y xbequimola-qui' chin niquinojij andex niquiban, roma niquijo' niquiquimisaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Y tak re Jesús xunabej re niquinojij chij xel-a chire'. Y camas je q'uiy vinak xe'tzake-a chij. Y can ye'ruc'achojsaj conojel re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero reja' camas nuchalabej-a chique re ye'ruc'achojsaj-a che man tiquilisaj rutzijol che ja reja' re xc'achojsan-a quichin cha re quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chin quire' can nibanataj re rubin can re Dios cha re Isaías re rusamajel re xc'ue' ajuer can, re xbex profeta cha. Y re rutz'iban can reja' ja quire' nubij: ");
INSERT INTO cakYNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jare' re Nusamajel re ncha'on. Yen camas ninjo' reja', can niqui'cot-va re vánma riq'uin. Can xtinya-pa chuka' re nu-Espíritu pa rue', y reja' xtutzijoj chiquivach re vinak re man yinquiniman-ta, y re xtutzijoj reja' ja re andex nic'atzin-va re c'aslen choj. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man xtuban-ta ayoval, man xturak-ta ruchi' roma ruyoval, y mana-ta chij reja' mismo xtuya-va rutzijol chiquivach re vinak pa tak calles. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y astapa' re ruc'aslen jun vinak ancha'l-ta jun aj cotoquic rij, reja' can man xtuk'aj-ta. Chuka' vo xa re ruc'aslen jun vinak ancha'l-ta jun rutza'n si' nibuku roma nichup-yan-ka, reja' can man xtuchup-ta. Y nojel tiempo quire' xtuban-apo, c'a jampa' xtapon re k'ij tak reja' xtuban che xtic'ue' re utzulaj ru-gobierno. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y re vinak re c'amaje-na quinquinimaj, can xtic'ue' qui-esperanza che ja reja' re xticola quichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y c'o c'a jun ache moy y mem ec'uan-apo chach re Jesús, y reja' quire' rubanon roma c'o jun itzel espíritu riq'uin. Y re Jesús xulisaj-a re itzel espíritu riq'uin re ache. Can xuban cha che xch'o y xtzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y mare' conojel re vinak can anchique-la xquina' tak xquitz'at y niquibila': ¿Mana-ta como re' re Cristo re rey-rumam can re David re bin che nitak-pa roma re Dios? ");
INSERT INTO cakYNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero tak re achi'a' fariseos xquic'axaj re niquibij re vinak chij re Jesús, reje' xquibij: Re Jesús ye'rulisaj itzel tak espíritu pero xa pa rube' re Beelzebú re quijoval re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Pero re Jesús can rutaman re andex niquinojela' re achi'a' fariseos pa tak cánma, mare' reja' xubij chique: Vo xa re vinak chin jun nación man niquinojij-ta y ca'e' quivach niquiban, nipa ayoval chiquicojol. Y re' man otz-ta, roma nuban cha re nación che nitzak. Y quire' chuka' vo xa jun tenemit o vo xa jun familia pa jay, vo xa c'o ayoval chiquicojol y man chic otz-ta niquitz'at-qui', xa can xque'q'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y quire' chuka' nibanataj riq'uin re Satanás, vo xa ye'rukotaj-a re itzel tak espíritu re jec'o riq'uin, can ndel che tzij che rion reja' nic'ue' can, roma can chij reja' mismo niyacataj-va-ka, y vo xa rion xtic'ue' can, can man nitiquir-ta nuban gobernar. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yex nibij chuij, che yen pa rube' re Beelzebú tak yintiquir ye'nlisaj re itzel tak espíritu, yex quire' ninojij chuij ¿y andex como nibij chiquij re ye'tzekelben ivichin? Roma reje' ye'tiquir chuka' ye'quilisaj re itzel tak espíritu. ¿Anchique como ya'yon poder chique reje' chin ye'tiquir chuka' niquiban quire'? Mare' ja re ye'tzekelben ivichin jare' re ye'sekresan che man otz-ta re nibij yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yen yintiquir ye'nlisaj itzel tak espíritu roma can ja re ru-Espíritu re Dios re c'o viq'uin. Xa can xbeka-yan re k'ij che conojel can ruc'amon che niquinimaj rutzij re Dios y ye'c'ue' pa ruk'a' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y re vinak re nrajo' nelak'-a pa rachoch jun ache re camas ruchuk'a', nabey nuxim ruk'a-rakan re ache, y c'are' nitiquir nucanoj-a ronojel re nrajo' ye'ruc'uaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Mare' re vinak re man nrajo-ta nic'ue' viq'uin, xa ja riq'uin re Satanás nrajo' nic'ue-va. Y anchique vinak re man nuban-ta re nusamaj, xa nuyoj re nusamaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y mare' nimbij chiva: Re mac y re itzel tak tzij re ye'quibila' re vinak chin niquiyok' rube' re Dios, xa can ye'cuyutaj-va re quimac. Jac'a vo xa niquiyok' re Espíritu Santo, can man xque'cuyutaj-ta re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y xabanchique vinak re man otz-ta nich'o chuij yen re xinalax chi'icojol, can nicuyutaj re rumac. Jac'a re anchique man otz-ta nich'o chij re Espíritu Santo, can man xticuyutaj-ta rumac re tiempo yojc'o-va vocame, y ni xe-ta chupan re tiempo re chakavach-apo. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Y tak jun che' otz, can otz re rach nuya', y re che' man otz-ta, can man otz-ta chuka' rach nuya'. Mare' jun che' ja tak nuya' rach jare' tak nik'alajin che otz o man otz-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Y yex xa yix ancha'l itzel tak cumatz, mare' man yixtiquir-ta ninojij y nibij cosas otz, roma xa ja re etzelal c'o iviq'uin. Roma jun vinak can ja re jec'o pa ránma jare' re nuban y nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzulaj ache can ja re otz tak cosas jare' re nubij, roma can ja re otz nunojij pa ránma. Jac'a re mal ache ja re itzel tak cosas nubij, roma jare' re nisamaj pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y yen nimbij chiva che chupan re k'ij tak re Dios xtuban juzgar, re vinak re xe'bin re tzij re manak rajkalen, ja reje' re xtika re castigo pa quive', quire' xtiban chique roma ronojel re tzij re manak rajkalen xe'quibila'. Jun che' ja tak nuya' rach jare' tak nik'alajin che otz o man otz-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Re vinak re ye'bin otz tak tzij, jare' re nibano chique che manak quimac ndel chach re Dios. Jac'a re ye'bin re tzij man otz-ta, jare' re nibano chique che c'o quimac ndel chach re Dios, tak reja' xque'ruban juzgar. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jec'o chique re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas y jec'o chuka' chique re achi'a' fariseos xe'ch'o-apo cha re Jesús, y xquibij: Maestro, nakac'utuj chava che tabana' jun señal chakavach. Chin quire' can nac'ut chakavach che can ja re Dios re takayom-pa avichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero re Jesús xubij chique: Yex re yixc'o chupan re tiempo vocame camas yix mal tak vinak, y can man ninimaj-ta re Dios. Can nijo' nitz'at che yen nimban-ta jun señal chin quire' yininimaj. Pero mana-ta re nijo' yex re xtibanataj. Xa can xe re xbanataj riq'uin re jun ache re xubini'aj Jonás, re rusamajel re Dios re xc'ue' ajuer can re xbex profeta cha, xaxe re señal re' re niya' chiva yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Roma re Jonás oxe' k'ij y oxe' ak'a' xc'ue' chupan jun moma' car. Y quire' chuka' re señal re ninya' yen chivach. Yen re xinalax chi'icojol, xquinc'ue' chuka' oxe' k'ij y oxe' ak'a' chuxe' ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y tak xtapon re k'ij tak re Dios xque'ruban juzgar re vinak re jec'o vocame, xque'c'astaj-pa re vinak re xe'c'ue' ajuer can pa tenemit Nínive y xtiquibij che man otz-ta xquiban re vinak re jec'o chupan re tiempo vocame, roma man xinquinimaj-ta. Roma re vinak re xe'c'ue' pa tenemit Nínive can xe xquic'axaj re ruch'abal re Dios re xutzijoj re Jonás chique, can jare' tak xquinimaj y xjalataj quic'aslen chach re Dios. Y vocame yinc'o yen re c'o más nuk'ij que chach re Jonás, y re vinak xa man yinquinimaj-ta, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y chuka' tak xtapon re k'ij chin xque'ban juzgar re vinak re jec'o vocame, xte'c'astaj-pa re jun reina re xc'ue' pa Sabá. Re reina re' xtubij che man otz-ta xquiban re vinak re jec'o chupan re tiempo vocame, roma man xinquinimaj-ta. Roma tak xc'ue' re jun ixok re', camas naj xbiyin chin quire' xbo'rtz'eta' y xbo'rc'axaj re namalaj na'oj re c'o riq'uin re Rey Salomón. Y vocame yinc'o yen re c'o más nuk'ij que chach re Rey Salomón re xc'ue' ajuer can, y xa man yinquinimaj-ta re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tak c'o jun itzel espíritu ndel-a riq'uin jun vinak, re itzel espíritu re' niba pa tak lugares re anche' manak vinak y manak ya', y chire' c'a nucanoj-va jun lugar chin nixulan. Y tak re jun itzel espíritu re' manak lugar nuvil chin nixulan, ");
INSERT INTO cakYNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","reja' nunojij y nubij: Más otz yintzolaj chic anche' xinel-va-pa, nicha'. Y tak re jun itzel espíritu re' nitzolaj chic-apo pa ránma re vinak anche' elinak-va-a, no'rvila' re ránma re vinak re' ancha'l jun jay re man jun c'o chupan, y jabal meson rupan y jabal ruvekic banon. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y c'are' re itzel espíritu re' ye'bo'rc'ama-pa je vuku' chic ruchibil itzel tak espíritu re más je itzel, y conojel re' ye'oc pa ránma re vinak. Y re vinak re anchok riq'uin ye'c'ue-va chic jun bey re itzel tak espíritu re', más c'ayef nuban re ruc'aslen que chach re xuban nabey. Y can quire' xtiquic'alvachij re vinak man otz-ta quic'aslen, re jec'o chupan re tiempo vocame. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y re Jesús can c'a nitzijon quiq'uin re vinak tak xapon re rute' y re je ruch'alal. Reje' niquijo' ye'ch'o riq'uin, pero man xe'oc-ta-apo riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y c'o jun xbin-apo cha re Jesús: Re ate' y re je avch'alal yatquiyaben chach-jay. Reje' niquijo' ye'ch'o aviq'uin, xcha-apo cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero re Jesús xubij cha re xbin-apo quire': ¿Anchique c'a re nte' y anchique c'a re je vach'alal nanojij rat? ");
INSERT INTO cakYNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","C'are' re Jesús xojruc'ut yoj re yoj ru-discípulos y xubij: Ja reje' re je'aconak nte' y je'aconak vach'alal. ");
INSERT INTO cakYNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Roma can conojel re ye'bano re nurayij re Nata' Dios re c'o chila' chicaj, ja reje' re je nte', vana' y nchak', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupan re k'ij re' re Jesús xel-a pa jay y xbetz'uye' chuchi-ya' y chuka' yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y camas je q'uiy vinak re xquimol-apo-qui' riq'uin. Mare' reja' xoc-apo pa jun canoa y xtz'uye-ka chupan re canoa y reja' nutzijoj-pa re ruch'abal re Dios chique re vinak. Y conojel re vinak re je'pa'al chuchi-ya' niquic'axaj-apo re andex nutzijoj-pa re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Reja' q'uiy cosas xubij chique y rion riq'uin ejemplos nich'o-va-pa chiquivach. Y jun chique re ejemplos re xucusaj, ja quire' nubij: C'o c'a jun ache xbo'rjopij semilla pa jun juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y tak re ache ntajin chic chubanic re samaj re', c'o nic'aj cha re semilla re' po bey xka-va. Y xe'pa re ch'utak chicop c'o quixic' re ye'ba pa cak'ik' xquitaj-a re semilla re xka po bey. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Y c'o chic nic'aj cha re semilla xa cojol tak aboj xka-va y chire' man pim-ta re ulef, y cha'nin xe'tz'uc-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xa jac'a tak xpa rach k'ij, xe'bayoba-ka y xe'chakij-ka. Roma xa man naj-ta binak-ka quixe' pan ulef, mare' cha'nin xe'chakij-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y nic'aj chic xka cojol tak k'ayis c'o quiq'uixal. Y tak xe'tz'uc-pa, junan xe'q'uiy quiq'uin re q'uix. Pero re k'ayis c'o quiq'uixal camas xe'q'uiy, mare' re tico'n xe'jik' pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Y re nic'aj chic semilla xka pa jun utzulaj ulef, y re tico'n camas xe'q'uiy y camas chuka' xe'vachin. Roma c'o semilla xquiyala' a treinta quivach, c'o xquiyala' a sesenta y c'o re xquiyala' ja'jun ciento. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y jare' tak yoj re yoj discípulos xojelon-apo riq'uin re Jesús y xkac'utuj cha: ¿Anchique roma xa'cusaj ejemplos tak xach'o chiquivach re vinak? xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Xpa re Jesús xubij chaka: Man jun bey can-ta jabal bin can chij tak re vinak ye'oc pa ruk'a' re Dios, pero chiva yex yi'on k'ij che nitamaj. Jac'a re vinak re man ye'niman-ta vichin, riq'uin ejemplos yinch'o-va chiquivach, roma chiquivach reje' can man nisekresas-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Roma re c'o cosas ruyacon pa ránma, can xtuc'ul c'a más chin quire' camas q'uiy cosas xtic'ue' riq'uin. Jac'a re man q'uiy-ta cosas ruyacon pa ránma, hasta re ba' c'o riq'uin can xtilisas chach. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa mare' tak yen ye'ncusaj ejemplos chin yinch'o chiquivach, roma xaxe tal choj quire' niquitzu' y man niquitz'at-ta jabal re niquitzu', y xaxe tal choj niquic'axaj y man nak'ax-ta pa quive' re niquic'axaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Can nibanataj-va re tz'iban can roma re Isaías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y ja quire' nubij re rutz'iban can reja': Yex xaxe c'a tal choj quire' xtic'axaj y man xtak'ax-ta pan ive' re xtic'axaj. Yex xaxe c'a tal choj quire' xtitzu' y man xtitz'at-ta jabal re nitzu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Roma re cánma re vinak re' xa can xquicoversaj. C'ayef c'a che ndoc-ta pa quixquin re niquic'axaj. C'o quinak'avach, pero man ye'tzu'un-ta roma man niquijo-ta ye'tzu'un. Reje' man jun cosa niquijo', man niquijo-ta niquic'axaj re nuch'abal, y man niquijo-ta che nika-ta-ka pa tak cánma, man niquijo-ta nitzolaj-pa quic'o'x, chin che yen ninchojmersaj re quic'aslen. Quire' xubij re Dios, re tz'iban can roma re Isaías. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero otz-ibanoj yex re yix nu-discípulos, roma re inak'avach can jabal-va ye'tzu'un. Re ixquin can jabal-va niquic'axaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Y vocame can jabal tic'axaj re nimbij chiva, che je q'uiy re rusamajela' re Dios re xbex profetas chique y je q'uiy chuka' vinak re camas choj quic'aslen chach re Dios re xe'c'ue' ajuer can, reje' camas xquijo' xquitz'at-ta re nitz'at yex vocame, pero cama-va xquitz'at-ta-a. Camas chuka' xquijo' che xquic'axaj-ta re nic'axaj yex vocame, pero cama-va xquic'axaj-ta-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y re Jesús xubij chique: Tic'axaj re andex ndel-va che tzij re ejemplo chij re jun ache re xbo'rjopij semilla pa jun juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Re semilla re xe'ka po bey, jare' re ruch'abal re Dios re niquic'axaj re vinak. Y ja ch'abal re' re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios. Pero roma re vinak re' man niquiya-ta-ka pa tak cánma re ruch'abal re Dios re niquic'axaj, mare' tak re itzel cha'nin nitiquir no'rlisaj re ch'abal re ticon can pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Re semilla re xe'ka chucojol tak aboj, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak. Re vinak re' camas c'a ye'qui'cot tak niquic'ul re ruch'abal re Dios pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero como man nuc'am-ta-ka ruxe' re ruch'abal re Dios pa tak cánma, mare' man q'uiy-ta tiempo re ye'qui'cot, xa jun ca'e-oxe-oc k'ij re otz ye'c'ue' riq'uin re Dios. Y tak nipa re tijoj-pokonal chiquij y ye'tzelas roma quiniman re ruch'abal re Dios, cha'nin ye'tzak. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y re semilla re xe'ka chucojol tak k'ayis re c'o ruq'uixal, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak. Pero como re vinak re' xa ja re ndoc cha re quic'aslen vova' chach re ruch'ulef re niba cánma chij, mare' ne'jik' re ruch'abal re Dios re c'o pa tak cánma. Ne'jik' pa ruk'a' re biyomal re ancha'l che c'o otz nuc'am-pa chique y xa man quire-ta. Y re vinak re' man jun bey xtivachin re ruch'abal re Dios pa tak quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Jac'a re semilla re xe'ka pa jun utzulaj ulef, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak, y re vinak re' can nic'ue-va-ka pa tak cánma re ruch'abal re Dios y re quic'aslen can jabal nivachin. Can ye'vachin ancha'l niquiban re semilla. Roma jec'o semilla niquiya' a treinta quivach, jec'o niquiya' a sesenta y jec'o niquiya' ja'jun ciento. Can quire' nuban re quic'aslen re vinak re can nic'ue-ka re ruch'abal re Dios pa tak cánma, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Y re Jesús xutzijoj chic re jun ejemplo re' chiquivach, y xubij: Re ru-gobierno re Dios can junan riq'uin re xuban jun ache tak xutic utzulaj semilla pa rujuyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero pa jun ak'a', tak conojel vinak ye'var, xpa re nic'uxc'ut rupan cha re rajaf re juyu', xbo'rtica' can re semilla chin re itzel k'ayis chucojol re trigo ticon chic can. Y xe xbo'rbana' can quire', xba. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Y tak xe'q'uiy-pa re trigo y tak xe'el-pa rue', c'ajare' tak xk'alajin re itzel k'ayis chucojol. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y jare' tak re mozos xe'bapon riq'uin re qui-patrón y xquibij cha: Re semilla re xatic-ka pan avulef can utzulaj semilla-va. Pero vocame c'o itzel tak k'ayis chucojol. ¿Anche' como xpo-va re semilla chin re itzel k'ayis? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y re patrón xubij chique re ru-mozos: Re' jun nic'uxc'ut rupan chua xbano. Y re mozos xquibij cha: ¿Najo' che yojba chuc'ukic? ");
INSERT INTO cakYNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero re qui-patrón xubij chique: Mane', man quixba chuc'ukic, roma vo xa xque'ic'uk re itzel k'ayis, q'uiba' xque'c'ukutaj chuka' re trigo. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiya' k'ij che re itzel k'ayis tiq'uiy-na junan riq'uin re trigo, c'a jampa' xtapon re cosecha. Roma tak xtapon re k'ij chin re cosecha, yen xtimbij chique re nu-mozos che nabey tiquimola' ruchi' re itzel k'ayis, y pa manojos que'quibanala' cha chin ye'parox, y c'ajare' tiquik'ata' re trigo chin che niquiyac-apo, xcha' re qui-patrón. Ja ejemplo re' re xubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y re Jesús xubij chic re jun ejemplo re' chiquivach: Jun ch'et semilla chin mostaza re no'rtica' can jun ache pa rujuyu', can junan riq'uin re ru-gobierno re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Roma astapa' re semilla chin re mostaza ja semilla re' re más co'ol-oc que chiquivach conojel semillas, pero tak nitz'uc-pa jare' re más nem ndel chiquivach re nic'aj chic k'ayis. Re mostaza can ancha'l jun che' nuban tak niq'uiy. Mare' re chicop re c'o quixic' re ye'ba pa cak'ik', ye'bapon pa rue' y niquiban quisoc pa tak ruk'a', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Re Jesús xubij chic chuka' re jun ejemplo re' chiquivach: Re levadura re no'rc'ama-pa jun ixok y nuya' chupan oxe' pajbal harina muban, can nuban che nuquiraj-ri' chupan ronojel. Can ancha'l c'a nuban re levadura che nuquiraj-ri', quire' chuka' xtibiyin re ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y ronojel re xubij re Jesús chique re vinak re', rion riq'uin ejemplos. Can man jun tzij re xubij chique re man-ta xucusaj ejemplos tak xch'o chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chin quire' can nibanataj re rubin can jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re profeta re' ja quire' nubij re rutz'iban can chij re Jesús: Yen tak xquinch'o chiquivach re vinak can xque'ncusaj ejemplos. Desde que tak xtz'ucutaj-pa re ruch'ulef, q'uiy cosas re can je'evan, y yen can xque'nsekresaj chiquivach. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y tak re Jesús xe'ruban despedir re vinak, reja' xoc-apo pa jay y chuka' yoj re yoj ru-discípulos. Y jare' tak yoj xojelon-apo riq'uin y xkabij cha: Yoj nakajo' che rat nabij-ta chaka andex ndel-va che tzij re ejemplo chij re trigo y chij re itzel k'ayis re xbetic can pa jun juyu'. Roma can man xk'ax-ta pa kave'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y xpa re Jesús xusekresaj re ejemplo chiquivach y xubij: Re nitico re utzulaj semilla, ja yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Re ulef re anche' xban-va re tico'n, can jac'a chach re ruch'ulef. Re utzulaj semilla ja re jec'o pa ruk'a' re Dios. Y re itzel k'ayis ja re can je richin-va re itzel. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y re xbetico can re itzel k'ayis roma camas nic'uxc'ut rupan, re' ja re itzel. Y tak nubij che xtik'at, jare' re xtibanataj pa ruq'uisibal cha re tiempo re katz'amon, y re xque'k'ato, jac'a re ángeles. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Can ancha'l niban riq'uin re itzel k'ayis che ye'lisas-a y ye'parox pa k'ak', can quire' chuka' xtibanataj pa ruq'uisibal cha re tiempo re katz'amon. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yen re xinalax chi'icojol xque'ntak re nu-ángeles chiquimolic conojel re ye'bano etzelal y niquiban chique nic'aj chic vinak che ye'tzak. Roma man ninjo-ta che ye'c'ue' re vinak re' chiquicojol re jec'o pa nuk'a' yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y conojel re vinak re xque'mol-a, c'a pa k'ak' xque'bech'akex-va, y c'aja chire' c'a xtipo-va re ok'ej chiquivach y can xtiquikach'ach'ej rocay. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Jac'a re vinak re choj quic'aslen can xque'yiq'uiloj ancha'l niyiq'uiloj re k'ij. Can xque'k'alajin che jec'o pa ruk'a' re Quirta' Dios. Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jun bey jun ache c'o jun biyomal mukun xuvel pa jun juyu', y re' can junan riq'uin tak re vinak ye'oc pa ruk'a' re Dios. Re ache re' xumuk chic can re biyomal re' y niqui'cot ránma xtzolaj y xutz'am ruc'ayixic ronojel re c'o riq'uin, y c'are' xulok' re juyu' re anche' c'o-va re jun biyomal mukun. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Re vinak re ye'oc pa ruk'a' re Dios, can je junan riq'uin jun ache re nilok'o o nic'ayin quichin ch'utak aboj re nibex perlas chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tak re ache re' nuvel c'a jun perla camas rajkalen y nic'ayex, cha'nin nitzolaj y nuc'ayij ronojel re c'o riq'uin, c'are' c'a niba chulok'ic re perla re c'o más rajkalen. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Y tak niya-ka re ya'l chapabal-car pa ya', can ye'rujocoquej-pa ronojel quivach car, can junan c'a riq'uin tak re vinak ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y tak re ya'l nojnak chic che car, can niquilisaj-pa pa ya' y niquic'uaj-a c'a chuchi-ya'. Y c'are' ye'tz'uye' chucha'ic. Y re utzulaj tak car ye'quiya' pa tak chacach, y jac'a re car re man je otz-ta man ye'quiya-ta pa tak chacach, xa ye'quilisaj can. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quire' xtibanataj pa ruq'uisibal cha re tiempo re katz'amon. Xque'pa c'a re ángeles chiquicha'ic re vinak. Jun-va xque'quiya-va re choj quic'aslen, y jac'a re man otz-ta quic'aslen xque'quijech'aj c'a can. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y re vinak re man otz-ta quic'aslen, xque'ch'akex pa k'ak', y c'aja chire' c'a xtipo-va re ok'ej chiquivach y can xtiquikach'ach'ej rocay. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Y re Jesús xuc'utuj chaka yoj re yoj ru-discípulos: ¿Xk'ax como pan ive' ronojel re'? Y yoj xkabij cha re Ajaf: Ja', xk'ax pa kave'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Reja' xubij chic: Camas otz vo xa can xk'ax pan ive', roma can xixoc-yan pa ruk'a' re Dios y c'o chic itaman chij re', y chuka' itaman re je'tz'iban can ajuer. Y mare' can yix junan riq'uin jun tata'aj pa jun jay. Tak c'o nic'atzin-va, c'are' c'a ye'bo'rlisaj-pa re rubiyomal. Ye'rucusaj c'a re rubiyomal re c'o-yan chic tiempo tiyaque-va y chuka' ye'bo'rlisaj-pa re rubiyomal re c'a ba-oc tiempo que'ruyac-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y tak re Jesús xtane' chubixic re ejemplos re', reja' xba y chuka' yoj re yoj ru-discípulos xkaya' c'a can re lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Jac'a tak xojapon pa tenemit Nazaret re anche' xq'uiy-va re Jesús, reja' xuc'ut c'a re ruch'abal re Dios chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y roma re ch'abal re ye'rubila' chiquivach re vinak re' can xsatz quic'o'x y xquibij: ¿Anchique roma tak re ache re' camas na'oj c'o riq'uin y nitiquir ye'ruban milagros? ");
INSERT INTO cakYNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Y xa jare' re ruc'ajol re jun ache carpintero, y ja re jun ixok rubini'an María jare' re rute' y re je ruch'alal ja re Jacobo, re José, re Simón y re Judas. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y chuka' re je rana' chakacojol yoj jec'o-va. ¿Anche' c'a xutamaj-va re rutaman y anche' c'a pitinak-va re ru-poder chin nitiquir ye'rubanala' milagros? ye'cha' chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y mare' re vinak can man ba' xquinimaj re Jesús. Y re Jesús xubij chique re vinak re': Conojel re rusamajela' re Dios re nibex profetas chique, can man jun quik'ij, pero re' xaxe chiquivach re vinak re jec'o pa rutenemit y chiquivach re ru-familia, roma chiquivach re nic'aj chic vinak c'o quik'ij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y re Jesús man q'uiy-ta milagros re xe'rubanala' chupan re rutenemit rubini'an Nazaret, roma re ruvinak man xquinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupan re tiempo re' re Herodes re nibano gobernar xuc'axaj che re Jesús camas elinak rutzijol chiquicojol re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y re Herodes xubij chique re ye'samaj riq'uin: Re Jesús xa ja re Juan Bautista re xc'astaj-pa chiquicojol re anama'i'. Mare' tak c'o poder pa ruk'a' chin q'uiy milagros nitiquir ye'rubanala'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Roma ja re Herodes re xbin che tiquitz'ama-pa re Juan. C'are' xuxim che cadena y xuya' pa cárcel. Re Herodes quire' xuban roma re ixok rubini'an Herodías re c'o riq'uin, xa ruxayil re Felipe re ruch'alal re Herodes. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Re Juan xtz'am roma rubin cha re Herodes: Man otz-ta abanon roma aconak-ka avxayil re Herodías re ruxayil re avch'alal rubini'an Felipe. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y xa roma re' re Herodes can rujovan-va che nuquimisaj-ta re Juan, pero can nuxibij-ri' chiquivach re vinak, roma re vinak can quitaman che re Juan Bautista can jun rusamajel re Dios re nibex profeta cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Y chupan re k'ij tak re Herodes xtz'akater chic jun rujuna', xuban jun namak'ij, y chupan re namak'ij re' re xtan ral re Herodías xajo' chach re Herodes, y re Herodes camas xka chach re xajoj re xuban re xtan. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y mare' re Herodes can xuban jurar chach re ral re Herodías che xabandex re nrajo' can xtuya-va cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero tak re xtan xya-yan-a runa'oj roma re rute' c'ajare' tak xubij cha re Herodes: Re ninjo' yen ja re rujalom re Juan Bautista, y naya-pa chinoch vova' chach jun plato. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y re Rey Herodes xbison-ka tak xuc'axaj quire', pero como can rubanon chic jurar cha, che xabandex xterajo' can xtuya-va y roma chuka' can chiquivach re jec'o riq'uin chach mesa tak xubij-va cha, reja' xubij che tic'am-pa re rujalom re Juan Bautista cha re xtan. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Y mare' tak xutak-a rutzaq'uisic rujalom re Juan Bautista chire' pa cárcel. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y c'are' xc'am-pa re rujalom cha re xtan chach jun plato, y re xtan xbo'rjacha' pa ruk'a' re rute'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y c'are' xe'bapon re ye'tzekelben chin re Juan, chin xquic'uaj-a re ru-cuerpo y xbequimuku' can. Y re je tzekelbey chin re Juan xbequitzijoj cha re Jesús re xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y re Jesús can xe xuc'axaj-a re xbanataj, xba, y chuka' yoj re yoj ru-discípulos xojba. Xojoc-a pa jun canoa y xojak'ax c'a juc'an chic-apo ruchi-ya', y c'a pa jun lugar naj xojbo-va. Re jun lugar re' je manak vinak, pero tak re vinak xquic'axaj-a, chacakan c'a xe'el-a re pa tak tenemit chin che xe'bapon c'a chupan re lugar re anche' napon-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y tak re Jesús xka can chupan re canoa chire' chuchi-ya', xutz'at che camas chic je q'uiy vinak re je'yabeyon richin y reja' camas xujoyovaj quivach re vinak re'. Y can xe'ruc'achojsaj re ye'yavaj re jec'o chiquicojol. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y tak xk'ak'ij-yan-ka chupan re jun k'ij re', yoj re yoj ru-discípulos xojelon-apo riq'uin y xkabij cha: Vova' je manak vinak y xa xk'ak'ij-yan-ka. Ca'taka-a re vinak re' chin che ye'ba pa tak cocoj tenemit re jec'o nakaj chin te'quilok'o' quivay chire', xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero re Jesús xubij chaka: Manak tuk'aj che ye'ba y c'aja-ta re' xtiquivel quivay, tiya' quivay yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y yoj xkabij cha: Yoj xe vo'o' vay y ca'e' car c'o kaq'uin, y re' man xque'ruban-ta, xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero re Jesús xubij chaka: Tic'ama-pa vova'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y jare' tak reja' xubij che que'tz'uye' conojel re vinak pa rue' re sabana. Y c'are' reja' xe'ruli'ej pa ruk'a' re vo'o' vay y re ca'e' car, xtzu'un chicaj y xutioxij cha re Dios. C'are' xe'rupar y xuya-a chaka yoj re yoj ru-discípulos y yoj xkajachala' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Can conojel jabal xe'va'. Can man jun re man-ta xva'. Y c'a c'o doce chacach nojnak re xuban sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Y re xe'va' jec'o la'k vo'o' mil achi'a', jac'a re ixoki' y re ac'ola' man xe'vejelax-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y jare' tak re Jesús xubij chaka yoj re yoj ru-discípulos che kojoc-a chupan re canoa y kojba c'a juc'an-apo ruchi-ya', che yojnabayaj-a chach, roma reja' c'a ye'ruban-na can despedir re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Y tak xe'ruban-yan can despedir re vinak, rion c'a xjote-a pa rue' re loma chubanic orar. Y chire' c'a c'o-va tak xoc-ka re ak'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y re canoa re anche' yojbinak-va yoj re yoj ru-discípulos pa nic'aj chic cha re ya' c'o-va, pero re ya' camas nubolk'otela-ri' y man nuya-ta k'ij che nibiyin re canoa. Roma camas cak'ik', mare' man nuya-ta k'ij cha che choj nibiyin, xa nutzalaba'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y tak nisakar-yam-pa, re Jesús binak charakan pa rue-ya', chin niba-apo kaq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero tak yoj re yoj discípulos xkatz'at che c'o jun pitinak charakan pa rue-ya', xsatz kac'o'x y xkabij: ¡La' jun xibinel! xojcha'. Y cof xojsiq'uin roma camas kaxibin-ki'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero re Jesús cha'nin xch'o-pa chaka, y xubij: Man tixibij-ivi'. Xa ja yen re Jesús, xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y tak re Jesús pitinak pa rue' re ya', can jare' tak re Pedro xubij-apo cha re Ajaf: Vo xa ja rat, can tabana' c'a chuka' chua yen che yimbiyin pa rue-ya' chin yimba-apo c'a anche' yatc'o-va, xcha-apo re Pedro cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y re Jesús xubij-pa cha re Pedro: Catampa c'a. Y re Pedro can jare' xka-ka pa canoa y nibiyin c'a pa rue' re ya' chin niba-apo c'a anche' c'o-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Xa jac'a tak xutz'at che camas cak'ik', xuxibij-ri'. Y tak xuna' can niba-ka chuxe' re ya', c'are' cof xsiq'uin y xubij: ¡Ajaf, quinacola'! ");
INSERT INTO cakYNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y re Jesús can jare' cha'nin xutz'am re Pedro y xubij cha: ¿Anchique roma man can-ta xaban confiar-avi' viq'uin? xcho'x re Pedro roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Y tak reje' xe'jote-yan-apo chupan re canoa, re cak'ik' xtane-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y konojel re yojbinak chire' pa canoa can jare' tak xkaya' ruk'ij re Jesús y xkabij cha: C'aja vocame c'a xkatz'at che katzij che can ja-va rat re yat Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y c'are' xojak'ax pa rue' re lago re' y xojapon chupan re lugar rubini'an Genesaret. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y tak xtamax rach re Jesús chire' coma re achi'a', reje' xquilisaj rutzijol cha'nin re pa tak lugar re jec'o chunakaj re quitenemit, y re vinak xe'quic'amala-pa re quiyava'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y re yava'i' re' can niquic'utula' utzil cha re Jesús che tuya' k'ij chique che astapa' xaxe ruchi-rutziak niquitz'am chin ye'c'achoj. Y can quire-va xbanataj. Conojel re yava'i' re xe'tz'amo ruchi-rutziak re Jesús can xe'c'achoj cha re quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y jec'o ca'e-oxe' achi'a' fariseos y ja'jun chique re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas re xe'bapon riq'uin re Jesús, y re achi'a' re' aj pa tenemit Jerusalén. Re achi'a' re' quire' xquibij cha re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Anchique roma tak re a-discípulos man niquiban-ta ancha'l re bin can coma re kavinak xe'c'ue' ajuer can? Roma re a-discípulos man niquich'aj-ta jabal quik'a' tak ye'va'. Man niquiban-ta ancha'l nakaban yoj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Roma quire' xquic'utuj cha re Jesús, xpa reja' xubij chique: Y yex ¿anchique roma tak man niban-ta re nubij re ru-mandamiento re Dios? Xa ja re je'quibin can re kavinak xe'c'ue' ajuer, xa jare' re ye'banala'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Re ru-mandamiento re Dios nubij: Taya' quik'ij re ate-arta', y re anchique ye'rutzelaj rute-rutota' camas rumac ndel re quire' nibano, y can ruc'amon che niquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Y yex man quire-ta niban. Xa man niban-ta ancha'l re rubin can re Dios. Yex xa ye'tijoj re vinak che man nic'atzin-ta che ye'quito' re quite-quirta'. Che xa riq'uin niquibij chique re quite-quirta', che yen man yintiquir-ta yixinto' riq'uin re ndoc chiva, roma can xinsuj-yan cha re Dios re xoc-ta ivichin yex. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y xa riq'uin quire' niquibij, can man nic'atzin-ta che ye'quito' re quite-quirta', yixcha' chique. Y riq'uin re' can nik'alajin che xaxe re je'quibin can re kavinak xe'c'ue' ajuer re iyi'on ruk'ij y jac'a re ru-mandamiento re Dios can man jun ruk'ij ibanon cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yex xa ca'e' ipalaj. Mare' can jabal rubixic rubanon can chivij re jun rusamajel re Dios re xbex profeta cha, re xc'ue' ajuer can re xubini'aj Isaías. Re xubij re Dios cha che tutz'ibaj can, y ja quire' nubij: ");
INSERT INTO cakYNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Re vinak re' xaxe riq'uin re quichi' niquiya' nuk'ij, pero re cánma xa mana-ta re' re nrajo', xa c'ac'anaj c'o-va re cánma chin che niquiya-ta nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa can man jun nic'atzin-va che niquiya' nuk'ij, roma xa enseñanzas quichin achi'a' niquic'ut y niquibij che can jare' re ruc'amon che niban. Quire' re rutz'iban can re profeta Isaías, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y c'are' re Jesús xe'rayoj conojel re vinak re quimalon-qui' chire', y xubij chique: Tic'axaj re xtimbij chiva y can tak'ax-a pan ive'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mana-ta re nutaj-ka re vinak re nitz'ilbisan richin. Re nitz'ilbisan chin re vinak xa ja re itzel tak tzij y re itzel tak nojebal re ye'pa pa ránma, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Y c'are' yoj re yoj discípulos xojelon-apo riq'uin re Jesús, y xkabij cha: Re achi'a' fariseos xpa quiyoval tak xquic'axaj re tzij re xabij. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Xpa reja' xubij chaka: Ronojel re tico'n re quibanon re achi'a' re' man xtic'ue-ta can, xa can xtic'uk-a. Roma ronojel re tico'n re' mana-ta re Nata' c'o chila' chicaj banayon. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xa tiya' k'ij chique, roma reje' can je moyi' riq'uin re quina'oj, y chuka' can ye'quic'uaj nic'aj chic re xa je moyi'. Y vo xa re je moyi' ye'quiyukej nic'aj chic moyi', xa can junan xque'betzak pa tak jul, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y c'are' xpa re Pedro xubij cha re Jesús: Tasekresaj ba' más chakavach re ejemplo xabij chij re nitz'ilbisan chin jun vinak, roma can man nak'ax-ta pa kave'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y re Jesús xubij: Yex can junan ibanon quiq'uin re nic'aj chic vinak che man nak'ax-ta pan ive' re nimbij. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Man k'axnak-ta pan ive' re tzij re nubij che mana-ta re nutaj-ka re vinak re nitz'ilbisan richin. Roma re nutaj-ka xa choj chupan nibo-va y c'are' ndel-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Re nitz'ilbisan chin re vinak ja re itzel tak tzij y re itzel tak nojebal re ye'pa pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Roma re itzel tak nojebal xa pa ránma c'a re vinak nipo-va. Pa tak cánma nipo-va tak ye'quimisan. Chire' chuka' nipo-va tak re vinak je'c'ulan y re man je'c'ulan-ta niquicanola-qui' chin ye'macun. Y pa tak cánma chuka' nipo-va tak ye'lak', niquitz'ucula' tzij chiquij re vinak, y chire' chuka' nipo-va tak ye'yok'on. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Y ja ronojel banabal qui tak re' re nitz'ilbisan chin re vinak. Pero re vinak re man nuch'aj-ta jabal ruk'a' tak niva', mana-ta re' re nibano che nitz'elab re ruc'aslen. Quire' xubij re Jesús chaka yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Re Jesús y yoj re yoj ru-discípulos xojel-a chire', y xojba pa jun lugar re c'o-apo chiquinakaj re ca'e' tenemit quibini'an Tiro y Sidón. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chire' jec'o-va re je rey-rumam can re jun ache xubini'aj Canaán. Y jun ixok re quivinak reje', xpa riq'uin re Jesús. Reja' camas bis c'o pa ránma, mare' camas nuc'utuj utzil cha re Jesús y jun pa ruchi' nubila': Tajoyovaj noch rat Ajaf, rat re yat rey-rumam can re Rey David. Quinato', roma re val-xtan camas c'ayef rubanon pa ruk'a' jun itzel espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero re Jesús man jun tzij xubij cha re ixok. Y yoj re yoj ru-discípulos xojelon-apo riq'uin re Jesús y xkabij cha: Tabij cha re ixok re' che ticanaj can, roma camas nurakala' ruchi' tzakatal chakij y re ruch'abal camas naj nic'axax-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xpa re Jesús xubij: Yen xintak-pa xaxe chiquicanoxic re kavinak israelitas re je'satzanak pa quimac. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Y can jare' xbexuque' re ixok chach re Jesús, y xubij cha: Ajaf, quinato'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero re Jesús xubij cha re ixok: Man otz-ta che chak xabanchique ninya-va re utzil re pitinak riq'uin re Dios. Ancha'l re quivay re ac'ola' man ruc'amon-ta che nilisas-a chiquivach y che ja-ta re tz'e' re ye'tijo richin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero re ixok xubij: Ajaf, can katzij-va re nabij. Pero can yojtiquir chuka' nakac'ul-apo ba' cha re utzil re'. Can ancha'l niquiban re tz'e' cha re ruchi' tak vay re ye'quitzakala' re cajaf chuxe' tak mesa, can ye'quimolola-apo. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y re Jesús can jare' xubij cha re ixok re': Can nik'alajin che camas abanon confiar-avi' viq'uin. Can tibanataj c'a re najo', xcha' re Jesús. Y can ja chupan re hora re' tak xel-a re itzel espíritu riq'uin re xtan, re ral re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tak re Jesús y yoj re yoj ru-discípulos xojak'ax-yan chupan re lugar re c'o chiquinakaj re ca'e' tenemit quibini'an Tiro y Sidón, xojapon chuchi' re lago rubini'an Galilea. Y xojote-a c'a pa rue' re loma re c'o chire' y c'are' xtz'uye-ka re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y camas je q'uiy vinak re xe'bapon riq'uin, y re vinak re' je'quic'ualon-apo quiyava'i'. Y re yava'i' re' man junan-ta rach yabil quic'uan conojel, roma jec'o je cojos, jec'o je moyi', jec'o je mema', jec'o re man otz-ta quik'a-cakan, y jec'o jun chic-va che rach yabil ndoc chique. Re vinak re' xe'quiya-apo re quiyava'i' chach re Jesucristo, y reja' can conojel xe'ruc'achojsaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Roma quire' xuban re Jesús quiq'uin re yava'i', re vinak can anchique-la xquina' tak xquitz'at. Re je mema' rubanon can, can ye'tiquir chic ye'ch'o. Re man otz-ta quik'a-cakan, xe'c'achoj. Re je cojos rubanon can, choj chic ye'biyin. Re moyi', ye'tzu'un chic. Re vinak can xquiya' ruk'ij re Dios, re Dios kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Y re Jesús xojrayoj yoj re yoj ru-discípulos y xubij chaka: Yen camas ninjoyovaj quivach re vinak re', roma oxe' k'ij que'c'ue-va viq'uin y vocame manak chic quivay chin niquitaj. Y vo xaxe tal choj quire' xque'ntak-a cho tak cachoch y man jun andex niquitaj-a, man otz-ta. Q'uiba' xque'betzak pa tak bey roma viyjal, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Y yoj can jare' tak xojch'o-apo cha re Jesús y xkabij: Re lugar anche' yojc'o-va je manak vinak. Y mare' manak anche' nakavila-va-pa vay chin che jabal ye'va' re vinak re'. Roma camas je q'uiy, xojcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero re Jesús xuc'utuj chaka: ¿Jenipa' vay c'o iviq'uin? Y yoj xkabij: Xe vuku' vay c'o kaq'uin y ca'e-oxe' ch'utak car. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y re Jesús xubij che que'tz'uye-ka re vinak pan ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","C'are' reja' xe'ruli'ej pa ruk'a' re vuku' xcana-vay y re car y xutioxij cha re Dios. Y c'are' xe'rupar y xuya' chaka yoj re yoj ru-discípulos, y yoj xkajachala' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Y conojel jabal xe'va'. Can man jun re man-ta xva'. Y c'a c'o vuku' chacach nojnak re xuban can sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Je caje' mil achi'a' re xe'va'. Jac'a re ixoki' y re ac'ola' man xe'vejelax-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y tak re Jesús je'rubanon chic despedir re vinak, reja' y yoj re yoj ru-discípulos xojoc-a chupan re canoa y xojba c'a chupan re lugar rubini'an Magdala. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Y jec'o achi'a' fariseos y jec'o chuka' achi'a' saduceos re xe'bapon riq'uin re Jesús. Re achi'a' re' xe'bapon riq'uin xaxe chin che niquitojtobej, y xquibij cha che can tubana' jun señal chicaj chin quire' can nuc'ut che ja re Dios takayom-pa richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero re Jesús xubij chique re achi'a' re': Tak nik'ak'ij-ka yex nitz'at che quiak rubanon re nube chach re rocaj, y nibij che re k'ij chua'k can otz xtuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chuka' re pa tak namak'a', tak yex nitz'at che re rocaj mukul y quiak chuka' rubanon re nube chicaj, nibij che re k'ij vocame man otz-ta xtuban. Yex xa ca'e' ipalaj, roma jabal itaman nitz'at re rocaj, y jabal itaman andex no'rbana' re tiempo vo xa otz o man otz-ta. Jac'a re señales re can ye'tz'at y can nubij anchique tiempo yojc'o-va, jare' can man yixtiquir-ta nitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yex re yixc'o chupan re tiempo vocame camas yix mal tak vinak y can man ninimaj-ta re Dios. Can nijo' nitz'at che yen nimban-ta jun señal chicaj chin quire' yininimaj. Pero mana-ta re nijo' yex re xtibanataj. Xa can xe re xbanataj riq'uin re jun ache xubini'aj Jonás, re jun rusamajel re Dios xc'ue' ajuer can re xbex profeta cha, xaxe re señal re' re niya' chiva yex, xcha' re Jesús y xba y chuka' yoj re yoj ru-discípulos xojba chij, y reja' xe'ruya' can quion re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Y tak re Jesús y yoj re yoj ru-discípulos xojapon c'a juc'an chic-apo ruchi-ya', c'ajare' tak xkanabej che xa manak vay kac'uan-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Y jare' tak re Jesús xubij chaka: Can tic'axaj re xtimbij chiva, che can tichajij-ivi' chach re levadura quichin re achi'a' fariseos y re achi'a' saduceos. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y roma quire' xubij re Jesús, yoj xkabila' chakavach: Reja' quire' xubij roma manak kavay xkac'am-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero re Jesús can xunabej re andex nakanojij, mare' xubij chaka: ¿Anchique roma yex ninojij che roma manak vay xic'am-pa, mare' tak quire' ximbij? Yex man can-ta ibanon confiar-ivi' viq'uin y mare' xaxe re vay ninojij. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Manak nic'atzin-va che xaxe re vay ninojij. Ancha'l xa c'amaje-na tak'ax pan ive'. Ancha'l xa man chic ne'ka-ta chi'c'o'x tak yen xinya' quivay re je vo'o' mil achi'a' riq'uin re vo'o' vay. Y ancha'l xa man chic ne'ka-ta chi'c'o'x re jenipa' chacach vay re xuban can sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Chuka' ancha'l xa man chic ne'ka-ta chi'c'o'x tak yen xinya' quivay re je caje' mil achi'a' riq'uin re vuku' vay. Chuka' chire' can xitamaj jenipa' chacach re xuban can sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Andex-ta como jun chic rubixic nimban cha, chin quire' nak'ax-ta pan ive' che man roma-ta re vay re ximistaj can, tak yen quire' ximbij che yex tichajij-ivi' chach re levadura quichin re achi'a' fariseos y saduceos? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Y c'ajare' tak yoj re yoj ru-discípulos xk'ax pa kave' che man chach-ta re levadura re niquicusaj riq'uin re xcana-vay re achi'a' fariseos y saduceos re nakachajij-va-ki', xa ja chach re enseñanza re niquic'ut re achi'a' re', xa ja chach re' re takachajij-va-ki', roma re enseñanza re' xa man je otz-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y re Jesús y chuka' yoj re yoj ru-discípulos xojapon chupan re jun lugar re nakaj nicanaj-va cha re tenemit rubini'an Cesarea chin re Filipo. Xpa re Jesús xuc'utuj chaka: ¿Yin anchique c'a yen re xinalax chi'icojol niquinojij re vinak? xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y yoj xkabij cha re Jesús: Jec'o ye'bin che ja rat re Juan Bautista. Nic'aj chic niquibij che ja rat re Elías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Jec'o chuka' ye'bin che ja rat re Jeremías re jun chuka' rusamajel re Dios re xc'ue' ajuer can, reja' chuka' jun profeta. Y jec'o chuka' ye'bin che rat yat jun chique re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y reja' xuc'utuj chaka yoj: Y yex, ¿andex ninojij chuij? xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y re Simón Pedro can jare' xubij cha re Jesús: Ja rat re Cristo re Ruc'ajol re c'aslic Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y can xe xuc'axaj quire' re Jesús, can jare' tak xubij: Otz-abanoj rat Simón Pedro re yat ruc'ajol re jun ache rubini'an Jonás, roma re xabij che ja yen re Cristo re Ruc'ajol re Dios. Re xabij man vinak-ta c'a xbin chava, xa can jac'a re Nata' Dios re c'o chila' chicaj re xbin chava che quire' xabij. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Yen ninjo' nimbij chava rat: Yen nyi'on chic jun abe', mare' tak rat abini'an Pedro. Y nimbij chava che pa rue' re aboj re' xtimpoba-va re nu-iglesia. Y man xtich'acataj-ta roma re camic y re etzelal. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Can chava-va rat xtinya-va re poder chin che naban chique re vinak che ye'oc pa ruk'a' re Dios, y re vinak man nrajo-ta ndoc pa ruk'a' re Dios can xtaban cha che man ndoc-ta. Can otz c'a xtitz'et chila' chicaj, tak rat xtatz'apij o xtajak jun bey chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y re Jesús can jare' xubij chaka yoj re yoj ru-discípulos che man jun anchok cha takabij-va che ja reja' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Y re Jesús xutz'am rubixic chakavach yoj re yoj ru-discípulos, che yen tiene que yimba pa tenemit Jerusalén y camas q'uiy tijoj-pokonal xtink'asaj pa quik'a' re rejeta'k tak achi'a' re c'o quik'ij, pa quik'a' re principal tak sacerdotes y pa quik'a' chuka' re je'atamayon re ley kachin yoj re yoj israelitas. Can xquinquiquimisaj-va, pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i', xcha' re Jesús chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Y re Pedro can xe xuc'axaj quire', xba-apo riq'uin re Jesús y xujich'aj-a ba' y cof xch'o cha. Y xubij cha: Can man tujovaj re Dios che quire-ta nibanataj ancha'l re xabij rat Ajaf. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero tak re Jesús xuc'axaj che quire' xubij re Pedro, xuposcolij-ri'. Y c'are' xubij cha: Catel-a viq'uin rat Satanás, roma man otz-ta re nanojij. Rat xa nak'at re nubey. Roma re anojebal xa can junan quiq'uin re quinojebal re vinak y man nanojij-ta ba' andex re nrajo' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y c'are' re Jesús xch'o chaka konojel yoj re yoj ru-discípulos y xubij: Vo xa c'o jun nrajo' yinrutzekelbej, can tubana' ancha'l jun re binak chuxe' ru-cruz. Man tuban re nurayij reja'. Man tupokonaj nuk'asaj tijoj-pokonal. Vo xa c'o jun re ninojin quire', otz che nipa viq'uin chin yinrutzekelbej. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Roma vo xa camas nupokonaj re ruc'aslen vova' chach re ruch'ulef, xa man xtuvel-ta ruc'aslen re man niq'uis-ta. Jac'a re man nupokonaj-ta re ruc'aslen, astapa' xtiquimisas nutzij yen, jare' sí can xtuvel-va ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Roma man jun cosa otz nuc'am-pa cha re vinak, xe-ta nic'ue' ronojel re biyomal chin re ruch'ulef riq'uin, y re vinak re' xa man nicolotaj-ta. Astapa' camas biyomal c'o riq'uin re vinak, pero man nitiquir-ta nulok' re c'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Roma yen re xinalax chi'icojol can xquimpa chic jun bey, y can junan chic nuk'ij riq'uin re Nata' y je vichibil-pa re nu-ángeles. Y c'ajare' tak xtinya' rajal-ruq'uixel chique conojel, roma re quibanabal re xe'quibanala'. ");
INSERT INTO cakYNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y can katzij re nimbij chiva, che yen re xinalax chi'icojol can xquimpo-va riq'uin nuk'ij y c'o autoridad pa nuk'a'. Y jec'o chiva yex re can man xque'com-ta, xa c'aja tak yinquitz'eton chic can che yinka-pa chila' chicaj, xa c'ajare' tak xque'com, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y tak k'axnak chic vaki' k'ij, re Jesús xuc'uaj-a re Pedro, y xe'ruc'uaj-a chuka' re Jacobo y re Juan y re je ca'e' re' quichak'-qui', xaxe re je oxe' re' re xe'ruc'uaj-a c'a pa rue' jun nema-loma. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Re Jesús can xjalataj rutzubal chiquivach re je oxe' ru-discípulos. Re rupalaj can niyiq'uiloj can ancha'l titzu'un re k'ij. Y re rutziak can ancha'l re sakil, roma camas sak xuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y can c'aja xquitz'at re je oxe' discípulos, ye'tzijon-yan chic riq'uin re Jesús re je ca'e' achi'a' quibini'an Moisés y Elías. Re achi'a' re' je rusamajela' re Dios re xe'c'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y c'are' tak re Pedro xubij-apo cha re Jesús: Ajaf, vova' otz kabanon. Vo xa rat najo', nakaban oxe' ch'utak jay. Jun avichin rat, jun chin re Moisés y jun chin re Elías. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tak re Pedro can c'a nich'o riq'uin re Jesús, can jare' tak re discípulos re' xquitz'at che c'o jun nube re camas sak y can nuchup pan avach re xpiso quichin. Y chupan re nube re' c'o Jun xch'o-pa y xubij: Jare' re Nuc'ajol y yen camas ninjo', yinqui'cot riq'uin y can tic'axaj c'a re rutzij. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y tak re je oxe' discípulos xquic'axaj quire', xe'xuque' y re nic'aj tak quivach c'a pan ulef xka-va-ka. Y camas xquixibij-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y re Jesús xjelon-apo quiq'uin re ru-discípulos, xe'rutz'am y xubij chique: Quixyacataj y man tixibij-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tak re discípulos xe'tzu'um-pa, man jun chic xquitz'at, xa rion chic re Jesús c'o. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y tak reje' je'xulam-pa chach re loma, re Jesús xuchalabej chique re ru-discípulos che man jun anchok cha tiquitzijoj-va re xquitz'at. Yex otz xtitzijoj pero tak yen re xinalax chi'icojol xinc'astaj-yam-pa chiquicojol re anama'i', c'ajare' tak ruc'amon che yex xtitzijoj, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Re je oxe' discípulos re' can jare' tak xquibij cha re Jesús: Yoj k'axnak pa kave' che can ja rat re Cristo re takom-pa roma re Dios. ¿Pero anchique roma tak re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas niquibij che nabey tiene que ne'ka re Elías, y c'ajare' tak xte'ka re Cristo? ");
INSERT INTO cakYNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y re Jesús xubij chique: Can katzij-va che re Elías nipa nabey y can nuban rubiyal ronojel. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero yen nimbij chiva che re Elías re' xpa-yan y man xquinabej-ta anchique re'. Xa camas xquiban-a cha. Can andex xquijo' quire' xquiban-a cha. Y can quire' chuka' yen re xinalax chi'icojol, jec'o ye'bano chua che nink'asaj tijoj-pokonal, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y c'ajare' tak re discípulos xk'ax pa quive' che re Jesús chij re Juan Bautista xch'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tak re Jesús y re je oxe' ru-discípulos xe'bapon-ka anche' camas je q'uiy vinak quimalon-qui', c'o c'a jun ache re xbeka riq'uin re Jesús y xbexuque' chach. Re ache xubij cha re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyovaj rach re nuc'ajol, roma reja' camas nutaj pokan pa ruk'a' re jun yabil rubini'an ataque, y camas q'uiy bey tzekenak pa k'ak' y pa tak ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'am-yam-pa y xinya' chiquivach re a-discípulos chin che niquic'achojsaj-ta, pero man xe'tiquir-ta xquic'achojsaj, xcha' re ache. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y re Jesús jare' tak xubij: Man jun vinak chupan re tiempo re' re rubanon-ta confiar-ri' riq'uin re Dios. Xa conojel je'satzanak. Man tinojij che yen nojel tiempo xquinc'ue' iviq'uin. Y chuka' man tinojij che nojel tiempo xquixincoch'. Tic'ama-pa re ala' vova', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Re Jesús chin che xuc'achojsaj re ala', cof xch'o cha re itzel espíritu chin che tel-a riq'uin re ala'. Y can ja chupan re hora re' tak xc'achoj-a re ala' cha re ruyabil roma xel-a re itzel espíritu riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y tak re Jesús y yoj re yoj ru-discípulos kayon chic yojc'o, xojpa yoj xkac'utuj cha re Jesús: ¿Anchique roma yoj man xojtiquir-ta xkalisaj-a re itzel espíritu? ");
INSERT INTO cakYNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y re Jesús xubij chaka: Man xixtiquir-ta xilisaj roma man can-ta ibanon confiar-ivi' riq'uin re Dios. Y can katzij nimbij chiva: Xa riq'uin-ta niban confiar-ivi' riq'uin re Dios, astapa' ancha'l-ta jun ch'et semilla chin mostaza, xa riq'uin re', yex can yixtiquir nibij cha re jun loma re' che tel-a vova' y tak'ax jun chic lugar, can xtak'ax-va. Can man jun cosa re man-ta xquixtiquir xtiban, xa riq'uin-ta ba' niban confiar-ivi' riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Jac'a re jun rach espíritu re' ndel, pero vo xa yex niban ayuno y oración, xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y tak re Jesús y yoj re yoj ru-discípulos xojapon-yan pa Galilea, xpa re Jesús xubij chic jun bey chaka: Yen re xinalax chi'icojol, can xquinjach-va pa quik'a' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Can xquinquimisas-va, pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i'. Y tak yoj xkac'axaj quire', camas xojbison. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y jac'a tak re Jesús y yoj re yoj ru-discípulos xojapon pa Capernaum, re ye'mola ruchi' re mero re nic'atzin pa rachoch re Dios, re tiene que niquitoj conojel achi'a', can xe'bapon chuka' riq'uin re Pedro y xquic'utuj cha: ¿La nutoj como re i-Maestro re mero re nic'atzin pa rachoch re Dios? ");
INSERT INTO cakYNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y re Pedro xubij: Ja', reja' can nutoj. Y tak re Pedro xapon pa jay, ja re Jesús jare' re xch'o-pa nabey y xubij cha: Simón Pedro ¿andex nanojij rat? ¿Re reyes vova' chach re ruch'ulef, anchok chique como niquic'utuj-va re impuesto? ¿La ja como chique re cajc'ual-ka reje' o la ja como chique re xa man je cajc'ual-ta? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xpa re Pedro xubij cha re Jesús: Re reyes vova' chach re ruch'ulef xa ja chique re man je cajc'ual-ta niquic'utuj-va re impuestos, xcha'. Y re Jesús can jare' xubij: Yen man ruc'amon-ta che nintoj re impuesto, roma yen can yin Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero vo xa man nakatoj-ta, q'uiba' man nak'ax-ta pa quive' anchique roma tak man nakatoj-ta. Mare' mejor cabiyin-ka pa ya' chutz'amic car. Y re nabey car xtatz'am, tajaka' pa ruchi' y chire' xtavel re mero re ndoc chin che na'ya' can chique re molay-mero re ndoc pa rachoch re Dios. Re mero re' nuban chin che natoj can re avichin rat y re vichin yen chuka', xcha' re Jesús cha re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y jare' tak yoj re yoj ru-discípulos xojelon-apo riq'uin re Jesús, y xkac'utuj cha: Tak can ja chic re Dios nibano gobernar pa kave', ¿anchique chaka yoj re c'o más ruk'ij xtic'ue'? ");
INSERT INTO cakYNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y can jare' tak re Jesús xrayoj jun ch'et ac'ual y xuya' pa kanic'ajal. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","C'are' xubij chaka: Can katzij nimbij chiva, vo xa yex man xtikasaj-ta-ivi' chach re Dios, y vo xa man niban-ta ancha'l niquiban re ac'ola', can man xquixoc-ta pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xaxe re can nuban che manak ruk'ij ancha'l re jun ch'et ac'ual re', jare' re c'o más ruk'ij xtic'ue' chiquicojol re jec'o pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Re yacayon vichin yen pa ránma y can niqui'cot nuc'ul jun ac'ual ancha'l re', man xe-ta re ac'ual xtuc'ul, xa can xquinruc'ul chuka' yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Xe-ta c'o jun vinak re c'a ba-oc quinrunimaj-va y nipa-ta chic jun vinak y nuban cha che nitzak pa mac, re vinak re' man otz-ta nuban. Y mare' antes che nuban re etzelal re', más-ta otz cha reja' che nixim-ta jun moma' aboj chukul y ne'torex can pa mar. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Camas c'ayef quibanon re vinak re jec'o chach re ruch'ulef roma can jec'o re ye'bano chique che ye'macun. Y can quire' nibanataj chach re ruch'ulef. Pero re camas ruc'amon che nivok'ex rach ja re vinak re nibano cha jun chic vinak che nimacun. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xa mare' vo xa jun ak'a' o jun avakan re nibano chava che yamacun, más otz che nachoy-a y natorij-a. Roma más otz che manak jun ak'a' o jun avakan y yatoc chupan re c'aslen re man niq'uis-ta, que chach c'o-ta che ca'e' ak'a' o ca'e' avakan y xaxe che tz'akat ak'a-avakan ya'tetorex can pa k'ak' re man jun bey xtiq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chuka' vo xa jun chique re anak'avach nibano chava che yamacun, más otz che nalisaj-a y natorij-a. Roma más otz che manak jun anak'avach y yatoc chupan re c'aslen re man niq'uis-ta, que chach c'o-ta che ca'e' anak'avach y ya'tetorex can chupan re k'ak' re c'o chupan re infierno. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man c'a que'tzelaj re vinak re camanak quik'ij, roma reje' can je'chajin coma re ángeles. Y yen nimbij chiva che re ye'chajin quichin reje' can nojel tiempo ye'tiquir ye'bapon chila' chicaj riq'uin re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y yen re xinalax chi'icojol, can ximpo-va c'a chiquicanoxic y chiquicolic re jec'o pa mac. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Can tinojij jabal re xtimbij chiva. C'o-ta jun ache re jec'o-ta jun ciento ru-ovejas y nisatz-ta can jun tak je'ruc'uan-a, reja' can ye'ruya' can ba' re je noventa y nueve y niba pa tak juyu' chucanoxic re jun re satzanak can. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y vo xa re ache re' no'rvila-pa re jun ru-oveja satzanak, can katzij nimbij che re ache re' camas niqui'cot ránma riq'uin re jun ru-oveja satzanak, que chach re je noventa y nueve re man jun andex xquic'alvachij. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Can quire' chuka' nibanataj riq'uin re Tata'aj re c'o chila' chicaj, reja' can man nurayij-ta c'a che c'o-ta jun vinak re nisatz-ta can chupan re mac, astapa' jun vinak camanak ruk'ij vova' chach re ruch'ulef, pero reja' can man nrajo-ta che nisatz-ta can. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Vo xa c'o jun hermano c'o andex man otz-ta nuban chava, y ja tak c'o rion che' cabiyin riq'uin y tabij cha. Y vo xa re hermano re' can nuc'axaj re nabij cha, can nach'ac. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Jac'a vo xa man yatruc'axaj-ta, ca'c'uaj c'a jun o je ca'e' chic más, chin quire' can chiquivach reje' tak nabij cha re hermano che man otz-ta rubanon. Chin quire' can yix ca'e' o yix oxe' re yixoc testigos chij ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y vo xa re hermano can man nrajo-ta nuc'axaj re xibij yex cha, c'are' rat re c'o andex man otz-ta rubanon chava, c'o modo nabij chique conojel re hermanos re niquimol-qui' pa rube' re Dios. Y tak bin chic cha coma re hermanos y man riq'uin re' cama-va nunimaj-ta tzij, y chin che reja' can nuna' che man otz-ta re xuban, can tibana' cha che man chic ivchibil-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y can katzij che yen ninya' poder pan ik'a'. Y mare' can otz xtitz'et chila' chicaj, tak yex xtitz'apij o xtijak jun bey chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chuka' nimbij chiva: Vo xa chach re ruch'ulef jec'o je ca'e' hermanos re can junan quivach chin che niquic'utuj xabanchique cosa cha re Dios, re Nata' Dios re c'o chila' chicaj can xtuya-pa re anchique cosa niquic'utuj re je ca'e' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Roma xabanche' quimalon-qui' je ca'e' o je oxe', vo xa can pa nube' yen niquimol-va-qui', yen can yinc'o pa quinic'ajal, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y can jare' tak xjelon-apo re Pedro riq'uin re Jesús y xubij cha: Ajaf, vo xa jun hermano can nojel tiempo c'o andex man otz-ta nuban chua, ¿jenipa' c'a bey otz che nincuy rumac? ¿La otz como che nincuy vuku' bey rumac? xcha' re Pedro cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Pero re Jesús xubij cha re Pedro: Yen man nimbij-ta chava che can ruc'amon che nacuy vuku' bey rumac jun hermano re c'o andex man otz-ta nuban chava. Yen nimbij chava che jun hermano can ruc'amon che nacuy setenta veces siete. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Roma chupan re ru-gobierno re Dios, can nibanataj ancha'l xbanataj riq'uin jun Rey. Re Rey re' nrajo' nutamaj jenipa' quic'as cada jun chique re ye'samaj riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y tak re Rey re' xutz'am rubanic cuentas, c'o c'a jun chique re rusamajel re can pa millón ruc'as riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Y re samajel re' man nitiquir-ta nutoj ronojel re ruc'as re rubanon riq'uin re Rey, mare' xpa re Rey xubij che mejor tic'ayex re samajel re' y chibil chuka' re ruxayil y re cajc'ual. Y can que'c'ayex chuka' ronojel re andex richin, y ronojel re mero xtimolotaj toc pa ruq'uixel re ruc'as. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Can jare' tak re samajel re' xuque' chach re Rey y re nic'aj-rach c'a pan ulef xka-va-ka, y camas nuc'utuj utzil cha. Y ja quire' nubila' re samajel cha re Rey: Tabana' utzil quinayabej chic ba'. Yen can xtintoj ronojel re nuc'as chava. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y re Rey re' camas c'a xujoyovaj rach re rusamajel, y can xucuy re ruc'as y mare' man jun chic andex xuban cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Y jac'a tak elinak chic-a libre roma xcuy re ruc'as, xbo'rc'ulu-pa jun chic samajel re c'o ba' c'as rubanon riq'uin. Y re ruc'as re jun chic samajel re' xaxe cien denarios. Pero man riq'uin re', reja' can man xucuy-ta re ruc'as, y mare' xutz'am chukul y nutz'apij-yan-ka ruxla', y nubij c'a cha: Tatojo-pa re c'as abanon viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y xpa re samajel re' can jare' xuque-ka chach, y re nic'aj-rach c'a pan ulef xka-va-ka, y camas c'a nuc'utuj utzil cha re jun chic samajel re anchok riq'uin c'o-va ruc'as, y nubij cha: Quinayabej chic ba' y yen can xtintoj ronojel chava, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero re samajel re anchok riq'uin banon-va re c'as, man xka-ta chach re xbex cha, mare' xusujuj chin xuya' pa cárcel, chin che kas nutz'at-na andex nuban chin che nutoj can re ruc'as, chin quire' ndel-pa libre. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y re nic'aj chic quichibil-qui' pa samaj tak xquitz'at ronojel re xbanataj, xpa bis pa tak cánma. Y reje' xe'ba riq'uin re qui-patrón y xbequitzijoj ronojel re xuban re jun samajel riq'uin re jun chic samajel. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y re Rey, re qui-patrón, can jare' xutak ruyoxic re samajel re man otz-ta xuban, y xubij cha: Rat, xa yat jun itzel samajel. Yen can xincuy ronojel re ac'as, roma can ja quire' xac'utuj chua. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Y quire-ta chuka' ruc'amon che xaban-ta rat riq'uin re avchibil pa samaj, ancha'l ximban yen aviq'uin che xinjoyovaj avach. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y can jare' tak re Rey re qui-patrón re samajela', xyacataj ruyoval xujach-a re jun itzel samajel pa quik'a' re achi'a' re ye'beyi'o can re presos pa cárcel, y chire' pa cárcel can xtiban cha che nuk'asaj tijoj-pokonal c'aja tak nitojtaj-na can ronojel re ruc'as. ");
INSERT INTO cakYNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Can quire' xtuban re Nata' Dios re c'o chila' chicaj iviq'uin yex, vo xa man riq'uin-ta ronojel ivánma nicuy quimac re hermanos tak c'o jun andex re man otz-ta niquiban chiva, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y tak re Jesús xtane' chubixic re tzij re', reja' xba y xuya' c'a can re lugar rubini'an Galilea y chuka' yoj re yoj ru-discípulos xojba chij c'a quila pa Judea, y xojak'ax c'a juc'an chic-apo re rakan-ya' rubini'an Jordán. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Y chire' camas c'a je q'uiy vinak re xe'tzekelben chin re Jesús, y jec'o chuka' yava'i' xe'ruc'achojsaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y jare' tak jec'o achi'a' fariseos xe'bapon riq'uin re Jesús chin niquitojtobej y chin che nitzak-ta pa quik'a'. Y mare' xquic'utuj cha: ¿La ruc'amon como che jun ache nujach-ri' riq'uin re ruxayil xa chak roma xabanchique cosa? ");
INSERT INTO cakYNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pero re Jesús xubij chique re achi'a' re': Yex can ibanon leer re nubij chupan re ruch'abal re Dios, re anche' nubij-va che tak xtz'ucutaj-pa, re Dios ache y ixok xuban y man rion-ta jun. Can man rion-ta re ache, y chuka' can man rion-ta re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y chuka' yex ibanon leer re nubij chupan re ruch'abal re Dios che re ache man chic quiq'uin-ta rute-rutota' xtic'ue-va. Xa riq'uin re ruxayil xtic'ue-va, y che je ca'e' xa jun c'a xtiquiban. Quire' nubij re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y tak quic'uan chic-qui', man chic je ca'e-ta vinak, xa jun chic quibanon. Mare' re xa jun chic rubanon re Dios chique, man tuban re vinak che ye'rujach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y re achi'a' fariseos xquic'utuj chic cha re Jesús: Vo xa man ruc'amon-ta che quire' niban, ¿anchique c'a roma tak re Moisés xubij che jun ache, xaxe tubana' jun vuj re anche' nubij-va che xujach-ri' riq'uin re ruxayil y tuya' can? ");
INSERT INTO cakYNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y re Jesús xubij chique re achi'a' re': Can ancha'l c'a icoversan re ivánma yex chupan re etzelal, can quire' chuka' xbanataj ajuer can pa ru-tiempo re Moisés. Xa mare' tak reja' xubij che re ache c'o modo nujach-ri' riq'uin re ruxayil. Y astapa' tak xtz'ucutaj-pa man quire-ta xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Yen nimbij chiva che xabanchique ache nujach-ri' riq'uin re ruxayil y man roma-ta che re ixok nucanoj chic jun ache, y vo xa re ache nic'ule' chic riq'uin jun chic ixok, re ache re' nimacun chach re Dios. Y vo xa c'o jun ache nic'ule-apo riq'uin re ixok yi'on can roma re ruchijil, chuka' re ache re' can nimacun chach re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y yoj re yoj discípulos xkabij cha re Jesús: Vo xa jun ache can nojel tiempo ximon riq'uin re ruxayil, más-ta otz cha re ache che man-ta nic'ue' ruxayil. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y re Jesús can jare' tak xubij chaka: Man conojel-ta otz ruc'ulic niquiban cha re tzij re xibij, roma man conojel-ta yi'on-va k'ij che quire-ta niquiban, y man-ta ye'c'ule'. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y can jec'o-va achi'a' re can ja tak xa'lax quiq'uin re quite', jare' tak nik'alajin che can man xtiquicanoj-ta ixoki'. Jec'o chuka' achi'a' quire' quibanon, pero xa roma ja re doctores xe'bano chique. Y jec'o chuka' achi'a' quire' quibanon, pero re' xa quiq'uin reje' mismo xpo-va che man niquicanoj-ta ixoki', chin che más otz ye'samaj pa rusamaj re Dios y can ye'quito' re ye'oc pa ruk'a' re Dios. Re jun re can nuna' che nitiquir nuban che man nic'ule-ta, man c'a tic'ule', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y jec'o ac'ola' xe'c'uax-apo chach re Jesús, chin che reja' nuya-a ruk'a' pa quive' y chuka' chin che nuban orar cha re Dios pa quive' re ac'ola' re'. Pero yoj re yoj ru-discípulos xkabij chique re vinak che man que'quic'amala-pa re ac'ola' riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero xpa re Jesús xubij chaka: Tiya' k'ij chique re ac'ola' che que'pa viq'uin, y man que'ik'at. Roma re xque'oc pa ruk'a' re Dios, xaxe re je ancha'l ac'ola'. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y tak re Jesús xuban-yan orar cha re Dios y xuyala-yan can ruk'a' pa quive' re ac'ola', reja' xba y xuya' can re lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y c'o c'a jun c'ajol ache xapon riq'uin re Jesús y xubij cha: Rat utzulaj Maestro tabij c'a chua, ¿anchique cosa otz ruc'amon che nimban yen chin quire' nic'ue-ta nuc'aslen re man niq'uis-ta? ");
INSERT INTO cakYNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y re Jesús xubij cha: ¿Anchique roma tak nabij chua che yen yin otz? Roma can man jun vinak re otz-ta, xa can xe c'a Jun re otz y re' ja re Dios. Vo xa rat najo' yatoc chupan re c'aslen re man niq'uis-ta, can ca'bana' re nubij re mandamientos. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Xpa re c'ajol ache re' xuc'utuj cha re Jesús: ¿Y andex c'a nubij re mandamientos re'? Y re Jesús xubij cha: Re nubij re mandamientos re' ja che man caquimisan, rat ache re yatc'ulan man camacun riq'uin jun chic ixok, man catelak', man tatz'uc tzij chij jun chic vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Taya' quik'ij re ate-arta'. Y can ancha'l najo-ka-avi' rat, quire' chuka' ca'jo' re nic'aj chic vinak. Ja quire' nubij re mandamientos, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y re c'ajol ache xubij cha re Jesús: C'a yin co'ol che' tak nbanom-pa ronojel re'. ¿Y anchique c'a re man nbanon-ta? xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y re Jesús xubij cha: Vo xa rat can najo' che yatel choj chach re Dios, xaxe chic c'a jun re man abanon-ta. Y re' ja re man ajachon-ta re abiyomal chiquivach re vinak re camas je meba'. Ta'c'ayij ronojel re c'o aviq'uin y re rajal tajacha' chiquivach re vinak re camas je meba', chin quire' nic'ue' abiyomal chila' chicaj. Y catampa viq'uin y catzake' chuij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tak re c'ajol ache xuc'axaj re tzij re xubij re Jesús, nibison ránma xtzolaj-a, roma reja' camas biyom y man nrajo-ta che ndel re biyomal pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Can jare' tak re Jesús xubij chaka yoj re yoj ru-discípulos: Can katzij nimbij, che camas c'ayef cha jun biyom che ndoc-ta pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mare' yen nimbij che man c'ayef-ta nak'ax jun camello pa ch'et rujulil jun bak chin t'iso'n, que chach jun biyom ndoc-ta pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y tak yoj re yoj ru-discípulos re Jesús xkac'axaj re tzij re', can anchique-la xkana'. Y nakabila' chakavach: Vo xa can ancha'l re nubij, quire', man jun xticolotaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Re Jesús xojrutzu-pa y xubij chaka: Man tinojij quire'. Re vinak man ye'tiquir-ta niquicol-qui', pero re Dios can ronojel nitiquir nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y jare' tak re Pedro xubij cha re Jesús: Rat ataman che yoj kayi'on can ronojel re c'o kaq'uin, chin che yojtzakatal chavij. ¿Y andex c'a re rajal-ruq'uixel xtakac'ul yoj roma kayi'on can ronojel? ");
INSERT INTO cakYNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Re Jesús xubij: Can katzij nimbij chiva che tak xtapon re tiempo tak xtijalataj ronojel, yen re xinalax chi'icojol c'o chic nuk'ij y xquintz'uye' chach jun ch'acat chin nimban juzgar. Y ja chuka' quire' yex re xixtzake' chuij, y cada jun chiva che yix doce re xquixtz'uye' chach jun ch'acat chin niban juzgar pa quive' re je doce grupo israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xabanchique vinak re nutzij yen ruyi'on can rachoch, ruch'alal, rute-rutota', ruxayil, rajc'ual o rulef, can q'uiy c'a re xtuc'ul. Can pa ciento c'a bey más re xtuc'ul y can xtuvel chuka' ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y vocame camas je q'uiy re c'o quik'ij, y xtapon re k'ij tak manak chic quik'ij xtic'ue'. Y je q'uiy re manak quik'ij vocame, pero can xtapon re k'ij tak can xtic'ue' quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Re ru-gobierno re Dios can junan riq'uin re xuban jun ache tata'aj pa jun jay, reja' namak'a-yan xba chiquicanoxic mozos chin ye'samaj pa rujuyu' re ruticon uva chach. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tak re ache re' xe'ruvel re ru-mozos y xch'o-yan quiq'uin che can xtuya' ja'jun denario chin quik'ij, c'are' xe'rutak-a pa rujuyu' chin ye'besamaj riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Y como a las nueve la'k re namak'a' re', reja' xba chic jun bey y chire' pa q'uiybal xe'rutz'at che jec'o re manak quisamaj quivilon. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xpa reja' xch'o quiq'uin y xubij chique: ¿Y yex manak samaj nijo'? Roma vo xa c'o samaj nijo', quixbiyin viq'uin y quixe samaj pa nujuyu' re c'o uva nticon chach, y yen can xtintoj otz chiva, xcha' chique. Y re mozos re' can xe'bo-va chuka' pa samaj riq'uin re ache re xch'o quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Y re rajaf re juyu' xba chic jun bey re pa nic'aj k'ij y re pa tak a las tres re tak'ak'ij re', y can xe'ruvel chic nic'aj mozos re hora re'. Y reja' can xe'rutak-a chin che ne'quibana' re rusamaj y xubij chique che can otz xtutoj chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y re pa tak a las cinco re tak'ak'ij, reja' xba chic jun bey y xe'ruvel chic-pa nic'aj chic mozos. Y reja' xubij chique re mozos re': ¿Anchique roma yex tak man ivilon-ta isamaj y can che jun k'ij yixc'o vova'? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y re mozos re' xquibij: Man jun xyi'o kasamaj. Y re rajaf juyu' xubij chique re mozos re': Anchique roma man yixe'samaj pa nujuyu' re nticon uva chach y can xtintoj otz chiva, xcha' chique. Y re mozos re' can xe'bo-va chuka' pa rujuyu' chin xe'besamaj riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Jac'a tak xoc-ka re ak'a', xpa re rajaf re juyu' re c'o tico'n chach, xubij cha re ec'uay quichin re mozos: Ca'vayoj-pa conojel re mozos chin ya'toj-a. Pero nabey ca'vayoj-pa re mozos re xe'beka c'a pa ruq'uisibal, y ja re mozos re xe'beka nabey jare' re c'a después xca'vayoj-pa, xcha' re patrón. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Y re mozos re xe'oc pa samaj pa tak a las cinco re tak'ak'ij, xe'bapon chin ne'quic'ama-pa re qui-mero re quich'acon, y can ja re jenipa' niquich'ac jun k'ij jare' xya-pa chique, roma ja quire' xrajo' re rajaf re juyu', che nuya' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y tak xe'bapon re mozos re xe'oc pa samaj nabey, chin ne'quic'ama-pa re quich'acon, reje' xquinojij che c'o más xtiya-pa chique que chiquivach re nic'aj chic re xa man rubanon-ta jun k'ij re xe'samaj. Jac'a tak xe'toj-pa, c'ajare' tak xquitz'at che xa junan xquich'ac quiq'uin re nic'aj chic re man xe'samaj-ta che jun k'ij entero. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tak xe'toj-yan re mozos re', c'are' xquitz'at che xa junan xquich'ac quiq'uin re nic'aj chic, mare' xquich'ojij anchique roma can junan xkach'ac konojel. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Re mozos re' ja quire' niquibij: Re mozos re xe'oc c'a pa ruq'uisibal pa samaj, re can xe-oc jun hora xe'samaj, can junan xatoj chique can ancha'l xatoj chaka yoj, y yoj can che jun k'ij entero xojsamaj y can xk'ax ronojel re rach k'ij chakij, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y re rajaf re samaj xubij cha jun chique re mozos re': Riq'uin che junan xe'ntoj re nic'aj chic mozos man jun cosa re man otz-ta ximban chava rat. Roma aviq'uin rat xa can yojcanajnak can che jun denario ninya' chin ak'ij. ¿Ne'ka cha'c'o'x? ");
INSERT INTO cakYNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Rat tac'uaj-a re jenipa' xinsuj chin ak'ij y otz yaba. Y jac'a chique re mozos re c'a pa ruq'uisibal xe'oc pa samaj, can pa vánma yen xpo-va chin che xintoj ancha'l xintoj chava rat. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Roma ronojel re c'o viq'uin, can pa nuk'a' yen c'o-va chin xabanchique ninjo' nimban riq'uin. Rat man otz-ta nana' chua yen tak xa ja re otz ntz'amon rubanic. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Re ejemplo re' nubij andex rubixic re tzij: Je q'uiy re camas quik'ij vocame, y xtapon re k'ij tak manak chic quik'ij xtic'ue'. Y je q'uiy re manak quik'ij vocame, xtapon re k'ij tak xtic'ue' quik'ij. Y astapa' je q'uiy re ye'vayox, pero man conojel-ta re xque'cha' chin nic'ue' quik'ij. Ja quire' xubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Re Jesús y yoj re yoj doce ru-discípulos y re nic'aj chic vinak je'binak kaq'uin, katz'amon-a re bey re niba pa tenemit Jerusalén. Y jare' tak re Jesús xojrujech'aj-a ba' yoj re yoj ru-discípulos roma nrajo' nich'o kaq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Reja' xubij chaka: Yex itaman che pa tenemit Jerusalén katz'amon-va-a bey, y ja chire' xquinjach-va yen re xinalax chi'icojol. Xquinjach pa quik'a' re principal tak sacerdotes y pa quik'a' re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. Y reje' xtiquibij che quinquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y chuka' xquinquijach pa quik'a' vinak re man je israelitas-ta. Y re vinak re' xque'tze'en chuij, xquinquich'ay y c'are' xquinquibajij cho cruz chin xquinquiquimisaj. Pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y re je ca'e' discípulos re je ruc'ajol re jun ache rubini'an Zebedeo, xe'jelon-apo riq'uin re Jesús, y can chibil chuka' re quite'. Y re quite' xuque' chach re Jesús chin che nuc'utuj jun utzil cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Re Jesús xubij cha re te'ej re': ¿Andex re najo'? Y re ixok xubij cha re Jesús: Yen ninjo' che tak ja chic rat re yabano gobernar, can-ta xtaban chique re je ca'e' val re' che ye'tz'uye-ta-apo aviq'uin, jun-ta re nitz'uye-apo pan avajquik'a' y jun-ta re pan axocon. Can tabana' chique che nic'ue-ta quik'ij, xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Y jare' tak re Jesús xubij: Yex man itaman-ta che can c'ayef nuban chiva re nic'utuj. Y mare' yen ninc'utuj chiva vocame: ¿Nicoch' como yex re xtiban chua yen? ¿Y nicoch' como chuka' yex jun tijoj-pokonal ancha'l re xtika pa nue' yen? Y re je ca'e' discípulos re' xquibij: Nakacoch', xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y re Jesús xubij chic chique: Can katzij che yex xticoch' re ancha'l xtiban chua yen. Chuka' can xticoch' jun tijoj-pokonal ancha'l re xtika pa nue' yen. Jac'a re nic'utuj chua che jun nitz'uye' vajquik'a' y jun pa noxocon, re' man pa nuk'a-ta yen c'o-va chin che ninya' chiva. Roma re nic'utuj yex, re' xa can quichin chic re xtubij re Nata' che otz che ye'tz'uye' chire', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y tak re yoj lajuj chic discípulos xkac'axaj re niquijo' re je ca'e' discípulos quichak'-qui', yoj xpa kayoval chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Can jare' tak re Jesús xojrayoj y xubij chaka: Yen nimbij che yex jabal itaman che re ye'bano gobernar vova' chach re ruch'ulef, ja reje' re ye'bano mandar pa quive' re vinak, mare' can niquina' che ja reje' re je cajaf. Xa can xe re c'o quik'ij jare' re ye'bin re andex niban. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero re chi'icojol yex man quire-ta. Roma vo xa c'o jun chiva yex re nrajo' nic'ue' ruk'ij, can tuna-ka-ri' che xa manak ruk'ij y tusuju-ri' chin nuban xabanchique samaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Vo xa jun chiva yex can nrajo' che ja reja' re nabey y c'o-ta ruk'ij, can tuna-ka-ri' che xa manak ruk'ij y tusuju-ri' chin nuban xabanchique samaj, ");
INSERT INTO cakYNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","y can tubana' ancha'l re nimban yen re xinalax chi'icojol. Yen man nimpokonaj-ta yinsamaj pa qui-cuenta re vinak, roma can chubanic-va re' tak ximpa, y man ximpa-ta chin che jec'o chic nic'aj ye'bano-pa re nimbij chique. Can jac'a yen re yimbano re samaj, y can xtinya' chuka' re nuc'aslen chin quire' je q'uiy re ye'colotaj chach re quimac, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Re Jesús y yoj re yoj ru-discípulos tak xojel-a chupan re tenemit rubini'an Jericó, camas je q'uiy vinak re xe'tzake-a chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Y jare' tak je ca'e' moyi' je'tz'uyul chuchi-bey y xquic'axaj che re Jesús can jare' nak'ax-a chire' anche' jec'o-va, xe'pa reje' cof xe'ch'o y xquibij: Rat Ajaf, re yat rey-rumam can re Rey David, tajoyovaj kavach roma quire' kabanon. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y re vinak xquibila' chique: Ch'oj-ichi'. Pero reje' xa más cof xe'ch'o y xquibij: Rat Ajaf, re yat rey-rumam can re Rey David, tajoyovaj kavach roma quire' kabanon. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y re Jesús xuc'axaj re quich'abal. Mare' xpa'e' y xe'rayoj. Y c'are' xubij chique: ¿Andex c'a re nijo'? ");
INSERT INTO cakYNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Reje' xquibij cha re Jesús: Ajaf, yoj nakajo' yojtzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Re Jesús roma camas xujoyovaj quivach re je ca'e' moyi' re', can jare' tak xutz'am re quinak'avach, y reje' xe'tzu'un. Y xe'tzake-a chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Re Jesús y yoj re yoj ru-discípulos, y re nic'aj chic vinak je'binak kaq'uin, nakaj chic c'a yojc'o-va-apo cha re tenemit Jerusalén. Chire' chic c'a pa Betfagé yojc'o-va, re aldea re' chach re loma rubini'an Olivos c'o-va-apo. Y xpa re Jesús xe'rutak-a je ca'e' chaka yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Reja' xubij-a chique: Quixbiyin-apo chupan la aldea la nitz'at-apo chila', y can xe xquixoc-apo, jare' xtivel jun alaj burro c'o riq'uin re rute'. Tisolo-pa re te'ej y que'c'ama-pa che je ca'e' chua. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y vo xa c'o jun xtibim-pa chiva anchique roma ye'sol-a re chicop, tibij c'a can cha: Ndoc cha re Ajaf, pero cha'nin xque'bo'rya' chic can, xe'cho'x-a re je ca'e' discípulos roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Y riq'uin re' can xbanataj ancha'l re tz'iban can roma re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re rutz'iban can reja', ja quire' nubij: ");
INSERT INTO cakYNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' c'a rutzijol chique re je richin chic re tenemit rubini'an Sion, che re qui-Rey ja re pitinak. Re qui-Rey can ch'o'l-va c'a ránma. Y reja' ch'ocol-pa chij jun alaj burro. Re alaj burro ral jun chicop chin ejka'n. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y re je ca'e' discípulos xe'ba, y can xquiban-va re bin-a chique roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquic'am-pa re alaj burro y re te'ej cha re Jesús. C'are' yoj re yoj ru-discípulos xkaya-a re kak'u' chiquij re je ca'e' chicop re', chin che re Jesús xch'oque-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y camas-va je q'uiy re vinak re je'binak chij re Jesús. Y can bama conojel chique reje' re xquiriq'uila' quik'u' pa rubey re Jesús chin che niquiya' ruk'ij. Y nic'aj chic chin che niquiya' chuka' ruk'ij re Jesús xe'bequic'amala-pa ruk'a' tak che' chin niquivak pa rubey. Y quire' c'a niquibanala' je nabey chach re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y re vinak re je nabey chach re Jesús y re je xambay can, jun pa quichi' niquibij: ¡Matiox che pitinak re rey-rumam can re Rey David! ¡Reja' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! ¡Matiox cha re Dios re c'o chila' chicaj! ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jac'a tak re Jesús xoc-apo pa tenemit Jerusalén, cha'nin xquimol-qui' re vinak chutz'etic. Y re vinak re' niquibila': ¿Anchique c'a che ache re'? ");
INSERT INTO cakYNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Pero jec'o xe'bin: Jare' re Jesús, re rusamajel re Dios re nibex profeta cha. Reja' aj pa tenemit Nazaret, re c'o chire' pa Galilea, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y tak re Jesús xoc-apo pa rachoch re Dios re c'o pa tenemit Jerusalén, xutz'at che can ancha'l q'uiybal quibanon re vinak cha, xe'rukotaj-pa conojel re vinak ye'c'ayin y re ye'lok'on. Y chique re vinak re ye'jalo rach mero xe'rutiquimila' can re qui-mesas. Y quire' chuka' xuban can chique re quich'acat re ye'c'ayin palomas. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Re Jesús xubij chique re vinak re': Chupan re ruch'abal re Dios tz'iban can, nubij che re vachoch, jay chin oración. Jac'a yex xa ancha'l cachoch elek'oma' ibanon cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Tak re Jesús c'o pa rachoch re Dios, jec'o moyi' y jec'o chuka' cojos xe'bapon riq'uin chin che ye'ruc'achojsaj-a. Y reja' can xe'ruc'achojsaj-va-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero re principal tak sacerdotes y re je'atamayon re ley kachin yoj re yoj israelitas xpa quiyoval, roma xquitz'at che camas q'uiy milagros ye'rubanala' re Jesús, y roma chuka' re ac'ola' jun pa quichi' niquibila' chire' chach re rachoch re Dios: ¡Matiox che xbeka re rey-rumam can re Rey David! ye'cha'. Y jare' xbano chique re principal tak sacerdotes y re je'atamayon re ley che xpa quiyoval. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Mare' tak xquibij cha re Jesús: ¿Nac'axaj re ye'tajin chubixic re ac'ola'? Y re Jesús xubij chique: Ja', ninc'axaj. Y yex ibanon leer re nubij chupan re ruch'abal re Dios che re can katzij ye'yi'o ruk'ij re Dios ja re ac'ola' y re ch'utak ac'ola' re c'a ye'tz'uman, xcha' re Jesús chique re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Xpa re Jesús xe'ruya' can chire' re achi'a' re'. Reja' xel-a pa tenemit Jerusalén y xba c'a pan aldea rubini'an Betania. C'a chire' c'a xbo-va chin xbexulan re jun ak'a' re', y chuka' yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y namak'a' cha re ruca'n k'ij, tak yojbinak chin che yojtzolaj pa tenemit Jerusalén, re Jesús xpa ch'umunic rupan. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y tak yojbinak, reja' xutz'at jun che' rubini'an higuera tiquil chuchi-bey. Xba-apo chuxe' chin no'rcanoj-pa vo xa c'o rach, pero xa manak rach, xa rion ruxak. Jare' tak re Jesús xubij cha re che': Can man jun bey chic xcavachin. Y re higuera re' can cha'nin xchakij-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Y tak yoj re yoj discípulos xkatz'at che chake'j chic re higuera, xkabila' chakavach: ¿Anchique roma che cha'nin xchakij-ka re higuera re'? ");
INSERT INTO cakYNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xpa re Jesús xubij chaka: Can katzij nimbij chiva: Vo xa yex can niban confiar-ivi' riq'uin re Dios y man nibij-ta-ka pa tak ivánma che xa man la'k nibanataj-ta re', can xquixtiquir niban quire' cha jun higuera. Y can c'o cosas re más je nima'k que chach re jun re' re yixtiquir niban. Yex yixtiquir nibij cha re loma re' che tel-a vova' y tak'ax chupan re mar, y can xtibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Can ronojel-va c'a re nic'utuj cha re Dios riq'uin ronojel ivánma, can xtic'ul-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y tak re Jesús c'o chic pa rachoch re Dios y nuc'ut re ruch'abal re Dios chiquivach re vinak, re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xe'bapon-apo riq'uin re Jesús y xquic'utuj cha: ¿Anchique xyi'o autoridad pan ak'a' chin xa'kotaj-a re vinak xe'c'ayin pa rachoch re Dios? ¿Y anchique chuka' xyi'o autoridad chava chin che q'uiy cosas ya'banala' chiquicojol re vinak? ");
INSERT INTO cakYNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xpa re Jesús xubij chique: Yen c'o chuka' jun cosa ninjo' ninc'utuj chiva, y vo xa yex xtibij chua, yen chuka' xtimbij chiva anchique ya'yon autoridad pa nuk'a' chin ye'mbanala' re cosas re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y jare' tak re Jesús xuc'utuj: ¿Re Juan xtak-pa roma re Dios chin xe'ruban bautizar re vinak? ¿O xa vinak xe'bin cha che quire' tubana'? Y re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij xquibila' c'a chiquivach: ¿Y vocame andex c'a xtakabij cha re Jesús? Roma vo xa xtakabij che re Juan ja re Dios takayom-pa richin, re Jesús xtubij chaka che anchique roma tak man xinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y vo xa xtakabij che xa vinak xe'bin cha re Juan che quire' tubana', can c'ayef nuban chaka yoj, roma re vinak xque'yacataj chakij. Roma conojel vinak je'atamayon che re Juan can jun rusamajel re Dios re xbex profeta cha, xe'cha-ka chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y c'are' xquibij-apo cha re Jesús: Yoj man kataman-ta. Y re Jesús can jare' chuka' tak xubij chique re achi'a' re': Roma yex man xixtiquir-ta xibij chua, quire' chuka' yen man xtimbij-ta chiva anchique ya'yon autoridad chua chin ye'mbanala' qui tak re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","C'are' re Jesús xubij chic chique re achi'a' re': ¿Andex ninojij chij re jun ejemplo re'? C'o c'a jun ache jec'o je ca'e' ruc'ajol. Y xpa re tata'aj xba riq'uin re jun ruc'ajol nemalaxel chin xbo'rbij cha: Vocame, cabiyin pa samaj anche' katicon-va uva. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xpa re ruc'ajol re' xubij cha re rutota': Vocame man ninjo-ta yimba pa samaj. Pero después can xbo-va pa samaj roma xuna' che man otz-ta xuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y re tata'aj xba chuka' riq'uin re jun chic ruc'ajol re chak'alaxel chin xbo'rbij cha, che tiba pa samaj. Y re ruc'ajol re' xubij cha: Ja papá, yimba. Pero re ruc'ajol re' xa man xba-ta pa samaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Y c'are' re Jesús xuc'utuj: ¿Anchique che je ca'e' re xbano re nrajo' re tata'aj? Y re achi'a' re' xquibij: Re xbano re nrajo' re tata'aj ja re nemalaxel. Y re Jesús xubij chique: Can katzij nimbij chiva che xa ja re molay tak impuestos y re ixoki' re man otz-ta quic'aslen, xa ja reje' re nabey ye'oc pa ruk'a' re Dios que chivach yex, roma reje' can nijalataj re quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Re Juan Bautista tak xpa, xuc'ut jun bey choj chivach, jac'a yex man xinimaj-ta. Xaxe re molay tak impuestos y re ixoki' re man otz-ta quic'aslen, xaxe reje' re xe'niman. Jac'a yex, man riq'uin re' cama-va xjalataj-ta re ic'aslen chach re Dios y chuka' cama-va xinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Y tic'axaj-na-pa' re jun chic ejemplo re', xcha' re Jesús chique re vinak: Xc'ue' jun tata'aj, y xpa reja' xutic uva chach re rujuyu' y c'are' xuban co'c chij. Xuban chuka' ancha'l jun ch'et pila pan ulef anche' niyitz'-va re uva, y xuban chuka' jun torre y pa rue' re torre xc'ue-va rachoch re nichajin chin re juyu'. C'are' xuya' can pa kajic chique je ca'e-oxe' achi'a', y reja' c'ac'anaj xbo-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y tak xapon re tiempo chin re cosecha, re rajaf re juyu' xutak jun ru-mozo, y c'are' xutak chic-a jun. Y can je q'uiy re mozos re xe'rutak-a chuc'amic re uva kajbal chin re juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero re achi'a' kajoy tak ulef, xa man otz-ta quic'ulic xquiban chique re mozos je'takon-a roma re rajaf re juyu'. C'o nic'aj xe'quich'ay, jec'o xe'quiq'uiak cha aboj y jec'o xe'quiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Y re rajaf re juyu' re jun chic bey re' más je q'uiy re mozos xe'rutakala-a. Pero re achi'a' kajoy tak ulef ja mismo re xquibanala-pa chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruq'uisibal re rajaf re juyu' xunojij y xubij: Re achi'a' kajoy tak ulef, tak xtiquitz'at che can ja re nuc'ajol xtapon quiq'uin, can xtiquinimaj-va, xcha-ka pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero re achi'a' re je'kajayon re ulef, can xe xquitz'at che ja re ruc'ajol re rajaf re juyu' xapon, xquibila' chiquivach: Jare' re xtoc can rajaf ronojel re juyu' kakajon. ¿Anchique roma man nakaquimisaj? Chin quire' pa kak'a' yoj nic'ue-va can re juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y can quire-va xquiban cha. Xquitz'am y c'are' xquilisaj-a chire' chupan re rujuyu' y xquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","C'are' re Jesús xubij: Tak xtipa re rajaf re juyu' tiquil uva chach, ¿andex como xtuban chique re achi'a' kajoy tak ulef, ninojij yex? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y re vinak xquibij: Re rajaf re juyu' man xtujoyovaj-ta quivach re itzel tak achi'a' kajoy tak ulef y can xque'ruquimisaj, y c'are' re rujuyu' xtuya' chic can pa kajic chique nic'aj chic achi'a' kajoy tak ulef, re can xtiquiya-va re uva kajbal chin re ulef tak napon re tiempo chin re cosecha, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xpa re Jesús xubij chique: Yex ibanon leer re jun ch'abal re tz'iban can chupan re ruch'abal re Dios. Re ch'abal re' nubij quire': C'o c'a jun aboj re man xka-ta chiquivach re banoy tak jay. Pero re aboj re' can xoc-va, roma re aboj re' xa can c'o-va xcusan richin, y ja aboj re' re tz'amayon chin re jay chin che man nitzak-ta. Roma can ja-va re Ajaf xbano re', y re inak'avach can man jun bey quitz'eton che quire-ta nibanataj. Quire' nubij chupan re ruch'abal re Dios re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y roma re quire' je'banatajnak, yex man chic xquixc'ue-ta pa ruk'a' re Dios, xa ja re vinak re can xtivachin re quic'aslen xa ja reje' re xque'c'ue' pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Y re vinak re xtitzak chach re jun aboj re' can xtic'ajer. Y re vinak re xtika re aboj re' chij, can xtuqui'ej jumul, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y tak re principal tak sacerdotes y re achi'a' fariseos xquic'axaj re ejemplos re xe'rutzijoj re Jesús, can xk'ax pa quive' che chiquij reje' xch'o-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y can jare' tak reje' xquijo' xquitz'am-ta-a re Jesús. Pero man xquitz'am-ta roma niquixibij-qui' chiquivach re vinak, roma chiquivach re vinak re Jesús can jun rusamajel re Dios re nibex profeta cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Y re Jesús xutz'am chic tzij jun bey quiq'uin re vinak, y xe'rucusaj nic'aj chic ejemplos y ja quire' re xubila': ");
INSERT INTO cakYNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Jun bey jun Rey xuban jun namak'ij roma xc'ule' re ruc'ajol, re' can junan riq'uin tak re vinak ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Y re Rey re' can c'o-va je'rubanon invitar chin che ye'bapon pa namak'ij roma re c'ulubic re', y mare' xe'rutak-a re ru-mozos chiquiyoxic re vinak re'. Pero re vinak re xba quiyoxic man xquijo-ta xe'bapon. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y c'are' re Rey xe'rutak chic-a nic'aj ru-mozos y xubij-a chique: Tibij chique conojel re je'mbanon invitar chin re jun namak'ij re', che ronojel c'o chic listo chin nakaban re va'in. Re achija' tak nuvacx y re nic'aj chic chicop jabal je tioji' chin ye'oc chupan re k'ij re', xe'quimisas-yan y je'banalon chic rubanic chin ye'tij. Can ronojel c'o chic listo, y can tiquibana' utzil che que'pa chupan re jun c'ulubic re', xcha-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero re je'banon invitar can man xcajo-ta xe'pa tak xbebex chic jun bey chique. Jec'o xa xe'ba pa tak quisamaj re c'o pak'os, y jec'o xa xe'ba pa tak quic'ayij. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Jac'a re nic'aj chic xa xe'quitz'am re achi'a' re je'rutakon-a re Rey, y xe'quiquimisaj, roma chiquivach reje' re ru-mozos re Rey xa can man jun quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jac'a tak xapon rutzijol riq'uin re Rey re andex xbanataj, jare' xbano cha reja' che xpa ruyoval. Can jare' tak reja' xe'rutak-a re ru-soldados chin che ye'quiq'uis can re xe'quimisan quichin re ru-mozos re Rey, y re Rey xubij-a chuka' chique che tiquinima' can ruk'ak'al re quitenemit. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'are' re Rey xch'o chic chique re ru-mozos: Can katzij-va che ronojel c'o chic listo chin niban re c'ulubic, xa jac'a re xe'mban invitar man xe'pa-ta, y can otz xquiban che man xe'pa-ta, roma cama-va ruc'amon-ta che ye'c'ue' chupan re c'ulubic re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Vocame, quixbiyin pa tak calles chin re katenemit, que'ibana-pa invitar conojel chin che ye'pa vova' chupan re c'ulubic, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y re ru-mozos can xe'bo-va pa tak calles, xe'quiban c'a-pa invitar ronojel quivach vinak, can xe'quijocoquej-pa, re otz y man otz-ta quic'aslen chiquivach re vinak. Y re jay re anche' xban-va re c'ulubic, can xnoj. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y c'are' re Rey xoc-apo pa jay chiquitz'etic conojel re xe'ruban invitar. Y reja' xutz'at c'a che c'o jun ache chire' pa jay re man rucusan-ta-a re rutziak re nic'atzin chupan re jun c'ulubic re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Y re ache re' can banon-va invitar chuka', y xpa re Rey xuc'utuj cha: Y rat ¿anchique roma can man xaxibij-ta-avi' chin xatoc-pa vova'? Roma xa mana-ta re atziak re nic'atzin chupan re jun c'ulubic re' re acusam-pa. Y re ache man jun tzij xtiquir xubij, xa can xmemur chach re Rey. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Y re Rey jare' tak xubij chique re ru-mozos: Tixima' ruk'a-rakan re jun ache re xa man xucusaj-ta-pa rutziak re nic'atzin che rucusan-ta-pa, mare' tilisaj-a y te'ich'akij chupan re lugar camas k'oko'm. Y c'aja chire' c'a xtipo-va re ok'ej chach y can xtukach'ach'ej roray. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y astapa' can je q'uiy-va re ye'vayox, pero man conojel-ta je'cha'on chin che ye'oc pa ruk'a' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y re achi'a' fariseos xe'ba. Reje' xbequiya' chiquivach chin che c'o-ta andex niquiban chin che re Jesús nitzak-ta pa quik'a' riq'uin re tzij re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Y jare' tak re achi'a' fariseos xe'bequitakala-pa re ye'tzekelben quichin y chibil chuka' je ca'e-oxe' ruvinak re Rey Herodes. Y tak reje' xe'bapon riq'uin re Jesús xquibij cha: Rat re yat jun Maestro, yoj can kataman che ja re katzij re natzijoj. Rat can pa rubiyal-va nac'ut re ruch'abal re Dios, y mana-ta re ruk'ij jun vinak re natz'at. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Y vocame nakajo' nakac'axaj andex re xtabij chaka. Roma yoj nakanojij y nakabij: ¿Can ruc'amon como che nakatoj re impuestos re nubij re César che nakatoj o xa man ruc'amon-ta? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero re Jesús can rutaman re andex niquinojij chij. Mare' xubij chique: Yex xa ca'e' ipalaj. ¿Anchique roma nitaj ik'ij chin yinitojtobej? ");
INSERT INTO cakYNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu-pa re mero re nicusas chin nitoj re impuestos, xcha' chique. Y reje' can jare' xquic'ut-apo re mero chach, y re mero re xquic'ut-apo chach jac'a re niquibij denario cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y re Jesús can jare' xuc'utuj chique: ¿Anchok rutzubal c'a la'? ¿Y anchok rube' chuka' la c'o chach la mero? ");
INSERT INTO cakYNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y reje' xquibij cha re Jesús: Chin re César. Y re Jesús xubij chique: Titojo' c'a re impuestos cha re César riq'uin re mero re ruc'amon che niya' cha reja'. Y tiya' cha re Dios, ronojel re ruc'amon che niya' cha re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y re achi'a' re' camas xsatz quic'o'x tak xquic'axaj re xubij re Jesús Y reje' xquiya' can re Jesús y xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ja mismo k'ij re' tak jec'o nic'aj chique re achi'a' saduceos xe'bapon riq'uin re Jesús. Re achi'a' re' man niquinimaj-ta che re anama'i' xque'c'astaj chic-pa. Y xe'bapon riq'uin re Jesús roma c'o niquijo' niquic'utuj cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Reje' xquibij cha: Rat re yat jun Maestro, c'o jun cosa nakajo' nakac'utuj chava. Re Moisés can rutz'iban can chaka che tak c'o jun ache nuya' can re ruxayil roma xcom-a y man jun rajc'ual xuya' can riq'uin re ixok, jun chique re ruch'alal reja' re nic'ule' riq'uin re malca'n-ixok, chin che c'o-ta rajc'ual nic'ue' riq'uin re ixok malca'n. Y vo xa can jec'o rajc'ual ye'c'ue' riq'uin re malca'n-ixok, ja re nabey rajc'ual ala' jare' re ndoc rajc'ual re ache quiminak chic-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y c'are' reje' xquibij: C'o jun bey xe'c'ue' je vuku' achi'a' quich'alal-qui'. Re nabey xc'ule'. Pero re ache re' xcom-a y man jun rajc'ual xuya' can riq'uin re ruxayil. Y re ruxayil re ache re xcom-a xoc ruxayil re ruch'alal. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Re ruca'n ache can quire' chuka' xuc'alvachij-a, reja' xcom-a y man jun rajc'ual xuya' can riq'uin re ruxayil. Re rox ache can ja chuka' quire' xuc'alvachij-a, can ancha'l xquic'alvachij-a re je ca'e' ruch'alal y re ixok c'a xc'ue-na can. Y can quire' xbanataj-a quiq'uin che je vuku' quich'alal-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y tak can je quiminak chic-a re je vuku' achi'a' quich'alal-qui' chach re ixok re', chuka' re ixok xcom-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y c'are' re achi'a' saduceos xquibij cha re Jesús: Rat nabij che xtapon jun k'ij tak re anama'i' xque'c'astaj-pa. Tak xtapon re k'ij re', ¿anchok ruxayil c'a xtoc-va re ixok re'? Roma che je vuku' achi'a' quich'alal-qui' xe'c'ue-a riq'uin, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Y re Jesús xubij chique re achi'a' re': Yex xa yixsatzanak riq'uin re xibij, roma man itaman-ta re andex nubij chupan re ruch'abal re Dios. Y can man k'axnak-ta pan ive' re ru-poder re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roma tak xtapon re k'ij che re anama'i' xque'c'astaj-a, man chic xque'c'ule-ta, y chuka' man chic xque'quiya-ta-a re quimi'al-cajc'ual chin ye'c'ule'. Reje' xa xque'oc ancha'l re ru-ángeles re Dios chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Jac'a che re anama'i' xque'c'astaj, re' can katzij-va. Yex ibanon leer re nubij chupan re ruch'abal re Dios re yi'on can pan ik'a'. Chupan re' re Dios nubij chiva: ");
INSERT INTO cakYNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja yen re ru-Dios re Abraham, re ru-Dios re Isaac y re ru-Dios chuka' re Jacob. Can quire' xubij re Dios ajuer can. Y xe-ta reje' xe'com-ta jumul y man-ta ye'c'astaj chic-pa jun bey, re Dios man-ta qui-Dios reje', roma re Dios can qui-Dios-va re c'o quic'aslen y man quichin-ta re anama'i', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y tak re vinak xquic'axaj re enseñanzas re xuc'ut re Jesús, can anchique-la xquina' roma man jun bey je'quic'axan tzij qui tak re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Y re achi'a' fariseos cha'nin xquimol-qui' chunojexic andex xtiquiban, tak xquic'axaj che re Jesús can xutz'apij xe'cay re achi'a' saduceos riq'uin re xubij chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpa c'a jun chique re achi'a' fariseos, re can rutaman-va re ley kachin yoj re yoj israelitas, xaxe chin che nutojtobej re Jesús, xuc'utuj cha: ");
INSERT INTO cakYNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro tabij c'a chua, ¿anchique c'a chique re mandamientos re xuya' re Dios pa ruk'a' re Moisés re más c'o rajkalen? ");
INSERT INTO cakYNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y re Jesús xubij cha: Re mandamiento re' ja re tajo' re Dios re Avajaf. Tajo' riq'uin ronojel avánma. Tajo' riq'uin ronojel re ac'aslen, y riq'uin ronojel re ana'oj. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jare' re mandamiento re más nem re c'o chupan re ley. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y c'o chic jun mandamiento re camas chuka' rajkalen y xa bama junan riq'uin re jun re c'a nimbij-ka, y nubij quire': Can ancha'l najo-ka-avi' rat, quire' chuka' ca'jo' re nic'aj chic vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Can ronojel c'a re nubij re ley chin re Moisés y ronojel re quibin can re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, can chupan c'a re ca'e' mandamientos re' pitinak-va ruxe'. Ca'e' c'a mandamientos re c'o más quijkalen, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y tak c'a quimalon-qui' re achi'a' fariseos, xpa re Jesús xuban jun pregunta chique: ");
INSERT INTO cakYNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Andex c'a ninojij yex chij re Cristo? ¿Anchok rajc'ual c'a reja'? Y re achi'a' fariseos xquibij: Chin re Rey David. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y re Jesús xubij chique: ¿Pero anchique roma tak re Rey David xubij Vajaf cha re Cristo? Roma ja re Espíritu Santo xbin cha che tubij quire': ");
INSERT INTO cakYNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Re Ajaf Dios xubij cha re Vajaf re Cristo: Catz'uye-pa pa vajquik'a' y xque'nya' pan ak'a' re ye'tzelan avichin. Quire' xubij re Dios cha re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y vo xa re Rey David, Vajaf nicha' cha re Cristo, ¿anchique roma tak nibex che re Cristo xa choj jun rey-rumam can re Rey David? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun xbin-ta-apo jun tzij cha re Jesús, chin che nubij-ta-apo re xuc'utuj re Jesús chij re Cristo. Can jac'a k'ij re' tak xtiquir-a che man jun chic xbano covil chin che c'o-ta jun cosa nuc'utuj cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y c'are' re Jesús xch'o chiquivach re vinak y chuka' chaka yoj re yoj ru-discípulos. Reja' xubij: ");
INSERT INTO cakYNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Pa ru-lugar c'a re Moisés, je'tz'uyul-va re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas y re achi'a' fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mare' yex tinimaj quitzij. Can ronojel c'a re niquibij chiva, tibana' y tichajij. Pero man c'a tiban ancha'l re niquiban reje'. Roma reje' xa man ye'tiquir-ta niquiban re niquibij che tiban. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Reje' namalaj tak ejka'n niquiya' chiquij re vinak, ejka'n re camas c'ayef quic'uaxic. Re ejka'n re' xaxe c'a chiquij re vinak niquiya-va y reje' ni siquiera jun ch'et rue-quik'a' niquisiloj chin niquiban y niquic'uaj-ta re ejka'n re niquibij che can ruc'amon che niquic'uaj re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Y reje' niquibanala' re otz, pero man chin-ta che otz niquiban chach re Dios. Reje' xaxe chin che que'tz'et y que'nimax coma re vinak che reje' camas je utzulaj tak vinak. Y chuka' can ye'quiyala' re chavon tak c'ojlebal chij re quik'a' y re nic'aj tak quivach. C'ojlebal re anche' niquiyac-va nic'aj versículos cha re ruch'abal re Dios. Y chuka' camas chavon rakan niquibanala' cha re rutz'abal ruchi' re quitziak. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Y can ja chuka' re lugar más otz ye'quicha' re anche' niban-va va'in y can ja chuka' quire' ye'quibanala' re pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Xaxe che tibex chique che reje' camas quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Camas nika chiquivach che niyalox can ruxnokil-quivach pa tak q'uiybal re anche' niquimol-va-qui' re vinak. Y chuka' camas nika chiquivach che nibex can chique coma re vinak: Maestro, maestro, ye'cha' c'a chique roma c'o quik'ij ye'quitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Jac'a yex man tijo' che nibex maestro chiva, roma xaxe Jun re ruc'amon che nibij Maestro cha, y re' ja re Cristo. Jac'a yex can ivch'alal-ivi' chiyixnojel. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chuka' man tibij irta' cha jun vinak xaxe roma c'o ruk'ij. Roma re Irta' yex xaxe Jun y ja reja' re c'o pa kave' konojel, y re' ja re Tata'aj re c'o chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Can man c'a tijo' che re vinak niquibij maestro chiva. Roma xaxe jun Maestro c'o y re' ja re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Roma re más c'o ruk'ij chiva yex, can nic'atzin che nuna-ka-ri' che xa manak ruk'ij y can tusuju-ri' chin nuban xabanchique samaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Roma re nuban che c'o ruk'ij, xa xtikasas ruk'ij. Y jac'a re nuban che manak ruk'ij, can xtic'ue' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Can tivok'ex ivach yex re yix-atamayon re ley kachin yoj re yoj israelitas y yex fariseos re xa ca'e' ipalaj! roma can ik'aton quibey re vinak chin che man ye'oc-ta pa ruk'a' re Dios. Can man otz-ta re ibanon, roma ni xe-ta yex yixoc-apo y chuka' can man niya-ta k'ij chique re vinak chin che ye'oc-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Tivok'ex ivach yex re yix-atamayon re ley y yex fariseos re xa ca'e' ipalaj! roma yex xa itz'amon rulesasic ronojel qui-cosas re malcani' tak ixoki'. Y xaxe chin che tinimax che camas otz re ic'aslen, camas yixyaloj tak niban oración cha re Dios. Y roma re' tak yex c'o más castigo xtika pan ive', roma chach re Dios camas q'uiy imac. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Tivok'ex ivach yex re yix-atamayon re ley y yex fariseos re xa ca'e' ipalaj! roma yex can nik'asala' mar y yixak'ax nic'aj chic naciones chucanoxic che c'o-ta jun re nitzekelben ivichin y nunimaj-ta re ninimaj yex. Y jac'a tak ivilon chic jun re nitzekelben ivichin, yex xa camas c'ayef niban cha, roma riq'uin re nic'ut chach, niban cha che c'ac'anaj nicanaj-va can chach re Dios. Y chuka' yex xa can c'ac'anaj c'a yixc'o-va chach re Dios, pero re nitzekelben ivichin ca'e' c'a bey más naj nicanaj-va can, y mare' tak can ruc'amon che niba pan infierno chuka' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Y can tivok'ex chuka' ivach yex re yixbin che yix ec'uay-bey y xa yix moyi'! Yex re yixbin che vo xa c'o jun re nibano jurar pa rube' re rachoch re Dios chin che nuban jun cosa, y astapa' can man nuban-ta re rubin, man jun nuban. Jac'a re nibano jurar pa rube' re k'anapuak re c'o pa rachoch re Dios, chin nuban jun cosa, re' sí tiene que nuban, roma pa rube' re k'anapuak rubanon-va jurar. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Yex can nic'ut che can yix nacanak y chuka' can yix moyi', roma ja re rachoch re Dios re c'o más ruk'ij y mana-ta re k'anapuak, roma ja re rachoch re Dios re nibano lok'olaj cha re k'anapuak. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yex chuka' nibij che re nibano jurar pa rube' re altar chin che nuban jun cosa, astapa' can man nuban-ta re rubin, can man jun nuban. Jac'a re nibano jurar pa rube' re ofrenda re nic'ue' pa rue' re altar chin nuban jun cosa, re' sí tiene que nuban roma pa rube' re ofrenda rubanon-va jurar. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Can yix nacanak y yex can yix moyi-va, ¿roma anchique re c'o más ruk'ij? ¿La ja como re ofrenda re nisuj pa rue' re altar cha re Dios o ja re altar? Ja re altar re c'o más ruk'ij, roma jare' re nibano lok'olaj cha re ofrenda. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Re nibano jurar pa rube' re altar chin nuban jun cosa, can nuban-va abarcar ronojel. Nuban abarcar re altar y nuban abarcar chuka' re ofrenda re nisuj pa rue' re altar. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Re nibano jurar pa rube' re rachoch re Dios chin che nuban jun cosa, man xe-ta c'a nuban abarcar re rachoch re Dios, xa can nuban abarcar chuka' re Dios mismo. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y re nibano jurar pa rube' re rocaj chin che nuban jun cosa, can nuban abarcar re anche' tz'uyul-va re Dios y can nuban chuka' abarcar re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Can tivok'ex ivach yex re yix-atamayon re ley kachin yoj re yoj israelitas y yex fariseos re xa ca'e' ipalaj! Yex camas yix cumplido riq'uin re i-diezmo, mare' hasta re jubulaj tak k'ayis, re nibex menta cha, re anís y re comino ye'nojij che ye'ilesala' can tak ba' cha chin che can chibil chuka' re' ndoc i-diezmo chin niya' cha re Dios. Y xa ja re más nic'atzin re nubij chupan re ley re man niban-ta, y re nubij re ley che yex niban ja che yex choj tibana' quiq'uin re vinak, can quixjoyovan y can-ta katzij che ibanon confiar-ivi' riq'uin re Dios. Ja-ta re' re ruc'amon che niban nabey, y c'aja-ta re' niban re can yixtajin-va chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yex re yixbin che yix ec'uay-bey, man quire-ta roma xa yix moyi', yen nimbij chiva che yex xaxe-oc re mandamientos re más je cocoj re yixtajin chubanic y re mandamientos más je nima'k xa man ye'ban-ta, xa can iyi'on k'ij cha che xe tal choj quire' ye'k'ax. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Can tivok'ex ivach yex re yix-atamayon re ley y yex fariseos re xa ca'e' ipalaj! roma xa yix ancha'l lak re jabal ch'ajch'oj rij y re rupan can xak che tz'il. Yex can nic'ut chiquivach re vinak che camas otz re ibanabal, pero re pa tak ivánma man quire-ta, roma xa nojnak riq'uin elak', y nojnak riq'uin itzel tak rayibal, roma yex camas nirayij che ronojel re c'o quiq'uin re vinak iviq'uin-ta yex c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Yex fariseos xa yix moyi'. Can tibana' cha re ic'aslen ancha'l niban riq'uin re lak, nich'aj rupan y re rij. Yex nabey tich'ojersaj re ivánma, chin quire' can nik'alajin chiquivach re vinak che can ch'ajch'oj chuka' re ic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Tivok'ex ivach yex re yix-atamayon re ley y yex fariseos re xa ca'e' ipalaj! roma xa yix junan riq'uin jun panteón re anche' ye'ya-va re anama'i', re rij jabal sak y ch'ajch'oj, pero re chupan man quire-ta. Roma xa rion man otz-ta c'o y rion rubakil ánma c'o chupan. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Y can jac'a quire' yex. Roma chiquivach re vinak can yixk'alajin che choj re ic'aslen, jac'a re pa tak ivánma man quire-ta. Re ivánma xa nojnak riq'uin etzelal. Y chuka' xa can ca'e' ipalaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Tivok'ex ivach yex re yix-atamayon re ley y yex fariseos re xa ca'e' ipalaj! roma jabal ye'banala' quibanic re qui-panteón re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Yex can jabal-va chuka' ye'vak re qui-panteón re utzulaj tak vinak re choj quic'aslen chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y yex nibij: Xe-ta yoj xojc'ue' pa qui-tiempo re kavinak xe'c'ue' ajuer can, yoj man-ta xojoc quichibil reje' tak xe'quiquimisaj re rusamajela' re Dios re xbex profetas chique, yixcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero xa can ja yex mismo yixbin-ka chivij che can yix quiy-quimam can re xe'quimisan quichin re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Y yex can tiq'uisa' c'a chuka' pa rue' re c'a anche' xapon-va re quibanabal re ivinak xe'c'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Yex, xa can yix ancha'l itzel tak cumatz. Mare' c'a pan infierno xquixbo-va chin ne'ic'ulu' rajal re ibanabal. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Y chin che yex nic'ut re etzelal re c'o iviq'uin, yen can xque'ntak-a achi'a' chi'icojol re ye'tzijon re nubij re Dios chique, achi'a' re camas quina'oj y achi'a' re nibex maestros chique. Pero jec'o chique re nusamajela' re xe tal choj quire' ye'iquimisaj, y jec'o re xque'ibajij cho cruz chin ye'com. Jec'o re xque'ich'ayala' pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, y xabanchique tenemit xque'bo-va reje', yex chuka' can xquixapon chire' roma c'o etzelal nijo' niban chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y ronojel re' can xtuban chiva che ja yex re xquixkalen re quicamic conojel re utzulaj tak vinak re je'quimisan-a. Nitiquir-pa riq'uin re rucamic re jun utzulaj ache xubini'aj Abel c'a riq'uin re rucamic re ache xubini'aj Zacarías, re ruc'ajol re ache xubini'aj Berequías. Y nimbij chiva, che re Zacarías can ja chuka' yex re xixquimisan richin, chire' chunakaj re altar re c'o chach re rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Re ximbij-ka chiva, can katzij-va che quire' xtibanataj. Can ronojel c'a re mac re' xtika pa quive' re vinak re jec'o chupan re tiempo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","C'are' re Jesús xch'o chiquij re vinak re jec'o pa tenemit Jerusalén. Reja' quire' xubij: Yex re yix aj-Jerusalén, yex re yix aj-Jerusalén, ¿anchique roma tak ye'quimisaj re rusamajela' re Dios re nibex profetas chique? ¿Anchique roma chuka' tak ye'quimisaj cha aboj re ye'rutak-pa re Dios chi'icojol? Y yen camas q'uiy bey xinjo' che xixinmol-ta viq'uin, ancha'l nuban re quite-ec' chique re ch'utak ral, ye'rumol chuxe' re ruxic'. Y yex man jun bey xijo' che quire-ta ximban iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vocame re ivachoch yex xtic'ue' can ancha'l jun lugar re anche' manak vinak re nibex desierto cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y quire' nimbij chiva roma jac'a ruq'uisibal bey re' re xquinitz'at-a. Y xquinitz'at chic jun bey c'aja chupan re k'ij tak xtibij chua: ¡Matiox che pitinak re Jun re'! ¡Reja' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! C'a chupan re k'ij re' tak xquinitz'at chic jun bey, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y tak re Jesús xel-pa chire' pa rachoch re Dios chin che niba, yoj re yoj ru-discípulos xojelon-apo riq'uin y xkabij cha, che re rachoch re Dios camas jabal rubanic y chuka' can xkac'utula' chach riq'uin re rue' tak kak'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Y reja' xubij chaka: Yex can ye'tz'at che re jay re' camas otz quibanic. Pero yen can katzij nimbij chiva, che xtapon jun k'ij che ronojel re ye'tz'at vova' can xque'vulax y can man jun re xtipa'e-ta can. Ronojel re aboj re je'cusan chin che je'banon-va re jay re', xa can xque'vulax. Can man jun aboj re xtic'ue-ta can ancha'l la rubanon vocame, xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y tak re Jesús tz'uyul chic pa rue' re loma rubini'an Olivos, jare' tak yoj re yoj ru-discípulos xojelon-apo riq'uin y xkac'utuj cha: Tabij c'a chaka, ¿c'a jampa' c'a xque'banataj re xabij-yan-ka chij re rachoch re Dios? ¿Andex che señal tak xcapa chic jun bey? ¿Y andex chuka' che señal chin quire' ninabex che napon-yan re ruq'uisibal k'ij chin re ruch'ulef? ");
INSERT INTO cakYNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y re Jesús xubij chaka: Can jabal tichajij-ivi' chin man quixk'olotaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Roma je q'uiy xque'pa y xtiquibij: Ja yen re Cristo, xque'cha'. Y camas je q'uiy re xque'k'olotaj pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y xtic'axala' che jec'o naciones re ye'tajin che guerra y chuka' xtic'axala' che c'o cha guerra xque'pa. Pero man tisatz ic'o'x, roma ronojel re' tiene que ye'banataj-na. Pero mana-ta re' re ruq'uisibal tak k'ij chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun tenemit xtiyacataj chin no'rbana' guerra riq'uin jun chic tenemit. Jec'o chuka' re nima'k tak naciones re xque'yacataj chin che ne'quibana' guerra quiq'uin nic'aj chic nima'k tak naciones. Xque'pa yabilal, viyjal y chuka' sananel xabanchique lugar chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y jare' re nabey tak k'axomal, y c'are' xque'pa chic c'a nic'aj quivach tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Y yex, can xquixya' pa tak tijoj-pokonal, y jec'o chiva yex re can xque'quimisas. Y can xquixtzelas-va coma conojel quivach vinak re jec'o chach re ruch'ulef, roma yex can ibanon confiar-ivi' viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Y chupan re tiempo re' je q'uiy re can xque'tzak, jec'o re can xque'quisujula' re mismo quichibil-qui' y jec'o xtiquitzelaj-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y chuka' camas je q'uiy re xque'bec'ulum-pa re xque'bin che reje' can niquibij re nubij re Dios chique, y roma quire' niquibij, can je q'uiy-va c'a vinak re xque'k'olotaj pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chuka' chupan re tiempo re' roma camas chic etzelal re ye'banataj, mare' je q'uiy re man chic xtiquijo-ta-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero re man xtutzolij-ta-ri' chij y xtucoch' xtuk'asaj ronojel re' c'a pa ruq'uisibal, can xticolotaj-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero re utzulaj ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios xtitzijos chach ronojel re ruch'ulef, chin quire' can xtitamax. Y c'ajare' tak xtapon re ruq'uisibal k'ij chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y chuka' can xtapon-va re k'ij tak xque'banataj re xajan tak banabal chupan re lugar santo. Y riq'uin re' xtivulataj c'a can re lugar re'. Jare' re tz'iban can roma re Daniel, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re nitz'eto re tz'iban can, tak'ax c'a pa rue' re nutz'at. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Chin quire' tak xtitz'at che can ja chic re' re ye'banataj, re vinak re jec'o pa Judea xa can que'numaj-a y te'quivovaj-qui' pa tak c'achelaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Re nixulan pa rue' re rachoch tak xtapon re k'ij chin nibanataj ronojel re', choj quire' tinumaj-a. Y man chic toc-apo pa rachoch chin che c'o jun cosa no'rc'ama-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Re nisamaj pak'os, man chic tiba charachoch chuc'amic ruk'u'. Xaxe tal choj chuka' quire' tinumaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Jac'a re ixoki' re c'o chic yabil chiquij, y re ixoki' re xa c'a niquiya' quitz'um ch'utak cal, tivok'ex c'a quivach tak xtapon re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mare' tic'utuj cha re Dios che re tijoj-pokonal re' man-ta nibanataj chupan re tiempo chin tef, y chuka' tic'utuj che man-ta pa jun k'ij chin uxlanen tak xtibanataj ronojel re', chin che man c'ayef-ta nuban chiva che yixnumaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Y jare' tak can xtak'ax rue' re tijoj-pokonal re xtipa. Jun tijoj-pokonal re man jun bey banatajnak-ta chach re ruch'ulef desde que jampa' banon can roma re Dios. Y chuka' re tijoj-pokonal re' man jun bey chic xtibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y xe-ta man-ta niban cortar re tiempo chin re tijoj-pokonal re', conojel-ta vinak ye'com. Pero re Dios xa quitzij re je'rucha'on chic, tak xtuban cortar re tiempo chin re tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan re k'ij re', vo xa jec'o ye'bin chiva: Titzu', jac'a Cristo re'. O vo xa niquibij chiva: Titzu', jac'a Cristo la c'o la'. Pero yex man quixk'olotaj pa quik'a', man tinimaj re niquibij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Roma jec'o re xque'bec'ulum-pa y xtiquibila': Ja yen re Cristo. Pero yex man que'inimaj, roma xa quion je tz'ucuy tak tzij. Y ja chuka' k'ij re' tak xque'bec'ulum-pa re xque'bin: Yen nintzijoj re nubij re Dios chua, xque'cha'. Pero yex man c'a que'inimaj, roma xa je tz'ucuy tak tzij chuka'. Y xque'quibanala' nima'k tak milagros, re man jun bey je'tz'eton-ta, xaxe chin che que'nimax, y can jec'o-va re xque'quik'ol. Y xe-ta reje' can ye'tiquir ye'quik'ol re je'cha'on chic roma re Dios, can ye'quik'ol-ta. Pero man ye'tiquir-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Y ja re ximbij-yan chiva, jare' re xque'banataj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mare' vo xa nibex chiva, re Cristo xpa-yan y vocame c'o chupan re lugar anche' manak vinak re nibex desierto cha, yex man c'a quixba chutz'etic. Y vo xa nibex chiva che re Cristo c'o chic y vocame chupan re jun jay re' c'o-va, man que'inimaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Roma tak yen re xinalax chi'icojol xquimpa chic jun bey, can jabal-va xquink'alajin. Xa can xtibanataj ancha'l nibanataj riq'uin re relámpago tak ne'yiq'uie-pa pan oriente y can jabal nik'alajin c'a quila pan occidente, y can conojel ye'tz'eto richin. Y can quire' chuka' xtimban yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Roma re castigo re xtuya' re Dios xte'ka anche' c'o-va re mac. Can xtibanataj ancha'l nibanataj quiq'uin re c'uch. Roma re chicop re' xaxe anche' c'o-va jun cuerpo quiminak, chire' ye'ka-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y tak xtak'ax re tijoj-pokonal chin re tiempo re', jare' tak re k'ij y re ic' can xtik'ukumutaj quivach. Re ch'umil xque'betzakalam-pa re anche' jec'o-va. Can ronojel-va re namalaj tak poderes re jec'o chicaj xque'silon roma re ru-poder re Dios. Can che jun re rocaj xtisilon. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Jare' tak xtitz'etetaj chicaj re nu-señal yen re xinalax chi'icojol. Y ronojel quivach vinak re jec'o chach re ruch'ulef, c'ajare' tak xque'ok' y xte'ka chiquic'o'x re je anchique reje', tak xquinquitz'at che ja yen re yinka-pa pa nube chila' chicaj, riq'uin chic namalaj poder y riq'uin chuka' namalaj nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y jare' chuka' tak re trompeta can cof xtik'ajan, y yen xque'ntak re nu-ángeles chiquimolic re je'ncha'on chic. Can xque'quimol-pa re jec'o pan oriente y re jec'o pan occidente, re jec'o pa norte y re jec'o pa sur. Can xque'quimol c'a-pa conojel re anche' nitiquir-pa re jun rutza'n re rocaj, c'a la jun chic rutza'n. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Can titamaj re ejemplo chij re jun che' rubini'an higuera. Tak re ruk'a' jabal rax ye'quibam-pa y ye'el-pa ruxak c'ac'a, can itaman che re tiempo chin job ne'ka-yan. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y ja quire' chuka' tak xtitz'at che can jec'o chic cosas re ye'banataj riq'uin re k'ij, re ic', re ch'umil y ronojel re ximbij-yan-ka ntajin chic rubanic, titamaj c'a che ne'ka-yan re k'ij. Xa can nakaj chic c'a c'o-va-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Y tic'axaj jabal re xtimbij chiva vocame: Ronojel re' xque'banataj tak re vinak chin re tiempo re' c'amaje-na que'q'uis-a chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Y re ruch'ulef y re rocaj can chin-va che ye'q'uis. Jac'a re nuch'abal man xtiq'uis-ta, xa can xtibanataj-va ronojel re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jac'a re k'ij y re hora tak yen xquimpa, man k'alaj-ta. Re ángeles re jec'o chila' chicaj man quitaman-ta jampa' re'. Xa can xe re Nata' Dios re atamayon re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xa can ancha'l xbanataj pa ru-tiempo re Noé, can quire' chuka' xtibanataj tak xquimpa chic yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roma pa ru-tiempo re Noé, tak c'amaje-na tibanataj re job re can man jun bey tz'eton-ta re nibex diluvio cha, re vinak binak cánma riq'uin re andex ye'quitaj y riq'uin re andex ye'quikumula'. Xa can binak cánma riq'uin re c'ulubic y chuka' can binak cánma chin che ye'quiya-a re quimi'al-cajc'ual chin che ye'c'ule'. Y can c'a quire' quitz'amon rubanic tak re Noé y re ru-familia xe'oc chupan re barco. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y re xtzijos chiquivach cama-va xk'ax-ta pa quive', xa c'aja tak xapon re k'ij chin re diluvio, roma jare' re xc'uan-a quichin conojel. Y can quire' chuka' xtibanataj tak xtapon re k'ij tak yen re xinalax chi'icojol xquimpa chic jun bey. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Jare' tak xtibanataj che je ca'e' achi'a' re junan ye'samaj pak'os, xaxe c'a jun re xtic'uax-a y re jun chic xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y vo xa jec'o je ca'e' ixoki' re junan ye'qui'en, xaxe c'a jun re xtic'uax-a y re jun chic xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Mare' can nojel tiempo quixc'ase' chin quiniyabej-apo, roma man itaman-ta jampa' tak xquineka yen re Ivajaf. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Roma yex jabal itaman, che xe-ta re rajaf jun jay can rutaman jampa' napon re elek'om pa rachoch, re rajaf re jay re' can-ta nic'ase' chin nuchajij re rachoch, y man nuya-ta k'ij che re elek'om nuvop re rachoch chin ndoc chupan y nelak'-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xa mare' tak yex can ruc'amon che can nojel tiempo quiniyabej-apo, roma ja tak can man jun inaben chire', jare' tak xquineka yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Roma chupan re k'ij re' can xtibanataj ancha'l re nibanataj riq'uin jun patrón re nucha' can jun ru-mozo chin nipa'e' can pa quive' re ye'c'ue' can pa jay. Y nubij can cha che tuya' quivay tak napon re hora. Y vo xa reja' c'o runa'oj y can nuban ronojel re bin can cha che nuban, ");
INSERT INTO cakYNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","reja' can niqui'cot roma ntajin chubanic re samaj ne'litaj-ka roma re ru-patrón. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Y can katzij nimbij chiva che re patrón re' xtuban cha re ru-mozo che xtuya' pa rue' ronojel re c'o riq'uin, chin che nuchajij. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero vo xa re mozo re' xa ja-ta re itzel tak nojebal ye'pa pa ránma y nubij-ta-ka: Re nu-patrón re' xa c'amaje-na ne'ka, ");
INSERT INTO cakYNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y nutz'am-ta quich'ayic re nic'aj chic mozos y chuka' can xe-ta va'in y tijoj-ya' nuban quiq'uin nic'aj chic k'abarla', ");
INSERT INTO cakYNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","jac'a re k'ij y re hora tak man jun runaben che ne'ka re ru-patrón jare' tak ne'ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Re patrón can xtuya' jun namalaj castigo pa rue' re mozo re' y xtuya' quiq'uin re nic'aj chic vinak re xa ca'e' quipalaj. Y c'aja chire' c'a xtipo-va re ok'ej chach y can xtukach'ach'ej roray. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chupan re k'ij tak xquimpa chic jun bey, jec'o re can xque'oc pa ruk'a' re Dios, y jec'o re man xque'oc-ta. Xa can xtibanataj ancha'l re xbanataj quiq'uin je lajuj k'apoji' re quic'uan-a qui-lámparas chin xe'ba chuyabexic re ala' xtic'ule' chupan re ak'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Je vo'o' c'a chique re k'apoji' re' re c'o quina'oj y re je vo'o' chic xa je nacanak. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Re je vo'o' k'apoji' re xa je nacanak, man xquic'uaj-ta-a nic'aj chic aceite chin re qui-lámparas, xa can xe-oc re c'o-a chupan. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Jac'a re je vo'o' chic k'apoji' re c'o quina'oj, xquic'uaj-a re qui-lámparas y je'quic'ualon chic-a nic'aj chic botellas re anche' quic'uan-va-a re nic'aj chic aceite. Y reje' xe'ba c'a chuyabexic re ala' xtic'ule'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y roma re ala' re nic'ule' camas xyaloj y can man xe-ta ne'ka, re je lajuj k'apoji' re je'yabeyon richin, can xuya' ruchuk'a' re quivaran. Nabey xe'xcurin-ka y c'are' c'a can xe'var-ka jumul. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pero pa nic'aj-ak'a' xc'axataj ruch'abal jun re camas cof nich'o y nubij: Ja pitinak re ala' re xtic'ule'. Quixel-pa chin ne'ic'ulu'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y jare' tak re je lajuj k'apoji' re', re je'yabeyon richin re ala' re xtic'ule', cha'nin c'a xe'yacataj y xquibanala' rubanic re qui-lámparas. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Y re je vo'o' k'apoji' re je nacanak xquibij chique re je vo'o' chic k'apoji' re c'o quina'oj: Re ka-lámparas xa can xque'bechup roma xa can man q'uiy-ta chic aceite c'o chiquipan. Tiya' c'a ba' ka-aceite yex, xe'cha' re k'apoji' re je nacanak. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero re je vo'o' chic k'apoji' re c'o quina'oj, xquibij: Re otz che niban yex vocame ja che quixbiyin chulok'ic quiq'uin re ye'c'ayin aceite, roma vo xa xtakaya' aceite chiva, riq'uin ba' c'a c'o xto'rbana' falta chaka yoj, y quire' chuka' yex. Mare' re más otz che niban yex ja che quixbiyin chulok'ic aceite. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y tak re je vo'o' k'apoji' re' je'binak chulok'ic aceite, jare' tak xbec'ulun re ala' re xtic'ule'. Re je vo'o' k'apoji' re can jec'o-apo chin quiyaben re ala' re', can xe'oc pa jay anche' niban-va re c'ulubic. Y can xe xe'oc xtz'apes-pa re ruchi-jay. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y c'a después xe'bapon re je vo'o' chic k'apoji' re je'binak chulok'ic aceite chin re qui-lámparas, y reje' can xe'ch'o-apo cha re rajaf re c'ulubic re' y xquibij: Tajaka' re ruchi-jay chakavach chin che yojoc-apo chuka' yoj. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y reja' xubij-pa chique re k'apoji' re': ¿Yix anchique c'a yex? Yen can katzij nimbij chiva che man jun bey xintamaj-ta ivach, xe'cho'x-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Mare' yex can nojel tiempo quixc'ase' chin quiniyabej-apo, roma xa man itaman-ta anchique k'ij y anchique hora tak yen re xinalax chi'icojol xquimpa chic jun bey. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Roma re ru-gobierno re Dios junan riq'uin re xuban jun ache tak xba naj. Reja' xe'rayoj re ru-mozos y xujach can re rubiyomal pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Cha re jun ru-mozo xuya' can vo'o' mil quetzales, cha re jun chic xuya' can ca'e' mil y cha re jun chic xuya' can jun mil. Cha re nabey q'uiy más xuya' can roma xutz'at che can nitiquir nusamajij. Re ruca'n xaxe ca'e' mil xuya' can cha roma xaxe re' re nitiquir nusamajij. Y re rox xe jun mil xuya' can cha chin tusamajij. Y re ache can xe xuban can quire', xba. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y re mozo re yi'on can vo'o' mil quetzales cha chin tusamajij y chin che nuch'ac más mero, can xuban-va re bin can cha. Reja' can xusamajij-va re vo'o' mil y can xuch'ac chic vo'o' mil más. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y quire' chuka' xuban re ruca'n mozo re yi'on can ca'e' mil cha, reja' can xuch'ac ca'e' chic mil más. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jac'a re rox mozo re xe-oc jun mil yi'on can cha, xa xbo'rc'oto' jun jul pan ulef y chire' xumuk-va can re mero re yi'on can pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Y tak xk'ax-yan q'uiy tiempo, c'ajare' xtzolaj-pa re qui-patrón re mozos re'. Y reja' xuc'utuj chique andex xquiban riq'uin re mero re xuya' can chique tak xba. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tak xapon re mozo re yi'on can vo'o' mil quetzales cha, can man xe-ta re' re ruc'uan-apo, xa can ruc'uan chic-apo vo'o' mil más y xubij cha re ru-patrón: Rat vo'o' mil re xaya' can chua, jac'a re c'o re', y ja chic vo'o' mil más re c'o re', jare' re xinch'ac chij, xcha' re mozo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y re ru-patrón re mozo re' xubij cha: Camas otz re xaban. Rat, can yat jun utzulaj nu-mozo roma can naban re nibex chava. Y roma can xaban re ruc'amon riq'uin re ba' mero re xinya' can chava tak ximba, vocame can yatinya' pa rue' jun samaj más nem. Catampa y catoc, can caqui'cot riq'uin re a-patrón, xcho'x re mozo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Y tak xapon chuka' re mozo re yi'on can ca'e' mil quetzales cha, reja' xubij cha re ru-patrón: Rat ca'e' mil re xaya' can chua, jac'a re c'o re', y ja chic ca'e' mil más re c'o re', jare' re xinch'ac chij, xcha' re mozo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Re ru-patrón re mozo re' xubij cha: Camas otz re xaban. Rat, can yat jun utzulaj nu-mozo roma can naban re nibex chava. Y roma can xaban re ruc'amon riq'uin re ba' mero re xinya' can chava tak ximba, vocame can yatinya' pa rue' jun samaj más nem. Catampa y catoc, can caqui'cot riq'uin re a-patrón, xcho'x re mozo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Jac'a tak xapon re mozo re yi'on can jun mil quetzales cha, reja' xubij cha re ru-patrón: Yen can ntaman-va avach, y mare' ntaman che camas yat c'a'l. Xa can najo' c'a yach'acon. Rat najo' nac'ul re ndel-pa chach re tico'n re xa mana-ta rat yatiquiyon-ka. Najo' nayac re trigo re xa mana-ta rat xach'ayo rue'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y mare' yen camas ximpokonaj xinsamajij re jun mil quetzales re xaya' can chua. Yen tak xinc'ul-a re mero, xinc'ot jun jul pan ulef y chire' ximuk-va can. Y jac'a a-mero re' re ne'njacha' can chava, xcha' re mozo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y re ru-patrón re mozo re' xubij: Can man otz-ta re xaban. Roma rat yat jun itzel mozo y man naban-ta re nibex chava. Roma vo xa ataman che yen can yin c'a'l-va, che yen ninjo' ninc'ul re ndel-pa chach re tico'n re xa mana-ta yen yintiquiyon-ka y ninjo' ninyac re trigo re xa mana-ta yen xinch'ayo rue', ");
INSERT INTO cakYNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xa mare' xaya-ta re nu-mero pa quik'a' re achi'a' re nibex banqueros chique, y vocame xineka, xinc'ul-ta re mero can vichin yen y xinc'ul-ta chuka' re ral re mero re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Vocame tic'ama' c'a can la mero chuk'a' y tiya' cha re mozo re anchok riq'uin c'o-va re lajuj mil quetzales. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Roma re c'o, c'o riq'uin, can xtuc'ul más y can xtuban sobra riq'uin. Jac'a re manak can-ta riq'uin, hasta re jenipa-oc ba' c'o riq'uin can xtilisas chach. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y re mozo re man jun nic'atzin-va tilisas-a y te'ich'akij chupan re lugar camas k'oko'm, y c'aja chire' c'a xtipo-va re ok'ej chach y can xtukach'ach'ej roray. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y tak yen re xinalax chi'icojol xquimpa chic jun bey, can c'o chic nuk'ij, y chuka' can conojel re nu-ángeles xque'pa viq'uin. Y jare' tak yen xquintz'uye' chach re nuch'acat re camas chuka' ruk'ij, y xtimban juzgar. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Can xque'mol-va-apo conojel vinak re jec'o pa tak ronojel naciones chinoch. Y xquimpa yen can xque'mban apartar, ancha'l nuban jun ache quiq'uin ch'utak ruchicop. Reja' jun-va ye'ruya-va re ch'utak ovejas y jun-va ye'ruya-va re ch'utak cabras. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Re vinak re ancha'l ch'utak ovejas, roma ch'ajch'oj chic re quic'aslen, xque'nya' pa vajquik'a'. Jac'a re vinak ancha'l ch'utak cabras, roma man otz-ta re quic'aslen, xque'nya' pa nuxocon. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y jare' tak yen re Rey xtimbij chique re jec'o pa vajquik'a': Quixampa yex, re can yix bendecidos chic roma re Nata' Dios. Quixc'ue' c'a anche' re can ja re Dios re nibano gobernar, re can ivichin-va yex tak rubanon, y tak reja' xunojij che nuban quire' c'amaje-na tic'ue' re ruch'ulef che'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Roma tak yen xch'umun nupan, yex can xiya' nuay. Tak yen xchake'j nuchi', yex can xiya' nuya' chin xinkum. Tak yen xinjo' nu-posada, yex can xiya' chua. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tak yen manak nutziak, yex xiya' nutziak. Tak yen xinyavaj, yex xixapon chinutz'etic. Tak yen xintz'ape' pa cárcel, yex xixapon chinuchi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Jac'a re vinak re choj quic'aslen xtiquibij: Ajaf, ¿jampa' c'a re' tak yoj xkaya' avay chin xava' roma nich'umun apan? ¿Jampa' c'a re' tak yoj xkaya' aya' chin xatuq'uia' roma nichake'j achi'? ");
INSERT INTO cakYNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y jampa' c'a re' tak xkaya' a-posada roma xc'atzin chava? ¿Jampa' c'a re' tak yoj xkaya' atziak roma can xoc chava? ");
INSERT INTO cakYNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampa' c'a re' tak yoj xojapon cha'tz'etic roma xayavaj? ¿Y jampa' c'a chuka' re' tak yoj xojapon cha'tz'etic tak yatc'o pa cárcel? ");
INSERT INTO cakYNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y yen re Rey xtimbij: Can katzij nimbij chiva che roma quire' xiban riq'uin re jun re camanak ruk'ij, re can yinruniman chic, xa can chua c'a chuka' yen xiban-va re utzil re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y can jac'a chuka' re' tak xtimbij chique re jec'o pa nuxocon: Yex xa can ja chic c'a re castigo iyaben che nika pan ive'. Quixel-a chinoch vova' y quixbiyin pa k'ak' re man jun bey xtichup, y re' xa richin re itzel y re ru-ángeles tak banon. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Roma yen can xch'umun nupan y yex man xiya-ta nuay. Camas xchake'j nuchi' y yex man xiya-ta nuya' chin xinuq'uia-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Y tak yen xinjo' nu-posada, yex man xiya-ta chua. Tak yen manak nutziak, yex man xiya-ta nutziak. Tak yen xinyavaj, yex man xinitz'eta-ta. Tak xinc'ue' pa cárcel, man xixapon-ta chinuchi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y jare' chuka' tak reje' xtiquibij: Ajaf, yoj man jun bey xatkatz'at-ta che nich'umun-ta apan o nichake'j-ta achi', chuka' man jun bey xatkatz'at-ta che nic'atzin-ta a-posada, o manak-ta atziak, o yayavaj-ta, o yatc'o-ta pa cárcel. Yoj man jun bey xatkatz'at-ta che quire-ta ac'alvachin, mare' can man jun utzil xkaban chava, xque'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y jare' tak yen re Rey xtimbij chique: Can katzij nimbij chiva, roma man jun utzil xiban chique re hermanos re manak quik'ij, can man jun chuka' utzil xiban chua yen. ");
INSERT INTO cakYNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y re vinak re' can xque'bo-va chupan re tijoj-pokonal chin nojel tiempo. Y re vinak re choj quic'aslen xtiquivel c'a jun c'aslen re man niq'uis-ta. Ja quire' re tzij re xe'rubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tak re Jesús xuq'uis rubixic ronojel re tzij re', xubij chaka yoj re yoj ru-discípulos: ");
INSERT INTO cakYNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Yex itaman che xaxe chic ca'e' k'ij nrajo' che nitz'amataj-a re kanamak'ij rubini'an pascua. Chupan re namak'ij re' tak xquinjach yen re xinalax chi'icojol chin yimbajex cho cruz chin xquincom, xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y can jare' tak re principal tak sacerdotes, re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas y chuka' re rejeta'k tak achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, can quimalon-va-qui' chach rachoch re namalaj sacerdote rubini'an Caifás. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Reje' xquiya' chiquivach andex niquiban chin che nika re Jesús pa quik'a', y c'are' niquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Y can xquiya' chiquivach, che man niquitz'am-ta chupan re namak'ij, chin che man que'yacataj-pa re vinak chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y re Jesús c'o pa tenemit rubini'an Betania, chire' pa rachoch re jun ache rubini'an Simón re xc'achojsas cha re yabil rubini'an lepra. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y jare' tak xapon jun ixok riq'uin re Jesús, ruc'uan-apo jun frasco re banon riq'uin jun aboj rubini'an alabastro, y c'o-a ak'om jubul-oc ruxla' chupan, re ak'om re' camas caro rajal. Y jare' re xbo'rk'aja' pa rujalom re Jesús tak tz'uyul chach mesa, niva' chire' pa rachoch re Simón. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Y tak yoj re yoj ru-discípulos xkatz'at re xuban re ixok riq'uin re ak'om jubul-oc ruxla' che xuk'aj pa rujalom re Jesús, xpa kayoval y xkabila': ¿Anchique roma che xaxe tal choj quire' xtix-a la ak'om la'? ");
INSERT INTO cakYNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Roma la ak'om la' caro rajal, y mare' xc'ayex-ta y re rajal xjach-ta chiquivach re vinak re camas je meba'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero re Jesús cha'nin xk'ax pa rue', mare' reja' xubij chaka: ¿Anchique roma tak yex man yixtane-ta-ka che tzij chij re ixok re'? Xa tiya' k'ij cha. Reja' jun cosa otz xuban viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Re vinak re camas je meba' can nojel tiempo jec'o iviq'uin, chin che xabanchique k'ij nijo' niban utzil chique. Jac'a yen man nojel-ta tiempo xquinc'ue' iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Roma tak re ixok re' xuk'aj re ak'om re' chuij, can xuc'ut che c'o amor riq'uin. Reja' can xuban-yan-apo chua ancha'l niban chique re anama'i' tak ye'muk. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Y can katzij nimbij chiva, che xabanchique lugar xtitzijos-va re utzulaj ch'abal chin re Dios re nibex evangelio cha, chire' chuka' xtitzijos-va re xuban viq'uin re jun ixok re'. Can che jun ruch'ulef xtitzijos-va, y man jun bey xtimistas, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Y jun chaka yoj re yoj doce ru-discípulos re Jesús, re rubini'an Judas Iscariote, xapon quiq'uin re principal tak sacerdotes. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Reja' xbo'rbij chique: ¿Andex niya' yex chua, xe-ta yen ninjach re Jesús pan ik'a'? Y re principal tak sacerdotes xquibij che niquiya' treinta fichas re banon cha sakapuak. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y jare' tak re Judas Iscariote xutz'am runojexic andex xtuban chin quire' nujach re Jesús pa quik'a' re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Y chupan re nabey k'ij chin re namak'ij, kachin yoj re yoj israelitas, tak nitij re xcana-vay re manak levadura riq'uin, jare' tak yoj re yoj discípulos xojelon-apo riq'uin re Jesús, y xkac'utuj cha: ¿Anche' c'a najo' naban-va re va'in chupan re jun pascua re' chin nakabana' can rubanic ronojel re ndoc? ");
INSERT INTO cakYNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y jec'o chaka yoj re xe'tak-a roma re Jesús c'a pa tenemit Jerusalén, pa rachoch jun ache, y reja' xubij-a chique: Tak xquixapon, tibij cha re ache re': Re ka-Maestro rubim-pa: Re nu-tiempo xa nakaj chic c'o-va-pa. Ja pan avachoch rat ninjo' nimban-va re namalaj va'in quiq'uin re nu-discípulos, chupan re pascua re', xcha-a re Jesús chique re xe'rutak-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y re discípulos re xe'tak-a can xquiban-va ancha'l re bin-a chique roma re Jesús. Reje' can xquiban-va rubanic ronojel re ndoc chin re va'in chin re pascua. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jac'a tak xoc-ka re ak'a' chupan re k'ij re', re Jesús y re yoj doce discípulos xojtz'uye-apo chach mesa chin re namalaj va'in. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y tak yojtajin che va'in, re Jesús xubij chaka: Can katzij nimbij chiva, che jun chiva yex re xquinjacho-a pa quik'a' re vinak re ye'tzelan vichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Y tak yoj xkac'axaj quire' camas bis xpa pa tak kánma. Y c'are' can cada jun xojch'o-apo cha y xkac'utula' cha: Ajaf, ¿la mana-ta como yen re quire' xquimbano? ");
INSERT INTO cakYNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y re Jesús can jare' tak xubij chaka: Ja re anchique xtuquiak'-pa ruay viq'uin chupan re mismo lak, jare' re xtijacho vichin pa quik'a' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Can tic'axaj re xtimbij chiva, che yen re xinalax chi'icojol can xquinquimisas-va. Can xtibanataj-va ancha'l nubij chupan re ruch'abal re Dios re tz'iban can. Pero tivok'ex c'a rach re xtijacho vichin yen re xinalax chi'icojol. Re ache re xtijacho vichin más-ta otz che man-ta xalax, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y can jare' tak xch'o-apo re Judas re xtijacho chin re Jesús, y re Judas xubij: Maestro, ¿ja como yen re xquinjacho-a avichin? Y re Jesús xubij: Ja', ja rat. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y tak c'a yojtajin che va'in, re Jesús xuc'am-apo jun xcana-vay y xutioxij cha re Dios. C'are' xupar re xcana-vay re' y xuya' chaka yoj re yoj ru-discípulos. Y reja' xubij chaka: Tic'ama' y titija' re xcana-vay re'. Roma jare' re nu-cuerpo re xtapon chach re camic. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y re Jesús xuc'am-apo chuka' re vaso re c'o ruyi'al-uva chupan, y tak rutioxin chic cha re Dios, xuya' chaka. Y reja' tak xuya' chaka xubij: Chiyixnojel c'a tikumu' re ruyi'al-uva c'o chupan re copa re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Roma jare' re nuq'uiq'uel re xtibiyin tak xquincom. Can xtibiyin c'a re nuq'uiq'uel, chin che je q'uiy vinak nicuyutaj re quimac. Riq'uin re nuq'uiq'uel, can jare' xc'achoj re c'ac'a trato re rujovam-pa re Dios che nuban quiq'uin re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Can katzij nimbij chiva che jac'a ruq'uisibal bey re' re xinkum-a re ruyi'al-uva re'. Y tak xtinkum chic jun bey, tak ja chic re Nata' Dios nibano gobernar. Y can iviq'uin chuka' yex xtinkum-va re ruyi'al-uva re'. Y re xtakakum chire' jun c'ac'a ruyi'al-uva, xcha' re Jesús chaka. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y tak kabixan chic-ka re bix chin nakaya' ruk'ij re Dios, re Jesús y yoj re yoj ru-discípulos xojel-a chire' pa jay y xojba-apo chuxe' re loma rubini'an Olivos. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y tak katz'amon bey, re Jesús xubij chaka: Chupan re ak'a' re' tak yex xtitz'at che yen xquinjach-a pa quik'a' re vinak, chiyixnojel yex xa xtitaluj-ivi' y nayon xquiniya' can. Roma re Dios can quire-va rubin chupan re ruch'abal re tz'iban can: Tak yen xtinya' k'ij che xtiquimisas re nichajin quichin re ovejas, re ovejas xa xtiquitaluj-a-qui'. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero yen re yinchajin quichin re ovejas, man jumul-ta xquincom, xa xquinc'astaj chic-pa. Y ja yen re xquinyaben ivichin chila' pa Galilea, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y re Pedro can jare' tak xch'o-apo cha re Jesús y xubij: Vo xa re nic'aj chic yatquiya' can ayon tak xtiquitz'at che c'o andex re man otz-ta niban chava, pero yen man jun bey xcatinya-ta can, xcha' re Pedro cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Y re Jesús xubij cha re Pedro: Yen can katzij nimbij chava, che chupan re ak'a' re', tak c'amaje-na titzirim-pa re moma', rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y re Pedro xubij cha: Astapa' can xtinvel nucamic aviq'uin, pero man jun bey xtimbij che man ntaman-ta avach. Y can konojel yoj re yoj ru-discípulos quire' chuka' xkabij. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Y c'are' re Jesús y yoj re yoj ru-discípulos xojapon chire' chupan re lugar rubini'an Getsemaní. Xpa re Jesús xubij chaka: Yex quixtz'uye-na can ba' vova', y jac'a yen xa yimba chic-apo ba' quila-apo chin ne'mbana' orar. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Reja' xaxe re Pedro y re je ca'e' ruc'ajol re ache rubini'an Zebedeo re xe'ruc'uaj-a. Jare' tak reja' can xuna-yan re xto'rc'alvachij. Mare' camas nem re bis xpa pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y jare' tak reja' xubij chique re je oxe' ru-discípulos: Re bis c'o pa vánma, camas nem. Y can yinruquimisaj nina' yen. Can quixc'ue-pa viq'uin, quixc'ase' y man quixvar-ka, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Reja' xbiyin chic-apo ba' y chire' xuque-va-ka, y re nic'aj-rach can xukasaj-ka pan ulef, chin xuban orar. Y ja quire' re tzij re xe'rubila': Nata' yen, can-ta naban che xaxe tal choj quire' nak'ax y man-ta nink'asaj re jun tijoj-pokonal re', pero man taban re ninjo' yen, xaxe roma yen quire' nimbij chava. Roma yen xa can ninjo' chuka' nimban re najo' rat, nicha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y tak reja' xuq'uis re ru-oración, xpa quiq'uin re je oxe' ru-discípulos, pero tak xbeka quiq'uin xa ye'var. Xpa reja' xubij cha re Pedro: Can man ba' xixtiquir xixc'ase' jun ch'et hora viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Man quixvar-ka, xa tibana' orar y tic'utuj cha re Dios chin che tak yixtojtobex, man quixtzak pa mac. Can ntaman-va che re ivánma can nurayij nuban re nrajo' re Dios. Pero iyon man yixtiquir-ta, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y re Jesús xba chic-apo jun bey chin xbo'rbana' orar, y nubij: Nata' yen, vo xa c'o che nink'asaj re tijoj-pokonal re', tiene que nink'asaj, roma yen can ninjo' nimban re narayij rat. Quire' nubij chupan re ru-oración. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y tak reja' xpa chic jun bey quiq'uin re je oxe' ru-discípulos, xa ye'var chic jun bey xe'bo'rvila', roma re discípulos re' can al rij re quinak'avach roma camas quivaran. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Re Jesús xe'ruya' chic can jun bey y ja-yan rox bey re' niba chubanic orar. Reja' xucamaluj chic rubixic re tzij re xe'rubij chupan re ru-oración re c'a ba' tuban-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Y c'are' re Jesús xpa quiq'uin re je oxe' ru-discípulos, y xubij chique: Vocame quixvar. Titz'aktisaj re ivaran. Yen re xinalax chi'icojol can jac'a re nu-hora xbeka, can xquinjach-a pa quik'a' re itzel tak achi'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Cha'nin, quixyacataj. Ja la pitinak re anchique xquinjacho-a pa quik'a' re itzel tak achi'a', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y re Jesús can c'a ntajin che tzij kaq'uin yoj re yoj ru-discípulos tak can jare' xbeka re Judas re jun chaka yoj re yoj doce discípulos, y re Judas je q'uiy vinak je'ruc'uan-apo y re vinak re' je'quic'ualon che' y espada. Conojel re vinak re' je'takon-a coma re principal tak sacerdotes y coma chuka' re rejeta'k tak achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Re Judas re nijacho-a chin re Jesús can rubin chic chique re je'pitinak riq'uin, andex xtuban chin nuc'ut re Jesús chiquivach. Reja' ja quire' rubin chique: Ja re anchique xtintz'ubaj chin xtimban saludar, jare' re Jesús, y titz'ama'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y re Judas can jare' xjelon-apo riq'uin re Jesús y xubij: K'ok'a' c'a Maestro, xcha' cha. Y xutz'ubaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpa re Jesús xubij cha re Judas: ¿Andex c'a re na'bana'? Y can jare' tak xe'jelon-apo re vinak re je'binak chutz'amic re Jesús y xquitz'am-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun chaka yoj re yojc'o riq'uin re Jesús chire', can jare' tak xulisaj ru-espada y xusoc re jun ru-mozo re namalaj sacerdote. Can xutzaq'uij-a re ruxquin cha re espada re xuya' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y re Jesús jare' tak xubij cha re xbano quire': Tayaca' la a-espada. Roma re anchique xtiquimisan cha espada, can cha espada chuka' xtiquimisas reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Rat nanojij che yen man jun nita'o vichin? Xe-ta yen ninc'utuj cha re Nata' Dios che quinruto', reja' can ye'rutak-ta-pa más je setenta y dos mil ángeles chinuto'ic. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero xa can nibanataj-va re je'tz'iban can chupan re ruch'abal re Dios, mare' tak man nic'atzin-ta che ye'pa re ángeles chinuto'ic, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chupan chuka' re hora re' re Jesús xubij chique re vinak: ¿Yex xinojij che yixpitinak chutz'amic jun elek'om y mare' ic'amom-pa che' y espada? Can k'ij-k'ij c'a xintz'uye' iviq'uin chire' pa rachoch re Dios, tak xinc'ut re ruch'abal chivach y man jun bey xinitz'am-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ronojel re nibanataj vocame, xa can chin c'a che no'rbana' cumplir re je'tz'iban can chupan re ruch'abal re Dios coma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Y can jare' tak yoj re yoj ru-discípulos xkaya' can rion re Jesús y xojnumaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Re xe'betz'amo-pa chin re Jesús chire' pa Getsemaní, c'a charachoch re Caifás re namalaj sacerdote xquic'uaj-va, re anche' quimalon-va can-qui' re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas y re rejeta'k tak achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y re Pedro c'ac'anaj c'a c'o-va can, tzakatal-a chiquij y chuka' xoc-apo chire' chach rachoch re namalaj sacerdote. Tak reja' c'o chic chire', xtz'uye-apo quiq'uin re policías re jec'o-apo chire', chin che nutz'at andex kas xtiban cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y re principal tak sacerdotes, re rejeta'k tak achi'a' re c'o quik'ij y conojel re achi'a' re pa camon niquiban juzgar, niquicanola' che c'o-ta itzel tak banabal re ye'litaj chij re Jesús, chin quire' niquimisas-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y astapa' can je q'uiy re xe'bapon chin xquitz'uc tzij chij, pero can man jun chique re tz'ucuj-tzij re' xoc che ja-ta re' re xcusas. Xa c'a pa ruq'uisibal xe'bapon je ca'e' re can junan niquibij. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Re je ca'e' re' xquibij: Re ache re' rubin: Yen yintiquir ninvulaj re rachoch re Dios y pan oxe' k'ij nimpoba' chic jun bey. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y c'are' re Caifás re namalaj sacerdote, xbepa'e-pa y xubij cha re Jesús: ¿Katzij como re xquibij-ka chavij re je ca'e' re'? ¿Andex nabij vocame? ");
INSERT INTO cakYNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero re Jesús man jun tzij xubij. Y jare' tak re namalaj sacerdote xubij cha: Can chach re c'aslic Dios tabij chaka vo xa ja rat re Cristo re Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y re Jesús xubij cha: Ja', ja yen re Cristo y chuka' nimbij chiva che can xquinitz'at yen re xinalax chi'icojol, yintz'uyul pa rajquik'a' re Dios re nitiquir nuban ronojel. Y xquinitz'at tak xquinka-pa pa nube chila' chicaj, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Y can jare' tak re Caifás re namalaj sacerdote xuratz re rutziak chij roma itzel xuc'axaj, y xubij: Manak tuk'aj che nipa-ta chic jun chin no'rbij chaka che re Jesús can aj-mac-va. Chiyixnojel yex xic'axaj re c'aja-oc xubij-ka che ja reja' re Cristo. Can man otz-ta xuban chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Y andex nakaban cha vocame nibij yex? xcha' re Caifás. Y re nic'aj chic re quimalon-qui' chire' xquibij: Can ruc'amon che tiquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubaj rupalaj re Jesús y xquich'ay riq'uin c'olon-k'a' y jec'o chuka' re xquipak'ala' rupalaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Chuka' xquibila' cha re Jesús tak quitz'apin rupalaj: Rat re Cristo, tabij chaka anchique re ye'ch'ayo avichin. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Re Pedro tz'uyul chach-jay. Y jare' tak c'o jun ixok raj-ic' re namalaj sacerdote re xapon-apo riq'uin y xubij cha: Rat chuka' yat ruchibil re Jesús re aj-Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero re Pedro can chiquivach conojel xutz'uc-va tzij roma xubij: Man nak'ax-ta pa nue' anchique roma tak quire' nabij chua, xcha' cha re aj-ic'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y tak reja' nrajo' ndel-a pa puerta can jare' tak c'o chic jun ixok aj-ic' re xtz'eto-pa richin y xubij chique re jec'o-apo chire': Chuka' re jun ache re' can ruchibil re Jesús re aj pa tenemit Nazaret, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero re Pedro can xutz'uc chic tzij jun bey. Roma reja' xubij: Can chach re Dios nimbij che yen man ntaman-ta rach re jun ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Y xa c'a ba' chic che', ja chic re quimalon-qui' chire' xe'jelom-pa riq'uin re Pedro y xquibij cha: Can katzij-va che rat yat jun chique re ru-discípulos re Jesús. Xaxe riq'uin re a-forma yach'o nik'alajin che can yat ruchibil-va, roma re aj-Galilea can quire' niquiban ye'ch'o. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero re Pedro xubij: Yen man ntaman-ta rach re ache re'. Can chach re Dios nimbij chiva che man ntaman-ta rach. Y vo xa man katzij-ta re nimbij, tika c'a re castigo pa nue'. Y can jare' tak xbetzirim-pa re moma'. ");
INSERT INTO cakYNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y jare' tak re Pedro xbeka chuc'o'x re tzij re je'rubin can re Jesús cha, che tak c'amaje-na titzirim-pa re moma' tak rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch. Y c'are' re Pedro xel-a chire' y can xujek'aj ok'ej. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y tak xsakar-ka, conojel re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xquimol-qui' chin niquinojij andex niquiban cha re Jesús chin che niquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Re Jesús yach'on tak xquic'uaj-a y xbequijacha' pa ruk'a' re gobernador rubini'an Poncio Pilato. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Y re Judas re xjacho chin re Jesús, tak xutz'at che re Jesús xc'uax-a chach re Pilato chin che nibex cha che niquimisas, jare' tak reja' xpa bis y k'axon riq'uin y xbo'rtzolij can re treinta fichas re banon cha sakapuak. Xbo'rtzolij can chique re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Re Judas ja quire' xubij can chique re achi'a' re': Yen can ximacun tak xinjach re Jesús pan ik'a', roma reja' man jun rumac chin che niquimisas. Pero re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij, xquibij-pa cha: Yoj man jun chic ka-cuenta cha, che re Jesús manak mac rubanon. Re' xaxe chavach rat. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Y re Judas ja chire' pa rachoch re Dios xutorij-va can re treinta fichas re banon cha sakapuak, y xba. Y c'are' xbo'rjetz'aj-ri'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y re principal tak sacerdotes xquimol-a re mero re xbo'rtzolij can re Judas y xquibij: Re mero re' man ruc'amon-ta che nakaxol-ka riq'uin re mero re niya' can vova' pa rachoch re Dios, roma re mero re' xa rajal jun ache re xtibiyin ruq'uiq'uel. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jac'a tak quiyi'on chic chiquivach re andex niquiban riq'uin re mero re', reje' xquilok' re jun juyu' chin re jun banoy-bojo'y. Re juyu' re' can xtic'atzin che ja chire' ye'muk-va re vinak re man je israelitas-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Y mare' re jun juyu' re' can c'a nibex Ulef chin Quic' cha, c'a chupan re tiempo re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Riq'uin re' can xbanataj-va re rubin can re Jeremías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Reja' ja quire' rubin can: Y re je rey-rumam can re ache xubini'aj Israel, xquilisaj-a treinta fichas re banon cha sakapuak, re mero re' xquiya' reje' roma xquibij che jare' re rajal re rusamajel re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y re mero re' jare' re xquiya' chin xquilok' re rujuyu' re banoy-bojo'y. Can ancha'l-va rubin re Ajaf chua. Ja quire' rubin can re Jeremías. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y re Jesús pa'al-apo chach re gobernador rubini'an Poncio Pilato. Y re gobernador re' xuc'utuj cha re Jesús: ¿Ja rat re qui-Rey re israelitas? Y re Jesús xubij: Ja', ja quire', can ancha'l re xabij. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij, jun quichi' niquiban-apo chij re Jesús, pero reja' can man jun tzij nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Re Pilato can jare' tak xubij cha re Jesús: Y can man naya-ta pa cuenta re niquibij re vinak chavij chin yatquisujuj. Y rat man jun tzij nabij. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero re Jesús cama-va jun tzij xubij cha re Pilato. Y mare' re gobernador re' can anchique-la xuna', roma man jun bey rutz'eton che jun vinak quire-ta nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y ronojel juna' tak napon re kanamak'ij yoj re yoj israelitas rubini'an pascua, can nilisas-a jun chique re presos re jec'o pa cárcel roma ja quire' re costumbre, y re gobernador ja re preso re niquic'utuj re vinak cha jare' re nulisaj-a libre. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan re tiempo re', c'o c'a jun ache rubini'an Barrabás re kejnak pa cárcel, y re jun ache re' can conojel je'atamayon rach che camas itzel ache. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y tak xbequimola-qui' re vinak chire', re Pilato xubij-pa chique: ¿Y yex anchique chique reje' re nijo' che yen ninlisaj-a libre? ¿Nijo' che ninlisaj-a re Barrabás o ja re Jesús re nibex chuka' Cristo cha? ");
INSERT INTO cakYNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Re Pilato can quire-va xubij-pa, roma can rutaman-va che re vinak re' quiyi'on re Jesús pa ruk'a', roma camas itzel niquina' cha che camas je q'uiy vinak re ye'tzekelben richin. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y re Pilato tz'uyul re anche' nuban-va juzgar, tak xapon rutzijol riq'uin re rubin-a re ruxayil cha. Y ja quire' re rutakon-a rubixic cha: Re Jesús jun ache re man jun mac rubanon, mare' rat, man catoc quichibil re ye'jovan niquiquimisaj. Roma yen rutzij re Jesús ximban jun itzel achic'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Y re principal tak sacerdotes y re rejeta'k tak achi'a' re c'o quik'ij, xquiya' quina'oj re vinak xaxe chin che tiquic'utuj-apo che ja re Barrabás re tilisas-a libre y re Jesús tiquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y tak re gobernador xuc'utuj chic jun bey chique re vinak re' che anchique chique re je ca'e' re' re xtulisaj-a libre, re vinak re' can jare' tak xquibij: Ja re Barrabás nakajo' che talisaj-a libre. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","C'are' re Pilato xuc'utuj chique re vinak: ¿Y andex nibij yex che yen nimban riq'uin re Jesús, re nibex chuka' Cristo cha? Y jare' tak conojel xe'ch'o-apo y xquibij: Re Jesús tiquimisas cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xpa re gobernador xubij chique re vinak: ¿Andex rumac rubanon chivach c'a? Pero re vinak man ye'tane-ta-ka. Xa más xquirak-apo quichi' y xquibij: Tiquimisas cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y tak re Pilato xutz'at che man jun chic cosa nitiquir nuban y re vinak camas niquiban, xpa reja' xbo'rc'ama-pa ba' ya' y xuch'aj ruk'a' chiquivach conojel re vinak re', y xubij chique: Camanak-va numac yen cha re rucamic re jun ache re' re man jun rumac. Re' xa jac'a yex yixc'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xe'pa conojel re vinak xquibij: Pues pa kave' c'a yoj y pa quive' re kami'al-kajc'ual tika-va re rucamic re jun ache re', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Y jare' tak re gobernador can chiquivach re vinak xulisaj-a libre re Barrabás, jac'a re Jesús antes che nujach-a pa quik'a' re ye'quimisan richin cho cruz, re Pilato xutak ruch'ayic re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y re soldados chin re gobernador re' xquic'uaj-apo re Jesús chupan re palacio. C'are' xe'cayoj conojel re nic'aj chic soldados, re quichibil-qui' quiq'uin. Can xe'quimol-apo chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xe'pa re soldados re' xquilisaj-a re rutziak re Jesús, y c'are' xquiya-ka jun tziak quiak chij can ancha'l-va re ye'quicusala' re reyes. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Reje' xquipach'uj chuka' jun k'ayis re camas ruq'uixal. Y xquiban ancha'l jun corona cha y c'are' xquiya' pa rujalom. Y chuka' xquiban cha re Jesús che xutz'am jun aj, y re ruk'a' re xtz'amo re aj, ja re rajquik'a', y can ye'xuque' chach. Y xquiban saludar can ancha'l niban saludar jun Rey, pero tak quire' niquiban xa chin burla, roma niquibij cha che rat yat qui-Rey re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Niquichubaj chuka' rupalaj, y re aj re c'o pa ruk'a' niquilisaj-a chin niquich'ay pa rujalom. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y tak xe'tane' che tza'n chij, xquilisaj-a re tziak re quiyi'on-ka chij. C'are' xquiya-a re can rutziak-va, y xquic'uaj-a chin che ne'quibajij cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y jac'a tak quitz'amon-a bey chin ne'quibajij re Jesús cho cruz xquic'ul jun ache, y re ache re' rubini'an Simón y reja' aj pa tenemit Cirene. Y re soldados can xquiban cha re ache re' che tuc'uaj-a re ru-cruz re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y xe'bapon c'a chupan re jun lugar rubini'an Gólgota. Re lugar re', Calavera chuka' ye'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tak jec'o chic chire', xquiya' cha re Jesús jun ch'amalaj ruyi'al-uva xalon jun ak'om camas c'ay riq'uin. Pero tak reja' xutaj retal, man xrajo-ta xukum. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y tak re soldados xquibajij-yan re Jesús cho cruz, xquitz'am rubanic sortear re rutziak chin xquitz'at andex che tziak re nuban-a tocar cada jun. Y riq'uin re' can nibanataj re bin can roma re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re jun rusamajel re Dios can chij c'a re Cristo ch'ovenak-va can tak xubij: Xe'quijachala' re nutziak chiquivach y chuka' xquiban sortear. Quire' nubij re rutz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Re soldados je'tz'uyul c'a chire' quichajin-apo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y pa rue' re cruz xquiya' jun tz'alam y chach re tz'alam re' tz'iban-va re andex rumac re Jesús, y mare' niquimisas. Chach re tz'alam re' nubij: Re Jesús jare' re qui-Rey re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Y ja chuka' re' tak jec'o je ca'e' elek'oma' re xe'quimisas cho cruz. Jun xya' pa rajquik'a' re Jesús y re jun chic pa ruxocon. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Re vinak re ye'k'ax re anche' c'o-va re Jesús, niquisiloj-apo quijalom chach, roma can man niquinimaj-ta che ja reja' re Ruc'ajol re Dios. Y chuka' c'o tzij re ye'quibila' can cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Y ja quire' re niquibij: Rat re yabin che navulaj re rachoch re Dios y pan oxe' k'ij napoba' chic jun bey, tacola' c'a-avi' ayon. Y vo xa ja rat re yat Ruc'ajol re Dios, caka-pa chach la a-cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y ja chuka' quire' niquiban re principal tak sacerdotes, re je'atamayon re ley kachin yoj re yoj israelitas, re achi'a' fariseos y re rejeta'k tak achi'a' re c'o quik'ij, ye'tze'en chij re Jesús y niquibila' chiquivach: ");
INSERT INTO cakYNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Reja' can je q'uiy xe'rucol, pero vocame ni xe-ta reja' mismo man nitiquir-ta nucol-ri'. Y vo xa ja reja' re Rey kachin yoj re yoj israelitas, tika-pa chach la ru-cruz y yoj can xtakanimaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Reja' can xuban confiar-ri' riq'uin re Dios, y vo xa re Dios can nrajo' re Jesús, tucola' c'a. Roma re Jesús rubin: Ja yen re Ruc'ajol re Dios. Can quire-va rubin, xe'cha' re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y re elek'oma' re junan je'bajin cho cruz riq'uin re Jesús, can ja chuka' quire' niquiban, ancha'l re nic'aj chic. Roma c'o chuka' tzij re niquibila-apo cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y ja tak xapon re nic'aj k'ij, jare' tak che jun ruch'ulef xk'ukumataj rach. Y re k'oko'm re' xq'uis-a c'a pa tak a las tres re tak'ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y como pa tak a las tres re tak'ak'ij chuka', jare' tak re Jesús cof xch'o y xubij: Elí, Elí, ¿lama sabactani? xcha'. Y re tzij re' ndel che tzij: Nu-Dios yen, nu-Dios yen, ¿anchique c'a roma tak xinamalij can? ");
INSERT INTO cakYNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y jec'o re jec'o-apo chire' chunakaj re Jesús, tak xquic'axaj re xubij, xquibila': Reja' xa ja re Elías re nrayoj. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y can jare' tak c'o jun re jonanin xba y xbo'rc'ama-pa jun ancha'l bo'j re nibex esponja cha, xumuba' chupan vinagre. C'are' xuya' re esponja chutza'n jun aj, chin xuya' cha re Jesús chin che otz ba' nuban-ka cha re nichake'j ruchi'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero re nic'aj chic re jec'o-apo chire' riq'uin re Jesús, xquibij: Taya' k'ij cha, takatz'eta-na vo xa katzij che xtipa re Elías chucolic. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero re Jesús xa can jare' tak cof chic xch'o, y xujach re ránma pa ruk'a' re Dios, y xcom. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y jare' tak re utzulaj tziak re anchok cha tason-va rupan re rachoch re Dios xel ca'e'. Xutz'am-pa pa rue' c'a charakan-ka. Chuka' xuban jun namalaj sananel y re aboj can xquijakala-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Re jul re anche' je'mukun-va re anama'i' xe'jakataj. Y je q'uiy chique re je rajc'ual re Dios re je quiminak chic-a, xe'c'astaj-pa, ");
INSERT INTO cakYNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xe'be'el-pa. Jac'a tak xc'astaj-yam-pa re Jesús, jare' tak xe'tz'etetaj chuka' reje'. Reje' chuka' xe'bapon chupan re lok'olaj tenemit Jerusalén. Can chiquivach je q'uiy xquic'utula-va-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Re ache capitán y conojel re ru-soldados quichajin-apo re Jesús, y tak xquitz'at-yan re xuban re sananel, y chuka' xquitz'at-yan re nic'aj chic andex re xe'banataj, reje' camas xquixibij-qui' y xquibila': Can katzij-va che re jun ache re' Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y je q'uiy ixoki' re can je'tzakatal-va-pa chij re Jesús tak xel-pa chire' pa Galilea chin niquivilij, reje' ye'tzu'um-pa chij re Jesús tak c'o cho cruz, pero c'ac'anaj c'a jec'o-va-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicojol c'a conojel re ixoki' re' c'o-va re María Magdalena, re María re quite' re Jacobo y re José, y chuka' re ruxayil re ache rubini'an Zebedeo, re quite' re Jacobo y re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jac'a tak xk'ak'ij-yan-ka, c'o c'a jun re xtzekelben richin re Jesús xapon. Re jun ache re' biyom y aj pa tenemit Arimatea, rubini'an José. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Reja' xba riq'uin re Pilato re gobernador y xbo'rc'utuj re ru-cuerpo re Jesús cha chin numuk. Y re Pilato xubij che tiya-a re ru-cuerpo re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y re José chin che xuc'uaj-a re ru-cuerpo re Jesús, xbo'rc'ama-pa, y c'are' xupis-a pa jun sábana ch'ajch'oj. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Re José xbo'rya' c'a can re ru-cuerpo re Jesús pa jun jul c'ac'a, re jun jul re' ja reja' re c'otoyon chach jun peña. Y tak reja' rutz'apin chic can ruchi' re jul riq'uin jun moma' aboj, c'ajare' tak xtzolaj. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Pero re María Magdalena y re jun chic ixok rubini'an chuka' María, can c'a xe'tz'uye-na can chach re jul re anche' xmuk-va can re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Re k'ij tak xmuk re Jesús, ja k'ij chuka' re' tak re vinak niquibanala' chic rubanic ronojel re xtoc chique chin re ruca'n k'ij, roma jare' tak nitiquir-a re k'ij chin uxlanen. Y chupan re k'ij chin uxlanen, jare' tak re principal tak sacerdotes y re achi'a' fariseos xe'ba riq'uin re Pilato re gobernador. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Reje' xbequibij cha: Yoj xbeka chakac'o'x che tak re Jesús can c'a c'as che' xubij che pa rox k'ij xtic'astaj-pa chiquicojol re anama'i'. Can quire-va rubin can re jun aj-tz'ucuy-tzij re'. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Y chin che man que'pa chak'a' re ru-discípulos chin niquilek'aj-a re ru-cuerpo re Jesús y c'are' niquibij chique re vinak: Re Jesús can xc'astaj-va-a chiquicojol re anama'i', mare' vocame yoj yojpitinak chin nakac'utuj jun utzil chava che ca'taka-a soldados chin ne'quichajij re anche' xmuk-va can, y c'a titz'akater-na re oxe' k'ij. Y vo xa man xtakaban-ta quire' y xtisatz-a re ru-cuerpo, c'are' c'a más je q'uiy re xque'niman che can takon-va-pa roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y re Pilato xubij chique re achi'a' re': Quixbiyin y que'c'uaj-a la soldados la' chin ne'quichajij. Yex xa can jabal chic itaman andex rubanic re niban can cha, xe'cho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Re achi'a' re' can xe'ba anche' xmuk-va can re Jesús y otz rubanic xbequibana' can cha chin che otz tichajex. Xbequibana' can sellar re aboj re anchok cha tz'apin-va can ruchi' re jul. Y xe'quiya' can chuka' re soldados chire' chin niquichajij. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y tak xk'ax-yan re k'ij chin uxlanen, cumaj-yan cha re domingo re nabey k'ij chin re semana, re María Magdalena y re jun chic ixok rubini'an chuka' María, xe'ba c'a chuchi-jul re anche' xmuk-va can re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Y xuban jun namalaj sananel tak c'amaje-na que'bapon re ixoki' chire' chuchi-jul, roma jun ángel chin re Ajaf pitinak chila' chicaj, xka-pa re anche' xmuk-va can re Jesús. Re ángel xulisaj-a re jun aboj re anchok cha tz'apin-va can ruchi' re jul y xtz'uye-ka pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Re rusakil re ángel re tz'uyul pa rue' re aboj, xa can junan riq'uin re sakil nuya' jun relámpago. Y re rusakil re rutziak can junan riq'uin re rusakil re hielo nika tak camas tef nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y re soldados re ye'chajin, roma camas xquixibij-qui' chach re ángel, mare' can ye'barbot. Can je quiminak roma quiximbire'. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Y jac'a tak xe'bapon re ixoki' re', re ángel xch'o quiq'uin y xubij chique: Man tixibij-ivi'. Roma yen can ntaman-va che yex ja re ru-cuerpo re Jesús re xquimisas cho cruz re nicanoj. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Re ru-cuerpo reja' xa manak chic vova', roma reja' xc'astaj-yan-a, ancha'l re rubin can chiva. Quixampa y titz'eta-na-pa' re anche' xc'ue-va re ru-cuerpo re Ajaf. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Can quixtzolaj cha'nin, chin che ne'ibij chique conojel re ru-discípulos re Jesús che reja' xc'astaj-yan-a chiquicojol re anama'i'. Reja' can xtinabayaj-a chivach, chin che nic'ul-ivi' chila' pa Galilea. Y chire' xtitz'at-va ancha'l re nimbij-a chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y re je ca'e' ixoki' re' can jare' xe'el-a chire' pa jul. Y astapa' can quixibin-qui', pero chuka' camas ye'qui'cot. Reje' can jonanin xe'ba chin che ne'quiya' rutzijol chique re ru-discípulos re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Y jare' tak re Jesús xbec'ulum-pa chiquivach po bey y xubij chique: Can quixqui'cot. Quire' xubij chin che xuya' ruxnokil-quivach. Y re je ca'e' ixoki' re' xe'jelon-apo riq'uin y can jare' xe'xuque-ka charakan re Jesús, xquik'etej re rakan y chuka' can xquiya' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y re Jesús can jare' tak xubij chique re ixoki' re': Man chic tixibij-ivi'. Vocame quixbiyin y te'iya' rutzijol chique re hermanos. Chin che can ye'ba c'a pa Galilea y chila' c'a xquinquitz'at-va. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Re ixoki' re' can c'a quitz'amon bey. Y jare' tak jec'o nic'aj chique re soldados ye'chajin chire' chuchi-jul xe'ba c'a pa tenemit Jerusalén. Re soldados re' xbequiya' rutzijol chique re principal tak sacerdotes ronojel re xbanataj chire' anche' xmuk-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xe'pa re principal tak sacerdotes xquimol-qui' quiq'uin re rejeta'k tak achi'a' re c'o quik'ij y xquiya' chiquivach che niquiya' q'uiy mero chique re soldados re xe'chajin. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Y xquibij chique: Yex xaxe tibij chique re vinak che ja tak yixvar jare' tak xe'bapon re ru-discípulos re Jesús pa k'oko'm y xquilek'aj-a re ru-cuerpo. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y vo xa re gobernador nutamaj che xa xixvar-ka y man xichajij-ta re ancha'l bin chiva, yoj xkojch'o riq'uin y xkojrunimaj. Chin quire' can xquixkacol pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Re soldados re xe'chajin chuchi-jul xquic'ul re mero, y ancha'l re xbex-a chique can ja quire' xquiban. Y ja tz'ucuj-tzij re' re xel rutzijol chiquicojol re vinak israelitas c'a chupan re tiempo vocame. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jac'a re yoj once ru-discípulos re Jesús, xojba c'a pa Galilea. Xojba pa rue' re loma re bin can chaka roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y tak xkatz'at rach re Jesús, can xkaya' ruk'ij. Y jec'o chaka yoj re man niquinimaj-ta che ja re Jesús jare' re c'o kaq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Re Jesús can xjelon-apo kaq'uin y xubij chaka: Ronojel jachon pa nuk'a' yen, re jec'o chila' chicaj y quire' chuka' re jec'o vova' chach re ruch'ulef. Can ronojel poder yi'on chua. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mare' vocame can nimbij-va chiva: Quixbiyin chach ronojel ruch'ulef y che re vinak yinquinimaj-ta chin yinquitzekelbej. Que'ibana' bautizar pa rube' re Dios re Tata'aj, pa nube' yen re Ruc'ajol re Dios y pa rube' re Espíritu Santo. ");
INSERT INTO cakYNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tic'utu' chiquivach che tiquibana' obedecer ronojel re nbin can. Y yen can k'ij-k'ij c'a xquinc'ue' iviq'uin, y can xquinc'ue-va iviq'uin c'a pa ruq'uisibal k'ij chin re ruch'ulef. Amén.");
INSERT INTO cakYNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Y ja quire' tak xtiquir-a re utzulaj ch'abal chin re Jesucristo re Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Re Isaías re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha, rutz'iban can re xbex cha roma re Dios chij re Jesucristo. Y ja quire' nubij re rutz'iban can reja': Xtintak c'a jun ache nabey, chin che nuchojmersaj re bey anche' xtapon-va re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jac'a ache re' re xtic'ue' chupan jun lugar re anche' manak vinak re nibex desierto cha. Y ja reja' re xtitzijon re ruch'abal re Dios chiquivach re vinak re xque'bapon riq'uin. Y xtubila' chique: Tichojmersaj rubey re ic'aslen, roma re Ajaf xa can nipa-yan. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Re ache re xunataj re Isaías che xtipa nabey, ja re Juan Bautista. Y reja' c'o chic chupan re jun lugar re anche' manak vinak re nibex desierto cha, y nubij chique re vinak re ye'bapon riq'uin che tijalataj quic'aslen chach re Dios y tiquibana' bautizar-qui', chin quire' re Dios nucuy quimac. Y reja' je q'uiy re ye'ruban-a bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y camas je q'uiy vinak re ye'bapon riq'uin re Juan Bautista. Jec'o que'pa pa tenemit Jerusalén. Y jec'o je'pitinak pa tak nic'aj chic tenemit chin re Judea. Re vinak re' ye'quicholola-apo re quimac chach re Juan Bautista chire' pa rakan-ya' Jordán y ye'ban-a bautizar roma reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Re tziak re nucusaj re Juan Bautista riq'uin rusumal camello banon-va, y jun tz'um re aconak ximibal-rupan. Y re ruay ja re sac' y re cab re niquiya' ch'utak chicop pa tak k'os. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Re Juan xutzijoj chique re vinak: Re tiempo pitinak xtipa Jun re man ancha'l-ta-oc yen. Re Jun re' can c'o ruk'ij y ru-poder, mare' yen, hasta xaxe chin che yinluque-ka chin ninsol re ximibal-rach re ruxajab, chua yen can man ruc'amon-ta roma c'o ruk'ij y ru-poder. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y yen, ya' nincusaj chin yiximban bautizar. Pero re Jun re xtipa, riq'uin re Espíritu Santo xquixruban-va bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja k'ij re' tak re Jesús elinak-pa pa tenemit Nazaret chire' pa Galilea y xbeka riq'uin re Juan. Y reja' xban bautizar roma re Juan pa rakan-ya' Jordán. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y tak re Jesús xel-pa pa ya', xutz'at re rocaj xjakataj, y re Espíritu Santo nika-pa pa rue' ancha'l jun paloma. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y jare' tak c'o Jun re xch'o-pa chila' chicaj y xubij: Ja rat re Nuc'ajol, y yen camas yatinjo' y yinqui'cot aviq'uin, xcha' re ch'abal re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Can jare' tak xban cha re Jesús roma re Espíritu Santo chin xba chupan re jun lugar re anche' manak vinak re nibex desierto cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y can nik'alajin che chupan jun lugar re anche' manak vinak c'o-va roma can jec'o-apo re itzel tak chicop chire'. Chire' xc'ue-va cuarenta k'ij. Y tak re Jesús c'o chire', re Satanás nutaj ruk'ij chij che nika-ta pa mac, pero man xtiquir-ta chij. Y re ángeles xquivilij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'o chic re Juan pa cárcel, tak re Jesús xba pa Galilea. Re Jesús nutzijoj re utzulaj ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Y nubij: Re k'ij re rubin can re Dios che re vinak ye'oc pa ruk'a' reja', xbeka-yan. Tinimaj re utzulaj ch'abal chin re Dios re nibex evangelio cha, y tijalataj re ic'aslen chach re Dios, nicha' reja' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y jun k'ij tak re Jesús binak chuchi' re lago rubini'an Galilea, xe'rutz'at je ca'e' achi'a' quichak'-qui', re jun rubini'an Simón y re jun chic ja re Andrés, y reje' je aj-tz'amoy-car. Mare' tak niquiya-ka re quiya'l chapabal-car pa ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Y jare' tak re Jesús xubij chique: Jo', jo' chuij, y xtinc'ut chivach andex niban chin ye'tz'am vinak chin che ye'tzake' chuij. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Re je ca'e' achi'a' re', can jare' xquiya' can re quiya'l chin chapabal-car y xe'ba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y c'a ba' que'biyin che', tak re Jesús xe'rutz'at re Jacobo y re Juan re je rajc'ual re jun ache rubini'an Zebedeo. Re je ca'e' achi'a' re' pa canoa jec'o-va, ye'samaj. Reje' ye'quic'ajoj re quiya'l chapabal-car. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Y xpa re Jesús xe'rayoj chin ye'ba chij. Y re Jacobo y re Juan can xe xquic'axaj quire', xe'ba chij. Y xaxe re quirta' y re samajela' re xe'c'ue' can chire' pa canoa. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Re Jesús y re je'binak chij, xe'bapon pa tenemit Capernaum. Y chupan re k'ij chin uxlanen, re Jesús xba chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Reja' nubij re ruch'abal re Dios chique re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y re xe'c'axan richin, xsatz quic'o'x y can anchique-la xquina' roma re ch'abal re xquic'axaj. Roma re Jesús tak nuc'ut re ruch'abal re Dios can ancha'l jun re c'o autoridad pa ruk'a' y man ancha'l-ta-oc re niquic'ut re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, re k'ij re' c'o-apo jun ache re c'o jun itzel espíritu riq'uin. Y re itzel espíritu re c'o riq'uin re ache xsiq'uin, ");
INSERT INTO cakYNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","y xubij cha re Jesús: ¿Andex najo' chaka rat Jesús re yat aj-Nazaret? ¿Xapa chin che yojaq'uis? Yen ntaman yat anchique rat y mare' ntaman che rat can yat lok'olaj Ruc'ajol re Dios, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero re Jesús xubij cha re itzel espíritu: Ch'oj-achi'. Catel-a riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y re itzel espíritu nisiq'uin xel-a. Y xuyiquiquej can re ru-cuerpo re ache re anchok riq'uin xel-va-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y re vinak re quimalon-qui' chire', xsatz quic'o'x tak xquitz'at re xuban re Jesús, y niquibila' chiquivach: ¿Andex che enseñanza y andex che banabal re'? Roma re nuc'ut reja', man jun bey kac'axan-ta yoj. Tak nich'o, can ja re nubij reja' re tiene que niban. Re itzel tak espíritu can niquinimaj rutzij, ye'cha' re vinak chiquivach-ka reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y cha'nin c'a xel rutzijol re Jesús, y mare' re vinak re jec'o pa tak tenemit re jec'o chunakaj re Galilea, cha'nin xquinabej re nubanala' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tak re Jesús, re Jacobo y re Juan xe'el-pa chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, reje' xe'ba charachoch re Simón y re Andrés. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero tak xe'bapon, xbex cha re Jesús che re rujete' re Simón kejnak chuch'at, roma jun namalaj c'atan tz'amayon richin. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y re Jesús can jare' xbo'rtz'eta' re ixok. Reja' xutz'am chuk'a' y xuyac. Y can xe quire' xuban cha, can jare' xk'ax-a re c'atan chij. Y re ixok re' can jare' xutz'am quilixic re Jesús y re je'binak chij. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Y jac'a tak xka-yan-ka re k'ij y xk'ok'a-ka chupan re k'ij re', jare' tak can conojel re vinak re c'o yava'i' quiq'uin xe'quic'uala-apo chach re Jesús. Re yava'i' re', c'o re choj che yabil re ndoc chique y jec'o re je yava'i' pa quik'a' itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Camas c'a je q'uiy re vinak re xquimol-apo-qui' chire', xa can bama conojel re vinak re jec'o chupan re jun tenemit re' re xe'bapon pa jay re anche' c'o-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y re Jesús can xe'ruc'achojsala-va-a re yava'i'. Re yava'i' re' q'uiy c'a rach yabil re tz'amayon quichin. Chuka' reja' xe'rulesala-a re itzel tak espíritu re jec'o quiq'uin re vinak re je'tz'amon coma itzel tak espíritu. Re Jesús can man xuya-ta k'ij chique re itzel tak espíritu che xe'ch'o-ta, roma reje' quitaman anchique reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Namak'a-yan ruca'n k'ij, re Jesús xyacataj-a y xba chupan jun lugar re anche' manak vinak re nibex desierto cha, chin xbo'rbana' orar. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y re Simón y re nic'aj chic ruchibil xe'ba canoy chin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tak xquivel, xquibij cha: Yacanox coma conojel vinak, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y re Jesús xubij chique: Jo' pa tak nic'aj chic tenemit re jec'o nakaj, che nintzijoj chuka' re ruch'abal re Dios chire', roma chubanic re samaj re' tak ximpa vova' chach re ruch'ulef, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y reja' xba chutzijosic re ruch'abal re Dios chupan ronojel re Galilea. Xabanchique tenemit napon-va, reja' nutzijoj re ruch'abal re Dios re pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y chuka' can xe'rulesala' re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'o jun ache xapon riq'uin re Jesús, y re ache re' niyavaj y ja re yabil rubini'an lepra re c'o chij, reja' xuque-ka chach y xubij cha: Yen ntaman che rat yatiquir yinac'achojsaj cha re nuyabil, pero man ntaman-ta andex nanojij pa nue'. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Re Jesús camas c'a xujoyovaj rach re ache, mare' reja' can jare' xutz'am-apo y xubij cha: Ninjo' che yac'achoj. Tiq'uis-a re yabil re' chavij, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y can xe xubij quire' re Jesús, re ru-lepra re ache xq'uis-a y xch'ojch'ojer can. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Y re Jesús can jare' xubij cha re ache che tiba, pero camas xuchalabej-a cha re andex nic'atzin che nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Re Jesús xubij-a cha re ache re': Man tatzijoj chique re vinak che xac'achoj cha re ayabil, vocame choj cabiyin pa rachoch re Dios chin ta'c'utu-avi' chach re sacerdote. Y taya' re ofrenda re nubij chupan re libro re rutz'iban can re Moisés. Y chupan re libro re' nubij re nic'atzin che naya' rat. Chin quire' niquitamaj che yat ch'ajch'oj chic, xcho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero re ache xa can xe xuya' can re Jesús, xa xutz'am rutzijosic chique re vinak che xc'achoj cha re ruyabil. Y mare' re Jesús cha'nin xel rutzijol, y man nitiquir-ta chic ndoc-apo re pa tak tenemit re anche' napon-va, roma xa camas je q'uiy vinak re ye'c'ulu-apo richin. Y roma chuka' re', re Jesús nic'ue' can re pa tak juyu'. Re lugar re anche' manak vinak. Y re vinak re ye'bapon riq'uin camas je q'uiy, y q'uiy lugar je'pitinak-va re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Y tak k'axnak chic ca'e-oxe' k'ij, re Jesús xtzolaj pa tenemit Capernaum, y jare' tak re vinak xquic'axaj che reja' c'o pa jun jay chire' pa tenemit. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jare' tak jec'o vinak re cha'nin xquimol-apo-qui' riq'uin re Jesús. Man ye'ruban-ta chic re pa jay, mare' chibil chojay jec'o vinak. Re pa ruchi-jay can man jun chic nitiquir ndoc. Y re Jesús can nutzijoj re ruch'abal re Dios chique conojel re xquimol-apo-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jare' tak jec'o nic'aj chic re xe'bapon. Reje' quic'uan-apo jun ache siquirnak ru-cuerpo. Je caje' re je'ac'ayon-apo richin, quili'en-a chach jun camilla. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero reje' xa man xe'tiquir-ta xe'oc-apo riq'uin re Jesús, roma re vinak re quimalon-apo-qui' camas je q'uiy. Man xe'tiquir-ta xe'k'ax chiquicojol re vinak re', mare' ja chic re rue' re jay re xquichobij. Y re jul re xquiban, can ja re anche' c'o-va re Jesús. Y chire' xquikasaj-va-ka re yava' y chibil re ru-camilla. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y tak re Jesús xe'rutz'at che can quibanon confiar-qui' riq'uin, xubij cha re ache siquirnak ru-cuerpo: Vajc'ual, re amac xe'cuyutaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y re jay re anche' quimalon-va-qui', jec'o-apo chuka' re achi'a' je'atamayon re ley kachin yoj re yoj israelitas, y reje' je'tz'uyul-apo. Reje' niquinojij pa tak cánma: ");
INSERT INTO cakYNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Anchique roma tak re Jesús nubij cha la ache che nucuy rumac? Can nuban che ja reja' re Dios. Roma ¿anchique-ta c'a vinak nucuy amac? Man jun. Xaxe re Dios re nucuy amac, ye'cha' pa tak cánma re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero re Jesús can rutaman re niquinojij pa tak cánma re achi'a' re'. Y mare' xubij chique: ¿Anchique roma tak yex quire' ninojij pa tak ivánma? ");
INSERT INTO cakYNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Roma vo xa yen yintiquir nimban cha re jun ache siquirnak ru-cuerpo chin che nibiyin-a, y nuc'uaj-a la ru-camilla, can yintiquir chuka' nimbij cha che nincuy rumac. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Y vocame, chin che yex nitamaj che yen re xinalax chi'icojol can c'o poder pa nuk'a' chin che nincuy mac, titz'eta', xcha' chique. Y jare' tak re Jesús xubij cha re ache siquirnak ru-cuerpo: ");
INSERT INTO cakYNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Chava rat nimbij-va: Cayacataj, tac'uaj-a la a-camilla y cabiyin cha'vachoch, xcho'x roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y re ache can jare' xpa'e-a, xuc'uaj-a re ru-camilla, y xel-a chiquicojol re quimalon-qui' chire'. Y re vinak re' xsatz quic'o'x, roma man jun bey quitz'eton-ta che quire' nibanataj. Y xquiya' chuka' ruk'ij re Dios y xquibila': Man jun bey katz'eton che quire' nibanataj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y re Jesús xba chuchi' re lago jun bey chic, y camas je q'uiy vinak re xe'bapon riq'uin, y reja' ye'rutijoj riq'uin re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y tak xtzolaj-pa, jare' tak xutz'at re Leví, re ruc'ajol re jun ache rubini'an Alfeo. Re Leví tz'uyul chach jun ch'acat, y ja cha reja' nitoj-va can re impuestos. Xpa re Jesús xubij cha: Jo' chuij. Y jare' tak reja' xbeyacataj-pa re anche' tz'uyul-va y xtzake-a chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y jac'a tak reja' tz'uyul chach mesa chire' pa jay, je q'uiy chique re molay tak impuestos y chuka' re vinak re nibex aj-maqui' chique, xe'tz'uye-apo chach mesa riq'uin re Jesús y re ru-discípulos. Camas c'a je q'uiy re je'tzakatal chij re Jesús re jec'o-apo chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y tak re fariseos y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas, xquitz'at re Jesús che xa niva' quiq'uin re molay tak impuestos y quiq'uin chuka' re vinak re nibex aj-maqui' chique, xquic'utuj chique re ru-discípulos: ¿Anchique roma reja' niva-nuq'uia' quiq'uin re molay tak impuestos y quiq'uin chuka' la aj-maqui'? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Y tak re Jesús xuc'axaj-pa re tzij re niquibij re fariseos y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas, reja' xubij chique: Jun doctor mana-ta re je otz re ye'ruk'omaj. Reja' ye'ruk'omaj re c'o quiyabil. Yen man ximpa-ta chiquicanoxic vinak re choj quic'aslen. Yen ximpa chiquicanoxic re c'o quimac, re nic'atzin che nijalataj quic'aslen chach re Dios, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Re ye'tzekelben chin re Juan Bautista y re ye'tzekelben quichin re achi'a' fariseos, c'o k'ij quicha'on chin niquiban ayuno. Y mare' xquic'utuj cha re Jesús: Yoj re yojtzekelben chin re Juan y re ye'tzekelben quichin re fariseos can kacha'on k'ij chin nakaban ayuno. ¿Y anchique roma tak re a-discípulos rat man quire-ta niquiban? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y re Jesús xubij chique: Re je'banon invitar pa jun c'ulubic siempre ye'va', roma re ala' xc'ule' c'o quiq'uin, y quire' chuka' niquiban re nu-discípulos, reje' ye'qui'cot roma yinc'o quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xtapon re k'ij tak re ala' re' xtilisas-a chiquicojol, y c'ajare' tak xtiquiban ayuno. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Y chuka' man jun vinak nicusan jun c'ojobal c'ac'a chin nuc'ajoj jun tziak re tzia'k chic. Roma jun c'ojobal c'ac'a man otz-ta nuban riq'uin re tziak re tzia'k chic, roma nuc'ol-ri' y mare' re tziak re tzia'k chic xa más niretzetaj-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y quire' chuka' man jun vinak niyi'o c'ac'a vino chupan jun tz'um tzia'k chic chin nuyac-apo. Roma re tz'um tzia'k chic man chic nuyuk-ta-ri', mare' vo xa niyac vino chupan re tz'um re' nurokch'ij-ri' y nitix-a re vino c'o chupan. Y re tz'um re' manak chic ndoc-va. Pero chupan jun c'ac'a tz'um, otz niya' c'ac'a vino chin niyac-apo, roma re tz'um re' nuyuk-ri' y man nurokch'ij-ta-ri'. Ja quire' nubij re ejemplo re xubij re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chupan jun k'ij chin uxlanen, re Jesús y re ru-discípulos xe'k'ax chupan jun ulef ticon trigo chach. Y re discípulos c'o c'a rue' trigo re ye'quich'upula-a chin niquitaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Pero re achi'a' fariseos xquibij cha re Jesús: Ca'tz'eta' la a-discípulos, roma man otz-ta ye'tajin chubanic. ¿Anchique roma ye'quich'upula' rue' trigo re k'ij re'? Re k'ij re' chin uxlanen y man ruc'amon-ta che ye'samaj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero re Jesús xubij chique: Yex ibanon leer re tz'iban can chij re xquiban re David y re ruchibil ajuer can tak camas xch'umun quipan. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Re David xba chucanoxic vay chire' pa rachoch re Dios. Y re namalaj sacerdote chupan re tiempo re' ja re Abiatar. Y can ja re lok'olaj tak xcana-vay re xe'beya-pa cha. Y re xcana-vay re' man xe-ta re David xtijo richin, xa can xuya' chuka' chique re je'binak riq'uin. Pero astapa' reje' quire' xquiban, manak quimac xel chach re Dios. Y re xcana-vay re' xaxe re sacerdotes re ye'tijo richin. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y re Jesús xubij chuka' chique: Re k'ij chin uxlanen xban chin jun utzil chique re vinak, y mana-ta re vinak re nibano jun utzil cha re k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yex can ruc'amon che nitamaj che ja yen re xinalax chi'icojol, Rajaf re k'ij chin uxlanen. Pa nuk'a' yen c'o-va chin nimbij andex otz che niban chupan re k'ij re', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y re Jesús y re ru-discípulos xe'bapon chic pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y chiquicojol re vinak re quimalon-qui' chire', c'o c'a jun ache chake'j jun ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero jec'o re ye'tz'eto chin re Jesús, vo xa nuc'achojsaj-a re ache, chin quire' niquisujuj che re Jesús xsamaj chupan re jun k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Man riq'uin re' re Jesús xubij cha re ache chake'j ruk'a': Catak'ax-pa vova' pa nic'aj, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xpa re Jesús xubij chique re vinak re jec'o chire', che chupan jun k'ij chin uxlanen ja re utzulaj tak banabal re más ruc'amon che niban y mana-ta re itzel tak banabal. Y chuka' re más ruc'amon ja che nacol jun vinak chach re camic y man naya-ta k'ij cha che nicom, xcha' chique. Pero conojel man jun tzij xquibij. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","C'are' re Jesús xe'rutzu' conojel re quimalon-qui' chire', y xe'rutz'at che xa quicoversan re cánma y man niquijo-ta niquinimaj. Mare' reja' camas xbison y itzel chuka' xuna'. C'are' reja' xubij cha re ache chake'j ruk'a': Tayuku' la ak'a'. Y re ache can xe xuyuk re ruk'a', can jare' xc'achoj. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y re achi'a' fariseos can xe xquitz'at re', can jare' xbequimola-qui' quiq'uin re ruvinak re Rey Herodes, chin niquinojij andex niquiban, roma niquijo' niquiquimisaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y re Jesús xba chuchi' re lago, y chibil re ru-discípulos. Re Jesús can xtzekelbes coma je q'uiy vinak re jec'o pa tak tenemit chin re Galilea, y coma chuka' re vinak re jec'o pa tak tenemit chin re Judea. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Reja' can xtzekelbes coma re vinak re xe'pa pa tenemit Jerusalén. Jec'o re xe'pa pan Idumea, jec'o chuka' xe'pa c'a juc'an chic-apo ruchi' re rakan-ya' Jordán. Xtzekelbes chuka' coma re vinak re xe'pa pa Tiro y Sidón y re xe'pa chuka' chiquinakaj re ca'e' tenemit re'. Can conojel re vinak re xe'beka riq'uin re Jesús, xe'pa roma quic'axam-pa re milagros re ye'rubanala' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y roma can je q'uiy vinak re ye'beka riq'uin, re Jesús xubij chique re ru-discípulos che tiquibana' listo jun canoa nakaj-oc, che vo xa re vinak camas niquipitz', reja' ndoc chupan re canoa re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Re Jesús can je q'uiy re je'ruc'achojsan chic. Pero roma can conojel re je yava'i' niquijo' chuka' che ye'c'achojsas roma re Jesús, mare' can ye'vich'o-qui' chij re Jesús chin niquitz'am-apo re rutziak, chin quire' ye'c'achoj cha re quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y re itzel tak espíritu tak niquitz'at re Jesús, niquixucubala-qui' chach y jun pa quichi' niquibij: Ja rat re Ruc'ajol re Dios, ye'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero re Jesús nubila' chique: Man titzijoj che ja yen re Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Re Jesús xjote' c'a-a pa rue' re loma y xe'rayoj je q'uiy achi'a'. Y can ja reja' mismo re xvayon quichin, y re achi'a' re' can xe'ba riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Je doce re xe'rucha' chin ye'oc ruchibil y chin che ye'rutak-a chuka' chutzijosic re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y can xuya-a chuka' poder chique chin ye'tiquir ye'quic'achojsala' yava'i', y che ye'quilesala' itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Re je doce apóstoles re xe'rucha' re Jesús, ja re Simón re xubij chuka' Pedro cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Re Jacobo y re Juan, re je ruc'ajol re Zebedeo, re xubij chuka' Boanerges chique; be'aj re ndel che tzij che cha'nin nipa quiyoval. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Re Andrés, re Felipe, re Bartolomé, re Mateo, re Tomás, y chuka' re Jacobo re ruc'ajol re Alfeo, y chuka' re Tadeo, y re jun Simón re c'o quiq'uin re achi'a' re je richin re jun partido re nibex cananista chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Y re Judas Iscariote re xjacho chin re Jesús. Y c'are' re Jesús y re ru-discípulos xe'ba pa jun jay. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Pero roma camas je q'uiy vinak re xquimol chic-apo-qui' jun bey chiquij re Jesús y re ru-discípulos, can man ye'tiquir-ta ye'va'. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y re ruch'alal re Jesús xquinabej-pa. Y xe'bapon chin ne'quic'ama-pa, roma reje' xquinojij che re Jesús xch'ujer. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas re je'pitinak pa tenemit Jerusalén, jec'o-apo re anche' c'o-va re Jesús. Y niquitzojola' chiquivach che re Jesús c'o re Beelzebú riq'uin, re quijoval re itzel tak espíritu. Y ja re Beelzebú re niyi'o poder cha, chin quire' nitiquir ye'rulisaj re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y mare' re Jesús xe'rayoj che xtzijon quiq'uin, y riq'uin ejemplos xch'o-va chique. Reja' xubij: Re Satanás man jun bey nuban che ja reja' mismo re nilisan-a quichin re rusamajela'. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Roma vo xa re vinak chin jun nación man niquinojij-ta y ca'e' quivach niquiban, nipa ayoval chiquicojol. Y re' man otz-ta, roma nuban cha re nación che nitzak. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y quire' chuka' pa jun jay, vo xa c'o ayoval chiquicojol y man junan-ta quivach, can xque'q'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y mare' re Satanás man jun bey nuban-ka ayoval quiq'uin re rusamajela'. Man otz-ta che chij reja' mismo niyacataj-va re ayoval. Roma vo xa quire' nuban, rion nic'ue' can y cha'nin niq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Quire' chuka' re nrajo' nelak'-a pa rachoch jun ache re camas ruchuk'a', nabey nuxim ruk'a-rakan re ache, y c'are' nitiquir nucanoj-a ronojel re nrajo' ye'ruc'uaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Y tic'axaj jabal re ch'abal re xtimbij chiva vocame, che ronojel re mac re ye'quibanala' re vinak re je'alaxnak chach re ruch'ulef, y ronojel re itzel tak tzij re ye'quibila' re vinak chin niquiyok' rube' re Dios, xa can ye'cuyutaj-va re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero re vinak re niyok'o chin re Espíritu Santo, can man xticuyutaj-ta rumac, xa can xtukalej re rumac chin nojel tiempo. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Re Jesús xubij quire' chique re achi'a' je'atamayon re ley kachin yoj re yoj israelitas, roma reje' niquibij chij re Jesús che c'o itzel espíritu riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y re rute' y re je ruch'alal re Jesús xe'pa anche' c'o-va reja'. Pero man xe'oc-ta-apo riq'uin. Xaxe xquitak rubixic cha che niquijo' ye'ch'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y re vinak re je'tz'uyul-apo riq'uin re Jesús xquibij cha: Re ate' y re je avch'alal yatquiyaben chach-jay, y niquijo' ye'ch'o aviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero re Jesús xubij chique re vinak re quimalon-qui' riq'uin: ¿Anchique c'a re nte' y re je vach'alal ninojij yex? ");
INSERT INTO cakYNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y re Jesús xe'rutzu' conojel re je'tz'uyul-apo riq'uin y xubij chique: Ja reje' re je'aconak nte' y je'aconak vach'alal. ");
INSERT INTO cakYNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Roma can conojel re ye'bano re nrajo' re Dios, jare' re ye'oc nte', vana' y nchak', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Re Jesús y re ru-discípulos xe'ba chic chuchi' re lago y reja' ye'rutijoj re vinak riq'uin re ruch'abal re Dios. Y camas je q'uiy vinak re xquimol-apo-qui' chin niquic'axaj. Mare' re Jesús xoc-apo pa jun canoa chire' pa rue-ya', y xtz'uye-ka chupan. Y chire' pan ulef chuchi-apo re ya', jec'o re vinak niquic'axaj-apo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Reja' q'uiy cosas xuc'ut chiquivach riq'uin ejemplos. Reja' xubij chique: ");
INSERT INTO cakYNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tic'axaj jabal re xtimbij chiva: C'o c'a jun ache xbo'rjopij semilla pa jun juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y tak re ache ntajin chic chubanic re samaj re', c'o nic'aj cha re semilla xka po bey. Y xe'pa re ch'utak chicop c'o quixic' re ye'ba pa cak'ik' xquitaj-a re semilla xka po bey. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Y nic'aj chic cha re semilla xa cojol tak aboj xka-va y chire' man pim-ta re ulef, y cha'nin xe'tz'uc-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xa jac'a tak xpa rach k'ij, xe'bayoba-ka y xe'chakij-ka. Roma xa man naj-ta binak-ka quixe' pan ulef, mare' cha'nin xe'chakij-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y nic'aj chic xka cojol tak k'ayis c'o quiq'uixal. Y tak xe'tz'uc-pa, junan xe'q'uiy quiq'uin re q'uix. Pero re q'uix camas xe'q'uiy, mare' re tico'n xe'jik' pa quik'a' y man xe'vachin-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Y re nic'aj chic semilla xka pa jun utzulaj ulef, xe'tz'uc-pa y jabal xe'q'uiy. Y c'o semilla xquiyala' a treinta quivach, c'o xquiyala' a sesenta y c'o xquiyala' ja'jun ciento. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","C'are' re Jesús xubij: Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y tak xcanaj can rion re Jesús quiq'uin ca'e-oxe' vinak y re je doce ru-discípulos, re jec'o riq'uin xquic'utuj cha andex nrajo' nubij chique riq'uin re ejemplo re xutzijoj chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y reja' xubij chique: Man jun bey can-ta bin can jabal chij tak re vinak ye'oc pa ruk'a' re Dios, pero chiva yex yi'on c'a k'ij che nitamaj. Jac'a chique re vinak re man yinquiniman-ta, riq'uin ejemplos yinch'o-va chiquivach, ");
INSERT INTO cakYNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","chin quire' choj niquitzu' y man niquitz'at-ta jabal re niquitzu', y chin che choj niquic'axaj y man nak'ax-ta pa quive' re niquic'axaj, chin quire' man nijalataj-ta quic'aslen chach re Dios y chuka' man nicuyutaj-ta quimac roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y re Jesús xubij chic jun bey chique re ca'e-oxe' vinak y re ru-discípulos: ¿Man xk'ax-ta pan ive' re ejemplo re c'a ba-oc timbij-va-ka chiva? Roma vo xa man xk'ax-ta pan ive', c'alapa' re nic'aj chic ejemplos xtak'ax-ta pan ive'. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Riq'uin re jun ejemplo re' ninc'ut che re xbejopin re semilla, jac'a ancha'l re samajel re nitzijon re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Re semilla re xe'ka po bey, ancha'l re vinak tak quic'axan chic re ruch'abal re Dios, y re Satanás jonanin napon quiq'uin y nulisaj-a re ch'abal re' pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Re semilla re xe'ka cojol tak aboj, can nich'o-va chij re ruch'abal re Dios re nic'axax coma re vinak. Re vinak re' camas ye'qui'cot tak niquic'ul re ruch'abal re Dios pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero como man nuc'am-ta-ka ruxe' re ruch'abal re Dios pa tak cánma, mare' man q'uiy-ta tiempo re ye'qui'cot, xa jun ca'e-oxe-oc k'ij re otz ye'c'ue' riq'uin re Dios. Y tak nipa re tijoj-pokonal chiquij y ye'tzelas roma quiniman re ruch'abal re Dios, cha'nin ye'tzak. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y re semilla re xe'ka cojol tak q'uix, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero como re vinak re' xa ja re ndoc cha re quic'aslen vova' chuch'ulef re niba cánma chij, mare' ne'jik' re ruch'abal re Dios re c'o pa tak cánma. Ne'jik' pa ruk'a' re biyomal re ancha'l xa c'o otz nuc'am-pa y xa man quire-ta. Y q'uiy chuka' rach rayibal ye'pa quiq'uin, mare' re vinak re' man jun bey xtivachin jabal re ruch'abal re Dios pa tak quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Jac'a re semilla re xe'ka pa jun utzulaj ulef, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak, y re vinak re' can niquic'ul-va re ruch'abal re Dios pa tak cánma y re quic'aslen jabal nivachin. Can ye'vachin ancha'l niquiban re semilla. Roma jec'o semilla niquiya' a treinta quivach, jec'o niquiya' a sesenta y jec'o niquiya' ja'jun ciento. Can quire' nuban re quic'aslen re vinak re niquic'ul re ruch'abal re Dios pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y re Jesús xubij chuka' chique: Tak nic'am-pa jun lámpara chin nusekresaj pa jay, man chuxe-ta jun cajón o jun ch'at niya-va-apo. Roma re lámpara can c'o ruc'ojlebal re anche' nitzekebas-va, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Y quire' chuka' man jun cosa re vovan can, re man-ta xtik'alajim-pa. Y chuka' man jun cosa re tz'apin can rij, re man-ta xtel-pa pa sakil. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y re Jesús xubij chuka' chique re vinak: Tak yex nic'axaj re ruch'abal re Dios, can tic'axaj jabal re nubij. Can tika c'a-ka pa tak ivánma, roma xa can ancha'l re nic'axaj xa can quire' chuka' re na'oj re nic'am can y riq'uin chic ba' rutz'akat. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Roma re c'o cosas ruyacon pa ránma, can xtuc'ul más. Jac'a re nic'axan re ruch'abal re Dios y xa man nuyac-ta-ka pa ránma, hasta re ba' re c'o riq'uin, xtilisas-a chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y re Jesús xubij chuka': Tak re vinak ye'oc pa ruk'a' re Dios, nibanataj ancha'l nibanataj riq'uin jun semilla re nitic can pan ulef roma jun ache. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Y tak re semilla c'o chic can pan ulef, re ache man jun chic nuban. Reja' nivar tak ndoc-pa re ak'a' y niyacataj-a tak nisakar-pa re ruca'n k'ij. Y tak napon re k'ij, re semilla nitz'uc-pa y niq'uiy-a, pero re xtico-ka chin re semilla man rutaman-ta, y chuka' man nitiquir-ta nubij andex nuban re semilla tak nitz'uc-pa y andex nuban tak niq'uiy. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Re nitico-ka re semilla man jun nuban chin che re tico'n niq'uiy-pa; roma re tico'n xa rion niq'uiy-pa. Y re ulef q'uiy c'a re nuya-pa. Pero nabey ja re ral re trigo niq'uiy-pa. Y tak nem chic, ye'el-pa re rue'. Y pa ruq'uisibal ne'noj-pa re rue' riq'uin re rupan. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y tak k'an chic, re rajaf can jare' ye'rutak re ru-mozos chupan, chin niquik'at, roma ja tiempo chin re cosecha xbeka. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y chuka' re Jesús xubij: ¿Andex como rubixic xtakabij chij ru-gobierno re Dios? ¿Anchok riq'uin como xtakajonomaj-va? Y chin che nakajonomaj nakacusaj re jun ejemplo re', y ja quire' nubij, ");
INSERT INTO cakYNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","che re ru-gobierno re Dios junan riq'uin re semilla chin re mostaza re nitic-ka pan ulef, roma astapa' re semilla chin re mostaza xa jare' re semilla más co'ol-oc re c'o chach re ruch'ulef, ");
INSERT INTO cakYNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero xa jare' re más nem ndel chiquivach re nic'aj chic k'ayis y ye'c'ue' ruk'a' chovomak. Mare' re chicop c'o quixic' re ye'ba pa cak'ik' niquibanala' quisoc pa tak ruk'a', roma chire' jabal ye'mujan. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Re Jesús tak xutzijoj re ruch'abal re Dios chiquivach re vinak, xe'rucusaj ejemplos roma rutaman che riq'uin re' c'o xtiquitamaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Reja' xaxe riq'uin ejemplos xch'o chiquivach re vinak. Pero tak ye'c'ue' can quion, re Jesús can nubij chique re ru-discípulos andex ye'el-va che tzij re ejemplos re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y tak xoc-pa re ak'a' chupan re k'ij re', re Jesús xubij chique re ru-discípulos: Jo' c'a juc'an-apo ruchi' re lago, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Reja' can xe'rutakala' can re vinak. Pero roma reja' tz'uyul chire' chupan re canoa, can jare' xquitz'am-a bey pa rue-ya'. Y jec'o chuka' nic'aj chic canoas re junan xe'el-a quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y tak quitz'amon bey, xpa jun cak'ik' camas ruchuk'a' chire' pa rue-ya'. Y mare' re canoa re anche' je'binak-va ninoj-pa che ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero re Jesús nivar chupan re canoa tak ntajin re cak'ik' pa rue-ya'. Reja' chij can re canoa rucanon-va-ka jun ch'acat-rue', y chire' nivar-va tak je'binak. Y xe'pa re ru-discípulos xquic'asoj y xquibij cha: ¡Ajaf! ¡Ajaf! Yoj yojcom-yan y rat xa yavar, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y re Jesús xyacataj-pa, y xubij: Tak'ax-a re cak'ik' y titane-ka re nubolk'otela-ri' re ya'. Y ja quire' xbanataj. Re cak'ik' xq'uis-a, y chuka' re nubolk'otela-ri' re ya' xtane-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'are' re Jesús xubij chique re ru-discípulos: ¿Anchique roma tak xixibij-ivi'? ¿Can man ibanon-ta confiar-ivi' viq'uin? ");
INSERT INTO cakYNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero re discípulos camas quixibin-qui' y xquic'utula' chiquivach chij re Jesús: ¿Anchique como che ache re'? Roma re cak'ik' y re ya' can niquinimaj rutzij. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y re Jesús y re ru-discípulos xe'bapon juc'an-apo ruchi' re lago, chire' chupan jun lugar rubini'an Gadara. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y tak re Jesús xka can chupan re canoa, can jare' tak xapon jun ache riq'uin, re ache re' elinak-pa anche' je'mukun-va re anama'i' roma c'o itzel espíritu riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Re ache re' ja re anche' je'mukun-va re anama'i' re aconak rachoch, y reja' hasta riq'uin cadena man je'tiquirnak-ta quitz'amon, roma camas ruchuk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Can q'uiy c'a bey quiximon ruk'a-rakan che cadena, pero xa je'ruk'ajlon y je'rurokch'in can. Can man jun tiquirnak chij. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Reja' nojel tiempo nibiyaj pa tak k'ayis y chiquicojol re anche' je'mukun-va anama'i', nurakala' ruchi' y nusocola-ri' riq'uin aboj. Can che pak'ij che chak'a' nubanala' quire' re ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y tak reja' xutz'at-pa re Jesús, c'ac'anaj c'a c'o-va, pero re ache re' jonanin xpa y xbexuque' chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y jun pa ruchi' xch'o cha re Jesús y xubij: Rat Jesús re Ruc'ajol re namalaj Dios, ¿anchique roma tak yinanak? Pa rube' re Dios ninc'utuj chava, che man quinach'ujersaj, xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Re ache xubij quire' roma re Jesús rubin chic cha re itzel espíritu re c'o riq'uin, che tel-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y xpa re Jesús xuc'utuj cha: ¿Andex abe'? Y reja' xubij-pa: Legión, jare' re nube', roma man nayon-ta yen, xa can je q'uiy chuka' re vichibil jec'o. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y camas c'a xuc'utuj utzil cha re Jesús che man que'rulisaj-a chupan re lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y chunakaj-apo re lugar rubini'an Gadara, c'o jun loma y chire' camas je q'uiy ak ye'va'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y xe'pa conojel re itzel tak espíritu re jec'o riq'uin re ache, xquic'utuj utzil cha re Jesús. Y xquibij cha: Taya' k'ij chaka che yoje'oc chiquipan la ak jec'o chila-apo. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Re Jesús can jare' xubij chique che otz. Y re itzel tak espíritu can jare' xe'el-a riq'uin re ache y xe'be'oc chiquipan re ak. Re ak camas je q'uiy. Jec'o la'k jun ca'e' mil. Y conojel re ak re' xquitz'am anin chach peña, y c'a chupan re lago xe'beka-va. Y conojel re ak re' xe'jik' y xe'com pa ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Jac'a re ye'chajin quichin re ak re', xe xquitz'at can re xbanataj, xe'numaj y xbequiyala' can rutzijol re pa tenemit y chuka' pa tak juyu'. Y re vinak can xe'pa chin ne'quitz'eta' re xbebex can chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y tak re vinak re' xe'beka riq'uin re Jesús, xquitz'at che re ache re xe'c'ue' itzel tak espíritu riq'uin, tz'uyul, rucusan rutziak y man nuban-ta chic re ancha'l rubanom-pa. Pero re vinak re' xa xquixibij-qui' tak xquitz'at re ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Re vinak re xe'tz'eto re xbanataj riq'uin re ache re xlisas itzel tak espíritu riq'uin y re xbanataj quiq'uin re ak, xquitzojola' chique re vinak re je'pitinak chutz'etic re xbanataj chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mare' re vinak xquibij cha re Jesús: Tabana' utzil catel-a chupan re ka-lugar. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y jac'a tak ndoc-a re Jesús pa canoa, re ache re xe'c'ue' itzel tak espíritu riq'uin, xuc'utuj utzil cha re Jesús che tuya' k'ij cha chin niba riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero re Jesús man xrajo-ta. Xa xubij cha: Catzolaj cha'vachoch, y tatzijoj chique re avch'alal che xe'lisas re itzel tak espíritu aviq'uin, roma xjoyovax avach roma re Ajaf Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y re ache xba y xutz'am rutzijosic re xuban re Jesús riq'uin reja'. Reja' xutzijoj chique re vinak re jec'o chupan re lugar rubini'an Decápolis. Y re vinak camas niquinojela' chij ruc'aslen re jun ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y re Jesús y re ru-discípulos xe'oc chic-a pa canoa chin xe'k'ax c'a juc'an chic ruchi' re lago. Y tak xe'bapon la juc'an chic ruchi-lago, camas je q'uiy vinak re xquimol-apo-qui' riq'uin. Reja' chunakaj c'a re lago xc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xapon chuka' jun ache rubini'an Jairo. Re ache re' c'o jun rusamaj chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Jac'a reja' re c'o más ruk'ij chire'. Y tak re Jairo xutz'at-apo re Jesús, can jare' xbexuque' chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y c'are' reja' xubij cha re Jesús: Re numi'al niyavaj, y nicom-yan. Tabana' utzil ta'ya' re ak'a' pa rue' chin nicolotaj chach re camic y nic'ase' can, xcha' re ache. Y re ache re' camas xuc'utuj utzil cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y re Jesús xba chij. Y je q'uiy chuka' vinak xe'tzake-a chiquij. Y roma camas je q'uiy vinak, can man otz-ta ye'biyin. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y chiquicojol re vinak re' binak chuka' jun ixok re c'o jun ruyabil. Re ixok re' doce juna' re nibiyin ruq'uiq'uel y man tanal-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Reja' rutijon pokan roma binak chic quiq'uin q'uiy doctores y xuq'uis-yan chuka' ronojel ru-mero, chin che nic'achoj-ta, pero re ruyabil xa más niyori'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Re ixok re' c'o c'a ruc'axam-pa chij re Jesús. Reja' binak chuka' chiquicojol re vinak re jec'o can chij re Jesús, y jare' tak xbo'rtz'ama' can ba' rutziak re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Roma re ixok re' can rubim-pa pa ránma che xa riq'uin xquintiquir xte'ntz'ama' can ba' rutziak re Jesús, can yinc'achoj, cha'inak pa ránma re ixok re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y can jare' xtane' re nibiyin ruq'uiq'uel. Reja' can xuna' che xc'achoj cha re ruyabil re ruc'alvachin. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Re Jesús cha'nin c'a xuna' che c'o jun xuc'achojsaj riq'uin re poder c'o riq'uin. Mare' xtzu'un can chij y xubij chique re vinak: ¿Anchique xtz'amo re nutziak? xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pero re discípulos xquibij cha: Rat najo' natamaj anchique xtz'amo re atziak, pero re vova' c'ayef chin natamaj. Ya'tz'at che re vinak yatquipitz' y rat nac'utuj: ¿Anchique re xintz'amo? xe'cha' re discípulos cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero re Jesús ye'rutzula' re vinak, nucanoj re anchique xtz'amo re rutziak. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y re ixok ruxibin-ri' y nibarbot, roma xa ja reja' re xtz'amo re rutziak re Jesús pan eval, y can xc'achoj-va cha re ruyabil. C'are' reja' xuque' chach re Jesús y xubij nojel re andex xuban. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y re Jesús xubij cha re ixok: Numi'al, xac'achoj, roma xaban confiar-avi' viq'uin. Vocame, catzolaj y ca'texulan, roma jumul xac'achoj cha re ayabil ac'alvachim-pa, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y c'a nitzijon re Jesús riq'uin re ixok, tak jec'o re xe'beka re je'pitinak charachoch re Jairo, re ache re c'o ruk'ij chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Re achi'a' re xe'beka xbequibij cha re Jairo: Re ami'al xa xcom-yan. Manak chic tuk'aj nac'uaj-a re Maestro Jesús, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jac'a tak re Jesús xuc'axaj-pa, cha'nin xubij cha re Jairo: Man tuxibij-ri' re avánma roma re xbebex chava. Tabana' confiar-avi' viq'uin, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y re Jesús xaxe re Pedro, re Jacobo y re Juan re ruch'alal re Jacobo, re xe'ruc'uaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y re Jesús je ruchibil-a re je oxe' ru-discípulos xe'ba charachoch re Jairo. Y tak xe'bapon, re Jesús xe'rutz'at che re vinak can je'elinak ch'o'j pa jay, y xe'rutz'at chuka' che can nibiyin ruyi'al-quivach y can ye'siq'uin che ok'ej. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tak re Jesús aconak chic-apo, xubij chique re vinak: ¿Anchique roma yixok' y can yixelinak ch'o'j? Re ac'ual xa man quiminak-ta, reja' xa nivar, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero reje' xa xe'tze'en chij re Jesús, roma quitaman che re ac'ual xa quiminak chic. Pero re Jesús xubij chique re vinak che que'el-a. C'are' reja' xe'rucusaj-apo re rute-rutota' re xtan y re je oxe' chic re je'binak chij, chupan re jay re anche' c'o-va re ru-cuerpo re xtan. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Reja' xutz'am ruk'a' re quiminak y xch'o pa kach'abal yoj re yoj israelitas, y xubij: Talita, cumi. Re ch'abal re' ndel che tzij: Xta, chava rat nimbij-va che cayacataj. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Can xe xubij quire' re Jesús, can jare' xyacataj y xbiyin-a re xtan, roma can doce chic rujuna'. Y re jec'o riq'uin, xsatz quic'o'x tak xquitz'at che xyacataj-a y xbiyin-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero re Jesús camas xuchalabej chique che man tiquitzijoj chique re vinak, y chuka' xubij che tiquisuju' ruay. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Re Jesús y re ru-discípulos xe'el-a chire' y xe'ba pa Nazaret, re tenemit re anche' xq'uiy-va reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y tak xapon re k'ij chin uxlanen, reja' xuc'ut re ruch'abal re Dios chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y roma re ch'abal re ye'rubij chique, re vinak re quimalon-qui' chire', can anchique-la xquic'axaj, y xquibila': ¿Anchique roma tak re ache re' camas na'oj c'o riq'uin y nitiquir ye'ruban milagros? ¿Ancha'l tak nitiquir nuban ronojel re'? ");
INSERT INTO cakYNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Roma re ache re' xa carpintero, ral re María, quich'alal re Jacobo, re José, re Judas y re Simón. Y re je rana' xa chakacojol yoj jec'o-va, xe'cha'. Mare' re vinak can man ba' xquinimaj re Jesús, roma reja' aj-chire' pa quitenemit. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y re Jesús xubij chique re vinak re': Conojel re rusamajela' re Dios re nibex profetas chique, man jun quik'ij, pero re' xaxe chiquivach re vinak re jec'o pa rutenemit, chiquivach re ruch'alal y chiquivach chuka' re ru-familia, roma chiquivach re nic'aj chic vinak c'o quik'ij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y chupan re rutenemit, re Jesús man q'uiy-ta milagros xuban roma re ruvinak cama-va xquinimaj-ta. Xaxe-oc ca'e-oxe' yava'i' re xuya' ruk'a' pa quive' chin xe'ruc'achojsaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y reja' can anchique-la xuna' roma xe'rutz'at che re vinak chire' pa rutenemit, xa can man xquiban-ta confiar-qui' riq'uin. Reja' xba c'a pa tak cocoj tenemit re jec'o chunakaj re rutenemit. Reja' can xuc'ut re ruch'abal re Dios chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","C'are' re Jesús xe'rayoj re je doce ru-discípulos. Y che ca'ca' che ca'ca' xutz'am-a quitakic chubanic re samaj, y xuya-a poder chique chin ye'tiquir ye'quilisaj re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y reja' xubij-a chuka' chique che xaxe re quich'ama'y tiquic'uaj-a y man tiquic'uaj-a jun chic cosa. Man tiquic'uaj-a quiya'l, man tiquic'uaj-a vay y chuka' man tiquic'uaj-a mero pa tak ximibal-quipan. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man tiquicusaj-a ca'e' quitziak. Pero re quixajab otz che niquicusaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Re Jesús xubij-a chuka' chique: Xabanchique tenemit yixapon-va, tak yixoc pa jun jay, chire' quixc'ue-va-ka. Xa c'aja tak yixel-pa chire', otz niya' can re jay re anche' xixc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y vo xa re anche' yixapon-va, re vinak man otz-ta ic'ulic niquiban y man niquijo-ta chuka' niquic'axaj re ruch'abal re Dios re nitzijoj yex chique, quixel-pa chire'. Y titavaj can re pokolaj re c'o pa tak ivakan chiquivach re vinak re', chin tiquitamaj che man otz-ta re xquiban chiva. Roma yen can katzij nimbij chiva, che chupan re k'ij tak xtibanataj re juicio, re vinak re xe'c'ue' pa tenemit Sodoma y Gomorra, man can-ta xtak'ax rue' re castigo xtika pa quive' que chach re xtika pa quive' re vinak chin re tenemit re man otz-ta ic'ulic xtiquiban, xcha-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y re discípulos xe'ba. Reje' xquibij chique re vinak che tijalataj quic'aslen chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Y re discípulos q'uiy itzel tak espíritu re xe'quilesala'. Y chuka' xquiyala' aceite olivo pa quive' je q'uiy yava'i' y xe'quic'achojsala' can. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Y re Rey Herodes xuc'axaj che re Jesús camas elinak rutzijol chiquicojol re vinak. Pero re Herodes xubij-ka pa ránma che re Jesús xa ja re Juan Bautista re xc'astaj-pa chiquicojol re anama'i', y mare' tak c'o poder pa ruk'a' chin q'uiy milagros nitiquir ye'rubanala', xcha-ka reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero jec'o nic'aj chic chique re vinak re xquibij che re Jesús xa ja re Elías. Y jec'o nic'aj chic xquibij che reja' jun profeta, re ancha'l re profetas re xe'c'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero tak re Rey Herodes xuc'axaj re', xubij: Re Jesús xa ja re Juan Bautista re xintak rutzaq'uisic rujalom, y vocame xc'astaj-pa chiquicojol re anama'i', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Roma ja re Rey Herodes re xbin che tiquitz'ama-pa re Juan. C'are' xuya' pa cárcel y xuxim che cadena. Re Herodes quire' xuban roma re ixok rubini'an Herodías re c'o riq'uin, xa ruxayil re Felipe re ruch'alal re Herodes. Y re Herodes can quic'uan-va-qui' riq'uin re Herodías. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Re Juan xtz'am roma rubin cha re Herodes: Man otz-ta abanon roma aconak-ka avxayil re Herodías re ruxayil re avch'alal rubini'an Felipe. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Re Herodías can rujovan-va c'a ruquimisan re Juan roma itzel nuna' cha, pero man pa ruk'a-ta reja' c'o-va, mare' man tiquirnak-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Re Rey Herodes can rutaman che re Juan jun lok'olaj ache y choj ruc'aslen chach re Dios, y nuxibij-ri' chach. Can man ruyi'on-ta k'ij chin che c'o-ta cosas ruc'alvachin. Reja' can jabal nuc'axaj tak re Juan nubij re ruch'abal re Dios cha. Pero reja' man ninojitaj-ta chach re andex ruc'amon che nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Y xapon re k'ij re yaben roma re Herodías chin nika re Juan pa ruk'a'. Chupan re k'ij tak re Rey Herodes xtz'akater chic jun rujuna', xe'rayoj conojel re ye'bano gobernar re jec'o pa ruk'a', xe'rayoj re je ec'uay quichin re soldados y xe'rayoj chuka' re achi'a' re c'o más quik'ij chiquicojol re aj-Galilea, chin jun va'in. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y re anche' quimalon-va-qui' reje', xoc-apo jun xtan ral re Herodías, y reja' xajo' chiquivach. Y re xajoj xuban re xtan camas xka chach re Rey Herodes y chiquivach conojel re ye'va' riq'uin. Y re Rey Herodes xubij cha re xtan: Tac'utuj re andex xtajo' y xtinya' chava. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Can nimban jurar chavach, che xabandex re xtac'utuj chua, xtinya' chava, astapa' pa nic'aj cha re lugar re anche' nimban-va gobernar re xtac'utuj, can xtinya' chava, xcha' re Rey Herodes cha re ral re Herodías. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pero re xtan, xe xuc'axaj re xubij re Rey Herodes, xel-a y xbo'rbij cha re rute': ¿Andex como ninc'utuj cha re Rey Herodes? Roma reja' xubij chua che xabandex re xtajo', can xtuya' chua, xcha' re xtan cha re rute'. Xpa re te'ej xubij cha re ral: Tac'utuj che tiquimisas re Juan Bautista y tiya-pa re rujalom chava. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y re xtan can jare' xtzolaj-apo riq'uin re Rey Herodes y xbo'rbij cha: Yen ninjo' che vocame-yan naya-pa chua chach jun plato, re rujalom re Juan Bautista, xcha' cha re Rey Herodes. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y re Rey Herodes camas xbison-ka pa ránma roma re', pero roma can rubanon chic jurar cha che can xtuya-va re andex nrajo' y roma chuka' can chiquivach re jec'o riq'uin chach mesa xubij-va, tiene que nuban re nic'utux cha, chin man nuya-ta ruq'uex. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y re Rey jare' tak xutak-a jun soldado chin tic'am-pa re rujalom re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y re soldado xba. Reja' xbo'rtzaq'uij-pa rujalom re Juan Bautista chire' pa cárcel. Y c'are' re rujalom re Juan xuc'am-pa cha re xtan chach jun plato y re xtan xbo'rya' cha re rute'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tak re ye'tzekelben chin re Juan xquic'axaj che xquimisas, xe'ba chuc'amic re ru-cuerpo, y xbequimuku' can. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","C'are' re ru-apóstoles re Jesús xe'tzolaj-pa banoy rusamaj re Dios y xquimol-apo-qui' riq'uin re Jesús. Reje' niquibila' cha ronojel re xquibanala' y re xquic'ut chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y re Jesús xubij chique: Jo' pa jun lugar re anche' je manak vinak chin che yoje'xulan ba'. Y quire' xubij chique roma re vinak ye'el-ye'oc quiq'uin y mare' hasta man ye'tiquir-ta chic ye'va'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y re Jesús y re ru-apóstoles xe'oc-a pa jun canoa chin che ye'k'ax juc'an chic-apo ruchi-ya', pa jun lugar re anche' manak vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero tak reje' xe'el-a, je q'uiy vinak re xe'tz'eto-a quichin y xquitamaj-a quivach. Mare' re vinak jonanin xe'ba chacakan, xquimol-a-qui' po bey, re pa tak tenemit re anche' xe'k'ax-va. Y xa ja-yan chic reje' re xe'bapon nabey. Y tak re Jesús y re ru-discípulos xe'bapon, re vinak xquimol-apo-qui' chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y tak re Jesús xka can chupan re canoa, xutz'at che camas je q'uiy vinak re je'yabeyon richin chire'. Reja' xujoyovaj quivach, roma re quibanon, can ancha'l re ovejas tak man jun nichajin quichin. C'are' q'uiy cosas re xuc'ut chiquivach re nic'atzin che niquitamaj chij re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pero tak xk'ak'ij-yan-ka, re ru-discípulos re Jesús xe'jelon-apo riq'uin y xquibij cha: Re vova' xa je manak vinak y xk'ak'ij-yan-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ca'taka-a re vinak re' chin che ye'ba pa tak cocoj tenemit y pa tak nic'aj chic lugar re jec'o nakaj, chin te'quilok'o' quivay chire', roma manak quivay chin niquitaj, xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jac'a re Jesús xubij chique re ru-discípulos: Tiya' quivay yex, xcha' chique. Y reje' xquibij cha: Rat nabij che takaya' quivay yoj, pero manak modo roma nrajo' che nakalok' ála ca'e' ciento denarios vay chin ye'va' conojel, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y reja' xuc'utuj chique: ¿Jenipa' vay c'o iviq'uin? Titz'eta-na c'a. Y tak reje' quitz'eton chic, xquibij: C'o vo'o' vay y ca'e' car. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","C'are' reja' xubij chique re ru-discípulos che tiquibij chique re vinak che que'tz'uye' conojel pa rue' re sabana, y pa tak grupos tiquic'uala-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y re vinak re' can xe'tz'uye' pa rue' re sabana, y xquic'uala-qui' pa tak ciento y nic'aj tak ciento. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y re Jesús xe'ruli'ej pa ruk'a' re vo'o' vay y re ca'e' car, xtzu'un chicaj y xutioxij cha re Dios. Reja' xe'rupar re vay y xuya-a chique re ru-discípulos chin che niquijachala' chiquivach re vinak. Y quire' chuka' xuban riq'uin re car. Xujach chiquivach conojel. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Can conojel jabal xe'va'. Can man jun re man-ta xva'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y c'a c'o doce chacach re nojnak che vay y car re xuban sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Camas je q'uiy vinak re xe'va', roma xaxe re achi'a' je vo'o' mil. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Y jare' tak re Jesús xubij chique re ru-discípulos che que'oc-a chupan re canoa, chin que'nabayaj-a chach, che que'ba pa Betsaida, re tenemit re c'o juc'an-apo ruchi-ya'. Y reja' c'a ye'ruban-na can despedir re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y tak re Jesús xe'ruban-yan can despedir re vinak, reja' xba pa rue' re loma chubanic orar. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Re Jesús xc'ue-na can pan ulef, pero re discípulos je'binak pa canoa y naj xe'ba-yan-apo pa rue' re lago. Pa runic'ajal chic re lago jec'o-va-apo tak xoc-ka re ak'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y re Jesús xe'rutzu' che re ru-discípulos man choj-ta nibiyin re canoa chiquivach, roma re cak'ik' nupaxij-ri' chach re canoa y nutzolij chij. Y tak nisakar-yam-pa, re Jesús binak charakan pa rue-ya' chin niba-apo quiq'uin y nrajo' nak'ax chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero tak re discípulos xquitz'at che c'o jun pitinak charakan pa rue-ya', xe'siq'uin. Roma reje' xquinojij che re pitinak pa rue-ya' xa jun xibinel. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y roma can conojel xe'tz'eto richin, xsatz quic'o'x. Y mare' re Jesús cha'nin xch'o-apo chique y xubij: Man tixibij-ivi'. Ja yen re Jesús, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y reja' xoc-a quiq'uin pa canoa. Y jare' tak xtane-ka re cak'ik'. Y re discípulos camas c'a xsatz quic'o'x. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Y astapa' can xquitz'at tak re Jesús xuban che xq'uier re vay, reje' man xk'ax-ta pa quive' che reja' can nitiquir-va nuban xabanchique cosa, roma can c'o poder riq'uin. Reje' can c'a quicoversan re cánma. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y reje' xe'k'ax pa rue' re lago re' y xe'bapon chupan re lugar rubini'an Genesaret. Reje' xe'bapon chuchi' re lago y chire' xquiya-va can re qui-canoa. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y xe xe'ka can pa canoa, re vinak re jec'o chire' chuchi-ya', cha'nin xquitamaj rach che ja re Jesús re xka can pa canoa. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mare' xquiyala' rutzijol ronojel lugar re jec'o nakaj, che re Jesús c'o chire'. Y re vinak ye'quic'amala-pa re quiyava'i' chach re qui-camilla, y xe'quic'uaj-apo chach re Jesús re anchique lugar niquic'axaj che c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y xabanchique lugar napon-va, re pa tak nima'k y cocoj tenemit, y chuka' pa tak juyu', re vinak xe'quiyala' re yava'i' pa tak bey re anche' nak'ax-va reja'. Camas c'a utzil niquic'utula' cha chin che tuya' k'ij chique chin niquitz'am astapa' xaxe re ruchi-rutziak. Y conojel re xe'tz'amo ruchi-rutziak re Jesús, xe'c'achoj cha re quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chij re Jesús xquimol-apo-qui' re achi'a' fariseos, y chuka' jun ca'e-oxe' achi'a' re je'atamayon re ley kachin yoj re yoj israelitas re je'pitinak pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y tak re achi'a' re' xe'quitz'at che jec'o chique re ru-discípulos re Jesús re man niquich'aj-ta jabal re quik'a' tak ye'va', man otz-ta xe'quitz'at. Roma chiquivach reje' can man ch'ajch'oj-ta re quik'a'. Y mare' camas xe'ch'o chiquij, roma man niquiban-ta ancha'l re niquiban reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Roma re achi'a' fariseos y conojel re nic'aj chic vinak israelitas, xa ja re je'bilon can coma re kavinak xe'c'ue' ajuer can, xa jare' re ye'quibanala'. Roma vo xa man niquich'aj-ta re quik'a' q'uiy bey, can man ye'va-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tak ye'tzolaj-pa pa tak q'uiybal, vo xa man niquijosk'ij-ta-qui', can man ye'va-ta. Y c'o nic'aj chic cosas re ye'quibanala' chuka', ancha'l re quijosk'esic re kumubal tak ya', re bojo'y, re ch'ich' tak lak y re andex chuka' rujosk'esic niquiban cha re quich'at. Quire' c'a re ye'quibanala' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Mare' xe'pa re achi'a' fariseos y re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas xquic'utuj cha re Jesús: ¿Anchique roma tak la a-discípulos man niquiban-ta ancha'l re bin can coma re kavinak xe'c'ue' ajuer can? Reje' ye'va' y man niquich'aj-ta jabal quik'a'. Man niquiban-ta ancha'l nakaban yoj, xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero re Jesús xubij chique re achi'a' re': Yex xa ca'e' ipalaj. Mare' can jabal rubixic rubanon can chivij re jun rusamajel re Dios re xbex profeta cha, re xc'ue' ajuer can re xubini'aj Isaías. Re xubij re Dios cha che tutz'ibaj can, y ja quire' nubij: Re vinak re' xaxe riq'uin re quichi' niquiya' nuk'ij, pero re cánma xa mana-ta re' re nrajo', xa c'ac'anaj c'o-va re cánma chin che niquiya-ta nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa can man jun nic'atzin-va che niquiya' nuk'ij, roma xa enseñanzas quichin achi'a' niquic'ut y niquibij che can jare' re ruc'amon che niban. Quire' re rutz'iban can re profeta Isaías. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y yex jare' re yixtajin chubanic. Y re ru-mandamiento re Dios xa iyi'on can. Yex can man niban-ta re nrajo' re Dios, xa ja re niquibij re vinak, xa jare' re itz'amon rubanic. Ancha'l tak nibij re andex quijosk'esic re bojo'y y re andex quijosk'esic re kumubal tak ya'. Y jec'o chuka' nic'aj chic re je ancha'l re', re ye'banala'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y re Jesús xubij chuka' chique: Yex niban re andex je'quibilon can re kavinak xe'c'ue' ajuer can, can iyi'on can rubanic re nubij re ru-mandamiento re Dios re otz che niban. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Roma re ch'abal re je'rutz'iban can re Moisés, nubij: Taya' quik'ij re ate-arta'. Y re anchique ye'rutzelaj rute-rutota' camas rumac ndel re quire' nibano, y can ruc'amon che niquimisas. Quire' re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Jac'a yex man quire-ta niban. Xa man niban-ta ancha'l re rubin can re Dios. Yex xa ye'tijoj re vinak che man nic'atzin-ta che ye'quito' re quite-quirta'. Che xa riq'uin niquibij chique re quite-quirta': Yen man yintiquir-ta yixinto' riq'uin re ndoc chiva, roma re c'o viq'uin xa Corbán. Re ch'abal re' ndel che tzij: Nsujun chic cha re Dios. Y xa riq'uin quire' niquibij, che quisujun chic cha re Dios re ndoc chique re quite-quirta', man nic'atzin-ta chic che ye'quito', yixcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riq'uin re nibij, can nik'alajin-va che niban chique re vinak che man chic ye'quito-ta re quite-quirta'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Riq'uin re', yex ibanon che man jun ruk'ij re ru-mandamiento re Dios. Y quire' ibanon xaxe chin niban re andex quibin can re ivinak re xe'c'ue' ajuer can. Y jec'o chuka' nic'aj chic ancha'l re' re ye'banala'. Quire' xubij re Jesús chique re achi'a' fariseos y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Y re Jesús xch'o chic jun bey quiq'uin conojel vinak re quimalon-apo-qui' chire' y xubij chique: Tic'axaj c'a chiyixnojel re xtimbij chiva y tak'ax pan ive'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Roma re cosa re nutaj-ka re vinak, mana-ta re' re nitz'ilbisan richin. Re nitz'ilbisan richin jun vinak xa ja re itzel tak nojebal re nipa pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij. Quire' xubij re Jesús chique re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y reja' xe'ruya' can re vinak, y xba pa jun jay. Y re discípulos xquic'utuj cha chij re nitz'ilbisan chin jun vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y re Jesús xubij chique: Yex can junan ibanon quiq'uin re nic'aj chic vinak che man nak'ax-ta pan ive' re nimbij. Can man k'axnak-ta pan ive' che ronojel re nutaj-ka re vinak, xa mana-ta re' re nitz'ilbisan richin. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ronojel re andex nutaj-ka re vinak, xa man pa ránma-ta nibo-va. Xa chupan nika-va-ka y c'are' ndel-a. Y roma re quire' xubij re Jesús, nik'alajin che ronojel re riquil tak vay jec'o can, can je otz-va chin ye'tij. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y re Jesús xubij chuka' che xa ja re itzel tak nojebal re nipa pa ránma re vinak, xa jare' re nitz'ilbisan richin. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Roma xa pa ránma re vinak ye'po-va re itzel tak nojebal. Chire' nipo-va tak re vinak re je'c'ulan y re man je'c'ulan-ta niquicanola-qui' chin ye'macun. Y chire' chuka' nipo-va tak ye'quimisan. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pa tak cánma c'a re vinak nipo-va tak ye'lak', tak niquirayij che ronojel-ta cosa quiq'uin-ta reje' c'o-va, ye'quibanala' re itzel tak banabal, ye'tz'ucu tzij, niquibanala' mac re camas ye'yi'o q'uex, itzel niquina' cha jun vinak re otz c'o, je nacanak, ye'quibila' itzel tak tzij chiquij re vinak, niquina' che camas quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel re etzelal qui tak re', pa ránma c'a re vinak nipo-va, y jare' re nitz'ilbisan richin. Quire' xubij re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Y re Jesús je ruchibil-a re ru-discípulos xe'el-a chire', y xe'ba pa jun lugar re c'o-apo chiquinakaj re ca'e' tenemit quibini'an Tiro y Sidón. Y xe'c'ue' pa jun jay, roma re Jesús man nrajo-ta che nitamax che reja' c'o chire'. Pero man riq'uin re', cha'nin xnabex che c'o chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Can cha'nin xnabex-pa roma jun ixok re c'o jun ral-xtan, y re xtan re' c'o jun itzel espíritu riq'uin. Re ixok re' can xe c'a xuc'axaj-pa che re Jesús c'o chire', reja' xpa riq'uin y xbexuque' chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Re jun ixok re' man israelita-ta. Reja' jun aj-sirofenicia. Pero xbexuque' chach re Jesús chin xbo'rc'utuj utzil cha che tulisaj re itzel espíritu re c'o riq'uin re ral. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero re Jesús xubij cha re ixok: Re utzil re pitinak riq'uin re Dios man otz-ta che chak xabanchique ninya-va. Xa ja re nuvinak israelitas re ye'nto' nabey. Roma man ruc'amon-ta che nilisas re quivay re ac'ola' chin che ja-ta re tz'e' ye'tijo, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero re ixok xubij cha re Jesús: Ajaf, can katzij re nabij. Pero can yojtiquir chuka' nakac'ul-apo ba' cha re utzil re'. Ancha'l niquiban re tz'e' chuxe' mesa, ye'quimolola' chuka' re ruchi' tak vay re ye'quitzakala-ka re ac'ola'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y re Jesús can jare' xubij cha re ixok: Re xabij can quire-va. Vocame catzolaj, roma re itzel espíritu xel-yan-a riq'uin re aval, xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y re ixok xtzolaj charachoch. Y xbo'rvila' re ral cotz'al chuch'at. Y cha'nin chuka' xutz'at che re itzel espíritu man chic c'o-ta riq'uin re ral. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Re Jesús y chibil re ru-discípulos xe'el-pa chupan re lugar re c'o-apo chunakaj re tenemit Tiro y xe'bak'ax-pa pa Sidón. Y xe'bak'ax-pa chuka' chupan re lugar rubini'an Decápolis, c'are' xe'beka chuchi' re lago rubini'an Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chire' jec'o-va tak xc'am-pa jun ache chach re Jesús, jun ache re man nuc'axaj-ta y man can-ta nitiquir nich'o. Y re je'c'amayom-pa richin, xquic'utuj utzil cha re Jesús che tuya' ruk'a' pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Re Jesús xuc'uaj-a re ache re'. Xuju' rue-ruk'a' pa tak ruxquin, xchuban, y c'are' xutz'am re rak'. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y re Jesús xtzu'un chicaj, xjek'ejo'x-ka y xubij pa kach'abal yoj re yoj israelitas: Efata. Re tzij re' ndel che tzij: Tijakataj. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y re ache can jare' xuc'axaj y xtiquir otz xch'o. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y re Jesús xuc'am-pa re ache y xubij chique re vinak che man tiquitzijoj re xbanataj. Pero re vinak, man riq'uin che can chalaben-a chique roma re Jesús che man tiquitzijoj, xa jare' re xbequibana-pa nabey. ");
INSERT INTO cakYNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y re vinak re' xsatz quic'o'x tak xquitz'at re xbanataj, y niquibila': Jabal re xuban. Nuban chique re man niquic'axaj-ta, che niquic'axaj, y nuban chuka' chique re je mema', che ye'ch'o, ye'cha' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ja k'ij re' tak camas je q'uiy vinak re xquimol-apo-qui' riq'uin re Jesús. Pero re vinak re' xq'uis quivay, y mare' reja' xe'rayoj re ru-discípulos y xubij chique: ");
INSERT INTO cakYNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yen camas ninjoyovaj quivach re vinak re', roma oxe' k'ij que'c'ue-va viq'uin y vocame manak chic quivay chin niquitaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y ye'ntak-ta-a cho tak cachoch choj quire' y man jun cosa niquitaj-a, man otz-ta. Roma jec'o naj je'pitinak-va, y q'uiba' ye'tzak pa tak bey roma viyjal, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Y re ru-discípulos xquibij cha: Re lugar yojc'o-va xa je manak vinak. Mare' manak anche' nakavila-va-pa vay chin che ye'va' jabal conojel re vinak re', xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero re Jesús xuc'utuj chique re ru-discípulos: ¿Jenipa' vay c'o iviq'uin? xcha' chique. Y reje' xquibij: C'o vuku', xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Y re Jesús xubij che que'tz'uye-ka re vinak pan ulef. C'are' reja' xe'ruli'ej pa ruk'a' re vuku' xcana-vay y xutioxij cha re Dios. Y c'are' xe'rupar y xuya-a chique re ru-discípulos, y reje' xquijachala' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y c'o chuka' ca'e-oxe' ch'utak car quiq'uin. Y re Jesús xutioxij cha re Dios roma re car re', y c'are' xutak rujachic chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Y conojel jabal xe'va'. Can man jun re man-ta xva'. Y c'a c'o vuku' chacach re xuban sobra. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Re xe'va' chupan re k'ij re', jec'o la'k jun caje' mil vinak. Y c'are' re Jesús xe'ruban despedir re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y can jare' tak re Jesús xoc-a pa canoa quiq'uin re ru-discípulos, y xe'ba pa jun lugar rubini'an Dalmanuta. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y jec'o chique re achi'a' fariseos re xe'beka riq'uin re Jesús, y xquitz'am-qui' che ch'abal. Y chin che niquitojtobej re Jesús xquibij cha che can tubana' jun señal chicaj, chin quire' can nuc'ut che ja re Dios takayom-pa richin, xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero re Jesús xbison-ka pa ránma y xjek'ejo'x-ka. C'are' xubij: ¿Anchique roma yex re yixc'o chupan re tiempo re' can nijo' nitz'at che c'o-ta jun señal nibanataj chicaj? Pero yen can katzij nimbij chiva che mana-ta re nijo' yex re xtibanataj, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y re Jesús xe'ruya' can re achi'a' fariseos, y xoc-a pa canoa quiq'uin re ru-discípulos, chin che ye'k'ax juc'an chic-apo ruchi-ya'. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y re discípulos xquimistaj man xquic'uaj-ta quivay, y chire' pa canoa xaxe jun vay c'o can. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y re Jesús xubij chique re ru-discípulos: Can tic'axaj re xtimbij chiva, che can tichajij-ivi' chach re levadura quichin re achi'a' fariseos y chin re Rey Herodes. Tak re Jesús xubij quire', xa xch'o chij re enseñanza re niquic'ut re achi'a' re' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero re discípulos man xk'ax-ta pa quive' y xquibila' chiquivach: Reja' xubij quire' roma manak kavay xkac'am-pa, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero re Jesús xunabej re niquibila' re ru-discípulos, mare' xubij chique: ¿Anchique roma yex ninojij che roma manak kavay, mare' tak ximbij quire'? Yex can man xk'ax-ta pan ive' re ximbij, roma xa can c'a icoversan re ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Yex c'o inak'avach, pero xa man yixtzu'un-ta. C'o ixquin, pero xa man nic'axaj-ta. Yex ancha'l xa man chic ne'ka-ta chi'c'o'x ");
INSERT INTO cakYNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","tak yen xinya' quivay re je vo'o' mil vinak riq'uin re vo'o' vay re ximpar chiquivach. ¿Jenipa' chacach je'nojnak che vay re xuban sobra? xcha' chique. Y re discípulos xquibij cha re Jesús: Doce chacach. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Y chuka' can ancha'l xa man chic ne'ka-ta chi'c'o'x tak yen xinya' quivay re je caje' mil vinak riq'uin re vuku' vay re ximpar chiquivach. ¿Jenipa' chacach je'nojnak che vay re xuban sobra? xcha' chique. Y re discípulos xquibij cha re Jesús: Vuku' chacach. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y re Jesús xubij chique: ¿Anchique roma tak can man k'axnak-ta pan ive'? ");
INSERT INTO cakYNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Re Jesús y chibil re ru-discípulos, xe'bapon pa Betsaida. Y xc'am-pa jun ache moy chach. Y re je'c'amayom-pa richin re moy re' xquic'utuj utzil cha che tuya' ruk'a' pa rue' che re ache moy nitiquir-ta nitzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xpa re Jesús xuyukej-a chuk'a' re ache moy y xuc'uaj-a chuchi' re tenemit. C'are' re Jesús xuya-apo ruchub chuchi' tak nak'arach re moy. Y xuya' ruk'a' pa rue'. C'are' xuc'utuj cha vo xa c'o nutz'at. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y tak re moy xujak re nak'arach, xubij: Ja'. Ye'ntz'at re achi'a'. Nintz'at che ancha'l che' je'pa'al. Pero xa man quire-ta, roma xa ye'biyin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y re Jesús xuya' chic jun bey re ruk'a' chuchi' tak nak'arach re ache. Can xuban cha re ache che xtzu'un. Y re ache xtzu'un jabal. Can jabal ye'rutz'at ronojel, che naj che nakaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y re Jesús xutak-a re ache chin tiba charachoch. Reja' xubij-a cha: Man catoc-apo pa tenemit chin man taya' rutzijol, xa choj cabiyin chavachoch, xcha-a re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Re Jesús y re ru-discípulos xe'ba pa tak cocoj tenemit re jec'o chire' pa Cesarea chin re Filipo. Y po bey re Jesús xuc'utuj chique re ru-discípulos: ¿Yin anchique c'a yen niquinojij re vinak? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y reje' xquibij cha: Jec'o ye'bin che ja rat re Juan Bautista. Nic'aj chic niquibij che ja rat re Elías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y jec'o chuka' re ye'bin che rat yat jun chique re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y reja' xuc'utuj chique re ru-discípulos: Y yex, ¿andex ninojij chuij? Y re Pedro can jare' xubij cha re Jesús: Ja rat re Cristo re bin che nitak-pa roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y re Jesús xubij chique che man jun anchok cha tiquibij-va che ja reja' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y re Jesús xutz'am rutzijosic y ruc'utic chiquivach re ru-discípulos: Yen re xinalax chi'icojol, tiene que nink'asaj q'uiy tijoj-pokonal. Xquintzelas coma re rejeta'k tak achi'a' re c'o quik'ij, coma re principal tak sacerdotes, y chuka' coma re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. Y xquinquimisas, pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y tak re Jesús xubij re ch'abal re' chique re ru-discípulos, can jabal k'alaj rubixic xuban cha. Pero re Pedro man xka-ta chach re xubij re Jesús, mare' xujich'aj-a quiq'uin re nic'aj chic discípulos, y cof xch'o cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero tak re Jesús xuc'axaj quire', xuposcolij-ri' y xe'rutzu' re nic'aj chic ru-discípulos. Y xubij cha re Pedro: Catel-a viq'uin rat Satanás, roma man otz-ta re nanojij. Roma re anojebal rat xa can junan quiq'uin re quinojebal re vinak y man nanojij-ta ba' andex re nrajo' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y re Jesús xe'rayoj-apo re vinak y re nic'aj chic ru-discípulos. Y xubij chique: Vo xa c'o jun nrajo' yinrutzekelbej, can tubana' ancha'l jun re binak chuxe' ru-cruz. Man tuban re nurayij reja'. Man tupokonaj nuk'asaj tijoj-pokonal. Vo xa c'o jun re ninojin quire', otz che nipa viq'uin chin yinrutzekelbej. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Roma vo xa camas nupokonaj re ruc'aslen vova' chach re ruch'ulef, xa man xtuvel-ta ruc'aslen re man niq'uis-ta. Jac'a re man nupokonaj-ta re ruc'aslen, astapa' xtiquimisas nutzij yen y roma re utzulaj ch'abal chin re Dios re nibex evangelio cha, jare' sí can xtuvel-va ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Roma man jun cosa otz nuc'am-pa cha re vinak, xe-ta nic'ue' ronojel re biyomal chin re ruch'ulef riq'uin, y re vinak re' man nicolotaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Astapa' camas biyomal c'o riq'uin re vinak, pero man nitiquir-ta nulok' re c'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Man jun vinak tiq'uex nutzijoj che yinruniman yen y re nuch'abal. Man tiq'uex nubij quire' chique re vinak re jec'o vocame, re xa man niquinimaj-ta re Dios y can je aj-maqui-va. Roma vo xa c'o jun re niq'uex nubij quire' chique, yen chuka' re xinalax chi'icojol xquinq'uex nimbij che re jun vinak re' che vichin yen. Quire' xtimban tak xquimpa chic jun bey, y junan chic nuk'ij riq'uin re Nata' y je vichibil-pa re lok'olaj tak ángeles. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y chuka' re Jesús xubij chique re jec'o riq'uin: Can katzij nimbij chiva, che re Dios can xtic'ue' pa kave', chin xkojruban gobernar. Y can xtik'alajin re ru-poder. Y jec'o chiva yex re can man xque'com-ta, xa c'aja tak quitz'eton chic can ronojel re xtibanataj, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y tak k'axnak chic vaki' k'ij, re Jesús xaxe re Pedro, re Jacobo y re Juan re xe'ruc'uaj-a pa rue' jun nema-loma. Y re Jesús xjalataj rutzubal chiquivach re je oxe' ru-discípulos re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y chuka' re rutziak can xjalataj ru-color. Roma camas rusakil xuban, can ancha'l re sakboch nika pa rue-juyu' y hasta niyiq'uiloj. Y man jun ch'ajoy-tziak re nitiquir-ta nuban quire' rusakil cha re jun tziak re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y xe'bec'ulum-pa re je ca'e' achi'a' quibini'an Elías y Moisés, y ye'tzijon riq'uin re Jesús. Re achi'a' re' je rusamajela' re Dios re xe'c'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y c'are' tak re Pedro xubij-apo cha re Jesús: Maestro, vova' otz kabanon. Takabana' oxe' ch'utak jay. Jun avichin rat, jun chin re Moisés y jun chin re Elías, xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Re Pedro quire' xubij-apo y man rutaman-ta anchique roma tak xch'o-apo. Xa bin che man bin xe'rubila-apo. Can che je oxe' discípulos camas quixibin-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y jare' tak c'o jun nube xpiso quichin. Y chupan re nube re' c'o Jun re xch'o-pa y xubij: Jare' re Nuc'ajol y yen camas ninjo'. Can tic'axaj c'a re rutzij. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pero tak re discípulos xe'tzu'un chic-apo, xquitz'at che xa man jun chic c'o riq'uin re Jesús. Xa rion chic c'o can. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y tak reje' je'xulam-pa chach re loma, re Jesús xuchalabej chique re ru-discípulos: Che man jun anchok cha titzijoj-va re xitz'at. Yex otz xtitzijoj pero tak yen re xinalax chi'icojol, xinc'astaj-yam-pa chiquicojol re anama'i', c'ajare' tak ruc'amon che yex xtitzijoj, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y reje' can man xquitzijoj-ta re andex xquitz'at, pero niquic'utula' chiquivach andex xrajo' xubij re Jesús tak xubij che xtic'astaj-pa chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y c'are' re je oxe' discípulos xquibij cha re Jesús: Yoj k'axnak pa kave' che can ja rat re Cristo re takom-pa roma re Dios. ¿Pero anchique roma tak re achi'a' je'atamayon re ley kachin yoj re yoj israelitas niquibij che nabey tiene que ne'ka re Elías, c'ajare' tak xte'ka re Cristo? ");
INSERT INTO cakYNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y re Jesús xubij chique: Can katzij-va che re Elías nipa nabey y nuban rubiyal ronojel. Mare' yex man tinojij che man xtibanataj-ta chuka' re je'tz'iban can chupan re ruch'abal re Dios, che yen re xinalax chi'icojol tiene que nink'asaj q'uiy tijoj-pokonal y can man jun nuk'ij xtiban chua. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero yen nimbij chiva che re Elías re' xpa-yan. Y camas xquiban-a cha. Can andex xquijo' xquiban-a cha. Can ancha'l nubij chupan re ruch'abal re Dios re tz'iban can, xcha' re Jesús chique. Re Elías re xunataj re Jesús xa ja re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Y tak re Jesús y re je oxe' ru-discípulos xe'bapon quiq'uin re nic'aj chic discípulos, reja' xutz'at che camas je q'uiy vinak re quimalon-apo-qui' chiquij, y chuka' ca'e-oxe' achi'a' je'atamayon re ley kachin yoj re yoj israelitas quitz'amon-qui' che ch'abal quiq'uin re discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Conojel re vinak, tak xquitz'at che pitinak re Jesús, xsatz quic'o'x, y jonanin xe'ba y xquic'utuj ruxnokil-rach. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y re Jesús xuc'utuj chique re ru-discípulos: ¿Anchok chij itz'amon-va-ivi' quiq'uin reje'? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pero jun chique re vinak xutz'am-apo rubixic cha re Jesús: Maestro, xcha' cha. Yen nc'amom-pa re nuc'ajol chava, roma c'o jun itzel espíritu riq'uin. Y re itzel espíritu re' can mem rubanon cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y tak más nutz'am, xabanchique lugar c'o-va, nutorij pan ulef, y re ruchub can nicubub pa ruchi' y can nukach'ach'ej roray. Y camas chuka' rucojman chic roma quire' ruc'alvachin. Y mare' xinc'utuj utzil chique re a-discípulos chin tiquilisaj re jun itzel espíritu re' riq'uin re nuc'ajol. Pero man xe'tiquir-ta, xcha' re ache. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y re Jesús jare' xubij chique: Man jun vinak chupan re tiempo re' re rubanon-ta confiar-ri' riq'uin re Dios. Man tinojij che yen nojel tiempo xquinc'ue' iviq'uin y chuka' man tinojij che nojel tiempo xquixincoch'. Tic'ama-pa re ala' vova', xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xc'am-pa re ala' chach re Jesús. Pero tak re itzel espíritu xutz'at re Jesús, riq'uin ruchuk'a' xuyiquiquej can re ala' y xutorij pan ulef. Y re ala' nubolk'otela-ri' y nicubub chuka' pa ruchi'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y re Jesús xuc'utuj cha rutota' re ala': ¿Jenipa' tiempo tuc'alvachij-va-pa quire' re ala'? xcha' re Jesús. Y re tata'aj xubij: Can c'a co'ol tak quire' ruc'alvachim-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Can q'uiy bey rutorin pa k'ak' y pa tak ya', chin nicom-ta. Pero vo xa rat yatiquir nato', tajoyovaj rach reja', tajoyovaj noch yen chuka' y kojato'. Quire' xubij re tata'aj cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pero re Jesús xubij cha re tata'aj: Vo xa rat yatiquir naban confiar-avi' viq'uin che yintiquir ninto' re ac'ajol, can xtibanataj-va re narayij. Pero re' ja rat yatc'o-va, roma re can nuban confiar-ri' tak nuc'utuj, can nibanataj-va re andex nrajo', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y re rutota' re ala' can jare' xubij: Nimban confiar-vi'. Y chuka' can quinato' chin che más-ta xtimban confiar-vi' aviq'uin. Y tak re tata'aj xubij re tzij re', can cof xubij, roma camas nem re bis c'o pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tak re Jesús xutz'at che camas je q'uiy vinak re niquimol-apo-qui', reja' cof xch'o cha re itzel espíritu, y xubij cha: Rat re abanon cha re ala' re' che mem y tocon, catel-a y man chic catzolaj-pa riq'uin, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y re itzel espíritu nurak ruchi' xel-a riq'uin re ala'. Pero camas xuyiquiquej can. Y re ala' xpune' can pan ulef, can ancha'l jun quiminak. Y mare' je q'uiy vinak xe'bin che re ala' xcom. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero re Jesús xutz'am ruk'a' y xuyac. Y re ala' can jare' xyacataj-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y tak re discípulos jec'o chic quion pa jay riq'uin re Jesús, xquic'utuj cha: ¿Anchique roma yoj man xojtiquir-ta xkalisaj-a re itzel espíritu? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y re Jesús xubij chique: Re jun rach espíritu re' ndel, pero vo xa yex niban ayuno y oración, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y tak reje' je'elinak chic-pa chire', xe'k'ax pa Galilea. Pero re Jesús man nrajo-ta che ninabex che reja' nak'ax chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Roma reja' nrajo' che re ru-discípulos niquitamaj can, mare' xubij chic jun bey chique: Yen re xinalax chi'icojol, can xquinjach-va pa quik'a' re vinak y xquinquiquimisaj. Jac'a tak yin quiminak chic, pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero re discípulos man xk'ax-ta pa quive' re xbex chique roma re Jesús. Y niquixibij-qui' niquic'utuj cha andex ndel-va che tzij. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y re Jesús je ruchibil-a re ru-discípulos xe'bapon pa tenemit Capernaum. Y tak c'o chic pa jay, reja' xuc'utuj chique re ru-discípulos. Y yex ¿andex re nich'ojela' chivach tak katz'amom-pa bey? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero re discípulos man xe'k'ajan-ta-apo cha re Jesús, roma tak je'pitinak po bey, xa xquich'ojela' chiquivach anchique chique reje' re c'o más ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y re Jesús xtz'uye-ka. C'are' xe'rayoj-apo che je doce ru-discípulos y xubij chique: Vo xa c'o jun nrajo' che ja reja' re c'o ruk'ij, can tuna-ka-ri' che xa manak ruk'ij y tusuju-ri' chin nuban xabanchique samaj quichin conojel. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y re Jesús xbo'rc'ama-pa jun ch'et ac'ual y xuya' chire' pa quinic'ajal. C'are' xuch'ilej y xubij chique re ru-discípulos: ");
INSERT INTO cakYNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Re yacayon vichin pa ránma y can niqui'cot nuc'ul jun ac'ual ancha'l re', man xe-ta xtuc'ul re ac'ual, xa can xquinruc'ul chuka' yen. Y re nic'ulu vichin yen, man xe-ta chuka' yen re xquinruc'ul, xa can xtuc'ul chuka' re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Y re Juan xubij-apo cha re Jesús: Maestro, yoj xkatz'at jun ache re pan abe' rat ye'rulisaj-va itzel tak espíritu, re man kachibil-ta, mare' xkabij cha che man chic tuban re ntajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Y re Jesús xubij: Man chic tibij quire' cha, roma vo xa pa nube' yen ye'rubanala' milagros, can nitiquir-va, y man xtijalataj-ta re nunojij y can ja-ta re' xtich'o-ka itzel tak tzij chuij. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Roma re man ye'tzelan-ta kachin, can kachibil-va-ki' quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y re vinak re otz yixquitz'at roma viq'uin yen re Cristo yixc'o-va, astapa' xa ba' rax-ya' re xtiquiya' chiva, can katzij nimbij che can c'o rajal-ruq'uixel xtiquic'ul roma quire' niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Vo xa c'o jun vinak re c'a ba-oc quinrunimaj-va y nipa-ta chic jun vinak y nuban cha che nitzak pa mac, re vinak re' man otz-ta re nuban. Y mare' antes che nuban re etzelal re', más-ta otz cha reja' che nixim-ta jun moma' aboj chukul y ne'torex can pa mar. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mare' vo xa jun ak'a' nibano chava che yamacun, más otz che nachoy-a. Roma más otz che manak jun ak'a' y yatoc chupan re c'aslen re man niq'uis-ta, que chach c'o-ta che ca'e' ak'a' y yaba pan infierno, anche' c'o-va re k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Re lugar re jec'o jut chin niquich'aculaj-ka re ach'acul re man ye'com-ta, y c'o chuka' k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y vo xa jun avakan nibano chava che yamacun, más otz che nachoy-a. Roma más otz che manak jun avakan y yatoc chupan re c'aslen re man niq'uis-ta, que chach che ca'e' avakan c'o y ya'tetorex can pan infierno, anche' c'o-va re k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Re lugar re jec'o jut chin niquich'aculaj-ka re ach'acul re man ye'com-ta, y c'o chuka' k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y vo xa jun anak'avach re nibano chava che yamacun, más otz che nalisaj-a. Roma más otz che manak jun anak'avach y yatapon chila' riq'uin re Dios, re anche' ja reja' re nibano gobernar, que chach c'o-ta che ca'e' anak'avach y ya'tetorex can pan infierno, ");
INSERT INTO cakYNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","re lugar re jec'o jut chin niquich'aculaj-ka re ach'acul re man ye'com-ta, y c'o chuka' k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Can ronojel chicop re ye'quimisas re ye'suj cha re Dios, ye'tzayex. Quire' chuka' conojel vinak xque'tzayex, pero man riq'uin-ta chic atz'am, xa riq'uin k'ak'. ");
INSERT INTO cakYNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Re atz'am camas otz. Pero xe-ta re atz'am niq'uis-ta-a re rutzayil, ¿andex como rubanic niban yex chin quire' nitzolaj-ta chic-pa re rutzayil? Man jun. Mare' yex tichajij re ic'aslen, chin quire' man quixoc ancha'l re atz'am re man nitzayin-ta chic, y chuka' manak-ta ayoval chi'icojol, quire' xubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Y c'are' re Jesús je ruchibil-a re ru-discípulos xel-a chire' y xba pa Judea. Y xk'ax chuka' juc'an chic-apo re rakan-ya' Jordán. Chire' camas chuka' q'uiy vinak xquimol-qui' riq'uin. Y reja' xutz'am ruc'utic re ruch'abal re Dios chiquivach, can ancha'l-va rubanom-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y jare' tak jec'o achi'a' fariseos xe'bapon riq'uin re Jesús chin niquitojtobej y chin che nitzak-ta pa quik'a'. Y mare' xquic'utuj cha vo xa ruc'amon che jun ache nujach-ri' riq'uin re ruxayil. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y re Jesús xubij chique re achi'a' re': ¿Andex rubin can re Moisés chiva che niban? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y reje' xquibij: Re Moisés can ruyi'on-va can k'ij cha re ache che nuban jun vuj anche' nubij-va che xujach-ri' riq'uin re ruxayil y tuya' can, xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y re Jesús can jare' xubij chique: Can ancha'l c'a icoversan re ivánma yex chupan re etzelal, can quire' chuka' xbanataj ajuer can pa ru-tiempo re Moisés. Xa mare' tak reja' xubij che can tiban quire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jac'a re xtiquir-va-pa xa man quire-ta. Re xtiquir-va-pa, tak re Dios xuban re ruch'ulef, can ache y ixok xuban. Can man rion-ta re ache y man rion-ta chuka' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mare' re ache man chic xtic'ue-ta quiq'uin rute-rutota'. Xa xtic'ue' riq'uin re ruxayil, ");
INSERT INTO cakYNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y che je ca'e' xa jun c'a xtiquiban. Roma tak quic'uan chic-qui', man chic je ca'e-ta vinak, xa jun chic quibanon. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Mare' re xa jun chic rubanon re Dios chique, man tuban re vinak che ye'rujach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tak re Jesús y re ru-discípulos jec'o chic pa jay, xe'pa re discípulos xquic'utula' cha re Jesús che andex xrajo' xubij riq'uin re ch'abal re ye'rubij chique re achi'a' fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y re Jesús xubij chique: Xabanchique ache re nujach-ri' riq'uin re ruxayil y c'are' nuc'am chic jun ixok, re ache re' nimacun chach re ruxayil. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y quire' chuka' re ixok re nujach-ri' riq'uin re ruchijil y niba chic riq'uin jun ache, re ixok re' can nimacun chuka'. Quire' xubij chique re discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y re vinak ye'quic'amala-pa re ac'ola' riq'uin re Jesús, chin che nuya-ta-a re ruk'a' pa quive'. Pero re discípulos xa xquibij chique re vinak che man tiquiban quire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jac'a tak re Jesús xutz'at re niquiban re ru-discípulos, xpa ruyoval, roma man otz-ta xutz'at re ye'tajin chubanic, y xubij chique: Tiya' k'ij chique re ac'ola' che que'pa viq'uin, y man que'ik'at. Roma re xque'oc pa ruk'a' re Dios, xaxe re je ancha'l ac'ola'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y can katzij nimbij chiva, che re man niquiban-ta ancha'l re ac'ola' chin niquijach-qui' pa ruk'a' re Dios, can man xque'oc-ta pa ruk'a' re Dios, xcha' chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y reja' xe'ruch'ilej y xuyala' ruk'a' pa quive' re ac'ola' chin xe'ruban bendecir. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y tak re Jesús xutz'am chic-a rubey je ruchibil-a re ru-discípulos, c'o jun ache jonanin xbeka riq'uin, xuque' chach, y xubij cha: Rat utzulaj Maestro, ¿andex re ruc'amon che nimban yen chin che ninvel-ta re c'aslen re man niq'uis-ta? xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y re Jesús xubij cha: ¿Anchique roma tak nabij chua che yen yin otz? Roma can man jun vinak re otz-ta, xa can xe c'a jun re otz y re' ja re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Y yen nimbij che rat ataman re lajuj mandamientos re xuya' re Dios pa ruk'a' re Moisés ajuer can, che rat ache re yatc'ulan man camacun riq'uin jun chic ixok, man caquimisan, man catelak', man tatz'uc tzij chij jun chic vinak, man tak'ol jun vinak chin che nalisaj chach re xa richin reja', taya' quik'ij re ate-arta', xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Y re ache xubij cha re Jesús: Maestro, c'a yin co'ol che' tak nbanom-pa ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y re Jesús xutzu' rach re ache tak xubij quire', y camas xrajo', y c'are' xubij cha: C'a c'o jun cosa re man abanon-ta. Man ajachon-ta re abiyomal chiquivach re vinak re camas je meba'. Ta'c'ayij ronojel re c'o aviq'uin y re rajal tajacha' chiquivach re vinak camas je meba', chin quire' nic'ue' abiyomal chila' chicaj. Y catampa viq'uin y catzake' chuij, y man tapokonaj nak'asaj tijoj-pokonal nutzij yen, ancha'l xa can yatbinak chuxe' jun cruz, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Y tak re ache xuc'axaj re tzij re xubij re Jesús cha, can k'alaj che xbison-ka pa ránma, roma camas biyomal c'o riq'uin. Y can nibison tak xba roma man nrajo-ta che ndel re rubiyomal pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Y re Jesús xe'rutzu' re ru-discípulos, y xubij chique: Re c'o quibiyomal, camas c'ayef che ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y re ru-discípulos re Jesús can anchique-la xquina' tak xquic'axaj re tzij re xubij re Jesús. Pero reja' xubij chic jun bey chique: Vajc'ual, xcha' chique. Re can quiyi'on cánma riq'uin re quibiyomal, camas c'ayef che ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mare' yen nimbij che man c'ayef-ta che nak'ax jun camello pa ch'et rujulil jun bak chin t'iso'n, que chach jun biyom ndoc-ta pa ruk'a' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero tak re discípulos xquic'axaj chic jun bey re tzij re xubij re Jesús, xsatz quic'o'x y xquibila' chiquivach: Vo xa can ancha'l re nubij, quire', man jun xticolotaj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y re Jesús xe'rutzu' chic re ru-discípulos jun bey y xubij chique: Re vinak man ye'tiquir-ta niquicol-qui', jac'a re Dios can nitiquir-va ye'rucol, roma reja' ronojel nitiquir nuban, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y jare' tak re Pedro xubij cha: Rat ataman che yoj kayi'on can ronojel re c'o kaq'uin, chin che yojtzakatal chavij. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pero re Jesús can jare' xubij: Can katzij nimbij chiva, che xabanchique vinak can c'o q'uiy cosas xtuc'ul, vo xa nutzij yen y roma re utzulaj ch'abal chin re Dios ruyi'on can rachoch, ruch'alal alabo y xtani', rute-rutota', ruxayil, rajc'ual o rulef. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Can q'uiy c'a xtuc'ul re nibano quire'. Can pa ciento c'a más re xtuc'ul-yan chupan re tiempo re katz'amon. Xtuc'ul-yan rachoch, ruch'alal alabo y xtani', rute', rajc'ual o rulef. Y astapa' riq'uin tijoj-pokonal roma xe'tzake' chuij yen, pero chupan re jun chic tiempo chakavach-apo, can xtuc'ul re ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Y je q'uiy re camas quik'ij vocame, pero xtapon re k'ij tak manak chic quik'ij xtic'ue'. Y je q'uiy re manak quik'ij vocame, pero xtapon re k'ij tak xtic'ue' quik'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Re Jesús y re ru-discípulos y re nic'aj chic vinak, quitz'amon-a bey pa tenemit Jerusalén. Y jac'a re Jesús re nabey-a chiquivach, y mare' re ru-discípulos y re vinak can anchique-la niquitz'at y quixibin-qui' je'tzakatal-a chij. C'are' re Jesús xe'rujach-a ba' re je doce ru-discípulos y xubij chic chique re andex che tijoj-pokonal xtuk'asaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Reja' xubij chique: Yex itaman che pa tenemit Jerusalén katz'amon-va-a bey, y ja chire' re xquinjach-va yen re xinalax chi'icojol. Xquinjach pa quik'a' re principal tak sacerdotes y pa quik'a' re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. Y reje' xtiquibij che quinquimisas. Y chuka' xquinquijach pa quik'a' vinak re man je israelitas-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y re vinak re' xque'tze'en chuij, xquinquichubaj, xquinquich'ay y c'are' xquinquiquimisaj. Pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y re Jacobo y re Juan, re je ruc'ajol re ache rubini'an Zebedeo, xe'jelon-apo riq'uin re Jesús, y xquibij cha: Maestro, xe'cha' cha. Yoj nakajo' nakac'utuj jun utzil chava. Pero tabana' utzil can naban re xtakac'utuj chava, xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y reja' xubij chique: ¿Andex che utzil re nijo' yex? ");
INSERT INTO cakYNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y reje' xquibij: Yoj nakajo' che tak ja chic rat re yabano gobernar, naban-ta chaka yoj che nic'ue' kak'ij, naya-ta k'ij chaka chin che yojtz'uye-ta-apo aviq'uin, jun-ta re nic'ue' pan avajquik'a' y jun-ta re pan axocon. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero re Jesús xubij chique: Yex man itaman-ta che can c'ayef nuban chiva re nic'utuj. Y mare' yen ninc'utuj chiva vocame: ¿Nicoch' como yex re xtiban chua yen? ¿Y nicoch' como chuka' yex jun tijoj-pokonal re ancha'l xtika pa nue' yen? xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Reje' xquibij: Nakacoch', xe'cha' cha re Jesús. Y re Jesús xubij chic chique: Can katzij che yex xticoch' re ancha'l xtiban chua yen. Chuka' can xticoch' jun tijoj-pokonal re ancha'l xtika pa nue' yen. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Jac'a re nic'utuj chua che jun nitz'uye' pa vajquik'a' y jun pa nuxocon, re' man pa nuk'a-ta yen c'o-va chin che ninya' chiva. Roma re nic'utuj yex, re' xa quichin chic re xtubij re Dios che otz che ye'tz'uye' chire', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y re je lajuj chic discípulos, tak xquic'axaj re niquijo' re Jacobo y re Juan, xpa quiyoval chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Y jare' tak re Jesús xe'rayoj re ru-discípulos y xubij chique: Yen nimbij che yex jabal itaman che re banon chique che niquiban gobernar chach re ruch'ulef, ja reje' re ye'bano mandar pa quive' re vinak, mare' can niquina' che ja reje' re je cajaf. Xa can xe re c'o quik'ij jare' re ye'bin re andex niban. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero chi'icojol yex man quire-ta. Roma vo xa c'o jun chiva yex re nrajo' nic'ue' ruk'ij, can tuna-ka-ri' che xa manak ruk'ij y tusuju-ri' chin nuban xabanchique samaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vo xa jun chiva yex can nrajo' che ja reja' re nabey y c'o-ta ruk'ij, can tuna-ka-ri' che xa manak ruk'ij y tusuju-ri' chin nuban xabanchique samaj quichin conojel. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Y quire' yen re xinalax chi'icojol. Yen man nimpokonaj-ta yinsamaj pa qui-cuenta re vinak, roma can chubanic-va re' tak ximpa, y man ximpa-ta chin che jec'o chic nic'aj ye'bano-pa re nimbij chique. Can jac'a yen re yimbano re samaj, y can xtinya' chuka' re nuc'aslen chin quire' je q'uiy re ye'colotaj chach re quimac, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'are' re Jesús y re ru-discípulos xe'bapon pa tenemit rubini'an Jericó. Y tak reje' niquiya' can re tenemit, camas je q'uiy vinak re je'tzakatal-a chiquij. Y chire' chuchi-bey c'o jun moy rubini'an Bartimeo, ruc'ajol jun ache rubini'an Timeo. Reja' tz'uyul chire', nuc'utula' c'a ru-limosna chique re vinak re ye'k'ax chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y tak reja' xuc'axaj che nak'ax-yan chire' re Jesús aj-Nazaret, reja' cof xch'o y xubij: Tajoyovaj noch rat Jesús, re yat rey-rumam can re Rey David, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y je q'uiy vinak xquibila' cha: Ch'oj-achi'. Pero reja' xa más cof nich'o y nubij: Rat re yat rey-rumam can re Rey David, tajoyovaj noch roma quire' nbanon, nicha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y re Jesús xuc'axaj ruch'abal re ache moy. Mare' xpa'e-ka y xubij che tayox-pa. Y can jare' xbecayoj-pa y xquibij cha: Man taxibij-avi'. Jo'. Re Jesús yarayoj, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y re ache can xe xuc'axaj quire', can jare' xyacataj-pa. Xuya' can re ruk'u' chire' y xba-apo riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y re Jesús xuc'utuj cha: ¿Andex najo'? Y re ache moy xubij cha: Maestro, yen ninjo' yintzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y re Jesús can jare' xubij cha: Vocame otz yaba, roma yatzu'un chic. Y roma xaban confiar-avi' viq'uin, mare' xac'achoj. Y re moy can xtzu'un-va y xba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y tak nakaj chic jec'o-va chique re aldea quibini'an Betfagé y Betania, xa ba' chic nrajo' che ye'bapon pa tenemit Jerusalén, roma can chuxe' chic-apo re loma rubini'an Olivos jec'o-va, jare' tak re Jesús xe'rutak-a je ca'e' chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Reja' xubij-a chique: Quixbiyin-apo chupan la aldea la nitz'at-apo chila'. Y can xe xquixoc-apo, jare' xtivel jun alaj burro ximil can chire'. Y re chicop re' can man jun ch'ocolbeyon richin. Tisolo-pa y tic'ama-pa chua. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y vo xa c'o jun xtibim-pa chiva anchique roma nisol re chicop, tibij cha che ndoc cha re Ajaf, pero cha'nin xto'rya' can, quixcha' can cha, jare' xbex-a chique roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Y re je ca'e' discípulos xe'ba. Tak xe'bapon, xquivel re alaj burro ximon can chire' po bey, re anche' c'o-va re entrada chin re jay. Y reje' xquisol-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero tak reje' ye'tajin chusolic re alaj burro, xe'tz'et-pa coma jun ca'e-oxe' vinak re jec'o chire' y xquibij chique re je ca'e' discípulos: ¿Andex yixtajin chubanic chire'? ¿Anchique roma nisol re ch'et alaj burro? xe'cha-pa chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y re discípulos xquibij re rubin-a re Jesús chique. Y re xe'tz'eto-pa quichin xquiya' k'ij chique chin che xquisol-a y xquic'uaj-a re alaj burro re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y re discípulos re' xquic'am-pa re alaj burro cha re Jesús. C'are' xquiya' quik'u' chij re chicop re', chin che re Jesús xch'oque-a chij. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y je q'uiy chique re vinak, xquiriq'uila' re quik'u' pa rubey re Jesús chin niquiya' ruk'ij. Y nic'aj chic xe'bequic'amala-pa ruk'a' tak che' re nibex palma cha chin xquivak pa rubey. Reje' quire' xquiban chin che xquiya' chuka' ruk'ij re Jesús. Y quire' niquibanala' tak je'binak. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Re vinak re je nabey chach re Jesús y re je xambay can, jun pa quichi' niquiban tak niquibij: ¡Matiox che pitinak re Jun re'! ¡Reja' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! ");
INSERT INTO cakYNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox che nitzolaj-yan chic-pa ruk'ij re David re karta' re xc'ue' ajuer can! ¡Matiox cha re Dios re c'o chila' chicaj! xe'cha' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y re Jesús xoc-apo pa tenemit Jerusalén, y xbak'ax-pa pa rachoch re Dios y xe'rutz'at can re jec'o chire'. Y tak xoc-pa re ak'a', reja' je ruchibil-a re je doce ru-discípulos xe'ba pan aldea rubini'an Betania. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa ruca'n k'ij tak quitz'amon bey chin je'tzolojnak-pa pa Betania y ye'ba pa Jerusalén, re Jesús xpa ch'umunic rupan. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y reja' c'ac'anaj xutz'at-va-apo che c'o jun che' rubini'an higuera tiquil, y camas jabal rubanon re ruxak. Xba-apo chuxe' chin no'rcanoj-pa vo xa c'o rach. Pero tak xapon-apo chuxe' xa manak rach, xa rion ruxak. Roma man ru-tiempo-ta che nivachin. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jare' tak re Jesús xch'o cha re che' y xubij: Man jun bey chic xcavachin. Can man jun chic vinak xtitijo avach, xcha' cha re che'. Y re ru-discípulos xquic'axaj re xubij. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xe'bapon chic pa tenemit Jerusalén. Y re Jesús xba pa rachoch re Dios. Pero tak reja' c'o chic chire', xe'rukotaj-pa re vinak ye'c'ayin y re ye'lok'on. Y chique re vinak re ye'jalo rach mero xe'rutiquimila' can re qui-mesas. Y quire' chuka' xuban can chique re quich'acat re ye'c'ayin palomas. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y reja' man xrajo-ta che re vinak quic'uan ejka'n, ye'k'ax chupan re rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'are' reja' xuc'ut chiquivach re vinak riq'uin re ruch'abal re Dios, che re rachoch re Dios xa can chin-va oración. Mare' reja' xubij chique re vinak, che chupan re ruch'abal re Dios tz'iban can che re vachoch jay chin niquiban orar conojel vinak re jec'o chach re ruch'ulef. Jac'a yex xa ancha'l cachoch elek'oma' ibanon cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y re' xc'axax coma re principal tak sacerdotes y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. Pero roma reje' ye'quitz'at re vinak che camas xsatz quic'o'x y can anchique-la xquina' roma re enseñanza re nuc'ut re Jesús chiquivach, mare' xa can niquicanola' c'a andex rubanic niquiban chin niquiquimisaj re Jesús. Re principal tak sacerdotes y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas niquixibij-qui' chach re Jesús, roma xa can bama conojel vinak jabal niquic'axaj re nuc'ut. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Y tak xk'okumar-pa, re Jesús je ruchibil-a re ru-discípulos xe'ba. Man xe'c'ue-ta-ka chire' pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Namak'a' cha re ruca'n k'ij, tak quitz'amon bey pa Jerusalén, xquitz'at che chake'j chic re che' rubini'an higuera re xubij can re Jesús che man jun bey chic xtivachin. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y re Pedro cha'nin xbeka chuc'o'x, y xubij cha re Jesús: Maestro, tatz'eta' la higuera, xa can xchakij-va-ka ancha'l re xabij, xcha-apo cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Pero re Jesús xubij chique conojel re ru-discípulos: Yex chuka' nic'atzin che niban confiar-ivi' riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Y can katzij nimbij chiva che xabanchique nibin cha re loma re' che tel-a vova' y tak'ax pa mar, can quire' nibanataj. Vo xa can katzij nuban confiar-ri' y man nubij-ta-ka pa ránma che xa man la'k nibanataj-ta re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mare' yen nimbij chiva che ronojel re nic'utuj tak yex niban orar y ninimaj che can xtic'ul-va, can quire' xtibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y tak niban orar, can man-ta jun re nik'ato richin. Roma vo xa c'o jun vinak re c'o rumac rubanon chivach, ticuyu'. Chin quire' re Karta' re c'o chila' chicaj xquixrucuy chuka' yex riq'uin re imac re ye'banala' chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roma vo xa yex man nicuy-ta rumac jun vinak re c'o etzelal rubanon chiva, chuka' re Karta' re c'o chila' chicaj man xtucuy-ta re imac re yixtajin chubanic chach. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Re Jesús y re ru-discípulos xe'bapon chic jun bey pa tenemit Jerusalén. Y chire' pa rachoch re Dios c'o-va re Jesús tak xe'bapon re principal tak sacerdotes riq'uin, y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas y chibil chuka' re rejeta'k tak achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Y xquic'utuj cha: ¿Anchique xyi'o autoridad pan ak'a' chin xa'kotaj-a re vinak xe'c'ayin pa rachoch re Dios? ¿Y anchique xyi'o autoridad chava chin che q'uiy cosas ya'banala' chiquicojol re vinak? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xpa re Jesús xubij chique re achi'a' re': Yen chuka' c'o jun cosa ninjo' ninc'utuj chiva. Y vo xa yex xtibij chua, yen chuka' xtimbij chiva anchique ya'yon autoridad chua yen chin ye'mbanala' re cosas re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tic'axaj jabal re xtinc'utuj chiva. ¿Re Juan xtak-pa roma re Dios chin xe'ruban bautizar re vinak? ¿O xa vinak xe'bin cha che quire' tubana'? Tibij chua andex ninojij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Y re principal tak sacerdotes, re achi'a' je'atamayon re ley kachin yoj re yoj israelitas y chuka' re rejeta'k tak achi'a' re c'o quik'ij, xquibila' chiquivach: ¿Y vocame andex xtakabij cha re Jesús? Roma vo xa xtakabij che re Juan ja re Dios takayom-pa richin, re Jesús xtubij chaka: ¿Anchique roma tak man xinimaj-ta? ");
INSERT INTO cakYNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y vo xa nakabij che xa vinak xe'bin cha re Juan che tubana' quire', c'ayef nuban chaka yoj. Reje' xquibij-ka quire', roma quixibin-qui' chiquivach re vinak. Roma conojel re vinak can quitaman che re Juan jun rusamajel re Dios re xbex profeta cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y c'are' xquibij-apo cha re Jesús: Yoj man kataman-ta. Y re Jesús can jare' chuka' tak xubij chique re achi'a' re': Roma yex man xixtiquir-ta xibij chua, quire' chuka' yen man xtimbij-ta chiva anchique ya'yon autoridad chua chin ye'mbanala' re cosas re', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y re Jesús, riq'uin ejemplo xch'o quiq'uin re achi'a' c'o quik'ij. Reja' quire' c'a xubij chique: Xc'ue' jun ache, xutic uva chach re rujuyu' y c'are' xuban co'c chij. Xuban chuka' ancha'l jun ch'et pila pan ulef anche' niyitz'-va re uva, y xuban chuka' jun torre y pa rue' re torre xc'ue-va rachoch re nichajin chin re juyu'. C'are' xuya' can pa kajic chique je ca'e-oxe' achi'a', y reja' c'ac'anaj xbo-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y tak xapon re tiempo chin re cosecha, re rajaf re juyu' xutak jun ru-mozo quiq'uin re achi'a' re je'kajayon re ulef chuc'amic re uva kajbal chin re juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero tak xapon re mozo quiq'uin re achi'a' re je'kajayon re ulef, reje' xquitz'am re mozo y xquich'ay, y manak uva xquiya-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Y re rajaf re juyu' xutak chic-a jun ru-mozo chuc'amic re uva kajbal richin re ulef. Pero re achi'a' re je'kajayon re juyu' xa cha aboj xquic'ul-apo y xquisocola-a pa rujalom. Q'uiy cosas re xquibanala-a y xquibila-a cha, y quire' xquitak-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pero re rajaf re juyu' xutak chic jun ru-mozo. Y re mozo re' xquimisas coma re je'kajayon re juyu'. Y c'o chic más ru-mozos xe'rutak, pero conojel c'o andex xban chique, roma jec'o xe'ch'ay y jec'o xe'quimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruq'uisibal re rajaf re juyu' xaxe chic re ruc'ajol re camas nrajo' xc'ue' can riq'uin. Pero re rajaf re juyu' xutak-a re ruc'ajol quiq'uin re achi'a' re je'kajayon re ulef, roma reja' xunojij: Re achi'a' kajoy tak ulef, tak xtiquitz'at che can ja re nuc'ajol xtapon quiq'uin, can xtiquinimaj-va, xcha-ka pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero tak re achi'a' re je'kajayon chin re ulef xquitz'at che ja re ruc'ajol re rajaf re juyu' xapon, xquibila' chiquivach: Jare' re xtoc can rajaf ronojel re juyu' kakajon. ¿Anchique roma man nakaquimisaj? Chin quire' pa kak'a' yoj nic'ue-va can re juyu', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y can quire-va xquiban. Xquitz'am y xquiquimisaj. Xquilisaj-a chire' pa rujuyu'. Reje' xbequitorij can pa jun chic lado. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","C'are' re Jesús xubij: ¿Andex como xtuban re rajaf re juyu' quiq'uin re achi'a' kajoy tak ulef? Re rajaf re juyu' xtipa y xque'ruquimisaj re je'kajayon chin re juyu' re' y re rujuyu' xtuya' chic can pa kajic chique nic'aj chic. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Y yex ibanon leer re jun ch'abal re tz'iban can chupan re ruch'abal re Dios. Re ch'abal re' nubij quire': C'o c'a jun aboj re man xka-ta chiquivach re banoy tak jay. Pero re aboj re' can xoc-va, roma re aboj re' xa can c'o-va xcusan richin, y ja aboj re' re tz'amayon chin re jay chin che man nitzak-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Roma can ja-va re Ajaf xbano re', y re inak'avach can man jun bey quitz'eton che quire-ta nibanataj. Quire' nubij chupan re ruch'abal re Dios re tz'iban can, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y re achi'a' anchok quiq'uin xch'o-va re Jesús can xquijo' che xquitz'am-ta-a, roma xquinabej che re achi'a' re je'kajayon re juyu' re xe'runataj chupan re ejemplo, xa chiquij reje' xch'o-va. Y man jun xe'tiquir xquiban chin xquitz'am-ta-a, roma niquixibij-qui' chiquivach re vinak re jec'o riq'uin. Reje' xquiya' can re Jesús y xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y re achi'a' re' xe'quitak-pa nic'aj chic quichibil. Xe'quitak-pa ca'e-oxe' achi'a' fariseos y chuka' je ca'e-oxe' ruvinak re Rey Herodes, chin niquiya' pa c'ayef re Jesús y nitzak-ta pa quik'a' riq'uin re ch'abal re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'are' reje' xe'pa y xquibij cha re Jesús: Rat re yat jun Maestro, yoj can kataman che can xe-va re katzij re nika chavach y jare' re natzijoj. Y chuka' mana-ta re ruk'ij jun vinak re natz'at, xa can pa rubiyal nac'ut re ruch'abal re Dios. ¿Andex nabij chaka? ¿Ruc'amon como nakatoj re impuestos re nubij re César che nakatoj o xa man ruc'amon-ta? xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero re Jesús can rutaman-va che riq'uin ca'e' quipalaj niquic'utuj quire' cha. Mare' reja' xubij chique: ¿Anchique roma yex can nitaj ik'ij chin yinitojtobej? Tic'ama-pa re mero re' y tintz'eta-na rach, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y reje' xbequic'ama-pa re mero chin niquic'ut chach. Y c'are' reja' xuc'utuj chique: ¿Anchok rutzubal c'a la'? ¿Y anchok rube' chuka' la c'o chach la mero? Y reje' xquibij cha re Jesús: Chin re César, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y jare' tak re Jesús xubij chique: Titojo' c'a re impuestos cha re César riq'uin re mero re ruc'amon che niya' cha reja'. Y tiya' cha re Dios, ronojel re ruc'amon che niya' cha re Dios, xcha' re Jesús chique. Y reje' camas xsatz quic'o'x tak xquic'axaj re xubij re Jesús chique, roma man xe'tiquir-ta chij che xka pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y jare' tak nic'aj chique re achi'a' saduceos xe'bapon riq'uin re Jesús. Re achi'a' re' man niquinimaj-ta che re anama'i' xque'c'astaj chic-pa. Y mare' reje' xquibij cha re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Rat re yat jun Maestro, c'o jun cosa nakajo' nakac'utuj chava. Re Moisés can rutz'iban can chaka, che tak jun ache nuya' can re ruxayil roma xcom-a y man jun rajc'ual xuya' can riq'uin re ixok, jun chique re ruch'alal reja' re nic'ule' riq'uin re malca'n-ixok, chin quire' che c'o-ta rajc'ual nic'ue' riq'uin re ixok malca'n. Y vo xa jec'o rajc'ual ye'c'ue' riq'uin re ixok, ja re nabey rajc'ual ala' jare' re ndoc rajc'ual re ache quiminak chic. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y reje' xquibij: Quire' xbanataj quiq'uin je vuku' achi'a' quich'alal-qui'. Re nabey xc'ule'. Pero xcom-a y man jun rajc'ual xc'ue'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xpa re ruca'n ache, re ruch'alal can re ache quiminak chic, xc'ule' riq'uin re malca'n-ixok. Pero chuka' re ache re' xcom-a y man jun rajc'ual xc'ue'. Re rox ache can quire' chuka' xuc'alvachij-a, ancha'l re je ca'e' nabey ruch'alal y re ixok c'a xc'ue-na can. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Che je vuku' achi'a' quich'alal-qui' quire' xquic'alvachila-a. Y man jun chique re je vuku' achi'a' re' xc'ue-ta rajc'ual. Y pa ruq'uisibal xcom chuka' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y re achi'a' saduceos xquibij cha re Jesús: Rat nabij che xtapon jun k'ij tak re anama'i' xque'c'astaj-pa. Tak xtapon re k'ij re', ¿anchok ruxayil c'a xtoc-va re ixok re'? Roma che je vuku' achi'a' quich'alal-qui' xe'c'ue-a riq'uin, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Y re Jesús xubij chique re achi'a' re': Yex xa yixsatzanak riq'uin re xibij, roma man itaman-ta re andex nubij chupan re ruch'abal re Dios. Y can man k'axnak-ta pan ive' re ru-poder re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roma tak xtapon re k'ij che re anama'i' xque'c'astaj-a, man chic xque'c'ule-ta, y chuka' man chic xque'quiya-ta-a quimi'al-cajc'ual chin ye'c'ule'. Reje' xa xque'oc ancha'l re ángeles re jec'o chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Y re anama'i' can xque'c'astaj-va, y yen nimbij che yex jabal itaman andex re tz'iban can roma re Moisés, tak reja' xutz'at re zarza can nibac'o pa k'ak', y chire' xch'o-va-pa re Dios cha y xubij: Ja yen re ru-Dios re Abraham, re ru-Dios re Isaac y re ru-Dios chuka' re Jacob, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Y vo xa re je oxe' anama'i' re' xe'com-ta jumul y xa man-ta ye'c'astaj chic-pa jun bey, re Dios man-ta qui-Dios reje', roma re Dios can qui-Dios-va re c'o quic'aslen y man quichin-ta re anama'i'. Mare' yen nimbij che xa yixsatzanak riq'uin re nibij, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y jare' tak xjelon-apo riq'uin re Jesús jun ache re etamayon re ley kachin yoj re yoj israelitas. Re ache re' xuc'axaj re xquibij re achi'a' saduceos cha re Jesús, y xuc'axaj chuka' re xubij re Jesús chique re achi'a' re'. Y chach reja' can k'alaj che otz xubij re Jesús y c'are' xuc'utuj: ¿Anchique c'a mandamiento xuya' re Dios pa ruk'a' re Moisés, re c'o más rajkalen? xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y re Jesús xubij cha: Re mandamiento re c'o más rajkalen ja re nubij quire': Tic'axaj yex aj-Israel, re Kajaf xaxe jun, y re' ja re Kajaf Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Can tajo' re Kajaf Dios. Tajo' riq'uin ronojel avánma. Tajo' riq'uin ronojel re ac'aslen, riq'uin ronojel re ana'oj y riq'uin ronojel re avuchuk'a'. Jare' re mandamiento re más c'o rajkalen. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y c'o chic jun mandamiento re camas rajkalen y bama junan riq'uin re jun re c'a nimbij-ka. Y re mandamiento re' nubij: Can ancha'l najo-ka-avi' rat, quire' chuka' que'ajo' re nic'aj chic vinak. Y ja ca'e' mandamiento re' re más c'o quijkalen, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y re ache xubij cha re Jesús: Maestro, xcha' cha. Can ja-va c'a quire'. Can katzij re xabij che xaxe jun Dios c'o, y man jun chic. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nic'atzin che nakajo' riq'uin ronojel kánma, riq'uin ronojel re kana'oj, riq'uin ronojel re kac'aslen y riq'uin ronojel kachuk'a'. Y ancha'l chuka' nakajo-ka-ki' yoj, quire' chuka' que'kajo' re nic'aj chic vinak. Vo xa ye'kaban re', c'o más rajkalen que chach re chicop je'quimisan re ye'suj cha re Dios, xcha' re ache re rutaman re ley kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y tak re Jesús xuc'axaj che can jabal xk'ax pa rue' re jun ache re', re Jesús xubij cha: Rat xa man naj-ta chic yatc'o-va chin che yatoc pa ruk'a' re Dios, xcha' cha re ache. Y jare' tak man jun chic xbano covil che c'o-ta jun cosa xuc'utuj cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y re Jesús chin ye'rutijoj re vinak re quimalon-qui' riq'uin chire' pa rachoch re Dios, xubij chique: ¿Anchique roma tak re achi'a' je'atamayon re ley kachin yoj re yoj israelitas niquibij che re Cristo xa choj jun rey-rumam can re Rey David? ");
INSERT INTO cakYNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tak xa can ja re Rey David xbin re xbex cha roma re Espíritu Santo. Re David ja quire' rubin can: Re Ajaf Dios xubij cha re Vajaf re Cristo: Catz'uye-pa pa vajquik'a', y xque'nya' pan ak'a' re ye'tzelan avichin. Quire' xubij re Dios cha re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y vo xa re Rey David, Vajaf nicha' cha re Cristo, ¿anchique roma tak nibex che re Cristo xa choj jun rey-rumam can re Rey David? xcha' re Jesús. Y camas je q'uiy chique re vinak re can riq'uin-va ronojel cánma xquic'axaj re xubij. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y re Jesús tak ye'rutijoj re vinak xubij chique: Man tiban ancha'l niquiban re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. Roma reje' camas nika chiquivach niquicusaj tukutak tak tziak, chin titz'et-na che camas quik'ij. Camas chuka' nika chiquivach che niya' ruxnokil-quivach pa tak q'uiybal, re anche' niquimol-va-qui' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, can ja re nabey tak ch'acat ye'quicanola', chin che tibex chique che camas quik'ij. Y can ja chuka' quire' niquibanala' re anche' niban-va va'in. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y chuka' re achi'a' re' ye'quimojola' cachoch re malcani' tak ixoki'. Y reje' tak niquiban oración cha re Dios, camas ye'yaloj xaxe chin ninimax che camas je otz tak vinak. Pero reje' can xtika-va más castigo pa quive', roma re quimac camas q'uiy, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y re Jesús tz'uyul-apo chach re anche' ne'yalox-va can mero chire' pa rachoch re Dios. Jare' tak reja' ye'rutz'at re vinak tak niquiyala' can mero chire'. Xe'rutz'at je q'uiy biyoma' re camas q'uiy mero niquiyala' can. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero xapon chuka' jun ixok malca'n re camas meba'. Reja' xuya' can ca'e' ch'utak mero re camas ba-oc rajkalen. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y tak re Jesús xutz'at re ixok re', xuc'ut chiquivach re ru-discípulos y xubij chique: Can katzij nimbij chiva che yen xintz'at che xa ja la ixok la' re xyi'o can más q'uiy, que chiquivach conojel re je'yayon can mero chin pa rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Roma reja' can xe-va re c'o riq'uin jare' re xuya' can, jac'a re nic'aj chic xa ja re nuban sobra quiq'uin, jare' re niquiyala' can, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y tak re Jesús ndel-pa pa rachoch re Dios, jun chique re ru-discípulos xubij cha: Maestro, xcha' cha. Tatz'eta' la rubanic re rachoch re Dios, y tatz'eta' chuka' la aboj je'cusan camas je jabal-oc, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Y re Jesús xubij cha re ru-discípulo: Rat can ya'tz'at che re jay re' camas otz quibanic y je nima'k, pero xtapon jun k'ij che ronojel re ya'tz'at vova' can xque'vulax y can man jun re xtipa'e-ta can. Ronojel re aboj re je'cusan chique re jay re', xa can xque'vulax-va. Can man jun aboj re xtic'ue-ta can ancha'l la rubanon vocame. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y tak re Jesús tz'uyul chic pa rue' re loma rubini'an Olivos, re anche' jabal niquitz'at-pa re rachoch re Dios, jare' tak re Pedro, re Jacobo, re Juan y re Andrés xe'jelon-apo riq'uin re Jesús y re je caje' discípulos re' xquic'utuj cha: ");
INSERT INTO cakYNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tabij chaka: ¿C'a jampa' c'a xque'banataj re xabij-yan-ka chij re rachoch re Dios? ¿Y andex che señal xtitz'et chin quire' ninabex che nibanataj-yan? xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y xpa re Jesús xubij chique: Can jabal tichajij-ivi' chin man quixk'olotaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Roma je q'uiy xque'pa y xtiquibij: Ja yen re Cristo, xque'cha'. Y camas je q'uiy re xque'k'olotaj pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Y tak xtic'axala' che jec'o naciones re ye'tajin che guerra, y xtic'axala' chuka' che c'o cha guerra xque'pa, pero man tisatz ic'o'x, roma ronojel re' tiene que ye'banataj-na. Pero mana-ta re' re ruq'uisibal tak k'ij chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jun tenemit xtiyacataj chin no'rbana' guerra riq'uin jun chic tenemit. Jec'o chuka' re nima'k tak naciones re xque'yacataj chin che ne'quibana' guerra quiq'uin nic'aj chic nima'k tak naciones. Xque'pa sananel q'uiy lugar. Xque'pa chuka' viyjal, y q'uiy chuka' quivach ayoval xque'pa y re vinak xque'ch'ujlan pa tak naciones. Y re' xa ja re nabey tak k'axomal y xque'pa nic'aj chic quivach tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero yex can jabal tichajij-ivi'. Roma xa can jec'o re xque'jacho ivichin pa quik'a' re achi'a' re pa camon ye'bano juzgar. Y chuka' xquixch'ay pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Xquixc'uax chiquivach re achi'a' re ye'bano gobernar, chiquivach reyes y nic'aj chic re ye'bano juzgar chach re ruch'ulef. Y xa nutzij yen xtic'alvachij quire', pero xa can xquixtiquir c'a xquinitzijoj chiquivach reje'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y nic'atzin che nitzijos re utzulaj ch'abal chin re Dios pa tak ronojel naciones, c'are' xte'ka re ruq'uisibal k'ij chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Jac'a tak xquixc'uax-a chin che yixe'jach pa quik'a' re autoridades, man timay re andex xtibij. Yex xaxe c'a tibij re andex che tzij re xtuya' re Dios chiva, roma xa can mana-ta chic yex re xquixch'o chupan re hora re', xa can ja chic re Espíritu Santo re xtich'o. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Y can xtibanataj, vo xa jec'o je ca'e' achi'a' quich'alal-qui', re jun xtiyacataj chij re jun chic ruch'alal y xtujach chin che niquimisas. Y can jec'o-va chuka' tata'aj re xque'yacataj chiquij re cajc'ual. Y re cajc'ual xque'yacataj chuka' chiquij re quite-quirta' y xque'quijach chin che que'quimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Can conojel-va xque'tzelan ivichin roma ibanon confiar-ivi' viq'uin. Pero re man xtutzolij-ta-ri' chij y xtucoch' xtuk'asaj ronojel re' c'a pa ruq'uisibal, can xticolotaj-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y chuka' can xtapon-va re k'ij tak xque'banataj re xajan tak banabal chupan re lugar re anche' man ruc'amon-ta che quire' nibanataj. Y riq'uin re' xtivulataj c'a can re lugar re'. Jare' re tz'iban can roma re Daniel, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Re nitz'eto re tz'iban can, tak'ax c'a pa rue' re nutz'at. Chin quire' tak xtitz'at che can ja chic re' re ye'banataj, re vinak re jec'o pa Judea xa can que'numaj-a y te'quivovaj-qui' pa tak c'achelaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Y re nixulan pa rue' rachoch tak napon re k'ij re', man chic toc-apo pa rachoch chin c'o cosas ye'bo'rc'ama-pa, xa choj quire' tinumaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Re nisamaj pak'os, man chic titzolaj pa rachoch chuc'amic ruk'u'. Xa choj chuka' quire' tinumaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Jac'a re ixoki' re c'o chic yabil chiquij, y re ixoki' re xa c'a niquiya' quitz'um ch'utak cal, tivok'ex c'a quivach tak xtapon re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mare' tic'utuj cha re Dios che re tijoj-pokonal re' man-ta nibanataj chupan re tiempo chin tef, chin che man c'ayef-ta nuban chiva che yixnumaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Roma tak xtapon re k'ij re', can ja tiempo chin tijoj-pokonal re xtipa. Jun tijoj-pokonal re man jun bey banatajnak-ta chach re ruch'ulef desde que jampa' banon can roma re Dios. Y chuka' re tijoj-pokonal re' man jun bey chic xtibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y vo xa re Ajaf Dios man-ta nuban cortar re tiempo chin re tijoj-pokonal re', conojel-ta vinak ye'com. Pero re Dios xa quitzij re je'rucha'on chic, tak xtuban cortar re tiempo chin re tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan re k'ij re', vo xa jec'o ye'bin chiva: Titzu', jac'a Cristo re'. O vo xa niquibij chiva: Titzu', jac'a Cristo la c'o la'. Pero yex man quixk'olotaj pa quik'a' y man tinimaj re niquibij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Roma can jec'o re xque'bec'ulum-pa y xtiquibila': Ja yen re Cristo. Pero yex man que'inimaj, roma xa quion je tz'ucuy tak tzij. Y ja chuka' k'ij re' tak xque'bec'ulum-pa re xque'bin: Yen nintzijoj re nubij re Dios chua, xque'cha'. Pero yex man c'a que'inimaj, roma xa je tz'ucuy tak tzij chuka'. Y xque'quibanala' milagros re man jun bey je'tz'eton, xaxe chin che que'nimax y can jec'o-va re xque'quik'ol. Y xe-ta reje' can ye'tiquir ye'quik'ol chuka' re je'cha'on chic roma re Dios, can ye'quik'ol-ta, pero man xque'tiquir-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Jac'a yex can tichajij-ivi', chin che man-ta yixk'olotaj roma ximbij-yan can chiva ronojel re xque'banataj. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupan re k'ij tak k'axnak chic re tijoj-pokonal re', xtibanataj che re k'ij y re ic' can xtik'ukumutaj quivach. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Y re ch'umil xque'betzakalam-pa re anche' jec'o-va. Can ronojel-va re namalaj tak poderes re jec'o chicaj xque'silon roma re ru-poder re Dios. Can che jun re rocaj xtisilon. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Y jare' tak xquinquitz'at yen re xinalax chi'icojol, che yinka-pa pa nube, riq'uin chic namalaj poder y chuka' riq'uin chic namalaj nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y jare' tak yen xque'ntak re nu-ángeles chiquimolic re je'ncha'on chic. Can xque'quimol-pa re jec'o pan oriente y re jec'o pan occidente, re jec'o pa norte y re jec'o pa sur. Can xque'quimol-pa che jun ruch'ulef, nitiquir-pa pa jun rutza'n re rocaj, c'a la jun chic rutza'n. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Can titamaj re ejemplo chij re jun che' rubini'an higuera. Tak re ruk'a' jabal rax ye'quibam-pa y ye'el-pa re ruxak c'ac'a, can itaman che re tiempo chin job ne'ka-yan. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y ja quire' chuka' tak xtitz'at che can jec'o chic cosas ye'banataj riq'uin re k'ij, re ic', re ch'umil y ronojel re ximbij-yan-ka ntajin chic rubanic, titamaj c'a che ne'ka-yan re k'ij. Xa can nakaj chic c'a c'o-va-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y tic'axaj jabal re xtimbij chiva vocame: Ronojel re' xque'banataj tak re vinak chin re tiempo re' c'amaje-na que'q'uis-a chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Y re ruch'ulef y re rocaj can chin-va che ye'q'uis. Jac'a re nuch'abal man xtiq'uis-ta, xa can xtibanataj-va ronojel re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jac'a re k'ij y re hora tak yen xquimpa, man k'alaj-ta. Re ángeles re jec'o chila' chicaj man quitaman-ta jampa' re'. Quire' chuka' yen re yin Ruc'ajol re Dios man ntaman-ta. Xa can xe re Nata' Dios atamayon re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Yex xa can tichajij-apo jabal re ic'aslen. Can tiyabej y tibana' chuka' orar, roma xa man itaman-ta jampa' xtapon re k'ij tak yen xquimpa. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ancha'l tak jun ache nuya' can re rachoch y niba naj. Reja' nuchalabej can re rusamaj chique re ru-mozos. Can cada jun nuyala' can quisamaj, y cha re nichajin can re rachoch nubij che can nojel tiempo tic'ase' chin tuyabej-apo. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Can quire' tibana' yex, can nojel tiempo c'a quixc'ase' chin quiniyabej-apo. Ancha'l re ache nichajin, roma man rutaman-ta jampa' xte'ka re rajaf jay, reja' can nuyabej-apo. Roma re rajaf-jay q'uiba' ne'ka tak ndoc-pa re ak'a', o ja pa tak nic'aj-ak'a', o ja tak nitzirim-pa re moma' namak'a-yan, o ja tak nisakar-yam-pa. Mare' yex can nojel tiempo c'a quiniyabej-apo. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Roma yen can nojel tiempo ninjo' che yixc'ase' chin yiniyabej-apo, roma man xtinya-ta rutzijol tak xquimpa. ");
INSERT INTO cakYNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y can ancha'l re nimbij chiva yex che can nojel tiempo quixc'ase' che quiniyabej-apo, can quire' chuka' nimbij chique conojel, xcha' re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa ca'e' chic k'ij nrajo' che napon re ca'e' kanamak'ij yoj re yoj israelitas. Re jun kanamak'ij rubini'an pascua. Y re jun chic ja tak nakataj re xcana-vay re manak levadura riq'uin. Y jare' tak re principal tak sacerdotes y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas niquinojela' andex niquiban chin che nika re Jesús pa quik'a' y c'are' niquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Y niquibila' chiquivach: Man takatz'am chupan re namak'ij re', che man que'yacataj-pa re vinak chakij. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y re Jesús c'o pa tenemit rubini'an Betania, chire' pa rachoch re jun ache rubini'an Simón re xc'achojsas cha re yabil rubini'an lepra. Re Jesús tz'uyul niva' chach mesa, y jare' tak c'o jun ixok xoc-apo y ruc'uan-apo jun frasco re banon riq'uin jun aboj rubini'an alabastro y chupan re frasco re' c'o-a nardo, jun ak'om jubul-oc ruxla' y camas caro rajal. Y tak re ixok re' xulisaj-a re ch'et rukul re frasco, xuk'aj re ak'om pa rujalom re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y jec'o xpa quiyoval tak xquitz'at che quire' xuban re ixok cha re ak'om jubul-oc ruxla' y xquibila': ¿Anchique roma la ixok la' chak xaxe tal quire' xutix la ak'om pa rujalom re Jesús? ");
INSERT INTO cakYNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roma xc'ayex-ta y xba-ta che más oxe' ciento denarios, y re mero re' xjach-ta chiquivach re vinak re camas je meba', xe'cha'. Y niquich'olij re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero re Jesús xubij chique: ¿Anchique roma tak man yixtane-ta-ka che tzij chij? Xa tiya' can. Reja' jun utzulaj banabal re xuban viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Re vinak re camas je meba' xa can nojel tiempo jec'o iviq'uin, y xabanchique k'ij nijo' ye'to', can tibana' utzil chique. Jac'a yen man nojel-ta tiempo xquinc'ue' iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Reja' xuban re andex nitiquir nuban viq'uin. Can xuc'ut che camas yinrajo'. Astapa' c'amaje-na quincom, reja' can xuban-yan-apo re nrajo' nuban viq'uin tak xquinemuk can. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Y can katzij re xtimbij chiva, che xabanchique lugar xtitzijos-va re utzulaj ch'abal chin re Dios re nibex evangelio cha, chire' chuka' xtitzijos-va re xuban viq'uin re jun ixok re'. Can che jun ruch'ulef xtitzijos-va, y man jun bey xtimistas, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Y jun chique re je doce ru-discípulos re Jesús re rubini'an Judas Iscariote, xapon quiq'uin re principal tak sacerdotes, chin xbo'rbij chique vo xa niquijo' che nujach re Jesús pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y tak reje' xquic'axaj quire', camas xe'qui'cot y xquisuj ru-mero. Mare' reja' xutz'am runojexic andex xtuban chin nujach re Jesús pa quik'a' re achi'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chupan re nabey k'ij chin re namak'ij kachin yoj re yoj israelitas tak nitij re xcana-vay re manak levadura riq'uin, ja chuka' k'ij re' tak ye'quimisas ch'utak ovejas chin re pascua, jare' tak re discípulos xquic'utuj cha re Jesús: ¿Anche' najo' naban-va re va'in chupan re jun pascua re', chin nakabana' rubanic ronojel re ndoc? ");
INSERT INTO cakYNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y re Jesús xe'rutak-a je ca'e' chique re ru-discípulos, y xubij-a chique: Quixbiyin pa tenemit Jerusalén, y chire' xtitz'at che c'o jun mozo re ruc'amom-pa ruya' pa jun cucu'. Ja reja' re xtic'uan-a ibey. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Re jay re anche' xtoc-va reja', chire' chuka' quixoc-va yex y quixch'o riq'uin re rajaf jay y tibij cha: Re ka-Maestro rubim-pa: ¿Anchique cuarto re vova' pan avachoch re otz chin nimban re namalaj va'in chin re pascua quiq'uin re nu-discípulos? ");
INSERT INTO cakYNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y re rajaf jay xquixruc'uaj-a pa ruca'n piso chin re jay. Y chire' c'o jun cuarto nem re banon chic rubanic. Ja chire' tibana-va rubanic re xtakataj chin re pascua, xe'cho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y re je ca'e' discípulos xe'ba pa tenemit Jerusalén. Y tak xe'bapon, can xbanataj-va ancha'l rubin-a re Jesús chique. Y reje' can xquiban-va rubanic ronojel re ndoc chin re va'in chin re pascua. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Jac'a tak xoc-ka re ak'a' chupan re k'ij re', jare' tak re Jesús je ruchibil-a re je doce ru-discípulos xe'bapon chire' pa jay. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y tak reje' je'tz'uyul chic chach mesa, y ye'tajin chic che va'in, jare' tak re Jesús xubij chique re ru-discípulos: Can katzij nimbij chiva, che jun chiva yex re xtijacho vichin. Jun re can niva' viq'uin, jare' xquinjacho pa quik'a' re vinak re ye'tzelan vichin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Reje' can jare' tak xpa bis pa tak cánma. Y niquic'utula-apo cha re Jesús: ¿Mana-ta como yen re xquimbano quire'? xe'cha'. Y can che ja'jun che ja'jun re quire' xquibij-apo cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y re Jesús xubij chique: Jun chiva yex re yix doce, y ja re anchique nuquiak' ruay viq'uin chupan re mismo lak jare' re xtijacho vichin. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can tic'axaj re xtimbij chiva, che yen re xinalax chi'icojol can xquinquimisas-va. Can xtibanataj-va ancha'l nubij chupan re ruch'abal re Dios re tz'iban can. Pero tivok'ex c'a rach re xtijacho vichin yen re xinalax chi'icojol. Re ache re xtijacho vichin más-ta otz che man-ta xalax, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y tak c'a ye'tajin che va'in, re Jesús xuc'am-apo jun xcana-vay y xutioxij cha re Dios. C'are' xupar re xcana-vay re' y xuya' chique re ru-discípulos. Reja' xubij chique: Tic'ama' can re xcana-vay re'. Roma jare' re nu-cuerpo re xtapon chach re camic. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y re Jesús xuc'am-apo chuka' re vaso re c'o ruyi'al-uva chupan, y tak rutioxin chic cha re Dios, xuya' chique, y conojel xquikum re ruyi'al-uva. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y reja' xubij chique re ru-discípulos: Jare' re nuq'uiq'uel re xtibiyin tak xquincom. Riq'uin re nuq'uiq'uel, can jare' xc'achoj re c'ac'a trato re rujovam-pa re Dios che nuban quiq'uin re vinak. Re nuq'uiq'uel xtibiyin, chin che je q'uiy vinak ye'colotaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Can katzij nimbij chiva, che jac'a ruq'uisibal bey re' re xinkum-a re ruyi'al-uva. Y tak xtinkum chic jun bey, tak ja chic re Dios nibano gobernar. Y re ruyi'al-uva re xtinkum chire', jun c'ac'a ruyi'al-uva, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y tak quibixan chic-ka re bix chin niquiya' ruk'ij re Dios, re Jesús y re ru-discípulos xe'el-a chire' pa jay y xe'ba-apo chuxe' re loma rubini'an Olivos. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y tak quitz'amon bey, re Jesús xubij chique re ru-discípulos: Chupan re ak'a' re' tak yex xtitz'at che yen xquinjach-a pa quik'a' re vinak, chiyixnojel yex xa xtitaluj-a-ivi' y nayon xquiniya' can. Roma re Dios can quire-va rubin can chupan re ruch'abal re tz'iban can: Tak yen xtinya' k'ij che xtiquimisas re nichajin quichin re ovejas, re ovejas xa xtiquitaluj-a-qui'. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero yen re yinchajin quichin re ovejas man jumul-ta xquincom, xa xquinc'astaj chic-pa. Y ja yen re xquinyaben ivichin chila' pa Galilea, xcha' re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Y re Pedro can jare' tak xch'o-apo cha re Jesús y xubij: Vo xa re nic'aj chic yatquiya' can ayon tak xtiquitz'at che c'o andex re man otz-ta niban chava, pero yen man xcatinya-ta can, xcha' re Pedro cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Y re Jesús xubij cha re Pedro: Yen can katzij nimbij chava, che chupan re ak'a' re' tak c'amaje-na titzirim-pa re moma' ca'e' bey, tak rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero astapa' re Jesús xubij quire', re Pedro xa xubij chic-apo jun bey cha re Jesús: Astapa' can xtinvel nucamic aviq'uin, pero man jun bey xtimbij che man ntaman-ta avach. Y chuka' re nic'aj chic discípulos can quire' niquibij. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Re Jesús y re ru-discípulos xe'bapon chupan re lugar rubini'an Getsemaní. Xpa re Jesús xubij chique re ru-discípulos: Quixtz'uye' can ba' vova', y yen te'mbana-na orar. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y xaxe re Pedro, re Jacobo y re Juan xe'ruc'uaj-a re Jesús. Jare' tak reja' can xuna-yan re xto'rc'alvachij. Mare' camas nem re bis xpa pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xubij chique re je oxe' ru-discípulos: Re bis c'o pa vánma, camas nem. Y can yinruquimisaj nina' yen. Quixc'ue' can ba' vova', quixc'ase' y man quixvar-ka, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Reja' xbiyin chic-apo ba' y c'are' xuque-ka y xluque-ka pan ulef y xuban orar. Reja' xuc'utuj che can choj-ta quire' nak'ax re hora re', che man-ta nuk'asaj re tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y ja ch'abal re' re xe'rubij pa ru-oración: Nata', yen ntaman che rat yatiquir naban ronojel. Can-ta naban che xaxe tal choj quire' nak'ax y man-ta nink'asaj re jun tijoj-pokonal re', pero man taban re ninjo' yen, xaxe roma yen quire' nimbij chava. Roma yen xa can ninjo' chuka' nimban re najo' rat, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y tak reja' xtane' cha re ru-oración, xpa quiq'uin re je oxe' ru-discípulos, pero tak xbeka quiq'uin xa ye'var. Xpa reja' xubij cha re Pedro: Simón, ¿xa xavar la'k-ka? Can man ba' xatiquir xac'ase' jun ch'et hora viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Man quixvar-ka, xa tibana' orar y tic'utuj cha re Dios chin che tak yixtojtobex, man quixtzak pa mac. Can ntaman-va che re ivánma can nurayij nuban re nrajo' re Dios. Pero iyon man yixtiquir-ta, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y re Jesús xba chic jun bey chin xbo'rbana' orar. Reja' xucamaluj rubixic re ch'abal re xe'rubij chupan re oración re c'a ba' tuban-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y tak xpa chic jun bey quiq'uin re je oxe' ru-discípulos, xa ye'var chic jun bey xe'bo'rvila', roma reje' can al rij re quinak'avach roma camas quivaran. Y reje' man niquivel-ta andex niquibij, roma ye'var chic jun bey xe'belitaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Y re Jesús xba chic chubanic orar. Pero tak xpa pa rox bey, reja' xubij chique re je oxe' ru-discípulos: Vocame quixvar y can titz'aktisaj re ivaran. Pero man chic xquixtiquir-ta. Yen re xinalax chi'icojol jac'a re nu-hora xbeka, can xquinjach-a pa quik'a' re itzel tak achi'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cha'nin, quixyacataj. Ja la pitinak re anchique xquinjacho-a pa quik'a' re itzel tak achi'a', xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y re Jesús can c'a ntajin che tzij quiq'uin re ru-discípulos, tak can jare' xbeka re Judas re jun chique re doce ru-discípulos re Jesús, y q'uiy vinak je'ruc'uan-apo y re vinak re' je'quic'ualon che' y espada. Y conojel re vinak re' je'takon-a coma re principal tak sacerdotes, coma re achi'a' je'atamayon re ley kachin yoj re yoj israelitas y coma chuka' re rejeta'k tak achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Re Judas re nijacho-a chin re Jesús can rubin chic chique re je'pitinak riq'uin, andex xtuban chin nuc'ut re Jesús chiquivach. Reja' ja quire' rubin chique: Ja re anchique xtintz'ubaj chin xtimban saludar, jare' re Jesús. Titz'ama', y man tinumaj chivach. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y tak re Judas xapon, can choj xba-apo riq'uin re Jesús y xubij cha: Maestro, Maestro, xcha' cha y c'are' xutz'ubaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y re vinak re je'binak chutz'amic re Jesús, xquitz'am-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun chique re jec'o riq'uin re Jesús chire', xulisaj ru-espada y xuya' cha re jun ru-mozo re namalaj sacerdote, y xutzaq'uij-a ruxquin cha re jun bic espada re xuya' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y c'are' xpa re Jesús xubij chique re vinak re je'binak chutz'amic: ¿Yex xinojij che yixpitinak chutz'amic jun elek'om y mare' ic'amom-pa che' y espada? ");
INSERT INTO cakYNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Yen can k'ij-k'ij xinc'ue' iviq'uin chire' pa rachoch re Dios, tak xinc'ut re ruch'abal re Dios chivach y man jun bey xinitz'am-ta. Pero re' tiene que nibanataj, can ancha'l re tz'iban can chupan re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y can jare' tak re ru-discípulos re Jesús, xquiya' can rion y xe'numaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero c'o jun ala' re can tzakatal-a chij re Jesús y reja' pa jun tziak nem rucuchun-va-a-ri'. Y re je'tz'amayon-a chin re Jesús xquitz'am re ala' re'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero reja' xel-a chupan re tziak re', y ja quire' manak rutziak xnumaj-a chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Y re vinak re je'tz'amayon-a chin re Jesús xquic'uaj-a pa rachoch re namalaj sacerdote. Y chire' chuka' xquimol-va-qui' re principal tak sacerdotes, re rejeta'k tak achi'a' re c'o quik'ij y chuka' re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y re Pedro c'ac'anaj c'a c'o-va can, pero tzakatal-a chij re Jesús. Y tak re Jesús xcusas-apo pa rachoch re namalaj sacerdote, chuka' re Pedro xoc-apo chire' chach-jay. Y xtz'uye-ka chiquicojol re policías re jec'o-apo chire', quimek'on-qui' chuchi-k'ak'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y re principal tak sacerdotes y conojel re achi'a' re pa camon ye'bano juzgar, niquicanola' che c'o-ta itzel tak banabal ye'litaj chij re Jesús, chin quire' niquimisas, pero man jun xquivel chij. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Roma astapa' can je q'uiy re xe'bapon chin xquitz'uc tzij chij re Jesús, pero man ba' xquic'ul-qui' je ca'e' re can-ta junan niquibij chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y c'are' jec'o nic'aj chic re xe'bepa'e-pa y ja quire' xquibij chij re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Yoj can kac'axan tak reja' rubin: Yen xtinvulaj re rachoch re Dios re banon coma achi'a', y pan oxe' k'ij xtimpoba' chic jun re man achi'a-ta xque'bano. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Pero man riq'uin re', cama-va junan-ta re xquibila'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y re Caifás re namalaj sacerdote, xbepa'e-pa pa quinic'ajal y xuc'utuj cha re Jesús: ¿Katzij como re xquibij re xe'ch'o-ka chavij? ¿Andex nabij vocame? xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero re Jesús man xch'o-ta, y man jun tzij xubij. Mare' xpa re namalaj sacerdote, xuban chic jun pregunta cha. Reja' xuc'utuj cha: ¿Ja rat re Cristo re Ruc'ajol re Dios re nakaya' ruk'ij? xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y re Jesús xubij: Ja', ja yen. Y xquinitz'at chuka' che yen re xinalax chi'icojol che yintz'uyul pa rajquik'a' re Dios re nitiquir nuban ronojel. Y xquinitz'at tak xquinka-pa pa nube chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tak re namalaj sacerdote xuc'axaj re', xuratz re rutziak chij roma itzel xuc'axaj y xubij: Manak tuk'aj che nipa-ta chic jun chin no'rbij chaka che re Jesús can aj-mac-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chiyixnojel yex xic'axaj che xubij che ja reja' re Cristo. Can man otz-ta xuban chach re Dios. ¿Andex nibij vocame? xcha' reja'. Y conojel xquibij che can ruc'amon che niquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y jec'o xquichubaj rupalaj, chuka' xquitz'apij rach, xquich'ay y c'are' niquic'utula' cha: ¿Anchique re xe'ch'ayo avichin? Tabij chaka, ye'cha' cha. Y re policías re jec'o chire', xquiyala' k'a' chupalaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y tak re Pedro c'o chire' pa xulan-ka cha re jay, c'o jun ixok raj-ic' re namalaj sacerdote re xapon chire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Re Pedro numak'-ri' chuchi-k'ak'. Y jare' tak xpa re aj-ic' nutzu-nutzu-apo rach re Pedro, y c'are' xubij cha: Rat chuka' yat ruchibil re Jesús re aj-Nazaret, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero re Pedro xa xutz'uc tzij chach roma xubij: Yen man ntaman-ta rach re Jesús. Man nak'ax-ta pa nue' anchique roma tak quire' nabij chua, xcha' cha re aj-ic'. Y re Pedro xel-a chire' chiquicojol y xba anche' c'o-va re puerta re anche' ye'el-va re vinak. Y jare' tak re moma' xtzirim-pa. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y tak re aj-ic' xutzu' chic jun bey re Pedro, xutz'am chic rubixic chique re jec'o chire': La ache la' jun chique re ru-discípulos re Jesús, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero re Pedro jun bey chic xutz'uc tzij. Y can c'a ba' tak'ax-va re', ja-yan chic re quimalon-qui' chire' xquibij chic jun bey cha: Can katzij-va che rat yat jun chique re ru-discípulos re Jesús. Roma rat pa Galilea yapo-va, y can junan yach'o quiq'uin, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero re Pedro xubij: Yen man ntaman-ta rach re ache nibij yex. Can chach re Dios nimbij chiva che yen man ntaman-ta rach. Y vo xa man katzij-ta re nimbij, tika c'a re castigo pa nue', xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y re moma' xbetzirim-pa pa ruca'n bey. Y re Pedro jare' tak xbeka chuc'o'x re tzij re je'rubin can re Jesús cha, che c'amaje-na titzirim-pa re moma' ca'e' bey, tak rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch. Y reja' can xujek'aj ok'ej tak xel-a chire', roma xbeka chuc'o'x re tzij re bin can cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y tak xsakar-pa chupan re k'ij re', re principal tak sacerdotes xquimol-qui' je quichibil-a re rejeta'k tak achi'a' re c'o quik'ij y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. Y ja achi'a' re' re pa camon ye'bano juzgar, y can conojel reje' xquimol-qui' chin xquinojij andex niquiban cha re Jesús, y yach'on tak xquic'uaj-a y xbequijacha' pa ruk'a' re ache nibano gobernar rubini'an Pilato. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y jare' tak re Pilato xuc'utuj cha re Jesús: ¿Ja rat re qui-Rey re israelitas? Y re Jesús xubij: Ja', ja quire', can ancha'l re xabij. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y re principal tak sacerdotes, jun quichi' niquiban-apo cha re Pilato, chin niquisujuj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xpa re Pilato xch'o chic-apo cha re Jesús y xubij cha: Reje' jun quichi' niquiban chin yatquisujuj, y rat ¿man jun tzij nabij? xcha' re Pilato cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero re Jesús cama-va jun tzij xubij. Y re Pilato can anchique-la xuna', roma man jun bey rutz'eton che jun vinak quire-ta nuban. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y ronojel juna' tak napon re kanamak'ij yoj re yoj israelitas rubini'an pascua, re gobernador can nulisaj-a jun chique re presos re jec'o pa cárcel. Y ja re preso re niquic'utuj re vinak re nulisaj-a libre. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y re k'ij re', c'o pa cárcel jun ache rubini'an Barrabás, y jec'o chic nic'aj ruchibil. Conojel reje' jec'o pa cárcel roma xe'yacataj chij re gobierno y chuka' xe'quimisan. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Y mare' re vinak re' can quitaman che re gobernador can nulisaj-va-a jun chique re presos re jec'o pa cárcel, mare' xe'pa reje' xquic'utuj cha re Pilato che tulisaj-a jun chique re jec'o pa cárcel. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y re Pilato can jare' xubij-pa chique: ¿Nijo' yex che ninlisaj-a libre re Rey ivichin yex re yix israelitas? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Re Pilato quire' xubij-pa, roma reja' can rutaman-va che re principal tak sacerdotes quiyi'on re Jesús pa ruk'a', roma itzel niquina' cha che camas je q'uiy vinak re ye'tzekelben richin. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Y re principal tak sacerdotes xquiban chique re vinak che tiquibij-apo cha re Pilato che xa ja re Barrabás re tulisaj-a libre. Y re vinak quire' xquiban. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y re Pilato jare' xuc'utuj chic chique: ¿Andex nibij yex che nimban riq'uin re ache re nibij che i-Rey yex re yix israelitas? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y re vinak jun pa quichi' xquiban tak xquibij-apo: ¡Tataka' ruquimisasic cho cruz! xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mare' re Pilato xubij chique: ¿Andex rumac rubanon chivach c'a? Pero reje' man ye'tane-ta-ka. Xa más xquirak-apo quichi' chin xquibij-apo: ¡Tataka' ruquimisasic cho cruz! xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y re Pilato xulisaj-a libre re Barrabás, chin che ticukar quic'o'x re vinak. C'are' xutak ruch'ayic re Jesús y xujach-a chin che tiquimisas cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xe'pa re soldados xquicusaj-apo re Jesús chach re palacio. C'are' xe'cayoj conojel re nic'aj chic soldados, re je quichibil. Xe'quimol-apo chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y re soldados re' xquiya' c'a jun tziak morado chij re Jesús, can ancha'l re ye'quicusala' re reyes. Y chuka' xquipach'uj jun k'ayis re camas ruq'uixal. Xquiban jun corona cha, y c'are' xquiya' pa rujalom re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Y chuka' chin niquiban-apo saludar niquibila-apo cha: Caqui'cot rat re qui-Rey re israelitas, ye'cha'. Y tak quire' niquibij xa chin niquiban burlar. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Reje' niquich'ay pa rujalom re Jesús riq'uin jun aj, y niquichubaj rupalaj chuka'. Can ye'xucuyaj chach. Can niquiban che niquiya' ruk'ij, pero xa ye'tze'en tak niquiban quire'. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y tak reje' xe'tane' che tza'n chij, xquilisaj-a re tziak morado re quiyi'on-ka chij. C'are' xquiya-a re can rutziak-va, y xquic'uaj-a chin che ne'quibajij cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tak quitz'amon-a bey, xquic'ul jun ache aj-Cirene, jun ache pitinak pak'os. Re ache re', quirta' re achi'a' quibini'an Alejandro y Rufo. Y reja' rubini'an Simón. Y re soldados xquiban cha re ache re' che xuc'uaj-a re ru-cruz re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y re soldados xquic'uaj-a re Jesús pa jun lugar rubini'an Gólgota. Re be'aj re' ndel che tzij Calavera. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y tak jec'o chic chire', xquisuj cha re Jesús vino re xalon riq'uin ruyi'al jun che' rubini'an mirra. Pero reja' man xrajo-ta xukum. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y tak re soldados quibajin chic re Jesús cho cruz, xquiban sortear re rutziak re Jesús chin xquitz'at andex che tziak re niquic'uala-a cada jun. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve re namak'a' tak xquibajij re Jesús cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y pa rue' re ru-cruz tz'iban-va chach jun tz'alam re andex rumac re Jesús chin niquimisas. Chach re tz'alam re' nubij: Jare' re qui-Rey re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y re soldados jec'o chuka' je ca'e' chic achi'a' re xe'quibajij cho cruz. Re je ca'e' achi'a' re' je elek'oma'. Jun re xya' pa rajquik'a' re Jesús y jun pa ruxocon. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riq'uin re' can nibanataj ancha'l re tz'iban can chupan re ruch'abal re Dios tak nubij: Reja' can ancha'l chuka' jun aj-mac xban cha. Quire' re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Re vinak re ye'k'ax re anche' c'o-va re Jesús, niquisiloj-apo quijalom chach, roma cama-va niquinimaj-ta che ja reja' re Ruc'ajol re Dios. Y chuka' c'o tzij ye'quibila' can cha, y ja quire' re niquibij: ¡Pobre-ála! Rat re yabin che navulaj re rachoch re Dios y pan oxe' k'ij napoba' chic jun bey. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tacola' c'a-avi' ayon y caka-pa chach la a-cruz, ye'cha' can cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y ja chuka' quire' niquiban re principal tak sacerdotes y re je'atamayon re ley kachin yoj re yoj israelitas, ye'tze'en chij re Jesús y niquibila' chiquivach: Reja' can je q'uiy xe'rucol, pero vocame ni xe-ta reja' mismo man nitiquir-ta nucol-ri'. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Can rubin che ja reja' re Cristo, re Rey chin re tenemit Israel. Vo xa quire', can tika-pa chach la ru-cruz, chin nakatz'at y nakanimaj, ye'cha'. Y re elek'oma' re je'bajin cho cruz riq'uin re Jesús, c'o chuka' tzij qui tak re' re ye'quibila-apo cha. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y tak xapon re nic'aj-k'ij, jare' tak che jun ruch'ulef xk'ukumataj rach. Y re k'oko'm re' xq'uis-a c'a pa tak a las tres re tak'ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y ja hora re' tak re Jesús cof xch'o y xubij pa kach'abal yoj re yoj israelitas: Eloi, Eloi, ¿lama sabactani? xcha'. Y re xubij ndel che tzij: Nu-Dios yen, nu-Dios yen, ¿anchique roma tak xinamalij can? ");
INSERT INTO cakYNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y jec'o re jec'o-apo chire' chunakaj re Jesús, tak xquic'axaj re xubij, xquibila' chiquivach: ¿Xic'axaj? Reja' ja re Elías re nrayoj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y jare' tak c'o jun re jonanin xbo'rc'ama-pa jun ancha'l bo'j re nibex esponja cha. Xumuba' chupan vinagre, xuya' chutza'n jun aj y xuya' cha re Jesús chin che otz ba' nuna-ka cha re nichake'j ruchi', y xubij: Takayabej-na c'a, k'alaj re' vo xa xtipa re Elías chukasasic, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Can jare' tak re Jesús cof xch'o y xcom. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y re utzulaj tziak re anchok cha tason-va rupan re rachoch re Dios, ca'e' xel-va. Xutz'am-pa pa rue' c'a charakan-ka. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Y chire' chach re Jesús c'o-apo re capitán quichin re soldados. Reja' xuc'axaj tak re Jesús cof xch'o, y jare' tak xcom, mare' re capitán xubij: Can katzij-va che re ache re' Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y jec'o chuka' ixoki' re ye'tzu'un-apo, pero c'ac'anaj jec'o-va-a. Chiquicojol re ixoki' re' c'o-va re María Magdalena, re María quite' re José y re Jacobo re más co'ol y c'o chuka' re jun ixok rubini'an Salomé. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Re ixoki' re', can c'a c'o re Jesús pa Galilea tak je'tzakatal chij y quivilim-pa. Y chuka' can jec'o nic'aj chic ixoki' je'tzakatal-apo chij re Jesús pa Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Re k'ij tak xcom re Jesús, jare' tak re vinak niquibanala' chic rubanic ronojel re xtoc chique chupan re ruca'n k'ij, roma re ruca'n k'ij xa chin uxlanen. Y ja tak xk'ak'ij-yan-ka chupan re k'ij tak xcom re Jesús, ");
INSERT INTO cakYNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","jare' tak xapon jun ache rubini'an José, y reja' aj pa tenemit Arimatea. Reja' jun ache quichibil re achi'a' re pa camon ye'bano juzgar, y reja' camas ruk'ij chiquicojol reje'. Reja' jun ache re can ruyaben c'a jampa' tak re Dios xtuban gobernar. Y reja' xapon riq'uin re Pilato chupan re hora re', chuc'utuxic re ru-cuerpo re Jesús chin numuk. Re José man xuxibij-ta-ri' tak xba chuc'utuxic re ru-cuerpo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pero re Pilato man nunimaj-ta che can cha'nin-yan xcom re Jesús. Mare' reja' xrayoj re capitán, y xuc'utuj cha vo xa katzij che quiminak chic re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y tak re capitán xubij che katzij xcom-yan re Jesús, c'are' re Pilato xuya' k'ij cha re José che no'rmuku' can re ru-cuerpo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y re José xulok' jun sábana. Y tak rukasan chic-pa re ru-cuerpo re Jesús cho cruz, xupis chupan re sábana re'. Y c'are' xba chumukic pa jun jul quichin anama'i' re c'oton chach jun peña. Y xutz'apij can ruchi' re jul cha jun aboj. ");
INSERT INTO cakYNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y re María Magdalena y re María re quite' re José y re Jacobo, xquitz'at jabal anche' xmuk-va can re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y tak k'axnak chic re k'ij chin uxlanen, re María Magdalena, re María quite' re José y re Jacobo, y chuka' re ixok rubini'an Salomé xbequilok'ola-pa ak'om re jubul-oc ruxla'. Y re ak'om re' ndoc chique chin ne'quiya' can chij re ru-cuerpo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y namak'a-yan chupan re nabey k'ij cha re semana, xe'ba chuchi' re jul re anche' xmuk-va re Jesús, y tak xe'bapon chire' nitzu'un chic re k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y reje' xquibila' chiquivach: ¿Y anchique c'a xtilisan-a re aboj tz'apebal-ruchi' re jul chakavach? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero tak xquitz'at re jul, xa jakal. Re moma' aboj re anchok cha tz'apin-va can ruchi' re jul, xa elisan chic-a. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y tak reje' je'aconak chic-apo chupan re jul, xquitz'at che c'o jun ancha'l c'ajol-ala', tz'uyul pa rajquik'a' re anche' xli'e-va re Jesús, rucusan jun tziak sak re napon c'a charakan-ka. Y re ixoki' tak xquitz'at re', xquixibij-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero reja' xubij chique: Man tixibij-ivi'. Roma yen can ntaman che yex nicanoj re ru-cuerpo re Jesús aj-Nazaret, re xquimisas cho cruz. Reja' xc'astaj-yan-a, xa manak chic vova'. Titz'eta' anche' xc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vocame quixbiyin, y te'ibij cha re Pedro y chique re nic'aj chic ru-discípulos re Jesús. Te'ibij chique che re Jesús xtinabayaj-a chivach, chin nic'ul-ivi' chila' pa Galilea. Y chire' xtitz'at-va, can ancha'l re rubin can chiva. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y re ixoki' xe'el-a chire' pa jul, pero can ye'barbot roma quiximbire'. Je'anomojnak-a. Can man jun anchok cha xquitzijoj-va, roma camas quixibin-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tak re Jesús xc'astaj chupan re namak'a' chin re nabey k'ij chin re semana, nabey xuc'ut-ri' chach re María Magdalena, re ixok re anchok riq'uin xulisaj-va vuku' itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y re María Magdalena can jare' xba y xbo'rbij chique conojel re je ruchibil re Jesús. Reje' camas ye'bison y quitz'amon ok'ej. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero tak reje' xquic'axaj che re Jesús xc'astaj-yan y che re María Magdalena xutz'at-yan can rach, xa man xquinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Y c'are' re Jesús xuc'ut-ri' chiquivach je ca'e' achi'a' tak quitz'amon-a bey chin ye'ba pa jun aldea. Pero roma re Jesús jun chic-va nitzu'un tak xuc'ut-ri' chiquivach, mare' man cha'nin-ta xquitamaj rach. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Re je ca'e' achi'a' re' xbequibij chuka' chique re nic'aj chic ruchibil re Jesús, pero chuka' man xe'nimax-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Y tak xbanataj-yan ronojel re', jare' tak re Jesús xuc'ut-ri' chiquivach re je once ru-discípulos, y tak re Jesús xuc'ut-ri' chiquivach ja tak quitz'amon va'in y jare' tak xubij chique: ¿Anchique roma tak man xiban-ta confiar-ivi' y can xicoversaj re ivánma? xcha' chique. Quire' xubij chique re ru-discípulos roma man xe'quinimaj-ta re xe'tz'eto chin re Jesús che xc'astaj-yan chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xubij chuka' chique: Quixbiyin chach re ruch'ulef y titzijoj re utzulaj ch'abal chin re Dios chique conojel re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Re vinak re niniman re utzulaj ch'abal chin re Dios y nuban chuka' bautizar-ri', xticolotaj. Jac'a re vinak re man xque'niman-ta, xtika re castigo pa quive'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Re xque'niman vichin, q'uiy cosa xque'quibanala' chin nik'alajin che can yinc'o-va quiq'uin. Pa nube' yen xque'quilesala' itzel tak espíritu y xque'ch'o nic'aj chic ch'abal re man je'quitamalon-ta. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Reje' chuka' astapa' xque'quitz'am itzel tak cumatz y xque'quitijla' itzel tak ak'om, man jun andex xtuban chique. Xtiquiyala' chuka' quik'a' pa quive' yava'i' y xque'c'achoj. Q'uiy c'a cosas re xque'quibanala' reje', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tak re Ajaf Jesús xch'o-yan can chique re ru-discípulos, xba. Y chila' chicaj xc'ul roma re Dios, y xtz'uye-apo pa rajquik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y re discípulos xe'el che naj che nakaj, xquitzijoj re ruch'abal re Dios. Y re Ajaf can c'o-va quiq'uin chin ye'ruto' y chuka' can xuban chique che q'uiy milagros xe'tiquir xquibanala', chin che xk'alajin che can ja-va re ruch'abal re Dios re niquitzijoj. Amén.");
INSERT INTO cakYNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Je q'uiy quitijon quik'ij chin niquitz'ibaj che ja'jun che ja'jun re cosas re xe'banataj chakacojol pa ru-tiempo re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y tak xquitz'ibaj, can ancha'l-va re xtzijos chaka, coma re xe'tz'eto chin ronojel re xuban re Jesús. Y re xe'tz'eto re xbanataj, reje' can xquitzijoj chuka' re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y yen chuka' ninjo' nintz'ibaj re xbanataj. Can xintaj nuk'ij chin xintamaj ronojel re xe'banataj. Y jare' re ninjo' nintz'ibaj che ja'jun che ja'jun chava rat namalaj Teófilo, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chin quire' natamaj che can katzij-va re c'utun chavach chij re Jesucristo. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chire' pa Judea xc'ue' jun sacerdote xubini'aj Zacarías, y xc'ue' c'a quiq'uin jun grupo sacerdotes re quibini'an Abías. Pa ru-tiempo re Zacarías, ja re Herodes re Rey chire' pa Judea. Re ruxayil re Zacarías rubini'an Elisabet. Re Elisabet jun rey-rumam can re namalaj sacerdote re xubini'aj Aarón. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Re Zacarías y re Elisabet choj re quic'aslen chach re Ajaf Dios, y niquinimaj rutzij. Can niquiban-va re nubij. Y man jun vinak itzel nich'o chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Re je ca'e' vinak re' man jun cajc'ual, roma re Elisabet man nic'ue-ta ral. Y che je ca'e' camas chic je re'j. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Y c'o jun k'ij tak re Zacarías y re je ruchibil xbeka re qui-turno chin niquiban re samaj chire' pa rachoch re Dios como sacerdote. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Cada jun chique re sacerdotes jun-va che samaj niquiban pa rachoch re Dios. Y re qui-costumbre re sacerdotes ja re niquiban sortear re anchique niparon re pom. Y re k'ij re' pa rue' re Zacarías xka-va re suerte che ja reja' re ndoc pa rachoch re Dios chin no'rparoj re pom pa rue' re altar. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y tak re Zacarías ntajin chuparoxic re pom, conojel re vinak jec'o pa fuera ye'tajin cha oración. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Jac'a tak re Zacarías c'o chire' nuparoj re pom, jare' tak xuc'ut-ri' jun ángel chach, jun ángel chin re Ajaf Dios. Y re ángel re' xpa'e' pa rajquik'a' re altar re anche' niparox-va re pom. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tak re Zacarías xutz'at re ángel re', xsatz ruc'o'x y xuxibij-ri' ");
INSERT INTO cakYNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero re ángel xubij cha re Zacarías: Man taxibij-avi'. Re Dios xuc'axaj re a-oración. Re Elisabet re avxayil xtic'ue' jun ral, y Juan rube' xtaya'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Y roma re ac'ual re' camas xtiqui'cot re avánma y chuka' camas je q'uiy vinak xque'qui'cot. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Roma re avajc'ual camas ruk'ij xto'rbana' chach re Dios. Man xtukum-ta vino, y ni xe-ta nic'aj chic clase ya' re nuban cha jun vinak che nik'abar, roma tak xtalax can nojnak-va-pa re ránma riq'uin re Espíritu Santo. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y xtuban chique je q'uiy avinak israelitas chin niquinimaj re Ajaf Dios y nijalataj re quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Re Juan re' xtinabayaj chach re Cristo chin ye'ruban preparar re vinak anche' xte'ka-va re Cristo. Reja' can xtic'ue' re Espíritu Santo y re poder riq'uin, ancha'l xc'ue' riq'uin re Elías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Reja' xtuban chique re te'ej-tata'aj chin ye'quijo' re cajc'ual, y chuka' xtuban chique re vinak re man ye'niman-ta tzij che tiquinimaj tzij y che niquic'uaj jun c'aslen choj ancha'l quic'uan re vinak choj quic'aslen. Quire' xtuban-apo chique re vinak chin ye'ruban-apo preparar, chin quire' re vinak re' xe chic niquiyabej-apo re Ajaf. Quire' xubij re ángel cha re Zacarías. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y re Zacarías xuc'utuj cha re ángel: ¿Ancha'l tak xtintamaj yen che katzij o man katzij-ta re nabij chua? Roma yen y re vaxayil xa yoj rejeta'k tak vinak chic, y man ye'c'ue-ta chic kajc'ual, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y jare' tak re ángel xubij cha: Ja yen re ángel re nbini'an Gabriel, y can nimban re nubij re Dios chua. Mare' xinrutak-pa aviq'uin chin che ne'nya' jun noticia otz chava. Y re noticia re', ja che xtic'ue' re avajc'ual. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y roma man xanimaj-ta re ximbij chava, vocame xcamemur, y xcach'o chic jun bey c'aja tak xtalax re avajc'ual. Y ronojel re' xtibanataj, c'aja tak xtapon re tiempo, xcha' re ángel. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tak re ángel ntajin che tzij riq'uin re Zacarías, re vinak re je'yabeyon richin, niquibila': ¿Andex como xuban re Zacarías roma man ndel-ta-pa pa rachoch re Dios? ");
INSERT INTO cakYNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y tak re Zacarías xel-pa, man nitiquir-ta nich'o chique re vinak, roma xmemur. Mare' re je'yabeyon richin, cha'nin xquinabej che c'o jun cosa re xsekresas-pa chach chire' pa rachoch re Dios. Re Zacarías xaxe riq'uin ruk'a' nuban-va señas chiquivach re vinak, roma xmemur. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y tak reja' xuq'uis can re jenipa' k'ij chin re ru-turno chire' pa rachoch re Dios, xba charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ca'e-oxe' k'ij tibanataj-va quire' pa rachoch re Dios, tak re Elisabet re ruxayil re Zacarías xunabej che c'o chic yabil chij, y mare' vo'o' ic' man jun anche' xel-va. Re Elisabet nubij: ");
INSERT INTO cakYNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Vocame re Vajaf Dios xtuya' c'a re ac'ual re' chua, chin che yen man chic yinq'uex-ta chiquivach re vinak re yinquiyok' roma man jun val. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jac'a tak re Elisabet ne'copej vaki' ic' re ruyabil, jare' tak re Dios xutak re ángel Gabriel pa jun tenemit rubini'an Nazaret, re tenemit re' chin re Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Re ángel Gabriel xtak riq'uin jun ixok rubini'an María. Re ixok re' man jun bey runimon-ta-ri' riq'uin ache. Re ixok re' c'utun chic chin nic'ule' riq'uin jun ache rubini'an José. Y re José rey-rumam can re Rey David. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Re ángel xapon riq'uin re ixok re' y xubij cha: ¡Tiqui'cot c'a re avánma, roma camas yatrajo' re Ajaf Dios! Y re Ajaf Dios c'o aviq'uin. Y chiquicojol conojel re ixoki', ja rat re c'o más bendición xac'ul. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y tak re María xutz'at re ángel y xuc'axaj re xubij cha, xsatz ruc'o'x y xunojij-ka pa ránma: ¿Anchique roma tak quire' nuban chin nuya' ruxnokil-noch? ");
INSERT INTO cakYNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Entonces re ángel xubij: Man taxibij-avi' María. Rat can xac'ul re utzil pitinak riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vocame nimbij can chava che xtic'ue' jun ac'ual aviq'uin, y tak xtalax re ac'ual re', ala' y Jesús rube' xtaya'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Reja' camas ruk'ij xtic'ue', y xtubini'aj chuka' Ruc'ajol re namalaj Dios roma can katzij-va che Ruc'ajol re Dios. Re ac'ual re xtic'ue', jun rey-rumam can re Rey David, y re Ajaf Dios xtiyi'o can Rey, chin xtuban gobernar ancha'l xuban gobernar re Rey David ajuer can, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chin quire' re Jesús nuban gobernar pan ive' yex re yix rey-rumam can re Jacob. Y yixruban gobernar chin nojel tiempo, xcha' re ángel cha re María. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y tak re María xuc'axaj ronojel re', xuc'utuj cha re ángel: ¿Y ancha'l c'a tak xtic'ue' val, roma yen manak ache viq'uin? ");
INSERT INTO cakYNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y re ángel xubij cha re María: Ja re ru-poder re Espíritu Santo chin re namalaj Dios re xtika-pa pan ave' chin xtuya' re yabil re' chavij. Mare', re lok'olaj ac'ual re xtalax aviq'uin, can xtubini'aj-va Ruc'ajol re Dios roma can katzij-va che Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y nimbij chuka' chava che re avch'alal Elisabet re camas chic re'j y niquibij cha che camanak-va ac'ual nic'ue' riq'uin, vocame xtic'ue' jun ac'ual riq'uin, roma vaki' ic' c'o-va cha re ruyabil, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","roma re Dios man jun cosa c'ayef chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Can jare' tak re María xubij: Can njachon-vi' pa ruk'a' re Ajaf. Can tibanataj c'a ancha'l re xabij chua, xcha' re María cha re ángel. Y re ángel xel-a chire' riq'uin re María, y xba. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Y re María cha'nin xuban-a rubanic chin xba pa jun tenemit re c'o pa rue' jun loma chin re departamento rubini'an Judea. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y tak xapon chire' pa tenemit, reja' xba charachoch re Zacarías chin xbo'rya' ruxnokil-rach re Elisabet. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tak re Elisabet xuc'axaj re ruxnokil-rach re xuya' re María, reja' xuna' che can xsilon re ac'ual chupan. Y tak re Elisabet nojnak chic ránma riq'uin re Espíritu Santo, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","can riq'uin ruchuk'a' xch'o, y xubij: Chakacojol yoj ixoki', ja rat re nac'ul jun namalaj bendición chin re Dios, y quire' chuka' nuc'ul re ac'ual re xtalax aviq'uin roma can katzij-va Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Y mare' yen can man nak'ax-ta pa nue', anchique roma tak naya' nuk'ij yen y nac'utuj ruxnokil-noch rat re yat rute' re Vajaf. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Y can xe xinc'axaj re ach'abal tak xaya' ruxnokil-noch, re ac'ual nyaben chin nalax viq'uin, can xsilon xina', roma xqui'cot-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Otz-abanoj che xanimaj re xubij re Ajaf chava, roma re ac'ual re xubij chava che xtalax aviq'uin, can xtalax-va aviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y jare' tak re María xubij: Yen can riq'uin ronojel vánma ninya' ruk'ij re Ajaf. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Re vánma niqui'cot roma re Dios re nicola vichin. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Roma re Dios xinrucha' yen chin ninc'ul re utzil c'o riq'uin, astapa' yen xa camanak nuk'ij. Roma yen xa yin relic-oc jun samajel chin re Dios. Y re tiempo re xtiba-apo, re vinak xtiquibij che camas otz nbanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Roma re Dios q'uiy namalaj tak utzil rubanom-pa chua, roma can nitiquir-va nuban ronojel cosas. Y reja' can Lok'olaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Can nujoyovaj c'a quivach conojel re vinak re ya'lax chach re ruch'ulef re niquinimaj rutzij y can niquiya' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Y riq'uin re ru-poder, can q'uiy c'a cosas rubanalon. Reja' rukasan quik'ij re niquinojij pa tak cánma che camas quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rukasan quik'ij re ye'bano gobernar chach re ruch'ulef y ruyi'on más quik'ij re manak quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Jac'a re biyoma' re niquina' che can c'o ronojel quiq'uin, man jun cosa xuya-a chique, xaxe tal choj quire' xe'tak-a. Jac'a re nich'umun quipan, re Dios can ruyi'on c'a ronojel re nic'atzin chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Reja' yojruta'on yoj re yoj israelitas re yojrucha'on chin nakaban re rusamaj. Man jun bey yojrumistan-ta can y can rujoyovan-va kavach, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","roma can quire' re rusujun can chique re kavinak xe'c'ue' ajuer can, re rusujun can cha re Abraham y chaka yoj re yoj rey-rumam re Abraham. Re Dios can man jun bey xtumistaj-ta re rusujun can. Quire' xubij re María. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y re María xc'ue' can riq'uin re Elisabet como oxe' ic', y c'are' xtzolaj charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tak xapon re k'ij chin xalax re ac'ual riq'uin re Elisabet, jun ch'et ala' re xc'ue' riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y re ru-vecinos re Elisabet y re ruch'alal xquic'axaj che re Ajaf can xujoyovaj rach re Elisabet, mare' xc'ue' jun ral. Y re vinak xe'bapon riq'uin, camas ye'qui'cot chij re Elisabet, roma quire' xuban. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y tak xtz'akater vakxaki' k'ij talax-va re ac'ual, re ru-vecinos y re ruch'alal xe'bapon chic jun bey chin ne'quibana' re circuncisión cha, ancha'l nubij chupan re ru-ley re Moisés. Y ja mismo k'ij re' niquijo' niquiya' rube' re ac'ual, y re rube' niquijo' niquiya' ja ancha'l rube' re rutota'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero re te'ej xubij: Re ac'ual man xtubini'aj-ta ancha'l rube' re rutota', re ac'ual re' xtubini'aj Juan. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y re vinak re jec'o quiq'uin re Elisabet xquibij cha: ¿Anchique roma najo' che re ac'ual nubini'aj Juan? Roma man jun chique re avch'alal rubini'an quire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Entonces re vinak re jec'o chire' xquiban señas chach re tata'aj, chin niquic'utuj-apo cha, che andex rube' nuya' re ac'ual. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Xpa re tata'aj xuc'utuj jun tz'alam re ye'quicusaj chin ye'tz'iban chach. Chach re tz'alam re' xutz'ibaj: Re ac'ual xtubini'aj Juan. Y conojel re vinak re quimalon-apo-qui' chire', xsatz quic'o'x, roma re be'aj xubij re te'ej, jare' chuka' xutz'ibaj re tata'aj chach re tz'alam. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Can jare' tak re Zacarías xtiquir xch'o chic jun bey. Y reja' can xe xch'o, can jare' xutz'am ruyi'ic ruk'ij re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y re qui-vecinos re jec'o chire' xquixibij-qui', roma re xbanataj chire'. Y re xbanataj, xba rutzijol chupan ronojel re tenemit re jec'o chunakaj re tenemit anche' c'o-va re Zacarías chupan re departamento chin re Judea. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y conojel re vinak re ye'c'axan re xbanataj quiq'uin re Zacarías y re Elisabet, can xc'ue-ka riq'uin cánma, y niquibij: ¿Andex che samaj xto'rbana' re ac'ual re'? ye'cha'. Roma can k'alaj che c'o re Ajaf Dios riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Y jare' tak re Zacarías re rutota' re ac'ual, can nojnak ránma riq'uin re Espíritu Santo, xusekresaj chiquivach: ");
INSERT INTO cakYNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Camas-ta xtiya' ruk'ij re Ajaf Dios, re ka-Dios yoj re yoj israelitas, roma yojrunataj-pa yoj re yoj rutenemit, y yojrucol. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Re Dios ruyi'on c'a Jun re camas ru-poder y yojrucol. Y re nicola kachin re', jun rey-rumam can re David re rusamajel re Dios xc'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Re Dios xbin chique re lok'olaj tak rusamajela' re xe'c'ue' ajuer can, re xbex profetas chique, chin che xtiquibij re xubij reja' chique y re profetas ja quire' xquibij che re Dios xtuya' Jun re nicola kachin. Y re' can ajuer tusuj-pa chaka. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Can rubin-va-pa che xkojrucol chiquivach re itzel yojquitz'at, y xkojrucol pa quik'a' re je ka-enemigos, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y chuka' xtujoyovaj quivach re kavinak xe'c'ue' ajuer can, y can xtuban-va cumplir re namalaj trato re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Y re xsuj cha re Abraham can xban-va jurar cha roma re Dios, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","che can xkojrucol-va pa quik'a' re ya'tzalan kachin, chin quire' man nakaxibij-ta-ki' chin nakaban re rusamaj re Dios, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y nakaban riq'uin jun kac'aslen ch'ajch'oj y choj chach reja' re jenipa' tiempo yojc'ase-a chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y rat ch'et nuc'ajol, xtibex profeta chava roma xtatzijoj re xtibex chava roma re namalaj Dios, roma ja rat re xcabin chique re vinak che tiquichojmersaj rubey re quic'aslen, roma xa ba' chic che man tipa re Ajaf, ");
INSERT INTO cakYNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y ja rat xcabin che re Dios nucuy quimac re can je rutenemit, chin che ye'colotaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y re', xaxe roma re ka-Dios yojrajo' y camas nujoyovaj kavach. Mare' nutak-pa re Jun re ne'sekresan-ka chakavach re can ancha'l nuban re k'ij tak nitzu'un chach re ruch'ulef, quire' xtuban tak xtika-pa chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Re Jun re ne'sekresan-ka, xque'ruya' pa sakil re vinak re jec'o pa k'oko'm, re c'o chic re rumuch'uch'il re camic pa quive', roma manak qui-esperanza chin ye'colotaj-ta, y xkojruc'uaj chupan re bey re anche' otz nuna' re avánma. Quire' xubij re Zacarías. ");
INSERT INTO cakYNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y re ac'ual re xalax quiq'uin re Zacarías y re Elisabet, niq'uiy y quire' chuka' niq'uiy re ruc'aslen espiritual. Y tak nem chic, xba chupan re lugar re anche' manak vinak re nibex desierto cha. Y chire' xc'ue-va, c'aja tak xapon re k'ij chin xutz'am rutzijosic re ruch'abal re Dios chiquivach re israelitas re ruvinak reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ja tiempo re' tak re ache rubini'an Augusto César xulisaj jun orden chin niban jun tz'iban be'aj re nibex censo cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man jun bey banon quire'. Pero tak xban re nabey censo, ja re jun ache rubini'an Cirenio jare' re gobernador, chire' chupan re nación rubini'an Siria. Re Siria c'o pa ruk'a' re Augusto César. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y re vinak re jec'o chupan re nación Israel tiene que ne'quitz'ibaj quibe' c'a pa tak quitenemit. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y chire' pa Galilea c'o jun tenemit rubini'an Nazaret. Y chire' pa Nazaret c'o jun ache rubini'an José. Y re José tiene que no'rtz'ibaj rube' c'a pa tenemit Belén, roma re rate't-rumoma' je aj-chire'. Re Belén c'a pa Judea c'o-va. Chire' c'a pa Belén xalax-va re Rey David, y re José rey-rumam can re Rey David. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Y re José y chibil re María re ruxayil chic, xe'ba pa Belén chin ne'quitz'ibaj quibe'. Y re María xa niyavaj chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y chire' pa Belén jec'o-va tak xtz'akater ru-tiempo re María chin nic'ue' ral. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Y re nabey ac'ual xc'ue' riq'uin, ch'et ala'. Re María jabal xubolk'otij re ac'ual pa tziak, y xuliba' anche' ye'va-va re chicop re nibex establo cha. Chire' xe'c'ue-va roma chupan re jay re anche' niya-va posada manak chic lugar anche' ye'c'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Y chupan re ak'a' re' jec'o achi'a' re niquichajij qui-ovejas pa tak k'os chunakaj-apo re tenemit Belén. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jare' tak xuc'ut-ri' jun ángel chiquivach, pitinak chila' chicaj riq'uin re Ajaf. Y reje' camas xquixibij-qui' roma re ángel, y roma chuka' re namalaj sakil chin re Ajaf re xtzu'un pa quive'. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Y re ángel xubij chique: Man tixibij-ivi'. Tic'axaj re xtinya' rutzijol chiva, can xtuban chiva che camas xquixqui'cot. Y man xe-ta yex quire' xtina', xa can quire' chuka' xtiquina' conojel vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Chire' pa Belén, re rutenemit can re Rey David, vocame xalax re nicola quichin re vinak chach re quimac, y re' ja re Cristo re Ajaf. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Y chin che nitamaj che vo xa ja reja', k'alaj xtivel re ch'et ac'ual bolk'otin pa tziak y cotz'oban anche' ye'va-va re chicop re nibex establo cha, xcha' re ángel. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Can jare' tak más je q'uiy ángeles xe'bec'ulum-pa je'pitinak chila' chicaj. Y reje' niquiya' c'a ruk'ij re Dios, y niquibij: ");
INSERT INTO cakYNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Vocame, camas ruk'ij nuc'ul re Dios chila' chicaj! ¡Y vova' chach re ruch'ulef re vinak otz xtuna' re cánma roma xka-pa re utzil re rutakom-pa re Dios! ");
INSERT INTO cakYNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Can xe xquibij can quire' re ángeles, can jare' xe'tzolaj-a chila' chicaj. Y can xe xe'ba re ángeles, re ye'chajin ovejas can jare' xquibila-ka chiquivach: Jo-apo pa Belén. Takatz'eta' re andex xbanataj. Roma re Ajaf can xutak-pa rutzijol chaka. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y can cha'nin xe'ba c'a pa tenemit. Y tak xe'bapon, can xe'quivel-va re María y re José, y jac'a re ac'ual cotz'oban anche' ye'va-va re chicop. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Y tak reje' xquitz'at re ac'ual, xquitz'am rutzijosic re xbex chique roma re ángel, chij re ac'ual re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y conojel re vinak re ye'c'axan re niquitzijoj re ye'chajin re ovejas man niquivel-ta andex niquinojij, roma re nitzijos chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y re María can xe'ruyac pa ránma ronojel re xtzijos chach, y nunojij andex ndel-va che tzij. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Re ye'chajin ovejas, tak xe'tzolaj camas c'a niquiya' ruk'ij re Dios y chuka' niquibixaj rube'. Roma ronojel re xbanataj y xquitz'at, can ancha'l re xuya' rutzijol re ángel chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","C'amaje-na rutzijol nic'ue' re ac'ual riq'uin re María, tak jare' jun ángel xubij cha che re ac'ual re xtic'ue' riq'uin xtubini'aj Jesús. Y can ja-va quire' xubini'aj can re ac'ual tak c'aja vakxaki' k'ij talax-va. Y ja mismo k'ij re' tak xban re circuncisión cha, ancha'l nubij re ley chin re Dios che tiene que niban. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y tak xtz'akater re k'ij ancha'l nubij re ley chin re Dios re yi'on cha re Moisés, che re ixoki' re xc'ue' ac'ual quiq'uin tiene que niquijosk'ij-qui', re María tiene que xuban quire'. Y tak re María xba chin no'rjosk'ij-ri' pa rachoch re Dios chire' pa Jerusalén, re María y re José xquic'uaj-a chuka' re Jesús chin niquiban presentar pa rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quire' xquiban roma re ley chin re Ajaf Dios nubij: Vo xa ala' re nabey ac'ual nalax riq'uin jun ixok, can richin-va re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Y re María can xuya-va chuka' re ofrenda chin re najosk'ij-avi' ancha'l nubij chupan re ley chin re Ajaf Dios. Re ofrenda re xuya' reja' chach re Dios, je ca'e' palomas, roma re ley nubij: Re je meba' c'o modo niquiya' je ca'e' palomas je nima'k o je ca'e' cocoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chire' pa tenemit Jerusalén re tiempo re', c'o jun ache rubini'an Simeón. Re jun ache re', choj ruc'aslen y can nuya-va ruk'ij re Dios. Re Simeón, can c'o-va chuka' re Espíritu Santo riq'uin y chuka' reja' ruyaben re Cristo tak xtipa chin no'rcola-ka chupan re rumac y chiquicolic chuka' re nic'aj chic israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y re Espíritu Santo rubin chic cha re Simeón, che c'aja tak rutz'eton chic can re Cristo, re xtutak-pa re Ajaf Dios, c'ajare' xticom. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupan re k'ij tak re te'ej-tata'aj xquic'uaj re ac'ual pa rachoch re Dios chin niquiban ancha'l nubij re ley, ja chuka' k'ij re' tak xapon re Simeón pa rachoch re Dios, roma quire' xrajo' re Espíritu Santo. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Re Simeón xuli'ej re ac'ual, y chin xuya' ruk'ij re Dios, xubij: ");
INSERT INTO cakYNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, vocame xa can otz chic che yincom, roma re vánma otz nuna', roma can ancha'l re abin chua, can quire' xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Vocame can xintz'at-yan re Jun re pitinak aviq'uin rat re ne'cola-ka kachin chach re kamac, ");
INSERT INTO cakYNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","re xaya-pa chin ye'rucol conojel re vinak chupan re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja reja' chuka' re sakil quichin re vinak re man je israelitas-ta, roma ja reja' re xte'sekresan re abey chiquivach. Y yoj re yoj atenemit Israel, can chakacojol xalax-va reja', mare' q'uiy utzil xtakac'ul y xtic'ue' kak'ij, xcha' re Simeón. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Y re José y re María, can anchique-la xquina' tak xquic'axaj re xubila' re Simeón chij re ac'ual. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y jare' tak re Simeón xuya' ru-bendición pa quive' re José y re María. Tak re Simeón rubanon chic-ka quire', xubij cha re María: Tac'axaj re xtimbij chava, re ac'ual re', jun namalaj samaj yi'om-pa cha roma re Dios. Y roma reja', je q'uiy chique re kavinak israelitas xque'colotaj chach re quimac. Y je q'uiy chuka' re man xque'colotaj-ta, roma itzel xtiquitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Y riq'uin re quire' xtiquiban cha reja', xtik'alajin andex che cosas re c'o pa tak cánma. Y re Simeón xubij chuka' cha re María: Y tak xtatz'at ronojel re xtiban cha re Jesús, re avánma camas xtik'axo y can ancha'l jun espada re xtinim riq'uin re avánma xtana', xcho'x re María. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chire' pa rachoch re Dios c'o c'a jun ixok rubini'an Ana, re nutzijoj re nibex cha roma re Dios. Reja' rumi'al re jun ache xc'ue' ajuer can re xubini'aj Fanuel, y rey-rumam can re jun ache xubini'aj Aser re xc'ue' ajuer can. Re Ana c'a ba-oc rujuna' tak xc'ule'. Y xaxe vuku' juna' xquic'uaj-qui' riq'uin re ruchijil, roma xcom-a y vocame re Ana jun ixok malca'n y re'j chic, ");
INSERT INTO cakYNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","y man chic xc'ule-ta. Ochenta y cuatro chic rujuna', y nojel tiempo nic'ue' pa rachoch re Dios, che pak'ij che chak'a' nuya' ruk'ij re Dios chin nuban orar y chuka' nuban ayuno. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tak re Ana xutz'at re ac'ual Jesús, reja' xba-apo riq'uin. Y camas xutioxij cha re Dios roma re ac'ual re'. Y c'are' xutz'am c'a rutzijosic chij re ac'ual re' chique re vinak re je'yabeyon chin re nicola kachin chupan re kamac chire' pa Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Re José y re María xquiban ronojel re nubij chupan re ru-ley re Ajaf Dios, re tiene que niquiban tak c'a ba' talax jun ac'ual. C'are' xe'tzolaj pa Nazaret anche' c'o-va cachoch. Re tenemit re' chin re Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y re ac'ual niq'uiy y nic'ue' más ruchuk'a'. Reja' niq'uiy y nic'ue' más runa'oj, y re utzil re pitinak riq'uin re Dios c'o pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Re María y re José re je rute-rutota' re Jesús, ronojel juna' ye'ba pa tenemit Jerusalén chin ne'quik'asaj re namak'ij rubini'an pascua. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y tak xtz'akater-yan doce rujuna' re Jesús, jare' tak xe'ba-a pa Jerusalén chin ne'quik'asaj re namak'ij. Reje' xe'ba roma can quire-va qui-costumbre re quivinak israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tak k'axnak chic re namak'ij, re María y re José xe'tzolaj chacachoch. Pero reje' man c'a xquiya-ta cuenta cha che re ac'ual Jesús xc'ue' can chire' pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Reje' xquinojij che re ac'ual binak chiquicojol re vinak, y quire' xe'biyin jun k'ij. Pero tak xquinabej che re ac'ual manak, c'ajare' tak xquic'utula' rutzijol chique re je quich'alal y chique re vinak re quitaman quivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero tak man xquivel-ta re ac'ual chiquicojol re vinak, xe'tzolaj chic jun bey pa Jerusalén chin ne'quicanoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Y oxe' k'ij c'a tisatz-va can re ac'ual, c'ajare' tak xquivel. Y re anche' xquivel-va re ac'ual, ja pa rachoch re Dios chire' pa Jerusalén, tz'uyul pa quinic'ajal re achi'a' re je'atamayon re ley quichin re israelitas nuc'axaj-apo re niquibij y c'o preguntas chuka' re ye'rubanala' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y conojel re ye'c'axan-apo re nubij re ac'ual xsatz quic'o'x, roma ronojel re nic'utux-apo cha coma re achi'a' re je'atamayon re ley, re ac'ual can jabal nuban contestar chique. Re ac'ual can k'alaj che c'o na'oj riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Y tak re María y re José xquivel re ac'ual chire', can anchique-la xquiban xquina' tak xquitz'at anche' c'o-va y camas xe'qui'cot roma xquivel. Y jare' tak re rute' xubij cha: Val, ¿anchique roma tak xac'ue' can y man jun tzij xabij chaka? Re arta' y yen yatkacanoj y nik'axo re kánma roma man yatkavel-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y jare' tak reja' xubij chique: ¿Anchique roma xitz'am pena chin yinicanoj? Pa nutzij yen che yex itaman che ja re nrajo' re Nata' Dios jare' re tiene que nimban. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Jac'a re xubij re ac'ual chique re José y re María, man xk'ax-ta pa quive'. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Y c'are' re ac'ual xba chiquij chin xe'tzolaj chacachoch, c'a pa tenemit Nazaret. Roma re ac'ual can nunimaj-va quitzij re rute-rutota'. Y ronojel re xbanataj pa Jerusalén riq'uin re ac'ual, re María can xe'ruyac-ka pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y re tiempo binak, re Jesús niq'uiy, y quire' chuka' re na'oj re c'o riq'uin niq'uiy. Y re Dios camas otz nutz'at y quire' chuka' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Quince juna' tutz'am-va rubanic gobernar re ache rubini'an Tiberio César. Y pa ruk'a' c'a re Tiberio César xe'c'ue-va je caje' achi'a' re niquiban gobernar. Jun chique reje' rubini'an Poncio Pilato, y reja' chire' pa Judea nuban-va gobernar. Re jun chic, ja re Herodes re nuban gobernar chire' pa Galilea. Re jun chic, ja re Felipe re ruch'alal re Herodes, y reja' nuban gobernar pan Iturea y pa Traconite. Jac'a re jun chic nibano gobernar, ja re Lisanias, y reja' nuban gobernar pan Abilinia. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y ja chuka' tiempo re' tak re Anás y re Caifás je namalaj tak sacerdotes pa rachoch re Dios, chire' pan Israel. Jare' tak xch'o re Dios cha re Juan re ruc'ajol re Zacarías chire' chupan re jun lugar anche' manak vinak re nibex desierto cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y tak reja' xuc'axaj quire', xba chupan re lugares re jec'o chunakaj re rakan-ya' rubini'an Jordán. Reja' nubij chique re vinak re ye'bapon riq'uin che tijalataj quic'aslen chach re Dios y tiquibana' bautizar-qui', chin quire' re Dios nucuy quimac. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y re Dios can xuban-va re rubin can cha re Isaías, re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha, y re rutz'iban can reja' nubij quire': Xtic'ue' c'a jun ache chupan jun lugar re anche' manak vinak re nibex desierto cha, y ja reja' re xtitzijon re ruch'abal re Dios chiquivach re vinak re xque'bapon riq'uin. Y xtubila' chique: Tichojmersaj rubey re ic'aslen, roma re Ajaf xa can nipa-yan. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Y tak nichojmersas jun bey, nic'atzin che ye'muk re sivan, ye'kasas re lomas, re ruyalon vuelta nic'atzin che choj niban cha, y re tinitak li'on niban cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conojel vinak xtiquitamaj che c'o Jun re xtitiquir yojrucol chach re kamac, y re Jun re' riq'uin re Dios pitinak-va, quire' nubij chupan re libro re rutz'iban can re profeta Isaías re rusamajel re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y quire' c'a nubij re Juan chique re vinak re ye'bapon riq'uin chin che ye'ban-a bautizar: Yex can yix ancha'l itzel tak cumatz re yixnumaj chach re ruyoval re Dios re nika pan ive', roma nijo' yixcolotaj chach re namalaj castigo re xtutak-pa re Dios re tiempo pitinak. ¿Anchique xbin chiva che quire' tibana'? ");
INSERT INTO cakYNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Yex tiene que nic'ut che katzij xjalataj re ic'aslen chach re Dios. Y man tinojij-ka che xaxe roma yex can yix rey-rumam can re Abraham mare' xquixcolotaj, man quire-ta. Roma xe-ta re Dios nrajo', hasta re aboj re ye'tz'etela' vova' nuban chique che can-ta ye'oc rey-rumam re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Re castigo re nuya' re Dios nipa-yan. Reja' xtuban ancha'l nuban jun ache re ruc'uan chic ricaj chin che ye'rukasaj re che' re xa manak otz quivach niquiya'. Y ronojel re che' re xque'rukasaj xtunem quik'ak'al, xcha' re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y re vinak re ye'c'axan-apo chin re Juan, xquic'utuj cha: ¿Andex como ruc'amon che nakaban? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y re Juan xubij chique: Anchique chiva yex re c'o ca'e' rutziak, tuya' jun cha re manak rutziak. Y xabanchique chiva yex re c'o vay riq'uin, tuya' chuka' cha re manak ruay, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y jec'o-apo chuka' re achi'a' re je molay tak impuestos. Re achi'a' re' xe'bapon chin ye'ban bautizar, y xquic'utuj cha re Juan: Maestro, y yoj ¿andex re ruc'amon che nakaban? ");
INSERT INTO cakYNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Re Juan xubij chique: Xaxe re impuestos re bin chiva coma re autoridad, xaxe re' tic'utuj, y man tic'utuj más chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Y chuka' je'aponak je ca'e-oxe' soldados, y xquic'utuj-apo cha re Juan: Y yoj ¿andex ruc'amon che nakaban? Re Juan xubij chique: Man tilisaj qui-cosas re vinak, ya porque c'o autoridad pan ik'a'. Chuka' man titz'ucula' tzij chiquij. Xa quixc'ue' conforme riq'uin re mero re nich'ac. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y re vinak re jec'o-apo riq'uin re Juan, can quiyaben c'a che nubij-ta-pa anchique reja', roma niquinojij pa tak cánma che q'uiba' re Juan jare' re Cristo, pero xa mana-ta reja' re Cristo re bin che nitak-pa roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mare' re Juan xubij chique re vinak re jec'o-apo riq'uin: Yex nitz'at che yen yiximban bautizar riq'uin ya'. Pero c'o Jun re xtipa re tiempo pitinak xquixruban bautizar riq'uin re Espíritu Santo y riq'uin k'ak'. Re Jun re xtipa, c'o más ruk'ij y c'o más ru-poder que chinoch yen. Roma hasta xaxe chin che yen ninsol re ximibal-rach re ruxajab, can man ruc'amon-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Y can ancha'l nuban jun ache cha re ru-trigo tak nuban trillar, y tak xuban-yan trillar nuxipuj rach chin quire' rion re runak' re trigo nic'ue' can y nuyac y re rij nuparoj. Y ja quire' xtuban re Jun re xtipa, xcha' re Juan. Re Jun re xtipa c'o autoridad pa ruk'a', chin nuban juzgar pa quive' re vinak re jec'o chach re ruch'ulef. Re vinak re ye'niman richin, xque'ruc'uaj chila' chicaj. Jac'a re vinak re man ye'niman-ta richin, xque'rutak chupan re k'ak' re man nichup-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy tzij quire' xe'rucusaj re Juan chin xe'rupaxabaj tak xutzijoj re utzulaj ch'abal chin re Dios chique re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Re Juan xubij cha re gobernador rubini'an Herodes: Man otz-ta re atz'amon rubanic, roma aconak-ka avxayil re ixok rubini'an Herodías re ruxayil re avch'alal rubini'an Felipe. Re Juan xunataj re' cha re Herodes, y xe'runataj chuka' nic'aj chic rumac re je'rubanalon. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y re Herodes c'o más rumac xuban, roma xutz'apij re Juan pa cárcel. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y tak ntajin re bautismo quichin re vinak, xban chuka' bautizar re Jesús. Tak re Jesús ntajin che oración, jare' tak xjakataj re rocaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y re Espíritu Santo xka-pa pa rue' re Jesús ancha'l pa rubanic jun paloma. Y xc'axataj chuka' che nibex-pa cha chila' chicaj: Ja rat re Nuc'ajol, y yen camas yatinjo', y yinqui'cot aviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chupan re tiempo re', re Jesús c'o la'k treinta rujuna', jare' tak xutz'am re rusamaj. Y chiquivach re vinak, re Jesús can ruc'ajol-va re José. Re José ruc'ajol can re Elí. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y re Elí ruc'ajol can re Matat, y re Matat ruc'ajol can re Leví, y re Leví ruc'ajol can re Melqui, y re Melqui ruc'ajol can re Jana, y re Jana ruc'ajol can jun chic ache rubini'an José. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y re José ruc'ajol can re Matatías, y re Matatías ruc'ajol can re Amós, y re Amós ruc'ajol can re Nahum, y re Nahum ruc'ajol can re Esli, y re Esli ruc'ajol can re Nagai. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y re Nagai ruc'ajol can re Maat, y re Maat ruc'ajol can jun ache rubini'an Matatías, y re Matatías, ruc'ajol can re Semei, y re Semei ruc'ajol can jun ache rubini'an José, y re José, ruc'ajol can re Judá. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y re Judá ruc'ajol can re Joana, y re Joana ruc'ajol can re Resa, y re Resa ruc'ajol can re Zorobabel, y re Zorobabel ruc'ajol can re Salatiel, y re Salatiel ruc'ajol can re Neri. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y re Neri ruc'ajol can jun ache rubini'an Melqui, y re Melqui ruc'ajol can re Adi, y re Adi ruc'ajol can re Cosam, y re Cosam ruc'ajol can re Elmodam, y re Elmodam ruc'ajol can re Er. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y re Er ruc'ajol can re Josué, y re Josué ruc'ajol can re Eliezer, y re Eliezer ruc'ajol can re Jorim, y re Jorim ruc'ajol can jun ache rubini'an Matat. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y re Matat ruc'ajol can jun ache rubini'an Leví, y re Leví ruc'ajol can re Simeón, y re Simeón ruc'ajol can jun ache rubini'an Judá, y re Judá ruc'ajol can jun ache rubini'an José, y re José ruc'ajol can re Jonán, y re Jonán ruc'ajol can re Eliaquim. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y re Eliaquim ruc'ajol can re Melea, y re Melea ruc'ajol can re Mainán, y re Mainán ruc'ajol can re Matata, y re Matata ruc'ajol can re Natán. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y re Natán ruc'ajol can re David, y re David ruc'ajol can re Isaí, y re Isaí ruc'ajol can re Obed, y re Obed ruc'ajol can re Booz, y re Booz ruc'ajol can re Salmón, y re Salmón ruc'ajol can re Naasón. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y re Naasón ruc'ajol can re Aminadab, y re Aminadab ruc'ajol can re Aram, y re Aram ruc'ajol can re Esrom, y re Esrom ruc'ajol can re Fares, y re Fares ruc'ajol can jun ache rubini'an Judá. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y re Judá ruc'ajol can re Jacob, y re Jacob ruc'ajol can re Isaac, y re Isaac ruc'ajol can re Abraham, y re Abraham ruc'ajol can re Taré, y re Taré ruc'ajol can re Nacor. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y re Nacor ruc'ajol can re Serug, y re Serug ruc'ajol can re Ragau, y re Ragau ruc'ajol can re Peleg, y re Peleg ruc'ajol can re Heber, y re Heber ruc'ajol can re Sala. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y re Sala ruc'ajol can re Cainán, y re Cainán ruc'ajol can re Arfaxad, y re Arfaxad ruc'ajol can re Sem, y re Sem ruc'ajol can re Noé, y re Noé ruc'ajol can re Lamec. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y re Lamec ruc'ajol can re Matusalén, y re Matusalén ruc'ajol can re Enoc, y re Enoc ruc'ajol can re Jared, y re Jared ruc'ajol can re Mahalaleel, y re Mahalaleel ruc'ajol can jun ache rubini'an Cainán. ");
INSERT INTO cakYNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y re Cainán ruc'ajol can re Enós, y re Enós ruc'ajol can jun ache rubini'an Set, y re Set ruc'ajol can re Adán, y re Adán rajc'ual re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Re k'ij tak xban bautizar re Jesús, nojnak ránma riq'uin re Espíritu Santo xel-pa chupan re rakan-ya' Jordán. Y re Espíritu Santo xuban cha re Jesús che xba chupan re jun lugar anche' manak vinak re nibex desierto cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chire' xc'ue-va cuarenta k'ij, y ronojel re tiempo re' re itzel nutaj ruk'ij chij chin che nika-ta pa mac. Y chupan re tiempo re xc'ue' chire', man jun cosa xutaj. Mare' re Jesús xch'umun rupan. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y xpa re itzel xubij cha re Jesús: Rat nabij che yat Ruc'ajol re Dios. Tabana' cha re aboj re' che toc vay. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero re Jesús xubij cha: Tz'iban can chupan re ruch'abal re Dios che re ache man xe-ta riq'uin re vay nuvel-va ruc'aslen, xa can nuvel-va chuka' ruc'aslen riq'uin re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y jare' tak re itzel xuc'uaj-a re Jesús pa rue' jun loma re camas naj jotal, y xa pa jun rato xuc'ut ronojel naciones chin re ruch'ulef chach re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y c'are' re itzel xubij cha re Jesús: Yen ninjach pan ak'a' re quik'ij ronojel re naciones re' chin naban gobernar pa quive' y xabanchok cha ninya-va can, roma pa nuk'a' yen jachon-va can. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Y vo xa rat yaxuque' chinoch y naya' nuk'ij, ronojel c'a re' xtoc avichin, xcha' re itzel cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero re Jesús xubij cha: Cabiyin, y man chic quinanak rat Satanás. Roma chupan re ruch'abal re Dios re tz'iban can, nubij: Xaxe c'a re Kajaf Dios takaya' ruk'ij y xaxe chuka' reja' takabana' rusamaj, xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y c'are' re itzel xuc'uaj chic-a re Jesús c'a pa tenemit Jerusalén, y xuban cha che xjote-a c'a pa rue' re namalaj rachoch re Dios roma camas naj jotal chicaj. Y tak jec'o chic chire', re itzel xubij cha re Jesús: Tatorij-ka-avi' vova', rat re yabin che yat Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Roma chupan re ruch'abal re Dios re tz'iban can, nubij: Re Dios xque'rutak re ru-ángeles chin yatquichajij. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y xcatquili'ej pa quik'a', chin quire' man xtasoc-ta avakan chach aboj. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero re Jesús xubij cha re itzel: Yen can man nintojtobej-ta re Dios. Roma chupan re ruch'abal re Dios re tz'iban can nubij che man takatojtobej re Kajaf Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y tak re itzel man nuvel-ta chic andex nuban cha re Jesús chin nitzak pa ruk'a', xuya' can jun tiempo. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y re Jesús xtzolaj pa Galilea, y nojnak ránma riq'uin re ru-poder re Espíritu Santo. Y chupan ronojel re tenemit jec'o chunakaj re Galilea, xapon rutzijol re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y reja' nuc'ut c'a re ruch'abal re Dios pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y re vinak re ye'c'axan re nubij, camas c'a niquiya' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Re Jesús xba pa tenemit Nazaret, re anche' xq'uiy-va. Y chupan re k'ij chin uxlanen, reja' xba pa jun nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, roma reja' can quire-va tuban. Y tak c'o chic chire', reja' xpa'e' chin nuban leer re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y c'o c'a jun libro re xya-apo cha, chin nuban leer chiquivach re vinak re jec'o-apo chire'. Y re libro re xya-apo cha ja re rutz'iban can re Isaías re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y tak re Jesús xujak re libro, xuvel c'a re jun parte re anche' nubij-va: ");
INSERT INTO cakYNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Re Espíritu Santo richin re Ajaf Dios, c'o viq'uin yen, roma can xinrucha-va-pa chin nimbij re utzulaj ch'abal re nibex evangelio cha chique re vinak re meba' cánma chach re Dios. Xinrutak-pa chuka' chin ye'nk'omaj re vinak re nik'axo cánma pa ruk'a' re mac. Xinrutak-pa chuka' chin ye'nlisaj-a libres re vinak re jec'o preso pa ruk'a' re mac. Xinrutak-pa chuka' chin nimban chique re vinak ancha'l je moyi', che ye'tzu'un. Y xinrutak-pa chuka' chin ye'ncol re vinak re camas niquitaj pokan. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xinrutak-pa chuka' chin nimbij chique re vinak che ja tiempo re' tak re Ajaf Dios nuban re utzil re man jun bey rubanon-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y re Jesús xutz'apij re libro re xuban leer chiquivach re vinak re jec'o chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. C'are' xuya' can cha jun ache re nisamaj chire', y c'are' xbetz'uye'. Y re vinak niquitzu-niquitzu-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y reja' xch'o y xubij: Ja chupan re i-tiempo yex nibanataj-va re rubin can re Dios chupan re libro re', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y conojel re vinak re quimalon-apo-qui' chire', otz niquitz'at re Jesús y chuka' nika chiquivach re utzulaj tak ch'abal re xe'rubij chique, can anchique-la xquic'axaj, roma man jun bey quic'axan quire' ancha'l re xe'rubij chique. Y chuka' re vinak re' niquibila' chiquivach: Xa jare' re ruc'ajol re José, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y re Jesús xubij chic chique: Yen can ntaman re andex ninojij chuij roma nibij: Vo xa re Jesús re' can nitiquir-va ye'rubanala' milagros, man xe-ta pa tenemit Capernaum que'rubanala-va. Can que'rubanala' chuka' vova' pa rutenemit. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y chuka' xubij chique re quimalon-qui' chire': Re jun rusamajel re Dios re nibex profeta cha, man niquinimaj-ta tak napon pa rutenemit, roma aj-chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Y yen nimbij che yex itaman re xbanataj pa ru-tiempo re Elías re rusamajel re Dios re xbex profeta cha, tak oxe' juna' y nic'aj manak job xuban. Can katzij-va che je q'uiy malca'n tak ixoki' jec'o chupan re tiempo re' tak camas viyjal xpa pa rue' re ka-nación Israel. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero re Dios man xutak-ta re Elías pan Israel re rutenemit re Dios, chin che xuto-ta jun chique re malca'n tak ixoki' re jec'o chire'. Reja' xutak-a re Elías riq'uin jun malca'n-ixok re c'o c'a pa jun tenemit rubini'an Sarepta. Y re tenemit re' c'a chunakaj re tenemit Sidón c'o-va-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y can quire' chuka' xbanataj quiq'uin re xe'yavaj pa ru-tiempo re Elías re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Pa ru-tiempo re Eliseo, chire' pa nación Israel, je q'uiy re je'ac'ayon re jun yabil rubini'an lepra. Pero re Dios man xrajo-ta chuka' che c'o-ta jun re xc'achojsas cha re ruyabil ruc'alvachin, xaxe c'a re Naamán re xrajo' re Dios che xc'achojsas y reja' jun ache aj-Siria. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y re vinak re quimalon-apo-qui' chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, tak xquic'axaj re xubij-ka re Jesús chique, xyacataj quiyoval. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Y xe'beyacataj-pa, y xquilisaj-a re Jesús chuchi' re tenemit. Re jun tenemit re' chach jun loma c'o-va. Mare' re vinak xquic'uaj-a c'a pa rue' re loma chin ne'quichocomij-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero re Jesús choj xel-pa chiquicojol re vinak y xba. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'are' re Jesús xbeka pa tenemit Capernaum. Re tenemit re' c'o chupan re Galilea. Y chupan re k'ij chin uxlanen reja' xba pa nema-jay rubini'an sinagoga chin nuc'ut re ruch'abal re Dios chiquivach re vinak re quimalon-qui' chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y conojel re vinak re quimalon-qui' chire', can anchique-la xquina' tak xquic'axaj re enseñanza re nuc'ut re Jesús chiquivach, roma can riq'uin autoridad tak ye'rubila' re ch'abal y can ja re nubij reja' re tiene que niban. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, chire' chiquicojol re vinak c'o-apo jun ache re c'o jun itzel espíritu riq'uin. Y re itzel espíritu re c'o riq'uin re ache, jun pa ruchi' xuban tak xch'o, ");
INSERT INTO cakYNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","y xubij cha re Jesús: ¿Andex najo' chaka yoj, rat Jesús re yat aj-Nazaret? ¿Xapa chin che yojaq'uis? Yen ntaman yat anchique rat y mare' ntaman che rat can yat lok'olaj Ruc'ajol re Dios, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero re Jesús xubij cha re itzel espíritu: Ch'oj-achi'. Catel-a riq'uin. Y re itzel espíritu xutzak re ache pan ulef chiquicojol re vinak re quimalon-qui' chire'. Y re itzel espíritu choj xel-a riq'uin re ache. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y re vinak re quimalon-qui' chire', xsatz quic'o'x tak xquitz'at re xuban re Jesús, y niquibila' chiquivach: ¿Anchique como che autoridad c'o riq'uin re ache re'? Roma can riq'uin poder nich'o. Can natz'at che c'o autoridad pa ruk'a', roma ronojel re nubij, tiene que niban. Re itzel tak espíritu can niquinimaj rutzij y ye'el-a, ye'cha-ka re vinak chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y re vinak re jec'o chupan re lugares re jec'o chunakaj re tenemit Capernaum, xquic'axaj re ye'rubanala' re Jesús. Cha'nin c'a xba rutzijol re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupan re mismo k'ij re' re chin uxlanen, re Jesús xel-pa chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, y choj xba c'a charachoch re jun ru-discípulo rubini'an Simón. Y chupan re k'ij re' re rujete' re Simón niyavaj roma jun namalaj c'atan tz'amayon richin. Y re jec'o chire' pa jay xquic'utuj utzil cha re Jesús pa rue' re yava', che nuc'achojsaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y reja' xluque-ka riq'uin re ixok y xubij che tiq'uis-a re c'atan chij. Y can xe xubij quire' re Jesús, can jare' xq'uis-a. Y re ixok re', can jare' xbeyacataj-pa y xuya' quivay re Jesús y re je'binak chij. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tak xka-yan-ka re k'ij chupan re jun k'ij re' re chin uxlanen, conojel re vinak chin re tenemit, re jec'o yava'i' quiq'uin, xe'quic'uaj-apo chach re Jesús. Re yava'i' re xe'quic'uaj-apo re vinak re', q'uiy rach yabil ndoc chique. Cada jun chique re ye'yavaj, re Jesús xuya' ruk'a' pa quive' chin xe'ruc'achojsaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Je q'uiy chique re yava'i' re' xa itzel tak espíritu jec'o quiq'uin. Pero re Jesús xe'rulisaj-a chuka'. Y tak re itzel tak espíritu ye'el-a quiq'uin re yava'i', can jun c'a pa quichi' tak ye'ch'o y niquibij: Ja rat re Ruc'ajol re Dios. Y re Jesús xuban chique che man chic que'ch'o. Roma re itzel tak espíritu quitaman che re Jesús, jare' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y namak'a-yan ruca'n k'ij, re Jesús xel-a pa tenemit. Reja' xba chupan jun lugar anche' manak vinak re nibex desierto cha. Pero re vinak xe'ba chucanoxic re Jesús, y xbequivila-pa. Re vinak re' man niquijo-ta che niba re Jesús, reje' xquijo-ta xquik'at-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero re Jesús xubij chique: Yen tiene que yimba pa tak nic'aj chic tenemit, chin ne'ntzijoj re utzulaj ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios. Roma re' tak xintak-pa, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y ja quire' xubanala' re Jesús pa Galilea, can xutzijoj re ruch'abal re Dios pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun k'ij, tak re Jesús c'o chire' chuchi' re lago rubini'an Genesaret, camas je q'uiy vinak xe'bapon riq'uin, roma niquijo' niquic'axaj ruch'abal re Dios. Y camas je q'uiy re vinak, mare' camas niquipitz' re Jesús chin niquic'axaj andex nubij. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pero reja' cha'nin xutz'at-apo ca'e' canoas jec'o can chuchi' re ya', y man jun c'o chupan re canoas. Roma re je rajaf re canoas re' je tz'amoy tak car, y chupan re rato re', xa ye'quich'aj re quiya'l chapabal-car. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun chique re canoas re' chin re Simón. Y chupan ru-canoa re Simón xoc-va-a re Jesús. Y reja' xubij cha re Simón che que'biyin-apo ba' pa rue' re ya'. Y reja' xtz'uye-ka chire' pa canoa, y xutz'am ruc'utic ruch'abal re Dios chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tak re Jesús xtane-ka chuc'utic re ruch'abal re Dios chiquivach re vinak, reja' xubij cha re Simón: Jo-apo anche' más nem rupan re ya', y tiya-ka pa ya' re iya'l chin chapabal-car. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero jare' tak re Simón xubij cha re Jesús: Maestro, yoj jun ak'a' xojc'ase' chin xe'kacanoj car, y man jun xkatz'am. Pero vocame rat yabin che takaya-ka re ya'l chapabal-car pa ya', entonces nakaya-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y tak xquiya-ka re quiya'l pa ya', camas c'a je q'uiy car xe'oc chupan re ya'l, y mare' re ya'l xe'rokch'itaj-pa rach, roma calal re car re jec'o chupan. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mare' re achi'a' tz'amoy tak car xquiban-apo quik'a' chiquivach re nic'aj chic quichibil re jec'o pa jun chic canoa, chin que'pa chiquito'ic. Y can xe'po-va chiquito'ic. Y re ca'e' canoas xe'quinojsaj riq'uin re car re xe'quitz'am. Mare' re ca'e' canoas ba-ta chic ye'ba chuxe' ya'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y tak re Simón re nibex chuka' Pedro cha, xutz'at che jun milagro re xbanataj, reja' xbexuque' chach re Jesús, y xubij cha: Ajaf, yen xa yin jun ache aj-mac, man ruc'amon-ta che yac'ue-pa viq'uin, roma camas ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quire' xubij re Simón roma reja' man jun bey rutz'eton che quire-ta nibanataj. Y ja quire' chuka' xquina' re ruchibil re je'binak riq'uin. Reje' xsatz quic'o'x tak xquitz'at che camas je q'uiy car xe'quitz'am re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Re Jacobo y re Juan re je ruc'ajol re jun ache rubini'an Zebedeo, y chibil chuka' re Simón c'o quiq'uin, reje' xsatz quic'o'x tak xquitz'at re xbanataj. Mare' re Jesús xubij cha re Simón: Man tisatz ac'o'x roma re xatz'at. Re rubanom-pa yat jun ache tz'amoy-car, pero vocame mana-ta chic car re xca'tz'am, xa xtatamaj chuka' xca'tz'am vinak chin ye'tzake' chuij. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y re achi'a' tz'amoy tak car xe'quic'am-pa re qui-canoas chuchi-ya', xquiya' can re quisamaj y xe'ba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y tak re Jesús xapon pa jun chic tenemit, xapon jun ache riq'uin, re c'o jun yabil chij re rubini'an lepra. Re ache re', can xe xutz'at re Jesús, xbexuque' chach y xukasaj-ka re nic'aj-rach c'a pan ulef. Y xubij cha re Jesús: Ajaf, yen ntaman che yatiquir yinac'achojsaj cha re nuyabil, pero man ntaman-ta andex nanojij pa nue', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Y re Jesús can jare' xutz'am-apo re ache c'o lepra chij y xubij cha: Ninjo' che yac'achoj. Tiq'uis-a re yabil re' chavij. Y can xe xubij quire' re Jesús, can jare' xq'uis-a re lepra chij re ache. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Re Jesús xubij-a cha re ache re' che man tutzijoj chique re vinak che xac'achoj. Y xubij-a chuka' cha: Vocame choj cabiyin pa rachoch re Dios, chin ta'c'utu-avi' chach re sacerdote. Y taya' re ofrenda re nubij chupan re libro re rutz'iban can re Moisés. Chupan re libro re' nubij re nic'atzin che naya' rat, chin quire' niquitamaj che yat ch'ajch'oj chic, xcho'x-a re ache. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero re Jesús can chak binak rutzijol, y camas vinak ne'quimalo-qui' riq'uin. Jec'o vinak re ye'bapon riq'uin, chin niquic'axaj re ruch'abal re Dios. Y jec'o nic'aj chic ye'bapon riq'uin niquijo' che ye'c'achojsas-a cha re quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y reja' jac'a chupan re lugar re anche' manak vinak re nibex desierto cha, chire' nibo-va, chin no'rbana' orar. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y jun k'ij, jec'o achi'a' fariseos y chuka' re je'atamayon re ley quichin re israelitas xbequic'ulu-qui' anche' c'o-va re Jesús. Jec'o chique reje' re je'pitinak pa tak tenemit re jec'o chupan re Galilea. Jec'o je'pitinak pa tenemit Jerusalén y nic'aj chic tenemit re jec'o chupan re Judea. Re achi'a' re je'atamayon re ley quichin re israelitas y re fariseos, je'tz'uyul-apo chiquicojol re vinak re niquic'axaj re ruch'abal re Dios re nuc'ut re Jesús chiquivach. Y re Jesús can c'o ru-poder re Ajaf Dios riq'uin, chin ye'ruc'achojsaj re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y c'o c'a jun ache siquirnak ru-cuerpo ec'uan-apo chach camilla coma jun ca'e-oxe' achi'a'. Y reje' xquijo-ta xe'oc-apo pa jay anche' c'o-va re Jesús, chin niquiya' re yava' chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero re achi'a' re' man xe'tiquir-ta xe'oc-apo chupan re jay, roma camas je q'uiy vinak quimalon-qui' chire'. Mare' reje' xe'jote' pa rue' re jay, y xquivop rue'. Y re anche' xquivop-va-ka, can ja re anche' c'o-va re Jesús. Y chire' xquikasaj-va-ka re yava' chach ru-camilla. Re yava' re' can c'a chach re Jesús xbeka-va-ka, chire' chiquicojol re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y tak re Jesús xutz'at che reje' can quibanon confiar-qui' riq'uin reja', xubij cha re ache siquirnak ru-cuerpo: Re amac xe'cuyutaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Y re achi'a' je'atamayon re ley quichin re israelitas y re achi'a' fariseos, can xe xquic'axaj re xubij re Jesús, xquitz'am runojexic: ¿Anchique che ache re'? ¿Y anchique roma nuban che can ja reja' re Dios? ¿Anchique vinak nucuy amac? Man jun. Xaxe re Dios re nucuy amac, ye'cha' pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero re Jesús can rutaman re niquinojij re achi'a' re je'atamayon re ley quichin re israelitas, y rutaman chuka' re niquinojij re achi'a' fariseos. Mare' reja' xubij chique: ¿Anchique roma yex ninojij quire'? ");
INSERT INTO cakYNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Roma vo xa yen yintiquir nimban cha re jun ache re' re siquirnak ru-cuerpo, chin che nibiyin-a y niba, can yintiquir chuka' nimbij cha che nincuy rumac. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Y vocame, chin che yex nitamaj che yen re xinalax chi'icojol can c'o poder pa nuk'a' chin che nincuy mac, titz'eta' c'a, xcha' chique. Y jare' tak re Jesús xubij cha re ache siquirnak ru-cuerpo: Chava rat nimbij-va: Cayacataj y tac'uaj-a la a-camilla y cabiyin cha'vachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y chiquivach conojel vinak re quimalon-qui' chire' xpa'e-a re ache siquirnak ru-cuerpo. Y xuc'uaj-a re ru-camilla re anche' li'en-va-pa. Y re ache xtzolaj-a charachoch, nuya' ruk'ij re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y conojel re vinak re quimalon-qui' chire', xsatz quic'o'x, roma man jun bey quitz'eton che quire-ta nibanataj. Re vinak re' camas xquiya' ruk'ij re Dios, y xquibij: Chupan re jun k'ij re' xe'katz'at milagros re man jun bey je'katz'eton-ta. Pero tak reje' xquibij quire', quixibin-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Tak re Jesús xel-pa chire', xutz'at jun ache molay-impuestos. Re ache re' rubini'an Leví, y tz'uyul chach jun ch'acat, y ja cha reja' nitoj-va can re impuestos. Y re Jesús xubij cha: Jo' chuij. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y xe xuc'axaj quire' xbeyacataj-pa anche' tz'uyul-va, y xuya' can ronojel cosas re c'o chire' y xtzake-a chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y c'a ba' tibanataj-va quire', re ache rubini'an Leví xuban jun namak'ij charachoch. Y re namak'ij re' can chin-va re Jesús, pero chuka' xe'rayoj re nic'aj chic molay tak impuestos y chuka' nic'aj chic vinak. Y conojel c'a re vinak re' junan xe'tz'uye-apo chach mesa riq'uin re Jesús y chuka' re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y jec'o achi'a' re je'atamayon re ley quichin re israelitas y jec'o chuka' achi'a' fariseos re jec'o-apo chire' chiquicojol. Y re achi'a' re' q'uiy tzij ye'quibila-apo chique re ru-discípulos re Jesús. Y xquic'utuj chique: ¿Anchique roma tak yex yixva-yixuq'uia' quiq'uin re achi'a' molay tak impuestos y quiq'uin chuka' la aj-maqui'? ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero re Jesús xubij chique re achi'a' fariseos y re achi'a' re je'atamayon re ley quichin re israelitas: Jun doctor mana-ta re je otz ye'ruk'omaj. Reja' ye'ruk'omaj re c'o quiyabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Y mare' yen man ximpa-ta chiquicanoxic vinak re choj quic'aslen. Yen ximpa chiquicanoxic re c'o quimac, re nic'atzin che nijalataj quic'aslen chach re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Y re achi'a' fariseos y re achi'a' re je'atamayon re ley quichin re israelitas, xquic'utuj cha re Jesús: ¿Anchique roma tak re ye'tzekelben chin re Juan can quicha'on k'ij chin niquiban ayuno y oración? Y can quire' chuka' niquiban re ye'tzekelben quichin re achi'a' fariseos, pero re a-discípulos rat man quire-ta niquiban, xa ye'va-ye'uq'uia', xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y re Jesús xubij chique: Re je'banon invitar pa jun c'ulubic siempre ye'va', y yex man ruc'amon-ta niban chique che man ye'va-ta, roma re ala' xc'ule' c'o quiq'uin. Y quire' chuka' niquiban re nu-discípulos, reje' ye'qui'cot roma yinc'o quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xtapon re k'ij tak re ala' re' xtilisas-a chiquicojol, y c'ajare' tak xtiquiban ayuno. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chuka' re Jesús xucusaj re jun ejemplo re' chiquivach: Man jun vinak nicusan jun tziak c'ac'a, chin nuc'ajoj jun tziak re tzia'k chic. Roma vo xa c'o jun re nibano quire', c'ayef. Roma tiene que nuratz re tziak c'ac'a chin nulisaj jun c'ojobal, y re c'ojobal re' xa man nuc'am-ta re jun tziak re tzia'k chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y quire' chuka' man jun vinak niyi'o c'ac'a vino chupan jun tz'um tzia'k chic chin nuyac-apo. Roma re tz'um tzia'k chic man chic nuyuk-ta-ri', mare' vo xa niyac c'ac'a vino chupan re tz'um re' nurokch'ij-ri' y nitix-a re vino c'o chupan. Y re tz'um re' manak chic ndoc-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero chupan jun c'ac'a tz'um, otz niyac c'ac'a vino chupan, roma re tz'um re' nuyuk-ri' y man nurokch'ij-ta-ri'. ");
INSERT INTO cakYNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y man jun re nikumu vino re c'o-yan chic che tiempo tiyac-va-apo, xtirajo-ta xtukum re c'ac'a vino. Roma xtubij: Re vino re c'o-yan chic che tiempo tiyac jare' re más otz, xticha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Chupan jun k'ij chin uxlanen, re Jesús y re ru-discípulos xe'k'ax chupan jun ulef ticon trigo chach. Y re discípulos c'o rue-trigo xe'quich'upula-a y niquibil pa quik'a'. Y re runak' re trigo niquitaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Mare' jec'o chique re achi'a' fariseos xquibij chique re ru-discípulos re Jesús: ¿Anchique roma yex ye'ch'up rue' re trigo? Re k'ij re', k'ij chin uxlanen y xajan chin ye'banala' quire', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero re Jesús xch'o-apo chique y xubij: Yex can ibanon leer re tz'iban can chij re xquiban re David y re ruchibil ajuer can, tak camas xch'umun quipan. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Re David xba chucanoxic vay chire' pa rachoch re Dios, y ja re lok'olaj tak xcana-vay re xe'beya-pa cha. Re xcana-vay re' xaxe re sacerdotes re ye'tijo richin. Pero reja' xutaj, y chuka' xuya' chique re je'binak riq'uin. Pero astapa' reje' quire' xquiban manak quimac xel chach re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y re Jesús xubij chique re achi'a' fariseos: Re Rajaf re k'ij chin uxlanen ja yen re xinalax chi'icojol. Roma pa nuk'a' yen c'o-va chin nimbij andex otz che niban chupan re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chupan jun chic k'ij chin uxlanen, re Jesús y re ru-discípulos xe'ba pa jun nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, y xutz'am c'a ruc'utic re ruch'abal re Dios chiquivach re quimalon-qui' chire'. Y chiquicojol re vinak re' c'o jun ache chake'j jun ruk'a', y ja re rajquik'a' re chake'j. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Mare' jec'o chique re achi'a' je'atamayon re ley quichin re israelitas y jec'o chuka' achi'a' fariseos ye'tz'eto-apo chin re Jesús, a ver vo xa nuc'achojsaj re ache, chin quire' niquisujuj che re Jesús xsamaj chupan re k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero re Jesús rutaman re niquinojij pa tak cánma re achi'a' re je'atamayon re ley quichin re israelitas y re achi'a' fariseos. Y re Jesús xubij cha re ache chake'j ruk'a': Catak'ax-pa vova' pa nic'aj. Y re ache xbeyacataj-pa re anche' tz'uyul-va, y xbepa'e' anche' xbex-va cha roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpa re Jesús xubij chique re vinak re jec'o chire', che chupan jun k'ij chin uxlanen ja re utzulaj tak banabal re más ruc'amon che niban y mana-ta re itzel tak banabal. Y chuka' re más ruc'amon ja che nacol jun vinak chach re camic y man naya-ta k'ij cha che nicom, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y re Jesús xe'rutzu' conojel re quimalon-qui' chire'. Y chiquivach reje' xch'o cha re ache chake'j ruk'a', y xubij: Tayuku' la ak'a'. Y re ache can xe xuyuk re ruk'a' ancha'l re xbex cha roma re Jesús, can jare' xc'achoj re ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero re achi'a' re je'atamayon re ley quichin re israelitas y re achi'a' fariseos re jec'o-apo chire', xyacataj quiyoval. Y niquibila' chiquivach anchique niquinojij niquiban cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y jun k'ij re Jesús xba pa rue' jun loma chin xbo'rbana' orar. Y jun ak'a' xuban orar chin xch'o riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y tak xsakar-ka ruca'n k'ij, reja' xe'rayoj re achi'a' re can ye'tzekelben-va richin. Chiquicojol re achi'a' re', xe'rucha' je doce, y xubij chique che ye'oc apóstoles. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Re je doce re xe'rucha' re Jesús, ja re Simón re xubij chuka' Pedro cha, re Andrés re ruch'alal re Simón, re Jacobo, re Juan, re Felipe, re Bartolomé, ");
INSERT INTO cakYNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","re Mateo, re Tomás, re Jacobo re ruc'ajol jun ache rubini'an Alfeo, y re jun Simón re c'o quiq'uin re achi'a' re je richin re jun partido nibex cananista chique, ");
INSERT INTO cakYNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","re Judas re ruch'alal re Jacobo, y re Judas Iscariote re xjacho chin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y jare' tak re Jesús y re ru-apóstoles xe'ka-pa pa rue' re loma y xe'bec'ue-ka quiq'uin re nic'aj chic discípulos chire' pa jun lugar li'on. Y chire' camas chuka' vinak quimalon-qui'. Jec'o vinak je'pitinak pa tenemit Jerusalén y nic'aj chic tenemit re jec'o chupan re Judea, y jec'o chuka' je'pitinak c'a chuchi-mar quila pa Tiro y Sidón. Jec'o chique re vinak re' je'pitinak chin niquic'axaj re ruch'abal re Dios re nutzijoj re Jesús, y jec'o chuka' ye'yavaj je'pitinak chin ye'c'achojsas-a roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y jec'o chuka' vinak re niquitaj pokan pa quik'a' re itzel tak espíritu. Re Jesús xe'rulisaj-a chuka' re itzel tak espíritu re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y conojel re vinak re ye'yavaj niquijo' niquitz'am-apo re rutziak re Jesús, roma re vinak niquitz'at che c'o poder riq'uin chin nuc'achojsaj ronojel rach yabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y xpa re Jesús xe'rutzu' re ru-discípulos y xubij chique: Otz-ibanoj yex re meba' ivánma chach re Dios, roma can yixoc-va pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Otz-ibanoj yex re nich'umun ipan espiritualmente, roma re Dios xtuban chiva che xtich'uch'o' re ivánma. Otz-ibanoj yex re ndok' ivánma chach re Dios, roma xtuban chiva che man chic xquixok'-ta, xa xquixtze'en. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Otz-ibanoj yex re itzel yixtz'et coma re vinak, y chuka' re yixquilisaj-pa chiquicojol re anche' niquimol-va-qui' chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, yex re yixyok', yex re itzel yixtz'et roma iniman re nuch'abal, y ronojel tijoj-pokonal re' nicoch' xa voma yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y camas quixqui'cot, can quixropin y quixtzoq'uin tak yixtajin chuk'asasic ronojel re', roma nem rajal-ruq'uixel xtic'ul chila' chicaj. Roma quire' chuka' re tijoj-pokonal re xquik'asaj re je rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Reje' xquik'asala' tijoj-pokonal pa quik'a' re cate't-quimoma' re vinak re ye'tzelan ivichin yex vocame. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Y yex biyoma', can tivok'ex ivach, roma xik'asaj-yan jun c'aslen camas otz chach re ruch'ulef. Jac'a re k'ij re je'pitinak chivij man chic quire-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Yex chuka' re camas otz yixva', tivok'ex ivach, roma xtapon re k'ij tak manak chic ivay xtivel. Yex re yixtze'en vocame, tivok'ex ivach, roma xtapon re bis iviq'uin y xtuban chiva che xquixok'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y yex re camas ik'ij niya' coma re vinak re man quitaman-ta rach re Dios, xa tivok'ex ivach. Roma re vinak re' xa ja re man je rajc'ual-ta re Dios re niquiya' quik'ij, can ancha'l xquiban re quivinak xe'c'ue' ajuer can, xa xquiya' quik'ij re vinak re xe'bin che ja reje' re je rusamajela' re Dios re xquibini'aj profetas, y xa man je katzij-ta profetas. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero yex re yixc'o vova' viq'uin re yinic'axaj, tic'axaj re xtimbij chiva: Can que'ijo' re vinak re man otz-ta yixquitz'at, y re vinak re man otz-ta yixquitz'at xaxe re otz tak cosas tibana' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tibana' orar pa quive' re vinak re ye'rayin itzel tak cosas chivij, chin che nuya' ru-bendición re Dios pa quive', y chuka' can tibana' orar pa quive' re vinak re ye'quitz'uc tzij chivij. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y vo xa c'o jun nich'ayo avichin, man taya' ruq'uixel cha, xa taya-avi' chin yach'ay chic jun bey. Y vo xa c'o jun vinak numoj-a jun atziak, man tapokonaj re atziak xmoj-a chavach, xa taya' chic-a re ak'u' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xabanchique vinak c'o jun cosa nuc'utuj chava, taya' cha re nrajo'. Y vo xa c'o jun vinak c'o jun cosa numoj-a chavach, man jun bey chic c'a talisaj chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y ancha'l re nijo' che re vinak niquiban iviq'uin yex, quire' chuka' tibana' yex quiq'uin reje'. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Y vo xa yex xaxe re vinak re ye'jovan ivichin jare' re camas ye'jo', man otz-ta roma man jun rajkalen chach re Dios. Roma quire' chuka' niquiban re vinak re man quitaman-ta rach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Vo xa yex, xaxe chique re vinak re ye'bano utzil chiva, xaxe chique reje' niban-va utzil, riq'uin re quire' niban man otz-ta roma man jun rajkalen chach re Dios. Roma quire' chuka' niquiban re man quitaman-ta rach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Vo xa yex niya' jun cosa cha jun vinak pa kajic, roma nic'axaj che nitoj rukajbal chiva, man c'ayef-ta chin niban quire'. Roma re vinak re man quitaman-ta rach re Dios, quire' chuka' niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Jac'a yex man tiban quire'. Xa que'ijo' re vinak re man otz-ta yixquitz'at. Tibana' ronojel rach utzil chique. Y tak yex niya' pa kajic jun cosa, man c'a tiyabej re kajbal richin. Chin quire' nem re rajal-ruq'uixel xtic'ul, y xtik'alajin che yex can yix rajc'ual chic re namalaj Dios re c'o chila' chicaj. Reja' ye'rajo' y otz runa'oj quiq'uin re vinak re camas itzel quina'oj, y otz runa'oj quiq'uin re man jun bey niquitioxij-ta re nuya' chique. Quire' chuka' tibana' yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tijoyovaj quivach re vinak, can ancha'l nuban re Karta' Dios kaq'uin yoj nujoyovaj kavach. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man tiban che ye'tzu' re vinak y c'are' itzel yixch'o chiquij, chin che re Dios man xtuban-ta quire' chiva yex. Man tirayij chiquij re vinak che tiene que niquitoj re itzel tak banabal re ye'quibanala', y chuka' re Dios can man xtuban-ta quire' iviq'uin yex. Ticuyu' quimac re vinak y re Dios quire' chuka' xtuban chiva yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Vo xa yex riq'uin ronojel ivánma ye'to' re vinak riq'uin re ndoc chique chupan re quic'aslen, re Dios xtuya' rajal-ruq'uixel chiva. Re rajal-ruq'uixel re xtuya' re Dios chiva, camas q'uiy. Roma re anche' xtuya-va can re rajal-ruq'uixel, can xtipul rue'. Y can ancha'l re niban yex quiq'uin re vinak, can quire' chuka' xtuban re Dios iviq'uin yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y re Jesús xubij chuka' jun ejemplo chique: Man jun moy nitiquir nuyukej jun chic moy, roma vo xa quire' nuban, can che je ca'e' ye'betzak pa tak jul. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y quire' chuka' man jun vinak re tz'amon ruc'utic jun cosa chach roma re ru-maestro, c'o-ta más ruk'ij que chach re ru-maestro. Xa c'a nutamaj-na ronojel re nic'ut chach, c'are' ndoc ancha'l re maestro. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Rat can cha'nin natz'at re ch'et k'ayis c'o pa rach jun vinak y rat man nana-ta-ka-avi' che xa más nem re che' c'o pan avach rat. Re ejemplo re' ndel che tzij che man takabij che la jun vinak la' camas rumac, y jac'a re kamac yoj can nakaban che más ba-oc. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y chuka' man tabij cha jun vinak: Taya' k'ij chua chin ninlisaj-a re ch'et k'ayis re k'atarnak pan avach y man nana-ta-ka-avi' rat che xa más nem re che' k'atarnak pan avach. Re ejemplo re' ndel che tzij, che man tabij cha jun chic vinak che man chic camacun, tak rat xa c'a yamacun. Man naya-ta-ka pa cuenta re amac. Xa ca'e' apalaj. Nabey tachojmersaj re ac'aslen rat, c'are' otz nato' y nabij cha jun chic vinak che tuchojmersaj re ruc'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Y man jun utzulaj che' xtuya-ta rach man otz-ta. Chuka' man jun che' man otz-ta, xtuya-ta rach otz. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Re che' cha'nin nitz'et vo xa otz o man otz-ta, roma re rach nuya'. Roma re k'ayis camas quiq'uixal man xtiquiya-ta higo, y ni xe-ta uva. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y quire' chuka' re ache. Re ache otz ruc'aslen, ja re otz tak banabal jare' re nuban y nubij, roma ja re otz tak cosas nunojij pa ránma. Jac'a re mal ache, ja re itzel tak banabal nuban y nubij, roma can ja re itzel tak cosas re nisamaj pa ránma. Roma jun vinak ja re nunojij y re c'o pa ránma jare' re nubij y nuban. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y anchique roma tak yex nibij Ajaf, Ajaf chua, y xa man niban-ta re nimbij chiva? ");
INSERT INTO cakYNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mare' re vinak re nipa viq'uin chin yinrunimaj y nuc'axaj re nuch'abal y nuban re nimbij cha, ");
INSERT INTO cakYNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","junan riq'uin re jun ache re xuban jun rachoch. Nabey, xuban-ka re jul chin re cimiento y anche' xbo'rvila-va-ka aboj chire' xuya-va-ka re ru-cimiento re jay. Y tak xc'achoj-yan re jay, xbenimar-pa re rakan-ya'. Y re rakan-ya' re' xbo'rvila' re jay. Pero re jay man xsilon-ta, astapa' re rakan-ya' xnimar, y camas ruchuk'a' xuban roma pa rue' aboj xuban-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero re vinak re nuc'axaj re nuch'abal, y man nuban-ta re nimbij cha, junan riq'uin re jun ache re xuban jun rachoch, y manak ru-cimiento xuban. Y tak re rakan-ya' xbenimar-pa, xbo'rvila' re jay. Re jay re' xtzak y xq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tak re Jesús xtane' che tzij chiquivach re vinak, xba pa tenemit Capernaum. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chire' pa tenemit c'o jun ache capitán. Y re ache re' c'o jun ru-mozo y camas nrajo', pero niyavaj, y nicom-yan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y tak re capitán xuc'axaj re ye'bilox chij re Jesús, reja' xe'rutak jun ca'e-oxe' chique re rejeta'k tak achi'a' israelitas re c'o quik'ij, chin ne'quic'utuj utzil cha re Jesús che tipa chin nuc'achojsaj re ru-mozo. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y tak xe'bapon re rejeta'k tak achi'a' riq'uin re Jesús, xquic'utuj jun namalaj utzil cha, y xquibij: Can ruc'amon-va che rat naban re jun utzil re' cha re capitán, ");
INSERT INTO cakYNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","roma reja' camas yojrajo' yoj re yoj israelitas, y chuka' xuban jun nema-jay rubini'an sinagoga re anche' nakamol-va-ki' chin nakac'axaj re ruch'abal re Dios, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y re Jesús xba chiquij re rejeta'k tak achi'a' re je'takom-pa roma re capitán. Y tak re Jesús y re je'tzakatal chij ye'bapon-yan charachoch re capitán, re capitán xe'rutak-pa jun ca'e-oxe' ru-amigos, chuc'ulic re Jesús. Y re achi'a' re' xbequibij cha re Jesús: Ajaf, re ache re yojtakayom-pa cha'c'ulic rubim-pa re tzij re' chaka: Ajaf, man c'a taban molestar-avi' nutzij yen, yen xa yin jun aj-mac y mare' man ruc'amon-ta che rat yatoc-apo c'a chupan re vachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Roma ja quire' nina' yen, mare' can man ruc'amon-ta che can ja yen mismo re xinapon-ta aviq'uin. Rat xaxe c'a tabij che nic'achoj re ache nisamaj viq'uin, y xtic'achoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Y can ntaman-va che quire' xtibanataj, roma ancha'l nbanon yen can c'o jun re nibano mandar pa nue'. Y chuka' jec'o soldados je'yi'on pa nuk'a' chin nimban mandar pa quive'. Tak nimban mandar pa rue' jun soldado re c'o pa nuk'a' che tiba, can nibo-va, y tak nimban chic mandar pa rue' jun chique re soldado re jec'o pa nuk'a' che tipa, can nipo-va. Y tak nimban mandar pa rue' re nu-mozo che tubana' jun cosa, can nuban-va. Ja nojel tzij re' re rubim-pa re capitán chaka, xe'cha' re achi'a' re' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y re Jesús can anchique-la xuna' tak xuc'axaj re rutakon-a rubixic re capitán chiquij re achi'a'. Y re Jesús can jare' xe'rutzu' re vinak re je'binak chij, y xubij chique: Can katzij nimbij chiva, che re ache re takayom-pa rubixic re tzij re', can rubanon confiar-ri' viq'uin. Y man jun nuvinak israelita nvilon re can rubanon-ta confiar-ri' viq'uin, ancha'l re jun ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y tak xe'tzolaj re achi'a' re je'takom-pa roma re capitán, xquitz'at che re ru-mozo niyavaj, otz chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic k'ij, re Jesús xba pa jun tenemit rubini'an Naín, y je'binak chuka' re ru-discípulos chij. Y camas chuka' vinak je'tzakatal-a chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tak re Jesús y re je'binak chij ye'oc-yan-apo pa tenemit Naín, xquitz'at che c'amom-pa jun quiminak chin ne'muk can. Re quiminak re' jun c'ajol-ala', ral jun malca'n-ixok. Re malca'n-ixok re', xa can xe-oc jun ral-ala' c'o, y jare' re binak chumukic tak re Jesús xapon. Y camas vinak je'binak mukunel, y re vinak re' niquicukuba' ruc'o'x re te'ej. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y tak re Ajaf Jesús xutz'at rach re ixok re', xujoyovaj rach, y xubij cha: Man chic catok'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y re Jesús xutz'am-apo re ru-cáxa re quiminak, y re je'c'ayon-a richin re quiminak xe'pa'e-ka chire'. Y re Jesús xubij cha re ala' quiminak: Chava rat nimbij-va, cayacataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y tak re Jesús xubij quire', re quiminak xyacataj, y xutz'am tzij. Y re Jesús xujach-a re ala' cha re rute'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tak re vinak xquitz'at re xbanataj, camas xquixibij-qui'. Y xquiya' chuka' ruk'ij re Dios, y niquibila': Vocame xbec'ulum-pa jun namalaj ache chakacojol, rusamajel re Dios re nibex profeta cha. Vocame re Dios xutak-pa jun re nicola kachin yoj re yoj israelitas re rutenemit, xe'cha' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y re xuban re Jesús chupan re k'ij re', xnabex chire' pa Judea, y xnabex chuka' pa tak tenemit re jec'o chunakaj re Judea. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y re Juan Bautista xuc'axaj c'a ronojel re ntajin chubanic re Jesús, roma ja re ru-discípulos re xe'betzijon cha. Mare' reja' xe'rayoj je ca'e' chique re ru-discípulos, ");
INSERT INTO cakYNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xe'rutak-a riq'uin re Jesús chin xbequic'utuj cha: ¿La ja como rat re Cristo re bin che nitak-pa roma re Dios? ¿O jun chic-va, y c'amaje-na te'ka? Quire' xubij-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y re achi'a' re je'rutakon-a re Juan, xe'bapon riq'uin re Jesús. Y reje' xquibij cha: Re Juan Bautista yojrutakom-pa aviq'uin, chin nakac'utuj chava: ¿La ja como rat re Cristo re bin che nitak-pa roma re Dios? ¿O jun chic-va y c'amaje-na te'ka? Quire' xquibij re achi'a', can ja re ancha'l bin-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y tak re achi'a' jec'o chire' riq'uin re Jesús, chupan re mismo rato re' xe'ruc'achojsaj je q'uiy re relic yabil ndoc chique, y jec'o re c'o itzel tak yabil chiquij re c'ayef che ye'k'omax. Xe'rulisaj chuka' itzel tak espíritu, y xuban chuka' chique re moyi' che xe'tzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y c'are' re Jesús xubij chique re je ca'e' achi'a' je'takon-a roma re Juan: Vocame quixtzolaj riq'uin re takayom-pa ivichin, y titzijoj cha re xitz'at y xic'axaj can vova'. Titzijoj cha andex rubanic tak re moyi' ye'tiquir ye'tzu'un-a, andex rubanic tak re vinak je cojos choj ye'biyin-a, y andex rubanic tak ye'c'achoj-a re c'o yabil rubini'an lepra chiquij. Titzijoj chuka' cha andex rubanic tak ye'c'achoj-a re je tocon, re je quiminak chic ye'c'astaj-a, y re vinak re meba' cánma chach re Dios, nimbij re utzulaj ch'abal chin re Dios chique re nibex evangelio cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tibij chuka' cha, che otz-rubanoj re jun vinak ancha'l reja', re rubanon confiar-ri' viq'uin y man jun bey yinrumalij-ta can, xe'cho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y tak re je ca'e' achi'a' re je'rutakom-pa re Juan xe'tzolaj, re Jesús xutz'am can tzij chij re Juan chiquivach re vinak re jec'o chire'. Y ja quire' re nubila': ¿Andex re' re xbe'itz'eta' chupan re lugar anche' manak vinak re nibex desierto cha? Yex man xitz'at-ta jun ache chire', re ancha'l aj re niba quila niba quila pa ruk'a' re cak'ik'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Andex re xbe'itz'eta' chire'? Yex chuka' man xitz'at-ta chire' jun ache re jabal ruvekon-ri'. Re achi'a' re jabal quivekon-qui', rion pa tak cachoch re reyes ye'c'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pero andex re xbe'itz'eta' chire' chupan re lugar re anche' manak vinak re nibex desierto cha? Yex xbe'itz'eta' jun ache rusamajel re Dios re nibex profeta cha. Re ache re xitz'at chire' can ja-va re' re rusamaj. Pero can c'o-va más ruk'ij que chach xabanchique profeta. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Y chij c'a re Juan nich'o-va re Dios chupan re ruch'abal re tz'iban can, y nubij: Xtintak c'a jun ache nabey, chin che nuchojmersaj re bey anche' xtapon-va re Cristo. Quire' nubij re Dios chupan re ruch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Y titamaj, che jenipa' rusamajela' re Dios re nibex profetas chique re je'alaxnak chach re ruch'ulef, man jun re c'o-ta más ruk'ij que chach re Juan Bautista. Can c'o-va más ruk'ij reja'. Jac'a vocame conojel re ye'oc pa ruk'a' re Dios, camas c'a nem quik'ij. Y re vinak re más ba-oc ruk'ij chiquicojol re ye'oc pa ruk'a' re Dios, jare' re más nem ruk'ij que chach re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y chire' jec'o-apo je q'uiy vinak y chuka' jec'o-apo re molay tak impuestos re je'banon bautizar roma re Juan. Y tak reje' xquic'axaj re xubij re Jesús, xquiya' ruk'ij re Dios, y xquibij: Re xuban re Dios can choj-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Y jac'a re achi'a' fariseos y re achi'a' re je'atamayon re ley quichin re israelitas man xquijo-ta xquic'ul re runojin re Dios che nuban quiq'uin. Reje' man xquijo-ta che xe'ban bautizar roma re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y re Ajaf xubij: Che re vinak chin re tiempo re', can xque'njonomaj quiq'uin re ac'ola'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Re vinak re' can je junan quiq'uin re ac'ola' re ye'tz'an pa tak q'uiybal. Y jun pa quichi' niquibila' chiquivach: Xkak'ojmaj xul chivach, pero man xixajo-ta. Xkabixaj bix re can nuyac abis, pero man xixok'-ta, quire' niquibila' re ac'ola' tak ye'tz'an. Y ja quire' quibanon re vinak chin re tiempo re', man jun re nika chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Roma tak xpa re Juan Bautista, reja' man nutaj-ta xcana-vay y man nukum-ta chuka' ruyi'al-uva. Y yex nibij che reja' c'o itzel espíritu riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y tak xineka yen re xinalax chi'icojol, nintaj xcana-vay y ninkum chuka' ruyi'al-uva. Y yex nibij chua che xaxe va'in ninjo' nimban y chuka' nibij che yen xa yin jun k'abarel, y chuka' nibij che xa yin quichibil re molay tak impuestos y re vinak re nibex aj-maqui' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero re runa'oj re Dios can nik'alajin pa quic'aslen re vinak re ye'niman richin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y c'o c'a jun ache fariseo xuban invitar re Jesús chin ne'va' charachoch. Y tak re Jesús xapon charachoch re ache, xtz'uye-apo chach mesa, chin ye'va'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupan re tenemit re', c'o jun ixok re ruc'uan jun itzel c'aslen. Y re ixok re' xunabej che re Jesús c'o charachoch re jun ache fariseo, mare' reja' xapon chire'. Y reja' ruc'uan-apo jun frasco re banon riq'uin jun aboj rubini'an alabastro. Chupan re frasco re' c'o-a jun jubulaj ak'om. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y re ixok re' camas c'a ndok'. Y re ruyi'al tak rach re ixok re' ye'biyin-ka chij rakan re Jesús. Y re ixok re' ye'rusula-a cha re rusumal-rue', y chuka' ye'rutz'ubaj rij rakan re Jesús, y xuya' chuka' re jubulaj ak'om re' chij re rakan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y re ache fariseo re xbano invitar chin re Jesús, tak xutz'at re xuban re ixok, xunojij-ka: Xe-ta re Jesús can katzij-va che reja' jun rusamajel re Dios re nibex profeta cha, nunabej-ta anchique che vinak re nitz'amo la rakan. Roma la ixok la' jun itzel c'aslen ruc'uan, xcha-ka pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Y re Jesús xubij cha re ache fariseo: Simón, c'o jun cosa re ninjo' nimbij chava. Re Simón xubij cha: Maestro, ¿andex najo' nabij chua? ");
INSERT INTO cakYNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y re Jesús xubij cha: Jec'o c'a je ca'e' achi'a' c'o quic'as riq'uin jun ache re niyi'o mero pa kajic. Jun chique re achi'a' re', vo'o' ciento denarios ruc'as, y re jun chic, nic'aj ciento denarios ruc'as. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero como re achi'a' re' man ye'tiquir-ta niquitoj re quic'as, re ache re ya'yon mero pa kajic chique, xubij che man chic tiquitoj, xa tiq'uis quire', xcha' chique. Y re Jesús xubij chuka' cha re Simón re fariseo: Vocame tabij chua, ¿anchique chique re je ca'e' achi'a' re' re más nijovan chin re ache re niyi'o mero pa kajic? ");
INSERT INTO cakYNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Re Simón xubij: Yen nimbij che ja re más q'uiy ruc'as. Ja', ja quire', xcha' re Jesús cha re Simón. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y re Jesús nutzu' rach re ixok tak xutz'am rubixic quire' cha re Simón re fariseo: Tatz'eta' re ixok re'. Tak yen xinoc-pa vova' pan avachoch, man xaya-ta nuya' ch'ajbal-vakan. Jac'a re ixok re' xe'ruch'aj vakan cha re ruyi'al-rach, y xe'ruchakejsaj riq'uin re rusumal tak rue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chuka' tak xinoc-pa, man xinatz'ubaj-ta. Jac'a re ixok re', desde que xinoc-pa ntajin chutz'ubaxic re vakan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rat chuka' man xak'aj-ta aceite pa nue' tak xinoc-pa. Jac'a re ixok re', jun jubulaj ak'om xuya' chij re vakan. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mare' nimbij chava rat Simón, che re ixok re' camas nrajo' re xcuyu re rumac. Roma re jenipa' mac re je'rubanalon xe'cuyutaj-yan. Jac'a re man q'uiy-ta rumac re xe'cuy, xa man can-ta nrajo' re xcuyu re rumac. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y re Jesús xubij cha re ixok: Re amac xe'cuyutaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y re vinak re je'banon invitar roma re Simón re jec'o-apo riq'uin re Jesús chach mesa, niquibila' c'a chiquivach: ¿Anchique como che ache re'? Roma hasta re mac ye'rucuy, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y re Jesús xubij cha re ixok: Xacolotaj, roma xaban confiar-avi' viq'uin. Vocame, catzolaj y ca'texulan. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ca'e-oxe' k'ij tibanataj-va quire', re Jesús xba pa tak nima'k y cocoj tenemit, je ruchibil-a re je doce ru-apóstoles. Y nutzijoj re utzulaj ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y jec'o chuka' ca'e-oxe' ixoki' je'tzakatal-a chij. Re ixoki' re', jare' re je'ruc'achojsan re Jesús, rulisan itzel tak espíritu quiq'uin y nic'aj chic rach yabil. Chiquicojol re ixoki' re' binak re María re nibex chuka' Magdalena cha. Y ja ixok re' re xe'lisas je vuku' itzel tak espíritu riq'uin, roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chiquicojol re ixoki' re je'tzakatal chij re Jesús, binak re jun ixok rubini'an Juana, ruxayil re jun ache rubini'an Chuza. Y re ache re' nisamaj riq'uin re Herodes y c'o más ruk'ij que chiquivach re nic'aj chic ye'samaj riq'uin. Chuka' binak re jun ixok rubini'an Susana. Y jec'o chuka' nic'aj chic ixoki' re je'binak y xe'ta'on chin xe'quivilij re Jesús y re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Y je q'uiy vinak xquimol-apo-qui' chij re Jesús re je'pitinak nic'aj chic tenemit. Mare' chupan re k'ij re', tak camas chic je q'uiy vinak quimalon-qui' chij, reja' xubij jun ejemplo, chique: ");
INSERT INTO cakYNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o c'a jun ache xbo'rjopij semilla pa jun juyu'. Y tak re ache ntajin chubanic re samaj re', c'o nic'aj cha re semilla xka po bey, mare' re vinak niquixak' can rue'. Y chuka' xe'pa ch'utak chicop re ye'ba pa cak'ik', xquitaj-a re semilla xka po bey. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Y c'o nic'aj cha re semilla xka cojol tak aboj. Re semilla re' can xe'tz'uc-va-pa. Pero tak xpa rach k'ij, xe'chakij-ka, roma re ulef anche' xka-va re semilla xa chake'j. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y nic'aj chic semilla xka chucojol k'ayis c'o quiq'uixal. Y tak xe'tz'uc-pa, junan xe'q'uiy quiq'uin re q'uix. Pero re k'ayis c'o quiq'uixal camas xe'q'uiy, mare' re tico'n xe'jik' pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y re nic'aj chic semilla xka pa jun utzulaj ulef, y jabal xe'q'uiy, y xquiyala' ja'jun ciento quivach. Y tak re Jesús rubin chic-ka re ejemplo re', cof xch'o y xubij: Re c'o ruxquin chin nuc'axaj, can tuc'axaj c'a re ximbij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y re ru-discípulos re Jesús xquic'utuj cha, andex nrajo' nubij chique riq'uin re jun ejemplo re xutzijoj chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y re Jesús xubij chique: Man jun bey can-ta bin can jabal chij tak re vinak ye'oc pa ruk'a' re Dios, pero chiva yex yi'on c'a k'ij chin nitamaj. Jac'a chique re vinak re man ye'niman-ta vichin, riq'uin ejemplos yinch'o-va chin quire' choj niquitzu' y man niquitz'at-ta jabal re niquitzu' y chin che choj niquic'axaj y man nak'ax-ta pa quive' re niquic'axaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y ja quire' re ndel che tzij re ejemplo chij re semilla: Re semilla jare' re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Re semilla re xe'ka po bey, junan riq'uin re ruch'abal re Dios tak nic'axax coma re vinak, y nipa re itzel y nulisaj-a re ruch'abal re Dios pa tak cánma, chin quire' man tiquinimaj re Dios, y man que'colotaj chach re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y re semilla re xe'ka chucojol tak aboj, nich'o chij re ruch'abal re Dios re nic'axax coma re vinak. Re vinak re' camas c'a ye'qui'cot tak niquic'ul re ruch'abal re Dios pa tak cánma. Pero man can-ta niquiban confiar-qui' riq'uin re Dios, roma tak ye'tojtobex, cha'nin niquiya' can re Dios. Mare' jun ca'e-oxe' k'ij re otz niquina' y niquiban confiar-qui' riq'uin re Dios y c'are' ye'tzak. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Re semilla re xe'ka cojol tak k'ayis re c'o quiq'uixal, can nich'o-va chij re ruch'abal re Dios re niquic'axaj re vinak. Pero re vinak re' xa ja re ndoc chique chin re quic'aslen vova' chach re ruch'ulef, xa jare' re niquiban, mare' ne'jik' re ruch'abal re Dios pa tak cánma. Ne'jik' pa ruk'a' re biyomal y q'uiy chuka' rach itzel tak rayibal c'o quiq'uin y mare' man nivachin-ta jabal re quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y re semilla re xe'ka pa jun utzulaj ulef, can nich'o-va chij re ruch'abal re Dios re niquic'axaj re vinak. Reje' riq'uin ronojel cánma niquic'axaj y niquiban re nubij. Nojel tiempo quibanon confiar-qui' riq'uin re Dios, y nivachin jabal re quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y man jun vinak nutzaj jun lámpara y c'are' nuvovaj o nuya-ta-apo chuxe' ruch'at. Re lámpara re' can c'o-va anche' nitzekebas-va, chin quire' sakil nuban pa jay tak ye'oc-apo re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y man jun cosa re vovan can re man-ta xtik'alajim-pa. Y chuka' man jun cosa re tz'apin can rij re man-ta ne'el-pa pa sakil. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Y quire' chuka' yex. Vo xa yex nic'axaj re ruch'abal re Dios, tiyaca-ka pa tak ivánma. Roma re c'o cosas ruyacon pa ránma, can xtuc'ul más. Jac'a re nic'axan re ruch'abal re Dios y xa man nuyac-ta-ka pa ránma, re jenipa' ba' nunojij che c'o riq'uin, hasta re' nilisas-a chach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Re rute' y re je ruch'alal re Jesús xe'pa anche' c'o-va reja'. Pero man xe'tiquir-ta xe'oc anche' c'o-va, roma camas je q'uiy vinak quimalon-qui' anche' c'o-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y xbex-apo cha re Jesús: Re ate' y re avch'alal yatquiyaben chach-jay roma xe'pa cha'tz'etic. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero reja' xubij: Re vinak re ye'c'axan y niquiban re nubij re ruch'abal re Dios, jare' re nte' y re je vach'alal, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y jun k'ij, re Jesús je ruchibil-a re ru-discípulos, xoc-a pa jun canoa. Y c'are' xubij chique: Jo' c'a juc'an-apo ruchi' re lago. Y xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y tak je'binak pa rue' re lago, re Jesús xvar-ka. Y chak c'ata' xpa jun cak'ik' camas ruchuk'a' chire' pa rue' re lago. Mare' re canoa anche' je'binak-va, ninoj-pa che ya', y quire' re canoa man c'ayef-ta niba chuxe' ya'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","C'are' re discípulos xquic'asoj re Jesús, y xquibij cha: ¡Ajaf! ¡Ajaf! Vocame yojcom, xe'cha' cha. Y re Jesús xyacataj-pa, y xubij: Tiq'uis-a re cak'ik' y titane-ka re nubolk'otela-ri' re ya'. Y ja quire' xbanataj. Re cak'ik' xq'uis-a, y re nubolk'otela-ri' re ya' xtane-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","C'are' re Jesús xubij chique re ru-discípulos: ¿Anchique roma tak man xiban-ta confiar-ivi' viq'uin? Pero re discípulos camas quixibin-qui'. Can anchique-la xquina' tak xquitz'at re xbanataj, y xquic'utula' chiquivach: ¿Anchique como che ache re'? Roma re cak'ik' y re ya' can niquinimaj rutzij, tak nich'o chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Y re Jesús y re ru-discípulos xe'bapon c'a juc'an-apo ruchi-ya', chire' chupan jun lugar rubini'an Gadara, re c'o-apo chach re Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y tak re Jesús xka can chupan re canoa, xapon jun ache aj pa tenemit Gadara riq'uin. Y re ache re' q'uiy-yan tiempo que'c'ue' itzel tak espíritu riq'uin. Manak rutziak nucusaj, ni xe-ta nic'ue' pa rachoch. Xa ja re anche' je'mukun-va re anama'i' chin re tenemit re', jare' re aconak rachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y re ache re', can xe xutz'at re Jesús, can jare' xbexuque' chach. Y jun pa ruchi' xch'o-apo cha re Jesús, y xubij: Rat Jesús re Ruc'ajol re namalaj Dios, ¿anchique roma tak yinanak? Tabana' jun utzil man quinach'ujersaj, xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Re ache xubij quire' roma re Jesús xubij cha re itzel espíritu che tel-a riq'uin. Roma q'uiy tiempo tic'ue-va re itzel espíritu riq'uin. Y re vinak quitijlon quik'ij chin niquiyach', pero tak niquiyach' ruk'a-rakan, ye'rurokch'ij can y ye'ruk'ajla' can re cadenas roma camas ruchuk'a'. Mare' man ye'tiquir-ta chij, astapa' jenipa' xtiquiban cha. Y re itzel espíritu siempre nuc'uaj-a re ache chupan re lugar anche' manak vinak re nibex desierto cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y re Jesús xuc'utuj cha re ache: ¿Andex abe'? Y re ache xubij-pa: Legión, jare' re nube'. Quire' xubij re ache roma camas je q'uiy itzel tak espíritu jec'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y re itzel tak espíritu xquic'utuj utzil cha re Jesús che vo xa ye'rulisaj-a riq'uin re ache, man c'a que'rutak-a chupan re qui-lugar, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y chire' chunakaj-apo re lugar re', pa rue' jun loma, camas je q'uiy ak ye'va', mare' re itzel tak espíritu xquic'utuj utzil cha re Jesús che tuya' k'ij chique chin ye'be'oc chiquipan re ak re'. Y re Jesús xubij chique che otz. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y re itzel tak espíritu can jare' xe'el-a riq'uin re ache, y xe'be'oc chiquipan re ak. Conojel c'a re ak xquitz'am anin chach peña, y c'a chupan re lago xe'beka-va. Y conojel re ak re' xe'jik' y xe'com. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y re ye'chajin quichin re ak, xe xquitz'at can quire', xe'numaj y xbequiya' rutzijol pa tenemit y pa tak juyu'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y tak re vinak xquic'axaj re xbanataj, xe'pa chin ne'quitz'eta'. Tak re vinak re' xe'beka riq'uin re Jesús, xquitz'at che re ache xe'lisas itzel tak espíritu riq'uin, tz'uyul-apo riq'uin re Jesús, rucusan rutziak, y man nuban-ta chic re ancha'l rubanom-pa. Pero re vinak re' xa xquixibij-qui' tak xquitz'at re ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y xtzijos chique re vinak ronojel re xbanataj, coma re vinak re xquitz'at tak xe'lisas re itzel tak espíritu riq'uin re ache, roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Y roma ronojel re xbanataj, re vinak re aj-chire' pa Gadara xquibij cha re Jesús: Tabana' utzil catel-a vova' pa ka-lugar. Re vinak aj chire' xquibij quire' roma camas quixibin-qui'. Mare' re Jesús y re ru-discípulos xe'oc-a pa canoa, chin ye'ba. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y re ache re xe'lisas itzel tak espíritu riq'uin, nuc'utuj utzil cha re Jesús che tuya' k'ij cha chin niba chij. Pero re Jesús xubij cha che tic'ue' can, y chuka' xubij cha: ");
INSERT INTO cakYNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolaj cha'vachoch, y ta'tzijoj re xuban re Dios aviq'uin, xcho'x-a. Y re ache xtzolaj y xbo'rtzijoj ronojel chique re jec'o pa rachoch, y chuka' chique conojel re vinak re jec'o pa rutenemit, roma re Jesús xuban jun milagro riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y tak re Jesús y re ru-discípulos xe'tzolaj c'a juc'an chic-apo ruchi' re lago, re vinak jec'o chire' camas c'a ye'qui'cot xquic'ul-apo, roma re vinak re' can ja-va re Jesús quiyaben. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xapon chuka' jun ache rubini'an Jairo. Re ache re' c'o jun rusamaj chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, jac'a reja' re c'o más ruk'ij chire'. Y tak re Jairo xutz'at-apo re Jesús, can jare' xbexuque' chach, y xuc'utuj utzil cha che titzake-a chij c'a charachoch, ");
INSERT INTO cakYNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","roma nicom-yan re rumi'al y re ache re' can xe-va jun rumi'al y c'o la'k doce rujuna'. Y tak re Jesús y re je'binak chij xquitz'am-a bey chin ye'ba charachoch re Jairo, camas je q'uiy vinak xe'tzake-a chiquij. Y roma camas je q'uiy vinak je'binak, man otz-ta chic ye'biyin. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicojol re vinak, binak jun ixok niyavaj. Y re ruyabil re ixok re' ja re nibiyin ruq'uiq'uel y doce juna' tuc'alvachij-va quire'. Xuq'uis-yan ronojel ru-mero, roma binak chic quiq'uin q'uiy doctores, y man jun chique re doctores nitiquir-ta nuk'omaj re ruyabil re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Re ixok re' xjelon-apo chij can re Jesús, y ja re ruchi-rutziak xbo'rtz'ama' can ba'. Y can ja mismo rato re' xc'achoj-a re ruyabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y jare' chuka' tak re Jesús xuc'utuj: ¿Anchique xtz'amo re nutziak? Y roma conojel vinak niquibij che manak rutziak quitz'amon-apo, xpa re Pedro y re nic'aj chic discípulos xquibij cha re Jesús: Ajaf, rat najo' natamaj anchique xtz'amo re atziak. Pero vova' c'ayef chin natamaj, roma camas je q'uiy vinak niquipitz'-qui' je'binak y niquichocomila-qui' chavij, y rat nac'utuj chaka: ¿Anchique xtz'amo re atziak? ");
INSERT INTO cakYNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Y jare' tak re Jesús xubij: C'o jun re xtz'amo re nutziak, roma can xina' che c'o jun re xinc'achojsaj cha re poder c'o viq'uin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y re ixok tak xutz'at che xnabex, roma ruximbire' can nibarbot xbexuque' chach re Jesús. Y chiquivach conojel re vinak xubij-apo cha re Jesús anchique roma tak xutz'am-apo ruchi-rutziak. Y xubij-apo chuka' cha re Jesús che can xe xutz'am ruchi-rutziak, can jare' xuna' che xc'achoj cha re ruyabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Re Jesús xubij cha: Numi'al, xac'achoj, roma xaban confiar-avi' viq'uin. Vocame, catzolaj y ca'texulan, xcho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y c'a ntajin che tzij re Jesús riq'uin re ixok, tak c'o jun xbeka pitinak charachoch re Jairo, re ache re c'o ruk'ij chire' pa nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Re jun re xbeka, xbo'rbij cha re Jairo: Man chic tac'uaj-a re Maestro, roma re ami'al xa xcom-yan. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jac'a tak re Jesús xuc'axaj-pa re xbebex cha re Jairo, xubij cha: Man taxibij-avi' roma re xbebex chava. Tabana' confiar-avi' viq'uin, y re ami'al xtic'astaj, xcho'x. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y tak xe'bapon charachoch re Jairo, re Jesús xaxe chique re Pedro, re Jacobo y re Juan re je ru-discípulos, y chique re rute-rutota' re ac'ual quiminak xuya' k'ij chin xe'oc riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel camas ye'ok' y ye'bison chij re xcom. Pero re Jesús xubij chique: Man chic c'a quixok' chij re ac'ual re nibij yex che xcom, roma reja' xa man quiminak-ta, reja' xa nivar, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero re vinak xa xe'tze'en chij re Jesús, roma quitaman che re xtan xa quiminak chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y re Jesús xutz'am ruk'a' re xtan quiminak, y xubij cha: Xta, chava rat nimbij-va che cayacataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y re xtan xtzolaj chic-pa re ránma, y ja mismo rato re' xyacataj-pa. Y re Jesús xubij che tiquisuju' ruay. ");
INSERT INTO cakYNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y re te'ej-tata'aj xsatz quic'o'x tak xquitz'at re xbanataj riq'uin re cajc'ual. Y re Jesús xubij chique che man tiquitzijoj chique re vinak re xbanataj chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Re Jesús xe'rayoj c'a re je doce ru-discípulos, y xuya-a poder chique chin ye'tiquir ye'quilisaj conojel itzel tak espíritu, y chin chuka' ye'quic'achojsaj re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xe'rutak c'a-a re ru-discípulos chin xe'ba chutzijosic che xbeka re k'ij chin andex rubanic tak re vinak ye'oc pa ruk'a' re Dios, y chin chuka' che ye'quic'achojsaj re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y re Jesús xubij chuka' chique: Tak xquixba, man jun cosa tic'uaj-a. Man tic'uaj ch'ama'y, man tic'uaj iya'l, man tic'uaj vay, man tic'uaj mero. Y man tic'uaj jun chic c'ulaj itziak, xa can xe-va re icusan-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y re jay re anche' yixoc-va pa jun tenemit, chire' quixc'ue-va-ka. Xa c'aja tak yixel-pa chupan re tenemit re', otz niya' can re jay re anche' xixc'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y vo xa re tenemit anche' yixapon-va man otz-ta ic'ulic niquiban, xa tiya' can, y titavaj can re pokolaj re c'o pan ivakan chiquivach re vinak, chin quire' tiquitamaj che man otz-ta re xquiban, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y re discípulos xe'ba. Xe'ba pa tak cocoj tenemit chin xbequitzijoj re utzulaj ch'abal chin re Dios re nibex evangelio cha. Y xe'quic'achojsaj re ye'yavaj ronojel lugar anche' xe'k'ax-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y re gobernador rubini'an Herodes chupan re tiempo re', xuc'axaj ronojel re ntajin chubanic re Jesús. Pero man nuvel-ta anchique nunimaj, roma jec'o ye'bin che re nibano quire' ja re Juan Bautista re xc'astaj-pa chiquicojol re anama'i'. Roma re Juan quiminak chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jec'o nic'aj chic ye'bin che re Jesús ja re Elías re xbetzolaj chic-pa. Y nic'aj chic vinak niquibij che re Jesús jun chique re je rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique re xc'astaj-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y re Herodes nubij: ¿Anchique como che ache re Jesús? Roma q'uiy cosas ye'nc'axaj chij re ye'ruban. Pero yen nimbij che mana-ta re Juan Bautista, roma re Juan ja yen mismo re ximbano mandar che xtzaq'uis rujalom, xcha'. Y re Herodes xucanola' formas chin quire' xutz'at-ta rach re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y re ru-apóstoles re Jesús tak xe'tzolaj-pa banoy re rusamaj re Dios, xquitzijoj cha re Jesús andex re xquibanala'. Y re Jesús xe'ruc'uaj c'a-a chupan jun lugar anche' manak vinak re nibex desierto cha. Y re lugar re' chin re tenemit rubini'an Betsaida. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y tak re vinak xquinabej anche' xbo-va re Jesús y re ru-discípulos, xe'ba chuka' reje'. Y tak xe'bapon riq'uin re Jesús, reja' xe'ruc'ul y xubij chuka' chique andex rubanic tak re vinak ye'oc pa ruk'a' re Dios. Y chuka' xe'ruc'achojsaj re ye'yavaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Y tak xk'ak'ij-ka chupan re k'ij re', re je doce discípulos xe'jelon-apo riq'uin re Jesús y xquibij cha: Ca'taka-a re vinak re' pa tak cocoj tenemit y pa tak nic'aj chic lugar re jec'o nakaj, chin te'quicanoj quivay y chuka' anche' ye'bevar-va, roma re anche' yojc'o-va, xa je manak vinak, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jac'a re Jesús xubij chique re ru-discípulos: Tiya' quivay yex. Y re discípulos xquibij: Kaq'uin yoj xaxe-oc vo'o' vay y ca'e' ch'utak car c'o. Re vinak re' yojtiquir ye'katzuk, pero vo xa yojba chulok'ic vay, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Roma re vinak camas je q'uiy. Y xaxe achi'a' jec'o la'k vo'o' mil. Y re Jesús xubij chique re ru-discípulos: Tibij chique re vinak re' che que'tz'uye' y pa tak nic'aj ciento tiquic'uala-qui', xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y re discípulos can ancha'l re xbex chique, can quire' xquiban. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y re Jesús xe'ruli'ej pa ruk'a' re vo'o' xcana-vay y re ca'e' car, xtzu'un chicaj y xutioxij cha re Dios. Y re Jesús xe'rupar re vay y re car, xuya-a chique re ru-discípulos chin che niquijachala' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Y conojel jabal xe'va'. Can man jun re man-ta xva'. Y c'a c'o doce chacach xuban sobra. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y c'o jun k'ij re Jesús rujich'an-a-ri' chin nuban orar, y jec'o-apo re ru-discípulos riq'uin. Y jare' tak re Jesús xuc'utuj chique re ru-discípulos: ¿Yin anchique c'a yen niquinojij re vinak? ");
INSERT INTO cakYNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y reje' xquibij cha: Jec'o ye'bin che ja rat re Juan Bautista. Jec'o nic'aj chic ye'bin che ja rat re Elías, re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y jec'o chuka' ye'bin che rat yat jun chique re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, y vocame xac'astaj-pa chiquicojol re anama'i', xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y reja' xuc'utuj chique re ru-discípulos: Y yex, ¿andex ninojij chuij? Y re Pedro xubij cha re Jesús: Ja rat re Cristo re yatcha'on roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero re Jesús camas xuchalabej chique re ru-discípulos che man jun anchok cha tiquibij-va che ja reja' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xubij chuka' chique: Yen re xinalax chi'icojol, tiene que nink'asaj q'uiy tijoj-pokonal. Y xquintzelas coma re rejeta'k tak achi'a' re c'o quik'ij, coma re principal tak sacerdotes y chuka' coma re achi'a' je'atamayon re ley kachin yoj re yoj israelitas. Y xquinquimisas, pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y c'are' xubij chique conojel: Vo xa c'o jun re nrajo' yinrutzekelbej, can tubana' ancha'l jun re binak chuxe' ru-cruz. Man tuban re nurayij reja'. Man tupokonaj nuk'asaj tijoj-pokonal. Vo xa c'o jun ninojin che nitiquir nuban quire' k'ij-k'ij, otz che nipa viq'uin chin yinrutzekelbej. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roma vo xa camas nupokonaj re ruc'aslen vova' chach re ruch'ulef, xa man xtuvel-ta ruc'aslen re man niq'uis-ta. Jac'a re man nupokonaj-ta re ruc'aslen, astapa' xtiquimisas nutzij yen, jare' sí can xtuvel-va ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Roma man jun cosa otz nuc'am-pa cha re vinak xe-ta nic'ue' ronojel re biyomal chin re ruch'ulef riq'uin, y re vinak re' xa man nicolotaj-ta. Xa rion reja' nunem-ri' chupan re camic chin jumul. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Y vo xa c'o chuka' jun chiva yex niq'uex nutzijoj che yinruniman yen y re nuch'abal, yen re xinalax chi'icojol, chuka' xquinq'uex nimbij che re jun vinak re' vichin yen. Quire' xtimban tak xquimpa chic jun bey, tak xtik'alajin che can yin Rey-va, y chuka' junan chic nuk'ij riq'uin re Nata' y je vichibil-pa re lok'olaj tak ángeles. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y can katzij nimbij chiva, che re Dios can xtic'ue' pa kave' chin xkojruban gobernar. Y jec'o chiva yex, c'aja tak quitz'eton chic che re Dios nuban chic gobernar, c'ajare' tak xque'com, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y jun semana la'k tubij-va ronojel re' chiquivach re vinak, jare' tak xe'rucha' re Pedro, re Juan y re Jacobo chin che ye'oc-a ruchibil chin niba pa rue' jun loma chubanic orar. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y tak re Jesús ntajin cha oración, xjalataj re rutzubal, y can quire' chuka' re rutziak xjalataj. Y re ru-color re rutziak can bo'j xuban y niyiq'uiloj. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y tak re je oxe' discípulos xquitz'at, je ca'e' achi'a' ye'tzijon riq'uin re Jesús. Re je ca'e' achi'a' re' quibini'an Moisés y Elías, y ja achi'a' re' re xe'c'ue' ajuer can. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Re je ca'e' achi'a' re' jec'o pa jun sakil y re sakil re' pitinak chila' chicaj, y ye'tzijon chij re andex rubanic tak re Jesús xtiquimisas pa tenemit Jerusalén. Roma ja samaj re' re yi'om-pa cha roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y re Pedro y re je ca'e' chic ruchibil, camas quivaran pero xquicoch' re varan, y mare' xquitz'at re namalaj ruk'ij re Jesús, y xe'quitz'at chuka' re je ca'e' chic achi'a' re jec'o riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y tak re je ca'e' achi'a' re' niquiya' can re Jesús chin ye'ba, jare' tak re Pedro xubij-apo cha re Jesús: Maestro, vova' otz kabanon. Takabana' oxe' ch'utak jay, jun avichin rat, jun chin re Moisés y jun chin re Elías. Re Pedro quire' xubij-apo y man rutaman-ta anchique roma tak xch'o-apo. Mare' bin che man bin xe'rubila-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y c'a ntajin che tzij, jare' tak c'o jun nube xbeka y xupis quij. Y re discípulos xquixibij-qui' tak xquina' che re nube xupis quij. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y jare' tak c'o Jun xch'o-pa chupan re nube y xubij: Jare' re Nuc'ajol y yen camas ninjo'. Can xe c'a reja' tic'axaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y jac'a tak re discípulos quic'axan chic-ka re ch'abal re', tak xquitz'at, rion chic re Jesús c'o chire'. Y re discípulos re', q'uiy tiempo man jun anchok cha xquitzijoj-va re xquitz'at che xbanataj chire' pa rue' re loma. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y pa ruca'n k'ij tak re Jesús y re je oxe' ru-discípulos xe'ka-pa pa rue' re loma, camas c'a je q'uiy re vinak re xe'c'ulu-apo richin. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y c'o c'a jun ache chiquicojol re vinak, xch'o-apo cha re Jesús y xubij: Maestro, yen xaxe jun vajc'ual c'o. Ninc'utuj c'a utzil chava che tatz'eta' ba', ");
INSERT INTO cakYNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","roma c'o jun itzel espíritu nitz'amo richin, y tak nutz'am nuban cha che nurak ruchi', nisiquic re ru-cuerpo y nicubub xe'ray. Re itzel espíritu re' c'a nuc'usaj-na can ruc'o'x chij, c'ajare' nuya' can. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mare' xinc'utuj-yan utzil chique re a-discípulos che tiquilisaj-a jumul re itzel espíritu riq'uin re nuc'ajol, pero man xe'tiquir-ta, xcha' re ache. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y re Jesús xubij: Man jun vinak chupan re tiempo re' re rubanon-ta confiar-ri' riq'uin re Dios. Xa conojel je'satzanak. Man tinojij che yen nojel tiempo xquinc'ue' iviq'uin. Y chuka' man tinojij che nojel tiempo xquixincoch'. Tac'ama-pa re ac'ajol vova', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y tak re ala' napon-yan-apo riq'uin re Jesús, re itzel espíritu riq'uin ruchuk'a' xuyiquiquej re ala' y xutorij pan ulef. Re Jesús cof xch'o cha re itzel espíritu, chin che tel-a riq'uin re ala'. Y re Jesús xucol re ala' re' chach re itzel espíritu, y xujach-a cha re rutota'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y conojel c'a re vinak xsatz quic'o'x tak xk'alajin re ru-poder re Dios re ruyi'on pa ruk'a' re Jesús. Y tak re vinak ye'tzijon chiquivach chij re ala' re xc'achojsas roma re Jesús, re Jesús xubij chique re ru-discípulos: ");
INSERT INTO cakYNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tic'axaj jabal re xtimbij chiva, y man timistaj: Yen re xinalax chi'icojol, xquinjach pa quik'a' re vinak, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Y reje' man xk'ax-ta pa quive', roma evan chiquivach. Y niquixibij-qui' niquic'utuj cha re Jesús andex ndel che tzij re xubij. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y re ru-discípulos re Jesús xquich'ojela' chiquivach re anchique chique reje' re más c'o ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero re Jesús can jabal-va rutaman y nutz'at re andex niquinojij pa tak cánma. Mare' reja' xbo'rc'ama-pa jun ac'ual, y xbo'rpoba' riq'uin, ");
INSERT INTO cakYNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","y xubij chique: Re yacayon vichin pa ránma y can niqui'cot nuc'ul jun ac'ual ancha'l re', man xe-ta re ac'ual xtuc'ul, xa can xquinruc'ul chuka' yen. Y re nic'ulu vichin yen, can nuc'ul chuka' re takayom-pa vichin. Y jac'a jun ivchibil re nitz'at yex che camanak ruk'ij, xa jare' re c'o más ruk'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpa re Juan xubij cha re Jesús: Maestro, yoj xkatz'at jun ache re pan abe' rat ye'rulisaj itzel tak espíritu. Pero xkatz'at che man kachibil-ta, xkabij cha che man chic tuban re ntajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y re Jesús xubij cha re Juan: Man chic tibij quire' cha. Roma re man ye'tzelan-ta kachin, can kachibil-va-ki' quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y tak napon-yan re k'ij che re Jesús nitzolaj chila' chicaj, reja' can xuban-a preparar-ri' chin xba pa tenemit Jerusalén, ");
INSERT INTO cakYNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","y jec'o xe'rutak-a nabey. Y re xe'tak-a, xe'ba pa jun aldea re c'o pa Samaria, chin xbequicanoj jun jay re anche' xte'xulan-va re Jesús y re je'tzakatal-a chij. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero re vinak chin re aldea re' man xquijo-ta xquic'ul re Jesús, roma reja' xa pa Jerusalén binak-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tak re je ca'e' discípulos quibini'an Jacobo y Juan xquiya' cuenta cha che man nic'ul-ta coma re vinak, xquibij cha re Jesús: Ajaf, ¿najo' che nakac'utuj che tika-pa k'ak' chicaj, chin ye'ruq'uis re vinak re'? Ancha'l xuban re Elías re rusamajel re Dios re xbex profeta cha, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y re Jesús xe'rutzu' y cof xch'o chique. Y xubij: Yex man itaman-ta che re Espíritu re ac'ayon ivichin camas nijovan. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Roma yen re xinalax chi'icojol, man ximpa-ta vova' chach re ruch'ulef chin ye'nquimisaj vinak, yen ximpa chiquicolic chach re quimac, xcha' chique. Y re Jesús y re ru-discípulos xe'ba chic pa jun aldea. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y tak reje' quitz'amon bey, c'o c'a jun ache re xbec'ulum-pa, y xubij cha re Jesús: Ajaf, yen ninjo' yatintzekelbej xabanche' xcabo-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Xpa re Jesús xubij cha re ache re': Re utif can c'o quijul anche' ye'c'ue-va, y quire' chuka' re ch'utak chicop c'o quixic' re ye'ba pa cak'ik', can c'o chuka' quisoc. Jac'a yen re xinalax chi'icojol, manak anche' yinc'ue-va, xcha' cha re ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y re Jesús xubij cha jun chic ache: Jo' chuij. Pero re ache re' xubij: Ajaf, yen ninjo' yimba chavij. Pero nabey taya' k'ij chua che c'a timuku-na-a re nata', c'are' xquimba chavij. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero re Jesús xubij cha re ache re': Re vinak re ye'com, que'muk coma re vinak re je quiminak chupan re quimac. Jac'a rat cabiyin y ta'tzijoj che xbeka re k'ij chin re andex rubanic tak re vinak ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y c'o chic jun ache xbin cha re Jesús: Ajaf, yen ninjo' yimba chavij. Pero nabey taya' k'ij chua chin yine'ch'o-na can chique conojel re jec'o chupan re vachoch, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero re Jesús xubij cha: Re ache re nisamaj riq'uin re arado chin nuposcolij re ulef, man otz-ta che nitzu'un can chij tak ntajin che samaj, roma man otz-ta ndel re rusamaj. Y quire' chuka' re vinak re niniman chin re Dios, man otz-ta che nitzu'un can chij chin ye'rutz'at can re andex ye'banataj. Roma vo xa quire' nuban, man ruc'amon-ta che nisamaj pa rusamaj re Dios y ye'ruto-ta re vinak chin ye'oc pa ruk'a' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y tak xe'banataj-yan ronojel re', re Ajaf Jesús xe'rucha' nic'aj chic achi'a' chin ye'samaj riq'uin. Re je setenta achi'a' re', xe'rutak che ca'ca' che ca'ca' pa tak tenemit y nic'aj chic lugar re anche' xtapon-va reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y re Jesús xubij chique re achi'a' re xe'rucha': Can katzij-va che re samaj chin nitzijos re ruch'abal re Dios, camas nem, jac'a re samajela' man je q'uiy-ta. Mare' tic'utuj cha re Rajaf re samaj, che que'rutaka-pa más samajela' chiquicojol re vinak re nic'atzin che niquic'axaj re ruch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y vocame quixbiyin. Y titamaj che yex xa yix ancha'l ch'utak ovejas re yixintak-a chiquicojol re vinak je ancha'l utif. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y man tic'uaj-a iya'l, man tic'uaj-a mero, man tic'uaj-a jun chic c'ulaj xajab. Y chuka' man quixpa'e' pa tak bey chin yixtzijon, xa choj quixbiyin anche' nijo' yixbo-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y tak yixapon pa jun jay, re nabey cosa re niban, ja re niya' ruxnokil-quivach. Y quire' nibij chique: Re camas nakarayij yoj chiva yex re yixc'o chupan re jay re', ja-ta che re paz re pitinak riq'uin re Dios nic'ue' iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y vo xa chire' chupan re jay re', re vinak otz ic'ulic niquiban y can niquic'ul re nibij chique, jac'a re Dios xtibano chique che re cánma nuna' re paz re pitinak riq'uin re Dios. Y vo xa re vinak man otz-ta ic'ulic niquiban, man xtiquina-ta re paz re pitinak riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Y tak yixapon pa jun tenemit, can quixc'ue-ka chupan re jay re anche' otz ic'ulic niquiban y titija' y tikumu' re xtiquisipaj chiva re jenipa' tiempo re yixc'ue' chire'. Roma jun mozo can ruc'amon-va che nitoj roma re samaj nuban. Y man tijalala' re jay anche' yixc'ue-va. Xa can anche' yixapon-va nabey, chire' quixc'ue-va-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y ja quire' tibana' tak yixapon xabanchique tenemit y jabal ic'ulic niquiban. Titija' ronojel re nisipas chiva. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'ic'achojsaj chuka' re yava'i' re jec'o chire', y tibij chique: Xbeka re k'ij chin re andex rubanic tak yex yixoc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero vo xa yixapon pa jun tenemit re anche' man otz-ta ic'ulic niquiban, quixel-a pa tak calles chin re tenemit y tibij chique re vinak: ");
INSERT INTO cakYNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Hasta re pokolaj chin re tenemit re' re c'o-a pa kakan, nakatavaj can chivach, chin quire' titamaj che man otz-ta kac'ulic xiban. Y titamaj chuka' che re k'ij chin che re vinak ye'oc pa ruk'a' re Dios xbeka-yan, y chiva yex can xsuj-va, xcha-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y re Jesús xubij-a chuka' chique: Tak re Dios xtuban re juicio, re vinak re jec'o chupan re tenemit re man xtiquic'ul-ta jabal re ruch'abal re Dios re nitzijoj chique, c'o más rue' re castigo xtika pa quive' reje' que chach re xtuya' pa quive' re aj-Sodoma. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Mare' ninvok'ej quivach re vinak re jec'o pa tenemit Corazín, y ninvok'ej chuka' quivach re jec'o pa tenemit Betsaida, roma camas q'uiy milagros xe'ban chiquivach y man riq'uin re' xquinimaj-ta re ruch'abal re Dios. Roma xe-ta pa tenemit Tiro y Sidón xe'ban-va re milagros re', re vinak re' xjalataj-yan-ta re quic'aslen chach re Dios, y quicusalon-ta chic tziak ancha'l niquicusaj re vinak tak c'o jun nicom chiquivach, y xquiyala-yan-ta chaj chiquij, chin quire' nik'alajin che ye'bison roma camas quimac re je'quibanalon. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero chupan re k'ij tak re Dios xtuban juzgar, ja re vinak jec'o pa tenemit Corazín y re jec'o pa tenemit Betsaida re c'o más castigo xte'ka pa quive', que chiquivach re aj-Tiro y re aj-Sidón. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y re vinak jec'o pa tenemit Capernaum niquinojij che xque'ba chila' chicaj riq'uin re Dios y can xtiya' quik'ij. Pero xa man quire-ta. Xa xtikasas quik'ij, roma c'a pan infierno xque'beka-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y anchique vinak re xquixruc'ul jabal chin nuc'axaj re ruch'abal re Dios, can ja yen re yinruc'ul. Y re anchique vinak itzel xquixrutz'at roma re ruch'abal re Dios, can ja yen re itzel xquinrutz'at. Y re itzel xquinrutz'at yen, can itzel chuka' xtutz'at re Dios re takayom-pa vichin, xcha-a re Jesús chique re je setenta achi'a' re xe'rucha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y tak xe'tzolaj-pa re je setenta achi'a' re je'takon-a pa samaj, camas ye'qui'cot xe'beka riq'uin re Jesús, y xquibij cha: Ajaf, re itzel tak espíritu can xquinimaj tzij roma pan abe' rat xojch'o chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y re Jesús xubij chique: Ja', can katzij re nibij. Roma yen can xintz'at che re Satanás xka ruk'ij y xuna' che xch'acataj, roma can ancha'l nuban re rayo re niyiq'uiyo' chicaj, quire' xuban reja' tak xtzak-pa anche' c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yen can nyi'on-va-a poder chiva chin che yixtiquir chij re ru-poder re Satanás, y chuka' chin che astapa' xque'ipilbej cumatz y alacrán re ye'ruya' pan ibey, can man jun cosa xtic'alvachij. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero yex man quixqui'cot xaxe roma re itzel tak espíritu xixtiquir chiquij. Más quixqui'cot pa tak ivánma roma re ibe' can xtz'ibas-yan chila' chicaj riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y ja misma hora re', re Espíritu Santo xuban cha re Jesús che camas niqui'cot. Y re Jesús xubij: Nintioxij chava Nata' Dios, rat re yat Rajaf re rocaj y re ruch'ulef, roma man xasekresaj-ta re andex ndel-va che tzij re ach'abal chiquivach re vinak re can niquina' che camas quitaman. Xa ja chiquivach re vinak re manak más quitaman, xa ja chiquivach reje' xasekresaj-va re andex ndel-va che tzij re ach'abal. Can ja-va c'a quire' Nata' Dios, roma ja quire' re xarayij rat che naban, xcha' re Jesús chupan re ru-oración. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y c'are' reja' xubij: Re Nata' Dios can ronojel ruyi'om-pa pa nuk'a'. Y man jun chic atamayon yin anchique yen, xaxe re Nata' re atamayon. Y man jun chuka' atamayon anchique re' re Nata', xaxe yen re Ruc'ajol, y re vinak anchok cha xtinjo' xtinc'ut-va, xtutamaj rach anchique re' re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y c'are' re Jesús xe'rutzu' re ru-discípulos y xaxe chique reje' xubij-va: Otz-ibanoj yex roma ronojel re yixtajin chutz'etic riq'uin re inak'avach. Y otz-quibanoj re nic'aj chic vinak re niquitz'at ronojel re yixtajin chutz'etic yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Y nimbij chiva, che je q'uiy re je rusamajel re Dios re xbex profetas chique, y re reyes re xe'c'ue' ajuer can, xquirayij che xquitz'at-ta re yixtajin chutz'etic vocame, y cama-va xquitz'at-ta-a, xquirayij chuka' xquic'axaj re nic'axaj yex vocame, pero cama-va xquic'axaj-ta-a, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y c'o c'a jun ache atamayon re ley quichin re israelitas xbeyacataj-pa y xch'o riq'uin re Jesús chin nutojtobej. Maestro, xcha' cha. ¿Andex ruc'amon che nimban yen chin quire' ninvel-ta re c'aslen re man niq'uis-ta? ");
INSERT INTO cakYNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Re Jesús xubij cha: ¿Andex nubij chupan re ley re xuya' re Dios cha re Moisés? ¿Andex nak'ax-va pan ave' rat? ");
INSERT INTO cakYNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y re ache re' xubij cha re Jesús: Re ley nubij che tajo' re Dios re Avajaf riq'uin ronojel avánma. Tajo' riq'uin ronojel re ac'aslen, riq'uin ronojel avuchuk'a', y riq'uin ronojel re ana'oj. Y can ancha'l najo-ka-avi' rat, quire' chuka' ca'jo' re nic'aj chic vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y jare' tak re Jesús xubij cha re ache re': Can katzij re xabij. Vocame, vo xa xtaban ronojel re', xtavel re c'aslen re man niq'uis-ta, xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero re ache can nrajo' che man jun rumac ndel, mare' reja' xuban ancha'l che man xk'ax-ta pa rue' anchique re' re nic'aj chic vinak re ca'jo' ancha'l najo-ka-avi' rat. Mare' xuc'utuj-apo cha re Jesús: ¿Anchique c'a che vinak re' re ye'njo' ancha'l ninjo-ka-vi' yen? ");
INSERT INTO cakYNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y re Jesús xubij jun ejemplo cha re ache: C'o jun ache re elinak-pa pa tenemit Jerusalén y xulan-ka pa tenemit Jericó. Pero re ache re' xe'be'el-pa elek'oma' chij po bey y ronojel re andex richin xquilek'aj-a chuk'a', y hasta re rutziak xquilisaj-a chij y xquic'uaj-a, c'are' xquich'ay y bama xquiquimisaj can, c'are' xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y c'o c'a jun sacerdote pitinak chupan re bey re'. Y tak re sacerdote re' xutz'at che punul re ache chire' po bey, jun-va xk'ax-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y quire' chuka' jun ache levita, re ye'ta'o quichin re sacerdotes pa rachoch re Dios, pitinak chuka' chupan re bey re'. Y tak re levita re' xapon chupan re lugar re', xutz'at re ache, y can ancha'l xuban re sacerdote quire' chuka' xuban reja', jun-va xk'ax-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o chic jun ache aj-Samaria pitinak chupan re bey re', y tiene que nak'ax anche' c'o-va re ache. Y tak re ache aj-Samaria xutz'at re ache punul po bey, camas xujoyovaj rach roma camas rubanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Mare' re ache aj-Samaria xjelon-apo riq'uin re ache, xutz'at andex rubanon y xuyala' vino y aceite olivo chach re anche' je'socotajnak-va, jabal ruk'omaxic xuban y c'are' xe'rupis can riq'uin tziak. C'are' re mismo ache aj-Samaria xuya-a re ache socotajnak chij re ruquiej, y xuc'am-pa pa jun pensión. Y xuchajij re jun ak'a' re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa ruca'n k'ij tak re ache aj-Samaria niba-yan, reja' xutoj can ca'e' denarios cha re rajaf re pensión, y xubij cha: Tavilij y tak'omaj re jun ache re'. Y tak xquintzolaj-pa, xtintoj chava re jenipa' chic xtasatz. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Y pa ruq'uisibal re Jesús xubij cha re ache re rutaman re ley quichin re israelitas: ¿Chavach rat anchique che je oxe' achi'a' re' can ancha'l nrajo-ka-ri' reja' can quire' chuka' xrajo' re ache re camas xquiban elek'oma' cha? ");
INSERT INTO cakYNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y re ache rutaman re ley quichin re israelitas xubij: Ja re ache re xjoyovan rach. Y re Jesús xubij chic cha re ache re': Vocame cabiyin y tabana' ancha'l xuban re ache aj-Samaria. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y re Jesús xutz'am chic rubey y xapon pa jun aldea. Y chupan re aldea re' c'o jun ixok rubini'an Marta, y ja reja' re xc'ulu-apo re Jesús pa rachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Re ixok re' c'o jun ruch'alal rubini'an María. Y tak re María xutz'at quire', xtz'uye-ka anche' c'o-va re Jesús, chin quire' nuc'axaj re ruch'abal re Dios re nutzijoj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Jac'a re Marta xa man quire-ta xuban. Reja' binak ránma chubanic re rusamaj, mare' re Marta xapon riq'uin re Jesús y xubij cha: Ajaf, tabana' utzil tabij ba' cha re María che quinruto' ba' cha re samaj roma can nayon yen yinruyi'on can chach, y rat can ancha'l che otz natz'at roma can man jun tzij nabij cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero re Ajaf Jesús xubij cha: Marta, rat q'uiy re nanojij, y yatelinak ch'o'j roma q'uiy re asamaj tiene que naban. ");
INSERT INTO cakYNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xaxe jun re más nic'atzin y más otz, y jare' re xucha' re María. Y re xucha' reja', man jun xtibin cha che man otz-ta y chuka' man jun xtilisan chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","C'o jun bey re Jesús c'o pa jun lugar ntajin che oración. Y tak xtane' cha re oración, jun chique re ru-discípulos xubij cha: Ajaf, tac'utu' chakavach andex rubanic tak nakaban orar, ancha'l xuban re Juan Bautista xuc'ut chiquivach re ru-discípulos andex rubanic tak niquiban orar. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y jare' tak re Jesús xubij chique re ru-discípulos: Quire' tibij tak xtiban orar: Karta' Dios yatc'o chila' chicaj, can-ta conojel re vinak niquiya' ruk'ij re abe'. Y xte'ka-yan-ta re k'ij tak ja rat re xcabano gobernar. Y xe-ta re najo' rat re nakaban vova' chuch'ulef, ancha'l niquiban re jec'o aviq'uin chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y taya' chuka' re kavay re nic'atzin chaka k'ij-k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y can ancha'l nakacuy re quimac conojel re vinak re yojquitzelaj, quire-ta xtaban kaq'uin yoj, xtacuy-ta re kamac re nakaban chavach. Y man taya' k'ij che re itzel nuban-ta chaka che yojtzak pa mac. Can kojacola' chach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y re Jesús xubij chuka' chique re ru-discípulos: Vo xa jun chiva yex napon pa nic'aj-ak'a' pa jun jay re anche' can taman-va rach jabal, y nubij cha re rajaf jay: Naban-ta jun utzil ninjal-ta ca'e-oxe' avay, ");
INSERT INTO cakYNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","roma c'o jun nu-amigo man aj-vova-ta xbeka viq'uin, y yen man jun vay c'o viq'uin chin ninya' cha. Mare' tabana' utzil chua, xcacha-apo cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y re vinak re anche' nac'utuj-va-apo re vay, can c'a chach ruch'at c'a xtich'o-va-pa chava y xtubij: Tabana' utzil man quinanak, roma xa xintz'apij-yan re ruchi-jay y re ac'ola' xa viq'uin yen ye'var-va. Mare' man yintiquir-ta yinyacataj-a chin ne'nya' can chava re utzil najo'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y re Jesús xubij chique re ru-discípulos: Can katzij nimbij chiva, che re vinak re nic'utux-apo re vay cha, niyacataj-pa, pero man roma-ta che camas-ta je amigo riq'uin re nic'utun-apo re vay. Reja' niyacataj-pa y no'rya-pa ronojel re nic'atzin, pero xe chin che titane-ka re jun nic'utun-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y yen nimbij chiva yex, xcha' re Jesús. Tibana' ancha'l xuban re ache re xbec'utun vay. Tic'utuj re nic'atzin y re Dios xtuya-pa chiva. Ticanoj re nijo' y xtivel. Ticocaj-apo re ruchi-jay y xtijak chivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mare' vo xa can riq'uin ronojel ivánma nic'utuj cha re Dios, reja' can xtuya-va-pa chiva re nic'utuj cha. Y vo xa nicanoj, can xtivel-va. Y vo xa yex can nicocaj-apo ruchi-jay, can xtijak-va chivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Man jun tata'aj nibano cha jun rajc'ual che tak re ac'ual nuc'utuj jun vay cha, reja' xa jun aboj nuya' pa ruk'a', y tak nuc'utuj jun car cha, reja' mana-ta jun cumatz nuya' pa ruk'a', ");
INSERT INTO cakYNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","y tak nuc'utuj jun skamalo' cha, reja' mana-ta jun alacrán nuya' pa ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yex astapa' itzel ina'oj, pero chique re ivajc'ual man jun bey quire' niban. Roma yex ja re otz tak cosas re niya' chique. C'alapa' re Irta' Dios re c'o chila' chicaj, che man-ta nuya-pa re Espíritu Santo chique re ye'c'utun cha, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Y jun k'ij re Jesús nuc'achojsaj jun ache re can mem rubanon pa ruk'a' jun itzel espíritu. Y tak re Jesús xubij cha re itzel espíritu che tel-a riq'uin re ache re', re itzel espíritu can xel-va-a, y re ache mem xtiquir xch'o chic jun bey. Y re vinak re xe'tz'eto, can anchique-la xquina' tak xquitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero jec'o chuka' chique re vinak xe'bin: Re Jesús c'o re Beelzebú riq'uin, re quijoval re itzel tak espíritu. Y ja re Beelzebú re niyi'o poder cha chin quire' nitiquir ye'rulisaj re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y jec'o nic'aj chic vinak, xaxe chin che niquitojtobej re Jesús vo xa can katzij che ja re Dios takayom-pa richin, xquibij cha che tubana' jun señal chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero re Jesús rutaman re niquinojij re achi'a' re' pa tak cánma, mare' xubij chique: Vo xa re vinak chin jun nación man niquinojij-ta y ca'e' quivach niquiban, nipa ayoval chiquicojol. Y re' man otz-ta, roma nuban cha re nación che nitzak. Y quire' chuka' pa jun jay, vo xa c'o ayoval chiquicojol, niquijach-qui' y man otz-ta chic xtiquitz'at-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y ja quire' chuka' re Satanás, reja' manak modo che nuban ayoval quiq'uin re rusamajela', roma vo xa quire' nuban, re ruchibil rion niquiya' can y cha'nin nitzak y man chic nitiquir-ta nuban gobernar. Y yen quire' nimbij chiva, roma yex nibij che yen c'o re Beelzebú viq'uin y mare' tak yintiquir ye'nlisaj-a re itzel tak espíritu. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yex quire' ninojij chuij yen, che c'o re Beelzebú viq'uin, mare' yintiquir ye'nlisaj re itzel tak espíritu, pero re ye'tzekelben ivichin chuka' ye'tiquir ye'quilisaj itzel tak espíritu. ¿Anchique como ya'yon poder chique reje' chin ye'tiquir niquiban quire'? Mare' ja re ye'tzekelben ivichin jare' re ye'sekresan che man otz-ta re ninojij yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Y yen can ja-va re Dios re ya'yom-pa poder chua chin yintiquir ye'nlisaj-a re itzel tak espíritu. Xa xbeka-yan re k'ij che conojel ruc'amon che niquinimaj rutzij re Dios y ye'c'ue' pa ruk'a' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Y tak c'o jun ache re camas ruchuk'a', y c'o ronojel rach ch'ich' riq'uin chin nuban ayoval, re ache re' can jabal-va nuchajij re rachoch, y man jun xtilek'an re cosas c'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero tak ne'c'ulun chic jun ache re c'o más ruchuk'a' que chach reja', nich'acataj, y nilisas-a ronojel rach ch'ich' chin ayoval re c'o riq'uin, re anchok riq'uin rubanon-va confiar-ri'. C'are' re ache re c'o más ruchuk'a', nutz'am rujachic chiquivach re ruchibil. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y mare', re vinak re man nrajo-ta nic'ue' viq'uin, xa riq'uin re Satanás nrajo' nic'ue-va. Y anchique vinak man nuban-ta re nusamaj, xa nuyoj re nusamaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Tak c'o jun itzel espíritu ndel-a riq'uin jun vinak, re itzel espíritu re' niba pa tak lugares re anche' manak vinak y manak ya', y chire' c'a nucanoj-va jun lugar chin nixulan. Y tak re jun itzel espíritu re' nuna' che man ak lugar nuvil chin nixulan, nunojij: Más otz yintzolaj chic anche' xinel-va-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y tak re itzel espíritu re' nitzolaj chic-apo pa ránma re vinak anche' elinak-va-a, no'rvila' re ránma re vinak re' ancha'l jun jay re meson rupan y jabal ruvekic banon. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y c'are' re itzel espíritu re' ye'bo'rc'ama-pa je vuku' chic ruchibil itzel tak espíritu re más je itzel, y conojel re' ye'oc pa ránma re vinak. Y re vinak re anchok riq'uin ye'c'ue-va chic jun bey re itzel tak espíritu re', más c'ayef nuban re ruc'aslen que chach re xuban nabey. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y tak re Jesús ntajin chubixic re' chiquivach conojel re vinak re quimalon-qui' riq'uin, jare' tak jun ixok re c'o chire' chiquicojol cof xbech'o-pa, y xubij: Otz-rubanoj re ixok re xyi'o avichin chach re ruch'ulef y xatruq'uiytisaj riq'uin tz'umaj, xcha' re ixok cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Y re Jesús xubij: Más otz-quibanoj re niquic'axaj re ruch'abal re Dios y niquiban re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y tak re Jesús xutz'at che camas je q'uiy vinak niquimol-apo-qui' chij, xpa re Jesús xubij chique re vinak re': Re vinak chupan re tiempo re' camas je mal tak vinak y man yinquinimaj-ta. Mare' can niquijo' che yen nimban jun señal chiquivach chin quire' yinquinimaj. Pero mana-ta re niquijo' reje' jare' re xtibanataj. Xa can xe re xbanataj riq'uin re jun ache re xubini'aj Jonás, re jun rusamajel re Dios re xc'ue' ajuer can re xbex profeta cha, xaxe re señal re' re niya' chique reje'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Re xuc'alvachij re Jonás xuc'ut chiquivach re vinak re xe'c'ue' ajuer can chupan re tenemit Nínive, che can ja re Dios takayom-pa richin. Y quire' chuka' yen re xinalax chi'icojol, re xtinc'alvachij xticusas chin jun señal chiquivach re vinak vocame. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y tak xtapon re k'ij tak re vinak xque'bapon chach re Dios chin xque'ban juzgar, xte'c'astaj-pa re jun ixok re xuban gobernar pa Sabá y xtubij che man otz-ta xquiban re vinak re jec'o vocame. Roma re tiempo tak xc'ue' re jun ixok re', camas naj xbiyin chin quire' xbo'rc'axaj y xbo'rtz'eta' re namalaj na'oj re c'o riq'uin re Rey Salomón. Y vocame yinc'o yen re c'o más nuk'ij que chach re Rey Salomón re xc'ue' ajuer can, y xa man yinquinimaj-ta re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y tak xtapon chuka' re k'ij tak re Dios xque'ruban juzgar re vinak re jec'o vocame, xque'c'astaj-pa re vinak re xe'c'ue' ajuer can pa tenemit Nínive. Re vinak re' xtiquibij che man otz-ta xquiban re vinak re jec'o chupan re tiempo re', roma man xinquinimaj-ta, roma re vinak re xe'c'ue' pa tenemit Nínive, can xe xquic'axaj re ruch'abal re Dios re xutzijoj re Jonás chique, can jare' tak xquinimaj y xjalataj re quic'aslen chach re Dios. Y vocame yinc'o yen re c'o más nuk'ij que chach re Jonás, y xa man yinquinimaj-ta re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Y man jun vinak nibano che tak nutzaj jun lámpara nuya-ta-apo chuxe' jun cajón o nuvovaj-ta-apo. Re vinak re nutzaj jun lámpara, nutzekeba' chicaj, chin quire' sakil nuban pa jay tak ye'oc-apo re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Y re anak'avach can ye'oc chava ancha'l ndoc jun lámpara. Roma vo xa re anak'avach je otz, ronojel re a-cuerpo c'o pa sakil. Pero vo xa re anak'avach man je otz-ta, ronojel re a-cuerpo c'o pa k'oko'm. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mare' tachajij re ac'aslen, chin quire' re sakil re ruyi'on re Dios pan avánma man tijalataj, y man chic tik'alajim-pa che c'a yatc'o pa k'oko'm. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roma vo xa yatc'o pa sakil, can man yatc'o-ta pa k'oko'm, y quire' can yatzu'un-va jabal. Re' can junan-va riq'uin tak tzijon jun lámpara chin nusekresaj re anche' yatc'o-va y can pak'ij rubanon roma k'alaj ronojel. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y tak re Jesús xtane-ka che tzij chiquivach re vinak, c'o jun chique re achi'a' fariseos xubij cha re Jesús che tubana' utzil niba-ta ba' charachoch, chin ne'va' riq'uin. Y re Jesús can xbo-va. Y tak xapon, xbetz'uye' chach mesa. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y re ache fariseo, can anchique-la xutz'at re Jesús, roma xtz'uye-apo chach mesa y man xuch'aj-ta ruk'a' ancha'l re qui-costumbre re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Y re Ajaf Jesús can rutaman re nunojij re ache fariseo, y mare' xubij cha: Yex fariseos xa yix ancha'l re lak re jabal ch'ajch'oj rij y re rupan can xak che tz'il. Yex can nic'ut chiquivach re vinak che camas otz re ibanabal, pero pa tak ivánma man quire-ta, roma xa nojnak riq'uin elak', y nojnak riq'uin ronojel rach etzelal. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Xa yix nacanak tak vinak, roma itaman che ja re Dios xbano re ka-cuerpo y chuka' reja' xbano re kánma. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mare' yex xa ja re ivánma tich'ojersaj, chin quire' tak ch'ajch'oj chic re ivánma, xtalax c'a-pa iviq'uin che ye'to' re man jun cosa c'o quiq'uin, y xquixch'ojch'ojer. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Tivok'ex ivach yex fariseos! roma yex xaxe re jubulaj tak k'ayis, ancha'l re hierbabuena y re ruda y ronojel quivach tico'n, jare' re ye'lisaj can tak ba' chin ndoc i-diezmo chin niya' cha re Dios, pero xa man nijo-ta re Dios, y man otz-ta ina'oj quiq'uin re vinak. Pero jare' re más otz-ta che niban nabey, y c'aja-ta re' niban re can yixtajin-va chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Tivok'ex ivach yex fariseos! roma ja re nabey tak ch'acat ye'canola' re pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, chin quire' nibex che camas ik'ij. Y chuka' camas nika chivach che niya' ruxnokil-ivach pa tak q'uiybal, re anche' niquimol-va-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Tivok'ex chuka' ivach yex achi'a' re itaman re ley kachin yoj re yoj israelitas y chuka' yex fariseos re ca'e' ipalaj! roma yex xa yix ancha'l re anche' je'mukun-va re anama'i', re man chic banon-ta quibanic y man chic k'alaj-ta che c'o mukun chire', y re vinak xa choj ye'k'ax pa rue', can man c'a quitaman-ta che xa pa rue' jun quiminak ye'k'ax-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun chique re achi'a' je'atamayon re ley quichin re israelitas, xubij cha re Jesús: Maestro, tak rat nabij quire', man xe-ta chic chique re fariseos nabij-va, xa can chibil chuka' chaka yoj nabij-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y re Jesús xubij cha re ache re': ¡Tivok'ex chuka' ivach yex re itaman re ley! roma tak ye'tijoj re vinak, niya' namalaj tak ejka'n chiquij, re camas c'ayef quic'uaxic. Re ejka'n re' xaxe chiquij re vinak niya-va, y yex can man jun ch'et rue-ik'a' nisiloj chin niban y nic'uaj-ta re ejka'n re nibij che tiene que niquic'uaj re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Tivok'ex ivach yex re itaman re ley! roma yex yix ancha'l re ivinak re xe'c'ue' ajuer can, xe'quiquimisala' re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Y ja quire' yex vocame nik'alajin che yix quire', roma ye'ibanala' rubanic re qui-panteón. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vocame nik'alajin che yex yix ancha'l reje', roma nika chivach re xquibanala' chique re rusamajela' re Dios re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y mare' re Dios re c'o ronojel rach na'oj riq'uin xubij: Xque'ntak achi'a' quiq'uin re israelitas re nutenemit, achi'a' re xque'tzijon re ch'abal re nimbij chique, y chuka' xque'ntak apóstoles quiq'uin. Pero jec'o chique reje' re xque'quimisas, y chuka' xque'ya' pa tak tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mare' xubij re Jesús: Conojel re profetas re je'quimisam-pa tak xtiquir-pa re ruch'ulef, ja re vinak re jec'o vocame, jare' re xque'kalen re quicamic. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitiquir-pa riq'uin re rucamic re ache xubini'aj Abel c'a riq'uin re rucamic re ache xubini'aj Zacarías. Y ja Zacarías re' re xquimisas chunakaj re altar re c'o chach rachoch re Dios. Mare' nimbij chiva, che re Dios pa quive' re vinak re jec'o vocame xtuya-va re quicamic re achi'a' re xe'samaj pa ru-cuenta re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Tivok'ex ivach yex achi'a' re itaman re ley! roma yex jabal itaman andex rubanic tak jun vinak ndoc rajc'ual re Dios, pero yex man yix-aconak-ta rajc'ual reja' y chuka' man niya-ta k'ij chique re vinak chin ye'oc-ta rajc'ual re Dios, astapa' re vinak niquijo' ye'oc rajc'ual reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tak re Jesús xubij ronojel re', re achi'a' re je'atamayon re ley quichin re israelitas y re achi'a' fariseos camas xpa quiyoval. Y mare' conojel reje' xquibanala' chic preguntas cha, xaxe chin niquinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Re achi'a' re' cama-va niquiya-ta can re Jesús, roma niquijo-ta reje' che reja' c'o-ta jun ch'abal re man pa rubiyal-ta re nubij chin che nika pa quik'a', chin che niquisujuj. Pero re Jesús can rion pa rubiyal re ye'rubij tak nich'o. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y re vinak xquimol-qui'. Y roma can pa mil xquimol-qui' chire', mare' can niquichocomila-qui'. Y re Jesús quiq'uin re ru-discípulos xutz'am-va tzij nabey, y xubij chique: Can tichajij-ivi' chach re levadura quichin re achi'a' fariseos. Y re levadura re' ndel che tzij, ja che re achi'a' fariseos ca'e' quipalaj quibanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Y ronojel re man can-ta sekresam-pa, can xtisekresas, y ronojel re tz'apin rij, can xtel pa sakil, mare' can conojel c'a xque'taman, y conojel chuka' xque'tz'eto. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mare' yex, ronojel re ibilon pan eval, can xte'k'alajim-pa. Y ronojel c'a re ibilon pa tak ixquin y pa tak jay can xtitamax coma re vinak, y reje' can xque'jote' c'a pa rue' re cachoch y c'a chire' xtiquiya-va-pa rutzijol. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y mare' chuka' nimbij chiva yex re yix nu-amigos: Man tixibij-ivi' chiquivach re vinak re ye'quimisan re i-cuerpo, roma tak xixquiquimisaj-yan, man chic jun andex ye'tiquir niquiban chiva, roma re ivánma man ye'tiquir-ta niquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Y nimbij chiva anchok chach ruc'amon che nixibij-ivi', y re' ja chach re jun re c'o autoridad pa ruk'a' che man xe-ta yixruquimisaj, reja' can nitiquir yixrutak pan infierno. Ja chach re' tixibij-va-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Y yex chuka' jabal itaman che tak ye'lok' vo'o' ch'utak chicop re c'o quixic' re ye'ba pa cak'ik', xaxe ca'e' ch'utak centavo cajal. Y man roma-ta che camas je barato, xtipa-ta re Dios ye'rumistaj-ta can. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y c'alapa' c'a yex, roma hasta re rusumal-ive' ejelan. Re Dios man jun bey yixrumistaj-ta can, camas yixrajo'. Reja' más yixrajo' que chiquivach ch'utak chicop re c'o quixic' re ye'ba pa cak'ik'. Mare' man tixibij-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chuka' nimbij chiva, che xabanchique vinak re man niq'uex-ta nubij che yinruniman chic, yen chuka' re xinalax chi'icojol xtimbij che reja' vichin chic yen. Y re tzij re' can chiquivach re ru-ángeles re Dios xtimbij-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Jac'a re vinak re niq'uex nubij che yinruniman chic, yen chuka' xquinq'uex nimbij chiquivach re ru-ángeles re Dios che re vinak re' vichin yen. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y xabanchique vinak nuyok' re nube' yen re xinalax chi'icojol, can nicuyutaj rumac. Jac'a re niyok'o richin re Espíritu Santo, man c'a xticuyutaj-ta rumac. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Y vo xa ja yen re yininimaj, y rutzij re' yixc'uax chiquivach re achi'a' c'o quik'ij pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, y rutzij chuka' re' yixc'uax chiquivach re autoridades, man timay re andex xtibij chique y andex che tzij xticusaj chin yixch'o chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roma tak xquixch'o-apo, can ja re Espíritu Santo re xtibin chiva re andex xtibij-apo, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chire' chiquicojol conojel vinak re quimalon-apo-qui', c'o c'a jun ache xch'o-apo y xubij cha re Jesús: Maestro, xcha' cha. Tabana' utzil cach'o riq'uin re vach'alal y tabij cha che tuya-pa re nu-herencia re aconak-ka richin. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero re Jesús xubij cha re ache: ¿La yin juez como yen chin yen yimbano rubiyal o ninjach re herencia chivach? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y re Jesús xch'o chic chique re vinak y xubij: Tichajij-ivi' che man tirayij re biyomal. Roma re biyomal man nitiquir-ta nulok' re c'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y jare' tak re Jesús xutz'am rubixic jun ejemplo y xubij: C'o jun ache biyom, re camas q'uiy rulef. Y c'o jun juna', camas q'uiy xuban cosechar. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Mare' re ache biyom xutz'am runojexic pa ránma: ¿Andex como xtimban cha ronojel re nu-cosecha? Roma manak chic anche' ninya-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y tak xunojij re andex nuban, xubij: Mejor ye'ntur re jay re je'aconak ruc'ojlebal re nu-cosecha roma camas je cocoj y nimban más chavon cha, y chupan c'a re' xtinyac-va ronojel re xtimban cosechar y ronojel re c'o viq'uin, ");
INSERT INTO cakYNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","y xtimbij c'a cha re vánma: Vánma, vocame camas q'uiy cosas re ayacon, y q'uiy juna' man xtataj-ta viyjal. Caqui'cot, caxulan, cava' y catuq'uia', xcha' re biyom cha re ránma. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero re Dios xubij cha re biyom re': Camas yat nacanic, chupan re ak'a' re' xtinvayoj-a re avánma, y ronojel re abiyomal re ayacon, ¿anchok richin c'a xtoc-va can? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quire' niquic'alvachij re vinak re niquimol biyomal chin re ruch'ulef, y xa mana-ta re biyomal c'o riq'uin re Dios re niquimol. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y re Jesús xubij chique re ru-discípulos: Yen nimbij chiva, che man quixel ch'o'j chucanoxic re ndoc chiva k'ij-k'ij, re anche' xte'vila-va-pa ivay y re anche' xte'c'ama-va-pa itziak, ");
INSERT INTO cakYNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","roma mana-ta re vay re c'o más rajkalen que chach re c'aslen, y chuka' mana-ta re tziak re c'o más rajkalen que chach re i-cuerpo. Roma re Dios can nuya-va-pa re ivay chin c'o ic'aslen y re itziak chin nicusaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Titz'eta-na-pa' ch'utak chicop re c'o quixic' re ye'ba pa cak'ik', reje' man ye'ticon-ta y manak cosecha niquilisaj juna-juna', y chuka' manak cachoch chin niquiyacala' qui-cosecha. Pero reje' ye'va', roma can ja re Dios re nitzuku quichin. C'alapa' c'a yex che re Dios man-ta xtuya' ivay, roma yex más ivajkalen que chiquivach reje'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Man jun chiva yex re nitiquir-ta nuban che niq'uiy-ta ba' más rakan, astapa' can elinak ch'o'j chubanic quire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y re jun samaj re' camas co'ol y man yixtiquir-ta niban, ¿anchique c'a roma tak can yixelenak ch'o'j chucanoxic ivay, itziak y re nic'aj chic re ye'c'atzin chiva? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Titz'eta' re cotz'e'j quibini'an lirio tak ye'q'uiy, reje' man ye'samaj-ta, y man ye'quimon-ta chin niquiban quitziak. Y c'o jun Rey xuban gobernar pan Israel jun bey can xubini'aj Salomón. Reja' camas rubiyomal y rion tziak re camas je caro re xe'ruc'uaj, pero man jun bey xucusaj-ta jun rutziak ancha'l jun cotz'e'j. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Roma re Dios ja re cotz'e'j jare' re quitziak nuya' chique re k'ayis re jec'o pak'os. Y astapa' re k'ayis man can-ta niyaloj, roma jun tiempo-oc re jabal nitzu'un y tak nichakij-ka, nich'akex pa k'ak', pero man riq'uin re' re Dios can nuvak-va jabal. Y vo xa re Dios nuvak jabal re k'ayis, c'alapa' yex man-ta xtuya' itziak, astapa' yex man can-ta ibanon confiar-ivi' riq'uin re Dios, pero reja' can nuya-va itziak. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Mare' yex man quixel ch'o'j chucanoxic re andex xtitaj y re andex xtikum. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Quire' nimbij chiva, roma ja quire' niquiban re vinak re man quitaman-ta rach re Dios. Pero yex can itaman che c'o jun Tata'aj re can rutaman chic andex re nic'atzin chiva. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mare' re ruc'amon che niban yex ja che tinimaj rutzij re Dios y reja' can xtuya' re nic'atzin chiva. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Mare' man tixibij-ivi' yex re yixtzekelben vichin, roma astapa' yix ba-oc, pero re Tata'aj re c'o chila' chicaj can nurayij-va che yixc'ue' pa ruk'a' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayila' re andex jec'o iviq'uin y tijachala' re rajal chiquivach re vinak re je meba-oc. Vo xa quire' xtiban, re bolsa chin re ibiyomal re yacon chila' chicaj xtinoj y man jun bey xtik'ay-ta, y re ibiyomal re' man jun bey xtiq'uis. Chila' manak elek'oma' y chila' man jun andex xtichocoper. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Roma re ivánma can nic'ue' anche' c'o-va re ibiyomal, roma can jare' re nirayij. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Can tichajij c'a ic'aslan, che can-ta nojel tiempo tzejal. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' ancha'l niquiban re ye'chajin chupan jun jay. Re ye'chajin quiyaben che nitzolaj-pa re qui-patrón binak pa jun c'ulubic, chin quire' tak ne'ka y nucocaj-apo re ruchi-jay, can jare' ne'quijaka-pa chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Otz-quibanoj re ye'chajin jun jay vo xa je c'as tak ne'ka re qui-patrón. Y katzij nimbij chiva, che re qui-patrón mismo xto'rcusaj-pa re rutziak chin samaj y c'are' conojel re ru-mozos ye'rutz'uyuba-apo chach mesa, y ye'ruvilij-apo jabal roma reja' camas niqui'cot, roma je c'as y quiyaben-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Otz-quibanoj re mozos re' vo xa je c'as ye'bo'rvila-ka re qui-patrón tak ne'ka pa nic'aj-ak'a' o ja tak nisakar-yam-pa, roma can quiyaben-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y yex itaman, che xe-ta jun rajaf jay rutaman jampa' napon jun elek'om pa rachoch, re rajaf jay re' nic'ase' chin nuchajij re rachoch, y man nuya-ta k'ij che re elek'om nuvop re rachoch chin ndoc chupan y nelak'-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mare' yex nojel tiempo quiniyabej-apo, roma ja tak yex man jun ninojij, jare' tak xquineka yen re xinalax chi'icojol, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jare' tak re Pedro xubij cha re Jesús: Ajaf, ¿rat xabij re ejemplo re' xaxe chaka yoj re a-discípulos o chique chuka' conojel vinak? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y re Ajaf Jesús xubij: Yex tibana' c'a ancha'l nuban jun mozo re c'o runa'oj y can nuban ronojel re nibex cha. Nipa re patrón nucha' re mozo re' chin nipa'e' can pa quive' conojel re ye'c'ue' can pa jay, chin nuya' quivay tak napon re hora. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Y reja' can nuban-va ronojel samaj re bin can cha che nuban, y mare' niqui'cot ránma tak ne'vil-ka roma re ru-patrón ntajin che samaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can katzij nimbij chiva che re patrón re' xtuban cha re ru-mozo che xtuya' pa rue' ronojel re c'o riq'uin, chin che nuchajij. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero vo xa re mozo re' nunojij-ka pa ránma: Re nu-patrón re' xa c'amaje-na ne'ka y nutz'am-ta quich'ayic re nic'aj chic mozos che achi'a' y che ixoki', y xaxe-ta va'in nuban, y nutz'am k'abaric y can man jun chic samaj nrajo' nuban, ");
INSERT INTO cakYNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","jac'a re k'ij y re hora tak man jun runaben che ne'ka re ru-patrón jare' tak ne'ka. Re ru-patrón can xtuya' jun namalaj castigo pa rue' re mozo re' junan quiq'uin re nic'aj chic mozos re man ye'niman-ta tzij. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Re mozo re rutaman andex nrajo' re ru-patrón, y xa man xuban-ta preparar-ri' y chuka' man xuban-ta re samaj re xbex can cha roma re ru-patrón, re mozo re' can xtika jun namalaj castigo pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Jac'a re mozo re man rutaman-ta andex re nrajo' re ru-patrón, y xa ja re andex re man je otz-ta re xubanala-apo, re mozo can niban-va castigar pero xa ba-oc. Roma re vinak re q'uiy yi'on cha, chuka' q'uiy xtic'utux cha, y re vinak re c'o q'uiy cosas jachon can pa ruk'a', más q'uiy xtic'utux cha, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yen can chuyi'ic k'ak' tak ximpa chi'icojol chach re ruch'ulef. Y camas ninrayij che re k'ak' re' nic'at-ta chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nabey tiene que nink'asaj jun tijoj-pokonal, y mare' nik'axo re vánma, y camas ninrayij che k'axnak-ta chic re tijoj-pokonal re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Man tinojij che yen ximpa chach re ruch'ulef chin che junan ivach nimban chiva. Man quire-ta. Xa nutzij yen jec'o re xtiquijachala-qui' ");
INSERT INTO cakYNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mare' re tiempo re xtiba-apo, vo xa pa jun jay jec'o je vo'o' vinak, je oxe' xque'yacataj chiquij re je ca'e', y re je ca'e' chic xque'yacataj chiquij re je oxe'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Re tata'aj man xtika-ta chach re nubij re ruc'ajol. Ni xe-ta re ruc'ajol man xtika-ta chach re nubij re tata'aj cha. Ni xe-ta re te'ej man xtika-ta chach re nubij re ral-xtan cha. Y quire' chuka' re xtan man xtika-ta chach re nubij re rute' cha. Y quire' chuka' re elite' man xtiquic'uaj-ta-qui' riq'uin re rali', roma man junan-ta niquinojij, y ni xe-ta re rali' xtiquic'uaj-ta-qui' riq'uin re rulite'. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y re Jesús xubij chuka' chique re vinak: Yex itaman andex titzu'un re nube chin job. Y tak nitz'at re nube re', cha'nin nibij che nipa job. Y can nipo-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y tak ne'ka re cak'ik', jac'a seña re' che ja xbeka re sak'ij y can ja quire' nibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yex xa ca'e' ipalaj, ¿anchique roma jabal itaman re andex nipa tak nitzu' re nube chicaj? ¿Y anchique roma chuka' jabal itaman che nipa cak'ik' y nipa job y nic'aj chic cosas chach re ruch'ulef? Vo xa itaman re', ¿y anchique roma tak man itaman-ta anchique tiempo re yojc'o-va? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y anchique roma tak man ninojij-ta jabal re andex otz che niban? ");
INSERT INTO cakYNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Roma vo xa c'o jun chiva yex nisujus chiquivach re autoridades roma c'o ruc'as, tucanoj rubanic chin che nuban rubiyal riq'uin re xsujun richin tak je'binak pa cabildo. Pero vo xa man nic'achoj-ta rubiyal re anchok riq'uin c'o-va ruc'as, can ye'bo-va chach re juez, y re juez nujach-a pa ruk'a' re policía, y re policía nuc'uaj-a, chin no'rtz'apij can pa cárcel. ");
INSERT INTO cakYNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y can katzij nimbij, che re vinak re ndoc pa cárcel roma c'o ruc'as, man xtel-ta-pa chire' vo xa man nutoj-ta can ronojel re ruc'as. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y jac'are' tak jec'o je ca'e-oxe' vinak xe'bapon chire' riq'uin re Jesús, y reje' xquitzijoj cha re xquic'alvachij re nic'aj chic achi'a' aj-Galilea. Re achi'a' aj-Galilea re' je'quic'ualon-apo chicop pa rachoch re Dios chin ye'suj cha re Dios. Y tak ntajin rubanic ronojel re', reje' xe'bequimisas can. Y re xtako quiquimisasic re achi'a' re' ja re gobernador rubini'an Pilato. Re quiq'uiq'uel re chicop xuxol-ri' riq'uin re quiq'uiq'uel re achi'a' re xe'bequimisas can. Jare' re xquitzijoj re je ca'e-oxe' vinak aj-Galilea cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pero re Jesús xubij chique: Man tinojij che re achi'a' aj-Galilea quire' xban chique roma c'o más quimac chiquivach re nic'aj chic quivinak aj-Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jac'a vo xa yex man xtijalataj-ta re ic'aslen chach re Dios, can c'ayef chuka' xtic'alvachij. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Y chuka' tak xe'com re je dieciocho re anche' c'o-va re ya' rubini'an Siloé, tak xtzak re torre chiquij, man tinojij che reje' c'o más quimac chiquivach conojel re nic'aj chic vinak re jec'o chupan re tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jac'a vo xa yex man xtijalataj-ta re ic'aslen chach re Dios, can c'ayef chuka' xtic'alvachij. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Re Jesús xutz'am rubixic jun ejemplo chiquivach: C'o c'a jun ache ruticon juvi' higo pa rujuyu', y xba chutz'etic re che' vo xa c'o rach. Y re juvi' higo re' manak rach. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mare' re rajaf re juyu' xubij cha re ache re nisamaj riq'uin: Oxe' juna' re' y can juna-juna' ne'ntz'eta' re che' re', y man jun bey ntz'eton che ruyi'on-ta rach. Mare' más otz tachoyo-a, roma manak rach nuya'. Man jun ndoc-va roma xaxe nuq'uis ruchuk'a' re ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero re ache nisamajin chin re rujuyu' xubij cha: Taya-na chic can re juna' re'. Timbana-na c'a abonar re ulef re anche' tiquil-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Vo xa xtuya' rach, otz. Y vo xa man xtuya-ta rach, c'are' c'a xtachoy-a, xcha' re nisamajin chin re juyu'. Quire' re ejemplo re xutzijoj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y chupan jun k'ij chin uxlanen, re Jesús ye'rutijoj re vinak riq'uin re ruch'abal re Dios, pa jun nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicojol re vinak re quimalon-qui' chire', c'o jun ixok dieciocho juna' tiyavaj-va, re ruyabil re ixok re' ja re luculic rij rubanon, y cama-va nitiquir-ta nipa'e' ba' choj. Re ixok re' jun itzel espíritu banayon cha, mare' quire' rubanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero tak re Jesús xutz'at re ixok re', xrayoj y xubij cha: Vocame xacolotaj chach re ayabil. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya' ruk'a' pa rue' re ixok. Y re ixok can jare' tak xchojmer rij, xpa'e' jabal. Y re ixok can jare' tak xuya' ruk'ij re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero re ache re principal chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, camas itzel xuna' cha re Jesús roma xuc'achojsaj re ixok chupan re k'ij chin uxlanen. Mare' re ache re' xubij chique re vinak re quimalon-qui' chire': Ronojel semana c'o vaki' k'ij chin yojsamaj. Y chupan c'a re vaki' k'ij re' c'o modo yixpa riq'uin re Jesús chin yixc'achojsas, y mana-ta re k'ij chin uxlanen, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero re Ajaf Jesús can jare' xubij cha: Yex xa ca'e' ipalaj. Roma yex ye'sol-a re ivacx, re iquiej chupan jun k'ij chin uxlanen, chin yixba chuyi'ic quiya', y más c'a re' xa je chicop manak can-ta quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","C'alapa' re jun ixok re', re can rey-rumam can re Abraham, ancha'l yex. Y re Satanás dieciocho juna' tuxim-va-pa. Mare' yen nimbij che can otz nic'achojsas chupan jun k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tak re Jesús rubin chic-ka re tzij re', conojel re ye'tzelan richin, xe'q'uex chach. Jac'a re nic'aj chic vinak camas niqui'cot cánma, roma re Jesús camas nem re rusamaj re Dios ntajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y re Jesús xubij: ¿Andex como rubanic xtimbij chij re ru-gobierno re Dios? ¿Anchok riq'uin como xtinjonomaj-va? ");
INSERT INTO cakYNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Yen nimbij che junan riq'uin re semilla chin re mostaza re nutic jun ache pa rujuyu'. Tak niq'uiy, can ancha'l jun nema-che' nuban. Mare' re chicop c'o quixic' re ye'ba pa cak'ik', ye'bapon pa rue' y niquibanala' quisoc pa tak ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y re Jesús xubij chuka': ¿Andex como xtimbij chij tak re vinak ye'oc pa ruk'a' re Dios? ¿Anchok riq'uin como xtinjonomaj-va? ");
INSERT INTO cakYNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xa can junan c'a riq'uin re levadura re no'rc'ama-pa jun ixok y nuya' chupan oxe' pajbal harina muban, y can nuban che nuxol-ri' chupan ronojel, xcha' reJesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y re Jesús xutz'am chic-a rubey chin niba pa tenemit Jerusalén. Pero nabey xbak'ax-pa pa tak nima'k y cocoj tenemit, chin nutzijoj re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y c'o jun xc'utun cha re Jesús, y xubij cha: Ajaf, ¿je q'uiy como re xque'colotaj? Pero re Jesús xa chique conojel xch'o-va, y xubij: ");
INSERT INTO cakYNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Can titija' ik'ij tinimaj re ruch'abal re Dios. Ronojel re niban yex, can ja re nika chach re Dios jare' re tibana'. Roma re ruchi-jay re anche' yixak'ax-va, camas co'ol-oc rach. Y camas je q'uiy vinak xtiquijo' xque'oc chupan re ruchi-jay re', pero man xque'tiquir-ta xque'oc. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Y tak re rajaf jay xtiyacataj-pa y xto'rtz'apij can re ruchi-jay, y yex re c'amaje-na quixoc-apo riq'uin, astapa' yex xticocaj-apo y xtibij: Ajaf, Ajaf, tajaka' re ruchi-jay chakavach chin che yojoc-apo aviq'uin. Pero reja' xtubij-pa chiva: Man ntaman-ta anche' quixpo-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y yex xtibila-apo cha: Ja yoj re xojva-xojuq'uia' aviq'uin. Y ja pa tak bey chin re katenemit, chire' xabij-va re ruch'abal re Dios chaka. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Y reja' xtubij-pa chiva: Ximbij-yan chiva che man ntaman-ta anche' quixpo-va. Can man otz-ta che yixc'ue' viq'uin, yex xa yix banoy-etzelal, xticha' re Ajaf chiva. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y tak xque'itz'at re achi'a' re quibini'an Abraham, Isaac, Jacob y conojel re rusamajela' re Dios re xe'c'ue' ajuer can re xbex profetas chique, che jec'o pa ruk'a' re Dios, jare' tak xquixok' y xquixbison, y can xtikach'ach'ej irovay roma xixlisas can. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y xque'pa vinak re jec'o pa norte y sur, quire' chuka' xtiquiban re vinak re jec'o pan oriente y pan occidente. Y re vinak re' can quibanon confiar-qui' viq'uin. Y chuka' re vinak re' xque'c'ue' pa ruk'a' re Dios. Reje' xque'tz'uye-apo chach mesa. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y chire' jec'o xtic'ue' quik'ij re vocame manak quik'ij, y jec'o re camas quik'ij vocame, jare' xa manak chic quik'ij xtic'ue', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupan re mismo k'ij re', jec'o achi'a' fariseos xe'bapon riq'uin re Jesús, y xquibij cha: Re gobernador rubini'an Herodes nrajo' yatruquimisaj, mare' catel-a vova', cabiyin cha'nin, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero re Jesús xubij chique re achi'a' re': Quixbiyin y tibij cha re Herodes, che yen can xtimban-va seguir re samaj ntz'amon rubanic, y re samaj re' ja re ye'nlisaj itzel tak espíritu y ye'nc'achojsaj chuka' re ye'yavaj. Y c'a cabij xtinq'uis re nusamaj, quixcha' cha. Roma re Herodes camas listo chubanic re etzelal. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero yen tiene que xtimban seguir re nubey vocame, chua'k y cabij, pero man roma-ta che quire' nrajo' re Herodes. Roma tiene que yinapon pa tenemit Jerusalén, roma jun rusamajel re Dios re nibex profeta cha, man jun bey xtiquimisas-ta pa jun chic tenemit, sino que reja' chupan re mismo tenemit Jerusalén chire' niquimisas-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y c'are' re Jesús xch'o chiquij re vinak re jec'o pa tenemit Jerusalén. Reja' quire' xubij: Yex re yix aj-Jerusalén, yex re yix aj-Jerusalén, ¿anchique roma tak ye'quimisaj re rusamajela' re Dios re nibex profetas chique? ¿Anchique roma chuka' tak ye'quimisaj cha aboj re ye'rutak-pa re Dios chi'icojol? Y yen camas q'uiy bey xinjo' che xixinmol-ta viq'uin, ancha'l nuban re quite-ec' chique re ch'utak ral, ye'rumol chuxe' re ruxic'. Y yex man jun bey xijo' che quire-ta ximban chiva. ");
INSERT INTO cakYNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vocame re ivachoch yex xtic'ue' can ancha'l jun lugar re anche', manak vinak re nibex desierto cha. Y quire' nimbij chiva roma jac'a ruq'uisibal bey re' re xquinitz'at-a. Y xquinitz'at chic jun bey c'aja chupan re k'ij tak xtibij chua: ¡Matiox che pitinak re Jun re'! ¡Reja' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! C'a chupan re k'ij re' tak xquinitz'at chic jun bey, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y pa jun k'ij chin uxlanen, re Jesús xba pa rachoch jun chique re ec'uay quichin re achi'a' fariseos, roma re ache re' xuban invitar re Jesús chin jun va'in. Y re jec'o chire' niquitzu-niquitzu-apo re Jesús, ");
INSERT INTO cakYNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","roma chire' c'o-apo jun ache niyavaj. Y re ache re' c'o chach re Jesús y sipojnak re ru-cuerpo. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y re Jesús xubij chique re achi'a' je'atamayon re ley quichin re israelitas y chuka' chique re achi'a' fariseos re jec'o chire': ¿Andex nibij yex, la xajan como che nic'achojsas jun vinak niyavaj chupan jun k'ij chin uxlanen? ");
INSERT INTO cakYNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero re achi'a' je'atamayon re ley quichin re israelitas y re fariseos man jun tzij xquibij. Mare' re Jesús xutz'am-apo re ache niyavaj y xuc'achojsaj y xubij cha che tiba. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y re Jesús xubij chique re achi'a' re je'atamayon re ley y re achi'a' fariseos: Roma tak jun chiva yex nitzak jun ruquiej o jun ruvacx pa jun pozo, yex can jonanin yixba chulesasic, astapa' k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y re achi'a' re je'atamayon re ley quichin re israelitas y re fariseos man xquivel-ta andex xquibij-apo cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y xpa re Jesús xutz'am rubixic jun ejemplo chique re je'banon invitar chin re va'in. Roma xe'rutz'at re vinak re je'banon invitar che ye'quichala' quich'acat chin ye'tz'uye' chire' chach mesa. Mare' xubij chique: ");
INSERT INTO cakYNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tak c'o jun nibano invitar ivichin pa jun c'ulubic, man ticanoj re nabey tak ch'acat. Roma q'uiba' yat tz'uyul chic chire' tak napon jun vinak re c'o más ruk'ij que chavach rat, ");
INSERT INTO cakYNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nipa re banayon invitar avichin, nubij chava: Tabana' utzil taya' can re ach'acat cha re jun re', roma reja' nbanon invitar chuka'. Y rat can quiak yatruban-ka roma yaq'uex-ka y yatetz'uye' c'a chach re ruq'uisibal ch'acat. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mare' vo xa c'o jun nibano invitar ivichin pa jun c'ulubic, quixtz'uye' chach re ruq'uisibal tak ch'acat chin quire' tak yatrutz'at-pa re banayon invitar avichin, xte'ka aviq'uin y xtubij chava: Tabana' utzil catak'ax-pa vova'. Y tak quire' xtiban chava, conojel re ye'tz'uye' aviq'uin chach mesa chin re va'in xtiquitamaj che can c'o-va ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Roma re nuban che c'o ruk'ij xa xtikasas ruk'ij. Y jac'a re nuban che manak ruk'ij, can xtic'ue' ruk'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y re Jesús xubij chuka' cha re xbano invitar richin: Tak rat najo' ya'ban invitar vinak chin jun va'in, man c'a ca'ban invitar xaxe re itaman ivach quiq'uin, re ate-arta', conojel re je avch'alal, y re a-vecinos re je biyoma', roma reje' can ye'tiquir chuka' yatquiban invitar chin jun va'in pa cachoch, y riq'uin re' nik'alajin che can cha'nin niquitzolij rajal-ruq'uixel chava. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Mare' nimbij chava, tak c'o jun namak'ij naban pan avachoch, ca'bana' invitar vinak re camas je meba', re vinak manak quik'a-cakan, o ya'ban invitar re cojos y chuka' re je moyi'. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Y vo xa quire' xtaban, camas c'a otz xtabana' roma reje' man ye'tiquir-ta niquitzolij rajal-ruq'uixel chava. Pero rat can xtac'ul rajal-ruq'uixel, tak junan xquixc'astaj-a quiq'uin re vinak re manak quimac ndel chach re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y c'o c'a jun re tz'uyul chire' chach mesa, tak ruc'axan chic-ka re tzij re xe'rubij re Jesús, xpa reja' xubij-apo cha re Jesús: Otz-quibanoj re xque'c'ue' pa ruk'a' re Dios y can xque'va' chire', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y jare' tak re Jesús xubij: Jun bey jun ache nrajo' nuban namak'ij pa rachoch y nrajo' nusipaj jun va'in. Mare' reja' xe'ruban invitar je q'uiy vinak chin ye'beva' charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Y tak xapon re k'ij chin re va'in, re ache xutak-a jun ru-mozo chiquiyoxic conojel re vinak re je'rubanon invitar. Y re mozo xbo'rbij chique: Quixampa, koje'va', roma vocame ronojel c'o chic listo. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero can conojel xquibila-pa, che man ye'tiquir-ta ye'pa. C'o jun xbim-pa: Tabana' utzil tabij cha re a-patrón, che tucuyu' ba' numac che man yintiquir-ta yinapon, roma xa xinlok' jun vulef, y nic'atzin che yimba chutz'etic. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o chic jun re can quire' chuka' xubij: Tabana' utzil tabij cha re a-patrón che man yintiquir-ta yinapon, roma jec'o vo'o' c'ulaj nuvacx chin samaj xe'nlok', y nic'atzin che ye'ntojtobej. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y re jun chic xubij-pa che man nitiquir-ta nipa, roma xa c'a ba' tic'ule-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y tak re mozo xtzolaj riq'uin re ru-patrón, ronojel re xbex-pa cha xbo'rtzijoj cha. Mare' re ru-patrón itzel xuna', y xubij cha re ru-mozo: Vocame cabiyin pa tak calles y pa tak callejones chin re katenemit y ca'c'amala-pa re manak quik'a-cakan, re cojos, re je moyi', y chuka' re camas je meba'. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y tak xtzolaj re mozo, xubij cha re ru-patrón: Xe'nc'am-yam-pa re vinak re xabij-a chua, pero c'a c'o q'uiy ch'acat xuban sobra. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y re ru-patrón xubij chic cha: Vocame cabiyin tza'n tak jay y pa tak bey re ye'ba nic'aj chic tenemit, y tabij chique re vinak re' che que'pa, chin quire' ninoj re vachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Roma yen can katzij nimbij chiva che man jun chique re xe'mban invitar nabey, re xtiya-ta k'ij cha che niva' viq'uin, roma man xquijo-ta xe'pa tak xe'mban invitar pa nabey, xcha' cha re ru-mozo, quire' xutzijoj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y camas vinak re je'tzakatal-a chij re Jesús. Y tak reja' xtzu'un can chij y xe'rutz'at re vinak re', xpa'e', y xutz'am rubixic chique: ");
INSERT INTO cakYNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Vo xa c'o jun nipa viq'uin chin ndoc nu-discípulo, ja-ta c'a yen re más yinrajo'. Man otz-ta che ja-ta re rute-rutota' re más ye'rajo' que chinoch yen. Y man otz-ta chuka' che ja-ta re ruxayil, re rajc'ual, re je ruch'alal o can reja' mismo re más nrajo-ka-ri'. Y can ja-ta c'a yen re más yinrajo'. Roma vo xa man xtuban-ta quire', man nitiquir-ta ndoc nu-discípulo. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Re vinak re can nrajo-va ndoc nu-discípulo, can tujacha' c'a re ruc'aslen y man tupokonaj nuk'asaj tijoj-pokonal nutzij yen, can ancha'l che binak chuxe' ru-cruz. Jac'a re vinak re camas nupokonaj nuk'asaj tijoj-pokonal nutzij yen y man nrajo-ta yinrutzekelbej, man nitiquir-ta ndoc nu-discípulo. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Roma tak c'o jun chiva yex nrajo' nuban jun jay nem, reja' can nitz'uye' chin nunojij jenipa' mero xtoc cha, vo xa c'o ronojel riq'uin o manak chin nitiquir nuq'uis rubanic. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Roma vo xa re mero xaxe chin re ru-cimiento re jay c'o riq'uin y xtutanaba' can re samaj chire', xque'pa re vinak xque'tze'en chij, ");
INSERT INTO cakYNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y xtiquibila': La jun ache la' xrajo' xupoba' jun jay, y man xtiquir-ta xuq'uis rubanic, xque'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Y tak jun Rey nuban ayoval riq'uin jun chic Rey, can nitz'uye' chin nunojij vo xa quiq'uin lajuj mil soldados nitiquir nuban ayoval quiq'uin re veinte mil soldados re je'ruc'amom-pa re jun chic Rey. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y vo xa nunojij che man nitiquir-ta, reja' ye'rutak-a achi'a' chuc'ulic re jun chic Rey, tak c'amaje-na rutzijol che ne'ka. Y re achi'a' re ye'ba chuc'ulic ne'quic'utuj utzil cha che man niquijo-ta ayoval. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mare', vo xa jun chiva yex nrajo' ndoc nu-discípulo, tiene que nunojij nabey che nuya' can ronojel re c'o riq'uin. Vo xa man nuban-ta quire', man nitiquir-ta ndoc nu-discípulo. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Re atz'am camas otz. Pero xe-ta re atz'am niq'uis-ta-a re rutzayil, ¿andex como rubanic nakaban chin quire' nitzolaj-ta chic pa re rutzayil? Man jun. ");
INSERT INTO cakYNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Re atz'am re man nitzayin-ta chic, man otz-ta nicusas, y chuka' man otz-ta nicusas chin nixol riq'uin ulef chin ndoc abono. Re otz che niban cha ja che nitorex-a, roma man jun chic ndoc-va. Yex re c'o ixquin chin nic'axaj, can tic'axaj c'a re ximbij-ka, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y conojel re achi'a' molay tak impuestos y chuka' re vinak re nibex aj-maqui' chique, ye'jelon-apo riq'uin re Jesús chin niquic'axaj re ruch'abal re Dios re nutzijoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y ja vinak qui tak re' re ye'jelon-apo riq'uin re Jesús, mare' re achi'a' fariseos y re achi'a' je'atamayon re ley quichin re israelitas camas ye'ch'o chij re Jesús, y niquibila': Re Jesús junan quivach quiq'uin re aj-maqui'. Roma camas otz quic'ulic nuban y man xe-ta re', xa can niba chuka' quiq'uin cho tak cachoch chin ne'va', ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mare' re Jesús xutz'am rubixic jun ejemplo chiquivach, y xubij: ");
INSERT INTO cakYNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Tak jun chiva yex jec'o jun ciento ru-ovejas y nisatz-ta can jun tak je'ruc'uan-a, reja' can ye'ruya' can ba' re je noventa y nueve chire' pa juyu', y niba chucanoxic re jun satzanak can. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y tak no'rvila-pa re oveja re', nuya' c'a-pa chutila'n. Can niqui'cot roma xuvel-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y tak napon charachoch, ye'rayoj re vinak rutaman quivach, y ye'rayoj chuka' re ru-vecinos, y nubij chique: Quixqui'cot viq'uin vocame, roma re nu-oveja satzanak, xinvel. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Y can katzij nimbij chiva, che re jec'o chila' chicaj ye'qui'cot tak jec'o noventa y nueve vinak re choj quic'aslen, re jalatajnak chic quic'aslen chach re Dios. Pero más ye'qui'cot chila' chicaj, tak c'o jun aj-mac re nijalataj ruc'aslen chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","C'o-ta jun ixok re c'o lajuj fichas riq'uin, y cha re lajuj fichas re' nutzak jun chire' pa rachoch, reja' can nutzaj k'ak' y can otz chuka' rumesic nuban pa rachoch chin nucanoj re ru-ficha, hasta c'a nuvel-na. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tak ruvilon chic, ye'rayoj re vinak re rutaman quivach, y ye'rayoj chuka' re ru-vecinos, y nubij chique: Quixqui'cot viq'uin, roma re nu-ficha tzekenak, xinvel-yan. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y can katzij nimbij chiva, che tak c'o jun aj-mac nijalataj ruc'aslen chach re Dios, can chibil chuka' re ángeles chin re Dios camas ye'qui'cot, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y re Jesús xubij chuka' chique: C'o c'a jun ache jec'o je ca'e' ruc'ajol. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun k'ij re chak'alaxel xubij cha re rutota': Papá, yen ninjo-yan re nu-herencia. Y re tata'aj can xujach-va re herencia chiquivach che je ca'e'. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xa c'a jac'a jun ca'e-oxe' k'ij tijach-va re herencia, re chak'alaxel xutz'am ruc'ayixic ronojel re xya' can cha. Q'uiy mero xumol-a, y c'are' xba pa jun chic lugar re c'ac'anaj c'o-va. Y tak c'o chic chire', xuc'uaj jun itzel c'aslen, y mare' camas q'uiy mero nuq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Reja' xuq'uis c'a ronojel re ru-mero. Y jare' tak xpa jun namalaj viyjal chupan re lugar re anche' c'o-va. Y re c'ajol-ala' re' nich'umun rupan y manak chic ru-mero chin nucusaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y mare' xbo'rsuju-ri' chin ne'samaj riq'uin jun ache re c'o chire' chupan re lugar re', y re ache re' xutak-a pa rujuyu' chin ye'bo'rchajij ak. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y roma camas viyjal tz'amayon richin re c'ajol-ala' re', can nrajo' nutaj re niquitaj re ak. Roma man jun vinak niyi'o-ta jun cosa cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y re c'ajol-ala' re', c'ajare' tak xbeka chuc'o'x y xubij-ka pa ránma: Re je ru-mozo re nata' man niquitaj-ta viyjal, roma c'o q'uiy quivay. Pero yen yincom-yan roma viyjal vova'. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más otz quintzolaj-na riq'uin re nata', y xtimbij cha: Papá, ximacun chach re Dios, y can ximacun chuka' chavach rat. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man chic c'a ruc'amon-ta nabij ac'ajol chua. Más otz tabana' chua che yinoc jun a-mozo, xquincha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y can jare' tak xutz'am-a bey chin xba charachoch, anche' c'o-va re rutota'. Y c'ac'anaj c'a c'o-va re c'ajol-ala' cha re rachoch, tak re tata'aj xutz'at-yan-apo re ruc'ajol, y camas xujoyovaj rach. Mare' jonanin xba chuc'ulic, xuk'etej y xutz'ubaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y re c'ajol-ala' can jare' xubij cha re rutota': Papá, ximacun chach re Dios, y can ximacun chuka' chavach rat. Man chic c'a ruc'amon-ta che nabij ac'ajol chua. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero re tata'aj xubij chique re ru-mozos: Tilisaj-pa re tziak más otz y tiveka' re nuc'ajol. Tiya' jun napank'a' chuk'a' y tiya' chuka' ruxajab. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y te'ic'ama-pa chuka' re ch'et vacx re camas ti'oj, y tiquimisaj. Takabana' jun namak'ij, y kojva'. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Y quire' nimbij roma re jun nuc'ajol re' can quiminak chic chinoch yen, pero vocame can ancha'l che xc'astaj chic-pa. Roma satzanak-a, pero xbeka chic kaq'uin, xcha' re tata'aj. Y can jare' xtiquir re namak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y tak ntajin re namak'ij, re nemalaxel nisamaj pa juyu'. Y tak xtzolaj-pa y napon-yan-apo charachoch, xuc'axaj che c'o namak'ij ntajin. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mare' reja' xrayoj jun chique re qui-mozo y xuc'utuj cha: ¿Andex xbanataj? ¿Y anchique roma tak ntajin namak'ij? ");
INSERT INTO cakYNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y re mozo xubij cha: Roma xtzolaj-pa re achak' y ruxnak rach. Mare' re arta' xutak ruquimisasic re ch'et vacx re camas ti'oj. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tak xuc'axaj quire' re nemalaxel, xyacataj ruyoval, y man nrajo-ta c'a ndoc-apo pa jay. Mare' xbe'el-pa re rutota', y nubuchila', chin quire' ndoc-ta-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero man xrajo-ta. Reja' xubij cha re rutota': Yen can nojel tiempo yinsamaj aviq'uin y man jun bey man-ta niniman atzij. Pero man jun bey ayi'on-ta jun cosa chua. Astapa' can ála-ta jun ch'et cabra, chin nakaban-ta jun namak'ij quiq'uin re nu-amigos, pero re' can man jun. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y vocame rat xaquimisaj re ch'et vacx ti'oj, xaxe roma xtzolaj-pa re jun ac'ajol re', y reja' xa xbo'rq'uisa-yan can ronojel re abiyomal chiquivach ixoki' re man otz-ta quic'aslen, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y re tata'aj xubij: Nuc'ajol, xcha' cha. Rat can viq'uin yen yatc'o-va. Mare' ronojel re c'o viq'uin, can avichin-va rat. ");
INSERT INTO cakYNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero re achak' re' can quiminak chic chinoch yen, y vocame can ancha'l che xc'astaj chic-pa. Roma satzanak y vocame xbeka chic kaq'uin. Y mare' can nimban namak'ij y re kánma camas niqui'cot, xcha' re tata'aj cha re ruc'ajol nemalaxel. Ja ejemplo re' re xubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Re Jesús xubij chuka' chique re ru-discípulos: C'o c'a jun ache biyom. Y re biyom re' c'o c'a jun ache pa'al chij ronojel re rubiyomal reja'. Y cha re ache biyom xtzijos-va che re ache pa'al chij ronojel re rubiyomal ntajin chuq'uisic. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y re patrón xutak ruyoxic re ache pa'al chij ronojel re rubiyomal. Y tak xbeka xubij cha: ¿Andex nabij chua chij re nitzijos chavij? Vocame ninjo' nintz'at andex rubanon ronojel re biyomal nyi'on pan ak'a', roma vocame manak chic asamaj, xcha' re patrón cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y re ache pa'al chij ronojel re biyomal xunojij-ka pa ránma: ¿Andex nimban vocame? Roma re nu-patrón nulisaj nusamaj. Y xtimban-ta chic jun samaj re nrajo' echuk'a' man yintiquir-ta chic. Y xquinoc-ta c'utuy-limosna yinq'uex. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Y tak xunojij-yan jabal, xubij: Vocame ntaman chic andex xtimban, chin quire' jec'o ye'c'ulu vichin pa tak cachoch, tak xtilisas nusamaj, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Y c'are' xe'rayoj che ja'jun che ja'jun re c'o quic'as riq'uin re ru-patrón, y xuc'utuj cha re nabey: ¿Rat andex re ac'as, y jenipa'? ");
INSERT INTO cakYNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y re ache re c'o ruc'as xubij cha: Yen c'o jun ciento barril aceite olivo nuc'as, xcha'. Y re ache pa'al chij ronojel re biyomal xubij cha re ache c'o ruc'as: Ja ruvujil re ac'as re'. Y vocame cha'nin catz'uye' y tabana' chic can jun ruvujil. Y chupan re jun chic vuj re xtaban, tabana-ka chupan che xaxe nic'aj ciento barril aceite re ac'as. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y tak xapon chic jun re c'o ruc'as, re ache pa'al chij ronojel re biyomal xuc'utuj cha: Y rat ¿andex re ac'as y jenipa'? Re ache c'o ruc'as xubij: Yen ochocientos quintal trigo nuc'as, xcha' cha. Y reja' xubij cha: Ja ruvujil re ac'as re', y vocame catz'uye' y tabana' chic jun ruvujil. Y chupan re jun chic vuj re xtaban, tabana-ka chupan che xe seiscientos cincuenta re ac'as, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y tak re ru-patrón xuc'axaj re rutz'amon rubanic re itzel ache, xubij: C'o runa'oj, xcha'. Y ja quire' re vinak re man quiniman-ta re Dios. C'o quina'oj y camas je listo quiq'uin re vinak. Y camas-va chuka' je listo, que chiquivach re vinak re je richin chic re sakil. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y yen nimbij chiva, xcha' re Jesús. Q'uiy bey re biyomal chin re ruch'ulef, man otz-ta rucusasic niban cha coma re vinak. Jac'a vo xa can pan ik'a' yex re yix rajc'ual chic re Dios c'o-va re biyomal re', can ticusaj chin che ye'to' re nic'atzin quito'ic. Chin quire' tak re ibiyomal xtiq'uis, xquixc'ul chila' chicaj, chupan re jay re man jun bey xque'q'uis. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Re jun re can otz nuban riq'uin jun samaj co'ol-oc, xa can otz chuka' xtuban riq'uin jun samaj nem. Jac'a re man otz-ta nuban riq'uin jun samaj co'ol-oc, xa can quire' chuka' xtuban riq'uin jun samaj nem. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y quire' chuka' riq'uin re biyomal chin re ruch'ulef, roma vo xa yex man otz-ta niban cha, re Dios can man xtujach-ta re katzij biyomal pan ik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Roma vo xa man otz-ta niban riq'uin re biyomal chin re ruch'ulef re man ivichin-ta yex, c'alapa' riq'uin re katzij biyomal re can ivichin-va yex otz-ta xtiban cha, mare' re Dios man nuya-ta pan ik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Y man jun mozo nibano che je ca'e-ta ru-patrón, roma man nitiquir-ta nisamaj quiq'uin che je ca'e' al mismo tiempo. Roma vo xa nrajo' jun chique re je ca'e' ru-patrón, tiene que nutzelaj re jun chic. Y vo xa can nunimaj rutzij re jun, man nitiquir-ta nuban quire' riq'uin re jun chic. Mare' manak modo che jun vinak re can ruyi'on ránma riq'uin re biyomal re nitiquir-ta nuban re nrajo' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y tak re achi'a' fariseos xquic'axaj re xubij re Jesús, xe'tze'en-apo chij, roma reje' can quiyi'on cánma riq'uin re biyomal. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y re Jesús xubij chique: Yex can nibananej chiquivach re vinak che camas yix choj y camas yix otz. Pero re Dios rutaman andex re c'o pa tak ivánma, y man otz-ta yixrutz'at. Y re' astapa' jenipa' jabal otz yixtz'et coma re vinak y astapa' can xtiquiya' ik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y tak re Juan Bautista c'amaje-na tutz'am rutzijosic re ruch'abal re Dios, xa can c'aja re ley chin re Moisés re nitzijos. Y xa can c'aja chuka' re ruch'abal re Dios re tz'iban can coma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, can c'aja chuka' re' re nitzijos. Pero tak xpa re Juan, jare' tak xtiquir-a rutzijosic re utzulaj ruch'abal re Dios re nich'o chij tak re vinak ye'oc pa ruk'a' re Dios, re nibex evangelio cha. Y je q'uiy vinak re can niquitaj quik'ij chin ye'oc chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Y chuka' nimbij chiva, che man can-ta c'ayef che re ruch'ulef y re rocaj ye'q'uis, que chach re ley. Roma ronojel re nubij chupan re ley tiene que nibanataj, y man jun cosa re man-ta xtibanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y re Jesús xubij chuka': Vo xa c'o jun ache c'ulan nujach-ri' riq'uin re ruxayil y c'are' nuc'am chic-apo jun ixok, re ache re' nimacun chach re Dios. Y vo xa c'o jun ache nuc'am-apo jun ixok c'ulan y yi'on can roma re ruchijil, chuka' re ache re' nimacun chach re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y re Jesús xubij chuka': Xc'ue' jun ache camas biyom. Re ache re' rion tziak camas caro cajal re ye'rucusala', y k'ij-k'ij nubanala' namak'ij charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero xc'ue' chuka' jun ache c'utuy-limosna y nojnak re ru-cuerpo che itzel tak ch'a'c. Reja' rubini'an Lázaro, y can jac'a chuchi-rachoch re biyom nic'ue-va-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Re Lázaro camas nurayij che nutaj-ta re ruchi' tak vay re ye'tzak-ka chuxe' ru-mesa re biyom. Y re tz'e' can ye'ba-apo riq'uin churek'ic re itzel tak ch'a'c re jec'o chij. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y jun k'ij re Lázaro xcom, y jac'a re lugar re camas jabal re nibex paraíso cha, chire' xapon-va riq'uin re Abraham. Ja lugar re' xc'uax-va-a, coma re ángeles. Y chuka' re ache biyom xcom, y xmuk. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y tak reja' nutaj chic pokan chupan re lugar re nibex infierno cha, anche' ye'bapon-va re anama'i' re man xquinimaj-ta-a re Dios, jare' tak xtzu'um-pa y jare' tak xutz'at re Abraham, pero c'ac'anaj c'a c'o-va. Xutz'at chuka' re Lázaro rak'al-apo chuc'o'x re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y re ache biyom cof xch'o, y xubij cha re Abraham: Nata' Abraham, tajoyovaj noch. Tabana' utzil tabij cha re Lázaro, che astapa' xaxe re rutza'n rue-ruk'a' tuch'ekeba', y tataka-pa viq'uin vova', chin no'rya' can chutza'n re vak'. Roma re vánma nic'at chupan re k'ak' re', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero re Abraham xubij cha: Te'ka cha'c'o'x rat nuc'ajol, tak xac'ase' chach re ruch'ulef, camas jabal xak'asaj re ac'aslen, y re Lázaro camas tijoj-pokonal xuk'asaj y vocame camas otz ruc'aslen xbo'rvila' vova', y rat xa jun c'aslen chin tijoj-pokonal xavel. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chuka' c'o jun namalaj sivan chakacojol. Mare' vo xa c'o jun re c'o vova' nrajo-ta napon iviq'uin, man nitiquir-ta. Y c'o-ta jun chiva yex nrajo' nipa vova' kaq'uin yoj, man nitiquir-ta chuka', xcha' re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y re ache biyom xubij: Vo xa quire', ninjo' ninc'utuj chic jun utzil chava rat nata' Abraham. Tataka-a ba' re Lázaro chach re ruch'ulef, pa rachoch re nata'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Roma jec'o je vo'o' vach'alal, y ne'ch'o-ta quiq'uin, chin che man que'pa chupan re jun lugar re' chin tijoj-pokonal, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y re Abraham xubij cha: Reje' c'o re ruch'abal re Dios re rutz'iban can re Moisés quiq'uin. Y c'o chuka' re ruch'abal re Dios re tz'iban can coma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. Jare' re tiquic'axaj y tiquinimaj, xcha' re Abraham cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y re ache biyom xubij: Ja', can katzij, nata' Abraham. Pero vo xa c'o jun re quiminak chic-a re nic'astaj-a y napon quiq'uin re vach'alal, can xtiquinimaj-va re Dios y nijalataj quic'aslen chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero re Abraham xubij cha: Vo xa can man niquinimaj-ta re ruch'abal re Dios re rutz'iban can re Moisés, y man niquinimaj-ta chuka' re ruch'abal re Dios re je'quitz'iban can re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, astapa' chuka' c'o jun re nic'astaj-a chiquicojol re anama'i', cama-va xtiquinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Re Jesús xubij chique re ru-discípulos: Can nojel tiempo c'o xtibano chique re vinak chin ye'macun. Pero re vinak re xtibano cha jun chic vinak che nimacun, xa tivok'ex c'a rach re quire' nibano. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mare' yen nimbij, antes che nuban re etzelal re', más-ta otz cha reja' che nixim-ta jun moma' aboj chukul y ne'torex can pa mar, que chach nuban quire' cha jun vinak re c'a ba-oc quinrunimaj-va che nitzak pa mac. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mare' yex tichajij re ic'aslen. Y vo xa c'o jun hermano c'o jun cosa re man otz-ta nuban chava, tabij cha che man otz-ta re xuban chava. Y vo xa reja' no'rc'utuj cuyubal rumac chavach roma xuna' che man otz-ta xuban chava, tacuyu' c'a rumac. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y vo xa chupan re mismo k'ij re' vuku' bey re man otz-ta xuban chava y che vuku' bey nipa aviq'uin y nubij chava: Tacuyu-tasatza' numac, can ruc'amon che nacuy rumac, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y re apóstoles xquibij cha re Kajaf Jesús: Tabana' chaka che nakaban-ta más confiar-ki' riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pero re Ajaf Jesús xubij chique: Vo xa yex ibanon confiar-ivi' riq'uin re Dios, astapa' ba-oc ancha'l jun ch'et semilla chin mostaza, y nibij-ta cha re che' rubini'an sicómoro che tel-a vova' y tak'ax chupan re mar chin ne'tique' chire', re che' re' can xtunimaj-va itzij. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Man jun chiva yex re nibano che tak nutak-a jun ru-mozo pa rujuyu' chin no'rbana' arar re ulef o ye'bo'rchajij-ta ovejas, che can xe-ta tak nitzolaj-pa nubij cha: Catoc pa jay, catz'uye' chach mesa y cava', ");
INSERT INTO cakYNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","en lugar che quire-ta nubij cha, xa nutak chubanic preparar re xtutaj chin tak'ak'ij, y chuka' nubij cha che can tabana' abanic chin che naya-pa re xtintaj y re xtinkum, y c'aja tak xinva-xinuq'uia-yan, c'are' xcava-xcatuq'uia' rat, nicha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Y man jun bey nutioxij cha re ru-mozo roma xuban re xubij cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y can ancha'l re mozo re', quire' chuka' yex. Tak ibanon chic re samaj re nubij re Dios chiva, tibij: Yoj re yoj mozos man jun yojc'atzin-va. Roma xaxe-oc re bin chaka, xaxe-oc re' re xkaban, quixcha', xcha' re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y tak re Jesús je ruchibil-a re ru-discípulos xutz'am chic-a bey pa Jerusalén, xk'ax c'a chiquicojol re lugar quibini'an Samaria y Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y tak ye'bapon-yan-apo pa jun aldea, jec'o c'a je lajuj achi'a' c'o yabil rubini'an lepra chiquij. Re achi'a' re' xbequirama' chach re Jesús, pero c'ac'anaj c'a xe'pa'e-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y jun pa quichi' xe'ch'o-apo cha re Jesús y xquibij: Ajaf, tajoyovaj kavach roma re kabanon, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y tak re Jesús xe'rutz'at, xubij chique: Quixbiyin y te'ic'utu-ivi' chiquivach re sacerdotes, xcha-a chique. Y tak quitz'amon-a bey chin ne'quic'utu-qui' chiquivach re sacerdotes, po bey xq'uis-va-a re yabil chiquij y can xe'ch'ojch'ojer-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun chique re je lajuj achi'a' re', tak xutz'at che can xc'achojsas-va cha re ruyabil, reja' xtzolaj. Y camas nuya' ruk'ij re Dios, y can cof nich'o tak quire' nuban. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y tak xapon riq'uin re Jesús, xuque' chach y c'a pan ulef xka-va-ka re nic'aj-rach, y camas nutioxij cha re Jesús. Y re ache re' aj-Samaria. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y re Jesús xubij: Pero yex yix lajuj re xixch'ojch'ojer cha re iyabil. ¿Y anche' jec'o-va re je nueve chic? ");
INSERT INTO cakYNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Y re je nueve cama-va xe'tzolaj-ta-pa chin che niquiya' ruk'ij re Dios. Xaxe re jun re' re man israelita-ta re xtzolaj-pa chin che nuya' ruk'ij re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y re Jesús xubij cha re ache aj-Samaria: Cayacataj y cabiyin. Xac'achoj roma can xaban confiar-avi' viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y re achi'a' fariseos xquic'utuj cha re Jesús che jampa' c'a xte'ka re ru-gobierno re Dios. Y re Jesús xubij chique: Man xtinabex-ta jampa' xte'ka, roma re ru-gobierno re Dios man nitz'et-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y man jun xtibin-ta che ja re c'o vova', o ja la c'o chila', roma re ru-gobierno re Dios c'o chic iviq'uin, xcha' re Jesús chique re achi'a' fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y reja' xch'o chique re ru-discípulos, y xubij: Xte'ka re k'ij tak yex xtijo' che xquinc'ue-ta chic jun k'ij iviq'uin, yen re xinalax chi'icojol. Pero man xquinitz'at-ta chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y can jec'o xque'bin chiva: Ja re c'o vova'. Ja la c'o chila'. Pero yex man quixba quiq'uin, y chuka' man quixtzake' chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Roma tak xtapon re k'ij che yen re xinalax chi'icojol tak xquimpa chic jun bey, xquineka ancha'l tak niyiq'uiyo' jun relámpago, y can nik'alajin jabal roma nusekresaj re rocaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nabey tiene que nink'asaj q'uiy tijoj-pokonal, y chuka' yintzelas coma re vinak chin re tiempo re', re yojc'o-va vocame. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y re k'ij tak xquimpa yen re xinalax chi'icojol, can xtibanataj-va chuka' ancha'l re xbanataj chupan re tiempo tak xc'ue' re Noé. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chupan re ru-tiempo re Noé, re vinak man jun chic re c'o-ta más rajkalen chiquivach. Re vinak xa can xe c'a re quivay-cuq'uia' y chuka' re c'ulubic jare' re niquinojij, ye'quiyala' c'a quimi'al-cajc'ual chin ye'c'ule'. Jare' re ye'quinojela' reje', tak xapon re k'ij chin che re Noé y re ru-familia xe'oc chupan re barco, y xutz'am c'a re job re can man jun bey tz'eton-ta re nibex diluvio cha. Y can conojel c'a re nic'aj chic vinak xe'com. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y can quire' chuka' xbanataj pa ru-tiempo re Lot. Re vinak binak cánma chij re anchique ye'quitijla' y re anchique ye'quikumula', chij re quilak'oj, re quic'ayij, re quitico'n y ye'quibanala' cachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y re k'ij tak re Lot y re ru-familia xquiya' can re tenemit Sodoma, xka c'a can k'ak' y azufre pa rue' re tenemit re'. Can ancha'l job xuban tak xka-pa chicaj, y can conojel vinak re jec'o chire' xe'ruq'uis re k'ak'. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y re k'ij tak yen re xinalax chi'icojol xquinec'ulun chic-ka vova' chach re ruch'ulef, sabalaj vinak re xa riq'uin ronojel andex re c'o quiq'uin binak-va cánma. Y mare' xtika re castigo pa quive'. Can xtibanataj-va ancha'l xbanataj quiq'uin re xe'c'ue' pa tenemit Sodoma. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Re nixulan pa rue' rachoch tak napon re k'ij re', choj quire' tinumaj-a. Man chic toc-apo pa rachoch chin c'o cosas no'rc'ama-pa. Y vo xa c'o chuka' jun re nisamaj pak'os chupan re k'ij re', man chic titzolaj charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Roma xaxe te'ka chi'c'o'x re xuban re ruxayil re Lot, tak xparox re tenemit Sodoma roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Re camas nupokonaj re ruc'aslen vova' chach re ruch'ulef, re ruc'aslen can xtiq'uis-va. Jac'a re man nupokonaj-ta re ruc'aslen chin vova' chach re ruch'ulef, re ruc'aslen can man xtiq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Y tak yen xquimpa chic jun bey, vo xa jec'o je ca'e' ye'var chach jun ch'at, xaxe c'a jun re xtic'uax-a y re jun chic xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Y vo xa jec'o je ca'e' ixoki' re junan ye'qui'en, xaxe c'a jun re xtic'uax-a y re jun chic xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y vo xa jec'o je ca'e' achi'a' re junan chuka' ye'samaj pak'os, xaxe c'a jun re xtic'uax-a y re jun chic xtic'ue' can. ");
INSERT INTO cakYNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y tak re discípulos quic'axan chic-ka re xubij re Jesús, xquic'utuj cha: Ajaf, ¿anche' c'a xtibanataj-va re c'a ba' tabij-va-ka? Y re Jesús xubij chique: Re castigo re xtuya' re Dios xte'ka anche' c'o-va re mac. Can xtibanataj ancha'l nibanataj quiq'uin re c'uch. Roma re chicop re' xaxe anche' c'o-va jun cuerpo quiminak, chire' ye'ka-va, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y re Jesús xutzijoj jun ejemplo chique re ru-discípulos, chin che nuc'ut chiquivach che can nic'atzin-va che can nojel tiempo tiquibana' orar y man jun bey tiquiya' can rubanic re oración. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Reja' xubij chique: C'o jun juez xc'ue' chupan jun tenemit re man nuxibij-ta-ri' chach re Dios, y camanak-va chuka' quijkalen re vinak chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan re tenemit re', c'o chuka' jun malca'n-ixok. Y re malca'n-ixok re' ndel-ndoc riq'uin re juez re', chin nuc'utuj utzil cha che tuto' chin che nich'acon chij re banayon ch'a'oj cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y q'uiy k'ij xk'ax, y re juez re' man nrajo-ta nuto' re ixok malca'n. Pero jun k'ij re juez re' xunojij c'a-ka pa ránma: Astapa' yen man niniman-ta re Dios, y man jun chuka' quijkalen re vinak chinoch, ");
INSERT INTO cakYNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero roma re ixok re' ndel-ndoc viq'uin, tinto-na. Roma vo xa man xtinto-ta, xtak'ax nuc'o'x pa ruk'a'. Ja ejemplo re' re xutzijoj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y c'are' re Ajaf Jesús xubij: Yen ntaman che yex otz xic'axaj re tzij re xe'rubij re itzel juez. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","C'alapa' re Dios che man-ta xque'ruto' re vinak re je'rucha'on chic reja' y che pak'ij che chak'a' niquiban orar. Re Dios can cha'nin xque'ruto-pa re vinak re je'rucha'on chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Y tak yen re xinalax chi'icojol tak xquimpa chic jun bey vova' chach re ruch'ulef, ¿la c'a jec'o como vinak re quibanon confiar-qui' riq'uin re Dios? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y re Jesús xubij chic jun ejemplo chiquivach re vinak, roma jec'o chique reje' re niquinojij che can xe reje' re camas je choj riq'uin re quic'aslen y niquibij chique re nic'aj chic vinak che man otz-ta quic'aslen. Mare' re Jesús xubij: ");
INSERT INTO cakYNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jec'o je ca'e' achi'a' re xe'ba pa rachoch re Dios chin ne'quibana' orar. Re jun ache, jun chique re fariseos, y re jun chic jun chique re molay tak impuestos. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Re ache fariseo pa'al nuban orar, y nubij chupan re ru-oración: Dios, nintioxij chava roma yen man yin junan-ta quiq'uin re nic'aj chic vinak. Roma reje' je elek'oma', ye'quicanoj chic nic'aj ixoki', y man je choj-ta chupan re quic'aslen. Y man yin junan-ta chuka' riq'uin la jun ache la aj-molay-impuestos la nuban chuka' orar chila'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Roma yen ca'e' k'ij nimban ayuno pa jun semana, chin nimban orar. Y ronojel re ninch'ac, lajuj partes nimban cha, y jun cha re lajuj partes re ninya' chava rat, xcha' re fariseo pa ru-oración. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Y jac'a re molay-impuestos c'ac'anaj pa'al-va can chin nuban orar, pero jun-oc lucul-va, roma chach reja' can man ruc'amon-ta che nuban cha re nak'arach che nitzu'un chicaj y reja' ja re ruk'a' nuyala' chuc'o'x, quire' nuban roma reja' can nuna' che camas rumac, y nubij cha re Dios: Tajoyovaj noch, roma yen yin jun aj-mac chavach. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Can katzij nimbij chiva, xcha' re Jesús, che re ache molay-impuestos xtzolaj-a, y man jun rumac xel chach re Dios. Jac'a re ache fariseo man quire-ta xel chach re Dios. Roma xabanchique re nuban che camas ruk'ij, xtiban cha che xtikasas ruk'ij. Jac'a re nuban che manak ruk'ij, can xtic'ue' ruk'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y re vinak ye'quic'amala-pa re ac'ola' riq'uin re Jesús, chin che nuya-ta-a ruk'a' pa quive'. Pero tak re discípulos xquitz'at quire' xquibij chique re vinak che man que'quic'amala-pa re ac'ola' riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero re Jesús xe'rayoj y xubij chique: Tiya' k'ij chique re ac'ola' che que'pa viq'uin, y man que'ik'at. Roma re xque'oc pa ruk'a' re Dios, xaxe re je ancha'l ac'ola'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y can katzij nimbij chiva, che re man niquiban-ta ancha'l re ac'ola' chin niquijach-qui' pa ruk'a' re Dios, can man xque'oc-ta pa ruk'a' re Dios, xcha' chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y c'o c'a jun ache re camas ruk'ij, xuc'utuj cha re Jesús: Rat utzulaj Maestro, ¿andex re ruc'amon che nimban yen chin quire' ninvel-ta re c'aslen re man niq'uis-ta? xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y re Jesús xubij cha: ¿Anchique roma tak nabij otz chua che yen yin otz? Roma can man jun vinak re otz-ta, xa can xe c'a re Jun re otz y re' ja re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Y yen nimbij che rat ataman re lajuj mandamientos re xuya' re Dios pa ruk'a' re Moisés ajuer can, che rat ache re yatc'ulan man camacun riq'uin jun chic ixok, man caquimisan, man catelak', man tatz'uc tzij chij jun chic vinak, taya' quik'ij re ate-arta', xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y re ache xubij cha re Jesús: C'a yin co'ol che' tak nbanom-pa ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tak re Jesús xuc'axaj quire', xubij: C'a c'o jun cosa re man abanon-ta. Man ajachon-ta re abiyomal chiquivach re vinak re camas je meba'. Tac'ayij ronojel re c'o aviq'uin y re rajal tajacha' chiquivach re vinak camas je meba', chin quire' nic'ue' abiyomal chila' chicaj. Y catampa viq'uin y catzake' chuij, xcha' re Jesús cha re ache biyom. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y tak re ache xuc'axaj re xubij re Jesús cha, camas xbison pa ránma roma camas biyomal c'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y tak re Jesús xutz'at che camas bis xpa pa ránma re ache, xubij: Re c'o quibiyomal, camas c'ayef chin che ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mare' yen nimbij che man c'ayef-ta che nak'ax jun camello pa ch'et rujulil jun bak chin t'iso'n, que chach jun biyom ndoc-ta pa ruk'a' re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Re xe'c'axan re xubij re Jesús, xquibila': Vo xa can quire' ancha'l nubij re Jesús, camas c'ayef, roma man jun xticolotaj, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y re Jesús xubij chique: Chiquivach re vinak c'o cosas camas c'ayef chin che ye'ban. Pero chach re Dios man jun cosa c'ayef, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Jare' tak xpa re Pedro xubij: Rat ataman che yoj kayi'on can ronojel re c'o kaq'uin, chin yojtzakatal chavij. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y re Jesús xubij chique: Can katzij nimbij chiva, che xabanchique vinak can c'o q'uiy cosas xtuc'ul, pero vo xa can ruyi'on can rachoch, rute-rutota', ruch'alal, ruxayil o rajc'ual, chin nuban re rusamaj re Dios y can ye'ruto' re nic'aj chic che ye'oc pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Can q'uiy-yan cosas nuc'ul chupan re tiempo re katz'amon Y chuka' chupan re jun chic tiempo re pitinak, can xtuc'ul c'a re ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y re Jesús xaxe c'a quiq'uin re je doce ru-discípulos xch'o-va, y xubij: Yex itaman che pa tenemit Jerusalén katz'amon-va-a bey, y chire' q'uiy c'a andex xtiban chua yen re xinalax chi'icojol. Can ronojel-va re tz'iban can chuij chupan re ruch'abal re Dios can xtibanataj-va, can ancha'l re quitz'iban can re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquinjach pa quik'a' vinak re man je israelitas-ta. Y re vinak re' xque'tze'en chuij, xtiquibila' itzel tak tzij chua y xque'chuban chuij, ");
INSERT INTO cakYNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","xquinquich'ay y c'are' xquinquiquimisaj. Pero pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero re discípulos man xk'ax-ta pa quive' re xubij re Jesús chique, roma can c'ayef xuban chique che xk'ax-ta otz pa quive', mare' xaxe tal choj quire' xquic'axaj y man quitaman-ta andex ndel-va che tzij. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tak re Jesús ndoc-yan-apo pa tenemit rubini'an Jericó, chire' chuchi-bey tz'uyul c'a jun ache. Y re ache re' moy, y nuc'utula' limosna chique re vinak re ye'k'ax chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y tak re moy re' xuc'axaj che sabalaj vinak ye'k'ax chire', xuc'utuj-apo chique andex xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y re vinak xquibij cha che ja re Jesús aj-Nazaret pitinak y nak'ax chire'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y re ache moy cof xch'o, y xubij: Tajoyovaj noch rat Jesús, re yat rey-rumam can re Rey David, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y re vinak re je nabey chach re Jesús, xquibila' cha re ache: Ch'oj-achi'. Pero reja' xa más cof xch'o, y xubij: Rat re yat rey-rumam can re Rey David, tajoyovaj noch roma quire' nbanon, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y re Jesús xuc'axaj re ruch'abal re ache. Mare' xpa'e' y xubij che tiquic'ama-pa. Y tak c'amon chic-pa re ache riq'uin, xuc'utuj cha: ");
INSERT INTO cakYNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Andex najo'? Y re ache moy xubij: Ajaf, yen ninjo' yintzu'un, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y re Jesús xubij cha: Catzu'un. Roma xaban confiar-avi' viq'uin, mare' xac'achoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y re ache moy can jare' tak xtzu'un y xtzake-a chij re Jesús. Y can nuya' chuka' ruk'ij re Dios. Y conojel re vinak re xe'tz'eto che re moy xtzu'un, can xquiya' ruk'ij re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y jare' tak re Jesús je ruchibil-a re ru-discípulos xe'oc-apo pa tenemit rubini'an Jericó, y xa choj c'a nak'ax chupan re tenemit re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y chire' chupan re tenemit re' c'o c'a jun ache biyom rubini'an Zaqueo. Re ache re', jare' re c'o más ruk'ij que chiquivach re nic'aj chic molay tak impuestos. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y reja' can nutaj ruk'ij chin nutamaj-a rach re Jesús, pero roma camas vinak y reja' camas co'ol-oc rakan, mare' man nitiquir-ta nutamaj-a rach. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Mare' reja' jonanin xnabayaj-a chiquivach re vinak y xjote' chuk'a' jun che' re nibex sicómoro cha, chin quire' nitiquir nutamaj-a rach re Jesús, roma chire' nak'ax-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y tak re Jesús xk'ax chire', xutz'at-a re Zaqueo chuk'a' che', y xubij cha: Zaqueo, cha'nin caka-pa chire', roma can ja vocame yinapon cha'vachoch, chin che yinxulan ba' chire', xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y re Zaqueo can cha'nin xka-pa, y camas niqui'cot xuc'ul-apo re Jesús charachoch. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tak xbanataj quire', re vinak niquibila' chij re Jesús che xa pa rachoch jun ache aj-mac xcanaj-va can. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y re Zaqueo xpa'e', c'are' xubij cha re Ajaf Jesús: Ajaf, vocame pa nic'aj cha re nubiyomal ninjach chiquivach re vinak re camas je meba'. Y re vinak re c'o mero xinlek'aj chiquik'a' roma xe'nk'ol, caje' bey más re ruq'uixel re xtintzolij chique, man xe-ta chic re xinlek'aj chiquik'a', roma yen can xk'ax rue' re impuestos re xinc'utuj chique, can man xe-ta chic re impuestos re niquitoj cha re gobierno, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y re Jesús xubij cha: Vocame rat can xcacolotaj chach re amac y chibil chuka' re a-familia xque'colotaj, roma rat can xaban confiar-avi' viq'uin, y can yat jun chuka' rey-rumam can re Abraham. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Roma yen re xinalax chi'icojol, can yimpitinak-va chiquicanoxic y chiquicolic re jec'o pa mac, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Y tak re Jesús rubin chic-ka ronojel re' chique re vinak, xutz'am rubixic jun ejemplo chiquivach. Quire' xuban roma nakaj chic c'o-va cha re tenemit Jerusalén, y chuka' re vinak re ye'c'axan richin niquinojij che tak reja' xtoc-apo pa tenemit Jerusalén, can jare' tak xtitiquir-a re ru-gobierno re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y reja' xubij: Xc'ue' c'a jun ache camas ruk'ij. Re ache re' xba pa jun chic nación re c'ac'anaj c'o-va, chin che nibex-pa cha che ja reja' re ndoc Rey. Y c'are' nitzolaj-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero tak c'amaje-na tiba, xe'rayoj je lajuj ru-mozos y cada jun xuya' can q'uiy mero chique, y xubij: Tic'uaj re mero re xinya' can chiva chin che c'o más nich'ac chij, c'a jampa' xquintzolaj-pa yen, xcha' can chique, y xba. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Y tak c'o chic chupan re nación re anche' xapon-va chin nibex-pa cha che ja reja' re ndoc can Rey, re ruvinak re ache ndoc can Rey jec'o achi'a' re mismo je quivinak xe'quitak-a c'a chupan re lugar re c'a anche' xapon-va re ndoc can Rey. Y re achi'a' je'takon-a xbequibij: Yoj man nakajo-ta che re ache re' ndoc can Rey chin re ka-nación, xe'cha'. Re je'takayon-a quichin re achi'a' re', camas niquitzelaj re ache re ndoc can Rey. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Y astapa' quire' xquiban re ruvinak cha, pero re ache re' can xbex-va-pa cha che ja reja' re ndoc can Rey, y xtzolaj-pa. Y tak c'o chic pa ru-nación, xutak quiyoxic re ru-mozos re xuya' can mero chique tak reja' c'amaje-na tiba che', roma nrajo' nutamaj jenipa' mero xquich'ac cada jun chij re mero re ruyi'on can chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tak xapon re nabey mozo, xubij: Patrón, re mero re xaya' can chua chin che c'o más ninch'ac chij, can xinch'ac-va lajuj tanto más chij, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y re ache re Rey chic chupan re tiempo re', xubij cha re ru-mozo: Camas otz xaban. Yat jun utzulaj mozo. Y roma camas otz xaban riq'uin re ba' mero xinya' can chava, vocame ninya' lajuj tenemit pan ak'a' chin che naban mandar pa quive', xcha' re Rey cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y c'are' xapon jun chic mozo, y xubij: Patrón, re mero re xaya' can chua tak xaba, xinch'ac vo'o' tanto más chij, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y re Rey xubij chuka' cha re jun mozo re': Roma camas otz xaban riq'uin re ba' mero re xinya' can chava, vocame ninya' vo'o' tenemit pan ak'a' chin naban mandar pa quive', xcha' re Rey cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Jac'a re jun chic mozo xapon, xubij: Patrón, ja a-mero re' re xaya' can chua. Re mero re' ximpes pa jun su't chin xinyac, ");
INSERT INTO cakYNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","roma yen ninxibij-vi' chavach roma rat yat jun ache camas yat c'a'l. Xa can najo' c'a yach'acon. Rat xa yat junan riq'uin jun ache re no'rc'utuj ru-mero pa banco y xa manak mero ruyi'on chire'. Y chuka' najo' nac'ul re ndel-pa chach re tico'n re xa mana-ta rat yatiquiyon-ka, xcha' re mozo cha re Rey. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y re Rey xubij cha re mozo re': Rat xa yat jun itzel mozo. Re tzij re xabij jare' re xtoc chin xcatimban juzgar. Roma vo xa ataman che yen can yin c'a'l-va, y yen can ninch'ojij-va nu-mero re anche' manak mero nyacon, y chuka' can ninjo' ninc'ul re ndel-pa chach re tico'n re xa mana-ta yen yintiquiyon-ka, ");
INSERT INTO cakYNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","vo xa quire' nabij rat, ¿anchique roma tak man xaya-ta re nu-mero pa kajic? Chin quire' ninc'ul-ta re mero re can vichin yen y c'o-ta chuka' ral ninc'ul vocame tak xintzolaj-pa, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y re Rey xubij chique re jec'o chire': Tic'ama' can la mero chuk'a', y tiya' cha re xch'aco lajuj tanto más. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y re jec'o chire' xquibij: Patrón, re xch'aco re lajuj tanto más, xa riq'uin reja' c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero reja' xubij chique: Yen nimbij chiva, che re c'o, c'o riq'uin, can xtuc'ul más. Jac'a re manak can-ta c'o riq'uin, hasta re jenipa-oc ba' c'o riq'uin can xtilisas chach. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vocame, ninjo' yinch'o chiquij re ye'tzelan vichin, y re man xe'jovan-ta che xinoc can Rey: Que'ic'ama-pa, y can chinoch yen que'quimisaj-va, xcha' re Rey. Ja ejemplo re' xubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y tak re Jesús xtane-yan che tzij chiquivach re vinak, xba y xnabayaj-a chiquivach re ru-discípulos, chin xe'ba pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y ja tak ye'bapon-yan-apo pa Betfagé y re pa Betania re ca'e' aldeas re jec'o chunakaj re loma rubini'an Olivos, re Jesús xe'rutak-a je ca'e' chique re ru-discípulos, ");
INSERT INTO cakYNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y xubij-a chique: Quixbiyin-apo chupan la jun aldea la', y can xe xquixoc-apo, jare' xtivel jun alaj burro ximil can chire'. Y re chicop re' can man jun ch'ocolbeyon richin. Tisolo-pa y tic'ama-pa chua. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y vo xa c'o jun xtibim-pa chiva anchique roma tak yex nisol re alaj burro re', tibij c'a can cha che ndoc cha re Ajaf, xcha-a chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Re je ca'e' discípulos re xe'tak-a, xe'ba, y can xquivel-va re burro, can ancha'l re bin-a chique roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Jac'a tak ye'tajin chusolic, re je rajaf re burro xquibij-pa chique: ¿Anchique roma nisol-a? ");
INSERT INTO cakYNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y re ru-discípulos re Jesús xquibij can chique re je rajaf re burro: Xa ndoc cha re Ajaf. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquic'am-pa cha re Jesús. Y reje' xquiya-a ja'jun quitziak chij re burro re', y xquich'ocoba-a re Jesús chij. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y tak binak re Jesús, re vinak niquiriq'uila-ka re quik'u' pa rubey chin niquiya' ruk'ij. Y quire' niquibanala' je nabey chach re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jac'a tak niquitz'am-yan-ka re bajada chin re loma rubini'an Olivos, conojel re ye'tzekelben chin re Jesús je'binak, niquiya' ruk'ij re Dios roma niqui'cot re cánma. Niquiya' ruk'ij re Dios roma re milagros je'quitz'etelon riq'uin re Jesús. Y jun pa quichi' niquiban tak ye'ch'o. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Y niquibij: ¡Re Rey re' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! ¡Ye'qui'cot c'a re jec'o chila' chicaj! ¡Y camas c'a ruk'ij nuc'ul re Dios chila' chicaj! ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chire' chiquicojol re vinak, je'binak c'a nic'aj chique re achi'a' fariseos. Y reje' xquibij cha re Jesús: Maestro, tabana' chique re je tzekelbey avichin, che que'tane-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","C'are' re Jesús xubij chique: Can katzij nimbij chiva, vo xa re je tzekelbey vichin xque'tane-ka, ja re aboj xque'ch'o-pa chin niquiya' nuk'ij, xcha' chique re achi'a' fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y re Jesús xutzu' re tenemit Jerusalén, tak más nakaj chic jec'o-va-apo. Reja' xrok'ej rach re tenemit re', ");
INSERT INTO cakYNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xubij: Yex re yixc'o pa Jerusalén, astapa' c'a ja-ta chupan re k'ij re' nak'ax-ta pan ive' re anchique nibano cha re ivánma che otz nuna'. Pero xa vovan chivach, y mare' man yixtiquir-ta nitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Roma xque'pa k'ij chin k'axomal, xque'pa k'ij tak re soldados xque'yacataj-pa chivij, y xtiquitz'apij rij re itenemit riq'uin jun chic tz'ak y xquixquiya' pa tijoj-pokonal, roma xtiquimol-qui' chivij y pa quinic'ajal xquixc'ue-va can. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Y can chiyixnojel re yixc'o chupan re tenemit xquixquimisas. Y cha re itenemit can man jun aboj re anchok riq'uin je'banalon-va re jay re xtipa'e-ta can. Ronojel xque'vulax. Roma can man xijo-ta re Dios tak xbeka iviq'uin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Y tak xapon-yan re Jesús pa Jerusalén, xoc-apo pa rachoch re Dios. Jare' tak reja' xe'rukotaj-pa re vinak ye'c'ayin y re vinak ye'lok'on chire' pa rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xubij chique: Chupan re ruch'abal re Dios re tz'iban can, nubij che re vachoch jay chin oración. Jac'a yex xa ancha'l cachoch elek'oma' ibanon cha, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y can ja chire' chupan re rachoch re Dios re Jesús k'ij-k'ij xe'rutijoj re vinak riq'uin re ruch'abal re Dios. Pero re principal tak sacerdotes y chibil re achi'a' je'atamayon re ley quichin re israelitas y re achi'a' re c'o quik'ij chiquicojol re vinak, niquicanola' andex niquiban chin quire' niquiquimisaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y man niquivel-ta andex niquiban, roma re vinak can jabal quiyi'on quixquin chin niquic'axaj re nubij re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Y jun k'ij, tak re Jesús c'o chire' pa rachoch re Dios nuc'ut y nutzijoj re utzulaj ch'abal chin re Dios chiquivach re vinak, jare' tak xe'beka re principal tak sacerdotes riq'uin, y re achi'a' je'atamayon re ley quichin re israelitas y chibil chuka' re rejeta'k tak achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y re achi'a' re' xquibij cha re Jesús: Tabij c'a chaka: ¿Anchique xyi'o autoridad pan ak'a' chin xa'kotaj-a re vinak xe'c'ayin pa rachoch re Dios? ¿Y anchique xyi'o autoridad chava chin che q'uiy cosas ya'banala' chiquicojol re vinak? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y re Jesús xubij chique: Yen chuka' c'o jun cosa ninjo' ninc'utuj chiva. Y tibij chua: ");
INSERT INTO cakYNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Re Juan xtak-pa roma re Dios chin xe'ruban bautizar re vinak? ¿O xa vinak xe'bin cha che quire' tubana'? xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero re principal tak sacerdotes y re je'atamayon re ley quichin re israelitas y re rejeta'k tak achi'a' re c'o quik'ij, xquibila' chiquivach: ¿Y vocame andex c'a xtakabij cha re Jesús? Roma vo xa xtakabij che re Juan ja re Dios takayom-pa richin, re Jesús xtubij chaka che anchique roma tak man xinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y vo xa xtakabij che xa vinak xe'bin cha re Juan che tubana' quire', xque'pa conojel vinak xkojquiquimisaj cha aboj. Roma re vinak can quitaman-va che re Juan jun rusamajel re Dios re xbex profeta cha, xe'cha-ka chiquivach reje'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y c'are' xquibij-apo cha re Jesús che man quitaman-ta anchique xbin cha re Juan tak xe'rubanala' bautizar re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y c'are' re Jesús xubij chique re achi'a' re': Roma yex man xixtiquir-ta xibij chua, quire' chuka' yen man xtimbij-ta chiva anchique ya'yon autoridad chua chin ye'mbanala' qui tak re', xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y re Jesús xutz'am rubixic jun ejemplo chiquivach re vinak, y re ejemplo re xuya' chiquivach quire' nubij: Xc'ue' jun ache, y xutic uva chach re rujuyu'. Y c'are' xuya' pa kajic chique je ca'e-oxe' achi'a' chin niquisamajij rach re rujuyu', y reja' xba, y q'uiy tiempo xbo'rbana'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y tak xapon re tiempo chin re cosecha, re rajaf re juyu' xutak jun ru-mozo quiq'uin re achi'a' re je'kajayon re ulef, chuc'amic re uva kajbal chin re juyu'. Pero tak xapon re mozo quiq'uin re achi'a' re je'kajayon re ulef, reje' xquitz'am re mozo y xquich'ay, y manak uva xquiya-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y xpa re rajaf re juyu' xutak chic-a jun ru-mozo chuc'amic re uva kajbal chin re ulef. Pero re achi'a' kajoy tak ulef xa xquitz'am chic re jun mozo re' y xquich'ay. Q'uiy andex xquibanala' y xquibila-a cha, y manak chuka' uva kajbal chin re ulef xquiya-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Pero re rajaf re juyu' xutak chic-a jun ru-mozo chuc'amic re uva kajbal chin re ulef, pero can ja chuka' quire' xquiban cha. Xquisoc, y c'are' xquikotaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Y pa ruq'uisibal, re rajaf re juyu' xubij: ¿Anchique xtintak-a vocame? xcha'. Y reja' c'o c'a jun ruc'ajol y camas nrajo', y jare' re xutak-a chuc'amic re kajbal chin re ulef. Roma re rajaf re ulef xunojij che re achi'a' re je'kajayon re rujuyu', q'uiba' tak xtiquitz'at, can xtiquinimaj-va che can ja re ruc'ajol napon. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero re achi'a' re je'kajayon re ulef, can xe xquitz'at che ja re ruc'ajol re rajaf re juyu' xapon, xquibila' chiquivach: Jare' re xtoc can rajaf ronojel re juyu' re kakajon. ¿Anchique roma man nakaquimisaj? Chin quire' pa kak'a' yoj nic'ue-va can re juyu', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y can katzij-va quire' xquiban cha re ruc'ajol re ache re rajaf re juyu', roma xquilisaj-pa chire' chupan re rujuyu' y xquiquimisaj. C'are' re Jesús xubij: ¿Andex como xtuban re rajaf re juyu' quiq'uin re achi'a' kajoy tak ulef? ");
INSERT INTO cakYNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Re rajaf re juyu' xtipa y xque'ruquimisaj re xe'kajo re ulef re', y re rujuyu' xtuya' chic can pa kajic chique nic'aj chic, xcha' re Jesús. Tak re vinak quic'axan chic-ka ronojel re', xquibij: Can man xtujovaj re Dios che nibanataj-ta quire', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y re Jesús xe'rutzu' re vinak, y xubij: ¿Y andex ndel-va che tzij re nubij chupan re ruch'abal re Dios re tz'iban can? Tak nubij: C'o c'a jun aboj re man xka-ta chiquivach re banoy tak jay. Pero re aboj re' can xoc-va, roma re aboj re' xa can c'o-va xcusan richin, y ja aboj re' re tz'amayon chin re jay chin che man nitzak-ta, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y re vinak re xtitzak chach re jun aboj re', can xtic'ajer. Y re vinak re xtika re aboj re' chij, can xtuqui'ej jumul, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y re principal tak sacerdotes y re achi'a' re je'atamayon re ley quichin re israelitas, can ja-ta re' xquijo' che xquitz'am-ta-a re Jesús, roma xquinabej che re achi'a' re kajoy tak ulef re xe'runataj chupan re ejemplo re xubij, xa chiquij reje' xch'o-va. Pero man xquitz'am-ta-a, roma niquixibij-qui' chiquivach re vinak re jec'o riq'uin re Jesús. Y re xquiban, ja che xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Pero re xbequibana-pa reje', ja che xe'bequitaka-pa nic'aj chic achi'a', y re achi'a' re' can xquiban che reje' can choj re quic'aslen, pero xa man katzij-ta che quire' re quic'aslen. Reje' niquijo' che niquiya-ta pa c'ayef re Jesús, y nitzak-ta pa quik'a' riq'uin re ch'abal nubij. Y vo xa nika re Jesús pa quik'a', reje' can xtiquiya' chuka' pa ruk'a' re gobernador. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y chin che niquiya' pa c'ayef re Jesús, re achi'a' re' xquic'utuj cha: Rat re yat jun Maestro, yoj can kataman-va che can ja re katzij re natzijoj. Y mana-ta re ruk'ij jun vinak re natz'at. Rat can pa rubiyal-va nac'ut re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Tabij c'a chaka: ¿Can ruc'amon como che nakatoj re impuestos re nubij re César che nakatoj, o xa man ruc'amon-ta? xe'cha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero re Jesús can rutaman andex niquinojij chij. Mare' xubij chique: ¿Anchique roma yex nitaj ik'ij chin yinitojtobej? ");
INSERT INTO cakYNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'ama-pa y tintz'eta-na rach re mero re', xcha'. Y re Jesús xuc'utuj: ¿Anchok rutzubal y anchok rube' chuka' la c'o chach la mero? Y reje' xquibij cha: Chin re César. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y re Jesús xubij chique: Titojo' c'a re impuestos cha re César riq'uin re mero re ruc'amon che niya' cha reja'. Y tiya' cha re Dios, ronojel re ruc'amon che niya' cha re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y re achi'a' re' man xe'tiquir-ta chij re Jesús, roma re Jesús ronojel tzij pa rubiyal ye'rubila' chiquivach re vinak. Y camas xsatz quic'o'x tak xquic'axaj re xubij re Jesús chique. Y mare' man chic xe'ch'o-ta-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y jare' tak nic'aj chique re achi'a' saduceos xe'bapon riq'uin re Jesús. Re achi'a' re' man niquinimaj-ta che re anama'i' xque'c'astaj. Y mare' reje' xquic'utuj cha re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Rat re yat jun Maestro, c'o jun cosa nakajo' nakac'utuj chava. Re Moisés can rutz'iban can chaka che tak jun ache nuya' can re ruxayil roma xcom-a y man jun rajc'ual xuya' can riq'uin re ixok, jun chique re ruch'alal reja' re nic'ule' riq'uin re malca'n-ixok, chin quire' che c'o-ta rajc'ual nic'ue' riq'uin re ixok malca'n. Y vo xa jec'o rajc'ual ye'c'ue' riq'uin re ixok, ja re nabey rajc'ual ala' jare' re ndoc rajc'ual re ache quiminak chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y reje' chuka' xquibij: C'o jun bey xe'c'ue' je vuku' achi'a' quich'alal-qui'. Re nabey xc'ule'. Pero xcom-a, y man jun rajc'ual xc'ue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xpa re ruca'n ache, re ruch'alal can re ache quiminak chic, xc'ule' riq'uin re malca'n-ixok. Pero chuka' re ache re' xcom-a, y man jun rajc'ual xc'ue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Re rox xc'ule' c'a chuka' riq'uin re malca'n-ixok, pero can ancha'l xquiban re je ca'e' ruch'alal nabey, can quire' chuka' xuban-a reja'. Y che je vuku' achi'a' quich'alal-qui' quire' xquiban-a. Y man jun c'a chique re je vuku' achi'a' re' xc'ue-ta can rajc'ual. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisibal xcom-a chuka' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y re achi'a' saduceos xquibij cha re Jesús: Rat nabij che xtapon jun k'ij tak re anama'i' xque'c'astaj-pa. Tak xtapon re k'ij re', ¿anchok ruxayil c'a xtoc-va re ixok re'? Roma che je vuku' achi'a' quich'alal-qui' xe'c'ue-a riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y re Jesús can jare' tak xubij chique: Chach re ruch'ulef, re vinak can c'a ye'c'ule' y can c'a ye'quiya' re quimi'al-cajc'ual chin che ye'c'ule'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Jac'a re je quiminak chic-a, manak chic c'ulubic chiquivach. Mare' re xque'c'astaj-a y yi'on chic k'ij chique chin che ye'ba chila' chicaj, man chic xque'c'ule-ta, y man chic xque'quiya-ta-a chuka' re quimi'al-cajc'ual chin che ye'c'ule'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Roma reje' man chic xque'com-ta, roma xque'oc ancha'l re ángeles y chuka' je rajc'ual chic re Dios roma je'c'astajnak chic-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Y re anama'i' can ye'c'astaj-va. Roma re Moisés rutz'iban can chupan re ruch'abal re Dios, tak xutz'at re zarza can nibac'o pa k'ak', y xuc'axaj tak xubij re Dios: Ja yen re ru-Dios re Abraham, re ru-Dios re Isaac, y re ru-Dios chuka' re Jacob, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Y xe-ta reje' xe'com-ta jumul y man-ta ye'c'astaj chic jun bey, re Dios man-ta qui-Dios reje', roma re Dios can qui-Dios-va re c'o quic'aslen y man quichin-ta re anama'i'. Roma chach re Dios reje' can je c'as-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y jec'o ja'jun chique re achi'a' re je'atamayon re ley quichin re israelitas xquibij cha re Jesús: Maestro, can ja-va c'a quire', can otz ronojel re xabij. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y man chic xquiban-ta covil che c'o-ta chic más cosas re xquic'utuj-apo cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y re Jesús xubij chique re achi'a' re je'atamayon re ley quichin re israelitas: ¿Anchique roma tak nibex che re Cristo xa choj jun rey-rumam can re Rey David? ");
INSERT INTO cakYNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tak xa can ja re Rey David biyon can chupan re jun libro rubini'an Salmos: Che re Ajaf Dios xubij cha re Vajaf re Cristo: Catz'uye-pa vajquik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y xque'nya' pan ak'a' re ye'tzelan avichin. Quire' xubij re Dios cha re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y vo xa re Rey David, Vajaf nicha' cha re Cristo, ¿anchique roma tak nibex che re Cristo xa choj jun rey-rumam can re Rey David? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y conojel c'a re vinak re quimalon-qui' chire', xquic'axaj tak re Jesús xubij chique re ru-discípulos: ");
INSERT INTO cakYNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Man tiban ancha'l niquiban re achi'a' re je'atamayon re ley kachin yoj re yoj israelitas. Roma reje' camas nika chiquivach niquicusaj tukutak tak tziak, chin quire' titz'et-na che camas quik'ij. Camas chuka' nika chiquivach che niya' ruxnokil-quivach pa tak q'uiybal re anche' niquimol-va-qui' re vinak. Y re pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha, can jac'a re nabey tak ch'acat ye'quicanola', chin quire' tibex chique che camas quik'ij. Y can ja chuka' quire' niquibanala' re anche' niban-va va'in. ");
INSERT INTO cakYNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y chuka' re achi'a' re' ye'quimojola' cachoch re malcani' tak ixoki'. Y reje' tak niquiban oración cha re Dios, camas ye'yaloj xaxe chin ninimax che camas je otz tak vinak. Pero reje' can xtika-va más castigo pa quive', roma re quimac camas q'uiy, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Re Jesús xe'rutz'at re vinak biyoma' niquiyala' can mero chire' anche' c'o-va re ruc'ojlebal ofrenda chupan re rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y re Jesús xutz'at che quire' chuka' nuban jun malca'n-ixok re can k'alaj che meba-oc, y xaxe ca'e' ch'utak mero re camas ba-oc rajkalen re xuya' can. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y tak re Jesús xutz'at re jun malca'n-ixok re', xuc'ut chiquivach re ru-discípulos, y xubij chique: Can katzij nimbij chiva che yen xintz'at che xa ja la ixok la' re xyi'o can más q'uiy mero que chiquivach conojel. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Roma reja' can xe-va re c'o riq'uin, jare' xuya' can anche' c'o-va re c'ojlebal chin ru-ofrenda re Dios. Jac'a re biyoma', ja re nuban sobra quiq'uin, jare' niquiyala' can, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y jec'o vinak re quitz'amon tzij chij re rachoch re Dios. Y niquibila' che camas jabal rubanic, che rion aboj re je jabal-oc je'cusan, y che ronojel can cotz'e'j rij quibanon cha, roma q'uiy cosas sipan coma re vinak chin xoc cha re rachoch re Dios, ye'cha'. Y re Jesús xubij chique: ");
INSERT INTO cakYNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xtapon jun k'ij tak ronojel re nitz'at vova' xque'vulax y can man jun aboj xtic'ue-ta can ancha'l rubanon vocame. Ronojel re aboj re je'cusan cha re jay re', xa can xque'vulax. Can man jun c'a aboj re xtic'ue' can ancha'l la rubanon vocame, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y re discípulos xquic'utuj cha re Jesús: Maestro, ¿c'a jampa' c'a xque'banataj re xabij-yan-ka chij re rachoch re Dios? ¿Y andex che señal xtitz'et chin quire' ninabex che nibanataj-yan? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y re Jesús xubij chique: Can jabal tichajij-ivi' chin man quixk'olotaj. Roma je q'uiy xque'pa y xtiquibij: Ja yen re Cristo. Ja tiempo re' re xbeka, xque'cha'. Pero yex man que'inimaj, chuka' man que'itzekelbej. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y tak xtic'axaj chuka' che jec'o naciones ye'tajin che guerra o re vinak pa tak tenemit niquibanala-ka ayoval chiquivach-ka reje' mismo, man c'a tixibij-ivi', roma nabey tiene que nibanataj quire', pero mana-ta re' re ruq'uisibal tak k'ij chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y re Jesús xubij chuka': Jun tenemit xtiyacataj chin no'rbana' guerra riq'uin jun chic tenemit. Jec'o chuka' nima'k tak naciones xque'yacataj chin che ne'quibana' guerra quiq'uin nic'aj chic nima'k tak naciones. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xque'pa sananel re camas je q'uiy vinak xque'ruquimisaj, xque'pa viyjal y yabil xabanchique lugar chach re ruch'ulef. Y camas c'a xque'xibin re señales y re xque'tz'etetaj chach re rocaj, re can man pak'ij che chak'a' je'tz'eton-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Y tak c'amaje-na tibanataj ronojel re', xquixtz'am y xtiban chiva che nitaj pokan, roma re ruch'abal re Dios. Xquixc'uax chiquivach re achi'a' c'o quik'ij pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Xquixtz'apes pa cárcel. Xquixc'uax chiquivach reyes y chiquivach chuka' gobernadores chach re ruch'ulef. Ronojel c'a re' xtic'alvachij xa roma yininiman. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y tak quire' xtiban chiva coma re vinak, jare' tak más xquixtiquir xquinisekresaj chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y te'ka chi'c'o'x che man jun ndoc-va che yex camas ninojij re andex xtibij chin nito-ivi', ");
INSERT INTO cakYNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","roma can ja yen re xquimbin-apo chiva re andex xtibij. Y xtinya' chuka' na'oj chiva chin quire', riq'uin re na'oj re' xtitz'apij quichi' re vinak itzel yixquitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y xquixya' pa quik'a' re vinak itzel yixquitz'at. Y q'uiba' hasta re ite-irta', re je ivch'alal o re je ivamigo re xque'jacho ivichin. Y jec'o chiva yex re can xque'quimisas. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xa can itzel-va xquixtz'et coma conojel vinak, roma ibanon confiar-ivi' viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man tichajij pena, roma re Dios can yixruchajij-va nojel tiempo, y chach reja' man jun rusumal-ive' re xtitzak-ta-a vo xa man quire-ta nrajo' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y vo xa nicoch' ronojel re', xtivel re utzulaj c'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y tak xtitz'at che re tenemit Jerusalén sutin rij coma re ejército, titamaj che xa ba' chic tiempo nrajo' chin che re tenemit xtiq'uis. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mare', vo xa yex yixc'o pa Judea, quixnumaj-a y te'ivovaj-ivi' pa tak c'achelaj. Y vo xa pa tenemit Jerusalén yixc'o-va, quixel-a y quixnumaj. Y vo xa pa k'ayis c'o-va ivachoch, man chic quixba-apo pa tenemit. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Roma tak xtapon re k'ij chin re tijoj-pokonal, c'ajare' tak re tenemit re' xtutoj ronojel re je'rubanalon, y can xtibanataj ronojel re tz'iban can chupan re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Y chupan re k'ij re' camas c'a re tijoj-pokonal xtipa pa rue' re ruch'ulef. Can xtika re ruyoval re Dios pa rue' re tenemit Jerusalén. Y roma re tijoj-pokonal re', c'ayef c'a xtuban chique re ixoki' re c'o chic yabil chiquij y chuka' c'ayef xtuban chique re ixoki' re c'a ye'tz'uman ch'utak cal. Can tivok'ex c'a quivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Camas c'a je q'uiy vinak xque'quimisas coma re soldados che espada. Y nic'aj chique re vinak xque'c'uax-a preso pa tak nic'aj chic naciones. Y re tenemit Jerusalén xtic'ue' pa quik'a' re juley chic naciones re man je israelitas-ta. Y tak xtel pa quik'a', ja tak xtapon re tiempo re yi'on chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y q'uiy c'a señales re can man pak'ij che chak'a' je'banatajnak-ta y can man pak'ij che chak'a' je'tz'eton-ta riq'uin re k'ij, re ic' y re ch'umil. Y re vinak re jec'o chach re ruch'ulef can man xtiquivel-ta andex xtiquiban, xa xtisatz quic'o'x roma re mar camas-va xtik'ajan, roma camas xtubolk'otela-ri'. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y re vinak roma can quiyaben re andex xtibanataj chach re ruch'ulef, xtitz'amataj quicamic roma quiximbire'. Roma hasta ronojel re namalaj tak poderes re jec'o chicaj xque'silon roma re ru-poder re Dios. Can che jun re rocaj xtisilon. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y jare' tak xquinquitz'at yen re xinalax chi'icojol, che yinka-pa pa jun nube, riq'uin chic namalaj poder y riq'uin chuka' namalaj nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y tak xtitz'at che ronojel re' ntajin chic rubanic, quixqui'cot y tic'ue' más ivuchuk'a' roma can napon-yan re k'ij chin yixel libres chach ronojel re tijoj-pokonal re nik'asaj chach re ruch'ulef, xcha' re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Y jare' tak reja' xubij chuka' jun ejemplo chique: Titz'eta-na-pa' re che' rubini'an higuera o xabanchique clase che'. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tak ye'el-pa re c'ac'a ruxak, itaman che re ru-tiempo re job ne'ka-yan. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y ja quire' chuka' tak xtitz'at che can jec'o chic cosas ye'banataj riq'uin re k'ij, re ic', re ch'umil y ronojel re xe'mbij-yan-ka ntajin chic rubanic, titamaj c'a che ne'ka-yan re k'ij tak re Dios xto'rbana' gobernar pa quive' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Y tic'axaj jabal re xtimbij chiva vocame: Ronojel re' xque'banataj, tak re vinak chin re tiempo re' c'amaje-na que'q'uis-a chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Y re ruch'ulef y re rocaj can chin-va che ye'q'uis. Jac'a re nuch'abal man xtiq'uis-ta, xa can xtibanataj-va ronojel re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Y tichajij re ic'aslen. Man tiba ivánma chij re va'in, man quixk'abar, y chuka' man xaxe re ndoc chiva chach re ruch'ulef jare' re ninojij nojel tiempo, y c'aja tak xtina' xte'ka re k'ij tak yen xquineka. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Y re' ancha'l jun trampa re nutz'apij-ri'. Quire' rubanic tak xte'ka pa quive' conojel re vinak re jec'o chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mare' can tichajij jabal re ic'aslen. Y tibana' chuka' orar nojel tiempo, chin yix chach ronojel re tijoj-pokonal re xtipa chach re ruch'ulef, y chin che otz re ic'aslen tak xquixapon chinoch yen re xinalax chi'icojol, xcha' re Jesús chique re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Y pak'ij, re Jesús pa rachoch re Dios ye'rutijoj re vinak cha re ruch'abal re Dios. Y chak'a' niba chuxe' re loma rubini'an Olivos, y chire' ne'c'ue-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y camas c'a vinak ye'bapon cumaj-yan riq'uin re Jesús chire' pa rachoch re Dios chin niquic'axaj re ruch'abal re Dios re nutzijoj chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Y xa chua'k-cabij chic re quinamak'ij re israelitas, y ja namak'ij re' tak niquitaj xcana-vay re manak levadura riq'uin, y re namak'ij re' niquibij pascua cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Jare' tak re principal tak sacerdotes y re achi'a' je'atamayon re ley quichin re israelitas, niquinojela' andex xtiquiban chin niquiquimisaj re Jesús, roma quixibin-qui' chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y re Judas re jun chique re je doce apóstoles re xbex chuka' Iscariote cha, can nisamaj chic re Satanás pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Mare' re Judas re' xba quiq'uin re principal tak sacerdotes y quiq'uin chuka' re ye'c'uan quichin re achi'a' re ye'chajin chire' pa rachoch re Dios, y xch'o quiq'uin chij re andex xtuban chin nujach re Jesús pa quik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y re achi'a' camas c'a xe'qui'cot tak xquic'axaj quire', y xquisuj mero cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Re Judas xuban can re trato. Y xutz'am runojexic andex xtuban y jampa' tak xtujach pa quik'a', y tak xtujach pa quik'a', ja tak manak vinak quimalon-qui' riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xbeka re namak'ij, k'ij chin nitij re xcana-vay re manak levadura riq'uin, y chuka' jare' tak ye'quimisas re ch'utak ovejas, roma jare' re ye'oc chupan re namak'ij rubini'an pascua. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Y re Jesús xe'rutak-a re Pedro y re Juan, y xubij-a chique: Quixbiyin y te'ibana' rubanic re xtakataj chupan re pascua re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y re je ca'e' discípulos xquic'utuj cha: ¿Anche' c'a najo-va che nakabana' rubanic re va'in? ");
INSERT INTO cakYNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y re Jesús xubij chique: Tak xquixapon pa tenemit Jerusalén, xtitz'at che c'o jun mozo re ruc'amom-pa ruya' pa jun cucu'. Titzekelbej-a re ache re' c'a anchique jay xtoc-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y tibij cha re rajaf re jay re': Re ka-Maestro rubim-pa: ¿Anchique cuarto chin re avachoch otz chin nimban-va re namalaj va'in quiq'uin re nu-discípulos chupan re namak'ij pascua? quixcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y re rajaf jay xquixruc'uaj pa ruca'n piso chin re jay. Y chire' c'o jun cuarto nem banon chic rubanic. Ja chire' tibana-va rubanic re xtakataj chin re pascua, xe'cho'x-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y re je ca'e' discípulos xe'ba. Y can ancha'l re rubin-a re Jesús chique, can quire' re xbanataj. Y reje' can xquiban-va rubanic ronojel re ndoc chin re va'in chin re pascua. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y tak xapon re hora, re Jesús y re je doce apóstoles xe'tz'uye-apo chach mesa, ");
INSERT INTO cakYNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","c'are' re Jesús xubij chique: Camas nrayim-pa che antes che yincom, junan nakaban can re jun namalaj va'in chupan re namak'ij pascua. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Y nimbij chiva, che tak ja re Dios re nibano chic gobernar chire' y xban-yan cumplir ronojel re ndel che tzij re namak'ij pascua, c'ajare' tak xtimban chic jun bey re va'in re' iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y re Jesús xutz'am c'a jun copa re c'o ruyi'al-uva chupan, y tak rutioxin chic cha re Dios, xubij: Tikumu' c'a can chiyixnojel, ");
INSERT INTO cakYNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","roma can nimbij chiva, che tak ja chic re Dios re nibano gobernar, c'ajare' tak xtinkum chic jun bey re ruyi'al-uva. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y quire' chuka' xuban tak xuc'am-apo jun xcana-vay, y tak rutioxin chic cha re Dios, xupar re xcana-vay y xuya' chique re ru-apóstoles, y xubij: Jare' re nu-cuerpo re ninjach pa camic pan i-cuenta yex. Tibana' quire' chin che xtinataj re nucamic. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y tak xe'va-yan, re Jesús xutz'am chuka' re copa re c'o ruyi'al-uva chupan, y xubij: Re ruyi'al-uva re', jare' re nuq'uiq'uel re xtibiyin tak xquincom. Riq'uin re nuq'uiq'uel, can jare' xtic'achoj re c'ac'a trato re rusujum-pa re Dios che nuban quiq'uin re vinak. Re nuq'uiq'uel re xtibiyin, xa rutzij re imac, chin che yixcolotaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y re ache re xquinjacho pa quik'a' re vinak re ye'tzelan vichin, can c'o c'a chakacojol chach mesa. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can tic'axaj c'a re nimbij chiva, che yen re xinalax chi'icojol, can xquinquimisas-va, roma can jare' re runojim-pa re Dios pa nue'. Pero re xtijacho vichin, can tivok'ex rach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y jare' tak re ru-discípulos re Jesús xquibila-ka chiquivach che anchique como re xtijacho-a chin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y re discípulos re' xquich'ojela' chiquivach anchique re c'o más ruk'ij chiquicojol reje'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero re Jesús xubij chique: Re ye'bano gobernar chach re ruch'ulef, can niquina' che ja reje' re je cajaf conojel vinak re jec'o chach re ruch'ulef, roma ja reje' re ye'bano mandar pa quive'. Y re achi'a' re ye'bano quire' camas nika chiquivach nibex chique che je banoy tak utzil. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Jac'a chi'icojol yex nu-discípulos man quire-ta. Roma re c'o más ruk'ij chi'icojol yex, tuna-ka-ri' che manak ruk'ij chiquivach re ruchibil. Y re jun chiva yex re nibano mandar pan ive', tuna-ka-ri' che manak ruk'ij. Xa quixruto' che nuban re samaj re niban yex. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Y tak c'o jun rutz'amon va'in chach mesa y c'o jun re nibano-apo servir richin, ¿anchique como che je ca'e' re c'o más ruk'ij ninojij yex? ¿Mana-ta como re c'o chach mesa re nivilix-apo re más c'o ruk'ij? Pero yen re yinc'o chi'icojol man quire-ta, roma yen can ancha'l nuban re nibano-apo servir chach mesa, quire' nimban. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yex can yixc'o-pa viq'uin chupan re tijoj-pokonal re ye'nk'asaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Roma re', yen xtimban chiva che xtic'ue' autoridad pan ik'a', can ancha'l re rubanon re Nata' Dios viq'uin yen, ");
INSERT INTO cakYNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","chin quire' xquixva' y xquixuq'uia' chach jun misma mesa viq'uin, tak c'o chic autoridad pa nuk'a' yen. Y yex xtiban gobernar pa quive' re je doce grupo israelitas re quibanon dividir-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y re Ajaf Jesús xutz'am tzij riq'uin re Simón Pedro y xubij: Simón, Simón, nimbij chava che re Satanás xixruc'utuj-yan cha re Dios chin che yixtojtobex. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero yen can nbanon-va-pa orar chavij rat, chin quire' can naban confiar-avi' viq'uin. Can xcatapon-va pa ruk'a' re Satanás. Pero tak xtitzolaj-pa ac'o'x viq'uin, tabana' chique re nic'aj chic discípulos che más tiquibana' confiar-qui' viq'uin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y re Simón Pedro xubij: Vajaf, vo xa rat xcac'uax pa cárcel, yen chuka' yimba chavij pa cárcel. Y vo xa yaquimisas, yen chuka' yincom aviq'uin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero re Jesús xubij cha: Pedro, yen nimbij chava, che chupan re ak'a' re', antes che re moma' nitzirim-pa, rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch, xcho'x re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y re Jesús xuc'utuj c'a chique re ru-discípulos: Tak xixintak jun bey can, man xinjo-ta che xic'uaj iya'l, ni xe-ta mero, ni xe-ta jun chic c'ulaj xajab. ¿C'o como re xuban falta chiva? xcha'. Y reje' xquibij che man jun xuban falta chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y re Jesús xubij chique: Jac'a vocame man chic quire-ta. Roma vocame re c'o ruya'l, tuc'uaj-a. Re c'o ru-mero, tuc'uaj-a. Y re manak ru-espada, tuc'ayij jun rutziak chin nulok' jun richin, ");
INSERT INTO cakYNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","roma tiene que nibanataj ancha'l nubij chupan re ruch'abal re Dios re tz'iban can chuij: Can ancha'l jun aj-mac xtiban cha, quire' nubij re tz'iban can. Y re' can xtiban-va chua yen. Roma ronojel re je'tz'iban can chuij chupan re ruch'abal re Dios, can xque'banataj-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y re discípulos xquibij cha re Jesús: Ajaf, vova' c'o ca'e' espada. Pero re Jesús xubij chique: Man chic tinataj re'. Re Jesús xubij quire' roma xutz'at che man xk'ax-ta pa quive' re ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Re Jesús tak elinak chic-a chire', xba chuxe' re jun loma rubini'an Olivos, re anche' siempre tibo-va. Y re ru-discípulos can je'tzakatal-va-a chij. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y tak xe'bapon, xubij chique: Tibana' orar y tic'utuj cha re Dios che tak yixtojtobex, man quixtzak pa mac. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y re Jesús xbiyin-apo jun ca'e' rakan-c'am, y chire' xuque-va-ka, y xutz'am rubanic orar. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nubij chupan re ru-oración: Nata', tabana' che man-ta nink'asaj re jun tijoj-pokonal re', vo xa quire' re najo' rat. Pero man taban re ninjo' yen. Roma yen can ninjo-va nimban re najo' rat, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y c'o c'a jun ángel re pitinak chila' chicaj xuc'ut-ri' chach, chin no'rya-ka ruchuk'a' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y camas c'a nik'axo re ránma nuna' reja'. Mare' can riq'uin c'a ronojel ránma más nuban orar. Y roma camas nik'axo re ránma, mare' re ya' re ndel chij man chic relic-ta ya', xa can ancha'l chic nima'k tak tz'uj quic' ye'ka pan ulef. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tak re Jesús xtane' chubanic orar, xbeyacataj-pa re anche' xucul-va, xtzolaj-pa quiq'uin re ru-discípulos, pero tak xbeka quiq'uin, xa quitz'amon varan, roma reje' ye'bison y je'cosnak. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y re Jesús xubij chique: ¿Anchique roma yixvar? Quixyacataj, tibana' orar y tic'utuj cha re Dios che tak yixtojtobex man quixtzak pa mac, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y c'a ntajin che tzij re Jesús quiq'uin re ru-discípulos, tak xquina', xe'bapon je q'uiy vinak quiq'uin. Y jun chique re je doce ru-discípulos re rubini'an Judas, jare' re ac'ayon-apo quibey re vinak re'. Y re Judas can xe xapon, xjelon-apo riq'uin re Jesús chin xutz'ubaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero re Jesús xubij cha re Judas: ¿Y como man yaq'uex-ta yinatz'ubaj xaxe chin che yinajach-a pa quik'a' re ye'tzelan vichin yen re xinalax chi'icojol? ");
INSERT INTO cakYNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y re discípulos tak xquitz'at re ntajin rubanic y re xque'banataj, xquibij: Ajaf, ¿yojyacataj chiquij che espada? ");
INSERT INTO cakYNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y c'o jun chique re discípulos re xusoc jun ache re ru-mozo re namalaj sacerdote. Can xutzaq'uij-va-a ruxquin. Y re ruxquin re xutzaq'uij-a ja re c'o pa rajquik'a'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y re Jesús xubij chique re ru-discípulos: Man chic tiban quire'. Y c'are' xutz'am re ruxquin re mozo y xuc'achojsaj. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y re vinak re je'binak chutz'amic re Jesús ja re principal tak sacerdotes, re je'ac'ayon quichin re achi'a' re ye'chajin pa rachoch re Dios, y re rejeta'k tak achi'a' re c'o quik'ij. Y reja' xubij chique: ¿Yex xinojij che yixpitinak chutz'amic jun elek'om y mare' ic'amom-pa che' y espada? ");
INSERT INTO cakYNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Can k'ij-k'ij c'a xinc'ue' chi'icojol pa rachoch re Dios, y man jun andex xiban chua. Pero ja hora re' re yi'on chiva yex, hora che re rujoval re k'oko'm nich'acon, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquitz'am-a re Jesús, y xquic'uaj pa rachoch re namalaj sacerdote. Y re Pedro je'rutzekelben-a, pero c'ac'anaj c'o-va can chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y re chire' chach-jay, re rusamajela' re namalaj sacerdote xquibox k'ak', y xe'tz'uye-apo conojel chuchi-k'ak'. Y chuka' re Pedro xtz'uye-apo chiquicojol. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y jun ixok raj-ic' re namalaj sacerdote, tak xutz'at che re Pedro tz'uyul chire' chiquicojol rumek'on-ri', xutzu-xutzu' rach y xubij: Re jun ache re' ruchibil chuka' re Jesús, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero re Pedro xutz'uc tzij chach re ixok, y xubij: Yen man ntaman-ta rach re Jesús, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y c'a ba' che', c'o chic jun xtz'eto-pa richin re Pedro, y xubij cha: Rat yat jun chique re ru-discípulos re Jesús. Y re Pedro xubij: Mana-ta yen. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","C'o la'k jun hora tak'ax-va re', tak c'o chic jun xbin che can katzij-va che chuka' re Pedro xc'ue' riq'uin re Jesús, roma reja' can aj-Galilea-va, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero re Pedro xubij: Man nak'ax-ta pa nue' anchique roma nabij quire' chua. Y can c'a ntajin che tzij re Pedro, tak re moma' xtzirim-pa. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y re Ajaf Jesús xuya' vuelta y xutz'at-pa re Pedro. Y re Pedro jare' tak xbeka chuc'o'x re rubin can re Ajaf cha, che c'amaje-na titzirim-pa re moma', tak rat oxe-yan bey tabij chique re ye'c'utun chava, che man ataman-ta noch. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y tak re Pedro xel-a pa fuera, can xujek'aj ok'ej. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y re achi'a' re je'chajiyon chin re Jesús, ye'tze'en c'a chij y niquich'ay. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","C'are' xquitz'apij rach y xquiyala' k'a' chupalaj y niquic'utula' c'a cha: ¿Anchique re xyi'o k'a' cha'palaj? Tabij chaka, ye'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y q'uiy c'a itzel tak tzij xquibila' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tak xsakar-ka, xquimol c'a-qui' re rejeta'k tak achi'a' re c'o quik'ij, re principal tak sacerdotes, y re achi'a' je'atamayon re ley quichin re israelitas. Y xc'uax-apo re Jesús chiquivach re achi'a' re', roma ja reje' re pa camon ye'bano juzgar, y xquic'utuj cha re Jesús: ");
INSERT INTO cakYNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tabij chaka: ¿La ja como rat re Cristo re bin che nitak-pa roma re Dios? Pero re Jesús xubij chique: Vo xa nimbij chiva che ja yen re Cristo, man yininimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y chuka' xe-ta c'o preguntas ye'mban chiva, man nibij-ta chua re ninc'utuj chiva, y chuka' man xquinisk'opij-ta-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Y tak xtak'ax can re jun tijoj-pokonal re', yen re xinalax chi'icojol, xquinetz'uye' pa rajquik'a' re Dios re nitiquir nuban ronojel, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Can ja mismo rato re' conojel xe'c'utun-apo cha re Jesús: ¿Entonces rat yat Ruc'ajol re Dios? xe'cha'. Y re Jesús xubij: Ja', ja quire', can ancha'l re c'a nibij-ka. ");
INSERT INTO cakYNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y reje' xquibij: Manak tuk'aj che nipa-ta chic jun chin no'rbij chaka che re Jesús can aj-mac-va, roma can yoj mismo re xojc'axan re c'a nubij-ka y ndel che tzij che can aj-mac-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y c'are' conojel re jec'o chire' xe'yacataj-a, chin xquic'uaj-a re Jesús che ne'quijacha' pa ruk'a' re jun gobernador rubini'an Pilato. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chire' chach re gobernador, niquisujuj-apo y niquibij: Yoj kataman che re ache re' q'uiy rumac. Reja' nujal quina'oj re vinak. Nubila' chuka' chique re vinak che man tiquitoj re impuestos cha re César. Y chuka' nubila' che reja' jun Rey roma ja reja' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y re Pilato xuc'utuj cha re Jesús: ¿Ja rat re qui-Rey re israelitas? Y re Jesús xubij: Ja', ja quire', can ancha'l re xabij. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y c'are' re Pilato xubij chique re principal tak sacerdotes y chique re vinak: Yen man jun ch'a'oj ninvel chij re jun ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero reje' xa más xe'yori' chin niquibij-apo: Xa nujal quina'oj re vinak re jec'o pa tak tenemit chin re Judea. Y rutz'amom-pa rubanic quire' chila' pa Galilea, y quire' nubanala' pitinak, y vocame ja xbeka vova' pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y tak re Pilato xuc'axaj Galilea re c'a niquibij-ka re vinak, xuc'utuj vo xa aj-Galilea re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tak xbex cha che aj-Galilea, reja' xutak-a re Jesús riq'uin re Herodes re gobernador chin re Galilea. Y como re Herodes c'o chire' pa tenemit Jerusalén re k'ij re', otz xuban. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y tak re Herodes xutz'at re Jesús, camas xqui'cot ránma, roma c'o-yan chic che tiempo rurayin nutz'at rach. Y roma c'o q'uiy cosas ruc'axan chij, mare' nurayij che chach-ta reja' tak nuban jun milagro. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y re Herodes q'uiy c'a preguntas xubanala' cha re Jesús, pero re Jesús man jun tzij xubij cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y jec'o-apo re principal tak sacerdotes y re achi'a' je'atamayon re ley quichin re israelitas, chin niquisujuj re Jesús chach re Herodes. Reje' can niquitaj quik'ij chin ye'sujun-apo. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y re Herodes chibil re ru-soldados can man jun ruk'ij xquiban cha re Jesús y xe'tze'en chij. Xquiya' c'a jun tziak chij, can ancha'l re ye'quicusala' re Reyes. Roma chiquivach reje' xa man jun ruk'ij re Jesús. Y c'are' re Herodes xutzolij chic-a re Jesús riq'uin re Pilato. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Re Herodes y re Pilato man que'ch'o-ta chiquivach, roma c'o ayoval chiquicojol. Jac'a re k'ij re' xa xquiban-ka amigos. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Y c'are' re Pilato xe'rayoj re principal tak sacerdotes y re achi'a' re pa camon ye'bano juzgar, y chuka' xe'rayoj re vinak re je'tzakatal-apo chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y c'are' xubij chique: Yex xbe'ijacha' re Jesús pa nuk'a', y nibij che nujalala' quina'oj re vinak. Pero chivach yex xinc'utuj cha vo xa katzij o man katzij-ta, y yen nintz'at che man jun rumac, y ronojel re nibij yex che je'rubanon, yen nintz'at che man katzij-ta. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y chuka' re Herodes man jun rumac xuvel re Jesús tak xixintak-a riq'uin, y mare' xutzolij chic-pa viq'uin. Xaxe riq'uin re' nakatamaj che man jun ch'a'oj rubanon chin quire' nika-ta re camic pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xtintak c'a ruch'ayic, y c'are' ninlisaj-a libre, xcha' re Pilato. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Y re Pilato tiene que nulisaj-a libre jun preso, roma ja quire' re costumbre re niban ronojel juna' chupan re namak'ij rubini'an pascua. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Y mare' conojel jun pa quichi' xe'ch'o-apo, y xquibij: ¡Ja re Barrabás talisaj-a libre, y re Jesús tiquimisas! xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y re Barrabás c'o pa cárcel roma xyacataj chij re gobierno chire' pa tenemit y chuka' roma c'o camic rubanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y re Pilato, roma nrajo' nulisaj-a libre re Jesús, xch'o chic jun bey chique re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero re vinak xa más jun pa quichi' ye'ch'o-apo y niquibij: ¡Tiquimisas cho cruz! ¡Tiquimisas cho cruz! ");
INSERT INTO cakYNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y pa rox bey xch'o re Pilato chique y xubij: ¿Andex rumac rubanon chivach re jun ache re'? Yen man jun ch'a'oj ninvel chij, chin che niquimisas-ta. Ninya' pa castigo, y c'are' ninlisaj-a libre, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero re vinak y re principal tak sacerdotes, xa más niquirak-apo quichi' chin niquic'utuj-apo che tiquimisas re Jesús cho cruz. Can xnimax-va c'a quitzij re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Y jare' tak re Pilato xubij che nuban re ancha'l re niquic'utuj-apo re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xulisaj-a libre re Barrabás re xquic'utuj-apo cha che tulisaj-a libre. Y re ache re' c'o pa cárcel roma xyacataj chij re gobierno y chuka' quimisanel. Y re Jesús xujach-a pa quik'a' chin che tiquimisas cho cruz, roma jare' re niquijo' re vinak che niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Tak re soldados quic'uan-a re Jesús chin ne'quibajij cho cruz, xquic'ul c'a jun ache pitinak pak'os, y re ache re' aj-Cirene y rubini'an Simón. Y re soldados xquitz'am y chij c'a reja' xquiya-va-a re ru-cruz re Jesús. Mare' ja reja' re xc'uan-a re cruz, y chij can re Jesús binak-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y camas vinak je'binak chij. Y camas je q'uiy chuka' ixoki' re ye'ok' chij re Jesús y niquijoyovaj rach. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Y re Jesús xe'rutzu' re ye'ok', y xubij chique: Yex ixoki' aj-Jerusalén, man quixok' chuij. Xa quixok' chivij yex mismo, y quixok' chiquij re ac'ola' jec'o iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Roma re tiempo re xte'ka c'ayef xtibanataj, y mare' xtibex: Otz-quibanoj re ixoki' re man nic'ue-ta ac'ual quiq'uin, re man jun bey xquiyabej-ta jun ac'ual, y re man jun bey xquiya-ta rutz'um jun ac'ual. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Jare' tak xtibanataj che re vinak can xque'ch'o-va chique re nima'k tak lomas y xtiquibila': Quixtzak-pa chakij. Chuka' xque'ch'o chique re cocoj tak lomas y xtiquibila': Kojivovaj, xque'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roma niquiban-na c'a chua yen re yin ancha'l jun che' rax, c'alapa' chique re vinak je ancha'l che' chake'j, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y jec'o chuka' je ca'e' achi'a' je'c'uan-a riq'uin re Jesús chin ye'quimisas. Re achi'a' re' c'o quimac quibanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y tak xe'bapon chupan re jun lugar rubini'an Calavera, xquibajij re Jesús cho cruz, y quire' chuka' xquiban chique re je ca'e' elek'oma'. Jun xbajex pa rajquik'a', y re jun chic xbajex pa ruxocon. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y re Jesús tak c'o chic cho cruz xubij: Nata' Dios, tacuyu' quimac re vinak, roma man quitaman-ta andex re ye'tajin chubanic. Y c'are' re soldados xquiban sortear re rutziak re Jesús, chin xquitz'at andex che tziak re niquic'uala-a cada jun. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y conojel c'a re vinak re jec'o-apo chire' y re achi'a' re ye'bano gobernar re aj-israelitas, niquitz'at-apo re Jesús. Y conojel c'a re vinak re' ye'tze'en-apo chij y niquibila': Reja' je q'uiy xe'rucol. Vocame tucola-ri' reja' mismo, k'alaj re' vo xa can katzij che ja reja' re Cristo re cha'on roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y ja quire' chuka' niquiban-apo re soldados. Ye'tze'en-apo chij re Jesús. Ye'jelon-apo riq'uin y niquisuj-apo vinagre cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y niquibila' chuka' cha: Vo xa can ja rat re qui-Rey re israelitas, tacola-avi' ayon rat, ye'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y pa rue-a re cruz c'o c'a tzij je'tz'iban-a chach jun tz'alam. Re tzij re' je'tz'iban-a pan oxe' rach ch'abal. Tz'iban pa quich'abal re aj-Grecia, pa quich'abal re aj-Roma y pa quich'abal re israelitas. Y re tzij re' nubij: Jare' re qui-Rey re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun chique re je ca'e' achi'a' re c'o quimac quibanon jec'o chuka' cho cruz, itzel xch'o-apo cha re Jesús, roma xubij: Rat re nabij che ja rat re Cristo, tacola-avi' rat, y kojacola' chuka' yoj. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Jac'a re jun chic ruchibil re ache re' cof xch'o-apo cha re mismo ruchibil y xubij: Rat can man naxibij-ta-avi' chach re Dios y chupan re mismo castigo yojc'o-va riq'uin, y reja' manak rumac chin niya' re mismo castigo re' pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Jac'a yoj can ruc'amon-va che kojquimisas chin quire' nakatoj re kamac. Pero reja' man ruc'amon-ta che quire' niban cha, roma man jun rumac rubanon. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y re mismo ache re' xubij-apo cha re Jesús: Quine'ka c'a cha'c'o'x, tak xcapa chic jun bey y tak can yat Rey chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y re Jesús xubij cha: Can katzij nimbij chava, che vocame mismo xcate'c'ue' viq'uin chupan re lugar anche' camas jabal y re lugar re' rubini'an Paraíso. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y pa nic'aj-k'ij la'k che' tak xk'ukumar rach re ruch'ulef. Y re k'oko'm re' xq'uis-a c'a pa tak a las tres re tak'ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Re k'ij man chic xtzu'un-ta, y ja mismo rato re' tak xel ca'e' re utzulaj tziak re anchok cha tason-va rupan re rachoch re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jare' tak re Jesús riq'uin ruchuk'a' xubij: Nata' Dios, pan ak'a' c'a ninjach-va re vánma. Y can xe xubij quire', jare' tak xcom. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tak re capitán quichin re soldados xutz'at re xbanataj, xuya' ruk'ij re Dios, y xubij: Can katzij-va che re jun ache re' man jun rumac. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y conojel re vinak re jec'o-apo chire' xquitz'at re xbanataj, can man niquivel-ta chic andex niquiban y ye'bison xe'tzolaj roma re xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y re vinak re quitaman rach re Jesús, y re ixoki' re can c'a pa Galilea je'tzakatal-va-pa chij, c'ac'anaj c'a jec'o-va niquitzu-pa re ye'banataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y c'o c'a jun ache rubini'an José, y aj pa tenemit Arimatea. Re tenemit Arimatea pa Judea c'o-va. Re jun ache re' camas otz runa'oj y chuka' choj ruc'aslen chach re Dios y quichibil re achi'a' re pa camon ye'bano juzgar re jec'o chiquicojol re israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y re José jun ache re ruyaben chuka' tak re Dios xtuban gobernar, y mare' reja' man xka-ta chach re xquiban re ruchibil cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y reja' xba riq'uin re Pilato re gobernador chuc'utuxic re ru-cuerpo re Jesús chin numuk. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y tak rukasan chic-pa re ru-cuerpo re Jesús cho cruz, xupis pa jun sábana. Y c'are' xbo'rmuku' can pa jun jul quichin anama'i', c'oton chach jun peña. Y man jun c'a cusayon-ta re jul re'. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pero re k'ij re', re vinak niquibanala' chic utzil ronojel re xtoc chique chupan re k'ij chin uxlanen, roma re k'ij chin uxlanen xa nitiquir-yan. Y re k'ij chin uxlanen re nitiquir-a ja tak nika-ka re k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y re ixoki' re can c'a pa Galilea je'tzakatal-va-pa chij re Jesús, xe'ba chij tak xbemuk can, y mare' can jabal xquitz'at tak xya' can re ru-cuerpo re Jesús chupan re jul, mare' can xna'e' can chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y tak re ixoki' re' xe'tzolaj cho tak cachoch, xquiban preparar jubulaj tak ak'om, chin jare' ne'quiya' can chij re Jesús. Y xe'xulan re jun k'ij chin uxlanen, roma can niquiban cumplir re nubij chupan re ley chin re Moisés. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y cumaj-yan re nabey k'ij chin re semana, re ixoki' re' xe'ba anche' xmuk-va re Jesús, y quic'uan-a re jubulaj tak ak'om re xe'quiban preparar. Y jec'o nic'aj chic ixoki' je'binak chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y tak xe'bapon chuchi' re jul re anche' xmuk-va re Jesús, xquitz'at che re aboj re anchok cha tz'apin-va ruchi' re jul, elisan chic-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Reje' xe'oc-apo chupan re jul, y xquitz'at che re ru-cuerpo re Ajaf Jesús manak chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Mare' xsatz quic'o'x y camas xquixibij-qui'. Y can jare' tak xe'quitz'at je ca'e' ancha'l achi'a' je'pa'al-apo quiq'uin, y can niyiq'uiloj re quitziak. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y re ixoki', roma re quiximbire' xe'luque-ka. Y jare' tak re je ca'e' ancha'l achi'a' xquibij chique: Yex ixoki' man ticanoj re Jesús chiquicojol re anama'i' roma reja' xa c'as. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Roma re ru-cuerpo man chic c'o-ta vova'. Reja' xc'astaj-yan-a. Te'ka chi'c'o'x re xubij chiva tak reja' c'a c'o chire' pa Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Reja' xubij chiva: Yen re xinalax chi'icojol, tiene que xquinjach pa quik'a' re aj-maqui' tak vinak chin che xquinquimisas cho cruz, y pa rox k'ij xquinc'astaj-pa chiquicojol re anama'i'. Quire' re xubij chiva, xe'cha' re je ca'e' ancha'l achi'a' chique re ixoki'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y re ixoki' can xbeka-va chiquic'o'x re ch'abal re je'rubin can re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y tak je'tzolojnak-pa anche' xmuk-va re Jesús, xbequitzijoj ronojel chique re je once apóstoles y chique re vinak re quimalon-qui' quiq'uin re apóstoles. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Re ixoki' re xe'beyi'o rutzijol chique re apóstoles ja re María Magdalena, re Juana, re María re rute' re Jacobo, y nic'aj chic ixoki'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero re apóstoles xa xquinojij che re ixoki' xa xe'ch'ujer, y mare' man xquinimaj-ta re xbex chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero re Pedro can jare' xel-a, y jonanin c'a xba chuchi-jul roma reja' nrajo' nutz'at vo xa katzij o man katzij-ta che quire' xbanataj. Y tak xtzu'un-apo chupan re jul, xutz'at che rion chic re tziak jec'o can chire'. Reja' xtzolaj y camas nunojij re xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chupan chuka' re k'ij re', je ca'e' achi'a' re xe'tzekelben richin re Jesús, quitz'amon-a bey pa jun aldea rubini'an Emaús, re aldea re' jun la'k oxe' leguas rucojol riq'uin re tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y tak je'binak, niquitzojola' re xe'banataj. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y tak can niquiya' che tzij je'binak y niquic'utula' c'a chiquivach-ka reje' re xe'banataj, can jare' tak re Jesús xoc-a quichibil, y junan xe'ba. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Re je ca'e' achi'a' re' can niquitz'at-va re jun re binak quiq'uin, pero c'o re banayon chique chin quire' man niquitamaj-ta rach. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y re Jesús xuc'utuj chique: ¿Andex c'a che tzij itz'amom-pa tak yixpitinak? ¿Y anchique roma chuka' yixbison? roma quire' nintz'at yen. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun chique reje' re rubini'an Cleofas, xch'o-apo cha y xubij: ¿Man ataman-ta rat re c'a ba-oc tibanataj pa tenemit Jerusalén? Pero conojel re vinak re xe'c'ue' pa namak'ij jabal quitaman re xe'banataj. ¿Y rat chire' yatpitinak-va y man ataman-ta andex re xe'banataj chire'? ");
INSERT INTO cakYNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y re Jesús xuc'utuj chique: ¿Andex xe'banataj chire' c'a? Y reje' xquibij: Re xquiban re vinak cha re Jesús aj-Nazaret, re rusamajel re Dios re xbex profeta cha. Y chuka' can xuc'ut che c'o ru-poder, roma re namalaj tak milagros re xe'rubanala' y chuka' re ru-forma tak nich'o. Quire' re xk'alajin chach re Dios y chiquivach re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero re principal tak sacerdotes y re achi'a' re pa camon ye'bano juzgar chakacojol yoj re yoj israelitas, jare' re xe'bano chin xquiquimisaj cho cruz. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y yoj can kanojin-va che ja reja' re pitinak chakacolic konojel yoj re yoj israelitas. Pero vocame man jun chic andex xtakaban, roma ja-yan oxe' k'ij ticom-va. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero jec'o chique re kachibil ixoki' re cumaj-yan xe'ba chuchi' re jul anche' xmuk-va re Jesús, y tak xe'tzolaj-pa xojquixibij, ");
INSERT INTO cakYNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","roma xbequibij che re ru-cuerpo re Jesús xa man chic c'o-ta chupan re jul y xbequibij chuka' che c'o ángeles xquic'ut-qui' chiquivach, y che re ángeles re' xquibij chique che re Jesús xc'astaj-yan-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y mare' jec'o chaka yoj re xe'ba chuchi' re jul chin xbequitz'eta' vo xa katzij o man katzij-ta re xbequibij re ixoki' chaka. Y can katzij-va che quire', roma can quire-va re xbequitz'eta' can re kachibil, pero re Jesús cama-va xquitz'at-ta can. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y re Jesús nitzijon binak quiq'uin, xubij c'a chique: Yex can man ninojij-ta ba', xa man c'o-ta pan ivánma re quibin re je rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Reje' quibin can che re Cristo tiene que nuk'asaj tijoj-pokonal, y c'are' niba chila' chicaj chin niya' ruk'ij, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y re Jesús xutz'am c'a rubixic chique andex ndel-va che tzij ronojel re je'tz'iban can chij reja' chupan re ruch'abal re Dios. Xutz'am-a riq'uin re je'rutz'iban can re Moisés, c'a riq'uin re quitz'iban chuka' re nic'aj chic rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y tak xe'bapon chupan re aldea rubini'an Emaús, re Jesús xuban che can choj nak'ax-a. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y chin che nicanaj-ka quiq'uin, xe'pa re je ca'e' achi'a' re' xquibij cha: Cacanaj-ka kaq'uin, roma re k'ij xa xka-yan-ka, y xa nik'ukumar-yan-ka. Y re Jesús xoc-apo pa jay, chin nic'ue-ka quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y tak je'tz'uyul chic-apo chach mesa, re Jesús xuc'am-apo re vay, y tak rutioxin chic cha re Dios, xupar re vay y xujach chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Y c'are' ancha'l xa xjak re quinak'avach, y xquitamaj rach che can ja-va re Jesús c'o quiq'uin. Y can c'aja xquitz'at manak chic quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y re je ca'e' achi'a' re' niquibila' c'a chiquivach: Can katzij-va che can nuna-va chic re kánma tak yojtzijon yojpitinak riq'uin, tak reja' xubij chaka andex ndel-va che tzij re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Re je ca'e' achi'a' re' can jare' xe'yacataj-a re anche' je'tz'uyul-va, y xquitz'am-a bey chin ye'tzolaj pa Jerusalén. Y xe'bequivila' re je once discípulos y re nic'aj chic vinak re can xe'tzekelben-va richin re Jesús, quimalon-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y re je once discípulos re' y re nic'aj chic vinak niquibij: Re Ajaf Jesús can xc'astaj-yan-va, y xuc'ut-yan-ri' chach re Simón Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y jare' tak re je ca'e' achi'a' xquitzijoj-apo re xquic'alvachij po bey tak je'binak pan Emaús, y chuka' xquitamaj rach re Jesús tak xupar re vay. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y conojel re quimalon-qui', c'a ye'tzijon chij re Jesús, tak xquitz'at c'o chic chire' chiquicojol, y xubij chique: Re ivánma can-ta otz nuna' roma yininiman chic. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero reje' xquinojij che re niquitz'at xa jun espíritu chin ánma, mare' camas xquixibij-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero re Jesús xubij chique: ¿Anchique roma tak xsatz ic'o'x tak xinitz'at y xinojij-ka itzel tak cosas? ");
INSERT INTO cakYNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Titz'eta' re nuk'a' y re vakan. Quinitz'ama-na-pa', y xtitz'at che can ja-va yen. Roma xe-ta yin ancha'l re xinojij chuij yen, man-ta c'o nu-cuerpo. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y tak re Jesús rubin chic quire' chique, xe'ruc'ut re ruk'a' y chuka' re rakan chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero reje' man niquinimaj-ta. Xa xsatz quic'o'x roma re niquitz'at y roma chuka' re ye'qui'cot. Y chin che niquinimaj, xpa re Jesús xuc'utuj chique: ¿C'o como jun andex chin nitij c'o iviq'uin chin niya-ta ba' chua? xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y reje' xbequiya-pa jun pedazo sa'on car cha y ba' cab re c'a c'o xca' riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y reja' xuc'ul y xutz'am rutijic chiquivach, chin tiquitz'eta' che can ja-va reja' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xubij c'a chique: Tak c'a yinc'o iviq'uin antes che yinquimisas, ximbij chiva che tiene que ninc'alvachij ancha'l nubij ronojel re je'tz'iban can chuij chupan re ruch'abal re Dios, ancha'l re je'tz'iban can roma re Moisés, re je'tz'iban can coma re nic'aj chic rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, y re je'tz'iban can chupan re libro rubini'an Salmos. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'are' reja' xuban chique chin xk'ax pa quive' re ruch'abal re Dios re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xubij c'a chique, che chupan re ruch'abal re Dios tz'iban can ronojel re', che yen re Cristo tiene que nink'asaj tijoj-pokonal, y c'are' yinquimisas, y pa rox k'ij yinc'astaj-pa chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Y pa nube' yen re Cristo xtitzijos re ruch'abal re Dios chique re vinak chach re ruch'ulef, che tijalataj re quic'aslen chach re Dios y nicuyutaj re quimac. Y nitz'uc-pa pa Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yex re can xitz'at ronojel re xe'banataj, can titzijoj c'a re xitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y can tic'axaj c'a jabal re nimbij can chiva. Can xtintak-pa re rusujun re Nata' Dios. Re rusujun reja', ja re Espíritu Santo. Y jare' re xte'yi'o-ka poder chiva. Y can quixc'ue' c'a vova' pa tenemit Jerusalén c'aja re k'ij tak xtika-pa re Espíritu Santo, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y re Jesús xe'ruc'uaj-a re ru-discípulos c'a pa tenemit Betania. Y chire' reja' xe'ruyac ruk'a' chicaj y xuc'utuj re ru-bendición re Dios pa quive'. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y re Jesús c'a ntajin-na chubanic quire' tak xyacataj-a chicaj pa cak'ik' roma xc'uax-a chicaj riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y re ru-discípulos can xquiya' c'a ruk'ij re Jesús re anche' jec'o-va. C'are' xe'tzolaj pa tenemit Jerusalén. Reje' camas c'a ye'qui'cot pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y k'ij-k'ij c'a ye'pa pa rachoch re Dios chin niquiya' ruk'ij re Dios y chuka' niquinimersaj rube'. Amén.");
INSERT INTO cakYNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Re Cristo jare' re Ch'abal re nisekresan chin re Dios. Tak xtiquir-pa ronojel, can c'o-va reja'. Reja' can c'o-va riq'uin re Dios y reja' chuka' can Dios-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Reja' can c'o-va-pa riq'uin re Dios tak xban re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y roma chuka' re Cristo tak c'o ronojel. Roma re Dios pa ruk'a' reja' xuya-va chin xuban ronojel cosas. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riq'uin reja' c'o-va re c'aslen. Y re c'aslen re', jare' re sakil quichin re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y re jun sakil re', nusekresaj re quic'aslen re vinak re jec'o pa k'oko'm. Y re k'oko'm chin re c'aslen re', can man nitiquir-ta nuchup re jun sakil re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xc'ue' jun ache re xtak-pa roma re Dios, y re' ja re Juan Bautista. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Re Juan Bautista xpa chin xutzijoj re Cristo re sakil, chin quire' conojel vinak tiquinimaj re nuya' rutzijol reja' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y mana-ta reja' re sakil. Reja' xaxe chin xuya' rutzijol re sakil re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y jare' tak xbeka re sakil re' chach re ruch'ulef. Jare' re katzij sakil re nisekresan quichin re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Can xbeka-va chach re ruch'ulef re banon roma reja', pero re jec'o chach re ruch'ulef, xa man xquitamaj-ta rach tak xbeka. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Can chupan-va re ruch'ulef chin reja' xbeka-va, pero re vinak re je richin reja', xa man xquic'ul-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Jac'a re xe'c'ulu y xe'niman richin, can xuban chique che xe'oc rajc'ual re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Re vinak re xe'oc rajc'ual re Dios can xa'lax-va chic, pero man ancha'l-ta tak xa'lax riq'uin re quite', tak xa ja re te'ej-tata'aj xe'jovan che xalax re ac'ual. Roma re c'ac'a alaxbal jare' re nurayij re Dios, y mana-ta re nurayij jun ache. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y re Cristo re Ch'abal re nisekresan chin re Dios, xbeka chach re ruch'ulef y can xoc chuka' ancha'l yoj re yoj vinak. Y xkatz'at che can xe-va reja' re Ruc'ajol re Dios, roma c'o ruk'ij y camas otz runa'oj kaq'uin y can xe-va re katzij ch'abal c'o riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y re Juan Bautista can xuya-va rutzijol re Cristo. Can riq'uin ruchuk'a' tak xubij: Jare' re ntzijon chiva, tak ximbij che re xte'ka chuij can yen, jare' re más c'o ruk'ij que chinoch yen. Y can c'o-va tak yen c'amaje-na quinalax chach re ruch'ulef, xcha' re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Can konojel c'a yoj re kaniman chic re Cristo kac'ulun re utzil. Can man xe-ta c'a jun bey re ruyi'om-pa chaka, xa can ruc'amom-pa-ri' re utzil re ye'ruya-pa chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Re Dios jac'a re Moisés re xucusaj chin xuya' re ley. Pero chin che xbeka re utzil y re katzij, ja re Jesucristo re xucusaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Can man jun vinak re tz'eteyon chin re Dios, xa can xe re Ruc'ajol re tz'eteyon richin. Re Dios xa can xe c'a jun Ruc'ajol c'o y camas nrajo'. Y jare' re xbesekresan-ka re Dios chakavach vova' chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y re achi'a' c'o quik'ij chakacojol yoj re yoj israelitas chire' pa tenemit Jerusalén, jec'o achi'a' re xe'quitak-a riq'uin re Juan Bautista. Xe'quitak-a sacerdotes y achi'a' re nibex levitas chique, chin che xbequic'utuj cha re Juan Bautista che tubij vo xa ja reja' re Cristo re bin che nitak-pa roma re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Y re Juan Bautista choj xubij: Mana-ta yen re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y c'are' re achi'a' re je'takon-a, xquic'utuj chic cha: ¿Yat anchique c'a rat c'a? ¿O xa ja rat re Elías re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha? xe'cha' cha. Pero re Juan Bautista xubij chique: Mana-ta yen. C'are' re achi'a' re' xquic'utuj chic jun bey cha re Juan Bautista: ¿Ja rat re profeta re bin che nipa? xe'cha' cha. Pero re Juan Bautista xubij: Mana-ta yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y c'are' re achi'a' re' xquic'utuj cha: ¿Yat anchique c'a rat c'a? Roma yoj nakajo' nakatamaj-a yat anchique rat, y jare' re nakabij chique re je'takayom-pa kachin. Tasekresaj c'a-avi' chakavach, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y reja' xubij chique re achi'a' re': Ja yen re jun ache re yi'on can nutzijol roma re Isaías re rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y jare' re xutz'ibaj can reja': Xtic'ue' c'a jun ache chupan jun lugar re anche' manak vinak re nibex desierto cha, y ja reja' re xtitzijon re ruch'abal re Dios chiquivach re vinak re xque'bapon riq'uin. Y xtubila' chique: Tichojmersaj rubey re ic'aslen, roma re Ajaf xa can nipa-yan, xcha' re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Y re achi'a' re xe'bapon riq'uin re Juan, ja re achi'a' re je'takon-a coma re fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y re achi'a' re' xquic'utuj chic cha re Juan: ¿Anchique roma rat ya'ban bautizar re vinak? Tak xa mana-ta rat re Cristo, y mana-ta chuka' rat re Elías y mana-ta rat re profeta re bin che nipa, xe'cha' re achi'a' re' cha re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y re Juan xubij chique: Yen riq'uin ya' ye'mban bautizar re vinak, pero chi'icojol yex c'o Jun re xte'ka re man itaman-ta rach, ");
INSERT INTO cakYNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y reja' chuij can yen xte'ka-va, pero ja reja' re más c'o ruk'ij que chinoch yen, mare' yen can man ruc'amon-ta che ninsol re ximibal-rach re ruxajab. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y ronojel re', ja chupan re jun lugar rubini'an Betábara xbanataj-va, re lugar re' c'o-apo juc'an ruchi' re rakan-ya' Jordán, re anche' ye'ruban-va bautizar re Juan. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Y pa ruca'n k'ij tak re Juan Bautista xutz'at che choj pitinak re Jesús riq'uin, xubij: Ja xbeka re ache re nibex ru-Cordero re Dios cha. Reja' takom-pa roma re Dios, chin nulisaj quimac re vinak re jec'o chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Y jare' re nbin chiva, tak ximbij che chuij yen xte'ka jun ache re c'o más ruk'ij que chinoch yen, y can c'o-va tak yen xinalax chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y yen man ntaman-ta anchique che ache reja'. Pero chin che nisekresas chiquivach re nuvinak israelitas, mare' tak ximpa chubanic bautizar riq'uin ya'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y re Juan can xusekresaj chuka' y xubij: Yen can xintz'at re Espíritu Santo tak xka-pa chila' chicaj ancha'l jun paloma y xbec'ue-ka pa rue' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y yen man ntaman-ta anchique re Jun re'. Pero re Dios re ya'yom-pa re jun samaj re' chua, can rusekresan-va chic chinoch che tak xtintz'at che nika-pa re Espíritu Santo y ne'c'ue-ka pa rue' jun ache, jare' re nibano bautizar riq'uin re Espíritu Santo y man riq'uin-ta ya'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vocame xintz'at-yan. Y mare' ninya' rutzijol che ja reja' re Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y pa ruca'n k'ij, re Juan y je ca'e' chique re ye'tzekelben richin, jec'o chic jun bey chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y jare' tak reja' xutz'at che re Jesús nak'ax chire'. Reja' xubij: Titzu', ja ache la' re nibex ru-Cordero re Dios cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y re je ca'e' re ye'tzekelben chin re Juan, tak xquic'axaj re xubij, reje' xe'ba chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y tak re Jesús xtzu'un can chij, xe'rutz'at re je ca'e' achi'a' re' che je'tzakatal chij, mare' reja' xuc'utuj chique: ¿Andex nicanoj? Y reje' xquibij cha re Jesús: Yoj nakajo' nakatamaj anche' c'o-va avachoch rat Rabí. Re ch'abal Rabí ndel che tzij Maestro. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y re Jesús xubij chique: Jo', y te'itz'eta'. Y reje' can xe'bo-va y xbequitamaj can anche' c'o-va re rachoch. Y xe'c'ue-ka riq'uin re jun k'ij re', roma c'o la'k a las cuatro re tak'ak'ij che'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Re jun chique re je ca'e' re xe'c'axan re andex xubij re Juan Bautista ja re Andrés ruch'alal re Simón Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Y c'are' re Andrés nabey xbo'rcanoj re Simón re ruch'alal y xbo'rbij cha: Kataman chic anchique re' re Mesías. Y re ch'abal Mesías ndel che tzij Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","C'are' re Andrés xuc'uaj re Simón re ruch'alal riq'uin re Jesús. Y tak re Jesús xutz'at, xubij cha: Ja rat re Simón ruc'ajol re Jonás. Vocame xtabini'aj chuka' Cefas. Y re be'aj re' ndel che tzij Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jac'a re pa ruca'n k'ij, re Jesús can runojin-va che niba pa Galilea. Y chupan re k'ij re' re Jesús xbo'rc'ulu-pa re jun ache rubini'an Felipe y xubij cha: Catzake' chuij. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y re Felipe aj pa tenemit Betsaida, re tenemit re anche' c'o-va cachoch re Andrés y re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Re Felipe xuvel re jun ache rubini'an Natanael y xubij cha: C'o chic re Jun re rubin can re Moisés chupan re ru-ley y re quibin can chuka' chupan re qui-libros re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique. C'aja nakatz'at can rach. Reja', ja re Jesús re ruc'ajol re José aj-Nazaret. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y re Natanael xubij: Yen can man ninimaj-ta che chire' pa tenemit Nazaret xtel-pa jun namalaj ache, xcha'. Pero re Felipe xubij cha: Vo xa man nanimaj-ta, jo' chutz'etic. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y tak re Jesús xutz'at che re Natanael napon-yan-apo riq'uin, xubij: Titzu' la jun ache la'. Reja' can chin-va re rutenemit re Dios, reja' jun katzij israelita. Can man jun tz'ucuj-tzij riq'uin, roma quire' nuc'ut re ruc'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","C'are' re Natanael xuc'utuj cha re Jesús: ¿Anche' xatamaj-va noch? Y re Jesús xubij cha: Yen xatintz'at tak c'a yatc'o chire' chuxe' re jun che' rubini'an higuera, tak c'amaje-na tapon re Felipe aviq'uin, xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Re Natanael can jare' xubij: Maestro, can ja-va rat re Ruc'ajol re Dios. Y can ja rat re Rey chin re nación Israel, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y re Jesús xubij cha re Natanael: Rat can xanimaj che ja yen re Ruc'ajol re Dios, xaxe roma ximbij chava che chuxe' re juvi' higo yatc'o-va tak c'amaje-na tac'ul re Felipe. Can xtatz'at cosas más je nima'k chin quire' más nanimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y re Jesús xubij chuka': Can tinimaj re xtimbij chiva: Yex can xtitz'at che re rocaj xtijakataj, y re ángeles chin re Dios xque'xule-xque'jote' chinuto'ic yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y pa rox k'ij, pa tenemit rubini'an Caná chire' pa Galilea, c'o jun c'ulubic xban. Y re María rute' re Jesús, c'o chuka' chire' chupan re c'ulubic re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y re Jesús y yoj re yoj ru-discípulos, xojban invitar chuka' chupan re c'ulubic re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jac'a re ruyi'al-uva xa cha'nin xq'uis chupan re c'ulubic. Y re rute' re Jesús xubij cha: Manak chic ruyi'al-uva quiq'uin. ¿Vocame andex nakaban? ");
INSERT INTO cakYNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero re Jesús xubij cha: ¿Andex najo'? Roma re nu-hora xa c'amaje-na tapon, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y re rute' re Jesús xubij chique re aj-ic'a': Vo xa c'o jun cosa re xtubij re Jesús chiva, can tibana', xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y chire' c'o vaki' cucu' chavon, je'banon riq'uin aboj. Yoj re yoj israelitas camas ye'kacusaj cucu' quire', roma chupan cucu' quire' nakaya-va re kaya' re ndoc chaka chin nakajosk'ij-ki', can ancha'l re nichalabex chaka roma re ka-ley. Y re cucu' re', cuatro cientos vasos ya' niba chupan jun. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y re Jesús xubij chique re aj-ic'a': Que'inojsaj re cucu' re' che ya', xcha' chique. Y re aj-ic'a' can quire-va xquiban, can xe'quinojsaj re cucu'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'are' re Jesús xubij chique re aj-ic'a': Vocame tipaja-a ba' y tic'uaj cha re ache pa'al chij re namak'ij re', chin tutija' retal. Y re aj-ic'a' can xquiban-va re xubij re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Y re ache pa'al chij re namak'ij re', tak xuna' che camas jabal re ruyi'al-uva, xrayoj re ala' xc'ule'. Roma re ache pa'al chij re namak'ij, man rutaman-ta anche' pitinak-va re ruyi'al-uva, xa can xe c'a re aj-ic'a' re xe'pajo, re je'atamayon. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Y tak xapon re ala' re xc'ule', re ache pa'al chij re namak'ij chin re c'ulubic xubij cha: Tak c'o jun namak'ij quire', conojel vinak ja re ruyi'al-uva re otz jare' re niquiya' nabey, y tak re jec'o pa namak'ij q'uiy chic quikumun, c'are' niquiya' re jun ruyi'al-uva re man can-ta otz. Pero rat xa man quire-ta xaban. Rat xa c'aja xbalisaj-pa re utzulaj ruyi'al-uva, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Re Jesús xuban cha re ya' che xoc ruyi'al-uva chupan re c'ulubic pa tenemit Caná chire' pa Galilea, y jare' re nabey milagro re xuban. Y riq'uin re jun milagro re', xk'alajin che reja' c'o ruk'ij y ru-poder. Y yoj re yoj ru-discípulos más xkaban confiar-ki' riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tak k'axnak chic re c'ulubic, re Jesús chibil re rute', re je ruch'alal y yoj re yoj ru-discípulos xojba pa tenemit Capernaum. Y xojc'ue-ka ca'e-oxe' k'ij chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y nakaj chic c'o-va re pascua re kanamak'ij yoj re yoj israelitas. Mare' re Jesús xba-a pa tenemit Jerusalén, chin re namak'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y chire' pa rachoch re Dios re c'o pa Jerusalén, re Jesús xe'bo'rvila' re ye'c'ayin vacx, ovejas y palomas. Y xe'bo'rvila' chuka' re ye'jalo rach mero re je'tz'uyul chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Re Jesús, can xe xe'rutz'at, xuban jun ruch'ayibal cha colo' y xe'rukotaj-pa conojel, chibil re qui-ovejas y re quivacx chire' pa rachoch re Dios. Y chique re ye'jalo rach mero, xuch'akela' can re qui-mero chiquivach y xe'rutiquimila' can re qui-mesas. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y xubij chique re ye'c'ayin palomas: Que'ilisaj-a re' vova'. Y man tiban cha re rachoch re Nata' Dios jun q'uiybal, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Mare' yoj re yoj ru-discípulos, cha'nin xbeka chakac'o'x re jun tzij re tz'iban can chupan re ruch'abal re Dios. Re tzij re' nubij: Re vánma can nik'axo roma re itzel tak cosas re ye'tajin chubanic re vinak chupan re avachoch, nicha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xquibij cha re Jesús: ¿Andex che señal yatiquir nac'ut chakavach chin quire' nakatamaj che c'o autoridad pan ak'a' chin xa'kotaj-a re vinak vova'? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y re Jesús xubij chique: Tivulaj re rachoch re Dios re', y yen pan oxe' k'ij xtimban chic jun bey, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xquibij cha re Jesús: Re jun jay re', cuarenta y seis juna' xquiban re kate-karta' chin xquipoba'. Y rat nabij che pan oxe' k'ij napoba' chic jun bey, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero re jay re xubij re Jesús chique re vinak re', ja re mismo ru-cuerpo. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y tak re Jesús xquimisas cho cruz, y pa rox k'ij xbec'astaj-pa chiquicojol re anama'i', c'ajare' tak yoj re yoj ru-discípulos xbeka chakac'o'x re jun tzij re xubij chique re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas. Y xkanimaj re nubij chupan re ruch'abal re Dios re tz'iban can ajuer, y re tzij re je'rubin can re Jesús chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupan re k'ij tak c'o re Jesús pa Jerusalén roma re namak'ij rubini'an pascua, je q'uiy vinak re xquinimaj. Re vinak re' xquinimaj tak xe'quitz'at re milagros xe'ruban chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero re Jesús man xuban-ta confiar-ri' quiq'uin re vinak re', roma reja' can rutaman-va re niquinojij pa tak cánma conojel. ");
INSERT INTO cakYNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y man nic'atzin-ta cha reja' che c'o-ta jun re nibim-pa cha re andex rubanic re quic'aslen che ja'jun re vinak, roma reja' can rutaman-va andex re c'o pa tak cánma. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y c'o jun ache chiquicojol re fariseos rubini'an Nicodemo, y re ache re' can c'o-va ruk'ij chakavach yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Y pa jun tok'ok'a', reja' xapon riq'uin re Jesús y xubij cha: Can k'alaj-va che yat jun Maestro re takom-pa roma re Dios, roma re milagros re ya'banala', xaxe re c'o Dios riq'uin re nitiquir nibano. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y re Jesús xubij cha re Nicodemo: Yen can katzij nimbij chava: Re anchique re man xtalax-ta chic jun bey, man xtoc-ta pa ruk'a' re Dios, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero re Nicodemo xubij cha re Jesús: Jun ache re'j chic, manak modo nalax chic jun bey. Roma re rute' manak modo nralaj chic jun bey, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Re Jesús xubij: Yen can katzij-va nimbij chava: Re c'ac'a alaxbal re xinataj, jare' re niban roma ya' y re Espíritu Santo. Y re man xtiquiban-ta re jun c'ac'a alaxbal re', man xque'oc-ta pa ruk'a' re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Re vinak re ruc'uan xaxe re alaxbal chin re ruch'ulef, can chin-va re ruch'ulef. Jac'a re vinak re ruc'uan re alaxbal chin re Espíritu Santo, can chin-va re Espíritu Santo. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Y man tisatz ac'o'x riq'uin re nimbij chava, roma can quire-va: Conojel nic'atzin che niquic'uaj jun chic c'ac'a alaxbal. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Re ye'c'uan re alaxbal chin re Espíritu Santo, nijalataj re quic'aslen. Y ja re Espíritu Santo re nijalo re quic'aslen, y re' man c'a natz'at-ta. Xa can ancha'l re cak'ik' re xabanche' ne'c'ulun-va-pa. Roma xaxe nac'axaj, pero man ataman-ta anche' pitinak-va y man ataman-ta chuka' anche' nibo-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y re Nicodemo xuc'utuj cha re Jesús: ¿Andex c'a rubanic re'? ");
INSERT INTO cakYNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Re Jesús xubij cha: ¿Man ataman-ta andex rubanic re' y can yat jun maestro chiquicojol re kavinak israelitas? ");
INSERT INTO cakYNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Can katzij nimbij chava: Yen ja re ntaman y ntz'eton jare' re nintzijoj, jac'a yex re yix vinak man nijo-ta ninimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yex man ninimaj-ta re cosas chin re ruch'ulef re nintzijoj chiva, c'alapa' xe-ta nintzijoj chiva re cosas chin chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Re chila' chicaj man jun re aponak-ta, xa can xe re Jun re kejnak-pa chila'. Can xe reja' re aponak. Xaxe re Jun re xalax chi'icojol y chila' chicaj riq'uin re Dios pitinak-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y ajuer can tak re Moisés xc'ue' chupan re jun lugar re anche' manak vinak re nibex desierto cha, reja' xutic jun che' nem rakan y xuya' jun ru-imagen cumatz pa rue'. Y ancha'l xban cha re ru-imagen re cumatz pa rue' re che' re', quire' chuka' nic'atzin che niban cha re Jun re alaxnak chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chin quire' anchique vinak re xtiniman richin, man c'a xtapon-ta chupan re camic chin jumul, xa xtic'ue' ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Re Dios camas ye'rajo' re vinak re jec'o chach re ruch'ulef, y mare' xutak-pa re Ruc'ajol vova' chach re ruch'ulef. Astapa' reja' xe jun Ruc'ajol c'o, pero xutak-pa chin che xabanchique vinak re xtiniman richin, man xtapon-ta chupan re camic chin jumul, xa xtic'ue' ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Roma re Dios man xutak-ta-pa re Ruc'ajol vova' chach re ruch'ulef, chin che nuya' re castigo chin jumul pa quive' re vinak. Re Dios xutak-pa re Ruc'ajol, chin che ye'rucol re vinak chach re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Y anchique vinak xtiniman richin, man xtika-ta re castigo pa rue'. Jac'a re vinak re man xtiniman-ta richin, re castigo chin nojel tiempo xa c'o chic pa rue', roma xa man xunimaj-ta re único Ruc'ajol re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Conojel re man ye'niman-ta, c'o chic re castigo pa quive', roma re sakil can xbeka-va chach re ruch'ulef, pero reje' xa más xquijo' re k'oko'm que chach re sakil, roma reje' can xe-va re itzel tak banabal re ye'quibanala'. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y conojel re ye'bano re itzel tak banabal, man nika-ta re sakil chiquivach, ni xe-ta chuka' ye'jelon-apo riq'uin, roma re sakil re' nuban che ye'bek'alajim-pa ronojel re itzel tak quibanabal re ye'tajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Jac'a re vinak re can ye'quibanala' re otz tak banabal ancha'l re nrajo' re Dios, can ye'bo-va-apo chupan re sakil, chin jabal ye'k'alajin che ye'tiquir niquiban quire'. Roma je rajc'ual chic re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Y tak k'axnak chic ronojel re', re Jesús y yoj re yoj ru-discípulos xojba pa Judea, y chire' xojec'ue-va. Y xe'bapon vinak re aj-chire' chin xe'ban-a bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupan chuka' re tiempo re', re Juan Bautista c'o chire' pan Enón re c'o-apo chunakaj re tenemit rubini'an Salim. Reja' chire' ye'ruban-va bautizar re vinak, roma chupan re lugar re' q'uiy ya' c'o. Re vinak ye'bapon riq'uin chin ye'ban-a bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupan re tiempo re' re Juan c'amaje-na tiya' pa cárcel, mare' c'a nuban bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y jec'o kavinak israelitas re xquibila' chiquivach quiq'uin re ye'tzekelben chin re Juan chij re andex che bautismo re más otz. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xe'pa re ye'tzekelben re Juan xe'ba riq'uin y xbequibij cha: Maestro, xe'cha'. Re Jun re xapon aviq'uin re juc'an chic-apo ruchi-ya' Jordán, re xabij che ja reja' re natzijoj rube', xa conojel re vinak ye'bapon riq'uin chin che ye'ruban bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Re Juan xubij chique re ye'tzekelben richin: Ja re Dios xtibin anchique re xtic'ue' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y yex mismo yixtiquir yixbin andex re nbin yen, che xa mana-ta yen re Cristo re bin che nitak-pa roma re Dios. Yen xaxe nbin che xintak-pa chin che ne'nya' rutzijol re anche' xte'ka-va reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yen camas niqui'cot re vánma vocame, roma xinc'axaj che camas je q'uiy vinak ye'bapon riq'uin re Jesucristo, can ancha'l nibanataj riq'uin jun ala' re ru-amigo jun chic ala' re c'a ba' tic'ule-va, mare' re ru-amigo niqui'cot che ye'ruc'axaj re je ca'e' ye'tzijon y quic'uan chic-qui'. Can rutaman che re xtan c'o chic-apo riq'uin re ruchijil. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Can xe-va re Jesucristo re ruc'amon che c'o más ruk'ij, jac'a yen más otz che manak nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Re Jun re kejnak-pa chila' chicaj, jare' re más nem ruk'ij que chakavach konojel yoj re yoj vinak. Roma yoj re yoj vinak, re kana'oj can xe-oc re vova' chach re ruch'ulef niq'uis-va-ka. Can xe-oc re' re yojtiquir nakatzijoj. Jac'a re Jun re kejnak-pa chila' chicaj, man ancha'l-ta-oc yoj, roma reja' can c'o pa rue' ronojel. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Re Jun re kejnak-pa chila' chicaj can jac'a re ruc'axam-pa y re rutz'eton can, jare' re no'rsekresaj-ka chakavach. Pero re vinak man niquijo-ta niquic'ul re no'rsekresaj-ka chakavach. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Y re vinak re nunimaj re no'rsekresaj-ka re Jun re kejnak-pa chila' chicaj, can nunimaj che re rubin can re Dios can katzij-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Roma re Jun re xutak-pa re Dios chach re ruch'ulef, can ja-va re ruch'abal re Dios re nutzijoj. Y re Dios can ruyi'om-pa re Espíritu Santo cha. Y re Espíritu Santo re nuya-pa cha reja', man jun re nitiquir nibin jenipa'. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y re Dios camas nrajo' re Ruc'ajol, y pa ruk'a' reja' xujach-va ronojel. ");
INSERT INTO cakYNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Y re vinak re xtiniman chin re Ruc'ajol re Dios, xtic'ue' ruc'aslen re man niq'uis-ta. Jac'a re vinak re man nunimaj-ta re Ruc'ajol re Dios, man c'a xtic'ue-ta ruc'aslen re man niq'uis-ta. Roma re vinak re man nunimaj-ta, can c'o chic re ruyoval re Dios pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Re achi'a' fariseos quic'axan che re Jesús c'o más q'uiy vinak re ye'ruban bautizar y más je q'uiy ye'tzake' chij, que chiquivach re vinak re ye'ban bautizar y re ye'tzake' chij re Juan Bautista. Y re Ajaf Jesús xunabej ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero re Jesús man can-ta ja reja' re nibano bautizar quichin re vinak. Xa ja yoj re yoj ru-discípulos re yojbano bautizar. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y re Jesús xel c'a-a chire' pa Judea, roma man nrajo-ta che re achi'a' fariseos ye'yacataj chij, mare' xtzolaj chic jun bey pa Galilea chibil chuka' yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Xa jac'a chin che yojapon pa Galilea, tiene que yojak'ax pa Samaria. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Re Jesús y chuka' yoj re yoj ru-discípulos xojapon pa tenemit Sicar. Y re tenemit re' chin re Samaria. Re tenemit Sicar c'o-apo chunakaj re jun juyu' re xuya' re Jacob cha re José re ruc'ajol. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y jac'a chire' c'o-va re jun pozo re rubini'an Pozo de Jacob. Chire' xtz'uye-va-ka re Jesús, roma reja' camas cosnak-pa roma re bey kabanom-pa, y roma chuka' nuban-yan pak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y tak yojbinak yoj re yoj ru-discípulos pa tenemit chulok'ic cosas chin nakataj yoj y re Jesús, chire' chuchi' re pozo xapon jun ixok aj-chire' pa Samaria chulesasic ruya'. Y re Jesús xubij cha re ixok re': Taya' ba' nuya' chin ninkum, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero re ixok aj-Samaria xubij cha re Jesús: Rat yat jun israelita, ¿y anchique roma tak nac'utuj aya' chua yen? Man ruc'amon-ta che jun aj-Samaria nuya' ruya' jun israelita, xcha' re ixok. Reja' xubij quire' roma yoj re yoj israelitas y re aj-Samaria can man otz-ta nakatz'at-ki'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","C'are' re Jesús xubij cha re ixok re': Xe-ta rat ataman andex re nusipaj re Dios, y ataman-ta chuka' anchique re' re nuc'utuj ba' ruya' chava, xa ja-ta rat re yac'utun aya' cha, y reja' nuya-ta aya' re nuya' c'aslen, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y re ixok xubij cha re Jesús: Re pozo naj kejnak-ka, y rat man jun anchok cha nac'am-va-ka re ya'. ¿Anche' nac'am-va re ya' re niyi'o c'aslen re nasuj? ");
INSERT INTO cakYNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Roma chupan re jun pozo re' xuc'am-va ruya' re kamoma' Jacob, re rajc'ual y quichin chuka' nojel re chicop xe'c'ue' quiq'uin. ¿Anche' xtac'am-va re ya' re nasuj? Roma rat manak más ak'ij que chach re kamoma' Jacob, roma nabij che re ya' re nuya' c'aslen man vova-ta nalisaj-va, xcha' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y re Jesús xubij cha re ixok: Re ye'kumu re ya' re ndel chupan re pozo re', man nak'ax-ta-a re nichake'j quichi'. Xa nic'atzin che niquikum más ya' chin che nich'uch'o-ka ba' re nichake'j quichi'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Jac'a re ye'kumu re ya' re niyi'o c'aslen re ninya' yen chique, xtuban chique che man chic xtichake'j-ta quichi'. Xa can xtuban chique che quiq'uin reje' nalax-va re ya' re', y can ancha'l nuban re ya' anche' ndel-va-pa, can quire' xtuban re quic'aslen re man xtiq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y re ixok can jare' xubij cha re Jesús: Taya' c'a re ya' re' chua yen, chin quire' man jun bey chic xtichake'j nuchi', y chin che man chic yimpa-ta vova' chuchi' re pozo chulesasic ya', xcha' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero re Jesús xubij cha re ixok: Cabiyin y ta'vayoj-pa re avchijil. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Re ixok xubij: Yen manak vichijil. Y re Jesús xubij cha: Can katzij nabij che manak avchijil. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Roma je vo'o-yan avchijil que'c'ue'. Y re ache re c'o aviq'uin vocame, xa man avchijil-ta. Can katzij xabij che manak avchijil. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y jare' tak re ixok xubij cha re Jesús: Yen ninojij che rat yat jun rusamajel re Dios re nibex profeta cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","¿Anche' ruc'amon che nakaya-va ruk'ij re Dios? Roma re kavinak re xe'c'ue' ajuer can, pa rue' re jun loma re' xquiya-va ruk'ij re Dios. Jac'a yex israelitas nibij che conojel vinak tiene que pa Jerusalén niquiya-va ruk'ij re Dios, xcha' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jac'a re Jesús xubij cha re ixok re': Tanimaj re xtimbij chava. Can xte'ka-va jun k'ij tak conojel vinak mana-ta chic pa rue' re loma re', y ni xe-ta chuka' pa Jerusalén xtiquiya-va ruk'ij re Karta' Dios re c'o chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yex aj-Samaria man can-ta itaman chij re anchique niya' ruk'ij. Jac'a yoj re yoj israelitas can kataman-va re anchique nakaya' ruk'ij, roma can kaq'uin yoj pitinak-va re utzulaj ch'abal re nubij che nipa Jun chin ye'rucol re vinak chach re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Re jun k'ij re ximbij chava che can nipo-va, xbeka-yan, chin che conojel vinak man chic niquiya-ta ruk'ij re Karta' Dios xaxe pa rue' re loma re', y ni xe-ta chuka' xaxe pa Jerusalén. Re katzij xque'yi'o ruk'ij re Karta' Dios, ja re c'o re Espíritu Santo quiq'uin, y chuka' can riq'uin ronojel cánma xtiquiya' ruk'ij. Y re Dios nrajo' che re vinak quire' niquiban. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Re Dios can Espíritu-va. Mare' re vinak re ye'yi'o ruk'ij, can nic'atzin che c'o re Espíritu Santo quiq'uin y riq'uin ronojel cánma tiquiya' ruk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y re ixok xubij cha re Jesús: Yen ntaman che c'o jun k'ij tak re Mesías xte'ka chach re ruch'ulef, re nibex chuka' Cristo cha, re bin che nitak-pa roma re Dios. Y re k'ij tak xte'ka reja', ronojel xtusekresaj chakavach, xcha' re ixok. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Re Jesús xubij cha: Re Mesías re nibij chuka' Cristo cha, ja yen. Ja yen re yintzijon aviq'uin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y jare' tak xojapon yoj re yoj ru-discípulos, y yoj ju-va ba' xkatz'at roma nitzijon riq'uin jun ixok aj-chire' pa Samaria. Pero yoj man jun andex xkabij cha re Jesús: ¿Andex nac'utuj cha? o ¿Andex re natzijoj riq'uin? Cama-va jun cosa xkac'utuj cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y re ixok re' xuya' can re rucucu' y xba pa tenemit. Y xbo'rbij chique re vinak: ");
INSERT INTO cakYNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","C'o jun ache xch'o viq'uin y xubij chua ronojel re je'mbanalon. ¿Mana-ta como re' re Cristo re bin che nitak-pa roma re Dios? Jo', y te'itz'eta', xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y re vinak re xe'c'axan re', xquiya' can re tenemit y xe'ba anche' c'o-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y tak c'amaje-na que'bapon re vinak, yoj re yoj discípulos xkabij cha re Jesús: Maestro, cava', xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero reja' xubij chaka: Yex man itaman-ta che yen c'o nuay chin nintaj, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","¿C'o como xc'amo-pa ruay? xojcha-ka chakavach. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y re Jesús xubij chaka: Re nuay yen ja re nimban re nurayij re takayom-pa vichin y ninq'uis can rubanic ronojel re rusamaj re ruchalabem-pa chua. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yex nibij che c'a caje' ic' nrajo' che niban cosechar ronojel rach re tico'n. Jac'a yen nimbij chiva: Quixtzu'un chila' y que'itz'eta' la vinak. Reje' je ancha'l jun tico'n re k'an chic. Quiyaben chic che nitzijos re ruch'abal re Dios chique, chin niquinimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Re xque'samaj riq'uin la cosecha la', can c'o rajal-ruq'uixel xtiquic'ul, y re rajal-ruq'uixel re xtiquic'ul, ja re vinak re xque'niman re Dios y re ruch'abal, xtiquic'ul c'a quic'aslen re man xtiq'uis-ta. Y riq'uin re', re je'tiquiyon can re ruch'abal re Dios, can xtiqui'cot cánma quiq'uin re ye'bano cosechar rach re jun tico'n re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vova' can katzij-va ndel re tzij re nubij: Jun-va re nitico can y jun-va chic re nibano-a cosechar re tico'n. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yen xixintak chin che yex xaxe chic niban cosechar re man yix-ta re xixcos chusamajesic. Roma re ruch'abal re Dios xa juley-va samajela' je'tiquiyon can pa tak cánma re vinak, y yex xaxe chic ba' samaj re ne'ibanala' chin niquinimaj re ruch'abal re Dios, xcha' re Jesús chaka yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupan re k'ij re', camas je q'uiy vinak xe'niman richin re Jesús chire' pa tenemit Sicar, re c'o chire' pa Samaria. Y re' xbanataj roma re ixok xbo'rbij chique che re Jesús xubij cha ronojel re je'rubanalom-pa. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Y re samaritanos xbequic'utuj utzil cha re Jesús che tic'ue-ka quiq'uin. Y reja' xc'ue-ka ca'e' k'ij quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y jec'o je q'uiy más re xe'niman, pero c'aja tak quic'axan chic re ch'abal re nubij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Re vinak re' niquibila' cha re ixok re xbeyi'o rutzijol chique: Vocame can kataman chic y nakanimaj chuka', man xe-ta roma re xabij rat chaka, xa can nakanimaj chuka' roma xkac'axaj yoj mismo. Xkatamaj che can katzij-va che ja reja' re Cristo re bin che nitak-pa roma re Dios, re nicola quichin conojel vinak re jec'o chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tak k'axnak chic ca'e' k'ij, re Jesús xuya' can re tenemit Sicar re c'o chire' pa Samaria y xutz'am chic-a rubey chin niba pa Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Chire' xbo-va re Jesús roma reja' mismo nibin che pa rutenemit jun rusamajel re Dios re nibex profeta cha, xa man jun ruk'ij chiquivach re ruvinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero tak re Jesús xapon pa Galilea, jabal ruc'ulic xban coma re vinak aj-chire', roma re vinak re' xe'c'ue' pa Jerusalén chin re namak'ij y xquitz'at re milagros re xe'rubanala' re Jesús chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'are' re Jesús xba chic jun bey pa tenemit Caná re c'o chire' pa Galilea, re anche' xuban cha re ya' che xoc ruyi'al-uva. Y chire' pa tenemit Capernaum c'o jun namalaj ache re niyavaj jun ruc'ajol, y re namalaj ache re' rusamajel re Rey. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Re ache rusamajel re Rey, tak xuc'axaj che re Jesús pitinak c'a quila pa Judea y xapon chire' pa Galilea, xba riq'uin. Reja' xbo'rc'utuj utzil cha chin che nuc'achojsaj-ta re ruc'ajol, roma nicom-yan. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","C'are' re Jesús xubij cha re rusamajel re Rey: Man-ta nitz'at yex re milagros re nimban yen, man-ta yininimaj. Y chuka' vo xa man-ta nik'alajin re señales che can ja re Dios re takayom-pa vichin, man-ta chuka' yininimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero re ache re rusamajel re Rey xubij cha re Jesús: Ajaf, tabana' utzil che yaxule-ta-ka pa tenemit Capernaum, roma re nuc'ajol nicom-yan. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y re Jesús xubij cha: Catzolaj. Re ac'ajol c'o ruc'aslen, xcho'x-a. Y re ache re' can xunimaj-va re xubij re Jesús, y xba. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tak re ache rusamajel re Rey tzolojnak-ka, jec'o c'a ru-mozos xe'pa chuc'ulic y xquibij cha: Re ac'ajol c'as. Man xcom-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y reja' xuc'utuj chique re xe'pa chuc'ulic: ¿Anchique hora tak re nuc'ajol xk'alajin che xc'achoj-a? Y reje' xquibij: Ja re tak'ak'ij ivir. La una chire' tak xq'uis-a re c'atan chij, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Re rutota' re ala' re niyavaj, cha'nin xbeka chuc'o'x che ja hora re' tak re Jesús xubij cha che re ruc'ajol man xticom-ta. Y mare' reja' y re jec'o pa rachoch can xquinimaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y jare' re ruca'n milagro re xuban re Jesús chire' pa Galilea, re milagro re' ndoc chuka' señal che reja' can ja-va re Dios takayom-pa richin. Y jare' re milagro re xuban tak tzolojnak-pa quila pa Judea. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y tak banatajnak chic ronojel re', jare' tak ne'ka-yan jun kanamak'ij yoj re yoj israelitas, y mare' tak re Jesús xba-a pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chire' pa tenemit Jerusalén, chunakaj-apo re puerta re rubini'an Puerta de las Ovejas, c'o jun ya' chin ye'ratin chupan. Y chire' chuchi' re ya' c'o vo'o' corredor. Y yoj re yoj israelitas nakabij Betesda cha re lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Y chire' chach re corredor camas je q'uiy yava'i' je'cotz'al. Jec'o je moyi', jec'o cojos y jec'o je siquirnak. Y jec'o re jun-va chic che yabil ndoc chique. Y conojel re yava'i' re', can quiyaben che nisilom-pa re ya'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roma re ya' re' can c'o-va k'ij tak nisilos can roma jun ángel re nika-pa chila' chicaj riq'uin re Dios. Y jac'a re yava' re nika-ka nabey chupan re ya' tak silon chic, ja yava' re' re nic'achoj. Y xabanchique yabil ndoc cha, nic'achoj-a. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chire' chuchi' re ya' c'o c'a jun ache treinta y ocho juna' tutz'am-va yabil. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun k'ij tak re Jesús nak'ax chire', xutz'at re ache cotz'al chire'. Y reja' can rutaman-va che re ache re' q'uiy juna' re tuc'alvachij-va quire'. Y c'are' reja' xuc'utuj cha re ache re': ¿Najo' yac'achoj? ");
INSERT INTO cakYNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y re yava' re' xubij cha re Jesús: Tak nisilom-pa la ya', man jun nibano utzil chua che yinruto-ta chin yinapon-apo c'a chupan. Mare', astapa' nintaj nuk'ij che yimba-ta-apo, c'amaje-na quinapon tak ja-yan jun chic napon nabey chinoch, xcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y re Jesús xubij cha re ache: Cayacataj, tac'uaj-a la a-camilla y cabiyin. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Can xe xubij quire' re Jesús cha re yava', can jare' xc'achoj cha re ruyabil. Xuc'uaj-a re ru-camilla y can ja xbiyin-a. Pero re k'ij re', k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xquibij cha re ache re xc'achojsas cha re ruyabil: Vocame k'ij chin uxlanen, xajan che rat ac'uan-a la a-camilla, quire' nubij re ka-ley. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero reja' xubij chique re achi'a': Re xc'achojsan vichin xubij chua: Tac'ola-a la a-camilla y cabiyin. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y re achi'a' re' xquic'utuj cha re ache: ¿Anchique re xbin chava che tac'ola' re a-camilla y cabiyin? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero re ache re xc'achojsas, man rutaman-ta anchique re xc'achojsan cha re ruyabil, roma re Jesús xa man xc'ue-ta-ka chire' chiquicojol re vinak. Reja' xa xba. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","C'are' re Jesús xuvel chic re ache re' pa rachoch re Dios, y xubij cha: Vocame yat otz chic. Man chic camacun, chin quire' man tika jun cosa más c'ayef chavij, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y re ache xtzolaj, y xapon quiq'uin re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, y xubij chique: Re xc'achojsan vichin, ja re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Mare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xe'yacataj chij re Jesús, y niquinojela' andex niquiban chin niquiquimisaj, roma re Jesús c'o milagros ye'rubanala' chupan re k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero re Jesús xubij: Re Nata' Dios can nisamaj-va re k'ij re', y quire' chuka' yen, yinsamaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, más xquinojij andex niquiban chin niquiquimisaj re Jesús, roma chiquivach reje', xajan re ye'rubanala' chupan re k'ij chin uxlanen. Y chuka' man xe-ta roma re', xa roma chuka' re Jesús nubij Rutota' cha re Dios, roma chiquivach reje', re Jesús can nuban che reja' junan riq'uin re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y jare' tak re Jesús xubij: Can katzij re nimbij chiva, che yen re Ruc'ajol re Dios can man nimban-ta re samaj riq'uin nuna'oj yen, xa nic'atzin che ninyabej-na re nubij re Nata'. Roma ja re samaj re nrajo' reja', jare' re nimban yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y roma re Nata' Dios camas yinrajo' yen re Ruc'ajol, mare' tak reja' nuc'ut chinoch ronojel re rusamaj reja'. Y chakavach-apo c'o samaj más je nima'k re xtuc'ut chinoch. Y tak xtimban re samaj re', yex can xtisatz ic'o'x tak xtitz'at. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y can ancha'l nuban re Nata' Dios tak nuya' quic'aslen re je quiminak y ye'ruyac-pa, can quire' chuka' nimban yen. Yen can ninya' chuka' quic'aslen re ye'njo'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Re Nata' Dios, pa nuk'a' chuka' yen re Ruc'ajol rujachon-va re poder chin xtimban juzgar y mana-ta reja' re xtibano. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chin quire', coma conojel yen xtinc'ul chuka' nuk'ij ancha'l re nuc'ul re Nata' Dios. Roma anchique vinak re man xtiyi'o-ta nuk'ij yen re Ruc'ajol re Dios, man nuya-ta chuka' ruk'ij re Nata', re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Roma can katzij-va nimbij chiva, che re nic'axan re nuch'abal y nunimaj re takayom-pa vichin, nuvel ruc'aslen re man niq'uis-ta. Y man xtapon-ta chupan re lugar re anche' camas tijoj-pokonal, roma colotajnak chic chach re camic, chin xk'ax-apo chupan re c'aslen re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y can katzij nimbij chiva, che c'o jun k'ij re yaben y ja re xbeka-yan, che re je quiminak xtiquic'axaj re nuch'abal yen re Ruc'ajol re Dios. Y jac'a re xquinquic'axaj y xquinquinimaj, xtiquivel quic'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Roma re Dios ruyi'on k'ij chua chin che ninya' c'aslen, ancha'l nuban reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y chuka' ruyi'on autoridad chua chin nimban juzgar, roma reja' rutaman che ja yen re xinalax chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Y chuka' man tinojij che re ximbij-yan-ka chiva, xe-oc re' re yintiquir nimban, man quire-ta. Roma can xtapon re k'ij che re je quiminak chic-a tiene que xtiquic'axaj re nuch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y jac'a re xe'c'uan jun c'aslen otz chach re Dios, xque'beyacataj-pa chin xtiquivel quic'aslen re man niq'uis-ta. Y re xquic'uaj jun itzel c'aslen chach re Dios, xque'beyacataj-pa chin xque'beka pa tijoj-pokonal. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yen can man nimban-ta re samaj riq'uin re nuna'oj, roma xa can ancha'l re bim-pa chua, can quire' chuka' nimban juzgar. Tak nimban juzgar, can pa rubiyal-va, roma mana-ta re ninrayij yen re nimban, xa can ja re nurayij re Nata' Dios re takayom-pa vichin, jare' re nimban. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y xe-ta nayon yen otz yinch'o-ka chuij, can otz che nibex chua che man katzij-ta re nimbij-ka chuij yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero c'o chic Jun re otz nich'o chuij. Y re nubij reja' chuij yen, can katzij-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Y yex can xitak ruc'utuxic cha re Juan Bautista chij re Cristo, y reja' xubij-pa re katzij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yen ninataj-apo re' chiva, chin che yex yininimaj y yixcolotaj. Roma c'o chic Jun re más nem ruk'ij re niyi'o testigo chuij, que chach re Juan Bautista o sea jun chic vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y re Juan Bautista can xuya' re sakil chiva. Can xuban-va ancha'l nuban jun antorcha tak nic'at, nusekresaj re anche' nic'ue-va. Y yex xirayij y xixqui'cot riq'uin re sakil re', jun ca'e-oxe' k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Y roma re xusekresaj re Juan chuij, can otz-va che yininimaj. Pero más nic'atzin che yininimaj, roma ronojel re milagros re ye'mban yen chivach, jare' re nisekresan che ja re Nata' Dios re takayom-pa vichin. Y ja reja' re biyom-pa chua che nimban ronojel re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y chuka' re Nata' Dios re xintako-pa, otz nich'o chuij. Y yex man jun bey ic'axan-ta andex nuban nich'o, y man jun bey chuka' itz'eton-ta rach. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Y re ruch'abal reja' camanak-va pa tak ivánma, roma yex xa man yininimaj-ta yen re xintak-pa chi'icojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Can tinic'oj jabal re ruch'abal re Dios re tz'iban can, roma can itaman che chupan re' nivel-va re c'aslen re man niq'uis-ta. Y re ruch'abal re Dios jac'a chuij yen nich'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Jac'a yex man nijo-ta niban confiar-ivi' viq'uin, chin quire' nivel-ta re ic'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Y ronojel re ximbij-ka chiva, man roma-ta che yen ninjo' niya' nuk'ij coma re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yen can ntaman ivach, mare' ntaman che xa man nijo-ta re Dios pa tak ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Roma yen can pa rube' re Nata' Dios yimpitinak-va y xa man xinic'ul-ta. Pero xe-ta c'o jun re nipa pa rube' reja' mismo, jare' sí can chiyixnojel yixba chuc'ulic y ninimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yex xa man nicanoj-ta ik'ij riq'uin re katzij Dios, xa ja quiq'uin re vinak nicanola-va ik'ij, mare' manak modo xquininimaj yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man tinojij pa tak ivánma che ja yen re xquinsujun chivij chach re Nata' Dios. Re xtisujun ivichin chach re Dios ja re Moisés roma mana-ta re yixtajin chubanic, y nibij che can c'o i-esperanza riq'uin re ru-ley. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Roma xe-ta can katzij che yex ninimaj re je'rutz'iban can re Moisés, can yininimaj-ta chuka' yen, roma re je'rutz'iban can reja' can chuij-va yen ye'ch'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y vo xa man ninimaj-ta re je'tz'iban can roma re Moisés, c'alapa' c'a re ch'abal re nc'amom-pa yen chiva, re xtinimaj-ta, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Y tak xe'banataj-yan ronojel re', re Jesús y yoj re yoj ru-discípulos xojba c'a juc'an chic-apo ruchi' re lago rubini'an Galilea, y chuka' nibex Tiberias cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Camas je q'uiy vinak re xe'tzake-a chij, roma re vinak re' quitz'eton chic re milagros re ye'rubanala' chique re yava'i', milagros re nisekresan che can ja-va re Dios takayom-pa richin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Re Jesús y yoj re yoj ru-discípulos xojote-a pa rue' jun loma, y chire' xtz'uye-va-ka reja' chakacojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Y nakaj chic c'o-va re pascua, re kanamak'ij yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y tak re Jesús xtzu'un-ka, xutz'at che camas je q'uiy vinak re je'tzakatal chij. Mare' reja' xubij cha re Felipe re jun ru-discípulo: ¿Anche' xtakalok'o-va-pa vay chin che ye'katzuk conojel re vinak re'? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quire' xubij re Jesús cha re ru-discípulo, chin che nutamaj andex nunojij reja', vo xa ne'ka chuc'o'x che re Jesús ronojel nitiquir nuban. Pero re Jesús rutaman chic andex nuban chin ye'rutzuk re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y re Felipe xubij cha re Jesús: Xe-ta nakalok' ca'e' ciento denarios vay, man xque'ruban-ta. Can man xtel-ta-apo chiquivach, astapa' ba-oc re nakaya' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","C'are' jun chaka yoj re yoj ru-discípulos, re rubini'an Andrés ruch'alal re Simón Pedro, xubij: ");
INSERT INTO cakYNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Vova' c'o jun ala' re c'o vo'o' vay riq'uin, banon che cebada y ca'e' car. ¿Pero xaxe-ta-oc re' re xtakaya-apo chiquivach conojel re vinak re'? xcha' re Andrés. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","C'are' re Jesús xubij: Tibij chique la vinak che que'tz'uye'. Y re lugar re' otz chin ye'tz'uye', roma q'uiy sabana c'o. Conojel re vinak quimalon-qui' chire' xe'tz'uye'. Je vo'o' mil la'k xaxe re achi'a'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Re Jesús xe'ruli'ej re vo'o' vay re' y xutioxij cha re Dios. C'are' xujachala-a chaka yoj re yoj ru-discípulos chin che nakajach chiquivach re vinak re je'tz'uyul. Y re Jesús can quire' chuka' xuban cha re ca'e' car. Re vinak can xquic'ul re jenipa' vay y car re xquijo'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y tak je'viynak chic jabal re vinak re', re Jesús xubij chaka yoj re yoj ru-discípulos: Timola-pa ronojel vay y car re man xquiq'uis-ta, roma man ninjo-ta che nitz'elas can. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Y xbakamola-pa re man xquiq'uis-ta re vinak y doce chacach che nojel re xkamol. Ja nojel re' xmolotaj can cha re car y re vo'o' vay banon che cebada. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y re vinak re', tak quitz'eton chic re milagro re xuban re Jesús, re nisekresan che can ja re Dios re takayom-pa richin, reje' xquibij: Can katzij-va che ja ache re' re jun rusamajel re Dios re nibex profeta cha, y q'uiy-yan tiempo yaben che nipa chach re ruch'ulef, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Y re Jesús xunabej che re vinak xque'pa chuc'amic chin che niquiban qui-Rey cha y astapa' man nrajo-ta reja', mare' rion xtzolaj pa rue' re loma. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y tak xkatz'at che xk'ak'ij-ka, yoj re yoj ru-discípulos re Jesús xojtzolaj-ka chuchi' re lago. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yoj xojoc-a pa jun canoa y xkatz'am-a bey chin che xojba pa tenemit Capernaum, re c'o c'a juc'an chic-apo ruchi' re lago. Camas chic k'oko'm y re Jesús man aponak-ta kaq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y jare' tak xbetiquir-pa jun namalaj cak'ik' pa rue' re lago, jun cak'ik' re camas ruchuk'a'. Y mare' re ya' camas nisilon. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Y tak xojbiyin-yan jun vo'o' o vaki' kilómetros, xkatz'at re Jesús pitinak charakan pa rue' re lago y ne'copej-pa kaq'uin. Y yoj camas xkaxibij-ki'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero re Jesús xubij chaka: Man tixibij-ivi'. Ja yen re Jesús, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Y tak re Jesús xubij quire', otz xkana-ka y yojqui'cot xkac'ul-apo re Jesús chupan re canoa. Y can jare' tak xojapon chupan re lugar re anche' tiene que yojapon-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pa ruca'n k'ij, re vinak re c'a xe'c'ue-na can juc'an-apo ruchi' re lago, can quitaman che xaxe yoj re yoj ru-discípulos re Jesús re xojtzolaj chupan re jun canoa re c'o chire'. Pero re Jesús c'a xc'ue-na can. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Re k'ij re', jec'o canoas re je'pitinak pa tenemit Tiberias y xe'bapon chunakaj re lugar anche' tak re Ajaf Jesús xutioxij cha re Dios, roma re vay chin xe'rutzuk re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y re vinak re', roma xquitz'at che re Jesús xa man c'o-ta chic chire' y yoj re yoj ru-discípulos xa xojtzolaj-yan, reje' chuka' xe'oc-a pa tak canoas y xe'ba pa Capernaum chucanoxic re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tak re vinak re' xbequivila' re Jesús juc'an chic-apo ruchi' re lago, xquibij cha: ¿Jampa' cateka-va vova' y anchok chupan xapo-va? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero re Jesús xubij chique re vinak re': Katzij nimbij chiva, che yex yinicanoj xaxe roma xivel ivay viq'uin y jabal xnoj ipan, y man roma-ta che xitz'at re milagros re nisekresan che yen can ja-va re Dios re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Can quixsamaj, pero man chin-ta che nich'ac re vay re xa niq'uis. Xa can quixsamaj chin nich'ac re vay re c'o nojel tiempo y nuya' ic'aslen re man niq'uis-ta. Ja vay re' re xtinya' chiva yen re xinalax chi'icojol, roma ja yen re xinrutak-pa re Nata' Dios, chin nimban re samaj re', y can xuban che xk'alajin che ja reja' re xtako-pa vichin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y re vinak re' xquibij cha re Jesús: ¿Andex re nika chach re Dios che nakaban? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y re Jesús xubij chique: Re nika chach re Dios che yex niban, ja re quininimaj yen re xintak-pa roma reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y re vinak xquibij cha re Jesús: ¿Andex che señal yatiquir naban? Tabana' jun milagro, chin quire' nakatz'at y yatkanimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Roma re kavinak xe'c'ue' ajuer can, tak xe'k'ax chupan re jun lugar re anche' manak vinak re nibex desierto cha, jac'a vay re xubini'aj maná re xuya' re Moisés chique chin xquitaj. Can ancha'l-va re nubij re ruch'abal re Dios re tz'iban can: Vay re pitinak chila' chicaj re xuya' chique chin xquitaj. Y rat ¿yatiquir como naban ancha'l xuban re Moisés? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y re Jesús xubij chique: Tic'axaj jabal re xtimbij chiva: Re vay re xka-pa chila' chicaj, mana-ta re Moisés xyi'o. Xa ja re Nata' Dios re xyi'o y ja chuka' reja' re niyi'o chiva re katzij vay chin chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roma re vay chin re Dios, ja re Jun re pitinak chila' chicaj. Y jare' re c'amayom-pa c'aslen chique re vinak, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tak xquic'axaj quire' re vinak, xquibij cha re Jesús: Nojel tiempo taya' re vay re' chaka, rat Maestro, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y re Jesús xubij chique: Ja yen re vay re niyi'o c'aslen. Re xtiniman vichin, man chic xtich'umun-ta rupan, roma ja yen re yinoc ruay y ninlisaj-a re ruch'umunic rupan. Y chuka' re xtuban confiar-ri' viq'uin, man xtichake'j-ta chic ruchi', roma ja yen re yinoc ruya'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero ancha'l nbin chiva, che yex man yininimaj-ta astapa' can xic'axaj y xitz'at re samaj re ximban. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel re xque'pa chinucanoxic, ye'nc'ul, y man jun bey xque'ntzelaj-ta-a. Roma jare' re je'rucha'on chic re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Roma yen re xinka-pa chila' chicaj man nusamaj-ta yen re nc'amom-pa. Yen xinka-pa chila' chicaj chubanic re samaj re nurayij re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Y re samaj rubim-pa re Nata' Dios re takayom-pa vichin, ja che conojel re je'rucha'on reja', re ye'canon vichin yen, man-ta c'a xque'satz can, y pa ruq'uisibal k'ij xque'nc'asoj-a chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Re samaj re bim-pa chuka' chua roma re Nata', re takayom-pa vichin, ja che conojel re ye'tz'eto re nusamaj y yinquinimaj, tic'ue' c'a quic'aslen re man niq'uis-ta, y ye'nc'asoj-a chiquicojol re anama'i' re pa ruq'uisibal k'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jac'a re kavinak israelitas xe'xibixot-ka chij re Jesús, roma reja' xubij: Ja yen re vay re kejnak-pa chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y xquibij: Pero jare' re Jesús re ruc'ajol re José, roma re rute-rutota' yoj kataman quivach. ¿Anchique roma nubij chaka che reja' kejnak-pa chila' chicaj riq'uin re Dios? ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero re Jesús xubij chique: Man quixibixot-pa chuij. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Roma re Nata' Dios re takayom-pa vichin, ja reja' re samajenak chic pa tak cánma re xque'niman vichin. Y yen can xtimban chique re ye'niman vichin che xque'c'astaj-a chiquicojol re anama'i' re pa ruq'uisibal k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Y can tz'iban-va can coma re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, che conojel c'o xtic'ut chiquivach roma re Dios. Y re anchique nuc'axaj re ruch'abal re Nata' Dios y nutamaj, can xtipa chinucanoxic yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero man roma-ta che c'o jun vinak re tz'eteyon rach re Dios. Xaxe yen re yimpitinak chila' chicaj riq'uin reja' re yintz'eteyon rach. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tic'axaj-na-pa' jabal re xtimbij chiva: Re niniman vichin, can c'o-va ruc'aslen chin jumul. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Re vay re niyi'o c'aslen, ja yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Roma re vay re xubini'aj maná, re xquitaj re ivinak xe'c'ue' ajuer can, re xe'k'ax chupan re lugar re anche' manak vinak re nibex desierto cha, man xtiquir-ta xuban chique che xc'ue-ta quic'aslen chin jumul. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Jac'a re katzij vay re kejnak-pa chila' chicaj, nuban chique re ye'tijo richin che man xque'bapon-ta chupan re camic chin jumul. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja yen re vay re niyi'o c'aslen, re xka-pa chila' chicaj. Re xque'tijo re vay re', xque'c'ase' nojel tiempo. Re vay re xtinya' yen chique can ja re nu-cuerpo. Can xtapon-va pa camic chin nuc'am-pa c'aslen chique re vinak re jec'o chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y re kavinak israelitas re', tak xquic'axaj re xubij re Jesús, xquic'utula' chiquivach-ka reje': ¿Andex como re' che reja' nuya' re ru-cuerpo chaka chin nakataj? ye'cha'. Pero re vinak re' xe'jalajo' roma jun-va nubij la jun y jun-va nubij la jun. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y re Jesús xubij chique: Can katzij-va, vo xa man nitaj-ta re nu-cuerpo y man nikum-ta chuka' re nuq'uiq'uel yen re xinalax chi'icojol, re c'aslen chin nojel tiempo can man xtoc-ta ivichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Re can xtiquitaj re nu-cuerpo y xtiquikum chuka' re nuq'uiq'uel, can c'o-va re quic'aslen re man xtiq'uis-ta. Y yen can xtimban chique che xque'c'astaj-a chiquicojol re anama'i' re pa ruq'uisibal k'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Roma re nu-cuerpo yen, jare' re katzij vay, y re nuq'uiq'uel, jare' re katzij ya' re nuc'am-pa c'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Re ye'tijo re nu-cuerpo y ye'kumu chuka' re nuq'uiq'uel, xa jun xtakaban quiq'uin. Reje' xque'c'ue' viq'uin yen y yen quiq'uin reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Roma ja re Nata' re takayom-pa vichin y reja' can c'o-va re c'aslen riq'uin, yen chuka' c'o re c'aslen re' viq'uin. Y quire' chuka' re xquinquic'ul yen, can xque'c'ase-va voma yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Re Jun re katzij vay, ja re kejnak-pa chila' chicaj, y re vay re' can man junan-ta riq'uin re vay re xubini'aj maná re xquitaj re ivinak xe'c'ue' ajuer can, roma re vay re xquitaj reje' man xtiquir-ta xuban chique che xc'ue-ta quic'aslen chin jumul. Jac'a re niquitaj re katzij vay re kejnak-pa chila' chicaj, xtic'ue' quic'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jare' xubij re Jesús chique re kavinak israelitas re quimalon-qui' chupan re nema-jay re nibex sinagoga cha, re c'o chire' pa tenemit Capernaum. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Y re je'tzakatal chij re Jesús, tak quic'axan chic-ka re xubij, je q'uiy chique reje' xquibij: Camas c'ayef che nac'ul re xubij. Man k'alaj-ta vo xa jec'o re xque'niman. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Y tak re Jesús xutz'at re niquinojij pa tak cánma re je'tzakatal chij, reja' xubij chique: ¿Anchique roma tak yex ninojij che c'ayef xtinimax re ximbij? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Xe-ta yinitz'at yen re xinalax chi'icojol che yintzolaj chila' riq'uin re Dios re anche' yimpitinak-va, ¿la yininimaj-ta coma? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Re espíritu jare' re niyi'o c'aslen. Re i-cuerpo xa can man jun rajkalen, roma man nitiquir-ta nuya' c'aslen. Y re Espíritu re niyi'o re katzij c'aslen, ja re ch'abal re je'mbin chic-ka chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero je q'uiy chiva yex re man xquinquinimaj-ta, xcha' re Jesús. Roma reja' can rutaman-va-pa anchique che vinak re man xque'niman-ta, y re anchique xtijacho richin. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y re Jesús xubij: Roma jec'o chiva yex re man xquinquinimaj-ta, mare' tak yen nbin chic chiva che ja re vinak re je'cha'on roma re Nata' Dios, jare' re xque'pa viq'uin chinucanoxic, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Roma quire' xubij re Jesús, camas je q'uiy chique re can que'tzake-va chij, man chic xe'tzake-ta chij. Xa xe'tzolaj can. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y re Jesús xuc'utuj chuka' chaka yoj re yoj doce ru-discípulos: ¿Yex chuka' nijo' yixba? ");
INSERT INTO cakYNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y re Simón Pedro xubij cha re Jesús: Ajaf, man jun chic ancha'l rat chin yojtzake-ta chij, roma re ach'abal rat can nuya' c'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yoj kaniman y kataman che ja rat re Cristo, re Ruc'ajol re c'aslic Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y re Jesús xubij: Man riq'uin re' che can ja yen re xincha'o ivichin yex re yix doce, can c'o jun re itzel xel chi'icojol, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tak re Jesús xubij-ka quire', xa chij re Judas Iscariote xch'o-va, re Judas re ruc'ajol re jun ache rubini'an Simón. Re Jesús xunataj re jun re', roma jare' re xtic'ayin richin. Y reja' jun c'a chaka yoj re yoj doce ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Y tak xe'banataj-yan ronojel re', re Jesús xba pa tak tenemit re jec'o pa Galilea. Man c'a rujovan-ta binak tzijoy ruch'abal re Dios pa Judea, roma re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, niquicanola' andex xtiquiban chin niquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Y roma ne'ka-yan jun chique re kanamak'ij yoj re yoj israelitas, namak'ij chin nakanataj re tiempo re xquik'asaj re kavinak ajuer can chupan re lugar re anche' manak vinak re nibex desierto cha, ");
INSERT INTO cakYNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","mare' re ruch'alal re Jesús xquibij cha: Taya' can re Galilea y cabiyin pa Judea, chin quire' re vinak re can yatquiniman-va y ye'tzake' chavij re jec'o chire', tiquitz'eta' re asamaj. Tiquitz'eta' re milagros re ya'banala'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Roma anchique re nrajo' nuc'ut-ri' chiquivach re vinak, man ruc'amon-ta che nuvovaj-ri'. Can nic'atzin che nuc'ut-ri' che can c'o-va re nitiquir nuban, xe'cha' re ruch'alal cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Reje' quire' xquibij roma can man niquinimaj-ta re Jesús, astapa' can quich'alal-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y c'are' re Jesús xubij chique: Yex xabanchique k'ij otz yixapon chupan re namak'ij. Jac'a yen man quire-ta. Yen c'amaje-na otz chin che yinapon. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Yex xa man itzel-ta yixtz'et coma re vinak re man quiniman-ta re Dios. Jac'a yen can yinquitzelaj-va. Yinquitzelaj roma yen can ninlisaj pa sakil re itzel tak quibanabal re ye'quibanala'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quixbiyin iyon yex. Yen xa c'amaje-na yimba-a pa namak'ij. Re hora chin che ninc'ut-vi', c'amaje-na tapon, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y tak re Jesús rubin chic ronojel re' chique re ruch'alal, reja' can xc'ue-va can chire' pa Galilea. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y tak je'binak chic re ruch'alal pa namak'ij, c'are' xba reja'. Pero pan eval xba. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jac'a re pa namak'ij, re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, ye'xule-ye'jote' chucanoxic re Jesús y niquibila': ¿Anche' como c'o-va re jun ache re'? ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicojol re vinak chupan re namak'ij re', q'uiy re nibilox chij re Jesús. Jec'o niquibij che re Jesús, jun utzulaj ache. Jec'o re man quire-ta chiquivach, xa niquibila' che re Jesús xa ye'ruk'ol re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero man jun chique re vinak re ye'bin quire' nipa'e-ta-pa y nich'o-ta chij re Jesús, roma niquixibij-qui' chiquivach re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y jac'a tak binak pa nic'aj re namak'ij, jare' tak re Jesús xapon pa rachoch re Dios re c'o chire' pa tenemit Jerusalén, anche' ntajin-va re namak'ij. Y reja' nutzijoj re ruch'abal re Dios chiquivach re vinak re quimalon-qui' chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mare' re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, niquibij chij re Jesús: ¿Anchique roma re ache re' camas rutaman chij re ruch'abal re Dios y xa man jun bey xkatz'at-ta che ntajin-ta ruc'utic chach? ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero re Jesús xubij: Re enseñanza re ninc'ut yen man vichin-ta yen, xa chin re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y re vinak re nurayij nuban re nrajo' re Dios, can xtuya' cuenta cha re enseñanza ninc'ut yen, vo xa riq'uin re Dios pitinak-va o xa nayon yen re yintz'ucuyun-ka. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Anchique vinak rion reja' nutz'uc-ka re enseñanza nuc'ut, can nrajo' che re vinak niquiya' ruk'ij. Jac'a yen ninjo' che yex niya' ruk'ij re Dios re takayom-pa vichin. Y mare' nik'alajin che yen ja re katzij nimban y man jun bey nimban re man otz-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Yex nicanoj andex rubanic niban chin yiniquimisaj. Xa man niban-ta re andex nubij re ley chin re Moisés, y re ley re' xa pan ik'a' c'o-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y re vinak xquibij: Xa xach'ujer. ¿Anchique re nijovan niquimisan avichin? ");
INSERT INTO cakYNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero re Jesús xubij chique: Yex can anchique-la xuna' re ivánma tak xitz'at che yen pa jun k'ij chin uxlanen xinc'achojsaj re jun ache. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Y re Moisés tak xuya' re ley xubij che tiban re circuncisión. Pero xa mana-ta reja' re xtz'ucu-pa, xa ja re kavinak xe'c'ue' ajuer can re xe'tz'ucu-pa. Y mare' yex, tak napon re vakxaki' k'ij talax-va jun ac'ual ala', astapa' pa jun k'ij chin uxlanen, can niban-va re circuncisión cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yex nibij che can nijo' niban ronojel re nubij chupan re ley re ruyi'on can re Moisés, y mare' astapa' pa jun k'ij chin uxlanen yex can niban-va re circuncisión, y re' samaj chuka'. Y vo xa quire' niban, ¿anchique roma xpa iyoval chua yen roma xinc'achojsaj jun ache chupan jun k'ij chin uxlanen? ");
INSERT INTO cakYNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man tibij che man otz-ta re nubanabal, roma quire' nik'alajin chivach yex. Xa can titamaj jabal vo xa quire' o man quire-ta, chin quire' man quixsatz, xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y jec'o chique re vinak aj-chire' pa tenemit Jerusalén re niquibila': Jare' re Jesús re nicanox chin niquimisas. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Reja' man ruvovan-ta-ri'. Titzu' la', reja' nich'o chiquivach la vinak y man jun nibin cha che man chic tuban quila. Q'uiba' re achi'a' re c'o quik'ij re jec'o chakacojol xa xquitz'at-yan che can ja-va reja' re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero can nik'alajin che xa mana-ta reja' re Cristo, roma xa can kataman anche' tipo-va. Y tak xte'ka re can katzij-va Cristo, xa man xtik'alajin-ta anche' xtipo-va, ye'cha' re vinak aj-Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y re Jesús nich'o chiquivach re vinak chire' pa rachoch re Dios. Y jun pa ruchi' xch'o y xubij: Yex can itaman-va noch y itaman chuka' anche' quimpo-va. Jac'a re takayom-pa vichin man itaman-ta rach, y reja' can katzij. Man c'a nayon-ta yen ximbano-ka che ximpa chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yen can ntaman-va rach re man itaman-ta rach yex, roma riq'uin reja' yimpitinak-va, y ja chuka' reja' re takayom-pa vichin, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y can jec'o re xe'jovan che xquitz'am-ta-a, pero man xquitz'am-ta-a, roma re hora chin re Jesús c'amaje-na tapon. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Y camas je q'uiy chique re vinak re xe'niman chin re Jesús chupan re k'ij re'. Re vinak re' niquibij che ja reja' re Cristo, roma re milagros man jun chic nitiquir nibano. Xa can xe-va re Cristo re nitiquir nibano quire', xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y re achi'a' fariseos xquic'axaj che quire' re ye'quibila' re vinak chij re Jesús. Mare' re achi'a' fariseos y re principal tak sacerdotes, xe'quitak-a policías chin ne'quitz'ama' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jare' tak xubij re Jesús: C'a c'o chic ba' tiempo re yinc'ue-a iviq'uin. C'are' xquintzolaj riq'uin re anchique takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yex xquinicanoj, y man xquinivel-ta chic, roma re lugar re anche' xquinec'ue-va yen, man xquixtiquir-ta xquixapon chinucanoxic, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas niquibila' chiquivach: ¿Anche' como xtibo-va re Jesús re'? Roma nubij che man xtakavel-ta chic. ¿Niba como quiq'uin re kavinak israelitas re jec'o nic'aj chic lugares, o q'uiba' quiq'uin re man je israelitas-ta, chin nutzijoj re ruch'abal chique? ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Man kataman-ta anche' xtibo-va, roma man kataman-ta andex ne'c'ulun-va che tzij re xubij: Xquinicanoj y man xquinivel-ta. Re lugar re anche' xquinec'ue-va, man xquixtiquir-ta xquixapon yex, ye'cha' chiquivach reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Re ruq'uisibal k'ij chin re namak'ij ja k'ij re' re c'o más rajkalen. Jare' tak re Jesús xyacataj y jun pa ruchi' tak xubij: Vo xa c'o jun re nichake'j ruchi', tipa viq'uin yen, chin nich'uch'o-a ránma riq'uin re ya' re xtinya-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Re xtipa viq'uin chin yinrunimaj, can xtic'ue' re ya' chin c'aslen pa ránma, y re ya' re' can ancha'l nuban re ya' anche' nalax-va, quire' xtuban pa ruc'aslen. Quire' re nubij chupan re ruch'abal re Dios re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Re ya' re xunataj re Jesús, ja re Espíritu Santo, roma jare' re xtiquic'ul re vinak re ye'niman chin re Jesús. Y re Espíritu Santo c'amaje-na tika-pa, roma c'amaje-na chuka' titzolaj-a re Jesús chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y jec'o chique re vinak, tak xquic'axaj-ka re tzij re xe'rubij re Jesús, xquibij: Can katzij-va che re Jesús jare' re jun rusamajel re Dios re nibex profeta cha, y q'uiy-yan tiempo yabem-pa. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y jec'o chuka' nic'aj chic niquibij: Jare' re Cristo re bin che nitak-pa roma re Dios. Pero jec'o nic'aj chic niquibij: Re Cristo man aj pa Galilea-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Roma re ruch'abal re Dios re tz'iban can nubij che re Cristo rey-rumam re Rey David. Y chire' pa tenemit Belén re anche' xalax-va re David, chire' tiene que nipo-va re Cristo, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Can man junan-ta re niquinojij chij re Cristo, roma jun-va nubij la jun y jun-va nubij la jun. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y jec'o chique re vinak re xquijo' che xquitz'am-ta-a re Jesús, pero xa man xquiban-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Jac'a tak xe'tzolaj-pa re policías re je'takon-a coma re principal tak sacerdotes y coma re achi'a' fariseos, xc'utux chique: ¿Anchique roma tak man xitz'am-ta-pa re Jesús? ");
INSERT INTO cakYNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pero re policías xquibij: Yoj man xkatz'am-ta-pa, roma re tzij re ye'rubij re ache re', can man jun ache re quire-ta biyon, roma rion utzulaj tak tzij re ye'rubila', xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","C'are' re achi'a' fariseos xquibij chique re policías: ¿Yex chuka' xixk'olotaj-pa? ");
INSERT INTO cakYNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acaso jec'o chique re ka-jefes y fariseos re quiniman-ta reja' ye'tz'at yex? ");
INSERT INTO cakYNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ja re vinak re man jun quitaman chij re ley re ruyi'on can re Moisés, xa jare' re ye'niman richin. Ja-ta c'a re castigo re xtika pa quive' re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero re Nicodemo re ache re chak'a' xapon riq'uin re Jesús, xubij chique re ruchibil: ");
INSERT INTO cakYNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Re ka-ley nubij che man yojtiquir-ta nakaban juzgar jun vinak, vo xa man kayi'on-ta k'ij cha che nubij vo xa katzij je'rubanalon mac o man katzij-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y reje' xquibij cha re Nicodemo: Rat man yat aj-Galilea-ta chin quire' nato' re Jesús. Tanic'oj-na-pa' jabal re ruch'abal re Dios re tz'iban can. Chire' nik'alajin-va che re pa Galilea man nipa-ta jun rusamajel re Dios re nibex profeta cha, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Y c'are' re achi'a' re quimalon-qui', cada jun xe'ba cho tak cachoch. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Re Jesús xba-apo chach re loma rubini'an Olivos. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y namak'a-yan ruca'n k'ij, reja' xapon chic pa rachoch re Dios. Y re vinak xe'bapon riq'uin. Y reja' tz'uyul tak nubij re ruch'abal re Dios chique re quimalon-apo-qui' chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y re achi'a' fariseos y re achi'a' je'atamayon re ley kachin yoj re yoj israelitas xe'bapon riq'uin re Jesús, quic'uan-apo jun ixok re nimacun riq'uin jun ache xbelitaj-pa. Xbequipoba' chach re Jesús, pa quinic'ajal. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Re fariseos y re achi'a' je'atamayon re ley, xquibij cha re Jesús: Maestro, xe'cha'. Re jun ixok re kapoban chavach, nimacun riq'uin jun ache xbelitaj-pa. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chupan re ley ruyi'on can re Moisés, nubij che re ye'bano quire', que'quimisas cha aboj. ¿Andex nabij rat? ¿Otz o man otz-ta nakaquimisaj cha aboj re jun ixok re'? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Re achi'a' re' quire' xquibij xaxe chin niquitojtobej re Jesús, chin quire' ye'tiquir ye'sujun chij. Pero re Jesús xa xluque-ka pan ulef, y xtz'iban-ka riq'uin re rue-ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y roma re achi'a' re' can ye'chaca-apo chin niquic'utuj cha re Jesús, vo xa niquimisas o man niquimisas-ta re ixok re', reja' xpa'e' y xubij: Re man jun bey kejnak pa jun mac quire', tutz'ama' ruq'uiekic re ixok cha aboj, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y re Jesús xluque' chic-ka jun bey pan ulef y xtz'iban chic-ka riq'uin re rue-ruk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tak reje' xquic'axaj re xubij re Jesús, re cánma xubij chique che reje' chuka' je aj-maqui', y che ja'jun che ja'jun xe'el-a chire'. Xe'nabayaj-a re rejeta'k tak achi'a', y c'are' xe'ba re nic'aj chic. Xa can xe chic c'a re ixok xc'ue' can chach re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y tak re Jesús xpa'e' chic, xutz'at che xaxe chic re ixok c'o can chire'. Mare' xuc'utuj cha re ixok re': ¿Y re vinak re je'c'amayom-pa avichin? ¿Man jun xc'ue-ka chin yatruquimisaj? xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y re ixok re' xubij: Ajaf, man jun chic c'o, xcha'. Y re Jesús xubij cha: Yen chuka' man nimbij-ta che yaquimisas. Vocame catzolaj y man chic camacun. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tak re Jesús xch'o chic jun bey chiquivach re vinak, xubij: Ja yen re sakil quichin conojel re vinak re jec'o chach re ruch'ulef. Re nitzekelben vichin, can xtic'ue' re sakil riq'uin y xtuvel ruc'aslen viq'uin. Y reja' man chic xtibiyin-ta pa k'oko'm. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","C'are' re achi'a' fariseos re jec'o chire', xquibij-apo cha re Jesús: Yoj man nakanimaj-ta che katzij re nabij, roma xa ja rat mismo re otz yach'o-ka chavij. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero re Jesús xubij chique re achi'a' fariseos: Astapa' ja yen mismo re otz yinch'o-ka chuij, pero can katzij-va re nimbij-ka chuij. Roma yen can ntaman-va anche' yimpitinak-va, y chire' chuka' xquintzolaj-va. Jac'a yex man itaman-ta anche' quimpo-va, y man itaman-ta chuka' anche' xquimbo-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yex xa jac'a re nitz'at chij jun vinak re niban juzgar. Jac'a yen man quire-ta nimban. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y vo xa yen nimban juzgar, can pa rubiyal-va nimban, roma can man nayon-ta yen, xa can vichibil-va re Nata' re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan re i-ley nubij che tak jec'o je ca'e' vinak re can junan niquibij, nik'alajin che katzij re niquibij. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Y chuij yen mismo ninya-va-ka testigo y re Nata' re xtako-pa vichin jare' re jun chic testigo, mare' k'alaj che katzij re nimbij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Re achi'a' fariseos xquibij cha re Jesús: ¿Anche' c'o-va re Arta'? Y re Jesús xubij: Yex man itaman-ta rach re Nata', roma man itaman-ta noch yen. Xe-ta itaman noch yen, can itaman-ta chuka' rach re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y jac'a tzij re' xe'rubij re Jesús chique re vinak re quimalon-qui' re anche' ne'yalox-va can mero coma re vinak chire' pa rachoch re Dios. Y man riq'uin re' che xe'rubila' ronojel re tzij re', man jun re xpa-ta chutz'amic, roma re ru-hora c'amaje-na tapon. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y re Jesús xubij chic jun bey chique: Yen can xquintzolaj-va, y jare' tak yex xquinicanoj, pero man xquinivel-ta. Xa can chupan re imac xquixcom-va. Y re anche' yimbo-va yen, yex man yixtiquir-ta yixapon, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, niquibila' chiquivach: ¿Xtuquimisaj como-ri' re Jesús? Roma nubij: Re anche' xquimbo-va yen, yex man yixtiquir-ta yixapon. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero re Jesús xubij chique: Yex can yix aj-vova' chach re ruch'ulef y yen yin aj-chila' chicaj. Can yix richin-va re ruch'ulef y yen man quire-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y mare' ximbij chiva che chupan re imac yixcom-va. Y vo xa man ninimaj-ta yin anchique yen, can xquixcom-va chupan re imac, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","C'are' re achi'a' re' xquibij chic cha re Jesús: ¿Yat anchique c'a rat c'a? Y re Jesús xubij chique: Yen can ja tak ntz'amom-pa tzij iviq'uin, jare' tak nbim-pa chiva re yin anchique yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Q'uiy re nimbij chivij, roma re itzel ibanabal. Pero re nimbij chiva yex y chique conojel vinak, xaxe re nc'axam-pa riq'uin re takayom-pa vichin, y reja' ja re katzij nubij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero reje' man xk'ax-ta pa quive' re xbex chique roma re Jesús, mare' man xquinabej-ta che chij re Dios re Rutota' reja' xch'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Re Jesús nubij chuka': Re k'ij tak xquinijotoba' cho cruz yen re xinalax chi'icojol, c'ajare' tak xtitamaj yin anchique yen. Y xtitamaj chuka' che ronojel re nimban yen, xa man nayon-ta yen yinojin-ka. Xa can ancha'l re rubim-pa re Nata' chua, can quire' chuka' nimbij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Re Nata' re takayom-pa vichin, can c'o viq'uin. Man yinruya-ta can nayon, roma yen can nimban-va re nika chach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y roma re tzij re xe'rubij-ka re Jesús chiquivach re vinak, je q'uiy re xe'niman richin. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'are' re Jesús xubij chique re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas re xe'niman richin: Vo xa yex jabal ruc'uaxic niban cha re nuch'abal, can xquixoc katzij tak nu-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xtitamaj chuka' anchique re katzij y re katzij ja yen, y re katzij xtuban chiva che yixel libres. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y re nic'aj chic re man quiniman-ta xquibij: ¿Anchique roma tak nabij che xkojel libres? Roma re kamoma' Abraham can libre-va, y yoj, yoj rey-rumam can reja', man yoj ancha'l-ta re esclavos, sino can yoj libre-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero re Jesús xubij chique: Tic'axaj-na-pa' jabal re xtimbij chiva vocame: Conojel vinak re ye'macun, can nik'alajin che chuxe' rutzij re mac jec'o-va y jare' re ac'ayon quichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y re vinak xa chuxe' rutzij re mac c'o-va, man xtic'ue-ta riq'uin re Dios. Jac'a re jun re can rajc'ual-va re Dios, can xtic'ue-va riq'uin jumul. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Mare' vo xa yen re Ruc'ajol re Dios yincola ivichin, can katzij-va xquixel libres. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Y chinoch yen, re nibij yex che yix rey-rumam can re Abraham, can quire-va, xa jac'a re ibanabal man nuc'ut-ta che quire', roma yex xa nicanola' andex niban chin yiniquimisaj. Re' nuc'ut che yex man iyi'on-ta k'ij cha re nuch'abal che aconak-ta pa tak ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ronojel re nintzijoj yen, ja re Nata' c'utuyum-pa chinoch. Y quire' chuka' yex, re nic'axaj riq'uin re jun aconak irta', jare' re yixtajin chubanic. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y reje' xquibij cha re Jesús: Re Abraham jare' re karta' yoj, xe'cha'. Y re Jesús xubij chique: Xe-ta ja re Abraham re irta', nik'alajin-ta, roma ja-ta re otz tak banabal re xe'rubanala' reja', ja-ta chuka' re' re ye'banala' yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero yex man quire-ta niban. Yex xa nicanoj andex niban chin yiniquimisaj yen re nintzijoj re katzij chiva, katzij re nc'axam-pa riq'uin re Dios. Re Abraham man xuban-ta ancha'l re niban yex, y yex nibij irta' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yex can jac'a re nuban re jun aconak irta', xa jare' niban, xcha' re Jesús chique. Y reje' xquibij cha: Yoj can xe c'a jun Karta', y re' ja re Dios y kataman che can xe reja' y man jun chic, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","C'are' re Jesús xubij chique re vinak: Xe-ta ja re Dios re Irta', can k'alaj-ta, roma camas-ta yinijo' y yinic'ul-ta, roma yen can riq'uin re Dios yimpitinak-va. Roma can ja-va re Dios re takayom-pa vichin y man nayon-ta yen xinojim-pa che ximpa chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Anchique roma tak yex man nijo-ta che nak'ax pan ive' re nimbij chiva? Xa roma man nika-ta chivach. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Re irta' yex xa ja re itzel y can yix richin reja', y ja re nika chach reja', jare' re yixtajin chubanic. Roma re itzel can antes je'rubanalom-pa camic. Man xc'ue-ta chic chupan re katzij, roma can nutzelaj re katzij. Xa can jun aj-tz'ucuy-tzij y ja reja' re quirta' conojel re ye'tz'ucu tzij. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y yen man yininimaj-ta roma ja re katzij re nimbij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿C'o como jun re nibim-pa chua vocame andex che mac je'mbanalon? Y vo xa jabal nik'alajin che man jun mac pa nuc'aslen y can rion katzij re nimbij, ¿anchique roma tak man yininimaj-ta? ");
INSERT INTO cakYNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Roma re can richin chic re Dios, can ja re nubij re ruch'abal re Dios re nuban. Jac'a yex man quire-ta niban, roma man yix richin-ta re Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, xquibij cha re Jesús: Can katzij-va re kabin chavij che rat xa yat jun vinak re yatpitinak pa Samaria y c'o itzel espíritu aviq'uin, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero re Jesús xubij chique re achi'a' re': Yen man jun itzel espíritu c'o viq'uin. Yen can ja re Nata' re ninya' ruk'ij, y yex xa man quire-ta chivach. Yex xa niban chua che yen yin itzel. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yen man nuk'ij-ta re nincanoj chi'icojol, pero c'o c'a Jun re nijovan che conojel vinak niquiya-ta nuk'ij. Y jac'a chuka' reja' re xtibano juzgar quichin re man xtiquiban-ta quire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can tic'axaj-na-pa' jabal re xtimbij chiva: Anchique vinak re nunimaj re nuch'abal, man xtutz'at-ta re camic chin jumul, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas xquibij cha re Jesús: Vocame can kataman chic che can c'o-va itzel espíritu aviq'uin, roma nabij che anchique re ye'niman re ach'abal, man xque'com-ta. Tatz'eta-na-pa' re karta' Abraham y re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, xe'com. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Más como c'o ak'ij rat que chach re karta' Abraham? Reja' xcom, y quire' chuka' re rusamajela' re Dios re xe'c'ue' ajuer can, re xbex profetas chique, xe'com. ¿Yat anchique c'a rat c'a? Roma nabij che re ye'niman re ach'abal man xque'com-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y re Jesús xubij: Vo xa nayon yen ninya' nuk'ij, xa man jun nic'atzin-va. Pero re nuk'ij yen, can ja re Nata' niyi'o. Re Nata' jare' re nibij i-Dios cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y astapa' yex quire' nibij cha, pero man itaman-ta rach. Jac'a yen can ntaman-va rach. Y yinoc jun aj-tz'ucuy-tzij ancha'l yex, xe-ta nimbij che man ntaman-ta rach re Dios. Pero yen can ntaman-va rach re Dios y can nimban-va re nubij re ruch'abal reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Re Abraham camas xqui'cot ránma, roma nrajo' xtutz'at re k'ij tak xquimpa chach re ruch'ulef. Y reja' can xutz'at-va can, y camas xqui'cot ránma roma re', xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas xquibij cha re Jesús: Rat nabij che atz'eton chic re karta' Abraham, pero rat xa c'a yat ac'ual. Xa c'amaje-na titz'akater nic'aj ciento ajuna'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero re Jesús xubij chique re achi'a' re': Can katzij nimbij chiva che yen can yinc'o-va-pa, tak c'amaje-na rutzijol che nalax re Abraham, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y re achi'a' re' can jare' xbequisiq'uila-pa aboj chin niquiq'uiak re Jesús. Pero re Jesús xel-pa chire' pa rachoch re Dios. Xrevala-pa-ri' chiquicojol re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Re Jesús nak'ax anche' c'o-va jun ache re can moy-va tak xalax. Re Jesús xutz'at re ache re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y yoj re yoj ru-discípulos xkac'utuj cha re Jesús: Maestro, ¿anchique como xmacun, mare' quire' xalax re ache re'? ¿Ja re rute-rutota' o ja reja'? ");
INSERT INTO cakYNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero re Jesús xubij: Man jun chique reje' c'o-ta rumac, chin quire' xuc'alvachij re ache re'. Ni xe-ta reja', ni xe-ta re rute-rutota'. Reja' can moy-va tak xalax, chin che nik'alajin re ru-poder re Dios riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pak'ij, can otz-va che niban samaj. Jac'a tak ndoc-pa re ak'a', conojel man otz-ta chic ye'samaj. Y quire' chuka' yen, vocame nic'atzin chin nimban re samaj re bim-pa chua roma re takayom-pa vichin, roma tak man xquinc'ue-ta chic, man chic xquintiquir-ta xtimban re samaj re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Y re k'ij re c'a yinc'o-na chach re ruch'ulef, jac'a yen re yinsekresan quic'aslen conojel vinak, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tak re Jesús je'rubin chic-ka re ch'abal re', reja' xchuban-ka pan ulef. Y riq'uin re ruchub re xka pan ulef, xuban ba' ch'abak. C'are' re ch'abak re' xuquil-a chuchi' tak nak'arach re ache moy. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xubij cha: Vocame cabiyin, y ta'ch'aja' re anak'avach pa jun ya' rubini'an Siloé. Re be'aj Siloé ndel che tzij, Takom-pa. Re ache re' can xbo-va, xe'ruch'aj re nak'arach, y tak xtzolaj-pa, nitzu'un chic. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","C'are' re vinak re je ru-vecinos re ache re' y re nic'aj chic vinak re can je'tz'eteyon-va che moy, niquibila': Ja ache re' re nic'utun limosna re katz'etom-pa, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Y jec'o vinak re ye'bin: Ja', ja reja'. Nic'aj chic niquibij: Junan titzu'un riq'uin re ache re', pero mana-ta reja'. Pero re ache nubij: Ja'. Ja yen re quintz'uye' chin ninc'utuj limosna chique re vinak, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y re vinak niquic'utuj cha re ache re': ¿Ancha'l c'a tak yatzu'un chic? ¿Andex xban chava chin che yatzu'un chic vocame? xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Re ache xubij chique: Re jun ache rubini'an Jesús xuban ba' ch'abak y jare' re xuquil chuchi' tak nuk'onach, y c'are' xubij chua: Cabiyin y ta'ch'aja' re anak'avach pa Siloé. Y yen can ximbo-va chuch'ajic re nuk'onach y can jare' tak xintzu'un. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero re vinak xquic'utuj cha: ¿Anche' c'a c'o-va re Jesús vocame? xe'cha'. Y reja' xubij chique: Man ntaman-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y re vinak xquic'uaj-a re ache moy rubanon can chiquivach re achi'a' fariseos. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Pero tak re Jesús xuban re ba' ch'abak y xuban cha re ache moy che nitzu'un, xa chupan jun k'ij chin uxlanen. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Tak re ache moy rubanon can c'o chic-apo chiquivach re achi'a' fariseos, re achi'a' re' xquic'utuj cha: ¿Ancha'l tak yatzu'un chic vocame? Y reja' xubij: Re xbano chua chin yintzu'un chic vocame, xuquil ba' ch'abak chuchi' tak nuk'onach, y xinch'aj, y ja xintzu'un, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y jec'o achi'a' fariseos re xquibij: Re ache re rubini'an Jesús man riq'uin-ta re Dios pitinak-va, roma can man nuchajij-ta re k'ij chin uxlanen, ye'cha'. Pero jec'o nic'aj chic fariseos re xquibij: Jun ache aj-mac man nitiquir-ta ye'ruban milagros, ancha'l xuban re Jesús riq'uin re ache moy. Re achi'a' fariseos man junan-ta re niquinojij chij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","C'are' re achi'a' fariseos xquic'utuj cha re ache, re moy rubanon can: ¿Anchique che ache re Jesús nanojij rat re xbano chava che yatzu'un? Y re ache re' xubij: Yen ninojij che re Jesús jun rusamajel re Dios re nibex profeta cha, xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Jac'a re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, man niquinimaj-ta che re ache re' can moy-va tak xalax. Mare' man niquinimaj-ta che jun milagro re xban che nitzu'un vocame. C'a xe'cayoj-na re rute-rutota' re ache re nitzu'un chic vocame. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y re achi'a' re' xquic'utuj chique re rute-rutota' re ache: ¿Ja ivajc'ual re', re nibij che can moy-va tak xalax? Vo xa can moy-va tak xalax, ¿anchique roma tak nitzu'un vocame? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y re rute-rutota' re ache xquibij chique re achi'a' re': Ja', ja kajc'ual re' re can moy-va tak xalax. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Jac'a re man kataman-ta yoj, ja re andex xuban che nitzu'un chic vocame. Y vo xa c'o jun re xbano cha chin nitzu'un chic vocame, re' man kataman-ta yoj. Tic'utuj cha reja', roma reja' xa nema-vinak chic, y nitiquir nubij chiva re andex xbanataj, xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quire' xquibij re rute-rutota' re ache chique re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, roma quixibin-qui' chiquivach. Re achi'a' re c'o quik'ij, can quilisan chic rutzijol che xabanchique vinak re xtibin che re Jesús jare' re Cristo re bin che nitak-pa roma re Dios, can nikotax-pa chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xa roma re' tak re rute-rutota' re ache re nitzu'un chic, xaxe xquibij che tiquic'utuj cha reja' roma xa nema-vinak chic. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y re achi'a' re' xcayoj chic jun bey re ache re man moy-ta chic, y xquibij cha: Cha re Dios tatioxij-va. Yoj kataman che re ache rubini'an Jesús, jun ache aj-mac, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y re ache xubij chique re achi'a' re': Yen man ntaman-ta vo xa re Jesús aj-mac o man aj-mac-ta. Re ntaman yen chij reja', ja che xinruc'achojsaj, roma tak rubanon can man yintzu'un-ta, y vocame yintzu'un chic, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y re achi'a' re' xquic'utuj chic cha re ache: ¿Andex re xe'ruban chava chin quire' xatiquir xatzu'un? ");
INSERT INTO cakYNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Reja' xubij chique re achi'a' re': Pero re' xintzijoj-yan chiva y xa man xinic'axaj-ta. ¿Anchique roma tak yex nijo' che yen nincamaluj chic rubixic chiva? ¿Nijo' nitzekelbej re Jesús? xcha' chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero re achi'a' re' xyacataj quiyoval y xquibij: Ja rat sí can atzekelben-va reja', jac'a yoj can yoj tzekelbey chin re Moisés. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Yoj can kataman-va che re Dios can xch'o-va riq'uin re Moisés, jac'a re Jesús re' man kataman-ta anche' tipo-va, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y re ache xch'o-apo y xubij chique: Yen camas ninojij re nibij yex, roma nibij che man itaman-ta anche' tipo-va y nibij che q'uiy itaman chij re ruch'abal re Dios, ¿y aroma reja' xtiquir xuban jun milagro viq'uin y yintzu'un chic? ");
INSERT INTO cakYNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Can nik'alajin c'a che re Jesús man aj-mac-ta, roma kataman che re Dios man nuban-ta re niquic'utuj re aj-maqui' cha. Pero re jun re can nuya-va ruk'ij re Dios y nuban chuka' re nrajo' reja', can nic'axax-va roma re Dios, y niya' cha re nuc'utuj. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Man jun bey tz'eton o c'axan-ta che c'o-ta jun re nibano cha jun vinak re can moy-va tak xalax che nitzu'un-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y xe-ta re ache rubini'an Jesús man-ta riq'uin re Dios pitinak-va, man-ta xtiquir xuban re milagro viq'uin yen, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero re achi'a' re' xquibij cha re ache re nitzu'un chic: Rat can yat aj-mac-va tak xatalax, ¿y najo' yojatijoj yoj? xe'cha'. Y xquilisaj-pa re ache re', chire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Re Jesús xuc'axaj che re ache re' xlisas-pa. Mare' xbo'rcanoj, y tak xuvel, xubij cha: ¿Nanimaj como rat re Ruc'ajol re Dios? xcha' re Jesús cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y re ache re nitzu'un chic xubij cha re Jesús: Yen ninjo' ninimaj re Ruc'ajol re Dios, xa ja re man ntaman-ta anchique reja'. Tabij chua, xcha' re ache. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y re Jesús xubij cha: Rat can atz'eton chic re Ruc'ajol re Dios. Jac'a yen re yinch'o aviq'uin, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Re ache can jare' xubij: Ajaf, yen yatinimaj. Y re ache can xuya' ruk'ij re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y re Jesús xubij: Yen ximpa chach re ruch'ulef chiquitz'etic re vinak andex quibanon, vo xa otz o man otz-ta. Y re vinak re man ye'tzu'un-ta espiritualmente, xtimban chique che xque'tzu'un. Jac'a re niquina' che ye'tzu'un espiritualmente, xa man chic xque'tzu'un-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Y jec'o achi'a' fariseos re jec'o-apo chire' anche' c'o-va re Jesús, tak xquic'axaj re', xquibij: ¿Acaso yoj moyi' chuka' yoj? ");
INSERT INTO cakYNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y re Jesús xubij chique: Xe-ta yix moyi', jabal-ta, roma manak-ta imac. Xa roma yex nibij che man yix moyi-ta, mare' tak can c'o-va imac. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Y tic'axaj jabal re xtimbij chiva: Re qui-corral re ovejas can c'o jun ruchi'. Y re man nicusan-ta re ruchi' re corral chin ndoc-apo y xa niropin pa rue' re corral, re nibano quire' xa jun elek'om. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jac'a re nicusan re ruchi' re corral chin ndoc-apo, can ja-va re' re chajinel quichin re ovejas. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y re nichajin re ruchi' re corral nujak-pa chach re chajinel quichin re ovejas, y re ovejas can quitaman chic re ruch'abal re quichajinel. Reja' ye'rayoj che ja'jun riq'uin quibe' y ye'rulisaj-a. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tak re chajinel je'rulisan chic-a conojel re ru-ovejas, ninabayaj-a chiquivach y re ovejas ye'tzake-a chij. Re ovejas can quire-va niquiban, roma can quitaman ruch'abal re nichajin quichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Jac'a re man quitaman-ta rach, man xtiquitzekelbej-ta. Xa ye'numaj chach, roma man quitaman-ta ruch'abal, ch'abal re man jun bey quic'axan. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ja ejemplo re' re xubij re Jesús chique re achi'a' fariseos, xa jac'a reje' man xk'ax-ta pa quive' andex re xrajo' xubij chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","C'are' re Jesús xch'o chic jun bey y xubij chique re achi'a' fariseos: Tic'axaj jabal re xtimbij chiva: Ja yen re ruchi' re corral re anche' ye'oc-va-apo re ovejas. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Y je q'uiy re xe'c'ue-yan nabey que chinoch yen y xquibij che je'takom-pa roma re Dios, pero xa man quire-ta, xa je junan quiq'uin re elek'oma'. Matiox che man xe'tzekelbes-ta coma re ovejas re je vichin yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja yen re ruchi' re corral. Re xtoc viq'uin yen, can xticolotaj y nuvel ronojel re ndoc cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jun elek'om tak napon, can xe chin no'rbana-pa elak' y ne'quimisan can. Can ronojel re nuban can, man pa rubiyal-ta. Jac'a yen, nicha' re Jesús, ximpa chin ninya' re c'ac'a c'aslen, jun c'aslen camas otz. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Y jac'a yen re utzulaj Chajinel. Re utzulaj Chajinel can nuya-va ruc'aslen coma re ru-ovejas. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jac'a re xa man katzij-ta chajinel, re nichajin roma tajon y chuka' man rajaf-ta re ovejas, re' tak nutz'at che nipa re utif, xa ja reja' re ninumaj-a nabey y ye'rumalij can re ovejas re ye'ruchajij. Y re utif ye'ruc'uaj-a re ovejas, y re nic'aj chic niquitaluj-a-qui'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Re man katzij-ta chajinel, re xa tajon, ninumaj. Y quire' nuban roma xa mana-ta reja' cajaf re ovejas. Man jun pena cha reja' vo xa c'o niquic'alvachij re ovejas. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Jac'a yen re utzulaj Chajinel, y ntaman quivach re ovejas re can je vichin yen, y reje' can quitaman chuka' noch yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Can quire' chuka' nbanon yen riq'uin re Nata'. Reja' rutaman noch yen, y yen ntaman rach reja'. Yen ninya' nuc'aslen coma re nu-ovejas. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y yen man xe-ta re' re nu-ovejas jec'o, xa can jec'o chuka' nic'aj chic re man jec'o-ta vova' chupan re jun corral re'. Y yen can xque'nc'am-pa y xtiquic'axaj chuka' re nuch'abal. Y ja yen xquinchajin quichin conojel y xa jun c'a xtiquiban. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Re Nata' Dios can yinrajo-va. Can nika chach che yen ninya' re nuc'aslen coma re nu-ovejas, y chuka' roma nic'ue' chic-a nuc'aslen jun bey, ");
INSERT INTO cakYNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","roma re nuc'aslen yen, can man jun xtilisan, xa c'aja-na yen re yinyi'o. Can pa nuk'a' yen c'o-va chin che ninya' y pa nuk'a' chuka' yen c'o-va chin che nic'ue' chic-a nuc'aslen jun bey. Quire' rubim-pa re Nata' chua, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas, man junan-ta xquinojij chij re ch'abal re xe'rubij re Jesús, y jare' tak xquiban chic jun bey che man junan-ta quivach. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Je q'uiy chique reje' xquibij chij re Jesús: Xa xch'ujer. Xa itzel espíritu re c'o riq'uin, y yex can ninimaj-ka re nubij. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Jac'a re nic'aj chic xquibij: Jun re c'o itzel espíritu riq'uin, man nitiquir-ta nubij utzulaj tak ch'abal ancha'l re xe'rubij re Jesús, y chuka' man nitiquir-ta nuban cha jun moy che nitzu'un, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Y pa ru-tiempo re tef, jare' tak yoj re yoj israelitas nakaban re namak'ij rubini'an Dedicación, namak'ij chin nakanataj re k'ij tak xjosk'es re rachoch re Dios re c'o chire' pa tenemit Jerusalén. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y re Jesús c'o-apo pa jun corredor chin re rachoch re Dios. Y re corredor re' ja re Rey Salomón banayon can. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas xe'bapon riq'uin re Jesús, xquimol-qui' chij, y c'are' xquibij cha: ¿Anchique roma tak man jun bey najo' nasekresaj-avi' chakavach? Vo xa can ja rat re Cristo, tabij c'a chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y re Jesús xubij chique re achi'a' re': Nbin chic chiva y man iniman-ta. Y ronojel re milagros re nimban, can pa rube' c'a re Nata' Dios ye'mbanala-va. Y re milagros re' can niquisekresaj-va c'a yin anchique yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Xa jac'a yex can man yininimaj-ta, roma yex xa man yix nu-ovejas-ta, can ancha'l-va re ximbij-yan chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Re nu-ovejas yen can quitaman y niquic'axaj re nuch'abal, y chuka' can yinquitzekelbej. Yen ntaman chuka' quivach reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Man c'a xque'satz-ta can, xa can xtiquivel-va quic'aslen re man niq'uis-ta viq'uin yen. Y man jun chuka' xtitiquir xque'lisan-a pa nuk'a'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Y chuka' can pa ruk'a' re Nata' Dios jec'o-va, roma ja reja' re xcha'o quichin. Y reja' jare' re más nem ruk'ij que chiquivach conojel. ¿La c'o como jun re nitiquir ye'lisan-a pa ruk'a' reja'? Man jun. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yen y re Nata', can jun c'a kabanon riq'uin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y jare' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas xe'bequisiq'uila' chic-pa aboj, chin niquiquimisaj re Jesús cha aboj. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero re Jesús xubij chique re achi'a' re': Can q'uiy c'a utzulaj tak samaj re je'mbanalon chivach, roma re poder re ruyi'om-pa re Nata' chua. ¿Anchique c'a chique re utzulaj tak samaj re je'mbanon re man nika-ta chivach, y mare' nijo' yiniquimisaj cha aboj? xcha' re Jesús chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Y re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas xquibij cha re Jesús: Yoj man yatkaq'uiak-ta cha aboj roma jun utzulaj samaj. Yoj yatkaq'uiak cha aboj roma nabij che yat junan riq'uin re Dios. Roma jun ache nibin quire', xa nuyok' rube' re Dios, xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero re Jesús xubij chique: Chupan re i-ley, re Dios nubij: Yen nbin che yex can yix dios chuka'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Can kataman c'a che man jun bey yojtiquir nakabij che re nubij re ruch'abal re Dios man katzij-ta. Reja' can xubij dios chique re anchok chique xuya-va re ruch'abal. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Vo xa quire' xubij re Dios, ¿anchique roma yex nibij che yen xinyok' rube' re Dios roma ximbij che ja yen re Ruc'ajol re Dios? Y yen can xinrucha' c'a re Dios chin xinrutak-pa chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y vo xa man nimban-ta re milagros re nrajo' re Nata' Dios che nimban, man c'a quininimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Jac'a vo xa can nimban re milagros re nrajo' re Dios, quininimaj, astapa' man ninimaj-ta ronojel re nbin chiva chuij yen. Can ála-ta re milagros re ye'mban nitz'at chin quire' ninimaj y nitamaj che re Nata' Dios can c'o-va viq'uin, y yen chuka' quire' nbanon riq'uin reja', xcha' re Jesús chique re achi'a' re c'o quik'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Camas c'a xquijo' re achi'a' re' che xquitz'am-ta-a re Jesús, pero xa man xe'tiquir-ta chic jun bey, roma xa xba chiquivach. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y re Jesús xba chic jun bey c'a juc'an chic-apo ruchi' re rakan-ya' Jordán y xc'ue-ka q'uiy k'ij chire', re anche' xubanala-va bautismos re Juan Bautista nabey. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y camas je q'uiy vinak xe'bapon riq'uin re Jesús chire'. Y re vinak re' niquibila': Re Juan Bautista can katzij-va che man jun milagro xuban chin che xusekresaj-ta-ri' che takom-pa roma re Dios, pero ronojel re tzij re xe'rubij can chij re ache re', can katzij-va, ye'cha' re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y je q'uiy vinak re xe'niman chin re Jesús chupan re jun lugar re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupan re aldea rubini'an Betania c'o c'a jun ache niyavaj rubini'an Lázaro y jec'o je ca'e' rana' quibini'an María y Marta, y re je oxe' re' je aj-chire' chupan re mismo aldea rubini'an Betania. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Re María re', jare' re xyi'o re jun ak'om jubul-oc ruxla' chij rakan re Ajaf Jesús y xe'ruchakejsaj riq'uin re rusumal-rue'. Y ja ruxibal reja' re Lázaro, re niyavaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Y re María y re Marta re je rana' re Lázaro, xquitak rubixic cha re Jesús: Ajaf, vocame nakaya' rutzijol chava che re kaxibal Lázaro, re camas najo' rat, niyavaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y tak re Jesús xuc'axaj re tzij takon-a rubixic cha, reja' xubij: Re Lázaro niyavaj, roma nic'atzin che nik'alajin re ru-poder re Dios. Re yabil ndoc cha, man xtitiquir-ta xtuc'uaj-a pa camic. Xa can xtik'alajin-va re ru-poder re Dios, chin quire' yen re Ruc'ajol re Dios xtinc'ul nuk'ij, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Re Jesús camas ye'rajo' re Marta, re María y re Lázaro re quixibal. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y tak reja' xuc'axaj che re Lázaro niyavaj, c'a pa rox k'ij xba chutz'etic, roma c'a xc'ue-na chic-a ca'e' k'ij chupan re lugar re anche' c'o-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Y jac'a tak k'axnak chic ca'e' k'ij, re Jesús xubij chaka yoj re yoj ru-discípulos: Vocame kojtzolaj c'a pa Judea. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y yoj re yoj ru-discípulos xkabij cha: Maestro, xa c'a ba' tiempo can re' tak re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas quic'ualon chic aboj chavij chin yatquiquimisaj. ¿Y vocame can najo' chic yaba chire'? xojcha' cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero re Jesús xubij jun ejemplo chaka chin nuc'ut chakavach che reja' c'amaje-na tapon re ru-hora chin nicom, mare' xubij che re k'ij ruc'uan doce horas. Re nibiyaj pak'ij, man xtupak'ela-ta rue' tak rakan, roma can c'o re nisekresan chin re ruch'ulef. Can ronojel-va nutz'at roma re sakil re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Jac'a re nibiyaj pa k'oko'm, can nupak'ela-va rue' tak rakan, roma manak sakil pa rue'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y tak re Jesús rubin chic-ka ronojel re', xch'o chic jun bey chaka y xubij: Re ka-amigo Lázaro nivar. Mare' ja yimba chuc'asosic, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y jare' tak yoj xkabij cha: Ajaf, vo xa re Lázaro nivar, xa xtic'achoj, xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Y re Jesús xa chij c'a rucamic re Lázaro xch'o-va tak xubij che nivar, pero chakavach yoj xk'ax che can katzij-va varan. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'are' re Jesús can jabal k'alaj re xubij chaka, roma xubij: Re Lázaro xcom. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y camas c'a yinqui'cot, xcha' re Jesús, roma man pa Betania-ta yinc'o-va tak xcom re Lázaro, chin che yex más niban confiar-ivi' viq'uin. Vocame jo' c'a pa Betania, anche' c'o-va re Lázaro, xcha' re Jesús chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jac'a re jun chaka yoj re rubini'an Tomás, y nibex chuka' Dídimo cha, reja' xubij chaka yoj re yoj ruchibil: Jo' chij re Jesús, vo xa reja' xtiquimisas, can jac'a chuka' quire' xtakac'alvachij yoj, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Re Jesús y yoj re yoj ru-discípulos xojapon c'a pa Betania. Y caje-yan k'ij timuk-va re Lázaro tak xojapon yoj. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Re aldea Betania man naj-ta nicanaj-va can cha re tenemit Jerusalén. Re quicojol xa ba' rue' che nic'aj legua. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y je q'uiy re kavinak israelitas re xe'pa chire' y xe'bapon quiq'uin che xquicukuba' can quic'o'x re Marta y re María, roma xcom re quixibal. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tak re Marta xapon rutzijol riq'uin che pitinak re Jesús, jonanin xel-a chin xba chuc'ulic. Y re María xa man c'a xunabej-ta, xa xc'ue' can chire' pa jay. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y re Marta tak xapon riq'uin re Jesús, reja' xubij cha: Ajaf, re nuxibal xcom. Xe-ta vova' yatc'o-va, man-ta xcom. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero yen ntaman che re xtac'utuj cha re Dios vocame, re Dios can xtuya-va chava, xcha' re Marta cha re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jare' tak re Jesús xubij cha re Marta: Re axibal Lázaro xtic'astaj, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y re Marta xubij cha re Jesús: Ja', yen can ntaman che xtic'astaj, roma tak xtapon re ruq'uisibal k'ij, can conojel c'a re anama'i' xque'c'astaj, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Re Jesús xubij cha re Marta: Yen can yintiquir-va ye'nc'asoj re je quiminak chic-a, y can yintiquir-va ninya' c'aslen. Mare' re niniman vichin, man jun rubanon vo xa quiminak chic, roma xtic'ue' ruc'aslen. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y xabanchique vinak re c'a c'o ruc'aslen chach re ruch'ulef y yinrunimaj yen, man xtapon-ta chupan re camic chin jumul. ¿Nanimaj c'a rat re'? xcha' re Jesús cha re Marta. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y re Marta xubij cha re Jesús: Ja', Ajaf. Can ninimaj ronojel re nabij, roma can ntaman-va che ja rat re Cristo re Ruc'ajol re Dios, re bin che nipa chach re ruch'ulef, xcha' re Marta. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tak re Marta rubin chic can re tzij re' cha re Jesús, xba chuyoxic re María re ruch'alal. Y tak xapon, re Marta xubij pa ruxquin re María: Re Ajaf xbeka y vocame yarayoj, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Re María, can xe c'a xuc'axaj-a quire', can jare' xyacataj-a re anche' tz'uyul-va y jonanin xba. Reja' xba c'a anche' c'o-va re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Re Jesús can c'amaje-na toc-apo chupan re aldea rubini'an Betania, xa can c'a c'o re anche' xbec'ul-va roma re Marta. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y re kavinak israelitas re jec'o chire' pa jay, re ye'cukuban ruc'o'x re María, tak xquitz'at che jonanin xyacataj-a, xel-a y xba, re vinak re' jonanin chuka' xe'ba chij, roma reje' xquinojij che re María niba chuchi-jul chin ne'rok'ej re ruxibal. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jac'a tak re María xapon anche' c'o-va re Jesús y xutz'at, xuque-ka charakan y xubij cha: Ajaf, re nuxibal xcom. Xe-ta vova' yatc'o-va, man-ta quiminak vocame, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jac'a tak re Jesús xutz'at che re María ndok' y quire' chuka' ye'ok' conojel re kavinak israelitas re xe'bapon che niquicukuba' ruc'o'x re María, re ránma re Jesús can ju-va xuban xuna' reja' y xpa c'a bis riq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y c'are' xuc'utuj: ¿Anche' ximuk-va re Lázaro? xcha'. Y reje' xquibij: Ajaf, jo' y nakac'utu' chavach anche' xkamuk-va, xe'cha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y re Jesús xok'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jare' tak re kavinak israelitas re ye'cukuban quic'o'x re Marta y re María, xquibila': Titzu' la Jesús, nrok'ej re Lázaro. Nik'alajin che camas xrajo', xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","C'are' jec'o c'a chique re vinak re' xquibila' chij re Jesús: Reja' can xtiquir xuban cha re moy che xtzu'un. ¿Y anchique roma man xtiquir-ta xuban cha re Lázaro che man-ta xcom? xe'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tak re Jesús xapon chuchi' re jul, xtzolaj chic-pa re bis riq'uin. Re jul re mukun-va can re Lázaro, jun jul c'oton chach jun peña, y tz'apal can ruchi' riq'uin jun aboj. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y jare' tak re Jesús xubij: Tilisaj-a la aboj re anchok cha tz'apin-va can ruchi' la jul, xcha' reja'. Jac'a re Marta, re rana' can re Lázaro re xcom, xubij cha re Jesús: Ajaf, caje-yan k'ij ticom-va. Xa pitinak chic ruchuvil ninojij yen, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero re Jesús xubij cha re Marta: Yen can nbin chic chava che vo xa xtanimaj, can xtatz'at c'a re nuban re ru-poder re Dios, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y jare' tak xquilisaj-a re aboj re anchok cha tz'apin-va can ruchi' re jul anche' c'o-va re quiminak. C'are' re Jesús xtzu'un chicaj y xubij: Nata', nintioxij c'a chava, roma can xinac'axaj-pa. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yen ntaman che can nojel tiempo yinac'axaj. Y ronojel re ximbij-yan-ka, can ximbij coma re vinak re quimalom-pa-qui' viq'uin vocame, chin che tiquinimaj che can ja rat re xatako-pa vichin chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tak re Jesús rubin chic-ka re tzij re', cof xch'o y xubij: Lázaro, cayacataj y catel-pa, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y re Lázaro re quiminak chic-a, xbe'el-pa, y tak xel-pa, je'baron ruk'a-rakan che tziak y re rupalaj pison riq'uin jun tziak. C'are' re Jesús xubij: Que'isola' can la tziak chij, che otz nibiyin y nitiquir nitzolaj-a, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Y je q'uiy kavinak israelitas re ye'cukuban quic'o'x re María, xquinimaj re Jesús tak xquitz'at re xuban, che xuc'asoj re quiminak. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero jec'o nic'aj re xe'ba quiq'uin re achi'a' fariseos y xbequitzijoj chique re andex xuban re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y can jare' re principal tak sacerdotes y re achi'a' fariseos xquimol-qui' y xe'cayoj chuka' re nic'aj chic achi'a' re junan ye'bano juzgar quiq'uin, y xquibij chique: ¿Andex c'a nakaban? Roma re ache rubini'an Jesús rutz'amon samaj y q'uiy milagros ye'rubanala' chiquivach re vinak chin tiquinimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y vo xa can xtakaya' k'ij cha, can conojel re vinak xque'niman richin, y can xtiquiban cha che xtoc qui-Rey. Y tak xtiquinabej-pa re vinak romanos, xtiquivulaj can re jay re anche' nakaya-va ruk'ij re Dios y xkojquiq'uis can chuka' yoj re yojc'o chupan re nación re', ye'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'are' c'o jun xch'o, y re xch'o ja re Caifás re namalaj sacerdote chupan re tiempo re'. Reja' c'o chire', roma reja' jun chique re c'o quik'ij. Y tak reja' xch'o, xubij: Xa man jun itaman yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Can man ninojij-ta ba' che xa más otz chaka yoj che xaxe jun nicom pa kaq'uixel konojel y man yojcom-ta konojel xaxe roma re jun re', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Re Caifás tak xch'o y xubij quire', can mana-ta runa'oj reja' xucusaj. Re xe'rubij reja', can jac'a re Dios xyi'o cha. Roma can ja reja' re namalaj ru-sacerdote re Dios re tiempo re', mare' re Dios xuya' k'ij cha che xubij-yan che re Jesús tiene que nicom pa kaq'uixel yoj re yoj israelitas. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y re Jesús can man xe-ta pa kaq'uixel yoj re yoj israelitas tak xticom, xa can xticom chuka' pa quiq'uixel conojel re vinak re can je rajc'ual-va re Dios re quiquiran-qui' chach re ruch'ulef, y mare' xa jun xtakaban quiq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y can jac'a k'ij re' tak re achi'a' re c'o quik'ij xquiya-yan can chiquivach che xtiquiquimisaj re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Mare' re Jesús man chic xtz'et-ta coma re achi'a' re c'o quik'ij chakacojol yoj re yoj israelitas. Reja' xa xba c'a pa jun chic tenemit. Xba pa jun tenemit re rubini'an Efraín, y re tenemit re' chunakaj-apo re lugar re anche' manak vinak re nibex desierto cha, c'o-va. Y xc'ue' c'a-ka chire' y chibil yoj re yoj ru-discípulos. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y jare' tak napon-yan re k'ij chin re pascua, re jun chique re kanamak'ij yoj re yoj israelitas. Mare' camas je q'uiy vinak re xe'el-pa pa tak quitenemit, chin xe'ba pa tenemit Jerusalén. Can xe'ba roma reje' tiene que niquijosk'ij-qui' chin niquichajij re k'ij chin re pascua. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y re vinak niquicanola' re Jesús. Reje' je'pa'al chupan re rachoch re Dios y niquic'utula' chiquivach: ¿Andex ninojij yex? ¿Xtipa como chupan re namak'ij? ye'cha' re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Jac'a re principal tak sacerdotes y re achi'a' fariseos, can quilisan chic rutzijol che xabanchique vinak atamayon anche' c'o-va re Jesús, tubij chique reje' chin niquitz'am. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Vaki' k'ij antes che man tapon re namak'ij rubini'an pascua, re Jesús xba chupan re aldea Betania, re ru-aldea re Lázaro, re Lázaro re xc'asos chiquicojol re anama'i' roma re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y chire' xban jun namalaj va'in, chin xe'va' chin tak'ak'ij, roma xapon re Jesús. Y jac'a re Marta re nibano-apo servir re mesa, y re Lázaro jun chique re je'tz'uyul-apo chach mesa riq'uin re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpa re María re ruch'alal re Marta re je rana' re Lázaro, xbo'rc'ama-pa jun libra ak'om jubul-oc ruxla' rubini'an nardo, re ak'om re' camas caro rajal. Y jare' xuya' chij rakan re Jesús y xe'rusula' riq'uin re rusumal-rue' reja'. Y re jay re' can xnoj riq'uin re ruxla' re ak'om re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y c'o jun chaka yoj re yoj ru-discípulos re Jesús re man xka-ta chach che quire' xban cha re ak'om, y re' ja re Judas Iscariote ruc'ajol re jun ache rubini'an Simón, re discípulo re xtijacho chin re Jesús. Reja' xubij: ");
INSERT INTO cakYNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Anchique roma tak man xc'ayex-ta re ak'om? Re ak'om re' xa xba-ta che oxe' ciento denarios, y re mero xjach-ta chiquivach re vinak re camas je meba', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tak reja' xubij quire', man roma-ta che camas ye'rajo' re vinak camas je meba', y nrajo-ta ye'ruto', man quire-ta. Xa roma ja reja' re niyaco re mero y c'o mero nulek'aj, xa mare' tak quire' xubij. Reja' can jun elek'om. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Y jare' tak re Jesús xubij cha re Judas: Taya' k'ij cha re xtan re' che tubana-na re nrajo' re ránma. Astapa' c'amaje-na quincom, reja' can xuban-yan-apo re nrajo' nuban viq'uin tak xquimuk, roma can vichin-va yen ruyacom-pa re ak'om re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Roma re vinak re camas je meba', can nojel tiempo jec'o iviq'uin y xabanchique k'ij nijo' niban utzil chique. Jac'a yen man nojel-ta tiempo xquinc'ue' iviq'uin, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tak re Jesús xnabex-pa coma re kavinak israelitas che c'o pa Betania, can je q'uiy xe'pa. Re kavinak re' xe'pa man xe-ta roma re Jesús, xa can xe'pa chuka' roma can niquijo' niquitz'at re Lázaro re xc'asos roma re Jesús chiquicojol re anama'i'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Mare' re principal tak sacerdotes xquiya' chiquivach che chuka' re Lázaro xtiquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Roma chij re Lázaro xquiya-va che je q'uiy kavinak israelitas re ye'yi'o can quichin reje' y niquinimaj-a re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pa ruca'n k'ij, chire' pa tenemit Jerusalén, camas je q'uiy vinak jec'o. Conojel re vinak re' quic'ulun-qui' chire' roma re namak'ij. Y tak xquic'axaj che binak-apo re Jesús, ");
INSERT INTO cakYNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","je'quic'uan ruk'a' tak che' re nibex palma cha, xe'ba chuc'ulic y niquibila': ¡Matiox che pitinak re Jun re'! ¡Jare' re ka-Rey yoj re yoj israelitas! ¡Reja' can banom-pa bendecir y pitinak pa rube' re Ajaf Dios! ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y re Jesús xuvel jun alaj burro chin xch'oque-a chij. Can ancha'l-va nubij chupan re ruch'abal re Dios re tz'iban can, tak nubij: ");
INSERT INTO cakYNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man tuxibij-ri' re ivánma yex re yix richin chic re tenemit rubini'an Sion, roma re i-Rey ja re pitinak, ch'ocol-pa chij jun alaj burro. Quire' nubij re tz'iban can. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Y nabey, ronojel re' man xk'ax-ta pa kave' yoj re yoj ru-discípulos re Jesús. Y xk'ax pa kave' can c'aja tak re Jesús c'astajnak chic-a chiquicojol re anama'i' y c'o chic ruk'ij. C'are' tak xbeka chakac'o'x che ronojel re' can tz'iban-va chupan re ruch'abal re Dios che tiene que xtibanataj, y can quire-va, roma can ancha'l re tz'iban can, can quire' xbanataj. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y re vinak re xe'tz'eto chin re Jesús tak xrayoj re Lázaro re quiminak chic-a chin xc'astaj-pa chiquicojol re anama'i', can niquitzojola' chique nic'aj chic vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y mare', tak re Jesús nakaj chic c'o-va cha re tenemit Jerusalén, can xe'pa chin ne'quic'ulu'. Re vinak re' can quic'axan chic re milagro xuban riq'uin re Lázaro. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Jac'a re achi'a' fariseos niquibila' chiquivach: Titzu', conojel re vinak je'binak chij. Man jun chic xkojtiquir xtakaban chique chin che man-ta ye'tzake' chij. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicojol conojel re vinak re je'aponak pa tenemit Jerusalén chupan re k'ij re', chin niquiya' ruk'ij re Dios chupan re namak'ij re', jec'o chuka' je ca'e-oxe' vinak griegos. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Re ca'e-oxe' vinak re' xe'bapon-apo riq'uin re Felipe re aj-Betsaida, y re Betsaida re' chin re Galilea, chin niquic'utuj jun utzil cha, roma reja' jun ru-discípulo re Jesús. Re vinak re' xquibij cha: Yoj nakajo' yojch'o ba' riq'uin re Jesús, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Re Felipe xba y xbo'rbij cha re Andrés re can discípulo chuka'. C'are' che je ca'e' xe'ba-apo c'a riq'uin re Jesús y xquibij cha: Jec'o ca'e-oxe' vinak griegos niquijo' ye'ch'o aviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y re Jesús can jare' xubij chique re je ca'e' discípulos re': Ja k'ij xbeka, che yen re xinalax chi'icojol xtic'ue' nuk'ij y xquintzolaj-a chila' chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Y tic'axaj re xtimbij chiva vocame, che can katzij-va: Vo xa nakapokonaj nakatic-ka jun ch'et rach-trigo pan ulef, re ch'et rach-trigo re' xa choj c'a quire' xtic'ue'. Jac'a vo xa man nakapokonaj-ta nakatic-ka, astapa' xtic'ue' can chuxe' ulef re ch'et rach-trigo re', xtel-pa y xtuya' rach. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Quire' chuka' re vinak re camas nupokonaj ruc'aslen vova' chach re ruch'ulef, man xtuvel-ta ruc'aslen re man niq'uis-ta. Jac'a re man nupokonaj-ta ruc'aslen nutzij yen, can chin nojel tiempo nuyac-apo. Can ne'c'ue-va ruc'aslen re man niq'uis-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Vo xa can c'o jun nrajo' nuban re nusamaj, tipa viq'uin. Y re anche' yinc'o-va yen, can chire' chuka' xtic'ue-va reja'. Re can xtibano re nusamaj, xtinimersas ruk'ij roma re Nata' Dios re c'o chicaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Yen camas nik'axo re vánma vocame. Pero man nimbij-ta cha re Nata' che quinacola' chach re k'axomal re', xa roma re' tak xineka, y xa mare' tak yinc'o vocame. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C'are' reja' xubij: Nata', can tabana' che nik'alajin-ta re ak'ij, xcha' re Jesús. Y can jare' tak re Dios xch'o-pa chila' chicaj y xubij: Can nbanon chic quire'. Y xtimban chic jun bey, che can nik'alajin-va re nuk'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y camas chique re vinak re jec'o chire' xe'bin che xa jun tempestad re xquic'axaj tak xch'o-pa re Dios chila' chicaj. Jac'a re nic'aj chic niquibij: Jun ángel re xch'o-pa cha, ye'cha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y re Jesús xubij chique: Re Jun xic'axaj che xch'o-pa chila' chicaj, man nutzij-ta yen tak xch'o-pa, xa itzij yex tak xch'o-pa chin che yex nitamaj yin anchique yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vocame ne'ka-yan re k'ij tak re Dios xtuban juzgar re ruch'ulef, y ja chuka' k'ij re' tak re itzel re tz'amayon re ruch'ulef, can xtich'acataj-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y tak yen xquinjotobax cho cruz, re vinak can xque'pa viq'uin yen, roma can xquinsamaj pa tak cánma, xcha' reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Re Jesús xubij quire', chin xusekresaj andex che camic xtoc cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y re vinak xquibij: Rat abin che ja rat re Jun re xalax chakacojol, pero xa nabij chuka' che xcajotobax cho cruz. Can man nak'ax-ta pa kave' anchique roma quire' nabij. Roma yoj kataman re nubij chupan re ruch'abal re Dios che re Cristo tak xtipa, xtic'ue' chin nojel tiempo. Can tabij c'a chaka vo xa re xalax chakacojol, can jare' re Cristo o mana-ta, xe'cha' reje'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jare' tak re Jesús xubij chique: Yen re sakil re c'a yinc'o chic ba' iviq'uin. Can chupan c'a re sakil re' quixbiyin-va, roma c'a c'o. Y vo xa man xtiban-ta quire', c'aja xtina' xte'k'ukumar chivach, y re pa k'oko'm nibiyin-va, man rutaman-ta anchique lugar binak-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mare', re k'ij tak c'a c'o re sakil iviq'uin, can tinimaj, chin che yixoc rajc'ual re sakil re'. Quire' xubij re Jesús chique re vinak. C'are' xe'ruya' can, y reje' man xquitz'at-ta anche' xbo-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Re Jesús can q'uiy milagros xe'rubanala' chiquivach re vinak. Pero man riq'uin re' reje' cama-va xquinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y quire' xbanataj, roma tiene que nibanataj re rutz'iban can re Isaías re jun rusamajel re Dios re xc'ue' ajuer can, re xbex profeta cha. Y ja quire' nubij re rutz'iban can reja': Ajaf, tak xkatzijoj re ach'abal chique re vinak, man je q'uiy-ta re xe'niman. Y chuka' man je q'uiy-ta re xk'ax pa quive' y man riq'uin re' che can xquitz'at-yan re a-poder. Quire' nubij re rutz'iban can re Isaías. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Re vinak re' can man ye'tiquir-ta niquinimaj, can ancha'l nubij chupan re rutz'iban can re Isaías: ");
INSERT INTO cakYNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Can banon chique reje' che man ye'tzu'un-ta y covernak re cánma, mare' man niquitz'at-ta re niquitzu', man nika-ta-ka pa tak cánma, y man nitzolaj-ta-pa quic'o'x chin che yen ninchojmersaj re quic'aslen, nicha' re Ajaf. Quire' nubij re tz'iban can roma re Isaías. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Re profeta Isaías xubij quire' ja tak xutz'at ruk'ij re Cristo pa jun ancha'l achic', y chij c'a reja' ch'ovenak-va can. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero chiquicojol re vinak re xe'niman chin re Jesús, je q'uiy re can je quichibil-va re achi'a' re pa camon ye'bano juzgar chakacojol yoj re yoj israelitas. Xa jac'a man xquilisaj-ta rutzijol che xquinimaj re Jesús, roma niquixibij-qui' chiquivach re achi'a' fariseos. Xa can niquixibij-qui' che ye'kotax-pa chupan re nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Reje' xa más xquinojij andex xtiquibij re vinak, y man xbeka-ta chiquic'o'x che re Dios c'o más ruk'ij que chiquivach re vinak re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y re Jesús cof xch'o y xubij: Re niniman vichin yen, man xe-ta yen re xquinrunimaj, xa can xtunimaj re Dios re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Re nitz'eto vichin, can nutz'at chuka' re Dios re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Roma yen re sakil, ximpa chach re ruch'ulef chin che xabanchique re xtiniman vichin, man xtic'ue-ta can chupan jun c'aslen k'oko'm. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Y jac'a re vinak re nuc'axaj re nuch'abal y xa man nika-ta chach nuban re nuc'axaj, mana-ta yen re xquimbano juzgar richin. Roma re nusamaj re nc'amom-pa tak ximpa chach re ruch'ulef, man chin-ta che ye'mban juzgar re vinak. Man tinojij quire'. Re nusamaj yen ja re ye'ncol re vinak chach re quimac. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pero pa ruq'uisibal k'ij chin re ruch'ulef, can xque'ban-va juzgar re ye'tzelan vichin y re man niquic'ul-ta re nuch'abal pa tak cánma. Y ja re ch'abal re xintzijoj re xtibano juzgar quichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Roma re ch'abal re xintzijoj chivach, can jac'a re Nata' biyom-pa chua, y man xe'ntz'ucula-ta-ka. Can jac'a reja' re takayom-pa vichin y rubim-pa chua andex che ch'abal re xtinc'ut y xtintzijoj chivach. ");
INSERT INTO cakYNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y can ntaman che re rubim-pa re Nata' Dios chua, can nuya-va c'aslen re man niq'uis-ta. Mare' re ch'abal nimbij chiva, can ancha'l c'a rubixic rubanom-pa re Nata' chua yen, quire' rubixic xbembana-ka chivach yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y tak ne'ka-yan re k'ij chin re namak'ij rubini'an pascua, re Jesús rutaman chic che ne'ka-yan re hora chin che reja' ndel-a vova' chach re ruch'ulef y nitzolaj chila' chicaj riq'uin re Dios re Rutota'. Re Jesús camas je'rujovam-pa conojel re can je richin chic reja' re jec'o vova' chach re ruch'ulef, y can c'a quire' nuban chupan re k'ij re', tak napon-yan chach re camic. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Re Jesús y yoj re yoj ru-discípulos katz'amon va'in. Y jac'a re jun kachibil rubini'an Judas Iscariote, re ruc'ajol re jun ache rubini'an Simón, nisamaj chic re itzel pa ránma, y jare' re nibin cha che tujacha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Y astapa' re Jesús can rutaman-va che ronojel jachon pa ruk'a' roma re Dios re Rutota', y chire' riq'uin re Dios pitinak-va y chire' chic nitzolaj-va-a, ");
INSERT INTO cakYNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","pero man riq'uin re' reja' can xyacataj-pa y xutanaba' can ruva'in. Y xulisaj can re tziak c'o chij, xbo'rc'ama-pa jun toalla, y xuxim xe-rupan. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'are' xuya' chuka' ya' chupan jun palangana y che ja'jun che ja'jun yoj re yoj ru-discípulos xutz'am ruch'ajic kakan, y nusula' re kakan riq'uin re toalla re ruximon xe-rupan. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jac'a tak xapon riq'uin re Simón Pedro chin nuch'aj rakan, re Pedro xubij cha re Jesús: Ajaf, can man ruc'amon-ta che nach'aj chuka' vakan yen, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y re Jesús xubij cha re Pedro: Re ntz'amon rubanic vocame che ninch'aj re ivakan, c'amaje-na tak'ax pan ive'. Pero can xtak'ax pan ive' después. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Jac'a re Pedro xubij: Man ruc'amon-ta chua yen che can ja rat yach'ajo vakan. Man xtinya-ta k'ij che xtach'aj re vakan. Y re Jesús xubij cha: Vo xa man naya-ta k'ij, can man yac'ue-ta viq'uin, xcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Mare' re Simón Pedro xubij cha re Jesús: Ajaf, vo xa quire', can man xe-ta c'a re vakan nach'aj, xa can tach'aja' chuka' re nuk'a' y re nujalom, xcha' re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero re Jesús xubij cha: Re xa c'a ba' tiratin-va, xaxe c'a re rakan ruc'amon che nuch'aj roma re pokolaj, roma reja' can ch'ajch'oj chic. Yex can ch'ajch'oj chic re ivánma. Astapa' man yixnojel-ta, pero can yix ch'ajch'oj chic, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Reja' xubij quire', roma can rutaman anchique re xtijacho richin. Y mare' tak xubij: Man yixnojel-ta yix ch'ajch'oj. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y tak re Jesús ruch'ajon chic kakan yoj re yoj ru-discípulos, xbo'rc'ama' chic-pa re tziak re rulisan can chij, xbetz'uye' chic chach mesa y xubij: ¿Xk'ax como pan ive' anchique roma tak yen xinch'aj ivakan? ");
INSERT INTO cakYNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ka-Maestro y Kajaf, yixcha' c'a chua. Can otz-va roma can ja-va quire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y roma yen re i-Maestro y re Ivajaf man xinq'uex-ta chin xinch'aj ivakan, can quire' c'a chuka' tibana' yex. Man quixq'uex che nich'ajla' cakan re nic'aj chic ivchibil. Can quire' tibana'. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yen can xinc'ut can chivach. Y ancha'l c'a ximban yen iviq'uin, quire' chuka' tibana' yex quiq'uin re nic'aj chic. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Yen can c'o-va nuk'ij y ximban re samaj re'. Can quire' c'a chuka' tibana' yex. Man tipokonaj niban re samaj re'. Roma chach re ruch'ulef, mana-ta re mozo re c'o más ruk'ij que chach re patrón, y ni xe-ta chuka' jun re nitak re más c'o ruk'ij que chach re takayon-a richin. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Otz-ibanoj vo xa yex can xitamaj can ronojel re' y can niban re xitamaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Can nimbij c'a che man yixnojel-ta quire' xquixel, roma yen can ntaman ivach chiyixnojel re xixincha'. Y chuka' re tz'iban can, tiene que nibanataj. Y ja quire' nubij: Re jun can xva' viq'uin, xyacataj c'a chuij. Quire' nubij chupan re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Re jun banabal re', can ninya-yan-apo rutzijol chivach re c'amaje-na tibanataj, chin quire' tak xtapon re k'ij tak xtibanataj, xtinimaj che can ja-va yen re Cristo. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can katzij-va nimbij chiva, che re xtic'ulu richin re nintak-a yen, can ja yen re yinruc'ul. Y re xtic'ulu vichin yen, xa can xtuc'ul chuka' re takayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y tak re Jesús rubin chic ronojel re', re ránma can anchique-la xuban xuna' reja', roma re bis. Reja' can xutzijoj anchique roma tak camas bis pa ránma y xubij: Can katzij nimbij chiva, che jun chiva yex nu-discípulos re xquinjacho-a pa quik'a' re vinak re ye'tzelan vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Can jare' tak yoj xkatzula' kavach, y man nakavel-ta andex nakanojij, roma man kataman-ta anchok chij xch'o-va re Jesús. Can man kataman-ta anchique xtijacho richin. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jac'a yen re discípulo re camas yinrajo' re Jesús, yinrak'al-apo chuc'o'x. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y jac'a chua yen xuban-va-pa seña re Simón Pedro. Reja' xubij-pa chua che tinc'utuj-apo cha re Jesús che anchique re jun xtijacho richin, re c'a ba' tubij-va-ka chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y yen tak yinrak'al-apo chuc'o'x re Jesús, xinc'utuj cha: Ajaf, ¿anchique c'a re jun re xtijacho avichin? ");
INSERT INTO cakYNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Re Jesús can jare' tak xubij chua: Re xtinya' re xcana-vay muban cha, jare' re xtijacho vichin. Y reja' xumuba' re xcana-vay y xuya' cha re Judas Iscariote re ruc'ajol re jun ache rubini'an Simón. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y tak re Judas Iscariote ruq'uison chic-ka re jun pedazo xcana-vay re', can xoc-va re Satanás pa ránma. C'are' re Jesús xubij cha: Re anojin chic che naban, tabana' c'a cha'nin, xcha-a cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Jac'a yoj re yojc'o-apo chach mesa riq'uin, man xk'ax-ta pa kave' anchique roma tak xubij-a quire' cha re Judas. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jec'o chaka yoj xquinojij che xtak-a roma re Jesús chulok'ic ronojel re ndoc chaka chupan re namak'ij re'. Y re nic'aj chic kachibil xquinojij che xtak-a chin c'o cosas no'ryala' can chique re vinak camas je meba', roma yoj can kataman-va che ja re Judas re niyaco re mero. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Re Judas can xe c'a xuq'uis-a re jun pedazo xcana-vay, can jare' tak xel-a. Y tak reja' xel-a, xa can chak'a' chic. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y tak re Judas elinak chic-a, c'are' re Jesús xubij: Jac'a xbeka-yan re k'ij che yen re xinalax chi'icojol xtik'alajin che can c'o-va nuk'ij. Y can quire' chuka' re Dios, can xtik'alajin re ruk'ij voma yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y roma re Dios can xtik'alajin re ruk'ij voma yen, reja' can xtuban che nik'alajin re nuk'ij yen. Y re' xa man c'a jampa-ta, xa can ja re k'ij re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xa ba' chic-oc tiempo xquinc'ue' iviq'uin yex re can ancha'l ch'utak vajc'ual nbanon chiva. C'are' xquinicanoj. Pero vocame can nimbij can chiva, ancha'l re nbin chique nic'aj kavinak israelitas, che re anche' xquinec'ue-va yen, man xquixtiquir-ta xquixapon viq'uin chinucanoxic. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mare' can tijo' c'a-ivi'. Yen can yixinjo-va. Can quire' chuka' tibana' yex. Can tijo-ivi'. Jare' nimbij can chiva vocame, y re' can jun c'ac'a mandamiento. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Y vo xa can xtijo-ivi', re vinak can xtiquitamaj che yex can yix nu-discípulos-va, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jare' tak re Simón Pedro xubij cha re Jesús: Ajaf, ¿anche' c'a yabo-va? Y re Jesús xubij cha: Vocame c'amaje-na yatiquir yinatzekelbej re anche' xquimbo-va yen. Jac'a tak xtapon re k'ij, can xquinatzekelbej-va, xcha' cha re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Y re Pedro xubij cha: Ajaf, ¿anchique roma tak man yintiquir-ta yatintzekelbej-a vocame? Roma vo xa nic'atzin, can ninya' re nuc'aslen avoma rat, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Y re Jesús xubij cha: ¿Naya' como re ac'aslen voma yen? Yen can katzij nimbij chava, che chupan re ak'a' re' oxe' bey xtabij che man ataman-ta noch chique re xque'c'utun chava. Y c'are' xte'tzirim-pa re moma', xcha' re Jesús cha re Pedro. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Man tisatz ic'o'x, xcha' re Jesús chaka yoj re yoj ru-discípulos. Yen can ntaman che yex ibanon confiar-ivi' riq'uin re Dios. Can quire' chuka' tibana' viq'uin yen. Can tibana' chuka' confiar-ivi' viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Re chila' chicaj anche' c'o-va re Nata', c'o lugar re anche' xque'c'ue-va re ye'bapon riq'uin. Vo xa man-ta katzij che quire', yen jun-ta chic-va rubixic ximban-ta-apo chiva. Yen yimba chin ne'mbana' rubanic re i-lugar chila' chicaj riq'uin re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Chubanic re' tak yimba, y can xquimpa chic jun bey, y yixinc'uaj viq'uin, chin che anche' yinc'ue-va yen, chire' chuka' xquixc'ue-va yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Y can itaman-va re bey re nic'uan ivichin re anche' yimbo-va yen, xcha' re Jesús chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Jac'a re jun kachibil rubini'an Tomás xubij cha re Jesús: Ajaf, yoj man kataman-ta anche' yabo-va rat. ¿Ancha'l tak xtakatamaj anchique bey nakac'uaj-a yoj? ");
INSERT INTO cakYNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Y re Jesús xubij: Ja yen re bey, yen re katzij, y ja yen chuka' re c'aslen. Xaxe c'a re xtiniman vichin, xtapon riq'uin re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Vo xa can itaman noch yen, can itaman chuka' rach re Nata'. Re vocame can itz'eton chic, y chuka' itaman chic rach reja', xcha' chaka. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Y can ja chuka' re' tak jun chic chaka yoj, re rubini'an Felipe xubij cha re Jesús: Ajaf, tac'utu' c'a re Arta' chakavach, xaxe riq'uin re' can xkojqui'cot, xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Y re Jesús xubij cha: Felipe, ¿la man como ataman-ta noch? Yen can q'uiy-yan tiempo quinc'ue-va iviq'uin. Re tz'eteyon vichin yen, rutz'eton chuka' re Nata'. ¿Anchique roma tak rat nabij che ninc'ut re Nata' chivach? ");
INSERT INTO cakYNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Man nanimaj-ta rat che re Nata' c'o viq'uin yen, y yen yinc'o riq'uin reja'? Re ch'abal re xintzijoj chivach, can riq'uin re Nata' pitinak-va, roma can viq'uin yen c'o-va. Can ja reja' re nibano re samaj re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Can quininimaj che yen yinc'o riq'uin re Nata' y reja' c'o viq'uin yen. Y vo xa man yininimaj-ta roma re nimbij chiva, titzu' c'a re nusamaj y quininimaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tic'axaj jabal re xtimbij chiva: Re can xtuban confiar-ri' viq'uin, can xque'rubanala' chuka' re samaj xe'mban yen, y camas c'a nima'k tak samaj xque'rubanala'. Roma jare' tak yinc'o chic chila' chicaj riq'uin re Nata', ");
INSERT INTO cakYNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","y ronojel re xtic'utuj pa nube' yen, can xtinya-va. Chin quire' nik'alajin ruk'ij re Nata', voma yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Vo xa c'o jun cosa xtic'utuj pa nube' yen, can xtinya-va-pa chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Vo xa can yinijo', can tibana' re nubij re nu-mandamientos re ye'mbij chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y yen xtinc'utuj cha re Nata', y reja' can xtutak-pa jun chic re nita'o ivichin, Jun re can xtic'ue-va iviq'uin chin nojel tiempo. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Y re' can ja re Espíritu Santo, re nitijon ivichin cha re katzij. Y re vinak re man quiniman-ta re Dios, man ye'tiquir-ta niquic'ul re Espíritu Santo. Roma re Espíritu Santo xa man nitz'et-ta y man quitaman-ta chuka' rach. Jac'a yex re can iniman chic, man quire-ta. Yex can itaman chic rach, roma c'o chic chi'icojol. Y reja' can xtoc pa tak ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yen man xquiximalij-ta can astapa' xquimba, man xquixc'ue-ta can ancha'l jun re manak rute-rutota', roma xa can yimpa chic iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Jac'a re vinak re man quiniman-ta re Dios, xa can ba' chic-oc re xquinquitz'at. Pero yex can xquinitz'at-va, roma can xtic'ue' chic jun bey nuc'aslen. Y yex can xtic'ue' chuka' ic'aslen quire'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Y chupan re k'ij re' tak xtik'alajin jabal chivach che yen can yinc'o-va riq'uin re Nata', yex yixc'o viq'uin yen y yen iviq'uin yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Re c'o re nuch'abal pa ránma y can nuban re nubij ronojel re nu-mandamientos, can yinrajo-va. Y re nijovan vichin yen, can xtijovax roma re Nata', y yen chuka' can xtinjo' y xtinc'ut-vi' chach, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jare' tak re Judas re jun kachibil, pero mana-ta re Judas Iscariote, xuc'utuj cha re Jesús: Ajaf, ¿anchique roma che xaxe chakavach yoj xtac'ut-va-avi'? ¿Y anchique roma tak man nac'ut-ta-avi' chiquivach re vinak re man quiniman-ta re Dios? ");
INSERT INTO cakYNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Y re Jesús xubij cha: Re can yinrajo-va, can nuban re nubij re nuch'abal cha. Re jun re xtibano quire', can xtijovax-va roma re Nata' chuka'. C'are' re Nata' y yen can xkojpa riq'uin y xtakaban kachoch pa ránma. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Jac'a re man nijovan-ta vichin, man nuban-ta re nubij re nuch'abal cha. Y re ch'abal re ic'axan viq'uin yen, man xe-ta c'a vichin yen. Can jac'a re Nata' re takayom-pa vichin, ja reja' re ya'yom-pa re ch'abal re' chua. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Y ronojel re ch'abal re', can xe'mbij c'a chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Y tak yen man chic yinc'o-ta iviq'uin, re Nata' xtutak-pa re Espíritu Santo chin yixruto'. Y ja reja' re xtic'ue' iviq'uin pa nuq'uixel. Y can jac'a chuka' reja' xquixtijon y xtunataj ronojel re ch'abal re je'mbin can yen chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Y can ancha'l nuna' re vánma yen che otz c'o, can quire' chuka' nimban can cha re ivánma yex. Y can katzij otz xtuna' re ivánma, roma yen man nimban-ta ancha'l niquiban re vinak re man quiniman-ta re Dios, tak niquibij che re ivánma otz nuna', y xa man katzij-ta. Man tisatz ic'o'x y chuka' man tixibij-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xa can ic'axan viq'uin che nbin: Yen can xquimbo-va, pero yimpa chic iviq'uin. Y vo xa yex camas-ta yinijo', niqui'cot-ta re ivánma, roma yen can riq'uin re Nata' yintzolaj-va-a. Reja' camas-va ruk'ij que chinoch yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Re' ninya-yan can rutzijol chiva, chin quire' tak xtapon re k'ij che xquixinya' can, man-ta jun cosa xtinojij, xa can xtinimaj-va re nbin can chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Y re vocame xa man q'uiy-ta chic tzij re xtimbij can chiva, roma re tiempo xa man q'uiy-ta chic. Re itzel re tz'amayon re ruch'ulef xa nipa-yan. Pero astapa' can ja reja' re tz'amayon re ruch'ulef, man jun ruk'a' chua yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Re nimban yen, can jac'a re Nata' Dios re xintako-pa chubanic. Y quire' nimban chin che re vinak re man quiniman-ta reja', tiquitamaj che yen ninjo' re Nata' Dios. Kojyacataj y kojel-a vova', xcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Y c'are' re Jesús xubij: Ja yen re katzij ancha'l juvi' uva, y re Nata' jare' re nisamajin re uva re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Roma juvi' uva jec'o ruk'a' re xa man ye'vachin-ta, ye'lisas-a. Jac'a re ruk'a' re can ye'vachin, ye'josk'es jabal, chin más otz ye'vachin. Can quire' chuka' yen. Re Nata' ye'rutz'at conojel re jec'o viq'uin y ye'rulisaj-a re man nivachin-ta quic'aslen. Jac'a re nivachin quic'aslen, ye'rojosk'ij más, che re quic'aslen más nivachin. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yex re can nc'utun-va-pa re ch'abal chivach, can xixch'ojch'ojer-yan roma re ch'abal re'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Can nojel tiempo c'a quixc'ue' viq'uin, chin quire' yen can yinc'ue' chuka' iviq'uin. Roma vo xa c'o jun ruk'a' uva re man chach-ta re rakan ndel-va-pa, man nivachin-ta. Xa can nic'atzin che jun ruk'a' uva chach re rakan ndel-va-pa, chin quire' nivachin. Can quire' chuka' yex, can nic'atzin che nojel tiempo quixc'ue' viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja yen re juvi' uva, y yex re ruk'a'. Re can nojel tiempo c'o viq'uin y yen riq'uin reja', re ruc'aslen can xtivachin-va. Roma re man c'o-ta viq'uin, man jun xtitiquir xtuban. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Re anchique man nic'ue-ta viq'uin, xtuc'alvachij ancha'l niquic'alvachij re ruk'a' tak uva re xa man ye'vachin-ta. Ye'lisas-a roma man ye'vachin-ta, y tak je chake'j chic, ye'bemol-pa, ye'torix pa k'ak', y chire' ye'c'at-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Jac'a yex can quixc'ue' viq'uin, y tic'ue' re nuch'abal iviq'uin. Vo xa quire' xtiban, can tic'utuj cha re Dios andex nurayij re ivánma, y can quire' xtibanataj. Can xtuya-va-pa chiva re nic'utuj. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Vo xa can nivachin jabal re ic'aslen, can nik'alajin che yixtzakatal chuij. Y mare' re xquixtz'eto, can xtiquiya' ruk'ij re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Can ancha'l como yen camas yinrajo' re Nata', can quire' chuka' nimban yen chiva yex. Y mare' nojel tiempo quixc'ue' viq'uin y siempre yixinjo'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Y chin che yixc'ue' viq'uin y yixinjo', yex can niban re ye'mbij chiva. Ancha'l nbanon yen riq'uin re Nata', can ye'mban re nubij chua, y mare' yinc'o riq'uin reja' y yinrajo'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Y ronojel re nbin chic chiva, can chin che yixqui'cot pa tak ivánma, can ancha'l yinqui'cot yen pa vánma. Y re ivánma camas-ta xtiqui'cot. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Y yen ninchalabej chiva che can tijo-ivi', can ancha'l yixinjo' yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Roma re jun re can nuya-va ruc'aslen pa quiq'uixel re ru-amigos, can k'alaj che camas ye'rajo' y man jun chic re xtijovan más que chach reja'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y yex can yix nu-amigos, vo xa niban ronojel re nimbij chiva che tibana'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Roma yen can amigos chic nbanon chiva, roma can ronojel re rubim-pa re Nata' chua yen, can xintzijoj chuka' chiva yex. Man xe-ta chic yix nusamajela'. Roma jun samajel man rutaman-ta andex nunojij re ru-patrón. Yen man quire-ta chic nbanon chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Re xcha'o ivichin yex, ja yen, y mana-ta yex re xixcha'o vichin yen. Y yen xixincha' chin che yixintak chubanic re nusamaj y chin chuka' che nivachin jabal re ic'aslen, y re' can chin nojel tiempo, chin quire' re andex xtic'utuj cha re Nata' pa nube' yen, can xtuya-va-pa chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Can ninchalabej c'a chiva, che tijo-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Y vo xa yixtzelas coma re vinak re man quiniman-ta re Dios, te'ka chi'c'o'x che ja yen re xinquitzelaj nabey que chivach yex. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xe-ta yix quichibil-ta re vinak re man quiniman-ta re Dios, yixquijo-ta. Pero vocame yixquitzelaj, roma man yix quichibil-ta chic reje'. Can jac'a yen re xinlisam-pa ivichin chiquicojol. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Can te'ka chi'c'o'x che mana-ta re mozo c'o más ruk'ij que chach re patrón. Y vo xa yen re Ivajaf yintzelas coma re vinak, yex chuka' xa can quire' xtiban chiva, y vo xa re vinak man niquiban-ta re nubij re nuch'abal yen, man xtiquiban-ta chuka' re nibij yex chique. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Y quire' xtiquiban, roma man quitaman-ta rach re Dios re takayom-pa vichin, y mare' yixquitzelaj, roma viq'uin yen ibanon-va confiar-ivi'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Y man-ta ximpa yen chach re ruch'ulef chutzijosic re nuch'abal, man-ta xinquitzelaj y man-ta xe'k'alajin che je aj-maqui'. Jac'a vocame, roma yen ximpa-yan chach re ruch'ulef, mare' reje' man xque'tiquir-ta xtiquibij che man jun quimac. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Re ye'tzelan vichin yen, can man xe-ta c'a yen re yinquitzelaj, xa can quire' chuka' niquiban cha re Nata'. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yen je'mbanalon nima'k tak samaj re man jun banayon chiquivach. Y reje' xquitz'at re samaj re', pero man yinquiniman-ta. Xa yinquitzelaj y niquitzelaj chuka' re Nata'. Y mare' man jun xtibin che manak rumac. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ronojel re', can ntajin chic rubanic, roma can quire' tz'iban can chupan re ruch'abal re Dios re yi'on chique. Chupan re ruch'abal re Dios nubij: Yinquitzelaj y xa man k'alaj-ta anchique roma. Quire' nubij chupan re ruch'abal re Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Jac'a tak yen xquintzolaj chic chila' riq'uin re Nata', xtintak-pa re xtito'o ivichin, y reja' can xquinrutzijoj-va. Y re Jun re' ja re Espíritu Santo, re nitijon ivichin cha re katzij. Y reja' riq'uin re Nata' nipo-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Y yex can xquinitzijoj chuka', roma can ja tak xintz'uc-pa re nusamaj, jare' tak yixc'o viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Y ronojel re', can ximbij chiva chin che yex nitamaj can y man-ta jun nibano chiva che yixtzak. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Xquixkotax chire' pa tak nema-jay re anche' nitzijos-va re ruch'abal re Dios re nibex sinagoga cha. Y can xtapon-va chuka' re k'ij tak re vinak xtiquinojij che rusamaj re Dios niquiban reje' tak yixquiquimisaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Quire' re xque'quibanala' re vinak, roma man quitaman-ta rach re Nata' y man quitaman-ta chuka' noch yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Y ronojel re' nimbij can chiva, chin che tak xtapon re k'ij tak xquixquikotaj-pa y xquixquimisas man c'a xtibij-ta che yen man xinya-ta can rutzijol chiva. En lugar che quire-ta xtinojij, xa can jare' tak xte'ka chi'c'o'x che can katzij re rutzijol nyi'on can chiva. Ronojel re' can man xinya-ta rutzijol chiva tak xintz'uc-pa re nusamaj, roma can yinc'o-va-pa iviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Y vocame yintzolaj riq'uin re takayom-pa vichin. Anchique roma tak man jun chiva yex re yix nu-discípulos re nic'utun-ta-pa chua: ¿Anche' c'a xcabo-va? ");
INSERT INTO cakYNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero en lugar che quire-ta nic'utuj chua, re ivánma xa nojnak che bis, roma re ximbij-ka chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero yen can ja re katzij nimbij chiva: Jabal nuban chiva vo xa yen xquimba-yan, roma vo xa man xquimba-ta, man nika-ta-pa re Espíritu Santo re nita'o ivichin. Jac'a vo xa xquimba-yan, can xtintak-va-pa. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Y tak xte'ka re Espíritu Santo, can xtutzijoj chiquivach re vinak re man quiniman-ta re Dios che can je aj-maqui-va, che c'o jun bey choj chin c'aslen, y re Dios can xtuban-va juzgar pa quive' re vinak. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Reja' xtutzijoj chiquivach re vinak che je aj-maqui', roma man yinquinimaj-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Can xtutzijoj chuka' chiquivach re vinak re choj bey chin c'aslen, roma yen riq'uin re Nata' yinapon-va. Y jare' tak yex man xquinitz'at-ta chic. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y chuka' reja' can xtutzijoj che re Dios can xtuban-va juzgar pa quive' re vinak, roma vocame can xban-yan juzgar pa rue' re itzel re tz'amayon chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Y can c'a q'uiy cosas re man nimbij-ta can chiva, roma vocame c'ayef chin che ye'k'ax pan ive' y can c'ayef chuka' nuban chiva che nic'uaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Jac'a tak xtipa re Espíritu Santo, can xquixrutijoj y xquixruc'uaj chupan re katzij. Reja' can man rion-ta xtisamaj, roma re ch'abal re xtuyala' chiva, can ja re je'bim-pa cha chila' chicaj. Y mare' tak reja' xque'rusekresaj-yan-apo chivach re xque'banataj re chakavach-apo. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Y reja' can xtuya' nuk'ij yen, roma ronojel re xtubij chivach, can chuij yen y re nusamaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Can ronojel re c'o riq'uin re Nata' Dios, can vichin chuka' yen, y mare' tak yen ximbij-yan che ronojel re xtubij re Espíritu Santo chivach, can chuij yen y re nusamaj. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xa ba' chic c'a xquinitz'at. Y c'are' xquinel-a jun ca'e-oxe' k'ij chi'icojol, c'are' xquinitz'at chic ba', y c'are' yen yintzolaj chic chila' riq'uin re Nata' Dios, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Y nic'aj chaka yoj re yoj discípulos tak xkac'axaj re xubij re Jesús, xkac'utula' chakavach. Yoj xkabij: ¿Andex xrajo' xubij chaka riq'uin re ch'abal re'? Roma xubij: Xa ba' chic c'a xquinitz'at. Y c'are' xquinel-a jun ca'e-oxe' k'ij chi'icojol, c'are' xquinitz'at chic ba'. Y c'are' yen yintzolaj chic chila' riq'uin re Nata' Dios, xcha', quire' xkabila' chakavach. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yoj nakabila' chakavach: ¿Andex nrajo' nubij re rutzij: Xa ba' chic c'a? Xa man ye'k'ax-ta pa kave' re rutzij, yojcha'. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Y re Jesús can cha'nin xunabej che yoj c'o jun cosa nakajo' nakac'utuj cha, mare' reja' xubij: Yex nijo' nitamaj andex re ximbij, che xa ba' chic c'a xquinitz'at, y c'are' xquinel-a jun ca'e-oxe' k'ij chi'icojol, c'are' xquinitz'at chic ba'. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mare' can katzij nimbij chiva: Yex can xquixok' y xquixbison roma re xtinc'alvachij yen. Jac'a re vinak re man quiniman-ta re Dios, xque'qui'cot roma re xtibanataj. Y man riq'uin re' che yex can c'o-va re bis pa tak ivánma, re bis re' xtijalataj. Re bis xa xtuban chiva che xquixqui'cot. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Re bis re' junan riq'uin re k'axomal nuk'asaj jun ixok tak napon ruk'ij chin nralaj jun ac'ual. Tak re ac'ual xalax-yan, re te'ej re' man ne'ka-ta chic chuc'o'x andex che k'axomal xuk'asaj, roma camas niqui'cot ránma che xalax chic jun ac'ual chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Can quire' chuka' yex, vocame c'o bis pa tak ivánma, pero can yimpa chic jun bey chi'itz'etic. Y jare' tak re ivánma xtiqui'cot chic jun bey, y man jun chic xtibano cha re ivánma che man chic xtiqui'cot-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Y chupan re k'ij re', man chic chua-ta yen xtic'utuj-va re nurayij re ivánma. Pero can katzij nimbij chiva, che ronojel re xtic'utuj cha re Nata' pa nube' yen, can xtuya-pa chiva. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Jac'a vocame can man jun ic'utun-ta cha re Nata' pa nube' yen. Can tic'utuj, y xtic'ul. Y chin quire' camas-ta xtiqui'cot re ivánma. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Can ronojel re nbin chic-ka chiva, can c'ayef-va chin che ye'k'ax pan ive', pero xte'ka re k'ij tak man chic quire-ta rubanic xquinch'o iviq'uin. Xa can k'alaj rubixic xtimban chiva chij re Nata' Dios. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Y chupan re k'ij re', can pa nube' yen xtic'utuj-va cha re Nata', y reja' can xtuya-pa chiva re nic'utuj cha. Y xtuya' chiva, man roma-ta che can ja yen re yinc'utun pan i-cuenta yex. Man quire-ta. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Re Nata' nuya' chuka' chiva re nic'utuj cha, roma yixrajo'. Y reja' yixrajo', roma yex yinijo' yen y ninimaj che yen riq'uin reja' yimpitinak-va. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Can riq'uin-va re Nata' Dios yimpitinak-va, chin xineka chach re ruch'ulef. Y vocame can riq'uin chuka' reja' yintzolaj-va-a, y ninya' can re ruch'ulef, xcha' re Jesús. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Y yoj re yoj ru-discípulos xkabij cha: Can katzij-va che vocame man chic c'ayef-ta chin ye'k'ax pa kave' re nabij, xa can k'alaj re ya'bij. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vocame nak'ax pa kave' che rat can ronojel natz'at y ronojel chuka' ataman. Can man nic'atzin-ta che nakac'utuj chava chin natamaj re nakanojij. Y mare' yoj can nakanimaj che riq'uin re Dios yatpitinak-va, xojcha' cha. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Y re Jesús xubij chaka yoj: ¿Can yininimaj como vocame? ");
INSERT INTO cakYNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Roma can katzij nimbij chiva che re jun k'ij re' can nipo-va, y can hora chic, che xtibanataj che yex xa xtitaluj-a-ivi' y xa xquiniya' can nayon. Pero man nayon-ta chuka' xquinc'ue' can, roma re Nata' can c'o-va viq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Y ronojel re', can nintzijoj can chiva, chin che re ivánma can otz nuna', y can quire' xtuna' re ivánma roma ibanon confiar-ivi' viq'uin. Y nimbij can chuka' chiva, che can xtivel-va tijoj-pokonal vova' chach re ruch'ulef. Pero can xtic'ue-a ivuchuk'a' roma yen xinch'ac-yan re itzel re tz'amayon chin re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Y tak re Jesús rubin chic ronojel re', reja' xtzu'un chicaj chin nuban orar y nubij: Nata' Dios, re nu-hora can ja xbeka. Vocame can tabana' chua yen re Ac'ajol che nik'alajin re nuk'ij, chin quire' yen re Ac'ajol can ja chuka' xtimban aviq'uin rat, che can xtik'alajin re ak'ij. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Roma can ajachon-va-pa poder pa nuk'a' chin che can yinc'ue-va pa quive' conojel vinak. Y re poder re' nic'atzin che yen ninya' re c'aslen re man niq'uis-ta chique conojel re can je'ayi'on chic chua. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Y re c'aslen re man niq'uis-ta, ja re niquitamaj avach rat Nata' Dios y niquitamaj chuka' noch yen. Roma ja rat re katzij Dios y man jun chic Dios c'o, y yen re Jesucristo re xinatak-pa chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Riq'uin re samaj re ximban vova' chach re ruch'ulef, xk'alajin re ak'ij. Y xinq'uis-yan chuka' ronojel re samaj re achalabem-pa chua chin nimban. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vocame, Nata' Dios, can taya' chic c'a re nuk'ij tak xinc'ue' aviq'uin rat. Can ancha'l re nuk'ij re xc'ue' tak c'amaje-na tic'ue' re ruch'ulef che'. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Roma re achi'a' re can je'acha'on chic-pa rat chiquicojol re man yatquiniman-ta, chua yen xa'ya-va vocame, y yen can xinsekresaj re abe' chiquivach. Re achi'a' re' can je avichin rat, y xa'ya' chua yen. Y reje' can quibanon y quichajin re ach'abal. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Chuka' re achi'a' re' can quitaman chic che ronojel re ayi'om-pa chua yen, can xk'ax-yan pa quive' che ja rat re yatya'yom-pa chua. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Roma can ja re ch'abal re ayi'om-pa chua yen chin nitzijos, can jare' re xintzijoj chiquivach re achi'a' re'. Y reje' can quic'ulun-va re ach'abal pa tak cánma, y can quitaman-va che katzij che aviq'uin rat Nata' Dios yimpitinak-va. Can quiniman che ja rat re yatakayom-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Can ninc'utuj chava rat che taya' re ak'a' pa quive' reje', y mana-ta pa quive' re vinak re man yatquiniman-ta. Can pa quive' re achi'a' re xa'ya' chua ninc'utuj che taya' re ak'a' pa quive', roma can je avichin chuka' rat. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Y conojel re je vichin yen, can je avichin chuka' rat, y re je avichin rat, je vichin chuka' yen. Y yen can xk'alajin-yan re nuk'ij, coma re achi'a' re xa'ya' chua. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lok'olaj Nata' Dios, pan ak'a' c'a ye'njach-va can re achi'a' re xa'ya' chua, can ca'chajij riq'uin re a-poder, chin quire' can junan-ta quivach y xa jun-ta c'a niquiban. Can niquiban-ta ancha'l kabanon yoj. Yoj can jun kabanon. Can ca'chajij, roma reje' can c'a ye'c'ue-na can chach re ruch'ulef, y yen man quire-ta. Yen xa yintzolaj-yan-a aviq'uin. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Y yen can je'nchajin-va-pa re achi'a' re xa'ya' chua. Jenipa' tiempo re xinc'ue-pa quiq'uin chach re ruch'ulef, can xe'nchajij riq'uin re a-poder rat. Y can man jun chic re xsatz-ta can chique, xa can xe re jun re xe itzel tak banabal nubanala' y nucanoj rucamic. Can quire' c'a re tz'iban can, che c'o jun re nisatz can. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yen can ja yintzolaj-yan aviq'uin, Nata' Dios, pero riq'uin re c'a yinc'ue-na ba' chic chach re ruch'ulef, ninc'utuj chava che taya' re ak'a' pa quive', roma ninjo' che camas-ta ye'qui'cot pa tak cánma. Can ancha'l yinqui'cot yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Re achi'a' re xa'ya' chua, can nyi'on-va re ach'abal chique. Mare' re vinak re man yatquiniman-ta xe'quitzelaj, roma re achi'a' re xa'ya' chua man je richin-ta chic re ruch'ulef. Can je ancha'l chic yen, roma yen man yin richin-ta chuka' re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man ninc'utuj-ta chava Nata' Dios che ca'lisaj-yan-a chach re ruch'ulef chin ya'col. Re ninc'utuj chava, ja che ca'to'. Man taya' k'ij che re itzel nich'acon chiquij. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Re achi'a' re xa'ya' chua, man je richin-ta re ruch'ulef. Can je ancha'l yen. Yen man yin richin-ta chuka' re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Can tabana' chique che tiquijacha-qui' chupan re ach'abal. Re ach'abal ja re katzij. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Y can ancha'l rubanic re xabam-pa chua yen chin xinatak-pa chubanic re asamaj chach re ruch'ulef, can quire' chuka' nimban yen chique re achi'a' re xa'ya' chua. Can je'ntakon-va chubanic re asamaj chach re ruch'ulef. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Coma reje' yen can ninjach c'a chuka-vi' chin re samaj, che quire-ta chuka' niquiban reje'. Can tiquijacha-qui' y que'c'ue' chupan re katzij. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nata' Dios, yen man xe-ta pa quive' re achi'a' re xa'ya' chua ninc'utuj che taya' ak'a' pa quive', xa can quire' chuka' ninc'utuj chava pa quive' conojel re xque'niman vichin, re can xquinquinimaj roma re ch'abal xtitzijos chiquivach, ");
INSERT INTO cakYNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","chin che conojel can junan-ta quivach. Xa can jun-ta xtiquiban. Can-ta xtiquiban ancha'l re kabanon yoj, che xa jun kabanon. Roma rat Nata' Dios can yatc'o viq'uin yen, y yen can yinc'o chuka' aviq'uin rat. Quire' ninjo' che niquiban-ta reje' kaq'uin yoj. Can-ta nik'alajin chiquivach re vinak re man yatquiniman-ta, che yen, can ja rat re xatako-pa vichin, roma niquitz'at che can junan quivach quibanon re jec'o kaq'uin yoj. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Yen xinya-yan chique re ayi'om-pa rat chua yen. Reje' can c'o chic quik'ij chuka', ancha'l re abanom-pa chua yen. Chin quire' xa jun-ta xtiquiban, ancha'l kabanon yoj xa jun kabanon. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Can xquinc'ue-va quiq'uin reje' y rat viq'uin yen, chin quire' reje' can jun-ta xtiquiban. Y mare' xtitamax coma re vinak re man yatquiniman-ta, che ja rat Nata' Dios re xatako-pa vichin. Y mare' chuka' xtitamax coma re vinak che can ya'jo-va, ancha'l yinajo' yen. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nata' Dios, yen ninjo' che conojel re je'ayi'on chua xque'bec'ue-ta viq'uin chila' chicaj, chin che niquitz'at-ta re nuk'ij re ayi'on, roma xinajo' tak c'amaje-na tic'ue' re ruch'ulef che'. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nata' Dios, rat re yat choj riq'uin ronojel, re vinak re man yatquiniman-ta man c'a quitaman-ta avach. Pero yen can ntaman-va avach, y re achi'a' re xa'ya' chua, can xquitamaj chuka' che ja rat re xatako-pa vichin. ");
INSERT INTO cakYNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Y yen can ximban che xinsekresaj re abe' rat chiquivach, y can xtimban che xtinsekresaj más chiquivach, chin quire' can-ta xca'jo' ancha'l