﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakWNT_vpl;
CREATE TABLE cakWNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakWNT_vpl WRITE;
INSERT INTO cakWNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Re wuj ri nuchop el wawe', jun wuj ri tz'ibatal wi ca ri quibi' ri ye ojer tak rati't rumama' ri Jesucristo. Can nik'alajin wi c'a chi Riya' can jun chique ri ye ralc'ual ca ri rey David, y can ralc'ual ca chuka' ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham yari' ri xalc'ualan ri Isaac; ri Isaac xralc'ualaj ri Jacob; ri Jacob xralc'ualaj ri Judá y ri nic'aj chic rach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yac'a ri Judá y ri Tamar ri rixjayil xecalc'ualaj ri Fares y ri Zara; yac'a ri Fares ri xalc'ualan ri Esrom; y ri Esrom xralc'ualaj ri Aram. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y ri Aram xralc'ualaj ri Aminadab; ri Aminadab xralc'ualaj ri Naasón; y ri Naasón xralc'ualaj ri Salmón. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y ri Salmón y ri Rahab ri rixjayil xcalc'ualaj ri Booz; ri Booz y ri Rut ri rixjayil xcalc'ualaj ri Obed; y ri Obed xralc'ualaj ri Isaí. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y ri Isaí xralc'ualaj ri David ri xoc jun rey; y ri rey David xralc'ualaj ri Salomón. Y ri rute' ri Salomón, ya ri rixjayil ca ri Urías. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Yac'a ri Salomón xralc'ualaj ri Roboam; ri Roboam xralc'ualaj ri Abías; y ri Abías xralc'ualaj ri Asa. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y ri Asa xralc'ualaj ri Josafat; ri Josafat xralc'ualaj ri Joram; y ri Joram xralc'ualaj ri Uzías. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y ri Uzías xralc'ualaj ri Jotam; ri Jotam xralc'ualaj ri Acaz; y ri Acaz xralc'ualaj ri Ezequías. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y ri Ezequías xralc'ualaj ri Manasés; ri Manasés xralc'ualaj ri Amón; y ri Amón xralc'ualaj ri Josías. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y ri Josías xralc'ualaj ri Jeconías y ri ye nic'aj chic rach'alal ri Jeconías. Y ya tiempo ri' tek ri kech aj Israel xechapatej el y xe'uc'uex c'a pa Babilonia. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y tek yec'o chic chiri' pa Babilonia, ri Jeconías xralc'ualaj ri Salatiel; y ri Salatiel xralc'ualaj ri Zorobabel. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y ri Zorobabel xralc'ualaj ri Abiud; ri Abiud xralc'ualaj ri Eliaquim; y ri Eliaquim xralc'ualaj ri Azor. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y ri Azor xralc'ualaj ri Sadoc; ri Sadoc xralc'ualaj ri Aquim; y ri Aquim xralc'ualaj ri Eliud. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y ri Eliud xralc'ualaj ri Eleazar; ri Eleazar xralc'ualaj ri Matán; ri Matán xralc'ualaj chuka' jun ri Jacob chuka' rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri Jacob xralc'ualaj c'a ri José ri xoc rachijil ri María. Y ri María ri' yari' ri xalan ri Jesús ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Cajlajuj c'a sol winek xec'ase' el, ri nitiquir pe riq'ui ri Abraham c'a riq'ui ri rey David. Cajlajuj chuka' sol winek xec'ase' el, ri nitiquir pe riq'ui ri rey David c'a chupan ri tiempo tek ri kech aj Israel xechapatej el y xe'uc'uex c'a pa Babilonia. Y cajlajuj chuka' sol winek xec'ase' el, ri nitiquir pe tek ri kech aj Israel xebec'oje' pa Babilonia, hasta riq'ui ri tiempo tek xalex ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Y ri ralaxbel ri Jesucristo quec'are' ri rubanic: Ri María rute' ri Jesucristo, jun c'a k'opoj ri c'utun chic ruma ri José. Y xc'ulwachitej c'a chi tek c'a ma jane quic'uan ta qui', xnabetej chi ri María yawa' chic riche (rixin) chi nic'oje' ral. Yac'a ri María queri' xril ruma ruchuk'a' ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yac'a ri José ri nbe'oc rachijil ri María, can jun chojmilaj winek wi; y man c'a xrajo' ta xuya' (xutzek) ruq'uix ri María chiquiwech ri winek, rumari' xrajo' chi man ta ninabex chi nuya' ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y ri José ya c'a ri' ri nuch'ob pa ránima. Y pa rachic' xuc'ut c'a ri' jun ángel riche (rixin) ri Ajaf chuwech, y xbix chare ruma ri ángel ri': Riyit José, ri yit jun chique ri ye ralc'ual ca ri rey David, man c'a taxibij ta awi' chi yac'ule' riq'ui ri María ri ac'utun chic riche (rixin) chi ntoc awixjayil. Wacami petenak chic alanic chrij ruma ya ri Lok'olaj Espíritu xka pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri ac'al c'a ri xtralaj ri María, ti c'ajol (ala'), y JESÚS c'a rubi' xtaya', ruma ya Riya' ri xquecolo ri winek chupan ri quimac. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel c'a re' xc'ulwachitej riche (rixin) chi can nibanatej ri xbix ruma ri Dios chare ri profeta Isaías ri jun chique ri xek'alajsan ri ruch'abel ri Dios ojer ca, tek xubij: ");
INSERT INTO cakWNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tiwetamaj c'a chi xtic'oje' jun ri c'a k'opoj na y xtic'oje' jun ral, astape' man c'o ta riq'ui achi. Y can xtralaj na wi jun ac'al, ti c'ajol (ala'), ri xtubini'aj Emanuel. Re bi'aj re' can ntel c'a chi tzij chi ri Dios c'o kiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tek xc'astej c'a ri José, can xuben wi achi'el ri xbix chare ruma ri ángel riche (rixin) ri Ajaf. Riya' can xuc'om na wi ri María riche (rixin) chi xoc rixjayil. ");
INSERT INTO cakWNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ri José majun xunek ta ri María c'a ya tek alaxnek chic na ri nabey ral. Y tek xalex ri ac'al, JESÚS ri rubi' xuya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalex c'a pa tinamit Belén, ri tinamit ri c'o pa rucuenta ri Judea. Tek xalex ri Jesús, ya c'a ri Herodes ri rey, y yac'ari' tek jun ca'i' achi'a' ri c'o quetamabel chiquij ri ch'umila', xe'apon pa Jerusalem. Ri achi'a' ri', pa relebel k'ij ye petenak wi, ");
INSERT INTO cakWNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquic'utuj c'a chique ri winek: ¿Acuchi (achique) c'o wi ri ac'al ri qui-Rey ri israelitas ri xa c'a xalex? Ri ruch'umil katz'eton pe riyoj c'a quela' pa relebel k'ij, y xojpe chuya'ic ruk'ij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tek ri rey Herodes xrac'axaj ri xquibij ri achi'a' ri c'o quetamabel chiquij ri ch'umila', xsach ruc'u'x. Y can queri' c'a chuka' xquic'ulwachij ri winek ri aj pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y ri rey Herodes xerumol c'a quinojel ri principali' tak sacerdotes y ri aj tz'iba' chiquicojol ri israelitas, y c'ac'ari' xuc'utuj chique chi acuchi (achique) c'a nalex wi ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xepe ri principali' tak sacerdotes y ri aj tz'iba' xquibij c'a chare ri rey: Ri Cristo nalex pa tinamit Belén wawe' pa rucuenta re Judea. Ruma jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, quec'are' ri rutz'iban ca: ");
INSERT INTO cakWNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y riyit tinamit Belén ri yitc'o pa Judá, riyit ma can ta yit co'ol chiquicojol ri nima'k tak tinamit chiri' pa Judá, ruma ya ri chiri' awuq'ui riyit xtipe wi ri uc'uey bey, y can xqueruchajij ri nutinamit Israel achi'el nuben jun utzilaj aj yuk', nicha' ri Dios, xecha' apo chare ri rey Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Yac'ari' tek ri rey Herodes pan ewel xerusiq'uij (xeroyoj) ri achi'a' ri c'o quetamabel chiquij ri ch'umila', y xuc'utuj ca jabel chique janipe' chic k'ij tiquitz'et wi ri ruch'umil ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","C'ac'ari' tek xerutek el pa tinamit Belén y xubij el chique: Quixbiyin c'a chila' y ticanoj ri ac'al, y tek iwilon chic ca, no'ibij ca chuwe, riche (rixin) chi riyin yibe chuka' chuya'ic ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y tek ri achi'a' ri c'o quetamabel chiquij ri ch'umila' quic'axan chic c'a ri ch'abel ri xbix el chique ruma ri rey Herodes, xebe. Y ri ch'umil ri quitz'eton pe riye' ri c'a acuchi (achique) quepe wi, pa relebel k'ij, can ruc'uan c'a el quibey. Y tek xe'apon, ri ch'umil ri' xpa'e' pa ruwi' ri acuchi (achique) c'o wi ri ac'al. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y tek xquitz'et c'a ri ch'umil chi xpa'e', sibilaj xquicot ri cánima. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Yac'a tek ri achi'a' ri' xe'oc apo pa jay, can xquitz'et wi c'a ri ac'al y ri María ri rute' ri ac'al, y can yac'ari' xexuque' xemaje' ka riche (rixin) chi xquiya' ruk'ij ri ac'al. Y chuka' can xequijakala' c'a ri quiyaconobal y xquisipaj c'a ca k'anapuek, pon y mirra chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Y ri achi'a' ri c'o quetamabel chiquij ri ch'umila', can xk'alajsex c'a chiquiwech ri pa cachic', chi man chic quetzolin ta pa quibey riche (rixin) chi nbequiya' ca rubixic chare ri rey Herodes. Y can queri' wi xquiben ri achi'a' ri', ruma tek xetzolin chic el pa quiruwach'ulef, xa jun wi chic chi bey ri xquic'uaj el. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y tek ri achi'a' ri c'o quetamabel chiquij ri ch'umila' ye elenak chic el, can yac'ari' tek jun ángel riche (rixin) ri Ajaf Dios xuc'ut ri' chuwech ri José pa rachic'. Y ri ángel ri' xubij chare: Cayacatej c'a el. Tac'uaj el ri ac'al rachibilan ri rute' y quixanmej el wawe'. Quixbiyin c'a pan Egipto y quixc'oje' chila', y riyin xtinya' rubixic chawe tek utz chic yixtzolin pe. Ruma chi re wacami, ri rey Herodes can xtorucanoj wi re ac'al riche (rixin) chi nucamisaj, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y ri José can yac'ari' tek xc'astej, y can chupan c'a ri ak'a' ri' xquichop el bey riche (rixin) chi xebe c'a pan Egipto, xuc'uaj el ri ac'al y ri te'ej. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Can chila' wi c'a pan Egipto xebec'oje' wi y xetzolin pan Israel c'a ya tek caminek chic ri rey Herodes. Riche (rixin) chi queri' can nibanatej na c'a ri ruk'alajsan ri Ajaf Dios chuwech ri jun profeta ri xk'alajsan ri ruch'abel ri Dios ojer ca. Ri tz'ibatal c'a ca nubij: Pan Egipto c'a c'o wi ri nuc'ajol tek xinsiq'uij (xinwoyoj). Quec'ari' ri rubin ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y can yac'ari' tek ri rey Herodes xunabej chi ri achi'a' ri c'o quetamabel chiquij ri ch'umila' xa ma xquiben ta ri achi'el ri rubin el riya' chique, rumari' xyacatej c'a sibilaj royowal y xutek c'a quicamisaxic quinojel ri tak c'ajola' (alaboni') ri xa c'a ma jane nik'ax ta caca' quijuna' ri yec'o chiri' pa tinamit Belén, y ri yec'o pa tak lugar ri yec'o pe chunakajal ri tinamit. Queri' xuben ruma riya' can retaman ca chi c'o chic ca'i' juna' titz'etetej wi ri ch'umil cuma ri achi'a' ri c'o quetamabel chiquij ri ch'umila'. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Wawe' can xbanatej wi c'a achi'el ri tz'ibatal ca ruma ri jun profeta ri xk'alajsan ri ruch'abel ri Dios ojer ca, ri xubini'aj Jeremías, tek xubij ca: ");
INSERT INTO cakWNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Chiri' c'a pa tinamit Ramá xac'axatej ok'ej. Can c'o wi nimalaj bis. C'o c'a jun ri nujik' ok'ej. Ri' ya ri Raquel yerok'ej ri ral, y astape' nibochi'ix, xa can ma nik'ax ta c'a ri bis chare ruma ri ral xecom. Queri' ri tz'ibatal ca ruma ri Jeremías. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y tek caminek chic el ri rey Herodes, can yac'ari' tek ri ángel riche (rixin) ri Ajaf Dios xuc'ut chic ri' chuwech ri José pa rachic', ri chila' pan Egipto. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Y ri ángel riche (rixin) ri Ajaf xubij c'a chare: Cayacatej c'a el. Tac'uaj el ri ac'al rachibilan ri rute' y quixtzolin c'a pan Israel. Ruma ri xe'ajowan chi xquicamisaj ta ri ac'al, xecom yan. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y ri José can xuben wi c'a ri xbix chare pa rachic' ruma ri ángel. Xuc'uaj el ri ac'al, y ri te'ej. Y xetzolin c'a pan Israel. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Xa yac'a riya' tek xrac'axaj chi ya ri Arquelao ri ruc'ajol ca ri rey Herodes ri oconek aj k'atbel tzij pa Judea, xuxibij ri' chi yec'oje' ka ri chiri' pa Judea. Y xk'alajsex c'a chuwech ri José pa jun achic' chi tuc'uaj el ri ac'al y ri te'ej c'a pa Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xe'apon c'a pa tinamit Nazaret y chiri' xec'oje' wi ka, riche (rixin) chi queri' can nibanatej na c'a achi'el ri tz'ibatal ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Riye' can quitz'iban ca chi ri Jesús can c'o na chi nibix nazareno chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chupan c'a ri k'ij ri', ri Juan ri Bautista xuchop ruk'alajsaxic ri ruch'abel ri Dios chiquiwech ri winek ri ye'apon riq'ui, ri chiri' pa jun desierto ri c'o chiri' pa rucuenta ri Judea. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Riya' xubij c'a chique ri winek: Can titzolin c'a pe ic'u'x riq'ui ri Dios, ruma xa nakaj chic c'o wi pe ri rajawaren ri Dios, nicha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Can chrij c'a ri Juan ri' ch'onak wi ca ri profeta Isaías, jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca. Riya' quec'are' ri rutz'iban ca: C'o c'a jun achi ri xtic'oje' pa jun desierto. Y riya' xturek c'a ruchi' riche (rixin) chi xtubij chique ri winek ri xque'apon riq'ui: Tichojmirisaj apo rubey ri Ajaf. Y can choj c'a tibana' chare. Quec'ari' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri rutziak c'a ri Juan ri Bautista banon riq'ui rusmal camello, y rucusan jun tz'um ri oconek ximibel xerupan. Y ri ruway ye c'a ri sac' y ri cab ri niquiya' ri tak chicop pa tak juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y ri winek ri ye'apon c'a riq'ui ri Juan ri Bautista, sibilaj c'a ye q'uiy. Yec'o c'a ri ye aj pa tinamit Jerusalem, ri tinamit ri c'o pa rucuenta ri Judea. Y yec'o chuka' ri aj pa nic'aj chic tinamit riche (rixin) ri Judea. Y chuka' can yec'o c'a ri yepe c'a quela' chunakajal ri raken ya' Jordán. Can quinojel c'a ri winek ri' ri ye'apon riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ri winek c'a ri' yeban c'a el bautizar ruma riya' ri chiri' pa raken ya' Jordán. Y can yequik'alajsaj wi c'a ri quimac. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y tek riya' xutz'et chi can ye q'uiy c'a chique ri achi'a' fariseos y ye q'uiy chuka' chique ri achi'a' saduceos ye'apon riq'ui ruma nicajo' chi yeban el bautizar ruma riya', riya' xubij c'a chique: Riyix xa yix achi'el itzel tak cumatz, ruma niwajo' yixanmej chuwech ri ruc'ayewal. ¿Achique xbin chiwe chi utz yixanmej chuwech ri ruc'ayewal ri xtutek pe ri Dios, re chkawech apo? ");
INSERT INTO cakWNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Riyix rajawaxic c'a chi nik'alajin chupan ri ic'aslen chi can kitzij xtzolin pe ic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man c'a tich'ob ta ka riyix chi can xu (xe) wi ruma chi yix ralc'ual ca ri Abraham, chi ruma ta ri' xquixcolotej, ma que ta ri'. Ruma xa ta ri Dios nrajo', Riya' can nicowin wi nuben ralc'ual ri Abraham chique re abej re ye'itz'et wawe'. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri ruc'ayewal ri nuya' ri Dios xa nipe yan. Riya' can xtuben achi'el nuben jun achi ri c'o chic ri iquej pa ruk'a' riche (rixin) chi xqueruchoy ri che' ri xa ma yewachin ta jabel. Y ronojel c'a ri xqueruchoy el, xqueruq'uek pa k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Riyin, pa ya' yixinben wi bautizar tek nitzolin pe ic'u'x riq'ui ri Dios. Pero c'o c'a jun achi ri xtipe re chkawech apo, ri man achi'el ta oc riyin. Riyin can ma yin ruc'amon ta (takal ta chuwij) riche (rixin) chi nc'uaj ri ruxajab, ruma ri jun achi ri' can más wi nim ruk'ij y can más wi nim ruchuk'a' que chinuwech riyin. Tek Riya' xtipe, can xquixruben wi bautizar riq'ui ri Lok'olaj Espíritu y riq'ui k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Y can ruchojmirisan chic ri' riche (rixin) chi nuben achi'el nuben jun achi tek nujosk'ij ri rutrigo pan era, ri can c'o chic jun horqueta pa ruk'a' riche (rixin) chi nuq'uek chuwacak'ik' ri trigo ri ch'ayon chic. Ri trigo ri nuchayuj ca ri', yari' ri numol y nuyec. Yac'a ri raken ri trigo ri nuc'uaj el cak'ik', xa nuporoj pa k'ak' ri majun bey nichuptej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y yac'ari' tek ri Jesús petenak c'a pa Galilea y xapon riq'ui ri Juan chiri' chuchi' ri raken ya' Jordán. Riya' can petenak c'a riche (rixin) chi niban el bautizar ruma ri Juan ri Bautista. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yac'a ri Juan ma nrajo' ta nuben bautizar ri Jesús, y nubij c'a chare: Xa yin ta riyin ri' ri utz chi yiban bautizar awuma riyit y mani chi can yit c'a riyit ri xatoka wuq'ui riyin, riche (rixin) chi yatinben el bautizar, xcha' ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yac'a ri Jesús xubij chare ri Juan ri Bautista: Riyoj rajawaxic c'a chi nikaben ronojel ri nubij ri Dios chake. Rumari' re wacami rajawaxic c'a chi riyit yinaben bautizar riyin. Y c'ac'ari' tek ri Juan ri Bautista xuben bautizar ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y tek ri Jesús banon chic c'a bautizar, xbe'el pe pa ya'. Y Riya' xutz'et c'a chi ri caj xjakatej y xutz'et chuka' chi ri Lok'olaj Espíritu riche (rixin) ri Dios nika c'a pe pa ruwi' achi'el jun palomax. Can choj wi c'a petenak pa ruwi' Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y can c'o c'a jun ch'abel xpe chila' chicaj y xubij: Yare' ri Nuc'ajol y can sibilaj nwajo', y nucukuban nuc'u'x riq'ui, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Y yac'ari' tek ri Jesús xuc'uex ruma ri Lok'olaj Espíritu riche (rixin) chi xbe c'a pa jun desierto, riche (rixin) chi nitojtobex c'a ruma ri itzel winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tek ri Jesús can cawinek k'ij y cawinek ak'a' chic ri ma waynek ta, yac'ari' tek xpe runumic. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y can yac'ari' tek xpe ri itzel winek nutojtobej ri Jesús, y xubij c'a chare: Wi kas kitzij chi yit c'a riyit ri Ruc'ajol ri Dios, tabana' c'a chique re abej re' chi que'oc caxlan wey, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yac'a ri Jesús xubij c'a chare ri itzel winek: Tz'ibatal ca chupan ri ruch'abel ri Dios, chi ma xu (xe) ta wi riq'ui caxlan wey nic'ase' wi ri winek, xa can nic'ase' chuka' riq'ui ronojel ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y yac'ari' tek ri itzel winek xuc'uaj ri Jesús c'a chupan ri lok'olaj tinamit Jerusalem, y c'a pa ruwi' ri rachoch ri Dios xberuya' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","C'ac'ari' tek ri itzel winek xubij chare ri Jesús: Wi kas kitzij chi yit Ruc'ajol ri Dios, tac'aka' ka awi' pa xulan. Ruma chupan ri ruch'abel ri Dios tz'ibatal ca, nubij: Ri Dios can xquerutek pe ri ru'ángeles awuq'ui riche (rixin) chi yatquichajij. Xcatquili'ej pa quik'a', riche (rixin) chi queri' ma xtachak'ij (xtatoch') ta awaken chuwech abej, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yac'a ri Jesús xubij chare ri itzel winek: Riyin ma nben ta ri narayij riyit. Ruma tz'ibatal ca chuka' chupan ri ruch'abel ri Dios chi ma tatojtobej ta ri Awajaf Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y ri itzel winek xuc'uaj chic c'a ri Jesús c'a pa ruwi' jun juyu' ri nej jotol chicaj, y xuc'ut c'a chuwech ronojel ri cajawaren y ri quic'ojlen ri nima'k tak tinamit ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y yac'ari' tek ri itzel winek xubij c'a chare ri Jesús: Can ronojel c'a re xinc'ut chawech xtinya' chawe, wi yaxuque' yamaje' chinuwech riche (rixin) chi naya' nuk'ij, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yac'ari' tek ri Jesús xubij chare: Cabiyin quela' riyit Satanás. Ruma chupan ri ruch'abel ri Dios ri tz'ibatal ca, nubij: Xaxu (xaxe wi) c'a ri Ajaf Dios taya' ruk'ij, y xaxu (xaxe wi) chuka' Riya' ri ruc'amon chi nanimaj ri nubij, xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y yac'ari' tek ri itzel winek xuya' ca ri Jesús. Y xe'oka ri ángeles riq'ui ri Jesús, y xquichop niquinimaj niquilij. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y tek ri Jesús xrac'axaj chi ri Juan ri Bautista xchapatej y xya'ox (xya') pa cárcel, yac'ari' tek ri Jesús xtzolin chic pa ruwach'ulef Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero xa ma xc'oje' ta ka pa tinamit Nazaret, xa xuya' ca ri tinamit ri', riche (rixin) chi xbec'oje' pa jun tinamit ri Capernaum rubi'; jun tinamit ri c'o chuchi' jun choy. Ri Capernaum ri' pa culef ri ye quiy quimam ca ri Zabulón y ri Neftalí c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ri Jesús xapon c'a chupan ri jun tinamit ri', riche (rixin) chi queri' nibanatej ri tz'ibatal ca ruma ri profeta Isaías, ri achi ri xk'alajsan ri ruch'abel ri Dios ojer ca. Y riya' rubin c'a ca: ");
INSERT INTO cakWNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ri winek ri yec'o pa culef ca ri ye riy rumam ri Zabulón y ri yec'o ri pa culef ca ri ye riy rumam ri Neftalí; ri acuchi (achique) nik'ax wi ri bey ri nibe chuchi' mar, ri juc'an chic ruchi' ri raken ya' Jordán. Ri chila' pa Galilea, acuchi (achique) xa juba' ma quiyon chic winek ri ma ye israelitas ta yec'o. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Can ye tinamit c'a ri achi'el pa k'eku'm yec'o wi, y xapon c'a ri Nimalaj Sakil quiq'ui. Y chuka' can ye tinamit c'a ri pa rumujal ri camic yec'o wi, y xapon c'a quiq'ui ri nisakirisan quiche (quixin). Queri' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y tek ri Jesús xapon ri pa tinamit Capernaum, can yac'ari' tek xuchop rutzijoxic ri ruch'abel ri Dios y nubij c'a chique ri winek: Can titzolin c'a pe ic'u'x riq'ui ri Dios, ruma xa can nakaj chic c'o wi pe ri rajawaren ri caj, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y tek ri Jesús benak c'a chuchi' ri choy Galilea, xerutz'et c'a ye ca'i' achi'a' cach'alal qui'. Ri ca'i' achi'a' ri', ya ri Simón ri nibix chuka' Pedro chare, rachibilan ri Andrés ri rach'alal. Riye' can ye aj chapoy car wi, rumari' tek yetajin niquiq'uek ka ri quiya'l chapabel car chupan ri choy. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y tek ri Jesús xch'o quiq'ui ri ca'i' aj chapoy tak car ri', xubij chique: Quinitzekelbej y xtinc'ut chiwech achique rubanic ye'ich'ec pe winek riche (rixin) chi yinquitzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ri ca'i' achi'a' ri', can yac'ari' xquiya' ca ri chapoj car y xquitzekelbej el. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","C'a juba' c'a quebiyin apo, tek ri Jesús xerutz'et c'a ye ca'i' chic achi'a' ri cach'alal qui'. Y ri ca'i' achi'a' ri', ya ri Jacobo y ri Juan ri ye ruc'ajol ri jun achi Zebedeo rubi'. Riye' can ya c'a ri pa jucu' yesamej wi riq'ui ri Zebedeo ri quitata', yequic'ojoj c'a ri quiya'l chapabel car. Y xpe c'a ri Jesús xerusiq'uij (xeroyoj) riche (rixin) chi niquitzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y ri Jacobo y ri Juan, ri ye ca'i' achi'a' ri', can yac'ari' tek xquiya' ca ri quijucu' y ri quitata' y xquitzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús can ronojel tinamit ri yec'o pa rucuenta ri Galilea xapon wi, nuc'ut c'a ri ruch'abel ri Dios chiquiwech ri winek pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, nutzijoj c'a ri lok'olaj ch'abel ri nich'o chrij ri rajawaren ri Dios. Yeruc'achojsaj c'a winek ri jalajoj chi yabilal y k'axon ntoc chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri rutzijol ri Jesús xapon c'a pa ronojel tinamit ri yec'o pa rucuenta ri Siria. Y ri ye yawa'i' xec'amer c'a pe chuwech ri Jesús riche (rixin) chi yeruc'achojsaj el, yawa'i' ri ma junan ta ruwech yabil ntoc chique. Yec'o ri can k'axon c'a riche (rixin) ri ch'aculaj ri ntoc chique. Yec'o ri xa itzel tak espíritu ri ye oconek quiq'ui. Yec'o c'a ri ye ch'u'j y yec'o c'a chuka' ri ye siquirnek. Y can quinojel c'a ri yawa'i' ri' xeruc'achojsaj el. ");
INSERT INTO cakWNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y ri Jesús can xtzekelbex c'a cuma sibilaj ye q'uiy winek ri ye petenak pa tak tinamit ri yec'o pa rucuenta ri Galilea, cuma chuka' ri ye petenak pa tak tinamit ri yec'o pa rucuenta ri Decápolis, ri yepe pa Jerusalem y ri ye petenak pa nic'aj chic tinamit ri yec'o pa rucuenta ri Judea. Y can queri' chuka', xtzekelbex cuma sibilaj ye q'uiy winek ri ye petenak c'a juc'an chic ruchi' ri raken ya' Jordán. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y tek ri Jesús xerutz'et chi ye sibilaj ye q'uiy winek ri quimolon qui', Riya' xjote' c'a pa ruwi' jun juyu', y xtz'uye' c'a ka. Y c'ac'ari' xquimol apo qui' ri ye rudiscípulos riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y yac'ari' tek ri Jesús xuchop nitzijon riche (rixin) chi yerutijoj, y xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jabel ruwaquik'ij ri winek ri can niquina' pa cánima chi nic'atzin ri Dios chique, ruma quiche (quixin) riye' ri rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Jabel ruwaquik'ij ri ye'ok' chuwech ri Dios, ruma riye' xquebochi'ix ruma ri Dios. Y xquequicot. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Jabel ruwaquik'ij ri ch'uch'uj cánima, ruma riye' xtoc quiche (quixin) ri ruwach'ulef ri rutzujun (rusujun) ca ri Dios chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Jabel ruwaquik'ij ri can ninum y nic'at cánima chrij ri chojmilaj c'aslen riq'ui ri Dios, ruma ri Dios xtuben c'a chique chi xtich'uch'u' ka ri cánima. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Jabel ruwaquik'ij ri can niquijoyowaj quiwech ri winek, ruma riye' can xtijoyowex chuka' quiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Jabel ruwaquik'ij ri ch'ajch'oj cánima, ruma riye' can xtiquitz'et c'a ruwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Jabel ruwaquik'ij ri c'o cánima riche (rixin) chi yequibochi'ij ri yebano oyowal, ruma riye' xtibix chique chi ye ralc'ual ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Jabel ruwaquik'ij ri niquik'axaj tijoj pokonal pa quik'a' nic'aj chic, ruma can choj wi ri quic'aslen chuwech ri Dios. Can jabel wi ruwaquik'ij, ruma chi quiche (quixin) riye' ri rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Jabel ruwa'ik'ij tek wuma riyin yixyok' y tek ri winek itzel niquina' chiwe, y niquibij ronojel itzel chiwij, y tek wuma riyin nitz'uculux tzij chiwij. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Rumari' riyix quixtze'en y quixquicot c'a, ruma nim rajel ruq'uexel ri xtic'ul chila' chicaj. Ruma ri tijoj pokonal ri nik'axaj riyix wacami, can queri' chuka' xquik'axaj ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, achi'a' ri xec'oje' el nabey que chiwech riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yix c'a riyix ri ratz'amil ri quic'aslen ri winek ri yec'o chuwech re ruwach'ulef. Y wi ta re achi'el atz'an re' niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic niban chare riche (rixin) chi queri' nitzolin ta chic pe ri ratz'amil? Xa majun chic c'a nic'atzin wi; xa can nirokix el, y nipalbex cuma ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Riyix can yix sakil riche (rixin) ri quic'aslen ri winek chuwech re ruwach'ulef, y yixk'alajin jabel, achi'el nik'alajin pe jun tinamit ri c'o pa ruwi' jun juyu' y ma nicowin ta nrewaj ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Riyix tek nitzij jun k'ak', majun bey niya' ta oc chuxe' jun almul, ma que ta ri'. Riyix xa nicanoj jun ruc'ojlibel ri nitz'uyuba' wi, riche (rixin) chi queri' can yerusakirisaj c'a quinojel ri yec'o pa jay. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Can queri' ta c'a nuben ri ic'aslen riyix chiquiwech ri winek; can jun ta c'a sakil. Riche (rixin) chi queri' niquitz'et ta c'a ri utz ri ye'ibanala', y ri winek can xtiquiya' c'a ruk'ij ruc'ojlen ri Itata' ri c'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man c'a tich'ob ta chi riyin xipe riche (rixin) chi majun ruk'ij nben chare ri ley riche (rixin) ri Moisés, y chuka' ma tich'ob ta chi riyin xipe riche (rixin) chi queri' chuka' nben chique ri ye tz'ibatal ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Ma que ta ri'. Riyin xipe riche (rixin) chi nbek'alajin pe jabel ri kas nubij ri ley y ri quitz'iban ca ri profetas. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ruma kas kitzij nbij chiwe chi ronojel ri tz'ibatal ca chupan ri ley riche (rixin) ri Moisés, can xquebanatej wi. Re ruwach'ulef y ri caj xa xquek'ax. Pero ri ye tz'ibatal chupan ri ley can xquebanatej wi ronojel, y can majun ri man ta xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xabachique winek ri ma nrajo' ta nuben jun chique ri pixa' ri nubij chupan ri ley, astape' jun pixa' ri achi'el xa ma nim ta rejkalen y can queri' chuka' nuc'ut chiquiwech ri winek, ri nibano c'a queri', ma nim ta oc ruk'ij ri xtic'oje' pa rajawaren ri caj. Yac'a ri winek ri can nuben wi ronojel ri pixa' ri nubij chupan ri ley y can queri' chuka' nuc'ut chiquiwech ri winek, riya' can nim c'a ruk'ij xtic'oje' pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nbij c'a chiwe, riyix can rajawaxic chi nic'uaj jun ic'aslen ri más choj que chuwech ri quic'aslen ri ye aj tz'iba' y chuwech ri quic'aslen ri fariseos. Ruma wi ma que ta ri' xtiben, ma xquixoc ta pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Y riyix can jabel iwetaman, ruma iwac'axan ri xbix chique ri xec'oje' ojer ca, chi ma quecamisan ta. Y xabachique c'a winek ri nicamisan, can aj mac wi y c'o chi nik'at tzij pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yac'a riyin nbij chi xabachique ri nipe royowal chare jun chic rach'alal, can aj mac wi y can utz wi chi nik'at tzij pa ruwi'. Chuka' xabachique ri nibin chare jun chic rach'alal: Majun ana'oj, nicha' chare; ri nibin queri', can aj mac wi chuka', rumari' can utz chi nuc'uex chiquiwech ri achi'a' ri pa moc (comon) yek'ato tzij riche (rixin) chi nik'at tzij pa ruwi'. Y xabachique ri nibin nacanic chare jun chic rach'alal, ri' xa can utz wi chi nibe pa k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Rumari' wi riyit can yitc'o chic apo riq'ui ri altar riche (rixin) chi naya' jun ofrenda chare ri Dios y yari' tek ninatej chawe chi riyit c'o jun pokon abanon chare jun awach'alal, ");
INSERT INTO cakWNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taya' c'a ca ri ofrenda chiri' chuwech ri altar y cabiyin riq'ui ri jun awach'alal ri', jac'utuj acuybel mac chuwech. Y tek achojmirisan chic ca y junan chic iwech, c'ac'ari' catzolin y taya' ri ofrenda chare ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Can tachojmirisaj c'a awi' chanin riq'ui ri ac'ulel ri yatuc'uan chuwech ri aj k'atbel tzij, tek xa c'ac'ari' ichapon el bey pa k'atbel tzij. Ruma wi xa ma que ta ri' xtaben, ri nitzujun (nisujun) chawij xcarujech pa ruk'a' ri aj k'atbel tzij, y ri aj k'atbel tzij ri' xcarujech el pa ruk'a' ri aj ch'ame'y y ri aj ch'ame'y xcaberutz'apij ca pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y can kitzij wi nbij chawe, chi can ma xcatel ta pe chiri' pa cárcel, c'a ya tek atojon chic na ca ri ruq'uisbel centavo ri nibix chawe chi natoj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Riyix can jabel iwetaman, ruma can iwac'axan ri tzij bin ca ojer. Ri tzij ri' nubij: Jun achi ri c'o rixjayil, man c'a tucanoj ta jun chic ixok. Y jun ixok ri c'o rachijil, man c'a tuc'om ta ruwech jun chic achi. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Yac'a riyin nbij chi xabachique c'a achi ri nutzu' jun ixok y can nurayij ruwech; ri nibano queri', pa ránima xa can xmacun yan c'a riq'ui ri jun ixok ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Rumac'ari' wi xa jun runak' awech nibano chawe chi yamacun, tawelesaj y tarokij el, astape' can ya ri runak' awech ri c'o pan awajquik'a'. Ruma xa más utz chi xaxu (xaxe wi) jun chique ri runak' awech nawelesaj el que chuwech chi can tz'aket ak'a' awaken y xa pa k'ak' yatbec'ak wi ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuka' wi xa jun chique ri ak'a' nibano chawe chi yamacun, más ta utz chi nachoy y narokij el, astape' can ya ri awajquik'a'. Ruma xa más utz chi xaxu (xaxe wi) jun chique ri ak'a' nawelesaj el que chuwech chi can tz'aket ak'a' awaken y xa pa k'ak' yatbec'ak wi ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y chuka' bin ri ojer ca: Ri achi ri can jurayil nujech ri' riq'ui ri rixjayil; tutz'ibaj jun wuj y tubij chupan ri wuj ri' chi xquijech qui' y tuya' el chare ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yac'a riyin nbij chiwe: Ri achi ri nujech ca ri rixjayil y xa ma ruma ta chi ri ixok xuc'om ruwech jun chic achi; ri achijlon ri' can nuben wi c'a chare ri rixjayil chi nimacun tek nibe chic riq'ui jun achi. Ri achijlon ri' can nimacun wi, y queri' chuka' ri jun chic achi ri nic'amo ri ixok ri jachon ca, can nimacun c'a chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Y chuka' riyix xa can jabel iwetaman, ruma iwac'axan ri xbix chique ri ojer tak winek, chi ma tiquik'ej ta ri quitzij. Y queri' chuka' tek niquiben jurar, ma tiquik'ej ta ri quitzij. Y tek c'o ri niquitzuj (niquisuj) chare ri Ajaf chi niquiben, can tiquibana' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yac'a riyin nbij chiwe: Majun bey tiben ta jurar, ni ma tinataj ta ri caj ruma chi niben jurar, ruma ya ri chila' chicaj tz'uyul wi ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Y ma tinataj ta ri ruwach'ulef, ruma ya ri chiri' nuya' wi ri raken ri Dios. Ni ma tinataj ta chuka' ri tinamit Jerusalem, ruma ri tinamit ri' riche (rixin) ri Nimalaj Rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Y chuka' ma tinataj ta ri ijolon (iwi') ruma chi niben jurar. Ruma ma yixcowin ta niben sek o k'ek chare jun rusmal iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ronojel ri nibij, can choj c'a tibij, wi kitzij ri nibij o xa ma kitzij ta. Can majun bey c'a tiben ta jurar, ruma ronojel ri' xa riq'ui ri itzel nipe wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Y riyix can jabel iwetaman, ruma iwac'axan ri xbix ojer ca, chi ri nelesan jun runak' ruwech jun winek, can queri' c'a chuka' tiban chare ri xbano. Ri nik'ajo el rey jun winek, can queri' c'a chuka' niban chare ri xbano. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Yac'a riyin nbij chiwe: Xa ticoch'o' ri nibano jun pokon chiwe. Wi xa c'o c'a jun ri xupak'ij juc'an apalej chi k'a' ri c'o pan awajquik'a', xa taya' chic apo ri juc'an apalej chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y wi c'o c'a jun winek ri yarutzujuj (yarusujuj) pa k'atbel tzij ruma nrajo' nrelesaj jun atziak, can man c'a tapokonaj ta naya' ca chare; y xa can taya' c'a ca chuka' ri achaqueta chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O wi c'o c'a jun chiwe riyix ri niban puersa chare ruma jun winek chi tuc'uaj jun ejka'n c'a pa jun kilómetro, xa can tiquicot c'a tuc'uaj el ri ejka'n ri', y chuka' ma tupokonaj ta chi nuc'uaj jun kilómetro chic ri ejka'n ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y wi c'o c'a jun chiwe riyix ri c'o nic'utux chare ruma jun winek, can tuya' c'a el chare. Y wi c'o chuka' jun ri c'o nrajo' nukej el chare, ma tupokonaj ta nuya' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Riyix can jabel iwetaman, ruma iwac'axan ri tzij ri bin ojer ca. Ri tzij ri' nubij: Can utz wi chi que'awajo' ri awuc' awach'alal. Yac'a ri ye'etzelan awuche (awixin), can que'awetzelaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Yac'a riyin nbij chiwe: Can que'iwajo' c'a ri ye'etzelan iwuche (iwixin); tic'utuj c'a chare ri Dios chi yeruben ta bendecir ri winek ri yerayin itzel pan iwi'; tibana' utzil chique ri xa ma utz ta quina'oj iwuq'ui riyix; y tibana' chuka' orar pa quiwi' ri ye'okotan y yeyok'o iwuche (iwixin). ");
INSERT INTO cakWNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Riche (rixin) chi queri' can nik'alajin wi chi riyix yix ralc'ual ri Itata' ri c'o chila' chicaj. Ruma Riya' can utz wi c'a pa quiwi' quinojel. Riya' nuben pe chi ri k'ij nitzu'un pe pa quiwi' ri winek ye utz y pa quiwi' ri winek ri xa ye itzel; y chuka' nuya' pe job pa quiwi' ri winek ri choj quic'aslen y pa quiwi' ri ma choj ta quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ruma wi riyix xaxu (xaxe wi) ri winek ri ye'ajowan iwuche (iwixin) ri ye'iwajo', ¿la can c'o ta cami rajel ruq'uexel xtic'ul? Ruma ri c'utuy tak alcawal queri' chuka' niquiben; riye' yecajo' xaxu (xaxe wi) ri ye'ajowan quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y wi xaxu (xaxe wi) ri iwach'alal ye'ik'etela' tek niya' rutzil quiwech, ¿achique ta chic c'a ri más rejkalen ri yixtajin chubanic riyix? Majun. Ruma ri winek ri ma quetaman ta ruwech ri Dios can queri' chuka' niquiben riye'. ");
INSERT INTO cakWNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Riyix can choj tibana' riq'ui ri ye'ibanala' achi'el nuben ri Itata' ri c'o chila' chicaj. Riya' can choj wi riq'ui ri yerubanala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Can tichajij c'a iwi' jabel, chi ma xaxu (xaxe) ta riche (rixin) chi utz yixtz'etetej cuma ri winek tek niben ri nrajo' ri Dios, ri' ma utz ta. Ruma wi xa queri' niben, can majun c'a rajel ruq'uexel xtic'ul riq'ui ri Itata' ri c'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Tek riyix niya' limosna chare jun winek, man c'a tiwelesaj ta rutzijol, ma tixupuj ta trompeta riche (rixin) chi nac'axex cuma ri winek. Ma tiben ta achi'el ri niquiben ri winek ri xa ca'i' quipalej. Riye' can niquelesaj rutzijol pa tak bey y pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, riche (rixin) chi netamex chi c'o utzil ri yetajin chubanic. Can kitzij wi nbij chi ri winek ri yebano queri', riq'ui ri xquic'ul quik'ij chique ri winek, xa can xquic'ul yan c'a rajel ruq'uexel ri yequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yac'a tek riyix niya' limosna, man c'a titzijoj ta chare jun chic. Can majun c'a nic'atzin wi chi nretamaj ta na jun chic winek ri yixtajin chubanic. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Riche (rixin) chi queri' ri limosna ri niya', majun c'a winek netaman. Yac'a ri Itata' ri c'o chila' chicaj, Riya' retaman. Riya' can nutz'et ri ma tz'etetel ta cuma ri winek y xtuya' rajel ruq'uexel chiwe. Y ri rajel ruq'uexel ri xtuya' chiwe, can xtik'alajin c'a chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Riyix tek niben c'a orar, ma tiben ta achi'el niquiben ri winek ri xa ca'i' quipalej. Ruma ri winek ri' can sibilaj c'a nika chiquiwech chi ya ri acuchi (achique) yec'o wi winek, chiri' niquiben wi orar. Tek niquiben orar, can yepa'e' pa tak jay ri kas nic'ut wi ruch'abel ri Dios, y ri pa tak xquina riche (rixin) ri bey xaxu (xaxe) wi riche (rixin) chi yetz'et cuma ri winek. Y can kitzij wi nbij chiwe, chi ri winek ri yebano queri', riq'ui ri niquic'ul quik'ij chique ri winek, xa can xquic'ul yan c'a rajel ruq'uexel ri yequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Y tek jun c'a chiwe riyix nuben orar, utz ntoc pa rachoch y tutz'apij ruchi' ri rachoch y c'ac'ari' tich'o riq'ui ri Dios Tata'ixel ri c'o chila' chicaj. Y astape' ma nutz'et ta ri achoj riq'ui nich'o wi, can retaman chi c'o ri nac'axan pe riche (rixin). Y ri nac'axan pe riche (rixin) can nutz'et wi c'a ri ma tz'etetel ta cuma ri winek y nuya' rajel ruq'uexel chare. Y ri rajel ruq'uexel ri xtuya' chare, can xtik'alajin c'a chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tek riyix niben c'a orar, ma tiben ta achi'el niquiben ri winek ri ma quiniman ta ri Dios. Ruma riye', niquicamuluj ch'abel y q'uiy ch'abel niquibij ruma riye' niquich'ob chi riq'ui ri' ye'ac'axex pe ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Tek riyix niben orar, ma tiben ta achi'el niquiben ri winek ri ma quiniman ta ri Dios. Ruma chi ri Itata' ri c'o chila' chicaj, can retaman chic c'a ri achique ri rajawaxic chiwe, tek c'a ma jane nic'utuj ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tek riyix niben orar, tibana' jun oración achi'el re': Katata' Dios yitc'o chila' chicaj, xtibanatej ta c'a chi quinojel ta ri winek niquiya' ta ak'ij, y man ta xtiquixolk'otij ri lok'olaj abi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y xtipe yan ta c'a ri awajawaren. Y can ya ta c'a ri nawajo' riyit ri xtibanatej wawe' chuwech re ruwach'ulef, achi'el nibanatej chila' chicaj awuq'ui riyit. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y taya' c'a chuka' ri kaway ri nic'atzin chake ronojel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y xtacuy ta c'a ronojel ri kamac ri yekaben chawech, achi'el yekacuy ri winek ri c'o pokon niquiben chake. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man c'a taya' ta k'ij chi ri itzel nuben ta chake chi yojtzak pa mac. Xa can kojacolo' c'a chuwech. Queri' ri nikac'utuj, ruma xaxu (xaxe) wi c'a riyit ri yitc'o pa kawi', c'o awuchuk'a', y c'o ak'ij ac'ojlen riche (rixin) xtibe k'ij xtibe sek. Amén. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wi riyix ye'icuy ri winek ri c'o pokon niquiben chiwe, ri Itata' ri c'o chila' chicaj can xquixrucuy c'a chuka' riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Y wi ma nicuy ta quimac ri winek ri c'o pokon niquiben chiwe, chuka' ri Itata' ri c'o chila' chicaj ma xtucuy ta ri imac ri ye'ibanala' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Tek riyix ma yixwa' ta riche (rixin) chi niben orar, ma tiben ta achi'el niquiben ri winek ri xa ca'i' quipalej; ruma riye' xa yebison ri yetzu'un, riche (rixin) chi can nik'alajin chiquiwech ri winek chi ma ye waynek ta. Y kitzij nbij chiwe, chi ri yebano queri', riq'ui ri niquic'ul quik'ij chique ri winek, xquic'ul yan c'a ri rajel ruq'uexel. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Yac'a tek riyix ma yixwa' ta riche (rixin) chi niben orar, ma tiben ta chi can nik'alajin apo chi ma yix waynek ta, xa jabel tich'aja' ipalej, tiya' juba' aceite pan iwi' y jabel tijica' rusmal tak iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Riche (rixin) chi queri', ma tik'alajsaj ta iwi' chiquiwech ri winek chi ma ibanon ta wa'in ruma niben orar. Xaxu (xaxe) wi ri Tata'ixel ri ma tz'etetel ta ri netaman chi ma ibanon ta wa'in. Riya' can nutz'et c'a ri ma tz'etetel ta cuma ri winek y xtuya' rajel ruq'uexel chiwe. Ri rajel ruq'uexel ri xtuya' chiwe, can xtik'alajin chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man c'a timol ta ibeyomal chuwech re ruwach'ulef, ri xa nichicopir y chuka' xa nipusir, y ri acuchi (achique) xa yec'o alek'oma' ri ye'elek'an y ye'elesan el. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Timolo' ibeyomal riche (rixin) chila' chicaj ri acuchi (achique) ma nichicopir ta y ni ma nipusir ta, ri acuchi (achique) chuka' majun alek'om ri nelek'an y nelesan el. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ruma ri iwánima can nic'oje' acuchi (achique) c'o wi ri ibeyomal. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri runak' tak awech can yec'atzin c'a chawe, achi'el nic'atzin jun k'ak' riche (rixin) sakil. Y wi ri runak' tak awech ye utz, riyit yitc'o pa jun sakil. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Yac'a wi ri runak' tak awech ma ye utz ta, riyit yitc'o pa jun k'eku'm. Rumari' wi xa nichuptej ri sakil ri ruya'on ri Dios pan awánima, can pa jun nimalaj k'eku'm yac'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Majun c'a mozo ri nicowin ta nisamej quiq'ui ye ca'i' patrón. Ruma wi nrajo' jun chique ri rupatrón, nretzelaj ca ri jun chic. Y wi can sibilaj nunimaj rutzij ri jun, can nretzelaj ri jun chic. Y quec'ari' chuka', ri winek ri xa benak ránima chrij ri beyomel, ma nicowin ta nuben ri nrajo' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Y rumari' tek riyin nbij chiwe: Ma tich'ujirisaj ta iwi' chupan ri ic'aslen chi acuchi (achique) nipe wi ri iway iwuc'ya', ni ruma ta ri itziak ri nicuchbej ri ich'acul. ¿La ma ya ta cami ri ic'aslen ri ruya'on ri Dios ri más rejkalen que chuwech ri iway iwuc'ya'? ¿La ma ya ta cami ri ich'acul ri más rejkalen que chuwech ri itziak? ");
INSERT INTO cakWNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Que'itz'eta' na pe' ri aj xic' tak chicop ri yebe pa cak'ik', riye' majun quitico'n niquiben ta, y majun cosecha niquelesaj, ni majun chuka' quic'ujay riche (rixin) chi quiyacon ta quijal. Ma riq'ui wi ri' riye' can yewa', ruma ya ri Itata' ri c'o chila' chicaj ri niya'o quiway. ¿C'a ta c'a riyix man ta xtuya' iway ri Dios, tek riyix más iwejkalen que chiquiwech ri aj xic' tak chicop? ");
INSERT INTO cakWNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿La c'o ta cami c'a jun chiwe riyix ri nicowin chi niq'uiy chic nic'aj vara ri rupalen, ruma can nuch'ujirisaj ri'? Majun. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y achique c'a ruma tek nich'ujirisaj iwi' ruma ri itziak? Ri Dios retaman nuya' itziak. Xaxu (xaxe) na pe' que'itzu' ri cotz'i'j ri lirio quibi', ri yec'o pa tak juyu'. Que'itzu' tek yeq'uiy. Riye' ma yesamej ta, ni ma yebatz'in ta, riche (rixin) chi queri' yequibanala' ta quitziak ri ye jabel oc. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Y c'o c'a jun rey riche (rixin) re ruwach'ulef Israel ri xc'oje' ojer ca ri xubini'aj Salomón. Riya' ruyon jabel tak tziek ri xerucusaj, pero majun bey xucusaj ta jun rutziak ri can achi'el jun cotz'i'j. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wi ri k'ayis riche (rixin) pa juyu' wacami jabel oc rubanon, yac'a ri chua'k xa chaki'j chic y nic'ak pa k'ak', y ma riq'ui wi ri' ri Dios yeruwik, ¿c'a ta c'a riyix winek chi man ta xtuya' itziak ri Dios? ¿Achique c'a ruma tek xa ma nicukuba' ta ic'u'x riq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Riyix man c'a tich'ujirisaj ta iwi' ruma iway iwuc'ya' y ruma ri itziak. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ruma ri winek ri ma quetaman ta ruwech ri Dios queri' niquiben, yac'a riyix c'o ri Itata' chila' chicaj y retaman chi ronojel ri' nic'atzin chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rumari' ri más rajawaxic chi niben riyix, ya ri ticanoj ri rajawaren ri Dios y ri achique rubanic nic'uaj jun c'aslen choj chuwech. Y wi queri' xtiben, ri Dios can xtuya' c'a pe ronojel ri nic'atzin chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Riyix ma nic'atzin ta chi nich'ujirisaj iwi' ruma nich'ob yan riche (rixin) ri chua'k. Ri chua'k can c'o wi ri xtuc'om pe. Tiya' c'a ca riche (rixin) chua'k, ruma ronojel k'ij can c'o wi ruc'ayewal nuc'om pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Majun bey titzu' ta achique quibanic ri winek xaxu (xaxe wi) riche (rixin) chi itzel yixtzijon chiquij, riche (rixin) chi queri' ma xtiban ta chuka' queri' chiwe riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ruma wi ye'itzu' ri winek xaxu (xaxe wi) riche (rixin) chi itzel yixtzijon chiquij, can queri' chuka' xtiban chiwe riyix. Can achi'el wi c'a rubanic ri niben riyix chique ri winek, can queri' chuka' xtiban chiwe riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Y riyit, ¿achique ruma tek ya ri ti k'ayis c'o pa runak' ruwech ri awach'alal ri natz'et chanin y ma nana' ta ri che' ri k'atel pa runak' awech riyit? ");
INSERT INTO cakWNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Achique ta c'a modo nabij chare jun awach'alal: Taya' k'ij chuwe riche (rixin) chi nwelesaj re ti k'ayis k'atel pa runak' awech, yacha' chare, y riyit xa can jun che' ri k'e'el pa runak' awech? ");
INSERT INTO cakWNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Xa ca'i' apalej, nabey na tachojmirisaj ka ri ac'aslen riyit, c'ac'ari' utz nato' ri awach'alal chi nuchojmirisaj ri ruc'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ri lok'olaj ruch'abel ri Dios y ronojel ri c'o quejkalen, ri achi'el quejkalen ri abej ri nibix perla chique, ma que'iya' ta chiquiwech ri winek ri xa ye achi'el ri tz'i' y ye achi'el ri ak. Ruma ri chicop ri', astape' sibilaj quejkalen ri niya'ox (nya') chique, riye' xa niquipalbela' chi aken y c'o jantek yeyacatej chrij ri xya'o chique y niquic'ajij chi eyaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Can tic'utuj c'a ri nic'atzin chiwe y ri Dios can xtuya' wi pe chiwe. Ticanoj ri niwajo' y xtiwil. Quixsiq'uin (quixoyon) apo chuchi' jay y xquixac'axex pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ruma wi riyix can riq'ui ronojel iwánima nic'utuj chare ri Dios, Riya' can xtuya' wi pe chiwe. Wi riyix can nicanoj, can xtiwil wi. Y wi riyix yixsiq'uin (yixoyon) apo chuchi' jay, can xtojak wi c'a chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿La c'o ta cami jun achi ri nuya' jun abej pa ruk'a' ri ralc'ual, tek ri ac'al xa jun caxlan wey ri nuc'utuj chare? ");
INSERT INTO cakWNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O la nuya' ta cami jun itzel cumatz pa ruk'a', tek ri ac'al xa jun car nrajo'? ");
INSERT INTO cakWNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Riyix majun bey niben ta queri'. Y astape' ta chi ma can ta utz ri ina'oj, pero riyix ya ri utz tak cosas ri niya' chique ri iwalc'ual. C'a ta c'a ri Itata' ri c'o chila' chicaj, chi man ta xtuya' pe ri nic'utuj chare. Riya' ronojel utz ri nuya' pe chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Rumac'ari' ri achi'el niwajo' riyix chi ri winek utz niquiben iwuq'ui, can quec'ari' tibana' riyix quiq'ui riye'. Ruma queri' ri tz'ibatal chupan ri ley riche (rixin) ri Moisés, y queri' chuka' quibin ca ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Chupan c'a ri puerta ri xa co'ol ruwech, chiri' c'a quixoc wi. Ruma can nim wi ruwech ri puerta riche (rixin) ri itzel c'aslen, ri nic'amo pe ri camic riche (rixin) xtibe k'ij xtibe sek, y sibilaj c'a ye q'uiy ri ye'oc chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero xa co'ol ri puerta y co'ol oc ruwech ri bey ri yatuc'uan pa utzilaj c'aslen, y ma ye q'uiy ta oc ri ye'ilo. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Rumari' nic'atzin nichajij iwi' chiquiwech ri winek ri yebin chi niquik'alajsaj ri ruch'abel ri Dios y xa ma kitzij ta ri niquibij. Ruma tek xa can c'ari' ye'apon iwuq'ui, niquic'ut chi can jabel ri quic'aslen, achi'el quibanic ri tak carne'l; can majun itzel nitz'etetej ta chiquij. Yac'a tek nbec'ulun pe ri etzelal ri c'o pa tak cánima, xa ye achi'el chic quibanic ri utiwa' (coyotes); yequiq'uis c'a ri achoj quiq'ui ye'apon wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Can xtiwetamaj wi quiwech, achi'el tek niwetamaj ruwech juwi' che', xaxu (xaxe) wi riq'ui nitz'et rubanic ri ruwech ri nuya'. Tek niwachin jun k'ayis ri c'o q'uiy ruq'uixal, ma xtuya' ta uva o higo. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Queri' c'a chuka' iwetaman chi jun utzilaj che' nuya' utzilaj tak ruwech, yac'a ri itzel che', itzel chuka' ri ruwech ri nuya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Majun utzilaj che' xtuya' ta itzel tak ruwech, ni majun chuka' itzel che' ri xtuya' ta utzilaj tak ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y ronojel c'a che' ri ma niquiya' ta utzilaj tak quiwech, yechoy el y c'ac'ari' yec'ak pa k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Rumac'ari' can xtiwetamaj quiwech ri winek ri ye'apon iwuq'ui, xaxu (xaxe wi) riq'ui nitz'et ri rubanic ri quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ma quinojel ta ri yebin ¡Ajaf! ¡Ajaf! chuwe, ri ye'oc pa rajawaren ri caj. Ruma xaxu (xaxe) wi c'a ri can riq'ui ronojel cánima niquiben ri ruraybel ri Nata' ri c'o chila' chicaj ri ye'oc chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupan c'a ri k'ij tek riyin xtink'et tzij pa quiwi' ri winek, ye q'uiy c'a ri xquebin chuwe: ¡Ajaf! ¡Ajaf! xquecha', riyoj pan abi' riyit xkak'alajsaj wi ri ruch'abel ri Dios, pan abi' riyit xekelesaj itzel tak espíritu quiq'ui q'uiy winek y pan abi' chuka' riyit xekabanala' sibilaj q'uiy milagros, xquecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero riyin, can yac'ari' tek xtinbij chique ri yebin queri': Riyin can ma wetaman ta c'a iwech. Quixel el chinuwech riyix ri xa yix banoy tak etzelal, xquicha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y xabachique c'a winek ri nac'axan re ch'abel re' y can nuben, can njunumaj c'a riq'ui jun achi ri c'o runa'oj ri can pa ruwi' abej xuben wi ka rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xka c'a job, xepe c'a raken tak ya' y xepe c'a cak'ik' chrij ri jun jay ri' y ri jay ma xtzak ta ruma chi ri rucimiento ri jay ri' can pa ruwi' abej tz'uyul wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Y xabachique c'a winek ri nac'axan re ch'abel re xinbij ka, y xa ma nuben ta ri nbij chare, can junan c'a riq'ui ri jun nacanic achi ri xuben jun rachoch pa ruwi' sanayi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xka c'a job, xepe c'a raken tak ya' y xepe c'a cak'ik' chrij ri jun jay ri' y ri jay xtzak; y xq'uis c'a chiri'. Queri' c'a ri ch'abel ri xerubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y tek ri Jesús xtane' ka chubixic re ch'abel re', ri winek ri xe'ac'axan riche (rixin) can sibilaj c'a xquimey ri ch'abel ri xuc'ut chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ruma ri ch'abel ri nuc'ut chiquiwech ri winek can achi'el jun achi ri c'o k'atbel tzij pa ruk'a' y man achi'el ta oc ri niquic'ut ri aj tz'iba'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y tek ri Jesús kajnek chic c'a pe pa ruwi' ri juyu', ri winek ri ye tzeketel chrij can sibilaj ye q'uiy. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y xpe c'a jun achi ri c'o jun itzel yabil chrij, y ri yabil ri' lepra rubi'. Ri achi ri' xxuque' xmaje' ka chuwech ri Jesús y xubij c'a chare: Ajaf, wi riyit nawajo' yinac'achojsaj chare re nuyabil, can yic'achoj wi c'a ri', ruma riyin wetaman chi can yacowin wi, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Y ri Jesús can yac'ari' tek xuyuk apo ruk'a' y xuchop apo ri achi ri c'o ri itzel yabil chrij y xubij chare: Nwajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chawij, xcha' chare. Y can xu (xe) wi xubij queri' ri Jesús, ri achi xch'ajch'ojir chare ri ruyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","C'ac'ari' ri Jesús xubij chare ri achi ri': Nchilabej c'a el chawe chi majun achoj chare tatzijoj wi ri xbanatej awuq'ui, xa choj jac'utu' awi' chuwech ri sacerdote, y can taya' c'a ri ofrenda ri rajawaxic chi naya', achi'el nubij chupan ri rutz'iban ca ri Moisés, riche (rixin) chi queri' nak'alajsaj c'a awi' chiquiwech chi yit ch'ajch'oj chic, xcha' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y tek ri Jesús xoc c'a pa tinamit Capernaum, c'o c'a jun achi ri xapon riq'ui. Y ri achi ri' jun capitán y xuc'utuj c'a jun utzil chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Quec'are' ri xubij ri capitán: Ajaf, ri numozo siquirnek; y ri yabil ri' rukasan pa ruwarabel chila' chwachoch. Y sibilaj pokonal ri ntajin chuk'axaxic, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Xpe ri Jesús xubij chare ri capitán: Yibe c'a y xtinc'achojsaj ri amozo, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y quec'are' ri ch'abel ri xubij chic apo ri capitán chare ri Jesús: Ajaf, riyit nim ak'ij y ma ruc'amon ta (takal ta chuwij) chi yatoc pa wachoch. Xaxu (xaxe) wi tabij jun ch'abel chi nic'achoj ri numozo y xtic'achoj. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Riyin can wetaman wi chi queri' xtibanatej, ruma chi yin jun achi ri nnimaj ri nubij ri aj k'atbel tzij chuwe ri c'o chi nben. Y yec'o chuka' soldados ri ye ya'on pa nuk'a'. Tek nbij c'a chare jun chi tibe, can nibe wi; y wi nbij chuka' chare jun chic chi tipe, can nipe wi chuka'. Y tek nbij c'a chare ri numozo chi tabana' re', can nuben wi chuka', xcha' ri capitán. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y ri Jesús can xumey c'a tek xrac'axaj ri ch'abel ri' y xubij chique ri ye tzekelbeyon riche (rixin): Can kitzij nbij chiwe chi ri xbin re ch'abel re', can rucukuban wi ruc'u'x wuq'ui. Y majun c'a wech aj Israel ri wilon ta ri can rucukuban ta ruc'u'x wuq'ui, achi'el re jun achi re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Can nbij wi c'a chiwe chi sibilaj ye q'uiy winek ri xquepe quere' pa relebel k'ij y quere' chuka' pa rukajbel k'ij, winek ri quicukuban quic'u'x wuq'ui. Riye' xquetz'uye' c'a riq'ui ri Abraham, ri Isaac y ri Jacob pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero yec'o chuka' nic'aj chic aj Israel ri can c'o chi ye'oc pa rajawaren ri caj, ri xa ma xque'oc ta, xa xque'elesex ca y xquec'ak chupan ri k'eku'm, ruma xa can ma xquicukuba' ta quic'u'x wuq'ui riyin. Y chiri' c'a xque'ok' wi y xtiquikach'ach'ej quey. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yac'ari' tek ri Jesús xubij el chare ri capitán: Catzolin chawachoch. Ruma xanimaj chi riyin yicowin yic'achojsan, can xtibanatej c'a ri araybel, xcha' el chare. Y ri rumozo ri capitán, can ya c'a hora ri' xc'achoj chare ri ruyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y tek ri Jesús xapon pa rachoch ri Pedro, xutz'et c'a chi ri rujite' ri Pedro kajnek pa ch'at ruma c'o jun nimalaj c'aten chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpe Riya' xuchop ruk'a' ri yawa' y can yac'ari' tek xq'uis el ri nimalaj c'aten chrij. Ri rujite' ri Pedro xyacatej c'a pe pa ruch'at y xuchop yerunimaj yerilij apo ri Jesús y ri ye benak riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tek ntoc c'a pe ak'a' ri k'ij ri', ye q'uiy c'a ri c'o itzel tak espíritu quiq'ui xe'uc'uex apo chuwech ri Jesús, riche (rixin) chi ri Jesús yerelesaj ta el ri itzel tak espíritu quiq'ui. Y Riya' xubij c'a chique ri itzel tak espíritu chi que'el el, y xeruc'achojsaj chuka' el quinojel ri ye yawa'i'; ");
INSERT INTO cakWNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","riche (rixin) chi queri' can nibanatej c'a ri rubin ca ri profeta Isaías, ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca. Ri Isaías quec'are' ri rubin ca chrij ri Jesús: Xerelesaj c'a el kayabilal konojel, y xuc'uaj c'a ronojel ri kak'axomal. Queri' ri rubin ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Tek ri Jesús xerutz'et chi sibilaj ye q'uiy winek ri quisutin qui' chrij, yac'ari' tek Riya' xubij chique ri rudiscípulos chi jo' kojk'ax chic apo la juc'an ruchi' ya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y c'o c'a jun achi aj tz'ib ri xapon apo riq'ui ri Jesús y xubij chare: Tijonel, riyin nwajo' c'a chi yatintzekelbej xabacuchi (xabachique) ri yabe wi, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Xpe ri Jesús xubij chare ri aj tz'ib ri': Ri xwan can c'o wi jul ri acuchi (achique) yec'oje' wi; y queri' chuka' ri aj xic' tak chicop ri yebe pa cak'ik', can c'o chuka' quisoc. Yac'a riyin ri C'ajolaxel ri xinalex chicojol, can majun wachoch ri acuchi (achique) yinuxlan wi juba', xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yac'a chuka' ri' tek jun chic ri can tzekelbey riche (rixin) ri Jesús, xubij c'a apo chare: Ajaf, riyin can nwajo' wi yatintzekelbej. Xa yac'a chi taya' na k'ij chuwe chi nmuk na el ri nata', c'ac'ari' tek xcatintzekelbej chic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xpe ri Jesús xubij chare: Riyit quinatzekelbej. Xa taya' c'a ca chi ri caminaki' quemuk na cuma ri ye caminek chupan ri quimac, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Y ri Jesús xoc c'a el pa jun jucu' y ri ye rudiscípulos xquitzekelbej el. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y yac'ari' tek xpe jun nimalaj cak'ik' pa ruwi' ri choy. Ri ruwi' ya' xa juba' ma numuk ri jucu'. Pero ri Jesús warnek el. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y xepe ri discípulos xquic'asoj c'a ri Jesús y xquibij chare: ¡Ajaf! ¡Ajaf! Kojacolo' c'a. Wacami yojcom, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Xpe ri Jesús xubij chique ri ye rudiscípulos: Can ma cukul ta c'a ic'u'x wuq'ui, rumari' tek ixibin iwi', xcha' chique. Y Riya' xbeyacatej c'a pe y xubij: Tiq'uis el ri cak'ik' y titane' ka ri ruwi' ya', xcha'. Y queri' xbanatej. Ri cak'ik' xq'uis el, y chuka' ri ruwi' ya' xtane' ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y ri discípulos xquimey tek xquitz'et ri xuben ri Jesús y niquibila' c'a: ¿Achique c'a rubanic chi achi re'? Ruma hasta ri cak'ik' y ri ya' can niquinimaj wi chuka' rutzij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y tek ri Jesús y ri ye rudiscípulos xe'apon c'a ri juc'an chic ruchi' ya', chiri' pa jun lugar ri Gadara rubi', yec'o c'a ye ca'i' winek xe'apon riq'ui ri Jesús; winek ri xa c'o itzel tak espíritu quiq'ui, xebe'el pe pa camposanto. Y ruma chi can q'uiy pokon niquiben ri winek ri', rumari' majun chic winek ri nik'ax ta chic chupan ri bey ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri ca'i' winek ri', ri c'o itzel tak espíritu quiq'ui, xquirek apo quichi' chare ri Jesús, y xquibij: Riyit Jesús ri Ruc'ajol ri Dios, ¿achique c'a ruma tek yojanek? ¿Achique c'a ruma yojach'ujirisaj yan, tek xa ma jane napon ta ruk'ijul? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y quela' c'a apo juba' chare ri lugar ri', sibilaj c'a ye q'uiy ak ntajin yewa'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Xepe ri itzel tak espíritu ri yec'o quiq'ui ri ye ca'i' winek ri', xquic'utuj utzil chare ri Jesús, y xquibij c'a chare: Wi yojawelesaj el wawe' quiq'ui re winek re', taya' k'ij chake chi yoj-oc quiq'ui la ak yec'o chila', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xubij c'a chique: Jix c'a. Y can yac'ari' tek ri itzel tak espíritu xe'el el y xebe'oc quiq'ui ri ak. Y quinojel ri ak ri' xquichop anin (anibel) pa xulan, chuwech jun juyu' xulan ruwech y choj xebeka c'a pa choy. Can quinojel c'a ri ak ri' xecom pa ya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yec'a ri yeyuk'un quiche (quixin) ri ak ri', xu (xe) wi c'a xquitz'et ca ri xbanatej, xe'anmej. Xebe pa tinamit, xbequiyala' ca rutzijol achique ri xquic'ulwachij ri ak y xbequibij chuka' ri xbanatej quiq'ui ri ye ca'i' winek ri c'o itzel tak espíritu quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Y yac'ari' tek quinojel ri winek riche (rixin) ri tinamit xepe c'a riq'ui ri Jesús chutz'etic y chuka' riche (rixin) chi xquic'utuj utzil chare chi tel el ri chiri' chupan ri quilugar, ruma riye' ma nicajo' ta chi nic'oje' ka chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yac'ari' tek ri Jesús xoc el pa jucu' y xebe c'a juc'an chic ruchi' choy. Y ri Jesús xapon pa tinamit ri acuchi (achique) xq'uiy wi Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y yac'ari' tek c'o jun achi siquirnek, li'en el chuwech ruwarabel, xuc'uex apo chuwech ri Jesús. Y tek ri Jesús xerutz'et chi can quicukuban quic'u'x riq'ui, Riya' xubij c'a chare ri achi siquirnek: Walc'ual, tiquicot c'a ri awánima; ri amac xecuyutej, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y can yac'ari' tek yec'o jun ca'i' chique ri aj tz'iba' ri yec'o apo chiri', xquibij ka pa tak cánima chrij ri Jesús: Re' xa itzel xubij ruma nujunumaj ri' riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yac'a ri Jesús can retaman c'a ri niquich'ob ka ri aj tz'iba'. Rumari' Riya' xubij chique: ¿Achique ruma tek itzel ri xich'ob pa tak iwánima? ");
INSERT INTO cakWNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Wacami tibij na c'a chuwe: ¿Achique cami ri más c'ayef (cuesta) rubanic nich'ob riyix? ¿La ya cami ri nbij chare re achi re' chi ri rumac xecuyutej yan, o ya ri nbij chare: Cayacatej y cabiyin el? ");
INSERT INTO cakWNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wacami c'a, riche (rixin) chi riyix niwetamaj chi riyin ri C'ajolaxel ri xinalex chicojol can c'o k'atbel tzij pa nuk'a' riche (rixin) chi ncuy mac chuwech re ruwach'ulef, titz'eta' c'a. Y ri Jesús xubij c'a chare ri achi siquirnek: Nbij c'a chawe: Cayacatej, tac'uaj el la awarabel y cabiyin chawachoch, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y yac'ari' tek ri achi siquirnek xyacatej anej y xbe chrachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ri winek c'a ri quimolon apo qui' chiri', tek xquitz'et chi ri achi siquirnek xpa'e' el, xquimey; ruma majun bey c'a quitz'eton ta chi nibanatej ta queri'. Y ri winek ri' xquiya' c'a ruk'ij ruc'ojlen ri Dios; ruma ruya'on pe ri jun nimalaj uchuk'a' ri' chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y tek ri Jesús ruchapon el bey, xutz'et jun achi Mateo rubi'. Ri achi ri' tz'uyul c'a ri acuchi (achique) yetoj wi ca ri alcawal. Y xpe ri Jesús xubij c'a chare: Quinatzekelbej. Y yac'ari' tek riya' xbeyacatej pe ri acuchi (achique) tz'uyul wi y xutzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y tek Riya' tz'uyul pa mesa ri chiri' pa jay, ye q'uiy c'a chique ri ye c'utuy tak alcawal y nic'aj chic winek ri xa ye aj maqui', xetz'uye' apo ri pa mesa junan riq'ui ri Jesús y quiq'ui ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y ri achi'a' fariseos tek xquitz'et ri', xquibij c'a chique ri ye rudiscípulos ri Jesús: ¿Achique ruma tek la Itijonel niwa' quiq'ui ri ye c'utuy tak alcawal y quiq'ui nic'aj chic winek ri xa ye aj maqui'? xecha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tek ri Jesús xrac'axaj pe ri tzij ri niquibij ri achi'a' fariseos, Riya' xubij chique: Jun ajk'omanel ma ye ta ri ye utz ri yerak'omaj. Riya' yerak'omaj ri yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Riyin ma xipe ta chiquicanoxic winek ri choj quic'aslen. Riyin xipe chiquicanoxic ri aj maqui', ri rajawaxic chi nitzolin pe quic'u'x riq'ui ri Dios. Quixbiyin c'a chiretamaxic ri achique ntel wi chi tzij ri ruch'abel ri Dios tek nubij: Riyin ri más nika chinuwech chi niben riyix ya chi nijoyowaj quiwech ri winek, ya c'a ri' ri más nika chinuwech, que chuwech ri chicop ri yecamisex y ye'itzuj (ye'isuj) chinuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Y yac'ari' tek ri ye rudiscípulos ri Juan ri Bautista xe'oka riq'ui ri Jesús, y xquibij chare: Riyoj can c'o c'a k'ij nikachajij tek can ma yojwa' ta riche (rixin) chi nikaben orar. Y queri' chuka' niquiben ri quidiscípulos ri achi'a' fariseos. ¿Y achique c'a ruma tek ri adiscípulos riyit ma que ta ri' niquiben? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Xpe ri Jesús xubij chique: ¿Achique nibij riyix? ¿La utz cami chi xa yebison ri xesiq'uix (xe'oyox) pa jun c'ulanen y chi man ta yewa', tek xa c'a c'o na apo quiq'ui ri achijlon ri xa c'a xc'ule'? Ma utz ta. Pero xtapon na ri k'ij tek re achijlon re' xtelesex el chiquicojol, y yac'ari' tek ma xquewa' ta, riche (rixin) chi xtiquiben orar. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Y majun chuka' winek nibano chi nucusaj ta jun c'ojobel c'ac'ac' riche (rixin) chi nuc'ojoj jun tziek ri xa ri'j chic. Ruma jun c'ojobel c'ac'ac' nuc'ol ri' y nujic' ri tziek; y ri tziek ri' más niretzetaj (nitzeretej). ");
INSERT INTO cakWNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y queri' chuka' majun niya'o ta c'ac'ac' ruya'al uva chupan jun tz'um yabel ya' ri xa ri'j chic. Ruma wi queri' niban, y ri tz'um xa ma niyukuk ta chic, xa nirakaro' y niq'uis el ri ruya'al uva chupan. Y chuka' ri tz'um ri' majun chic nic'atzin wi. Yac'a jun c'ac'ac' tz'um yabel ya', utz niyaque' ri c'ac'ac' ruya'al uva chupan. Ri ruya'al uva can nic'oje' c'a jabel chupan ruma chi ri ruya'al uva y ri tz'um niquito' qui'. Quec'ari' xubij ri Jesús chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y tek ri Jesús c'a ntajin c'a chutzijoxic ronojel ri', c'o c'a jun achi principal xapon y xbexuque' xbemaje' chuwech y c'ac'ari' xubij chare: Ri numi'al xa c'a juba' ticom ka, tabana' jun utzil jaya' ri ak'a' pa ruwi' riche (rixin) chi queri' xtic'ase' chic jun bey, xcha' ri achi. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Xpe ri Jesús xyacatej c'a el y ye rachibilan ri rudiscípulos xquitzekelbej el ri achi. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y c'o c'a jun ixok ri c'o jun ruyabil riche (rixin) ic' chare. Ri ixok ri' c'o chic c'a cablajuj juna' ri ma tanel ta ri ruquiq'uel, xjel c'a apo chrij ri Jesús, y xberuchapa' c'a ca juba' ri ruchi' rutziak ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ruma ri ixok ri' can yerubila' c'a pa ránima: Xa riq'ui ta nchop el juba' ruchi' rutziak ri Jesús, yic'achoj, chinek pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Yac'a ri Jesús chanin c'a xuna' chi xchapatej rutziak y xtzu'un ca chrij. Y tek rutz'eton chic achique ri xchapo ruchi' rutziak, xubij c'a chare ri ixok ri': Numi'al, xac'achoj, ruma xacukuba' ac'u'x wuq'ui. Ma cabison ta chic, xuche'ex. Y ri ixok ri', can yac'ari' xc'achoj chare ri ruyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y tek ri Jesús ntoc c'a apo pa rachoch ri achi ri principal, xutz'et chi ri winek yech'ujlan y yec'o chic c'a ri yebano xul. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpe Riya' xubij: Kojiya' na ca juba' kayon, ruma re ti k'opoj re' xa ma caminek ta, xa warnek, xcha' chique ri winek. Yac'a riye' xa xetze'en chrij ri Jesús, ruma can quetaman chi caminek chic ri ti k'opoj ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y yac'a tek ri winek ye elenak chic el, ri Jesús xoc apo chupan ri jay ri acuchi (achique) c'o wi ri ti k'opoj ri caminek chic. Xpe Riya' xuchop ruk'a' ri ti k'opoj, y can yac'ari' tek xc'astej. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbanatej c'a chiri', xbe c'a rutzijol ri pa tak tinamit chupan ri ruwach'ulef ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y tek ri Jesús elenak chic c'a pe ri chiri', yec'o c'a ca'i' moyi' xquitzekelbej el ri Jesús y niquirek quichi' chrij y niquibij c'a chare: ¡Riyit ri yit ralc'ual ca ri rey David, tajoyowaj kawech ruma re kabanon! yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tek ri Jesús xapon pa jay, ri ca'i' moyi' xe'apon c'a chuka' riq'ui. Y ri Jesús xuc'utuj c'a chique: ¿Can ninimaj c'a riyix chi riyin yicowin nben chiwe chi yixtzu'un? xcha' chique. Y ri ca'i' moyi' ri' xquibij: Ja' (je) Ajaf, nikanimaj, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpe ri Jesús xuchop ri runak' tak quiwech chi ye ca'i' y xubij chique: Ruma riyix ninimaj chi riyin yicowin yixinc'achojsaj, can tibanatej c'a ri iraybel, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y can yac'ari' tek xetzu'un. Yac'a ri Jesús xuchilabej c'a el chique: Can tiwac'axaj c'a el jabel, chi re xbanatej iwuq'ui, majun achoj chare titzijoj wi, xcha' el chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Yac'a riye' xa ma que ta ri' xquiben tek ye elenak chic pe chiri' riq'ui ri Jesús. Riye' xa xquichop c'a rutzijoxic pa ronojel ri ruwach'ulef ri', ri xuben ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y tek ri ca'i' achi'a' ri yetzu'un chic, kas elen c'a niquiben pe, can yac'ari' tek yec'o chic nic'aj xe'oc apo riq'ui ri Jesús, quic'uan apo jun achi ri memurnek ruma chapatajnek ruma jun itzel espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y tek elesan chic c'a ri itzel espíritu riq'ui ri achi ruma ri Jesús, ri achi xch'o. Y ri winek ri xetz'eto xquimey y xquibij: Majun bey c'a tz'eton ta chi que ta re' banatajnek wawe' pan Israel, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Yac'a ri achi'a' fariseos xa niquibij c'a chrij ri Jesús: La' xa ya ri cajawalul ri itzel tak espíritu ri niya'o uchuk'a' chare, rumari' tek nicowin yerelesaj itzel tak espíritu, yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ri Jesús can pa ronojel wi c'a nima'k tak tinamit y pa tak aldea xapon wi, y xerutijoj c'a ri winek riq'ui ri ruch'abel ri Dios. Y ya c'a ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, chiri' napon wi riche (rixin) chi yerutijoj ri winek. Y chuka' can nutzijoj c'a ri lok'olaj ch'abel ri nich'o chrij ri rajawaren ri Dios. Yeruc'achojsaj chuka' yawa'i', y yerucol c'a ri winek chuwech ronojel ruwech k'axomal. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y tek xerutz'et chi sibilaj ye q'uiy ri winek, xujoyowaj quiwech, ruma can quiyon yec'o y quitalun qui'; can achi'el niquiben ri carne'l tek xa majun ri niyuk'un quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Yac'ari' tek ri Jesús xubij chique ri rudiscípulos: Can kitzij wi chi ri samaj riche (rixin) chi nitzijox ri ruch'abel ri Dios, sibilaj nim; yec'a ri yetzijon ri ch'abel ri' xa ma ye q'uiy ta oc. ");
INSERT INTO cakWNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rumari' can tic'utuj c'a chare ri Rajaf ri samaj, chi querutaka' pe q'uiy samajela' chiquicojol ri winek ri rajawaxic chi niquic'axaj ri ruch'abel. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y ri Jesús xerusiq'uij (xeroyoj) c'a ri ye cablajuj rudiscípulos, y xuya' k'atbel tzij pa quik'a', riche (rixin) chi yecowin yequelesaj ri itzel tak espíritu y riche (rixin) chi yequic'achojsaj ri winek chare xabachique chi yabil y xabachique chi k'axomal. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Y yec'are' ri quibi' chiquijujunal ri ye cablajuj apóstoles. Ri nabey, Simón ri nibix chuka' Pedro chare, ri Andrés ri rach'alal ri Simón. Ri Jacobo y ri Juan ri ye ruc'ajol jun achi Zebedeo rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri c'utuy alcawal, ri Jacobo ruc'ajol ri jun achi ri Alfeo rubi', ri Lebeo ri nibix chuka' Tadeo chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri Simón ri c'o quiq'ui ri achi'a' ri nibix cananista chique, y ri Judas Iscariote ri xjacho riche (rixin) ri Jesús pa quik'a' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y yec'a ri cablajuj achi'a' ri' ri xerutek el ri Jesús. Xerupixabala' c'a el. Xubila' chique: Nichop c'a bey, xa yac'a ri ma quixapon ta quiq'ui ri winek ri xa ma ye israelitas ta. Chuka' ma quixapon ta ri pa tak tinamit ri yec'o pa rucuenta ri Samaria. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xa quixbiyin nabey quiq'ui ri israelitas ri ye sachnek ca. Ruma riye' quibanon c'a achi'el niquiben ri carne'l tek yesach ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y yac'a tek yix benak chic, can titzijoj ri ruch'abel ri Dios y tibij c'a: Nakaj chic c'o wi pe ri rajawaren ri caj, quixcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Que'ic'achojsaj c'a yawa'i'. Ri c'o c'a ri yabil lepra chiquij, can tibana' c'a chique chi nich'ajch'ojir jabel ri quich'acul. Ri ye caminek chic, que'ic'asoj. Can que'iwelesaj c'a chuka' ri itzel tak espíritu. Y ruma c'a ronojel re uchuk'a' re' xa sipan chiwe riyix, can queri' c'a chuka' tibana' riyix. Tek niben ca ri utzil, ma tic'utuj ta rajel. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ma tic'uaj ta el irajil pa tak ximibel ipan. Can majun c'a ruwech puek tic'uaj el. Ma tic'uaj ta el puek ri banon riq'ui ri ch'ich' ri nibix cobre chare, y ma tic'uaj ta chuka' el ri banon riq'ui sakapuek, ni xa ta ri banon riq'ui k'anapuek. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Re nichop el bey man c'a tic'uaj ta el ya'l. Ma tic'uaj ta el ca'i' itziak, xa can xu (xe) wi ri icusan el. Ma tic'uaj ta jun chic c'ulaj ixajab, ni ma tic'uaj ta chuka' ich'ame'y. Can majun c'a ri tic'uaj. Ruma chi ri aj samajel xabacuchi (xabachique) ri napon wi, ruc'amon chi niya'ox (nya') ri nic'atzin chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Xabachique ta na tinamit o xabachique ta na aldea ri yixapon wi, nabey na tiwetamaj achique winek ri utz chi yixapon pa rachoch. Y can chiri' c'a quixc'oje' wi ka, y can c'a ya tek yixel pe chupan ri tinamit ri', c'ac'ari' utz chi niya' ca ri jay ri xixc'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y tek xa c'ari' yixoc apo chupan ri jay ri yixbec'oje' wi, tiyala' rutzil quiwech ri yec'o chupan ri jay ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tibij c'a chique: Ya ta c'a ri uxlanibel c'u'x riche (rixin) ri Dios xtic'oje' pan iwi'. Y wi can utz chi yixc'oje' ka chupan ri jay ri', ri uxlanibel c'u'x ri nuya' ri Dios ri niraybej pa quiwi', can xtika wi c'a pa quiwi'. Yac'a wi ma ruc'amon ta chi yixc'oje' ka chupan ri jay ri', ri uxlanibel c'u'x ri nuya' ri Dios ri niraybej pa quiwi', ma xtic'oje' ta ca quiq'ui, xa xtitzolin pe iwuq'ui riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Wi can ma nicajo' ta yixquic'ul, y ma nicajo' ta chuka' niquic'axaj ri ruch'abel ri Dios ri nitzijoj riyix chique, can quixel c'a pe chiri' quiq'ui pa cachoch o pa quitinamit. Y titotala' (tiquirala') ca ri pokolaj ri c'o chiwaken chiquiwech ri winek ri', riche (rixin) chi tiquetamaj chi ma utz ta ri xquiben. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kitzij c'a nbij chiwe, chi chupan ri k'ij tek xtik'at tzij pa ruwi' re ruwach'ulef, más xtik'ax ruwi' ri ruc'ayewal ri xtika pa quiwi' ri winek riche (rixin) ri tinamit ri ma xquixquic'ul ta, que chiquiwech ri aj Sodoma y Gomorra, xcha' el chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Wacami yixintek c'a el, y riyix iwetaman chi xa yix achi'el tak carne'l ri yixbeka chiquicojol ri winek ri ye achi'el utiwa' (coyotes). Xa yac'a chi can tibana' achi'el nuben ri cumatz, ruma riya' nuna' ri' tek c'o ri petenak chrij. Can tibana' c'a chuka' achi'el nuben jun palomax, ruma riya' majun etzelal c'o ta riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Can tichajij c'a iwi', riche (rixin) chi manxa choj tibejacha' iwi' pa quik'a' ri winek ri ye'etzelan iwuche (iwixin). Ruma riye' xquixquijech pa quik'a' ri achi'a' ri pa moc (comon) yek'ato tzij; y chuka' ri winek ri' xquixquich'ey ri chiri' pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chuka' ri winek can xquixquic'uaj c'a chiquiwech ri aj k'atbel tak tzij; chiquiwech reyes y nic'aj chic aj k'atbel tak tzij. Y xa wuma c'a riyin tek xtic'ulwachij queri', pero xa can xquixcowin c'a xquinik'alajsaj chiquiwech riye' y chiquiwech chuka' ri winek ri ma ye israelitas ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Yac'a tek ri winek xquixquijech pa quik'a' ri aj k'atbel tak tzij, ma tich'ujirisaj ta iwi' chuch'obic achique chi ch'abel ri xtibij chique. Ruma chupan ri hora ri', ri Dios xtuya' c'a ch'abel chiwe ri nic'atzin chi nibij. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ruma xa can ma yix ta chic riyix ri xquixch'o, xa can ya chic ri Lok'olaj Espíritu riche (rixin) ri Itata' ri c'o chila' chicaj ri xtiya'o ri ch'abel chiwe ri xtibij. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y xtibanatej c'a, chi yec'o achi'a' cach'alal qui', jun chique riye' xtiyacatej y xtujech ri rach'alal pa camic. Chuka' can yec'o wi tata'aj ri xqueyacatej chiquij ri calc'ual. Ri alc'ualaxela' xqueyacatej chuka' chiquij ri quite' quitata' y xquequiya' pa camic. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Xa can xquixetzelex wi c'a cuma quinojel, ruma icukuban ic'u'x wuq'ui riyin. Yac'a ri ma xtutzolij ta ri' chrij y xtucoch' ronojel c'a pa ruq'uisbel, ya c'a ri' ri xticolotej. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y tek ri winek ri yec'o chupan jun tinamit niquichop yixquiya' pa tijoj pokonal, utz niya' ca y yixanmej c'a el chuwech ronojel ri', y yixbe pa jun chic tinamit. Y nbij c'a chiwe chi ma jane quixk'ax ta pa ronojel tinamit ri yec'o wawe' pan Israel, tek riyin ri C'ajolaxel ri xinalex chicojol xapon yan ri k'ij chi yipe. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Majun c'a discípulo ri más ta nim ruk'ij que chuwech ri rutijonel. Chuka' majun mozo ri más ta nim ruk'ij que chuwech ri rupatrón. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ri discípulo c'o chi nuk'axaj tijoj pokonal achi'el ri rutijonel, y ri mozo c'o chi nuk'axaj tijoj pokonal achi'el ri rupatrón. Riyin ri Tata'ixel, wi ri winek quibin Beelzebú chuwe, ¿c'a ta c'a chiwe riyix ri yix walc'ual man ta xtiquibij itzel chiwe? ");
INSERT INTO cakWNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Riyix man c'a tixibij ta iwi' chiquiwech ri xquebano queri' chiwe, ruma xa can rajawaxic chi nik'alajsaj ri majun bey can ta k'alajsan pe jabel. Can nic'atzin c'a chi netamatej ri ewan. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ronojel c'a ri ch'abel ri nbij chiwe, ma tic'oje' ta ca pa k'eku'm, xa can tiwelesaj c'a pe chuwasakil. Ri xinbij c'a chiwe pa tak ixquin, ma tiwewaj ta ka, xa tik'alajsaj c'a pa ruwi' tak iwachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ma tixibij ta iwi' chiquiwech ri xaxu (xaxe wi) oc ri ch'aculaj ri yecowin niquicamisaj, yac'a ri iwánima ma yecowin ta niquicamisaj. Ri achoj chuwech ri ruc'amon chi nixibij wi iwi', can chuwech ri jun ri nicowin nuya' ri iwánima y ri ich'acul chupan ri k'ak' ri majun bey nichuptej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Can jabel c'a iwetaman chi tek ye'ic'ayij ca'i' tak aj xic' tak chicop, xaxu (xaxe) wi ca'i' oxi' oc tak centavos cajel. Y ma riq'ui ta chi ri aj xic' tak chicop ri' xa ma q'uiy ta oc cajel, majun c'a ri xtitzak ta pan ulef wi xa ma ruraybel ta ri Itata' ri c'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","C'a ta c'a riyix. Ruma riyix hasta ri rusmal tak iwi' ajlan ronojel. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Rumari' ma tixibij ta iwi'. Riyix más c'o iwejkalen que chiquiwech ye q'uiy aj xic' tak chicop. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Y xabachique c'a winek ri nuk'alajsaj ri' chi riya' yin runiman riyin, riyin chuka' xtink'alajsaj chuwech ri Nata' Dios ri c'o chila' chicaj chi ri winek ri' wuche (wixin) chic riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Yac'a jun winek ri xa ma nuk'alajsaj ta ri' chiquiwech ri winek chi riya' wuche (wixin) riyin, riyin chuka' can ma xtink'alajsaj ta apo rubi' chuwech ri Nata' Dios ri c'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man c'a tich'ob ta chi ruma xipe riyin chuwech re ruwach'ulef, ruma ta ri' can ta c'o uxlanibel c'u'x quiq'ui quinojel. Ma que ta ri'. Xa wuma riyin xqueyojtej ri winek chiquiwech y xtiquiben ch'a'oj. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Riyin xipe c'a chuwech re ruwach'ulef y wuma c'a riyin nipe oyowal chiquicojol ri winek. Queri' xtibanatej ri pa tak jay. Ri c'ajol xtiyacatej chrij ri rutata'. Ri k'opoj xtiyacatej c'a chrij ri rute'. Y can queri' chuka' ri alibetz xtiyacatej chrij ri ralite'. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri xque'etzelan c'a riche (rixin) jun winek ri nucukuba' ruc'u'x wuq'ui riyin, can yec'a ri ye aj pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri winek ri xa más c'a xquerajo' rute' rutata' que chinuwech riyin, can ma ruc'amon ta chi ntoc wuche (wixin) riyin. Ri te'ej tata'aj ri xa can más yecajo' ri calc'ual que chinuwech riyin, can ma ruc'amon ta chi ye'oc wuche (wixin) riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun winek ri can nrajo' ntoc wuche (wixin) riyin, nic'atzin chi ma tupokonaj ta nuk'axaj tijoj pokonal wuma riyin, achi'el jun ri can benak chuxe' jun cruz riche (rixin) chi nbecamisex. Yac'a ri winek ri xa nupokonaj nuk'axaj tijoj pokonal wuma riyin y ma nrajo' ta yirutzekelbej, ma ruc'amon ta chi ntoc wuche (wixin) riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Rumari' wi xa ya ri c'aslen riche (rixin) re ruwach'ulef ri nrajo', ma xtril ta ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri winek ri ma nupokonaj ta ri ruc'aslen re wawe' choch'ulef, astape' ta na can napon pa camic wuma riyin, can xtril wi ri ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Yac'a ri can yixruc'ul riyix, can yin c'a chuka' riyin ri yiruc'ul; y ri nic'ulu c'a wuche (wixin) riyin, can nuc'ul c'a chuka' ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri winek c'a ri can nika chuwech ri ruch'abel ri Dios, y rumari' nuc'ul jun profeta ri nik'alajsan ruch'abel ri Dios, ri winek ri' can xtuc'ul c'a rajel ruq'uexel achi'el rajel ruq'uexel ri nuc'ul ri nik'alajsan ri ruch'abel ri Dios. Y queri' chuka' ri winek ri utz nutz'et jun c'aslen choj y rumari' can nuc'ul riq'ui quicoten jun winek ri can choj wi ruc'aslen; can achi'el c'a rajel ruq'uexel ri xtuc'ul ri choj ruc'aslen, can queri' chuka' xtuc'ul riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y xabachique c'a winek, astape' xa jun vaso raxya' nuya' chare jun ri ma can ta nim ruk'ij pero ruma chi yin rutzekelben, kitzij nbij chiwe chi can c'o wi rajel ruq'uexel ri xtuc'ul. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y tek ri Jesús xuq'uis rubixic chique ri cablajuj rudiscípulos ri achique chi samaj ri nbequibana', Riya' can ma xc'oje' ta chic ca chiri', xa xbe c'a pa nic'aj chic tinamit ri yec'o chiri' pan Israel, chuc'utic y chutzijoxic ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Y ri Juan ri Bautista tek c'o pa cárcel xrac'axaj c'a ri samaj ri nuben ri Jesús, rumari' riya' xerutek c'a el ye ca'i' rudiscípulos c'a riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Y riya' xutek c'a el ruc'utuxic chare: ¿Can yit c'a riyit ri Cristo ri c'o chi nipe? ¿O xa nikoyobej chic na jun? Can quec'ari' xbequibij ri ca'i' discípulos riche (rixin) ri Juan ri Bautista. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y ri Jesús xubij c'a el chique ri ye ca'i' rudiscípulos ri Juan: Wacami quixtzolin y jebe'itzijoj chare ri xitz'et ca y ri xiwac'axaj el re wawe'. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Jebe'itzijoj chare achique rubanic tek ri moyi' yecowin yetzu'un el, achique rubanic tek ri winek ri ye cojo can yebiyin wi el jabel y achique rubanic tek ri ye yawa'i' riq'ui ri yabil lepra yech'ajch'ojir el. Jebe'itzijoj chuka' chare ri achique rubanic tek ri ma ye'ac'axan ta yec'achoj, ri caminaki' yec'astej, y chique ri pobres ntzijoj ri lok'olaj ch'abel ri niya'o colotajic. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Can tibij c'a chuka' chare chi can jabel ruwaruk'ij ri winek ri can rucukuban ruc'u'x wuq'ui y ma yirumalij ta ca. Quec'ari' xbix el chique ri ca'i' discípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y tek ri ye ca'i' rudiscípulos ri Juan ri Bautista xebe el, ri Jesús xerubila' c'a utzilaj tak ch'abel chrij ri Juan chiquiwech ri winek ri yec'o chiri'. Y quec'are' ri nubij ri Jesús chique: ¿Achique ri xbe'itz'eta' riyix pa desierto? ¿La xitz'et cami riyix jun achi chiri', chi xa achi'el jun aj, ri xa nibe quela' y nibe chic quela' pa ruk'a' ri cak'ik'? Ma que ta ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Achique c'a ri xbe'itz'eta' riyix chiri'? ¿La xitz'et cami riyix jun achi ri jabel tak tziek ye rucusan? Ma que ta ri'. Ri achi'a' ri ye quicusalon jabel tak tziek, riye' can pa tak cachoch reyes yec'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pero achique ri xbe'itz'eta' riyix pa desierto? ¿Xitz'et cami jun profeta ri nik'alajsan ri ruch'abel ri Dios? Ja' (je). Ri achi ri xitz'et chiri' can ya wi ri' ri rusamaj. Pero can c'o c'a chuka' jun chic samaj ri ya'on pe chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ruma can ya c'a riya' ri' ri tako'n ri natan ca chupan ri ruch'abel ri Dios ri tz'ibatal ca, tek ri Dios xubij: Xtintek c'a ri nutako'n ri ninabeyej chawech, riche (rixin) chi nuchojmirisaj apo ri abey. Quec'ari' nubij ri tz'ibatajnek ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Kitzij c'a re xtinbij chiwe wacami: Chiquicojol quinojel ri ye alaxnek chuwech re ruwach'ulef, majun chic jun profeta ri más ta nim ruk'ij que chuwech ri Juan ri Bautista. Pero wacami ri pa rajawaren ri Dios, astape' jun winek xa co'ol oc ruk'ij, hasta ri' más nim ruk'ij que chuwech ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Y ri winek chupan c'a ri k'ij tek can c'a nisamej na ri Juan ri Bautista, yac'ari' tek quichapon pe y c'a yetajin na chupan re k'ij re', chi can niquitij quik'ij chi ye'oc pa rajawaren ri caj. Can niquimajla' c'a qui' chrij y más niquiben ri can riq'ui c'a ronojel quic'u'x ye'apon. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Queri' niquiben ruma ri k'alajsan ca cuma quinojel ri profetas y ri nuk'alajsaj chuka' ri ley riche (rixin) ri Moisés, can chrij wi c'a tek ri winek ye'oc pa rajawaren ri caj ch'onak wi pe, hasta que xoc'ulun ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wi riyix ninimaj o ma ninimaj ta, yac'a ri nbij chiwe riyin chi ri tz'ibatal ca tek nubij chi nipe ri Elías xa chrij c'a ri Juan nich'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ri c'o rac'axabel, can trac'axaj c'a ri xinbij! ");
INSERT INTO cakWNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Achoj riq'ui yenjunumaj wi ri winek yec'o re tiempo re'? Re winek re' xa ye junan quiq'ui ri ac'ala' ri yetz'uye' pa tak c'aybel y niquirek quichi' chiquij ri cachibil tek ye'etz'eyaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Y ri ac'ala' ri' niquibila' c'a: Xojk'ojoman riq'ui xul chiwech y ma xixxajo ta. Xkabixaj bix riche (rixin) bis chiwech y ma xixok' ta. Queri' niquibila' ri ac'ala' pa quetz'anen. Y ye queri' ri winek riche (rixin) re tiempo re', majun ri nika ta chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ruma tek xpe ri Juan ri Bautista, riya' ma nutij ta caxlan wey y ma nukum ta chuka' ruya'al uva. Y ye q'uiy yebin chi riya' c'o itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y tek xinoka riyin ri C'ajolaxel ri xinalex chicojol, riyin ntij caxlan wey y nkum chuka' ruya'al uva. Y ye q'uiy yebin chi xu (xe wi) wa'in nwajo', y niquibij chuka' chi yin jun k'abarel, chi yin cachibil ri c'utuy tak alcawal y yin cachibil chuka' ri aj maqui'. Yac'a ri runa'oj ri Dios can nik'alajin pa quic'aslen ri ye ralc'ual chic, chi can choj wi, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yec'o c'a tinamit ri xeban wi sibilaj q'uiy milagros ruma ri Jesús. Y ma riq'ui wi ri' ri winek ri yec'o chupan ri tinamit ri' ma xtzolin ta pe quic'u'x riq'ui ri Dios. Y rumari' ri Jesús q'uiy ri xubij chiquij. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Riya' xubij c'a: Juyi' oc iwech riyix ri yixc'o pa tinamit Corazín, y juyi' oc chuka' iwech riyix ri yixc'o pa tinamit Betsaida, ruma sibilaj q'uiy milagros xeban chiwech y ma xinimaj ta ri ruch'abel ri Dios. Ruma xa ta ya ri pa tinamit Tiro y pa tinamit Sidón ri xeban ta wi ri milagros ri', ri winek aj chiri' xtzolin yan ta pe quic'u'x riq'ui ri Dios, y quicusalon ta chic quitziak riche (rixin) bis, y quiyalon ta chic chaj chiquij, riche (rixin) chi queri' nik'alajin chi yebison ruma sibilaj q'uiy quimac ri ye quibanalon. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Yac'a tek xtapon ri k'ij tek xtik'at tzij pa ruwi' re ruwach'ulef, riyin nbij c'a chiwe chi riyix ri yixc'o pa Corazín y ri yixc'o pa Betsaida ri más xtik'ax ruwi' ri ruc'ayewal ri xtika pan iwi', que chiquiwech ri aj Tiro y ri aj Sidón. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y riyix ri yixc'o pa tinamit Capernaum can nich'ob chi yixbe chila' chicaj riq'ui ri Dios y xtinimirisex ik'ij. Pero xa ma que ta ri'. Xa xtikasex ik'ij, ruma xa c'a chupan ri lugar riche (rixin) ri tijoj pokonal ri xquixbeka wi. Ruma xa ta ronojel ri milagros ri xeban chiwech riyix, ya ta ri' ri xeban chiquiwech ri aj Sodoma, xquinimaj ta y man ta xeq'uis rachibilan ri quitinamit. Xa c'a yec'o ta na re k'ij re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Yac'a tek xtapon ri k'ij tek xtik'at tzij pa ruwi' ri ruwach'ulef, riyin nbij c'a chiwe chi riyix ri yixc'o pa Capernaum ri más xtik'ax ruwi' ri ruc'ayewal xtika pan iwi', que chiquiwech ri aj Sodoma. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y ya tiempo chuka' ri' tek ri Jesús xubij: Nya' ak'ij Nata' Dios, riyit ri yit Rajaf ri caj y re ruwach'ulef, ruma ma xak'alajsaj ta ri lok'olaj ach'abel chiquiwech ri winek ri can niquina' chi sibilaj q'uiy quina'oj y q'uiy quetaman. Xa chiquiwech c'a ri winek ri ma q'uiy ta quetaman ri xa ye achi'el tak ac'ala', xa chiquiwech riye' xak'alajsaj wi re lok'olaj ach'abel re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can que wi c'a ri' Nata' Dios, ruma chi queri' ri araybel riyit, xcha' ri Jesús pa ru'oración. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y c'ac'ari' Riya' xubij c'a: Ri Nata' Dios, can ronojel cosas rujachon pa nuk'a'. Y majun chic c'a etamayon ta yin achique riyin, xaxu (xaxe) wi ri Nata' ri etamayon. Y majun chuka' etamayon ta achique ri' ri Nata', xaxu (xaxe) wi riyin ri Ruc'ajol ri etamayon, y ri winek ri achoj chare xtinwajo' xtink'alajsaj wi riyin, xtretamaj achique c'a ri' ri Nata'. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixam pe wuq'ui chi'iwonojel riyix ri yix samajnek y ri yixc'o chuxe' jun ejka'n, y riyin xtinben c'a chiwe chi yixuxlan. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Riyix tic'uaj c'a ri nuyugo chrij tak iwi', y tiwetamaj c'a chuwij riyin, chi riyin nc'uan jun c'aslen ch'uch'uj y nch'utinirisan wi'. Can quec'ari' tibana' riyix riche (rixin) chi ri iwánima xtril uxlanen. ");
INSERT INTO cakWNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ruma ri nuyugo riyin ma ruc'ayewal ta ruc'uaxic y ma al ta ri wejka'n, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Y ya tiempo chuka' ri', pa jun uxlanibel k'ij, ri Jesús y ri rudiscípulos ye benak c'a pa jun ulef ri ticon trigo chuwech. Y ri discípulos xpe quinumic y rumari' c'o c'a ruwi' trigo ri yequich'upla' c'a riche (rixin) chi niquitij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y xetz'et c'a pe cuma ri achi'a' fariseos, y xquibij c'a chare ri Jesús: Que'atzu' la adiscípulos xajan yetajin chubanic. Ruma can ma utz ta chi yesamej chupan jun uxlanibel k'ij achi'el re k'ij re wacami, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yac'a ri Jesús xubij chique: ¿La majun bey c'a isiq'uin ta ri tz'ibatal ca chupan ri wuj chrij ri xquiben ri David y ri ye rachibil ri ojer ca, tek sibilaj xenum? ");
INSERT INTO cakWNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ri David xbe c'a chucanoxic wey chiri' pa rachoch ri Dios, y can ya ri lok'olaj tak caxlan wey ri xbejach pe chare. Riya' xutij ri lok'olaj tak caxlan wey ri' y xuya' chuka' chique ri ye benak riq'ui. Pero ma riq'ui wi ri', ma mac ta ri xquiben, astape' ri caxlan wey ri' xaxu (xaxe wi) ri sacerdotes yetijo. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Riyin nbij chi riyix can isiq'uin chuka' ri tz'ibatal chupan ri ley riche (rixin) ri Moisés, chi ri sacerdotes can yesamej wi pa rachoch ri Dios chupan ri uxlanibel k'ij y riye' ma mac ta ri niquiben. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ri' ruma chi ri rachoch ri Dios can c'o wi ruk'ij. Yac'a re wacami, yinc'o riyin ri más nuk'ij que chuwech ri rachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Xa ta riyix iwetaman achique ntel wi chi tzij ri nubij chupan ri ruch'abel ri Dios, man ta xixcowin xibij chi ri nudiscípulos ma utz ta yetajin chubanic. Ruma chupan ri ruch'abel ri Dios nubij: Riyin ri más nika chinuwech chi niben riyix, ya chi nijoyowaj quiwech ri winek, ya c'a ri' ri más nika chinuwech, que chuwech ri chicop ri yecamisex y ye'itzuj (ye'isuj) chinuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Riyin ri C'ajolaxel ri xinalex chicojol can yin Rajaf ri uxlanibel k'ij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y tek ri Jesús y ri ye rudiscípulos ye k'axnek chic chupan ri tico'n ri', riye' xebe ri pa jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y chiri' chiquicojol ri winek ri quimolon qui', c'o c'a jun achi chaki'j jun ruk'a'. Xepe c'a ri winek ri' xquic'utuj chare ri Jesús: ¿La ruc'amon cami chi nic'achojsex jun yawa' pa jun uxlanibel k'ij? xecha' chare. Queri' c'a ri xquic'utuj chare ruma nicajo' yetzujun (yesujun) chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Xpe c'a ri Jesús xubij chique: Wi jun chiwe riyix c'o ta jun rucarne'l ri nitzak ta chupan jun jul pa jun uxlanibel k'ij, ¿achique ta cami nuben riq'ui? ¿La ma nrelesaj ta cami chiri'? Riya' xa can nuc'om wi ka riche (rixin) chi nrelesaj pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","C'a ta c'a jun achi chi man ta nic'achojsex, tek xa can c'o más ruk'ij que chuwech jun carne'l. Xa rumac'ari' tek can ruc'amon wi chi niban ri utz pa jun uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Y c'ac'ari' tek ri Jesús xubij chare ri achi ri chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achi can xu (xe wi) xuyuk ri ruk'a', can yac'ari' xchojmir y xuben achi'el ri jun chic ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y ri achi'a' fariseos can xu (xe wi) xquitz'et ca ri xbanatej, xebe y xbequimolo' qui' riche (rixin) chi niquich'ob achique rubanic niquiben riche (rixin) chi niquicamisaj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús xel c'a el chiri' ruma Riya' can retaman wi ri niquich'ob chrij. Riya' can sibilaj ye q'uiy c'a ri winek xetzekelben el riche (rixin). Y yeruc'achojsaj c'a quinojel ri ye yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Y can nuchilabej c'a el chique quinojel riye' chi ma tiquiya' ta rutzijol chi Riya' xeruc'achojsaj chare ri quiyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ri Jesús xubanala' c'a ronojel ri' riche (rixin) chi queri' can nibanatej wi c'a ri ruk'alajsan chic ri Dios chuwech ri profeta Isaías, ri xk'alajsan ri ruch'abel ri Dios ojer ca. Ri tz'ibatal c'a ca nubij: ");
INSERT INTO cakWNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yac'are' ri Nusamajel ri nucha'on. Riyin sibilaj nwajo' Riya'; can niquicot c'a ri wánima riq'ui. Can xtinya' c'a pe chuka' ri nu-Espíritu pa ruwi'; y Riya' xtuk'alajsaj c'a chiquiwech ri ma ye israelitas ta, ri achique rubanic niquic'uaj jun c'aslen choj. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ma xtuben ta oyowal, ma xturek ta ruchi', ni ma xtutzijoj ta ri' chiquiwech ri winek ri pa tak bey. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y ri aj ri xa paxnek chic, Riya' ma xtuben ta c'a chare chi nik'aj. Chuka' jun k'ak' ri xa nibuku chic ruma xa nichuptej yan ka, Riya' xtuben chare chi ma xtichuptej ta ka. Y queri' xtuben apo, c'a ya tek xtapon ri k'ij chi Riya' xtuben chi xtich'acon ri utzilaj ruk'atbel tzij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri winek c'a ri ma ye israelitas ta, riq'ui c'a Riya' xticoyobej wi ri quicolotajic. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y c'o c'a jun achi moy y mem xuc'uex apo chuwech ri Jesús, y queri' ruc'ulwachin ruma chapatajnek ruma jun itzel espíritu. Y ri Jesús can xrelesaj c'a el ri itzel espíritu ri'. Can xuben c'a chare ri achi chi xtzu'un y xch'o. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y rumari' tek quinojel winek can xquimey tek xquitz'et y niquibila' c'a: ¿La ma ya ta cami re' ri Cristo ralc'ual ca ri David ri koyoben? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Yac'a tek ri achi'a' fariseos xquic'axaj ri niquibij ri winek chrij ri Jesús, riye' xquibij c'a: Ri Jesús yerelesaj itzel tak espíritu pero xa ya ri Beelzebú ri cajawalul ri itzel tak espíritu ri niya'o uchuk'a' chare, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y ruma chi ri Jesús can retaman c'a ri niquich'obola' ri achi'a' fariseos, Riya' xubij chique: Wi ri winek riche (rixin) jun ruwach'ulef wi xa ma junan ta quiwech niquiben, nipe ch'a'oj chiquicojol. Y ri' ma utz ta, ruma nuben chare ri quiruwach'ulef chi ma xtiyaloj ta. Y queri' chuka' ronojel tinamit y quinojel winek ri yec'o chupan jun jay, wi xa ma junan ta quiwech niquiben, xa xtiquitaluj el qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y wi ri Satanás yerelesaj el ri can yesamej riq'ui, can ntel c'a chi tzij chi xa ruyon riya' nrokotaj el ri'. Xa ruyon riya' nuben ka ch'a'oj chrij. Y wi queri' nuben, chanin nitzak y niq'uis ka ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Riyix nibij chuwe chi xa uchuk'a' riche (rixin) ri Beelzebú ri ncusaj riyin tek yenwelesaj ri itzel tak espíritu, pero ri ye tzekelbey iwuche (iwixin) riyix yequelesaj chuka' itzel tak espíritu. ¿La ya cami ruchuk'a' ri Beelzebú ri niquicusaj chuka' riye' nich'ob riyix? Rumari' yec'a ri ye tzekelbey iwuche (iwixin) riyix, yec'a riye' ri xquebin chiwe chi xa ma kitzij ta ri xibij chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Yac'a wi riyin riq'ui ri ru-Espíritu ri Dios yenwelesaj wi ri itzel tak espíritu, ntel chi tzij chi kitzij chi xoka yan ri rajawaren ri Dios iwuq'ui riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y ri nrajo' nelek' el pa rachoch jun achi ri c'o sibilaj ruchuk'a', nabey c'o chi nuxim ri achi ri', y c'ac'ari' nicowin nucanoj el ronojel ri nrajo' yeruc'uaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Achique c'a ri ma ruya'on ta ránima wuq'ui, xa can yiretzelaj wi c'a ri'. Y achique ri ma nito'o ta wuche (wixin), xa yari' ri niyojo ronojel ri yenben riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y rumac'ari' riyin nbij chiwe: Ri mac y ri yok'onic ri yequibanala' ri winek, can c'a yecuyutej na. Yac'a ri yeyok'on chrij ri Lok'olaj Espíritu, can ma xticuyutej ta quimac. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y xabachique c'a winek ri niyok'on chuwij riyin ri C'ajolaxel ri xinalex chicojol, can c'a nicuyutej na rumac. Yac'a ri niyok'on chrij ri Lok'olaj Espíritu, can man c'a xticuyutej ta rumac re wacami, ni ri chkawech apo. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","O niben achi'el jun che' utz, ri utz ruwech ri nuya' o niben achi'el jun che' ri ma utz ta, ri xa ma utz ta ruwech ri nuya'. Ruma jun che' netamatej ruwech riq'ui ri ruwech ri nuya', wi utz ri che' ri' o xa ma utz ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Rumac'ari' riyix ri xa yix achi'el itzel tak cumatz, ¿achique modo yixcowin nibij ri utz, tek xa yix itzel tak winek? Ruma chi jun winek can ya c'a ri yec'o pa ránima ri yerubij. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzilaj winek, ri utz ri yec'o pa ránima, yeri' ri yerubij pe tek nitzijon. Yac'a ri winek ri xa itzel yec'o pa ránima, yeri' ri yerubij pe tek nitzijon. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y riyin nbij c'a chiwe chi chupan ri k'ij tek xtik'at tzij pa ruwi' re ruwach'ulef, ri winek ri xebin ch'abel ri xa majun rejkalen, can xtik'at c'a tzij pa quiwi', ruma ronojel ri ch'abel ri xequibila'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Riq'ui ri ch'abel ri nibij, riq'ui ri' xtik'at tzij pan iwi'. Wi utzilaj ch'abel ri nibij, riq'ui ri' nik'alajin chi choj ri ic'aslen chuwech ri Dios. Yac'a ri ch'abel wi xa majun rejkalen ri nibij, riq'ui ri' nik'alajin chi xtika ruc'ayewal pan iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Y yec'o c'a chique ri aj tz'iba' y yec'o chuka' chique ri achi'a' fariseos ri xech'o apo chare ri Jesús, y xquibij c'a: Riyit ri can yit jun Tijonel, riyoj nikajo' nikatz'et c'a chi naben jun milagro chkawech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yac'a ri Jesús xubij c'a chique: Ri winek yec'o wacami sibilaj ye itzel y xa ma niquinimaj ta chic ri Dios. Riye' xa can nicajo' c'a chi riyin nben na jun milagro chiquiwech c'ac'ari' chi yinquinimaj. Y xa ma ya ta c'a ri nicajo' riye' ri xtibanatej. Ruma xa can xu (xe wi) ri xbanatej riq'ui ri profeta Jonás ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca, xaxu (xaxe wi) c'a ri' ri retal ri xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ruma achi'el xc'oje' ri Jonás chupan jun nimalaj car oxi' k'ij y oxi' ak'a', can queri' chuka' ri retal ri xtinya' riyin chiwech. Riyin c'a ri C'ajolaxel ri xinalex chicojol, xquimuke' oxi' k'ij y oxi' ak'a' pan ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y tek xtapon c'a ri k'ij riche (rixin) chi xtik'at tzij pa quiwi' ri winek ri yec'o re tiempo re', xquec'astej c'a pe ri winek aj Nínive y xtiquibij c'a chi ma utz ta xquiben ri winek ri yec'o re tiempo re'. Ruma ri winek ri xec'oje' pa tinamit Nínive ri ojer ca, can xu (xe) wi c'a xquic'axaj ri ruch'abel ri Dios ri xutzijoj ri Jonás chique, can yac'ari' tek xtzolin pe quic'u'x riq'ui ri Dios. Y wacami yinc'o riyin ri más nim nuk'ij que chuwech ri Jonás, y xa ma yinquinimaj ta ri winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y tek xtapon c'a chuka' ri k'ij riche (rixin) chi xtik'at tzij pa quiwi' ri winek ri yec'o re tiempo re', xtic'astej c'a pe ri jun reina ri xc'oje' ojer ca, ri xk'ato tzij pa ruwi' ri ruwach'ulef ri c'o pa sur. Y xtubij c'a chi ma utz ta xquiben ri winek ri yec'o re tiempo re'. Ruma tek xc'ase' ri jun reina ri', sibilaj nej xbiyin wi riche (rixin) chi xorac'axaj ri runa'oj ri jun rey riche (rixin) re Israel, ri xubini'aj Salomón ri xc'oje' ojer ca, y wacami yinc'o riyin ri más nim nuk'ij que chuwech ri rey Salomón. Y xa ma yinquinimaj ta ri winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tek jun itzel espíritu ntel el pa ránima jun winek, nucanoj uxlanen pa chaki'j tak lugar. Tek nuna' chi majun uxlanen nril, ");
INSERT INTO cakWNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","nuch'ob ka: quitzolin na chic pa ránima ri winek ri acuchi (achique) xinel wi pe, nicha' c'a. Y tek ri itzel espíritu ri' nitzolin chic apo pa ránima ri winek, nril c'a ri ránima ri winek ri' achi'el jun jay ri majun c'o ta chupan, meson y wikon jabel. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y c'ac'ari' tek ri itzel espíritu ri' yeberuc'ama' pe ye wuku' chic itzel tak espíritu ri más chi na ye itzel, y quinojel c'a ri' ye'oc pa ránima ri winek. Y ri winek achoj riq'ui yec'oje' wi ri itzel tak espíritu ri', más lawalo' nuben ri ruc'aslen que chuwech ri rubanon pa nabey mul. Y can quec'ari' xtiquic'ulwachij ri winek ri itzel quic'aslen, ri yec'o re tiempo re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y ri Jesús can c'a nich'o na quiq'ui ri winek tek xapon ri rute' y ri ye rach'alal. Riye' nicajo' c'a yech'o riq'ui ri Jesús, xa yac'a ri ma xe'oc ta apo c'a riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y c'o c'a jun ri xbin apo chare ri Jesús: Ri ate' y ri ye awach'alal yec'o pe wawe' chuwajay el. Riye' nicajo' yech'o awuq'ui, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yac'a ri Jesús xubij c'a chare ri xbin apo queri': ¿Achique c'a ri' ri nte' y ye achique c'a ri' ri wach'alal ri nach'ob riyit? ");
INSERT INTO cakWNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y ri Jesús riq'ui c'a ri ruk'a' xeruc'ut ri rudiscípulos y xubij c'a: Yec'are' ri ye oconek nte' y ye oconek wach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ruma chi can quinojel c'a ri yebano ri ruraybel ri Nata' Dios ri c'o chila' chicaj, yec'ari' ri ye achi'el nte', wana' y nchak', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupan c'a ri k'ij ri' ri Jesús ye rachibilan ri ye rudiscípulos xel el pa jay y xbetz'uye' chuchi' ri choy. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y sibilaj ye q'uiy winek ri xquimol apo qui' riq'ui. Rumari' Riya' xoc apo pa jun jucu' y xtz'uye' ka chiri' y nubij c'a pe ri ruch'abel ri Dios chique ri winek. Y quinojel c'a ri winek yec'o chuchi' ri choy xquic'axaj apo ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Riya' q'uiy c'a ri xubij chique, xa yac'a chi ruyon riq'ui c'ambel tak tzij. Y jun c'a chique ri c'ambel tak tzij ri xucusaj, yare': C'o c'a jun achi ri xbe pa jopin ija'tz. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y tek ri achi c'o chic pa samaj nijopin ija'tz, c'o c'a juba' chare ri ija'tz ri' xa pa bey xka wi. Y xepe c'a ri aj xic' tak chicop ri yebe pa cak'ik' xquitij el ri ija'tz ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","C'o c'a juba' chic chare ri ija'tz cojol tak abej xka wi y chiri' xa ma q'uiy ta ri ulef c'o. Y can chanin c'a xe'el pe ruma chi ma pim ta ri ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xa yac'a tek xpe ruchuk'a' ri k'ij, xemayamo' y xechaki'j ka chanin, ruma chi xa ma nej ta benak wi ka ri quic'amal. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y juba' chic chare ri ija'tz xka cojol tak k'ayis ri c'o quiq'uixal. Y tek xe'el pe, junan xeq'uiy quiq'ui ri q'uix. Y ruma chi ri q'uix sibilaj xeq'uiy, ri tico'n xejik' pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yac'a ri juba' chic chare ri ija'tz xka pa jun utzilaj ulef, jabel xeq'uiy y xewachin chuka' jabel. Ruma c'o ija'tz xquiyala' a treinta quiwech, c'o xquiyala' a sesenta quiwech y c'o ri can jojun ciento quiwech xquiyala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y yac'ari' tek ri discípulos xebe apo riq'ui ri Jesús y xquic'utuj chare: ¿Achique ruma tek riq'ui c'ambel tak tzij yach'o wi chiquiwech ri winek? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Xpe c'a ri Jesús xubij chique: Chiwe c'a riyix can ya'on c'a k'ij riche (rixin) chi niwetamaj chrij ri rajawaren ri Dios, ri ma k'alaj ta chiquiwech nic'aj chic winek, ruma riye' ma ya'on ta k'ij chique riche (rixin) chi niquetamaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ruma chi ri can c'o q'uiy riq'ui, xtiya'ox (xtya') c'a más chare y queri' q'uiy ri xtic'oje' riq'ui. Yac'a ri xa juba' oc c'o riq'ui, hasta ri juba' ri' xa xtelesex chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Xa rumac'ari' tek riyin yencusaj c'ambel tak tzij riche (rixin) chi yich'o quiq'ui riche (rixin) chi queri' astape' niquitzu' y xa ma nich'obotej ta chiquiwech ri niquitzu', y riche (rixin) chi astape' niquic'axaj y xa ma nik'ax ta chiquiwech ri niquic'axaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Can ya wi c'a re' nibanatej ri tz'ibatal ca ruma ri profeta Isaías, ri xk'alajsan ri ruch'abel ri Dios ojer ca. Y quec'are' ri rutz'iban ca riya': Riyix xtiwac'axaj y ma xtik'ax ta chiwech ri xtiwac'axaj. Riyix xtitzu' y xa ma xtiya' ta c'a pa cuenta ri nitzu'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ruma ri cánima re winek re' xa xquicowirisaj. C'ayef (cuesta) chi ntoc pa tak quixquin ri niquic'axaj. Ri runak' tak quiwech quiyupuban, ruma ma nicajo' ta yetzu'un. Riye' can majun nicajo', can ma nicajo' ta niquic'axaj, can ma nicajo' ta nika pa tak cánima, ma nicajo' ta nitzolin pe quic'u'x, riche (rixin) chi riyin nchojmirisaj ri quic'aslen. Queri' ri xubij ri Dios, ri tz'ibatal ca ruma ri Isaías. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yac'a riyix nudiscípulos, can jabel wi ruwa'ik'ij, ruma chi ri runak' tak iwech can yetzu'un wi jabel y ri ixquin can ye'ac'axan wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Riyin can kitzij c'a nbij chiwe wacami, chi ye q'uiy chojmilaj tak winek y ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, sibilaj xcajo' chi xquitz'et ta ri nitz'et riyix wacami, y xa ma xquitz'et ta el. Can sibilaj chuka' xcajo' chi xquic'axaj ta ri niwac'axaj riyix re wacami, y xa ma xquic'axaj ta el. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y ri Jesús xubij c'a chique: Tiwac'axaj c'a achique nubij ri c'ambel tzij ri nich'o chrij ri achi ri xbe pa jopin ija'tz. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri juba' ija'tz ri xka pa bey, yari' ri nich'o chrij ri ch'abel riche (rixin) ri rajawaren ri Dios, ri nac'axex ruma jun winek, y xa ma nik'ax ta chuwech. Rumari' nipe ri itzel nrelesaj el ri ch'abel ri xtic pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija'tz ri xka cojol tak abej, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex ruma jun winek. Ri winek ri' can chanin c'a nuc'ul ri ruch'abel ri Dios pa ránima riq'ui quicoten. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Xa yac'a chi ma xbe ta ka jabel ruc'amal ri ruch'abel ri Dios pa ránima, xa can ma niyaloj ta c'a ri quicoten riq'ui. Y tek yepe c'a tijoj pokonal y netzelex ruma runiman ri ruch'abel ri Dios, chanin nitzak. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y ri ija'tz ri xka cojol tak k'ayis ri c'o quiq'uixal, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex ruma jun winek. Pero ri winek ri' xa ya c'a ri nrajo' re tiempo re' ri nuben y nik'olotej c'a pa ruk'a' ri beyomel riche (rixin) re ruwach'ulef, y rumari' xa nijik' c'a ri ruch'abel ri Dios ri c'o riq'ui. Y can majun bey c'a xtiwachin ta jabel ri ruch'abel ri Dios pa ruc'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Yac'a ri ija'tz ri xka pa jun utzilaj ulef, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex ruma jun winek, y ri winek ri' can nik'ax c'a ri ruch'abel ri Dios chuwech y ri ruc'aslen niwachin jabel. Can niwachin wi c'a achi'el niquiben ri ija'tz. Ruma c'o ija'tz ri niquiya' a treinta quiwech, yec'o ri niquiya' a sesenta quiwech y yec'o ri can jojun ciento c'a quiwech niquiya', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xutzijoj chic c'a jun c'ambel tzij chiquiwech ri winek, y xubij c'a: Ri rajawaren ri caj, junan c'a riq'ui jun achi ri xberutica' ca jun utzilaj ija'tz pa rulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Xa yac'a tek quinojel ri winek ye warnek, xpe c'a ri ruc'ulel ri rajaf ri ulef, xberutica' ca rujatzul ri itzel k'ayis chucojol ri trigo ri ticon chic ca. Y xu (xe wi) xberubana' ca ri', y xbe. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Yac'a tek xbeq'uiy pe ri tico'n y xuchop xebe'el pe ri ruwi', c'a yac'ari' tek xk'alajin ri itzel k'ayis. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y yac'ari' tek ri ye rumozo ri rajaf ri ulef xe'apon c'a riq'ui y xquibij chare: Ri ija'tz ri xatic ka pan awulef can utz wi. Xa yac'a wacami c'o itzel k'ayis chucojol. ¿Acuchi (achique) c'a xpe wi ri ija'tz riche (rixin) ri itzel k'ayis? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y ri achi xubij c'a chique ri ye rumozo: Re' rusamaj jun ri netzelan wuche (wixin), xcha'. Y ri ye rumozo xquibij c'a chare: ¿Nawajo' c'a chi yojbe chuc'ukic? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Yac'a ri achi xubij c'a chique ri rumozo: Mani, ma yixbe ta chuc'ukic, man xa ruma chi nic'uk ri itzel k'ayis yec'ukutej chuka' ri trigo. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Xa tiya' na c'a k'ij chare ri itzel k'ayis chi junan niq'uiy riq'ui ri trigo, c'a ya na tek xtapon ri k'ij riche (rixin) ri k'atoj. C'a ya na c'a k'ij ri' tek riyin xtinbij c'a chique ri xquebano k'atoj, chi nabey tiquimolo' ri itzel k'ayis y quequibanala' pa tak manojo riche (rixin) chi yeporox; y c'ac'ari' tiquik'ata' ri trigo riche (rixin) chi nbequiyaca' ca, xcha' ri achi. Queri' xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y ri Jesús xutzijoj chic c'a jun c'ambel tzij chiquiwech ri winek, y xubij c'a: Ri rajawaren ri caj junan riq'ui jun ti ija'tz riche (rixin) ri mostaza ri nberutica' ca jun achi pa rulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ruma ri ija'tz riche (rixin) ri mostaza astape' yari' ri más tak cocoj, yac'a tek niq'uiy, ya riya' ri sibilaj nim ntel que chiquiwech ri nic'aj chic ichaj. Y can achi'el jun ti alaj che' nuben. Rumari' ri aj xic' tak chicop ri yebe pa cak'ik', ye'apon chiri' y niquibanala' quisoc pa tak ruk'a', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xuya' chic c'a jun c'ambel tzij chiquiwech, y xubij c'a chique: Ri rajawaren ri caj junan c'a riq'ui ri ch'om (levadura) ri xberuc'ama' pe jun ixok y xuya' ca chupan oxi' pajbel harina, xuch'omirisaj c'a ronojel. Quec'ari' chuka' xtibiyin rutzijol ri ruch'abel ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y ronojel c'a ri xubij ri Jesús chique ri winek ri', ruyon c'ambel tak tzij yerucusaj tek nich'o quiq'ui. Can majun c'a ri xubij ta chique chi man ta xucusaj c'ambel tak tzij. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Riche (rixin) chi queri' can nibanatej c'a ri rubin ca ri profeta ri xk'alajsan ri ruch'abel ri Dios ojer ca. Ri rusamajel ri Dios can quec'are' ri rutz'iban ca chrij ri Jesús: Riyin tek xquich'o xquencusaj c'a c'ambel tak tzij. Q'uiy c'a ri can ye ewatel pe pa rutiquiribel re ruwach'ulef, xquenk'alajsaj c'a. Queri' nubij ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y tek ri Jesús rubin chic c'a chique ri winek chi quebe chi tak cachoch, yac'ari' tek Riya' xtzolin pa jay ye rachibilan ri rudiscípulos. Y yac'ari' tek ri rudiscípulos xejel apo riq'ui y xquibij c'a chare: Riyoj nikajo' c'a chi riyit nabij ta chake achique ntel wi chi tzij ri c'ambel tzij chrij ri trigo y ri itzel k'ayis ri xetic ca pa jun ulef. Ruma can ma xk'ax ta chkawech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús can xuk'alajsaj c'a chiquiwech ri c'ambel tzij, y xubij c'a: Ri ticonel riche (rixin) ri utzilaj ija'tz, yin c'a riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulef ri xban wi ri ticoj, can ya c'a re ruwach'ulef. Ri utzilaj ija'tz yec'a ri yec'o pa rajawaren ri Dios. Y ri itzel k'ayis yec'a ri can ye riche (rixin) wi ri itzel. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ri xbetico ca ri itzel k'ayis, ya c'a ri itzel winek. Ri k'atoj, ya c'a ri xtibanatej pa ruq'uisbel chare re tiempo re kachapon; y ri xquebano ri k'atoj yec'a ri ángeles. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Can achi'el c'a niban riq'ui ri itzel k'ayis chi ye'elesex el y yeporox pa k'ak', can quec'ari' chuka' xtibanatej pa ruq'uisbel chare re tiempo re kachapon. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Riyin ri C'ajolaxel ri xinalex chicojol xquentek c'a ri nu'ángeles chiquimolic quinojel ri yebano etzelal y ri yebano chique ri nic'aj chic chi yetzak. Ruma ma nwajo' ta c'a chi yec'o ta ri winek ri' chiquicojol ri yec'o pa rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y quinojel c'a ri xquemol el, xquebec'ak ca chupan ri nimalaj k'ak'; y chiri' c'a xque'ok' wi y xtiquikach'ach'ej quey. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yec'a ri winek ri choj chic quic'aslen can xquetz'itz'an c'a achi'el ri k'ij, pa rajawaren ri Tata'ixel ri c'o chila' chicaj. Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri rajawaren ri caj junan c'a riq'ui jun beyomel mukul ca pa jun ulef y xilitej ruma jun achi. Ri achi ri' xumuk chic c'a ca ri beyomel ri' y niquicot ránima xtzolin y xuchop c'a ruc'ayixic ronojel ri c'o riq'ui y c'ac'ari' xbe chulok'ic ri ulef ri acuchi (achique) mukul wi ri beyomel. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Y chuka' ri rajawaren ri caj, can junan c'a riq'ui jun lok'onel y c'ayinel quiche (quixin) tak abej ri nibix perlas chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tek ri achi ri' nril c'a ca jun perla sibilaj jabel y nic'ayix, junanin (anibel) nitzolin y nuc'ayij ronojel ri c'o riq'ui, c'ac'ari' nibe chulok'ic ri perla ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Y chuka' ri rajawaren ri caj xa junan c'a riq'ui jun ya'l chapabel car, ri niya'ox (nya') ka pa ya' y yeberuc'ama' pe quinojel quiwech car. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y tek nojnek chic c'a ri ya'l riq'ui car, niquic'uaj c'a el c'a chuchi' ya'. Y c'ac'ari' yetz'uye' chucha'ic. Ri utzilaj tak car yequiya' c'a pa tak chaquech, yac'a ri car ri xa ma ye utz ta, xa yequelesaj c'a ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quec'ari' ri xtic'ulwachitej pa ruq'uisbel chare re tiempo re kachapon. Ri ángeles xquepe c'a chiquicha'ic ri winek. Juc'an xquequiya' wi ri choj chic quic'aslen, y xquequelesaj c'a ca ri ma ye utz ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y ri winek ri ma ye utz ta, xquebequic'aka' c'a ca chupan ri nimalaj k'ak', y chiri' c'a xque'ok' wi y xtiquikach'ach'ej quey. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Y ri Jesús xubij c'a chique ri rudiscípulos: ¿Xk'ax chiwech ronojel re xinbij chiwe? xcha' chique. Y ri discípulos xquibij c'a: Ja' (je) Ajaf, xk'ax chkawech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Riya' xubij chic c'a: Can utz wi chi xk'ax chiwech, ruma xixoc yan achi'el jun aj tz'ib ri q'uiy retaman chrij ri ye tz'ibatal ojer ca, y q'uiy chuka' ntajin nretamaj chrij ri rajawaren ri Dios. Y rumari' can yix junan c'a riq'ui jun tata'aj pa jun jay ri can c'o rubeyomal ruyacon. Tek c'o nic'atzin wi, riya' yeberelesaj pe ri can c'o chic k'ij ye ruyacon y yeberelesaj pe chuka' ri xa c'a juba' quec'oje' riq'ui, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y tek ri Jesús xtane' c'a chubixic ri c'ambel tak tzij ri', Riya' xel c'a el chiri' y xbe, ye rachibilan el ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yac'a tek xapon pa tinamit ri acuchi (achique) xq'uiy wi, Riya' xuchop c'a ruc'utic ri ruch'abel ri Dios ri chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios. Y ruma c'a ri ch'abel ri yerubij chique, ri winek ri' can xquimey c'a y xquibij: ¿Achique c'a ruma tek re achi re' sibilaj q'uiy etamabel c'o riq'ui y nicowin yeruben milagros? ");
INSERT INTO cakWNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿La xa ma ya ta cami re' ri ruc'ajol ri jun achi ri aj samajel chrij che'? ¿La xa ma ya ta c'a re' ral ri María y rach'alal ri Jacobo, ri José, ri Simón y ri Judas? ");
INSERT INTO cakWNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y ri ye rana', ¿la xa man ta c'a yec'o chkacojol? ¿Acuchi (achique) ta c'a xretamaj wi ri retaman y acuchi (achique) ta c'a petenak wi ri ruchuk'a' riche (rixin) chi yerubanala' milagros? yecha' chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y rumari' ri winek can ma juba' xquinimaj ta ri Jesús. Y ri Jesús xubij c'a chique ri winek ri': Majun c'a jun profeta ri nik'alajsan ri ruch'abel ri Dios, ri man ta jun ruk'ij. Quinojel can c'o wi quik'ij, xa yac'a chi ma niya'ox (nya') ta quik'ij pa tak quitinamit y pa tak cachoch, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Chupan ri rutinamit, ri Jesús ma q'uiy ta c'a milagros ri xerubanala', ruma ri ruwinak ma xquinimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ri Herodes jun chique ri ye caji' aj k'atbel tak tzij chupan ri tiempo ri', xrac'axaj c'a chi ri Jesús sibilaj rutzijol c'o chiquicojol ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y ri Herodes xubij c'a chique ri rusamajel: Ri Jesús xa ya ri Juan ri Bautista ri xc'astej pe chiquicojol ri caminaki'. Rumari' tek c'o uchuk'a' pa ruk'a' riche (rixin) chi q'uiy ri nicowin yerubanala', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ruma can ya wi c'a ri rey Herodes ri xbin chi tichapatej ri Juan. Can xuxim wi c'a pa cadena y xuya' pa cárcel ruma ri Herodes ruc'amon ka ri Herodías rixjayil ri Felipe, y ri Felipe ri' xa can rach'alal ri Herodes, ");
INSERT INTO cakWNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","y ri Juan rubin c'a chare ri Herodes: Ma utz ta abanon chi ac'amon ka ri awixnan. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y rumac'ari' ri Herodes can rajowan wi c'a chi rucamisan ta ri Juan, xa yac'a ri can nuxibij c'a ri' chiquiwech ri winek, ruma riye' can quetaman wi chi ri Juan ri Bautista can jun profeta ri nik'alajsan ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero chupan ri k'ij tek ri Herodes xtz'aket chic jun rujuna', riya' xuben c'a jun nimak'ij, y chupan c'a ri nimak'ij ri' ri k'opoj ral ri Herodías xxajo c'a chuwech ri Herodes, y ri xajoj ri xuben ri k'opoj sibilaj xka chuwech ri Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y rumari' ri Herodes xuben c'a jurar chare ri ral ri Herodías chi xabachique c'a ri nrajo' can xtuya' wi chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Yac'a tek ri k'opoj can ya'on chic c'a runa'oj ruma ri rute', can yac'ari' tek xubij chare ri Herodes: Riyin nwajo' chi naya' pe wawe' pa jun plato, ri rujolon (ruwi') ri Juan ri Bautista, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y ri rey Herodes can xpe bis pa ránima ruma ri xc'utux chare, pero ruma chi can rubanon chic jurar chi can xtuya' wi ri xtrajo' ri k'opoj y ruma chuka' chi can chiquiwech ri ye rachibilan pa mesa tek xubij; rumari' riya' xubij c'a chi tic'amer pe ri rujolon (ruwi') ri Juan ri Bautista chare ri k'opoj ral ri Herodías. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutek c'a rutzaq'uixic rujolon (ruwi') ri Juan ri Bautista chiri' pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y ri rujolon (ruwi') xc'amer pe pa jun plato chare ri k'opoj, y ri k'opoj xberuya' pa ruk'a' ri rute'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y ri ye rudiscípulos ri Juan ri Bautista xe'apon c'a chuc'amaric ri ruch'acul y xbequimuku' ca. Y riye' xbequibij c'a chuka' chare ri Jesús ronojel ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y ri Jesús can xu (xe) wi c'a xrac'axaj el ronojel ri xbanatej, xbe, ye rachibilan el ri rudiscípulos. Xe'oc el pa jun jucu' y xek'ax c'a juc'an chic ruchi' choy, xebe c'a pa jun desierto. Yac'a tek ri winek xquic'axaj el, chicaken c'a xe'el el ri pa tak tinamit riche (rixin) chi xe'apon c'a acuchi (achique) xbe wi ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y tek ri Jesús xel c'a pe chupan ri jucu' chiri' ri juc'an chic ruchi' choy, xutz'et c'a chi sibilaj ye q'uiy chic ri winek ri ye oyobeyon apo riche (rixin) y Riya' xujoyowaj c'a quiwech ri winek ri'. Y Riya' can xeruc'achojsaj wi c'a ri yawa'i' ri yec'o chiquicojol. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y tek xa ntoc c'a pe ak'a' chupan ri jun k'ij ri', ri rudiscípulos xejel c'a apo riq'ui y xquibij chare: Re wawe' xa majun c'o y xa xka ka k'ij. Que'ataka' c'a el re winek re' riche (rixin) chi yebe ri pa tak aldea ri yec'o pe nakaj riche (rixin) chi nbequilok'o' quiway, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yac'a ri Jesús xubij chique ri rudiscípulos: Ma rajawaxic ta chi yebe riche (rixin) chi niquicanoj quiway, xa tiya' quiway riyix, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y ri rudiscípulos xquibij c'a: Riyoj xaxu (xaxe wi) wu'o' caxlan wey y ca'i' car c'o kiq'ui, y re' ma xqueruben ta, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yac'a ri Jesús xubij chique: Tic'ama' pe wawe'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y can yac'ari' tek Riya' xubij chique quinojel ri winek chi quetz'uye' pa ruwi' ri rexlaj k'ayis. Yac'ari' tek Riya' xeruli'ej c'a pa ruk'a' ri wu'o' caxlan wey y ri ca'i' car y c'ac'ari' xtzu'un chicaj y xuc'utuj ri rubendición ri Dios pa ruwi'. C'ac'ari' xeruwech'ela' c'a el ri caxlan wey y ri car y xuya' el chique ri rudiscípulos y ri discípulos xbequiyala' chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Can quinojel c'a jabel xewa'. Can majun c'a ri man ta xwa' chi utz. Y c'a c'o na c'a cablajuj chaquech ri xnoj ca riq'ui ri caxlan wey rachibilan car ri xmolotej ca, ri xa ma xq'uis ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Sibilaj ye q'uiy c'a ri winek ri xewa' ruma xaxu (xaxe) wi ri achi'a' yec'o wu'o' mil, yac'a ri ixoki' y ri ac'ala' ma xe'ajlex ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y yac'ari' tek ri Jesús xerucusaj el ri rudiscípulos chupan ri jucu' y xubij chique chi quebe c'a ri juc'an chic ruchi' ya'; chi can quenabeyej c'a el chuwech, ruma Riya' c'a yerutek na ca ri winek chi tak cachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yac'a tek ye rutakon chic ca ri winek chi tak cachoch, ruyon c'a xjote' el pa ruwi' ri juyu' chubanic orar. Y c'a chiri' c'a c'o wi tek xoc pe ri ak'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y ri jucu' ri ye benak wi ri discípulos pa runic'ajal chic c'a ri choy c'o wi, pero ri ruwi' ya' y ri cak'ik' nupaxij ri' chuwech ri jucu' y ma nuya' ta k'ij chare ri jucu' chi choj nibiyin chiquiwech, xa nutzolij c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y tek xa ruchapon c'a pe rusekeric, ri Jesús petenak c'a chraken pa ruwi' ri choy, riche (rixin) chi napon quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Yac'a tek ri rudiscípulos xquitz'et chi c'o jun petenak chraken pa ruwi' ri choy, riye' xsach quic'u'x y xquibij: ¡La' jun subunel (xibinel)! xecha'. Y xquirek quichi' tek xquibila' queri' ruma xquixibij qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yac'a ri Jesús chanin xch'o pe chique, y xubij c'a: Ma tixibij ta iwi'. Xa ticukuba' ic'u'x, xa yin c'a riyin, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y tek ri Jesús c'a petenak na pa ruwi' ya', ri Pedro xch'o c'a apo chare y xubij: Ajaf, wi yit c'a riyit, tabana' c'a chuwe chi yibiyin pa ruwi' ya' riche (rixin) chi yibe apo awuq'ui, xcha' ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Ajaf xubij pe chare ri Pedro: Catan c'a pe. Y ri Pedro can yac'ari' tek xel el chupan ri jucu' y xuchop c'a nibiyin pa ruwi' ya' riche (rixin) chi nibe apo riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Xa yac'a tek xutz'et ri nuben ri nimalaj cak'ik', xpe xibinri'il chare. Y tek xuna' chi nibe ka chuxe' ya', riq'ui c'a ruchuk'a' xubij: ¡Ajaf, quinacolo'! xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y ri Jesús can yac'ari' tek chanin xuchop ruk'a' ri Pedro y xubij chare: ¿Achique c'a ruma tek xa juba' oc xacukuba' ac'u'x wuq'ui? xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tek riye' ye oconek chic el pa jucu', xtane' ri cak'ik'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y can yac'ari' tek quinojel ri ye benak chiri' pa jucu' xquiya' c'a ruk'ij ri Jesús y xquibij c'a chare: Can kitzij wi chi yit Ruc'ajol ri Dios, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y riye' xek'ax c'a pa ruwi' ri choy ri' y xe'apon chuchi' ya' chiri' pa Genesaret. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri chiri', tek xetamex c'a ruwech ri Jesús cuma ri achi'a', riye' xquelesaj c'a rutzijol chanin pa ronojel lugar ri yec'o pe chunakajal ri quitinamit, y ri winek xequic'amala' c'a pe ri yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y ri yawa'i' ri' can niquic'utuj c'a utzil chare ri Jesús, chi tuya' k'ij chique chi astape' xaxu (xaxe) ta ruchi' ri rutziak niquichop riche (rixin) chi yec'achoj. Y can queri' wi c'a xbanatej. Quinojel c'a ri xechapo ruchi' rutziak ri Jesús xec'achoj chare ri quiyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y yec'o c'a ca'i' oxi' achi'a' ri xe'apon riq'ui ri Jesús. Ri achi'a' ri' ye aj Jerusalem, y yeri' ri nibix fariseos y aj tz'iba' chique. Xe'apon c'a riq'ui ri Jesús y xquibij c'a chare: ");
INSERT INTO cakWNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Achique c'a ruma tek la adiscípulos riyit ma niquiben ta ri bin ca cuma ri kati't kamama'? Ruma ri adiscípulos tek yewa' ma niquich'ej ta quik'a' achi'el rubanic ri nikaben riyoj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Y ruma chi queri' xquic'utuj chare ri Jesús, Riya' xubij c'a chique: ¿Achique c'a ruma tek riyix xa ya ri quibin ca ri iwati't imama' ri niben? Riq'ui ri' niben chare ri rupixa' ri Dios chi majun rejkalen. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ri rupixa' ri Dios nubij c'a: Taya' quik'ij ri ate' atata'. Y wi c'o jun nibin pokon tak ch'abel chique ri rute' rutata', can majun chic c'a ri nrajo', xa can ticamisex. Quec'ari' ri rubin ca ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Yac'a riyix xa ma que ta ri' niben y nic'ut. Xa ma niben ta achi'el ri rubin ca ri Dios. Riyix xa ye'itijoj ri alc'ualaxela' chi ma rajawaxic ta chi yequito' ri quite' quitata'. Riyix xa nibij chique ri alc'ualaxela' chi xa tiquibij chique ri quite' quitata': Riyin ma yicowin ta yixinto' riq'ui ri nic'atzin chiwe, ruma ri c'o wuq'ui xa ntzujun (nsujun) chic chare ri Dios, yixcha' chique. Y riq'ui niquibij queri' chi quitzujun (quisujun) chic chare ri Dios, xa riche (rixin) chi ma yequito' ta ri quite' quitata'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y riq'ui ri nibij queri', can nik'alajin wi chi riyix nibij chique ri alc'ualaxela' chi ma tiquiya' ta quik'ij ri quite' quitata'. Y riq'ui ri', riyix ibanon chare ri rupixa' ri Dios chi majun rejkalen. Y queri' ibanon xaxu (xaxe wi) riche (rixin) chi niben ri quibin ca ri iwati't imama'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Riyix xa ca'i' c'a ipalej. Xa can jabel c'a rubixic rubanon ca ri Isaías chiwij. Ruma ri Isaías rutz'iban c'a ca ri xbix chare ruma ri Dios y quec'are' ri nubij: ");
INSERT INTO cakWNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Re winek re' xaxu (xaxe) wi c'a riq'ui ri quich'abel niquiya' nuk'ij, yac'a ri cánima xa nej c'o wi el chuwe riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa majun c'a nic'atzin wi chi niquiya' nuk'ij, ruma ri ch'abel ri niquic'ut xa pixa' quiche (quixin) winek y niquibij chi can yari' ri rajawaxic chi niban. Queri' ri rutz'iban ca ri Isaías, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y can yac'ari' tek ri Jesús xerusiq'uij (xeroyoj) apo ri winek riq'ui, ri quimolon qui' chiri', y xubij c'a chique: Tiwac'axaj c'a re xtinbij chiwe y tik'ax chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri nitz'ilobisan riche (rixin) ri winek ma ya ta c'a ri nutij ka, xa ya ri itzel tak ch'abel ri yerubij ri nitz'ilobisan riche (rixin), xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Yac'ari' tek ri discípulos xejel apo riq'ui ri Jesús, y xquibij chare: Ri fariseos xpe coyowal tek xquic'axaj ri ch'abel ri xabij, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yac'a Riya' xubij chique ri rudiscípulos: Ronojel tico'n ri ma ticon ta ruma ri Nata' ri c'o chila' chicaj xtic'uk el. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Xa que'iya' ca. Xa ye achi'el moyi' y ye uc'uey quiche (quixin) nic'aj chic ri xa ye achi'el moyi' chuka'. Y wi ri ye moyi' yequiyukej ri nic'aj chic moyi', junan c'a xquetzak pa tak jul, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y ri Pedro xubij c'a chare ri Jesús: Tabij juba' chake chrij ri nitz'ilobisan riche (rixin) jun winek, ruma can ma xk'ax ta chkawech, xcha' ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xubij: ¿Riyix chuka' can c'a ma jane nik'ax ta chiwech ri nbij? ");
INSERT INTO cakWNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿La ma nik'ax ta cami chiwech ri tzij ri nubij chi ri nutij ka ri winek, xa ma ya ta ri' ri nitz'ilobisan riche (rixin)? Ruma ri nutij ka xa chupan nibe wi y c'ac'ari' ntel el. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Yac'a ri itzel tak ch'abel ri nubij ri winek, can pa ránima c'a yepe wi, y ya c'a ri' ri nitz'ilobisan riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ruma chi can pa cánima c'a ri winek yepe wi ri itzel tak na'oj tek yecamisan. Chiri' chuka' nipe wi ri na'oj tek ri ixok c'o rachijil y nuc'om ruwech jun chic achi, y tek ri achi c'o rixjayil y nucanoj jun chic ixok, y ri winek ri yemacun y xa ma quic'ulaj ta qui'. Y pa cánima chuka' nipe wi tek ye'elek', tek yequibila' tzij ri xa ma kitzij ta chiquij nic'aj chic, y chuka' tek yeyok'on. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Y ronojel c'a ri yequibanala' ri achi'el ri', yari' ri nitz'ilobisan riche (rixin) ri winek. Yac'a ri nuben ri winek chi ma ruch'ajon ta jabel ri ruk'a' tek niwa', ri' xa ma nutz'ilobisaj ta ri ruc'aslen. Quec'ari' xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Y ri Jesús ye rachibilan ri rudiscípulos xel c'a el chiri', y xbe c'a quela' pa jun lugar ri nakaj nicanaj chique ri tinamit Tiro y Sidón. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chiri' c'o c'a jun ixok aj Canaán xpe c'a riq'ui ri Jesús. Riya' ruma nibison, can nuc'utuj c'a utzil chare ri Jesús y can nurakala' c'a ruchi' chubixic: Tajoyowaj nuwech riyit Ajaf, ri yit Ralc'ual ca ri rey David. Quinato' c'a, ruma ri ti wal c'o jun itzel espíritu riq'ui, y ch'ujernek pa ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Yac'a ri Jesús majun ch'abel xubij ta chare ri ixok. Y ri discípulos xejel apo riq'ui ri Jesús y xquibij chare: Tabij chare re ixok re' chi titzolin ca, ruma nurakala' ruchi' tzeketel pe chikij, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Xpe ri Jesús xubij: Riyin xitak pe xaxu (xaxe wi) chiquicanoxic ri winek israelitas ri quibanon achi'el carne'l ri ye sachnek, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Can yac'ari' xpe ri ixok xoxuque' xomaje' chuwech ri Jesús, y xubij chare: Ajaf, can quinato', xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yac'a ri Jesús xubij chare ri ixok: Ri rutzil ri Dios ma utz ta chi chare xabachique niya'ox (nya') wi. Ruma ma ruc'amon ta chi nelesex quiway ri alc'ualaxela', riche (rixin) chi niya'ox (nya') chique ri tak tz'i', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yac'a ri ixok xubij: Ajaf, can kitzij ri nabij. Pero chuka' ri tak tz'i' yequitij ri ruc'aj caxlan wey ri yequitzek ka ri cajaf chuxe' ri mesa. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y ri Jesús can yari' xubij chare ri ixok: Can nik'alajin chi nim ri acukbel c'u'x. Can tibanatej c'a ri nawajo' riyit, xcha' ri Jesús. Y ri ti k'opoj, ral ri ixok, can chupan c'a ri hora ri' xel el ri itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Tek ri Jesús k'axnek chic c'a pe chupan ri lugar ri nakaj nicanaj wi chique ri tinamit Tiro y Sidón, xapon c'a chunakajal ri choy Galilea. Riya' xjote' c'a pa ruwi' ri juyu', y tek c'o chic chiri' xtz'uye' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y yec'o c'a sibilaj ye q'uiy winek ri xe'apon riq'ui y ye quic'uan apo yawa'i'. Chique ri yawa'i' ri ye quic'uan apo, yec'o ri xa ma choj ta yebiyin ruma ye cojo, yec'o moyi', yec'o mema', yec'o ri ma utz ta ri quik'a' caken, y yec'o nic'aj chic ri jun wi chic ruwech chi yabil ri ntoc chique. Ri winek ri' xequiya' c'a apo ri yawa'i' chuwech ri Jesús, y Riya' xeruc'achojsaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Can ruma c'a ri xuben ri Jesús quiq'ui ri yawa'i', ri winek can xquimey tek xquitz'et. Ruma ri mema' tek rubanon ca, wacami yech'o chic. Ri ma utz ta ri quik'a' caken, xec'achoj. Ri ye cojo, choj chic yebiyin. Ri moyi', yetzu'un chic. Ri winek can xquiya' wi c'a ruk'ij ruc'ojlen ri Dios riche (rixin) ri Israel. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ri Jesús xerusiq'uij (xeroyoj) ri rudiscípulos, y xubij c'a chique: Riyin sibilaj njoyowaj quiwech re winek re', ruma c'o chic oxi' k'ij yec'o pe wuq'ui y wacami majun chic quiway riche (rixin) chi niquitij. Y yentek ta c'a el chi tak cachoch y xa majun niquitij el, ma utz ta; man xa quebetzak pa tak bey ruma wayjal, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Can yac'ari' tek xech'o apo ri discípulos chare ri Jesús y xquibij c'a: Re acuchi (achique) re yojc'o wi xa majun c'o. ¿Acuchi (achique) ta c'a nbekila' wi pe wey riche (rixin) chi yekatzuk jabel re winek re'? Xa can sibilaj ye q'uiy, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yac'a ri Jesús xuc'utuj c'a chique ri rudiscípulos: ¿Janipe' caxlan wey c'o iwuq'ui? xcha' chique. Y riye' xquibij: Riyoj xaxu (xaxe wi) wuku' caxlan wey y ca'i' oxi' tak car c'o kiq'ui, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xubij c'a chique ri winek chi quetz'uye' ka ri pan ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Yac'ari' tek Riya' xeruli'ej ri wuku' caxlan wey y ri car pa ruk'a' y tek rumatioxin chic chare ri Dios, c'ac'ari' xeruwech'ela' y xuyala' el chique ri rudiscípulos, y ri discípulos xequiya' chique ri sibilaj winek ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Can quinojel c'a jabel xewa'. Can majun c'a ri man ta xwa' chi utz. Y c'a c'o na caxlan wey y car ri xmol ca. Wuku' chaquech c'a ri xnoj riq'ui ri caxlan wey y car ri xemolotej ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ye caji' mil achi'a' c'a ri xewa', yec'a ri ixoki' y ri ac'ala' ma xe'ajlex ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y yac'a tek ri Jesús ye rutakon chic ca ri winek chi tak cachoch, Riya' ye rachibilan ri rudiscípulos xoc el pa jucu' y xbe c'a pa Magdala. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Y yac'ari' tek yec'o achi'a' fariseos y yec'o chuka' achi'a' saduceos xe'apon riq'ui ri Jesús. Ri achi'a' ri' xe'apon c'a riq'ui ri Jesús ruma nicajo' niquitojtobej y xquibij c'a chare chi tubana' chi c'o jun retal nibanatej chuwech ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yac'a ri Jesús xubij chique ri achi'a' ri': Tek riyix nitz'et chi quek rubanon ri sutz' chuwech ri caj, tek xka ka ri k'ij, nibij chi jabel ri tiempo nberubana'. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chuka' ri pa tak nimak'a', tek riyix nitz'et chi mukul ruwech ri caj y quek chuka' quibanon ri sutz', nibij chi ma utz ta ri k'ij nuben wacami. Riyix xa ca'i' c'a ipalej, ruma jabel iwetaman nitzu' achique nuben ruwech ri caj, iwetaman wi utz o ma utz ta ri k'ij nberubana'. Yac'a ri retal ri ntajin nibanatej chiwech wacami nubij achique tiempo yojc'o wi, pero riyix xa ma nitzu' ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri winek riche (rixin) re tiempo re' sibilaj ye itzel y xa ma niquinimaj ta chic ri Dios. Riye' xa can nicajo' chi riyin nben na jun milagro chiquiwech c'ac'ari' yinquinimaj. Xa ma ya ta c'a ri nicajo' riye' ri xtibanatej. Ma que ta ri'. Xa can xu (xe wi) achi'el ri xbanatej riq'ui ri profeta Jonás ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca, xaxu (xaxe) wi ri' ri retal ri xtibanatej, xcha' ri Jesús. Y xbe ye rachibilan ri rudiscípulos; xeruya' ca quiyon ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Y tek ri Jesús y ri rudiscípulos xe'apon c'a ri juc'an chic ruchi' ya', ri discípulos c'ac'ari' xquinabej chi xa majun caxlan wey quic'uan el. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ri Jesús xubij c'a chique ri rudiscípulos: Can tiwac'axaj c'a ri xtinbij chiwe, chi can tichajij c'a iwi' chuwech ri ch'om (levadura) quiche (quixin) ri achi'a' fariseos y ri achi'a' saduceos, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y ruma chi queri' xubij ri Jesús, ri discípulos xquich'ob c'a pa tak cánima: Riya' xubij queri' ruma majun caxlan wey xkac'om pe riche (rixin) chi nikatij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yac'a ri Jesús xretamaj c'a ri niquich'ob ri rudiscípulos pa tak cánima, y xubij c'a chique: ¿Achique ruma riyix nich'ob chi ruma majun caxlan wey xic'om pe, rumari' tek xinbij queri'? ¿Can ma icukuban ta ic'u'x wuq'ui y rumari' xaxu (xaxe wi) ri caxlan wey ri nich'ob? ");
INSERT INTO cakWNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Achi'el xa c'a ma jane nik'ax ta chiwech. ¿Y ma ninatej ta chiwe tek xentzuk ri wu'o' mil winek riq'ui ri wu'o' caxlan wey? ¿Can ma ninatej ta c'a chiwe janipe' chi chaquech caxlan wey ri ximol ca? ");
INSERT INTO cakWNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Chuka' can ma ninatej ta c'a chiwe tek xentzuk ri caji' mil winek riq'ui ri wuku' caxlan wey? Chuka' chiri' can c'a pa tak chaquech na ri xe'imol ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Achique ruma tek riyix ma xk'ax ta chiwech chi ma ruma ta chi majun caxlan wey ic'amom pe, tek xinbij chiwe chi can tichajij iwi' chuwech ri ch'om (levadura) quiche (quixin) ri fariseos y saduceos? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Y ri discípulos, c'ac'ari' xk'ax chiquiwech chi ma chuwech ta c'a ri ch'om (levadura) ri niquicusaj ri fariseos y saduceos ri c'o chi niquichajij wi qui'. Xa chuwech ri niquic'ut ri achi'a' ri', ri man achi'el ta nubij ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y ri Jesús ye rachibilan ri rudiscípulos xapon c'a pa jun lugar ri nakaj nicanaj wi chare ri tinamit Cesarea ri nibix chuka' riche (rixin) ri Felipe chare. Xpe ri Jesús xuc'utuj c'a chique ri rudiscípulos: ¿Achique c'a niquibij ri winek chuwij riyin ri C'ajolaxel ri xinalex chicojol, chi yin achique c'a riyin? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ri discípulos xquibij c'a chare ri Jesús: Yec'o ri yebin chi yit c'a riyit ri Juan ri Bautista. Yec'o nic'aj chic niquibij chi yit c'a riyit ri Elías. Yec'o chuka' yebin chi yit c'a riyit ri Jeremías. Y can yec'o chuka' yebin chi yit jun c'a chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, xecha' ri discípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y c'ac'ari' ri Jesús xuc'utuj c'a chique ri rudiscípulos: ¿Yin achique c'a riyin nibij riyix? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro can yac'ari' tek xubij: Yit c'a riyit ri Cristo, ri Ruc'ajol ri c'aslic Dios, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y can xu (xe wi) xrac'axaj queri' ri Jesús, can yac'ari' xubij: Riyit Simón Pedro ruc'ajol ri Jonás, can jabel c'a ruwa'ak'ij, ruma ri xabij chi yin c'a riyin ri Cristo ri Ruc'ajol ri Dios. Ri xabij majun ta c'a winek ri xk'alajsan chawech, xa can ya c'a ri Nata' Dios ri c'o chila' chicaj ri xk'alajsan chawech. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Y riyin chuka' nbij c'a chawe chi riyit Pedro chic c'a abi', y pa ruwi' re abej re' xtinpaba' wi ri nu'iglesia, y man c'a xtich'acatej ta ruma ruchuk'a' ri camic. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Y chawe c'a riyit xtinya' wi ri rulawa'il riche (rixin) ri rajawaren ri caj. Ronojel ri xtaxim wawe' chuwech re ruwach'ulef xtixime' chila' chicaj y ronojel ri xtaquir wawe' chuwech re ruwach'ulef xtiquiritej chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y ri Jesús can yac'ari' xuchilabej chique ri rudiscípulos chi majun achoj chare tiquitzijoj wi chi ya Riya' ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Can yac'a chuka' ri' tek ri Jesús xuchop ruk'alajsaxic chiquiwech ri rudiscípulos, chi rajawaxic c'a chi Riya' nibe pa tinamit Jerusalem riche (rixin) chi nuk'axaj q'uiy tijoj pokonal pa quik'a' ri rijita'k tak achi'a' ri c'o quik'ij, pa quik'a' ri principali' tak sacerdotes y pa quik'a' chuka' ri aj tz'iba'. Can xubij chi xticamisex na wi, pero pa rox k'ij xtic'astej pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Y tek ri Pedro xrac'axaj chi queri' xubij ri Jesús, xuc'uaj el juba' quela' y xbechapon pe chare. Can xubij c'a chare: ¿Achique ruma ma napokonaj ta awi' riyit? Man ta nibanatej achi'el ri xabij riyit Ajaf, xcha' ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yac'a tek ri Jesús xrac'axaj queri', xupiscolij ri' y xubij c'a chare ri Pedro: Cabiyin quela' riyit Satanás, ruma ma utz ta ri nach'ob. Riyit xa yatoc k'atbel nubey. Ruma ri nach'ob riyit xa can junan riq'ui ri niquich'ob ri winek y xa ma ya ta ri nrajo' ri Dios ri nach'ob. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y ri Jesús xch'o c'a chique ri rudiscípulos, y xubij: Wi c'o jun nrajo' yirutzekelbej, man c'a tupokonaj ta nuk'axaj tijoj pokonal. Xa can tubana' c'a achi'el nuben jun ri benak chuxe' jun cruz riche (rixin) chi nbecamisex. Ma nuben ta chic ri nurayij ka riya'. Wi c'o c'a jun nich'obo queri', utz chi nipe wuq'ui y quirutzekelbej c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ruma xabachique ri can nupokonaj ri ruc'aslen re wawe' chuwech re ruwach'ulef, xa ma xtril ta c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri ma nupokonaj ta ri ruc'aslen re wawe' choch'ulef, astape' ta na can napon pa camic wuma riyin, can xtril wi ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ruma, ¿achique ta c'a nuc'om pe chare ri winek, wi nic'oje' ri beyomel riche (rixin) ronojel re ruwach'ulef riq'ui y wi xa ma nicolotej ta? Astape' sibilaj q'uiy ri beyomel c'o riq'ui ri winek, ma nicowin ta c'a nulok' ri c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Riyin ri C'ajolaxel ri xinalex chicojol can xquipe chic c'a jun bey, y junan chic c'a nuk'ij nuc'ojlen riq'ui ri Nata' y ye wachibilan pe ri nu'ángeles. Y yac'ari' tek xtinya' rajel ruq'uexel chique quinojel; rajel ruq'uexel ri xequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y kitzij c'a re nbij chiwe, chi yec'o nic'aj chiwe riyix ri yec'o wawe' ri ma xquecom ta na, xquecom pero c'a ya tek quitz'eton chic na ca ri C'ajolaxel ri xalex chicojol petenak riq'ui ruk'ij ruc'ojlen, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y tek k'axnek chic c'a waki' k'ij, ri Jesús xerucha' ri Pedro, y chuka' ri Jacobo y ri Juan ri cach'alal qui', riche (rixin) chi xeruc'uaj chi ye oxi' c'a pa ruwi' jun nimajuyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ri Jesús xjalatej c'a ruwachbel chiquiwech ri ye oxi' rudiscípulos. Xuben c'a achi'el tek nitz'itz'an ri k'ij. Y ri rutziak can sek xuben achi'el ri sakil. Can sibilaj c'a rusakil xuben. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y xebec'ulun c'a pe ri Moisés y ri Elías, y xquichop c'a tzij riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y yac'ari' tek ri Pedro xubij apo chare ri Jesús: Ajaf, xcha' chare. Xa utz kabanon chi yojc'o wawe'. Wi nawajo', tikabana' oxi' tak ca'aj. Jun awuche (awixin) riyit, jun riche (rixin) ri Moisés, y queri' chuka' jun chic riche (rixin) ri Elías, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Tek ri Pedro can c'a nich'o na apo riq'ui ri Jesús, yac'ari' tek c'o jun sutz' sibilaj sek ri xka pe pa quiwi' y xerucuch. Y chupan c'a ri sutz' ri' c'o jun ch'abel xquic'axaj ri xubij: Yare' ri Nuc'ajol y can sibilaj nwajo' y nucukuban nuc'u'x riq'ui. Can ya c'a Riya' tiwac'axaj, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y tek ri ye oxi' discípulos xquic'axaj ri ch'abel ri', xexuque' xemaje' ka. Y sibilaj c'a xquixibij qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y ri Jesús xjel c'a apo quiq'ui ri rudiscípulos, xeruchop ka riq'ui ruk'a' y xubij c'a chique: Quixyacatej c'a y ma tixibij ta iwi', xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tek ri discípulos xquijek anej ri runak' quiwech, majun chic c'a ri xquitz'et, xa can ruyon chic ri Jesús c'o ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y tek riye' ye xulan c'a pe chuwech ri juyu', ri Jesús xuchilabej chique ri rudiscípulos, y xubij: Majun achoj chare tibij wi ri xitz'et. Riyix utz nitzijoj, c'a ya tek riyin ri C'ajolaxel ri xinalex chicojol yin c'astajnek chic pe chiquicojol ri caminaki', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri discípulos ri' can yac'ari' tek xquibij chare ri Jesús: Riyoj ketaman chi yit c'a riyit ri Cristo ri yit takon pe ruma ri Dios. ¿Y achique c'a ruma tek ri aj tz'iba' niquibij chi nabey c'o chi nipe ri Elías, c'ac'ari' nipe ri Cristo? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xubij c'a chique: Can kitzij wi chi ri Elías nipe nabey y nuben c'a ruchojmil ronojel ri rajawaxic chi nichojmirisex. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yac'a riyin nbij c'a chiwe chi ri Elías ri' xpe yan y ma xquetamaj ta el ruwech. Xa sibilaj c'a pokon xquiben el chare. Can achique ri xcajo' xquiben el chare, can queri' wi xquiben. Y can queri' chuka' riyin ri C'ajolaxel ri xinalex chicojol, yec'o ri xquebano chuwe chi xtink'axaj tijoj pokonal, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y c'ac'ari' tek ri discípulos xk'ax chiquiwech chi ri Jesús chrij ri Juan ri Bautista xch'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Tek ri Jesús y ri ye oxi' rudiscípulos xe'apon ka acuchi (achique) quimolon wi qui' sibilaj ye q'uiy winek, c'o c'a jun achi xoc'ulun riq'ui ri Jesús y xoxuque' chuwech. Ri achi ri' xubij c'a chare ri Jesús: ");
INSERT INTO cakWNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyowaj ruwech ri nuc'ajol, ruma riya' sibilaj nutij pokon pa ruk'a' ri ataque, y q'uiy c'a mul tzaknek pa k'ak' y pa tak ya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'om c'a pe riche (rixin) chi xonya' chiquiwech re adiscípulos riche (rixin) chi niquic'achojsaj ta el, y xa ma xecowin ta, xcha' ri achi. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús yac'ari' tek xubij: Riyix winek ri yixc'o chuwech re ruwach'ulef, majun chiwe ri cukul ta ruc'u'x riq'ui ri Dios. Chi'iwonojel xa yix sachnek. ¿Riyix nich'ob chi riyin can ronojel k'ij xquic'oje' iwuq'ui y man c'a xquitane' ta chi yixincoch'? Tic'ama' c'a pe ri c'ajol wawe', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Y can yac'ari' tek ri Jesús xchapon chare ri itzel espíritu riche (rixin) chi tel el riq'ui ri c'ajol ri'. Y can ya c'a hora ri' tek xc'achoj chare ri ruyabil, ruma xel el ri itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y tek ri Jesús y ri rudiscípulos quiyon chic c'a yec'o, xepe ri discípulos xquic'utuj chare ri Jesús: ¿Achique ruma riyoj ma xojcowin ta xkelesaj el ri itzel espíritu? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xubij chique: Ma xixcowin ta xiwelesaj ruma ma icukuban ta ic'u'x jabel riq'ui ri Dios. Y can kitzij c'a ri nbij chiwe: Xa riq'ui ta nicukuba' juba' ic'u'x riq'ui ri Dios, astape' jun cukbel c'u'x ri xa achi'el jun ti ija'tz riche (rixin) ri mostaza, xa riq'ui ri' yixcowin nibij chare re jun juyu' re' chi tel el wawe' y tik'ax quela', y can xtik'ax wi. Y can ronojel c'a xquixcowin xtiben, wi nicukuba' ic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Yac'a re jun ruwech itzel espíritu re' ntel, pero wi riyix niben orar y ma yixwa' ta tek niben ri oración ri', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y tek ri Jesús y ri rudiscípulos yec'o chic c'a ri pa Galilea, xpe ri Jesús xubij chic c'a chique ri rudiscípulos: Riyin ri C'ajolaxel ri xinalex chicojol, can xquijach wi pa quik'a' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Can xquinquicamisaj, yac'a ri pa rox k'ij xquic'astej pe chiquicojol ri caminaki'. Y tek ri discípulos xquic'axaj ri xubij ri Jesús, can sibilaj c'a xebison. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y yac'a tek ri Jesús y ri rudiscípulos xe'apon ri pa tinamit Capernaum, ri yec'utun ri puek riche (rixin) pa rachoch ri Dios, ri c'o chi niquitoj quinojel ri achi'a', can xe'apon c'a chuka' riq'ui ri Pedro y xquic'utuj chare: ¿Ri Itijonel ma nuya' ta cami ri puek riche (rixin) pa rachoch ri Dios? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y ri Pedro xubij: Ja' (je), nuya'. Y tek ri Pedro xapon ri pa jay, nabey ri Jesús xbech'o pe y xubij chare: Simón Pedro, ¿achique nabij riyit? Ri aj k'atbel tak tzij chuwech re ruwach'ulef, ¿achoj chare c'a niquic'utuj wi ri alcawal o ri impuestos? ¿Chique ri calc'ual ka riye' o chique ri nic'aj chic ri xa ma ye calc'ual ta? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Y ri Pedro xubij c'a chare ri Jesús: Ri aj k'atbel tak tzij xa chique ri ma ye calc'ual ta niquic'utuj wi ri alcawal o ri impuestos, xcha'. Y ri Jesús can yac'ari' tek xubij: Rumac'ari' tek riyin ma ntoj ta ri alcawal o ri impuestos, ruma yin c'a riyin ri Alc'ualaxel. ");
INSERT INTO cakWNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero riche (rixin) c'a chi ma niyacatej ta coyowal, jet ka chuchi' choy chuchapic car. Y ri nabey ri xtachop, tajaka' c'a pa ruchi' y chiri' xtawil wi ri puek ri nic'atzin riche (rixin) chi nbe'aya' ca chique ri ye c'utuy puek riche (rixin) pa rachoch ri Dios. Ri puek c'a ri' nuben c'a riche (rixin) chi naya' ca ri awuche (awixin) riyit y ri wuche (wixin) riyin, xcha' ri Jesús chare ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y ya c'a tiempo ri' tek ri discípulos xejel apo riq'ui ri Jesús, y xquic'utuj c'a chare: ¿Achique chake riyoj ri más nim ruk'ij ri xtic'oje' pa rajawaren ri caj? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y ri Jesús can yac'ari' tek xusiq'uij (xroyoj) jun ti ac'al y xuya' chiri' pa quinic'ajal. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","C'ac'ari' tek Riya' xubij chique ri rudiscípulos: Can kitzij c'a nbij chiwe, wi riyix ma nijel ta ri ina'oj, wi ma yixoc ta achi'el jun ti ac'al, ma xquixoc ta pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xaxu (xaxe) wi c'a ri xtuch'utinirisaj ri' achi'el re jun ti ac'al re', ya c'a ri' ri más nim ruk'ij ri xtic'oje' chiquicojol ri yec'o pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Xabachique ri nuc'ul jun ac'al pa nubi' riyin, jun ri achi'el re', ma xu (xe) ta wi xtuc'ul ri ac'al, xa can xquiruc'ul chuka' riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Y xabachique c'a winek ri nuben chi nitzak pa mac jun chique re tak ac'ala' re', ri yin quiniman riyin, ri winek ri xbano ri pokon ri', nimalaj ruc'ayewal nipe pa ruwi'. Rumari' xa utz na juba' chi ximon ta el jun nimalaj abej chukul y nbec'ak ca pa mar, que chuwech chi nuben chare jun co'ol chi nitzak pa mac. Y ri abej ri ximon ta el chukul ri winek ri' can ta ya ri abej ri nucusex riche (rixin) chi niban ri qui'en, ri nisitix ruma jun bur. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Juyi' oc quiwech ri winek ri yec'o chuwech re ruwach'ulef, ruma yec'o ri yebano chique chi yemacun. Can c'o wi c'a chi queri' nic'ulwachitej chuwech re ruwach'ulef. Pero juyi' c'a oc ruwech ri winek ri nibano chare jun chic chi nimacun. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Xa rumac'ari' wi xa ta jun ak'a' o jun awaken ri nibano chawe chi yamacun, xa utz tachoyo' el y tarokij el. Ruma más utz chi xaxu (xaxe wi) jun ak'a' o jun awaken c'o y yatoc chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek, que chuwech chi can tz'aket ak'a' awaken y xa pa k'ak' riche (rixin) xtibe k'ij xtibe sek ri yatbec'ak wi ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chuka' wi xa ta jun chique ri runak' awech ri nibano chawe chi yamacun, xa utz chi tawelesaj y tarokij el. Ruma más utz chi xaxu (xaxe wi) jun runak' awech c'o y yatoc chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek, que chuwech ca'i' runak' awech c'o y xa pa k'ak' yatbec'ak wi ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man c'a tiwetzelaj ta jun chique re tak ac'ala' re', ruma riyin nbij c'a chiwe chi ri ángeles ri nichajin quiche (quixin) riye' can quitzuliben apo ri Nata' chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y riyin ri C'ajolaxel ri xinalex chicojol, can xipe wi c'a chiquicanoxic y chiquicolic ri ye sachnek pa mac. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Achique nibij riyix? Wi c'o jun achi ri yec'o ta jun ciento rucarne'l y nisach ta ca jun tek yeberuyuk'uj, ¿la ma yeruya' ta cami ca juba' ri nic'aj chic tak rucarne'l, y nibe pa tak juyu' chucanoxic ri jun ri sachnek ca? ");
INSERT INTO cakWNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y astape' ri achi ri' c'a yec'o na ri noventa y nueve rucarne'l ri ma xesach ta ca, riyin nbij chi riya' más niquicot ránima riq'ui ri jun rucarne'l ri sachnek ca, tek nberila' pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Can queri' c'a chuka' ri Itata' ri c'o chila' chicaj, can ma ruraybel ta c'a Riya' chi nisach ta ca jun chique re tak ac'ala' re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Tek c'o c'a jun awach'alal ri c'o pokon ri xuben chawe, jet riq'ui y pa ruyonil tabij c'a chare chi ma utz ta ri xuben. Y wi ri awach'alal ri' nrac'axaj ri nabij chare, can xach'ec wi c'a pe ri awach'alal ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Yac'a wi xa ma yarac'axaj ta, que'ac'uaj c'a jun o ye ca'i' chic, riche (rixin) chi chiquiwech riye' tek nabij chare ri awach'alal chi ma utz ta ri rubanon. Riche (rixin) chi queri' can yix ca'i' o yix oxi' c'a ri yixc'o tek nichojmirisaj ronojel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y wi ri awach'alal can ma nrac'axaj ta riq'ui ri xibij riyix chare, c'ac'ari' riyit ri banon ri pokon chawe, tabij chique ri kach'alal riche (rixin) ri iglesia. Y tek bin chic chare cuma ri kach'alal y ma riq'ui wi ri' ma nunimaj ta tzij, tibana' c'a chare achi'el xa jun c'utuy alcawal chi ma iwachibil ta chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y can kitzij c'a re nbij chiwe: Ronojel c'a ri xtixim wawe' chuwech re ruwach'ulef xtixime' chuka' chila' chicaj. Ronojel c'a ri xtiquir wawe' chuwech ri ruwach'ulef xtiquiritej chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chuka' nbij chiwe: Wi chuwech re ruwach'ulef yec'o ye ca'i' kach'alal ri can junan quiwech niquiben riche (rixin) chi niquic'utuj xabachique cosa chare ri Dios, ri Nata' Dios ri c'o chila' chicaj can xtuben c'a ri nic'utux chare cuma ri ye ca'i' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ruma xabacuchi (xabachique) c'a ri quimolon wi qui' ye ca'i' o ye oxi' pa nubi' riyin, can yinc'o c'a pa quinic'ajal, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y can yac'ari' tek xjel apo ri Pedro riq'ui ri Jesús y xubij chare: Ajaf, wi jun wach'alal can c'o pokon nubanala' chuwe, ¿c'a janipe' c'a mul utz chi ncuy rumac? ¿La wuku' cami mul ncuy rumac? xcha' ri Pedro chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yac'ari' tek ri Jesús xubij chare ri Pedro: Riyin ma nbij ta c'a chawe chi wuku' mul ri utz chi nacuy rumac jun awach'alal ri c'o pokon nubanala' chawe. Riyin nbij c'a chawe chi ri rumac ri awach'alal utz chi wuku' mul chi setenta ri nacuy rumac. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ruma chupan ri rajawaren ri caj, can nibanatej c'a achi'el ri xuben jun rey, tek xrajo' c'a xuchojmirisaj janipe' quic'as chiquijujunal ri rumozos. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y tek ri rey ri' xuchop c'a ruchojmirisaxic, c'o c'a jun rumozo ri xbepabex chuwech y ri mozo ri' lajuj mil talentos ri ruc'as. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Y ruma c'a ri mozo ri' ma nicowin ta nutoj ri ruc'as ri rubanon, ri rey xubij c'a chi tic'ayix ri mozo ri' rachibilan ri rixjayil y ri ye calc'ual. Y chuka' can quec'ayix ri rucosas riche (rixin) chi ri rajel ntoc tojbel ri c'as. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Can yac'ari' tek ri mozo xxuque' xmaje' ka chuwech ri rey riche (rixin) chi nuc'utuj jun utzil chare. Y xubij c'a chare ri rey: Tabana' jun utzil chi quinawoyobej na juba'. Riyin can xtintoj c'a chawe ronojel ri nuc'as, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rey ri rupatrón ri mozo ri', can xujoyowaj c'a ruwech ri rumozo ri q'uiy ruc'as, rumari' xucuy ri ruc'as y majun xuben chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Yac'a tek cuyutajnek chic el ri mozo ri' chare ri ruc'as, xberuc'ulu' c'a jun rech mozo. Ri mozo ri' c'o c'a jun kajo'n rubanon riq'ui riya'. Ri kajo'n c'a ri rubanon ri rech mozo ri', man achi'el ta c'a ri ruc'as riya', xa jun ciento puek ri nibix denario chare. Pero ma riq'ui wi ri', riya' xupitz' chukul y nutz'apij yan c'a ruxla', y nubij c'a chare: Tatojo' pe ri ac'as ri abanon wuq'ui, nicha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y ri rech mozo can yac'ari' xxuque' ka chuwech riche (rixin) chi nuc'utuj c'a utzil chare; y xubij c'a: Quinawoyobej na juba' y riyin xtintoj ronojel nuc'as chawe, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Yac'a ri achi mozo achoj riq'ui banon wi ri c'as, ma xrajo' ta achi'el ri xbix chare y rumari' xbe pa k'atbel tzij y xberuya' ca pa cárcel, riche (rixin) chi queri' tek rutojon chic na ca ruc'as, c'ac'ari' utz chi ntel pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Tek xtz'etetej c'a cuma ri nic'aj chic cachibil ronojel ri xbanatej, can xpe c'a bis pa cánima. Y riye' xebe c'a riq'ui ri rey ri quipatrón y xbequitzijoj c'a chare ronojel ri xuben ri jun mozo riq'ui ri jun chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y ri rey, ri quipatrón, can yac'ari' xutek rusiq'uixic (royoxic) ri mozo ri ma utz ta xuben, y xubij c'a chare: Riyit xa yit jun c'a itzel numozo. Riyin xincuy ronojel ri ac'as, ruma riyit xac'utuj utzil chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿La ma que ta cami ri', ri utz chuka' chi xaben ta riyit riq'ui ri awech mozo achi'el ri xinben riyin awuq'ui chi xinjoyowaj awech? ");
INSERT INTO cakWNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y can yac'ari' tek ri rey ri quipatrón ri mozos ri', ruma xyacatej royowal, xujech c'a el ri itzel mozo pa quik'a' ri achi'a' ri yebano pokon. Y chiri' xtiban chare chi nuk'axaj tijoj pokonal c'a ya tek nitojtej na ca ronojel ri ruc'as. ");
INSERT INTO cakWNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Can quec'ari' chuka' xtuben ri Nata' Dios ri c'o chila' chicaj iwuq'ui riyix, wi xa ma riq'ui ta ronojel iwánima nicuy quimac ri iwach'alal tek c'o pokon niquiben chiwe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y tek ri Jesús xtane' chubixic ri ch'abel ri', xel c'a el chiri' ye rachibilan ri rudiscípulos, xuya' c'a ca ri lugar ri', ri Galilea rubi'. Riya' xbe c'a quela' pa Judea, y xk'ax c'a juc'an chic chare ri raken ya' Jordán. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Riya' sibilaj c'a ye q'uiy winek ri xetzekelben riche (rixin) y yec'o c'a chuka' ri xeruc'achojsaj ca chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y yac'ari' tek yec'o achi'a' fariseos ri xe'apon riq'ui ri Jesús, riche (rixin) chi niquitojtobej y nitzak ta pa quik'a'. Y rumari' xquic'utuj c'a chare: ¿Utz cami chi jun achi nujech ri' riq'ui ri rixjayil ruma xabachique ta chi mac nuben ri rixjayil? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yac'a ri Jesús xubij c'a chique ri achi'a' ri': ¿La ma isiq'uin ta c'a riyix chupan ri ruch'abel ri Dios ri nubij wi chi ri Dios can pa rutiquiribel pe tek can pa c'ulaj xeruben? Can ma ruyon ta c'a ri achi, y chuka' ma ruyon ta ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y xubij chique: Rumari' ri achi man chic c'a quiq'ui ta rute' rutata' xtic'oje' wi. Xa xtiquic'uaj c'a qui' riq'ui ri rixjayil, y chi ye ca'i' xa jun c'a ri xtiquiben. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Rumari' tek quic'uan chic qui', man chic ye ca'i' ta c'a winek, ma que ta chic ri', xa jun xtiquiben. Rumac'ari' ri can ye tunun chic ruma ri Dios, majun winek ri tijacho ta quiche (quixin). Queri' ri tz'ibatajnek ca, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y ri fariseos xquic'utuj c'a chare ri Jesús: Wi ma utz ta chi queri' niban, ¿achique c'a ruma tek ri Moisés xubij chi ri achi, utz nutz'ibaj jun wuj y tubij chupan chi xquijech qui' riq'ui ri rixjayil y tuya' chare ri ixok y tuya' ca? ");
INSERT INTO cakWNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xubij c'a chique ri achi'a' ri': Ruma chi can cowirnek ri iwánima riyix chi ma ninimaj ta ri Dios, xa rumac'ari' tek ri Moisés xuya' k'ij chi nijech ca ri iwixjaylal. Yac'a ri pa rutiquiribel pe xa ma que ta ri' xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Riyin can nbij wi c'a chiwe chi xabachique achi ri nujech ri' riq'ui ri rixjayil y xa ma ruma ta chi ri ixok xuc'om ruwech jun chic achi; wi ri achi ri' nuc'om chic pe jun ixok, ri achi ri' nimacun chuwech ri Dios. Y wi c'o c'a jun achi ri nuc'uan el ri ixok ri jachon ca ruma ri rachijil, chuka' ri achi ri' nimacun chuwech ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y ri discípulos xquibij c'a chare ri Jesús: Wi jun achi can majun chic modo nujech ri' riq'ui ri rixjayil, xa más ta utz chi ri achi man ta nucanoj rixjayil, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y ri Jesús can yac'ari' tek xubij chique ri rudiscípulos: Ma quinojel ta yecoch'o chi man ta xtic'oje' quixjayil, ruma ma quinojel ta yatajnek chique chi man ta xquec'ule'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y can yec'o na wi achi'a' ri can c'a pa calaxic pe riq'ui ri quite' tek xk'alajin yan chi ma xtiquicanoj ta ixok. Yec'o chuka' achi'a' ri ye queri', xa ruma chi xa banon chique cuma ri ye ajk'omanel. Y yec'o chuka' achi'a' ri ye queri', xa ruma chi xa yec'a riye' ri xech'obo chi ma niquicanoj ta ixok, riche (rixin) chi yesamej jabel pa rusamaj ri Dios y yequito' ri winek ri ye'oc pa rajawaren ri caj. Ri jun c'a ri can nuna' chi nicowin nic'oje' ruyonil, man c'a tucanoj ta ixok riche (rixin) chi ntoc rixjayil, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y yec'o c'a ac'ala' ri xe'uc'uex apo chuwech ri Jesús, chi nuya' ta el ri ruk'a' pa quiwi' y tuc'utuj chuka' ri rubendición ri Dios pa quiwi' ri ac'ala' ri'. Yac'a ri discípulos xa xechapon chique ri winek chi ma quequic'om ta pe ri ac'ala'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yac'a ri Jesús xa xubij c'a chique ri rudiscípulos: Tiya' k'ij chique ri ac'ala' chi yepe wuq'ui riyin, y ma que'ik'et ta. Ruma ri xque'oc pa rajawaren ri caj, xaxu (xaxe) wi ri winek ri ye achi'el re ac'ala' re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y tek ri Jesús ruya'on chic ruk'a' pa tak quiwi' ri ac'ala', Riya' xbe, xuya' c'a ca ri lugar ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y c'o c'a jun c'ajol achi ri xapon riq'ui ri Jesús y xubij: Riyit ri can yit utzilaj Tijonel, tabij c'a chuwe: ¿Achique c'a ri rajawaxic chi nben riyin riche (rixin) chi ntoc ta wuche (wixin) ri c'aslen riche (rixin) xtibe k'ij xtibe sek? xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y ri Jesús xubij chare: ¿Achique c'a ruma tek nabij utz chuwe riyin? Ruma majun winek ri utz ta, xa can xu (xe) wi c'a Jun ri utz y ri' ya ri Dios. Wi riyit can nawajo' c'a yatapon chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek, can que'animaj c'a ri pixa', xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y xpe ri c'ajol achi ri aponak riq'ui ri Jesús xuc'utuj c'a: ¿Achique c'a chi pixa' ri'? xcha'. Y ri Jesús xubij chare: Ri pixa' ri' ya ri ma cacamisan ta; riyit achi ri c'o awixjayil, ma tacanoj ta jun chic ixok; ma catelek' ta, ma tatz'uc ta tzij chrij jun chic winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chuka' taya' quik'ij ri ate' atata'. Y achi'el nawajo' ka awi' riyit, queri' chuka' que'awajo' ri awuc' awach'alal. Ye pixa' ri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y ri c'ajol achi xubij c'a chare ri Jesús: C'a yin co'ol na tek nchapon pe rubanic ronojel ri'. ¿Achique ta c'a ri nic'aj chic ri ma nbanon ta? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y ri Jesús xubij c'a chare: Wi riyit nawajo' chi can tz'aket nuben ri ac'aslen chuwech ri Dios, jet, jac'ayij c'a ri c'o awuq'ui y ri rajel taya' chique ri pobres, riche (rixin) chi queri' nic'oje' abeyomal chila' chicaj. Y catam pe wuq'ui y quinatzekelbej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tek ri c'ajol achi xrac'axaj c'a ri ch'abel ri xubij ri Jesús, nibison ránima xtzolin el, ruma q'uiy ri beyomel c'o riq'ui y ma nrajo' ta ntel pa ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Can yac'ari' tek ri Jesús xubij chique ri rudiscípulos: Wacami can nbij wi c'a chi can kitzij wi chi c'ayef (cuesta) chi jun beyon ntoc pa rajawaren ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Y can nbij c'a chiwe chi xa ma can ta c'ayef (cuesta) chi nik'ax ri jun chicop ri camello rubi' pa ti rachek jun bak riche (rixin) t'iso'n (tz'iso'n), que chuwech chi ntoc jun beyon pa rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y tek ri rudiscípulos ri Jesús xquic'axaj ri ch'abel ri', xsach quic'u'x. Y niquibila' c'a chiquiwech: Wi can achi'el ri xubij, ¿achique ta c'a jun ri xticolotej? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xerutzu' apo ri rudiscípulos y xubij chique: Ma tich'ob ta queri'. Ri winek ma yecowin ta niquicol qui', yac'a ri Dios ronojel nicowin nuben, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y yac'ari' tek ri Pedro xubij c'a chare ri Jesús: Riyit awetaman chi riyoj kaya'on ca ronojel ri c'o kiq'ui, riche (rixin) chi yit katzekelben. ¿Y achique c'a ri xtikach'ec riyoj rumari'? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xubij c'a: Can kitzij c'a nbij chiwe chi tek xtapon ri k'ij tek ronojel c'ac'ac' chic rubanic, riyin ri C'ajolaxel ri xinalex chicojol c'o chic c'a nuk'ij nuc'ojlen y xquitz'uye' pa jun ch'aquet riche (rixin) chi nk'et tzij. Y yac'a chuka' ri' tek riyix ri xixtzekelben wuche (wixin), xquixtz'uye' pa cablajuj ch'aquet riche (rixin) chi nik'et tzij pa quiwi' ri cablajuj tinamit ri yec'o pa rucuenta ri Israel. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xabachique winek ri wuma c'a riyin ruya'on ca rachoch, ruya'on ca rach'alal ye c'ajola' o k'opoji', rute' rutata', rixjayil, ralc'ual o rulef, q'uiy c'a ri xtuc'ul; can pa ciento c'a mul ri xtuc'ul. Y xtiyatej chuka' ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y c'o ri yec'o nabeyel ri xquecanaj c'a pa ruq'uisbel. Y c'o ri yec'o pa ruq'uisbel ri xquec'oje' pa nabey, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri rajawaren ri caj can junan c'a riq'ui achi'el nuben jun achi tata'aj pa jun jay ri xel el ri nimak'a' chiquicanoxic mozos, riche (rixin) chi yerutek pa rulef ri ruticon ruwech riq'ui uva. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tek ri achi ri' xeril c'a ri mozos y tek ch'onak chic quiq'ui chi niquich'ec jojun denario ri jun k'ij, c'ac'ari' xerutek chusamajixic ri rulef ri ruticon ruwech riq'ui uva. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Achi'el xa pa tak a las nueve ri nimak'a' ri', riya' xel chic el jun bey y xerutz'et c'a chi chiri' pa c'aybel yec'o mozos ri ma quilon ta quisamaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Riya' xubij c'a chique: ¿Niwajo' isamaj? Wi niwajo', quixbiyin c'a chuka' riyix, quixbesamej pa nujuyu' ri nuticon ruwech riq'ui uva, y riyin xtintoj c'a chiwe ri ruc'amon chi nich'ec, xcha' chique. Y ri mozos ri' can xebe c'a pa samaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri tata'aj c'a, ri rajaf ri ulef, can queri' c'a chuka' ri xubanala' quiq'ui ri nic'aj chic mozos ri xeril tek xel el achi'el xa pa nic'aj k'ij y achi'el xa pa tak a las tres ri tikak'ij. Riya' xerutek c'a ri mozos pa rusamaj y xubij chique chi can xtuya' wi c'a chique ri ruc'amon chi niquich'ec. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y achi'el xa pa tak a las cinco ri tikak'ij riya' xel chic el jun bey y xeberila' c'a pe nic'aj chic mozos. Y riya' xubij c'a chique ri mozos ri': ¿Achique c'a ruma tek ma iwilon ta el isamaj y chi jun k'ij re yixc'o wawe'? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y ri mozos ri' xquibij c'a: Majun xya'o kasamaj, xecha'. Y ri tata'aj rajaf ri ulef xubij c'a chique ri mozos ri': Quixbesamej c'a chuka' riyix pa nujuyu' ri nuticon ruwech riq'ui uva y xtintoj c'a chiwe ri ruc'amon chi nich'ec, xcha' chique. Y ri mozos ri' can xebe c'a pa samaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Yac'a tek xka ka ri k'ij, xpe ri rajaf ri ulef ri ticon ruwech riq'ui uva, xubij c'a chare ri uc'uey quiche (quixin) ri rumozos: Que'asiq'uij (que'awoyoj) pe quinojel ri mozos y que'atojo' el. Nabey c'a que'asiq'uij (que'awoyoj) pe ri mozos ri xe'oka pa ruq'uisbel, y yec'a ri mozos ri xe'oka pa nabey yeri' ri xqueruq'uisbej ca, xcha' riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tek ri mozos ri xe'oc pa samaj ri pa tak a las cinco ri tikak'ij xe'apon riche (rixin) chi yetoj pe, jun puek ri nibix denario chare ri xbequic'ulula' pe, ruma queri' ri ruraybel ri rajaf ri ulef chi xuya' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y tek xe'apon c'a ri mozos ri xe'oc pa samaj nabey riche (rixin) chi yebetoj pe, xquich'ob chi riye' más q'uiy cajel xtiquic'ul que chiquiwech ri nic'aj chic ri xa majun k'ij ta ri xesamej. Yac'a tek xquic'ul ri cajel, yac'ari' tek xquitz'et chi riye' chuka' xa jun puek ri nibix denario chare ri xquic'ul. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tek ri mozos ri' xquic'ul ri cajel y xquitz'et chi xa junan ri xquic'ul quiq'ui ri nic'aj chic, xexebexot (xexebeloj) chrij ri tata'aj. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri mozos ri' niquibij c'a: Ri ye ruq'uisbel mozos xe'oc pa samaj, y xa jun hora oc xesamej, y riyit can junan xaben chake quiq'ui riye', tek riyoj can jun k'ij xojsamej y xojc'oje' chuxe' ri ruc'atanal ri k'ij, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y ri rajaf ri samaj xubij c'a chare jun chique ri mozos ri': Riq'ui ri junan xentoj ri nic'aj chic mozos majun itzel ta xinben chawe riyit. Ruma awuq'ui riyit xkaya' chkawech chi jun denario ri nya' chawe. ¿Ninatej chawe? ");
INSERT INTO cakWNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Wacami riyit xaxu (xaxe wi) c'a tac'uaj la arajil y utz yabe. Y yac'a chique ri mozos ri c'a pa ruq'uisbel xe'oc pa samaj, can pa wánima c'a riyin xpe wi tek xinya' el ri cajel achi'el ri awajel riyit. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ruma ronojel ri c'o wuq'ui riyin, can pa nuk'a' c'a riyin c'o wi riche (rixin) chi nben achique ri nwajo' nben riq'ui. ¿O riyit xa itzel nana' chuwe tek riyin xa utz nuna'oj nben quiq'ui ri nic'aj chic? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Y quec'ari', c'o ri yec'o nabeyel ri xquecanaj c'a pa ruq'uisbel. Y c'o ri yec'o pa ruq'uisbel ri xquec'oje' pa nabey, ruma ye q'uiy ri ye siq'uin (oyon), xa yac'a ri ma ye q'uiy ta ri ye cha'on, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ri Jesús y ri cablajuj rudiscípulos y ri nic'aj chic winek ri ye benak quiq'ui, quichapon el bey riche (rixin) chi ye jotol el pa tinamit Jerusalem. Y yac'ari' tek ri Jesús xeruc'uaj el juba' quela' pa quiyonil ri rudiscípulos ruma c'o c'a ri nrajo' nubij chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Riya' xubij c'a: Riyix iwetaman chi pa tinamit Jerusalem kachapon wi el bey, y ya ri chiri' xquijach wi el riyin ri C'ajolaxel ri xinalex chicojol. Xquijach na pa quik'a' ri principali' tak sacerdotes y pa quik'a' ri aj tz'iba'. Y riye' xtiquibij c'a chi can quicamisex. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y chuka' xquinquijech el pa quik'a' winek ri xa ma ye israelitas ta. Y ri winek ri' xquetze'en chuwij, xquinquich'ey y c'ac'ari' xquinquibajij chuwech jun cruz riche (rixin) chi yinquicamisaj. Pero pa rox k'ij xquic'astej c'a pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y ri ye ca'i' discípulos ri ye ruc'ajol ri achi ri Zebedeo rubi', xejel apo riq'ui ri Jesús, cachibilan ri quite'. Y ri quite' xxuque' xmaje' ka chuwech ri Jesús riche (rixin) chi nuc'utuj jun utzil chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xubij c'a chare ri te'ej ri': ¿Achique c'a ri nawajo'? xcha' chare. Y ri ixok xubij c'a chare ri Jesús: Riyin nwajo' c'a chi tek yitc'o chic pan awajawaren, can tabana' c'a chi re ye ca'i' wal re' yetz'uye' ta apo awuq'ui; jun ta c'a ri pan awajquik'a' y jun ta c'a ri pan awajxocon, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Y yac'ari' tek ri Jesús xubij chique ri ye ca'i' ral ri ixok ri': Riyix ma iwetaman ta c'a ri nic'utuj chuwe. ¿La nicoch' cami riyix achi'el ri xtiban chuwe riyin? ¿Y la nicoch' cami chuka' riyix jun tijoj pokonal achi'el ri xtink'axaj riyin? xcha' ri Jesús. Y riye' xquibij c'a: Nikacoch', xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xubij chic c'a chique: Can kitzij wi c'a chi riyix xticoch' na wi achi'el ri xtiban chuwe riyin. Chuka' can xticoch' jun tijoj pokonal achi'el ri xtink'axaj riyin. Yac'a ri nic'utuj chuwe, chi riyix niwajo' chi jun nitz'uye' ri pa wajquik'a' y jun nitz'uye' ri pa wajxocon, ri' ma pa nuk'a' ta riyin c'o wi chi nya' chiwe. Ruma ri nic'utuj riyix, ri' xa quiche (quixin) chic c'a ri xtubij ri Nata' chi utz chi xquetz'uye' chiri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y yac'a tek ri lajuj chic discípulos xquic'axaj ri xbitej ka, xpe c'a coyowal chique ri ye ca'i' discípulos ri cach'alal qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Can yac'ari' tek ri Jesús xerusiq'uij (xeroyoj) ri rudiscípulos y xubij c'a chique: Riyix jabel iwetaman chi re wawe' chuwech re ruwach'ulef ri ye aj k'atbel tak tzij, yeri' ri yec'o pa quiwi' ri winek, y ruma chi can c'o quik'atbel tzij pa quiwi' ri winek, rumari' niquina' chi can yec'a riye' ri ye cajaf ri winek. Xa can xu (xe) wi c'a ri c'o quik'ij ri yebin ri c'o chi niban. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Yac'a ri chicojol riyix jun wi chic. Ruma ri nrajo' chi nic'oje' ruk'ij chicojol, xa tuch'utinirisaj ri', y querunimaj querilij ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Wi c'o jun chiwe riyix ri nrajo' chi ya riya' ri nabey, xa tuch'utinirisaj ri', querunimaj querilij ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Can achi'el nben riyin ri C'ajolaxel ri xinalex chicojol. Riyin ma xipe ta riche (rixin) chi ye ri winek yebano samaj pa nucuenta riyin. Riyin xipe riche (rixin) chi nben ri samaj ri nic'atzin chi nben pa quicuenta ri winek, y can nya' wi' pa camic riche (rixin) chi queri' ye q'uiy ri yecolotej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ri Jesús y ri rudiscípulos yac'a tek quichapon el elen pa tinamit Jericó, y sibilaj c'a ye q'uiy winek ri ye tzekelbeyon el riche (rixin), ");
INSERT INTO cakWNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","can yac'ari' tek ye ca'i' moyi' ye tz'uyul chuchi' ri bey xquic'axaj c'a chi ri Jesús yari' ri nik'ax el queri', y riye' xquirek quichi' y xquibij c'a: Riyit Ajaf, ri yit ralc'ual ca ri rey David, tajoyowaj c'a kawech ruma re kabanon, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y ri winek xequik'il c'a ri moyi' ri' chi ma tiquirek ta chic quichi'. Yac'a riye' xa más niquirek quichi' y xquibij: Riyit Ajaf, ri yit ralc'ual ca ri rey David, tajoyowaj c'a kawech ruma re kabanon, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y ri Jesús xrac'axaj c'a ri quich'abel. Rumari' Riya' xpa'e' c'a y xerusiq'uij (xeroyoj). Y xubij chique: ¿Achique c'a niwajo'? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Riye' xquibij c'a chare ri Jesús: Ajaf, riyoj nikajo' c'a chi yojtzu'un, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús ruma xujoyowaj c'a quiwech ri ye ca'i' achi'a' moyi' ri', can yac'ari' tek xuchop ri runak' tak quiwech, y riye' xetzu'un c'a. Y xquitzekelbej chuka' el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Y ri Jesús, y ri ye rudiscípulos y ri nic'aj chic winek ri ye benak quiq'ui, xa juba' chic c'a nrajo' chi ma ye'apon pa tinamit Jerusalem, ruma xa can pa tinamit Betfagé chic yec'o wi, tinamit ri c'o chunakajal ri juyu' Olivos. Y xpe c'a ri Jesús xerutek c'a el ye ca'i' rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Riya' xubij c'a el chique: Quixbiyin apo chupan la jun aldea la nitzu' apo chila', y can xu (xe) wi xquixoc apo, xtiwil jun ti alaj bur ri ximil ca chiri' riq'ui ri rute'. Tiquira' c'a pe ri te'ej y que'ic'ama' pe chi ye ca'i' chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y wi c'o c'a jun xtibin pe chiwe chi achique ruma yixtajin ye'iquir, tibij c'a ca chare: Nic'atzin chare ri Ajaf, y xa chanin xque'orutzolij ca, quixcha' ca, xe'uche'ex el ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ronojel re' nibanatej ruma queri' tz'iban ca ruma ri jun profeta ri xk'alajsan ri ruch'abel ri Dios ojer ca. Ri rutz'iban c'a ca riya', nubij: ");
INSERT INTO cakWNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' c'a rutzijol chique ri winek ye riche (rixin) ri tinamit Sion, chi ri qui-Rey yac'are' petenak. Ri qui-Rey can ch'uch'uj wi c'a ránima. Y Riya' ch'ocol pe chrij jun ti bur. Can chrij wi c'a jun ti alaj bur ch'ocol wi pe. Ri ti alaj bur ral c'a jun chicop riche (rixin) ejka'n. Quec'ari' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y ri ca'i' discípulos xebe c'a, y xquiben wi ri bin el chique ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquic'om c'a pe ri ti alaj bur rachibilan ri rute', c'ac'ari' ri discípulos xquiya' ri quitziak chiquij ri bur riche (rixin) chi ri Jesús xch'oque' el chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y ri ye tzeketel chrij ri Jesús sibilaj ye q'uiy. Y juba' ma quinojel chique riye' ri xquiriq'uila' ri nima'k tak quitziak pa rubey ri Jesús riche (rixin) chi niquiya' ruk'ij. Y nic'aj chic winek ruma can niquiya' chuka' ruk'ij ri Jesús xebequic'amala' pe ruxak tak che' ri can riche (rixin) wikbel, riche (rixin) chi xequiric' pa rubey. Y quec'ari' niquibanala' ye benak. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y ri winek c'a ri ye nabeynek chuwech ri Jesús y ri yec'o ca chrij, can riq'ui c'a ronojel quichuk'a' niquibij: ¡Matiox chi petenak ralc'ual ca ri rey David! ¡Riya' can banon pe bendecir ruma ri Ajaf Dios! ¡Y can pa rubi' ri Ajaf Dios petenak wi! ¡Matiox chare ri Dios ri c'o chila' chicaj! yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yac'a tek ri Jesús ntoc apo ri pa tinamit Jerusalem, xepe c'a ri winek xquimol apo qui' chanin chutz'etic ri Jesús. Y ri winek ri' niquibila' c'a: ¿Achique c'a chi achi re'? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y yec'o c'a nic'aj chic ri xebin: Re' yare' ri Jesús, ri profeta ri nik'alajsan ri ruch'abel ri Dios ri nipe pa tinamit Nazaret; tinamit ri c'o pa rucuenta ri Galilea, yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y ri Jesús xoc c'a pa rachoch ri Dios ri c'o pa tinamit Jerusalem. Y tek xerutz'et ri winek chi achi'el c'aybel quibanon chare rachoch ri Dios, xerokotaj c'a pe quinojel ri yetajin yec'ayin y ri yelok'onaj chiri'. Y ri aj q'uexoy tak puek xerutecmayila' ca ri quimesas, y queri' chuka' xuben chique ri quich'acat ri yetajin yec'ayin palomax. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri Jesús xubij c'a chique ri winek ri': Chupan ri ruch'abel ri Dios ri tz'ibatal ca nubij chi ri wachoch, jay riche (rixin) oración. Yac'a riyix xa achi'el jul quiche (quixin) alek'oma' ibanon chare, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Y tek ri Jesús c'o c'a pa rachoch ri Dios, yec'o c'a winek ye moyi' y yec'o chuka' ri ma yecowin ta yebiyin ruma chi ye cojo, ri xe'apon riq'ui Riya', riche (rixin) chi yeruc'achojsaj el. Y Riya' can xeruc'achojsaj wi el. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Yac'a ri principali' tak sacerdotes y ri ye aj tz'iba' xpe coyowal, ruma ri Jesús q'uiy milagros ri yerubanala', y ruma chuka' ri ac'ala' riq'ui c'a quichuk'a' niquibila' chiri' pa rachoch ri Dios: ¡Matiox chi xoka ralc'ual ca ri David! yecha'. Y ya c'a ri' ri xyaco coyowal. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xepe ri principali' tak sacerdotes y ri achi'a' aj tz'iba', xquibij c'a chare ri Jesús: ¿Nawac'axaj c'a ri yetajin chubixic ri ac'ala'? xecha'. Y xpe ri Jesús xubij chique ri achi'a' ri': Ja' (je), nwac'axaj. Y riyix, ¿la majun bey cami isiq'uin chupan ri ruch'abel ri Dios tek nubij: Riyit Dios can abanon chique ri ac'ala' y chique ri c'a yetz'uman na chi ntel ch'abel pa quichi' riche (rixin) chi nac'ul ak'ij ac'ojlen? Quec'ari' nubij ri ruch'abel ri Dios, xcha' ri Jesús chique ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y ri Jesús xeruya' c'a ca chiri' ri achi'a' ri'. Riya' xel el ri pa tinamit Jerusalem y xbe c'a pa tinamit Betania. C'a chiri' c'a xbe wi riche (rixin) chi xbe'uxlan ri jun ak'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y nimak'a' ri ruca'n k'ij, tek ruchapon bey riche (rixin) chi nitzolin pa tinamit Jerusalem, ri Jesús xpe runumic. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y tek benak, Riya' xutz'et c'a juwi' che' ri higo rubi' tiquil chunakajal ri bey. Xbe c'a apo chuxe' chucanoxic ruwech, pero xa majun ruwech c'o ta, xa ruyon ruxak c'o. Yac'ari' tek ri Jesús xubij chare ri che': Majun bey chic c'a xcawachin ta. Y ri juwi' che' ri' can chanin xchaki'j ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tek ri rudiscípulos ri Jesús xquitz'et chi chaki'j chic ri juwi' che' higo rubi', xquibila' chiquiwech: ¿Achique c'a rubanic la' chi can chanin xchaki'j ka re juwi' che' re'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xpe ri Jesús xubij c'a chique: Can kitzij nbij chiwe, chi wi riyix can nicukuba' ic'u'x riq'ui ri Dios y ma nuben ta ca'i' ic'u'x, can xquixcowin c'a niben achi'el xinben riyin chare re jun higo re'. Y ma xu (xe) ta wi re' ri xquixcowin xtiben, xa can xquixcowin nibij chare re juyu' re' chi tel el wawe' y tik'ax chupan ri mar, y can quec'ari' ri xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Can ronojel wi c'a ri nic'utuj chare ri Dios, wi riyix can ninimaj chi nic'ul, can xtic'ul wi c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y tek ri Jesús c'o chic pa rachoch ri Dios y nuc'ut chic ri ruch'abel ri Dios chiquiwech ri winek, ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij chiquicojol ri winek, xe'apon apo riq'ui ri Jesús y xquic'utuj c'a chare: ¿Achique chi k'atbel tzij c'o pan ak'a' riche (rixin) chi xe'awokotaj el ri winek ri yec'ayin re pa rachoch ri Dios? ¿Y achique chuka' xya'o ri k'atbel tzij ri' pan ak'a' chi ye'abanala' quere'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xpe ri Jesús xubij c'a chique ri achi'a' ri': Riyin c'o c'a chuka' jun ri nwajo' nc'utuj chiwe, y wi riyix xtibij chuwe, riyin chuka' xtinbij c'a chiwe achique ri yayon pe k'atbel tzij pa nuk'a' chi yenbanala' quere'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y yac'ari' tek ri Jesús xuc'utuj c'a: ¿Ri Juan xtak pe ruma ri Dios riche (rixin) chi xeruben bautizar ri winek? ¿O xa ye ri winek xebin chare chi xuben queri'? xcha' ri Jesús. Y ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij xquibila' c'a chiquiwech: ¿Achique c'a xtikabij chare wacami? xecha' ka. Ruma wi nikabij chi ri Juan ya ri Dios ri takayon pe, ri Jesús xa xtubij c'a chake chi achique c'a ruma tek ma xinimaj ta ri xubij. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y wi nikabij chi xa winek xebin chare ri Juan chi xuben queri', c'o ruc'ayewal nuc'om pe chake riyoj, ruma ri winek xqueyacatej pe chikij. Ruma quinojel ri winek quetaman wi chi ri Juan can jun profeta ri xk'alajsan ri ruch'abel ri Dios, xecha' c'a ka chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y yac'ari' tek xquibij apo chare ri Jesús: Riyoj ma ketaman ta, xecha' apo. Y ri Jesús can yac'a chuka' ri' xubij chique ri achi'a' ri': Ruma c'a chi riyix ma xixcowin ta xibij chuwe, queri' c'a chuka' riyin ma xtinbij ta chiwe achique yayon k'atbel tzij pa nuk'a' chi yicowin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yac'ari' tek ri Jesús xubij chic c'a chique ri achi'a' ri': ¿Achique nibij riyix chrij re xtinbij chiwe? C'o c'a jun achi yec'o ca'i' ruc'ajol. Y ri tata'aj ri' xapon c'a nabey riq'ui ri jun, y xubij chare: Wacami, jabana' juba' kasamaj, ri acuchi (achique) katicon wi ri uva, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Xpe ri c'ajolaxel ri' xubij c'a chare ri rutata': Riyin ma yibe ta, xcha'. Pero xtzolin pe ruc'u'x ruma xuch'ob chi ma utz ta ri ch'abel ri xubij y xbe c'a pa samaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y ri tata'aj xapon c'a chuka' riq'ui ri jun chic ruc'ajol, y xubij chare chi tibe pa samaj. Y ri c'ajolaxel ri' xubij chare ri rutata': Táta, yare' yibe, xcha'. Yac'a ri c'ajolaxel ri' xa ma xbe ta pa samaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Y c'ac'ari' ri Jesús xuc'utuj: ¿Achique chique ri ye ca'i' ri' ri xbano ri ruraybel ri rutata'? xcha'. Y ri achi'a' ri' xquibij c'a: Ri xbano ri ruraybel ri rutata' ya ri nabey, xecha'. Y ri Jesús xubij c'a chique: Can kitzij c'a nbij chiwe chi xa ye ri c'utuy tak alcawal y ri ixoki' ri ma utz ta c'aslen quic'uan, xa yeri' ri xque'oc nabey pa rajawaren ri Dios, que chiwech riyix, ruma riye' xtzolin pe quic'u'x. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ri Juan ri Bautista tek xpe, riya' xuc'ut c'a jun chojmilaj bey chiwech, yac'a riyix xa ma xinimaj ta. Xaxu (xaxe wi) ri c'utuy tak alcawal y ri ixoki' ri ma utz ta quic'aslen, xaxu (xaxe) wi riye' ri xeniman. Yac'a riyix, astape' xitz'et ri' xa ma xtzolin ta pe ic'u'x riche (rixin) chi queri' xinimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Y tiwac'axaj na pe' jun chic c'ambel tzij, xcha' ri Jesús chique ri winek: Xc'oje' c'a jun achi ri can tetata' chic, ri xutic c'a ruwech ri rulef riq'ui uva y xuben coral chrij ri rulef. Xuben chuka' achi'el jun ti pila pan ulef riche (rixin) chi niyitz' ri uva chupan, y xuben chuka' jun setesic tz'ak ri nej xujotoba' chicaj, y pa ruwi' ri' xc'oje' wi rachoch ri chajinel. C'ac'ari' xuya' ca pa kajic chique ca'i' oxi' mozos, y riya' xbe nej. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y yac'a tek xapon ri ruk'ijul riche (rixin) chi nijunex ruwech ri uva, ri rajaf ri ulef xutek nabey jun rumozo, c'a juba' ri' xutek jun chic. Y queri' ye q'uiy mozos ri xerutek quiq'ui ri kajoy tak ulef chuc'ulic ri uva kajbel riche (rixin) ri ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Xa yac'a ri achi'a' kajoy tak ulef, xa ma xequic'ul ta jabel ri mozos ri ye takon el ruma ri rajaf ri ulef. Jun xquich'ey, jun chic xquiq'uek chi abej y jun chic xquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Y ri rajaf ri ulef xerutakala' c'a nic'aj chic achi'a' ri ye rumozos. Sibilaj ye q'uiy chic c'a ri xerutek. Xa yac'a ri achi'a' kajoy tak ulef xa can queri' chuka' xquibanala' pe chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruq'uisbel, xutek ri ruc'ajol ruma riya' xuch'ob ka: Ri achi'a' ri ye kajayon ri ulef can xqueniman wi c'a chare ri nuc'ajol tek xtiquitz'et chi can ya riya' ri napon quiq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Yac'a ri achi'a' ri ye kajayon ri ulef, can xu (xe) wi xquitz'et chi ya ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquiwech: Yare' ri xtoc ca rajaf ronojel re ulef re kakajon. Wacami quixam pe, tikacamisaj riche (rixin) chi re ulef ntoc ca kiche (kixin) riyoj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y can queri' wi c'a xquiben. Xquichop ri c'ajolaxel y c'ac'ari' xquelesaj c'a el chiri' chupan ri rulef y xquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yac'ari' tek ri Jesús xubij: Tek xtipe ri rajaf ri ulef ri ticon ruwech riq'ui uva, ¿achique cami xtuben chique ri achi'a' kajoy tak ulef, nich'ob riyix? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y ri winek xquibij c'a: Ri rajaf ri ulef man c'a xtujoyowaj ta quiwech ri itzel tak achi'a' kajoy ulef y xquerucamisaj y c'ac'ari' ri rulef xtuya' chic ca pa kajic chique nic'aj chic achi'a' kajoy tak ulef, ri can xtiquiya' wi ri uva kajbel riche (rixin) ri ulef tek napon ri ruk'ijul, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Xpe ri Jesús xubij c'a chique: ¿La can majun bey c'a isiq'uin ta ri jun tzij tz'ibatal ca chupan ri ruch'abel ri Dios? Ri tzij ri' nubij c'a: C'o c'a jun abej ri ma xka ta chiquiwech chi xquicusaj ri nic'aj aj banoy tak jay. Pero re abej re' xa can c'o wi xucusan chare ri xquina riche (rixin) ri jay, riche (rixin) chi ri jay ri' ma nitzak ta. Ri xbano c'a re' can ya wi ri Ajaf, y re' can nikamey ruma majun bey katz'eton ta chi nibanatej ta quere'. Queri' nubij ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y ruma c'a ri quere' ye banatajnek, rumac'ari' riyix xa xtelesex ri rajawaren ri Dios pan ik'a' y xtiya'ox (xtya') chic chique nic'aj chic winek ri can xtiwachin wi pa quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ri winek ri xtitzak c'a chuwech re jun abej re', can xtuquiraj ri' chuwech. Y ri winek ri xtika ri abej ri' chrij, can xtic'ajtej c'a, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y tek ri principali' tak sacerdotes y ri achi'a' fariseos tek quic'axan chic ka ri c'ambel tak tzij ri xerutzijoj ri Jesús, can xk'ax c'a chiquiwech chi chiquij riye' xch'o wi ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y yac'ari' tek riye' can ta c'o xcajo' chi xquichop ta el ri Jesús. Pero ma xquichop ta el ruma xa niquixibij qui' chiquiwech ri winek; ruma chiquiwech ri winek, ri Jesús can jun profeta ri nik'alajsan ri ruch'abel ri Dios, y nubij chuka' chique ri xquebanatej ri chiquiwech apo. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ri Jesús xuchop chic c'a tzij quiq'ui ri winek, y xerucusaj nic'aj chic c'ambel tak tzij. Riya' xuchop c'a rubixic: ");
INSERT INTO cakWNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ri rajawaren ri caj, can junan c'a riq'ui ri xbanatej pa jun nimak'ij ri xuben ri jun rey chare ri ruc'ajol tek xc'ule'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ri rey ri' can yec'o wi ri rubin chic chique chi ye'apon chupan ri jun c'ulanen ri', y rumari' xerutek c'a ri ye rumozos chiquisiq'uixic (chicoyoxic) ri winek ri'. Yac'a tek xesiq'uix (xe'oyox), man chic xcajo' ta xebe. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y ri rey xerutek chic el nic'aj rumozos y xubij el chique: Tibij chique quinojel ri nya'on chic rutzijol chique chrij re jun nimak'ij re', chi ronojel c'o chic riche (rixin) chi nikaben ri wa'in. Ri achij tak nuwáquix y ri nic'aj chic chicop ri xentiojirisaj riche (rixin) chi yec'atzin chupan re k'ij re', xecamisex yan y xechojmirisex yan riche (rixin) chi yetij. Can ronojel c'a c'o chic, quixcha' chique. Chi can quepe c'a chupan re jun c'ulanen re', xcha' el chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Yac'a ri xesiq'uix (xe'oyox), ma xeniman ta pe riq'ui ri xbebix chic jun bey chique. Yec'o xa xebe pa tak quisamaj ri pa tak juyu'; y yec'o xa xebe pa tak c'aynic. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yac'a ri nic'aj chic xequichop ri mozos ri ye rutakon el ri rey, jani' na c'a xquiben chique y xequicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Yac'a tek xapon rutzijol riq'ui ri rey ri xbanatej, xyacatej royowal. Can yac'ari' tek riya' xerutek achi'a' ye banoy tak ch'a'oj chiquij riche (rixin) chi xeruq'uis c'a ri xecamisan quiche (quixin) ri rumozos, y chuka' can xubij chi tiporox c'a ri quitinamit. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Yac'ari' tek ri rey xch'o chic quiq'ui ri rumozos y xubij c'a chique: Can kitzij wi chi ronojel c'o chic riche (rixin) chi nibanatej ri c'ulanen, xa yac'a ri xensiq'uij (xenwoyoj) ma xcajo' ta xepe, y riq'ui ri' xk'alajin chi ma ruc'amon ta (takal ta chiquij) chi yepe. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wacami c'a, quixbiyin ri pa tak bey y que'isiq'uij (que'iwoyoj) pe quinojel ri xque'iwil riche (rixin) chi yepe chupan re jun c'ulanen re', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y ri mozos can xebe na wi ri pa tak bey, xebequimolo' c'a pe quinojel winek, chi utz y ma utz ta quic'aslen. Y ri jay ri acuchi (achique) xban wi ri c'ulanen, xnoj. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y ri rey xoc c'a apo chiquitz'etic quinojel ri xerusiq'uij (xeroyoj). Y riya' xutz'et c'a chi c'o c'a jun achi chiri' ri ma rucusan ta ri tziek ri nic'atzin chi nucusex chupan jun c'ulanen. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ri rey xch'o c'a riq'ui ri achi ri', ri can rusiq'uin (royon) wi chuka' chupan ri jun c'ulanen ri', y xuc'utuj c'a chare: Y riyit ¿achique c'a modo xatoc pe wawe', tek xa ma xacusaj ta ri tziek ri nic'atzin chupan re jun c'ulanen re'? xcha' ri rey chare. Y ri achi ma xch'o ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Yac'ari' tek ri rey xubij chique ri rumozos: Tixima' el ruk'a' raken re jun achi re xa ma xucusaj ta ri tziek ri nic'atzin tek c'o jun c'ulanen y je'ic'aka' c'a ca quela' pa k'eku'm ri acuchi (achique) xtok' wi y xtukach'ach'ej rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y astape' can ye q'uiy c'a ri yesiq'uix (ye'oyox), xa ma ye q'uiy ta ri xquechatej riche (rixin) chi ye'oc pa rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y yac'ari' tek ri achi'a' fariseos xebe. Riye' xquiya' c'a chiquiwech riche (rixin) chi achique ta jun niquiben riche (rixin) chi ri Jesús nitzak ta pa quik'a' riq'ui ri ch'abel ri nubij. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Yac'ari' tek riye' xequitek ri quidiscípulos ye cachibilan el ye ca'i' oxi' chique ri yec'o pa rupartido ri rey Herodes. Xequitek el c'a riq'ui ri Jesús; y riye' xbequibij c'a chare tek xe'apon riq'ui: Riyit ri can yit jun Tijonel, riyoj can ketaman c'a chi xaxu (xaxe) wi c'a ri kas kitzij ri nika chawech y yari' ri natzijoj. Can nac'ut wi ri bey riche (rixin) ri Dios chiquiwech ri winek. Y riyit ma naxibij ta awi' chuwech jun winek, astape' can c'o ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Y wacami nikajo' c'a nikac'axaj achique nabij riyit. ¿La ruc'amon cami chi nikatoj ri alcawal ri nubij ri César ri c'o chi nikatoj o xa ma ruc'amon ta? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yac'a ri Jesús can retaman ri itzel ch'obonic ri yetajin chrij. Rumari' Riya' xubij c'a chique: Riyix xa ca'i' ipalej. ¿Achique c'a ruma riyix nitij ik'ij riche (rixin) chi yinitojtobej? ");
INSERT INTO cakWNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu' c'a pe ri puek ri niya' riyix riche (rixin) chi nitoj ri alcawal, xcha' chique. Y riye' can yac'ari' xquic'ut apo ri puek chuwech; y ri puek ri xquic'ut apo, ya c'a ri niquibij denario chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y ri Jesús yac'ari' tek xuc'utuj chique: ¿Achoj ruwachbel c'a la'? ¿Y achoj rubi' chuka' la c'o chuwech la puek? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y riye' xquibij c'a chare ri Jesús: Riche (rixin) ri César, xecha'. Y ri Jesús xubij c'a chique: Can tiya' c'a chare ri César ri can riche (rixin) wi ri César. Y can tiya' c'a chare ri Dios, ri can riche (rixin) wi ri Dios, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y tek ri achi'a' ri' quic'axan chic ka ri xubij ri Jesús, can xquimey tek xquic'axaj. Y riye' xquiya' c'a ca ri Jesús, y xebe el. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ya c'a k'ij ri' tek nic'aj chique ri achi'a' saduceos xe'apon riq'ui ri Jesús, ruma c'o nicajo' niquic'utuj chare. Ri achi'a' ri' ma niquinimaj ta chi ri caminaki' xquec'astej chic pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Rumac'ari' riye' xquibij c'a chare ri Jesús: Riyit ri can yit jun Tijonel, c'o c'a jun ri nikajo' nikac'utuj chawe. Ri Moisés can rutz'iban wi c'a ca chake chi tek jun achi nicom el y majun ralc'ual nic'oje' ca riq'ui ri rixjayil, can jun c'a rach'alal ri achi ri' c'o chi nic'ule' riq'ui ri ixok ri xmalcanij ca, riche (rixin) chi queri' yec'oje' ta ralc'ual riq'ui ri ixok ri'. Y ri nabey ti c'ajol (ala') ri nalex ntoc ralc'ual ri caminek chic el. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y riye' xquibij c'a: Chkacojol riyoj xec'oje' c'a ye wuku' achi'a' cach'alal qui'. Y xbanatej c'a chi ri nimalaxel xc'ule' pero ri achi ri' xa xcom el y majun ralc'ual xc'oje' ta ca. Y ri rixjayil xcanaj ca chare ri rach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ri ruca'n achi can queri' chuka' xuc'ulwachij el, riya' xcom el y majun ralc'ual xc'oje' ta ca. Ri rox achi can queri' chuka' xuc'ulwachij el, achi'el ri ca'i' nabey tak rach'alal y ri ixok c'a xc'oje' na ca. Y quec'ari' xquic'ulwachila' el chi ye wuku' cach'alal qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y tek ye caminek chic c'a el ri ye wuku' achi'a' cach'alal qui' chuwech ri ixok ri', pa ruq'uisbel xcom chuka' el ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y ri achi'a' saduceos xquibij c'a chare ri Jesús: Riyit nabij chi xtapon na jun k'ij tek ri caminaki' xquec'astej pe. Y tek xtapon ri k'ij ri', ¿achoj rixjayil c'a xtoc wi ri ixok ri'? Ruma chi ye wuku' achi'a' cach'alal qui' xec'oje' riq'ui, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Can yac'ari' tek ri Jesús xubij chique ri achi'a' ri': Riyix xa yix sachnek riq'ui ri xibij. Xa ma k'axnek ta chiwech ri nubij chupan ri ruch'abel ri Dios. Y xa ma iwetaman ta chi ri ruchuk'a' ri Dios sibilaj nim. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ruma tek xtapon ri k'ij chi ri caminaki' xquec'astej el, ri achi ma xtic'oje' ta chic rixjayil, ni ri ixok ma xtic'oje' ta chic rachijil, ruma can majun chic c'ulanen xtibanatej. Riye' xa can xque'oc c'a achi'el ri ru'ángeles ri Dios chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yac'a ri c'astajbel quiche (quixin) ri caminaki', can c'o wi. ¿La ma isiq'uin ta c'a chupan ri ruch'abel ri Dios? Tek ri Dios xubij: ");
INSERT INTO cakWNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Yin c'a riyin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob. Can quec'ari' ri xubij ri Dios ojer ca. Y xa ta ri kati't kamama' ri' xa xecom ta jurayil, ri Dios man ta qui-Dios chic riye', ruma xa ma xquec'astej ta chic pe. Ruma ri Dios, ma Dios ta quiche (quixin) ri caminaki', xa can Dios quiche (quixin) ri c'o quic'aslen, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y tek ri winek quic'axan chic ri ch'abel ri nuc'ut ri Jesús, can xquimey ri xquic'axaj, ruma majun bey quic'axan ta ch'abel queri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tek ri achi'a' fariseos xquic'axaj chi ri Jesús can xutz'apij wi c'a xequey ri achi'a' saduceos riq'ui ri xubij chique, can chanin c'a xquimol qui' chuch'obic achique ri xtiquiben. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpe c'a jun chique ri achi'a' fariseos, ri can c'o q'uiy retaman chrij ri ley riche (rixin) ri Moisés, xaxu (xaxe wi) c'a riche (rixin) chi nutojtobej ri Jesús, xuc'utuj c'a chare: ");
INSERT INTO cakWNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Riyit ri can yit Tijonel wi, tabij c'a chuwe, ¿achique c'a chique ri pixa' ri más nim rejkalen ri xuya' ri Dios pa ruk'a' ri Moisés? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y ri Jesús xubij chare: Ri pixa' ri' ya ri tawajo' c'a ri Dios ri Awajaf. Tawajo' riq'ui ronojel awánima. Tawajo' chupan ronojel ri ac'aslen, y riq'ui ronojel ri anojibal. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Can yac'ari' ri nabey y nimalaj pixa' ri c'o chupan ri ley. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y c'o chuka' jun ruca'n pixa' y juba' ma junan riq'ui ri nabey. Y ri pixa' ri' nubij c'a: Can achi'el nawajo' ka awi' riyit, can queri' c'a chuka' que'awajo' ri awuc' awach'alal. Queri' nubij ri pixa' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Re ca'i' pixa' re', yare' ruc'u'x ri nubij ri ley riche (rixin) ri Moisés y ronojel c'a ri quibin ca ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y tek quimolon qui' ri achi'a' fariseos, xpe ri Jesús xuc'utuj c'a chique: ");
INSERT INTO cakWNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Achique c'a nibij riyix chrij ri Cristo? Tek Riya' xtipe, ¿achoj ralc'ual Riya'? xcha' c'a chique. Y ri achi'a' fariseos xquibij c'a: Ralc'ual ca ri rey David, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xubij c'a chique: Pero wi Riya' xa choj jun ralc'ual ca ri rey David, ¿achique c'a ruma tek ri rey David xubij Wajaf chare ri Cristo? Ruma xa can xk'alajsex chare ruma ri Lok'olaj Espíritu; y rumari' tek xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Dios xubij c'a chare ri Wajaf: Catz'uye' re pa wajquik'a', c'a ya tek xquenya' na pan ak'a' pan awaken ri ye'etzelan awuche (awixin). Queri' ri rutz'iban ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y wi ri rey David, Wajaf xcha' chare ri Cristo, ¿achique c'a ruma tek ri winek niquibij chi ri Cristo xa choj jun ralc'ual ca ri rey David? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y can majun c'a jun ri xcowin ta xbin apo ri xuc'utuj ri Jesús chique. Can ya c'a k'ij ri' tek can majun chic ri xbano cowil chi c'o ta ri xuc'utuj apo chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y ri Jesús yac'ari' tek xch'o quiq'ui ri winek y chuka' quiq'ui ri rudiscípulos y xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ri aj tz'iba' y ri achi'a' fariseos yec'a riye' ri yec'o ca pa ruq'uexel ri Moisés riche (rixin) chi niquic'ut ri ruch'abel ri Dios chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rumac'ari' riyix can tinimaj quitzij. Can ronojel c'a ri niquibij chiwe, tibana' y titakej. Xa yac'a ri ma tiben ta achi'el ri niquiben riye'. Ruma chi riye' xa ma niquiben ta ri niquibij chi tiban. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Riye' nima'k tak ejka'n niquiyala' chiquikul ri winek, ejka'n ri can c'o calal y c'ayef (cuesta) quic'uaxic. Ri ejka'n ri' xaxu (xaxe) wi chiquikul ri winek niquiya' wi y riye' ni xa ta jun ti ruwi' quik'a' niquisiloj riche (rixin) chi niquic'uaj ri ejka'n ri niquibij ri c'o chi niquic'uaj ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Y ronojel ri niquiben xaxu (xaxe wi) riche (rixin) chi utz yetz'et cuma ri winek y yenimex. Y rumari' tek nima'k ruwech niquibanala' chare ri niquitz'ibaj wi ri ruch'abel ri Dios ri niquic'uaj chrij ri quik'a' y ri nic'aj tak quiwech. Y ruma chuka' ri' tek nima'k raken niquibanala' chare ri retz'aba'l ruchi' tak quitziak. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Can ya chuka' ri nabey tak ch'aquet yequicanola' ri pa nima'k tak wa'in y ya chuka' ri' ri yequicha' pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, riche (rixin) chi queri' nibix chi riye' c'o quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Can sibilaj nika chiquiwech ri niya'ox (nya') rutzil quiwech ri pa tak c'aybel. Y chuka' can sibilaj nika chiquiwech nibix Tijonel, Tijonel chique cuma ri winek, ruma c'o quik'ij yetz'et. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Yac'a riyix ma tiwajo' ta chi nibix nimalaj tijonel chiwe, ruma xa can xu (xe) wi c'a Jun ri ruc'amon (takal chrij) chi nibij Itijonel chare, y ri' ya ri Cristo. Yac'a chi'iwonojel riyix, xa iwach'alal iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Majun ri c'o wawe' chuwech ri ruwach'ulef ri utz nibij tata'ixel chare. Ruma xa jun ri Tata'ixel iwuche (iwixin) riyix ri c'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Can ma tiwajo' ta c'a chi ri winek niquibij tijonel chiwe. Ruma xa can xu (xe) wi Jun ri Tijonel c'o y ri' ya ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ruma ri más nim ruk'ij chiwe riyix, nic'atzin chi nuna' ka ri' chi xa majun ruk'ij y tuch'utinirisaj ri' riche (rixin) chi yerunimaj yerilij ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ruma chi ri niquinimirisaj qui', xa xtikasex quik'ij. Y yac'a ri niquich'utinirisaj qui', xtinimirisex quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Yac'a riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej, ¡can juyi' oc iwech! ruma xa can ik'aton c'a quibey ri winek riche (rixin) chi ma ye'oc ta pa rajawaren ri caj. Y ni xa ta c'a yixoc riyix y ni xa ta niya' k'ij chique ri winek chi ye'oc. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma riyix niwelesala' ronojel quicosas ri malcani' tak ixoki'. Y xaxu (xaxe wi) riche (rixin) chi tinimex chi jabel ri ic'aslen, yixyaloj c'a tek niben orar. Pero riyix can xtik'ax ruwi' ri ruc'ayewal ri xtika pan iwi', ruma chi ri imac sibilaj q'uiy. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma riyix can nik'axala' mar y nik'axala' ruwach'ulef chucanoxic chi c'o ta jun ri ntoc tzekelbey iwuche (iwixin) y nunimaj ta achi'el ri ninimaj riyix. Xa yac'a tek iwilon chic ri achique xtitzekelben iwuche (iwixin), riyix xa niben chare chi ntoc más itzel winek, ruma ri nic'ut chuwech nuben chare chi nej nibe wi ca chare ri Dios. Riyix can nej c'a yixc'o wi, yac'a riya' ca'i' mul más nej nibe wi ca chare ri Dios, y xa rumari' tek can ruc'amon chi nibe pa k'ak' chuka' riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Y chuka' can juyi' oc iwech riyix ri yixbin chi yix uc'uey bey y xa yix moyi'! Riyix ri yixbin chi wi c'o jun ri ninatan ri rachoch ri Dios riche (rixin) chi nuben jurar, astape' ma nuben ta ri xubij, ri' majun nuben. Yac'a ri ninatan ri k'anapuek ri c'o pa rachoch ri Dios riche (rixin) chi nuben jurar, ri' c'o chi nuben, yixcha' riyix. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Riyix xa yix nacanek y yix moyi'. Ruma, ¿achique c'a ri más nim ruk'ij? ¿La ya cami ri k'anapuek ri c'o pa rachoch ri Dios o xa can ya ri rachoch ri Dios ri nibano lok'olaj chare ri k'anapuek ri c'o chiri'? ");
INSERT INTO cakWNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Riyix chuka' nibij: Ri ninatan ri altar riche (rixin) chi nuben jurar, astape' ma nuben ta c'a ri xubij, ri' majun nuben. Yac'a ri ninatan ri ofrenda ri nic'oje' pa ruwi' ri altar riche (rixin) chi nuben jurar, ri' c'o chi nuben. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Riyix xa yix nacanek y yix moyi'. Ruma, ¿achique c'a ri más nim ruk'ij? ¿La ya cami c'a ri ofrenda o xa can ya ri altar? Can ya wi ri altar ri más nim ruk'ij, ruma yari' ri nibano lok'olaj chare ri ofrenda. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri ninatan c'a ri altar riche (rixin) chi nuben jurar, can nunataj c'a ronojel. Nunataj ri altar y nunataj chuka' ri ofrenda ri ya'on pa ruwi' ri altar. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri can ninatan c'a ri rachoch ri Dios riche (rixin) chi nuben jurar, can nunataj c'a ronojel. Nunataj ri rachoch ri Dios y nunataj ri c'o chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri ninatan c'a ri caj riche (rixin) chi nuben jurar, can nunataj wi c'a ronojel. Nunataj c'a ri tz'uyul wi ri Dios y can nunataj c'a chuka' ri Dios ri tz'uyul chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Xa can juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma tek riyix niya' ri idiezmo, can niya' wi ri k'ayis ri jubul ruxla', ri menta rubi', ri anís y ri comino. Pero xa iya'on ca rubanic ri ruchojmilal ri c'aslen ri nubij chupan ri ley ri más rajawaxic chi niben, chi tic'oje' joyowanic iwuq'ui y kitzij tucuke' ic'u'x riq'ui ri Dios. Ya ta c'a ri' ri rajawaxic chi niben y rajawaxic chuka' chi ma niya' ta ca ruya'ic ri idiezmo. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Riyix c'a ri yixbin chi yix uc'uey bey, xa yix achi'el moyi', ruma xaxu (xaxe wi) nichayuj ca ri us y xa nibik' ri nimalaj chicop ri camello rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Can juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma xa yix achi'el lek ri jabel ch'ajch'oj rij y ri rupan xa tz'il. Riyix can nic'ut c'a chiquiwech ri winek chi utz ri ye'ibanala', yac'a ri pa tak iwánima xa ma que ta ri', ruma xa nojnek riq'ui alek', y nojnek riq'ui itzel tak raynic, ruma riyix can nirayij chi ronojel ri c'o quiq'ui ri winek iwuq'ui ta riyix c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Riyix fariseos xa yix moyi'. Can tibana' c'a chare ri ic'aslen achi'el niban riq'ui ri lek, nich'ajch'ojsaj rupan y ri rij. Riyix tich'ajch'ojsaj c'a ri iwánima nabey, riche (rixin) chi queri' ri ic'aslen chiquiwech ri winek can ch'ajch'oj chuka' nik'alajin. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma xa yix junan riq'ui jun panteón ri acuchi (achique) ya'on wi jun caminek. Ri rij jabel sek y ch'ajch'oj, yac'a ri rupan xa ma ch'ajch'oj ta, xa ruyon rubakil caminek c'o. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Can quec'ari' ibanic riyix. Riyix nic'ut c'a chi choj ri ic'aslen chiquiwech ri winek, yac'a ri pan iwánima xa ma que ta ri'. Ri iwánima xa nojnek riq'ui etzelal. Y chuka' xa ca'i' ipalej. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Juyi' oc iwech riyix aj tz'iba' y riyix fariseos ri xa ca'i' ipalej! ruma nibanala' ruchojmil ri panteón acuchi (achique) ye mukun wi ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Riyix can jabel wi niwik ri acuchi (achique) ye mukun wi ri chojmilaj tak ralc'ual ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y riyix nibij c'a: Xa ta riyoj xojc'oje' pa quitiempo ri kati't kamama', riyoj man ta xoj-oc cachibil riye' tek xequicamisaj ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, yixcha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Y riq'ui ri queri' nibij, xa yix c'a riyix ri yixk'alajsan ka chiwij chi yix quiy quimam ca ri xecamisan quiche (quixin) ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Can tiq'uisa' c'a rubanic chuka' riyix ri quichapon ca rubanic ri iwati't imama'. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Riyix xa yix achi'el itzel tak cumatz. Can majun chic c'a rubanic ri niben riche (rixin) chi yixcolotej chi man ta yixbe pa k'ak' chuc'ulic ri rutojbalil ri ye'ibanala'. Riyix xa can chiri' c'a xquixapon wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Y riche (rixin) c'a chi xtik'alajin ri iwetzelal, riyin yare' yentek el chicojol, profetas ri yek'alajsan ri ruch'abel ri Dios, yentek c'a achi'a' ri c'o quina'oj, y yentek chuka' aj tz'iba'. Yac'a riyix yec'o c'a chique riye' ri xque'icamisaj y yec'o ri xque'ibajij chuwech tak cruz. Yec'o c'a xque'ich'ey chiri' pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios; y xabachique c'a tinamit yebe wi riye', riyix chuka' xquixapon chiri' riche (rixin) chi ye'iwokotan. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y ronojel re' can xtuben c'a chiwe chi pan iwi' riyix xtika wi ri rutojbalil ri quicamic quinojel ri chojmilaj tak winek ri ye camisan el chuwech re ruwach'ulef. Xuchop pe riq'ui tek xcamisex ri chojmilaj achi xubini'aj Abel y nbeq'uis c'a riq'ui tek xcamisex ri achi xubini'aj Zacarías, ri ruc'ajol ri achi xubini'aj Berequías. Y nbij c'a chiwe, chi ri Zacarías can yix chuka' riyix ri xixcamisan riche (rixin), chiri' chunakajal ri altar ri c'o chuwarachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ronojel re xinbij c'a ka chiwe, can kitzij wi chi pa quiwi' ri winek ri yec'o re wacami ri xtika wi ri rutojbalil. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Y c'ac'ari' ri Jesús xubij c'a: Riyix aj Jerusalem, aj Jerusalem, ¿achique c'a ruma tek ye'icamisala' ri profetas ri yek'alajsan ri ruch'abel ri Dios? ¿Achique c'a ruma chuka' tek ye'icamisala' chi abej ri yerutek pe ri Dios chicojol? Riyin can q'uiy c'a mul ri xinwajo' chi xixinmol ta wuq'ui, achi'el nuben ri quite' ec' chique ri tak ral, yerumol chuxe' ri ruxic'. Yac'a riyix ma xiwajo' ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Wacami c'a, ri itinamit xtimalix ca ruma ri Dios, xtiban c'a ca chare chi xtoc achi'el jun desierto. ");
INSERT INTO cakWNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y queri' c'a nbij chiwe ruma riyix can man c'a xquinitz'et ta chic. Y xquinitz'et chic c'a jun bey, c'a ya tek xtibij chuwe: ¡Matiox chi petenak re jun achi re'! ¡Riya' banon pe bendecir ruma ri Ajaf Dios! ¡Y can pa rubi' ri Ajaf Dios petenak wi! xquixcha' chuwe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y tek ri Jesús xel c'a pe ri chiri' pa rachoch ri Dios riche (rixin) chi nibe el, ri rudiscípulos xejel c'a apo riq'ui y xquic'ut ri jay ri ye riche (rixin) ri rachoch ri Dios chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yac'ari' tek Riya' xubij chique ri rudiscípulos: Riyix can ye'itzu' c'a chi re jay re' sibilaj ye jabel. Yac'a riyin can kitzij c'a nbij chiwe, chi xtapon na jun k'ij tek xa can xquewulex y majun chic ri xtipa'e' ta ca. Ronojel re nima'k tak abej re ye ucusan chique re jay re', xa can xquewulex c'a pe. Can majun c'a abej ri xtic'oje' ta ca achi'el la rubanon wacami, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y tek ri Jesús tz'uyul chic c'a pa ruwi' ri juyu' ri Olivos rubi', yac'ari' tek ri rudiscípulos xejel apo riq'ui y xquic'utuj chare: Tabij c'a chake, ¿ajan (jampe') c'a xtic'ulwachitej ri xabij yan ka chrij ri rachoch ri Dios? ¿Achique c'a retal nibanatej riche (rixin) chi queri' ninabex tek xcape chic jun bey, y riche (rixin) chi queri' ninabex chi xa napon yan ri ruq'uisbel k'ij riche (rixin) re tiempo re'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y ri Jesús xubij c'a chique ri rudiscípulos: Can jabel c'a tichajij iwi' riche (rixin) chi ma xquixk'olotej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ruma can ye q'uiy ri xquepe y xtiquibila': Yin c'a riyin ri Cristo, xquecha'. Y sibilaj ye q'uiy ri xquek'olotej pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y xtiwac'axala' c'a chi yec'o ruwach'ulef ri c'o ch'a'oj ntajin chiquicojol. Y xtiwac'axala' rutzijol chi c'o chuka' ch'a'oj ri xquepe. Yac'a riyix ma tisach ta ic'u'x, ruma ronojel ri' xa can c'o c'a chi yebanatej na. Pero xa ma ya ta ri' ri ruq'uisbel tak k'ij chare re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun tinamit xtiyacatej c'a el chi nberubana' ch'a'oj riq'ui jun chic tinamit. Yec'o c'a chuka' nima'k tak ruwach'ulef ri xqueyacatej el chi nbequibana' ch'a'oj quiq'ui nic'aj chic nima'k tak ruwach'ulef. Xquepe c'a yabil, wayjal y chuka' nimalaj tak silonel xabachique lugar chare re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y yac'ari' ri nabey tak k'axomal, y c'ac'ari' tek xquepe c'a nic'aj chic quiwech tijoj pokonal. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Xquixya'ox (xquixya') c'a pa tak tijoj pokonal, y xquixcamisex. Xa can xquixetzelex wi c'a cuma quinojel ri winek ri yec'o chuwech re ruwach'ulef, ruma riyix can icukuban ic'u'x wuq'ui riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ye q'uiy c'a ri can xquetzak ca, yec'o chuka' xtiquitzujuj (xtiquisujuj) qui' y yec'o ri xtiquetzelaj qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y xquebec'ulun pe chuka' ye q'uiy ri xquebin chi ye profetas y xtiquibij chi niquik'alajsaj ri ruch'abel ri Dios y xa ma kitzij ta. Y ruma c'a can queri' ri niquibij, can ye q'uiy wi c'a winek ri xquek'olotej pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chuka' chupan ri tiempo ri' ruma can q'uiyirnek chic ri etzelal, ye q'uiy c'a ri xa can ma xticajo' ta chic qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Yac'a ri ma xtutzolij ta ri' chrij y xtucoch' ronojel c'a pa ruq'uisbel, ya c'a ri' ri xticolotej. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y c'o c'a chi nitzijox na ri lok'olaj ch'abel ri nich'o chrij ri rajawaren ri Dios chuwech ronojel re ruwach'ulef, riche (rixin) chi netamex cuma quinojel ri tinamit. Y c'ac'ari' tek xtapon ri ruq'uisbel k'ij riche (rixin) re tiempo re kachapon. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y chuka' can xtapon wi ri k'ij tek xquebanatej ri xajan chupan ri lok'olaj lugar ri ma ruc'amon ta chi nibanatej chiri'. Y rumari' xtiwulex c'a ca ri lugar ri'. Can achi'el ri tz'ibatal ca ruma ri Daniel, jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Ri nitz'eto c'a ri tz'ibatal ca, tik'ax c'a chuwech ri nutz'et. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Riche (rixin) chi queri' tek xtitz'et chi can ya chic ri' ri ntajin, ri yixc'o pa Judea xa can quixanmej c'a el y tiwewaj iwi' ri pa tak juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri c'o c'a pa ruwi' ri rachoch tek xtibanatej ronojel ri', xa utz chi tanmej el. Y ma toc ta chic pa rachoch riche (rixin) chi c'o na ri nberuc'ama' pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri nisamej c'a pa juyu', ma tibe ta chic chrachoch chuc'amaric ri ruchaqueta. Xa choj chuka' queri' tanmej el. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Yac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a yetz'uman na ri tak cal, juyi' oc quiwech tek xtapon ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rumac'ari' xa tic'utuj chare ri Dios chi ronojel ri' man ta xtibanatej pa ruk'ijul ri job y chuka' can tic'utuj c'a chi man ta pa jun uxlanibel k'ij xtibanatej wi ronojel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ruma tek xtapon c'a ri k'ij ri', can xtik'ax ruwi' ri tijoj pokonal ri xtipe, jun tijoj pokonal ri majun bey c'ulwachitajnek ta pa ruwi' re ruwach'ulef jani' chi tiempo ri winakirsan wi pe ruma ri Dios. Chuka' ri jun tijoj pokonal ri' majun bey chic c'a xtic'ulwachitej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y wi xa ta ri Dios man ta nuben chi xa k'atatel ri k'ij riche (rixin) ri tijoj pokonal ri', quinojel ta yecom. Pero ruma ri rutzil ri Dios pa quiwi' ri ye rucha'on chic, rumari' can xtuben wi chi xa k'atatel ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan ri k'ij ri', wi yec'o c'a ri yebin chiwe: Titzu', ya c'a Cristo re'. O wi niquibij chiwe: Titzu', ya c'a Cristo la', man c'a tinimaj ta ri niquibij chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ruma can yec'o c'a ri xquebec'ulun pe y xtiquibila' c'a chi ye riye' ri Cristo. Yac'a riyix man c'a que'inimaj ta, ruma xa ye k'olonel. Y yac'a chuka' tiempo ri' tek xquebec'ulun pe ri xquebin chi ye profetas ri xtiquibij chi niquik'alajsaj ri ruch'abel ri Dios. Yac'a riyix man c'a que'inimaj ta, ruma xa ye k'olonel chuka'. Y xquequibanala' c'a nima'k tak milagros ri majun bey ye tz'eton ta, ruma nicajo' chi yenimex, y yec'o ri xquek'olotej pa quik'a'. Y wi ta xa can yecowin, riye' yequik'ol ta chuka' ri ye cha'on chic ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Can yac'are' xinbij yan ca chiwe ri xquebanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumari' wi xa can nibix c'a chiwe: Ri Cristo xpe yan y wacami c'o pa jun desierto, riyix man c'a quixbe ta chutz'etic. Y wi nibix chiwe chi ri Cristo c'o chic y wacami chupan ri jun jay ri' c'o wi, ma que'inimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ruma tek xtipe chic jun bey ri C'ajolaxel ri xalex chicojol, can xtik'alajin wi c'a jabel achi'el nuben ri coyopa' tek ntel pe ri pa relebel k'ij y nbek'alajin c'a pa rukajbel k'ij, can quinojel c'a yetz'eto. Y quec'ari' xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ruma ri ruc'ayewal ri xtuya' ri Dios xtika acuchi (achique) c'o wi ri mac. Can xtibanatej c'a achi'el niquiben ri c'uch. Ruma ri aj xic' tak chicop ri' xabacuchi (xabachique) c'o wi jun caminek ch'aculaj, chiri' c'a yeka wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y tek ye k'axnek chic c'a ronojel ri tijoj pokonal riche (rixin) ri tiempo ri', can xtibanatej wi c'a chi ri k'ij xtik'ekumatej y ri ic' chuka' ma xtitzu'un ta chic. Ri ch'umila' xquetzak c'a el chuwech ri caj. Can ronojel wi c'a ri nimalaj tak uchuk'a' ri yec'o chicaj xquesilon na. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Yac'ari' tek xtitz'etetej jun retal chila' chicaj chi yin c'a riyin ri C'ajolaxel ri xinalex chicojol ri yin petenak. Yac'ari' tek xque'ok' quinojel quiwech chi winek ri yec'o chuwech re ruwach'ulef, tek xquinquitz'et chi yin c'a riyin ri yin petenak pa sutz' ri chila' chicaj, riq'ui chic nimalaj wuchuk'a' y riq'ui chuka' jun nimalaj nuk'ij nuc'ojlen. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y yac'a chuka' ri' tek c'o jun trompeta ri can riq'ui ruchuk'a' xtik'ajan pe y riyin xquentek c'a ri nu'ángeles chiquimolic ri ye nucha'on chic. Can xquequimol wi c'a pe re quere' pa relebel k'ij y re quere' pa rukajbel k'ij, re quere' c'a pa jotol y re quere' chuka' pa xulan. Can xquequimol wi c'a pe, ronojel ri acuchi (achique) nitiquir wi pe ri jun ruchi' re caj, c'a la jun chic ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Can tic'ama' c'a ina'oj chrij ri juwi' che' ri higo rubi'. Tek can yeraxer c'a pe ri ruk'a' y niquichop yeq'uiy pe ri ruxak, etaman c'a ri' chi ya xa nik'ax yan ruk'ijul ri sak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y quec'ari' tek xtitz'et chi yec'ulwachitej chic ronojel ri xinbij yan ka, tiwetamaj c'a ri' chi noka yan ri ruq'uisbel tak k'ij. Xa can nakaj chic c'a c'o wi pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Y tiwac'axaj c'a jabel re xtinbij chiwe re wacami: Ronojel ri' xtic'ulwachitej tek ri winek riche (rixin) re tiempo re kachapon, c'a ma jane queq'uis ta chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Y re ruwach'ulef y ri caj xa xquek'ax. Yac'a ri nuch'abel can ma xtiq'uis ta chak que ta ri', xa can xtibanatej na wi ri nubij. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Yac'a ri k'ij y ri hora tek riyin xquipe, majun achique etamayon ta. Ni xa ta ri ángeles ri yec'o chila' chicaj ma quetaman ta ajan (jampe') xquipe. Xa can xu (xe) wi ri Nata' ri etamayon ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xa can achi'el c'a ri xbanatej pa rutiempo ri Noé, xa can queri' c'a chuka' xtic'ulwachitej tek xquipe chic riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ruma ri pa rutiempo ri Noé, tek can c'a ma jane tibanatej ta ri nimalaj job, ri winek xaxu (xaxe) wi c'a chrij ri quiway quic'uya' benak wi ri cánima. Chuka' chi achi'a' chi ixoki' can benak c'a cánima chrij ri quic'ulanen. Y can c'a que na ri' yetajin chubanic ri winek chupan ri k'ij tek ri Noé y ri ye aj pa rachoch xe'oc chupan ri nimalaj barco. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y ma xk'ax ta chiquiwech ri nimalaj ruc'ayewal ri nipe chiquij, xk'ax chiquiwech pero c'a ya tek xpe ri nimalaj job ri xq'uiso quiche (quixin) quinojel. Y can queri' c'a chuka' xtibanatej tek xtapon ri k'ij tek riyin ri C'ajolaxel ri xinalex chicojol xquipe chic jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Yac'ari' tek xtibanatej chi ye ca'i' achi'a' ri junan yesamej pa juyu', jun c'a ri xtuc'uex el y jun ri xticanaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chuka' ye ca'i' ixoki' ri junan yequi'en, jun c'a ri xtuc'uex el y jun ri xticanaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rumac'ari' can ma quixmestan ta, xa can quiniwoyobej apo, ruma xa ma iwetaman ta ajan (jampe') tek xquipe riyin ri Iwajaf. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Riyix iwetaman, chi xa ta ri rajaf jun jay nretamaj ajan (jampe') napon ri alek'om pa rachoch, ri rajaf ri jun jay ri' nic'ase' ta riche (rixin) chi nuchajij ri rachoch, y man ta nuya' k'ij chare ri alek'om chi nelek' el pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rumac'ari', riyix nic'atzin chi can quiniwoyobej apo, ruma riq'ui juba' ri hora tek xa ma yin ta riyin ri yinich'ob, yari' tek xquipe riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chupan ri k'ij ri' can xtibanatej c'a achi'el ri nuben jun patrón ri ruya'on ca jun rumozo ri can c'o runa'oj pa quiwi' ri ye aj pa rachoch y rubin ca chare chi querutzuku' apo tek napon ri hora. Wi can nuben wi ri bin ca chare y utz nuben chare ronojel ri samaj, ");
INSERT INTO cakWNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","can jabel ruwaruk'ij ri mozo ri', ruma ntajin chubanic ri samaj tek no'ilitej ruma ri rupatrón. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can kitzij wi c'a nbij chiwe chi ri patrón ri' can xtuya' wi c'a ronojel ri rubeyomal pa ruk'a' ri mozo ri' riche (rixin) chi nuchajij. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero ri itzel mozo, wi xa nuch'ob ka pa ránima: Ri nupatrón ri' xa c'a ma jane noka ta na, nicha'; ");
INSERT INTO cakWNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y nuchop c'a quich'ayic ri nic'aj chic mozos y chuka' can xu (xe) ta wi wa'in y tijoj ya' nuben quiq'ui ri k'abarela', ");
INSERT INTO cakWNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ya c'a ri k'ij y ri hora tek majun nuch'ob chi noka ri rupatrón, yac'ari' tek noka. ");
INSERT INTO cakWNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Y ri rupatrón, can xtuc'ajsaj wi ruwech ri mozo ri' y xtuya' quiq'ui ri nic'aj chic ri xa ca'i' quipalej. Y chiri' c'a xtok' wi y xtukach'ach'ej rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Y chupan c'a ri k'ij tek xquipe chic, ri pa rajawaren ri caj xtibanatej c'a achi'el ri xquic'ulwachij ye lajuj k'opoji' ri xquic'uaj el quilámpara chi xebe chiroyobexic jun c'ajol ri xtic'ule' chupan ri ak'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ye wu'o' c'a chique ri k'opoji' ri' can c'o wi quina'oj. Yec'a ri ye wu'o' chic man c'o ta quina'oj. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri wu'o' k'opoji' ri xa man c'o ta quina'oj, xebe c'a chiroyobexic ri c'ajol ri xtic'ule', xa yac'a ri ma xquic'uaj ta c'a nic'aj chic aceite riche (rixin) ri quilámpara, xa can xu (xe) wi ri c'o el chupan. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Yac'a ri wu'o' chic k'opoji' ri c'o quina'oj, xquic'uaj c'a ri quilámpara y quic'ualon chuka' el c'ojlibel (frasco) nojnek el riq'ui aceite. Y riye' xebe c'a chiroyobexic ri c'ajol ri xtic'ule'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y ruma c'a chi ri c'ajol ri nic'ule' xyaloj y ma noka ta chanin, ri lajuj k'opoji' ri ye oyobeyon riche (rixin), xa xquichop c'a xeyuxcu'r y xewer ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Yac'a ri pa nic'aj ak'a' xac'axatej c'a jun ri nurek ruchi' y nubij c'a: Ya xpe ri c'ajol ri xtic'ule'. Can quixel c'a pe chuc'ulic. Quec'ari' nubij ri ntajin nurek pe ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y yac'ari' tek ri lajuj k'opoji' ri', ri ye oyobeyon riche (rixin) ri c'ajol ri xtic'ule', chanin c'a xeyacatej y xquibanala' ruchojmil ri quilámpara. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yec'a ri wu'o' k'opoji' ri man c'o ta quina'oj xquibij c'a chique ri wu'o' chic k'opoji' ri can c'o wi quina'oj: Re kak'ak' xa can xquechuptej ka ruma xa ma q'uiy ta chic aceite c'o chupan. Tiya' c'a juba' kaceite riyoj, xecha' c'a ri k'opoji' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Yec'a ri wu'o' chic k'opoji' ri can c'o wi quina'oj, xquibij c'a: Ri utz chi niben riyix wacami jix jilok'o' ri aceite quiq'ui ri yec'ayin, ruma wi riyoj nikaya' ri kaceite chiwe, ma xkojruben ta riyoj, y queri' chuka' riyix, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y tek ri ye wu'o' k'opoji' ri' c'ari' ye benak chulok'ic ri aceite, yac'ari' tek xoc'ulun ri c'ajol ri xtic'ule'. Ri wu'o' k'opoji' ri can yec'o wi apo chiri' coyoben ri c'ajol ri xtic'ule', xe'oc c'a pa jay acuchi (achique) niban wi ri c'ulanen. Y tek can ye oconek chic c'a apo quinojel ri ye benak, xtz'apix c'a ca ruchi' ri jay. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y c'ac'ari' tek xe'apon ri ye wu'o' chic k'opoji' ri xebe ca chulok'ic ri aceite riche (rixin) ri quilámpara, y riye' xech'o c'a apo chare ri rajaf ri jun c'ulanen ri' y xquibila' c'a: Tajaka' ri ruchi' jay chkawech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y riya' xubij c'a pe chique ri k'opoji' ri': ¿Yix achique c'a riyix? Riyin can kitzij ri nbij chiwe chi ma wetaman ta iwech, xe'uche'ex pe. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","C'ac'ari' ri Jesús xubij chique ri rudiscípulos: Riyix can ma quixmestan ta, can quiniwoyobej apo, ruma xa ma iwetaman ta achique k'ij, y achique hora tek riyin ri C'ajolaxel ri xinalex chicojol xquipe chic jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Rumac'ari' ri pa rajawaren ri caj xtibanatej c'a achi'el ri xuben jun achi tek xbe nej. Riya' xerusiq'uij (xeroyoj) c'a ri rumozos y xuya' c'a ca ri rubeyomal chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Chare c'a jun rumozo xuya' ca wu'o' puek ri nibix talento chare, y chare jun chic xuya' c'a ca ca'i', y chare ri jun chic xuya' c'a ca xa jun. Riya' xuya' c'a ca chique chiquijujunal xaxu (xaxe wi) ri puek ri yecowin yesamej riq'ui. Y ri achi ri' can xu (xe) wi xuben ca queri', xbe c'a el c'anej. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y ri mozo ri ya'on ca wu'o' talento chare riche (rixin) chi nisamej riq'ui, can xuben na wi ri bin ca chare. Riya' can xsamej wi c'a riq'ui ri wu'o' talento y xuch'ec chic c'a wu'o' riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y queri' chuka' xuben ri jun chic mozo ri ya'on ca ca'i' talento chare, riya' can xuch'ec chic c'a ca'i' talento riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Yac'a ri jun chic mozo ri xa jun oc talento ri ya'on ca chare ruma ri rupatrón, xa xberuc'oto' c'a jun jul pan ulef y chiri' xumuk wi ca ri puek ri ya'on ca chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Y tek k'axnek chic c'a q'uiy k'ij, c'ac'ari' xtzolin pe ri quipatrón ri mozos ri'. Y riya' xuc'utuj c'a chique achique xquiben riq'ui ri puek ri xuya' ca chique tek xbe. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tek xapon c'a ri mozo ri ya'on ca wu'o' talento chare, can ma xu (xe) ta wi ri' ri ruc'uan apo, xa can ruc'uan c'a apo wu'o' chic talento y xubij c'a chare ri rupatrón: Riyit wu'o' c'a talento ri xaya' ca chuwe. Yac'are' c'o, y ya chuka' re' c'o wu'o' talento ri xinch'ec riq'ui, xcha' ri mozo ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ri patrón ri' xubij c'a chare: Sibilaj utz ri xaben. Riyit can yit jun utzilaj numozo ri can naben wi ri nibix chawe. Y ruma c'a chi can utz xaben riq'ui ri juba' ri xinya' ca chawe tek xibe, wacami c'a yatinya' pa ruwi' jun samaj nim. Catam pe c'a y catoc chupan ri quicoten ri c'o wuq'ui, xuche'ex ri mozo. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Tek xapon chuka' ri mozo ri ya'on ca ca'i' talento chare, riya' xubij c'a chare ri rupatrón: Riyit ca'i' talento ri xaya' ca chuwe. Yac'are' c'o, y ya chuka' re' c'o ca'i' talento chic ri xinch'ec riq'ui, xcha' ri mozo ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Y ri patrón ri' xubij c'a chare: Sibilaj utz ri xaben. Riyit can yit jun utzilaj numozo ri can naben wi ri nibix chawe. Y ruma c'a chi can utz xaben riq'ui ri juba' ri xinya' ca chawe tek xibe, wacami c'a yatinya' pa ruwi' jun samaj nim. Catam pe c'a y catoc chupan ri quicoten ri c'o wuq'ui, xuche'ex chuka' ri mozo ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yac'a tek xapon chuka' ri mozo ri xa jun talento ri ya'on ca chare, riya' xubij c'a chare ri rupatrón: Riyin can wetaman wi c'a awech, y rumari' wetaman chi riyit yit jun c'a'nlaj (c'a'elaj) achi. Xa can nawajo' wi c'a yach'acon. Riyit nawajo' nac'ul ri ntel pe chuwech ri tico'n ri xa ma yit ta riyit xatico ka. Nawajo' nac'ol ruwech ri tico'n ri xa ma yit ta riyit xajopin ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y rumari' riyin xinpokonaj xisamej riq'ui ri jun talento ri xaya' ca chuwe. Riyin tek xinc'ul c'a el ri puek, xinc'ot jun jul pan ulef y chiri' xinmuk wi ca. Y ya c'a arajil re' nonjacha' ca chawe, xcha' ri mozo ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y ri rupatrón ri mozo ri' xubij c'a: Ma utz ta ri xaben. Ruma yit jun itzel mozo y ma naben ta ri nibix chawe. Ruma wi can awetaman chi riyin yin jun c'a'nlaj (c'a'elaj) achi y chi riyin nwajo' nc'ul ri ntel pe chuwech ri tico'n ri xa ma yin ta xitico ka y nwajo' nc'ol ruwech ri tico'n ri xa ma yin ta xijopin ka, ");
INSERT INTO cakWNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ri más ta utz chi xaben, xaya' ta re nurajil pa banco, y re xinoka wacami xinc'ul ta c'a ri puek ri can wuche (wixin) wi riyin y xinc'ul ta chuka' ri ral re nurajil. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wacami tiwelesaj c'a ca ri talento chare y tiya' chare ri numozo ri c'o ri lajuj talento riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ruma ri can c'o q'uiy riq'ui, xtiya'ox (xtya') c'a más chare y q'uiy c'a ri xtic'oje' riq'ui. Yac'a ri xa juba' oc c'o riq'ui hasta ri juba' ri' xa xtelesex chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri mozo ri xa majun nic'atzin wi, tiwelesaj el y jibe'ic'aka' ca chupan ri nimalaj k'eku'm, ri acuchi (achique) xtok' wi y xtukach'ach'ej rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y tek ri C'ajolaxel ri xalex chicojol xtipe chic, can riq'ui chic c'a ruk'ij ruc'ojlen; y chuka' can quinojel ri lok'olaj tak ángeles xquepe riq'ui. Y yac'ari' tek xtitz'uye' pa ruch'acat ri can c'o chuka' rejkalen y xtuk'et c'a tzij. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Can xquemol wi c'a pe chuwech quinojel ri winek riche (rixin) re ruwach'ulef. Y Riya' can xquerujech c'a, achi'el nuben jun aj yuk' tek juc'an yeruya' wi ri tak carne'l, y juc'an chic yeruya' wi ri tak q'uisic' (cabras). ");
INSERT INTO cakWNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri winek c'a ri achi'el tak carne'l, ruma ch'ajch'oj chic quic'aslen, xqueruya' c'a pa rajquik'a'. Yac'a ri winek ri achi'el tak q'uisic' (cabras), ruma ma utz ta ri quic'aslen, xqueruya' pa rajxocon. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y yac'ari' tek ri Rey xtubij chique ri yec'o pa rajquik'a': Quixam pe riyix ri ic'ulun chic ri rutzil ri Nata' Dios. Quixc'oje' c'a pa rajawaren ri Dios, ri can iwuche (iwixin) wi riyix tek xuchojmirisaj. Y ri' ruchojmirisan chic tek c'a ma jane c'o ta re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ruma tek riyin xiwayjan, riyix xiya' c'a nuway. Tek riyin xchaki'j c'a nuchi', riyix xiya' nuya' riche (rixin) chi xinkum. Tek Riyin xinapon pan itinamit, riyix xinic'ul pa tak iwachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tek xitz'et chi can ti lawalo' chic ri nutziak chuwij, riyix xiya' nutziak. Tek riyin xiyawej, xixapon chinutz'etic. Tek riyin xitz'ape' pa cárcel, xixapon chuka' chinutz'etic, xticha' ri Rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yac'ari' tek ri winek choj quic'aslen xtiquibij c'a: Ajaf, ¿ajan (jampe') c'a ri' tek riyit c'o wayjal chawe y riyoj xkaya' away? ¿Ajan (jampe') c'a ri' tek riyoj xkaya' aya' riche (rixin) chi xakum tek xchaki'j achi'? ");
INSERT INTO cakWNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y ajan (jampe') c'a ri' tek xatapon pa katinamit y xatkac'ul pa tak kachoch? ¿Ajan (jampe') c'a ri' tek riyoj xkaya' atziak ruma xa can ti lawalo' chic atziak? ");
INSERT INTO cakWNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ajan (jampe') c'a ri' tek xojapon chatz'etic ruma yit yawa'? ¿Y ajan (jampe') c'a chuka' ri' tek xojapon chatz'etic ruma yitc'o pa cárcel? xquecha' riye'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey xtubij c'a: Can kitzij wi c'a ri nbij chiwe chi ronojel ri utzil ri xiben chare jun wach'alal ri majun oc ruk'ij, ntel chi tzij chi can chuwe c'a riyin xiben wi ri utzil ri', xticha' ri Rey. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y yac'a chuka' ri' tek ri Rey xtubij chique ri yec'o pa rajxocon: Riyix ri xa can c'o chic chi nika ri ruc'ayewal pan iwi', quixel c'a el chinuwech. Wacami xa xquixbe pa k'ak' ri majun bey xtichuptej ta riche (rixin) xtibe k'ij xtibe sek, ri xa riche (rixin) wi ri itzel winek y quiche (quixin) ri ye ru'ángeles tek banon. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ruma riyin can xiwayjan c'a y riyix ma xiya' ta nuway. Sibilaj c'a xchaki'j nuchi' y riyix xa ma xiya' ta juba' nuya' riche (rixin) chi xinkum. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Y tek riyin xinapon pan itinamit, riyix ma xinic'ul ta pa tak iwachoch. Tek lawalo' chic nutziak chuwij, riyix ma xiya' ta nutziak. Tek xiyawej, riyix ma xixapon ta chinutz'etic. Y tek xic'oje' pa cárcel, ma xixapon ta chuka' chinutz'etic, xticha' ri Rey chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y yac'ari' tek riye' chuka' xtiquibij: Ajaf, riyoj majun bey xatkatz'et ta chi natij ta wayjal, nichaki'j ta achi', chuka' majun bey xatkatz'et ta pa katinamit chi nic'atzin aposada, o chi man ta jun atziak, yit yawa' ta, yitc'o ta pa cárcel. Riyoj majun bey xatkatz'et ta chi que ta ri' ac'ulwachin, rumari' can majun wi c'a utzil xkaben chawe, xquecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y yac'ari' tek ri Rey xtubij chique: Can kitzij wi c'a ri nbij chiwe chi ruma majun utzil xiben chique re tak wach'alal ri majun oc quik'ij, ntel chi tzij chi xa can majun c'a chuka' utzil xiben ta chuwe riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y ri winek ri ma xebano ta ri utzil ri', can xquebe wi c'a pa tijoj pokonal riche (rixin) xtibe k'ij xtibe sek. Y ri chojmilaj tak winek xtiquil c'a jun c'aslen riche (rixin) xtibe k'ij xtibe sek. Quec'ari' ri ch'abel ri xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Tek ri Jesús rubin chic c'a ka ronojel ri', Riya' xch'o c'a quiq'ui ri rudiscípulos y xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Riyix can iwetaman wi chi pa ca'i' k'ij nichapatej ri nimak'ij pascua. Chupan c'a ri nimak'ij ri' tek riyin ri C'ajolaxel ri xinalex chicojol can xquijach wi el riche (rixin) chi yibajix chuwech cruz riche (rixin) chi xquicamisex, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y can ya c'a chuka' hora ri' tek ri principali' tak sacerdotes, ri aj tz'iba' y chuka' ri rijita'k tak achi'a' ri c'o quik'ij chiquicojol ri winek, can quimolon c'a qui' chuwarachoch ri nimalaj sacerdote ri Caifás rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Riye' xquiya' c'a chiquiwech achique chi k'oloj ri xtiquicusaj riche (rixin) chi nika ri Jesús pa quik'a', y c'ac'ari' niquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Y chuka' can xquibij c'a: Ma tikachop ta chupan re nimak'ij re', riche (rixin) chi ma yeyacatej ta pe ri winek chikij. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y ri Jesús c'o c'a ri pa tinamit Betania, chiri' pa rachoch ri Simón ri xc'achojsex chare ri itzel yabil ri lepra rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y yac'ari' tek xoc apo jun ixok riq'ui ri Jesús, ruc'uan apo jun c'ojlibel (frasco) ri banon riq'ui jun abej alabastro rubi', y c'o el jun ak'om ri jubul ruxla' chupan; ak'om ri sibilaj jotol rajel. Y yari' ri xberuk'eja' pa rujolon (ruwi') ri Jesús, tek tz'uyul apo chiri' pa mesa, niwa' pa rachoch ri Simón. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Tek ri discípulos xquitz'et ri xuben ri ixok riq'ui ri ak'om ri jubul ruxla' chi xuk'ej pa rujolon (ruwi') ri Jesús, xpe coyowal y xquibila' c'a: ¿Achique c'a ruma tek la ixok la' chi chak queri' xutix la ak'om la'? ");
INSERT INTO cakWNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ruma la ak'om la' jotol rajel, y rumari' xa más ta utz chi xc'ayix, y ri rajel xa xya'ox (xya') ta chique ri pobres, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ri Jesús chanin xk'ax chuwech ri niquibila' ri rudiscípulos, rumari' Riya' xubij c'a chique: ¿Achique c'a ruma tek riyix ma yixtane' ta ka chi tzij chrij re ixok re'? Xa tiya' ca, ma tinek ta. Riya' can jun utzilaj samaj c'a ri xuben wuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri pobres xa can yec'o wi iwuq'ui, y xabachique k'ij utz niben utzil chique. Yac'a riyin ma ronojel ta tiempo xquic'oje' iwuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ruma tek re ixok re' xuk'ej chuwij re jun ak'om jubul ruxla', riya' xa can xuben yan apo nuchojmil riche (rixin) chi xquibemuk ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Y kitzij nbij chiwe, chi xabacuchi (xabachique) c'a ri xtitzijox wi ri lok'olaj ch'abel ri niya'o colotajic, chiri' chuka' xtitzijox wi re xuben re jun ixok re'. Can pa ronojel c'a ruwach'ulef xtitzijox wi, chi natabel riche (rixin) riya', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Y jun c'a chique ri ye cablajuj rudiscípulos ri Jesús, ri Judas Iscariote rubi', xapon c'a quiq'ui ri principali' tak sacerdotes. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Riya' xberubij c'a chique: ¿Achique niya' chuwe riyix, wi riyin njech ri Jesús pan ik'a'? xcha' chique. Y ri principali' tak sacerdotes xquibij chi niquiya' juwinek lajuj sakapuek chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y yac'ari' tek ri Judas Iscariote xuchop ruch'obic chi achique ta rubanic nuben chi xtujech ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Y chupan c'a ri nabey k'ij chare ri nimak'ij, tek ri israelitas niquitij ri caxlan wey ri majun ch'om (levadura) riq'ui, yac'ari' tek ri discípulos xejel apo riq'ui ri Jesús, y xquic'utuj c'a chare: ¿Acuchi (achique) c'a nawajo' naben wi ri wa'in chupan re jun pascua re', riche (rixin) chi nbekabana' c'a ruchojmil ronojel ri nic'atzin? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y yec'o c'a chique ri discípulos ri xetak el ruma ri Jesús c'a pa tinamit Jerusalem, pa rachoch jun achi, y xbix el chique chi tek xque'apon, tiquibij c'a chare: Ri Katijonel rubin c'a pe: Ri nutiempo xa nakaj chic c'a c'o wi pe. Ya c'a ri pan awachoch riyit nwajo' nben wi ri wa'in riche (rixin) re pascua re', ye wachibilan ri nudiscípulos, quixcha' chare, xcha' ri Jesús chique ri discípulos ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri discípulos can xquiben wi c'a achi'el ri bin el chique ruma ri Jesús. Riye' can xquiben wi c'a ruchojmil ronojel ri nic'atzin chare ri wa'in chupan ri pascua ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yac'a tek xoc pe ri ak'a' chupan ri k'ij ri', ri Jesús y ri ye cablajuj rudiscípulos xebetz'uye' c'a pa mesa riche (rixin) ri wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y tek yetajin chic c'a chi wa'in, ri Jesús xubij c'a: Kas kitzij c'a nbij chiwe, chi jun chiwe riyix ri xquijacho el pa quik'a' ri winek, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yac'ari' tek ri discípulos xpe nimalaj bis pa cánima tek xquic'axaj ri xubij ri Jesús chique. Y c'ac'ari' chiquijujunal xech'o apo chare y xquic'utula' c'a: Ajaf, ¿la ma yin ta cami riyin ri xquibano queri'? xecha' c'a chiquijujunal. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús yac'ari' tek xubij chique ri rudiscípulos: Ri jun c'a ri xtuya' pe ri ruk'a' riche (rixin) chi xtumu' pe ri caxlan wey wuq'ui pa lek, yac'ari' ri xtijacho el wuche (wixin) pa quik'a' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tiwac'axaj c'a chuka' ri xtinbij chiwe, chi riyin ri C'ajolaxel ri xinalex chicojol can xquicamisex na wi, achi'el ri tz'ibatal ca. Pero juyi' c'a ruwech ri xquijacho el riyin ri C'ajolaxel ri xinalex chicojol. Ri achi ri xquijacho el utz ta chi man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y yac'ari' tek ri Judas, ri xtijacho riche (rixin) ri Jesús pa quik'a' ri winek, xubij apo: Riyit Nutijonel, ¿la yin cami riyin ri xquijacho el awuche (awixin)? xcha'. Y ri Jesús xubij: Ja' (je), queri', can achi'el ri xabij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y tek c'a yetajin na c'a chi wa'in, ri Jesús xuc'om c'a apo jun caxlan wey y tek ruc'utun chic ri rubendición ri Dios pa ruwi', xuwech'ela' ri caxlan wey ri' y xuya' chique ri rudiscípulos, y xubij c'a chique: Tic'ama' y titija' re caxlan wey re'. Ruma yac'are' ri nuch'acul. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y ri Jesús xuc'om c'a chuka' apo ri vaso ri c'o ruya'al uva chupan; y tek rumatioxin chic chare ri Dios, xuya' c'a chique ri rudiscípulos. Y xubij c'a chique: Tikumu' c'a chi'iwonojel ri ruya'al uva ri c'o chupan re vaso re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ruma yac'are' ri nuquiq'uel ri xtibiyin tek xquicamisex. Riq'ui c'a ri xtibiyin ri nuquiq'uel, can yac'ari' tek xtic'achoj ri c'ac'ac' trato ri rajowan pe ri Dios chi nuben quiq'ui ri winek, riche (rixin) chi ye q'uiy winek c'a ri nicuyutej ri quimac. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Can nbij c'a chiwe chi yac'are' ri ruq'uisbel mul ri xinkum el re ruya'al uva. Y tek xtinkum chic jun bey, c'a chupan chic ri rajawaren ri Nata'. Xtinkum riyin y riyix chuka' xtikum ri ruya'al uva ri'. Y ri xtikakum c'a chiri', jun c'ac'ac' ruya'al uva, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y tek quibixan chic c'a ri bix riche (rixin) ri pascua, ri Jesús y ri rudiscípulos xe'el el chiri' pa jay y xebe ri pa juyu' ri Olivos rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y tek ye benak c'a, ri Jesús xubij chique ri rudiscípulos: Chi'iwonojel riyix xtitaluj el iwi' y xquiniya' c'a ca nuyon chupan re ak'a' re', tek xa xtitz'et chi riyin yijach el pa quik'a' ri winek. Ruma ri Dios can nubij wi c'a chupan ri tz'ibatal ca: Tek riyin xtinya' k'ij chi nicamisex ri aj yuk', ri rucarne'l xa xtiquitaluj el qui'. Queri' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Yin c'a riyin ri Aj Yuk', pero man c'a xquicom ta el jurayil, xa xquic'astej chic pe. Y riyin xquixinwoyobej chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y ri Pedro can yac'ari' tek xubij apo chare ri Jesús: Astape' can quinojel xcatquiya' ca ayon, yac'a riyin ma xcatinya' ta ca, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yac'a ri Jesús xubij c'a chare ri Pedro: Riyin can kitzij c'a nbij chawe, chi wacami chupan re ak'a' re', c'a ma jane tisiq'uin ta pe ri ec', tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xubij chic c'a chare: Wi can rajawaxic chi yicom junan awuq'ui riyit, can quec'ari' ri', pero can ma xtinbij ta chi ma wetaman ta awech, xcha' ri Pedro. Y quinojel c'a ri discípulos can queri' chuka' xquibij. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Y yac'ari' tek ri Jesús ye rachibilan ri rudiscípulos xe'apon c'a chiri' chupan ri lugar ri Getsemaní rubi'. Xpe ri Jesús xubij c'a chique ri rudiscípulos: Riyix quixtz'uye' na c'a ca juba' wawe', riyin xa yibe na apo juba' quere' nbenbana' orar, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Riya' xa quiyon c'a ri Pedro y ri ye ca'i' ruc'ajol ri achi Zebedeo rubi' ri xeruc'uaj el. Yac'ari' tek Riya' can xuna' yan k'axon ruma ri xtiberuc'ulwachij. Can jun nimalaj bis c'a ri xpe pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Y yac'ari' tek Riya' xubij chique ri ye oxi' rudiscípulos: Sibilaj nim ri bis c'o pa wánima, ya yirucamisaj nna' riyin. Quixc'oje' c'a ca juba' wawe', quixc'ase' y ma quixwer ta ka, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Riya' xbiyin chic c'a apo juba' y c'ac'ari' xxuque' ka. Xujupuba' c'a ka ri rupalej c'a pan ulef, y xuben c'a orar. Y quec'are' ri ch'abel ri xerubij: Nata' Dios, xa ta c'o modo, tabana' c'a chi man ta nk'axaj re jun tijoj pokonal re', pero ma taben ta c'a achi'el ri nuraybel riyin. Tabana' ri araybel riyit, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y tek Riya' xbeyacatej pe chare ri oración, xpe c'a quiq'ui ri ye oxi' rudiscípulos, yac'a tek xoka quiq'ui, xa ye warnek. Xpe Riya' xubij c'a chare ri Pedro: ¿Can ma juba' c'a xacowin ta xac'ase' jun ti hora wuq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Man c'a quixwer ta ka, xa tibana' orar y tic'utuj chare ri Dios riche (rixin) chi ma yixtzak ta pa mac tek yixtojtobex. Can wetaman wi chi ri iwánima can nrajo' wi nuben ri nrajo' ri Dios. Xa yac'a ri ich'acul xa majun ruchuk'a', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y ri Jesús xbe chic c'a apo chubanic orar pa rucamul y nubij c'a: Nata' Dios, wi can c'o c'a chi nk'axaj na ri tijoj pokonal, riyin can nwajo' c'a nben ri araybel riyit. Quec'ari' ri xubij pa ru'oración. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y tek Riya' xpe chic c'a jun bey quiq'ui ri ye oxi' rudiscípulos, xa ye warnek chic c'a jun bey xeril, ruma ri discípulos ri' sibilaj al rubanon ri runak' tak quiwech ruma ri quiwaran. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ri Jesús xeruya' chic c'a ca jun bey y xbe chic chubanic orar pa rox mul. Riya' xerubij chic c'a ri achi'el ri ch'abel ri xerubij chupan ri oración ri xa c'a juba' tuben ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yac'ari' tek ri Jesús xpe c'a quiq'ui ri ye oxi' rudiscípulos, y xubij c'a chique: ¿Can c'a yixwer na? Wacami can quixwer c'a y quixuxlan. Riyin ri C'ajolaxel ri xinalex chicojol can ya wi c'a re' xoka ri hora, chi xquijach c'a el pa quik'a' ri aj maqui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chanin, quixyacatej. Yala' petenak ri xquijacho el pa quik'a' ri aj maqui', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y ri Jesús can c'a nich'o na c'a quiq'ui ri rudiscípulos, tek yari' xoka ri Judas ri jun chique ri cablajuj rudiscípulos, y ye ruc'uan c'a apo ye q'uiy winek ri ye quic'ualon che' y espada. Quinojel ri' ye takon c'a el cuma ri principali' tak sacerdotes y cuma chuka' ri rijita'k tak achi'a' ri c'o quik'ij chiquicojol ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri nijacho el ri Jesús can rubin c'a pe chique ri ye petenak riq'ui, chi achique rubanic xtuben riche (rixin) chi xtuc'ut ri Jesús chiquiwech. Riya' can rubin c'a pe chique: Ya c'a ri xquijel apo riq'ui y xtintz'umaj (xtintz'ubaj) ruchi', yari' ri Jesús, y tichapa' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y ri Judas can yac'ari' tek xjel apo riq'ui ri Jesús y xubij: Xoc ak'a' Nutijonel, xcha' chare. Y xutz'umaj (xutz'ubaj) c'a ruchi' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpe ri Jesús xubij c'a chare: Judas, ¿Achique c'a ri nawajo'? xcha' chare. Y can yac'ari' tek ri winek ri ye benak riq'ui ri Judas xejel apo riq'ui ri Jesús y xquichop c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun c'a chique ri yec'o riq'ui ri Jesús, can yac'ari' chanin xbe ri ruk'a', xrelesaj ri ru'espada y xusoc ri jun rumozo ri nimalaj sacerdote. Can xuchoy c'a ri ruxquin. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús yac'ari' tek xubij chare ri xbano queri': Tayaca' la awespada pa ruc'ojlibel. Ruma achique yecamisan chi espada, can chi espada c'a chuka' yecamisex wi. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿La ma awetaman ta c'a chi riyin yicowin nc'utuj chare ri Nata' chi yerutek ta pe más ye setenta y dos mil ángeles chinuto'ic? ");
INSERT INTO cakWNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero can nic'atzin chi nibanatej na ri ye tz'ibatal ca chupan ri ruch'abel ri Dios, rumari' tek ma rajawaxic ta c'a chi yepe ri ángeles chinuto'ic, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chupan c'a chuka' ri hora ri' ri Jesús xubij chique ri winek: ¿Achique c'a xich'ob riyix? ¿Xich'ob chi yix petenak chuchapic jun alek'om y rumari' ic'amom pe che' y espada? Can k'ij k'ij c'a ri xitz'uye' iwuq'ui chiri' pa rachoch ri Dios, tek xinc'ut ri ruch'abel chiwech y majun bey xinichop ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ronojel c'a re nibanatej wacami, xa can riche (rixin) chi can nibanatej wi ri tz'ibatal ca chupan ri ruch'abel ri Dios cuma ri profetas ri xek'alajsan ri ruch'abel ojer ca. Y can yac'ari' tek ri ye rudiscípulos ri Jesús, xquiya' ca ruyon y xe'anmej el. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xebechapo pe riche (rixin) ri Jesús chiri' pa Getsemaní, xquic'uaj c'a riq'ui ri Caifás ri nimalaj sacerdote, ri acuchi (achique) quimolon wi ca qui' ri aj tz'iba' y ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y ri Pedro c'anej c'a c'o wi ca, ye rutzekelben el, y xoc chuka' apo ri chiri' chuwarachoch ri nimalaj sacerdote. Tek riya' c'o chic c'a chiri', xtz'uye' c'a ka chiquicojol ri ye aj ch'ame'y ri yec'o apo chiri', riche (rixin) chi nutz'et na achique ri xtuc'ulwachij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y ri principali' tak sacerdotes, ri rijita'k tak achi'a' ri c'o quik'ij, y quinojel c'a ri achi'a' ri can pa moc (comon) yek'ato tzij, niquicanola' c'a k'aban tak tzij chrij ri Jesús, riche (rixin) chi niquitek pa camic. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y astape' can ye q'uiy c'a ri xe'apon ri xquitz'uc tzij chrij ri Jesús, pero xa ma junan ta ri xquibij. Pa ruq'uisbel xe'apon ye ca'i' ri junan wi ri xquibij, xa yac'a ri ma kitzij ta chuka' ri xquibij. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ri ye ca'i' ri' xquibij c'a: Re achi re' rubin: Riyin yicowin nwulaj ri rachoch ri Dios y pan oxi' k'ij npaba' chic jun bey. Queri' rubin, xecha' ri ye ca'i' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y ri Caifás, ri nimalaj sacerdote, xbepa'e' c'a pe y xubij chare ri Jesús: ¿Kitzij cami ri xquibij ka chawij re ye ca'i' re'? ¿Achique c'a nabij riyit chi natobej awi'? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yac'a ri Jesús ma xch'o ta, y yac'ari' tek ri nimalaj sacerdote xubij chare: Can chuwech c'a ri c'aslic Dios tabij c'a chake wi yit c'a riyit ri Cristo ri Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y ri Jesús xubij c'a chare: Kitzij ri xabij, y chuka' can nbij wi c'a chiwe chi can xu (xe wi) xtink'axaj re jun tijoj pokonal re', can yac'ari' tek xquinitz'et riyin ri C'ajolaxel ri xinalex chicojol, yin tz'uyul pa rajquik'a' ri Dios ri nicowin nuben ronojel. Y xquinitz'et tek yipe pa sutz' ri chila' chicaj, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Yac'ari' tek ri Caifás ri nimalaj sacerdote xuretz (xutzer) ka ri rutziak chrij ruma itzel xrac'axaj y xubij c'a: Ma rajawaxic ta c'a chi noka chic jun ri norubij chake chi re achi re' can aj mac wi. Riyix, xa c'ari' niwac'axaj ka chi'iwonojel ri xubij chi ya Riya' ri Cristo. Can itzel c'a xuben chuwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Y achique c'a nibij riyix wacami chi nikaben chare? xcha'. Y ri nic'aj chic ri quimolon qui' chiri' xquibij c'a: Ruc'amon c'a chi nicamisex, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubala' c'a rupalej ri Jesús, y xquibuc'la' chi k'a' y yec'o chuka' xquipak'ila' rupalej chi k'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Chuka' xquibila' chare ri Jesús tek quitz'apin ruwech: Riyit ri Cristo, tabij na c'a chake achique ri yech'ayo awuche (awixin), xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yac'a tek ntajin ronojel ri', ri Pedro tz'uyul c'a ri chuwajay. Y yac'ari' tek c'o jun ixok raj ic' ri nimalaj sacerdote ri xjel apo riq'ui y xubij c'a chare: Riyit chuka' yit rachibil ri Jesús ri aj Galilea, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Yac'a riya' xa xrewaj chiquiwech quinojel, ruma xubij: Ma wetaman ta achique ri nabij chuwe, xcha' chare ri aj ic'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y tek riya' ntel c'a el ri pa puerta, c'o chic c'a jun ixok aj ic' ri xtz'eto riche (rixin) y xubij c'a chique ri yec'o apo chiri': Re jun achi re' can rachibil chuka' ri Jesús ri nipe pa tinamit Nazaret, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Yac'a ri Pedro xa xrewaj chic c'a jun bey. Riya' xubij: Chuwech ri Dios nbij wi chi riyin ma wetaman ta ruwech ri jun achi ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Xa c'a juba' chic ri', tek ye chic c'a ri quimolon qui' chiri' ri xejel apo riq'ui ri Pedro y xquibij c'a chare: Can kitzij na wi chi riyit can yit jun chique ri yec'o riq'ui ri Jesús. Can k'alaj rubanic ri yach'o, ruma ri aj Galilea queri' yech'o, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yac'a ri Pedro xubij c'a: Riyin ma wetaman ta ruwech ri achi ri'. Can chuwech Dios nbij chiwe chi ma wetaman ta ruwech. Y wi ma kitzij ta ri nbij, tika c'a ruc'ayewal pa nuwi', xcha'. Y yac'ari' tek xbesiq'uin pe ri ec'. ");
INSERT INTO cakWNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y ri Pedro can yac'ari' tek xenatej chare ri ch'abel ri bin ca chare ruma ri Jesús, chi c'a ma jane tisiq'uin ta pe ri ec' tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech. Y riya' xel c'a el y xuchop jun nimalaj ok'ej. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y tek xseker pe, quinojel c'a ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij chiri' chiquicojol ri winek, xquimol qui' riche (rixin) chi niquich'ob achique niquiben riche (rixin) chi niquitek ri Jesús pa camic. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ri Jesús can ximon wi el tek xquic'uaj y xbequijacha' pa ruk'a' ri aj k'atbel tzij ri Poncio Pilato rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yac'a ri Judas ri xjacho riche (rixin) ri Jesús pa quik'a' ri winek, tek xutz'et chi ri Jesús xa nitak pa camic, yac'ari' tek riya' xpe k'axon pa ránima y xberutzolij ca ri juwinek lajuj sakapuek chique ri principali' tak sacerdotes y chique ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xubij c'a chique ri achi'a' ri': Riyin can ximacun wi ruma xinjech ri Jesús pan ik'a', ruma Riya' can majun mac rubanon riche (rixin) chi nicamisex, xcha' chique. Yac'a ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij, xa xquibij c'a pe chare ri Judas: Riyoj majun kacuenta chare ri'. Ri' chawech riyit c'o wi, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpe c'a ri Judas xurokij ca ri sakapuek chiri' pa rachoch ri Dios. C'ac'ari' xel el, y xberujitz'aj c'a ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y ri principali' tak sacerdotes xquic'ol c'a ri sakapuek ri' y xquibij c'a: Re puek re' ma utz ta c'a chi nikaxol ka riq'ui ri ofrenda wawe' pa rachoch ri Dios, ruma re puek re' xa rajel quic'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Yac'a tek quiya'on chic c'a chiquiwech ri achique niquiben riq'ui ri puek ri', riye' xquilok' c'a ri rulef jun aj banoy bojo'y. Ri ulef ri' can xtic'atzin c'a riche (rixin) chi chiri' yemuk wi ri winek ri ma ye aj chiri' ta. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Y rumari' tek ri jun ulef ri' can c'a nibix na c'a Ulef riche (rixin) Quic' chare. Can man c'a jalatajnek ta ri rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Riq'ui c'a ri' can xbanatej wi ri rubin ca ri profeta Jeremías ri xk'alajsan ri ruch'abel ri Dios ojer ca. Riya' can rubin wi c'a ca: Ri ye riy rumam ca ri achi ri Israel rubi', xquic'om c'a el ri juwinek lajuj sakapuek, puek ri xquiya' riye', ri xoc rajel ri rusamajel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y ya puek ri' ri xquilok'bej ri ulef riche (rixin) ri aj banoy bojo'y, can achi'el ri xubij ri Ajaf chuwe. Queri' c'a ri rubin ca ri Jeremías. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y ri Jesús pa'el c'a apo chuwech ri aj k'atbel tzij ri Poncio Pilato. Y ri aj k'atbel tzij ri' xuc'utuj c'a chare ri Jesús: ¿Yit c'a riyit ri qui-Rey ri israelitas? xcha' chare. Y ri Jesús xubij c'a: Ja' (je), queri'. Can achi'el ri xabij, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij q'uiy c'a ri niquibij riche (rixin) chi yetzujun (yesujun) apo chrij ri Jesús, pero Riya' can majun c'a ch'abel ri xubij riche (rixin) chi nuto' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ri Pilato can yac'ari' tek xubij chare ri Jesús: ¿Can ma nawac'axaj ta c'a ri niquibij ri winek chawij riche (rixin) chi yatquitzujuj (yatquisujuj)? ");
INSERT INTO cakWNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús can majun c'a ch'abel ri xubij ta chare ri Pilato. Y rumari' tek ri aj k'atbel tzij ri' xumey, ruma majun bey rutz'eton ta chi c'o ta jun winek ri que ta ri' nuben. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y ronojel juna' chupan ri nimak'ij pascua, ri aj k'atbel tzij can nrelesaj c'a el jun chique ri yec'o pa cárcel. Riya' nrelesaj c'a el ri preso ri nicajo' ri winek chi ntel el. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan c'a ri k'ij ri', c'o c'a jun achi tz'apel pa cárcel ri Barrabás rubi', jun achi ri can c'o rutzijol chi sibilaj itzel. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y ri Pilato xubij c'a chique ri winek ri quimolon c'a qui' chiri': ¿Achique c'a ri niwajo' riyix chi riyin nwelesaj el? ¿Niwajo' chi nwelesaj el ri Barrabás o ya ri Jesús ri nibix chuka' Cristo chare? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato can que wi c'a ri' ri xubij pe, ruma riya' can retaman wi chi ri winek ri' quiya'on ri Jesús pa ruk'a', ruma itzel niquina' chare chi sibilaj ye q'uiy ri yetzekelben riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y ri Pilato tz'uyul c'a ri acuchi (achique) nuk'et wi tzij, tek xapon c'a rutzijol riq'ui ri rubin el ri rixjayil. Ri rixjayil rutakon c'a el rubixic chare: Ri Jesús jun achi choj, rumari' riyit, ma catoc ta cachibil ri ye'ajowan niquicamisaj. Ruma riyin xinben jun achic' ri sibilaj ruc'ayewal ruma ri Jesús. Quec'ari' ri rutakon el rubixic ri rixjayil ri Pilato. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Yac'a ri principali' tak sacerdotes y ri rijita'k tak achi'a' ri c'o quik'ij, xquiya' c'a quina'oj ri winek riche (rixin) chi tiquic'utuj chi ya ri Barrabás ri trelesaj el y ri Jesús ticamisex. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y yac'a tek ri aj k'atbel tzij xuc'utuj chic jun bey chique ri winek ri' chi achique c'a chique chi ye ca'i' ri nrelesaj el, ri winek ri' can yac'ari' xquibij: Ya ri Barrabás tawelesaj el, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yac'ari' tek ri Pilato xuc'utuj c'a chique ri winek: ¿Y achique c'a ri niwajo' chi nben chare ri Jesús, ri nibix chuka' Cristo chare? xcha' chique. Can yac'ari' tek quinojel xech'o apo y xquibij: Ri Jesús xa ticamisex chuwech cruz, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Xpe c'a ri aj k'atbel tzij xubij chique ri winek: ¿Achique c'a rumac rubanon chiwech? Pero riye' xa ma yetane' ta ka. Xa más xquirek apo quichi' y xquibij: Xa ticamisex chuwech cruz, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y tek ri Pilato xutz'et chi xa majun chic c'a ri nicowin ta nuben y ri winek xa sibilaj pa quichi' niquiben, xpe riya' xberuc'ama' pe juba' ruya' y xuch'ej ruk'a' chiquiwech quinojel ri winek ri', y xubij: Riyin majun numac chare ri rucamic re jun chojmilaj achi re'. Kas yix wi c'a riyix achique niben chare, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Xepe c'a quinojel ri winek xquibij c'a: Xa can pa kawi' c'a riyoj y pa quiwi' ri kalc'ual tika wi rutojbalil ri rucamic re jun achi re', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Yac'ari' tek ri aj k'atbel tzij xrelesaj c'a el ri Barrabás, yac'a ri Jesús xa xutek ruch'ayic, y c'ac'ari' xujech el riche (rixin) chi ticamisex chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y ri soldados riche (rixin) ri aj k'atbel tzij ri' xquic'uaj c'a apo ri Jesús chupan ri palacio. C'ac'ari' xequisiq'uij (xecoyoj) c'a quinojel ri nic'aj chic soldados, ri ye cachibil. Y xbequimolo' qui' chrij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xepe ri soldados ri' xquelesaj c'a el nic'aj rutziak ri Jesús, c'ac'ari' xquiya' jun tziek quek chrij can achi'el wi ri yequicusala' ri reyes. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Riye' xquipach'uj chuka' jun k'ayis ri c'o sibilaj ruq'uixal. Can achi'el jun corona xquiben chare, y c'ac'ari' xquiya' pa rujolon (ruwi') ri Jesús. Y xquiben chuka' chare ri Jesús chi xuchop jun aj riq'ui ri rajquik'a'. Y c'ac'ari' yetze'en c'a tek yexuque' chuwech ri Jesús y niquibila' c'a: Caquicot c'a, riyit ri qui-Rey ri israelitas, yecha' c'a chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Can niquichubala' c'a chuka' ri Jesús y niquelesala' ri aj c'o pa rajquik'a' riche (rixin) chi niquik'osij pa rujolon (ruwi'). ");
INSERT INTO cakWNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y tek riye' xetane' c'a chi yetze'en chrij, xquelesaj el ri tziek ri quiya'on chrij. C'ac'ari' xquiya' el ri can rutziak wi Riya', y xquic'uaj c'a el riche (rixin) chi nbequibajij chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y yac'a tek quichapon el elen chupan ri tinamit, xquic'ul jun achi aj Cirene, ri Simón rubi'. Xepe c'a ri soldados can xquiben c'a chare ri achi ri' chi xuc'uaj el ri rucruz ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y xe'apon c'a chupan ri jun juyu' Gólgota rubi'. Gólgota ntel chi tzij rubakil rujolon (ruwi') caminek. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tek can yec'o chic c'a chiri', xquiya' c'a chare ri Jesús jun ch'omilaj ruya'al uva xolon riq'ui jun c'ayilaj ak'om. Yac'a tek Riya' xuna' ri xquiya' chare, ma xrajo' ta xukum. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y tek ri soldados quibajin chic ri Jesús chuwech cruz, xesaquin c'a chrij ri rutziak ri Jesús riche (rixin) chi xquijech chiquiwech. Y riq'ui ri' can xbanatej c'a ri bin ca ruma ri jun profeta ri xk'alajsan ri ruch'abel ri Dios ojer ca, tek xubij: Xequijech ri nutziak chiquiwech y chuka' xesaquin chrij. Queri' ri rutz'iban ca. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ri soldados ye tz'uyul c'a chiri' quichajin apo ri Jesús tek c'o chuwech ri cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y pa ruwi' c'a ri cruz, riye' xquiya' c'a jun tz'alan ri tz'iban el chuwech ri achique mac ri niquibij riye' chi xuben ri Jesús, y rumari' nicamisex. Chuwech ri tz'alan ri' nubij c'a: YARE' RI JESÚS RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Y yac'ari' tek yec'o chic ye ca'i' alek'oma' ri xequibajij chuka' chuwech cruz. Jun xc'oje' pa rajquik'a' ri Jesús y ri jun chic pa rajxocon. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri winek c'a ri yek'ax el riq'ui ri Jesús, niquisiloj apo quijolon (quiwi') chuwech, y c'o chuka' pokon tak ch'abel ri yequibila' ca chare, ruma can ma niquinimaj ta chi ya Riya' ri Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ri winek ri' niquibila' c'a ca chare ri Jesús: Riyit ri yabin chi nawulaj ri rachoch ri Dios y pan oxi' k'ij napaba' chic jun bey, tacolo' c'a awi' ayon. Y wi yit c'a riyit ri Ruc'ajol ri Dios, caka pe chuwech la cruz, yecha' c'a ca chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y can queri' chuka' ri ch'abel ri niquibila' ri principali' tak sacerdotes. Riye' y ri aj tz'iba', ri achi'a' fariseos y ri rijita'k tak achi'a' ri c'o quik'ij, niquitze'ej c'a ri Jesús y niquibila' c'a chiquiwech: ");
INSERT INTO cakWNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Riya' can yec'o wi c'a ri xerucol, pero Riya' ma nicowin ta nucol el ri'. Y wi can ya c'a Riya' ri Rey riche (rixin) re katinamit Israel, tika c'a pe chuwech la cruz y riyoj can xtikanimaj c'a Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Riya' can xucukuba' wi ruc'u'x riq'ui ri Dios, y wi ri Dios can nrajo' wi re Jesús, tucolo' c'a. Ruma re Jesús xa can rubin wi: Yin c'a riyin ri Ruc'ajol ri Dios, chinek, xecha' ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y ri alek'oma' ri ye bajin chuwech quicruz ri yec'o apo chuxquin ri Jesús, can queri' chuka' niquibila' apo, achi'el ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y tek xnic'ajer ri k'ij, yac'ari' tek xoc k'eku'm ronojel ri ruwach'ulef. Y ri k'eku'm ri' xq'uis c'a el c'a pa tak a las tres ri tikak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y ya c'a hora ri' tek ri Jesús xurek ruchi' y xubij: Elí, Elí, ¿lama sabactani? xcha'. Y ri ch'abel ri' ntel chi tzij: Nata' Dios, Nata' Dios, ¿achique c'a ruma tek xinamalij ca? ");
INSERT INTO cakWNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y yec'o ri yec'o apo chiri' chunakajal ri Jesús, tek xquic'axaj ri xubij, xquibila' c'a: Riya' ya ri Elías ri nusiq'uij (nroyoj), xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y can yac'ari' tek c'o c'a jun ri junanin (anibel) xberuc'ama' pe jun esponja y xumuba' pa jun ch'omilaj ruya'al uva. C'ac'ari' xuya' chutza'n jun aj, riche (rixin) chi xuya' chare ri Jesús riche (rixin) chi nich'uch'u' ka juba' ri chaki'j chi' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Yac'a ri nic'aj chic ri yec'o apo chiri' riq'ui ri Jesús, xquibij: Tikatzu' na c'a, k'alaj ri' wi nipe ri Elías chucolic, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yac'a ri Jesús yac'ari' tek riq'ui ruchuk'a' xurek ruchi', y xujech c'a ri ránima pa ruk'a' ri Dios; y xcom ka. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y yac'ari' tek ri tziek ri achoj riq'ui jachon wi ri rupan ri rachoch ri Dios xel pa ca'i'. Xuchop pe c'a pa ruwi' y xbeq'uis c'a chuxe' ka. Chuka' ri ruwach'ulef can xsilon c'a y ri nima'k tak abej xepax. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri jul ri ye mukun wi ri caminaki' xejakatej. Y ye q'uiy c'a chique ri lok'olaj tak ralc'ual ri Dios ri ye caminek el xec'astej pe, ");
INSERT INTO cakWNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xebe'el pe. Yac'a tek c'astajnek chic pe ri Jesús, yac'ari' tek xetz'etetej chuka' riye'. Y riye' xe'apon c'a chupan ri lok'olaj tinamit Jerusalem. Can chiquiwech wi c'a ye q'uiy ri xquic'ut wi qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri quicapitán ri soldados y quinojel ri yec'o chiri' quichajin apo ri Jesús, tek quitz'eton chic ka ri xuben ri silonel, y quitz'eton chuka' chic ri nic'aj chic ri xebanatej, riye' can sibilaj c'a xquixibij qui' y xquibila' c'a: Can kitzij na wi chi re jun achi re' can Ruc'ajol wi ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y ye q'uiy c'a ixoki' ri can c'a pa Galilea ye tzeketel wi pe chrij ri Jesús riche (rixin) chi niquinimaj niquilij, riye' yetzu'un c'a apo, xa yac'a chi c'anej yec'o wi el. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicojol c'a quinojel ri ixoki' ri', c'o c'a ri María Magdalena, c'o ri María ri quite' ri Jacobo y ri José, y c'o chuka' apo ri rixjayil ri Zebedeo, ri quite' ri Jacobo y ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Yac'a tek xoc pe ri ak'a', c'o c'a jun tzekelbey riche (rixin) ri Jesús ri xapon, jun beyon aj pa tinamit Arimatea, ri José rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Riya' xbe c'a riq'ui ri Pilato ri aj k'atbel tzij y xberuc'utuj ri ruch'acul ri Jesús chare riche (rixin) chi numuk. Y ri Pilato xubij c'a chi tijach pe ri ruch'acul ri Jesús chare ri José. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y ri José xberuc'ama' c'a pe ri ruch'acul ri Jesús, y c'ac'ari' xubor pa jun sakilaj tziek. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Y xberuya' c'a ca pa jun jul riche (rixin) chi niya'ox (nya') caminek chupan. Ri jul ri' c'ac'ac', ri can riche (rixin) wi ka ri José tek ruc'oton chuwech jun nimabej. Y tek riya' rutz'apin chic ca ruchi' ri jul riq'ui ri nimalaj setesic abej ri tz'apebel ruchi' ri jul, c'ac'ari' xtzolin el. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ri María Magdalena y ri jun chic ixok María chuka' rubi', can ye tz'uyul c'a apo chuwech ri jul tek xmuk ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri k'ij tek xmuk ri Jesús, ya k'ij chuka' ri' tek ri winek niquibanala' chic ruchojmil ronojel ri xtic'atzin chique ri pa ruca'n k'ij, ruma yari' napon ri uxlanibel k'ij. Y pa ruca'n k'ij, tek yec'o chic chupan ri uxlanibel k'ij, yac'ari' tek ri principali' tak sacerdotes y ri achi'a' fariseos xquiben c'a chi xbequic'ulu' qui' chuwech ri Pilato ri aj k'atbel tzij. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Riye' xbequibij c'a chare: Táta, riyoj xnatej chake chi tek ri Jesús can c'a q'ues na, xubij c'a chi xtic'astej pe ri pa rox k'ij. Can queri' wi c'a rubin ca ri k'olojel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Y riche (rixin) c'a chi man xa quepe ri rudiscípulos y niquelek'aj el ri ruch'acul ri Jesús re chak'a', y c'ac'ari' xtiquibij chique ri winek chi ri Jesús can xc'astej wi el chiquicojol ri caminaki'; rumari' yoj petenak re wacami riche (rixin) chi nikac'utuj jun utzil chawe chi tataka' ruchajixic ri acuchi (achique) mukun wi ca, c'a ya tek nitz'aket na ri oxi' k'ij. Ruma wi xa ma xtikaben ta queri' y nisach el ri ruch'acul, yac'ari' tek can más ye q'uiy winek ri xquek'olotej que chuwech ri nabey mul, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xubij c'a chique ri achi'a' ri': Quixbiyin c'a y que'ic'uaj c'a el la achi'a' ye chajinel. Tibana' c'a ca rubanic chi utz, achi'el ri iwetaman riyix chi utz nuben ca, xe'uche'ex el. ");
INSERT INTO cakWNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ri achi'a' ri' can yac'ari' xebe acuchi (achique) mukun wi ca ri Jesús y xbequichojmirisaj ca chi tichajix chi utz. Y xquiya' c'a ca retal ri abej tz'apebel ruchi' ri jul, ri xtic'utu wi c'o ri xtijako. Y xequiya' ca chuka' ri ye chajinel chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y tek k'axnek chic ri uxlanibel k'ij, nimak'a' yan c'a chupan ri nabey k'ij chare ri semana, ri María Magdalena y ri jun chic ixok ri María chuka' rubi' xebe c'a chuchi' ri jul ri acuchi (achique) mukun wi ca ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yac'a tek can c'a ma jane ye'apon ta ri ixoki' chiri' chuchi' ri jul, xuben jun nimalaj silonel. Queri' xbanatej ruma jun ángel riche (rixin) ri Ajaf ri petenak chila' chicaj, xka acuchi (achique) mukun wi ca ri Jesús, y xrelesaj c'a el ri setesic abej ri tz'apebel ruchi' ri jul y xtz'uye' ka pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri sakil c'a riche (rixin) ri ángel ri tz'uyul pa ruwi' ri abej, xa can junan c'a riq'ui ri sakil ri nuya' jun coyopa'. Y ri rusakil ri rutziak can junan c'a riq'ui ri rusakil ri chumatef ri nika. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y ri achi'a' ye chajinel, ruma c'a sibilaj xquixibij qui' chuwech ri ángel, can xebarbot (xebaybot) c'a. Xa can achi'el ye caminaki' xquiben ca ruma quixibinri'il. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Yac'a tek xch'o ri ángel quiq'ui ri ca'i' ixoki', xubij c'a chique: Riyix man c'a tixibij ta iwi'. Ruma riyin can wetaman chi riyix nicanoj ri ruch'acul ri Jesús ri xcamisex chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ri ruch'acul xa man c'o ta chic wawe', ruma Riya' xc'astej yan el, achi'el ri rubin ca chiwe. Quixam pe y titzu' na pe' ri acuchi (achique) xc'oje' wi ri ruch'acul ri Ajaf. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wacami c'a quixbiyin chanin, y je'ibij chique quinojel ri rudiscípulos ri Jesús, chi Riya' xc'astej yan c'a el chiquicojol ri caminaki'. Riya' can ninabeyej c'a el chiwech, y nic'ul iwi' chila' pa Galilea. Y chiri' xtitz'et wi, achi'el re nbij el chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y ri ca'i' ixoki' ri' can yac'ari' xe'el el ri chiri' pa jul. Y astape' can quixibin qui', xa can sibilaj chuka' yequicot. Riye' can junanin (anibel) c'a xebe riche (rixin) chi nbequiya' rutzijol chique ri rudiscípulos ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Y yac'ari' tek ri Jesús xbec'ulun pe chiquiwech ri pa bey y xuya' rutzil quiwech. Y ri ca'i' ixoki' ri' can yac'ari' xexuque' ka chraken ri Jesús, xquik'etej ri raken y can xquiya' c'a chuka' ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y ri Jesús can yac'ari' tek xubij chique ri ixoki' ri': Man chic c'a tixibij ta iwi'. Wacami quixbiyin c'a y je'iya' rutzijol chique ri wach'alal, riche (rixin) chi can quebiyin c'a pa Galilea y chila' c'a xquinquitz'et wi, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ri ixoki' ri' quichapon c'a el bey. Y yac'ari' tek yec'o chique ri ye chajinel chuchi' ri jul ri xebe c'a pa tinamit Jerusalem. Y xbequiya' c'a rutzijol chique ri principali' tak sacerdotes, ronojel c'a ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Xepe ri principali' tak sacerdotes xquimol c'a qui' quiq'ui ri rijita'k tak achi'a' ri c'o quik'ij y xquiya' c'a chiquiwech chi niquiya' q'uiy quirajil ri soldados ri xechajin. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Y xquibij c'a chique ri ye chajinel: Riyix xaxu (xaxe) wi c'a tibij chi ya tek yix warnek yac'ari' tek xe'apon ri ye rudiscípulos ri Jesús pa k'eku'm y xquelek'aj el ri ruch'acul. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y wi ri aj k'atbel tzij nretamaj c'a chi xa xixwer ka y ma xixchajin ta achi'el ri bin chiwe, riyoj xkojbech'o c'a riq'ui. Y queri' xquixkacol pa ruk'a', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados ri xechajin chuchi' ri jul xquic'ul c'a el ri puek, y achi'el ri xbix el chique, can quec'ari' rutzijol ri xquelesaj rubixic chiquicojol ri israelitas. Y ya c'a ri' ri etaman cuma ri israelitas c'a chupan re k'ij re'. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yac'a ri julajuj rudiscípulos ri Jesús, xebe c'a pa Galilea. Y xebe c'a pa ruwi' ri juyu' ri bin ca chique ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y tek xquitz'et c'a ruwech ri Jesús, riye' can xquiya' c'a ruk'ij. Pero yec'o nic'aj chic ri ma can ta niquinimaj chi ya Jesús ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ri Jesús xjel c'a apo quiq'ui, y xubij c'a chique: Ronojel c'a k'atbel tzij jachon pa nuk'a' riyin, can queri' ri chila' chicaj y queri' chuka' wawe' chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Rumac'ari' re wacami nbij c'a chiwe: Quixbiyin c'a chuwech ronojel re ruwach'ulef, que'itijoj c'a ri winek riche (rixin) chi ye'oc tzekelbey wuche (wixin). Y ri can yinquitzekelbej, que'ibana' c'a bautizar pa rubi' ri Dios Tata'ixel, pa nubi' riyin ri C'ajolaxel y pa rubi' ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tic'utu' c'a chiquiwech chi tiquinimaj ronojel ri pixa' ri nbin ca. Y riyin can ronojel c'a k'ij xquic'oje' iwuq'ui; y majun bey xquixinya' ta ca, c'a tek xtapon ri ruq'uisbel k'ij chare re ruwach'ulef. Amén.");
INSERT INTO cakWNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quec'are' rubanic tek xtiquir pe rutzijoxic ri lok'olaj ch'abel ri niya'o colotajic, ruch'abel ri Jesucristo ri Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ri profeta Isaías, ri xk'alajsan ri ruch'abel ri Dios ojer ca, rutz'iban c'a ca ri xbix chare ri Jesucristo ruma ri Dios. Y quec'are' ri xutz'ibaj ca riya': Xtintek c'a ri nutako'n ri ninabeyej chawech, riche (rixin) chi nuchojmirisaj apo ri abey. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ri achi ri' xtic'oje' pa jun desierto. Y riya' can xturek c'a ruchi' riche (rixin) chi xtubij chique ri winek ri xque'apon riq'ui: Tichojmirisaj apo rubey ri Ajaf y can choj tibana' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri achi ri xunataj c'a ri Isaías chi xtipe nabey, ya ri Juan ri Bautista. Y riya' xc'oje' c'a pa jun desierto, y xubij c'a chique ri winek ri xe'apon riq'ui, chi titzolin c'a pe quic'u'x riq'ui ri Dios y tiquibana' bautizar qui', riche (rixin) chi queri' ri Dios nucuy ri quimac. Y ye q'uiy ri xeruben el bautizar. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y sibilaj c'a ye q'uiy ri winek ri xe'apon riq'ui ri Juan ri Bautista. Yec'o aj Jerusalem, ri tinamit ri c'o chiri' pa rucuenta ri Judea. Y yec'o riche (rixin) ri nic'aj chic tinamit ri yec'o chuka' pa rucuenta ri Judea. Ri winek c'a ri' xeban c'a el bautizar ruma riya' chiri' pa raken ya' Jordán. Y can xequik'alajsaj wi c'a ri quimac. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri rutziak c'a ri Juan banon riq'ui rusmal camello, y rucusan jun tz'um ri oconek ximibel xerupan. Y ri ruway, yec'a ri sac' y ri cab ri niquiya' ri tak chicop pa tak juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan nuk'alajsaj c'a chique ri winek: C'o jun achi ri xtipe re chkawech apo ri man achi'el ta oc riyin. Ri jun achi ri' can nim wi ruk'ij y nim chuka' ri ruchuk'a'; rumari', astape' riyin yiwuque' ka riche (rixin) chi nquir ri ruximbel ri ruxajab, hasta ri' ma yin ruc'amon ta (takal ta chuwij) chi nben ruma nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y riyin, ya' ri ncusaj riche (rixin) chi yixinben bautizar. Pero ri jun achi ri xtipe, riq'ui ri Lok'olaj Espíritu xquixruben wi bautizar. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ye k'ij c'a ri' tek ri Jesús elenak pe pa tinamit Nazaret ri c'o chiri' pa rucuenta ri Galilea y xapon riq'ui ri Juan. Y Riya' chuka' xban c'a bautizar ruma ri Juan ri pa raken ya' Jordán. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y tek ri Jesús ntel c'a pe pa ya', xutz'et chi ri caj xjakatej, y ri Lok'olaj Espíritu nika c'a pe pa ruwi' achi'el jun palomax. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y yac'ari' tek c'o jun ch'abel ri xpe chila' chicaj y xubij: Yit c'a riyit ri Nuc'ajol y can sibilaj yatinwajo', y can nucukuban wi nuc'u'x awuq'ui, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Can yac'ari' tek ri Jesús xban chare ruma ri Lok'olaj Espíritu riche (rixin) chi xbe pa jun desierto. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y can xc'oje' pa desierto y ri chiri' can yec'o apo ri itzel tak chicop. Chiri' c'a xc'oje' wi cawinek k'ij. Y tek ri Jesús c'o c'a chiri', ri Satanás nutij c'a ruk'ij chrij ruma nrajo' chi nitzak pa ruk'a', pero ma xcowin ta. Y ri ángeles xquichop niquinimaj niquilij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'o chic c'a ri Juan pa cárcel, tek ri Jesús xbe pa Galilea. Ri Jesús nutzijoj c'a ri lok'olaj ch'abel ri nich'o chrij ri rajawaren ri Dios, ");
INSERT INTO cakWNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y nubij c'a: Xtz'aket yan c'a ri tiempo, ri rajawaren ri Dios xa nakaj chic c'o wi pe. Titzolin c'a pe ic'u'x y tinimaj ri lok'olaj ch'abel ri niya'o colotajic, nicha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y tek ri Jesús benak c'a chuchi' ri choy Galilea, xerutz'et c'a ye ca'i' achi'a' cach'alal qui'; Simón rubi' ri jun y Andrés rubi' ri jun chic. Ri ca'i' c'a achi'a' ri' ye chapoy tak car, rumari' tek yetajin niquiq'uek ka ri quiya'l chapabel car chupan ri choy. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Y tek ri Jesús xch'o quiq'ui ri ye ca'i' chapoy tak car ri', xubij chique: Quinitzekelbej y xtinc'ut chiwech achique rubanic ye'ich'ec pe winek riche (rixin) chi yinquitzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri ca'i' achi'a' ri', can yac'ari' xquiya' ca ri chapoj car y xquitzekelbej el. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y xa c'a juba' c'a quebiyin apo, tek ri Jesús xerutz'et c'a ri Jacobo y ri Juan, ri ye ruc'ajol ri jun achi Zebedeo rubi'. Ri ye ca'i' achi'a' ri' pa jucu' c'a yec'o wi, yesamej. Riye' yequic'ojoj ri quiya'l chapabel car. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Xpe c'a ri Jesús xerusiq'uij (xeroyoj) riche (rixin) chi niquitzekelbej. Y ri Jacobo y ri Juan can xu (xe wi) chuka' xquic'axaj queri', xquitzekelbej el ri Jesús y xquiya' ca ri quitata'. Ri tata'aj y ri mozos xec'oje' c'a ca chiri' pa jucu'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri Jesús y ri ye benak riq'ui, xe'apon c'a pa tinamit Capernaum. Y chupan ri uxlanibel k'ij, ri Jesús xbe c'a pa jay ri kas nic'ut wi ri ruch'abel ri Dios chupan ri tinamit ri'. Riya' nutzijoj c'a ri ruch'abel ri Dios chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xe'ac'axan riche (rixin), can xquimey ruma chi ri ch'abel ri xuc'ut can nik'alajin chi achi'el ruch'abel jun ri c'o k'atbel tzij pa ruk'a' y man achi'el ta oc ri niquic'ut ri aj tz'iba'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y ri chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios, ri k'ij ri' c'o c'a apo jun achi ri c'o jun itzel espíritu riq'ui. Y ri itzel espíritu ri c'o riq'ui ri achi ri', xuchop nurakala' ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Y xubij c'a chare ri Jesús: ¡Ah! ¿Achique c'a ri nawajo' chake, riyit Jesús aj Nazaret? ¿Xape c'a riche (rixin) chi naq'uis kak'ij? Riyin wetaman yit achique c'a riyit y rumari' wetaman chi riyit can yit lok'olaj wi y yit petenak riq'ui ri Dios, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yac'a ri Jesús xchapon chare ri itzel espíritu y xubij: Ma cach'o ta chic. Catel el. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y ri itzel espíritu nurek ruchi' xel el. Y xuquiyica' ca ri ruch'acul ri achi ri achoj riq'ui xel wi el. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y ri winek ri quimolon qui' chiri', xsach quic'u'x tek xquitz'et ri xuben ri Jesús, y niquibila' c'a chiquiwech: ¿Achique c'a rubanic re'? Ruma re tijonic re ye ruc'amon pe Riya', majun bey kac'axan ta riyoj. Ruma ri ruch'abel can nuc'ut c'a chi Riya' can c'o k'atbel tzij pa ruk'a'. Y hasta ri itzel tak espíritu can niquinimaj rutzij, yecha' c'a ka chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y chanin c'a xbe rutzijol ri Jesús, y rumari' ri winek ri yec'o pa tak tinamit ri yec'o pe chunakajal ri Galilea, chanin c'a xquic'axaj ri yerubanala' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Tek ri Jesús, ri Jacobo y ri Juan xe'el c'a pe ri chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios, riye' xebe c'a chcachoch ri Simón y ri Andrés. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Yac'a tek xe'apon, xbix chare ri Jesús chi ri rujite' ri Simón kajnek pa ruch'at, ruma c'o jun nimalaj c'aten chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y ri Jesús can yac'ari' xjel apo riq'ui, xuchop c'a ruk'a' y xuben chare chi xyacatej. Y can xu (xe) wi c'a queri' xuben chare, can yac'ari' tek xq'uis el ri nimalaj c'aten chrij. Y ri ixok ri' can yac'ari' xuchop yerunimaj yerilij apo ri Jesús y ri ye benak riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Y yac'a tek xka yan ka ri k'ij y xoc c'a pe ri ak'a' chupan ri k'ij ri', yac'ari' tek quinojel ri winek ri c'o yawa'i' quiq'ui xequic'uala' apo chuwech ri Jesús. Chiquicojol ri yawa'i' c'a ri', yec'o ri relic yabil ri ntoc chique y yec'o c'a ri ye yawa'i' pa quik'a' itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y quinojel ri winek ri yec'o chupan ri jun tinamit ri' xbequimolo' qui' chuchi' ri jay ri acuchi (achique) c'o wi ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y ri Jesús can xeruc'achojsaj wi el ri yawa'i'. Ri yawa'i' ri' can jalajoj c'a ruwech chi yabil ri chapayon quiche (quixin). Chuka' Riya' xerelesala' el ri itzel tak espíritu ri yec'o quiq'ui ri winek. Ri Jesús can ma xuya' ta c'a k'ij chique ri itzel tak espíritu riche (rixin) chi xech'o ta, ruma riye' quetaman ruwech Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nimak'a' yan ri ruca'n k'ij, can c'a mukmuj na, ri Jesús xyacatej el y xbe pa jun lugar ri acuchi (achique) majun winek c'o, riche (rixin) chi xberubana' orar. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y ri Simón y ri ye rachibil xebe c'a chucanoxic ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tek xquil c'a, xquibij chare: Quinojel ri winek yatquicanoj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y ri Jesús xubij c'a chique: Jo' pa nic'aj chic tinamit ri yec'o pe nakaj, riche (rixin) chi ntzijoj chuka' ri ruch'abel ri Dios chiri', ruma chubanic ri samaj ri' tek xipe wawe' chuwech re ruwach'ulef, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y Riya' xbe c'a chutzijoxic ri ruch'abel ri Dios pa ronojel tinamit ri yec'o pa rucuenta ri Galilea. Xabachique c'a tinamit ri xapon wi, Riya' xutzijoj ri ruch'abel ri Dios ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. Y chuka' can xerelesala' c'a ri itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xpe c'a jun achi ri c'o jun itzel yabil chrij, y ri yabil ri' lepra rubi'. Ri achi ri' xuc'utuj c'a utzil chare ri Jesús, xxuque' ka chuwech y xubij c'a chare: Wi riyit nawajo' yinac'achojsaj chare re nuyabil, can yic'achoj wi c'a ri', ruma riyin wetaman chi can yacowin wi, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ri Jesús sibilaj c'a xujoyowaj ruwech ri achi ri ruc'ulwachin ri yabil ri'; rumari' Riya' can yac'ari' tek xuchop apo y xubij chare: Nwajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chawij, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y can xu (xe) wi xubij queri' ri Jesús, can yac'ari' xq'uis el ri lepra chrij ri achi y xc'achoj ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Y ri Jesús, can yac'ari' tek xubij chare ri achi chi tibe el, pero can xuchilabej c'a el chare ri achique rajawaxic chi nuben. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ri Jesús xubij c'a el chare ri achi ri': Majun achoj chare tatzijoj wi ri xbanatej awuq'ui, xa choj jac'utu' awi' chuwech ri sacerdote. Y can taya' c'a ri ofrenda ri rajawaxic chi naya', achi'el nubij chupan ri rutz'iban ca ri Moisés, riche (rixin) chi queri' nak'alajsaj c'a awi' chiquiwech chi yit ch'ajch'oj chic, xuche'ex el. ");
INSERT INTO cakWNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Yac'a ri achi xaxu (xaxe) wi xuya' ca ri Jesús, can yari' xuchop rutzijoxic chique ri winek ri achique xbanatej riq'ui riya'. Y queri' ri Jesús chanin c'a xel rutzijol, y rumari' xa pan ewel chic tek ntoc apo chupan ri tinamit, y ruma c'a chuka' ri' tek nic'oje' ca ri pa tak juyu' ri acuchi (achique) majun winek c'o. Y ri winek c'a ri ye'apon riq'ui ri Jesús sibilaj ye q'uiy, y chuka' q'uiy lugar yepe wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Y tek k'axnek chic c'a ca'i' oxi' k'ij, ri Jesús xtzolin ri pa tinamit Capernaum, y yac'ari' tek ri winek xquic'axaj chi Riya' c'o pa jun jay chiri' pa tinamit. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Yac'ari' tek yec'o winek ri can chanin c'a xquimol apo qui' ri achique jay c'o wi ri Jesús, y ma xeruben ta chic chi xe'oc chupan ri jay. Ri pa ruchi' jay can majun chic c'a nicowin ta ntoc. Rumari' hasta chuwajay el yec'o winek. Y ri Jesús can nubij c'a ri ruch'abel ri Dios chique quinojel ri xquimol apo qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yac'a chuka' ri' tek yec'o nic'aj chic ri xe'apon, quic'uan c'a apo jun achi siquirnek. Ye caji' c'a ri ye uc'uayon apo riche (rixin), quili'en el chuwech ri ruwarabel. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero riye' xa ma xecowin ta xe'oc apo c'a riq'ui ri Jesús, cuma ri winek ri quimolon apo qui' sibilaj ye q'uiy. Ma xecowin ta c'a xek'ax chiquicojol ri winek ri', rumari' xa ya chic ruwi' ri jay ri xquelesaj el juba'. Y chiri' c'a xquikasaj wi ka ri yawa', rachibilan ri ruwarabel. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y tek ri Jesús xerutz'et chi can quicukuban quic'u'x riq'ui Riya', xubij c'a chare ri achi siquirnek: Walc'ual, ri amac xecuyutej, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y ri jay ri quimolon wi qui', ye tz'uyul chuka' apo ca'i' oxi' aj tz'iba'. Riye' niquich'ob c'a pa tak cánima: ");
INSERT INTO cakWNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Achique ruma tek re Jesús nubij chare la achi la' chi nucuy rumac? Can itzel ri nubij ruma nuben chi can ya Riya' ri Dios. ¿Ruma achique ta chic jun ri nicuyu mac? Majun chic jun. Xaxu (xaxe) wi ri Dios ri nicuyu mac, yecha' c'a pa tak cánima ri aj tz'iba' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yac'a ri Jesús can jabel retaman ri niquich'ob pa tak cánima ri achi'a' ri'. Y rumari' xubij chique: ¿Achique c'a ruma tek riyix queri' nich'ob pa tak iwánima? ");
INSERT INTO cakWNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wacami tibij na c'a chuwe: ¿Achique cami ri más c'ayef (cuesta) rubanic nich'ob riyix? ¿La ya cami ri nbij chare re achi siquirnek chi ri rumac xecuyutej yan, o ya ri nbij chare: Cayacatej, tac'uaj la awarabel y cabiyin el? ");
INSERT INTO cakWNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wacami c'a, riche (rixin) chi riyix niwetamaj chi riyin ri C'ajolaxel ri xinalex chicojol can c'o k'atbel tzij pa nuk'a' riche (rixin) chi ncuy mac, titz'eta' c'a. Y ri Jesús xubij c'a chare ri achi siquirnek: ");
INSERT INTO cakWNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nbij c'a chawe: Cayacatej, tac'uaj el la awarabel y cabiyin chawachoch, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y ri achi can yac'ari' tek xyacatej anej, xuc'ol ri ruwarabel, y xel el chiquicojol ri quimolon qui' chiri'. Y ri winek ri' xquimey c'a, ruma majun bey quitz'eton ta chi que ta ri' nibanatej. Y xquiya' c'a chuka' ruk'ij ruc'ojlen ri Dios y xquibila' c'a: Majun bey katz'eton ta chi que ta re' nibanatej, xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y ri Jesús xbe chic c'a jun bey chuchi' ri choy; y quinojel c'a ri winek xe'apon riq'ui, y Riya' xerutijoj c'a riq'ui ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y yac'a tek ri Jesús ruchapon el bey riche (rixin) chi nitzolin, yac'ari' tek xutz'et ri Leví, ri ruc'ajol ri jun achi Alfeo rubi'. Ri Leví tz'uyul c'a acuchi (achique) yetoj wi ca ri alcawal. Y xpe ri Jesús xubij c'a chare: Quinatzekelbej. Y can yac'ari' tek riya' xbeyacatej pe ri acuchi (achique) tz'uyul wi y xutzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y yac'a tek ri Jesús tz'uyul pa mesa ri chiri' pa rachoch ri Leví, ye q'uiy c'a chique ri ye c'utuy tak alcawal y nic'aj chic winek ri xa ye aj maqui' ri xetz'uye' chuka' apo ri pa mesa junan riq'ui ri Jesús y quiq'ui ri rudiscípulos, ruma sibilaj ye q'uiy ri yetzekelben riche (rixin) ri Jesús ri yec'o c'a chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y tek ri aj tz'iba' y ri achi'a' fariseos xquitz'et ri Jesús chi xa niwa' quiq'ui ri ye c'utuy tak alcawal y quiq'ui ri winek ri xa ye aj maqui', xquic'utuj c'a chique ri rudiscípulos: ¿Achique ruma la' chi Riya' niwa' y nuc'uya' quiq'ui ri ye c'utuy tak alcawal y quiq'ui nic'aj chic winek ri xa ye aj maqui'? xecha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Y tek ri Jesús xrac'axaj ri tzij ri xquibij ri aj tz'iba' y ri achi'a' fariseos, Riya' xubij c'a chique: Jun ajk'omanel ma ye ta ri ye utz ri yerak'omaj. Riya' yerak'omaj ri yawa'i'. Riyin ma xipe ta chiquicanoxic winek ri choj quic'aslen. Riyin xipe chiquicanoxic ri aj maqui', ri rajawaxic chi nitzolin pe quic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri ye rudiscípulos ri Juan ri Bautista y ri quidiscípulos ri fariseos, c'o c'a k'ij niquichajij tek can ma yewa' ta riche (rixin) chi niquiben orar. Y rumari' xoquic'utuj c'a chare ri Jesús: Ri yoj rudiscípulos ri Juan y ri quidiscípulos ri fariseos can c'o k'ij nikachajij tek can ma yojwa' ta, riche (rixin) chi nikaben orar. ¿Y achique c'a ruma tek ri adiscípulos riyit ma que ta ri' niquiben? ");
INSERT INTO cakWNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y ri Jesús xubij c'a chique: ¿Achique nibij riyix? ¿La utz cami chi man ta yewa' ri xesiq'uix (xe'oyox) pa jun c'ulanen tek xa c'a c'o na apo quiq'ui ri achijlon ri xa c'a xc'ule'? Ma utz ta. Can ma utz ta c'a ri niquiben, wi xa ma yewa' ta, ruma ri achijlon xa c'a c'o na chiquicojol. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xtapon ri k'ij tek re achijlon re' xtelesex el chiquicojol, y yac'ari' tek ma xquewa' ta riche (rixin) chi xtiquiben orar. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Y majun chuka' winek nibano chi nucusaj ta jun c'ojobel c'ac'ac' riche (rixin) chi nuc'ojoj jun tziek ri xa ri'j chic. Ruma jun c'ojobel c'ac'ac' nuc'ol ri' y nujic' ri tziek ri xa ri'j chic, y ri tziek ri' más niretzetaj (nitzeretej). ");
INSERT INTO cakWNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y queri' chuka' majun niya'o ta c'ac'ac' ruya'al uva chupan jun tz'um yabel ya' ri xa ri'j chic. Ruma wi queri' niban, y ri tz'um xa ma niyukuk ta chic, xa nirakaro' y niq'uis el ri ruya'al uva chupan. Y chuka' ri tz'um ri' majun chic nic'atzin wi. Yac'a jun c'ac'ac' tz'um yabel ya', utz niyaque' ri c'ac'ac' ruya'al uva chupan. Queri' xubij ri Jesús chrij ri ch'abel ri xuc'ut. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun uxlanibel k'ij, ri Jesús y ri rudiscípulos yek'ax c'a el pa jun ulef ri ticon trigo chuwech. Y ri discípulos c'o c'a ruwi' trigo ri xequich'up el. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Yec'a ri achi'a' fariseos xquibij chare ri Jesús: Que'atzu' la adiscípulos ruma xajan yetajin chubanic. ¿Achique ruma yequich'upla' trigo re k'ij re'? Ruma re k'ij re', uxlanibel k'ij y ma ruc'amon ta chi yesamej, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Yac'a ri Jesús xubij chique: ¿La majun bey c'a isiq'uin ta ri tz'ibatal ca chupan ri wuj chrij ri xquiben ri David y ri ye rachibil ri ojer ca, tek sibilaj xenum y rajawaxic chi yewa'? ");
INSERT INTO cakWNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xbe c'a chucanoxic wey pa rachoch ri Dios. Y ri nimalaj sacerdote chupan ri tiempo ri' ya c'a ri Abiatar. Y can ya ri lok'olaj tak caxlan wey ri xbejach pe chare ri David y ma xu (xe) ta wi riya' ri xtijo, xa can xuya' chuka' chique ri ye benak riq'ui. Y ma riq'ui wi ri', ma mac ta ri xquiben, astape' ri caxlan wey ri' xaxu (xaxe wi) ri sacerdotes ri yetijo. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y ri Jesús xubij chuka' chique: Ri uxlanibel k'ij xban riche (rixin) jun utzil chare ri winek, y ma ya ta ri winek ri xban riche (rixin) ta jun utzil chare ri uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rumac'ari' riyix can ruc'amon c'a chi niwetamaj chi yin c'a riyin ri C'ajolaxel ri xinalex chicojol, ri yin Rajaf ri uxlanibel k'ij. Can pa nuk'a' c'a riyin c'o wi riche (rixin) chi nbij achique utz niban chupan ri k'ij ri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y ri Jesús y ri rudiscípulos xe'apon chic c'a ri pa jay ri kas nic'ut wi ri ruch'abel ri Dios. Y chiquicojol ri winek ri quimolon qui' chiri', c'o c'a jun achi chaki'j jun ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Y yec'o c'a ri ye tzulibeyon apo riche (rixin) ri Jesús, k'alaj ri' wi nuc'achojsaj ri achi, riche (rixin) chi queri' niquitzujuj (niquisujuj) chi ri Jesús xsamej chupan ri jun uxlanibel k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ma riq'ui wi ri', ri Jesús xubij chare ri achi chaki'j ri ruk'a': Cayacatej pe y cac'oje' pa nic'aj, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Xpe c'a ri Jesús xubij chique ri winek ri yec'o chiri': Riyin nwajo' c'a nc'utuj chiwe: ¿La más cami ruc'amon chi niban utzil pa jun uxlanibel k'ij o xa ya ri etzelal? ¿Ri nicol jun winek chuwech ri camic o ri nicamisex? ¿Achique nich'ob riyix? xcha' chique. Pero quinojel majun xquibij ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yac'ari' tek ri Jesús xerutzu' c'a quinojel ri quimolon qui' chiri', y xerutz'et chi xa cowirnek ri cánima y ma nicajo' ta niquinimaj. Rumari' Riya' xpe royowal y xbison. C'ac'ari' Riya' xubij c'a chare ri achi chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achi can xu (xe) wi xuyuk ri ruk'a', can yac'ari' xchojmir. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y ri achi'a' fariseos can xu (xe) wi xquitz'et ca ri xbanatej, xbequimolo' qui' quiq'ui ri yec'o pa rupartido ri rey Herodes, riche (rixin) chi niquich'ob achique rubanic niquiben riche (rixin) chi niquicamisaj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y ri Jesús xbe c'a chuchi' jun choy, ye rachibilan el ri rudiscípulos. Y chuka' xtzekelbex el cuma q'uiy winek ri ye petenak pa rucuenta ri Galilea, y cuma nic'aj chic winek ri ye petenak pa rucuenta ri Judea. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Y can xtzekelbex chuka' cuma ri winek ri ye petenak pa Jerusalem, jun tinamit ri c'o chuka' pa rucuenta ri Judea. Y yec'o chuka' ri ye petenak pa rucuenta ri Idumea, y ri ye petenak c'a juc'an chic ruchi' ri raken ya' Jordán. Xtzekelbex chuka' cuma ri winek ri ye petenak pa Tiro y pa Sidón y ri ye petenak chuka' chiquinakajal ri ca'i' tinamit ri'. Can quinojel c'a ri winek ri xe'oka riq'ui ri Jesús, xepe ruma quic'axan c'a pe ri milagros ri yerubanala' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y ruma chi can ye q'uiy ri winek ri ye'oka riq'ui, ri Jesús xubij c'a chique ri rudiscípulos chi tiquiya' pe jun jucu' queri' nakaj, riche (rixin) chi queri', wi ri winek más niquipitz', Riya' ntoc c'a chupan ri jucu' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ri Jesús can ye q'uiy wi c'a ri ye ruc'achojsan chic. Pero ruma quinojel c'a ri ye yawa'i' nicajo' chuka' chi yec'achojsex ruma ri Jesús, rumari' niquimajla' c'a qui' chrij, riche (rixin) chi niquichop ta apo ri rutziak, ruma nicajo' yec'achoj chare ri quiyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y ri itzel tak espíritu tek niquitz'et c'a ri Jesús, niquixucubala' c'a qui' chuwech, chuka' niquirek quichi' y niquibij: Yit c'a riyit ri Ruc'ajol ri Dios, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yac'a ri Jesús xchapon c'a chique chi ma tiquiya' ta rutzijol chi ya Riya' ri Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xjote' c'a el pa ruwi' jun juyu' y xerusiq'uij (xeroyoj) el ri xrajo' Riya' chi xeruc'uaj el. Ri Jesús xerusiq'uij (xeroyoj) apo chiquijujunal ri achi'a' ri' y ri achi'a' ri' xebe apo riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ye cablajuj c'a ri xerucha' riche (rixin) chi yerachibilaj y riche (rixin) chuka' chi yerutek el chutzijoxic ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y queri' chuka' can xtuya' k'atbel tzij pa quik'a' riche (rixin) chi yequic'achojsaj yawa'i', y riche (rixin) chi yecowin yequelesala' itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri ye cablajuj ri xerucha' ri Jesús, ya ri Simón ri xubij chuka' Pedro chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ri Jacobo y ri Juan, ri ye ruc'ajol ri Zebedeo, ri xubij chuka' Boanerges chique; bi'aj ri ntel c'a chi tzij chi ye achi'el coklajay. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri jun achi ri Alfeo rubi', ri Tadeo, ri Simón ri c'o quiq'ui ri achi'a' ri nibix cananista chique, ");
INSERT INTO cakWNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xjacho riche (rixin) ri Jesús pa quik'a' ri winek. Y quinojel c'a ri' xebe riq'ui ri Jesús pa jun jay. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Y ruma sibilaj ye q'uiy winek ri xquimol chic apo qui' jun bey, rumari' riye' hasta ma utz ta chic chi yewa'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y tek ri ye rach'alal ri Jesús xquic'axaj ri nibanatej, xe'apon riche (rixin) chi nbequic'ama' pe, ruma riye' xquich'ob chi ri Jesús xch'ujer. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y ri aj tz'iba' ri ye petenak pa tinamit Jerusalem, yec'o apo ri chiri' riq'ui ri Jesús. Y niquibila' c'a chiquiwech chi ri Jesús c'o ri Beelzebú riq'ui; ri cajawalul ri itzel tak espíritu. Y ya ri Beelzebú ri niya'o uchuk'a' chare riche (rixin) chi queri' nicowin yerelesaj ri itzel tak espíritu, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y rumari' ri Jesús xerusiq'uij (xeroyoj), y riche (rixin) chi xtzijon quiq'ui, xerucusaj c'ambel tak tzij. Riya' xubij c'a chique: ¿Achique modo chi ri Satanás can ya riya' mismo nrokotaj el ri'? ");
INSERT INTO cakWNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ruma ri winek riche (rixin) jun ruwach'ulef, wi xa ma junan ta quiwech niquiben, ri' ma utz ta, ruma nuben chare ri quiruwach'ulef chi ma xtiyaloj ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y queri' chuka' ri winek pa jun jay, wi xa ma junan ta quiwech niquiben, xa xtiquitaluj el qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y rumari' ri Satanás, ma xtuben ta ka ch'a'oj chrij riya' mismo y ca'i' c'a nuben. Ruma wi queri' nuben, chanin nitzak y niq'uis ka ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Y wi c'o jun winek ri nrajo' nelek' el pa rachoch jun achi ri c'o sibilaj ruchuk'a', nabey c'o chi nuxim ri achi ri', y c'ac'ari' nicowin nucanoj el ronojel ri nrajo' yeruc'uaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Y tiwac'axaj c'a jabel re ch'abel re xtinbij chiwe wacami. Xabachique mac yequibanala' ri winek ri ye alaxnek chuwech re ruwach'ulef can c'a yecuyutej na. Y queri' chuka' ronojel ri yok'onic ri yequibanala' ri winek, can c'a yecuyutej na chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Yac'a ri niyok'on chrij ri Lok'olaj Espíritu, can ma xticuyutej ta rumac, xa can xtrejkalej rumac riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Quec'are' xubij chique ri aj tz'iba', ruma chi riye' niquibij c'a chare, chi Riya' c'o itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y ri rute' y ri ye rach'alal ri Jesús xepe c'a ri acuchi (achique) c'o wi Riya'. Pero ma xe'oc ta apo riq'ui. Xaxu (xaxe) wi c'a xquitek rubixic chare chi nicajo' yetzijon riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y ri winek ri ye tz'uyul ka ri can quisutin apo qui' chrij ri Jesús xquibij c'a apo chare: Ri ate' y ri ye awach'alal yec'o pe wawe' chuwajay el y yatquicanoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yac'a ri Jesús xubij c'a chique ri winek ri quimolon qui' riq'ui: ¿Achique c'a ri' ri nte' y ye achique c'a ri' ri wach'alal ri nich'ob riyix? ");
INSERT INTO cakWNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y ri Jesús xerutzu' c'a quinojel ri quisutin qui' chrij ye tz'uyul y xubij chique: Yec'are' ri ye oconek nte' y ye oconek wach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ruma chi can quinojel c'a ri yebano ri ruraybel ri Dios, yec'ari' ri ye achi'el nte', wana' y nchak', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Y ri Jesús ye rachibilan ri rudiscípulos xbe chic c'a chuchi' ri choy y Riya' yerutijoj c'a ri winek riq'ui ri ruch'abel ri Dios. Y sibilaj ye q'uiy winek ri xquimol apo qui'. Rumari' ri Jesús xoc apo pa jun jucu' ri chiri' pa ruwi' ya', y xtz'uye' c'a chupan. Y ri chiri' chuchi' apo ri choy, yec'o c'a ri winek niquic'axaj apo ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Riya' q'uiy c'a ri xuc'ut chiquiwech riq'ui c'ambel tak tzij. Y xubij c'a chique: ");
INSERT INTO cakWNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tiwac'axaj c'a jabel re xtinbij chiwe: C'o c'a jun achi ri xbe pa jopin ija'tz. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y tek ri achi c'o chic pa samaj nijopin ija'tz, c'o c'a juba' chare ri ija'tz ri' xa pa bey xka wi. Y xepe c'a ri aj xic' tak chicop ri yebe pa cak'ik', xquitij el ri ija'tz ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","C'o c'a juba' chic chare ri ija'tz cojol tak abej xka wi y chiri' xa ma q'uiy ta ri ulef c'o. Y chanin c'a xe'el pe ruma xa ma pim ta ri ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xa yac'a tek xpe ruchuk'a' ri k'ij, xemayamo' y xechaki'j ka. Y ruma chi xa ma nej ta benak wi ka ri quic'amal, rumari' xechaki'j ka chanin. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y c'o c'a juba' chic chare ri ija'tz ri' xa cojol tak k'ayis ri c'o quiq'uixal xka wi. Y tek xe'el pe, junan xeq'uiy quiq'ui ri q'uix. Y ruma chi ri q'uix sibilaj xeq'uiy, ri tico'n xejik' pa quik'a' y man c'a xquiya' ta quiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yac'a ri juba' chic chare ri ija'tz xka pa jun utzilaj ulef, y xe'el pe y xeq'uiy jabel. Y c'o c'a ija'tz xquiyala' a treinta quiwech, c'o xquiyala' a sesenta y c'o ri xquiyala' jojun ciento quiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","C'ac'ari' ri Jesús xubij c'a: Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y tek xcanaj ca ruyon ri Jesús quiq'ui ye ca'i' oxi' winek y ri ye cablajuj rudiscípulos, ri yec'o riq'ui xquic'utuj c'a chare chi achique c'a ri nrajo' nubij chique riq'ui ri c'ambel tzij ri xutzijoj chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y Riya' xubij chique: Chiwe c'a riyix can ya'on c'a k'ij riche (rixin) chi niwetamaj chrij ri rajawaren ri Dios, yac'a ri nic'aj chic winek ri ma yeniman ta wuche (wixin), ma ya'on ta k'ij chique riche (rixin) chi niquetamaj. Rumac'ari' riq'ui c'ambel tak tzij yitzijon wi quiq'ui, ");
INSERT INTO cakWNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","riche (rixin) chi queri' astape' niquitzu' y xa ma nich'obotej ta chiquiwech ri niquitzu' y astape' niquic'axaj y xa ma nik'ax ta chiquiwech ri niquic'axaj, riche (rixin) chi queri' ma nitzolin ta pe quic'u'x, y ma nicuyutej ta chuka' quimac ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y ri Jesús xubij chuka' chique ri winek y ri rudiscípulos: ¿La ma xk'ax ta cami chiwech ri c'ambel tzij ri xa c'a juba' tinbij ka chiwe? Ruma wi xa ma xk'ax ta chiwech, ¿la xtik'ax cami chiwech ri nic'aj chic c'ambel tak tzij? ");
INSERT INTO cakWNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ya c'a ri aj ticonel ri xbejopin ija'tz, yac'ari' ri samajel ri nic'utu ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri juba' ija'tz ri xeka pa bey, ye achi'el ri winek tek quic'axan chic ri ruch'abel ri Dios, y ri Satanás chanin napon quiq'ui y nrelesaj el ri ch'abel ri xtic pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri ija'tz ri xeka cojol tak abej, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex cuma ri winek. Ri winek ri' can chanin c'a niquic'ul ri ruch'abel ri Dios pa tak cánima riq'ui quicoten. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Xa yac'a chi can ma xbe ta ka jabel ruc'amal ri ruch'abel ri Dios pa tak cánima, xa can ma niyaloj ta c'a ri quicoten quiq'ui. Y tek yepe c'a tijoj pokonal y ye'etzelex ruma quiniman ri ruch'abel ri Dios, chanin yetzak. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yac'a ri ija'tz ri xeka cojol tak k'ayis ri c'o quiq'uixal, can nich'o chuka' chrij ri ruch'abel ri Dios ri nac'axex cuma ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero ri winek ri' xaxu (xaxe wi) c'a ri nrajo' re tiempo re' ri nicajo' niquiben, y yek'olotej pa ruk'a' ri beyomel riche (rixin) re ruwach'ulef. Y q'uiy chuka' ruwech raynic yepe quiq'ui, y rumari' xa nijik' ri ruch'abel ri Dios ri c'o quiq'ui y majun bey c'a xtiwachin ta jabel ri ruch'abel ri Dios pa tak quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Yac'a ri ija'tz ri xeka pa jun utzilaj ulef, nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex cuma ri winek, y ri winek ri' can niquic'ul wi ka ri ruch'abel ri Dios y ri quic'aslen niwachin jabel. Can yewachin c'a achi'el niquiben ri ija'tz. Ruma yec'o ija'tz ri niquiya' a treinta quiwech, yec'o ri niquiya' a sesenta quiwech y yec'o ri can jojun ciento quiwech niquiya'. Quec'ari' nuben quic'aslen ri winek ri niquic'ul ka ri ruch'abel ri Dios pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ri Jesús xubij c'a chuka' chique: Tek nbec'amer pe jun k'ak' riche (rixin) nusakirisaj pa jay, ¿la chuxe' cami jun almul o chuxe' cami jun ch'at niya'ox (nya') wi? Ma que ta ri'. Ri k'ak' can c'o ruc'ojlibel ri acuchi (achique) nipabex wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Queri' chuka' majun ri ewan ca, ri man ta xtibek'alajin pe. Y chuka' can majun ri tz'apin ca rij, ri xa man ta xtibek'alajin pe y ntel pe chuwasakil. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y ri Jesús xubij chuka' chique ri winek: Tek riyix niwac'axaj ri ruch'abel ri Dios, can tiwac'axaj c'a ri nubij. Can tika c'a ka pa tak iwánima, ruma wi queri' niben, q'uiy etamabel ri nic'ul ca y xtiya'ox (xtya') chic juba' ruwi' chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ruma ri can c'o q'uiy riq'ui, xtiya'ox (xtya') c'a más chare y queri' q'uiy c'a ri xtic'oje' riq'ui. Yac'a ri xa juba' oc c'o riq'ui, hasta ri juba' ri' xa xtelesex chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y ri Jesús xubij chuka': Tek ri winek ye'oc pa rajawaren ri Dios, nibanatej c'a achi'el nibanatej riq'ui jun ija'tz ri nbetic ca ruma jun achi pan ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Tek ri ija'tz c'o chic c'a pan ulef, ri ticonel majun chic ri nuben. Riya' nbewer tek ntoc pe ri ak'a' y niyacatej el tek niseker pe, y queri' nuben ronojel k'ij. Y tek napon ri k'ij, ri ija'tz ntz'uc pe y niq'uiy, yac'a ri xtico ka riche (rixin) ri ija'tz ma retaman ta achique rubanic tek ri ija'tz ntz'uc pe y achique rubanic tek niq'uiy. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ri ticonel can majun chic c'a nuben ta, xa ruyon ri ulef nuben chi niq'uiy pe ri tico'n. Pero nabey ya ri ti ral ri trigo nbetz'uc pe. C'ac'ari' niq'uiy ri ruxak, y tek nim chic, ntel pe ri ruwi'. Y pa ruq'uisbel ninoj c'a pe ri ruwi' riq'ui ri rupan. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y tek k'en chic, ri rajaf can yac'ari' yerutek ri rumozos chupan, riche (rixin) chi niquik'et, ruma ya k'ij chic riche (rixin) ri k'atoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y ri Jesús xubij c'a chuka': ¿Achique rubanic xtinbij chrij ri rajawaren ri Dios? ¿Y achoj riq'ui njunumaj wi? ¿Y achique ta cami c'ambel tzij ri nik'alajsan riche (rixin)? ");
INSERT INTO cakWNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xa junan c'a riq'ui ri ija'tz riche (rixin) ri mostaza ri nitic ka pan ulef. Ruma yari' ri ija'tz ri más tak cocoj ri c'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Y xa yari' ri sibilaj nim ntel que chiquiwech ri nic'aj chic ichaj, y yec'oje' ruk'a' ri can ye nima'k. Rumari' ri aj xic' tak chicop ri yebe pa cak'ik' niquibanala' quisoc pa tak ruk'a', ruma chiri' jabel yemujan. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ri Jesús can q'uiy c'a c'ambel tak tzij ri xerucusaj achi'el re' riche (rixin) chi xch'o quiq'ui ri winek, y xutzijoj chique ri janipe' ri yecowin nich'obotej chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Riya' majun c'a ri xubij ta chique ri winek chi man ta xerucusaj c'ambel tak tzij. Yac'a tek ri Jesús nicanaj ca ruyon quiq'ui ri rudiscípulos, Riya' can nuk'alajsaj c'a chiquiwech ri achique ntel wi chi tzij ri c'ambel tak tzij. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y tek xoc c'a pe ri ak'a' chupan ri k'ij ri', ri Jesús xubij chique ri rudiscípulos: Jo', kojk'ax la juc'an chic apo ruchi' ya', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Riya' xerutakala' c'a ca ri winek. Y ruma Riya' can tz'uyul chic chupan ri jucu', can quec'ari' rubanon, xuc'uex el cuma ri rudiscípulos. Y yec'o chuka' nic'aj chic jucu' ri junan xebe el quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y tek ye benak, xpe jun nimalaj cak'ik'. Y ri jucu' ri ye benak wi xuchop ninoj pe chi ya'. Y rumari' xa juba' ma yebe ka chuxe' ya'. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero ri Jesús warnek c'a chupan ri jucu' tek ntajin ri cak'ik' pa ruwi' ri choy. Riya' chrij ca ri jucu' rucanon wi ka jun ruch'equet wi' y chiri' warnek wi. Y xepe c'a ri discípulos xquic'asoj y xquibij c'a chare: ¡Tijonel! Riyoj ya xa yojcom y riyit xa yit warnek, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y ri Jesús xyacatej c'a pe, y xubij chare ri cak'ik' chi tiq'uis el y xubij chare ri ruwi' ya' chi titane' ka. Y queri' xbanatej. Ri cak'ik' xq'uis el, y chuka' ri ruwi' ya' xtane' ka. ");
INSERT INTO cakWNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","C'ac'ari' ri Jesús xubij chique: ¿Achique ruma tek xixibij iwi'? ¿Can ma icukuban ta ic'u'x wuq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yac'a ri discípulos can quixibin qui' y xquic'utula' c'a chiquiwech chrij ri Jesús: ¿Achique c'a chi achi re'? Ruma ri cak'ik' y ri ya' xa can niquinimaj chuka' rutzij. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y ri Jesús y ri ye rudiscípulos xe'apon c'a ri juc'an chic ruchi' choy, ri chiri' pa jun lugar ri Gadara rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y tek ri Jesús xel pe chupan ri jucu', yac'ari' tek xapon jun achi riq'ui ri elenak pe pa camposanto. Y ri achi ri' xa c'o c'a itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri achi ri' can ya c'a ri camposanto ri oconek rachoch, y riya' hasta riq'ui cadena ma ye cowinek ta quichapon, ruma can sibilaj ruchuk'a' c'o. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Can q'uiy c'a mul quiximon ri ruk'a' raken pa ch'ich' y riq'ui chuka' cadena, pero xa yeruc'okpij y yeruk'aj ca. Can majun c'a ri cowinek ta chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Riya' can nibiyaj wi c'a ri pa tak juyu' y pa camposanto, nurek ruchi' y nusocola' ri' riq'ui abej. Can chi pak'ij chi chak'a' c'a ri nubanala' queri' ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y tek riya' xutz'et c'a pe ri Jesús, c'anej c'a c'o wi, pero junanin (anibel) c'a xpe y xoxuque' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y can xurek c'a ruchi' y xubij c'a: Riyit Jesús ri Ruc'ajol ri nimalaj Dios, ¿Achique ruma tek yinanek? Pa rubi' ri Dios nc'utuj jun utzil chawe, chi ma quinach'ujirisaj ta, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ri achi xubij queri' ruma ri Jesús rubin chic c'a chare ri itzel espíritu ri c'o riq'ui ri achi ri', chi tel el. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y xpe ri Jesús xuc'utuj c'a chare: ¿Achique abi'? Y riya' xubij pe: Yoj q'uiy ri nubi', ruma ma nuyon ta riyin, xa can ye q'uiy chuka' ri wachibil yec'o, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y can xuc'utula' c'a utzil chare ri Jesús chi ma querelesaj ta el chupan ri ruwach'ulef ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y chunakajal apo ri lugar ri', sibilaj c'a ye q'uiy ak yetajin yewa' pa ruwi' jun juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y xepe c'a quinojel ri itzel tak espíritu ri yec'o riq'ui ri achi, xquic'utuj utzil chare ri Jesús. Y xquibij c'a chare: Taya' k'ij chake chi yoj-oc quiq'ui la ak yec'o chila', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús can yac'ari' tek xuya' k'ij chique. Y ri itzel tak espíritu can yac'ari' xe'el el y xebe'oc quiq'ui ri ak. Ri ak ri' sibilaj c'a ye q'uiy. Xa juba' ma ye ca'i' mil. Y quinojel ri ak ri' xquichop anin (anibel) pa xulan, chuwech jun juyu' xulan ruwech y choj xebeka c'a pa choy. Can quinojel c'a ri ak ri' xejik' chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Yac'a ri yeyuk'un quiche (quixin) ri ak ri', xaxu (xaxe) wi c'a xquitz'et ca ri xbanatej, xe'anmej; y xbequiyala' ca rutzijol pa tinamit y ri pa tak juyu'. Y ri winek xepe c'a riche (rixin) chi noquitz'eta' ri xbebix ca chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y tek ri winek ri' xe'oka riq'ui ri Jesús, xquitz'et c'a chi ri achi ri xec'oje' itzel tak espíritu riq'ui, tz'uyul, rucusan rutziak y ma nuben ta chic c'a ri achi'el ri rubanon pe. Yac'a ri winek ri' xa xquixibij c'a qui' tek xquitz'et ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri winek c'a ri can xetz'eto ri xbanatej riq'ui ri achi ri xelesex itzel tak espíritu riq'ui y ri xc'ulwachitej quiq'ui ri ak, xquitzijola' c'a chique ri nic'aj chic winek ri ye petenak chutz'etic ri xc'ulwachitej chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Rumac'ari' ri winek xquic'utuj utzil chare ri Jesús chi tel el chiri' chupan ri quilugar. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Y yac'a tek ntoc el ri Jesús pa jucu', ri achi ri xec'oje' itzel tak espíritu riq'ui, xuc'utuj c'a utzil chare ri Jesús chi tuya' k'ij chare riche (rixin) chi nibe riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yac'a ri Jesús ma xrajo' ta. Xa xubij c'a chare: Catzolin chawachoch, y jatzijoj chique ri ye aj pan awachoch ri xuben ri Dios awuq'ui riyit, ruma xjoyowex awech ruma ri Ajaf. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y ri achi xbe c'a y xuchop rutzijoxic ri xuben ri Jesús riq'ui riya'. Riya' xutzijoj c'a chique ri winek ri yec'o pa rucuenta ri ruwach'ulef Decápolis. Y ri winek sibilaj c'a xquimey ri ruc'aslen ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ri Jesús y ri discípulos xe'oc chic c'a el pa jucu' y xek'ax c'a juc'an chic ruchi' ya'. Y tek xe'apon, sibilaj c'a ye q'uiy winek ri xquimol apo qui' riq'ui. Riya' chuchi' c'a ri choy xc'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xapon c'a chuka' jun achi ri Jairo rubi'. Ri achi c'a ri' jun chique ri principali' chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Y tek riya' xutz'et apo ri Jesús, can yac'ari' xbexuque' xbemaje' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y c'ac'ari' xubij chare ri Jesús: Ri ti numi'al yawa', y ya xa juba' ma nicom ka. Tabana' c'a jun utzil jaya' ri ak'a' pa ruwi' riche (rixin) chi nic'achoj y ma nicom ta, xcha'. Y riya' can xuc'utula' c'a utzil chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y ri Jesús can xbe wi c'a. Y can sibilaj ye q'uiy c'a winek ri xetzeke' el chrij. Y rumari' niquipitz'ila' c'a qui' chrij, ye benak. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y chiquicojol c'a ri winek ri' benak c'a chuka' jun ixok ri c'o jun ruyabil riche (rixin) ic' chare. Ri ixok ri' c'o chic c'a cablajuj juna' ri ma tanel ta ri ruquiq'uel. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Riya' rutijon c'a pokon ruma benak chic quiq'ui q'uiy ajk'omanela' y xuq'uis yan chuka' ronojel rurajil; y ma xc'achoj ta juba' chare ri ruyabil, xa más xnimatej. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ri ixok ri' c'o c'a rac'axan pe chrij ri milagros ri yeruben ri Jesús. Riya' benak c'a chuka' chiquicojol ri winek ri yec'o ca chrij ri Jesús, y yac'ari' tek xberuchapa' ca juba' ri rutziak ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ruma ri ixok ri' can rubilon c'a pe pa ránima: Xa riq'ui ta nchop el juba' rutziak ri Jesús, yic'achoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y can xu (xe) wi xuchop rutziak ri Jesús, can yac'ari' xk'atak'o ri ruquiq'uel. Riya' can xuna' c'a chi xc'achoj chare ri ruyabil ri ruc'ulwachin. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Y ri Jesús can chanin c'a xuna' chi c'o jun xuc'achojsaj riq'ui ri uchuk'a' ri xel el riq'ui. Rumari' xtzu'un chrij, y xubij chique ri winek: ¿Achique c'a xchapo nutziak chuwij? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Y ri discípulos xquibij c'a chare: Riyit nawajo' nawetamaj achique xchapo ri atziak, pero re wawe' ma xtawetamaj ta. Ye'atz'et chi re winek yatquipitz', y riyit nac'utuj: ¿Achique xichapo? ");
INSERT INTO cakWNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yac'a ri Jesús yerutzula' c'a ri winek, nucanoj ri achique xchapo rutziak. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y ri ixok ruxibin ri' y nibarbot (nibaybot) c'a ruma xa ya riya' ri xchapo ri rutziak ri Jesús, y can xc'achoj wi chare ri ruyabil. C'ac'ari', riya' xoxuque' xomaje' chuwech ri Jesús y xubij c'a ronojel ri achique xuben. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y ri Jesús xubij chare ri ixok: Numi'al, xac'achoj, ruma xacukuba' ac'u'x wuq'ui. Wacami c'a, catzolin; ya xawil yan uxlanibel c'u'x. Y can riche (rixin) jurayil xac'achoj chare ri ayabil ri awilon pe, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y c'a ntajin na c'a nitzijon ri Jesús riq'ui ri ixok, tek yec'o ri xe'oka ri ye petenak chrachoch ri Jairo ri principal chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Ri achi'a' ri xe'oka, xoquibij c'a chare ri Jairo: Ri ti ami'al xa xcom yan y ma rajawaxic ta chic nac'uaj el ri Tijonel, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yac'a tek ri Jesús xrac'axaj pe, chanin xubij chare ri achi ri principal chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios: Ma taxibij ta awi' ruma ri xobix chawe. Xaxu (xaxe wi) tacukuba' ac'u'x wuq'ui, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús ma xuya' ta k'ij chi yec'o ta chic nic'aj ri xetzeke' ta el chrij, xaxu (xaxe) wi c'a ri Pedro, ri Jacobo y ri Juan ri rach'alal ri Jacobo, ri xeruc'uaj el. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y ri Jesús ye rachibilan ri ye oxi' rudiscípulos xebe c'a chrachoch ri achi ri principal chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Y tek xe'apon c'a, ri Jesús xerutz'et chi ri winek yech'ujlan pa jay, y xerutz'et chuka' chi ye'ok' y can niquirek quichi' chi ok'ej. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Tek ri Jesús xoc c'a apo, xubij chique ri winek: ¿Achique ruma yixok' y yixch'ujlan? Ri ac'al ma caminek ta, riya' xa warnek, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yac'a riye' xa xetze'en chrij ri Jesús, ruma quetaman chi ri ti k'opoj ri' xa can caminek chic. Xpe c'a ri Jesús xerelesaj c'a pe ri winek. C'ac'ari' Riya' xerucusaj apo ri rute' rutata' ri ti k'opoj y ri ye oxi' chic ri ye benak riq'ui, chupan ri jay ri acuchi (achique) c'o wi ri ruch'acul ri ti k'opoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Riya' xuchop c'a ruk'a' ri ti caminek y xch'o pa jun chic ch'abel, y xubij: Talita cumi, xcha'. Re tzij re' ntel chi tzij: Nóya, chawe riyit nbij wi chi cayacatej. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Can xu (xe) wi c'a xubij queri' ri Jesús, can yac'ari' xyacatej y xbiyaj el ri ti k'opoj, ruma xa can cablajuj chic c'a rujuna'. Y ri yec'o riq'ui, xquimey tek xquitz'et chi xc'astej pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yac'a ri Jesús can xuchilabej chique chi majun achoj chare tiquitzijoj wi y chuka' xubij chi titzuj (tisuj) ruway. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y ri Jesús ye rachibilan ri discípulos xe'el el ri chiri' y xebe pa Nazaret ri tinamit ri xq'uiy wi Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y tek xapon c'a ri uxlanibel k'ij, xuchop c'a ruc'utic ri ruch'abel ri Dios ri pa jay ri kas nic'ut wi ri ruch'abel ri Dios. Ruma c'a ri ch'abel ri yerubij chique, ri winek ri' can xquimey c'a y xquibij: ¿Achique c'a ruma re achi re' sibilaj q'uiy etamabel c'o riq'ui y nicowin yeruben milagros? ¿Achique modo tek nicowin nuben ronojel re'? ");
INSERT INTO cakWNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ruma re achi re', xa yare' ri aj samajel chrij che', ral ri María, cach'alal ri Jacobo, ri José, ri Judas y ri Simón. Y ri ye rana' xa yec'o chkacojol, xecha'. Rumari' ri winek can ma xquinimaj ta ri Jesús, ruma Riya' aj chiri' pa quitinamit. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y ri Jesús xubij c'a chique ri winek ri': Majun c'a jun profeta ri nik'alajsan ri ruch'abel ri Dios ri man ta jun ruk'ij. Quinojel can c'o wi quik'ij, xa yac'a chi ma niya'ox (nya') ta quik'ij pa tak quitinamit, ni cuma ri cach'alal y ni cuma chuka' ri aj pa cachoch, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ri Jesús ma q'uiy ta c'a milagros xuben chupan ri tinamit ri xq'uiy wi Riya'. Xaxu (xaxe wi) oc ca'i' oxi' yawa'i' ri xuya' ruk'a' pa quiwi' y queri' xeruc'achojsaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y Riya' can xumey ruma xerutz'et chi ri winek ri aj chiri' pa rutinamit, xa can ma niquinimaj ta. Riya' xbe c'a ri pa tak aldea ri yec'o pe chunakajal ri rutinamit, y xuc'ut c'a ri ruch'abel ri Dios chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","C'ac'ari' ri Jesús xerusiq'uij (xeroyoj) c'a ri cablajuj discípulos. Y chi caca' xuchop el quitakic chubanic ri samaj, y xuya' el k'atbel tzij pa quik'a' riche (rixin) chi yecowin yequelesaj ri itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y Riya' xubij c'a chuka' el chique chi xaxu (xaxe) wi ri quich'ame'y tiquic'uaj el y majun chic ri tiquic'uaj el. Ma tiquic'uaj ta ya'l, ma tiquic'uaj ta caxlan wey y chuka' can ma tiquic'uaj ta el quirajil ri pa tak ximibel quipan. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ma tiquicusaj ta el ca'i' quitziak. Pero utz chi niquicusaj el ri quixajab. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ri Jesús xubij c'a chuka' chique ri discípulos: Xabachique ta na tinamit ri yixapon wi; tek yixoc pa jun jay, chiri' quixc'oje' wi ka. Xa can c'a ya tek yixel pe chupan ri tinamit ri', c'ac'ari' utz chi niya' ca ri jay ri xixc'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y ri acuchi (achique) yixapon wi, wi ri winek ma nicajo' ta yixquic'ul, y ma nicajo' ta chuka' niquic'axaj ri ruch'abel ri Dios ri nitzijoj riyix chique, can quixel c'a pe chiri', y titotala' (tiquirala') ca ri pokolaj ri c'o chiwaken chiquiwech ri winek ri', riche (rixin) tiquetamaj chi ma utz ta ri xquiben. Ruma can nbij wi c'a chiwe, chi chupan ri k'ij tek xtibanatej ri k'atoj tzij, más xtik'ax wi c'a ruwi' ri ruc'ayewal ri xtika pa quiwi' ri winek riche (rixin) ri tinamit ri can ma xquixquic'ul ta, que chuwech ri Sodoma y Gomorra, xcha' el chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y ri discípulos xebe c'a. Riye' xquibij c'a chique ri winek chi titzolin pe quic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Y ri discípulos q'uiy c'a itzel tak espíritu ri xequelesala'. Y chuka' xquiyala' aceite pa quiwi' ye q'uiy yawa'i' y xequic'achojsaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Y ri rey Herodes can xrac'axaj c'a chi ri Jesús sibilaj rutzijol c'o chiquicojol ri winek. Ri Herodes xubij c'a ka pa ránima chi ri Jesús xa ya ri Juan ri Bautista ri xc'astej pe chiquicojol ri caminaki', y rumari' tek c'o uchuk'a' pa ruk'a' riche (rixin) chi q'uiy ri nicowin yerubanala', xcha' ka ri Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero yec'o c'a chique ri winek ri xquibij chi ri Jesús xa ya ri Elías. Y yec'o nic'aj chic xquibij chi Riya' jun achi profeta ri nik'alajsan ri ruch'abel ri Dios y chuka' xquibij chi Riya' jun chique ri achi'a' ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Yac'a tek ri rey Herodes xrac'axaj c'a ri', xubij: Ri Jesús xa ya ri Juan ri Bautista ri xintek rutzaq'uixic rujolon (ruwi'), ri xc'astej pe chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ruma chi xa can ya c'a ri rey Herodes ri xbin chi tichapatej ri Juan. Y c'ac'ari' xuya' pa cárcel y xxime' pa cadena. Ruma ri Herodes ruc'amon ka ri Herodías rixjayil ri Felipe, y ri Felipe ri' xa can rach'alal ri Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Y ri Juan rubin chare ri Herodes: Ma utz ta abanon chi ac'amon ka rixjayil ri awach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Y ri Herodías can rajowan wi c'a chi rucamisan ta ri Juan ruma itzel nuna' chare, pero ma cowinek ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ruma ri rey Herodes can retaman wi c'a chi ri Juan can choj wi y jun lok'olaj achi riche (rixin) ri Dios; y rumari' can nuxibij c'a ri' chuwech ri Juan. Can ma ruya'on ta c'a k'ij riche (rixin) chi c'o ta ruc'ulwachin. Ri Herodes can jabel wi c'a nrac'axaj tek ri Juan nutzijoj ri ruch'abel ri Dios chare. Xa yac'a chi ma nich'obotej ta c'a chuwech ri achique ruc'amon chi nuben. Pero ma riq'ui wi ri', riya' can jabel wi c'a nrac'axaj ri nibix chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Y ri k'ij c'a ri oyoben ruma ri Herodías riche (rixin) chi nika ri Juan pa ruk'a', xoka c'a. Chupan ri k'ij tek ri rey Herodes xtz'aket chic jun rujuna', ri Herodes ri' xuya' jun wa'in y xerusiq'uij (xeroyoj) c'a ri aj k'atbel tak tzij ri yec'o pa ruk'a', xerusiq'uij (xeroyoj) chuka' ri achi'a' ri can c'o quik'ij chiquicojol ri soldados y xerusiq'uij (xeroyoj) ri achi'a' ri c'o quik'ij chiquicojol ri aj Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y ri acuchi (achique) c'a quimolon wi qui' riye', xoc c'a apo jun k'opoj, ral ri Herodías; y ri k'opoj ri' xxajo chiquiwech. Y ri xajoj ri xuben sibilaj xka chuwech ri rey Herodes y chiquiwech quinojel ri yewa' riq'ui. Y ri Herodes xubij c'a chare ri k'opoj: Tac'utuj c'a ri achique nawajo' y xtinya' chawe. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ri rey Herodes can xuben c'a jurar chare, y xubij: Xabachique c'a ri xtac'utuj chuwe, xtinya' chawe, astape' ta na chi can pa nic'aj chare re ruwach'ulef ri c'o pa nuk'a', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Y xel el ri k'opoj y xberubij chare ri rute': ¿Achique ri utz chi nc'utuj? xcha'. Y ri te'ej xubij c'a chare: Tac'utuj chi tiya'ox (tya') pe chawe ri rujolon (ruwi') ri Juan ri Bautista. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y ri k'opoj can yac'ari' xtzolin apo riq'ui ri rey Herodes y xberubij c'a chare: Riyin nwajo' chi ya re wacami yan, naya' pe chuwe pa jun plato ri rujolon (ruwi') ri Juan ri Bautista, xcha' chare ri rey Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y ri rey Herodes can xpe bis pa ránima ruma ri xc'utux chare, pero ruma c'a chi can rubanon chic jurar chi can xtuya' wi ri xtrajo' ri k'opoj y ruma chuka' chi can chiquiwech ri ye rachibilan pa mesa tek xubij, rumari' can c'o c'a chi nuben ri nic'utux chare, y queri' ma nuya' (nutzek) ta ruq'uix. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y ri rey can yac'ari' tek xutek el jun soldado riche (rixin) chi tic'amer pe ri rujolon (ruwi') ri Juan ri Bautista. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ri soldado xbe c'a, xberutzaq'uij pe rujolon (ruwi') ri Juan ri Bautista pa cárcel y xuc'om c'a pe chare ri k'opoj pa jun plato y ri k'opoj xberuya' chare ri rute'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tek ri rudiscípulos ri Juan xquic'axaj chi xcamisex, xebe c'a chuc'amaric ri ruch'acul, y xbequimuku' ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri ye ru'apóstoles ri Jesús tek xetzolin pe chubanic ri rusamaj ri Dios, can xquimol apo qui' riq'ui ri Jesús y xquitzijola' c'a chare ronojel ri xquibanala' y ronojel ri tijonic ri xquiyala' chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y ri Jesús xubij c'a chique: Jo' pa jun lugar ri acuchi (achique) majun winek c'o riche (rixin) chi yixuxlan juba'. Y queri' xubij chique ruma can ye q'uiy c'a winek ri ye'el ye'oc quiq'ui y rumari' hasta ma utz ta chic chi yewa'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y ri Jesús y ri rudiscípulos xe'oc c'a el pa jun jucu' riche (rixin) chi xek'ax c'a juc'an chic ruchi' ya', y xebe c'a pa jun desierto. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Yac'a tek riye' xe'el el, ye q'uiy c'a winek ri xetz'eto el y can xquetamaj el quiwech. Rumari' ri winek junanin (anibel) xebe chicaken, xquimolola' el qui' pa bey; ri pa tak tinamit ri xek'ax wi el. Y xa ye riye' ri xe'apon nabey. Y tek ri Jesús y ri rudiscípulos xe'apon, ri winek xquimol c'a apo qui' chiquij. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y tek ri Jesús xel pe chupan ri jucu', xutz'et c'a chi sibilaj ye q'uiy winek yec'o chiri' coyoben apo. Riya' xujoyowaj c'a quiwech, ruma quibanon achi'el c'a ri carne'l tek majun niyuk'un quiche (quixin), y xuchop c'a nuc'ut q'uiy chiquiwech ri nic'atzin chi niquetamaj chrij ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Yac'a tek xka ka más ri k'ij, ri rudiscípulos ri Jesús xejel apo riq'ui y xquibij chare: Re wawe' xa majun c'o y xa xka ka k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Que'ataka' c'a el re winek re' riche (rixin) chi yebe ri pa tak aldea y pa tak nic'aj chic lugar ri yec'o pe nakaj, riche (rixin) chi nbequilok'o' quiway, ruma xa majun quiway riche (rixin) chi niquitij, xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yac'a ri Jesús xubij chique ri rudiscípulos: Tiya' quiway riyix, xcha' chique. Y riye' xquibij: ¿Riyit nabij chi yojbe chulok'ic ca'i' ciento denarios caxlan wey riche (rixin) chi yewa' riye'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y Riya' xuc'utuj c'a chique: ¿Janipe' caxlan wey c'o iwuq'ui? Je'itz'eta' na c'a. Y tek riye' quitz'eton chic ca, xquibij: C'o wu'o' caxlan wey y ca'i' car, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Y c'ac'ari' Riya' xubij chique ri rudiscípulos chi tiquibij chique ri winek chi quetz'uye' quinojel pa ruwi' ri rexlaj k'ayis, y pa tak moc quetz'uye' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y ri winek ri' can xetz'uye' c'a pa ruwi' ri k'ayis, y xquic'uala' c'a qui' pa tak ciento y pa nic'aj tak ciento. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xeruli'ej c'a pa ruk'a' ri wu'o' caxlan wey y ri ca'i' car y c'ac'ari' xtzu'un chicaj y xuc'utuj ri rubendición ri Dios pa ruwi'. Y c'ac'ari' xeruwech'ela' c'a el ri caxlan wey, y xuya' el chique ri discípulos riche (rixin) chi niquiya' chique ri winek. Y queri' chuka' xuben riq'ui ri car. Xujech c'a chiquiwech quinojel. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Can quinojel c'a jabel xewa'. Can majun c'a ri man ta xwa' chi utz. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y c'a c'o na c'a cablajuj chaquech caxlan wey rachibilan car ri xmolotej ca, ri ma xq'uis ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Sibilaj ye q'uiy c'a ri winek ri xewa' ruma xaxu (xaxe) wi ri achi'a' yec'o wu'o' mil. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Yac'ari' tek ri Jesús xerucusaj el ri rudiscípulos chupan ri jucu', riche (rixin) chi yenabeyej el chuwech; chi quebe c'a pa Betsaida, tinamit ri c'o juc'an chic ruchi' ya'. Y Riya' xerutek na c'a el ri winek chi tak cachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y tek ri Jesús ye ruch'aben chic c'a ca ri winek, xbe pa ruwi' jun juyu' chubanic orar. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Tek xoc c'a pe ri ak'a', ri discípulos ri ye benak pa jucu', pa runic'ajal chic c'a ri choy yec'o wi. Y ri Jesús ruyonil c'a c'o na ca pa ruwi' ri ulef ruma xa ma benak ta quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y ri Jesús xerutz'et c'a chi ri rudiscípulos ye cosnek chic y ma yecowin ta niquiben chare ri jucu' chi nibiyin chiquiwech, ruma ri cak'ik' nupaxij ri' chuwech ri jucu' y nutzolij c'a. Y tek xa ruchapon c'a pe rusekeric, ri Jesús petenak c'a chraken pa ruwi' ri choy, y nrajo' c'a nik'ax el chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Yac'a tek ri discípulos xquitz'et chi c'o jun petenak chraken pa ruwi' ri choy, xquirek quichi' y xquibila' c'a chiquiwech chi achique c'a la', xecha'. Ruma riye' xquibij chi ri petenak pa ruwi' ri choy xa jun subunel (xibinel). ");
INSERT INTO cakWNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y ruma can quinojel c'a xetz'eto, xquixibij qui'. Y rumari' ri Jesús chanin xch'o apo chique y xubij: Ma tixibij ta iwi'. Xa ticukuba' ic'u'x. Xa yin c'a riyin, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y Riya' xoc c'a el quiq'ui ri pa jucu'. Y can yac'ari' tek xtane' ri cak'ik'. Y ri discípulos xsach quic'u'x tek xquitz'et ri xbanatej y sibilaj xquimey. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Y astape' can xquitz'et tek ri Jesús xuq'uiyirisaj ri caxlan wey, riye' ma k'axnek ta chiquiwech chi Riya' can nicowin wi nuben xabachique, ruma can c'o ruchuk'a'. Riye' c'a cowirnek na ri cánima. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y riye' xek'ax c'a pa ruwi' ri choy ri' y xe'apon ri chuchi' ya' chiri' pa Genesaret. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y xu (xe) wi xe'el pe pa jucu', ri winek ri yec'o chiri' chuchi' ya', chanin c'a xquetamaj ruwech chi ya ri Jesús ri xel pe pa jucu'. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rumari' xquelesaj c'a rutzijol pa ronojel lugar ri yec'o pe nakaj, chi ri Jesús c'o chiri'. Y ri winek xequic'amala' c'a pe ri quiyawa'i'. Can ronojel wi c'a lugar xec'amalox wi pe yawa'i'; y chuwech c'a ri quiwarabel ye quic'amalon wi pe, y xequic'amala' pe chuwech ri Jesús ri acuchi (achique) niquic'axaj chi c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y xabacuchi (xabachique) xapon wi, ri pa nima'k tak tinamit, pa tak aldeas y ri pa tak juyu' chuka', ri winek xequiyala' ri yawa'i' pa tak bey ri nik'ax wi Riya'. Can niquic'utuj c'a utzil chare ri Jesús chi tuya' k'ij chique chi astape' xaxu (xaxe) ta wi ri ruchi' rutziak ri niquichop riche (rixin) chi yec'achoj y can queri' wi c'a xbanatej. Can quinojel c'a ri xechapo ruchi' rutziak ri Jesús, xec'achoj chare ri quiyabil. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chrij c'a ri Jesús xquimol c'a apo qui' ri achi'a' fariseos, y chuka' ca'i' oxi' aj tz'iba' ri ye petenak ri pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y tek ri achi'a' ri' xequitz'et chi yec'o chique ri rudiscípulos ri Jesús ri yetajin chi wa'in y xa ma xquich'ej ta quik'a' achi'el rubanic ri niquiben riye', ma utz ta xequitz'et, y rumari' q'uiy c'a ri xquibij chiquij. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ruma ri fariseos y quinojel ri nic'aj chic winek israelitas, xa ya ri ye quibin ca ri cati't quimama', xa yari' ri yequibanala'. Ruma wi xa ma niquich'ej ta q'uiy mul ri quik'a', can ma yewa' ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tek yetzolin c'a pe ri pa tak c'aybel, wi ma niquich'ajch'ojsaj ta qui', can ma yewa' ta. Y c'o c'a nic'aj chic ri ye quibin ca ri cati't quimama' ri yequibanala', achi'el ri achique rubanic ri quijosk'ixic ri kumbel tak ya', ri xára, ri ch'ich' tak lek y ri achique chuka' rujosk'ixic niquiben chare ri quiwarabel. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumari' ri fariseos y ri aj tz'iba' xquic'utuj c'a chare ri Jesús: ¿Achique c'a ruma tek la adiscípulos riyit ma niquiben ta achi'el ri bin ca cuma ri kati't kamama'? Ruma la adiscípulos riyit tek yewa' ma niquich'ej ta quik'a', achi'el rubanic ri nikaben riyoj, xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yac'a ri Jesús xubij chique ri achi'a' ri': Riyix xa ca'i' ipalej. Xa can jabel c'a rubixic rubanon ca ri Isaías chiwij. Ruma ri Isaías rutz'iban c'a ca ri xbix chare ruma ri Dios, y quec'are' ri nubij: Re winek re' xaxu (xaxe) wi c'a riq'ui ri quich'abel niquiya' nuk'ij, yac'a ri cánima xa nej c'o wi el chuwe riyin. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa majun c'a nic'atzin wi chi niquiya' nuk'ij, ruma ri ch'abel ri niquic'ut xa pixa' quiche (quixin) winek y niquibij chi can yari' ri rajawaxic chi niban. Queri' ri rutz'iban ca ri Isaías, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y riyix yari' ri yixtajin chubanic. Xa iya'on ca ri rupixa' ri Dios ri c'o chi niben. Riyix can ma niben ta c'a ri nrajo' ri Dios, xa ya ri niquibij ri winek, xa yari' ri yixtajin chubanic. Achi'el tek nibij ri achique quijosk'ixic ri xára y ri achique quijosk'ixic ri kumbel tak ya'. Y yec'o chuka' nic'aj chic ye achi'el ri', ri ye'ibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y ri Jesús xubij chuka' chique: Riyix riche (rixin) chi niben ri achique ye quibin ca ri iwati't imama', can niben chare ri rupixa' ri Dios chi majun rejkalen. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ruma ri ch'abel ri ye rutz'iban ca ri Moisés, nubij: Taya' quik'ij ri ate' atata'. Y wi c'o jun nibin pokon tak ch'abel chique ri rute' rutata', can majun chic c'a ri nrajo', xa can ticamisex. Quec'ari' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Yac'a riyix xa ma que ta ri' ri niben y nic'ut. Xa ma niben ta achi'el ri rubin ca ri Dios. Riyix xa ye'itijoj ri alc'ualaxela' chi ma rajawaxic ta chi yequito' ri quite' quitata'. Riyix xa nibij chique ri alc'ualaxela' chi xa tiquibij chique ri quite' quitata': Riyin ma yicowin ta yixinto' riq'ui ri nic'atzin chiwe, ruma ri c'o wuq'ui xa ntzujun (nsujun) chic chare ri Dios, yixcha' chique. Y riq'ui niquibij queri' chi quitzujun (quisujun) chic chare ri Dios, xa riche (rixin) chi ma yequito' ta ri quite' quitata'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riq'ui ri nibij, can nik'alajin wi chi riyix niben chique ri alc'ualaxela' chi majun chic tiquiya' chique ri quite' quitata'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Y riq'ui ri', riyix ibanon chare ri rupixa' ri Dios chi majun rejkalen. Y queri' ibanon xaxu (xaxe) wi riche (rixin) chi niben ri achique quibin ca ri iwati't imama'. Y yec'o chuka' nic'aj chic achi'el re' ri ye'ibanala'. Queri' xubij ri Jesús chique ri achi'a' fariseos y ri ye aj tz'iba'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Can yac'ari' tek ri Jesús xerusiq'uij (xeroyoj) apo quinojel ri winek riq'ui, ri quimolon qui' chiri', y xubij c'a chique: Tiwac'axaj c'a chi'iwonojel re xtinbij chiwe y tik'ax chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ri nitz'ilobisan riche (rixin) ri winek, ma ya ta c'a ri nutij ka. Xa ya ri itzel ri yepe pa ránima ri nitz'ilobisan riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y Riya' xeruya' c'a ca ri winek, y xbe pa jun jay. Y ri discípulos xquic'utuj c'a chare chrij ri c'ambel tzij ri nich'o chrij ri nitz'ilobisan riche (rixin) jun winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y ri Jesús xubij c'a chique: ¿Riyix chuka', can c'a ma jane nik'ax ta chiwech ri nbij? ¿La ma nik'ax ta c'a chiwech chi ronojel ri nutij ka ri winek ma ya ta ri' ri nitz'ilobisan riche (rixin)? ");
INSERT INTO cakWNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ruma ronojel ri achique nutij ka ri winek, xa ma pa ránima ta nibe wi. Xa chupan nibe wi y c'ac'ari' ntel el. Y riq'ui ri queri' xubij ri Jesús, nik'alajin chi ronojel ri yec'o ca riche (rixin) chi yetij, can ye ch'ajch'oj wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ri Jesús xubij chuka' chi xa ya ri itzel ri yepe pa ránima ri winek, xa yari' ri nitz'ilobisan riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ruma xa pa ránima c'a ri winek yepe wi ri itzel tak na'oj, achi'el tek jun ixok c'o rachijil y xa nuc'om ruwech jun chic achi y achi'el tek jun achi c'o rixjayil y nucanoj jun chic ixok, y achi'el chuka' ri winek yemacun y xa ma quic'ulaj ta qui'. Y pa cánima chuka' nipe wi ri na'oj tek yecamisan. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pa tak cánima c'a ri winek nipe wi ri jalajoj ruwech itzel tak na'oj, achi'el tek ye'elek', tek niquirayij chi ronojel ta cosa quiq'ui ta riye' c'o wi, yequibanala' etzelal, yek'olon, ri achi'a' y ri ixoki' yequibanala' mac ri sibilaj q'uixbel, itzel niquina' chare jun winek ri utz c'o, yequibila' itzel tak ch'abel chiquij ri nic'aj chic, ri niquina' chi can c'o quik'ij, y ri ma yech'obon ta jabel. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel c'a ri etzelal achi'el ri', pa ránima c'a ri winek yepe wi, y yac'ari' ri nitz'ilobisan riche (rixin). Quec'ari' xubij ri Jesús chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Y ri Jesús ye rachibilan ri rudiscípulos xel c'a el ri chiri', y xbe c'a quela' pa jun lugar ri nakaj nicanaj chique ri tinamit Tiro y Sidón. Y xc'oje' c'a pa jun jay, ruma ma nrajo' ta c'a chi netamex chi Riya' c'o chiri'. Pero ma riq'ui wi ri', chanin xnabex chi c'o chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Can chanin c'a xnabex pe ruma jun ixok ri c'o jun ral ti k'opoj, ri c'o jun itzel espíritu riq'ui. Ri ixok ri' can xu (xe) wi c'a xrac'axaj pe chi ri Jesús c'o chiri', riya' xpe c'a riq'ui y xoxuque' xomaje' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri jun ixok ri' ma israelita ta. Riya' jun aj sirofenicia. Pero xoxuque' chuwech ri Jesús riche (rixin) chi xoruc'utuj jun utzil chare chi trelesaj el ri itzel espíritu ri c'o riq'ui ri ral. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Yac'a ri Jesús xubij chare ri ixok: Ri rutzil ri Dios ma utz ta chi chare xabachique niya'ox (nya') wi. C'o chi ya ri nuwinak israelitas yento' nabey. Ruma ma ruc'amon ta chi nelesex ri quiway ri alc'ualaxela' riche (rixin) chi niya'ox (nya') chique ri tak tz'i', xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Y ri ixok xubij c'a chare ri Jesús: Ajaf, can kitzij wi ri nabij. Pero chuka' riyoj utz nikac'ul apo juba' chare ri utzil ri'. Achi'el niquiben ri tak tz'i' chuxe' ri mesa, yequimolola' chuka' ri ruc'aj tak caxlan wey ri yequitzakala' ka ri ac'ala'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y ri Jesús can yac'ari' xubij chare ri ixok: Ri xabij can queri' wi. Wacami catzolin c'a, ruma ri itzel espíritu xel yan el riq'ui ri awal, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y ri ixok xtzolin c'a chrachoch. Y xberila' ri ral cotz'ol pa ch'at. Y chanin chuka' xutz'et chi ri itzel espíritu man c'o ta chic riq'ui ri ral. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ri Jesús ye rachibilan ri rudiscípulos xel c'a pe chupan ri lugar ri nakaj nicanaj chare ri tinamit Tiro y xbek'ax pe pa Sidón. Y xbek'ax pe chuka' pa Decápolis, c'ac'ari' xoka chuchi' ri choy Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiri' c'a c'o wi ri Jesús tek xbeya'ox (xbeya') jun achi chuwech, jun achi ri ma nac'axan ta y ma ntel ta jabel ruch'abel. Y ri ye c'amayon pe, xquic'utuj c'a jun utzil chare ri Jesús chi tuya' ruk'a' pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ri Jesús xrelesaj c'a el ri achi ri' chiquicojol ri winek y xuju' ruwi' ruk'a' pa tak ruxquin. C'ac'ari' ri Jesús xchuban, y xuya' chuka' apo ruwi' ruk'a' pa ruwi' rak' ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y ri Jesús xtzu'un chicaj, xjik'jo'x (xjik'jo't) ránima y xubij: Efata. Re tzij re' nubij c'a: Tijakatej. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ri achi can yac'ari' tek xac'axan y xel ri ruch'abel jabel. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xuc'om c'a pe ri achi y xuchilabej chique ri winek chi majun achoj chare tiquibij wi ri xbanatej. Yac'a ri winek, ma riq'ui ta chi can bin chique ruma ri Jesús chi majun achoj chare tiquibij wi, riye' xa yari' ri más xquitzijoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Y ri winek ri' can xquimey tek xquitz'et ri xbanatej, y xquibila' c'a: Jabel ri xuben. Nuben c'a chique ri ma ye'ac'axan ta, chi ye'ac'axan; y nuya' chuka' quich'abel ri ye mema', xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupan c'a ri tiempo ri' xbanatej c'a chi sibilaj ye q'uiy winek quimolon apo qui' riq'ui ri Jesús y ri winek ri' xq'uis c'a quiway. Rumari' ri Jesús xerusiq'uij (xeroyoj) c'a ri rudiscípulos y xubij c'a chique: ");
INSERT INTO cakWNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Riyin sibilaj njoyowaj quiwech re winek re', ruma c'o chic oxi' k'ij yec'o pe wuq'ui y wacami majun chic quiway riche (rixin) chi niquitij. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y yentek ta c'a el chi tak cachoch y xa majun niquitij el, ma utz ta. Ruma yec'o nej ye petenak wi, y riq'ui juba' yetzak pa tak bey ruma wayjal, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Y ri rudiscípulos xquibij c'a chare: Re acuchi (achique) yojc'o wi xa majun c'o. ¿Acuchi (achique) ta c'a nbekila' wi pe wey riche (rixin) chi yekatzuk jabel re winek re'? xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Y ri Jesús xuc'utuj c'a chique ri rudiscípulos: ¿Janipe' caxlan wey c'o iwuq'ui? xcha' chique. Y riye' xquibij c'a: C'o wuku', xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Y ri Jesús xubij c'a chique ri winek chi quetz'uye' ka ri pan ulef. Yac'ari' tek Riya' xeruli'ej ri wuku' caxlan wey y tek rumatioxin chic chare ri Dios, c'ac'ari' xeruwech'ela' y xuyala' el chique ri rudiscípulos riche (rixin) chi niquiya' chique ri winek. Y ri rudiscípulos can xquiya' wi chique ri sibilaj winek ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y c'o c'a chuka' ca'i' oxi' tak car quiq'ui. Y ri Jesús xuc'utuj ri rubendición ri Dios pa ruwi', y c'ac'ari' xutek rujachic chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri winek can jabel c'a xewa'. Can majun c'a ri man ta xwa' chi utz y c'a c'o na c'a wuku' chaquech caxlan wey rachibilan car ri xmolotej ca, ri ma xq'uis ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xquiben wa'in chupan ri k'ij ri', achi'el xa caji' mil winek. Y c'ac'ari' ri Jesús xerutek el ri winek chi tak cachoch. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Y can yac'ari' tek ri Jesús xoc el pa jucu' quiq'ui ri rudiscípulos y xebe c'a pa jun lugar Dalmanuta rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y yec'o c'a chique ri achi'a' fariseos ri xe'apon riq'ui ri Jesús, y xquichop c'a qui' riq'ui ch'abel riq'ui Riya'. Y riche (rixin) chi niquitojtobej, xquibij c'a chare chi tubana' c'a chi c'o jun retal nibanatej chuwech ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yac'a ri Jesús xjik'jo'x (xjik'jo't) ránima y c'ac'ari' xubij: ¿Achique c'a ruma re winek re yec'o re wacami nicajo' niquitz'et chi c'o jun retal nibanatej chuwech ri caj? Riyin can kitzij c'a nbij chiwe chi ma ya ta ri nicajo' riye' ri xtibanatej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y ri Jesús xeruya' c'a ca ri fariseos, y xoc el pa jucu' quiq'ui ri rudiscípulos riche (rixin) chi xek'ax c'a juc'an chic ruchi' ya'. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y ri discípulos xquimestaj c'a xquic'uaj quiway, y chiri' pa jucu' xaxu (xaxe wi) c'a jun caxlan wey c'o ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y ri Jesús xubij c'a chique ri rudiscípulos: Can tiwac'axaj c'a re xtinbij chiwe, chi can tichajij c'a iwi' chuwech ri ch'om (levadura) quiche (quixin) ri fariseos y riche (rixin) ri Herodes, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yac'a ri discípulos xa xquibila' c'a chiquiwech: Riya' xubij queri' ruma majun caxlan wey xkac'om pe riche (rixin) chi nikatij, xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yac'a ri Jesús can retaman c'a ri niquibila' ka chiquiwech ri rudiscípulos, y rumari' xubij c'a chique: ¿Achique ruma riyix nich'ob chi ruma majun caxlan wey iwuq'ui, rumari' tek xinbij queri'? ¿La ma xk'ax ta c'a chiwech ri xinbij? ¿Xa can c'a cowirnek na ri iwánima, rumari' chi ma nik'ax ta chiwech? ");
INSERT INTO cakWNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Riyix c'o runak' tak iwech, pero achi'el xa ma yixtzu'un ta. C'o ixquin, pero achi'el xa ma yixac'axan ta. ¿Can ma ninatej ta c'a chiwe? ");
INSERT INTO cakWNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Tek riyin xentzuk ri wu'o' mil winek riq'ui ri wu'o' caxlan wey ri xinwech' chiquiwech, ¿janipe' chaquech ri xe'inojsaj riq'ui ri caxlan wey ri ximol ca? xcha' chique. Y ri discípulos xquibij c'a chare ri Jesús: Cablajuj chaquech, xecha' apo. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Y ri Jesús xubij: Tek riyin xentzuk ri caji' mil winek riq'ui ri wuku' caxlan wey, ¿janipe' chuka' chaquech ri xe'inojsaj riq'ui ri caxlan wey ri ximol ca? xcha' chique. Y ri discípulos xquibij c'a chare ri Jesús: Wuku' chaquech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xubij c'a chique: ¿Y achique c'a ruma tek can ma nik'ax ta chiwech ri nbij chiwe? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Y ri Jesús ye rachibilan ri rudiscípulos xe'apon c'a pa Betsaida. Y c'o c'a jun achi moy xbeya'ox (xbeya') chuwech. Y ri ye c'amayon pe ri moy ri', xquic'utuj utzil chare ri Jesús chi tuya' ruk'a' pa ruwi' ri moy riche (rixin) chi nitzu'un. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xpe ri Jesús xuchop el chuk'a' ri achi moy y xuc'uaj el c'a chuchi' ri aldea. C'ac'ari' ri Jesús xuya' apo ruchub (ruc'axej) chrij runak' ruwech ri moy. Y xuya' ruk'a' pa ruwi'. C'ac'ari' tek xuc'utuj chare wi c'o ri nutz'et. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y tek ri moy xujek runak' ruwech, xubij c'a: Ja' (je), yentz'et ri achi'a'. Ntz'et chi achi'el ye che'. Pero xa ma ye che' ta ruma xa can yebiyin, ncha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y ri Jesús xuya' chic c'a ri ruk'a' chrij ri runak' tak ruwech ri achi y xuben c'a chare chi xtzu'un chic apo jun bey. Y yac'ari' tek ri achi xtzu'un chic jun bey achi'el ri rubanon ca. Can jabel c'a yerutzu' ronojel ri yec'o chi nej chi nakaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y ri Jesús xutek c'a el ri achi chrachoch. Riya' xubij c'a el chare: Ma catoc ta pan aldea riche (rixin) chi nbe'atzijoj ca chiri', xa choj jet chawachoch, xcha' el ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Y ri Jesús y ri rudiscípulos xebe ri pa tak aldea ri yec'o pa rucuenta ri tinamit Cesarea ri nibix chuka' riche (rixin) ri Felipe chare. Y pa bey, ri Jesús xuc'utuj c'a chique ri rudiscípulos: ¿Yin achique c'a riyin, niquibij ri winek? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y riye' xquibij chare: Yec'o ri yebin chi yit c'a riyit ri Juan ri Bautista. Yec'o nic'aj chic niquibij chi yit c'a riyit ri Elías. Y yec'o c'a chuka' ri yebin chi riyit yit jun chique ri nic'aj chic profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y Riya' xuc'utuj c'a chique ri rudiscípulos: ¿Yin achique c'a riyin nibij riyix? xcha' chique. Y ri Pedro can yac'ari' tek xubij: Yit c'a riyit ri Cristo, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y ri Jesús xuchilabej c'a chique chi majun achoj chare tiquitzijoj wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y ri Jesús xuchop c'a rubixic chique ri rudiscípulos: Riyin ri C'ajolaxel ri xinalex chicojol, c'o chi nk'axaj na q'uiy tijoj pokonal. Xquinetzelex cuma ri rijita'k tak achi'a' ri c'o quik'ij. Xquinetzelex cuma ri principali' tak sacerdotes. Chuka' xquinetzelex cuma ri aj tz'iba'. Y xquicamisex. Yac'a ri pa rox k'ij xquic'astej pe, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y tek ri Jesús xubij c'a re ch'abel re' chique ri rudiscípulos, can jabel c'a k'alaj rubixic xuben chare. Yac'a ri Pedro ma xka ta chuwech ri xubij ri Jesús, rumari' xuc'uaj el juba' quela', y xbechapon pe chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero tek ri Jesús xrac'axaj queri', xupiscolij ri' y xerutzu' ri nic'aj chic rudiscípulos y c'ac'ari' xubij chare ri Pedro: Cabiyin quela' riyit Satanás, ruma ma utz ta ri nach'ob. Ruma ri nach'ob riyit xa can junan riq'ui ri niquich'ob ri winek y xa ma ya ta ri nrajo' ri Dios ri nach'ob. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y ri Jesús xerusiq'uij (xeroyoj) c'a ri winek y ri rudiscípulos y Riya' xubij c'a chique: Wi c'o jun nrajo' yirutzekelbej, man c'a tupokonaj ta nuk'axaj tijoj pokonal. Xa can tubana' c'a achi'el nuben jun ri benak chuxe' jun cruz riche (rixin) chi nbecamisex. Ma nuben ta chic ri nurayij ka riya'. Wi c'o c'a jun nich'obo queri', utz chi nipe wuq'ui y quirutzekelbej c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ruma xabachique ri can nupokonaj ri ruc'aslen re wawe' chuwech re ruwach'ulef, xa ma xtril ta c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri ma nupokonaj ta ri ruc'aslen re wawe' choch'ulef, astape' ta na can napon pa camic wuma riyin y ruma ri lok'olaj ch'abel ri niya'o colotajic, can xtril c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ruma, ¿achique ta c'a nuc'om pe chare ri winek wi nic'oje' ri beyomel riche (rixin) ronojel re ruwach'ulef riq'ui y wi xa ma nicolotej ta? ");
INSERT INTO cakWNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Y astape' sibilaj q'uiy ri beyomel ri c'o riq'ui ri winek, xa can ma xticowin ta nulok' ri c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ruma wi jun winek niq'uix yiruk'alajsaj riyin y niq'uix nuk'alajsaj ri nuch'abel chique ri winek ri xa can ma yeniman ta chic chare ri Dios, winek ri can ye aj maqui' ri yec'o chuwech re ruwach'ulef re tiempo re', queri' chuka' riyin ri C'ajolaxel ri xinalex chicojol xquiq'uix xtinbij chi ri jun winek ri' wuche (wixin) riyin. Queri' xtinben tek xquipe chic jun bey, y junan chic nuk'ij nuc'ojlen riq'ui ri Nata' y ye wachibilan pe ri lok'olaj tak ángeles. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y chuka' ri Jesús xubij c'a chique ri yec'o riq'ui: Can tiwac'axaj c'a re xtinbij chiwe, chi yec'o nic'aj chiwe riyix ri yec'o wawe' ri ma xquecom ta na, xquecom pero c'a ya tek quitz'eton chic na ca ri rajawaren ri Dios petenak riq'ui ruchuk'a', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y tek k'axnek chic c'a waki' k'ij, ri Jesús xerucha' ri Pedro, ri Jacobo y ri Juan, riche (rixin) chi xeruc'uaj chi ye oxi' c'a pa ruwi' jun nimajuyu'. Y ri Jesús xjalatej c'a ruwachbel chiquiwech ri ye oxi' rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y chuka' ri rutziak can xjalatej ri yetzu'un. Can sibilaj rusakil xuben, can achi'el ri chumatef ri nika, y hasta nitz'itz'an. Y majun c'a jun aj ch'ajoy tziek ri nicowin ta nuben queri' rusakil chare jun tziek. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y xebec'ulun c'a pe ye ca'i' achi'a', ri Elías rachibilan ri Moisés, y xquichop tzij riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y yac'ari' tek ri Pedro xubij apo chare ri Jesús: Tijonel, xa utz kabanon chi yojc'o wawe'. Tikabana' oxi' tak ca'aj, jun awuche (awixin) riyit, jun riche (rixin) ri Moisés, y queri' chuka' ri jun chic riche (rixin) ri Elías, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro quec'ari' xubij apo y ma retaman ta achique ruma tek xch'o apo. Xa ch'obon ma ch'obon ri xerubila' apo, ruma chi ye oxi' quixibin qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y yac'ari' tek xpe jun sutz' ri xuben muj pa quiwi'. Y chupan c'a ri sutz' ri' c'o jun ch'abel xquic'axaj ri xubij: Yare' ri Nuc'ajol y can sibilaj nwajo', can ya c'a Riya' tiwac'axaj, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Y tek ri discípulos xetzu'un chic c'a apo, xquitz'et chi xa majun chic c'o riq'ui ri Jesús. Xa ruyon chic c'o ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y tek riye' ye xulan c'a pe chuwech ri juyu', ri Jesús xuchilabej chique ri rudiscípulos chi majun achoj chare tiquitzijoj wi ri xquitz'et, utz niquitzijoj pero c'a ya tek ri C'ajolaxel c'astajnek chic pe chiquicojol ri caminaki'; c'a yac'ari' tek utz niquitzijoj. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y riye' can ma xquitzijoj ta c'a ri achique xquitz'et, pero niquic'utula' c'a chiquiwech chi achique ri xrajo' xubij ri Jesús riq'ui ri ch'abel tek xubij chi xtic'astej pe chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y ri ye oxi' discípulos xquibij c'a chare ri Jesús: ¿Achique c'a ruma tek ri aj tz'iba' niquibij chi nabey c'o chi nipe ri Elías, y c'ac'ari' nipe ri Cristo? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y ri Jesús xubij c'a chique: Kas kitzij wi chi ri Elías nipe nabey y nuben c'a ruchojmil ronojel ri rajawaxic chi nichojmirisex. ¿Y achique nibij riyix? ¿Ma xtibanatej ta chuka' cami ri tz'ibatal ca chuwij riyin ri C'ajolaxel ri xinalex chicojol chi c'o chi nk'axaj q'uiy tijoj pokonal y can majun nuk'ij xtiban chuwe? ");
INSERT INTO cakWNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero riyin nbij c'a chiwe chi ri Elías ri' xpe yan. Y sibilaj q'uiy pokon ri xquiben el chare. Can achique ri xcajo' xquiben el chare, can queri' wi xquiben. Can achi'el ri ye tz'ibatajnek ca chrij, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Y tek ri Jesús ye rachibilan ri ye oxi' rudiscípulos xapon quiq'ui ri nic'aj chic discípulos, Riya' xutz'et c'a chi sibilaj ye q'uiy winek ri quimolon qui' chiquij, y chuka' ca'i' oxi' aj tz'iba' ri quichapon qui' riq'ui ch'abel quiq'ui ri discípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Quinojel can xu (xe) wi c'a xquitz'et chi petenak ri Jesús, can xquimey. Y xequicot, y chanin xebe y xquiya' rutzil ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xuc'utuj c'a chique: ¿Achoj pa ruwi' c'a ichapon wi iwi' quiq'ui riye'? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Y jun c'a chique ri winek xuchop apo rubixic chare ri Jesús: Tijonel, riyin nc'amon c'a pe ri nuc'ajol awuq'ui, ruma c'o jun itzel espíritu riq'ui. Y re itzel espíritu re', rumemurisan. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y tek nuchop, xabacuchi (xabachique) ta na c'o wi, nuch'akij pan ulef, niwoko pa ruchi', y nukach'ach'ej rey. Sibilaj chuka' rucajman chic ruma re quere' ruc'ulwachin. Y rumari' xinc'utuj utzil chique re adiscípulos chi tiquelesaj el re jun itzel espíritu re' riq'ui re nuc'ajol, y xa ma ye cowinek ta, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y ri Jesús yac'ari' tek xubij chique: Riyix winek ri yixc'o chuwech re ruwach'ulef, can majun chiwe ri cukul ta ruc'u'x riq'ui ri Dios. ¿Riyix nich'ob chi riyin can ronojel k'ij xquic'oje' iwuq'ui y man c'a xquitane' ta chi yixincoch'? Tic'ama' c'a pe ri c'ajol wawe', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xuc'uex c'a apo ri c'ajol chuwech ri Jesús. Pero tek ri itzel espíritu xutz'et ri Jesús, riq'ui ruchuk'a' xuyicaj ri c'ajol y xuch'akij pan ulef. Y ri c'ajol nubolkotila' c'a ri' y niwoko ruchub (ruc'axej) pa ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xuc'utuj c'a chare ri rutata' ri c'ajol: ¿Janipe' chic tiempo ruc'ulwachin pe quere' re c'ajol re'? xcha' ri Jesús. Y ri tata'aj xubij: Can c'a co'ol tek quere' ruc'ulwachin pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Can q'uiy c'a mul ruc'akon pa k'ak' y pa tak ya' riche (rixin) chi nucamisaj. Pero wi riyit yacowin nato', tajoyowaj c'a kawech; y kojato' c'a. Queri' xubij ri tata'aj chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Y ri Jesús xubij chare ri tata'aj: Wi riyit yacowin nacukuba' ac'u'x wuq'ui chi yicowin nto' ri ac'ajol, can xtibanatej wi ri achi'el nawajo'. Pero ri' awuq'ui riyit c'o wi, ruma jun winek ri can nucukuba' ruc'u'x wuq'ui tek c'o ri nuc'utuj, can nibanatej wi ri achique ri nrajo', xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y ri rutata' ri c'ajol can riq'ui ruchuk'a' xch'o y xubij: Ncukuba' nuc'u'x awuq'ui. Y chuka' can quinato' riche (rixin) chi queri' más ta xtincukuba' nuc'u'x awuq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Tek ri Jesús xutz'et chi sibilaj ye q'uiy winek ri yetajin niquimol apo qui', ri más utz xuben ya ri xchapon chare ri itzel espíritu. Riya' xubij c'a chare: Riyit ri abanon chare re c'ajol re' chi ma nac'axan ta y amemurisan, catel el, y ma catzolin ta pe chic riq'ui, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y ri itzel espíritu nurek ruchi', xel el riq'ui ri c'ajol ri'. Y xuyicaj ca. Y ri c'ajol ri' xc'oje' ca pan ulef, achi'el jun caminek. Y rumari' ye q'uiy winek xquibij chi xcom. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xuchop ruk'a' ri c'ajol ri' y xuyec anej. Y can yac'ari' tek xbeyacatej pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y tek ri discípulos yec'o chic pa jay quiyon riq'ui ri Jesús, xquic'utuj c'a chare: ¿Achique ruma tek riyoj ma xojcowin ta xkelesaj el ri itzel espíritu? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ri Jesús xubij c'a chique: Re jun ruwech itzel espíritu re' ntel, pero wi riyix niben orar y ma yixwa' ta tek niben ri oración ri', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y tek riye' ye elenak chic pe chiri', xek'ax ri pa Galilea. Pero ri Jesús ma xrajo' ta chi ninabex chi Riya' nik'ax chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ruma Riya' nrajo' c'a chi c'o ri niquetamaj ca ri rudiscípulos, y rumari' Riya' xuchop chic c'a rubixic chique: Riyin ri C'ajolaxel ri xinalex chicojol, can xquijach wi pa quik'a' ri winek y xquinquicamisaj. Yac'a tek xa yin caminek chic, pa rox k'ij xquic'astej pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Yac'a ri discípulos xa ma xk'ax ta chiquiwech ri xbix chique ruma ri Jesús. Y niquixibij c'a qui' niquic'utuj chare chi achique ri xubij chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y ri Jesús ye rachibilan ri rudiscípulos xapon ri pa tinamit Capernaum. Y tek c'o chic pa jay, Riya' xuc'utuj chique ri rudiscípulos: Y riyix ¿achique c'a ri nich'ojila' chiwech tek yoj petenak pa bey? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yac'a ri discípulos ma xek'ajan ta apo chuwech ri Jesús, ruma tek ye petenak pa bey, xa xquich'ojila' c'a chiquiwech chi achique ri más nim ruk'ij chique riye'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y ri Jesús xtz'uye' c'a ka. C'ac'ari' xerusiq'uij (xeroyoj) apo chi ye cablajuj rudiscípulos y xubij c'a chique: Wi c'o jun nrajo' chi ya riya' ri nabey y c'o ta ruk'ij, nic'atzin chi tuna' ka ri' chi riya' xa majun ruk'ij y tuch'utinirisaj ri', querunimaj y querilij quinojel. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y ri Jesús xberuc'ama' c'a pe jun ti ac'al y xuya' chiri' pa quinic'ajal. C'ac'ari' xuch'elej; y Riya' xubij c'a chique ri rudiscípulos: ");
INSERT INTO cakWNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri can pa nubi' riyin nuc'ul jun ac'al, jun ac'al ri achi'el re', ma xu (xe) ta wi xtuc'ul ri ac'al, xa can xquiruc'ul chuka' riyin. Y ri xquic'ulu c'a riyin, ma xu (xe) ta wi riyin ri xquiruc'ul, xa can xtuc'ul chuka' ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Y ri Juan xubij c'a pe chare ri Jesús: Tijonel, riyoj c'o jun achi katz'eton ca. Y pan abi' riyit yerelesala' itzel tak espíritu. Pero ruma xa ma kachibil ta, xkak'il ca, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Yac'a ri Jesús xubij: Ma tik'il ta chic. Ruma majun jun winek ri pa nubi' riyin yerubanala' wi milagros, y c'a ta ri' xticowin xquerubij itzel tak tzij chuwij, ma que ta ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ruma ri ma yojquetzelaj ta, can ye kachibil wi c'a ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y xabachique c'a ri utz yixrutz'et ruma wuq'ui riyin ri Cristo yixc'o wi, astape' xa jun vaso raxya' ri nuya' chiwe, can kitzij c'a nbij chiwe chi can c'o rajel ruq'uexel ri xtuc'ul. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Wi c'o ta jun co'ol ri yirunimaj y nipe ta jun winek y nuben chare ri jun co'ol ri' chi nitzak pa mac, ri winek ri xbano ri pokon ri', nimalaj ruc'ayewal nipe pa ruwi'. Rumari' xa utz na juba' chi ximon ta el jun nimalaj ca' chukul y nbec'ak ca pa mar, que chuwech ri nuben chare jun co'ol chi nitzak pa mac. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xa rumac'ari' wi xa jun chique ri ak'a' ri nibano chawe chi yamacun, más ta utz chi nachoy el. Ruma xa más utz chi xaxu (xaxe) wi jun ak'a' c'o y yatoc chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek, que chuwech ca'i' ta ak'a' c'o y xa yabe chupan ri tijoj pokonal; chupan ri k'ak' ri ma nichuptej ta, ");
INSERT INTO cakWNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ri acuchi (achique) ri quijutil riye' xa ma yecom ta, y ri k'ak' chuka' can ma nichuptej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y xa ta jun awaken ri nibano chawe chi yamacun, más ta utz chi nachoy el. Ruma más utz chi xaxu (xaxe) wi jun awaken c'o y yatoc chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek, que chuwech c'o chi ca'i' awaken y xa pa k'ak' ri majun bey xtichuptej ta ri yatbec'ak wi ca, ");
INSERT INTO cakWNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ri acuchi (achique) ri quijutil riye' xa ma yecom ta, y ri k'ak' chuka' can ma nichuptej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y xa ta jun runak' awech ri nibano chawe chi yamacun, tawelesaj el. Ruma más utz chi xaxu (xaxe) wi jun runak' awech c'o y yatoc chila' pa rajawaren ri Dios, que chuwech ca'i' ta runak' awech c'o y xa pa k'ak' yatbec'ak wi ca, ");
INSERT INTO cakWNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ri acuchi (achique) ri quijutil riye' xa ma yecom ta, y ri k'ak' chuka' can ma nichuptej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Can ronojel wi c'a chicop ri yecamisex y ri yetzuj (yesuj) chuwech ri Dios, yetz'amix riq'ui atz'an. Queri' chuka' quinojel winek xquetz'amix, pero ma riq'ui ta chic atz'an, xa riq'ui k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ri atz'an jabel. Y wi ta ri atz'an niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic niban chare riche (rixin) chi queri' nitzolin ta chic pe ri ratz'amil? Rumari' riyix tichajij ri ic'aslen, riche (rixin) chi queri' ma yixoc ta achi'el ri atz'an ri ma natz'amin ta chic, y chuka' can ta c'o uxlanibel c'u'x chicojol chi'iwonojel. Queri' xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Y c'ac'ari' ri Jesús ye rachibilan ri rudiscípulos xel el chiri' y xbe c'a quela' pa Judea. Y xk'ax c'a juc'an chic chare ri raken ya' Jordán. Chiri', sibilaj ye q'uiy winek xquimol chic qui' riq'ui. Y Riya' xuchop chic c'a ruc'utic ri ruch'abel ri Dios chiquiwech, can achi'el wi rubanon pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y yac'ari' tek yec'o achi'a' fariseos ri xe'apon riq'ui, ruma nicajo' chi niquitojtobej ri Jesús y nitzak ta pa quik'a'. Riye' xquic'utuj c'a chare wi ruc'amon chi jun achi nujech ri' riq'ui ri rixjayil. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y ri Jesús xubij c'a chique ri achi'a' ri': ¿Achique c'a rubin ca ri Moisés chiwe chi niben? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y riye' xquibij c'a: Ri Moisés can xuya' wi ca k'ij chare ri achi chi utz nutz'ibaj jun wuj y nubij chupan chi xquijech qui' riq'ui ri rixjayil y tuya' chare ri ixok, y tuya' ca, xecha' riye'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y ri Jesús can yac'ari' xubij chique: Ruma chi can cowirnek ri iwánima riyix chi ma ninimaj ta ri Dios, xa rumac'ari' tek ri Moisés xuya' k'ij chi nijech ca ri iwixjaylal. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yac'a ri pa rutiquiribel pe xa ma que ta ri'. Ri pa rutiquiribel, tek ri Dios xuben re ruwach'ulef, can pa c'ulaj c'a xeruben ri winek. Can ma ruyon ta ri achi y ma ruyon ta chuka' ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Rumari' ri achi man chic c'a quiq'ui ta rute' rutata' xtic'oje' wi. Xa xtiquic'uaj qui' riq'ui ri rixjayil, ");
INSERT INTO cakWNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y chi ye ca'i' xa jun c'a xtiquiben. Rumari' tek quic'uan chic qui', man chic ye ca'i' ta c'a winek, xa jun chic quibanon. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Rumac'ari' ri can ye tunun chic ruma ri Dios, majun winek ri tijacho ta quiche (quixin), xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Tek ri Jesús y ri rudiscípulos yec'o chic c'a pa jay, xepe ri discípulos xquic'utula' chare ri Jesús chi achique c'a ri xrajo' xubij riq'ui ri ch'abel ri xa c'ari' xerubij ca chique ri achi'a' fariseos. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y ri Jesús xubij c'a chique: Xabachique achi ri nujech ca ri rixjayil y c'ac'ari' nuc'om chic jun ixok, ri achi ri' nimacun chuwech ri rixjayil. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y queri' chuka' ri ixok ri nujech ca ri rachijil y nibe chic riq'ui jun achi, ri ixok ri' can nimacun chuka'. Queri' xubij chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yec'o c'a ac'ala' ri xe'uc'uex apo chuwech ri Jesús, chi nuya' ta el ri ruk'a' pa quiwi', riche (rixin) chi niquic'ul ri rubendición ri Dios. Yac'a ri discípulos xa xechapon chique ri winek chi ma quequic'om ta pe ri ac'ala'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yac'a tek ri Jesús xutz'et ri niquiben ri rudiscípulos, ma xka ta chuwech ri yetajin chubanic, y xubij c'a chique: Tiya' k'ij chique ri ac'ala' chi yepe wuq'ui riyin, y ma que'ik'et ta. Ruma ri xque'oc pa rajawaren ri Dios, xaxu (xaxe) wi ri winek ri ye achi'el re ac'ala' re'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y can kitzij c'a nbij chiwe, chi ri xa ma niquiben ta achi'el ri ac'ala' riche (rixin) chi niquijech qui' pa ruk'a' ri Dios, can man c'a xque'oc ta pa rajawaren ri Dios, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y Riya' xeruch'elej chiquijujunal ri ac'ala' y xuyala' ri ruk'a' pa quiwi' y xerubanala' c'a bendecir. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y tek ri Jesús ye rachibilan ri rudiscípulos xuchop chic el ri rubey, c'o jun achi junanin (anibel) xoka riq'ui, xxuque' chuwech, y xubij c'a chare: Riyit ri can yit utzilaj Tijonel, tabij c'a chuwe: ¿Achique c'a ri rajawaxic chi nben riyin riche (rixin) chi ntoc ta wuche (wixin) ri c'aslen riche (rixin) xtibe k'ij xtibe sek? xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y ri Jesús xubij c'a chare: ¿Achique ruma tek nabij utz chuwe riyin? Ruma majun winek ri utz ta, xa can xu (xe wi) Jun ri utz y ri' ya ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Y riyin nbij chi riyit jabel awetaman ri rupixa' ri Dios, chi riyit achi ri c'o awixjayil ma tacanoj ta jun chic ixok, ma cacamisan ta, ma catelek' ta, ma tatz'uc ta tzij chrij jun chic winek, ma tak'ol ta jun winek riche (rixin) chi nawelesaj chare ri xa riche (rixin) riya'; taya' quik'ij ri ate' atata', xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Y ri achi ri' xubij chare ri Jesús: Tijonel, c'a yin co'ol na tek nchapon pe rubanic ronojel ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y ri Jesús riq'ui c'a ajowabel xutzu' ruwech ri achi tek xubij queri', y c'ac'ari' xubij chare: C'a c'o na jun ri ma abanon ta. Wacami, jet jac'ayij c'a ronojel ri c'o awuq'ui y ri rajel taya' chique ri pobres, riche (rixin) chi queri' nic'oje' abeyomal chila' chicaj. Y catam pe wuq'ui, quinatzekelbej, y ma tapokonaj ta nak'axaj tijoj pokonal wuma riyin, achi'el jun ri can benak chuxe' jun cruz riche (rixin) chi nbecamisex, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero tek ri achi xrac'axaj ri ch'abel ri xubij ri Jesús chare, xa can pokon xuna' ri ránima, ruma riya' can q'uiy ri beyomel c'o riq'ui. Y nibison c'a ránima xtzolin el, ruma ma nrajo' ta chi ntel ri rubeyomal pa ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Y ri Jesús xerutzu' ri rudiscípulos y xubij chique: Ri c'o quibeyomal, c'ayef (cuesta) chi ye'oc pa rajawaren ri Dios, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y ri rudiscípulos can achique na xquic'axaj ri ch'abel ri xubij ri Jesús. Pero Riya' xubij chic jun bey chique: Walc'ual, ri winek ri can quicukuban quic'u'x riq'ui quibeyomal, c'ayef (cuesta) chi ye'oc pa rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa ma can ta c'ayef (cuesta) chi nik'ax ri jun chicop ri camello rubi' pa ti rachek jun bak riche (rixin) t'iso'n (tz'iso'n), que chuwech chi ntoc jun beyon pa rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero tek ri discípulos xquic'axaj chic jun bey ri ch'abel ri xubij ri Jesús, xsach quic'u'x y xquibila' c'a chiquiwech: Wi can achi'el ri xubij, ¿achique ta c'a jun ri xticolotej? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y ri Jesús xerutzu' chic c'a jun bey ri rudiscípulos y xubij c'a chique: Ri winek ma yecowin ta niquicol qui', yac'a ri Dios can nicowin wi yerucol, ruma Riya' ronojel nicowin nuben, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y yac'ari' tek ri Pedro xubij chare: Riyit awetaman chi riyoj kaya'on ca ronojel ri c'o kiq'ui, riche (rixin) chi yit katzekelben, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Y ri Jesús xubij: Can kitzij c'a nbij chiwe, wi c'o jun winek ri ruya'on ca rachoch, ruya'on ca rach'alal ye c'ajola' o k'opoji', rute' rutata', rixjayil, ralc'ual o rulef, wuma riyin y ruma ri lok'olaj ch'abel ri niya'o colotajic, ");
INSERT INTO cakWNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ri winek ri nibano queri' can q'uiy c'a xtuc'ul. Can pa ciento c'a mul ri xtuc'ul chupan re tiempo re kachapon. Xtuc'ul rachoch, rach'alal ye c'ajola' o k'opoji', rute', ralc'ual y rulef. Astape' can c'o wi c'a tijoj pokonal ri xtuk'axaj ruma tzekelbey wuche (wixin) riyin, pero chupan apo ri jun chic tiempo chkawech apo, can xtiyatej c'a chuka' ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Y c'o ri yec'o nabeyel ri xquecanaj c'a pa ruq'uisbel. Y c'o ri yec'o pa ruq'uisbel ri xquec'oje' pa nabey, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús, ri rudiscípulos y ri nic'aj chic winek, quichapon c'a el bey pa tinamit Jerusalem. Y can yac'a ri Jesús ri nabeynek el chiquiwech, y rumari' ri rudiscípulos y ri winek can achique na xquina' y quixibin chuka' qui' ye tzeketel el chrij. Yac'ari' tek ri Jesús xeruc'uaj c'a el juba' quela' pa quiyonil ri cablajuj rudiscípulos y xubij chic c'a chique ri achique chi tijoj pokonal ri xtuk'axaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Riya' xubij c'a chique: Riyix iwetaman chi pa tinamit Jerusalem kachapon wi el bey, y ya ri chiri' ri xquijach wi el riyin ri C'ajolaxel ri xinalex chicojol. Xquijach na pa quik'a' ri principali' tak sacerdotes y pa quik'a' ri aj tz'iba'. Y riye' xtiquibij chi can quicamisex. Y chuka' xquinquijech el pa quik'a' winek ri xa ma ye israelitas ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y ri winek ri' xquinquiyok', xquinquichubaj, xquinquich'ey, y c'ac'ari' xquinquicamisaj. Pero pa rox k'ij xquic'astej c'a pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y ri Jacobo y ri Juan, ri ye ruc'ajol ri achi ri Zebedeo rubi', xejel c'a apo riq'ui ri Jesús, y xquibij chare: Tijonel, riyoj nikajo' nikac'utuj jun utzil chawe. Pero naben ta c'a ri xtikac'utuj chawe, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y Riya' xubij chique: ¿Achique c'a chi utzil ri niwajo'? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y riye' xquibij c'a: Riyoj nikajo' c'a chi tek yitc'o chic pan awajawaren, naya' ta c'a k'ij chake chi yojtz'uye' apo awuq'ui; jun ta c'a ri pan awajquik'a' y jun ta c'a ri pan awajxocon, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Y ri Jesús xubij chique: Riyix ma iwetaman ta c'a ri nic'utuj chuwe. ¿La nicoch' cami riyix achi'el ri xtiban chuwe riyin? ¿Y la nicoch' cami chuka' riyix jun tijoj pokonal achi'el ri xtink'axaj riyin? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y riye' xquibij c'a: Nikacoch', xecha' chare. Y ri Jesús xubij chic c'a chique: Can kitzij wi c'a chi riyix xticoch' na wi achi'el ri xtiban chuwe riyin. Chuka' can xticoch' jun tijoj pokonal achi'el ri xtink'axaj riyin; ");
INSERT INTO cakWNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","yac'a ri nic'utuj chuwe, chi riyix niwajo' chi jun nitz'uye' ri pa wajquik'a' y jun nitz'uye' ri pa wajxocon, ri' ma pa nuk'a' ta riyin c'o wi chi nya' chiwe. Ruma ri nic'utuj riyix, ri' xa quiche (quixin) chic c'a ri xtubij ri Nata' chi utz chi xquetz'uye' chiri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y yac'a tek ri lajuj chic discípulos xquic'axaj ri xbitej ka, xpe c'a coyowal chique ri Jacobo y ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Y yac'ari' tek ri Jesús xerusiq'uij (xeroyoj) ri rudiscípulos y xubij c'a chique: Riyin nbij c'a chi riyix jabel iwetaman chi re wawe' choch'ulef, ri ya'on k'atbel tzij pa quik'a', yeri' ri yec'o pa quiwi' ri winek, y ruma chi can c'o quik'atbel tzij pa quiwi' ri winek, rumari' niquina' chi can yec'a riye' ri ye cajaf ri winek. Xa can xu (xe) wi c'a ri c'o quik'ij ri yebin ri c'o chi niban. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Yac'a ri chicojol riyix jun wi chic. Ruma ri nrajo' chi nic'oje' ruk'ij chicojol, xa tuch'utinirisaj ri', y querunimaj querilij ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Wi jun c'a chiwe riyix ri can nrajo' chi ya riya' ri nabey, xa tuch'utinirisaj ri', querunimaj querilij quinojel ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ruma riyin ri C'ajolaxel ri xinalex chicojol ma xipe ta riche (rixin) chi ye ri winek yebano samaj pa nucuenta riyin. Riyin xipe riche (rixin) chi nben ri samaj ri nic'atzin chi nben pa quicuenta ri winek, y can nya' wi' pa camic riche (rixin) chi queri' ye q'uiy ri yecolotej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yac'ari' tek ri Jesús y ri rudiscípulos xe'apon c'a pa tinamit Jericó. Y tek quichapon el elen pa tinamit Jericó, sibilaj ye q'uiy winek ri ye tzekelbeyon el quiche (quixin). Y chiri' chuchi' bey c'o c'a jun moy ri Bartimeo rubi', ruc'ajol jun achi ri Timeo rubi'. Riya' tz'uyul c'a chiri', nuc'utula' ca limosna chique ri winek ri yek'ax el queri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y tek riya' xrac'axaj c'a chi ri nik'ax el queri' ya ri Jesús aj Nazaret, riya' xurek ruchi' y xubij c'a: Riyit Jesús, ri yit ralc'ual ca ri rey David, tajoyowaj nuwech ruma re nbanon, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y ye q'uiy c'a winek ri xquik'il ri moy chi ma turek ta chic ruchi'. Pero riya' xa can más nurek ruchi' y nubij: Riyit ri yit ralc'ual ca ri rey David, tajoyowaj nuwech ruma re nbanon, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y ri Jesús xrac'axaj c'a ri ruch'abel. Rumari' xpa'e' c'a y xubij chi tisiq'uix (toyox) pe ri achi. Y yac'ari' tek xbequisiq'uij (xbecoyoj) pe ri achi moy y xquibij chare: Ma taxibij ta awi'. Jo' kiq'ui. Ri Jesús yarusiq'uij (yaroyoj), xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y ri achi can xu (xe) wi c'a xrac'axaj queri', can yac'ari' xyacatej pe. Xuya' ca ri ruchaqueta chiri' y xbe apo riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ri Jesús xuc'utuj chare: ¿Achique c'a ri nawajo'? Y ri achi moy xubij chare: Tijonel, riyin nwajo' yitzu'un, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús can yac'ari' tek xubij c'a chare: Wacami jet, ya xacolotej chuwech ri amoyil ruma xacukuba' ac'u'x wuq'ui. Y ri moy can xtzu'un wi y xutzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y tek xa nakaj chic c'a yec'o wi apo chique ri tinamit Betfagé y Betania, xa juba' chic c'a nrajo' chi ma ye'apon pa tinamit Jerusalem, ruma can chunakajal chic apo ri juyu' Olivos yec'o wi. Y yac'ari' tek ri Jesús xerutek el ye ca'i' chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Riya' xubij c'a el chique: Quixbiyin apo chupan la aldea la nitzu' apo chila'. Y can xu (xe) wi xquixoc apo, xtiwil jun ti alaj bur ri ximil ca chiri' ri can c'a ma jane jun ch'ocolbeyon ta. Tiquira' c'a pe y nic'om c'a pe chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y wi c'o jun xtibin pe chiwe chi achique ruma yixtajin niquir ri ti alaj bur, tibij c'a ca chare chi nic'atzin chare ri Ajaf, pero chanin xtorutzolij ca, quixcha' ca chare, xe'uche'ex el ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Y ri ca'i' discípulos xebe c'a. Tek xe'apon, xquil na wi ri ti alaj bur ximon ca ri acuchi (achique) nuya' wi vuelta ri bey ri ntoc chuwajay. Y riye' xquiquir c'a pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Y tek yetajin chuquiric ri ti alaj bur, xetz'et pe cuma jun ca'i' ri yec'o chiri' y xquibij chique ri ye ca'i' discípulos: ¿Achique yixtajin chubanic chiri'? ¿Achique ruma yixtajin chuquiric ri ti alaj bur? xecha' pe chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y ri discípulos xquibij c'a ri rubin el ri Jesús chique. Y ri xetz'eto pe xquiya' k'ij chique chi xquic'om pe ri ti alaj bur ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y ri discípulos ri' xquic'om c'a pe ri ti alaj bur chare ri Jesús. C'ac'ari' xquiya' c'a quitziak chrij ri chicop ri', riche (rixin) chi ri Jesús xch'oque' el chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y ye q'uiy c'a chique ri winek ruma can nicajo' niquiya' ruk'ij ri Jesús, xquiriq'uila' ri nima'k tak quitziak pa rubey. Y nic'aj chic winek ruma can xcajo' xquiya' chuka' ruk'ij ri Jesús, xebequic'amala' pe ruxak tak che' ri can riche (rixin) wikbel, riche (rixin) chi xequiric' pa rubey. Y quec'ari' niquibanala' ye benak. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winek c'a ri ye nabeynek chuwech ri Jesús y ri yec'o ca chrij, can riq'ui c'a ronojel quichuk'a' niquibij: ¡Matiox chi petenak re jun achi re'! ¡Riya' can banon pe bendecir ruma ri Ajaf Dios! ¡Y can pa rubi' ri Ajaf Dios petenak wi! ");
INSERT INTO cakWNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox chi nitzolin yan chic pe ri ruk'atbel tzij ri David ri katata' ri xc'oje' ojer ca! ¡Matiox chare ri Dios ri c'o chila' chicaj! xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y ri Jesús xoc c'a apo ri pa tinamit Jerusalem y xbek'ax c'a pe pa rachoch ri Dios y xerutzu' ca ri yec'o chiri'. Y tek ntoc c'a pe ri ak'a', Riya' ye rachibilan ri ye cablajuj rudiscípulos xbe ri pa tinamit Betania. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa ruca'n k'ij tek quichapon pe bey riche (rixin) chi yetzolin pe pa Betania y yebe pa Jerusalem, ri Jesús xpe c'a runumic. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y Riya' c'anej c'a c'o wi tek xutz'et chi c'o juwi' che' ri higo rubi' y sibilaj jabel rubanon ri ruxak. Xbe c'a apo chuxe' chucanoxic ruwech. Y tek xapon apo riq'ui, xa majun ruwech c'o ta, xa ruyon ruxak c'o. Ruma ma ruk'ijul ta chi niwachin. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Yac'ari' tek ri Jesús xubij chare ri che': Can majun chic c'a winek xtitijo ta jun ti awech, ruma can ma xcawachin ta chic, xcha' chare. Y ri rudiscípulos xquic'axaj c'a ri xubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xe'apon chic c'a pa tinamit Jerusalem. Y ri Jesús xoc c'a pa rachoch ri Dios. Yac'a tek Riya' c'o chic chiri', xerokotaj c'a pe ri yetajin yec'ayin y ri yelok'onaj chiri'. Y ri aj q'uexoy tak puek, xerutecmayila' ca ri quimesas. Y queri' chuka' xuben ca chique ri quich'acat ri yec'ayin palomax. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y Riya' ma xuya' ta k'ij chique ri winek chi quic'uan cosas yek'ax chupan ri ruwajay ri c'o chiri' pa rachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'ac'ari' Riya' xuc'ut c'a chuka' chiquiwech ri winek riq'ui ri ruch'abel ri Dios, chi ri rachoch ri Dios xa can jay riche (rixin) niban wi oración. Rumari' Riya' xubij chique ri winek: ¿La ma tz'ibatal ta c'a ca chupan ri ruch'abel ri Dios chi ri wachoch, can jay riche (rixin) chi niquiben wi orar quinojel winek ri yec'o chuwech re ruwach'ulef? Yac'a riyix xa achi'el jul quiche (quixin) alek'oma' ibanon chare, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y ri' xac'axex c'a cuma ri principali' tak sacerdotes y ri aj tz'iba'. Rumari' riye' xa can niquicanola' c'a achique ta rubanic niquiben, riche (rixin) chi niquicamisaj ri Jesús. Ruma ri sacerdotes y ri aj tz'iba' ri' can quixibin c'a qui' chuwech ri Jesús, ruma xa can juba' ma quinojel ri winek jabel niquic'axaj ri ch'abel ri nuc'ut chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Y tek xoc pe ri ak'a', ri Jesús xbe ye rachibilan ri rudiscípulos. Ma xc'oje' ta ka ri chiri' pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nimak'a' ruca'n k'ij, tek quichapon bey pa Jerusalem, xquitz'et c'a chi ri juwi' che' ri higo rubi' chaki'j chic rachibilan ri ruc'amal. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y ri Pedro chanin c'a xoka chuc'u'x, y xubij chare ri Jesús: Tijonel, tatzu' la juwi' higo ri xabij ca chare chi majun bey chic xtiwachin ta, xa can xchaki'j wi ka, xcha' ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Y ri Jesús xubij c'a chique quinojel ri rudiscípulos: Riyix chuka' rajawaxic chi nicukuba' ic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Queri' nbij chiwe ruma kas kitzij chi xabachique ri nibin chare re juyu' re' chi tel el wawe' y tik'ax pa mar, can queri' wi nibanatej wi can kitzij nucukuba' ruc'u'x y ma nuben ta ca'i' ruc'u'x. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumac'ari', riyin can nbij c'a chiwe chi ronojel ri nic'utuj tek riyix niben orar y wi can ninimaj chi nic'ul, can xtiyatej wi c'a chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y tek niben c'a orar, can man ta jun ri nik'ato ri i'oración. Ruma wi xa c'o ta jun ri c'o jun pokon rubanon chiwe, ticuyu'. Y queri' ri Itata' ri c'o chila' chicaj xquixrucuy chuka' riyix riq'ui ri imac ri ye'ibanala' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ruma wi riyix xa ma nicuy ta rumac jun ri c'o pokon rubanon chiwe, chuka' ri Itata' ri c'o chila' chicaj ma xtucuy ta ri imac ri ye'ibanala' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús ye rachibilan ri rudiscípulos xe'apon chic c'a pa tinamit Jerusalem. Y nibiyala' (nibiyajlan) c'a pa rachoch ri Dios tek xe'apon ri principali' tak sacerdotes riq'ui, chuka' ri aj tz'iba' y ri rijita'k tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Y xquic'utuj c'a chare: ¿Achique chi k'atbel tzij c'o pan ak'a' riche (rixin) chi xe'awokotaj el ri winek ri yec'ayin wawe' pa rachoch ri Dios? ¿Y achique chuka' xya'o ri k'atbel tzij ri' pan ak'a' chi ye'abanala' quere'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xpe ri Jesús xubij c'a chique ri achi'a' ri': Riyin c'o chuka' jun ri nwajo' nc'utuj chiwe. Y wi riyix xtibij chuwe, riyin chuka' xtinbij chiwe achique ri yayon pe k'atbel tzij pa nuk'a' rumari' yicowin yenbanala' quere'. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tiwac'axaj c'a jabel re xtinc'utuj chiwe. ¿Ri Juan xtak pe ruma ri Dios riche (rixin) chi xeruben bautizar ri winek? ¿O xa ye ri winek xebin chare chi xuben queri'? Tibij c'a chuwe ri achique nich'ob, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Y ri principali' tak sacerdotes, ri aj tz'iba' y chuka' ri rijita'k tak achi'a' ri c'o quik'ij, xquibila' c'a chiquiwech: ¿Achique c'a xtikabij chare wacami? xecha' ka. Ruma wi nikabij chi ri Juan ya ri Dios ri takayon pe, ri Jesús xa xtubij c'a chake chi achique c'a ruma tek ma xinimaj ta ri xubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y wi nikabij chi xa winek xebin chare ri Juan chi xuben queri', c'o ruc'ayewal nuc'om pe chake riyoj. Riye' xquich'ob ka queri', ruma quixibin qui' chiquiwech ri winek. Ruma quinojel ri winek can quetaman c'a chi ri Juan jun profeta ri can xuk'alajsaj wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Yac'ari' tek xquibij apo chare ri Jesús: Riyoj ma ketaman ta, xecha' apo. Y ri Jesús can yac'a chuka' ri' xubij chique: Ruma c'a chi riyix xa ma xixcowin ta xibij chuwe, queri' chuka' riyin ma xtinbij ta chiwe achique ri yayon pe k'atbel tzij pa nuk'a' chi yicowin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y ri Jesús, riq'ui c'a c'ambel tak tzij xch'o wi quiq'ui. Riya' quec'are' xubila' chique: Xc'oje' c'a jun achi ri xutic ruwech ri rulef riq'ui uva. Xuben coral chrij ri ulef y xuben chuka' achi'el jun ti pila ri pan ulef riche (rixin) chi niyitz' ri uva chupan. Xuben chuka' jun setesic tz'ak ri nej xujotoba' chicaj, y pa ruwi' ri' xc'oje' wi rachoch ri chajinel. C'ac'ari' xuya' ca pa kajic chique ca'i' oxi' mozos, y riya' xbe nej. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y ri rajaf ri ulef xutek c'a jun rumozo quiq'ui ri achi'a' ri ye kajayon ri ulef, tek xapon ruk'ijul riche (rixin) chi nberuc'ulu' pe ri uva kajbel riche (rixin) ri ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yac'a tek xapon ri mozo quiq'ui ri achi'a' ri ye kajayon ri ulef, ri kajoy tak ulef ri' xquichop c'a ri mozo ri' y xquich'ey, y majun c'a uva xquiya' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Y ri rajaf ri ulef xutek chic c'a jun rumozo quiq'ui ri kajoy tak ulef, chuc'amaric ri uva kajbel riche (rixin) ri ulef. Pero tek xapon ri mozo, xa xquichop ruc'akic chi abej y xquisocola' el ri rujolon (ruwi'). Q'uiy c'a pokon ri xquibanala' el chare, y queri' xquitek el. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Y ri rajaf ri ulef xutek chic jun rumozo. Y ri mozo ri' xcamisex cuma ri kajoy tak ulef. Y ye q'uiy chic mozos ri xerutek, pero quinojel c'o ri xquic'ulwachij. Yec'o xech'ay pe, y yec'o xecamisex. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruq'uisbel, ri rajaf ri ulef xaxu (xaxe wi) chic c'a ri ruc'ajol xc'oje' ca riq'ui y riya' sibilaj nrajo' ri ruc'ajol. Pero ri rajaf ri ulef xutek c'a ri ruc'ajol quiq'ui ri achi'a' ri ye kajayon ri rulef, ruma riya' xuch'ob ka: Ri achi'a' ri ye kajayon ri ulef can xqueniman wi c'a chare ri nuc'ajol tek xtiquitz'et chi can ya riya' ri napon quiq'ui, xcha' ka pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Yac'a ri achi'a' ri ye kajayon ri ulef can xu (xe) wi xquitz'et chi ya ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquiwech: Yare' ri xtoc ca rajaf ronojel re ulef re kakajon. Wacami quixam pe, tikacamisaj riche (rixin) chi queri' re ulef re' ntoc ca kiche (kixin) riyoj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y can queri' wi c'a xquiben. Xquichop ri c'ajolaxel, xquicamisaj. Xquelesaj c'a el chupan ri ulef ri ticon ruwech riq'ui uva y xbequic'aka' ca juc'an chic. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","C'ac'ari' ri Jesús xubij: ¿Achique cami xtuben ri rajaf ri ulef ri' chique ri achi'a' kajoy tak ulef? Ri rajaf ri ulef xtipe c'a y xquerucamisaj ri kajoy tak ulef ri' y ri rulef xtuya' chic ca pa kajic chique nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿La can majun bey c'a isiq'uin ta ri jun tzij ri tz'ibatal ca chupan ri ruch'abel ri Dios? Tek nubij: C'o c'a jun abej ri ma xka ta chiquiwech chi xquicusaj ri nic'aj aj banoy tak jay. Pero re abej re' xa can c'o wi ri xucusan chare ri xquina riche (rixin) ri jay, riche (rixin) chi ri jay ri' ma nitzak ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ri xbano c'a re' can ya wi ri Ajaf y re' can nikamey ruma majun bey katz'eton ta chi nibanatej ta quere'. Queri' nubij ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y ri achi'a' achoj quiq'ui xch'o wi ri Jesús, riye' can ta c'o xcajo' chi xquichop ta el ri Jesús, ruma xquinabej chi ri achi'a' kajoy tak ulef ri xerunataj chupan ri c'ambel tzij, xa chiquij riye' xch'o wi. Y xa majun xquiben chi xquichop ta el, ruma niquixibij qui' chiquiwech ri sibilaj winek ri yec'o riq'ui. Riye' xquiya' c'a ca ri Jesús y xebe. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y ri achi'a' ri' yec'o c'a nic'aj chic ri xequitek pe. Xequitek c'a pe ca'i' oxi' achi'a' fariseos y chuka' ye ca'i' oxi' ri yec'o pa rupartido ri rey Herodes, ruma can nicajo' chi ri Jesús nitzak ta pa quik'a' riq'ui ri ch'abel ri xtubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'ac'ari' riye' xepe c'a y xquibij chare ri Jesús: Riyit ri can yit jun Tijonel, riyoj can ketaman c'a chi xaxu (xaxe) wi c'a ri kas kitzij ri nika chawech y yari' ri natzijoj. Y riyit ma naxibij ta chuka' awi' chuwech jun winek, astape' can c'o ruk'ij. Y can nac'ut wi ri bey riche (rixin) ri Dios chiquiwech ri winek. ¿Achique c'a nabij riyit? ¿La ruc'amon cami chi nikatoj ri alcawal ri nubij ri César ri c'o chi nikatoj o xa ma ruc'amon ta? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yac'a ri Jesús can retaman wi chi riq'ui ca'i' quipalej ri niquic'utuj queri'. Rumari' Riya' xubij chique: ¿Achique c'a ruma riyix nitij ik'ij riche (rixin) chi yinitojtobej? Tic'ama' c'a pe jun puek riche (rixin) chi ntz'et, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y riye' xbequic'ama' c'a pe ri puek chi niquic'ut chuwech. Y c'ac'ari' Riya' xuc'utuj c'a chique: ¿Achoj ruwachbel la'? ¿Y achoj rubi' chuka' la c'o chuwech la puek? xcha' chique. Y riye' xquibij: Riche (rixin) ri César, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y yac'ari' tek ri Jesús xubij chique: Can tiya' c'a chare ri César ri can riche (rixin) wi ri César. Y can tiya' c'a chare ri Dios, ri can riche (rixin) wi ri Dios, xcha' chique. Y riye' xquimey tek xquic'axaj ri xubij ri Jesús chique, ruma ma xecowin ta chrij chi xtzak ta pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y yac'ari' tek nic'aj chique ri achi'a' saduceos xe'apon riq'ui ri Jesús ruma c'o nicajo' niquic'utuj chare. Ri achi'a' ri' ma niquinimaj ta c'a chi ri caminaki' xquec'astej chic pe. Y rumac'ari' riye' xquibij c'a chare ri Jesús: ");
INSERT INTO cakWNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Tijonel, ri Moisés can rutz'iban wi c'a ca chake chi tek jun achi nicom el y majun ralc'ual nic'oje' ca riq'ui ri rixjayil, can jun c'a rach'alal ri achi ri' c'o chi nic'ule' riq'ui ri ixok ri xmalcanij ca, riche (rixin) chi queri' yec'oje' ta ralc'ual riq'ui ri ixok ri'. Y ri nabey ti c'ajol (ala') ri nalex ntoc ralc'ual ri caminek chic el. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y riye' xquibij c'a: Xec'oje' c'a ye wuku' achi'a' cach'alal qui'. Y xbanatej c'a chi ri nimalaxel xc'ule'. Pero ri achi ri' xcom el, y majun ralc'ual ri xc'oje' ta ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xpe ri ruca'n achi, ri rach'alal ca ri achi ri caminek chic el, xc'ule' riq'ui ri malca'n ixok. Pero chuka' ri achi ri' xcom el y majun ralc'ual ri xc'oje' ta ca. Ri rox achi can queri' chuka' ri xuc'ulwachij el, achi'el ri ca'i' nabey tak rach'alal y ri ixok c'a xc'oje' na ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Y tek ye caminek chic el ri ye wuku' achi'a' cach'alal qui' chuwech ri ixok ri', can majun chique ri ye wuku' achi'a' ri' xc'oje' ta ca ralc'ual. Y pa ruq'uisbel xcom chuka' el ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Riyit nabij chi xtapon na jun k'ij tek ri caminaki' xquec'astej pe. Tek xtapon c'a ri k'ij ri', ¿achoj rixjayil c'a xtoc wi ri ixok ri'? Ruma chi ye wuku' achi'a' cach'alal qui' xec'oje' riq'ui, xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Can yac'ari' tek ri Jesús xubij chique ri achi'a' ri': Riyix xa yix sachnek riq'ui ri xibij, ruma ma k'axnek ta chiwech ri nubij chupan ri ruch'abel ri Dios. ¿Man c'a iwetaman ta chi ri ruchuk'a' ri Dios sibilaj nim? ");
INSERT INTO cakWNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ruma tek xtapon ri k'ij chi ri caminaki' xquec'astej el, ri achi ma xtic'oje' ta chic rixjayil, ni ri ixok ma xtic'oje' ta chic rachijil, ruma can majun chic c'ulanen xtibanatej. Xa xque'oc achi'el ri ángeles ri yec'o chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Yac'a ri c'astajbel quiche (quixin) ri caminaki', can c'o wi. ¿La ma isiq'uin ta c'a ri nubij chupan ri ruch'abel ri Dios ri tz'ibatal ca ruma ri Moisés, tek ri Dios xch'o pe chare chupan ri juwi' k'ayis ri c'o ruq'uixal? Tek ri Dios xubij: Yin c'a riyin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac y ri ru-Dios chuka' ri Jacob, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Y wi ta riye' xecom el jurayil y xa man ta yec'astej chic pe jun bey, ri Dios man ta qui-Dios chic riye', ruma ri Dios ma Dios ta quiche (quixin) caminaki', xa can Dios quiche (quixin) ri c'o quic'aslen. Rumac'ari' riyin nbij chi xa yix sachnek riq'ui ri nibij, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y yac'ari' tek xjel apo riq'ui ri Jesús jun aj tz'ib. Ri aj tz'ib ri' xrac'axaj c'a ri xquibij ri achi'a' saduceos chare ri Jesús, y xrac'axaj chuka' ri xubij ri Jesús chique ri achi'a' ri'. Y chuwech riya' can k'alaj wi chi utz ri xubij ri Jesús y c'ac'ari' xuc'utuj c'a: ¿Achique c'a ri nabey pixa' chare ronojel ri pixa' ri xuya' ri Dios pa ruk'a' ri Moisés? xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y ri Jesús xubij c'a chare: Ri nabey pixa' ya c'a ri nubij: Tiwac'axaj c'a riyix aj Israel, chi ri Kajaf xaxu (xaxe) wi jun, y ri' ya ri Kajaf Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Can tawajo' c'a ri Dios ri Awajaf. Tawajo' riq'ui ronojel awánima. Tawajo' chupan ronojel ri ac'aslen, riq'ui ri anojibal y riq'ui chuka' ronojel ri awuchuk'a'. Yac'are' ri pixa' ri más nim rejkalen. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y c'o chuka' jun ruca'n pixa' ri nim rejkalen y juba' ma junan riq'ui ri nabey. Y ri pixa' ri' nubij c'a: Can achi'el ri nawajo' ka awi' riyit, can queri' c'a chuka' que'awajo' ri awuc' awach'alal. Y ya ca'i' pixa' re' ri más ye nima'k quejkalen, xcha' c'a ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y ri aj tz'ib xubij c'a chare ri Jesús: Tijonel, can queri' wi. Kas kitzij ri xabij chi xaxu (xaxe) wi jun Dios c'o, y majun chic jun. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Rajawaxic chi nikajo' riq'ui ronojel kánima. Rajawaxic chi nikajo' riq'ui ri kanojibal, chupan ronojel ri kac'aslen y riq'ui chuka' ronojel ri kachuk'a'. Y achi'el chuka' nikajo' ka ki' riyoj, can que c'a chuka' ri' quekajo' ri kuc' kach'alal. Y wi yekaben c'a re', can más quejkalen que chuwech ri chicop ri yecamisex y yeporox chuwech ri Dios; y más quejkalen que chuwech xabachique cosa ri nikatzuj (nikasuj) chuwech ri Dios, xcha' c'a ri aj tz'ib. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y tek ri Jesús xrac'axaj chi can jabel wi xk'ax chuwech ri jun aj tz'ib ri', ri Jesús xubij c'a chare: Riyit xa ma nej ta chic c'a yitc'o wi riche (rixin) chi yatoc pa rajawaren ri Dios, xcha' chare. Y yac'ari' tek can majun chic ri xbano cowil chi c'o ta ri xuc'utuj apo chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y ri Jesús yerutijoj c'a ri winek ri quimolon qui' riq'ui, chiri' pa rachoch ri Dios, y xubij c'a chique: ¿Achique c'a ruma tek ri aj tz'iba' niquibij chi ri Cristo xa choj jun ralc'ual ca ri rey David? ");
INSERT INTO cakWNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Tek xa can ya ri rey David xbin ri xk'alajsex chare ruma ri Lok'olaj Espíritu. Ri David can rubin wi ca: Ri Dios xubij chare ri Wajaf: Catz'uye' re pa wajquik'a', c'a ya tek xquenya' na pan ak'a' pan awaken ri ye'etzelan awuche (awixin). Queri' xubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y wi ri rey David, Wajaf xcha' chare ri Cristo, ¿achique c'a ruma tek ri aj tz'iba' niquibij chi ri Cristo xa choj jun ralc'ual ca ri rey David? xcha' ri Jesús. Y sibilaj ye q'uiy chique ri winek ri can riq'ui wi ronojel cánima xquic'axaj ri xubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y ri Jesús xubij c'a chuka' chique ri winek tek yerutijoj: Man c'a tiben ta achi'el niquiben ri aj tz'iba'. Ruma riye' sibilaj nika chiquiwech niquicusaj tukutek tak tziek, riche (rixin) chi queri' nitz'et chi can c'o quik'ij. Nika chuka' chiquiwech chi niya'ox (nya') rutzil quiwech ri pa tak c'aybel. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, can ya c'a ri nabey tak ch'aquet yequicanola', riche (rixin) chi queri' nibix chi riye' c'o quik'ij. Y can queri' chuka' yequibanala' ri pa nima'k tak wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y yequelesala' chuka' ronojel quicosas ri malcani' tak ixoki'. Y xaxu (xaxe wi) riche (rixin) chi can quenimex chi riye' can ye utzilaj tak winek, yeyaloj tek niquiben orar. Pero riye' can xtik'ax ruwi' ri ruc'ayewal ri xtika pa quiwi', ruma sibilaj q'uiy quimac, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y ri Jesús tz'uyul c'a chiri' chuwech apo ri acuchi (achique) niyalox wi ca ri ofrenda chiri' pa rachoch ri Dios. Yac'ari' tek Riya' yerutzu' ri winek tek niquiyala' ca puek chiri'. Xerutz'et c'a ye q'uiy beyoma' ri can q'uiy puek niquiyala' ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Y xapon c'a chuka' jun ixok malca'n ri can nik'alajin chi ma beyon ta y xuya' c'a ca ca'i' tak puek ri ma rubanon ta ni jun centavo. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y tek ri Jesús xutz'et ri ixok ri', xuc'ut c'a chiquiwech ri rudiscípulos y xubij chique: Kitzij c'a nbij chiwe, chi riyin ntz'et chi xa ya la ixok la' ri xya'o ca más q'uiy que chiquiwech quinojel ri ye yayon ca puek. ");
INSERT INTO cakWNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ruma riya', astape' xa ti meba', xa can xuya' c'a ca ronojel ri c'o riq'ui; astape' xa can yari' ri nic'atzin chare riche (rixin) chi nutzukbej ri'. Yac'a la nic'aj chic, astape' q'uiy puek xquiyala' ca, xa juba' oc chare ronojel ri beyomel ri c'o quiq'ui ri xquiyala' ca, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y tek ri Jesús ntel c'a pe ri pa rachoch ri Dios, jun chique ri rudiscípulos xubij c'a chare: Tijonel, tatzu' re nima'k tak jay riche (rixin) re rachoch ri Dios, y re nima'k tak abej re ye ucusan chare, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Y ri Jesús xubij chare ri rudiscípulo: Riyit can ye'atzu' c'a chi re jay re' can ye jabel y ye nima'k, pero xtapon na jun k'ij tek xa can xquewulex y majun chic ri xtipa'e' ta ca. Ronojel re nima'k tak abej re ye ucusan chique re jay re', xa can xquewulex c'a pe. Can majun c'a abej ri xtic'oje' ta ca achi'el la rubanon wacami, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y tek ri Jesús xapon c'a pa ruwi' ri juyu' Olivos, xtz'uye' c'a ka ri acuchi (achique) jabel niquitzu' wi pe ri rachoch ri Dios, y yac'ari' tek ri Pedro, ri Jacobo, ri Juan y ri Andrés xejel c'a apo riq'ui ri Jesús y xquic'utuj c'a chare: ");
INSERT INTO cakWNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Tabij c'a chake, ¿ajan (jampe') c'a xtic'ulwachitej ri xabij yan ka chrij ri rachoch ri Dios? ¿Y achique c'a retal nibanatej tek xa yec'ulwachitej yan ri'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y xpe ri Jesús quec'are' ri xuchop rubixic chique: Can jabel c'a tichajij iwi' riche (rixin) chi ma xquixk'olotej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ruma can ye q'uiy ri xquepe y xtiquibila': Yin c'a riyin ri Cristo, xquecha'. Y sibilaj ye q'uiy ri xquek'olotej pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Y tek xtiwac'axala' c'a chi yec'o ruwach'ulef ri c'o ch'a'oj ntajin chiquicojol y xtiwac'axala' rutzijol chi c'o chuka' ch'a'oj ri xquepe, man c'a tisach ta ic'u'x, ruma ronojel ri' xa can c'o c'a chi yebanatej na. Pero xa ma ya ta ri' ri ruq'uisbel tak k'ij chare re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jun tinamit xtiyacatej c'a el chi nberubana' ch'a'oj riq'ui jun chic tinamit. Yec'o c'a chuka' nima'k tak ruwach'ulef ri xqueyacatej el chi nbequibana' ch'a'oj quiq'ui nic'aj chic nima'k tak ruwach'ulef. Xquepe silonel xabachique lugar chare re ruwach'ulef y xquepe chuka' wayjal y q'uiy c'a chuka' quiwech ch'a'oj xquepe chiquicojol ri winek. Y ri' xa c'ari' ri nabey tak tijoj pokonal y xquepe chic c'a nic'aj chic quiwech tijoj pokonal. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero riyix can jabel c'a tichajij ka iwi'. Ruma xa can yec'o c'a ri xquixjacho pa quik'a' ri achi'a' ri pa moc (comon) yek'ato tzij. Y chuka' xquixquich'ey pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. Y xquixuc'uex c'a chiquiwech aj k'atbel tak tzij; xquixuc'uex chiquiwech reyes y nic'aj chic aj k'atbel tak tzij. Y xa wuma c'a riyin tek xtic'ulwachij queri', pero xa can xquixcowin c'a xquinik'alajsaj chiquiwech riye'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y can rajawaxic chi nitzijox na nabey ri lok'olaj ch'abel ri niya'o colotajic pa ronojel ruwach'ulef, c'ac'ari' xtoka ri ruq'uisbel k'ij chare re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yac'a tek xquixuc'uex riche (rixin) chi yixbejach pa quik'a' ri aj k'atbel tak tzij, ma tich'ujirisaj ta iwi' chuch'obic achique chi ch'abel ri xtibij. Riyix xaxu (xaxe wi) c'a tibij ri achique chi ch'abel ri xtuya' ri Dios chiwe, ruma xa can ma yix ta chic riyix ri xquixch'o chupan ri hora ri', xa can ya chic ri Lok'olaj Espíritu ri xtich'o. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Ruma xtibanatej c'a chuka', chi wi yec'o ta ca'i' achi'a' cach'alal qui', jun chique riye' xtiyacatej y xtujech ri rach'alal pa camic. Chuka' can yec'o wi tata'aj ri xqueyacatej chiquij ri calc'ual. Ri alc'ualaxela' xqueyacatej chuka' chiquij ri quite' quitata' y xquequiya' pa camic. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Xa can xquixetzelex wi c'a cuma quinojel, ruma icukuban ic'u'x wuq'ui riyin. Yac'a ri ma xtutzolij ta ri' chrij y xtucoch' ronojel c'a pa ruq'uisbel, yac'ari' ri xticolotej. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y chuka' can xtapon wi c'a ri k'ij tek xquebanatej ri xajan chupan ri lok'olaj lugar ri xa ma ruc'amon ta chi nibanatej chiri'. Can achi'el ri tz'ibatal ca ruma ri Daniel, jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Ri nitz'eto c'a ri tz'ibatal ca, tik'ax c'a chuwech ri nutz'et. Riche (rixin) chi queri' tek xtitz'et chi can ya chic ri' ri nibanatej, ri yixc'o pa Judea xa can quixanmej c'a el y tiwewaj iwi' ri pa tak juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri c'o c'a pa ruwi' ri rachoch tek xtibanatej ronojel ri', ma tika ta pe riche (rixin) chi ntoc pa rachoch riche (rixin) chi c'o na ri nberuc'ama' pe. Xa choj queri' tanmej el. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri nisamej c'a pa juyu', ma tibe ta chic chrachoch chuc'amaric ri ruchaqueta. Xa choj chuka' queri' tanmej el. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Yac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a yetz'uman na ri tak cal, juyi' oc quiwech tek xtapon ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rumac'ari' xa tic'utuj chare ri Dios chi ronojel ri' man ta xtibanatej pa ruk'ijul ri job, riche (rixin) chi queri' ma nitij ta más pokon tek yixanmej. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ruma tek xtapon c'a ri k'ij ri', can xtik'ax ruwi' ri tijoj pokonal ri xtipe, jun tijoj pokonal ri majun bey c'ulwachitajnek ta pa ruwi' re ruwach'ulef, jani' chi tiempo ri winakirsan wi pe ruma ri Dios. Y chuka' ri jun tijoj pokonal ri' majun bey chic c'a xtic'ulwachitej ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y wi xa ta ri Ajaf Dios man ta nuben chi xa k'atatel ri k'ij riche (rixin) ri tijoj pokonal ri', quinojel ta yecom. Pero ruma ri rutzil Riya' pa quiwi' ri ye rucha'on chic, can xtuben wi chi xa k'atatel ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan ri k'ij ri', wi yec'o c'a ri yebin chiwe: Titzu', ya c'a Cristo re'. O wi niquibij chiwe: Titzu', ya c'a Cristo la', man c'a tinimaj ta ri niquibij chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ruma can yec'o c'a ri xquebec'ulun pe y xtiquibila' c'a chi ye riye' ri Cristo. Yac'a riyix man c'a que'inimaj ta, ruma xa ye k'olonel. Y yac'a chuka' tiempo ri' tek xquebec'ulun pe ri xquebin chi ye profetas ri niquibij chi niquik'alajsaj ri ruch'abel ri Dios. Yac'a riyix man c'a que'inimaj ta, ruma xa ye k'olonel chuka'. Y xquequibanala' c'a milagros ri majun bey ye tz'eton ta, ruma nicajo' chi yenimex y yec'o ri xquek'olotej pa quik'a'. Y wi xa ta yecowin, riye' yequik'ol ta chuka' ri ye cha'on chic ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero riyix man c'a quixk'olotej ta pa quik'a', xa can tichajij c'a iwi', xa rumac'ari' xinbij yan ca chiwe ronojel ri xquebanatej. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupan ri k'ij tek k'axnek chic ri tijoj pokonal ri', xtibanatej c'a chi ri k'ij xtik'ekumatej y ri ic' chuka' ma xtitzu'un ta chic. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri ch'umila' xquetzak c'a el chuwech ri caj. Can ronojel wi c'a ri nimalaj tak uchuk'a' ri yec'o chicaj xquesilon na. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Y yac'ari' tek xquinquitz'et riyin ri C'ajolaxel ri xinalex chicojol, chi yin petenak pa sutz', riq'ui chic nimalaj wuchuk'a' y riq'ui chuka' jun nimalaj nuk'ij nuc'ojlen. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y yac'ari' tek riyin xquentek ri nu'ángeles chiquimolic ri ye nucha'on chic. Can xquequimol wi c'a pe re quere' pa relebel k'ij y re quere' pa rukajbel k'ij, re quere' pa jotol y re quere' chuka' pa xulan. Can xquequimol wi c'a pe chi ronojel ruwach'ulef; nitiquir pe pa jun ruchi' re caj, c'a la jun chic ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Can tic'ama' c'a ina'oj chrij ri juwi' che' ri higo rubi'. Tek can yeraxer c'a pe ri ruk'a' y niquichop yeq'uiy pe ri ruxak, etaman c'a ri' chi ya xa nik'ax yan ruk'ijul ri sak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y quec'ari' tek xtitz'et chi yec'ulwachitej chic ronojel ri xinbij yan ka, tiwetamaj c'a ri' chi xa noka yan ri ruq'uisbel tak k'ij. Xa can nakaj chic c'o wi pe. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y tiwac'axaj c'a jabel re xtinbij chiwe re wacami: Ronojel ri' xtic'ulwachitej, tek ri winek riche (rixin) re tiempo re kachapon, c'a ma jane queq'uis ta chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Y re ruwach'ulef y ri caj xa xquek'ax. Yac'a ri nuch'abel can ma xtiq'uis ta chak que ta ri', xa can xtibanatej na wi ri nubij. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Yac'a ri k'ij y ri hora tek riyin xquipe, majun achique etamayon ta. Ni xa ta ri ángeles ri yec'o chila' chicaj ma quetaman ta ajan (jampe') tek xquipe chic jun bey. Queri' chuka' riyin ri C'ajolaxel ma wetaman ta. Xa can xu (xe) wi c'a ri Nata' ri etamayon ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Riyix xa can tichajij c'a apo jabel ri ic'aslen. Can tiwoyobej c'a, y tibana' chuka' orar, ruma xa ma iwetaman ta ajan (jampe') xtapon ri ruk'ijul tek xquipe chic jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Achi'el tek jun achi nuya' ca ri rachoch y nibe nej c'a pa jun chic tinamit. Riya' can nuchilabej c'a ca ri rusamaj chique ri ye rumozos. Can nuyala' c'a ca quisamaj chiquijujunal; y chare ri chajinel can nubij c'a ca chi can troyobej apo. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Can quec'ari' tibana' riyix, can quiniwoyobej apo. Achi'el ri achi chajinel, ruma ma retaman ta ajan (jampe') xtoka ri rajaf ri jay, riya' c'o chi noyoben apo. Ruma ri rajaf ri jay riq'ui juba' xa noka tek ntoc pe ri ak'a', o ya ri pa nic'aj ak'a', o tek yesiq'uin pe ri ec' tek xa nipe yan rusekeric o ri nimak'a' yan. Rumari' riyix can quiniwoyobej apo. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ruma riyin can nwajo' chi yiniwoyobej ta apo, y man ta yixwer, ruma can ma xtinya' ta na rutzijol tek xquipe. ");
INSERT INTO cakWNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y can achi'el ri nbij chiwe riyix chi quiniwoyobej apo, can queri' chuka' nbij chique quinojel, xcha' ri Jesús chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa ca'i' chic c'a k'ij nrajo' chi napon ri nimak'ij pascua, jun quinimak'ij ri israelitas tek niquitij ri caxlan wey ri majun ch'om (levadura) riq'ui. Y yac'ari' tek ri principali' tak sacerdotes y ri aj tz'iba' niquich'obola' achique chi k'oloj ri xtiquicusaj riche (rixin) chi nika ta c'a ri Jesús pa quik'a' y c'ac'ari' niquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Y niquibila' c'a chiquiwech: Ma tikachop ta c'a chupan re nimak'ij re', riche (rixin) chi ma yeyacatej ta pe ri winek chikij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y ri Jesús c'o c'a ri pa tinamit Betania, chiri' pa rachoch ri Simón ri xc'achojsex chare ri itzel yabil ri lepra rubi'. Ri Jesús tz'uyul c'a ri pa mesa niwa', y yac'ari' tek c'o jun ixok xoc apo y ruc'uan apo jun c'ojlibel (frasco) ri banon riq'ui jun abej alabastro rubi' y c'o el nardo chupan; jun ak'om ri jubul ruxla' ri sibilaj jotol rajel. Y tek ri ixok ri' xuk'ip el ri ti rukul ri c'ojlibel (frasco), xuk'ej c'a ri ak'om jubul ruxla' pa rujolon (ruwi') ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y yec'o c'a ri xpe coyowal tek xquitz'et chi queri' xuben ri ixok riq'ui ri ak'om ri' y xquibila' c'a: ¿Achique c'a ruma tek la ixok la' chi chak queri' xutix la ak'om la'? ");
INSERT INTO cakWNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ruma xa utz chi xc'ayix ta re ak'om re' chi más oxi' ciento denarios y ri rajel xa xya'ox (xya') ta chique ri pobres, xecha'. Y q'uiy c'a ri niquibij apo chare ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xubij c'a chique: ¿Achique c'a ruma tek ma yixtane' ta ka chi tzij chrij re ixok re'? Xa tiya' ca, ma tinek ta. Ruma riya' jun utzilaj samaj c'a ri xuben wuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri pobres xa can yec'o wi iwuq'ui, y xabachique k'ij niwajo' ye'ito', can tibana' c'a utzil chique. Yac'a riyin ma ronojel ta tiempo xquic'oje' iwuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Riya' xuben c'a ri achique nicowin nuben wuq'ui. Riya' xa can xuben yan apo nuchojmil, riche (rixin) chi xquibemuk ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Y tiwac'axaj na pe' jabel re xtinbij chiwe, chi xabacuchi (xabachique) c'a xtitzijox wi ri lok'olaj ch'abel ri niya'o colotajic, chiri' chuka' xtitzijox wi re xuben re jun ixok re'. Can pa ronojel c'a ruwach'ulef xtitzijox wi, chi natabel riche (rixin) riya', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Y jun c'a chique ri ye cablajuj rudiscípulos ri Jesús, ri Judas Iscariote rubi', xapon c'a quiq'ui ri principali' tak sacerdotes, riche (rixin) chi xutzuj (xusuj) ri', wi nicajo' chi nujech ri Jesús pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y tek riye' xquic'axaj queri', sibilaj xequicot. Y xquitzuj (xquisuj) c'a puek chare. Y yac'ari' tek ri Judas Iscariote xuchop c'a ruch'obic chi achique ta rubanic nuben chi xtujech ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chupan c'a ri nabey k'ij chare ri nimak'ij, tek ri israelitas niquitij ri caxlan wey ri majun ch'om (levadura) riq'ui, ya c'a chuka' k'ij ri' tek yecamisex ri tak carne'l riche (rixin) ri pascua. Y can yac'a chuka' k'ij ri' tek ri discípulos xquic'utuj chare ri Jesús: ¿Acuchi (achique) c'a nawajo' chi naben wi ri wa'in chupan re jun pascua re', riche (rixin) chi nbekabana' c'a ruchojmil ronojel ri nic'atzin? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y ri Jesús can xerutek wi el ye ca'i' chique ri rudiscípulos, y xubij el chique: Quixbiyin pa tinamit Jerusalem, y chiri' xtitz'et c'a chi c'o jun achi ri ruc'amom pe ya' pa jun cucu'. Titzekelbej c'a el. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ri jay ri xtoc wi riya', chiri' c'a chuka' quixoc wi riyix y tibij c'a chare ri rajaf ri jay: Ri Katijonel rubin c'a pe: ¿Acuchi (achique) c'o wi jun jay ri jamel chare ri awachoch, ri utz riche (rixin) chi nben ri wa'in riche (rixin) re pascua ye wachibilan ri nudiscípulos? quixcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y ri rajaf ri jay xquixruc'uaj c'a pa jun ruca'n tanaj (wik) chare ri jay. Y chiri' c'o jun nimajay ri chojmirisan chic rupan. Ya ri chiri' tibana' wi ruchojmil ri xtikatij chupan re pascua, xe'uche'ex el ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y ri ca'i' discípulos xebe c'a pa tinamit Jerusalem. Y tek xe'apon, can xbanatej na wi achi'el ri rubin el ri Jesús chique. Y riye' can xquiben wi c'a ruchojmil ronojel ri nic'atzin chare ri wa'in chupan ri pascua ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yac'a tek xoc pe ri ak'a' chupan ri k'ij ri', yari' tek ri Jesús ye rachibilan ri cablajuj rudiscípulos xe'apon ri chiri' pa jay. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y tek riye' ye tz'uyul chic c'a apo pa mesa, y yetajin chic chi wa'in, yac'ari' tek ri Jesús xubij chique ri rudiscípulos: Kas kitzij c'a nbij chiwe, chi jun chiwe riyix ri xquijacho el pa quik'a' ri winek. Jun ri can niwa' wuq'ui, yari' ri xquijacho el pa quik'a' ri winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Riye' can yac'ari' tek xpe bis pa cánima. Y niquic'utula' c'a apo chare ri Jesús: ¿La ma yin ta cami riyin ri xquibano queri'? xecha' c'a chiquijujunal. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y yac'ari' tek ri Jesús xubij chique: Ri' jun chiwe riyix cablajuj, ri xtumu' pe ri rucaxlanway wuq'ui pa lek. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can tiwac'axaj c'a ri xtinbij chiwe, chi riyin ri C'ajolaxel ri xinalex chicojol can xquicamisex na wi, achi'el ri tz'ibatal ca. Pero juyi' c'a ruwech ri xquijacho el riyin ri C'ajolaxel ri xinalex chicojol. Ri achi ri xquijacho el, utz ta chi man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y tek can c'a yetajin na c'a chi wa'in, ri Jesús xuc'om c'a apo jun caxlan wey y tek ruc'utun chic ri rubendición ri Dios pa ruwi', c'ac'ari' xuwech'ela' ri caxlan wey ri' y xuya' chique ri rudiscípulos y xubij c'a chique: Tic'ama' c'a re caxlan wey re' y titija'. Ruma yac'are' ri nuch'acul. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y ri Jesús xuc'om chuka' apo ri vaso ri c'o ruya'al uva chupan; y tek rumatioxin chic chare ri Dios, xuya' chique, y quinojel c'a xquikum ri ruya'al uva. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y Riya' xubij c'a chique ri rudiscípulos: Yac'are' ri nuquiq'uel ri xtibiyin tek xquicamisex. Riq'ui c'a ri xtibiyin ri nuquiq'uel, can yac'ari' tek xtic'achoj ri c'ac'ac' trato ri rajowan pe ri Dios chi nuben quiq'ui ri winek. Ri nuquiq'uel ri xtibiyin, can riche (rixin) wi c'a chi ye q'uiy winek yecolotej. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tiwac'axaj c'a re xtinbij chiwe: Yac'are' ri ruq'uisbel mul ri xinkum el re ruya'al uva. Y tek xtinkum chic jun bey, c'a chupan chic c'a ri rajawaren ri Dios. Y ri ruya'al uva ri xtinkum ri chiri', jun c'ac'ac' ruya'al uva, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y tek quibixan chic c'a ri bix riche (rixin) ri pascua, ri Jesús y ri rudiscípulos xe'el el ri chiri' pa jay y xebe ri pa juyu' ri Olivos rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y tek ye benak c'a, ri Jesús xubij chique ri rudiscípulos: Chi'iwonojel riyix xtitaluj el iwi' y xquiniya' c'a ca nuyon chupan re ak'a' re', tek xa xtitz'et chi riyin yijach el pa quik'a' ri winek. Ruma ri Dios can nubij wi c'a chupan ri tz'ibatal ca: Tek riyin xtinya' k'ij chi nicamisex ri aj yuk', ri rucarne'l xa xtiquitaluj el qui'. Queri' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Yin c'a riyin ri Aj Yuk' pero man c'a xquicom ta el jurayil, xa xquic'astej chic pe. Y xquixinwoyobej ri chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Yac'ari' tek ri Pedro xubij: Astape' can quinojel xcatquiya' ca ayon, yac'a riyin ma xcatinya' ta ca, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yac'a ri Jesús xubij chare ri Pedro: Riyin can kitzij c'a nbij chawe, chi wacami chupan re jun ak'a' re', c'a ma jane tisiq'uin ta pe ri ec' pa rucamul, tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Y ma riq'ui wi chi queri' xubij ri Jesús, ri Pedro xa can nutij ruk'ij chubixic chare ri Jesús: Wi can rajawaxic chi yicom junan awuq'ui riyit, can quec'ari' ri', pero can ma xtinbij ta chi ma wetaman ta awech, xcha' ri Pedro. Y ri nic'aj chic discípulos can queri' chuka' xquibij. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri rudiscípulos xe'apon c'a chupan ri lugar ri Getsemaní rubi'. Xpe ri Jesús xubij c'a chique ri rudiscípulos: Riyix quixtz'uye' na c'a ca juba' wawe', y riyin nbenbana' na orar, xcha' ca chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y xaxu (xaxe wi) c'a ri Pedro, ri Jacobo y ri Juan ri xeruc'uaj el. Yac'ari' tek Riya' can xuna' yan k'axon ruma ri xtiberuc'ulwachij. Can jun nimalaj bis c'a ri xpe pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xubij c'a chique ri ye oxi' rudiscípulos: Sibilaj nim ri bis c'o pa wánima, ya yirucamisaj nna' riyin. Quixc'oje' c'a ca juba' wawe', quixc'ase' y ma quixwer ta ka, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Riya' xbiyin chic c'a apo juba' y c'ac'ari' xxuque' ka y xukasaj ka ri' c'a pan ulef y xuben c'a orar. Y xuc'utuj c'a chare ri Dios chi xa ta c'o modo, choj ta nik'ax el ri hora ri', chi man ta nuk'axaj ri tijoj pokonal. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y quec'are' ri ch'abel ri xerubij ri pa ru'oración: Nata' Dios, Nata' Dios, wetaman chi riyit yacowin naben ronojel. Tabana' c'a chi man ta nk'axaj re jun tijoj pokonal re'. Pero ma taben ta c'a ri xa nuraybel riyin. Tabana' ri araybel riyit, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y tek Riya' xbeyacatej pe chare ri oración, xpe c'a quiq'ui ri ye oxi' rudiscípulos, y tek xoka quiq'ui xa ye warnek chic. Xpe Riya' xubij c'a chare ri Pedro: Simón, ¿xa xawer ka? ¿Can ma juba' c'a xacowin ta xac'ase' jun ti hora wuq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Man c'a quixwer ta ka, xa tibana' orar y tic'utuj chare ri Dios riche (rixin) chi ma yixtzak ta pa mac tek yixtojtobex. Can wetaman wi chi ri iwánima can nrajo' wi nuben ri nrajo' ri Dios. Pero ri ich'acul xa majun ruchuk'a', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y ri Jesús xbe chic c'a apo jun bey chubanic orar. Riya' xucamuluj chic c'a rubixic ri ch'abel ri xerubij chupan ri oración ri xa c'a juba' tuben ka. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y tek xpe chic c'a jun bey quiq'ui ri ye oxi' rudiscípulos, xa ye warnek chic c'a jun bey xeril, ruma ri discípulos ri' sibilaj al rubanon ri runak' tak quiwech ruma ri quiwaran. Y riye' ma nich'obotej ta c'a chiquiwech achique ri niquibij, ruma xe'ilitej chic jun bey chi quichapon waran. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Y ri Jesús xbe chic c'a chubanic orar. Y tek xtzolin pe ri pa rox mul, Riya' xubij c'a chique ri ye oxi' rudiscípulos: Wacami can quixwer c'a y quixuxlan. Ya xa riq'ui c'a re'. Riyin ri C'ajolaxel ri xinalex chicojol can ya wi c'a re' xoka ri hora, chi xquijach c'a el pa quik'a' ri aj maqui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chanin, quixyacatej. Yala' petenak ri xquijacho el pa quik'a' ri aj maqui', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y tek ri Jesús can c'a nich'o na c'a quiq'ui ri rudiscípulos, yac'ari' tek xoka ri Judas ri jun chique ri cablajuj rudiscípulos, y ye ruc'uan c'a apo ye q'uiy winek ri quic'ualon che' y espada. Quinojel ri' ye takon c'a el cuma ri principali' tak sacerdotes, cuma ri aj tz'iba' y cuma chuka' ri rijita'k tak achi'a' ri c'o quik'ij chiquicojol ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri nijacho el ri Jesús can rubin c'a pe chique ri ye petenak riq'ui, chi achique rubanic xtuben riche (rixin) chi xtuc'ut ri Jesús chiquiwech. Riya' rubin c'a pe chique: Ya c'a ri xquijel apo riq'ui y xtintz'umaj (xtintz'ubaj) ruchi', yari' ri Jesús. Tichapa' chi utz riche (rixin) chi ma nanmej ta ca chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y tek ri Judas xapon, can choj c'a xbe apo riq'ui ri Jesús y xubij chare: Nutijonel, Nutijonel, xcha' chare y c'ac'ari' xutz'umaj (xutz'ubaj) ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y ri winek ri ye benak chuchapic ri Jesús can yac'ari' tek xquichop. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun c'a chique ri yec'o riq'ui ri Jesús chiri', xrelesaj ri ru'espada y xusoc ri rumozo ri nimalaj sacerdote y can ya ri ruxquin ri xuchoy. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y c'ac'ari' xpe ri Jesús xubij chique ri winek ri ye benak chuchapic: ¿Achique c'a xich'ob riyix? ¿Xich'ob chi yix petenak chuchapic jun alek'om y rumari' ic'amom pe che' y espada? ");
INSERT INTO cakWNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Riyin can k'ij k'ij c'a xic'oje' iwuq'ui chiri' pa rachoch ri Dios, tek xinc'ut ri ruch'abel chiwech y majun bey xinichop ta. Pero can quere' c'o chi nibanatej, ruma can quere' wi ri tz'ibatal ca chupan ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y can yac'ari' tek ri ye rudiscípulos ri Jesús, xquiya' ca ruyon y xe'anmej el. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Y c'o c'a jun ti c'ajol ri can tzeketel el chrij ri Jesús y xa pa jun tziek nim rucuchun wi el ri'. Y ri ye chapayon el ri Jesús, xquichop c'a ri ti c'ajol ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero riya' xa xel c'a el chupan ri tziek ri', y xa choj queri' ch'anel xanmej el chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Y ri winek ri ye chapayon el ri Jesús xquic'uaj c'a el c'a pa rachoch ri nimalaj sacerdote. Y chiri' chuka' xquimol wi qui' ri principali' tak sacerdotes, cachibilan ri rijita'k tak achi'a' ri c'o quik'ij y ri aj tz'iba'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y ri Pedro c'anej c'o wi ca, y rutzekelben el ri Jesús. Y tek ri Jesús xucusex apo pa rachoch ri nimalaj sacerdote, chuka' ri Pedro xoc apo chiri' chuwajay, y xtz'uye' c'a ka chiquicojol ri ye aj ch'ame'y ri yec'o apo chiri', ri quimek'on apo qui' chuchi' k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y ri principali' tak sacerdotes, y quinojel c'a ri achi'a' ri can pa moc (comon) yek'ato tzij, niquicanola' c'a achique chi mac niquil chrij ri Jesús, riche (rixin) chi queri' can niquitek wi pa camic, pero xa majun mac ri xquil ta chrij. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ruma astape' can ye q'uiy ri xe'apon ri xquitz'uc tzij chrij ri Jesús, pero xa ma junan ta ri xquibij. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y c'ac'ari' yec'o chic nic'aj ri xebepa'e' pe y quec'are' ri xquibij chrij ri Jesús: ");
INSERT INTO cakWNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Riyoj can kac'axan c'a tek Riya' rubin: Riyin xtinwulaj re rachoch ri Dios ri banon cuma achi'a', y pan oxi' k'ij npaba' chic jun ri ma achi'a' ta xquebano. Queri' rubin, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ma riq'ui wi ri', xa ma junan ta chuka' ri xquibila' apo. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y ri Caifás, ri nimalaj sacerdote, xbepa'e' c'a pe ri pa quinic'ajal y xuc'utuj chare ri Jesús: ¿Kitzij cami ri xquibij ka chawij re winek re'? ¿Y achique c'a nabij riyit chi natobej awi'? xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Yac'a ri Jesús xa ma xch'o ta c'a. Can majun c'a ch'abel ri xubij. Rumari' xpe ri nimalaj sacerdote, xuc'utuj chic c'a chare: ¿La yit c'a riyit ri Cristo ri Ruc'ajol ri nimalaj Dios ri nikaya' ruk'ij? xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xubij c'a: Ja' (je), yin c'a riyin. Y xquinitz'et chuka' riyin ri C'ajolaxel ri xinalex chicojol chi yin tz'uyul pa rajquik'a' ri Dios ri nicowin nuben ronojel. Y xquinitz'et tek yipe pa sutz' ri chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Tek ri nimalaj sacerdote xrac'axaj ri', xuretz (xutzer) ka ri rutziak chrij, ruma itzel xrac'axaj y xubij c'a: Ma rajawaxic ta c'a chi noka chic jun ri norubij chake chi re achi re' can aj mac wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Chi'iwonojel riyix xiwac'axaj ri xubij chi ya Riya' ri Cristo. Can itzel c'a xuben chuwech ri Dios. ¿Achique c'a nibij riyix wacami chi nikaben chare? xcha' riya'. Y quinojel c'a xquibij: Ruc'amon c'a chi nicamisex. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y yec'o c'a ri xquichop niquiben q'uiy pokon chare ri Jesús. Xquichop c'a niquichubala' rupalej. Xquitz'apij ruwech. Xquibuc'la' chi k'a', y c'ac'ari' niquic'utula' chare: ¿Achique c'a ri xach'eyo? Tabij na c'a chake, yecha' chare. Chuka' ri ye aj ch'ame'y ri yec'o chiri', xquipak'ila' rupalej ri Jesús chi k'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y tek ri Pedro c'a c'o na c'a chiri' chuwajay ka, c'o c'a jun ixok raj ic' ri nimalaj sacerdote ri xapon chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ri Pedro numek' c'a ri' chuchi' k'ak'. Y yac'ari' tek xpe ri aj ic' nutzu' nutzu' c'a apo ri Pedro, y yac'ari' tek xubij chare: Riyit chuka' yit rachibil ri Jesús ri aj Nazaret, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Yac'a ri Pedro xa xrewaj c'a, ruma xubij: Riyin ma wetaman ta ruwech ri Jesús. Ma nik'ax ta chuka' chinuwech achique ruma tek queri' nabij chuwe, xcha' chare ri aj ic'. Y ri Pedro xel c'a el ri chiri' chiquicojol y xbe chuchi' bey. Y yac'ari' tek xsiq'uin pe ri ec'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y tek ri ixok aj ic' xutzu' chic jun bey ri Pedro, xuchop chic c'a rubixic chique ri yec'o chiri': Re achi re' jun chique ri yec'o riq'ui ri Jesús, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Yac'a ri Pedro xa xrewaj chic jun bey. Y xa c'a jumej tibix queri' chare, ye chic ri yec'o chiri' xebin chic jun bey chare: Can kitzij na wi chi riyit yit jun chique ri yec'o riq'ui ri Jesús. Ruma riyit pa Galilea yape wi, ruma can junan rubanic ri ach'abel quiq'ui, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Yac'a ri Pedro xubij c'a: Riyin ma wetaman ta ruwech ri achi ri nibij riyix. Can chuwech Dios nbij chiwe chi riyin ma wetaman ta ruwech. Y wi ma kitzij ta ri nbij, tika c'a ruc'ayewal pa nuwi', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y yac'ari' tek xbesiq'uin pe ri ec' pa rucamul. Y ri Pedro can yari' tek xenatej chare ri ch'abel ri bin ca chare ruma ri Jesús tek xubij: C'a ma jane tisiq'uin ta pe ri ec' pa rucamul, tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech. Y riya' xuchop jun nimalaj ok'ej tek xel el chiri', ruma xuch'ob c'a quij ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y tek xseker c'a pe chupan ri k'ij ri', ri principali' tak sacerdotes xquimol c'a qui' ye cachibilan ri rijita'k tak achi'a' ri c'o quik'ij y ri aj tz'iba'. Can quinojel wi c'a ri achi'a' ri pa moc (comon) yek'ato tzij, can xquimol wi c'a qui'. Riye' xquich'ob c'a achique ri niquiben chare ri Jesús, y can ximon wi el tek xquic'uaj y xbequijacha' pa ruk'a' ri aj k'atbel tzij ri Pilato rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y yac'ari' tek ri Pilato xuc'utuj chare ri Jesús: ¿Yit c'a riyit ri qui-Rey ri israelitas? xcha' chare. Y ri Jesús xubij c'a: Ja' (je), queri'. Can achi'el ri xabij, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y ri principali' tak sacerdotes, q'uiy c'a ri niquibila' apo chare ri Pilato, chi niquitzujuj (niquisujuj) ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xpe ri Pilato xch'o chic apo riq'ui ri Jesús y xubij c'a chare: Riye', q'uiy ri niquibila' pe chawij chi yatquitzujuj (yatquisujuj), y riyit ¿can majun c'a jun ch'abel ri nabij chi natobej awi'? xcha' ri Pilato chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ma riq'ui wi chi queri' xbix chare, ri Jesús can majun c'a ch'abel ri xubij. Y ri Pilato xumey, ruma majun bey rutz'eton ta chi c'o ta jun winek ri que ta ri' nuben. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y ronojel juna' chupan ri nimak'ij pascua, ri aj k'atbel tzij nrelesaj el jun preso; ri preso ri niquibij ri winek chi utz ntel el. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y ri k'ij ri', c'o c'a pa cárcel jun achi Barrabás rubi' ye rachibilan nic'aj chic rachibil. Riye' ye kajnek c'a pa cárcel ruma xeyacatej chrij ri k'atbel tzij y chuka' xquiben camic. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Y ruma c'a chi ri winek ri' can quetaman chi ri aj k'atbel tzij can nrelesaj wi el jun chique ri yec'o pa cárcel, rumari' xepe riye' xquic'utuj c'a chare ri Pilato chi trelesaj el jun chique ri yec'o pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y ri Pilato can yac'ari' tek xubij pe chique: ¿Niwajo' riyix chi riyin ncol el re achi re' ri i-Rey riyix israelitas? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ri Pilato can que wi c'a ri' ri xubij pe, ruma riya' can retaman wi chi ri principali' tak sacerdotes quiya'on ri Jesús pa ruk'a', ruma itzel niquina' chare chi sibilaj ye q'uiy winek ri yetzekelben riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Y ri principali' tak sacerdotes xquiya' c'a quina'oj ri winek, chi tiquibij apo chare ri Pilato chi xa ya ri Barrabás ri trelesaj el. Y ri winek can queri' xquibij. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y ri Pilato can yac'ari' xbech'o chic pe jun bey y xuc'utuj c'a chique: ¿Y achique c'a ri niwajo' chi nben chare re achi ri nibij chi i-Rey riyix israelitas? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y ri winek xquirek c'a apo quichi' y xquibij: Tataka' rucamisaxic chuwech cruz, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Rumari' ri Pilato xubij chique: ¿Achique c'a rumac rubanon chiwech? Pero riye' xa ma yetane' ta ka. Xa más xquirek apo quichi' y niquibila' apo: ¡Tataka' rucamisaxic chuwech cruz! xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato xrelesaj c'a el ri Barrabás, ruma nrajo' chi nuben ri quiraybel ri winek. C'ac'ari' xutek ruch'ayic ri Jesús y xujech el riche (rixin) chi ticamisex chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepe ri soldados xquicusaj c'a apo ri Jesús chuwajay ri c'o chiri' pa palacio. C'ac'ari' xequisiq'uij (xecoyoj) quinojel ri nic'aj chic soldados, ri ye cachibil. Xequimol c'a apo chrij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y ri soldados ri' xquiya' c'a jun tziek morado chrij ri Jesús, can achi'el wi ri yequicusala' ri reyes. Y xquipach'uj chuka' jun k'ayis ri c'o sibilaj ruq'uixal. Xquiben jun corona chare, y c'ac'ari' xquiya' pa rujolon (ruwi') ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Y can niquiben c'a chi achi'el niquiya' rutzil ruwech ri Jesús, y niquibila' c'a chare: Caquicot c'a riyit ri qui-Rey ri israelitas, yecha' c'a chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Riye' niquik'osij c'a pa rujolon (ruwi') ri Jesús riq'ui jun aj; y niquichubala' chuka'. Can yexucutaj c'a chuwech. Can niquiben c'a chi achi'el niquiya' ruk'ij, pero xa yetze'en c'a chubanic. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y tek riye' xetane' c'a chi yetze'en chrij, xquelesaj el ri tziek morado ri quiya'on ka chrij. C'ac'ari' xquiya' el ri can rutziak wi Riya', y xquic'uaj c'a el riche (rixin) chi nbequibajij chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Tek quichapon c'a el bey, xquic'ul jun achi aj Cirene, ri Simón rubi', quitata' ri Alejandro y ri Rufo. Y riya' petenak pa juyu'. Y ri soldados xquiben c'a chare ri achi ri' chi xuc'uaj el ri rucruz ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y ri soldados pa ruwi' c'a ri jun juyu' Gólgota rubi' xquic'uaj wi ri Jesús. Gólgota ntel chi tzij rubakil rujolon (ruwi') caminek. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y tek yec'o chic c'a chiri', xquitzuj (xquisuj) chare ri Jesús ruya'al uva xolon riq'ui ruya'al jun ti che' ri mirra rubi'. Yac'a ri Jesús ma xrajo' ta xukum. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y tek ri soldados quibajin chic c'a ri Jesús chuwech cruz, xesaquin c'a chrij ri rutziak ri Jesús riche (rixin) chi xquitz'et achique chi tziek ri niquic'uala' el chiquijujunal. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Las nueve c'a ri nimak'a' tek xquibajij ri Jesús chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y pa ruwi' c'a ri cruz, riye' xquiya' c'a jun tz'alan ri tz'iban el chuwech ri achique mac ri niquibij riye' chi xuben ri Jesús y rumari' nicamisex. Chuwech ri tz'alan ri' nubij c'a: YARE' RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y chuka' yec'o ye ca'i' alek'oma' ri xequibajij chuwech cruz. Jun xc'oje' pa rajquik'a' ri Jesús y ri jun chic pa rajxocon. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riq'ui ri' can xbanatej c'a achi'el ri tz'ibatal ca chupan ri ruch'abel ri Dios, tek nubij: Riya' can achi'el chuka' jun aj mac xban chare. Queri' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri winek c'a ri yek'ax el riq'ui ri Jesús, niquisiloj apo quijolon (quiwi') chuwech, y c'o chuka' pokon tak ch'abel ri yequibila' ca chare, ruma can ma niquinimaj ta chi ya Riya' ri Ruc'ajol ri Dios. Ri winek ri' niquibila' c'a ca chare ri Jesús: ¡Ah! riyit ri xabin chi can nawulaj ri rachoch ri Dios y pan oxi' k'ij napaba' chic jun bey, ");
INSERT INTO cakWNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tacolo' c'a awi' ayon riyit y caka c'a pe chuwech la cruz, yecha' c'a ca chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y can queri' chuka' ri ch'abel ri niquibila' ri principali' tak sacerdotes. Riye' y ri aj tz'iba' niquitze'ej c'a ri Jesús y niquibila' c'a chiquiwech: Riya' can yec'o wi c'a ri xerucol, pero Riya' ma nicowin ta nucol el ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Can rubin c'a chi ya Riya' ri Cristo, ri Rey riche (rixin) re katinamit Israel. Wi queri', can tika c'a pe chuwech la cruz, y queri' nikatz'et y nikanimaj, yecha'. Y ri alek'oma' ri ye bajin chuwech quicruz ri yec'o apo chuxquin ri Jesús, c'o chuka' pokon tak ch'abel ri yequibila' apo chare. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y tek xnic'ajer ri k'ij, yac'ari' tak xoc k'eku'm ronojel ri ruwach'ulef. Y ri k'eku'm ri' xq'uis c'a el c'a pa tek a las tres ri tikak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y yac'a hora ri', tek ri Jesús xurek ruchi' y xubij: Eloi, Eloi, ¿lama sabactani? xcha'. Y ri ch'abel ri' ntel chi tzij: Nata' Dios, Nata' Dios, ¿achique c'a ruma tek xinamalij ca? ");
INSERT INTO cakWNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y yec'o ri yec'o apo chiri' chunakajal ri Jesús, tek xquic'axaj ri xubij, xquibila' c'a: ¿Xiwac'axaj? Riya' ya ri Elías ri nusiq'uij (nroyoj), xecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y yac'ari' tek c'o jun ri junanin (anibel) xberumuba' pe jun esponja chupan jun ch'omilaj ruya'al uva, y xuya' chutza'n jun aj y xuya' chare ri Jesús riche (rixin) chi nich'uch'u' ka juba' ri chaki'j chi' chare, y xubij: Tikatzu' na c'a, k'alaj ri' wi nipe ri Elías chukasaxic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Can yac'ari' tek ri Jesús riq'ui c'a ruchuk'a' xurek ruchi' y xcom. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y ri tziek ri achoj riq'ui jachon wi ri rupan ri rachoch ri Dios xel pa ca'i'. Xuchop pe c'a pa ruwi' y xbeq'uis c'a chuxe' ka. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Chuwech apo ri acuchi (achique) c'o wi ri Jesús c'o c'a apo ri quicapitán ri soldados. Riya' xrac'axaj c'a tek ri Jesús riq'ui ruchuk'a' xch'o tek xcom ka. Rumari' tek ri capitán ri' xubij c'a: Can kitzij na wi chi re jun achi re' can Ruc'ajol wi ri Dios, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y yec'o chuka' ixoki' ri c'anej yetzu'un wi apo. Chiquicojol c'a ri ixoki' ri', c'o c'a ri María Magdalena, c'o ri María ri quite' ri José y ri Jacobo ri c'a c'ajol na, y c'o chuka' ri jun ixok Salomé rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ri ixoki' ri', can c'a c'o na ri Jesús pa Galilea, tek quitzekelben y quiniman quilin pe. Y chuka' can yec'o c'a nic'aj chic ixoki' ri quitzekelben apo ri Jesús c'a pa Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Yac'a tek xoc pe ri ak'a' chupan ri k'ij tek xcom ri Jesús, ri winek niquibanala' chic c'a ruchojmil ronojel ri xtic'atzin chique chupan ri uxlanibel k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Y yac'ari' tek xapon jun achi José rubi'; ri aj pa tinamit Arimatea. Riya' cachibil ri achi'a' ri aj k'atbel tzij chiquicojol ri quiwinak; y c'o c'a ruk'ij chiquicojol riye'. Riya' chuka' can royoben tek xtoka ri rajawaren ri Dios. Y riya' can majun xibinri'il chuwech chi xapon riq'ui ri Pilato chupan ri hora ri', chuc'utuxic ri ruch'acul ri Jesús riche (rixin) chi numuk. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Yac'a ri Pilato man c'a nunimaj ta chi can xcom yan chanin ri Jesús. Rumari' riya' xusiq'uij (xroyoj) ri capitán, y xuc'utuj chare wi kitzij chi caminek chic ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y tek ri Pilato xrac'axaj yan ca chare ri capitán, c'ac'ari' xuya' k'ij chare ri José chi nberumuku' ca ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y ri José xulok' c'a jun sakilaj tziek. Y tek rukasan chic pe ri ruch'acul ri Jesús chuwech ri cruz, xubor c'a chupan ri tziek ri'. Y c'ac'ari' xberuya' ca pa jun jul riche (rixin) chi niya'ox (nya') caminek chupan ri c'oton chuwech jun nimabej. Y c'ac'ari' xutz'apij ca ruchi' riq'ui jun nimalaj setesic abej ri tz'apebel ruchi' ri jul. ");
INSERT INTO cakWNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ri María Magdalena y ri María ri quite' ri José y ri Jacobo, xquitzu' c'a jabel acuchi (achique) xmuk wi ca ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y tek k'axnek chic c'a ri uxlanibel k'ij, ri María Magdalena, ri María ri rute' ri Jacobo, y chuka' ri ixok Salomé rubi' xbequilok'o' pe ak'om ri jubul ruxla'. Y ri ak'om ri' nic'atzin c'a chique riche (rixin) chi nbequiya' ca chrij ruch'acul ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y nimak'a' yan c'a chupan ri nabey k'ij chare ri semana, xebe c'a chuchi' ri jul. Y tek ntel pe ri k'ij, yac'ari' tek xe'apon. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y riye' xquibila' c'a chiquiwech: ¿Y achique c'a xtelesan el ri abej tz'apebel ruchi' ri jul chkawech? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Yac'a tek xquitz'et ri jul, xquitz'et chi xa jakel chic. Ri nimalaj abej tz'apebel ruchi' ri jul, xa elesan chic el. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y tek ye oconek chic c'a apo chupan ri jul, riye' xquitz'et c'a chi c'o jun ri achi'el jun c'ajol achi, tz'uyul pa cajquik'a' apo, rucusan jun tziek sek ri napon c'a chraken ka. Y ri ixoki' tek xquitz'et ri', xquixibij qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Yac'a riya' xubij chique: Man c'a tixibij ta iwi'. Riyin wetaman chi riyix nicanoj ri ruch'acul ri Jesús aj Nazaret, ri xcamisex chuwech cruz. Ri ruch'acul xa man c'o ta chic wawe'. Riya' xc'astej yan el. Titzu' ri acuchi (achique) xc'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wacami c'a quixbiyin, y je'ibij chare ri Pedro y chique ri nic'aj chic rudiscípulos ri Jesús. Je'ibij c'a chique chi ri Jesús xtinabeyej el chiwech, y nic'ul iwi' chila' pa Galilea. Y chiri' xtitz'et wi, can achi'el wi ri rubin ca chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y ri ixoki' xe'anmej c'a el ri chiri' pa jul, y can yebarbot (yebaybot) c'a ruma ye ruchapon jun nimalaj xibinri'il. Y can majun c'a achoj chare xquitzijoj wi ca, ruma sibilaj quixibin qui'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tek ri Jesús xc'astej c'a chupan ri nimak'a' chare ri nabey k'ij chare ri semana, nabey c'a xuc'ut ri' chuwech ri María Magdalena; ri ixok ri achoj riq'ui xerelesaj wi ye wuku' itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y ri María Magdalena can yac'ari' xbe y xberubij c'a chique quinojel ri xerachibilaj ri Jesús. Riye' sibilaj yebison y ye'ok'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yac'a tek riye' xquic'axaj c'a chi ri Jesús c'astajnek chic pe y chi ri María Magdalena xutz'et yan ca ruwech, xa ma xquinimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Queri' chuka' ri Jesús xuc'ut ri' chiquiwech ye ca'i' achi'a' ri quichapon c'a bey chi yebe pa jun aldea. Pero ruma chi ri Jesús jun wi chic nitzu'un tek xuc'ut ri' chiquiwech, rumari' ma chanin ta c'a xquetamaj ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri ca'i' achi'a' c'a ri' xbequibij chuka' chique ri nic'aj chic ri xetzekelben c'a ri Jesús, pero chuka' ma xenimex ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","C'ac'ari' ri Jesús xuc'ut ri' chiquiwech ri julajuj ru'apóstoles tek quichapon wa'in, y Riya' xubij c'a chique: ¿Achique c'a ruma tek xa can ma xicukuba' ta ic'u'x y xa xicowirisaj ri iwánima? xcha' chique. Queri' ri xubij chique ruma riye' xa can ma xequinimaj ta ri xetz'eto ca ri Jesús chi c'astajnek chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xubij c'a chuka' chique: Can quixbiyin c'a chuwech re ruwach'ulef y titzijoj ri lok'olaj ch'abel ri niya'o colotajic chique quinojel ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri winek c'a ri niniman ri lok'olaj ch'abel ri niya'o colotajic y nuben chuka' bautizar ri', xticolotej c'a. Yac'a ri winek ri xa ma niniman ta, can xtitak c'a pa ruc'ayewal. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y achique c'a ri xqueniman wuche (wixin), q'uiy c'a xquequibanala' riche (rixin) chi nik'alajin chi can yinc'o wi quiq'ui. Pa nubi' c'a riyin xquequelesala' itzel tak espíritu y xquech'o anej pa tak ch'abel ri xa ma ye quich'abel ta. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Riye' chuka' astape' xquequichop itzel tak cumatz y xquequitijla' camisanel tak ak'om, majun xtiquic'ulwachij. Xtiquiyala' chuka' quik'a' pa quiwi' yawa'i' y xquec'achoj. Q'uiy c'a ri xquequibanala' riye', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Tek ri Ajaf Jesús ch'onak chic c'a ca chique ri rudiscípulos, xbe; y ri chila' chicaj xc'ul wi ruma ri Dios, y xtz'uye' apo pa rajquik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y ri discípulos xe'el c'a chi nej chi nakaj chutzijoxic ri ruch'abel ri Dios. Y ri Ajaf can c'o wi c'a quiq'ui riche (rixin) chi yeruto' y chuka' can xuben chique chi q'uiy milagros ri xecowin xquibanala', riche (rixin) chi nik'alajin chi can ya wi ri kitzij ri niquitzijoj. Amén.");
INSERT INTO cakWNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ye q'uiy yan c'a quitijon chic quik'ij riche (rixin) chi niquitz'ibaj pa rucholajen ri can kitzij chi xebanatej chkacojol. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y ri rutz'ibaxic ri xquiben chare can achi'el wi ri xtzijox chake cuma ri xetz'eto ri c'a pa rutiquiribel pe. Y ri xetz'eto ri xbanatej xe'oc chuka' tzijoy ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y riyin chuka' nwajo' ntz'ibaj ri xbanatej. Can xintij c'a nuk'ij riche (rixin) chi xinwetamaj chrij ri rutiquiribel. Y yac'ari' ri nwajo' ntzijoj chawe. Nwajo' chi pa rucholajen ntz'ibaj chawe riyit nimalaj Teófilo, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","riche (rixin) chi queri' nawetamaj jabel chrij ri kitzij ri ye bin y ye c'utun pe chawech. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chiri' pa Judea xc'oje' c'a jun sacerdote ri xubini'aj Zacarías, y riya' xc'oje' c'a quiq'ui ri jumoc sacerdotes ri quibini'an chi ye riche (rixin) ri Abías. Y ri tiempo ri' ya c'a ri achi Herodes ri rey chiri' pa Judea. Ri rixjayil c'a ri Zacarías, Elisabet rubi'. Ri Elisabet ri' jun chique ri ye riy rumam ca ri nimalaj sacerdote ri xubini'aj Aarón. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri juc'ulaj winek ri' choj ri quic'aslen chuwech ri Ajaf Dios, y niquinimaj c'a ri rutzij. Can niquiben wi ri nubij. Y majun winek nicowin nibin ta jun tzij chiquij, ruma chi can ye choj wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ri juc'ulaj winek ri' majun c'a calc'ual, ruma ri Elisabet ma alanel ta. Y chi ye ca'i' ye rijita'k chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Y tek xapon c'a ri semana chi yesamej pa rachoch ri Dios ri jumoc sacerdotes ri can cachibil qui' riq'ui ri Zacarías, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ri k'ij c'a ri' ya ri Zacarías ri xkajben chi ntoc apo pa rachoch ri Dios riche (rixin) chi nuporoj ri pon, can achi'el ri kas niquiben wi ri rech sacerdotes chi jalajoj ruwech samaj yequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y tek ntajin c'a chuporoxic ri pon, quinojel c'a ri winek ri quimolon qui' ri chuwajay el, yetajin niquiben orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Yac'a tek c'o ri Zacarías chiri' ntajin nuporoj ri pon, yac'ari' tek xuc'ut ri' jun ángel riche (rixin) ri Ajaf Dios chuwech. Y ri ángel ri' xpa'e' chunakajal ri altar ri niporox wi ri pon. Pa rajquik'a' ri altar xpa'e' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Tek ri Zacarías xutz'et ri ángel ri', xsach ruc'u'x y xpe xibinri'il chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ri ángel xubij chare ri Zacarías: Ma taxibij ta awi'. Ri Dios xrac'axaj ri a'oración. Ri Elisabet ri awixjayil xtic'oje' c'a jun ral, y ri ac'al ri', Juan ri rubi' ri xtaya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ri ac'al c'a ri' xtuc'om pe sibilaj quicoten chawe riyit, y xtuc'om pe chuka' quicoten chique sibilaj ye q'uiy winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ruma ri awalc'ual xtoc jun samajel ri sibilaj nim ruk'ij xtitz'etetej ruma ri Dios. Ma xtukum ta ruya'al uva, ni nic'aj chic quiwech ya' ri yek'abarisan, ruma chi can pa ralaxic pe nojnek ri ránima riq'ui ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y xtuben c'a chique ye q'uiy awech israelitas chi niquinimaj ri Ajaf Dios y nijalatej ri quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Yac'a ri Juan ri awalc'ual ri xtinabeyej chuwech ri Ajaf. Y riya' can xtic'oje' c'a ri Lok'olaj Espíritu y ri uchuk'a' riq'ui, can achi'el ri xc'oje' riq'ui ri Elías. Chuka' ri Juan xtuben c'a chique ri te'ej tata'aj chi yecajo' ri calc'ual, y xtuben chuka' chique ri winek ri ma yeniman ta tzij, chi xtiquic'uaj jun chojlaj c'aslen, achi'el ri quic'uan ri winek choj quic'aslen. Queri' ruchojmirisaxic xtuben apo chique ri winek, riche (rixin) chi queri' ri winek ri' xa can xu (xe wi) chic ri Ajaf coyoben apo, xcha' ri ángel chare ri Zacarías. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y ri Zacarías xuc'utuj chare ri ángel: ¿Achique c'a rubanic tek xtinwetamaj riyin chi can kitzij ri nabij chuwe? Ruma chi riyin y ri wixjayil xa yoj rijita'k chic, y ma yec'oje' ta chic kalc'ual, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y yac'ari' tek ri ángel xubij chare: Yin c'a riyin ri yin rutako'n ri Dios ri Gabriel nubi' ri yinc'o chuwech ri Dios. Y xirutek pe wacami riche (rixin) chi nonbij ca chawe ri nuc'om pe quicoten, ruma chi xtic'oje' awalc'ual. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y ruma c'a chi ma xanimaj ta ri xinbij chawe, xcamemur c'a ca, man c'a xcach'o ta chic, c'a ya tek xtalex na ri awalc'ual, c'ac'ari' xcach'o chic jun bey. Ronojel c'a ri' can xtibanatej na wi, pero c'a ya tek xtapon na ri k'ij, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Y tek ri Zacarías nitzijon c'a ri ángel riq'ui, ri winek ri ye oyobeyon riche (rixin) ri chuwajay el, niquibila' c'a: ¿Achique c'a ruma tek xa ma ntel ta pe chupan ri lok'olaj rachoch ri Dios? ");
INSERT INTO cakWNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y tek ri Zacarías xbe'el pe, ma nicowin ta chic nich'o chique, ruma chi memurnek chic. Rumac'ari', ri ye oyobeyon riche (rixin), xquinabej chi c'o xuc'ut ri' chuwech ri chiri' chupan ri lok'olaj rachoch ri Dios. Ri Zacarías xaxu (xaxe wi) riq'ui ruk'a' nich'o wi chique, ruma xa xmemur c'a ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y tek riya' ye rutz'akatisan chic ca ri k'ij riche (rixin) ri samaj chiri' pa rachoch ri Dios, xbe chrachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Tek xa ma jane q'uiy ta k'ij tic'o ca ri xc'ulwachitej chiri' pa rachoch ri Dios, ri Elisabet ri rixjayil ri Zacarías xunabej chi riya' xa yawa' chic, y rumari' ma xel ta pa bey wu'o' ic'. Ri Elisabet nubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Wacami ri Wajaf Dios nuya' c'a re ac'al re' chuwe, riche (rixin) chi riyin ma xquiq'uix ta chic chiquiwech ri winek ri niquikasaj nuk'ij ruma chi majun wal. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Yac'a tek ri Elisabet ruchapon chic waki' ic' yawa' pe, yac'ari' tek ri Dios xutek chic ri ángel Gabriel pa jun tinamit ri Nazaret rubi', jun tinamit ri c'o pa rucuenta ri Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ri ángel Gabriel xtak riq'ui jun k'opoj, ri María rubi'. Ri k'opoj c'a ri', c'utun chic riche (rixin) chi nic'ule' riq'ui jun c'ajol ri José rubi'. Y ri José ri' jun chique ri ye riy rumam ca ri rey David. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel can xapon na wi riq'ui ri k'opoj, y xubij chare: ¡Tiquicot c'a ri awánima, ruma sibilaj xaka chuwech ri Dios! Ri Ajaf can c'o awuq'ui. Y chique quinojel ri ixoki', yit c'a riyit ri sibilaj bendición xac'ul. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y tek ri María xutz'et ri ángel y xrac'axaj ri xbix chare, xsach ruc'u'x y xuch'ob c'a ka pa ránima chi achique ruma tek quere' rutzil ruwech niya'ox (nya') ruma ri ángel. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Yac'ari' tek ri ángel chanin xubij chare ri María: Ma taxibij ta awi'. Riyit awilon rutzil ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wacami c'a, nbij ca chawe chi xtipe alanic chawij, y tek xtalex c'a ri ac'al ri', ti c'ajol (ala') y Jesús ri rubi' ri xtaya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Riya' sibilaj nim c'a ruk'ij xtic'oje', y xtubini'aj chuka' Ruc'ajol ri nimalaj Dios. Ri Jesús jun chique ri ye riy rumam ca ri rey David, y ri Ajaf Dios can ya c'a Riya' ri xtutz'uyuba' pa ruch'acat ri rey David ri xc'oje' ojer ca, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","riche (rixin) chi queri' ri Jesús nuk'et tzij pan iwi' riyix, ri yix riy rumam ca ri Jacob. Y ri ruk'atbel tzij can riche (rixin) xtibe k'ij xtibe sek, majun bey chic xtitane' ta, xcha' ri ángel chare ri María. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y tek ri María rac'axan chic ka ronojel ri', xuc'utuj chare ri ángel: ¿Achique c'a modo ri' tek xtic'oje' wal? Ruma riyin xa ma jane yinc'o ta riq'ui ri achi ri xtoc wachijil. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y ri ángel xubij chare ri María: Ya ri Lok'olaj Espíritu riq'ui ri ruchuk'a' ri nimalaj Dios, ri xtika pe pan awi'. Rumac'ari', ri lok'olaj ac'al ri xtalex awuq'ui, can xtubini'aj na wi Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tawetamaj c'a chuka' ca, chi ri Elisabet ri awach'alal xtralaj jun ac'al, astape' ma alanel ta y chuka' can ri'j chic. Y re wacami c'o chic waki' ric'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ruma chi ri Dios can ronojel nicowin nuben. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Can yac'ari' tek ri María xubij: Yac'are' yinc'o, yin jun rusamajel ri Ajaf. Can tibanatej c'a achi'el ri xabij chuwe, xcha' ri María chare ri ángel. Y ri ángel xel el chiri' riq'ui ri María, y xbe. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ye k'ij c'a ri' tek ri María can chanin xbe pa jun tinamit ri c'o pa ruwi' jun juyu' ri c'o pa rucuenta ri Judea. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y tek xapon chiri' pa tinamit, riya' xbe pa cachoch ri Zacarías y ri Elisabet, y xuya' c'a rutzil ruwech ri Elisabet. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Tek ri Elisabet xrac'axaj ri rutzil ruwech ri xya'ox (xya') ruma ri María, can sibilaj xropin ri ac'al ri royoben xuna' riya'. Y ri Elisabet xnoj ránima riq'ui ri Lok'olaj Espíritu, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","y can riq'ui c'a ruchuk'a' xch'o, y xubij: Chkacojol riyoj ixoki', yit c'a riyit ri sibilaj bendición ac'ulun, y queri' chuka' ri bendición c'o pa ruwi' ri ac'al ri xtalex awuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ma nik'ax ta c'a chinuwech, ¿ruma yin achique ta c'a riyin, riche (rixin) chi no'aya' ca rutzil nuwech riyit ri yit rute' ri Wajaf? ");
INSERT INTO cakWNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Y can xu (xe) wi xinwac'axaj ri ach'abel tek xaya' rutzil nuwech, ri ac'al ri woyoben, can xropin ruma quicoten, xinna' riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Jabel c'a ruwa'ak'ij ruma chi xanimaj ri xubij ri Ajaf chawe, ruma ri ac'al ri xbix chawe chi xtalex awuq'ui, can xtalex na wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y yac'ari' tek ri María xubij: Riyin riq'ui ronojel wánima nya' ruk'ij ri Ajaf. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri wánima niquicot ruma ri Dios ri Nucolonel. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ruma chi ri Dios xirucha' riyin ri rusamajel ri xa majun oc nuk'ij. Y janipe' ri xtibe apo, ri winek xtiquibij chi jabel ruwanuk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ruma q'uiy nima'k tak utzil ri rubanon pe chuwe Riya', ri can nicowin wi nuben ronojel. Y ri rubi' Riya' can lok'olaj wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Can nujoyowaj c'a chuka' quiwech quinojel ri winek, ri chi sol chi sol yek'ax el chuwech re ruwach'ulef, ri can niquixibij wi qui' yemacun chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Y riq'ui c'a ri ruchuk'a', can q'uiy c'a rubanalon. Riya' rukasan quik'ij ri yech'obo pa tak cánima chi can nima'k quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ye rukasan ri nima'k aj k'atbel tak tzij, y ye runimirisan ri xa majun quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri yewayjan, can xuya' c'a ronojel ri nic'atzin chique; yec'a ri beyoma' xa choj queri' xetak el. Can majun xuya' el chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Riya' yoj ruto'on c'a riyoj israelitas ri can yoj rucha'on wi riche (rixin) chi nikaben ri rusamaj. Ma yoj rumestan ta ca y rujoyowan kawech. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Can rujoyowan wi kawech, achi'el ri rubin ca chique ri kati't kamama' ri xec'oje' ojer ca, ri can rubin ca chare ri Abraham y chake riyoj ri yoj riy rumam ca riya'. Ri Dios can majun bey c'a xtumestaj ta ri rubin ca. Quec'ari' xubij ri María. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María xa juba' ma achi'el oxi' ic' xc'oje' ka pa rachoch ri Elisabet, y c'ac'ari' xtzolin chrachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tek xapon ri k'ij riche (rixin) chi nalex ri ti ac'al riq'ui ri Elisabet, xralaj jun ac'al ti c'ajol (ala'). ");
INSERT INTO cakWNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y ri winek c'a ri ye ruvecinos ri Elisabet y ri ye rach'alal tek xquic'axaj c'a chi xralaj jun ac'al ruma ri nimalaj rutzil ri Dios, ri winek c'a ri' xe'apon riq'ui chuya'ic rutzil ruwech, y sibilaj c'a chuka' xequicot riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y riye' xe'apon chic c'a riq'ui ri Elisabet, tek xapon c'a ri wakxaki' ruk'ij ri ac'al, tek can ya chuka' k'ij ri' niban ri circuncisión chare ri ac'al. Y can ya chuka' k'ij ri' tek niquicanoj ca rubi' ri ac'al. Y ri yec'o quiq'ui ri rute' rutata' ri ac'al xcajo' c'a xquiya' ta ri rubi' ri rutata' chare ri ac'al, y queri' ri ac'al xubini'aj ta Zacarías. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Yac'a ri rute' ri ac'al chanin xubij: Re ac'al re' ma xtubini'aj ta achi'el rubi' ri rutata', ruma re ac'al re' xtubini'aj Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ri yec'o quiq'ui ri Elisabet xquibij chare: ¿Achique ruma tek nawajo' chi re ac'al nubini'aj Juan? Ruma majun chique ri ye awach'alal ri que ta ri' rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Yac'ari' tek xa riq'ui retal xech'o apo chare ri Zacarías, ri rutata' ri ac'al, riche (rixin) chi niquic'utuj chare achique bi'aj nrajo' nuya' chare ri ac'al. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri rutata' ri ac'al xuc'utuj jun tz'alan ri ye'ucusex riche (rixin) tz'ibanen y chuwech c'a ri tz'alan ri' xutz'ibaj: Ri ac'al xtubini'aj Juan. Y quinojel c'a ri quimolon apo qui' quiq'ui ri rute' rutata' ri ac'al, xquimey, ruma can ya ri bi'aj ri xubij ri te'ej, can ya chuka' ri' xutz'ibaj ri Zacarías chuwech ri tz'alan. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Can yac'ari' tek ri Zacarías xch'o chic jun bey. Y riya' can xu (xe) wi xch'o, can yac'ari' xuya' ruk'ij ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y ri ye quivecinos xpe c'a xibinri'il chique, ruma ri xbanatej chiri'. Y ri xbanatej, xel c'a rutzijol chiri' pa tak juyu' ri c'o pa rucuenta ri Judea. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y quinojel c'a winek ri ye'ac'axan ri xbanatej quiq'ui ri Zacarías y ri Elisabet, niquiyec c'a ka pa tak cánima ri nitzijox chique, y niquibij: ¿Achique c'a rusamaj ruc'amom pe re ac'al re'? yecha'. Ruma nik'alajin chi can c'o wi ri Ajaf Dios riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Rumac'ari' ri Zacarías, ri rutata' ri ac'al, tek nojnek ránima riq'ui ri Lok'olaj Espíritu, riya' xuk'alajsaj c'a y xubij: ");
INSERT INTO cakWNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Sibilaj ta xtinimirisex rubi' ri Ajaf Dios kiche (kixin) riyoj ri yoj aj Israel, ruma yojrunataj pe riyoj ri yoj rutinamit, y yojrucol. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ri Dios nuya' jun kanimalaj Colonel. Y ri Kacolonel ri', jun chique ri ye riy rumam ca ri David ri jun ka-rey y rusamajel ri Dios ri xc'oje' ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri Dios xbin chique ri lok'olaj tak profetas ri xek'alajsan ri ruch'abel Riya' ojer ca, chi xquibij chi xtuya' jun Kacolonel. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Can rubin wi pe chi xkojrucol chiquiwech ri ye'etzelan kiche (kixin), y xkojrucol pa quik'a' ri ma yojcajo' ta, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y chuka' rubin ca chi nujoyowaj quiwech ri kati't kamama' ri xec'oje' ojer ca, y chuka' ma numestaj ta ri lok'olaj trato ri xuben riq'ui ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Can xubij wi chare ri ojer kamama' Abraham ri c'o chi nuben chake, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chi can yojrucol pa quik'a' ri ye'etzelan kiche (kixin), riche (rixin) chi queri' ma nikaxibij ta ki' chi nikaben ri rusamaj, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y riq'ui jun chojmilaj y ch'ajch'ojlaj c'aslen chuwech Riya', nikaben ri rusamaj ronojel k'ij ri yojc'ase' el chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y riyit ti nuc'ajol, xcha' ri Zacarías, xtibix chawe chi can yit jun profeta ri k'alajsey ruch'abel ri nimalaj Dios. Ruma yit c'a riyit ri xcanabeyej chuwech ri Ajaf riche (rixin) chi xtachojmirisaj apo ri rubey, ");
INSERT INTO cakWNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y yit c'a riyit ri xcak'alajsan chi ri Dios nucuy quimac ri can ye rutinamit, riche (rixin) chi yecolotej. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y ri', xaxu (xaxe) wi ruma chi ri ka-Dios nujoyowaj kawech riq'ui ronojel ajowabel. Rumari' tek c'a chila' chicaj nutek wi pe Jun ri nosakirisan kiche (kixin), ri can achi'el tek ntel pe ri k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ri Jun c'a ri nosakirisan, xquerusakirisaj ri yec'o pa k'eku'm y ri yec'o pa rumujal ri camic, y xkojruc'uaj c'a chupan ri bey riche (rixin) uxlanibel c'u'x. Quecáre' ri chábel ri xerubij ri Zacarías. ");
INSERT INTO cakWNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y quec'ari', ri ac'al ri xalex quiq'ui ri Zacarías y ri Elisabet, ruchapon c'a q'uiyen y chuka' queri' riq'ui ri ruc'aslen chuwech ri Dios. Y ya c'a ri pa tak desierto xc'oje' wi, y xuk'alajsaj ri' c'a ya tek xapon ri k'ij riche (rixin) chi xutzijoj ri ruch'abel ri Dios chiquiwech ri rech aj Israel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Y xbanatej c'a chi pa rutiempo ri Augusto César tek ya riya' ri aj k'atbel tzij, riya' xutek c'a rubixic chique quinojel ri winek chi tiquitz'ibaj quibi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Yari' ri nabey mul niban queri'. Y tek xban ri nabey tz'iban bi'aj ri', yari' tek c'a nik'ato na tzij ri jun achi ri Cirenio rubi', chila' pa ruwach'ulef Siria. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y ri winek pan Israel c'o c'a chi nbequitz'ibaj quibi' pa tak quitinamit. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y chiri' pa rucuenta ri Galilea c'o jun tinamit ri Nazaret rubi'. Y ri chiri' pa Nazaret c'o c'a jun achi ri José rubi'. Y ri José c'a ri', c'o c'a chi nibe chutz'ibaxic ri rubi' c'a pa Belén, ri jun tinamit ri c'a pa rucuenta ri Judea c'o wi, ruma ye aj chiri' ri ye ojer tak rati't rumama'. Chiri' c'a pa Belén xalex wi ri rey David, y ri José can jun chique ri ye riy rumam ca ri rey David. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Y ri José rachibilan ri María ri ya'on chic chare riche (rixin) chi ntoc rixjayil, xebe c'a pa Belén chutz'ibaxic quibi'. Y ri María xa nakaj chic c'a ri alanic chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y chiri' c'a pa Belén yec'o wi tek ri María xtz'aket ri ruk'ij riche (rixin) chi nralaj ri ac'al. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Riya' xc'oje' c'a ral ti c'ajol (ala'). Ri María jabel xubor ri ac'al pa tziek, y xuliba' pa jun quiwaybal chicop. Pa jun quica'aj chicop xalex wi ri nabey ti ral ri María, ruma chi nojnek chic ri mesón. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Y yec'o c'a aj yuk'a' yequiwaraj quicarne'l pa jun juyu', ri nakaj nicanaj wi ca chare ri tinamit Belén. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Can yac'ari' tek xuc'ut ri' jun ángel chiquiwech ri aj yuk'a' ri', jun ángel ri petenak chila' chicaj riq'ui ri Ajaf. Y riye' sibilaj xquixibij qui' ruma ri ángel, y ruma chuka' ri sakil riche (rixin) ri Ajaf ri xsakirisan quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Yac'a ri ángel xubij chique: Ma tixibij ta iwi'. Tiwac'axaj na pe' re nwajo' nbij chiwe, can riche (rixin) sibilaj quicoten. Y ma xu (xe) ta wi iwuche (iwixin) riyix re quicoten re', xa can quiche (quixin) chuka' quinojel winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tiwac'axaj c'a re xtinbij chiwe: Chila' pa Belén, ri rutinamit ca ri rey David, wacami xalex c'a ri Colonel, ri Cristo ri Ajaf. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal riche (rixin) chi wi ya ti ac'al ri' ri niwil, xtitz'et c'a chi boron jabel pa tziek y cotz'oban pa jun quiwaybal chicop, xcha' ri ángel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Can yac'a chuka' ri' tek xebec'ulun pe nic'aj chic ángeles ri ye petenak chila' chicaj y can sibilaj ye q'uiy. Y riye' niquiya' c'a ruk'ij ri Dios, y niquibij: ");
INSERT INTO cakWNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Wacami, ri chila' chicaj sibilaj niya'ox (nya') ruk'ij ruc'ojlen ri Dios! ¡Y wawe' chuwech re ruwach'ulef xoka yan ri uxlanibel c'u'x. Xoka yan chiquicojol ri winek, ruma ri rutzil ri Dios! ");
INSERT INTO cakWNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Can xu (xe) wi xquibij ca queri' ri ángeles, can yac'ari' tek xebe chila' chicaj. Y can xu (xe wi) c'a xebe ri ángeles ri', ri aj yuk'a' can yac'ari' xquibila' ka chiquiwech: Jo' chanin pa Belén. Jo' chutz'etic ri ac'al ri xalex chila'. Ruma ri Ajaf can xutek pe rubixic chake. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y riche (rixin) c'a chi nbequitz'eta' ri ac'al, ri aj yuk'a' ri' can chanin c'a xebe c'a pa tinamit. Can xebequila' wi c'a ri María, ri José, y ri ac'al can cotz'oban c'a pa jun quiwaybal chicop. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ri aj yuk'a' ri', can xu (xe) wi xquitz'et ri ac'al, xquichop c'a rutzijoxic ri xbix chique ruma ri ángel, chrij ri ti ac'al ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y quinojel c'a ri winek ri ye'ac'axan quiche (quixin), can xquimey ri utzilaj tak ch'abel ri niquitzijoj ri aj yuk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y ri María can xeruyec c'a pa ránima ronojel ri tzij ri', y yeruch'ob chuka' ronojel ri tzij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ri aj yuk'a' xetzolin c'a. Y riye' niquiyala' c'a ruk'ij ruc'ojlen ri Dios y niquinimirisala' ri rubi'. Riye' quec'ari' niquiben ruma ronojel ri quitz'eton y quic'axan chic. Can xbanatej wi c'a achi'el ri rubin ca ri ángel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Y tek xtz'aket ri wakxaki' k'ij ri talex wi ri ac'al, xban ri circuncisión chare, y can ya chuka' k'ij ri' tek nicanox rubi', y Jesús ri rubi' ri xquiya', ruma ya bi'aj ri' ri xubij ca ri ángel chare ri María tek can c'a ma jane c'o ta alanic chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y tek xtz'aket c'a ri k'ij achi'el nubij ri ley riche (rixin) ri Moisés, chi ri ixoki' ri xe'alan c'o chi niquich'ajch'ojsaj qui', ri María y ri José xquic'uaj c'a ri ac'al Jesús pa rachoch ri Dios pa Jerusalem, riche (rixin) chi xbequic'utu' ca chuwech ri Ajaf Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Queri' xquiben ruma ri ruley ri Ajaf Dios nubij chi ronojel ri nabey ac'al, wi ti c'ajol (ala'), can nijach wi chare ri Dios riche (rixin) chi ntoc rusamajel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ri José y ri María can xquiben wi c'a ri nubij chupan ri ruley ri Ajaf Dios, ri nich'o chrij ri ch'ajch'ojirisanic. Riye' xequiya' c'a ca'i' palomax riche (rixin) chi xecamisex chuwech ri Dios, ruma ri ley can nubij wi c'a: Ca'i' palomax ye nima'k o ca'i' tak cocoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chiri' pa tinamit Jerusalem ri tiempo ri', c'o c'a jun achi ri Simeón rubi'. Ri jun achi c'a ri', can choj ri ruc'aslen y kas ya'ol ruk'ij ri Dios. Ri Simeón, can c'o wi c'a ri Lok'olaj Espíritu riq'ui y royoben chuka' tek xtipe ri Cristo riche (rixin) chi nicolotej riya' y ri rech aj Israel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y ri Lok'olaj Espíritu ruk'alajsan chic c'a chare ri Simeón chi ma nicom ta na, xticom pero c'a ya tek rutz'eton chic na ca ri Cristo, ri xtutek pe ri Ajaf Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupan c'a ri k'ij tek ri te'ej tata'aj xquic'uaj ri ac'al pa rachoch ri Dios riche (rixin) chi niquiben achi'el ri nubij ri ley, can yac'a chuka' k'ij ri' tek xapon ri Simeón pa rachoch ri Dios, ruma queri' xrajo' ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xuch'elej c'a ri ac'al, y riche (rixin) chi xuya' ruk'ij ri Dios, xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, wacami c'a ri yin asamajel xa can utz chic chi yinawelesaj el, can riq'ui c'a uxlanibel c'u'x yibe, ruma can achi'el ri abin chuwe, can queri' xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ri runak' tak nuwech xquitzu' yan c'a ca ri Colonel ri petenak awuq'ui riyit, ");
INSERT INTO cakWNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xaya' pe riyit quiche (quixin) quinojel ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ya Riya' chuka' ri Sakil quiche (quixin) ri winek ri ma ye israelitas ta, ruma ya Riya' xtic'utu ri bey chiquiwech riche (rixin) chi ye'apon awuq'ui. Y riyoj ri yoj atinamit Israel, ruma can chkacojol xalex wi ri Colonel, q'uiy c'a utzil xtikac'ul y xtic'oje' kak'ij kac'ojlen, xcha' ri Simeón. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Y ri José y ri María ri rute' ri Jesús can xquimey tek xquic'axaj ri xubila' ri Simeón chrij ri ac'al. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y yac'ari' tek ri Simeón xeruben bendecir ri José y ri María y c'ac'ari' xubij chare ri María, ri rute' ri ac'al: Tawac'axaj na pe', re ac'al re' nim ri samaj ri ya'on pe chare ruma ri Dios. Y ruma Riya', ye q'uiy chique ri kech aj Israel ri xquecolotej. Y ye q'uiy chuka' ri xquetzak, ruma xtiquetzelaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Can ruma c'a Riya' tek xtibek'alajin pe ri etzelal ri c'o pa tak cánima ri winek. Y ri Simeón xubij chuka' chare ri María: Ruma ri pokon ri xtiban chare ri Jesús, xtipe k'axon awuq'ui riyit. Xtana' c'a chi can achi'el jun espada ri xtusoc ri awánima, xcha' ri Simeón. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiri' c'a pa rachoch ri Dios c'o c'a jun ixok ri Ana rubi'. Riya' jun ixok ri nik'alajsan ri ruch'abel ri Dios. Riya' rumi'al ca jun achi ri Fanuel rubi', y jun chique ri ye riy rumam ca ri Aser, ri jun achi xc'oje' ojer ca. Ri Ana c'a ri' ti ri'j chic. Riya' c'a co'ol tek xc'ule'. Pero xaxu (xaxe wi) wuku' juna' xquic'uaj qui' riq'ui ri rachijil, ruma xa chanin xcom el ri achi chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y ma xc'ule' ta chic. C'o chic c'a ochenta y cuatro rujuna', y can k'ij k'ij nic'oje' pa rachoch ri Dios. Q'uiy c'a mul can ma niwa' ta, riche (rixin) chi nuben orar. Nuya' c'a ruk'ij ri Dios chi pak'ij chi chak'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Tek ri Ana xutz'et ri ti ac'al Jesús, riya' xbe apo riq'ui. Y sibilaj c'a xmatioxin chare ri Dios ruma ri ac'al ri', ruma xunabej chi ya Colonel ri'. Y xuchop c'a rutzijoxic chique ri winek ri ye oyobeyon riche (rixin) ri Colonel ri', ri chiri' pa Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ri José y ri María xquiben c'a ronojel ri nuchilabej ri Ajaf Dios chupan ri ruley, ri c'o chi niquiben tek c'a juba' talex jun ac'al. C'ac'ari' xetzolin pa cachoch chiri' pa Nazaret. Ri tinamit ri' c'a pa rucuenta ri Galilea c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ac'al xuchop c'a ruq'uiyen, y petenak más ruchuk'a'. Y petenak chuka' más runa'oj, y c'o ri rutzil ri Dios pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri María y ri José ri ye rute' rutata' ri Jesús, can ronojel c'a juna' yebe pa tinamit Jerusalem, tek napon ri k'ij riche (rixin) ri nimak'ij pascua. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y xapon chic c'a jun bey ri k'ij riche (rixin) ri nimak'ij ri'. Ri Jesús c'o c'a cablajuj rujuna' tek xebe c'a pa tinamit Jerusalem, can achi'el wi niquiben ri quech aj Israel. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tek k'axnek chic c'a ca ri nimak'ij pascua, ri María y ri José xetzolin chcachoch. Pero riye' ma quetaman ta c'a chi ri ac'al Jesús xa xc'oje' na c'a ca chiri' pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri José y ri María can quicukuban ka quic'u'x chi ri ac'al benak, y queri' xebiyin jun k'ij. Yac'a tek xquichop xquic'utula' chique ri cach'alal y chique ri quetaman quiwech, c'ac'ari' tek xquinabej chi xa ma benak ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Y ruma chi ma xquil ta, ri José y ri María xetzolin ca chucanoxic ri ac'al c'a pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","C'a pa rox k'ij c'a chare ri quisachon wi ca ri ac'al, c'ac'ari' xquil ri ac'al pa rachoch ri Dios chiri' pa Jerusalem, tz'uyul apo quiq'ui ri achi'a' ri q'uiy quetaman chrij ri ley, nrac'axaj ri niquibij y c'o chuka' ri yeruc'utula' apo chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y quinojel c'a ri can xquic'axaj ri nubij ri ac'al can xquimey, ruma chi ri nic'utux pe chare cuma ri aj tz'iba', ri ac'al can jabel wi nicowin nubij apo chique. Riya' can nik'alajin wi chi ronojel jabel nik'ax chuwech y c'o etamabel riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chiri' c'a pa rachoch ri Dios c'o wi ri Jesús tek ri María y ri José xbequila'. Riye' can xquimey c'a. Y yac'ari' tek ri rute' xubij chare ri ral: ¿Achique xaben? ¿Achique ruma tek xac'oje' ca y ma xabij ta chake? Tatzu' la'. La atata' y riyin sibilaj yit kacanon chic. Y can nik'axo chic kánima ruma ma juba' yatkil ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y yac'ari' tek Riya' xubij chique: ¿Achique c'a ruma tek sibilaj yinicanoj? Chinuwech riyin, riyix can jabel wi iwetaman chi ya ri nrajo' ri Nata' Dios, yari' ri c'o chi nben. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yac'a ri ch'abel ri xubij ri ac'al chique ri José y ri María, ma xk'ax ta chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Y c'ac'ari' ri ac'al junan c'a xtzolin quiq'ui riye' c'a chcachoch, ri c'o pa tinamit Nazaret. Ri ac'al can sibilaj c'a nunimaj quitzij. Y ronojel c'a ri xbanatej ri pa Jerusalem riq'ui ri ac'al, ri María xeruyec c'a pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y riq'ui ri benak ri tiempo, ri Jesús ruchapon c'a q'uiyen, y can queri' chuka' petenak más runa'oj. Can sibilaj c'a utz nitz'etetej ruma ri Dios, y sibilaj c'a chuka' utz nitz'etetej cuma ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chupan ri wolajuj juna' tek ruchapon nik'ato pe tzij ri Tiberio César, ya c'a riya' ri c'o pa quiwi' ye caji' chic aj k'atbel tak tzij y ri caji' aj k'atbel tak tzij ri' yec'a achi'a' re': Jun ya ri Poncio Pilato rubi', ri nik'ato tzij pa Judea. Y ri jun chic, Herodes rubi', ri nik'ato tzij pa Galilea. Y ri rox, Felipe c'a rubi', rach'alal ri Herodes, y ri Felipe ri' nik'ato tzij pa Iturea y pa Traconite. Y ri rucaj aj k'atbel tzij, Lisanias rubi', ri nik'ato tzij pan Abilinia. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y can yac'a chuka' tiempo ri' tek ya ri Anás y ri Caifás ye nimalaj tak sacerdotes chiri' pa rachoch ri Dios. Yac'a chuka' tiempo ri' tek ri Dios xch'o riq'ui ri Juan ri ruc'ajol ri Zacarías, pa jun desierto. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y ri Juan ronojel c'a ri ruchi' ri raken ya' Jordán xbe wi. Riya' xubij c'a chique ri winek ri xe'apon riq'ui chi titzolin c'a pe quic'u'x riq'ui ri Dios y tiquibana' bautizar qui', riche (rixin) chi queri' ri Dios nucuy quimac. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y can ya c'a riq'ui ri Juan xbanatej wi ri rutz'iban ca ri profeta Isaías, jun chique ri xek'alajsan ri ruch'abel ri Dios ojer ca. Quec'are' ri rutz'iban ca: C'o c'a jun achi ri xtic'oje' pa desierto. Y riya' xturek c'a ruchi' riche (rixin) chi xtubij chique ri winek ri xque'apon riq'ui: Tichojmirisaj apo rubey ri Ajaf y can choj tibana' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Y riche (rixin) c'a chi nichojmirisex jun bey, can nic'atzin c'a chi yenojsex ri jul. Nic'atzin chuka' yejunumex ri tanatek. Ri xotoxek tak bey, choj niban chique. Y ri cujquek tak bey, li'an c'a chuka' niban chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y quinojel c'a ri winek xtiquitz'et c'a ri xtuben ri Dios riche (rixin) chi yecolotej, nicha' chupan ri wuj ri rutz'iban ca ri Isaías. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y tek ri winek ye'apon riq'ui ri Juan ruma nicajo' chi yeban el bautizar ruma riya', riya' nubij c'a chique: Riyix xa yix achi'el itzel tak cumatz ruma niwajo' yixanmej chuwech ri ruc'ayewal. ¿Achique xbin chiwe chi utz yixanmej chuwech ri ruc'ayewal ri xtutek pe ri Dios re chkawech apo? ");
INSERT INTO cakWNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Riyix nic'atzin c'a chi nic'ut chi can kitzij nitzolin pe ic'u'x riq'ui ri Dios. Y man c'a tich'ob ta ka chi can xu (xe) wi ruma chi yix ralc'ual ca ri Abraham, chi ruma ta ri' xquixcolotej, ma que ta ri'. Ruma xa ta ri Dios nrajo', Riya' can nicowin wi nuben ralc'ual ri Abraham chique re abej re ye'itz'et wawe'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri ruc'ayewal ri nuya' ri Dios xa nipe yan. Riya' can xtuben achi'el nuben jun achi ri c'o chic ri iquej pa ruk'a' riche (rixin) chi xqueruchoy ri che' ri xa ma yewachin ta jabel. Y ronojel c'a ri xqueruchoy el, xqueruq'uek pa k'ak', xcha' ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y can yac'ari' tek ri winek ri ye'ac'axan apo riche (rixin) ri Juan, xquic'utuj chare: ¿Achique c'a ri ruc'amon chi nikaben? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y ri Juan xubij c'a chique ri xec'utun apo: Achique c'a chiwe riyix ri c'o ca'i' rutziak, tuya' jun chare ri majun rutziak. Y xabachique c'a chuka' chiwe riyix ri c'o wey riq'ui, tuya' c'a chuka' ruway ri xa majun ruway, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y yec'o c'a chuka' apo riq'ui ri Juan, ca'i' oxi' achi'a' ri ye c'utuy tak alcawal riche (rixin) chi yeban el bautizar. Y xepe c'a ri achi'a' ri' xquic'utuj chare ri Juan: Tijonel, y riyoj, ¿achique c'a ri ruc'amon chi nikaben? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ri Juan xubij chique: Xaxu (xaxe wi) c'a ri alcawal ri bin chiwe ruma ri aj k'atbel tzij, can xu (xe) wi ri' tic'utuj chique ri winek. Man c'a tic'utuj ta más. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Can yac'a chuka' ri' tek yec'o ca'i' oxi' soldados ri ye aponak riq'ui ri Juan, xquic'utuj apo chare: Y riyoj, ¿achique c'a ri ruc'amon chi nikaben? xecha'. Ri Juan xubij c'a chique: Man c'a que'iwelesala' ta quicosas ri winek, ma ruma ta chi c'o k'atbel tzij pan ik'a'. Ni ma tik'abaj ta tzij chiquij ri winek riche (rixin) chi c'o niwelesaj chique. Xa quixquicot c'a riq'ui ri irajil ri nich'ec, xcha' ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y ri winek ri yec'o c'a apo riq'ui ri Juan, can coyoben c'a chi ri Juan nubij ta chique chi achique c'a ri' riya', ruma riye' niquibila' c'a pa tak cánima chi riq'ui juba' chi ri Juan yari' ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Rumac'ari' ri Juan xubij chique ri winek ri ye aponak riq'ui: Riyin pa ya' yixinben wi bautizar. Pero c'o c'a jun achi ri xtipe re chkawech apo, ri xquixruben bautizar riq'ui ri Lok'olaj Espíritu y riq'ui k'ak'. Ri Jun c'a ri xtipe, can más wi nim ruk'ij y can más wi nim ruchuk'a' que chinuwech riyin. Rumari' riyin ma yin ruc'amon ta (takal ta chuwij) chi nquir ri ruximbel ri ruxajab. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Y ri Jun c'a ri xtipe, can ruchojmirisan chic ri' riche (rixin) chi nuben achi'el nuben jun achi tek nujosk'ij ri rutrigo pan era, ri can c'o chic jun horqueta pa ruk'a' riche (rixin) chi nuq'uek chuwacak'ik' ri trigo ri ch'ayon chic. Ri trigo ri nuchayuj ca ri', yari' ri numol y nuyec. Yac'a ri raken ri trigo ri nuc'uaj el cak'ik', xa nuporoj pa k'ak' ri majun bey nichuptej ta. Can quec'ari' xtuben ri jun achi ri xtipe, xcha' ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy c'a tzij ri achi'el re' ri xerubij ri Juan riche (rixin) chi xerupixabaj ri winek, tek xutzijoj ri lok'olaj ch'abel ri niya'o colotajic. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Chuka' ri Juan xchapon chare ri Herodes, ri jun chique ri ye caji' aj k'atbel tak tzij chupan ri tiempo ri' y xubij chare: Riyit ma utz ta abanon ruma ac'amon ka ri Herodías, rixjayil ri awach'alal Felipe, xcha' chare. Y ma xu (xe) ta wi ri' ri xubij chare, xa can xerunataj chuka' ri nic'aj chic rumac ri ye rubanalon ri Herodes. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y ri Herodes xa xnimatej c'a anej más ri rumac, ruma xutz'apij ri Juan pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y xc'ulwachitej c'a chi tek ntajin yeban bautizar ri winek, xban chuka' bautizar ri Jesús. Y tek ri Jesús ntajin c'a chi oración, yac'ari' tek xjakatej ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y ri Lok'olaj Espíritu can tz'etetel wi ri xka pe pa ruwi' ri Jesús. Can achi'el jun palomax ri xka pe pa ruwi' Riya'. Y yac'ari' tek c'o jun ch'abel ri xpe chila' chicaj y xubij: Yit c'a riyit ri Nuc'ajol y can sibilaj yatinwajo', y can nucukuban wi nuc'u'x awuq'ui, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Chupan ri tiempo ri', ri Jesús c'o achi'el xa juwinek lajuj rujuna'. Can yac'ari' tek xuchop ri rusamaj. Y pa quic'u'x ri winek chi ri Jesús can ruc'ajol wi ri José. Ri José ruc'ajol ca ri Elí. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y ri Elí, ruc'ajol ca ri Matat, y ri Matat ruc'ajol ca ri Leví, y ri Leví ruc'ajol ca ri Melqui, y ri Melqui ruc'ajol ca ri Jana, y ri Jana ruc'ajol ca jun chic achi ri José rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y ri José, ruc'ajol ca ri Matatías, y ri Matatías ruc'ajol ca ri Amós, y ri Amós ruc'ajol ca ri Nahum, y ri Nahum ruc'ajol ca ri Esli, y ri Esli ruc'ajol ca ri Nagai. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y ri Nagai, ruc'ajol ca ri Maat, y ri Maat ruc'ajol ca jun chic achi ri Matatías rubi', y ri Matatías, ruc'ajol ca ri Semei, y ri Semei ruc'ajol ca jun chic achi José rubi', y ri José, ruc'ajol ca ri Judá. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y ri Judá, ruc'ajol ca ri Joana, y ri Joana ruc'ajol ca ri Resa, y ri Resa ruc'ajol ca ri Zorobabel, y ri Zorobabel ruc'ajol ca ri Salatiel, y ri Salatiel ruc'ajol ca ri Neri. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y ri Neri, ruc'ajol ca jun chic achi Melqui rubi', y ri Melqui ruc'ajol ca ri Adi, y ri Adi ruc'ajol ca ri Cosam, y ri Cosam ruc'ajol ca ri Elmodam, y ri Elmodam ruc'ajol ca ri Er. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y ri Er, ruc'ajol ca ri Josué, y ri Josué ruc'ajol ca ri Eliezer, y ri Eliezer ruc'ajol ca ri Jorim, y ri Jorim ruc'ajol ca jun chic achi ri Matat rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y ri Matat, ruc'ajol ca jun achi ri Leví rubi', y ri Leví ruc'ajol ca ri Simeón, y ri Simeón ruc'ajol ca jun chic achi ri Judá rubi', y ri Judá ruc'ajol ca jun chic achi ri José rubi', y ri José ruc'ajol ca ri Jonán, y ri Jonán ruc'ajol ca ri Eliaquim. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y ri Eliaquim, ruc'ajol ca ri Melea, y ri Melea ruc'ajol ca ri Mainán, y ri Mainán ruc'ajol ca ri Matata, y ri Matata ruc'ajol ca ri Natán. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y ri Natán, ruc'ajol ca ri David, y ri David ruc'ajol ca ri Isaí, y ri Isaí ruc'ajol ca ri Obed, y ri Obed ruc'ajol ca ri Booz, y ri Booz ruc'ajol ca ri Salmón, y ri Salmón ruc'ajol ca ri Naasón. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y ri Naasón, ruc'ajol ca ri Aminadab, y ri Aminadab ruc'ajol ca ri Aram, y ri Aram ruc'ajol ca ri Esrom, y ri Esrom ruc'ajol ca ri Fares, y ri Fares ruc'ajol ca jun chic achi ri Judá rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y ri Judá, ruc'ajol ca ri Jacob, y ri Jacob ruc'ajol ca ri Isaac, y ri Isaac ruc'ajol ca ri Abraham, y ri Abraham ruc'ajol ca ri Taré, y ri Taré ruc'ajol ca ri Nacor. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y ri Nacor, ruc'ajol ca ri Serug, y ri Serug ruc'ajol ca ri Ragau, y ri Ragau ruc'ajol ca ri Peleg, y ri Peleg ruc'ajol ca ri Heber, y ri Heber ruc'ajol ca ri Sala. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y ri Sala, ruc'ajol ca ri Cainán, y ri Cainán ruc'ajol ca ri Arfaxad, y ri Arfaxad ruc'ajol ca ri Sem, y ri Sem ruc'ajol ca ri Noé, y ri Noé ruc'ajol ca ri Lamec. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y ri Lamec, ruc'ajol ca ri Matusalén, y ri Matusalén ruc'ajol ca ri Enoc, y ri Enoc ruc'ajol ca ri Jared, y ri Jared ruc'ajol ca ri Mahalaleel, y ri Mahalaleel ruc'ajol ca jun chic achi ri Cainán rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y ri Cainán, ruc'ajol ca ri Enós, y ri Enós ruc'ajol ca jun achi Set rubi', y ri Set ruc'ajol ca ri Adán, y ri Adán ralc'ual ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ri k'ij c'a tek xban bautizar ri Jesús, Riya' nojnek ránima riq'ui ri Lok'olaj Espíritu xtzolin pe ri pa raken ya' Jordán. Y ri Jesús xuc'uex c'a ruma ri Lok'olaj Espíritu, riche (rixin) chi xbe c'a pa jun desierto. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chiri' xc'oje' wi. Ri cawinek k'ij c'a ri xc'oje' chiri', ri itzel winek can nutij ruk'ij chrij riche (rixin) chi nitzak ta pa ruk'a'. Y janipe' tiempo xc'oje' ri Jesús chupan ri lugar ri', ma xwa' ta. Rumari' xpe runumic. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y can yac'ari' tek c'o apo ri itzel winek, y xubij chare ri Jesús: Wi kas kitzij chi yit c'a riyit ri Ruc'ajol ri Dios, tabana' c'a chique re abej re' chi que'oc caxlan wey. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yac'a ri Jesús xubij chare: Tz'ibatal ca chupan ri ruch'abel ri Dios, chi ma xu (xe) ta wi riq'ui caxlan wey nic'ase' wi ri winek, xa can nic'ase' chuka' riq'ui ronojel ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y can yac'ari' tek ri itzel winek xuc'uaj ri Jesús pa ruwi' jun juyu' ri nej jotol chicaj, y xa pa jun ti rato xuc'ut chuwech ri Jesús ronojel ri cajawaren ri nima'k tak tinamit ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y c'ac'ari' ri itzel winek xubij chic chare ri Jesús: Riyin njech pan ak'a' re nima'k tak tinamit re', ri can c'o quic'ojlen, y riyin nya' k'ij chawe riche (rixin) chi riyit nak'et tzij pa quiwi', ruma pa nuk'a' riyin ye jachon wi ca, y riyin yicowin nya' xabachoj chare nwajo' nya' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Y wi riyit yaxuque' yamaje' chinuwech riche (rixin) chi naya' nuk'ij, ronojel c'a re' xque'oc awuche (awixin), xcha' ri itzel winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yac'ari' tek ri Jesús xubij chare: Cabiyin quela' riyit Satanás. Ruma chupan ri ruch'abel ri Dios ri tz'ibatal ca, nubij: Xaxu (xaxe) wi c'a ri Ajaf Dios taya' ruk'ij, y xaxu (xaxe wi) chuka' Riya' ri ruc'amon chi nanimaj ri nubij, xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y can yac'a chuka' ri' tek ri itzel winek xuc'uaj ri Jesús, c'a pa tinamit Jerusalem, y c'a pa ruwi' ri rachoch ri Dios xberuya' wi. Y tek yec'o chic chiri', ri itzel winek xubij chare ri Jesús: Tac'aka' ka awi' wawe', wi kas kitzij chi yit Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ruma chupan ri ruch'abel ri Dios tz'ibatal ca, nubij: Ri Dios can xquerutek pe ri ru'ángeles awuq'ui, riche (rixin) chi yatquichajij. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Xcatquili'ej pa quik'a', riche (rixin) chi queri' ma xtachak'ij (xtatoch') ta awaken chuwech abej. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yac'a ri Jesús xubij chare ri itzel winek: Bitajnek c'a ca chi ma tatojtobej ta ri Awajaf Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y tek ri itzel winek majun chic xril ri nuben ta chare ri Jesús, riche (rixin) chi nutojtobej, xuya' c'a ca y xroyobej chic na juba' tiempo c'ac'ari' xtutojtobej chic jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y ri Jesús xtzolin pa Galilea, y nojnek ránima riq'ui ri ruchuk'a' ri Lok'olaj Espíritu. Y pa quinojel c'a tinamit ri yec'o pe chunakajal ri Galilea, xbe rutzijol ri Jesús ruma ri yerubanala'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y Riya' xabachique tinamit napon wi, nuc'ut c'a ri ruch'abel ri Dios pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. Y quinojel c'a ri winek ri ye'ac'axan ri nubij, niquiyala' c'a ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xbe pa tinamit Nazaret, ri tinamit ri xq'uiy wi Riya'. Y chupan ri uxlanibel k'ij, Riya' xbe c'a chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios, can achi'el wi ri tuben. Y tek c'o chic chiri', Riya' xpa'e' c'a, riche (rixin) chi nusiq'uij ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y xjach c'a pa ruk'a' ri Jesús ri wuj ri rutz'iban ca ri profeta Isaías, jun chique ri xek'alajsan ri ruch'abel ri Dios ojer ca, riche (rixin) chi nusiq'uij chiquiwech ri winek ri quimolon qui' chiri'. Y tek xuric' c'a ri wuj ri', xril ri acuchi (achique) nubij wi: ");
INSERT INTO cakWNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Lok'olaj Espíritu riche (rixin) ri Ajaf Dios, c'o wuq'ui riyin, ruma can xirucha' wi pe riche (rixin) chi ntzijoj chique ri pobres ri lok'olaj ch'abel ri niya'o colotajic. Xirutek pe chuka' riche (rixin) chi yenwak'omaj ri winek ri nik'axo cánima pa ruk'a' ri mac. Xirutek pe ri Dios riche (rixin) chi nbij chique ri winek ri ye ximil pa ruk'a' ri mac, chi c'o modo yecolotej pa ruk'a'. Xitak pe chuka' riche (rixin) chi nben chique ri winek ri ye moyi' chi yetzu'un. Y ri Dios xirutek pe chuka' riche (rixin) chi yencol ri winek ri sibilaj niquitij pokon pa quik'a' nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xirutek pe chuka' riche (rixin) chi nbij chique ri winek chi ya tiempo re' tek ri Ajaf Dios nuben ri utzil. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y ri Jesús xubot c'a ca ri wuj ri xusiq'uij chiquiwech ri winek ri yec'o chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Y yac'ari' tek xuya' ca chare jun ri nisamej chiri', y xbetz'uye' c'a riche (rixin) chi nich'o. Y ri winek quitzuliben quitzuliben c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y Riya' xuchop c'a rubixic chique: Wacami yac'are' nibanatej chiwech riyix ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y quinojel c'a ri winek ri quimolon qui' chiri', sibilaj xka chiquiwech ri Jesús. Y ri utzilaj tak ch'abel ri xerubij ri Jesús chique, can xquimey c'a, ruma chi majun bey ye quic'axalon ta ch'abel achi'el ri xerubij chique. Y ri winek ri' niquibila' c'a chuka' chiquiwech: ¿La xa ma ya ta cami re' ri ruc'ajol ri José? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xubij chique: Riyin can wetaman chi riyix nibij re ch'abel re' chuwij: Ajk'omanel, tawak'omaj ka awi' ayon riyit. Ruma kac'axan chi q'uiy milagros ye'abanala' pa Capernaum. Wacami can que'abanala' c'a chuka' wawe' pan atinamit, yixcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xubij chuka' chique ri quimolon qui' chiri': Majun profeta ri nik'alajsan ri ruch'abel ri Dios ri xtiya'ox (xtya') ta ruk'ij pa rutinamit. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Y riyin nbij chi riyix iwetaman ri xbanatej tek ma xuben ta job oxi' juna' riq'ui nic'aj, pa rutiempo ri profeta Elías ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca. Can kitzij wi chi sibilaj ye q'uiy ri ixoki' ye malcani' yec'o wawe' pan Israel ri tiempo ri', tek xpe nimalaj wayjal chuwech ronojel re karuwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ri Dios ma xutek ta ri Elías chuto'ic jun malca'n ixok wawe' pan Israel. Ri Dios xutek el ri Elías riq'ui jun malca'n ixok c'a pa jun tinamit ri Sarepta rubi'. Y ri tinamit Sarepta ri', xa ma pa rucuenta ta ri Israel c'o wi, xa c'a chunakajal ri tinamit Sidón c'o wi apo. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y can queri' chuka' xc'ulwachitej quiq'ui ri yawa'i' pa rutiempo ri profeta Eliseo, ri xk'alajsan ri ruch'abel ri Dios ojer ca. Pa rutiempo c'a ri Eliseo, ri wawe' pan Israel can yec'o c'a q'uiy yawa'i' riq'ui ri jun yabil ri lepra rubi'. Pero majun ri xc'achojsex ta chique ri c'o ri yabil ri' chiquij, xaxu (xaxe wi) c'a ri Naamán ri xc'achojsex y riya' xa ma israelita ta, xa jun achi ri nipe pa Siria. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y ri winek ri quimolon qui' chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios, tek xquic'axaj ri xubij ri Jesús chique, xyacatej coyowal. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Y xebeyacatej pe, c'ac'ari' xquelesaj el chuchi' ri tinamit. Ri jun tinamit c'a ri' pa ruwi' jun juyu' c'o wi. Rumari' ri winek xquic'uaj c'a el ri Jesús riche (rixin) chi nbequinima' ca chuchi' siwan. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Yac'a ri Jesús achi'el ye majun ri winek chuwech. Choj xel pe chiquicojol ri winek y xbe el. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yac'ari' tek ri Jesús xbe ka pa tinamit Capernaum, jun tinamit ri c'o pa rucuenta ri Galilea. Y Riya' nutzijoj ri ruch'abel ri Dios chique ri winek ri quimolon qui' chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios pa tak uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y quinojel c'a ri winek ri quimolon qui' chiri', can sibilaj c'a xquimey ri ch'abel ri xuc'ut chiquiwech, ruma chi ri ruch'abel Riya' can nuc'ut chi can c'o k'atbel tzij pa ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chiri' chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios, ri k'ij ri' c'o c'a apo jun achi ri c'o jun itzel espíritu riq'ui. Y ri itzel espíritu ri c'o riq'ui ri achi, riq'ui ruchuk'a' xurek ruchi' y xubij: ");
INSERT INTO cakWNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Man kojanek ta. ¿Achique nawajo' chake, riyit Jesús aj Nazaret? ¿Xape c'a riche (rixin) chi naq'uis kak'ij? Riyin wetaman yit achique c'a riyit y rumari' wetaman chi riyit can yit lok'olaj wi y yit petenak riq'ui ri Dios, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yac'a ri Jesús xchapon chare ri itzel espíritu y xubij: Ma cach'o ta chic, y catel el. Y ri itzel espíritu ri' tek xel el riq'ui ri achi xuben ca chare chi xtzak pan ulef, chiri' chiquicojol ri winek ri quimolon qui', pero majun chic achique ta xuben ca chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y quinojel c'a ri winek ri quimolon qui' chiri', xquimey tek xquitz'et ri xuben ri Jesús, y niquibila' c'a chiquiwech: ¿Achique c'a rubanic ri ruchuk'a' ri ruch'abel re achi re'? Ruma ri ruch'abel can nuc'ut c'a chi Riya' can c'o k'atbel tzij pa ruk'a'. Ri itzel tak espíritu can niquinimaj rutzij y ye'el el, yecha' c'a ka chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y chanin c'a xbe rutzijol ri Jesús. Rumari' ri winek ri yec'o pa tak lugar ri yec'o pe chunakajal ri tinamit Capernaum, xquic'axaj chuka' ri yerubanala' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupan c'a ri uxlanibel k'ij ri', ri Jesús xel c'a pe chiri' pa jay ri kas nic'ut wi ri ruch'abel ri Dios y choj c'a xbe pa rachoch ri jun rudiscípulo ri Simón rubi'. Y chupan c'a ri k'ij ri' ri rujite' ri Simón, yawa' riq'ui jun nimalaj c'aten. Y ri yec'o chiri' pa jay xquic'utuj jun utzil chare ri Jesús chi tuc'achojsaj ri yawa'. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y Riya' xluque' ka riq'ui ri yawa' y xubij chi tiq'uis el ri c'aten chrij. Y can xu (xe) wi c'a xubij queri' ri Jesús, can yac'ari' tek xq'uis el ri nimalaj c'aten chrij ri yawa'. Y ri ixok ri', can yac'ari' tek xbeyacatej pe y xuchop yerunimaj yerilij apo ri Jesús y ri ye benak riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Tek xka yan c'a ka ri k'ij chupan ri jun k'ij ri', quinojel c'a ri winek riche (rixin) ri tinamit, ri yec'o yawa'i' quiq'ui, xequic'uala' apo chuwech ri Jesús. Ri yawa'i' ri xequic'uala' apo ri winek ri', jalajoj c'a ruwech yabil ri ntoc chique. Y ri Jesús xuya' c'a ruk'a' pa quiwi' chiquijujunal ri yawa'i' y xeruc'achojsaj c'a el. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ye q'uiy c'a chique ri yawa'i' ri' xa ma relic ta yabil ntoc chique. Xa itzel tak espíritu yec'o quiq'ui. Pero ri Jesús xerelesaj chuka' el. Y ri itzel tak espíritu, tek ye'el c'a el quiq'ui ri yawa'i' ri', can riq'ui c'a quichuk'a' yech'o y niquibij: Yit c'a riyit ri Ruc'ajol ri Dios, yecha'. Y ri Jesús xeruk'il riq'ui ri ruch'abel y ma xuya' ta k'ij chique riche (rixin) chi xech'o chic. Ruma ri itzel tak espíritu ri' can quetaman chi ri Jesús, yari' ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y tek xseker pe pa ruca'n k'ij, ri Jesús xel el pa tinamit y xbe pa jun lugar ri acuchi (achique) majun winek c'o. Pero ri winek xa xebe chucanoxic y xbequila' pe. Ri winek c'a ri' xcajo' xquik'et ka ri Jesús ruma ma nicajo' ta chi nibe el. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Yac'a ri Jesús xubij chique: Riyin rajawaxic chi yibe pa nic'aj chic tinamit, riche (rixin) chi ntzijoj ri lok'olaj ruch'abel ri Dios ri nich'o chrij ri rajawaren ri Dios, ruma chi xa can rumari' tek xitak pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y can queri' xuben pa ronojel tinamit ri yec'o pa rucuenta ri Galilea, Riya' can xutzijoj c'a ri ruch'abel ri Dios ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun k'ij, tek ri Jesús c'o chuchi' ri choy Genesaret, ye q'uiy c'a winek xe'apon riq'ui, ruma chi nicajo' niquic'axaj ri ruch'abel ri Dios. Y ri winek ri' can sibilaj wi ye q'uiy, rumari' niquipitz' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Y Riya' chanin xutz'et apo ca'i' jucu' yec'o ca chuchi' ri ya', y majun c'o ta chiquipan. Ruma ri cajaf ri jucu' ri' ye chapoy tak car, y ri hora ri' xa quichapon yequich'ej ri ya'l chapabel car. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun c'a chique ri jucu' ri' riche (rixin) ri Simón. Y chupan ri rujucu' ri Simón, xoc wi ri Jesús. Y Riya' xubij c'a chare ri Simón chi tunima' apo juba' pa ruwi' ya'. Y c'ac'ari' xtz'uye' ka chiri' pa jucu', y xuchop pe quitijoxic ri winek riq'ui ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Tek ri Jesús xtane' riche (rixin) chi nich'o quiq'ui ri winek ri', Riya' xubij chare ri Simón: Jo' apo pa raxal ya', y que'iya' ka ri iya'l chapabel car pa ya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Yac'ari' tek ri Simón xubij chare ri Jesús: Tijonel, riyoj junak'a' xojc'ase' riche (rixin) chi xekacanoj car, y xa majun xkachop. Pero ruma c'a chi can yit c'a riyit yabin chi nikaya' ka re ya'l chapabel car pa ya', can nikaya' c'a ka, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y tek xquiq'uek ka ri quiya'l chapabel car pa ya', can ye q'uiy c'a car xquiya' pe qui', y rumari' ri ya'l xuchop nik'oxpitej ruma ri calal ri car. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Rumari' ri achi'a' chapoy tak car ri' xquiben apo retal chique ri nic'aj chic cachibil ri yec'o pa jun chic jucu', riche (rixin) chi quepe chiquito'ic. Y ri cachibil can xepe na wi chiquito'ic. Y ri ca'i' jucu' xequinojsaj chi car. Rumari' ri ca'i' jucu' ri' xa juba' ma yebe ka chuxe' ya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y tek ri Simón ri nibix chuka' Pedro chare, xutz'et chi jun milagro ri xbanatej ruma sibilaj q'uiy car xbequiya' pe qui', riya' xbexuque' chuwech ri Jesús, y xubij chare: Ajaf, riyin xa yin jun achi aj mac, ma yin ruc'amon ta (ma takal ta chuwij) chi yac'oje' pe wuq'ui, ruma chi riyit can c'o ak'ij ac'ojlen, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Queri' xubij ri Simón, ruma riya' majun bey rutz'eton ta chi que ta ri' nibanatej. Y can queri' chuka' quinojel ri ye benak riq'ui. Riye' can xquixibij qui' tek xquitz'et chi ye q'uiy car xequichop ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Y chuka' ri Jacobo y ri Juan, ri ye rachibil ri Simón, ri ye ruc'ajol ri jun achi ri Zebedeo rubi', can xquixibij qui' tek xquitz'et ri xbanatej. Rumari' ri Jesús xubij chare ri Simón: Man c'a taxibij ta awi' ruma ri xatz'et. Re rubanon pe, yit jun achi chapoy car, yac'a ri xtibe apo, xtawetamaj chuka' xque'ach'ec pe winek, riche (rixin) chi queri' yinquitzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y ri achi'a' chapoy tak car ri' xequic'om pe ri quijucu' c'a chuchi' ri ya'. Ri achi'a' ri' xquiya' ca ri quisamaj y xquitzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y tek ri Jesús xapon c'a pa jun tinamit, xapon c'a jun achi riq'ui, ri c'o jun itzel yabil chrij, y ri yabil ri' lepra rubi'. Ri achi ri', can xu (xe) wi xutz'et ri Jesús, xbexuque' chuwech y xujupuba' c'a ka ri rupalej c'a pan ulef y xuc'utuj utzil chare ri Jesús, y xubij c'a: Ajaf, wi riyit nawajo' yinac'achojsaj chare re nuyabil, can yic'achoj wi c'a ri', ruma riyin wetaman chi riyit can yacowin wi, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Y ri Jesús can yac'ari' xuchop apo ri achi ri c'o ri itzel yabil chrij y xubij chare: Nwajo' chi yac'achoj. Tiq'uis c'a el re yabil re' chawij, xcha' chare. Y can xu (xe) wi xubij queri' ri Jesús, can yac'ari' xq'uis el ri lepra chrij ri achi. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xuchilabej c'a el chare ri achi ri' chi majun achoj chare tutzijoj wi ri xbanatej riq'ui. Y xubij chuka' el chare: Wacami xa choj jac'utu' awi' chuwech ri sacerdote, y can taya' c'a ri ofrenda ri rajawaxic chi naya', achi'el nubij chupan ri rutz'iban ca ri Moisés, riche (rixin) chi queri' nak'alajsaj c'a awi' chiquiwech chi yit ch'ajch'oj chic, xcha' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri Jesús más c'a xbe rutzijol, y sibilaj ye q'uiy winek niquimol qui' riq'ui. Yec'o c'a winek ri yepe riq'ui riche (rixin) chi niquic'axaj ri ruch'abel ri Dios. Y yec'o c'a nic'aj chic nicajo' chi yec'achojsex el ruma Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y Riya' ya c'a ri pa desierto nibe wi riche (rixin) chi nuben orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y xapon c'a jun k'ij, tek yec'o c'a achi'a' fariseos y yec'o chuka' achi'a' ri q'uiy quetaman chrij ri ley, ri xbequic'ulu' qui' ri acuchi (achique) c'o wi ri Jesús. Yec'o c'a chique riye' ri ye petenak c'a quela' pa tak tinamit ri yec'o pa rucuenta ri Galilea. Yec'o ye petenak pa tinamit Jerusalem y pa nic'aj chic tinamit ri yec'o pa rucuenta ri Judea. Ri achi'a' ri' ri q'uiy quetaman chrij ri ley y ri fariseos c'a ri', ye tz'uyul apo chiquicojol ri winek ri ye'ac'axan ri ruch'abel ri Dios ri nuc'ut ri Jesús chiquiwech. Y ri Jesús can c'o ruchuk'a' ri Ajaf Dios riq'ui, riche (rixin) chi yeruc'achojsaj ri yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y c'o c'a jun achi siquirnek uc'uan apo cuma ca'i' oxi' achi'a' chuwech ri ruwarabel. Y riye' xcajo' c'a xe'oc ta apo pa jay c'a riq'ui ri Jesús, riche (rixin) chi niquiya' ri quiyawa' chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ri achi'a' ri' ma xecowin ta xe'oc apo chupan ri jay, ruma sibilaj ye q'uiy winek ri quimolon qui' chiri'. Rumari' riye' xquich'ob chi xejote' pa ruwi' ri jay, y xquelesaj el juba' ruwi' ri jay. Y chiri' xquikasaj wi ka ri achi siquirnek c'o el chuwech ri ruwarabel. Y c'a chuwech ri Jesús xbeka wi ka, chiri' pa quinic'ajal ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y tek ri Jesús xutz'et chi ri achi'a' ri ye uc'uayon apo ri achi siquirnek chi can quicukuban wi quic'u'x riq'ui Riya', xubij chare ri achi siquirnek: Ri amac xecuyutej yan. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Can xu (xe) wi xquic'axaj ri aj tz'iba' y ri achi'a' fariseos ri ch'abel ri xubij ri Jesús, ri achi'a' ri' can yac'ari' xquichop niquich'ob ka: ¿Achique c'a chi achi re'? ¿Y achique ruma tek nuben chi can ya Riya' ri Dios? ¿Ruma achique ta chic jun ri nicuyu mac? Majun chic jun. Xaxu (xaxe) wi ri Dios ri nicuyu mac, yecha' c'a pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yac'a ri Jesús can jabel retaman ri niquich'ob ka. Rumari' Riya' xubij chique: ¿Achique c'a ruma tek riyix nich'ob queri' pa tak iwánima? ");
INSERT INTO cakWNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Wacami tibij na c'a chuwe: ¿Achique cami ri más c'ayef (cuesta) rubanic nich'ob riyix? ¿La ya cami ri nbij chare ri achi re' chi ri rumac xecuyutej yan, o ya ri nbij chare: Cayacatej y cabiyin el? ");
INSERT INTO cakWNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wacami c'a, riche (rixin) chi riyix niwetamaj chi riyin ri C'ajolaxel ri xinalex chicojol can c'o k'atbel tzij pa nuk'a' riche (rixin) chi ncuy mac, titz'eta' c'a. Y ri Jesús xubij chare ri achi siquirnek: Nbij c'a chawe: Cayacatej, tac'uaj el la awarabel y cabiyin chawachoch, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y ri achi siquirnek, can yac'ari' tek xyacatej anej chiquiwech quinojel ri winek ri quimolon qui' chiri'. Y xuc'ol el ri ruwarabel ri acuchi (achique) cotz'oban wi pe, y xbe. Y riya' nuya' c'a ruk'ij ruc'ojlen ri Dios ri xtzolin el chrachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y quinojel ri winek ri quimolon qui' chiri', xquimey, ruma majun bey quitz'eton ta chi que ta ri' nibanatej. Ri winek c'a ri' sibilaj c'a xquiya' ruk'ij ruc'ojlen ri Dios, y quixibin qui' niquibij: Chupan re jun k'ij re' xekatz'et milagros ri majun bey ye tz'eton ta, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ri Jesús xel c'a el chiri', y xutz'et c'a jun achi ri c'utuy alcawal. Ri achi ri' Leví rubi', y tz'uyul c'a acuchi (achique) yetoj wi ca ri alcawal. Y xpe ri Jesús xubij chare: Quinatzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y yac'ari' tek riya' xbeyacatej pe ri acuchi (achique) tz'uyul wi, xuya' ca ronojel ri c'o chiri', y xutzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y c'o c'a jun k'ij ri Leví xuben c'a jun nimawa'in pa rachoch, jun nimawa'in ri can riche (rixin) wi ri Jesús, pero chuka' xerusiq'uij (xeroyoj) ri ye c'utuy tak alcawal y chuka' nic'aj chic winek. Y quinojel c'a ri' junan ye tz'uyul ri pa mesa riq'ui ri Jesús y ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y yec'o c'a aj tz'iba' y yec'o chuka' achi'a' fariseos ri yec'o apo chiri'. Y ri aj tz'iba' y ri fariseos ri', yexebexot (yexebeloj) c'a chiquij ri ye rudiscípulos ri Jesús. Yequibila' c'a chique: ¿Achique ruma tek riyix yixwa' yixuc'ya' quiq'ui ri ye c'utuy tak alcawal y quiq'ui nic'aj chic winek ri xa ye aj maqui'? xecha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yac'a ri Jesús xubij chique ri achi'a' fariseos y ri aj tz'iba': Jun ajk'omanel ma ye ta ri ye utz ri yerak'omaj. Riya' yerak'omaj ri yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Riyin ma xipe ta chiquicanoxic winek ri choj quic'aslen. Riyin xipe chiquicanoxic ri aj maqui', ri rajawaxic chi nitzolin pe quic'u'x riq'ui ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Y ri achi'a' fariseos y ri aj tz'iba' xquic'utuj chare ri Jesús: ¿Achique ruma tek ri ye rudiscípulos ri Juan can c'o k'ij niquichajij tek can ma yewa' ta, riche (rixin) chi yequibanala' oraciones chare ri Dios? Y can queri' chuka' niquiben ri kadiscípulos riyoj, yac'a ri adiscípulos riyit ma que ta ri' niquiben, xa yewa' ye'uc'ya', xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y ri Jesús xubij c'a chique: ¿Achique nibij riyix? ¿la utz cami chi man ta yewa' ri xesiq'uix (xe'oyox) pa jun c'ulanen tek xa c'a c'o na apo quiq'ui ri achijlon ri xa c'a xc'ule'? Ma utz ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xtapon na ri k'ij tek re achijlon re' xtelesex el chiquicojol, y yac'ari' tek ma xquewa' ta riche (rixin) chi xtiquiben orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ri Jesús xucusaj chuka' re jun c'ambel tzij re' chiquiwech: Majun chuka' winek nibano chi nucusaj ta jun c'ojobel c'ac'ac' riche (rixin) chi nuc'ojoj jun tziek ri xa ri'j chic. Ruma wi c'o jun ri nibano queri', ma utz ta. Ruma can nuretz (nutzer) ka ri tziek c'ac'ac' riche (rixin) chi nrelesaj jun c'ojobel chare, y ri c'ojobel ri' xa ma numej ta ri' riq'ui jun rutziak ri xa ri'j chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y queri' chuka' majun niya'o ta c'ac'ac' ruya'al uva chupan jun tz'um yabel ya' ri xa ri'j chic. Ruma wi queri' niban, y ri tz'um xa ma niyukuk ta chic, xa nirakaro' y niq'uis el ri ruya'al uva chupan. Y chuka' ri tz'um ri' majun chic nic'atzin wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Yac'a jun c'ac'ac' tz'um yabel ya', utz niyaque' ri c'ac'ac' ruya'al uva chupan, ruma chi ri ruya'al uva y ri tz'um niquito' qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y majun ri rukumun chic ruya'al uva ri c'o yan chic k'ij yacon, y c'a ta ri' nrajo' ri c'ac'ac' ruya'al uva. Ma que ta ri'. Ruma xa xtubij: Ri ruya'al uva ri c'o yan chic k'ij yacon yari' ri más utz. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun uxlanibel k'ij, ri Jesús y ri rudiscípulos yek'ax c'a el pa jun ulef ri ticon trigo chuwech. Y ri discípulos c'o c'a ruwi' trigo yequich'up el, yequibil pa quik'a'. Y ya c'a ri trigo niquitij ka. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Yac'ari' tek yec'o c'a achi'a' fariseos ri xquibij chique ri ye rudiscípulos ri Jesús: ¿Achique ruma riyix ye'ibil re trigo pan ik'a' re k'ij re'? Re k'ij re', uxlanibel k'ij y xajan chi niban samaj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yac'a ri Jesús xch'o apo chique, y xubij: ¿La majun bey c'a isiq'uin ta ri tz'ibatal ca chrij ri xquiben ri David y ri ye rachibil ri ojer ca, tek sibilaj xenum? ");
INSERT INTO cakWNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xbe chucanoxic wey chiri' pa rachoch ri Dios, y can ya ri lok'olaj tak caxlan wey ri xbejach pe chare. Riya' xutij ri lok'olaj tak caxlan wey ri', y xuya' chuka' chique ri ye benak riq'ui. Pero ma riq'ui wi ri', ma mac ta ri xquiben, astape' ri caxlan wey ri' xaxu (xaxe) wi ri sacerdotes yetijo, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y ri Jesús xubij chuka' chique ri achi'a' fariseos: Yin c'a riyin ri C'ajolaxel ri xinalex chicojol ri yin Rajaf ri uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic c'a uxlanibel k'ij, ri Jesús y ri rudiscípulos xebe pa jun jay ri kas nic'ut wi ri ruch'abel ri Dios, y xuchop c'a quitijoxic ri quimolon qui' chiri'. Y chiquicojol ri winek ri quimolon qui' chiri', c'o c'a jun achi ri chaki'j ri rajquik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rumac'ari' yec'o chique ri aj tz'iba' y yec'o chuka' achi'a' fariseos ri quitzuliben apo ri Jesús, k'alaj ri' wi nuc'achojsaj ri achi, riche (rixin) chi queri' niquitzujuj (niquisujuj) chi ri Jesús xsamej chupan ri jun uxlanibel k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yac'a ri Jesús jabel retaman ri yetajin chuch'obic ri aj tz'iba' y ri achi'a' fariseos. Y ri Jesús xubij chare ri achi ri chaki'j ri ruk'a': Cac'oje' pe pa nic'aj. Y ri achi can yac'ari' xyacatej pe ri acuchi (achique) tz'uyul wi, y xbepa'e' acuchi (achique) ri xbix wi chare ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpe c'a ri Jesús xubij chique ri winek ri yec'o chiri': Wacami nwajo' c'a nc'utuj chiwe: ¿La más cami ruc'amon chi niban utzil pa jun uxlanibel k'ij o xa ya ri etzelal? ¿Ri nicol jun winek chuwech ri camic o ri nicamisex? ¿Achique nich'ob riyix? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y ri Jesús xerutzu' c'a quinojel ri quimolon qui' chiri'. Xch'o chare ri achi ri chaki'j ruk'a', y xubij: Tayuku' la ak'a'. Y ri achi can xu (xe) wi xuyuk ri ruk'a' achi'el ri xbix chare ruma ri Jesús, can yac'ari' xchojmir ca ri ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Yac'a ri aj tz'iba' y ri achi'a' fariseos ri yec'o apo chiri', xyacatej coyowal y niquic'utula' chuka' chiquiwech achique niquiben chare ri Jesús riche (rixin) chi niquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y c'o c'a jun k'ij, tek ri Jesús xbe c'a pa ruwi' ri juyu' riche (rixin) chi xberubana' orar. Y junak'a' c'a xc'ase' riche (rixin) chi xch'o riq'ui ri Dios pan oración. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y chupan c'a ri nimak'a' chare ri ruca'n k'ij, Riya' xerusiq'uij (xeroyoj) ri achi'a' ri can yetzekelben wi riche (rixin). Chiquicojol c'a ri achi'a' ri', xerucha' ye cablajuj, y xubij apóstoles chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri ye cablajuj ri xerucha' ri Jesús, ya ri Simón ri xubij chuka' Pedro chare, ri Andrés ri rach'alal ri Simón, ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cakWNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri ruc'ajol ri jun achi ri Alfeo rubi', ri Simón ri c'o quiq'ui ri jumoc achi'a' ri celadores nibix chique, ");
INSERT INTO cakWNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri rach'alal ri Jacobo, y ri Judas Iscariote ri xc'ayin el riche (rixin) ri Jesús pa quik'a' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y yac'ari' tek ri Jesús y ri ye ru'apóstoles xexule' pe ri pa ruwi' ri juyu', y xe'oc'oje' ka quiq'ui ri nic'aj chic discípulos pa jun li'on. Y chiri' ye q'uiy chuka' winek quimolon qui'. Yec'o winek ye petenak pa tinamit Jerusalem y pa nic'aj chic tinamit ri yec'o pa rucuenta ri Judea, y yec'o chuka' ye petenak c'a quela' chuchi' mar, ri c'a quela' pa tinamit Tiro y Sidón. Yec'o c'a chique ri winek ri' ye petenak riche (rixin) chi niquic'axaj ri ruch'abel ri Dios ri nutzijoj ri Jesús, y yec'o c'a ye petenak ruma nicajo' chi yec'achojsex el chare ri quiyabil ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y yec'o c'a chuka' winek ri yec'o pa pokonal pa quik'a' ri itzel tak espíritu ri yec'o quiq'ui. Xe'elesex chuka' el ri itzel tak espíritu ri' ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y quinojel ri winek ye yawa'i' nicajo' c'a niquichop apo ri rutziak ri Jesús, ruma Riya' c'o uchuk'a' riq'ui riche (rixin) chi yeruc'achojsaj quinojel. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y can yac'ari' tek ri Jesús xerutzu' ri ye rudiscípulos y xubij chique: Jabel ruwa'ik'ij riyix ri yix pobres, ruma iwuche (iwixin) c'a riyix ri' ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Jabel ruwa'ik'ij riyix ri yixnum wacami, ruma ri Dios xtuben c'a chiwe chi xquixnoj na chi utz. Jabel ruwa'ik'ij riyix ri yixok', ruma ri Dios xtuben chiwe chi ma xquixok' ta chic y xa xquixbetze'en. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Jabel ruwa'ik'ij chuka' riyix tek yixetzelex cuma ri winek, y yixquelesaj pe chiquicojol, yixyok', chuka' itzel yixtz'et ruma yin iniman riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y tek xtic'ulwachij ronojel ri', xa quixquicot c'a, y can tic'oje' nimalaj quicoten iwuq'ui, ruma chi nim rajel ruq'uexel ri xtic'ul chila' chicaj. Ruma xa can queri' chuka' ri tijoj pokonal ri xquik'axaj ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Riye' xquik'axala' tijoj pokonal pa quik'a' ri cati't quimama' ri winek ri ye'etzelan iwuche (iwixin) riyix wacami. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Y riyix beyoma', juyi' oc iwech, ruma xik'axaj yan jun c'aslen sibilaj jabel chuwech re ruwach'ulef. Yac'a ri k'ij ri ye petenak chiwij ma ye que ta chic ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Riyix chuka' ri yixwa' jabel, juyi' oc iwech, ruma xtapon c'a ri k'ij tek xtitij wayjal. Riyix ri jabel yixtze'en wacami, juyi' oc iwech, ruma xtapon ri k'ij tek xquixbe'ok' ruma bis. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y riyix xa juyi' oc c'a iwech tek ninimirisex ik'ij cuma ri winek ri xa ma ye riche (rixin) ta ri Dios. Ruma can queri' chuka' xquiben ri quite' quitata' riye', ruma ri quite' quitata' riye' xquinimirisaj quik'ij ri xebin chi ye profetas y xa ma kitzij ta chi ye profetas. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Yac'a riyix ri can niwac'axaj wi ri nuch'abel, tiwac'axaj c'a re xtinbij chiwe: Can que'iwajo' c'a ri ye'etzelan iwuche (iwixin), y tibana' utzil chique ri winek ri itzel niquina' chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tic'utuj c'a chare ri Dios chi yeruben ta bendecir ri winek ri yerayin itzel pan iwi', y tibana' chuka' orar pa quiwi' ri yek'aban tzij chiwij. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y wi c'o c'a jun xupak'ij juc'an apalej chi k'a', xa taya' chic apo ri juc'an apalej chuwech. Y wi c'o c'a chuka' jun winek numej el achaqueta, can man c'a tapokonaj ta naya' el chuka' ri jun chic atziak chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xabachique c'a winek ri c'o nuc'utuj chawe, taya' chare ri nrajo'. Y wi c'o jun winek ri c'o numej el chawe, majun bey chic c'a tach'ojij ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Achi'el niwajo' riyix chi ri winek utz niquiben iwuq'ui, can quec'ari' tibana' riyix quiq'ui riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Y wi riyix xaxu (xaxe wi) ye'iwajo' ri winek ri ye'ajowan iwuche (iwixin), majun ri más ta chic rejkalen ri yixtajin chubanic. Ruma chi xa can queri' chuka' niquiben ri winek ri ma quiniman ta ri Dios, riye' yecajo' ri ye'ajowan quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y wi riyix, xaxu (xaxe) wi ri winek ri yebano utzil chiwe, xaxu (xaxe wi) chique riye' niben wi utzil, majun ri más ta chic rejkalen ri yixtajin chubanic. Ruma chi xa can queri' chuka' niquiben ri winek ri ma quiniman ta ri Dios, riye' niquiben utzil chique ri winek ri yebano utzil chique riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Y wi riyix niya' pa kajic jun cosa chare jun winek, xa riche (rixin) chi niwoyobej ri kajbel riche (rixin), majun ri más ta chic rejkalen ri yixtajin chubanic. Ruma chi xa can queri' chuka' niquiben ri winek ri ma quiniman ta ri Dios, ruma riye' yequiya' ka pa kajic ri quicosas chiquiwech riye', xa riche (rixin) chi c'o niquich'ec ca chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yac'a riyix ma tiben ta queri'. Xa que'iwajo' ri winek ri ye'etzelan iwuche (iwixin); tibana' utzil chique. Y tek riyix niya' pa kajic jun icosa, man c'a tiwoyobej ta ri ruq'uexel. Wi queri' niben, nim ri rajel ruq'uexel ri xtic'ul, y xtik'alajin c'a chi can yix ralc'ual chic ri nimalaj Dios. Riya' jabel runa'oj quiq'ui ri winek ri sibilaj ye itzel, y jabel runa'oj quiq'ui ri majun bey yematioxin ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Y riyix chuka' tijoyowaj quiwech ri winek, can achi'el nuben ri Itata' Dios chi nujoyowaj quiwech quinojel. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Majun bey titzu' ta achique quibanic ri winek xaxu (xaxe wi) riche (rixin) chi itzel yixtzijon chiquij, riche (rixin) chi queri' ma xtiban ta chuka' queri' chiwe riyix. Ma tirayij ta chi jun winek nika ruc'ayewal pa ruwi', riche (rixin) chi queri' ma xtika ta chuka' ruc'ayewal pan iwi' riyix. Ticuyu' quimac ri winek y xticuyutej chuka' ri imac riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wi riyix ye'ito' ri winek riq'ui ri nic'atzin chique, xtiya'ox (xtya') chuka' ri rajel ruq'uexel chiwe riyix. Ri rajel ruq'uexel ri xtiya'ox (xtya') chiwe riyix, sibilaj q'uiy, jun pajbel ri can xtinojsex, can xtipitz' y can xtipulin ruwi'. Y can achi'el ri niben riyix quiq'ui ri winek, can queri' chuka' xtiban chiwe riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y ri Jesús xubij c'a chuka' re jun c'ambel tzij re' chique: ¿C'o cami jun moy ri nicowin ta nuyukej jun chic moy y man ta yetzak pa tak jul? ");
INSERT INTO cakWNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y queri' chuka' majun c'a discípulo ri más ta nim ruk'ij que chuwech ri rutijonel. Xa c'a ya tek nretamaj na jabel ronojel ri nic'atzin, c'ac'ari' junan nuben el riq'ui ri rutijonel. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Y achique ruma tek riyit xa ya ri ti k'ayis ri c'o pa runak' ruwech ri awach'alal ri natz'et chanin y ma nana' ta ri che' k'atel pa runak' awech riyit? ");
INSERT INTO cakWNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y man c'a tabij ta chuka' chare ri awach'alal: Taya' k'ij chuwe riche (rixin) chi nwelesaj re ti k'ayis k'atel pa runak' awech, y ma naya' ta ka pa cuenta ri che' k'e'el pa runak' awech riyit. Tek nabij queri' xa ca'i' apalej. Nabey na tachojmirisaj ka ri ac'aslen riyit, c'ac'ari' utz nato' ri awach'alal chi nuchojmirisaj ri ruc'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Y majun utzilaj che' ri nuya' ta itzel tak ruwech. Majun chuka' itzel che' ri nuya' ta utzilaj tak ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ri che' netamex ruwech riq'ui ri ruwech ri nuya', wi utz o ma utz ta. Ruma ri k'ayis ri c'o quiq'uixal ma xtiquiya' ta higo, ni ma xtiquiya' ta uva. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y can quec'ari' ri winek. Ri winek utz, ya ri utz ri nuben y nubij, ruma chi can ya ri utz ri c'o pa ránima. Yac'a ri winek itzel, ya ri itzel ri nuben y nubij, ruma chi can ya ri itzel ri c'o pa ránima. Ruma jun winek can ya c'a ri c'o pa ránima ri nubij. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y achique c'a ruma tek riyix: Ajaf, Ajaf, yixcha' chuwe, y xa ma niben ta ri nbij chiwe? ");
INSERT INTO cakWNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Rumari' ri winek ri nipe wuq'ui, ri nrac'axaj ri nuch'abel y nuben ri nbij chare, nbij chiwe achoj riq'ui junan wi, ");
INSERT INTO cakWNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","junan riq'ui jun achi ri xuben jun rachoch. Nabey, xuben ka ri jul riche (rixin) ri rucimiento ri jay, y can pa ruwi' abej xuc'ot wi ka ri jul ri'. C'ac'ari' xuya' ka ri rucimiento ri jay, y xuchop c'a samaj. Y tek c'achojnek chic c'a ri jay, xpe c'a ri raken ya'. Y ri raken ya' ri' riq'ui ruchuk'a' xberila' ri jay. Pero ri jay ma xsilon ta, ruma chi ri rucimiento ri jay ri' can pa ruwi' abej tz'uyul wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yac'a ri winek ri nipe wuq'ui riche (rixin) chi nrac'axaj ri nuch'abel, y ma nuben ta ri nbij chare, xa junan riq'ui jun achi ri xa pa ruwi' ulef xuben wi ka rachoch, y xa ma xuya' ta ka ri rucimiento. Y tek ri raken ya' xbeq'uiy pe, riq'ui ruchuk'a' xberila' ri jay. Ri jay ri' xtzak y xq'uis chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Tek ri Jesús xtane' chi tzij ri ruchapon rubixic chiquiwech ri winek, Riya' xbe pa tinamit Capernaum. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chiri' pa tinamit c'o jun achi capitán. Y ri achi ri' c'o jun rumozo ri sibilaj c'a nrajo', pero yawa', y ya xa juba' ma nicom ka. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y tek ri capitán xrac'axaj c'a ri nitzijox chrij ri Jesús, riya' xerutek nic'aj rijita'k tak achi'a' ri c'o quik'ij, achi'a' israelitas, riche (rixin) chi queri' niquic'utuj jun utzil chare ri Jesús chi tipe juba', riche (rixin) chi noruc'achojsaj ca ri rumozo. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y tek ri rijita'k tak achi'a' xe'apon riq'ui ri Jesús, sibilaj c'a xquic'utuj utzil chare. Y xquibij chuka' chare: Can ruc'amon wi c'a chi naben re jun utzil re' chare ri capitán. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ruma chi riya' sibilaj yojrajo' riyoj israelitas, y chuka' xuben jun jay ri nikamol wi ki', riche (rixin) chi nikac'axaj ri ruch'abel ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y ri Jesús xbe c'a quiq'ui ri rijita'k tak achi'a' ri ye takon pe ruma ri capitán. Y tek ri Jesús y ri ye benak riq'ui xa juba' ma ye'apon chrachoch ri capitán, ri capitán xerutek c'a pe jun ca'i' oxi' ramigo chuc'ulic ri Jesús. Y ri achi'a' ri' xoquibij c'a chare ri Jesús: Ajaf, ri achi ri yoj takayon pe chi'ac'ulic rubin c'a pe: Ajaf, man c'a tatij ta más pokon wuma riyin, ruma riyit nim ak'ij y ma ruc'amon ta (takal ta chuwij) chi yatoc pa wachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y ruma chi yin aj mac, can xinna' ka chi ma ruc'amon ta (takal ta chuwij) chi yin c'a riyin ri xinapon awuq'ui. Riyit xaxu (xaxe wi) c'a tabij jun ch'abel chi nic'achoj ri numozo, y xtic'achoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Riyin can wetaman wi chi queri' xtibanatej, ruma chi yin jun achi ri nnimaj ri nubij ri aj k'atbel tzij chuwe ri c'o chi nben. Y yec'o chuka' soldados ri ye ya'on pa nuk'a'. Tek nbij c'a chare jun chi tibe, can nibe wi; y wi nbij chuka' chare jun chic chi tipe, can nipe wi chuka'. Y tek nbij c'a chare ri numozo chi tabana' re', can nuben wi chuka', nicha' pe, xecha' ri achi'a' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y ri Jesús can xumey c'a tek xrac'axaj ri rutakon el rubixic ri capitán. Y can yac'ari' xerutzu' ri winek ri ye tzeketel chrij, y xubij c'a chique: Can kitzij nbij chiwe, chi ri achi ri takayon pe rubixic re ch'abel re', can rucukuban wi ruc'u'x wuq'ui. Y majun c'a wech aj Israel ri wilon ta ri can rucukuban ta ruc'u'x wuq'ui, achi'el ri jun achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y tek xetzolin ri winek ri ye takon pe ruma ri capitán, xquitz'et c'a chi ri mozo ri yawa', can majun chic yabil c'o ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic c'a k'ij, ri Jesús xbe pa jun tinamit ri Naín rubi', y ye benak chuka' ri rudiscípulos riq'ui. Y sibilaj ye q'uiy chuka' winek ri ye tzeketel el chiquij. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tek ri Jesús y ri ye benak riq'ui xa juba' ma ye'oc apo ri pa tinamit Naín, xquitz'et c'a chi c'amon pe jun caminek riche (rixin) chi nbemuk ca. Ri caminek ri' jun ti c'ajol, ral jun malca'n ixok. Ri malca'n ixok ri', xa can xu (xe) wi c'a jun ral c'o, y yari' ri benak chumukic. Y ye q'uiy c'a winek ri ye tz'etonel ri ye benak riq'ui pa mukunic. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y tek ri Ajaf Jesús xutz'et ri ixok ri xcom el ri ral, xujoyowaj ruwech, y xubij c'a chare: Man c'a catok' ta chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y ri Jesús xuchop apo ri rucáxa ri caminek, y ri ye uc'uayon el riche (rixin) ri caminek xepa'e' c'a chiri'. Y Riya' xubij chare ri c'ajol ri': Chawe riyit yich'o wi y nbij chawe chi cayacatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y tek ri Jesús xubij queri', ri caminek xyacatej, y xuchop nitzijon pe. Y ri Jesús xujech c'a el ri c'ajol ri' chare ri rute'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tek ri winek xquitz'et ri xbanatej, xpe jun nimalaj xibinri'il chique. Y xquiya' chuka' ruk'ij ruc'ojlen ri Dios, y niquibila' c'a: Wacami xbec'ulun pe jun nimalaj profeta chkacojol, ri nik'alajsan ri ruch'abel ri Dios. Wacami ri Dios xutek pe jun ri niya'o rutzil chkacojol riyoj ri yoj rutinamit, xecha' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y ri xuben ri Jesús chupan ri k'ij ri', xetamex pa ronojel ri Judea, y xbe chuka' rutzijol ri pa tak tinamit ri yec'o pe chunakajal ri Judea. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y ri ye rudiscípulos ri Juan ri Bautista xbequitzijoj c'a chare ronojel ri nuben ri Jesús. Rumari' ri Juan xerusiq'uij (xeroyoj) ye ca'i' chique ri ye rudiscípulos, ");
INSERT INTO cakWNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xerutek c'a el c'a riq'ui ri Jesús. Xerutek el riche (rixin) chi xbequic'utuj chare: ¿Can yit c'a riyit ri Cristo ri c'o chi nipe? ¿O xa nikoyobej chic na jun? Queri' xubij el chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y ri ye rutakon el ri Juan, xe'apon c'a riq'ui ri Jesús. Y riye' xquibij c'a chare: Ri Juan ri Bautista yoj rutakon pe awuq'ui, riche (rixin) chi nokac'utuj chawe: ¿Yit c'a riyit ri Cristo ri c'o chi nipe? ¿O xa nikoyobej chic na jun? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y can ya hora ri' tek ri Jesús xeruc'achojsaj ye q'uiy yawa'i'. Xeruc'achojsaj chuka' winek ri ye chapatajnek ruma nima'k tak yabil y xerelesala' chuka' itzel tak espíritu ri yec'o quiq'ui nic'aj winek, y xuben chuka' chique ri moyi' chi xetzu'un. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y c'ac'ari' ri Jesús xubij el chique ri ye ca'i' rudiscípulos ri Juan: Wacami quixtzolin, y jebe'itzijoj chare ri xitz'et ca y ri xiwac'axaj el re wawe'. Jebe'itzijoj chare achique rubanic tek ri moyi' yecowin yetzu'un el, achique rubanic tek ri winek ye cojo yebiyin el jabel, y achique rubanic tek ri ye yawa'i' riq'ui ri yabil lepra yech'ajch'ojir el. Jebe'itzijoj chuka' chare ri achique rubanic tek ri ma ye'ac'axan ta yec'achoj, ri caminaki' yec'astej, y chique ri pobres ntzijoj ri lok'olaj ch'abel ri niya'o colotajic. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tibij chuka' chare chi can jabel ruwaruk'ij ri winek ri can rucukuban ruc'u'x wuq'ui y ma yirumalij ta ca, xe'uche'ex el y xebe. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y tek ri ye ca'i' achi'a' ri ye rutakon pe ri Juan xebe el, ri Jesús xerubila' c'a utzilaj tak ch'abel chrij ri Juan chiquiwech ri winek ri yec'o chiri'. Y quec'are' ri nubij ri Jesús chique ri winek: ¿Achique ri xbe'itz'eta' riyix pa desierto? ¿La xitz'et cami riyix jun achi chiri', chi xa achi'el jun aj, ri xa nibe quela' y xa nibe chic quela' pa ruk'a' ri cak'ik'? Ma que ta ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Achique c'a ri xbe'itz'eta' riyix chiri'? ¿La xitz'et cami riyix jun achi ri jabel tak tziek ye rucusan? Ma que ta ri'. Ruma ri achi'a' ri ye quicusalon jabel tak tziek y c'o ronojel quiq'ui, riye' can pa tak cachoch reyes yec'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pero achique ri xbe'itz'eta' riyix pa desierto? ¿Xitz'et cami jun profeta ri nik'alajsan ri ruch'abel ri Dios? Can kitzij wi chi ri achi ri xitz'et chiri', can ya wi ri' ri rusamaj. Pero can c'o c'a chuka' jun chic samaj ri ya'on pe chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ruma can ya c'a riya' ri' ri tako'n ri natan chupan ri ruch'abel ri Dios ri tz'ibatal ca, tek ri Dios xubij: Xtintek c'a ri nutako'n ri ninabeyej chawech, riche (rixin) chi nuchojmirisaj apo ri abey. Quec'ari' nubij ri tz'ibatajnek ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Riyin kitzij nbij chiwe, chiquicojol quinojel ri ye alaxnek chuwech ri ruwach'ulef, majun chic jun profeta ri más ta nim ruk'ij que chuwech ri Juan ri Bautista. Pero wacami ri pa rajawaren ri Dios, astape' jun winek xa co'ol oc ruk'ij, hasta ri' más nim ruk'ij que chuwech ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y yec'o c'a ye q'uiy winek ye c'utuy tak alcawal ri ye banon bautizar ruma ri Juan. Y tek riye' xquic'axaj ri xubij ri Jesús chrij ri Juan, xquibij chi ri Dios can choj wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Y yac'a ri achi'a' fariseos y ri achi'a' ri yek'axan ri nubij ri ley, riye' can k'alaj chi ma xcajo' ta xquic'ul ri ruch'obon ri Dios chi nuben quiq'ui, ruma ma xcajo' ta chi xeban bautizar ruma ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ri Ajaf Jesús xubij: ¿Achoj riq'ui cami yenjunumaj wi ri winek ri yec'o re tiempo re'? ¿Y achoj riq'ui ye junan wi? ");
INSERT INTO cakWNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Re winek re' xa ye junan quiq'ui ri ac'ala' ye tz'uyul pa c'aybel. Ri ac'ala' ri' niquirakala' quichi' tek yech'o chiquiwech, y niquibij c'a chupan ri quetz'anen: Xojk'ojoman riq'ui xul chiwech y ma xixxajo ta y ma xixquicot ta. Xkabixaj bix riche (rixin) bis chiwech y ma xixok' ta. Queri' niquibila' ri ac'ala' pa quetz'anen. Y ye queri' re winek re', majun ri nika ta chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ruma tek xpe ri Juan ri Bautista, riya' ma nutij ta caxlan wey, ma nukum ta chuka' ruya'al uva. Yac'a riyix xibij chi riya' xa c'o itzel espíritu riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y tek xinoka riyin ri C'ajolaxel ri xinalex chicojol, riyin ntij caxlan wey y nkum chuka' ruya'al uva. Y riyix nibij chuwe chi xu (xe wi) wa'in nwajo', y nibij chuka' chi yin jun k'abarel, chi yin cachibil ri c'utuy tak alcawal, y yin cachibil chuka' ri aj maqui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri runa'oj ri Dios can nik'alajin pa quic'aslen quinojel ri ye ralc'ual chic, chi can choj wi, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y c'o c'a jun achi fariseo ri xsiq'uin (xoyon) riche (rixin) ri Jesús riche (rixin) chi nbewa' pa rachoch. Y tek ri Jesús xapon c'a pa rachoch ri achi ri', xtz'uye' c'a apo ri pa mesa, riche (rixin) ri wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupan ri tinamit ri', c'o c'a jun ixok ri itzel ruc'aslen. Y ri ixok ri' xretamaj c'a chi ri Jesús c'o pa rachoch ri jun achi fariseo, rumari' riya' xapon chiri'. Y riya' ruc'uan c'a apo jun c'ojlibel (frasco), ri banon riq'ui jun abej ri alabastro rubi'. Ri c'ojlibel (frasco) ri' c'o el jun ak'om jubul ruxla' chupan. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y ri ixok ri' xapon c'a riq'ui ri Jesús y xuchop c'a ok'ej. Y ri ruya'al ri runak' tak ruwech ri ixok ri' xeka ka c'a chrij raken ri Jesús. Riya' yerusula' c'a raken ri Jesús riq'ui ri rusmal tak ruwi'. Ri ixok ri' yerutz'umala' (yerutz'ubala') c'a ri raken ri Jesús, y xuya' chuka' ri ak'om ri jubul ruxla' chrij ri raken. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y ri fariseo ri xsiq'uin (xoyon) riche (rixin) ri Jesús, tek xutz'et ri xuben ri ixok, xuch'ob ka: Wi ta re achi re' kas kitzij wi chi jun profeta ri nik'alajsan ri ruch'abel ri Dios, nunabej ta achique nichapo la raken, y achique chi winek la ixok la'. Ruma la jun ixok la' xa itzel ri ruc'aslen, xcha' ka pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yac'a ri Jesús xubij chare ri achi fariseo ri xsiq'uin (xoyon) riche (rixin): Simón, c'o jun ri nwajo' nbij chawe, xcha' chare. Ri Simón xubij chare ri Jesús: Tijonel, ¿achique c'a ri nawajo' nabij chuwe? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y ri Jesús xubij chare: Xec'oje' c'a ye ca'i' achi'a' ri c'o quic'as riq'ui jun achi ri niya'o puek pa kajic. Jun chique ri achi'a' ri', wu'o' ciento puek ri nibix denario chare ri ruc'as, y ri jun chic, cincuenta ri ruc'as. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero ruma c'a ri achi'a' ri' ma yecowin ta niquitoj ri quic'as, ri achi ri yayon ri puek chique pa kajic, xubij chi ma tiquitoj ta chic, xa tiq'uis chi queri', xcha' chique. Y c'ac'ari' ri Jesús xubij chuka' chare ri Simón ri fariseo: Wacami tabij c'a chuwe, ¿achique c'a chique ri ye ca'i' achi'a' ri' ri más najowan riche (rixin) ri achi ri xya'o puek pa kajic? ");
INSERT INTO cakWNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xubij: Riyin nbij chi ya ri más q'uiy ruc'as rubanon riq'ui. Ja' (je), can queri' achi'el ri xabij, xcha' ri Jesús chare ri Simón. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y ri Jesús rutzuliben ri ixok tek xubij chare ri Simón ri fariseo: ¿Natz'et re ixok re'? Riyin tek xinoc pe re wawe' pan awachoch, ma xaya' ta nuya' ch'ajbel waken. Yac'a re ixok re' xeruch'ej re waken riq'ui ri ruya'al ri runak' tak ruwech, y xeruchakirisaj riq'ui ri rusmal tak ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chuka' tek xinoc pe, ma xinatz'umaj (xinatz'ubaj) ta riche (rixin) chi xaya' rutzil nuwech. Yac'a re ixok re', can yac'a tek xinoc pe tek ruchapon yerutz'umaj (yerutz'ubaj) ri waken. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Riyit chuka' ma xak'ej ta aceite pa nujolon (nuwi') tek xinoc pe. Yac'a re ixok re', can ya ri ak'om ri jubul ruxla' ri xuyala' chrij ri waken. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rumari' nbij chawe riyit Simón, chi re ixok re' sibilaj nrajo' ri xcuyu ri rumac. Y rumari' ri janipe' chi mac ri ye rubanalon pe xecuyutej yan. Yac'a jun winek ri nuna' chi xa ma q'uiy ta ri rumac ri xecuy, xa ma can ta nrajo' ri xcuyu ri rumac. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y ri Jesús xubij chare ri ixok: Ri amac xecuyutej yan. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y ri winek ri xesiq'uix (xe'oyox) ruma ri Simón ri fariseo y junan yec'o riq'ui ri Jesús ri chiri' pa mesa, niquibila' c'a chiquiwech: ¿Achique c'a chi achi re'? Ruma can yerucuy chuka' mac, yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xubij chare ri ixok: Xac'achoj, ruma chi xacukuba' ac'u'x wuq'ui. Wacami c'a, catzolin; ruma xawil yan uxlanibel c'u'x. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xa c'a ca'i' oxi' k'ij tibanatej wi ronojel ri', tek ri Jesús xuchop c'a chi nibe pa tak tinamit y pa tak aldeas, y chi ye cablajuj rudiscípulos ye benak riq'ui. Y Riya' nutzijoj c'a ri lok'olaj ch'abel ri nich'o chrij ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y yec'o chuka' ca'i' oxi' ixoki' ri ye tzeketel el chrij. Ri ixoki' ri', yeri' ri ye ruc'achojsan ri Jesús y relesalon itzel tak espíritu quiq'ui. Chiquicojol c'a ri ixoki' ri' benak ri María, ri nibix chuka' Magdalena chare. Y ya c'a riq'ui ri ixok ri' xe'elesex wi ye wuku' itzel tak espíritu ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Y benak chuka' ri Juana, rixjayil ri jun achi ri Chuza rubi'. Y ri achi ri' jun rumozo ri Herodes. Y benak chuka' ri Susana. Y ye benak chuka' nic'aj chic ixoki' ri can c'o chuka' quibeyomal ri can ye riye' yeya'o y yebano ronojel ri nic'atzin chare ri Jesús, y chique ri ye rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Y riq'ui ri Jesús sibilaj ye q'uiy winek ri xquimol apo qui', y yec'o chuka' apo ri yepe pa nic'aj chic tinamit. Y Riya' c'o c'a jun c'ambel tzij ri xubij chique, y quec'are' ri xubij chique: ");
INSERT INTO cakWNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o c'a jun achi ri xbe pa jopin ija'tz. Y tek ri achi c'o chic pa samaj nijopin ija'tz, juba' c'a chare ri ija'tz ri' xa pa bey xka wi, rumari' ri winek yek'ax pa ruwi'. Y xepe ri aj xic' tak chicop ri yebe pa cak'ik', xquitij el ri ija'tz ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Y juba' chic chare ri ija'tz xka cojol tak abej. Ri ija'tz c'a ri' xel pe. Xa yac'a tek xpe ruchuk'a' ri k'ij, xechaki'j ka, ruma man c'o ta más ruraxal ri ulef ri xka wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y juba' chic chare ri ija'tz xka cojol tak k'ayis ri c'o quiq'uixal. Y tek xe'el pe, junan xeq'uiy quiq'ui ri q'uix. Y ruma chi ri q'uix sibilaj xeq'uiy, ri tico'n xejik' pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Yac'a ri juba' chic chare ri ija'tz xka pa jun utzilaj ulef, y jabel xeq'uiy. Y xquiyala' jojun ciento quiwech jojun ija'tz, xcha'. Yac'a tek rubin chic ka ri', can riq'ui c'a ruchuk'a' xch'o, y xubij: Ri c'o c'a rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y ri ye rudiscípulos ri Jesús xquic'utuj c'a chare chi achique c'a ri nrajo' nuk'alajsaj chiquiwech riq'ui re jun c'ambel tzij re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y ri Jesús xubij c'a chique: Chiwe c'a riyix can ya'on c'a k'ij riche (rixin) chi niwetamaj chrij ri rajawaren ri Dios, yac'a ri nic'aj chic winek ri ma yeniman ta wuche (wixin), ma ya'on ta k'ij chique chi niquetamaj. Rumac'ari' riq'ui c'ambel tak tzij yitzijon wi quiq'ui, riche (rixin) chi queri' astape' niquitzu' y xa ma nich'obotej ta chiquiwech ri niquitzu', y riche (rixin) chi astape' niquic'axaj y xa ma nik'ax ta chiquiwech ri niquic'axaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y quec'are' ri nubij ri c'ambel tzij ri': Ri ija'tz junan nuben riq'ui ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri juba' ija'tz ri xeka pa bey, junan riq'ui ri ruch'abel ri Dios tek nac'axex cuma ri winek. Ri itzel winek chanin nipe, y nrelesaj el ri ruch'abel ri Dios ri xtic pa tak cánima ri winek ri', riche (rixin) chi queri' ri winek ri' ma niquinimaj ta ri Dios, y ma yecolotej ta chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y ri ija'tz ri xeka cojol tak abej, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex cuma ri winek. Ri winek ri' can sibilaj c'a yequicot tek niquic'ul ri ruch'abel ri Dios pa tak cánima. Pero ruma can ma xbe ta ka jabel ruc'amal ri ruch'abel ri Dios pa tak cánima, xa can ma niyaloj ta c'a ri quicoten quiq'ui. Y tek yetojtobex, niquiya' ca ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija'tz ri xeka cojol tak k'ayis ri c'o quiq'uixal can nich'o wi c'a chiquij ri winek ri niquic'axaj ri ruch'abel ri Dios. Pero ri winek ri' xa yejik' ruma xaxu (xaxe wi) niquich'ob achique nic'atzin chare ri quic'aslen wawe' chuwech re ruwach'ulef y xaxu (xaxe) wi niquich'ob ri quibeyomal y chuka' ri achique yequirayij. Y rumari' ma niwachin ta jabel ri quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Yac'a ri ija'tz ri xeka pa jun utzilaj ulef, can nich'o wi c'a chrij ri ruch'abel ri Dios ri nac'axex cuma ri winek. Riye' riq'ui ronojel cánima niquic'axaj y niquiben ri nubij. Y can niquiyec pa cánima ri ruch'abel ri Dios, y niwachin jabel ri quic'aslen ronojel tiempo. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y majun chuka' winek ri nutzij jun k'ak' y c'a ta ri' nutz'apij rij riq'ui jun bojo'y o nuya' ta chuxe' ri ruch'at. Ma que ta ri' nuben. Ri k'ak' ri' nic'atzin nicanox jun ruc'ojlibel ri acuchi (achique) nipa'e' wi, riche (rixin) chi queri' ri ye'oc apo pa jay yetzu'un jabel. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y majun ri ewan ca, ri man ta xtibek'alajin pe. Y chuka' majun ri tz'apin ca rij, ri xa man ta xtibek'alajin pe y ntel pe chuwasakil. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Y queri', wi riyix niwac'axaj ri ruch'abel ri Dios, tiyaca' c'a ka ri pa tak iwánima. Ruma ri can c'o q'uiy riq'ui xtiya'ox (xtya') c'a más chare y queri' q'uiy ri xtic'oje' riq'ui. Yac'a ri xa juba' oc c'o riq'ui, y astape' nuch'ob chi c'o ri juba' ri' riq'ui, hasta ri juba' ri' xa xtelesex chare, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y ri rute' y ri ye rach'alal ri Jesús xepe c'a ri acuchi (achique) c'o wi Riya'. Pero xa ma xecowin ta xe'oc apo riq'ui, ruma sibilaj ye q'uiy winek ri quimolon apo qui' riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y xbix c'a apo chare ri Jesús: Ri ate' y ri ye awach'alal yec'o pe wawe' chuwajay el, ye petenak chatz'etic. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yac'a Riya' xubij: Yec'a ri winek ri ye'ac'axan y niquiben ri nubij ri ruch'abel ri Dios, yec'ari' ri ye achi'el nte' y ye achi'el wach'alal, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y c'o c'a jun k'ij, tek ri Jesús ye rachibilan ri rudiscípulos, xoc el pa jun jucu'. Y c'ac'ari' xubij chique: Jo', kojk'ax la juc'an chic apo ruchi' choy. Y xebe. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y ri Jesús xwer el, tek quichapon el bey pa ruwi' ri choy. Y xpe c'a jun nimalaj cak'ik' chiri' pa ruwi' ri choy. Rumari' ri jucu' ri ye benak wi, xuchop ninoj pe chi ya', y xa juba' ma yebe chuxe' ya'. Can pa ruc'ayewal c'a yec'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xepe c'a ri discípulos xquic'asoj ri Jesús, y xquibij chare: ¡Tijonel! ¡Tijonel! Wacami yojcom, xecha' chare. Y ri Jesús xyacatej c'a pe, y xubij: Tiq'uis el ri cak'ik' y ri ruwi' ya' titane' ka, xcha'. Y queri' xbanatej. Ri cak'ik' xq'uis el, y ri ruwi' ya' xtane' ka. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Yac'ari' tek ri Jesús xubij chique ri ye rudiscípulos: ¿Achique ruma tek ma xicukuba' ta ic'u'x wuq'ui? Yac'a ri discípulos quixibin qui'. Can xquimey tek xquitz'et ri xbanatej, y xquic'utula' chiquiwech: ¿Achique c'a chi achi re'? Ruma tek nich'o chique ri cak'ik' y ri ya', can niquinimaj wi rutzij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ri Jesús y ri rudiscípulos xe'apon c'a ri juc'an chic ruchi' choy, ri chiri' pa jun lugar ri Gadara rubi', ri c'o apo chuwech ri Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y tek ri Jesús xel pe chupan ri jucu', xapon c'a jun achi riche (rixin) ri tinamit ri' riq'ui. Y ri achi ri' c'o chic c'a q'uiy tiempo ri yec'o pe itzel tak espíritu riq'ui, majun rutziak nucusaj, ni ma nic'oje' ta pa rachoch. Xa ya ri camposanto ri oconek rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y ri achi ri', can xu (xe) wi xutz'et ri Jesús, can yac'ari' tek xbexuque' xbemaje' chuwech. Y xurek apo ruchi' chare ri Jesús, y xubij c'a: Riyit Jesús ri can yit Ruc'ajol ri nimalaj Dios, ¿achique ruma tek yinanek? Tabana' jun utzil ma quinach'ujirisaj ta, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ri achi xubij queri' ruma ri Jesús xubij chare ri itzel espíritu ri c'o riq'ui ri achi ri' chi tel el. Ruma q'uiy chic tiempo c'o pe ri itzel espíritu ri' riq'ui. Y ruma chuka' ri' ri winek q'uiy c'a mul quiximon ruk'a' raken ri achi ri' riq'ui ch'ich' y cadenas, pero ma ye cowinek ta chrij. Ruma chi ri achi ri' yeruc'okpij ri cadenas ri achoj riq'ui ximon wi, y ri itzel espíritu ri c'o riq'ui nuben c'a chare chi nibe pa tak lugar ri acuchi (achique) majun winek c'o. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xuc'utuj c'a chare ri achi: ¿Achique abi'? Y ri itzel espíritu ri c'o riq'ui ri achi xubij: Yoj q'uiy ri nubi', xcha'. Queri' xubij ruma can ye q'uiy ri itzel tak espíritu ri yec'o riq'ui ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y ri itzel tak espíritu ri' sibilaj c'a xquic'utuj utzil chare ri Jesús, chi wi yerelesaj el riq'ui ri achi, man c'a querutek ta el chupan ri itzel jul ri k'eku'm rupan, quilugar ri itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y chunakajal apo ri c'o wi ri achi ri', sibilaj c'a ye q'uiy ak yetajin yewa' pa ruwi' jun juyu', y rumari' ri itzel tak espíritu xquic'utuj utzil chare ri Jesús chi tuya' k'ij chique riche (rixin) chi ye'oc quiq'ui ri ak ri'. Y ri Jesús xuya' k'ij chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y ri itzel tak espíritu can yac'ari' xe'el el riq'ui ri achi, y xebe'oc quiq'ui ri ak. Quinojel c'a ri ak ri' xquichop anin (anibel) chuwech jun juyu' xulan ruwech y choj xebeka c'a pa choy. Y chiri' xejik' wi quinojel ri ak ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y ri yeyuk'un quiche (quixin) ri ak ri', tek xquitz'et ri xbanatej, xe'anmej y xbequiyala' ca rutzijol pa tinamit y ri pa tak juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y ri winek ri xe'ac'axan pe ri xbanatej, xepe chutz'etic. Tek ri winek ri' xe'oka riq'ui ri Jesús, xquitz'et c'a chi ri achi ri xe'elesex ri itzel tak espíritu riq'ui, tz'uyul c'a apo riq'ui ri Jesús, rucusan rutziak, y ma nuben ta chic c'a achi'el ri rubanon pe. Pero ri winek ri' xa xquixibij qui' tek xquitz'et ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y xtzijox chuka' chique achique rubanic ri xbanatej. Ronojel ri' xtzijox chique cuma ri winek ri can xetz'eto tek xe'elesex ri itzel tak espíritu riq'ui ri achi ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Riq'ui c'a ronojel ri xbanatej, ri winek ri aj chiri' pa Gadara, xquic'utuj c'a utzil chare ri Jesús chi tel el ri chiri'. Ri winek ri aj chiri' xquibij c'a queri' chare ruma chi sibilaj quixibin qui'. Rumac'ari' ri Jesús ye rachibilan ri rudiscípulos xe'oc el pa jucu' riche (rixin) chi xebe. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y ri achi ri xe'elesex ri itzel tak espíritu riq'ui, nuc'utuj c'a jun utzil chare ri Jesús chi tuya' k'ij chare riche (rixin) chi nibe riq'ui. Yac'a ri Jesús xa xubij c'a chare: ");
INSERT INTO cakWNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolin chawachoch, y jatzijoj ri xuben ri Dios awuq'ui riyit, xuche'ex. Y ri achi can xberutzijoj na wi chrachoch, y chique quinojel ri winek pa rutinamit xutzijoj wi ri xuben ri Jesús riq'ui riya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y tek ri Jesús xtzolin c'a juc'an chic chare ri ruchi' ri choy, ri winek yec'o chiri', riq'ui c'a quicoten xquic'ul apo, ruma chi ri winek ri' can ya c'a Riya' ri coyoben. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xapon c'a chuka' jun achi ri Jairo rubi'. Ri achi c'a ri' jun principal chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Riya' xbexuque' xbemaje' chuwech ri Jesús, y xuc'utuj c'a jun utzil chare chi nibe riq'ui c'a pa rachoch, ");
INSERT INTO cakWNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ruma xa can xu (xe wi) ri jun ti rumi'al c'o, y c'o achi'el xa cablajuj rujuna' y ya xa juba' ma nicom ka. Y tek ri Jesús y ri ye benak riq'ui xquichop el bey riche (rixin) chi yebe chrachoch ri Jairo, sibilaj ye q'uiy c'a winek ri xetzeke' el chrij. Y rumari' niquipitz'ila' c'a qui' chrij, ye benak. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicojol c'a ri winek, benak jun ixok ri c'o jun ruyabil riche (rixin) ic' chare. Ri ixok ri' c'o chic c'a cablajuj juna' ri ma tanel ta ri ruquiq'uel. Xuq'uis yan c'a ronojel rurajil, ruma benak chic quiq'ui q'uiy ajk'omanel, y majun chique ri ajk'omanel cowinek ta rak'oman ri ruyabil. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok ri' xjel c'a apo chrij ri Jesús, y xberuchapa' c'a ca juba' ri ruchi' rutziak ri Jesús. Y can yac'ari' xk'atak'o ri ruquiq'uel. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y yac'ari' tek ri Jesús xuc'utuj: ¿Achique ri xichapo? Y ruma chi quinojel niquibij chi majun xquichop ta riye', ri Pedro y ri nic'aj chic discípulos xquibij chare ri Jesús: Tijonel, riyit nawajo' nawetamaj achique xachapo. Pero wawe' ma xtawetamaj ta, ruma sibilaj ye q'uiy winek niquipitz' qui' y niquinimila' qui' chawij, y riyit nac'utuj: ¿Achique xichapo? ");
INSERT INTO cakWNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Y yac'ari' tek ri Jesús xubij: C'o jun ri xichapo, ruma can xinna' chi c'o jun ri xinc'achojsaj riq'ui ri uchuk'a' c'o wuq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y ri ixok tek xutz'et chi xa xnabex, nibarbot (nibaybot) c'a xoxuque' xomaje' chuwech ri Jesús. Y chiquiwech quinojel ri winek xubij apo chare ri Jesús ri achique ruma tek xuchop ruchi' rutziak. Y xubij chuka' chi can xu (xe wi) xuchop ruchi' rutziak ri Jesús, can yac'ari' xuna' riya' chi xc'achoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xubij chare: Numi'al, xac'achoj, ruma xacukuba' ac'u'x wuq'ui. Wacami c'a, catzolin; ruma xawil yan uxlanibel c'u'x, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y c'a ntajin na c'a nitzijon ri Jesús riq'ui ri ixok, tek c'o jun achi xoka ri petenak chrachoch ri Jairo, ri Jairo ri principal chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. Ri jun achi ri xoka, xorubij c'a chare ri Jairo: Man chic tac'uaj ta el ri Tijonel Jesús, ruma ri ti ami'al xa xcom yan. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yac'a tek ri Jesús xrac'axaj pe, xubij chare ri Jairo: Ma taxibij ta awi' ruma ri xobix chawe. Xaxu (xaxe wi) tacukuba' c'a ac'u'x wuq'ui, y ri ti ami'al xtic'astej, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y tek xe'apon c'a chrachoch ri Jairo, ri Jesús xaxu (xaxe) wi c'a chique ri Pedro, ri Jacobo, ri Juan, y ri rute' rutata' ri ac'al xuya' k'ij riche (rixin) chi xe'oc pa jay riq'ui ri ti k'opoj ri caminek. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Y ri Jesús xerutz'et chi quinojel ri winek ye'ok' y can niquirek quichi' chi ok'ej. Yac'a ri Jesús xubij chique: Man c'a tiwok'ej ta chic ri ti k'opoj, ruma riya' xa ma caminek ta, riya' xa warnek, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero riye' xa xetze'en chrij ri Jesús, ruma quetaman chi ri ti k'opoj xa caminek chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y ri Jesús xuchop ruk'a' ri ti caminek, y xubij c'a: Nóya, cayacatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ri ti k'opoj can xtzolin na wi pe ri ránima y can yari' xyacatej pe. Y ri Jesús xubij chi titzuj (tisuj) ruway. ");
INSERT INTO cakWNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y ri te'ej tata'aj can xquimey tek xquitz'et ri xbanatej riq'ui ri calc'ual. Y ri Jesús xubij chique chi majun achoj chare tiquitzijoj wi ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xerusiq'uij (xeroyoj) c'a ri cablajuj rudiscípulos, y xuya' uchuk'a' chique y xuya' k'atbel tzij pa quik'a' riche (rixin) chi yecowin yequelesaj quinojel quiwech itzel tak espíritu, y riche (rixin) chuka' yequic'achojsaj yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xerutek c'a el ri rudiscípulos riche (rixin) chi xebe chutzijoxic ri rajawaren ri Dios, y riche (rixin) chuka' chi yequic'achojsaj yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y ri Jesús xubij chuka' chique: Re nichop el bey, can majun c'a tic'uaj el. Ma tic'uaj ta ch'ame'y, ma tic'uaj ta ya'l, ni caxlan wey, ni irajil. Y ma tic'uaj ta el ca'i' itziak, xa can xu (xe) wi ri icusan. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y xabachique ta na jay ri yixapon wi pa jun tinamit, chiri' quixc'oje' wi ka. Xa can c'a ya tek yixel pe chupan ri tinamit ri', c'ac'ari' utz chi niya' ca ri jay ri xixc'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y wi ri tinamit ri yixapon wi xa ma yixc'ul ta, can quixel c'a pe chiri' y titotala' (tiquirala') ca ri pokolaj ri c'o chiwaken chiquiwech ri winek ri', riche (rixin) chi queri' tiquetamaj chi ma utz ta ri xquiben, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y ri discípulos xebe na wi. Xebe ri pa tak aldeas riche (rixin) chi xbequitzijoj ri lok'olaj ch'abel ri niya'o colotajic. Y xequic'achojsaj chuka' yawa'i' ronojel ri acuchi (achique) xek'ax wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y ri Herodes, jun chique ri ye caji' aj k'atbel tak tzij chupan ri tiempo ri', can yerac'axala' c'a ronojel ri yerubanala' ri Jesús. Pero ma nril ta c'a achique ri nunimaj, ruma yec'o yebin chi ri nibano queri' ya ri Juan ri Bautista ri xc'astej pe chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yec'o c'a chuka' yebin chi ri Jesús ya ri Elías ri xtzolin pe. Y nic'aj chic winek niquibij c'a chi ri Jesús jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, ri xbec'astej pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y ri Herodes nubij: ¿Achique cami chi achi ri'? Ruma q'uiy yenwac'axaj chrij. Pero riyin nbij chi ma ya ta ri Juan ri Bautista, ruma ri Juan yin c'a riyin xitako rutzaq'uixic rujolon (ruwi'), xcha'. Y ri Herodes nucanola' c'a achique nuben, ruma nrajo' nutz'et ruwech ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y tek ri ye ru'apóstoles ri Jesús xetzolin pe chubanic ri rusamaj ri Dios, xquitzijola' c'a chare ri Jesús ri xequibanala'. Y ri Jesús xeruc'uaj c'a el ri ru'apóstoles, y xebe pa jun desierto, jun lugar ri c'o pa rucuenta ri tinamit Betsaida. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y tek ri winek xquinabej el chi xbe ri Jesús ye rachibilan ri rudiscípulos, xebe chuka' riye'. Y tek ri winek ri' xe'apon riq'ui ri Jesús, Riya' jabel xeruc'ul y xubij chuka' chique achique rubanic ri rajawaren ri Dios. Y chuka' xeruc'achojsaj yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Y tek xka ka ri k'ij ri', ri cablajuj discípulos xejel apo riq'ui ri Jesús y xquibij chare: Que'ataka' c'a el re winek re' riche (rixin) chi yebe chucanoxic acuchi (achique) yebewer wi, y yebe chuka' chucanoxic quiway pa tak aldeas y pa nic'aj chic lugar ri yec'o pe nakaj. Ruma re yojc'o wi, xa majun winek yec'o, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yac'a ri Jesús xubij chique ri rudiscípulos: Tiya' quiway riyix. Y ri discípulos xquibij chare ri Jesús: Wawe' ma q'uiy ta caxlan wey c'o riche (rixin) chi nikaya' chique, xaxu (xaxe wi) wu'o' caxlan wey y ca'i' car. Re winek re' yewa', pero wi yojbe chulok'ic cosas riche (rixin) chi niquitij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ruma ri winek sibilaj ye q'uiy. Y xaxu (xaxe wi) ri achi'a' yec'o achi'el xa wu'o' mil. Y ri Jesús xubij chique ri ye rudiscípulos: Tibij chique re winek re' chi quetz'uye' pa tak moc y chi nic'aj tak ciento tiquic'uaj qui', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y can que na wi ri' xquiben ri discípulos, xquiben chique quinojel ri winek chi xetz'uye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y ri Jesús xeruli'ej c'a pa ruk'a' ri wu'o' caxlan wey y ri ca'i' car y c'ac'ari' xtzu'un chicaj y xuc'utuj ri rubendición ri Dios pa ruwi'. Y c'ac'ari' ri Jesús xeruwech'ela' c'a el ri caxlan wey y ri car, y xuya' el chique ri rudiscípulos riche (rixin) chi niquiya' chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Can quinojel c'a jabel xewa'. Can majun c'a ri man ta xwa' chi utz. Y c'a c'o na c'a cablajuj chaquech caxlan wey y car ri xmolotej ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y c'o c'a jun k'ij tek ri Jesús ruyon c'a ntajin nuben orar, y ri ye rudiscípulos can yec'o chuka' apo chunakajal. Y yac'ari' tek ri Jesús xuc'utuj chique ri rudiscípulos: ¿Yin achique c'a riyin niquibij ri winek? ");
INSERT INTO cakWNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y riye' xquibij chare: Yec'o ri yebin chi yit c'a riyit ri Juan ri Bautista. Yec'o nic'aj chic niquibij chi yit c'a riyit ri Elías. Y yec'o c'a chuka' ri yebin chi riyit jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, y wacami xac'astej pe chiquicojol ri caminaki', xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y Riya' xuc'utuj c'a chique ri rudiscípulos: ¿Yin achique c'a riyin nibij riyix? xcha' chique. Y ri Pedro can yac'ari' tek xubij chare ri Jesús: Yit c'a riyit ri Cristo, ri yit takon pe ruma ri Dios, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Yac'a ri Jesús sibilaj xuchilabej chique ri ye rudiscípulos chi majun achoj chare tiquitzijoj wi chi ya Riya' ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xubij c'a chuka' chique: Riyin ri C'ajolaxel ri xinalex chicojol, c'o chi nk'axaj na q'uiy tijoj pokonal. Y xquinetzelex cuma ri rijita'k tak achi'a' ri c'o quik'ij. Xquinetzelex cuma ri principali' tak sacerdotes y cuma ri aj tz'iba'. Y xquicamisex. Pero pa rox k'ij xquic'astej pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y c'ac'ari' xubij chique quinojel: Wi c'o jun nrajo' yirutzekelbej, man c'a tupokonaj ta nuk'axaj tijoj pokonal. Xa can tubana' c'a achi'el nuben jun ri benak chuxe' jun cruz riche (rixin) chi nbecamisex. Ma nuben ta chic ri nurayij ka riya'. Wi c'o c'a jun nich'obo chi nicowin nuben queri' k'ij k'ij, utz chi nipe wuq'ui y quirutzekelbej c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ruma wi can nupokonaj ri ruc'aslen re wawe' chuwech re ruwach'ulef, xa ma xtril ta c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri ma nupokonaj ta ri ruc'aslen re wawe' choch'ulef, astape' ta na can napon pa camic wuma riyin, xa can xtril ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ruma, ¿achique ta c'a nuc'om pe chare ri winek wi nic'oje' ri beyomel riche (rixin) ronojel ri ruwach'ulef riq'ui y wi xa ma nicolotej ta? Xa ruyon c'a nuya' ri' chupan ri camic riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ruma wi jun winek niq'uix yiruk'alajsaj riyin y niq'uix nuk'alajsaj ri nuch'abel, queri' chuka' xtinben riyin ri C'ajolaxel ri xinalex chicojol, tek xquipe chic jun bey, xquiq'uix nbij chi ri jun winek ri' wuche (wixin) riyin, tek xtik'alajin chi can yin Rey wi, y chuka' junan chic nuk'ij nuc'ojlen riq'ui ri Nata' y ye wachibilan pe ri lok'olaj tak ángeles. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y can kitzij c'a re nbij chiwe chi yec'o c'a nic'aj chiwe ri yec'o wawe' ri ma xquecom ta na, xquecom pero c'a ya tek quitz'eton chic na ca ri rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y achi'el xa c'o yan jun semana k'axnek ca tek ri Jesús tich'o wi chiquiwech ri winek, yac'ari' tek Riya' xerucha' c'a ri Pedro, ri Juan y ri Jacobo riche (rixin) chi yerachibilaj el chi nibe pa ruwi' jun juyu' chubanic orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y tek ri Jesús ntajin c'a chare ri oración, xjalatej c'a ri ruwachbel, y can queri' chuka' ri rutziak, can xjalatej ri yetzu'un. Ri rutziak sibilaj rusakil xuben y nitz'itz'an. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y can yac'ari' tek xquichop tzij ye ca'i' achi'a' riq'ui ri Jesús. Y ri ye ca'i' achi'a' ri' ya ri Moisés y ri Elías ri ye rusamajel ri Dios ri xec'oje' ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Riye' xusutij c'a ri' jun lok'olaj sakil chiquij, y yetzijon c'a chrij ri camic ri xtiban chare ri Jesús pa Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y ri Pedro y ri ye rachibil, sibilaj quiwaran c'o, pero xquicoch' ma xewer ta, y rumari' xquitz'et c'a ri lok'olaj sakil riche (rixin) ri Jesús, y xequitz'et chuka' ri ye ca'i' achi'a' ri yec'o riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y tek ri ca'i' achi'a' ri' niquiya' c'a ca ri Jesús riche (rixin) chi yebe, yac'ari' tek ri Pedro xubij chare ri Jesús: Tijonel, xa utz kabanon chi yojc'o wawe'. Tikabana' oxi' tak ca'aj, jun awuche (awixin) riyit, jun riche (rixin) ri Moisés y queri' chuka' jun riche (rixin) ri Elías, xcha' chare. Ri Pedro quec'ari' xubij apo y ma retaman ta achique ruma tek xch'o apo. Xa ch'obon, ma ch'obon ri xerubila' apo. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y c'a nich'o na c'a ri Pedro, tek c'o jun sutz' ri xka pe pa quiwi' y xerucuch. Y ri ye rudiscípulos xquixibij qui' tek xquina' chi yec'o chic chupan ri sutz' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y yac'ari' tek c'o jun ch'abel xquic'axaj chupan ri sutz' ri', y xubij: Yare' ri Nuc'ajol y can sibilaj nwajo'. Can ya c'a Riya' tiwac'axaj, xcha' ri ch'abel ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y yac'a tek quic'axan chic ri jun ch'abel ri', yac'ari' tek xquitz'et chi ri Jesús xa ruyon chic c'o ca. Y ri discípulos ri', q'uiy c'a k'ij ri majun achoj chare xquibij wi ri xquitz'et ri chiri' pa ruwi' ri juyu'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y pa ruca'n k'ij, tek ri Jesús ye rachibilan ri ye oxi' rudiscípulos xka pe pa ruwi' ri juyu', can ye sibilaj c'a ye q'uiy ri winek ri xec'ulu apo riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y jun achi ri c'o chiquicojol ri winek, riq'ui ruchuk'a' xch'o apo chare ri Jesús y xubij: Tijonel, riyin xaxu (xaxe wi) jun walc'ual c'o. Nc'utuj c'a jun utzil chawe chi tatzu' juba', ");
INSERT INTO cakWNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ruma chi c'o jun itzel espíritu nichapo. Y tek nuchop, nuben c'a chare chi nurek ruchi', nuben chare chi nibarbot (nibaybot) ri ruch'acul, y nuben chuka' chare chi niwoko pa ruchi'. Ri itzel espíritu ri' can nik'ax ruwi' nuben chare ri nuc'ajol, y c'arunaj nuya' ca tek nuchop. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rumari' xinc'utuj yan jun utzil chique re adiscípulos chi tiquelesaj el re jun itzel espíritu re' riq'ui ri nuc'ajol, pero xa ma ye cowinek ta chi niquelesaj, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y ri Jesús yac'ari' tek xubij chique: Riyix winek ri yixc'o chuwech re ruwach'ulef, majun chiwe ri cukul ta ruc'u'x riq'ui ri Dios. Chi'iwonojel xa yix sachnek. ¿Riyix nich'ob chi riyin can ronojel k'ij xquic'oje' iwuq'ui, y man c'a xquitane' ta chi yixincoch'? Tac'ama' pe ri ac'ajol wawe', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y tek ri c'ajol xapon apo riq'ui ri Jesús, ri itzel espíritu riq'ui ruchuk'a' xuyicaj y xuch'akij pan ulef. Ri Jesús xchapon c'a chare ri itzel espíritu, riche (rixin) chi tel el riq'ui ri c'ajol ri'. Y ri Jesús can xuc'achojsaj wi c'a el y xujech el chare ri rutata'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y quinojel c'a ri winek xquimey tek xk'alajin ri nimalaj ruchuk'a' ri Dios. Y tek quinojel c'a ri winek yetajin niquimey c'a rij ronojel ri yerubanala' ri Jesús, Riya' xubij chique ri rudiscípulos: ");
INSERT INTO cakWNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Can tiwac'axaj c'a jabel re tzij re', y man c'a timestaj ta: Riyin ri C'ajolaxel ri xinalex chicojol, can xquijach wi pa quik'a' ri winek, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Y ri tzij ri' ma xk'ax ta chiquiwech ri discípulos, ruma ma ya'on ta k'ij chique chi nik'ax chiquiwech, y riye' niquixibij c'a qui' niquic'utuj chare ri Jesús chi achique ri xubij chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ri rudiscípulos ri Jesús xquich'ojila' chiquiwech chi achique chique riye' ri más nim ruk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yac'a ri Jesús can retaman c'a achique yetajin chuch'obic pa tak cánima ri rudiscípulos. Rumari' Riya' xberuc'ama' pe jun ti ac'al, y xupaba' riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y xubij chique ri rudiscípulos: Xabachique ri nuc'ul jun ac'al pa nubi' riyin, jun ri achi'el re', ma xu (xe) ta wi xtuc'ul ri ac'al, xa can xquiruc'ul chuka' riyin. Y ri xtic'ulu c'a wuche (wixin) riyin, can xtuc'ul c'a chuka' ri yin takayon pe. Ruma chi ri can nuch'utinirisaj ri' chicojol riyix, yari' ri más nim ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpe c'a ri Juan xubij chare ri Jesús: Tijonel, riyoj katz'eton c'a jun achi ri pan abi' riyit yerelesala' itzel tak espíritu. Pero ruma xa ma kachibil ta, xkak'il ca, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y ri Jesús xubij c'a chare ri Juan: Ma tik'il ta chic. Ruma ri ma yojquetzelaj ta, can ye kachibil wi c'a ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y tek xa noka yan c'a ri k'ij riche (rixin) chi ri Jesús xtitzolin chila' chicaj, Riya' can xuch'ob c'a pa ránima chi xuchop el ri rubey riche (rixin) chi nibe pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y yec'o chuka' ri xerutek el nabey riche (rixin) chi xebe pa jun aldea ri c'o pa rucuenta ri Samaria, xebe chucanoxic jun jay ri acuchi (achique) xtibe'uxlan wi ri Jesús y ri ye rachibilan el. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri winek aj chiri' ma xcajo' ta xquic'ul ri Jesús, ruma chi ri winek ri' xquinabej chi xa pa Jerusalem ruchapon wi el bey. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tek ri discípulos Jacobo y Juan xquinabej chi ma nic'ul ta ri Jesús cuma ri winek, xquibij chare ri Jesús: Ajaf, ¿nawajo' chi nikac'utuj chi tika pe k'ak' chila' chicaj, riche (rixin) chi yeruq'uis re winek re'? Achi'el xuben ri Elías, ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y ri Jesús xerutzu' y xchapon chique. Y xubij c'a chique: Riyix ni ma iwetaman ta chi ri Espíritu ri c'o iwuq'ui riche (rixin) chi ye'iwajo' quinojel. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ruma chi riyin ri C'ajolaxel ri xinalex chicojol, ma xipe ta wawe' chuwech re ruwach'ulef chiquicamisaxic winek, riyin xa xipe chiquicolic, xcha'. Y ri Jesús y ri rudiscípulos xebe pa jun chic aldea. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y tek riye' quichapon chic c'a el bey, c'o c'a jun achi ri xbec'ulun pe, y xubij chare ri Jesús: Ajaf, riyin nwajo' c'a yatintzekelbej xabacuchi (xabachique) yabe wi, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yac'a ri Jesús xubij chare ri achi: Ri xwan, can c'o wi jul ri acuchi (achique) yec'oje' wi; y queri' chuka' ri aj xic' tak chicop ri yebe pa cak'ik', can c'o chuka' quisoc. Yac'a riyin ri C'ajolaxel ri xinalex chicojol, can majun wachoch ri acuchi (achique) yinuxlan wi juba', xcha' chare ri achi ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y ri Jesús xubij c'a chare jun chic achi: Quinatzekelbej. Yac'a ri achi ri' xubij: Ajaf, riyin can nwajo' wi yatintzekelbej. Xa yac'a chi taya' na k'ij chuwe chi nmuk na el ri nata', c'ac'ari' tek xcatintzekelbej chic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yac'a ri Jesús xubij chare ri achi ri': Xa taya' c'a ca chi ri caminaki' quemuk na cuma ri ye caminek chupan ri quimac. Yac'a riyit jet, jatzijoj achique rubanic ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y c'o chic c'a jun ri xbin chare ri Jesús: Ajaf, riyin nwajo' yatintzekelbej. Pero nabey, taya' c'a k'ij chuwe riche (rixin) chi yibech'o na ca chique ri nte' nata' y chique ri ye wach'alal, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yac'a ri Jesús xubij chare ri achi ri': Tek jun achi nisamej pa juyu' riq'ui ri arado, ma utz ta chi nitzu'un ca chrij. Queri' c'a chuka' ri winek ri niniman riche (rixin) ri Dios, ma utz ta chi nitzu'un ca chrij. Ruma wi queri' nuben, ma ruc'amon ta chi nisamej chupan ri samaj riche (rixin) ri rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y tek banatajnek chic c'a ronojel ri', ri Ajaf Jesús xerucha' c'a nic'aj chic achi'a' riche (rixin) chi yesamej riq'ui; y can ye setenta c'a achi'a' ri xerucha', riche (rixin) chi xerutek el chi ye caca'. Xerutek ri pa tak tinamit y pa tak nic'aj chic lugar ri acuchi (achique) c'o chi xtapon wi Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y ri Jesús xubij c'a chique ri achi'a' ri xerucha': Can kitzij wi chi ri samaj riche (rixin) chi nitzijox ri ruch'abel ri Dios, sibilaj nim; yec'a ri yetzijon ri ch'abel ri' xa ma ye q'uiy ta oc. Rumari' can tic'utuj c'a chare ri Rajaf ri samaj, chi querutaka' pe q'uiy samajela' chiquicojol ri winek ri rajawaxic chi niquic'axaj ri ruch'abel. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y wacami quixbiyin c'a. Y riyix iwetaman chi xa yix achi'el tak carne'l ri yixbeka chiquicojol ri winek ri ye achi'el utiwa' (coyotes). ");
INSERT INTO cakWNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y man c'a tic'uaj ta yabel irajil, ni man c'a tic'uaj ta ya'l, y man c'a tic'uaj ta chuka' jun chic c'ulaj ixajab. Ni ma quixpa'e' ta pa tak bey riche (rixin) chi ye'iyala' ca rutzil tak quiwech ri winek. Xa jic (choj) quixbiyin c'a acuchi (achique) c'o chi yixapon wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y tek yixapon c'a pa jun jay, ri nabey c'o chi niben, ya ri ye'iyala' rutzil quiwech ri winek. Y nibij c'a chique: Ya ta c'a ri uxlanibel c'u'x riche (rixin) ri Dios ri xtic'oje' iwuq'ui chupan re jay re', quixcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y wi chiri' chupan ri jay ri', c'o jun winek riq'ui quicoten xquixruc'ul, ri uxlanibel c'u'x riche (rixin) ri Dios xtic'oje' ca riq'ui. Yac'a ri winek ri xa ma xquixruc'ul ta, ri uxlanibel c'u'x ma xtic'oje' ta ca riq'ui, xa xtitzolin pe iwuq'ui riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Riyix can quixc'oje' c'a ka chupan ri jay ri yixapon wi ri jabel ic'ulic niquiben, titija' y tikumu' ri xtiquisipaj chiwe. Ruma ri samajel can ruc'amon wi chi nitoj ruma ri samaj ri nuben. Y man c'a tijalala' ta ri jay ri acuchi (achique) yixc'oje' wi. Xa can acuchi (achique) yixapon wi nabey mul, chiri' quixc'oje' wi ka. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y queri' chuka' tibana' tek yixapon xabachique tinamit y jabel ic'ulic niban. Can titija' c'a ronojel ri nisipex chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Que'ic'achojsaj c'a chuka' ri yawa'i' ri yec'o chiri', y tibij c'a chique: Xa nakaj chic c'a c'o wi ri rajawaren ri Dios iwuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yac'a tek yixapon pa jun tinamit ri xa ma utz ta ic'ulic niban, quixel c'a el ri pa tak bey riche (rixin) ri tinamit y tibij c'a chique ri winek: ");
INSERT INTO cakWNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ri pokolaj riche (rixin) re tinamit re' ri c'o el chikaken, nikatotaj (nikaquiraj) ca chiwech, riche (rixin) chi queri' tiwetamaj chi ma utz ta ri xiben chi ma xojic'ul ta. Y tiwetamaj ca chuka' chi ri rajawaren ri Dios xa nakaj chic c'o wi iwuq'ui, quixcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y ri Jesús xubij chuka' el chique: Tek xtapon ri k'ij tek ri Dios xtuk'et tzij, ri winek quiche (quixin) ri tinamit ri ma xtiquic'ul ta ri ruch'abel ri Dios ri nibij riyix chique, más c'a xtik'ax ruwi' ri ruc'ayewal ri xtika pa quiwi' riye', que chuwech ri tinamit Sodoma. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Rumari' juyi' oc iwech riyix ri yixc'o pa tinamit Corazín, y juyi' oc chuka' iwech riyix ri yixc'o pa tinamit Betsaida, ruma sibilaj q'uiy milagros xeban chiwech y ma xinimaj ta ri ruch'abel ri Dios. Ruma xa ta ya ri pa tinamit Tiro y pa tinamit Sidón ri xeban ta wi ri milagros ri', ri winek aj chiri' xtzolin yan ta pe quic'u'x riq'ui ri Dios, y quicusalon ta chic quitziak riche (rixin) bis, y quiyalon ta chic chaj chiquij, riche (rixin) chi queri' nik'alajin chi yebison ruma sibilaj q'uiy quimac ri ye quibanalon. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Yac'a tek xtapon ri k'ij tek xtik'at tzij pa ruwi' re ruwach'ulef, yix c'a riyix ri yixc'o pa Corazín y ri yixc'o pa Betsaida ri más xtik'ax ruwi' ri ruc'ayewal ri xtika pan iwi', que chiquiwech ri aj Tiro y ri aj Sidón. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y riyix ri yixc'o pa tinamit Capernaum can nich'ob chi yixbe chila' chicaj riq'ui ri Dios y xtinimirisex ik'ij. Pero xa ma que ta ri'. Xa xtikasex ik'ij, ruma xa c'a chupan ri lugar riche (rixin) ri tijoj pokonal xquixbeka wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y achique c'a winek ri xquixruc'ul jabel riche (rixin) chi nrac'axaj ri ruch'abel ri Dios, can yin c'a chuka' riyin ri yiruc'ul. Y achique c'a chuka' ri xquixetzelan ruma ri ruch'abel ri Dios, can yin c'a chuka' riyin ri yiretzelaj. Y ri netzelan wuche (wixin) riyin, can ya chuka' ri Dios ri yin takayon pe ri nretzelaj, xcha' c'a el ri Jesús chique ri setenta achi'a' ri xerucha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y tek xetzolin c'a pe ri setenta achi'a' ri' chare ri samaj ri bin el chique y xe'oka riq'ui ri Jesús, sibilaj yequicot, y xquibij c'a chare: Ajaf, ri itzel tak espíritu can xeniman chuka' chake tek pan abi' riyit xojch'o wi chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xubij chique: Ja' (je), can kitzij wi ri nibij. Ruma riyin can xintz'et chi ri Satanás xuna' yan chi xch'acatej, ruma can achi'el nuben ri k'ak' riche (rixin) ri coklajay chicaj, queri' xuben riya' tek xtzak pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Riyin can nya'on k'atbel tzij chiwe riche (rixin) chi ye'ipalbej cumatz y alacrán (k'asna'j) y riche (rixin) chuka' chi yixch'acon chrij ri ruchuk'a' ri itzel winek, y majun achique ta ri xtic'ulwachij. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Yac'a riyix ma quixquicot ta xaxu (xaxe wi) ruma chi ri itzel tak espíritu yixquinimaj. Más quixquicot pa tak iwánima ruma can tz'ibatal ri ibi' chila' chicaj riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y can yac'a hora ri', ri Jesús xquicot ránima ruma ri Lok'olaj Espíritu. Y xubij: Nya' ak'ij Nata' Dios, riyit ri can yit Rajaf ri caj y re ruwach'ulef, ruma ma xak'alajsaj ta ri lok'olaj ach'abel chiquiwech ri winek ri can niquina' chi sibilaj q'uiy quina'oj y q'uiy quetaman. Y xa chiquiwech ri winek ri ma q'uiy ta quetaman ri xa ye achi'el tak ac'ala', xa chiquiwech riye' xak'alajsaj wi re lok'olaj ach'abel re'. Can que wi c'a ri' Nata' Dios, ruma chi queri' ri araybel riyit, xcha' ri Jesús pa ru'oración. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y c'ac'ari' tek Riya' xubij: Ri Nata' Dios can ronojel cosas rujachon pa nuk'a'. Y majun chic c'a etamayon ta yin achique riyin, xaxu (xaxe) wi ri Nata' ri etamayon. Y majun chuka' etamayon ta achique ri' ri Nata', xaxu (xaxe) wi riyin ri Ruc'ajol ri etamayon, y ri winek ri achoj chare xtinwajo' xtink'alajsaj wi riyin, xtretamaj achique c'a ri' ri Nata'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yac'ari' tek ri Jesús xerutzu' ri rudiscípulos y xaxu (xaxe wi) chique riye' xubij wi: Jabel ruwa'ik'ij riyix, ruma re yixtajin chutz'etic riq'ui ri runak' tak iwech. Y chuka' can jabel ruwaquik'ij ri nic'aj chic winek ri yetz'eto ronojel re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Y can nbij c'a chiwe, chi ye q'uiy chique ri profetas ri xek'alajsan ri ruch'abel ri Dios y ri reyes ri xec'oje' ojer ca, sibilaj xcajo' chi xquitz'et ta ri nitz'et riyix wacami, y xa ma xquitz'et ta el. Can sibilaj chuka' xcajo' chi xquic'axaj ta ri niwac'axaj riyix re wacami, y xa ma xquic'axaj ta el, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y c'o c'a jun achi ri nik'axan ri nubij ri ley chiquiwech ri winek ri xbeyacatej pe y xbech'o riq'ui ri Jesús, y ruma chi nrajo' nutojtobej ri Jesús, xubij c'a chare: Tijonel, ¿achique ri rajawaxic chi nben riyin riche (rixin) chi ntoc ta wuche (wixin) ri c'aslen riche (rixin) xtibe k'ij xtibe sek? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xubij chare: ¿Achique c'a ri nubij chupan ri ley ri xuya' ri Dios chare ri Moisés? ¿Y achique nik'ax chawech riyit? ");
INSERT INTO cakWNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y ri achi ri nik'axan ri nubij ri ley xubij chare ri Jesús: Ri ley nubij chi tawajo' ri Dios ri Awajaf. Tawajo' riq'ui ronojel awánima. Tawajo' chupan ronojel ri ac'aslen, riq'ui ronojel awuchuk'a', y riq'ui chuka' ri anojibal. Y can achi'el nawajo' ka awi' riyit, can queri' chuka' que'awajo' ri awuc' awach'alal. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y yac'ari' tek ri Jesús xubij chare ri achi ri nik'axan ri nubij ri ley: Can kitzij wi ri xabij. Wacami c'a, wi xtaben ronojel re', xtoc c'a awuche (awixin) ri c'aslen riche (rixin) xtibe k'ij xtibe sek, xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Yac'a ri achi ri' ri nik'axan ri nubij ri ley can xrajo' chi nitz'etetej chi achi'el xa majun rumac. Rumari' xuc'utuj c'a chare ri Jesús: ¿Achique c'a ri' ri wuc' wach'alal ri ruc'amon chi yenwajo' ri achi'el nwajo' ka wi' riyin? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y ri Jesús can yac'ari' xutzijoj jun c'ambel tzij chare ri achi ri nik'axan ri nubij ri ley: C'o c'a jun achi ri elenak pe ri pa tinamit Jerusalem y xulan ka riche (rixin) chi nibe ka c'a pa tinamit Jericó. Pero ri achi ri' xebe'el pe alek'oma' chrij pa bey, y ri alek'oma' ri' ronojel xquelesaj el chare. Hasta ri rutziak ri rucusan ri achi xquelesaj el chrij. Y sibilaj xquisoc ca ruma sibilaj xquich'ey ca. Ri achi ri' xpune' c'a ca ri chiri' pa bey y xa juba' ma nicom. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y c'o c'a jun sacerdote ri petenak chuka' chupan ri bey ri'. Y tek ri sacerdote ri' xutz'et chi punul ri achi ri chiri' pa bey, xu (xe wi) xutzu' ca y xa choj xk'ax el. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y queri' chuka' jun achi levita, ri yeto'o quiche (quixin) ri sacerdotes ri pa rachoch ri Dios, petenak chuka' chupan ri bey ri'. Y tek ri levita ri' xapon chupan ri lugar ri', xutz'et chuka' chi ri achi punul pa bey, y can achi'el xuben ri sacerdote can queri' chuka' xuben riya'. Xu (xe wi) xutzu' ca, y xa choj xk'ax el. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o c'a jun achi aj Samaria ri petenak chuka' chupan ri bey ri', y c'o c'a chi nik'ax riq'ui ri achi punul ca pa bey, ri achi ri ch'ayon ca cuma alek'oma'. Y tek ri aj Samaria xutz'et ri achi punul pa bey, sibilaj c'a xujoyowaj ruwech ruma ri ruc'ulwachin ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Rumari' ri aj Samaria ri' xjel apo riq'ui ri achi punul pa bey, xutz'et achique rubanon. Y xerak'omala' ruwech ri rusocotajic ri achi riq'ui aceite olivo y riq'ui vino, xerupisla' c'a chuka' ri socotajic riq'ui tziek. Y c'o ruquiej ruc'amom pe ri achi aj Samaria, chrij ri' xuya' wi el ri achi socotajnek y xuc'uaj c'a pa jun posada. Y xuchajij c'a ri jun ak'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pa ruca'n k'ij tek ri aj Samaria nuchop yan chic el ri rubey, riya' xrelesaj ca'i' puek ri nibix denario chare y xuya' ca chare ri rajaf ri posada, y xubij chare: Tawilij y tawak'omaj re jun achi re'. Y tek xquitzolin pe, xtintoj c'a chawe ri nic'aj chic ri xtasech chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Rumac'ari', chawech riyit, ¿achique c'a chique ri ye oxi' achi'a' ri can achi'el nrajo' ka ri' riya', can queri' chuka' xrajo' ri achi ri xka pa quik'a' alek'oma'? xcha' ri Jesús chare ri achi ri nik'axan ri nubij ri ley. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y ri achi ri nik'axan ri nubij ri ley xubij: Ya ri achi ri xjoyowan ruwech, xcha'. Y ri Jesús xubij c'a chare ri achi ri nik'axan ri nubij ri ley: Wacami cabiyin c'a y tabana' achi'el xuben ri achi aj Samaria, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y ri Jesús xuchop chic c'a rubey y xapon pa jun aldea. Y chiri' chupan ri aldea ri' c'o c'a jun ixok ri Marta rubi', y riya' xuc'ul apo ri Jesús pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri ixok c'a ri' c'o c'a jun rach'alal María rubi'. Y ri María ri' xtz'uye' c'a chraken ka ri Jesús, riche (rixin) chi queri' nrac'axaj ri ruch'abel ri Dios ri nutzijoj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Yac'a ri Marta xa ma que ta ri' xuben. Riya' xa ch'ujernek c'a chubanic ri rusamaj. Rumac'ari' ri Marta xapon riq'ui ri Jesús y xubij chare: Ajaf, ¿chak utz chawe chi ri María nuyon riyin yin ruya'on ca chuwech re samaj? Tabij c'a juba' chare chi quiruto', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ri Ajaf Jesús xubij chare: Marta, Marta, riyit q'uiy ri nach'ob, y sachnek ac'u'x ruma q'uiy ri c'o chi naben. ");
INSERT INTO cakWNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xaxu (xaxe wi) c'a jun ri más rajawaxic y más utz, y yac'ari' ri xucha' ri María. Y ri xucha' riya', majun xtelesan ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Y jun bey c'a, ri Jesús c'o pa jun lugar, y nuben c'a orar. Y tek tanel chic ka, jun c'a chique ri rudiscípulos xubij chare: Ajaf, kojatijoj riche (rixin) chi nikaben orar, achi'el ri Juan ri Bautista xerutijoj ri rudiscípulos riche (rixin) chi niquiben orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y can yac'ari' tek ri Jesús xubij chique ri rudiscípulos: Tek xtiben c'a orar, tibana' c'a jun oración achi'el re': Katata' Dios yitc'o chila' chicaj, xtibanatej ta c'a chi quinojel ta ri winek niquiya' ta ak'ij, y man ta xtiquixolk'otij ri lok'olaj abi'. Y xtipe yan ta c'a ri awajawaren. Y can ya ta c'a ri nawajo' riyit ri xtibanatej wawe' chuwech re ruwach'ulef, achi'el nibanatej chila' chicaj awuq'ui riyit. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y taya' c'a chuka' ri kaway ri nic'atzin chake ronojel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y xtacuy ta c'a ronojel ri kamac ri yekaben chawech, can achi'el yekacuy ri winek ri c'o pokon niquiben chake. Y man c'a taya' ta k'ij chi ri itzel nuben ta chake chi yojtzak pa mac. Xa can kojacolo' c'a chuwech, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y ri Jesús xubij c'a chuka' chique ri rudiscípulos: Wi jun chiwe riyix napon pa nic'aj ak'a' riq'ui jun ramigo ri can retaman ruwech jabel, y nubij ta c'a chare: Tabana' jun utzil naya' ta oxi' caxlan wey chuwe, y xa c'a xtinya' na ruq'uexel chawe. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ruma c'o jun wamigo ri juc'an chic petenak wi y xoka wuq'ui, y riyin majun c'o wuq'ui riche (rixin) chi nya' apo chare riche (rixin) chi nutij. Rumac'ari' tabana' jun utzil chuwe, xcacha' apo chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y ri winek ri achoj chare nac'utuj wi apo, can c'a pa ruwarabel c'a xtich'o wi pe chawe y xtubij c'a: Tabana' jun utzil ma yinanek ta, ruma chi ri ruchi' jay xa xintz'apij yan ca y ri ac'ala' xa wuq'ui riyin ye warnek wi. Rumari' ma utz ta yiyacatej el riche (rixin) chi nbenya' ca chawe ri nawajo'. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y ri Jesús xubij c'a chique ri rudiscípulos: Can kitzij wi nbij chiwe, chi ri winek ri achoj chare nic'utux wi apo, xtibeyacatej pe, pero ma ruma ta chi can ya ri ramigo ri nic'utun apo chare. Ma que ta ri', xa ruma chi ma nitane' ta chuc'utuxic, rumari' xtibeyacatej pe y nberuya' pe ronojel ri nic'atzin chare, riche (rixin) chi titane' apo chuc'utuxic. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y riyin nbij c'a chiwe riyix, can tic'utuj c'a ri nic'atzin chiwe y ri Dios can xtuya' wi pe chiwe. Ticanoj ri niwajo' y xtiwil. Quixsiq'uin (quixoyon) apo chuchi' jay y xtojak chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ruma wi riyix can riq'ui ronojel iwánima nic'utuj chare ri Dios, Riya' can xtuya' wi pe chiwe. Wi riyix can nicanoj, can xtiwil wi. Y wi riyix yixsiq'uin (yixoyon) apo chuchi' jay, can xtojak wi c'a chiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿La c'o ta cami jun tata'aj ri nuya' jun abej pa ruk'a' ri ralc'ual, tek ri ac'al xa jun caxlan wey ri nuc'utuj chare? ¿O la nuya' ta cami jun itzel cumatz pa ruk'a', tek ri ac'al xa jun car ri nrajo'? ");
INSERT INTO cakWNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O la nuya' ta c'a jun alacrán (k'asna'j) pa ruk'a', tek ri ac'al xa jun sakmolo' ri nuc'utuj chare? ");
INSERT INTO cakWNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Riyix majun bey niben ta queri'. Y astape' ta chi ma can ta utz ri ina'oj, pero riyix ya ri utz tak cosas ri niya' chique ri iwalc'ual. C'a ta c'a ri Itata' ri c'o chila' chicaj chi man ta xtuya' pe chiwe ri nic'utuj chare. Riya' can nuya' wi c'a ri Lok'olaj Espíritu chique ri can niquic'utuj, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Y c'o c'a jun k'ij ri Jesús ntajin nrelesaj jun itzel espíritu riq'ui jun achi. Ri itzel espíritu ri' rubanon c'a mem chare ri achi. Y xbanatej c'a chi tek ri Jesús xubij c'a chare ri itzel espíritu chi tel el riq'ui ri achi ri', ri itzel espíritu can xel c'a el, y yac'ari' tek ri achi mem xch'o. Y ri winek ri xetz'eto, can xquimey c'a ri xquitz'et. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero yec'o c'a chuka' chique ri winek ri xebin: Ri Jesús c'o ri Beelzebú riq'ui; ri cajawalul ri itzel tak espíritu. Y ya ri Beelzebú ri niya'o uchuk'a' chare riche (rixin) chi queri' nicowin yerelesaj ri itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y yec'o c'a nic'aj chic winek, ri xaxu (xaxe wi) riche (rixin) chi niquitojtobej ri Jesús, xquibij c'a chare chi tubana' c'a chi c'o jun retal nibanatej chuwech ri caj. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yac'a ri Jesús retaman c'a ri niquich'obola' ri achi'a' ri', rumari' xubij chique: Wi ri winek riche (rixin) jun ruwach'ulef wi xa ma junan ta quiwech niquiben, nipe ch'a'oj chiquicojol. Y ri' ma utz ta, ruma nuben chare ri quiruwach'ulef chi ma xtiyaloj ta. Y queri' chuka' ri winek pa jun jay, wi xa ma junan ta quiwech niquiben, xa xtiquitaluj el qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y queri' c'a chuka' ri Satanás, wi xa nuben ka ch'a'oj chrij riya' mismo, y ca'i' c'a nuben, chanin nitzak y niq'uis ka ruk'ij. Rumari' xa ma kitzij ta ri nibij riyix, chi riyin xa ya ri uchuk'a' riche (rixin) ri Beelzebú ri ncusaj riche (rixin) chi yenwelesaj ri itzel tak espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ruma wi xa ya ri uchuk'a' riche (rixin) ri Beelzebú ri ncusaj riche (rixin) chi yenwelesaj ri itzel tak espíritu, ¿achique c'a nich'ob riyix chiquij ri ye tzekelbey iwuche (iwixin)? ¿La ya cami ruchuk'a' ri Beelzebú ri niquicusaj chuka' riye' riche (rixin) chi yequelesaj ri itzel tak espíritu? Ma que ta ri'. Rumari' can yec'a ri ye tzekelbey iwuche (iwixin) ri xquebin chiwe chi xa ma kitzij ta ri nibij riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Y wi ya ri Dios ri yayon pe uchuk'a' chuwe riche (rixin) chi yenwelesaj ri itzel tak espíritu, ntel chi tzij chi xoka yan ri rajawaren ri Dios iwuq'ui riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Tek c'o jun achi ri can c'o ruchuk'a', y c'o ronojel ruwech camisabel riq'ui, ri achi ri' can jabel wi nuchajij ri rachoch, y majun ri xtelesan ta chare ronojel ri cosas ri yec'o pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Yac'a tek noc'ulun chic c'a jun achi ri más k'axnek ruchuk'a' que chuwech riya', nich'acatej ruma ri achi ri' y nelesex chare ronojel ri camisabel ri nucusaj ri can rucukuban ruc'u'x riq'ui. Y ri achi ri más c'o ruchuk'a', ronojel c'a ri cosas ri xerelesaj el nujachala' chique ri rachibil. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y rumac'ari', achique c'a ri ma ruya'on ta ránima wuq'ui, xa can yiretzelaj wi c'a ri'. Y achique ri ma nito'o ta wuche (wixin), xa yari' ri niyojo ronojel ri yenben riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Y tek jun itzel espíritu ntel el pa ránima jun winek, nucanoj uxlanen pa chaki'j tak lugar. Y tek nuna' chi majun uxlanen nril, nuch'ob ka: Quitzolin na chic pa ránima ri winek ri acuchi (achique) xinel wi pe, nicha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y tek ri itzel espíritu ri' nitzolin chic apo pa ránima ri winek, nril c'a ri ránima ri winek ri' achi'el jun jay ri majun c'o ta chupan, meson y wikon jabel. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y c'ac'ari' tek ri itzel espíritu ri' yeberuc'ama' pe ye wuku' chic itzel tak espíritu ri más chi na ye itzel, y quinojel c'a ri' ye'oc pa ránima ri winek. Y ri winek achoj riq'ui yec'oje' wi ri itzel tak espíritu ri', más lawalo' nuben ri ruc'aslen que chuwech ri rubanon pa nabey mul. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y tek ri Jesús ntajin c'a chubixic re tzij re' chiquiwech ri sibilaj ye q'uiy winek ri quimolon qui' riq'ui, yac'ari' tek c'o c'a jun ixok chiri' chiquicojol xurek pe ruchi', y xubij c'a: Jabel ruwaruk'ij ri te'ej ri xalan awuche (awixin) chuwech re ruwach'ulef y xaq'uiytisan riq'ui tz'umaj, xcha' ri ixok chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yac'a ri Jesús xubij: Más jabel ruwaquik'ij ri ye'ac'axan y niquiben ronojel ri nubij ri ruch'abel ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y tek can ye sibilaj q'uiy c'a ri winek ri yetajin niquimol apo qui' chrij ri Jesús, xpe Riya' xubij c'a chique ri winek ri': Ri winek ri yec'o re tiempo re' sibilaj ye itzel y ma niquinimaj ta ri nbij chique. Rumari' tek nicajo' chi riyin nben jun milagro chiquiwech riche (rixin) chi yinquinimaj. Pero ma ya ta c'a ri nicajo' riye' ri xtibanatej. Xa can xu (xe) wi c'a ri xbanatej riq'ui ri profeta Jonás, ri jun achi ri xk'alajsan ri ruch'abel ri Dios ojer ca, xaxu (xaxe wi) c'a ri' ri retal ri xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri xuc'ulwachij ri Jonás xuc'ut chiquiwech ri winek ri xec'oje' ojer ca chupan ri tinamit Nínive, chi can ya ri Dios takayon pe riche (rixin). Y queri' chuka' riyin ri C'ajolaxel ri xinalex chicojol, ri xtinc'ulwachij riyin xtucusex riche (rixin) jun retal chiquiwech ri winek ri yec'o wacami. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y tek xtapon c'a ri k'ij riche (rixin) chi xtik'at tzij pa quiwi' ri winek ri yec'o re tiempo re', xtic'astej c'a pe ri jun reina ri xc'oje' ojer ca, ri xk'ato tzij pa ruwi' ri ruwach'ulef ri c'o pa sur y xtubij c'a chi ma utz ta xquiben ri winek ri yec'o re tiempo re'. Ruma tek xc'ase' ri jun reina ri', sibilaj nej xbiyin wi riche (rixin) chi xorac'axaj ri runa'oj ri jun rey riche (rixin) re Israel, ri xubini'aj Salomón. Y wacami yinc'o riyin ri más nim nuk'ij que chuwech ri rey Salomón ri xc'oje' ojer ca, y xa ma yinquinimaj ta ri winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y tek xtapon c'a ri k'ij riche (rixin) chi xtik'at tzij pa quiwi' ri winek ri yec'o re tiempo re', xquec'astej c'a pe ri winek aj Nínive y xtiquibij c'a chi ma utz ta xquiben ri winek ri yec'o re tiempo re'. Ruma ri winek ri xec'oje' pa tinamit Nínive ri ojer ca, can xu (xe) wi c'a xquic'axaj ri ruch'abel ri Dios ri xutzijoj ri Jonás chique, can yac'ari' tek xtzolin pe quic'u'x riq'ui ri Dios. Y wacami yinc'o riyin ri más nim nuk'ij que chuwech ri Jonás, y xa ma yinquinimaj ta ri winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Y majun winek ri nutzij ta jun k'ak' y c'ac'ari' nuya' ta acuchi (achique) ri ma nik'alajin ta pe, o nuya' ta chuxe' jun almul. Ri winek ri nutzij jun k'ak', can c'o ruc'ojlibel ri acuchi (achique) nuya' wi riche (rixin) chi queri' niquitz'et quibey ri ye'oc apo pa jay. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Y ri runak' tak awech can yec'atzin c'a chawe, achi'el nic'atzin jun k'ak' riche (rixin) sakil. Ruma chi ri runak' tak awech wi ye utz, riyit yitc'o pa jun sakil. Yac'a wi ri runak' tak awech ma ye utz ta, riyit yitc'o pa jun k'eku'm. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Rumac'ari' tachajij ri ac'aslen, riche (rixin) chi queri' ri sakil ri ruya'on ri Dios pan awánima ma tijalatej ta, riche (rixin) chi man xa tibec'ulun pe chi xa pa k'eku'm chic yitc'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ruma wi can yitc'o pa jun sakil, y wi can majun c'a retal ri k'eku'm awuq'ui, can yacowin wi c'a yatzu'un jabel achi'el tek tzijon jun k'ak' riche (rixin) sakil. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y tek ri Jesús xtane' c'a ka riche (rixin) chi nitzijon chiquiwech ri winek, c'o c'a jun chique ri achi'a' fariseos xubij chare ri Jesús chi tubana' jun utzil nibe ta juba' ri pa rachoch, riche (rixin) chi nutij jun ruway. Y ri Jesús can xbe na wi. Riya' xapon, y xbetz'uye' ri pa mesa. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y ri achi fariseo, can achique na xuna' tek xutz'et chi ri Jesús xtz'uye' apo pa mesa y ma xuch'ej ta ruk'a' achi'el rubanic ri niquiben riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Y ri Ajaf Jesús xutz'et ri nuch'ob ri fariseo ri xsiq'uin (xoyon) riche (rixin), y rumari' xubij chare: Riyix fariseos xa yix achi'el lek ri jabel ch'ajch'oj rij y ri rupan xa tz'il. Riyix can nic'ut c'a chiquiwech ri winek chi utz ri ye'ibanala', yac'a ri pa tak iwánima xa ma que ta ri', ruma xa nojnek riq'ui alek', y nojnek riq'ui etzelal. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Riyix xa yix nacanek. ¿Can ma iwetaman ta c'a chi ri xbano re kach'acul, xuben chuka' ri kánima? ");
INSERT INTO cakWNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Rumari' ri rajawaxic chi niben riche (rixin) chi nik'alajin chi wi kitzij chi ch'ajch'oj ri iwánima, ya ri ticusaj ri c'o iwuq'ui riche (rixin) chi ye'ito' ri winek ri nic'atzin quito'ic. Y wi queri' niben, can xtik'alajin c'a chi yix ch'ajch'oj. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Juyi' oc iwech riyix fariseos! Tek riyix niya' ri idiezmo can niya' wi ri k'ayis ri jubul ruxla' ri menta rubi', ri róra (ruda) y nic'aj quiwech ichaj. Pero yac'a ri ruchojmilal ri c'aslen, xa ma niben ta y ma niwajo' ta ri Dios. Y ya ta c'a ri' ri rajawaxic chi niben, y rajawaxic chuka' chi ma niya' ta ca ruya'ic ri idiezmo. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Juyi' oc iwech riyix fariseos! ruma can ya oc ri nabey tak ch'aquet ye'icanola' ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, riche (rixin) chi queri' nibix chi riyix can c'o ik'ij. Y can más chuka' nika chiwech ri niya'ox (nya') ca rutzil tak iwech ri pa tak c'aybel. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Juyi' oc iwech riyix aj tz'iba' y chuka' riyix fariseos ri xa ca'i' ipalej! ruma xa yix achi'el ri ulef ri c'o pa quiwi' ri caminaki'. Tek ri ulef ri' xa xq'uis yan ka y xa ma can ta nik'alajin chic, ri winek choj chic yek'ax el pa ruwi'. Can man c'a quetaman ta chi xa pa ruwi' jun caminek yek'ax wi el, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun c'a chique ri achi'a' ri nik'axan ri nubij ri ley xubij chare ri Jesús: Tijonel, tek riyit nabij queri', ma xu (xe) ta wi chique ri fariseos nabij wi, xa can chake chuka' riyoj nabij wi, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y ri Jesús xubij c'a chare ri achi ri nik'axan ri nubij ri ley: ¡Juyi' oc chuka' iwech riyix! ruma nima'k tak ejka'n niyala' chiquikul ri winek ri can c'ayef (cuesta) quic'uaxic. Ri ejka'n ri' xaxu (xaxe) wi c'a chiquikul ri winek niya' wi, y riyix ni xa ta jun ti ruwi' ik'a' nisiloj riche (rixin) chi nic'uaj ta ri ejka'n ri nibij ri c'o chi niquic'uaj ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Juyi' oc iwech riyix ri yixk'axan ri nubij ri ley! ruma riyix nibanala' ruchojmil ri panteón ri acuchi (achique) ye mukun wi ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, y riye' xa ye ri iwati't imama' ri xecamisan quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Wacami nik'alajin c'a chi riyix can nika chiwech ri itzel ri xequibanala' ri iwati't imama' ojer, ruma ye riye' ri xecamisan ri ruprofetas ri Dios, y riyix nibanala' ruchojmil ri quipanteón ri profetas ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y rumac'ari' ri Dios, ri can retaman ronojel, xubij: Xquentek c'a profetas ri xquek'alajsan ri nuch'abel, y xquentek chuka' apóstoles chiquicojol. Pero yec'o c'a ri xquentek ri xquecamisex, y yec'o ri xtiban chique chi niquik'axaj tijoj pokonal pa quik'a' ri winek, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Rumari', xubij ri Jesús, pa quiwi' c'a re winek ri yec'o re tiempo re', pa quiwi' c'a riye' xtuya' wi ri Dios rutojbalil ri quicamic quinojel ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, quinojel ri ye camisan ri winakirsan wi pe re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Xuchop pe riq'ui tek xcamisex ri Abel y nbeq'uis c'a riq'ui tek xcamisex ri profeta Zacarías, ri xcamisex chunakajal ri altar ri c'o chuwarachoch ri Dios. Rumac'ari' nbij chiwe chi pa quiwi' re winek ri yec'o re tiempo re' xtuya' wi ri Dios rutojbalil ri quicamic quinojel ri profetas. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Juyi' oc iwech riyix ri yixk'axan ri nubij ri ley! ruma chi riyix iwetaman achique rubaniquil riche (rixin) chi jun winek ntoc riche (rixin) ri Dios, yac'a riyix ma yix oconek ta riche (rixin) ri Dios y chuka' ye ik'aton ri winek ri nicajo' ye'oc riche (rixin) ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Tek ri Jesús xubij ronojel re', ri aj tz'iba' y ri fariseos sibilaj xpe coyowal. Y rumac'ari' riye' ronojel c'a niquic'utuj apo chare ri Jesús xaxu (xaxe) wi riche (rixin) chi niquinek. ");
INSERT INTO cakWNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ri aj tz'iba' y ri fariseos, can ma niquiya' ta ca juba' ri Jesús, c'o ta nicajo' riye' chi niquic'axaj chi Riya' c'o ta jun ch'abel ri ma ruc'amon ta ri nubij y nika ta pa quik'a', riche (rixin) chi niquitzujuj (niquisujuj). Yac'a ri Jesús can ruyon c'a pa ruchojmil ri yerubij. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y ri winek xemolotej c'a apo. Pa mil winek ri xquimol apo qui'. Rumari' niquipalbej chic qui'. Y ri Jesús xuchop c'a tzij quiq'ui ri ye rudiscípulos nabey, y xubij c'a chique: Tichajij iwi' chuwech ri ch'om (levadura) quiche (quixin) ri achi'a' fariseos. Ri ch'om (levadura) quiche (quixin) ri achi'a' fariseos ntel chi tzij chi xa ca'i' quipalej, xa ma niquiben ta ri niquic'ut. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Y ronojel ri ma k'alajsan ta, xtik'alajin pe. Y ronojel ri tz'apel ca rij, xtel c'a pe chuwasakil. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rumac'ari' riyix, ronojel ri tzij ri nitzijoj pa k'eku'm, ronojel ri' xtel rutzijoxic pa sakil. Y ronojel c'a ch'abel ri pan ekal ibin pa tak ixquin ri pa tak jay, xtetamex na cuma ri winek y xtiquirek quichi' chubixic c'a pa ruwi' tak jay. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y riyix ri can yix wamigo nbij c'a chiwe: Ma tixibij ta iwi' chiquiwech ri xaxu (xaxe wi) ri ch'aculaj ri yecowin niquicamisaj, y tek quicamisan chic ri ch'aculaj majun chic achique ta ri xquecowin xtiquiben. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Y nbij c'a chiwe achoj chuwech ri ruc'amon chi nixibij wi iwi': Tixibij iwi' chuwech ri jun ri can nicowin nucamisaj ri ch'aculaj y nicowin yixrutek pa k'ak'. Can chuwech c'a ri' tixibij wi iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Y riyix chuka' jabel iwetaman chi tek ye'ic'ayij wu'o' aj xic' tak chicop, xaxu (xaxe) wi ca'i' oxi' oc tak centavos cajel. Y ma riq'ui ta chi ri aj xic' tak chicop ri' xa ma q'uiy ta oc cajel, ri Dios majun bey yerumestaj ta ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y c'a ta c'a riyix. Ruma riyix hasta ri rusmal tak iwi' ajlan ronojel. Ri Dios can sibilaj yixrajo'. Riyix más c'o iwejkalen que chiquiwech ye q'uiy aj xic' tak chicop. Rumac'ari' ma tixibij ta iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chuka' nbij c'a chiwe, chi xabachique winek ri nuk'alajsaj ri' chi yin runiman riyin, queri' chuka' riyin ri C'ajolaxel ri xinalex chicojol, xtink'alajsaj chiquiwech ri ru'ángeles ri Dios chi ri winek ri' wuche (wixin) chic riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yac'a jun winek ri ma nuk'alajsaj ta ri' chiquiwech ri winek chi yin runiman riyin, queri' chuka' xtinben riyin, man c'a xtink'alajsaj ta chiquiwech ri ru'ángeles ri Dios, ruma ri winek ri' xa ma wuche (wixin) ta riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y xabachique c'a winek ri niyok'on chuwij riyin ri C'ajolaxel ri xinalex chicojol, c'a nicuyutej na rumac. Yac'a ri niyok'on chrij ri Lok'olaj Espíritu, man c'a xticuyutej ta rumac. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Y tek yixuc'uex c'a chiquiwech ri principali' pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, y tek yixuc'uex chuka' chiquiwech ri aj k'atbel tak tzij, ma tich'ujirisaj ta iwi' chuch'obic achique chi ch'abel ri xtibij tek yixch'o chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ruma tek c'o chi yixch'o apo, can ya ri Lok'olaj Espíritu ri xtiya'o ri ch'abel chiwe ri rajawaxic chi xtibij apo, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chiri' chiquicojol ri sibilaj ye q'uiy winek ri quimolon apo qui', c'o c'a jun ri xch'o apo y xubij chare ri Jesús: Tijonel, tabana' jun utzil cach'o riq'ui ri wach'alal y tabij chare chi tuya' pe ri werencia ri rubanon ka riche (rixin) chare, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yac'a ri Jesús xubij chare ri achi: Riyin ma banon ta pe chuwe chi yin jun aj k'atbel tzij pan iwi' riyix y chuka' ma yin ta jun jachoy herencia chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y ri Jesús xch'o chic c'a chique ri winek y xubij: Can titzu' c'a ka iwi' jabel riche (rixin) chi nichajij ri ic'aslen, riche (rixin) chi ma tipe ta raynic pa tak iwánima chrij ronojel ruwech cosas. Ruma astape' jun winek sibilaj q'uiy rubeyomal c'o, ma ya ta ri' ri xtiya'o ri ruc'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y can yac'ari' tek ri Jesús xuchop rubixic jun c'ambel tzij, y xubij: C'o c'a jun achi beyon, ri sibilaj ulef c'o riq'ui. Y jun bey c'a, q'uiy cosecha ri xumol. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rumac'ari' ri beyon ri' xuch'ob ka pa ránima: ¿Achique ta jun nben riche (rixin) chi queri' nyec ronojel ri nucosecha? Ruma majun chic nya' wi re nic'aj chic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y tek xch'obotej chuwech, xubij: Más utz quenwulaj na el re cocoj tak nuc'ujay, y yenben chic nic'aj más ye nima'k. Y chupan ri nuc'ujay ri' xquenyacala' wi ri c'o wuq'ui y ronojel ri nucosecha. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y xtinbij c'a chare ri wánima: Wánima, wacami sibilaj q'uiy abeyomal ri ayacon, y q'uiy juna' ma xtatij ta wayjal. Caquicot c'a, catuxlan, cawa' y catuc'ya', xcha' ri beyon chare ri ránima. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios xubij chare ri beyon ri': Nacanic chi achi, chupan re ak'a' re' xtinsiq'uij (xtinwoyoj) el ri awánima, y ronojel ri abeyomal ri ayacon, ¿achoj riche (rixin) cami xtoc wi ca? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quec'ari' ri winek ri nimolo beyomel riche (rixin) re ruwach'ulef, y xa man c'o ta ri beyomel riche (rixin) ri Dios riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y ri Jesús xubij c'a chique ri rudiscípulos: Nbij c'a chiwe, chi ma tich'ujirisaj ta iwi' chupan ri ic'aslen, chi acuchi (achique) xtipe wi ri iway y chi acuchi (achique) xtipe wi ri itziak. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ruma chi ri kitzij c'aslen, más rejkalen que chuwech ri iway iwuc'ya' y ri ich'acul chuka' can más rejkalen que chuwech ri itziak. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Que'itz'eta' na pe' ri ko'ch. Ri aj xic' tak chicop ri' majun quitico'n niquiben ta, y majun cosecha niquelesaj, ni majun riche (rixin) quiwaybal quiyacon, majun chuka' quic'ujay. Pero ma riq'ui wi ri', riye' yewa', ruma chi ri Dios can nuya' wi quiway. ¿C'a ta c'a riyix man ta xtuya' iway ri Dios? tek riyix más iwejkalen que chiquiwech ri aj xic' tak chicop. Rumac'ari' ma más ta c'a tich'ob ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿La c'o ta cami c'a jun chiwe riyix ri nicowin chi niq'uiy chic nic'aj vara ri rupalen, ruma can nuch'ujirisaj ri'? Majun. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y wi xa jun samaj ri xa ti co'ol oc achi'el ri' ma yixcowin ta niben, ¿achique c'a ruma tek can nich'ujirisaj iwi' riche (rixin) chi niwil nic'aj chic chique ri yec'atzin chiwe? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Que'itzu' na pe' ri cotz'i'j ri lirio quibi'. Que'itzu' na pe' tek yeq'uiy. Riye' ma yesamej ta, ni ma yebatz'in ta, riye' majun quitziak niquiben, pero ma riq'ui wi ri' jabel oc yetzu'un. Y c'o c'a jun rey riche (rixin) re ruwach'ulef Israel ri xc'oje' ojer ca, ri xubini'aj Salomón. Riya' ruyon jabel tak tziek ri xerucusaj, pero majun bey xucusaj ta jun rutziak ri can achi'el jun cotz'i'j. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Y wi ri Dios queri' yeruwik ri k'ayis, ri wacami c'o pa juyu' y chua'k xa niya' pa k'ak', ¿c'a ta c'a riyix winek chi man ta xtuya' itziak ri Dios? Rumari', ¿achique c'a ruma tek xa ma nicukuba' ta ic'u'x riq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Rumari' riyix ma tich'ujirisaj ta iwi' chupan ri ic'aslen chi acuchi (achique) nipe wi ri iway iwuc'ya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ruma chi quinojel ri winek queri' niquiben. Yac'a riyix c'o jun Itata' ri can retaman chi ronojel ri' nic'atzin chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Rumari' ri más rajawaxic chi niben riyix ya ri ticanoj ri rajawaren ri Dios. Y wi queri' xtiben, ri Dios can xtuya' c'a pe ronojel ri nic'atzin chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ma tixibij ta iwi' riyix ri yixtzekelben wuche (wixin), ruma astape' xa yix juba' oc, ri Tata'ixel can nrajo' wi c'a chi yixbec'oje' pa rajawaren. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayila' c'a ri c'o iwuq'ui y tiyala' chique ri winek ri nic'atzin quito'ic. Wi queri' niben, xtic'oje' jun iyaconobal chila' chicaj ri majun bey xtijar ta, y xtic'oje' ibeyomal chupan, beyomel ri majun bey xtiq'uis ta, ni majun alek'om xtelek'an ta, ni ma nichicopir ta chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ruma chi acuchi (achique) c'o wi ri ibeyomal, chiri' chuka' nic'oje' wi ri iwánima. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tichajij c'a ri ic'aslen, y can ma tichuptej ta ri icantil. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' c'a achi'el niquiben ri mozos pa jun jay. Ri mozos coyoben ajan (jampe') nitzolin pe ri quipatrón ri benak pa jun c'ulanen, riche (rixin) chi queri' tek noka y nisiq'uin (noyon) apo, can yac'ari' niquijek pe ruchi' ri jay chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Y can jabel c'a ruwaquik'ij ri mozos ri ye q'ues tek noka ri quipatrón. Y kas kitzij nbij chiwe, chi ri quipatrón xtuchojmirisaj c'a ri' y yerutz'uyuba' c'a ri rumozos pa mesa. Y yerunimaj yerilij apo jabel ruma sibilaj niquicot chi c'a coyoben na apo ri hora ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y wi ri quipatrón ri mozos ri' noka pa nic'aj ak'a' o ya tek xa niseker yan pe, ri mozos ri' can jabel ruwaquik'ij ruma c'a ye q'ues na chiroyobexic ri quipatrón ri hora ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y riyix iwetaman, chi xa ta ri rajaf jun jay nretamaj ajan (jampe') napon ri alek'om pa rachoch, ri rajaf ri jun jay ri' nic'ase' ta riche (rixin) chi nuchajij ri rachoch, y man ta nuya' k'ij chare ri alek'om chi nelek' el pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Rumac'ari' riyix nic'atzin chi can quiniwoyobej apo, ruma riq'ui juba' ri hora tek xa ma yin ta riyin ri yinich'ob, yari' tek xquipe riyin ri C'ajolaxel ri xinalex chicojol, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yac'ari' tek ri Pedro xubij chare ri Jesús: Ajaf, ¿tek riyit xatzijoj re c'ambel tzij re', la xaxu (xaxe) wi chake riyoj ri yoj adiscípulos, o xabij chuka' chique quinojel ri winek? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf xubij: Ri mayordomo ri choj y c'o runa'oj, yac'ari' ri nicha'ox (ncha') ca ruma ri rupatrón, riche (rixin) chi nicanaj ca pa quiwi' quinojel ri yec'o pa rachoch ri rupatrón, riche (rixin) chi nuya' quiway y ronojel ri nic'atzin chique tek napon ri hora. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Can jabel c'a ruwaruk'ij ri mozo ri', ruma ntajin chubanic ri samaj tek no'ilitej ruma ri rupatrón. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can kitzij c'a nbij chiwe chi ri patrón can xtuya' wi c'a ronojel ri rubeyomal pa ruk'a' ri mozo riche (rixin) chi nuchajij. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero ri mozo ri' wi xa nuch'ob ka pa ránima: Ri nupatrón ri' xa c'a ma jane noka ta na, nicha'; y nuchop c'a quich'ayic ri nic'aj chic mozos chi achi'a' y chi ixoki', y can xu (xe) wi wa'in y tijoj ya' nuben quiq'ui ri k'abarela', ");
INSERT INTO cakWNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ya c'a ri k'ij y ri hora tek majun nuch'ob chi noka ri rupatrón, yac'ari' tek noka. Ri rupatrón can xtuc'ajsaj wi ruwech ri mozo ri' y xtuya' quiq'ui ri nic'aj chic ri ma yeniman ta tzij. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri mozo ri retaman achique ri nrajo' ri rupatrón, pero xa ma xuchojmij ta ri' riche (rixin) chi nuben ri samaj, ni ma nuben ta ri nrajo' ri rupatrón, ri mozo c'a ri' sibilaj c'a xtich'ay. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yac'a ri mozo ri xa ma retaman ta achique ri nrajo' ri rupatrón, astape' c'o ri ma utz ta yerubanala' apo, y astape' ri mozo ri' can ruc'amon chi nich'ay ta más, pero xa ma que ta ri' xtiban chare. Riya' ma xtik'ax ta ruwi' ri ch'ayquil ri xtiban chare. Ruma ri can q'uiy c'a ya'on ca chare, chuka' can q'uiy c'a ri xtich'ojix chare, y chuka' ri can q'uiy ri jachon ca pa ruk'a', can q'uiy c'a chuka' ri xtic'utux chare, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Riyin can chuyaquic c'a k'ak' chicojol re xipe chuwech re ruwach'ulef. Y riyin nwajo' chi ri k'ak' ri' nic'at ta chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero nabey nic'atzin c'a chi nk'axaj na tijoj pokonal, y can nik'axo ri wánima ruma ri woyoben apo, y sibilaj nrayij chi k'axnek ta chic ca ri jun c'ayewalej bautismo ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Riyix nich'ob chi riyin xipe riche (rixin) chi nya' uxlanibel c'u'x chuwech re ruwach'ulef? Ma que ta ri'. Wuma riyin yec'o ri xa xtiquitaluj qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rumari' re xtibe apo, wi pa jun jay yec'o ye wu'o' winek, ye oxi' xa xqueyacatej c'a chiquij ri ye ca'i', o ya ri ye ca'i' ri xqueyacatej chiquij ri ye oxi'. Y can xtiquitaluj qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tata'aj ma xtika ta c'a chuwech ri nubij ri ruc'ajol. Ni ri c'ajolaxel ma xtika ta chuwech ri nubij ri tata'aj. Ni ri te'ej ma xtika ta chuwech ri nubij ri ruxok'al (ruxok-al) chare. Y can queri' c'a chuka' ri k'opoj ma xtika ta chuwech ri nubij ri rute' chare. Y can quec'ari' ri alite' ma xtiquic'uaj ta qui' riq'ui ri ralibatz, ruma ma junan ta niquich'ob, y can ni ta c'a ri alibetz xtiquic'uaj qui' riq'ui ri ralite'. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y ri Jesús xubij c'a chuka' chique ri winek: Riyix iwetaman achique nitzu'un ri sutz' ri nic'amo pe job. Y tek nitz'et c'a ri sutz' ri', chanin nibij chi nipe job. Y can nipe wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y tek nipe ri cak'ik' quere' pa sur, ya c'a retal ri' iya'on chi nuchop ruk'ijul ri sak'ij. Y can nuchop wi c'a ri sak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Riyix xa ca'i' c'a ipalej, ruma jabel iwetaman nitzu' achique nuben ruwech ri caj y jabel chuka' iwetaman achique ri nipe xaxu (xaxe wi) riq'ui nitzu' achique rubanon re ruwach'ulef. ¿Achique c'a ruma tek can ma niwetamaj ta chuka' achique tiempo re yojc'o wi wacami? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y achique ruma tek ma nich'obotej ta ka iwuma riyix mismo achique ri ruc'amon chi niben y achique ri ma ruc'amon ta? ");
INSERT INTO cakWNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tek c'o jun chiwe riyix ri nitzujux (nisujux) pa k'atbel tzij, tutija' ruk'ij riche (rixin) chi nuchojmirisaj ri' riq'ui ri ruc'ulel tek xa c'ac'ari' quichapon el bey pa k'atbel tzij. Ruma wi ma nuchojmirisaj ta ri' riq'ui ri nitzujun (nisujun) chrij, can xtuc'uex c'a chuwech ri aj k'atbel tzij, y ri aj k'atbel tzij ri' nujech el pa ruk'a' ri aj ch'ame'y, y ri aj ch'ame'y nuc'uaj el, y nberutz'apij ca pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y can kitzij nbij, chi ri winek ri ntoc pa cárcel ruma ruc'as, ma xtel ta pe chiri' c'a ya tek rutojon chic ca ri ruq'uisbel centavo ri nibix chare ri c'o chi nutoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y yec'a k'ij ri' tek yec'o ca'i' oxi' winek ri xe'apon riq'ui ri Jesús, y riye' xquichop c'a niquitzijoj apo chare ri Jesús ri xuben ri Pilato chique nic'aj achi'a' ri ye aj Galilea, tek ri achi'a' ri' yec'o c'a pa rachoch ri Dios, y ye quic'ualon apo chicop riche (rixin) chi yequicamisaj chi yequitzuj (yequisuj) chuwech ri Dios. Y yac'a tek yetajin chutzujic (chusujic) ri chicop chuwech ri Dios, yac'ari' tek ri aj k'atbel tzij ri Pilato rubi' xutek quicamisaxic ri achi'a' ri'. Rumari' ri quiquiq'uel c'a ri chicop y ri quiquiq'uel ri achi'a', xuxol ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yac'a ri Jesús xubij chique: ¿Riyix nich'ob chi ri achi'a' aj Galilea ri', queri' xquic'ulwachij ruma más c'o quimac que chiquiwech ri nic'aj chic aj Galilea? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ma que ta ri'. Yac'a riyix, wi ma xtitzolin ta pe ic'u'x riq'ui ri Dios, xa can xtitz'ila' chuka' iwi' chi'iwonojel riyix achi'el riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O riyix nich'ob chuka' chi ri ye wakxaklajuj ri xecom acuchi (achique) c'o wi ri atinibel ri Siloé rubi', tek xtzak ri torre chiquij, chi más c'o quimac que chiquiwech quinojel ri nic'aj chic winek ri yec'o chiri' pa tinamit Jerusalem? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ma que ta ri'. Nbij c'a chiwe: Wi riyix ma xtitzolin ta pe ic'u'x riq'ui ri Dios, xa can xtitz'ila' chuka' iwi' chi'iwonojel riyix achi'el riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ri Jesús xuchop c'a rubixic jun c'ambel tzij chiquiwech, y xubij: C'o c'a jun achi ruticon juwi' che' ri higo rubi' pa rulef, y xapon chuxe' ri che' chutz'etic wi c'o ruwech. Y ri juwi' che' ri' xa majun ti ruwech c'o ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rumari' ri rajaf ri ulef xubij chare ri achi ri samajiy rulef: Oxi' yan c'a juna' re' noncanoj ruwech re che' re', y majun bey wilon ta jun ti ruwech. Rumac'ari' más utz tachoyo' el. ¿Achique nic'atzin wi chi xaxu (xaxe wi) nuq'uis ruchuk'a' re ulef? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Yac'a ri samajiy riche (rixin) ri ulef xubij chare ri rajaf: Taya' na chic ca re juna' re'. Nc'ot na ri ulef chuxe' y nya' na abono chuxe'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Wi nuya' c'a ruwech, utz. Y wi mani, tachoyo' c'a el, xcha' ri samajiy riche (rixin) ri ulef. Queri' ri c'ambel tzij ri xutzijoj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y pa jun uxlanibel k'ij, ri Jesús yerutijoj c'a ri winek riq'ui ri ruch'abel ri Dios, pa jun jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicojol ri winek ri quimolon qui' ri chiri', c'o c'a jun ixok ri c'o chic wakxaklajuj juna' ruchapon pe yabil. Ri ixok c'a ri' luculic rij, y can ma nicowin ta nipa'e' choj. Ri ixok ri' ruc'ulwachin c'a queri' ruma jun itzel espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero tek ri Jesús xutz'et apo ri ixok ri', xusiq'uij (xroyoj) apo y xubij chare: Re wacami yac'are' xacolotej chuwech ri ayabil. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya' c'a ruk'a' pa ruwi' ri ixok. Y ri ixok can yac'ari' xchojmir, xpa'e' jabel. Y ri ixok can yac'ari' xuya' ruk'ij ruc'ojlen ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yac'a ri achi ri principal chiri' chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios, sibilaj itzel xuna' chare ri Jesús ruma xuc'achojsaj ri ixok chupan ri uxlanibel k'ij. Rumari' ri achi principal xubij chique ri winek ri quimolon qui' chiri': Ronojel semana c'o waki' k'ij riche (rixin) chi yojsamej. Y chupan c'a ri k'ij ri', quixpe riq'ui ri Jesús riche (rixin) chi yixc'achojsex, y ma ya ta chupan jun uxlanibel k'ij, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Yac'a ri Ajaf Jesús can yac'ari' tek xubij chare: Riyit xa ca'i' apalej. ¿Chi'ijujunal riyix la ma ye'iquir ta c'a el juba' ri iwáquix, ri iquiej pa jun uxlanibel k'ij, riche (rixin) chi yixbe chuya'ic quiya'? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","C'a ta c'a re jun ixok re', ri can riy rumam ca ri Abraham. Y re ixok re' c'o chic wakxaklajuj juna' kasan chi yabil ruma ri Satanás. ¿La ma ruc'amon ta cami chi nic'achojsex chupan jun uxlanibel k'ij? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tek ri Jesús rubin chic ka ri tzij ri', quinojel ri ye'etzelan riche (rixin) xeq'uix apo chuwech. Yac'a ri nic'aj chic winek sibilaj niquicot cánima, ruma ri Jesús ntajin chubanic nima'k tak samaj riche (rixin) ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y ri Jesús xubij c'a: ¿Achique rubanic xtinbij chrij ri rajawaren ri Dios? ¿Y achoj riq'ui njunumaj wi? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Riyin nbij c'a chi junan riq'ui ri ija'tz riche (rixin) ri mostaza ri nutic ka jun achi pa rulef. Tek niq'uiy, can achi'el jun ti alaj che' nuben. Rumari' ri aj xic' tak chicop ri yebe pa cak'ik', niquibanala' quisoc pa tak ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y ri Jesús xubij c'a chuka': ¿Achoj riq'ui junan wi ri rajawaren ri Dios? ");
INSERT INTO cakWNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xa can junan c'a riq'ui ri ch'om (levadura) ri nberuc'ama' pe jun ixok y nuya' ca chupan oxi' pajbel harina, y nuch'omirisaj ronojel, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y ri Jesús xuchop chic c'a el ri rubey chi nibe pa tinamit Jerusalem. Pero nabey xbek'ax na pe pa tak tinamit y pa tak aldeas riche (rixin) chi nutzijoj ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y c'o c'a jun ri xc'utun chare ri Jesús, y xubij chare: Ajaf, ¿ye q'uiy cami ri xquecolotej? Yac'a ri Jesús xa chique c'a quinojel xch'o wi, y xubij: ");
INSERT INTO cakWNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Can titija' c'a ik'ij yixoc pa ruchi' jay ri xa co'ol ruwech. Ruma sibilaj c'a ye q'uiy ri winek xticajo' xque'oc chupan ri ruchi' jay ri', pero ma xquecowin ta xque'oc. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ruma tek ri Ajaf xtiyacatej pe y xtorutz'apij ca ruchi' ri jay, riyix ri ma jane yix oconek ta apo riq'ui, xquixsiq'uin (xquixoyon) c'a apo y xtibij: Ajaf, Ajaf, tajaka' ri ruchi' jay chkawech riche (rixin) chi yoj-oc apo, xquixcha'. Pero Riya' xtubij pe chiwe: Ma wetaman ta acuchi (achique) quixpe wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y riyix xtibila' c'a apo chare: Yoj c'a riyoj ri xojwa' xojuc'ya' awuq'ui. Y ya ri pa tak c'aybel ri pa tak katinamit, chiri' xac'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Yac'a Riya' xtubij pe chiwe: Xinbij yan chiwe chi ma wetaman ta acuchi (achique) quixpe wi. Quixel el chinuwech riyix ri xa yix banoy tak etzelal, xticha' ri Ajaf. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y tek xque'itz'et ri Abraham, ri Isaac, ri Jacob y quinojel ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, chi yec'o pa rajawaren ri Dios chila' chicaj, yac'ari' tek xquixok' ruma bis, xtikach'ach'ej iwey ruma xixelesex ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y xquepe c'a winek quere' pa jotol, quere' pa xulan, quere' pa relebel k'ij y quere' pa rukajbel k'ij. Winek ri quicukuban quic'u'x wuq'ui. Y ri winek ri' xquetz'uye' c'a apo ri pa mesa chupan ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y c'o ri yec'o nabeyel ri xquecanaj c'a pa ruq'uisbel y c'o ri yec'o pa ruq'uisbel ri xquec'oje' pa nabey, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupan c'a chuka' ri k'ij ri', yec'o achi'a' fariseos ri xe'apon riq'ui ri Jesús, y xquibij chare: Ri Herodes, ri aj k'atbel tzij, nrajo' yarucamisaj. Catel c'a el wawe' chanin, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yac'a ri Jesús xubij chique ri achi'a' ri': Quixbiyin y tibij chare ri jun aj k'atbel tzij ri', ri achi'el jun itzel xwan, chi riyin c'a yenwelesaj na itzel tak espíritu y can c'a yenc'achojsaj na chuka' ri c'o quiyabil. Queri' xtinben re wacami, ri chua'k y c'a pa rox k'ij xtinq'uis ca rubanic re samaj re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Riyin xa can c'o wi chi nchop el nubey re wacami, ri chua'k y ri cabij. C'o chi pa tinamit Jerusalem xquicamisex wi, ruma chi ri profetas ri yek'alajsan ri ruch'abel ri Dios, majun bey ri xquecamisex ta pa jun chic tinamit. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y c'ac'ari' ri Jesús xubij c'a: Riyix aj Jerusalem, aj Jerusalem, ¿achique c'a ruma tek ye'icamisala' ri profetas ri yek'alajsan ri ruch'abel ri Dios? ¿Achique c'a ruma chuka' tek ye'icamisala' chi abej ri yerutek pe ri Dios chicojol? Y riyin can q'uiy c'a mul ri xinwajo' chi xixinmol ta wuq'ui, achi'el nuben ri quite' ec' chique ri tak ral, yerumol chuxe' ri ruxic'. Yac'a riyix ma xiwajo' ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wacami c'a, ri itinamit xtimalix ca ruma ri Dios, xtiban c'a ca chare achi'el jun desierto. Y kas kitzij chuka' nbij chiwe chi man c'a xquinitz'et ta chic. Xquinitz'et chic jun bey, c'a ya tek xtapon na ri k'ij tek xtibij chuwe: ¡Matiox chi petenak re jun achi re'! ¡Riya' can banon pe bendecir ruma ri Ajaf Dios! ¡Y can pa rubi' ri Ajaf Dios petenak wi! xquixcha' chuwe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y pa jun uxlanibel k'ij, ri Jesús xbe pa rachoch jun principal quiche (quixin) ri achi'a' fariseos. Ri Jesús siq'uin (oyon) c'a ruma ri achi ri' riche (rixin) jun wa'in. Y ri yec'o chiri' niquitzula' c'a apo ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Y chiri' chuwech ri Jesús c'o c'a apo jun achi ri sipojnek. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y ri Jesús xubij c'a chique ri achi'a' ri yek'axan ri nubij ri ley y chuka' chique ri achi'a' fariseos ri yec'o apo chiri': ¿La xajan cami chi nic'achojsex jun yawa' pa jun uxlanibel k'ij? ¿Achique nibij riyix? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yac'a riye' majun xquibij. Rumari' ri Jesús xuchop apo ri yawa' y xuc'achojsaj y xubij chare chi tibe el. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y c'ac'ari' tek ri Jesús xubij chique ri achi'a' ri yek'axan ri nubij ri ley y chique ri fariseos: Wi c'o jun chiwe riyix ri nitzak jun ruquiej o jun ruwáquix pa jun jul, ¿La ma nibe ta cami chanin churelesaxic, astape' pa jun uxlanibel k'ij? ");
INSERT INTO cakWNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ri achi'a' ri yek'axan ri nubij ri ley y ri fariseos ma xquil ta c'a achique xquibij apo chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y ri Jesús xuchop c'a rubixic jun c'ambel tzij chique ri winek ri ye siq'uin (oyon) chupan ri wa'in ri', ruma xerutz'et chi ri winek ri' yequichala' ri nabey tak ch'aquet riche (rixin) chi yetz'uye' chiri' pa mesa. Rumari' xubij c'a chique: ");
INSERT INTO cakWNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tek c'o c'a jun ri nisiq'uin (noyon) iwuche (iwixin) pa jun c'ulanen, man c'a quixtz'uye' ta pa tak ch'aquet ri xa quiche (quixin) ri nima'k quik'ij. Ruma chi riq'ui juba' yit tz'uyul chic ri chiri' tek napon jun winek ri más nim ruk'ij que chawech riyit, ");
INSERT INTO cakWNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nipe ri xsiq'uin (xoyon) awuche (awixin) chupan ri c'ulanen ri', y nubij chawe: Tabana' jun utzil taya' ca re ch'aquet re' chare re jun re nusiq'uin (woyon) chuka'. Y riyit xa xcaq'uix ka tek xcabetz'uye' pa ruq'uisbel tak ch'aquet. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Rumac'ari' tek c'o jun ri nisiq'uin (noyon) awuche (awixin) pa jun c'ulanen, catz'uye' ri pa ruq'uisbel tak ch'aquet riche (rixin) chi queri' tek yarutz'et pe ri xsiq'uin (xoyon) awuche (awixin), xtoka c'a awuq'ui riyit y xtubij chawe: Tabana' jun utzil cajote' pe wawe'. Y tek queri' xtiban chawe, quinojel c'a ri yetz'uye' awuq'ui ri pa mesa riche (rixin) ri wa'in, xtiquetamaj chi can c'o ak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Rumac'ari', xabachique ri nunimirisaj ri', xa xtikasex ruk'ij. Y yac'a ri nuch'utinirisaj ri', xtinimirisex ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y ri Jesús xubij c'a chuka' chare ri xsiq'uin (xoyon) riche (rixin): Tek nawajo' c'a chi c'o yepe awuq'ui riche (rixin) chi noquibana' jun wa'in, ma xaxu (xaxe) ta wi ri awachibil, ri ate' atata', ri ye awach'alal, y ri avecinos ri ye beyoma' ri ye'asiq'uij (ye'awoyoj), ruma chi riye' xa can yecowin chuka' yatquisiq'uij (yatcoyoj) riyit pa jun wa'in pa cachoch, y riq'ui ri' xa can xtiquiya' yan el ri rajel ruq'uexel chawe. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Yac'a riyit, tek naben jun nimak'ij, que'asiq'uij (que'awoyoj) ri pobres, ri winek ri cut quik'a' o cut caken, ri ye cojos y ri moyi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Y wi queri' naben can jabel c'a ruwa'ak'ij, ruma ri winek ri xe'asiq'uij (xe'awoyoj), ma yecowin ta niquiya' rajel ruq'uexel chawe. Yac'a riyit xtac'ul ri rajel ruq'uexel, tek junan xcac'astej el quiq'ui ri chojmilaj tak winek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y c'o c'a jun achi ri tz'uyul chiri' pa mesa, tek rac'axan chic ka ri tzij ri xubij ri Jesús, xubij c'a apo chare ri Jesús: Jabel ruwaruk'ij ri can xtibewa' pa rajawaren ri Dios, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y yac'ari' tek ri Jesús xubij: Jun achi jun bey ca, xuben jun nimak'ij pa rachoch riche (rixin) chi niquiben jun wa'in. Rumari' riya' ye q'uiy winek ri xubij chique chi yeroyobej chrachoch ri k'ij riche (rixin) ri wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rumari', tek xapon ri k'ij riche (rixin) ri wa'in, ri achi xutek c'a el jun rumozo chiquisiq'uixic (chicoyoxic) quinojel ri winek ri'. Y ri mozo xberubij c'a chique: Ronojel ya c'o chic, wacami jo' c'a pa wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero quinojel can c'o c'a jun ri xquibij pe, chi achique ruma tek ma yecowin ta yebe. C'o c'a jun xubij pe: Tabana' jun utzil tabij juba' chare ri apatrón, chi tucuyu' juba' numac chi ma yicowin ta yibe, ruma xa c'a xinlok' ca jun wulef, y rajawaxic chi yibe chutz'etic. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","C'o chic c'a jun ri xa xubij pe: Tabana' jun utzil tabij juba' chare ri apatrón chi ma yicowin ta yibe, ruma yec'o lajuj nuwáquix riche (rixin) samaj xenlok', y rajawaxic chi yentojtobej na. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y jun chic xubij pe: Ma yicowin ta yibe ruma xa c'a xic'ule'. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y tek ri mozo ri takon el xtzolin apo riq'ui ri rupatrón, ronojel c'a ri xbix pe xberubij chare. Rumari' ri rupatrón xpe royowal, y xubij chare ri rumozo: Wacami c'a cabiyin pa tak c'aybel y pa tak bey riche (rixin) re tinamit re' y quebe'amolo' c'a pe ri cut quik'a' o cut caken, ri ye cojo, ri ye moyi', y chuka' ri pobres. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y tek ri mozo xtzolin pe, xubij c'a chare ri rupatrón: Xenc'om pe ri winek ri xabij el chuwe, pero ri ch'aquet c'a q'uiy na c'o. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ri rupatrón xubij chare ri mozo ri': Wacami c'a jet ri tzan tak jay y ri pa tak bey ri ye'el el chare ri tinamit y tabana' c'a chique ri winek chi puersa yepe pa wachoch, riche (rixin) chi queri' ninoj rupan re wachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ruma riyin can kitzij wi nbij chiwe chi majun chique ri xensiq'uij (xenwoyoj) nabey, ri xtorubana' ta re wa'in re' wuq'ui. Queri' xubij ri achi' ri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y sibilaj c'a ye q'uiy winek ri ye tzekelbeyon el riche (rixin) ri Jesús. Y tek Riya' xtzu'un c'a ca chrij y xerutz'et ri winek ri', xpa'e', y xuchop c'a rubixic chique: ");
INSERT INTO cakWNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Wi c'o c'a jun ri nipe wuq'ui riche (rixin) chi nrajo' yirutzekelbej, c'o c'a chi can yin c'a riyin ri más yirajo'. Man c'a ruc'amon ta c'a chi ya ta ri rute' rutata' ri más yerajo' que chinuwech riyin. Ni ma ruc'amon ta chuka' chi ya ta ri rixjayil, ri ye ralc'ual, ri ye rach'alal ri más yerajo' o xa ya ri ruc'aslen riya' mismo ri más nrajo'. C'o c'a chi can yin c'a riyin ri más yirajo'. Ruma wi ma que ta ri' ri nuben, ma nicowin ta c'a ntoc tzekelbey wuche (wixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri winek ri can nrajo' wi yirutzekelbej, nic'atzin chi ma tupokonaj ta nuk'axaj tijoj pokonal wuma riyin, achi'el jun ri can benak chuxe' jun cruz riche (rixin) chi nbecamisex. Yac'a ri winek ri xa nupokonaj nuk'axaj tijoj pokonal wuma riyin, ma nicowin ta ntoc tzekelbey wuche (wixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ruma tek c'o jun chiwe riyix ri nrajo' nuben jun jay nim, ¿la ma nitz'uye' ta cami juba' riche (rixin) chi nuch'ob janipe' puek ri xtic'atzin chare, y wi can c'o ronojel riq'ui riche (rixin) nuq'uis rubanic o xa ma nicowin ta? ");
INSERT INTO cakWNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ruma wi xaxu (xaxe wi) ri rucimiento ri jay ri nicowin nuya' ka y nupaba' ca ri samaj chiri', xquepe c'a ri winek xquetze'en chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y xtiquibila' c'a: La jun achi la' xrajo' xupaba' jun jay, y xa ma xcowin ta chic xuq'uis, xquecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O wi jun rey ri c'o chi nuben ch'a'oj riq'ui jun chic rey, ¿la ma nitz'uye' ta cami juba' riche (rixin) chi queri' nuch'ob na wi lajuj mil rusoldados yecowin niquiben ch'a'oj quiq'ui ri juwinek mil soldados ri ye ruc'amom pe ri jun chic rey? ");
INSERT INTO cakWNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y wi nuch'ob chi ma nicowin ta, riya' yerutek achi'a' chuc'ulic ri rey, tek c'a c'anej c'o wi. Y ri achi'a' ri yebe chuc'ulic nbequic'utuj ri achique c'a nrajo' chi niquiya' chare riche (rixin) chi tiq'uis chi queri' ri ch'a'oj. ");
INSERT INTO cakWNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Rumari', wi jun chiwe riyix nrajo' yirutzekelbej, c'o c'a chi nuch'ob nabey chi rajawaxic chi nuya' ca ronojel ri c'o riq'ui. Wi ma nuben ta queri', ma nicowin ta ntoc tzekelbey wuche (wixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atz'an jabel. Y wi ta ri atz'an niq'uis ta el ri ratz'amil, ¿achique ta c'a rubanic niban chare riche (rixin) chi queri' nitzolin ta chic pe ri ratz'amil? ");
INSERT INTO cakWNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Jun atz'an ri ma natz'amin ta chic, ni ma nic'atzin ta chare ri ulef, ni ma nic'atzin ta chi nucusex achi'el ri mes riche (rixin) chi niban abonar jun ulef. Xa nirokix el, ruma majun chic nic'atzin wi. Ri c'o rac'axabel, can trac'axaj c'a ri xinbij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y quinojel c'a ri achi'a' ri ye c'utuy tak alcawal y ri nic'aj chic winek ri xa ye aj maqui' xe'apon c'a apo riq'ui ri Jesús riche (rixin) chi niquic'axaj ri ruch'abel ri Dios ri nutzijoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Yac'a ri achi'a' fariseos y ri aj tz'iba' xexebexot (xexebeloj) apo chrij ri Jesús. Y niquibila' c'a: Re Jesús can junan ruwech quiq'ui ri xa ye aj maqui'. Ruma ma xu (xe) ta wi chi jabel quic'ulic nuben, xa can niwa' chuka' quiq'ui, yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Rumac'ari' ri Jesús xuchop c'a rubixic jun c'ambel tzij chiquiwech, y xubij: ");
INSERT INTO cakWNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Wi ta jun chiwe riyix ri yec'o ta jun ciento rucarne'l y nisach ta ca jun tek yeberuyuk'uj, ¿la ma yeruya' ta cami ca juba' ri nic'aj chic tak rucarne'l chiri' pa juyu', y nibe chucanoxic ri jun hasta que nril pe? ");
INSERT INTO cakWNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y tek nberila' pe ri carne'l ri', nuya' c'a pe chuwirutele'n. Can niquicot wi c'a ruma chi xril pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y tek napon chrachoch, yerusiq'uij (yeroyoj) ri winek ri retaman quiwech, y yerusiq'uij (yeroyoj) chuka' ri ruvecinos, y nubij c'a chique: Quixquicot c'a wuq'ui re wacami, ruma ri nucarne'l ri sachnek ca, xinwil pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Can kitzij c'a nbij chiwe, chi chila' chicaj c'o más quicoten tek c'o jun aj mac ri nitzolin pe ruc'u'x riq'ui ri Dios que chiquiwech yec'o ta noventa y nueve ri choj quic'aslen, ri ma nic'atzin ta chique chi nitzolin pe quic'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O wi ta c'o jun ixok ri c'o lajuj sakapuek riq'ui, y chare ri lajuj sakapuek ri' nisach ta jun ri chiri' pa rachoch, ¿la ma nutzij ta cami jun k'ak', y la ma numes ta cami rupan ri rachoch riche (rixin) chi nucanoj? Ri ixok ri' can xtucanoj wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y tek nril, yerusiq'uij (yeroyoj) ri winek ri retaman quiwech, y yerusiq'uij (yeroyoj) chuka' ri ruvecinos, y nubij c'a chique: Quixquicot c'a wuq'ui, ruma ri nurajil ri sachnek, xinwil, xticha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y can kitzij c'a nbij chiwe, chi can queri' chuka' sibilaj yequicot ri ángeles riche (rixin) ri Dios, tek c'o jun aj mac ri nitzolin pe ruc'u'x riq'ui ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y ri Jesús xubij c'a chuka' chique: C'o c'a jun achi ri yec'o ca'i' ruc'ajol. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun k'ij ri chak'laxel xubij c'a chare ri rutata': Táta, riyin nwajo' c'a ri werencia, y taya' c'a chuwe ri c'o chi naya' chuwe, xcha'. Y ri tata'aj can xujech wi c'a ri herencia chiquiwech chi ye ca'i'. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","C'a juba' ri', ri chak'laxel xuc'ayila' ca ronojel ri ruherencia. Can q'uiy c'a ri puek ri xumol el, y c'ac'ari' xbe pa jun chic ruwach'ulef ri nej c'o wi. Y tek c'o chic chiri', xuc'uaj c'a jun itzel c'aslen, y rumari' xuq'uis ronojel ri rurajil. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pero tek riya' kas xuq'uis ronojel ri rurajil, ya chuka' tiempo ri' tek xpe jun nimalaj wayjal chupan ri ruwach'ulef ri acuchi (achique) c'o wi. Y ri c'ajol ri' xpe c'a nimalaj wayjal chare y majun chic c'a nucusaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y rumari' xberutzuju' (xberusuju') ri' pa samaj riq'ui jun achi aj chiri' chupan ri ruwach'ulef ri', y ri achi xutek c'a el pa rulef riche (rixin) chi yeruyuk'uj ak. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y ruma chi can c'o sibilaj wayjal chare ri c'ajol ri', can nurayij c'a nutij ri quiway ri ak. Pero majun ri niya'o ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y ri c'ajol ri', c'ac'ari' tek xtzolin pe ruc'u'x, y xubij ka pa ránima: Q'uiy mozos ri yec'o chrachoch ri nata' y c'o q'uiy quiway. Y riyin xa juba' ma yicom ka wawe' ruma wayjal. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Más utz quitzolin na riq'ui ri nata', y xtinbij c'a chare: Táta, ximacun chuwech ri Dios, y can ximacun chuka' chawech riyit. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Man c'a ruc'amon ta chic chi nabij ac'ajol chuwe. Xa más utz tabana' chuwe chi yinoc jun amozo, xcha' ka pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y can xuchop c'a el bey chi nibe chrachoch, c'a riq'ui ri rutata'. Y ri c'ajol ri' c'anej na c'a c'o wi riche (rixin) chi napon chrachoch, tek ri tata'aj xutz'et yan ri ruc'ajol, y sibilaj c'a xujoyowaj ruwech. Rumari' ri tata'aj junanin (anibel) xbe chuc'ulic, xutz'umaj (xutz'ubaj) ruchi' y xuk'etej. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y ri c'ajol can yac'ari' xubij chare ri rutata': Táta, ximacun chuwech ri Dios, y can ximacun chuka' chawech riyit. Man c'a ruc'amon ta chic chi nabij ac'ajol chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Yac'a ri tata'aj xubij c'a chique ri rumozos: Tiwelesaj pe ri tziek más jabel y tiwika' re nuc'ajol. Tiya' jun puk'a' (napak'e') chuwiruk'a' y tiya' chuka' ruxajab chraken. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y jibe'ic'ama' c'a pe chuka' ri ti wáquix ri más ti'oj, y ticamisaj. Tikabana' c'a jun nimak'ij, y kojwa' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ruma chi riyin nbij c'a, chi re jun nuc'ajol re' caminek chic, pero wacami xa achi'el xc'astej pe. Rusachon c'a el ri', pero xoka chic kiq'ui, xcha' ri tata'aj. Y yac'ari' tek xchapatej ri nimak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y tek ntajin c'a ri nimak'ij, ri nimalaxel nisamej pa juyu'. Y tek xtzolin c'a pe y xapon c'a chunakajal ri jay, xrac'axaj c'a chi ntajin ri k'ojon y xajoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rumari' riya' xusiq'uij (xroyoj) jun chique ri mozos y xuc'utuj c'a chare: ¿Achique xbanatej? ¿Y achique ruma tek c'o nimak'ij ntajin? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri mozo xubij c'a chare: Ruma chi xtzolin pe ri achak', y utz ruwech xtzolin pe. Rumari' ri atata' xutek rucamisaxic ri alaj wáquix ri más ti'oj. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Tek xrac'axaj ri queri' ri nimalaxel, xyacatej royowal, y ma nrajo' ta c'a ntoc apo ri pa jay. Xbe'el c'a pe ri rutata', y nubochila' c'a, riche (rixin) chi queri' ntoc ta apo. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero ma xrajo' ta. Riya' xa xubij c'a chare ri rutata': Riyin can ronojel k'ij c'a yisamej awuq'ui y majun bey ri man ta nuniman atzij. Y ma riq'ui wi ri', majun ri aya'on ta chuwe. Astape' xa ta jun ti q'uisic' (cabra) riche (rixin) chi nikaben ta jun nimak'ij quiq'ui ri wamigos, pero majun, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y wacami riyit xacamisaj ri ti wáquix ti'oj, xaxu (xaxe wi) ruma chi xtzolin pe re jun ac'ajol re', ri xa xberuq'uisa' yan ca ronojel ri abeyomal quiq'ui ixoki' ri ma utz ta quic'aslen, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri tata'aj xubij: Nuc'ajol, riyit can yitc'o wi wuq'ui. Rumari' ronojel ri c'o wuq'ui, can awuche (awixin) wi riyit. ");
INSERT INTO cakWNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Yac'a ri achak' chinuwech riyin can caminek chic, y wacami xa achi'el xc'astej pe. Rusachon c'a el ri', y wacami xoka chic kiq'ui. Y rumari' rajawaxic chi c'o nimak'ij y quicoten pa tak kánima, xcha' ri tata'aj ri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xubij c'a chuka' chique ri ye rudiscípulos: C'o c'a jun achi beyon. Y ri beyon ri' c'o c'a jun rumayordomo ri ruya'on pa ruwi' ronojel ri rubeyomal. Y xbix c'a chare ri achi beyon chi ri rumayordomo, ntajin c'a chuq'uisic ri beyomel. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y ri patrón xutek c'a rusiq'uixic (royoxic) ri mayordomo ri'. Y tek xoka c'a ri mayordomo, ri patrón xubij c'a chare: ¿Achique c'a nabij chuwe chrij ri nitzijox chawij chi achapon ruq'uisic ri nubeyomal? Wacami nwajo' c'a ntz'et achique rubanon ronojel ri nubeyomal pan ak'a', ruma chi ri asamaj yare' niq'uis ca wawe', xcha' ri patrón chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y ri mayordomo xuch'ob c'a ka pa ránima: ¿Achique nben? Ruma chi re nupatrón nrelesaj nusamaj. Wi yibesamej pa juyu', xa ma yicowin ta. Wi yinoc c'utuy limosna pa tak bey, yiq'uix. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Tek xch'obotej chuwech, xubij: Wacami wetaman chic achique ri xtinben, riche (rixin) chi queri' yec'o yec'ulu wuche (wixin) ri pa tak cachoch, tek xtelesex ri nusamaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri mayordomo c'a ri' xerusiq'uij (xeroyoj) chiquijujunal ri c'o quic'as riq'ui ri rupatrón, y xuc'utuj c'a chare ri nabey: ¿Achique c'a ri ac'as, y janipe'? ");
INSERT INTO cakWNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y ri achi aj c'as xubij c'a: Riyin c'o jun ciento barril aceite olivo ri nuc'as, xcha'. Y ri rumayordomo ri beyon achi xubij c'a chare ri aj c'as: Ya ruwujil ri ac'as re'. Y wacami aninek catz'uye' ka y tabana' chic ca jun ruwujil. Y chupan ri jun wuj ri xtaben, tabana' c'a ka chupan chi xa nic'aj ciento barril aceite ri ac'as. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y tek xapon chic c'a jun aj c'as, ri mayordomo xuc'utuj c'a chare: Y riyit, ¿achique ri ac'as y janipe'? Ri aj c'as xubij: Riyin c'o jun ciento pajbel trigo ri nuc'as, xcha'. Y ri mayordomo xubij c'a chare: Ya ruwujil ri ac'as re', y wacami catz'uye' ka y tabana' chic jun. Y chupan ri jun chic wuj ri xtaben, tatz'ibaj ka chi xa ochenta, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y tek ri rupatrón xrac'axaj ri nuben ri jun itzel mayordomo ri', xubij: Can c'o runa'oj chubanic, xcha'. Y achi'el c'a ri achi ri', ye queri' ri winek ri xa riq'ui re ruwach'ulef quicukuban wi quic'u'x. Can c'o quina'oj niquiben quiq'ui ri winek ri xa riq'ui chuka' re ruwach'ulef quicukuban wi quic'u'x. Y can más c'a c'o quina'oj ri winek ri', que chiquiwech ri quiniman ri Dios y ye riche (rixin) chic ri sakil. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y riyin nbij c'a chiwe chi can ticusaj ri beyomel riche (rixin) re ruwach'ulef, riche (rixin) chi ye'ito' ri nic'atzin quito'ic. Riche (rixin) chi queri' tek xtiq'uis ri ibeyomal, xquixc'ul c'a ri chila' chicaj, chupan ri jay ri can c'o riche (rixin) xtibe k'ij xtibe sek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun winek ri can utz nuben riq'ui ri xa ma q'uiy ta ri ya'on ca chare, can utz c'a chuka' xtuben riq'ui wi q'uiy niya'ox (nya') ca chare. Yac'a jun winek ri xa ma utz ta nuben riq'ui ri ma q'uiy ta ri ya'on ca chare, xa can ma utz ta chuka' xtuben riq'ui wi q'uiy niya'ox (nya') ca chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y wi riq'ui ri beyomel ri xa riche (rixin) re ruwach'ulef, riyix majun utz niben riq'ui, ¿la xtujech cami ri Dios ri kitzij beyomel chiwe? ");
INSERT INTO cakWNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ruma wi xa majun utz niben riq'ui jun beyomel ri xa ma iwuche (iwixin) ta riyix, ¿la c'o ta cami jun xtijacho ri kitzij beyomel pan ik'a', beyomel ri can yacon apo riche (rixin) chi ntoc iwuche (iwixin) riyix? ");
INSERT INTO cakWNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Y majun c'a mozo ri nicowin ta nisamej quiq'ui ye ca'i' patrón. Ruma wi nrajo' jun chique ri rupatrón, nretzelaj ca ri jun chic. Y wi can sibilaj nunimaj rutzij ri jun, can nretzelaj ri jun chic. Y quec'ari' chuka', ri winek ri xa benak ránima chrij ri beyomel, ma nicowin ta nuben ri nrajo' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y ri achi'a' fariseos xquic'axaj c'a ri xubij ri Jesús, rumari' xquibanala' apo quipalej chuwech, ruma chi riye' can benak cánima chrij ri beyomel. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y ri Jesús xubij chique: Riyix can nibananej iwi' chiquiwech ri winek chi can sibilaj yix choj. Yac'a ri Dios xa can retaman wi achique ri c'o pan iwánima, y ma utz ta yixrutz'et. Y astape' can jabel c'a yixtz'et y astape' chuka' chi can janipe' na nimirisan ik'ij cuma ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y tek c'a ma jane c'a tuchop ta samaj ri Juan ri Bautista, can c'a ya na c'a ri ley riche (rixin) ri Moisés ri nitzijox. Y can c'a ya na chuka' ri ruch'abel ri Dios ri tz'iban ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, can c'a ya na c'a chuka' ri' nitzijox. Yac'a tek xuchop samaj ri Juan, yac'ari' tek xchapatej rutzijoxic ri lok'olaj ruch'abel ri Dios ri nich'o chrij ri rajawaren ri Dios. Y ye q'uiy c'a winek ri sibilaj niquitij quik'ij riche (rixin) chi ye'oc chupan. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Y chuka' nbij chiwe, chi xa ma can ta c'ayef (cuesta) chi re ruwach'ulef y ri caj xquek'ax, que chuwech ri ley. Ruma ri nubij chiri', can c'o wi c'a chi nibanatej na ronojel, y majun jun ti letra chak ta queri' xtic'oje' ta ca, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y ri Jesús xubij chuka': Wi c'o c'a jun achi ri nujech ca ri rixjayil y c'ac'ari' nuc'om chic jun ixok, ri achi ri' nimacun chuwech ri Dios. Y wi c'o c'a jun achi ri nic'amo jun ixok ri jachon ca ruma ri rachijil, chuka' ri achi ri' nimacun chuwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y ri Jesús xubij c'a chuka': Xc'oje' c'a jun achi ri q'uiy rubeyomal c'o. Ri achi ri' ruyon c'a jabel tak tziek ri jotol cajel ri yerucusala', y k'ij k'ij nubanala' nimak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero queri' chuka' xc'oje' c'a jun c'utuy limosna y nojnek ri ruch'acul pa ch'a'c. Ri achi ri' Lázaro rubi', y can yac'a ri pa ruchi' rachoch ri beyon nic'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro can sibilaj c'a nurayij chi nutij ta ri ruc'aj tak wey ri yetzak ka chuxe' ri mesa. Y ri tz'i' can ye'apon c'a riq'ui churak'ic ri ch'a'c ri c'o chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y c'o c'a jun k'ij tek ri c'utuy limosna xcom, y xuc'uex c'a el cuma ri ángeles y c'a ya ri lugar riche (rixin) quicoten xapon wi; chiri' riq'ui ri Abraham. Y chuka' ri achi beyon xcom, y xmuk. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y tek ri beyon nutij chic c'a pokonal chupan ri lugar ri ye'apon wi ri caminaki' ri ma xquinimaj ta el ri Dios, riya' xtzu'un anej chicaj, y yac'ari' tek xutz'et ri Abraham, pero c'anej c'a c'o wi. Xutz'et c'a chuka' ri Lázaro rak'el apo chuwaruc'u'x ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ri achi beyon xurek ruchi' y xubij c'a chare ri Abraham: Nata' Abraham, tajoyowaj nuwech. Tabana' c'a jun utzil tataka' pe ri Lázaro wuq'ui wawe', chi astape' xaxu (xaxe wi) juba' ruwi' ruk'a' tuxek'eba' (tuch'ekeba') pe, riche (rixin) chi noruya' ca pa ruwi' wak'. Ruma nic'at wánima chupan re k'ak' re', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Yac'a ri Abraham xubij chare: Nuc'ajol, toka c'a chac'u'x, chi tek xac'ase' chuwech ri ruwach'ulef, sibilaj jabel xak'axaj ri ac'aslen, y re Lázaro sibilaj tijoj pokonal xuk'axaj. Pero riya' sibilaj jabel ri ruc'aslen ri xorila' wawe', y riyit xa jun c'aslen riche (rixin) tijoj pokonal ri xawil. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chuka' xa c'o jun nimalaj siwan chkacojol. Rumari', wi c'o jun ri c'o wawe' nrajo' ta napon iwuq'ui, ma nicowin ta. Y wi ta jun chiwe riyix nrajo' nipe wawe' kiq'ui riyoj, ma nicowin ta chuka', xcha' ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y ri achi beyon xubij c'a: Wi queri', nwajo' c'a nc'utuj jun chic utzil chawe riyit nata' Abraham. Tataka' c'a el juba' ri Lázaro pa rachoch ri nata'. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ruma yec'o wu'o' wach'alal, y nberubij ta chique riche (rixin) chi ma yepe ta chupan re jun lugar riche (rixin) tijoj pokonal, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y ri Abraham xubij chare: Riye' c'o ri ruch'abel ri Dios quiq'ui, ri rutz'iban ca ri Moisés. Y c'o chuka' ruch'abel ri Dios ri tz'iban ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. Yac'ari' ri tiquic'axaj, y tiquinimaj, xcha' ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y ri achi beyon xubij: Ja' (je), can kitzij wi ri xabij, nata' Abraham. Pero wi c'o jun ri caminek chic ri nic'astej el y napon quiq'ui ri wach'alal, can xtitzolin wi pe quic'u'x riq'ui ri Dios, xcha' ri beyon. ");
INSERT INTO cakWNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Yac'a ri Abraham xubij chare: Wi can ma niquinimaj ta ri ruch'abel ri Dios ri rutz'iban ca ri Moisés, ni ma niquinimaj ta chuka' ri ruch'abel ri Dios ri quitz'iban ca ri profetas ri xek'alajsan ri ch'abel ri' ojer ca, c'a ta c'a chi xtiquinimaj jun ri nic'astej el chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Y ri Jesús xubij c'a chique ri ye rudiscípulos: Ronojel tiempo can c'o wi c'a ri xtibano chique ri winek riche (rixin) chi yetzak pa mac. Pero juyi' oc ruwech ri nibano chare jun chic winek chi nitzak pa mac. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ruma ri winek ri xbano ri pokon ri', nimalaj ruc'ayewal nipe pa ruwi'. Rumari' xa utz na juba' chi ximon ta jun nimalaj ca' chukul y nbec'ak ca pa mar, que chuwech nuben chare jun co'ol chi nitzak pa mac. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Rumari' riyix tichajij c'a ri ic'aslen. Y wi c'o jun awach'alal ri c'o jun pokon nuben chawe, tabij c'a chare chi ma utz ta xuben. Y wi ri nibano pokon chawe noruc'utuj cuybel rumac chawech ruma xtzolin pe ruc'u'x, tacuyu' c'a rumac. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y wi pa jun k'ij wuku' ta mul c'o pokon nuben chawe y chi wuku' mul nitzolin ta pe ruc'u'x y nipe awuq'ui y nubij chawe: Tacuyu' tasacha' numac, nicha' ta; can utz c'a chi nacuy rumac, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y ri apóstoles xquibij c'a chare ri Ajaf Jesús: Tabana' c'a chake chi nikacukuba' más kac'u'x riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Yac'a ri Ajaf Jesús xubij chique: Xa riq'ui ta nicukuba' juba' ic'u'x riq'ui ri Dios, astape' jun cukbel c'u'x ri xa achi'el jun ti ija'tz riche (rixin) ri mostaza, xa riq'ui ri' can yixcowin wi nibij chare re jun che' ri sicómoro rubi' chi tel el wawe' y tik'ax chupan ri mar riche (rixin) chi nberutica' ri' chiri', y re che' re' can xtunimaj wi itzij. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Y wi c'o ta jun chiwe riyix ri c'o jun rumozo ri rutakon el pa juyu' riche (rixin) chi nisamej riq'ui ri arado o niyuk'un carne'l, ¿la can xu (xe wi) cami tek nitzolin pe, can ya cami ri' xtubij chare: Catoc pa jay, catz'uye' pa mesa y cawa'? Mani. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿La ma nubij ta cami chare: Tachojmirisaj ri xtintij re wacami tikak'ij, y tachojmirisaj awi' riche (rixin) chi queri' yinanimaj yinawilij pe re yiwa' y yinuc'ya', y can c'a ya tek xiwa' yan riyin, c'ac'ari' xcawa' y xcatuc'ya' riyit? ");
INSERT INTO cakWNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Y numatioxij cami chare ri mozo ruma xuben ri xubij chare? Ma que ta ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y can achi'el ri mozo ri', queri' chuka' riyix. Tek ibanon chic ri samaj ri nubij ri Dios chiwe, tibij: Riyoj yoj mozos ri majun yojc'atzin wi. Ruma xaxu (xaxe) wi ri bin chake, xaxu (xaxe) wi ri' ri xkaben, quixcha', xcha' ri Jesús chique ri ye rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y tek ri Jesús ye rachibilan ri ye rudiscípulos xuchop chic el bey chi nibe pa Jerusalem, xk'ax c'a chiquicojol ri lugar Samaria y ri Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y tek xapon pa jun aldea, yec'o c'a ye lajuj achi'a' ri c'o ri yabil lepra chiquij. Ri achi'a' ri' xebec'ulun pe, pero c'anej xepa'e' wi apo chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y xquichop niquirek apo quichi' chare ri Jesús y xquibij: Tijonel, tajoyowaj kawech ruma re kabanon, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y ri Jesús tek xerutzu' xubij c'a chique: Quixbiyin c'a y je'ic'utu' iwi' chiquiwech ri sacerdotes, xcha' el ri Jesús chique. Y tek quichapon c'a el binen riche (rixin) chi nbequic'utu' qui' chiquiwech ri sacerdotes, ri quiyabil xq'uis el chiquij y xech'ajch'ojir c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun c'a chique ri ye lajuj achi'a' ri', tek xutz'et chi can xc'achojsex wi chare ri ruyabil, riya' xtzolin. Y can nuya' ruk'ij ruc'ojlen ri Dios, y can nurek ruchi' chubixic. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y tek xapon riq'ui ri Jesús, xxuque' chuwech y xujupuba' ka ri rupalej c'a pan ulef, y sibilaj c'a numatioxij chare ri Jesús. Ri achi c'a ri' aj Samaria. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y ri Jesús xubij: Ye lajuj c'a ri xec'achoj chare ri quiyabil y xech'ajch'ojir. Y ri beleje' chic, ¿acuchi (achique) yec'o wi? ");
INSERT INTO cakWNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Can majun chic c'a ri xtzolin ta pe riche (rixin) chi nuya' ruk'ij ruc'ojlen ri Dios? ¿Xaxu (xaxe) wi re jun achi re' ri ma israelita ta? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y ri Jesús xubij c'a chare ri achi aj Samaria: Cayacatej y cabiyin c'a. Xac'achoj ruma chi can xacukuba' ac'u'x wuq'ui, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y ri achi'a' fariseos xquic'utuj c'a chare ri Jesús chi achique tiempo xtoka ri rajawaren ri Dios. Y ri Jesús xubij c'a chique: Can ma xtinabex ta achique tiempo xtoka ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y majun c'a xtibin ta chi yare' c'o wawe', o yala' c'o chila', ruma chi ri rajawaren ri Dios c'o chic chicojol, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y Riya' xch'o c'a chique ri ye rudiscípulos, y xubij: Xque'oka c'a ri k'ij tek riyix xtiwajo' chi astape' xaxu (xaxe wi) jun k'ij xtiwajo' xtitz'et ri C'ajolaxel ri xalex chicojol. Pero ma xtitz'et ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y can yec'o c'a ri xquebin chiwe: Yare' c'o wawe'. Yala' c'o chila'. Pero riyix man c'a quixbe ta quiq'ui, ni man c'a chuka' que'itzekelbej ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ruma tek xtapon ri k'ij chi ri C'ajolaxel ri xalex chicojol xtipe chic jun bey, can xtuben wi c'a achi'el jun coyopa', ri can nusakirisaj ruwech ri caj ruma can nitz'etetej cuma quinojel ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero nabey c'o c'a chi nk'axaj na q'uiy tijoj pokonal, y c'o c'a chuka' chi yinetzelex cuma ri winek riche (rixin) re tiempo re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y ri k'ij c'a tek xquipe chic riyin ri C'ajolaxel ri xinalex chicojol, can xtibanatej c'a chuka' achi'el ri xc'ulwachitej pa rutiempo ri Noé. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chupan c'a ri rutiempo ri Noé, ri winek ri' xaxu (xaxe) wi c'a chrij ri quiway quic'uya' benak wi ri cánima, chuka' chi achi'a' chi ixoki' can benak c'a cánima chrij ri quic'ulanen. Y can c'a que na ri' yetajin chubanic ri winek chupan ri k'ij tek ri Noé y ri ye aj pa rachoch xe'oc chupan ri nimalaj barco, y xuchop ri nimalaj k'ekelaj job. Y quinojel ri winek xecom. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y can queri' c'a chuka' xc'ulwachitej pa rutiempo ri Lot. Ri winek ri' xaxu (xaxe) wi c'a chrij ri quiway quic'uya' benak wi cánima, riq'ui ri quilok'oj, ri quic'ayij, ri quitico'n y ri paban tak jay. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y ya c'a ri k'ij tek ri Lot y ri ye aj pa rachoch xe'el el pa tinamit Sodoma, xka c'a ca k'ak' y azufre pa ruwi' ri tinamit. Can achi'el c'a job xuben tek xka pe ri chicaj, y can quinojel ri winek yec'o chiri' xeq'uis ruma ri k'ak'. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y quec'ari' quibanon ri winek chupan ri k'ij tek ri C'ajolaxel ri xalex chicojol xtipe chic jun bey, sibilaj c'a ye q'uiy winek ri xa riq'ui ronojel ri c'o quiq'ui benak wi ri cánima. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri c'o c'a pa ruwi' ri rachoch tek xtibanatej ronojel ri', xa utz chi tanmej el. Y ma tika ta pe riche (rixin) chi ntoc pa rachoch riche (rixin) chi nberuc'ama' pe ri rucosas ri c'o pa jay. Y wi c'o c'a chuka' jun ri nisamej pa juyu' chupan ri k'ij ri', ma titzolin ta chic pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ruma toka c'a chi'ic'u'x ri xuc'ulwachij ri rixjayil ri Lot, tek xporox ri tinamit Sodoma ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri can sibilaj c'a nupokonaj ri ruc'aslen re wawe' chuwech re ruwach'ulef, ma xtril ta ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri ma nupokonaj ta ri ruc'aslen re wawe' choch'ulef, xtril ri ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Y tek riyin xquipe chic jun bey, yac'ari' tek xtibanatej chi yec'o ye ca'i' ye warnek pa jun ch'at, jun xtuc'uex el y jun ri xticanaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chuka' ye ca'i' ixoki' ri junan yequi'en, jun c'a ri xtuc'uex el y jun ri xticanaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y chuka' ye ca'i' achi'a' ri junan yesamej pa juyu', jun c'a ri xtuc'uex el y jun ri xticanaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y tek ri ye rudiscípulos quic'axan chic ka ri xubij ri Jesús, xquic'utuj c'a chare: Ajaf, ¿acuchi (achique) c'a xtic'ulwachitej wi ri queri' ri'? xecha'. Y ri Jesús xubij c'a chique: Ri ruc'ayewal ri xtuya' ri Dios xtika acuchi (achique) c'o wi ri mac. Can xtibanatej c'a achi'el niquiben ri c'uch. Ruma ri aj xic' tak chicop ri' xabachique lugar c'o wi jun caminek ch'aculaj, chiri' c'a yeka wi, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y ri Jesús xutzijoj c'a jun c'ambel tzij chique ri ye rudiscípulos riche (rixin) chi nuc'ut chiquiwech chi can rajawaxic wi chi ma quetane' ta chi niquiben orar y ma tiquimalij ta ca rubanic. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Riya' xubij c'a chique: Pa jun c'a tinamit xc'oje' jun aj k'atbel tzij ri can ma nuxibij ta ri' chuwech ri Dios, y majun chuka' quejkalen ri winek chuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan c'a chuka' ri tinamit ri', c'o c'a jun malca'n ixok. Y ri malca'n ixok ri' binakil napon riq'ui ri aj k'atbel tzij ri' y nubij c'a chare: Tak'ata' tzij pa ruwi' ri nuc'ulel, nicha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y q'uiy c'a k'ij ri xk'ax, y ri aj k'atbel tzij ma xrajo' ta xuto' ri ixok ri' chuwech ri ruc'ulel. Pero jun k'ij ri aj k'atbel tzij ri' xuch'ob c'a ka pa ránima: Astape' riyin ma nnimaj ta ri Dios, ni majun chuka' quejkalen ri winek chinuwech, ");
INSERT INTO cakWNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero ruma c'a re ixok re' ntel ntoc wuq'ui, nben na c'a ri nrajo'. Ruma wi ma xtinben ta, xtic'o nuc'u'x pa ruk'a'. Queri' nubij ri c'ambel tzij ri xutzijoj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y c'ac'ari' ri Ajaf Jesús xubij: Riyin wetaman chi riyix xiwac'axaj ri jabel tak ch'abel ri xerubij ri aj k'atbel tzij, y riya' xa ma utzilaj aj k'atbel tzij ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿C'a ta c'a ri Dios chi man ta xqueruto' ri winek ri ye rucha'on chic Riya' y chi pak'ij chi chak'a' niquiben orar? ¿Ri Dios ma chanin ta cami xqueruto' pe ri winek ri ye rucha'on chic? ");
INSERT INTO cakWNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Riyin can nbij c'a chiwe chi chanin xqueruto' pe. Y tek ri C'ajolaxel ri xalex chicojol xtipe chic jun bey wawe' chuwech re ruwach'ulef, ¿la c'a yec'o na cami winek ri quicukuban quic'u'x riq'ui ri Dios? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y ri Jesús xubij chic c'a jun c'ambel tzij chiquiwech ri winek, ruma yec'o chique riye' ri niquich'ob chi choj ri quic'aslen, y yequetzelaj ri nic'aj chic winek. Rumari' ri Jesús xubij: ");
INSERT INTO cakWNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yec'o c'a ye ca'i' achi'a' ri xebe pa rachoch ri Dios riche (rixin) chi nbequibana' orar. Ri jun achi, jun chique ri fariseos, y ri jun chic, jun c'utuy alcawal. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri achi fariseo pa'el, ruyon nuben orar, y nubij c'a chupan ri ru'oración: Dios, matiox nya' chawe ruma chi riyin ma yin junan ta quiq'ui ri nic'aj chic. Ruma chi ri nic'aj chic winek ye alek'oma', c'o quixjayil y yequicanoj nic'aj chic ixoki', y ma choj ta ri quic'aslen. Ni ma yin junan ta c'a chuka' riq'ui re jun achi c'utuy alcawal re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ruma chi riyin can ca'i' c'a k'ij pa jun semana ri ma yiwa' ta riche (rixin) chi nben orar. Y niwelesaj ca ri nudiezmo chare ronojel ri nch'ec, riche (rixin) chi nya' chawe riyit, xcha' ri fariseo pa ru'oración. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Y yac'a ri c'utuy alcawal c'anej c'a xpa'e' wi ca y xluque' c'a chiri', riche (rixin) chi nuben orar, ruma chi chuwech riya' can ma ruc'amon ta (takal ta chrij) chi nuyec ri runak' ruwech chicaj y riya' nubajila' c'a ruwaruc'u'x riq'ui ri ruk'a', y nubij c'a chare ri Dios: Tajoyowaj nuwech, ruma chi riyin yin jun aj mac chawech, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Can kitzij c'a nbij chiwe, xcha' ri Jesús, chi ri achi c'utuy alcawal xtzolin el, y xtz'etetej ruma ri Dios chi xa majun rumac. Y yac'a ri achi fariseo ma que ta ri' xc'ulun chuwech ri Dios. Ruma chi xabachique c'a ri nunimirisaj ri', xa can xtikasex c'a ruk'ij. Yac'a ri ruch'utinirisan ri', xtinimirisex ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y yec'o c'a ac'ala' ri xe'uc'uex apo chuwech ri Jesús, chi nuya' ta el ri ruk'a' pa quiwi', riche (rixin) chi niquic'ul ri rubendición ri Dios. Yac'a ri discípulos xa xechapon chique ri winek chi ma quequic'om ta pe ri ac'ala'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ri Jesús xerusiq'uij (xeroyoj) ri ye rudiscípulos y xubij chique: Tiya' k'ij chique ri ac'ala' chi yepe wuq'ui riyin, y ma que'ik'et ta. Ruma ri xque'oc pa rajawaren ri Dios, xaxu (xaxe) wi ri winek ri ye achi'el re ac'ala' re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y can kitzij c'a nbij chiwe, chi ri xa ma niquiben ta achi'el ri ac'ala' riche (rixin) chi niquijech qui' pa ruk'a' ri Dios, can man c'a xque'oc ta pa rajawaren ri Dios, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y c'o c'a jun achi ri nim ruk'ij, xuc'utuj c'a chare ri Jesús: Riyit ri can yit utzilaj Tijonel, tabij c'a chuwe: ¿Achique c'a ri rajawaxic chi nben riyin riche (rixin) chi ntoc ta wuche (wixin) ri c'aslen riche (rixin) xtibe k'ij xtibe sek? xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y ri Jesús xubij chare: ¿Achique ruma tek nabij utz chuwe riyin? Ruma majun winek ri utz ta, xa can xu (xe wi) ri Dios ri utz. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Y riyin nbij chi riyit jabel awetaman ri rupixa' ri Dios: chi riyit achi ri c'o awixjayil man c'a tacanoj ta jun chic ixok, ma cacamisan ta; ma catelek' ta; ma tatz'uc ta tzij chrij jun chic winek; taya' quik'ij ri ate' atata', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y ri achi xubij chare ri Jesús: C'a yin co'ol na tek nchapon pe rubanic ronojel ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Tek ri Jesús xrac'axaj queri', xubij: C'a c'o na c'a jun ri ma abanon ta. Ma aya'on ta ri abeyomal chique ri pobres. Tac'ayij c'a ronojel ri c'o awuq'ui y ri rajel taya' chique ri pobres, riche (rixin) chi queri' nic'oje' abeyomal chila' chicaj. Y catam pe wuq'ui y quinatzekelbej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y tek ri achi ri' xrac'axaj ri xubij ri Jesús, sibilaj xbison pa ránima, ruma q'uiy rubeyomal c'o y ma nrajo' ta ntel pa ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y tek ri Jesús xutz'et chi xa xpe sibilaj bis pa ránima ri achi, xubij: Ri c'o quibeyomal, c'ayef (cuesta) chi ye'oc pa rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xa ma can ta c'ayef (cuesta) chi nik'ax ri jun chicop ri camello rubi' pa ti rachek jun bak riche (rixin) t'iso'n (tz'iso'n), que chuwech chi ntoc jun beyon pa rajawaren ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri xe'ac'axan ri xubij ri Jesús, xquibila' c'a: Wi can achi'el ri xubij, ¿achique ta c'a jun ri xticolotej? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y ri Jesús xubij c'a chique: Ri ma yecowin ta niquiben ri winek, ri Dios can nicowin wi nuben, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Yac'ari' tek ri Pedro xubij: Riyit awetaman chi riyoj kaya'on ca ri c'o kiq'ui, riche (rixin) chi yit katzekelben, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xubij c'a chique: Can kitzij nbij chiwe, chi xabachique winek ri ruya'on ca rachoch, ruya'on ca rute' rutata', rach'alal, rixjayil o ralc'ual, riche (rixin) chi nuben samaj riche (rixin) ri rajawaren ri Dios, can xtuc'ul c'a rajel ruq'uexel. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Can q'uiy yan c'a ri nuc'ul chupan re tiempo re kachapon. Y chupan apo ri jun chic tiempo chkawech apo, can xtiyatej c'a chuka' ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y ri Jesús xeruc'uaj c'a el juba' quela' pa quiyonil ri cablajuj rudiscípulos, y xubij chique: Riyix iwetaman chi pa tinamit Jerusalem kachapon wi el bey, y ri chiri', q'uiy c'a ri xtiban chuwe riyin ri C'ajolaxel ri xinalex chicojol. Can ronojel wi c'a ri tz'ibatal ca chuwij riyin can xtibanatej wi, can achi'el ri quitz'iban ca ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquijach c'a pa quik'a' winek ri ma ye israelitas ta. Y ri winek ri' xquetze'en chuwij, xtiquibila' itzel tak ch'abel chuwe y xquinquichubaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xquinquich'ey, y c'ac'ari' xquinquicamisaj. Pero pa rox k'ij xquic'astej c'a pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ri cablajuj rudiscípulos can ma xk'ax ta c'a chiquiwech ri xubij ri Jesús. Ri ch'abel ri' xa ewatajnek c'a chiquiwech riche (rixin) chi ma niquetamaj ta, rumac'ari' xaxu (xaxe) wi xquic'axaj y ma xk'ax ta chiquiwech achique ntel wi ri tzij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tek ri Jesús ntoc yan c'a apo ri pa tinamit Jericó, ri chiri' chuchi' bey tz'uyul c'a jun achi. Y ri achi c'a ri' moy, y nuc'utula' ca limosna chique ri winek ri yek'ax el queri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y tek ri moy ri' xrac'axaj chi sibilaj ye q'uiy winek ri yek'ax el, xuc'utuj c'a chi achique ri xc'ulwachitej. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y xquibij chare chi ya ri Jesús aj Nazaret ri nik'ax el queri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y ri achi moy ri' xurek ruchi', y xubij c'a: Riyit Jesús, ri yit ralc'ual ca ri rey David, tajoyowaj nuwech ruma re nbanon, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ri winek c'a ri ye nabeynek el chuwech ri Jesús, xquik'il c'a ri achi chi ma turek ta chic ruchi'. Pero riya' xa más xurek ruchi', y xubij: Riyit ri yit ralc'ual ca ri rey David, tajoyowaj nuwech ruma ri nbanon, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y ri Jesús xrac'axaj c'a ri ruch'abel. Rumari' xpa'e' c'a y xubij chi tic'amer pe. Y tek c'o chic apo ri achi riq'ui, xuc'utuj c'a chare: ");
INSERT INTO cakWNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Achique c'a ri nawajo'? Y ri achi moy xubij: Ajaf, riyin nwajo' yitzu'un, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xubij chare: Catzu'un c'a. Ruma chi xacukuba' ac'u'x wuq'ui, rumari' xac'achoj. ");
INSERT INTO cakWNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y ri achi moy can yac'ari' tek xtzu'un y xtzeke' el chrij ri Jesús. Ri achi c'a chuka' ri' nuya' ruk'ij ruc'ojlen ri Dios. Y quinojel ri winek ri xetz'eto chi xtzu'un ri moy, can xquiya' c'a chuka' ruk'ij ruc'ojlen ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y yac'ari' tek ri Jesús ye rachibilan ri rudiscípulos xoc apo ri pa tinamit Jericó, y nik'ax c'a el. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y ri chiri' chupan ri tinamit ri' c'o c'a jun achi beyon ri Zaqueo rubi'. Ri achi c'a ri', yari' ri más nim ruk'ij que chiquiwech ri nic'aj chic c'utuy tak alcawal. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y riya' can nutij c'a ruk'ij riche (rixin) chi nrajo' nutzu' el ri Jesús, pero ruma chi sibilaj ye q'uiy ri winek y riya' xa ti co'ol oc ri rupalen, rumari' ma nicowin ta c'a nutz'et el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Rumari' riya' junanin (anibel) xnabeyej el y xbejote' pa ruwi' jun che' ri sicómoro rubi', riche (rixin) chi queri' nutz'et el ri Jesús, ruma c'o chi nik'ax el queri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y tek ri Jesús nik'ax c'a el queri', xtzu'un anej pa ruwi' ri che', y xubij c'a chare ri jotol chiri': Zaqueo, chanin caka pe chiri', ruma chi can ya re wacami c'o chi yinapon pan awachoch, riche (rixin) chi yinuxlan juba', xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo can yac'ari' xka pe chanin, y riq'ui quicoten xuc'ul apo ri Jesús pa rachoch. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tek xbanatej c'a ri queri', ri winek xexebexot (xexebeloj) c'a apo chrij ri Jesús y niquibila' c'a chi ri Jesús xa pa rachoch jun achi aj mac xbec'oje' wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y ri Zaqueo xpa'e' c'a y xch'o apo chare ri Ajaf Jesús y xubij: Ajaf, wacami pa nic'aj chare ri nubeyomal nya' chique ri pobres. Y wi c'o winek ri can xk'ax ruwi' ri alcawal welesan chique, can caji' chic c'a ruq'uexel ri xtintzolij chique, y ma xu (xe wi) ta chic ri xinwelesaj chique, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xubij chare: Wacami xoka yan ri colotajic chupan re jay re', ruma chi riya' chuka' can riy rumam ca ri Abraham. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ruma chi riyin ri C'ajolaxel ri xinalex chicojol, can xipe c'a chiquicanoxic y chiquicolic ri ye sachnek pa mac, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Y tek ri Jesús rubin chic ka ronojel ri', ri winek c'a ri ye'ac'axan riche (rixin) ri Jesús, niquich'ob c'a chi tek Riya' xtoc apo ri pa tinamit Jerusalem, xtibetz'uye' ca pa k'atbel tzij y chanin xtibek'alajin pe ri rajawaren ri Dios. Y ruma chi queri' niquich'ob ri winek, y ruma chi xa nakaj chic yec'o wi apo chare ri tinamit Jerusalem, rumari' ri Jesús xuchop c'a rubixic jun c'ambel tzij chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y Riya' xubij c'a: Xc'oje' c'a jun achi ri nim ruk'ij. Ri achi ri' xbe c'a pa jun chic ruwach'ulef ri c'anej c'o wi, riche (rixin) chi ntoc pe rey. Y c'ac'ari' nitzolin chic pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yac'a tek c'a ma jane c'a tibe, xerusiq'uij (xeroyoj) ye lajuj rumozos y xuya' ca lajuj puek chique ri nibix mina chare, y xubij chique: Tic'uaj c'a re puek re xinya' ca chiwe riche (rixin) chi c'o nich'ec riq'ui, c'a achique tiempo xquitzolin pe riyin, xcha' ca chique, y xbe. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero ri achi ri' netzelex c'a cuma ri ruwinak, rumari' tek riya' c'o chic chupan ri ruwach'ulef ri acuchi (achique) c'o chi napon wi riche (rixin) chi niya'ox (nya') pe k'atbel tzij pa ruk'a' riche (rixin) chi ntoc pe rey, ri ye ruwinak xequitek c'a el achi'a' ri xe'apon ri c'a acuchi (achique) c'o wi riya' riche (rixin) chi xbequibij: Riyoj ma nikajo' ta chi re achi re' ntoc jun aj k'atbel tzij pa kawi', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Y xc'ulwachitej c'a chi tek xbetzolin pe riya', tek c'o chic pe ruk'ij ruc'ojlen, y tek c'o chic ri pa ruruwach'ulef, xutek c'a quisiq'uixic (coyoxic) ri rumozos ri ruya'on ca puek chique tek riya' c'a ma jane tibe. Queri' xuben ruma nrajo' nretamaj janipe' puek quich'acon chiquijujunal. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tek xapon c'a ri nabey mozo ri ruc'ulun ca puek ri nibix mina chare, xubij: Ajaf ri puek ri xaya' ca chuwe riche (rixin) chi c'o nch'ec riq'ui, can xinch'ec wi c'a lajuj chic riq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ri achi, rey chic ri tiempo ri', xubij c'a chare ri rumozo: Sibilaj utz ri xaben. Riyit can yit jun utzilaj numozo ri can naben wi ri nibix chawe. Y ruma c'a chi can utz xaben riq'ui ri juba' ri xinya' ca chawe, wacami c'a nya' lajuj tinamit pan ak'a' riche (rixin) chi nak'et tzij pa quiwi', xcha' ri rey. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y yac'ari' tek xapon jun chic mozo ri ruc'ulun ca chuka' puek ri nibix mina chare, y xubij: Ajaf, ri puek ri xaya' ca chuwe tek xabe, xinch'ec wu'o' puek más riq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ri rey xubij c'a chuka' chare ri jun mozo ri': Ruma c'a chi can utz xaben riq'ui ri juba' ri xinya' ca chawe, wacami c'a nya' wu'o' tinamit pan ak'a' riche (rixin) chi nak'et tzij pa quiwi', xcha' chuka' ri rey chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Yac'a tek xapon jun chic mozo ri ruc'ulun ca chuka' puek ri nibix mina chare, xubij: Ajaf, ya c'a arajil re' nonjacha' ca chawe. Re puek re' ximpis pa jun su't riche (rixin) chi xinyec. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ruma riyin nxibij wi' chawech. Ruma yit jun c'a'nlaj (c'a'elaj) achi. Riyit xa yit junan riq'ui jun achi ri nberuc'utuj pe rurajil y xa majun puek ruya'on ca chiri'. Y chuka' nawajo' nac'ul ri ntel pe chuwech ri tico'n ri xa ma riyit ta xatico ka, xcha' ri mozo chare ri rey. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ri rey xubij c'a chare ri mozo ri': Riyit xa yit jun itzel mozo. Ri tzij ri xabij yari' ri xtincusaj riche (rixin) chi nk'et tzij pan awi'. Ruma wi can awetaman chi riyin can yin c'a'nlaj (c'a'elaj) achi, chi riyin can nch'ojij wi nurajil ri acuchi (achique) xa majun nyacon ca, y chuka' can nwajo' nc'ul ri ntel pe chuwech ri tico'n ri xa ma yin ta riyin xitico ka; ");
INSERT INTO cakWNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","wi queri' nabij riyit, ¿achique c'a ruma tek ma xaya' ta re nurajil pa banco? Riche (rixin) chi queri' nc'ul ta c'a ri puek ri can wuche (wixin) riyin y nc'ul ta chuka' ral re nurajil re wacami re xitzolin pe, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ri rey xubij c'a chique ri yec'o chiri': Tiwelesaj c'a ca la puek pa ruk'a' re itzel mozo re', y tiya' chare ri utzilaj mozo ri c'o chic ri lajuj puek riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ri yec'o chiri' xquibij: Ajaf, pero ri utzilaj mozo c'o chic lajuj riq'ui, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero riya' xubij chique: Riyin nbij c'a chiwe, chi ri c'o q'uiy riq'ui, xtiya'ox (xtya') más chare y queri' q'uiy ri xtic'oje' riq'ui. Yac'a ri xa juba' oc c'o riq'ui, hasta ri juba' ri' xa xtelesex chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Wacami c'a, que'ic'ama' c'a pe ri ye'etzelan wuche (wixin), y ri ma xe'ajowan ta chi xinoc rey, y chinuwech riyin que'icamisaj wi, xcha' ri rey. Queri' xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y tek ri Jesús xtane' chubixic re' chiquiwech ri winek, xuchop chic c'a el bey chi xjote' pa Jerusalem, nabeynek el chiquiwech ri ye rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y tek xa nakaj chic c'a yec'o wi apo chique ri tinamit Betfagé y Betania, tinamit ri yec'o chunakajal ri juyu' Olivos, ri Jesús xerutek c'a el ye ca'i' chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Y xubij el chique: Quixbiyin apo chupan la aldea la nitzu' apo chila' y can xu (xe) wi xquixoc apo, xtiwil jun ti alaj bur ri ximil ca chiri' ri can c'a ma jane jun ch'ocolbeyon ta. Tiquira' c'a pe y nic'om c'a pe chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y wi c'o c'a jun xtibin pe chiwe chi achique ruma yixtajin niquir ri ti alaj bur, riyix tibij c'a ca chare chi nic'atzin chare ri Ajaf, xe'uche'ex el ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ri ca'i' discípulos ri xetak el, xebe c'a, y can xquil na wi ri ti alaj bur, can achi'el ri bin el chique ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yac'a tek yetajin chuquiric, ri ye rajaf xquibij pe chique: ¿Achique ruma tek niquir el? xecha' pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y ri ye rudiscípulos ri Jesús xquibij c'a ca chique ri ye rajaf ri ti bur: Xa nic'atzin chare ri Ajaf, xecha' ca chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquic'om pe chare ri Jesús. Y riye' xquiya' c'a chuka' quitziak chrij ri bur ri', y xquich'ocoba' c'a el ri Jesús chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y tek benak c'a ri Jesús, ri winek niquiriq'uila' c'a ka ri nima'k tak quitziak pa rubey riche (rixin) chi niquiya' ruk'ij. Y queri' ri niquibanala' ye benak. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yac'a tek xa ye'apon yan apo acuchi (achique) nuchop nixule' wi el ri bey chuwech ri juyu' Olivos, quinojel ri ye tzekelbey riche (rixin) ri Jesús ri ye benak, ruma niquicot ri cánima, xquichop c'a niquirek quichi' chuya'ic ruk'ij ri Dios. Niquiya' c'a ruk'ij ri Dios ruma ye quitz'eton ri milagros ri ye rubanalon ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Riye' niquibij c'a: ¡Re Rey re' can banon pe bendecir ruma ri Ajaf Dios, y can pa rubi' ri Ajaf Dios petenak wi! ¡Uxlanibel c'u'x c'a ri chila' chicaj! ¡Jani' na niya'ox (nya') ruk'ij ruc'ojlen ri Dios ri chila' chicaj! yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chiri' chiquicojol ri winek, ye benak c'a nic'aj achi'a' fariseos. Y riye' xquibij c'a chare ri Jesús: Tijonel, que'ak'ila' ri ye adiscípulos, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yac'ari' tek ri Jesús xubij chique: Can kitzij c'a nbij chiwe, chi xa ta yetane' ka riye', ye ri abej xquebech'o pe riche (rixin) chi niquiya' nuk'ij, xcha' chique ri fariseos. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y tek nakaj chic c'o wi apo ri Jesús chare ri tinamit Jerusalem, xutz'et c'a apo ri tinamit ri' y xuchop nrok'ej ruwech, ");
INSERT INTO cakWNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xubij c'a: Riyix ri yixc'o pa Jerusalem, astape' c'a ya k'ij re' nik'ax ta chiwech achique ri niya'o uxlanibel c'u'x chiwe. Pero xa ewatajnek chiwech, y rumari' ma yixcowin ta nitz'et. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ruma xtapon na k'ij tek xtipe k'axon pan iwi', k'ij tek ri achi'a' ye banoy tak ch'a'oj xquebeyacatej pe chiwij, y xtiquisutij rij ri itinamit y xtiquiben achi'el jun coral chiwij. Xquixquiya' pa quinic'ajal y xquixc'oje' pa tijoj pokonal. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xtiquikasaj c'a pan ulef ri itinamit iwachibilan riyix. Y chare ri itinamit majun c'a jay ri xtipa'e' ta ca. Ronojel ronojel xquewulex. Ruma chi can ma xiya' ta pa cuenta chi ri Dios xoka yan iwuq'ui re tiempo re', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Y tek ri Jesús aponak chic c'a, Riya' xoc c'a pa rachoch ri Dios ri c'o chiri' pa Jerusalem. Yac'ari' tek Riya' xerokotala' pe ri yetajin yec'ayin y ri yelok'onaj ri chiri' pa rachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xubij c'a chuka' chique: Chupan ri ruch'abel ri Dios ri tz'ibatal ca, nubij chi ri wachoch, jay riche (rixin) oración. Yac'a riyix xa achi'el jul quiche (quixin) alek'oma' ibanon chare, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y yac'ari' tek ri Jesús k'ij k'ij yerutijoj ri winek riq'ui ri ruch'abel ri Dios, chiri' chupan ri rachoch ri Dios. Pero ri principali' tak sacerdotes ye cachibilan ri aj tz'iba' y ri achi'a' ri can c'o wi quik'ij chupan ri tinamit, niquicanola' c'a achique ta rubanic niquiben riche (rixin) chi queri' niquicamisaj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y ma niquil ta c'a achique niquiben chare, ruma chi ri winek can benak cánima chirac'axaxic ri nubij ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Y xbanatej c'a chi jun chique ri k'ij tek ri Jesús c'o ri pa rachoch ri Dios ntajin nuc'ut y nutzijoj ri lok'olaj ch'abel ri niya'o colotajic chiquiwech ri winek, yac'ari' tek ri principali' tak sacerdotes, ri aj tz'iba' ye cachibilan ri rijita'k tak achi'a' ri c'o quik'ij xe'oka riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y ri achi'a' ri' xquibij c'a chare ri Jesús: Tabij c'a chake: ¿Achique chi k'atbel tzij c'o pan ak'a' riche (rixin) chi xe'awokotaj el ri winek ri yec'ayin wawe' pa rachoch ri Dios? ¿Y achique chuka' xya'o ri k'atbel tzij ri' pan ak'a' chi ye'abanala' quere'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xubij c'a chique: Riyin c'o c'a chuka' jun ri nwajo' nc'utuj chiwe. Tibij c'a chuwe: ");
INSERT INTO cakWNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ri Juan xtak pe ruma ri Dios riche (rixin) chi xeruben bautizar ri winek? ¿O xa ye ri winek xebin chare chi xuben queri'? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yac'a ri principali' tak sacerdotes, ri aj tz'iba' y ri rijita'k tak achi'a' ri c'o quik'ij, xquibila' c'a chiquiwech: ¿Achique c'a xtikabij chare wacami? xecha' ka. Ruma wi nikabij chi ri Juan ya ri Dios ri takayon pe, ri Jesús xa xtubij c'a chake chi achique c'a ruma tek ma xinimaj ta ri xubij. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y wi nikabij chi xa winek xebin chare ri Juan chi xuben queri', xquepe quinojel ri winek y xkojquiq'uek chi abej. Ruma chi ri winek can quetaman wi chi ri Juan can jun chique ri profetas ri xek'alajsan ri ruch'abel ri Dios, xecha' c'a ka chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Yac'ari' tek xquibij apo chare ri Jesús chi ma quetaman ta achique xbin chare ri Juan chi xeruben bautizar ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xubij c'a chique ri achi'a' ri': Ruma c'a chi riyix ma xixcowin ta xibij chuwe, queri' c'a chuka' riyin ma xtinbij ta chiwe achique yayon k'atbel tzij pa nuk'a' chi yicowin yenbanala' quere', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y ri Jesús xuchop c'a rubixic jun c'ambel tzij chique ri winek, y xubij c'a: Xc'oje' c'a jun achi ri xutic ruwech ri rulef riq'ui uva. Y c'ac'ari' xuya' ca pa kajic chique ca'i' oxi' mozos. Y riya' xbe el riche (rixin) q'uiy tiempo. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y ri rajaf ri ulef ri' xutek c'a jun rumozo quiq'ui ri achi'a' ri ye kajayon ri ulef, tek can ruk'ijul chic riche (rixin) chi niquiya' ri uva kajbel riche (rixin) ri ulef. Yac'a tek xapon ri mozo quiq'ui ri achi'a' ri ye kajayon ri ulef, ri kajoy tak ulef ri' xquichop c'a ri mozo y xquich'ey, y majun c'a uva xquiya' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y ri rajaf ri ulef xutek chic jun rumozo chuc'amaric ri uva kajbel riche (rixin) ri ulef. Pero ri achi'a' kajoy tak ulef xa xquichop y xquich'ey. Q'uiy c'a pokon ri xquibanala' y xquibila' el chare, y majun chuka' uva kajbel riche (rixin) ri ulef xquiya' ta el chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Yac'a ri rajaf ri ulef xutek chic c'a el jun rumozo chuc'amaric ri uva kajbel riche (rixin) ri ulef, pero can queri' chuka' xuc'ulwachij. Xquisocola', y c'ac'ari' xcokotaj el. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Y pa ruq'uisbel c'a, ri rajaf ri ulef xuch'ob ka: ¿Achique c'a xtintek el? xcha'. Y riya' c'o c'a jun ruc'ajol ri sibilaj nrajo', y yac'ari' ri xutek el chuc'amaric ri kajbel riche (rixin) ri ulef. Ruma ri rajaf ri ulef ri' xuch'ob chi ri achi'a' ri ye kajayon ri rulef, riq'ui juba' can xqueniman wi chare ri ruc'ajol tek xtiquitz'et chi can ya riya' ri napon quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Yac'a ri achi'a' ri ye kajayon ri ulef, can xu (xe) wi xquitz'et chi ya ri ruc'ajol ri rajaf ri ulef ri xapon, xquibila' c'a chiquiwech: Yare' ri xtoc ca rajaf ronojel re ulef re kakajon. Wacami quixam pe, tikacamisaj riche (rixin) chi queri' re ulef re' ntoc ca kiche (kixin) riyoj, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y can queri' wi c'a xquiben. Xquelesaj c'a el ri c'ajolaxel chiri' chupan ri rulef y xquicamisaj. Yac'ari' tek ri Jesús xubij: ¿Achique cami xtuben ri rajaf ulef chique ri achi'a' kajoy tak ulef? ");
INSERT INTO cakWNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ri rajaf ri ulef xtipe c'a y xquerucamisaj ri kajoy tak ulef ri' y ri rulef xtuya' chic ca pa kajic chique nic'aj chic, xcha' ri Jesús. Tek ri winek quic'axan chic ka ri c'ambel tzij ri', xquibij: Dios ta c'a xkojto'o chi man ta xtibanatej queri', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y ri Jesús xerutzu' c'a ri winek, y xubij: ¿Achique cami ntel wi chi tzij ri nubij chupan ri ruch'abel ri Dios ri tz'ibatal ca? Tek nubij: C'o c'a jun abej ri ma xka ta chiquiwech chi xquicusaj ri nic'aj aj banoy tak jay. Pero re abej re' xa can c'o wi xucusan chare ri xquina riche (rixin) ri jay, riche (rixin) chi ri jay ri' ma nitzak ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y xabachique c'a winek ri xtitzak chuwech re jun abej re', can xtuquiraj ri' chuwech. Y xabachique c'a winek ri xtika ri abej ri' chrij, can xtic'ajtej c'a, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y ri principali' tak sacerdotes, y ri aj tz'iba', can yac'ari' tek riye' can ta c'o xcajo' chi xquichop ta el ri Jesús, ruma xquinabej chi ri achi'a' kajoy tak ulef ri xerunataj chupan ri c'ambel tzij, xa chiquij riye' xch'o wi. Pero ma xquichop ta el, ruma niquixibij qui' chiquiwech ri winek ri yec'o riq'ui. Y xebe. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Y ri principali' tak sacerdotes y ri aj tz'iba' ri' xequitek c'a pe nic'aj chic achi'a' ri can choj ri quic'aslen nik'alajin, pero xa ma ye que ta ri'. Queri' xquiben ruma chi can nicajo' chi ri Jesús nitzak ta pa quik'a' riq'ui ri ch'abel ri nubij. Y wi can nika c'a pa quik'a', niquiya' pa ruk'a' ri aj k'atbel tzij. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y riche (rixin) c'a chi nitzak ta ri Jesús pa quik'a', ri achi'a' ri' xquic'utuj c'a chare: Riyit ri can yit jun Tijonel, riyoj can ketaman wi chi can kitzij ri natzijoj. Ma naxibij ta awi' chuwech jun winek, astape' c'o ruk'ij. Y can nac'ut wi ri bey riche (rixin) ri Dios chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Achique nabij riyit? ¿La ruc'amon cami chi nikatoj ri alcawal ri nubij ri César ri c'o chi nikatoj, o xa ma ruc'amon ta? xecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yac'a ri Jesús can retaman wi c'a ri niquich'ob chrij. Rumari' Riya' xubij c'a chique: ¿Achique c'a ruma riyix nitij ik'ij riche (rixin) chi yinitojtobej? ");
INSERT INTO cakWNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'utu' c'a pe jun puek, xcha'. Y ri Jesús xuc'utuj c'a: ¿Achoj ruwachbel la'? ¿Y achoj rubi' chuka' la c'o chuwech la puek? xcha' chique. Y riye' xquibij chare: Riche (rixin) ri César, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xubij c'a chique: Can tiya' c'a chare ri César ri can riche (rixin) wi ri César. Y can tiya' c'a chare ri Dios, ri can riche (rixin) wi ri Dios, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y ri achi'a' ri xec'utun chare ri Jesús, man c'a xech'acon ta chrij chiquiwech ri winek, ruma chi ri Jesús ronojel tzij pa ruchojmil c'a yerubila' chique. Y ri achi'a' ri' can xquimey c'a tek xquic'axaj ri xubij ri Jesús chique. Y rumari' ma xech'o ta chic apo. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y yac'ari' tek nic'aj chique ri achi'a' saduceos xe'apon riq'ui ri Jesús ruma c'o nicajo' niquic'utuj chare. Ri achi'a' ri' ma niquinimaj ta c'a chi ri caminaki' can xquec'astej chic pe. Y rumac'ari' riye' xquibij chare ri Jesús: ");
INSERT INTO cakWNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Riyit ri can yit jun Tijonel, c'o c'a jun ri nikajo' nikac'utuj chawe. Ri Moisés can rutz'iban wi c'a ca chake chi tek jun achi nicom el y majun ralc'ual nic'oje' ca riq'ui ri rixjayil, can jun c'a rach'alal ri achi ri' c'o chi nic'ule' riq'ui ri ixok ri xmalcanij ca, riche (rixin) chi queri' yec'oje' ta ralc'ual riq'ui ri ixok ri'. Y ri nabey ti c'ajol (ala') ri nalex ntoc ralc'ual ri caminek chic el. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y riye' xquibij c'a: Xec'oje' c'a ye wuku' achi'a' cach'alal qui'. Y xbanatej c'a chi ri nimalaxel xc'ule', pero ri achi ri' xcom el, y majun ralc'ual xc'oje' ta ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xpe ri ruca'n achi, ri rach'alal ca ri achi ri caminek chic el, xc'ule' c'a riq'ui ri malca'n ixok. Pero chuka' ri achi ri' xcom el, y majun ralc'ual xc'oje' ta ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri rox achi xc'ule' c'a chuka' riq'ui ri malca'n ixok, pero can achi'el ri xquic'ulwachij el ri ye ca'i' nabey rach'alal, can queri' c'a chuka' xuc'ulwachij el riya'. Y chi ye wuku' achi'a' cach'alal qui' queri' xquic'ulwachila' el. Y majun c'a chique ri ye wuku' achi'a' ri' ri xec'oje' ta ca ralc'ual. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisbel xcom chuka' el ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y ri achi'a' saduceos xquibij c'a chare ri Jesús: Riyit nabij chi xtapon na jun k'ij tek ri caminaki' xquec'astej pe. Tek xtapon c'a ri k'ij ri', ¿achoj rixjayil c'a xtoc wi ri ixok ri'? Ruma chi ye wuku' achi'a' cach'alal qui' xec'oje' riq'ui, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús can yac'ari' tek xubij chique: Chuwech re ruwach'ulef, ri achi nic'oje' rixjayil y ri ixok nic'oje' rachijil ruma c'a c'o na c'ulanen nibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yac'a ri ye caminek chic el ri can ruc'amon (takal chiquij) chi yebe chila' chicaj, tek xtapon ri k'ij chi xquec'astej el chiquicojol ri caminaki', ri achi ma xtic'oje' ta chic rixjayil y ri ixok ma xtic'oje' ta chic rachijil, ruma can majun chic c'ulanen xtibanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Y chuka' ri camic can ma xtapon ta chic quiq'ui, ruma xque'oc achi'el ri ángeles y chuka' ye ralc'ual ri Dios ruma ye c'astajnek chic el. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yac'a ri c'astajbel quiche (quixin) ri caminaki', can c'o wi. Ri Moisés rutz'iban ca chupan ri ruch'abel ri Dios, tek riya' xutz'et chi nic'at ri juwi' k'ayis ri c'o ruq'uixal, y xrac'axaj tek xubij ri Ajaf Dios: Yin c'a riyin ri ru-Dios ri Abraham, ri ru-Dios ri Isaac, y ri ru-Dios chuka' ri Jacob, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ruma ri Dios ma Dios ta quiche (quixin) caminaki', xa can Dios quiche (quixin) ri can c'o quic'aslen. Rumac'ari' chuwech ri Dios riye' can ye q'ues wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y yec'o c'a nic'aj chique ri aj tz'iba' ri xquibij chare ri Jesús: Tijonel, can kitzij wi ri xabij, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y yac'ari' tek can majun chic ri xbano cowil chi c'o ta ri xquic'utuj apo chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yac'ari' tek ri Jesús xubij c'a chique: ¿Achique c'a ruma tek ri winek niquibij chi ri Cristo xa choj jun ralc'ual ca ri rey David? ");
INSERT INTO cakWNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Tek xa can ya ri rey David tz'ibayon ca chupan ri wuj ri Salmos rubi', tek xubij: Ri Dios xubij chare ri Wajaf: Catz'uye' re pa wajquik'a', ");
INSERT INTO cakWNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","c'a ya tek xquenya' na pan ak'a' pan awaken ri ye'etzelan awuche (awixin). Queri' ri rutz'iban ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y wi ri rey David Wajaf xcha' chare ri Cristo, ¿achique c'a ruma tek ri winek niquibij chi ri Cristo xa choj jun ralc'ual ca ri rey David? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y quinojel c'a ri winek ri quimolon qui' chiri', xquic'axaj tek ri Jesús xubij chique ri rudiscípulos: ");
INSERT INTO cakWNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Man c'a tiben ta achi'el niquiben ri achi'a' ye aj tz'iba'. Ruma riye' sibilaj nika chiquiwech niquicusaj tukutek tak tziek, riche (rixin) chi queri' nitz'et chi can c'o quik'ij. Sibilaj chuka' nika chiquiwech chi niya'ox (nya') rutzil tak quiwech ri pa tak c'aybel. Y ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios, can ya c'a ri nabey tak ch'aquet yequicanola', riche (rixin) chi queri' nibix chi riye' c'o quik'ij. Y can queri' chuka' yequibanala' ri pa nima'k tak wa'in. ");
INSERT INTO cakWNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y yequelesala' chuka' ronojel quicosas ri malcani' tak ixoki'. Y xaxu (xaxe wi) riche (rixin) chi can quenimex chi riye' can ye utzilaj tak winek, yeyaloj tek niquiben orar. Pero riye' can xtik'ax ruwi' ri ruc'ayewal ri xtika pa quiwi', ruma sibilaj q'uiy quimac, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri chiri' c'a ri pa rachoch ri Dios, ri Jesús xerutz'et c'a chi ri winek beyoma' niquiyala' ca ofrenda ri acuchi (achique) niyalox wi ca ri ofrenda chiri' pa rachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y queri' c'a chuka' xutz'et chi jun malca'n ixok ri can nik'alajin chi ma beyon ta, xuya' ca ca'i' tak puek ri ma rubanon ta ni jun centavo. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y tek ri Jesús xutz'et ri jun malca'n ixok ri', xuc'ut c'a chiquiwech ri ye rudiscípulos, y xubij chique: Can kitzij c'a nbij chiwe, chi riyin ntz'et chi xa ya la ixok la' ri xya'o ca más q'uiy que chiquiwech quinojel ri ye yayon ca puek. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ruma riya', astape' xa ti meba', xa can xuya' c'a ca ronojel ri c'o riq'ui, astape' xa can yari' nic'atzin chare riche (rixin) chi nutzukbej ri'. Yac'a ri beyoma', astape' sibilaj q'uiy puek xquiyala' ca, xa juba' oc chare ronojel ri beyomel ri c'o quiq'ui ri xquiyala' ca, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y yec'o c'a ri quichapon tzij chrij achique rubanic ri rachoch ri Dios. Y niquibila' c'a chi sibilaj jabel rubanic, chi ruyon jabel tak abej ri ye ucusan chare, y chi ronojel ri wikbel, ruyon ofrenda quiche (quixin) ri winek, xecha'. Y ri Jesús xubij c'a chique: ");
INSERT INTO cakWNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xtapon na jun k'ij tek ronojel re nitz'et wawe' xquewulex y majun chic ri xtipa'e' ta ca. Ronojel re nima'k tak abej re ye ucusan chare re jay re', xa can xquewulex c'a pe. Can majun c'a abej ri xtic'oje' ta ca achi'el la rubanon wacami, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ri discípulos xquic'utuj c'a chare ri Jesús: Tijonel, ¿ajan (jampe') c'a xtic'ulwachitej ri xabij yan ka chrij ri rachoch ri Dios? ¿Y achique c'a retal nibanatej tek xa yec'ulwachitej yan ri'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y ri Jesús xubij chique: Can jabel c'a tichajij iwi' riche (rixin) chi ma xquixk'olotej ta. Ruma can ye q'uiy ri xquepe y xtiquibila': Yin c'a riyin ri Cristo, xquecha'. Ya tiempo re' xoka, xquecha'. Yac'a riyix ma que'inimaj ta, ni ma que'itzekelbej ta chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y tek xtiwac'axala' c'a chi yec'o ruwach'ulef ri c'o ch'a'oj ntajin chiquicojol o ri winek yeyacatej chiquij ri aj k'atbel tak tzij pa quitinamit, man c'a tixibij ta iwi', ruma nabey can c'o chi nibanatej na queri', pero xa ma ya ta ri' ri ruq'uisbel tak k'ij chare re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y ri Jesús xubij c'a chuka': Jun tinamit xtiyacatej c'a el chi nberubana' ch'a'oj riq'ui jun chic tinamit. Yec'o c'a chuka' nima'k tak ruwach'ulef ri xqueyacatej c'a el chi nbequibana' ch'a'oj quiq'ui nic'aj chic nima'k tak ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xquepe nima'k tak silonel, xabachique lugar chare re ruwach'ulef, xquepe wayjal y yabil. Xtuya' c'a jun nimalaj xibinri'il ri xquebanatej y xquetz'etetej chuwech ri caj ri majun bey ye tz'eton ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Y tek ma jane nibanatej ta ronojel ri', riyix xquixchapatej y xtiban c'a chiwe chi xtik'axaj tijoj pokonal ruma ri ruch'abel ri Dios. Xquixuc'uex c'a chiquiwech ri principali' ri pa tak jay ri kas nic'ut wi ri ruch'abel ri Dios. Xquixtz'apix pa cárcel. Xquixuc'uex chiquiwech aj k'atbel tak tzij; chiquiwech reyes y nic'aj chic aj k'atbel tak tzij. Ronojel c'a ri' xtic'ulwachila' ruma ic'uan ri nubi' riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y tek queri' c'a xtiban chiwe cuma ri winek, yac'ari' tek xquixcowin xquinik'alajsaj chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y can tic'oje' c'a pa tak iwánima chi ma rajawaxic ta chi nich'ob más achique chi ch'abel ri c'o chi xtibij riche (rixin) chi nito' iwi', ");
INSERT INTO cakWNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ruma can yin c'a riyin ri xquiya'o ch'abel chiwe. Y xtinya' chuka' na'oj chiwe riche (rixin) chi queri', riq'ui ri na'oj ri' xtik'il quichi' ri ye'etzelan iwuche (iwixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y xquixjachalox c'a pa quik'a' ri ye'etzelan iwuche (iwixin). Y riq'ui juba' hasta ri ite' itata', ri iwach'alal o can ye ri iwachibil ri xquejacho iwuche (iwixin). Y yec'o c'a jojun chiwe riyix ri can xquecamisex. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Xa can xquixetzelex wi c'a cuma quinojel, ruma icukuban ic'u'x wuq'ui riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man c'a tixibij ta iwi', ruma ri Dios can yixruchajij yixruwaraj, y ni xa ta jun ti rusmal iwi' ri xtitzak ta ca chak ta queri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y riq'ui c'a ronojel coch'onic, xtiwil c'a ri utzilaj c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y tek xtitz'et c'a chi ri tinamit Jerusalem sutin chic rij cuma achi'a' ye banoy tak ch'a'oj, tiwetamaj c'a ri' chi xa juba' chic tiempo nrajo' riche (rixin) chi ri tinamit xtiwulex. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Rumari', riyix ri yixc'o pa ruwach'ulef Judea, quixanmej c'a el y je'iwewaj iwi' ri pa tak juyu'. Y wi pa tinamit Jerusalem yixc'o wi, quixanmej c'a pe chupan. Y wi pa tak juyu' yixc'o wi, man chic c'a quixtzolin ta apo ri pa tinamit. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ruma tek xtapon c'a ri k'ij riche (rixin) ri tijoj pokonal, yac'ari' tek ri tinamit ri' xtuc'ul rutojbalil ronojel ri ye rubanalon pe, y can xtibanatej c'a ronojel ri tz'ibatal ca chupan ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Yac'a ri ixoki' ri coyoben chic alanen, y ri ixoki' ri xa c'a yetz'uman na ri tak cal, juyi' c'a oc quiwech tek xtapon ri k'ij ri'. Ruma chi chupan ri k'ij ri' can xtik'ax ruwi' ri tijoj pokonal ri xtipe pa ruwi' re ruwach'ulef, y can xtika wi c'a ri royowal ri Dios pa ruwi' re tinamit re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sibilaj ye q'uiy c'a winek ri xquecamisex tzan espada cuma ri achi'a' ye banoy tak ch'a'oj. Y ri nic'aj chic chique ri winek xque'uc'uex preso cuma ri achi'a' ye banoy ch'a'oj. Xque'uc'uex c'a pa nic'aj chic ruwach'ulef. Y re tinamit Jerusalem xtixak' c'a chi aken cuma winek ri xa ma ye israelitas ta, c'a ya tek xtitz'aket na ri tiempo ri xtic'oje' pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y q'uiy c'a ri majun bey ye banatajnek ta y majun bey ye tz'eton ta ri xquec'ulwachitej chuwech ri k'ij, ri ic' y ri ch'umila'. Y ri winek c'a ri yec'o chuwech re ruwach'ulef ma xtiquil ta chic achique xtiquiben, xa xtisach quic'u'x ruma chi ri mar, can xtik'ax c'a ruwi' xtik'ajan, ruma sibilaj xtibolko't ri ruwi' ya'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y ri winek ruma chi can coyoben c'a ri achique xtic'ulwachitej chuwech re ruwach'ulef, xtipe quicamic ruma ri xibinri'il ri'. Ruma hasta ronojel ri nimalaj tak uchuk'a' ri yec'o chila' chicaj xquesilon na ruma ri ruchuk'a' ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y yac'ari' tek xquinitz'et riyin ri C'ajolaxel ri xinalex chicojol, chi yin petenak pa jun sutz', riq'ui chic nimalaj wuchuk'a' y riq'ui chuka' jun nimalaj nuk'ij nuc'ojlen, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y riyix, tek xtitz'et chi ronojel ri' yec'ulwachitej chic, quixquicot y tic'oje' el más iwuchuk'a', ruma chi can napon yan ri k'ij riche (rixin) chi yixcolotej el chuwech ronojel tijoj pokonal riche (rixin) re ruwach'ulef, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Y yac'ari' tek Riya' xubij chuka' jun c'ambel tzij chique: Titzu' na pe' ri juwi' che' ri higo rubi'. O xabachique chic chi che'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Tek xa can niquichop yeq'uiy pe ri ruxak, iwetaman c'a ri' chi ya xa nik'ax yan ruk'ijul ri sak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y quec'ari' tek xtitz'et chi yec'ulwachitej chic y yebanatej chic ronojel ri xinbij yan ka, tiwetamaj c'a ri' chi xa noka yan ri rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Y tiwac'axaj c'a jabel re xtinbij chiwe re wacami: Ronojel ri' xtic'ulwachitej, tek c'a ma jane queq'uis ta el ri winek riche (rixin) re tiempo re kachapon. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Y re ruwach'ulef y ri caj xa xquek'ax. Yac'a ri nuch'abel ma xtiq'uis ta chak que ta ri', xa can xtibanatej na wi ri nubij. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Y tichajij c'a ri ic'aslen. Ma xaxu (xaxe) ta wi chrij ri wa'in tibe wi ri iwánima, y tichajij ri ic'aslen chi ma quixk'aber ta; y chuka' ma xaxu (xaxe) ta wi ri nic'atzin chiwe chuwech re ruwach'ulef ri nich'ob, y xa c'a tek xtina', xa yari' xoka ri k'ij riche (rixin) chi riyin xquinoka. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Queri' nbij chiwe ruma xa xtoka achi'el tika jun trampa. Queri' rubanic tek xtoka pa quiwi' quinojel ri winek ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rumac'ari' can quiniwoyobej apo chi pak'ij chi chak'a' y ma quixwer ta ka. Y chuka' can tibana' orar, riche (rixin) chi yixcolotej chuwech ronojel ri tijoj pokonal ri xtipe pa ruwi' re ruwach'ulef, y riche (rixin) chuka' chi utz yixapon c'a chinuwech riyin ri C'ajolaxel ri xinalex chicojol, xcha' ri Jesús chique ri ye rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Y ri pak'ij, ri Jesús nic'oje' c'a chiri' pa rachoch ri Dios, yerutijoj ri winek riq'ui ri ruch'abel ri Dios. Y ri chak'a' nibe el y nbec'oje' ri pa juyu' ri Olivos rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y ruma c'a chi ri Jesús nutzijoj ri ruch'abel ri Dios ri chiri' pa rachoch ri Dios, can ye q'uiy c'a winek ri ye'apon nimak'a' yan riche (rixin) chi niquic'axaj. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Y tek xa nakaj chic c'a ri quinimak'ij ri israelitas ri nibix pascua chare, jun nimak'ij tek niquitij caxlan wey ri majun ch'om (levadura) riq'ui, ");
INSERT INTO cakWNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","can yac'ari' tek ri principali' tak sacerdotes y ri aj tz'iba' niquich'obola' c'a achique ta rubanic niquiben riche (rixin) chi queri' niquicamisaj ri Jesús. Queri' niquiben ruma xa quixibin qui' chiquiwech ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y ri Judas ri jun chique ri cablajuj rudiscípulos ri Jesús, ri xbix chuka' Iscariote chare, can oconek chic ri Satanás pa ránima. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Rumari' ri Judas xbe c'a quiq'ui ri principali' tak sacerdotes y quiq'ui chuka' ri c'o quik'ij chique ri ye chajinel ri chiri' pa rachoch ri Dios, y xch'o quiq'ui chrij chi achique rubanic xtuben riche (rixin) chi nujech ri Jesús pa quik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y riye' can sibilaj xequicot tek xquic'axaj ri', y xquitzuj (xquisuj) puek chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Y ri Judas xubij c'a chique chi can xtujech ri Jesús pa quik'a'. Y xuchop c'a ruch'obic chi achique ta rubanic nuben chi xtujech pa quik'a' ri achi'a' ri', y xuch'ob chi nujech tek majun winek quimolon ta qui' riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tek xapon ruk'ijul ri nimak'ij, tek ri israelitas niquitij ri caxlan wey ri majun ch'om (levadura) riq'ui, y tek yecamisex chuka' ri tak carne'l riche (rixin) ri pascua, ");
INSERT INTO cakWNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ri Jesús xerutek c'a el ri Pedro y ri Juan, y xubij c'a el chique: Quixbiyin y tibana' ruchojmil ri xtikatij chupan re pascua re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y ri ca'i' discípulos xquic'utuj c'a chare: ¿Acuchi (achique) c'a nawajo' chi nikaben wi ruchojmil? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xubij chique: Tek xquixapon ri pa tinamit Jerusalem, xtitz'et c'a chi c'o jun achi ri ruc'amom pe ya' pa jun cucu'. Titzekelbej c'a el ri achi ri' c'a achique jay xtoc wi. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y tibij c'a chare ri tata'aj chupan ri jay ri': Ri Katijonel rubin c'a pe: ¿Acuchi (achique) c'o wi jun jay ri jamel chare ri awachoch ri utz riche (rixin) chi nben ri wa'in riche (rixin) re pascua ye wachibilan ri nudiscípulos? quixcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y ri rajaf ri jay xquixruc'uaj c'a pa jun ruca'n tanaj (wik) chare ri jay. Y chiri' c'o jun nimajay ri chojmirisan chic rupan. Ya ri chiri' tibana' wi ruchojmil ri xtikatij chupan re pascua, xe'uche'ex el. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y ri ca'i' discípulos xebe c'a. Y can achi'el ri rubin el ri Jesús chique, can queri' ri xbanatej. Y riye' can xquiben wi c'a ruchojmil ronojel ri nic'atzin chare ri wa'in chupan ri pascua ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y tek xapon c'a ri hora, ri Jesús y ri cablajuj apóstoles xetz'uye' apo ri pa mesa. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xubij c'a chique: Can nrayin pe chi tek c'a ma jane yinapon ta chuwech ri camic, junan nikaben re jun wa'in riche (rixin) re jun pascua re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ruma can nbij wi c'a chiwe, chi majun bey xtinben ta chic re wa'in re', c'a ya tek banatajnek chic ronojel pa rajawaren ri Dios ri nuc'ut re jun wa'in re'. Can c'a yac'ari' tek xtinben chic re wa'in re'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y ri Jesús xuchop c'a jun vaso ri c'o ruya'al uva chupan, y tek rumatioxin chic chare ri Dios, xubij: Tikumu' c'a ca chi'iwonojel. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ruma can nbij wi c'a chiwe, chi can c'a ya tek c'o chic na ri rajawaren ri Dios, can yac'ari' tek xtinkum chic jun bey ri ruya'al uva, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y queri' c'a chuka' xuc'om apo jun caxlan wey, y tek rumatioxin chic chare ri Dios, c'ac'ari' xuwech'ela' ri caxlan wey ri' y xuya' chique ri rudiscípulos y xubij: Yac'are' ri nuch'acul ri xtijach pa camic, riche (rixin) chi yixcolotej. Tibana' c'a re' riche (rixin) natabel wuche (wixin) riyin. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y tek ye waynek chic, ri Jesús xuchop c'a chuka' ri vaso ri c'o ruya'al uva chupan, y xubij: Re ruya'al uva re', yac'are' ri nuquiq'uel ri xtibiyin tek xquicamisex. Riq'ui c'a ri xtibiyin ri nuquiq'uel, can yac'ari' tek xtic'achoj ri c'ac'ac' trato ri rajowan pe ri Dios chi nuben quiq'ui ri winek. Ri nuquiq'uel ri xtibiyin, iwuma riyix riche (rixin) chi yixcolotej. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y wacami c'a, ri achi ri xquijacho el pa quik'a' ri winek, can c'o c'a pe wuq'ui re pa mesa. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can tiwac'axaj c'a re nbij chiwe, chi riyin ri C'ajolaxel ri xinalex chicojol, can xquicamisex na wi, ruma can yare' ri ruch'obon pe ri Dios chi nibanatej. Pero juyi' c'a ruwech ri xtijacho el wuche (wixin), xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y yac'ari' tek ri ye rudiscípulos ri Jesús niquibila' ka chiquiwech chi achique cami ri xtijacho el riche (rixin) ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y ri discípulos ri' xquichop c'a yech'ojin pa ruwi' chi achique ri más nim ruk'ij chiquicojol riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yac'a ri Jesús xa xubij chique: Ri aj k'atbel tak tzij riche (rixin) re ruwach'ulef, ruma can c'o quik'atbel tzij pa quiwi' ri winek, rumari' can niquina' chi can yec'a riye' ri ye c'ajaf ri winek, y nicajo' chi nibix chique chi ye aj banoy tak utzil. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Yac'a ri chicojol riyix jun wi chic. Ruma ri nrajo' chi nic'oje' ruk'ij chicojol, xa tubana' chi ya riya' ri más co'ol que chiquiwech ri nic'aj chic. Y ri nrajo' chi ntoc jun c'amol bey chicojol riyix, xa yari' ri tuch'utinirisaj ri', querunimaj querilij ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Rumac'ari', ¿achique ri más c'o ruk'ij, ya ri tz'uyul pa mesa, o ya ri niya'o apo pa ruwi' mesa ronojel ri nitij? Can ya wi ri tz'uyul pa mesa ri c'o más ruk'ij. Pero riyin ma que ta ri' nben, ruma riyin yinc'o chicojol ri xa yin achi'el jun ri niniman nilin apo pa mesa. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Pero riyix can yixc'o pe wuq'ui chupan ri tijoj pokonal ri ye nk'axan pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rumac'ari', riyin xtinya' jun k'atbel tzij pan ik'a' riyix, can achi'el ri rubanon ri Nata' Dios wuq'ui riyin, ");
INSERT INTO cakWNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","riche (rixin) chi queri' xquixwa' y xquixuc'ya' wuq'ui pa numesa ri pa nujawaren. Y riyix xquixtz'uye' na pa tek ch'aquet riche (rixin) chi nik'et tzij pa quiwi' ri cablajuj tinamit ri yec'o pa rucuenta ri Israel. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y ri Ajaf Jesús xubij c'a chuka' chare ri jun rudiscípulo ri nibix Pedro chare: Simón, Simón, nbij c'a chawe chi ri Satanás xixruc'utuj chare ri Dios riche (rixin) chi yixrutojtobej. Can nrajo' c'a yixruchayuj achi'el nichayux ri trigo chupan jun chuybel. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero riyin can nbanon wi orar pan awi' riyit, riche (rixin) chi queri' can nacukuba' ac'u'x wuq'ui. Can xcatapon wi pa ruk'a' ri Satanás. Pero tek xtitzolin pe ac'u'x wuq'ui, tabana' chique ri nic'aj chic awach'alal chi can niquicukuba' quic'u'x wuq'ui, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xubij: Ajaf, wi riyit xcatuc'uex pa cárcel, yibe awuq'ui. Hasta yibe awuq'ui, wi riyit xcatapon pa camic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yac'a ri Jesús xubij chare: Pedro, riyin nbij c'a chawe, chi chupan re jun ak'a' re wacami, c'a ma jane tisiq'uin ta pe ri ec', tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech, xcha' ri Jesús chare ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y ri Jesús xuc'utuj c'a chique ri ye rudiscípulos: Tek xixintek y ma xinwajo' ta chi xic'uaj yabel irajil, ni ya'l, ni jun chic c'ulaj ixajab, ¿la c'o cami ri xiwajo' y man ta xiwil? xcha' chique. Y riye' xquibij: Majun ri man ta xkil, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y ri Jesús xubij c'a chique: Yac'a re wacami jun wi chic ri rubanic nrajo' chi niben. Ruma wacami ri c'o yabel rurajil y c'o ruya'l, tuc'uaj. Y ri majun ru'espada, tuc'ayij ri ruchaqueta y c'ac'ari' tulok'o' jun riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Y wacami quere' nbij chiwe, ruma c'o chi nibanatej achi'el ri nubij chupan ri ruch'abel ri Dios ri tz'ibatal ca. Ri chiri' nubij c'a: Can achi'el chuka' jun aj mac xban chare. Queri' ri tz'ibatal ca. Y ri' can xtibanatej na wi wuq'ui riyin. Ronojel c'a ri ye tz'ibatal ca chuwij riyin chupan ri ruch'abel ri Dios, can xquebanatej na wi, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y ri discípulos xquibij c'a chare ri Jesús: Ajaf, wawe' c'o ca'i' espada, xecha'. Yac'a ri Jesús xubij chique: Xa riq'ui c'a ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ri Jesús tek elenak chic c'a el chiri', xbe c'a ri acuchi (achique) kas tibe wi. Riya' xbe c'a ri pa juyu' ri Olivos rubi'. Y ri rudiscípulos can ye tzeketel wi el chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y tek xe'apon c'a, xubij chique: Tibana' orar y tic'utuj chare ri Dios riche (rixin) chi queri' ma yixtzak ta pa mac tek yixtojtobex. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y ri Jesús xbiyin chic c'a apo jun ca'i' raken c'an, y c'ac'ari' xxuque' ka chiri', y xuchop c'a rubanic orar. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nubij c'a ri pa ru'oración: Nata' Dios, wi riyit nawajo', tabana' c'a chi riyin man ta nk'axaj re jun tijoj pokonal re', pero ma taben ta ri xa nuraybel riyin. Tabana' ri araybel riyit, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y c'o c'a jun ángel ri petenak chila' chicaj xuc'ut ri' chuwech, riche (rixin) chi xoruya' ka más ruchuk'a' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y can sibilaj c'a k'axon ri c'o pa ránima Riya'. Rumari' can riq'ui c'a ronojel ránima nuben orar. Y ruma chuka' ri k'axon ri', ri ya' ri ntel chrij, xa can achi'el chic nima'k tak tz'uj quic' ri yeka pan ulef. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Tek Riya' xbeyacatej pe chare ri oración, xpe c'a quiq'ui ri ye rudiscípulos, pero tek xoka quiq'ui, xa quichapon waran, ruma yebison. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y ri Jesús xubij c'a chique ri ye rudiscípulos ri': ¿Achique ruma tek xa yix warnek? Quixyacatej, tibana' orar y tic'utuj chare ri Dios riche (rixin) chi ma yixtzak ta pa mac tek yixtojtobex, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y can c'a nich'o na c'a ri Jesús quiq'ui ri ye rudiscípulos, tek c'a xquitz'et xe'apon ye q'uiy winek quiq'ui. Y can ya c'a jun chique ri ye cablajuj discípulos, ri Judas rubi', ri uc'uayon apo quibey ri winek ri'. Y ri Judas xjel apo riq'ui ri Jesús riche (rixin) chi xutz'umaj (xutz'ubaj) ruchi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Yac'a ri Jesús xubij chare ri Judas: Judas, ¿la riq'ui jun tz'uban (tz'uman) chi'ij najech el ri C'ajolaxel ri xalex chicojol? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y ri discípulos tek xquitz'et ri ntajin nibanatej, xquinabej ri achique ri xtic'ulwachitej. Rumari' xquibij c'a chare: Ajaf, ¿nawajo' chi yojyacatej chiquij riq'ui espada? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y jun c'a chique ri ye rudiscípulos xusoc jun rumozo ri nimalaj sacerdote. Can xuchoy ruxquin. Y ri ruxquin ri xuchoy ya ri c'o pa rajquik'a'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y ri Jesús xubij c'a chique ri ye rudiscípulos: Ma tinek ta, xa tiya' ca. Y xpe ri Jesús xuchop ri ruxquin ri mozo ri' y xuc'achojsaj ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y c'ac'ari' ri Jesús xubij chique ri principali' tak sacerdotes, y chique ri achi'a' ri c'o quik'ij chiquicojol ri ye chajinel pa rachoch ri Dios, y chique ri rijita'k tak achi'a' ri c'o quik'ij ri ye benak chuchapic: ¿Achique c'a xich'ob riyix? ¿Xich'ob chi yix petenak chuchapic jun alek'om y rumari' ic'amom pe che' y espada? ");
INSERT INTO cakWNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Riyin can k'ij k'ij c'a xic'oje' iwuq'ui ri pa rachoch ri Dios, y majun achique ta xiben chuwe. Pero c'a ya c'a hora re' ri ya'on chiwe riyix, hora tek nik'alajin ruchuk'a' ri rajawalul ri k'eku'm, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquichop c'a el ri Jesús, y xquic'uaj pa rachoch ri nimalaj sacerdote. Y ri Pedro ye rutzekelben el, pero c'anej c'o wi ca chiquij. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y ri chiri' pa nic'aj ruwajay, xquibox c'a jun k'ak', y xetz'uye' apo quinojel chuchi'. Y chuka' ri Pedro xtz'uye' apo chiquicojol. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y jun ixok raj ic' ri nimalaj sacerdote, tek xutz'et chi ri Pedro tz'uyul chiri' numek' ri', xutzu' xutzu', y xubij: Re jun achi re' rachibil chuka' ri Jesús, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Yac'a ri Pedro xa xrewaj c'a y xubij: Riyin ma wetaman ta ruwech ri Jesús, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y xa c'a juba' ka ri', tek c'o chic c'a jun ri xtz'eto pe riche (rixin) ri Pedro, y xubij chare: Riyit, yit jun chique ri yec'o riq'ui ri Jesús, xcha'. Y ri Pedro xubij: Táta, kitzij nbij chawe ma yin ta ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Y achi'el xa jun hora tik'ax ka ri', tek c'o chic c'a jun ri xbin: Re achi re', can kitzij wi chi rachibil ri Jesús, ruma can pa Galilea chuka' nipe wi, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Yac'a ri Pedro xubij chare: Táta, ma nik'ax ta chinuwech achique ruma tek nabij queri' chuwe, xcha' ri Pedro. Y can c'a nich'o na c'a ri Pedro, tek ri ec' xsiq'uin pe. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y ri Ajaf Jesús xtzu'un pe chrij y xutzu' pe ri Pedro. Y ri Pedro can yac'ari' tek xenatej chare ri ch'abel ri bin ca chare ruma ri Ajaf, chi c'a ma jane tisiq'uin ta pe ri ec' tek riyit oxi' yan chic mul abin chique ri yec'utun chawe, chi ma awetaman ta nuwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y ri Pedro xel c'a el y xuchop jun nimalaj ok'ej. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ri achi'a' ri ye chajiyon c'a riche (rixin) ri Jesús, yetze'en c'a chrij y niquich'ey c'a. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y xquitz'apij runak' ruwech y xquiyala' k'a' chupalej y niquic'utula' c'a chare: ¿Achique c'a ri xach'eyo? Tabij na c'a chake, yecha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y c'o c'a q'uiy itzel tak tzij ri xquibila' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Tek xseker c'a pe, xquimol c'a qui' ri rijita'k tak achi'a' ri c'o quik'ij, ri principali' tak sacerdotes, y chuka' ri aj tz'iba'. Y ri Jesús xuc'uex c'a apo chiquiwech ri achi'a' ri', ri can pa moc (comon) yek'ato tzij. Y xquic'utuj c'a chare ri Jesús: ");
INSERT INTO cakWNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Tabij c'a chake: ¿La yit c'a riyit ri Cristo? xecha'. Yac'a ri Jesús xubij chique: Wi nbij chiwe chi yin c'a riyin ri Cristo, ma yininimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y chuka' wi ta c'o ri yenc'utuj apo chiwe, majun xtibij pe chuwe, ni ma xquiniwisk'opij ta el chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Y can xu (xe wi) xtink'axaj re jun tijoj pokonal re', can yac'ari' riyin ri C'ajolaxel ri xinalex chicojol, xquibetz'uye' c'a pa rajquik'a' ri Dios ri nicowin nuben ronojel, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Can yac'ari' tek quinojel xec'utun apo chare ri Jesús: ¿La can yit c'a riyit ri Ruc'ajol ri Dios? xecha'. Ja' (je), queri', can achi'el ri nibij riyix, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y riye' xquibij: Ma rajawaxic ta c'a chi noka chic jun ri norubij chake chi re achi re' can aj mac wi. Ruma konojel xkac'axaj ri xa c'ari' xubij ka, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y c'ac'ari', quinojel ri yec'o chiri' xeyacatej c'a el, y xquic'uaj el ri Jesús riche (rixin) chi nbequijacha' pa ruk'a' ri aj k'atbel tzij ri Pilato rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chiri' chuwech ri aj k'atbel tzij, xquichop c'a niquitzujuj (niquisujuj) apo y niquibij: Riyoj ketaman chi re Jesús re' q'uiy rumac. Riya' nusuk' quina'oj ri katinamit Israel. Nubila' chuka' chique ri winek chi ma tiquitoj ta ri alcawal chare ri César. Y nubila' chi ya Riya' ri Cristo, y re' ntel chi tzij chi jun Rey, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y ri Pilato xuc'utuj c'a chare ri Jesús: ¿Yit c'a riyit ri qui-Rey ri israelitas? xcha' chare. Y ri Jesús xubij c'a: Ja' (je), queri', can achi'el ri xabij, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y c'ac'ari' ri Pilato xubij chique ri principali' tak sacerdotes y chuka' chique ri winek: Riyin can majun achique ta mac nwil ta chrij re jun achi re', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Yac'a riye' xa ma yetane' ta ka. Xa niquitij c'a quik'ij chi niquibila' apo: Xa nusuk' quina'oj ri winek pa ronojel tinamit riche (rixin) re Judea. Chila' c'a pa Galilea ruchapon wi pe rubanic. Y queri' nubanala' ri petenak y xoc'ulun c'a wawe' pa tinamit Jerusalem, xecha' apo. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y tek ri Pilato xrac'axaj ri xa c'ari' niquibij ka, xuc'utuj c'a chi wi aj Galilea ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Tek xbix c'a chare ri Pilato chi ri Jesús kitzij chi aj Galilea, ri lugar ri c'o pa ruk'a' ri Herodes, xutek c'a el chare ri Herodes, ri aj k'atbel tzij riche (rixin) ri Galilea. Ruma ri Herodes c'o c'a chiri' pa tinamit Jerusalem ri k'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y tek ri Herodes xutz'et ri Jesús, sibilaj xquicot ránima, ruma can q'uiy chic k'ij rurayin chi rutz'eton ta. Y q'uiy c'a ri rac'axan chrij. Rumari' can royoben c'a chi can xtutz'et na jun bey tek nuben jun milagro. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y ri Herodes q'uiy c'a ri xeruc'utuj chare ri Jesús, yac'a ri Jesús majun tzij xubij ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y can yec'o c'a apo chuka' ri principali' tak sacerdotes y ri aj tz'iba', riche (rixin) chi niquitzujuj (niquisujuj) ri Jesús. Riye' can niquitij c'a quik'ij riche (rixin) chi yetzujun (yesujun) apo chrij. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y ri Herodes y ri ye rusoldados can majun c'a ruk'ij xquiben chare ri Jesús y xquitze'ej. Xquiya' c'a jun tziek chrij, can achi'el ri yequicusala' ri reyes. Y c'ac'ari' ri Herodes xutzolij chic el ri Jesús c'a riq'ui ri Pilato. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes y ri Pilato quic'ulel qui' rubanon pe. Yac'a ri k'ij ri' tek junan quiwech xquiben. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Yac'ari' tek ri Pilato xerusiq'uij (xeroyoj) ri ye principali' tak sacerdotes y ri ye cachibil ri pa moc (comon) yek'ato tzij. Y chuka' xerusiq'uij (xeroyoj) ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y c'ac'ari' xubij chique: Riyix xo'iya' re Jesús pa nuk'a', y nitzujuj (nisujuj) chi nusuk' quina'oj ri winek. Pero can chiwech c'a riyix xinc'utuj wi chare, y riyin ntz'et chi can majun mac ye rubanalon ta ri achi'el ri nibij riyix. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y chuka' ri Herodes majun xril ta chrij tek xixintek el riq'ui, y rumari' xutzolij chic pe pa nuk'a' riyin. Xaxu (xaxe wi) riq'ui ri' niketamaj chi can majun mac rubanon riche (rixin) chi nicamisex. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xtintek c'a ruch'ayic, y c'ac'ari' ncol el, xcha' ri Pilato. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Y ri aj k'atbel tzij can c'o c'a chi nucol el jun preso, ruma queri' niban ronojel juna' chupan ri nimak'ij pascua, jun chique ri quinimak'ij ri israelitas. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Rumari' quinojel junan xquirek apo quichi', y xquibij: ¡Ya ri Barrabás tacolo' el, y ri Jesús ticamisex! xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y ri Barrabás ya'on pa cárcel ruma xyacatej chrij ri k'atbel tzij chiri' pa tinamit, y rubanon chuka' camic. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y ri Pilato, ruma c'a can nrajo' wi nucol el ri Jesús, xch'o chic c'a jun bey chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Yac'a ri winek xquirek apo quichi', y xquibij: ¡Ticamisex chuwech cruz! ¡Ticamisex chuwech cruz! ");
INSERT INTO cakWNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y pa rox mul ri Pilato xubij c'a chique: ¿Achique c'a mac rubanon chiwech re jun achi re'? Riyin can majun achique ta mac nwil ta chrij, riche (rixin) chi ruc'amon ta chi nicamisex. Xtintek c'a ruch'ayic, y c'ac'ari' ncol el, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero riye' xa ma xetane' ta ka, xa más niquirek apo quichi', niquic'utuj chi ticamisex ri Jesús chuwech cruz. Can nik'alajin c'a chi ya ri ch'abel ri xquibila' apo ri winek y ri principali' tak sacerdotes ri xtich'acon. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Y yac'ari' tek ri Pilato xubij chi tiban c'a achi'el ri niquic'utuj apo riye'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xucol c'a el ri achi ri xquic'utuj apo chare chi tucolo' el. Y ri achi ri' xa ya'on pa cárcel ruma xyacatej chrij ri k'atbel tzij y rubanon chuka' camic. Yac'a ri Jesús xa xujech el riche (rixin) chi ticamisex chuwech cruz, ruma can yari' ri xcajo' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y tek ri soldados quic'uan c'a el ri Jesús riche (rixin) chi nbequibajij chuwech cruz, xquic'ul c'a jun achi petenak pa juyu', jun achi aj Cirene, ri Simón rubi'. Y ri soldados chrij c'a riya' xquiya' wi el ri rucruz ri Jesús. Riya' xuc'uan el ri cruz, y xutzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y sibilaj ye q'uiy c'a winek ri ye benak chrij. Ye q'uiy c'a chuka' ixoki' ye'ok' ri ye benak chrij ri Jesús, y can niquibisoj ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Y ri Jesús xerutzu' c'a, y xubij chique: Ixoki' aj Jerusalem, man c'a quiniwok'ej ta riyin. Xa tiwok'ej ka iwi' riyix, y que'iwok'ej chuka' ri ye iwal. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ruma can xque'oka c'a k'ij tek xquepe ruc'ayewal y rumari' tek xtibix chi jabel ruwaruk'ij ri ixok ri ma nalan ta, ni majun bey xralaj ta jun ac'al, y majun ac'al xtz'uman ta chuwaruc'u'x. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Y xtibanatej chuka' chi ri winek xtiquibij chique ri nima'k tak juyu': Quixtzak pe chikij. Chuka' xtiquibij chique ri cocoj tak juyu': Kojiwewaj, xquecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ruma wi chuwe riyin ri achi'el jun che' rex can niban chi c'o chi nk'axaj tijoj pokonal, ¿achique ta cami ri ma xtiban ta chique ri xa ye achi'el chaki'j tak che'? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y yec'o c'a chuka' ye ca'i' alek'oma' ri ye uc'uan el, riche (rixin) chi yecamisex junan riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y tek xe'apon c'a acuchi (achique) c'o wi ri jun juyu' ri nibix Rubakil Rujolon (Ruwi') Caminek chare, ri soldados xquibajij c'a ri Jesús chuwech ri cruz, y queri' chuka' xquiben chique ri ye ca'i' alek'oma'. Jun xc'oje' pa rajquik'a' ri Jesús, y ri jun chic pa rajxocon. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y ri Jesús nubij c'a: Nata' Dios, tacuyu' quimac, ruma ma quetaman ta achique ri yetajin chubanic, xcha'. Y ri soldados xesaquin c'a chrij rutziak ri Jesús, riche (rixin) chi xquitz'et achique chi tziek ri niquic'uala' el chiquijujunal. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ri Jesús tzuliben c'a apo cuma sibilaj ye q'uiy winek y cuma chuka' ri achi'a' ri can yek'ato wi tzij chiquicojol ri israelitas. Y quinojel c'a ri winek ri' niquitze'ej apo, y niquibila' c'a: Riya' can yec'o wi c'a ri xerucol. Wacami tucolo' c'a ri' ruyon, wi kas kitzij chi ya Riya' ri Cristo ri cha'on pe ruma ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y can queri' chuka' niquiben ri soldados. Yetze'en apo chrij ri Jesús. Yejel apo riq'ui y xquitzuj (xquisuj) jun ch'omilaj ruya'al uva chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y niquibila' c'a chuka' chare: Wi can yit c'a riyit ri qui-Rey ri israelitas, tacolo' c'a awi' ayon, yecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y pa ruwi' c'a ri cruz c'o c'a jun tzij tz'iban chuwech jun tz'alan. Ri tzij c'a ri' tz'ibatal el pan oxi' ch'abel. Tz'iban pa quich'abel ri aj Grecia, pa quich'abel ri aj Roma y pa quich'abel ri israelitas. Y ri tzij ri' nubij c'a: YARE' RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun c'a chique ri ye ca'i' alek'oma' ri yec'o chuka' chuwech quicruz, itzel xch'o apo chare ri Jesús, ruma xubij: Riyit ri nabij chi yit c'a riyit ri Cristo, tacolo' c'a awi' riyit, y kojacolo' chuka' riyoj, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Yac'a ri jun chic alek'om xchapon apo chare ri jun y xubij: ¿Can ma naxibij ta awi' chuwech ri Dios chupan re ruc'ayewal re junan yojc'o wi riq'ui? ");
INSERT INTO cakWNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Riyoj can utz wi rubanic chake, ruma yojtajin chutojic ri itzel ye kabanalon. Yac'a Riya' majun achique ta mac rubanon. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y ri alek'om ri' xubij c'a apo chare ri Jesús: Quinatej c'a chawe, tek xcape y tek yitc'o chic chupan ri awajawaren, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xubij c'a chare: Kitzij c'a nbij chawe, chi can ya re wacami xcabec'oje' wuq'ui ri acuchi (achique) c'o wi quicoten, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Achi'el xa pa nic'aj k'ij tek xoc k'eku'm ronojel ri ruwach'ulef. Y ri k'eku'm ri' xq'uis c'a el c'a pa tak a las tres ri tikak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri k'ij can ma xtzu'un ta chic, y yac'ari' tek xel pa ca'i' ri tziek ri achoj riq'ui jachon wi rupan ri rachoch ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Can yac'ari' tek ri Jesús xurek ruchi' y xubij: Nata' Dios, pan ak'a' c'a riyit njech wi ri wánima, xcha'. Y can xu (xe) wi c'a xubij queri', can yac'ari' xcom ka. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Tek ri quicapitán ri soldados xutz'et ri xbanatej, xuya' c'a ruk'ij ruc'ojlen ri Dios, y xubij c'a: Can kitzij na wi chi re jun achi re' can majun wi rumac, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y quinojel c'a ri winek ri yec'o apo y xquitz'et ri xbanatej, niquibajla' (niquibuc'la') c'a ruwa tak quic'u'x ri xetzolin el, ruma ri k'axon c'o pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y ri ye etamayon ruwech ri Jesús, y ri ixoki' ri can c'a pa Galilea ye tzeketel wi pe chrij, c'anej c'a yec'o wi el, niquitzu' apo ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y c'o c'a jun achi José rubi', y aj pa tinamit Arimatea, tinamit ri c'o pa rucuenta ri Judea. Ri jun utzilaj y chojmilaj achi ri' cachibil ri achi'a' ri yek'ato tzij chiquicojol ri israelitas. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y ri José chuka' royoben apo ri rajawaren ri Dios y rumari' tek riya' ma xka ta chuwech ri xquibij ri rachibil chi niban chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y riya' xbe c'a riq'ui ri Pilato ri aj k'atbel tzij y xberuc'utuj ri ruch'acul ri Jesús chare, riche (rixin) chi numuk. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y tek rukasan chic c'a pe ri ruch'acul ri Jesús chuwech ri cruz, riya' xubor pa jun sakilaj tziek. Y c'ac'ari' xberuya' ca pa jun jul riche (rixin) chi niya'ox (nya') caminek chupan, ri c'oton chuwech jun nimabej. Can c'a ma jane jun caminek ri ya'on ta chupan ri jul ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pero ri k'ij ri', ri winek niquichojmirisala' chic c'a qui', ruma xa nuchop yan ri uxlanibel k'ij. Y can ya c'a tek nika ri k'ij ri', yac'ari' tek nuchop ri uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y ri ixoki' ri can c'a pa Galilea ye tzeketel wi pe chrij ri Jesús, xquitzekelbej c'a chuka' ri ruch'acul ri Jesús tek xbemuk ca; y rumari' tek can jabel quetaman ri acuchi (achique) xmuk wi ca, y chuka' xquitzu' ca jabel achique rubanic xban ca chare ri ruch'acul. ");
INSERT INTO cakWNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y tek xetzolin ri pa tak cachoch ri ixoki' ri', xequibanala' ruchojmil ri ak'om ri jubul ruxla' riche (rixin) chi yari' nbequiya' ca chrij ruch'acul ri Jesús. Y xe'uxlan c'a chupan ri jun k'ij riche (rixin) uxlanen ri', can achi'el nubij chupan ri ley riche (rixin) ri Moisés. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y nimak'a' yan c'a chupan ri nabey k'ij chare ri semana, ri ixoki' xebe c'a chuchi' ri jul, y ye quic'ualon el ak'om ri jubul ruxla' ri ye quichojmirisan el. Y yec'o c'a chuka' nic'aj chic ixoki' ri ye benak quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y tek xe'apon c'a chuchi' ri jul, xquitz'et c'a chi ri abej tz'apebel ruchi' ri jul, elesan chic el. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Riye' xe'oc c'a apo chupan ri jul, y xquitz'et c'a chi ri ruch'acul ri Ajaf Jesús xa man c'o ta chic chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rumari' sibilaj c'a xquixibij qui', y xsach quic'u'x. Y can yac'ari' tek xequitz'et ye ca'i' achi'el achi'a' ye pa'el apo quiq'ui, y nitz'itz'an ri quitziak. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y ri ixoki', ruma ri quixibinri'il xquilucuba' ka quijolon (quiwi'). Y yac'ari' tek ri achi'el achi'a' xquibij c'a chique: ¿Achique c'a ruma riyix chiquicojol caminaki' nicanoj wi ri xa q'ues? ");
INSERT INTO cakWNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ri ruch'acul xa man c'o ta chic wawe'. Riya' xc'astej yan el. Toka c'a chi'ic'u'x ri xubij chiwe tek Riya' c'a c'o na c'a chiri' pa Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ri Jesús xubij c'a chiwe: Riyin ri C'ajolaxel ri xinalex chicojol, can c'o c'a chi xquijach pa quik'a' ri aj maqui'. Xquicamisex chuwech cruz. Y pa rox k'ij xquic'astej pe, chinek ca chiwe, xecha' ri ye ca'i' achi'el achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y ri ixoki' can xoka c'a chiquic'u'x ri ch'abel ri rubilon ca ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y tek ye tzolijnek chic c'a pe ri chiri' pa jul, xquitzijoj chique ri julajuj apóstoles y chique ri quimolon qui' quiq'ui, ronojel ri xquitz'et ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri ixoki' ri xebeya'o rutzijol chique ri apóstoles ya ri María Magdalena, ri Juana, ri María ri rute' ri Jacobo, y nic'aj chic ixoki'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yac'a ri apóstoles xa xquich'ob chi ri ixoki' ri' xa ch'obon ma ch'obon ri xquibij apo, y rumari' ma xquinimaj ta ri xbix chique cuma ri ixoki'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Y ri Pedro can yac'ari' xel el, y junanin (anibel) xbe c'a chuchi' ri jul. Y tek xtzu'un c'a apo chupan ri jul, xutzu' chi ri tziek yec'o ca chiri'. Riya' xtzolin c'a el, y numey rij ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chupan chuka' ri k'ij ri', yec'o c'a ye ca'i' chique ri xetzekelben riche (rixin) ri Jesús quichapon el bey riche (rixin) chi yebe pa Emaús, jun ti aldea ri nicanaj ca achi'el xa pa jun oxi' leguas chare ri tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y tek ye benak pa bey yetzijon c'a chrij ri xebanatej ri cabjir oxjir ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y tek benak c'a cánima riq'ui ri quitzij ri ye benak y riq'ui ri niquic'utula' c'a chiquiwech ka riye', ri Jesús c'astajnek chic el, xeberuk'i' c'a, y junan xebe. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ri ye ca'i' c'a achi'a' ri' can niquitzu' wi c'a ri benak quiq'ui, pero c'o c'a banayon chique chi ma niquetamaj ta ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y ri Jesús xuc'utuj c'a chique: ¿Achique c'a ri nitzijola' chiwech re yix petenak? ¿Y achique ruma tek yixbison? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun c'a chique riye', ri Cleofas rubi', xubij apo chare: ¿Xaxu (xaxe wi) c'a riyit ri ma yit aj wawe' ta ri yitc'o pa Jerusalem y ma awetaman ta achique ri ye banatajnek chiri', chupan re ca'i' oxi' k'ij re'? xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xuc'utuj c'a chique: ¿Achique ri xc'ulwachitej? Y riye' xquibij: Ri xuc'ulwachij ri Jesús aj Nazaret, jun profeta ri xk'alajsan ri ruch'abel ri Dios. Y chuka' can xuc'ut chi c'o ruchuk'a' ruma c'o nima'k tak milagros ri xerubanala' y chuka' c'o ruchuk'a' ri ruch'abel. Queri' c'a xk'alajin chiquiwech ri winek y chuka' chuwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yac'a ri principali' tak sacerdotes y ri ye cachibil ri pa moc (comon) yek'ato tzij chkacojol, yeri' ri xebano chi xcamisex chuwech cruz. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y riyoj can xkacukuba' c'a kac'u'x riq'ui chi can ya wi Riya' ri petenak chkacolic konojel riyoj israelitas. Pero wacami majun chic c'a achique xtikaben, ruma ya xa xuben oxi' k'ij ticom wi el. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero yec'o ixoki' ri ye kachibil, ri can nimak'a' yan xebe chuchi' ri jul, y xojoquixibij. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ruma xquibij chake chi ri ruch'acul ri Jesús xa man c'o ta chic chiri' pa jul. Y niquibij c'a chuka' chi c'o ángeles xquic'ut qui' chiquiwech, y chi ri ángeles ri' xquibij chique chi ri Jesús xc'astej yan el. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y rumari' yec'o c'a achi'a' ri ye kachibil riyoj ri xebe chuchi' ri jul riche (rixin) chi xbequitz'eta'. Y can achi'el ri xquibij ri ixoki' chake, can queri' ri xbequitz'eta' ca ri achi'a' ri', pero ri Jesús can man c'o ta chic chiri' xquitz'et ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y ri Jesús nitzijon benak quiq'ui, xubij c'a chique: Nacanek. Ri iwánima riyix c'ayef (cuesta) juba' chi nunimaj ri quibin ca ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ma quibin ta cami ca riye' chi ri Cristo can c'o wi chi nuk'axaj tijoj pokonal, y c'ac'ari' nibe chila' chicaj riche (rixin) chi nbec'oje' chic ruk'ij ruc'ojlen? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y ri Jesús xuchop c'a ruk'alajsaxic chiquiwech ri ye ca'i' achi'a' ri', ronojel ri ye tz'ibatal ca chrij Riya' chupan ri ruch'abel ri Dios. Xuchop c'a el riq'ui ri ye rutz'iban ca ri Moisés, c'a riq'ui ri quitz'iban ca ri nic'aj chic profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y tek xe'apon c'a ri pan aldea Emaús, ri Jesús xuben chi can choj nik'ax el. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y riche (rixin) c'a chi can niquiben chare ri Jesús chi nicanaj ka quiq'ui, ri ca'i' achi'a' ri' xquibij c'a chare: Cacanaj ka kiq'ui, ruma ri k'ij xa xka yan ka, y xa can ntoc yan pe ri ak'a', xecha'. Y ri Jesús xoc c'a apo, riche (rixin) chi nic'oje' ka quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y tek ye tz'uyul chic c'a apo pa mesa, ri Jesús xuc'om apo ri caxlan wey y tek ruc'utun chic ri rubendición ri Dios pa ruwi', xuwech'ela' c'a ri caxlan wey y xuya' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Y can yac'ari' tek achi'el xjakatej ri runak' tak quiwech, y c'ac'ari' xquetamaj ruwech chi can ya wi ri Jesús ri c'o quiq'ui. Ri Jesús xmalomo' el chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y ri ca'i' achi'a' ri' niquibila' c'a chiquiwech: Can kitzij wi chi can nuna' wi c'a juba' ri kánima tek yojtzijon ri yoj petenak, tek Riya' xuk'alajsaj chkawech ri ruch'abel ri Dios ri tz'ibatal ca, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri ca'i' achi'a' ri' can yac'ari' xeyacatej el ri pa mesa, y xquichop bey riche (rixin) chi xetzolin pa Jerusalem. Y xebequila' c'a ri julajuj discípulos y ri nic'aj chic ri can ye tzekelbey wi riche (rixin) ri Jesús, quimolon qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y ri discípulos y ri nic'aj chic niquibij c'a: Ri Ajaf Jesús can kitzij wi chi xc'astej el, y xuc'ut yan ri' chuwech ri Simón. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y yac'ari' tek ri ca'i' achi'a' xquitzijoj apo ri xquic'ulwachij tek quichapon el bey pan Emaús, y xquetamaj ruwech chi can ya wi ri Jesús tek xeruwech' ri caxlan wey. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y quinojel ri quimolon qui', c'a yetzijon na c'a chrij ri Jesús, y c'a tek xquitz'et, xa c'o chic chiri' chiquicojol, y xubij c'a chique: Ya ta c'a ri uxlanibel c'u'x ri xtic'oje' pa tak iwánima chi'iwonojel, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero riye' xquich'ob chi ri niquitz'et xa ya c'a ri ánima riche (rixin) ri Jesús, rumari' sibilaj xquixibij qui'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yac'a ri Jesús xubij chique: ¿Achique ruma tek xsach ic'u'x tek xinitz'et y xpe re ch'obonic re' pa tak iwánima? ");
INSERT INTO cakWNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Que'itzu' re nuk'a' waken. Quinichapa' na pe', y xtitz'et chi can yin wi riyin. Ruma xa ta yin jun ánima achi'el ri nich'ob riyix, man ta c'o nuch'acul. Y riyix nitz'et chi riyin can c'o nuch'acul y c'o nubakil, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y tek ri Jesús rubin chic ka queri' chique, xeruc'ut c'a ri ruk'a' raken chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yac'a riye' ma niquinimaj ta. Xa xquimey ruma ri niquitzu' y ruma ri quicoten. Y riche (rixin) chi niquinimaj, xpe ri Jesús xuc'utuj c'a chique: ¿Majun cami riche (rixin) nitij c'o iwuq'ui? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y riye' c'o c'a juba' sa'on car y juba' cab ri c'a c'o na pa rucera'il xquiya' chare. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y Riya' xuc'ul y xuchop rutijic, riche (rixin) chi tiquitz'eta' chi can ya wi Riya' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xubij c'a chique: Tek can c'a ma jane quicamisex ta, xinbij c'a chiwe ri xtink'axaj, y xinbij chuka' chiwe chi can rajawaxic chi nibanatej na ronojel ri ye tz'ibatal ca chuwij riyin chupan ri ruch'abel ri Dios, achi'el ri ye tz'ibatal ca ruma ri Moisés, ri ye tz'ibatal ca cuma ri nic'aj chic profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, y ri ye tz'ibatal ca chupan ri wuj Salmos rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ac'ari' Riya' xuben chique chi nik'ax c'a chiquiwech ri ruch'abel ri Dios ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xubij c'a chique: Can tz'ibatal wi ca, chi riyin ri Cristo c'o chi nk'axaj tijoj pokonal, y chi can yicom na wi, y pa rox k'ij yic'astej pe, ");
INSERT INTO cakWNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y chi yec'o ri xquebe pa nubi' riyin chutzijoxic ri ruch'abel ri Dios chique ri winek chuwech ronojel re ruwach'ulef, chi titzolin pe quic'u'x riq'ui ri Dios riche (rixin) chi nicuyutej quimac. Y nitiquiribex el re pa Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y riyix ri can xitz'et, tik'alajsaj c'a ri xitz'et. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y can tiwac'axaj c'a jabel re nbij ca chiwe, xcha' ri Jesús. Can xtintek c'a pe chiwe ri rutzujun (rusujun) ri Nata' Dios chi nuya' pe chiwe. Ri rutzujun (rusujun) c'a Riya' chiwe riyix, ya ri Lok'olaj Espíritu. Y yac'ari' ri xtoya'o ka iwuchuk'a'. Y can quixc'oje' c'a re wawe' pa tinamit Jerusalem c'a ya tek xtapon ri k'ij tek xtika pe ri Lok'olaj Espíritu, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y ri Jesús xeruc'uaj el ri rudiscípulos c'a pa tinamit Betania. Y chiri', Riya' xeruyec ri ruk'a' chicaj, y xeruben c'a bendecir. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y ri Jesús ntajin c'a yeruben bendecir ri discípulos tek xujech el ri' chiquicojol. Yac'ari' tek xyacatej el pa cak'ik' y xuc'uex c'a el chila' chicaj riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y ri discípulos can xquiya' c'a ruk'ij ruc'ojlen ri Jesús chiri'. C'ac'ari' xetzolin pa tinamit Jerusalem. Riye' can sibilaj c'a quicoten ri c'o pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y can k'ij k'ij c'a yec'o pa rachoch ri Dios riche (rixin) chi niquiya' ruk'ij y niquinimirisaj rubi' ri Dios. Amén.");
INSERT INTO cakWNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tek xtiquir c'a pe ronojel, can c'o chic pe ri Ch'abel; y ri Ch'abel yari' ri Cristo. Riya' can c'o c'a riq'ui ri Dios, y Riya' chuka' can Dios wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Riya' can c'o riq'ui ri Dios tek xban re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y ruma Riya' tek c'o ronojel. Ruma ri Dios pa ruk'a' ri Cristo xuya' wi riche (rixin) chi xuben ronojel ri c'o chicaj y ri c'o choch'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riq'ui c'a Riya' c'o wi ri c'aslen. Y re c'aslen re', yac'are' ri Sakil quiche (quixin) ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y re jun Sakil re', can nisakirisan wi ri pa tak itzel quic'aslen ri winek ri achi'el k'eku'm. Y can majun bey c'a chuptajnek ta pa ruk'a' ri k'eku'm ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xc'oje' c'a jun achi ri can ya ri Dios takayon pe riche (rixin), ri xubini'aj Juan. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri Juan c'a ri' xpe riche (rixin) chi xoruk'alajsaj ri Sakil, riche (rixin) chi queri' can quinojel c'a winek tiquinimaj ri nuya' rutzijol chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y ma ya ta c'a ri Juan ri Sakil. Riya' xaxu (xaxe) c'a xoruk'alajsaj achique ri' ri Sakil. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y can yac'ari' tek xoka ri Cristo chuwech re ruwach'ulef. Yari' ri kas kitzij Sakil, ri nisakirisan quiche (quixin) ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Can xoc'oje' wi c'a ka chuwech re ruwach'ulef ri banon ruma Riya', pero ri yec'o chuwech re ruwach'ulef re' xa ma xquetamaj ta c'a ruwech tek xoka. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Xoka chiquicojol ri israelitas ri can ye ruwinak Riya' mismo. Pero ri winek ri' xa ma xquic'ul ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Yac'a quinojel ri xec'ulu riche (rixin) tek xoka chuwech re ruwach'ulef, ri xeniman riche (rixin), can xuben c'a chique chi xe'oc ralc'ual ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri xe'oc ralc'ual ri Dios can xe'alex wi chic, pero ma xe'alex ta chic achi'el tek xe'alex riq'ui ri quite' quitata'. Ri c'ac'ac' alaxic ri xquic'ul riye', yari' tek xe'alex achi'el ri ruraybel ri Dios, y ma ruraybel ta chic jun achi. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Ch'abel, ya ri Cristo, ri xoka c'a chuwech re ruwach'ulef y can xoc c'a winek achi'el riyoj. Y can xkatz'et c'a chi xaxu (xaxe) wi Riya' ri Ruc'ajol ri Dios, ruma can xkatz'et chi c'o ruk'ij ruc'ojlen. Y Riya' can nojnek c'a riq'ui utzil y chuka' riq'ui ri kitzij. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y ri Juan ri Bautista xuk'alajsaj c'a ri Cristo. Can riq'ui wi ruchuk'a' tek xubij: Yare' ri ntzijon pe chiwe, tek xinbij chiwe chi chuwij ca riyin c'o c'a jun achi ri xtoka ri sibilaj nim ruk'ij que chinuwech riyin. Ruma Riya' can c'o tek c'a ma jane quinalex ta riyin, xcha' c'a ri Juan ri Bautista. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Can konojel c'a riyoj kac'ulun ri rutzil ránima ri Cristo. Can ma nitane' ta c'a chi yeruya' pe ri utzil ri' pa kawi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios ya c'a ri Moisés ri xucusaj riche (rixin) chi xuya' pe ri ley. Yac'a riche (rixin) chi xoka ri utzil y ri kitzij, ya ri Jesucristo ri xucusaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Can majun c'a winek ri tz'eteyon ta riche (rixin) ri Dios, xa can xu (xe) wi ri Ruc'ajol ri tz'eteyon riche (rixin). Ri Dios xaxu (xaxe wi) jun Ruc'ajol c'o y sibilaj nrajo'. Y yari' ri xok'alajsan ka ri Dios chkawech re wawe' chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y ri achi'a' israelitas ri can c'o quik'ij chiri' pa tinamit Jerusalem, yec'o c'a achi'a' ri xequitek el c'a riq'ui ri Juan ri Bautista. Xequitek c'a ye sacerdotes y achi'a' ri ye levitas nibix chique, riche (rixin) chi xbequic'axaj chare ri Juan chi tubij wi ya riya' ri Cristo. Y riya' can xuk'alajsaj wi chiquiwech chi ma ya ta riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri Juan can kitzij wi ri xubij chique, ruma xubij c'a chique: Ma yin ta c'a riyin ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y yac'ari' tek ri achi'a' ri ye takon el, xquic'utuj chic c'a chare: ¿Yit achique c'a riyit? ¿La ma yit ta cami riyit ri profeta Elías ri xk'alajsan ri ruch'abel ri Dios ojer ca? xecha' chare. Pero ri Juan xubij: Ma yin ta riyin, xcha' chique. C'ac'ari' ri achi'a' ri' xquic'utuj chic c'a jun bey chare: ¿La ma yit ta cami riyit ri profeta ri nik'alajsan ri ruch'abel ri Dios ri kac'axan rutzijol chi nipe? xecha' chare. Pero riya' xubij: Ma yin ta, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yac'ari' tek can xquic'utuj chic c'a chare: ¿Yit achique c'a riyit? Ruma riyoj nic'atzin c'a chake chi niketamaj el yit achique c'a riyit, y yari' ri nbekabij chique ri ye takayon pe kiche (kixin). Tak'alajsaj c'a awi' chkawech, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ri Juan xubij c'a chique ri achi'a' ri': Yin c'a riyin ri' ri xunataj ca ri profeta Isaías chupan ri ruch'abel ri Dios, tek xubij: C'o c'a jun achi ri xturek c'a ruchi' pa jun desierto riche (rixin) chi xtubij chique ri winek ri xque'apon riq'ui: Tichojmirisaj apo rubey ri Ajaf, xticha' chique. Quec'ari' tz'ibatajnek ca, y yin c'a riyin ri', xcha' ri Juan chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achi'a' c'a ri xetak el riq'ui ri Juan, ye ri ye cachibil ri fariseos. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y riye' xquic'utuj chic c'a chare: ¿Achique c'a ruma tek riyit ye'aben bautizar ri winek, wi xa ma yit ta riyit ri Cristo, ni xa ma yit ta chuka' ri Elías, ni ma yit ta ri profeta ri nik'alajsan ri ruch'abel ri Dios ri kac'axan rutzijol chi nipe na? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y ri Juan xubij c'a chique: Riyin riq'ui ya' yenben wi bautizar ri winek, pero chicojol riyix c'o c'a jun achi ri ma iwetaman ta ruwech, ");
INSERT INTO cakWNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y Riya' xtipe chuwij ca riyin re chkawech apo, pero can ya Riya' ri c'o nabey que chinuwech riyin. Y riyin can ma yin ruc'amon ta (takal ta chuwij) riche (rixin) chi nquir ri ruximbel ri ruxajab. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y ronojel c'a re', ya ri chiri' pa Betábara xbanatej wi, ri lugar ri c'o juc'an chic ruchi' ri raken ya' Jordán, ri acuchi (achique) yeruben wi bautizar winek ri Juan. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Pa ruca'n k'ij tek ri Juan ri Bautista xutz'et chi petenak ri Jesús c'a riq'ui riya', xubij: Yare' xoka ri achi'el Alaj Carne'l ri takon pe ruma ri Dios, riche (rixin) chi nrelesaj quimac ri winek ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Y yare' ri nutzijon chiwe, tek xinbij chi chuwij c'a riyin xtoka na jun achi ri can sibilaj nim ruk'ij que chinuwech riyin, y can c'o tek riyin c'a ma jane quinalex ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y riyin ma wetaman ta ruwech achique chi achi ri'. Pero riche (rixin) chi nik'alajsex chare re tinamit Israel, rumari' xipe chi yenben bautizar ri winek riq'ui ya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y ri Juan xuk'alajsaj c'a chuka' y xubij: Riyin can xintz'et c'a ri Lok'olaj Espíritu tek xka pe chila' chicaj achi'el nika jun palomax, y xka pa ruwi' y can xc'oje' riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y riyin ri chiri' can c'a ma jane c'a wetaman ta ruwech achique chi achi ri'. Pero ri Dios ri yin takayon pe riche (rixin) chi yenben bautizar ri winek riq'ui ya', can ruk'alajsan wi c'a chic chinuwech chi tek xtintz'et chi nika pe ri Lok'olaj Espíritu y xtika pa ruwi' jun achi y can xtic'oje' riq'ui, ya c'a achi ri' ri nibano bautizar quiche (quixin) ri winek riq'ui ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Wacami xintz'et yan c'a. Y rumari' nk'alajsaj chi ya Riya' ri Ruc'ajol ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y pa ruca'n k'ij, ri Juan ri Bautista c'o chic c'a chiri' jun bey, ye rachibilan ye ca'i' chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y yac'ari' tek riya' xutz'et chi ri Jesús nik'ax el queri'. Riya' xubij: Titzu', ya achi la', ri achi'el Alaj Carne'l ri takon pe ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y ri ye ca'i' rudiscípulos ri Juan tek xquic'axaj c'a ri xubij, riye' xquitzekelbej el ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y tek ri Jesús xtzu'un ca chrij y xerutz'et ri ye ca'i' rudiscípulos ri Juan chi ye tzeketel el chrij, Riya' xuc'utuj c'a chique: ¿Achique nicanoj? xcha' chique. Y riye' xquibij c'a chare ri Jesús: Rabí, riyoj nikajo' niketamaj acuchi (achique) c'o wi ri awachoch, xecha' chare. Rabí ntel chi tzij nimalaj tijonel. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y ri Jesús xubij c'a chique: Jo', y je'iwetamaj ca. Y riye' xebe chiretamaxic ri rachoch. Y xec'oje' c'a ka riq'ui ri k'ij ri', ruma xa can a las cuatro chic ri tikak'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri jun c'a chique ri ye ca'i' discípulos ri xe'ac'axan el achique ri xubij ri Juan y xquitzekelbej el ri Jesús, ya c'a ri Andrés ri rach'alal ri Simón Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés nabey c'a xberila' ri Simón ri rach'alal y xberubij chare: Xkil ri Mesías. Ri Mesías ntel chi tzij ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Y ri Andrés xuc'uaj c'a ri Simón c'a riq'ui ri Jesús. Y tek ri Jesús xutz'et, xubij c'a chare: Yit c'a riyit ri Simón ri ruc'ajol ri Jonás. Wacami xtabini'aj Cefas, xcha' chare. Ri Cefas ntel chi tzij Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Yac'a ri pa ruca'n k'ij, ri Jesús xuch'ob chi nibe c'a pa Galilea. Y chupan c'a ri k'ij ri' ri Jesús xuc'ul jun achi ri Felipe rubi' y xubij chare: Quinatzekelbej. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y ri jun achi ri', ri Felipe rubi', aj pa tinamit Betsaida, ri tinamit ri quitinamit chuka' ri Andrés y ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri Felipe xuc'ul jun achi ri Natanael rubi', y xubij c'a chare: Riyoj xkil ri jun achi ri achoj chrij tz'ibatajnek wi ca ruma ri Moisés chupan ri ley y tz'ibatajnek chuka' ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, ri kac'axan rutzijol chi nipe, xa c'o chic ajc'a, ya ajc'a ri Jesús ri ruc'ajol ri José aj Nazaret. C'ari' niketamaj ca ruwech, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y ri Natanael xubij: ¿La xtel ta c'a pe jun utzilaj achi chiri' pa tinamit Nazaret? xcha'. Pero ri Felipe xubij chare: Wi ma nanimaj ta, catam pe, jo' tikatzu'. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y tek ri Jesús xutz'et ri Natanael chi xa napon yan apo riq'ui, xubij c'a: Titzu' la jun achi la'. Riya' can k'alaj chi kitzij jun israelita. Ruma majun k'oloj riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","C'ac'ari' ri Natanael xuc'utuj c'a chare ri Jesús: ¿Acuchi (achique) xawetamaj wi nuwech? Y ri Jesús xubij c'a chare: Riyin xatintz'et tek c'a yitc'o na chiri' chuxe' ri juwi' higo, tek c'a ma jane carusiq'uij (caroyoj) pe ri Felipe, xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael yac'ari' tek xubij: Tijonel, can yit wi riyit ri Ruc'ajol ri Dios. Y can yit wi riyit ri Rey riche (rixin) re tinamit Israel, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y ri Jesús xubij chare ri Natanael: Riyit can xanimaj chi yin c'a riyin ri Ruc'ajol ri Dios, xa ruma chi xinbij chawe chi chuxe' ri juwi' higo yitc'o wi tek c'a ma jane carusiq'uij (caroyoj) ta pe ri Felipe. Pero yec'o milagros ri más ye nima'k que chuwech re' ri xtatz'et na. ");
INSERT INTO cakWNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y ri Jesús xubij c'a chuka': Can kitzij re xtinbij chiwe: Riyix can xtitz'et c'a chi ri caj xtijakatej, y chi ri ángeles riche (rixin) ri Dios xquexule' xquejote' pa nuwi' riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y pa rox k'ij, chiri' pa tinamit Caná ri c'o chiri' pa rucuenta ri Galilea, c'o c'a jun c'ulanen xbanatej. Y ri María ri rute' ri Jesús, c'o c'a chuka' chiri' chupan ri c'ulanen ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y ri Jesús ye rachibilan ri rudiscípulos xesiq'uix (xe'oyox) c'a chuka' riye' chupan ri c'ulanen ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yac'a ri ruya'al uva xa xq'uis yan chanin chupan ri c'ulanen ri'. Y ri María ri rute' ri Jesús, xapon c'a apo riq'ui ri Jesús y xberubij chare: Xa majun chic ri ruya'al uva quiq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero ri Jesús xubij c'a chare: Nána, ¿achique c'a ri nawajo'? Ri nuhora xa c'a ma jane napon ta, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y ri rute' ri Jesús xubij c'a chique ri yeniman ye'ilin chiri': Wi c'o achique xtubij chiwe chi niben, can tibana' c'a, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y chiri' yec'o c'a waki' yabel ya' ye banon riq'ui abej. Ri israelitas sibilaj yequicusaj yabel ya' ri queri' quibanic, ruma chupan ri yabel tak ya' ri' niquiya' wi ya' ri nic'atzin chique riche (rixin) chi niquiben q'uiy ruwech ch'ajch'ojirisanic achi'el nubij chupan ri ley riche (rixin) ri Moisés. Y ri yabel tak ya' ri', ca'i' o oxi' cucu' quipan. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y ri Jesús xubij chique ri yeniman ye'ilin chiri': Que'inojsaj chi ya' re yabel tak ya' re', xcha' chique. Y riye' can que wi ri' xquiben. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'ac'ari' ri Jesús xubij c'a chique: Wacami tipaja' el juba' y tic'uaj chare ri achi ri nisamej chrij re c'ulanen re', riche (rixin) chi tuna'. Y ri yeniman ye'ilin chiri' can xquiben wi ri xubij ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ri achi ri nisamej chrij ri c'ulanen ri', man c'a retaman ta acuchi (achique) petenak wi ri ruya'al uva ri'. Xa can xu (xe) wi c'a ri yeniman ye'ilin chiri' ri xepajo ri ye etamayon. Y tek ri achi ri nisamej chrij ri c'ulanen ri' runa'on chic chi sibilaj jabel ri ruya'al uva ri', xusiq'uij (xroyoj) c'a ri c'ajol ri xc'ule'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Y tek ri c'ajol ri xc'ule' xapon c'a, ri achi ri nisamej chrij ri c'ulanen ri' xubij c'a chare: Tek c'o jun nimak'ij quere', quinojel c'a winek ya ri ruya'al uva ri utz niquiya' nabey mul, y tek q'uiy chic ri quikumun, niquiya' c'a jun ruya'al uva ri ma can ta utz. Pero riyit xa ma que ta ri' xaben. Riyit xa c'ac'ari' xbe'awelesaj pe ri ruya'al uva ri más utz, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xuben c'a ri Jesús, chi xuben ruya'al uva chare ri relic ya' pa jun c'ulanen chiri' pa Caná ri c'o pa rucuenta ri Galilea, yac'ari' ri nabey milagro ri xuben. Can xuc'ut c'a chi Riya' can c'o ruk'ij ruc'ojlen. Y ri ye rudiscípulos xquicukuba' c'a quic'u'x riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Tek c'achojnek chic ca ri c'ulanen ri', ri Jesús rachibilan ri rute', ri ye rach'alal y ri rudiscípulos xebe pa tinamit Capernaum. Y xec'oje' c'a ca'i' oxi' k'ij chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y xa nakaj chic c'a ri k'ij riche (rixin) ri quinimak'ij ri israelitas, ri pascua rubi'. Rumari' ri Jesús xbe c'a pa tinamit Jerusalem, riche (rixin) ri nimak'ij ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y chupan ri lugar ri acuchi (achique) c'o wi rachoch ri Dios ri c'o pa Jerusalem, ri Jesús xeberila' c'a ri yec'ayin wáquix, carne'l, y ri yec'ayin tak palomax. Y xeberila' chuka' ri aj q'uexoy tak puek ri ye tz'uyul ri chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús, xu (xe wi) tek xerutz'et, xberuc'ama' pe ca'i' oxi' tak colo' y xuben c'a jun ruch'aybal y xerokotaj pe quinojel. Xerokotaj c'a pe cachibilan ri quicarne'l y ri quiwáquix ri chiri' chupan ri lugar riche (rixin) ri rachoch ri Dios. Y chique ri aj q'uexoy tak puek, xuc'akala' c'a ca ri quirajil chiquiwech y xerutecmayila' ca ri quimesas. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y chique ri yec'ayin palomax xubij c'a: Que'iwelesaj el re' wawe'. Y ma tiben ta chare ri rachoch ri Nata' Dios, jun c'aybel, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Rumari' ri rudiscípulos can chanin xoka chiquic'u'x ri jun tzij tz'ibatal ca chupan ri ruch'abel ri Dios. Ri tzij c'a ri' nubij: Sibilaj nik'axo chic wánima ruma ri itzel yetajin chubanic ri winek chupan ri awachoch, nicha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yac'ari' tek ri achi'a' israelitas ri can c'o quik'ij, xquibij chare ri Jesús: ¿Achique c'a chi milagro nac'ut chkawech riche (rixin) chi niketamaj chi c'o k'atbel tzij pan ak'a' riche (rixin) chi xe'awokotaj el ri winek wawe'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y ri Jesús xubij c'a chique: Tikasaj c'a pan ulef re jay re', jay ri can riche (rixin) wi ri Dios y riyin pan oxi' k'ij npaba' chic jun bey, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Y yac'ari' tek ri achi'a' israelitas ri can c'o quik'ij, xquibij chare ri Jesús: Re jun jay re', cawinek waki' juna' xquiben ri kate' katata' chrij riche (rixin) chi xquipaba'. ¿La yacowin cami riyit napaba' pan oxi' k'ij? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri jay ri xubij ri Jesús chique ri winek ri', ya ri ruch'acul Riya' mismo. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y rumac'ari', tek ri Jesús xcamisex chuwech ri cruz y pa rox k'ij xbec'astej pe, ri rudiscípulos xoka c'a chiquic'u'x chi ri jun tzij ri' rubin chique ri achi'a' israelitas ri can c'o quik'ij. Y c'ac'ari' xquinimaj ri ruch'abel ri Dios ri tz'ibatal ca, y ri ch'abel ri ye rubin ca ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupan c'a ri k'ij tek c'o ri Jesús pa Jerusalem ruma ri nimak'ij pascua, can ye q'uiy wi c'a winek ri xeniman. Ri winek ri' xquinimaj tek xequitz'et ri milagros ri xeruben chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man c'a xucukuba' ta ruc'u'x quiq'ui ri winek ri', ruma Riya' can retaman wi ri c'o pa tak cánima quinojel ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y ma rajawaxic ta c'a chare chi c'o ta jun ri nibin chare achique rubanic ri quic'aslen chiquijujunal ri winek; ruma Riya' can retaman wi achique c'a ri c'o pa tak cánima. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y c'o c'a jun achi chiquicojol ri fariseos ri Nicodemo rubi', y ri achi ri' c'o c'a ruk'ij chiquicojol ri rech aj Israel. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Y pa jun chak'a', riya' xapon c'a riq'ui ri Jesús y xubij chare: Can nik'alajin wi c'a chi yit jun Tijonel ri yit takon pe ruma ri Dios, ruma ri milagros ri ye'abanala', xaxu (xaxe wi) c'a ri c'o Dios riq'ui ri nicowin nibano quere', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y ri Jesús xubij c'a chare ri Nicodemo: Riyin can kitzij c'a re nbij chawe: Ri achique c'a ri ma xtalex ta chic jun bey, ma xtoc ta pa rajawaren ri Dios, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xubij chare ri Jesús: ¿La can nicowin cami nalex chic jun bey jun achi ri xa ri'j chic? ¿Y can nicowin cami jun te'ej nralaj chic jun bey jun achi ri xa ri'j chic? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xubij c'a: Kas kitzij wi c'a re nbij chawe: Ri ma xtalex ta ruma ri Lok'olaj Espíritu y ruma ya', ma xtoc ta pa rajawaren ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri winek ri xaxu (xaxe wi) alaxnek riq'ui ri ruch'acul, can aj ruwach'ulef wi. Yac'a ri winek ri xalex ruma ri Lok'olaj Espíritu, can riche (rixin) wi ri Lok'olaj Espíritu. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Y man c'a tisach ta ac'u'x riq'ui re xinbij chawe, ruma can queri' wi: Can rajawaxic wi chi yatalex chic jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri ye'uc'uan ri alaxic riche (rixin) ri Lok'olaj Espíritu, nijalatej ri quic'aslen. Ri Lok'olaj Espíritu man c'a tz'etetel ta, xa can achi'el c'a ri cak'ik' ri xabacuchi (xabachique) nbec'ulun wi pe. Ruma xaxu (xaxe wi) nawac'axaj, pero man c'a awetaman ta acuchi (achique) petenak wi y ma awetaman ta chuka' acuchi (achique) nibe wi, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y ri Nicodemo xuc'utuj c'a chare ri Jesús: ¿Achique c'a rubanic ri'? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xubij c'a chare: ¿La ma awetaman ta c'a achique rubanic re', y can yit jun tijonel chiquicojol ri kech aj Israel? ");
INSERT INTO cakWNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kitzij nbij chawe: Ya ri wetaman y ri ntz'eton riyin ri ntzijoj, yac'a riyix ma niwajo' ta ninimaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wi riyix ma ninimaj ta re nbij chiwe, y xa cosas riche (rixin) ri ruwach'ulef, ¿achique ta c'a modo xtinimaj, wi ntzijoj chiwe ri cosas ri ye riche (rixin) chila' chicaj? ");
INSERT INTO cakWNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Majun chic c'a jun ri aponak ta chila' chicaj, xa can xu (xe wi) c'a ri C'ajolaxel kajnek pe chila' chicaj. Ri C'ajolaxel ri xalex chicojol ri can c'o wi chila' chicaj riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y ojer ojer ca ri', tek ri Moisés xc'oje' ri pa jun desierto, riya' xutic c'a jun che' y xuya' anej ruwachbel jun cumatz chutza'n. Y achi'el c'a xban chare ri ruwachbel ri cumatz ri', can queri' chuka' nic'atzin chi niban chare ri C'ajolaxel ri xalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Riche (rixin) chi queri' xabachique c'a winek ri xtiniman ri C'ajolaxel, ma xtibe ta pa tijoj pokonal, xa can xtic'oje' ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios can sibilaj yerajo' ri winek ri yec'o chuwech re ruwach'ulef, y rumari' xutek c'a pe ri Ruc'ajol wawe' chuwech re ruwach'ulef. Riya' xaxu (xaxe wi) c'a jun Ruc'ajol c'o, pero xutek pe riche (rixin) chi xabachique c'a winek ri xtiniman riche (rixin), ma xtibe ta pa tijoj pokonal, xa can xtic'oje' c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ruma chi ri Dios ma xutek ta pe ri Ruc'ajol wawe' chuwech re ruwach'ulef riche (rixin) chi noruk'ata' tzij pa quiwi' ri winek y noruya' ta ruc'ayewal pa quiwi'. Ma que ta ri'. Ri Dios xutek pe ri Ruc'ajol, riche (rixin) chi yecolotej ri winek chupan ri mac. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Y achique winek ri xtiniman ri C'ajolaxel, ma xtika ta ruc'ayewal pa ruwi'. Yac'a ri winek ri ma xtiniman ta riche (rixin), ri ruc'ayewal riche (rixin) xtibe k'ij xtibe sek c'o chic riche (rixin) chi nika pa ruwi', ruma xa can ma xunimaj ta rubi' ri Ruc'ajol ri Dios, y ri Dios xaxu (xaxe wi) jun Ruc'ajol ri c'o. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Y quinojel c'a ri ma yeniman ta, can c'o chic riche (rixin) chi nika ri ruc'ayewal pa quiwi'; ruma ri Sakil can xoka wi chuwech re ruwach'ulef, pero riye' xa más xcajo' ri k'eku'm que chuwech ri Sakil, ruma riye' can xu (xe wi) c'a ri etzelal ri yequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y quinojel c'a ri yebano ri etzelal, man c'a nika ta chiquiwech ri Sakil, ni ma ye'apon ta chuka' riq'ui ri Sakil; ruma re Sakil re' nuben c'a chi yebek'alajin pe ronojel ri etzelal ri yetajin chubanic. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Yac'a ri winek ri can yequibanala' ri kitzij, can yebe chupan ri Sakil, riche (rixin) chi yek'alajin jabel chi yecowin niquiben ri nrajo' ri Dios, ruma xa jun chic quibanon riq'ui Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Y tek banatajnek chic c'a ronojel ri', ri Jesús ye rachibilan ri rudiscípulos xbe pa Judea, y chiri' xebec'oje' wi. Y xe'apon c'a winek chiri' riche (rixin) chi yeban el bautizar. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupan c'a chuka' ri tiempo ri', ri Juan ri Bautista c'o c'a ri chiri' pa Enón, ri c'o chunakajal ri tinamit Salim. Riya' chiri' c'a yeruben wi bautizar ri winek, ruma chupan ri lugar ri' jabel ya' c'o y ri winek ye'apon c'a riq'ui riche (rixin) chi yeban el bautizar. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupan ri tiempo ri' ri Juan c'a ma jane c'a titz'apix ta pa cárcel. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y yec'o israelitas ri xquibila' chiquiwech quiq'ui ri rudiscípulos ri Juan chrij ri achique chi bautismo ri más utz. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xepe c'a ri discípulos ri' xebe c'a riq'ui ri Juan y xbequibij chare: Tijonel, ri achi ri Jesús rubi' ri xapon awuq'ui ri juc'an chic ruchi' ya' Jordán, ri xabij chi ya Riya' ri takon pe ruma ri Dios, wacami xa can quinojel chic ri winek ye'apon riq'ui Riya' riche (rixin) chi yeruben el bautizar, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ri Juan xubij c'a chique ri rudiscípulos: Majun jun winek nicowin nuben jun samaj queri', wi xa ma ya ta ri Dios yayon pe chare chi nuben queri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y riyix mismo iwac'axan achique ri nbin riyin, chi xa ma yin ta riyin ri Cristo, riyin xa yin jun tako'n ri xitak pe nabey chuwech Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Achi'el tek jun c'ajol ri xc'ule' can yetzijon chic c'a riq'ui ri k'opoj ri xoc rixjayil y ri ramigo ri c'ajol can niquicot c'a tek yerac'axaj chi ri c'ajol y ri k'opoj ri xec'ule' yetzijon chiquiwech. Quec'ari' riyin can niquicot ri wánima wacami, ruma xinwac'axaj chi sibilaj ye q'uiy winek ri ye'apon chic riq'ui ri Jesucristo. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ya ri Jesucristo ri ruc'amon (takal chrij) chi ninimirisex ruk'ij, yac'a riyin más utz chi yich'utiner ka. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri C'ajolaxel ri petenak chila' chicaj yac'ari' ri c'o pa kawi' konojel. Ri ye aj ruwach'ulef xaxu (xaxe wi) riche (rixin) re ruwach'ulef ri yecowin niquitzijoj, ruma xaxu (xaxe wi) ri' quetaman y ma quetaman ta riche (rixin) ri chicaj. Yac'a ri C'ajolaxel ri kajnek pe chila' chicaj, can ya riche (rixin) ri chicaj ri nutzijoj, ruma Riya' c'o pa ruwi' ronojel. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri C'ajolaxel c'a ri petenak chila' chicaj, can ya c'a ri rac'axan pe y rutz'eton ca, yari' ri noruk'alajsaj ka chake. Pero ri winek ma nicajo' ta c'a niquic'ul ri nuk'alajsaj Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Y ri winek ri niniman ri nuk'alajsaj ri C'ajolaxel ri petenak chila' chicaj, can nuk'alajsaj c'a chi ri Dios can kitzij wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ruma ri C'ajolaxel ri xutek pe ri Dios chuwech re ruwach'ulef, can ya wi ri ruch'abel ri Dios ri nutzijoj. Y ri Dios can ruya'on c'a pe ri Lok'olaj Espíritu chare. Y ri Lok'olaj Espíritu ri nuya' pe chare Riya', can ma pajtal ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y ri Tata'ixel can sibilaj c'a nrajo' ri Ruc'ajol, y pa ruk'a' Riya' rujachon wi ronojel cosas. ");
INSERT INTO cakWNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Achique c'a winek ri xtiniman riche (rixin) re C'ajolaxel, xtic'oje' c'a ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri winek ri ma nrajo' ta nunimaj ri Ruc'ajol ri Dios, man c'a xtic'oje' ta ruc'aslen riche (rixin) xtibe k'ij xtibe sek; xa can c'o chic c'a chi nika ri royowal ri Dios pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Ajaf Jesús xretamaj c'a chi ri achi'a' fariseos quic'axan chic chi Riya' más ye q'uiy winek ri yeruben bautizar y más ye q'uiy ri yetzekelben riche (rixin), que chiquiwech ri winek ri yeruben bautizar ri Juan ri Bautista y ri yetzekelben riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Astape' ri Jesús ma ya ta Riya' ri yebano bautizar ri winek, xa yec'a ri ye rudiscípulos ri yebano bautizar. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y tek ri Jesús xretamaj ronojel ri', xel c'a el pa Judea y xtzolin chic jun bey pa Galilea ye rachibilan ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Xa yac'a riche (rixin) chi ye'apon c'a pa Galilea, rajawaxic chi yek'ax ri pa Samaria. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri Jesús ye rachibilan ri rudiscípulos xe'apon c'a pa Sicar. Ri Sicar jun tinamit ri c'o pa rucuenta ri Samaria y c'o c'a apo chunakajal ri ulef ri xuya' ca ri Jacob chare ri José ri ruc'ajol. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y achi'el xa pa nic'aj k'ij chare ri k'ij ri' tek ri Jesús xe'apon chiri' y chiri' c'a c'o wi ri pozo riche (rixin) ri Jacob nibix chare. Chiri' c'a xtz'uye' wi ka ri Jesús, ruma Riya' can sibilaj c'a cosnek chic ruma ri binen ri quibanon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y tek ye benak c'a ri rudiscípulos pa tinamit chulok'ic riche (rixin) ri niquitij, xapon c'a jun ixok aj Samaria chuchi' ri pozo chirelesaxic ruya'. Y ri Jesús xubij c'a chare ri ixok ri': Tasipaj juba' nuya' riche (rixin) chi nkum, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero ri ixok aj Samaria xubij c'a chare ri Jesús: Riyit yit jun israelita, ¿y achique ruma tek nac'utuj aya' chuwe riyin, ri xa yin jun aj Samaria? xcha' ri ixok. Riya' xubij queri' ruma chi ri ye israelitas y ri ye aj Samaria ma yech'aben ta qui' (yech'o ta chiquiwech). ");
INSERT INTO cakWNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","C'ac'ari' ri Jesús xubij c'a chare ri ixok ri': Wi ta riyit awetaman achique chi sipanic ruya'on pe ri Dios, y awetaman ta chuka' achique c'a ri' ri nic'utun juba' ruya' chawe; xa yit ta riyit ri yac'utun aya' chare, y Riya' can ta nuya' Aya' ri can niya'o c'aslen, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y ri ixok xubij c'a chare ri Jesús: Táta, pero re pozo re' nej rupan y ri ya' nej c'o wi ka, y riyit majun c'o ta awuq'ui riche (rixin) chi nawelesaj ka ya'. ¿Acuchi (achique) c'a nac'om wi ri ya' ri niya'o c'aslen ri natzuj (nasuj)? ");
INSERT INTO cakWNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ruma chupan c'a re jun pozo re' xrelesaj wi ruya' ri kamama' Jacob, quiya' ri ralc'ual y quiya' chuka' quinojel ri chicop ri xeruq'uiytisaj. ¿Acuchi (achique) ta c'a xtac'om wi ri ya' ri natzuj (nasuj)? ¿La más ta c'a nim ak'ij riyit que chuwech ri kamama' Jacob chi ma wawe' ta c'a nac'om wi ri ya'? xcha' ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xubij c'a chare ri ixok: Ri yekumu re ya' re', re ntel chupan re pozo, xa juba' oc nrelesaj ri chaki'j chi' chique. Xa can nic'atzin c'a chi niquikum más ya' riche (rixin) chi nich'uch'u' ka juba' ri chaki'j chi' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Yac'a ri xquekumu ri ya' ri nya' riyin majun bey xtichaki'j ta chic quichi', xa xtuben pa cánima achi'el jun ralaxbel (rutz'ucbel) ya' ri can nibulbut (nibulbux) pe riche (rixin) chi yeruc'uaj c'a chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y ri ixok can yac'ari' xubij chare ri Jesús: Táta, taya' c'a ri ya' ri' chuwe riyin, riche (rixin) chi queri' majun bey chic c'a xtichaki'j ta nuchi', y riche (rixin) chi majun chic nic'atzin wi chi yipe wawe' chuchi' ri pozo chirelesaxic ya', xcha' ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xubij c'a chare ri ixok: Cabiyin y tasiq'uij (tawoyoj) ri awachijil, y c'ac'ari' yape chic, xuche'ex el ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xubij c'a: Riyin majun wachijil, xcha'. Y ri Jesús xubij chare: Kas kitzij wi ri xabij chi majun awachijil. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ruma can ye wu'o' chic awachijil quec'oje'. Y ri achi ri c'o awuq'ui wacami, xa ma awachijil ta. Rumari' can kitzij wi c'a ri xabij chi majun awachijil. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y can yac'ari' tek ri ixok xubij chare ri Jesús: Táta, riyin nch'ob chi riyit yit jun profeta ri yak'alajsan ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","¿Achique c'a lugar ri ruc'amon chi nikaya' wi ruk'ij ri Dios? Ruma ri kate' katata' ri xec'oje' ojer ca, pa ruwi' re jun juyu' re' c'o wi ri lugar ri xquiya' wi ruk'ij ri Dios. Ya chic c'a riyix israelitas nibij chi quinojel ri winek c'o chi ya ri pa Jerusalem niquiya' wi ruk'ij ri Dios, xcha' ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yac'a ri Jesús xubij chare ri ixok ri': Tanimaj c'a re xtinbij chawe. Can xtoka wi c'a jun k'ij tek quinojel ri winek ma ya ta chic pa ruwi' re juyu' re', ni ma pa Jerusalem ta chuka' xtiquiya' wi ruk'ij ri Katata' Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Riyix aj Samaria niya' c'a ruk'ij ri Dios pero ma k'axnek ta jabel chiwech achique ri'. Yac'a riyoj israelitas can ketaman wi ri achique ri nikaya' ruk'ij; ruma can ya c'a ri kiq'ui riyoj xtel wi pe ri nicolo quiche (quixin) ri winek chupan ri quimac. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ri jun k'ij ri xinbij chawe chi nipe, wacami ri', tek quinojel ri winek ri can kitzij chi niquiya' ruk'ij ri Katata' Dios, can xtiquiya' wi ruk'ij chi kitzij pan espíritu, astape' ma niquitz'et ta, ruma chi can ye ri yebano queri' ri yerucanoj ri Tata'ixel. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios can Espíritu wi y rumac'ari' ri winek nic'atzin chi kitzij pan espíritu niquiya' ruk'ij, astape' ma niquitz'et ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y ri ixok xubij c'a chare ri Jesús: Riyin wetaman c'a chi c'o na jun k'ij tek xtoka chuwech re ruwach'ulef ri Mesías, ri nibix chuka' Cristo chare. Y ri k'ij tek xtoka Riya', ronojel c'a xtuk'alajsaj chkawech, xcha' ri ixok. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubij c'a chare: Ri Mesías ri nibij chuka' Cristo chare, yin c'a riyin ri', ri yitzijon awuq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y yac'ari' tek xe'apon ri rudiscípulos y riye' jun wi juba' xquina' ruma nitzijon riq'ui jun ixok aj Samaria. Pero ri discípulos majun xquibij chare ri Jesús: ¿Achique nac'utuj chare? o ¿Achique ri natzijoj riq'ui? Majun c'a xquic'utuj ta chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y ri ixok ri' xuya' c'a ca ri rucucu' chiri' y xbe ri pa tinamit. Y xberubij c'a chique ri winek: ");
INSERT INTO cakWNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","C'o jun achi xtzijon wuq'ui y xubij c'a chuwe ronojel ri ye nubanalon. ¿La ma ya ta cami re' ri Cristo? Jo', y titz'eta', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y ri winek ri xe'ac'axan ri', xquiya' ca ri tinamit y xebe c'a acuchi (achique) c'o wi ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y tek c'a ma jane que'apon ta ri winek, ri discípulos xquibij c'a chare ri Jesús: Tijonel, cawa', xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Riya' xubij chique: Riyin c'o nuway ri ntij y riyix ma iwetaman ta achique ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Y ri rudiscípulos xquibij ka chiquiwech: ¿La c'o cami jun xc'amo pe ruway? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xubij chique: Ri oconek ruq'uexel nuway riyin ya c'a ri nben ri nrajo' ri yin takayon pe y nq'uis ca rubanic ronojel ri rusamaj ri ruchilaben pe chuwe. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Riyix nibij c'a chi c'a c'o na caji' ic' nrajo' riche (rixin) chi nic'ol ruwech ri tico'n. Yac'a riyin nbij chiwe: Quixtzu'un chila' y que'itzu' la winek. Riye' ye achi'el jun tico'n ri k'en chic. Coyoben chic riche (rixin) chi nitzijox ri ruch'abel ri Dios chique, riche (rixin) chi niquinimaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri xquebano c'a ri k'atoj, can c'o c'a rajel ruq'uexel xtiquic'ul; y ri ruwech ri tico'n ri xtiquimol ca, yac'ari' ri winek ri can xtiquic'ul quic'aslen riche (rixin) xtibe k'ij xtibe sek, riche (rixin) chi queri', ri ye tiquiyon ca ri ruch'abel ri Dios, y ri yec'olo ruwech ri tico'n ri', junan c'a xtiquicot ri cánima. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wawe' can kitzij c'a ntel wi ri tzij ri nubij: Jun wi c'a ri nibano ca ri ticoj y jun wi chic nic'olo ruwech ri tico'n. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Riyin xixintek c'a riche (rixin) chi xaxu (xaxe wi) chic nic'ol ruwech ri tico'n ri ma yix ta riyix ri yix samajiyon. Ruma ye nic'aj chic c'a samajela' ye tiquiyon ca ri tico'n ri', y riyix xaxu (xaxe wi) chic ximol ruwech ri tico'n ri quisamajin riye', xcha' ri Jesús chique ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupan c'a ri k'ij ri', ye q'uiy wi ri winek xeniman riche (rixin) ri Jesús ri chiri' pa tinamit Sicar, ri c'o chiri' pa rucuenta ri Samaria. Y ri' ruma chi ri ixok quere' xberubij chique ri winek: Ri Jesús xubij chuwe ronojel ri ye nubanalon, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Y ri ye aj Samaria ri' xbequic'utuj c'a utzil chare ri Jesús chi tic'oje' ka quiq'ui. Y Riya' xc'oje' c'a ka ca'i' k'ij quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y sibilaj ye q'uiy chic winek ri aj chiri' ri xeniman tek xquic'axaj ri ch'abel ri xubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ri winek ri' niquibila' c'a chare ri ixok ri xbeya'o rutzijol chique: Wacami ketaman chic y nikanimaj chuka', pero ma xaxu (xe) ta wi ruma ri xabij riyit chake, xa can nikanimaj chuka' ruma ri xkac'axaj riyoj y xketamaj c'a chi kas kitzij wi chi ya Riya' ri Cristo, ri Colonel quiche (quixin) quinojel winek ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Tek k'axnek chic ri ca'i' k'ij ri', xuya' c'a ca ri tinamit Sicar ri c'o pa rucuenta ri Samaria y xuchop chic c'a el ri rubey riche (rixin) chi xbe c'a pa Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Y can ya ri Jesús xk'alajsan chi tek jun profeta nuk'alajsaj ri ruch'abel ri Dios pa rutinamit, xa majun ruk'ij nitz'etetej cuma ri ruwinak. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero tek ri Jesús xapon pa Galilea, jabel ruc'ulic xban cuma ri winek aj chiri'; ruma ri winek ri' xec'oje' chuka' pa Jerusalem riche (rixin) ri nimak'ij y xquitz'et ri milagros ri xerubanala' ri Jesús chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'ac'ari' ri Jesús xbe chic c'a jun bey ri pa tinamit Caná ri c'o pa rucuenta ri Galilea, ri acuchi (achique) xuben wi chare ri relic ya' chi xoc ruya'al uva. Y chiri' pa Galilea, pa jun chic tinamit ri Capernaum rubi', c'o c'a jun achi nim ruk'ij, rumozo ri rey, y riya' c'o jun ruc'ajol yawa'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ri achi ri rumozo ri rey, tek xrac'axaj chi ri Jesús petenak c'a quela' pa Judea y xapon ri chiri' pa Galilea, xbe c'a riq'ui. Riya' xberuc'utuj jun utzil chare riche (rixin) chi nucol ta ri ruc'ajol chuwech ri camic, ruma ri c'ajol ri' ya xa nicom yan ka. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yac'ari' tek ri Jesús xubij c'a chare ri rumozo ri rey: Man ta nitz'et riyix ri milagros ri nben riyin, man ta yininimaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ri achi ri rumozo ri rey xubij c'a chare ri Jesús: Ajaf, tabana' c'a jun utzil chi caxule' pa tinamit Capernaum, ruma chi ri nuc'ajol ya xa nicom. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y ri Jesús xubij c'a chare: Catzolin. Ri ac'ajol nic'ase', xuche'ex el. Y ri achi ri' can xunimaj wi ri xubij ri Jesús, y xbe. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Tek ri achi ri' ruchapon ka rutzolejen, yec'o c'a ri rumozo ri xepe chuc'ulic y xquibij chare: Ri ac'ajol q'ues. Ma xcom ta, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y riya' xuc'utuj c'a chique ri rumozo chi achique c'a hora tek ri ruc'ajol xk'alajin chi nic'achoj. Y riye' xquibij: Ya ri tikak'ij iwir pa tek a la una, tek xq'uis el ri c'aten chrij, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Y ri tata'aj ri' chanin c'a xoka chuc'u'x chi ya hora ri' tek ri Jesús xubij chare chi ri ruc'ajol nic'ase'. Y riya' y ri ye aj pa rachoch can xquinimaj c'a ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y yac'are' ri ruca'n milagro ri xuben ri Jesús chiri' pa Galilea, y re' xuben tek tzolijnek chic pe quela' pa Judea. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y tek banatajnek chic c'a ronojel ri', yac'ari' tek xa noka yan c'a jun quinimak'ij ri israelitas, y rumari' ri Jesús xbe anej ri pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ri chiri' c'a pa tinamit Jerusalem, ri chunakajal apo ri puerta, puerta quiche (quixin) ri Carne'l nibix chare, c'o c'a jun atinibel. Y chiri' chuchi' ri ya' yec'o c'a wu'o' ruchi' raken jay. Y pa quich'abel ri israelitas niquibij c'a Betesda chare ri lugar ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ri chiri' c'a chuchi' ri raken tek jay ri' yec'o q'uiy yawa'i' ye cotz'ol pan ulef. Yec'o ye moyi', yec'o ri ma choj ta yebiyin ruma chi ye cojo y yec'o ye siquirnek. Y yec'o c'a ri jun wi chic ruwech yabil ntoc chique. Y ronojel c'a quiwech yawa'i' ri yec'o chiri', can coyoben c'a chi nisilox ri ya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ruma ri ya' ri' c'o c'a jantek nosilox ca ruma jun ángel ri nipe chila' chicaj. Y ya c'a ri yawa' ri nika ka nabey chupan ri ya' tek silon chic ca, ya c'a yawa' ri' ri nic'achoj. Y xabachique ta na yabil ntoc chare ri yawa', nic'achoj el. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chiri' chuchi' ri ya' c'o c'a jun achi ri c'o chic treinta y ocho juna' yawa' wi pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun k'ij tek ri Jesús nik'ax c'a el queri', xutz'et c'a ri achi cotz'ol chiri'. Y Riya' can retaman c'a chi ri achi ri' q'uiy yan chic juna' ri queri' ruc'ulwachin pe. Yac'ari' tek Riya' xuc'utuj c'a chare ri achi ri': ¿Nawajo' yac'achoj? ");
INSERT INTO cakWNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y ri yawa' ri' xubij c'a chare ri Jesús: Táta, tek nisilon pe ri ya', majun yito'o ta riche (rixin) chi yinapon ta apo c'a chupan. Rumari', astape' ntij nuk'ij chi yibe ta apo, c'a ma jane quinapon ta, tek xa can yari' xapon yan jun chic, xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y ri Jesús xubij chare ri achi: Cayacatej, tac'uaj el la awarabel y cabiyin, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Can xu (xe) wi c'a xubij queri' ri Jesús chare ri yawa', can yac'ari' tek xc'achoj chare ri ruyabil. Xuc'ol c'a el ri ruwarabel y xuchop el binen. Ri k'ij c'a ri', uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y ri achi'a' israelitas ri c'o quik'ij, xquibij chare ri achi ri xc'achojsex chare ri ruyabil: Wacami uxlanibel k'ij, xajan chi riyit awejkalon la awarabel. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero riya' xubij c'a chique ri achi'a' ri': Ri xc'achojsan wuche (wixin) xubij chuwe: Tac'olo' el la awarabel y cabiyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achi'a' ri' xquic'utuj c'a chare ri achi: ¿Achique c'a ri xbin chawe chi tac'olo' el ri awarabel y cabiyin? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri achi ri xc'achojsex, ma retaman ta c'a achique ri xc'achojsan chare ri ruyabil; ruma ri Jesús xa ma xc'oje' ta ka chiri' chiquicojol ri winek. Riya' xa xbe el. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","C'a juba' c'a ri' tek ri Jesús xberila' chic ri achi ri' pa rachoch ri Dios, y xubij chare: Wacami yit utz chic. Man chic c'a camacun ta, riche (rixin) chi queri' ma nipe ta jun cosa ri más chi na itzel chawij, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y ri achi xtzolin el, y xapon c'a quiq'ui ri achi'a' israelitas ri c'o quik'ij, y xubij chique: Ri xc'achojsan wuche (wixin), ya ri Jesús, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rumari' tek ri achi'a' israelitas ri c'o quik'ij xeyacatej c'a chrij ri Jesús, y niquich'obola' c'a chi achique ta rubanic niquiben riche (rixin) chi niquicamisaj; ruma ri Jesús c'o milagros yerubanala' chupan ri uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xubij: Ri Nata' Dios can c'a ntajin na nisamej re wacami, y que c'a chuka' ri' riyin, yisamej, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y rumac'ari' tek ri achi'a' israelitas ri c'o quik'ij, xa más xquichop ruch'obic chi achique ta rubanic niquiben riche (rixin) chi niquicamisaj ri Jesús; ruma chiquiwech riye', xajan ri yerubanala' chupan ri uxlanibel k'ij. Y chuka' ma xu (xe) ta c'a rumari', xa can ruma c'a chuka' chi ri Jesús nubij Rutata' chare ri Dios; can nuben chi Riya' can junan riq'ui ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y yac'ari' tek ri Jesús xubij: Can kitzij c'a re nbij chiwe, chi riyin ri C'ajolaxel ma yisamej ta pa nuyonil; xa ya ri ntz'et riq'ui ri Tata'ixel ri nben. Ronojel ri nuben ri Tata'ixel, yari' chuka' nben riyin ri C'ajolaxel. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y ruma ri Tata'ixel sibilaj yirajo' riyin ri Ruc'ajol, rumari' tek Riya' nuc'ut chinuwech ronojel ri rusamaj. Y yec'o samaj más ye nima'k que chuwech re' ri xtuc'ut chinuwech. Y tek nitz'et ri nben riyin, riyix can xtimey. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y can achi'el c'a nuben ri Tata'ixel tek nuya' quic'aslen ri caminaki' chi yeruyec pe, can queri' chuka' nben riyin ri C'ajolaxel, can nya' c'a chuka' c'aslen chique ri winek ri achoj chique nwajo' nya' wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Tata'ixel ma ya ta c'a Riya' nik'ato tzij. Can pa nuk'a' c'a riyin ri C'ajolaxel xujech wi chi nk'et tzij. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Riche (rixin) chi queri', quinojel tiquiya' nuk'ij riyin ri C'ajolaxel achi'el niquiya' ruk'ij ri Tata'ixel. Ruma achique winek ri ma xtiya'o ta nuk'ij riyin ri C'ajolaxel, ma nuya' ta c'a chuka' ruk'ij ri Tata'ixel ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Can kitzij wi ri nbij chiwe, chi ri nac'axan ri nuch'abel y nunimaj ri yin takayon pe, nril ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Y man c'a xtapon ta chupan ri lugar riche (rixin) tijoj pokonal, ruma colotajnek chic pe chuwech ri camic, y xk'ax chupan ri c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y kitzij c'a re nbij chiwe, chi c'o c'a jun k'ij ri oyoben y yare' xoka; chi ri achi'el ye caminaki' xtiquic'axaj c'a ri nuch'abel riyin ri C'ajolaxel. Y ya c'a ri xque'ac'axan, xtiquil quic'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ruma can achi'el ri Tata'ixel can nuya' c'aslen, queri' chuka' xuya' chuwe riyin ri C'ajolaxel chi can nya' c'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y chuka' ri Tata'ixel xuya' k'atbel tzij pa nuk'a' riche (rixin) chi nk'et tzij, ruma can yin c'a riyin ri C'ajolaxel ri xinalex chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ma tisach ta ic'u'x ruma ri xinbij chiwe, ruma xtapon c'a k'ij tek ri ye caminaki' can c'o c'a chi xtiquic'axaj ri nuch'abel. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y yec'a ri xe'uc'uan jun c'aslen utz chuwech ri Dios, xquebec'astej c'a pe riche (rixin) chi xtiquil jun quic'aslen riche (rixin) xtibe k'ij xtibe sek. Y ri xa itzel c'aslen xquic'uaj chuwech ri Dios, xquebec'astej c'a pe riche (rixin) chi xquebe pa ruc'ayewal. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Riyin ma pa nuyonil ta c'a yisamej, ruma achi'el ri k'atoj tzij ri nibix chuwe, queri' ri nben. Ri k'atoj tzij ri nben riyin can pa ruchojmilal; ruma ma ya ta ri nwajo' riyin ri nben, xa can ya ri nrajo' ri Nata' Dios ri yin takayon pe, yari' ri nben. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Y wi xa ta nuyon riyin nk'alajsaj ka wi', ri nbij ka chuwij riyin ri' xa man ta kitzij. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero can c'o c'a jun ri nik'alajsan wuche (wixin). Y ri nubij riya' chuwij riyin, can kitzij wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Y riyix can xitek c'a ruc'utuxic chare ri Juan ri Bautista wi ya riya' ri Cristo, pero riya' xa can yin c'a riyin ri xiruk'alajsaj pe chiwe y can ya c'a ri kitzij ri xubij pe chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero ri xubij ri Juan o ri nubij jun ta chic achi chuwij riyin, ma rajawaxic ta c'a chuwe riyin. Ri xubij ri Juan nnataj apo chiwe ruma rajawaxic chiwe riyix, riche (rixin) chi yixcolotej. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y ri Juan ri Bautista can xuya' c'a ri sakil chiwe. Can xuben wi c'a achi'el nuben jun k'ak' tek nic'at y nisakirisan. Y riyix xirayij y xixquicot c'a riq'ui ri sakil ri', pero xa jun ca'i' oxi' oc k'ij ri xiben queri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero ri samaj ri yitajin chubanic yari' ri más nik'alajsan wuche (wixin) que chuwech ri xubij ri Juan, ruma ri nben riyin can ya samaj ri' ri rubin pe ri Tata'ixel chuwe. Y ri samaj ri yenben riyin yari' nik'alajsan wuche (wixin) chi can ya ri Tata'ixel ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y ya c'a ri Nata' Dios ri xtako pe wuche (wixin), Riya' can c'o utz ri ruk'alajsan pe chuwij riyin. Y riyix majun bey iwac'axan ta achique rubanic nich'o, ni majun bey chuka' itz'eton ta ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri ruch'abel Riya' can man c'o ta pa tak iwánima, ruma chi riyix xa ma yininimaj ta riyin ri xitak pe riche (rixin) chi yinoc'oje' ka chicojol. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Can tinic'oj c'a jabel rupan ri ruch'abel ri Dios ri tz'ibatal ca, ruma iwetaman chi chupan ri' niwil wi ri c'aslen riche (rixin) xtibe k'ij xtibe sek. Y ri ruch'abel ri Dios can ya c'a ri' ri nik'alajsan wuche (wixin) riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Xa yac'a riyix ma niwajo' ta nicukuba' ic'u'x wuq'ui, riche (rixin) chi queri' niwil ta ri c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ri ch'abel ri xinbij chiwe ma riche (rixin) ta chi ri winek niquiya' nuk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Riyin xa can wetaman c'a iwech chi riyix xa ma niwajo' ta ri Dios pa tak iwánima. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ruma riyin can pa rubi' ri Nata' Dios yin petenak wi y xa ma yinic'ul ta. Pero xa ta c'o jun chic ri petenak pa rubi' ka riya' y xa ma pa rubi' ta ri Dios petenak wi, yari' can nic'ul wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Riyix xa ma riq'ui ta ri kitzij Dios nicanoj wi ik'ij, xa chicojol ka riyix mismo nicanoj wi ka ik'ij, y rumari' tek ma nicukuba' ta ic'u'x wuq'ui riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man c'a tich'ob ta ri pa tak iwánima chi riyin xquitzujun (xquisujun) chiwij chuwech ri Nata' Dios. Ma que ta ri'. Ri xtitzujun (xtisujun) c'a chiwij chuwech ri Dios, ya ri Moisés; ri achoj riq'ui nibij chi can icukuban wi apo ic'u'x. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ruma xa ta can kitzij chi riyix ninimaj ri ye rutz'iban ca ri Moisés, can yininimaj ta chuka' riyin, ruma ri ye rutz'iban ca riya', can chuwij wi riyin yech'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y wi xa ma ninimaj ta ri ye tz'ibatal ca ruma ri Moisés, ¿achique ta c'a modo tek xtinimaj ri ch'abel ri yenbij chiwe riyin? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Y tek ye banatajnek chic c'a ca ronojel ri', ri Jesús y ri rudiscípulos xebe c'a juc'an chic ruchi' ri choy Galilea; y ri choy ri' nibix chuka' Tiberias chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Can ye sibilaj q'uiy winek ri xetzekelben el riche (rixin), ruma ri winek ri' quitz'eton chic c'a ri milagros ri nik'alajsan riche (rixin) chi ya ri Dios takayon pe, milagros ri yerubanala' tek yeruc'achojsaj ri yawa'i'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús y ri rudiscípulos xejote' c'a anej pa ruwi' jun juyu'; y Riya' xtz'uye' c'a chiquicojol ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri k'ij c'a ri', xa nakaj chic c'a c'o ri jun chique ri quinimak'ij ri israelitas ri pascua rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y tek ri Jesús xtzu'un apo, xerutz'et c'a chi can sibilaj ye q'uiy winek ri ye aponak riq'ui. Rumari' Riya' quec'are' xubij chare ri jun chique ri rudiscípulos ri Felipe rubi': ¿Acuchi (achique) xtibekalok'o' wi pe caxlan wey riche (rixin) chi yekatzuk quinojel re winek re'? xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quec'are' ri xubij ri Jesús chare ri Felipe, riche (rixin) chi nretamaj achique c'a xtubij ri discípulo ri'. Pero ri Jesús xa can retaman chic achique ri xtuben riche (rixin) chi yerutzuk ri winek ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y ri Felipe xubij c'a chare ri Jesús: Wi ta nikalok' ca'i' ciento denario caxlan wey, ma xqueruben ta. Astape' xa ta juba' oc nikaya' chique chiquijujunal, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yac'ari' tek jun c'a chique ri rudiscípulos, ri Andrés rubi', ri rach'alal ri Simón Pedro, xubij: ");
INSERT INTO cakWNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Wawe' c'o jun c'ajol ri c'o wu'o' caxlan wey riq'ui ri banon riq'ui cebada y ca'i' tak car ye ruc'amom pe, pero, ¿la xaxu (xaxe wi) ta c'a oc re' ri xtikaya' apo chiquiwech quinojel re winek re'? xcha' ri Andrés. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yac'ari' tek ri Jesús xubij c'a: Tibij chique ri winek chi quetz'uye' pa ruwi' ri rexlaj k'ayis. Ruma ri lugar ri' can jabel c'a riche (rixin) chi yetz'uye'. Quinojel c'a ri winek quimolon qui' chiri', xetz'uye'. Yec'o achi'el xa ye wu'o' mil xaxu (xaxe wi) ri achi'a'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Y ri Jesús xeruli'ej c'a pa ruk'a' ri wu'o' caxlan wey ri', y tek rumatioxin chic chare ri Dios, c'ac'ari' xujachala' el chique ri rudiscípulos y ri discípulos xbequijachala' ca chique ri winek ri ye tz'uyul. Y ri Jesús can queri' chuka' xuben riq'ui ri ca'i' car. Ri winek can xquic'ul c'a ri janipe' caxlan wey y car ri xcajo'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y tek ye waynek chic c'a jabel ri winek ri', ri Jesús xubij c'a chique ri rudiscípulos: Tic'olo' c'a pe ronojel ri caxlan wey y car ri ma xq'uis ta, ruma ma nwajo' ta c'a chi c'o ta yec'oje' ca queri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri discípulos can xbequimolo' c'a pe y xquinojsaj cablajuj chaquech riq'ui ri ma xq'uis ta rutijic, tek ye waynek chic quinojel. C'a ya na c'a ri' xmolotej ca chare ri wu'o' tak caxlan wey banon riq'ui cebada. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y ri winek ri', tek xquitz'et ri milagro ri xuben ri Jesús, xquibij c'a: Can kitzij wi chi ya achi re' ri profeta ri c'o yan chic tiempo bin wi pe chi nipe chuwech re ruwach'ulef, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús ruyon c'a xtzolin anej pa ruwi' ri juyu', ruma xunabej chi ri winek xquepe chuc'amaric riche (rixin) chi niquiben qui-rey chare y astape' ma nrajo' ta Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y tek ri rudiscípulos ri Jesús xquitz'et chi xoc pe ri ak'a', xexule' ka chuchi' choy. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Riye' xe'oc c'a el pa jun jucu' y quichapon c'a bey ye benak pa ruwi' ya' riche (rixin) chi yebe c'a pa tinamit Capernaum, ri c'o c'a juc'an chic ruchi' ya'. Sibilaj chic k'eku'm chiri' y ri Jesús xa ma aponak ta quiq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y yac'ari' tek xyacatej pe jun nimalaj cak'ik' pa ruwi' ya'; jun cak'ik' ri sibilaj nim ruchuk'a'. Y rumari' ri ya' can sibilaj c'a nisilon. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Y tek ye biyinek chic c'a jun wu'o' o waki' kilómetros pa ruwi' ri choy, ri discípulos xquitz'et chi ya ri Jesús ri petenak chraken pa ruwi' ri choy y xa juba' ma yeruk'i'. Y sibilaj c'a xquixibij qui'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xubij c'a chique: Ma tixibij ta iwi'. Xa yin c'a riyin, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ri discípulos xquic'axaj na c'a chi can ya wi ri Jesús, c'ac'ari' xcuke' ka quic'u'x y riq'ui quicoten xquic'ul apo ri Jesús chupan ri jucu'. Y can yac'ari' tek xe'apon chuchi' ya', ri lugar ri c'o chi ye'apon wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Pa ruca'n k'ij ri winek ri xec'oje' ca ri juc'an chic ruchi' ya' ri acuchi (achique) xetzuk wi ruma ri Jesús, riye' quetaman chi xa jun jucu' ri xc'oje' chiri' y majun chic jun, y quetaman chi ri Jesús ma xoc ta el quiq'ui ri rudiscípulos tek xebe el ruma xa quiyon c'a ri discípulos ri xebe, y ri Jesús xa xc'oje' ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ri k'ij c'a ri', yec'o c'a jucu' ri ye petenak pa tinamit Tiberias ri xe'apon chunakajal ri acuchi (achique) xewa' wi ri winek ri jun k'ij ca, tek xquitij ri caxlan wey ri xuya' ri Ajaf Jesús chique, tek rumatioxin chic chare ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y ri winek ri', ruma xquitz'et chi ri Jesús xa man c'o ta chic chiri' y chuka' ri rudiscípulos xa ma yec'o ta chic chiri', riye' chuka' xe'oc el ri pa tak jucu' y xebe pa Capernaum chucanoxic ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Tek ri winek ri' xbequila' ri Jesús ri juc'an chic ruchi' choy, xquibij c'a chare: Tijonel, ¿ajan (jampe') catoka wawe'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Y ri Jesús xubij c'a chique ri winek ri': Kitzij nbij chiwe, chi riyix yinicanoj pero ma ruma ta xe'itz'et ri milagros ri xenbanala' riyin ri yek'alajsan wuche (wixin) chi ya ri Dios yin takayon pe. Yinicanoj pero xa ruma xixwa' jabel wuq'ui y xixnoj. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Quixsamej c'a, pero ma riche (rixin) ta chi nicanoj iway ri xa niq'uis ka. Quixsamej pero riche (rixin) chi nicanoj iway ri nuya' ic'aslen riche (rixin) xtibe k'ij xtibe sek. Wey ri xtinya' chiwe riyin ri C'ajolaxel ri xinalex chicojol, ruma yin c'a riyin xirutek pe ri Tata'ixel, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y ri winek ri' xquibij c'a chare ri Jesús: ¿Achique c'a ri nika chuwech ri Dios chi nikaben riche (rixin) chi queri' nikaben ri nrajo' Riya'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y ri Jesús xubij c'a chique: Ri nika chuwech ri Dios chi niben riyix, ya ri yininimaj riyin ri xitak pe ruma Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y ri winek xquibij chare ri Jesús: ¿Achique c'a ri yacowin naben? Tabana' jun milagro chkawech riche (rixin) chi queri' nikatz'et y yatkanimaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ruma ri ojer tak kati't kamama', tek xek'ax chupan ri jun desierto, ya c'a ri caxlan wey ri xubini'aj maná ri xuya' ri Moisés chique riche (rixin) chi xquitij. Can achi'el wi c'a ri nubij ri ruch'abel ri Dios ri tz'ibatal ca. Chiri' nubij: Caxlan wey c'a ri petenak chila' chicaj ri xuya' chique riche (rixin) chi xquitij. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y ri Jesús xubij c'a chique: Kitzij re xtinbij chiwe: Tiwac'axaj na pe'. Ri caxlan wey ri xpe chila' chicaj, ma ya ta c'a ri Moisés ri xya'o, ya c'a ri Nata' ri xya'o. Ya c'a chuka' Riya' ri niya'o chiwe wacami ri kitzij caxlan wey riche (rixin) chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ruma ri caxlan wey ri nuya' ri Dios, can ya c'a ri C'ajolaxel ri petenak chila' chicaj. Y yari' ri niya'o c'aslen chique ri winek chuwech re ruwach'ulef, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tek xquic'axaj queri' ri winek, xquibij c'a chare ri Jesús: Táta, can ronojel k'ij c'a taya' ri caxlan wey ri' chake, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y ri Jesús xubij c'a chique: Yin c'a riyin ri caxlan wey ri yiya'o c'aslen. Ri xtucukuba' ruc'u'x wuq'ui, man chic c'a xtinum ta ri ránima. Y chuka' ri xtiniman wuche (wixin), ma xtutij ta chic chaki'j chi' ri ránima. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero can achi'el c'a ri nbin chiwe, chi astape' riyix can itz'eton ri nben riyin, xa ma yininimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Quinojel ri winek ri yeyatej na chuwe ruma ri Nata', xquepe chinucanoxic y riyin xquenc'ul; y majun bey xquenwetzelaj ta el. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ruma riyin ma yin kajnek ta pe chila' chicaj chubanic ri nwajo' riyin. Riyin yin kajnek pe chubanic ri samaj ri nrajo' ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Y ri nrajo' ri Nata' Dios ri yin takayon pe, ya c'a chi quinojel ri ye ruya'on chuwe, man ta jun xtisach ca, y pa ruq'uisbel k'ij xquenc'asoj el chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri nrajo' ri Nata' ri yin takayon pe, ya c'a chi quinojel ri yetz'eto ri C'ajolaxel y niquinimaj, xtic'oje' c'a quic'aslen riche (rixin) xtibe k'ij xtibe sek y xquenc'asoj el chiquicojol ri caminaki' ri pa ruq'uisbel k'ij, xcha' ri Jesús chique ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yac'a ri winek israelitas ri' yexebexot (yexebeloj) apo chrij ri Jesús, ruma Riya' xubij: Riyin ri caxlan wey ri kajnek pe chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y yequibila' c'a: ¿La xa ma ya ta cami re' ri Jesús ri ruc'ajol ri José? Xa ketaman c'a quiwech ri rute' rutata'. ¿Achique c'a ruma nubij chi Riya' kajnek pe chila' chicaj? ");
INSERT INTO cakWNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xubij c'a chique: Ma quixxebexot (quixxebeloj) ta pe chuwij. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Majun winek ri nicowin nipe wuq'ui, wi ma ya ta ri Tata'ixel ri takayon pe wuche (wixin) ri nibano pe chare chi nipe wuq'ui. Y ri yeniman wuche (wixin) xquenc'asoj c'a el chiquicojol ri caminaki' ri pa ruq'uisbel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Y tz'ibatal chuka' ca cuma ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, chi quinojel ri winek xquetijox na ruma ri Dios, queri' ri nubij. Y ri achique c'a ri nrac'axaj ri ruch'abel ri Nata' Dios y nretamaj, can xtipe c'a chinucanoxic. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero majun winek ri tz'eteyon ta riche (rixin) ri Tata'ixel. Xaxu (xaxe wi) riyin ri yin petenak chila' chicaj riq'ui Riya' ri yin tz'eteyon ruwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Can kitzij c'a ri nbij chiwe: Ri niniman c'a wuche (wixin), can c'o ruc'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yin c'a riyin ri caxlan wey ri yiya'o ri c'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Tek ri iwati't imama' xek'ax chupan ri desierto, riye' xquitij ri caxlan wey ri xubini'aj maná, pero ma xuya' ta quic'aslen riche (rixin) xtibe k'ij xtibe sek, xa xecom. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yac'a ri kas kitzij caxlan wey, ri kajnek pe chila' chicaj, nuben chique ri yetijo chi ma xque'apon ta chupan ri camic riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yin c'a riyin ri caxlan wey ri yiya'o c'aslen ri xika pe chila' chicaj. Ri xquetijo c'a re caxlan wey re', xquec'ase' riche (rixin) xtibe k'ij xtibe sek. Ri caxlan wey c'a ri xtinya' riyin chique can ya c'a ri nuch'acul, ri xtapon pa camic riche (rixin) chi nuya' quic'aslen ri winek ri yec'o chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y ri winek israelitas ri', tek xquic'axaj ri xubij ri Jesús, xquichop c'a ch'a'oj chiquiwech ka riye' y niquibila' c'a: ¿Achique c'a rubanic ri' chi Riya' nuya' ri ruch'acul chake riche (rixin) chi nikatij? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ri Jesús xubij c'a chique: Kitzij wi nbij, wi xa ma nitij ta ri nuch'acul y ma nikum ta chuka' ri nuquiq'uel riyin ri C'ajolaxel ri xinalex chicojol, man c'o ta ri ic'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri xtiquitij c'a ri nuch'acul y xtiquikum chuka' ri nuquiq'uel, c'o c'a ri quic'aslen riche (rixin) xtibe k'ij xtibe sek. Y riyin xquenc'asoj el chiquicojol ri caminaki' ri pa ruq'uisbel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ruma ri nuch'acul yari' ri kitzij caxlan wey y ri nuquiq'uel yari' ri kitzij ya' ri can niya'o c'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri niquitij c'a ri nuch'acul y niquikum chuka' ri nuquiq'uel, xa jun c'a ri xtikaben quiq'ui. Riye' xquec'oje' wuq'ui riyin y riyin quiq'ui riye'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ri Tata'ixel ri yin takayon pe, can c'o wi ruc'aslen y ruma chuka' Riya' c'o nuc'aslen. Y can queri' c'a chuka' ri winek ri xquinquic'ul riyin, can xquec'ase' wi wuma riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri kas kitzij caxlan wey, ri kajnek pe chila' chicaj, ma junan ta riq'ui ri maná ri xquitij ri iwati't imama', ruma riye' xquitij ri maná pero ma riq'ui wi ri', ma xec'ase' ta riche (rixin) xtibe k'ij xtibe sek, xa xecom. Yac'a ri niquitij ri kitzij caxlan wey ri kajnek pe chila' chicaj, xtic'oje' quic'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yac'are' ri xubij ri Jesús chique ri winek israelitas ri quimolon qui' chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios chiri' pa tinamit Capernaum. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Y tek ri yetzekelben riche (rixin) ri Jesús quic'axan chic ka ri xubij, ye q'uiy c'a chique riye' ri xquibij: Can c'ayef (cuesta) ruc'uaxic ri xubij. ¿Achique ta c'a xtiniman re tzij re'? xecha' ka. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Y ri Jesús can retaman wi ri yetajin niquich'ob pa tak cánima ye q'uiy chique ri yetzekelben riche (rixin), rumari' xubij chique: ¿Achique ruma tek riyix nich'ob chi c'ayef (cuesta) riche (rixin) chi xtinimex ri xinbij? ");
INSERT INTO cakWNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Wi ta yinitz'et riyin ri C'ajolaxel ri xinalex chicojol chi yitzolin chila' riq'ui ri Dios ri acuchi (achique) yin petenak wi, ¿la ma yininimaj ta cami? ");
INSERT INTO cakWNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri ruc'aslen ri ich'acul, ya ri ru'espíritu ri niya'o. Ri ich'acul xa majun rejkalen. Yac'a ri ch'abel ri ye nbin chic ka chiwe ye espíritu y ye c'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero c'a ye q'uiy na chiwe riyix ri ma yinquinimaj ta, xcha' ri Jesús. Queri' xubij ruma Riya' can pa rutiquiribel retaman chic pe achique winek ri ma xqueniman ta riche (rixin), y ri achique ri xtijacho el riche (rixin) pa quik'a' ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y ri Jesús xubij c'a: Rumari' xinbij chiwe chi majun winek ri nicowin ta nipe wuq'ui, wi ma ya'on ta pe chare ruma ri Tata'ixel chi nucukuba' ruc'u'x wuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ruma c'a ri xubij ri Jesús, ye q'uiy c'a chique ri can yetzekelben riche (rixin), man chic xquitzekelbej ta. Xa can xetzolin ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y ri Jesús xubij c'a chique ri cablajuj rudiscípulos: ¿Riyix chuka' niwajo' yixbe ca? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y ri Simón Pedro xubij c'a chare ri Jesús: Ajaf, ¿achoj riq'ui ta c'a chic yojbe wi? Majun chic jun achoj riq'ui yojbe wi, ruma xaxu (xaxe) wi ri ach'abel riyit ri niya'o c'aslen riche (rixin) xtibe k'ij xtibe sek. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Riyoj can kacukuban kac'u'x awuq'ui y ketaman chi yit c'a riyit ri Cristo, ri Ruc'ajol ri c'aslic Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y ri Jesús xubij c'a: Astape' can yin c'a riyin ri xicha'o iwuche (iwixin) riyix cablajuj, ma riq'ui wi ri', can c'o c'a jun itzel winek xel chicojol, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Tek ri Jesús xunataj c'a ri jun ri itzel winek, chrij c'a ri Judas Iscariote xch'o wi; ri Judas ri ruc'ajol ri jun achi Simón rubi'. Ri Jesús xunataj c'a ri jun ri', ruma yac'ari' ri xtic'ayin el riche (rixin) ri Jesús. Y riya' can jun c'a chique ri cablajuj rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Y c'ac'ari' tek ri Jesús xbe pa tak tinamit ri yec'o pa rucuenta ri Galilea. Man c'a nrajo' ta chic napon pa tak tinamit ri yec'o pa rucuenta ri Judea, ruma ri achi'a' israelitas ri c'o quik'ij, niquicanola' c'a achique ta rubanic niquiben riche (rixin) chi niquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ri k'ij c'a ri', xa can nakaj chic c'a c'o wi ri jun chique ri quinimak'ij ri israelitas; jun nimak'ij tek ri israelitas yec'oje' pa tak ca'aj ri ye banon riq'ui ruk'a' tak che', riche (rixin) chi niquinatabej ri tiempo ri xquik'axaj ri cati't quimama' chupan ri desierto. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Y ri ye rach'alal c'a ri Jesús xquibij chare: Catel el juba' re pa Galilea y jet c'a pa Judea, riche (rixin) chi queri' ri winek ri yetzekelben awuche (awixin) ri yec'o chila', niquitz'et ri milagros ri ye'abanala'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ruma tek c'o jun ri nrajo' nuk'alajsaj ri' chiquiwech ri winek, ma utz ta c'a chi nrewaj ri'. Y riyit ruma chi naben re cosas re', can nic'atzin chi nak'alajsaj awi' chiquiwech ri winek, yecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Astape' riye' can cach'alal ri Jesús, pero xa man c'a niquinimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y yac'ari' tek ri Jesús xubij c'a chique ri ye rach'alal: Riyin ma jane napon ta ri k'ij riche (rixin) chi yibe. Yac'a riyix utz chi xabachique hora yixbe. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Riyix majun modo chi xquixetzelex ta cuma ri winek ri xa riq'ui ri ruwach'ulef quicukuban wi quic'u'x. Yac'a riyin can yinquetzelaj wi, ruma riyin can nk'alajsaj ri itzel ri yequibanala'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jix c'a iyon riyix chupan ri nimak'ij. Riyin xa c'a ma jane yibe ta chupan ri nimak'ij ri'. Ruma ri k'ij riche (rixin) chi nk'alajsaj wi', can c'a ma jane napon ta, xcha' ri Jesús chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y tek ri Jesús rubin chic c'a ronojel re' chique ri ye rach'alal, Riya' c'a xc'oje' na ca ri chiri' pa Galilea. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y tek ye benak chic ri ye rach'alal chupan ri nimak'ij ri', c'ac'ari' tek Riya' xbe. Pero xa ma xuc'ut ta ri' tek xbe. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yac'a chupan ri nimak'ij ri', ri achi'a' israelitas ri ye'etzelan riche (rixin) ri Jesús, yexule' yejote' chucanoxic y niquic'utula' c'a chique ri winek: ¿La ma itz'eton ta ri jun achi ri'? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicojol ri winek ri yec'o chupan ri nimak'ij ri', q'uiy c'a ri niquibij chrij ri Jesús. Yec'o ri niquibij chi ri Jesús can utzilaj achi wi. Yec'o ri ma que ta ri' niquibij, xa niquibila' c'a chi ri Jesús xa yeruk'ol ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero majun c'a chique ri winek ri yebin queri' ri niquik'alajsaj ta qui', ruma xa niquixibij c'a qui' chiquiwech ri israelitas ri c'o quik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y yac'a tek nic'ajarnek ri nimak'ij, yac'ari' tek ri Jesús xapon ri pa rachoch ri Dios ri chiri' pa Jerusalem. Y Riya' can nuc'ut c'a ri ruch'abel ri Dios chiquiwech ri winek ri quimolon qui' chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri achi'a' israelitas ri can c'o quik'ij, can xquimey c'a ri yerubij ri Jesús, y rumari' niquibij: ¿Achique c'a ruma re achi re' can q'uiy retaman chrij ri ruch'abel ri Dios y xa majun bey xutijoj ta ri'? yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero ri Jesús xubij: Ri utzilaj tak ch'abel ri yenc'ut riyin, can ya ri yin takayon pe ri chilabeyon pe chuwe. Re' ma wuche (wixin) ta c'a riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y ri winek ri can nrajo' c'a nuben ri achi'el nrajo' ri Dios, ri winek ri' can xtretamaj c'a, wi ri utzilaj ch'abel ri nc'ut riyin can riq'ui ri Dios petenak wi o xa nuyon riyin yibin. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Achique c'a winek ri ruyon riya' nuk'alajsaj ka ri', can nrajo' c'a chi niya'ox (nya') ruk'ij cuma ri winek. Yac'a riyin nwajo' chi riyix niya' ta ruk'ij ruc'ojlen ri Dios ri yin takayon pe. Y yari' nik'alajsan wuche (wixin) chi can kitzij wi ri nbij y majun etzelal wuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ri Moisés xuya' ri ley pan ik'a', pero majun chiwe riyix nunimaj ta ri nubij ri ley ri', ruma chi riyix can nitij ik'ij riche (rixin) chi niwajo' yinicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y ri winek xquibij c'a: La' xa c'o jun itzel espíritu awuq'ui ri yit ch'ujirisayon. ¿Achique c'a ri najowan nicamisan awuche (awixin)? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xubij c'a chique: Riyix can ximey tek xitz'et chi riyin pa jun uxlanibel k'ij tek xinben jun milagro. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Y ri Moisés tek xuya' ri ley, xubij c'a chi tiban ri circuncisión chique ri tak c'ajola' (alaboni'). Pero xa ma ya ta c'a riya' ri xtiquiriban pe, xa ye ri ojer tak kati't kamama' ri xetiquiriban pe. Y rumari' riyix, tek napon ri wakxaki' k'ij talex wi jun ac'al ti c'ajol (ala'), astape' pa jun uxlanibel k'ij, can niben wi c'a ri circuncisión chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Riyix nibij chi ma niwajo' ta yixk'ax pa ruwi' ri nubij chupan ri ley ri ruya'on ca ri Moisés, y rumari' astape' pa jun uxlanibel k'ij riyix can niben wi ri circuncisión. ¿Y achique ruma tek xpe iwoyowal chuwe riyin ruma xinc'achojsaj jun achi pa jun uxlanibel k'ij? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man c'a tibij ta chi riyin ma utz ta ri xinben, ruma queri' nitz'et riyix. Xa can tiwetamaj na c'a jabel, la kas queri' o ma que ta ri'; riche (rixin) chi queri' ma yixsach ta riq'ui ri nibij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y yec'o c'a chique ri winek aj chiri' pa tinamit Jerusalem ri niquibila' c'a: ¿La ma ya ta cami c'a achi re' ri nicanox riche (rixin) chi nicamisex? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Pero Riya' xa ma rewan ta ri'. Titzu' c'a la', Riya' nich'o chiquiwech ri winek y majun niquibij ta chare. Riq'ui juba' ri aj k'atbel tak tzij ri yec'o chkacojol xa xquetamaj yan chi can ya wi Riya' ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero ma ya ta Riya' ri Cristo, ruma xa can ketaman c'a acuchi (achique) nipe wi. Ruma tek xtoka ri kitzij Cristo, xa man c'a xtetamex ta achique lugar nbec'ulun wi pe, yecha' ri winek aj Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y ri Jesús nich'o c'a chiquiwech ri winek chiri' pa rachoch ri Dios. Y riq'ui c'a ruchuk'a' xch'o y xubij: Riyix can iwetaman wi nuwech, y chuka' iwetaman acuchi (achique) yipe wi. Pero ma nuyon ta riyin xinben chi xipe chuwech re ruwach'ulef. Ri yin takayon pe ya ri kitzij Dios, xa yac'a chi riyix ma iwetaman ta ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Riyin can wetaman wi c'a ruwech, ruma riq'ui Riya' yin petenak wi; y can ya chuka' Riya' ri yin takayon pe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y can yec'o c'a ri xcajo' chi xquichop ta el, pero majun xunim ta ri' riche (rixin) chi xquichop ta el ri Jesús, ruma ma jane napon ta ri hora riche (rixin) chi nichapatej. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Y yec'o c'a ye q'uiy chique ri winek ri xeniman riche (rixin) ri Jesús chupan ri k'ij ri'. Ri winek c'a ri' niquibij: Yare' ri Cristo, ruma majun chic ri xtipe ta ri xtibano milagros achi'el nuben re achi re', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y ri fariseos xquic'axaj c'a chi queri' ri yequibila' ri winek chrij ri Jesús. Rumari' ri achi'a' fariseos y ri principali' tak sacerdotes, xequitek c'a el ye aj ch'ame'y chuchapic. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yac'ari' tek ri Jesús xubij: Xa juba' chic c'a ri yic'oje' el iwuq'ui. C'ac'ari' xquitzolin riq'ui ri achique yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Riyix xquinicanoj c'a, y ma xquiniwil ta chic; ruma acuchi (achique) ri xquibec'oje' wi riyin, ma xquixcowin ta xquixapon chinucanoxic, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y ri achi'a' israelitas ri c'o quik'ij, niquibila' c'a chiquiwech: ¿Achique cami lugar xtibe wi re achi re'? Ruma nubij chi chiri' ma xtibekila' ta chic. ¿Nibe cami c'a pa nic'aj chic ruwach'ulef quiq'ui ri israelitas ri yec'o chiquicojol ri ma ye israelitas ta o yeberutijoj cami ri ma ye israelitas ta? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Achique c'a ntel wi chi tzij re' tek xubij: Xquinicanoj y ma xquiniwil ta, y ri acuchi (achique) xquibec'oje' wi riyin, ma xquixcowin ta xquixapon riyix? yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chupan c'a ri nimalaj k'ij y ruq'uisbel riche (rixin) ri jun semana nimak'ij ri', ri Jesús xpa'e' anej y riq'ui c'a ruchuk'a' xubij: Wi c'o c'a jun ri can nichaki'j ruchi', tipe c'a wuq'ui riyin, y tuc'uya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri can xtipe c'a wuq'ui riyin riche (rixin) chi yirunimaj, can xtalex c'a ri ya' riche (rixin) c'aslen pa ránima, y can achi'el c'a ri nuben ri raken ya', can queri' xtuben pa ruc'aslen. Queri' nubij chupan ri ruch'abel ri Dios ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri ya' c'a ri xunataj ri Jesús, ya c'a ri nich'o chrij ri Lok'olaj Espíritu; ruma can yac'ari' ri xtiquic'ul ri winek ri yeniman riche (rixin) ri Jesús. Y ri k'ij c'a ri' c'a ma jane tika ta pe ri Lok'olaj Espíritu, ruma c'a ma jane tibe ri Jesús chila' chicaj riche (rixin) chi nuc'ul chic jun bey ri ruk'ij ruc'ojlen. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y yec'o c'a chique ri winek, tek xquic'axaj ka ri ch'abel ri xerubij ri Jesús, xquibij c'a: Kas kitzij wi chi ya profeta la' ri nik'alajsan ri ruch'abel ri Dios; achi'el ri bitajnek ca, ri can c'o chi nipe na. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y yec'o nic'aj ri niquibij: Re Jesús re' yare' ri Cristo. Pero yec'o chic c'a nic'aj ri niquibij: ¿La xa ta pa Galilea c'a nipe wi ri Cristo? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ruma ri ruch'abel ri Dios ri tz'ibatal ca nubij chi ri Cristo jun chique ri ye riy rumam ri rey David. Y ri chiri' pa Belén ri tinamit ri xalex wi ri David, chiri' c'o chi nipe wi ri Cristo, yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Can ma junan ta c'a ri niquich'ob chrij ri Cristo; ruma xa jun wi nubij la jun y jun wi chic nubij la jun. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y yec'o c'a nic'aj chic chique ri winek, can xcajo' c'a chi xquichop ta el ri Jesús, pero xa can majun ri xchapo ta el. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yac'a tek xetzolin pe ri ye aj ch'ame'y quiq'ui ri principali' tak sacerdotes y quiq'ui ri achi'a' fariseos ri ye takayon el quiche (quixin), xc'utux c'a chique: ¿Achique ruma tek ma xichop ta pe ri Jesús? xe'uche'ex. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pero ri ye aj ch'ame'y ri' xquibij: Riyoj man c'a xkachop ta pe, ruma ri ch'abel ri yerubij Riya' majun chic c'a achi biyon ta. Can sibilaj jabel, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Yac'ari' tek ri achi'a' fariseos xquibij c'a chique ri ye aj ch'ame'y: ¿Riyix chuka' xixk'olotej pe pa ruk'a'? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿La c'o ta cami jun chique ri aj k'atbel tak tzij o c'o ta cami jun chique ri fariseos ri ye nimayon riche (rixin) ri nubij Riya'? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ye ri winek ri ma quetaman ta ri ley ri ruya'on ca ri Moisés, xa yeri' ri yeniman riche (rixin) ri Jesús. Y xa xtika ta c'a ri ruc'ayewal pa quiwi' riye', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero ri achi fariseo ri Nicodemo rubi', ri chak'a' xapon riq'ui ri Jesús, xubij c'a chique ri ye rachibil: ");
INSERT INTO cakWNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿La utz ta cami chuwech ri kaley chi nibix chi jun achi c'o rumac, tek xa ma etaman ta, ni ma ac'axan ta chuka' chare wi kas kitzij chi c'o mac rubanon o xa ma jun? ");
INSERT INTO cakWNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y riye' xquibij c'a chare ri Nicodemo: ¿Achique ruma nabij queri'? Riyit ni ma yit ta aj Galilea. Tanic'oj na pe' jabel rupan ri ruch'abel ri Dios y tatz'eta' ri tz'ibatal ca chiri'. Can nik'alajin wi c'a chi ri pa Galilea ma xtel ta c'a pe jun profeta ri nik'alajsan ri ruch'abel ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Y yac'ari' tek ri achi'a' ri quimolon qui', xquitaluj el qui' y xebe chcachoch. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ri Jesús xbe c'a pa ruwi' ri juyu' ri Olivos rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y nimak'a' yan, Riya' xapon chic c'a ri pa rachoch ri Dios. Y ri winek xe'apon c'a riq'ui. Y tz'uyul tek nubij ri ruch'abel ri Dios chique ri winek ri quimolon apo qui' chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yac'ari' tek ri achi'a' fariseos y ri aj tz'iba' xe'apon c'a riq'ui ri Jesús; quic'uan apo jun ixok ri nimacun riq'ui jun achi ri xbe'ilitej pe. Xbequipaba' chuwech ri Jesús, chiri' pa quinic'ajal. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ri fariseos y ri aj tz'iba' ri' xquibij c'a chare ri Jesús: Tijonel, re jun ixok re kapaban chawech, nimacun riq'ui jun achi ri xilitej pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Chupan ri ley ri ruya'on ca ri Moisés, nubij chi ri yebano quere', quecamisex chi abej. ¿Achique c'a nabij riyit? ¿Utz o ma utz ta nikacamisaj chi abej re jun ixok re'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri achi'a' ri' queri' xquibij chare riche (rixin) chi niquitojtobej ri Jesús; riche (rixin) chi queri' yecowin yetzujun (yesujun) chrij. Pero ri Jesús xa xluque' ka, y c'o c'a xerutz'ibaj ka pan ulef riq'ui ri ruwi' ruk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y ruma c'a chi ri achi'a' ri' can sibilaj c'a niquic'utuj apo chare ri Jesús, wi nicamisex o ma nicamisex ta ri ixok ri', Riya' xtz'uye' anej choj y xubij: Achique chiwe riyix ri majun rumac, yari' ri tichapo c'a ruc'akic chi abej re ixok re', xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y ri Jesús xluque' chic c'a ka jun bey y xuchop chic c'a tz'ibanic riq'ui ri ruwi' ruk'a', ri chiri' pan ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tek ri ye tzujunel (sujunel) chrij ri ixok xquic'axaj c'a ri xubij ri Jesús, ri cánima xubij chique chi riye' chuka' ye aj maqui'; y chi jojun xe'el c'a el chiri'. Xenabeyej el ri rijita'k, y c'ac'ari' xebe ri c'a ye ac'ala' na. Xa can xu (xe wi) chic c'a ri ixok ri xbequipaba' pa nic'aj ri xc'oje' ca chiri' chuwech ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y tek ri Jesús xtz'uye' chic anej choj, xutz'et c'a chi xaxu (xaxe wi) chic ri ixok ri pa'el ca chiri'. Rumari' xuc'utuj c'a chare ri ixok ri': ¿Y ri winek ri yetzujun (yesujun) chawij? ¿Majun ri xc'oje' ca riche (rixin) chi yarucamisaj? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y ri ixok ri' xubij: Ajaf, majun chic c'o ca, xcha'. Y ri Jesús xubij c'a chare: Ni xa ta riyin nbij chi yacamisex. Wacami xa catzolin, y ma camacun ta chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Tek ri Jesús xch'o chic c'a jun bey chique ri winek, xubij c'a: Yin c'a riyin ri yisakirisan quic'aslen ri winek ri yec'o chuwech re ruwach'ulef. Ri nitzekelben wuche (wixin), can xtril ri sakil riche (rixin) ri ruc'aslen wuq'ui. Y riya' man chic c'a xtibiyin ta pa k'eku'm. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Yac'ari' tek ri achi'a' fariseos ri yec'o c'a chiri', xquibij apo chare ri Jesús: Riyoj ma nikanimaj ta chi kitzij ri nabij chawij, ruma xa yit c'a riyit ri yabin ka. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ri Jesús xubij c'a chique ri achi'a' fariseos: Astape' chi xa yin c'a riyin ri yik'alajsan ka wi', can kitzij wi c'a ri nk'alajsaj ka chuwij. Ruma riyin wetaman achique lugar yin petenak wi, y can chiri' c'a chuka' xquitzolin wi. Yac'a riyix ma iwetaman ta acuchi (achique) yipe wi, ni ma iwetaman ta c'a chuka' acuchi (achique) xquibe wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Y tek riyix nibij chrij jun winek chi c'o rumac, ri' xa ina'oj riyix nicusaj. Yac'a riyin ma que ta ri' nben. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y wi riyin nk'et tzij chrij jun winek, can pa ruchojmilal c'a nben; ruma ma nuyon ta riyin, xa can wachibil c'a ri Nata' ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan ri iley, tz'ibatajnek c'a chi tek yec'o ye ca'i' winek ri junan niquibij, can kitzij wi ri niquibij. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri nbij ka chuwij riyin can kitzij wi, y ri Nata' ri yin takayon pe, chuka' Riya' can kitzij ri nubij chuwij, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri achi'a' fariseos xquibij c'a chare ri Jesús: ¿Acuchi (achique) c'a c'o wi ri Atata'? xecha' chare. Y ri Jesús xubij c'a: Riyix ma iwetaman ta ruwech ri Nata', ruma ma iwetaman ta nuwech riyin. Wi ta iwetaman nuwech riyin, can iwetaman ta chuka' ruwech ri Nata'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y ya c'a ch'abel re' ri xerubij ri Jesús chique ri winek tek ruchapon quitijoxic, tek quimolon qui' ri acuchi (achique) yeyalox wi ca ri ofrenda chiri' pa rachoch ri Dios. Y astape' xerubila' ch'abel queri' chique ri winek, can majun ri xchapo ta el ri Jesús, ruma ri hora c'a ma jane napon ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y jun bey chic, ri Jesús xubij c'a chique: Riyin can xquitzolin wi c'a, y tek riyix xquinicanoj, man c'a xquiniwil ta. Xa can chupan c'a ri imac xquixcom wi. Y ri achique lugar yibe wi riyin, riyix ma yixcowin ta yixapon, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y yac'ari' tek ri achi'a' ri c'o quik'ij chiquicojol ri israelitas, niquibila' c'a chiquiwech: ¿La xtucamisaj cami c'a ri'? Ruma nubij: Ri acuchi (achique) xquibe wi riyin, riyix ma yixcowin ta yixapon, xcha', yecha' c'a ri achi'a' ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero ri Jesús xubij c'a chique: Riyix can yix aj ruwach'ulef wi y riyin yin aj chila' chicaj. Can yix riche (rixin) wi re ruwach'ulef, yac'a riyin ma yin riche (rixin) ta re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y can rumari' xinbij c'a chiwe chi chupan ri imac yixcom wi, ruma wi xa ma yininimaj ta yin achique c'a riyin, can xquixcom na wi chupan ri imac, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yac'ari' tek ri achi'a' ri' xquibij chic c'a chare ri Jesús: ¿Yit achique c'a riyit? Y ri Jesús xubij chique: Riyin, can yac'a tek nchapon pe tzij iwuq'ui, can yac'ari' tek nbin pe chiwe yin achique riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Can c'o c'a q'uiy ri nbij chiwij riche (rixin) chi nk'et tzij pan iwi' ruma ma utz ta ri yixtajin chubanic. Pero ri yin takayon pe, can kitzij wi y ya ri wac'axan pe riq'ui Riya', yari' nbij chiwe riyix y chique quinojel ri winek ri yec'o chuwech re ruwach'ulef, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero riye' ma xk'ax ta chiquiwech ri xbix chique ruma ri Jesús, chi can chrij ri Tata'ixel nich'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xubij chic c'a: Ri k'ij c'a tek xquinijotoba' chuwech cruz riyin ri C'ajolaxel ri xinalex chicojol, c'a yac'ari' tek xtiwetamaj yin achique c'a riyin. Y xtiwetamaj chuka' chi ronojel ri nben riyin, xa ma nben ta pa nuyonil. Xa can achi'el ri rubin pe ri Nata' chuwe riyin, can queri' chuka' nbij riyin chiwe riyix. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ri Nata' ri yin takayon pe, can c'o wuq'ui. Man c'a yiruya' ta ca nuyon, ruma riyin can nben wi ri nika chuwech Riya', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y ruma c'a re tzij re xerutzijola' ri Jesús chique ri winek, ye q'uiy c'a ri xeniman riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yac'ari' tek ri Jesús xubij c'a chique ri achi'a' israelitas ri c'o quik'ij ri xeniman riche (rixin): Wi riyix can xquixc'oje' jabel chupan ri nuch'abel, can xquixoc c'a kitzij tzekelbey wuche (wixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xtiwetamaj c'a chuka' achique ri kas kitzij; y ri kas kitzij xtuben c'a chiwe chi xquixtotej chuwech ronojel. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y ri winek ri' xquibij c'a: Riyoj can yoj riy rumam ca ri Abraham, y rumari' ma xojc'oje' ta chuxe' quitzij nic'aj chic winek. ¿Achique c'a ruma tek nabij chake chi yojtotej chuwech ronojel? ");
INSERT INTO cakWNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xubij chique: Can kitzij c'a re nbij chiwe: Quinojel c'a winek ri yemacun, can nik'alajin chi ye ximil pa ruk'a' ri mac. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y jun mozo ri ximil pa samaj riq'ui jun patrón ma xtic'oje' ta ka jurayil pa rachoch ri patrón ri' ruma xa xtelesex el. Can queri' wi niban chare jun ri ma riche (rixin) ta ri Dios. Yac'a ri jun ri can ralc'ual wi ri Dios, yari' majun bey xtelesex ta el. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Rumac'ari' wi riyin ri C'ajolaxel ri yicolo iwuche (iwixin) pa ruk'a' ri mac, kas kitzij wi chi xquixtotej chuwech ronojel. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Riyin wetaman chi yix riy rumam ca ri Abraham, xa yac'a chi riyix xa nicanola' achique rubanic niben riche (rixin) chi yinicamisaj. Re' nuc'ut c'a chi riyix ma iya'on ta k'ij chare ri nuch'abel chi oconek ta ri pa tak iwánima. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ronojel c'a ri nbij riyin, can ya c'a ri Nata' ri c'utuyun pe chinuwech. Y queri' chuka' riyix. Can ya ri iwac'axan riq'ui ri oconek itata' ri yixtajin chubanic. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y riye' xquibij c'a chare ri Jesús: Ri Abraham yari' ri katata' riyoj, xecha'. Y ri Jesús xubij chique: Xa ta yix ralc'ual ri Abraham, can ta ya ri utz ri xerubanala' riya', can ta yari' ri yixtajin chubanic riyix. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero ma que ta ri' niben. Riyix xa nicanoj achique rubanic niben riche (rixin) chi yinicamisaj riyin ri ntzijoj ri kitzij chiwe ri wac'axan pe riq'ui ri Dios. Ri Abraham ma xuben ta achi'el ri niben riyix, y riyix nibij chi yix riy rumam ca riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Riyix xa ya c'a ri nuben ri jun ri oconek itata', xa yari' ri niben, xcha' ri Jesús chique. Y riye' xquibij c'a chare: Riyoj ma ca'i' oxi' ta ri katata'. Xa can xu (xe wi) c'a Jun ri Katata', y ri' ya ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yac'ari' tek ri Jesús xubij c'a chique ri winek ri': Xa ta can ya ri Dios ri Itata', can ta nik'alajin, ruma yiniwajo' ta y yinic'ul ta jabel; ruma riyin can riq'ui ri Dios yin elenak wi pe y xinoc'ulun chicojol. Y ma nuyonil ta riyin xinch'ob chi xipe chuwech re ruwach'ulef. Can ya wi ri Dios ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Achique c'a ruma tek riyix ma nik'ax ta chiwech ri nbij chiwe? Ruma ma niwajo' ta niwac'axaj ri nuch'abel. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri itata' riyix xa ya ri itzel winek y can yix riche (rixin) c'a riya'; y ya ri nika chuwech riya', yari' ri yixtajin chubanic. Ri itzel winek can pa rutiquiribel ruchapon wi pe nicamisan. Man c'a xc'oje' ta chic chupan ri kitzij, ruma xa can majun c'a ri kitzij ri c'o ta riq'ui. Xa can riche (rixin) wi chi jun aj tz'ucuy tzij. Can quitata' c'a quinojel ri ye aj tz'ucuy tak tzij. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y riyin ma yininimaj ta ruma can ya ri kitzij ri nbij chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿La c'o cami jun ri nibin pe chuwe wacami achique mac ye nubanalon? Y wi can jabel nik'alajin chi majun mac pa nuc'aslen y can ruyon kitzij ri nbij, ¿achique c'a ruma tek ma yininimaj ta? ");
INSERT INTO cakWNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ruma ri jun winek ri can riche (rixin) chic c'a ri Dios, ya ri nubij ri ruch'abel ri Dios ri nuben. Yac'a riyix ma niben ta ri nbij, ruma ma yix riche (rixin) ta ri Dios, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y ri achi'a' israelitas ri c'o quik'ij, xquibij c'a chare ri Jesús: Kitzij wi c'a ri nikabij chawij chi riyit xa yit jun winek ri yape pa Samaria y c'o itzel espíritu awuq'ui, xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero ri Jesús xubij c'a chique ri achi'a' ri': Riyin majun itzel espíritu ri c'o ta wuq'ui. Riyin ya c'a ri Nata' ri nya' ruk'ij, pero chiwech riyix xa ma que ta ri'. Rumari' tek riyix niben chuwe chi majun nuk'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Riyin ma ncanoj ta nuk'ij nuc'ojlen, yac'a ri Nata' nrajo' chi quinojel winek niquiya' ta nuk'ij nuc'ojlen. Y ya c'a chuka' Riya' ri xtik'ato tzij. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can tiwac'axaj c'a jabel re xtinbij chiwe: Achique c'a winek ri can nunimaj ri nuch'abel, man c'a xtril ta ri jun camic riche (rixin) xtibe k'ij xtibe sek, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y ri achi'a' israelitas ri c'o quik'ij xquibij c'a chare ri Jesús: Wacami ketaman chic chi can c'o itzel espíritu awuq'ui; ruma nabij chi achique ri yeniman ri ach'abel, man c'a xquecom ta riche (rixin) xtibe k'ij xtibe sek, yacha'. Tatz'eta' c'a ri katata' Abraham y ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, xa xecom. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿La más ta c'a c'o ak'ij riyit que chuwech ri katata' Abraham? Riya' xa xcom, y queri' chuka' ri profetas ri xek'alajsan ri ruch'abel ri Dios ojer ca, xecom. ¿Achique ta c'a abanic nabij riyit? ");
INSERT INTO cakWNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y ri Jesús xubij: Wi xa ta nuyon c'a riyin nya' nuk'ij nuc'ojlen, xa majun c'a nic'atzin wi. Pero ri nuk'ij nuc'ojlen riyin, ya c'a ri Nata' niya'o. Ri Nata' yac'ari' ri nibij i-Dios chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y astape' riyix queri' nibij chare, pero ma iwetaman ta ruwech. Yac'a riyin can wetaman wi ruwech. Y xa yinoc c'a jun aj tz'ucuy tzij achi'el riyix, wi ta nbij chi ma wetaman ta ruwech. Pero riyin can wetaman wi ruwech y can nben wi c'a ri nubij ri ruch'abel Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham ri tata'aj iwuche (iwixin) riyix sibilaj c'a xquicot ránima ri ojer ca, tek xk'ax chuwech chi c'o chi nutz'et na ri nuk'ij. Y riya' can xutz'et na wi, y rumari' sibilaj c'a xquicot ránima, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yac'ari' tek ri achi'a' israelitas ri c'o quik'ij xquibij chare ri Jesús: Riyit nabij chi xatz'et ri katata' Abraham, pero riyit xa c'a yit ac'al na. Xa c'a ma jane c'o ta nic'aj ciento ajuna'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero ri Jesús xubij chique ri achi'a' ri': Can kitzij wi nbij chiwe chi riyin can yinc'o wi pe, tek c'a ma jane c'o ta rutzijol chi nalex ri Abraham, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y ri achi'a' ri' can yac'ari' tek xbequisiq'uila' pe abej riche (rixin) chi yequiq'uek chrij. Pero ri Jesús xrewala' pe ri' chiquicojol ri winek, xel pe chiri' pa rachoch ri Dios y xbe. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús ruchapon bey nik'ax c'a el queri'. Yac'ari' tek xutz'et c'a jun achi ri can moy pe tek xalex. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri discípulos xquic'utuj c'a chare ri Jesús: Tijonel, ¿achique c'a ri xmacun riche (rixin) chi quere' xalex re jun achi re'? ¿Ye ri rute' rutata' o ya riya'? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero ri Jesús xubij: Majun c'a chique ta riye' ri xmacun, riche (rixin) chi quere' xuc'ulwachij re jun achi re'. Ni riya', ni ri rute' rutata'. Riya' can quec'are' rubanon pe pa ralaxic, riche (rixin) chi xtik'alajin ri samaj ri xtuben ri Dios riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Riyin nic'atzin chi nben ri rusamaj ri yin takayon pe, ruloman chi c'a ma jane ntoc ta pe ri ak'a', ruma tek ntoc pe ri ak'a', majun chic nicowin nisamej. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ruloman chi c'a yinc'o na chuwech re ruwach'ulef, yin c'a riyin ri Sakil riche (rixin) ri quic'aslen quinojel ri winek, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Tek ri Jesús ye rubin chic c'a ka ri ch'abel ri', xchuban c'a ri pan ulef. Y riq'ui ri ruchub (ruc'axej) ri xka pan ulef, xuben juba' ti ch'abek. C'ac'ari' ri ch'abek ri' xuquil el chrij runak' ruwech ri moy. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xubij chare: Wacami cabiyin c'a, y jach'aja' ri runak' awech chupan ri atinibel ri Siloé rubi'. Ri Siloé c'a ri' ntel chi tzij Tako'n. Ri achi ri' can xbe c'a chuch'ajic ri runak' ruwech, y tek xtzolin pe, nitzu'un chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yac'ari' tek ri winek ri ye ruvecino ri achi ri' y ri nic'aj chic winek ri ye tz'eteyon riche (rixin) chi can moy wi, niquibila' c'a: ¿La ma ya ta cami achi re' ri katz'eton chi nitz'uytaj y nuc'utula' limosna? yecha' c'a. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Y yec'o c'a winek ri yebin: Xa can ya achi la'. Nic'aj chic niquibij: Ma ya ta la', xa junan yetzu'un riq'ui ri achi ri', yecha'. Pero riya' can nubij c'a: Yin c'a riyin ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y ri winek niquic'utuj c'a chare ri achi ri': ¿Achique c'a rubanic xban chawe, rumari' tek yatzu'un chic re wacami? xecha' c'a chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achi xubij chique: Ri jun achi ri Jesús rubi' xuben juba' ti ch'abek y yari' ri xuquil chrij ri runak' nuwech, y c'ac'ari' xubij chuwe: Cabiyin y jach'aja' ri runak' awech chupan ri atinibel ri Siloé rubi'. Y riyin can xibe wi y xinch'ej ri runak' nuwech y yac'ari' tek xitzu'un. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero ri winek xquic'utuj chare: ¿Acuchi (achique) c'a c'o wi ri Jesús wacami? xecha' chare. Y riya' xubij: Ma wetaman ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y ri winek xquic'uaj c'a el ri achi ri moy tek rubanon ca, c'a chiquiwech ri achi'a' fariseos. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri k'ij c'a tek ri Jesús xuben ri juba' ti ch'abek y xuben chare ri achi moy chi xtzu'un, can jun uxlanibel k'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ri achi ri moy tek rubanon ca, tek c'o chic c'a apo chiquiwech ri achi'a' fariseos, xquic'utuj c'a chare chi achique rubanic xban chare riche (rixin) chi wacami nitzu'un chic. Y riya' xubij: Ri xbano c'a chuwe chi yitzu'un chic, xuya' juba' ti ch'abek chrij runak' nuwech, xinch'ej, y yare' yitzu'un chic, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y yec'o c'a achi'a' fariseos ri xquibij: Ri achi ri', ri Jesús rubi', ma riq'ui ta ri Dios petenak wi; ruma ma nuchajij ta ri uxlanibel k'ij, yecha'. Pero yec'o c'a nic'aj chic fariseos ri xquibij: ¿Can nicowin ta cami yeruben milagros jun achi aj mac, achi'el xuben riq'ui ri achi moy? yecha'. Ri achi'a' fariseos ri' ma junan ta c'a ri niquich'ob chrij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Yac'ari' tek ri achi'a' fariseos xquic'utuj c'a chare ri achi ri moy tek rubanon ca: ¿Achique cami chi achi ri xbano chawe chi yatzu'un chic, nach'ob riyit? Y ri achi ri' xubij: Riyin nch'ob chi Riya' jun profeta ri nik'alajsan ri ruch'abel ri Dios, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yac'a ri achi'a' israelitas ri c'o quik'ij, ma niquinimaj ta c'a chi ri achi ri' can moy wi tek xalex y wacami xa nitzu'un chic. Rumari' can xequisiq'uij (xecoyoj) na c'a ri rute' rutata' ri achi ri ya nitzu'un chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y ri achi'a' ri' xquic'utuj c'a chique ri rute' rutata' ri achi: ¿La ya iwalc'ual re', ri nibij chi can moy tek xalex? Wi moy c'a tek xalex, ¿achique c'a ruma tek nitzu'un chic wacami? xecha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y ri rute' rutata' ri achi xquibij c'a chique ri achi'a' ri': Ketaman chi ya kalc'ual re' y moy tek xalex. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Yac'a ri ma ketaman ta riyoj, ya ri achique rubanic xuben riche (rixin) chi nitzu'un chic wacami. Y wi c'o jun ri xbano chare riche (rixin) chi nitzu'un chic, chuka' ma ketaman ta riyoj. Tic'utuj chare riya'; ruma xa can c'o chic rujuna', y riya' nicowin nubij chiwe ri achique xbanatej riq'ui, xecha' riye'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quec'ari' xquibij ri rute' rutata' ri achi chique ri achi'a' israelitas ri c'o quik'ij, ruma quixibin qui' chiquiwech. Ruma ri achi'a' ri' quiya'on chic rubixic chiquiwech chi xabachique jun winek ri xtibin chi ri Jesús yari' ri Cristo, ri winek ri' can nokotex c'a pe chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Xa rumari' tek ri rute' rutata' ri achi ri nitzu'un chic, xaxu (xaxe) xquibij chi tiquic'utuj chare riya', ruma riya' c'o chic rujuna'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y ri achi'a' ri' xquisiq'uij (xcoyoj) chic c'a jun bey ri achi ri nitzu'un chic, y xquibij chare: Ya ri Dios taya' ruk'ij ruc'ojlen. Riyoj ketaman chi ri achi Jesús xa jun aj mac, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ri achi xubij c'a chique ri achi'a' ri': Riyin ma wetaman ta wi ri achi ri' jun aj mac o ma aj mac ta. Ri wetaman riyin chrij Riya', yac'a chi xic'achoj ruma; ruma tek rubanon ca ma yitzu'un ta, y wacami yitzu'un chic, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y ri achi'a' ri' xquic'utuj chic c'a chare ri achi: ¿Achique ri xeruben chawe riche (rixin) chi queri' xacowin xatzu'un? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Riya' xubij c'a chique ri achi'a' ri': Pero ri' xinbij yan chiwe y xa ma xiwajo' ta xiniwac'axaj. ¿Achique c'a ruma tek wacami riyix niwajo' chi riyin ncamuluj chic rubixic chiwe? ¿La niwajo' c'a chi yixoc rudiscípulos Riya'? xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero ri achi'a' ri' xa xquichop yeyok'on pe chare y xquibij: Riyit xa yit jun rudiscípulo Riya', yac'a riyoj can yoj rudiscípulos ri Moisés. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Riyoj ketaman wi c'a chi ri Moisés can xch'o wi ri Dios riq'ui, yac'a ri achi ri' xa ma ketaman ta acuchi (achique) tipe wi, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y ri achi xch'o apo chique y xubij c'a: Re' sibilaj nmey riyin, ruma riyix ma iwetaman ta acuchi (achique) nipe wi, pero riyin xujek ri runak' nuwech, rumari' wacami yitzu'un chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ruma ketaman chi ri Dios ma nrac'axaj ta ri niquic'utuj ri aj maqui' chare. Pero jun winek ri can nuxibij ri' chi nimacun chuwech ri Dios y can nuben chuka' ri nrajo' ri Dios, can nac'axex wi ruma ri Dios, y nibanatej ri nuc'utuj. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Can majun bey c'a tz'eton ta o ac'axan ta chi c'o ta jun ri nibano chare jun moy chi nitzu'un ri can moy pe tek xalex. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y wi ta ri achi ri' man ta riq'ui ri Dios petenak wi, man ta xcowin xuben ri milagro wuq'ui riyin, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero ri achi'a' ri' xquibij chare ri achi ri nitzu'un chic: Riyit can yit aj mac pe tek xatalex, ¿y nawajo' yojatijoj riyoj? xecha' chare. Y xquelesaj c'a pe ri achi ri', ri chiri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xrac'axaj c'a chi ri achi ri' xelesex pe. Rumari', tek xquil qui' riq'ui ri achi ri', xubij c'a chare: ¿La nanimaj cami riyit ri Ruc'ajol ri Dios? xcha' ri Jesús chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y ri achi ri nitzu'un chic xubij c'a chare ri Jesús: Táta, ¿achique c'a ri' ri Ruc'ajol ri Dios riche (rixin) chi riyin nnimaj? Ma wetaman ta achique chi achi ri'. Tabij c'a chuwe, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y ri Jesús xubij c'a chare: Riyit atz'eton chic c'a ri Ruc'ajol ri Dios. Y ri' can ya c'a ri ntajin nich'ob awuq'ui, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri achi can yac'ari' tek xubij: Ajaf, riyin yatinnimaj, xcha'. Y ri achi ri' can xuya' c'a ruk'ij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xubij: Riyin xipe c'a chuwech re ruwach'ulef riche (rixin) chi xtik'alajin achique quibanon ri winek. Riche (rixin) chi queri' ri winek ri xa ye achi'el moyi' quibanon, can xquetzu'un, y ri winek ri niquibij chi can yetzu'un, xa xque'oc achi'el moyi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Y yec'o c'a achi'a' fariseos ri yec'o apo chiri' riq'ui ri Jesús, y tek xquic'axaj ri xubij ri Jesús, xquibij: ¿La yoj moy ta c'a chuka' riyoj, rumari' tek queri' nabij? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y ri Jesús xubij chique: Xa ta yix moyi', jabel ta, ruma man ta jun imac. Pero ruma chi riyix nibij chi can yixtzu'un, rumari' tek ri imac can c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Y can kitzij c'a re xtinbij chiwe: Ya c'a ri ma pa ruchi' ta ri quicoral ri carne'l ntoc wi, y xa pa juc'an chic ri ntoc wi, ya c'a ri' xa alek'om, y xa achi'el jun ri nalek' ca pa tak bey. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yac'a ri ntoc pa ruchi' ri coral, can ya wi ri' ri aj yuk' quiche (quixin) ri carne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y ri nichajin quiche (quixin) ri carne'l nujek c'a pe ri ruchi' ri coral chuwech ri aj yuk', y ri carne'l can quetaman chic ri ruch'abel ri cajyuk'. Riya' yerusiq'uij (yeroyoj) chiquijujunal riq'ui ri quibi' y yerelesaj c'a el. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Tek ri aj yuk' ye relesan chic c'a el quinojel ri rucarne'l, ninabeyej c'a el chiquiwech y ri carne'l yetzeke' el chrij. Ri carne'l can queri' wi niquiben, ruma quetaman c'a ruch'abel ri cajyuk'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yac'a ri ma quetaman ta ruwech, ma xtiquitzekelbej ta el. Xa ye'anmej chuwech, ruma ri carne'l ri' ma quetaman ta achique rubanic yech'o ri nic'aj chic ri xa ma ye cajyuk' ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xubij c'a re jun c'ambel tzij re' chique ri achi'a' fariseos, yac'a riye' ma xk'ax ta chiquiwech achique ntel wi chi tzij ri xubij chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","C'ac'ari' ri Jesús xch'o chic jun bey chique ri achi'a' fariseos ri', y xubij: Can kitzij c'a nbij chiwe: Yin c'a riyin ri Ruchi' ri coral ri acuchi (achique) ye'oc wi apo ri tak carne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Y ye q'uiy c'a ri xec'oje' yan nabey que chinuwech riyin, ri xa ye junan quiq'ui ri alek'oma' y xa ye achi'el ri ye'elek' ca pa tak bey. Pero ma xetzekelbex ta cuma ri tak nucarne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yin c'a riyin ri Ruchi' ri coral. Ri xtoc c'a wuq'ui riyin, can xticolotej y nril ri nic'atzin chare. Achi'el nuben ri carne'l ntel ntoc chupan ri coral, y nril k'ayis riche (rixin) chi nutij. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ri alek'om nipe riche (rixin) chi nalek' y nicamisan ca y nuyoj ronojel. Yac'a riyin, xipe riche (rixin) chi nya' ri c'aslen; jun c'aslen ri ma juba' ta oc. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Y yin c'a riyin ri utzilaj Aj Yuk'. Ri utzilaj Aj Yuk', can nuya' wi ri ruc'aslen cuma ri rucarne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma que ta ri' nuben ri xa ma kitzij ta chi aj yuk', ri niyuk'un xa ruma chi tojon. Riya' xa ma cajaf ta ri carne'l y tek nutz'et c'a chi petenak ri utif (coyote), xa ya riya' ri nucol el ri' nabey y yerumalij ca ri carne'l. Y ri utif (coyote) c'o carne'l yeruc'uaj el y ri nic'aj chic yerutaluj ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ri oconek aj yuk', xa ruma chi tojon, xa nanmej el. Queri' nuben ruma majun c'a pena chare wi c'o niquic'ulwachij ca ri carne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Yin c'a riyin ri utzilaj Aj Yuk', y wetaman quiwech ri ye nucarne'l, y riye' quetaman c'a chuka' nuwech riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Can queri' chuka' nbanon riyin riq'ui ri Nata'. Riya' retaman nuwech riyin, y riyin wetaman ruwech Riya'. Y riyin nya' c'a nuc'aslen cuma ri nucarne'l. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y ma xu (xe) ta c'a nucarne'l re' ri yec'o, xa can yec'o c'a chuka' nic'aj chic nucarne'l ri ma jane yec'o ta wawe' chupan re jun coral re'. Rajawaxic chi yenc'om pe, y xtiquic'axaj chuka' ri nuch'abel. Y xa jumoc carne'l xtiquiben, y xa jun Aj Yuk' xtiyuk'un quiche (quixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nata' Dios can yirajo' wi ruma chi riyin nya' wi' chi yicamisex pa quiq'uexel ri nucarne'l, riche (rixin) chi nic'oje' chic el jun bey ri nuc'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri nuc'aslen riyin, majun c'a xtelesan ta, can yin c'a riyin ri yiya'o. Can pa nuk'a' c'a riyin c'o wi riche (rixin) chi nya' y pa nuk'a' chuka' riyin c'o wi riche (rixin) chi nic'oje' chic el jun bey ri nuc'aslen. Quec'ari' ri rubin pe ri Nata' chuwe, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y yac'ari' tek ri achi'a' israelitas ri c'o quik'ij, ma junan ta quiwech xquiben chic jun bey, ruma ma junan ta xquich'ob chrij ri ch'abel ri xerubij ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ye q'uiy chique riye' ri xquibij chrij ri Jesús: Xa ch'ujernek la'. Xa itzel espíritu ri c'o riq'ui, y riyix, ¿achique ruma ninimaj ka ri nubij? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Yac'a ri nic'aj chic xquibij: Jun ri c'o itzel espíritu riq'ui, ma nicowin ta nubij utzilaj tak ch'abel achi'el ri xerubij ka ri Jesús. ¿La nicowin cami chuka' jun ri c'o itzel espíritu riq'ui chi nuben chare jun moy chi nitzu'un? yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Y pa ruk'ijul c'a ri job, yac'ari' tek ntajin ri nimak'ij ri Dedicación rubi'; nimak'ij riche (rixin) chi niquinatabej ri k'ij tek xchojmirisex chic ri rachoch ri Dios ri c'o chiri' pa tinamit Jerusalem. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y ri Jesús nibiyaj chupan ri rachoch ri Dios. Y pa jun ruchi' raken jay Riche (Rixin) ri Salomón rubi', chiri' c'a c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xe'apon riq'ui ri Jesús, xquisutij qui' chrij, y c'ac'ari' xquibij c'a chare: ¿Achique c'a ruma tek nasech kac'u'x, ruma majun bey nawajo' nak'alajsaj awi' chkawech? Wi can yit c'a riyit ri Cristo, tabij c'a chake. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y ri Jesús xubij c'a chique ri achi'a' ri': Nbin chic c'a chiwe y ma iniman ta. Y ronojel ri samaj ri yenben, can pa rubi' c'a ri Nata' Dios yenben wi. Y ri samaj ri' can nuk'alajsaj wi c'a yin achique riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Xa yac'a riyix ma yininimaj ta, ruma riyix xa ma yix nucarne'l ta; can achi'el wi c'a ri xinbij yan chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri ye nucarne'l can quetaman ri nuch'abel, y can yinquitzekelbej y riyin can wetaman chuka' quiwech riye'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Riyin xa can xtinya' quic'aslen riche (rixin) xtibe k'ij xtibe sek. Y majun bey xquesach ta ca. Ni majun achique ta ri xticowin xque'elesan ta el pa nuk'a'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri Nata' Dios ri xeya'o pa nuk'a' riyin, yari' ri más nim ruchuk'a' que chuwech xabachique y majun c'a nicowin ye'elesan ta el pa ruk'a' Riya'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Riyin y ri Nata', xa yoj jun, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y yac'ari' tek ri achi'a' israelitas ri c'o quik'ij, xebequisiq'uila' chic c'a pe abej chrij ri Jesús, riche (rixin) chi niquicamisaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ri Jesús xubij c'a chique ri achi'a' ri': Can q'uiy c'a utzilaj tak samaj ri ye nubanalon chiwech ruma ri uchuk'a' ri ruya'on pe ri Nata' chuwe. ¿Achique c'a jun chique ri utzilaj tak samaj ri nbanon ri ma nika ta chiwech, y rumari' niwajo' yinicamisaj chi abej? xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Y ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xquibij chare ri Jesús: Riyoj ma yatkaq'uek ta chi abej ruma jun utzilaj samaj. Riyoj yatkaq'uek chi abej ruma nabij chi yit junan riq'ui ri Dios. Ruma jun achi ri nibin queri', xa nuyok' rubi' ri Dios, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xubij c'a chique: Chupan ri iley ri tz'ibatajnek ca, ri Dios nubij: Chi'iwonojel riyix can yix dios chuka'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Riya' can xubij dios chique ri achoj chique xuya' wi ri ruch'abel, y majun modo nibix chi ma kitzij ta nubij ri ruch'abel ri Dios ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Rumari' wi queri' xubij ri Dios, ¿achique c'a ruma tek riyix nibij chi riyin xinyok' rubi' ri Dios ruma xinbij chi yin c'a riyin ri Ruc'ajol? Riya' can xirucha' pe riche (rixin) chi xirutek pe chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y wi xa ma nben ta c'a ri ruchilaben pe ri Nata' Dios chuwe ri c'o chi nben, man c'a quininimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero wi ya ri samaj ri ruchilaben pe ri Dios chuwe ri nben; astape' ma yininimaj ta riyin, pero tinimaj c'a chi ri samaj ri nben riyin can ya wi ri ruchilaben pe ri Dios chuwe. Tinimaj c'a riche (rixin) chi tiwetamaj chi ri Nata' Dios can c'o wi wuq'ui riyin y riyin chuka' can yinc'o wi riq'ui ri Nata' y xa yoj jun, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Can sibilaj xcajo' ri achi'a' ri' chi xquichop ta el ri Jesús, pero xa ma xecowin ta chic jun bey; ruma xa xbe el chiquiwech. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y ri Jesús xk'ax chic apo juc'an ruchi' raken ya' Jordán y xc'oje' c'a ka q'uiy k'ij ri chiri'; ri acuchi (achique) xeruben wi bautizar winek ri Juan ri Bautista, pa nabey mul. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y ye q'uiy c'a winek ri xe'apon riq'ui ri Jesús, ri chiri'. Y ri winek ri' niquibila' c'a: Ri Juan ri Bautista can kitzij wi chi majun milagro ri xuben ta, pero ronojel c'a ri tzij ri xerubij ca chrij re achi re', can kitzij wi, yecha' c'a ri winek ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y ye q'uiy c'a winek ri xeniman riche (rixin) ri Jesús chiri' chuchi' ri raken ya' Jordán. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupan c'a ri aldea ri Betania rubi' ri quitinamit ri María y ri Marta ri cach'alal qui', c'o c'a jun yawa'. Ri yawa' ri' Lázaro rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ri María ri', yac'ari' ri xya'o ak'om ri jubul ruxla' chrij ri raken ri Ajaf Jesús y xerusu' riq'ui ri rusmal tak ruwi'. Xa ruxibal c'a riya' ri' ri Lázaro, ri yawa'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Y ri María y ri Marta ri ye rana' ri Lázaro, xquitek c'a rubixic chare ri Jesús: Ajaf, wacami c'a nikaya' rutzijol chawe chi ri kaxibal Lázaro, ri sibilaj nawajo' riyit, yawa'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y tek ri Jesús xrac'axaj c'a ri takon el rubixic chare, Riya' xubij: Ri Lázaro yawa', pero ma riche (rixin) ta camic. Xa riche (rixin) chi xtik'alajin na c'a ri ruchuk'a' ri Dios, riche (rixin) chi queri' riyin ri Ruc'ajol ri Dios xtiya'ox (xtya') ta c'a nuk'ij nuc'ojlen, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús can sibilaj wi c'a yerajo' ri Lázaro, ri Marta y ri María. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y tek Riya' xrac'axaj chi ri Lázaro yawa', ma can ta xbe chanin chutz'etic, xa xc'oje' na chic ca'i' k'ij chiri' ri acuchi (achique) c'o wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Y yac'a tek k'axnek chic ri ca'i' k'ij, ri Jesús xubij chique ri discípulos: Wacami kojtzolin c'a pa Judea. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y ri rudiscípulos xquibij c'a chare: Tijonel, xa c'are' ca tek ri achi'a' israelitas ri c'o quik'ij quic'ualon chic abej chawij riche (rixin) chi yatquicamisaj. ¿Can nawajo' c'a chi yatzolin chic chila'? xecha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero ri Jesús xubij chique: Ri jun k'ij ruc'uan c'a cablajuj horas. Ri nibiyaj pak'ij, man c'a xtuchak'ila' (xtutoch') ta raken, ruma can c'o ri sakirisayon riche (rixin) re ruwach'ulef. Can ronojel wi c'a nutz'et ruma ri sakil ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yac'a ri nibiyaj chak'a', can nuchak'ila' (nutoch') wi ri raken; ruma xa majun ri sakil riq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y tek ri Jesús rubin chic ka ronojel re', xch'o chic jun bey chique ri rudiscípulos y xubij: Ri Lázaro ri ketaman ruwech, xa warnek. Rumac'ari' wacami yac'are' yibe chuc'asoxic. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y yac'ari' tek ri rudiscípulos xquibij chare: Ajaf, wi ri Lázaro xa warnek, xa can xtic'achoj wi c'a ri', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Y ri Jesús xa chrij c'a ri rucamic ri Lázaro xch'o wi tek xubij chi xa warnek, pero ri rudiscípulos xk'ax chiquiwech chi can waran wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yac'ari' tek ri Jesús can jabel c'a k'alaj rubixic ri xubij chique tek xubij: Ri Lázaro, xa caminek chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y can sibilaj c'a yiquicot ruma ma pa Betania ta yinc'o wi tek xcom ri Lázaro, riche (rixin) chi queri' riyix yininimaj. Wacami, jo' c'a pa Betania, ri acuchi (achique) c'o wi ri Lázaro, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Yac'a ri discípulo ri Tomás rubi', y nibix chuka' Dídimo chare; riya' xubij c'a chique ri rech discípulos: Jo' c'a, tikatzekelbej ri Jesús, riche (rixin) chi wi Riya' xticamisex, can kojcamisex chuka' riyoj junan riq'ui Riya', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Y ri Jesús y ri rudiscípulos xe'apon c'a pa Betania. Ri k'ij c'a tek xe'apon riye', c'o chic caji' k'ij timuk wi ri Lázaro. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri tinamit Betania ma nej ta c'o wi chare ri tinamit Jerusalem. Ri quicojol xa juba' ruwi' nic'aj legua. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y ye q'uiy c'a chique ri israelitas ri xepe chiri' y xe'apon riche (rixin) chi noquibochi'ij ránima ri Marta y ri María, ruma xcom ri quixibal. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Tek xapon c'a rutzijol riq'ui ri Marta chi petenak ri Jesús, junanin (anibel) xel el riche (rixin) chi xbe chuc'ulic. Y ri María man c'a xunabej ta, xa xc'oje' ca ri chiri' pa jay. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y ri Marta tek xapon c'a riq'ui ri Jesús, riya' xubij chare: Ajaf, ri nuxibal xcom. Xa ta wawe' yitc'o wi, c'a q'ues ta na ri nuxibal. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero riyin wetaman chi ri xtac'utuj chare ri Dios wacami, ri Dios can xtuya' wi chawe, xcha' ri Marta chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yac'ari' tek ri Jesús xubij chare ri Marta: Ri axibal Lázaro xtic'astej, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y ri Marta xubij chare ri Jesús: Ja' (je), riyin can wetaman chi xtic'astej; tek xtapon ri ruq'uisbel k'ij, tek quinojel c'a ri caminaki' xquec'astej, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xubij c'a chare ri Marta: Riyin can yicowin wi yenc'asoj ri ye caminek chic el, y can yicowin wi nya' c'aslen. Rumari' ri niniman wuche (wixin), astape' nicom el, xtic'astej chic pe jun bey. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xabachique c'a winek ri c'a c'o na ruc'aslen chuwech re ruwach'ulef y yirunimaj riyin, man c'a xticom ta riche (rixin) xtibe k'ij xtibe sek. ¿La nanimaj c'a riyit re'? xcha' ri Jesús chare ri Marta. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y ri Marta xubij chare ri Jesús: Ja' (je), Ajaf. Riyin can nnimaj c'a achi'el ri xabij; ruma can nuniman wi chi yit c'a riyit ri Cristo ri Ruc'ajol ri Dios, ri xape wawe' chuwech re ruwach'ulef, xcha' ri Marta. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Tek ri Marta rubin chic c'a ca re ch'abel re' chare ri Jesús, xbe chusiq'uixic (chroyoxic) ri María ri rach'alal. Y tek xapon c'a, ri Marta xubij pan ekal chare ri María: Ri Ajaf xoka y wacami yarusiq'uij (yaroyoj), xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María, can xu (xe) wi c'a xrac'axaj el queri', can yari' xyacatej el ri acuchi (achique) tz'uyul wi y chanin xbe. Riya' xbe c'a acuchi (achique) c'o wi ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús can c'a ma jane c'a ntoc ta apo chupan ri aldea ri Betania rubi', xa can c'a c'o na ca chiri' ri acuchi (achique) xbe'ilitej wi ca ruma ri Marta. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y ri winek ri ye israelitas ri yec'o chiri' pa jay, ri yebochi'in ránima ri María, tek xquitz'et chi chanin xyacatej, xel el y xbe; ri winek ri' can xquitzekelbej c'a el, ruma riye' xquich'ob chi ri María nibe chuchi' ri jul riche (rixin) chi nrok'ej ri ruxibal. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Yac'a tek ri María xapon acuchi (achique) c'o wi ri Jesús y xutz'et, xxuque' xmaje' ka chuwech y xubij chare: Ajaf, xa ta wawe' yitc'o wi, man ta xcom ri nuxibal, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yac'a tek ri Jesús xutz'et chi ri María ntok' y que chuka' ri' ye'ok' quinojel ri israelitas ri ye tzeketel el chrij ri María, ri ránima ri Jesús jun wi xuben xuna' Riya' y xpe c'a bis chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y c'ac'ari' xuc'utuj chique: ¿Acuchi (achique) ximuk wi ri Lázaro? xcha'. Y riye' xquibij: Ajaf, jo' y nbekac'utu' chawech, xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y ri Jesús xok'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yac'ari' tek ri israelitas xquibila' c'a: Titzu' la Jesús, nrok'ej ri Lázaro. Nik'alajin chi can sibilaj xrajo', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Yac'ari' tek yec'o c'a chique ri winek ri' xquibila' c'a chrij ri Jesús: Riya' can xcowin c'a xuben chare ri moy riche (rixin) chi xtzu'un. ¿La man ta cami xcowin xuben ta chare ri Lázaro chi man ta xcom? xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Tek ri Jesús xapon c'a chuchi' ri jul, xpe chic c'a jun bey ri bis chare. Ri jul ri mukul wi ca ri Lázaro c'oton chuwech jun juyu', y tz'apel ca ruchi' riq'ui jun abej. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y yac'ari' tek ri Jesús xubij: Tiwelesaj la abej tz'apebel ruchi' la jul, xcha'. Yac'a ri Marta, ri rana' ca ri caminek, xubij chare ri Jesús: Ajaf, can c'o chic caji' k'ij ticom wi el, y ri' xa can c'o chic ruxla', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xubij chare ri Marta: Riyin can nbin chic c'a chawe chi wi xtanimaj, can xtatz'et c'a ri nuben ri ruchuk'a' ri Dios, xcha' chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y yac'ari' tek xquelesaj c'a ri abej tz'apebel ruchi' ri jul acuchi (achique) c'o wi ri caminek. C'ac'ari' ri Jesús xtzu'un c'a chicaj y xubij: Nata', matiox nya' chawe, ruma can xinawac'axaj c'a pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Riyin wetaman chi can yinawac'axaj wi pe. Y ronojel c'a re', nbij cuma re winek re quimolon pe qui' wuq'ui wacami, riche (rixin) chi tiquinimaj chi can yit c'a riyit ri xatako pe wuche (wixin) chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Tek ri Jesús rubin chic c'a ka re ch'abel re', xurek ruchi' y xubij: Lázaro, cayacatej y catel pe, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y ri Lázaro, ri caminek chic el, xbe'el pe. Ri ruk'a' raken jabel c'a pison pa tak tziek, y cuchun c'a rupalej riq'ui jun su't. C'ari' ri Jesús xubij: Que'isolo' ca la tziek chrij, riche (rixin) chi utz nibiyin y nicowin nitzolin el, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Yac'ari' tek ye q'uiy israelitas ri ye aponak riq'ui ri María, xquinimaj ri Jesús tek xquitz'et ri xuben, chi xuc'asoj ri caminek. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero yec'o nic'aj chique riye' ri xebe quiq'ui ri achi'a' fariseos y xbequitzijoj chique ri achique ri xuben ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y can yac'ari' tek ri principali' tak sacerdotes y ri achi'a' fariseos xquimol qui' y xequisiq'uij (xecoyoj) chuka' ri nic'aj chic achi'a' ri pa moc (comon) yek'ato tzij quiq'ui, y xquibij chique: ¿Achique c'a nikaben? Ruma re achi re' ruchapon samaj y q'uiy milagros ri yerubanala' chiquiwech ri winek riche (rixin) chi niquinimaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y wi xtikaya' c'a k'ij chare, can quinojel c'a ri winek xqueniman riche (rixin). Y tek xtiquinabej pe ri winek romanos, xtoquiwulaj ca ri lok'olaj jay ri acuchi (achique) nikaya' wi ruk'ij ri Dios y xkojquiq'uis ca chuka' riyoj ri yojc'o chupan re ruwach'ulef re', xecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yac'ari' tek c'o jun ri xch'o. Ri xch'o ya c'a ri Caifás ri nimalaj sacerdote chupan ri tiempo ri'. Riya' c'o c'a ri chiri', ruma riya' jun chique ri can c'o quik'ij. Y tek riya' xch'o, xubij c'a: Xa majun iwetaman riyix. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Can ma nich'ob ta c'a juba' chi xa más utz chake riyoj chi xaxu (xaxe wi) ri jun nicom pa kaq'uexel konojel y ma yojcom ta konojel xaxu (xaxe wi) ruma ri jun ri', xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ri Caifás tek xch'o y xubij queri', ma ya ta ri nuch'ob ka riya' ri xubij, ma que ta ri'. Ri ch'abel ri xerubij riya', can ya c'a ri Dios ri xya'o pe chare. Y ruma chi can ya c'a riya' ri nimalaj sacerdote chupan ri tiempo ri', rumari' tek ri Dios xuya' c'a k'ij chare chi xubij yan apo chi ri Jesús c'o c'a chi nicom na pa quiq'uexel ri winek riche (rixin) ri ruwach'ulef Israel. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y ri Jesús can ma xu (xe) ta c'a pa quiq'uexel ri winek israelitas tek xticom, xa can xticom c'a riche (rixin) chi yerumol quinojel ri winek ri can ye ralc'ual wi ri Dios ri quiquiran qui' chuwech re ruwach'ulef. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y can ya c'a k'ij ri' tek xquiya' yan c'a chiquiwech chi xtiquicamisaj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumac'ari', ri Jesús ma xtz'etetej ta chic cuma ri achi'a' israelitas ri c'o quik'ij. Riya' xa xbe c'a pa jun chic tinamit. Xbe pa jun tinamit Efraín rubi', y ri tinamit c'a ri' c'o apo chunakajal ri desierto. Y xc'oje' c'a ka chiri' ye rachibilan ri rudiscípulos. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y xa napon yan ri k'ij riche (rixin) ri pascua, ri jun quinimak'ij ri israelitas. Rumari' can ye q'uiy winek ri ye elenak pe pa tak quitinamit, riche (rixin) chi xebe pa tinamit Jerusalem. Can xebe yan c'a ruma c'o chi nbequich'ajch'ojsaj qui' chuwech ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y ri winek niquicanola' c'a ri Jesús. Riye' ye pa'el chupan ri rachoch ri Dios y niquic'utula' c'a chiquiwech: ¿Achique c'a nich'ob riyix? ¿Xtipe cami chupan re nimak'ij re'? yecha' c'a ri winek ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yac'a ri principali' tak sacerdotes y ri achi'a' fariseos, can quelesan chic rubixic chi xabachique c'a winek ri xtetaman acuchi (achique) c'o wi ri Jesús, tubij chique riye', riche (rixin) chi niquichop. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Tek xa waki' chic c'a k'ij nrajo' riche (rixin) chi ma napon ri k'ij riche (rixin) ri nimak'ij pascua, ri Jesús xbe pa tinamit Betania, ri rutinamit ri Lázaro; ri Lázaro ri xcom el y xbec'asox pe chiquicojol ri caminaki' ruma ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y ri chiri' xban c'a jun nimawa'in, ruma xapon ri Jesús. Y ya c'a ri Marta ri niniman nilin apo pa mesa. Y chuka' ri Lázaro tz'uyul chiquicojol ri winek ri ye tz'uyul apo pa mesa riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpe c'a ri María rana' ri Lázaro, xberuc'ama' c'a pe jun libra ak'om ri jubul ruxla' ri nardo rubi', ri sibilaj jotol rajel y xuya' chrij raken ri Jesús y xerusula' ca riq'ui ri rusmal tak ruwi'. Y ri jay ri' can xnoj c'a riq'ui ri ruxla' ri ak'om ri'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y c'o c'a jun chique ri discípulos ri ma xka ta chuwech chi queri' xban chare ri ak'om jubul ruxla', y ri' ya ri Judas Iscariote ri ruc'ajol ri jun achi ri Simón rubi'; ri discípulo ri xtijacho na riche (rixin) ri Jesús pa quik'a' ri winek. Riya' xubij c'a: ");
INSERT INTO cakWNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Achique c'a ruma tek xa ma xc'ayix ta re jubulaj ak'om re'? Re ak'om re' xa xbe ta chi oxi' ciento denarios, y ri puek ri' xya'ox (xya') ta chique ri pobres, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Tek riya' xubij queri', ma ruma ta c'a chi yerajo' ri pobres, y nrajo' ta yeruto', ma que ta ri'. Xa ruma c'a chi ya riya' ri yacol puek y c'o c'a nrelek'aj el, ruma chi riya' can alek'om wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Can yac'ari' tek ri Jesús xubij chare ri Judas: Ma tanek ta. Xa taya' c'a ca chi tubana' na ri nrajo' ri ránima. Ruma re ak'om re' can ruyacon pe riche (rixin) chi nuya' chuwij tek xa napon ri k'ij chi xquibemuk ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ruma ri pobres xa can yec'o wi iwuq'ui y xabachique k'ij utz niben utzil chique. Yac'a riyin ma ronojel ta tiempo xquic'oje' iwuq'ui, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tek ri Jesús xnabex c'a pe cuma ri rech aj Israel chi c'o pa Betania, xepe. Y sibilaj c'a ye q'uiy winek ri xepe. Quinojel c'a ri winek ri' xepe ruma ri Jesús y riche (rixin) chuka' chi niquitz'et ca ri Lázaro, ri xc'asox pe ruma ri Jesús chiquicojol ri caminaki'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Pero ri principali' tak sacerdotes xquiya' chiquiwech chi nicajo' niquicamisaj chuka' ri Lázaro. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ruma chi xa can rumac ri Lázaro tek ye q'uiy quech aj Israel ri ye'el el quiq'ui riye' ruma niquinimaj ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pa ruca'n k'ij, ri chiri' pa tinamit Jerusalem, can ye sibilaj c'a ye q'uiy winek yec'o. Quinojel c'a ri' ye aponak chiri' ruma ri nimak'ij. Y tek xquic'axaj c'a chi benak apo ri Jesús, ");
INSERT INTO cakWNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","xequic'uaj apo ruxak tak che' ri nibix palma chare, xebe chuc'ulic y riq'ui c'a quichuk'a' niquibij: ¡Matiox chi petenak re jun achi re'! ¡Yare' ri Rey riche (rixin) re katinamit Israel, y can banon pe bendecir ruma ri Ajaf Dios, y can pa rubi' ri Ajaf Dios petenak wi! yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y ri Jesús can c'o c'a jun ti alaj bur ri xril, riche (rixin) chi xuch'ocolbej, can achi'el wi c'a ri nubij chupan ri ruch'abel ri Dios ri tz'ibatal ca. Chiri' nubij: ");
INSERT INTO cakWNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man c'a tixibij ta iwi' riyix ri yix riche (rixin) chic ri tinamit Sion; ruma yac'are' petenak ri Rey riche (rixin) re itinamit, ch'ocol pe chrij jun ti alaj bur. Quec'ari' ri tz'ibatal ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Y pa nabey mul, ronojel re' man c'a xk'ax ta chiquiwech ri rudiscípulos. Y xk'ax chiquiwech can c'a ya tek ri Jesús c'astajnek chic el chiquicojol ri caminaki' y tek c'o chic ruk'ij ruc'ojlen. C'ac'ari' tek xnatej chique chi ronojel re' can tz'ibatajnek wi ca; y can queri' wi ri xbanatej. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri winek c'a ri xetz'eto riche (rixin) ri Jesús tek xusiq'uij (xroyoj) ri Lázaro ri caminek chic el riche (rixin) chi xc'astej pe chiquicojol ri caminaki', can niquitzijola' c'a chique ri nic'aj chic winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y rumac'ari', tek ri Jesús xa nakaj chic c'o wi apo chare ri tinamit Jerusalem, ri winek can xepe c'a riche (rixin) chi noquic'ulu', ruma can quic'axan chic c'a ri milagro ri xuben riq'ui ri Lázaro. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Yac'a ri achi'a' fariseos niquibila' c'a chiquiwech: Titzu' la' xa majun nikach'ec, ruma xa ma niquinimaj ta katzij y xa quinojel ri winek ye benak riq'ui, yecha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicojol c'a quinojel ri winek ri ye aponak pa tinamit Jerusalem riche (rixin) chi niquiya' ruk'ij ri Dios chupan ri nimak'ij, yec'o chuka' ye ca'i' oxi' winek griegos. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Re ca'i' oxi' c'a winek re', xe'apon apo riq'ui ri Felipe ri aj Betsaida ri tinamit ri c'o pa rucuenta ri Galilea, riche (rixin) chi niquic'utuj jun utzil chare; ruma riya' jun rudiscípulo ri Jesús. Ri winek ri' xquibij c'a chare: Táta, riyoj nikajo' yojch'o riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xbe y xberubij c'a chare ri Andrés ri can discípulo chuka'. C'ari' chi ye ca'i' xebe apo c'a riq'ui ri Jesús y xquibij chare: Yec'o ca'i' oxi' winek griegos ri nicajo' yech'o awuq'ui. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y ri Jesús can yac'ari' xubij chique ri ca'i' discípulos ri': Ya xapon ri k'ij, riche (rixin) chi riyin ri C'ajolaxel ri xinalex chicojol xtiya'ox (xtya') chic nuk'ij nuc'ojlen chila' chicaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Can kitzij c'a re xtinbij chiwe: Jun ruwech trigo wi ma nimuk ta ka pan ulef, ri ti ruwech ri trigo ri' xa choj c'a queri' xtic'oje'. Pero wi nimuk ka pan ulef, ri ti ruwech trigo ri', xtiq'uis c'a chuxe' ri ulef, pero xtitz'uc pe y xtuya' ruwech. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Y que chuka' ri' ri winek ri sibilaj nupokonaj ri ruc'aslen wawe' chuwech re ruwach'ulef, ma xtril ta ruc'aslen riche (rixin) xtibe k'ij xtibe sek. Yac'a ri ma nupokonaj ta ri ruc'aslen wawe' chuwech re ruwach'ulef wuma riyin, can jun c'aslen riche (rixin) xtibe k'ij xtibe sek ri nuyec apo. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Wi can c'o c'a jun winek ri nrajo' nuben ri nusamaj, can quirutzekelbej c'a. Y ri acuchi (achique) c'a yinc'o wi riyin, can chiri' c'a chuka' xtic'oje' wi riya'. Ri can xtibano c'a ri nusamaj, xtiya'ox (xtya') c'a ruk'ij ruma ri Nata'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Riyin can sibilaj c'a nik'axo ri wánima wacami. ¿Pero la xtinbij ta c'a chare ri Nata': Quinacolo' c'a chuwech re k'axomal re'? Tek xa can rumari' xinoka. Rumari' tek c'a yinc'o na wacami. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yac'ari' tek Riya' xubij: Nata', can tabana' c'a chi xtik'alajin ta ri ak'ij ac'ojlen, xcha'. Y can yac'ari' tek c'o jun ch'abel xpe chila' chicaj y xubij: Can nbanon chic c'a queri'. Y xtinben chic c'a jun bey, chi can xtik'alajin wi ri nuk'ij nuc'ojlen. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y tek xac'axex c'a ri ch'abel ri' cuma ri sibilaj ye q'uiy winek ri yec'o chiri', yec'o q'uiy xebin chi xa jun coklajay ri xquic'axaj. Yac'a ri nic'aj chic xquibij chi jun ángel ri xch'o pe chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y ri Jesús xubij c'a chique: Ri ch'abel ri xiwac'axaj ri xpe chila' chicaj, xch'o pe iwuma riyix y ma wuma ta riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Wacami can k'ij chic chi ri Dios nuk'et tzij pa ruwi' re ruwach'ulef, y ri itzel winek ri chapayon re ruwach'ulef, can xtelesex c'a el. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y tek riyin xquijotobex chuwech cruz, ri winek can xquepe c'a wuq'ui; ruma riyin can xquisamej pa tak cánima, xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ri Jesús xubij c'a queri', riche (rixin) chi xuk'alajsaj c'a achique rubanic xtiban chare chi xticamisex. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ri winek xquibij c'a chare: Riyoj ketaman ri nubij chupan ri ruch'abel ri Dios chi tek xtipe ri Cristo, can xtic'oje' riche (rixin) xtibe k'ij xtibe sek. Riyit abin chi yit c'a riyit ri C'ajolaxel ri xatalex chkacojol, ¿achique c'a ruma nabij chi yajotobex chuwech cruz? Can tak'alajsaj c'a chkawech achique c'a chi achi ri' ri C'ajolaxel. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yac'ari' tek ri Jesús xubij chique: Ri Sakil can c'a c'o na juba' iwuq'ui. Can chupan c'a ri Sakil ri' quixbiyin wi, ruloman chi c'a c'o na iwuq'ui. Ruma wi ma xtiben ta queri', c'a tek xtina', nik'ekumer pe chiwech; y ri xa pa k'eku'm nibiyin wi, ma retaman ta acuchi (achique) benak wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Rumari', tek c'a c'o na re Sakil iwuq'ui, can ticukuba' ic'u'x riq'ui, riche (rixin) chi yixoc ralc'ual ri Sakil ri'. Quec'ari' ri xerubij ri Jesús chique ri winek. C'ac'ari' xeruya' ca, y majun c'a xetaman ta acuchi (achique) xbe wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús can xerubanala' wi q'uiy milagros chiquiwech ri winek. Pero ma riq'ui wi ri' riye' ma xquinimaj ta. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y quec'ari' xbanatej, ruma c'o c'a chi nibanatej na ri rutz'iban ca ri profeta Isaías ri xk'alajsan ri ruch'abel ri Dios ojer ca. Riya' rutz'iban c'a ca: Ajaf, ri ach'abel ri xkatzijoj chique ri winek, ¿la can c'o cami jun ri xniman? ¿C'o cami c'a jun ri xk'ax yan chuwech, ruma xutz'et ri awuchuk'a'? Queri' nubij ri rutz'iban ca ri Isaías. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Re winek re' can ma yecowin ta niquinimaj, ruma chupan ri rutz'iban ca ri Isaías nubij chuka': ");
INSERT INTO cakWNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Can banon c'a chique riye' chi ma yetzu'un ta y cowirnek ri cánima; riche (rixin) chi ma niquitz'et ta ri nic'ut chiquiwech, ma nika ta ka pa tak cánima, y ma nitzolin ta pe quic'u'x riche (rixin) chi riyin nchojmirisaj ri quic'aslen, nicha' ri Ajaf. Queri' ri tz'ibatal ca ruma ri Isaías. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri profeta Isaías, ri achi ri xk'alajsan ri ruch'abel ri Dios ojer ca, xubij quere' tek xutz'et yan c'a ruk'ij ruc'ojlen ri Ajaf Jesús, y chrij c'a Riya' ch'onak wi ca. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero ma riq'ui wi ri', ye q'uiy chique ri achi'a' ri pa moc (comon) yek'ato tzij chiquicojol ri israelitas ri xeniman riche (rixin) ri Jesús. Xa yac'a chi ma xquik'alajsaj ta qui', ruma niquixibij qui' chiquiwech ri fariseos, chi man xa que'okotex pe chupan ri jay ri kas nic'ut wi ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Queri' xquiben, ruma riye' más nika chiquiwech ri quik'ij ri niya'ox (nya') cuma ri winek, que chuwech ri quik'ij ri niya'ox (nya') ruma ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y ri Jesús riq'ui c'a ruchuk'a' xch'o y xubij: Ri niniman c'a wuche (wixin) riyin, ma xu (xe) ta c'a riyin ri yirunimaj, xa can nunimaj c'a ri Dios ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri nitz'eto wuche (wixin), can nutz'et c'a chuka' ri Dios ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ruma yin c'a riyin ri Sakil ri xipe chuwech re ruwach'ulef riche (rixin) chi achique c'a ri xtiniman wuche (wixin), ma xtic'oje' ta ca chupan jun k'ekumlaj c'aslen. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Y ri winek ri nrac'axaj ri nuch'abel y xa ma nuyec ta pa ránima y ma nuben ta ri nrac'axaj; ma yin ta c'a riyin ri xquik'ato tzij pa ruwi'. Ruma riyin xipe chuwech re ruwach'ulef, ma riche (rixin) ta chi nk'et tzij pa quiwi' ri winek. Riyin xipe riche (rixin) chi yencol ri winek. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ri netzelan c'a wuche (wixin) y ma nuc'ul ta ri nuch'abel pa ránima, pa ruq'uisbel k'ij can xtik'at na c'a tzij pa ruwi'. Ri xtik'ato tzij pa ruwi' can ya ri ch'abel ri xenk'alajsaj. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ruma ri ch'abel ri xenk'alajsaj chiwech, can ya c'a ri Nata' ri biyon pe chuwe, y xa ma yin ta riyin yibin. Can ya c'a Riya' ri yin takayon pe y rubin c'a pe chuwe achique chi ch'abel ri nonbij y nonk'alajsaj chiwe. ");
INSERT INTO cakWNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y can wetaman c'a chi ri rubin pe ri Nata' Dios chuwe, can nuya' wi c'a c'aslen riche (rixin) xtibe k'ij xtibe sek. Rumari' re ch'abel re nonbij c'a chiwe, can achi'el ri rubin pe ri Nata' chuwe riyin, can queri' rubixic xonbana' chiwe riyix. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y tek xa napon yan ri nimak'ij pascua, ri Jesús retaman chic c'a chi napon yan ri hora riche (rixin) chi Riya' ntel el wawe' chuwech re ruwach'ulef y nitzolin chila' chicaj riq'ui ri Dios, ri Rutata'. Ri Jesús sibilaj c'a ye rajowan pe quinojel ri can ye riche (rixin) chic Riya' ri yec'o wawe' chuwech re ruwach'ulef, y can achi'el ye rajowan pe, can quec'ari' xuq'uis pa ruwi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ri Jesús y ri rudiscípulos quichapon c'a wa'in. Yac'a ri Judas Iscariote, ri ruc'ajol ri jun achi ri Simón rubi', nisamej chic c'a ri itzel winek pa ránima, y yac'ari' ri nibin chare chi tujacha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Y astape' ri Jesús can retaman wi chi ronojel jachon pa ruk'a' ruma ri Dios ri Rutata', y chiri' riq'ui ri Dios petenak wi y chiri' chic nitzolin wi el; ");
INSERT INTO cakWNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","pero ma riq'ui wi ri' Riya' ma xupokonaj ta xuya' ca ri ruwa'in y xyacatej pe. Riya' xrelesaj c'a ca ri tziek ri ruya'on chrij, xberuc'ama' pe jun toalla, y xuxim xerupan. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","C'ac'ari' xuya' chuka' ya' chupan jun palangana y xuchop ruch'ajic ri caken chiquijujunal ri rudiscípulos y nusula' c'a ri caken riq'ui ri toalla ri ruximon xerupan. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yac'a tek xapon riq'ui ri Simón Pedro riche (rixin) chi nuch'ej ri raken, ri Pedro xubij chare ri Jesús: Ajaf, ¿can nach'ej c'a chuka' waken riyin? xcha'. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xubij c'a chare ri Pedro: Re nch'ej re iwaken wacami, ma jane c'a nik'ax ta chiwech achique ruma tek nben. Pero can xtik'ax c'a chiwech ri más chkawech apo. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Yac'a ri Pedro xubij: Riyin ma juba' xtinya' ta k'ij chi can yit c'a riyit yach'ajo re waken, xcha'. Y ri Jesús xubij c'a chare: Wi man c'a naya' ta k'ij riche (rixin) chi nch'ej ri awaken, xa ma yit ta chic nudiscípulo c'a ri', xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Rumac'ari' ri Simón Pedro xubij chare ri Jesús: Ajaf, wi queri', man c'a xaxu (xaxe) ta wi re waken nach'ej, xa can tach'aja' c'a chuka' re nuk'a' y re nujolon (nuwi'), xcha' ri Pedro. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xubij chare: Ri ruch'ajch'ojsan chic ri', xaxu (xaxe) wi c'a ri raken ri rajawaxic chi nuch'ej, ruma riya' can ch'ajch'oj chic. Riyix can yix ch'ajch'oj chic, astape' ma chi'iwonojel ta, xcha' ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Riya' xubij c'a queri', ruma can retaman achique ri xtijacho el riche (rixin) pa quik'a' ri winek. Y rumari' tek xubij: Ma chi'iwonojel ta yix ch'ajch'oj. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y tek ri Jesús ruch'ajon chic c'a caken ri rudiscípulos, xberuc'ama' chic c'a pe ri tziek ri relesan ca chrij, xbetz'uye' chic pa mesa y xubij c'a: ¿Xk'ax chiwech achique ruma tek riyin xinch'ej ri iwaken? ");
INSERT INTO cakWNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Riyix nibij Katijonel y Kajaf chuwe. Can utz wi ri nibij, ruma can yin wi. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y ruma wi riyin ri Itijonel y ri Iwajaf xinch'ej ri iwaken, can queri' c'a chuka' tibana' riyix. Man c'a tipokonaj ta nich'ajla' iwaken chi'iwachibil iwi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Riyin xinc'ut yan c'a ca chiwech. Can achi'el c'a ri xinben riyin iwuq'ui riyix, queri' chuka' tibana' riyix quiq'ui ri nic'aj chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Can kitzij c'a nbij chiwe: Ma ya ta ri mozo ri más nim ruk'ij que chuwech ri rupatrón; ni ma ya ta ri jun ri nitak, ma ya ta chuka' ri' ri más nim ruk'ij que chuwech ri takayon riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wi riyix can xiwetamaj c'a ca ronojel re' y can niben c'a re xiwetamaj, can jabel c'a ruwa'ik'ij. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Can nbij c'a chi ma iwonojel ta xquixbano queri', ruma riyin can wetaman iwech chi'iwonojel ri xixincha'. Y chuka' ri tz'ibatal ca, c'o c'a chi nibanatej na. Achi'el ri nubij: Ri jun c'a ri can xwa' wuq'ui, xyacatej c'a chuwij. Queri' nubij chupan ri ruch'abel ri Dios. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Y wacami can nya' yan c'a apo rutzijol chiwe ri xtibanatej, riche (rixin) chi queri' tek xtapon ri k'ij chi xtibanatej re', xtinimaj c'a chi can yin c'a riyin ri Cristo. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can kitzij wi c'a nbij chiwe, ri xtic'ulu c'a riche (rixin) ri ntek el riyin, can yin c'a riyin ri yiruc'ul. Y ri xquic'ulu c'a riyin, xa can xtuc'ul c'a chuka' ri yin takayon pe. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y tek ri Jesús rubin chic c'a ronojel re', ri ránima can achique na c'a xuben xuna' Riya', ruma ri bis. Riya' can xuk'alajsaj c'a achique ruma tek sibilaj bis c'o pa ránima y xubij c'a: Kas kitzij c'a ri nbij chiwe, chi jun chiwe riyix ri xquijacho el pa quik'a' ri winek, xcha' chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Can yac'ari' tek ri ye rudiscípulos xquitzula' quiwech, y ma niquil ta c'a achique niquich'ob; ruma ma quetaman ta achoj chrij xch'o wi ri Jesús. Can man c'a quetaman ta achique ri xtijacho el riche (rixin). ");
INSERT INTO cakWNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yac'a ri jun chique ri rudiscípulos, ri sibilaj najowex ruma ri Jesús, ye rak'el c'a junan riq'ui ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y chare c'a ri jun discípulo ri', ri xuben wi apo retal ri Simón Pedro. Riya' xubij c'a apo chare chi tuc'utuj chare ri Jesús chi achique c'a ri' ri xtijacho el riche (rixin), ri xa c'ari' nubij ka chique. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri discípulo ri rak'el c'a apo chunakajal ri ruwaruc'u'x ri Jesús, yac'ari' tek xuc'utuj c'a chare: Ajaf, ¿achique c'a ri' ri jun ri xtijacho el awuche (awixin)? xcha' chare ri Jesús. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús can yac'ari' tek xubij chare ri discípulo ri': Ri achoj chare xtinya' wi ri caxlan wey muban, yac'ari' ri xtijacho el wuche (wixin), xcha'. Y Riya' xumuba' c'a ri caxlan wey y xuya' chare ri Judas Iscariote ri ruc'ajol ri jun achi Simón rubi'. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y tek ri Judas Iscariote ruq'uison chic c'a ka ri juwech' caxlan wey ri', can xoc wi c'a ri Satanás pa ránima. C'ac'ari' tek ri Jesús xubij chare: Ri ach'obon chic chi naben, tabana' c'a chanin, xcha' el chare. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yec'a ri rudiscípulos ri yec'o apo ri pa mesa riq'ui ma xk'ax ta chiquiwech achique ruma tek xubij el queri' chare ri Judas. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yec'o xech'obo chi xtak el ruma ri Jesús chulok'ic ronojel ri nic'atzin chique chupan ri nimak'ij ri'. Y yec'o chic nic'aj chique ri discípulos xech'obo chi xtak el riche (rixin) chi c'o nberuyala' ca chique ri pobres, ruma ri discípulos can quetaman wi chi ya ri Judas ri yacol puek. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ri Judas xa can xu (xe) wi c'a tek xuq'uis el ri juwech' caxlan wey, xa can yac'ari' tek xel el. Tek xel c'a el riya', xa can chak'a' chic. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y tek ri Judas elenak chic c'a el, yac'ari' tek ri Jesús xubij: Yac'are' xoka yan ri k'ij chi riyin ri C'ajolaxel ri xinalex chicojol xtik'alajin chi can c'o wi nuk'ij nuc'ojlen. Y can queri' c'a chuka' ri Dios; can xtik'alajin ri ruk'ij ruc'ojlen wuma riyin. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y ruma chi ri Dios can xtik'alajin ri ruk'ij ruc'ojlen wuma riyin; rumari' Riya' can xtuben c'a chi nik'alajin ri nuk'ij nuc'ojlen riyin. Y ri' man c'a ajan (jampe') ta na, xa can ya c'a re k'ij re'. ");
INSERT INTO cakWNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Juba' chic c'a oc re yic'oje' el iwuq'ui riyix ri can achi'el tak walc'ual nbanon chiwe. C'ac'ari' xquinicanoj. Pero re wacami can nbij c'a ca chiwe, achi'el ri nbin chique nic'aj aj Israel, chi ri xquibec'oje' wi riyin, ma xquixcowin ta xquixapon chinucanoxic. ");
INSER