﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakSNT_vpl;
CREATE TABLE cakSNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakSNT_vpl WRITE;
INSERT INTO cakSNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chupan va libro va, tzꞌibꞌan can ri quibꞌeꞌ ri i-rateꞌt-rumamaꞌ can ri Jesucristo. Ri Jesucristo rumáma can ri rey David, y rumáma can jeꞌ ri Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham rutataꞌ ri Isaac; ri Isaac rutataꞌ ri Jacob; ri Jacob rutataꞌ ri Judá y nicꞌaj chic ruchakꞌ-runimal. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Y ri Judá y ri Tamar quitie-quitataꞌ ri Fares y ri Zara; y ri Fares rutataꞌ ri Esrom; y ri Esrom rutataꞌ ri Aram. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y ri Aram rutataꞌ ri Aminadab; ri Aminadab rutataꞌ ri Naasón; y ri Naasón rutataꞌ ri Salmón. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Y ri Salmón y ri Rahab, rutie-rutataꞌ ri Booz; ri Booz y ri Rut rutie-rutataꞌ ri Obed; y ri Obed rutataꞌ ri Isaí. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y ri Isaí rutataꞌ ri rey David; y ri rey David rutataꞌ ri Salomón. Ri Salomón ral ri Betsabé ri raxjayil ri Urías, y después xuoc raxjayil ri rey David. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Y ri Salomón rutataꞌ ri Roboam; ri Roboam rutataꞌ ri Abías; y ri Abías rutataꞌ ri Asa. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y ri Asa rutataꞌ ri Josafat; ri Josafat rutataꞌ ri Joram; y ri Joram rutataꞌ ri Uzías. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y ri Uzías rutataꞌ ri Jotam; ri Jotam rutataꞌ ri Acaz; y ri Acaz rutataꞌ ri Ezequías. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y ri Ezequías rutataꞌ ri Manasés; ri Manasés rutataꞌ ri Amón; y ri Amón rutataꞌ ri Josías. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y ri Josías xcꞌujieꞌ jun ralcꞌual ri xubꞌinaj Jeconías y nicꞌaj chic ralcꞌual, chupan ri tiempo antok xaꞌtzꞌam y xaꞌcꞌuax ri israelitas chi xaꞌbꞌacꞌujieꞌ chupan ri Babilonia. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y antok icꞌo chic chireꞌ Babilonia, ri Jeconías xcꞌujieꞌ jun ralcꞌual ri xubꞌinaj Salatiel; y ri Salatiel rutataꞌ ri Zorobabel. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y ri Zorobabel rutataꞌ ri Abiud; ri Abiud rutataꞌ ri Eliaquim; y ri Eliaquim rutataꞌ ri Azor. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y ri Azor rutataꞌ ri Sadoc; ri Sadoc rutataꞌ ri Aquim; y ri Aquim rutataꞌ ri Eliud. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y ri Eliud rutataꞌ ri Eleazar; ri Eleazar rutataꞌ ri Matán; ri Matán rutataꞌ jun chic ri Jacob jeꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri Jacob rutataꞌ ri José ri rachajil ri María. Y ri María xuoc rutieꞌ ri Jesús, ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Catorce generaciones xaꞌcꞌujieꞌ; nitiquir-pa riqꞌuin ri Abraham hasta cꞌa riqꞌuin ri rey David. Y catorce jeꞌ generaciones xaꞌcꞌujieꞌ; nitiquir-pa riqꞌuin ri rey David hasta cꞌa chupan ri tiempo antok ri israelitas xaꞌcꞌuax Babilonia. Y catorce jeꞌ generaciones xaꞌcꞌujieꞌ; nitiquir-pa riqꞌuin ri tiempo antok ri israelitas xaꞌcꞌuax Babilonia, hasta cꞌa riqꞌuin ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Antok xalax ri Jesucristo, quireꞌ xbꞌanataj: Ri María ri xuoc rutieꞌ ri Jesucristo, jun xtan cꞌutun chic ruma ri José chi nicꞌulieꞌ riqꞌuin. Pero antok cꞌa majaꞌ tiquicꞌan-quiꞌ, ri José xunaꞌiej chi ri María cꞌo chic encinta (embarazada). Ri María quireꞌ rubꞌanun xa ruma xka-pa ri Espíritu Santo paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pero ri José ri ntuoc rachajil ri María, can jun alaꞌ choj; y mareꞌ man xrajoꞌ ta xralasaj rubꞌixic ri María chiquivach ri vinak, rumareꞌ chalakꞌal nrajoꞌ nuyaꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y jareꞌ nuꞌon pensar jajaꞌ, chi choj chalakꞌal nuyaꞌ can, antok cꞌo jun ángel richin ri Ajaf xucꞌut-riꞌ choch pa rachicꞌ, y xuꞌej cha: José, at rumáma can ri rey David, man taxiꞌij-aviꞌ chi ncacꞌulieꞌ riqꞌuin ri María ri acꞌutun chic chi ntuoc avaxjayil; ruma ja ri Espíritu Santo ri xka-pa paroꞌ, mareꞌ vacame cꞌo chic encinta (embarazada). ");
INSERT INTO cakSNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri acꞌual ri xtalax, jun chꞌiti alaꞌ, y JESUS ri rubꞌeꞌ ri xtayaꞌ; ruma jajaꞌ xcaꞌrucol ri vinak choch ri qui-pecados. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nojiel reꞌ xbꞌanataj chi nuꞌon cumplir incheꞌl ruꞌeꞌn ri Ajaf Dios cha jun profeta ri xcꞌujieꞌ ojier can tiempo. Y quireꞌ xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Titzꞌataꞌ chi cꞌo jun xtan xticꞌujieꞌ encinta (embarazada). Y can xtalax jun ral-alaꞌ, ri xtubꞌinaj Emanuel. Ri bꞌiꞌaj reꞌ nrajoꞌ nuꞌej: Ri Dios cꞌo kiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Antok xcꞌastaj ri José, can xuꞌon-na-ve ri xꞌeꞌx cha ruma ri ángel richin ri Ajaf. Jajaꞌ can xucꞌan-na-ve ri María chi xuoc raxjayil. ");
INSERT INTO cakSNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero man xvar ta yan riqꞌuin, hasta cꞌa xalax ri naꞌay ral. Y antok ri José xuyaꞌ rubꞌeꞌ ri acꞌual, JESUS rubꞌeꞌ xuꞌon cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalax pa tanamet Belén, ri cꞌo chupan Judea. Antok xalax ri Jesús, ja ri Herodes ri rey, y jareꞌ antok nicꞌaj achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil) xaꞌlka Jerusalén. Ri achiꞌaꞌ reꞌ, cꞌa oriente i-patanak-ve, ");
INSERT INTO cakSNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquicꞌutuj cꞌa: ¿Pacheꞌ cꞌo-ve ri acꞌual ri xalax, ri qui-rey ri israelitas? Ruma ojreꞌ cꞌa oriente katzꞌatuon-pa ri ru-estrella (ruchꞌumil), y xojpa chi nalkayaꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Antok ri rey Herodes xraꞌxaj ri xquiꞌej ri achiꞌaꞌ, xsach runoꞌj. Y quireꞌ jeꞌ xquiꞌan ri vinak aj-Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y ri rey Herodes xaꞌrumol quinojiel ri principales sacerdotes y ri achiꞌaꞌ escribas chiquicajol ri israelitas, y xucꞌutuj chica pacheꞌ nalax-ve ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ijejeꞌ xquiꞌej cha ri rey: Ri Cristo nalax pa tanamet Belén vaveꞌ Judea. Ruma ri profeta ri xcꞌujieꞌ ojier can tiempo, quireꞌ rutzꞌibꞌan can: ");
INSERT INTO cakSNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y at Belén ri atcꞌo Judá, man at coꞌl ta oc chiquicajol ri nimaꞌk tak tanamet chireꞌ Judá, ruma aviqꞌuin atreꞌ xtitiel-el ri Jun ri xticꞌutu ri bꞌay, y can xcaꞌruchajij ri vinak aj-Israel ri nutanamit. Quireꞌ xquiꞌej cha ri rey Herodes. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Y antok ruyuon cꞌo ri rey Herodes, xaꞌrayuoj chalakꞌal ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil), y xucꞌutuj otz chica ri jampeꞌ xquitzꞌat ri estrella (chꞌumil). ");
INSERT INTO cakSNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y cꞌajareꞌ xaꞌrutak-el pa tanamet Belén y xuꞌej-el chica: Quixꞌin cꞌa y ticanuj ri acꞌual, y antok xtivil, tiliꞌej chuva, chi quireꞌ inreꞌ jeꞌ niꞌyaꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y antok ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil) caxan chic ri tzij ri xuꞌej ri rey Herodes chica, xaꞌa. Y ri estrella (chꞌumil) ri quitzꞌatuon-pa ijejeꞌ cꞌa oriente, bꞌanak chiquivach. Y antok xaꞌbꞌaka, ri estrella (chꞌumil) reꞌ xpiꞌieꞌ paroꞌ ri lugar pacheꞌ cꞌo-ve ri acꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil), antok xquitzꞌat chi xpiꞌieꞌ ri estrella (chꞌumil), can altíra xaꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Y antok xaꞌuoc pa jay, ja xquitzꞌat ri acꞌual y ri María ri rutieꞌ, y ja xaꞌxuquieꞌ choch ri acꞌual chi xquiyaꞌ rukꞌij. Y xaꞌquijak ri pacheꞌ quicꞌuan-ve ri niquisipaj can cha y xquiyaꞌ oro, incienso (puon) y mirra cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero chica ri achiꞌaꞌ reꞌ, pa cachicꞌ xꞌeꞌx chica chi man chic caꞌtzalaj riqꞌuin ri rey Herodes chi niquiꞌej cha. Mareꞌ antok ijejeꞌ xaꞌtzalaj chupan ri qui-nación, jun-ve chic bꞌay ri xquicꞌuaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y después antok xaꞌa ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil), jun ángel richin ri Ajaf xucꞌut-riꞌ choch ri José pa rachicꞌ. Y ri ángel reꞌ xuꞌej cha: Capalaj, tavucꞌuaj ri acꞌual y ri rutieꞌ y quixnumaj cꞌa chupan ri nación Egipto; quixcꞌujieꞌ chireꞌ y inreꞌ xtinꞌej chava jampeꞌ otz xquixtzalaj-pa. Ruma ri rey Herodes can xtucanuj ri acꞌual chi nuquimisaj, xchaꞌ ri ángel cha ri José pa rachicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y ri José xcꞌastaj, xucꞌuaj ri acꞌual y ri rutieꞌ. Can chupan ri mismo akꞌaꞌ reꞌ xquitzꞌom bꞌay chi xaꞌa cꞌa Egipto. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Y chireꞌ Egipto xaꞌcꞌujie-ve y xaꞌtzalaj-pa Israel cꞌa antok quiminak chic ri rey Herodes; chi quireꞌ nuꞌon cumplir incheꞌl ruꞌeꞌn ri Ajaf Dios cha ri profeta ri xcꞌujieꞌ ojier can tiempo. Ri tzꞌibꞌan can nuꞌej: Egipto cꞌo-ve ri Nucꞌajuol antok xinvayuoj. Quireꞌ ruꞌeꞌn ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y antok ri rey Herodes xunaꞌiej chi ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil) xa man xquiꞌan ta incheꞌl ri ruꞌeꞌn-el chica, jajaꞌ xyacataj altíra royoval y mareꞌ xuꞌon mandar chi caꞌquimisas quinojiel ri xuluꞌiꞌ alabꞌo ri cꞌajaꞌ xaꞌlax hasta caꞌyeꞌ quijunaꞌ ri icꞌo chireꞌ pa tanamet Belén y ri icꞌo pa tak lugar cierca ri tanamet. Ruma jajaꞌ rataꞌn can ri tiempo quiqꞌuin ri achiꞌaꞌ ri qꞌuiy cataꞌn chiquij ri estrellas (chꞌumil). ");
INSERT INTO cakSNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Vaveꞌ nuꞌon cumplir incheꞌl ri rutzꞌibꞌan can ri profeta Jeremías: ");
INSERT INTO cakSNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Pa tanamet Ramá xcꞌaxataj okꞌiej. Can cꞌo-ve bꞌis. Cꞌo cꞌa jun ri nujekꞌ okꞌiej y nijilo. Reꞌ ja ri Raquel ncaꞌrokꞌiej ri ral. Y man xrajoꞌ ta chi xꞌan consolar ruma xaꞌcon ri ral. Quireꞌ ri tzꞌibꞌan can ruma ri Jeremías. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y antok quiminak chic ri rey Herodes, ri ángel richin ri Ajaf xucꞌut chic riꞌ choch ri José pa rachicꞌ chireꞌ Egipto, ");
INSERT INTO cakSNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","y xuꞌej cha: Capalaj, tavucꞌuaj ri acꞌual y ri rutieꞌ y quixtzalaj cꞌa ri nación Israel. Ruma ri xcajoꞌ xquiquimisaj ri acꞌual chila, ya xaꞌcon. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y ri José can xuꞌon-ve ri xꞌeꞌx cha pa rachicꞌ ruma ri ángel. Xucꞌam-pa ri acꞌual y ri rutieꞌ, y xaꞌtzalaj-pa ri nación Israel. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero jajaꞌ ruma xraꞌxaj chi ri nibꞌano gobernar Judea, ja ri Arquelao ri rucꞌajuol ri rey Herodes, xuxiꞌij-riꞌ chi niꞌa y nicꞌujie-ka chireꞌ Judea. Pero cha ri José xꞌeꞌx pa rachicꞌ chica nuꞌon, y mareꞌ jajaꞌ Galilea xꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xbꞌaka cꞌa pa tanamet rubꞌinan Nazaret y chireꞌ xcꞌujie-ve-ka, chi quireꞌ nuꞌon cumplir incheꞌl quitzꞌibꞌan can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo chi ri Jesús can niꞌeꞌx-na-ve nazareno cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chupan ri tiempo reꞌ, ri Juan el Bautista xutzꞌom rutzijoxic ri ruchꞌabꞌal ri Dios chiquivach ri vinak, chupan jun lugar desierto ri cꞌo Judea. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Y jajaꞌ nuꞌej chica: Titzalaj-pa ivánima riqꞌuin ri Dios y tibꞌanaꞌ ri nrajoꞌ jajaꞌ, ruma xa cierca chic cꞌo-ve-pa ri ru-reino, nichaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Can ja chirij ri Juan el Bautista xchꞌo-ve can ri profeta Isaías. Quireꞌ cꞌa nuꞌej: Cꞌo jun ache ri xticꞌujieꞌ chupan jun lugar desierto, y jajaꞌ xturak cꞌa ruchiꞌ chi xtuꞌej chica ri vinak ri xcaꞌbꞌaka riqꞌuin: Tichojmij-apa rubꞌiey ri Ajaf, y can choj tibꞌanaꞌ cha. Quireꞌ ri rutzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ri rutziak ri Juan el Bautista bꞌanun cha ruveꞌ camello, y jutzꞌit tzꞌun rucusan chi ruximuon rupan. Y ri rutiꞌ, ja ri sacꞌ y ri cabꞌ ri niril pa tak kꞌayis. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y ri vinak ri ncaꞌbꞌaka riqꞌuin ri Juan el Bautista, can iqꞌuiy. Icꞌo ri i-patanak Jerusalén, y icꞌo ri i-patanak nicꞌaj chic tanamet richin ri Judea, y icꞌo jeꞌ ri i-patanak cierca ri río Jordán, ");
INSERT INTO cakSNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","y jajaꞌ ncaꞌruꞌon bautizar chireꞌ chupan ri río Jordán. Y niquiꞌej cꞌa ri qui-pecados ri i-quibꞌanun-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y antok jajaꞌ xutzꞌat chi iqꞌuiy chiquivach ri achiꞌaꞌ fariseos y chiquivach ri achiꞌaꞌ saduceos jeꞌ ncaꞌlka riqꞌuin ruma nicajoꞌ ncaꞌan bautizar, xuꞌej chica: ¡Ixreꞌ xa ix incheꞌl cumatz! ¿Chica xꞌeꞌn chiva chi nquixcolotaj choch ri castigo ri xtutak-pa ri Dios ri chakavach-apa? ");
INSERT INTO cakSNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ixreꞌ nicꞌatzin nticꞌut chi can ketzij nitzalaj-pa ivánima riqꞌuin ri Dios y ntiꞌan ri nrajoꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Y man tiꞌan-ka pensar ixreꞌ chi ruma ix rumáma can ri Abraham, rumareꞌ nquixcolotaj, man quireꞌ ta. Inreꞌ niꞌej chiva chi ri Dios nicovin ncaꞌruꞌon rumáma ri Abraham aún chica ri abꞌaj ri icꞌo vaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri castigo ri nuyaꞌ ri Dios ya nipa. Jajaꞌ xtuꞌon incheꞌl nuꞌon jun ache ri cꞌo chic ri icaj pa rukꞌaꞌ chi ncaꞌrukasaj quinojiel ri chieꞌ ri man otz ta quivach niquiyaꞌ, y xcaꞌruyaꞌ pa kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Inreꞌ, yaꞌ ri nicusaj chi nquixꞌan bautizar antok nitzalaj-pa ivánima riqꞌuin ri Dios y ntiꞌan ri nrajoꞌ jajaꞌ. Pero cꞌo Jun ri xtipa chuvij inreꞌ ri ni xa ta nucꞌul chi inreꞌ nivalasaj-el y niyaꞌ ri ruxajabꞌ chirakan, ruma jajaꞌ cꞌo nojiel poder riqꞌuin que chinoch inreꞌ, y jajaꞌ xquixruꞌon bautizar riqꞌuin ri Espíritu Santo y riqꞌuin kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ri Jun ri xtipa cꞌo jun incheꞌl horqueta pa rukꞌaꞌ y xtujoskꞌij ri ru-trigo pa ru-lugar. Y xtumol ri runakꞌ ri trigo y xtuyac. Y ri qꞌuin xtuyaꞌ pa kꞌakꞌ ri man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y ri Jesús xalka riqꞌuin ri Juan chireꞌ chuchiꞌ ri río Jordán. Jajaꞌ cꞌa Galilea alanak-pa chi niꞌan bautizar ruma ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero ri Juan man nrajoꞌ ta nuꞌon bautizar ri Jesús, y mareꞌ xuꞌej cha: Ja ta inreꞌ ri rucꞌamun chi nquinaꞌan bautizar, y vacame xa atreꞌ xatalka viqꞌuin chi ncanꞌan-el bautizar, xchaꞌ ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero ri Jesús xuꞌej cha: Tabꞌanaꞌ, ruma ojreꞌ nicꞌatzin nakaꞌan nojiel ri nuꞌej ri Dios. Cꞌajareꞌ ri Juan xuꞌon bautizar ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y antok ri Jesús bꞌanun chic bautizar, xiel-pa pa yaꞌ. Y ri rocaj xjakataj y jajaꞌ xutzꞌat-el chi ri Ru-Espíritu ri Dios nika-pa incheꞌl jun paluomix; y choj xka-pa paroꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y jareꞌ antok cꞌo Jun ri xchꞌo-pa chicaj y xuꞌej: Jareꞌ ri Nucꞌajuol; altíra nivajoꞌ y niquicuot vánima riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Entonces ri Jesús xucꞌuax ruma ri Espíritu Santo chupan jun lugar desierto, chi niꞌan tentar ruma ri diablo. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús cuarenta kꞌij y cuarenta akꞌaꞌ xuꞌon ayuno. Después reꞌ, xnem-pa rupan. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y jareꞌ antok xalka ri diablo riqꞌuin y xuꞌej cha: Xa ketzij chi atreꞌ ri at Rucꞌajuol ri Dios, tabꞌanaꞌ chica ri abꞌaj la chi ncaꞌuoc simíta. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero ri Jesús xuꞌej cha: Tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, chi ri ache man joꞌc ta cꞌa riqꞌuin ri simíta nicꞌasieꞌ, xa nicꞌasieꞌ jeꞌ riqꞌuin ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y ri diablo xucꞌuaj ri Jesús cꞌa chupan ri santa tanamet Jerusalén, y cꞌa paroꞌ ri más naj jatol chicaj richin ri templo xbꞌaruya-ve-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y chireꞌ xuꞌej cha ri Jesús: Xa ketzij chi atreꞌ ri at Rucꞌajuol ri Dios, tacꞌaka-ka-aviꞌ vaveꞌ. Ruma chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can, nuꞌej: Ri Dios xcaꞌrutak-pa ri ru-ángeles aviqꞌuin, y xcatquiliꞌiej pa quikꞌaꞌ, chi quireꞌ man xtacajij ta avakan choch abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero ri Jesús xuꞌej cha ri diablo: Tzꞌibꞌan can jeꞌ chupan ri ruchꞌabꞌal ri Dios: Man taꞌan tentar ri Avajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y ri diablo xucꞌuaj chic jun bꞌay ri Jesús, y xbꞌaruyaꞌ paroꞌ jun juyuꞌ ri naj jatol chicaj, y xucꞌut choch nojiel ri naciones richin ri roch-ulief y ri quibꞌayomal. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y ri diablo xuꞌej cha ri Jesús: Nojiel reꞌ niyaꞌ chava, xa atreꞌ ncaxuquieꞌ chinoch chi nayaꞌ nukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero ri Jesús xuꞌej cha: Caꞌin Satanás. Ruma ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios nuꞌej: Xa ja ri Kajaf Dios takayaꞌ rukꞌij, y kabꞌanaꞌ rusamaj jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y ri diablo xuyaꞌ can ri Jesús. Y jareꞌ antok xaꞌlka ángeles riqꞌuin chi xquiꞌan servir. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y antok ri Jesús xraꞌxaj chi ri Juan el Bautista cꞌo pa cárcel, xtzalaj chic Galilea, ");
INSERT INTO cakSNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","y xbꞌaka pa tanamet Nazaret. Después xuyaꞌ can y xꞌa pa tanamet Capernaum y chireꞌ xcꞌujie-ve. Ri tanamet reꞌ cꞌo chuchiꞌ jun mar y cꞌo chiquicajol ri caꞌyeꞌ lugar quibꞌinan Zabulón y Neftalí. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ri Jesús xbꞌaka chireꞌ, chi quireꞌ nuꞌon cumplir incheꞌl rutzꞌibꞌan can ri profeta Isaías. Jajaꞌ rutzꞌibꞌan can: ");
INSERT INTO cakSNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ri vinak ri icꞌo chupan ri caꞌyeꞌ lugar rubꞌinan Zabulón y Neftalí, ri icꞌo chuchiꞌ ri jun mar, ri cꞌo-apa jucꞌan ri río Jordán. Ri Galilea ri pacheꞌ icꞌo-ve vinak ri man israelitas ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri vinak ri can kꞌakuꞌn rubꞌanun quicꞌaslien, xquitzꞌat jun nem Luz. Ri can cꞌo chic ri rumuchꞌuchꞌil ri camic pa quiveꞌ, xaꞌruꞌon alumbrar ri Luz. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y jareꞌ antok ri Jesús xutzꞌom rutzijoxic ri ruchꞌabꞌal ri Dios y nuꞌej chica ri vinak: Titzalaj-pa ivánima riqꞌuin ri Dios y tibꞌanaꞌ ri nrajoꞌ jajaꞌ, ruma xa cierca chic cꞌo-ve-pa ri ru-reino, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y jun kꞌij antok ri Jesús bꞌanak chuchiꞌ ri mar Galilea, xaꞌrutzꞌat icaꞌyeꞌ achiꞌaꞌ ri quichakꞌ-quinimal-quiꞌ; jun ja ri Simón ri niꞌeꞌx jeꞌ Pedro cha, y ri jun chic ja ri Andrés; ijejeꞌ i-tzꞌamoy-car, mareꞌ niquiya-ka ri quiyaꞌl chupan ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Y xchꞌo-apa chica ri icaꞌyeꞌ achiꞌaꞌ reꞌ y xuꞌej chica: Joꞌ viqꞌuin, y xtincꞌut chivach cheꞌl nquiꞌcanuj vinak chi nquinquinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ri icaꞌyeꞌ achiꞌaꞌ reꞌ, ja xquiyaꞌ can ri quiyaꞌl y xaꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Y cꞌa jubꞌaꞌ caꞌin, ri Jesús xaꞌrutzꞌat chic icaꞌyeꞌ ri quichakꞌ-quinimal-quiꞌ jeꞌ, ja ri Jacobo y ri Juan, ri i-rucꞌajuol ri Zebedeo. Ijejeꞌ icꞌo riqꞌuin ri quitataꞌ chupan ri barco, y niquicꞌajuoj ri quiyaꞌl richin niquitzꞌom car. Y ri Jesús xaꞌrayuoj chi ncaꞌa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y ijejeꞌ ja xquiyaꞌ can ri quitataꞌ y ri barco y ja xaꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Y ri Jesús nojiel tanamet richin ri Galilea xakꞌax, ncaꞌrutijuoj ri vinak pa tak sinagogas, y nutzijuoj chica ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, y ncaꞌruꞌon jeꞌ sanar iqꞌuiy vinak ri diferente roch yabꞌil y kꞌaxuon ntuoc chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ri rutzijoxic ri Jesús xꞌa nojiel tanamet richin ri Siria. Y xaꞌcꞌamar-pa iqꞌuiy yavaꞌiꞌ choch, ri diferente roch yabꞌil ntuoc chica. Icꞌo ri altíra nikꞌaxo ri qui-cuerpo. Icꞌo ja ri itziel tak espíritus acunak quiqꞌuin. Icꞌo i-chꞌuꞌj y icꞌo jeꞌ paralíticos. Y quinojiel xaꞌruꞌon sanar ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y chirij ri Jesús can iqꞌuiy vinak ri xaꞌa ri aj-chireꞌ Galilea, ri xaꞌpa ri pa tak tanamet ri icꞌo Decápolis, ri xaꞌpa Jerusalén, ri xaꞌpa Judea, y ri xaꞌpa jucꞌan chic ruchiꞌ ri río Jordán. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y antok ri Jesús xaꞌrutzꞌat chi iqꞌuiy vinak quimaluon-quiꞌ, jajaꞌ xjotie-el paroꞌ ri chꞌiti juyuꞌ, y xtzꞌuye-ka. Y ri ru-discípulos xquimol-quiꞌ riqꞌuin cierca. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y ri Jesús ncaꞌrutijuoj ri vinak, y nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Can jaꞌal caꞌquicuot ri niquinaꞌ chi puobra ri qui-espíritu choch ri Dios, ruma quichin ijejeꞌ ri reino ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Can jaꞌal caꞌquicuot ri ntuokꞌ cánima choch ri Dios, ruma ri Dios xcaꞌruꞌon consolar. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Can jaꞌal caꞌquicuot ri manak-oc quikalien niquinaꞌ pa cánima, ruma xtuoc quichin ri roch-ulief como herencia. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Can jaꞌal caꞌquicuot ri ninem y nicꞌat cánima chi niquicꞌuaj jun utzulaj cꞌaslien choch ri Dios, ruma ri Dios xtuyaꞌ nojiel chica chi ninuoj ri cánima. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Can jaꞌal caꞌquicuot ri niquijoyovaj quivach nicꞌaj chic vinak, ruma ri Dios xtujoyovaj jeꞌ quivach ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Can jaꞌal caꞌquicuot ri sak cánima, ruma ijejeꞌ xtiquitzꞌat roch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Can jaꞌal caꞌquicuot ri niquiꞌan chi niqꞌuis ri ayoval, ruma xtiꞌeꞌx chica chi i-ralcꞌual ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Can jaꞌal caꞌquicuot ri quicꞌuan jun choj cꞌaslien y rumareꞌ niquikꞌasaj sufrimiento pa quikꞌaꞌ nicꞌaj chic; ruma quichin ijejeꞌ ri reino ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Can jaꞌal quixquicuot ixreꞌ ri itziel nquixtzꞌiet y niꞌeꞌx nojiel clase chi tzij chiva, y nitzꞌak tzij chivij vuma inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Quixtzeꞌn y quixquicuot, ruma nem ri rucꞌaxiel ri xtiyoꞌx chiva chicaj. Ruma incheꞌl ri sufrimiento ri ntikꞌasaj ixreꞌ vacame, quireꞌ jeꞌ xquikꞌasaj ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ixreꞌ ix incheꞌl atzꞌan chiquivach ri vinak ri icꞌo choch-ulief. Pero xa ri atzꞌan niqꞌuis-el ri rutzayal, ¿chica ta cꞌa niyoꞌn chic rusavuor? Xa man jun chic nicꞌatzin, xa nicꞌak-el chi niquixakꞌ can ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ixreꞌ ix incheꞌl ri luz chiquivach ri vinak ri icꞌo choch-ulief y jaꞌal nquixkꞌalajin, incheꞌl nikꞌalajin-pa jun tanamet ri cꞌo paroꞌ jun juyuꞌ y manak cheꞌl nravaj-riꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Antok nitzij jun lámpara, man niyoꞌx ta chuxieꞌ jun cajuon; antok nitzij jun lámpara, chicaj niyoꞌx-ve chi nuyaꞌ sakil pa quiveꞌ quinojiel ri icꞌo pa jay. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quireꞌ tibꞌanaꞌ ixreꞌ jeꞌ chiquivach ri vinak; can tiyaꞌ sakil incheꞌl jun luz chi quireꞌ antok ri vinak niquitzꞌat chi ixreꞌ otz ntiꞌan, can xtiquiyaꞌ rukꞌij ri Itataꞌ ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man tiꞌan pensar chi inreꞌ xipa chi niꞌan man jun rakalien cha ri ley richin ri Moisés, y niꞌan jeꞌ quireꞌ cha ri tzꞌibꞌan can cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo; man ruma ta reꞌ xipa. Inreꞌ xipa chi niꞌan cumplir. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Can ketzij niꞌej chiva chi nojiel ri tzꞌibꞌan chupan ri ley, can xcaꞌbꞌanataj-na-ve. Ri roch-ulief y ri rocaj can xcaꞌqꞌuis. Pero ri tzꞌibꞌan can chupan ri ley, man jun letra choj xtakꞌax, xa xtuꞌon cumplir nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xa chica-na vinak ri man nrajoꞌ ta nuꞌon ri nuꞌej chupan ri ley, mesque jun tzij ri man can ta rakalien, y can quireꞌ mismo nucꞌut chiquivach nicꞌaj chic vinak chi man tiquiꞌan ri nuꞌej ri tzij reꞌ, ri nibꞌano quireꞌ xtiꞌan chꞌuteꞌn cha chupan ri reino ri cꞌo chicaj. Pero ri nibꞌano nojiel ri nuꞌej chupan ri ley y quireꞌ mismo nucꞌut chiquivach nicꞌaj chic vinak, chi tiquibꞌanaꞌ ri nuꞌej ri ley, can xtiꞌan nem cha chupan ri reino ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Y mareꞌ ixreꞌ nicꞌatzin chi más ta choj ri icꞌaslien choch ri quicꞌaslien ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos. Ruma xa man quireꞌ ta ri icꞌaslien, man xquixuoc ta chupan ri reino ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Ixreꞌ ivaxan jaꞌal ri xꞌeꞌx chica ri vinak ri xaꞌcꞌujieꞌ ojier can tiempo: Man caquimisan; y chica-na ri nuquimisaj jun, can tiꞌan juzgar. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero inreꞌ niꞌej: Chica-na ri nipa royoval chirij jun chic vinak, can nuꞌon ruchꞌoꞌj, y can tiꞌan juzgar. Y chica-na jeꞌ ri nuꞌej cha jun chic: Nacanic, can tucꞌuax chiquivach ri autoridades richin ri tanamet chi tiꞌan juzgar. Y chica-na ri nuꞌej cha jun vinak: Tacatic, can niꞌa chupan ri infierno, ri kꞌakꞌ ri man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Mareꞌ, vi xa atreꞌ atcꞌo chic apa choch ri altar richin nayaꞌ can ri av-ofrenda cha ri Dios y ja nalka pan aveꞌ chi atreꞌ cꞌo jun kax itziel abꞌanun cha jun chic; ");
INSERT INTO cakSNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tayaꞌ can ri av-ofrenda choch ri altar y caꞌin riqꞌuin ri jun reꞌ, y tabꞌanaꞌ ri paz riqꞌuin chi quireꞌ manak ayoval chiꞌicajol. Cꞌajareꞌ catzalaj chic pa y tayaꞌ cha ri Dios ri av-ofrenda. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Cacꞌujieꞌ de acuerdo riqꞌuin ri nibꞌano acusar avichin, otz xa cꞌa ja at-bꞌanak pa bꞌay. Ruma xa man naꞌan ta quireꞌ, ri nibꞌano acusar avichin xcarujach pa rukꞌaꞌ ri juez, y ri juez xcarujach-el pa rukꞌaꞌ ri ache ri nichajin ri cárcel chi ncarutzꞌapij pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y can ketzij niꞌej, chi man ncatiel ta pa pa cárcel, hasta cꞌa xtatzoliej ri último centavo ri choj cha abꞌanun-ve acꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ixreꞌ ivaxan jaꞌal ri xꞌeꞌx ojier can: Ri at-cꞌulan, man tavucꞌuaj-aviꞌ riqꞌuin jun chic. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero inreꞌ niꞌej: Xa cꞌo jun ache nutzꞌat jun ixok y nurayij roch pa ránima; ya xuꞌon pecado riqꞌuin ri ixok reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Mareꞌ, xa ri anakꞌavach derecha nibꞌano chava chi ncatzak, más otz tavalasaj-el y tacꞌaka-el. Ruma más otz manak jun anakꞌavach que niꞌa nojiel ri a-cuerpo chupan ri infierno. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Y xa ri akꞌaꞌ derecha nibꞌano chava chi ncatzak, más otz takupij-el y tacꞌaka-el. Ruma más otz manak jun akꞌaꞌ que niꞌa nojiel ri a-cuerpo chupan ri infierno. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y xꞌeꞌx jeꞌ ojier can: Ri ache ri man nrajoꞌ ta chic ri raxjayil y nujach-riꞌ riqꞌuin, tubꞌanaꞌ jun carta ri pacheꞌ nuꞌej-ve chi nujach-riꞌ riqꞌuin, y tuya-el cha ri raxjayil. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero inreꞌ niꞌej: Ri ache ri nujach-riꞌ riqꞌuin ri raxjayil, pero man ruma ta ri ixok rucꞌuan-riꞌ riqꞌuin jun chic ache; ri ache reꞌ nuꞌon chi ri raxjayil nuꞌon pecado choch ri Dios xa niꞌa riqꞌuin jun chic ache, y ri ache ri nicꞌulieꞌ riqꞌuin ri ixok ri jachuon-el, can nuꞌon jeꞌ pecado choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ixreꞌ jaꞌal ivaxan jeꞌ ri xꞌeꞌx chica ri vinak ri xaꞌcꞌujieꞌ ojier can tiempo; chi man tiquicꞌax quitzij, xa can tiquibꞌanaꞌ cumplir ri xquiꞌej, ruma choch ri Ajaf Dios xquiꞌan-ve jurar. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero inreꞌ niꞌej chiva: Man jun bꞌay tiꞌan jurar; ni por ri rocaj, ruma chireꞌ cꞌo-ve ri ru-trono ri Dios; ");
INSERT INTO cakSNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ni por ri roch-ulief, ruma chireꞌ nuya-ve ri rakan ri Dios; ni por ri tanamet Jerusalén, ruma ri tanamet reꞌ richin ri Namalaj Rey; ");
INSERT INTO cakSNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ni por ri ijaluon tiꞌan jurar; ruma ixreꞌ man nquixtiquir ta ntiꞌan sak o xak cha jun iveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mareꞌ nojiel ri ntiꞌej, xa tiꞌej sí o tiꞌej ni; ruma xa ntiꞌan jurar, man otz ta, ruma xa riqꞌuin ri itziel nipa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ivaxan jaꞌal ri xꞌeꞌx ojier can, chi ri nalasan-el jun nakꞌaroch jun chic vinak, quireꞌ jeꞌ mismo tiꞌan cha jajaꞌ. Y ri nalasan-el jun roray jun chic vinak, can quireꞌ jeꞌ mismo tiꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero inreꞌ niꞌej chiva: Man tiꞌan rucꞌaxiel cha ri nibꞌano itziel chiva. Xa cꞌo jun nuyaꞌ jutzꞌaj kꞌaꞌ cha ri akꞌoꞌtz derecha, xa tayaꞌ chic apa ri jun chic lado choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y xa cꞌo jun ri ncarucꞌuaj pa juzgado ruma nrajoꞌ numaj-el jun atziak, can tayaꞌ cha chi nucꞌuaj, y can tayaꞌ jeꞌ cha ri a-capa ri akꞌuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Y xa cꞌo jun ri ncaruꞌon obligar chi navucꞌuaj ri rakaꞌn jun kilómetro, xa can tavucꞌuaj ri akaꞌn jun chic kilómetro más. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y xa cꞌo jun cꞌo nucꞌutuj chava, tayaꞌ cha ri nrajoꞌ. Y xa cꞌo jun nucꞌutuj jun kax pa kajic chava, can taya-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Ivaxan jaꞌal ri xꞌeꞌx ojier can. Ri tzij reꞌ nuꞌej: Tavajoꞌ ri a-prójimo y tatzꞌataꞌ itziel ri itziel ncarutzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero inreꞌ niꞌej chiva: Quiꞌivajoꞌ ri iv-enemigos; ticꞌutuj cha ri Dios chi caꞌrubꞌanaꞌ bendecir ri vinak ri nquixquiꞌan maldecir; tibꞌanaꞌ otz chica ri itziel nquixquitzꞌat; y tibꞌanaꞌ orar pa qui-cuenta ri ncaꞌyakꞌuon ivichin y ri ncaꞌbꞌano perseguir ivichin, ");
INSERT INTO cakSNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","richin quireꞌ nikꞌalajin chi ixreꞌ ix ralcꞌual ri Itataꞌ ri cꞌo chicaj. Ruma jajaꞌ can otz quiqꞌuin quinojiel. Nuꞌon chi ntiel-pa ri kꞌij pa quiveꞌ ri otz quicꞌaslien y pa quiveꞌ ri itziel quicꞌaslien, y nuya-pa jeꞌ ri jobꞌ pa quiveꞌ ri choj quicꞌaslien, y pa quiveꞌ ri man choj ta quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ruma xa ja ri ncaꞌjoꞌn ivichin, xa jareꞌ nquiꞌvajoꞌ, ¿cꞌo came rucꞌaxiel xtiyoꞌx chiva? ¿Man quireꞌ ta came niquiꞌan ri maloy-impuestos? ");
INSERT INTO cakSNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y xa joꞌc quiqꞌuin ri iv-hermanos jaꞌal ntiꞌan saludar-iviꞌ, ¿chica otz nitzꞌiet iviqꞌuin? ¿Man quireꞌ ta came niquiꞌan ri man cataꞌn ta roch ri Dios? ");
INSERT INTO cakSNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ixreꞌ can choj tibꞌanaꞌ riqꞌuin nojiel ri ntiꞌan, incheꞌl ri Itataꞌ ri cꞌo chicaj; jajaꞌ can choj riqꞌuin nojiel ri nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Can tibꞌanaꞌ cuenta-iviꞌ jaꞌal, man tiꞌan chiquivach ri vinak chi ntitoꞌ jun, joꞌc chi nquixquitzꞌat chi ixreꞌ can ntiꞌan ri nrajoꞌ ri Dios. Y xa quireꞌ xtiꞌan, ri Itataꞌ ri cꞌo chicaj can man jun rucꞌaxiel xtuyaꞌ chiva rumareꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Antok ixreꞌ ntitoꞌ jun puobra, man tixupuj jun trompeta chi quireꞌ quinojiel vinak nicaꞌxaj, incheꞌl niquiꞌan ri caꞌyeꞌ quipalaj. Ijejeꞌ quireꞌ niquiꞌan pa tak sinagogas y pa tak bꞌay, ruma nicajoꞌ chi niꞌeꞌx chica chi otz niquiꞌan. Can ketzij niꞌej chiva chi ri ncaꞌbꞌano quireꞌ, ya xyoꞌx rucꞌaxiel chica nojiel ri xquiꞌan, ruma xyoꞌx quikꞌij cuma ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Y antok ixreꞌ ntiyaꞌ limosna, man tiꞌan chiquivach ri vinak, ");
INSERT INTO cakSNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","chi quireꞌ ri ntiyaꞌ man jun chic ninaꞌien. Pero ri Itataꞌ ri cꞌo chicaj can nutzꞌat ri otz ri ntiꞌan pan aval, rumareꞌ can xtuyaꞌ rucꞌaxiel chiva. Y can chiquivach ri vinak xtuꞌon quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Antok ntiꞌan orar, man tiꞌan incheꞌl niquiꞌan ri vinak ri caꞌyeꞌ quipalaj. Ruma ijejeꞌ altíra nika chiquivach ncaꞌpiꞌieꞌ pa tak sinagogas, y pa tak xiquína antok niquiꞌan orar, chi ncaꞌtzꞌiet cuma ri vinak. Can ketzij niꞌej chiva, chi ri ncaꞌbꞌano quireꞌ, ya xyoꞌx rucꞌaxiel chica nojiel ri xquiꞌan, ruma xyoꞌx quikꞌij cuma ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero antok atreꞌ naꞌan orar, catuoc pan a-cuarto y tatzꞌapij ruchiꞌ ri a-cuarto y tabꞌanaꞌ orar cha ri Atataꞌ ri cꞌo chicaj; y jajaꞌ nutzꞌat ri naꞌan pan aval, y xtuyaꞌ rucꞌaxiel chava, y can chiquivach ri vinak xtuꞌon quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Y antok ixreꞌ ntiꞌan orar, man tiꞌan repetir qꞌuiy mul ri mismo tzij, incheꞌl niquiꞌan ri vinak ri man cataꞌn ta roch ri Dios. Ruma ijejeꞌ niquiꞌan pensar chi ri Dios ncaꞌraꞌxaj ruma niquiꞌan repetir qꞌuiy tzij chupan ri qui-oraciones. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Antok ntiꞌan orar, man tiꞌan incheꞌl niquiꞌan ri vinak ri man cataꞌn ta roch ri Dios. Ruma ri Itataꞌ ri cꞌo chicaj can rataꞌn chic ri chica nicꞌatzin chiva, antok cꞌa majaꞌ ticꞌutuj cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Antok ixreꞌ xtiꞌan orar, tiꞌej cava: Katataꞌ Dios ri atcꞌo chila chicaj, quinojiel ta ri vinak xtiquiyaꞌ akꞌij y nem xtiquiꞌan cha ri santo abꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y talka cꞌa ri kꞌij antok atreꞌ ri xcabꞌano reinar. Y ja ta ri navajoꞌ atreꞌ, ja ta reꞌ ri tibꞌanataj vaveꞌ ri choch-ulief, incheꞌl niquiꞌan ri icꞌo aviqꞌuin chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y tayaꞌ cꞌa ri ka-simíta ri nicꞌatzin chika kꞌij-kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y tabꞌanaꞌ perdonar ri ka-pecados ri nakaꞌan chavach, incheꞌl ncaꞌkaꞌan perdonar ojreꞌ ri niquiꞌan itziel chika. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man tayaꞌ lugar chi ri itziel nuꞌon chika chi nkutzak. Can kojacaloꞌ choch, ruma atreꞌ ri atcꞌo pa kaveꞌ, cꞌo a-poder, y cꞌo akꞌij richin nojiel tiempo. Amén. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Xa ixreꞌ ntiꞌan perdonar ri vinak ri niquiꞌan itziel chiva, ri Itataꞌ ri cꞌo chicaj nquixruꞌon jeꞌ perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Y xa man ntiꞌan ta perdonar ri vinak ri itziel niquiꞌan chiva, ri Itataꞌ ri cꞌo chicaj man xquixruꞌon ta jeꞌ perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Antok ixreꞌ ntiꞌan ayuno, man tiꞌan incheꞌl niquiꞌan ri caꞌyeꞌ quipalaj; ruma ijejeꞌ niquicꞌut-quiꞌ chi can ncaꞌbꞌisuon, xa ruma nicajoꞌ chi ncaꞌtzꞌiet chi niquiꞌan ayuno. Can ketzij niꞌej chiva, chi ri ncaꞌbꞌano quireꞌ, ya xyoꞌx rucꞌaxiel chica nojiel ri xquiꞌan, ruma xyoꞌx quikꞌij cuma ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero antok ixreꞌ ntiꞌan ayuno, man ticꞌut-iviꞌ chi jareꞌ ntiꞌan, xa can tichꞌajaꞌ otz ri ipalaj, y tiyaꞌ bꞌaꞌ akꞌuon chirij ri iveꞌ y jaꞌal tijicaꞌ; ");
INSERT INTO cakSNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","chi quireꞌ, man kꞌalaj ta chiquivach ri vinak chi ntiꞌan ayuno. Y ri Itataꞌ ri cꞌo chicaj can nutzꞌat ri ntiꞌan pan aval, jajaꞌ can xtuyaꞌ chiva ri rucꞌaxiel, y can chiquivach ri vinak xtuꞌon quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man tiꞌan bꞌayomal vaveꞌ choch-ulief, ruma nichocoper y nipuser-ka, y icꞌo jeꞌ alakꞌomaꞌ ri niquilakꞌaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sino tibꞌanaꞌ ibꞌayomal chicaj, chireꞌ man nichocoper ta y man nipuser ta jeꞌ, y man jun jeꞌ alakꞌomaꞌ ncaꞌlakꞌan-el y ncaꞌlasan-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ruma pacheꞌ cꞌo-ve ri ibꞌayomal, chireꞌ nicꞌujie-ve jeꞌ ri ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri anakꞌavach jareꞌ ri lámpara richin ri a-cuerpo. Y xa ri anakꞌavach otz, nojiel ri a-cuerpo cꞌo pa sakil. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero xa ri anakꞌavach man otz ta, nojiel ri a-cuerpo cꞌo pa kꞌakuꞌn. Rumareꞌ, xa ri sakil ri ruyoꞌn ri Dios pan ivánima xa xticꞌaxtaj, can xtikꞌalajin-pa chi atcꞌo pa kꞌakuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man jun nicovin nuꞌon servir icaꞌyeꞌ rajaf, ruma xa nrajoꞌ ri jun rajaf, itziel nutzꞌat ri jun chic. Y xa nunimaj rutzij ri jun, man nitiquir ta nuꞌon quireꞌ riqꞌuin ri jun chic. Quireꞌ jeꞌ, manak cheꞌl chi jun nuꞌon ri nrajoꞌ ri Dios ri xa bꞌanak ránima chirij ri bꞌayomal. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rumareꞌ inreꞌ niꞌej chiva: Man tichꞌujirisaj-iviꞌ ruma ri chica nicꞌatzin chiva kꞌij-kꞌij, chica ntitej o chica ntikun, ni por ri i-cuerpo chi chica itziak ri nticusaj. ¿Man ja ta came ri icꞌaslien más rakalien choch ri ntitej y ri i-cuerpo más rakalien choch ri itziak? ");
INSERT INTO cakSNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Quiꞌitzꞌataꞌ ri chicop ri cꞌo quixicꞌ; man ncaꞌtico ta, y manak niquiꞌan cosechar, ni manak jeꞌ quicꞌujay chi niquiyac. Pero ijejeꞌ ncaꞌvaꞌ, ruma ja ri Itataꞌ ri cꞌo chicaj ncaꞌtzuku. ¿Man ivakalien ta came ixreꞌ más que chiquivach ijejeꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Cꞌo came jun chivach ixreꞌ ri nitiquir nuꞌon chi niqꞌuiy ta chic nicꞌaj vara ri rakan, mesque nuchꞌujirisaj-riꞌ chi nuꞌon? ");
INSERT INTO cakSNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y karruma ixreꞌ ntichꞌujirisaj-iviꞌ ruma ri itziak? Quiꞌitzꞌataꞌ ri cotzꞌeꞌj lirio ri icꞌo pa kꞌayis, antok ncaꞌqꞌuiy: Ijejeꞌ man ncaꞌsamaj ta, ni man ncaꞌcamuon ta chi niquiꞌan quitziak jaꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Pero niꞌej cꞌa chiva, chi ri rey Salomón ri xcꞌujieꞌ ojier can, mesque altíra rubꞌayomal y ruyuon jaꞌal tak tziak ri xucusaj, pero man jun bꞌay xucusaj ta jun rutziak incheꞌl nitzꞌiet jun lirio. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mesque ri kꞌayis man nilayuj ta, ruma jun kꞌij jaꞌal ranun, y jun chic kꞌij nichakej-ka y nicꞌak pa kꞌakꞌ, pero ri Dios can nuvak jaꞌal. Y xa ri Dios can nuvak jaꞌal, ¿man came nuyaꞌ ta nojiel chiva ixreꞌ mesque man can ta icukubꞌan icꞌuꞌx riqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mareꞌ man tichꞌujirisaj-iviꞌ ntiꞌej: ¿Chica nakatej, o chica nakakun, o chica katziak nakacusaj? ");
INSERT INTO cakSNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ruma ri vinak ri man cataꞌn ta roch ri Dios niquicanuj nojiel reꞌ. Pero ri Itataꞌ ri cꞌo chicaj can rataꞌn chic ri chica nicꞌatzin chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mareꞌ can ticanuj naꞌay ri ru-reino ri Dios y titijaꞌ ikꞌij ntivucꞌuaj jun choj cꞌaslien choch, y nojiel ri nicꞌatzin chiva, xtuyaꞌ chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ixreꞌ man tichꞌujirisaj-ka-iviꞌ chi chica rucꞌamun-pa ri chuaꞌk. Ruma ri chuaꞌk can cꞌo-ve chica rucꞌamun-pa. Basta ri kꞌij-kꞌij can cꞌo sufrimientos niquicꞌam-pa chika. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man quiꞌan juzgar ri vinak, chi quireꞌ man xtiꞌan ta quireꞌ chiva ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ruma xa ixreꞌ nquiꞌan juzgar ri vinak, quireꞌ xtiꞌan chiva ixreꞌ. Can incheꞌl ri ntiꞌan ixreꞌ chica ri vinak, quireꞌ xtiꞌan chiva ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Y karruma ja ri qꞌuin ri cꞌo pa roch ri av-hermano ri natzꞌat chaꞌnin, y man nanaꞌ ta ka-aviꞌ chi atreꞌ xa jun chieꞌ kꞌapal pan avach? ");
INSERT INTO cakSNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿O karruma naꞌej cha ri av-hermano: Tayaꞌ chi nivalasaj-el ri qꞌuin ri kꞌapal pan avach, y man nanaꞌ ta chi atreꞌ xa jun chieꞌ kꞌapal pan avach? ");
INSERT INTO cakSNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Atreꞌ xa caꞌyeꞌ apalaj! Tavalasaj-el naꞌay ri chieꞌ pan avach atreꞌ, chi quireꞌ kꞌalaj xcatzuꞌn y xcatiquir xtavalasaj-el ri qꞌuin ri cꞌo pa roch ri av-hermano. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ri can richin ri Dios, man tayaꞌ chica ri tzꞌeꞌ; y ri perlas, man tayaꞌ chiquivach ri ak. Ruma ri tzꞌeꞌ y ri ak, mesque jun kax altíra rakalien, choj ncaꞌkꞌax paroꞌ y cꞌo mul ncaꞌa chirij ri niyoꞌn reꞌ chica y niquicꞌux. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ticꞌutuj cha ri Dios ri nicꞌatzin chiva y jajaꞌ xtuya-pa chiva. Ticanuj y xtivil ri ntivajoꞌ. Ticꞌoscꞌa-apa ri ruchi-jay y xtijak chivach. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ruma xa jun nucꞌutuj cha ri Dios, jajaꞌ xtuya-pa cha ri nucꞌutuj. Xa jun nucanuj, can xtiril ri nucanuj. Y xa jun nucꞌoscꞌa-apa ri ruchi-jay, can xtijak choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Cꞌo came jun ache nuyaꞌ jun abꞌaj pa rukꞌaꞌ ri ralcꞌual, antok nucꞌutuj jun simíta cha? ");
INSERT INTO cakSNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O nuyaꞌ came jun cumatz pa rukꞌaꞌ, antok xa jun car nucꞌutuj cha? ");
INSERT INTO cakSNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mesque ixreꞌ itziel inoꞌj, pero man jun bꞌay ntiyaꞌ jun itziel kax chica ri ivalcꞌual. Ixreꞌ ja ri utzulaj tak kax ntiyaꞌ chica. ¿Cuánto más ri Itataꞌ ri cꞌo chicaj nuya-pa utzulaj tak kax chica ri ncaꞌcꞌutun cha? Y nojiel ri nuya-pa, can otz. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Incheꞌl ri ntivajoꞌ ixreꞌ chi ri vinak niquiꞌan chiva, quireꞌ jeꞌ tibꞌanaꞌ quiqꞌuin ijejeꞌ. Quireꞌ ri tzꞌibꞌan can chupan ri ley ri xuyaꞌ ri Dios cha ri Moisés. Quireꞌ jeꞌ quiꞌeꞌn can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quixuoc chupan ri puerta ri coꞌl-oc roch. Ruma nem roch ri puerta y ri bꞌay ri niꞌa richin ri camic, y can iqꞌuiy vinak ri ncaꞌuoc chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero coꞌl-oc roch ri puerta y coꞌl-oc roch ri bꞌay ri niꞌa richin ri cꞌaslien, y man iqꞌuiy ta ri ncaꞌilo richin. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tibꞌanaꞌ cuenta-iviꞌ chiquivach ri i-tzꞌakoy-tzij ri ncaꞌlka iviqꞌuin y niquiꞌej chi i-profetas. Ruma antok ncaꞌlka iviqꞌuin, can jaꞌal quicꞌaslien, incheꞌl i-ovejas. Pero antok nibꞌakꞌalajin-pa ri itziel tak kax ri cꞌo pa cánima, xa incheꞌl i-utif ruma altíra i-itziel. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Can xtivatamaj quivach jaꞌal riqꞌuin ri quicꞌaslien. ¿Acaso ri qꞌuix kꞌayis nuyaꞌ uvas o víquix? ");
INSERT INTO cakSNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jun utzulaj chieꞌ nuyaꞌ utzulaj tak roch, pero jun chieꞌ ri man otz ta, man otz ta roch ri nuyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Man jun utzulaj chieꞌ xtuyaꞌ ta itziel tak roch, y man jun chieꞌ ri man otz ta, xtuyaꞌ ta utzulaj tak roch. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y quinojiel chieꞌ ri man otz ta quivach niquiyaꞌ, ncaꞌkasas y ncaꞌyoꞌx pa kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Mareꞌ, can xtivatamaj quivach jaꞌal riqꞌuin ri quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Man quinojiel ta ri ncaꞌeꞌn chuva: Ajaf, Ajaf, xcaꞌuoc chupan ri reino ri cꞌo chicaj. Ri xcaꞌuoc chireꞌ, xa ja ri niquiꞌan riqꞌuin nojiel cánima ri nrajoꞌ ri Nataꞌ Dios ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupan ri kꞌij antok inreꞌ xcaꞌnꞌan juzgar ri vinak, iqꞌuiy ri xtiquiꞌej chuva: Ajaf, Ajaf, ojreꞌ pan abꞌeꞌ atreꞌ xkatzijuoj ri ruchꞌabꞌal ri Dios, pan abꞌeꞌ atreꞌ xaꞌkalasaj-el itziel tak espíritus y pan abꞌeꞌ atreꞌ xaꞌkaꞌan qꞌuiy milagros, xcaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero inreꞌ xtinꞌej chica: Inreꞌ man vataꞌn ta ivach. Quixiel-el viqꞌuin, ruma ixreꞌ joꞌc itziel tak kax ri ntiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y chica-na vinak ri nraꞌxaj ri nutzij y nuꞌon ri niꞌej inreꞌ, can junan riqꞌuin jun ache ri altíra runoꞌj; jajaꞌ xuꞌon ri rachuoch paroꞌ abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xpa cꞌa ri jobꞌ, y xaꞌpa ríos y cakꞌiekꞌ chirij ri jay reꞌ, pero man xtzak ta, ruma ri ru-cimiento ri jay reꞌ paroꞌ abꞌaj xyoꞌx-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Pero chica-na ri joꞌc nraꞌxaj ri niꞌej inreꞌ y man nuꞌon ta ri niꞌej cha, junan riqꞌuin jun ache nacanic ri xuꞌon ri rachuoch pa sanayeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xpa ri jobꞌ, y xaꞌpa ríos y cakꞌiekꞌ chirij ri jay reꞌ y ja xtzak y xvuluvuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y antok ri Jesús xtanie-ka chi nichꞌoꞌ, ri vinak ri xaꞌcꞌaxan richin, can xaꞌchapataj ruma ri tzij ri xcaꞌxaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ruma antok ncaꞌrutijuoj, can kꞌalaj chi can cꞌo autoridad pa rukꞌaꞌ y man incheꞌl ta ri achiꞌaꞌ escribas. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y antok ri Jesús kajnak chic pa paroꞌ ri chꞌiti juyuꞌ, can iqꞌuiy vinak xaꞌa chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y cꞌo jun ache niyavaj riqꞌuin ri yabꞌil lepra, xalka choch ri Jesús, ja xxuquie-ka choch y xulucubꞌa-ka ri rujaluon cꞌa pan ulief y xuꞌej cha: Ajaf, xa navajoꞌ, cꞌo cheꞌl nquinaꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ri Jesús ja xuyuk-apa ri rukꞌaꞌ y xutzꞌom-apa ri ache y xuꞌej cha: Nivajoꞌ chi ncacꞌachoj. Tiqꞌuis-el ri yabꞌil reꞌ chavij, xchaꞌ cha. Y joꞌc xuꞌej quireꞌ ri Jesús, ja xqꞌuis-el ri yabꞌil lepra chirij ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Y ri Jesús xuꞌej cha: Man tatzijuoj chica ri vinak ri xbꞌanataj aviqꞌuin, choj caꞌin, acꞌutu-aviꞌ choch ri sacerdote, y tayaꞌ ri ofrenda ri nuꞌej chupan ri ru-ley ri Moisés, chi quireꞌ nikꞌalajin chiquivach chi at otz chic vacame, xcha-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Antok ri Jesús xuoc pa tanamet Capernaum, xalka jun capitán riqꞌuin y xucꞌutuj jun favor cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Quireꞌ xuꞌej ri capitán: Ajaf, ri nu-esclavo cꞌo chivachuoch, catzꞌol choch ruchꞌat ruma paralítico ru-cuerpo. Y altíra nuꞌon sufrir rumareꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Y ri Jesús xuꞌej cha ri capitán: Inreꞌ nquiꞌa y xtinꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y ri capitán xuꞌej chic apa cha ri Jesús: Ajaf, atreꞌ cꞌo akꞌij, y rumareꞌ man nucꞌul ta chi ncatuoc pa vachuoch. Joꞌc taꞌej chi ticꞌachoj y ri nu-esclavo xtuꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ruma incheꞌl nubꞌanun inreꞌ, cꞌo jun ri nquibꞌano mandar. Y icꞌo soldados i-yoꞌn pa nukꞌaꞌ chi ncaꞌnꞌan mandar. Y antok niꞌej cha jun chi tiꞌa, ja niꞌa; y antok niꞌej cha jun chic chi tipa, ja nipa. Y antok niꞌej cha ri nu-esclavo chi tubꞌanaꞌ jun samaj, can nuꞌon, xchaꞌ ri capitán. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y antok ri Jesús xraꞌxaj ri xuꞌej ri capitán, can xchapataj y xuꞌej chica ri i-bꞌanak chirij: Can ketzij niꞌej chiva, chi man jun cꞌa israelita ri viluon ri rucukubꞌan rucꞌuꞌx viqꞌuin incheꞌl va ache va. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Can niꞌej cꞌa chiva chi can qꞌuiy vinak ri xcaꞌpa oriente y occidente ri in-quiniman. Ijejeꞌ xcaꞌbꞌatzꞌuyeꞌ riqꞌuin ri Abraham, ri Isaac, y ri Jacob pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero ri israelitas ri can quichin-ve ri ru-reino ri Dios, man xcaꞌuoc ta chic, xa xcaꞌlasas-el juviera y xcaꞌcꞌak chupan ri kꞌakuꞌn. Y chireꞌ xcaꞌuokꞌ y xtiquikꞌachꞌachꞌiej coray. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Cꞌajareꞌ ri Jesús xuꞌej-el cha ri capitán: Catzalaj chavachuoch. Ruma xanimaj, can tibꞌanataj incheꞌl navajoꞌ, xcha-el cha. Y ri ru-esclavo ri capitán reꞌ, can ja xuꞌon sanar ri misma huora reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y antok xalka ri Jesús chirachuoch ri Pedro, xutzꞌat chi ri rujitieꞌ ri Pedro catzꞌol choch ruchꞌat ruma cꞌo cꞌatan chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpa jajaꞌ, xutzꞌom rukꞌaꞌ y ja xqꞌuis-el ri cꞌatan chirij. Ri ixok reꞌ xpalaj-pa, y xaꞌrutzuk ri Jesús y ri i-bꞌanak riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Y antok xcokꞌa-ka, iqꞌuiy vinak ri cꞌo itziel tak espíritus quiqꞌuin xaꞌcꞌamar-pa choch ri Jesús, chi ncaꞌralasaj-el ri itziel tak espíritus quiqꞌuin. Y jajaꞌ, riqꞌuin ri tzij ri xuꞌej, ja xaꞌralasaj-el ri itziel tak espíritus, y quinojiel jeꞌ ri ncaꞌyavaj xaꞌruꞌon sanar; ");
INSERT INTO cakSNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","chi quireꞌ nuꞌon cumplir ri ruꞌeꞌn can ri profeta Isaías. Quireꞌ ruꞌeꞌn can: Jajaꞌ mismo xalasan-el nojiel ri kayabꞌil, y xucꞌuaj nojiel kakꞌaxomal. Quireꞌ ruꞌeꞌn can. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Antok ri Jesús xutzꞌat chi iqꞌuiy vinak niquimol-apa-quiꞌ riqꞌuin, ja xuꞌej chica ri ru-discípulos chi ncaꞌa jucꞌan chic ruchiꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y cꞌo jun ache escriba xalka riqꞌuin ri Jesús y xuꞌej cha: Maestro, inreꞌ nivajoꞌ nquiꞌa aviqꞌuin ri pacheꞌ na ri ncaꞌa-ve, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ri Jesús xuꞌej cha: Ri utif cꞌo quijul pacheꞌ ncaꞌcꞌujie-ve; y quireꞌ jeꞌ ri chicop ri cꞌo quixicꞌ, cꞌo quisuoc. Pero ri Xtak-pa chicaj chi xalax chiꞌicajol, can man jun pacheꞌ nuxlan-ve jubꞌaꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Y jun chic ru-discípulo ri Jesús xuꞌej cha: Ajaf, tayaꞌ permiso chuva chi naꞌay nimuk-na-el ri nataꞌ, y cꞌajareꞌ nquiꞌa chavij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ri Jesús xuꞌej cha: Atreꞌ joꞌ viqꞌuin. Tayaꞌ chi ri quiminak ncaꞌmuk cuma ri i-quiminak, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Y ri Jesús xuoc chupan ri barco, y ri ru-discípulos xaꞌa chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y jun arapienta xpa jun nem cakꞌiekꞌ, y ri yaꞌ nubꞌolkotila-riꞌ y naj nijotieꞌ chicaj y ri barco choj nisach chupan ri yaꞌ. Pero ri Jesús nivar. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y xaꞌpa ri discípulos, xquicꞌasuoj ri Jesús y xquiꞌej cha: ¡Ajaf, kojacaloꞌ, vacame nkucon! xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pero ri Jesús xuꞌej chica: ¿Karruma ixiꞌin-iviꞌ? ¿Man icukubꞌan ta icꞌuꞌx viqꞌuin cꞌa? Y jajaꞌ xpalaj-pa y xchꞌolin cha ri cakꞌiekꞌ y cha ri mar, y can xquinimaj ri rutzij. Ri cakꞌiekꞌ xqꞌuis-el ruchukꞌaꞌ, y xtanie-ka jeꞌ ri mar. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y ri discípulos xaꞌchapataj antok xquitzꞌat ri xuꞌon ri Jesús y niquiꞌej: ¿Chica cꞌa chi ache va chi ri cakꞌiekꞌ y ri mar can xaꞌniman cha? ");
INSERT INTO cakSNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y antok ri Jesús cꞌo jucꞌan chic ruchiꞌ ri mar, chireꞌ chupan ri lugar rubꞌinan Gadara, icꞌo icaꞌyeꞌ achiꞌaꞌ xaꞌlka riqꞌuin; y ri icaꞌyeꞌ achiꞌaꞌ reꞌ cꞌo itziel tak espíritus quiqꞌuin y ja ri cementerio ri acunak cachuoch. Y ruma altíra i-itziel, man jun vinak niꞌin chupan ri bꞌay ri nakꞌax chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri icaꞌyeꞌ achiꞌaꞌ reꞌ, riqꞌuin quichukꞌaꞌ xaꞌchꞌo-apa cha ri Jesús y xquiꞌej: ¿Chica navajoꞌ chika Jesús ri Rucꞌajuol ri Dios? ¿Karruma nkojachꞌujirisaj yan, ruma xa cꞌa majaꞌ talka ri tiempo? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y naj bꞌaꞌ ri pacheꞌ icꞌo-ve ijejeꞌ, iqꞌuiy ak ncaꞌvaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ri itziel tak espíritus ri icꞌo quiqꞌuin ri icaꞌyeꞌ achiꞌaꞌ xquicꞌutuj favor cha ri Jesús, y xquiꞌej cha: Xa nkojavalasaj-el, tayaꞌ permiso chika chi nkojuoc quiqꞌuin ri ak la, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xuꞌej chica: Quixꞌin cꞌa. Y ri itziel tak espíritus ja xaꞌiel-el y xaꞌuoc quiqꞌuin ri ak. Y quinojiel ri ak reꞌ jun-anin xaꞌbꞌaxulie-pa choch jun juyuꞌ can paꞌl-roch, y cꞌa chupan ri mar xaꞌbꞌaka-ve; y chireꞌ xaꞌjiekꞌ-ve quinojiel ri ak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y ri ncaꞌchajin quichin ri ak xaꞌnumaj, xaꞌa pa tanamet y xbꞌaquitzijuoj ri xbꞌanataj quiqꞌuin ri ak y ri xbꞌanataj jeꞌ quiqꞌuin ri icaꞌyeꞌ achiꞌaꞌ ri cꞌo itziel tak espíritus quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quinojiel ri vinak richin ri tanamet reꞌ xaꞌpa riqꞌuin ri Jesús y antok xquitzꞌat, xquicꞌutuj favor cha chi tiel-el chireꞌ chupan ri qui-lugar. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ri Jesús xuoc chupan jun barco y xꞌa jucꞌan chic ruchiꞌ ri mar, y xbꞌaka pa rutanamit. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y jareꞌ antok nicꞌaj achiꞌaꞌ xquicꞌam-pa jun ache ri paralítico ru-cuerpo, liꞌan-pa choch jun camilla, y xalquiyaꞌ choch ri Jesús. Y antok ri Jesús xutzꞌat chi quicukubꞌan quicꞌuꞌx riqꞌuin, ja xuꞌej cha ri ache ri paralítico ru-cuerpo: Valcꞌual, tiquicuot cꞌa avánima; ri a-pecados xaꞌan perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y icꞌo nicꞌaj achiꞌaꞌ escribas ri icꞌo-apa chireꞌ, xquiꞌan-ka pensar chirij ri Jesús: Va ache va can nuꞌon chi jajaꞌ ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Y ri Jesús can rataꞌn ri niquiꞌan pensar ri achiꞌaꞌ reꞌ, mareꞌ xuꞌej chica: ¿Karruma ntiꞌej itziel tak kax pan ivánima? ");
INSERT INTO cakSNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Chica ri más fácil, niꞌej: Ri a-pecados niꞌan perdonar, o niꞌej: Capalaj y caꞌin? ");
INSERT INTO cakSNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Vacame cꞌa, chi ntivatamaj chi ri Xtak-pa chicaj chi xalax chiꞌicajol can cꞌo poder riqꞌuin chi nuꞌon perdonar pecados, (jareꞌ antok ri Jesús xuꞌej cha ri ache paralítico): Capalaj, tavucꞌuaj ri a-camilla y caꞌin chavachuoch, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y ri ache ja xpalaj y xꞌa chirachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Y ri vinak ri quimaluon-apa-quiꞌ chireꞌ antok xquitzꞌat ri xbꞌanataj, can xaꞌchapataj. Y xquiyaꞌ rukꞌij ri Dios, ruma ruyoꞌn-pa namalaj poder chica nicꞌaj achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y antok ri Jesús nakꞌax, xutzꞌat jun ache rubꞌinan Mateo. Ri ache reꞌ tzꞌuyul choch jun chꞌacat chi numol ri impuestos ri ncaꞌtuoj can. Y ri Jesús xuꞌej cha: Joꞌ viqꞌuin. Y jajaꞌ xpalaj-pa ri pacheꞌ tzꞌuyul-ve y xꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y antok ri Jesús tzꞌuyul chirij ri mesa pa rachuoch ri Mateo, iqꞌuiy ri maloy-impuestos y nicꞌaj chic vinak ri niꞌeꞌx aj-bꞌanoy-pecado chica xaꞌtzꞌuye-apa chirij ri mesa, junan riqꞌuin ri Jesús y ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y ri achiꞌaꞌ fariseos ri xaꞌtzꞌato reꞌ, xquiꞌej chica ri ru-discípulos ri Jesús: ¿Karruma ri I-Maestro nivaꞌ quiqꞌuin ri maloy-impuestos y quiqꞌuin ri vinak ri aj-bꞌanoy-pecado niꞌeꞌx chica? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Antok ri Jesús xraꞌxaj ri niquiꞌej ri achiꞌaꞌ reꞌ, xuꞌej chica: Ri man ncaꞌyavaj ta man nicꞌatzin ta jun doctor chica, xa ja ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Inreꞌ man xipa ta chi ncaꞌnvayuoj ri choj quicꞌaslien choch ri Dios, xa ja ri cꞌo qui-pecados, chi niquiyaꞌ can ri qui-pecados y niquiꞌan ri nrajoꞌ ri Dios. Rumareꞌ quixꞌin y tivatamaj chica ntiel chi tzij: Inreꞌ más nika chinoch chi ntijoyovaj quivach ri vinak, que choch ri chicop ri nquiꞌquimisaj chi ntiyaꞌ chinoch. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Entonces ri ru-discípulos ri Juan el Bautista xaꞌlka riqꞌuin ri Jesús y xquiꞌej cha: Ojreꞌ nakaꞌan ayuno qꞌuiy mul. Y quireꞌ jeꞌ niquiꞌan ri achiꞌaꞌ fariseos. ¿Karruma ri a-discípulos atreꞌ man quireꞌ ta niquiꞌan? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Y ri Jesús xuꞌej chica: ¿Acaso otz came chi ncaꞌbꞌisuon ri i-bꞌanun invitar pa jun cꞌulubꞌic antok xa cꞌa cꞌo ri alaꞌ ri xcꞌulieꞌ chiquicajol? Pero xtalka ri kꞌij antok ri alaꞌ reꞌ xtalasas-el chiquicajol, cꞌajareꞌ xtiquiꞌan ayuno. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Man jun nucusaj jun cꞌojobꞌal cꞌacꞌacꞌ chi nucꞌojobꞌiej jun tziak ri xa tziaꞌk chic. Ruma ri cꞌojobꞌal cꞌacꞌacꞌ nucꞌol-riꞌ y nujicꞌ ri tziak y más nikꞌachꞌitaj-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y quireꞌ jeꞌ man jun nuya-ka cꞌacꞌacꞌ vino chupan jun tzꞌun yacbꞌal-yaꞌ ri xa tziaꞌk chic. Ruma xa quireꞌ niꞌan cha, ri tzꞌun xa nikꞌachꞌitaj y ja niqꞌuis-el ri vino chupan. Y ri tzꞌun jeꞌ man jun chic xticꞌatzin-ve. Pero chupan jun cꞌacꞌacꞌ tzꞌun yacbꞌal-yaꞌ, otz niyaquieꞌ cꞌacꞌacꞌ vino, ruma ri tzꞌun reꞌ cꞌa nuyuk-riꞌ jaꞌal y man nikꞌachꞌitaj ta. Ri vino niyaquieꞌ jaꞌal chupan. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y antok ri Jesús nutzijuoj nojiel reꞌ, cꞌo jun ache principal chiquicajol ri israelitas xbꞌaxuquieꞌ choch y xuꞌej: Ri numiꞌal cꞌa ja oc nicon-ka, pero catam-pa y tayaꞌ ri akꞌaꞌ paroꞌ, y nicꞌastaj chic pa, xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ri Jesús xpalaj y junan quiqꞌuin ri ru-discípulos xaꞌa chirij ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y cꞌo jun ixok ri cꞌo doce (cabꞌalajuj) junaꞌ ri ntiel ruquiqꞌuiel y man nitanieꞌ ta, ruma jun yabꞌil. Jajaꞌ xjiel-apa chirij ri Jesús y xutzꞌom-apa ri ruchi-rutziak; ");
INSERT INTO cakSNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ruma nuꞌej pa ránima: Xa ta riqꞌuin nitzꞌom-apa ri rutziak, ja niꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús can xunaꞌ y xtzuꞌn can chirij y xuꞌej cha: Numiꞌal, xacꞌachoj ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin. Man chic cabꞌisuon, xchaꞌ cha. Y ri ixok reꞌ can ja misma huora reꞌ xcꞌachoj. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y antok ri Jesús ntuoc-oc pa rachuoch ri ache ri principal, xutzꞌat chi ri vinak ncaꞌchꞌujuyan y icꞌo chic ri niquixupuj ri flautas. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jajaꞌ xuꞌej chica: Quixiel-el, ruma ri chꞌiti xtan xa man quiminak ta, xa nivar, xchaꞌ chica ri vinak. Pero ijejeꞌ xa xaꞌtzeꞌn chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y antok i-alasan chic el juviera ri vinak, ri Jesús xuoc-oc ri pacheꞌ cꞌo-ve ri chꞌiti xtan quiminak chic. Y xutzꞌom rukꞌaꞌ ri chꞌiti xtan y ja xcꞌastaj chic pa. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbꞌanataj chireꞌ, xꞌa rutzijoxic pa tak tanamet ri icꞌo chupan ri lugar reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y antok ri Jesús xiel-pa chireꞌ, icꞌo icaꞌyeꞌ muoy xaꞌa chirij y riqꞌuin quichukꞌaꞌ xaꞌchꞌoꞌ y xquiꞌej: ¡Tajoyovaj kavach atreꞌ ri at Rumáma can ri rey David! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Antok ri Jesús xbꞌaka pa jay ri pacheꞌ nicꞌujie-ve, ri icaꞌyeꞌ muoy xaꞌbꞌaka riqꞌuin. Y ri Jesús xucꞌutuj chica: ¿Can ntinimaj ixreꞌ chi inreꞌ nquicovin niꞌan chiva chi nquixtzuꞌn? xchaꞌ chica. Y ri icaꞌyeꞌ muoy xquiꞌej: Quireꞌ Ajaf, nakanimaj, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ri Jesús xutzꞌom-apa ri quinakꞌavach y xuꞌej chica: Ruma ixreꞌ xicukubꞌaꞌ icꞌuꞌx viqꞌuin, can tibꞌanataj cꞌa ri incheꞌl ntivajoꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y ijejeꞌ ja xaꞌtzuꞌn. Pero ri Jesús xuꞌon mandar chica: Ri xbꞌanataj iviqꞌuin, man jun ta vinak ninaꞌien. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero ijejeꞌ can joꞌc xaꞌiel-el chireꞌ, can ja xquitzꞌom rutzijoxic chupan nojiel ri lugar reꞌ ri xuꞌon ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y antok xaꞌiel-pa ri icaꞌyeꞌ achiꞌaꞌ reꞌ riqꞌuin ri Jesús, jareꞌ antok xcꞌamar-pa jun ache miem; quireꞌ rubꞌanun ruma cꞌo jun itziel espíritu riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y antok ri Jesús xralasaj-el ri itziel espíritu, ri ache miem ja xchꞌoꞌ. Y ri vinak can xaꞌchapataj y niquiꞌej: Man jun bꞌay katzꞌatuon chi quireꞌ nibꞌanataj vaveꞌ Israel, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ri achiꞌaꞌ fariseos niquiꞌej chirij ri Jesús: Ja ri quijaval ri itziel tak espíritus ri nibꞌano cha chi nitiquir ncaꞌralasaj ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Y ri Jesús xꞌa nojiel tanamet y aldeas, y ncaꞌrutijuoj ri vinak pa tak sinagogas, y nutzijuoj jeꞌ chica ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios. Y nuꞌon sanar nojiel roch yabꞌil ri ntuoc chica, y ncaꞌrucol cꞌa ri vinak choch nojiel kꞌaxomal. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y antok xaꞌrutzꞌat chi can iqꞌuiy ri vinak, xujoyovaj quivach, ruma quiyuon icꞌo y quiquiran-quiꞌ; can incheꞌl ri ovejas antok man jun ri nichajin quichin. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Y ri Jesús xuꞌej chica ri ru-discípulos: Can ketzij chi ri samaj can qꞌuiy, pero ri aj-samajiel xa man iqꞌuiy ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rumareꞌ ticꞌutuj cha ri Rajaf ri samaj chi caꞌrutaka-pa más aj-samajiel chupan ri rusamaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y ri Jesús xaꞌrayuoj ri i-doce (cabꞌalajuj) ru-discípulos y xuyaꞌ autoridad chica chi ncaꞌtiquir ncaꞌcalasaj itziel tak espíritus y chi niquiꞌan sanar nojiel roch yabꞌil y kꞌaxomal ri ntuoc chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jareꞌ quibꞌeꞌ ri doce (cabꞌalajuj) apóstoles: Ri naꞌay ja ri Simón ri niꞌeꞌx jeꞌ Pedro cha, y ri Andrés ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Simón. Ri Jacobo y ri Juan ri i-rucꞌajuol ri Zebedeo. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri maloy-impuestos, ri Jacobo ri rucꞌajuol ri Alfeo, ri Lebeo ri niꞌeꞌx jeꞌ Tadeo cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri Simón ri cꞌo quiqꞌuin ri achiꞌaꞌ ri niꞌeꞌx cananistas chica, y ri Judas Iscariote ri xjacho richin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y ja ri doce (cabꞌalajuj) reꞌ xaꞌrutak-el ri Jesús, y quireꞌ ri instrucciones ri xuꞌej-el chica: Man quixꞌa chupan quibꞌiey ri vinak ri man israelitas ta. Y man cꞌa quixuoc pa tak tanamet richin ri Samaria. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xa quixꞌin naꞌay quiqꞌuin ri israelitas, ri incheꞌl ri ovejas ri i-sachnak can. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y antok ix-bꞌanak, can titzijuoj ri ruchꞌabꞌal ri Dios. Tiꞌej cꞌa: Xa cierca chic cꞌo-ve-pa ri ru-reino ri Dios, quixchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Quiꞌbꞌanaꞌ sanar ri ncaꞌyavaj, y ri cꞌo ri yabꞌil lepra chiquij, tibꞌanaꞌ chica chi sak nuꞌon can ri qui-cuerpo. Quiꞌicꞌasuoj quiminakiꞌ, quiꞌivalasaj itziel tak espíritus. Ruma xa sipan chiva chi quireꞌ ntiꞌan, man ticꞌutuj ivajal ri ntiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Man cꞌa tivucꞌuaj miera ri bꞌanun cha oro, ni plata, ni cobre pa tak ximbꞌal-ipan. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ni man tivucꞌuaj i-buolsa antok nquixꞌa. Man tivucꞌuaj jun chic jal itziak; xa joꞌc ri icusan. Man tivucꞌuaj jun chic par ixajabꞌ, ni ichꞌameꞌy. Can man jun kax tivucꞌuaj. Ruma ri samajiel can nicꞌatzin chi nitzuk. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Y antok nquixbꞌaka chupan jun tanamet nem o chupan jun aldea, ticanuj jun vinak otz. Y pa rachuoch jajaꞌ quixcꞌujie-ve-ka, y cꞌajaꞌ antok nquixiel-pa chupan ri tanamet reꞌ, cꞌajareꞌ xtiyaꞌ can ri jay ri pacheꞌ xixcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y antok nquixuoc chupan ri jay reꞌ, quiꞌbꞌanaꞌ saludar ri icꞌo chupan. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Y xa otz chi nquixcꞌujie-ka chupan ri jay reꞌ, ri paz richin ri Dios can xtika cꞌa paroꞌ. Pero xa man otz ta, ri paz xa xtitzalaj-pa iviqꞌuin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y xa man nquixquiꞌan ta recibir y man nicajoꞌ ta nicaꞌxaj ri ruchꞌabꞌal ri Dios ri ntitzijuoj ixreꞌ chica, quixiel-pa chupan ri jay reꞌ o chupan ri quitanamit y titotaꞌ can ri pokolaj ri cꞌo pa tak ivakan chiquivach ri vinak reꞌ, chi quireꞌ ticatamaj chi man otz ta ri xquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Inreꞌ ketzij cꞌa niꞌej chiva, chi antok xtalka ri kꞌij richin ri juicio ri nuꞌon ri Dios, ri vinak richin ri tanamet pacheꞌ man xixꞌan ta recibir, más nem ri castigo ri xtika pa quiveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri aj-Sodoma y ri aj-Gomorra. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Vacame nquixtak-el, xa ix incheꞌl ovejas ri nquixbꞌaka chiquicajol vinak ri incheꞌl utif. Pero tibꞌanaꞌ incheꞌl nuꞌon ri cumatz; jajaꞌ chaꞌnin nunaꞌ antok cꞌo jun patanak. Y tibꞌanaꞌ jeꞌ incheꞌl nuꞌon jun paluomix, ruma jajaꞌ man jun itziel nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Can tibꞌanaꞌ cuenta-iviꞌ chiquivach ri vinak ri man otz ta nquixquitzꞌat. Ruma ijejeꞌ xquixquijach pa quikꞌaꞌ ri autoridades quichin ri tanamet y xquixquichꞌey jeꞌ pa tak sinagogas. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Y xquixquicꞌuaj chiquivach gobernadores y chiquivach reyes ruma iyoꞌn ivánima viqꞌuin, pero ixreꞌ xquixtiquir cꞌa xquinitzijuoj chiquivach ijejeꞌ y chiquivach jeꞌ ri vinak ri man israelitas ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Antok xquixquijach pa quikꞌaꞌ ri autoridades, man tiꞌan preocupar-iviꞌ ri chica xtiꞌej chica y ri chica tzij xticusaj chi nquixchꞌoꞌ chiquivach. Ruma chupan ri misma huora reꞌ, ri Dios xtuya-pa chiva ri tzij ri xtiꞌej-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ruma can ja ri Ru-Espíritu ri Itataꞌ ri cꞌo chicaj ri xtiyoꞌn chiva ri chica tzij ri ntiꞌej-apa. Y man ixreꞌ ta ri xquixchꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y chiquicajol ri quichakꞌ-quinimal-quiꞌ, jun chiquivach ijejeꞌ xtujach ri jun chic chi niquimisas, y ri tataꞌj xcaꞌquijach ri calcꞌual chi ncaꞌquimisas, y ri calcꞌual xcaꞌpalaj chiquij ri quitie-quitataꞌ y xcaꞌquijach chi ncaꞌquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Can quinojiel vinak, itziel xquixquitzꞌat ruma iyoꞌn ivánima viqꞌuin. Pero ri man xtitzalaj ta chirij y xtucochꞌ nojiel reꞌ hasta el fin, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y antok ri vinak chupan jun tanamet nquixquiꞌan perseguir, quixnumaj jun chic tanamet. Y can ketzij niꞌej chiva chi cꞌa majaꞌ quixakꞌax chupan nojiel tanamet ri icꞌo Israel, antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Man jun discípulo cꞌo más rukꞌij choch ri ru-maestro. Y man jun samajiel más nem choch ri rajaf. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jun discípulo tiquicuot ruma ntiel incheꞌl ri ru-maestro, y quireꞌ jeꞌ jun samajiel tiquicuot ruma ntiel incheꞌl ri rajaf. Xa chuva inreꞌ ri Tataꞌj chiꞌicajol niquiꞌej Beelzebú chuva, can más peor xtiquiꞌej chiva ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pero man tixiꞌij-iviꞌ chiquivach ri xcaꞌbꞌano quireꞌ chiva, ruma man jun kax ri man kꞌalaj ta, ri man ta xtibꞌakꞌalajin-pa. Y man jun kax ri avan-can, ri man ta xtinaꞌax. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nojiel ri niꞌej chiva pa kꞌakuꞌn, can tiꞌej pa sakil. Ri niꞌeꞌx chiva pa tak ixiquin, xa paroꞌ ivachuoch titzijuoj chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixiꞌij-iviꞌ chiquivach ri niquiquimisaj ri i-cuerpo, pero ri iv-espíritu man ncaꞌtiquir ta niquiquimisaj. Tixiꞌij-iviꞌ choch ri Jun ri nitiquir nuyaꞌ ri iv-espíritu y ri i-cuerpo pan infierno. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Man ncaꞌcꞌayix ta came caꞌyeꞌ chꞌitak chicop ri cꞌo quixicꞌ por jun len cajal? Y mesque ri chicop reꞌ manak-oc cajal, man jun chiquivach ijejeꞌ xtitzak ta pan ulief xa ri Itataꞌ ri cꞌo chicaj man nrajoꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y hasta ri iveꞌ i-jilan nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mareꞌ man tixiꞌij-iviꞌ; ixreꞌ más ivakalien que chiquivach iqꞌuiy chꞌitak chicop ri cꞌo quixicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Y chica-na ri man niqꞌuix ta nuꞌej chi in-runiman, inreꞌ jeꞌ man xquiqꞌuix ta xtinꞌej choch ri Nataꞌ ri cꞌo chicaj chi jajaꞌ vichin inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ri nuꞌej chi man in-runiman ta, inreꞌ jeꞌ xtinꞌan negar choch ri Nataꞌ ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man tiꞌan pensar chi inreꞌ xipa chi niyaꞌ paz ri choch-ulief. Man quireꞌ ta. Xa vuma inreꞌ xtipa ayoval. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Inreꞌ xipa richin chi ri alaꞌ xtipalaj chirij ri rutataꞌ; ri xtan xtipalaj chirij ri rutieꞌ; y quireꞌ jeꞌ ri alibꞌatz xtipalaj chirij ri ralitieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri itziel xcaꞌtzꞌato richin jun ri in-runiman inreꞌ, can ja mismo ri icꞌo riqꞌuin pa rachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ri más ncaꞌrajoꞌ ri rutie-rutataꞌ que chinoch inreꞌ, man nucꞌul ta chi ntuoc vichin. Ri más ncaꞌrajoꞌ ri ralcꞌual que chinoch inreꞌ, man nucꞌul ta chi ntuoc vichin. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ri man nutzꞌom ta y nucꞌuaj ri ru-cruz y niꞌa chuvij, man nucꞌul ta chi ntuoc vichin inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ri nrajoꞌ ri rucꞌaslien vaveꞌ ri choch-ulief, man xticolotaj ta. Pero ri jun, mesque niquimisas vuma inreꞌ, can xtiril ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ri jun cꞌa ri nquixruꞌon recibir ixreꞌ, can inreꞌ ri nquiruꞌon recibir; y ri xquiruꞌon recibir inreꞌ, can nuꞌon recibir ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ri jaꞌal nuꞌon recibir jun profeta, ruma can profeta, can junan rucꞌaxiel xtiyoꞌx cha riqꞌuin ri profeta. Y ri nuꞌon recibir jaꞌal jun ri choj rucꞌaslien choch ri Dios, ruma can choj rucꞌaslien choch ri Dios, can junan rucꞌaxiel xtiyoꞌx cha riqꞌuin ri choj rucꞌaslien choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y chica-na ri nuyaꞌ jun vaso yaꞌ chꞌichꞌ cha jun nu-discípulo ri manak-oc rukꞌij, can ketzij niꞌej chiva; chi can cꞌo rucꞌaxiel xtiyoꞌx cha. Quireꞌ ri xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y antok ri Jesús xuqꞌuis rubꞌixic ri instrucciones chica ri i-doce (cabꞌalajuj) ru-discípulos, jajaꞌ xꞌa nicꞌaj chic tanamet ri icꞌo chupan ri Israel, chi nucꞌut y nutzijuoj ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Antok ri Juan el Bautista cꞌo pa cárcel, xraꞌxaj chirij ri samaj ri nuꞌon ri Cristo. Mareꞌ xaꞌrutak-el icaꞌyeꞌ ru-discípulos riqꞌuin ri Jesús ");
INSERT INTO cakSNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chi xbꞌaquicꞌutuj cha: ¿Atreꞌ ri xtipa o nakayoꞌiej chic jun? ");
INSERT INTO cakSNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y ri Jesús xuꞌej chica: Quixꞌin y tiꞌej cha ri Juan ri xitzꞌat y ri xivaxaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ri muoy ncaꞌtzuꞌn; ri ncaꞌjacajot ncaꞌin, otz ncaꞌin; ri cꞌo ri yabꞌil lepra chiquij, ncaꞌcꞌachoj; ri man ncaꞌcꞌaxan ta, vacame ncaꞌcꞌaxan; ri quiminakiꞌ ncaꞌcꞌastaj-pa; y chica ri i-puobra nitzijos ri evangelio. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Y tiꞌej jeꞌ cha chi jun ri can rucukubꞌan rucꞌuꞌx viqꞌuin y man nquiruyaꞌ ta can, can jaꞌal tiquicuot, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y antok ijejeꞌ xaꞌa, ri Jesús xaꞌruꞌej utzulaj tak tzij chirij ri Juan el Bautista chiquivach ri vinak ri icꞌo chireꞌ. Y quireꞌ ri xuꞌej chica: ¿Chica ri xbꞌaꞌitzꞌataꞌ chupan ri lugar desierto? ¿Jun aj ri nisilos ruma ri cakꞌiekꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿O chica ri xbꞌaꞌitzꞌataꞌ chireꞌ? ¿Jun ache ri jaꞌal tak tziak rucusan? Ri achiꞌaꞌ ri niquicusaj jaꞌal tak tziak, xa pa tak cachuoch ri reyes ncaꞌcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Pero ¿chica ri xbꞌaꞌitzꞌataꞌ? ¿Jun profeta? Quireꞌ. Y ri Jesús xuꞌej chic chica: Pero más nem que choch jun profeta. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Y chirij cꞌa ri Juan nichꞌo-ve ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can, y nuꞌej: Inreꞌ xtintak jun ache naꞌay chavach, chi nuchojmij ri abꞌiey chavach. Quireꞌ nuꞌej ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Can ketzij niꞌej chiva: Chiquicajol ri profetas ri i-alaxnak choch-ulief, man jun más nem choch ri Juan el Bautista. Pero ri más coꞌl-oc chupan ri reino ri cꞌo chicaj, más nem choch ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Xa-jan antok xutzꞌom-pa samaj ri Juan el Bautista hasta vacame, ri vinak altíra nicajoꞌ ncaꞌuoc chupan ri reino ri cꞌo chicaj, can niquitej quikꞌij chi ncaꞌuoc, y ja ri can niquitej quikꞌij y riqꞌuin nojiel cánima nicajoꞌ ncaꞌuoc, jareꞌ ri xcaꞌuoc. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Quinojiel ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, can cꞌo xquiꞌej can chirij ri ru-reino ri Dios. Y quireꞌ jeꞌ bꞌeꞌn can chupan ri ru-ley ri Moisés. Pero cꞌa pa ru-tiempo ri Juan xbꞌanataj-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xa ixreꞌ ntivajoꞌ ntinimaj ri tzꞌibꞌan can, ri nuꞌej chi nipa ri Elías, xa chirij ri Juan ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Pero ¿choj-iqꞌuin cꞌa niꞌan comparar ri vinak richin ri tiempo vacame? Ri vinak reꞌ xa i-junan quiqꞌuin ri acꞌolaꞌ ri ncaꞌcꞌujieꞌ pa tak bꞌay, y ncaꞌsiqꞌuin ncaꞌchꞌoꞌ chiquivach antok ncaꞌtzꞌan, ");
INSERT INTO cakSNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","y niquiꞌej: Xkaxupuj flautas chivach y man xixxajo ta. Xkabꞌixaj bꞌix richin bꞌis chivach y man xixuokꞌ ta. Quireꞌ niquiꞌej ri acꞌolaꞌ chupan ri atzꞌanien. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ruma antok xalka ri Juan el Bautista, jajaꞌ man xutej ta utzulaj tak teꞌj ni man xukun ta jeꞌ vino. Y ixreꞌ ntiꞌej chi jajaꞌ cꞌo itziel espíritu riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y vacame xalka ri Xtak-pa chicaj chi xalax chiꞌicajol, nutej utzulaj tak teꞌj y nukun jeꞌ vino, y ixreꞌ ntiꞌej chi joꞌc vaꞌen nrajoꞌ, y ntiꞌej chi jun kꞌabꞌariel, qui-amigo ri maloy-impuestos y qui-amigo ri vinak ri aj-bꞌanoy-pecado. Pero ri runoꞌj ri Dios can kꞌalaj pa quicꞌaslien ri ncaꞌniman richin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Icꞌo tanamet pacheꞌ xuꞌon-ve qꞌuiy milagros ri Jesús. Pero ri vinak ri icꞌo chupan ri tanamet reꞌ man xtzalaj ta pa cánima riqꞌuin ri Dios chi niquiꞌan ri nrajoꞌ jajaꞌ. Rumareꞌ ri Jesús qꞌuiy kax xuꞌej can chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Jajaꞌ xuꞌej: ¡Juyeꞌ ivach ri ixcꞌo pa tanamet Corazín! ¡Juyeꞌ jeꞌ ivach ri ixcꞌo pa tanamet Betsaida! Ruma xa ta chupan ri tanamet Tiro y Sidón xaꞌan ta ri milagros ri xaꞌan chivach, ri icꞌo chireꞌ xtzalaj ta pa yan ri cánima riqꞌuin ri Dios y xquiꞌan ta ri nrajoꞌ jajaꞌ, quicusan ta chic tziak richin bꞌis, y quiyoꞌn ta chaj chiquij chi quireꞌ nitzꞌiet chi ncaꞌbꞌisuon. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero inreꞌ niꞌej chiva chi antok xtalka ri kꞌij richin ri juicio ri nuꞌon ri Dios, más nem ri castigo ri xtika pan iveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri aj-Tiro y ri aj-Sidón. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y ri icꞌo pa tanamet Capernaum niquiꞌan pensar chi ncaꞌa chicaj riqꞌuin ri Dios, pero xa man quireꞌ ta, xa cꞌa chupan ri infierno xcaꞌbꞌaka-ve. Ruma xa ta nojiel ri milagros ri xꞌan chiquivach ijejeꞌ, ja ta reꞌ xꞌan chiquivach ri aj-Sodoma, xquinimaj ta y man ta xaꞌqꞌuis. Xa cꞌa icꞌo ta vacame. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero inreꞌ niꞌej chiva chi antok xtalka ri kꞌij richin ri juicio ri nuꞌon ri Dios, ri icꞌo pa tanamet Capernaum más nem ri castigo ri xtika pa quiveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri aj-Sodoma. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y chupan ri tiempo reꞌ ri Jesús xuꞌej: Tiox bꞌaꞌ niyaꞌ chava Nataꞌ Dios, atreꞌ ri Rajaf ri rocaj y ri roch-ulief, ruma xavavaj ri utzulaj atzij chiquivach ri vinak ri niquinaꞌ chi qꞌuiy cataꞌn. Xa ja chiquivach ri vinak ri manak-oc cataꞌn, ri incheꞌl acꞌolaꞌ, ri xacꞌut ri utzulaj atzij. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can quireꞌ Nataꞌ Dios, ruma jareꞌ ri xavajoꞌ atreꞌ, xchaꞌ ri Jesús chupan ri ru-oración. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y jajaꞌ xuꞌej jeꞌ: Ri Nataꞌ Dios nojiel ruyoꞌn-pa pa nukꞌaꞌ. Y man jun chic taꞌmayuon in chica inreꞌ, xa joꞌc ri Nataꞌ. Y man jun jeꞌ taꞌmayuon chica ri Nataꞌ, xa joꞌc inreꞌ ri in Rucꞌajuol, y ri choj cha xtinvajoꞌ xtincꞌut-ve inreꞌ xtiratamaj chica ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixam-pa viqꞌuin ixvonojiel ri altíra ix-samajnak y ri ixcꞌo chuxieꞌ ri akaꞌn, y inreꞌ xquibꞌano chiva chi nquixuxlan. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tivucꞌuaj cꞌa ri nu-yugo chirij iveꞌ, y tivatamaj cꞌa chuvij inreꞌ chi ri cꞌaslien ri vucꞌuan inreꞌ, can otz nunoꞌj quiqꞌuin quinojiel y nubꞌanun chi manak vakalien. Y can quireꞌ tibꞌanaꞌ ixreꞌ chi quireꞌ ri ivánima can xtiril uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ruma ri nu-yugo inreꞌ man cuesta ta nucꞌuax y man al ta ri vakaꞌn, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chupan ri tiempo reꞌ, chupan jun kꞌij richin uxlanien, ri Jesús y ri ru-discípulos i-bꞌanak chupan jun ulief ri ticuon trigo choch. Y ri discípulos ncaꞌquichꞌup-el ruveꞌ ri trigo y niquitej, ruma ninem quipan. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y xaꞌquitzꞌat cꞌa ri achiꞌaꞌ fariseos, ja xquiꞌej cha ri Jesús: Caꞌtzꞌataꞌ la a-discípulos, ruma xajan chi ncaꞌsamaj chupan jun kꞌij richin uxlanien, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ri Jesús xuꞌej chica: ¿Manak came ibꞌanun leer ri tzꞌibꞌan can chirij ri xuꞌon ri David y ri i-rachꞌil chupan ri ojier can tiempo antok xnem-pa quipan? ");
INSERT INTO cakSNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ri David xuoc pa rachuoch ri Dios y can ja ri sagrada simíta ri xbꞌayoꞌx-pa cha. Jajaꞌ xucꞌux ri simíta reꞌ y xuyaꞌ jeꞌ chica ri i-bꞌanak riqꞌuin; pero man pecado ta ri xquiꞌan, mesque ri simíta reꞌ joꞌc ri sacerdotes ri ncaꞌcꞌuxu. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O manak came itzꞌatuon ri nuꞌej chupan ri ley ri xuyaꞌ ri Dios cha ri Moisés? Chireꞌ nuꞌej chi ri sacerdotes can ncaꞌsamaj-ve pa templo ri kꞌij richin uxlanien y man xajan ta chi quireꞌ niquiꞌan ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Pero vacame, ixreꞌ ntitzꞌat Jun ri cꞌo más rukꞌij choch ri templo. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Y ixreꞌ man ta xiꞌej chi pecado ri xquiꞌan ri nu-discípulos, xa ta ivataꞌn chica nuꞌej rutzij ri Dios antok nuꞌej: Inreꞌ más nika chinoch chi ntijoyovaj quivach ri vinak, que choch ri chicop ri nquiꞌquimisaj chi ntiyaꞌ chinoch. Quireꞌ nuꞌej ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ri Xtak-pa chicaj chi xalax chiꞌicajol, Rajaf ri kꞌij richin uxlanien, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y antok ri Jesús xtzalaj-pa, xaꞌa pa sinagoga. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y chiquicajol ri vinak ri quimaluon-quiꞌ, cꞌo jun ache chakeꞌj jun rukꞌaꞌ. Y ri vinak reꞌ xquicꞌutuj cha ri Jesús chi cꞌo cheꞌl niquiꞌan acusar: ¿Otz came chi niꞌan sanar jun niyavaj chupan jun kꞌij richin uxlanien? ");
INSERT INTO cakSNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pero ri Jesús xuꞌej chica: ¿Cꞌo ta jun chivach ixreꞌ ri cꞌo jun ru-oveja ri nitzak-ka chupan jun jul chupan jun kꞌij richin uxlanien, nuyaꞌ came can chi nicꞌujieꞌ can chireꞌ, man nralasaj ta pa came? ");
INSERT INTO cakSNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero jun vinak más rakalien choch jun oveja, rumareꞌ nucꞌul niꞌan ri otz chupan jun kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Cꞌajareꞌ ri Jesús xuꞌej cha ri ache ri chakeꞌj jun rukꞌaꞌ: Tayukuꞌ la akꞌaꞌ. Y ri ache xuyuk ri rukꞌaꞌ, y ja otz xuꞌon, incheꞌl ri jun chic rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y ri achiꞌaꞌ fariseos xaꞌiel chireꞌ chi xbꞌaquimalo-quiꞌ chi niquiꞌan pensar chica niquiꞌan, ruma nicajoꞌ niquiquimisaj ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Antok ri Jesús xunaꞌiej ri niquiꞌan pensar chirij, xiel-el chireꞌ. Y can iqꞌuiy vinak ri xaꞌa chirij, y quinojiel ri ncaꞌyavaj ncaꞌruꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Y xuꞌon mandar chica quinojiel chi man tiquitzijuoj chi chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chi quireꞌ nuꞌon cumplir ri ruꞌeꞌn can ri profeta Isaías. Ri rutzꞌibꞌan can, nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jareꞌ ri Nu-Siervo ri nuchoꞌn. Inreꞌ altíra nivajoꞌ jajaꞌ; can niquicuot vánima riqꞌuin. Can xtinya-pa jeꞌ Nu-Espíritu paroꞌ, y jajaꞌ xtitzijuon chiquivach ri vinak ri man israelitas ta chi nicꞌatzin jun cꞌaslien choj. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Man xtuꞌon ta ayoval, man xtisiqꞌuin ta chi nichꞌoꞌ ruma royoval, ni man xtitzijuon ta ka chirij jajaꞌ mismo chiquivach ri vinak pa tak bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y ri aj ri kꞌajnak chic jubꞌaꞌ, jajaꞌ man xtuꞌon ta cha chi nikꞌaj. Y xa ri rucꞌaslien jeꞌ jun vinak incheꞌl ta jun kꞌakꞌ ri joꞌc chic sebꞌ nuyaꞌ, jajaꞌ man xtuchup ta. Y quireꞌ xtuꞌon-apa, cꞌa antok xtalka ri kꞌij chi jajaꞌ xtuꞌon juzgar nojiel pa ruchojmil. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri vinak ri man israelitas ta, jajaꞌ cꞌa xtiquiyoꞌiej chi ncaꞌrucol. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y xcꞌamar-pa choch ri Jesús jun ache muoy y miem ri quireꞌ rubꞌanun ruma cꞌo jun itziel espíritu riqꞌuin. Y ri Jesús xralasaj-el ri itziel espíritu reꞌ, y ri ache xtzuꞌn y xchꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y quinojiel ri vinak can xaꞌchapataj y niquiꞌej: ¿Man ja ta came va ri Rumáma can ri rey David ri kayoꞌien? ");
INSERT INTO cakSNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero antok ri achiꞌaꞌ fariseos xcaꞌxaj ri niquiꞌej ri vinak chirij ri Jesús, ja xquiꞌej: Jajaꞌ nitiquir ncaꞌralasaj ri itziel tak espíritus xa ruma cꞌo ri Beelzebú riqꞌuin, ri quijaval ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y ri Jesús can rataꞌn ri niquiꞌan pensar ri achiꞌaꞌ fariseos, mareꞌ xuꞌej chica: Xa ri vinak richin jun reino caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri reino reꞌ xa nitzak. Y quireꞌ jeꞌ chupan jun tanamet o chupan jun jay, xa caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri jay reꞌ xa niqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y xa ri Satanás ncaꞌralasaj ri i-rusamajiel jajaꞌ, xa chirij jajaꞌ mismo nuꞌon-ka ayoval. Y xa quireꞌ nuꞌon, ruyuon niquiyaꞌ can y chaꞌnin nitzak ri ru-reino. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Y xa inreꞌ ruma ri ru-poder ri Beelzebú ncaꞌnvalasaj ri itziel tak espíritus, ¿chica xyoꞌn poder chica ri i-bꞌanak chivij chi ncaꞌtiquir ncaꞌcalasaj itziel tak espíritus? Can ja ri niquiꞌan ijejeꞌ nikꞌalajin chi ixreꞌ man ketzij ta ri ntiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero xa inreꞌ ncaꞌnvalasaj ri itziel tak espíritus riqꞌuin ri Ru-Espíritu ri Dios ri cꞌo viqꞌuin, riqꞌuin reꞌ ntivatamaj chi ri ru-reino ri Dios ya xalka iviqꞌuin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y ri nrajoꞌ nuꞌon alakꞌ pa rachuoch jun ache ri altíra ruchukꞌaꞌ; naꞌay nuxim, cꞌajareꞌ cꞌo cheꞌl nucanuj-el nojiel ri nrajoꞌ nucꞌuaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ri man viqꞌuin ta inreꞌ nisamaj-ve, xa chuvij inreꞌ nisamaj-ve. Y ri man nitoꞌn ta vichin, xa jareꞌ ri nituru nojiel ri ncaꞌnꞌan inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y rumareꞌ inreꞌ niꞌej chiva: Nojiel pecado y ri itziel ncaꞌchꞌoꞌ chirij ri Dios, cꞌa ncaꞌan perdonar. Pero jun ri itziel nichꞌoꞌ chirij ri Espíritu Santo, man niꞌan ta perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y chica-na ri itziel nichꞌoꞌ chirij ri Xtak-pa chicaj chi xalax chiꞌicajol, cꞌa niꞌan perdonar. Pero ri itziel nichꞌoꞌ chirij ri Espíritu Santo, man niꞌan ta perdonar chupan ri tiempo vacame, ni chupan ri tiempo chakavach-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","O ntiꞌan incheꞌl jun chieꞌ otz, ri can nuyaꞌ utzulaj tak roch, o ntiꞌan incheꞌl jun chieꞌ ri xa man otz ta, ri roch ri nuyaꞌ man otz ta. Ruma jun chieꞌ ja antok nuyaꞌ roch nikꞌalajin chi otz o man otz ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ixreꞌ xa ix incheꞌl cumatz! ¿Cheꞌl ntiꞌej ri otz, antok xa ja ri itziel tak kax cꞌo pan ivánima? Ruma jun vinak ja ri chica cꞌo pa ránima ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzulaj ache can ja ri utzulaj kax ri nuꞌej, ruma joꞌc utzulaj tak kax cꞌo pa ránima. Pero jun ache ri man otz ta, ja ri itziel tak kax ri nuꞌej, ruma jareꞌ ri cꞌo pa ránima. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y inreꞌ niꞌej chiva chi antok xtalka ri kꞌij richin ri juicio ri nuꞌon ri Dios, quinojiel ri xaꞌeꞌn ri tzij ri manak rakalien, can xcaꞌan juzgar. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ri Dios xcaꞌruꞌon condenar ri vinak ri itziel ncaꞌchꞌoꞌ, pero ri otz ncaꞌchꞌoꞌ, nikꞌalajin chi choj ri quicꞌaslien choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Y icꞌo jujun chiquivach ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos xaꞌchꞌo-apa cha ri Jesús, y xquiꞌej: Maestro, ojreꞌ nakajoꞌ nakatzꞌat chi naꞌan jun señal chakavach. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero ri Jesús xuꞌej chica: Ri vinak richin ri tiempo vacame altíra i-itziel y man niquinimaj ta ri Dios, rumareꞌ nicajoꞌ chi niꞌan jun señal chiquivach chi nquinquinimaj. Pero ri señal ri nicajoꞌ man xtiyoꞌx ta chica. Xa ja ri xbꞌanataj riqꞌuin ri Jonás, ri jun profeta ri xcꞌujieꞌ ojier can tiempo, jareꞌ ri señal ri xtiyoꞌx chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ruma incheꞌl ri Jonás xcꞌujieꞌ oxeꞌ kꞌij y oxeꞌ akꞌaꞌ chupan jun nem car, quireꞌ jeꞌ ri Xtak-pa chicaj chi xalax chiꞌicajol xticꞌujieꞌ chuxie-ulief oxeꞌ kꞌij y oxeꞌ akꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y antok xtalka ri kꞌij richin ri juicio, xcaꞌcꞌastaj-pa ri vinak aj-Nínive y xtiquiꞌej chi man otz ta xquiꞌan ri vinak ri icꞌo vacame, ruma man xquinimaj ta. Ri vinak aj-Nínive joꞌc xcaꞌxaj ri ruchꞌabꞌal ri Dios ri xutzijuoj ri Jonás chica, ja xtzalaj-pa cánima riqꞌuin ri Dios y xquiꞌan ri nrajoꞌ jajaꞌ. Y vacame incꞌo inreꞌ ri cꞌo más nukꞌij choch ri Jonás. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y antok xtalka ri kꞌij richin ri juicio, xticꞌastaj-pa ri jun reina ri xuꞌon gobernar ri Sabá y xtuꞌej chi man otz ta xquiꞌan ri vinak ri icꞌo vacame. Ruma antok xcꞌasieꞌ ri jun reina reꞌ, altíra naj xpa-ve chi xalraꞌxaj runoꞌj ri rey Salomón. Y vacame incꞌo inreꞌ ri cꞌo más nukꞌij choch ri rey Salomón ri xcꞌujieꞌ ojier can. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Antok jun itziel espíritu ntiel-el pa ránima jun vinak, niꞌa pa tak lugar chakeꞌj, nucanuj pacheꞌ nuxlan-ve, y man jun lugar niril. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Rumareꞌ nuꞌej: Más otz nquitzalaj chic pa ránima ri vinak pacheꞌ xiniel-ve-pa, nichaꞌ. Y antok nalka, nalrilaꞌ incheꞌl jun jay man jun cꞌo chupan, masuon y jaꞌal bꞌanun adornar. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y ri itziel espíritu reꞌ ncaꞌrucꞌam-pa i-siete (ivukuꞌ) chic itziel tak espíritus ri más i-itziel, y quinojiel ncaꞌuoc pa ránima ri vinak. Y ri vinak choj-iqꞌuin ncaꞌbꞌacꞌujie-ve ri itziel tak espíritus reꞌ, más peor nuꞌon ri rucꞌaslien choch ri rubꞌanun-pa naꞌay. Quireꞌ jeꞌ xtibꞌanataj quiqꞌuin ri vinak ri man otz ta quicꞌaslien ri icꞌo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y ri Jesús cꞌa nichꞌoꞌ quiqꞌuin ri vinak antok xalka ri rutieꞌ y ri i-ruchakꞌ. Ijejeꞌ nicajoꞌ ncaꞌchꞌoꞌ cha, pero xaꞌcꞌujieꞌ juviera. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y cꞌo jun ri xuꞌej-apa cha ri Jesús: Ri atieꞌ y ri achakꞌ icꞌo juviera y nicajoꞌ ncaꞌchꞌoꞌ chava, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero ri Jesús xuꞌej cha ri xꞌeꞌn-apa quireꞌ cha: ¿Chica ri ntieꞌ y ri nchakꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y ri Jesús xaꞌrucꞌut cꞌa cha rukꞌaꞌ ri ru-discípulos y xuꞌej: Jareꞌ ri ntieꞌ y ri nchakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ruma quinojiel ri ncaꞌbꞌano ri nrajoꞌ ri Nataꞌ ri cꞌo chicaj, jareꞌ ri ntieꞌ, ri vanaꞌ y ri nchakꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupan ri kꞌij reꞌ, ri Jesús xiel-el pa jay y xbꞌatzꞌuyeꞌ chuchiꞌ ri mar. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y iqꞌuiy vinak xquimol-apa-quiꞌ riqꞌuin. Rumareꞌ jajaꞌ xuoc chupan jun barco y xtzꞌuye-ka chupan y quinojiel ri vinak xaꞌcꞌujieꞌ chuchiꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Y jajaꞌ qꞌuiy kax xuꞌej chica y ruyuon riqꞌuin parábolas (cꞌambꞌal-tzij). Y quireꞌ nuꞌej chica: Cꞌo jun ache ri xꞌa chi xbꞌaruquiraj ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y antok ri ache nuquiraj ri ijaꞌtz, cꞌo ijaꞌtz xaꞌka pa bꞌay. Y xaꞌpa ri chicop ri cꞌo quixicꞌ, xquimol-el ri ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Nicꞌaj chic ijaꞌtz xaꞌka chiquicajol abꞌaj y chireꞌ xa man qꞌuiy ta ri ulief cꞌo, rumareꞌ chaꞌnin xaꞌiel-pa ruma man pin ta ri ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero antok xpa ruchukꞌaꞌ ri kꞌij, xaꞌyamayo-ka, y ruma man naj ta bꞌanak-ka ri quixieꞌ, mareꞌ xaꞌchakej-ka chaꞌnin. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y nicꞌaj chic ijaꞌtz xaꞌka chiquicajol tak qꞌuix. Y antok xaꞌiel-pa, junan xaꞌqꞌuiy quiqꞌuin ri qꞌuix, y xaꞌjiekꞌ chiquicajol ri qꞌuix. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero nicꞌaj chic ijaꞌtz xaꞌka pan utzulaj ulief, y jaꞌal xquiyaꞌ quivach; cꞌo ri xquiyaꞌ a treinta quivach, cꞌo ri xquiyaꞌ a sesenta y cꞌo ri xquiyaꞌ a cien quivach. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y ri discípulos xaꞌjiel-apa riqꞌuin ri Jesús y xquiꞌej cha: ¿Karruma riqꞌuin parábolas (cꞌambꞌal-tzij) ncachꞌo-ve chiquivach ri vinak? ");
INSERT INTO cakSNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Y jajaꞌ xuꞌej chica: Chiva ixreꞌ yoꞌn permiso chi ntinaꞌiej chirij ri reino ri cꞌo chicaj. Pero chica ri vinak ri man nquinquinimaj ta, man yoꞌn ta lugar chi niquitamaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ruma ri cꞌo riqꞌuin, can xtiyoꞌx más cha y can qꞌuiy xtuꞌon-ka riqꞌuin. Pero ri xa man qꞌuiy ta cꞌo riqꞌuin, hasta reꞌ xtalasas-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rumareꞌ ncaꞌncusaj parábolas (cꞌambꞌal-tzij) antok nquichꞌoꞌ chica; ruma man nicajoꞌ ta niquiꞌan entender, mesque niquitzꞌat y nicaꞌxaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Quireꞌ nuꞌon cumplir ri tzꞌibꞌan can ruma ri profeta Isaías. Y quireꞌ rutzꞌibꞌan can jajaꞌ: Joꞌc xtivaxaj y man xtiꞌka ta pan iveꞌ (man xtiꞌan ta entender) ri xtivaxaj. Choj xtitzꞌat y man xtiyaꞌ ta pa cuenta ri ntitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ruma ri cánima ri vinak reꞌ xa cof rubꞌanun, y can man ntuoc ta pa quixiquin ri niꞌeꞌx chica. Ijejeꞌ can quiyupun ri quinakꞌavach, ruma man nicajoꞌ ta ncaꞌtzuꞌn. Man nicajoꞌ ta nicaꞌxaj ri niꞌeꞌx chica, man nicajoꞌ ta chi ntuoc riqꞌuin cánima; y can man nicajoꞌ ta niquiyaꞌ can ri pecado chi niquiꞌan ri nivajoꞌ inreꞌ, chi nicꞌax ri quicꞌaslien. Quireꞌ nuꞌej ri Dios, ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero ixreꞌ ri ix nu-discípulos, can jaꞌal quixquicuot, ruma riqꞌuin ri inakꞌavach can jaꞌal ntitzꞌat y riqꞌuin ixiquin can jaꞌal ntivaxaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ruma ketzij cꞌa niꞌej chiva, chi iqꞌuiy profetas y choj tak vinak ri xaꞌcꞌujieꞌ ojier can tiempo, altíra xcajoꞌ xquitzꞌat ri ntitzꞌat ixreꞌ vacame, y man xquitzꞌat ta el. Xcajoꞌ ta jeꞌ xcaꞌxaj ri ntivaxaj ixreꞌ vacame, y man xcaꞌxaj ta el. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y ri Jesús xuꞌej chica: Tivaxaj ri chica nuꞌej ri parábola (cꞌambꞌal-tzij) ri nichꞌoꞌ chirij ri xbꞌaruquiraj ri ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Antok jun nraꞌxaj ri chꞌabꞌal chirij ri ru-reino ri Dios y man niꞌka ta paroꞌ (man nuꞌon ta entender), nipa ri itziel y nralasaj-el ri chꞌabꞌal ri xtic can pa ránima. Jareꞌ ri ijaꞌtz ri xaꞌka pa bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ijaꞌtz ri xaꞌka chiquicajol abꞌaj, jareꞌ ri nraꞌxaj ri ruchꞌabꞌal ri Dios y can altíra niquicuot antok nuꞌon recibir. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ruma manak ruxieꞌ ri ruchꞌabꞌal ri Dios riqꞌuin ránima, rumareꞌ man nilayuj ta niquicuot. Ruma antok ncaꞌpa ri sufrimientos y itziel nitzꞌiet ruma runiman ri ruchꞌabꞌal ri Dios, chaꞌnin nitzak. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y ri ijaꞌtz ri xaꞌka chiquicajol tak qꞌuix, jareꞌ ri nraꞌxaj ri ruchꞌabꞌal ri Dios, pero xa ja ri nicꞌatzin cha kꞌij-kꞌij choch-ulief, joꞌc reꞌ ninataj cha y niꞌan maña cha ruma ri bꞌayomal. Jareꞌ nibꞌano chi nijiekꞌ ri ruchꞌabꞌal ri Dios riqꞌuin ránima. Rumareꞌ man jun otz xtikꞌalajin pa rucꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Y ri ijaꞌtz ri xaꞌka pan utzulaj ulief, jareꞌ ri nraꞌxaj y niꞌka paroꞌ (nuꞌon entender) ri ruchꞌabꞌal ri Dios. Ri rucꞌaslien can nikꞌalajin jaꞌal, y can nuyaꞌ ru-fruto, a cien, a sesenta o a treinta, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Y ri Jesús xuꞌej chic jun parábola (cꞌambꞌal-tzij) chiquivach, y xuꞌej: Ri reino ri cꞌo chicaj can junan riqꞌuin ri xuꞌon jun ache ri xutic jun utzulaj ijaꞌtz pa rulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero chakꞌaꞌ antok quinojiel ncaꞌvar, xalka ri ru-enemigo ri rajaf ri ulief, xalruticaꞌ jun kꞌayis rubꞌinan cizaña chucajol ri trigo ri ticuon can. Y joꞌc xalrubꞌanaꞌ quireꞌ, y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Y antok xaꞌbꞌaqꞌuiy-pa ri trigo y xuya-pa roch, cꞌajareꞌ xkꞌalajin-pa jeꞌ ri cizaña. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y ri ru-esclavos ri rajaf ri ulief xaꞌa riqꞌuin y xquiꞌej cha: Ajaf, ri ijaꞌtz ri xatic pan avulief can otz. Pero vacame cꞌo cizaña chucajol. ¿Pacheꞌ cꞌa xpa-ve ri ijaꞌtz richin ri cizaña? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y ri ache xuꞌej chica ri ru-esclavos: Jun nu-enemigo xbꞌano reꞌ. Y ri ru-esclavos xquiꞌej cha: ¿Navajoꞌ chi nkuꞌa y nakacꞌukuꞌ ri cizaña? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero ri ache xuꞌej chica ri ru-esclavos: Ni, ruma xa nticꞌuk ri cizaña, ncaꞌcꞌukutaj jeꞌ ri trigo. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiyaꞌ lugar cha ri cizaña chi junan niqꞌuiy-pa riqꞌuin ri trigo, cꞌa talka-na ri kꞌij chi nijuk ri trigo, ruma antok xtalka ri kꞌij reꞌ, inreꞌ xtinꞌej chica ri xcaꞌjuku chi tiquimaloꞌ naꞌay ri cizaña y chi manuoja tiquibꞌanaꞌ cha chi niparox; cꞌajareꞌ tiquijukuꞌ ri trigo y tiquiyacaꞌ, xchaꞌ ri ache. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y ri Jesús xuꞌej chic jun parábola (cꞌambꞌal-tzij) chiquivach, y xuꞌej: Ri reino ri cꞌo chicaj can junan riqꞌuin ri ijaꞌtz richin ri mostaza ri xutic can jun ache pa rulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ruma mesque ja ri ijaꞌtz richin ri mostaza ri más coꞌl-oc chiquivach nicꞌaj chic ijaꞌtz, pero antok niqꞌuiy, jareꞌ ri más nem ntiel chiquivach ri nicꞌaj chic kꞌayis. Ri mostaza can incheꞌl jun chieꞌ ntiel antok niqꞌuiy. Rumareꞌ ri chicop ri cꞌo quixicꞌ ncaꞌlka y niquiꞌan quisuoc chukꞌaꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xuꞌej chic jun parábola (cꞌambꞌal-tzij) chiquivach, y xuꞌej chica: Ri reino ri cꞌo chicaj xa junan riqꞌuin ri levadura ri niruma-pa jun ixok y nuyaꞌ chupan oxeꞌ medida harina y ri levadura nuquiraj-riꞌ chupan nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y nojiel ri xuꞌej ri Jesús chica ri vinak reꞌ, ruyuon riqꞌuin parábolas (cꞌambꞌal-tzij) xchꞌoꞌ. Man jun tzij ri xuꞌej chica, ri man ta xucusaj parábolas (cꞌambꞌal-tzij); ");
INSERT INTO cakSNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","chi quireꞌ nuꞌon cumplir ri ruꞌeꞌn can ri jun profeta ri xcꞌujieꞌ ojier can tiempo. Quireꞌ rutzꞌibꞌan can: Antok inreꞌ xquichꞌoꞌ, xcaꞌncusaj parábolas (cꞌambꞌal-tzij). Xtinꞌej ri kax ri avan-pa desde xtzꞌucutaj-pa ri roch-ulief. Quireꞌ nuꞌej ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y antok ri Jesús xaꞌruꞌon-el despedir ri vinak, jajaꞌ xuoc pa jay y ri ru-discípulos xaꞌjiel-apa riqꞌuin y xquiꞌej cha: Ojreꞌ nakajoꞌ chi atreꞌ naꞌej chika ri chica nuꞌej ri parábola (cꞌambꞌal-tzij) chirij ri trigo y ri cizaña. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús xuꞌej chica: Ri ache ri nutic ri utzulaj ijaꞌtz, ja ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulief ri pacheꞌ xtic-ve ri ijaꞌtz, ja ri roch-ulief. Ri utzulaj ijaꞌtz, ja ri icꞌo pa ru-reino ri Dios. Y ri cizaña, ja ri can i-richin ri itziel. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ri enemigo ri xaltico ri cizaña, ja ri diablo. Ri kꞌij antok xtijuk ri trigo, reꞌ pa ruqꞌuisbꞌal ri tiempo, y ri ncaꞌjuku ri trigo, ja ri ángeles. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Y can incheꞌl niꞌan riqꞌuin ri cizaña ncaꞌlasas-el y ncaꞌyoꞌx pa kꞌakꞌ, can quireꞌ mismo xtibꞌanataj pa ruqꞌuisbꞌal ri tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ri Xtak-pa chicaj chi xalax chiꞌicajol, xcaꞌrutak ri ru-ángeles chi ncaꞌquimol chupan ri ru-reino quinojiel ri ncaꞌbꞌano itziel tak kax y ri niquiꞌan chica nicꞌaj chic chi ncaꞌtzak chupan ri pecado. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y xcaꞌbꞌacꞌak chupan ri kꞌakꞌ; y chireꞌ xcaꞌuokꞌ y xtiquikꞌachꞌachꞌiej coray. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Y ri choj quicꞌaslien choch ri Dios, can altíra xcaꞌchꞌichꞌan incheꞌl ri kꞌij chupan ri ru-reino ri Quitataꞌ Dios. Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri reino ri cꞌo chicaj can junan riqꞌuin jun tesoro ri mukun can chupan jun ulief, y nirila-pa jun ache. Ri ache reꞌ numuk chic can y altíra niquicuot nitzalaj chirachuoch, nucꞌayij nojiel ri cꞌo riqꞌuin, cꞌajareꞌ nulokꞌ ri ulief ri pacheꞌ mukun-ve can ri tesoro reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri reino ri cꞌo chicaj can junan riqꞌuin ri nuꞌon jun ache ri ncaꞌrulokꞌ y ncaꞌrucꞌayij ri perlas. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Antok niril jun perla ri altíra jaꞌal y nicꞌayix, chaꞌnin nitzalaj chirachuoch y nucꞌayij nojiel ri cꞌo riqꞌuin, y nulokꞌ ri perla reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ri reino ri cꞌo chicaj can junan riqꞌuin jun yaꞌl ri niyoꞌx-ka chupan ri mar y ncaꞌralasaj-pa nojiel quivach car. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y antok ri yaꞌl nojnak chic chi car, nicalasaj-pa y niquicꞌuaj chuchi-yaꞌ, y ncaꞌtzꞌuye-ka chi ncaꞌquichaꞌ. Ri car i-otz ncaꞌquiyaꞌ pa tak chacach, pero ri man i-otz ta xa ncaꞌquicꞌak-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quireꞌ ri xtibꞌanataj pa ruqꞌuisbꞌal ri tiempo. Xcaꞌpa ri ángeles y xcaꞌquichaꞌ ri vinak ri man otz ta rubꞌanun quicꞌaslien chiquicajol ri choj rubꞌanun quicꞌaslien choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y xcaꞌyoꞌx chupan ri kꞌakꞌ, y chireꞌ xcaꞌuokꞌ y xtiquikꞌachꞌachꞌiej coray. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ri Jesús xuꞌej chica ri ru-discípulos: ¿Xiꞌka pan iveꞌ (xiꞌan entender) nojiel ri xinꞌej chiva? xchaꞌ chica. Y ri discípulos xquiꞌej: Quireꞌ Ajaf, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Y jajaꞌ xuꞌej chica: Jun ri rataꞌn chirij ri reino ri cꞌo chicaj, y rataꞌn jeꞌ ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, can junan riqꞌuin jun rajaf-jay ri ncaꞌbꞌaralasaj-pa ru-tesoro ri cꞌo yan tiempo ruyacuon y ncaꞌbꞌaralasaj-pa jeꞌ ri cꞌa jubꞌaꞌ oc tiempo tuyac, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y antok ri Jesús xtanieꞌ cꞌa chubꞌixic ri parábolas (cꞌambꞌal-tzij) reꞌ, xuyaꞌ can ri lugar reꞌ y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Y xalka chupan ri rutanamit pacheꞌ xqꞌuiy-pa jajaꞌ, y xucꞌut ri ruchꞌabꞌal ri Dios chupan ri sinagoga. Y ruma ri tzij ri nuꞌej, ri vinak can xaꞌchapataj, y xquiꞌej: ¿Pacheꞌ cꞌa rucꞌamun-pa ri noꞌj, y chi nitiquir ncaꞌruꞌon milagros? ");
INSERT INTO cakSNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Man ja ta came va rucꞌajuol ri jun ache carpintero, y ri rutieꞌ María rubꞌeꞌ, y ri i-ruchakꞌ ja ri Jacobo, ri José, ri Simón y ri Judas? ");
INSERT INTO cakSNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Man icꞌo ta cꞌa quinojiel ri ranaꞌ kiqꞌuin? ¿Pacheꞌ cꞌa xucꞌam-pa nojiel ri nuꞌej y ri nuꞌon? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y rumareꞌ ri vinak man xquinimaj ta y xpa quiyoval chirij ri Jesús. Pero jajaꞌ xuꞌej chica: Jun profeta joꞌc ri pa rutanamit y ri pa rachuoch niquiꞌan cha chi man jun rakalien, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ri Jesús man qꞌuiy ta milagros xaꞌruꞌon pa rutanamit, ruma ri vinak xa man xquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupan ri tiempo reꞌ, ri gobernador Herodes xraꞌxaj ri nuꞌon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y ri Herodes xuꞌej chica ri rusamajiel: Ri ache reꞌ xa ja ri Juan el Bautista ri xcꞌastaj-pa chiquicajol ri quiminakiꞌ, y rumareꞌ cꞌo qꞌuiy poder riqꞌuin, xchaꞌ ri Herodes chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ruma ja ri Herodes ri xꞌeꞌn chi xtzꞌam ri Juan, xyoꞌx pa cárcel y xtzꞌam cha cadena (yariena). Ri Herodes quireꞌ xuꞌon, ruma quicꞌamun-quiꞌ riqꞌuin ri Herodías, ri xa raxjayil ri Felipe ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Herodes; ");
INSERT INTO cakSNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ruma ri Juan xuꞌej cha: Man otz ta chi abꞌanun avaxjayil cha ri Herodías. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Y ri Herodes can nrajoꞌ nuquimisaj ri Juan, pero nuxiꞌij-riꞌ chiquivach ri vinak, ruma ijejeꞌ niquitzꞌat chi ri Juan can jun profeta. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Pero chupan ri kꞌij antok ri Herodes xuqꞌuis chic jun rujunaꞌ, jajaꞌ xuꞌon jun namakꞌej, y chupan ri namakꞌej reꞌ ri ral-xtan ri Herodías xxajo chiquivach quinojiel ri invitados, y altíra xka choch ri Herodes. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y rumareꞌ ri Herodes xuꞌon jurar cha ri ral ri Herodías chi chica-na ri nrajoꞌ, can xtuyaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero nabꞌayal ri xtan xa xyoꞌx runoꞌj ruma ri rutieꞌ, cꞌajareꞌ xuꞌej cha ri Herodes: Inreꞌ nivajoꞌ chi nayaꞌ chuva chupan jun plato ri rujaluon ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y ri rey Herodes xbꞌisuon-ka ránima rumareꞌ, pero ruma can rubꞌanun yan jurar y cuma ri icꞌo riqꞌuin chirij ri mesa, mareꞌ jajaꞌ xuꞌon mandar chi ticꞌamar-pa ri rujaluon ri Juan el Bautista chi tiyoꞌx cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Y xutak rukupixic rujaluon ri Juan el Bautista chireꞌ pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y ri rujaluon xcꞌamar-pa chupan jun plato y xyoꞌx cha ri xtan, y ri xtan xbꞌarujachaꞌ cha ri rutieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y ri ru-discípulos ri Juan xaꞌlka chi xalquimaꞌ ri ru-cuerpo y xbꞌaquimukuꞌ. Y xbꞌaquiꞌej cha ri Jesús nojiel ri xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y ri Jesús joꞌc xraꞌxaj ri xbꞌanataj, xuoc chupan jun barco y naj niꞌa-ve, chupan jun lugar pacheꞌ manak vinak. Pero antok ri vinak xquinaꞌiej pacheꞌ niꞌa-ve, xaꞌiel-el pa tak tanamet y chicakan xaꞌa ri pacheꞌ nibꞌaka-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y antok ri Jesús ja ntiel-pa chireꞌ, xutzꞌat chi can iqꞌuiy ri vinak, y jajaꞌ xujoyovaj quivach. Y ri ncaꞌyavaj ri icꞌo chiquicajol ri vinak reꞌ, xaꞌruꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Antok ya xkakꞌij-ka, ri ru-discípulos xaꞌjiel-apa riqꞌuin ri Jesús y xquiꞌej cha: Chupan va lugar va man jun jay cꞌo y ya tarde chic; caꞌtakaꞌ cꞌa el ri vinak chi caꞌa pa tak aldeas chi tiquilakꞌoꞌ ri chica niquitej, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero ri Jesús xuꞌej chica: Man nicꞌatzin ta chi ncaꞌa, tiyaꞌ ixreꞌ chi ncaꞌvaꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y ri discípulos xquiꞌej cꞌa: Kiqꞌuin ojreꞌ joꞌc vuꞌuoꞌ simíta y caꞌyeꞌ car cꞌo, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero ri Jesús xuꞌej chica: Ticꞌama-pa vaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y xuꞌej chica ri vinak chi caꞌtzꞌuye-ka quinojiel paroꞌ ri kꞌayis. Y jajaꞌ xutzꞌom ri vuꞌuoꞌ simíta y ri caꞌyeꞌ car, xtzuꞌn chicaj, y xuꞌon bendecir, y xaꞌruper, y xuyaꞌ chica ri ru-discípulos, y ri ru-discípulos xquijach chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Y quinojiel jaꞌal xaꞌvaꞌ, y otz xnuoj quipan. Y cꞌa cꞌo doce (cabꞌalajuj) chacach ri xaꞌnuoj riqꞌuin ri jutak pir ri xmuol can ri xuꞌon suobra. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Y ri xaꞌvaꞌ icꞌo laꞌk vuꞌuoꞌ mil joꞌc ri achiꞌaꞌ, y ri ixokiꞌ y ri acꞌolaꞌ ri xaꞌvaꞌ man xaꞌjilax ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y jareꞌ antok ri Jesús xuꞌej chica ri ru-discípulos chi caꞌuoc chupan ri barco y caꞌa naꞌay choch jucꞌan chic ruchiꞌ ri yaꞌ; y jajaꞌ cꞌa nicꞌujieꞌ can chi ncaꞌruꞌon can despedir ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Y antok ya i-bꞌanak chic quinojiel ri vinak, jajaꞌ xjotie-el paroꞌ jun juyuꞌ chi xirubꞌanaꞌ orar. Y can ruyuon cꞌo chireꞌ antok xchakꞌa-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y ri barco pacheꞌ i-bꞌanak-ve ri discípulos ya pa nicꞌaj ri mar cꞌo-ve-apa, pero ri yaꞌ altíra nibꞌalkoꞌt, man nuyaꞌ ta lugar chi niꞌin. Ruma altíra nuꞌon ri cakꞌiekꞌ, rumareꞌ man nuyaꞌ ta chic lugar cha ri barco chi choj niꞌin choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y antok ya nisakar-pa, ri Jesús patanak chirakan paroꞌ ri mar, chi nalka quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero antok ri discípulos xquitzꞌat chi cꞌo jun niꞌin paroꞌ ri mar, xaꞌchapataj, y rumareꞌ xquiꞌej: ¡Jun fantasma! xaꞌchaꞌ. Y can riqꞌuin quichukꞌaꞌ xquiꞌej quireꞌ ruma altíra xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ri Jesús chaꞌnin xchꞌo-pa chica, y xuꞌej: ¡Man tixiꞌij-iviꞌ; tiyaꞌ ivánima viqꞌuin, xa inreꞌ! xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y ri Pedro xchꞌo-apa y xuꞌej: Ajaf, xa can ketzij chi atreꞌ, tabꞌanaꞌ chuva chi nquiꞌin paroꞌ ri yaꞌ chi nquiꞌa-apa aviqꞌuin, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Jesús xuꞌej-pa cha: Catam-pa cꞌa. Y ri Pedro can ja xka-ka chupan ri barco y niꞌin paroꞌ ri yaꞌ chi niꞌa-apa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero antok xutzꞌat chi can nem ruchukꞌaꞌ ri cakꞌiekꞌ, xuxiꞌij-riꞌ, y antok xunaꞌ chi niꞌa-ka chuxieꞌ ri yaꞌ, riqꞌuin ruchukꞌaꞌ xuꞌej: ¡Ajaf, quinacaloꞌ! ");
INSERT INTO cakSNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y ri Jesús can chaꞌnin xutzꞌom ri Pedro y xuꞌej cha: ¿Karruma man xacukubꞌaꞌ ta acꞌuꞌx viqꞌuin? xchaꞌ cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Y antok ijejeꞌ xaꞌjotie-apa chupan ri barco, ja xtanie-ka ruchukꞌaꞌ ri cakꞌiekꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y quinojiel ri i-bꞌanak chupan ri barco xquiyaꞌ rukꞌij ri Jesús y xquiꞌej cha: Ketzij chi atreꞌ ri Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y ijejeꞌ xaꞌkꞌax paroꞌ ri mar y xaꞌbꞌaka Genesaret. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y antok ri achiꞌaꞌ richin ri lugar reꞌ xquitzꞌat chi ja ri Jesús xalka, ijejeꞌ can chaꞌnin xquitak rutzijoxic chupan nojiel lugar ri icꞌo cierca ri Genesaret, y ri vinak xaꞌquicꞌam-pa quinojiel ri ncaꞌyavaj ri icꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y ri ncaꞌyavaj can niquicꞌutuj favor cha chi tuyaꞌ permiso chica chi niquitzꞌom mesque joꞌc ruchiꞌ ri rutziak. Y quinojiel ri xaꞌtzꞌamo ruchiꞌ ri rutziak ri Jesús, xquiꞌan sanar riqꞌuin ri quiyabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y icꞌo nicꞌaj achiꞌaꞌ fariseos y nicꞌaj achiꞌaꞌ escribas ri i-patanak Jerusalén xaꞌjiel-apa riqꞌuin ri Jesús y xquicꞌutuj cha: ");
INSERT INTO cakSNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Karruma ri a-discípulos man niquiꞌan ta incheꞌl ri bꞌeꞌn can cuma ri kateꞌt-kamamaꞌ? Ruma ri a-discípulos atreꞌ man niquichꞌaj ta quikꞌaꞌ antok ncaꞌvaꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Y ri Jesús xucꞌutuj chica ijejeꞌ: ¿Y ixreꞌ, karruma joꞌc ri quicꞌutun can ri ivateꞌt-imamaꞌ ri ntiꞌan, y man ntiꞌan ta ri ru-mandamiento ri Dios? ");
INSERT INTO cakSNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ruma ri Dios nuꞌon mandar: Caꞌbꞌanaꞌ respetar ri atie-atataꞌ. Y jun ri ncaꞌrukal ri rutie-rutataꞌ, tiquimisas; man tijoyovax roch. Quireꞌ ruꞌeꞌn ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero ixreꞌ ntiꞌej: Chica-na ri nuꞌej chica ri rutie-rutataꞌ chi manak cheꞌl ncaꞌrutoꞌ, ruma nojiel ri cꞌo riqꞌuin xa ruyoꞌn chic cha ri Dios; ");
INSERT INTO cakSNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ri jun reꞌ ya man nicꞌatzin ta chi ncaꞌruꞌon respetar ri rutie-rutataꞌ. Riqꞌuin ri ntiꞌej, can kꞌalaj chi ixreꞌ joꞌc ntivajoꞌ ntiꞌan ri quicꞌutun can ri ivateꞌt-imamaꞌ, y ibꞌanun cha ri ru-mandamiento ri Dios chi man jun rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ixreꞌ xa caꞌyeꞌ ipalaj. Xa otz rubꞌixic ruꞌeꞌn can chivij ri profeta Isaías. Quireꞌ cꞌa nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ri vinak reꞌ joꞌc riqꞌuin ri quichiꞌ niquiyaꞌ nukꞌij, pero ri cánima xa naj cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa man jun nicꞌatzin ri niquiꞌan antok niquiyaꞌ nukꞌij, nojiel ri ncaꞌquiꞌej antok ncaꞌquitijuoj ri vinak, xa quinoꞌj achiꞌaꞌ y niquiꞌej chi can jareꞌ tiꞌan. Quireꞌ ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Y ri Jesús xaꞌrayuoj-apa ri vinak ri quimaluon-quiꞌ chireꞌ y xuꞌej chica: Tivaxaj otz ri xtinꞌej chiva y tiꞌka pan iveꞌ (tibꞌanaꞌ entender). ");
INSERT INTO cakSNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri nibꞌano tzꞌil cha jun vinak man ja ta ri kax ri ncaꞌrutej-ka. Ri nibꞌano tzꞌil cha jun vinak, ja ri itziel kax ri ncaꞌiel-pa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Y ri discípulos xaꞌjiel-apa riqꞌuin ri Jesús, y xquiꞌej cha: Ri achiꞌaꞌ fariseos xpa quiyoval antok xcaꞌxaj ri xaꞌej, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero ri Jesús xuꞌej chica ri ru-discípulos: Nojiel ri man ticuon ta ruma ri Nataꞌ ri cꞌo chila chicaj, can xticꞌuk-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Quiꞌiyaꞌ can chireꞌ. Ijejeꞌ xa i-muoy quibꞌanun riqꞌuin ri cataꞌn, y ncaꞌquicꞌuaj nicꞌaj chic muoy. Y xa ri muoy nucꞌuaj jun chic muoy, junan xcaꞌbꞌatzak pa jul. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y ri Pedro xuꞌej cha ri Jesús: Tabꞌanaꞌ explicar chika, chica nibꞌano tzꞌil cha jun vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xuꞌej: ¿Ixreꞌ jeꞌ man niꞌka ta pan iveꞌ (man ntiꞌan ta entender) ri xinꞌej? ");
INSERT INTO cakSNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man niꞌka ta pan iveꞌ (man ntiꞌan ta entender) chi nojiel ri nutej-ka xa chupan nika-ve-ka, y después ntiel-el? ");
INSERT INTO cakSNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ri nibꞌano tzꞌil cha jun vinak, ja ri itziel tak tzij ri ncaꞌruꞌej, ruma nojiel reꞌ xa pa ránima ntiel-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ruma xa pa cánima ri vinak ncaꞌpa-ve ri itziel tak kax ri niquiꞌan pensar, ri ncaꞌquimisan, ri i-cꞌulan y ri man i-cꞌulan ta niquicanuj-quiꞌ chi niquiꞌan pecado, ri ncaꞌlakꞌ, ri niquitzꞌak tzij chiquij nicꞌaj chic, y ri itziel ncaꞌchꞌoꞌ chiquij nicꞌaj chic. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nojiel reꞌ, jareꞌ ri nibꞌano tzꞌil cha jun vinak. Pero xa jun vinak man nuchꞌaj ta rukꞌaꞌ antok niva-ka, man jun tzꞌil nuꞌon cha ri ránima. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Y ri Jesús xiel-el chireꞌ, y xꞌa cꞌa chupan jun lugar cierca ri tanamet quibꞌinan Tiro y Sidón. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chireꞌ cꞌo jun ixok aj-Canaán. Jajaꞌ xalka riqꞌuin ri Jesús, y nucꞌutuj favor cha y can riqꞌuin ruchukꞌaꞌ nuꞌej: ¡Ajaf, ri at Rumáma can ri rey David, tajoyovaj noch! Ri val-xtan cꞌo jun itziel espíritu riqꞌuin, y can altíra nuꞌon sufrir pa rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ri Jesús man xchꞌoꞌ ta cha ri ixok. Y ri discípulos xaꞌjiel-apa riqꞌuin ri Jesús y xquiꞌej cha: Taꞌej cha ri ixok reꞌ chi ticꞌujieꞌ can, ruma patanak chikij y can altíra nisiqꞌuin nichꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Y ri Jesús xuꞌej: Inreꞌ xitak-pa joꞌc quichin ri israelitas, ri incheꞌl ri ovejas ri i-sachnak can, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Can ja xpa ri ixok y xalxuquieꞌ choch, y xuꞌej cha: ¡Ajaf, quinatoꞌ! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xuꞌej cha ri ixok: Man otz ta nicꞌan-el ri qui-simíta ri acꞌolaꞌ y niyoꞌx chica ri tzꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Y ri ixok xuꞌej: Ajaf, can ketzij ri naꞌej. Pero ri tzꞌeꞌ ncaꞌquimol ri rupixqꞌuil ri simíta ri ncaꞌquitzak-ka ri cajaf choch ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y ri Jesús xuꞌej cha ri ixok: Can altíra acukubꞌan acꞌuꞌx viqꞌuin. Can tibꞌanataj cꞌa ri navajoꞌ, xchaꞌ cha. Y can chupan ri huora reꞌ, ri itziel espíritu ri cꞌo riqꞌuin ri ral-xtan ri ixok, ja xiel-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús xuyaꞌ can ri lugar reꞌ y xꞌa cierca ri mar Galilea, xjotieꞌ paroꞌ ri chꞌiti juyuꞌ ri cꞌo chireꞌ y chireꞌ xbꞌatzꞌuye-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y can iqꞌuiy vinak xaꞌlka riqꞌuin, i-quicꞌamun-pa ri i-jacajic ncaꞌin, ri i-muoy, ri i-miem, ri man otz ta quikꞌaꞌ y nicꞌaj chic ri jun-ve chic roch yabꞌil ntuoc chica. Quinojiel xaꞌyoꞌx choch ri Jesús, y quinojiel xaꞌruꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Y ruma ri xuꞌon ri Jesús quiqꞌuin ri ncaꞌyavaj, ri vinak can xaꞌchapataj; ruma ri i-miem, ncaꞌchꞌoꞌ; ri man otz ta ri quikꞌaꞌ, xaꞌcꞌachoj; ri ncaꞌjacajot ncaꞌin, can otz yan chic ncaꞌin; y ri muoy ncaꞌtzuꞌn yan chic. Rumareꞌ ri vinak can xquiyaꞌ rukꞌij ri Ru-Dios ri Israel. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Y ri Jesús xaꞌrayuoj ri ru-discípulos y xuꞌej chica: Altíra nijoyovaj quivach ri vinak, ruma oxeꞌ kꞌij icꞌo viqꞌuin y manak chic ri chica niquitej. Y xa ncaꞌntak ta el y xa man ncaꞌvaꞌ ta el, man nivajoꞌ ta; xa xcaꞌbꞌatzak pa tak bꞌay ruma viꞌjal, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Y ri ru-discípulos xquiꞌej cha: Chupan va lugar va manak jay. ¿Pacheꞌ nakila-pa simíta chi ncaꞌkatzuk quinojiel? ");
INSERT INTO cakSNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero ri Jesús xucꞌutuj chica: ¿Janeꞌ (jaroꞌ) simíta cꞌo iviqꞌuin? Y ijejeꞌ xquiꞌej: Cꞌo siete (vukuꞌ) simíta y jutzꞌit chꞌitak car, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xuꞌej chica ri vinak chi caꞌtzꞌuye-ka pan ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Y xutzꞌom ri siete (vukuꞌ) simíta y ri car, xuyaꞌ tiox bꞌaꞌ cha ri Dios, xaꞌruper y xuya-el chica ri ru-discípulos y ri ru-discípulos xiꞌquiyaꞌ chica quinojiel ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Can quinojiel xaꞌvaꞌ otz y jaꞌal xnuoj quipan; y xmuol siete (vukuꞌ) chacach ri jutak pir ri xuꞌon suobra. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Y ri xaꞌvaꞌ, joꞌc ri achiꞌaꞌ icajeꞌ mil. Y ri ixokiꞌ y ri acꞌolaꞌ ri xaꞌvaꞌ man xaꞌjilax ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y antok ri Jesús i-rubꞌanun chic despedir ri vinak, jajaꞌ xuoc-el chupan ri barco, y xꞌa cꞌa jun lugar rubꞌinan Magdala. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri achiꞌaꞌ fariseos y ri achiꞌaꞌ saduceos xaꞌlka riqꞌuin ri Jesús chi niquiꞌan tentar, y xquiꞌej cha chi tubꞌanaꞌ jun señal chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Antok ixreꞌ ntitzꞌat chi can quiak rubꞌanun ri mukul chicaj antok nika-ka ri kꞌij, ntiꞌej chi otz kꞌij nuꞌon chuaꞌk. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y quireꞌ jeꞌ ri macꞌajan yan, antok ntitzꞌat chi ri rocaj mukul y quiak ri mukul, ntiꞌej: Vacame nika jobꞌ, nquixchaꞌ. ¡Ixreꞌ xa caꞌyeꞌ ipalaj! Ruma can ivataꞌn chica nirubꞌanaꞌ antok ntitzꞌat ri rocaj, pero man ivataꞌn ta ntitzꞌat ri señales richin ri tiempo ri ojcꞌo. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri vinak richin ri tiempo vacame altíra i-itziel y man niquinimaj ta ri Dios, rumareꞌ nicajoꞌ chi niꞌan jun señal chiquivach chi nquinquinimaj. Pero ri señal ri nicajoꞌ man xtiyoꞌx ta chica. Xa ja ri xbꞌanataj riqꞌuin ri Jonás, ri jun profeta ri xcꞌujieꞌ ojier can tiempo, jareꞌ ri señal ri xtiyoꞌx chica. Y ja xaꞌruyaꞌ can ri achiꞌaꞌ reꞌ y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Antok ri Jesús y ri ru-discípulos xaꞌbꞌaka cꞌa jucꞌan ruchiꞌ ri yaꞌ, ri discípulos xa xmastaj chica chi xquicꞌuaj simíta. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Y ri Jesús xuꞌej chica ri ru-discípulos: Tibꞌanaꞌ cuenta-iviꞌ choch ri levadura quichin ri achiꞌaꞌ fariseos y ri achiꞌaꞌ saduceos. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ijejeꞌ xquiꞌej-ka pa cánima: Jajaꞌ xuꞌej quireꞌ ruma manak simíta xkacꞌam-pa, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ri Jesús can rataꞌn ri niquiꞌan pensar ri ru-discípulos, mareꞌ xuꞌej chica: ¿Karruma ixreꞌ ntiꞌan pensar chi ruma manak simíta xicꞌam-pa mareꞌ xinꞌej quireꞌ? Man icukubꞌan ta icꞌuꞌx viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cꞌa majaꞌ tiꞌka pan iveꞌ (tiꞌan entender) ri xinꞌej? ¿Man nalka ta chic pan iveꞌ antok xaꞌntzuk ri ivuꞌuoꞌ mil achiꞌaꞌ riqꞌuin ri vuꞌuoꞌ simíta y janeꞌ (jaroꞌ) chacach ximol can? ");
INSERT INTO cakSNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Man nalka ta jeꞌ pan iveꞌ antok xaꞌntzuk ri icajeꞌ mil riqꞌuin ri siete (vukuꞌ) simíta y janeꞌ (jaroꞌ) chacach ximol can? ");
INSERT INTO cakSNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Karruma ixreꞌ man xiꞌka ta pan iveꞌ (man xiꞌan ta entender) chi inreꞌ man xichꞌoꞌ ta chirij ri simíta ri ximastaj can? Ri xinꞌej inreꞌ chiva, ja chi tibꞌanaꞌ cuenta-iviꞌ choch ri levadura quichin ri achiꞌaꞌ fariseos y ri achiꞌaꞌ saduceos, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cꞌajareꞌ ri discípulos xiꞌka pa quiveꞌ (xquiꞌan entender) chi man nuꞌej ta chi tiquibꞌanaꞌ cuenta-quiꞌ choch ri levadura ri nicusas riqꞌuin ri simíta. Xa choch ri niquicꞌut ri achiꞌaꞌ fariseos y ri achiꞌaꞌ saduceos. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y ri Jesús junan quiqꞌuin ri ru-discípulos xalka jun lugar ri cꞌo cierca ri tanamet Cesarea richin ri Filipo; y xucꞌutuj chica ri ru-discípulos: ¿Chica niquiꞌej ri achiꞌaꞌ chirij ri Xtak-pa chicaj chi xalax chiꞌicajol; chi chica jajaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ijejeꞌ xquiꞌej cha: Icꞌo ncaꞌeꞌn chi jajaꞌ ri Juan el Bautista. Icꞌo nicꞌaj chic niquiꞌej chi jajaꞌ ri Elías. Icꞌo jeꞌ ri ncaꞌeꞌn chi jajaꞌ ri Jeremías o jun chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y jajaꞌ xucꞌutuj chica: ¿Y ixreꞌ, in chica inreꞌ ntiꞌej? ");
INSERT INTO cakSNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro ja xuꞌej cha ri Jesús: Atreꞌ ri Cristo, ri Rucꞌajuol ri cꞌaslic Dios, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y joꞌc xraꞌxaj quireꞌ ri Jesús, can ja xuꞌej cha: Atreꞌ Simón Pedro ri at rucꞌajuol ri Jonás, can jaꞌal caquicuot; ruma ri xaꞌej, man vinak ta xꞌeꞌn chava, xa ja ri Nataꞌ ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Y nivajoꞌ niꞌej chava: Atreꞌ Pedro abꞌeꞌ; y paroꞌ ri abꞌaj nem reꞌ xtinpabꞌa-ve ri nu-iglesia. Y ri camic man xtitiquir ta chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Can pan akꞌaꞌ atreꞌ xtinya-ve chi najak ri puerta chiquivach ri ncaꞌuoc chupan ri reino ri cꞌo chicaj; rumareꞌ nojiel ri xtaxim o xtaquir vaveꞌ choch-ulief, can quireꞌ jeꞌ xtiꞌan cha chila chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y ri Jesús xuꞌon mandar chica ri ru-discípulos chi man jun choj cha tiquiꞌej-ve chi jajaꞌ ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Y chupan ri tiempo reꞌ ri Jesús xutzꞌom cꞌa rutzijoxic chiquivach ri ru-discípulos, chi nicꞌatzin chi niꞌa pa tanamet Jerusalén y nukꞌasaj qꞌuiy sufrimiento pa quikꞌaꞌ ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, pa quikꞌaꞌ ri principales sacerdotes y pa quikꞌaꞌ ri achiꞌaꞌ escribas; y xtiquimisas, pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ri Pedro xucꞌuaj jubꞌaꞌ aparte ri Jesús, y xuchꞌolij y xuꞌej cha: Man ta xtirajoꞌ ri Dios chi xtibꞌanataj incheꞌl ri xaꞌej chavij atreꞌ Ajaf, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero antok ri Jesús xraꞌxaj quireꞌ, xtzuꞌn-apa riqꞌuin y xuꞌej cha ri Pedro: ¡Catiel-el chinoch Satanás! Atreꞌ xa ncatuoc kꞌatoy-nubꞌiey. Ruma ri naꞌan pensar atreꞌ xa junan riqꞌuin ri niquiꞌan pensar ri vinak y man incheꞌl ta ri nrajoꞌ ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y ri Jesús xchꞌoꞌ chica ri nicꞌaj chic ru-discípulos y xuꞌej: Vi xa cꞌo jun nrajoꞌ niꞌa chuvij, man tuꞌon ri nurayij jajaꞌ, y can tutzꞌamaꞌ y tucꞌuaj ri ru-cruz. Xa quireꞌ nuꞌon, otz tipa viqꞌuin chi niꞌa chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ruma xa cꞌo jun ri altíra nrajoꞌ ri rucꞌaslien vaveꞌ choch-ulief, man xticolotaj ta. Pero ri jun, mesque niquimisas vuma inreꞌ, can xtiril ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ruma ¿chica nuchꞌec jun vinak xa nicꞌujieꞌ ta riqꞌuin nojiel ri bꞌayomal ri cꞌo choch-ulief y xa man nicolotaj ta? Mesque altíra bꞌayomal cꞌo riqꞌuin, pero man nitiquir ta nulokꞌ ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ruma ri Xtak-pa chicaj chi xalax chiꞌicajol can xtipa chic jun bꞌay, y junan chic rukꞌij riqꞌuin ri Rutataꞌ y xcaꞌpa jeꞌ ri ru-ángeles riqꞌuin. Y ja xtuyaꞌ rucꞌaxiel chica chiquijunal conforme ri xquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Y can ketzij ri niꞌej chiva, chi ri Xtak-pa chicaj chi xalax chiꞌicajol, can xtipa riqꞌuin chic rukꞌij, y icꞌo jujun chivach ixreꞌ ri man xcaꞌcon ta yan, cꞌa xtiquitzꞌat-na reꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y antok kꞌaxnak chic vakiꞌ kꞌij, ri Jesús xaꞌruchaꞌ ri Pedro, ri Jacobo y ri Juan ri quichakꞌ-quinimal-quiꞌ y xaꞌrucꞌuaj cꞌa ri iyoxeꞌ reꞌ paroꞌ jun juyuꞌ nem. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Y ri Jesús xcꞌaxtaj rutzubꞌal chiquivach. Ri rutzubꞌal can xchꞌichꞌan incheꞌl ri kꞌij. Y ri rutziak can altíra sak xuꞌon, can incheꞌl ri luz. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y antok ri iyoxeꞌ discípulos xquitzꞌat, icꞌo yan chic ri Moisés y ri Elías, ncaꞌtzijuon riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y ri Pedro xuꞌej cha ri Jesús: Ajaf, otz chi ojcꞌo vaveꞌ ojreꞌ. Xa atreꞌ navajoꞌ, nakaꞌan oxeꞌ chꞌitak enramadas; jun avichin atreꞌ, jun richin ri Moisés y jun richin ri Elías. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Y cꞌa nichꞌoꞌ ri Pedro cha ri Jesús, antok jun mukul can nichꞌichꞌan xka-pa pa quiveꞌ. Y chupan ri mukul reꞌ, cꞌo Jun ri xchꞌo-pa y xuꞌej: Jareꞌ ri Nucꞌajuol; altíra nivajoꞌ y niquicuot vánima riqꞌuin. Can tivaxaj ri nuꞌej jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y antok ri iyoxeꞌ discípulos xcaꞌxaj reꞌ, xaꞌxuquieꞌ y xquikasaj-ka ri quijaluon cꞌa pan ulief. Y altíra xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y ri Jesús xjiel-apa quiqꞌuin ri ru-discípulos, xaꞌrutzꞌom-ka y xuꞌej chica: Quixpalaj y man tixiꞌij-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Antok ri discípulos xaꞌtzuꞌn chic apa, man jun chic más xquitzꞌat, xa ruyuon chic ri Jesús cꞌo can. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y antok ijejeꞌ i-xulan-pa choch ri juyuꞌ, ri Jesús xuꞌon mandar chica ri ru-discípulos: Man jun choj cha tiꞌej ri xitzꞌat. Otz ntiꞌej pero cꞌa antok ri Xtak-pa chicaj chi xalax chiꞌicajol ya cꞌastajnak chic pa chiquicajol ri quiminakiꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Entonces ri discípulos xquicꞌutuj cha ri Jesús: ¿Karruma niquiꞌej ri achiꞌaꞌ escribas chi nicꞌatzin chi ja ri Elías nipa naꞌay? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xuꞌej chica: Can ketzij chi ri Elías nipa naꞌay y nalruchojmij nojiel ri nicꞌatzin chi nichojmix. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero inreꞌ niꞌej chiva chi ri Elías ya xpa, y man xquinaꞌiej ta chica reꞌ. Can nojiel ri xcajoꞌ, can quireꞌ xquiꞌan cha. Y can quireꞌ xtiquiꞌan jeꞌ cha ri Xtak-pa chicaj chi xalax chiꞌicajol, can xtuꞌon sufrir pa quikꞌaꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y cꞌajareꞌ ri discípulos xiꞌka pa quiveꞌ (xquiꞌan entender) chi ri Jesús chirij ri Juan el Bautista xchꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Antok ri Jesús y ri iyoxeꞌ discípulos xaꞌlka pacheꞌ quimaluon-quiꞌ iqꞌuiy vinak, cꞌo jun ache xalka riqꞌuin ri Jesús y xalxuquieꞌ choch. Ri ache xuꞌej cha ri Jesús: ");
INSERT INTO cakSNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyovaj roch ri nucꞌajuol, ruma jajaꞌ altíra nuꞌon sufrir ruma ri ataque, y qꞌuiy mul tzaknak pa kꞌakꞌ y pa yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xincꞌam-pa chi xalyaꞌ chiquivach ri a-discípulos, pero ijejeꞌ man xaꞌtiquir ta xquiꞌan sanar, xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús xuꞌej: ¡Man jun vinak chupan ri tiempo vacame ruyoꞌn ta ránima riqꞌuin ri Dios, xa quinojiel i-sachnak! ¿Ixreꞌ ntiꞌan pensar chi inreꞌ nojiel kꞌij xquicꞌujieꞌ iviqꞌuin? ¿Y janeꞌ (jaroꞌ) tiempo xquixcochꞌ? Ticꞌama-pa ri alaꞌ vaveꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús cof xchꞌoꞌ cha ri itziel espíritu y xuꞌej cha chi tiel-el y ja xiel riqꞌuin ri alaꞌ. Y ri alaꞌ can ja chupan ri huora reꞌ xuꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y antok ri Jesús y ri ru-discípulos quiyuon chic icꞌo can, xaꞌpa ijejeꞌ xquicꞌutuj cha: ¿Karruma ojreꞌ man xojtiquir ta xkalasaj-el ri itziel espíritu? ");
INSERT INTO cakSNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xuꞌej chica: Man xixtiquir ta xivalasaj-el ruma man can ta icukubꞌan icꞌuꞌx riqꞌuin ri Dios. Y can ketzij ri niꞌej chiva: Xa ta icukubꞌan icꞌuꞌx riqꞌuin ri Dios, mesque incheꞌl-oc jun chꞌiti ijaꞌtz richin ri mostaza, ntiꞌej cha la juyuꞌ la chi tiel-el vaveꞌ y takꞌax chic jun lugar, y can xtakꞌax y man jun cꞌa kax ri man ta xquixtiquir xtiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ri jun clase espíritu reꞌ ntiel-el, joꞌc riqꞌuin ayuno y oración, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y antok ri Jesús y ri ru-discípulos icꞌo chic Galilea, xpa ri Jesús xuꞌej chic jun bꞌay chica: Ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach pa quikꞌaꞌ ri vinak, ");
INSERT INTO cakSNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","y xtiquiquimisaj, pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ. Y antok ri discípulos xcaꞌxaj ri xuꞌej ri Jesús, can altíra xaꞌbꞌisuon. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y antok ri Jesús y ri ru-discípulos xaꞌlka pa tanamet Capernaum, ri ncaꞌmalo ri impuestos xaꞌlka riqꞌuin ri Pedro y xquicꞌutuj cha: ¿Ri I-Maestro nutoj ri caꞌyeꞌ dracmas? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y ri Pedro xuꞌej: Nutoj. Y antok ri Pedro xuoc pa jay, ja ri Jesús xbꞌachꞌo-pa cha naꞌay y xuꞌej cha: ¿Chica naꞌej atreꞌ Simón Pedro? ¿Ri reyes ri icꞌo choch-ulief, choj chica niquicꞌutuj ri impuestos y ri contribuciones? ¿Chica ri calcꞌual o chica ri man calcꞌual ta? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Y ri Pedro xuꞌej cha ri Jesús: Ri reyes chica ri man i-calcꞌual ta niquicꞌutuj-ve, xchaꞌ. Y ri Jesús xuꞌej: Ja ri calcꞌual ri manak niquitoj. ");
INSERT INTO cakSNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero xa man nakatoj ta, xa man xtiꞌka ta pa quiveꞌ (man xtiquiꞌan ta entender) karruma man nakatoj ta. Caꞌin cꞌa chuchiꞌ ri mar chi natzꞌamaꞌ car; y ri naꞌay car ri xtavalasaj-pa, tajakaꞌ pa ruchiꞌ y chireꞌ xtavil-ve ri miera chi natoj ri impuesto ri vichin inreꞌ y ri avichin atreꞌ, xchaꞌ ri Jesús cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y chupan ri tiempo reꞌ ri discípulos xaꞌjiel-apa riqꞌuin ri Jesús, y xquicꞌutuj cha: ¿Chica ri más nem xtuꞌon chupan ri ru-reino ri Dios? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y ri Jesús xrayuoj jun acꞌual y xuyaꞌ pa nicꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Y jajaꞌ xuꞌej chica ri ru-discípulos: Can ketzij ri niꞌej chiva, chi xa man nticꞌax ta ri inoꞌj, y xa man ntiꞌan ta incheꞌl jun acꞌual, man xquixuoc ta chupan ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Joꞌc ri nunaꞌ chi man jun oc rukꞌij incheꞌl ri jun acꞌual reꞌ, jareꞌ ri más nem rukꞌij xticꞌujieꞌ pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Y chica-na ri nuꞌon recibir jun acꞌual incheꞌl va pa nubꞌeꞌ, xa can inreꞌ nquiruꞌon recibir. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Xa cꞌo ta jun ri in-runiman mesque manak-oc rukꞌij y nipa jun chic vinak y nuꞌon cha ri jun reꞌ chi nitzak, ri nibꞌano quireꞌ más otz nixim jun nem abꞌaj (caꞌ) chukul y nicꞌak-ka cꞌa chuxieꞌ ri mar. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Juyeꞌ quivach ri vinak ri icꞌo choch-ulief, ruma icꞌo ri ncaꞌbꞌano chica chi ncaꞌtzak chupan pecado! Can cꞌo-ve chi quireꞌ niquicꞌul choch-ulief. ¡Pero can juyeꞌ roch ri vinak ri nibꞌano cha jun chic chi nitzak chupan pecado! ");
INSERT INTO cakSNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Rumareꞌ xa jun akꞌaꞌ o jun avakan ri nibꞌano chava chi ncatzak, más otz takupij-el y tacꞌaka-el. Ruma más otz jun oc akꞌaꞌ o jun oc avakan cꞌo ncatuoc chupan ri cꞌaslien ri man niqꞌuis ta, que cꞌo caꞌyeꞌ akꞌaꞌ y caꞌyeꞌ avakan y xa ncayoꞌx chupan ri kꞌakꞌ ri man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y xa jun anakꞌavach ri nibꞌano chava chi ncatzak, más otz tavalasaj-el y tacꞌaka-el. Ruma más otz jun oc anakꞌavach cꞌo ncatuoc chupan ri cꞌaslien ri man niqꞌuis ta, que cꞌo caꞌyeꞌ anakꞌavach y xa ncayoꞌx chupan ri infierno, ri kꞌakꞌ ri man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man tiꞌan chica chi man jun quikalien ri man jun oc quikꞌij, ruma chivach ixreꞌ can i-coꞌl-oc. Inreꞌ niꞌej chiva chi ijejeꞌ icꞌo ángeles ri ncaꞌchajin quichin, y ri ángeles reꞌ can siempre icꞌo riqꞌuin ri Nataꞌ ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y ri Xtak-pa chicaj chi xalax chiꞌicajol, can xpa chi ncaꞌrucanuj y chi ncaꞌrucol ri i-sachnak chupan ri pecado. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Tibꞌanaꞌ pensar otz ri xtinꞌej chiva. Xa jun ache icꞌo ta i-cien ru-ovejas y nisach ta can jun, ¿man ncaꞌruyaꞌ ta came can bꞌaꞌ ri i-noventa y nueve y niꞌa pa tak kꞌayis chucunuxic ri jun ri sachnak can? ");
INSERT INTO cakSNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y xa ri ache reꞌ nirila-pa ri jun ru-oveja ri sachnak can, can ketzij niꞌej chiva chi jajaꞌ más niquicuot riqꞌuin ri ru-oveja ri nirila-pa que chiquivach ri i-noventa y nueve ri man xaꞌsach ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Can quireꞌ nibꞌanataj riqꞌuin ri Itataꞌ ri cꞌo chicaj, can man nrajoꞌ ta jajaꞌ chi nisach ta can jun vinak chupan ri pecado, mesque manak-oc rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Xa cꞌo jun hermano cꞌo jun kax itziel ri nuꞌon chava, ayuon caꞌin riqꞌuin y taꞌej cha ri xuꞌon chava. Y xa nraꞌxaj ri naꞌej cha, can xachꞌec ri hermano. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero xa man ncaraꞌxaj ta, caꞌvucꞌuaj jun o icaꞌyeꞌ testigos aviqꞌuin, chi quireꞌ chiquivach ijejeꞌ naꞌej cha ri hermano chi man otz ta ri xuꞌon chava. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y xa ri hermano man nrajoꞌ ta nraꞌxaj ri niquiꞌej cha, taꞌej cha ri iglesia. Y xa man nraꞌxaj ta ri nuꞌej ri iglesia cha, entonces tabꞌanaꞌ cha incheꞌl jun maloy-impuestos o incheꞌl jun vinak ri man runiman ta ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y can ketzij niꞌej chiva, chi nojiel ri xtixim vaveꞌ choch-ulief, can xtinxim chila chicaj, y ri xtiquir vaveꞌ choch-ulief, can xtinquir chila chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Niꞌej jeꞌ chiva: Xa choch-ulief icꞌo icaꞌyeꞌ hermanos ri ncaꞌcꞌujieꞌ de acuerdo chi niquicꞌutuj chica-na kax, ri Nataꞌ Dios ri cꞌo chicaj can xtuya-pa ri nicꞌutux cha cuma ri icaꞌyeꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ruma pacheꞌ na quimaluon-quiꞌ icaꞌyeꞌ o iyoxeꞌ pa nubꞌeꞌ inreꞌ, can incꞌo inreꞌ chiquicajol, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y ri Pedro can ja xjiel-apa riqꞌuin ri Jesús y xuꞌej cha: Ajaf, ¿janeꞌ (jaroꞌ) mul niꞌan perdonar ri nu-hermano ri nuꞌon itziel chuva? ¿Siete (vukuꞌ) mul came niꞌan perdonar? xchaꞌ ri Pedro cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri Jesús xuꞌej cha ri Pedro: Inreꞌ man niꞌej ta chava chi joꞌc siete (vukuꞌ) mul otz naꞌan perdonar jun av-hermano ri nuꞌon itziel chava. Inreꞌ niꞌej chava chi hasta setenta veces siete naꞌan perdonar ri av-hermano. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ri reino ri cꞌo chicaj can junan riqꞌuin ri xuꞌon jun rey ri xrajoꞌ xunaꞌiej janeꞌ (jaroꞌ) quicꞌas chiquijunal ri rusamajiel. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y antok ri rey reꞌ xutzꞌom rubꞌanic ri cuentas, cꞌo jun rusamajiel xpabꞌax choch ri cꞌo diez (lajuj) mil talentos rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Y ruma ri samajiel reꞌ man nitiquir ta nutzoliej ri rucꞌas, ri rey xuꞌej chi ticꞌayix ri samajiel, ri raxjayil y ri ralcꞌual. Y ticꞌayix jeꞌ nojiel ri kax richin, chi quireꞌ nitzalaj ri rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ri samajiel can ja xxuquie-ka pan ulief choch ri rey, y altíra nuꞌon rogar cha. Ri samajiel nuꞌej cha ri rey: Tabꞌanaꞌ favor quinavoyoꞌiej chic bꞌaꞌ. Inreꞌ can xtintzoliej chava nojiel ri nucꞌas, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rey ri rajaf ri samajiel, can altíra xujoyovaj roch, rumareꞌ xutzokopij-el y xuꞌon perdonar ri rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero antok xiel-pa ri samajiel reꞌ, xbꞌarucꞌuluꞌ cꞌa jun chic samajiel ri cꞌo rucꞌas rubꞌanun riqꞌuin jajaꞌ. Ri rucꞌas ri rubꞌanun ri jun rachꞌil riqꞌuin xa cien denarios oc, pero jajaꞌ xutzꞌom chukul ri rachꞌil y can ja nujitzꞌ-ka pa rukul y nuꞌej cha: Tayaꞌ cꞌa ri acꞌas ri abꞌanun viqꞌuin, nichaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y ri rachꞌil ja xxuquie-ka chukul rakan, y can nucꞌutuj favor cha, y nuꞌej: Quinavoyoꞌiej chic bꞌaꞌ y inreꞌ xtintzoliej nojiel chava, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ri ache samajiel ri cꞌo cꞌas bꞌanun riqꞌuin, man xka ta choch ri xꞌeꞌx cha y rumareꞌ xucꞌuaj y xuyaꞌ pa cárcel, hasta cꞌa nutzoliej-na ri rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y ri nicꞌaj chic aj-samajiel antok xquitzꞌat nojiel ri xbꞌanataj, can altíra xaꞌbꞌisuon-ka. Y ijejeꞌ xaꞌa riqꞌuin ri rey ri cajaf y xbꞌaquitzijuoj nojiel ri xuꞌon ri jun samajiel riqꞌuin ri jun chic. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y ri rey xutak royoxic ri samajiel ri man otz ta xuꞌon y xuꞌej cha: Atreꞌ xa at jun itziel nusamajiel. Inreꞌ xinꞌan perdonar nojiel ri acꞌas, ruma xaꞌan rogar chinoch. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Karruma man xajoyovaj ta roch ri avachꞌil pa samaj, incheꞌl ri xinꞌan inreꞌ aviqꞌuin chi xinjoyovaj avach? ");
INSERT INTO cakSNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y ri rey, ri cajaf ri aj-samajiel, xpa royoval, y xujach-el ri itziel rusamajiel pa quikꞌaꞌ ri achiꞌaꞌ chi xquitzꞌapij pa cárcel, hasta cꞌa nutzoliej-na nojiel ri rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Can quireꞌ xtuꞌon ri Nataꞌ Dios ri cꞌo chicaj iviqꞌuin ixreꞌ, xa man riqꞌuin ta nojiel ivánima ntiꞌan perdonar ri iv-hermano antok cꞌo itziel niquiꞌan chiva, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y antok ri Jesús xtanieꞌ chubꞌixic ri tzij reꞌ, xꞌa y xuyaꞌ can ri lugar reꞌ, ri rubꞌinan Galilea. Jajaꞌ xꞌa cꞌa Judea, y xakꞌax jucꞌan ri río Jordán. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Can iqꞌuiy vinak ri xaꞌa chirij, y xaꞌruꞌon sanar ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y jareꞌ antok nicꞌaj achiꞌaꞌ fariseos xaꞌlka riqꞌuin chi niquiꞌan tentar. Y rumareꞌ xquicꞌutuj cha: ¿Otz chi jun ache nujach-riꞌ riqꞌuin ri raxjayil ruma chica-na kax? ");
INSERT INTO cakSNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: ¿Man ibꞌanun ta leer chupan ri ruchꞌabꞌal ri Dios ri nuꞌej chi pa rutzꞌucbꞌal, ri Dios ache y ixok xaꞌruꞌon? ");
INSERT INTO cakSNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y xuꞌej: Rumareꞌ ri ache xcaꞌruyaꞌ can ri rutie-rutataꞌ y xtiquicꞌan-quiꞌ riqꞌuin ri raxjayil, y ri icaꞌyeꞌ xa joꞌc jun xtiquiꞌan. Quireꞌ nuꞌej ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y rumareꞌ man chic icaꞌyeꞌ ta, xa joꞌc jun xtiquiꞌan. Ruma cꞌa reꞌ, lo que ri Dios xuꞌon jun cha, ri ache man tujach roch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y ijejeꞌ xquicꞌutuj cha ri Jesús: ¿Karruma ri Moisés xuꞌon mandar chi xa jun ache nrajoꞌ nujach-riꞌ riqꞌuin ri raxjayil, tubꞌanaꞌ jun carta ri pacheꞌ nuꞌej-ve chi nujach-riꞌ riqꞌuin y tuyaꞌ can? ");
INSERT INTO cakSNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xuꞌej chica: Ruma cof ibꞌanun cha ri ivánima, rumareꞌ ri Moisés xuꞌon permitir chi jun ache cꞌo cheꞌl nujach-riꞌ riqꞌuin ri raxjayil; pero pa rutzꞌucbꞌal, man quireꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Y inreꞌ can niꞌej cꞌa chiva chi chica-na ache ri nujach-riꞌ riqꞌuin ri raxjayil y xa man ruma ta ri ixok rucꞌuan-riꞌ riqꞌuin jun chic ache, y nicꞌulieꞌ riqꞌuin jun chic ixok, ri ache reꞌ can nuꞌon pecado choch ri Dios. Y ri ache ri nicꞌulieꞌ riqꞌuin ri ixok ri jachuon-el, can nuꞌon jeꞌ pecado choch ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y ri discípulos xquiꞌej cha ri Jesús: Xa jun ache can richin xa jun tiempo ximil riqꞌuin ri raxjayil, más ta otz chi man ta nicꞌulieꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y ri Jesús xuꞌej chica ri ru-discípulos: Man quinojiel ta ncaꞌcovin niquiꞌan chi man ta ncaꞌcꞌulieꞌ, ruma man chica ta quinojiel yoꞌn-ve chi niquiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y icꞌo-na-ve alabꞌo, xa-jan antok xaꞌlax ja yan xaꞌkꞌalajin chi man xtiquicanuj ta quixjayil. Icꞌo jeꞌ alabꞌo ri man xtiquicanuj ta quixjayil, pero xa ruma xaꞌan operar. Y icꞌo jeꞌ alabꞌo ri man xtiquicanuj ta quixjayil, pero xa quiqꞌuin ijejeꞌ xpa-ve chi quireꞌ niquiꞌan rusamaj ri Dios y ncaꞌquitoꞌ ri ncaꞌuoc chupan ri reino ri cꞌo chicaj. Ri nunaꞌ chi nicovin nicꞌujieꞌ ruyuon, man tucanuj raxjayil, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y icꞌo acꞌolaꞌ ri xaꞌcꞌamar-pa choch ri Jesús, chi nuyaꞌ rukꞌaꞌ pa quiveꞌ chi ncaꞌruꞌon bendecir. Pero ri discípulos xaꞌquichꞌolij ri vinak chi man tiquiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ri Jesús xuꞌej chica ri ru-discípulos: Tiyaꞌ permiso chica ri acꞌolaꞌ chi ncaꞌpa viqꞌuin inreꞌ, y man quiꞌikꞌat. Ruma ri reino ri cꞌo chicaj, xa quichin ri i-incheꞌl acꞌolaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y antok ri Jesús ruyoꞌn chic rukꞌaꞌ pa quiveꞌ ri acꞌolaꞌ chi xaꞌruꞌon bendecir, jajaꞌ xuyaꞌ can ri lugar reꞌ y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y cꞌo jun cꞌajol ache xalka riqꞌuin ri Jesús y xuꞌej: Utzulaj Maestro, ¿chica otz niꞌan chi nivil ri cꞌaslien ri man niqꞌuis ta? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y ri Jesús xuꞌej cha: ¿Karruma naꞌej otz chuva inreꞌ? Ruma man jun vinak otz, xa joꞌc Jun ri otz y reꞌ ja ri Dios. Xa atreꞌ navajoꞌ ncabꞌaka chupan ri cꞌaslien ri man niqꞌuis ta, can tabꞌanaꞌ ri nuꞌej ri mandamientos, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y xpa ri cꞌajol ache xucꞌutuj cha ri Jesús: ¿Chica ri mandamientos reꞌ? xchaꞌ. Y ri Jesús xuꞌej cha: Man caquimisan; ri at-cꞌulan, man tavucꞌuaj-aviꞌ riqꞌuin jun chic; man catalakꞌ; man tatzꞌak tzij chirij jun chic; ");
INSERT INTO cakSNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","caꞌbꞌanaꞌ respetar ri atie-atataꞌ; y can incheꞌl ri navajo-ka-aviꞌ atreꞌ, can quireꞌ jeꞌ mismo tavajoꞌ ri a-prójimo. Jareꞌ ri mandamientos, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y ri cꞌajol ache xuꞌej cha ri Jesús: Nojiel reꞌ cꞌa in coꞌl-oc nutzꞌamuon-pa rubꞌanic. ¿Chica nquirajoꞌ ri man nubꞌanun ta? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y ri Jesús xuꞌej cha: Xa navajoꞌ naꞌan nojiel, caꞌin, tacꞌayij ri cꞌo aviqꞌuin y ri rajal tajachaꞌ chiquivach ri i-puobra, chi quireꞌ nicꞌujieꞌ abꞌayomal chicaj. Y catam-pa viqꞌuin y ncaꞌa chuvij, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Antok ri cꞌajol ache xraꞌxaj ri tzij ri xuꞌej ri Jesús, nibꞌisuon ránima xꞌa, ruma altíra rubꞌayomal cꞌo. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Entonces ri Jesús xuꞌej chica ri ru-discípulos: Can ketzij niꞌej chiva, chi altíra cuesta chi jun bꞌayuon ntuoc pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Jun chic bꞌay niꞌej chiva: Xa más fácil nakꞌax jun camello chupan jun ruvaruol jun acúxa, que choch jun bꞌayuon chi ntuoc pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y antok ri ru-discípulos xcaꞌxaj ri tzij reꞌ, can más xaꞌchapataj, y niquiꞌej: ¿Chica cꞌa xticolotaj? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xaꞌrutzꞌat-apa ri ru-discípulos y xuꞌej chica: Ri vinak man nojiel ta ncaꞌtiquir niquiꞌan, pero ri Dios nojiel nitiquir nuꞌon, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y jareꞌ antok ri Pedro xuꞌej cha ri Jesús: Ojreꞌ kayoꞌn can nojiel ri cꞌo kiqꞌuin, y oj-bꞌanak chavij. ¿Y chica xtakachꞌec ojreꞌ rumareꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xuꞌej: Can ketzij ri niꞌej chiva, chi antok xtalka ri kꞌij chi nojiel xcaꞌuoc cꞌacꞌacꞌ, ri Xtak-pa chicaj chi xalax chiꞌicajol cꞌo chic rukꞌij, can xtitzꞌuyeꞌ pa ru-trono chi nuꞌon juzgar. Y ixreꞌ jeꞌ ri ix-bꞌanak chuvij, xquixtzꞌuyeꞌ pa doce (cabꞌalajuj) tronos chi ntiꞌan juzgar ri doce (cabꞌalajuj) tribus richin ri Israel. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y chica-na ri ruyoꞌn can rachuoch, o runimal, o ruchakꞌ, o ranaꞌ, o rutie-rutataꞌ, o raxjayil, o ralcꞌual o rulief vuma inreꞌ, can xtiyoꞌx cien veces más ri rucꞌaxiel cha. Y can xtiyoꞌx cha ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Pero iqꞌuiy ri icꞌo nabꞌayal, ri xcaꞌcꞌujieꞌ cꞌa pa ruqꞌuisbꞌal y iqꞌuiy ri icꞌo pa ruqꞌuisbꞌal xcaꞌcꞌujieꞌ nabꞌayal. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri reino ri cꞌo chicaj can junan riqꞌuin ri xuꞌon jun ache tataꞌj. Jajaꞌ cumaj yan xꞌa chi xaꞌrucanuj aj-samajiel chi xaꞌrutak pa rulief ri ruticuon uva choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Antok ri ache reꞌ xaꞌril ri aj-samajiel y antok chꞌovinak chic quiqꞌuin chi niquichꞌec jun denario ri kꞌij, cꞌajareꞌ xaꞌrutak-el pa rulief ri ruticuon uva choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Y como a las nueve laꞌk ri macꞌajan reꞌ, xiel chic ri ache y xaꞌrutzꞌat pa qꞌuiyiꞌal chi icꞌo ri man quiluon ta quisamaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Jajaꞌ xchꞌoꞌ chica y xuꞌej: Quixbꞌasamaj jeꞌ ixreꞌ pa vulief ri nuticuon uva choch, y inreꞌ xtinyaꞌ otz ivajal, xchaꞌ chica. Y ri aj-samajiel reꞌ can xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri rajaf ri ulief, xiel chic jun bꞌay como pa nicꞌaj-kꞌij, y quireꞌ jeꞌ xuꞌon como a las tres ri nakakꞌij. Jajaꞌ xaꞌrutak chic el nicꞌaj aj-samajiel pa rusamaj, y xuꞌej chica chi can xtuyaꞌ otz cajal. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y como a las cinco ri nakakꞌij, jajaꞌ xiel chic el jun bꞌay y xaꞌbꞌarilaꞌ nicꞌaj chic, y xuꞌej chica: ¿Karruma ixreꞌ man iviluon ta isamaj y choj xixcꞌujieꞌ jun kꞌij vaveꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y ri aj-samajiel reꞌ xquiꞌej cha: Man jun xyoꞌn kasamaj. Y ri rajaf ri ulief xuꞌej chica: Quixbꞌasamaj jeꞌ ixreꞌ pa vulief ri nuticuon uva choch, y xtinyaꞌ otz ivajal, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Antok xka-ka ri kꞌij, xpa ri rajaf ri ulief, xuꞌej cha ri ucꞌuay quichin ri samajiel: Caꞌvayuoj-pa quinojiel ri aj-samajiel y tatajo-el ri quikꞌij. Naꞌay caꞌtajoꞌ ri aj-samajiel ri xaꞌlka tarde, y después caꞌtajoꞌ ri xaꞌlka naꞌay, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Antok ri aj-samajiel ri xaꞌuoc pa samaj como a las cinco ri nakakꞌij, xaꞌlka chi ncaꞌtuoj; xaꞌtuoj jun denario. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y antok xaꞌlka ri aj-samajiel ri xaꞌuoc pa samaj naꞌay chi ncaꞌtuoj; xquiꞌan pensar chi más qꞌuiy ri xtiyoꞌx chica. Pero antok xaꞌtuoj, xa jun denario oc ri xyoꞌx chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Antok xquitzꞌat chi junan ri xyoꞌx chica, xquichꞌojij ri cajal cha ri ache tataꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri aj-samajiel reꞌ xquiꞌej: Ri samajiel ri xaꞌuoc pa samaj tarde, xa jun huora-oc xaꞌsamaj, y can junan xaꞌan chica kiqꞌuin ojreꞌ, y ojreꞌ jun kꞌij ri xojsamaj y xojcꞌujieꞌ chuxieꞌ rukꞌakꞌal ri kꞌij, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y ri rajaf samaj xuꞌej cha jun: Xa junan xaꞌntoj ri nicꞌaj chic samajiel, man jun itziel kax xinꞌan chava atreꞌ. Ruma quireꞌ xkaꞌej aviqꞌuin chi jun denario niyaꞌ chava. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Tavucꞌuaj ri avajal y caꞌin. Y chica ri samajiel ri xaꞌuoc pa samaj tarde, can pa vánima inreꞌ xalax-pa chi xinyaꞌ ri cajal incheꞌl ri avajal atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ruma nojiel ri cꞌo viqꞌuin inreꞌ, can pa nukꞌaꞌ inreꞌ cꞌo-ve richin niꞌan chica-na ri nivajoꞌ niꞌan cha. ¿O itziel nquinatzꞌat ruma niꞌan ri otz? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Quireꞌ cꞌa ri icꞌo nabꞌayal xcaꞌcꞌujieꞌ cꞌa pa ruqꞌuisbꞌal. Y ri icꞌo pa ruqꞌuisbꞌal xcaꞌcꞌujieꞌ nabꞌayal. Y mesque iqꞌuiy ri ncaꞌyox, pero man quinojiel ta xcaꞌchoꞌx chi nicꞌujieꞌ quikꞌij. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ri Jesús y ri i-doce (cabꞌalajuj) ru-discípulos y ri nicꞌaj chic vinak ri i-bꞌanak quiqꞌuin, quitzꞌamuon-el bꞌay chi ncaꞌa pa tanamet Jerusalén. Y jareꞌ antok ri Jesús xaꞌrucꞌuaj aparte ri ru-discípulos y xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Ixreꞌ ivataꞌn chi cꞌa pa tanamet Jerusalén nkuꞌa-ve-el, y chireꞌ xtijach-ve ri Xtak-pa chicaj chi xalax chiꞌicajol pa quikꞌaꞌ ri principales sacerdotes y pa quikꞌaꞌ ri achiꞌaꞌ escribas. Y ijejeꞌ xtiquiꞌej chi tiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y xtiquijach pa quikꞌaꞌ ri vinak ri man israelitas ta. Y ri vinak reꞌ xcaꞌtzeꞌn chirij, xtiquichꞌey y cꞌajareꞌ xtiquibꞌajij choch cruz. Pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y ri quitieꞌ ri icaꞌyeꞌ discípulos ri i-rucꞌajuol ri Zebedeo, xjiel-apa riqꞌuin ri Jesús i-rachꞌil ri ral. Y ri quitieꞌ xxuquie-ka choch ri Jesús chi nucꞌutuj jun favor cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xuꞌej cha ri quitieꞌ: ¿Chica ri navajoꞌ? xchaꞌ cha. Y ri ixok xuꞌej cha ri Jesús: Tabꞌanaꞌ chi ri icaꞌyeꞌ val reꞌ xcaꞌtzꞌuyeꞌ ta apa aviqꞌuin chupan ri a-reino; jun ta nicꞌujieꞌ pan a-derecha y jun ta pan av-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero ri Jesús xuꞌej: Ixreꞌ man ivataꞌn ta chica ri nticꞌutuj. ¿Nticochꞌ came ixreꞌ incheꞌl ri xtiꞌan chuva inreꞌ? ¿Y nticochꞌ came ixreꞌ ri sufrimiento ri xtinkꞌasaj inreꞌ? Y ri icaꞌyeꞌ discípulos reꞌ xquiꞌej: Nakacochꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xuꞌej chic chica: Can ketzij chi ixreꞌ xticochꞌ ri incheꞌl xtiꞌan chuva inreꞌ. Can xticochꞌ jeꞌ ri sufrimiento ri xtinkꞌasaj inreꞌ. Pero ri nticꞌutuj ixreꞌ, chi jun nitzꞌuyeꞌ pa nu-derecha y ri jun chic pa nu-izquierda, reꞌ man pa nukꞌaꞌ ta inreꞌ cꞌo-ve chi niyaꞌ chiva. Ja ri Nataꞌ ri ruꞌeꞌn choj chica xtuya-ve chi ncaꞌtzꞌuyeꞌ chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y antok ri i-diez (lajuj) chic discípulos xcaꞌxaj ri xꞌeꞌx, xpa quiyoval chica ri icaꞌyeꞌ discípulos ri quichakꞌ-quinimal-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero ri Jesús xaꞌrayuoj ri ru-discípulos y xuꞌej chica: Ixreꞌ jaꞌal ivataꞌn chi vaveꞌ ri choch-ulief, ri ncaꞌbꞌano gobernar, ruma icꞌo ri vinak pa quikꞌaꞌ, rumareꞌ niquinaꞌ chi ijejeꞌ ri i-cajaf. Y quireꞌ jeꞌ ri principales, nicajoꞌ chi caꞌnimax y can tiꞌan nojiel ri niquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero chiꞌicajol ixreꞌ man quireꞌ ta. Ruma xa cꞌo jun ri nrajoꞌ nuꞌon nem chiꞌicajol ixreꞌ, nicꞌatzin chi nquixruꞌon servir. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xa jun chivach ixreꞌ nrajoꞌ chi jajaꞌ ri naꞌay, can quixrubꞌanaꞌ servir. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Can tubꞌanaꞌ incheꞌl nuꞌon ri Xtak-pa chicaj chi xalax chiꞌicajol. Jajaꞌ man xpa ta chi niꞌan servir, sino chi nuꞌon servir, y chi nuyaꞌ rucꞌaslien chi quireꞌ iqꞌuiy ri ncaꞌcolotaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Antok ri Jesús y ri ru-discípulos ja ncaꞌiel-el chupan ri tanamet Jericó, altíra iqꞌuiy vinak ri xaꞌa chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Icꞌo icaꞌyeꞌ muoy i-tzꞌuyul chuchiꞌ ri bꞌay, y antok xcaꞌxaj chi ri Jesús nakꞌax chireꞌ, ijejeꞌ riqꞌuin quichukꞌaꞌ xaꞌchꞌoꞌ y xquiꞌej: ¡Ajaf, ri at Rumáma can ri rey David, tajoyovaj kavach! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y ri vinak xaꞌquichꞌolij chi man chic caꞌchꞌo-pa, pero ijejeꞌ xa riqꞌuin más quichukꞌaꞌ xaꞌchꞌo-pa y xquiꞌej: ¡Ajaf, ri at Rumáma can ri rey David, tajoyovaj kavach! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y ri Jesús xaꞌraꞌxaj, rumareꞌ xpiꞌie-ka, xaꞌrayuoj y xuꞌej chica: ¿Chica ntivajoꞌ chi niꞌan? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ijejeꞌ xquiꞌej cha ri Jesús: Ajaf, ojreꞌ nakajoꞌ nkutzuꞌn, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús ruma altíra xujoyovaj quivach ri icaꞌyeꞌ muoy, ja xutzꞌom-apa ri quinakꞌavach. Y ijejeꞌ ja xaꞌtzuꞌn, y xaꞌa chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Y antok ri Jesús y ri ru-discípulos y ri nicꞌaj chic vinak ri i-bꞌanak quiqꞌuin ya xaꞌbꞌaka Betfagé, ri cꞌo choch ri juyuꞌ Olivos, ri cꞌo cierca ri tanamet Jerusalén, ri Jesús xaꞌrutak-el icaꞌyeꞌ ru-discípulos, ");
INSERT INTO cakSNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","y xuꞌej-el chica: Quixꞌin chupan la aldea la y xtivil jun alaj burro cꞌo riqꞌuin ri rutieꞌ ri ximil. Tiquira-pa ri rutieꞌ y quiꞌcꞌama-pa viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y xa cꞌo jun ri cꞌo chica ri xtuꞌej-pa chiva, tiꞌej cha: Nicꞌatzin cha ri Ajaf, pero chaꞌnin xcaꞌlrujachaꞌ chic, quixchaꞌ can cha, xcha-el ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Riqꞌuin reꞌ nuꞌon cumplir incheꞌl ri tzꞌibꞌan can ruma ri jun profeta ri xcꞌujieꞌ ojier can tiempo. Ri rutzꞌibꞌan can jajaꞌ, nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiꞌej chica ri vinak ri icꞌo pa tanamet Sion: Ri I-Rey ja patanak iviqꞌuin. Can manak-oc rukꞌij rubꞌanun-pa, chꞌacol-pa chirij jun alaj burro. Ri alaj burro ral jun chicop richin akaꞌn. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y ri icaꞌyeꞌ discípulos xaꞌa, y xquiꞌan ri eꞌn-el chica ruma ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Y xaꞌquicꞌam-pa ri burro y ri ral riqꞌuin ri Jesús, y ri discípulos xquiya-el ri qui-manta chiquij, y xchꞌoquie-el ri Jesús chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y can iqꞌuiy ri vinak ri niquilicꞌ qui-manta pa rubꞌiey. Y nicꞌaj chic vinak xiquima-pa chꞌitak rukꞌaꞌ chieꞌ chi xquiyaꞌ pa rubꞌiey. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y ri vinak ri i-bꞌanak choch ri Jesús y ri icꞌo can chirij, can riqꞌuin nojiel quichukꞌaꞌ niquiꞌej: ¡Tiox bꞌaꞌ chi patanak ri Rumáma can ri rey David! ¡Bendito ri patanak pa rubꞌeꞌ ri Ajaf Dios! ¡Tiox bꞌaꞌ cha ri Dios ri cꞌo chicaj! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Y antok ri Jesús xuoc pa tanamet Jerusalén, ri vinak ri icꞌo chireꞌ xquimol-quiꞌ chaꞌnin chi niquitzꞌat. Y ri vinak reꞌ niquiꞌej: ¿Chica cꞌa ache la? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y icꞌo ri xaꞌeꞌn: La ja ri Jesús, ri profeta, ri rutanamit Nazaret, ri cꞌo Galilea, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y ri Jesús xuoc pa ru-templo ri Dios ri cꞌo pa tanamet Jerusalén. Y xaꞌrutarariej-el quinojiel ri ncaꞌcꞌayin y ri ncaꞌlakꞌo chireꞌ. Y xupajqꞌuij can ri qui-mesas ri niquicꞌax miera. Y quireꞌ jeꞌ xuꞌon cha ri quichꞌacat ri niquicꞌayij paluomix. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri Jesús xuꞌej chica ri vinak reꞌ: Chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can nuꞌej: Ri vachuoch, jay richin oración; pero ixreꞌ xa ibꞌanun cachuoch alakꞌomaꞌ cha, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Y antok ri Jesús cꞌo pa templo, icꞌo muoy y icꞌo ncaꞌjacajot xaꞌlka riqꞌuin y jajaꞌ xaꞌruꞌon-el sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero ri principales sacerdotes y ri achiꞌaꞌ escribas xpa quiyoval, ruma ri Jesús qꞌuiy milagros ri ncaꞌruꞌon, y ruma jeꞌ ri acꞌolaꞌ riqꞌuin quichukꞌaꞌ niquiꞌej chireꞌ pa templo: ¡Tiox bꞌaꞌ chi xalka ri Rumáma can ri rey David! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Y xquiꞌej cha ri Jesús: ¿Navaxaj ri niquiꞌej ri acꞌolaꞌ? Y ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Nivaꞌxaj. Y ixreꞌ, ¿man itzꞌatuon ta cꞌa chupan ri ruchꞌabꞌal ri Dios ri nuꞌej: Ri can ketzij ncaꞌyoꞌn rukꞌij ri Dios ja ri acꞌolaꞌ y ri cꞌa ncaꞌtzꞌuman? Quireꞌ nuꞌej ri ruchꞌabꞌal ri Dios, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y ri Jesús xaꞌruyaꞌ can chireꞌ ri achiꞌaꞌ reꞌ. Jajaꞌ xiel-el pa tanamet Jerusalén y xꞌa chupan ri aldea Betania. Chireꞌ xꞌa-ve chi xukꞌasaj ri akꞌaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y ri macꞌajan chucaꞌn kꞌij, antok rutzꞌamuon bꞌay chi nitzalaj pa tanamet Jerusalén, ri Jesús xnem-pa rupan. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y jajaꞌ xutzꞌat jun mata víquix cierca ri bꞌay. Xꞌa-apa chuxieꞌ chi xirucanuj roch, pero xa man jun roch cꞌo, xa ruyuon ruxak. Y ri Jesús xuꞌej cha ri chieꞌ: Man jun chic bꞌay xtayaꞌ avach. Y ri víquix reꞌ can chaꞌnin xchakej-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Antok ri ru-discípulos xquitzꞌat chi xchakej-ka ri jun mata víquix, xquiꞌej: ¿Cheꞌl xuꞌon chi chaꞌnin xchakej-ka ri jun mata víquix reꞌ? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Y ri Jesús xuꞌej chica: Can ketzij niꞌej chiva chi xa ixreꞌ can nticukubꞌaꞌ icꞌuꞌx riqꞌuin ri Dios y man nuꞌon ta caꞌyeꞌ icꞌuꞌx, can xquixtiquir ntiꞌan quireꞌ cha jun mata víquix. Y hasta cꞌo más ri nquixtiquir ntiꞌan. Nquixtiquir ntiꞌej cha la juyuꞌ la chi tiel-el y takꞌax chupan ri mar, y can quireꞌ xtibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Y nojiel ri xticꞌutuj cha ri Dios chupan iv-oración, xa ntinimaj, can niyoꞌx chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y antok ri Jesús cꞌo chic pa templo y nucꞌut chic ri ruchꞌabꞌal ri Dios chiquivach ri vinak, ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri vinak, xaꞌjiel-apa riqꞌuin y xquicꞌutuj cha: ¿Chica autoridad cꞌo pan akꞌaꞌ chi naꞌan nojiel reꞌ? ¿Y chica xyoꞌn autoridad chava? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ cꞌo jeꞌ jun kax ri nivajoꞌ nicꞌutuj chiva, y xa ixreꞌ xtiꞌej-pa chuva, inreꞌ jeꞌ xtinꞌej chiva chica autoridad cꞌo pa nukꞌaꞌ chi niꞌan nojiel reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Ri Juan xtak-pa ruma ri Dios chi xaꞌruꞌon bautizar ri vinak? ¿O xa achiꞌaꞌ xaꞌeꞌn cha? xchaꞌ ri Jesús. Entonces ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, xquiꞌej-ka chiquivach: Xa nakaꞌej chi ri Juan ja ri Dios ri takayuon-pa richin, ri Jesús xtuꞌej chika: ¿Karruma man xinimaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y xa nakaꞌej chi ja ri achiꞌaꞌ xaꞌeꞌn cha ri Juan chi tubꞌanaꞌ quireꞌ, man otz ta, ruma ojreꞌ nakaxiꞌij-kiꞌ chiquivach ri vinak, ruma quinojiel cataꞌn chi ri Juan jun profeta, xaꞌcha-ka chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y cꞌajareꞌ xquiꞌej-apa cha ri Jesús: Ojreꞌ man kataꞌn ta, xaꞌcha-apa. Y ri Jesús xuꞌej jeꞌ chica: Inreꞌ jeꞌ man xtinꞌej ta chiva chica autoridad cꞌo pa nukꞌaꞌ chi ncaꞌnꞌan quireꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Can tibꞌanaꞌ pensar otz ri xtinꞌej chiva. Cꞌo jun ache icꞌo icaꞌyeꞌ rucꞌojolaꞌ. Y ri quitataꞌ xuꞌej cha ri naꞌay: Nucꞌajuol, caꞌin vacame y cabꞌasamaj pacheꞌ nuticuon-ve uva, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pero jajaꞌ xuꞌej cha ri rutataꞌ: Vacame man nivajoꞌ ta nquibꞌasamaj, xchaꞌ. Pero después xalka paroꞌ chi man otz ta ri xuꞌej, y ja xꞌa pa samaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y ri quitataꞌ quireꞌ jeꞌ xuꞌej cha ri jun chic rucꞌajuol, chi tisamaj. Y ri rucꞌajuol reꞌ xuꞌej cha: Otz cꞌa táta, ja nquiꞌa, xchaꞌ. Pero xa man xꞌa ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ri Jesús xucꞌutuj: ¿Chica chiquivach ri icaꞌyeꞌ xbꞌano ri xrajoꞌ ri quitataꞌ? Y ri achiꞌaꞌ reꞌ xquiꞌej: Ja ri naꞌay, xaꞌchaꞌ. Y ri Jesús xuꞌej chica: Can ketzij niꞌej chiva, chi ja ri maloy-impuestos y ri rameras ri xcaꞌuoc naꞌay chivach ixreꞌ chupan ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Antok ri Juan el Bautista xpa, xucꞌut jun choj bꞌay chivach, pero ixreꞌ man xinimaj ta. Joꞌc ri maloy-impuestos y ri rameras ri xquinimaj. Pero ixreꞌ, mesque xitzꞌat reꞌ, man xtzalaj ta pa ivánima riqꞌuin ri Dios chi xinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Tivaxaj jun chic parábola (cꞌambꞌal-tzij), xchaꞌ ri Jesús chica ri vinak: Xcꞌujieꞌ jun ache tataꞌj; xpa jajaꞌ, xutic uva pa rulief, xucꞌajuoj rij, xuꞌon incheꞌl jun chꞌiti pila chupan ri ulief chi niyitzꞌ ri uva chupan, y xuꞌon jeꞌ jun torre. Cꞌajareꞌ xuyaꞌ can pa kajic chica nicꞌaj aj-samajiel, y jajaꞌ xꞌa naj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y antok xalka ri tiempo richin ri cosecha, ri rajaf ri ulief xaꞌrutak-pa ri rusamajiel quiqꞌuin ri i-kajayuon ri rulief richin chi nalquimaꞌ ri uva kajbꞌal richin ri ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ri achiꞌaꞌ ri i-kajayuon ri rulief xa man xaꞌquicꞌul ta otz ri aj-samajiel ri i-takuon-pa ruma ri rajaf ri ulief. Jun xquichꞌey, jun xquicꞌak cha abꞌaj y jun chic xquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ri rajaf ri ulief xaꞌrutak-pa nicꞌaj chic rusamajiel. Can más iqꞌuiy ri xaꞌrutak-pa. Pero ri achiꞌaꞌ ri i-kajayuon ri ulief ja mismo xquiꞌan chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruqꞌuisbꞌal, ri rajaf ri ulief xutak-pa ri rucꞌajuol y xuꞌej: Ri achiꞌaꞌ reꞌ can xtiquiꞌan respetar antok xtiquitzꞌat chi ja ri nucꞌajuol ri xtiꞌka quiqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ri achiꞌaꞌ reꞌ, antok xquitzꞌat chi ja ri rucꞌajuol ri rajaf ri ulief ri xalka, xquiꞌej-ka chiquivach: Jareꞌ ri xtuoc can rajaf nojiel ri ulief ri kakajuon, quixam-pa, kaquimisaj, chi quireꞌ pa kakꞌaꞌ ojreꞌ nicꞌujieꞌ can ri ulief, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y ja xquitzꞌom, y juviera ri ulief ri ticuon uva choch, xbꞌaquicꞌakaꞌ y xquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Antok xtipa ri rajaf ri ulief ri ticuon uva choch, ¿chica came xtuꞌon chica ri achiꞌaꞌ ri i-kajayuon ri ulief? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y ri vinak xquiꞌej: Ri rajaf ri ulief man xtujoyovaj ta quivach ri itziel tak achiꞌaꞌ ri i-kajayuon, can xcaꞌruquimisaj; y ri rulief xtuyaꞌ chic pa kajic chica nicꞌaj chic aj-samajiel ri can xtiquiyaꞌ ri uva kajbꞌal richin ri ulief antok nalka ri tiempo, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ri Jesús xuꞌej chica: ¿Can man jun bꞌay cꞌa itzꞌatuon ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios? Ri nuꞌej: Ri Abꞌaj ri man xka ta chiquivach ri achiꞌaꞌ ri i-bꞌanoy-jay, xa jareꞌ ri xyoꞌx ri lugar ri más nicꞌatzin chi quireꞌ ri jay man nitzak ta. Ja ri Ajaf ri xbꞌano quireꞌ cha, y ojreꞌ man jun bꞌay katzꞌatuon chi nibꞌanataj quireꞌ. Quireꞌ nuꞌej ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y ruma cꞌa reꞌ niꞌej chiva chi ri ru-reino ri Dios xa xtalasas pan ikꞌaꞌ. Xa xtiyoꞌx chica nicꞌaj chic vinak ri quicꞌuan jun utzulaj cꞌaslien choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Chica-na vinak ri xtitzak choch va Abꞌaj va, can xtimulumuꞌ. Y chica-na vinak ri xtika va Abꞌaj va chirij, can xtuyitzꞌ cꞌa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y antok ri principales sacerdotes y ri achiꞌaꞌ fariseos caxan chic ri parábolas (cꞌambꞌal-tzij) ri xaꞌrutzijuoj ri Jesús, can xiꞌka pa quiveꞌ (xquiꞌan entender) chi xa chiquij ijejeꞌ xchꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y jareꞌ antok ijejeꞌ xcajoꞌ ta xquitzꞌom yan el. Pero man xquiꞌan ta, ruma niquixiꞌij-quiꞌ chiquivach ri vinak; ruma chiquivach ri vinak, ri Jesús can jun profeta. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Y ri Jesús xchꞌoꞌ chic chica ri vinak, y xaꞌrucusaj nicꞌaj chic parábolas (cꞌambꞌal-tzij). Jajaꞌ xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ri reino ri cꞌo chicaj can junan riqꞌuin jun namakꞌej ri xuꞌon jun rey antok xcꞌulieꞌ ri rucꞌajuol. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Y xaꞌrutak-el ri ru-siervos chi xaꞌbꞌacayuoj quinojiel ri i-rubꞌanun invitar richin ri cꞌulubꞌic. Pero ri i-bꞌanun invitar xquiꞌej-pa chi man ncaꞌpa ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y ri rey xaꞌrutak chic el nicꞌaj ru-siervos y xuꞌej-el chica: Tiꞌej chica quinojiel ri i-nubꞌanun invitar, chi nojiel cꞌo chic listo chi nkuvaꞌ. Ri nu-tuora y ri nicꞌaj chic vavaj ri i-tiꞌuoj chi ncaꞌcꞌatzin chupan ri kꞌij va, ya xaꞌquimisas. Can nojiel cꞌo chic, quixam-pa ri pa cꞌulubꞌic, quixchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ri i-bꞌanun invitar, man xaꞌniman ta chi xaꞌpa. Icꞌo xaꞌa pan avan, y icꞌo xaꞌbꞌacꞌayin y xaꞌbꞌalakꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y ri nicꞌaj chic, xa xaꞌquitzꞌom ri siervos ri i-rutakuon-el ri rey y xaꞌquiquimisaj; ruma chiquivach ijejeꞌ ri siervos reꞌ xa man jun quikalien. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Antok xraꞌxaj ri rey ri xbꞌanataj, xyacataj royoval. Rumareꞌ xaꞌrutak ru-soldados chiquij chi xaꞌruqꞌuis ri aj-quimisaniel, y chi xparox jeꞌ ri quitanamit. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Cꞌajareꞌ ri rey xchꞌoꞌ chic chica ri ru-siervos y xuꞌej: Can ketzij chi nojiel cꞌo chic chi niꞌan ri cꞌulubꞌic, pero ri xaꞌnꞌan invitar man ncaꞌrucꞌul ta chi xaꞌlka. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Quixꞌin pa tak bꞌay ri ncaꞌiel-el pa tanamet, quiꞌivayuoj-pa quinojiel ri xquiꞌvil chi ncaꞌpa chupan ri cꞌulubꞌic va, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y antok ri siervos xaꞌa pa tak bꞌay, xaꞌcayuoj-pa chica-na vinak, ri otz y ri man otz ta quicꞌaslien. Y ri jay pacheꞌ xꞌan-ve ri cꞌulubꞌic, xnuoj. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y ri rey xuoc chi xaꞌrutzꞌat quinojiel ri xaꞌrayuoj. Y jajaꞌ xutzꞌat chi cꞌo jun ache chireꞌ ri man rucusan ta ri tziak ri nicusas chupan ri cꞌulubꞌic. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ri rey xucꞌutuj cha ri ache reꞌ: Amigo, ¿cheꞌl xatuoc-pa vaveꞌ, ruma man ja ta ri tziak ri nicusas chupan ri cꞌulubꞌic acusan? xchaꞌ ri rey cha. Y ri ache manak kax xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Y jareꞌ antok ri rey xuꞌej chica ri ru-siervos: Tixima-el rukꞌa-rakan ri jun ache ri man rucusan ta ri tziak richin ri cꞌulubꞌic, tivalasaj-el y ticꞌakaꞌ pa kꞌakuꞌn. Chireꞌ xa xtituokꞌ y xtukꞌachꞌachꞌiej roray. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y mesque iqꞌuiy ri ncaꞌyox, man quinojiel ta xcaꞌchoꞌx, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y ri achiꞌaꞌ fariseos xaꞌa; y xquiꞌej chiquivach chi chica manera niquiꞌan cha ri Jesús chi nitzak pa quikꞌaꞌ riqꞌuin ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Y ijejeꞌ xaꞌquitak qui-discípulos y nicꞌaj ruvinak ri rey Herodes riqꞌuin ri Jesús; y antok xaꞌbꞌaka, xquiꞌej cha: Maestro, ojreꞌ kataꞌn chi joꞌc ri ketzij ri nika chavach y nacꞌut ri ruchꞌabꞌal ri Dios y can ja-ve rubꞌixic naꞌan cha, ruma atreꞌ man naxiꞌij ta aviꞌ choch jun vinak mesque altíra rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ojreꞌ vacame nakajoꞌ nakaxaj ri chica xtaꞌej: ¿Otz nakatoj ri impuestos ri nuꞌej ri rey César, o xa man otz ta? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ri Jesús can rataꞌn ri man otz ta ri niquiꞌan pensar chirij, rumareꞌ jajaꞌ xuꞌej chica: Ixreꞌ xa caꞌyeꞌ ipalaj. ¿Karruma nquiniꞌan tentar? ");
INSERT INTO cakSNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ticꞌutu-pa ri moneda ri nicusas chi nituoj ri impuestos, xchaꞌ chica. Y ijejeꞌ xquicꞌut-apa jun denario choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y jajaꞌ xucꞌutuj chica: ¿Choj palaj y choj bꞌeꞌ ri cꞌo choch? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y ijejeꞌ xquiꞌej cha: Richin ri rey César, xaꞌchaꞌ cha. Y ri Jesús xuꞌej chica: Tiyaꞌ cꞌa cha ri César ri can richin ri César, y tiyaꞌ cha ri Dios ri can richin ri Dios, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y antok ri achiꞌaꞌ reꞌ xcaꞌxaj ri xuꞌej ri Jesús, can vor chica xquinaꞌ. Y rumareꞌ ijejeꞌ xquiyaꞌ can ri Jesús y xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ri kꞌij reꞌ icꞌo achiꞌaꞌ saduceos xaꞌlka riqꞌuin ri Jesús. Ri achiꞌaꞌ reꞌ man niquinimaj ta chi ri quiminakiꞌ can xcaꞌcꞌastaj-pa, y rumareꞌ ijejeꞌ xquicꞌutuj cha ri Jesús: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Maestro, ri Moisés rutzꞌibꞌan can chika: Xa cꞌo jun ache nicon-el y xa man jun ralcꞌual nicꞌujieꞌ can, jun ruchakꞌ o runimal ticꞌulieꞌ riqꞌuin ri raxjayil, richin quireꞌ ncaꞌcꞌujieꞌ ralcꞌual ri quiminak chic el. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y ijejeꞌ xquiꞌej cꞌa: Xaꞌcꞌujieꞌ i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ chikacajol ojreꞌ. Ri naꞌay xcꞌulieꞌ, pero xcon-el y man jun ralcꞌual xcꞌujieꞌ can. Ri raxjayil xcꞌulieꞌ chic riqꞌuin jun ruchakꞌ ri ache ri xcon-el choch. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ri rucaꞌn, can quireꞌ jeꞌ mismo xuꞌon, jajaꞌ xcon-el y man jun ralcꞌual xcꞌujieꞌ can. Ri ruox, can quireꞌ jeꞌ mismo xuꞌon. Y quireꞌ xquiꞌan-el ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y antok i-quiminak chic el ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ, después xcon jeꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y ri achiꞌaꞌ saduceos xquicꞌutuj cha ri Jesús: Antok xtalka ri kꞌij chi xcaꞌcꞌastaj-pa ri quiminakiꞌ, ¿choj axjayil xtuoc ri ixok reꞌ? Ruma ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ xuoc caxjayil, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Entonces ri Jesús xuꞌej chica: Ixreꞌ xa ix-sachnak riqꞌuin ri xiꞌej. Man ivataꞌn ta ri nuꞌej ri ruchꞌabꞌal ri Dios. Y man ivataꞌn ta jeꞌ ri ru-poder ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ruma antok xtalka ri kꞌij chi ri quiminakiꞌ xcaꞌcꞌastaj-el, man xcaꞌcꞌulieꞌ ta chic, ni man xcaꞌyoꞌx ta chi xcaꞌcꞌulieꞌ. Ijejeꞌ xa xcaꞌuoc incheꞌl ri ru-ángeles ri Dios ri icꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero riqꞌuin ri quiminakiꞌ ri xcaꞌcꞌastaj-pa, ¿man itzꞌatuon ta cꞌa ri ruchꞌabꞌal ri Dios ri yoꞌn can pan ikꞌaꞌ? Chireꞌ ri Dios nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Inreꞌ in Ru-Dios ri Abraham, in Ru-Dios ri Isaac y in Ru-Dios ri Jacob. Quireꞌ xuꞌej ri Dios ojier can. Ri Dios man Qui-Dios ta ri quiminakiꞌ, xa Qui-Dios ri icꞌas, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y antok ri vinak caxan chic ri tzij ri xucꞌut ri Jesús, can vor chica xquinaꞌ, ruma man jun bꞌay caxan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Y ri achiꞌaꞌ fariseos can chaꞌnin xquimol-quiꞌ chi niquiꞌan pensar ri chica xtiquiꞌan, ruma xcaꞌxaj chi ri Jesús can xutzꞌapij quichiꞌ ri achiꞌaꞌ saduceos riqꞌuin ri xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpa jun chiquivach ri maestros richin ri ley, joꞌc chi nuꞌon tentar ri Jesús, xucꞌutuj cha: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Maestro, ¿chica chiquivach ri mandamientos ri xuyaꞌ ri Dios cha ri Moisés, ri más nem? ");
INSERT INTO cakSNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y ri Jesús xuꞌej cha: Can tavajoꞌ ri Avajaf Dios, tavajoꞌ riqꞌuin nojiel avánima, tavajoꞌ riqꞌuin nojiel ri acꞌaslien y tavajoꞌ jeꞌ riqꞌuin nojiel ri anoꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jareꞌ ri naꞌay y más nem mandamiento. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y cꞌo chic jun rucaꞌn mandamiento ri casi junan riqꞌuin ri naꞌay. Y ri mandamiento reꞌ nuꞌej: Can incheꞌl ri navajo-ka-aviꞌ atreꞌ, can quireꞌ jeꞌ mismo tavajoꞌ ri a-prójimo. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ri caꞌyeꞌ mandamientos reꞌ jareꞌ rucꞌuꞌx nojiel ri ley ri xuyaꞌ ri Dios cha ri Moisés y nojiel ri quiꞌeꞌn can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y antok cꞌa quimaluon-quiꞌ ri achiꞌaꞌ fariseos, xpa ri Jesús xucꞌutuj chica: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","¿Chica ntiꞌan pensar ixreꞌ chirij ri Cristo? ¿Choj ralcꞌual jajaꞌ? Y ri achiꞌaꞌ fariseos xquiꞌej: Ralcꞌual ri rey David, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xuꞌej chica: ¿Pero karruma ri rey David xuꞌej Vajaf cha ri Cristo? Ruma ja ri Espíritu Santo ri xꞌeꞌn cha, y rumareꞌ xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Ajaf Dios xuꞌej cha ri Vajaf: Catzꞌuyeꞌ pa nu-derecha, hasta cꞌa xcaꞌnyaꞌ ri av-enemigos chuxieꞌ avakan. Quireꞌ xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y xa ri rey David xuꞌej Vajaf cha ri Cristo, ¿karruma niꞌeꞌx chi ri Cristo xa choj jun rumáma can ri rey David? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun chic cꞌa xꞌeꞌn-apa jun tzij cha ri Jesús chirij ri xucꞌutuj chica. Can ja kꞌij reꞌ antok man jun chic xutzꞌom rucovil chi cꞌo ta ri chica xucꞌutuj más cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y ri Jesús xchꞌoꞌ chiquivach ri vinak y chiquivach ri ru-discípulos, jajaꞌ xuꞌej cꞌa: ");
INSERT INTO cakSNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Pa rucꞌaxiel ri Moisés, icꞌo can ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rumareꞌ, ixreꞌ can tinimaj quitzij y tibꞌanaꞌ nojiel ri niquiꞌej chiva. Pero man tiꞌan incheꞌl ri niquiꞌan ijejeꞌ, ruma ijejeꞌ xa man niquiꞌan ta ri niquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ijejeꞌ nimaꞌk tak akaꞌn niquiyaꞌ chiquij ri vinak, ri altíra calal y can cuesta ncaꞌcꞌuax. Ri akaꞌn reꞌ joꞌc chiquij ri vinak niquiya-ve, pero ijejeꞌ man niquisiluoj ta ni xa ta cha jun ruve-quikꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Nojiel ri niquiꞌan ijejeꞌ, joꞌc chi caꞌtzꞌiet y caꞌnaꞌax cuma ri vinak chi ja ri otz ri niquiꞌan. Y can nika chiquivach nitzꞌibꞌas jujun versículo ri ruchꞌabꞌal ri Dios choch jun tzꞌun y niquiyaꞌ chupan jun chic tzꞌun, y can nem niquiꞌan cha y niquicꞌuaj chirij ri quikꞌaꞌ y chiꞌquivach. Y más nimaꞌk niquiꞌan cha ri ru-fleco ruchiꞌ ri quitziak. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Can ja ri naꞌay tak chꞌacat nicajoꞌ pa tak vaꞌen y pa tak sinagogas. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Can altíra nika chiquivach chi ncaꞌan saludar ri pacheꞌ niquimol-ve-quiꞌ qꞌuiy vinak. Y can altíra nika chiquivach chi niꞌeꞌx chica cuma ri vinak: Rabí, Rabí. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero ixreꞌ man tivajoꞌ chi niꞌeꞌx Rabí chiva, ruma xa joꞌc Jun ri otz niꞌeꞌx Maestro cha, y reꞌ ja ri Cristo. Y ixvonojiel ixreꞌ xa hermanos-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Y man cꞌa tiꞌej katataꞌ cha jun vinak ri vaveꞌ choch-ulief chi ntiyaꞌ rukꞌij. Ruma ri Katataꞌ joꞌc Jun, y reꞌ ja ri Katataꞌ ri cꞌo chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ni man tiyaꞌ lugar chi ri vinak niquiꞌej maestros chiva. Ruma xa joꞌc Jun ri Maestro cꞌo y reꞌ ja ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ruma ri cꞌo más rukꞌij chiꞌicajol ixreꞌ, nicꞌatzin chi nquixruꞌon servir. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ruma ri niquinaꞌ chi can cꞌo quikꞌij, xa xtikasas quikꞌij. Pero ri niquinaꞌ chi manak-oc quikꞌij, xtiyoꞌx quikꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! ruma ikꞌatuon quibꞌiey ri vinak chi man ncaꞌuoc ta chupan ri reino ri cꞌo chicaj. Man nquixuoc ta ixreꞌ y man ntiyaꞌ ta jeꞌ lugar chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ruma ixreꞌ can ntimaj nojiel kax quichin ri malcaꞌn-ixokiꞌ, y chi tinimax chi jaꞌal icꞌaslien, can nquixlayuj ntiꞌan orar. Y rumareꞌ más nem ri castigo ri xtika pan iveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ruma ixreꞌ can nquixꞌa paroꞌ mar y can nquixꞌin choch ri roch-ulief chi nquiꞌcanuj vinak chi ncaꞌa chivij, y niquinimaj ri ntinimaj ixreꞌ. Pero antok iviluon chic, man otz ta ntiꞌan chica; ruma ri nticꞌut chiquivach, can ntiꞌan chica chi niquiyaꞌ can ri Dios, can ntiꞌan chica chi caꞌmul más i-richin ri infierno que chivach ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Juyeꞌ ivach ixreꞌ ri nquixꞌeꞌn chi ix ucꞌuay-bꞌay y xa ix muoy! Ixreꞌ ri nquixꞌeꞌn: Xa cꞌo jun ri nuꞌon jurar pa rubꞌeꞌ ri templo, mesque man nuꞌon ta ri ruꞌeꞌn, can man jun ruchꞌoꞌj. Pero ri nuꞌon jurar pa rubꞌeꞌ ri oro ri cꞌo pa templo, can tubꞌanaꞌ ri ruꞌeꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ixreꞌ can ix-nacanak y ix muoy jeꞌ, ruma ¿chica ri más cꞌo rukꞌij? ¿Ja came ri oro ri cꞌo pa templo o ja ri templo ri nibꞌano santificar ri oro ri cꞌo chireꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ixreꞌ ntiꞌej jeꞌ: Ri nuꞌon jurar pa rubꞌeꞌ ri altar, mesque man nuꞌon ta ri ruꞌeꞌn, man jun ruchꞌoꞌj. Pero ri nuꞌon jurar pa rubꞌeꞌ ri sipan can choch ri altar, can tubꞌanaꞌ ri ruꞌeꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Can ix-nacanak y can ix muoy, ruma ¿chica ri más cꞌo rukꞌij? ¿Ja came ri sipan ri cꞌo choch ri ru-altar ri Dios o ja ri altar ri nibꞌano santificar ri sipan? ");
INSERT INTO cakSNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri nuꞌon jurar pa rubꞌeꞌ ri altar, xa man joꞌc ta pa rubꞌeꞌ ri altar nuꞌon-ve jurar. Xa can pa rubꞌeꞌ jeꞌ ri sipan ri cꞌo can choch ri altar. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri nuꞌon jurar pa rubꞌeꞌ ri templo, xa man joꞌc ta pa rubꞌeꞌ ri templo nuꞌon-ve jurar, xa can pa rubꞌeꞌ ri Dios nuꞌon-ve jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri nuꞌon jurar pa rubꞌeꞌ ri rocaj, can nuꞌon jurar pa rubꞌeꞌ ri ru-trono ri Dios y pa rubꞌeꞌ ri Dios, ruma jajaꞌ tzꞌuyul chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ixreꞌ ntiyaꞌ ri diezmo richin ri alvaviena, ri anís y ri comino, pero iyoꞌn can ri más nicꞌatzin ri nuꞌej chupan ri ley, chi choj tibꞌanaꞌ quiqꞌuin ri vinak, tijoyovaj quivach y can ticukubꞌaꞌ icꞌuꞌx riqꞌuin ri Dios. Jareꞌ ri más nicꞌatzin chi ntiꞌan, después tiyaꞌ ri i-diezmo. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ixreꞌ nquixꞌeꞌn chi ix ucꞌuay-bꞌay, pero xa ix muoy, ruma xa ntichayuj can ri us y xa ntibꞌakꞌ ri camello. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Can juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ruma ixreꞌ ix incheꞌl ri vaso y ri plato ri jaꞌal chꞌajuon quij, pero ri quipan xa tzꞌil. Ri ivánima xa nojnak riqꞌuin alakꞌ, y xa bꞌanak chirij ri cꞌo quiqꞌuin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Ixreꞌ achiꞌaꞌ fariseos xa ix muoy! Can tibꞌanaꞌ cha ri icꞌaslien incheꞌl ri vaso y ri plato ri can sak rij y ri rupan jeꞌ. Tichꞌajaꞌ ri ivánima chi quireꞌ ri icꞌaslien xtiel sak. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ruma xa ix junan riqꞌuin ri panteón ri rij sak-sak, pero ri rupan man quireꞌ ta; xa ruyuon kꞌaynak cꞌo chupan, xa ruyuon rubꞌakil quiminak. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Can ix quireꞌ ixreꞌ. Ruma ixreꞌ can nticꞌut chi choj ri icꞌaslien chiquivach ri vinak, pero ri ivánima xa man quireꞌ ta choch ri Dios. Ri ivánima xa nojnak riqꞌuin itziel tak kax. Y can caꞌyeꞌ jeꞌ ipalaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! Ruma nquiꞌchojmij ri panteones ri pacheꞌ i-mukun-ve ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. Ixreꞌ can jaꞌal ncaꞌivak pacheꞌ i-mukun-ve ri utzulaj tak vinak ri choj quicꞌaslien choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y ixreꞌ ntiꞌej: Xa ta ojreꞌ xojcꞌujieꞌ pa qui-tiempo ri kateꞌt-kamamaꞌ, ojreꞌ man ta xaꞌkatoꞌ antok xaꞌquiquimisaj ri profetas. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero xa man ketzij ta ri ntiꞌej, ruma xa iyuon ixreꞌ nticꞌut-iviꞌ chi ix junan quiqꞌuin ri ivateꞌt-imamaꞌ ri xaꞌquimisan quichin ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Tiqꞌuisaꞌ cꞌa rubꞌanic ri xquitanabꞌaꞌ can ri ivateꞌt-imamaꞌ! ");
INSERT INTO cakSNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Ixreꞌ xa ix incheꞌl cumatz! Can man jun manera nquixtiquir nticol-iviꞌ choch ri infierno, xa cꞌa chireꞌ xquixbꞌaka-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Rumareꞌ inreꞌ ncaꞌntak profetas, achiꞌaꞌ ri altíra quinoꞌj y achiꞌaꞌ i-maestros. Pero icꞌo chiquivach ri xquiꞌbꞌajij choch cruz, y icꞌo ri xquiꞌquimisaj. Icꞌo xquiꞌchꞌey pa tak i-sinagogas; y chica-na tanamet ncaꞌa-ve ijejeꞌ, ixreꞌ jeꞌ xquixbꞌaka chireꞌ chi nquiꞌtarariej. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y ruma quireꞌ xtiꞌan, ixreꞌ nquixakan quicamic quinojiel ri choj tak vinak ri i-quimisan; ri xtiquir-pa riqꞌuin ri rucamic ri choj ache Abel, cꞌa riqꞌuin ri rucamic ri Zacarías, ri rucꞌajuol ri ache Berequías. Ri Zacarías ri xquimisas chucajol ri templo y ri altar. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ri xinꞌej chiva, can ketzij chi nojiel cꞌa ri camic reꞌ xtika pa quiveꞌ ri vinak ri icꞌo chupan ri tiempo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ri Jesús xuꞌej chiquij ri vinak ri icꞌo Jerusalén: Aj-Jerusalén, aj-Jerusalén, ¿karruma nquiꞌquimisaj ri profetas? ¿Karruma nquiꞌquimisaj cha abꞌaj ri ncaꞌrutak-pa ri Dios chiꞌicajol? Incheꞌl jun quitie-acꞌ ncaꞌrumol ri chꞌitak ral chuxieꞌ ri ruxicꞌ, inreꞌ qꞌuiy mul xinvajoꞌ xixmol ta viqꞌuin, pero ixreꞌ man xivajoꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Vacame ri ivachuoch xticꞌujieꞌ can abandonado. ");
INSERT INTO cakSNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Y ketzij niꞌej chiva chi man xquinitzꞌat ta chic, hasta cꞌa chupan ri kꞌij antok xtiꞌej: ¡Bendito ri patanak pa rubꞌeꞌ ri Ajaf Dios! xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y antok ri Jesús xiel-pa pa templo chi niꞌa, ri ru-discípulos xaꞌjiel-apa riqꞌuin y xquicꞌut choch ri chica quibꞌanic bꞌanun chica ri jay richin ri templo. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ri Jesús xuꞌej chica: ¿Ntitzꞌat nojiel va? Inreꞌ can ketzij niꞌej chiva, chi xtalka jun kꞌij antok nojiel va xcaꞌvulex. Quinojiel ri nimaꞌk tak abꞌaj ri i-cusan, can xcaꞌvulex, y man jun abꞌaj ri xticꞌujieꞌ can pa ru-lugar, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y antok ri Jesús tzꞌuyul chic paroꞌ ri juyuꞌ Olivos, ri ru-discípulos xaꞌjiel-apa riqꞌuin y xquicꞌutuj cha: Taꞌej chika, ¿jampeꞌ cꞌa xtibꞌanataj ri xaꞌej? ¿Y chica señal xtibꞌanataj chi quireꞌ ninaꞌax chi atreꞌ ncapa chic jun bꞌay, y ri ruqꞌuisbꞌal kꞌij richin ri tiempo va? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y ri Jesús xuꞌej chica: Tibꞌanaꞌ cuenta-iviꞌ chi man jun tibꞌano maña chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ruma iqꞌuiy ri xcaꞌpa y xtiquiꞌej: Inreꞌ ri Cristo, xcaꞌchaꞌ. Y iqꞌuiy ri xcaꞌquiꞌan maña chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y xtivaxaj chi nibꞌanataj guerras y xtivaxaj jeꞌ chi cꞌo guerras ri xcaꞌpa, pero man tixiꞌij-iviꞌ, ruma nicꞌatzin chi nojiel reꞌ xcaꞌbꞌanataj. Pero man ja ta yan reꞌ ri ruqꞌuisbꞌal kꞌij richin ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jun nación xtipalaj chirij jun chic nación y jun reino xtipalaj chirij jun chic reino. Xcaꞌpa yabꞌil, xtuꞌon viꞌjal y xtuꞌon jeꞌ nimaꞌk tak cubꞌrakan chica-na lugar. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y nojiel reꞌ xa cꞌa ja oc rutzꞌucbꞌal richin ri sufrimientos ri xcaꞌpa. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Y ixreꞌ xquixyoꞌx chupan sufrimiento y icꞌo chivach ixreꞌ ri xcaꞌquimisas. Can quinojiel vinak ri icꞌo choch-ulief itziel xquixquitzꞌat ruma iyoꞌn ivánima viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Iqꞌuiy xcaꞌtzak pa quicꞌaslien choch ri Dios, y xtiquisujuj-quiꞌ y icꞌo itziel xtiquitzꞌat-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y iqꞌuiy falsos profetas xcaꞌpalaj-pa y iqꞌuiy ri xcaꞌka pa quikꞌaꞌ, ruma xcaꞌquiꞌan engañar. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chupan jeꞌ ri tiempo reꞌ, ruma altíra chic qꞌuiynak ri itziel riqꞌuin cánima, iqꞌuiy ri man xticajoꞌ ta chic quiꞌ, xa itziel xtiquitzꞌat-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ri man xtitzalaj ta chirij y xtucochꞌ nojiel reꞌ hasta el fin, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Y xtitzijos cꞌa ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, choch nojiel ri roch-ulief, richin chi quinojiel vinak nicaꞌxaj. Y cꞌajareꞌ xtalka ri ruqꞌuisbꞌal kꞌij richin ri tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y antok xtitzꞌat chi xcaꞌbꞌanataj ri itziel tak kax chupan ri Lugar Santo, ja xtiqꞌuis ri lugar reꞌ, ri incheꞌl tzꞌibꞌan can ruma ri profeta Daniel, (ri nibꞌano leer, can tubꞌanaꞌ entender). ");
INSERT INTO cakSNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Entonces ri icꞌo Judea, caꞌnumaj-el pa tak juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri cꞌo paroꞌ ri rachuoch antok xtalka ri huora reꞌ, man tika-pa chi cꞌo niruma-pa chupan ri rachuoch, ");
INSERT INTO cakSNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","y ri cꞌo pan avan, man titzalaj-pa chirachuoch chi nalrumaꞌ ri ru-capa. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Can juyeꞌ quivach ri ixokiꞌ ri icꞌo encinta (embarazada) antok xtalka ri kꞌij reꞌ, y quireꞌ jeꞌ ri ixokiꞌ ri cꞌa niquiyaꞌ quitzꞌun ri quixuluꞌ! ");
INSERT INTO cakSNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Rumareꞌ, tibꞌanaꞌ orar chi antok xquixnumaj, man ta pa ru-tiempo jobꞌ o chupan jun kꞌij richin uxlanien, ");
INSERT INTO cakSNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ruma xtalka jun gran sufrimiento vaveꞌ choch-ulief ri man jun bꞌay quireꞌ rubꞌanun xa-jan antok bꞌanun-pa ri roch-ulief ruma ri Dios, ni xtalka chic jun bꞌay ri sufrimiento reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y xa ta ri Dios man ta nuꞌon coꞌl cha ri tiempo richin ri sufrimiento, man jun nicolotaj. Pero cuma ri i-ruchoꞌn chic, can xtuꞌon coꞌl cha ri tiempo reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupan ri kꞌij reꞌ, xa icꞌo ri xcaꞌeꞌn chiva: Titzꞌataꞌ, ja cꞌo vaveꞌ ri Cristo, o xa niquiꞌej chiva: Titzꞌataꞌ, ja cꞌo chila, man tinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ruma xcaꞌpa falsos cristos y falsos profetas. Ijejeꞌ xcaꞌquiꞌan nimaꞌk tak señales y milagros chi xtiquiꞌan maña chica ri vinak. Y ijejeꞌ nicajoꞌ xtiquiꞌan maña chica hasta ri i-choꞌn chic ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Can ja yan xinꞌej can chiva ri xcaꞌbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumareꞌ, xa niꞌeꞌx chiva: Titzꞌataꞌ, ja cꞌo chupan jun lugar pacheꞌ manak vinak, man cꞌa quixꞌa chutzꞌatic. Y xa niꞌeꞌx chiva: Titzꞌataꞌ, ja cꞌo chupan jun jay, man tinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ruma antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay, can xtikꞌalajin-ve jaꞌal. Can xtibꞌanataj cꞌa incheꞌl nuꞌon ri yocopaꞌ, ri nuꞌon cala pacheꞌ ntiel-pa ri kꞌij y cꞌa kꞌalaj pacheꞌ nika-ka ri kꞌij. Quireꞌ xtuꞌon jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Can xtibꞌanataj incheꞌl nibꞌanataj quiqꞌuin ri cꞌuch. Ruma ri chicop reꞌ ncaꞌka pacheꞌ cꞌo-ve jun quiminak. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y antok kꞌaxnak chic ri sufrimiento richin ri tiempo reꞌ, ri kꞌij man chic xtitzuꞌn ta, y ri icꞌ man xtuyaꞌ ta chic rusakil. Ri estrellas (chꞌumil) xcaꞌtzak-pa chicaj. Can nojiel cꞌa ri icꞌo chicaj xcaꞌsilos. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Entonces ri chicaj xtikꞌalajin ri ru-señal ri Xtak-pa chicaj chi xalax chiꞌicajol. Y quinojiel vinak ri icꞌo choch-ulief xcaꞌuokꞌ antok xtiquitzꞌat chi jajaꞌ ri nika-pa chupan mukul ri chicaj, riqꞌuin namalaj poder y namalaj rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y ri trompeta xtikꞌajan cof, y xcaꞌrutak ri ru-ángeles chi ncaꞌquimol ri i-ruchoꞌn chic. Can xcaꞌquimol quinojiel ri icꞌo oriente, ri icꞌo occidente, ri icꞌo norte y ri icꞌo sur. Can xcaꞌquimol quinojiel ri i-ruchoꞌn chic; chica-na lugar ri roch-ulief icꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Chirij ri víquix tivatamaj ri parábola (cꞌambꞌal-tzij): Antok ncaꞌjotoyin-pa ri rukꞌaꞌ y ncaꞌiel-pa ri ruxak, ivataꞌn chi ri ru-tiempo ri sakꞌij ya nalka. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y quireꞌ jeꞌ antok xtitzꞌat chi ncaꞌbꞌanataj nojiel ri xinꞌej, tivatamaj cꞌa chi ya nalka ri kꞌij reꞌ. Can cierca chic cꞌo-ve-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Can ketzij niꞌej chiva, chi nojiel reꞌ xtibꞌanataj antok ri vinak richin ri tiempo vacame cꞌa icꞌo ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ri roch-ulief y ri rocaj can xcaꞌqꞌuis. Pero ri nuchꞌabꞌal man xtiqꞌuis ta quireꞌ, xa can xtibꞌanataj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero ri kꞌij y ri huora antok xtipa chic, man jun taꞌmayuon. Ni xa ta ri ángeles ri icꞌo chicaj man cataꞌn ta jampeꞌ. Xa joꞌc ri Nataꞌ Dios taꞌmayuon reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Can incheꞌl xbꞌanataj pa ru-tiempo ri Noé, can quireꞌ jeꞌ xtibꞌanataj antok xtipa chic ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ruma pa ru-tiempo ri Noé, antok cꞌa majaꞌ tika ri diluvio; ri vinak xa bꞌanak cánima chirij ri chica niquitej y ri chica niquikun, ncaꞌcꞌulieꞌ y ncaꞌyoꞌx chi ncaꞌcꞌulieꞌ, y cꞌa quireꞌ niquiꞌan chupan ri kꞌij antok ri Noé xuoc chupan ri arca (ri incheꞌl jun nem barco). ");
INSERT INTO cakSNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y ri vinak man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) cꞌajaꞌ antok xpa cꞌa ri diluvio, y ri yaꞌ xaꞌrumuk quinojiel. Y quireꞌ xtibꞌanataj antok xtipa chic ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ri kꞌij reꞌ, icꞌo icaꞌyeꞌ achiꞌaꞌ ri junan ncaꞌsamaj pan avan, jun xtucꞌuax y ri jun chic xticꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Icꞌo icaꞌyeꞌ ixokiꞌ ri junan ncaꞌqueꞌn, jun xtucꞌuax y ri jun chic xticꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rumareꞌ, man timastaj chiva chi ntivoyoꞌiej-apa, ruma man ivataꞌn ta ri chica huora xtipa ri Ivajaf. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Pero tivatamaj cꞌa, xa ta ri rajaf-jay nunaꞌiej ri chica huora nalka ri alakꞌuon pa rachuoch, nicꞌasieꞌ chi nuchajij ri rachuoch, y man nuyaꞌ ta lugar cha ri alakꞌuon chi ntuoc-oc chi nalakꞌ-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Rumareꞌ, ixreꞌ quixcꞌujieꞌ preparados, ruma xtipa chic ri Xtak-pa chicaj chi xalax chiꞌicajol antok xa man ja ta reꞌ ntiꞌan pensar. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Can xtibꞌanataj incheꞌl ri nibꞌanataj riqꞌuin jun rajaf-jay, jajaꞌ xuyaꞌ can jun siervo ri choj y cꞌo runoꞌj pa quiveꞌ ri icꞌo pa rachuoch, chi nuyaꞌ nojiel ri nicꞌatzin chica chi niquitej antok nalka ri huora. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Can jaꞌal tiquicuot ri siervo reꞌ antok nalꞌilitaj ruma ri rajaf najin riqꞌuin ri samaj ri bꞌeꞌn can cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can ketzij niꞌej chiva, chi ri rajaf can xtuyaꞌ paroꞌ nojiel ri cꞌo riqꞌuin, chi nuꞌon cuenta. ");
INSERT INTO cakSNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero xa ta ri siervo reꞌ nuꞌon-ka itziel, y nuꞌej-ka pa ránima: Ri vajaf xa man nipa ta yan, nicha-ka; ");
INSERT INTO cakSNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y nutzꞌom quichꞌayic ri nicꞌaj chic siervos, y ruyuon vaꞌen nuꞌon y nikumun quiqꞌuin ri kꞌabꞌaralaꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","y jareꞌ ncaꞌruꞌon antok ri rajaf xtalka chupan jun kꞌij y jun huora antok jajaꞌ man royoꞌien ta y man rataꞌn ta, ");
INSERT INTO cakSNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ri rajaf can xtuyaꞌ jun nem castigo cha ri siervo reꞌ, y xtuyaꞌ quiqꞌuin ri xa caꞌyeꞌ quipalaj. Y chireꞌ xa okꞌiej xtuꞌon y can xtukꞌachꞌachꞌiej roray. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Entonces ri reino ri cꞌo chicaj xtuꞌon incheꞌl ri xbꞌanataj quiqꞌuin i-diez (lajuj) xtaniꞌ ri xquicꞌuaj qui-lámparas chi xbꞌaquiyoꞌiej ri alaꞌ ri nicꞌulieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ivuꞌuoꞌ cꞌa chiquivach ri xtaniꞌ can cꞌo quinoꞌj, y ri ivuꞌuoꞌ chic xa manak quinoꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri ivuꞌuoꞌ xtaniꞌ ri manak quinoꞌj, man xquicꞌuaj ta chic más qui-aceite chi niquinojsaj ri qui-lámparas; xa can joꞌc ri cꞌo-el chupan ri qui-lámparas. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ri ivuꞌuoꞌ chic xtaniꞌ ri can cꞌo quinoꞌj, xquicꞌuaj ri qui-lámparas y xquicꞌuaj qui-frascos quinojsan rupan chi aceite. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y ruma ri alaꞌ ri nicꞌulieꞌ man nalka ta yan, ri i-diez (lajuj) xtaniꞌ ri quiyoꞌien xaꞌyuxcuꞌr-ka y xaꞌvar-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Pa nicꞌaj-akꞌaꞌ, xcꞌaxax chi cꞌo ri nisiqꞌuin y nuꞌej: ¡Ja patanak ri alaꞌ ri xticꞌulieꞌ; quixiel-pa chi nticꞌuluꞌ! nichaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y ri i-diez (lajuj) xtaniꞌ reꞌ, ri quiyoꞌien ri alaꞌ ri xticꞌulieꞌ, can chaꞌnin xaꞌpalaj y xquichojmij ri qui-lámparas. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero ri ivuꞌuoꞌ xtaniꞌ ri manak quinoꞌj xquiꞌej chica ri ivuꞌuoꞌ chic xtaniꞌ ri can cꞌo quinoꞌj: Ri ka-lámparas xa can ncaꞌchup-ka ruma man qꞌuiy ta chic aceite chiquipan. Tiyaꞌ jubꞌaꞌ ka-aceite, xaꞌchaꞌ ri xtaniꞌ ri manak quinoꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero ri ivuꞌuoꞌ chic xtaniꞌ ri can cꞌo quinoꞌj, xquiꞌej: Xa nakayaꞌ ri ka-aceite chiva, man xkuruꞌon ta ojreꞌ ni ixreꞌ. Rumareꞌ más otz quixꞌin quiqꞌuin ri ncaꞌcꞌayin y tilakꞌoꞌ ivichin ixreꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y antok ri ivuꞌuoꞌ xtaniꞌ reꞌ cꞌa ja i-bꞌanak chulokꞌic ri aceite, ja xalka ri alaꞌ ri xticꞌulieꞌ. Ri ivuꞌuoꞌ xtaniꞌ ri can icꞌo-apa quiyoꞌien ri alaꞌ ri xticꞌulieꞌ, xaꞌuoc riqꞌuin ri alaꞌ pacheꞌ niꞌan-ve ri cꞌulubꞌic. Y xtzꞌapes can ri puerta. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y después xaꞌlka ri ivuꞌuoꞌ chic xtaniꞌ ri xbꞌaquilakꞌoꞌ qui-aceite richin ri qui-lámparas, y ijejeꞌ xquiꞌej-apa: ¡Ajaf, ajaf, tajakaꞌ ri puerta chakavach! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y jajaꞌ xuꞌej-pa chica ri xtaniꞌ reꞌ: Inreꞌ can ketzij niꞌej chiva, chi man vataꞌn ta ivach, xcha-pa chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ruma cꞌa reꞌ, man timastaj chiva chi ntivoyoꞌiej-apa, ruma man ivataꞌn ta ri chica kꞌij, ri chica huora antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ruma ri reino ri cꞌo chicaj, can junan riqꞌuin ri xuꞌon jun ache antok xꞌa naj. Jajaꞌ xaꞌrayuoj ri rusamajiel y xuyaꞌ can ri rubꞌayomal pa quikꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa rukꞌaꞌ jun xuyaꞌ can vuꞌuoꞌ talentos, pa rukꞌaꞌ jun chic xuyaꞌ can caꞌyeꞌ talentos, y pa rukꞌaꞌ jun chic xuyaꞌ can jun talento. Jajaꞌ jareꞌ xuyaꞌ can chica, ruma xutzꞌat chi jareꞌ ncaꞌtiquir ncaꞌsamaj chirij. Y can joꞌc xuꞌon can quireꞌ, ja xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y ri xyoꞌx can vuꞌuoꞌ talentos pa rukꞌaꞌ xꞌa, xsamaj chirij y xuchꞌec chic vuꞌuoꞌ más chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y quireꞌ jeꞌ xuꞌon ri xyoꞌx can caꞌyeꞌ talentos pa rukꞌaꞌ, jajaꞌ can xuchꞌec caꞌyeꞌ chic más chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ri ruox ri joꞌc jun talento ri xyoꞌx can cha, xꞌa y xbꞌarucꞌatoꞌ jun jul pan ulief y chireꞌ xumuk-ve ri miera. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Después antok kꞌaxnak chic qꞌuiy kꞌij, xtzalaj-pa ri ache ri cajaf ri samajiel reꞌ. Y jajaꞌ xucꞌutuj chica, janeꞌ (jaroꞌ) xquichꞌec chirij ri miera ri xuyaꞌ can chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Antok xalka ri yoꞌn can ri vuꞌuoꞌ talentos pa rukꞌaꞌ, can man joꞌc ta reꞌ ri rucꞌamun-pa, xa can rucꞌamun-pa vuꞌuoꞌ talentos más y xuꞌej: Ajaf, atreꞌ vuꞌuoꞌ talentos xayaꞌ can pa nukꞌaꞌ; ja-va, y cꞌo chic vuꞌuoꞌ más ri xinchꞌec chirij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ri rajaf xuꞌej cha: Otz ri xaꞌan. At jun utzulaj nusamajiel, can naꞌan ri niꞌeꞌx chava. Y ruma otz xaꞌan riqꞌuin ri jubꞌaꞌ xinyaꞌ can pan akꞌaꞌ, vacame xcanyaꞌ paroꞌ jun samaj más nem. Catuoc-pa y caquicuot jeꞌ viqꞌuin, xucheꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Antok xalka ri yoꞌn can ri caꞌyeꞌ talentos pa rukꞌaꞌ, xuꞌej: Ajaf, atreꞌ caꞌyeꞌ talentos xayaꞌ can pa nukꞌaꞌ; ja-va, y cꞌo chic caꞌyeꞌ más ri xinchꞌec chirij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri rajaf xuꞌej cha: Otz ri xaꞌan. At jun utzulaj nusamajiel, can naꞌan ri niꞌeꞌx chava. Y ruma can otz xaꞌan riqꞌuin ri jubꞌaꞌ xinyaꞌ can pan akꞌaꞌ, vacame xcanyaꞌ paroꞌ jun samaj más nem. Catuoc-pa y caquicuot jeꞌ viqꞌuin, xucheꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero antok xalka ri yoꞌn can ri jun talento pa rukꞌaꞌ, xuꞌej: Ajaf, inreꞌ can vataꞌn chi at jun ache altíra at ruquiy. Y navajoꞌ naꞌan cosechar ri xa man atreꞌ ta ri at-tiquiyuon y navajoꞌ nayac ri trigo ri xa man atreꞌ ta ri xabꞌano ri samaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y rumareꞌ inreꞌ xinxiꞌij-viꞌ. Can joꞌc xayaꞌ can chuva, xiꞌa y xincꞌot jun jul pan ulief y chireꞌ xinmuk-ve. Y ja a-miera va, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y ri rajaf xuꞌej cha: Atreꞌ at jun itziel samajiel, y at kꞌuor, man naꞌan ta ri niꞌeꞌx chava. Xa can avataꞌn chi inreꞌ nivajoꞌ niꞌan cosechar ri man inreꞌ ta in-tiquiyuon y nivajoꞌ niyac ri trigo ri xa man inreꞌ ta ri xibꞌano ri samaj; ");
INSERT INTO cakSNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xa avataꞌn chi in quireꞌ, xayaꞌ ta ri nu-miera pa banco y antok xitzalaj-pa, niꞌan ta recibir ri nu-miera y ri interés (ralabꞌal). ");
INSERT INTO cakSNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ticꞌama-el ri talento cha, y tiyaꞌ cha ri jun ri cꞌo diez (lajuj) talentos riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ruma ri can cꞌo riqꞌuin, xtiyoꞌx más cha y can qꞌuiy xtuꞌon-ka riqꞌuin. Pero ri xa man qꞌuiy ta cꞌo riqꞌuin, hasta reꞌ xtalasas-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri samajiel ri man jun nicꞌatzin-ve, icꞌakaꞌ pa kꞌakuꞌn, ri pacheꞌ ruyuon okꞌiej xtuꞌon y xtukꞌachꞌachꞌiej roray. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay, can cꞌo chic rukꞌij xtipa; y can quinojiel ri ru-ángeles xcaꞌpa riqꞌuin. Y xtitzꞌuyeꞌ chupan ri namalaj ru-trono. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Can xcaꞌmuol ri vinak choch, ri icꞌo nojiel naciones. Y xtujach quivach quinojiel, incheꞌl nuꞌon jun ache ri ncaꞌruchajij chicop; jajaꞌ jucꞌan ncaꞌruya-ve ri ovejas, y jucꞌan chic ncaꞌruya-ve ri cabras. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri vinak ri choj chic quicꞌaslien, jareꞌ ri i-incheꞌl ovejas, xcaꞌruyaꞌ pa ru-derecha. Pero ri vinak ri man otz ta ri quicꞌaslien, jareꞌ ri i-incheꞌl cabras, xcaꞌruyaꞌ pa ru-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Entonces ri Rey xtuꞌej chica ri icꞌo pa ru-derecha: Can quixam-pa ixreꞌ, can cꞌo chic ri ru-bendición ri Nataꞌ Dios pan iveꞌ. Quixcꞌujieꞌ chupan ri reino ri can ivichin ixreꞌ rubꞌanun preparar antok cꞌa majaꞌ cꞌo ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ruma antok inreꞌ xnem nupan, ixreꞌ cꞌo xiyaꞌ chuva chi xintej. Antok xchakej nuchiꞌ, ixreꞌ cꞌo xiyaꞌ chuva chi xinkun. Antok xcꞌatzin nu-posada, ixreꞌ xiyaꞌ chuva. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Antok manak chic nutziak chuvij, ixreꞌ can xiyaꞌ nutziak. Antok xiyavaj, xiniꞌan visitar. Antok xitzꞌapieꞌ pa cárcel, xixbꞌaka viqꞌuin, xtichaꞌ ri Rey. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Y ri choj chic quicꞌaslien xtiquiꞌej: Ajaf, ¿jampeꞌ xatkatzꞌat chi cꞌo viꞌjal xakꞌasaj y cꞌo xkayaꞌ chava chi xatej? ¿Jampeꞌ xatkatzꞌat chi xchakej achiꞌ y cꞌo xkayaꞌ chava chi xakun? ");
INSERT INTO cakSNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y jampeꞌ xkayaꞌ a-posada ruma xcꞌatzin chava? ¿Jampeꞌ xkayaꞌ atziak ruma man jun chic nacusaj? ");
INSERT INTO cakSNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampeꞌ xojbꞌaka aviqꞌuin antok xayavaj? ¿Y jampeꞌ jeꞌ xojbꞌaka aviqꞌuin antok atcꞌo pa cárcel? xcaꞌchaꞌ ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey xtuꞌej: Can ketzij cꞌa ri niꞌej chiva, ruma quireꞌ xiꞌan riqꞌuin ri nu-hermano ri can manak-oc rukꞌij, xa chuva inreꞌ xiꞌan-ve ri favor reꞌ, xtichaꞌ ri Rey. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y xtuꞌej jeꞌ ri Rey chica ri icꞌo pa ru-izquierda: Ixreꞌ malditos, quixiel-el chinoch y quixꞌin cꞌa pa kꞌakꞌ ri man nichup ta, ri bꞌanun preparar richin ri diablo y ri ru-ángeles. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ruma antok inreꞌ xnem nupan, man jun xiyaꞌ chuva chi xintej. Antok xchakej nuchiꞌ, ixreꞌ man jun xiyaꞌ chuva chi xinkun. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Antok xcꞌatzin nu-posada, ixreꞌ xa man xiyaꞌ ta chuva. Antok manak chic nutziak chuvij, ixreꞌ man jun xiyaꞌ chuva chi xincusaj. Antok xiyavaj, man xiniꞌan ta visitar; y quireꞌ jeꞌ antok xitzꞌapieꞌ pa cárcel, man xixbꞌaka ta viqꞌuin, xtichaꞌ ri Rey chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y ijejeꞌ xtiquiꞌej jeꞌ: Ajaf, ¿jampeꞌ xatkatzꞌat chi xakꞌasaj viꞌjal o xchakej achiꞌ, o xavajoꞌ a-posada, o man jun atziak, o xayavaj, o xacꞌujieꞌ pa cárcel, y man xkaꞌan ta favor chava? ");
INSERT INTO cakSNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y ri Rey xtuꞌej chica: Can ketzij cꞌa ri niꞌej chiva chi ruma man jun favor xiꞌan chica ri nu-hermanos ri manak-oc quikꞌij, xa man jun jeꞌ favor xiꞌan chuva inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y ri vinak reꞌ can xcaꞌa-ve chupan ri castigo ri man xtiqꞌuis ta. Y ri vinak choj chic ri quicꞌaslien xtiyoꞌx chica jun cꞌaslien ri man xtiqꞌuis ta. Quireꞌ ri xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Antok ri Jesús ruꞌeꞌn chic cꞌa nojiel reꞌ, jajaꞌ xuꞌej chica ri ru-discípulos: ");
INSERT INTO cakSNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Ixreꞌ ivataꞌn chi caꞌyeꞌ kꞌij apa cꞌo ri namakꞌej Pascua. Chupan ri namakꞌej reꞌ, ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach-el chi nibꞌajix choch cruz, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y ja huora reꞌ ri principales sacerdotes, ri achiꞌaꞌ escribas, y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri vinak, xquimol-quiꞌ chojay, chirachuoch ri sacerdote ri más cꞌo rukꞌij ri rubꞌinan Caifás. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ijejeꞌ xquiꞌej chiquivach ri chica maña xtiquicusaj chi nika ri Jesús pa quikꞌaꞌ y niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero xquiꞌej jeꞌ: Man nakatzꞌom ta chupan ri namakꞌej reꞌ, chi quireꞌ man ncaꞌpalaj ta pa ri vinak chikij, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y ri Jesús cꞌo chupan ri aldea Betania, chirachuoch ri Simón ri xcꞌachoj riqꞌuin ri yabꞌil lepra. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y xalka jun ixok riqꞌuin ri Jesús, rucꞌamun-pa jun frasco ri bꞌanun cha alabastro y cꞌo jun jubꞌul akꞌuon chupan ri can cara rajal; y xukꞌej pa rujaluon ri Jesús, antok tzꞌuyul chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Antok ri discípulos xquitzꞌat ri xuꞌon ri ixok, xpa quiyoval y xquiꞌej: ¿Karruma choj xutix ri jubꞌul akꞌuon la? ");
INSERT INTO cakSNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ruma ri jubꞌul akꞌuon reꞌ can cara rajal, xa ta xcꞌayix, ri rajal xjach ta chica ri i-puobra, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero ri Jesús chaꞌnin xraꞌxaj ri niquiꞌej, rumareꞌ jajaꞌ xuꞌej chica: ¿Karruma man nquixtanieꞌ ta ka nquixtzijuon chirij la ixok la? Jajaꞌ can otz ri xuꞌon chuva. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ruma ri i-puobra, can siempre icꞌo iviqꞌuin. Pero inreꞌ man siempre ta xquicꞌujieꞌ iviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ruma ri ixok reꞌ antok xukꞌej chirij ri nu-cuerpo ri jun jubꞌul akꞌuon reꞌ, jajaꞌ xiruꞌon preparar richin antok xquibꞌamuk. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Can ketzij ri niꞌej chiva, chi chica-na lugar xtitzijos-ve ri evangelio, chireꞌ jeꞌ xtitzijos-ve ri xuꞌon va ixok va. Can choch cꞌa nojiel ri roch-ulief xtitzijos-ve, y man jun bꞌay xtimastaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Entonces jun chiquivach ri i-doce (cabꞌalajuj) ru-discípulos ri Jesús, ri discípulo ri rubꞌinan Judas Iscariote, xꞌa quiqꞌuin ri principales sacerdotes. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Jajaꞌ xbꞌaruꞌej chica: ¿Chica ntiyaꞌ chuva, xa inreꞌ nijach ri Jesús pan ikꞌaꞌ? Y ijejeꞌ xquiꞌej chi niquiyaꞌ treinta monedas de plata cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y chupan ri kꞌij reꞌ, ri Judas Iscariote ja xutzꞌom cꞌa rucunuxic chica manera nuꞌon chi nujach ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chupan ri naꞌay kꞌij richin ri namakꞌej antok nicꞌux ri simíta ri manak levadura riqꞌuin, ri discípulos xbꞌaquicꞌutuj cha ri Jesús: ¿Pacheꞌ navajoꞌ naꞌan-ve ri vaꞌen chupan ri Pascua, chi quireꞌ nakachojmij nojiel ri nicꞌatzin? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y jajaꞌ xuꞌej chica ri discípulos: Quixꞌin pa tanamet Jerusalén, pa rachuoch jun ache, y tiꞌej cha: Ri Maestro ruꞌeꞌn-pa: Ri nu-tiempo xa cierca chic cꞌo-ve. Pan avachuoch atreꞌ nivajoꞌ niꞌan-ve ri vaꞌen richin ri Pascua quiqꞌuin ri nu-discípulos. Quireꞌ xuꞌej-el ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri discípulos can xquiꞌan incheꞌl ri eꞌn-el chica ruma ri Jesús. Y ijejeꞌ can xquichojmij nojiel ri nicꞌatzin chica richin ri Pascua reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Antok xcokꞌa-ka, ri Jesús y ri i-doce (cabꞌalajuj) ru-discípulos xaꞌtzꞌuye-apa chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y antok ncaꞌvaꞌ, ri Jesús xuꞌej: Can ketzij niꞌej chiva, chi jun chivach ixreꞌ ri xtijacho vichin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Y ri discípulos altíra xaꞌbꞌisuon-ka, y chiquijunal xquicꞌutuj-apa cha: ¿Inreꞌ came ri xquibꞌano quireꞌ Ajaf? ");
INSERT INTO cakSNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús xuꞌej chica: Ri jun ri xtuya-pa ri rukꞌaꞌ viqꞌuin chupan ri plato, jareꞌ ri xtijacho vichin. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Can ketzij chi ri Xtak-pa chicaj chi xalax chiꞌicajol can niꞌa. Can xtibꞌanataj-na-ve incheꞌl ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. ¡Pero juyeꞌ roch ri ache ri xtijacho richin! Más otz man ta xalax ri ache reꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y xchꞌo-apa ri Judas, ri xtijacho richin ri Jesús; y xuꞌej: ¿Inreꞌ came ri xquibꞌano quireꞌ Maestro? xchaꞌ. Y ri Jesús xuꞌej cha: Atreꞌ xaꞌeꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y antok cꞌa ncaꞌvaꞌ, ri Jesús xucꞌan-apa jun simíta y xuyaꞌ tiox bꞌaꞌ cha ri Dios, y xuper y xuyaꞌ chica ri ru-discípulos y xuꞌej chica: Titzꞌamaꞌ y ticꞌuxuꞌ ri simíta; ruma jareꞌ ri nu-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y ri Jesús xucꞌan-apa ri copa, y xuyaꞌ tiox bꞌaꞌ cha ri Dios, xuyaꞌ cꞌa chica ri ru-discípulos y xuꞌej chica: Tikumuꞌ ixvonojiel ri cꞌo chupan ri copa reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ruma jareꞌ ri nuquiqꞌuiel ri xtiꞌin antok xquiquimisas pa qui-cuenta iqꞌuiy vinak, chi quireꞌ iqꞌuiy ri xtiꞌan perdonar ri qui-pecados. Riqꞌuin ri nuquiqꞌuiel, ja xticꞌachoj ri cꞌacꞌacꞌ pacto ri rajoꞌn-pa ri Dios chi nuꞌon quiqꞌuin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Can niꞌej chiva chi man chic xtinkun ta ri ruyaꞌl ri uva, hasta cꞌa chupan ri kꞌij antok xtinkun jun cꞌacꞌacꞌ ruyaꞌl ri uva iviqꞌuin chupan ri ru-reino ri Nataꞌ, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y antok quibꞌixan chic jun bꞌix chi niquiyaꞌ rukꞌij ri Dios, ri Jesús y ri ru-discípulos xaꞌiel-el chireꞌ pa jay y xaꞌa choch ri juyuꞌ Olivos. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y antok i-bꞌanak, ri Jesús xuꞌej chica ri ru-discípulos: Ixvonojiel ixreꞌ xtiquiraj-el-iviꞌ y xquiniyaꞌ can nuyuon chupan va akꞌaꞌ va. Ruma chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can nuꞌej: Antok inreꞌ xtinyaꞌ lugar chi niquimisas ri nichajin quichin ri ovejas, ri ovejas xtiquiquiraj-el-quiꞌ. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero inreꞌ xa xquicꞌastaj-pa. Y después xquixvoyoꞌiej Galilea, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y ri Pedro xchꞌo-apa cha ri Jesús y xuꞌej: Mesque quinojiel xcatquiyaꞌ can ayuon, pero inreꞌ man xcanyaꞌ ta can, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ri Jesús xuꞌej cha: Inreꞌ can ketzij niꞌej chava chi chupan va akꞌaꞌ va, xa cꞌa majaꞌ titzirin-pa ri mamaꞌ, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xuꞌej cha: Mesque nicꞌatzin chi junan nquicon aviqꞌuin, pero man xtinꞌej ta chi man vataꞌn ta avach, xchaꞌ ri Pedro. Y quinojiel ri ru-discípulos quireꞌ jeꞌ xquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ri Jesús y ri ru-discípulos xaꞌlka chupan ri lugar rubꞌinan Getsemaní. Y ri Jesús xuꞌej chica ri ru-discípulos: Quixtzꞌuyeꞌ can vaveꞌ, inreꞌ xa cꞌa nquiꞌa-apa más chila chi nibꞌanaꞌ orar, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Y jajaꞌ joꞌc ri Pedro y ri icaꞌyeꞌ rucꞌajuol ri Zebedeo ri xaꞌrucꞌuaj riqꞌuin, y chirij jajaꞌ xpa jun nem bꞌis, ruma xunaꞌ yan ri nem sufrimiento ri xtukꞌasaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Rumareꞌ xuꞌej chica ri iyoxeꞌ ru-discípulos: Ri vánima altíra nibꞌisuon; can nquiruquimisaj ninaꞌ. Quixcꞌujieꞌ can vaveꞌ y quixcꞌasieꞌ viqꞌuin, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Jajaꞌ xꞌin chic apa jubꞌaꞌ y chireꞌ xxuquie-ka, y xukasaj-ka ri rujaluon cꞌa pan ulief chi xuꞌon orar; y quireꞌ xuꞌej: Nataꞌ, xa cꞌo ta cheꞌl chi man ta nikꞌasaj ri sufrimiento, pero man taꞌan ri nivajoꞌ inreꞌ, xa ja ri navajoꞌ atreꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y antok jajaꞌ xtanieꞌ riqꞌuin ri oración, xpa cꞌa quiqꞌuin ri iyoxeꞌ ru-discípulos, y xaꞌlrilaꞌ xa ncaꞌvar. Xpa jajaꞌ xuꞌej cha ri Pedro: ¿Can man xixtiquir ta xixcꞌasieꞌ jun huora viqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Quixcꞌasieꞌ y tibꞌanaꞌ orar richin chi man quixtzak chupan ri tentación. Inreꞌ vataꞌn chi ri iv-espíritu nrajoꞌ nuꞌon ri nrajoꞌ ri Dios, pero ri i-cuerpo manak ruchukꞌaꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y ri Jesús xꞌa chic apa jun bꞌay chi xirubꞌanaꞌ orar, y nuꞌej: Nataꞌ Dios, xa man jun manera chi inreꞌ man ta nikꞌasaj ri sufrimiento reꞌ, can tibꞌanataj ri navajoꞌ atreꞌ. Quireꞌ nuꞌej chupan ri ru-oración. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y antok jajaꞌ xpa chic jun bꞌay quiqꞌuin ri iyoxeꞌ ru-discípulos, xaꞌlrilaꞌ xa ncaꞌvar ruma man chic niquicochꞌ ta quivaran. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ri Jesús xaꞌruyaꞌ chic can jun bꞌay y xꞌa chic chi xirubꞌanaꞌ orar, chi oxeꞌ mul. Y ja mismo xucꞌutuj chupan ri oración. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Y cꞌajareꞌ ri Jesús xpa quiqꞌuin ri iyoxeꞌ ru-discípulos y xuꞌej chica: Vacame quixvar y quixuxlan. Ruma ja xalka ri huora chi ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach-el pa quikꞌaꞌ ri pecadores. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Quixpalaj. Joꞌ. Titzꞌataꞌ, ja patanak ri xtijacho vichin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y ri Jesús cꞌa nitzijuon, antok xalka ri Judas, ri jun chiquivach ri doce (cabꞌalajuj) discípulos; riqꞌuin jajaꞌ i-patanak iqꞌuiy vinak ri quicꞌamun-pa chieꞌ y espadas. Quinojiel i-takuon-el cuma ri principales sacerdotes y cuma jeꞌ ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri nijacho richin ri Jesús, can ruꞌeꞌn yan pa chica ri i-patanak riqꞌuin, ri chica xtuꞌon chi nucꞌut ri Jesús chiquivach. Jajaꞌ ruꞌeꞌn-pa chica: Ja ri jun ri xtintzꞌubꞌaj ruchiꞌ, jareꞌ ri Jesús, titzꞌamaꞌ cꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y ri Judas can ja xjiel-apa riqꞌuin ri Jesús y xuꞌej: ¡Co kꞌaꞌ Maestro! xchaꞌ cha. Y ja xutzꞌubꞌaj ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpa ri Jesús xuꞌej cha ri Judas: Amigo, ¿chica ri navajoꞌ naꞌan? xchaꞌ cha. Y jareꞌ antok xaꞌjiel-apa ri vinak riqꞌuin ri Jesús y xquitzꞌom. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun chiquivach ri icꞌo riqꞌuin ri Jesús, xralasaj-el ri ru-espada y xusoc ri ru-esclavo ri sacerdote ri más cꞌo rukꞌij, y xralasaj-el jun ruxiquin. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús xuꞌej cha ri xbꞌano quireꞌ: Tayacaꞌ la av-espada. Ruma ri niquimisan cha espada, can cha espada xtiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Acaso atreꞌ naꞌan pensar chi inreꞌ man nquicovin ta nicꞌutuj cha ri Nataꞌ Dios chi ncaꞌrutak-pa más de doce (cabꞌalajuj) legiones (72,000) de ángeles chi nquinquitoꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Pero cheꞌl nuꞌon cumplir ri i-tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios chi nicꞌatzin chi nibꞌanataj quireꞌ? xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chupan jeꞌ ri huora reꞌ ri Jesús xuꞌej chica ri vinak: ¿Ixreꞌ ix-patanak incheꞌl chirij jun alakꞌuon; mareꞌ icꞌamun-pa chieꞌ y espadas chi nquiniltzꞌamaꞌ? Can kꞌij-kꞌij xitzꞌuyeꞌ iviqꞌuin pa templo antok xincꞌut ri ruchꞌabꞌal ri Dios chivach, y man xinitzꞌom ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Pero nojiel reꞌ nibꞌanataj, richin nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. Y quinojiel ri discípulos xquiyaꞌ can ruyuon ri Jesús y xaꞌnumaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xaꞌbꞌatzꞌamo ri Jesús xquicꞌuaj cꞌa riqꞌuin ri Caifás ri sacerdote ri más cꞌo rukꞌij, pacheꞌ quimaluon-ve-quiꞌ ri achiꞌaꞌ escribas y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y ri Pedro bꞌanak chirij, pero cꞌa naj cꞌo can y xuoc jeꞌ chirachuoch ri sacerdote ri más cꞌo rukꞌij, y xcꞌujieꞌ chojay. Antok jajaꞌ cꞌo chic chireꞌ, xtzꞌuye-apa chiquicajol ri alguaciles ri icꞌo chireꞌ, chi nutzꞌat-apa chica xtibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar y quinojiel ri autoridades quichin ri israelitas, niquicanuj manera chi niquitzꞌak tzij chirij ri Jesús, chi quireꞌ niquitak chi niquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y mesque can iqꞌuiy ri xaꞌlka chi xquitzꞌak tzij chirij, xa man jun xquil chirij. Xa cꞌa pa ruqꞌuisbꞌal xaꞌlka icaꞌyeꞌ chi niquitzꞌak tzij, ");
INSERT INTO cakSNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","y xquiꞌej: Ri ache reꞌ ruꞌeꞌn: Inreꞌ nquitiquir nivulij ri ru-templo ri Dios y chi oxeꞌ kꞌij nipabꞌaꞌ chic jun bꞌay. Quireꞌ ruꞌeꞌn, xaꞌchaꞌ ri icaꞌyeꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y ri Caifás, ri sacerdote ri más cꞌo rukꞌij, xpiꞌieꞌ y xuꞌej cha ri Jesús: ¿Man jun kax naꞌej? ¿Ketzij ri xquiꞌej chavij? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ri Jesús man jun tzij xuꞌej. Y jareꞌ antok ri sacerdote ri más cꞌo rukꞌij xuꞌej cha: Can choch ri cꞌaslic Dios taꞌej chika xa atreꞌ ri Cristo, ri Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y ri Jesús xuꞌej cha: Atreꞌ xaꞌej ri ketzij; y niꞌej jeꞌ chiva chi desde vacame can xtitzꞌat ri Xtak-pa chicaj chi xalax chiꞌicajol, chi tzꞌuyul pa ru-derecha ri Dios ri nitiquir nuꞌon nojiel. Y xtitzꞌat antok nika-pa chupan mukul ri chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Entonces ri sacerdote ri más cꞌo rukꞌij xurakꞌachꞌij-ka ri rutziak chirij, y xuꞌej: Man chic nicꞌatzin ta chi nalka jun chic chi nalruꞌej chika chi man otz ta ri i-rubꞌanun. Ixreꞌ xivaxaj ri xuꞌej, chi jajaꞌ junan riqꞌuin ri Dios. ¡Reꞌ can itziel choch ri Dios! ");
INSERT INTO cakSNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Chica ntiꞌej ixreꞌ vacame? xchaꞌ jajaꞌ. Y ri nicꞌaj chic ri quimaluon-apa-quiꞌ chireꞌ xquiꞌej: ¡Otz chi tiquimisas! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubꞌaj rutzubꞌal y xquiyaꞌ kꞌaꞌ cha y nicꞌaj chic xquipaj rutzubꞌal, ");
INSERT INTO cakSNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","y niquicꞌutuj cha: Taꞌej chika, Cristo, ¿chica ri xchꞌayo avichin? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri Pedro tzꞌuyul chojay, y jun xtan aj-chi-icꞌ richin ri sacerdote ri más cꞌo rukꞌij xjiel-apa riqꞌuin y xuꞌej cha: Atreꞌ jeꞌ at rachꞌil ri Jesús ri aj-Galilea, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero ri Pedro man xuꞌej ta ri ketzij chiquivach quinojiel, ruma xuꞌej: Man vataꞌn ta chica ri naꞌej, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y antok jajaꞌ ya ntiel-el chuchiꞌ ri puerta, cꞌo chic jun xtan aj-chi-icꞌ ri xtzꞌato richin y xuꞌej chica ri icꞌo chireꞌ: La ache la can rachꞌil ri Jesús ri aj-Nazaret, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero ri Pedro jun chic bꞌay man xuꞌej ta ri ketzij. Jajaꞌ xuꞌej: Choch ri Dios niꞌej chi inreꞌ man vataꞌn ta roch ri jun ache reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Cꞌa jubꞌaꞌ oc quireꞌ tiꞌeꞌx cha, ri quimaluon-quiꞌ chireꞌ xaꞌjiel-apa riqꞌuin ri Pedro y xquiꞌej cha: Can ketzij chi atreꞌ at jun chiquivach ri icꞌo riqꞌuin ri Jesús, ruma ncachꞌoꞌ incheꞌl ncaꞌchꞌoꞌ ri aj-Galilea, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Entonces ri Pedro xuꞌej: Inreꞌ man vataꞌn ta roch ri ache reꞌ. Can choch ri Dios niꞌej chiva chi inreꞌ man vataꞌn ta roch. Y xa man ketzij ta ri niꞌej, tika ri castigo panoꞌ, xchaꞌ. Y jareꞌ antok xtzirin-pa ri mamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y ri Pedro xalka paroꞌ ri tzij ri ruꞌeꞌn ri Jesús cha: Antes cꞌa majaꞌ titzirin-pa ri mamaꞌ, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch. Y ri Pedro xiel-el juviera y xuokꞌ amargamente. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y antok xsakar-pa, quinojiel ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri israelitas, xquimol-quiꞌ chi niquiꞌan pensar ri chica manera niquiꞌan chi quireꞌ niquitak ri Jesús chi niquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Y xquixim-el y xbꞌaquijachaꞌ pa rukꞌaꞌ ri Poncio Pilato, ri gobernador. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Antok ri Judas xutzꞌat chi ri Jesús xa xucꞌuax choch ri Pilato chi niꞌeꞌx cha chi niquimisas, ja xpa bꞌis pa ránima ruma jajaꞌ ri xcꞌayin richin ri Jesús; rumareꞌ xbꞌarutzoliej can ri treinta monedas de plata chica ri principales sacerdotes y chica ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ xinꞌan pecar ruma xincꞌayij ri Jesús pan ikꞌaꞌ; jajaꞌ manak ruchꞌoꞌj, xchaꞌ chica. Pero ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, xquiꞌej cha ri Judas: ¿Chica ka-cuenta ojreꞌ? ¡Cheꞌl-na ncatiel atreꞌ! xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpa jajaꞌ xuqꞌuiak can ri miera chireꞌ pa templo; xiel-pa chireꞌ y xꞌa y xirutzakabꞌa-riꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y ri principales sacerdotes xquimol ri miera y xquiꞌej: Ri miera va man otz ta chi nakaxol-ka riqꞌuin ri miera ri nisipas can pa templo, ruma ri miera reꞌ xa rajal quicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Antok quiꞌeꞌn chic chiquivach ri chica niquiꞌan cha ri miera reꞌ, ijejeꞌ xquilokꞌ jun ulief ri rubꞌinan Richin ri Bꞌanoy-Bꞌajoꞌy; chi ncaꞌmuk ri vinak ri man israelitas ta. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Rumareꞌ ri jun ulief reꞌ hasta vacame cꞌa niꞌeꞌx Ulief richin Quicꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Riqꞌuin reꞌ nuꞌon cumplir ri ruꞌeꞌn can ri profeta Jeremías. Jajaꞌ ruꞌeꞌn can: Xquimol-el ri treinta monedas de plata, rajal ri altíra rakalien. Jareꞌ rajal xquiyaꞌ ri vinak israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y cha ri miera reꞌ xquilokꞌ ri ulief ri rubꞌinan Richin ri Bꞌanoy-Bꞌajoꞌy, can incheꞌl ruꞌeꞌn ri Ajaf chuva. Quireꞌ ri ruꞌeꞌn can ri Jeremías. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y ri Jesús paꞌl-apa choch ri gobernador. Y jajaꞌ xucꞌutuj cha ri Jesús: ¿Atreꞌ ri Qui-Rey ri israelitas? Y ri Jesús xuꞌej cha: Atreꞌ ncaꞌeꞌn, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y antok ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar niquiꞌan-apa acusar, jajaꞌ man jun tzij ri xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Rumareꞌ ri Pilato xuꞌej cha ri Jesús: ¿Man navaxaj ta ri niquiꞌej-pa chavij chi ncatquiꞌan acusar? ");
INSERT INTO cakSNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús man jun tzij ri xuꞌej. Rumareꞌ ri gobernador can xchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y juna-junaꞌ antok nalka ri namakꞌej Pascua, ri gobernador nutzokopij-el jun chiquivach ri icꞌo pa cárcel; ja ri nicajoꞌ ri vinak chi ntiel-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupan ri tiempo reꞌ, cꞌo pa cárcel jun ache rubꞌinan Barrabás, jun ache ri quinojiel cataꞌn chi altíra itziel. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y ri Pilato xuꞌej chica ri vinak ri quimaluon-quiꞌ chireꞌ: ¿Chica chiquivach ri icaꞌyeꞌ ntivajoꞌ ixreꞌ chi nitzokopij-el? ¿Ntivajoꞌ chi nitzokopij-el ri Barrabás o ja ri Jesús ri niꞌeꞌx Cristo cha? ");
INSERT INTO cakSNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato quireꞌ xuꞌej ruma jajaꞌ rataꞌn chi ri vinak reꞌ quiyoꞌn ri Jesús pa rukꞌaꞌ, ruma itziel niquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y antok ri Pilato tzꞌuyul pa tribunal, jareꞌ antok cꞌo jun xalka riqꞌuin ri rutakuon-pa ri raxjayil. Ri raxjayil ruꞌeꞌn-el cha: Ri Jesús jun ache choj, rumareꞌ man jun kax taꞌan cha. Ruma inreꞌ ruyuon itziel tak achicꞌ xinꞌan chakꞌaꞌ ruma jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Pero ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar xaꞌcovin chiquij ri vinak, chi tiquicꞌutuj-apa chi ja ri Barrabás titzokopes-el y ri Jesús tiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y antok ri gobernador xucꞌutuj chic chica ri vinak chi chica chiquivach ri icaꞌyeꞌ nicajoꞌ ijejeꞌ chi nralasaj-el, ri vinak reꞌ xquiꞌej: Ja ri Barrabás tavalasaj-el, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Y ri Pilato xucꞌutuj chica ri vinak: ¿Chica niꞌan cha ri Jesús, ri niꞌeꞌx Cristo cha? Quinojiel xaꞌchꞌo-apa y xquiꞌej: ¡Tiꞌan crucificar! ");
INSERT INTO cakSNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Y ri gobernador xucꞌutuj chica: ¿Chica ruchꞌoꞌj rubꞌanun? Pero ri vinak man ncaꞌtanieꞌ ta ka. Xa riqꞌuin más quichukꞌaꞌ ncaꞌchꞌo-apa y niquiꞌej: ¡Tiꞌan crucificar! ");
INSERT INTO cakSNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y antok ri Pilato xutzꞌat chi man jun chic kax nitiquir nuꞌon chi nucol ri Jesús, y ri vinak xa más altíra niquiꞌan-apa, xucꞌutuj jubꞌaꞌ ruyaꞌ y ja xuchꞌaj rukꞌaꞌ chiquivach quinojiel ri vinak reꞌ, y xuꞌej: Inreꞌ manak nuchꞌoꞌj chirij ri rucamic ri jun choj ache reꞌ. ¡Titzꞌataꞌ ixreꞌ chica ntiꞌan cha! ");
INSERT INTO cakSNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Y quinojiel ri vinak niquiꞌej: Pa kaveꞌ ojreꞌ y pa quiveꞌ ri kalcꞌual tika ri ruquiqꞌuiel, xaꞌcha-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Entonces ri gobernador xutzokopij-el ri Barrabás y xuꞌej chi tichꞌay ri Jesús, cꞌajareꞌ xujach-el chi tiquimisas choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y ri ru-soldados ri gobernador xquicusaj-apa ri Jesús chupan ri palacio. Y xaꞌquimol quinojiel ri nicꞌaj chic soldados chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Y ri soldados reꞌ xquicꞌan-el ri rutziak ri Jesús y xquiyaꞌ jun tziak quiak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Y xquiyaꞌ pa rujaluon jun corona ri pachꞌun cha jun kꞌayis ri altíra ruqꞌuixal. Y xquiyaꞌ jeꞌ jun aj pa rukꞌaꞌ derecha y ncaꞌxuquieꞌ choch y ncaꞌtzeꞌn chirij antok niquiꞌej cha: ¡Caquicuot, atreꞌ ri Qui-Rey ri israelitas! ");
INSERT INTO cakSNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Can niquichubꞌaj ri Jesús y niquimaj jeꞌ ri aj ri cꞌo pa rukꞌaꞌ chi niquibꞌuj pa rujaluon. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y antok ijejeꞌ xaꞌtanie-ka chi ncaꞌtzeꞌn chirij, xquicꞌan-el ri tziak ri quiyoꞌn ijejeꞌ chirij, xquiya-el ri rutziak jajaꞌ, y xquicꞌuaj chi niquibꞌajij choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y antok ya ncaꞌiel-el pa tanamet, xquicꞌul jun ache aj-Cirene, ri Simón rubꞌeꞌ, y ri soldados xquiꞌan cha ri ache reꞌ chi tucꞌuaj ri cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y xaꞌbꞌaka chupan ri lugar rubꞌinan Gólgota. Ri tzij Gólgota nrajoꞌ nuꞌej: Rujaluon Quiminak (Calavera). ");
INSERT INTO cakSNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Antok icꞌo chic chireꞌ, xquiyaꞌ cha ri Jesús vinagre xaluon riqꞌuin jun cꞌayilaj akꞌuon. Pero antok jajaꞌ xunaꞌ ri chica niquiyaꞌ cha, man xrajoꞌ ta xukun. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y antok ri soldados quibꞌajin chic ri Jesús choch ri cruz, xcalasaj suerte chirij ri rutziak chi niquijach chiquivach. Y riqꞌuin reꞌ nuꞌon cumplir ri bꞌeꞌn can ruma ri jun profeta ri xcꞌujieꞌ ojier can tiempo. Quireꞌ nuꞌej ri tzꞌibꞌan can: Xaꞌquijach ri nutziak chiquivach y xcalasaj suerte chirij. Quireꞌ ri rutzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Y ri soldados xaꞌtzꞌuye-ka chireꞌ, quichajin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y paroꞌ ri cruz, ijejeꞌ xquiyaꞌ jun letrero ri nuꞌej karruma niquimisas. Choch ri letrero reꞌ nuꞌej: JAREꞌ RI JESUS RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Icꞌo icaꞌyeꞌ alakꞌomaꞌ ri xaꞌbꞌajix choch cruz riqꞌuin ri Jesús. Jun xyoꞌx pa ru-derecha y ri jun chic pa ru-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri vinak ri ncaꞌkꞌax ri pacheꞌ cꞌo-ve ri Jesús niquisiluoj can quijaluon choch, y cꞌo tzij ri man otz ta ri ncaꞌquiꞌej can cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ri vinak reꞌ niquiꞌej cha ri Jesús: Atreꞌ xaꞌej chi navulij ri templo y chi oxeꞌ kꞌij napabꞌaꞌ chic jun bꞌay, tacalo-aviꞌ ayuon. Y xa atreꞌ ri Rucꞌajuol ri Dios, caka-pa choch ri cruz, ncaꞌchaꞌ can cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y quireꞌ jeꞌ niquiꞌan ri principales sacerdotes, ri achiꞌaꞌ escribas, ri achiꞌaꞌ fariseos y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, ijejeꞌ altíra ncaꞌtzeꞌn-apa chirij ri Jesús y niquiꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Jajaꞌ can iqꞌuiy xaꞌrucol, pero jajaꞌ man nitiquir ta nucol-riꞌ ruyuon. Xa jajaꞌ ri Qui-Rey ri israelitas, tika-pa choch ri cruz vacame cꞌa y can xtakanimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jajaꞌ can xucukubꞌaꞌ rucꞌuꞌx riqꞌuin ri Dios, y xa ri Dios can nrajoꞌ jajaꞌ, tucaloꞌ cꞌa. Ruma ri Jesús ruꞌeꞌn: Inreꞌ in Rucꞌajuol ri Dios. Quireꞌ xquiꞌej ri achiꞌaꞌ reꞌ chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y ri alakꞌomaꞌ ri i-bꞌajin choch qui-cruz riqꞌuin ri Jesús, can cꞌo tzij jeꞌ ri man otz ta ri ncaꞌquiꞌej-apa cha. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y pa nicꞌaj-kꞌij, nojiel ri roch-ulief xuꞌon kꞌakuꞌn. Y ri kꞌakuꞌn reꞌ xqꞌuis-el hasta cꞌa a las tres ri nakakꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y yan laꞌk a las tres, ri Jesús xurak ruchiꞌ y xuꞌej: Elí, Elí, ¿lama sabactani? xchaꞌ. Y ri tzij reꞌ quireꞌ nuꞌej: Nu-Dios, Nu-Dios, ¿karruma xinayaꞌ can? ");
INSERT INTO cakSNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y icꞌo jujun ri icꞌo-apa cierca ri Jesús, antok xcaꞌxaj ri xuꞌej, ja xquiꞌej: Jajaꞌ, ja ri Elías ri nrayuoj, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y cꞌo jun ri chaꞌnin xbꞌarucꞌama-pa jun esponja, xumubꞌaꞌ chupan vinagre, y xuyaꞌ ri esponja chutzaꞌn jun aj, chi xuyaꞌ cha ri Jesús chi nutzꞌuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ri nicꞌaj chic ri icꞌo-apa ri pacheꞌ cꞌo-ve ri Jesús, xquiꞌej: Kayoꞌiej, katzꞌataꞌ xa nalka ri Elías chi nucol, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero ri Jesús xurak chic ruchiꞌ y ja xujach ri ru-espíritu. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y antok jajaꞌ xcon, ri tziak ri choj cha jachuon-ve rupan ri templo xkꞌachꞌitaj pa nicꞌaj, cꞌa paroꞌ cꞌa chuxieꞌ ka. Can xuꞌon cubꞌrakan y ri abꞌaj xaꞌpax. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri jul ri pacheꞌ i-mukun-ve ri quiminakiꞌ xaꞌjakataj. Y iqꞌuiy chiquivach ri quiniman ri Dios ri i-quiminak chic el, xaꞌcꞌastaj-pa, ");
INSERT INTO cakSNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xaꞌbꞌaꞌiel-pa. Antok ri Jesús cꞌastajnak chic chiquicajol ri quiminakiꞌ, xaꞌuoc chupan ri santa tanamet Jerusalén; y can iqꞌuiy xaꞌtzꞌato quichin. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ri capitán y quinojiel ri icꞌo riqꞌuin chi niquichajij ri Jesús, xquitzꞌat ri xuꞌon ri cubꞌrakan y ri nicꞌaj chic kax ri xaꞌbꞌanataj, can altíra xquixiꞌij-quiꞌ y xquiꞌej: Can ketzij chi la ache la, can Rucꞌajuol ri Dios, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y iqꞌuiy ixokiꞌ ri i-patanak chirij ri Jesús antok xiel-pa Galilea, y quilin-pa, ijejeꞌ chi-naj ncaꞌtzuꞌn-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicajol ri ixokiꞌ reꞌ, cꞌo ri María Magdalena, ri María quitieꞌ ri Jacobo y ri José, y ri raxjayil ri Zebedeo, ri quitieꞌ ri Jacobo y ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Antok xkakꞌij-ka (después ri a las tres), cꞌo jun ache bꞌayuon xalka rubꞌinan José ri aj-Arimatea, jajaꞌ jun ru-discípulo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Jajaꞌ xꞌa riqꞌuin ri Pilato chi xucꞌutuj ri ru-cuerpo ri Jesús. Y ri Pilato xuꞌej cꞌa chi tiyoꞌx-pa ri ru-cuerpo ri Jesús cha ri José. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y ri José xubꞌol cꞌa jun tziak sak chirij ri ru-cuerpo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ri José can richin jajaꞌ rucꞌatuon jun jul cꞌacꞌacꞌ, y chireꞌ xbꞌaruya-ve ri ru-cuerpo ri Jesús. Ri jul reꞌ cꞌatuon choch jun nem abꞌaj. Jajaꞌ xutzꞌapij can ri ruchiꞌ ri jul cha jun nem abꞌaj y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ri María Magdalena y ri jun chic ixok rubꞌinan jeꞌ María i-tzꞌuyul chireꞌ choch ri jul. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri kꞌij antok xmuk ri Jesús, ja kꞌij reꞌ antok ri vinak niquiꞌan yan nojiel ri xticꞌatzin chica chucaꞌn kꞌij, ruma ri kꞌij richin uxlanien ya nitiquir-ka. Y chupan ri kꞌij richin uxlanien, ri principales sacerdotes y ri achiꞌaꞌ fariseos xaꞌbꞌaka choch ri Pilato. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ijejeꞌ xbꞌaquiꞌej cha: Ojreꞌ xalka pa kaveꞌ antok ri Jesús cꞌa cꞌas, xuꞌej chi xticꞌastaj-pa chi oxeꞌ kꞌij. Quireꞌ ruꞌeꞌn can ri jun aj-tzꞌakoy-tzij reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rumareꞌ caꞌtakaꞌ soldados chi niquichajij ri jul cꞌa nitzꞌakat-na ri oxeꞌ kꞌij, chi quireꞌ man caꞌpa ri ru-discípulos y xticalakꞌaj ri ru-cuerpo ri Jesús chakꞌaꞌ, y xtiquiꞌej chica ri vinak: Ri Jesús can xcꞌastaj-ve-el chiquicajol ri quiminakiꞌ, xcaꞌchaꞌ. Ruma xa nalakꞌax-el ri ru-cuerpo, can más iqꞌuiy ri xcaꞌniman choch ri naꞌay, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xuꞌej chica ri achiꞌaꞌ reꞌ: Quixꞌin y quiꞌivucꞌuaj ri soldados la. Tibꞌanaꞌ cha incheꞌl ri ivataꞌn ixreꞌ, xaꞌucheꞌx-el. ");
INSERT INTO cakSNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ri achiꞌaꞌ reꞌ can ja xaꞌa pacheꞌ mukun-ve can ri Jesús y xquichojmij otz ruchiꞌ ri jul. Xquiꞌan jeꞌ sellar ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, chi quireꞌ man jun nitiquir nijako. Y xaꞌquiyaꞌ can ri soldados chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y antok kꞌaxnak chic ri kꞌij richin uxlanien, cꞌa cumaj yan ri naꞌay kꞌij richin ri semana, ri María Magdalena y ri jun chic ixok rubꞌinan jeꞌ María, xaꞌa chi niquitzꞌataꞌ ri jul pacheꞌ yoꞌn-ve can ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Y xuꞌon jun nem cubꞌrakan; ruma jun ángel richin ri Ajaf xka-pa chicaj chupan ri lugar pacheꞌ yoꞌn-ve can ri Jesús, xralasaj-el ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, y xtzꞌuyeꞌ paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri rusakil ri ángel ri tzꞌuyul paroꞌ ri abꞌaj, can junan riqꞌuin ri sakil ri nuyaꞌ ri yocopaꞌ. Y ri rutziak can altíra sak, can incheꞌl ri hielo ri nika. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y ri soldados can altíra xquixiꞌij-quiꞌ choch ri ángel, can xaꞌbꞌarbꞌuot, y can incheꞌl xaꞌcon xaꞌcꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Pero ri ángel xchꞌo-pa chica ri icaꞌyeꞌ ixokiꞌ y xuꞌej chica: Man tixiꞌij-iviꞌ. Ruma inreꞌ vataꞌn chi ixreꞌ nticanuj ri Jesús ri xquimisas choch ri cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jajaꞌ man cꞌo ta chic vaveꞌ, ruma ya xcꞌastaj-el, incheꞌl ruꞌeꞌn can chiva. Quixam-pa; titzꞌataꞌ ri lugar pacheꞌ xcꞌujie-ve ri ru-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Quixꞌin chaꞌnin y tiꞌej chica quinojiel ri ru-discípulos, chi jajaꞌ ya xcꞌastaj-el chiquicajol ri quiminakiꞌ; y vacame niꞌa naꞌay chivach cꞌa Galilea; chireꞌ xtitzꞌat-ve, can incheꞌl niꞌej-el chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y ri icaꞌyeꞌ ixokiꞌ reꞌ can ja xaꞌiel-pa chupan ri jul. Y mesque can quixiꞌin-quiꞌ y altíra jeꞌ ncaꞌquicuot, ijejeꞌ chaꞌnin xaꞌa chi niquiꞌej ri xquitzꞌat y ri xcaꞌxaj chica ri ru-discípulos ri Jesús. Y antok i-bꞌanak chi niquiꞌej, ");
INSERT INTO cakSNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","jareꞌ antok ri Jesús xbꞌaꞌiel-pa chiquivach y xaꞌruꞌon saludar. Y ri icaꞌyeꞌ ixokiꞌ reꞌ xaꞌxuquie-ka choch ri Jesús, xquikꞌatiej ri rakan y can xquiyaꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y ri Jesús xuꞌej chica ri ixokiꞌ: Man tixiꞌij-iviꞌ. Quixꞌin y tiꞌej chica ri nu-hermanos ri xitzꞌat y xivaxaj, richin chi caꞌa Galilea y chila xquinquitzꞌat-ve, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Y antok ri ixokiꞌ quitzꞌamuon bꞌay, icꞌo nicꞌaj chiquivach ri soldados ri niquichajij ri jul xaꞌa pa tanamet Jerusalén y xbꞌaquiꞌej chica ri principales sacerdotes nojiel ri xbꞌanataj ri pacheꞌ xmuk-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ri principales sacerdotes xquimol-quiꞌ quiqꞌuin ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, y antok quiꞌeꞌn chic chiquivach, xquiyaꞌ qꞌuiy miera chica ri soldados. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ijejeꞌ xquiꞌej chica: Ixreꞌ tiꞌej chi xixvar-ka ri chakꞌaꞌ, y antok nquixvar, xaꞌlka ri ru-discípulos ri Jesús y xquilakꞌaj-el ri ru-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y xa ri gobernador nunaꞌiej chi ixreꞌ xa xixvar-ka y man xichajij ta incheꞌl ri xꞌeꞌx chiva, ojreꞌ xkojbꞌachꞌoꞌ riqꞌuin y xkojrunimaj, y quireꞌ nquixkacol pa rukꞌaꞌ, xaꞌchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados xquicꞌan ri miera, y can incheꞌl xꞌeꞌx chica, can quireꞌ xquiꞌan: Can xquitzijuoj incheꞌl ri xꞌeꞌx chica chiquicajol ri israelitas y cꞌa niquinimaj chupan ri tiempo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ri once (julajuj) ru-discípulos ri Jesús xaꞌa Galilea. Y xaꞌjotieꞌ paroꞌ ri chꞌiti juyuꞌ pacheꞌ bꞌeꞌn can chica ruma ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y antok ijejeꞌ xquitzꞌat ri Jesús, can xquiyaꞌ rukꞌij. Pero icꞌo nicꞌaj ri man can ta niquinimaj chi ja ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Y ri Jesús xjiel-apa quiqꞌuin y xuꞌej chica: Can nojiel poder xjach pa nukꞌaꞌ; ri cꞌo chicaj y ri cꞌo vaveꞌ choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mareꞌ niꞌej can chiva: Quixꞌin cꞌa nojiel naciones chi nticꞌut chiquivach ri vinak chi ncaꞌuoc nu-discípulos; quiꞌbꞌanaꞌ bautizar pa rubꞌeꞌ ri Katataꞌ Dios, pa nubꞌeꞌ inreꞌ ri in Rucꞌajuol ri Dios y pa rubꞌeꞌ ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y ticꞌutuꞌ chiquivach chi tiquibꞌanaꞌ nojiel ri nuꞌeꞌn chiva. Y inreꞌ xquicꞌujieꞌ iviqꞌuin nojiel kꞌij hasta cꞌa antok xtalka ri ruqꞌuisbꞌal kꞌij richin ri roch-ulief. Amén.");
INSERT INTO cakSNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quireꞌ xtiquir-pa ri evangelio richin ri Jesucristo ri Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ri profeta Isaías rutzꞌibꞌan can ri xꞌeꞌx cha ruma ri Dios. Quireꞌ nuꞌej: Inreꞌ xtintak jun ache naꞌay chavach, chi nuchojmij ri abꞌiey chavach. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ri ache reꞌ xticꞌujieꞌ chupan jun lugar desierto, y jajaꞌ xturak cꞌa ruchiꞌ chi xtuꞌej chica ri vinak ri xcaꞌbꞌaka riqꞌuin: Tichojmij-apa rubꞌiey ri Ajaf, y can choj tibꞌanaꞌ cha. Quireꞌ nuꞌej ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri ache ri xtak-pa, ja ri Juan el Bautista. Y jajaꞌ ncaꞌruꞌon bautizar ri vinak chupan jun lugar desierto. Y nuꞌej chica ri vinak ri ncaꞌbꞌaka riqꞌuin chi titzalaj-pa cánima riqꞌuin ri Dios y tiquibꞌanaꞌ ri nrajoꞌ ri Dios y tiquibꞌanaꞌ bautizar-quiꞌ, chi quireꞌ niꞌan perdonar ri qui-pecados ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y ri vinak ri ncaꞌbꞌaka riqꞌuin, can iqꞌuiy. Icꞌo ri i-patanak Jerusalén, y icꞌo ri i-patanak nicꞌaj chic tanamet richin ri Judea, y jajaꞌ ncaꞌruꞌon bautizar chireꞌ chupan ri río Jordán. Y niquiꞌej cꞌa ri qui-pecados ri i-quibꞌanun-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri rutziak ri Juan el Bautista bꞌanun cha ruveꞌ camello, y jutzꞌit tzꞌun rucusan chi ruximuon rupan. Y ri rutiꞌ, ja ri sacꞌ y ri cabꞌ ri niril pa tak kꞌayis. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan nuꞌej chica ri vinak: Cꞌo Jun ri xtipa chuvij inreꞌ ri nixta nucꞌul chi inreꞌ nquiluquie-ka chi niquir ri ximbꞌal-roch ri ruxajabꞌ, ruma jajaꞌ cꞌo nojiel poder riqꞌuin que chinoch inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Inreꞌ, yaꞌ ri nicusaj chi nquixꞌan bautizar. Pero ri Jun ri xtipa, xquixruꞌon bautizar riqꞌuin ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja tiempo reꞌ antok ri Jesús alanak-pa pa tanamet Nazaret ri cꞌo Galilea y xalka riqꞌuin ri Juan. Y jajaꞌ xꞌan bautizar ruma ri Juan chupan ri río Jordán. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y antok ri Jesús xiel-pa chupan ri yaꞌ, xutzꞌat chi xjakataj ri rocaj, y ri Espíritu Santo nika-pa incheꞌl jun paluomix; y choj xka-pa paroꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y jareꞌ antok cꞌo Jun ri xchꞌo-pa chicaj y xuꞌej: Atreꞌ ri at Nucꞌajuol; altíra ncanvajoꞌ y niquicuot vánima aviqꞌuin. Quireꞌ ri xuꞌej-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Y ri Jesús xꞌan cha ruma ri Espíritu Santo chi xꞌa chupan jun lugar desierto. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y chireꞌ chupan ri lugar desierto xcꞌujie-ve, pacheꞌ joꞌc cꞌuxuniel tak chicop icꞌo. Chireꞌ xcꞌujie-ve cuarenta kꞌij. Y antok cꞌo chireꞌ, ri Satanás xuꞌon tentar. Y ri ángeles xquiꞌan servir ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cꞌo chic ri Juan el Bautista pa cárcel antok ri Jesús xtzalaj chic Galilea. Ri Jesús nutzijuoj ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, ");
INSERT INTO cakSNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y nuꞌej: Vacame cꞌa, ja xalka ri tiempo ri ruꞌeꞌn ri Dios; xa cierca chic cꞌo-ve-pa ri ru-reino. Titzalaj-pa ivánima riqꞌuin ri Dios y tibꞌanaꞌ ri nrajoꞌ jajaꞌ y tinimaj ri evangelio, nchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y jun kꞌij antok ri Jesús bꞌanak chuchiꞌ ri mar Galilea, xaꞌrutzꞌat icaꞌyeꞌ achiꞌaꞌ ri quichakꞌ-quinimal-quiꞌ; jun ja ri Simón y ri jun chic ja ri Andrés; ijejeꞌ i-tzꞌamoy-car, mareꞌ niquiya-ka ri quiyaꞌl chupan ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Y ri Jesús xchꞌo-apa chica ri icaꞌyeꞌ achiꞌaꞌ reꞌ y xuꞌej chica: Joꞌ viqꞌuin, y xtincꞌut chivach cheꞌl nquiꞌcanuj vinak chi nquinquinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri icaꞌyeꞌ achiꞌaꞌ reꞌ, ja xquiyaꞌ can ri quiyaꞌl y xaꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y cꞌa jubꞌaꞌ oc caꞌin, ri Jesús xaꞌrutzꞌat chic icaꞌyeꞌ ri quichakꞌ-quinimal-quiꞌ jeꞌ, ja ri Jacobo y ri Juan, ri i-rucꞌajuol ri Zebedeo. Ijejeꞌ icꞌo chupan ri barco niquicꞌajuoj ri yaꞌl richin niquitzꞌom car. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Y xpa ri Jesús xaꞌrayuoj chi ncaꞌa riqꞌuin. Y ri Jacobo y ri Juan xquiyaꞌ can ri quitataꞌ Zebedeo quiqꞌuin ri muosa chupan ri barco, y xaꞌa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri Jesús y ri i-bꞌanak riqꞌuin xaꞌlka pa tanamet Capernaum. Y antok nalka ri kꞌij richin uxlanien, ri Jesús niꞌa pa sinagoga. Jajaꞌ chireꞌ nucꞌut ri ruchꞌabꞌal ri Dios chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xaꞌcꞌaxan richin, can xaꞌchapataj ruma ri tzij ri xcaꞌxaj, ruma antok ncaꞌrutijuoj, can kꞌalaj chi can cꞌo autoridad pa rukꞌaꞌ y man incheꞌl ta ri achiꞌaꞌ escribas. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y chireꞌ chupan ri sinagoga, cꞌo-apa jun ache ri cꞌo jun itziel espíritu riqꞌuin. Y ri itziel espíritu ri cꞌo riqꞌuin ri ache, can xsiqꞌuin, ");
INSERT INTO cakSNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","y xuꞌej cha ri Jesús: ¿Chica navajoꞌ chika, atreꞌ Jesús aj-Nazaret? ¿Xapa chi nkojaqꞌuis? Inreꞌ vataꞌn chica atreꞌ, chi at Santo richin ri Dios, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ri Jesús xuchꞌolij ri itziel espíritu: ¡Man chic cachꞌoꞌ y catiel-el riqꞌuin ri ache! ");
INSERT INTO cakSNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y ri itziel espíritu xuquiyica-can ri ru-cuerpo ri ache, y nisiqꞌuin antok xiel-el riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y ri vinak ri quimaluon-quiꞌ chireꞌ, can xaꞌchapataj antok xquitzꞌat ri xuꞌon ri Jesús, y niquiꞌej cꞌa chiquivach: ¿Chica cꞌa va? Ruma ri nucꞌut jajaꞌ can cꞌacꞌacꞌ. Antok nichꞌoꞌ, can riqꞌuin autoridad, y ri itziel tak espíritus can niquinimaj rutzij, ncaꞌchaꞌ ri vinak chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y chaꞌnin xꞌa rutzijoxic ri Jesús ri pa tak tanamet ri icꞌo cierca ri Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Antok ri Jesús, ri Jacobo y ri Juan xaꞌiel-pa chupan ri sinagoga, xaꞌlka chicachuoch ri Simón y ri Andrés. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero antok xaꞌlka, xꞌeꞌx cha ri Jesús chi ri rujitieꞌ ri Simón catzꞌol choch ruchꞌat, ruma cꞌo cꞌatan chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y ri Jesús xjiel-apa riqꞌuin ri niyavaj, xutzꞌom rukꞌaꞌ y xupilisaj. Y joꞌc quireꞌ xuꞌon cha, ja xqꞌuis-el ri cꞌatan chirij. Y ri ixok reꞌ xaꞌrutzuk ri Jesús y ri i-bꞌanak riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Antok ya xka-ka ri kꞌij y xcokꞌa-ka, ri vinak ri icꞌo ncaꞌyavaj quiqꞌuin xaꞌquicꞌam-pa choch ri Jesús. Ri ncaꞌyavaj reꞌ, diferente roch yabꞌil ri ntuoc chica y icꞌo jeꞌ ri cꞌo itziel tak espíritus quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y jubꞌaꞌ ma quinojiel ri vinak ri icꞌo chupan ri jun tanamet reꞌ ri xquimol-quiꞌ chuchiꞌ ri jay pacheꞌ cꞌo-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y xaꞌruꞌon sanar iqꞌuiy ri ncaꞌyavaj, ri diferente roch yabꞌil ri ntuoc chica. Y xaꞌralasaj-el iqꞌuiy itziel tak espíritus ri icꞌo quiqꞌuin ri vinak. Ri Jesús man xuyaꞌ ta permiso chica ri itziel tak espíritus chi xaꞌchꞌoꞌ, ruma cataꞌn chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Cumaj yan, can cꞌa kꞌakuꞌn, ri Jesús xiel-el pa tanamet y xꞌa chupan jun lugar pacheꞌ man jun vinak chi xbꞌarubꞌanaꞌ orar. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y ri Simón y ri icꞌo riqꞌuin xaꞌa chi xiꞌquicanuj ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Y antok xquil, xquiꞌej cha: Quinojiel ri vinak ncatquicanuj, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y jajaꞌ xuꞌej chica: Joꞌ nicꞌaj chic tanamet ri icꞌo cierca, chi nitzijuoj jeꞌ ri ruchꞌabꞌal ri Dios chireꞌ, ruma richin reꞌ xipa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y jajaꞌ nutzijuoj ri ruchꞌabꞌal ri Dios pa tak sinagogas chupan nojiel ri Galilea. Y can xaꞌralasaj-el ri itziel tak espíritus ri icꞌo quiqꞌuin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xalka riqꞌuin ri Jesús jun ache niyavaj riqꞌuin ri yabꞌil lepra, ja xxuquie-ka choch y nucꞌutuj favor xuꞌej cha: Xa navajoꞌ, cꞌo cheꞌl nquinaꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Y ri Jesús xujoyovaj roch ri ache reꞌ; xuyuk-apa ri rukꞌaꞌ y xutzꞌom-apa y xuꞌej cha: Nivajoꞌ chi ncacꞌachoj. Tiqꞌuis-el ri yabꞌil reꞌ chavij, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y can joꞌc quireꞌ xuꞌej ri Jesús, ri yabꞌil lepra ri cꞌo chirij ri ache xqꞌuis-el y xcꞌachoj ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Entonces ri Jesús xuꞌej cha ri ache chi tiꞌa, pero xuꞌon mandar cha ri chica nicꞌatzin chi nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ri Jesús xuꞌej cha: Man tatzijuoj chica ri vinak ri xbꞌanataj aviqꞌuin, choj caꞌin, acꞌutu-aviꞌ choch ri sacerdote, y tayaꞌ ri nuꞌej chupan ri ru-ley ri Moisés, chi quireꞌ nikꞌalajin chiquivach chi at otz chic vacame, xcha-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ri ache can joꞌc xuyaꞌ can ri Jesús, xutzꞌom rutzijoxic ri xbꞌanataj riqꞌuin jajaꞌ. Y rumareꞌ ri Jesús chaꞌnin xiel rutzijoxic, y man nitiquir ta chic cꞌa ntuoc-apa ri pa tak tanamet ri pacheꞌ nalka-ve, ruma can iqꞌuiy vinak ri ncaꞌcꞌulu-apa richin. Y rumareꞌ ri Jesús nicꞌujieꞌ juviera ri tanamet. Y ri vinak ri ncaꞌlka riqꞌuin, can nojiel lugar ncaꞌpa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ya takꞌax jun janeꞌ (jaroꞌ) kꞌij, ri Jesús xtzalaj-pa pa tanamet Capernaum, y ri vinak xcaꞌxaj chi jajaꞌ cꞌo chupan jun jay chireꞌ pa tanamet. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ri vinak chaꞌnin cꞌa xquimol-apa-quiꞌ pacheꞌ cꞌo-ve ri Jesús. Rumareꞌ ri jay can man ncaꞌruꞌon ta chic, ni ri chuchiꞌ. Y ri Jesús nutzijuoj ri ruchꞌabꞌal ri Dios chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Jareꞌ antok icꞌo nicꞌaj chic xaꞌlka; quicꞌamun-pa jun ache ri paralítico ru-cuerpo. Icajeꞌ i-talayuon-pa richin. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero ijejeꞌ xa man xaꞌtiquir ta xaꞌbꞌaka pacheꞌ cꞌo-ve ri Jesús, ruma iqꞌuiy ri vinak quimaluon-quiꞌ chireꞌ. Mareꞌ xquicꞌan-el jubꞌaꞌ ruveꞌ ri jay ri pacheꞌ cꞌo-ve ri Jesús, y xquikasaj-ka ri camilla ri cꞌo ri ache ri paralítico ru-cuerpo choch. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y antok ri Jesús xutzꞌat chi ri achiꞌaꞌ ri i-cꞌamayuon-pa quicukubꞌan quicꞌuꞌx riqꞌuin, ja xuꞌej cha ri ache ri paralítico ru-cuerpo: Valcꞌual, ri a-pecados xaꞌan perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y chireꞌ i-tzꞌuyul-apa nicꞌaj achiꞌaꞌ escribas. Ijejeꞌ xquiꞌej-ka pa cánima: ");
INSERT INTO cakSNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Karruma nuꞌej quireꞌ va ache va? Can nuꞌon chi jajaꞌ ri Dios, ruma joꞌc ri Dios nibꞌano perdonar pecados, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Y ri Jesús can rataꞌn ri chica niquiꞌej pa tak cánima ri achiꞌaꞌ reꞌ, mareꞌ xuꞌej chica: ¿Karruma quireꞌ ntiꞌej pa tak ivánima? ");
INSERT INTO cakSNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Chica ri más fácil, niꞌej cha ri ache paralítico: Ri a-pecados niꞌan perdonar, o niꞌej cha: Capalaj, tavucꞌuaj ri a-camilla y caꞌin? ");
INSERT INTO cakSNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Vacame cꞌa, chi ntivatamaj chi ri Xtak-pa chicaj chi xalax chiꞌicajol can cꞌo poder riqꞌuin chi nuꞌon perdonar pecados, (jareꞌ antok ri Jesús xuꞌej cha ri ache paralítico): ");
INSERT INTO cakSNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Chava atreꞌ niꞌej: Capalaj, tavucꞌuaj ri a-camilla y caꞌin chavachuoch, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y ri ache ja xpalaj chaꞌnin, xucꞌol-el ri ru-camilla, y xiel-el chiquicajol ri quimaluon-quiꞌ chireꞌ. Y ri vinak can xaꞌchapataj, y xquiyaꞌ rukꞌij ri Dios y xquiꞌej: Man jun bꞌay katzꞌatuon chi quireꞌ nibꞌanataj, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y ri Jesús xꞌa chic jun bꞌay chuchiꞌ ri mar y altíra iqꞌuiy vinak ri xaꞌlka riqꞌuin, y jajaꞌ ncaꞌrutijuoj riqꞌuin ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y antok jajaꞌ nakꞌax, xutzꞌat ri Leví, ri rucꞌajuol ri Alfeo. Ri ache reꞌ tzꞌuyul choch jun chꞌacat chi numol ri impuestos ri ncaꞌtuoj can. Y ri Jesús xuꞌej cha: Joꞌ viqꞌuin. Y jajaꞌ xpalaj-pa ri pacheꞌ tzꞌuyul-ve y xꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y antok ri Jesús cꞌo chirij ri mesa pa rachuoch ri Leví, iqꞌuiy ri maloy-impuestos y nicꞌaj chic vinak ri niꞌeꞌx aj-bꞌanoy-pecado chica icꞌo-apa chirij ri mesa, junan riqꞌuin ri Jesús y ri ru-discípulos. Ruma can iqꞌuiy ri i-bꞌanak chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y antok ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos xquitzꞌat chi ri Jesús nivaꞌ quiqꞌuin ri maloy-impuestos y quiqꞌuin ri vinak ri aj-bꞌanoy-pecado niꞌeꞌx chica, xquiꞌej chica ri ru-discípulos: ¿Karruma jajaꞌ nivaꞌ quiqꞌuin ri maloy-impuestos y quiqꞌuin ri vinak ri aj-bꞌanoy-pecado niꞌeꞌx chica? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Antok ri Jesús xraꞌxaj ri niquiꞌej ri achiꞌaꞌ reꞌ, xuꞌej chica: Ri man ncaꞌyavaj ta man nicꞌatzin ta jun doctor chica, xa ja ri ncaꞌyavaj. Inreꞌ man xipa ta chi ncaꞌnvayuoj ri choj quicꞌaslien choch ri Dios, xa ja ri cꞌo qui-pecados, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri ru-discípulos ri Juan el Bautista y ri qui-discípulos ri achiꞌaꞌ fariseos niquiꞌan ayuno. Y rumareꞌ xaꞌlka riqꞌuin ri Jesús y xquiꞌej cha: Ojreꞌ ri oj ru-discípulos ri Juan el Bautista y oj qui-discípulos ri achiꞌaꞌ fariseos nakaꞌan ayuno. ¿Karruma ri a-discípulos atreꞌ man quireꞌ ta niquiꞌan? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y ri Jesús xuꞌej chica: ¿Acaso otz came chi niquiꞌan ayuno ri i-bꞌanun invitar pa jun cꞌulubꞌic antok xa cꞌa cꞌo ri alaꞌ ri xcꞌulieꞌ chiquicajol? Antok xa cꞌa cꞌo ri alaꞌ ri xcꞌulieꞌ chiquicajol, manak cheꞌl niquiꞌan ayuno. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xtalka ri kꞌij antok ri alaꞌ reꞌ xtalasas-el chiquicajol, cꞌajareꞌ xtiquiꞌan ayuno. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Man jun nucusaj jun cꞌojobꞌal cꞌacꞌacꞌ chi nucꞌojobꞌiej jun tziak ri xa tziaꞌk chic. Ruma ri cꞌojobꞌal cꞌacꞌacꞌ nucꞌol-riꞌ y nujicꞌ ri tziak ri xa tziaꞌk chic y más nikꞌachꞌitaj-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y man jun niyoꞌn cꞌacꞌacꞌ vino chupan jun tzꞌun yacbꞌal-yaꞌ ri xa tziaꞌk chic. Ruma xa quireꞌ niꞌan cha, ri tzꞌun xa man nuyuk ta chic riꞌ; ri tzꞌun xa nikꞌachꞌitaj y ja niqꞌuis-el ri vino chupan. Y ri tzꞌun jeꞌ man jun chic xticꞌatzin-ve. Pero chupan jun cꞌacꞌacꞌ tzꞌun yacbꞌal-yaꞌ, otz niyaquieꞌ cꞌacꞌacꞌ vino. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chupan jun kꞌij richin uxlanien, ri Jesús y ri ru-discípulos ncaꞌkꞌax chupan jun ulief ri ticuon trigo choch. Y ri discípulos mientras ncaꞌin, ncaꞌquichꞌup-el ruveꞌ ri trigo. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Rumareꞌ ri achiꞌaꞌ fariseos xquiꞌej cha ri Jesús: Caꞌtzꞌataꞌ la a-discípulos. ¿Karruma ncaꞌsamaj chupan ri kꞌij richin uxlanien? Reꞌ xajan, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero ri Jesús xuꞌej chica: ¿Man jun came bꞌay ibꞌanun leer ri tzꞌibꞌan can chirij ri xuꞌon ri David y ri i-rachꞌil chupan ri ojier can tiempo antok xnem-pa quipan? ");
INSERT INTO cakSNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xuoc pa rachuoch ri Dios chi xirucanuj ri chica nutej. Y ri sacerdote ri más cꞌo rukꞌij chupan ri tiempo reꞌ ja ri Abiatar. Y can ja ri sagrada simíta ri xbꞌayoꞌx-pa cha. Y ri simíta reꞌ man joꞌc ta ri David ri xcꞌuxu, xa can xuyaꞌ jeꞌ chica ri i-bꞌanak riqꞌuin. Pero man pecado ta ri xquiꞌan, mesque ri simíta reꞌ joꞌc ri sacerdotes ri ncaꞌcꞌuxu. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y xuꞌej jeꞌ chica: Ri Dios cuma ri vinak xuꞌon can ri kꞌij richin uxlanien; y man ruma ta ri kꞌij richin uxlanien xaꞌruꞌon ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rumareꞌ vacame tivatamaj chi ri Xtak-pa chicaj chi xalax chiꞌicajol, Rajaf ri kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y ri Jesús xuoc chic jun bꞌay ri pa sinagoga, y chiquicajol ri vinak ri quimaluon-quiꞌ, cꞌo jun ache chakeꞌj jun rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero icꞌo ri joꞌc niquitzꞌat-apa ri Jesús y quiyoꞌien chi xa xtuꞌon sanar ri ache, chi quireꞌ niquiꞌan acusar chi xsamaj chupan jun kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pero ri Jesús xuꞌej cha ri ache chakeꞌj ri rukꞌaꞌ: Capalaj y capiꞌieꞌ pa nicꞌaj, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y ri Jesús xuꞌej chica ri vinak ri icꞌo chireꞌ: ¿Chica ri más otz niꞌan chupan jun kꞌij richin uxlanien, ja ri otz o ja ri man otz ta? ¿Ri nicuol jun vinak choch ri camic o niquimisas? xchaꞌ chica. Pero quinojiel man jun tzij ri xquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Y ri Jesús xaꞌrucaꞌyiej ri quimaluon-quiꞌ chireꞌ, xpa rayoval y xbꞌisuon-ka, ruma xutzꞌat chi cof quibꞌanun cha ri cánima y man nicajoꞌ ta niquinimaj. Después xuꞌej cha ri ache ri chakeꞌj jun rukꞌaꞌ: Tayukuꞌ la akꞌaꞌ. Y ri ache xuyuk ri rukꞌaꞌ, y ja otz xuꞌon ri rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y ri achiꞌaꞌ fariseos xaꞌiel chireꞌ chi xbꞌaquimalo-quiꞌ quiqꞌuin ri i-ruvinak ri rey Herodes, chi niquiꞌan pensar ri chica niquiꞌan cha ri Jesús, ruma nicajoꞌ niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y ri Jesús y ri ru-discípulos xaꞌa chuchiꞌ ri mar y chirij ri Jesús xaꞌa iqꞌuiy vinak aj-chireꞌ Galilea. Y nicꞌaj ri xaꞌpa Judea, ");
INSERT INTO cakSNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ri Jerusalén, ri Idumea, ri jucꞌan chic ruchiꞌ ri río Jordán, y cierca ri caꞌyeꞌ tanamet ri Tiro y ri Sidón. Can quinojiel ri vinak ri xaꞌlka riqꞌuin ri Jesús, xaꞌpa ruma caxan ri milagros ri ncaꞌruꞌon. Can iqꞌuiy ri vinak ri xaꞌlka. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y ruma iqꞌuiy ri vinak ncaꞌlka riqꞌuin, ri Jesús xuꞌej chica ri ru-discípulos chi tiquiya-pa jun chꞌiti barco cierca, chi quireꞌ xa ri vinak xtiquipitzꞌ, ntuoc chupan ri chꞌiti barco. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ri Jesús can iqꞌuiy ri xaꞌruꞌon sanar. Rumareꞌ ri ncaꞌyavaj quimaluon-quiꞌ chirij, y niquitej quikꞌij chi niquitzꞌom-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y ri itziel tak espíritus antok niquitzꞌat ri Jesús, ncaꞌxuquieꞌ choch y can riqꞌuin quichukꞌaꞌ ncaꞌchꞌoꞌ y niquiꞌej: Atreꞌ ri Rucꞌajuol ri Dios, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ri Jesús ncaꞌruchꞌolij altíra chi man tiquitzijuoj chi chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xjotie-el paroꞌ jun juyuꞌ y xaꞌrayuoj-el ri xaꞌrajoꞌ jajaꞌ chi xaꞌrucꞌuaj y ijejeꞌ xaꞌa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","I-doce (cabꞌalajuj) ri xaꞌruchaꞌ chi ncaꞌcꞌujieꞌ riqꞌuin y chi ncaꞌrutak-el chi niquitzijuoj ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y can xuyaꞌ poder chica chi ncaꞌquiꞌan sanar ri ncaꞌyavaj y chi ncaꞌquilasaj itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri i-doce (cabꞌalajuj) ri xaꞌruchaꞌ ri Jesús, ja ri Simón ri xuꞌej Pedro cha, ");
INSERT INTO cakSNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ri Jacobo y ri Juan ri i-rucꞌajuol ri Zebedeo, ri xuꞌej jeꞌ Boanerges chica; ri tzij Boanerges ntiel: I-ralcꞌual ráya. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri rucꞌajuol ri Alfeo, ri Tadeo, ri Simón ri cꞌo quiqꞌuin ri achiꞌaꞌ ri niꞌeꞌx cananistas chica, ");
INSERT INTO cakSNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xjacho richin ri Jesús. Ri Jesús y ri xaꞌruchaꞌ xaꞌa chupan jun jay. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Y ruma altíra iqꞌuiy vinak ri xquimol-quiꞌ jun chic bꞌay, ri Jesús y ri ru-discípulos manak cheꞌl xaꞌvaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y antok ri rachꞌalal ri Jesús xquinaꞌiej nojiel reꞌ, ja xaꞌlka chi nalquimaꞌ, ruma ijejeꞌ xquiꞌan pensar chi ri Jesús xuꞌon-ka chꞌuꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Pero ri achiꞌaꞌ escribas ri i-patanak pa tanamet Jerusalén, niquitzijuoj chiquivach chi ri Jesús cꞌo ri Beelzebú riqꞌuin, ri quijaval ri itziel tak espíritus y niquiꞌej chi jareꞌ ri nibꞌano cha chi nitiquir ncaꞌralasaj ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y rumareꞌ ri Jesús xaꞌrayuoj chi xaꞌjiel-apa riqꞌuin y xutzijuoj jun parábola (cꞌambꞌal-tzij) chiquivach, y quireꞌ xuꞌej chica: ¿Cheꞌl reꞌ chi ja mismo ri Satanás ncaꞌralasaj-el ri rusamajiel? ");
INSERT INTO cakSNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ruma xa ri vinak richin jun reino caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri reino reꞌ xa nitzak. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y quireꞌ jeꞌ chupan jun jay, xa caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri jay reꞌ xa niqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y xa ri Satanás nuꞌon-ka ayoval quiqꞌuin ri i-rusamajiel, xa nipalaj chirij jajaꞌ mismo. Ruma xa quireꞌ nuꞌon, ruyuon nicꞌujieꞌ can y chaꞌnin nitzak. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Y xa cꞌo jun ri nrajoꞌ nuꞌon alakꞌ pa rachuoch jun ache ri altíra ruchukꞌaꞌ, naꞌay nuxim, cꞌajareꞌ cꞌo cheꞌl nucanuj-el nojiel ri nrajoꞌ nucꞌuaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Y can ketzij cꞌa ri niꞌej chiva, chi xa chica-na pecados niquiꞌan ri vinak choch ri ulief, cꞌa ncaꞌan perdonar. Hasta ri itziel ncaꞌchꞌoꞌ chirij ri Dios, cꞌa ncaꞌan perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero ri itziel nichꞌoꞌ chirij ri Espíritu Santo, man niꞌan ta perdonar sino que xtiꞌan castigar richin nojiel tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús quireꞌ xuꞌej chica ri achiꞌaꞌ escribas, ruma ijejeꞌ niquiꞌej chirij jajaꞌ chi cꞌo itziel espíritu riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y ri rutieꞌ y ri i-ruchakꞌ ri Jesús xaꞌpa cꞌa pacheꞌ cꞌo-ve jajaꞌ. Pero xa juviera xaꞌcꞌujie-ve. Xa xquitak royoxic chi nicajoꞌ ncaꞌchꞌoꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y ri vinak ri i-tzꞌuyul riqꞌuin ri Jesús xquiꞌej-apa cha: Ri atieꞌ y ri achakꞌ icꞌo juviera y ncatquicanuj. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ri Jesús xuꞌej: ¿Chica ri ntieꞌ y ri nchakꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y xaꞌrucaꞌyiej quinojiel ri i-tzꞌuyul riqꞌuin y xuꞌej chica: Jareꞌ ri ntieꞌ y ri nchakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ruma quinojiel ri ncaꞌbꞌano ri nrajoꞌ ri Dios, jareꞌ ri ntieꞌ, ri vanaꞌ y ri nchakꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Y ri Jesús xꞌa chic chuchiꞌ ri mar y jajaꞌ ncaꞌrutijuoj ri vinak riqꞌuin ri ruchꞌabꞌal ri Dios. Y iqꞌuiy vinak ri xquimol-apa-quiꞌ riqꞌuin. Rumareꞌ jajaꞌ xuoc chupan jun barco ri cꞌo paroꞌ ri mar y xtzꞌuye-ka chupan. Y pan ulief chuchiꞌ ri mar icꞌo ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Y jajaꞌ qꞌuiy kax xucꞌut chiquivach ruyuon riqꞌuin parábolas (cꞌambꞌal-tzij). Jajaꞌ xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tivaxaj jaꞌal ri xtinꞌej chiva: Cꞌo jun ache ri xꞌa chi xbꞌaruquiraj ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Y antok ri ache nuquiraj ri ijaꞌtz, cꞌo ijaꞌtz xaꞌka pa bꞌay. Y xaꞌpa ri chicop ri cꞌo quixicꞌ, xquimol-el ri ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Nicꞌaj chic ijaꞌtz xaꞌka chiquicajol abꞌaj y chireꞌ xa man qꞌuiy ta ulief cꞌo, rumareꞌ chaꞌnin xaꞌiel-pa ruma man pin ta ri ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero antok xpa ruchukꞌaꞌ ri kꞌij, xaꞌyamayo-ka, y ruma man naj ta bꞌanak-ka ri quixieꞌ, mareꞌ xaꞌchakej-ka chaꞌnin. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y nicꞌaj chic ijaꞌtz xaꞌka chiquicajol tak qꞌuix. Y antok xaꞌiel-pa, junan xaꞌqꞌuiy quiqꞌuin ri qꞌuix, y xaꞌjiekꞌ chiquicajol ri qꞌuix y man jun quivach xcꞌujieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Pero nicꞌaj chic ijaꞌtz xaꞌka pan utzulaj ulief y jaꞌal xquiyaꞌ quivach, ruma xaꞌiel-pa ri ticuon can y xaꞌqꞌuiy jaꞌal; cꞌo ri xquiyaꞌ a treinta quivach, cꞌo ri xquiyaꞌ a sesenta y cꞌo ri xquiyaꞌ a cien quivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ri Jesús xuꞌej jeꞌ: Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y antok ri Jesús y ri i-doce (cabꞌalajuj) ru-discípulos quiyuon xaꞌcꞌujieꞌ can quiqꞌuin ri nicꞌaj vinak, xquicꞌutuj cha chirij ri chica nrajoꞌ nuꞌej ri parábola (cꞌambꞌal-tzij). ");
INSERT INTO cakSNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y jajaꞌ xuꞌej chica: Chiva ixreꞌ yoꞌn chi ntinaꞌiej chirij ri ru-reino ri Dios. Pero chica ri vinak ri man nquinquinimaj ta, xa riqꞌuin parábolas (cꞌambꞌal-tzij) nquichꞌo-ve chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chi quireꞌ xa choj niquitzꞌat y man niquiyaꞌ ta pa cuenta ri niquitzꞌat, y joꞌc nicaꞌxaj y man xtiꞌka ta pa quiveꞌ (man xtiquiꞌan ta entender) ri nicaꞌxaj, chi quireꞌ man niquiyaꞌ ta can ri pecado chi niquiꞌan ri nrajoꞌ ri Dios, y man xtiꞌan ta perdonar ri qui-pecados. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y ri Jesús xuꞌej jeꞌ chica: ¿Man xiꞌka ta pan iveꞌ (man xiꞌan ta entender) ri parábola (cꞌambꞌal-tzij) ri xintzijuoj chiva? ¿Cheꞌl xtiꞌka pan iveꞌ (xtiꞌan entender) ri nicꞌaj chic parábolas (cꞌambꞌal-tzij)? ");
INSERT INTO cakSNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri ache aj-ticoniel, jareꞌ ri rusamajiel ri Dios ri nutzijuoj ri ruchꞌabꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri ijaꞌtz ri xaꞌka pa bꞌay, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios, y ri Satanás chaꞌnin nipa quiqꞌuin y nralasaj-el ri chꞌabꞌal ri xtic can pa cánima. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri ijaꞌtz ri xaꞌka chiquicajol abꞌaj, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios y can altíra ncaꞌquicuot antok niquiꞌan recibir. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero ruma manak ruxieꞌ ri ruchꞌabꞌal ri Dios riqꞌuin cánima, rumareꞌ man ncaꞌlayuj ta ncaꞌquicuot. Ruma antok ncaꞌpa ri sufrimientos y itziel ncaꞌtzꞌiet ruma quiniman ri ruchꞌabꞌal ri Dios, chaꞌnin ncaꞌtzak. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y ri ijaꞌtz ri xaꞌka chiquicajol tak qꞌuix, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios, ");
INSERT INTO cakSNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","pero xa ja ri nicꞌatzin chica kꞌij-kꞌij choch-ulief, joꞌc reꞌ ninataj chica y niꞌan maña chica ruma ri bꞌayomal. Y ruma nicajoꞌ chi quiqꞌuin ta ijejeꞌ cꞌo-ve ri cꞌo riqꞌuin jun chic, jareꞌ nibꞌano chi nijiekꞌ ri ruchꞌabꞌal ri Dios riqꞌuin cánima. Rumareꞌ man jun otz xtikꞌalajin pa quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Y ri ijaꞌtz ri xaꞌka pan utzulaj ulief, ja ri nicaꞌxaj ri ruchꞌabꞌal ri Dios y niquiꞌan recibir. Ri quicꞌaslien can nikꞌalajin jaꞌal, y can niquiyaꞌ qui-fruto a treinta, a sesenta o a cien. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ri Jesús xuꞌej jeꞌ chica: Antok nicꞌamar-pa jun lámpara chi nuyaꞌ sakil pa jay, ¿chuxieꞌ came jun cajuon o chuxieꞌ came jun chꞌat niyoꞌx-ve? Ri lámpara chicaj niyoꞌx-ve, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ruma man jun kax ri avan-can, ri man ta xtibꞌakꞌalajin-pa. Y man jun ri tzꞌapin can ruveꞌ, ri man ta xtibꞌakꞌalajin-pa choch sakil. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y ri Jesús xuꞌej jeꞌ chica ri vinak: Ixreꞌ ri ntivaxaj ri ruchꞌabꞌal ri Dios, tivaxaj otz y tibꞌanaꞌ ri nuꞌej. Ruma can incheꞌl ri ntiꞌan ixreꞌ chica ri vinak, quireꞌ xtiꞌan chiva ixreꞌ; y man joꞌc ta reꞌ, xa xtiyoꞌx más ruveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ruma ri cꞌo riqꞌuin, can xtiyoꞌx más cha. Pero ri xa man qꞌuiy ta cꞌo riqꞌuin, hasta reꞌ xtalasas-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y ri Jesús xuꞌej jeꞌ: Ri ru-reino ri Dios can nibꞌanataj incheꞌl nibꞌanataj riqꞌuin ri ijaꞌtz ri nutic can jun ache ri pan ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jajaꞌ nivar ri chakꞌaꞌ y nipalaj-pa antok nisakar-pa, y quireꞌ nuꞌon kꞌij-kꞌij. Y ri ijaꞌtz ntiel-pa y niqꞌuiy. Pero ri ache ri tiquiyuon can, man rataꞌn ta chica nuꞌon ri ijaꞌtz chi ntiel-pa y chica nuꞌon chi niqꞌuiy. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ruma xa ja ri ulief nibꞌano chi ntiel-pa ri ijaꞌtz. Naꞌay antok ntiel-pa, chꞌuteꞌn-oc kꞌayis, después antok nem chic, niqꞌuiy-pa ri ruveꞌ. Y pa ruqꞌuisbꞌal ninuoj-pa ri rupan ri ruveꞌ riqꞌuin ri runakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y antok kꞌan chic, ja nijuk cha juos, ruma ja xalka ri tiempo richin ri cosecha. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y ri Jesús xuꞌej jeꞌ: ¿Choj-iqꞌuin junan ri ru-reino ri Dios? ¿Y chica parábola (cꞌambꞌal-tzij) nicusaj chi niꞌan comparar? ");
INSERT INTO cakSNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Xa incheꞌl ri ijaꞌtz richin ri mostaza antok nitic pan ulief. Y xa jareꞌ ri ijaꞌtz ri más coꞌl ri cꞌo choch ri ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero antok niqꞌuiy, jareꞌ ri más nem ntiel chiquivach quinojiel kꞌayis, y nuꞌon nimaꞌk ri rukꞌaꞌ. Rumareꞌ ri chicop ri cꞌo quixicꞌ niquiꞌan quisuoc chukꞌaꞌ, ruma chireꞌ jaꞌal ncaꞌmujan. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ri Jesús antok nutzijuoj ri ruchꞌabꞌal ri Dios chica ri vinak, xaꞌrucusaj parábolas (cꞌambꞌal-tzij) ruma nrajoꞌ chi nicaꞌxaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Y man jun tzij ri xuꞌej chica, ri man ta xucusaj parábolas (cꞌambꞌal-tzij). Pero antok ri Jesús y ri ru-discípulos quiyuon icꞌo can, jajaꞌ can nuꞌej chica ri chica nrajoꞌ nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y antok xcokꞌa-ka chupan ri kꞌij reꞌ, ri Jesús xuꞌej chica ri ru-discípulos: Kojakꞌax-apa jucꞌan chic ruchiꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Y jajaꞌ xaꞌruꞌon can despedir ri vinak. Y ruma can tzꞌuyul chic chupan ri barco, can quireꞌ rubꞌanun xucꞌuax cuma ri ru-discípulos. Y icꞌo jeꞌ nicꞌaj chic barcos ri junan xaꞌiel-el quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y antok i-bꞌanak paroꞌ ri mar, xpa jun cakꞌiekꞌ ri altíra nem. Y rumareꞌ ri yaꞌ nipalaj chicaj y nalruquiraj-riꞌ chirij ri barco ri choj chupan i-bꞌanak-ve, y xuoc yaꞌ chupan. Riqꞌuin reꞌ jubꞌaꞌ ma niꞌa-ka chuxieꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero ri Jesús xa nivar bꞌanak chupan ri barco. Jajaꞌ chirij can ri barco rucanun-ve jun ruchꞌacaveꞌ. Y xaꞌpa ri discípulos, xquicꞌasuoj y xquiꞌej cha: ¡Maestro! Vacame nkucon y atreꞌ xa ncavar, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y ri Jesús xpalaj-pa y xchꞌolin cha ri cakꞌiekꞌ y xuꞌej cha ri mar chi titanie-ka. Y quireꞌ xbꞌanataj. Ri cakꞌiekꞌ xqꞌuis-el ruchukꞌaꞌ y xtanie-ka jeꞌ ri mar. ");
INSERT INTO cakSNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ri Jesús xuꞌej chica: ¿Karruma xixiꞌij-iviꞌ? ¿Man icukubꞌan ta icꞌuꞌx viqꞌuin cꞌa? ");
INSERT INTO cakSNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero ri discípulos altíra quixiꞌin-quiꞌ y niquiꞌej chiquivach: ¿Chica cꞌa chi ache va chi ri cakꞌiekꞌ y ri mar can xaꞌniman cha? ");
INSERT INTO cakSNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y ri Jesús y ri ru-discípulos xaꞌbꞌaka ri jucꞌan chic ruchiꞌ ri mar, chupan ri lugar rubꞌinan Gadara. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y antok ri Jesús xiel-pa chupan ri barco, can ja xalka jun ache riqꞌuin, ri pa cementerio alanak-ve-pa, ri cꞌo itziel espíritu riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri ache reꞌ ja ri cementerio ri acunak rachuoch, y man jun nitiquir chirij, hasta riqꞌuin cadena (yariena) man i-tiquirnak ta chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ruma qꞌuiy mul quiyoꞌn cadena (yariena) y nicꞌaj chic chꞌichꞌ chirij ri rukꞌa-rakan, pero i-rukꞌochpin, i-rukꞌajuon nojiel. Can man jun tiquirnak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi pakꞌij chi chakꞌaꞌ siempre nibꞌiej pa tak juyuꞌ y pa cementerio, nurak ruchiꞌ y nusocola-riꞌ cha abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y antok jajaꞌ xutzꞌat-pa ri Jesús chi-naj, xpa anin y xalxuquieꞌ choch. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y riqꞌuin ruchukꞌaꞌ xchꞌoꞌ cha ri Jesús y xuꞌej: ¿Chica navajoꞌ chuva Jesús ri Rucꞌajuol ri Namalaj Dios? Pa rubꞌeꞌ ri Dios nicꞌutuj chava, man quinachꞌujirisaj, xchaꞌ cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ri ache xuꞌej quireꞌ ruma ri Jesús ruꞌeꞌn chic cha ri itziel espíritu ri cꞌo riqꞌuin chi tiel-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y ri Jesús xucꞌutuj cha: ¿Cheꞌl abꞌeꞌ? Y jajaꞌ xuꞌej-pa: Legión nubꞌeꞌ; ruma oj qꞌuiy, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y can altíra xucꞌutuj cꞌa favor cha ri Jesús chi man caꞌralasaj-el chupan ri lugar reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y cierca-apa ri lugar reꞌ, paroꞌ jun juyuꞌ, iqꞌuiy ak ncaꞌvaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y quinojiel ri itziel tak espíritus ri icꞌo riqꞌuin ri ache xquicꞌutuj favor cha ri Jesús, y xquiꞌej cha: Tayaꞌ permiso chika chi nkojuoc quiqꞌuin ri ak reꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús xuyaꞌ permiso chica. Y ri itziel tak espíritus ja xaꞌiel-el y xaꞌbꞌaꞌuoc quiqꞌuin ri ak. Ri ak reꞌ icaꞌyeꞌ mil. Y quinojiel ri ak reꞌ jun-anin xaꞌbꞌaxulie-pa choch jun juyuꞌ can paꞌl-roch, y cꞌa chupan ri mar xaꞌbꞌaka-ve; y chireꞌ xaꞌjiekꞌ-ve quinojiel ri ak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Y ri ncaꞌchajin quichin ri ak xaꞌnumaj, y xbꞌaquitzijuoj ri xbꞌanataj pa tanamet y pa tak avan. Y ri vinak xaꞌpa cꞌa chi nalquitzꞌataꞌ ri chica xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y antok ri vinak reꞌ xaꞌlka riqꞌuin ri Jesús, xquitzꞌat chi ri ache ri xcꞌujieꞌ ri jun legión (6,000) itziel tak espíritus riqꞌuin; tzꞌuyul, rucusan rutziak y man nuꞌon ta chic cꞌa ri incheꞌl rubꞌanun-pa. Rumareꞌ ri vinak xa xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y ri vinak ri xaꞌtzꞌato ri xbꞌanataj riqꞌuin ri ache ri xaꞌlasas-el ri itziel tak espíritus riqꞌuin y ri xbꞌanataj quiqꞌuin ri ak, xquitzijuoj cꞌa chica ri nicꞌaj chic vinak ri i-patanak chutzꞌatic ri xbꞌanataj chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Y ruma cꞌa reꞌ quinojiel ri vinak xquicꞌutuj favor cha ri Jesús chi tiel-el chireꞌ chupan ri qui-lugar. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Antok ntuoc-oc ri Jesús chupan ri barco, ri ache ri xaꞌcꞌujieꞌ itziel tak espíritus riqꞌuin, nucꞌutuj favor cha ri Jesús chi niꞌa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ri Jesús man xrajoꞌ ta. Xa xuꞌej cha: Caꞌin chavachuoch y atzijuoj chica ri avachꞌalal ri nem samaj ri xuꞌon ri Ajaf aviqꞌuin, y cheꞌl xjoyovax avach. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y ri ache xꞌa cꞌa, y xutzꞌom rutzijoxic chupan ri lugar rubꞌinan Decápolis, ri nem samaj ri xuꞌon ri Jesús cha, y ri vinak can altíra xaꞌchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ri Jesús xuoc chic chupan ri barco chi xakꞌax jucꞌan chic ruchiꞌ ri mar. Y antok xalka, altíra iqꞌuiy vinak ri xquimol-quiꞌ chirij. Jajaꞌ chuchiꞌ ri mar xcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Y xalka jun ache rubꞌinan Jairo, ri jun principal chupan ri sinagoga. Y antok xutzꞌat-apa ri Jesús, ja xbꞌaxuquieꞌ chukul rakan, ");
INSERT INTO cakSNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","y altíra xuꞌon rogar choch ri Jesús y xuꞌej cha: Ri numiꞌal niyavaj y ya nicon. Catam-pa y taꞌyaꞌ ri akꞌaꞌ paroꞌ chi nuꞌon sanar y can xticꞌasieꞌ, xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y ri Jesús can xꞌa cꞌa riqꞌuin ri ache, y iqꞌuiy vinak xaꞌa chirij, rumareꞌ niquipitzꞌ ri Jesús i-bꞌanak. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Pero jun ixok ri cꞌo doce (cabꞌalajuj) junaꞌ ri ntiel ruquiqꞌuiel y man nitanieꞌ ta, ruma jun yabꞌil, ");
INSERT INTO cakSNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","altíra rubꞌanun-pa sufrir ruma bꞌanak quiqꞌuin qꞌuiy doctores, y ya xuqꞌuis nojiel ri ru-miera y man jun otz ranun cha, xa más peor ranun cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ri ixok reꞌ raxan-pa chirij ri milagros ri ncaꞌruꞌon ri Jesús y bꞌanak chiquicajol ri vinak ri i-bꞌanak chirij ri Jesús. Jajaꞌ xjiel-apa chirij ri Jesús y xutzꞌom-apa ri rutziak, ");
INSERT INTO cakSNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ruma nuꞌej pa ránima: Xa ta riqꞌuin nitzꞌom-apa jubꞌaꞌ ri rutziak, ja niꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y chaꞌnin xtanieꞌ ri ruquiqꞌuiel ri ntiel. Y xunaꞌ chi xuꞌon sanar riqꞌuin ri ruyabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús can chaꞌnin xunaꞌ chi cꞌo jun xuꞌon sanar ruma ri poder ri xiel riqꞌuin; rumareꞌ xtzuꞌn can chirij, y xuꞌej chica ri vinak: ¿Chica xtzꞌamo ri nutziak? ");
INSERT INTO cakSNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Y ri ru-discípulos xquiꞌej cha: Natzꞌat chi iqꞌuiy vinak ncatquipitzꞌ y atreꞌ naꞌej: ¿Chica xitzꞌamo? xaꞌchaꞌ ri discípulos cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús ncaꞌrucaꞌyiej ri vinak, chi nucanuj ri chica xtzꞌamo ri rutziak. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ri ixok ruxiꞌin-riꞌ y nibꞌarbꞌuot, ruma rataꞌn chi xuꞌon sanar riqꞌuin ri ruyabꞌil, xpa cꞌa y xalxuquieꞌ choch ri Jesús y xuꞌej cꞌa cha nojiel ri xuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y ri Jesús xuꞌej cha: Numiꞌal, xacꞌachoj ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin. Vacame caꞌin en paz. Ri ayabꞌil man chic xtitzalaj ta pa, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y cꞌa nitzijuon ri Jesús riqꞌuin ri ixok, antok xaꞌlka nicꞌaj ri i-patanak chirachuoch ri ache principal chupan ri sinagoga. Ijejeꞌ xalquiꞌej cha ri ache principal: Ri amiꞌal ya xcon, man chic taꞌan molestar ri Maestro. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero ri Jesús xraꞌxaj ri niquiꞌej, y xuꞌej cha ri jun principal chupan ri sinagoga: Man taxiꞌij-aviꞌ, joꞌc tanimaj, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús man xuꞌon ta permitir chi xaꞌa nicꞌaj chic chirij, xa joꞌc ri Pedro, ri Jacobo y ri Juan ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Jacobo. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y antok xaꞌbꞌaka chirachuoch ri jun principal chupan ri sinagoga, ri Jesús xaꞌrutzꞌat chi ri vinak ncaꞌchꞌujuyan pa jay, can altíra ncaꞌuokꞌ y altíra ncaꞌbꞌisuon. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Antok ri Jesús acunak chic oc pa jay, xuꞌej chica: ¿Karruma nquixuokꞌ y nquixchꞌujuyan? Ri chꞌiti xtan xa man quiminak ta, xa nivar, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero ijejeꞌ xa xaꞌtzeꞌn chirij ri Jesús. Pero ri Jesús xaꞌralasaj-el juviera quinojiel ri vinak ri icꞌo chireꞌ, y xaꞌrucusaj-oc ri rutie-rutataꞌ ri chꞌiti xtan y ri iyoxeꞌ chic ri i-bꞌanak riqꞌuin, pacheꞌ cꞌo-ve ri ru-cuerpo ri chꞌiti xtan. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Y xutzꞌom rukꞌaꞌ ri chꞌiti xtan y xuꞌej cha: Talita cumi, xchaꞌ. Ri tzij reꞌ ntiel: Chꞌiti xtan, chava atreꞌ niꞌej chi capalaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Can joꞌc xuꞌej quireꞌ ri Jesús, can ja xpalaj-pa ri chꞌiti xtan y xꞌin, ruma cꞌo doce (cabꞌalajuj) rujunaꞌ. Y ri icꞌo riqꞌuin altíra xaꞌchapataj antok xquitzꞌat chi xcꞌastaj chic pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ri Jesús xuꞌon mandar chica chi man jun choj cha tiquitzijuoj ri xbꞌanataj, y xuꞌej chi tiyoꞌx ruvay ri chꞌiti xtan. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y ri Jesús xiel-el chireꞌ, xꞌa pa rutanamit pacheꞌ xqꞌuiy-pa, y ri ru-discípulos i-bꞌanak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y antok xalka ri kꞌij richin uxlanien, jajaꞌ xucꞌut ri ruchꞌabꞌal ri Dios chupan ri sinagoga. Y ruma ri tzij ri nuꞌej, ri vinak ri quimaluon-quiꞌ chireꞌ antok xcaꞌxaj, can xaꞌchapataj, y xquiꞌej: ¿Chica chi noꞌj va y chi nitiquir ncaꞌruꞌon milagros? ¿Pacheꞌ cꞌa rucꞌamun-pa nojiel va? ");
INSERT INTO cakSNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Man ja ta came va ri carpintero, ral ri María, y ri i-ruchakꞌ ja ri Jacobo, ri José, ri Judas y ri Simón? ¿Man icꞌo ta cꞌa jeꞌ ri ranaꞌ kiqꞌuin? xaꞌchaꞌ. Y rumareꞌ ri vinak man xquinimaj ta y xpa quiyoval chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y ri Jesús xuꞌej chica: Jun profeta joꞌc ri rutanamit, ri rachꞌalal y ri pa rachuoch niquiꞌan cha chi man jun rakalien, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y man jun milagro xuꞌon ri Jesús pa rutanamit. Xa nicꞌaj-oc ri ncaꞌyavaj ri xuyaꞌ rukꞌaꞌ pa quiveꞌ chi xaꞌruꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y jajaꞌ can xchapataj ruma ri vinak xa man xquinimaj ta. Y xꞌa cꞌa pa tak aldeas ri icꞌo cierca ri rutanamit chi nucꞌut ri ruchꞌabꞌal ri Dios chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Después xaꞌrayuoj ri doce (cabꞌalajuj) discípulos. Y chi cacaꞌ chi cacaꞌ xaꞌrutak-el, y xuyaꞌ autoridad chica chi ncaꞌtiquir ncaꞌquilasaj itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y jajaꞌ xuꞌej chica chi joꞌc quichꞌameꞌy tiquicꞌuaj y man jun chic chica tiquicꞌuaj. Man tiquicꞌuaj qui-buolsa, ni simíta, ni qui-miera pa tak ximbꞌal-quipan. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man tiquicusaj-el caꞌyeꞌ quitziak. Pero otz chi niquicusaj-el quixajabꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y ri Jesús xuꞌej-el chica ri ru-discípulos: Xa chica-na jay pacheꞌ nquixuoc-ve, chireꞌ quixcꞌujie-ve-ka y cꞌajaꞌ antok nquixiel-pa chupan ri tanamet, cꞌajareꞌ xtiyaꞌ can ri jay ri pacheꞌ xixcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y ri pacheꞌ nquixbꞌaka-ve, xa man nquixquiꞌan ta recibir y man nicajoꞌ ta nicaꞌxaj ri ruchꞌabꞌal ri Dios ri ntitzijuoj ixreꞌ chica, quixiel-pa chireꞌ y titotaꞌ can ri pokolaj ri cꞌo pa tak ivakan chiquivach ri vinak reꞌ, chi quireꞌ niquitzꞌat chi man otz ta ri xquiꞌan. Inreꞌ can ketzij cꞌa ri niꞌej chiva, chi chupan ri kꞌij antok ri vinak xcaꞌan juzgar ruma ri Dios, ri vinak richin ri tanamet pacheꞌ man xixcꞌul ta, más nem ri castigo ri xtika pa quiveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri vinak ri xaꞌcꞌujieꞌ pa tanamet Sodoma y Gomorra, xcha-el chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y ri discípulos xaꞌa. Ijejeꞌ xquiꞌej chica ri vinak chi titzalaj-pa cánima riqꞌuin ri Dios y tiquibꞌanaꞌ ri nrajoꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ri discípulos qꞌuiy itziel tak espíritus ri xaꞌquilasaj. Y xquiyaꞌ aceite de olivo pa quiveꞌ iqꞌuiy ncaꞌyavaj y xaꞌquiꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Y ri rey Herodes xraꞌxaj ri nuꞌon ri Jesús chiquicajol ri vinak. Mareꞌ ri Herodes xuꞌej-ka: Ri Juan el Bautista xa xcꞌastaj-pa chiquicajol ri quiminakiꞌ, y rumareꞌ cꞌo qꞌuiy poder riqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero icꞌo vinak xquiꞌej chi ri Jesús xa ja ri Elías. Y icꞌo nicꞌaj chic xquiꞌej chi jajaꞌ jun profeta o jun chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Antok ri Herodes xraꞌxaj ri niquiꞌej ri vinak, xuꞌej: Ri ache reꞌ xa ja ri Juan el Bautista ri xinꞌej chi xcꞌamar-el rujaluon, y vacame xcꞌastaj-pa chiquicajol ri quiminakiꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ruma xa ja mismo ri rey Herodes ri xꞌeꞌn chi xtzꞌam ri Juan, xyoꞌx pa cárcel y xtzꞌam cha cadena (yariena). Ri Herodes quireꞌ xuꞌon, ruma quicꞌamun-quiꞌ riqꞌuin ri Herodías, ri xa raxjayil ri Felipe ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Herodes. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ruma ri Juan xuꞌej cha ri Herodes: Man otz ta chi abꞌanun avaxjayil cha ri Herodías, ruma jajaꞌ xa raxjayil ri Felipe ri achakꞌ-animal-aviꞌ riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Rumareꞌ ri Herodías can nrajoꞌ nuquimisaj ri Juan ruma royoval chirij, pero man riluon ta cheꞌl nuꞌon cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ruma ri rey Herodes rataꞌn chi ri Juan jun utzulaj ache y choj rucꞌaslien choch ri Dios, mareꞌ nuxiꞌij-riꞌ choch. Can ranun cha chi otz chajin chi quireꞌ man jun kax nuꞌon pasar. Jajaꞌ can jaꞌal nraꞌxaj antok ri Juan nutzijuoj ri ruchꞌabꞌal ri Dios cha. Pero ri Herodes man niril ta chica nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Pero ri kꞌij ri royoꞌien ri Herodías chi nika ri Juan pa rukꞌaꞌ, xalka chupan ri kꞌij antok ri Herodes xuqꞌuis chic jun rujunaꞌ. Jajaꞌ xuꞌon jun namakꞌej y xuyaꞌ jun nem vaꞌen y xaꞌruꞌon invitar ri gobernadores ri ncaꞌsamaj chupan ri ru-gobierno, y xaꞌrayuoj ri qui-jefes ri soldados y xaꞌrayuoj jeꞌ ri achiꞌaꞌ principales chiquicajol ri aj-Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y pacheꞌ quimaluon-ve-quiꞌ ijejeꞌ, xuoc-pa ri ral-xtan ri Herodías; y jajaꞌ xxajo chiquivach. Y altíra xka choch ri Herodes y chiquivach quinojiel ri icꞌo riqꞌuin. Y ri rey Herodes xuꞌej cha ri xtan: Tacꞌutuj ri chica navajoꞌ y niyaꞌ chava. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Can niꞌan jurar chavach, chi chica-na ri xtacꞌutuj chuva, xtinyaꞌ chava, hasta la mitad ri nu-reino, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ri xtan xiel-el y xbꞌarucꞌutuj cha ri rutieꞌ: ¿Chica ta nicꞌutuj cha? Y ri rutieꞌ xuꞌej cha ri ral: Tacꞌutuj chi tiyoꞌx chava ri rujaluon ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y ri xtan chaꞌnin xtzalaj-pa riqꞌuin ri rey Herodes y xalruꞌej cha: Inreꞌ nivajoꞌ chi orita nayaꞌ chuva chupan jun plato ri rujaluon ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y ri rey Herodes altíra xbꞌisuon-ka ránima rumareꞌ, pero ruma can rubꞌanun yan jurar y cuma ri icꞌo riqꞌuin chirij ri mesa, rumareꞌ jajaꞌ xuꞌon ri xucꞌutuj ri xtan cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y ri rey chaꞌnin xutak-el jun soldado chi ticꞌam-pa ri rujaluon ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ri soldado xꞌa cꞌa, y xucꞌan-el ri rujaluon ri Juan el Bautista chireꞌ pa cárcel. Y ri rujaluon xuyaꞌ cha ri xtan chupan jun plato, y ri xtan xbꞌaruyaꞌ cha ri rutieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Antok ri ru-discípulos ri Juan xcaꞌxaj chi xquimisas, xaꞌlka chi xalquimaꞌ ri ru-cuerpo y xbꞌaquimukuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri ru-apóstoles ri Jesús, antok xaꞌtzalaj-pa chi xiꞌquibꞌanaꞌ rusamaj ri Dios y xquimol chic quiꞌ riqꞌuin ri Jesús, xquiꞌej cha nojiel ri chica xquiꞌan y ri chica xquicꞌut chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y ri Jesús xuꞌej chica: Joꞌ jun lugar pacheꞌ manak vinak chi nquixuxlan jubꞌaꞌ. Y quireꞌ xuꞌej chica ruma iqꞌuiy vinak ri ncaꞌiel-ncaꞌuoc quiqꞌuin y rumareꞌ hasta manak chic cheꞌl ncaꞌvaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y ri Jesús y ri ru-discípulos xaꞌuoc chupan jun barco chi ncaꞌkꞌax jucꞌan ruchiꞌ ri yaꞌ, y xaꞌa chupan jun lugar pacheꞌ manak vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero antok ijejeꞌ xaꞌa, iqꞌuiy vinak ri xaꞌtzꞌato-el quichin y xcatamaj-el quivach. Rumareꞌ ri vinak reꞌ xaꞌa chicakan, y ri pa tak bꞌay xaꞌiel-el más ri pa tak tanamet ri pacheꞌ xaꞌkꞌax-ve. Y xa ja yan chic ri vinak ri xaꞌbꞌaka naꞌay chiquivach. Y antok ri Jesús y ri ru-discípulos xaꞌbꞌaka, ri vinak xquimol-ka-quiꞌ chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y antok ri Jesús xiel-pa, xutzꞌat chi can iqꞌuiy ri vinak, y jajaꞌ xujoyovaj quivach ruma ri quibꞌanun, can incheꞌl ri ovejas antok man jun ri nichajin quichin. Xucꞌut cꞌa chiquivach qꞌuiy kax ri nicꞌatzin chi nicatamaj chirij ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Antok ya xkakꞌij-ka, ri ru-discípulos xaꞌjiel-apa riqꞌuin ri Jesús y xquiꞌej cha: Chupan va lugar va man jun jay cꞌo y ya tarde chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Caꞌtakaꞌ cꞌa el ri vinak chi caꞌa pa tak aldeas y nicꞌaj chic lugar ri icꞌo cierca, chi tiquilakꞌoꞌ qui-simíta, ruma manak chica niquicꞌux, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero ri Jesús xuꞌej chica: Tiyaꞌ ixreꞌ chi ncaꞌvaꞌ. Y ijejeꞌ xquiꞌej cha: ¿Atreꞌ naꞌej chi nakalakꞌoꞌ doscientos denarios simíta chi ncaꞌvaꞌ ijejeꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y jajaꞌ xucꞌutuj chica: ¿Janeꞌ (jaroꞌ) simíta cꞌo iviqꞌuin? Itzꞌataꞌ cꞌa, xchaꞌ chica. Y antok ijejeꞌ quitzꞌatuon chic, xquiꞌej cha: Cꞌo vuꞌuoꞌ simíta y caꞌyeꞌ car, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jajaꞌ xuꞌej chi tiquiꞌej chica ri vinak chi caꞌtzꞌuye-ka quinojiel paroꞌ ri rax kꞌayis, y chi grupo tiquicꞌuaj-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y ri vinak reꞌ can xaꞌtzꞌuye-ka, y xquicꞌuaj-quiꞌ chi ciento y nicꞌaj tak ciento. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xutzꞌom ri vuꞌuoꞌ simíta y ri caꞌyeꞌ car, xtzuꞌn chicaj, y xuꞌon bendecir, y xaꞌruper ri simíta, y xuyaꞌ chica ri ru-discípulos chi niquijach chiquivach ri vinak. Y quireꞌ mismo xuꞌon riqꞌuin ri car. Xujach chica quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Y quinojiel jaꞌal xaꞌvaꞌ, y otz xnuoj quipan. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y cꞌa cꞌo doce (cabꞌalajuj) chacach ri xaꞌnuoj riqꞌuin ri jutak pir ri simíta y ri car ri xmuol can ri xuꞌon suobra. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Y ri xaꞌvaꞌ icꞌo laꞌk vuꞌuoꞌ mil joꞌc ri achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Y jareꞌ antok ri Jesús xuꞌej chica ri ru-discípulos chi caꞌuoc chupan ri barco y caꞌa naꞌay choch; chi ncaꞌa ri tanamet Betsaida, ri cꞌo jucꞌan chic ruchiꞌ ri yaꞌ; y jajaꞌ cꞌa nicꞌujieꞌ can chi ncaꞌruꞌon can despedir ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y antok ya i-bꞌanak chic quinojiel ri vinak, jajaꞌ xjotie-el paroꞌ jun juyuꞌ chi xirubꞌanaꞌ orar. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Y antok xchakꞌa-ka, ri barco pacheꞌ i-bꞌanak-ve ri discípulos ya pa nicꞌaj ri mar cꞌo-ve-apa, y ri Jesús ruyuon cꞌo can paroꞌ ri juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y ri Jesús xaꞌrutzꞌat-apa chi ri ru-discípulos ya i-cosnak chic, ruma altíra nuꞌon ri cakꞌiekꞌ y man nuyaꞌ ta chic lugar cha ri barco chi choj niꞌin choch. Y antok ya nisakar-pa, ri Jesús patanak chirakan paroꞌ ri mar, y nrajoꞌ nakꞌax chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero antok ri discípulos xquitzꞌat chi cꞌo jun niꞌin paroꞌ ri mar, ijejeꞌ xquiꞌan-ka pensar chi jun fantasma patanak, y xaꞌsiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y ruma quinojiel xaꞌtzꞌato richin, altíra xquixiꞌij-quiꞌ. Pero ri Jesús chaꞌnin xchꞌo-pa chica y xuꞌej: ¡Man tixiꞌij-iviꞌ; tiyaꞌ ivánima viqꞌuin, xa inreꞌ! xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y jajaꞌ xjotie-apa quiqꞌuin chupan ri barco. Y ja xtanie-ka ruchukꞌaꞌ ri cakꞌiekꞌ. Y ri discípulos altíra xaꞌchapataj, ");
INSERT INTO cakSNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ruma majaꞌ tiꞌka pa quiveꞌ (tiquiꞌan entender) ri xuꞌon ri Jesús riqꞌuin ri simíta. Y ijejeꞌ xa cof canun cha ri cánima. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y ijejeꞌ xaꞌkꞌax paroꞌ ri mar y xaꞌbꞌaka Genesaret, ri cꞌo chuchiꞌ ri mar reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y antok xaꞌiel-pa chupan ri barco, ri vinak ri icꞌo chireꞌ chuchiꞌ ri mar, chaꞌnin xquitzꞌat chi ja ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rumareꞌ xquiꞌej chupan nojiel lugar ri icꞌo cierca, chi ri Jesús xalka chupan ri lugar reꞌ. Y ri vinak xaꞌpa nojiel lugar i-quicꞌamun-pa ri ncaꞌyavaj choch qui-camilla, y xaꞌquicꞌuaj choch ri Jesús ri chica lugar nicaꞌxaj pacheꞌ cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y chica-na lugar nakꞌax-ve, pa tak nimaꞌk tanamet, pa tak aldeas y pa tak juyuꞌ jeꞌ, ri vinak xaꞌquiyaꞌ ri ncaꞌyavaj pa tak bꞌay ri pacheꞌ nakꞌax-ve jajaꞌ. Y niquicꞌutuj favor cha chi tuyaꞌ permiso chica chi niquitzꞌom mesque joꞌc ruchiꞌ ri rutziak. Y quinojiel ri xaꞌtzꞌamo ruchiꞌ ri rutziak ri Jesús, xquiꞌan sanar riqꞌuin ri quiyabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chirij ri Jesús xquimol-quiꞌ ri achiꞌaꞌ fariseos, y nicꞌaj achiꞌaꞌ escribas ri i-patanak Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y ri achiꞌaꞌ reꞌ xaꞌquitzꞌat chi icꞌo chiquivach ri ru-discípulos ri Jesús ri man niquichꞌaj ta quikꞌaꞌ antok ncaꞌvaꞌ. Chiquivach ijejeꞌ man sak ta quikꞌaꞌ. Y rumareꞌ man otz ta ri xquiꞌej chiquij, ruma man niquiꞌan ta incheꞌl niquiꞌan ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ruma ri achiꞌaꞌ fariseos y quinojiel ri nicꞌaj chic vinak israelitas, xa ja ri bꞌeꞌn can cuma ri cateꞌt-quimamaꞌ, xa jareꞌ ri ncaꞌquiꞌan. Ruma xa man niquichꞌaj ta quikꞌaꞌ qꞌuiy mul, ja man ncaꞌvaꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y antok ncaꞌtzalaj-pa pa qꞌuiyiꞌal, xa man niquijoskꞌij ta quiꞌ incheꞌl ri bꞌeꞌn can, man ncaꞌvaꞌ ta. Y icꞌo nicꞌaj chic kax ri niquiꞌan jeꞌ; incheꞌl antok niquichꞌaj ri vasos ri richin niquikun quiyaꞌ chupan, ri xára, ri lak ri bꞌanun cha chꞌichꞌ y hasta ri quichꞌat quireꞌ niquiꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumareꞌ ri achiꞌaꞌ fariseos y ri achiꞌaꞌ escribas xquicꞌutuj cha ri Jesús: ¿Karruma ri a-discípulos man niquiꞌan ta incheꞌl ri bꞌeꞌn can cuma ri kateꞌt-kamamaꞌ, ruma antok ncaꞌvaꞌ xa man niquichꞌaj ta quikꞌaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Ixreꞌ xa caꞌyeꞌ ipalaj. Xa otz rubꞌixic ruꞌeꞌn can chivij ri profeta Isaías. Ri xutzꞌibꞌaj can, quireꞌ nuꞌej: Ri vinak reꞌ joꞌc riqꞌuin ri quichiꞌ niquiyaꞌ nukꞌij, pero ri cánima xa naj cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa man jun nicꞌatzin ri niquiꞌan antok niquiyaꞌ nukꞌij, nojiel ri ncaꞌquiꞌej antok ncaꞌquitijuoj ri vinak, xa quinoꞌj achiꞌaꞌ y niquiꞌej chi can jareꞌ tiꞌan. Quireꞌ ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ixreꞌ xa iyoꞌn can jun lado ri ru-mandamiento ri Dios. Xa ja ri tradición ri ntiꞌan, cheꞌl antok ntichꞌaj ri xára y ri vasos ri richin ntikun iyaꞌ chupan. Y nicꞌaj chic kax incheꞌl reꞌ ri ntiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y ri Jesús xuꞌej jeꞌ chica: Ixreꞌ joꞌc ri quicꞌutun can ri ivateꞌt-imamaꞌ ri ntiꞌan, rumareꞌ ibꞌanun cha ri ru-mandamiento ri Dios chi man jun rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ruma ri ru-mandamiento ri Dios ri i-rutzꞌibꞌan can ri Moisés, nuꞌej: Caꞌbꞌanaꞌ respetar ri atie-atataꞌ. Y jun ri ncaꞌrukal ri rutie-rutataꞌ, tiquimisas; man tijoyovax roch. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero ixreꞌ ntiꞌej: Basta chi jun ache nuꞌej cha ri rutataꞌ o cha ri rutieꞌ: Inreꞌ manak cheꞌl nquixtoꞌ, ruma nojiel ri cꞌo viqꞌuin xa Corbán (ri tzij Corbán nrajoꞌ nuꞌej: Nuyoꞌn chic cha ri Dios). ");
INSERT INTO cakSNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riqꞌuin ri ntiꞌej, can kꞌalaj chi ixreꞌ ntiꞌan chica ri achiꞌaꞌ chi man jun chic kax tiquiyaꞌ chica ri quitie-quitataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Riqꞌuin reꞌ, ixreꞌ xa man jun rakalien ibꞌanun cha ri ruchꞌabꞌal ri Dios. Ruma joꞌc ri quicꞌutun can ri ivateꞌt-imamaꞌ, joꞌc reꞌ ntivajoꞌ ntiꞌan. Y icꞌo jeꞌ nicꞌaj chic kax incheꞌl reꞌ ri ntiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Y ri Jesús xaꞌrayuoj-apa quinojiel ri vinak ri quimaluon-quiꞌ chireꞌ y xuꞌej chica: Tivaxaj otz ixvonojiel ri xtinꞌej chiva y tiꞌka pan iveꞌ (tibꞌanaꞌ entender). ");
INSERT INTO cakSNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ri nibꞌano tzꞌil cha jun vinak man ja ta ri kax ri ncaꞌrutej-ka. Ri nibꞌano tzꞌil cha jun vinak, ja ri itziel kax ri ncaꞌiel-pa riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej. Quireꞌ xuꞌej ri Jesús chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y jajaꞌ xaꞌruyaꞌ can ri vinak, y xꞌa chupan jun jay. Y ri ru-discípulos xquicꞌutuj cha ri chica nuꞌej ri parábola (cꞌambꞌal-tzij) reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y ri Jesús xuꞌej chica: ¿Ixreꞌ jeꞌ man niꞌka ta pan iveꞌ (man ntiꞌan ta entender) ri xinꞌej? ¿Man niꞌka ta pan iveꞌ (man ntiꞌan ta entender) chi man ja ta ri nutej-ka jun vinak ri nibꞌano tzꞌil cha? ");
INSERT INTO cakSNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nojiel ri nutej-ka jun vinak, xa man pa ránima ta niꞌa-ve. Xa chupan nika-ve-ka, y después ntiel-el. Y ruma ri quireꞌ xuꞌej ri Jesús, nikꞌalajin chi nojiel ri ncaꞌtij, can i-otz. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ri Jesús xuꞌej jeꞌ chi ja ri itziel kax ri ncaꞌiel-pa riqꞌuin jun vinak, jareꞌ ri nibꞌano tzꞌil cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ruma xa pa cánima ri vinak ncaꞌiel-pa ri itziel tak kax ri niquiꞌan pensar, ri i-cꞌulan y ri man i-cꞌulan ta niquicanuj-quiꞌ chi niquiꞌan pecado, ri ncaꞌquimisan, ");
INSERT INTO cakSNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ri ncaꞌlakꞌ, ri niquirayij chi nojiel ri cꞌo choch-ulief can ta quiqꞌuin ijejeꞌ cꞌo-ve, ri itziel quinoꞌj, ri niquiꞌan maña, ri achiꞌaꞌ y ri ixokiꞌ ja ri nurayij ri qui-cuerpo ri niquiꞌan, ri itziel niquitzꞌat jun vinak ri otz cꞌo, ri ncaꞌquiꞌej itziel tak tzij chiquij nicꞌaj chic, ri niquinaꞌ chi can altíra i-nimaꞌk, y ri man niquiꞌan ta pensar otz. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nojiel ri itziel tak kax reꞌ, riqꞌuin ránima ri vinak ntiel-pa, y jareꞌ ri nibꞌano tzꞌil cha. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ri Jesús xiel-el chireꞌ, y xꞌa cꞌa chupan jun lugar cierca ri tanamet quibꞌinan Tiro y Sidón. Y xcꞌujieꞌ chupan jun jay. Ri Jesús man nrajoꞌ ta chi ninaꞌax chi cꞌo chireꞌ. Pero man xtiquir ta xravaj-riꞌ; ");
INSERT INTO cakSNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","xa xunaꞌiej jun ixok ri cꞌo jun ral-xtan, ri cꞌo jun itziel espíritu riqꞌuin, chi ri Jesús cꞌo chireꞌ, y jajaꞌ xpa cꞌa riqꞌuin y xalxuquieꞌ chukul rakan. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri jun ixok reꞌ man israelita ta. Jajaꞌ jun aj-Sirofenicia. Pero xalxuquieꞌ chukul rakan ri Jesús chi xucꞌutuj favor cha chi talasaj-el ri itziel espíritu riqꞌuin ri ral. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero ri Jesús xuꞌej cha ri ixok: Tayaꞌ chi naꞌay ncaꞌvaꞌ ri israelitas. Ruma man otz ta nicꞌan-el ri qui-simíta ri acꞌolaꞌ y niyoꞌx chica ri tzꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ri ixok xuꞌej cha ri Jesús: Ajaf, can ketzij ri naꞌej. Pero ri tzꞌeꞌ, chuxieꞌ ri mesa, ncaꞌquimol ri rupixqꞌuil ri simíta ri ncaꞌquitzak-ka ri acꞌolaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y ri Jesús xuꞌej cꞌa cha ri ixok: Riqꞌuin ri xaꞌej, vacame catzalaj chavij, ruma ri itziel espíritu ya xiel-el riqꞌuin ri aval, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y antok ri ixok xtzalaj chirachuoch, xutzꞌat chi ri itziel espíritu man cꞌo ta chic riqꞌuin ri xtan, y ri xtan choj catzꞌol choch ruchꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ri Jesús xiel-el chupan ri lugar ri cierca ri tanamet Tiro y xakꞌax Sidón. Y xakꞌax jeꞌ chupan ri lugar rubꞌinan Decápolis, y quireꞌ xalka chuchiꞌ ri mar Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chireꞌ cꞌo-ve antok xcꞌamar-pa jun ache choch, jun ache ri man nacꞌaxan ta y man nichꞌoꞌ ta otz. Y ri i-cꞌamayuon-pa richin, xquicꞌutuj favor cha ri Jesús chi tuyaꞌ rukꞌaꞌ paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Y ri Jesús xralasaj-el ri ache chiquicajol ri vinak, xujuꞌ ruve-rukꞌaꞌ pa tak ruxiquin, xchubꞌan, y xutzꞌom ri rakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y ri Jesús xtzuꞌn cꞌa chicaj, xjilo y xuꞌej: Efata. Ri tzij Efata nrajoꞌ nuꞌej: Tijakataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ri ache can ja xcꞌaxan y xchꞌoꞌ otz. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xuꞌon mandar chica ri vinak chi man tiquitzijuoj ri xbꞌanataj. Pero antok jajaꞌ quireꞌ xuꞌej chica ri vinak, ijejeꞌ xa más niquitzijuoj. ");
INSERT INTO cakSNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ri vinak reꞌ altíra xaꞌchapataj antok xquitzꞌat ri xbꞌanataj, y niquiꞌej: Can jaꞌal ri ncaꞌruꞌon. Nuꞌon chica ri man ncaꞌcꞌaxan ta chi ncaꞌcꞌaxan; y nuꞌon jeꞌ chica ri miem chi ncaꞌchꞌoꞌ, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupan ri kꞌij reꞌ, can iqꞌuiy vinak ri quimaluon-apa-quiꞌ riqꞌuin ri Jesús. Pero ri vinak reꞌ manak chic chica niquicꞌux, rumareꞌ ri Jesús xaꞌrayuoj ri ru-discípulos y xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Altíra nijoyovaj quivach ri vinak, ruma oxeꞌ kꞌij icꞌo viqꞌuin y manak chic chica niquitej. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y xa ncaꞌntak ta el chi tak cachuoch y xa man ncaꞌvaꞌ ta el, xa xcaꞌbꞌatzak pa tak bꞌay ruma viꞌjal, ruma icꞌo ri naj i-patanak-ve, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ri ru-discípulos xquiꞌej cha: Chupan va lugar va manak jay. ¿Pacheꞌ nakila-pa simíta chi ncaꞌkatzuk quinojiel? xaꞌchaꞌ cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero ri Jesús xucꞌutuj chica ri ru-discípulos: ¿Janeꞌ (jaroꞌ) simíta cꞌo iviqꞌuin? Y ijejeꞌ xquiꞌej: Cꞌo siete (vukuꞌ) simíta, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ri Jesús xuꞌej chica ri vinak chi caꞌtzꞌuye-ka pan ulief. Y xutzꞌom ri siete (vukuꞌ) simíta, xuyaꞌ tiox bꞌaꞌ cha ri Dios, xaꞌruper y xuya-el chica ri ru-discípulos y ri ru-discípulos xiꞌquiyaꞌ chiquivach quinojiel ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y cꞌo jeꞌ jutzꞌit chꞌitak car quiqꞌuin; y ri Jesús xuyaꞌ tiox bꞌaꞌ cha ri Dios ruma ri chꞌitak car reꞌ, y xuꞌej chica ri ru-discípulos chi xiꞌquiyaꞌ chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri vinak can xaꞌvaꞌ otz y jaꞌal xnuoj quipan; y xmuol siete (vukuꞌ) chacach ri jutak pir ri xuꞌon suobra. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xaꞌvaꞌ, icꞌo laꞌk icajeꞌ mil. Cꞌajareꞌ ri Jesús xaꞌruꞌon despedir, ");
INSERT INTO cakSNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","y ja xuoc-el chupan ri barco quiqꞌuin ri ru-discípulos, y xaꞌa cꞌa jun lugar rubꞌinan Dalmanuta. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y icꞌo achiꞌaꞌ fariseos ri xaꞌlka riqꞌuin ri Jesús, y xquitzꞌamala-ka-quiꞌ chi tzij riqꞌuin. Y chi niquiꞌan tentar ri Jesús, xquiꞌej cha chi tubꞌanaꞌ jun señal chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ri Jesús xjikꞌijuot ránima, y xuꞌej: ¿Karruma ri vinak richin ri tiempo vacame nicajoꞌ chi niꞌan jun señal chiquivach? Inreꞌ can ketzij cꞌa ri niꞌej chiva chi ri señal ri nicajoꞌ man xtiyoꞌx ta chica, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y ri Jesús xaꞌruyaꞌ can ri achiꞌaꞌ fariseos, y xuoc-oc chupan ri barco chi xꞌa cꞌa jucꞌan chic ruchiꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y ri ru-discípulos xa xmastaj chica chi xquicꞌuaj simíta, y chupan ri barco xa joꞌc jun simíta cꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y ri Jesús xuꞌej chica ri ru-discípulos: Tibꞌanaꞌ cuenta-iviꞌ choch ri levadura quichin ri achiꞌaꞌ fariseos y richin ri Herodes, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Y ri discípulos xquiꞌej-ka chiquivach: Jajaꞌ xuꞌej quireꞌ ruma manak simíta xkacꞌam-pa, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero ri Jesús can rataꞌn ri niquiꞌan pensar ri ru-discípulos, mareꞌ xuꞌej chica: ¿Karruma ixreꞌ ntiꞌej chivach chi ruma manak simíta xicꞌam-pa mareꞌ xinꞌej quireꞌ? ¿Man xiꞌka ta pan iveꞌ (man xiꞌan ta entender) ri xinꞌej? ¿Xa cꞌa cof ibꞌanun cha ri ivánima? ");
INSERT INTO cakSNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ixreꞌ cꞌo inakꞌavach, pero xa man nquixtzuꞌn ta. Cꞌo ixiquin, pero xa man nquixcꞌaxan ta. ¿Can man nalka ta pan iveꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Antok xaꞌntzuk ri ivuꞌuoꞌ mil riqꞌuin ri vuꞌuoꞌ simíta ri xinper chiquivach, ¿janeꞌ (jaroꞌ) chacach jutak pir ri simíta ximol can? xchaꞌ chica. Y ri discípulos xquiꞌej cha: Doce (cabꞌalajuj) chacach, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Y ri Jesús xuꞌej chica: Antok xaꞌntzuk ri icajeꞌ mil riqꞌuin ri siete (vukuꞌ) simíta, ¿janeꞌ (jaroꞌ) chacach jutak pir ri simíta ximol can? xchaꞌ chica. Y ri discípulos xquiꞌej cha: Siete (vukuꞌ) chacach, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xuꞌej chica: ¿Karruma majaꞌ tiꞌka pan iveꞌ (tiꞌan entender) nojiel reꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Después ri Jesús xalka cꞌa Betsaida. Y xcꞌamar-pa jun ache muoy choch. Y ri i-cꞌamayuon-pa ri muoy xquicꞌutuj favor cha chi tutzꞌamaꞌ ri nakꞌaroch. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ri Jesús xutzꞌom rukꞌaꞌ ri ache muoy y xralasaj-el cꞌa chuchiꞌ ri aldea. Ri Jesús xuchubꞌaj ri nakꞌaroch ri muoy y xutzꞌom jeꞌ. Y xucꞌutuj cha xa cꞌo nutzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y antok ri muoy xujak ri nakꞌaroch, xuꞌej: Ncaꞌntzꞌat ri achiꞌaꞌ i-incheꞌl chieꞌ, pero ncaꞌntzꞌat chi xa ncaꞌin, nchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y ri Jesús xutzꞌom chic jun bꞌay ri nakꞌaroch ri ache. Can xuꞌon cha ri ache chi xtzuꞌn. Y ri ache xtzuꞌn jaꞌal. Can jaꞌal cꞌa ncaꞌrutzꞌat nojiel; hasta ri icꞌo naj. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y ri Jesús xutak cꞌa el ri ache chi tiꞌa chirachuoch. Jajaꞌ xuꞌej cꞌa el cha: Man catuoc chupan ri aldea, y man jun choj cha tatzijuoj-ve chupan ri aldea, xcha-el ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Y ri Jesús y ri ru-discípulos xaꞌa pa tak aldeas ri icꞌo chupan ri Cesarea richin ri Filipo. Y pa bꞌay ri Jesús xucꞌutuj chica ri ru-discípulos: ¿In chica inreꞌ niquiꞌej ri achiꞌaꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y ijejeꞌ xquiꞌej cha: Icꞌo ncaꞌeꞌn chi atreꞌ ri Juan el Bautista. Icꞌo nicꞌaj chic niquiꞌej chi atreꞌ ri Elías. Y icꞌo jeꞌ ri ncaꞌeꞌn chi atreꞌ at jun chic chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, xaꞌchaꞌ cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y jajaꞌ xucꞌutuj chica: ¿Y ixreꞌ, in chica inreꞌ ntiꞌej? Y ri Pedro xuꞌej cha ri Jesús: Atreꞌ ri Cristo, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pero ri Jesús xuꞌon mandar chica chi man jun choj cha tiquiꞌej-ve chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y ri Jesús xutzꞌom cꞌa rutzijoxic chiquivach ri ru-discípulos, chi nicꞌatzin chi ri Xtak-pa chicaj chi xalax chiꞌicajol nukꞌasaj qꞌuiy sufrimiento, y itziel xtitzꞌiet cuma ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, cuma ri principales sacerdotes, y cuma ri achiꞌaꞌ escribas; y xtiquimisas, pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y ri Jesús can jaꞌal kꞌalaj rutzijoxic ri tzij ri xuꞌej chica ri ru-discípulos. Y ri Pedro xucꞌuaj jubꞌaꞌ aparte ri Jesús y xuchꞌolij. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero antok ri Jesús xraꞌxaj quireꞌ, xtzuꞌn can chirij y xaꞌrutzꞌat ri nicꞌaj chic ru-discípulos y xuchꞌolij ri Pedro y xuꞌej cha: ¡Catiel-el chinoch Satanás! Ruma ri naꞌan pensar atreꞌ xa junan riqꞌuin ri niquiꞌan pensar ri vinak y man incheꞌl ta ri nrajoꞌ ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y ri Jesús xaꞌrayuoj ri vinak y ri ru-discípulos y xuꞌej chica: Vi xa cꞌo jun nrajoꞌ niꞌa chuvij, man tuꞌon ri nurayij jajaꞌ, y can tutzꞌamaꞌ y tucꞌuaj ri ru-cruz. Xa quireꞌ nuꞌon, otz tipa viqꞌuin chi niꞌa chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ruma xa cꞌo jun ri altíra nrajoꞌ ri rucꞌaslien vaveꞌ ri choch-ulief, man xticolotaj ta. Pero ri jun, mesque niquimisas vuma inreꞌ y ruma ri evangelio, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ruma ¿chica nuchꞌec jun vinak xa nicꞌujieꞌ ta riqꞌuin nojiel ri bꞌayomal ri cꞌo choch-ulief y xa man nicolotaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mesque altíra bꞌayomal cꞌo riqꞌuin, pero man nitiquir ta nulokꞌ ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ruma xa cꞌo jun ri niqꞌuix pa nu-cuenta y ruma ri nutzij chiquivach ri vinak richin ri tiempo vacame ri can aj-bꞌanoy-pecado y man nicajoꞌ ta niquinimaj ri Dios, ri Xtak-pa chicaj chi xalax chiꞌicajol can xtiqꞌuix jeꞌ pa ru-cuenta. Quireꞌ xtuꞌon antok xtipa chic jun bꞌay, junan chic ru-gloria riqꞌuin ri Rutataꞌ, i-richꞌilan-pa ri santos ángeles. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y ri Jesús xuꞌej jeꞌ chica ri icꞌo riqꞌuin: Can ketzij ri niꞌej chiva, chi icꞌo jujun chivach ixreꞌ ri man xcaꞌcon ta yan, cꞌa xtiquitzꞌat-na ri ru-reino ri Dios ri xtipa riqꞌuin poder, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y antok kꞌaxnak chic vakiꞌ kꞌij, ri Jesús xaꞌruchaꞌ ri Pedro, ri Jacobo y ri Juan, y xaꞌrucꞌuaj cꞌa ri iyoxeꞌ reꞌ paroꞌ jun juyuꞌ nem. Y ri Jesús xcꞌaxtaj rutzubꞌal chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y ri rutziak can xchꞌichꞌan. Can altíra sak xuꞌon, can incheꞌl ri hielo ri nika. Y man jun vinak ri nichꞌajo tziak nitiquir nuꞌon sak cha jun tziak incheꞌl reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y antok ri iyoxeꞌ discípulos xquitzꞌat, icꞌo yan chic ri Elías y ri Moisés, ncaꞌtzijuon riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y ri Pedro xuꞌej cha ri Jesús: Maestro, otz chi ojcꞌo vaveꞌ ojreꞌ, nakaꞌan oxeꞌ chꞌitak enramadas, jun avichin atreꞌ, jun richin ri Moisés y jun richin ri Elías. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro quireꞌ xuꞌej, pero man rataꞌn ta ri chica ncaꞌruꞌej, ruma altíra xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y jareꞌ antok jun mukul xka-pa pa quiveꞌ. Y chupan ri mukul reꞌ, cꞌo Jun ri xchꞌo-pa y xuꞌej: Jareꞌ ri Nucꞌajuol y altíra nivajoꞌ. Can tivaxaj ri nuꞌej jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Y antok ri discípulos xaꞌtzuꞌn chic apa, xquitzꞌat chi xa man jun chic cꞌo riqꞌuin ri Jesús. Xa ruyuon chic cꞌo can. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y antok ijejeꞌ i-xulan-pa choch ri juyuꞌ, ri Jesús xuꞌon mandar chica ri ru-discípulos: Man jun choj cha tiꞌej ri xitzꞌat. Otz ntiꞌej pero cꞌa antok ri Xtak-pa chicaj chi xalax chiꞌicajol ya cꞌastajnak chic pa chiquicajol ri quiminakiꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y ijejeꞌ man xquitzijuoj ta ri chica xquitzꞌat, pero niquicꞌutuj chiquivach ri chica xrajoꞌ xuꞌej ri Jesús antok xuꞌej chi xticꞌastaj chic pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y ri discípulos xquicꞌutuj cha ri Jesús: ¿Karruma niquiꞌej ri achiꞌaꞌ escribas chi nicꞌatzin chi ja ri Elías nipa naꞌay? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y ri Jesús xuꞌej chica: Can ketzij chi ri Elías nipa naꞌay y nalruchojmij nojiel ri nicꞌatzin chi nichojmix. ¿Man xtibꞌanataj ta came ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios chirij ri Xtak-pa chicaj chi xalax chiꞌicajol, chi nukꞌasaj qꞌuiy sufrimientos, y man jun rukꞌij xtiꞌan cha? ");
INSERT INTO cakSNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero inreꞌ niꞌej chiva chi ri Elías ya xpa, y ri vinak can xquiꞌan cha nojiel ri xcajoꞌ xquiꞌan cha, can incheꞌl ri tzꞌibꞌan can chirij chupan ri ruchꞌabꞌal ri Dios, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Antok ri Jesús y ri iyoxeꞌ discípulos ya cierca chic icꞌo-ve chi ncaꞌlka quiqꞌuin ri nicꞌaj chic discípulos, jajaꞌ xutzꞌat chi altíra iqꞌuiy vinak ri quimaluon-quiꞌ chiquij, y nicꞌaj achiꞌaꞌ escribas quitzꞌamuon-quiꞌ chi tzij quiqꞌuin ri discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Quinojiel ri vinak, antok xquitzꞌat chi patanak ri Jesús, can xaꞌchapataj, y jun-anin xbꞌaquicꞌuluꞌ y xquiꞌan saludar. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xucꞌutuj chica: ¿Choj chirij itzꞌamuon-ve-iviꞌ quiqꞌuin ijejeꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Jun chiquivach ri vinak xuꞌej cha ri Jesús: Maestro, inreꞌ nucꞌamun-pa ri nucꞌajuol aviqꞌuin, ruma cꞌo jun itziel espíritu riqꞌuin ri miem rubꞌanun cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y antok más nuyaꞌ ruchukꞌaꞌ chirij, pacheꞌ na cꞌo-ve nuquiyicaꞌ ri ru-cuerpo, ntiel ruvakuol pa ruchiꞌ, y nukꞌachꞌachꞌiej roray. Altíra jeꞌ nuꞌon chie-chieꞌ cha. Y rumareꞌ xinꞌej chica ri a-discípulos chi tiquilasaj-el ri itziel espíritu reꞌ riqꞌuin ri nucꞌajuol, pero man xaꞌtiquir ta, xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y ri Jesús xuꞌej chica: ¡Man jun vinak chupan ri tiempo vacame ruyoꞌn ta ránima riqꞌuin ri Dios! ¿Ixreꞌ ntiꞌan pensar chi inreꞌ nojiel kꞌij xquicꞌujieꞌ iviqꞌuin? ¿Y janeꞌ (jaroꞌ) tiempo xquixcochꞌ? Ticꞌama-pa ri alaꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xcꞌamar-pa ri alaꞌ cꞌa choch ri Jesús. Pero antok ri itziel espíritu xutzꞌat ri Jesús, riqꞌuin ruchukꞌaꞌ xuchꞌikilaꞌ ri alaꞌ y xutzak pan ulief. Y ri alaꞌ nubꞌolkotila-riꞌ y ntiel jeꞌ ruvakuol pa ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xucꞌutuj cha ri rutataꞌ ri alaꞌ: ¿Janeꞌ (jaroꞌ) tiempo rubꞌanun-pa quireꞌ ri alaꞌ? xchaꞌ ri Jesús cha. Y ri rutataꞌ ri alaꞌ xuꞌej: Xa-jan cꞌa acꞌual quireꞌ rubꞌanun-pa cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Qꞌuiy mul rutzakuon pa kꞌakꞌ, y pa yaꞌ, chi nuquimisaj. Pero xa atreꞌ ncatiquir naꞌan jun kax, tajoyovaj kavach y kojatoꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pero ri Jesús xuꞌej cha ri rutataꞌ ri alaꞌ: Xa atreꞌ nanimaj chi nquitiquir nitoꞌ ri acꞌajuol, can xtibꞌanataj. Ruma xa jun nunimaj ri nucꞌutuj, can nibꞌanataj ri chica ri nrajoꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y chaꞌnin ri rutataꞌ ri alaꞌ riqꞌuin ruchukꞌaꞌ xchꞌoꞌ y xuꞌej: Ninimaj. Y quinatoꞌ jeꞌ chi quireꞌ más ninimaj, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Antok ri Jesús xutzꞌat chi ri vinak más niquimol-ka-quiꞌ, xchꞌolin cha ri itziel espíritu. Jajaꞌ xuꞌej cha: Atreꞌ espíritu miem y xuorta, inreꞌ niꞌan mandar chava chi catiel-el riqꞌuin ri alaꞌ, y man chic catzalaj-pa riqꞌuin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y ri itziel espíritu nisiqꞌuin, y xuchꞌikilaꞌ ri alaꞌ xiel-el. Y ri alaꞌ xpoqꞌuieꞌ can pan ulief, incheꞌl quiminak xuꞌon can. Y rumareꞌ iqꞌuiy vinak xquiꞌej: Ri alaꞌ xcon. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xutzꞌom rukꞌaꞌ ri alaꞌ chi xupabꞌaꞌ. Y ri alaꞌ can ja xpalaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y antok ri Jesús xuoc pa jay, ri ru-discípulos xquicꞌutuj cha quiyuon: ¿Karruma ojreꞌ man xojtiquir ta xkalasaj-el ri itziel espíritu? ");
INSERT INTO cakSNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ri Jesús xuꞌej chica: Ri jun clase espíritu reꞌ man jun choj cha ntiel-el, joꞌc riqꞌuin ayuno y oración sí ntiel-el, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y antok ijejeꞌ ya i-alanak chic pa chireꞌ, xaꞌkꞌax chupan Galilea. Pero ri Jesús man xrajoꞌ ta chi ninaꞌax chi jajaꞌ nakꞌax chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ruma jajaꞌ nrajoꞌ chi nicatamaj ri ru-discípulos, rumareꞌ nuꞌej chica: Ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach pa quikꞌaꞌ ri vinak y xtiquiquimisaj. Pero antok quiminak chic, chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ri discípulos xa man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) ri xꞌeꞌx chica. Y niquixiꞌij-quiꞌ niquicꞌutuj cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y ri Jesús y ri ru-discípulos xaꞌbꞌaka pa tanamet Capernaum. Y antok icꞌo chic pa jay, jajaꞌ xucꞌutuj chica ri ru-discípulos: ¿Chica ri ntiꞌej chivach antok oj-patanak pa bꞌay? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ri discípulos man xaꞌchꞌoꞌ ta apa cha ri Jesús, ruma antok i-patanak ri pa bꞌay, xa niquiꞌej chiquivach ri chica xtuoc nem chiquivach ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y ri Jesús xtzꞌuye-ka y xaꞌrayuoj-apa ri doce (cabꞌalajuj) discípulos y xuꞌej chica: Xa cꞌo jun ri nrajoꞌ chi jajaꞌ ri naꞌay, can tubꞌanaꞌ ri ruqꞌuisbꞌal y caꞌrubꞌanaꞌ servir quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y ri Jesús xbꞌaruma-pa jun acꞌual y xuyaꞌ pa nicꞌaj. Y xukꞌatiej y xuꞌej chica ri ru-discípulos: ");
INSERT INTO cakSNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Ri nuꞌon recibir jun acꞌual incheꞌl va pa nubꞌeꞌ, can nquiruꞌon recibir inreꞌ. Y ri nquiruꞌon recibir inreꞌ, man joꞌc ta inreꞌ ri nquiruꞌon recibir, xa can nuꞌon jeꞌ recibir ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ri Juan xuꞌej cha ri Jesús: Maestro, cꞌo jun ache xkatzꞌat, ri pan abꞌeꞌ atreꞌ ncaꞌralasaj itziel tak espíritus. Pero ruma xa man kachꞌil ta, mareꞌ xkaꞌan prohibir cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Pero ri Jesús xuꞌej: Man tiꞌan prohibir cha. Ruma xa pa nubꞌeꞌ inreꞌ ncaꞌruꞌon milagros, man chaꞌnin ta xtucꞌax runoꞌj y después xtuꞌej ta itziel tak tzij chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ruma ri man royoval ta chikij, can kiqꞌuin ojreꞌ cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y chica-na ri nuyaꞌ jun vaso iyaꞌ pa nubꞌeꞌ inreꞌ, ruma ixcꞌo viqꞌuin inreꞌ ri Cristo, can ketzij niꞌej chiva; chi can cꞌo rucꞌaxiel xtiyoꞌx cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Xa cꞌo ta jun ri in-runiman mesque manak-oc rukꞌij y nipa jun chic vinak y nuꞌon cha ri jun reꞌ chi nitzak, ri nibꞌano quireꞌ más otz nixim jun nem abꞌaj (caꞌ) chukul y nicꞌak chupan ri mar. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xa jun akꞌaꞌ ri nibꞌano chava chi ncatzak, más otz takupij-el. Ruma más otz jun oc akꞌaꞌ cꞌo ncatuoc chupan ri cꞌaslien ri man niqꞌuis ta, que cꞌo caꞌyeꞌ akꞌaꞌ y xa ncaꞌa chupan ri infierno; chupan ri kꞌakꞌ ri man nichup ta, ");
INSERT INTO cakSNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ri pacheꞌ icꞌo jut ri man ncaꞌcon ta ri quichin ri icꞌo chireꞌ, y ri kꞌakꞌ can man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y xa jun avakan ri nibꞌano chava chi ncatzak, más otz takupij-el. Ruma más otz jun oc avakan cꞌo ncatuoc chupan ri cꞌaslien ri man niqꞌuis ta, que cꞌo caꞌyeꞌ avakan y xa ncayoꞌx chupan ri infierno; chupan ri kꞌakꞌ ri man nichup ta, ");
INSERT INTO cakSNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ri pacheꞌ icꞌo jut ri man ncaꞌcon ta ri quichin ri icꞌo chireꞌ, y ri kꞌakꞌ can man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y xa jun anakꞌavach ri nibꞌano chava chi ncatzak, más otz tavalasaj-el. Ruma más otz jun oc anakꞌavach cꞌo ncatuoc chupan ri ru-reino ri Dios, que cꞌo caꞌyeꞌ anakꞌavach y xa ncayoꞌx chupan ri infierno, ");
INSERT INTO cakSNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ri pacheꞌ icꞌo jut ri man ncaꞌcon ta ri quichin ri icꞌo chireꞌ, y ri kꞌakꞌ can man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Antok ncaꞌyoꞌx ri chicop choch ri Dios, yoꞌn atzꞌan chiquij. Quireꞌ jeꞌ xtiꞌan chica ri vinak, pero man chic cha ta atzꞌan, xa cha kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ri atzꞌan, can otz. Pero xa ri atzꞌan niqꞌuis-el ri rutzayal, ¿chica ta ntiꞌan chi nitzalaj chic pa rutzayal ri atzꞌan? Rumareꞌ tibꞌanaꞌ cuenta ri icꞌaslien, chi quireꞌ man nquixuoc ta incheꞌl ri atzꞌan ri manak chic rutzayal, y man jun ta ayoval chiꞌicajol. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ri Jesús xiel-el chireꞌ y xꞌa cꞌa Judea. Y xakꞌax jucꞌan ri río Jordán. Chireꞌ, iqꞌuiy vinak xquimol chic quiꞌ riqꞌuin. Y jajaꞌ xucꞌut ri ruchꞌabꞌal ri Dios, incheꞌl rubꞌanun-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y jareꞌ antok nicꞌaj achiꞌaꞌ fariseos xaꞌjiel-apa riqꞌuin, chi niquiꞌan tentar, xquicꞌutuj cha xa otz chi jun ache nujach-riꞌ riqꞌuin ri raxjayil. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: ¿Chica ri ruꞌeꞌn can ri Moisés chiva chi ntiꞌan? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y ijejeꞌ xquiꞌej: Ri Moisés xuꞌon permitir chi xa jun ache nrajoꞌ nujach-riꞌ riqꞌuin ri raxjayil, cꞌo cheꞌl nuꞌon jun carta ri pacheꞌ nuꞌej-ve chi nujach-riꞌ riqꞌuin y tuyaꞌ can, xaꞌchaꞌ ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Y ri Jesús xuꞌej chica: Ruma cof ibꞌanun cha ri ivánima, rumareꞌ xuꞌej chi tiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero antok xtzꞌucutaj-pa ri roch-ulief, ache y ixok xaꞌruꞌon ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Rumareꞌ ri ache xcaꞌruyaꞌ can ri rutie-rutataꞌ y xtiquicꞌan-quiꞌ riqꞌuin ri raxjayil, ");
INSERT INTO cakSNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y ri icaꞌyeꞌ xa joꞌc jun xtiquiꞌan. Rumareꞌ man chic icaꞌyeꞌ ta, xa joꞌc jun xtiquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ruma cꞌa reꞌ, lo que ri Dios xuꞌon jun cha, ri ache man tujach roch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Antok ri Jesús y ri ru-discípulos icꞌo chic pa jay, ri discípulos xquicꞌutuj cha chirij ri xaꞌruꞌej chica ri achiꞌaꞌ fariseos. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y ri Jesús xuꞌej chica: Chica-na ache ri nujach-riꞌ riqꞌuin ri raxjayil y nicꞌulieꞌ riqꞌuin jun chic ixok, can nuꞌon ruchꞌoꞌj choch ri raxjayil. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y xa ri ixok nujach-riꞌ riqꞌuin ri rachajil y nicꞌulieꞌ riqꞌuin jun chic ache, can nuꞌon pecado choch ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ri vinak xaꞌquicꞌam-pa acꞌolaꞌ riqꞌuin ri Jesús, chi nuyaꞌ rukꞌaꞌ pa quiveꞌ chi ncaꞌruꞌon bendecir. Pero ri discípulos xaꞌquichꞌolij ri vinak chi man tiquiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Y antok ri Jesús xutzꞌat ri niquiꞌan ri ru-discípulos, xpa rayoval, y xuꞌej chica: Tiyaꞌ permiso chica ri acꞌolaꞌ chi ncaꞌpa viqꞌuin inreꞌ, y man quiꞌikꞌat. Ruma ri ru-reino ri Dios xa quichin ri i-incheꞌl acꞌolaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y can ketzij ri niꞌej chiva, chi xa jun man nuꞌon ta recibir ri ru-reino ri Dios incheꞌl nuꞌon jun acꞌual, man xtuoc ta chupan, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y xaꞌrukꞌatiej y xuyaꞌ ri rukꞌaꞌ pa quiveꞌ ri acꞌolaꞌ chi xaꞌruꞌon bendecir. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y antok ri Jesús xiel-el chireꞌ chi xutzꞌom chic el rubꞌiey, cꞌo jun ri anin xalka riqꞌuin, xalxuquieꞌ choch, y xucꞌutuj cha: Utzulaj Maestro, ¿chica niꞌan chi nivil ri cꞌaslien ri man niqꞌuis ta? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y ri Jesús xuꞌej cha: ¿Karruma naꞌej otz chuva inreꞌ? Ruma man jun vinak otz, xa joꞌc Jun ri otz y reꞌ ja ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Avataꞌn ri mandamientos ri xuyaꞌ ri Dios cha ri Moisés ri ojier can, ri nuꞌej: Ri at-cꞌulan, man tavucꞌuaj-aviꞌ riqꞌuin jun chic; man caquimisan; man catalakꞌ; man tatzꞌak tzij chirij jun chic; man taꞌan maña cha jun vinak ruma cꞌo chica navajoꞌ navalakꞌaj chukꞌaꞌ; caꞌbꞌanaꞌ respetar ri atie-atataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ri jun reꞌ xuꞌej cha ri Jesús: Maestro, nojiel reꞌ cꞌa in coꞌl-oc nutzꞌamuon-pa rubꞌanic, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Y ri Jesús xutzꞌat y altíra xrajoꞌ. Y xuꞌej cha: Cꞌa cꞌo jun kax ri man abꞌanun ta. Caꞌin, tacꞌayij nojiel ri cꞌo aviqꞌuin y ri rajal tajachaꞌ chiquivach ri i-puobra, chi quireꞌ nicꞌujieꞌ abꞌayomal chicaj. Y catam-pa viqꞌuin, y ncaꞌa chuvij y tatzꞌamaꞌ ri a-cruz, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero antok ri jun reꞌ xraꞌxaj ri tzij ri xuꞌej ri Jesús, can xcꞌaxtaj ri titzuꞌn y nibꞌisuon ránima xꞌa, ruma altíra rubꞌayomal cꞌo. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Entonces ri Jesús xtzuꞌn quiqꞌuin ri ru-discípulos y xuꞌej chica: ¡Ri cꞌo qꞌuiy quibꞌayomal, can cuesta chi ncaꞌuoc pa ru-reino ri Dios! ");
INSERT INTO cakSNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y ri ru-discípulos ri Jesús can xaꞌchapataj ruma ri tzij ri xuꞌej ri Jesús. Pero jajaꞌ xuꞌej chic jun bꞌay chica: Valcꞌual, ¡ri quicukubꞌan quicꞌuꞌx chirij ri quibꞌayomal, can cuesta chi ncaꞌuoc pa ru-reino ri Dios! ");
INSERT INTO cakSNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa más fácil nakꞌax jun camello chupan jun ruvaruol jun acúxa, que choch jun bꞌayuon chi ntuoc pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Y ri discípulos can más xaꞌchapataj y niquiꞌej chiquivach: ¿Chica cꞌa xticolotaj? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y ri Jesús xaꞌrutzꞌat-apa ri ru-discípulos y xuꞌej chica: Ri vinak man nojiel ta kax ncaꞌtiquir niquiꞌan, pero ri Dios nojiel kax nitiquir nuꞌon, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y jareꞌ antok ri Pedro xuꞌej cha: Ojreꞌ kayoꞌn can nojiel ri cꞌo kiqꞌuin, y oj-bꞌanak chavij. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pero ri Jesús xuꞌej: Can ketzij ri niꞌej chiva, chi man jun ri ruyoꞌn can rachuoch, o runimal, o ruchakꞌ, o ranaꞌ, o rutie-rutataꞌ, o raxjayil, o ralcꞌual o rulief vuma inreꞌ y ruma ri evangelio; ");
INSERT INTO cakSNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","man ta xtiyoꞌx cha cien veces más ri rucꞌaxiel chupan ri tiempo vacame. Xtiyoꞌx rachuoch, runimal, ruchakꞌ, ranaꞌ, rutieꞌ, ralcꞌual y rulief. Can xtuꞌon sufrir jeꞌ pa quikꞌaꞌ ri vinak ruma bꞌanak viqꞌuin, pero chupan-apa ri jun chic tiempo ri chakavach-apa, can xtiyoꞌx cha ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Pero iqꞌuiy ri icꞌo nabꞌayal, ri xcaꞌcꞌujieꞌ cꞌa pa ruqꞌuisbꞌal, y iqꞌuiy ri icꞌo pa ruqꞌuisbꞌal, xcaꞌcꞌujieꞌ nabꞌayal, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús, ri ru-discípulos y nicꞌaj chic vinak, quitzꞌamuon-el bꞌay chi ncaꞌa pa tanamet Jerusalén. Y ja ri Jesús ri bꞌanak-el chiquivach, y ri ru-discípulos y ri vinak can i-chapatajnak y quixiꞌin-quiꞌ jeꞌ i-bꞌanak-el chirij. Jun chic bꞌay ri Jesús xaꞌrucꞌuaj aparte ri doce (cabꞌalajuj) discípulos y xuꞌej chic chica, ri chica sufrimiento ri xtukꞌasaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jajaꞌ xuꞌej chica: Ixreꞌ ivataꞌn chi cꞌa pa tanamet Jerusalén nkuꞌa-ve-el, y chireꞌ xtijach-ve ri Xtak-pa chicaj chi xalax chiꞌicajol pa quikꞌaꞌ ri principales sacerdotes y pa quikꞌaꞌ ri achiꞌaꞌ escribas. Y ijejeꞌ xtiquiꞌej chi tiquimisas. Y ijejeꞌ xtiquijach pa quikꞌaꞌ vinak ri man israelitas ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y ri vinak reꞌ xcaꞌtzeꞌn chirij, xtiquichꞌey, xtiquichubꞌaj, y cꞌajareꞌ xtiquiquimisaj. Pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y ri Jacobo y ri Juan, ri i-rucꞌajuol ri Zebedeo, xaꞌjiel-apa riqꞌuin ri Jesús, y xquiꞌej cha: Maestro, xaꞌchaꞌ cha. Ojreꞌ nakajoꞌ chi naꞌan ri nakacꞌutuj chava, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y jajaꞌ xuꞌej chica: ¿Chica ri ntivajoꞌ chi niꞌan? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y ijejeꞌ xquiꞌej cha: Ojreꞌ nakajoꞌ chi chupan ri a-reino, naꞌan chi nkojtzꞌuye-apa aviqꞌuin; jun ta nicꞌujieꞌ pan a-derecha y jun ta pan av-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ri Jesús xuꞌej chica: Ixreꞌ man ivataꞌn ta ri chica nticꞌutuj. ¿Nticochꞌ came ixreꞌ incheꞌl ri xtiꞌan chuva inreꞌ? ¿Y nticochꞌ came ixreꞌ ri sufrimiento ri xtinkꞌasaj inreꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y ijejeꞌ xquiꞌej: Nakacochꞌ, xaꞌchaꞌ. Y ri Jesús xuꞌej chic chica: Can ketzij chi ixreꞌ xticochꞌ ri incheꞌl xtiꞌan chuva inreꞌ. Can xticochꞌ jeꞌ ri sufrimiento ri xtinkꞌasaj inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ri nticꞌutuj ixreꞌ, chi jun nitzꞌuyeꞌ pa nu-derecha y ri jun chic pa nu-izquierda, reꞌ man pa nukꞌaꞌ ta inreꞌ cꞌo-ve chi niyaꞌ chiva. Ja ri Dios ri ruꞌeꞌn choj chica xtuya-ve chi ncaꞌtzꞌuyeꞌ chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y antok ri i-diez (lajuj) chic discípulos xcaꞌxaj ri xꞌeꞌx, xpa quiyoval chica ri Jacobo y ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero ri Jesús xaꞌrayuoj ri ru-discípulos y xuꞌej chica: Ixreꞌ jaꞌal ivataꞌn chi vaveꞌ ri choch-ulief, ri ncaꞌbꞌano gobernar, ruma icꞌo ri vinak pa quikꞌaꞌ, rumareꞌ niquinaꞌ chi ijejeꞌ ri i-cajaf. Y quireꞌ jeꞌ ri principales, nicajoꞌ chi caꞌnimax y can tiꞌan nojiel ri niquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero chiꞌicajol ixreꞌ man quireꞌ ta. Ruma xa cꞌo jun ri nrajoꞌ nuꞌon nem chiꞌicajol ixreꞌ, nicꞌatzin chi nquixruꞌon servir. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xa jun chivach ixreꞌ nrajoꞌ chi jajaꞌ ri naꞌay, can quixrubꞌanaꞌ servir. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ruma ri Xtak-pa chicaj chi xalax chiꞌicajol, man xpa ta chi niꞌan servir, sino chi nuꞌon servir, y chi nuyaꞌ rucꞌaslien chi quireꞌ iqꞌuiy ri ncaꞌcolotaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Y ri Jesús y ri ru-discípulos xaꞌbꞌaka pa tanamet Jericó. Y antok ijejeꞌ ya ncaꞌiel-pa chupan ri tanamet, iqꞌuiy vinak ri i-bꞌanak chiquij. Y chuchiꞌ cꞌa ri bꞌay cꞌo jun muoy Bartimeo rubꞌeꞌ, rucꞌajuol ri Timeo. Jajaꞌ tzꞌuyul chireꞌ chi nucꞌutuj ru-limosna. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y antok jajaꞌ xraꞌxaj chi ja ri Jesús ri aj-Nazaret ri nakꞌax chireꞌ, jajaꞌ riqꞌuin ruchukꞌaꞌ xchꞌoꞌ y xuꞌej: ¡Jesús, ri at Rumáma can ri rey David, tajoyovaj noch! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y iqꞌuiy vinak ri xquichꞌolij chi man chic tichꞌo-pa. Pero jajaꞌ xa riqꞌuin más ruchukꞌaꞌ xchꞌo-pa y xuꞌej: ¡Atreꞌ ri at Rumáma can ri rey David, tajoyovaj noch! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y ri Jesús xraꞌxaj ri ache, rumareꞌ xpiꞌie-ka y xuꞌej cꞌa chi ticayuoj-pa. Y ja xbꞌacayuoj-pa ri ache muoy y xquiꞌej cha: Man taxiꞌij-aviꞌ; capiꞌieꞌ, ri Jesús ncarayuoj, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Jajaꞌ xuqꞌuiak can ri ru-capa ri rukꞌuꞌn, xpalaj-pa y xpa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ri Jesús xucꞌutuj cha: ¿Chica navajoꞌ chi niꞌan? Y ri ache muoy xuꞌej cha: Maestro, inreꞌ nivajoꞌ nquitzuꞌn chic, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús xuꞌej cha: Caꞌin, ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin, xacꞌachoj. Y ja xtzuꞌn chic, y xꞌa chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y antok ya ncaꞌbꞌaka cierca ri aldeas Betfagé y Betania, ri icꞌo choch ri juyuꞌ Olivos, ri cꞌo cierca ri tanamet Jerusalén, ri Jesús xaꞌrutak-el icaꞌyeꞌ chiquivach ri ru-discípulos, ");
INSERT INTO cakSNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","y xuꞌej-el chica: Quixꞌin chupan la aldea la, y antok xquixuoc, xtivil jun alaj burro ximil chireꞌ, ri man jun bꞌay chꞌacol ache chirij. Tiquira-pa y ticꞌama-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y xa cꞌo jun xtiꞌeꞌn-pa chiva: ¿Karruma quireꞌ ntiꞌan? tiꞌej cha chi nicꞌatzin cha ri Ajaf, pero chaꞌnin xtalruyaꞌ chic, quixchaꞌ can cha, xcha-el ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ri icaꞌyeꞌ discípulos xaꞌa, y xquil ri alaj burro, ximuon juviera chuchiꞌ jun puerta ri pacheꞌ nuya-ve vielta ri bꞌay. Y ijejeꞌ xquiquir-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero antok ijejeꞌ ja niquiquir ri alaj burro, xaꞌtzꞌiet-pa cuma ri icꞌo chireꞌ y xquiꞌej-pa chica ri icaꞌyeꞌ discípulos: ¿Karruma ntiquir-el ri alaj burro? xaꞌcha-pa chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y ri discípulos xquiꞌej ri ruꞌeꞌn-el ri Jesús chica. Y ja xquiyaꞌ permiso chica chi xquicꞌuaj ri alaj burro. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y xquicꞌam-pa ri alaj burro riqꞌuin ri Jesús. Y ri discípulos xquiya-el ri qui-manta chirij, y ri Jesús xchꞌoquie-el chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y can iqꞌuiy chiquivach ri vinak niquilicꞌ qui-manta pa rubꞌiey. Y nicꞌaj chic vinak xiquima-pa chꞌitak rukꞌaꞌ chieꞌ chi xquiyaꞌ pa rubꞌiey. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y ri vinak ri i-bꞌanak choch ri Jesús y ri icꞌo can chirij, can riqꞌuin nojiel quichukꞌaꞌ niquiꞌej: ¡Tiox bꞌaꞌ chi patanak ri Jun reꞌ! ¡Bendito ri patanak pa rubꞌeꞌ ri Ajaf Dios! ");
INSERT INTO cakSNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Tiox bꞌaꞌ chi nitzalaj-pa ri ru-reino ri kamamaꞌ David ri xcꞌujieꞌ ojier can! ¡Tiox bꞌaꞌ cha ri Dios ri cꞌo chicaj! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y ri Jesús xuoc pa tanamet Jerusalén y xuoc pa templo y xaꞌrutzꞌat can nojiel ri icꞌo chireꞌ. Y ruma xcokꞌa-ka, jajaꞌ y ri i-doce (cabꞌalajuj) ru-discípulos xaꞌa chupan ri aldea Betania. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Y chucaꞌn kꞌij, antok xaꞌiel-el chupan ri aldea Betania chi ncaꞌa Jerusalén, ri Jesús xnem-pa rupan. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y jajaꞌ chi-naj xutzꞌat jun mata víquix, y altíra jaꞌal ri ruxak rubꞌanun. Xꞌa-apa riqꞌuin chi xirucanuj-pa roch. Pero antok xbꞌaka chuxieꞌ, xa man jun roch cꞌo, xa ruyuon ruxak. Ruma man ru-tiempo ta chi nuyaꞌ roch. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Y ri Jesús xuꞌej cha ri jun mata víquix reꞌ: Man jun chic vinak xtitijo avach, ruma manak chic avach xtayaꞌ, xchaꞌ. Y ri ru-discípulos xcaꞌxaj ri xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xaꞌlka chic pa tanamet Jerusalén. Y ri Jesús xꞌa pa templo y xaꞌrutarariej-el ri ncaꞌcꞌayin y ri ncaꞌlakꞌo chireꞌ. Y xupajqꞌuij can ri qui-mesas ri niquicꞌax miera. Y quireꞌ jeꞌ xuꞌon cha ri quichꞌacat ri niquicꞌayij paluomix. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y jajaꞌ man xuyaꞌ ta permiso chica ri vinak ri quicꞌuan kax, chi ncaꞌkꞌax chireꞌ pa templo. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Y ri Jesús xaꞌrutijuoj cꞌa ri vinak riqꞌuin ri ruchꞌabꞌal ri Dios, y xuꞌej chica: ¿Man came tzꞌibꞌan ta can chupan ri ruchꞌabꞌal ri Dios chi ri vachuoch, jay chi niquiꞌan orar quinojiel vinak ri icꞌo choch-ulief? Pero ixreꞌ xa ibꞌanun cachuoch alakꞌomaꞌ cha, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y ri achiꞌaꞌ escribas y ri principales sacerdotes xcaꞌxaj ri xuꞌej y niquicanuj manera chi niquiquimisaj, ruma niquixiꞌij-quiꞌ choch ri Jesús y ruma ri vinak can i-chapatajnak riqꞌuin ri nucꞌut. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Antok xchakꞌa-ka, ri Jesús xiel-el chupan ri tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Macꞌajan chucaꞌn kꞌij xaꞌkꞌax, xquitzꞌat chi chakeꞌj chic ri jun mata víquix, hasta ri ruxieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y ri Pedro chaꞌnin xalka paroꞌ, y xuꞌej cha ri Jesús: Maestro, tatzꞌataꞌ ri jun mata víquix, can xchakej-ka incheꞌl ri xaꞌej, xchaꞌ ri Pedro cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Y ri Jesús xuꞌej chica: Ixreꞌ nicꞌatzin chi nticukubꞌaꞌ icꞌuꞌx riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ruma can ketzij niꞌej chiva chi chica-na ri niꞌeꞌn cha la juyuꞌ la chi tiel-el y takꞌax chupan ri mar, can quireꞌ xtibꞌanataj, xa man cacaꞌ ta rucꞌuꞌx nucꞌutuj y nunimaj chi nibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumareꞌ, inreꞌ niꞌej chiva chi nojiel ri xticꞌutuj cha ri Dios antok ixreꞌ ntiꞌan orar, tinimaj chi jajaꞌ xtuꞌon ri ntivajoꞌ, y can xtibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y antok ntiꞌan orar, xa cꞌo jun ri cꞌo jun kax ri man otz ta rubꞌanun chiva, tibꞌanaꞌ perdonar, chi quireꞌ ri Itataꞌ ri cꞌo chicaj xtuꞌon perdonar ri man otz ta ri ntiꞌan choch. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ruma xa ixreꞌ man ntiꞌan ta perdonar jun ri cꞌo jun kax man otz ta rubꞌanun chiva, ri Itataꞌ ri cꞌo chicaj man xquixruꞌon ta jeꞌ perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús y ri ru-discípulos xaꞌlka chic pa tanamet Jerusalén. Y chireꞌ pa templo cꞌo-ve jajaꞌ antok ri principales sacerdotes, ri achiꞌaꞌ escribas y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri vinak, xaꞌlka riqꞌuin ");
INSERT INTO cakSNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","y xquicꞌutuj cha: ¿Chica autoridad cꞌo pan akꞌaꞌ chi naꞌan nojiel reꞌ, y chica xyoꞌn autoridad chava chi naꞌan cala? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ cꞌo jeꞌ jun kax ri nivajoꞌ nicꞌutuj chiva; tiꞌej cꞌa chuva y inreꞌ jeꞌ xtinꞌej chiva chica autoridad cꞌo pa nukꞌaꞌ chi niꞌan nojiel reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ri Juan xtak-pa ruma ri Dios chi xaꞌruꞌon bautizar ri vinak o xa achiꞌaꞌ xaꞌeꞌn cha? Tiꞌej cꞌa chuva, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Entonces ri principales sacerdotes, ri achiꞌaꞌ escribas y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, xquiꞌej-ka chiquivach: Xa nakaꞌej chi ri Juan ja ri Dios ri takayuon-pa richin, ri Jesús xtuꞌej chika: ¿Karruma man xinimaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y xa nakaꞌej chi ja ri achiꞌaꞌ xaꞌeꞌn cha ri Juan chi tubꞌanaꞌ quireꞌ, man otz ta. Ijejeꞌ xquiꞌej quireꞌ ruma niquixiꞌij-quiꞌ chiquivach ri vinak, ruma quinojiel cataꞌn chi ri Juan jun ketzij profeta. ");
INSERT INTO cakSNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y cꞌajareꞌ xquiꞌej-apa cha ri Jesús: Ojreꞌ man kataꞌn ta, xaꞌcha-apa. Y ri Jesús xuꞌej chica: Inreꞌ jeꞌ man xtinꞌej ta chiva chica autoridad cꞌo pa nukꞌaꞌ chi ncaꞌnꞌan quireꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y ri Jesús xutzꞌom cꞌa riqꞌuin parábolas (cꞌambꞌal-tzij) xchꞌoꞌ chica ri vinak y xuꞌej chica: Cꞌo cꞌa jun ache ri xutic uva pa rulief, xucꞌajuoj rij, xuꞌon incheꞌl jun chꞌiti pila chupan ri ulief chi niyitzꞌ ri uva chupan, y xuꞌon jeꞌ jun torre. Cꞌajareꞌ xuyaꞌ can pa kajic chica nicꞌaj aj-samajiel, y jajaꞌ xꞌa naj. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y antok xalka ri tiempo richin ri cosecha, ri rajaf ri ulief xutak-pa jun rusamajiel quiqꞌuin ri i-kajayuon ri rulief richin chi nalrumaꞌ ri uva kajbꞌal richin ri ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero ri achiꞌaꞌ ri i-kajayuon ri rulief xa xquitzꞌom y xquichꞌey, y man jun uva xquiya-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ri rajaf ri ulief xutak chic pa jun rusamajiel quiqꞌuin. Pero ijejeꞌ xa cha abꞌaj xquicꞌul-ve y xquisoc-el rujaluon, y chica-na ri xcajoꞌ xquiꞌan-el cha y quireꞌ xquitak-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ri rajaf ri ulief xutak chic pa jun rusamajiel. Y ri samajiel reꞌ xquimisas cuma ri i-kajayuon ri rulief. Y iqꞌuiy chic rusamajiel xaꞌrutak-pa; icꞌo xaꞌchꞌay, y icꞌo xaꞌquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruqꞌuisbꞌal, ri rajaf ri ulief xa joꞌc chic ri rucꞌajuol xcꞌujieꞌ can riqꞌuin y jajaꞌ altíra nrajoꞌ ri rucꞌajuol. Xutak-pa ri rucꞌajuol quiqꞌuin y xuꞌej: Ri achiꞌaꞌ reꞌ can xtiquiꞌan respetar antok xtiquitzꞌat chi ja ri nucꞌajuol ri xtiꞌka quiqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero ri achiꞌaꞌ reꞌ xquiꞌej-ka chiquivach: Jareꞌ ri xtuoc can rajaf nojiel ri ulief ri kakajuon, quixam-pa, kaquimisaj, chi quireꞌ pa kakꞌaꞌ ojreꞌ nicꞌujieꞌ can ri ulief, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y ja xquitzꞌom, xquiquimisaj, y juviera ri ulief ri ticuon uva choch, xbꞌaquicꞌakaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","¿Chica came xtuꞌon ri rajaf ri ulief ri ticuon uva choch chica ri achiꞌaꞌ reꞌ? Ri rajaf ri ulief xtipa y xcaꞌruquimisaj ri achiꞌaꞌ reꞌ y ri rulief xtuyaꞌ chic pa kajic chica nicꞌaj chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Man came itzꞌatuon ta ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios? Ri nuꞌej: Ri Abꞌaj ri man xka ta chiquivach ri achiꞌaꞌ ri i-bꞌanoy-jay, xa jareꞌ ri xyoꞌx ri lugar ri más nicꞌatzin chi quireꞌ ri jay man nitzak ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ja ri Ajaf ri xbꞌano quireꞌ cha, y ojreꞌ man jun bꞌay katzꞌatuon chi nibꞌanataj quireꞌ. Quireꞌ nuꞌej ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y ri achiꞌaꞌ choj-iqꞌuin xchꞌo-ve ri Jesús can ta xcajoꞌ xquitzꞌom yan el, ruma xiꞌka pa quiveꞌ (xquiꞌan entender) chi xa chiquij ijejeꞌ xuꞌej ri parábola (cꞌambꞌal-tzij). Pero man xquiꞌan ta, ruma niquixiꞌij-quiꞌ chiquivach ri vinak. Ijejeꞌ xquiyaꞌ can ri Jesús y xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y ri achiꞌaꞌ reꞌ xaꞌquitak-pa nicꞌaj achiꞌaꞌ fariseos y nicꞌaj ruvinak ri rey Herodes, ruma nicajoꞌ chi ri Jesús nitzak ta pa quikꞌaꞌ riqꞌuin ri tzij ri ncaꞌruꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Y ri achiꞌaꞌ xaꞌpa riqꞌuin ri Jesús y xquiꞌej cha: Maestro, ojreꞌ kataꞌn chi joꞌc ri ketzij ri naꞌej y nacꞌut ri ruchꞌabꞌal ri Dios y can ja-ve rubꞌixic naꞌan cha, ruma atreꞌ man naxiꞌij ta aviꞌ choch jun vinak mesque altíra rukꞌij. ¿Chica naꞌej chika? ¿Otz nakatoj ri impuestos ri nuꞌej ri rey César, o xa man otz ta? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ri Jesús can rataꞌn chi xa riqꞌuin caꞌyeꞌ quipalaj niquicꞌutuj quireꞌ cha. Rumareꞌ jajaꞌ xuꞌej chica: ¿Karruma nquiniꞌan tentar? Ticꞌama-pa jun moneda chi nitzꞌat, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y ijejeꞌ xbꞌaquicꞌama-pa ri moneda chi niquicꞌut choch. Y jajaꞌ xucꞌutuj chica: ¿Choj palaj y choj bꞌeꞌ ri cꞌo choch? xchaꞌ chica. Y ijejeꞌ xquiꞌej cha: Richin ri rey César, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y ri Jesús xuꞌej chica: Tiyaꞌ cꞌa cha ri César ri can richin ri César, y tiyaꞌ cha ri Dios ri can richin ri Dios, xchaꞌ ri Jesús chica. Y ijejeꞌ can vor chica xquinaꞌ antok xcaꞌxaj ri xuꞌej ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y icꞌo achiꞌaꞌ saduceos xaꞌlka riqꞌuin ri Jesús. Ri achiꞌaꞌ reꞌ man niquinimaj ta chi ri quiminakiꞌ can xcaꞌcꞌastaj-pa, y rumareꞌ ijejeꞌ xquicꞌutuj cha ri Jesús: ");
INSERT INTO cakSNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Maestro, ri Moisés rutzꞌibꞌan can chika, xa cꞌo jun ache nicon-el nuyaꞌ can ri raxjayil y xa man jun ralcꞌual nicꞌujieꞌ can, jun ruchakꞌ o runimal ticꞌulieꞌ riqꞌuin ri raxjayil, richin quireꞌ ncaꞌcꞌujieꞌ ralcꞌual ri quiminak chic el. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y ijejeꞌ xquiꞌej cꞌa: Xaꞌcꞌujieꞌ i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ. Ri naꞌay xcꞌulieꞌ, pero xcon-el y man jun ralcꞌual xcꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ri rucaꞌn, xcꞌulieꞌ riqꞌuin ri raxjayil, pero xcon-el jeꞌ y man jun ralcꞌual xcꞌujieꞌ can. Ri ruox, can quireꞌ jeꞌ mismo xuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Y quireꞌ xquiꞌan-el ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ. Y man jun chiquivach ri i-siete (ivukuꞌ) reꞌ xcꞌujieꞌ ta can ralcꞌual. Y antok i-quiminak chic el ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ, xcon jeꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y ri achiꞌaꞌ saduceos xquicꞌutuj cha ri Jesús: Antok xtalka ri kꞌij chi xcaꞌcꞌastaj-pa ri quiminakiꞌ, ¿choj axjayil xtuoc ri ixok reꞌ? Ruma ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ xuoc caxjayil, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Entonces ri Jesús xuꞌej chica: ¿Man came ix-sachnak ta riqꞌuin ri xiꞌej, ruma man ivataꞌn ta ri nuꞌej ri ruchꞌabꞌal ri Dios? ¿Man ivataꞌn ta jeꞌ ri ru-poder ri Dios? ");
INSERT INTO cakSNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ruma antok ri quiminakiꞌ xcaꞌcꞌastaj-pa, man xcaꞌcꞌulieꞌ ta chic, ni man xcaꞌyoꞌx ta chi xcaꞌcꞌulieꞌ. Ijejeꞌ xa xcaꞌuoc incheꞌl ri ángeles ri icꞌo chila chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Pero riqꞌuin ri quiminakiꞌ ri xcaꞌcꞌastaj-pa, ¿man itzꞌatuon ta cꞌa ri tzꞌibꞌan can ruma ri Moisés, antok xchꞌo-pa ri Dios cha chupan ri jun kꞌayis cꞌo ruqꞌuixal ri rubꞌinan zarza ri nicꞌat, antok ri Dios xuꞌej: Inreꞌ in Ru-Dios ri Abraham, in Ru-Dios ri Isaac y in Ru-Dios ri Jacob? xcha-pa cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ri Dios man Qui-Dios ta ri quiminakiꞌ, xa Qui-Dios ri icꞌas. Rumareꞌ inreꞌ niꞌej chi ixreꞌ can ix-sachnak riqꞌuin ri ntiꞌej, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y xjiel-apa riqꞌuin ri Jesús jun chiquivach ri achiꞌaꞌ escribas. Ri ache reꞌ xraꞌxaj ri xquiꞌej ri achiꞌaꞌ saduceos cha ri Jesús, y xraꞌxaj jeꞌ ri xuꞌej ri Jesús chica ri achiꞌaꞌ reꞌ. Y choch jajaꞌ can kꞌalaj chi otz ri xuꞌej ri Jesús y mareꞌ xucꞌutuj cha: ¿Chica chiquivach ri mandamientos ri xuyaꞌ ri Dios cha ri Moisés, ri naꞌay? xchaꞌ cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y ri Jesús xuꞌej cha: Ri naꞌay mandamiento nuꞌej: Tivaxaj ixreꞌ aj-Israel, ri Kajaf joꞌc Jun, y reꞌ ja ri Kajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Can tavajoꞌ ri Avajaf Dios, tavajoꞌ riqꞌuin nojiel avánima, tavajoꞌ riqꞌuin nojiel ri acꞌaslien, tavajoꞌ riqꞌuin nojiel ri anoꞌj y tavajoꞌ jeꞌ riqꞌuin nojiel ri avuchukꞌaꞌ. Jareꞌ ri mandamiento ri más nem. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y cꞌo chic jun rucaꞌn mandamiento ri casi junan riqꞌuin ri naꞌay. Y ri mandamiento reꞌ nuꞌej: Can incheꞌl ri navajo-ka-aviꞌ atreꞌ, can quireꞌ jeꞌ mismo tavajoꞌ ri a-prójimo. Ja caꞌyeꞌ mandamientos reꞌ ri cꞌo más quikalien, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y ri ache escriba xuꞌej cꞌa cha ri Jesús: Maestro, can quire-ve. Can ketzij ri xaꞌej chi joꞌc jun Dios cꞌo, y man jun chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nicꞌatzin chi navajoꞌ riqꞌuin nojiel avánima, navajoꞌ riqꞌuin nojiel ri anoꞌj, navajoꞌ riqꞌuin nojiel ri acꞌaslien y navajoꞌ jeꞌ riqꞌuin nojiel avuchukꞌaꞌ. Y can incheꞌl ri navajo-ka-aviꞌ atreꞌ, can quireꞌ jeꞌ mismo tavajoꞌ ri a-prójimo; nojiel reꞌ cꞌo más rakalien que choch ri chicop o jun chic kax ri ncaꞌyoꞌx choch ri Dios, xchaꞌ ri ache escriba. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y antok ri Jesús xraꞌxaj chi jaꞌal xiꞌka paroꞌ (xuꞌon entender) ri jun ache reꞌ, ri Jesús xuꞌej cha: Atreꞌ man naj ta chic atcꞌo-ve chi ncatuoc pa ru-reino ri Dios, xchaꞌ cha. Y jareꞌ antok man jun chic xutzꞌom rucovil chi cꞌo ta ri chica xucꞌutuj cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y ri Jesús chi ncaꞌrutijuoj ri vinak ri quimaluon-quiꞌ riqꞌuin chireꞌ pa templo, xuꞌej cꞌa chica: ¿Karruma ri achiꞌaꞌ escribas niquiꞌej chi ri Cristo xa choj jun rumáma can ri rey David? ");
INSERT INTO cakSNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ruma ja mismo ri rey David xuꞌej ri xꞌeꞌx cha ruma ri Espíritu Santo: Ri Ajaf Dios xuꞌej cha ri Vajaf: Catzꞌuyeꞌ pa nu-derecha, hasta cꞌa xcaꞌnyaꞌ ri av-enemigos chuxieꞌ avakan. Quireꞌ xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y xa ri rey David xuꞌej Vajaf cha ri Cristo, ¿karruma niꞌeꞌx chi ri Cristo xa choj jun rumáma can ri rey David? xchaꞌ ri Jesús. Y iqꞌuiy chiquivach ri vinak xka chiquivach ri xcaꞌxaj ri xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y ri Jesús xuꞌej jeꞌ chica ri vinak antok ncaꞌrutijuoj: Tibꞌanaꞌ cuenta-iviꞌ, man tiꞌan incheꞌl niquiꞌan ri achiꞌaꞌ escribas. Ruma ijejeꞌ can altíra nika chiquivach niquicusaj jucujak tak tziak, chi quireꞌ ncaꞌtzꞌiet chi utzulaj tak achiꞌaꞌ. Y can altíra nika chiquivach chi ncaꞌan saludar ri pacheꞌ niquimol-ve-quiꞌ qꞌuiy vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y can ja ri naꞌay tak chꞌacat nicajoꞌ pa tak sinagogas y pa tak vaꞌen. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ri achiꞌaꞌ reꞌ niquimaj nojiel kax quichin ri malcaꞌn-ixokiꞌ, y chi caꞌnimax chi jaꞌal quicꞌaslien, can ncaꞌlayuj niquiꞌan orar. Pero ijejeꞌ can xtika más ri castigo pa quiveꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y ri Jesús tzꞌuyul choch ri pacheꞌ niyoꞌx-ve can ri ofrenda. Jajaꞌ ncaꞌrutzꞌat ri vinak ri niquiyaꞌ can miera chireꞌ. Xaꞌrutzꞌat iqꞌuiy bꞌayomaꞌ ri qꞌuiy miera niquiyaꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero xalka jun malcaꞌn-ixok ri puobra. Jajaꞌ xuyaꞌ can caꞌyeꞌ fichas ri man qꞌuiy ta oc rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y ri Jesús xaꞌrayuoj ri ru-discípulos y xuꞌej chica: Can ketzij ri niꞌej chiva chi ja ri malcaꞌn-ixok puobra la ri xyoꞌn can más que choch ri xquiyaꞌ can quinojiel ri nicꞌaj chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ruma jajaꞌ mesque man qꞌuiy ta ru-miera cꞌo, xuyaꞌ can nojiel ri cꞌo riqꞌuin. Pero ri bꞌayomaꞌ, mesque qꞌuiy miera xquiyaꞌ can, xa ja ri nuꞌon suobra quiqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y antok ri Jesús ntiel-pa pa templo, jun chiquivach ri ru-discípulos xuꞌej cha: Maestro, tatzꞌataꞌ ri quibꞌanic ri jay richin ri templo, can jaꞌal bꞌanun chica, y ri nimaꞌk tak abꞌaj ri i-cusan, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ri Jesús xuꞌej cha ri ru-discípulo: ¿Natzꞌat va nimaꞌk tak jay va? Xtalka jun kꞌij antok nojiel va xcaꞌvulex. Quinojiel ri nimaꞌk tak abꞌaj ri i-cusan, can xcaꞌvulex, y man jun abꞌaj ri xticꞌujieꞌ can pa ru-lugar, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y antok ri Jesús xtzꞌuyeꞌ paroꞌ ri juyuꞌ Olivos, ri pacheꞌ kꞌalaj niquitzꞌat-pa ri templo; ri Pedro, ri Jacobo, ri Juan y ri Andrés xaꞌjiel-apa riqꞌuin y xquicꞌutuj cha: ");
INSERT INTO cakSNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Taꞌej chika, ¿jampeꞌ cꞌa xtibꞌanataj ri xaꞌej? ¿Y chica señal xtibꞌanataj antok nojiel ri kax reꞌ xtuꞌon cumplir? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y ri Jesús xutzꞌom cꞌa rutzijoxic y quireꞌ xuꞌej chica: Tibꞌanaꞌ cuenta-iviꞌ chi man jun tibꞌano maña chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ruma iqꞌuiy ri xcaꞌpa y xtiquiꞌej: Inreꞌ ri Cristo, xcaꞌchaꞌ. Y iqꞌuiy ri xcaꞌquiꞌan maña chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Pero antok xtivaxaj chi nibꞌanataj guerras y xtivaxaj jeꞌ chi cꞌo guerras ri xcaꞌpa, man tixiꞌij-iviꞌ, ruma nicꞌatzin chi nojiel reꞌ xcaꞌbꞌanataj. Pero man ja ta yan reꞌ ri ruqꞌuisbꞌal kꞌij richin ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jun nación xtipalaj chirij jun chic nación y jun reino xtipalaj chirij jun chic reino. Xtuꞌon nimaꞌk tak cubꞌrakan qꞌuiy lugar, xtuꞌon viꞌjal, y qꞌuiy jeꞌ roch ayoval xcaꞌpa chiquicajol ri vinak pa tak tanamet. Y nojiel reꞌ xa cꞌa ja oc rutzꞌucbꞌal richin ri sufrimientos ri xcaꞌpa. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero ixreꞌ can tibꞌanaꞌ cuenta-iviꞌ. Ruma ixreꞌ xquixjach pa quikꞌaꞌ ri autoridades quichin ri tanamet y xquixchꞌay pa tak sinagogas. Y xquixucꞌuax chiquivach gobernadores y chiquivach reyes ruma iyoꞌn ivánima viqꞌuin, pero ixreꞌ xquixtiquir cꞌa xquinitzijuoj chiquivach ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y antes chi xtalka ri ruqꞌuisbꞌal kꞌij, nicꞌatzin chi ri evangelio nitzijos nojiel naciones. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Pero antok xquixucꞌuax chi xquixjach pa quikꞌaꞌ ri autoridades, man tiꞌan preocupar-iviꞌ ri chica tzij ri xtiꞌej, ni man tiꞌan pensar. Ixreꞌ joꞌc tiꞌej ri chica tzij ri xtuyaꞌ ri Dios chiva ri misma huora reꞌ, ruma man ixreꞌ ta ri xquixchꞌoꞌ chupan ri huora reꞌ, xa can ja ri Espíritu Santo ri xtichꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Y chiquicajol ri quichakꞌ-quinimal-quiꞌ, jun chiquivach ijejeꞌ xtujach ri jun chic chi niquimisas, y ri tataꞌj xcaꞌquijach ri calcꞌual chi ncaꞌquimisas, y ri calcꞌual xcaꞌpalaj chiquij ri quitie-quitataꞌ y xcaꞌquijach chi ncaꞌquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Can quinojiel vinak, itziel xquixquitzꞌat ruma iyoꞌn ivánima viqꞌuin. Pero ri man xtitzalaj ta chirij y xtucochꞌ nojiel reꞌ hasta el fin, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Pero antok xtitzꞌat chi xcaꞌbꞌanataj ri itziel tak kax chupan ri lugar ri pacheꞌ man rucꞌamun ta chi niꞌan chireꞌ, ja xtiqꞌuis ri lugar reꞌ, ri incheꞌl tzꞌibꞌan can ruma ri profeta Daniel, (ri nibꞌano leer, can tubꞌanaꞌ entender). Entonces ri icꞌo Judea, caꞌnumaj-el pa tak juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri cꞌo paroꞌ ri rachuoch antok xtalka ri huora reꞌ, man tika-pa chi ntuoc pa rachuoch chi cꞌo niruma-pa, choj tiꞌa; ");
INSERT INTO cakSNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","y ri cꞌo pan avan, man titzalaj-pa chirachuoch chi nalrumaꞌ ri ru-capa. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Can juyeꞌ quivach ri ixokiꞌ ri icꞌo encinta (embarazada) antok xtalka ri kꞌij reꞌ, y quireꞌ jeꞌ ri ixokiꞌ ri cꞌa niquiyaꞌ quitzꞌun ri quixuluꞌ! ");
INSERT INTO cakSNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Rumareꞌ tibꞌanaꞌ orar chi antok xquixnumaj, man ta pa ru-tiempo jobꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ruma antok xtalka ri kꞌij reꞌ, can nem ri sufrimiento ri xtipa, ri man jun bꞌay quireꞌ rubꞌanun xa-jan antok bꞌanun-pa ri roch-ulief ruma ri Dios, ni xtalka chic jun bꞌay ri sufrimiento reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y xa ta ri Ajaf Dios man ta nuꞌon coꞌl cha ri tiempo richin ri sufrimiento, man jun nicolotaj. Pero cuma ri i-ruchoꞌn chic, can xtuꞌon coꞌl cha ri tiempo reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupan ri kꞌij reꞌ, xa icꞌo ri xcaꞌeꞌn chiva: Titzꞌataꞌ, ja cꞌo vaveꞌ ri Cristo, o xa niquiꞌej chiva: Titzꞌataꞌ, ja cꞌo chila, man tinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ruma xcaꞌpa falsos cristos y falsos profetas. Ijejeꞌ xcaꞌquiꞌan milagros y señales chi xtiquiꞌan maña chica ri vinak. Y ijejeꞌ nicajoꞌ xtiquiꞌan maña chica hasta ri i-choꞌn chic ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero ixreꞌ can tibꞌanaꞌ cuenta-iviꞌ. Can ja yan xinꞌej can chiva nojiel ri xcaꞌbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupan ri tiempo reꞌ, antok kꞌaxnak chic ri sufrimiento, ri kꞌij man chic xtitzuꞌn ta, y ri icꞌ man xtuyaꞌ ta chic rusakil. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri estrellas (chꞌumil) xcaꞌtzak-pa chicaj. Can nojiel cꞌa ri icꞌo chicaj xcaꞌsilos. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Entonces xtitzꞌatataj ri Xtak-pa chicaj chi xalax chiꞌicajol, chi xtika-pa chupan mukul riqꞌuin namalaj poder y namalaj rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y xcaꞌrutak ri ru-ángeles chi ncaꞌquimol ri i-ruchoꞌn chic. Can xcaꞌquimol quinojiel ri icꞌo oriente, ri icꞌo occidente, ri icꞌo norte y ri icꞌo sur. Can xcaꞌquimol quinojiel ri i-ruchoꞌn chic; chica-na lugar ri roch-ulief icꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Chirij ri víquix tivatamaj ri parábola (cꞌambꞌal-tzij): Antok ncaꞌjotoyin-pa ri rukꞌaꞌ y ncaꞌiel-pa ri ruxak, ivataꞌn chi ri ru-tiempo ri sakꞌij ya nalka. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y quireꞌ jeꞌ antok xtitzꞌat chi ncaꞌbꞌanataj ri kax ri xinꞌej, tivatamaj cꞌa chi ya nalka ri kꞌij reꞌ. Can cierca chic cꞌo-ve-pa. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Can ketzij niꞌej chiva, chi nojiel reꞌ xtibꞌanataj antok ri vinak richin ri tiempo vacame cꞌa icꞌo ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ri roch-ulief y ri rocaj can xcaꞌqꞌuis. Pero ri nuchꞌabꞌal man xtiqꞌuis ta quireꞌ, xa can xtibꞌanataj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero ri kꞌij y ri huora antok xtipa chic, man jun taꞌmayuon. Nixta ri ángeles ri icꞌo chila chicaj man cataꞌn ta jampeꞌ. Ni ri Rucꞌajuol ri Dios man rataꞌn ta, xa joꞌc ri Rutataꞌ Dios taꞌmayuon reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Rumareꞌ ixreꞌ can tibꞌanaꞌ cuenta-iviꞌ, man timastaj chiva chi ntivoyoꞌiej-apa y tibꞌanaꞌ orar, ruma man ivataꞌn ta jampeꞌ xtalka ri kꞌij chi xtipa chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Can junan riqꞌuin ri xuꞌon jun ache ri xuyaꞌ can ri rachuoch y niꞌa naj, jajaꞌ xuyaꞌ can autoridad pa quikꞌaꞌ ri rusamajiel y xuyaꞌ can quisamaj chiquijunal. Y cha ri nuchajij can ri rachuoch, nuꞌej can cha chi can tuyoꞌiej-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Rumareꞌ, man timastaj chiva chi ntivoyoꞌiej-apa, ruma man ivataꞌn ta jampeꞌ xtalka ri Rajaf-jay. Ruma nak xa nalka antok nuꞌon-ka chakꞌaꞌ, o pa nicꞌaj-akꞌaꞌ, o antok nitzirin-pa ri mamaꞌ o macꞌajan. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ruma antok xtipa chic jun bꞌay, jun arapienta. Can tivoyoꞌiej-apa chi quireꞌ man nquixalrilaꞌ ta nquixvar. ");
INSERT INTO cakSNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y incheꞌl ri niꞌej chiva ixreꞌ, can quireꞌ jeꞌ niꞌej chica quinojiel, can quinivoyoꞌiej-apa, xchaꞌ ri Jesús chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa caꞌyeꞌ chic kꞌij nrajoꞌ chi nalka ri namakꞌej Pascua, y ri namakꞌej antok nicꞌux ri simíta ri manak levadura riqꞌuin. Y ri principales sacerdotes y ri achiꞌaꞌ escribas niquiꞌan pensar ri chica maña xtiquicusaj chi nika ri Jesús pa quikꞌaꞌ y niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ijejeꞌ xquiꞌej chiquivach: Man nakatzꞌom ta chupan ri namakꞌej, chi quireꞌ man ncaꞌpalaj ta pa ri vinak chikij, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y ri Jesús cꞌo chupan ri aldea Betania, chirachuoch ri Simón ri xcꞌachoj riqꞌuin ri yabꞌil lepra. Ri Jesús tzꞌuyul chirij ri mesa, y jareꞌ antok xalka jun ixok rucꞌamun-pa jun frasco ri bꞌanun cha alabastro y cꞌo nardo puro chupan; jun jubꞌul akꞌuon ri altíra cara rajal. Y ri ixok xukꞌumij ri rukul ri frasco y xukꞌej pa rujaluon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y icꞌo ri xpa quiyoval antok xquitzꞌat ri xuꞌon ri ixok riqꞌuin ri jubꞌul akꞌuon y xquiꞌej cꞌa: ¿Karruma choj xutix ri jubꞌul akꞌuon la? ");
INSERT INTO cakSNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ruma xa ta xcꞌayix, xyoꞌx ta más trescientos denarios, y ri rajal xjach ta chica ri i-puobra, xaꞌchaꞌ. Y qꞌuiy kax ri niquiꞌej-apa chirij ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xuꞌej chica: ¿Karruma man nquixtanieꞌ ta ka nquixtzijuon chirij ri ixok? Xa tiyaꞌ can. Jajaꞌ can otz ri xuꞌon chuva. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri i-puobra, can siempre icꞌo iviqꞌuin, y chica-na kꞌij ri ntivajoꞌ nquiꞌtoꞌ, can quiꞌtoꞌ. Pero inreꞌ man siempre ta xquicꞌujieꞌ iviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Jajaꞌ xuꞌon ri chica nitiquir nuꞌon. Ruma jajaꞌ xuyaꞌ yan ri jubꞌul akꞌuon chirij ri nu-cuerpo richin antok xquibꞌamuk. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Can ketzij ri niꞌej chiva, chi chica-na lugar xtitzijos-ve ri evangelio, chireꞌ jeꞌ xtitzijos-ve ri xuꞌon va ixok va. Can choch cꞌa nojiel ri roch-ulief xtitzijos-ve, y man jun bꞌay xtimastaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Entonces ri Judas Iscariote, jun chiquivach ri i-doce (cabꞌalajuj) ru-discípulos ri Jesús, xꞌa quiqꞌuin ri principales sacerdotes, chi nujach ri Jesús pa quikꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y antok ijejeꞌ xcaꞌxaj quireꞌ, xaꞌquicuot, y xquiꞌan prometer chi niquiyaꞌ miera cha. Y ri Judas ja xutzꞌom cꞌa rucanuxic chica manera nuꞌon chi nujach ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chupan ri naꞌay kꞌij richin ri namakꞌej antok nicꞌux ri simíta ri manak levadura riqꞌuin, y antok ncaꞌquimisas ri alaj tak ovejas richin ri Pascua, ri discípulos xquicꞌutuj cha ri Jesús: ¿Pacheꞌ navajoꞌ naꞌan-ve ri vaꞌen chupan ri Pascua, chi nkuꞌa y nakachojmij nojiel ri nicꞌatzin? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y ri Jesús can xaꞌrutak-el icaꞌyeꞌ chiquivach ri ru-discípulos y xuꞌej-el chica: Quixꞌin pa tanamet Jerusalén, y chireꞌ xticꞌul jun ache rucꞌuan yaꞌ chupan jun cántaro. Quixꞌin chirij; ");
INSERT INTO cakSNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","y ri jay ri pacheꞌ xtuoc-ve, chireꞌ jeꞌ quixuoc-ve ixreꞌ, y quixchꞌoꞌ riqꞌuin ri rajaf-jay y tiꞌej cha: Ri Maestro ruꞌeꞌn-pa: ¿Pacheꞌ cꞌo-ve ri cuarto ri pacheꞌ niꞌan-ve ri vaꞌen richin ri Pascua quiqꞌuin ri nu-discípulos? quixchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y ri rajaf-jay xquixrucꞌuaj rucaꞌn piso ri rachuoch. Y chireꞌ cꞌo jun cuarto nem rupan ri chojmin chic ri rupan; chireꞌ tibꞌana-ve ri chica xtakacꞌux richin ri Pascua, xcha-el chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y ri discípulos reꞌ xaꞌa pa tanamet Jerusalén. Y antok xaꞌbꞌaka, can xbꞌanataj-na-ve incheꞌl ri ruꞌeꞌn-el ri Jesús chica. Y ijejeꞌ can xquichojmij nojiel ri nicꞌatzin chica richin ri Pascua reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Y antok xcokꞌa-ka, ri Jesús y ri i-doce (cabꞌalajuj) ru-discípulos xaꞌlka chireꞌ pa jay. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y antok i-tzꞌuyul chic apa chirij ri mesa y ncaꞌvaꞌ, ri Jesús xuꞌej: Can ketzij niꞌej chiva, chi jun chivach ixreꞌ ri niva-pa viqꞌuin ri xtijacho vichin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ijejeꞌ can xaꞌbꞌisuon-ka, y chiquijunal xquicꞌutuj-apa cha: ¿Inreꞌ came ri xquibꞌano quireꞌ? nchaꞌ jun. ¿Inreꞌ came ri xquibꞌano quireꞌ? nchaꞌ jun chic. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y ri Jesús xuꞌej chica: Xa jun chivach ri ix doce (cabꞌalajuj), ri numubꞌa-pa ru-simíta viqꞌuin chupan ri plato. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can ketzij chi ri Xtak-pa chicaj chi xalax chiꞌicajol can niꞌa. Can xtibꞌanataj-na-ve incheꞌl ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. ¡Pero juyeꞌ roch ri ache ri xtijacho richin! Más otz man ta xalax ri ache reꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y antok cꞌa ncaꞌvaꞌ, ri Jesús xucꞌan-apa jun simíta y xuyaꞌ tiox bꞌaꞌ cha ri Dios, y xuper y xuyaꞌ chica ri ru-discípulos y xuꞌej chica: Titzꞌamaꞌ ri simíta; ruma jareꞌ ri nu-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y ri Jesús xucꞌan-apa ri copa, y xuyaꞌ tiox bꞌaꞌ cha ri Dios; xuyaꞌ cꞌa chica, y quinojiel cꞌa xquikun ri ruyaꞌl ri uva. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y jajaꞌ xuꞌej chica ri ru-discípulos: Jareꞌ ri nuquiqꞌuiel ri xtiꞌin antok xquiquimisas pa qui-cuenta iqꞌuiy vinak. Riqꞌuin ri nuquiqꞌuiel, ja xticꞌachoj ri cꞌacꞌacꞌ pacto ri rajoꞌn-pa ri Dios chi nuꞌon quiqꞌuin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Can ketzij ri niꞌej chiva chi man chic xtinkun ta ri ruyaꞌl ri uva, hasta cꞌa chupan ri kꞌij antok xtinkun jun cꞌacꞌacꞌ ruyaꞌl ri uva iviqꞌuin chupan ri ru-reino ri Dios, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y antok quibꞌixan chic jun bꞌix chi niquiyaꞌ rukꞌij ri Dios, ri Jesús y ri ru-discípulos xaꞌiel-el chireꞌ pa jay y xaꞌa choch ri juyuꞌ Olivos. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y antok i-bꞌanak, ri Jesús xuꞌej chica ri ru-discípulos: Ixvonojiel ixreꞌ xtiquiraj-el-iviꞌ y xquiniyaꞌ can nuyuon chupan va akꞌaꞌ va. Ruma chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can nuꞌej: Antok inreꞌ xtinyaꞌ lugar chi niquimisas ri nichajin quichin ri ovejas, ri ovejas xtiquiquiraj-el-quiꞌ. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero inreꞌ xa xquicꞌastaj-pa. Y después xquixvoyoꞌiej Galilea, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Entonces ri Pedro xuꞌej cha: Mesque quinojiel xcatquiyaꞌ can ayuon, pero inreꞌ man xtinꞌan ta quireꞌ, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Y ri Jesús xuꞌej cha: Inreꞌ can ketzij niꞌej chava, chi atreꞌ vacame, chupan va akꞌaꞌ va, xa cꞌa majaꞌ titzirin-pa ri mamaꞌ caꞌyeꞌ mul, antok oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero ri Pedro nuꞌej cha y man nitanieꞌ ta: Xa nicꞌatzin chi junan nquicon aviqꞌuin, pero man xtinꞌej ta chi man vataꞌn ta avach, xchaꞌ ri Pedro. Y quinojiel ri ru-discípulos quireꞌ jeꞌ xquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri ru-discípulos xaꞌbꞌaka chupan ri lugar rubꞌinan Getsemaní. Y ri Jesús xuꞌej chica ri ru-discípulos: Quixtzꞌuyeꞌ can vaveꞌ, inreꞌ nibꞌanaꞌ orar. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Y jajaꞌ joꞌc ri Pedro, ri Jacobo y ri Juan ri xaꞌrucꞌuaj riqꞌuin, y chirij jajaꞌ xpa jun nem bꞌis, ruma xunaꞌ yan ri sufrimiento ri xtukꞌasaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xuꞌej chica ri iyoxeꞌ ru-discípulos: Ri vánima altíra nibꞌisuon; can nquiruquimisaj ninaꞌ. Quixcꞌujieꞌ can vaveꞌ y quixcꞌasieꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Jajaꞌ xꞌin chic apa jubꞌaꞌ y chireꞌ xxuquie-ka, y xukasaj-ka ri rujaluon cꞌa pan ulief y xuꞌon orar. Jajaꞌ xucꞌutuj xa cꞌo ta cheꞌl, choj ta nakꞌax ri huora reꞌ, chi quireꞌ man ta nukꞌasaj ri sufrimiento. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y quireꞌ ri tzij ri xuꞌej chupan ri ru-oración: Nataꞌ, inreꞌ vataꞌn chi atreꞌ ncatiquir naꞌan nojiel. Tabꞌanaꞌ chi man ta nikꞌasaj ri sufrimiento. Pero man taꞌan ri nivajoꞌ inreꞌ, xa ja ri navajoꞌ atreꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y antok jajaꞌ xtanieꞌ riqꞌuin ri oración, xpa cꞌa quiqꞌuin ri iyoxeꞌ ru-discípulos, y xaꞌlrilaꞌ xa ncaꞌvar. Xpa jajaꞌ xuꞌej cha ri Pedro: Simón, ¿xa xavar-ka? ¿Can man xatiquir ta xacꞌasieꞌ jun huora? ");
INSERT INTO cakSNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Quixcꞌasieꞌ y tibꞌanaꞌ orar richin chi man quixtzak chupan ri tentación. Inreꞌ vataꞌn chi ri iv-espíritu nrajoꞌ nuꞌon ri nrajoꞌ ri Dios. Pero ri i-cuerpo manak ruchukꞌaꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y ri Jesús xꞌa chic apa jun bꞌay chi xirubꞌanaꞌ orar. Y ja mismo xucꞌutuj chupan ri oración. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y antok xpa chic jun bꞌay quiqꞌuin ri iyoxeꞌ ru-discípulos, xaꞌlrilaꞌ xa ncaꞌvar ruma man chic niquicochꞌ ta quivaran. Y ijejeꞌ man niquil ta chica niquiꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Pero antok xpa chi oxeꞌ mul, jajaꞌ xuꞌej chica ri iyoxeꞌ ru-discípulos: Vacame quixvar y quixuxlan. Pero ya otz cala. Ruma ja xalka ri huora chi ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach-el pa quikꞌaꞌ ri pecadores. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Quixpalaj. Joꞌ. Ja patanak ri xtijacho vichin, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y ri Jesús cꞌa nitzijuon, antok xalka ri Judas, ri jun chiquivach ri doce (cabꞌalajuj) discípulos; riqꞌuin jajaꞌ i-patanak iqꞌuiy vinak ri quicꞌamun-pa chieꞌ y espadas. Quinojiel i-takuon-el cuma ri principales sacerdotes, cuma ri achiꞌaꞌ escribas y cuma jeꞌ ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri nijacho richin ri Jesús, can ruꞌeꞌn yan pa chica ri i-patanak riqꞌuin, ri chica xtuꞌon chi nucꞌut ri Jesús chiquivach. Jajaꞌ ruꞌeꞌn-pa chica: Ja ri jun ri xtintzꞌubꞌaj ruchiꞌ, jareꞌ ri Jesús. Titzꞌamaꞌ cꞌa otz chi man tinumaj chivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y antok ri Judas xalka, can ja xjiel-apa riqꞌuin ri Jesús y xuꞌej cha: Maestro, Maestro, xchaꞌ cha. Y ja xutzꞌubꞌaj ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y ri vinak ri i-patanak, can ja xquitzꞌom ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun chiquivach ri icꞌo chireꞌ, xralasaj-el ri ru-espada y xusoc ri ru-esclavo ri sacerdote ri más cꞌo rukꞌij, y xralasaj-el jun ruxiquin. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y ri Jesús xuꞌej chica ri vinak ri i-patanak: ¿Ixreꞌ ix-patanak incheꞌl chirij jun alakꞌuon; mareꞌ icꞌamun-pa chieꞌ y espadas chi nquiniltzꞌamaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Can kꞌij-kꞌij xicꞌujieꞌ iviqꞌuin pa templo antok xincꞌut ri ruchꞌabꞌal ri Dios chivach, y man xinitzꞌom ta. Pero nibꞌanataj quireꞌ richin nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y quinojiel ri discípulos xquiyaꞌ can ruyuon ri Jesús y xaꞌnumaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero cꞌo jun alaꞌ ri bꞌanak chirij ri Jesús y joꞌc cha jun cꞌul rutzꞌapin rij. Y ri i-tzꞌamayuon ri Jesús, xquitzꞌom jeꞌ ri alaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero jajaꞌ xuyaꞌ can ri cꞌul, y xnumaj-el man jun rutziak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ri xaꞌbꞌatzꞌamo ri Jesús xquicꞌuaj cꞌa riqꞌuin ri sacerdote ri más cꞌo rukꞌij. Y xquimol-quiꞌ quinojiel ri principales sacerdotes, ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, y ri achiꞌaꞌ escribas. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y ri Pedro bꞌanak chirij, pero cꞌa naj cꞌo can y xuoc jeꞌ chirachuoch ri sacerdote ri más cꞌo rukꞌij, y xcꞌujieꞌ chojay. Y xtzꞌuye-ka chiquicajol ri alguaciles ri icꞌo chireꞌ ri niquimakꞌ-quiꞌ choch-kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y ri principales sacerdotes y quinojiel ri autoridades quichin ri israelitas, niquicanuj manera chi niquitzꞌak tzij chirij ri Jesús, chi quireꞌ niquitak chi niquimisas, pero xa man jun xquil chirij. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Can iqꞌuiy ri xaꞌlka chi xquitzꞌak tzij chirij, pero xa man junan ta ri xquiꞌej-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y después icꞌo nicꞌaj chic ri xaꞌbꞌapiꞌie-pa y xquiꞌej-apa tzꞌakon tak tzij chirij ri Jesús. Quireꞌ xquiꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ojreꞌ xkaxaj antok jajaꞌ xuꞌej: Inreꞌ xtinvulij ri templo ri bꞌanun cuma achiꞌaꞌ, y chi oxeꞌ kꞌij xtinꞌan chic jun, y man achiꞌaꞌ ta xcaꞌbꞌano. Quireꞌ ruꞌeꞌn, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Y ni riqꞌuin reꞌ, man junan ta jeꞌ ri xquiꞌej-apa. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y ri Caifás, ri sacerdote ri más cꞌo rukꞌij, xpiꞌieꞌ pa nicꞌaj y xucꞌutuj cha ri Jesús: ¿Man jun kax naꞌej? ¿Ketzij ri xquiꞌej chavij? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús man jun tzij xuꞌej. Rumareꞌ xpa ri sacerdote ri más cꞌo rukꞌij, xucꞌutuj chic cha: ¿Atreꞌ ri Cristo, ri Rucꞌajuol ri Dios? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xuꞌej cha: Inreꞌ. Y xtitzꞌat ri Xtak-pa chicaj chi xalax chiꞌicajol, chi tzꞌuyul pa ru-derecha ri Dios ri nitiquir nuꞌon nojiel. Y xtitzꞌat antok nika-pa chupan mukul ri chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Entonces ri sacerdote ri más cꞌo rukꞌij xurakꞌachꞌij-ka ri rutziak chirij, y xuꞌej: Man chic nicꞌatzin ta chi nalka jun chic chi nalruꞌej chika chi man otz ta ri i-rubꞌanun. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ixreꞌ xivaxaj ri xuꞌej, chi jajaꞌ junan riqꞌuin ri Dios. Riqꞌuin reꞌ, nuyokꞌ rubꞌeꞌ ri Dios. ¿Chica ntiꞌej ixreꞌ vacame? xchaꞌ jajaꞌ. Y quinojiel xquiꞌej chi otz chi tiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y icꞌo nicꞌaj xquichubꞌaj, y xquitzꞌapij rutzubꞌal, y xquiyaꞌ kꞌaꞌ cha y niquicꞌutuj cha: ¿Chica ri xchꞌayo avichin? Taꞌej chika, ncaꞌchaꞌ cha. Y ri alguaciles ri icꞌo chireꞌ, xquichꞌey jeꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y antok ri Pedro cꞌa cꞌo pa xulan ri chojay, cꞌo jun xtan aj-chi-icꞌ richin ri sacerdote ri más cꞌo rukꞌij xalka chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Y antok ri aj-chi-icꞌ xutzꞌat-apa ri Pedro chi rumakꞌuon-riꞌ choch ri kꞌakꞌ, xutzꞌat otz y xuꞌej cha: Atreꞌ jeꞌ at rachꞌil ri Jesús ri aj-Nazaret, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ri Pedro man xuꞌej ta ri ketzij, ruma xuꞌej: Inreꞌ man vataꞌn ta roch. Man vataꞌn ta chica ri naꞌej, xchaꞌ cha ri xtan. Y ri Pedro xiel-el chireꞌ chiquicajol y xꞌa chuchi-bꞌay. Y jareꞌ antok xtzirin-pa ri mamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y antok ri xtan aj-chi-icꞌ xutzꞌat chic jun bꞌay ri Pedro, xuꞌej chica ri icꞌo chireꞌ: La ache la jun chiquivach ri icꞌo riqꞌuin ri Jesús, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ri Pedro jun chic bꞌay man xuꞌej ta ri ketzij. Y cꞌa jubꞌaꞌ oc quireꞌ tiꞌeꞌx cha, ri quimaluon-quiꞌ chireꞌ xquiꞌej cha: Can ketzij chi atreꞌ at jun chiquivach ri icꞌo riqꞌuin ri Jesús. Ruma atreꞌ Galilea at-patanak-ve, y can junan ncachꞌoꞌ quiqꞌuin, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Entonces ri Pedro xuꞌej: Inreꞌ man vataꞌn ta roch ri ache ri ntiꞌej ixreꞌ. Can choch ri Dios niꞌej chiva chi inreꞌ man vataꞌn ta roch. Y xa man ketzij ta ri niꞌej, tika ri castigo panoꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y ri mamaꞌ xtzirin-pa rucaꞌn mul. Entonces ri Pedro xalka paroꞌ ri tzij ri ruꞌeꞌn ri Jesús cha: Antes cꞌa majaꞌ titzirin-pa ri mamaꞌ caꞌyeꞌ mul, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch. Y ruma nuꞌon pensar chirij ri xuꞌej ri Jesús cha, ja xuokꞌ-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y cꞌa cumaj yan, ri principales sacerdotes xquimol-quiꞌ quiqꞌuin ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar y ri achiꞌaꞌ escribas. Quinojiel ri autoridades quichin ri israelitas ya xquiꞌan pensar cheꞌl niquiꞌan cha ri Jesús, y mareꞌ xquixim-el y xbꞌaquijachaꞌ pa rukꞌaꞌ ri Pilato. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y ri Pilato xucꞌutuj cha ri Jesús: ¿Atreꞌ ri Qui-Rey ri israelitas? Y ri Jesús xuꞌej cha: Atreꞌ ncaꞌeꞌn, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y ri principales sacerdotes qꞌuiy ri niquiꞌej-apa cha ri Pilato, chi niquiꞌan-apa acusar ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Y ri Pilato xucꞌutuj chic cha ri Jesús y xuꞌej cha: ¿Man jun tzij naꞌej? Ijejeꞌ qꞌuiy niquiꞌej-pa chavij chi ncatquiꞌan acusar, xchaꞌ ri Pilato cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ri Jesús man jun tzij ri xuꞌej. Rumareꞌ ri Pilato can xchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y juna-junaꞌ antok nalka ri namakꞌej Pascua, ri gobernador nutzokopij-el jun chiquivach ri icꞌo pa cárcel; ja ri nicajoꞌ ri vinak chi ntiel-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y chupan ri tiempo reꞌ, cꞌo pa cárcel jun ache rubꞌinan Barrabás. Junan cꞌo pa cárcel quiqꞌuin nicꞌaj chic rachꞌil ruma xaꞌpalaj chirij ri gobierno y quibꞌanun camic. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ri vinak xquicꞌutuj cha ri gobernador chi tutzokopij-el jun chiquivach ri icꞌo pa cárcel, incheꞌl ri ranun-pa juna-junaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y ri Pilato xuꞌej cꞌa chica: ¿Ntivajoꞌ ixreꞌ chi nitzokopij-el ri I-Rey ixreꞌ ri israelitas? ");
INSERT INTO cakSNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ri Pilato quireꞌ xuꞌej ruma jajaꞌ rataꞌn chi ri principales sacerdotes quiyoꞌn ri Jesús pa rukꞌaꞌ, ruma itziel niquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pero ri principales sacerdotes xaꞌquitakcheꞌj ri vinak, chi tiquiꞌej-apa chi ja ri Barrabás titzokopes-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y ri Pilato xchꞌoꞌ chic jun bꞌay y xucꞌutuj chica: ¿Chica ntivajoꞌ ixreꞌ chi niꞌan cha ri ntiꞌej chi I-Rey ixreꞌ ri israelitas? xchaꞌ jajaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y ri vinak xaꞌchꞌo-apa chic riqꞌuin nojiel quichukꞌaꞌ: ¡Tiꞌan crucificar! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ri Pilato xucꞌutuj chica: ¿Chica ruchꞌoꞌj rubꞌanun? Pero ri vinak man ncaꞌtanieꞌ ta ka. Xa riqꞌuin más quichukꞌaꞌ xquiꞌej-apa: ¡Tiꞌan crucificar! ");
INSERT INTO cakSNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato chi otz nitzꞌiet cuma ri vinak, mareꞌ xutzokopij-el ri Barrabás; y xutak ruchꞌayic ri Jesús, después xujach-el chi tiquimisas choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Y ri soldados xquicusaj-apa ri Jesús chojay richin ri palacio; y xaꞌcayuoj quinojiel ri nicꞌaj chic soldados. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y ri soldados reꞌ xquiyaꞌ jun tziak morado chirij ri Jesús. Y xquiyaꞌ pa rujaluon jun corona ri pachꞌun cha jun kꞌayis ri altíra ruqꞌuixal. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Y niquiꞌan cha chi cꞌo rukꞌij y niquiꞌej cha: ¡Caquicuot, atreꞌ ri Qui-Rey ri israelitas! ");
INSERT INTO cakSNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Y niquibꞌuj rujaluon cha jun aj y niquichubꞌaj. Can ncaꞌxuquieꞌ jeꞌ choch, incheꞌl can niquiyaꞌ rukꞌij niquiꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y antok ijejeꞌ xaꞌtanie-ka chi ncaꞌtzeꞌn chirij, xquilasaj-el ri tziak morado ri quiyoꞌn ijejeꞌ chirij, y xquiya-el ri rutziak jajaꞌ, y xquilasaj-el chi niquibꞌajij choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Antok i-bꞌanak pa bꞌay, xquicꞌul jun ache aj-Cirene, ri patanak pan avan. Ri ache reꞌ Simón rubꞌeꞌ, quitataꞌ ri Alejandro y ri Rufo. Y ri soldados xquiꞌan cha ri ache reꞌ chi tucꞌuaj ri cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y ri soldados xquicꞌuaj ri Jesús chupan ri lugar rubꞌinan Gólgota. Ri tzij Gólgota nrajoꞌ nuꞌej: Rujaluon Quiminak (Calavera). ");
INSERT INTO cakSNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y antok icꞌo chic chireꞌ, xquiyaꞌ cha ri Jesús vino xaluon riqꞌuin ruyaꞌl mirra. Pero jajaꞌ man xrajoꞌ ta xukun. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y antok ri soldados quibꞌajin chic ri Jesús choch ri cruz, xquilasaj suerte chirij ri rutziak chi niquitzꞌat chica tziak ri niquicꞌuaj chiquijunal. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve ri macꞌajan antok xquibꞌajij ri Jesús choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y paroꞌ ri cruz, xquiyaꞌ jun letrero ri nuꞌej karruma niquimisas. Choch ri letrero reꞌ nuꞌej: RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Icꞌo jeꞌ icaꞌyeꞌ alakꞌomaꞌ ri xaꞌbꞌajix choch cruz riqꞌuin ri Jesús. Jun xyoꞌx pa ru-derecha y ri jun chic pa ru-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riqꞌuin reꞌ nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, ri nuꞌej: Jajaꞌ can jun aj-bꞌanoy-chꞌoꞌj xꞌan cha. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri vinak ri ncaꞌkꞌax ri pacheꞌ cꞌo-ve ri Jesús niquisiluoj can quijaluon choch, y cꞌo tzij ri man otz ta ri ncaꞌquiꞌej can cha. Ri vinak reꞌ niquiꞌej cha ri Jesús: ¡Ah! Atreꞌ xaꞌej chi navulij ri ru-templo ri Dios y chi oxeꞌ kꞌij napabꞌaꞌ chic jun bꞌay, ");
INSERT INTO cakSNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","tacalo-aviꞌ ayuon y caka-pa choch ri cruz, ncaꞌchaꞌ can cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y quireꞌ jeꞌ niquiꞌan ri principales sacerdotes y ri achiꞌaꞌ escribas, ijejeꞌ altíra ncaꞌtzeꞌn-apa chirij ri Jesús y niquiꞌej chiquivach: Jajaꞌ can iqꞌuiy xaꞌrucol, pero jajaꞌ man nitiquir ta nucol-riꞌ ruyuon. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Xa jajaꞌ ri Cristo, ri Qui-Rey ri israelitas, tika-pa choch ri cruz vacame cꞌa, chi quireꞌ nakatzꞌat y nakanimaj, ncaꞌchaꞌ chiquivach. Y quireꞌ jeꞌ ri alakꞌomaꞌ ri i-bꞌajin choch qui-cruz riqꞌuin ri Jesús, can cꞌo tzij ri man otz ta ri ncaꞌquiꞌej-apa cha. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y pa nicꞌaj-kꞌij, nojiel ri roch-ulief xuꞌon kꞌakuꞌn. Y ri kꞌakuꞌn reꞌ xqꞌuis-el hasta cꞌa a las tres ri nakakꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y a las tres, ri Jesús xurak ruchiꞌ y xuꞌej: Eloi, Eloi, ¿lama sabactani? xchaꞌ. Y ri tzij reꞌ quireꞌ nuꞌej: Nu-Dios, Nu-Dios, ¿karruma xinayaꞌ can? ");
INSERT INTO cakSNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y icꞌo jujun ri icꞌo-apa cierca ri Jesús, antok xcaꞌxaj ri xuꞌej, ja xquiꞌej: Tivaxaj, ja ri Elías ri nrayuoj, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y cꞌo jun ri jun-anin xbꞌarumubꞌa-pa jun esponja chupan vinagre, y xuyaꞌ ri esponja chutzaꞌn jun aj, chi xuyaꞌ cha ri Jesús chi nutzꞌuꞌ, y xuꞌej: Kayoꞌiej, katzꞌataꞌ xa nalka ri Elías chi nukasaj-pa, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Pero ri Jesús xurak ruchiꞌ y ja xcon-ka. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y ri tziak ri choj cha jachuon-ve rupan ri templo xkꞌachꞌitaj pa nicꞌaj, cꞌa paroꞌ cꞌa chuxieꞌ ka. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Y ri capitán ri paꞌl-apa choch ri cruz ri pacheꞌ cꞌo-ve ri Jesús, antok xutzꞌat ri Jesús chi xurak ruchiꞌ y ja xcon, cava xuꞌej: Can ketzij chi la ache la, can Rucꞌajuol ri Dios, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y icꞌo jeꞌ nicꞌaj ixokiꞌ ri chi-naj ncaꞌtzuꞌn-apa. Chiquicajol ri ixokiꞌ reꞌ, cꞌo ri María Magdalena, ri María quitieꞌ ri Jacobo ri chꞌuteꞌn y ri José, y ri ixok Salomé. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Antok ri Jesús cꞌa cꞌo Galilea, ri ixokiꞌ reꞌ i-bꞌanak chirij y quilin-pa. Y icꞌo jeꞌ qꞌuiy chic ixokiꞌ ri i-bꞌanak chirij ri Jesús hasta cꞌa Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Antok xkakꞌij-ka (después ri a las tres), ri vinak niquichojmij cꞌa nojiel ri xticꞌatzin chica chupan ri kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jareꞌ antok xalka ri José ri aj-Arimatea. Jajaꞌ jun chiquivach ri achiꞌaꞌ ri autoridades quichin ri israelitas y utzulaj ache. Jajaꞌ royoꞌien jeꞌ ri ru-reino ri Dios. Y jajaꞌ xuoc riqꞌuin ri Pilato, y man jun chic xibꞌinreꞌl choch xucꞌutuj ri ru-cuerpo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pero ri Pilato can xchapataj chi chaꞌnin yan xcon ri Jesús. Rumareꞌ jajaꞌ xrayuoj ri capitán, y xucꞌutuj cha xa ketzij chi ya xcon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y antok ri Pilato rataꞌn chic ruma ri xuꞌej ri capitán cha, mareꞌ xuꞌej cꞌa chi tiyoꞌx ri ru-cuerpo ri Jesús cha ri José. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y ri José xulokꞌ jun tziak nem. Y antok rukasan chic pa ri ru-cuerpo ri Jesús choch ri cruz, xubꞌol cꞌa chupan ri tziak reꞌ. Y chupan jun jul ri cꞌatuon choch jun nem abꞌaj xbꞌaruya-ve ri ru-cuerpo ri Jesús. Jajaꞌ xutzꞌapij can ri ruchiꞌ ri jul cha jun nem abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ri María Magdalena y ri María ri rutieꞌ ri José, xquitzꞌat pacheꞌ xyoꞌx-ve can ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y antok kꞌaxnak chic ri kꞌij richin uxlanien, ri María Magdalena, ri María ri rutieꞌ ri Jacobo, y ri ixok Salomé rubꞌeꞌ, xquilokꞌ jubꞌul tak akꞌuon chi niquiyaꞌ chirij ri ru-cuerpo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Y macꞌajan yan ri naꞌay kꞌij richin ri semana, xaꞌa cꞌa chuchiꞌ ri jul. Y ya xiel-pa ri kꞌij antok xaꞌbꞌaka. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y ijejeꞌ niquiꞌej chiquivach: ¿Chica xtalasan-el ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero antok xquitzꞌat ri jul, xquitzꞌat chi ri nem abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, xa alasan-el. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y antok ijejeꞌ xaꞌuoc chupan ri jul, xquitzꞌat jun alaꞌ tzꞌuyul chireꞌ ri lado derecha, rucusan jun tziak sak ri nika-ka cꞌa chukul rakan. Y ri ixokiꞌ xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero jajaꞌ xuꞌej chica: Man tixiꞌij-iviꞌ. Ixreꞌ nticanuj ri Jesús ri aj-Nazaret, ri xquimisas choch ri cruz. Jajaꞌ ya xcꞌastaj-el, man cꞌo ta chic vaveꞌ. Titzꞌataꞌ ri lugar pacheꞌ xyoꞌx-ve. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Vacame cꞌa quixꞌin y tiꞌej cha ri Pedro y chica ri nicꞌaj chic ru-discípulos, chi jajaꞌ niꞌa naꞌay chivach cꞌa Galilea; chireꞌ xtitzꞌat-ve, can incheꞌl ri ruꞌeꞌn can chiva. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y ri ixokiꞌ reꞌ xaꞌiel-pa anin chupan ri jul y xaꞌa anin; ijejeꞌ ncaꞌbꞌarbꞌuot ruma altíra quixiꞌin-quiꞌ. Ijejeꞌ man jun choj cha xquitzijuoj-ve, ruma quixiꞌin-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Antok ri Jesús xcꞌastaj-pa chiquicajol ri quiminakiꞌ ri macꞌajan ri naꞌay kꞌij richin ri semana, naꞌay xucꞌut-riꞌ choch ri María Magdalena; ri ixok ri choj-iqꞌuin xaꞌralasaj-el i-siete (ivukuꞌ) itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y ri María Magdalena xꞌa chi xbꞌaruꞌej chica quinojiel ri xaꞌcꞌujieꞌ riqꞌuin ri Jesús. Ijejeꞌ altíra ncaꞌbꞌisuon y ncaꞌuokꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ijejeꞌ antok xcaꞌxaj chi ri Jesús ya xcꞌastaj-pa chiquicajol ri quiminakiꞌ y chi ri María Magdalena xutzꞌat yan, xa man xquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Después ri Jesús xucꞌut-riꞌ chiquivach icaꞌyeꞌ ru-discípulos ri quitzꞌamuon bꞌay chi ncaꞌa jun chic lugar. Pero ri Jesús jun-ve chic nitzuꞌn antok xucꞌut-riꞌ chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri icaꞌyeꞌ reꞌ xbꞌaquiꞌej chica ri nicꞌaj chic discípulos, pero man xaꞌquinimaj ta jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pa ruqꞌuisbꞌal ri Jesús xucꞌut-riꞌ chiquivach ri once (julajuj) ru-discípulos antok ncaꞌvaꞌ. Jajaꞌ xuꞌej chica: ¿Karruma ixreꞌ man xinimaj ta y cof xiꞌan cha ri ivánima? Quireꞌ xuꞌej chica ruma ri discípulos man xquinimaj ta quitzij ri xaꞌtzꞌato ri Jesús, chi ya xcꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xuꞌej chica: Quixꞌin cꞌa choch nojiel ri ulief y titzijuoj ri evangelio chica quinojiel vinak. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri nunimaj y xtiꞌan bautizar, xticolotaj. Pero ri man xtunimaj ta, xtika ri castigo paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y ri xcaꞌniman vichin, can qꞌuiy kax xcaꞌtiquir xtiquiꞌan y reꞌ señal chi incꞌo quiqꞌuin. Pa nubꞌeꞌ inreꞌ xcaꞌquilasaj itziel tak espíritus y xcaꞌchꞌoꞌ nicꞌaj chic chꞌabꞌal ri man cꞌutun ta chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Xcaꞌquitzꞌom cumatz, y xa xtiquikun vaniena, man jun kax xtuꞌon chica. Xtiquiyaꞌ quikꞌaꞌ pa quiveꞌ ri ncaꞌyavaj y xcaꞌquiꞌan sanar, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Antok ri Ajaf Jesús chꞌovinak chic can chica ri ru-discípulos, después xꞌa, y xꞌan recibir chicaj ruma ri Dios, y xtzꞌuyeꞌ pa ru-derecha. ");
INSERT INTO cakSNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y ri discípulos xaꞌa cꞌa nojiel lugar chi xquitzijuoj ri ruchꞌabꞌal ri Dios. Y ri Ajaf can cꞌo quiqꞌuin chi ncaꞌrutoꞌ, y can xuꞌon chica chi qꞌuiy milagros ri xaꞌtiquir xaꞌquiꞌan chi tikꞌalajin chi ja ri ketzij ri niquitzijuoj. Amén.");
INSERT INTO cakSNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Iqꞌuiy quitijuon yan quikꞌij chi niquinucꞌ ruchiꞌ niquitzꞌibꞌaj ri kax ri xaꞌbꞌanataj chikacajol. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y can incheꞌl ri xtzijos chika cuma ri xaꞌtzꞌato-pa pa rutzꞌucbꞌal, can quireꞌ xtzꞌibꞌas. Y ri xaꞌtzꞌato ri xaꞌbꞌanataj, can xquitzijuoj jeꞌ ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y inreꞌ jeꞌ nivajoꞌ nitzꞌibꞌaj ri xaꞌbꞌanataj. Can xintej nukꞌij xinnucꞌ ruchiꞌ nojiel ri xaꞌbꞌanataj. Y jareꞌ ri nivajoꞌ nitzꞌibꞌaj chava atreꞌ namalaj Teófilo. Can chijujun-chijujun nitzꞌibꞌaj ri xaꞌbꞌanataj desde pa rutzꞌucbꞌal hasta cꞌa pa ruqꞌuisbꞌal, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chi quireꞌ nanaꞌiej otz chi ketzij ri cꞌutun chavach chirij ri Jesucristo. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chireꞌ Judea xcꞌujieꞌ jun sacerdote rubꞌinan Zacarías, y jajaꞌ xcꞌujieꞌ quiqꞌuin ri jun grupo sacerdotes ri Abías rubꞌeꞌ. Pa ru-tiempo ri Zacarías ja ri Herodes ri rey chupan ri Judea. Ri raxjayil ri Zacarías, Elisabet rubꞌeꞌ. Ri Elisabet reꞌ jun rumáma can ri sacerdote ri más cꞌo rukꞌij ri Aarón rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri icaꞌyeꞌ reꞌ can choj quicꞌaslien choch ri Dios. Ijejeꞌ can niquiꞌan ri nuꞌej ri ru-mandamientos y ri ru-leyes ri Ajaf Dios. Y man jun vinak nichꞌoꞌ itziel chiquij, ruma ijejeꞌ otz ri niquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ijejeꞌ man jun calcꞌual, ruma ri Elisabet manak ruxuluꞌ alaxnak. Y ri icaꞌyeꞌ cꞌo chic qꞌuiy quijunaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Y antok ri Zacarías y ri nicꞌaj chic sacerdotes ri niꞌeꞌx Abías chica, ja xalka qui-turno chi ncaꞌsamaj pa rachuoch ri Dios, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","paroꞌ ri Zacarías xka-ve chi jajaꞌ ntuoc chupan ri Lugar Santo chi nuparuoj ri incienso (puon), ruma ri qui-costumbre ri sacerdotes niquiꞌan sorteo. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y antok nuparuoj ri incienso (puon), quinojiel ri vinak ri quimaluon-apa-quiꞌ juviera niquiꞌan orar. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Y antok ri Zacarías nuparuoj ri incienso (puon), jun ángel richin ri Ajaf xucꞌut-riꞌ choch. Y ri ángel reꞌ xpiꞌieꞌ lado derecha ri altar ri pacheꞌ niparox-ve ri incienso (puon). ");
INSERT INTO cakSNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Antok ri Zacarías xutzꞌat ri ángel reꞌ, xsach runoꞌj y xpa xibꞌinreꞌl chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ri ángel xuꞌej cha ri Zacarías: Man taxiꞌij-aviꞌ. Ri Dios xraꞌxaj ri av-oración. Ri Elisabet ri avaxjayil xticꞌujieꞌ jun ruxuluꞌ, y Juan ri rubꞌeꞌ ri xtayaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Y can xcaquicuot y iqꞌuiy vinak jeꞌ xcaꞌquicuot ruma xtalax; ");
INSERT INTO cakSNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ruma xticꞌujieꞌ nem rukꞌij choch ri Dios. Man xtukun ta vino, ni nicꞌaj chic roch avarienta, ruma antok xtalax, nojnak chic pa ránima riqꞌuin ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y xtuꞌon chica iqꞌuiy avanakil israelitas chi xtiquinimaj ri Ajaf Dios y xticꞌaxtaj quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jajaꞌ ri xtiꞌa choch ri Ajaf Dios, y xticꞌujieꞌ ri Espíritu Santo riqꞌuin y xticꞌujieꞌ riqꞌuin ri poder, ri incheꞌl xcꞌujieꞌ riqꞌuin ri Elías, ri jun profeta ri xcꞌujieꞌ ojier can tiempo. Ri Juan xtuꞌon chica ri tataꞌj chi xcaꞌcajoꞌ ri calcꞌual, y xtuꞌon chica ri man ncaꞌniman ta tzij chi xtiquicꞌuaj jun choj cꞌaslien, incheꞌl quicꞌuan ri vinak ri choj quicꞌaslien choch ri Dios. Quireꞌ xtuꞌon ri Juan chica ri vinak, chi quireꞌ joꞌc chic niquiyoꞌiej-apa ri Ajaf Dios, xchaꞌ ri ángel cha ri Zacarías. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y ri Zacarías xucꞌutuj cha ri ángel: ¿Cheꞌl xtinaꞌiej inreꞌ chi ketzij ri naꞌej? Ruma inreꞌ in mámix chic y ri vaxjayil xa aviela chic, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y jareꞌ antok ri ángel xuꞌej cha: Inreꞌ Gabriel nubꞌeꞌ, ri incꞌo choch ri Dios. Rumareꞌ xirutak-pa aviqꞌuin chi nalꞌej-ka ri utzulaj tzij chava. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y ruma man xanimaj ta ri xinꞌej chava, xcacꞌujieꞌ can miem; hasta cꞌa xtalax-na ri avalcꞌual, cꞌajareꞌ xcachꞌoꞌ chic jun bꞌay. Nojiel reꞌ xtibꞌanataj-na-ve antok xtalka ri tiempo, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Antok ri Zacarías nitzijuon riqꞌuin ri ángel, ri vinak ri quiyoꞌien-apa juviera xquiꞌan extrañar ruma man ntiel ta pa chupan ri Lugar Santo. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y antok ri Zacarías xbꞌaꞌiel-pa, man nichꞌoꞌ ta chic; mareꞌ ri quiyoꞌien-apa xquinaꞌiej chi cꞌo ri xꞌeꞌx-pa cha chupan ri Lugar Santo. Ri Zacarías xa cha rukꞌaꞌ nuꞌon-ve señas chica, ruma xcꞌujieꞌ can miem. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y antok jajaꞌ xuqꞌuis can ri ru-turno chi nisamaj chireꞌ pa rachuoch ri Dios, xꞌa chirachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Y después ri quireꞌ tibꞌanataj, jareꞌ antok ri Elisabet ri raxjayil xcꞌujie-ka encinta (embarazada), y rumareꞌ man xiel ta pa bꞌay vuꞌuoꞌ icꞌ. Y ri Elisabet nuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Vacame ri Ajaf Dios quireꞌ nuꞌon chuva, chi man xquiqꞌuix ta chic chiquivach ri vinak ri nquinquiyokꞌ ruma manak val. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Y antok ri Elisabet rucꞌuan vakiꞌ icꞌ encinta (embarazada), jareꞌ antok ri Dios xutak ri ángel Gabriel chupan jun tanamet ri cꞌo Galilea rubꞌinan Nazaret, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","riqꞌuin jun xtan María rubꞌeꞌ, ri ni jun choj-iqꞌuin varnak-ve. Ri xtan reꞌ cꞌutun chic chi nicꞌulieꞌ riqꞌuin jun alaꞌ rubꞌinan José. Y ri José reꞌ rumáma can ri rey David. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel xuoc-pa ri pacheꞌ cꞌo-ve ri xtan, y xuꞌej cha: ¡Tiquicuot avánima, ruma ri Dios pan aveꞌ atreꞌ xuya-ve ru-bendición! Ri Ajaf can cꞌo aviqꞌuin. Y chiquivach quinojiel xtaniꞌ y ixokiꞌ, atreꞌ ri más bendición xyoꞌx chava. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y antok ri María xutzꞌat ri ángel y xraꞌxaj ri xuꞌej cha, can xsach runoꞌj y xuꞌon-ka pensar karruma quireꞌ xꞌan saludar. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Entonces ri ángel xuꞌej cha: María, man taxiꞌij-aviꞌ, ruma atreꞌ xaꞌan recibir ri ru-favor ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Vacame niꞌej can chava chi xcacꞌujieꞌ cꞌa encinta (embarazada), y antok xtalax ri xuluꞌ, alaꞌ y JESUS ri rubꞌeꞌ ri xtayaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jajaꞌ cꞌo rukꞌij xticꞌujieꞌ, y xtubꞌinaj Ralcꞌual ri Namalaj Dios. Ri Jesús jun rumáma can ri rey David, y ri Ajaf Dios can jajaꞌ cꞌa ri xtuyaꞌ pa ru-trono ri rey David ri xcꞌujieꞌ ojier can, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chi quireꞌ xtuꞌon reinar richin nojiel tiempo pan iveꞌ ixreꞌ ri ix rumáma can ri Jacob. Y ri ru-reino man xtiqꞌuis ta, xchaꞌ ri ángel cha ri María. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y ri María xucꞌutuj cha ri ángel: ¿Chica cꞌa modo antok xticꞌujieꞌ nuxuluꞌ? Ruma inreꞌ xa ni jun choj-iqꞌuin in-varnak-ve, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y ri ángel xuꞌej cha ri María: Ja ri Espíritu Santo riqꞌuin ri ru-poder ri Namalaj Dios ri xtika-pa pan aveꞌ. Rumareꞌ ri Santo acꞌual ri xtalax aviqꞌuin, can xtubꞌinaj Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tavatamaj cꞌa chi ri Elisabet ri avachꞌalal cꞌo encinta (embarazada), mesque jajaꞌ aviela chic ri niquiꞌej cha chi manak ral alaxnak. Y vacame rucꞌuan vakiꞌ icꞌ encinta (embarazada). ");
INSERT INTO cakSNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ruma ri Dios man jun kax ri man ta nicovin nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Entonces ri María xuꞌej: Ja incꞌo va, in jun ru-sierva ri Ajaf. Can tibꞌanataj cꞌa incheꞌl ri xaꞌej chuva, xchaꞌ ri María cha ri ángel. Y ri ángel xiel-el chireꞌ riqꞌuin ri María y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jun janeꞌ (jaroꞌ) kꞌij después, ri María xuchojmij-el-riꞌ y chaꞌnin xꞌa pa jun tanamet ri cꞌo paroꞌ jun juyuꞌ richin ri Judá. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y antok xbꞌaka chireꞌ pa tanamet, jajaꞌ xꞌa chicachuoch ri Zacarías y ri Elisabet y xuꞌon saludar ri Elisabet. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Antok ri Elisabet xraꞌxaj ri ru-saludo ri María, can xsiluon ri ral xunaꞌ. Y ri Elisabet xnuoj ránima riqꞌuin ri Espíritu Santo, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","y rumareꞌ cof xchꞌoꞌ, y xuꞌej: Chikacajol ojreꞌ ri oj xtaniꞌ y ixokiꞌ, atreꞌ ri más bendición xyoꞌx chava, y quireꞌ jeꞌ ri bendición cꞌo paroꞌ ri aval ri xtalax aviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿In chica ta cꞌa inreꞌ, chi xapa vaveꞌ viqꞌuin y nquinaꞌan saludar, atreꞌ ri at rutieꞌ ri Vajaf? ");
INSERT INTO cakSNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ruma antok xinvaꞌxaj chi xinaꞌan saludar, can xinnaꞌ chi ri nuxuluꞌ can xsiluon ruma xquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Can jaꞌal caquicuot ruma xanimaj ri xuꞌej ri Ajaf chava; ruma can xtuꞌon cumplir ri xuꞌej chava chi xtalax ri acꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y ri María xuꞌej: Inreꞌ riqꞌuin nojiel vánima niyaꞌ rukꞌij ri Ajaf. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri nu-espíritu niquicuot riqꞌuin ri Dios ri Nu-Salvador (caloy-vichin). ");
INSERT INTO cakSNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ruma ri Dios xiruchaꞌ inreꞌ ri man jun oc vakalien, xa in jun ru-sierva. Y desde vacame, ri vinak xtiquiꞌej chi can jaꞌal nquiquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ruma qꞌuiy nimaꞌk tak kax ri rubꞌanun-pa chuva, ri nitiquir nuꞌon nojiel. Y ri rubꞌeꞌ jajaꞌ can Santo. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Jajaꞌ siempre nujoyovaj quivach quinojiel vinak ri ncaꞌkꞌax-el choch-ulief, ri niquinimaj rutzij y niquiyaꞌ jeꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Can qꞌuiy nimaꞌk tak kax i-rubꞌanun riqꞌuin ri ru-poder. Jajaꞌ rukasan quikꞌij ri niquiꞌej pa tak cánima chi cꞌo quikꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I-rukasan nimaꞌk tak gobernadores, y xuꞌon nem chica ri man jun oc quikalien. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri ncaꞌvijan, can xuyaꞌ nojiel ri nicꞌatzin chica; pero ri bꞌayomaꞌ xa choj quireꞌ xaꞌrutak-el, man jun xuya-el chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Jajaꞌ oj-rutoꞌn cꞌa ri oj israelitas ri oj-ruchoꞌn chi nakaꞌan ri rusamaj. Man oj-rumastan ta can y rujoyovan kavach. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Incheꞌl ri ruꞌeꞌn chica ri kateꞌt-kamamaꞌ ojier can, ri ruꞌeꞌn cha ri Abraham y chika ojreꞌ ri oj rumáma can jajaꞌ. Ri Dios man jun bꞌay xtumastaj ri ruꞌeꞌn. Quireꞌ xuꞌej ri María. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María xcꞌujie-ka jun laꞌk oxeꞌ icꞌ riqꞌuin ri Elisabet, y después xtzalaj chirachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Antok xalka ri kꞌij chi nalax ri ruxuluꞌ ri Elisabet, ja xcꞌujieꞌ jun alaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y antok ri iru-vacínix ri Elisabet y ri rachꞌalal xcaꞌxaj chi jun namalaj favor ri xuꞌon ri Dios riqꞌuin chi xcꞌujieꞌ jun ral, can xaꞌquicuot riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y ijejeꞌ xaꞌlka chic riqꞌuin ri Elisabet antok xtzꞌakat ocho (vakxakiꞌ) kꞌij talax ri xuluꞌ, ri kꞌij chi niꞌan ri circuncisión cha. Y ri vinak reꞌ xcajoꞌ ta xquiyaꞌ rubꞌeꞌ ri xuluꞌ incheꞌl rubꞌeꞌ ri rutataꞌ, y xubꞌinaj ta Zacarías. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero ri rutieꞌ xuꞌej: Man xtubꞌinaj ta incheꞌl rubꞌeꞌ ri rutataꞌ; xa xtubꞌinaj Juan. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ri icꞌo riqꞌuin ri Elisabet xquiꞌej cha: ¿Karruma Juan navajoꞌ naꞌan cha ri rubꞌeꞌ? Ruma chupan ri a-familia man jun quireꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Entonces cha señas xquicꞌutuj cha ri Zacarías, rutataꞌ ri xuluꞌ, chi chica rubꞌeꞌ nrajoꞌ nuyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri rutataꞌ ri xuluꞌ xucꞌutuj jun chꞌiti tabla y xutzꞌibꞌaj choch: Ri xuluꞌ xtubꞌinaj Juan. Y quinojiel ri quimaluon-apa-quiꞌ xaꞌchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Y jareꞌ antok xchꞌoꞌ chic jun bꞌay ri Zacarías. Y can joꞌc xchꞌoꞌ, can ja xuyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y ri qui-vacínix xquixiꞌij-quiꞌ ruma ri xbꞌanataj chireꞌ. Y ri xbꞌanataj, xꞌa rutzijoxic pa tak juyuꞌ richin ri Judea. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y quinojiel ri ncaꞌcꞌaxan ri xbꞌanataj quiqꞌuin ri Zacarías y ri Elisabet, niquiyac pa tak cánima ri nitzijos chica, y niquiꞌej: ¿Chica came xtirubꞌanaꞌ ri acꞌual reꞌ? ncaꞌchaꞌ. Ruma kꞌalaj chi cꞌo ri Ajaf Dios riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Y ri Zacarías, ri rutataꞌ ri xuluꞌ, nojnak ránima riqꞌuin ri Espíritu Santo, mareꞌ nuꞌej ri chica xtibꞌanataj ri más chila-apa y xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Can tiyoꞌx rukꞌij ri Ajaf Dios kichin ojreꞌ ri aj-Israel, ruma nkojrunataj-pa ojreꞌ ri oj rutanamit, y nkojrucol. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ri Dios nuya-pa chika jun Namalaj Ka-Salvador (caloy-kichin). Y reꞌ jun rumáma can ri David, ri jun ka-rey ri xcꞌujieꞌ ojier can y rusamajiel ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri Dios xꞌeꞌn chica ri santos profetas ri xaꞌcꞌujieꞌ ojier can tiempo, chi tiquiꞌej chi xtuyaꞌ Jun ri xticalo kichin. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Can ruꞌeꞌn-ve-pa chi xkojrucol chiquivach ri itziel ncaꞌtzꞌato kichin, y xkojrucol pa quikꞌaꞌ ri man nkojcajoꞌ ta, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y ruꞌeꞌn chi nujoyovaj quivach ri kateꞌt-kamamaꞌ ri xaꞌcꞌujieꞌ ojier can, y can nuꞌon ri xuꞌej antok xuꞌon ri santo pacto. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Can xuꞌon jurar cha ri kamamaꞌ Abraham chi nuꞌon cumplir, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chi xkojrucol pa quikꞌaꞌ ri itziel ncaꞌtzꞌato kichin, chi quireꞌ man xtakaxiꞌij ta kiꞌ nakaꞌan servir ");
INSERT INTO cakSNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","riqꞌuin jun choj y sak cꞌaslien choch ri Dios, ri kꞌij ri nkojcꞌasie-el vaveꞌ ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y atreꞌ chꞌiti acꞌual, xtiꞌeꞌx chava chi at jun profeta richin ri Namalaj Dios, ruma atreꞌ xcaꞌa naꞌay choch ri Ajaf chi nachojmij ri rubꞌiey, ");
INSERT INTO cakSNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y atreꞌ ri xcaꞌeꞌn chi ri Dios nuꞌon perdonar ri qui-pecados ri rutanamit chi ncaꞌcolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y reꞌ, xa ruma ri Ka-Dios nujoyovaj kavach y riqꞌuin nojiel ránima nkojrajoꞌ. Rumareꞌ nutak-pa ri Jun ri nalruyaꞌ sakil chika, ri incheꞌl ri kꞌij xtuꞌon chikacajol antok xtika-pa chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ri Jun ri nalruyaꞌ sakil, xtuyaꞌ sakil chica ri icꞌo pa kꞌakuꞌn y ri icꞌo pa rumuchꞌuchꞌil ri camic, y xkojrucꞌuaj chupan ri bꞌay richin paz. ");
INSERT INTO cakSNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y ri acꞌual ri xalax quiqꞌuin ri Elisabet y ri Zacarías, niqꞌuiy y quireꞌ nicꞌujieꞌ ruchukꞌaꞌ ri ru-espíritu. Y pa tak lugares desiertos xcꞌujie-ve, cꞌa xalka-na ri kꞌij chi xutzijuoj ri ruchꞌabꞌal ri Dios chiquivach ri aj-Israel ri ruvanakil. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Y chupan ri tiempo reꞌ, ri Augusto César ri emperador xuꞌon mandar chi quinojiel vinak tiquibꞌanaꞌ empadronar-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Antok xꞌan ri naꞌay censo reꞌ, ri gobernador chupan ri nación Siria ja ri Cirenio. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y ri vinak ri icꞌo chupan ri nación Israel ncaꞌa chi ncaꞌan empadronar pa tak quitanamit ri cateꞌt-quimamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y ri José xiel-el ri pa tanamet Nazaret, ri cꞌo chupan Galilea, y xꞌa cꞌa pa rutanamit ri rey David, ri niꞌeꞌx Belén cha, ri cꞌo chupan Judea, ruma jajaꞌ rumáma can ri rey David. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ri José richꞌilan ri María, ri xtan ri rucꞌutun chi nicꞌulieꞌ riqꞌuin, xaꞌa cꞌa Belén chi xiꞌquinaꞌ empadronar-quiꞌ. Y ri María cꞌo chic encinta (embarazada). ");
INSERT INTO cakSNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y cꞌa chireꞌ pa tanamet Belén icꞌo-ve antok ri María xtzꞌakat ri rukꞌij chi nalax ri ruxuluꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Y ja xalax ri naꞌay ral-alaꞌ, y jaꞌal xumutz ri xuluꞌ pa tziak, y xucotzꞌobꞌaꞌ pacheꞌ niyoꞌx-ve quivay ri avaj, ruma manak chic lugar chupan ri posada. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Cierca ri Belén ri akꞌaꞌ reꞌ, icꞌo ri ncaꞌquichajij qui-ovejas pa kꞌayis. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Jareꞌ antok xucꞌut-riꞌ chiquivach jun ángel ri patanak chicaj riqꞌuin ri Ajaf. Y ijejeꞌ altíra xquixiꞌij-quiꞌ ruma ri ángel, y ruma jeꞌ ri rusakil ri Ajaf ri xuꞌon pakꞌij quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xuꞌej chica: Man tixiꞌij-iviꞌ, ruma inreꞌ cꞌo utzulaj tak tzij nucꞌamun-pa chiva, y ri utzulaj tak tzij reꞌ quichin quinojiel vinak ri icꞌo choch-ulief chi xcaꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tivaxaj ri xtinꞌej chiva: Chireꞌ Belén, ri rutanamit ri rey David, vacame xalax ri Salvador (caloy-quichin ri vinak), ri CRISTO, ri Ajaf. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri ratal ri xuluꞌ reꞌ ri xtivil, xtitzꞌat chi mutzun pa tziak y cotzꞌobꞌan pacheꞌ niyoꞌx-ve quivay ri avaj, xchaꞌ ri ángel. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Y jun arapienta xaꞌbꞌaꞌiel chic pa riqꞌuin ri ángel nicꞌaj chic ángeles ri i-patanak chicaj. Can iqꞌuiy. Y ijejeꞌ niquiyaꞌ rukꞌij ri Dios, y niquiꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Altíra niyoꞌx rukꞌij ri Dios chicaj! ¡Y vaveꞌ choch-ulief xalka ri paz chiquicajol ri vinak, ruma ri Dios altíra ncaꞌrajoꞌ! ");
INSERT INTO cakSNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Y joꞌc quireꞌ xquiꞌej can ri ángeles, ja xaꞌa chicaj. Y can joꞌc xaꞌa ri ángeles reꞌ, ri quichajin qui-ovejas ja xquiꞌej-ka chiquivach: Joꞌ pa tanamet Belén. Joꞌ chutzꞌatic ri xbꞌanataj. Ruma ri Ajaf Dios xutak-pa ri rubꞌixic chika. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y jun-anin xaꞌa pa tanamet chi niquitzꞌataꞌ, y xaꞌbꞌaquilaꞌ ri María, ri José y ri acꞌual cotzꞌobꞌan pacheꞌ niyoꞌx-ve quivay ri avaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Antok xquitzꞌat ri acꞌual, ja xquitzꞌom rutzijoxic ri xꞌeꞌx chica ruma ri ángel, chirij ri acꞌual reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y quinojiel ri ncaꞌcꞌaxan quichin, can xaꞌchapataj ruma ri utzulaj tak tzij ri niquitzijuoj ri ncaꞌchajin ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y ri María can xaꞌruyac cꞌa pa ránima nojiel ri tzij reꞌ, y nuꞌon jeꞌ pensar chirij ri tzij reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Y ri ncaꞌchajin ovejas xaꞌtzalaj chiquij niquiꞌan nem cha ri rubꞌeꞌ ri Dios, y niquiyaꞌ jeꞌ rukꞌij ruma nojiel ri xquitzꞌat y xcaꞌxaj, can xbꞌanataj incheꞌl ri xuꞌej can ri ángel. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Antok xtzꞌakat ocho (vakxakiꞌ) kꞌij talax ri acꞌual, xꞌan ri circuncisión cha, y JESUS ri rubꞌeꞌ ri xquiyaꞌ, ruma ja bꞌiꞌaj reꞌ ri xuꞌej can ri ángel cha ri María, antok cꞌa majaꞌ cꞌo encinta (embarazada). ");
INSERT INTO cakSNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y antok xtzꞌakat ri kꞌij incheꞌl nuꞌej ri ru-ley ri Moisés chi ri ixokiꞌ ri nicꞌujieꞌ cal niquiꞌan purificar-quiꞌ, ri María y ri José xquicꞌam-pa ri acꞌual pa tanamet Jerusalén chi niquiꞌan presentar choch ri Ajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quireꞌ xquiꞌan ruma ri ru-ley ri Ajaf Dios nuꞌej: Nojiel naꞌay alaꞌ ri xtalax, can richin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ri José y ri María can xquiꞌan incheꞌl nuꞌej chupan ri ru-ley ri Ajaf Dios. Ijejeꞌ xquiyaꞌ choch ri Dios caꞌyeꞌ paluomix, ruma ri ley nuꞌej: Caꞌyeꞌ paluomix nimaꞌk o caꞌyeꞌ chꞌuteꞌk. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chireꞌ pa tanamet Jerusalén ri tiempo reꞌ, cꞌo jun ache rubꞌinan Simeón. Ri jun ache reꞌ can choj rucꞌaslien y can nuyaꞌ rukꞌij ri Dios. Ri Simeón can cꞌo ri Espíritu Santo riqꞌuin y royoꞌien chi ncaꞌcuol ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y ri Espíritu Santo ruꞌeꞌn chic cha ri Simeón chi man nicon ta yan, cꞌa ja-na cꞌa antok rutzꞌatuon chic can ri Cristo ri xtutak-pa ri Ajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupan ri kꞌij antok ri rutie-rutataꞌ ri xuluꞌ Jesús xquicꞌuaj pa templo chi niquiꞌan incheꞌl ri nuꞌej ri ley, can ja kꞌij reꞌ xalka ri Simeón pa templo, ruma quireꞌ xrajoꞌ ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xukꞌatiej ri xuluꞌ, y richin xuyaꞌ rukꞌij ri Dios xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, vacame cꞌa ri in a-siervo xa can otz chic chi nquicon-el, xa can cꞌo chic paz viqꞌuin, ruma incheꞌl ri aꞌeꞌn chuva, can quireꞌ xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ri nakꞌanoch xquitzꞌat can ri Salvador (caloy-kichin) ri patanak aviqꞌuin, ");
INSERT INTO cakSNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xaya-pa atreꞌ chiquivach quinojiel vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Jajaꞌ jeꞌ ri Luz quichin ri man israelitas ta, ruma jajaꞌ ri xticꞌutu ri abꞌiey chiquivach. Y ojreꞌ ri atanamit Israel can xticꞌujieꞌ kakꞌij ruma jajaꞌ, xchaꞌ ri Simeón. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri José y ri María can xaꞌchapataj antok xcaꞌxaj ri xuꞌej ri Simeón chirij ri xuluꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y después ri Simeón xaꞌruꞌon bendecir ri José y ri María. Antok rubꞌanun chic quireꞌ, xuꞌej cꞌa cha ri María, ri rutieꞌ ri xuluꞌ: Tavaxaj cꞌa, ruma ri xuluꞌ reꞌ, iqꞌuiy chiquivach ri kavanakil israelitas xcaꞌcolotaj. Y iqꞌuiy jeꞌ ri xcaꞌtzak, ruma can itziel xtiquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Can jajaꞌ cꞌa xtibꞌano chi xtikꞌalajin-pa ri itziel ri cꞌo riqꞌuin cánima ri vinak. Y xtanaꞌ cꞌa atreꞌ chi can incheꞌl jun espada ri xtusoc ri avánima, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chireꞌ pa templo cꞌo jeꞌ ri Ana ri profetisa. Jajaꞌ rumiꞌal can jun ache Fanuel rubꞌeꞌ, y rumáma can ri Aser, ri jun ache ri xcꞌujieꞌ ojier can. Ri Ana reꞌ jumul chic aviela. Jajaꞌ cꞌa coꞌl-oc antok xcꞌulieꞌ. Y joꞌc siete (vukuꞌ) junaꞌ xquicꞌuaj-quiꞌ riqꞌuin ri rachajil, ruma xa chaꞌnin xcon-el ri ache choch. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y jajaꞌ malcaꞌn durante ochenta y cuatro junaꞌ, y can kꞌij-kꞌij nicꞌujieꞌ pa templo. Jajaꞌ nuꞌon ayuno y oración chi nuyaꞌ rukꞌij ri Dios, y quireꞌ nuꞌon chi pakꞌij chi chakꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Antok ri Ana xutzꞌat ri xuluꞌ, xꞌa-apa riqꞌuin. Y xuyaꞌ tiox bꞌaꞌ cha ri Dios ruma ri xuluꞌ reꞌ. Y chica ri vinak aj-Jerusalén ri quiyoꞌien chi ncaꞌcuol, xutzꞌom rutzijoxic chirij ri acꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ri José y ri María xquiꞌan nojiel ri nuꞌej ri Ajaf Dios chupan ri ru-ley, ri nicꞌatzin chi niꞌan antok cꞌa jubꞌaꞌ kꞌij talax jun acꞌual. Después xaꞌtzalaj chiquij chicachuoch Nazaret, ri cꞌo chupan Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri acꞌual niqꞌuiy y nicꞌujie-ka ruchukꞌaꞌ bꞌanak. Y nicꞌujieꞌ más runoꞌj, y cꞌo ri ru-favor ri Dios paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri rutie-rutataꞌ ri Jesús, can juna-junaꞌ ncaꞌa pa tanamet Jerusalén antok nalka ri kꞌij richin ri namakꞌej Pascua. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Y antok ri Jesús cꞌo chic doce (cabꞌalajuj) rujunaꞌ y xalka chic jun bꞌay ri namakꞌej Pascua, ijejeꞌ xaꞌa cꞌa pa tanamet Jerusalén, incheꞌl ri costumbre ri niquiꞌan quinojiel ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Antok ya kꞌaxnak chic ri namakꞌej Pascua, ri María y ri José xquitzꞌom bꞌay chi xaꞌtzalaj chiquij chicachuoch, pero ijejeꞌ man cataꞌn ta chi ri acꞌual Jesús xa xcꞌujieꞌ can chireꞌ pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ijejeꞌ xquiꞌan pensar chi ri acꞌual bꞌanak chiquicajol ri vinak, y quireꞌ xaꞌin jun kꞌij y xquicanuj quiqꞌuin ri cachꞌalal y quiqꞌuin jeꞌ ri cataꞌn quivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Pero ruma man xquil ta, ri José y ri María xaꞌtzalaj chic can chi niquicanuj ri acꞌual pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Y kꞌaxnak chic oxeꞌ kꞌij tisach ri acꞌual, ijejeꞌ xquil ri acꞌual pa templo. Ri acꞌual tzꞌuyul-apa quiqꞌuin ri achiꞌaꞌ maestros richin ri ley, nraꞌxaj ri niquiꞌej y cꞌo jeꞌ ri nucꞌutuj-apa chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y quinojiel ri ncaꞌcꞌaxan ri nuꞌej ri acꞌual xaꞌchapataj, ruma jajaꞌ can jaꞌal nitiquir nuyaꞌ respuesta chica. Y can kꞌalaj chi nojiel niꞌka paroꞌ (nuꞌon entender) y cꞌo runoꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chireꞌ pa templo cꞌo-ve ri Jesús antok ri María y ri José xbꞌaquilaꞌ. Ijejeꞌ can xaꞌchapataj. Y ri rutieꞌ xuꞌej cha ri ral: ¿Karruma quireꞌ xaꞌan chika? Tatzꞌataꞌ; la atataꞌ y inreꞌ can at-kacanun-pa. Y can nikꞌaxo chic kánima ruma manak ncatkil. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y jajaꞌ xuꞌej chica: ¿Karruma nquinicanuj? ¿Man ivataꞌn ta cꞌa chi inreꞌ ja ri nrajoꞌ ri Nataꞌ Dios, jareꞌ ri nicꞌatzin chi niꞌan? ");
INSERT INTO cakSNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero ri tzij ri xuꞌej ri acꞌual chica ri José y ri María man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender). ");
INSERT INTO cakSNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Y ri acꞌual xꞌa quiqꞌuin chicachuoch, pa tanamet Nazaret. Ri acꞌual can nunimaj quitzij. Y nojiel ri xbꞌanataj Jerusalén riqꞌuin ri acꞌual, ri rutieꞌ xaꞌruyac cꞌa riqꞌuin ránima. ");
INSERT INTO cakSNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y ri Jesús can niqꞌuiy y can quireꞌ jeꞌ ri runoꞌj. Y jaꞌal nitzꞌiet ruma ri Dios, y jaꞌal jeꞌ nitzꞌiet cuma ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Cꞌo yan quince junaꞌ tuoc-pa rey ri Tiberio César. Y pa rukꞌaꞌ jajaꞌ icꞌo icajeꞌ gobernadores. Jun ja ri Poncio Pilato, y jajaꞌ nuꞌon gobernar ri Judea. Jun ja ri Herodes, y jajaꞌ nuꞌon gobernar ri Galilea. Jun ja ri Felipe ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Herodes, y jajaꞌ nuꞌon gobernar ri Iturea y ri Traconite. Y ri jun chic ja ri Lisanias, y jajaꞌ nuꞌon gobernar ri Abilinia. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y chupan jeꞌ ri tiempo reꞌ, ja ri Anás y ri Caifás ri i-sacerdotes ri más cꞌo quikꞌij chireꞌ Israel. Y ja tiempo reꞌ antok xchꞌoꞌ ri Dios cha ri Juan ri rucꞌajuol ri Zacarías, chupan jun lugar desierto. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y ri Juan xꞌa chupan ri lugares ri icꞌo cierca ri río Jordán. Jajaꞌ nuꞌej chica ri vinak ri ncaꞌbꞌaka riqꞌuin chi titzalaj-pa cánima riqꞌuin ri Dios y tiquibꞌanaꞌ ri nrajoꞌ ri Dios y tiquibꞌanaꞌ bautizar-quiꞌ, chi quireꞌ niꞌan perdonar ri qui-pecados ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y riqꞌuin ri Juan xbꞌanataj-ve ri incheꞌl rutzꞌibꞌan can ri profeta Isaías. Quireꞌ nuꞌej: Cꞌo jun ache ri xticꞌujieꞌ chupan jun lugar desierto, y jajaꞌ xturak cꞌa ruchiꞌ chi xtuꞌej chica ri vinak ri xcaꞌbꞌaka riqꞌuin: Tichojmij-apa rubꞌiey ri Ajaf, y can choj tibꞌanaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Can nicꞌatzin chi xcaꞌnojsas nojiel sivan. Y xcaꞌvulex jeꞌ nojiel juyuꞌ. Ri cotocak tak bꞌay, can choj xtiꞌan chica. Y ri cujcak tak bꞌay, liꞌan xtiꞌan chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y quinojiel vinak xtiquitzꞌat ri nuꞌon ri Dios chi nkojrucol. Quireꞌ nuꞌej chupan ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y antok ri vinak ncaꞌlka riqꞌuin ri Juan chi ncaꞌruꞌon-el bautizar, xuꞌej chica: ¡Ixreꞌ xa ix incheꞌl cumatz! ¿Chica xꞌeꞌn chiva chi nquixcolotaj choch ri castigo ri xtutak-pa ri Dios ri chakavach-apa? ");
INSERT INTO cakSNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ixreꞌ nicꞌatzin nticꞌut chi can ketzij nitzalaj-pa ivánima riqꞌuin ri Dios y ntiꞌan ri nrajoꞌ jajaꞌ. Y man tiꞌan-ka pensar ixreꞌ chi ruma ix rumáma can ri Abraham, rumareꞌ nquixcolotaj, man quireꞌ ta. Inreꞌ niꞌej chiva chi ri Dios nicovin ncaꞌruꞌon rumáma ri Abraham aún chica ri abꞌaj ri icꞌo vaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri castigo ri nuyaꞌ ri Dios ya nipa. Jajaꞌ xtuꞌon incheꞌl nuꞌon jun ache ri cꞌo chic ri icaj pa rukꞌaꞌ chi ncaꞌrukasaj quinojiel ri chieꞌ ri man otz ta quivach niquiyaꞌ, y xcaꞌruyaꞌ pa kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y ri vinak xquicꞌutuj cha ri Juan: ¿Chica nakaꞌan? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y jajaꞌ xuꞌej chica ri xaꞌcꞌutun-apa: Xa cꞌo jun cꞌo caꞌyeꞌ rutziak, tuyaꞌ jun cha ri manak rutziak. Y xa cꞌo jun cꞌo nutej, tuyaꞌ cha ri manak nutej, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y riqꞌuin ri Juan, xalka jeꞌ nicꞌaj achiꞌaꞌ ri i-maloy-impuestos chi ncaꞌan bautizar. Y ri achiꞌaꞌ reꞌ xquicꞌutuj cha ri Juan: Maestro, ¿chica nakaꞌan? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y jajaꞌ xuꞌej chica: Joꞌc ri impuestos ri ruꞌeꞌn ri gobierno, joꞌc reꞌ ticꞌutuj chica ri vinak. Man ticꞌutuj más. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Y nicꞌaj soldados xquicꞌutuj jeꞌ apa cha: Y ojreꞌ, ¿chica nakaꞌan? xaꞌchaꞌ. Ri Juan xuꞌej chica: Man timaj ri kax quichin ri vinak ruma cꞌo autoridad pan ikꞌaꞌ. Ni man tikꞌabꞌaj tzij chiquij ri vinak. Y quixquicuot riqꞌuin ri ntichꞌec, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y ri vinak ri icꞌo-apa riqꞌuin ri Juan, can quiyoꞌien chi nuꞌej ri chica jajaꞌ, ruma ijejeꞌ niquiꞌej pa tak cánima chi ri Juan jareꞌ ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Rumareꞌ ri Juan xuꞌej chica ri vinak: Inreꞌ, yaꞌ ri nicusaj chi nquixꞌan bautizar, pero cꞌo Jun ri xtipa chuvij inreꞌ, ri xquixruꞌon bautizar riqꞌuin ri Espíritu Santo y riqꞌuin kꞌakꞌ. Ri Jun ri xtipa, cꞌo nojiel poder riqꞌuin que chinoch inreꞌ. Y nixta nucꞌul chi inreꞌ niquir ri ximbꞌal-roch ri ruxajabꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ri Jun ri xtipa cꞌo jun incheꞌl horqueta pa rukꞌaꞌ y xtujoskꞌij ri ru-trigo pa ru-lugar. Y xtumol ri runakꞌ ri trigo y xtuyac. Y ri qꞌuin xtuyaꞌ pa kꞌakꞌ ri man nichup ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Qꞌuiy tzij incheꞌl reꞌ xaꞌrucusaj ri Juan chi xutzijuoj ri utzulaj ruchꞌabꞌal ri Dios chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ri Juan xuchꞌolij ri gobernador Herodes, ruma man otz ta rubꞌanun, chi rucꞌamun-ka ri Herodías, ri xa raxjayil ri Felipe ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Herodes. Y xaꞌrunataj jeꞌ nicꞌaj chic ruchꞌoꞌj ri i-rubꞌanun. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y ri Herodes xa xnimar-ka más ruveꞌ ri ruchꞌoꞌj ruma xutzꞌapij ri Juan pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y antok ncaꞌan bautizar iqꞌuiy vinak, xꞌan jeꞌ bautizar ri Jesús, y ri Jesús nuꞌon orar, y ri rocaj xjakataj, ");
INSERT INTO cakSNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y ri Espíritu Santo can xtzꞌiet chi xka-pa paroꞌ, incheꞌl jun paluomix. Y jareꞌ antok cꞌo Jun ri xchꞌo-pa chicaj y xuꞌej: Atreꞌ ri at Nucꞌajuol; altíra ncanvajoꞌ y niquicuot vánima aviqꞌuin. Quireꞌ ri xuꞌej-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Antok ri Jesús xutzꞌom ri rusamaj, cꞌo laꞌk treinta rujunaꞌ. Y chiquivach ri vinak, ri Jesús rucꞌajuol ri José. Ri José rucꞌajuol can ri Elí. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y ri Elí rucꞌajuol can ri Matat, y ri Matat rucꞌajuol can ri Leví, y ri Leví rucꞌajuol can ri Melqui, y ri Melqui rucꞌajuol can ri Jana, y ri Jana rucꞌajuol can jun chic ri José jeꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y ri José rucꞌajuol can ri Matatías, y ri Matatías rucꞌajuol can ri Amós, y ri Amós rucꞌajuol can ri Nahum, y ri Nahum rucꞌajuol can ri Esli, y ri Esli rucꞌajuol can ri Nagai. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y ri Nagai rucꞌajuol can ri Maat, y ri Maat rucꞌajuol can jun chic ri Matatías jeꞌ rubꞌeꞌ, y ri Matatías rucꞌajuol can ri Semei, y ri Semei rucꞌajuol can jun chic ri José jeꞌ rubꞌeꞌ, y ri José rucꞌajuol can ri Judá. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y ri Judá rucꞌajuol can ri Joana, y ri Joana rucꞌajuol can ri Resa, y ri Resa rucꞌajuol can ri Zorobabel, y ri Zorobabel rucꞌajuol can ri Salatiel, y ri Salatiel rucꞌajuol can ri Neri. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y ri Neri rucꞌajuol can jun chic ri Melqui jeꞌ rubꞌeꞌ, y ri Melqui rucꞌajuol can ri Adi, y ri Adi rucꞌajuol can ri Cosam, y ri Cosam rucꞌajuol can ri Elmodam, y ri Elmodam rucꞌajuol can ri Er. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y ri Er rucꞌajuol can ri Josué, y ri Josué rucꞌajuol can ri Eliezer, y ri Eliezer rucꞌajuol can ri Jorim, y ri Jorim rucꞌajuol can jun chic ri Matat jeꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y ri Matat rucꞌajuol can jun chic ri Leví jeꞌ rubꞌeꞌ, y ri Leví rucꞌajuol can ri Simeón, y ri Simeón rucꞌajuol can jun chic ri Judá jeꞌ rubꞌeꞌ, y ri Judá rucꞌajuol can jun chic ri José jeꞌ rubꞌeꞌ, y ri José rucꞌajuol can ri Jonán, y ri Jonán rucꞌajuol can ri Eliaquim. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y ri Eliaquim rucꞌajuol can ri Melea, y ri Melea rucꞌajuol can ri Mainán, y ri Mainán rucꞌajuol can ri Matata, y ri Matata rucꞌajuol can ri Natán. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y ri Natán rucꞌajuol can ri David, y ri David rucꞌajuol can ri Isaí, y ri Isaí rucꞌajuol can ri Obed, y ri Obed rucꞌajuol can ri Booz, y ri Booz rucꞌajuol can ri Salmón, y ri Salmón rucꞌajuol can ri Naasón. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y ri Naasón rucꞌajuol can ri Aminadab, y ri Aminadab rucꞌajuol can ri Aram, y ri Aram rucꞌajuol can ri Esrom, y ri Esrom rucꞌajuol can ri Fares, y ri Fares rucꞌajuol can jun chic ri Judá jeꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y ri Judá rucꞌajuol can ri Jacob, y ri Jacob rucꞌajuol can ri Isaac, y ri Isaac rucꞌajuol can ri Abraham, y ri Abraham rucꞌajuol can ri Taré, y ri Taré rucꞌajuol can ri Nacor. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y ri Nacor rucꞌajuol can ri Serug, y ri Serug rucꞌajuol can ri Ragau, y ri Ragau rucꞌajuol can ri Peleg, y ri Peleg rucꞌajuol can ri Heber, y ri Heber rucꞌajuol can ri Sala. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y ri Sala rucꞌajuol can ri Cainán, y ri Cainán rucꞌajuol can ri Arfaxad, y ri Arfaxad rucꞌajuol can ri Sem, y ri Sem rucꞌajuol can ri Noé, y ri Noé rucꞌajuol can ri Lamec. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y ri Lamec rucꞌajuol can ri Matusalén, y ri Matusalén rucꞌajuol can ri Enoc, y ri Enoc rucꞌajuol can ri Jared, y ri Jared rucꞌajuol can ri Mahalaleel, y ri Mahalaleel rucꞌajuol can jun chic ri Cainán jeꞌ rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y ri Cainán rucꞌajuol can ri Enós, y ri Enós rucꞌajuol can ri Set, y ri Set rucꞌajuol can ri Adán, y ri Adán ralcꞌual ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ri kꞌij antok xꞌan bautizar ri Jesús, jajaꞌ nojnak ránima riqꞌuin ri Espíritu Santo xiel-pa chupan ri río Jordán. Y ri Jesús xucꞌuax ruma ri Espíritu Santo chupan jun lugar desierto. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chireꞌ xcꞌujie-ve cuarenta kꞌij. Y ri diablo xuꞌon tentar. Y chupan ri kꞌij ri xcꞌujieꞌ ri Jesús chupan ri lugar reꞌ, man jun kax xutej, y antok xaꞌkꞌax ri kꞌij reꞌ xnem-pa rupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y xpa ri diablo xuꞌej cha: Xa ketzij chi atreꞌ at Rucꞌajuol ri Dios, tabꞌanaꞌ cha ri abꞌaj la chi ntuoc simíta. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero ri Jesús xuꞌej cha: Tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, chi ri ache man joꞌc ta cꞌa riqꞌuin ri simíta nicꞌasieꞌ, xa nicꞌasieꞌ jeꞌ riqꞌuin ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y ri diablo xucꞌuaj ri Jesús paroꞌ jun nem juyuꞌ, y chupan jun rato xucꞌut choch nojiel naciones richin ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y ri diablo xuꞌej cha ri Jesús: Inreꞌ nijach pan akꞌaꞌ ri qui-gloria nojiel ri naciones reꞌ, chi naꞌan gobernar pa quiveꞌ, ruma pa nukꞌaꞌ inreꞌ i-jachuon-ve can, y inreꞌ niyaꞌ cha ri choj-cha-na ri nivajoꞌ niya-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Xa atreꞌ ncaxuquieꞌ chinoch chi nayaꞌ nukꞌij, nojiel reꞌ xtuoc avichin. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ri Jesús xuꞌej cha: Caꞌin Satanás. Ruma ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios nuꞌej: Xa ja ri Kajaf Dios takayaꞌ rukꞌij, y kabꞌanaꞌ rusamaj jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y ri diablo xucꞌuaj ri Jesús cꞌa chupan ri tanamet Jerusalén, y cꞌa paroꞌ ri más naj jatol chicaj richin ri templo xbꞌaruya-ve-el. Y chireꞌ xuꞌej cha ri Jesús: Xa ketzij chi atreꞌ ri at Rucꞌajuol ri Dios, tacꞌaka-ka-aviꞌ vaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ruma chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can, nuꞌej: Ri Dios xcaꞌrutak-pa ri ru-ángeles aviqꞌuin, chi ncatquichajij. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y xcatquiliꞌiej pa quikꞌaꞌ, chi quireꞌ man xtacajij ta avakan choch abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero ri Jesús xuꞌej cha ri diablo: Ri ruchꞌabꞌal ri Dios nuꞌej: Man taꞌan tentar ri Avajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y antok ri diablo man xril ta chic chica nuꞌon cha ri Jesús chi nuꞌon tentar, xuyaꞌ can jun tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y ri Jesús xtzalaj chic Galilea, nojnak ránima riqꞌuin ri ru-poder ri Espíritu Santo. Y chupan quinojiel tanamet ri icꞌo-pa cierca ri Galilea, xꞌa rutzijoxic ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y jajaꞌ nucꞌut ri ruchꞌabꞌal ri Dios pa tak sinagogas ri tanamet ri pacheꞌ nakꞌax-ve. Y ri vinak ri ncaꞌcꞌaxan ri nuꞌej, niquiyaꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xꞌa Nazaret, ri tanamet pacheꞌ xqꞌuiy-pa. Y chupan ri kꞌij richin uxlanien, jajaꞌ xꞌa chupan ri sinagoga, ri can incheꞌl tuꞌon. Y antok cꞌo chic chireꞌ, jajaꞌ xpiꞌieꞌ chi nuꞌon leer ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y xyoꞌx pa rukꞌaꞌ ri Jesús ri libro ri rutzꞌibꞌan can ri profeta Isaías. Y antok ri Jesús xujak ri libro reꞌ, xril ri pacheꞌ nuꞌej-ve: ");
INSERT INTO cakSNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Espíritu richin ri Ajaf cꞌo panoꞌ inreꞌ, ruma can xirucha-pa chi niꞌej ri utzulaj ruchꞌabꞌal ri Dios chica ri i-puobra. Xirutak-pa chi ncaꞌan sanar ri nikꞌaxo cánima pa rukꞌaꞌ ri pecado; chi niꞌej chica ri icꞌo priexa pa rukꞌaꞌ ri pecado, chi cꞌo cheꞌl ncaꞌcolotaj pa rukꞌaꞌ; chi niꞌan chica ri i-muoy chi ncaꞌtzuꞌn; chi ncaꞌncol ri niquiꞌan sufrir; ");
INSERT INTO cakSNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y chi niꞌej chica ri vinak chi ja tiempo va antok ri Ajaf Dios nuꞌon ri favor. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y ri Jesús xubꞌot can ri libro y xuyaꞌ can cha jun ri nisamaj chireꞌ, y xbꞌatzꞌuyeꞌ. Y quinojiel ri icꞌo chupan ri sinagoga choj niquitzꞌat-apa. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y jajaꞌ xchꞌoꞌ y xuꞌej: Vacame nuꞌon cumplir chivach ixreꞌ ri tzꞌibꞌan can, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y quinojiel ri vinak ri quimaluon-quiꞌ chireꞌ, can xka chiquivach ri Jesús. Y ruma ri utzulaj tak tzij ri xaꞌruꞌej chica, can xaꞌchapataj. Y ri vinak reꞌ niquiꞌej jeꞌ chiquivach: ¿Man ja ta came va rucꞌajuol ri José? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xuꞌej chica: Inreꞌ vataꞌn ri ntiꞌan pensar chuvij: Doctor, taꞌnaꞌ curar-aviꞌ atreꞌ mismo. Ojreꞌ kaxan chi qꞌuiy milagros i-abꞌanun Capernaum, tabꞌanaꞌ jeꞌ vaveꞌ pan atanamit. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xuꞌej jeꞌ chica ri quimaluon-quiꞌ chireꞌ: Can ketzij niꞌej chiva, man jun profeta ninimax pa rutanamit. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Inreꞌ niꞌej chi ixreꞌ ivataꞌn ri xbꞌanataj pa ru-tiempo ri profeta Elías ri xcꞌujieꞌ ojier can antok man xuꞌon ta jobꞌ oxeꞌ junaꞌ riqꞌuin vakiꞌ icꞌ. Can ketzij chi iqꞌuiy malcaꞌn-ixokiꞌ icꞌo vaveꞌ Israel ri tiempo reꞌ, antok xpa altíra viꞌjal choch nojiel ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ri Dios man xutak ta ri Elías chi xutoꞌ jun malcaꞌn-ixok vaveꞌ Israel. Jajaꞌ xa xutak ri Elías riqꞌuin jun malcaꞌn-ixok ri cꞌo chupan ri tanamet Sarepta. Y ri tanamet Sarepta reꞌ cꞌo cierca ri Sidón. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y pa ru-tiempo ri profeta Eliseo ri xcꞌujieꞌ ojier can, ri vaveꞌ Israel iqꞌuiy ri ncaꞌyavaj riqꞌuin ri yabꞌil lepra. Pero ni jun jeꞌ chiquivach xꞌan sanar, joꞌc cꞌa ri Naamán ri xꞌan sanar, y jajaꞌ jun ache aj-Siria. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y antok ri vinak ri quimaluon-quiꞌ chireꞌ chupan ri sinagoga xcaꞌxaj ri xuꞌej ri Jesús chica, xyacataj quiyoval, ");
INSERT INTO cakSNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","y xaꞌbꞌayacataj-pa y xquilasaj-el chuchiꞌ ri tanamet. Ri jun tanamet reꞌ choch jun juyuꞌ cꞌo-ve. Rumareꞌ ri vinak xquicꞌuaj ri Jesús cꞌa paroꞌ ri juyuꞌ chi niquinima-pa choch parar. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ri Jesús choj xakꞌax chiquicajol ri vinak y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ri Jesús xꞌa-ka pa tanamet Capernaum, ri cꞌo Galilea. Y antok nalka ri kꞌij richin uxlanien, jajaꞌ nucꞌut ri ruchꞌabꞌal ri Dios chiquivach ri vinak ri pa sinagoga. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y ri xaꞌcꞌaxan richin, can xaꞌchapataj ruma ri tzij ri ncaꞌruꞌej, can riqꞌuin autoridad. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chireꞌ chupan ri sinagoga, cꞌo-apa jun ache ri cꞌo jun itziel espíritu riqꞌuin. Y ri itziel espíritu reꞌ can cof xchꞌoꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","y xuꞌej cha ri Jesús: Kojayaꞌ can. ¿Chica navajoꞌ chika, atreꞌ Jesús aj-Nazaret? ¿Xapa chi nkojaqꞌuis? Inreꞌ vataꞌn chica atreꞌ, chi at Santo richin ri Dios, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Y ri Jesús xuchꞌolij ri itziel espíritu: Man chic cachꞌoꞌ y catiel-el riqꞌuin ri ache. Y ri itziel espíritu reꞌ xutzak ri ache pan ulief chiquicajol ri vinak ri quimaluon-quiꞌ chireꞌ, xiel-el riqꞌuin y man jun chic kax xuꞌon can cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y ri vinak ri quimaluon-quiꞌ chireꞌ, can xaꞌchapataj antok xquitzꞌat ri xuꞌon ri Jesús, y niquiꞌej cꞌa chiquivach: ¿Chica cꞌa chi tzij va, chi riqꞌuin autoridad y poder nichꞌoꞌ chica ri itziel tak espíritus y niquinimaj rutzij y ncaꞌiel-el? ncaꞌchaꞌ ri vinak chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y xꞌa rutzijoxic ri Jesús, y rumareꞌ ri vinak ri icꞌo cierca ri Capernaum xcaꞌxaj jeꞌ ri ncaꞌruꞌon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupan ri mismo kꞌij richin uxlanien reꞌ, ri Jesús xiel-pa chupan ri sinagoga y xꞌa chirachuoch ri Simón. Ri rujitieꞌ ri Simón nijino pa cꞌatan. Y ri icꞌo chireꞌ pa jay xquicꞌutuj favor cha ri Jesús pa ru-cuenta ri niyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y jajaꞌ xluquie-ka riqꞌuin ri niyavaj, xuchꞌolij ri cꞌatan ri cꞌo chirij, y ja xqꞌuis-el ri cꞌatan ri cꞌo chirij. Ri ixok reꞌ ja xpalaj-pa y xaꞌrutzuk ri Jesús y ri i-bꞌanak riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Antok ya xka-ka ri kꞌij, quinojiel ri vinak richin ri tanamet ri icꞌo ncaꞌyavaj quiqꞌuin, xaꞌquicꞌam-pa choch ri Jesús. Ri ncaꞌyavaj reꞌ, diferente roch yabꞌil ri ntuoc chica. Y ri Jesús xuyaꞌ rukꞌaꞌ pa quiveꞌ chiquijunal ri ncaꞌyavaj y xaꞌruꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Quireꞌ jeꞌ ncaꞌiel itziel tak espíritus quiqꞌuin iqꞌuiy. Y antok ri itziel tak espíritus ncaꞌiel-el, can cof ncaꞌchꞌoꞌ y niquiꞌej: Atreꞌ ri Rucꞌajuol ri Dios. Y ri Jesús ncaꞌruchꞌolij y man xuyaꞌ ta permiso chica chi xaꞌchꞌoꞌ, ruma cataꞌn chi ri Jesús jareꞌ ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y antok xsakar-pa, ri Jesús xiel-el pa tanamet y xꞌa chupan jun lugar pacheꞌ manak vinak. Pero ri vinak xbꞌaquicanuj ri Jesús, y antok xbꞌaquila-pa, xquikꞌat choch ruma man nicajoꞌ ta chi niꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero jajaꞌ xuꞌej chica: Can nicꞌatzin jeꞌ chi nquiꞌa nicꞌaj chic tanamet chi nitzijuoj ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, ruma richin reꞌ xitak-pa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y jajaꞌ nutzijuoj ri ruchꞌabꞌal ri Dios pa tak sinagogas chupan ri Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun kꞌij, antok ri Jesús cꞌo chuchiꞌ ri lago Genesaret rubꞌeꞌ, qꞌuiy vinak xaꞌbꞌaka riqꞌuin y niquipitzꞌ, ruma nicajoꞌ nicaꞌxaj ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pero jajaꞌ xutzꞌat-apa caꞌyeꞌ barcos icꞌo can chuchiꞌ ri lago, y man jun icꞌo chiquipan, ruma ri cajaf ri barcos reꞌ i-tzꞌamoy-car, y ri huora reꞌ niquichꞌaj ri quiyaꞌl. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun chiquivach ri barcos reꞌ richin ri Simón. Y chupan ri ru-barco ri Simón xuoc-ve ri Jesús. Y jajaꞌ xuꞌej cha ri Simón chi tiꞌa-apa bꞌaꞌ paroꞌ ri yaꞌ. Y jajaꞌ xtzꞌuye-ka chupan ri barco y xaꞌrutijuoj-ka ri vinak riqꞌuin ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Antok ri Jesús xtanieꞌ chi nichꞌoꞌ chica ri vinak reꞌ, ja xuꞌej cha ri Simón: Jo-apa pacheꞌ nem kajnak ri yaꞌ, y quiꞌiya-ka ri iyaꞌl chi nquiꞌtzꞌom car. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero ri Simón xuꞌej cha ri Jesús: Maestro, ojreꞌ jun akꞌaꞌ xojcꞌasieꞌ chi xaꞌkacanuj car, y man jun xaꞌkatzꞌom. Pero ruma atreꞌ ncaꞌeꞌn chi kaya-ka ri yaꞌl pa yaꞌ, nakaya-ka cꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y antok xquicꞌak-ka ri yaꞌl chupan ri yaꞌ, can iqꞌuiy car xaꞌuoc chupan ri yaꞌl, y rumareꞌ ri yaꞌl can nikꞌachꞌitaj ruma ri calal ri car. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Rumareꞌ xquiꞌan-apa señas chica ri cachꞌil ri icꞌo chupan ri jun chic barco, chi ncaꞌpa chi ncaꞌquitoꞌ. Ri cachꞌil xaꞌpa y ri caꞌyeꞌ barcos xaꞌquinojsaj chi car. Rumareꞌ ri barcos reꞌ xa jubꞌaꞌ ma ncaꞌa chuxieꞌ yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y antok ri Simón Pedro xutzꞌat ri xbꞌanataj, jajaꞌ xxuquieꞌ choch ri Jesús, y xuꞌej cha: Ajaf, inreꞌ xa in jun ache pecador, man otz ta chi ncacꞌujie-pa viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Can ruma ri qꞌuiy car ri xaꞌquitzꞌom ri kꞌij reꞌ, ri Simón y ri i-bꞌanak riqꞌuin, can xquixiꞌij-quiꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","y quireꞌ mismo xquiꞌan ri Jacobo y ri Juan, ri i-rucꞌajuol ri Zebedeo, ri icꞌo riqꞌuin ri Simón. Rumareꞌ ri Jesús xuꞌej cha ri Simón: Man taxiꞌij-aviꞌ ruma ri xatzꞌat. Desde vacame xcaꞌcanuj vinak chi nquinquinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y ri achiꞌaꞌ reꞌ xaꞌquicꞌam-pa ri qui-barcos cꞌa chuchiꞌ ri yaꞌ, xquiyaꞌ can ri quisamaj y xaꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y antok ri Jesús cꞌo chupan jun tanamet, xalka jun ache riqꞌuin ri cꞌo ri yabꞌil lepra chirij. Ri ache reꞌ joꞌc xutzꞌat ri Jesús, ja xxuquie-ka choch y xulucubꞌa-ka ri rujaluon cꞌa pan ulief y nucꞌutuj favor, xuꞌej cha: Ajaf, xa navajoꞌ, cꞌo cheꞌl nquinaꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ri Jesús ja xuyuk-apa ri rukꞌaꞌ y xutzꞌom-apa ri ache y xuꞌej cha: Nivajoꞌ chi ncacꞌachoj. Tiqꞌuis-el ri yabꞌil reꞌ chavij, xchaꞌ cha. Y joꞌc xuꞌej quireꞌ ri Jesús, ja xqꞌuis-el ri yabꞌil lepra chirij ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Y ri Jesús xuꞌon mandar cha chi man tutzijuoj chica ri vinak ri xbꞌanataj riqꞌuin. Y xuꞌej jeꞌ cha: Vacame choj caꞌin, acꞌutu-aviꞌ choch ri sacerdote, y tayaꞌ ri nuꞌej chupan ri ru-ley ri Moisés, chi quireꞌ nikꞌalajin chiquivach chi at otz chic vacame, xcha-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri Jesús más cꞌa xꞌa rutzijoxic, y qꞌuiy vinak niquimol-quiꞌ riqꞌuin ruma nicajoꞌ nicaꞌxaj ri ruchꞌabꞌal ri Dios y ruma nicajoꞌ chi ncaꞌan sanar ruma jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y jajaꞌ niꞌa pacheꞌ manak vinak, chi nuꞌon orar. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y jun kꞌij antok ri Jesús nucꞌut ri ruchꞌabꞌal ri Dios, i-tzꞌuyul-apa nicꞌaj achiꞌaꞌ fariseos y nicꞌaj maestros richin ri ley. Icꞌo chiquivach ijejeꞌ ri i-patanak pa tak aldeas ri icꞌo chupan Galilea, icꞌo i-patanak pa tanamet Jerusalén y icꞌo i-patanak nicꞌaj chic tanamet ri icꞌo Judea. Y ri Jesús can cꞌo ri ru-poder ri Ajaf Dios riqꞌuin chi ncaꞌruꞌon sanar ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y icꞌo nicꞌaj achiꞌaꞌ quicꞌamun-pa jun ache ri paralítico ru-cuerpo, choch jun camilla. Y ijejeꞌ xcajoꞌ ta xaꞌuoc pa jay cꞌa riqꞌuin ri Jesús, chi niquiyaꞌ ri ache paralítico choch. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ri achiꞌaꞌ reꞌ man xaꞌtiquir ta xaꞌuoc, ruma iqꞌuiy ri vinak quimaluon-quiꞌ chireꞌ. Mareꞌ xaꞌjotie-el paroꞌ ri jay, y xquicꞌan-el jubꞌaꞌ ri ruveꞌ. Y xquikasaj-ka ri camilla ri cꞌo ri ache ri paralítico ru-cuerpo choch, cꞌa choch ri Jesús xbꞌaka-ve-ka, chireꞌ chiquicajol ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y antok ri Jesús xutzꞌat chi ri achiꞌaꞌ ri i-cꞌamayuon-pa quicukubꞌan quicꞌuꞌx riqꞌuin, ja xuꞌej cha ri ache ri paralítico ru-cuerpo: Ache, ri a-pecados xaꞌan perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Entonces ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos ja xquiꞌan-ka pensar: ¿Chica cꞌa ache va? ¿Y karruma nuꞌon chi jajaꞌ ri Dios, ruma joꞌc ri Dios nibꞌano perdonar pecados? ");
INSERT INTO cakSNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ri Jesús can rataꞌn ri niquiꞌan pensar ri achiꞌaꞌ reꞌ, mareꞌ xuꞌej chica: ¿Karruma quireꞌ ntiꞌej pa tak ivánima? ");
INSERT INTO cakSNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Chica ri más fácil, niꞌej: Ri a-pecados niꞌan perdonar, o niꞌej: Capalaj y caꞌin? ");
INSERT INTO cakSNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Vacame cꞌa, chi ntivatamaj chi ri Xtak-pa chicaj chi xalax chiꞌicajol can cꞌo poder riqꞌuin chi nuꞌon perdonar pecados, (jareꞌ antok ri Jesús xuꞌej cha ri ache paralítico): Chava atreꞌ niꞌej: Capalaj, tavucꞌuaj ri a-camilla y caꞌin chavachuoch, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chaꞌnin xpalaj chiquivach quinojiel ri vinak ri quimaluon-quiꞌ chireꞌ, xucꞌol-el ri camilla ri choj choch cotzꞌobꞌan-ve-pa, y xꞌa chirachuoch, nuyaꞌ cꞌa rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y quinojiel ri vinak ri quimaluon-quiꞌ chireꞌ, can xaꞌchapataj, y xquiyaꞌ rukꞌij ri Dios, y quixiꞌin-quiꞌ niquiꞌej: Chupan va jun kꞌij va xaꞌkatzꞌat milagros ri man jun bꞌay katzꞌatuon. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Después ri xbꞌanataj, ri Jesús xiel-pa chireꞌ y xutzꞌat jun ache maloy-impuestos. Ri ache reꞌ rubꞌinan Leví, y tzꞌuyul choch jun chꞌacat chi numol ri impuestos ri ncaꞌtuoj can. Y ri Jesús xuꞌej cha: Joꞌ viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y jajaꞌ xpalaj-pa ri pacheꞌ tzꞌuyul-ve, xuyaꞌ can nojiel ri cꞌo chireꞌ, y xꞌa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y ri Leví xuꞌon jun namakꞌej pa rachuoch richin ri Jesús. Xaꞌrayuoj iqꞌuiy ri maloy-impuestos y nicꞌaj chic vinak. Y quinojiel icꞌo chirij ri mesa riqꞌuin ri Jesús y quiqꞌuin ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos qꞌuiy tzij niquiꞌej-apa chiquij ri discípulos. Niquiꞌej-apa chica: ¿Karruma ixreꞌ nquixvaꞌ quiqꞌuin ri maloy-impuestos y quiqꞌuin ri vinak ri aj-bꞌanoy-pecado niꞌeꞌx chica? ");
INSERT INTO cakSNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ fariseos y ri achiꞌaꞌ escribas: Ri man ncaꞌyavaj ta man nicꞌatzin ta jun doctor chica, xa ja ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Inreꞌ man xipa ta chi ncaꞌnvayuoj ri choj quicꞌaslien choch ri Dios, xa ja ri cꞌo qui-pecados, chi nitzalaj-pa cánima riqꞌuin ri Dios y niquiꞌan ri nrajoꞌ jajaꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Entonces ri achiꞌaꞌ fariseos y ri achiꞌaꞌ escribas xquiꞌej cha ri Jesús: ¿Karruma ri ru-discípulos ri Juan el Bautista qꞌuiy mul niquiꞌan ayuno y oración, y quireꞌ jeꞌ niquiꞌan ri qui-discípulos ri achiꞌaꞌ fariseos, pero ri a-discípulos atreꞌ man quireꞌ ta niquiꞌan, xa siempre ncaꞌvaꞌ? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y ri Jesús xuꞌej chica: ¿Acaso nquixcovin ntiꞌan chi niquiꞌan ayuno ri i-bꞌanun invitar pa jun cꞌulubꞌic antok xa cꞌa cꞌo ri alaꞌ ri xcꞌulieꞌ chiquicajol? ");
INSERT INTO cakSNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xtalka ri kꞌij antok ri alaꞌ reꞌ xtalasas-el chiquicajol, cꞌajareꞌ xtiquiꞌan ayuno. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ri Jesús xucusaj jeꞌ jun parábola (cꞌambꞌal-tzij) chiquivach: Man jun nralasaj-el jun cꞌojobꞌal cha jun tziak cꞌacꞌacꞌ chi nucꞌojobꞌiej jun tziak ri xa tziaꞌk chic; ruma xa nuꞌon quireꞌ, man otz ta nuꞌon cha ri tziak cꞌacꞌacꞌ ruma nurakꞌachꞌij. Y quireꞌ jeꞌ jun tziak cꞌacꞌacꞌ man otz ta nuꞌon riqꞌuin jun ri xa tziaꞌk chic. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y man jun niyoꞌn cꞌacꞌacꞌ vino chupan jun tzꞌun yacbꞌal-yaꞌ ri xa tziaꞌk chic. Ruma xa quireꞌ niꞌan cha, ri tzꞌun xa man nuyuk ta chic riꞌ; ri tzꞌun xa nikꞌachꞌitaj y ja niqꞌuis-el ri vino chupan. Y ri tzꞌun jeꞌ man jun chic xticꞌatzin-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero chupan jun cꞌacꞌacꞌ tzꞌun yacbꞌal-yaꞌ, otz niyaquieꞌ cꞌacꞌacꞌ vino, ruma ri tzꞌun reꞌ cꞌa nuyuk-riꞌ jaꞌal y man nikꞌachꞌitaj ta. Ri vino niyaquieꞌ jaꞌal chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y man jun ri nukun vino ri ya cꞌo tiempo yacal, xtirajoꞌ ta nukun ri cꞌacꞌacꞌ vino después. Ruma xa xtuꞌej: Ri vino ri cꞌo tiempo yacal jareꞌ ri más otz, xtichaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Chupan jun kꞌij richin uxlanien, ri Jesús y ri ru-discípulos ncaꞌkꞌax chupan jun ulief ri ticuon trigo choch. Y ri discípulos ncaꞌquichꞌup-el ruveꞌ ri trigo, y ncaꞌquibꞌir pa quikꞌaꞌ, y ncaꞌquitej. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Rumareꞌ nicꞌaj achiꞌaꞌ fariseos xquiꞌej chica ri ru-discípulos ri Jesús: ¿Karruma nquixsamaj chupan ri kꞌij richin uxlanien? Reꞌ xajan. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero ri Jesús xchꞌo-apa chica y xuꞌej: ¿Man jun came bꞌay ibꞌanun leer ri tzꞌibꞌan can chirij ri xuꞌon ri David y ri i-rachꞌil chupan ri ojier can tiempo antok xnem-pa quipan? ");
INSERT INTO cakSNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xuoc pa rachuoch ri Dios y can ja ri sagrada simíta ri xiruma-pa. Jajaꞌ xucꞌux ri simíta reꞌ y xuyaꞌ jeꞌ chica ri i-bꞌanak riqꞌuin; pero man pecado ta ri xquiꞌan, mesque ri simíta reꞌ joꞌc ri sacerdotes ri ncaꞌcꞌuxu, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y xuꞌej jeꞌ chica: Ri Xtak-pa chicaj chi xalax chiꞌicajol, Rajaf ri kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Chupan jun chic kꞌij richin uxlanien, ri Jesús xuoc ri pa sinagoga y ncaꞌrutijuoj ri quimaluon-quiꞌ chireꞌ. Y chiquicajol ri vinak, cꞌo jun ache chakeꞌj ri rukꞌaꞌ derecha. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Y icꞌo achiꞌaꞌ escribas y achiꞌaꞌ fariseos niquitzꞌat-apa ri Jesús y quiyoꞌien chi xa xtuꞌon sanar ri ache, chi quireꞌ niquiꞌan acusar chi xsamaj chupan jun kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ri Jesús rataꞌn chic ri niquiꞌan pensar ri achiꞌaꞌ reꞌ. Mareꞌ xuꞌej cha ri ache chakeꞌj ri rukꞌaꞌ: Capalaj y capiꞌieꞌ pa nicꞌaj. Y ri ache ja xpalaj-pa ri pacheꞌ cꞌo-ve y xpiꞌieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpa ri Jesús xuꞌej chica ri vinak ri icꞌo chireꞌ: Nivajoꞌ cꞌa nicꞌutuj chiva: ¿Chica ri más otz niꞌan chupan jun kꞌij richin uxlanien, ja ri otz o ja ri man otz ta? ¿Ri nicuol jun vinak choch ri camic o niquimisas? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y ri Jesús xaꞌrucaꞌyiej quinojiel ri quimaluon-quiꞌ chireꞌ, y xuꞌej cha ri ache ri chakeꞌj jun rukꞌaꞌ: Tayukuꞌ la akꞌaꞌ. Y ri ache xuyuk ri rukꞌaꞌ incheꞌl ri xꞌeꞌx cha ruma ri Jesús, y ja otz xuꞌon ri rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos ri icꞌo-apa chireꞌ xyacataj quiyoval. Y ja niquicꞌutuj chiquibꞌil-quiꞌ chi chica niquiꞌan cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y jun kꞌij ri Jesús xꞌa paroꞌ jun juyuꞌ chi xbꞌarubꞌanaꞌ orar. Y jun akꞌaꞌ xchꞌoꞌ riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y chupan ri macꞌajan ri chucaꞌn kꞌij, jajaꞌ xaꞌrayuoj ri ru-discípulos. Chiquicajol ri achiꞌaꞌ reꞌ, xaꞌruchaꞌ doce (cabꞌalajuj) y xuꞌej apóstoles chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri i-doce (cabꞌalajuj) ri xaꞌruchaꞌ ri Jesús, ja ri Simón ri xuꞌej jeꞌ Pedro cha, ri Andrés ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Simón, ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cakSNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri rucꞌajuol ri Alfeo, ri Simón ri cꞌo quiqꞌuin ri achiꞌaꞌ ri niꞌeꞌx Zelotes chica, ");
INSERT INTO cakSNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Jacobo, y ri Judas Iscariote ri xcꞌayin richin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Y antok ri Jesús y ri ru-apóstoles xaꞌka-pa paroꞌ ri juyuꞌ, y xaꞌbꞌacꞌujie-ka quiqꞌuin ri nicꞌaj chic discípulos chupan jun lugar liꞌan, chireꞌ jeꞌ iqꞌuiy vinak quimaluon-quiꞌ. Icꞌo i-patanak Jerusalén y nicꞌaj chic tanamet ri icꞌo Judea, y icꞌo i-patanak Tiro y Sidón ri icꞌo chuchiꞌ ri mar. Ri vinak reꞌ i-patanak chi nicaꞌxaj ri ruchꞌabꞌal ri Dios ri nutzijuoj ri Jesús, y chi ncaꞌan sanar riqꞌuin ri quiyabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y xaꞌan jeꞌ sanar ri altíra niquiꞌan sufrir pa quikꞌaꞌ ri itziel tak espíritus ri icꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y quinojiel ri vinak ri ncaꞌyavaj nicajoꞌ niquitzꞌom-apa ri Jesús, ruma jajaꞌ cꞌo poder riqꞌuin y ncaꞌruꞌon sanar quinojiel ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y ri Jesús xaꞌrucaꞌyiej ri ru-discípulos y xuꞌej chica: Can jaꞌal quixquicuot ixreꞌ ri ix puobra, ruma can ivichin ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Can jaꞌal quixquicuot ixreꞌ ri ntikꞌasaj viꞌjal, ruma ri Dios xtuyaꞌ nojiel chiva. Can jaꞌal quixquicuot ixreꞌ ri nquixuokꞌ vacame, ruma ri Dios xtucꞌax ri ivokꞌiej riqꞌuin tzeꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Can jaꞌal quixquicuot ixreꞌ ri itziel nquixtzꞌiet cuma ri vinak, y nquixquilasaj-pa chiquicajol, y niquiꞌan cha ri ibꞌeꞌ chi man jun rakalien ruma iniman ri nubꞌeꞌ inreꞌ, y nojiel roch itziel ri niquiꞌan chiva ruma ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y antok xtibꞌanataj nojiel reꞌ, quixtzeꞌn y quixquicuot, ruma nem ri rucꞌaxiel ri xtiyoꞌx chiva chicaj. Ruma quireꞌ ri sufrimiento ri xquikꞌasaj ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, pa quikꞌaꞌ ri cateꞌt-quimamaꞌ ri vinak ri itziel nquixquitzꞌat vacame. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Pero juyeꞌ ivach ixreꞌ bꞌayomaꞌ, ruma xixquicuot yan ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Juyeꞌ ivach ixreꞌ ri nquixvaꞌ jaꞌal vacame, ruma xtikꞌasaj viꞌjal. Juyeꞌ ivach ixreꞌ ri jaꞌal nquixtzeꞌn vacame, ruma xquixuokꞌ ruma bꞌis. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y juyeꞌ ivach antok quinojiel ri vinak otz ncaꞌchꞌoꞌ chivij. Ruma ri cateꞌt-quimamaꞌ ijejeꞌ otz xaꞌchꞌoꞌ chiquij ri falsos profetas. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero chiva ixreꞌ ri nquinivaxaj, niꞌej cꞌa: Quiꞌivajoꞌ ri iv-enemigos; tibꞌanaꞌ otz chica ri itziel nquixquitzꞌat; ");
INSERT INTO cakSNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ticꞌutuj cha ri Dios chi caꞌrubꞌanaꞌ bendecir ri vinak ri nquixquiꞌan maldecir; y tibꞌanaꞌ orar pa qui-cuenta ri niquikꞌabꞌaj tzij chivij. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y xa cꞌo jun nuyaꞌ jutzꞌaj kꞌaꞌ cha ri akꞌoꞌtz, xa tayaꞌ chic apa ri jun chic lado choch. Y xa cꞌo jun numaj-el ri a-capa ri akꞌuꞌn, xa tayaꞌ chic can jun atziak cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chica-na ri cꞌo nucꞌutuj chava, tayaꞌ cha ri nrajoꞌ. Y xa cꞌo jun ri cꞌo numaj-el chava, man chic cꞌa tacꞌutuj cha chi nutzoliej-pa chava. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y incheꞌl ri ntivajoꞌ ixreꞌ chi ri vinak niquiꞌan chiva, quireꞌ jeꞌ tibꞌanaꞌ quiqꞌuin ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Ruma xa ja ri ncaꞌjoꞌn ivichin, xa jareꞌ nquiꞌvajoꞌ, ¿cꞌo came rucꞌaxiel xtiyoꞌx chiva? Ruma quireꞌ jeꞌ mismo niquiꞌan ri man quiniman ta ri Dios, joꞌc ri ncaꞌjoꞌn quichin jareꞌ ri ncaꞌcajoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y xa joꞌc ri ncaꞌbꞌano otz chiva, joꞌc chica ijejeꞌ ntiꞌan-ve otz jeꞌ, ¿cꞌo came rucꞌaxiel xtiyoꞌx chiva? Ruma quireꞌ jeꞌ mismo niquiꞌan ri man quiniman ta ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xa ixreꞌ ntiyaꞌ jun kax cha jun pa kajic ruma ntivoyoꞌiej ri kajbꞌal richin, ¿cꞌo came rucꞌaxiel xtiyoꞌx chiva? Ruma ri man quiniman ta ri Dios quireꞌ jeꞌ mismo niquiꞌan, ncaꞌquiyaꞌ pa kajic ri kax chiquivach ijejeꞌ, chi quireꞌ cꞌo niquichꞌec chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero ixreꞌ man tiꞌan quireꞌ. Xa quiꞌivajoꞌ ri iv-enemigos y tibꞌanaꞌ otz chica. Y antok ixreꞌ ntiyaꞌ pa kajic jun kax ivichin, man tivoyoꞌiej ri kajbꞌal richin; chi quireꞌ nem ri rucꞌaxiel ri xtiyoꞌx chiva. Y xa quireꞌ xtiꞌan ixreꞌ, can xtikꞌalajin chi ixreꞌ ix ralcꞌual ri Namalaj Dios ri cꞌo chicaj. Jajaꞌ otz runoꞌj quiqꞌuin ri man jun bꞌay niquiyaꞌ tiox bꞌaꞌ cha, y quiqꞌuin ri itziel quinoꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tijoyovaj quivach ri vinak, incheꞌl ri Itataꞌ ri cꞌo chicaj; jajaꞌ can nujoyovaj kavach ojreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man quiꞌan juzgar ri vinak, y man xtiꞌan ta quireꞌ chiva ixreꞌ. Man tirayij chiquij ri vinak chi niquikꞌaj ri itziel tak kax ri ncaꞌquiꞌan, y ri Dios man xtuꞌon ta jeꞌ quireꞌ iviqꞌuin ixreꞌ. Tibꞌanaꞌ perdonar ri quichꞌoꞌj ri vinak, y ri Dios quireꞌ jeꞌ xtuꞌon chiva ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xa ixreꞌ riqꞌuin nojiel ivánima nquiꞌtoꞌ ri vinak riqꞌuin ri nicꞌatzin chica, ri Dios xtuyaꞌ jeꞌ rucꞌaxiel chiva. Ri rucꞌaxiel ri xtuyaꞌ chiva ri Dios, can qꞌuiy. Can xtunojsaj, can xtupitzꞌ, y xtipulin xtuyaꞌ ri Dios chiva. Y can incheꞌl ri ntiꞌan ixreꞌ, quireꞌ xtiꞌan chiva ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y xuꞌej jeꞌ jun parábola (cꞌambꞌal-tzij) chica. Jajaꞌ xuꞌej: ¿Cꞌo came jun muoy ri nitiquir nuyukiej chukꞌaꞌ jun chic muoy, y man ncaꞌtzak ta came pa jul? ");
INSERT INTO cakSNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Man jun discípulo cꞌo más rukꞌij choch ri ru-maestro. Xa cꞌa nratamaj-na nojiel ri nucꞌut choch, después ntiel incheꞌl ri ru-maestro. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Karruma ja ri qꞌuin ri cꞌo pa roch ri av-hermano ri natzꞌat chaꞌnin, y man nanaꞌ ta ka-aviꞌ chi atreꞌ xa jun chieꞌ kꞌapal pan avach? ");
INSERT INTO cakSNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿O karruma naꞌej cha ri av-hermano: Hermano, tayaꞌ chi nivalasaj-el ri qꞌuin ri kꞌapal pan avach, y man nanaꞌ ta chi atreꞌ xa jun chieꞌ kꞌapal pan avach? Atreꞌ xa caꞌyeꞌ apalaj, tavalasaj-el naꞌay ri chieꞌ pan avach atreꞌ, chi quireꞌ kꞌalaj xcatzuꞌn y xcatiquir xtavalasaj-el ri qꞌuin ri cꞌo pa roch ri av-hermano. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Man jun utzulaj chieꞌ xtuyaꞌ ta itziel tak roch, y man jun chieꞌ ri man otz ta, xtuyaꞌ ta utzulaj tak roch. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ri chieꞌ ninaꞌax riqꞌuin ri roch ri nuyaꞌ xa otz o man otz ta. Ruma ri chieꞌ ri cꞌo quiqꞌuixal man xtiquiyaꞌ ta víquix, ni ri kꞌayis ri cꞌo quiqꞌuixal man xtiquiyaꞌ ta uvas. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun utzulaj ache can ja ri utzulaj kax ri nuꞌej, ruma joꞌc utzulaj tak kax cꞌo pa ránima. Pero jun ache ri man otz ta, ja ri itziel tak kax ri nuꞌej, ruma jareꞌ ri cꞌo pa ránima. Ruma jun vinak ja ri chica cꞌo pa ránima ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y karruma ixreꞌ ntiꞌej Ajaf, Ajaf, chuva y xa man ntiꞌan ta ri niꞌej chiva? ");
INSERT INTO cakSNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Niꞌej chiva, chica choj-iqꞌuin junan-ve ri nipa viqꞌuin y nraꞌxaj ri nutzij y nuꞌon ri niꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Can junan riqꞌuin ri ache ri xuꞌon jun rachuoch. Naꞌay xuꞌon-ka ri jul richin ri ru-cimiento ri jay, y paroꞌ abꞌaj xuya-ve ri ru-cimiento ri jay. Y antok cꞌachojnak chic ri jay, xnimar-pa ri río. Y ri río reꞌ xbꞌarilaꞌ ri jay. Pero mesque ri río altíra xnimar y altíra ruchukꞌaꞌ, man xcovin ta xusiluoj, ruma ri ru-cimiento ri jay reꞌ paroꞌ abꞌaj xyoꞌx-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ri joꞌc nraꞌxaj ri niꞌej inreꞌ y man nuꞌon ta ri niꞌej cha, junan riqꞌuin jun ache ri xuꞌon ri rachuoch choch ulief, y xa man xuyaꞌ ta ru-cimiento. Y antok ri río xnimar-pa, xbꞌarila-pa ri jay y ja xtzak y xvuluvuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Antok ri Jesús xtanieꞌ riqꞌuin ri tzij chiquivach ri ncaꞌcꞌaxan richin, ja xuoc pa tanamet Capernaum. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chireꞌ pa tanamet cꞌo jun capitán ri cꞌo jun ru-esclavo ri altíra nrajoꞌ, pero niyavaj y ya nicon. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Antok ri capitán xraꞌxaj cꞌa chirij ri Jesús, jajaꞌ xaꞌrutak nicꞌaj mamaꞌaꞌ tak achiꞌaꞌ israelitas ri niquiꞌan gobernar, chi niquicꞌutuj favor cha ri Jesús chi tipa chi nuꞌon sanar ri ru-esclavo. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y antok ri mamaꞌaꞌ tak achiꞌaꞌ xaꞌlka riqꞌuin ri Jesús, xquicꞌutuj favor cha. Y xquiꞌej cha: Can rakalien chi naꞌan ri favor cha ri capitán, ");
INSERT INTO cakSNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ruma jajaꞌ altíra nkojrajoꞌ ojreꞌ israelitas, y xuꞌon jun sinagoga, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y ri Jesús xꞌa chiquij ri mamaꞌaꞌ tak achiꞌaꞌ ri i-takuon-pa ruma ri capitán. Y antok ri Jesús y ri i-bꞌanak riqꞌuin icꞌo cierca ri rachuoch ri capitán, jajaꞌ xaꞌrutak nicꞌaj ru-amigos chi xalquiꞌej cha ri Jesús: Ajaf, man cꞌa taꞌan molestar-aviꞌ, atreꞌ cꞌo akꞌij, y rumareꞌ man nucꞌul ta chi ncatuoc pa vachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y ruma quireꞌ ninaꞌ, mareꞌ man xinvajoꞌ ta chi inreꞌ xibꞌacanun avichin. Joꞌc taꞌej chi ticꞌachoj y ri nu-esclavo xtuꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ruma incheꞌl nubꞌanun inreꞌ, cꞌo jun ri nquibꞌano mandar. Y icꞌo soldados i-yoꞌn pa nukꞌaꞌ chi ncaꞌnꞌan mandar. Y antok niꞌej cha jun chi tiꞌa, ja niꞌa; y antok niꞌej cha jun chic chi tipa, ja nipa. Y antok niꞌej cha ri nu-esclavo chi tubꞌanaꞌ jun samaj, can nuꞌon, xaꞌchaꞌ ri achiꞌaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y antok ri Jesús xraꞌxaj ri ruꞌeꞌn-el ri capitán, can xchapataj. Y xaꞌrutzꞌat can ri vinak ri i-bꞌanak chirij, y xuꞌej chica: Can niꞌej chiva, chi man jun cꞌa israelita ri viluon ri rucukubꞌan rucꞌuꞌx viqꞌuin incheꞌl ri ache reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y antok xaꞌtzalaj chirachuoch ri capitán ri i-takuon-el, xquitzꞌat chi ri esclavo ri niyavaj, man chic niyavaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic kꞌij, ri Jesús xꞌa jun tanamet rubꞌinan Naín, y i-bꞌanak jeꞌ iqꞌuiy ri ru-discípulos riqꞌuin. Y iqꞌuiy vinak jeꞌ i-bꞌanak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Antok ri Jesús y ri i-bꞌanak riqꞌuin ya ncaꞌuoc chupan ri tanamet Naín, xquitzꞌat chi cꞌamun-pa jun quiminak chi niꞌmuk. Ri quiminak reꞌ jun alaꞌ, ral jun malcaꞌn-ixok. Ri malcaꞌn-ixok reꞌ, xa jun oc ral cꞌo. Y iqꞌuiy vinak ri i-bꞌanak riqꞌuin ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y antok ri Ajaf Jesús xutzꞌat ri ixok reꞌ, xujoyovaj roch y xuꞌej cha: Man chic catuokꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y ri Jesús xjiel-apa y xutzꞌom-apa ri rucáxa ri quiminak, y ri i-cꞌuayuon richin ri quiminak xaꞌpiꞌie-ka. Y xuꞌej cha ri quiminak: Alaꞌ, chava atreꞌ niꞌej, capalaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Entonces ri alaꞌ ri quiminak xpalaj-pa y xbꞌatzijuon-pa. Y ri Jesús xuya-el ri alaꞌ cha ri rutieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Y quinojiel ri xquitzꞌat ri xbꞌanataj altíra xquixiꞌij-quiꞌ. Y xquiyaꞌ rukꞌij ri Dios, y niquiꞌej: Jun Namalaj Profeta xpalaj-pa chikacajol, y ri Dios xutak-pa ri ru-favor chikacajol ojreꞌ ri rutanamit, xaꞌchaꞌ ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y ri xuꞌon ri Jesús xꞌa rutzijoxic nojiel Judea, y xꞌa jeꞌ rutzijoxic nicꞌaj chic tanamet ri icꞌo-pa cierca ri Judea. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ri ru-discípulos ri Juan el Bautista xquiꞌej cha nojiel ri xuꞌon ri Jesús. Rumareꞌ ri Juan el Bautista xaꞌrayuoj icaꞌyeꞌ chiquivach ri ru-discípulos, ");
INSERT INTO cakSNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xaꞌrutak-el riqꞌuin ri Jesús chi xbꞌaquicꞌutuj cha: ¿Atreꞌ ri xtipa o nakayoꞌiej chic jun? ");
INSERT INTO cakSNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Antok ri i-rutakuon-el ri Juan xaꞌbꞌaka cꞌa riqꞌuin ri Jesús, xquiꞌej cha: Ri Juan el Bautista oj-rutakuon-pa aviqꞌuin, chi nalkacꞌutuj chava: ¿Atreꞌ ri xtipa o nakayoꞌiej chic jun? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ja misma huora reꞌ, ri Jesús xaꞌruꞌon sanar qꞌuiy vinak ri ncaꞌyavaj. Xaꞌruꞌon jeꞌ sanar nicꞌaj riqꞌuin itziel tak yabꞌil. Xaꞌralasaj jeꞌ itziel tak espíritus ri icꞌo quiqꞌuin nicꞌaj, y xuꞌon jeꞌ chica iqꞌuiy muoy chi xaꞌtzuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y ri Jesús xuꞌej chica: Quixꞌin, tiꞌej cha ri Juan ri xitzꞌat y ri xivaxaj-el: Ri muoy ncaꞌtzuꞌn; ri ncaꞌjacajot ncaꞌin, otz ncaꞌin; ri cꞌo ri yabꞌil lepra chiquij, ncaꞌcꞌachoj; ri man ncaꞌcꞌaxan ta, vacame ncaꞌcꞌaxan; ri quiminakiꞌ ncaꞌcꞌastaj-pa; y chica ri i-puobra nitzijos ri evangelio. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y tiꞌej jeꞌ cha chi jun ri can rucukubꞌan rucꞌuꞌx viqꞌuin y man nquiruyaꞌ ta can, can jaꞌal tiquicuot, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y antok ri i-rutakuon-pa ri Juan el Bautista xaꞌa, ri Jesús xaꞌruꞌej utzulaj tak tzij chirij ri Juan el Bautista chiquivach ri vinak ri icꞌo chireꞌ. Y quireꞌ ri xuꞌej chica: ¿Chica ri xbꞌaꞌitzꞌataꞌ chupan ri lugar desierto? ¿Jun aj ri nisilos ruma ri cakꞌiekꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Pero ¿chica ri xbꞌaꞌitzꞌataꞌ chireꞌ? ¿Jun ache ri jaꞌal tak tziak rucusan? Ri achiꞌaꞌ ri niquicusaj jaꞌal tak tziak y cꞌo ta man cꞌo niquiꞌan, xa pa tak qui-palacios ri reyes ncaꞌcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Pero ¿chica ri xbꞌaꞌitzꞌataꞌ? ¿Jun profeta? Quireꞌ. Y ri Jesús xuꞌej chic chica: Pero más nem que choch jun profeta. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Y chirij cꞌa ri Juan nichꞌo-ve ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can ri nuꞌej: Inreꞌ xtintak jun ache naꞌay chavach, chi nuchojmij ri abꞌiey chavach. Quireꞌ nuꞌej ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Y niꞌej cꞌa chiva, chi chiquicajol ri profetas ri i-alaxnak choch-ulief, man jun más nem choch ri Juan el Bautista. Pero ri más coꞌl-oc pa ru-reino ri Dios, más nem choch ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y chireꞌ icꞌo iqꞌuiy vinak y ri maloy-impuestos ri i-bꞌanun bautizar ruma ri Juan. Y antok ijejeꞌ xcaꞌxaj ri xuꞌej ri Jesús, xquiꞌej chi ri Dios can choj-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ri achiꞌaꞌ fariseos y ri maestros richin ri ley, man xka ta chiquivach ri xrajoꞌ ta xuꞌon ri Dios quiqꞌuin. Ijejeꞌ man xcajoꞌ ta xaꞌan bautizar ruma ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ri Ajaf Jesús xuꞌej: ¿Choj-iqꞌuin cꞌa niꞌan comparar ri vinak richin ri tiempo vacame? ¿Y choj-iqꞌuin i-junan-ve? ");
INSERT INTO cakSNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri vinak reꞌ xa i-junan quiqꞌuin ri acꞌolaꞌ ri ncaꞌcꞌujieꞌ pa tak bꞌay, ri can ncaꞌsiqꞌuin ncaꞌchꞌoꞌ chiquivach antok ncaꞌtzꞌan, y niquiꞌej: Xkaxupuj flautas chivach y man xixxajo ta. Xkabꞌixaj bꞌix richin bꞌis chivach y man xixuokꞌ ta. Quireꞌ niquiꞌej ri acꞌolaꞌ chupan ri atzꞌanien. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ruma antok xalka ri Juan el Bautista, jajaꞌ man xucꞌux ta simíta ni man xukun ta jeꞌ vino. Y ixreꞌ ntiꞌej chi jajaꞌ cꞌo itziel espíritu riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y vacame xalka ri Xtak-pa chicaj chi xalax chiꞌicajol, nutej utzulaj tak teꞌj y nukun jeꞌ vino, y ixreꞌ ntiꞌej chi joꞌc vaꞌen nrajoꞌ, y ntiꞌej chi jun kꞌabꞌariel, qui-amigo ri maloy-impuestos y qui-amigo ri vinak ri aj-bꞌanoy-pecado. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri runoꞌj ri Dios can kꞌalaj pa quicꞌaslien quinojiel ri ncaꞌniman richin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y cꞌo jun ache fariseo xuꞌon rogar choch ri Jesús chi nivaꞌ chirachuoch. Y antok ri Jesús xuoc-oc pa rachuoch ri ache, xtzꞌuye-apa chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupan ri tanamet, jun ixok ri itziel rucꞌaslien xunaꞌiej chi ri Jesús cꞌo chirij mesa chirachuoch ri jun ache fariseo. Rumareꞌ jajaꞌ xalka chireꞌ rucꞌamun-pa jun frasco ri bꞌanun cha alabastro y cꞌo jun jubꞌul akꞌuon chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y ri ixok reꞌ xbꞌacꞌujieꞌ cꞌa chirij ri Jesús chirakan, altíra ntuokꞌ. Y ri ruyaꞌl nakꞌaroch ri ixok reꞌ ncaꞌka-ka chirij rakan ri Jesús. Jajaꞌ ncaꞌrusuꞌ rakan ri Jesús cha ri ruveꞌ, y ncaꞌrutzꞌubꞌaj jeꞌ ri rakan, y nuyaꞌ jeꞌ ri jubꞌul akꞌuon chirij ri rakan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y antok ri ache fariseo ri xbꞌano invitar richin ri Jesús xutzꞌat ri xuꞌon ri ixok, xuꞌon-ka pensar: Xa ta ketzij chi profeta, nunaꞌiej ri chica nitzꞌamo la rakan y ri chica chi ixok la. Ruma la jun ixok la xa itziel rucꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Y ri Jesús xuꞌej cha ri ache fariseo: Simón, cꞌo jun kax ri nivajoꞌ niꞌej chava. Ri Simón xuꞌej cha: Taꞌej cꞌa Maestro. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y ri Jesús xuꞌej cha: Jun ache ri niyoꞌn miera pa kajic icꞌo icaꞌyeꞌ achiꞌaꞌ ri quibꞌanun quicꞌas riqꞌuin. Jun chiquivach, quinientos denarios rucꞌas, y ri jun chic, cincuenta denarios rucꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero ruma ri achiꞌaꞌ reꞌ man ncaꞌtiquir ta niquitzoliej ri quicꞌas, ri ache ri yaꞌyuon ri miera pa kajic xuꞌej chica: Xa tiqꞌuis chireꞌ, xchaꞌ chica. Y ri Jesús xuꞌej cha ri Simón ri fariseo: Taꞌej cꞌa, ¿chica chiquivach ri icaꞌyeꞌ achiꞌaꞌ reꞌ ri más xtajoꞌn richin ri ache ri niyoꞌn miera pa kajic? ");
INSERT INTO cakSNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xuꞌej: Inreꞌ niꞌej chi ja ri más qꞌuiy rucꞌas. Y ri Jesús xuꞌej cha ri Simón: Jaꞌ, quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y ri Jesús xutzꞌat-apa ri ixok antok xuꞌej cha ri Simón ri fariseo: ¿Natzꞌat ri ixok la? Antok inreꞌ xinuoc-pa pan avachuoch, man xayaꞌ ta nuyaꞌ chi xchꞌaj vakan. Pero ri ixok reꞌ xaꞌruchꞌaj ri vakan riqꞌuin ri ruyaꞌl nakꞌaroch, y xaꞌrusuꞌ cha ri ruveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Quireꞌ jeꞌ antok xinuoc-pa, man xinatzꞌubꞌaj ta chi xinaꞌan saludar. Pero ri ixok reꞌ, xa-jan antok xinuoc-pa, man nitanieꞌ ta chi nutzꞌubꞌaj ri vakan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Atreꞌ man xakꞌej ta aceite pa nujaluon antok xinuoc-pa. Pero ri ixok la, jun jubꞌul akꞌuon ri xuyaꞌ chirij ri vakan. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Rumareꞌ niꞌej chava atreꞌ Simón, chi ri qꞌuiy ru-pecados ri i-rubꞌanun ncaꞌan perdonar, ruma altíra nrajoꞌ ri xbꞌano perdonar ri ru-pecados. Pero ri man qꞌuiy ta ru-pecados ri niꞌan perdonar, xa man can ta nrajoꞌ ri xbꞌano perdonar ri ru-pecados. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y ri Jesús xuꞌej cha ri ixok: Ri a-pecados xaꞌan perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y ri vinak ri junan i-tzꞌuyul riqꞌuin ri Jesús chirij ri mesa, niquiꞌej chiquivach: ¿Chica chi ache va, chi nuꞌon jeꞌ perdonar pecados? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xuꞌej cha ri ixok: Ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin, xacolotaj. Vacame caꞌin en paz. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Después ri xbꞌanataj reꞌ, ri Jesús xꞌa nojiel tanamet y aldeas, y nutzijuoj ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, y ri doce (cabꞌalajuj) discípulos i-bꞌanak riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y icꞌo jeꞌ nicꞌaj ixokiꞌ ri i-bꞌanak chirij, ri xaꞌlasas-el itziel tak espíritus quiqꞌuin y ri i-rubꞌanun sanar riqꞌuin yabꞌil. Chiquicajol ri ixokiꞌ reꞌ bꞌanak ri María, ri niꞌeꞌx jeꞌ Magdalena cha, ri xaꞌlasas-el i-siete (ivukuꞌ) itziel tak espíritus riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Y bꞌanak ri Juana, raxjayil ri ache Chuza rubꞌeꞌ. Y ri ache reꞌ jun rusamajiel ri Herodes. Bꞌanak jeꞌ ri Susana. Y icꞌo jeꞌ nicꞌaj chic ixokiꞌ ri niquiꞌan servir ri Jesús riqꞌuin ri cꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Altíra iqꞌuiy vinak xquimol-ka-quiꞌ riqꞌuin ri Jesús ri i-patanak nicꞌaj chic tanamet. Y jajaꞌ xuꞌej jun parábola (cꞌambꞌal-tzij) chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Cꞌo jun ache ri xꞌa chi xbꞌaruquiraj ijaꞌtz. Y antok ri ache nuquiraj ri ijaꞌtz, cꞌo ijaꞌtz xaꞌka pa bꞌay, y ri vinak ncaꞌkꞌax paroꞌ. Y xaꞌpa ri chicop ri cꞌo quixicꞌ, xquimol-el ri ijaꞌtz. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Nicꞌaj chic ijaꞌtz xaꞌka chiquicajol abꞌaj y xaꞌiel-pa, pero xaꞌchakej-ka ruma man rax ta ri ulief ri pacheꞌ xaꞌka-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nicꞌaj chic ijaꞌtz xaꞌka chiquicajol tak qꞌuix. Y antok xaꞌiel-pa, junan xaꞌqꞌuiy quiqꞌuin ri qꞌuix, y xaꞌjiekꞌ chiquicajol ri qꞌuix. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y ri nicꞌaj chic ijaꞌtz xaꞌka pan utzulaj ulief, y jaꞌal xaꞌqꞌuiy-pa y xquiyaꞌ a cien quivach, xchaꞌ. Y antok ri Jesús xuqꞌuis rubꞌixic ri tzij reꞌ, cof xchꞌoꞌ y xuꞌej: Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y ri ru-discípulos xquicꞌutuj cha ri Jesús: ¿Chica nuꞌej ri jun parábola (cꞌambꞌal-tzij) reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y jajaꞌ xuꞌej chica: Chiva ixreꞌ yoꞌn permiso chi ntinaꞌiej chirij ri ru-reino ri Dios. Pero chica ri vinak ri man nquinquinimaj ta, xa riqꞌuin parábolas (cꞌambꞌal-tzij) nquichꞌo-ve chica, chi quireꞌ xa choj niquitzꞌat y man niquiyaꞌ ta pa cuenta ri niquitzꞌat, y joꞌc nicaꞌxaj y man xtiꞌka ta pa quiveꞌ (man xtiquiꞌan ta entender) ri nicaꞌxaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y quireꞌ nuꞌej ri parábola (cꞌambꞌal-tzij): Ri ijaꞌtz ja ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri ijaꞌtz ri xaꞌka pa bꞌay, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios y ri diablo chaꞌnin nipa, y nralasaj-el ri ruchꞌabꞌal ri Dios riqꞌuin cánima, chi quireꞌ man niquinimaj ta ri Dios, y man ncaꞌcolotaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ri ijaꞌtz ri xaꞌka chiquicajol abꞌaj, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios y can altíra ncaꞌquicuot antok niquiꞌan recibir. Pero ruma manak ruxieꞌ ri ruchꞌabꞌal ri Dios riqꞌuin cánima, rumareꞌ man ncaꞌlayuj ta ncaꞌquicuot, joꞌc jun janeꞌ oc (jaroꞌ oc) kꞌij niquinimaj. Y antok nipa ri prueba, chaꞌnin niquiyaꞌ can ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ijaꞌtz ri xaꞌka chiquicajol tak qꞌuix, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios, pero antok ncaꞌin chupan ri quicꞌaslien, xa ncaꞌjiekꞌ ruma ja ri nicꞌatzin chica kꞌij-kꞌij choch-ulief, ri quibꞌayomal y ri ncaꞌquirayij, joꞌc reꞌ ninataj chica, y man jun fruto niquiyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y ri ijaꞌtz ri xaꞌka pan utzulaj ulief, jareꞌ ri nicaꞌxaj ri ruchꞌabꞌal ri Dios y niquiꞌan ri nuꞌej. Ijejeꞌ quiyoꞌn cánima riqꞌuin ri Dios y jaꞌal quivach niquiyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Man jun vinak nutzej jun lámpara y nutzꞌapij o nuyaꞌ ta oc chuxieꞌ ruchꞌat. Ri lámpara reꞌ nuyaꞌ jun lugar chicaj chi quireꞌ ri ncaꞌuoc pa jay jaꞌal niquitzꞌat ri sakil. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y man jun kax ri avan-can, ri man ta xtikꞌalajin-pa. Y man jun kax jeꞌ ri tzꞌapin can rij, ri man ta xtikꞌalajin-pa y man ntiel ta pa choch sakil. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Tivaxaj cꞌa otz, ruma ri cꞌo riqꞌuin, xtiyoꞌx más cha. Pero ri xa man qꞌuiy ta cꞌo riqꞌuin, hasta ri janeꞌ (jaroꞌ) nuꞌon pensar chi nicꞌujieꞌ riqꞌuin xtalasas-el cha, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y ri rutieꞌ y ri i-ruchakꞌ ri Jesús xaꞌpa cꞌa pacheꞌ cꞌo-ve jajaꞌ. Pero man xaꞌtiquir ta xaꞌbꞌaka cꞌa riqꞌuin, ruma iqꞌuiy vinak quimaluon-quiꞌ riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y xꞌeꞌx-apa cha ri Jesús: Ri atieꞌ y ri achakꞌ icꞌo juviera y nicajoꞌ ncatquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero ri Jesús xuꞌej: Ri ntieꞌ y ri nchakꞌ ja ri ncaꞌcꞌaxan y niquiꞌan ri nuꞌej ri ruchꞌabꞌal ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y jun kꞌij ri Jesús xuoc chupan jun barco junan quiqꞌuin ri ru-discípulos y xuꞌej chica: Kojakꞌax-apa jucꞌan chic ruchiꞌ ri lago. Y xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y antok i-bꞌanak-apa, ri Jesús xvar-ka y jun arapienta xpa jun nem cakꞌiekꞌ paroꞌ ri lago. Rumareꞌ ri barco ri pacheꞌ i-bꞌanak-ve, xa ninuoj-pa chi yaꞌ y jubꞌaꞌ ma niꞌa-ka chuxieꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Y xaꞌpa ri discípulos, xquicꞌasuoj ri Jesús y xquiꞌej cha: ¡Maestro, Maestro, vacame nkucon! xaꞌchaꞌ cha. Y ri Jesús xpalaj-pa y xchꞌolin cha ri cakꞌiekꞌ y cha ri yaꞌ. Y ri cakꞌiekꞌ xqꞌuis-el ruchukꞌaꞌ y xtanie-ka jeꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Y ri Jesús xuꞌej chica ri ru-discípulos: ¿Karruma man xicukubꞌaꞌ ta icꞌuꞌx viqꞌuin? Pero ri discípulos quixiꞌin-quiꞌ. Can xaꞌchapataj antok xquitzꞌat ri xbꞌanataj, y niquiꞌej chiquivach: ¿Chica cꞌa chi ache va chi ncaꞌruꞌon mandar ri cakꞌiekꞌ y ri yaꞌ, y ncaꞌniman cha? ");
INSERT INTO cakSNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Y ri Jesús y ri ru-discípulos xaꞌbꞌaka jucꞌan chic ruchiꞌ ri lago, chupan ri lugar rubꞌinan Gadara, ri cꞌo-apa choch ri Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y antok ri Jesús xiel-pa chupan ri barco, xalka jun ache riqꞌuin ri cꞌo nak pa tanamet. Y ri ache reꞌ ya qꞌuiy tiempo ri icꞌo itziel tak espíritus riqꞌuin. Rumareꞌ man jun rutziak nucusaj, ni man nicꞌujieꞌ ta chirachuoch. Xa ja ri cementerio ri acunak rachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y ri ache reꞌ joꞌc xutzꞌat ri Jesús, xurak ruchiꞌ y xbꞌaxuquieꞌ chukul rakan. Y riqꞌuin ruchukꞌaꞌ nichꞌo-apa cha ri Jesús, y nuꞌej: ¿Chica navajoꞌ chuva Jesús ri Rucꞌajuol ri Namalaj Dios? Tabꞌanaꞌ jun favor man quinachꞌujirisaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ri ache xuꞌej quireꞌ ruma ri Jesús ruꞌeꞌn chic cha ri itziel espíritu ri cꞌo riqꞌuin chi tiel-el. Ruma ya qꞌuiy tiempo ticꞌujieꞌ riqꞌuin. Y qꞌuiy mul ri vinak quiyoꞌn chꞌichꞌ y cadenas (yariena) chirij rukꞌa-rakan ri ache reꞌ, pero man i-tiquirnak ta chirij. Ruma ri ache reꞌ ncaꞌrukꞌochpij ri cadenas (yariena) ri choj cha tzꞌamuon-ve, y ri itziel espíritu ri cꞌo riqꞌuin nuꞌon cha chi niꞌa pa tak lugares desiertos. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xucꞌutuj cha: ¿Cheꞌl abꞌeꞌ? Y jajaꞌ xuꞌej-pa: Legión nubꞌeꞌ. Ruma iqꞌuiy ri itziel tak espíritus ri icꞌo riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y xquicꞌutuj cꞌa favor cha ri Jesús chi man caꞌrutak-el chupan ri jul ri man niqꞌuis ta rakan ri can kꞌakuꞌn rupan, ri qui-lugar ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y chireꞌ, paroꞌ jun juyuꞌ, iqꞌuiy ak ncaꞌvaꞌ, rumareꞌ ri itziel tak espíritus xquicꞌutuj favor cha ri Jesús chi tuyaꞌ permiso chica chi ncaꞌuoc quiqꞌuin ri ak reꞌ. Y ri Jesús xuyaꞌ permiso chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y ri itziel tak espíritus ja xaꞌiel-el riqꞌuin ri ache, y xaꞌbꞌaꞌuoc quiqꞌuin ri ak. Y quinojiel ri ak reꞌ jun-anin xaꞌbꞌaxulie-pa choch jun juyuꞌ can paꞌl-roch, y cꞌa chupan ri lago xaꞌbꞌaka-ve; y chireꞌ xaꞌjiekꞌ-ve quinojiel ri ak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y ri ncaꞌchajin quichin ri ak, antok xquitzꞌat ri xbꞌanataj, xaꞌnumaj; y xbꞌaquitzijuoj ri xbꞌanataj pa tanamet y pa tak avan. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y ri vinak xaꞌpa cꞌa chi nalquitzꞌataꞌ ri chica xbꞌanataj. Y antok xaꞌlka riqꞌuin ri Jesús, xquitzꞌat chi ri ache ri xaꞌlasas-el ri itziel tak espíritus riqꞌuin; tzꞌuyul chirakan ri Jesús, rucusan rutziak y man nuꞌon ta chic cꞌa ri incheꞌl rubꞌanun-pa. Rumareꞌ ri vinak xa xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y ri vinak ri xaꞌtzꞌato ri xbꞌanataj, xquitzijuoj cꞌa chica ri nicꞌaj chic vinak chi cheꞌl xaꞌlasas ri itziel tak espíritus riqꞌuin ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Entonces ri vinak aj-Gadara y ri icꞌo cierca, xquicꞌutuj favor cha ri Jesús chi tiel-el chireꞌ Gadara, ruma altíra quixiꞌin-quiꞌ. Rumareꞌ ri Jesús xuoc-oc chupan ri barco richin chi niꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y ri ache ri xaꞌlasas-el ri itziel tak espíritus riqꞌuin, nucꞌutuj favor cha ri Jesús chi niꞌa riqꞌuin. Pero ri Jesús xuꞌon can despedir y xuꞌej can cha: ");
INSERT INTO cakSNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzalaj chavachuoch y atzijuoj ri nem samaj ri xuꞌon ri Dios aviqꞌuin, xucheꞌx. Y ri ache xꞌa cꞌa chupan ri tanamet, y xutzꞌom rutzijoxic ri nem samaj ri xuꞌon ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y antok ri Jesús xtzalaj chic cꞌa pa jucꞌan ruchiꞌ ri lago, ri altíra iqꞌuiy vinak ri icꞌo chireꞌ can ncaꞌquicuot xquicꞌul-apa, ruma ri vinak reꞌ can jajaꞌ ri quiyoꞌien. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jareꞌ antok xalka jun ache rubꞌinan Jairo. Ri ache reꞌ principal chupan ri sinagoga, y xbꞌaxuquieꞌ chukul rakan ri Jesús, y xuꞌon rogar choch chi tiꞌa riqꞌuin chirachuoch, ");
INSERT INTO cakSNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ruma joꞌc jun oc rumiꞌal cꞌo, ri cꞌo laꞌk doce (cabꞌalajuj) rujunaꞌ y ya nicon. Y antok ri Jesús bꞌanak, iqꞌuiy vinak i-bꞌanak chirij y mareꞌ niquipitzꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicajol cꞌa ri vinak, bꞌanak jun ixok ri cꞌo doce (cabꞌalajuj) junaꞌ ri ntiel ruquiqꞌuiel y man nitanieꞌ ta, ruma jun yabꞌil. Ya xuqꞌuis nojiel ri ru-miera chiquivach iqꞌuiy doctores, y man jun chiquivach ijejeꞌ tiquirnak ta rukꞌoman ri ruyabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok reꞌ xjiel-apa chirij ri Jesús y xutzꞌom-apa ri ruchi-rutziak, y chaꞌnin xtanieꞌ ri ruquiqꞌuiel ri ntiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y ri Jesús xuꞌej: ¿Chica xtzꞌamo-pa vichin? Quinojiel niquiꞌej chi ijejeꞌ man xquitzꞌom ta, rumareꞌ ri Pedro y ri nicꞌaj chic discípulos xquiꞌej cha ri Jesús: Maestro, iqꞌuiy vinak ncatquipitzꞌ y niquinimila-quiꞌ chavij, y atreꞌ naꞌej: ¿Chica xtzꞌamo-pa vichin? ");
INSERT INTO cakSNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero ri Jesús xuꞌej: Cꞌo jun ri xirutzꞌom-pa, ruma xinnaꞌ chi cꞌo poder xiel viqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Antok ri ixok xutzꞌat chi xnaꞌax, xpa cꞌa nibꞌarbꞌuot y xalxuquieꞌ chukul rakan ri Jesús. Y chiquivach quinojiel ri vinak xuꞌej-apa cha ri Jesús karruma xutzꞌom ruchi-rutziak. Y xuꞌej jeꞌ chi antok xutzꞌom ri ruchi-rutziak, can ja xunaꞌ chi xꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Y ri Jesús xuꞌej cha: Numiꞌal, xacꞌachoj ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin. Vacame caꞌin en paz, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y cꞌa nitzijuon ri Jesús riqꞌuin ri ixok, antok cꞌo jun xalka ri patanak chirachuoch ri ache principal chupan ri sinagoga. Ri jun reꞌ xalruꞌej cha ri ache principal: Ri amiꞌal ya xcon, man chic taꞌan molestar ri Maestro. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero ri Jesús xraꞌxaj, y xuꞌej cha: Man taxiꞌij-aviꞌ, joꞌc tanimaj, y ri amiꞌal xticꞌastaj chic, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y antok xalka chirachuoch ri Jairo, ri Jesús man xuyaꞌ ta permiso chi xaꞌuoc pa jay nicꞌaj chic vinak, xa joꞌc ri Pedro, ri Jacobo, ri Juan, y ri rutie-rutataꞌ ri chꞌiti xtan ri quiminak chic. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Quinojiel altíra ncaꞌuokꞌ y ncaꞌbꞌisuon chirij ri chꞌiti xtan reꞌ. Pero ri Jesús xuꞌej chica: Man chic quixuokꞌ, ruma ri chꞌiti xtan xa man quiminak ta, xa nivar, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero ijejeꞌ xa xaꞌtzeꞌn chirij ri Jesús, ruma cataꞌn chi xa quiminak chic ri chꞌiti xtan. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y ri Jesús xutzꞌom rukꞌaꞌ ri chꞌiti xtan y xuꞌej: Nóya, capalaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ri chꞌiti xtan can xtzalaj-pa ri ru-espíritu riqꞌuin, y can ja xpalaj-pa chaꞌnin. Y ri Jesús xuꞌej chi tiyoꞌx ruvay. ");
INSERT INTO cakSNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y ri rutie-rutataꞌ, can xaꞌchapataj antok xquitzꞌat ri xbꞌanataj. Pero ri Jesús xuꞌon mandar chica chi man jun choj cha tiquitzijuoj ri xbꞌanataj chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xaꞌrayuoj ri i-doce (cabꞌalajuj) ru-discípulos, y xuyaꞌ poder y autoridad chica chi ncaꞌtiquir ncaꞌquilasaj nojiel quivach itziel tak espíritus, y chi niquiꞌan sanar nojiel roch yabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xaꞌrutak-el chi xbꞌaquitzijuoj ri ru-reino ri Dios, y chi ncaꞌquiꞌan sanar ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y ri Jesús xuꞌej jeꞌ chica: Antok xquixꞌa, man jun kax tivucꞌuaj. Man tivucꞌuaj ichꞌameꞌy, ni man tivucꞌuaj i-buolsa, ni simíta, ni miera, ni man tivucꞌuaj jun chic jal itziak. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y chica-na jay pacheꞌ nquixuoc-ve, chireꞌ quixcꞌujie-ve-ka. Xa cꞌajaꞌ antok nquixiel-pa chupan ri tanamet, cꞌajareꞌ xtiyaꞌ can ri jay ri pacheꞌ xixcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y pacheꞌ na man nquixꞌan ta recibir, quixiel-pa chupan ri tanamet y titotaꞌ can ri pokolaj ri cꞌo pa tak ivakan chiquivach ri vinak reꞌ, chi quireꞌ niquitzꞌat chi man otz ta ri xquiꞌan, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y ri discípulos xaꞌa y xaꞌkꞌax ri pa tak aldeas chi xbꞌaquitzijuoj ri evangelio. Y ri pacheꞌ xaꞌkꞌax-ve, xaꞌquiꞌan jeꞌ sanar quinojiel ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y ri Herodes ri gobernador xraꞌxaj nojiel ri ncaꞌruꞌon ri Jesús. Pero vor chica xtunimaj, ruma icꞌo ncaꞌeꞌn: Ri Juan el Bautista xa xcꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Icꞌo ncaꞌeꞌn chi ja ri Elías ri xtzalaj-pa. Y nicꞌaj chic niquiꞌej chi jun chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, ri xbꞌacꞌastaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y ri Herodes xuꞌej: Inreꞌ ri xiꞌeꞌn chi xcꞌamar-el rujaluon ri Juan el Bautista, ¿chica came ache reꞌ ri qꞌuiy nivaꞌxaj chirij? Y ri Herodes xucanuj manera chi nutzꞌat ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y antok ri ru-apóstoles ri Jesús xaꞌtzalaj-pa, xquiꞌej cha nojiel ri chica xquiꞌan. Y jajaꞌ xaꞌrucꞌuaj y xaꞌa chupan jun lugar pacheꞌ manak vinak richin ri tanamet rubꞌinan Betsaida. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y antok ri vinak xquinaꞌiej chi xꞌa ri Jesús, xaꞌa chirij. Y antok ri vinak reꞌ xaꞌbꞌaka riqꞌuin, jajaꞌ xaꞌruꞌon recibir y xuꞌej jeꞌ chica chirij ri ru-reino ri Dios. Y xaꞌruꞌon jeꞌ sanar ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Pero antok ya nika-ka ri kꞌij, ri doce (cabꞌalajuj) apóstoles xaꞌjiel-apa riqꞌuin ri Jesús y xquiꞌej cha: Caꞌtakaꞌ cꞌa el ri vinak chi caꞌa pa tak aldeas y nicꞌaj chic lugar ri icꞌo cierca, chi niquicanuj pacheꞌ ncaꞌbꞌavar-ve, y ri chica niquitej, ruma ri pacheꞌ ojcꞌo-ve xa manak jay, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero ri Jesús xuꞌej chica: Tiyaꞌ ixreꞌ chi ncaꞌvaꞌ. Y ijejeꞌ xquiꞌej cha: Kiqꞌuin ojreꞌ xa joꞌc vuꞌuoꞌ simíta y caꞌyeꞌ car cꞌo. Ri vinak reꞌ ncaꞌvaꞌ, pero xa nkuꞌa chulokꞌic ri chica niquitej, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Y ri achiꞌaꞌ icꞌo laꞌk vuꞌuoꞌ mil. Y ri Jesús xuꞌej chica ri ru-discípulos: Tibꞌanaꞌ chica ri vinak chi caꞌtzꞌuye-ka chi nicꞌaj tak ciento, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y quireꞌ xquiꞌan, xaꞌquitzꞌuyubꞌaꞌ quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y ri Jesús xutzꞌom ri vuꞌuoꞌ simíta y ri caꞌyeꞌ car, xtzuꞌn chicaj, y xuꞌon bendecir, y xaꞌruper ri simíta y ri car, y xuyaꞌ chica ri ru-discípulos chi niquijach chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Y quinojiel jaꞌal xaꞌvaꞌ, y otz xnuoj quipan. Y cꞌa cꞌo doce (cabꞌalajuj) chacach ri xaꞌnuoj riqꞌuin ri jutak pir ri xmuol can ri xuꞌon suobra. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y jun kꞌij ri Jesús cꞌo aparte chi nuꞌon orar, y ri ru-discípulos icꞌo jeꞌ riqꞌuin. Y jareꞌ antok ri Jesús xucꞌutuj chica ri ru-discípulos: ¿In chica inreꞌ niquiꞌej ri vinak? ");
INSERT INTO cakSNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y ijejeꞌ xquiꞌej cha: Icꞌo ncaꞌeꞌn chi atreꞌ ri Juan el Bautista. Icꞌo nicꞌaj chic ncaꞌeꞌn chi atreꞌ ri Elías. Y icꞌo jeꞌ ncaꞌeꞌn chi atreꞌ at jun chic chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, y vacame xbꞌacꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y jajaꞌ xucꞌutuj chica: ¿Y ixreꞌ, in chica inreꞌ ntiꞌej? Y ri Pedro xuꞌej cha ri Jesús: Ri Cristo, ri at-takuon-pa ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús xuꞌon mandar chica chi man jun choj cha tiquiꞌej-ve chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xuꞌej jeꞌ chica: Ri Xtak-pa chicaj chi xalax chiꞌicajol, nicꞌatzin chi nukꞌasaj qꞌuiy sufrimiento, y itziel xtitzꞌiet cuma ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, cuma ri principales sacerdotes y cuma ri achiꞌaꞌ escribas; y xtiquimisas, pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y chica quinojiel xuꞌej: Vi xa cꞌo jun nrajoꞌ niꞌa chuvij, man tuꞌon ri nurayij jajaꞌ, y can tutzꞌamaꞌ y tucꞌuaj ri ru-cruz. Xa quireꞌ nuꞌon kꞌij-kꞌij, otz tipa viqꞌuin chi niꞌa chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ruma xa cꞌo jun ri altíra nrajoꞌ ri rucꞌaslien vaveꞌ ri choch-ulief, man xticolotaj ta. Pero ri jun, mesque niquimisas vuma inreꞌ, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Y ¿chica nuchꞌec jun vinak xa nicꞌujieꞌ ta riqꞌuin nojiel ri bꞌayomal ri cꞌo choch-ulief y xa man nicolotaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ruma xa cꞌo jun ri niqꞌuix pa nu-cuenta y ruma ri nutzij, ri Xtak-pa chicaj chi xalax chiꞌicajol can xtiqꞌuix jeꞌ pa ru-cuenta ri jun reꞌ. Quireꞌ xtuꞌon antok xtipa chic jun bꞌay, junan chic ru-gloria riqꞌuin ri Rutataꞌ, i-richꞌilan-pa ri santos ángeles. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y can ketzij ri niꞌej chiva, chi icꞌo jujun chivach ixreꞌ ri man xcaꞌcon ta yan, cꞌa xtiquitzꞌat-na ri ru-reino ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y xakꞌax yan laꞌk jun semana ri tichꞌoꞌ ri Jesús chiquivach ri vinak, jajaꞌ xaꞌrucꞌuaj ri Pedro, ri Juan y ri Jacobo chi junan xꞌa quiqꞌuin paroꞌ jun juyuꞌ chi xbꞌarubꞌanaꞌ orar. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y antok ri Jesús nuꞌon orar, xcꞌaxtaj rutzubꞌal, y ri rutziak jeꞌ altíra sak xuꞌon y nichꞌichꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y jareꞌ antok ncaꞌtzijuon yan chic riqꞌuin ri Jesús icaꞌyeꞌ achiꞌaꞌ; jun ja ri Moisés y ri jun chic ja ri Elías. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ri icaꞌyeꞌ reꞌ icꞌo chupan jun namalaj sakil, y ncaꞌtzijuon chirij ri camic ri xtukꞌasaj ri Jesús chupan ri tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y ri Pedro y ri icaꞌyeꞌ chic, mesque cꞌo quivaran, xquicochꞌ, y xquitzꞌat ri namalaj rusakil ri Jesús, y xaꞌquitzꞌat jeꞌ ri icaꞌyeꞌ chic achiꞌaꞌ ri icꞌo riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y antok ri icaꞌyeꞌ achiꞌaꞌ reꞌ ja niquiyaꞌ can ri Jesús chi ncaꞌa, ri Pedro xuꞌej cha ri Jesús: Maestro, otz chi ojcꞌo vaveꞌ ojreꞌ, nakaꞌan oxeꞌ chꞌitak enramadas, jun avichin atreꞌ, jun richin ri Moisés y jun richin ri Elías. Pero ri Pedro man rataꞌn ta ri chica ncaꞌruꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y cꞌa nichꞌoꞌ jajaꞌ cha ri Jesús antok jun mukul xka-pa pa quiveꞌ. Y ri discípulos xquixiꞌij-quiꞌ antok xquinaꞌ chi icꞌo yan chic chupan ri mukul. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y chupan ri mukul reꞌ, cꞌo Jun ri xchꞌo-pa y xuꞌej: Jareꞌ ri Nucꞌajuol y altíra nivajoꞌ. Can tivaxaj ri nuꞌej jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y antok caxan chic ri xchꞌo-pa, xquitzꞌat chi ri Jesús xa ruyuon chic cꞌo can. Y qꞌuiy tiempo xakꞌax, ijejeꞌ man jun choj cha xquiꞌej-ve ri xquitzꞌat chireꞌ paroꞌ ri juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y chucaꞌn kꞌij, antok ri Jesús y ri iyoxeꞌ discípulos xaꞌka-pa paroꞌ ri juyuꞌ, can altíra iqꞌuiy vinak ri xaꞌcꞌulu-apa quichin. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y jun ache ri cꞌo chiquicajol ri vinak, xchꞌo-apa cha ri Jesús y xuꞌej: Maestro, inreꞌ joꞌc jun valcꞌual cꞌo. Tabꞌanaꞌ favor tatzꞌataꞌ bꞌaꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ruma cꞌo jun itziel espíritu nitzꞌamo richin. Y antok nutzꞌom, nuꞌon cha chi altíra nisiqꞌuin, y nuquiyicaꞌ ri ru-cuerpo, y nuꞌon jeꞌ cha chi ntiel ruvakuol pa ruchiꞌ, y bien golpeado nuꞌon cha. Ri itziel espíritu reꞌ quireꞌ nuꞌon cha ri nucꞌajuol, y cꞌarunaj nuyaꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Rumareꞌ xincꞌutuj yan favor chica ri a-discípulos chi tiquilasaj-el ri itziel espíritu reꞌ, pero man xaꞌtiquir ta, xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y ri Jesús xuꞌej: ¡Man jun vinak chupan ri tiempo vacame ruyoꞌn ta ránima riqꞌuin ri Dios, xa quinojiel i-sachnak! ¿Ixreꞌ ntiꞌan pensar chi inreꞌ nojiel kꞌij xquicꞌujieꞌ iviqꞌuin y xquixcochꞌ? Tacꞌama-pa ri acꞌajuol vaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y antok ri alaꞌ nijiel-apa riqꞌuin ri Jesús, ri itziel espíritu riqꞌuin ruchukꞌaꞌ xuchꞌikilaꞌ ri alaꞌ y xutzak-ka pan ulief. Ri Jesús xchꞌolin cha ri itziel espíritu chi tiel-el riqꞌuin ri alaꞌ. Y ri Jesús xuꞌon sanar ri alaꞌ reꞌ, y xuya-el cha ri rutataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y quinojiel ri vinak xaꞌchapataj antok xquitzꞌat chi ri Dios can nem-ve ru-poder. Y antok ri vinak ncaꞌtzijuon chiquivach ruma xaꞌchapataj chirij nojiel ri ncaꞌruꞌon ri Jesús, jajaꞌ xuꞌej chica ri ru-discípulos: ");
INSERT INTO cakSNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tivaxaj jaꞌal ri tzij ri xtinꞌej, y man timastaj chiva: Ri Xtak-pa chicaj chi xalax chiꞌicajol can xtijach pa quikꞌaꞌ ri vinak, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero ri discípulos xa man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) ri xꞌeꞌx chica, ruma avan chiquivach chi man tiꞌka pa quiveꞌ (man tiquiꞌan entender). Y niquixiꞌij-quiꞌ niquicꞌutuj cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ri ru-discípulos ri Jesús xquitzꞌom cꞌa quiꞌ chi tzij chiquivach, chi chica chiquivach ijejeꞌ ri xtuoc ri más nem. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ri Jesús can rataꞌn ri chica niquiꞌej pa tak cánima ri ru-discípulos. Rumareꞌ jajaꞌ xbꞌaruma-pa jun acꞌual y xupabꞌaꞌ riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y xuꞌej chica ri ru-discípulos: Chica-na ri nuꞌon recibir jun acꞌual incheꞌl va pa nubꞌeꞌ, xa can inreꞌ nquiruꞌon recibir. Y chica-na ri nquiruꞌon recibir inreꞌ, can nuꞌon recibir ri takayuon-pa vichin. Pero chiꞌicajol ixreꞌ, ri más chꞌuteꞌn, xa jareꞌ ri más nem, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpa ri Juan xuꞌej cha ri Jesús: Maestro, cꞌo jun ache xkatzꞌat, ri pan abꞌeꞌ atreꞌ ncaꞌralasaj itziel tak espíritus. Pero ruma xa man kiqꞌuin ta ojreꞌ cꞌo-ve, mareꞌ xkaꞌan prohibir cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y ri Jesús xuꞌej cha: Man tiꞌan prohibir cha. Ruma ri man royoval ta chikij, can kiqꞌuin ojreꞌ cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y antok ya nalka ri kꞌij chi ri Jesús nitzalaj-el chicaj, jajaꞌ xuꞌon pensar chi niꞌa pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y icꞌo ri xaꞌrutak-el naꞌay choch jajaꞌ. Y ri xaꞌtak-el, xaꞌa pa jun aldea ri cꞌo Samaria, chi xbꞌaquicanuj ri pacheꞌ xtuxlan-ve y xtivaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri vinak ri icꞌo chupan ri aldea man xcajoꞌ ta xquicꞌul ri Jesús, ruma xquinaꞌiej chi xa Jerusalén bꞌanak-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Antok ri discípulos Jacobo y Juan xquinaꞌiej chi ri vinak man niquicꞌul ta ri Jesús, xquiꞌej cha: Ajaf, ¿navajoꞌ nakacꞌutuj chi tika-pa kꞌakꞌ chicaj chi ncaꞌruqꞌuis, incheꞌl xuꞌon ri profeta Elías ri xcꞌujieꞌ ojier can tiempo? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y ri Jesús xaꞌrutzꞌat y xaꞌruchꞌolij. Y xuꞌej chica: Ixreꞌ man ivataꞌn ta chica espíritu cꞌo iviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ruma ri Xtak-pa chicaj chi xalax chiꞌicajol, man xpa ta vaveꞌ choch-ulief chi ncaꞌruquimisaj vinak, jajaꞌ xpa chi ncaꞌrucol, xchaꞌ. Y ri Jesús y ri ru-discípulos xaꞌa chic jun aldea. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y antok ijejeꞌ i-bꞌanak, jun xchꞌo-pa cha ri Jesús y xuꞌej cha: Ajaf, inreꞌ nivajoꞌ nquiꞌa aviqꞌuin ri pacheꞌ na ri ncaꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Y ri Jesús xuꞌej cha: Ri utif cꞌo quijul pacheꞌ ncaꞌcꞌujie-ve; y quireꞌ jeꞌ ri chicop ri cꞌo quixicꞌ, cꞌo quisuoc. Pero ri Xtak-pa chicaj chi xalax chiꞌicajol, can man jun pacheꞌ nuxlan-ve jubꞌaꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y ri Jesús xuꞌej cha jun chic: Joꞌ viqꞌuin. Ri jun reꞌ xuꞌej cha: Ajaf, tayaꞌ permiso chuva chi naꞌay nimuk-na-el ri nataꞌ y cꞌajareꞌ nquiꞌa chavij. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ri Jesús xuꞌej cha: Tayaꞌ chi ri quiminak ncaꞌmuk cuma ri i-quiminak. Y atreꞌ, caꞌin y atzijuoj ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y cꞌo chic jun ri xꞌeꞌn cha ri Jesús: Ajaf, inreꞌ nivajoꞌ nquiꞌa chavij. Pero naꞌay, tayaꞌ permiso chuva chi ncaꞌnꞌan can despedir quinojiel ri icꞌo chupan ri vachuoch, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero ri Jesús xuꞌej cha: Ri ache ri nucꞌuan ri arado y nitzuꞌn can chirij, man otz ta ntiel ri rusamaj. Y quireꞌ jeꞌ ri vinak ri nunimaj ri Dios, man otz ta chi nutzꞌat ri ncaꞌbꞌanataj can chirij. Ruma xa quireꞌ xtuꞌon, man otz ta chi nisamaj pa ru-reino ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y antok bꞌanatajnak chic nojiel reꞌ, ri Ajaf Jesús xaꞌruchaꞌ nicꞌaj chic i-setenta achiꞌaꞌ, chi xaꞌrutak-el chi cacaꞌ ri pa tak tanamet y nicꞌaj chic lugar pacheꞌ xtiꞌka-ve jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y ri Jesús xuꞌej chica: Ri samaj can ketzij chi qꞌuiy; pero ri aj-samajiel xa man iqꞌuiy ta. Mareꞌ ticꞌutuj cha ri Rajaf ri samaj chi caꞌrutaka-pa más aj-samajiel chupan ri rusamaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y vacame nquixtak-el, xa ix incheꞌl ovejas ri nquixbꞌaka chiquicajol vinak ri incheꞌl utif. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Man tivucꞌuaj i-buolsa, ni man tivucꞌuaj i-miera, y man tivucꞌuaj jeꞌ jun chic par ixajabꞌ. Y man quixpiꞌieꞌ jeꞌ chi nquiꞌan saludar ri vinak pa tak bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y chica-na jay pacheꞌ nquixuoc-ve, naꞌay tiꞌej chica: Ja ta ri paz richin ri Dios xticꞌujieꞌ chupan ri jay va. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y xa chupan ri jay reꞌ cꞌo jun niquicuot nquixrucusaj pa rachuoch, ri paz richin ri Dios xticꞌujieꞌ riqꞌuin. Y xa manak, ri paz xa xtitzalaj-pa iviqꞌuin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ixreꞌ quixcꞌujie-ka chupan ri jay ri pacheꞌ nquixbꞌaka-ve, titijaꞌ y tikumuꞌ ri xtisipas chiva; ruma ri samajiel can nicꞌatzin chi nituoj. Y man ticꞌax ri jay pacheꞌ xixuoc-ve naꞌay. Xa chireꞌ quixcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y quireꞌ jeꞌ tibꞌanaꞌ antok nquixuoc chica-na tanamet y jaꞌal nquixꞌan recibir, titijaꞌ nojiel ri nisipas chiva, ");
INSERT INTO cakSNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","y quiꞌbꞌanaꞌ jeꞌ sanar ri ncaꞌyavaj ri icꞌo chireꞌ, y tiꞌej chica ri vinak: Xa cierca chic cꞌo-ve-pa ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero xa chupan jun tanamet pacheꞌ nquixbꞌaka-ve man otz ta nquixꞌan recibir, quixiel-el pa tak bꞌay richin ri tanamet y tiꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ri pokolaj richin ri tanamet ri cꞌo-el pa kakan, nakatotaꞌ can chivach, chi ntivatamaj chi man otz ta ri xiꞌan. Y tivatamaj jeꞌ chi xa cierca chic cꞌo-ve-pa ri ru-reino ri Dios, quixchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y inreꞌ niꞌej cꞌa chiva, chi chupan ri kꞌij antok ri vinak xcaꞌan juzgar ruma ri Dios, ri vinak richin ri tanamet pacheꞌ man xixꞌan ta recibir, más nem ri castigo ri xtika pa quiveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri aj-Sodoma. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","¡Juyeꞌ ivach ri ixcꞌo pa tanamet Corazín! ¡Juyeꞌ jeꞌ ivach ri ixcꞌo pa tanamet Betsaida! Ruma xa ta chupan ri tanamet Tiro y Sidón xaꞌan ta ri milagros ri xaꞌan chivach, ri icꞌo chireꞌ xtzalaj ta pa yan ri cánima riqꞌuin ri Dios y xquiꞌan ta ri nrajoꞌ jajaꞌ, quicusan ta chic tziak richin bꞌis, y quiyoꞌn ta chaj chiquij chi quireꞌ nitzꞌiet chi ncaꞌbꞌisuon. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero antok xtalka ri kꞌij richin ri juicio ri nuꞌon ri Dios, más nem ri castigo ri xtika pan iveꞌ, que choch ri xtiyoꞌx pa quiveꞌ ri aj-Tiro y ri aj-Sidón. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y ri icꞌo pa tanamet Capernaum niquiꞌan pensar chi ncaꞌa chicaj riqꞌuin ri Dios, pero xa man quireꞌ ta, xa cꞌa chupan ri infierno xcaꞌbꞌaka-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y chica-na ri nquixraꞌxaj ixreꞌ, can inreꞌ ri nquiraꞌxaj. Y ri jun ri man nrajoꞌ ta nquixruꞌon recibir, can inreꞌ ri man nquiruꞌon ta recibir; y ri man xquiruꞌon ta recibir inreꞌ, man nuꞌon ta recibir ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y antok xaꞌtzalaj-pa ri i-setenta achiꞌaꞌ riqꞌuin ri Jesús, altíra ncaꞌquicuot, y xalquiꞌej cha: Ajaf, ri itziel tak espíritus can xquinimaj katzij antok pan abꞌeꞌ atreꞌ xojchꞌoꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xuꞌej chica: Inreꞌ xintzꞌat chi ri Satanás xtzak-pa chicaj incheꞌl nuꞌon ri ráya. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Inreꞌ nuyoꞌn poder chiva chi nquixtiquir chirij ri ru-poder ri Satanás, y mesque nquixpiꞌieꞌ pa quiveꞌ cumatz y alacrán, man jun kax xtiquiꞌan chiva. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero ixreꞌ man quixquicuot ruma ri itziel tak espíritus nquixquinimaj. Más quixquicuot ruma tzꞌibꞌan ri ibꞌeꞌ chicaj riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y chupan ri misma huora reꞌ ri Jesús altíra xquicuot ruma ri Espíritu Santo; y xuꞌej: Inreꞌ tiox bꞌaꞌ niyaꞌ chava Nataꞌ Dios, atreꞌ ri Rajaf ri rocaj y ri roch-ulief, ruma xavavaj ri utzulaj atzij chiquivach ri vinak ri niquinaꞌ chi qꞌuiy cataꞌn. Xa ja chiquivach ri vinak ri manak-oc cataꞌn, ri incheꞌl acꞌolaꞌ, ri xacꞌut ri utzulaj atzij. Can quireꞌ Nataꞌ Dios, ruma jareꞌ ri xavajoꞌ atreꞌ, xchaꞌ ri Jesús chupan ri ru-oración. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y jajaꞌ xuꞌej jeꞌ: Ri Nataꞌ Dios nojiel ruyoꞌn-pa pa nukꞌaꞌ. Y man jun chic taꞌmayuon in chica inreꞌ, xa joꞌc ri Nataꞌ. Y man jun jeꞌ taꞌmayuon ri chica ri Nataꞌ, xa joꞌc inreꞌ ri in Rucꞌajuol, y ri choj cha xtinvajoꞌ xtincꞌut-ve inreꞌ xtiratamaj ri chica ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y ri Jesús xaꞌrutzꞌat ri ru-discípulos y joꞌc chica ijejeꞌ xuꞌej-ve: Can jaꞌal caꞌquicuot ri niquitzꞌat nojiel ri ntitzꞌat ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ruma niꞌej cꞌa chiva, chi iqꞌuiy profetas y reyes ri xaꞌcꞌujieꞌ ojier can tiempo, altíra xcajoꞌ xquitzꞌat ri ntitzꞌat ixreꞌ vacame, y man xquitzꞌat ta el. Xcajoꞌ ta jeꞌ xcaꞌxaj ri ntivaxaj ixreꞌ vacame, y man xcaꞌxaj ta el, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y cꞌo jun maestro richin ri ley xpalaj-pa y ruma nrajoꞌ nuꞌon tentar ri Jesús xuꞌej cha: Maestro, ¿chica niꞌan inreꞌ chi quireꞌ nivil ri cꞌaslien ri man niqꞌuis ta? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xuꞌej cha: ¿Chica nuꞌej ri ru-ley ri Moisés? ¿Y chica niꞌka pan aveꞌ atreꞌ (naꞌan entender atreꞌ)? ");
INSERT INTO cakSNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y ri maestro xuꞌej cha ri Jesús: Can tavajoꞌ ri Avajaf Dios, tavajoꞌ riqꞌuin nojiel avánima, tavajoꞌ riqꞌuin nojiel ri acꞌaslien, tavajoꞌ riqꞌuin nojiel ri avuchukꞌaꞌ, y tavajoꞌ jeꞌ riqꞌuin nojiel ri anoꞌj. Y can incheꞌl ri navajo-ka-aviꞌ atreꞌ, can quireꞌ jeꞌ mismo tavajoꞌ ri a-prójimo. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y ri Jesús xuꞌej cha ri ache: Can ketzij ri xaꞌej. Vacame cꞌa, xa xtaꞌan nojiel reꞌ, xtavil ri cꞌaslien ri man niqꞌuis ta, xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ri ache reꞌ xrajoꞌ chi ntiel chi otz. Rumareꞌ xucꞌutuj chic cha ri Jesús: ¿Chica ri nu-prójimo? ");
INSERT INTO cakSNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y ri Jesús xuꞌej cha ri ache: Cꞌo jun ache ri alanak-pa pa tanamet Jerusalén y xulan-ka chi niꞌka cꞌa pa tanamet Jericó. Pero xaꞌbꞌaꞌiel-pa alakꞌomaꞌ chirij pa bꞌay, y nojiel xquilakꞌaj-el cha. Hasta ri rutziak ri rucusan xquimaj-el cha. Ri alakꞌomaꞌ xaꞌa, pero altíra xquichꞌey can. Ri ache xpoqꞌuieꞌ can chireꞌ pa bꞌay casi quiminak. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y cꞌo jun sacerdote ri xxulan-pa chupan ri bꞌay reꞌ, y antok xutzꞌat chi pacꞌol ri ache pa bꞌay, ja ri jun chic ruchiꞌ ri bꞌay xakꞌax-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y quireꞌ jeꞌ jun ache levita, xxulan-pa jeꞌ chupan ri bꞌay reꞌ. Y antok ri levita reꞌ xalka cierca ri lugar reꞌ, xutzꞌat ri ache pacꞌol can, y ja ri jun chic ruchiꞌ ri bꞌay xakꞌax-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero cꞌo jun ache aj-Samaria ri xxulan-pa jeꞌ chupan ri bꞌay reꞌ, y antok xalka cierca, xutzꞌat ri ache ri pacꞌol can pa bꞌay, y altíra xujoyovaj roch. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Rumareꞌ xjiel-apa riqꞌuin, xutzꞌat chica rubꞌanun, xaꞌrukꞌomaj cha aceite de olivo y vino ri pacheꞌ socotajnak-ve, y xaꞌruxim cha tziak. Después ri ache aj-Samaria xuya-el chirij ruquiej y xucꞌuaj cꞌa pa jun posada. Y xuchajij ri jun akꞌaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chucaꞌn kꞌij antok ri aj-Samaria ya niꞌa, ja xralasaj ru-miera y xuyaꞌ can caꞌyeꞌ denarios cha ri rajaf ri posada, y xuꞌej cha: Tabꞌanaꞌ cuenta ri jun ache reꞌ. Y xa man xcaruꞌon ta ri miera reꞌ, antok inreꞌ xquitzalaj-pa, xtintoj chava nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Cꞌajareꞌ ri Jesús xucꞌutuj cha ri ache: ¿Chavach atreꞌ, chica chiquivach ri iyoxeꞌ achiꞌaꞌ ri can incheꞌl nrajo-ka-riꞌ jajaꞌ, can quireꞌ jeꞌ xrajoꞌ ri ache ri xka pa quikꞌaꞌ ri alakꞌomaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y ri ache reꞌ xuꞌej: Ja ri ache ri xjoyovan roch, xchaꞌ. Y ri Jesús xuꞌej cha: Vacame caꞌin y abꞌanaꞌ atreꞌ incheꞌl xuꞌon ri ache aj-Samaria. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y ri Jesús xutzꞌom chic rubꞌiey y xbꞌaka chupan jun aldea. Y chireꞌ chupan ri aldea reꞌ cꞌo jun ixok rubꞌinan Marta, y jajaꞌ xuꞌon recibir ri Jesús pa rachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Cꞌo jun chic ixok rubꞌinan María ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Marta. Y ri María reꞌ xtzꞌuyeꞌ chirakan ri Jesús chi nraꞌxaj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ri Marta xa man quireꞌ ta xuꞌon. Jajaꞌ xa rutzꞌamuon chꞌuꞌj riqꞌuin ri ropísa. Rumareꞌ ri Marta xjiel-apa riqꞌuin ri Jesús y xuꞌej cha: Ajaf, ¿man natzꞌat ta came chi ri María in-ruyoꞌn can nuyuon choch ri opísa? Taꞌej cha chi quirutoꞌ jubꞌaꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ri Jesús xuꞌej cha: Marta, Marta, atreꞌ qꞌuiy ri naꞌan pensar y altíra bꞌanak avánima riqꞌuin ri av-opísa. ");
INSERT INTO cakSNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero joꞌc jun kax ri más nicꞌatzin y más otz, y jareꞌ ri xuchaꞌ ri María. Y ri xuchaꞌ jajaꞌ, man jun xtimajo cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Y jun bꞌay chic, ri Jesús cꞌo jun lugar, y nuꞌon orar. Y antok xtanieꞌ riqꞌuin ri oración, jun chiquivach ri ru-discípulos xuꞌej cha: Ajaf, tacꞌutuꞌ chakavach chi nakaꞌan orar, incheꞌl ri Juan el Bautista xucꞌut chiquivach ri ru-discípulos cheꞌl niquiꞌan orar, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y ri Jesús xuꞌej chica ri ru-discípulos: Antok xtiꞌan orar, cava tiꞌej: Katataꞌ Dios ri atcꞌo chila chicaj, quinojiel ta ri vinak xtiquiyaꞌ akꞌij y nem xtiquiꞌan cha ri santo abꞌeꞌ. Y talka cꞌa ri kꞌij antok atreꞌ ri xcabꞌano reinar. Y ja ta ri navajoꞌ atreꞌ, ja ta reꞌ ri tibꞌanataj vaveꞌ ri choch-ulief, incheꞌl niquiꞌan ri icꞌo aviqꞌuin chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y tayaꞌ cꞌa ri ka-simíta ri nicꞌatzin chika kꞌij-kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y tabꞌanaꞌ perdonar ri ka-pecados ri nakaꞌan chavach, incheꞌl ncaꞌkaꞌan perdonar ojreꞌ quinojiel ri niquiꞌan itziel chika. Y man tayaꞌ lugar chi ri itziel nuꞌon chika chi nkutzak. Can kojacaloꞌ choch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y ri Jesús xuꞌej jeꞌ chica ri ru-discípulos: Xa jun chivach ixreꞌ niꞌa pa nicꞌaj-akꞌaꞌ riqꞌuin jun ru-amigo y nuꞌej ta cha: Amigo, tabꞌanaꞌ favor chuva, nijal oxeꞌ a-simíta, ");
INSERT INTO cakSNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ruma cꞌo jun nu-amigo naj patanak-ve y xalka viqꞌuin, y inreꞌ xa man jun simíta cꞌo viqꞌuin chi niya-apa cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y ri choj cha nucꞌutuj-apa ri simíta, cꞌa pa dentro xtichꞌo-pa y xtuꞌej cha: Tabꞌanaꞌ favor man quinaꞌan molestar, ruma ri ruchi-jay xa ya xintzꞌapij y ri acꞌolaꞌ xa viqꞌuin inreꞌ ncaꞌvar-ve. Rumareꞌ manak modo nquipalaj chi niya-el chava ri navajoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y ri Jesús xuꞌej chica ri ru-discípulos: Can niꞌej cꞌa chiva, chi ri choj cha ri nicꞌutux-apa ri simíta nipalaj-pa, pero man ruma ta ru-amigo riqꞌuin ri nicꞌutun-apa cha. Jajaꞌ nipalaj-pa y nuya-pa nojiel ri nicꞌatzin cha, chi quireꞌ man chic tichꞌo-apa más. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y inreꞌ niꞌej chiva ixreꞌ: Ticꞌutuj cha ri Dios ri nicꞌatzin chiva y jajaꞌ xtuya-pa chiva. Ticanuj y xtivil ri ntivajoꞌ. Ticꞌoscꞌa-apa ri ruchi-jay y xtijak chivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ruma xa jun nucꞌutuj cha ri Dios, jajaꞌ xtuya-pa cha ri nucꞌutuj. Xa jun nucanuj, can xtiril ri nucanuj. Y xa jun nucꞌoscꞌa-apa ri ruchi-jay, can xtijak choch. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","¿Cꞌo came jun tataꞌj nuyaꞌ jun abꞌaj pa rukꞌaꞌ ri ralcꞌual, antok nucꞌutuj jun simíta cha? ¿O nuyaꞌ came jun cumatz pa rukꞌaꞌ, antok xa jun car nucꞌutuj cha? ");
INSERT INTO cakSNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O nuyaꞌ came jun alacrán pa rukꞌaꞌ, antok xa jun luoꞌ ri nucꞌutuj cha? ");
INSERT INTO cakSNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mesque ixreꞌ itziel inoꞌj, pero man jun bꞌay ntiyaꞌ jun itziel kax chica ri ivalcꞌual. Ixreꞌ ja ri utzulaj tak kax ntiyaꞌ chica. ¿Cuánto más ri Itataꞌ ri cꞌo chicaj nuya-pa ri Espíritu Santo chica ri ncaꞌcꞌutun cha? ");
INSERT INTO cakSNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jun kꞌij ri Jesús xralasaj-el jun itziel espíritu miem, y antok xiel ri itziel espíritu, ri ache miem ja xchꞌoꞌ, y ri vinak can xaꞌchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero nicꞌaj chiquivach ri vinak reꞌ niquiꞌej chirij ri Jesús: Ja ri Beelzebú, ri quijaval ri itziel tak espíritus, ri nibꞌano cha chi nitiquir ncaꞌralasaj ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y nicꞌaj chic, chi niquiꞌan tentar ri Jesús, xquiꞌej cha chi tubꞌanaꞌ jun señal chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús can rataꞌn ri niquiꞌan pensar ri vinak reꞌ, mareꞌ xuꞌej chica: Xa ri vinak richin jun reino caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri reino reꞌ xa nitzak. Y quireꞌ jeꞌ chupan jun jay, xa caꞌyeꞌ grupo niquiꞌan-ka, nipa ayoval chiquicajol y ri jay reꞌ xa niqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y quireꞌ jeꞌ ri Satanás, xa nuꞌon-ka ayoval quiqꞌuin ri i-rusamajiel, xa chirij jajaꞌ mismo nuꞌon-ka ayoval. Y xa quireꞌ nuꞌon, ruyuon niquiyaꞌ can y chaꞌnin nitzak ri ru-reino. Y ixreꞌ ntiꞌej chi inreꞌ cꞌo ri Beelzebú viqꞌuin y rumareꞌ ncaꞌnvalasaj ri itziel tak espíritus. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Xa inreꞌ ruma ri ru-poder ri Beelzebú ncaꞌnvalasaj ri itziel tak espíritus, ¿chica xyoꞌn poder chica ri i-bꞌanak chivij chi ncaꞌtiquir ncaꞌquilasaj itziel tak espíritus? Can ja ri niquiꞌan ijejeꞌ nikꞌalajin chi ixreꞌ man ketzij ta ri ntiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero xa inreꞌ ja ri Dios ri xyoꞌn-pa poder chuva chi ncaꞌnvalasaj ri itziel tak espíritus, riqꞌuin reꞌ ntivatamaj chi ri ru-reino ri Dios ya xalka iviqꞌuin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Antok jun ache cꞌo altíra ruchukꞌaꞌ y cꞌo nojiel clases de armas riqꞌuin, can jaꞌal nuchajij ri ru-palacio. Y man jun nitiquir nalasan cha ri cꞌo riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero antok nalka chic jun ri cꞌo más ruchukꞌaꞌ choch jajaꞌ, ja nicovin chirij, y nralasaj-el cha nojiel ri armas ri cꞌo riqꞌuin ri rucukubꞌan rucꞌuꞌx chirij. Y nutzꞌom rujachic ri xralasaj-el cha ri ache ri xuchꞌec. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y ri man viqꞌuin ta inreꞌ nisamaj-ve, xa chuvij inreꞌ nisamaj-ve. Y ri man nitoꞌn ta vichin, xa jareꞌ ri nituru nojiel ri ncaꞌnꞌan inreꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Antok jun itziel espíritu ntiel-el pa ránima jun vinak, niꞌa pa tak lugar chakeꞌj, nucanuj pacheꞌ nuxlan-ve. Y antok man jun lugar niril, nuꞌej cꞌa: Más otz nquitzalaj chic pa ránima ri vinak pacheꞌ xiniel-ve-pa, nichaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y antok nalka, nalrilaꞌ incheꞌl jun jay masuon y jaꞌal bꞌanun adornar. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y ri itziel espíritu reꞌ ncaꞌrucꞌam-pa i-siete (ivukuꞌ) chic itziel tak espíritus ri más i-itziel, y quinojiel ncaꞌuoc pa ránima ri vinak. Y ri vinak choj-iqꞌuin ncaꞌbꞌacꞌujie-ve ri itziel tak espíritus reꞌ, más peor nuꞌon ri rucꞌaslien choch ri rubꞌanun-pa naꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y antok ri Jesús nutzijuoj ri tzij reꞌ chiquivach iqꞌuiy vinak ri quimaluon-quiꞌ riqꞌuin, jun ixok ri cꞌo chireꞌ chiquicajol, cof xchꞌoꞌ y xuꞌej: Can jaꞌal tiquicuot ri ixok ri xyoꞌn avichin ri choch-ulief y xuyaꞌ atzꞌun, xchaꞌ ri ixok cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Y ri Jesús xuꞌej: Can más jaꞌal caꞌquicuot ri ncaꞌcꞌaxan ri ruchꞌabꞌal ri Dios y niquiꞌan nojiel ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y antok qꞌuiy vinak ri niquimol-apa-quiꞌ chirij ri Jesús, xpa jajaꞌ xuꞌej chica: Ri vinak richin ri tiempo vacame altíra i-itziel, rumareꞌ nicajoꞌ chi niꞌan jun señal chiquivach chi nquinquinimaj. Pero ri señal ri nicajoꞌ man xtiyoꞌx ta chica. Xa ja ri xbꞌanataj riqꞌuin ri Jonás, ri xcꞌujieꞌ ojier can tiempo, jareꞌ ri señal ri xtiyoꞌx chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ruma incheꞌl xbꞌanataj riqꞌuin ri Jonás, xucꞌut chiquivach ri vinak ri xaꞌcꞌujieꞌ ojier can chupan ri tanamet Nínive, chi ja ri Dios takayuon-pa richin. Y quireꞌ jeꞌ ri xtukꞌasaj ri Xtak-pa chicaj chi xalax chiꞌicajol, xticusas richin jun señal chiquivach ri vinak vacame. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y antok xtalka ri kꞌij richin ri juicio, xticꞌastaj-pa ri jun reina ri xuꞌon gobernar ri Sabá y xtuꞌej chi man otz ta xquiꞌan ri vinak ri icꞌo vacame. Ruma antok xcꞌasieꞌ ri jun reina reꞌ, altíra naj xpa-ve chi xalraꞌxaj runoꞌj ri rey Salomón. Y vacame incꞌo inreꞌ ri cꞌo más nukꞌij choch ri rey Salomón ri xcꞌujieꞌ ojier can. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y antok xtalka ri kꞌij richin ri juicio, xcaꞌcꞌastaj-pa ri vinak aj-Nínive y xtiquiꞌej chi man otz ta xquiꞌan ri vinak ri icꞌo vacame, ruma man xquinimaj ta. Ri vinak aj-Nínive joꞌc xcaꞌxaj ri ruchꞌabꞌal ri Dios ri xutzijuoj ri Jonás chica, ja xtzalaj-pa cánima riqꞌuin ri Dios y xquiꞌan ri nrajoꞌ jajaꞌ. Y vacame incꞌo inreꞌ ri cꞌo más nukꞌij choch ri Jonás. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Man jun vinak nutzej jun lámpara y nuyaꞌ pacheꞌ man kꞌalaj ta, o nuyaꞌ ta chuxieꞌ jun cajuon. Jun ri nutzej jun lámpara, chicaj nuya-ve chi quireꞌ ri ncaꞌuoc pa jay jaꞌal niquitzꞌat ri sakil. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ri anakꞌavach jareꞌ ri lámpara richin ri a-cuerpo. Antok ri anakꞌavach otz, nojiel jeꞌ ri a-cuerpo cꞌo pa sakil. Pero xa ri anakꞌavach man otz ta, nojiel ri a-cuerpo cꞌo pa kꞌakuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mareꞌ tatzꞌata-ka-aviꞌ chi ri sakil ri cꞌo pan avánima man kꞌakuꞌn ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ruma xa nojiel ri a-cuerpo cꞌo pa sakil, can manak kꞌakuꞌn aviqꞌuin y quireꞌ ncatzuꞌn jaꞌal. Incheꞌl antok jun lámpara ncaruꞌon alumbrar y jaꞌal sakil nuyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y antok ri Jesús xtanie-ka chi nitzijuon chiquivach ri vinak, cꞌo jun chiquivach ri achiꞌaꞌ fariseos xuꞌon rogar choch ri Jesús chi nivaꞌ riqꞌuin. Y antok ri Jesús xbꞌaka pa jay, ja xtzꞌuye-apa chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y ri ache fariseo can xuꞌon extrañar-riꞌ antok xutzꞌat ri Jesús, chi man xuchꞌaj ta rukꞌaꞌ antes chi nivaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero ri Ajaf Jesús xuꞌej cha: Ixreꞌ achiꞌaꞌ fariseos xa ix incheꞌl ri vaso y ri plato ri jaꞌal chꞌajuon quij pero ri quipan xa tzꞌil. Ri ivánima xa nojnak riqꞌuin alakꞌ y nojnak riqꞌuin itziel tak kax. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ix-nacanak. ¿Man ivataꞌn ta cꞌa chi ri xbꞌano ri ka-cuerpo, xuꞌon jeꞌ ri kánima? ");
INSERT INTO cakSNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Rumareꞌ tiyaꞌ ri cꞌo iviqꞌuin chica ri man jun kax cꞌo quiqꞌuin, y quireꞌ nojiel xtiel sak. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ fariseos! Ixreꞌ ntiyaꞌ ri diezmo richin ri alvaviena, ri rura y nojiel quivach kꞌayis, pero xa man ntivajoꞌ ta ri Dios, ni man ix choj ta jeꞌ quiqꞌuin ri vinak. Jareꞌ ri más nicꞌatzin chi ntiꞌan, después tiyaꞌ ri i-diezmo. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ fariseos! ruma ja ri naꞌay tak chꞌacat ntivajoꞌ pa tak sinagogas. Y can altíra nika chivach chi nquixꞌan saludar ri pacheꞌ niquimol-ve-quiꞌ qꞌuiy vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Juyeꞌ ivach ixreꞌ achiꞌaꞌ escribas y ixreꞌ achiꞌaꞌ fariseos, ri xa caꞌyeꞌ ipalaj! ruma xa ix incheꞌl ri jul pacheꞌ i-mukun can ri quiminakiꞌ. Antok man kꞌalaj ta chic nitzꞌiet, ri vinak choj ncaꞌkꞌax paroꞌ ruma man cataꞌn ta chi xa paroꞌ jun quiminak ncaꞌkꞌax-ve, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun chiquivach ri maestros richin ri ley xuꞌej cha ri Jesús: Maestro, antok atreꞌ naꞌej quireꞌ, man joꞌc ta chica ri nicꞌaj naꞌej-ve, xa chika jeꞌ ojreꞌ naꞌej-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y ri Jesús xuꞌej cha ri ache reꞌ: ¡Juyeꞌ jeꞌ ivach ixreꞌ maestros richin ri ley! ruma antok nquiꞌtijuoj ri vinak, ntiyaꞌ nimaꞌk tak akaꞌn chiquij ri man ncaꞌtiquir ta niquicꞌuaj. Pero ixreꞌ nixta cha jun ruve-ikꞌaꞌ chi ntitzꞌom ta bꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Juyeꞌ ivach, ruma nquiꞌchojmij ri panteones ri pacheꞌ i-mukun-ve ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, y ijejeꞌ xa ja ri ivateꞌt-imamaꞌ ri xaꞌquimisan quichin! ");
INSERT INTO cakSNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Vacame kꞌalaj chi ixreꞌ nika chivach ri itziel tak kax ri xaꞌquiꞌan ri ivateꞌt-imamaꞌ ri ojier can, ruma ijejeꞌ xaꞌquimisan ri profetas, y ixreꞌ nquixchojmin ri panteones ri pacheꞌ i-mukun-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y como ri Dios rataꞌn nojiel, mareꞌ xuꞌej: Xcaꞌntak profetas, y xcaꞌntak jeꞌ apóstoles chiquicajol. Pero icꞌo chiquivach ri xcaꞌquiquimisaj, y icꞌo ri xcaꞌquitarariej-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Rumareꞌ ri vinak ri icꞌo vacame, ijejeꞌ ri xcaꞌkalien ri quicamic quinojiel ri profetas ri xaꞌquimisas ojier can tiempo, xa-jan antok xtzꞌucutaj-pa ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Tiquirnak-pa riqꞌuin ri rucamic ri Abel, cꞌa riqꞌuin ri rucamic ri Zacarías, ri xquimisas chucajol ri altar y ri templo. Rumareꞌ niꞌej chiva, chi nojiel cꞌa ri camic reꞌ xticakaj ri vinak ri icꞌo chupan ri tiempo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Juyeꞌ ivach ixreꞌ maestros richin ri ley! ruma pan ikꞌaꞌ ixreꞌ cꞌo-ve ri noꞌj, ruma ivataꞌn ri chica modo jun vinak ntuoc richin ri Dios, pero ixreꞌ xa man ix-acunak ta richin ri Dios y ri nicajoꞌ ncaꞌuoc richin ri Dios nquiꞌkꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Antok ri Jesús xuꞌej nojiel reꞌ, ri achiꞌaꞌ escribas y ri achiꞌaꞌ fariseos altíra xyacataj quiyoval. Y rumareꞌ ijejeꞌ qꞌuiy cꞌa kax niquicꞌutuj cha ri Jesús xa richin niquinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Y ijejeꞌ man niquiyaꞌ ta can ri Jesús, ruma nicajoꞌ nicaꞌxaj chi jajaꞌ cꞌo ta jun tzij ri man otz ta ri nuꞌej chi quireꞌ niquiꞌan acusar. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y ri vinak chi i-miles xquimol-ka-quiꞌ chireꞌ. Rumareꞌ niquinimila-quiꞌ. Y ri Jesús naꞌay cꞌa xchꞌoꞌ quiqꞌuin ri ru-discípulos y xuꞌej chica: Tibꞌanaꞌ cuenta-iviꞌ choch ri levadura quichin ri achiꞌaꞌ fariseos. Ri levadura reꞌ ja ri caꞌyeꞌ quipalaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ruma man jun kax ri man kꞌalaj ta, ri man ta xtibꞌakꞌalajin-pa. Y man jun kax ri avan-can, ri man ta xtinaꞌax. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rumareꞌ ixreꞌ, nojiel cꞌa ri i-eꞌn pa kꞌakuꞌn, xtikꞌalajin-pa. Y nojiel cꞌa ri i-eꞌn pa tak ixiquin pa jay, xtinaꞌax cuma ri vinak y xtiquirak quichiꞌ xtiquitzijuoj pa quiveꞌ ri jay. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y niꞌej chiva ixreꞌ ri ix nu-amigos: Man tixiꞌij-iviꞌ chiquivach ri niquiquimisaj ri i-cuerpo, pero después man jun chic kax xcaꞌtiquir xtiquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero niꞌej chiva choj choch nicꞌatzin chi ntixiꞌij-iviꞌ: Tixiꞌij-iviꞌ choch ri Jun ri nuquimisaj ri i-cuerpo y cꞌo ru-poder chi nquixrutak pan infierno. Choch reꞌ tixiꞌij-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","¿Man ncaꞌcꞌayix ta came vuꞌuoꞌ chꞌitak chicop ri cꞌo quixicꞌ por caꞌyeꞌ len cajal? Y mesque ri chicop reꞌ manak-oc cajal, ri Dios man jun bꞌay ncaꞌrumastaj can. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Y hasta ri iveꞌ i-jilan nojiel. Man tixiꞌij-iviꞌ, ruma ixreꞌ más ivakalien que chiquivach iqꞌuiy chꞌitak chicop ri cꞌo quixicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Niꞌej jeꞌ chiva, chi ri man niqꞌuix ta nuꞌej chi in-runiman, quireꞌ jeꞌ xtuꞌon ri Xtak-pa chicaj chi xalax chiꞌicajol, man xtiqꞌuix ta xtuꞌej chiquivach ri ru-ángeles ri Dios chi richin jajaꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","pero ri nuꞌej chi man in-runiman ta, xtiꞌan negar chiquivach ri ru-ángeles ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y chica-na ri itziel nichꞌoꞌ chirij ri Xtak-pa chicaj chi xalax chiꞌicajol, cꞌa niꞌan perdonar. Pero ri itziel nichꞌoꞌ chirij ri Espíritu Santo, man niꞌan ta perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Antok xquixucꞌuax pa tak sinagogas, y xquixucꞌuax jeꞌ chiquivach ri jueces y nicꞌaj chic autoridades, man tiꞌan preocupar-iviꞌ chica tzij ri xtiꞌej chica y ri chica tzij xticusaj chi nquixchꞌoꞌ chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ruma antok xtalka ri huora chi nquixchꞌo-apa, ja ri Espíritu Santo ri xtiyoꞌn tzij chiva chi ntiꞌej-apa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chireꞌ chiquicajol ri vinak quimaluon-apa-quiꞌ, cꞌo jun ri xchꞌo-apa y xuꞌej cha ri Jesús: Maestro, tabꞌanaꞌ favor taꞌej cha ri nunimal chi tuyaꞌ ri nu-herencia. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ri Jesús xuꞌej cha: Ache, ¿chica came in-yaꞌyuon pan iveꞌ ixreꞌ, chi inreꞌ in jun juez o in jun jachoy-herencia chiꞌicajol? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y ri Jesús xchꞌoꞌ chic chica ri vinak y xuꞌej: Titzꞌata-iviꞌ otz chi ntiꞌan cuenta-iviꞌ, man tirayij chi nicꞌujieꞌ nojiel kax iviqꞌuin. Ruma mesque qꞌuiy rubꞌayomal jun vinak, man ja ta reꞌ ri xtiyoꞌn rucꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y ri Jesús xutzijuoj jeꞌ chica jun parábola (cꞌambꞌal-tzij), y xuꞌej: Cꞌo jun ache bꞌayuon, qꞌuiy rulief cꞌo. Y jun bꞌay, qꞌuiy xuꞌon cosechar. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Rumareꞌ ri bꞌayuon reꞌ xuꞌej-ka pa ránima: ¿Chica ta xtinꞌan chi quireꞌ niyac nojiel ri nu-cosecha, ruma manak chic pacheꞌ niya-ve nojiel? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y antok ranun chic pensar, xuꞌej: Más otz ncaꞌntur ri caꞌcoj nucꞌujay y niꞌan más nimaꞌk. Y chupan reꞌ xcaꞌnyac-ve ri cꞌo viqꞌuin y nojiel ri nu-cosecha. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y xtinꞌej cha ri vánima: Vánima, vacame qꞌuiy kax ri ayacuon richin qꞌuiy junaꞌ. Caquicuot cꞌa, catuxlan, cavaꞌ y takumuꞌ yaꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios xuꞌej cha ri bꞌayuon reꞌ: Nacanic ache, chupan va akꞌaꞌ va nalcꞌutux ri avánima, y nojiel ri abꞌayomal ri ayacuon, ¿choj cha xticꞌujie-ve can? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quireꞌ nibꞌanataj riqꞌuin ri numol rubꞌayomal richin ri roch-ulief, y xa manak ri rubꞌayomal ri Dios riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y después ri Jesús xuꞌej chica ri ru-discípulos: Rumareꞌ inreꞌ niꞌej chiva: Man tichꞌujirisaj-iviꞌ ruma ri chica nicꞌatzin chiva kꞌij-kꞌij, ri chica ntitej, ni por ri i-cuerpo chi chica itziak ri nticusaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ri icꞌaslien más rakalien choch ri ntitej, y ri i-cuerpo más rakalien choch ri itziak. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Quiꞌitzꞌataꞌ ri chicop ri cꞌo quixicꞌ quibꞌinan cuervos; man ncaꞌtico ta, y manak niquiꞌan cosechar, ni manak jeꞌ quicꞌujay chi niquiyac. Pero ijejeꞌ ncaꞌvaꞌ, ruma ja ri Dios nitzuku quichin. ¿Man ivakalien ta came ixreꞌ más que chiquivach ri chicop reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Cꞌo came jun chivach ixreꞌ ri nitiquir nuꞌon chi niqꞌuiy ta chic nicꞌaj vara ri rakan, mesque nuchꞌujirisaj-riꞌ chi nuꞌon? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y xa jun kax ri altíra coꞌl incheꞌl reꞌ man nquixtiquir ta ntiꞌan, ¿karruma ntichꞌujirisaj-iviꞌ richin ntivil nicꞌaj chic kax ri ncaꞌcꞌatzin chiva? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Quiꞌitzꞌataꞌ ri cotzꞌeꞌj lirio antok ncaꞌqꞌuiy: Ijejeꞌ man ncaꞌsamaj ta, ni man ncaꞌcamuon ta chi niquiꞌan quitziak jaꞌal. Pero niꞌej cꞌa chiva, chi ri rey Salomón ri xcꞌujieꞌ ojier can, mesque altíra rubꞌayomal y ruyuon jaꞌal tak tziak ri xucusaj, pero man jun bꞌay xucusaj ta jun rutziak incheꞌl nitzꞌiet jun lirio. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ri Dios quireꞌ nuvak ri kꞌayis mesque man can ta nilayuj, ruma jun kꞌij jaꞌal ranun, y jun chic kꞌij nichakej-ka y nicꞌak pa kꞌakꞌ. Y xa ri Dios can nuvak jaꞌal, ¿cuánto más chiva ixreꞌ mesque man can ta icukubꞌan icꞌuꞌx riqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Rumareꞌ ixreꞌ, man tiꞌan preocupar-iviꞌ chi nticanuj ri chica ntitej y ri chica ntikun, y man tichꞌujirisaj-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ruma quinojiel vinak ri icꞌo choch-ulief niquicanuj nojiel reꞌ. Pero ri Itataꞌ can rataꞌn chic ri chica nicꞌatzin chiva. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Mareꞌ can ticanuj ri ru-reino ri Dios, y nojiel ri nicꞌatzin chiva, xtuyaꞌ chiva. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Man tixiꞌij-iviꞌ ixreꞌ ri ix-bꞌanak chuvij, mesque xa ix jubꞌaꞌ oc. Ri Itataꞌ can niquicuot chi nquixcꞌujieꞌ pa ru-reino jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ticꞌayilaꞌ ri cꞌo iviqꞌuin y tiyaꞌ chica ri i-puobra. Xa quireꞌ ntiꞌan, ja ntinojsaj ri i-buolsa richin ri bꞌayomal chicaj ri man xtikꞌay ta, ni man xtiqꞌuis ta, pacheꞌ man jun alakꞌuon xtiꞌka, ni man nichocoper ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ruma pacheꞌ cꞌo-ve ri ibꞌayomal, chireꞌ nicꞌujie-ve jeꞌ ri ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Quixcꞌujieꞌ preparados, y siempre ticꞌat ri i-lámparas. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibꞌanaꞌ incheꞌl niquiꞌan ri samajiel chupan jun jay. Ri samajiel quiyoꞌien chi nitzalaj-pa ri cajaf bꞌanak pa jun cꞌulubꞌic, chi quireꞌ antok nalka y nichꞌo-apa, can chaꞌnin niquijak ri ruchi-jay choch. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Can jaꞌal caꞌquicuot ri samajiel ri icꞌas antok xtalka ri cajaf. Y can ketzij niꞌej chiva, chi ri cajaf ncaꞌrutzꞌuyubꞌaꞌ chirij ri mesa, nurucusaj-pa ru-gavacha y nuya-apa nojiel kax richin nitij chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y mesque ri cajaf ri samajiel reꞌ nalka pa nicꞌaj-akꞌaꞌ o antok nisakar-pa, xa ncaꞌrilaꞌ cꞌa icꞌas ri samajiel reꞌ, can jaꞌal caꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Pero tivatamaj cꞌa, xa ta ri rajaf-jay nunaꞌiej ri chica huora nalka ri alakꞌuon pa rachuoch, nicꞌasieꞌ chi nuchajij ri rachuoch, y man nuyaꞌ ta lugar cha ri alakꞌuon chi ntuoc-oc chi nalakꞌ-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mareꞌ ixreꞌ quixcꞌujieꞌ preparados, ruma antok xa man ja ta reꞌ ntiꞌan pensar, jareꞌ antok xtipa chic ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Jareꞌ antok ri Pedro xuꞌej cha ri Jesús: Ajaf, ¿atreꞌ xatzijuoj ri parábola (cꞌambꞌal-tzij) reꞌ joꞌc chika ojreꞌ ri a-discípulos, o xatzijuoj jeꞌ chica quinojiel vinak? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf Jesús xuꞌej: Ri mayordomo ri choj y cꞌo runoꞌj, jareꞌ niyoꞌx can ruma ri rajaf chi nicꞌujieꞌ pa quiveꞌ ri icꞌo pa rachuoch, chi nuyaꞌ nojiel ri nicꞌatzin chica chi niquitej antok nalka ri huora. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Can jaꞌal tiquicuot ri siervo reꞌ antok nalꞌilitaj ruma ri rajaf najin riqꞌuin ri samaj ri bꞌeꞌn can cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can ketzij niꞌej chiva, chi ri rajaf can xtuyaꞌ paroꞌ nojiel ri cꞌo riqꞌuin, chi nuꞌon cuenta. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero xa ta ri siervo reꞌ nuꞌej-ka pa ránima: Ri vajaf xa man nipa ta yan, nicha-ka; y nutzꞌom quichꞌayic ri nicꞌaj chic siervos, chi achiꞌaꞌ chi ixokiꞌ, y ruyuon vaꞌen nuꞌon y nutzꞌom rukumic avarienta chi nikꞌabꞌar, ");
INSERT INTO cakSNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","y jareꞌ ncaꞌruꞌon antok ri rajaf xtalka chupan jun kꞌij y jun huora antok jajaꞌ man royoꞌien ta y man rataꞌn ta, ri rajaf can xtuyaꞌ jun nem castigo cha ri siervo reꞌ, y xtuyaꞌ quiqꞌuin ri man ncaꞌniman ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri siervo ri rataꞌn ri chica nrajoꞌ ri rajaf, pero xa man xuꞌon ta preparar-riꞌ, ni man xuꞌon ta ri nrajoꞌ ri rajaf, ri siervo reꞌ xtika jun nem castigo paroꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ri siervo ri man rataꞌn ta ri chica nrajoꞌ ri rajaf, y cꞌo kax man otz ta ncaꞌruꞌon, mesque jajaꞌ otz chi niꞌan castigar, pero joꞌc jun coꞌl castigo xtiyoꞌx cha. Ruma ri qꞌuiy yoꞌn cha, can qꞌuiy jeꞌ xticꞌutux cha. Quireꞌ jeꞌ ri qꞌuiy jachuon can pa rukꞌaꞌ, can qꞌuiy jeꞌ ri xticꞌutux cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Inreꞌ xipa choch-ulief chi nalyaꞌ kꞌakꞌ chiꞌicajol. ¿Y chica chic más nirayij, si ri kꞌakꞌ reꞌ ya nicꞌat? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero naꞌay nicꞌatzin cꞌa chi nikꞌasaj jun bautismo de sufrimiento, rumareꞌ ¡altíra nikꞌaxo vánima voyoꞌien-apa, hasta cꞌa xtuꞌon cumplir! ");
INSERT INTO cakSNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Ixreꞌ ntiꞌan pensar chi inreꞌ xipa chi niyaꞌ paz ri choch-ulief? Niꞌej cꞌa chiva: Man quireꞌ ta. Xa vuma inreꞌ icꞌo ri xtiquijachala-ka-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rumareꞌ desde vacame, chupan jun jay icꞌo ivuꞌuoꞌ vinak, iyoxeꞌ xa xcaꞌpalaj chiquij ri icaꞌyeꞌ chic, o ja ri icaꞌyeꞌ ri xcaꞌpalaj chiquij ri iyoxeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tataꞌj man xtiquicꞌuaj ta quiꞌ riqꞌuin ri rucꞌajuol. Ri alaꞌ xtipalaj chirij ri rutataꞌ. Ri rutieꞌ xtipalaj chirij ri ral-xtan. Ri xtan xtipalaj chirij ri rutieꞌ. Ri alitieꞌ xtipalaj chirij ri raliꞌ, y ri alibꞌatz xtipalaj chirij ri ralitieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y ri Jesús xuꞌej jeꞌ chica ri vinak: Antok ntitzꞌat ri mukul ri nicꞌamo-pa jobꞌ, chaꞌnin ntiꞌej chi nipa jobꞌ y can nipa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y antok nalka ri cakꞌiekꞌ, ntiꞌej chi nutzꞌom sakꞌij y quireꞌ nibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Ixreꞌ xa caꞌyeꞌ ipalaj! Ruma can ivataꞌn chica nirubꞌanaꞌ antok ntitzꞌat ri rocaj y ri roch-ulief, ¿y karruma man ivataꞌn ta chica tiempo ri ojcꞌo vacame? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y karruma man iyuon ta ixreꞌ ntivatamaj ri otz, y ja ta reꞌ ri ntiꞌan? ");
INSERT INTO cakSNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Antok ri nibꞌano acusar avichin ncarucꞌuaj choch ri juez, tatijaꞌ akꞌij chi naꞌan arreglar riqꞌuin antok cꞌa at-bꞌanak pa bꞌay. Ruma xa man naꞌan ta quireꞌ, can xcarucꞌuaj choch ri juez, y ri juez xcarujach-el pa rukꞌaꞌ ri ache ri nichajin ri cárcel, y ri ache reꞌ xcarutzꞌapij pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y can niꞌej chi man ncatiel ta pa pa cárcel, hasta cꞌa xtatzoliej ri último centavo ri choj cha abꞌanun-ve acꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y chupan ri tiempo reꞌ icꞌo nicꞌaj vinak riqꞌuin ri Jesús, y ijejeꞌ xquitzijuoj cha ri xuꞌon ri Pilato chica nicꞌaj achiꞌaꞌ aj-Galilea. Ri Pilato xaꞌruquimisaj antok ja niquiyaꞌ ri chicop choch ri Dios, y ri quiquiqꞌuiel ri chicop y ri quiquiqꞌuiel ri achiꞌaꞌ reꞌ, xa jun xuꞌon cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pero ri Jesús xuꞌej chica: ¿Ixreꞌ ntiꞌan pensar chi ri achiꞌaꞌ aj-Galilea reꞌ, quireꞌ xꞌan chica ruma ijejeꞌ más i-pecadores que chiquivach quinojiel ri aj-Galilea? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Niꞌej cꞌa chiva: Man quireꞌ ta. Pero ixreꞌ vi xa man xtitzalaj ta pa ivánima riqꞌuin ri Dios y man ntiꞌan ta ri nrajoꞌ jajaꞌ, xa xquixbꞌaka jeꞌ chupan ri castigo pacheꞌ xaꞌbꞌaka-ve ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Antok xaꞌcon ri i-dieciocho pacheꞌ cꞌo-ve ri estanque ri niꞌeꞌx Siloé cha, antok xtzak ri torre chiquij, ¿ixreꞌ ntiꞌan pensar chi más i-pecadores que chiquivach quinojiel ri nicꞌaj chic vinak ri icꞌo chireꞌ pa tanamet Jerusalén? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Niꞌej cꞌa chiva: Man quireꞌ ta. Pero ixreꞌ vi xa man xtitzalaj ta pa ivánima riqꞌuin ri Dios y man ntiꞌan ta ri nrajoꞌ jajaꞌ, xa can xquixbꞌaka jeꞌ chupan ri castigo pacheꞌ xaꞌbꞌaka-ve ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ri Jesús xutzijuoj jun parábola (cꞌambꞌal-tzij) chiquivach, y xuꞌej: Cꞌo jun ache ruticuon jun mata víquix ri pa rulief, y xalka chuxieꞌ ri chieꞌ chi xalrucanuj roch, y man jun roch xril. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rumareꞌ ri rajaf ri ulief xuꞌej cha ri ache ri nisamaj riqꞌuin: Oxeꞌ yan junaꞌ in-patanak chi nalcanuj roch ri chieꞌ reꞌ, y man jun bꞌay ruyoꞌn ta jun roch. Rumareꞌ más otz tachayo-el. ¿Chica xticꞌatzin-ve la xa joꞌc nuqꞌuis ruchukꞌaꞌ ri ulief? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ri samajiel xuꞌej cha ri rajaf: Tayaꞌ chic can ri junaꞌ va. Nicꞌot-na ri ulief chuxieꞌ y niyaꞌ na avuona chuxieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xa nuyaꞌ roch, otz. Y xa man xtuyaꞌ ta roch, cꞌajareꞌ tachayo-el, xchaꞌ ri samajiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y chupan jun kꞌij richin uxlanien, ri Jesús nucꞌut chiquivach ri vinak ri ruchꞌabꞌal ri Dios, chupan jun sinagoga. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicajol ri vinak ri quimaluon-quiꞌ chireꞌ, cꞌo jun ixok ri cꞌo dieciocho junaꞌ tiyavaj-pa. Ri ixok reꞌ luculic rij, y man nitiquir ta nipiꞌieꞌ choj. Ri ixok quireꞌ rubꞌanun ruma jun itziel espíritu bꞌanayuon cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero antok ri Jesús xutzꞌat ri ixok reꞌ, xrayuoj y xuꞌej cha: Nuoya, vacame at libre choch ri ayabꞌil. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuyaꞌ rukꞌaꞌ paroꞌ ri ixok. Y ri ixok ja xyukutaj ri rij y otz xpiꞌieꞌ. Y ri ixok xuyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ri ache principal chupan ri sinagoga xpa royoval ruma ri Jesús xuꞌon sanar ri ixok chupan jun kꞌij richin uxlanien; rumareꞌ ri ache reꞌ xuꞌej chica ri vinak ri quimaluon-quiꞌ chireꞌ: Ri semana rucꞌuan vakiꞌ kꞌij chi nkusamaj. Y chupan ri vakiꞌ kꞌij reꞌ quixpa chi nquixꞌan sanar, y man ja ta chupan jun kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero ri Ajaf Jesús xuꞌej cha: Ixreꞌ xa caꞌyeꞌ ipalaj. ¿Man came nquiꞌquir ta el ri iváquix o ri iquiej chupan jun kꞌij richin uxlanien, richin nquixꞌa chi ntiyaꞌ quiyaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ri jun ixok reꞌ rumáma can ri Abraham, y ri Satanás cꞌo dieciocho junaꞌ tuluc-pa. ¿Man otz ta came chi niꞌan sanar chupan jun kꞌij richin uxlanien? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Antok ri Jesús xuꞌej quireꞌ, quinojiel ri itziel ncaꞌtzꞌato richin xaꞌqꞌuix-ka. Pero ri nicꞌaj chic vinak niquicuot cánima, ruma ri Jesús nem samaj ri nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y ri Jesús xuꞌej: ¿Choj-iqꞌuin junan ri ru-reino ri Dios? ¿Y choj-iqꞌuin niꞌan comparar? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Xa junan riqꞌuin ri ijaꞌtz richin ri mostaza ri xutic can jun ache pa rulief. Antok xqꞌuiy, can incheꞌl jun nem chieꞌ xuꞌon y ri chicop ri cꞌo quixicꞌ niquiꞌan quisuoc chukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y ri Jesús xuꞌej jeꞌ: ¿Choj-iqꞌuin niꞌan comparar ri ru-reino ri Dios? ");
INSERT INTO cakSNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Xa junan riqꞌuin ri levadura ri niruma-pa jun ixok y nuyaꞌ chupan oxeꞌ medida harina y nuxol-riꞌ chupan nojiel, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y ri Jesús xutzꞌom chic bꞌay chi niꞌa pa tanamet Jerusalén. Y nutzijuoj ri ruchꞌabꞌal ri Dios pa tak nimaꞌk tanamet y pa tak aldeas pacheꞌ nakꞌax-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y cꞌo jun ri xcꞌutun cha ri Jesús, y xuꞌej cha: Ajaf, ¿man iqꞌuiy ta ri xcaꞌcolotaj? Pero ri Jesús chica quinojiel xchꞌo-ve, y xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Can titijaꞌ ikꞌij chi nquixuoc chupan ri puerta ri coꞌl-oc roch; ruma niꞌej cꞌa chiva chi iqꞌuiy cꞌa vinak xticajoꞌ xcaꞌuoc chupan ri puerta reꞌ, pero man xcaꞌtiquir ta xcaꞌuoc. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Y antok ri Ajaf xtipalaj-pa y xtalrutzꞌapij can ri puerta, ixreꞌ ri majaꞌ quixuoc riqꞌuin, xticꞌoscꞌa-apa y xtiꞌej-apa: Ajaf, Ajaf, tajakaꞌ ri puerta chakavach. Pero jajaꞌ xtuꞌej-pa chiva: Man vataꞌn ta pacheꞌ ix-patanak-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y ixreꞌ xtiꞌej-apa cha: Ojreꞌ ri xojvaꞌ y xkakun yaꞌ aviqꞌuin. Y pa tak bꞌay richin ri katanamit, chireꞌ xacꞌut-ve ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero jajaꞌ xtuꞌej-pa chiva: Xinꞌej yan chiva chi inreꞌ man vataꞌn ta pacheꞌ ix-patanak-ve. Quixiel-el viqꞌuin, ruma ixreꞌ joꞌc itziel tak kax ri ntiꞌan, xticha-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y antok xquiꞌtzꞌat ri Abraham, ri Isaac, ri Jacob y quinojiel ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, chi icꞌo pa ru-reino ri Dios; chireꞌ xquixuokꞌ y xtikꞌachꞌachꞌiej ivoray ruma xixcꞌujieꞌ can juviera. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Ruma xcaꞌpa vinak oriente, occidente, norte y sur ri in-quiniman. Ijejeꞌ xcaꞌbꞌatzꞌuyeꞌ chirij ri mesa pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y nicꞌaj ri icꞌo pa ruqꞌuisbꞌal vacame, xcaꞌcꞌujieꞌ nabꞌayal y nicꞌaj ri icꞌo nabꞌayal vacame, xcaꞌcꞌujieꞌ pa ruqꞌuisbꞌal, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupan ri mismo kꞌij reꞌ, icꞌo nicꞌaj achiꞌaꞌ fariseos ri xaꞌlka riqꞌuin ri Jesús, y xquiꞌej cha: Catiel-el vaveꞌ chaꞌnin, ruma ri Herodes nrajoꞌ ncaruquimisaj, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Quixꞌin y tiꞌej cha ri rey reꞌ, ri incheꞌl jun zorra, chi inreꞌ cꞌa xcaꞌnvalasaj itziel tak espíritus y cꞌa xcaꞌnꞌan sanar jeꞌ ri ncaꞌyavaj vacame y chuaꞌk, y cabꞌij xtinqꞌuis rubꞌanic ri samaj reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Inreꞌ nicꞌatzin chi niꞌan seguir ri nubꞌiey vacame, chuaꞌk y cabꞌij. Can nicꞌatzin chi nquibꞌaka pa tanamet Jerusalén, ruma jun profeta manak cheꞌl xticon chupan jun chic tanamet. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y xuꞌej cꞌa chiquij ri vinak ri icꞌo Jerusalén: Aj-Jerusalén, aj-Jerusalén, ¿karruma nquiꞌquimisaj ri profetas? ¿Karruma nquiꞌquimisaj cha abꞌaj ri ncaꞌrutak-pa ri Dios chiꞌicajol? Incheꞌl jun quitie-acꞌ ncaꞌrumol ri chꞌitak ral chuxieꞌ ri ruxicꞌ, inreꞌ qꞌuiy mul xinvajoꞌ xixmol ta viqꞌuin, pero ixreꞌ man xivajoꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Vacame ri ivachuoch xticꞌujieꞌ can abandonado. Y ketzij niꞌej chiva chi man xquinitzꞌat ta chic, hasta cꞌa xtalka-na ri kꞌij antok xtiꞌej: ¡Bendito ri patanak pa rubꞌeꞌ ri Ajaf Dios! xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y chupan jun kꞌij richin uxlanien, ri Jesús xꞌa chirachuoch jun ache principal chiquivach ri achiꞌaꞌ fariseos ruma bꞌanun invitar richin jun vaꞌen. Y ri icꞌo chireꞌ niquitzꞌat-apa ri Jesús, ");
INSERT INTO cakSNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ruma chireꞌ cꞌo-apa choch ri Jesús jun ache ri nuꞌon sopojic. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y ri Jesús xuꞌej chica ri maestros richin ri ley y chica jeꞌ ri achiꞌaꞌ fariseos ri icꞌo chireꞌ: ¿Xajan came chi niꞌan sanar jun ri niyavaj chupan jun kꞌij richin uxlanien? ");
INSERT INTO cakSNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero ijejeꞌ man jun chic xquiꞌej. Y ri Jesús xutzꞌom-apa ri ache ri nuꞌon sopojic y xuꞌon sanar y xuꞌej cha chi tiꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y chica ri maestros chirij ri ley y ri achiꞌaꞌ fariseos, ri Jesús xuꞌej: ¿Cꞌo ta jun chivach ixreꞌ nitzak-ka jun ruquiej o jun ruváquix chupan jun chꞌiti sivan, man niꞌa ta came jun-anin chi niꞌralasaj-pa, mesque chupan jun kꞌij richin uxlanien? ");
INSERT INTO cakSNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ijejeꞌ man xquil ta chica xquiꞌej-apa cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y xpa ri Jesús xutzꞌom rubꞌixic jun parábola (cꞌambꞌal-tzij) chica ri i-bꞌanun invitar richin ri vaꞌen, ruma xutzꞌat chi ri vinak ri i-bꞌanun invitar ncaꞌquichaꞌ ri naꞌay tak chꞌacat chirij ri mesa. Rumareꞌ xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Antok cꞌo jun ri nibꞌano invitar avichin richin jun cꞌulubꞌic, man cꞌa tacanuj ri naꞌay tak chꞌacat. Ruma xa jubꞌaꞌ catzꞌuye-ka chireꞌ antok nalka jun ri más rakalien que chavach atreꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nipa ri xbꞌano invitar avichin, nuꞌej chava: Tabꞌanaꞌ favor tayaꞌ can ri lugar cha va ache va. Y atreꞌ xcaqꞌuix-ka y can cala quiak abꞌanun ncaꞌa pa ruqꞌuisbꞌal tak chꞌacat. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Rumareꞌ antok cꞌo jun ri nibꞌano invitar avichin richin jun cꞌulubꞌic, catzꞌuyeꞌ ri pa ruqꞌuisbꞌal chꞌacat, richin quireꞌ antok ncarutzꞌat-pa ri xbꞌano invitar avichin, xtalka aviqꞌuin y xtuꞌej chava: Amigo, tabꞌanaꞌ favor catakꞌax-pa vaveꞌ. Y antok quireꞌ xtiꞌan chava, quinojiel ri ncaꞌtzꞌuyeꞌ aviqꞌuin chirij ri mesa xticatamaj chi at rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ruma ri nunaꞌ chi nem, xtiꞌan chꞌuteꞌn cha. Ri nunaꞌ chi chꞌuteꞌn-oc, nem xtiꞌan cha, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y ri Jesús xuꞌej jeꞌ cha ri xbꞌano invitar richin: Antok naꞌan jun vaꞌen, man caꞌan invitar joꞌc ri av-amigos, ri atie-atataꞌ, ri i-avachꞌalal, y ri a-vacínix ri i-bꞌayomaꞌ, ruma ijejeꞌ ncaꞌtiquir jeꞌ ncatquiꞌan invitar atreꞌ, y riqꞌuin reꞌ niyoꞌx chava rucꞌaxiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero atreꞌ, antok naꞌan jun namakꞌej pan avachuoch, caꞌbꞌanaꞌ invitar ri i-puobra, ri cuta ri quikꞌaꞌ o cakan, ri ncaꞌjaco ncaꞌin, y ri i-muoy. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xa quireꞌ xtaꞌan, can jaꞌal caquicuot, ruma ri vinak reꞌ man ncaꞌtiquir ta niquiyaꞌ chava rucꞌaxiel, pero atreꞌ xtiyoꞌx rucꞌaxiel chava antok junan xcacꞌastaj-el quiqꞌuin ri choj quicꞌaslien, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y cꞌo jun ri tzꞌuyul chirij ri mesa, antok xraꞌxaj ri tzij ri xuꞌej ri Jesús, xuꞌej cha: Can jaꞌal caꞌquicuot ri xcaꞌcꞌujieꞌ pa ru-reino ri Dios y xcaꞌvaꞌ chireꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y jareꞌ antok ri Jesús xuꞌej: Jun bꞌay jun ache nrajoꞌ nuꞌon jun namakꞌej chirachuoch y nuyaꞌ jun vaꞌen. Rumareꞌ jajaꞌ iqꞌuiy vinak ri xaꞌruꞌon invitar chi ncaꞌbꞌavaꞌ chirachuoch ri kꞌij reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Y antok xalka ri kꞌij chi niꞌan ri vaꞌen, ri ache xutak jun ru-siervo chi xaꞌbꞌarayuoj quinojiel ri i-rubꞌanun invitar. Y ri siervo xbꞌaruꞌej chica: Quixam-pa. Nojiel cꞌo chic listo. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero quinojiel junan ri xquiꞌej-pa, chi man nuyaꞌ ta tiempo chi ncaꞌpa. Ri naꞌay xuꞌej-pa: Tabꞌanaꞌ favor taꞌej cha ri avajaf chi tucuyuꞌ numac ruma cꞌa xinlokꞌ jun vulief, y vacame nicꞌatzin chi nquiꞌa chi nitzꞌataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Jun chic xuꞌej-pa: Tabꞌanaꞌ favor taꞌej cha ri avajaf chi tucuyuꞌ numac ruma cꞌa xaꞌnlokꞌ vuꞌuoꞌ párix nuváquix richin arado, y vacame nicꞌatzin chi ncaꞌntojtobꞌiej. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y jun chic xuꞌej-pa: Man nuyaꞌ ta tiempo chi nquiꞌa ruma xa cꞌajaꞌ xicꞌulieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y antok ri siervo ri takuon-el xtzalaj-pa riqꞌuin ri rajaf, xalruꞌej cha nojiel ri xꞌeꞌx-pa cha. Rumareꞌ ri rajaf xpa royoval, y xuꞌej cha ri ru-siervo: Vacame caꞌin pa tak bꞌay ri icꞌo pa tanamet y caꞌcꞌama-pa ri i-puobra, ri cuta ri quikꞌaꞌ o cakan, ri ncaꞌjaco ncaꞌin, y ri i-muoy. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y antok ri siervo xtzalaj chic pa, xuꞌej cha ri rajaf: Ajaf, xinꞌan ri xaꞌej-el chuva, pero cꞌa qꞌuiy lugar cꞌo. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ri rajaf xuꞌej chic cha ri siervo: Vacame caꞌin pa tak bꞌay ri icꞌo chupan ri tanamet y ri pa tak bꞌay ri ncaꞌa jun chic tanamet, y caꞌbꞌanaꞌ obligar ri vinak ri ncaꞌkꞌax chireꞌ chi caꞌpa chi ninuoj ri vachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ruma niꞌej cꞌa chiva, chi man jun chiquivach ri xaꞌan invitar naꞌay ri xtalvaꞌ, xchaꞌ. Quireꞌ xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y qꞌuiy vinak ri i-bꞌanak chirij ri Jesús. Y jajaꞌ xtzuꞌn can chirij, xpiꞌieꞌ, y xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Xa cꞌo jun ri nrajoꞌ nipa viqꞌuin, nicꞌatzin chi inreꞌ ri más nquirajoꞌ. Ruma xa más ncaꞌrajoꞌ ri rutie-rutataꞌ, ri raxjayil, ri ralcꞌual, ri ruchakꞌ-runimal, ri ranaꞌ o jajaꞌ mismo ri más nrajo-ka-riꞌ, man nucꞌul ta chi ntuoc nu-discípulo. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Y ri man nutzꞌom ta y nucꞌuaj ri ru-cruz y niꞌa chuvij, man nucꞌul ta chi ntuoc nu-discípulo. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ruma xa cꞌo jun chivach ixreꞌ ri nrajoꞌ nuꞌon jun rachuoch nem, ¿man came nitzꞌuyeꞌ ta chi nuꞌon pensar janeꞌ (jaroꞌ) miera xticꞌatzin cha, y vi xa cꞌo nojiel riqꞌuin chi nuqꞌuis rubꞌanic? ");
INSERT INTO cakSNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ruma xa joꞌc ri ru-cimiento ri jay nitiquir nuya-ka y nupabꞌaꞌ can ri samaj chireꞌ, xcaꞌpa ri vinak y xcaꞌtzeꞌn chirij, ");
INSERT INTO cakSNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y xtiquiꞌej chirij: La jun ache la xrajoꞌ xupabꞌaꞌ jun jay, y xa man xtiquir ta xuqꞌuis rubꞌanic, xcaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O xa jun rey chi niꞌrubꞌanaꞌ guerra riqꞌuin jun chic rey, ¿man came nitzꞌuyeꞌ ta chi nuꞌon pensar, xa riqꞌuin diez (lajuj) mil soldados nitiquir nuꞌon guerra riqꞌuin ri jun chic rey ri i-rucꞌamun-pa veinte mil soldados? ");
INSERT INTO cakSNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y xa nuꞌon pensar chi xa man nitiquir ta, jajaꞌ ncaꞌrutak-el achiꞌaꞌ chi ncaꞌbꞌachꞌoꞌ riqꞌuin ri jun rey antok xa cꞌa naj cꞌo-ve. Y ri achiꞌaꞌ reꞌ ncaꞌbꞌatzijuon riqꞌuin chi quireꞌ man nibꞌanataj ta ri guerra. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mareꞌ, xa jun chivach ixreꞌ nrajoꞌ ntuoc nu-discípulo, tubꞌanaꞌ pensar otz naꞌay chi nuyaꞌ can nojiel ri cꞌo riqꞌuin. Xa man nuꞌon ta quireꞌ, man nucꞌuluj ta ntuoc nu-discípulo. ");
INSERT INTO cakSNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atzꞌan, can otz. Pero xa ta ri atzꞌan niqꞌuis-el ri rutzayal, ¿chica ta niꞌan chi nitzalaj chic pa ri rutzayal? ");
INSERT INTO cakSNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ri atzꞌan reꞌ, man otz ta chic nicusas chi niyoꞌx pan ulief, ni man otz ta jeꞌ nixuol riqꞌuin avuona. Xa nicꞌak-el ruma man jun chic nicꞌatzin-ve. Ri cꞌo ruxiquin chi nraꞌxaj, can tiraꞌxaj ri xinꞌej, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y quinojiel ri achiꞌaꞌ i-maloy-impuestos y ri nicꞌaj chic vinak ri niꞌeꞌx aj-bꞌanoy-pecado chica, ncaꞌjiel-pa riqꞌuin ri Jesús richin nicaꞌxaj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y ri achiꞌaꞌ fariseos y ri achiꞌaꞌ escribas ncaꞌtzijuon chirij ri Jesús y niquiꞌej: Ri Jesús jaꞌal ncaꞌruꞌon recibir ri vinak ri niꞌeꞌx aj-bꞌanoy-pecado chica y can niꞌvaꞌ quiqꞌuin, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Rumareꞌ ri Jesús xutzijuoj jun parábola (cꞌambꞌal-tzij) chiquivach y xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Xa ta jun chivach ixreꞌ icꞌo ta i-cien ru-ovejas y nisach ta can jun, ¿man ncaꞌruyaꞌ ta came can bꞌaꞌ ri i-noventa y nueve chireꞌ pa kꞌayis, y niꞌa chi nirucanuj-pa ri jun ri sachnak can, hasta cꞌa niril-na? ");
INSERT INTO cakSNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y antok nirila-pa ri ru-oveja, can niquicuot nuya-pa chutaleꞌn. Niquicuot cꞌa ruma xril-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y antok nibꞌaka chirachuoch, ncaꞌrayuoj ri ru-amigos y ri ru-vacínix, y nuꞌej chica: Quixquicuot viqꞌuin, ruma ri jun nu-oveja ri sachnak can, vacame xinvil-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Y can niꞌej chiva, chi can ncaꞌquicuot ri icꞌo chila chicaj antok cꞌo jun pecador nitzalaj-pa ránima riqꞌuin ri Dios y nuꞌon ri nrajoꞌ jajaꞌ, que chiquivach ri i-noventa y nueve vinak ri choj quicꞌaslien, ri ya xtzalaj-pa cánima riqꞌuin ri Dios y niquiꞌan ri nrajoꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O xa cꞌo ta jun ixok ri cꞌo diez (lajuj) dracmas riqꞌuin, y nutzak jun dracma pa rachuoch, ¿man nutzej ta came jun lámpara ri ixok reꞌ, y numas rupan ri rachuoch y nucanuj ri miera hasta niril? ");
INSERT INTO cakSNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y antok niril, ncaꞌrayuoj ri ru-amigas y ri ru-vacínix, y nuꞌej chica: Quixquicuot viqꞌuin, ruma ri dracma ri sachnak, ya xinvil. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y mareꞌ niꞌej chiva, chi antok cꞌo jun pecador nitzalaj-pa ránima riqꞌuin ri Dios y nuꞌon ri nrajoꞌ jajaꞌ, ri ángeles ri icꞌo riqꞌuin ri Dios altíra ncaꞌquicuot, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y ri Jesús xuꞌej jeꞌ chica: Jun ache cꞌo icaꞌyeꞌ rucꞌajuol. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun kꞌij ri rucꞌajuol coꞌl xuꞌej cha ri rutataꞌ: Táta, tayaꞌ ri nu-herencia ri abꞌanun pensar chi nayaꞌ chuva, xchaꞌ. Y ri rutataꞌ, can xujach ri qui-herencia chica ri icaꞌyeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Cꞌa jubꞌaꞌ cꞌa kꞌij tijach ri qui-herencia, ri coꞌl rucꞌajuol xucꞌayij can nojiel ri ru-herencia. Can qꞌuiy ri miera ri xumol-el, y xꞌa jun lugar ri naj cꞌo-ve. Y antok cꞌo chic chireꞌ, xucꞌuaj jun itziel cꞌaslien y quireꞌ xuqꞌuis ri ru-miera. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Antok ruqꞌuisuon chic nojiel ri ru-miera, xpa jun tremenda viꞌjal chupan ri lugar ri pacheꞌ cꞌo-ve. Y ri alaꞌ reꞌ man jun chic kax nitiquir nulokꞌ ruma manak chic ru-miera. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Y rumareꞌ xbꞌarucꞌutuj rusamaj cha jun ache aj-chireꞌ. Y ri ache reꞌ xutak-el chupan ri ru-finca chi ncaꞌbꞌarutzukuꞌ ak. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y ri alaꞌ altíra nurayij nutej ri niquitej ri ak. Pero man jun niyoꞌn cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y ri alaꞌ reꞌ cꞌajareꞌ xalka paroꞌ, y xuꞌej-ka: ¡Ri iru-muosa ri nataꞌ cꞌo qꞌuiy qui-simíta; y inreꞌ vaveꞌ nquicon riqꞌuin viꞌjal! ");
INSERT INTO cakSNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Vacame nquipalaj y nquiꞌa riqꞌuin ri nataꞌ y xtinꞌej cha: Táta, xinꞌan pecar choch ri Dios y xinꞌan nuchꞌoꞌj chavach atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Vacame man otz ta chic chi naꞌej acꞌajuol chuva. Xa tabꞌanaꞌ chuva incheꞌl jun a-muosa, xcha-ka pa ránima. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y ja xutzꞌom bꞌay, xꞌa chirachuoch ri rutataꞌ. Y cꞌa naj cꞌo-ve chi niꞌka chirachuoch, antok xtzꞌiet-pa ruma ri rutataꞌ. Y ri rutataꞌ altíra xujoyovaj roch; rumareꞌ jun-anin xbꞌarucꞌuluꞌ, xukꞌatiej y xutzꞌubꞌaj ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y ri alaꞌ xuꞌej cha ri rutataꞌ: Táta, xinꞌan pecar choch ri Dios y xinꞌan nuchꞌoꞌj chavach atreꞌ. Man otz ta chic naꞌej acꞌajuol chuva. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ri rutataꞌ xuꞌej chica ri rusamajiel: Tivalasaj-pa ri tziak ri más rakalien y tijalaꞌ ri rutziak. Tiyaꞌ jun anillo chukꞌaꞌ y tiyaꞌ ruxajabꞌ chirakan. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Y ticꞌama-pa ri váquix ri más tiꞌuoj y tiquimisaj; kabꞌanaꞌ jun namakꞌej y kuvaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ruma ri jun nucꞌajuol reꞌ incheꞌl xcon-el chinoch, pero vacame incheꞌl xcꞌastaj chic pa. Sachnak-el chinoch, y vacame xtzalaj chic pa, xchaꞌ ri rutataꞌ. Y ja xtzꞌucutaj-ka ri namakꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y ri huora reꞌ, ri nem alaꞌ nisamaj pan avan. Y antok jajaꞌ nitzalaj-pa y cierca chic ri rachuoch cꞌo-ve, xraꞌxaj chi cꞌo namakꞌej najin. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rumareꞌ xrayuoj jun chiquivach ri siervos y xucꞌutuj cha: ¿Chica xꞌan? ¿Y karruma cꞌo namakꞌej? ");
INSERT INTO cakSNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri siervo xuꞌej cha: Ruma xtzalaj-pa ri achakꞌ otz roch. Rumareꞌ ri atataꞌ xuꞌej chi tiquimisas ri váquix ri más tiꞌuoj. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Antok xraꞌxaj quireꞌ, xpa royoval y man nrajoꞌ ta ntuoc pa jay. Rumareꞌ xiel-pa ri rutataꞌ, y nubꞌocheꞌj chi ntuoc pa jay. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero man xrajoꞌ ta. Jajaꞌ xa xuꞌej cha ri rutataꞌ: Inreꞌ qꞌuiy junaꞌ in-samajnak aviqꞌuin y man jun bꞌay man ta nuniman atzij. Pero man jun bꞌay ayoꞌn chuva nixta jun cabrito chi niꞌan jun namakꞌej quiqꞌuin ri nu-amigos. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y vacame atreꞌ xaquimisaj ri váquix ri más tiꞌuoj, xa ruma xtzalaj-pa ri acꞌajuol ri xbꞌaruqꞌuisaꞌ rajal ri nicꞌaj kax avichin quiqꞌuin ri rameras, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri rutataꞌ xuꞌej cha: Nucꞌajuol, atreꞌ siempre atcꞌo viqꞌuin. Rumareꞌ nojiel ri cꞌo viqꞌuin, can avichin atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero ri achakꞌ, can incheꞌl xcon-el rubꞌanun-el chinoch, y vacame incheꞌl xcꞌastaj chic pa. Sachnak-el y vacame xalka chic kiqꞌuin. Y ruma jajaꞌ xtzalaj-pa, can nicꞌatzin chi vacame nkojquicuot y nakaꞌan namakꞌej. Quireꞌ xuꞌej ri rutataꞌ cha, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xuꞌej jeꞌ chica ri ru-discípulos: Xcꞌujieꞌ jun ache bꞌayuon. Y ri ache reꞌ cꞌo jun ru-mayordomo ri ruyoꞌn paroꞌ nojiel ri rubꞌayomal. Y cha ri ache bꞌayuon xꞌeꞌx chi ri ru-mayordomo nuqꞌuis ri bꞌayomal bꞌanak. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y ri bꞌayuon xutak royoxic ri mayordomo reꞌ. Y antok xalka ri mayordomo, xuꞌej cha: ¿Chica naꞌej chuva chirij ri nitzijos chavij? Vacame taꞌej cheꞌl rubꞌanun ri kax vichin pan akꞌaꞌ, ruma vacame man chic xcasamaj ta viqꞌuin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y ri mayordomo xuꞌej-ka pa ránima: ¿Chica niꞌan vacame? Ruma ri nu-patrón man chic nuyaꞌ ta nusamaj. Y xa ta nquisamaj pan avan, reꞌ nrajoꞌ qꞌuiy uchukꞌaꞌ, y man nquitiquir ta chic. Y xa ta nicꞌutuj nu-limosna pa tak bꞌay, nquiqꞌuix. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya vataꞌn ri chica xtinꞌan chi quireꞌ icꞌo ri ncaꞌbꞌano recibir vichin ri pa tak cachuoch, antok manak chic nusamaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri mayordomo reꞌ xaꞌrayuoj chijujun quinojiel ri cꞌo quicꞌas choch ri ru-patrón, y xucꞌutuj cha ri naꞌay: ¿Janeꞌ (jaroꞌ) acꞌas choch ri nu-patrón? ");
INSERT INTO cakSNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y ri ache ri cꞌo rucꞌas xuꞌej: Inreꞌ cien barriles de aceite de olivo nucꞌas, xchaꞌ. Y ri ru-mayordomo ri ache bꞌayuon xuꞌej cha: Ja ruvuj ri acꞌas reꞌ. Vacame catzꞌuyeꞌ y tabꞌanaꞌ jun chic vuj chaꞌnin. Y joꞌc chic cincuenta barriles de aceite acꞌas tabꞌana-ka chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y antok xalka jun chic ri cꞌo rucꞌas, ri mayordomo xucꞌutuj cha: Y atreꞌ, ¿janeꞌ (jaroꞌ) acꞌas? Ri ache xuꞌej: Inreꞌ cien medidas de trigo nucꞌas, xchaꞌ. Y ri mayordomo xuꞌej cha: Ja ruvuj ri acꞌas reꞌ, vacame tabꞌanaꞌ chic jun vuj. Y joꞌc chic ochenta medidas de trigo acꞌas tabꞌana-ka chupan, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y antok ri ru-patrón xraꞌxaj ri nuꞌon ri jun itziel mayordomo reꞌ, xuꞌej: Jajaꞌ can listo, xchaꞌ. Y ri Jesús xuꞌej jeꞌ: Can quireꞌ niquiꞌan ri vinak ri man quiniman ta ri Dios. Can i-listo chiquivach-ka ijejeꞌ; can más i-listo que chiquivach ri quiniman ri Dios ri i-richin chic ri sakil. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y inreꞌ niꞌej chiva: Ticusaj ri bꞌayomal richin ri roch-ulief, chi nquiꞌtoꞌ ri nicꞌatzin chi ncaꞌtoꞌx. Chi quireꞌ antok ri ibꞌayomal xtiqꞌuis, xtiꞌan recibir chupan ri jay ri man xcaꞌqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun ri otz nuꞌon riqꞌuin jun kax ri manak-oc rakalien, otz jeꞌ xtuꞌon riqꞌuin ri altíra rakalien. Pero ri man otz ta nuꞌon riqꞌuin jun kax ri manak-oc rakalien, xa quireꞌ jeꞌ xtuꞌon riqꞌuin ri altíra rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y xa riqꞌuin ri bꞌayomal richin ri roch-ulief ixreꞌ man otz ta ntiꞌan, ¿xtujach came ri Dios ri ketzij bꞌayomal pan ikꞌaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ruma xa man otz ta ntiꞌan riqꞌuin ri bꞌayomal richin ri roch-ulief ri xa oxkonien pan ikꞌaꞌ, quireꞌ jeꞌ xtiꞌan riqꞌuin ri ketzij bꞌayomal, xa ta nujach ri Dios chiva ri bꞌayomal ri can ivichin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Man jun esclavo nicovin nuꞌon servir icaꞌyeꞌ rajaf, ruma xa nrajoꞌ ri jun rajaf, itziel nutzꞌat ri jun chic. Y xa nunimaj rutzij ri jun, man nitiquir ta nuꞌon quireꞌ riqꞌuin ri jun chic. Quireꞌ jeꞌ, manak cheꞌl chi jun nuꞌon ri nrajoꞌ ri Dios ri xa bꞌanak ránima chirij ri bꞌayomal. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y antok ri achiꞌaꞌ fariseos xcaꞌxaj ri xuꞌej ri Jesús, xaꞌtzeꞌn-ka chirij ruma ijejeꞌ bꞌanak cánima chirij ri bꞌayomal. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y ri Jesús xuꞌej chica: Ixreꞌ can ntiꞌan chiquivach ri vinak chi can choj ri icꞌaslien, y otz nquixtzꞌiet, y nem jeꞌ bꞌanun chiva. Pero ri Dios rataꞌn chica ri cꞌo pan ivánima, y man otz ta nquixrutzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ja ri ru-ley ri Moisés y ri tzꞌibꞌan can cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, jareꞌ ri nitzijos. Pero antok xutzꞌom samaj ri Juan el Bautista, jareꞌ antok xtiquir-pa rutzijoxic chirij antok ri vinak ncaꞌuoc chupan ri ru-reino ri Dios. Y iqꞌuiy vinak ri altíra niquitej quikꞌij chi ncaꞌuoc chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Pero más fácil chi ri roch-ulief y ri rocaj can xcaꞌqꞌuis, que choch ri ley, ruma man jun letra chupan ri ley choj cala xticꞌujieꞌ can, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y ri Jesús xuꞌej jeꞌ: Ri ache ri nujach-riꞌ riqꞌuin ri raxjayil y nicꞌulieꞌ riqꞌuin jun chic ixok, can nuꞌon pecado choch ri Dios. Y ri ache ri nicꞌulieꞌ riqꞌuin ri ixok ri jachuon-el, can nuꞌon jeꞌ pecado choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y ri Jesús xuꞌej jeꞌ: Xcꞌujieꞌ jun ache ri altíra bꞌayuon, ri ruyuon jaꞌal tak tziak ri altíra cara cajal ri ncaꞌrucusaj, y kꞌij-kꞌij ncaꞌruꞌon namakꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Xcꞌujieꞌ jeꞌ jun ache ri cꞌutuy-limosna y qꞌuisnak paroꞌ ri ru-cuerpo riqꞌuin chꞌaꞌc. Jajaꞌ rubꞌinan Lázaro, y chuchiꞌ rachuoch ri bꞌayuon nicꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro altíra nurayij nucꞌux ri rupixqꞌuil ri simíta ri ncaꞌtzak chuxieꞌ ri ru-mesa ri bꞌayuon. Y ri tzꞌeꞌ ncaꞌlka riqꞌuin y niquirakꞌ ri chꞌaꞌc ri cꞌo chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y jun kꞌij ri nucꞌutuj limosna xcon, y xucꞌuax-el cuma ri ángeles chupan ri utzulaj lugar ri pacheꞌ cꞌo-ve ri Abraham. Y ri ache bꞌayuon xcon jeꞌ y xmuk. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y antok ri bꞌayuon nuꞌon chic sufrir chupan ri lugar richin sufrimiento, cꞌa naj xtzuꞌn-el, y xutzꞌat ri Abraham, y xutzꞌat jeꞌ ri Lázaro rakꞌal-apa choch-rucꞌuꞌx ri Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ri ache bꞌayuon riqꞌuin ruchukꞌaꞌ xchꞌo-el, y xuꞌej cha ri Abraham: Nataꞌ Abraham, tajoyovaj noch. Tabꞌanaꞌ favor taꞌej cha ri Lázaro chi tuchꞌakabꞌa-pa ri ruve-rukꞌaꞌ, y tataka-pa viqꞌuin chi nalruya-ka chutzaꞌn vakꞌ. Ruma altíra niꞌan sufrir chupan va kꞌakꞌ va, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ri Abraham xuꞌej cha: Nucꞌajuol, talka pan aveꞌ chi antok xacꞌasieꞌ choch-ulief, can jaꞌal xakꞌasaj ri acꞌaslien, y ri Lázaro qꞌuiy sufrimiento xukꞌasaj; pero vacame jajaꞌ jaꞌal ri rucꞌaslien ri xalrilaꞌ vaveꞌ, y atreꞌ xa jun cꞌaslien richin sufrimiento. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y cꞌo jeꞌ jun nem sivan chikacajol. Rumareꞌ, xa ta cꞌo jun chakavach ojreꞌ nrajoꞌ ta nakꞌax-ka iviqꞌuin, man nitiquir ta. Y xa ta jun chivach ixreꞌ nrajoꞌ ta nipa vaveꞌ kiqꞌuin ojreꞌ, man nitiquir ta jeꞌ, xchaꞌ ri Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y ri ache bꞌayuon xuꞌej cꞌa chic: Nivajoꞌ nicꞌutuj favor chava atreꞌ nataꞌ Abraham. Tataka-el bꞌaꞌ ri Lázaro choch-ulief, chirachuoch ri nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ruma icꞌo vuꞌuoꞌ nchakꞌ, y nivajoꞌ chi jajaꞌ nichꞌoꞌ ta bꞌaꞌ chica chi quireꞌ man ncaꞌpa ta jeꞌ vaveꞌ chupan va lugar richin sufrimiento, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y ri Abraham xuꞌej cha: Ijejeꞌ cꞌo quiqꞌuin ri ruchꞌabꞌal ri Dios ri rutzꞌibꞌan can ri Moisés y ri tzꞌibꞌan can cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. Jareꞌ ticaꞌxaj, xchaꞌ ri Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y ri ache bꞌayuon xuꞌej: Man niquiꞌan ta, nataꞌ Abraham. Pero xa cꞌo ta jun quiminak nicꞌastaj-el y niꞌka quiqꞌuin ijejeꞌ, can xtitzalaj-pa cánima riqꞌuin ri Dios y niquiꞌan ri nrajoꞌ jajaꞌ, xchaꞌ ri bꞌayuon. ");
INSERT INTO cakSNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ri Abraham xuꞌej cha: Xa man nicaꞌxaj ta ri ruchꞌabꞌal ri Dios ri rutzꞌibꞌan can ri Moisés, y ri quitzꞌibꞌan can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, man xtiquinimaj ta jeꞌ jun ri nicꞌastaj-el chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Y ri Jesús xuꞌej chica ri ru-discípulos: Can siempre icꞌo ri xcaꞌbꞌano chica nicꞌaj chic chi ncaꞌtzak. ¡Pero juyeꞌ roch ri nibꞌano cha jun chic chi nitzak! ");
INSERT INTO cakSNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Más otz nixim jun nem abꞌaj (caꞌ) chukul y nicꞌak chupan ri mar, que nuꞌon chi nitzak jun ri in-runiman mesque manak-oc rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Rumareꞌ ixreꞌ tibꞌanaꞌ cuenta-iviꞌ. Y xa cꞌo jun hermano nuꞌon jun itziel chava, tachꞌolij. Y xa ri nibꞌano quireꞌ chava nucꞌax runoꞌj y nalruꞌej chava chi tabꞌanaꞌ perdonar, can tabꞌanaꞌ perdonar. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y xa chupan jun kꞌij siete (vukuꞌ) mul nuꞌon itziel chava y siete (vukuꞌ) mul jeꞌ nipa aviqꞌuin y nalruꞌej chava: Tabꞌanaꞌ perdonar ri nuchꞌoꞌj; can tabꞌanaꞌ perdonar ri ruchꞌoꞌj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y ri apóstoles xquiꞌej cha ri Ajaf Jesús: Tabꞌanaꞌ chika chi nakacukubꞌaꞌ más kacꞌuꞌx riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pero ri Ajaf Jesús xuꞌej chica: Xa ta icukubꞌan icꞌuꞌx riqꞌuin ri Dios, mesque incheꞌl-oc jun chꞌiti ijaꞌtz richin ri mostaza, nquixcovin ntiꞌej cha la chieꞌ sicómoro la: Catiel-el vaveꞌ y atica-aviꞌ chupan ri mar, y ri chieꞌ reꞌ can nunimaj itzij. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Y xa ta jun chivach ixreꞌ cꞌo ta jun ru-esclavo, y rutakuon-el pan avan chi xbꞌarubꞌanaꞌ arar ri ulief o chi xaꞌbꞌaruchajij váquix, ¿ja came antok nitzalaj-pa, nuꞌej cha: Catuoc-pa, catzꞌuyeꞌ chirij ri mesa y cavaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pa rucꞌaxiel reꞌ nuꞌej cha: Tachojmij ri nu-cena, y tachojmij jeꞌ aviꞌ atreꞌ chi naya-pa ri xtintej, y cꞌa xquivaꞌ na inreꞌ, cꞌajareꞌ xcavaꞌ atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Y nuyaꞌ came tiox bꞌaꞌ cha ri esclavo ruma xuꞌon ri xuꞌej cha? Manak. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y incheꞌl ri esclavo reꞌ, quireꞌ jeꞌ ixreꞌ. Antok ibꞌanun chic ri samaj ri nuꞌej ri Dios chiva, tiꞌej: Ojreꞌ oj esclavos ri man jun nkojcꞌatzin-ve. Ruma xa joꞌc ri eꞌn chika, joꞌc reꞌ ri xkaꞌan, quixchaꞌ, xchaꞌ ri Jesús chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y antok ri Jesús xutzꞌom chic el bꞌay chi niꞌa Jerusalén, xakꞌax chiquicajol ri Samaria y ri Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y antok xbꞌaka jun aldea, i-diez (lajuj) achiꞌaꞌ ri cꞌo ri yabꞌil lepra chiquij xaꞌbꞌaꞌiel-pa pa rubꞌiey ri Jesús y cꞌa naj xaꞌpiꞌie-ve-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y cof xaꞌchꞌo-pa cha y xquiꞌej: ¡Jesús, Maestro, tajoyovaj kavach! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y ri Jesús xaꞌrutzꞌat y xuꞌej chica: Quixꞌin y icꞌutu-iviꞌ chiquivach ri sacerdotes, xchaꞌ ri Jesús chica. Y antok i-bꞌanak, ri quiyabꞌil xqꞌuis-el chiquij y sak xquiꞌan-ka. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun chiquivach ri i-diez (lajuj) achiꞌaꞌ, antok xutzꞌat chi xcꞌachoj riqꞌuin ri ruyabꞌil, ja xtzalaj-pa chirij. Y can nuyaꞌ rukꞌij ri Dios, y can cof nichꞌoꞌ antok nuyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y antok xalka riqꞌuin ri Jesús, xxuquieꞌ chukul rakan y xulucubꞌa-ka-riꞌ cꞌa pan ulief y nuyaꞌ tiox bꞌaꞌ cha. Ri ache reꞌ aj-Samaria. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y ri Jesús xuꞌej: ¿Man i-diez (lajuj) ta came ri xqꞌuis-el ri quiyabꞌil chiquij? ¿Y ri i-nueve (bꞌilijieꞌ) pacheꞌ icꞌo-ve? ");
INSERT INTO cakSNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Man jun chic cꞌa ri xtzalaj-pa chi nalruyaꞌ rukꞌij ri Dios? ¿Xa ja ri jun ri man israelita ta ri xtzalaj-pa? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y ri Jesús xuꞌej cha ri ache aj-Samaria: Capalaj y caꞌin. Xacꞌachoj ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y ri achiꞌaꞌ fariseos xquicꞌutuj cha ri Jesús chi jampeꞌ cꞌa xtalka ri ru-reino ri Dios. Y ri Jesús xuꞌej chica: Man jun xtinaꞌien jampeꞌ xtalka ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y man jun xtiꞌeꞌn chi ja cꞌo vaveꞌ, o ja cꞌo chila, ruma ri ru-reino ri Dios cꞌo chic iviqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y jajaꞌ xchꞌoꞌ chica ri ru-discípulos y xuꞌej: Xtipa tiempo antok ixreꞌ xtirayij chi nicꞌujieꞌ ta iviqꞌuin mesque joꞌc jun kꞌij, ri Xtak-pa chicaj chi xalax chiꞌicajol; pero man xtitzꞌat ta chic. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y icꞌo ri xcaꞌeꞌn chiva: Ja cꞌo vaveꞌ o ja cꞌo chila. Pero ixreꞌ man quixꞌa quiqꞌuin, ni man quixꞌa jeꞌ chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ruma antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay, can xtikꞌalajin-ve jaꞌal. Can xtibꞌanataj cꞌa incheꞌl nuꞌon ri yocopaꞌ, ri nuꞌon cala pacheꞌ ntiel-pa ri kꞌij, y cꞌa kꞌalaj pacheꞌ nika-ka ri kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero naꞌay cꞌo chi xtukꞌasaj qꞌuiy sufrimiento, y itziel xtitzꞌiet jeꞌ cuma ri vinak richin ri tiempo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Can incheꞌl xbꞌanataj pa ru-tiempo ri Noé, can quireꞌ jeꞌ xtibꞌanataj antok xtipa ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Pa ru-tiempo ri Noé, ri vinak joꞌc ncaꞌvaꞌ y ncaꞌkumun, joꞌc reꞌ niquiꞌan pensar, ncaꞌcꞌulieꞌ y ncaꞌyoꞌx chi ncaꞌcꞌulieꞌ, y cꞌa quireꞌ niquiꞌan chupan ri kꞌij antok ri Noé xuoc chupan ri arca (ri incheꞌl jun nem barco), y xpa cꞌa ri diluvio, y quinojiel ri vinak xaꞌcon. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y quireꞌ jeꞌ xbꞌanataj pa ru-tiempo ri Lot. Ri vinak ncaꞌvaꞌ y ncaꞌkumun, ncaꞌlakꞌo, ncaꞌcꞌayin, ncaꞌtico y ncaꞌquiꞌan jay. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y ri kꞌij antok ri Lot y ri ru-familia xquiyaꞌ can ri tanamet Sodoma, xka-pa chicaj kꞌakꞌ y azufre paroꞌ ri tanamet. Can incheꞌl jobꞌ xuꞌon, y quinojiel ri vinak ri icꞌo chireꞌ xaꞌqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y quireꞌ xtibꞌanataj antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtalka chic vaveꞌ choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri cꞌo paroꞌ ri rachuoch antok xtalka ri kꞌij reꞌ, man tika-pa chi ntuoc pa rachuoch chi cꞌo niruma-pa. Y ri cꞌo pan avan quireꞌ jeꞌ, man titzalaj-pa chirachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Talka pan iveꞌ ri xuꞌon ri raxjayil ri Lot, antok ri Dios xuparuoj ri tanamet Sodoma. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri altíra cꞌa nrajoꞌ ri rucꞌaslien vaveꞌ ri choch-ulief, man xticolotaj ta. Pero ri jun, mesque niquimisas vuma inreꞌ, can xticolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Niꞌej cꞌa chiva chi chupan ri akꞌaꞌ reꞌ, icꞌo icaꞌyeꞌ ncaꞌvar choch jun chꞌat, jun xtucꞌuax y ri jun chic xticꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Icꞌo icaꞌyeꞌ ixokiꞌ ri junan ncaꞌqueꞌn, jun xtucꞌuax y ri jun chic xticꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y xa icꞌo icaꞌyeꞌ achiꞌaꞌ ri junan ncaꞌsamaj pan avan, jun xtucꞌuax y ri jun chic xticꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y antok ri discípulos caxan chic ri xuꞌej ri Jesús, xquicꞌutuj cha: Ajaf, ¿pacheꞌ xtibꞌanataj-ve reꞌ? Y ri Jesús xuꞌej chica: Pacheꞌ cꞌo-ve jun quiminak, chireꞌ jeꞌ ncaꞌka-ve ri cꞌuch. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y ri Jesús xutzijuoj jun parábola (cꞌambꞌal-tzij) chica ri ru-discípulos chi nucꞌut chiquivach chi nicꞌatzin chi siempre niquiꞌan orar y man tiquimalij. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jajaꞌ xuꞌej chica: Chupan jun tanamet cꞌo jun juez ri man nuxiꞌij ta riꞌ choch ri Dios, y man jun jeꞌ quikalien nuꞌon chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chupan jeꞌ ri tanamet reꞌ, cꞌo jun malcaꞌn-ixok ri ntiel-ntuoc riqꞌuin ri jun juez reꞌ, y nuꞌej cha: Tabꞌanaꞌ justicia chirij ri bꞌanayuon itziel chuva. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y qꞌuiy tiempo xakꞌax y ri juez reꞌ man nrajoꞌ ta nuꞌon arreglar ri ru-problema ri malcaꞌn-ixok. Pero jun kꞌij ri juez reꞌ xuꞌej-ka pa ránima: Mesque man nixiꞌij ta viꞌ choch ri Dios, ni man jun jeꞌ quikalien niꞌan chica ri vinak, ");
INSERT INTO cakSNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero ruma ri ixok reꞌ ntiel-ntuoc viqꞌuin, mejor niꞌan arreglar. Ruma xa man niꞌan ta, xtakꞌax nucꞌuꞌx riqꞌuin ruma siempre xtalka. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y ri Ajaf Jesús xuꞌej: Xivaxaj ri xuꞌej ri juez reꞌ, mesque jajaꞌ man otz ta nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","¿Y será que ri Dios man ncaꞌrutoꞌ ta came ri i-ruchoꞌn chic, ri chi pakꞌij chi chakꞌaꞌ niquiꞌan orar? ¿Ri Dios man chaꞌnin ta came xcaꞌruto-pa? ");
INSERT INTO cakSNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Inreꞌ niꞌej chiva chi chaꞌnin xcaꞌruto-pa. Y antok ri Xtak-pa chicaj chi xalax chiꞌicajol xtipa chic jun bꞌay vaveꞌ ri choch-ulief, ¿cꞌa icꞌo came quicukubꞌan quicꞌuꞌx riqꞌuin ri Dios? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y ri Jesús xuꞌej chic cꞌa jun parábola (cꞌambꞌal-tzij) chiquivach ri vinak, ruma icꞌo chiquivach ijejeꞌ ri niquinaꞌ chi i-choj tak vinak, y xa itziel ncaꞌquitzꞌat ri nicꞌaj chic. Rumareꞌ ri Jesús xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Icꞌo icaꞌyeꞌ achiꞌaꞌ ri xaꞌbꞌaka pa templo chi niquinaꞌ orar: Jun fariseo, y jun maloy-impuestos. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri ache fariseo paꞌl nuꞌon orar, y nuꞌej chupan ri ru-oración: Dios, tiox bꞌaꞌ niyaꞌ chava ruma inreꞌ man in junan ta quiqꞌuin ri nicꞌaj chic. Ruma ri nicꞌaj chic i-alakꞌomaꞌ, ncaꞌquicanuj jeꞌ nicꞌaj chic ixokiꞌ mesque i-cꞌulan, y man quicꞌuan ta jun choj cꞌaslien. Ni man in junan ta jeꞌ riqꞌuin ri jun ache maloy-impuestos la. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ruma inreꞌ caꞌyeꞌ kꞌij chupan jun semana niꞌan ayuno. Y nojiel ri nichꞌec, nicꞌan-el ri décima parte cha, y niyaꞌ chava atreꞌ, xchaꞌ ri ache fariseo chupan ri ru-oración. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero ri ache maloy-impuestos cꞌa naj cꞌo can chi nuꞌon orar. Pero rulucubꞌan rujaluon; ruma choch jajaꞌ man otz ta chi nitzuꞌn-el chicaj, y nutin cꞌa roch-rucꞌuꞌx cha ri rukꞌaꞌ y nuꞌej cꞌa: Dios, tajoyovaj noch, ruma inreꞌ in jun ache pecador chavach. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Y ri Jesús xuꞌej jeꞌ: Can niꞌej chiva chi ri ache maloy-impuestos xtzalaj chirachuoch, man jun chic ru-pecado choch ri Dios. Pero ri ache fariseo man quireꞌ ta xtzalaj. Ruma chica-na cꞌa ri nunaꞌ chi altíra rakalien, xa xtiꞌan cha chi manak rakalien. Pero ri nunaꞌ chi manak-oc rakalien, nem xtiꞌan cha, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y ri vinak ncaꞌquicꞌam-pa ri acꞌolaꞌ riqꞌuin ri Jesús, chi nuyaꞌ rukꞌaꞌ pa quiveꞌ chi ncaꞌruꞌon bendecir. Pero ri discípulos xquitzꞌat y xaꞌquichꞌolij ri vinak chi man tiquiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ri Jesús xaꞌrayuoj ri acꞌolaꞌ y xuꞌej chica ri ru-discípulos: Tiyaꞌ permiso chica ri acꞌolaꞌ chi ncaꞌpa viqꞌuin inreꞌ, y man quiꞌikꞌat. Ruma ri ru-reino ri Dios xa quichin ri i-incheꞌl acꞌolaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y can ketzij ri niꞌej chiva, chi xa jun man nuꞌon ta recibir ri ru-reino ri Dios incheꞌl nuꞌon jun acꞌual, man xtuoc ta chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y cꞌo jun cꞌajol ache principal xucꞌutuj cha ri Jesús: Utzulaj Maestro, ¿chica niꞌan chi nivil ri cꞌaslien ri man niqꞌuis ta? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y ri Jesús xuꞌej cha: ¿Karruma naꞌej otz chuva inreꞌ? Ruma man jun vinak otz, xa joꞌc ri Dios otz. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Avataꞌn ri mandamientos ri xuyaꞌ ri Dios cha ri Moisés ri ojier can, ri nuꞌej: Ri at-cꞌulan, man tavucꞌuaj-aviꞌ riqꞌuin jun chic; man caquimisan; man catalakꞌ; man tatzꞌak tzij chirij jun chic; caꞌbꞌanaꞌ respetar ri atie-atataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y ri cꞌajol ache xuꞌej cha ri Jesús: Nojiel reꞌ cꞌa in coꞌl-oc nutzꞌamuon-pa rubꞌanic, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Antok ri Jesús xraꞌxaj reꞌ, xuꞌej: Cꞌa cꞌo jun kax ri man abꞌanun ta. Tacꞌayij nojiel ri cꞌo aviqꞌuin y ri rajal tajachaꞌ chiquivach ri i-puobra, chi quireꞌ nicꞌujieꞌ abꞌayomal chicaj. Y catam-pa viqꞌuin y ncaꞌa chuvij, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y antok ri cꞌajol ache xraꞌxaj ri xuꞌej ri Jesús, altíra xbꞌisuon-ka, ruma qꞌuiy ri rubꞌayomal cꞌo. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y antok ri Jesús xutzꞌat chi altíra xbꞌisuon-ka, xuꞌej: ¡Ri cꞌo qꞌuiy quibꞌayomal, can cuesta chi ncaꞌuoc pa ru-reino ri Dios! ");
INSERT INTO cakSNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ruma xa más fácil nakꞌax jun camello chupan jun ruvaruol jun acúxa, que choch jun bꞌayuon chi ntuoc pa ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri xaꞌcꞌaxan ri xuꞌej ri Jesús, xquiꞌej: ¿Chica cꞌa xticolotaj? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y ri Jesús xuꞌej chica: Ri vinak man nojiel ta ncaꞌtiquir niquiꞌan, pero ri Dios nojiel nitiquir nuꞌon, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Y jareꞌ antok ri Pedro xuꞌej: Ojreꞌ kayoꞌn can ri kax kichin y oj-bꞌanak chavij. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xuꞌej chica: Can ketzij ri niꞌej chiva, chi chica-na ri ruyoꞌn can rachuoch, o rutie-rutataꞌ, o runimal, o ruchakꞌ, o raxjayil, o ralcꞌual, chi nuꞌon rusamaj ri Dios y ncaꞌrutoꞌ ri ncaꞌuoc pa ru-reino ri Dios; ");
INSERT INTO cakSNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","can qꞌuiy yan ri xtiyoꞌx cha chupan ri tiempo vacame. Y chupan-apa ri jun chic tiempo ri chakavach-apa, can xtiyoꞌx cha ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y ri Jesús xaꞌrucꞌuaj aparte ri doce (cabꞌalajuj) discípulos chi nichꞌoꞌ quiqꞌuin, y xuꞌej: Ixreꞌ ivataꞌn chi cꞌa pa tanamet Jerusalén nkuꞌa-ve-el, y chireꞌ qꞌuiy ri xtiꞌan cha ri Xtak-pa chicaj chi xalax chiꞌicajol. Ruma chireꞌ xtibꞌanataj nojiel ri tzꞌibꞌan can chirij cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xtijach pa quikꞌaꞌ ri vinak ri man israelitas ta. Y ri vinak reꞌ xcaꞌtzeꞌn chirij, xtiquiꞌej pakon tak tzij cha y xtiquichubꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Después antok quichꞌayuon chic, xtiquiquimisaj. Pero chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ri ru-discípulos man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) ri xuꞌej. Ri tzij reꞌ xa avan chiquivach, rumareꞌ joꞌc xcaꞌxaj y man cataꞌn ta ri chica xrajoꞌ xuꞌej chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Antok ri Jesús ya ntuoc pa tanamet Jericó, chuchi-bꞌay tzꞌuyul jun ache muoy chi nucꞌutuj ru-limosna. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y antok ri muoy reꞌ xraꞌxaj chi qꞌuiy vinak ncaꞌkꞌax, xucꞌutuj chi chica reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y xquiꞌej cha chi ja ri Jesús ri aj-Nazaret ri nakꞌax chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y ri ache muoy riqꞌuin ruchukꞌaꞌ xchꞌoꞌ, y xuꞌej: ¡Jesús, ri at Rumáma can ri rey David, tajoyovaj noch! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ri vinak ri i-kꞌaxnak choch ri Jesús, xquichꞌolij ri ache chi man chic tichꞌo-pa. Pero jajaꞌ xa riqꞌuin más ruchukꞌaꞌ xchꞌo-pa y xuꞌej: ¡Atreꞌ ri at Rumáma can ri rey David, tajoyovaj noch! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y ri Jesús xpiꞌie-ka y xuꞌej chi ticꞌamar-pa choch. Y antok cꞌo chic ri ache choch, xucꞌutuj cha: ");
INSERT INTO cakSNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Chica navajoꞌ chi niꞌan? Y ri ache muoy xuꞌej cha: Ajaf, inreꞌ nivajoꞌ nquitzuꞌn, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xuꞌej cha: Catzuꞌn cꞌa. Ruma xacukubꞌaꞌ acꞌuꞌx viqꞌuin, xacꞌachoj. ");
INSERT INTO cakSNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y ri ache muoy ja xtzuꞌn y xꞌa chirij ri Jesús, y nuyaꞌ rukꞌij ri Dios. Y quinojiel ri vinak ri xaꞌtzꞌato chi ri muoy xtzuꞌn, can xquiyaꞌ jeꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y ri Jesús xuoc pa tanamet Jericó, y choj nakꞌax chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y chupan ri tanamet reꞌ cꞌo jun ache bꞌayuon rubꞌinan Zaqueo. Ri ache reꞌ, jareꞌ ri qui-jefe ri maloy-impuestos. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y jajaꞌ nutej rukꞌij chi nutzꞌat ri Jesús, pero ruma iqꞌuiy vinak icꞌo y xa coꞌl-oc rakan, rumareꞌ man nicovin ta nutzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Rumareꞌ jajaꞌ jun-anin xakꞌax y xbꞌajotieꞌ chukꞌaꞌ jun chieꞌ sicómoro chi quireꞌ nutzꞌat-el ri Jesús, ruma tiene que nakꞌax chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y antok ri Jesús xbꞌaka chireꞌ, xtzuꞌn-el chicaj chukꞌaꞌ ri chieꞌ, y xuꞌej cha: Zaqueo, chaꞌnin caka-pa, ruma vacame nicꞌatzin chi nquibꞌaka chavachuoch chi nquinuxlan jubꞌaꞌ chireꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo chaꞌnin xka-pa, y can niquicuot xuꞌon recibir ri Jesús pa rachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Antok ri vinak quireꞌ xquitzꞌat, xquiꞌej-ka chi ri Jesús xa pa rachuoch jun ache pecador xbꞌacꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y ri Zaqueo xpiꞌieꞌ y xuꞌej cha ri Ajaf Jesús: Ajaf, vacame la mitad ri nubꞌayomal niyaꞌ chica ri i-puobra. Y xa cꞌo valakꞌan cha jun, can cajeꞌ chic más rucꞌaxiel xtintzoliej cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xuꞌej cha: Vacame xalka ri salvación (colotajic) chupan va jay va, ruma jajaꞌ jun rumáma can ri Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ruma ri Xtak-pa chicaj chi xalax chiꞌicajol, can xpa chi ncaꞌrucanuj y chi ncaꞌrucol ri i-sachnak chupan ri pecado, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Antok ri Jesús ruꞌeꞌn chic nojiel reꞌ chica ri vinak, xutzijuoj jun parábola (cꞌambꞌal-tzij) chica, ruma cierca chic cꞌo-ve chi niꞌka Jerusalén y ruma jeꞌ ri vinak ri ncaꞌcꞌaxan richin, niquiꞌan pensar chi antok jajaꞌ xtiꞌka pa tanamet, can ja xtikꞌalajin ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y jajaꞌ xuꞌej: Cꞌo jun utzulaj ache xꞌa jun chic nación ri naj cꞌo-ve, chi niꞌan-pa rey cha y cꞌajareꞌ nitzalaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero antok cꞌa majaꞌ tiꞌa, xaꞌrayuoj i-diez (lajuj) rusamajiel y xuyaꞌ can diez (lajuj) minas chica, y xuꞌej chica: Quixsamaj chirij ri xinyaꞌ can chiva hasta cꞌa antok xquitzalaj-pa inreꞌ, xchaꞌ can chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero ri ruvanakil ri ache reꞌ itziel niquitzꞌat, y rumareꞌ xaꞌquitak-el nicꞌaj achiꞌaꞌ chupan ri nación ri pacheꞌ niꞌan-pa rey cha. Y xꞌeꞌx-el chica: Ojreꞌ man nakajoꞌ ta chi ri ache reꞌ ntuoc ka-rey, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero ri jun ache reꞌ xꞌan-pa rey cha, y después xtzalaj-pa. Y antok cꞌo chic ri pa ru-nación, xutak quiyoxic ri rusamajiel ri ruyoꞌn can miera chica, ruma nrajoꞌ nunaꞌiej janeꞌ (jaroꞌ) miera quichꞌacuon chiquijunal. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Antok xalka ri naꞌay samajiel, xuꞌej: Ajaf, ri mina ri xayaꞌ can chuva xinchꞌec diez (lajuj) más, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ri ache, rey chic, xuꞌej cha: Otz ri xaꞌan. At jun utzulaj nusamajiel. Y ruma otz xaꞌan riqꞌuin ri jubꞌaꞌ xinyaꞌ can pan akꞌaꞌ, vacame niyaꞌ diez (lajuj) tanamet pan akꞌaꞌ chi ncaꞌan gobernar, xchaꞌ ri rey cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Antok xalka jun chic samajiel, xuꞌej: Ajaf, ri mina ri xayaꞌ can chuva xinchꞌec vuꞌuoꞌ más, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ri rey xuꞌej jeꞌ cha: Ruma otz ri xaꞌan riqꞌuin ri jubꞌaꞌ ri xinyaꞌ can chava, vacame niyaꞌ vuꞌuoꞌ tanamet pan akꞌaꞌ chi ncaꞌan gobernar, xchaꞌ ri rey cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Xalka jun chic, xuꞌej: Ajaf, ja a-mina va; xinyaꞌ chupan jun pañuelo y xinyac ");
INSERT INTO cakSNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ruma inreꞌ nixiꞌij-viꞌ chavach. Ruma atreꞌ at jun ache altíra at ruquiy. Xa nacꞌan-el ri man avichin ta. Y navajoꞌ naꞌan cosechar ri xa man atreꞌ ta ri at-tiquiyuon, xchaꞌ cha ri rey. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ri rey xuꞌej cha: Atreꞌ at jun itziel samajiel. Ri tzij ri xaꞌej, jareꞌ ri xtincusaj chi ncanꞌan juzgar. Ruma xa avataꞌn chi inreꞌ in altíra ruquiy, chi inreꞌ nicꞌan-el ri man vichin ta, y quireꞌ jeꞌ nivajoꞌ niꞌan cosechar ri man inreꞌ ta in-tiquiyuon; ");
INSERT INTO cakSNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿karruma man xayaꞌ ta ri nu-miera pa banco chi quireꞌ vacame antok xitzalaj-pa niꞌan ta recibir ri nu-miera y ri interés (ralabꞌal)? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ri rey xuꞌej chica ri icꞌo chireꞌ: Ticꞌama-el ri mina cha, y tiyaꞌ cha ri jun ri cꞌo diez (lajuj) minas riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ri icꞌo chireꞌ xquiꞌej: Ajaf, pero jajaꞌ cꞌo chic diez (lajuj) pa rukꞌaꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero jajaꞌ xuꞌej chica: Inreꞌ niꞌej chiva, chi ri cꞌo riqꞌuin, xtiyoꞌx más cha. Pero ri xa man qꞌuiy ta cꞌo riqꞌuin, hasta reꞌ xtalasas-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Vacame cꞌa, ri itziel ncaꞌtzꞌato vichin, ri man xcajoꞌ ta chi inreꞌ xinuoc rey: Quiꞌcꞌama-pa, y ticꞌama-el quijaluon chinoch, xchaꞌ ri rey. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y antok ri Jesús xtanieꞌ riqꞌuin ri xuꞌej chica ri vinak, xꞌa chiquivach ri ru-discípulos chi niꞌa-el pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y antok cierca chic icꞌo-ve ri aldeas Betfagé y Betania, ri icꞌo choch ri juyuꞌ rubꞌinan Olivos, ri Jesús xaꞌrutak-el icaꞌyeꞌ chiquivach ri ru-discípulos, ");
INSERT INTO cakSNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y xuꞌej-el chica: Quixꞌin chupan la aldea la, y antok xquixuoc, xtivil jun alaj burro ximil chireꞌ, ri man jun bꞌay chꞌacol ache chirij. Tiquira-pa y ticꞌama-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y xa cꞌo jun xticꞌutun-pa chiva: ¿Karruma ntiquir-el ri alaj burro? tiꞌej cha chi nicꞌatzin cha ri Ajaf, xcha-el ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xaꞌa ri icaꞌyeꞌ discípulos ri xaꞌtak-el, y xquil ri alaj burro ri incheꞌl eꞌn-el chica ruma ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Y antok ja niquiquir, ri rajaf xquiꞌej-pa chica: ¿Karruma ntiquir-el ri alaj burro? xaꞌcha-pa chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y ri discípulos xquiꞌej can chica: Xa nicꞌatzin cha ri Ajaf, xaꞌchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquicꞌam-pa riqꞌuin ri Jesús. Y ri discípulos xquiya-el ri qui-manta chirij ri alaj burro y xquichꞌocobꞌa-el ri Jesús chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y antok bꞌanak ri Jesús, ri vinak niquilicꞌ ri qui-manta pa rubꞌiey. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y antok xalka cierca ri lugar pacheꞌ xulan nuꞌon ri bꞌay choch ri juyuꞌ Olivos, quinojiel ri ru-discípulos ri Jesús, ruma niquicuot cánima, riqꞌuin nojiel quichukꞌaꞌ niquiyaꞌ rukꞌij ri Dios. Quireꞌ niquiꞌan ruma ri milagros ri quitzꞌatuon. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ijejeꞌ niquiꞌej: ¡Bendito ri Rey ri patanak pa rubꞌeꞌ ri Ajaf Dios! ¡Can paz cꞌa chicaj! ¡Can qꞌuiy cꞌa rukꞌij niyoꞌx ri Dios chicaj! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chiquicajol ri vinak i-bꞌanak nicꞌaj achiꞌaꞌ fariseos. Y ijejeꞌ xquiꞌej cha ri Jesús: Maestro, caꞌchꞌolij ri a-discípulos, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero ri Jesús xuꞌej chica: Can niꞌej chiva, xa ncaꞌtanie-ka ijejeꞌ, ja ri abꞌaj xcaꞌchꞌo-pa chi niquiyaꞌ nukꞌij, xchaꞌ chica ri achiꞌaꞌ fariseos. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y antok ri Jesús más cierca cꞌo-ve ri tanamet Jerusalén, xutzꞌat-apa y xrokꞌiej ri tanamet reꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xuꞌej: ¡Ixreꞌ ri ixcꞌo Jerusalén, mesque cꞌajaꞌ ta vacame ntivatamaj ri chica niyoꞌn ri paz riqꞌuin ivánima! Pero xa avan chivach, rumareꞌ man nquixtiquir ta ntitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ruma xtipa kꞌij man otz ta chivij antok qꞌuiy soldados xcaꞌpalaj-pa chivij, y xtiquitzꞌapij rij ri itanamit cha jun chic incheꞌl muro, y xquixquiyaꞌ pa sufrimiento, ruma xtiquimol-quiꞌ chivij y pa nicꞌaj xquixcꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xtiquikasaj pan ulief ri itanamit y xquixquimisas ixreꞌ. Y chupan ri itanamit man jun jay xtipiꞌieꞌ can. Can quinojiel xcaꞌvulex ruma man xiyaꞌ ta pa cuenta chi ri Dios xalka iviqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Antok ri Jesús xbꞌaka Jerusalén, xuoc-oc pa templo y xaꞌrutarariej-el quinojiel ri ncaꞌcꞌayin y ri ncaꞌlakꞌo chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xuꞌej chica: Chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can nuꞌej: Ri vachuoch, jay richin oración; pero ixreꞌ xa ibꞌanun cachuoch alakꞌomaꞌ cha, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y ri Jesús kꞌij-kꞌij ncaꞌrutijuoj ri vinak riqꞌuin ri ruchꞌabꞌal ri Dios pa templo. Pero ri principales sacerdotes y ri achiꞌaꞌ escribas y ri achiꞌaꞌ principales chupan ri tanamet, niquicanuj manera chi chica niquiꞌan chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y man niquil ta chica manera niquiꞌan, ruma ri vinak jaꞌal nicaꞌxaj ri nuꞌej ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jun kꞌij, antok ri Jesús cꞌo pa templo nucꞌut y nutzijuoj ri evangelio chica ri vinak, jareꞌ antok xaꞌlka riqꞌuin ri principales sacerdotes, ri achiꞌaꞌ escribas y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y ri achiꞌaꞌ reꞌ xquiꞌej cha ri Jesús: Taꞌej chika: ¿Chica autoridad cꞌo pan akꞌaꞌ chi naꞌan nojiel reꞌ? ¿O chica xyoꞌn autoridad chava? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ cꞌo jeꞌ jun kax ri nivajoꞌ nicꞌutuj chiva. Tiꞌej cꞌa chuva: ");
INSERT INTO cakSNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ri Juan xtak-pa ruma ri Dios chi xaꞌruꞌon bautizar ri vinak o xa achiꞌaꞌ xaꞌeꞌn cha? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Entonces ri principales sacerdotes, ri achiꞌaꞌ escribas y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, xquiꞌej-ka chiquivach: Xa nakaꞌej chi ri Juan ja ri Dios ri takayuon-pa richin, ri Jesús xtuꞌej chika: ¿Karruma man xinimaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y xa nakaꞌej chi ja ri achiꞌaꞌ xaꞌeꞌn cha ri Juan chi tubꞌanaꞌ quireꞌ, xcaꞌpa quinojiel ri vinak y xkojquiquimisaj cha abꞌaj, ruma ri vinak cataꞌn chi ri Juan jun profeta, xaꞌcha-ka chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y cꞌajareꞌ xquiꞌej-apa cha ri Jesús chi man cataꞌn ta ri chica xꞌeꞌn cha ri Juan chi xaꞌruꞌon bautizar ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xuꞌej chica: Inreꞌ jeꞌ man xtinꞌej ta chiva chica autoridad cꞌo pa nukꞌaꞌ chi ncaꞌnꞌan quireꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y ri Jesús xutzꞌom cꞌa rutzijoxic chiquivach ri vinak jun parábola (cꞌambꞌal-tzij) y xuꞌej: Cꞌo cꞌa jun ache ri xutic uva pa rulief, xuyaꞌ can pa kajic chica nicꞌaj aj-samajiel, y jajaꞌ xꞌa qꞌuiy tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y antok xalka ri tiempo richin ri cosecha, ri rajaf ri ulief xutak-pa jun rusamajiel quiqꞌuin ri i-kajayuon ri rulief, richin chi niquiya-el ri uva kajbꞌal richin ri ulief. Pero ri achiꞌaꞌ ri i-kajayuon ri rulief xa xquichꞌey, y man jun uva xquiya-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ri rajaf ri ulief xutak chic pa jun rusamajiel. Pero xa xquitzꞌom jeꞌ ri samajiel reꞌ y xquichꞌey. Y chica-na ri xcajoꞌ xquiꞌan-el cha, y man jun jeꞌ uva xquiya-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ri rajaf ri ulief xutak chic pa jun ruox rusamajiel, pero ri achiꞌaꞌ ri i-kajayuon ri ulief, quireꞌ jeꞌ xquiꞌan cha. Xquisoc-el, y después xquitarariej-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Entonces ri rajaf ri ulief xuꞌej-ka: ¿Chica xtinꞌan vacame? Nitak-el ri nucꞌajuol ri altíra nivajoꞌ. Talvez antok xtiquitzꞌat chi ja ri nucꞌajuol ri xtiꞌka, xtiquiꞌan respetar. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ri achiꞌaꞌ reꞌ, antok xquitzꞌat chi ja ri rucꞌajuol ri rajaf ri ulief ri xalka, xquiꞌej-ka chiquivach: Jareꞌ ri xtuoc can rajaf nojiel ri ulief ri kakajuon, quixam-pa, kaquimisaj, chi quireꞌ pa kakꞌaꞌ ojreꞌ nicꞌujieꞌ can ri ulief, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y juviera ri ulief ri ticuon uva choch, xbꞌaquicꞌakaꞌ y xquiquimisaj. ¿Chica came xtuꞌon ri rajaf ri ulief ri ticuon uva choch chica ri achiꞌaꞌ reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ri rajaf ri ulief xtipa y xcaꞌruquimisaj ri achiꞌaꞌ reꞌ, y ri rulief xtuyaꞌ chic pa kajic chica nicꞌaj chic, xchaꞌ ri Jesús. Antok ri vinak caxan chic nojiel reꞌ, xquiꞌej: ¡Man ta quireꞌ xtibꞌanataj kiqꞌuin ojreꞌ! xaꞌcha-ka. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y ri Jesús xaꞌrucaꞌyiej ri vinak, y xuꞌej: ¿Chica came nrajoꞌ nuꞌej chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can? Antok nuꞌej: Ri Abꞌaj ri man xka ta chiquivach ri achiꞌaꞌ ri i-bꞌanoy-jay, xa jareꞌ ri xyoꞌx ri lugar ri más nicꞌatzin chi quireꞌ ri jay man nitzak ta, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y chica-na vinak ri xtitzak choch la Abꞌaj la, can xtimulumuꞌ. Y chica-na vinak ri xtika la Abꞌaj la chirij, can xtuyitzꞌ cꞌa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y ri principales sacerdotes y ri achiꞌaꞌ escribas can ta xcajoꞌ xquitzꞌom yan el ri Jesús, ruma xbꞌaka pa quiveꞌ (xa xquiꞌan entender) chi xa chiquij ijejeꞌ xuꞌej ri parábola (cꞌambꞌal-tzij). Pero man xquiꞌan ta, ruma xquixiꞌij-quiꞌ chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Y ri achiꞌaꞌ reꞌ xaꞌquitak nicꞌaj chic achiꞌaꞌ ri can incheꞌl choj ri quicꞌaslien nikꞌalajin, pero xa man quireꞌ ta. Ijejeꞌ nicajoꞌ chi ri Jesús nitzak ta pa quikꞌaꞌ riqꞌuin ri tzij ri ncaꞌruꞌej, chi quireꞌ niquijach pa rukꞌaꞌ ri gobernador. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y ri achiꞌaꞌ reꞌ xquicꞌutuj cha ri Jesús: Maestro, ojreꞌ kataꞌn chi joꞌc ri ketzij ri natzijuoj. Man naxiꞌij ta aviꞌ choch jun vinak mesque altíra rukꞌij. Y nacꞌut ri ruchꞌabꞌal ri Dios y can ja-ve rubꞌixic naꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Taꞌej chika: ¿Otz nakatoj ri impuestos ri nuꞌej ri rey César, o xa man otz ta? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ri Jesús can rataꞌn ri niquiꞌan pensar chirij, rumareꞌ jajaꞌ xuꞌej chica: ¿Karruma nquiniꞌan tentar? ");
INSERT INTO cakSNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Ticꞌutu-pa ri moneda chinoch. ¿Choj palaj y choj bꞌeꞌ ri cꞌo choch? xchaꞌ chica. Y ijejeꞌ xquiꞌej cha: Richin ri rey César, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xuꞌej chica: Tiyaꞌ cꞌa cha ri César ri can richin ri César, y tiyaꞌ cha ri Dios ri can richin ri Dios, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y ri achiꞌaꞌ ri xaꞌcꞌutun cha ri Jesús man xaꞌtiquir ta chirij, ruma nojiel tzij pa ruchojmil xuꞌej chica chiquivach ri vinak. Y can vor chica xquinaꞌ antok xcaꞌxaj ri xuꞌej ri Jesús chica. Rumareꞌ man chic xaꞌchꞌoꞌ ta apa cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y icꞌo nicꞌaj achiꞌaꞌ saduceos xaꞌlka riqꞌuin ri Jesús. Ri achiꞌaꞌ reꞌ man niquinimaj ta chi ri quiminakiꞌ can xcaꞌcꞌastaj-pa, y rumareꞌ ijejeꞌ xquicꞌutuj cha ri Jesús: ");
INSERT INTO cakSNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Maestro, ri Moisés rutzꞌibꞌan can chika: Xa cꞌo jun ache nicon-el nuyaꞌ can ri raxjayil y xa man jun ralcꞌual nicꞌujieꞌ can, jun ruchakꞌ o runimal ticꞌulieꞌ riqꞌuin ri raxjayil, richin quireꞌ ncaꞌcꞌujieꞌ ralcꞌual ri quiminak chic el. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y ijejeꞌ xquiꞌej cꞌa: Xaꞌcꞌujieꞌ i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ. Ri naꞌay xcꞌulieꞌ, pero xcon-el y man jun ralcꞌual xcꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Y ri rucaꞌn, xcꞌulieꞌ riqꞌuin ri malcaꞌn-ixok. Pero xcon-el jeꞌ y man jun ralcꞌual xcꞌujieꞌ can. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri ruox xcꞌulieꞌ jeꞌ riqꞌuin ri malcaꞌn-ixok y xcon jeꞌ. Quireꞌ xquiꞌan-el ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ. Y man jun chiquivach ri i-siete (ivukuꞌ) reꞌ xcꞌujieꞌ ta can ralcꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruqꞌuisbꞌal xcon jeꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y ri achiꞌaꞌ saduceos xquicꞌutuj cha ri Jesús: Antok xtalka ri kꞌij chi xcaꞌcꞌastaj-pa ri quiminakiꞌ, ¿choj axjayil xtuoc ri ixok reꞌ? Ruma ri i-siete (ivukuꞌ) ri quichakꞌ-quinimal-quiꞌ xuoc caxjayil, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Entonces ri Jesús xuꞌej chica: Vaveꞌ choch-ulief, ri vinak ncaꞌcꞌulieꞌ y ncaꞌyoꞌx chi ncaꞌcꞌulieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero ri i-quiminak-el ri yoꞌn lugar chica richin ncaꞌa chicaj, y chi ncaꞌcꞌastaj-pa chiquicajol ri quiminakiꞌ, man xcaꞌcꞌulieꞌ ta chic, ni man xcaꞌyoꞌx ta chi xcaꞌcꞌulieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ijejeꞌ man chic ncaꞌcon ta, ruma i-junan quiqꞌuin ri ángeles y can i-ralcꞌual ri Dios ruma i-cꞌastajnak-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Pero riqꞌuin ri quiminakiꞌ ri xcaꞌcꞌastaj-pa, hasta ri Moisés xucꞌut can chupan ri ruchꞌabꞌal ri Dios, antok jajaꞌ xutzꞌat ri jun kꞌayis cꞌo ruqꞌuixal ri rubꞌinan zarza ri nicꞌat, y xraꞌxaj antok ri Dios xuꞌej: Inreꞌ in Ru-Dios ri Abraham, in Ru-Dios ri Isaac y in Ru-Dios ri Jacob, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ruma ri Dios man Qui-Dios ta quiminakiꞌ, xa Qui-Dios ri icꞌas. Mareꞌ choch ri Dios ijejeꞌ can icꞌas. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y icꞌo chiquivach ri achiꞌaꞌ escribas xquiꞌej cha ri Jesús: Maestro, can ketzij ri xaꞌej, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y man jun chic xutzꞌom rucovil chi xucꞌutuj más cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y ri Jesús xuꞌej chica: ¿Karruma niꞌeꞌx chi ri Cristo xa choj jun rumáma can ri rey David? ");
INSERT INTO cakSNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Xa ja mismo ri rey David bꞌiyuon can chupan ri libro ri niꞌeꞌx Salmos cha: Ri Ajaf Dios xuꞌej cha ri Vajaf: Catzꞌuyeꞌ pa nu-derecha, ");
INSERT INTO cakSNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta cꞌa xcaꞌnyaꞌ ri av-enemigos chuxieꞌ avakan. Quireꞌ xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y xa ri rey David xuꞌej Vajaf cha ri Cristo, ¿karruma niꞌeꞌx chi ri Cristo xa choj jun rumáma can ri rey David? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y quinojiel ri vinak ri quimaluon-quiꞌ chireꞌ nicaꞌxaj-apa ri Jesús; y jajaꞌ xuꞌej chica ri ru-discípulos: ");
INSERT INTO cakSNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tibꞌanaꞌ cuenta-iviꞌ, man tiꞌan incheꞌl niquiꞌan ri achiꞌaꞌ escribas. Ruma ijejeꞌ can altíra nika chiquivach niquicusaj jucujak tak tziak, chi quireꞌ ncaꞌtzꞌiet chi utzulaj tak achiꞌaꞌ. Y can altíra nika chiquivach chi ncaꞌan saludar ri pacheꞌ niquimol-ve-quiꞌ qꞌuiy vinak. Y can ja ri naꞌay tak chꞌacat nicajoꞌ pa tak sinagogas y pa tak vaꞌen. ");
INSERT INTO cakSNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ri achiꞌaꞌ reꞌ niquimaj nojiel kax quichin ri malcaꞌn-ixokiꞌ, y chi caꞌnimax chi jaꞌal quicꞌaslien, can ncaꞌlayuj niquiꞌan orar. Pero ijejeꞌ can xtika más ri castigo pa quiveꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri Jesús xutzꞌat chi ri bꞌayomaꞌ niquiyaꞌ can miera pacheꞌ niyoꞌx-ve can ri ofrenda. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y quireꞌ jeꞌ xutzꞌat jun malcaꞌn-ixok ri altíra puobra, xuyaꞌ can caꞌyeꞌ fichas ri man qꞌuiy ta oc rakalien. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y mareꞌ xuꞌej chica ri ru-discípulos: Can ketzij ri niꞌej chiva chi ja ri malcaꞌn-ixok puobra la ri xyoꞌn can más que chiquivach quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ruma jajaꞌ mesque man qꞌuiy ta ru-miera cꞌo, xuyaꞌ can nojiel ri cꞌo riqꞌuin cha ri Dios. Pero ri bꞌayomaꞌ, mesque qꞌuiy miera xquiyaꞌ can, xa ja ri nuꞌon suobra quiqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y icꞌo ri quitzꞌamuon tzij chirij ri templo. Y niquiꞌej chi altíra jaꞌal rubꞌanic bꞌanun cha y jaꞌal tak abꞌaj ri i-cusan, y nojiel ri choj cha bꞌanun adornar, nojiel reꞌ ja ri vinak i-sipayuon, ncaꞌchaꞌ. Y ri Jesús xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xtalka jun kꞌij antok nojiel ri ntitzꞌat vaveꞌ xcaꞌvulex. Quinojiel ri nimaꞌk tak abꞌaj ri i-cusan, can xcaꞌvulex, y man jun abꞌaj ri xticꞌujieꞌ can pa ru-lugar, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ri discípulos xquicꞌutuj cha ri Jesús: Maestro, ¿jampeꞌ cꞌa xtibꞌanataj ri xaꞌej? ¿Y chica señal xtibꞌanataj chi ya nuꞌon nojiel reꞌ? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y ri Jesús xuꞌej chica: Tibꞌanaꞌ cuenta-iviꞌ chi man jun tibꞌano maña chiva. Ruma iqꞌuiy ri xcaꞌpa y xtiquiꞌej: Inreꞌ ri Cristo. Ri tiempo xa cierca chic cꞌo-ve, xcaꞌchaꞌ. Pero ixreꞌ man quixꞌa chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y antok xtivaxaj chi nibꞌanataj guerras o ri vinak pa tak tanamet ncaꞌpalaj-pa chiquij ri autoridades, man tixiꞌij-iviꞌ, ruma nicꞌatzin chi nojiel reꞌ nibꞌanataj naꞌay, pero man ja ta yan reꞌ chi niqꞌuis ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y ri Jesús xuꞌej jeꞌ: Jun nación xtipalaj chirij jun chic nación y jun reino xtipalaj chirij jun chic reino. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xtuꞌon nimaꞌk tak cubꞌrakan chica-na lugar, xtuꞌon viꞌjal y xcaꞌpa yabꞌil. Chila chicaj xcaꞌbꞌanataj kax ri xtiquiyaꞌ altíra xibꞌinreꞌl y xcaꞌtzꞌatataj nimaꞌk tak señales chila chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero antok majaꞌ caꞌbꞌanataj nojiel reꞌ, ixreꞌ xquixtzꞌam y xtiꞌan chiva chi ntiꞌan sufrir. Xquixjach pa quikꞌaꞌ ri achiꞌaꞌ i-principales pa tak sinagogas. Xquixtzꞌapes pa cárcel. Xquixucꞌuax chiquivach reyes y chiquivach gobernadores. Nojiel reꞌ xtikꞌasaj ruma iyoꞌn ivánima viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y antok quireꞌ xtiꞌan chiva, ixreꞌ tibꞌanaꞌ aprovechar chi xquinitzijuoj chiquivach ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y can ticꞌujieꞌ pa tak ivánima chi man nicꞌatzin ta chi ntiꞌan pensar más ri chica tzij nticusaj chi ntiꞌan defender-iviꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ruma inreꞌ ri xquiyoꞌn-pa ri tzij chiva. Y xtinyaꞌ jeꞌ inoꞌj chi quireꞌ, riqꞌuin ri noꞌj reꞌ, xtitzꞌapij quichiꞌ ri itziel ncaꞌtzꞌato ivichin. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y hasta ri itie-itataꞌ, ri ichakꞌ o inimal, ri ivachꞌalal o ri iv-amigos ri xcaꞌjacho ivichin y icꞌo chivach ixreꞌ ri xcaꞌquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Can quinojiel vinak, itziel xquixquitzꞌat ruma iyoꞌn ivánima viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man jun iveꞌ xtitzak-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Riqꞌuin ri i-paciencia xtivil ri utzulaj cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y antok xtitzꞌat chi ri tanamet Jerusalén quicholojin-quiꞌ soldados chirij, tivatamaj cꞌa chi xa jubꞌaꞌ chic tiempo nrajoꞌ chi niꞌan destruir. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Entonces ri icꞌo Judea, caꞌnumaj-el pa tak juyuꞌ. Ri icꞌo pa tanamet Jerusalén, caꞌiel-pa chupan. Y ri icꞌo pa tak juyuꞌ, man chic cꞌa caꞌuoc-oc chupan ri Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ruma ja kꞌij reꞌ ri xtiyoꞌx rucꞌaxiel nojiel ri i-rubꞌanun ri tanamet reꞌ, chi quireꞌ nuꞌon cumplir cꞌa nojiel ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Can juyeꞌ quivach ri ixokiꞌ ri icꞌo encinta (embarazada) antok xtalka ri kꞌij reꞌ, y quireꞌ jeꞌ ri ixokiꞌ ri cꞌa niquiyaꞌ quitzꞌun ri quixuluꞌ! Ruma xtipa jun gran sufrimiento paroꞌ ri roch-ulief y xtika cꞌa ri rayoval ri Dios paroꞌ ri tanamet reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Iqꞌuiy cꞌa xcaꞌcon cha espada pa quikꞌaꞌ ri soldados. Y nicꞌaj chic vinak xcaꞌcꞌuax nicꞌaj chic naciones cuma ri soldados. Y ri tanamet Jerusalén xtixakꞌ can cuma vinak ri man israelitas ta, hasta cꞌa xtitzꞌakat-na ri tiempo ri yoꞌn chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y qꞌuiy cꞌa señales xcaꞌbꞌanataj riqꞌuin ri kꞌij, ri icꞌ y ri estrellas (chꞌumil). Y ri vinak ri icꞌo choch-ulief man xtiquil ta chica xtiquiꞌan, xa xtisach quinoꞌj ruma ri mar más xtikꞌajan, y más xtibꞌalkoꞌt riqꞌuin ruchukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y ri vinak, ruma niquiꞌan imaginar ri xtibꞌanataj ri choch-ulief, xtiquiꞌan desmayar-quiꞌ ruma xibꞌinreꞌl. Can nojiel cꞌa ri icꞌo chicaj xcaꞌsilos. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Entonces ri vinak xtiquitzꞌat ri Xtak-pa chicaj chi xalax chiꞌicajol, chi xtika-pa chupan jun mukul riqꞌuin namalaj poder y namalaj rukꞌij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y antok xtitzꞌat chi nojiel reꞌ ncaꞌbꞌanataj, quixquicuot y ticꞌujieꞌ más ruchukꞌaꞌ ri ivánima, ruma ya nalka ri kꞌij chi nquixcolotaj-el choch ri ulief, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jareꞌ antok jajaꞌ xuꞌej jeꞌ jun parábola (cꞌambꞌal-tzij) chica: Titzꞌataꞌ ri víquix y nojiel ri chieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Antok ya ncaꞌiel-pa quixak, ivataꞌn chi ri ru-tiempo ri sakꞌij ya nalka. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y quireꞌ jeꞌ antok xtitzꞌat chi ncaꞌbꞌanataj ri kax ri xinꞌej, tivatamaj cꞌa chi cierca chic cꞌo-ve ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Can ketzij niꞌej chiva, chi nojiel reꞌ xtibꞌanataj antok ri vinak richin ri tiempo vacame cꞌa icꞌo ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ri roch-ulief y ri rocaj can xcaꞌqꞌuis. Pero ri nuchꞌabꞌal man xtiqꞌuis ta quireꞌ, xa can xtibꞌanataj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tibꞌanaꞌ cuenta-iviꞌ. Man tiꞌa ivánima chirij ri vaꞌen, man quixkꞌabꞌar, y man joꞌc ta oc ri nicꞌatzin chiva ri choch-ulief ri ntiꞌan pensar, y antok xtinaꞌ, xa ja xalka ri kꞌij chi inreꞌ nquinalka. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Xa xtalka incheꞌl nuꞌon jun trampa. Quireꞌ xtuꞌon antok xtalka pa quiveꞌ quinojiel ri vinak ri icꞌo choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Rumareꞌ tibꞌanaꞌ cuenta-iviꞌ y siempre tibꞌanaꞌ orar, chi nquixcolotaj choch nojiel ri sufrimiento ri xtipa paroꞌ ri roch-ulief, y chi quireꞌ otz ri icꞌaslien nquixalka choch ri Xtak-pa chicaj chi xalax chiꞌicajol, xchaꞌ ri Jesús chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Y ri pakꞌij ri Jesús nicꞌujieꞌ pa templo, ncaꞌrutijuoj ri vinak riqꞌuin ri ruchꞌabꞌal ri Dios. Y chakꞌaꞌ niꞌa choch ri juyuꞌ rubꞌinan Olivos, y chireꞌ nicꞌujie-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y iqꞌuiy vinak ri ncaꞌlka macꞌajan yan ri pa templo chi nicaꞌxaj ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Y xa cierca chic ri kꞌij richin ri namakꞌej Pascua, antok nicꞌux ri simíta ri manak levadura riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y ri principales sacerdotes y ri achiꞌaꞌ escribas niquicanuj ri chica manera niquiꞌan chi niquiquimisaj ri Jesús. Pero xa niquixiꞌij-quiꞌ chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y ri Judas, jun chiquivach ri i-doce (cabꞌalajuj) ru-discípulos ri Jesús, ri xꞌeꞌx jeꞌ Iscariote cha, xuoc ri Satanás pa ránima. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Rumareꞌ xꞌa quiqꞌuin ri principales sacerdotes y quiqꞌuin jeꞌ ri qui-jefes ri ncaꞌchajin ri templo, y xuꞌej chica cheꞌl xtuꞌon chi nujach ri Jesús pa quikꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y ijejeꞌ xaꞌquicuot antok xcaꞌxaj reꞌ, y xquisuj miera cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Y jajaꞌ xuꞌon ri trato y ja nucanuj chica manera nuꞌon chi nujach ri Jesús antok man quimaluon ta quiꞌ vinak riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xalka ri kꞌij richin nicꞌux ri simíta ri manak levadura riqꞌuin, y antok nicꞌatzin jeꞌ chi ncaꞌquimisas ri alaj tak ovejas richin ri Pascua. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ri Jesús xaꞌrutak-el ri Pedro y ri Juan, y xuꞌej-el chica: Quixꞌin, tichojmij ri xtakacꞌux chupan ri Pascua. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y ri icaꞌyeꞌ discípulos xquicꞌutuj cha: ¿Pacheꞌ navajo-ve chi nakachojmij? ");
INSERT INTO cakSNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xuꞌej chica: Antok xquixuoc pa tanamet Jerusalén, chireꞌ xticꞌul jun ache rucꞌuan yaꞌ chupan jun cántaro. Quixꞌin chirij hasta ri jay pacheꞌ xtuoc-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y tiꞌej cha ri tataꞌj chupan ri jay reꞌ: Ri Maestro ruꞌeꞌn-pa: ¿Pacheꞌ cꞌo-ve ri cuarto ri pacheꞌ niꞌan-ve ri vaꞌen richin ri Pascua quiqꞌuin ri nu-discípulos? quixchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y ri tataꞌj reꞌ xquixrucꞌuaj rucaꞌn piso ri rachuoch. Y chireꞌ cꞌo jun cuarto nem rupan ri chojmin chic ri rupan; chireꞌ tibꞌana-ve ri chica xtakacꞌux richin ri Pascua, xcha-el chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y ri discípulos reꞌ xaꞌa. Y incheꞌl ri ruꞌeꞌn-el ri Jesús chica, can quireꞌ xbꞌanataj. Y ijejeꞌ can xquichojmij nojiel ri nicꞌatzin chica richin ri Pascua reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y antok xalka ri huora, ri Jesús y ri doce (cabꞌalajuj) apóstoles xaꞌtzꞌuye-apa chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xuꞌej chica: ¡Altíra nurayin-pa chi antes chi nquicon, nquivaꞌ iviqꞌuin chupan va jun Pascua va! ");
INSERT INTO cakSNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ruma niꞌej chiva chi man chic xquivaꞌ ta chupan jun chic Pascua, hasta cꞌa nuꞌon cumplir chupan ri ru-reino ri Dios, cꞌajareꞌ xtinꞌan chic. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y ri Jesús xucꞌan-apa ri copa, xuyaꞌ tiox bꞌaꞌ cha ri Dios y xuꞌej: Titzꞌamaꞌ y tikumuꞌ ixvonojiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Can niꞌej chiva chi man chic xtinkun ta ri ruyaꞌl ri uva, hasta cꞌa ri ru-reino ri Dios xtipa. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y xucꞌan-apa jun simíta y xuyaꞌ tiox bꞌaꞌ cha ri Dios, y xuper y xuyaꞌ chica ri ru-discípulos y xuꞌej chica: Va, jareꞌ ri nu-cuerpo ri xtijach pan i-cuenta ixreꞌ. Can tibꞌanaꞌ cava siempre richin nquininataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y antok ya i-viꞌnak chic, ri Jesús xucꞌan-apa ri copa, y xuꞌej: Jareꞌ ri nuquiqꞌuiel ri xtiꞌin antok xquiquimisas. Riqꞌuin ri nuquiqꞌuiel, ja xticꞌachoj ri cꞌacꞌacꞌ pacto ri rajoꞌn-pa ri Dios chi nuꞌon quiqꞌuin ri vinak, chi quireꞌ ixreꞌ nquixcolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y ri ache ri xtijacho vichin cꞌo-pa viqꞌuin chirij ri mesa. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can ketzij chi ri Xtak-pa chicaj chi xalax chiꞌicajol can niꞌa, ruma jareꞌ ri ranun-pa pensar ri Dios chi nibꞌanataj. ¡Pero juyeꞌ roch ri ache ri xtijacho richin! xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Entonces ri ru-discípulos ri Jesús ja xquibꞌila-ka chiquivach chi chica chiquivach xtaꞌno reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y ri discípulos xaꞌyovar-ka chiquivach ijejeꞌ chi chica ri xtuoc más nem. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero ri Jesús xuꞌej chica: Ri reyes quichin ri naciones, ruma icꞌo ri vinak pa quikꞌaꞌ, rumareꞌ niquinaꞌ chi ijejeꞌ ri i-cajaf. Y ri achiꞌaꞌ ri cꞌo qui-autoridad pa quiveꞌ ri vinak, can utzulaj tak achiꞌaꞌ niꞌeꞌx chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero chiꞌicajol ixreꞌ man quireꞌ ta. Ruma ri más nem chiꞌicajol, can tubꞌanaꞌ más chꞌuteꞌn. Y ri jun chivach ri nicꞌujieꞌ pan iveꞌ ixreꞌ, tubꞌanaꞌ incheꞌl nuꞌon ri nibꞌano servir. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ruma, ¿chica ri más nem, ja came ri cꞌo chirij ri mesa, o ja ri nibꞌano servir? ¿Man ja ta came ri cꞌo chirij ri mesa? Pero inreꞌ incꞌo chiꞌicajol incheꞌl ri nibꞌano servir. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ixreꞌ ixcꞌo viqꞌuin chupan nojiel ri sufrimientos ri nukꞌasan. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Rumareꞌ, inreꞌ xtinyaꞌ jun reino pan ikꞌaꞌ incheꞌl ri rubꞌanun ri Nataꞌ Dios chuva inreꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","richin quireꞌ xquixvaꞌ y xtikun iyaꞌ viqꞌuin choch ri nu-mesa chupan ri nu-reino. Y ixreꞌ xquixtzꞌuyeꞌ chupan tronos chi ntiꞌan juzgar ri doce (cabꞌalajuj) tribus richin ri Israel. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y ri Ajaf Jesús xuꞌej jeꞌ cha jun chiquivach ri ru-discípulos: Simón, Simón, niꞌej chava chi ri Satanás ya xixrucꞌutuj richin xquixruꞌon tentar. Nrajoꞌ nquixrusiluoj incheꞌl niꞌan cha ri trigo. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero inreꞌ ya xinꞌan orar pan a-cuenta, chi quireꞌ atreꞌ xtacukubꞌaꞌ acꞌuꞌx viqꞌuin siempre. Can xcaka pa rukꞌaꞌ ri Satanás. Pero antok ya at-kꞌaxnak chic chupan reꞌ, xcaꞌtoꞌ ri nicꞌaj chic nu-discípulos chi quireꞌ xtiquicukubꞌaꞌ quicꞌuꞌx viqꞌuin siempre, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xuꞌej cha: Ajaf, xa atreꞌ xcatucꞌuax pa cárcel, inreꞌ jeꞌ nquiꞌa aviqꞌuin. Y xa xcaquimisas, inreꞌ jeꞌ nquicon aviqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Y ri Jesús xuꞌej cha: Pedro, inreꞌ niꞌej chava chi chupan va akꞌaꞌ va, majaꞌ titzirin-pa ri mamaꞌ, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch, xchaꞌ ri Jesús cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y ri Jesús xucꞌutuj chica ri ru-discípulos: Antok xixtak-el y man xinvajoꞌ ta chi xivucꞌuaj i-buolsa, ni i-miera, ni jun chic par ixajabꞌ, ¿cꞌo xuꞌon falta chivach? xchaꞌ chica. Y ijejeꞌ xquiꞌej: Man jun. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y ri Jesús xuꞌej chica: Pero vacame ri cꞌo ru-buolsa, tucꞌuaj. Ri cꞌo ru-miera, tucꞌuaj jeꞌ. Y ri manak ru-espada, tucꞌayij ri ru-capa ri nukꞌuꞌj y tulakꞌoꞌ jun. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Quireꞌ niꞌej chiva, ruma chi nuꞌon cumplir ri nuꞌej chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. Chireꞌ nuꞌej: Incheꞌl jun aj-bꞌanoy-chꞌoꞌj xꞌan cha. Quireꞌ ri tzꞌibꞌan can. Y xtuꞌon cumplir nojiel ri tzꞌibꞌan can chuvij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y ri discípulos xquiꞌej cha ri Jesús: Ajaf, vaveꞌ cꞌo caꞌyeꞌ espadas. Y ri Jesús xuꞌej chica: Xa riqꞌuin reꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Antok ri Jesús xiel-el chireꞌ, xꞌa cꞌa ri pacheꞌ can tiꞌa-ve siempre, choch ri juyuꞌ Olivos. Y ri ru-discípulos i-bꞌanak chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y antok xbꞌaka chupan ri lugar reꞌ, xuꞌej chica: Tibꞌanaꞌ orar richin chi man quixtzak chupan ri tentación. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y ri Jesús xꞌin chic apa jubꞌaꞌ chiquivach, y xxuquie-ka chi nuꞌon orar. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nuꞌej chupan ri ru-oración: Nataꞌ, xa atreꞌ navajoꞌ, chi man ta nikꞌasaj ri sufrimiento; pero man taꞌan ri nivajoꞌ inreꞌ, xa ja ri navajoꞌ atreꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y jun ángel ri patanak chicaj xucꞌut-riꞌ choch, chi xalruya-ka ruchukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y altíra nikꞌaxo ránima ri Jesús. Rumareꞌ riqꞌuin nojiel ránima nuꞌon orar. Y ri yaꞌ ri ntiel chirij incheꞌl nimaꞌk tak gotas quicꞌ ri ncaꞌka pan ulief. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Antok ri Jesús xpalaj-pa pacheꞌ xucul-ve nuꞌon orar, xpa cꞌa quiqꞌuin ri ru-discípulos, y xaꞌlrilaꞌ xa ncaꞌvar, ruma ncaꞌbꞌisuon. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y ri Jesús xuꞌej chica ri ru-discípulos: ¿Karruma nquixvar? Quixpalaj y tibꞌanaꞌ orar richin chi man quixtzak chupan ri tentación. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y cꞌa nitzijuon ri Jesús, antok xaꞌlka iqꞌuiy vinak riqꞌuin. Y ri jun chiquivach ri doce (cabꞌalajuj) discípulos ri rubꞌinan Judas, jareꞌ ri kꞌaxnak-pa chiquivach ri vinak reꞌ. Y ri Judas xjiel-apa riqꞌuin ri Jesús chi xutzꞌubꞌaj ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Entonces ri Jesús xuꞌej cha: Judas, ¿xatzꞌubꞌaj ri Xtak-pa chicaj chi xalax chiꞌicajol, chi najach pa quikꞌaꞌ ri itziel ncaꞌtzꞌato richin? xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y antok ri discípulos xuyaꞌ cuenta chiquivach ri chica ri xtibꞌanataj, xquiꞌej cha: Ajaf, ¿nkojoyovar quiqꞌuin cha espada? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y jun chiquivach ri discípulos xusoc ri ru-esclavo ri sacerdote ri más cꞌo rukꞌij, y xralasaj-el ri ruxiquin derecha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y ri Jesús xuꞌej chica ri ru-discípulos: Man jun chic chica tiꞌan. Caꞌcꞌujieꞌ chireꞌ. Y xpa jajaꞌ xutzꞌom ri ruxiquin y xuꞌon sanar. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y ri Jesús xuꞌej chica ri principales sacerdotes, ri qui-jefes ri ncaꞌchajin ri templo, y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, ri i-patanak tzꞌamoy-richin: ¿Ixreꞌ ix-patanak incheꞌl chirij jun alakꞌuon; mareꞌ icꞌamun-pa chieꞌ y espadas? ");
INSERT INTO cakSNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Can kꞌij-kꞌij xicꞌujieꞌ iviqꞌuin pa templo y man jun kax xiꞌan chuva. Pero ja huora va ri yoꞌn chiva ixreꞌ, chi ja ri kꞌakuꞌn ri nichꞌacuon, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquitzꞌom-el y xquicꞌuaj cꞌa chirachuoch ri sacerdote ri más cꞌo rukꞌij. Y ri Pedro bꞌanak chirij, pero cꞌa naj cꞌo can. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y chireꞌ pa nicꞌaj ri chojay, xquibꞌox kꞌakꞌ y xaꞌtzꞌuyeꞌ chirij. Y ri Pedro jeꞌ xtzꞌuye-apa chiquicajol. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y jun xtan aj-chi-icꞌ richin ri sacerdote ri más cꞌo rukꞌij, antok xutzꞌat ri Pedro tzꞌuyul chireꞌ rumakꞌuon-riꞌ, xutzꞌat otz y xuꞌej: Va ache va rachꞌil jeꞌ ri Jesús, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ri Pedro man xuꞌej ta ri ketzij, ruma xuꞌej: Xtan, inreꞌ man vataꞌn ta roch, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y cꞌa jubꞌaꞌ oc tiempo takꞌax, antok cꞌo chic jun ri xtzꞌato chic pa ri Pedro, y xuꞌej cha: Atreꞌ at jun chiquivach ri icꞌo riqꞌuin ri Jesús, xchaꞌ cha. Y ri Pedro xuꞌej: Ache, man inreꞌ ta, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jun laꞌk huora takꞌax, cꞌo chic jun ri xꞌeꞌn chirij ri Pedro: Ri ache va, ketzij chi rachꞌil jeꞌ ri Jesús, ruma aj-Galilea, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Y ri Pedro xuꞌej cha: Ache, man vataꞌn ta chica ri naꞌej. Y cꞌa nichꞌoꞌ ri Pedro antok ri mamaꞌ xtzirin-pa. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y ri Ajaf Jesús xtzuꞌn can chirij y xutzꞌat-pa ri Pedro. Y ri Pedro xalka paroꞌ ri tzij ri ruꞌeꞌn ri Ajaf cha: Antes cꞌa majaꞌ titzirin-pa ri mamaꞌ, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y ri Pedro xiel-el juviera y xuokꞌ amargamente. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ri achiꞌaꞌ ri i-chajiyuon richin ri Jesús ncaꞌtzeꞌn chirij y niquichꞌey jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y xquitzꞌapij nakꞌaroch y xquipaj rutzubꞌal y niquicꞌutuj cha: Taꞌej chika: ¿Chica ri xchꞌayo avichin? ncaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y qꞌuiy jeꞌ pakon tak tzij ri niquiꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Antok xsakar-pa, xquimol-quiꞌ ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar chiquicajol ri israelitas, ri principales sacerdotes, y ri achiꞌaꞌ escribas; ruma ijejeꞌ ri autoridades quichin ri israelitas. Ri Jesús xucꞌuax chiquivach ijejeꞌ, y xquicꞌutuj cha: ");
INSERT INTO cakSNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Taꞌej chika: ¿Atreꞌ ri Cristo? xaꞌchaꞌ. Pero ri Jesús xuꞌej chica: Xa ta niꞌej chiva chi inreꞌ, man ntinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Y quireꞌ jeꞌ, xa ta cꞌo ri nicꞌutuj-apa chiva, ixreꞌ man xtiꞌej ta pa chuva, y man xquinitzokopij ta el jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero desde vacame, ri Xtak-pa chicaj chi xalax chiꞌicajol, xtibꞌatzꞌuyeꞌ pa ru-derecha ri Dios ri nitiquir nuꞌon nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Y quinojiel xquicꞌutuj cha ri Jesús: ¿Atreꞌ ri Rucꞌajuol ri Dios? xaꞌchaꞌ. Y ri Jesús xuꞌej chica: Ixreꞌ nquixꞌeꞌn chi inreꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y ijejeꞌ xquiꞌej: Man chic nicꞌatzin ta chi nalka jun chic chi nalruꞌej chika chi man otz ta ri i-rubꞌanun. Ruma ojreꞌ mismo xkaxaj ri xuꞌej, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y entonces quinojiel ri icꞌo chireꞌ xaꞌpalaj, y xquicꞌuaj ri Jesús chi xbꞌaquijachaꞌ pa rukꞌaꞌ ri Pilato. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chireꞌ choch ri gobernador, niquiꞌan-apa acusar y niquiꞌej: Ojreꞌ xkil ri Jesús chi nuꞌej chica ri vinak chi man caꞌniman. Y nuꞌej chica ri vinak chi man tiquitoj ri impuestos cha ri César. Y nuꞌej jeꞌ chi jajaꞌ ri Cristo, y reꞌ nrajoꞌ nuꞌej chi jajaꞌ jun rey, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Entonces ri Pilato xucꞌutuj cha ri Jesús: ¿Atreꞌ ri Qui-Rey ri israelitas? Y ri Jesús xuꞌej cha: Atreꞌ ncaꞌeꞌn, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y ri Pilato xuꞌej chica ri principales sacerdotes y chica ri vinak: Inreꞌ man jun chꞌoꞌj nivil chirij va ache va, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero ijejeꞌ man ncaꞌtanieꞌ ta ka. Xa quireꞌ niquirak-apa quichiꞌ niquiꞌej-apa: Nuꞌej chica ri vinak ri icꞌo chupan nojiel tanamet richin ri Judea chi man caꞌniman. Cꞌa Galilea rutzꞌucun-pa rubꞌanic. Y vacame ja xalka vaveꞌ pa tanamet Jerusalén, xaꞌcha-apa. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y antok ri Pilato xraꞌxaj chi niquiꞌej Galilea, xucꞌutuj xa aj-Galilea ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y antok xꞌeꞌx cha chi aj-Galilea, jajaꞌ xutak-el ri Jesús riqꞌuin ri Herodes ri gobernador richin Galilea, ruma ri Herodes cꞌo chireꞌ pa tanamet Jerusalén ri kꞌij reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y antok ri Herodes xutzꞌat ri Jesús, altíra xquicuot, ruma qꞌuiy yan kꞌij rurayin nutzꞌat. Y qꞌuiy ri raxan chirij. Rumareꞌ altíra nurayij nutzꞌat antok nuꞌon jun milagro. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y ri Herodes qꞌuiy kax nucꞌutuj cha ri Jesús, pero ri Jesús man jun tzij xuꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y icꞌo-apa ri principales sacerdotes y ri achiꞌaꞌ escribas, niquitej quikꞌij niquiꞌan-apa acusar ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Entonces ri Herodes y ri ru-soldados man jun rakalien xquiꞌan cha ri Jesús, xaꞌtzeꞌn chirij y xquiya-el jun tziak chirij, ri incheꞌl ncaꞌquicusaj ri reyes. Y después ri Herodes xutzoliej chic el ri Jesús cha ri Pilato. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes y ri Pilato quiyoval nak quiꞌ, pero ri kꞌij reꞌ xquiꞌan can amigos. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Entonces ri Pilato xaꞌrayuoj ri principales sacerdotes y ri autoridades quichin ri israelitas, y xaꞌrayuoj jeꞌ ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y xuꞌej chica: Ixreꞌ xalꞌiyaꞌ ri Jesús pa nukꞌaꞌ, y ntiꞌej chi nuꞌej chica ri vinak chi man caꞌniman. Pero chivach ixreꞌ xincꞌutuj cha, y inreꞌ man jun ruchꞌoꞌj xinvil chirij ri ntiꞌej ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y ri Herodes jeꞌ man jun kax xril chirij antok xixtak-el riqꞌuin, y rumareꞌ xutzoliej chic pa chuva. Riqꞌuin reꞌ nakatamaj chi jajaꞌ man jun kax rubꞌanun chi niquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Xtintak cꞌa ruchꞌayic y después nitzokopij-el, xchaꞌ ri Pilato. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Y ri gobernador cꞌo cꞌa chi nutzokopij-el jun chiquivach ri icꞌo pa cárcel, ruma quireꞌ niꞌan juna-junaꞌ chupan ri namakꞌej Pascua. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Pero quinojiel junan xaꞌchꞌo-apa riqꞌuin nojiel quichukꞌaꞌ, y xquiꞌej: ¡Ja ri Barrabás tatzokopij-el y ri Jesús tiquimisas! xaꞌcha-apa. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y ri Barrabás cꞌo pa cárcel ruma xpalaj chirij ri gobierno chireꞌ pa tanamet y ruma jeꞌ ruquimisan jun. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Y ri Pilato nrajoꞌ nutzokopij-el ri Jesús, rumareꞌ xchꞌoꞌ chic jun bꞌay chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ri vinak xaꞌchꞌo-apa chic riqꞌuin nojiel quichukꞌaꞌ, y xquiꞌej: ¡Tiꞌan crucificar! ¡Tiꞌan crucificar! ");
INSERT INTO cakSNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y ri Pilato chi oxeꞌ mul xucꞌutuj chica: ¿Chica ruchꞌoꞌj rubꞌanun va ache va? Inreꞌ man jun chꞌoꞌj nivil chirij chi quireꞌ niquimisas. Xtintak ruchꞌayic y después nitzokopij-el, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ri vinak y ri principales sacerdotes, can riqꞌuin nojiel quichukꞌaꞌ niquicꞌutuj-apa chi tiꞌan crucificar ri Jesús, y ja ri niquiꞌej-apa ijejeꞌ, jareꞌ ri xnimax. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Entonces ri Pilato xuꞌej chi tiꞌan incheꞌl niquicꞌutuj-apa ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xutzokopij-el ri ache ri xquicꞌutuj-apa ijejeꞌ cha. Ri ache reꞌ cꞌo pa cárcel ruma xpalaj chirij ri gobernador y ruma xuquimisaj jeꞌ jun. Pero ri Jesús xujach-el chi tiꞌan crucificar, ruma jareꞌ xcajoꞌ ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y antok ri soldados quicꞌuan-el ri Jesús, xquicꞌul jun ache aj-Cirene, ri Simón rubꞌeꞌ, ri patanak pan avan, y ri soldados xquitzꞌom y xquiya-el ri cruz chirij. Y jajaꞌ xucꞌuan-el y xꞌa chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y iqꞌuiy vinak ri i-bꞌanak chirij. Y iqꞌuiy jeꞌ ixokiꞌ altíra ncaꞌuokꞌ chirij ri Jesús, y altíra ncaꞌbꞌisuon chirij. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ri Jesús xtzuꞌn can chirij, y xuꞌej chica: Ixreꞌ ixokiꞌ aj-Jerusalén, man quixuokꞌ chuvij inreꞌ. Xa tivokꞌiej-ka-iviꞌ ixreꞌ, y quixuokꞌ chiquij ri ival. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ruma xcaꞌpa kꞌij richin altíra sufrimiento. Rumareꞌ xtiꞌeꞌx chi can jaꞌal caꞌquicuot ri ixokiꞌ ri manak cal xcꞌujieꞌ y ri man jun bꞌay xquiyoꞌiej ta jun acꞌual, y ri man jun bꞌay xquiyaꞌ ta rutzꞌun jun xuluꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Entonces ri vinak xtiquiꞌej chica ri juyuꞌ: Quixtzak-pa chikij. Y chica ri chꞌitak juyuꞌ xtiquiꞌej: Kojivavaj, xcaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ruma xa niꞌan chuva inreꞌ, ri in incheꞌl jun chieꞌ rax chi nikꞌasaj sufrimiento, ¿chica came xtiꞌan cha ri incheꞌl jun chieꞌ chakeꞌj? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y cꞌo jeꞌ icaꞌyeꞌ alakꞌomaꞌ ri i-ucꞌuan-el chi ncaꞌquimisas junan riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y antok xaꞌbꞌaka chupan ri lugar rubꞌinan Rujaluon Quiminak, xquibꞌajij ri Jesús choch cruz, y quireꞌ jeꞌ xquiꞌan chica ri icaꞌyeꞌ alakꞌomaꞌ. Jun xyoꞌx pa ru-derecha y ri jun chic pa ru-izquierda. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y ri Jesús xuꞌej: Nataꞌ Dios, caꞌbꞌanaꞌ perdonar, ruma man cataꞌn ta chica ri niquiꞌan, xchaꞌ. Y ri soldados xquilasaj suerte chirij ri rutziak chi niquijach chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ri Jesús nitzꞌiet-apa cuma iqꞌuiy vinak y cuma jeꞌ ri autoridades quichin ri israelitas. Y quinojiel ri vinak reꞌ ncaꞌtzeꞌn-apa chirij y niquiꞌej: Jajaꞌ can iqꞌuiy xaꞌrucol. Vacame tucalo-riꞌ, xa jajaꞌ ri Cristo ri choꞌn-pa ruma ri Dios, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y quireꞌ jeꞌ niquiꞌan ri soldados. Altíra ncaꞌtzeꞌn-apa chirij ri Jesús, y ncaꞌjiel-apa riqꞌuin y niquisuj vinagre cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y niquiꞌej cha: Xa atreꞌ ri Qui-Rey ri israelitas, tacalo-aviꞌ ayuon, ncaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y paroꞌ ri cruz cꞌo jun letrero tzꞌibꞌan-el pa chꞌabꞌal griego, latín y hebreo y nuꞌej: JAREꞌ RI QUI-REY RI ISRAELITAS. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun chiquivach ri icaꞌyeꞌ alakꞌomaꞌ ri icꞌo jeꞌ choch qui-cruz, can cꞌo tzij ri man otz ta ri ncaꞌruꞌej-apa y cava xuꞌej: Xa atreꞌ ri Cristo, tacalo-aviꞌ ayuon y kojacaloꞌ ojreꞌ jeꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ri jun chic xuchꞌolij ri xꞌeꞌn quireꞌ cha ri Jesús y xuꞌej-apa cha: ¿Man naxiꞌij ta aviꞌ atreꞌ choch ri Dios chupan ri castigo ri junan ojcꞌo riqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ojreꞌ otz chi quireꞌ bꞌanun chika, ruma riqꞌuin reꞌ nakatoj ri itziel ri i-kabꞌanun. Pero jajaꞌ man jun chꞌoꞌj rubꞌanun. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y ri alakꞌuon reꞌ xuꞌej-apa cha ri Jesús: Quinalka pan aveꞌ, antok xcapa chi naꞌan reinar, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xuꞌej cha: Can ketzij niꞌej chava, chi vacame mismo xcabꞌacꞌujieꞌ viqꞌuin chupan ri lugar ri niꞌeꞌx paraíso cha, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y antok pa nicꞌaj-kꞌij laꞌk, nojiel ri roch-ulief xuꞌon kꞌakuꞌn. Y ri kꞌakuꞌn reꞌ xqꞌuis-el hasta cꞌa a las tres ri nakakꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri kꞌij man xuyaꞌ ta rusakil, y ri tziak ri choj cha jachuon-ve rupan ri templo xkꞌachꞌitaj pa nicꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Entonces ri Jesús xurak ruchiꞌ y xuꞌej: Nataꞌ Dios, pan akꞌaꞌ cꞌa nijach ri nu-espíritu, xchaꞌ. Y joꞌc xuꞌej quireꞌ, ja xcon-ka. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Antok ri capitán xutzꞌat ri xbꞌanataj, xuyaꞌ rukꞌij ri Dios, y xuꞌej: Can ketzij chi la ache la man jun ruchꞌoꞌj, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y quinojiel ri vinak ri icꞌo-apa y xquitzꞌat ri xbꞌanataj, niquitin roch-quicꞌuꞌx xaꞌtzalaj chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y ri cataꞌn roch ri Jesús, y ri ixokiꞌ ri cꞌa Galilea i-patanak chirij, cꞌa naj icꞌo-ve niquitzꞌat-apa ri nibꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y cꞌo jun ache rubꞌinan José, jajaꞌ aj-Arimatea ri cꞌo Judea. Ri jun utzulaj y choj ache reꞌ, jun chiquivach ri achiꞌaꞌ ri autoridades quichin ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y ri José reꞌ royoꞌien ri ru-reino ri Dios, y rumareꞌ jajaꞌ man xka ta choch ri xquiꞌej y xquiꞌan ri rachꞌil cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y jajaꞌ xꞌa riqꞌuin ri Pilato chi xucꞌutuj ri ru-cuerpo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y antok rukasan chic pa ri ru-cuerpo ri Jesús choch ri cruz, xubꞌol cꞌa chupan jun tziak. Y chupan jun jul ri cꞌatuon choch jun nem abꞌaj xbꞌaruya-ve ri ru-cuerpo ri Jesús. Y man jun yoꞌn chupan. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Chupan ri kꞌij reꞌ, ri vinak niquichojmij yan nojiel ri xticꞌatzin chica, ruma ri kꞌij richin uxlanien ya nitzꞌucutaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y ri ixokiꞌ ri cꞌa Galilea i-patanak chirij ri Jesús, xaꞌa chirij antok xbꞌamuk; y xquitzꞌat ri jul ri pacheꞌ xyoꞌx-ve can, y xquitzꞌat cheꞌl xꞌan can cha ri ru-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y antok xaꞌtzalaj pa tanamet, xquiꞌan preparar jubꞌul akꞌuon richin chi niquiyaꞌ chirij ri ru-cuerpo ri Jesús. Y xaꞌuxlan chupan ri kꞌij richin uxlanien incheꞌl nuꞌej chupan ri ru-ley ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Y macꞌajan yan ri naꞌay kꞌij richin ri semana, xaꞌa chuchiꞌ ri jul, y quicꞌuan ri jubꞌul tak akꞌuon ri quibꞌanun. Y icꞌo jeꞌ nicꞌaj chic ixokiꞌ ri i-bꞌanak quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y antok xaꞌbꞌaka chuchiꞌ ri jul, xquitzꞌat chi ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, xa alasan-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Y xaꞌuoc-oc chupan ri jul, y manak xquitzꞌat ri ru-cuerpo ri Ajaf Jesús chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Rumareꞌ xsach quinoꞌj. Y jareꞌ antok xaꞌquitzꞌat icaꞌyeꞌ achiꞌaꞌ i-paꞌl-apa quiqꞌuin, y nichꞌichꞌan quitziak. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y ruma quixibꞌinreꞌl, ri ixokiꞌ xquilucubꞌa-ka ri quijaluon. Y ri achiꞌaꞌ xquiꞌej chica: ¿Karruma nticanuj chiquicajol quiminakiꞌ ri xa cꞌas? ");
INSERT INTO cakSNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jajaꞌ man cꞌo ta chic vaveꞌ, ya xcꞌastaj-el. Talka pan iveꞌ ri xuꞌej chiva antok jajaꞌ cꞌa cꞌo Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Jajaꞌ xuꞌej chiva: Ri Xtak-pa chicaj chi xalax chiꞌicajol, can nicꞌatzin chi nijach pa quikꞌaꞌ ri pecadores. Xtiquimisas choch cruz, y chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ, xaꞌchaꞌ ri icaꞌyeꞌ achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y ri ixokiꞌ xalka pa quiveꞌ ri tzij ri ruꞌeꞌn can ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y antok ya xaꞌtzalaj-pa chi xiꞌquitzꞌataꞌ ri jul, xquitzijuoj chica ri once (julajuj) apóstoles y chica ri quimaluon-quiꞌ quiqꞌuin, nojiel ri xquitzꞌat can. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri ixokiꞌ ri xaꞌeꞌn chica ri apóstoles, ja ri María Magdalena, ri Juana, ri María ri rutieꞌ ri Jacobo, y nicꞌaj chic ixokiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ri apóstoles xquiꞌan pensar chi ri ixokiꞌ reꞌ xa man ketzij ta ri xalquiꞌej, y rumareꞌ man xaꞌquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero ri Pedro ja xpalaj-el, y jun-anin xꞌa chuchiꞌ ri jul. Y antok xtzuꞌn-apa chupan ri jul, xutzꞌat chi joꞌc ri tziak icꞌo can chireꞌ. Jajaꞌ xtzalaj chirij, pero chapatajnak ruma nojiel ri xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chupan ri kꞌij reꞌ, icꞌo icaꞌyeꞌ chiquivach ri discípulos richin ri Jesús i-bꞌanak chupan ri bꞌay richin ncaꞌa Emaús, ri jun aldea reꞌ cꞌo once (julajuj) kilómetros quicajol riqꞌuin ri tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y ncaꞌtzijuon i-bꞌanak. Niquitzijuoj nojiel ri cꞌa jubꞌaꞌ xaꞌbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y antok bꞌanak cánima riqꞌuin ri niquitzijuoj y ri niquicꞌutuj chiquivach; jareꞌ antok ri Jesús xjiel-apa quiqꞌuin y junan xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ri icaꞌyeꞌ achiꞌaꞌ reꞌ niquitzꞌat ri bꞌanak quiqꞌuin, pero bꞌanun chica chi man nicatamaj ta roch. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y ri Jesús xucꞌutuj chica: ¿Chica ntitzijuoj ri ix-patanak? ¿Y karruma nquixbꞌisuon? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun chiquivach ijejeꞌ, ri rubꞌinan Cleofas, xchꞌo-apa cha y xuꞌej: ¿Joꞌc atreꞌ ri cꞌo pa tanamet Jerusalén ri man anaꞌien ta ri cꞌa jubꞌaꞌ xaꞌbꞌanataj? ");
INSERT INTO cakSNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xucꞌutuj chica: ¿Chica xbꞌanataj cꞌa? Y ijejeꞌ xquiꞌej: Ja ri xꞌan cha ri Jesús ri aj-Nazaret, jun ache profeta. Y xucꞌut chi cꞌo ru-poder riqꞌuin ri nimaꞌk tak milagros ri xaꞌruꞌon, y riqꞌuin ri rutzij choch ri Dios y chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ri principales sacerdotes y ri ka-autoridades, jareꞌ ri xaꞌbꞌano cha chi xquimisas choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y ojreꞌ xkacukubꞌaꞌ kacꞌuꞌx chirij chi jajaꞌ ri patanak chi nkojrucol konojiel ojreꞌ ri israelitas. Pero vacame man jun chic chica xtakaꞌan, ruma ya ja oxeꞌ kꞌij ticon. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero icꞌo kachꞌil ixokiꞌ ri macꞌajan yan xaꞌa chuchiꞌ ri jul ri pacheꞌ mukun can y xquiꞌan chika chi xojchapataj, ");
INSERT INTO cakSNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ruma xquiꞌej chi ri ru-cuerpo ri Jesús man cꞌo ta chic chupan ri jul. Y niquiꞌej jeꞌ chi cꞌo ángeles xquicꞌut-quiꞌ chiquivach y xquiꞌej chica chi ri Jesús ya xcꞌastaj-el. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y mareꞌ nicꞌaj kachꞌil ojreꞌ xaꞌa chuchiꞌ ri jul chi xbꞌaquitzꞌataꞌ. Y incheꞌl ri xalquiꞌej ri ixokiꞌ chika, quireꞌ xiꞌquilaꞌ ijejeꞌ, pero ri Jesús manak xquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Entonces ri Jesús xuꞌej chica: ¡Ixreꞌ ix-nacanak, ruma man acunak ta pan ivánima ri quiꞌeꞌn can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo! ");
INSERT INTO cakSNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Man came quiꞌeꞌn ta can ijejeꞌ chi ri Cristo can nukꞌasaj sufrimiento, cꞌajareꞌ niꞌa chicaj chi nicꞌujieꞌ pa ru-gloria? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y ri Jesús xutzꞌom cꞌa rubꞌixic chiquivach nojiel ri i-tzꞌibꞌan can chirij jajaꞌ, chupan ri ruchꞌabꞌal ri Dios. Xutzꞌom-el riqꞌuin ri i-rutzꞌibꞌan can ri Moisés, cꞌa riqꞌuin ri quitzꞌibꞌan can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y antok xaꞌbꞌaka chupan ri aldea ri pacheꞌ ncaꞌa-ve, ri Jesús xuꞌon chi naj niꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y ri icaꞌyeꞌ achiꞌaꞌ xquiꞌan obligar chi ticꞌujie-ka quiqꞌuin y xquiꞌej cha: Cacꞌue-ka kiqꞌuin, ruma ya xkakꞌij-ka, y tarde chic, xaꞌchaꞌ cha. Y ri Jesús xuoc quiqꞌuin, chi nicꞌujie-ka quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y antok i-tzꞌuyul chic apa chirij ri mesa quiqꞌuin, ri Jesús xucꞌan-apa ri simíta, xuꞌon bendecir, xuper y xuyaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Entonces incheꞌl xa xjakataj ri quinakꞌavach, y xquitzꞌat chi xa ja ri Jesús ri cꞌo quiqꞌuin. Pero jajaꞌ xsach-el chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y ri icaꞌyeꞌ achiꞌaꞌ reꞌ niquiꞌej chiquivach: Can ketzij chi jun-ve nunaꞌ ri kánima antok nkutzijuon oj-patanak, antok jajaꞌ nuꞌej ri ruchꞌabꞌal ri Dios chika, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri icaꞌyeꞌ achiꞌaꞌ reꞌ ja xaꞌpalaj-el chirij ri mesa y xquitzꞌom bꞌay chi xaꞌtzalaj Jerusalén. Y xaꞌbꞌaquilaꞌ ri once (julajuj) discípulos quimaluon-quiꞌ y ri nicꞌaj chic ri icꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y ri discípulos y ri nicꞌaj chic niquiꞌej: Ri Ajaf Jesús ketzij chi ya xcꞌastaj-pa chiquicajol ri quiminakiꞌ y xucꞌut-riꞌ choch ri Simón. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Entonces ri icaꞌyeꞌ achiꞌaꞌ xquichol-apa ri xquiꞌan antok quitzꞌamuon bꞌay Emaús, y xquitzꞌat chi ja ri Jesús antok xuper ri simíta. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y quinojiel ri quimaluon-quiꞌ, cꞌa ncaꞌtzijuon chirij ri Jesús, antok xquitzꞌat cꞌo chic chireꞌ chiquicajol, y xuꞌej chica: Paz iviqꞌuin, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Entonces ijejeꞌ altíra xquixiꞌij-quiꞌ y mareꞌ xquiꞌan pensar chi ri niquitzꞌat xa jun espíritu. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ri Jesús xuꞌej chica: ¿Karruma xsach inoꞌj antok xinitzꞌat y xpa man otz ta pensamientos iviqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Titzꞌataꞌ ri nukꞌaꞌ y ri vakan. Quinitzꞌamaꞌ, y titzꞌataꞌ chi inreꞌ. Ruma xa ta in jun espíritu, man ta cꞌo nu-cuerpo y man ta cꞌo jeꞌ nubꞌakil. Y ixreꞌ ntitzꞌat chi inreꞌ cꞌo nojiel, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y antok jajaꞌ ruꞌeꞌn chic quireꞌ chica, xucꞌut chiquivach ri rukꞌaꞌ y ri rakan. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero ijejeꞌ man niquinimaj ta, ruma xaꞌchapataj y ruma altíra ncaꞌquicuot. Y rumareꞌ ri Jesús xucꞌutuj chica: ¿Cꞌo jubꞌaꞌ ri chica nitij iviqꞌuin? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Entonces ijejeꞌ xquiyaꞌ cha jubꞌaꞌ sabꞌan car y jubꞌaꞌ miel. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y jajaꞌ xucꞌan-apa y xutej chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xuꞌej chica: Antok cꞌa incꞌo iviqꞌuin, xinꞌej chiva chi can nicꞌatzin chi nuꞌon cumplir nojiel ri tzꞌibꞌan can chuvij chupan ri ruchꞌabꞌal ri Dios: Ri tzꞌibꞌan can ruma ri Moisés, ri tzꞌibꞌan can cuma ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, y ri tzꞌibꞌan can chupan ri libro ri niꞌeꞌx Salmos cha. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Entonces xuꞌon chica chi tiꞌka pa quiveꞌ (tiquiꞌan entender) ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xuꞌej chica: Can quireꞌ tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, chi ri Cristo nicꞌatzin chi xtukꞌasaj sufrimiento, y can xticon, y chi oxeꞌ kꞌij xticꞌastaj-pa chiquicajol ri quiminakiꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y icꞌo ri xcaꞌa pa rubꞌeꞌ jajaꞌ chi xtiquitzijuoj ri ruchꞌabꞌal ri Dios chica ri vinak ri icꞌo chupan nojiel naciones, chi titzalaj-pa cánima riqꞌuin ri Dios y tiquibꞌanaꞌ ri nrajoꞌ jajaꞌ, chi quireꞌ niꞌan perdonar ri qui-pecados. Y xtitiquir-el Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y ixreꞌ ri xitzꞌat nojiel, tiꞌej nojiel ri xitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y tivaxaj otz ri niꞌej can chiva: Inreꞌ xtintak-pa chiva ri ranun prometer ri Nataꞌ Dios chi nuya-pa chiva; y ri ruꞌeꞌn jajaꞌ chi nuyaꞌ chiva, ja ri Espíritu Santo. Y jareꞌ ri xtiyoꞌn i-poder. Pero quixcꞌujieꞌ vaveꞌ pa tanamet Jerusalén hasta cꞌa antok xtika-pa ri Espíritu Santo, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y ri Jesús xaꞌrucꞌuaj ri ru-discípulos cꞌa chupan ri aldea Betania. Y chireꞌ, xupilisaj ri rukꞌaꞌ chicaj, y xaꞌruꞌon bendecir. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y ri Jesús antok cꞌa ja ncaꞌruꞌon bendecir, ja xpilisas-el y xucꞌuax-el chicaj riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y ri discípulos xquiyaꞌ rukꞌij ri Jesús. Después xaꞌtzalaj pa tanamet Jerusalén, altíra ncaꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y kꞌij-kꞌij icꞌo pa templo chi niquiyaꞌ rukꞌij ri Dios y nem niquiꞌan cha ri rubꞌeꞌ. Amén.");
INSERT INTO cakSNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Antok xtiquir-pa nojiel; ri Chꞌabꞌal can cꞌo-ve. Jajaꞌ can cꞌo-ve riqꞌuin ri Dios, y jajaꞌ jeꞌ can Dios-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Jajaꞌ can cꞌo-ve riqꞌuin ri Dios antok xtiquir-pa nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y ruma jajaꞌ cꞌo nojiel y man jun kax ri cꞌo vacame ri man ta jajaꞌ xbꞌano. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riqꞌuin jajaꞌ cꞌo-ve ri cꞌaslien. Y ri cꞌaslien reꞌ, jareꞌ ri Sakil quichin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y ri Sakil reꞌ, can nuꞌon sakil cha ri quicꞌaslien ri vinak ri icꞌo pa kꞌakuꞌn. Y man jun bꞌay cꞌa ri kꞌakuꞌn nicovin nuchup. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xcꞌujieꞌ jun ache ri xtak-pa ruma ri Dios, ri Juan rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jajaꞌ xpa chi xalrutzijuoj ri Sakil, richin chi quinojiel ri vinak tiquinimaj ri nuꞌej chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y man jajaꞌ ta ri Sakil. Jajaꞌ joꞌc xutzijuoj ri Sakil. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y xalka ri Sakil choch-ulief. Jareꞌ ri ketzij Sakil, ri nuꞌon sakil cha ri quicꞌaslien ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Can xalka choch-ulief ri rubꞌanun jajaꞌ, pero ri icꞌo choch-ulief man xquitamaj ta roch antok xalka. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Can quiqꞌuin ri ruvanakil israelitas xalka-ve, pero ri ruvanakil xa man xquiꞌan ta recibir. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero quinojiel ri xaꞌbꞌano recibir y xquinimaj, jajaꞌ xuꞌon chica chi xaꞌuoc ralcꞌual ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri vinak ri xaꞌuoc ralcꞌual ri Dios, can xaꞌlax-ve chic jun bꞌay, pero man junan ta chic riqꞌuin antok xaꞌlax naꞌay riqꞌuin ri quitieꞌ, antok ja ri quitie-quitataꞌ xcajoꞌ chi xaꞌcꞌujieꞌ. Vacame xaꞌlax chic jun bꞌay ruma quireꞌ xrajoꞌ ri Dios, y man ruma ta xrajoꞌ jun ache. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Chꞌabꞌal xalka choch-ulief y xuoc vinak incheꞌl ojreꞌ. Jajaꞌ xcꞌujieꞌ chikacajol y xkatzꞌat chi joꞌc jajaꞌ ri Rucꞌajuol ri Dios, ruma can xkatzꞌat ri namalaj ru-gloria. Y jajaꞌ nojnak riqꞌuin ri ketzij y nojnak riqꞌuin ri ru-favor ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y ri Juan cꞌo ri ruꞌeꞌn can chirij ri Cristo. Can cof xchꞌoꞌ y xuꞌej: Jareꞌ ri nutzijuon chiva, antok xinꞌej chiva chi ri xtalka chuvij inreꞌ, jareꞌ ri cꞌo antes chinoch. Y can cꞌo-ve naꞌay antok inreꞌ cꞌa majaꞌ quinalax vaveꞌ choch-ulief, xchaꞌ ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Can konojiel ojreꞌ kiluon ri ru-favor ri Cristo. Y man nitanieꞌ ta cꞌa chi nuya-pa ri favor reꞌ pa kaveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios ja ri Moisés ri xucusaj chi xuya-pa ri ley. Pero antok xuya-pa ri favor y ri ketzij, ja ri Jesucristo xucusaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Man jun vinak ri tzꞌatayuon richin ri Dios. Ri Dios joꞌc jun Rucꞌajuol cꞌo y junan icꞌo. Y jajaꞌ ri xalꞌeꞌn-ka ri Rutataꞌ chakavach vaveꞌ choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas chireꞌ pa tanamet Jerusalén, xaꞌquitak-el sacerdotes y achiꞌaꞌ ri niꞌeꞌx levitas chica riqꞌuin ri Juan el Bautista, chi xiꞌquicꞌutuj cha: ¿At chica atreꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jajaꞌ can ja ri ketzij ri xuꞌej chica, ruma xuꞌej: Man inreꞌ ta ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y ri achiꞌaꞌ ri i-takuon-el xquicꞌutuj chic cha: ¿At chica cꞌa atreꞌ? ¿Xa atreꞌ ri Elías? xaꞌchaꞌ cha. Y ri Juan xuꞌej chica: Man inreꞌ ta. Y ri achiꞌaꞌ reꞌ xquicꞌutuj chic cha: ¿Atreꞌ ri profeta? xaꞌchaꞌ cha. Jajaꞌ xuꞌej chica: Man inreꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y ri achiꞌaꞌ reꞌ can xquicꞌutuj chic cha: ¿At chica cꞌa atreꞌ? Chi quireꞌ jareꞌ nakaꞌej chica ri i-takayuon-pa kichin. ¿Chica cꞌa naꞌej chavij atreꞌ? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y jajaꞌ xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ ri jun ri choj chirij rutzꞌibꞌan can ri profeta Isaías. Ri xutzꞌibꞌaj can jajaꞌ, nuꞌej: Cꞌo jun ache ri xticꞌujieꞌ chupan jun lugar desierto, y jajaꞌ xturak cꞌa ruchiꞌ chi xtuꞌej chica ri vinak ri xcaꞌbꞌaka riqꞌuin: Tichojmij-apa rubꞌiey ri Ajaf, xchaꞌ ri Juan chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achiꞌaꞌ ri xaꞌbꞌaka riqꞌuin ri Juan, i-cachꞌil ri achiꞌaꞌ fariseos. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y ri achiꞌaꞌ reꞌ xquicꞌutuj chic cha ri Juan: ¿Karruma atreꞌ ncaꞌan bautizar ri vinak, xa man atreꞌ ta ri Cristo, ni man atreꞌ ta ri Elías, ni man atreꞌ ta ri profeta ri eꞌn chi nipa? xaꞌchaꞌ ri achiꞌaꞌ reꞌ cha ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y ri Juan xuꞌej chica: Inreꞌ, yaꞌ ri nicusaj chi nquixꞌan bautizar, pero chiꞌicajol ixreꞌ cꞌo Jun ri man ivataꞌn ta roch, ");
INSERT INTO cakSNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y jajaꞌ can chuvij inreꞌ xtalka-ve, pero jajaꞌ can cꞌo antes chinoch inreꞌ. Ri nixta nucꞌul chi inreꞌ niquir ri ximbꞌal-roch ri ruxajabꞌ, ruma jajaꞌ nem rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y nojiel reꞌ xbꞌanataj chireꞌ Betábara, ri lugar ri cꞌo-apa jucꞌan ruchiꞌ ri río Jordán, pacheꞌ nuꞌon-ve bautizar ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chucaꞌn kꞌij, antok ri Juan el Bautista xutzꞌat chi ri Jesús choj patanak riqꞌuin, xuꞌej: Ja-la ri Alaj Oveja ri takuon-pa ruma ri Dios, chi nralasaj qui-pecados ri vinak ri icꞌo choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Jareꞌ ri nutzijuon-pa chiva, antok xinꞌej chi chuvij inreꞌ xtalka Jun ri cꞌo antes chinoch inreꞌ, y can cꞌo-ve naꞌay, antok inreꞌ majaꞌ quinalax choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y inreꞌ man vataꞌn ta roch chica jajaꞌ. Pero chi nikꞌalajin chiquivach ri vinak israelitas, rumareꞌ xipa inreꞌ chi niꞌan bautizar cha yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y ri Juan xutzijuoj jeꞌ y xuꞌej: Inreꞌ can xintzꞌat ri Espíritu Santo ri xka-pa chicaj incheꞌl jun paluomix y xalcꞌujie-ka paroꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y inreꞌ man vataꞌn ta roch chica jajaꞌ. Pero ri Dios, ri xitako-pa chi ncaꞌnꞌan bautizar ri vinak cha yaꞌ, can ruꞌeꞌn chic chuva, chi antok xtintzꞌat chi nika-pa ri Espíritu Santo y nalcꞌujie-ka paroꞌ Jun, jareꞌ ri nibꞌano bautizar riqꞌuin ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Vacame xintzꞌat, y rumareꞌ nitzijuoj chi jajaꞌ ri Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y chucaꞌn kꞌij, ri Juan y icaꞌyeꞌ chiquivach ri ru-discípulos icꞌo chic chireꞌ jun bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y antok jajaꞌ xutzꞌat chi ri Jesús nakꞌax chireꞌ, xuꞌej: Titzꞌataꞌ, ja Alaj Oveja la ri takuon-pa ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y antok ri icaꞌyeꞌ ru-discípulos ri Juan xcaꞌxaj quireꞌ, ja xaꞌa chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y antok ri Jesús xtzuꞌn can chirij y xutzꞌat chi ri icaꞌyeꞌ ru-discípulos ri Juan i-bꞌanak chirij, jajaꞌ xuꞌej chica: ¿Chica nticanuj? xchaꞌ chica. Y ijejeꞌ xquiꞌej cha ri Jesús: Rabí (ri tzij Rabí nrajoꞌ nuꞌej Maestro), ojreꞌ nakajoꞌ nakatamaj pacheꞌ atcꞌo-ve, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y ri Jesús xuꞌej chica: Joꞌ y titzꞌataꞌ. Y ijejeꞌ can xaꞌa y xquitzꞌat ri pacheꞌ cꞌo-ve. Y xaꞌcꞌujie-ka riqꞌuin ri Jesús ri jun nakakꞌij reꞌ, ruma ya a las cuatro. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri jun chiquivach ri icaꞌyeꞌ discípulos ri xraꞌxaj ri xuꞌej ri Juan y xaꞌa chirij ri Jesús, ja ri Andrés ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Simón Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés naꞌay xril ri Simón ri quichakꞌ-quinimal-quiꞌ riqꞌuin y xuꞌej cha: Vacame xkil ri Mesías (ri tzij Mesías nrajoꞌ nuꞌej ri Cristo). ");
INSERT INTO cakSNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Y ri Andrés xucꞌuaj ri Simón riqꞌuin ri Jesús. Y antok ri Jesús xutzꞌat, xuꞌej cha: Atreꞌ ri Simón ri at rucꞌajuol ri Jonás. Vacame xtiꞌeꞌx Cefas chava (ri tzij Cefas nrajoꞌ nuꞌej Pedro). ");
INSERT INTO cakSNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Y chucaꞌn kꞌij, ri Jesús xuꞌon pensar chi niꞌa cꞌa Galilea. Y chupan ri kꞌij reꞌ ri Jesús xbꞌarucꞌuluꞌ jun ache Felipe rubꞌeꞌ y xuꞌej cha: Joꞌ viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y ri Felipe aj-Betsaida, ri quitanamit jeꞌ ri Andrés y ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri Felipe xbꞌarucꞌuluꞌ ri Natanael, y xuꞌej cha: Vacame xkil ri Jun ri choj chirij rutzꞌibꞌan can ri Moisés chupan ri ley y ri quitzꞌibꞌan can ri profetas ojier can tiempo. Jajaꞌ ja ri Jesús ri rucꞌajuol ri José aj-Nazaret. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y ri Natanael xuꞌej: ¿Xtiel-pa came jun utzulaj ache chireꞌ pa tanamet Nazaret? xchaꞌ cha. Pero ri Felipe xuꞌej cha: Joꞌ y katzꞌataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y antok ri Jesús xutzꞌat chi ya nalka ri Natanael riqꞌuin, xuꞌej: Titzꞌataꞌ ri jun ache la, jajaꞌ jun ketzij israelita, ruma man jun engaño riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Y ri Natanael xucꞌutuj cha ri Jesús: ¿Pacheꞌ xavatamaj-ve noch? Y ri Jesús xuꞌej cha: Inreꞌ xantzꞌat antok atcꞌo chuxieꞌ ri mata víquix, antok cꞌa majaꞌ carayuoj ri Felipe, xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael xuꞌej cꞌa cha: Rabí, atreꞌ ri Rucꞌajuol ri Dios. Y atreꞌ ri Rey richin ri tanamet Israel, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y ri Jesús xuꞌej cha ri Natanael: ¿Atreꞌ xanimaj chi inreꞌ ri Rucꞌajuol ri Dios, ruma xinꞌej chava chi xantzꞌat chuxieꞌ ri mata víquix? Cꞌo kax más nimaꞌk xtatzꞌat, choch ri xatzꞌat vacame. ");
INSERT INTO cakSNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y ri Jesús xuꞌej cꞌa: Can ketzij, ketzij ri niꞌej chiva: Ixreꞌ can xtitzꞌat chi ri chicaj xtijakataj, y ri ángeles richin ri Dios xcaꞌxulie-xcaꞌjotieꞌ paroꞌ ri Xtak-pa chicaj chi xalax chiꞌicajol, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y chi oxeꞌ kꞌij, chireꞌ pa tanamet Caná ri cꞌo Galilea, cꞌo jun cꞌulubꞌic xꞌan. Y ri rutieꞌ ri Jesús cꞌo chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y ri Jesús y ri ru-discípulos xaꞌan jeꞌ invitar chupan ri cꞌulubꞌic reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y ri vino xa xqꞌuis chupan ri cꞌulubꞌic. Y ri rutieꞌ ri Jesús xjiel-pa riqꞌuin y xuꞌej cha: Manak chic vino quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero ri Jesús xuꞌej cha: ¿Chica navajoꞌ chuva nuoya? Ruma ri nu-huora majaꞌ talka, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y ri rutieꞌ ri Jesús xuꞌej chica ri ncaꞌbꞌano servir: Xa cꞌo chica xtuꞌej ri Jesús chiva, tibꞌanaꞌ nojiel, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y chireꞌ icꞌo vakiꞌ yacbꞌal-yaꞌ i-bꞌanun cha abꞌaj, ruma chupan reꞌ ri israelitas niquiya-ve ri yaꞌ ri nicꞌatzin chica chi niquichꞌaj-quiꞌ, incheꞌl nuꞌej ri ley chi tiquibꞌanaꞌ. Y ri yacbꞌal-yaꞌ reꞌ, cajeꞌ o vuꞌuoꞌ cucuꞌ quipan. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y ri Jesús xuꞌej chica ri ncaꞌbꞌano servir: Quiꞌinojsaj ri yacbꞌal-yaꞌ reꞌ cha yaꞌ, xchaꞌ chica. Y ijejeꞌ quireꞌ xquiꞌan. Can xaꞌquinojsaj ri yacbꞌal-yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Después ri Jesús xuꞌej chica: Vacame tipaja-el jubꞌaꞌ y tivucꞌuaj cha ri ache ri encargado richin ri namakꞌej. Y ri ncaꞌbꞌano servir, can xquiꞌan-ve ri xuꞌej ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Y antok ri ache ri encargado richin ri namakꞌej xunaꞌ chi jaꞌal ruquiꞌal ri vino reꞌ, jajaꞌ man rataꞌn ta pacheꞌ xpa-ve, xa joꞌc ri xaꞌpajo-el ri i-taꞌmayuon. Mareꞌ xrayuoj ri alaꞌ ri xcꞌulieꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y xuꞌej cha: Antok cꞌo jun namakꞌej quireꞌ, quinojiel vinak ja ri vino ri más otz niquiyaꞌ naꞌay, y antok ri icꞌo pa namakꞌej quikumun qꞌuiy chic vino, jareꞌ antok niquiyaꞌ ri vino ri man can ta otz. Pero atreꞌ xa man quireꞌ ta xaꞌan. Atreꞌ xa cꞌajaꞌ xavalasaj-pa ri vino ri más otz, xchaꞌ ri encargado. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xuꞌon ri Jesús chupan ri cꞌulubꞌic pa tanamet Caná ri cꞌo Galilea, jareꞌ ri naꞌay milagro ri xuꞌon. Y riqꞌuin reꞌ, xucꞌut cꞌa chi jajaꞌ cꞌo rukꞌij. Y ri ru-discípulos can xquiyaꞌ cánima riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Antok xqꞌuis ri namakꞌej richin ri cꞌulubꞌic, ri Jesús, ri rutieꞌ, ri i-ruchakꞌ y ri ru-discípulos xaꞌa-ka pa tanamet Capernaum. Y xaꞌcꞌujieꞌ chireꞌ man qꞌuiy ta kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y xa cierca chic ri Pascua, ri jun quinamakꞌej ri israelitas y ri Jesús xꞌa cꞌa pa tanamet Jerusalén richin ri namakꞌej reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y chireꞌ pa templo ri cꞌo Jerusalén, ri Jesús xaꞌbꞌarilaꞌ ri ncaꞌcꞌayin váquix, ovejas y paluomix. Y ri niquicꞌax miera i-tzꞌuyul chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Y ri Jesús xuchojmij jun caloꞌ chi ncaꞌruchꞌey y xaꞌrutarariej-el quinojiel ri ncaꞌcꞌayin ovejas y váquix chireꞌ pa templo. Y chica ri niquicꞌax miera, xuqꞌuiak can ri qui-miera chiquivach y xupajqꞌuij can ri qui-mesas. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y chica ri ncaꞌquicꞌayij paluomix xuꞌej: Quiꞌivalasaj-el reꞌ vaveꞌ. Y man tiꞌan cha ri rachuoch ri Nataꞌ Dios jun qꞌuiyiꞌal, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Rumareꞌ ri ru-discípulos xalka pa quiveꞌ ri tzij ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. Ri tzij reꞌ nuꞌej: Nikꞌaxo vánima ruma ri niquiꞌan ri vinak chupan ri avachuoch, nichaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: ¿Chica señal naꞌan chakavach chi nakatzꞌat chi cꞌo poder pan akꞌaꞌ chi xaꞌvokotaj-el ri vinak vaveꞌ? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y ri Jesús xuꞌej chica: Tivulij va templo va, y inreꞌ chi oxeꞌ kꞌij xtinpabꞌaꞌ chic jun bꞌay, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: Ri templo va, cuarenta y seis junaꞌ xꞌan chi xpabꞌax. ¿Y atreꞌ naꞌej chi napabꞌaꞌ chi oxeꞌ kꞌij? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri templo ri xuꞌej ri Jesús chica ri vinak reꞌ, xa ja ri ru-cuerpo jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y rumareꞌ, antok ri Jesús xbꞌacꞌastaj-pa chiquicajol ri quiminakiꞌ, ri ru-discípulos xalka pa quiveꞌ ri tzij ri xuꞌej chica ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas. Y xquinimaj ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can y ri tzij ri i-ruꞌeꞌn can ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupan ri kꞌij antok ri Jesús cꞌo pa tanamet Jerusalén ruma ri namakꞌej Pascua, can iqꞌuiy xaꞌniman richin ruma xaꞌquitzꞌat ri milagros ri xaꞌruꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man xuꞌon ta confiar-riꞌ quiqꞌuin, ruma jajaꞌ rataꞌn ri cꞌo riqꞌuin cánima quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Y man nicꞌatzin ta chi cꞌo ta jun ri niꞌeꞌn cha chica rubꞌanun ri quicꞌaslien chiquijunal, ruma jajaꞌ rataꞌn ri cꞌo riqꞌuin cánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y cꞌo jun ache chiquicajol ri fariseos ri rubꞌinan Nicodemo, y ri ache reꞌ jun principal chiquivach ri vinak israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jajaꞌ xalka riqꞌuin ri Jesús jun nocokꞌaꞌ y xuꞌej cha: Rabí, kataꞌn chi at jun Maestro ri at-takuon-pa ruma ri Dios; ruma man jun nitiquir nibꞌano ri milagros ri incheꞌl naꞌan atreꞌ, xa manak ri Dios riqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y ri Jesús xuꞌej cha ri Nicodemo: Can ketzij, ketzij ri niꞌej chava, chi xa jun man xtalax ta chic jun bꞌay, man xtuoc ta chupan ri ru-reino ri Dios, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xuꞌej cha ri Jesús: ¿Cꞌo came cheꞌl nalax chic jun bꞌay jun ache ri qꞌuiy chic rujunaꞌ? ¿Cꞌo came cheꞌl ntuoc chic chupan ri rutieꞌ y nalax chic jun bꞌay? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xuꞌej: Can ketzij, ketzij ri niꞌej chava, chi xa jun man xtalax ta riqꞌuin yaꞌ y riqꞌuin ri Espíritu Santo, man xtuoc ta chupan ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri nalax choch-ulief, can richin ri roch-ulief. Pero ri nalax riqꞌuin ri Espíritu Santo, can richin ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Man cachapataj ruma ri xinꞌej chava: Chi nicꞌatzin chi ncatalax chic jun bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri cakꞌiekꞌ chica-na lugar nipa-ve y navaxaj, pero man avataꞌn ta pacheꞌ patanak-ve y man avataꞌn ta jeꞌ pacheꞌ niꞌa-ve. Quireꞌ mismo nibꞌanataj quiqꞌuin ri ncaꞌlax riqꞌuin ri Espíritu Santo, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y ri Nicodemo xucꞌutuj cha ri Jesús: ¿Chica cꞌa modo nibꞌanataj reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xuꞌej cha: ¿At jun maestro chiquicajol ri israelitas, y man avataꞌn ta? ");
INSERT INTO cakSNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Inreꞌ can ketzij, ketzij ri niꞌej chava, chi ri nitzijuoj ja ri vataꞌn y ri nutzꞌatuon, pero atreꞌ y ri vinak man ntivajoꞌ ta ntinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ixreꞌ man ntinimaj ta ri niꞌej chiva, y xa chiquij kax ri ncaꞌbꞌanataj vaveꞌ choch-ulief nquichꞌo-ve. ¿Chica modo xtinimaj xa ta nquichꞌoꞌ chiva chiquij ri kax richin ri chicaj? ");
INSERT INTO cakSNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Y chicaj man jun bꞌanak, xa joꞌc ri Jun ri Xtak-pa chicaj chi xalax chiꞌicajol y can riqꞌuin ri Dios cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y incheꞌl xuꞌon ri Moisés ojier can antok xcꞌujieꞌ pa desierto, xutic jun chieꞌ nem rakan y xuyaꞌ jun cumatz paroꞌ ri bꞌanun cha bronce, quireꞌ mismo nicꞌatzin niꞌan cha ri Jun ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chi quireꞌ chica-na ri xtiniman richin, man niꞌa ta chupan ri sufrimiento ri man niqꞌuis ta, xa can xticꞌujieꞌ riqꞌuin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios can altíra ncaꞌrajoꞌ ri vinak ri icꞌo choch-ulief, rumareꞌ xutak-pa ri único Rucꞌajuol vaveꞌ choch-ulief, chi quireꞌ chica-na vinak ri xtiniman richin, man xtiꞌa ta chupan ri sufrimiento ri man niqꞌuis ta, xa can xticꞌujieꞌ riqꞌuin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ruma ri Dios man xutak ta pa ri Rucꞌajuol vaveꞌ choch-ulief chi ncaꞌruꞌon condenar ri vinak. Ri Dios xutak-pa ri Rucꞌajuol chi ncaꞌrucol ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ri xtiniman richin, man xtiꞌan ta condenar. Pero ri man xtiniman ta richin, can ya bꞌanun chic condenar, ruma man xunimaj ta ri único Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ri Dios ncaꞌruꞌon condenar ri vinak; ruma ri Sakil xalka choch-ulief, pero ri vinak más xcajoꞌ ri kꞌakuꞌn choch ri Sakil, ruma ijejeꞌ joꞌc ri itziel tak kax ri nicajoꞌ niquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y quinojiel ri ncaꞌbꞌano ri itziel tak kax, man nika ta chiquivach ri Sakil, ni man ncaꞌpa ta chupan, ruma ri Sakil nuꞌon chi ncaꞌbꞌakꞌalajin-pa nojiel ri itziel tak kax ri ncaꞌquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ri vinak ri niquiꞌan ri ketzij, can ncaꞌpa chupan ri Sakil chi nikꞌalajin chi niquiꞌan incheꞌl nrajoꞌ ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Después reꞌ, ri Jesús y ri ru-discípulos xaꞌa Judea, y chireꞌ xaꞌbꞌacꞌujie-ve. Y xaꞌlka ri vinak chireꞌ chi xaꞌan bautizar. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupan jeꞌ ri tiempo reꞌ, ri Juan el Bautista cꞌo chireꞌ Enón, ri cꞌo cierca ri tanamet Salim. Jajaꞌ chireꞌ ncaꞌruꞌon-ve bautizar ri vinak, ruma chupan ri lugar reꞌ qꞌuiy yaꞌ cꞌo. Ri vinak ncaꞌlka riqꞌuin chi ncaꞌan-el bautizar. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupan ri tiempo reꞌ ri Juan el Bautista cꞌa majaꞌ titzꞌapes pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y icꞌo israelitas ri xquitzꞌom-quiꞌ chi tzij quiqꞌuin ri ru-discípulos ri Juan chirij ri chica bautismo ri más otz. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xaꞌpa ri discípulos reꞌ riqꞌuin ri Juan y xquiꞌej cha: Rabí, ri Jun ri xalka aviqꞌuin ri jucꞌan chic ruchiꞌ ri río Jordán, ri xaꞌej chi jajaꞌ ri natzijuoj, ncaꞌruꞌon bautizar ri vinak y quinojiel chic ri vinak ncaꞌlka riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Y ri Juan xuꞌej chica ri ru-discípulos: Man jun nicovin nuꞌon jun kax, xa man ja ta ri Dios yaꞌyuon-pa cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y ixreꞌ mismo ivaxan ri nuꞌeꞌn inreꞌ, chi man inreꞌ ta ri Cristo. Inreꞌ joꞌc nuꞌeꞌn chi xitak-pa naꞌay choch jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Niꞌan incheꞌl nuꞌon jun alaꞌ, ri cꞌo jun ru-amigo ri xcꞌulieꞌ y niquicuot ruma ncaꞌraꞌxaj ri ache y ri ixok ncaꞌtzijuon. Can rataꞌn chi ri ixok cꞌo chic riqꞌuin ri rachajil, quireꞌ nquiquicuot inreꞌ riqꞌuin ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Can ja ri Jesucristo ri nicꞌatzin chi kꞌij-kꞌij ninimar más rukꞌij, pero inreꞌ otz chi kꞌij-kꞌij más coꞌl niꞌan-ka, xchaꞌ ri Juan. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri patanak chicaj, jareꞌ ri cꞌo pa kaveꞌ konojiel. Ri cꞌo choch-ulief joꞌc ri cꞌo choch-ulief ri nitiquir nuꞌej. Pero ri Jun ri kajnak-pa chicaj cꞌo paroꞌ nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri Jun ri patanak chicaj, ja ri raxan-pa y rutzꞌatuon-pa, jareꞌ ri nalrutzijuoj-ka chika. Pero ri vinak man nicajoꞌ ta niquinimaj ri nutzijuoj jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ri vinak ri niquinimaj ri nutzijuoj ri Jun ri patanak chicaj, can niquiꞌej chi ri Dios can ketzij-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ruma ri Jun ri Xtak-pa ruma ri Dios choch-ulief, can ja ri nuꞌej ri Dios ri nutzijuoj. Y ri Dios can ruyoꞌn-pa ri Espíritu Santo cha, y man xrataj ta xuya-pa cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y ri Ajaf Dios altíra nrajoꞌ ri Rucꞌajuol, y pa rukꞌaꞌ jajaꞌ xujach-ve nojiel. ");
INSERT INTO cakSNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ri vinak ri xtiquinimaj ri Rucꞌajuol ri Dios, can xticꞌujieꞌ quiqꞌuin ri cꞌaslien ri man xtiqꞌuis ta. Pero ri vinak ri man nicajoꞌ ta niquinimaj ri Rucꞌajuol ri Dios, man xticꞌujieꞌ ta quiqꞌuin ri cꞌaslien ri man niqꞌuis ta; xa ja ri rayoval ri Dios ri cꞌo pa quiveꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Ajaf Jesús xunaꞌiej chi ri achiꞌaꞌ fariseos caxan chi jajaꞌ más iqꞌuiy vinak ri ncaꞌruꞌon bautizar y más iqꞌuiy ri ru-discípulos que choch ri Juan el Bautista. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero man ja ta ri Jesús nibꞌano bautizar quichin ri vinak; xa ja ri ru-discípulos ri ncaꞌbꞌano bautizar. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Antok ri Jesús xunaꞌiej quireꞌ, xiel-el chireꞌ Judea y xtzalaj chic jun bꞌay Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Y chi niꞌka Galilea, nicꞌatzin chi nakꞌax Samaria. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri Jesús xbꞌaka chupan ri tanamet Sicar, ri jun tanamet richin ri Samaria ri cꞌo cierca ri ulief ri xuyaꞌ ri Jacob cha ri José ri rucꞌajuol ojier can. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y chireꞌ cꞌo-ve ri pozo ri ranun can ri Jacob. Chireꞌ xtzꞌuye-ve ri Jesús, ruma jajaꞌ altíra cosnak-pa ruma ri bꞌinien ri ranun-pa. Como pa nicꞌaj-kꞌij laꞌk reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Y cꞌo jun ixok aj-Samaria xalka chuchiꞌ ri pozo chi nralasaj ruyaꞌ. Y ri Jesús xuꞌej cha ri ixok reꞌ: Tasipaj bꞌaꞌ nuyaꞌ chi nikun, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Antok xalka ri ixok, i-bꞌanak ri ru-discípulos pa tanamet chulokꞌic ri chica niquitej. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ri ixok aj-Samaria xuꞌej cha ri Jesús: ¿Karruma nacꞌutuj ayaꞌ chuva inreꞌ ri in jun ixok aj-Samaria, y atreꞌ xa at israelita? xchaꞌ ri ixok. Jajaꞌ xuꞌej quireꞌ ruma ri israelitas y ri aj-Samaria xa man nicajoꞌ ta quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ri Jesús xuꞌej cha ri ixok reꞌ: Xa ta atreꞌ avataꞌn ri chica ruyoꞌn-pa ri Dios, y avataꞌn ta jeꞌ ri chica nicꞌutun ruyaꞌ chava; atreꞌ yan chic nacꞌutuj ayaꞌ cha, y jajaꞌ nuyaꞌ chava ri yaꞌ ri nuyaꞌ cꞌaslien, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y ri ixok xuꞌej cha ri Jesús: Tuoya, ri pozo naj kajnak, y atreꞌ man jun choj cha navalasaj-ka ri yaꞌ. ¿Pacheꞌ nacꞌan-ve ri yaꞌ ri nuyaꞌ cꞌaslien? ");
INSERT INTO cakSNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Será que atreꞌ más at nem choch ri kamamaꞌ Jacob ri xcꞌujieꞌ ojier can, ri xuyaꞌ chika va pozo va, ruma chupan va xralasaj-el ruyaꞌ jajaꞌ, y quichin ri ralcꞌual y ri cavaj? xchaꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xuꞌej cha ri ixok: Ri ncaꞌkumu ri yaꞌ ri ntiel chupan va pozo va, man xtiqꞌuis ta ri chakej-cheꞌ chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero ri ncaꞌkumu ri yaꞌ ri niyaꞌ inreꞌ, man jun bꞌay xtichakej ta chic quichiꞌ, xa xtuꞌon riqꞌuin cánima incheꞌl jun nacimiento richin yaꞌ, ri can xtipulin richin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y ri ixok xuꞌej cha ri Jesús: Tuoya, tayaꞌ ri yaꞌ reꞌ chuva inreꞌ, chi quireꞌ man chic xtichakej ta nuchiꞌ y ni man chic xquipa ta vaveꞌ chuchiꞌ ri pozo chi nalvalasaj. Quireꞌ xuꞌej ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ri Jesús xuꞌej cha ri ixok: Caꞌin y avayuoj ri avachajil, y ncapa chic vaveꞌ, xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xuꞌej: Inreꞌ manak vachajil, xchaꞌ. Y ri Jesús xuꞌej cha: Can ketzij ri naꞌej chi manak avachajil. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ruma ivuꞌuoꞌ yan avachajil caꞌcꞌujieꞌ, y ri ache ri cꞌo aviqꞌuin vacame man avachajil ta. Can ketzij ri xaꞌej chi manak avachajil, xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y ri ixok xuꞌej cha ri Jesús: Tuoya, inreꞌ niꞌan pensar chi atreꞌ at jun profeta. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri katie-katataꞌ ri xaꞌcꞌujieꞌ ojier can, paroꞌ ri jun juyuꞌ va xquiyaꞌ rukꞌij ri Dios. Pero ixreꞌ ri israelitas ntiꞌej chi ja ri Jerusalén ri lugar ri pacheꞌ niyoꞌx rukꞌij ri Dios, xchaꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Y ri Jesús xuꞌej cha: Nuoya, tanimaj ri xtinꞌej chava, chi xtalka jun kꞌij antok quinojiel vinak man paroꞌ ta chic ri juyuꞌ va, ni Jerusalén jeꞌ xtiquiyaꞌ rukꞌij ri Katataꞌ Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ixreꞌ aj-Samaria man ivataꞌn ta roch ri ntiyaꞌ rukꞌij. Pero ojreꞌ ri israelitas kataꞌn ri chica ri nakayaꞌ rukꞌij; ruma kiqꞌuin ojreꞌ ntiel-pa ri nicalo quichin ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ri jun kꞌij ri xinꞌej chava chi nipa, ya xalka. Ruma vacame ri ketzij xtiquiyaꞌ rukꞌij ri Katataꞌ Dios, can ketzij y riqꞌuin nojiel cánima xtiquiyaꞌ rukꞌij. Y ri Dios ncaꞌrucanuj ri vinak ri ncaꞌbꞌano quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios can Espíritu. Rumareꞌ ri vinak ri ncaꞌyoꞌn rukꞌij, can nicꞌatzin chi ketzij y riqꞌuin nojiel cánima tiquiyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y ri ixok xuꞌej cha ri Jesús: Inreꞌ vataꞌn chi cꞌo jun kꞌij antok ri Mesías ri niꞌeꞌx jeꞌ Cristo cha, xtalka choch-ulief. Y ri kꞌij antok xtalka jajaꞌ, nojiel xtuꞌej chakavach, xchaꞌ ri ixok. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xuꞌej cha: Ri Mesías xa inreꞌ ri nquitzijuon aviqꞌuin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y jareꞌ antok xaꞌlka ri ru-discípulos; y can xaꞌchapataj ruma nitzijuon riqꞌuin jun ixok, pero man jun chiquivach xcꞌutun cha ri Jesús: ¿Chica nacꞌutuj cha? o, ¿Chica ri natzijuoj riqꞌuin? ");
INSERT INTO cakSNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y ri ixok reꞌ xuyaꞌ can ri ru-cántaro chireꞌ y xꞌa pa tanamet. Y xbꞌaruꞌej chica ri vinak: ");
INSERT INTO cakSNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","Cꞌo jun ache xtzijuon viqꞌuin y xuꞌej chuva nojiel ri i-nubꞌanun. ¿Man ja ta came reꞌ ri Cristo? Quixam-pa y titzꞌataꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y ri vinak ri xaꞌcꞌaxan, xaꞌiel-pa pa tanamet y xaꞌa cꞌa pacheꞌ cꞌo-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y antok cꞌa majaꞌ caꞌlka ri vinak, ri discípulos xquiꞌej cha ri Jesús: Rabí, cavaꞌ, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero jajaꞌ xuꞌej chica: Inreꞌ cꞌo nutiꞌ chi nitej, y ixreꞌ man ivataꞌn ta chica, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ri ru-discípulos xquiꞌej-ka chiquivach: ¿Cꞌo came jun xcꞌamo-pa ri chica nutej? ");
INSERT INTO cakSNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xuꞌej chica: Ri nutiꞌ inreꞌ ja chi niꞌan ri nurayij ri takayuon-pa vichin y niqꞌuis can rubꞌanic nojiel ri rusamaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ixreꞌ ntiꞌej chi cꞌa cꞌo cajeꞌ icꞌ nrajoꞌ chi ntiꞌan cosechar nojiel ri ticoꞌn. Pero inreꞌ niꞌej chiva: Quixtzuꞌn chila y quiꞌitzꞌataꞌ la vinak. Ijejeꞌ i-incheꞌl jun ticoꞌn ri kꞌan chic. Quiyoꞌien chic chi nitzijos ri ruchꞌabꞌal ri Dios chica, chi niquinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri xcaꞌbꞌano cosechar ri cosecha reꞌ can xcaꞌtuoj; ruma ri vinak ri xtiquinimaj ri ruchꞌabꞌal ri Dios, xticꞌujieꞌ quiqꞌuin ri cꞌaslien ri man niqꞌuis ta. Y rumareꞌ ri i-tiquiyuon can ri ruchꞌabꞌal ri Dios, can xtiquicuot cánima junan quiqꞌuin ri xcaꞌbꞌano cosechar. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Vaveꞌ ketzij ntiel ri tzij ri nuꞌej: Jun-ve ri nitico y jun-ve chic ri nibꞌano cosechar. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Inreꞌ xixtak chi ixreꞌ joꞌc chic ntiꞌan cosechar ri man ixreꞌ ta ri xixtico. Nicꞌaj chic ri i-tiquiyuon can ri ticoꞌn reꞌ, y ixreꞌ joꞌc chic xiꞌbꞌanaꞌ cosechar, xchaꞌ ri Jesús chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupan ri kꞌij reꞌ, can iqꞌuiy vinak xquinimaj ri Jesús chireꞌ pa tanamet Sicar, ri cꞌo Samaria. Ijejeꞌ xquinimaj ruma ri ixok xbꞌaruꞌej chica: Ri Jesús can xuꞌej chuva nojiel ri i-nubꞌanun-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Entonces ri vinak aj-Samaria xaꞌlka y xquicꞌutuj favor cha ri Jesús chi ticꞌujie-ka quiqꞌuin. Y jajaꞌ xcꞌujieꞌ caꞌyeꞌ kꞌij quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y más iqꞌuiy xquinimaj antok xcaꞌxaj ri xuꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ri vinak reꞌ niquiꞌej cha ri ixok: Vacame nakanimaj man joꞌc ta ruma ri xaꞌej atreꞌ chika, xa nakanimaj ruma ri xkaxaj ojreꞌ mismo. Xkatamaj chi ketzij chi jajaꞌ ri Cristo, ri nicalo quichin quinojiel vinak ri icꞌo choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Antok kꞌaxnak chic ri caꞌyeꞌ kꞌij, ri Jesús xuyaꞌ can ri tanamet Sicar ri cꞌo Samaria y xꞌa cꞌa Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ruma jajaꞌ mismo xꞌeꞌn: Ri profeta pa rutanamit, man jun rakalien xtiꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero antok ri Jesús xalka Galilea, ri vinak aj-chireꞌ can otz xquiꞌan recibir; ruma ri vinak reꞌ xaꞌcꞌujieꞌ Jerusalén chupan ri namakꞌej y xquitzꞌat ri milagros ri xaꞌruꞌon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Xpa chic jun bꞌay ri Jesús pa tanamet Caná ri cꞌo chireꞌ Galilea, pacheꞌ xuꞌon cha ri yaꞌ chi xuoc vino. Y chireꞌ mismo Galilea, chupan ri tanamet Capernaum, cꞌo jun rusamajiel ri rey, ri niyavaj jun rucꞌajuol. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Antok ri rusamajiel ri rey xraꞌxaj chi ri Jesús patanak cꞌa Judea y vacame cꞌo Galilea, jajaꞌ xpa cꞌa riqꞌuin y xucꞌutuj favor cha chi niꞌa-ka riqꞌuin chi niꞌrubꞌanaꞌ sanar ri rucꞌajuol, ruma ya nicon. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ri Jesús xuꞌej cha ri rusamajiel ri rey: Xa man ta ntitzꞌat ri señales y milagros ri niꞌan inreꞌ, man ta nquininimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ri ache ri rusamajiel ri rey xuꞌej cha ri Jesús: Ajaf, tabꞌanaꞌ favor cꞌa chi ncaꞌa-ka pa tanamet Capernaum, antes que nicon-ka ri nucꞌajuol. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y ri Jesús xuꞌej cha: Caꞌin. Ri acꞌajuol man xticon ta. Y ri ache reꞌ can xunimaj ri xuꞌej ri Jesús, y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Antok ri ache ri rusamajiel ri rey xulan-ka, ri ru-esclavos jajaꞌ xalquicꞌuluꞌ y xquiꞌej cha: Ri acꞌajuol cꞌas. Man xcon ta, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y jajaꞌ xucꞌutuj chica ri ru-esclavos chi chica huora xquitzꞌat chi otz xunaꞌ ri rucꞌajuol. Y ri ru-esclavos xquiꞌej: Nakakꞌij ivir a la una, antok xqꞌuis-el ri cꞌatan chirij, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ri rutataꞌ ri alaꞌ xalka paroꞌ chi ja huora reꞌ antok ri Jesús xuꞌej cha chi ri rucꞌajuol man xticon ta. Y rumareꞌ jajaꞌ y ri ru-familia xquinimaj ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y jareꞌ ri rucaꞌn milagro ri xuꞌon ri Jesús chireꞌ Galilea; antok patanak cꞌa Judea. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y después ri nojiel reꞌ, ya mero nalka jun quinamakꞌej ri israelitas, y rumareꞌ ri Jesús xꞌa-el pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Y chireꞌ pa tanamet Jerusalén, cierca ri puerta ri niꞌeꞌx Quichin Ovejas cha, cꞌo jun estanque ri pa chꞌabꞌal hebreo niꞌeꞌx Betesda cha. Chuchiꞌ reꞌ cꞌo vuꞌuoꞌ galeras. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chireꞌ chupan ri galeras icꞌo iqꞌuiy yavaꞌiꞌ, icꞌo muoy, icꞌo ri jacajic cakan, y icꞌo paralíticos, y quiyoꞌien chi nisiluon-pa ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ruma ri yaꞌ reꞌ cꞌo kꞌij nalsilos ruma jun ángel ri nika-pa chicaj riqꞌuin ri Dios. Y ri nika-ka naꞌay chupan ri yaꞌ, jareꞌ ri nicꞌachoj; mesque chica-na yabꞌil ntuoc cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chireꞌ chuchiꞌ ri yaꞌ cꞌo jun ache ri treinta y ocho junaꞌ tiyavaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun kꞌij antok ri Jesús nakꞌax chireꞌ, xutzꞌat ri ache catzꞌol chireꞌ. Y can rataꞌn chi ri ache reꞌ can qꞌuiy junaꞌ ri quireꞌ rubꞌanun-pa. Y jajaꞌ xucꞌutuj cha ri ache reꞌ: ¿Navajoꞌ ncaꞌan sanar? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y ri ache xuꞌej cha ri Jesús: Tuoya, antok nisiluon-pa la yaꞌ, man jun nibꞌano favor chuva chi nquiruyaꞌ cꞌa chupan. Rumareꞌ, mesque nitej nukꞌij chi nquiꞌa-apa, pero cꞌa majaꞌ quibꞌaka inreꞌ, ja nika-ka jun naꞌay chinoch, xchaꞌ cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y ri Jesús xuꞌej cha ri ache: Capalaj, tavucꞌuaj ri avaraꞌal y caꞌin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Y chaꞌnin ri ache reꞌ xꞌan sanar riqꞌuin ri ruyabꞌil, xucꞌol-el ri ruvaraꞌal y niꞌin xꞌa. Ri kꞌij reꞌ, kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri ache ri xꞌan sanar: Vacame kꞌij richin uxlanien, man otz ta chi avucꞌuan la avaraꞌal, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero jajaꞌ xuꞌej chica ri achiꞌaꞌ reꞌ: Ri xibꞌano sanar xuꞌej chuva: Tavucꞌuaj la avaraꞌal y caꞌin, xchaꞌ chuva. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achiꞌaꞌ reꞌ xquicꞌutuj cha ri ache: ¿Chica xꞌeꞌn chava chi tacꞌaloꞌ ri avaraꞌal y caꞌin? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri ache man rataꞌn ta ri chica xbꞌano sanar richin, ruma ri Jesús xa man xcꞌujieꞌ ta ka chiquicajol ri vinak ri icꞌo chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Después ri Jesús xbꞌarilaꞌ ri ache pa templo y xuꞌej cha: Vacame at otz yan chic. Man chic taꞌan pecado, chi quireꞌ man xtipa ta chic jun kax más peor chavij, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y ri ache xꞌa, y xbꞌaka quiqꞌuin ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, y xuꞌej chica: Ri xibꞌano sanar, ja ri Jesús, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Rumareꞌ ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas can xaꞌpalaj chirij ri Jesús, y niquiꞌan pensar chica niquiꞌan chi niquiquimisaj, ruma ri Jesús cꞌo milagros ncaꞌruꞌon chupan ri kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xuꞌej chica: Ri Nataꞌ Dios cꞌa nisamaj vacame, y quireꞌ jeꞌ niꞌan inreꞌ, cꞌa nquisamaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y ja antok ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, más xquiꞌan pensar chirij chica niquiꞌan chi niquiquimisaj ri Jesús; ruma chiquivach ijejeꞌ, xajan ri ncaꞌruꞌon chupan ri kꞌij richin uxlanien. Y man joꞌc ta rumareꞌ, xa ruma jeꞌ ri Jesús nuꞌej Rutataꞌ cha ri Dios y nuꞌon chi jajaꞌ junan riqꞌuin ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y ri Jesús xuꞌej: Can ketzij, ketzij ri niꞌej chiva: Ri Rucꞌajuol ri Dios man nisamaj ta ruyuon; xa nicꞌatzin chi nroyoꞌiej ri nuꞌej ri Rutataꞌ. Ruma ja ri samaj ri nrajoꞌ ri Rutataꞌ, jareꞌ ri nuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y ruma ri Rutataꞌ altíra nrajoꞌ ri Rucꞌajuol, rumareꞌ jajaꞌ nucꞌut choch nojiel ri rusamaj. Y chakavach-apa cꞌo samaj más i-nem ri xtucꞌut choch. Y antok xtuꞌon ri samaj reꞌ, ixreꞌ can xquixchapataj. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y incheꞌl nuꞌon ri Rutataꞌ antok ncaꞌrupilisaj ri quiminakiꞌ y nuyaꞌ quicꞌaslien, quireꞌ jeꞌ nuꞌon ri Rucꞌajuol. Jajaꞌ nuyaꞌ jeꞌ quicꞌaslien ri choj chica nrajoꞌ nuya-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Rutataꞌ pa rukꞌaꞌ ri Rucꞌajuol ruyoꞌn chi ncaꞌruꞌon juzgar ri vinak y man jajaꞌ ta xtibꞌano. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chi quireꞌ niyoꞌx rukꞌij incheꞌl niyoꞌx rukꞌij ri Rutataꞌ. Ruma chica-na ri man xtiyoꞌn ta rukꞌij ri Rucꞌajuol, man nuyaꞌ ta jeꞌ rukꞌij ri Rutataꞌ, ri takayuon-pa richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ruma can ketzij, ketzij ri niꞌej chiva: Ri nicꞌaxan ri nutzij y nunimaj ri takayuon-pa vichin, cꞌo chic riqꞌuin ri cꞌaslien ri man xtiqꞌuis ta. Man xtiꞌa ta chupan ri lugar ri pacheꞌ cꞌo qꞌuiy sufrimiento, ruma ya xcolotaj choch ri camic, y xakꞌax-apa chupan ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y can ketzij, ketzij ri niꞌej chiva: Cꞌo jun kꞌij ri ayoꞌien y ja xalka yan, chi ri i-quiminak xticaꞌxaj ri rutzij ri Rucꞌajuol ri Dios. Y ri xticaꞌxaj, xtiquil quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ruma incheꞌl ri Rutataꞌ cꞌo rucꞌaslien, quireꞌ mismo rubꞌanun cha ri Rucꞌajuol chi cꞌo rucꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y ruyoꞌn jeꞌ autoridad cha chi ncaꞌruꞌon juzgar ri vinak, ruma jajaꞌ ri Xtak-pa chicaj chi xalax chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man quixchapataj ruma ri xinꞌej yan chiva, ruma xtalka ri kꞌij chi quinojiel quiminakiꞌ ri i-mukun xticaꞌxaj ri rutzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y ri otz quicꞌaslien xquicꞌuaj choch ri Dios, xcaꞌbꞌacꞌastaj-pa chi xticꞌujieꞌ quiqꞌuin ri cꞌaslien ri man niqꞌuis ta. Pero ri man otz ta quicꞌaslien xquicꞌuaj choch ri Dios, xcaꞌbꞌacꞌastaj-pa chi ncaꞌa chupan ri sufrimiento. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Inreꞌ man jun kax xtinꞌan-ka nuyuon; ruma inreꞌ ncaꞌnꞌan juzgar ri vinak, pero joꞌc incheꞌl ri niꞌeꞌx chuva. Y antok inreꞌ niꞌan juzgar, pa ruchojmil niꞌan-ve; ruma man ja ta ri nirayij inreꞌ ri niꞌan, xa ja ri nurayij ri Nataꞌ Dios ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Xa ta nuyuon inreꞌ niꞌej chi otz ri niꞌan, man ketzij ta ri niꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero cꞌo Jun ri otz nichꞌoꞌ chuvij. Y ri nuꞌej jajaꞌ chuvij inreꞌ, can ketzij ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ixreꞌ cꞌo xiꞌtak-el riqꞌuin ri Juan el Bautista chi xquicꞌutuj cha, y jajaꞌ xuꞌej-pa chiva ri ketzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero inreꞌ man ja ta ri nuꞌej jun ache chuvij ri xtinyaꞌ pa cuenta. Ri xinꞌej chiva, richin nquixcolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y ri Juan el Bautista incheꞌl jun antorcha ri nicꞌat y nuyaꞌ sakil. Y ixreꞌ xirayij y xixquicuot riqꞌuin ri sakil reꞌ, pero xa man qꞌuiy ta kꞌij ri xiꞌan quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Y ruma ri xutzijuoj ri Juan chuvij inreꞌ, can otz chi nquininimaj. Pero más nicꞌatzin chi nquininimaj, ruma ri samaj ri ncaꞌnꞌan chivach. Ja ri samaj reꞌ ri niꞌeꞌn chi ja ri Nataꞌ Dios ri takayuon-pa vichin. Y jajaꞌ ri bꞌiyuon-pa chuva chi niꞌan ri samaj reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y ja ri Nataꞌ Dios ri xtako-pa vichin otz chꞌovinak chuvij jeꞌ, pero ixreꞌ man jun bꞌay ivaxan cheꞌl rukul, ni man jun bꞌay itzꞌatuon roch. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri ruchꞌabꞌal jajaꞌ man acunak ta riqꞌuin ivánima, ruma ixreꞌ man ntinimaj ta ri Xtak-pa chi xalcꞌujieꞌ chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ixreꞌ titzꞌataꞌ otz ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can, ruma ivataꞌn chi chupan reꞌ ntivil ri cꞌaslien ri man niqꞌuis ta. Y ri ruchꞌabꞌal ri Dios xa chuvij inreꞌ nichꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero mesque quireꞌ, ixreꞌ man ntivajoꞌ ta nquixpa viqꞌuin, chi quireꞌ ntivil ri icꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Y nojiel ri xinꞌej yan chiva, man ruma ta nivajoꞌ chi ixreꞌ ntiyaꞌ nukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Inreꞌ vataꞌn otz ivach, rumareꞌ vataꞌn chi man ntivajoꞌ ta ri Dios pa tak ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ruma inreꞌ can pa rubꞌeꞌ ri Nataꞌ Dios in-patanak-ve y xa man nquininimaj ta. Pero xa ta cꞌo jun ri nipa pa rubꞌeꞌ jajaꞌ mismo, jareꞌ can chaꞌnin ntinimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ixreꞌ man nticanuj ta ikꞌij riqꞌuin ri ketzij Dios; xa chiꞌicajol-ka ixreꞌ mismo nticanuj-ka ikꞌij, rumareꞌ man ntiyaꞌ ta ivánima viqꞌuin inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man tiꞌan pensar chi inreꞌ ri xquibꞌano acusar ivichin choch ri Nataꞌ Dios. Ri xtibꞌano acusar ivichin choch ri Dios ja ri Moisés; ri choj-iqꞌuin iyoꞌn-ve ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ruma xa ta ixreꞌ ketzij ntinimaj ri i-rutzꞌibꞌan can ri Moisés, can ta nquininimaj inreꞌ, ruma ri i-rutzꞌibꞌan can jajaꞌ, can chuvij inreꞌ ncaꞌchꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y xa man ntinimaj ta ri i-rutzꞌibꞌan can ri Moisés, ¿cheꞌl xtinimaj ri chꞌabꞌal ri nucꞌamun-pa inreꞌ chiva? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Después nojiel reꞌ, ri Jesús xꞌa cꞌa jucꞌan chic ruchiꞌ ri mar Galilea; ri niꞌeꞌx jeꞌ Tiberias cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Can iqꞌuiy vinak ri i-bꞌanak chirij, ruma ri vinak reꞌ quitzꞌatuon chic ri milagros ri ncaꞌruꞌon quiqꞌuin ri ncaꞌyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús y ri ru-discípulos xaꞌjotie-el paroꞌ jun juyuꞌ; y jajaꞌ chireꞌ xtzꞌuye-ka quiqꞌuin ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri kꞌij reꞌ, xa cierca chic ri Pascua, ri jun quinamakꞌej ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y antok ri Jesús xtzuꞌn-apa y xutzꞌat chi can iqꞌuiy ri vinak ri xaꞌlka riqꞌuin, jajaꞌ xuꞌej cha ri Felipe ri jun ru-discípulo: ¿Pacheꞌ cꞌa xtakalakꞌo-pa simíta chi ncaꞌkatzuk ri vinak reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Quireꞌ xuꞌej ri Jesús cha ri Felipe, richin xuꞌon probar. Pero ri Jesús xa rataꞌn chic chica nuꞌon chi ncaꞌrutzuk ri vinak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y ri Felipe xuꞌej cha ri Jesús: Mesque xtakalokꞌ doscientos denarios simíta, man xcaꞌruꞌon ta, mesque joꞌc jutak bꞌaꞌ oc ri nakayaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Y jun chiquivach ri ru-discípulos, ri Andrés rubꞌeꞌ, ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Simón Pedro, xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","Vaveꞌ cꞌo jun alaꞌ cꞌo vuꞌuoꞌ simíta bꞌanun cha cebada y caꞌyeꞌ chꞌitak car rucꞌamun-pa, pero ¿chica xcaꞌruꞌon ri iqꞌuiy vinak reꞌ? xchaꞌ ri Andrés. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Entonces ri Jesús xuꞌej: Tiꞌej chica ri vinak chi caꞌtzꞌuye-ka. Y ri lugar reꞌ rax rubꞌanun ri kꞌayis, y ri vinak ri xaꞌtzꞌuyeꞌ, icꞌo laꞌk vuꞌuoꞌ mil achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ri Jesús xutzꞌom ri vuꞌuoꞌ simíta reꞌ y xuyaꞌ tiox bꞌaꞌ cha ri Dios, y xujach chica ri ru-discípulos, y ri discípulos xbꞌaquiyaꞌ chica ri vinak ri i-tzꞌuyul. Y quireꞌ mismo xuꞌon ri Jesús riqꞌuin ri caꞌyeꞌ car. Ri vinak xquicꞌux janeꞌ na (jaroꞌ na) ri xcajoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y antok i-viꞌnak chic jaꞌal ri vinak reꞌ, ri Jesús xuꞌej chica ri ru-discípulos: Timalo-pa nojiel ri jutak pir ri xuꞌon suobra, chi quireꞌ man choj ta cala niqꞌuis can, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri discípulos can xbꞌaquimalo-pa y xquinojsaj doce (cabꞌalajuj) chacach riqꞌuin ri jutak pir ri xmuol can ri xuꞌon suobra, antok i-viꞌnak chic ri vinak. Jareꞌ ri xmolotaj can cha ri vuꞌuoꞌ simíta bꞌanun cha cebada. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y antok ri vinak reꞌ quitzꞌatuon chic ri milagro ri xuꞌon ri Jesús, ijejeꞌ xquiꞌej: Can ketzij chi jajaꞌ ri profeta ri qꞌuiy yan tiempo ayoꞌien chi nipa choch-ulief, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús xunaꞌ chi ri vinak nicajoꞌ niquicꞌuaj chi niquiꞌan qui-rey cha, rumareꞌ xꞌa chic el paroꞌ ri juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y antok xcokꞌa-ka, ri ru-discípulos ri Jesús xaꞌa-ka chuchiꞌ ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ijejeꞌ xaꞌuoc chupan jun barco y xaꞌa paroꞌ ri mar chi ncaꞌbꞌaka pa tanamet Capernaum. Can kꞌakuꞌn chic y ri Jesús xa majaꞌ talka quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y jareꞌ antok xbꞌatiquir-pa jun nem cakꞌiekꞌ ri altíra ruchukꞌaꞌ paroꞌ ri mar; y rumareꞌ altíra nisiluon ri yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Antok ya i-bꞌanak jun vuꞌuoꞌ o vakiꞌ kilómetros paroꞌ ri mar, ri discípulos xquitzꞌat chi ri Jesús niꞌin paroꞌ ri mar y cierca chic ri barco cꞌo-ve, rumareꞌ ijejeꞌ altíra xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xuꞌej chica: Man tixiꞌij-iviꞌ. Xa inreꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Y antok ri discípulos xcaꞌxaj chi jajaꞌ, xaꞌquicuot xquicusaj-pa chupan ri barco. Y ja xaꞌbꞌaka ri lugar ri pacheꞌ ncaꞌbꞌaka-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chucaꞌn kꞌij, ri vinak ri icꞌo ri jucꞌan chic ruchiꞌ ri mar, can cataꞌn chi joꞌc ri ru-discípulos ri Jesús ri xaꞌa chupan ri jun oc barco ri cꞌo chireꞌ. Y ri Jesús man xꞌa ta quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ri kꞌij reꞌ, icꞌo barcos ri i-patanak pa tanamet Tiberias y xaꞌlka cierca ri pacheꞌ xquicꞌux-ve ri simíta ri vinak antok ri Ajaf Jesús xuyaꞌ tiox bꞌaꞌ cha ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y ri vinak reꞌ, ruma xquitzꞌat chi ri Jesús xa man cꞌo ta chic chireꞌ y ri ru-discípulos xa man icꞌo ta chic jeꞌ, ijejeꞌ xaꞌjotie-el chupan ri barcos y xaꞌa Capernaum chucunuxic ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Antok ri vinak reꞌ xbꞌaquilaꞌ ri Jesús ri jucꞌan chic ruchiꞌ ri mar, xquiꞌej cha: Rabí, ¿jampeꞌ xatalka vaveꞌ? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero ri Jesús xuꞌej chica ri vinak reꞌ: Can ketzij, ketzij ri niꞌej chiva, chi ixreꞌ nquinicanuj ruma xixtzuk y jaꞌal xinojsaj ipan, y man ruma ta xitzꞌat ri milagros. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Can quixsamaj, pero man richin ta ntichꞌec ri simíta ri xa niqꞌuis. Xa can quixsamaj chi ntichꞌec ri Simíta ri nuyaꞌ cꞌaslien ri man niqꞌuis ta. Y ri Xtak-pa chicaj chi xalax chiꞌicajol nuyaꞌ chiva ri Simíta reꞌ, ruma jajaꞌ ri Xtak-pa ruma ri Rutataꞌ Dios, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y ri vinak reꞌ xquiꞌej cha ri Jesús: ¿Chica ri nrajoꞌ ri Dios chi nakaꞌan? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y ri Jesús xuꞌej chica: Ri nrajoꞌ ri Dios chi ixreꞌ ntiꞌan, ja chi tinimaj ri Xtak-pa ruma jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y ri vinak xquiꞌej cha ri Jesús: ¿Chica señal naꞌan chakavach chi quireꞌ nakatzꞌat y ncatkanimaj? ¿Chica naꞌan? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ruma ri ojier tak kateꞌt-kamamaꞌ antok xaꞌcꞌujieꞌ chupan ri desierto, ja ri simíta ri xubꞌinaj maná ri xquicꞌux. Can incheꞌl ri nuꞌej ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can: Simíta ri patanak chicaj ri xuyaꞌ chica chi xquicꞌux. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y ri Jesús xuꞌej chica: Can ketzij, ketzij ri niꞌej chiva: Ri simíta ri xpa chicaj, man ja ta ri Moisés ri xyoꞌn. Ja ri Nataꞌ Dios ri xyoꞌn chica, y vacame nuyaꞌ chiva ri ketzij Simíta ri patanak chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ruma ri Simíta ri richin ri Dios, ja ri Jun ri patanak chicaj. Y jareꞌ ri cꞌamayuon-pa ri cꞌaslien chica ri vinak ri icꞌo choch-ulief, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Antok xcaꞌxaj quireꞌ ri vinak, xquiꞌej cha ri Jesús: Tuoya, siempre tayaꞌ ri Simíta reꞌ chika, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y ri Jesús xuꞌej chica: Inreꞌ ri Simíta ri niyoꞌn cꞌaslien. Ri nipa viqꞌuin, man xtunaꞌ ta chic viꞌjal. Y ri xquirunimaj, man xtichakej ta chic ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero incheꞌl ri nuꞌeꞌn chiva, mesque ixreꞌ xitzꞌat ri xinꞌan, man nquininimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Quinojiel ri ncaꞌruyaꞌ ri Nataꞌ chuva, ncaꞌpa viqꞌuin, y ri ncaꞌpa viqꞌuin, man xcaꞌntarariej ta el. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ruma inreꞌ ri xika-pa chicaj, man ja ta ri nivajoꞌ inreꞌ nalbꞌana-ka. Inreꞌ xika-pa chicaj chi nalbꞌana-ka ri nrajoꞌ ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri Nataꞌ Dios ri takayuon-pa vichin, nrajoꞌ chi quinojiel ri i-ruyoꞌn chuva, man jun ta chiquivach ijejeꞌ xtisach can, y pa ruqꞌuisbꞌal kꞌij ncaꞌncꞌasuoj-el chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ja-va ri nrajoꞌ ri takayuon-pa vichin: Chi quinojiel ri ncaꞌtzꞌato ri Rucꞌajuol y niquinimaj, xticꞌujieꞌ quiqꞌuin ri cꞌaslien ri man niqꞌuis ta; y ncaꞌncꞌasuoj-el chiquicajol ri quiminakiꞌ ri pa ruqꞌuisbꞌal kꞌij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pero ri vinak israelitas reꞌ xaꞌchꞌo-ka chirij ri Jesús, ruma jajaꞌ xuꞌej: Inreꞌ ri Simíta ri kajnak-pa chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y niquiꞌej: ¿Man ja ta reꞌ ri Jesús ri rucꞌajuol ri José cꞌa? Xa kataꞌn quivach ri rutie-rutataꞌ. ¿Karruma nuꞌej chika chi jajaꞌ kajnak-pa chicaj? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xuꞌej chica: Man quixchꞌoꞌ chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ni jun nicovin nipa viqꞌuin inreꞌ, xa man ta ri Nataꞌ Dios ri takayuon-pa vichin nucꞌam-pa viqꞌuin. Y inreꞌ xtincꞌasuoj chiquicajol ri quiminakiꞌ pa ruqꞌuisbꞌal kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ri tzꞌibꞌan can cuma ri profetas ojier can tiempo nuꞌej: Y quinojiel ri vinak xcaꞌtijox ruma ri Dios. Quireꞌ ri tzꞌibꞌan can. Y ri nraꞌxaj ri nuꞌej ri Nataꞌ Dios y nratamaj, can nipa viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero inreꞌ man niꞌej ta chi cꞌo jun vinak ri tzꞌatayuon richin ri Katataꞌ Dios, man quireꞌ ta. Joꞌc ri patanak chicaj riqꞌuin jajaꞌ ri tzꞌatayuon roch. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Can ketzij, ketzij ri niꞌej chiva: Ri niniman vichin, can cꞌo riqꞌuin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Inreꞌ ri Simíta ri niyoꞌn cꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri ivateꞌt-imamaꞌ can, ja ri maná ri xquicꞌux ri pa desierto, y xaꞌcon. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ri ketzij Simíta ri kajnak-pa chicaj, nuꞌon chica ri ncaꞌcꞌuxu richin chi man xcaꞌcon ta richin xa jun tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Inreꞌ ri Simíta ri niyoꞌn cꞌaslien ri xka-pa chicaj. Ri xcaꞌcꞌuxu cꞌa ri Simíta reꞌ, xcaꞌcꞌasieꞌ richin nojiel tiempo. Ri Simíta ri xtinyaꞌ inreꞌ, ja ri nu-cuerpo ri xtinyaꞌ chi nucꞌam-pa cꞌaslien chica ri vinak ri icꞌo choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y antok ri vinak israelitas reꞌ xcaꞌxaj ri xuꞌej ri Jesús, xquitzꞌom-ka-quiꞌ chi tzij chiquivach, y niquiꞌej cꞌa: ¿Chica modo reꞌ chi jajaꞌ nuyaꞌ ri ru-cuerpo chika chi nakatej? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ri Jesús xuꞌej chica: Can ketzij, ketzij ri niꞌej chiva: Xa man ntitej ta ri ru-cuerpo y man ntikun ta jeꞌ ri ruquiqꞌuiel ri Xtak-pa chicaj chi xalax chiꞌicajol, man xticꞌujieꞌ ta iviqꞌuin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri xtiquitej ri nu-cuerpo y xtiquikun jeꞌ ri nuquiqꞌuiel, cꞌo quiqꞌuin ri cꞌaslien ri man niqꞌuis ta. Y inreꞌ xtinꞌan chica chi ncaꞌcꞌastaj-el chiquicajol ri quiminakiꞌ pa ruqꞌuisbꞌal kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ruma ri nu-cuerpo inreꞌ jareꞌ ri ketzij Simíta y ri nuquiqꞌuiel jareꞌ ri ketzij Yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri niquicꞌux ri nu-cuerpo y niquikun jeꞌ ri nuquiqꞌuiel, joꞌc jun xtakaꞌan quiqꞌuin. Ijejeꞌ xcaꞌcꞌujieꞌ viqꞌuin inreꞌ y inreꞌ quiqꞌuin ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ruma ja ri Nataꞌ ri takayuon-pa vichin ri cꞌas richin nojiel tiempo, inreꞌ jeꞌ incꞌas richin nojiel tiempo. Y ri nquirucꞌux inreꞌ, can xticꞌasieꞌ vuma inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri ketzij Simíta, ri kajnak-pa chicaj, man junan ta riqꞌuin ri maná ri xquicꞌux ri ivateꞌt-imamaꞌ, ruma ijejeꞌ xa xaꞌcon. Pero ri niquicꞌux ri ketzij Simíta ri kajnak-pa chicaj, xticꞌujieꞌ quiqꞌuin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jareꞌ ri xuꞌej ri Jesús chica ri vinak israelitas ri quimaluon-quiꞌ chupan ri sinagoga, chireꞌ pa tanamet Capernaum. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Y antok ri ru-discípulos ri Jesús xcaꞌxaj ri xuꞌej, iqꞌuiy chiquivach ijejeꞌ xquiꞌej: Altíra cuesta ri xuꞌej. ¿Chica xticꞌaxan richin? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Y ri Jesús xa rataꞌn ri chica xquiꞌej-ka ri ru-discípulos, mareꞌ xuꞌej chica: ¿Man xka ta chivach ri xinꞌej? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Y chica xtiꞌej xa ta ntitzꞌat ri Xtak-pa chicaj chi xalax chiꞌicajol chi nitzalaj-el chila ri pacheꞌ patanak-ve? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja ri Espíritu ri niyoꞌn cꞌaslien, ri i-cuerpo xa manak nuyaꞌ. Y ri Espíritu ri niyoꞌn ri ketzij cꞌaslien, ja ri chꞌabꞌal ri i-nuꞌeꞌn chic chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero iqꞌuiy chivach ixreꞌ ri man nquinquinimaj ta, xchaꞌ ri Jesús. Jajaꞌ quireꞌ xuꞌej ruma rataꞌn-ve-pa chica vinak ri man xtiquinimaj ta, y ri chica xtijacho richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y ri Jesús xuꞌej: Ruma cꞌa reꞌ nuꞌeꞌn chiva, chi man jun ruyuon xtipa viqꞌuin chi nquirunimaj, xa man ta ja ri Nataꞌ Dios ri xticꞌamo-pa richin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ruma quireꞌ xuꞌej ri Jesús, iqꞌuiy chiquivach ri ru-discípulos xa xaꞌtzalaj can chiquij y man chic xaꞌa ta chirij. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y ri Jesús xuꞌej chica ri doce (cabꞌalajuj) discípulos: ¿Ixreꞌ jeꞌ ntivajoꞌ nquixꞌa? ");
INSERT INTO cakSNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y ri Simón Pedro xuꞌej cha ri Jesús: Ajaf, ¿choj-iqꞌuin nkuꞌa-ve? Ruma joꞌc ri achꞌabꞌal atreꞌ nuyaꞌ cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ojreꞌ kaniman y kataꞌn chi atreꞌ ri Cristo, ri Rucꞌajuol ri cꞌaslic Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y ri Jesús xuꞌej: Inreꞌ ri xichoꞌn ivichin ixreꞌ ri ix doce (cabꞌalajuj), pero jun chivach ixreꞌ xuoc ri diablo riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Antok ri Jesús xuꞌej quireꞌ, chirij ri Judas Iscariote xchꞌo-ve; ri Judas ri rucꞌajuol ri Simón. Ri Jesús xunataj reꞌ, ruma jareꞌ ri xtijacho richin. Y jajaꞌ jun chiquivach ri doce (cabꞌalajuj) discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Después nojiel reꞌ, ri Jesús xꞌa pa tak tanamet ri icꞌo Galilea. Man xrajoꞌ ta chic nakꞌax pa tak tanamet ri icꞌo Judea, ruma ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas niquicanuj manera chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ri tiempo reꞌ, xa cierca chic ri quinamakꞌej ri israelitas ri niꞌeꞌx tabernáculos cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Y ri ruchakꞌ ri Jesús xquiꞌej cha: Catiel vaveꞌ Galilea y caꞌin cꞌa Judea, chi quireꞌ ri a-discípulos ri icꞌo chireꞌ, niquitzꞌat ri milagros ri naꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ruma man jun ri nrajoꞌ nucꞌut-riꞌ, nuꞌon kax pan aval. Can nicꞌatzin chi tacꞌutu-aviꞌ chiquivach ri vinak, xaꞌchaꞌ ri ruchakꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Mesque ijejeꞌ i-ruchakꞌ ri Jesús, pero man niquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y ri Jesús xuꞌej chica ri ruchakꞌ: Ixreꞌ chica-na kꞌij otz nquixbꞌaka chupan ri namakꞌej. Pero inreꞌ man quireꞌ ta. Inreꞌ majaꞌ talka ri nu-huora. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ixreꞌ man itziel ta nquixtzꞌiet cuma ri vinak ri man quiniman ta ri Dios. Pero inreꞌ itziel nquitzꞌiet, ruma inreꞌ niꞌej ri itziel tak kax ri ncaꞌquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Quixꞌin ixreꞌ chupan ri namakꞌej; inreꞌ cꞌa majaꞌ quiꞌa-el chupan ri namakꞌej reꞌ. Ri nu-huora majaꞌ talka, xchaꞌ ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ chica ri ruchakꞌ, jajaꞌ xcꞌujieꞌ can chireꞌ Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y antok i-bꞌanak chic ri ruchakꞌ chupan ri namakꞌej, cꞌajareꞌ xꞌa jajaꞌ. Pero xa man xucꞌut ta riꞌ antok xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Y chupan ri namakꞌej, ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, ri itziel niquitzꞌat ri Jesús, niquicanuj y niquiꞌej: ¿Pacheꞌ cꞌo-ve ri jun ache reꞌ? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicajol ri vinak chupan ri namakꞌej reꞌ, qꞌuiy niquiꞌej chirij ri Jesús. Icꞌo ncaꞌeꞌn: Ri Jesús jun utzulaj ache. Icꞌo ncaꞌeꞌn: Ri Jesús man otz ta, jajaꞌ ncaꞌruꞌon engañar ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero man jun chiquivach ri vinak ri ncaꞌeꞌn quireꞌ nrajoꞌ nuꞌej abiertamente, ruma niquixiꞌij-quiꞌ chiquivach ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y antok xnacꞌajar ri namakꞌej reꞌ, ri Jesús xbꞌaka pa templo. Jajaꞌ nucꞌut ri ruchꞌabꞌal ri Dios chiquivach ri vinak ri quimaluon-quiꞌ chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas can xaꞌchapataj, rumareꞌ niquiꞌej chirij ri Jesús: ¿Cheꞌl chi ri ache reꞌ qꞌuiy rataꞌn chirij ri ruchꞌabꞌal ri Dios y xa man jun bꞌay xkatzꞌat chi xutijuoj-riꞌ? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero ri Jesús xuꞌej: Ri nicꞌut inreꞌ, man vichin ta inreꞌ, xa richin ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y ri nrajoꞌ nuꞌon ri nrajoꞌ ri Dios, xtiratamaj chi ri nicꞌut inreꞌ xa riqꞌuin ri Dios patanak-ve o xa nuyuon niꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jun vinak ri ruyuon nichꞌo-ka chirij jajaꞌ mismo, nrajoꞌ chi niyoꞌx rukꞌij cuma ri vinak. Pero inreꞌ nivajoꞌ chi ixreꞌ ntiyaꞌ rukꞌij ri Dios ri takayuon-pa vichin. Y jareꞌ nibꞌano chi nikꞌalajin chi inreꞌ ja ri ketzij niꞌan y man jun bꞌay niꞌan ri man otz ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Ri Moisés xuyaꞌ ri ley pan ikꞌaꞌ, pero man ntiꞌan ta ri chica nuꞌej ri ley reꞌ. Ruma ixreꞌ nticanuj manera chi nquiniquimisaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y ri vinak xquiꞌej: Xa cꞌo itziel espíritu aviqꞌuin. ¿Chica nrajoꞌ niquimisan avichin? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xuꞌej chica: Ixreꞌ xixchapataj antok xitzꞌat chi inreꞌ chupan jun kꞌij richin uxlanien xinꞌan jun milagro. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero chupan ri ru-ley ri Moisés nuꞌej chi tiꞌan ri circuncisión. Pero man ja ta ri Moisés ri xtzꞌucu-pa ri circuncisión, xa ja ri kateꞌt-kamamaꞌ ri xaꞌtzꞌucu-pa. Y rumareꞌ ixreꞌ vacame, mesque chupan jun kꞌij richin uxlanien, can ntiꞌan ri circuncisión cha jun xuluꞌ alaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ixreꞌ ntivajoꞌ ntiꞌan ri nuꞌej ri ley ri ruyoꞌn can ri Moisés, y rumareꞌ, mesque chupan jun kꞌij richin uxlanien, ixreꞌ can ntiꞌan ri circuncisión. ¿Y karruma xpa ivoyoval chuva inreꞌ ruma xinꞌan sanar jun ache chupan jun kꞌij richin uxlanien? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man tiꞌej chi man otz ta ri xinꞌan, joꞌc ruma quireꞌ ntitzꞌat ixreꞌ. Ixreꞌ titzꞌataꞌ otz ri xinꞌan, cꞌajareꞌ tiꞌej xa otz o man otz ta, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y icꞌo chiquivach ri vinak aj-chireꞌ pa tanamet Jerusalén ri niquiꞌej: ¿Man ja ta came la ri nicanux chi niquimisas? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xa man ravan ta riꞌ. ¡Titzꞌataꞌ! Ja nichꞌoꞌ chiquivach ri vinak y man jun kax niꞌeꞌx cha. ¿O xa ya xquinimaj ri achiꞌaꞌ ri cꞌo quikꞌij chikacajol chi jajaꞌ ri Cristo? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero kataꞌn pacheꞌ patanak-ve jajaꞌ. Y antok xtipa ri Cristo, man jun xtinaꞌien pacheꞌ xtipa-ve, ncaꞌchaꞌ ri vinak aj-Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y ri Jesús nichꞌoꞌ chiquivach ri vinak ri chireꞌ pa templo. Y cof xchꞌoꞌ y xuꞌej: Ixreꞌ ivataꞌn noch y ivataꞌn jeꞌ pacheꞌ xipa-ve. Pero ri takayuon-pa vichin man ivataꞌn ta roch, y jajaꞌ can ketzij. Man nuyuon ta inreꞌ xinꞌan chi xipa choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Inreꞌ vataꞌn roch ri man ivataꞌn ta roch ixreꞌ, ruma riqꞌuin jajaꞌ in-patanak-ve; y jajaꞌ ri takayuon-pa vichin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y icꞌo nicꞌaj xcajoꞌ ta xquitzꞌom ri Jesús, pero man jun xtzꞌamo ruma ri ru-huora majaꞌ talka. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Iqꞌuiy chiquivach ri vinak xquinimaj ri Jesús chupan ri kꞌij reꞌ y niquiꞌej: Antok xtipa ri Cristo, ¿xtuꞌon más milagros que choch va ache va? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y ri achiꞌaꞌ fariseos xcaꞌxaj ri niquiꞌej ri vinak chirij ri Jesús. Rumareꞌ ri achiꞌaꞌ fariseos reꞌ y ri principales sacerdotes, xaꞌquitak-el ri alguaciles chi niquitzꞌamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Entonces ri Jesús xuꞌej: Cꞌa cꞌo jubꞌaꞌ tiempo ri nquicꞌujieꞌ iviqꞌuin. Después xquitzalaj riqꞌuin ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ixreꞌ xquinicanuj y man xquinivil ta chic; ruma ri lugar pacheꞌ xquibꞌacꞌujie-ve inreꞌ, ixreꞌ man xquixtiquir ta xquixbꞌaka, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas niquiꞌej chiquivach: ¿Pacheꞌ came xtiꞌa-ve ri Jesús chi man xtikil ta? ¿Niꞌa came nicꞌaj chic lugares quiqꞌuin ri israelitas ri icꞌo chiquicajol ri man israelitas ta, o ncaꞌbꞌarutijuoj came ri man israelitas ta? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Chica nrajoꞌ nuꞌej ri xuꞌej: Ixreꞌ xquinicanuj y man xquinivil ta chic; ruma ri lugar pacheꞌ xquibꞌacꞌujie-ve inreꞌ, ixreꞌ man xquixtiquir ta xquixbꞌaka? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chupan ri ruqꞌuisbꞌal y namalaj kꞌij richin ri jun namakꞌej reꞌ, ri Jesús xpiꞌieꞌ y cof xchꞌoꞌ: Xa cꞌo jun ri chakeꞌj ruchiꞌ, tipa viqꞌuin inreꞌ y tukumuꞌ ruyaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri nquirunimaj, can nuꞌon incheꞌl nuꞌej chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. Can xtiꞌin ri Yaꞌ ri nuyaꞌ cꞌaslien riqꞌuin ránima incheꞌl nuꞌon ri río, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Yaꞌ ri xuꞌej ri Jesús, ja ri Espíritu Santo; ruma jareꞌ ri xtiquiꞌan recibir ri vinak ri ncaꞌniman richin ri Jesús. Y ri kꞌij reꞌ cꞌa majaꞌ tika-pa ri Espíritu Santo, ruma cꞌa majaꞌ titzalaj-el ri Jesús chicaj chi nikꞌalajin chi jajaꞌ can cꞌo-ve rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y icꞌo chiquivach ri vinak, antok xcaꞌxaj ri tzij ri xaꞌruꞌej ri Jesús, xquiꞌej: Can ketzij chi jajaꞌ jareꞌ ri profeta. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y icꞌo jeꞌ niquiꞌej: Jajaꞌ jareꞌ ri Cristo. Pero nicꞌaj chic niquiꞌej: ¿Galilea came nipa-ve ri Cristo? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","¿Man nuꞌej ta came ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can, chi ri Cristo rumáma can ri rey David, y chi chireꞌ Belén, ri tanamet pacheꞌ xalax-ve ri David, chireꞌ nipa-ve ri Cristo? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ri vinak xa man junan ta xquiꞌej-ka chirij ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y icꞌo nicꞌaj chic chiquivach ri vinak, can xcajoꞌ ta xquitzꞌom-el ri Jesús, pero xa man jun xtzꞌamo. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Antok ri alguaciles, ri i-takuon-el cuma ri principales sacerdotes y cuma ri achiꞌaꞌ fariseos, xaꞌtzalaj-pa; xcꞌutux cꞌa chica: ¿Karruma man xitzꞌom ta pa ri Jesús? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Y ri achiꞌaꞌ xquiꞌej: ¡Ruma man jun chic ache nichꞌoꞌ incheꞌl nichꞌoꞌ jajaꞌ! xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Y ri achiꞌaꞌ fariseos xquiꞌej chica: ¿Ixreꞌ jeꞌ xixꞌan engañar? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Acaso icꞌo chiquivach ri autoridades y chiquivach ri achiꞌaꞌ fariseos quiniman ri nuꞌej ri Jesús? ");
INSERT INTO cakSNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ja ri vinak ri man cataꞌn ta ri ru-ley ri Moisés, xa jareꞌ ri niquinimaj ri Jesús. Can xtika ri castigo pa quiveꞌ ri vinak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero ri Nicodemo, jun chiquivach ri achiꞌaꞌ fariseos, ri xbꞌaka chakꞌaꞌ riqꞌuin ri Jesús, xuꞌej chica ri nicꞌaj chic achiꞌaꞌ: ");
INSERT INTO cakSNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Chupan ri ka-ley nuꞌej chi manak cheꞌl nakaꞌan juzgar jun ache, xa naꞌay man kaxan ta ri chica rubꞌanun. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y ijejeꞌ xquiꞌej cha ri Nicodemo: ¿At aj-Galilea atreꞌ cꞌa? Tatzꞌataꞌ otz ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. Can kꞌalaj chi Galilea man jun cꞌa profeta alanak-pa, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ri achiꞌaꞌ ri quimaluon-quiꞌ, cada uno xaꞌa chicachuoch, ");
INSERT INTO cakSNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","y ri Jesús xꞌa-el paroꞌ ri juyuꞌ Olivos. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y antok xsakar-pa, jajaꞌ xbꞌaka chic pa templo y iqꞌuiy vinak xaꞌbꞌaka riqꞌuin. Y jajaꞌ tzꞌuyul nutzijuoj ri ruchꞌabꞌal ri Dios chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y ri achiꞌaꞌ fariseos y ri achiꞌaꞌ escribas xaꞌbꞌaka, quicꞌamun-pa jun ixok ri xquil nuꞌon achpay. Y xbꞌaquiyaꞌ pa nicꞌaj, pacheꞌ cꞌo-ve ri Jesús, ");
INSERT INTO cakSNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y xquiꞌej cha: Maestro, ojreꞌ xkil ri jun ixok va nuꞌon achpay riqꞌuin jun ache. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Y chupan ri ley ri ruyoꞌn can ri Moisés, nuꞌej chi ri ncaꞌbꞌano quireꞌ, caꞌquimisas cha abꞌaj. Atreꞌ, ¿chica naꞌej chika? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri achiꞌaꞌ reꞌ quireꞌ xquiꞌej richin niquiꞌan tentar ri Jesús; chi quireꞌ niquiꞌan acusar. Pero ri Jesús xa xluquie-ka, y xtzꞌibꞌan-ka pan ulief cha ri ruve-rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y ruma ri achiꞌaꞌ reꞌ man ncaꞌtanieꞌ ta ka chi niquicꞌutuj-apa cha ri Jesús xa niquimisas ri ixok o manak, rumareꞌ jajaꞌ xupilisaj ri rujaluon y xuꞌej chica: Xa cꞌo jun chivach ixreꞌ ri man jun ru-pecado rubꞌanun, tucꞌakaꞌ ri naꞌay abꞌaj chirij ri ixok, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y xluquieꞌ chic ka jun bꞌay pan ulief y xuꞌon seguir nitzꞌibꞌan cha ri ruve-rukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Y antok ijejeꞌ xcaꞌxaj ri xuꞌej ri Jesús, xquina-ka-quiꞌ chi ijejeꞌ jeꞌ cꞌo qui-pecados, rumareꞌ chijujun-chijujun xaꞌa; naꞌay xaꞌa ri i-mámix, y después xaꞌa ri más cꞌa acꞌolaꞌ. Y joꞌc chic ri ixok ri xbꞌaquiyaꞌ pa nicꞌaj xcꞌujieꞌ can choch ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y antok ri Jesús xupilisaj chic ri rujaluon, xutzꞌat chi joꞌc chic ri ixok paꞌl can chireꞌ. Y jajaꞌ xucꞌutuj cha: ¿Pacheꞌ icꞌo-ve ri ncaꞌbꞌano acusar avichin? ¿Man jun xcꞌujieꞌ can chi ncaruquimisaj? xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y ri ixok xuꞌej: Tuoya, man jun. Y ri Jesús xuꞌej cha: Ni inreꞌ xtinꞌej chi ncaquimisas. Vacame caꞌin y man chic taꞌan pecado. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Antok ri Jesús xchꞌoꞌ chic jun bꞌay chiquivach ri vinak, xuꞌej: Inreꞌ ri Sakil richin nojiel ri roch-ulief. Ri niꞌa chuvij, can xtiril ri sakil richin ri rucꞌaslien viqꞌuin. Y man chic xtiꞌin ta pa kꞌakuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Pero ri achiꞌaꞌ fariseos ri icꞌo chireꞌ xquiꞌej-apa cha ri Jesús: Ojreꞌ man nakanimaj ta chi ketzij ri naꞌej chavij, ruma xa ayuon atreꞌ ncaꞌeꞌn-ka otz chavij. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ fariseos: Mesque inreꞌ mismo nquichꞌo-ka otz chuvij, can ketzij ri niꞌej chuvij. Ruma inreꞌ vataꞌn ri pacheꞌ in-patanak-ve, y chireꞌ xquitzalaj-ve. Ixreꞌ man ivataꞌn ta pacheꞌ in-patanak-ve, ni man ivataꞌn ta jeꞌ pacheꞌ xquiꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ixreꞌ can ntiꞌan juzgar riqꞌuin ri noꞌj richin ri roch-ulief. Pero inreꞌ man quireꞌ ta niꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y xa inreꞌ niꞌan juzgar, can pa ruchojmil niꞌan-ve; ruma man nuyuon ta inreꞌ, xa junan nakaꞌan juzgar riqꞌuin ri Nataꞌ ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupan ri i-ley ixreꞌ, ri tzꞌibꞌan can nuꞌej chi antok icꞌo icaꞌyeꞌ ri junan niquiꞌej, can kꞌalaj chi ketzij ri niquiꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri niꞌej-ka chuvij inreꞌ can ketzij, y ri Nataꞌ ri takayuon-pa vichin, can ketzij ri nuꞌej chuvij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri achiꞌaꞌ fariseos xquiꞌej cha ri Jesús: ¿Pacheꞌ cꞌo-ve ri Atataꞌ? xaꞌchaꞌ cha. Y jajaꞌ xuꞌej: Ixreꞌ man ivataꞌn ta roch ri Nataꞌ, ruma man ivataꞌn ta noch inreꞌ. Xa ta ivataꞌn noch inreꞌ, can ivataꞌn ta jeꞌ roch ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y ja tzij reꞌ ri xuꞌej ri Jesús chiquivach ri vinak ri quimaluon-quiꞌ ri pacheꞌ niyoꞌx can ri ofrenda ri chireꞌ pa templo. Pero mesque quireꞌ xuꞌej, man jun xpa chi xutzꞌom ta, ruma ri ru-huora majaꞌ talka. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y jun bꞌay chic ri Jesús xuꞌej chica: Inreꞌ nquiꞌa y ixreꞌ xquinicanuj, pero man xquinivil ta. Xa chupan ri i-pecado xquixcon-ve. Y ri pacheꞌ nquiꞌa-ve inreꞌ, ixreꞌ man nquixtiquir ta nquixꞌa, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y ruma cꞌa reꞌ ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej-ka chiquivach: ¿Xtuquimisaj came riꞌ ruyuon ri Jesús? Ruma xuꞌej: Ri pacheꞌ xquiꞌa-ve inreꞌ, ixreꞌ man nquixtiquir ta nquixꞌa, xaꞌchaꞌ ri achiꞌaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero ri Jesús xuꞌej chica: Ixreꞌ ix aj-vaveꞌ y inreꞌ in aj-chicaj. Ixreꞌ ix richin ri roch-ulief y inreꞌ man in richin ta ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y rumareꞌ xinꞌej chiva chi chupan ri i-pecados nquixcon-ve. Y xa man ntinimaj ta in chica inreꞌ, can xquixcon-ve chupan ri i-pecados, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Y ri achiꞌaꞌ reꞌ xquiꞌej chic cha ri Jesús: ¿Y at chica atreꞌ cꞌa? Y ri Jesús xuꞌej chica: Inreꞌ, xa-jan antok nutzꞌamuon-pa tzij iviqꞌuin, can nuꞌeꞌn-pa chiva in chica inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Inreꞌ can cꞌo cꞌa qꞌuiy kax ri niꞌej chivij, y nquixꞌan juzgar. Pero ri niꞌej chiva ixreꞌ y chica quinojiel ri vinak ri icꞌo choch-ulief, ja ri vaxan-pa riqꞌuin ri takayuon-pa vichin, jareꞌ ri niꞌej, y jajaꞌ can ketzij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero ijejeꞌ man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) chi ri Jesús xa chirij ri Rutataꞌ xchꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xuꞌej chic: Ri kꞌij antok xtijotobꞌaꞌ choch ri cruz, ri Xtak-pa chicaj chi xalax chiꞌicajol, cꞌajareꞌ antok xtinaꞌiej in chica inreꞌ. Y xtinaꞌiej chi nojiel ri niꞌan inreꞌ, xa man nuyuon ta niꞌan, xa incheꞌl ri ruꞌeꞌn-pa ri Nataꞌ chuva inreꞌ, can quireꞌ jeꞌ niꞌej inreꞌ chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ri Nataꞌ ri takayuon-pa vichin, can cꞌo viqꞌuin. Man nquiruyaꞌ ta can nuyuon, ruma inreꞌ niꞌan ri nika choch jajaꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y ruma ri tzij ri xaꞌruꞌej ri Jesús, iqꞌuiy ri xaꞌniman richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Y xuꞌej cꞌa ri Jesús chica ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas ri xaꞌniman richin: Xa ixreꞌ ntiꞌan siempre ri xinꞌej, can xquixuoc ketzij nu-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xtivatamaj chica ri ketzij, y ri ketzij xtuꞌon libres chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y ri vinak reꞌ xquiꞌej: Ojreꞌ oj rumáma can ri Abraham, y rumareꞌ man jun bꞌay oj-acunak esclavos. ¿Karruma naꞌej chika chi xkujiel libres? ");
INSERT INTO cakSNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xuꞌej chica: Can ketzij, ketzij ri niꞌej chiva, chi quinojiel vinak ri niquiꞌan pecado, can iru-esclavo ri pecado. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y xa jun vinak ru-esclavo ri pecado, man xticꞌujieꞌ ta riqꞌuin ri Dios. Pero ri jun ri ralcꞌual ri Dios, can xticꞌujieꞌ riqꞌuin richin nojiel tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Rumareꞌ, xa ri Rucꞌajuol ri Dios nuꞌon chiva chi ix libres, can ketzij chi ix libres. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Inreꞌ vataꞌn chi ix rumáma can ri Abraham, pero ixreꞌ xa nticanuj chica manera ntiꞌan chi nquiniquimisaj. Reꞌ nucꞌut chi ixreꞌ man iyoꞌn ta lugar cha ri nuchꞌabꞌal chi acunak ta riqꞌuin ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nojiel ri nitzijuoj inreꞌ, can ja ri Nataꞌ cꞌutuyun-pa chinoch. Quireꞌ jeꞌ ixreꞌ, nojiel ri ntiꞌan, riqꞌuin ri itataꞌ ivaxan-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y ijejeꞌ xquiꞌej cha ri Jesús: Ja ri Abraham ri katataꞌ ojreꞌ, xaꞌchaꞌ. Y ri Jesús xuꞌej chica: Xa ta ix rumáma can ri Abraham, can ta ntiꞌan ri otz ri incheꞌl xuꞌon jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Pero ixreꞌ xa nticanuj chica manera ntiꞌan chi nquiniquimisaj inreꞌ ri nitzijuoj ri ketzij chiva; ri ketzij ri vaxan-pa riqꞌuin ri Dios. Ri Abraham man xuꞌon ta incheꞌl ri ntiꞌan ixreꞌ vacame. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ixreꞌ xa ja ri nuꞌon ri itataꞌ, xa jareꞌ ri ntiꞌan, xchaꞌ ri Jesús chica. Y ijejeꞌ xquiꞌej cha: Ojreꞌ kataꞌn roch ri Katataꞌ. Y joꞌc Jun ri Katataꞌ, y reꞌ ja ri Dios, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ri Jesús xuꞌej chica ri vinak reꞌ: Xa ta ja ri Dios ri Itataꞌ, can ta nquinivajoꞌ; ruma inreꞌ riqꞌuin ri Dios in-patanak-ve. Jajaꞌ ri takayuon-pa vichin y man nuyuon ta inreꞌ xipa choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Karruma ixreꞌ man niꞌka ta pan iveꞌ (man ntiꞌan ta entender) ri niꞌej chiva? Ruma man ntivajoꞌ ta ntivaxaj ri nutzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri itataꞌ ixreꞌ ja ri diablo y can ix richin jajaꞌ; y ja ri nika choch jajaꞌ, jareꞌ ri ntivajoꞌ ntiꞌan. Ri diablo can pa rutzꞌucbꞌal-pa niquimisan. Man xcꞌujieꞌ ta chupan ri ketzij, ruma man jun ketzij cꞌo riqꞌuin. Xa tzꞌakoy-tzij. Can quitataꞌ quinojiel ri i-tzꞌakoy-tzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y inreꞌ ruma niꞌej ri ketzij chiva, ixreꞌ man nquininimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Chica chivach ixreꞌ niꞌeꞌn-pa chuva chica pecado i-nubꞌanun? Y xa joꞌc ri ketzij ri niꞌej, ¿karruma man nquininimaj ta? ");
INSERT INTO cakSNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ruma ri richin ri Dios, nraꞌxaj ri nuꞌej ri ruchꞌabꞌal. Pero ixreꞌ man quireꞌ ta ntiꞌan, ruma man ix richin ta ri Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: Can ketzij ri kaꞌeꞌn chavij, chi atreꞌ xa at jun vinak ri at aj-Samaria y cꞌo itziel espíritu aviqꞌuin, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Inreꞌ man jun itziel espíritu cꞌo viqꞌuin. Inreꞌ can ja ri Nataꞌ ri niyaꞌ rukꞌij, pero chivach ixreꞌ xa man quireꞌ ta. Ixreꞌ xa itziel nquixchꞌoꞌ chuvij. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Inreꞌ man nicanuj ta chi ixreꞌ ntiyaꞌ nukꞌij, pero cꞌo Jun ri nrajoꞌ chi quinojiel ta vinak niquiyaꞌ nukꞌij. Y jajaꞌ jeꞌ xtibꞌano juzgar quichin ri man xtiquiꞌan ta quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can ketzij, ketzij ri niꞌej chiva, chi ri nunimaj ri nutzij, man xticon ta, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: Vacame kataꞌn chi cꞌo itziel espíritu aviqꞌuin; ruma naꞌej chi chica ri ncaꞌniman ri achꞌabꞌal, man xcaꞌcon ta. Ri kamamaꞌ Abraham y ri profetas ojier can tiempo xaꞌcon. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Cꞌo came más avakalien atreꞌ choch ri kamamaꞌ Abraham? ¡Jajaꞌ xcon; quireꞌ jeꞌ ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo xaꞌcon! ¿Chica choj-iqꞌuin navajoꞌ naꞌan at junan? ");
INSERT INTO cakSNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y ri Jesús xuꞌej: Xa nuyuon inreꞌ niya-ka nukꞌij, man jun nicꞌatzin-ve. Pero inreꞌ, ja ri Nataꞌ niyoꞌn nukꞌij. Ri Nataꞌ jareꞌ ri ntiꞌej I-Dios cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y mesque ixreꞌ quireꞌ ntiꞌej cha, man ivataꞌn ta roch. Pero inreꞌ vataꞌn roch. Y xa niꞌej chi man vataꞌn ta roch ri Dios, nquinuoc jun tzꞌakoy-tzij incheꞌl ixreꞌ. Pero inreꞌ vataꞌn roch y niꞌan ri nuꞌej ri ruchꞌabꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham ri ojier katataꞌ can xquicuot ránima, ruma rataꞌn chi xtutzꞌat ri tiempo antok inreꞌ xquipa choch-ulief. Y jajaꞌ xutzꞌat, y xquicuot ránima rumareꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Jareꞌ antok ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: Atreꞌ cꞌa majaꞌ cincuenta ajunaꞌ y naꞌej chi atzꞌatuon ri kamamaꞌ Abraham. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Can ketzij, ketzij ri niꞌej chiva: Inreꞌ can incꞌo-ve antes que choch ri Abraham, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y ri achiꞌaꞌ reꞌ xaꞌbꞌaquisicꞌa-pa abꞌaj chi niquiqꞌuiak chirij. Pero ri Jesús xravaj-riꞌ chiquivach, y chiquicajol ri vinak xakꞌax-ve y xiel-pa ri pa templo, y xꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Y antok ri Jesús nakꞌax, xutzꞌat jun ache muoy; ri ache reꞌ muoy xa-jan antok xalax. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri ru-discípulos xquicꞌutuj cha ri Jesús: Rabí, ¿chica xbꞌano ri pecado chi quireꞌ xalax ri ache reꞌ? ¿Ja ri rutie-rutataꞌ o jajaꞌ? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero ri Jesús xuꞌej: Ni jajaꞌ ni ri rutie-rutataꞌ xuꞌon pecado chi quireꞌ xalax. Jajaꞌ cala xalax, chi quireꞌ xtikꞌalajin ri samaj ri xtuꞌon ri Dios riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Inreꞌ nicꞌatzin chi niꞌan ri rusamaj ri takayuon-pa vichin mientras cꞌa pakꞌij, ruma antok ntuoc-pa ri akꞌaꞌ, man jun chic nicovin nisamaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pero mientras inreꞌ incꞌo choch-ulief, inreꞌ ri nquiyoꞌn sakil cha nojiel ri roch-ulief, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Antok ri Jesús ruꞌeꞌn chic ri tzij reꞌ, xchubꞌan cꞌa pan ulief, xuꞌon jubꞌaꞌ chꞌabꞌak cha ri ruchubꞌ, xubꞌach pa roch ri ache muoy, ");
INSERT INTO cakSNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","y xuꞌej cha: Vacame caꞌin y achꞌajaꞌ ri anakꞌavach chupan ri estanque ri niꞌeꞌx Siloé cha (ri tzij Siloé nuꞌej: Takuon-el). Ri ache reꞌ xꞌa y xuchꞌaj ri nakꞌaroch, y antok xtzalaj-pa, nitzuꞌn yan chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Y ri vinak ri iru-vacínix ri ache reꞌ, y ri nicꞌaj chic vinak ri quitzꞌatuon chi muoy, niquiꞌej: ¿Man ja ta came la ri ache ri katzꞌatuon ri nitzꞌuyeꞌ nucꞌutuj ru-limosna? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Icꞌo niquiꞌej: Jajaꞌ. Y nicꞌaj chic niquiꞌej: Casi junan ncaꞌtzuꞌn riqꞌuin ri ache reꞌ. Pero jajaꞌ nuꞌej: Inreꞌ reꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y ri vinak niquicꞌutuj cha ri ache reꞌ: ¿Chica xꞌan chava chi ncatzuꞌn vacame? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri ache xuꞌej chica: Jun ache rubꞌinan Jesús xuꞌon jubꞌaꞌ chꞌabꞌak y jareꞌ ri xubꞌach pa noch, y xuꞌej chuva: Caꞌin y achꞌajaꞌ ri anakꞌavach chupan ri estanque ri niꞌeꞌx Siloé cha. Y ja xiꞌa, y xinchꞌaj ri nakꞌanoch y ja xitzuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero ri vinak xquicꞌutuj cha: ¿Pacheꞌ cꞌo-ve ri Jesús vacame? xaꞌchaꞌ cha. Y jajaꞌ xuꞌej: Man vataꞌn ta, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y ri vinak xquicꞌuaj cꞌa ri ache ri nitzuꞌn yan chic chiquivach ri achiꞌaꞌ fariseos. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri kꞌij antok ri Jesús xuꞌon ri jubꞌaꞌ chꞌabꞌak y xuꞌon cha ri ache muoy chi xtzuꞌn, chupan jun kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Antok ri ache cꞌo chic apa chiquivach ri achiꞌaꞌ fariseos, ijejeꞌ xquicꞌutuj cꞌa cha chi cheꞌl xꞌan cha chi nitzuꞌn vacame. Y jajaꞌ xuꞌej: Ri xbꞌano chuva chi xitzuꞌn, xubꞌach jubꞌaꞌ chꞌabꞌak pa noch, xinchꞌaj, y ja xitzuꞌn, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y nicꞌaj achiꞌaꞌ fariseos xquiꞌej: Ri ache ri rubꞌinan Jesús man riqꞌuin ta ri Dios patanak-ve, ruma man nuꞌon ta guardar ri kꞌij richin uxlanien. Pero nicꞌaj chic achiꞌaꞌ fariseos xquiꞌej: ¿Can nitiquir came ncaꞌruꞌon milagros jun ache ri cꞌo ru-pecado? Ri achiꞌaꞌ fariseos reꞌ man junan ta niquiꞌej chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Rumareꞌ ri achiꞌaꞌ fariseos xquicꞌutuj chic cha ri ache muoy ri nitzuꞌn yan chic: ¿Chica chi ache naꞌej atreꞌ ri xjako ri anakꞌavach? Y ri ache reꞌ xuꞌej: Inreꞌ niꞌej chi jun profeta, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, man niquinimaj ta chi ri ache reꞌ can muoy antok xalax, y vacame xa nitzuꞌn yan chic. Rumareꞌ xaꞌcayuoj ri rutie-rutataꞌ ri ache ri nitzuꞌn yan chic, ");
INSERT INTO cakSNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","y xquicꞌutuj cꞌa chica: ¿Ja ivalcꞌual va, ri ntiꞌej chi muoy antok xalax? ¿Cheꞌl reꞌ chi nitzuꞌn yan chic vacame? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y ri rutie-rutataꞌ ri ache xquiꞌej chica: Kataꞌn chi ja kalcꞌual va y can muoy antok xalax. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero man kataꞌn ta ojreꞌ ri chica xuꞌon chi vacame nitzuꞌn. Y man kataꞌn ta jeꞌ ri chica xbꞌano cha chi nitzuꞌn yan chic vacame. Ticꞌutuj cha jajaꞌ; ruma jajaꞌ cꞌo chic rujunaꞌ, y xtuꞌej chiva ri chica xꞌan cha, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quireꞌ xquiꞌej ri rutie-rutataꞌ ri ache chica ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, ruma quixiꞌin-quiꞌ chiquivach. Ruma ri achiꞌaꞌ ri cꞌo quikꞌij calasan chic rubꞌixic, chi chica-na ri xtiꞌeꞌn chi ri Jesús jareꞌ ri Cristo, can nikotax-pa chupan ri sinagoga. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rumareꞌ ri rutie-rutataꞌ ri ache xquiꞌej chi tiquicꞌutuj cha jajaꞌ, ruma jajaꞌ cꞌo chic rujunaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y ri achiꞌaꞌ reꞌ xcayuoj chic jun bꞌay ri ache ri nitzuꞌn yan chic, y xquiꞌej cha: Ja ri Dios tayaꞌ rukꞌij. Ojreꞌ kataꞌn chi ri ache rubꞌinan Jesús xa jun pecador, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ri ache xuꞌej chica: Inreꞌ man vataꞌn ta xa ri ache reꞌ xa jun pecador o manak. Ri vataꞌn inreꞌ ja ri rubꞌanun-pa, chi man nquitzuꞌn ta y vacame nquitzuꞌn, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y ri achiꞌaꞌ reꞌ xquicꞌutuj chic cha ri ache: ¿Chica xuꞌon chava? ¿Cheꞌl antok xujak ri anakꞌavach? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Jajaꞌ xuꞌej chica: Pero reꞌ ya xinꞌej chiva y xa man xinivaxaj ta. ¿Karruma vacame ixreꞌ ntivajoꞌ chi inreꞌ niꞌej chic jun bꞌay chiva? ¿Ntivajoꞌ jeꞌ nquixuoc ru-discípulos jajaꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero ri achiꞌaꞌ reꞌ xpa quiyoval y xquiꞌej: Atreꞌ xa at jun ru-discípulo jajaꞌ, pero ojreꞌ oj ru-discípulos ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ojreꞌ kataꞌn chi ri Moisés can xchꞌoꞌ ri Dios riqꞌuin, pero ri ache reꞌ man kataꞌn ta pacheꞌ patanak-ve, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y ri ache xchꞌo-apa chica y xuꞌej: Inreꞌ altíra nquichapataj, ruma ixreꞌ man ivataꞌn ta pacheꞌ patanak-ve, pero inreꞌ xujak ri nakꞌanoch. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Can kataꞌn chi ri Dios man nraꞌxaj ta ri niquicꞌutuj ri pecadores cha. Pero ri jun ri nuxiꞌij-riꞌ nuꞌon pecado choch ri Dios y nuꞌon jeꞌ ri nrajoꞌ, can nicꞌaxax y niyoꞌx cha ri nucꞌutuj. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Xa-jan antok xtzꞌucutaj-pa ri roch-ulief, man jun bꞌay cꞌaxan chi cꞌo ta jun ache nuꞌon cha jun muoy xa-jan antok xalax, chi nitzuꞌn yan chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y xa ta ri ache reꞌ man ta riqꞌuin ri Dios patanak-ve, man jun kax nitiquir nuꞌon, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero ri achiꞌaꞌ reꞌ xquiꞌej cha ri ache ri nitzuꞌn yan chic: Atreꞌ can xatalax chupan nojiel a-pecado, ¿y navajoꞌ nkojatijuoj ojreꞌ? xaꞌchaꞌ. Y xquikotaj-pa ri ache reꞌ chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xraꞌxaj chi ri ache reꞌ xkotax-pa, rumareꞌ xbꞌarucanuj. Y antok xril, xuꞌej cha: ¿Nanimaj atreꞌ ri Rucꞌajuol ri Dios? xchaꞌ ri Jesús cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y ri ache ri nitzuꞌn yan chic, xuꞌej cha ri Jesús: Tuoya, ¿chica cꞌa ri Rucꞌajuol ri Dios chi ninimaj inreꞌ? xchaꞌ ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y ri Jesús xuꞌej cha: Atreꞌ atzꞌatuon chic ri Rucꞌajuol ri Dios. Y ri nichꞌoꞌ aviqꞌuin jareꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Y ri ache xuꞌej: Ajaf, inreꞌ ncannimaj. Y ri ache can xuyaꞌ rukꞌij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xuꞌej: Inreꞌ xipa choch-ulief chi ncaꞌntzꞌat ri chica quibꞌanun ri vinak, xa i-otz o man i-otz ta. Y niꞌan chica ri vinak ri man ncaꞌtzuꞌn ta chi ncaꞌtzuꞌn. Pero ri niquinaꞌ chi ncaꞌtzuꞌn, xa xcaꞌuoc muoy. ");
INSERT INTO cakSNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Icꞌo achiꞌaꞌ fariseos ri icꞌo-apa chireꞌ pacheꞌ cꞌo-ve ri Jesús, antok xcaꞌxaj reꞌ, xquiꞌej: ¿Oj muoy cꞌa jeꞌ ojreꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y ri Jesús xuꞌej chica: Xa ta ix muoy, otz ta, ruma manak ta i-pecado. Pero ruma ixreꞌ ntiꞌej chi man ix muoy ta, rumareꞌ cꞌo ri i-pecado. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Can ketzij, ketzij cꞌa ri niꞌej chiva: Ri man ntuoc ta pacheꞌ cꞌo-ve ri ruchiꞌ ri quicoral ri ovejas y xa nijotieꞌ chirij ri coral chi ntuoc; ri nibꞌano quireꞌ xa alakꞌuon y nalakꞌ pa tak bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero ri ntuoc chuchiꞌ ri coral, jareꞌ ri pastor quichin ri ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y ri ache ri nichajin ruchiꞌ ri coral, nujak-pa ruchiꞌ ri coral choch ri ache ri nichajin quichin ri ovejas, y ri ovejas can cataꞌn chic rukul ri nichajin quichin. Jajaꞌ ncaꞌrayuoj, nuꞌej ri quibꞌeꞌ y ncaꞌralasaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Antok ri chajiniel i-ralasan chic el quinojiel ri ru-ovejas, niꞌa naꞌay chiquivach, y ri ovejas ncaꞌa chirij. Ri ovejas quireꞌ niquiꞌan, ruma cataꞌn ri rukul ri nichajin quichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero ri man cataꞌn ta roch, man ncaꞌa ta chirij; xa ncaꞌnumaj choch, ruma man cataꞌn ta rukul. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xuꞌej ri jun parábola (cꞌambꞌal-tzij) reꞌ chica ri achiꞌaꞌ fariseos, pero ijejeꞌ man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) ri chica xuꞌej chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Y ri Jesús xchꞌoꞌ chic jun bꞌay y xuꞌej chica ri achiꞌaꞌ fariseos: Inreꞌ can ketzij, ketzij ri niꞌej chiva: Inreꞌ ri Ruchiꞌ ri coral ri pacheꞌ ncaꞌuoc-ve ri ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Quinojiel ri xaꞌcꞌujieꞌ naꞌay chinoch inreꞌ y xquiꞌej chi i-takuon-pa ruma ri Dios, pero xa man quireꞌ ta, xa i-junan quiqꞌuin ri alakꞌomaꞌ y xa incheꞌl ri ncaꞌlakꞌ pa tak bꞌay. Pero ri ovejas man xaꞌa ta chiquij ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Inreꞌ ri Ruchiꞌ ri coral. Ri xtuoc viqꞌuin inreꞌ, can xticolotaj y ntiel y ntuoc y xtiril nojiel ri nicꞌatzin cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Antok nalka ri alakꞌuon, joꞌc nalakꞌ, niquimisan y nuqꞌuis can paroꞌ nojiel. Pero inreꞌ xipa chi niyaꞌ ri cꞌaslien; jun cꞌaslien ri man jubꞌaꞌ ta oc. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Inreꞌ ri Utzulaj Chajiniel quichin ri ovejas. Ri Utzulaj Chajiniel, can nuyaꞌ rucꞌaslien pa qui-cuenta ri ru-ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero man quireꞌ ta nuꞌon ri xa man ketzij ta chajiniel, ruma xa tajuon. Jajaꞌ xa man cajaf ta ri ovejas, y antok nutzꞌat chi nipa ri utif, xa jajaꞌ ri ninumaj-el y ncaꞌruyaꞌ can ri ovejas. Y ri utif ncaꞌrucꞌuaj ri ovejas, y ri nicꞌaj chic niquiquiraj-el-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jun ri nituoj chi ncaꞌruchajij ri ovejas xa ninumaj. Quireꞌ nuꞌon, ruma man jun ru-cuenta chica ri ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Inreꞌ ri Utzulaj Chajiniel, y vataꞌn quivach ri nu-ovejas, y ijejeꞌ jeꞌ cataꞌn noch inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Quireꞌ jeꞌ nubꞌanun riqꞌuin ri Nataꞌ. Jajaꞌ rataꞌn noch inreꞌ, y inreꞌ vataꞌn roch jajaꞌ. Y inreꞌ niyaꞌ nucꞌaslien pa qui-cuenta ri nu-ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y man joꞌc ta reꞌ nu-ovejas icꞌo, xa icꞌo jeꞌ nicꞌaj chic ri man icꞌo ta vaveꞌ chupan va jun coral va. Can nicꞌatzin chi ncaꞌncꞌam-pa, y ijejeꞌ xtiquiꞌan ri xtinꞌej chica. Richin quireꞌ xa jun xtiquiꞌan y jun oc Chajiniel xtichajin quichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nataꞌ Dios nquirajoꞌ ruma inreꞌ niyaꞌ ri nucꞌaslien pa qui-cuenta ri nu-ovejas, y nicꞌujieꞌ chic jun bꞌay ri nucꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri nucꞌaslien man jun xtimajo chuva, ruma ri nucꞌaslien xa inreꞌ mismo ri nquiyoꞌn. Pa nukꞌaꞌ inreꞌ cꞌo-ve chi niyaꞌ y pa nukꞌaꞌ jeꞌ inreꞌ cꞌo-ve chi nicꞌujieꞌ chic nucꞌaslien. Quireꞌ ri ruꞌeꞌn-pa ri Nataꞌ chuva, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y jun bꞌay chic ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas man junan ta xquiꞌan-ka pensar chirij ri tzij ri xaꞌruꞌej ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Iqꞌuiy chiquivach ijejeꞌ xquiꞌej chirij ri Jesús: La xa chꞌuꞌj. Xa itziel espíritu ri cꞌo riqꞌuin, y ixreꞌ, ¿karruma ntivaxaj ri nuꞌej? ");
INSERT INTO cakSNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Y ri nicꞌaj chic xquiꞌej: Jun ri cꞌo itziel espíritu riqꞌuin, man nuꞌej ta utzulaj tak tzij incheꞌl ri xaꞌruꞌej ri Jesús. ¿Nicovin came jun ri cꞌo itziel espíritu riqꞌuin nuꞌon chica ri muoy chi ncaꞌtzuꞌn? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa ru-tiempo jobꞌ nakꞌax ri namakꞌej rubꞌinan Dedicación, ri pa tanamet Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús nibꞌiej chupan ri templo, chuchiꞌ jun corredor ri rubꞌinan Richin ri Salomón. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xaꞌbꞌaka riqꞌuin ri Jesús, xquimol-quiꞌ chirij y xquiꞌej cha: ¿Karruma nasach kajaluon? Xa atreꞌ ri Cristo, taꞌej chika. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Nuꞌeꞌn yan chiva y man iniman ta. Nojiel ri samaj ri ncaꞌnꞌan, pa rubꞌeꞌ ri Nataꞌ Dios ncaꞌnꞌan-ve. Y ri samaj reꞌ, jareꞌ niꞌeꞌn in chica inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero ixreꞌ man nquininimaj ta, ruma ixreꞌ man ix nu-ovejas ta; can incheꞌl ri xinꞌej yan chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu-ovejas cataꞌn nukul, y ncaꞌa chuvij, y inreꞌ vataꞌn quivach ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Inreꞌ niyaꞌ chica ri cꞌaslien ri man niqꞌuis ta y man jun chiquivach xtisach ta can. Y man jun xtitiquir xcaꞌralasaj-el pa nukꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ri Nataꞌ Dios ri xaꞌruyaꞌ chuva inreꞌ, cꞌo más ru-poder chiquivach quinojiel y man jun xtitiquir xcaꞌralasaj-el pa rukꞌaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Inreꞌ y ri Nataꞌ, joꞌc jun kabꞌanun riqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, xaꞌbꞌaquisicꞌaꞌ chic pa abꞌaj chirij ri Jesús chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ri Jesús xuꞌej chica ri achiꞌaꞌ reꞌ: Can qꞌuiy utzulaj tak samaj ri i-nubꞌanun chivach, ruma ri poder ri ruyoꞌn-pa ri Nataꞌ chuva. ¿Chica chiquivach ri utzulaj tak samaj ri nubꞌanun ri man nika ta chivach, y rumareꞌ ntivajoꞌ nquiniquimisaj cha abꞌaj? xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Y ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha ri Jesús: Ojreꞌ man ruma ta jun utzulaj samaj ncatkacꞌak cha abꞌaj. Ojreꞌ ncatkacꞌak ruma naꞌej chi at Dios. Ruma jun ache ri niꞌeꞌn quireꞌ, xa nuyokꞌ rubꞌeꞌ ri Dios, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xuꞌej chica: Chupan ri i-ley ri tzꞌibꞌan can, ri Dios nuꞌej: Inreꞌ nuꞌeꞌn chi ixreꞌ can ix dioses. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Jajaꞌ xuꞌej dioses chica ri choj cha xuya-ve ri ruchꞌabꞌal, y man jun modo niꞌeꞌx chi man ketzij ta nuꞌej ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xa quireꞌ xuꞌej ri Dios, ¿karruma ixreꞌ ntiꞌej chi inreꞌ xinyokꞌ rubꞌeꞌ ri Dios, ruma xinꞌej chi inreꞌ ri Rucꞌajuol ri Dios? Y inreꞌ ri xirucha-pa chi xirutak-pa choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y xa man niꞌan ta ri ruꞌeꞌn-pa ri Nataꞌ Dios chuva, man nquininimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero xa niꞌan ri ruꞌeꞌn-pa ri Nataꞌ Dios chuva, mesque man nquininimaj ta inreꞌ, pero tinimaj nojiel ri ncaꞌnꞌan chivach, richin quireꞌ ntivatamaj y ntinimaj chi ri Nataꞌ Dios cꞌo viqꞌuin y inreꞌ incꞌo riqꞌuin jajaꞌ, xchaꞌ ri Jesús chica ri achiꞌaꞌ ri cꞌo quikꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ijejeꞌ can xcajoꞌ ta xquitzꞌom ri Jesús, pero xa man xaꞌtiquir ta chic, ruma xꞌa chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y ri Jesús xakꞌax chic apa jucꞌan ruchiꞌ ri río Jordán, ri lugar pacheꞌ ri Juan el Bautista xaꞌruꞌon bautizar ri vinak naꞌay; y chireꞌ xcꞌujie-ve-ka. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y iqꞌuiy vinak xaꞌlka riqꞌuin ri Jesús chireꞌ. Y ri vinak reꞌ niquiꞌej: Can ketzij chi ri Juan el Bautista man jun milagro xuꞌon, pero nojiel ri tzij ri xaꞌruꞌej can chirij ri ache va, can ketzij, ncaꞌchaꞌ ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y iqꞌuiy vinak ri xquinimaj ri Jesús chupan ri lugar reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupan cꞌa ri aldea Betania, cꞌo jun ache rubꞌinan Lázaro ri niyavaj. Jajaꞌ icꞌo icaꞌyeꞌ ranaꞌ quibꞌinan María y Marta, y ri iyoxeꞌ reꞌ aj-chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ri María reꞌ, jareꞌ ri xyoꞌn jubꞌul akꞌuon chirij ri rakan ri Ajaf Jesús y xaꞌrusuꞌ cha ri ruveꞌ. Ruxiꞌal jajaꞌ ri Lázaro ri niyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ri María y ri Marta xquitak rasuon cha ri Jesús: Ajaf, nakaꞌej chava chi ri kaxiꞌal Lázaro, ri navajoꞌ, vacame niyavaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y antok ri Jesús xraꞌxaj ri rasuon ri takuon-el cha, jajaꞌ xuꞌej: Ri Lázaro niyavaj, pero man richin ta camic, xa richin niyoꞌx rukꞌij ri Dios, chi quireꞌ ri Rucꞌajuol ri Dios niyoꞌx rukꞌij, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús altíra ncaꞌrajoꞌ ri Marta, ri María y ri quixiꞌal Lázaro. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y antok jajaꞌ xraꞌxaj chi ri Lázaro niyavaj, xa man xꞌa ta chaꞌnin chutzꞌatic, xa xcꞌujie-ka chic caꞌyeꞌ kꞌij chupan ri lugar ri pacheꞌ cꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Y antok kꞌaxnak chic ri caꞌyeꞌ kꞌij, ri Jesús xuꞌej chica ri ru-discípulos: Vacame kojtzalaj cꞌa Judea, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y ri ru-discípulos xquiꞌej cha: Rabí, xa cꞌa jubꞌaꞌ oc tiempo takꞌax antok ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xcajoꞌ ta xatquiquimisaj cha abꞌaj, ¿y vacame navajoꞌ ncatzalaj chic jun bꞌay chireꞌ? xaꞌchaꞌ ri discípulos cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero ri Jesús xuꞌej chica: Ri kꞌij rucꞌuan doce (cabꞌalajuj) horas. Ri niꞌin pakꞌij, man nutupij ta rakan, ruma cꞌo ri luz ri nibꞌano ri sakil cha ri roch-ulief. Can nojiel nutzꞌat ruma ri sakil reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero ri niꞌin pa kꞌakuꞌn, can nutupij ri rakan, ruma xa manak ri luz riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ, xchꞌoꞌ chic jun bꞌay chica ri ru-discípulos y xuꞌej: Ri ka-amigo Lázaro nivar. Pero nquiꞌa chi nicꞌasuoj, xchaꞌ chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y ri ru-discípulos xquiꞌej cha: Ajaf, xa ri Lázaro nivar, nuꞌon sanar, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero ri Jesús xa chirij ri rucamic ri Lázaro xchꞌo-ve antok xuꞌej chi nivar, pero ri ru-discípulos xiꞌka pa quiveꞌ (xquiꞌan entender) chi choj nivar. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Entonces ri Jesús jaꞌal cꞌa kꞌalaj xuꞌej chica: Ri Lázaro xcon. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y can nquiquicuot ruma man incꞌo ta Betania antok xcon ri Lázaro, chi quireꞌ ixreꞌ más ntiyaꞌ ivánima viqꞌuin. Vacame joꞌ Betania, pacheꞌ cꞌo-ve ri Lázaro, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pero ri jun discípulo ri Tomás rubꞌeꞌ, ri niꞌeꞌx jeꞌ Dídimo cha, xuꞌej chica ri nicꞌaj chic discípulos: Joꞌ riqꞌuin ri Jesús, chi quireꞌ junan nkojquimisas riqꞌuin, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Antok ri Jesús xalka Betania, ya cajeꞌ kꞌij tiyoꞌx ri Lázaro chupan ri jul ri cꞌo choch jun tanatic juyuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri aldea Betania man naj ta quicajol riqꞌuin ri tanamet Jerusalén. Ri quicajol xa jun laꞌk caꞌyeꞌ kilómetros riqꞌuin nicꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y iqꞌuiy achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas ri xaꞌlka chi xaꞌquiꞌan consolar ri Marta y ri María, ruma xcon ri quixiꞌal Lázaro. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Antok ri Marta xunaꞌiej chi patanak ri Jesús, jun-anin xbꞌarucꞌuluꞌ. Pero ri María xa xcꞌujieꞌ can chireꞌ pa jay. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y antok ri Marta xalka riqꞌuin ri Jesús, jajaꞌ xuꞌej cha: Ajaf, xa ta atcꞌo vaveꞌ, man ta xcon ri nuxiꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero inreꞌ vataꞌn chi ri xtacꞌutuj cha ri Dios vacame, ri Dios can xtuyaꞌ chava, xchaꞌ ri Marta cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xuꞌej cha ri Marta: Ri axiꞌal Lázaro xticꞌastaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y ri Marta xuꞌej: Inreꞌ vataꞌn chi xticꞌastaj-pa; ruma antok xtalka ri ruqꞌuisbꞌal kꞌij, quinojiel ri quiminakiꞌ xcaꞌcꞌastaj-pa, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xuꞌej cha ri Marta: Inreꞌ nquicovin ncaꞌncꞌasuoj ri i-quiminak chic y nquicovin jeꞌ niyaꞌ cꞌaslien. Rumareꞌ ri niniman vichin, mesque xticon, can xticꞌasieꞌ chic jun bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Y chica-na vinak ri cꞌo rucꞌaslien choch-ulief y nquirunimaj inreꞌ, man xticon ta richin nojiel tiempo. ¿Nanimaj reꞌ? xchaꞌ ri Jesús cha ri Marta. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y ri Marta xuꞌej cha ri Jesús: Quireꞌ Ajaf, can ninimaj chi atreꞌ ri Cristo ri Rucꞌajuol ri Dios, ri xapa vaveꞌ choch-ulief, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Antok ri Marta ruꞌeꞌn chic ri tzij reꞌ cha ri Jesús, xꞌa chi xbꞌarayuoj ri María ri quichakꞌ-quinimal-quiꞌ riqꞌuin. Y antok xbꞌaka, ri Marta xuꞌej pa ruxiquin ri María: Ri Maestro xalka y vacame ncarayuoj, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María, antok xraꞌxaj quireꞌ, xpalaj-pa ri pacheꞌ cꞌo-ve y jun-anin xꞌa cꞌa pacheꞌ cꞌo-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús cꞌa majaꞌ tuoc chupan ri aldea Betania, xa cꞌa cꞌo chupan ri lugar pacheꞌ xbꞌacꞌul-ve ruma ri Marta. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y antok ri vinak israelitas ri icꞌo chirachuoch ri María chi niquiꞌan consolar, xquitzꞌat chi jun-anin xpalaj-el y xꞌa; ijejeꞌ xaꞌa chirij, ruma ijejeꞌ xquiꞌej-ka: Ri María niꞌuokꞌ chuchiꞌ ri jul ri pacheꞌ yoꞌn-ve ri ruxiꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Y antok ri María xalka pacheꞌ cꞌo-ve ri Jesús y xutzꞌat, xxuquie-ka chukul rakan y xuꞌej cha: Ajaf, xa ta atcꞌo vaveꞌ, man ta xcon ri nuxiꞌal, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Y antok ri Jesús xutzꞌat chi ri María ntuokꞌ y ncaꞌuokꞌ jeꞌ quinojiel ri vinak israelitas ri i-bꞌanak riqꞌuin ri María, ri ránima ri Jesús jun-ve xuꞌon xunaꞌ y xbꞌisuon-ka. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y xucꞌutuj: ¿Pacheꞌ yoꞌn-ve ri Lázaro? xchaꞌ. Y ijejeꞌ xquiꞌej: Ajaf, joꞌ y nakacꞌutuꞌ chavach, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y ri Jesús xuokꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jareꞌ antok ri vinak israelitas ri ncaꞌquiꞌan consolar ri Marta y ri María, xquiꞌej: Titzꞌataꞌ, kꞌalaj chi altíra xrajoꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero icꞌo chiquivach ri vinak reꞌ xquiꞌej chirij ri Jesús: Jajaꞌ cꞌa xuꞌon cha ri muoy chi xtzuꞌn. ¿Man ta came xcovin xuꞌon chi man ta xcon ri Lázaro? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Antok ri Jesús xalka chuchiꞌ ri pacheꞌ yoꞌn-ve, xbꞌisuon chic ka jun bꞌay. Ri jul ri pacheꞌ yoꞌn can ri Lázaro jun cueva ri cꞌo choch jun tanatic juyuꞌ, ri tzꞌapin can ruchiꞌ cha jun abꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y ri Jesús xuꞌej: Tivalasaj-el ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, xchaꞌ chica. Pero ri Marta, ri ranaꞌ ri quiminak, xuꞌej cha ri Jesús: Ajaf, chuf chic, ruma ya cajeꞌ kꞌij ticon, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xuꞌej cha ri Marta: Inreꞌ nuꞌeꞌn chic chava chi xa xtanimaj, can xtatzꞌat ri nuꞌon ri ru-poder ri Dios, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y ja xcalasaj-el ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul ri pacheꞌ cꞌo-ve ri quiminak. Y ri Jesús xtzuꞌn chicaj y xuꞌej: Nataꞌ, tiox bꞌaꞌ niyaꞌ chava ruma xinavaxaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Inreꞌ vataꞌn chi siempre nquinavaxaj. Pero nojiel reꞌ, niꞌej cuma ri vinak ri quimaluon-pa-quiꞌ viqꞌuin vacame, chi tiquinimaj chi atreꞌ ri xatako-pa vichin ri choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Antok ri Jesús ruꞌeꞌn chic ri tzij reꞌ, riqꞌuin nojiel ruchukꞌaꞌ xchꞌoꞌ y xuꞌej: ¡Lázaro, catiel-pa juviera! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y ri Lázaro, ri quiminak, xbꞌaꞌiel-pa. Y ri rukꞌa-rakan yoꞌn tziak chirij, y ri rupalaj tzꞌapin cha jun tziak xax. Y ri Jesús xuꞌej: Tiquiraꞌ ri tziak chirij, chi quireꞌ otz niꞌin y niꞌa, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Y iqꞌuiy chiquivach ri vinak israelitas ri xaꞌlka riqꞌuin ri María, xquinimaj ri Jesús antok xquitzꞌat ri xuꞌon, chi xucꞌasuoj ri quiminak. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero icꞌo nicꞌaj xaꞌa quiqꞌuin ri achiꞌaꞌ fariseos y xbꞌaquitzijuoj chica, ri xuꞌon ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y ri principales sacerdotes y ri achiꞌaꞌ fariseos xquimol-quiꞌ y xaꞌcayuoj jeꞌ ri nicꞌaj chic achiꞌaꞌ ri autoridades quichin ri israelitas y xquiꞌej chica: ¿Chica nakaꞌan? Ruma ri ache rubꞌinan Jesús qꞌuiy milagros ri ncaꞌruꞌon chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y xa xtakayaꞌ lugar cha, quinojiel ri vinak xcaꞌniman richin; y xcaꞌpa ri romanos, y xtiquiꞌan destruir ri templo y ri ka-nación, xaꞌchaꞌ ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Entonces ri Caifás, ri sacerdote ri más cꞌo rukꞌij chupan ri junaꞌ reꞌ, jun cachꞌil ri principales sacerdotes, xchꞌoꞌ y xuꞌej chica: Ixreꞌ xa man jun ivataꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Man ntiꞌan ta pensar jubꞌaꞌ chi xa más otz chi joꞌc jun nicon pa ka-cuenta konojiel y man nkucon ta konojiel, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Antok ri Caifás xuꞌej quireꞌ, man runoꞌj ta jajaꞌ xucusaj. Ri tzij ri xaꞌruꞌej jajaꞌ, ja ri Dios ri xꞌeꞌn-pa cha, ruma chupan ri junaꞌ reꞌ jajaꞌ ri sacerdote ri más cꞌo rukꞌij. Rumareꞌ ri Dios xuꞌon cha chi xuꞌej chi ja ri Jesús xticon pa qui-cuenta ri vinak israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero ri Jesús man joꞌc ta pa qui-cuenta ri vinak israelitas xticon, xa xticon jeꞌ chi nuꞌon xa jun quiqꞌuin ri vinak ri i-ralcꞌual ri Dios ri quiquiran-quiꞌ choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y chupan ri mismo kꞌij reꞌ, ri achiꞌaꞌ ri cꞌo quikꞌij xquiꞌej chiquivach chi xtiquiquimisaj ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumareꞌ, ri Jesús man chic xucꞌut ta riꞌ chiquivach ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas. Jajaꞌ xꞌa jun tanamet rubꞌinan Efraín ri cꞌo cierca ri desierto. Y xcꞌujie-ka chireꞌ quiqꞌuin ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y ya nalka ri Pascua, ri jun quinamakꞌej ri israelitas. Rumareꞌ iqꞌuiy vinak ri xaꞌiel-pa pa tak quitanamit, chi xaꞌa pa tanamet Jerusalén. Can xaꞌa chi niquiꞌan purificar-quiꞌ choch ri Dios, antes choch ri namakꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y ri vinak niquicanuj ri Jesús, y pa templo niquicꞌutuj chiquivach: ¿Chica ntiꞌan pensar ixreꞌ? ¿Nipa came chupan ri namakꞌej reꞌ? ncaꞌchaꞌ ri vinak reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ri principales sacerdotes y ri achiꞌaꞌ fariseos calasan chic rutzijoxic, chi chica-na ri xtinaꞌien pacheꞌ cꞌo-ve ri Jesús, tuꞌej chica ijejeꞌ, chi niquitzꞌamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Antok vakiꞌ chic kꞌij nrajoꞌ chi nalka ri kꞌij richin ri namakꞌej Pascua, ri Jesús xꞌa chupan ri aldea Betania, ri rutanamit ri Lázaro, ri xcon y xcꞌasos chiquicajol ri quiminakiꞌ ruma ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y chireꞌ xꞌan jun vaꞌen ruma xalka ri Jesús. Y ja ri Marta ri ncaꞌtzuku-apa ri icꞌo chirij ri mesa. Y ri Lázaro cꞌo chiquicajol ri i-tzꞌuyul-apa chirij ri mesa riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpa ri María ri ranaꞌ ri Lázaro, xbꞌarucꞌama-pa nicꞌaj litro nardo puro; jun jubꞌul akꞌuon ri altíra cara rajal. Y xuyaꞌ chirij rakan ri Jesús y xaꞌrusuꞌ cha ri ruveꞌ. Y ri jay reꞌ can xnuoj riqꞌuin ri ruxlaꞌ ri akꞌuon reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y jun chiquivach ri discípulos, ri Judas Iscariote rubꞌeꞌ, ri rucꞌajuol ri Simón; ri discípulo reꞌ ja ri xticꞌayin richin ri Jesús, xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Karruma man xcꞌayix ta ri jubꞌul akꞌuon reꞌ? Xa ta xcꞌayix, xyoꞌx ta trescientos denarios; y ri rajal xjach ta chica ri i-puobra, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Jajaꞌ xuꞌej quireꞌ, pero man ruma ta altíra ncaꞌrajoꞌ ri i-puobra. Jajaꞌ quireꞌ xuꞌej ruma jajaꞌ niyaco ri miera y cꞌo ri nalakꞌaj-el. Jajaꞌ xa alakꞌuon. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Y ri Jesús xuꞌej cha: Tayaꞌ chireꞌ. Mesque majaꞌ quicon, jajaꞌ can vichin inreꞌ ruyacuon-pa ri akꞌuon reꞌ richin ri kꞌij antok xquimuk. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ruma ri i-puobra, can siempre icꞌo iviqꞌuin. Pero inreꞌ man siempre ta xquicꞌujieꞌ iviqꞌuin, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Antok ri vinak israelitas xquinaꞌiej chi ri Jesús cꞌo Betania, can iqꞌuiy ri xaꞌpa, pero man joꞌc ta chi niquitzꞌat jajaꞌ, xa richin jeꞌ chi niquitzꞌat ri Lázaro, ri xcꞌasos ruma ri Jesús chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Rumareꞌ ri principales sacerdotes xquiꞌej chiquivach chi niquiquimisaj jeꞌ ri Lázaro. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ruma jajaꞌ, mareꞌ iqꞌuiy israelitas ri ncaꞌquiyaꞌ can ijejeꞌ y niquinimaj ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chucaꞌn kꞌij, chireꞌ pa tanamet Jerusalén, can iqꞌuiy vinak icꞌo ruma ri namakꞌej. Y antok xcaꞌxaj chi patanak ri Jesús, ");
INSERT INTO cakSNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","xquicꞌuaj chꞌitak rukꞌaꞌ palmas y xbꞌaquicꞌuluꞌ y riqꞌuin nojiel quichukꞌaꞌ niquiꞌej: ¡Tiox bꞌaꞌ chi patanak ri Jun reꞌ! ¡Bendito ri patanak pa rubꞌeꞌ ri Ajaf Dios, jareꞌ ri Ka-Rey ojreꞌ israelitas! ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y ri Jesús cꞌo jun alaj burro ri xril, chi xchꞌoquie-el chirij. Can incheꞌl ri nuꞌej chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can: ");
INSERT INTO cakSNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man tixiꞌij-iviꞌ ixreꞌ ri ixcꞌo pa tanamet Sion; ruma ri I-Rey ja patanak, chꞌacol-pa chirij jun alaj burro. Quireꞌ ri tzꞌibꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Naꞌay ri ru-discípulos man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) nojiel reꞌ. Cꞌajaꞌ antok ri Jesús cꞌastajnak chic pa chiquicajol ri quiminakiꞌ y cꞌo chic namalaj rukꞌij, cꞌajareꞌ xalka pa quiveꞌ chi nojiel ri xbꞌanataj, can tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri vinak ri xquitzꞌat ri Jesús antok xrayuoj ri Lázaro ri quiminak chic y xucꞌasuoj-pa chiquicajol ri quiminakiꞌ, niquiꞌej chica ri nicꞌaj chic vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y rumareꞌ, ri vinak xaꞌpa chi nalquicꞌuluꞌ ri Jesús. Ri vinak reꞌ can caxan chic ri milagro ri xuꞌon riqꞌuin ri Lázaro. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero ri achiꞌaꞌ fariseos niquiꞌej chiquivach: Titzꞌataꞌ, quinojiel ri vinak i-bꞌanak chirij. Man niquinimaj ta ri katzij ojreꞌ, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicajol quinojiel ri vinak ri ncaꞌlka pa tanamet Jerusalén chi nalquiyaꞌ rukꞌij ri Dios chupan ri namakꞌej, icꞌo jeꞌ nicꞌaj vinak man israelitas ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ri vinak reꞌ xaꞌbꞌaka riqꞌuin ri Felipe ri aj-Betsaida ri cꞌo chupan Galilea, chi niquicꞌutuj favor cha; ruma jajaꞌ jun ru-discípulo ri Jesús. Ri vinak reꞌ xquiꞌej cha: Tuoya, ojreꞌ nakajoꞌ nkuchꞌoꞌ cha ri Jesús, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xꞌa y xbꞌaruꞌej cha ri Andrés ri jun discípulo jeꞌ. Cꞌajareꞌ ri icaꞌyeꞌ xaꞌa chi xbꞌaquiꞌej cha ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y ri Jesús xuꞌej chica ri icaꞌyeꞌ discípulos: Ja xalka ri huora, chi ri Xtak-pa chicaj chi xalax chiꞌicajol xticꞌujieꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Can ketzij, ketzij ri niꞌej chiva chi xa man nitic ta jun ru-semilla trigo pan ulief, choj quireꞌ xticꞌujieꞌ. Pero xa nitic-ka pan ulief ri ru-semilla trigo reꞌ, xtiel-pa y xtuyaꞌ roch. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ri altíra nrajoꞌ ri rucꞌaslien vaveꞌ ri choch-ulief, man xticolotaj ta. Pero ri man nrajoꞌ ta ri rucꞌaslien vaveꞌ choch-ulief, xa nuyac-apa richin ri cꞌaslien ri man niqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Y xa cꞌo jun nrajoꞌ nuꞌon ri nusamaj, tipa viqꞌuin. Y pacheꞌ xquicꞌujie-ve inreꞌ, chireꞌ jeꞌ xticꞌujie-ve jajaꞌ. Ri xtibꞌano ri nusamaj, xtiꞌan cha ruma ri Nataꞌ chi xticꞌujieꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Inreꞌ altíra nikꞌaxo ri vánima vacame. ¿Pero chica xtinꞌej vacame: Nataꞌ, quinacaloꞌ choch ri huora richin sufrimiento? Más inreꞌ xa richin reꞌ xipa. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cꞌajareꞌ jajaꞌ xuꞌej: Nataꞌ, can tabꞌanaꞌ chi nikꞌalajin chi cꞌo akꞌij, xchaꞌ. Y jareꞌ antok Jun xchꞌo-pa chicaj y xuꞌej: Can nubꞌanun chic quireꞌ. Y xtinꞌan chic jun bꞌay, chi nikꞌalajin nukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y can iqꞌuiy chiquivach ri vinak ri icꞌo chireꞌ niquiꞌej chi jun ráya ri xcaꞌxaj antok xchꞌo-pa ri Jun chicaj. Y nicꞌaj chic niquiꞌej: Jun ángel ri xchꞌo-pa cha, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y ri Jesús xuꞌej chica: Ri xivaxaj ri xchꞌo-pa chicaj, xchꞌo-pa ivuma ixreꞌ y man vuma ta inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Vacame xalka ri kꞌij chi ri Dios nuꞌon juzgar ri roch-ulief, y ri Satanás, ri tzꞌamayuon ri roch-ulief, xtalasas-el. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y antok inreꞌ xquijotobꞌax choch ri cruz, ri vinak xcaꞌpa viqꞌuin inreꞌ, xchaꞌ jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ri Jesús xuꞌej quireꞌ, chi xuꞌej ri chica modo xtiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y ri vinak xquiꞌej: Katzꞌatuon chupan ri ruchꞌabꞌal ri Dios, chi ri Cristo man nicon ta, can xticꞌasieꞌ richin nojiel tiempo. ¿Karruma naꞌej chi nicꞌatzin chi ri Xtak-pa chicaj chi xalax chikacajol nijotobꞌax choch ri cruz? Can taꞌej cꞌa chika, ¿chica reꞌ ri Xtak-pa chicaj chi xalax chikacajol? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jareꞌ antok ri Jesús xuꞌej chica: Ri Luz cꞌa cꞌo jutzꞌit tiempo iviqꞌuin. Can chupan cꞌa ri Luz quixꞌin-ve, mientras cꞌa cꞌo iviqꞌuin. Y xa man xtiꞌan ta quireꞌ, antok xtinaꞌ, pa kꞌakuꞌn yan chic nquixꞌin-ve; y jun ri pa kꞌakuꞌn niꞌin-ve, man rataꞌn ta pacheꞌ bꞌanak-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mientras cꞌa cꞌo ri Luz iviqꞌuin, can tinimaj cꞌa, chi quireꞌ nquixuoc ralcꞌual ri Luz reꞌ. Quireꞌ xaꞌruꞌej ri Jesús chica ri vinak. Y xaꞌruyaꞌ can, y man jun xnaꞌien pacheꞌ xꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús qꞌuiy milagros xaꞌruꞌon chiquivach ri vinak. Pero mesque quireꞌ xuꞌon, ijejeꞌ man xquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y quireꞌ ri xbꞌanataj, chi nuꞌon cumplir ri rutzꞌibꞌan can ri profeta Isaías. Jajaꞌ rutzꞌibꞌan can: Ajaf, ¿chica xniman ri atzij ri xkatzijuoj? ¿Cꞌo came jun vinak ri xutzꞌat ri a-poder? Quireꞌ nuꞌej ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ri vinak reꞌ man niquinimaj ta, ruma chupan ri rutzꞌibꞌan can ri Isaías nuꞌej jeꞌ: ");
INSERT INTO cakSNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Can bꞌanun chica ijejeꞌ ruma ri Dios chi man ncaꞌtzuꞌn ta y cof ranun ri cánima; mareꞌ man niquitzꞌat ta ri nicꞌut chiquivach, y man nicajoꞌ ta chi ntuoc riqꞌuin cánima, y can man nicajoꞌ ta niquiyaꞌ can ri pecado chi niquiꞌan ri nivajoꞌ inreꞌ, chi nicꞌax ri quicꞌaslien. Quireꞌ nuꞌej ri Dios, ri rutzꞌibꞌan can ri Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri profeta Isaías, ri xcꞌujieꞌ ojier can tiempo, xuꞌej quireꞌ antok xutzꞌat yan rukꞌij ri Ajaf Jesús, y chirij jajaꞌ ruꞌeꞌn can. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Pero mesque quireꞌ, iqꞌuiy chiquicajol ri autoridades quichin ri israelitas xquinimaj ri Jesús. Pero man xquiꞌej ta, ruma niquixiꞌij-quiꞌ chiquivach ri achiꞌaꞌ fariseos, chi man caꞌkotax-pa chupan ri sinagoga. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ruma ijejeꞌ más nika chiquivach chi niyoꞌx quikꞌij cuma ri vinak, que choch niyoꞌx quikꞌij ruma ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y ri Jesús riqꞌuin ruchukꞌaꞌ xchꞌoꞌ y xuꞌej: Ri nquirunimaj inreꞌ, man joꞌc ta inreꞌ ri nquirunimaj, xa nunimaj cꞌa ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri nquirutzꞌat inreꞌ, can nutzꞌat jeꞌ ri Dios ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ruma inreꞌ ri Luz ri xipa choch-ulief, chi quireꞌ xa cꞌo jun ri xtiniman vichin, ri rucꞌaslien man chic xticꞌujieꞌ ta chupan ri kꞌakuꞌn. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero ri vinak ri nraꞌxaj ri nutzij y man nuꞌon ta ri nraꞌxaj, man inreꞌ ta ri xquibꞌano juzgar richin. Ruma inreꞌ man xipa ta choch-ulief chi ncaꞌnꞌan juzgar ri vinak. Inreꞌ xipa chi ncaꞌncol ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ri man nquirajoꞌ ta inreꞌ y man nrajoꞌ ta ri nuchꞌabꞌal, cꞌo ri xtibꞌano juzgar richin; ja ri chꞌabꞌal ri xaꞌnꞌej, jareꞌ ri xtibꞌano juzgar richin chupan ri ruqꞌuisbꞌal kꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ruma ri chꞌabꞌal ri xinꞌej, ja ri Nataꞌ yaꞌyuon-pa chuva. Jajaꞌ ri takayuon-pa vichin y ruꞌeꞌn-pa chuva chica chꞌabꞌal ri xtincꞌut y xtintzijuoj. ");
INSERT INTO cakSNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y vataꞌn chi ri ruꞌeꞌn-pa ri Nataꞌ Dios chuva, can nuyaꞌ cꞌaslien ri man niqꞌuis ta. Rumareꞌ ri chꞌabꞌal ri niꞌej, can incheꞌl ri ruꞌeꞌn-pa ri Nataꞌ chuva inreꞌ, can quireꞌ xalꞌej-ka. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y antok ya nalka ri kꞌij richin ri namakꞌej Pascua, ri Jesús rataꞌn chic chi ya nalka ri huora chi jajaꞌ ntiel-el vaveꞌ choch-ulief y nitzalaj-el chicaj riqꞌuin ri Rutataꞌ. Ri Jesús can altíra xaꞌrajoꞌ quinojiel ri i-richin jajaꞌ ri icꞌo vaveꞌ choch-ulief, y quireꞌ xuꞌon hasta cꞌa xcon. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Antok ri Jesús y ri discípulos ja ncaꞌvaꞌ chakꞌaꞌ, ri diablo ya ruyoꞌn chic pa ránima ri Judas Iscariote, ri rucꞌajuol ri Simón, chi tujachaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ri Jesús can rataꞌn chi nojiel jachuon-pa pa rukꞌaꞌ ruma ri Dios ri Rutataꞌ, y can rataꞌn chi riqꞌuin ri Dios patanak-ve y chireꞌ chic niꞌa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Y ri Jesús xutanabꞌaꞌ can ri ruvaꞌen, xpalaj y xralasaj-el ri tziak ri rukꞌuꞌn, xbꞌarucꞌama-pa jun tualla, y xuxim chupan. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Y xuyaꞌ jeꞌ yaꞌ chupan jun vacal y xutzꞌom ruchꞌajic ri cakan ri ru-discípulos, y nusuꞌ ri cakan cha ri tualla ri ruximuon chupan. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Y antok xalka riqꞌuin ri Simón Pedro chi nuchꞌaj ri rakan, ri Pedro xuꞌej cha ri Jesús: Ajaf, ¿atreꞌ nachꞌaj ri vakan inreꞌ? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xuꞌej cha ri Pedro: Ri nquinajin inreꞌ, man xtiꞌka ta pan aveꞌ (man xtaꞌan ta entender) vacame, pero chuaꞌk chi cabꞌij xtiꞌka pan aveꞌ (xtaꞌan entender). ");
INSERT INTO cakSNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero ri Pedro xuꞌej: Inreꞌ man xtinyaꞌ ta chi xtachꞌaj ri vakan, xchaꞌ. Y ri Jesús xuꞌej cha: Xa man nayaꞌ ta, man xcacꞌujieꞌ ta viqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Rumareꞌ ri Simón Pedro xuꞌej cha ri Jesús: Ajaf, xa quireꞌ, man joꞌc ta ri vakan nachꞌaj, xa tachꞌajaꞌ jeꞌ ri nukꞌaꞌ y ri nujaluon, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xuꞌej cha: Jun ri ya xatin, joꞌc chic ri rakan nuchꞌaj; ruma jajaꞌ can rujoskꞌin chic riꞌ. Ixreꞌ sak chic ri icꞌaslien, mesque man ixvonojiel ta, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jajaꞌ xuꞌej quireꞌ, ruma rataꞌn ri chica xtijacho richin. Y mareꞌ xuꞌej: Man ixvonojiel ta sak chic ri icꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y antok ri Jesús ruchꞌajuon chic cakan ri ru-discípulos, xbꞌarucꞌamaꞌ chic pa ri tziak ri ruchꞌiluon can chirij, xbꞌatzꞌuyeꞌ chic chirij ri mesa y xuꞌej: ¿Xiꞌka pan iveꞌ (xiꞌan entender) ri xinꞌan inreꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ixreꞌ, Maestro y Ajaf nquixchaꞌ chuva. Can otz ri ntiꞌej, ruma quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Y xa inreꞌ ri Maestro y ri Ajaf xinchꞌaj ri ivakan, quireꞌ mismo tibꞌanaꞌ ixreꞌ, tichꞌajaꞌ ivakan chivach-ka ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inreꞌ ya xincꞌut chivach. Can incheꞌl ri xinꞌan inreꞌ iviqꞌuin, can quireꞌ tibꞌanaꞌ ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Can ketzij, ketzij ri niꞌej chiva: Man jun samajiel más nem choch ri rajaf; ni ri takuon-el, más nem choch ri takayuon-el richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xa ixreꞌ xivatamaj can nojiel reꞌ y can ntiꞌan ri xivatamaj, can jaꞌal quixquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Man chivij ta ixvonojiel nquichꞌo-ve, ruma inreꞌ vataꞌn ivach ixreꞌ ri xixchaꞌ. Pero xtuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios ri nuꞌej: Ri jun ri xvaꞌ viqꞌuin, xpalaj chuvij. Quireꞌ nuꞌej chupan ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Reꞌ niꞌej yan chiva, chi quireꞌ antok xtalka ri kꞌij chi nibꞌanataj, xtinimaj chi inreꞌ ri Cristo. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can ketzij, ketzij ri niꞌej chiva: Ri xtibꞌano recibir ri nitak-el inreꞌ, can inreꞌ ri nquiruꞌon recibir y ri xquiruꞌon recibir inreꞌ, can nuꞌon recibir ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ, ri ránima can vor chica xunaꞌ. Jajaꞌ xuꞌej chica: Can ketzij, ketzij ri niꞌej chiva, chi jun chivach ixreꞌ ri xtijacho vichin, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Y ri discípulos xquicaꞌyiej-quiꞌ, y man niquil ta chica niquiꞌej, ruma man cataꞌn ta choj chirij xchꞌo-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Y ri jun chiquivach ri discípulos, ri altíra najoꞌx ruma ri Jesús, rakꞌal riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y cha ri jun discípulo reꞌ, xuꞌon-apa seña ri Simón Pedro, chi tucꞌutuj cha ri Jesús chi chica ri jun ri xtijacho richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri discípulo reꞌ xrakꞌie-apa cierca ri roch-rucꞌuꞌx ri Jesús, y xucꞌutuj cha: Ajaf, ¿chica ri jun ri xtijacho avichin? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Y ri Jesús xuꞌej cha ri discípulo reꞌ: Ri choj cha xtinya-ve jun pedazo simíta mubꞌan, jareꞌ ri xtijacho vichin. Y jajaꞌ xumubꞌaꞌ jun pedazo simíta y xuyaꞌ cha ri Judas Iscariote ri rucꞌajuol ri Simón. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y antok ri Judas Iscariote xucꞌux-ka ri simíta reꞌ, ja xuoc ri Satanás pa ránima. Y ri Jesús xuꞌej cha: Ri abꞌanun chic pensar chi naꞌan, tabꞌanaꞌ chaꞌnin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero ri discípulos ri icꞌo-apa chirij ri mesa riqꞌuin, man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) karruma quireꞌ xuꞌej cha ri Judas. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Icꞌo xquiꞌan-ka pensar chi xtak-el ruma ri Jesús chulokꞌic nojiel ri xticꞌatzin chica chupan ri namakꞌej, o chi tuyaꞌ miera chica ri i-puobra, ruma ijejeꞌ cataꞌn chi ja ri Judas ri niyaco ri miera. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ri Judas joꞌc xucꞌux-el ri jun pedazo simíta, ja xiel-el. Antok xiel-el jajaꞌ, can chakꞌaꞌ chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y antok ri Judas alanak chic el, ri Jesús xuꞌej: Ja xalka ri huora chi ri Xtak-pa chicaj chi xalax chiꞌicajol, xtikꞌalajin chi can cꞌo-ve rukꞌij. Y quireꞌ jeꞌ ri Dios, can xtikꞌalajin ri nem rukꞌij ruma jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y ri Dios can xtikꞌalajin ri rukꞌij ruma jajaꞌ, y ri Dios can xtuꞌon chi nikꞌalajin ri rukꞌij. Y reꞌ vacame. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Chꞌitak valcꞌual, xa jubꞌaꞌ chic oc tiempo ri xquicꞌujieꞌ iviqꞌuin. Ixreꞌ xquinicanuj; pero vacame niꞌej can chiva, incheꞌl ri nuꞌeꞌn chica nicꞌaj chic israelitas, chi ri pacheꞌ xquibꞌacꞌujie-ve inreꞌ, ixreꞌ man xquixtiquir ta xquixbꞌaka vacame. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Vacame niyaꞌ jun cꞌacꞌacꞌ mandamiento chiva: Can tivajo-iviꞌ. Can incheꞌl nquixvajoꞌ inreꞌ, can quireꞌ tibꞌanaꞌ ixreꞌ. Jareꞌ ri cꞌacꞌacꞌ mandamiento ri niyaꞌ can chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Y xa xtivajo-iviꞌ, ri vinak xtiquitzꞌat chi ix nu-discípulos inreꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Y ri Simón Pedro xuꞌej cha ri Jesús: Ajaf, ¿pacheꞌ cꞌa ncaꞌa-ve? xchaꞌ. Y ri Jesús xuꞌej cha: Vacame man ncatiquir ta ncaꞌa chuvij ri pacheꞌ xquiꞌa-ve inreꞌ. Pero después xcatiquir xcaꞌa chuvij, xchaꞌ cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Y ri Pedro xuꞌej cha: Ajaf, ¿karruma man nquitiquir ta nquiꞌa chavij vacame? Ruma xa nicꞌatzin chi niyaꞌ ri nucꞌaslien avuma atreꞌ, can xtinya-ve, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ri Jesús xuꞌej cha: ¿Nayaꞌ came ri acꞌaslien vuma inreꞌ? Inreꞌ can ketzij, ketzij ri niꞌej chava: Cꞌa majaꞌ titzirin-pa ri mamaꞌ, antok atreꞌ oxeꞌ yan mul taꞌej chica ri ncaꞌcꞌutun chava, chi man avataꞌn ta noch, xchaꞌ ri Jesús cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Man tichꞌujirisaj ri ivánima, xchaꞌ ri Jesús chica ri ru-discípulos. Inreꞌ vataꞌn chi iniman ri Dios. Quireꞌ jeꞌ tibꞌanaꞌ viqꞌuin inreꞌ. Can quininimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pa rachuoch ri Nataꞌ Dios qꞌuiy lugar cꞌo. Y xa man ta quireꞌ, xinꞌej yan ta chiva. Vacame nquiꞌa chi nichojmij ri i-lugar. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Y xa nquiꞌa inreꞌ, y nichojmij ri i-lugar, xquipa chic jun bꞌay y xquixvucꞌuaj viqꞌuin; chi quireꞌ, pacheꞌ xquicꞌujie-ve inreꞌ, chireꞌ jeꞌ xquixcꞌujie-ve ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ixreꞌ ivataꞌn pacheꞌ nquiꞌa-ve inreꞌ y ivataꞌn jeꞌ ri bꞌay, xchaꞌ ri Jesús chica ri ru-discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Y ri discípulo ri Tomás rubꞌeꞌ xuꞌej cha ri Jesús: Ajaf, ojreꞌ man kataꞌn ta pacheꞌ ncaꞌa-ve atreꞌ. ¿Cheꞌl chi kataꞌn ri bꞌay reꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Y ri Jesús xuꞌej: Inreꞌ ri bꞌay, inreꞌ ri ketzij, y inreꞌ ri cꞌaslien. Man jun xticovin xtibꞌaka riqꞌuin ri Nataꞌ xa man xquirunimaj ta inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Y xa ixreꞌ xivatamaj noch inreꞌ, can xivatamaj jeꞌ roch ri Nataꞌ. Y vacame can itzꞌatuon chic, y ivataꞌn chic roch, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Y ri Felipe, jun chic chiquivach ri discípulos, xuꞌej cha ri Jesús: Ajaf, tacꞌutuꞌ ri Atataꞌ Dios chakavach, y riqꞌuin reꞌ suficiente, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Y ri Jesús xuꞌej cha: ¿Qꞌuiy yan tiempo quicꞌujieꞌ iviqꞌuin, y man avataꞌn ta noch, atreꞌ Felipe? Ri tzꞌatayuon vichin, rutzꞌatuon jeꞌ ri Nataꞌ. ¿Karruma cꞌa atreꞌ naꞌej chi nicꞌut ri Nataꞌ chivach? ");
INSERT INTO cakSNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Man nanimaj ta atreꞌ chi ri Nataꞌ cꞌo viqꞌuin inreꞌ y inreꞌ incꞌo riqꞌuin jajaꞌ? Ri tzij ri xintzijuoj chivach, can riqꞌuin ri Nataꞌ patanak-ve, ruma jajaꞌ cꞌo viqꞌuin inreꞌ. Can jajaꞌ ri nibꞌano ri samaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Can quininimaj chi inreꞌ incꞌo riqꞌuin ri Nataꞌ y jajaꞌ cꞌo viqꞌuin inreꞌ. Y xa man nquininimaj ta ruma ri niꞌej chiva, titzꞌataꞌ cꞌa ri nusamaj y quininimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Can ketzij, ketzij ri niꞌej chiva: Ri xquirunimaj inreꞌ, xcaꞌruꞌon ri samaj ri xinꞌan inreꞌ; y can más nimaꞌk tak samaj xcaꞌruꞌon, ruma inreꞌ nquiꞌa riqꞌuin ri Nataꞌ chicaj, ");
INSERT INTO cakSNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","y nojiel ri xticꞌutuj cha ri Nataꞌ pa nubꞌeꞌ inreꞌ, can xtinꞌan. Chi quireꞌ nikꞌalajin ri rukꞌij ri Nataꞌ vuma inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xa cꞌo ri xticꞌutuj pa nubꞌeꞌ inreꞌ, can xtinya-pa chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Xa nquinivajoꞌ, can tibꞌanaꞌ nojiel ri nu-mandamientos. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y inreꞌ xtincꞌutuj cha ri Nataꞌ, y jajaꞌ xtutak-pa Jun chic ri xtitoꞌn ivichin. Jun ri can xticꞌujieꞌ iviqꞌuin richin nojiel tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Y reꞌ ja ri Espíritu Santo ri nquixrutijuoj riqꞌuin ri ketzij. Ri vinak ri man quiniman ta ri Dios man niquiꞌan ta recibir riqꞌuin cánima, ruma ri Espíritu Santo man niquitzꞌat ta, ni man cataꞌn ta jeꞌ roch. Pero ixreꞌ ri iniman chic, can ivataꞌn chic roch, ruma jajaꞌ cꞌo chic iviqꞌuin y xticꞌujieꞌ riqꞌuin ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Inreꞌ nquiꞌa, pero man xquixyaꞌ ta can iyuon incheꞌl jun mabꞌaꞌ, ruma xa nquipa chic iviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ri vinak ri man quiniman ta ri Dios, joꞌc chic jubꞌaꞌ xquinquitzꞌat, pero ixreꞌ xquinitzꞌat chic. Ruma inreꞌ cꞌo nucꞌaslien, ixreꞌ jeꞌ xticꞌujieꞌ icꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Y chupan ri kꞌij reꞌ, xtikꞌalajin otz chivach chi inreꞌ incꞌo riqꞌuin ri Nataꞌ, ixreꞌ ixcꞌo viqꞌuin inreꞌ y inreꞌ incꞌo iviqꞌuin ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ri cꞌo ri nuchꞌabꞌal pa ránima y ncaꞌruꞌon nojiel ri mandamientos ri ncaꞌnꞌej, can nquirajoꞌ. Y ri nquirajoꞌ inreꞌ, can xtajoꞌx ruma ri Nataꞌ, y inreꞌ jeꞌ can xtinvajoꞌ y xtincꞌut-viꞌ choch, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Y ri Judas, ri jun chiquivach ri ru-discípulos, pero man ja ta ri Iscariote, xucꞌutuj cha ri Jesús: Ajaf, ¿karruma joꞌc chakavach ojreꞌ xtacꞌut-ve-aviꞌ y man nacꞌut ta aviꞌ chiquivach ri vinak ri man quiniman ta ri Dios? ");
INSERT INTO cakSNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Y ri Jesús xuꞌej cha: Ri nquirajoꞌ, can nuꞌon ri nuꞌej ri nuchꞌabꞌal. Ri jun ri xtibꞌano quireꞌ, can xtajoꞌx ruma ri Nataꞌ. Y ri Nataꞌ y inreꞌ xkupa riqꞌuin y xtakaꞌan kachuoch riqꞌuin ránima. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ri man nquirajoꞌ ta, man nuꞌon ta ri nuꞌej ri nuchꞌabꞌal. Y ri chꞌabꞌal ri ivaxan viqꞌuin, man vichin ta inreꞌ; xa richin ri Nataꞌ ri takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Y nojiel ri chꞌabꞌal reꞌ, can nuꞌeꞌn-pa chivach. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Y antok inreꞌ man incꞌo ta chic iviqꞌuin, ri Nataꞌ xtutak-pa ri Espíritu Santo ri xtitoꞌn ivichin. Y jajaꞌ ri xticꞌujieꞌ iviqꞌuin pa nucꞌaxiel inreꞌ. Y jajaꞌ jeꞌ xquixrutijuoj y xtunataj chiva nojiel ri chꞌabꞌal ri i-nuꞌeꞌn can inreꞌ chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ri paz ri cꞌo viqꞌuin inreꞌ, niyaꞌ can chiva. Ri paz ri niyaꞌ can inreꞌ riqꞌuin ivánima, man incheꞌl ta ri paz ri niquiyaꞌ ri vinak. Man tichꞌujirisaj ri ivánima, y man tixiꞌij-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xivaxaj ri xinꞌej yan chiva: Inreꞌ xquiꞌa, pero nquitzalaj chic pa iviqꞌuin. Y xa ixreꞌ nquinivajoꞌ, nquixquicuot ta, ruma inreꞌ nuꞌeꞌn chi nquiꞌa riqꞌuin ri Nataꞌ. Jajaꞌ cꞌo más rukꞌij chinoch inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Reꞌ niꞌej yan can chiva, chi quireꞌ antok xtalka ri kꞌij reꞌ, xtinimaj ri nuꞌeꞌn can chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Y vacame man qꞌuiy ta chic ri chꞌabꞌal ri xtinꞌej can chiva, ruma ri tiempo xa man qꞌuiy ta chic. Ri Satanás, ri tzꞌamayuon ri roch-ulief, xa nucꞌut yan pa-riꞌ. Jajaꞌ man jun rukꞌaꞌ chuva. ");
INSERT INTO cakSNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Inreꞌ niꞌan ri nrajoꞌ ri Nataꞌ, chi quireꞌ ri vinak ri icꞌo choch-ulief niquitzꞌat chi inreꞌ nivajoꞌ ri Nataꞌ. Quixpalaj y kojiel-el vaveꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Y ri Jesús xuꞌej: Inreꞌ ri ketzij mata uva, y ri Nataꞌ jareꞌ ri samajiel. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Antok jun mata uva icꞌo rukꞌaꞌ ri man niquiyaꞌ ta quivach, ncaꞌlasas-el. Y ri rukꞌaꞌ ri can niquiyaꞌ quivach, ncaꞌjoskꞌis otz, chi quireꞌ niquiyaꞌ más quivach. Can quireꞌ jeꞌ inreꞌ. Ri Nataꞌ ncaꞌrutzꞌat quinojiel ri icꞌo viqꞌuin y ncaꞌralasaj-el ri man otz ta quicꞌaslien. Y ri otz quicꞌaslien, ncaꞌrujoskꞌij más, chi quireꞌ más otz nuꞌon ri quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ixreꞌ ri ya nucꞌutun-pa ri chꞌabꞌal chivach, can ix sak chic ruma ri chꞌabꞌal reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Can quireꞌ quixcꞌujieꞌ viqꞌuin, chi quireꞌ inreꞌ nquicꞌujieꞌ jeꞌ iviqꞌuin. Ruma jun rukꞌaꞌ ri uva man nicovin ta nuyaꞌ roch, xa man cꞌo ta chirij ri rakan. Xa nicꞌatzin chi ri rukꞌaꞌ ri uva nicꞌujieꞌ chirij ri rakan, chi quireꞌ nuyaꞌ roch. Can quireꞌ jeꞌ ixreꞌ, can nicꞌatzin chi siempre nquixcꞌujieꞌ viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Inreꞌ ri mata uva, y ixreꞌ ri rukꞌaꞌ. Ri can siempre cꞌo viqꞌuin y inreꞌ riqꞌuin jajaꞌ, ri rucꞌaslien can otz. Ruma ri man cꞌo ta viqꞌuin, man jun ri xtitiquir xtuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ri man nicꞌujieꞌ ta viqꞌuin, xtuꞌon incheꞌl ri rukꞌaꞌ ri uva ri man niquiyaꞌ ta quivach. Ncaꞌlasas-el, y antok i-chakeꞌj chic, ncaꞌbꞌamuol-pa y ncaꞌcꞌak pa kꞌakꞌ, y chireꞌ ncaꞌcꞌat-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Xa ixreꞌ xquixcꞌujieꞌ viqꞌuin y xtiꞌan ri niꞌej chiva, can ticꞌutuj cha ri Dios ri nurayij ri ivánima, y jajaꞌ xtuya-pa chiva ri nticꞌutuj. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Xa otz ri icꞌaslien, can kꞌalaj chi ketzij ix nu-discípulos. Y rumareꞌ ri xcaꞌtzꞌato ivichin, can xtiquiyaꞌ rukꞌij ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Can incheꞌl nquirajoꞌ ri Nataꞌ Dios, can quireꞌ jeꞌ nquixvajoꞌ inreꞌ. Can siempre quixcꞌujieꞌ chupan ri nu-amor. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Y xa ixreꞌ ntiꞌan ri nuꞌej ri nu-mandamientos, can siempre ixcꞌo chupan ri nu-amor. Incheꞌl ri nubꞌanun inreꞌ riqꞌuin ri Nataꞌ, inreꞌ can niꞌan ri nuꞌej ri ru-mandamientos, y siempre incꞌo chupan ri ru-amor. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Y nojiel ri nuꞌeꞌn chic chiva, richin cꞌa chi nquixquicuot, can incheꞌl nquiquicuot inreꞌ, y chi quireꞌ siempre nquixquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Inreꞌ niyaꞌ ri nu-mandamiento chiva, chi tivajo-iviꞌ, incheꞌl nquixvajoꞌ inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Man jun ri más nem ru-amor que choch ri jun ri nuyaꞌ ri rucꞌaslien pa quicꞌaxiel ri ru-amigos. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y ixreꞌ can ix nu-amigos, xa ntiꞌan nojiel ri niꞌej inreꞌ chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Ruma inreꞌ can ix nu-amigos nubꞌanun yan chiva, ruma nojiel ri ruꞌeꞌn-pa ri Nataꞌ chuva, inreꞌ can xintzijuoj yan chiva ixreꞌ. Man ix aj-nusamajiel ta chic. Ruma jun samajiel man rataꞌn ta ri chica nuꞌon pensar ri rajaf. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Inreꞌ ri xchoꞌn ivichin ixreꞌ, y man ixreꞌ ta ri xichoꞌn vichin inreꞌ. Y inreꞌ xixchaꞌ chi nquixtak chi ntiꞌan ri nusamaj y chi otz jeꞌ ri icꞌaslien, y reꞌ richin nojiel tiempo; chi quireꞌ chica-na ri xticꞌutuj cha ri Nataꞌ pa nubꞌeꞌ inreꞌ, jajaꞌ can xtuya-pa chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Can niꞌan cꞌa mandar chiva, chi can tivajo-iviꞌ chibꞌil-iviꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Y xa itziel nquixtzꞌiet cuma ri vinak ri man quiniman ta ri Dios, talka pan iveꞌ chi man joꞌc ta chiva ixreꞌ quireꞌ niꞌan, xa quireꞌ xꞌan chuva inreꞌ antes. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xa ta ix junan quiqꞌuin ri vinak ri man quiniman ta ri Dios, can ta nquixcajoꞌ. Pero vacame itziel nquixquitzꞌat, ruma man ix junan ta chic quiqꞌuin, y ruma inreꞌ xichoꞌn-pa ivichin chiquicajol ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Can talka pan iveꞌ chi vaveꞌ choch-ulief, man jun samajiel más nem choch ri rajaf. Y xa inreꞌ ri in Ivajaf, itziel nquitzꞌiet cuma ri vinak y man otz ta ri niquiꞌan chuva, ixreꞌ jeꞌ can quireꞌ xtiꞌan chiva. Y ri niquiꞌan ri nuꞌej ri nuchꞌabꞌal, can xtiquiꞌan jeꞌ ri ntiꞌej ixreꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Nojiel cꞌa ri sufrimiento reꞌ xtiquiꞌan chiva ruma man cataꞌn ta roch ri Dios ri takayuon-pa vichin. Can itziel nquixquitzꞌat ruma iyoꞌn ivánima viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Y xa man ta xipa inreꞌ choch-ulief chi xaltzijuoj ri nuchꞌabꞌal, manak ta qui-pecado. Pero vacame, ruma inreꞌ xipa choch-ulief, ijejeꞌ man xcaꞌtiquir ta xtiquiꞌej chi man jun qui-pecado. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ri itziel ncaꞌtzꞌato vichin, man joꞌc ta inreꞌ ri itziel nquinquitzꞌat, xa quireꞌ jeꞌ niquiꞌan cha ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Y man ta jun qui-pecado, xa ta inreꞌ man ta i-nubꞌanun nimaꞌk tak samaj ri man jun bꞌanayuon chiquivach. Pero ijejeꞌ can xquitzꞌat yan ri samaj reꞌ y man in-quiniman ta. Xa itziel nquinquitzꞌat y itziel jeꞌ niquitzꞌat ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nojiel reꞌ nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, ri nuꞌej: Itziel xinquitzꞌat, mesque man jun nuchꞌoꞌj. Quireꞌ nuꞌej chupan ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pero antok inreꞌ xquitzalaj chic chila riqꞌuin ri Nataꞌ, xtintak-pa ri Espíritu Santo ri xtitoꞌn ivichin, y jajaꞌ xquirutzijuoj, y xquixrutijuoj jeꞌ riqꞌuin ri ketzij. Y jajaꞌ riqꞌuin ri Nataꞌ xtipa-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Y ixreꞌ can xquinitzijuoj jeꞌ, ruma antok xintzꞌuc-pa ri nusamaj, ixcꞌo viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Y nojiel reꞌ xinꞌej chiva, chi quireꞌ man jun chivach ixreꞌ ri xtitzak. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ruma xquixkotax-pa pa tak sinagogas; y xtalka ri huora antok ri vinak xtiquiꞌan pensar chi rusamaj ri Dios niquiꞌan antok nquixquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Quireꞌ xtiquiꞌan ri vinak, ruma man cataꞌn ta roch ri Nataꞌ y man cataꞌn ta jeꞌ noch inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Can nojiel reꞌ niꞌej can chiva, chi quireꞌ antok xtalka ri huora, xtalka pan iveꞌ chi ketzij ri xinꞌej can chiva. Nojiel reꞌ man nuꞌeꞌn ta chiva antes, ruma cꞌa incꞌo iviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero vacame, ja nquiꞌa riqꞌuin ri takayuon-pa vichin. Y man jun chivach ixreꞌ nicꞌutun-pa chuva: ¿Pacheꞌ cꞌa ncaꞌa-ve? ");
INSERT INTO cakSNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pa rucꞌaxiel reꞌ, xa nojnak ri ivánima riqꞌuin bꞌis, ruma ri xinꞌej chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero inreꞌ ketzij ri niꞌej chiva: Can otz nuꞌon chiva chi nquiꞌa yan; ruma xa man nquiꞌa ta, man nipa ta ri Espíritu Santo ri xtitoꞌn ivichin. Pero xa nquiꞌa yan, ja nitak-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Y antok xtalka ri Espíritu Santo, can xtuꞌej chiquivach ri vinak ri man quiniman ta ri Dios chi cꞌo qui-pecado, chi cꞌo jun choj bꞌay richin cꞌaslien, y chi ri Dios xcaꞌruꞌon condenar ri vinak ri man ncaꞌniman ta richin. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Jajaꞌ xtuꞌej chiquivach ri vinak chi cꞌo qui-pecado, ruma man nquinquinimaj ta inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Can xtuꞌej cꞌa chiquivach ri vinak chi cꞌo jun choj bꞌay richin cꞌaslien, ruma inreꞌ riqꞌuin ri Nataꞌ nquiꞌa-ve. Y ixreꞌ man xquinitzꞌat ta chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y jajaꞌ jeꞌ xtuꞌej chi ri Dios xcaꞌruꞌon condenar ri vinak ri man ncaꞌniman ta richin, ruma vacame ri Satanás, ri tzꞌamayuon ri roch-ulief, ya xꞌan condenar. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Cꞌo cꞌa qꞌuiy ri man niꞌej ta can chiva, ruma vacame man nquixtiquir ta ntiꞌan entender. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero antok xtipa ri Espíritu Santo, can xquixrutijuoj y xquixrucꞌuaj chupan ri ketzij. Jajaꞌ man ruyuon ta xtisamaj; ruma ri chꞌabꞌal ri xtuꞌej chiva, ja ri i-bꞌeꞌn-pa cha chicaj. Y rumareꞌ jajaꞌ xtuꞌej chiva ri xcaꞌbꞌanataj chupan ri tiempo ri chivach-apa. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Y jajaꞌ xtuyaꞌ nukꞌij inreꞌ; ruma xtuꞌon recibir ri vichin inreꞌ, y xtuꞌej chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ruma nojiel ri cꞌo riqꞌuin ri Nataꞌ, can vichin inreꞌ, y rumareꞌ inreꞌ xinꞌej yan chiva chi ri Espíritu Santo xtuꞌon recibir ri vichin inreꞌ, y xtuꞌej chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Vacame joꞌc chic jubꞌaꞌ tiempo xquinitzꞌat, ruma nquiꞌa; pero xtakꞌax chic jubꞌaꞌ tiempo, y ja xquinitzꞌat chic jun bꞌay. Quireꞌ niꞌej chiva ruma nquiꞌa riqꞌuin ri Nataꞌ Dios, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Y nicꞌaj ru-discípulos xquicꞌutuj chiquivach: ¿Chica cꞌa ri xrajoꞌ xuꞌej chika riqꞌuin ri xaꞌruꞌej? Vacame joꞌc chic jubꞌaꞌ tiempo xquinitzꞌat, ruma nquiꞌa; pero xtakꞌax chic jubꞌaꞌ tiempo, y ja xquinitzꞌat chic jun bꞌay; ruma nquiꞌa riqꞌuin ri Nataꞌ Dios, xaꞌchaꞌ ri discípulos chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Y niquiꞌej jeꞌ chiquivach: ¿Chica cꞌa nrajoꞌ nuꞌej riqꞌuin ri xuꞌej: Joꞌc chic jubꞌaꞌ tiempo? Xa man niꞌka ta pa kaveꞌ (man nakaꞌan ta entender) ri nuꞌej, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Y ri Jesús chaꞌnin xuyaꞌ cuenta choch chi ri ru-discípulos cꞌo ri nicajoꞌ niquicꞌutuj cha, rumareꞌ jajaꞌ xuꞌej: Ixreꞌ ntivajoꞌ ntinaꞌiej chica ri xinꞌej, chi vacame joꞌc chic jubꞌaꞌ tiempo xquinitzꞌat, ruma nquiꞌa; pero xtakꞌax chic jubꞌaꞌ tiempo, y ja xquinitzꞌat chic jun bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Can ketzij, ketzij ri niꞌej chiva, chi ixreꞌ can xquixuokꞌ y xquixbꞌisuon ruma nojiel ri xtiꞌan chuva inreꞌ. Pero ri vinak ri man quiniman ta ri Dios xcaꞌquicuot rumareꞌ. Pero mesque ixreꞌ nem ri bꞌis ri cꞌo riqꞌuin ivánima, ri bꞌis xa xticꞌaxtaj, y pa rucꞌaxiel ri bꞌis xa xquixquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ri bꞌis reꞌ junan riqꞌuin ri ruquiy ri nunaꞌ jun ixok antok nalka ri huora chi nicꞌujieꞌ ruxuluꞌ. Antok ri acꞌual ya xalax, ri ixok man nalka ta chic paroꞌ chica sufrimiento ri xukꞌasaj, ruma altíra niquicuot chi xalax jun chic acꞌual choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quireꞌ jeꞌ ixreꞌ, vacame cꞌo bꞌis pa tak ivánima, pero nquipa chic jun bꞌay iviqꞌuin chi nquixaltzꞌataꞌ. Y antok xquipa iviqꞌuin, ja xtiquicuot chic jun bꞌay ri ivánima, y reꞌ man jun xtitiquir xtalasan-el pa tak ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Y chupan ri kꞌij reꞌ, man chuva ta inreꞌ xticꞌutuj-ve jun kax. Can ketzij, ketzij ri niꞌej chiva, chi nojiel ri xticꞌutuj cha ri Nataꞌ pa nubꞌeꞌ inreꞌ, jajaꞌ can xtuya-pa chiva. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Y cꞌa vacame man jun cꞌa kax icꞌutun cha ri Nataꞌ pa nubꞌeꞌ. Can ticꞌutuj cꞌa y xtiyoꞌx chiva ri nticꞌutuj. Chi quireꞌ más xtiquicuot ri ivánima. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nojiel ri nuꞌeꞌn chic chiva, riqꞌuin parábolas (cꞌambꞌal-tzij), pero xtalka ri kꞌij antok man quireꞌ ta chic xquichꞌoꞌ chivach. Xa kꞌalaj ri rubꞌixic xtinꞌan chivach chirij ri Nataꞌ Dios. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Y chupan ri kꞌij reꞌ, can pa nubꞌeꞌ inreꞌ xticꞌutuj cha ri Nataꞌ, y jajaꞌ xtuya-pa chiva ri nticꞌutuj cha. Y man inreꞌ ta chic xquicꞌutun pan i-cuenta cha ri Nataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ri Nataꞌ mismo xtuyaꞌ chiva ri nticꞌutuj cha, ruma altíra nquixrajoꞌ. Y jajaꞌ altíra nquixrajoꞌ, ruma ixreꞌ nquinivajoꞌ inreꞌ y ruma ntinimaj chi inreꞌ riqꞌuin jajaꞌ in-patanak-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Can riqꞌuin ri Nataꞌ Dios in-patanak-ve chi xinalka choch-ulief. Y vacame riqꞌuin jajaꞌ nquitzalaj chic, y niyaꞌ can ri roch-ulief, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Y ri ru-discípulos xquiꞌej cha: Can ketzij chi vacame man cuesta ta chi niꞌka pa kaveꞌ (nakaꞌan entender) ri xaꞌej, vacame xa can kꞌalaj nojiel ri xaꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Vacame niꞌka pa kaveꞌ (nakaꞌan entender) chi atreꞌ nojiel cꞌa avataꞌn. Man nicꞌatzin ta chi cꞌa nakacꞌutuj chava. Y rumareꞌ ojreꞌ can nakanimaj chi riqꞌuin ri Dios at-patanak-ve, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Y ri Jesús xuꞌej chica ri discípulos: ¿Can ntinimaj came? ");
INSERT INTO cakSNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ruma can ketzij niꞌej chiva chi ri huora nipa, y ja xalka, chi ixreꞌ xtiquiraj-el-iviꞌ y xquiniyaꞌ can nuyuon inreꞌ. Pero man nuyuon ta xquicꞌujieꞌ can, ruma ri Nataꞌ cꞌo viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Y nojiel cꞌa reꞌ xinꞌej chiva, chi nicꞌujieꞌ ri paz riqꞌuin ivánima, ruma xa jun ibꞌanun viqꞌuin. Y niꞌej can jeꞌ chiva, chi choch ri ulief xtikꞌasaj sufrimiento. Pero ruma inreꞌ ya xichꞌacuon chirij ri Satanás, ri tzꞌamayuon ri roch-ulief, rumareꞌ ticukubꞌaꞌ icꞌuꞌx viqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ, xtzuꞌn chicaj chi xuꞌon orar, y xuꞌej: Nataꞌ Dios, ri nu-huora ja xalka. Vacame tabꞌanaꞌ chuva inreꞌ ri in Acꞌajuol chi nikꞌalajin ri nukꞌij; chi quireꞌ, inreꞌ ri in Acꞌajuol can quireꞌ jeꞌ xtinꞌan, chi xtikꞌalajin ri akꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ruma can ayoꞌn-pa poder pa nukꞌaꞌ chi nquicꞌujieꞌ pa quiveꞌ quinojiel vinak y chi niyaꞌ ri cꞌaslien ri man niqꞌuis ta chica ri vinak ri can i-ayoꞌn chic chuva. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Y jareꞌ ri cꞌaslien ri man niqꞌuis ta: Chi niquitamaj avach atreꞌ Nataꞌ Dios y niquitamaj jeꞌ noch inreꞌ. Ruma atreꞌ ri ketzij Dios y man jun chic Dios cꞌo, y inreꞌ ri Jesucristo ri xinatak-pa choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inreꞌ xinyaꞌ yan akꞌij vaveꞌ choch-ulief. Y xinqꞌuis yan jeꞌ nojiel ri samaj ri aꞌeꞌn-pa chuva. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Vacame cꞌa Nataꞌ Dios, tabꞌanaꞌ chi nikꞌalajin ri nukꞌij aviqꞌuin, incheꞌl ri nukꞌij ri cꞌo antok cꞌa majaꞌ cꞌo ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Can xincꞌut cꞌa ri abꞌeꞌ chica ri achiꞌaꞌ ri xaꞌyaꞌ chuva, ri i-achoꞌn chic pa atreꞌ chiquicajol ri icꞌo choch-ulief. Ri achiꞌaꞌ reꞌ, can i-avichin atreꞌ, y xaꞌyaꞌ chuva inreꞌ. Y vacame ijejeꞌ niquiꞌan ri nuꞌej ri achꞌabꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ri achiꞌaꞌ reꞌ, cataꞌn chic chi nojiel ri ayoꞌn-pa chuva, can aviqꞌuin atreꞌ patanak-ve. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ruma ja ri chꞌabꞌal ri ayoꞌn-pa chuva chi niꞌej, jareꞌ ri xinꞌej chiquivach ri achiꞌaꞌ reꞌ. Y ijejeꞌ xquiꞌan recibir, y xquitamaj chi ketzij chi aviqꞌuin atreꞌ Nataꞌ Dios in-patanak-ve. Can xquinimaj cꞌa chi atreꞌ ri at-takayuon-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Inreꞌ nicꞌutuj chava pa qui-cuenta ijejeꞌ vacame, y man pa qui-cuenta ta ri vinak ri man at-quiniman ta. Can pa qui-cuenta ri achiꞌaꞌ ri xaꞌyaꞌ chuva nicꞌutuj chava, ruma can i-avichin atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Y quinojiel ri i-vichin inreꞌ, can i-avichin atreꞌ, y ri i-avichin atreꞌ, can i-vichin inreꞌ. Y inreꞌ xkꞌalajin yan ri nukꞌij cuma ri achiꞌaꞌ ri xaꞌyaꞌ chuva. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Santo Nataꞌ, pan akꞌaꞌ ncaꞌnjach-ve can ri achiꞌaꞌ ri xaꞌyaꞌ chuva. Caꞌchajij, chi quireꞌ can junan ta cánima y joꞌc jun ta niquiꞌan. Can niquiꞌan ta incheꞌl kabꞌanun ojreꞌ, ruma ojreꞌ joꞌc jun kabꞌanun. Caꞌchajij cꞌa, ruma ijejeꞌ cꞌa ncaꞌcꞌujieꞌ can choch-ulief, y inreꞌ ya nquitzalaj-el aviqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Y inreꞌ, i-nuchajin-pa ri achiꞌaꞌ ri xaꞌyaꞌ chuva. Ri tiempo ri xicꞌujieꞌ quiqꞌuin choch-ulief, can xaꞌnchajij pan abꞌeꞌ. Y man jun cꞌa xsach can chiquivach, xa joꞌc ri jun ri itziel xuꞌon y ja ri camic xuchaꞌ; chi nuꞌon cumplir incheꞌl ri tzꞌibꞌan can chupan ri achꞌabꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Inreꞌ ja nquitzalaj-el aviqꞌuin, pero ruma ri cꞌa nquicꞌujieꞌ jubꞌaꞌ choch-ulief, niꞌej reꞌ chiquivach, ruma nivajoꞌ chi niquicuot can ri cánima. Can incheꞌl nquiquicuot inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ri achiꞌaꞌ ri xaꞌyaꞌ chuva, can nuyoꞌn ri achꞌabꞌal chica. Rumareꞌ ri vinak ri man at-quiniman ta, can itziel xaꞌquitzꞌat; ruma ri achiꞌaꞌ ri xaꞌyaꞌ chuva, man i-richin ta chic ri roch-ulief. Ijejeꞌ can i-incheꞌl chic inreꞌ, ruma inreꞌ man in richin ta jeꞌ ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man nicꞌutuj ta chava chi caꞌvalasaj-el choch-ulief. Ri nicꞌutuj chava, xa caꞌtoꞌ choch ri itziel y man tayaꞌ lugar chi ncaꞌruchꞌec. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ri achiꞌaꞌ ri xaꞌyaꞌ chuva, man i-richin ta chic ri roch-ulief, i-incheꞌl inreꞌ, y inreꞌ man in richin ta jeꞌ ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Can tabꞌanaꞌ chica chi niquijach-quiꞌ más chupan ri achꞌabꞌal. Ri achꞌabꞌal jareꞌ ri ketzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Y can incheꞌl ri xaꞌan-pa chuva inreꞌ chi xinatak-pa chi niꞌan ri asamaj choch-ulief, quireꞌ jeꞌ niꞌan inreꞌ chica ri achiꞌaꞌ ri xaꞌyaꞌ chuva. Can i-nutakuon-el chi niquiꞌan ri asamaj choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cuma ijejeꞌ, inreꞌ nijach-viꞌ pan akꞌaꞌ, chi quireꞌ jeꞌ niquiꞌan ijejeꞌ. Can tiquijacha-quiꞌ pan akꞌaꞌ chi ncaꞌcꞌujieꞌ chupan ri ketzij. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Inreꞌ man joꞌc ta pa qui-cuenta ri achiꞌaꞌ ri xaꞌyaꞌ chuva nicꞌutuj chava, xa quireꞌ jeꞌ nicꞌutuj chava pa qui-cuenta quinojiel ri xcaꞌniman vichin ruma ri chꞌabꞌal ri xtiquitzijuoj ijejeꞌ; ");
INSERT INTO cakSNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","chi quinojiel can junan ta cánima. Can joꞌc ta jun xtiquiꞌan, incheꞌl kabꞌanun ojreꞌ. Ruma atreꞌ Nataꞌ Dios atcꞌo viqꞌuin, y inreꞌ incꞌo aviqꞌuin atreꞌ. Quireꞌ nivajoꞌ chi niquiꞌan ta ijejeꞌ kiqꞌuin ojreꞌ. Y quireꞌ nikꞌalajin chiquivach ri vinak ri man at-quiniman ta, chi atreꞌ ri xatako-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ri akꞌij atreꞌ ri ayoꞌn-pa chuva inreꞌ, can xinyaꞌ yan chica. Rumareꞌ cꞌo chic quikꞌij jeꞌ; chi quireꞌ joꞌc ta jun xtiquiꞌan, incheꞌl kabꞌanun ojreꞌ, joꞌc jun kabꞌanun. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Can xquicꞌujieꞌ quiqꞌuin ijejeꞌ y atreꞌ viqꞌuin inreꞌ, chi quireꞌ ijejeꞌ can joꞌc ta jun xtiquiꞌan. Y cuma ijejeꞌ, ri vinak ri man at-quiniman ta xtiquitamaj chi inreꞌ can atreꞌ Nataꞌ Dios ri xatako-pa vichin. Y xtiquitamaj ri vinak chi ncaꞌvajoꞌ, incheꞌl nquinavajoꞌ inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nataꞌ Dios, inreꞌ nivajoꞌ chi quinojiel ri i-ayoꞌn chuva xcaꞌbꞌacꞌujieꞌ viqꞌuin chicaj, chi niquitzꞌat ri nukꞌij ri ayoꞌn, ruma in avajoꞌn-pa antok cꞌa majaꞌ cꞌo ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nataꞌ Dios, atreꞌ ri at choj riqꞌuin nojiel, ri vinak ri man at-quiniman ta man cataꞌn ta avach. Pero inreꞌ vataꞌn avach, y ri achiꞌaꞌ ri xaꞌyaꞌ chuva xquitamaj jeꞌ chi atreꞌ ri xatako-pa vichin. ");
INSERT INTO cakSNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Y nucꞌutun cꞌa ri abꞌeꞌ chiquivach, y nicꞌut más; chi quireꞌ can incheꞌl nquinavajoꞌ inreꞌ, can quireꞌ jeꞌ caꞌvajoꞌ ijejeꞌ, y inreꞌ xquicꞌujieꞌ quiqꞌuin ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ, jajaꞌ y ri ru-discípulos xaꞌiel-el, y xaꞌkꞌax-apa jucꞌan ri río coꞌl-oc ri niꞌeꞌx Cedrón cha. Chireꞌ cꞌo jun huerto y chireꞌ xaꞌuoc-oc. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri Judas, ri nijacho richin ri Jesús, rataꞌn cꞌa ri lugar, ruma ri Jesús qꞌuiy mul i-rucꞌuan ri ru-discípulos chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Rumareꞌ ri Judas xaꞌrucꞌuaj cꞌa chupan ri lugar reꞌ, iqꞌuiy soldados y nicꞌaj chiquivach ri chajiniel richin ri templo ri xaꞌtak-el cuma ri principales sacerdotes y cuma jeꞌ ri achiꞌaꞌ fariseos. Ri soldados y ri chajiniel can quicꞌamun-pa lámparas y antorchas y quicꞌamun jeꞌ pa lanzas y espadas. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Y ri Jesús rataꞌn chic cꞌa nojiel ri chica xtukꞌasaj. Rumareꞌ xaꞌbꞌarucꞌuluꞌ ri i-patanak y xucꞌutuj chica: ¿Chica nticanuj? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Ijejeꞌ xquiꞌej: Ja ri Jesús ri aj-Nazaret ri nakacanuj, xaꞌchaꞌ. Y ri Jesús xuꞌej chica: Inreꞌ, xchaꞌ. Y ri Judas ri nijacho ri Jesús, can cꞌo jeꞌ chiquicajol ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Y antok ri Jesús xuꞌej chica: Inreꞌ; ri vinak xaꞌjiel chiquij, y xaꞌtzak pan ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Y ri Jesús xucꞌutuj chic jun bꞌay chica: ¿Chica ri nticanuj? xchaꞌ. Y ri vinak reꞌ xquiꞌej chic: Ja ri Jesús ri aj-Nazaret ri nakacanuj, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Y ri Jesús xuꞌej chica: Can ya xivaxaj ri xinꞌej chiva chi inreꞌ. Y xa inreꞌ ri nquinicanuj, tiyaꞌ lugar chica ri icꞌo viqꞌuin chi caꞌa, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Quireꞌ xuꞌej ri Jesús, chi quireꞌ nuꞌon cumplir incheꞌl ri ruꞌeꞌn. Jajaꞌ can ruꞌeꞌn cꞌa: Chiquivach ri achiꞌaꞌ ri xaꞌyaꞌ chuva, man jun xsach can chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pero ri Simón Pedro rucꞌuan jun espada, y xralasaj-el y xusoc ri ru-esclavo ri sacerdote ri más cꞌo rukꞌij, y xralasaj-el ri ruxiquin derecha. Y ri esclavo reꞌ Malco rubꞌeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Y ri Jesús xuꞌej cha ri Pedro: Tayacaꞌ la av-espada chupan ri ru-vaina. ¿Atreꞌ naꞌan pensar chi ruma la xaꞌan, inreꞌ can nquicolotaj choch ri sufrimiento ri ruꞌeꞌn-pa ri Nataꞌ chi nikꞌasaj? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Y ri iqꞌuiy soldados y ri qui-jefe, y ri chajiniel ri i-quitakuon-pa ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, xquitzꞌom ri Jesús y xquixim-el. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Naꞌay xquicꞌuaj choch ri Anás, ruma ri Anás rujiꞌnan ri Caifás. Y ri tiempo reꞌ ja ri Caifás ri sacerdote ri más cꞌo rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Y ja ri Caifás ri bꞌiyuon chica ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas, chi más otz chi joꞌc jun ri nicon pa qui-cuenta quinojiel ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro y jun chic discípulo i-bꞌanak chirij ri Jesús. Ri jun chic discípulo can ataꞌn roch ruma ri sacerdote ri más cꞌo rukꞌij, rumareꞌ choj xuoc chirachuoch ri sacerdote ri más cꞌo rukꞌij, y xcꞌujieꞌ chojay. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero ri Pedro man xuoc ta oc, xa xcꞌujieꞌ can chuchiꞌ ri puerta. Y ri discípulo ri ataꞌn roch ruma ri sacerdote ri más cꞌo rukꞌij, xiel chic pa y xchꞌoꞌ cha ri ixok ri nuchajij ri puerta y xucusaj-oc ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Y ri xtan aj-chi-icꞌ ri nicꞌujieꞌ chuchiꞌ ri puerta xuꞌej cha ri Pedro: ¿Man at jun ta jeꞌ chiquivach ri ru-discípulos ri ache ri cꞌamun-pa? xchaꞌ cha. Pero jajaꞌ xuꞌej: Inreꞌ man in ru-discípulo ta, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ri ru-esclavos ri icꞌo chupan ri jay reꞌ y ri alguaciles ri xquicꞌam-pa ri Jesús, quibꞌaxuon jun kꞌakꞌ y i-paꞌl-apa chuchiꞌ chi niquimakꞌ-quiꞌ ruma ri tief. Y ri Pedro jeꞌ paꞌl-apa chiquicajol, rumakꞌuon-apa-riꞌ chuchiꞌ ri kꞌakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri Anás ri sacerdote ri más cꞌo rukꞌij, xucꞌutuj cha ri Jesús chirij ri chica niquiꞌan ri ru-discípulos y xucꞌutuj jeꞌ cha chirij ri ncaꞌrucꞌut chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Xpa ri Jesús xuꞌej: Inreꞌ can kꞌalaj xichꞌoꞌ chiquivach quinojiel vinak. In-chꞌovinak chiquivach pa templo y pa tak sinagogas, ri pacheꞌ niquimol-ve-quiꞌ quinojiel ri israelitas. Can man jun kax pan aval xichꞌoꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Karruma atreꞌ xa chuva inreꞌ nacꞌutuj-ve? Tacꞌutuj chica ri xaꞌcꞌaxan vichin, y ijejeꞌ ncaꞌeꞌn ri chica nutzijuon chica. Ijejeꞌ can cataꞌn ri chica nuꞌeꞌn inreꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Y antok ri Jesús ruꞌeꞌn chic reꞌ, jun chiquivach ri chajiniel ri cꞌo chireꞌ cierca, xupaj rutzubꞌal ri Jesús y xuꞌej cha: ¿Karruma cala naꞌej-apa cha la sacerdote ri más cꞌo rukꞌij? ");
INSERT INTO cakSNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pero ri Jesús xuꞌej cha ri chajiniel reꞌ: Xa cꞌo jun tzij ri man otz ta xinꞌej-apa cha, taꞌej cꞌa ri chica ri man otz ta ri xinꞌej-apa. Y xa nojiel ri xinꞌej-apa otz, ¿karruma xinachꞌey? ");
INSERT INTO cakSNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Y ri Anás xutak ri Jesús ximuon, cha ri Caifás, ri sacerdote ri más cꞌo rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Y ri Pedro paꞌl-apa chuchiꞌ ri kꞌakꞌ numakꞌ-riꞌ. Y icꞌo ri xaꞌcꞌutun cha: ¿Man at jun ta chiquivach ri ru-discípulos ri ache la? xaꞌchaꞌ cha. Y jajaꞌ man xuꞌej ta ri ketzij, ruma xuꞌej: Man inreꞌ ta, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Y jun chiquivach ri ru-esclavos ri sacerdote ri más cꞌo rukꞌij, rachꞌalal ri ache ri xalasas ri ruxiquin ruma ri Pedro, xucꞌutuj cha ri Pedro y xuꞌej: ¿Man atreꞌ ta cꞌa ri xantzꞌat chi atcꞌo riqꞌuin ri Jesús chireꞌ pacheꞌ xbꞌakatzꞌama-pa? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pero ri Pedro jun chic bꞌay man xuꞌej ta ri ketzij. Y jareꞌ antok xtzirin-pa ri mamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Y ri Jesús xalasas cꞌa el pa rachuoch ri Caifás y xucꞌuax pa ru-palacio ri Pilato ri gobernador. Y cꞌa cumaj yan antok xbꞌanataj reꞌ. Ri i-cꞌuayuon richin ri Jesús man xaꞌuoc ta oc chupan ri palacio, chi quireꞌ man nuꞌon ta tzꞌil ri quicꞌaslien, y chi quireꞌ ijejeꞌ cꞌo cheꞌl niquitej ri nitij chupan ri namakꞌej Pascua. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Y ri Pilato xbꞌaꞌiel-pa y xucꞌutuj chica ri i-cꞌamayuon-pa richin ri Jesús: ¿Chica ri acusación ri icꞌamun-pa chirij ri jun ache reꞌ? xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Y ri vinak ri i-cꞌamayuon-apa richin ri Jesús xquiꞌej cha: Xa ta ri ache reꞌ manak ta ruchꞌoꞌj, man ta xalkayaꞌ pan akꞌaꞌ, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Y ri Pilato xuꞌej chica: Tivucꞌuaj chic ri ache reꞌ y tibꞌanaꞌ juzgar ixreꞌ incheꞌl ri nuꞌej ri i-ley, xchaꞌ chica. Pero ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej cha: Ojreꞌ man jun ley pa kakꞌaꞌ chi nakaꞌej chi tiquimisas jun vinak. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Y quireꞌ nuꞌon cumplir incheꞌl ri ruꞌeꞌn chic ri Jesús, chi chica manera xtiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Y ri Pilato xuoc chic oc chupan ri ru-palacio. Y xrayuoj ri Jesús y xucꞌutuj cha: ¿Atreꞌ ri Qui-Rey ri israelitas? ");
INSERT INTO cakSNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pero ri Jesús xuꞌej cha ri Pilato: ¿Ri nacꞌutuj chuva, aviqꞌuin atreꞌ xiel-pa, o xa nicꞌaj chic ri xaꞌeꞌn chava? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Y ri Pilato xuꞌej cha ri Jesús: Inreꞌ man in israelita ta, xa ja ri avanakil y ri principales sacerdotes ri xaꞌjacho avichin pa nukꞌaꞌ. ¿Chica chꞌoꞌj abꞌanun? ");
INSERT INTO cakSNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Y ri Jesús xuꞌej cha ri Pilato: Inreꞌ man in rey ta richin ri roch-ulief. Ruma xa ta in rey richin ri roch-ulief, quinojiel ta ri nusamajiel niquiꞌan guerra, chi quireꞌ man nquijach ta pa quikꞌaꞌ ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas. Inreꞌ man in rey ta richin ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Y ri Pilato xucꞌutuj cha ri Jesús: ¿Entonces atreꞌ can at rey cꞌa? xchaꞌ. Y ri Jesús xuꞌej cha: Atreꞌ ncaꞌeꞌn chi in rey inreꞌ. Can rumareꞌ xinalax y ruma jeꞌ reꞌ xipa choch-ulief chi nitzijuoj ri ketzij chiquivach ri vinak. Y quinojiel ri ncaꞌniman ri ketzij, can niquiꞌan ri niꞌej inreꞌ chica, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Y ri Pilato xucꞌutuj chic cha ri Jesús: ¿Chica ri ketzij? Y antok ruꞌeꞌn chic quireꞌ cha ri Jesús, jajaꞌ xiel chic cꞌa el chupan ri ru-palacio chi xbꞌachꞌoꞌ chica ri vinak israelitas y xuꞌej chica: Inreꞌ man jun chꞌoꞌj nivil chirij ri jun ache reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero juna-junaꞌ chupan ri namakꞌej Pascua, ixreꞌ cꞌo jun i-costumbre chi nticꞌutuj chuva chi nitzokopij-el jun chiquivach ri icꞌo pa cárcel. ¿Ntivajoꞌ ixreꞌ chi nitzokopij-el ri I-Rey ixreꞌ ri israelitas? ");
INSERT INTO cakSNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pero ri vinak reꞌ, can riqꞌuin nojiel quichukꞌaꞌ xaꞌchꞌoꞌ chic apa cha ri Pilato y xquiꞌej: Ja ri Barrabás tatzokopij-el y man ja ta ri ache reꞌ, xaꞌchaꞌ. Y ri Barrabás xa jun alakꞌuon. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Y rumareꞌ ri Pilato, ri gobernador, xuꞌej chi tichꞌay ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Y ri soldados xquipachꞌuj jun kꞌayis ri altíra ruqꞌuixal; y xquiꞌan jun corona cha, y xquiyaꞌ pa rujaluon ri Jesús. Y xquiyaꞌ jun tziak morado chirij ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Y ri soldados niquiꞌej cha ri Jesús: ¡Caquicuot, atreꞌ ri Qui-Rey ri israelitas! Y can niquipaj rutzubꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri Pilato xiel chic pa jun bꞌay chupan ri ru-palacio chi xalchꞌoꞌ chiquivach ri vinak, y jajaꞌ xuꞌej chica: Titzꞌataꞌ, ja ache reꞌ nivalasaj-pa chivach, chi tivatamaj chi man jun chꞌoꞌj nivil chirij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Y antok ri Jesús xbꞌaꞌiel-pa, rucusan ri corona ri bꞌanun cha ri kꞌayis ri altíra ruqꞌuixal, y rucusan ri tziak morado. Y jareꞌ antok ri Pilato xuꞌej: ¡Ja ache va! xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Antok ri principales sacerdotes y ri chajiniel xquitzꞌat ri Jesús, can riqꞌuin nojiel quichukꞌaꞌ xaꞌchꞌo-apa y xquiꞌej: ¡Tiꞌan crucificar! ¡Tiꞌan crucificar! xaꞌchaꞌ. Y ri Pilato xuꞌej chica: Tivucꞌuaj cꞌa ixreꞌ y tibꞌanaꞌ crucificar, ruma inreꞌ man jun chꞌoꞌj nivil chirij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero ri achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas xquiꞌej-apa cha ri gobernador: Jajaꞌ nuꞌej chi Rucꞌajuol ri Dios, rumareꞌ otz chi niquimisas, ruma quireꞌ nuꞌej ri ka-ley, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Antok ri Pilato xraꞌxaj ri xquiꞌej ri vinak chi ri Jesús nuꞌej chi Rucꞌajuol ri Dios, más xuxiꞌij-ka-riꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Rumareꞌ xuoc chic oc jun bꞌay chupan ri ru-palacio y xucꞌutuj cha ri Jesús: ¿Chica lugar at-patanak-ve atreꞌ? xchaꞌ cha. Pero ri Jesús man jun tzij xuꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Rumareꞌ ri Pilato xuꞌej cha ri Jesús: ¿Karruma man ncachꞌoꞌ ta pa chuva? ¿Man avataꞌn ta cꞌa chi inreꞌ cꞌo autoridad pa nukꞌaꞌ chi niꞌej chi ncaquimisas choch cruz y cꞌo autoridad pa nukꞌaꞌ chi ncancol jeꞌ? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Y ri Jesús xuꞌej: Man jun ta av-autoridad panoꞌ, xa man ta ri Dios ri cꞌo chila chicaj ri yaꞌyuon-pa chava. Ruma cꞌa reꞌ, más nem ru-pecado ri xjacho vichin pan akꞌaꞌ, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Rumareꞌ ri Pilato ri gobernador, nucanuj manera chi nucol-el ri Jesús. Pero ri vinak israelitas xaꞌchꞌoꞌ riqꞌuin nojiel quichukꞌaꞌ, y xquiꞌej: Xa xtacol-el, man at ru-amigo ta ri César. Ruma chica-na ri niꞌeꞌn chi jajaꞌ jun rey, can enemigo chirij ri César, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Antok ri Pilato xraꞌxaj ri tzij ri xquiꞌej ri vinak cha, ja xuꞌej chi talasas-pa ri Jesús. Y ri Pilato xbꞌatzꞌuyeꞌ pa tribunal; ri lugar ri niꞌeꞌx Empedrado cha, y pa chꞌabꞌal hebreo niꞌeꞌx Gabata cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ri kꞌij reꞌ, ja nitiquir-ka ri jun namakꞌej Pascua, y rumareꞌ quinojiel vinak niquichojmij ri xticꞌatzin chica. Y pa nicꞌaj-kꞌij laꞌk ri kꞌij reꞌ, ri Pilato xuꞌej chica ri israelitas: ¡Ja I-Rey reꞌ! xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ri vinak ri quimaluon-quiꞌ, riqꞌuin quichukꞌaꞌ xaꞌchꞌo-apa y xquiꞌej: ¡Tavalasaj-el, tavalasaj-el vaveꞌ! ¡Tiꞌan crucificar! xaꞌcha-apa. Y ri Pilato xucꞌutuj chica: ¿Ja ri I-Rey ri ntivajoꞌ chi nitak ruquimisaxic choch cruz? Pero ri principales sacerdotes xa xquiꞌej-apa: Joꞌc ri César ri ka-rey ojreꞌ, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Rumareꞌ ri Pilato xuꞌon ri xquicꞌutuj ri vinak cha. Xujach-el ri Jesús chica ri xcaꞌquimisan richin choch cruz, y ijejeꞌ xquitzꞌom ri Jesús y xquicꞌuaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Y ri Jesús rutalien ri cruz, rutzꞌamuon bꞌay chi niquimisas chupan ri lugar rubꞌinan Rujaluon Quiminak. Pa chꞌabꞌal hebreo, Gólgota niꞌeꞌx cha ri lugar reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Antok xaꞌbꞌaka paroꞌ ri chꞌiti juyuꞌ, xquibꞌajij ri Jesús choch cruz, y quireꞌ jeꞌ xquiꞌan chica icaꞌyeꞌ chic achiꞌaꞌ. Y pa nicꞌaj ri icaꞌyeꞌ achiꞌaꞌ reꞌ xcꞌujie-ve ri cruz ri pacheꞌ xbꞌajix-ve ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Y ri Pilato cꞌo jun letrero xutzꞌibꞌaj-el, y xyoꞌx paroꞌ ri ru-cruz ri Jesús. Choch ri letrero reꞌ nuꞌej: RI JESUS RI AJ-NAZARET, QUI-REY RI ISRAELITAS. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ri letrero reꞌ, can iqꞌuiy chiquivach ri israelitas ncaꞌbꞌano leer, ruma ri lugar ri pacheꞌ xbꞌajix-ve ri Jesús choch ri cruz, xa cierca ri tanamet Jerusalén cꞌo-ve. Y ri letrero reꞌ, oxeꞌ chꞌabꞌal tzꞌibꞌan-ve. Can tzꞌibꞌan cꞌa pa chꞌabꞌal hebreo, griego, y latín. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rumareꞌ ri principales sacerdotes chiquicajol ri israelitas xbꞌaquichꞌojij cha ri Pilato ri gobernador: Man ta xatzꞌibꞌaj ri tzij ri nuꞌej: Qui-Rey ri israelitas. Xa tatzꞌibꞌaj chi jajaꞌ ri xꞌeꞌn: Inreꞌ in Qui-Rey ri israelitas, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero ri Pilato xuꞌej chica ri principales sacerdotes reꞌ: Ri nutzꞌibꞌan, can nutzꞌibꞌan, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Antok ri soldados quibꞌajin chic ri Jesús choch ri cruz, xbꞌaquicꞌama-pa ri rutziak ri Jesús y xquijach chiquivach ijejeꞌ. Cajeꞌ xquiꞌan cha, ruma icajeꞌ ijejeꞌ. Pero ri jun tziak ri niꞌeꞌx túnica cha, man tzꞌisuon ta; xa camuon y joꞌc jun bꞌanun cha, ");
INSERT INTO cakSNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","mareꞌ ijejeꞌ xquiꞌej chiquivach: Man takarakꞌachꞌij ri jun tziak reꞌ. Xa kalasaj suerte chirij, chi quireꞌ joꞌc jun ri nucꞌuan, xaꞌchaꞌ ijejeꞌ. Quireꞌ cꞌa xquiꞌan, chi nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios ri nuꞌej: Xaꞌquijachalaꞌ ri nutziak chiquivach y xcalasaj jeꞌ suerte chirij. Y quireꞌ xquiꞌan ri soldados. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chireꞌ chuxieꞌ ri cruz ri pacheꞌ bꞌajin-ve ri Jesús, icꞌo ri María ri rutieꞌ, ri jun chic ixok ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri rutieꞌ, ri María raxjayil ri ache Cleofas y ri María Magdalena. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Y antok ri Jesús xutzꞌat-pa ri rutieꞌ y ri discípulo ri altíra nrajoꞌ, xuꞌej cha ri rutieꞌ: Nuoya, ja aval la, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Después xuꞌej cha ri ru-discípulo: Ja atieꞌ la, xchaꞌ cha. Y ri discípulo can chupan ri huora reꞌ xucꞌuaj ri María chirachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Y ri Jesús can rataꞌn chic chi nojiel ri samaj ri yoꞌn-pa cha ruma ri Dios ya xcꞌachoj, y chi nuꞌon cumplir incheꞌl tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, rumareꞌ xuꞌej: Chakeꞌj nuchiꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Y chireꞌ cꞌo jun xára nojnak chi vinagre. Y ri soldados chupan reꞌ xquimubꞌaꞌ jun esponja, xquiyaꞌ chutzaꞌn jun chieꞌ ri niꞌeꞌx hisopo cha, y cꞌajareꞌ xquiya-el pa ruchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Y antok ri Jesús rutzꞌuꞌn chic ri vinagre, jajaꞌ xuꞌej: Ya xcꞌachoj nojiel ri nusamaj, xchaꞌ. Xulucubꞌa-pa ri rujaluon y ja xujach ri ru-espíritu. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ri kꞌij reꞌ, quinojiel vinak israelitas niquichojmij yan nojiel ri nicꞌatzin chica chupan ri namakꞌej Pascua. Y rumareꞌ ri achiꞌaꞌ ri cꞌo quikꞌij xaꞌa riqꞌuin ri Pilato ri gobernador y xbꞌaquicꞌutuj favor cha chi tuꞌej chi tikꞌaj cakan ri icꞌo choch cruz, chi quireꞌ ncaꞌlasas-el chireꞌ. Ruma man otz ta chi ncaꞌcꞌujieꞌ ri qui-cuerpo chireꞌ choch cruz chupan ri namalaj kꞌij, ruma Pascua y kꞌij richin uxlanien. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Y ri soldados xaꞌbꞌaka quiqꞌuin ri icꞌo choch cruz, xquikꞌaj rakan ri naꞌay y quireꞌ jeꞌ xquiꞌan cha ri jun chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero antok xaꞌbꞌaka riqꞌuin ri Jesús, man xquikꞌaj ta ri rakan, ruma xquitzꞌat chi xa quiminak chic. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Y mesque xquitzꞌat chi ri Jesús quiminak chic, jun chiquivach ri soldados xujuꞌ rutzaꞌn ri ru-lanza chucꞌalcꞌaꞌx ri Jesús, y ja xbꞌaꞌiel-pa quicꞌ y yaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Y ri xtzꞌato chi quireꞌ xbꞌanataj, can nuꞌej, y ri nuꞌej jajaꞌ can ketzij. Ri rutzꞌatuon y rataꞌn, can ketzij ri nutzijuoj, chi quireꞌ ixvonojiel ixreꞌ ntinimaj jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Quireꞌ cꞌa xbꞌanataj, chi nuꞌon cumplir ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios. Ri tzꞌibꞌan can, nuꞌej: Can man jun rubꞌakil jajaꞌ ri xtiquikꞌaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y nuꞌej jeꞌ chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can: Can xtiquitzꞌat cꞌa ri Jun ri xquichokꞌ cha lanza, nichaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Después ri nojiel reꞌ, cꞌo jun ache José ri aj-Arimatea, jun ru-discípulo ri Jesús, pero man rucꞌutun ta riꞌ ruma nuxiꞌij-riꞌ chiquivach ri nicꞌaj chic achiꞌaꞌ ri cꞌo quikꞌij chiquicajol ri israelitas. Y jajaꞌ xbꞌaka riqꞌuin ri Pilato ri gobernador chi xucꞌutuj favor cha chi tuyaꞌ ri ru-cuerpo ri Jesús cha. Y ri Pilato xuyaꞌ cha. Xpa ri José y xucꞌuaj ri ru-cuerpo ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Y ri Nicodemo jeꞌ, ri ache ri xbꞌaka riqꞌuin ri Jesús chakꞌaꞌ, xalka chupan ri huora reꞌ, rucꞌamun-pa mirra xaluon riqꞌuin nicꞌaj chic quivach jubꞌul tak akꞌuon. Jun laꞌk quintal ri jubꞌul akꞌuon ri rucꞌamun-pa. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ri José y ri Nicodemo xquibꞌol tziak ri cꞌo jubꞌul akꞌuon chirij ri ru-cuerpo ri Jesús. Ijejeꞌ quireꞌ xquiꞌan cha ri ru-cuerpo ri Jesús, ruma ri vinak israelitas quireꞌ niquiꞌan chica ri quiquiminak. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Cierca ri lugar pacheꞌ xbꞌajix-ve ri Jesús choch ri cruz, cꞌo jun huerto. Y chireꞌ cꞌo jun jul cꞌacꞌacꞌ, ri man jun yoꞌn chupan. ");
INSERT INTO cakSNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Y chireꞌ chupan ri jul reꞌ xquiya-ve ri ru-cuerpo ri Jesús, ruma ri jul reꞌ xa cierca cꞌo-ve, y ruma ri quinamakꞌej ri israelitas ri niꞌeꞌx Pascua cha ya nitzꞌucutaj-ka; y ri vinak niquichojmij yan nojiel ri xticꞌatzin chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Y chupan ri naꞌay kꞌij richin ri semana, ri María Magdalena xꞌa chuchiꞌ ri jul. Can macꞌajan yan ri xꞌa, cꞌa kꞌakuꞌn. Y xutzꞌat chi ri abꞌaj ri choj cha tzꞌapin can ruchiꞌ ri jul, xa alasan-el. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Jajaꞌ jun-anin cꞌa xtzalaj chirij y xꞌa riqꞌuin ri Simón Pedro y riqꞌuin jeꞌ ri jun chic discípulo ri altíra xajoꞌx ruma ri Jesús. Ri María Magdalena xiruꞌej chica: Icꞌo xaꞌlasan-el ri ru-cuerpo ri Ajaf Jesús chupan ri jul, y vacame man kataꞌn ta pacheꞌ xbꞌaquiya-ve, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ri Pedro y ri jun chic discípulo, joꞌc xcaꞌxaj ri xuꞌej ri María Magdalena chica, ja xaꞌiel-el y xaꞌa chuchiꞌ ri jul. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Jun-anin xaꞌa ri icaꞌyeꞌ. Y ri jun chic discípulo más anin xꞌa, rumareꞌ xuyaꞌ can ri Pedro, y jareꞌ ri xbꞌaka naꞌay chuchiꞌ ri jul. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ri discípulo reꞌ xluquie-ka chi nitzuꞌn-apa chupan ri jul; y jajaꞌ xutzꞌat-apa ri tziak ri icꞌo can chireꞌ, pero man xuoc ta oc chupan ri jul. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Y antok ri Simón Pedro xalka, ruma cꞌa cꞌo can chirij ri discípulo ri xalka naꞌay, ri Simón Pedro choj xuoc chupan ri jul, y xutzꞌat ri tziak ri icꞌo can chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pero ri tziak ri choj cha xxim can ri rujaluon ri Jesús, jucꞌan chic cꞌo-ve can, bꞌanun can roch. Man junan ta cꞌo can riqꞌuin ri nicꞌaj chic tziak. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Cꞌajareꞌ xuoc jeꞌ ri jun chic discípulo, ri xalka naꞌay chuchiꞌ ri jul. Y jajaꞌ xutzꞌat y xunimaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ri discípulos man canun ta entender ri nuꞌej chupan ri ruchꞌabꞌal ri Dios ri tzꞌibꞌan can chirij ri Jesús, chi nicꞌastaj chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Y ri icaꞌyeꞌ discípulos xaꞌtzalaj chiquij quiqꞌuin ri nicꞌaj chic discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ri María Magdalena ntuokꞌ xcꞌujieꞌ can chuchiꞌ ri jul. Y antok ntuokꞌ, xluquie-ka chi nitzuꞌn-apa chupan ri jul. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Y xaꞌrutzꞌat icaꞌyeꞌ ángeles ri sak quitziak. Jun tzꞌuyul ri pacheꞌ xcꞌujie-ve ri rujaluon ri Jesús y ri jun chic pacheꞌ xaꞌcꞌujie-ve ri rakan. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Y ri icaꞌyeꞌ ángeles reꞌ xquicꞌutuj-pa cha ri María Magdalena: Nuoya, ¿karruma ncatuokꞌ? xaꞌcha-pa cha. Y jajaꞌ xuꞌej chica: Inreꞌ nquinuokꞌ, ruma icꞌo xaꞌlasan-el ri ru-cuerpo ri Vajaf Jesús y man vataꞌn ta pacheꞌ xbꞌaquiya-ve, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Y antok jajaꞌ ruꞌeꞌn chic ri tzij reꞌ, xtzuꞌn can chirij. Jajaꞌ xutzꞌat chi cꞌo Jun ri paꞌl-apa, pero man rataꞌn ta chi ja ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jareꞌ antok ri Jesús xucꞌutuj cha ri María Magdalena: Nuoya, ¿karruma ncatuokꞌ? ¿Chica ri nacanuj? xchaꞌ cha. Y ri María Magdalena xuꞌon-ka pensar chi ja ri nichajin ri huerto, rumareꞌ jajaꞌ xuꞌej cha: Xa atreꞌ ri xatucꞌuan ri ru-cuerpo ri Vajaf Jesús, taꞌej chuva pacheꞌ xaya-ve y inreꞌ xtinvucꞌuaj, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Pero ri Jesús xchꞌoꞌ chic cha y xuꞌej: ¡María! xchaꞌ. Y ri María Magdalena xtzuꞌn cꞌa apa riqꞌuin y xutzꞌat chi ja ri Jesús, y xuꞌej cha: ¡Raboni! xchaꞌ. (Ri tzij Raboni nrajoꞌ nuꞌej Maestro). ");
INSERT INTO cakSNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Y ri Jesús xuꞌej cha ri María Magdalena: Man quinatzꞌom. Ruma inreꞌ cꞌa majaꞌ quiꞌa riqꞌuin ri Nataꞌ chila chicaj. Pero abꞌej chica ri hermanos chi inreꞌ nquiꞌa riqꞌuin ri Nataꞌ, ri Itataꞌ jeꞌ ixreꞌ. Can nquiꞌa riqꞌuin ri Nu-Dios, ri I-Dios jeꞌ ixreꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Y ri María Magdalena xꞌa y xbꞌaruꞌej chica ri discípulos chi xutzꞌat ri Ajaf Jesús, y xbꞌaruꞌej chica jeꞌ ri eꞌn-el cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Y antok xcokꞌa-ka chupan ri kꞌij reꞌ, ri naꞌay kꞌij richin ri semana, ri discípulos quimaluon-quiꞌ; i-tzꞌapal ruchiꞌ ri jay ri pacheꞌ icꞌo-ve, ruma ijejeꞌ quixiꞌin-quiꞌ chiquivach ri israelitas, ri i-quivanakil. Jareꞌ antok xalka ri Jesús chiquicajol y xuꞌej chica: Paz iviqꞌuin, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Y antok jajaꞌ ruꞌeꞌn chic quireꞌ chica ri quimaluon-quiꞌ chireꞌ, xucꞌut chiquivach ri rukꞌaꞌ y ri rucꞌalcꞌaꞌx. Y ri discípulos can xaꞌquicuot, ruma xquitzꞌat chi ja ri Ajaf Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Y ri Jesús xuꞌej chic jun bꞌay chica ri ru-discípulos: Paz iviqꞌuin. Vacame nquixtak-el, incheꞌl xirutak-pa inreꞌ ri Nataꞌ, chi xinꞌan ri rusamaj. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Y antok ruꞌeꞌn chic ri tzij reꞌ, jajaꞌ xaꞌruxupuj y xuꞌej chica: Tibꞌanaꞌ cꞌa recibir ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Y xa ixreꞌ ntiꞌan perdonar ri ru-pecados richin jun, ri Dios can nuꞌon perdonar ri ru-pecados ri jun reꞌ. Y xa ixreꞌ man xtiꞌan ta perdonar ri ru-pecados, ri Dios jeꞌ man xtuꞌon ta perdonar ri ru-pecados, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Pero ri Tomás, jun chiquivach ri doce (cabꞌalajuj) discípulos ri Jesús, ri niꞌeꞌx jeꞌ Dídimo cha, xa man cꞌo ta quiqꞌuin ri nicꞌaj chic antok ri Jesús xalka chiquicajol. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Y rumareꞌ ri nicꞌaj chic discípulos xquiꞌej cha ri Tomás: Ojreꞌ xkatzꞌat ri Ajaf Jesús, xaꞌchaꞌ cha. Pero jajaꞌ man xunimaj ta, xa xuꞌej chica: Inreꞌ cꞌa nitzꞌat-na ri pacheꞌ xaꞌuoc-ve ri clavos pa rukꞌaꞌ y cꞌa nijuꞌ na ri ruve-nukꞌaꞌ chupan ri varol ri xquiꞌan ri clavos y pa rucꞌalcꞌaꞌx jeꞌ pacheꞌ xuoc-ve ri lanza, cꞌajareꞌ xtinnimaj chi jajaꞌ, xchaꞌ ri Tomás. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Antok kꞌaxnak chic cꞌa ocho (vakxakiꞌ) kꞌij, ri discípulos quimaluon chic quiꞌ jun bꞌay, quitzꞌapin-quiꞌ chupan ri jay y cꞌo ri Tomás quiqꞌuin. Y mesque ri puerta richin ri jay can i-tzꞌapal, ri Jesús xalka chiquicajol, y xuꞌej chica: Paz iviqꞌuin, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Y después xuꞌej cha ri Tomás: Tajuꞌ ri ruve-akꞌaꞌ vaveꞌ y caꞌtzꞌataꞌ ri nukꞌaꞌ i-socotajnak. Taya-pa la akꞌaꞌ pa nucꞌalcꞌaꞌx y tajuꞌ pacheꞌ xuoc-ve ri lanza. Can tanimaj cꞌa, y man taꞌan incheꞌl niquiꞌan ri nicꞌaj chic vinak, ri man niquinimaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Y ri Tomás xuꞌej cha ri Jesús: ¡Atreꞌ at Vajaf y at Nu-Dios! xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pero ri Jesús xuꞌej cha ri Tomás: Cꞌa xinatzꞌat-na, mareꞌ xanimaj. Can jaꞌal caꞌquicuot ri man nquinquitzꞌat ta y nquinquinimaj, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús qꞌuiy milagros xaꞌruꞌon chiquivach ri ru-discípulos, pero man nojiel ta tzꞌibꞌan can chupan va libro va. ");
INSERT INTO cakSNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero ri i-tzꞌibꞌan can chupan va libro va, can i-tzꞌibꞌan can chi quireꞌ ixreꞌ tinimaj chi ri Jesús jareꞌ ri Cristo ri Rucꞌajuol ri Dios. Y antok xtinimaj, can xtivil ri cꞌaslien ri man xtiqꞌuis ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Después ri Jesús xucꞌut chic riꞌ jun bꞌay chiquivach ri ru-discípulos chuchiꞌ ri mar Tiberias. Y quireꞌ xuꞌon antok xucꞌut-riꞌ chiquivach: ");
INSERT INTO cakSNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Xa jun icꞌo ri Simón Pedro, ri Tomás ri niꞌeꞌx jeꞌ Dídimo cha, ri Natanael ri patanak ri tanamet Caná ri cꞌo chupan Galilea, ri icaꞌyeꞌ rucꞌajuol ri Zebedeo y icaꞌyeꞌ chic discípulos. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Y ri Simón Pedro xuꞌej chica ri nicꞌaj chic: Inreꞌ nquiꞌa chi ncaꞌnbꞌatzꞌamaꞌ car pa yaꞌ, xchaꞌ. Y ri nicꞌaj chic xquiꞌej: Ojreꞌ jeꞌ nkuꞌa aviqꞌuin. Y quinojiel xaꞌa y xaꞌjotie-el chupan jun barco; y mesque jun akꞌaꞌ xaꞌcꞌasieꞌ, man jun car xquitzꞌom. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Y antok ya nisakar-pa, ri Jesús xalka y xalpiꞌieꞌ chuchiꞌ ri mar. Pero ri discípulos man cataꞌn ta chi ja ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Y jajaꞌ xchꞌo-apa chica y xuꞌej cꞌa: Chꞌitak valcꞌual, ¿cꞌo kax iviqꞌuin chi nitij? xchaꞌ chica. Y ri discípulos xquiꞌej-pa cha: Nak, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xpa ri Jesús xuꞌej-apa chica: Tiya-ka la yaꞌl ri choj cha ntitzꞌom-ve car chupan ri yaꞌ, ri lado derecha ri barco, y icꞌo cꞌa car xquiꞌtzꞌom, xchaꞌ. Y ri discípulos ja xquiya-ka ri yaꞌl chupan ri yaꞌ. Y man ncaꞌtiquir ta chic nicalasaj-pa ri yaꞌl chupan ri yaꞌ, ruma qꞌuiy car ri xquiya-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Y ri jun discípulo ri xajoꞌx altíra ruma ri Jesús, xuꞌej cha ri Pedro: ¡Ja ri Ajaf Jesús ri nichꞌo-pa! xchaꞌ. Y ri Simón Pedro joꞌc xraꞌxaj chi ja ri Jesús, ja xucusaj ri jun chic rutziak ri ralasan-el chirij y xuqꞌuiak-ka-riꞌ chupan ri yaꞌ chi niꞌka chuchiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pero ri nicꞌaj chic discípulos cꞌa chupan ri barco xaꞌpa-ve, y quichiririen-pa ri yaꞌl nojnak chi car. Man naj ta icꞌo-apa paroꞌ ri yaꞌ, xa jun laꞌk cien metros. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Y antok ijejeꞌ xaꞌlka chuchiꞌ ri yaꞌ y xaꞌiel-pa chupan ri barco, xquitzꞌat chi cꞌo rachak kꞌakꞌ, y paroꞌ cꞌo jun car sabꞌan-ka, y cꞌo jeꞌ simíta. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xuꞌej chica: Ticꞌama-pa nicꞌaj car ri cꞌajaꞌ oc xiꞌvalasaj-pa, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro xꞌa y xjotie-apa chupan ri barco, y xbꞌaralasaj-pa ri yaꞌl nojnak chi car y xujicꞌ-pa cꞌa chuchiꞌ ri yaꞌ. Can qꞌuiy ri i-nimaꞌk car ri icꞌo chupan ri yaꞌl. Ciento cincuenta y tres car ri xquiya-pa-quiꞌ. Can iqꞌuiy, pero ri yaꞌl man xkꞌachꞌitaj ta. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Y ri Jesús xuꞌej chica ri ru-discípulos: Quixam-pa y quixvaꞌ, xchaꞌ. Y man jun chiquivach ri discípulos xuꞌon rucovil chi xucꞌutuj cha ri Jesús: ¿At chica atreꞌ? ruma cataꞌn chi ja ri Ajaf. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Y ri Jesús xjiel cꞌa pa quiqꞌuin y xutzꞌom rujachic ri simíta chiquivach, y quireꞌ jeꞌ xuꞌon cha ri car. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Y jareꞌ ri ruox mul chi ri Jesús xucꞌut-riꞌ chiquivach ri ru-discípulos, antok cꞌastajnak chic pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Y antok ya xaꞌvaꞌ quinojiel, ri Jesús xucꞌutuj cha ri Simón Pedro: Atreꞌ Simón ri at rucꞌajuol ri Jonás, ¿nquinavajoꞌ came más que chiquivach quinojiel la? xchaꞌ cha. Y ri Simón Pedro xuꞌej: Ajaf, quireꞌ. Atreꞌ avataꞌn chi ncanvajoꞌ. Y ri Jesús xuꞌej cha: Xa nquinavajoꞌ, caꞌchajij cꞌa ri alaj tak nu-ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Y ri Jesús xucꞌutuj chic cha jun bꞌay: Atreꞌ Simón ri at rucꞌajuol ri Jonás, ¿can nquinavajoꞌ cꞌa? Y ri Pedro xuꞌej: Ajaf, quireꞌ. Atreꞌ avataꞌn chi ncanvajoꞌ. Y ri Jesús xuꞌej: Xa nquinavajoꞌ, caꞌbꞌanaꞌ cꞌa cuenta ri nu-ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Y chi oxeꞌ mul, ri Jesús xuꞌej cha: Atreꞌ Simón ri at rucꞌajuol ri Jonás, ¿can nquinavajoꞌ cꞌa? Y ri Pedro ja xbꞌisuon-ka, ruma ja oxeꞌ mul reꞌ ri xcꞌutux cha ruma ri Jesús: ¿Can nquinavajoꞌ cꞌa? Y ri Pedro xuꞌej: Ajaf, atreꞌ nojiel avataꞌn. Can avataꞌn chi ncanvajoꞌ. Y ri Jesús xuꞌej chic cha: Can caꞌchajij ri nu-ovejas. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Can ketzij, ketzij ri niꞌej chava: Antok cꞌa at cꞌajuol, can ayuon naxim apan y pacheꞌ na cꞌa navajoꞌ ncaꞌa, can ncaꞌa. Pero antok xcarijix-ka, xtayuk ri akꞌaꞌ choch jun chic, y jun chic ri xtiximo ri apan y xcarucꞌuaj pacheꞌ man navajoꞌ ta atreꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri xuꞌej cꞌa ri Jesús, can xuꞌej chi antok xticon ri Pedro, can xtiyoꞌx rukꞌij ri Dios. Y antok ri Jesús ruꞌeꞌn chic nojiel reꞌ, xuꞌej jeꞌ cha ri Pedro: Joꞌ viqꞌuin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Y antok ri Jesús y ri Pedro i-bꞌanak, ri Pedro xtzuꞌn can chirij y xutzꞌat chi bꞌanak chiquij ri discípulo ri altíra najoꞌx ruma ri Jesús, ri xrakꞌie-apa riqꞌuin ri Jesús antok xquiꞌan ri Santa Cena, y ri xcꞌutun cha ri Jesús: Ajaf, ¿chica ri xtijacho avichin? ");
INSERT INTO cakSNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Antok ri Pedro xutzꞌat ri discípulo reꞌ, xucꞌutuj cha ri Jesús: Ajaf, ¿chica xtuꞌon can jajaꞌ? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Y ri Jesús xuꞌej cha ri Pedro: Xa inreꞌ nivajoꞌ chi jajaꞌ cꞌa cꞌas antok xquipa chic jun bꞌay, man nicꞌatzin ta chi jareꞌ ri naꞌan pensar. Atreꞌ joꞌ viqꞌuin, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ri tzij ri xuꞌej ri Jesús, can xꞌa cꞌa rutzijoxic chiquicajol ri hermanos. Rumareꞌ ri hermanos can xquiꞌan-ka pensar chi ri jun discípulo reꞌ man nicon ta. Pero ri xuꞌej ri Jesús xa man quireꞌ ta, ruma jajaꞌ xuꞌej: Xa inreꞌ nivajoꞌ chi jajaꞌ cꞌa cꞌas antok xquipa chic jun bꞌay, man nicꞌatzin ta chi jareꞌ ri naꞌan pensar. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Y ja mismo discípulo reꞌ ri tzꞌibꞌayuon can nojiel ri cꞌo chupan ri libro va. Can kataꞌn cꞌa chi ketzij nojiel ri nuꞌej, ruma jajaꞌ xutzꞌat ri xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Y cꞌa cꞌo qꞌuiy kax xaꞌruꞌon ri Jesús ri man i-tzꞌibꞌan ta can chupan va libro va. Ruma xa ta chijujun ri samaj xaꞌruꞌon ri Jesús xaꞌtzꞌibꞌas ta, niꞌan pensar chi ri roch-ulief man nuꞌon ta chi ncaꞌyac nojiel ri libros ri pacheꞌ ncaꞌtzꞌibꞌas-ve ri kax reꞌ. Amén.");
INSERT INTO cakSNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chupan ri jun libro ri xintak-el chava naꞌay, Teófilo, nutzꞌibꞌan-el ri xutzꞌom rubꞌanic ri Jesús, y ri xucꞌut can chiquivach ri vinak, ");
INSERT INTO cakSNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","hasta cꞌa chupan ri kꞌij antok jajaꞌ xꞌa chicaj. Pero antok jajaꞌ cꞌa majaꞌ tiꞌa chicaj, riqꞌuin ri ru-poder ri Espíritu Santo xuꞌej chica ri ru-apóstoles ri i-ruchoꞌn, ri chica nicꞌatzin chi niquiꞌan can. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Y después antok xuꞌon sufrir y xquimisas y antok cꞌastajnak chic pa, xucꞌut-riꞌ chiquivach cuarenta kꞌij. Y cꞌo nicꞌaj chic kax ri xaꞌruꞌon chi xquinaꞌiej chi cꞌas. Y xutzijuoj jeꞌ chica chirij ri ru-reino ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Y jun bꞌay antok ri Jesús y ri ru-apóstoles quimaluon-quiꞌ, ri Jesús xuꞌon mandar chica: Quixcꞌujieꞌ vaveꞌ pa tanamet Jerusalén y tivoyoꞌiej hasta cꞌa xtalka ri ranun prometer ri Nataꞌ Dios chiva. Incheꞌl ri nuꞌeꞌn chiva. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ruma ri Juan cha yaꞌ xaꞌruꞌon bautizar ri vinak; pero ixreꞌ, chi jun janeꞌ apa (jaroꞌ apa) kꞌij, riqꞌuin ri Espíritu Santo xquixꞌan bautizar, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Y ri quimaluon-quiꞌ xquicꞌutuj cha ri Jesús: Ajaf, ¿naꞌan chi jun chikacajol ojreꞌ israelitas nibꞌano chic gobernar kichin chupan ri tiempo vacame? xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Y ri Jesús xuꞌej chica: Ja ri Dios xtiꞌeꞌn jampeꞌ xtibꞌanataj reꞌ, y man nicꞌatzin ta chi ntinaꞌiej ixreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero ixreꞌ xtiꞌan recibir poder antok ri Espíritu Santo xtika-pa pan iveꞌ, y xquinitzijuoj chiquivach ri vinak pa tanamet Jerusalén, y chiquivach ri vinak ri icꞌo nicꞌaj chic tanamet richin ri Judea y ri Samaria, y chiquivach jeꞌ quinojiel vinak ri icꞌo choch-ulief, xchaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Y después que xuꞌej ri tzij reꞌ, ri icꞌo riqꞌuin chireꞌ, xquitzꞌat antok xꞌa chicaj y xuoc-el chupan jun mukul ri xravaj chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Y cꞌa ncaꞌtzuꞌn-el chicaj antok ri Jesús xꞌa-el. Antok xquinaꞌ, icꞌo yan chic icaꞌyeꞌ achiꞌaꞌ quiqꞌuin, ri quicusan sak tziak. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Y ri icaꞌyeꞌ achiꞌaꞌ reꞌ xquiꞌej chica ri ru-apóstoles ri Jesús: Achiꞌaꞌ aj-Galilea, ¿karruma ixreꞌ nquixtzuꞌn-el chicaj? Ri Jesús ri xitzꞌat chi xꞌa chicaj vacame, can incheꞌl xuꞌon chi xꞌa, can quireꞌ jeꞌ xtuꞌon antok xtipa chic jun bꞌay, xaꞌchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Y ri apóstoles xaꞌiel-pa chireꞌ paroꞌ ri juyuꞌ rubꞌinan Olivos, y xaꞌtzalaj pa tanamet Jerusalén. Ri juyuꞌ Olivos cierca cꞌo-ve riqꞌuin ri Jerusalén, xa joꞌc laꞌk jun kilómetro. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Y antok xaꞌlka, xaꞌjotie-el rucaꞌn piso ri jay ri pacheꞌ niquimol-ve-quiꞌ ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo ri rucꞌajuol ri Alfeo, ri Simón ri cꞌo quiqꞌuin ri achiꞌaꞌ ri niꞌeꞌx Zelotes chica, y ri Judas ri quichakꞌ-quinimal-quiꞌ riqꞌuin ri Jacobo. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Y quinojiel ijejeꞌ junan cánima y siempre niquiꞌan orar. Icꞌo jeꞌ ixokiꞌ, y ri María jeꞌ ri rutieꞌ ri Jesús, y ri i-ruchakꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Y jun kꞌij antok quimaluon-quiꞌ jun laꞌk ciento veinte hermanos, ri Pedro xbꞌapiꞌie-pa chiquicajol y xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Hermanos, can xcꞌatzin chi nuꞌon cumplir ri ruchꞌabꞌal ri Dios ri xuyaꞌ ri Espíritu Santo cha ri David, antok xuꞌej chirij ri Judas ri xucꞌuan quichin ri vinak chi xbꞌaquitzꞌamaꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Y ri Judas reꞌ xuoc kachꞌil, y xsamaj jeꞌ kiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Y riqꞌuin ri miera ri xyoꞌx cha ruma xujach ri Jesús, xluokꞌ jun ulief. Ri Judas xuquimisaj-riꞌ. Jajaꞌ xtzak-pa pan ulief y ja ri rujaluon xutic, xbꞌuos ri rupan, y nojiel xpichcan pan ulief. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Y antok xbꞌanataj reꞌ, quinojiel ri vinak aj-Jerusalén xquinaꞌiej, y rumareꞌ Acéldama xꞌeꞌx cha ri ulief reꞌ. Ri tzij Acéldama pa quichꞌabꞌal ijejeꞌ nuꞌej, Ulief richin Quicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Quireꞌ xbꞌanataj, ruma chupan ri libro rubꞌinan Salmos bꞌeꞌn can: Xa tiyoꞌx can ri rachuoch y man jun vinak ticꞌujieꞌ chupan. Y nuꞌej jeꞌ: Jun chic tuoc pa rucꞌaxiel chi nuꞌon ri rusamaj. Quireꞌ nuꞌej ri bꞌeꞌn can. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Rumareꞌ nicꞌatzin chi nakacanuj jun rucꞌaxiel, pero chiquicajol ri achiꞌaꞌ ri nojiel tiempo icꞌo kiqꞌuin y can i-bꞌanak kiqꞌuin antok xcꞌujieꞌ ri Ajaf Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Nitzꞌucutaj-pa antok xꞌan bautizar ri Jesús ruma ri Juan, hasta cꞌa antok xꞌa chicaj, y xiel-el chikacajol. Nicꞌatzin chi nutzijuoj junan kiqꞌuin ojreꞌ chi ri Jesús xcꞌastaj-pa chiquicajol ri quiminakiꞌ, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Y xquiya-apa caꞌyeꞌ bꞌiꞌaj: Jun, ja ri José ri niꞌeꞌx Barsabás cha y niꞌeꞌx jeꞌ Justo cha, y ri jun chic, ja ri Matías. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Y xquiꞌan orar, y quireꞌ xquiꞌej: Ajaf, atreꞌ ri natzꞌat ri kánima konojiel, tacꞌutuꞌ chakavach chica chiquivach ri icaꞌyeꞌ achiꞌaꞌ reꞌ ri xachaꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","chi ntuoc can apóstol pa rucꞌaxiel ri Judas y nuꞌon ri samaj. Ruma ri Judas xa xuyaꞌ can ri samaj, ruma ri itziel ri xuꞌon. Y vacame jajaꞌ ya xbꞌaka chupan ri lugar ri pacheꞌ chi nibꞌaka-ve, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Entonces xquiꞌan sortear ri quibꞌeꞌ ri icaꞌyeꞌ chi chica xticꞌujieꞌ pa rucꞌaxiel ri Judas chi ntuoc cachꞌil ri once (julajuj) apóstoles. Y ja ri Matías ri xchꞌacuon. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Y antok xalka ri kꞌij richin ri namakꞌej Pentecostés, ri quiniman ri Ajaf Jesús quimaluon-quiꞌ. Can junan cánima quibꞌanun quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Y jun arapienta, xkꞌajan-pa chicaj, y can incheꞌl jun nem cakꞌiekꞌ ri nikꞌajan patanak. Y reꞌ altíra xuꞌon ri pa jay ri pacheꞌ i-tzꞌuyul-ve. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Y ri icꞌo chireꞌ, xquitzꞌat chi xaꞌbꞌaꞌiel-pa incheꞌl ruxak tak kꞌakꞌ ri xujachala-riꞌ y xcꞌujieꞌ pa quiveꞌ chiquijunal. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ri Espíritu Santo xunojsaj ri cánima, y ja xaꞌchꞌo-ka nicꞌaj chic chꞌabꞌal, según ri xuyaꞌ ri Espíritu chica chi xaꞌchꞌoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Y ri chireꞌ pa tanamet Jerusalén ri kꞌij reꞌ, icꞌo iqꞌuiy achiꞌaꞌ israelitas ri niquiyaꞌ rukꞌij ri Dios, ri i-patanak nojiel naciones ri icꞌo choch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pero ruma ri xkꞌajan, ri vinak xquimol-apa-quiꞌ. Ri vinak reꞌ can xaꞌchapataj, ruma chiquijunal nicaꞌxaj ri chꞌabꞌal ri ncaꞌchꞌoꞌ ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Can i-chapatajnak ruma ri xcaꞌxaj, y niquiꞌej chiquivach: Titzꞌataꞌ, ¿man i-aj-Galilea ta cꞌa quinojiel la ncaꞌchꞌoꞌ cꞌa? ");
INSERT INTO cakSNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Cheꞌl chi ojreꞌ can nakaxaj ri niquiꞌej y xa man junan ta kachꞌabꞌal chikajunal? ");
INSERT INTO cakSNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ruma icꞌo chakavach ojreꞌ ri aj-vaveꞌ Judea, icꞌo i-patanak Partia, Media, Elam, Mesopotamia, Capadocia, Ponto, Asia, ");
INSERT INTO cakSNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia, Panfilia, Egipto, y icꞌo ri i-patanak más cꞌa cala choch ri tanamet Cirene, ri cꞌo chupan ri Africa. Icꞌo jeꞌ ri i-patanak pa tanamet Roma. Y chikacajol ojreꞌ icꞌo ri i-calcꞌual ri israelitas, y icꞌo jeꞌ ri i-acunak israelitas ruma niquinimaj ri nuꞌej ri ru-ley ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Y icꞌo jeꞌ ri i-patanak Creta y Arabia. Y konojiel xkaxaj pa tak kachꞌabꞌal ri namalaj rusamaj ri Dios, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Y quinojiel xaꞌchapataj y man niquil ta chica niquiꞌan pensar y niquiꞌej chiquivach: ¿Chica nrajoꞌ nuꞌej ri nibꞌanataj? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Pero icꞌo vinak ri xa ncaꞌtzeꞌn-apa chiquij y niquiꞌej: La xa i-kꞌabꞌaralaꞌ, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Y ri Pedro y ri once (julajuj) chic apóstoles xaꞌbꞌapiꞌie-pa chiquivach ri vinak. Y ri Pedro xchꞌoꞌ y xuꞌej: Achiꞌaꞌ israelitas ri ix-patanak juviera y ixreꞌ jeꞌ ri ixcꞌo vaveꞌ Jerusalén ri kꞌij vacame, tivaxaj cꞌa ri xtinꞌej chiva y tivatamaj: ");
INSERT INTO cakSNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Konojiel ri kamaluon-kiꞌ vaveꞌ, man jun kꞌabꞌariel cꞌo. Man incheꞌl ta ri ntiꞌan pensar ixreꞌ. Ruma xa cꞌa cumaj, xa cꞌa ja a las nueve. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ri xbꞌanataj vacame, can tzꞌibꞌan can ruma ri profeta Joel. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Y chupan ri rutzꞌibꞌan can jajaꞌ, ri Dios nuꞌej: Chupan ri ruqꞌuisbꞌal tak kꞌij, xtinya-pa ri Nu-Espíritu pa quiveꞌ ri vinak, y chi xtaniꞌ chi alabꞌo xtiquitzijuoj ri niꞌej chica. Y ri cꞌa i-cꞌojolaꞌ, chupan jun incheꞌl achicꞌ xtiquitzꞌat ri nitzijuoj chica. Y ri i-mámix chic, pan achicꞌ ri xtinꞌej chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Can xtinyaꞌ jeꞌ ri Nu-Espíritu pa quiveꞌ ri nu-siervos y ri nu-siervas chupan ri kꞌij reꞌ, y ijejeꞌ xtiquitzijuoj ri xtinꞌej chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Y choch ri rocaj xtinꞌan milagros ri man jun bꞌay i-tzꞌatuon, y xcaꞌnꞌan jeꞌ señales ri choch-ulief. Can xtinꞌan chi xcaꞌtzꞌiet quicꞌ, kꞌakꞌ, y sebꞌ ri can incheꞌl mukul. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Y ri kꞌij man xtuyaꞌ ta chic rusakil. Ri icꞌ incheꞌl quicꞌ xtuꞌon. Jareꞌ ri xcaꞌbꞌanataj naꞌay antok majaꞌ talka ri kꞌij richin ri Ajaf, chupan ri nem kꞌij antok xcaꞌan juzgar quinojiel ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y quinojiel ri xtiquicꞌutuj cha ri Ajaf chi caꞌrucaloꞌ, can xcaꞌcolotaj-ve. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Y ri Pedro xuꞌej jeꞌ: Achiꞌaꞌ israelitas, tivaxaj cꞌa ri xtinꞌej chiva: Ri Jesús ri aj-Nazaret, ja ri Dios ri bꞌanayuon-pa cha chi qꞌuiy ri xaꞌruꞌon chiꞌicajol. Xaꞌruꞌon milagros ri man jun bꞌay i-tzꞌatuon. Y cꞌo jeꞌ señales xaꞌruꞌon. Ja ri Dios xbꞌano nojiel reꞌ chiꞌicajol por medio jajaꞌ. Ixreꞌ ivataꞌn jaꞌal. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Pero ri Dios xuyaꞌ lugar chi xjach ri Jesús pan ikꞌaꞌ, ruma quireꞌ ranun-pa pensar. Y ixreꞌ xiyaꞌ pa quikꞌaꞌ itziel tak vinak chi xquiquimisaj choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero riqꞌuin ri ru-poder ri Dios, ri Jesús xbꞌacꞌastaj-pa, y xcolotaj-pa pa rukꞌaꞌ ri camic, ruma ri camic man xcovin ta xutzꞌom richin nojiel tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Ri David ruꞌeꞌn can chirij ri Jesús: Can siempre nitzꞌat chi ri Ajaf bꞌanak chinoch. Man jun chica xtibꞌano chuva chi nixiꞌij-viꞌ, ruma cꞌo viqꞌuin pa nu-derecha. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Y rumareꞌ niquicuot ri vánima, y nquiquicuot jeꞌ nquichꞌoꞌ. Y mesque xquicon, can vataꞌn chi xquicꞌastaj chic pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ruma atreꞌ Nu-Dios, can man xquinayaꞌ ta can chiquicajol ri quiminakiꞌ, man xtayaꞌ ta jeꞌ lugar chuva inreꞌ ri in Santo Acꞌajuol chi nikꞌay ri nu-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Can nacꞌut ri utzulaj bꞌay richin ri cꞌaslien chinoch, y can xtiquicuot ri vánima antok xquicꞌujieꞌ aviqꞌuin. Quireꞌ ruꞌeꞌn can ri David. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Y ri Pedro xuꞌej jeꞌ: Achiꞌaꞌ nuvanakil, ixreꞌ ivataꞌn chi ri kamamaꞌ David xcon y xmuk. Y pacheꞌ mukun-ve, cꞌa cꞌo chupan ri tiempo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ri David jun profeta ri xcꞌujieꞌ ojier can tiempo. Jajaꞌ rataꞌn chi ri Dios can xuꞌon-ve jurar chi chupan ru-familia jajaꞌ xtiel-pa ri Cristo, y jareꞌ ri xtuoc can rey pa rucꞌaxiel jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Y ri David, can incheꞌl ya xutzꞌat ri xcaꞌbꞌanataj. Rumareꞌ xchꞌoꞌ y xuꞌej chi ri Cristo xticꞌastaj chic, y chi ri ránima man xticꞌujieꞌ ta can chireꞌ chiquicajol ri quiminakiꞌ, y ni ri ru-cuerpo man nikꞌay ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Y konojiel ojreꞌ kataꞌn y nakatzijuoj chi ja ri Dios ri xbꞌano chi ri Jesús xcꞌastaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Y xucꞌuax jeꞌ chicaj ruma ri ru-poder ri Dios. Y xyoꞌx ri Espíritu Santo cha, ri ranun prometer ri Rutataꞌ chi nuyaꞌ cha. Y antok yoꞌn chic ri Espíritu Santo cha, jajaꞌ xutak-pa chika ojreꞌ, y ja yan cꞌa reꞌ ri xitzꞌat y xivaxaj kiqꞌuin vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ruma ri David man xꞌa ta chicaj chaꞌnin, y jajaꞌ mismo rutzꞌibꞌan can: Ri Ajaf Dios xuꞌej cha ri Vajaf: Catzꞌuyeꞌ pa nu-derecha, ");
INSERT INTO cakSNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta cꞌa xcaꞌnyaꞌ ri av-enemigos chuxieꞌ avakan. Quireꞌ rutzꞌibꞌan can ri David. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tivatamaj cꞌa ixreꞌ ri ix rumáma can ri Israel; chi ketzij chi ri Jesús ri xiquimisaj choch cruz, ja ri Dios ri bꞌanayuon-pa cha chi jajaꞌ ri Cristo y chi jajaꞌ ri Rajaf nojiel, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Y antok ri vinak xcaꞌxaj ri xuꞌej ri Pedro, xkꞌaxo cánima, y xquicꞌutuj cha ri Pedro y chica ri nicꞌaj chic apóstoles: Kavanakil, ¿chica nakaꞌan? xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Y ri Pedro xuꞌej chica: Titzalaj-pa ivánima riqꞌuin ri Dios y tibꞌanaꞌ ri nrajoꞌ jajaꞌ, y pa rubꞌeꞌ ri Jesucristo tibꞌanaꞌ bautizar-iviꞌ, chi quireꞌ niꞌan perdonar ri i-pecados. Y ri Dios xtuyaꞌ ri Espíritu Santo chiva. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ruma jareꞌ ri ranun prometer ri Dios chi nuyaꞌ chiva ixreꞌ, y chica ri ivalcꞌual, y chica quinojiel vinak ri icꞌo naj; chica quinojiel ri ncaꞌrayuoj ri Kajaf Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Y ri Pedro cꞌo nicꞌaj chic tzij ri xaꞌruꞌej chica. Jajaꞌ xuꞌej cꞌa chica ri vinak: Quixiel-pa chiquicajol ri vinak richin ri tiempo vacame, ri man choj ta ncaꞌin choch ri Dios, chi quireꞌ nquixcolotaj, nichaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Y ri vinak ri xquinimaj ri ruchꞌabꞌal ri Dios chupan ri kꞌij reꞌ, xaꞌan bautizar y icꞌo laꞌk jun oxeꞌ mil vinak xaꞌuoc quiqꞌuin ri quiniman antes. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y man niquimalij ta quicꞌuꞌx, xa siempre niquimol-quiꞌ chi nicaꞌxaj ri niquicꞌut ri apóstoles, xa junan cánima quibꞌanun, xa junan niquicꞌux ri simíta chi niquinataj ri rucamic ri Ajaf Jesús, y junan jeꞌ niquiꞌan orar. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Y chiquij quinojiel ri vinak xpa xibꞌinreꞌl. Y qꞌuiy milagros y señales ri niquiꞌan ri apóstoles. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Y quinojiel ri quiniman ri Jesucristo, nicajo-quiꞌ y junan icꞌo, y niquijach chiquivach nojiel ri kax ri cꞌo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Y niquicꞌayij ri chica cꞌo quiqꞌuin chi ncaꞌquitoꞌ ri nicꞌaj chic antok nicꞌatzin chi ncaꞌtoꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Y pa templo kꞌij-kꞌij niquimol-quiꞌ, y junan cánima quinojiel. Y antok niquiꞌan vaꞌen pa tak jay, can riqꞌuin nojiel cánima y ncaꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Y niquiyaꞌ rukꞌij ri Dios, y otz ncaꞌtzꞌiet cuma ri vinak. Y kꞌij-kꞌij icꞌo más ri ncaꞌbꞌaka chupan ri iglesia, ruma ja ri Ajaf ri nibꞌano chi ncaꞌcolotaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ri Pedro y ri Juan junan i-bꞌanak-el chi ncaꞌa pa templo a las tres ri nakakꞌij, ruma ja huora reꞌ richin ri oración. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Y chuchiꞌ ri jun puerta ri rubꞌinan La Hermosa richin ri templo, kꞌij-kꞌij cꞌo ri ncaꞌbꞌayoꞌn can jun ache chi nucꞌutuj limosna. Ri jun ache reꞌ xa-jan antok xalax ri manak cheꞌl niꞌin. Jajaꞌ nucꞌutuj limosna chica ri vinak ri ncaꞌuoc pa templo. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Y antok ri Pedro y ri Juan ncaꞌuoc pa templo, ri ache nuꞌon rogar chi nucꞌutuj ru-limosna chica ijejeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pero ri Pedro xucaꞌyiej-xucaꞌyiej otz ri ache, y quireꞌ jeꞌ xuꞌon ri Juan, y cꞌajareꞌ ri Pedro xuꞌej cha ri ache: Kojatzꞌataꞌ, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Y ri ache can xaꞌrutzꞌat, y royoꞌien ri chica ri xtiquiyaꞌ can cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero ri Pedro xuꞌej cha: Inreꞌ manak oro ni plata viqꞌuin chi niyaꞌ ta chava. Pero ri cꞌo viqꞌuin, jareꞌ ri niyaꞌ chava, xchaꞌ; y ja xuꞌej cha: Pa rubꞌeꞌ ri Jesucristo ri aj-Nazaret, capalaj y caꞌin, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Y ri Pedro xutzꞌom ri rukꞌaꞌ derecha ri ache chi xupabꞌaꞌ, y ri rakan ja xaꞌcꞌujie-ka quichukꞌaꞌ y quireꞌ jeꞌ ri rukul-rakan. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y xirucꞌaka-pa-riꞌ, xpiꞌieꞌ y xꞌin. Y junan xuoc quiqꞌuin ri Pedro y ri Juan ri chireꞌ pa templo. Nucꞌakala-riꞌ bꞌanak, y nuyaꞌ jeꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Y iqꞌuiy vinak ri xaꞌtzꞌato chi ri ache reꞌ niꞌin y nuyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ri vinak cataꞌn chi ja ri ache reꞌ ri nucꞌutuj limosna, ri nicꞌujieꞌ chuchiꞌ ri puerta richin ri templo; ri puerta ri niꞌeꞌx La Hermosa cha. Rumareꞌ ri vinak reꞌ xaꞌchapataj y xquixiꞌij-quiꞌ ruma ri xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Y ri ache ri xꞌan sanar man ncaꞌrutzokopij ta can ri Pedro y ri Juan. Y qꞌuiy vinak ri xaꞌlka chiquitzꞌatic ri chireꞌ chupan jun corredor ri niꞌeꞌx Richin ri Salomón cha. Chaꞌnin xquimol-apa-quiꞌ, ruma man jun bꞌay quitzꞌatuon chi nibꞌanataj quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Y antok ri Pedro xaꞌrutzꞌat ri vinak, xuꞌej chica: Achiꞌaꞌ israelitas, ¿karruma ixreꞌ nquixchapataj ruma ri xbꞌanataj? ¿Y karruma xa ojreꞌ nkojitzꞌat como si fuera riqꞌuin ka-poder ojreꞌ o ja ri otz ri nakaꞌan choch ri Dios ri xbꞌano chi xꞌin va ache va? ");
INSERT INTO cakSNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ri Katataꞌ Dios, ri Qui-Dios jeꞌ ri ojier tak kateꞌt-kamamaꞌ, ri Abraham, ri Isaac, ri Jacob; can xuꞌon cꞌa cha ri Jesús, ri Rucꞌajuol, chi cꞌo rukꞌij. Pero ixreꞌ man xivajoꞌ ta xinimaj chi jajaꞌ ri Rucꞌajuol ri Dios. Xa xiyaꞌ pa rukꞌaꞌ ri Pilato, ri gobernador. Y antok ri Pilato ruꞌeꞌn chic chi nucol-el, ixreꞌ man xivajoꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Xa ja ri jun ache quimisaniel xicꞌutuj chi ticuol-el, y ri Santo y Choj ri rucꞌaslien, xa jareꞌ ri man xivajoꞌ ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Y can xiꞌan cha chi xquimisas ri Jesús ri niyoꞌn cꞌaslien. Pero ri Dios xuꞌon cha chi xcꞌastaj-pa chiquicajol ri quiminakiꞌ. Nakaꞌej quireꞌ chiva ruma ojreꞌ can xkatzꞌat antok cꞌastajnak chic pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Y ri jun ache ri ntitzꞌat-pa ixreꞌ kiqꞌuin y ivataꞌn jeꞌ roch, xꞌan sanar, ruma pa rubꞌeꞌ ri Jesús xkacꞌutuj-ve. Y ri ache xꞌan sanar chivach ixreꞌ ruma ri cukbꞌal cꞌuꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Y ojreꞌ kataꞌn chi antok ixreꞌ nuvanakil y ri achiꞌaꞌ ri nquixbꞌano gobernar xiꞌej chi tiquimisas ri Jesús, quireꞌ xiꞌan ruma man ivataꞌn ta chica jajaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ri Dios nuꞌon cumplir incheꞌl ri ruꞌeꞌn-pa. Jareꞌ xquiꞌej quinojiel ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, chi ri Cristo can nuꞌon-na-ve sufrir. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Vacame titzalaj-pa ivánima riqꞌuin ri Dios y tibꞌanaꞌ ri nrajoꞌ jajaꞌ y ticꞌaxaꞌ ri icꞌaslien, chi quireꞌ niꞌan perdonar ri i-pecados. Y xcaꞌpa tiempos richin uxlanien, antok ri Ajaf xticꞌujieꞌ chiꞌicajol. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Y ri Ajaf Dios xtutak-pa ri Jesucristo rucaꞌn mul, ri incheꞌl tzijuon-pa chiva. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Pero vacame nicꞌatzin chi jajaꞌ nicꞌujieꞌ chicaj, cꞌa xtalka-na ri kꞌij antok xtuchojmij nojiel. Quireꞌ nuꞌej ri Dios chupan ri quitzꞌibꞌan can ri santos profetas ri xaꞌcꞌujieꞌ ojier can tiempo. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ri Moisés xuꞌej chica ri kateꞌt-kamamaꞌ can: Ri Kajaf Dios xtupilisaj-pa jun profeta chiquicajol ri iviy-imáma ri xcaꞌcꞌujieꞌ más chakavach-apa; jun incheꞌl inreꞌ. Can tivaxaj nojiel ri xtuꞌej chiva. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Y ri man xcaꞌcꞌaxan ta ri profeta reꞌ, can xcaꞌlasas-el richin xa jun tiempo chiquicajol ri rutanamit chic ri Dios. Quireꞌ ri rutzꞌibꞌan can ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Y ri Pedro xuꞌej jeꞌ chica ri vinak: Quinojiel ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo desde Samuel, xaꞌchꞌoꞌ can chirij ri tiempo ri ojcꞌo vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Can ivichin ixreꞌ ri quiꞌeꞌn can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. Y can ivichin ixreꞌ ri xuꞌej ri Dios antok xuꞌon ri jun pacto quiqꞌuin ri kateꞌt-kamamaꞌ can, antok xuꞌej cha ri Abraham chi ri vinak ri icꞌo choch-ulief ncaꞌan bendecir ruma ri jun rumáma ri xticꞌujieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Y antok ri Dios xupilisaj-pa ri Jesús ri Rucꞌajuol, chiꞌicajol ixreꞌ xutak-ve naꞌay. Quireꞌ xuꞌon chi xuyaꞌ ri bendición chiva, ruma jajaꞌ nrajoꞌ chi ixvonojiel ntiyaꞌ can ri itziel icꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ri Pedro y ri Juan cꞌa ncaꞌchꞌoꞌ chica ri vinak, antok xaꞌlka ri sacerdotes y ri achiꞌaꞌ saduceos y ri qui-jefe ri achiꞌaꞌ ri niquichajij ri templo. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Y ri achiꞌaꞌ reꞌ can yacatajnak quiyoval chiquij ri Pedro y ri Juan, ruma ncaꞌquitijuoj ri vinak. Can niquitzijuoj chi ri Jesús quiminak chic el y xcꞌastaj-pa chiquicajol ri quiminakiꞌ, y rumareꞌ ri quiminakiꞌ can xcaꞌcꞌastaj chic pa jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Rumareꞌ xaꞌquitzꞌom-el ri icaꞌyeꞌ apóstoles reꞌ, y choj xaꞌbꞌaquiyaꞌ pa cárcel; xa cꞌa chucaꞌn kꞌij xaꞌquiꞌan arreglar, ruma tarde chic. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Y can iqꞌuiy chiquivach ri vinak ri xcaꞌxaj ri ruchꞌabꞌal ri Dios ri kꞌij reꞌ, xquinimaj. Quinojiel ri quiniman y ri xquinimaj ri kꞌij reꞌ, joꞌc ri achiꞌaꞌ icꞌo laꞌk jun ivuꞌuoꞌ mil. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Y chucaꞌn kꞌij, xquimol-quiꞌ chireꞌ Jerusalén ri achiꞌaꞌ ri ncaꞌbꞌano gobernar chiquicajol ri israelitas, ri mamaꞌaꞌ tak achiꞌaꞌ, ri achiꞌaꞌ escribas, ");
INSERT INTO cakSNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ri Anás ri sacerdote ri más cꞌo rukꞌij, ri Caifás, ri Juan, ri Alejandro, y quinojiel ri quimáma ri sacerdotes ri más cꞌo quikꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Y ri Pedro y ri Juan xaꞌbꞌacꞌamar-pa y xaꞌyoꞌx pa nicꞌaj. Y xquicꞌutuj chica: ¿Chica xyoꞌn poder chiva o chica choj bꞌeꞌ xiꞌej chi xꞌan sanar ri ache? xaꞌchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Y ri Pedro, nojnak cꞌa ránima riqꞌuin ri Espíritu Santo xuꞌej chica: Ixreꞌ achiꞌaꞌ ri nquixbꞌano gobernar chupan ri katanamit Israel, y ixreꞌ jeꞌ mamaꞌaꞌ tak achiꞌaꞌ: ");
INSERT INTO cakSNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ixreꞌ nticꞌutuj chika chirij ri favor ri xkaꞌan cha jun ache ri man otz ta rakan, chi chica xkacusaj chi xꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tivatamaj cꞌa ixreꞌ ri ixcꞌo-pa vaveꞌ, y ticatamaj jeꞌ quinojiel ri nicꞌaj chic israelitas, chi ri jun ache ri cꞌo vaveꞌ chivach, xꞌan sanar antok xkaꞌej ri rubꞌeꞌ ri Jesucristo ri aj-Nazaret, ri Jesucristo ri xiꞌej chi tiquimisas choch cruz, pero ri Dios xuꞌon cha chi xcꞌastaj-pa chiquicajol ri quiminakiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Ri Jesús man jun rakalien ibꞌanun cha, can incheꞌl niquiꞌan ri achiꞌaꞌ ri i-bꞌanoy-jay cha jun abꞌaj, niquiꞌej chi man nicꞌatzin ta. Pero xa ja ri abꞌaj reꞌ ri xyoꞌx ri lugar ri más nicꞌatzin chi quireꞌ ri jay man nitzak ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Y man jun chic ri nicalo kichin. Ruma ri choch-ulief xa man jun chic bꞌiꞌaj yoꞌn-pa chika chi nkojcolotaj, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Y antok ri achiꞌaꞌ ri ncaꞌbꞌano gobernar xaꞌquitzꞌat ri Pedro y ri Juan, can xaꞌchapataj. Ruma mesque manak qui-estudio y i-sencillo-oc, man niquixiꞌij ta quiꞌ. Can kꞌalaj chi ijejeꞌ xaꞌcꞌujieꞌ riqꞌuin ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Y man jun chica xaꞌtiquir xquiꞌej chica ri icaꞌyeꞌ apóstoles, ruma ri ache ri xcꞌachoj, paꞌl-apa quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Entonces xquiꞌej chi caꞌlasas-el chireꞌ ri Pedro y ri Juan, y joꞌc ijejeꞌ xaꞌcꞌujieꞌ can chi niquiꞌan pensar chica niquiꞌan. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Y ri achiꞌaꞌ reꞌ niquiꞌej chiquivach: ¿Chica xtakaꞌan chica? Ruma quinojiel ri vinak vaveꞌ Jerusalén cataꞌn chi xbꞌanataj jun nem milagro. Y ojreꞌ man nkojtiquir ta nakavaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Pero chi man titzijos más ri xbꞌanataj, caꞌkaxibꞌij-el, chi quireꞌ man niquitzijuoj ta chic ri Jesús chica ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Y xaꞌcayuoj chic apa ri Pedro y ri Juan, y xquiꞌej chica chi man chic caꞌquitijuoj ri vinak, y man chic tiquitzijuoj ri Jesús chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ri Pedro y ri Juan xaꞌchꞌo-apa, y xquiꞌej chica: Tiꞌej-na cꞌa chika: ¿Otz came choch ri Dios, xa ja ri ntiꞌej ixreꞌ ri nakaꞌan y man nakaꞌan ta ri nuꞌej jajaꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ojreꞌ manak cheꞌl chi man ta nakaꞌej chica ri vinak ri xkatzꞌat y xkaxaj, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Y ri achiꞌaꞌ ri ncaꞌbꞌano gobernar altíra xaꞌquixiꞌij-el ri Pedro y ri Juan y ja xaꞌquitzokopij-el. Can man jun kax ri xquil chiquij chi xaꞌquiꞌan ta castigar, ruma ri vinak can niquiyaꞌ rukꞌij ri Dios ruma ri xbꞌanataj riqꞌuin ri ache. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ruma ri ache ri xꞌan sanar ruma ri milagro reꞌ, xa más cuarenta rujunaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Y antok ri Pedro y ri Juan xaꞌtzokopis-el, xaꞌa pacheꞌ icꞌo-ve ri nicꞌaj chic discípulos, y xbꞌaquitzijuoj chica nojiel ri eꞌn-el chica cuma ri principales sacerdotes y ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Y antok ijejeꞌ xcaꞌxaj ri xquitzijuoj ri Pedro y ri Juan, quinojiel junan xquiꞌan orar y cava xquiꞌej chupan ri qui-oración: Namalaj Dios, atreꞌ ri xaꞌan nojiel; xaꞌan ri rocaj y ri icꞌo choch, xaꞌan ri roch-ulief y ri icꞌo choch, xaꞌan ri mar y ri icꞌo chupan. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Y atreꞌ xaꞌeꞌn cha ri asamajiel David, chi xuꞌej: ¿Karruma ri vinak ri pa tak naciones xa itziel tak kax nicajoꞌ niquiꞌan, y ri vinak ri icꞌo pa tak tanamet xa man jun rakalien ri niquiꞌan pensar? ");
INSERT INTO cakSNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Y xaꞌpalaj-pa ri reyes ri icꞌo choch-ulief. Y ri gobernadores xquimol-quiꞌ, chi xquiꞌan xa jun, chavij atreꞌ Ajaf Dios, y chirij jeꞌ ri Cristo. Quireꞌ rutzꞌibꞌan can ri David. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Y can ketzij, chi incheꞌl ri tzꞌibꞌan can chupan ri ruchꞌabꞌal ri Dios, can quireꞌ xbꞌanataj. Ruma ri Herodes y ri gobernador Poncio Pilato, ri israelitas y ri man israelitas ta, xquimol-quiꞌ vaveꞌ pa tanamet Jerusalén chi xaꞌpalaj chirij ri Jesús ri Santo Acꞌajuol ri xatak-pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Quireꞌ xquiꞌan richin chi xbꞌanataj ri can pan akꞌaꞌ atreꞌ cꞌo-ve, y aꞌeꞌn-pa chi xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Y vacame Ajaf, tatzꞌataꞌ ri vinak reꞌ ri ncaꞌxiꞌin, ruma yacatajnak quiyoval chikij ojreꞌ ri asamajiel. Y rumareꞌ ojreꞌ nakacꞌutuj chava chi tayaꞌ ka-valor chi quireꞌ man nakaxiꞌij ta kiꞌ nakatzijuoj ri atzij. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Y nakacꞌutuj jeꞌ chava, chi riqꞌuin ri a-poder ncaꞌan sanidad, señales, y milagros pa rubꞌeꞌ ri Jesús ri Santo Acꞌajuol, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Y antok xaꞌtanieꞌ riqꞌuin ri oración, can xsiluon ri lugar pacheꞌ quimaluon-ve-quiꞌ. Y xnuoj ri cánima riqꞌuin ri Espíritu Santo, rumareꞌ man niquixiꞌij ta quiꞌ chi niquitzijuoj ri ruchꞌabꞌal ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Y quinojiel ri vinak ri quiniman ri Jesucristo, junan niquiꞌan pensar y xa jun cánima quibꞌanun. Y man jun niꞌeꞌn chi joꞌc richin jajaꞌ ri cꞌo riqꞌuin, sino que nojiel ri kax quichin, niquijach chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ri apóstoles riqꞌuin ru-poder ri Dios niquitzijuoj chi ri Ajaf Jesús xcꞌastaj-pa chiquicajol ri quiminakiꞌ, y ri Dios can altíra ncaꞌruꞌon bendecir quinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Y chiquicajol ri quiniman chic ri Jesucristo, man jun kax nuꞌon falta chiquivach, ruma ri cꞌo culief o cꞌo cachuoch, ncaꞌquicꞌayij y ri rajal niquicꞌam-pa, ");
INSERT INTO cakSNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y nalquiyaꞌ chica ri apóstoles, y ri apóstoles niquiyaꞌ chica ri can nicꞌatzin chi ncaꞌtoꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Y cꞌo jun ache chiquicajol ri José rubꞌeꞌ. Y ri José reꞌ aj-Chipre, rumáma can ri Leví. Y ri apóstoles xquiyaꞌ jun chic rubꞌeꞌ. Y ri rubꞌeꞌ ri xquiyaꞌ, Bernabé. (Ri tzij Bernabé nuꞌej: Ncaꞌruꞌon consolar quinojiel.) ");
INSERT INTO cakSNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Y ri Bernabé reꞌ xucꞌayij jun rulief, y ri rajal xalruyaꞌ pa quikꞌaꞌ ri apóstoles. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Y cꞌo jun ache rubꞌinan Ananías y ri raxjayil rubꞌinan Safira, xquicꞌayij jun culief. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Y xquiꞌej chiquivach chi niquicꞌan can nicꞌaj rajal ri ulief, y ri nicꞌaj chic miera xucꞌuaj ri Ananías chi xbꞌaruyaꞌ pa quikꞌaꞌ ri apóstoles. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Y ri Pedro xuꞌej cha ri Ananías: ¿Karruma xayaꞌ lugar cha ri Satanás chi xunojsaj ri avánima, chi xatzꞌak tzij choch ri Espíritu Santo, y xacꞌan can nicꞌaj rajal ri ulief ri xacꞌayij? ");
INSERT INTO cakSNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Xa man ta xacꞌayij ri ulief, ¿man cꞌa avichin ta atreꞌ? Y antok xacꞌayij, ¿man avichin ta came atreꞌ ri rajal ri ulief? ¿Karruma xaꞌan pensar chi xaꞌan quireꞌ? Atreꞌ man chiquivach ta vinak xatzꞌak tzij, atreꞌ choch cꞌa ri Dios xatzꞌak tzij, xchaꞌ ri Pedro cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Y ri Ananías, joꞌc xraꞌxaj ri tzij ri xuꞌej ri Pedro, xtzak-ka y xcon. Y quinojiel ri xaꞌcꞌaxan ri xbꞌanataj, xpa cꞌa jun gran xibꞌinreꞌl chiquij. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Y icꞌo nicꞌaj cꞌojolaꞌ xaꞌpalaj-pa y xquibꞌol-el ri quiminak chupan tziak, y xquilasaj-el chi xiquimukuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Y cꞌo laꞌk jun oxeꞌ huora ticon ri Ananías, antok xalka ri raxjayil. Jajaꞌ man rataꞌn ta chica xbꞌanataj. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Y ri Pedro xucꞌutuj cha ri ixok reꞌ: Ri miera ri rucꞌamun-pa ri Ananías, ¿quireꞌ ri rajal ri ulief ri xicꞌayij? Y ri ixok xuꞌej: Quireꞌ, ja nojiel ri rajal ri ulief reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Y ri Pedro xuꞌej cꞌa cha: ¿Karruma ixreꞌ xixcꞌujieꞌ de acuerdo chi xiꞌan chi man nquixrutzꞌat ta pa ri Ru-Espíritu ri Ajaf? Ya ncaꞌlka chuchiꞌ ri puerta ri xaꞌbꞌamukuꞌ richin ri avachajil y ncatquilasaj-el jeꞌ atreꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Y ja xtzak-ka ri ixok choch ri Pedro, y xcon. Antok xaꞌuoc-pa ri cꞌojolaꞌ, xalquilaꞌ ri ixok quiminak chic, y xquilasaj-el y xiquimukuꞌ riqꞌuin ri rachajil. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y quinojiel ri quiniman ri Jesucristo ri niꞌeꞌx iglesia chica, xpa cꞌa jun gran xibꞌinreꞌl chiquij ruma ri xbꞌanataj. Y quireꞌ jeꞌ xquiꞌan ri nicꞌaj chic ri xaꞌcꞌaxan ri xbꞌanataj. Can altíra xquixiꞌij-quiꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Y ri apóstoles qꞌuiy señales y milagros ri ncaꞌquiꞌan chiquivach ri vinak. Y ri quiniman chic ri ruchꞌabꞌal ri Dios, junan niquimol-quiꞌ chuchiꞌ jun corredor richin ri templo. Ri corredor reꞌ, Richin ri Salomón ncaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Y icꞌo vinak ri man nicajoꞌ ta ncaꞌjiel quiqꞌuin ruma niquixiꞌij-quiꞌ. Pero icꞌo nicꞌaj chic vinak ri niquiyaꞌ quikꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Pero iqꞌuiy vinak ri niquinimaj ri Ajaf Jesucristo. Rumareꞌ kꞌij-kꞌij ncaꞌqꞌuiyir-ka más, chi ixokiꞌ chi achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Y ncaꞌlasas-pa ri ncaꞌyavaj pa tak bꞌay y ncaꞌyoꞌx choch varaꞌal y choch camilla, chi quireꞌ antok ri Pedro nakꞌax, mesque joꞌc ri rumuchꞌuchꞌil nika pa quiveꞌ nicꞌaj chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Y iqꞌuiy cꞌa vinak ri icꞌo pa tak tanamet ri icꞌo cierca ri Jerusalén, xaꞌlka chireꞌ pa tanamet, i-quicꞌamun-pa ri ncaꞌyavaj y ri niquiꞌan sufrir pa quikꞌaꞌ itziel tak espíritus. Y quinojiel ncaꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Pero ri sacerdote ri más cꞌo rukꞌij y ri achiꞌaꞌ saduceos ri icꞌo riqꞌuin, itziel ncaꞌquitzꞌat ri apóstoles. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Rumareꞌ xaꞌbꞌaquitzꞌama-pa y xaꞌbꞌaquiyaꞌ pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Y ri chakꞌaꞌ, ri Ajaf xutak-pa jun ángel quiqꞌuin ri apóstoles. Ri ángel reꞌ xujak ri ruchiꞌ ri cárcel chiquivach chi xaꞌralasaj-el, y xuꞌej chica: ");
INSERT INTO cakSNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Quixꞌin. Y antok nquixbꞌaka pa templo, titzijuoj chica ri vinak nojiel ri chꞌabꞌal ri nichꞌoꞌ chirij ri cꞌacꞌacꞌ cꞌaslien ri nuyaꞌ ri Jesucristo, xchaꞌ ri ángel. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Y joꞌc xcaꞌxaj reꞌ ri apóstoles, cumaj yan ri chucaꞌn kꞌij xaꞌa pa templo y ncaꞌquitijuoj ri vinak. Y chupan ri huora reꞌ, ri sacerdote ri más cꞌo rukꞌij y ri icꞌo riqꞌuin, xaꞌquitak quiyoxic ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar. Quinojiel ri achiꞌaꞌ reꞌ xquimol-quiꞌ ruma ijejeꞌ ri autoridades richin ri tanamet. Y cꞌajareꞌ xquiꞌej chi caꞌcꞌamar-pa ri apóstoles ri icꞌo pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Pero antok ri achiꞌaꞌ i-chajiniel ri i-takuon-el xaꞌbꞌaka pa cárcel, manak xaꞌquil ri apóstoles. Can ja xaꞌtzalaj-pa, y xbꞌaquiyaꞌ rutzijuol, ");
INSERT INTO cakSNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","y xbꞌaquiꞌej cꞌa: Ri cárcel can otz tzꞌapal can, y ri soldados icꞌo chuchiꞌ ri puertas; pero antok xkajak ri puertas i-manak ijejeꞌ chupan, xaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Y antok ri sacerdote ri más cꞌo rukꞌij y ri qui-jefe ri achiꞌaꞌ ri i-chajiniel pa templo y ri principales sacerdotes xcaꞌxaj ri xquiꞌej ri chajiniel chica, man niquil ta chica niquiꞌan pensar, y rumareꞌ niquiꞌej chiquivach: ¿Cꞌa pacheꞌ cꞌa xtibꞌaka-ve reꞌ? ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Y cꞌo jun ri xbꞌaka quiqꞌuin ri quimaluon-quiꞌ, y xbꞌaruꞌej chica: Ri achiꞌaꞌ ri xiꞌtzꞌapij pa cárcel ja ncaꞌquitijuoj ri vinak pa templo, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Y ri ache ri qui-jefe ri chajiniel, xꞌa quiqꞌuin ri chajiniel chi xaꞌbꞌaquicꞌamaꞌ ri apóstoles y man jun kax xquiꞌan-pa chica, ruma niquixiꞌij-quiꞌ chi ncaꞌcꞌak cha abꞌaj cuma ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Y antok ri achiꞌaꞌ reꞌ xaꞌquicꞌam-pa ri apóstoles, choj xaꞌbꞌaquiyaꞌ chiquivach ri autoridades richin ri tanamet. Y ri sacerdote ri más cꞌo rukꞌij xucꞌutuj chica ri apóstoles: ");
INSERT INTO cakSNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Ojreꞌ ya xkaꞌan mandar chiva chi man chic quiꞌitijuoj ri vinak riqꞌuin ri rubꞌeꞌ ri Jesús. Pero vacame ri tanamet Jerusalén nojnak chic riqꞌuin nojiel ri nticꞌut, y can chikij ojreꞌ ntivajoꞌ ntiya-ve ri rucamic ri jun ache reꞌ, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pero ri Pedro y ri nicꞌaj chic apóstoles xquiꞌej-apa: Can nicꞌatzin chi ja ri nuꞌej ri Dios nakanimaj, y man ja ta ri nicajoꞌ ri achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ruma ri xbꞌano cha ri Jesús chi xcꞌastaj-pa, ja ri Qui-Dios ri kateꞌt-kamamaꞌ. Pero ixreꞌ xiquimisaj antok xiꞌej chi tibꞌajix choch cruz. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Y ri Dios más nem rukꞌij xuyaꞌ ri Jesús, xutzꞌuyubꞌaꞌ pa ru-derecha, y xuꞌon cha chi jajaꞌ ri Ucꞌuay-Bꞌay y Salvador (caloy-quichin ri vinak), chi quireꞌ ri israelitas nitzalaj-pa cánima riqꞌuin ri Dios y niquiꞌan ri nrajoꞌ jajaꞌ y chi niꞌan perdonar ri qui-pecados. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Y nojiel reꞌ ketzij, y ojreꞌ can xkatzꞌat, rumareꞌ nakatzijuoj. Y ri Espíritu Santo jeꞌ nutzijuoj chi can ketzij. Konojiel ri kaniman ri rutzij ri Dios, can ruyoꞌn-pa ri Espíritu Santo chika. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Y antok ri autoridades richin ri tanamet xcaꞌxaj ri xquiꞌej ri apóstoles, xyacataj quiyoval y can ta xcajoꞌ xaꞌquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Pero chiquicajol ri autoridades reꞌ, cꞌo jun ache fariseo, y ri ache reꞌ rubꞌinan Gamaliel. Jajaꞌ jun maestro richin ri ru-ley ri Moisés, y can cꞌo rukꞌij chiquivach ri vinak. Ri ache reꞌ xpiꞌieꞌ, y xuꞌej chi caꞌlasas-el juviera ri apóstoles jun rato. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Y después xuꞌej: Achiꞌaꞌ israelitas, tibꞌanaꞌ pensar otz chica xtiꞌan chica ri achiꞌaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ruma talka pan iveꞌ antok xcꞌujieꞌ ri jun ache Teudas rubꞌeꞌ. Ri Teudas reꞌ xuꞌej chi jajaꞌ jun ache cꞌo rukꞌij, y icꞌo laꞌk cuatrocientos achiꞌaꞌ ri xaꞌa chirij. Y antok xquimisas, quinojiel xquiquiraj-quiꞌ y xaꞌqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Y después reꞌ, chupan ri tiempo antok xꞌan ri censo, xcꞌujieꞌ jun chic ache Judas rubꞌeꞌ. Jajaꞌ aj-Galilea, y can xtiquir xuꞌon chi iqꞌuiy vinak ri xaꞌa chirij. Y antok xquimisas, quinojiel ri i-bꞌanak chirij xquiquiraj-quiꞌ jeꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Y rumareꞌ niꞌej chiva chi quiꞌiyaꞌ can ri achiꞌaꞌ reꞌ. Ruma xa quinoꞌj achiꞌaꞌ ri niquiꞌan, xa xtiqꞌuis. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Pero xa richin ri Dios, man jun cꞌa xquixtiquir ntiꞌan chi xcaꞌqꞌuis. Tibꞌanaꞌ cuenta-iviꞌ, man tiꞌan chi xa ixreꞌ nquixajin chi ayoval riqꞌuin ri Dios, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Y quinojiel xka chiquivach ri xuꞌej ri Gamaliel. Y xquiꞌej chi caꞌcꞌamar chic pa ri apóstoles. Y después antok xaꞌchꞌay, xquiꞌej chica chi man chic tiquitzijuoj ri rubꞌeꞌ ri Jesús chica ri vinak. Y cꞌajareꞌ xaꞌquitzokopij-el chi xaꞌa. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Y antok ri apóstoles xaꞌiel-el chireꞌ chiquivach ri autoridades richin ri tanamet, niquicuot ri cánima xaꞌa, ruma yoꞌn chica chi niquikꞌasaj ri sufrimiento ruma ri rubꞌeꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Y nojiel kꞌij ri pa templo y pa tak jay, man ncaꞌtanieꞌ ta chi niquicꞌut y niquitzijuoj rubꞌeꞌ ri Jesucristo. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chupan ri tiempo reꞌ, ri discípulos más ncaꞌqꞌuiyir-ka. Y ri ncaꞌchꞌoꞌ griego niquiꞌej chiquij ri ncaꞌchꞌoꞌ hebreo, chi ri malcaꞌn-ixokiꞌ ri icꞌo chiquicajol ri ncaꞌchꞌoꞌ griego, man ncaꞌan ta atender otz antok nijach kꞌij-kꞌij ri chica niquitej. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Rumareꞌ ri doce (cabꞌalajuj) apóstoles xaꞌquimol quinojiel ri discípulos, y xquiꞌej chica: Man otz ta chi ojreꞌ nakayaꞌ can ri nakatzijuoj ri ruchꞌabꞌal ri Dios, richin chi nquixkilij. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Vacame cꞌa hermanos, quiꞌicha-pa i-siete (ivukuꞌ) achiꞌaꞌ chiꞌicajol, ri ivataꞌn chi can choj ri quicꞌaslien, cꞌo quinoꞌj y nojnak cánima riqꞌuin ri Espíritu Santo, chi quireꞌ ijejeꞌ ri ncaꞌkayaꞌ choch ri samaj chi niquijach ri chica nitij. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Y chi quireꞌ ojreꞌ nakaꞌan ri samaj incheꞌl ri kabꞌanun-pa. Nakaꞌan orar, y nakacꞌut ri ruchꞌabꞌal ri Dios, xaꞌchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Y quinojiel xka chiquivach ri xꞌeꞌx chica cuma ri apóstoles, y xaꞌquichaꞌ i-siete (ivukuꞌ) achiꞌaꞌ. Jun ja ri Esteban, jun ache ri can jaꞌal-ve rucukubꞌan rucꞌuꞌx riqꞌuin ri Dios y nojnak ránima riqꞌuin ri Espíritu Santo. Ri nicꞌaj chic ja ri Felipe, ri Prócoro, ri Nicanor, ri Timón, ri Parmenas y ri Nicolás ri aj-Antioquía. Ri ache Nicolás rubꞌeꞌ man israelita ta, pero can runiman ri nuꞌej ri ru-ley ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Y ja ri i-siete (ivukuꞌ) achiꞌaꞌ reꞌ ri xaꞌquipabꞌaꞌ chiquivach ri apóstoles. Xaꞌpa ri apóstoles xquiꞌan orar, y xquiyaꞌ quikꞌaꞌ pa quiveꞌ ri achiꞌaꞌ reꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Y ri ruchꞌabꞌal ri Dios riqꞌuin ruchukꞌaꞌ bꞌanak, y ncaꞌqꞌuiyir jeꞌ ri discípulos chireꞌ pa tanamet Jerusalén. Y iqꞌuiy jeꞌ chiquivach ri sacerdotes ri niquicukubꞌaꞌ quicꞌuꞌx riqꞌuin ri Jesucristo. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ri Esteban jun ache ri cꞌo ri ru-poder ri Dios riqꞌuin, y cꞌo jeꞌ ri ru-favor ri Dios riqꞌuin. Y ncaꞌruꞌon nimaꞌk tak milagros y señales chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Pero icꞌo vinak ri xaꞌbꞌapalaj-pa y xquitzꞌom-quiꞌ chi tzij riqꞌuin ri Esteban. Ri vinak reꞌ i-richin jun sinagoga ri niꞌeꞌx quichin ri Esclavos Libertados cha, y quichin jeꞌ ri vinak aj-Cirene, aj-Alejandría, aj-Cilicia y aj-Asia. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Y ri Esteban ja ri Espíritu Santo ri xyoꞌn runoꞌj, rumareꞌ antok jajaꞌ xchꞌoꞌ, ri vinak man xaꞌtiquir ta chirij. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Rumareꞌ xaꞌquitoj nicꞌaj chi tiquiꞌej chi xcaꞌxaj chi ri Esteban itziel xchꞌoꞌ chirij ri ru-ley ri Moisés y chirij jeꞌ ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Y antok ri mamaꞌaꞌ tak achiꞌaꞌ ri niquiꞌan gobernar, ri achiꞌaꞌ escribas y ri vinak ri icꞌo quiqꞌuin xcaꞌxaj reꞌ, ja xaꞌbꞌapalaj-pa chirij ri Esteban; xbꞌaquitzꞌama-pa y xquicꞌuaj chiquivach ri autoridades richin ri tanamet chi tiꞌan juzgar. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Y icꞌo jeꞌ achiꞌaꞌ xaꞌquiyaꞌ chi niquitzꞌak tzij chirij ri Esteban. Ri achiꞌaꞌ reꞌ niquiꞌej: Va ache va man nitanieꞌ ta ncaꞌruꞌej itziel tak kax chirij ri santo templo y chirij ri ru-ley ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ruma kaxan cꞌa ri nuꞌej chi ri Jesús aj-Nazaret xtuvulij ri templo y xtucꞌax nojiel ri costumbres ri xuyaꞌ ri Moisés chika. ");
INSERT INTO cakSNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Y quinojiel ri achiꞌaꞌ ri i-tzꞌuyul pacheꞌ icꞌo-ve ri autoridades richin ri tanamet, xquitzꞌat chi ri rupalaj ri Esteban xcꞌaxtaj, y can incheꞌl titzuꞌn jun ángel xuꞌon-ka. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Y ri sacerdote ri más cꞌo rukꞌij xucꞌutuj cha ri Esteban: ¿Ketzij cꞌa ri niꞌeꞌx chavij? ");
INSERT INTO cakSNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ri Esteban xuꞌej: Achiꞌaꞌ israelitas y ixreꞌ tataꞌj chupan ri katanamit, tivaxaj ri xtinꞌej chiva: Ri Dios ri cꞌo rukꞌij xucꞌut-riꞌ choch ri kamamaꞌ Abraham ojier can tiempo, antok cꞌa cꞌo chupan ri lugar rubꞌinan Mesopotamia, antok cꞌa majaꞌ rutzijuol chi nicꞌujieꞌ Harán. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Y ri Dios xuꞌej cha ri Abraham: Catiel-pa chiquicajol ri avachꞌalal, y tayaꞌ can ri atanamit, y catam-pa chupan ri lugar ri xtincꞌut chavach, xchaꞌ ri Dios cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Y ri Abraham xuyaꞌ can ri lugar rubꞌinan Caldea y xbꞌacꞌujieꞌ chupan ri tanamet Harán. Y chireꞌ chupan ri Harán xcon ri rutataꞌ ri Abraham, después ri Dios xucꞌam-pa ri Abraham chupan ri Canaán ri pacheꞌ ojcꞌo-ve vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Y ri Dios manak herencia xuyaꞌ cha ri Abraham chupan ri lugar reꞌ, nixta pacheꞌ nipiꞌie-ve. Pero ri Dios xuꞌon prometer cha chi ri lugar reꞌ xtuoc richin jajaꞌ y quichin ri rumáma ri xcaꞌcꞌujieꞌ, mesque ri tiempo reꞌ ri Abraham majaꞌ ticꞌujieꞌ ralcꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Y xꞌeꞌx jeꞌ cha ruma ri Dios, chi ri rumáma jajaꞌ xcaꞌbꞌacꞌujieꞌ chupan jun chic nación, chupan ulief ri man quichin ta. Y ri vinak ri icꞌo chupan ri nación reꞌ xcaꞌquiyaꞌ pa samaj y man xcaꞌtuoj ta y xtiquiꞌan chica chi niquiꞌan sufrir cuatrocientos junaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Y ri Dios xuꞌej jeꞌ: Ri nación ri quireꞌ xtibꞌano chica ri rumáma ri Abraham, can xtinꞌan juzgar. Y cꞌajareꞌ xcaꞌiel-pa chireꞌ, y xcaꞌpa chupan va lugar va, y niquiyaꞌ nukꞌij, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Y ri Dios xuꞌon jun pacto riqꞌuin ri Abraham. Ri pacto reꞌ cꞌo jun ratal. Y ri ratal ri pacto reꞌ, ja ri circuncisión ri niꞌan chica ri cꞌojolaꞌ. Y antok xalax ri Isaac ri rucꞌajuol ri Abraham, xuꞌon ri circuncisión cha antok xtzꞌakat ri ocho (vakxakiꞌ) kꞌij chi xalax. Quireꞌ jeꞌ xuꞌon ri Isaac antok xalax ri Jacob ri rucꞌajuol. Y quireꞌ jeꞌ xuꞌon ri Jacob quiqꞌuin ri i-doce (cabꞌalajuj) rucꞌojolaꞌ ri xaꞌuoc tataꞌj. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Y ri i-nimaꞌk rucꞌojolaꞌ ri Jacob itziel xquitzꞌat ri quichakꞌ José, ruma jajaꞌ ri más najoꞌx. Y rumareꞌ xquicꞌayij-el, y xucꞌuax cꞌa Egipto. Pero ri Dios cꞌo riqꞌuin ri José, ");
INSERT INTO cakSNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","y xucol choch nojiel sufrimiento. Ri Dios xuꞌon cha ri Faraón ri rey richin ri nación Egipto, chi otz xutzꞌat ri José, y xutzꞌat jeꞌ chi cꞌo runoꞌj. Rumareꞌ ri rey xuꞌon cha ri José chi xuoc gobernador chupan Egipto, y xuoc jeꞌ encargado chupan ri rachuoch. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Y ri tiempo reꞌ paroꞌ ri Egipto y ri Canaán, xpa jun viꞌjal, y jun nem sufrimiento xka pa quiveꞌ. Y ri kateꞌt-kamamaꞌ ri icꞌo Canaán manak chic kax niquil chi niquitej. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Antok xraꞌxaj ri Jacob chi cꞌo trigo chupan ri Egipto, xaꞌrutak-el ri ralcꞌual ri naꞌay mul chulokꞌic trigo; ri ralcꞌual jareꞌ ri i-kamamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Y antok xaꞌa rucaꞌn mul, cꞌajareꞌ antok ri José xuꞌej chica ri runimal y cha ri ruchakꞌ, chi jajaꞌ ri José. Y rumareꞌ ri Faraón xunaꞌiej chi ri José icꞌo runimal y ruchakꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Cꞌajareꞌ ri José xutak quiyoxic ri Jacob ri rutataꞌ y ri rachꞌalal, i-setenta y cinco chiquinojiel. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Quireꞌ xxulie-ka ri Jacob cꞌa Egipto. Chireꞌ xcon-ve jajaꞌ y ri ralcꞌual ri i-kamamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Pero ri qui-cuerpo, cꞌa pa jun lugar rubꞌinan Siquem xaꞌmuk-ve. Xaꞌbꞌamuk chupan jun ulief pacheꞌ cꞌo-ve jun jul cꞌatuon choch jun tanatic. Ri jun ulief reꞌ, ja ri Abraham ri lakꞌayuon can chica ri i-ralcꞌual ri ache xubꞌinaj Hamor. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Pero antok nijiel-pa ri tiempo richin ri promesa ri rubꞌanun-pa jurar ri Dios cha ri Abraham, ri tanamet Israel más xnimar y xqꞌuiyir-ka chupan ri Egipto, ");
INSERT INTO cakSNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","hasta cꞌa antok chireꞌ Egipto xuoc can jun cꞌacꞌacꞌ rey ri man rataꞌn ta roch ri José. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Y ri cꞌacꞌacꞌ rey reꞌ xuꞌon maña cha ri ka-nación. Xuꞌon chica ri kateꞌt-kamamaꞌ chi xquikꞌasaj qꞌuiy sufrimiento, ruma xuꞌon chica chi ri calcꞌual joꞌc ncaꞌlax, ja ncaꞌbꞌacꞌak chi ncaꞌcon, ruma man nrajoꞌ ta chi ncaꞌqꞌuiyir-ka más. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Chupan ri tiempo reꞌ xalax ri Moisés. Y can otz xtzꞌiet ruma ri Dios. Oxeꞌ icꞌ ri xꞌan cuenta cuma ri rutie-rutataꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Y después antok xyoꞌx choch peligro paroꞌ ri río, xucꞌuax ruma ri rumiꞌal ri Faraón y can incheꞌl ral xuꞌon cha ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Y xcꞌut choch ri Moisés nojiel ri noꞌj ri cꞌo quiqꞌuin ri aj-Egipto. Can jun nem ache xuꞌon-ka riqꞌuin ri nuꞌon y riqꞌuin ri nuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Antok ri Moisés cꞌo cuarenta rujunaꞌ, xalax pa ránima chi xaꞌbꞌarutzꞌataꞌ ri ruvanakil israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Y xutzꞌat chi jun aj-Egipto nuchꞌey jun israelita. Y chi xutoꞌ ri ruvanakil, xuꞌon rucꞌaxiel cha ri aj-Egipto y xuquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Jajaꞌ xuꞌon-ka pensar chi ri ruvanakil israelitas xtiꞌka pa quiveꞌ (xtiquiꞌan entender) chi jajaꞌ ri takuon-pa ruma ri Dios chi ncaꞌrucol pa quikꞌaꞌ ri aj-Egipto, pero ijejeꞌ xa man xiꞌka ta pa quiveꞌ (man xquiꞌan ta entender) chi quireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Y chucaꞌn kꞌij, icꞌo icaꞌyeꞌ israelitas ncaꞌyovar, y ri Moisés xalka quiqꞌuin, y xrajoꞌ ta xujach quivach chi quireꞌ man chic ncaꞌyovar. Rumareꞌ jajaꞌ xuꞌej chica: ¿Karruma nquixayovar? Ixreꞌ israelitas ri ix caꞌyeꞌ, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Pero ri jun ri nichꞌayuon, xunem ri Moisés y xuꞌej: ¿Chica xayoꞌn chi naꞌan gobernar pa kaveꞌ y chi at juez pa kaveꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿O navajoꞌ nquinaquimisaj inreꞌ incheꞌl xaꞌan cha ri jun ache aj-Egipto ri ivir? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Y antok ri Moisés xraꞌxaj quireꞌ, xnumaj y xꞌa cꞌa ri nación Madián. Y chireꞌ, chiquicajol vinak ri man i-ruvanakil ta, xcꞌujie-ve. Chireꞌ xcꞌulieꞌ y xaꞌcꞌujieꞌ icaꞌyeꞌ ralcꞌual. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Y antok kꞌaxnak chic cuarenta junaꞌ ticꞌujieꞌ ri Moisés chireꞌ Madián, jun ángel xucꞌut-riꞌ choch chupan jun kꞌayis cꞌo ruqꞌuixal ri rubꞌinan zarza ri nicꞌat pa kꞌakꞌ. Reꞌ xutzꞌat chupan jun desierto, ri pacheꞌ cꞌo-ve ri juyuꞌ Sinaí. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Y antok ri Moisés xutzꞌat reꞌ, can xchapataj. Y chi nutzꞌat más otz, xjiel-apa cierca. Pero jareꞌ antok xchꞌo-pa ri Ajaf cha, y xuꞌej: ");
INSERT INTO cakSNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Inreꞌ ri Qui-Dios ri avateꞌt-amamaꞌ. Inreꞌ in Ru-Dios ri Abraham, in Ru-Dios ri Isaac y in Ru-Dios ri Jacob, xchaꞌ. Y ri Moisés xuxiꞌij-riꞌ chi xtzuꞌn chic apa, xa nibꞌarbꞌuot. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Y ri Ajaf xuꞌej jeꞌ cha ri Moisés: Tavalasaj-el la axajabꞌ chavakan, ruma ri lugar pacheꞌ at-paꞌl-ve can santo. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Y vacame catam-pa y ncantak-el Egipto chi nacol ri nutanamit, ruma nitzꞌat chi qꞌuiy sufrimiento niquikꞌasaj, y vaxan jeꞌ ri okꞌiej ri niquiꞌan, y mareꞌ xika-pa chi ncaꞌncol, xchaꞌ ri Ajaf cha ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Y ri Moisés reꞌ, man xcajoꞌ ta ri ruvanakil antes, antok xquiꞌej cha: ¿Chica xayoꞌn chi nkojaꞌan gobernar y chi at juez pa kaveꞌ? Ja Moisés reꞌ ri xtak-el ruma ri Dios, chi xaꞌrucol ri ruvanakil y chi jajaꞌ jeꞌ nucꞌuan quichin. Y ri xtoꞌn richin ri Moisés, ja ri ángel ri xucꞌut-riꞌ chupan ri jun kꞌayis ri cꞌo ruqꞌuixal ri rubꞌinan zarza. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Jajaꞌ ri xalasan-pa quichin ri kateꞌt-kamamaꞌ chireꞌ Egipto. Jajaꞌ xaꞌruꞌon nimaꞌk tak milagros y señales chupan ri nación Egipto, chupan ri Mar Rojo, y chupan jeꞌ ri desierto durante cuarenta junaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Y ri Moisés xuꞌej chica ri kavanakil ri tiempo reꞌ chirij ri Cristo: Ri Kajaf Dios xtupilisaj-pa jun profeta chiquicajol ri iviy-imáma ri xcaꞌcꞌujieꞌ más chakavach-apa; jun incheꞌl inreꞌ. Can tivaxaj cꞌa ri rutzij. Quireꞌ ruꞌeꞌn can ri Moisés. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Y jareꞌ ri Moisés ri xcꞌujieꞌ chiquicajol ri kavanakil israelitas chupan ri desierto. Y ja jeꞌ jajaꞌ ri xꞌeꞌn chica ri kateꞌt-kamamaꞌ ri tzij ri xuꞌej ri ru-ángel ri Dios cha paroꞌ ri juyuꞌ Sinaí. Can cha cꞌa jajaꞌ xjach-ve ri tzij richin ri cꞌaslien chi quireꞌ jajaꞌ xuyaꞌ chika. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Xa ja ri kateꞌt-kamamaꞌ man xaꞌniman ta cha ri Moisés. Pa rucꞌaxiel chi xaꞌniman cha, man xcajoꞌ ta, ri cánima ijejeꞌ chaꞌnin xtzalaj cꞌa chupan ri nación Egipto. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Y antok ri Moisés cꞌa cꞌo paroꞌ ri juyuꞌ Sinaí, xquiꞌej cha ri Aarón: Tabꞌanaꞌ ka-dioses chi quireꞌ ijejeꞌ ncaꞌcꞌuan kichin. Ruma ri Moisés ri xalasan-pa kichin chupan ri Egipto, man kataꞌn ta chica xuꞌon. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Y can xquiꞌan jun chꞌiti váquix y can xaꞌquicuot riqꞌuin. Rumareꞌ xaꞌquiquimisaj chicop choch, chi xquiyaꞌ rukꞌij ri ídolo. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rumareꞌ ri Dios xaꞌruyaꞌ can ri kavanakil, y xuyaꞌ lugar chica chi tiquiyaꞌ cꞌa quikꞌij ri ncaꞌtzꞌiet chicaj. Can quireꞌ quitzꞌibꞌan can ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo. Chupan ri tzꞌibꞌan can, ri Dios nuꞌej: Ixreꞌ aj-Israel, antok xixcꞌujieꞌ cuarenta junaꞌ chupan ri desierto, ¿chuva came inreꞌ xiyaꞌ ri chicop ri xiꞌquimisaj chireꞌ? ");
INSERT INTO cakSNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pa rucꞌaxiel reꞌ xa xitaliej ri rachuoch ri dios Moloc, y xiyaꞌ rukꞌij ri ru-estrella (ruchꞌumil) ri i-dios rubꞌinan Renfán. Y jareꞌ ri i-dios ri xiꞌan chi xiyaꞌ quikꞌij. Rumareꞌ inreꞌ, xchaꞌ ri Dios, xtinꞌan chiva chi nquixbꞌacꞌujieꞌ más cꞌa cala choch ri Babilonia. Quireꞌ nuꞌej chupan ri quitzꞌibꞌan can ri profetas. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Y antok ri kateꞌt-kamamaꞌ xaꞌcꞌujieꞌ chupan ri desierto, can quicꞌuan ri rachuoch ri Dios ri bꞌanun cha tziak, y chireꞌ nucꞌut-ve-riꞌ ri Dios chiquivach. Ri rachuoch ri Dios xꞌan cha can incheꞌl ri xrajoꞌ, ruma ri Dios can xucꞌut choch ri Moisés ri chica rubꞌanic nrajoꞌ chi niꞌan cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Y ja rachuoch ri Dios reꞌ ri quicꞌamun-pa ri kateꞌt-kamamaꞌ antok xaꞌuoc-pa chupan ri lugar rubꞌinan Canaán, antok i-cꞌamun-pa ruma ri Josué. Y xaꞌcꞌujie-ka vaveꞌ, antok xaꞌchꞌacuon chiquij ri vinak ri icꞌo chupan ri lugar reꞌ. Can ja ri Dios xtoꞌn quichin chi xaꞌquilasaj-el ri vinak ri man israelitas ta. Y ri rachuoch ri Dios ri quicꞌamun-pa antok xaꞌlka, cꞌa cꞌo pa ru-tiempo ri rey David. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Y ri rey reꞌ can altíra xajoꞌx ruma ri Dios. Rumareꞌ jajaꞌ xucꞌutuj favor cha ri Dios chi tuyaꞌ lugar cha chi nuꞌon jun ru-templo richin ri Ru-Dios ri Jacob ri kamamaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Pero man ja ta ri rey David ri xbꞌano ri templo. Xa ja ri Salomón ri rucꞌajuol ri rey David ri xbꞌano ri templo. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Pero ri Namalaj Dios man nicꞌujieꞌ ta chupan templos ri canun achiꞌaꞌ. Incheꞌl rutzꞌibꞌan can jun profeta ri xcꞌujieꞌ ojier can tiempo: ");
INSERT INTO cakSNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Ri Ajaf Dios nuꞌej: Ri rocaj jareꞌ ri nu-trono, y ri roch-ulief jareꞌ ri pacheꞌ niya-ve ri vakan. ¿Chica cꞌa jay ntiꞌan ixreꞌ chi vichin inreꞌ? ¿Y pacheꞌ cꞌo-ve ri lugar ri ntiꞌan chi nquinuxlan? ");
INSERT INTO cakSNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Man xinꞌan ta came nojiel kax riqꞌuin nukꞌaꞌ? Quireꞌ nuꞌej ri rutzꞌibꞌan can ri profeta. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Y ri Esteban xuꞌej jeꞌ chica: ¡Ixreꞌ cof ranun ri ivánima, ruma man ntivajoꞌ ta ntivaxaj ri nuꞌej ri Dios chiva, ni man ntiyaꞌ ta jeꞌ lugar chi ntuoc riqꞌuin ivánima, y man ntiyaꞌ ta lugar chi ja ta ri Espíritu Santo ri nucꞌuan ivichin! Y can incheꞌl ri xquiꞌan ri ojier tak kateꞌt-kamamaꞌ, can quireꞌ jeꞌ ri ntiꞌan ixreꞌ vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Cꞌo came jun chiquivach ri profetas ri xaꞌcꞌujieꞌ ojier can tiempo, ri man ta xuꞌon sufrir pa quikꞌaꞌ ri ivateꞌt-imamaꞌ? Ri ivateꞌt-imamaꞌ xaꞌquiquimisaj ri xaꞌeꞌn chi xtipa ri Cristo ri can choj ri rucꞌaslien. Y antok xalka ri Cristo, ixreꞌ chic ri xixjacho richin y xiꞌej chi tiquimisas. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Y ri Dios xuyaꞌ ri ley chica ángeles chi xalquiyaꞌ chiva. Pero ixreꞌ man xinimaj ta, xchaꞌ ri Esteban chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Y antok ri autoridades richin ri tanamet xcaꞌxaj ri xuꞌej ri Esteban, xyacataj quiyoval y can niquikꞌachꞌachꞌiej coray chirij. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ri Esteban can jun ache ri nojnak ránima riqꞌuin ri Espíritu Santo. Jajaꞌ xtzuꞌn-el chicaj, xutzꞌat ri ru-gloria ri Dios, y xutzꞌat ri Jesús cꞌo pa ru-derecha ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Y jareꞌ antok xuꞌej: Inreꞌ nitzꞌat la rocaj jakal y nitzꞌat ri Xtak-pa chicaj chi xalax chikacajol cꞌo pa ru-derecha ri Dios, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Y ri vinak, ruma man nicajoꞌ ta chic nicaꞌxaj, xquitzꞌapij quixiquin; y ncaꞌsiqꞌuin xaꞌpalaj-pa chirij y xbꞌaquitzꞌama-pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Y xquilasaj-el chuchiꞌ ri tanamet, y xquicꞌak cha abꞌaj. Y ri xaꞌtzꞌako tzij chirij ri Esteban xquiyaꞌ can ri quitziak chirakan jun alaꞌ rubꞌinan Saulo. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Y antok ri Esteban nicꞌak cha abꞌaj, jajaꞌ nuꞌon orar y nuꞌej: Vajaf Jesús, tabꞌanaꞌ recibir ri nu-espíritu. ");
INSERT INTO cakSNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Y jajaꞌ xxuquie-ka, y xurak ruchiꞌ chi xchꞌoꞌ y xuꞌej: Vajaf, man taꞌan chica chi nicakaj ri pecado ri niquiꞌan, xchaꞌ. Y joꞌc cꞌa reꞌ xuꞌej, ja xcon. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri Saulo can xka choch chi ri Esteban xquimisas. Y ja kꞌij reꞌ chireꞌ Jerusalén, ri quiniman ri Jesucristo xquiꞌan-ka sufrir, ruma itziel ncaꞌtzꞌiet. Rumareꞌ quinojiel xquiquiraj-quiꞌ; icꞌo xaꞌa nicꞌaj chic tanamet chireꞌ Judea, y icꞌo xaꞌa Samaria, pero ri apóstoles xaꞌcꞌujieꞌ can Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Y ri Esteban xmuk cuma utzulaj tak achiꞌaꞌ ri cꞌo ri Dios riqꞌuin cánima y altíra xcokꞌiej. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Y ri Saulo can altíra itziel nuꞌon cha ri iglesia, y ntuoc pa tak jay chi ncaꞌbꞌaralasaj-pa, chi ixokiꞌ chi achiꞌaꞌ ncaꞌruchiririej-pa y ncaꞌrutzꞌapij pa cárcel. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Y ri quiniman ri Jesucristo xquiquiraj-quiꞌ. Y nojiel lugar pacheꞌ xaꞌbꞌaka-ve, can niquitzijuoj ri evangelio. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Y ri Felipe xbꞌaka chupan ri tanamet Samaria. Y antok cꞌo chic chireꞌ, xutzꞌom cꞌa rutzijoxic rubꞌeꞌ ri Cristo chica ri icꞌo chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Y qꞌuiy vinak ri niquimol-quiꞌ riqꞌuin ri Felipe, chi nicaꞌxaj ri nuꞌej jajaꞌ, y niquitzꞌat ri señales ri nuꞌon chiquivach. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Can iqꞌuiy vinak ri xaꞌiel-el ri itziel tak espíritus ri icꞌo quiqꞌuin. Y ri itziel tak espíritus reꞌ can altíra ncaꞌsiqꞌuin ncaꞌiel-el. Icꞌo jeꞌ ri ncaꞌjaco ncaꞌin, y icꞌo ri paralítico qui-cuerpo, xaꞌan sanar. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Rumareꞌ ri vinak ri icꞌo chireꞌ pa tanamet can altíra ncaꞌquicuot. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Y chupan ri tanamet reꞌ, antok majaꞌ tibꞌaka ri Felipe, cꞌo jun ache aj-itz rubꞌinan Simón. Can i-rubꞌanun engañar ri aj-Samaria. Jajaꞌ ruꞌeꞌn jeꞌ chica chi jajaꞌ jun ache ri cꞌo rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Y quinojiel ri vinak chi chꞌuteꞌk chi nimaꞌk ncaꞌniman ri rutzij ri aj-itz reꞌ y niquiꞌej chirij: Ri namalaj ru-poder ri Dios cꞌo riqꞌuin ri Simón, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Y qꞌuiy yan tiempo i-rubꞌanun-pa engañar ri vinak riqꞌuin nojiel ri magia ri ncaꞌruꞌon. Rumareꞌ ri vinak niquinimaj ri rutzij. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero antok ri vinak xquinimaj ri nutzijuoj ri Felipe chirij ri Jesucristo y ri evangelio ri nichꞌoꞌ chirij ri ru-reino ri Dios, chi achiꞌaꞌ chi ixokiꞌ xaꞌan bautizar. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Y ri Simón jeꞌ, ri ache aj-itz, xunimaj ri ruchꞌabꞌal ri Dios y xꞌan bautizar. Ri Simón reꞌ, can pacheꞌ bꞌanak ri Felipe, can ja bꞌanak riqꞌuin. Pero jajaꞌ can chapatajnak antok ncaꞌrutzꞌat ri nimaꞌk señales y milagros ri ncaꞌruꞌon ri Felipe chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Y ri apóstoles ri icꞌo can Jerusalén, xcaꞌxaj chi ri aj-Samaria xquinimaj ri ruchꞌabꞌal ri Dios. Rumareꞌ xaꞌquitak cꞌa el ri Pedro y ri Juan quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Y antok xaꞌbꞌaka, xquiꞌan orar pa qui-cuenta ri quiniman ri Jesucristo ri icꞌo chireꞌ Samaria, chi quireꞌ nika-pa ri Espíritu Santo pa quiveꞌ, ");
INSERT INTO cakSNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ruma man jun chiquivach ijejeꞌ ri kajnak-pa ri Espíritu Santo paroꞌ, joꞌc i-bꞌanun bautizar pa rubꞌeꞌ ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Y ri Pedro y ri Juan xquiyaꞌ quikꞌaꞌ pa quiveꞌ, y xquiꞌan recibir ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Y antok ri Simón xutzꞌat chi xka-pa ri Espíritu Santo pa quiveꞌ ri vinak antok ri apóstoles xquiyaꞌ quikꞌaꞌ pa quiveꞌ, ri Simón xusuj miera chica, ");
INSERT INTO cakSNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","y xuꞌej chica: Tiyaꞌ chuva ri poder incheꞌl cꞌo iviqꞌuin ixreꞌ, chi quireꞌ antok niyaꞌ nukꞌaꞌ paroꞌ jun vinak, xtuꞌon recibir ri Espíritu Santo, xchaꞌ chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Y ri Pedro xuꞌej cha ri Simón: Cꞌa pa kꞌakꞌ xcabꞌaka-ve junan riqꞌuin ri a-miera; ruma atreꞌ naꞌan pensar chi riqꞌuin miera nalokꞌ ri nusipaj ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Atreꞌ man jun akꞌaꞌ cha ri samaj reꞌ, ruma ri avánima man choj ta cꞌo choch ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tayaꞌ can ri man otz ta ri cꞌo pan avánima, y tacꞌutuj cꞌa favor cha ri Dios chi nuꞌon perdonar ri a-pecado, ruma choch jajaꞌ, man otz ta ri xaꞌan pensar. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Inreꞌ nitzꞌat chi ri itziel cꞌa cꞌo pan acꞌaslien y ri pecado cꞌa at-ruximuon, xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Pero ri Simón xuꞌej chica ri apóstoles: Tibꞌanaꞌ rogar pa nu-cuenta inreꞌ cha ri Ajaf Dios, chi quireꞌ man jun kax nipa panoꞌ incheꞌl ri xiꞌej, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Y antok ri apóstoles quitzijuon y quicꞌutun chic ri ruchꞌabꞌal ri Dios chica ri vinak ri icꞌo Samaria, ja xaꞌa; pero can niquitzijuoj ri evangelio nicꞌaj chic tanamet ri icꞌo chupan ri Samaria, ri pacheꞌ ncaꞌkꞌax-ve. Cꞌajareꞌ xaꞌa chic Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Y cꞌo jun ángel richin ri Ajaf xchꞌoꞌ cha ri Felipe, y xuꞌej cha: Capalaj, y caꞌin chupan ri jun bꞌay ri ntiel-el Jerusalén y nixulie-ka pa tanamet Gaza. Ri bꞌay reꞌ man qꞌuiy ta vinak ncaꞌkꞌax chupan. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Y ri Felipe can xpalaj-pa, y xꞌa. Y antok bꞌanak, xutzꞌat jun alaꞌ aj-Etiopía. Ri alaꞌ reꞌ jun eunuco, y cꞌo paroꞌ nojiel ri rubꞌayomal ri reina Candace richin ri nación Etiopía. Ri alaꞌ reꞌ yoꞌn autoridad cha ruma ri Candace, y xpa Jerusalén chi xalruyaꞌ rukꞌij ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Y antok nitzalaj chic pa ru-nación, tzꞌuyul-el chupan ri ru-carruaje. Y jajaꞌ nuꞌon leer bꞌanak. Y ri nuꞌon leer, ja ri rutzꞌibꞌan can ri profeta Isaías. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Y ri Espíritu Santo xuꞌej cha ri Felipe: Cajiel-apa riqꞌuin ri carruaje pacheꞌ bꞌanak-ve ri alaꞌ eunuco, y caꞌin riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Y antok ri Felipe xjiel-apa riqꞌuin ri carruaje, xraꞌxaj ri nuꞌon leer ri alaꞌ bꞌanak, ja ri rutzꞌibꞌan can ri profeta Isaías. Mareꞌ ri Felipe xucꞌutuj cha: ¿Niꞌka pan aveꞌ (naꞌan entender) ri naꞌan leer? xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Pero ri alaꞌ reꞌ xuꞌej: ¿Cheꞌl cꞌa xtiꞌka panoꞌ (xtinꞌan entender) xa man jun nicꞌutu chinoch? Y ri alaꞌ xuꞌon rogar cha ri Felipe chi tijotie-el y titzꞌuye-el riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ri ruchꞌabꞌal ri Dios ri nuꞌon leer ri alaꞌ reꞌ, nuꞌej: Xucꞌuax chi niquimisas, incheꞌl niꞌan cha jun oveja. Can incheꞌl nuꞌon ri alaj oveja ri man nisiqꞌuin ta antok nisocas rij, quireꞌ jeꞌ xuꞌon jajaꞌ, man jun kax xuꞌej. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Man jun rukꞌij xꞌan cha, y mesque man jun ru-pecado, paroꞌ jajaꞌ xka-ve nojiel pecado. Y ri ncaꞌniman richin, ¿chica came nicovin nijilan quichin? Ruma xquimisas-el ri choch-ulief. Quireꞌ nuꞌej ri nuꞌon leer. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Y ri alaꞌ eunuco xucꞌutuj cha ri Felipe: Tabꞌanaꞌ favor taꞌej chuva: ¿Choj chirij nichꞌo-ve ri profeta vaveꞌ? ¿Chirij jajaꞌ mismo nichꞌo-ve, o chirij jun chic? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ri Felipe xutzꞌom rubꞌixic riqꞌuin ri rutzꞌibꞌan can ri profeta Isaías, richin chi xchꞌoꞌ chirij ri ru-evangelio ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Y antok xaꞌbꞌaka jun lugar ri pacheꞌ cꞌo-ve yaꞌ, ri alaꞌ eunuco xuꞌej cha ri Felipe: Vaveꞌ cꞌo yaꞌ. ¿Chica ta nibꞌano impedir chi niꞌan bautizar? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Y ri Felipe xuꞌej cha ri alaꞌ reꞌ: Xa riqꞌuin nojiel avánima nanimaj ri Jesucristo, otz chi naꞌan bautizar, xchaꞌ. Y ri alaꞌ xuꞌej cꞌa: Ninimaj chi ja ri Jesucristo ri Rucꞌajuol ri Dios, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Y rumareꞌ ri alaꞌ xuꞌej chi tipiꞌieꞌ ri carruaje. Y xaꞌka-ka ri icaꞌyeꞌ pa yaꞌ, y ri Felipe xuꞌon bautizar ri alaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Antok i-alanak chic pa pa yaꞌ, ri Felipe xucꞌuax ruma ri Ru-Espíritu ri Ajaf. Y ri alaꞌ eunuco man xutzꞌat ta chic ri Felipe, pero niquicuot xutzꞌom chic el bꞌay. ");
INSERT INTO cakSNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Y ri Felipe xbꞌaka pa tanamet Azoto. Y xakꞌax nicꞌaj chic tanamet, nutzijuoj ri evangelio. Quireꞌ xuꞌon cꞌa hasta xbꞌaka pa tanamet Cesarea. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Y ri Saulo man nakꞌax ta ri royoval chiquij ri ru-discípulos ri Ajaf, y nrajoꞌ ncaꞌruquimisaj. Mareꞌ jajaꞌ xꞌa riqꞌuin ri sacerdote ri más cꞌo rukꞌij, ");
INSERT INTO cakSNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","chi xbꞌarucꞌutuj cartas cha, chi xyoꞌx autoridad pa rukꞌaꞌ chi niꞌa pa tanamet Damasco, chi ntuoc pa tak sinagogas chi ncaꞌbꞌarucanuj-pa ri quiniman ri Utzulaj Bꞌay. Y antok ncaꞌril-pa, ncaꞌruxim-pa y ncaꞌrucꞌam-pa cꞌa Jerusalén, chi ixokiꞌ chi achiꞌaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Pero antok jajaꞌ bꞌanak pa bꞌay, y xa jubꞌaꞌ chic nrajoꞌ chi nibꞌaka pa tanamet Damasco, jun arapienta xka-pa paroꞌ jun luz ri patanak chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Y ri Saulo xtzak-ka pan ulief, y xraꞌxaj chi cꞌo Jun ri nichꞌo-pa cha, y nuꞌej: Saulo, Saulo, ¿karruma nquinaꞌan perseguir? xcha-pa cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Y ri Saulo xuꞌej: ¿At chica cꞌa atreꞌ tuoya? xchaꞌ. Pero ri nichꞌo-pa cha ri Saulo xuꞌej-pa cha: Inreꞌ ri Jesús, ri in-abꞌanun perseguir. Y ruma quireꞌ naꞌan, xa ayuon atreꞌ naya-ka-aviꞌ pa sufrimiento. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Y ri Saulo nibꞌarbꞌuot ruma xibꞌinreꞌl, xuꞌej: Ajaf, ¿chica navajoꞌ chi niꞌan? Y ri Ajaf xuꞌej cha: Capalaj, y caꞌin cꞌa pa tanamet, y chireꞌ xtiꞌeꞌx chava ri chica nicꞌatzin chi xtaꞌan, xucheꞌx. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Y ri achiꞌaꞌ ri i-bꞌanak riqꞌuin ri Saulo can xaꞌchapataj, ruma nicaꞌxaj chi cꞌo Jun nichꞌo-pa, pero man jun niquitzꞌat. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Y ja xpalaj ri Saulo pan ulief. Y antok xaꞌrujak ri nakꞌaroch, jajaꞌ xa man nitzuꞌn ta chic. Rumareꞌ xquiyukiej chukꞌaꞌ cꞌa Damasco. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Y chireꞌ xcꞌujie-ve oxeꞌ kꞌij, man xtzuꞌn ta, y man xvaꞌ ta ni man jun kax xukun. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Chireꞌ Damasco cꞌo jun ache rubꞌinan Ananías, jun ru-discípulo ri Jesucristo. Y ri Ajaf xucꞌut-riꞌ choch jajaꞌ chupan jun incheꞌl achicꞌ, y xuꞌej cha: Ananías, xchaꞌ cha. Y ri Ananías xuꞌej: Incꞌo vaveꞌ, Ajaf, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Y ri Ajaf xuꞌej cha: Capalaj y caꞌin chirachuoch ri Judas, ri cꞌo pa jun bꞌay ri niꞌeꞌx Derecha cha. Chireꞌ tacanuj-ve jun ache aj-Tarso, rubꞌinan Saulo. Ruma jajaꞌ vacame nuꞌon orar. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Y chupan jun incheꞌl achicꞌ xinꞌan cha chi xutzꞌat chi cꞌo jun ache rubꞌinan Ananías ri xalka riqꞌuin, y xuyaꞌ rukꞌaꞌ paroꞌ chi nitzuꞌn chic, xchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Antok xraꞌxaj quireꞌ ri Ananías, xuꞌej: Ajaf, iqꞌuiy cꞌa i-bꞌiyuon chuva ri itziel ri i-rubꞌanun ri jun ache reꞌ chica ri santos avalcꞌual ri icꞌo Jerusalén. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y vacame cꞌo vaveꞌ, can yoꞌn-pa autoridad pa rukꞌaꞌ cuma ri principales sacerdotes chi ncaꞌrutzꞌom-el quinojiel ri niquiyaꞌ akꞌij, xchaꞌ ri Ananías. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Y ri Ajaf xuꞌej cha: Caꞌin, ruma jajaꞌ ri nuchoꞌn chi nutzijuoj ri nubꞌeꞌ chiquivach ri vinak ri man israelitas ta, chiquivach ri reyes y chiquivach ri vinak israelitas. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Y inreꞌ xtincꞌut choch nojiel ri sufrimiento ri xtukꞌasaj vuma inreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Y ri Ananías xꞌa ri pacheꞌ xꞌeꞌx cha y xuoc-oc pa jay. Y antok cꞌo chic chireꞌ pa jay riqꞌuin ri Saulo, xuyaꞌ rukꞌaꞌ paroꞌ y xuꞌej cha: Hermano Saulo, ri Ajaf Jesús ri xucꞌut-riꞌ chavach antok at-patanak pa bꞌay chi ncatalka vaveꞌ Damasco, xirutak-pa aviqꞌuin chi ncatzuꞌn chic jun bꞌay, y chi nika-pa jeꞌ ri Espíritu Santo pan aveꞌ chi nunojsaj ri avánima, xchaꞌ ri Ananías cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Y ja xaꞌtzak-el pa tak nakꞌaroch ri Saulo incheꞌl rij car, y xtzuꞌn chic jun bꞌay. Y xpalaj-el y xꞌan bautizar. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Y antok xvaꞌ, ja xcꞌujieꞌ chic ruchukꞌaꞌ. Ri Saulo xcꞌujie-ka nicꞌaj chic kꞌij quiqꞌuin ri discípulos ri icꞌo chireꞌ Damasco. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Y ri Saulo chaꞌnin xirunaꞌ predicar chica ri vinak ri pa tak sinagogas chi ri Jesús jareꞌ ri Cristo ri Rucꞌajuol ri Dios. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Y quinojiel ri vinak ri nicaꞌxaj ri nuꞌej ri Saulo, can xaꞌchapataj y niquiꞌej chirij: ¿Man ja ta came reꞌ ri altíra xuꞌon chica ri niquiyaꞌ rukꞌij ri Jesús pa tanamet Jerusalén y xaꞌruyaꞌ pa sufrimiento? Y vacame xalka vaveꞌ Damasco chi ncaꞌruxim-el y ncaꞌrucꞌuaj ri niquiyaꞌ rukꞌij ri Jesús, y ncaꞌbꞌaruyaꞌ pa quikꞌaꞌ ri principales sacerdotes, ncaꞌchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ri Saulo nicꞌujie-ka más ruchukꞌaꞌ chi nuꞌon predicar ri ruchꞌabꞌal ri Dios. Y nuꞌej chi ri Jesús jareꞌ ri Cristo. Y ruma ri nuꞌej jajaꞌ, ri israelitas ri icꞌo chireꞌ Damasco man niquil ta chica niquiꞌej cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Y qꞌuiy kꞌij ticꞌujieꞌ ri Saulo chireꞌ Damasco, antok ri israelitas xquimol-quiꞌ y xquiꞌan pensar chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero ri Saulo xunaꞌiej ri nicajoꞌ niquiꞌan cha. Y ri vinak ri canun pensar chi niquiquimisaj, can pakꞌij chi chakꞌaꞌ quiyoꞌien chuchiꞌ ri puertas ri pacheꞌ ncaꞌiel y ncaꞌuoc ri vinak chireꞌ pa tanamet, chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Pero ri discípulos, jun chakꞌaꞌ xquiya-el ri Saulo chupan jun chacach nem, y xquikasaj-ka chirij ri muro ri cꞌo chirij ri tanamet. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Y antok ri Saulo xalka pa tanamet Jerusalén, xrajoꞌ xcꞌujieꞌ ta quiqꞌuin ri discípulos ri icꞌo chireꞌ. Pero ijejeꞌ xa niquixiꞌij-quiꞌ choch, ruma man niquinimaj ta chi ri Saulo ya runiman chic ri Jesús. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Pero ri jun discípulo Bernabé rubꞌeꞌ, xucꞌuaj ri Saulo quiqꞌuin ri apóstoles y xucꞌut chiquivach. Y ri Bernabé xuꞌej chica chi ri Ajaf xucꞌut-riꞌ choch ri Saulo y xchꞌoꞌ riqꞌuin antok rutzꞌamuon bꞌay bꞌanak Damasco, y cheꞌl chi ri Saulo man xuxiꞌij ta riꞌ chi xuꞌon predicar ri Ajaf Jesús chica ri vinak ri icꞌo chireꞌ Damasco, xchaꞌ ri Bernabé chica ri apóstoles. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Cꞌajareꞌ xquinimaj y ri Saulo xcꞌujie-ka chireꞌ Jerusalén, y pacheꞌ ncaꞌa-ve ri apóstoles, ja bꞌanak ri Saulo quiqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Y man nuxiꞌij ta riꞌ jajaꞌ chi nuꞌon predicar ri Ajaf chica ri vinak. Y niquitzꞌom cꞌa quiꞌ chi tzij quiqꞌuin ri israelitas ri ncaꞌchꞌoꞌ griego, chirij ri ruchꞌabꞌal ri Dios. Pero ijejeꞌ xa niquicanuj chica manera niquiꞌan chi niquiquimisaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Rumareꞌ antok ri hermanos xquinaꞌiej ri chica nicajoꞌ niquiꞌan ri vinak cha ri Saulo, xquicꞌuaj chupan ri tanamet Cesarea. Y antok icꞌo chic chireꞌ Cesarea, xquitak-el pa tanamet Tarso. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Y ri tiempo reꞌ, ri iglesias ri icꞌo chupan ri Judea, ri Galilea y ri Samaria, man niquiꞌan ta chic sufrir. Xa ncaꞌqꞌuiy chupan ri ruchꞌabꞌal ri Dios, y niquixiꞌij-quiꞌ niquiꞌan pecado choch ri Ajaf, y xaꞌqꞌuiyir ruma ri ru-poder ri Espíritu Santo. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Y antok ri Pedro alanak chiquitzꞌatic ri santos hermanos ri icꞌo nicꞌaj chic tanamet, xalka cꞌa quiqꞌuin ri icꞌo pa tanamet Lida. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Y chupan ri tanamet reꞌ xbꞌarilaꞌ jun ache rubꞌinan Eneas, ri ocho (vakxakiꞌ) junaꞌ ticotzꞌieꞌ choch varaꞌal ruma paralítico ru-cuerpo. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Rumareꞌ ri Pedro xuꞌej cha ri Eneas: Ja ri Jesucristo ri xcabꞌano sanar. Capalaj y tacꞌaloꞌ ri avaraꞌal, xchaꞌ ri Pedro cha. Y ri Eneas chaꞌnin xpiꞌieꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Y iqꞌuiy vinak ri aj-Lida y aj-Sarón ri xaꞌtzꞌato chi ri Eneas xpalaj. Y ri vinak reꞌ xquinimaj ri Ajaf Jesús y xcꞌaxtaj quicꞌaslien. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chupan ri tanamet Jope ri tiempo reꞌ, cꞌo jun discípula rubꞌinan Tabita, y Dorcas niꞌeꞌx cha ri pa chꞌabꞌal griego. Ri ixok reꞌ can otz runoꞌj quiqꞌuin ri vinak; jajaꞌ ncaꞌrutoꞌ ri i-puobra. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Y chupan cꞌa ri tiempo reꞌ, ri Dorcas xyavaj-ka y xcon. Después antok joskꞌin chic y yoꞌn chic rutziak, xiꞌquiyaꞌ chupan jun chic cuarto. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Y ri tanamet Jope cierca cꞌo-ve riqꞌuin ri tanamet Lida, pacheꞌ cꞌo-ve ri Pedro. Y ri discípulos ri icꞌo Jope, ruma xcaꞌxaj chi ri Pedro cꞌo pa tanamet Lida, xaꞌquitak-el icaꞌyeꞌ achiꞌaꞌ riqꞌuin, chi xbꞌaquiꞌej cha: Tabꞌanaꞌ favor chika, joꞌ chaꞌnin kiqꞌuin cꞌa Jope, xaꞌchaꞌ cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Y ri Pedro can xꞌa quiqꞌuin. Antok xaꞌbꞌaka, ri Pedro xcusas-oc chupan ri jay pacheꞌ liꞌan-ve ri quiminak. Y ri malcaꞌn-ixokiꞌ xaꞌcꞌujieꞌ choch y chirij ri Pedro, ncaꞌuokꞌ y niquicꞌut choch ri tziak ri xaꞌruꞌon ri Dorcas antok majaꞌ ticon. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Y ri Pedro xuꞌej chica quinojiel chi caꞌiel-el. Jajaꞌ xxuquie-ka, y xuꞌon orar. Y xtzuꞌn chic apa riqꞌuin ri quiminak, y xuꞌej cha: Tabita, capalaj. Y ri ixok ja xbꞌatzuꞌn-pa, y antok xutzꞌat chi cꞌo ri Pedro, xpalaj-pa. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ri Pedro xutzꞌom rukꞌaꞌ ri ixok chi xupabꞌaꞌ y xaꞌrayuoj ri malcaꞌn-ixokiꞌ y ri nicꞌaj chic hermanos, y cꞌas chic xujach ri Dorcas chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Y ri xbꞌanataj, xquinaꞌiej quinojiel vinak ri icꞌo chireꞌ pa tanamet Jope, y iqꞌuiy vinak xquinimaj ri Ajaf Jesús chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Y ri Pedro qꞌuiy cꞌa kꞌij ri xcꞌujieꞌ chireꞌ pa tanamet Jope. Xcꞌujieꞌ pa rachuoch jun ache Simón rubꞌeꞌ, ri rusamaj ja ri nutzac y nukꞌomaj rij chicop. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Y ri pa tanamet Cesarea cꞌo jun ache rubꞌinan Cornelio. Jajaꞌ jun capitán ri icꞌo cien soldados pa rukꞌaꞌ, y ri soldados reꞌ i-richin ri grupo ri niꞌeꞌx Italiana chica. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri Cornelio y ri ru-familia niquiyaꞌ rukꞌij ri Dios, y niquixiꞌij-quiꞌ niquiꞌan chꞌoꞌj choch ri Dios. Y jajaꞌ siempre nuꞌon orar, y ncaꞌrutoꞌ ri i-puobra, y nusipaj qui-miera. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Y jun nakakꞌij antok a las tres laꞌk, jajaꞌ chupan jun incheꞌl achicꞌ xutzꞌat chi cꞌo jun ángel richin ri Dios ri xuoc riqꞌuin, y xuꞌej cha: Cornelio, xchaꞌ ri ángel cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Y ri Cornelio choj nutzꞌat ri ángel, y ruxiꞌin-riꞌ. Y xuꞌej cha ri ángel: ¿Chica ri navajoꞌ, Ajaf? xchaꞌ. Y ri ángel xuꞌej cha: Ri oraciones ri ncaꞌan, can ncaꞌka choch ri Dios, y nika jeꞌ choch chi cꞌo nasipaj chica ri vinak, y rumareꞌ ri Dios ncanataj cha vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Mareꞌ vacame caꞌtaka-el achiꞌaꞌ pa tanamet Jope, chi nicayuoj ri Simón ri niꞌeꞌx jeꞌ Pedro cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Jajaꞌ cꞌo pa rachuoch ri jun ache Simón jeꞌ rubꞌeꞌ, ri Simón ri nutzac y nukꞌomaj rij chicop y ri rachuoch chuchiꞌ ri mar cꞌo-ve. Y ja ri Pedro xtiꞌeꞌn chava ri nicꞌatzin chi naꞌan, xchaꞌ ri ángel cha ri Cornelio. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Y antok xꞌa ri ángel ri xchꞌoꞌ cha ri Cornelio, jajaꞌ xaꞌrayuoj icaꞌyeꞌ ru-siervos y jun soldado ri nuyaꞌ rukꞌij ri Dios jeꞌ. Ri soldado reꞌ, jareꞌ ri can siempre cꞌo riqꞌuin ri Cornelio, y nuꞌon ri niꞌeꞌx cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Y ri Cornelio xutzijuoj nojiel chica, y xaꞌrutak-el pa tanamet Jope. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Y chucaꞌn kꞌij antok i-bꞌanak ri achiꞌaꞌ, y xa jubꞌaꞌ chic nrajoꞌ chi ncaꞌbꞌaka pa tanamet Jope, pa nicꞌaj-kꞌij laꞌk reꞌ, ri Pedro xjotie-el cꞌa paroꞌ ri jay chi xbꞌarubꞌanaꞌ orar. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Jajaꞌ can ninem rupan y nrajoꞌ nivaꞌ yan. Pero antok royoꞌien chi nicꞌachoj ri chica xtutej, ri Dios xuꞌon cha chi xuꞌon jun incheꞌl achicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Jajaꞌ xutzꞌat chi ri rocaj jakal, y nika-pa incheꞌl jun nem tziak, y ximuon ri cajeꞌ rutzaꞌn. Y ri incheꞌl tziak reꞌ akal nika-pa choch ri roch-ulief. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Y antok xka-pa, ri Pedro xutzꞌat chi chupan icꞌo-pa nojiel quivach chicop. Icꞌo ri chicop ri cajeꞌ cakan, y icꞌo cumatz, y icꞌo ri chicop ri cꞌo quixicꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Y jareꞌ antok ri Pedro xraꞌxaj chi cꞌo Jun ri nichꞌo-pa cha y nuꞌej: Pedro, capalaj. Caꞌaquimisaj ri chicop y caꞌcꞌuxuꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Y ri Pedro xuꞌej: Ajaf, inreꞌ man xcaꞌncꞌux ta la chicop la. Inreꞌ man jun bꞌay i-nucꞌuxun chicop incheꞌl la, ri man i-sak ta, y ri man i-otz ta ncaꞌcꞌux, xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Y ri nichꞌo-pa cha ri Pedro xuꞌej chic pa cha rucaꞌn mul: Nojiel ri ranun sak ri Dios cha, can i-otz; man taꞌej atreꞌ chi man i-sak ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Oxeꞌ mul quireꞌ xbꞌanataj, y cꞌajareꞌ ri incheꞌl nem tziak xucꞌuax chic el chicaj. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ri Pedro cꞌa cꞌo chireꞌ, y man niril ta chica nrajoꞌ nuꞌej ri incheꞌl achicꞌ ri xuꞌon, antok ri achiꞌaꞌ ri i-takuon-el ruma ri Cornelio xaꞌbꞌaka, niquicꞌutuj cꞌa ri rachuoch ri Simón rubꞌeꞌ. Y antok xaꞌbꞌaka chuchiꞌ ri jay, ");
INSERT INTO cakSNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","xquicꞌutuj-apa vi chireꞌ cꞌo-ve ri Simón ri niꞌeꞌx jeꞌ Pedro cha. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Y ri Pedro cꞌa nuꞌon pensar chirij ri incheꞌl achicꞌ, antok ri Espíritu Santo xuꞌej cha: Icꞌo iyoxeꞌ achiꞌaꞌ ri ncatquicanuj. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Capalaj y caka-ka, y man taꞌan dudar chi ncaꞌa quiqꞌuin, ruma inreꞌ xitako-pa quichin. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Y ri Pedro xka-pa quiqꞌuin ri iyoxeꞌ achiꞌaꞌ ri i-takuon-el ruma ri Cornelio, y xuꞌej chica: Inreꞌ ri Pedro. ¿Choj-uma ix-patanak ixreꞌ? xchaꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Y ri achiꞌaꞌ xquiꞌej cha ri Pedro: Jun capitán Cornelio rubꞌeꞌ oj-rutakuon-pa chi ncatalkayuoj. Jajaꞌ jun ache choj y nuxiꞌij-riꞌ nuꞌon chꞌoꞌj choch ri Dios. Quinojiel ri vinak israelitas can nicajoꞌ y otz ncaꞌchꞌoꞌ chirij. Y jun santo ángel ri xalchꞌoꞌ cha jajaꞌ, y ri ángel reꞌ xuꞌej can cha chi carayuoj atreꞌ chirachuoch chi nraꞌxaj ri chica xtaꞌej cha, xaꞌchaꞌ ri achiꞌaꞌ ri i-takuon-el. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Y ri Pedro xaꞌrucusaj-oc pa jay ri achiꞌaꞌ reꞌ, y xaꞌcꞌujie-ka riqꞌuin. Y chucaꞌn kꞌij ri Pedro xꞌa quiqꞌuin cꞌa pa tanamet Cesarea. Y icꞌo nicꞌaj hermanos aj-chireꞌ pa tanamet Jope xaꞌa riqꞌuin ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Y chucaꞌn kꞌij ri caꞌiel-pa, cꞌajareꞌ xaꞌbꞌaka pa tanamet Cesarea. Y ri Cornelio i-rayuon ri rachꞌalal y i-rayuon jeꞌ ri ru-amigos ri más ncaꞌrajoꞌ, y quiyoꞌien-apa ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Y antok ri Pedro ya ntuoc-oc pa jay, ri Cornelio xiel-pa chi nuꞌon recibir y xxuquieꞌ chukul rakan chi xuyaꞌ rukꞌij. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ri Pedro xupilisaj y xuꞌej cha: Capiꞌieꞌ. Man caxuquieꞌ chinoch; inreꞌ xa in ache jeꞌ incheꞌl atreꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ri Pedro y ri Cornelio ncaꞌtzijuon, xaꞌuoc pa jay. Y jareꞌ antok ri Pedro xutzꞌat chi iqꞌuiy vinak quimaluon-quiꞌ chireꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Y jajaꞌ xuꞌej chica ri vinak reꞌ: Ixreꞌ ivataꞌn chi ojreꞌ israelitas man yoꞌn ta lugar chika chi nakaꞌan xa jun iviqꞌuin y manak cheꞌl nkojuoc pa tak ivachuoch jeꞌ ruma man ix israelitas ta. Pero ri Dios xucꞌut chinoch chi man otz ta niꞌej cha jun vinak chi man sak ta, ruma man israelita ta. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Rumareꞌ, joꞌc xaꞌbꞌaka ri achiꞌaꞌ ri i-takuon-el chi xinbꞌacayuoj, man xinꞌej ta chica chi man nquipa ta, xa xipa quiqꞌuin. Y vacame nicꞌutuj: ¿Karruma xinivayuoj? xchaꞌ ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Y ri Cornelio xuꞌej: Pa cajeꞌ can kꞌij, como cava huora a las tres ri nakakꞌij, antok inreꞌ niꞌan ayuno y oración, jareꞌ antok xucꞌut-riꞌ chinoch jun ache ri nichꞌichꞌan rutziak. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Y xuꞌej chuva: Cornelio, ri Dios can otz raxan ri av-oración, y nika jeꞌ choch ri Dios chi cꞌo nasipaj chica ri vinak, y rumareꞌ ncanataj cha vacame. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Y caꞌtaka-el achiꞌaꞌ cꞌa pa tanamet Jope chi nicayuoj ri Simón ri niꞌeꞌx jeꞌ Pedro cha, ri cꞌo pa rachuoch jun ache ri Simón jeꞌ rubꞌeꞌ. Y ri rachuoch cꞌo chuchiꞌ ri mar, y nutzac y nukꞌomaj rij chicop. Y antok ri Pedro xtalka aviqꞌuin, cꞌo cꞌa kax xtuꞌej chava, xchaꞌ chuva. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Rumareꞌ xintak avayoxic, y tiox bꞌaꞌ chi xapa. Y choch ri Dios ojcꞌo-ve konojiel ri kamaluon-kiꞌ ri vaveꞌ, y nakajoꞌ nakaxaj ri xtatzijuoj chakavach, ri ruꞌeꞌn ri Dios chava atreꞌ, xchaꞌ ri Cornelio cha ri Pedro. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Y ri Pedro xchꞌoꞌ y xuꞌej: Can ketzij niꞌka panoꞌ (niꞌan entender) vacame chi ri Dios nkojrajoꞌ konojiel. Man joꞌc ta jun nrajoꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Chica-na ri katanamit, ri Dios can nkojka choch konojiel xa nakaxiꞌij-kiꞌ nakaꞌan pecado choch y xa nakaꞌan ri choj. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Y ri Dios can xutak-pa ri Jesucristo vaveꞌ choch-ulief, ri Jesucristo ri Cajaf quinojiel vinak, y xalrutzijuoj-ka ri evangelio, ri niyoꞌn paz riqꞌuin kánima. Y chikacajol ojreꞌ israelitas xalrutzijuoj-ka. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ixreꞌ nalka pan iveꞌ nojiel ri xbꞌanataj chupan ri tiempo reꞌ chupan nojiel Judea. Naꞌay, ja ri Juan el Bautista ri xtzijuon ri ruchꞌabꞌal ri Dios y xaꞌruꞌon bautizar ri vinak. Después ri Jesús xutzꞌom-pa rutzijoxic ri ruchꞌabꞌal ri Dios chupan Galilea. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ivataꞌn jeꞌ chi ri Jesús ri aj-Nazaret, can cꞌo-ve ri Espíritu Santo riqꞌuin, ri yoꞌn-pa cha ruma ri Dios, y rumareꞌ cꞌo poder pa rukꞌaꞌ. Y joꞌc ri otz xaꞌruꞌon chica ri vinak. Xaꞌruꞌon jeꞌ sanar vinak ri icꞌo pa rukꞌaꞌ ri diablo. Quireꞌ xaꞌruꞌon ri Jesús, ruma cꞌo ri Dios riqꞌuin. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Y nojiel ri xaꞌruꞌon ri Jesús pa tanamet Jerusalén y nicꞌaj chic lugar richin ri Judea, can xkatzꞌat ojreꞌ ri ru-apóstoles. Ri Jesús xbꞌajix choch jun cruz chi xquimisas. Y jareꞌ ri nakatzijuoj chiquivach ri vinak. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Y chi oxeꞌ kꞌij, ri Dios xucꞌasuoj-pa chiquicajol ri quiminakiꞌ. Y antok cꞌastajnak chic pa, xuꞌon cha chi xucꞌut-riꞌ. ");
INSERT INTO cakSNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Y man chiquivach ta chica-na vinak xucꞌut-riꞌ, xa joꞌc chakavach ojreꞌ ri can ranun-pa pensar ri Dios ojier can chi nakatzijuoj chi ri Jesús xcꞌastaj-pa. Y juna