﻿USE sofia;
DROP TABLE IF EXISTS sofia.cakNT_vpl;
CREATE TABLE cakNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES cakNT_vpl WRITE;
INSERT INTO cakNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Chupa ri libro re' tz'iban-wi can quibi' ri ojer tak winak ri xe'oc ri rati't-rumama' ri Jesucristo. Can k'alaj-wi chi raja' ru-familia can ri rey David, y ru-familia can chuka' ri Abraham. ");
INSERT INTO cakNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri Abraham jari' rutata' ri Isaac; ri Isaac rutata' ri Jacob; ri Jacob rutata' ri Judá y ch'aka chic rach'alal. ");
INSERT INTO cakNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Y Judá y ri Tamar ja reje' quite-quitata' ri Fares y Zara; y ri Fares ja rutata' ri Esrom; y ri Esrom rutata' ri Aram. ");
INSERT INTO cakNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Y Aram rutata' ri Aminadab; ri Aminadab rutata' ri Naasón; y ri Naasón rutata' ri Salmón. ");
INSERT INTO cakNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri Salmón y ri Rahab, reje' je rute-rutata' ri Booz; ri Booz y ri Rut je rute-rutata' ri Obed; y ri Obed rutata' ri Isaí. ");
INSERT INTO cakNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y ri Isaí rutata' ri rey David; y ri rey David rutata' ri Salomón; Salomón ral ri Betsabé ri xoc raxayil ri Urías, y después xoc raxayil ri rey David. ");
INSERT INTO cakNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Y ri Salomón rutata' ri Roboam; ri Roboam rutata' ri Abías; y ri Abías rutata' ri Asa. ");
INSERT INTO cakNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Y ri Asa rutata' ri Josafat; ri Josafat rutata' ri Joram; y ri Joram rutata' ri Uzías. ");
INSERT INTO cakNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Y ri Uzías re', ja rutata' ri Jotam; ri Jotam rutata' ri Acaz; y ri Acaz rutata' ri Ezequías. ");
INSERT INTO cakNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Y ri Ezequías rutata' ri Manasés; ri Manasés rutata' ri Amón; y ri Amón rutata' ri Josías. ");
INSERT INTO cakNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Y ri Josías rutata' ri Jeconías y ch'aka chic rach'alal. Y ja' cuando ri israelitas xec'uax-e chi xebec'ue' pa rech-ulef Babilonia, roma xech'acataj pa quik'a' ri ejército chi Babilonia. ");
INSERT INTO cakNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Y cuando jec'o chic chiri' pa Babilonia, ri Jeconías xc'ue' jun ralc'ual ri xubinaj Salatiel; y ri Salatiel jari' rutata' ri Zorobabel. ");
INSERT INTO cakNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Y ri Zorobabel rutata' ri Abiud; ri Abiud rutata' ri Eliaquim; y ri Eliaquim rutata' ri Azor. ");
INSERT INTO cakNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Y ri Azor re' rutata' ri Sadoc; ri Sadoc rutata' ri Aquim; y ri Aquim rutata' ri Eliud. ");
INSERT INTO cakNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Y ri Eliud rutata' ri Eleazar; ri Eleazar rutata' ri Matán; ri Matán rutata' ri jun chic Jacob. ");
INSERT INTO cakNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri Jacob re' rutata' ri José ri xoc rachijil ri María. Y ri María jari' rute' ri Jesús, ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Je catorce grupos winak xec'ue'; nitiquier-pe riq'uin ri Abraham c'a riq'uin ri rey David. Y je catorce chuka' grupos winak xec'ue', ri nitiquier-pe riq'uin ri rey David c'a chupa ri tiempo cuando ri israelitas xec'uax pa rech-ulef Babilonia. Y chuka' je catorce grupos winak xec'ue'; nitiquier-pe riq'uin ri tiempo cuando ri israelitas xec'uax pa rech-ulef Babilonia, c'a riq'uin ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Cuando xalex ri Jesucristo, quiere' xbanataj: Ri María ri xoc rute' ri Jesucristo, jun xten c'utun chic roma ri José. Pero xbanataj chi cuando c'a man jani tiquic'on-qui', xna'ex chi ri María ruyoben jun ral. Pero ri María quiere' rubanon roma xka-pe ri Espíritu Santo pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Pero José ri ne'oc-wi rachijil ri María, can jun chojmilaj achi; y man xrojo' ta xuya' pa q'uix ri María chiquiwech ri winak, romari' choj quiri' nrojo' nuya' can y man nulesaj ta rutzijol. ");
INSERT INTO cakNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Y jari' ri xunojij-ka raja' pa ránima, chi choj quiri' nuya' can. Pero c'o jun ángel chi ri Ajaf Dios xuc'ut-ri' chech pa ruwaran, y xu'ij che: José, ret ri jat ru-familia can ri rey David, man taxi'j-awi' chi jac'ule' riq'uin ri María ri ac'utun chic chi ntoc awaxayil; roma raja' ne'c'ue' ral, pero ri ac'ual can richi ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ri ac'ual ri xtic'ue' riq'uin ri María, jun ala', y Jesús xta'an che rubi'; roma raja' xquierucol ri winak chech ri quimac. ");
INSERT INTO cakNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronojel re' nibanataj anche'l ru'in can ri Ajaf Dios che jun rusamajel ri xc'ue' ojer can. Y quiere' xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Titzu' na pe', chi xtic'ue' jun xten ri xtic'ue' jun ral. Y can xtralaj na-wi jun ac'ual ala', ri xtubinaj Emanuel. Ri bi'aj re' ntel chi tzij chi ri Dios can c'o kaq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Cuando ri José xuna' rech, can xu'on na-wi ri x-ix che roma ri ángel richi ri Ajaf Dios. Raja' can xuc'on-ka rech ri María chi xoc raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ri ral ri María man ralc'ual ta achi, roma raja' ruyoben yan ri ac'ual cuando xquic'on-qui' riq'uin ri José. Ri ral ri María can richi-wi ri Espíritu Santo. Y cuando ri José xuya' rubi' ri ac'ual, Jesús rubi' xu'on che. ");
INSERT INTO cakNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalex pa tenemit rubinan Belén, ri c'o pa Judea. Cuando xalex ri Jesús, ri Herodes jari' ri rey, y jec'o jujun achi'a' ri q'uiy quieta'n chiquij ri ch'umil, xeloka pa Jerusalem. Ri achi'a' re', pa oriente je-petenak-wi, ");
INSERT INTO cakNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","y xquic'utuj: ¿Anchi' c'o-wi ri ac'ual ri xalex, qui-Rey ri israelitas? Roma roj c'a pa oriente katz'eton-pe ruch'umil, y xojpe chi nokaya' ruk'ij, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cuando ri rey Herodes xuc'oxaj ri xqui'ij ri achi'a', man nril ta anchique nu'on. Y can quiri' chuka' xqui'en ri winak aj-Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Y ri rey Herodes xerumol conojel ri nimalaj tak sacerdotes y ri achi'a' je maestros chi ri ley chiquicojol ri israelitas, y xuc'utuj chique anchi' nalex-wi ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Xepe ri nimalaj tak sacerdotes y ri achi'a' maestros chi ri ley xqui'ij che ri rey: Ri Cristo nalex pa tenemit Belén we' pa Judea. Roma ri jun rusamajel ri Dios ri xc'ue' ojer can, quiere' rutz'iban can: ");
INSERT INTO cakNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Y ret tenemit Belén ri jatc'o pa rech-ulef Judá, ret can man jat co'l ta oc chiquicojol ri nimalaj tak tenemit chiri' pa Judá, roma chiri' awiq'uin ret xtipe-wi ri Jun ri nic'uan bey, y can xquieruchajij ri winak aj-Israel ri nutenemit, nicha' ri Dios, xecha-apo che ri rey Herodes. ");
INSERT INTO cakNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Y c'ajari' ri rey Herodes xeroyoj pa alak'al ri achi'a' ri q'uiy quieta'n chiquij ri ch'umil, y xuc'utula' utz chique jampe' xquitzu' ruch'umil ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Y c'ajari' xerutak-e pa tenemit Belén y xu'ij-e chique: Jix (Quixbin) c'a y ticanoj ri ac'ual, y cuando xtiwil, to'ibij chue, chi quiri' ren chuka' nenya' ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Y cuando ri achi'a' ri q'uiy quieta'n chiquij ri ch'umil quic'oxan chic ri tzij ri xeru'ij-e ri rey Herodes chique, xebe. Y ri ch'umil ri quitz'eton-pe reje' c'a pa oriente anchi' quiepe-wi reje', xuc'uaj quibey. Y cuando xe'apon, ri ch'umil re' xpa'e' pa ruchojmil anchi' c'o-wi ri ac'ual. ");
INSERT INTO cakNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Y ri achi'a' ri q'uiy quieta'n chiquij ri ch'umil, can xnoj-wi ri cánima roma xequicot cuando xquitzu' chic ruch'umil ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Y cuando ri achi'a' re' xe'oc-apo pa jay, can xquitzu-wi ri ac'ual y ri María ri rute', y can ja' xexuquie' chech chi xquiya' ruk'ij ri ac'ual. Y chuka' can xequijakala' anchi' quic'uan ri niquisipaj can che y xquiya' can oro, incienso y mirra che. ");
INSERT INTO cakNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Pero chique ri achi'a' ri', can xk'alajix chiquiwech pa cachic', chi can man quietzolaj chic riq'uin ri rey Herodes chi ne'qui'ij; y can quiri-wi xqui'en ri achi'a' ri'. Reje' xetzolaj-e pa qui-nación y jun-wi chic bey ri xquic'uaj. ");
INSERT INTO cakNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Y ri achi'a' ri q'uiy quieta'n chiquij ri ch'umil xetzolaj. Y jun ángel chi ri Ajaf Dios xuc'ut-ri' chech ri José pa rachic'. Y ri ángel re' xu'ij che: Cacataj, tac'uaj-e ri ac'ual y ri rute' y quixlumaj-e (quixnimaj-e) c'a Egipto; quixc'ue' chiri' y ren xtin-ij chawe jampe' utz jixtzolaj-pe. Roma cami ri rey Herodes can xtorucanoj ri ac'ual chi nucamisaj, xcha' ri ángel che ri José pa rachic'. ");
INSERT INTO cakNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Y José can ja' xc'astaj, xuc'uaj-e ri ac'ual y ri te'j. Can chupa ri nok'ok'a' ri' xquitz'om bey chi yebe c'a Egipto. ");
INSERT INTO cakNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Y chiri' pa Egipto xec'ue-wi y xetzolaj pa Israel c'a cuando caminak chic ri rey Herodes. Chi quiri' can xbanataj anche'l ruk'alajin can ri Ajaf Dios che ri rusamajel ri xc'ue' ojer can. Ri tz'iban can, nu'ij: Pa Egipto c'o-wi ri Walc'ual cuando xinwoyoj. Quiri' ru'in can ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Y cuando ri rey Herodes xuna'ej chi ri achi'a' ri q'uiy quieta'n chiquij ri ch'umil xa man xqui'en ta anche'l ri ru'in-e raja' chique, raja' xcataj q'uiy ruyowal y xu'ij chi quiecamises conojel ri ne'y ri je alabo ri jec'o chiri' pa tenemit Belén y ri jec'o pa tak lugar ri nakaj che ri tenemit. Ri ne'y ri je alabo ri xutak chi quiecamises, ja ri c'aja' ye'alex c'a ca'i' quijuna'. Roma raja' reta'n chi jari' yan tiempo ri achi'a' xqui'ij chi quitz'eton ri ch'umil. ");
INSERT INTO cakNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","We' can xbanataj-wi anche'l ri tz'iban can roma ri jun rusamajel ri Dios ri xc'ue' ojer can, ri xubinaj Jeremías: ");
INSERT INTO cakNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Chiri' pa Ramá xc'axataj ok'ej. Can c'o-wi bis. C'o c'a jun ri nujik' ok'ej. Ri' ja ri Raquel yerok'ej ri ral. Can man nik'ax ta ri bis che roma xecom ral. Quiri' ri tz'iban can roma ri Jeremías. ");
INSERT INTO cakNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Y cuando caminak chic ri rey Herodes, c'ajari' ri ángel richi ri Ajaf Dios xuc'ut chic ri' chech ri José pa rachic' chiri' pa Egipto. ");
INSERT INTO cakNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Y ri ángel richi ri Ajaf xu'ij che: Cacataj. Tac'uaj-e ri ac'ual y ri rute' y quixtzolaj pa rech-ulef Israel. Roma ri niquijo' niquicamisaj ri ac'ual chila', xa xecom yan. ");
INSERT INTO cakNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Y ri José can xu'on-wi ri x-ix che pa rachic' roma ri ángel. Xuc'uaj-e ri ac'ual y ri te'j. Y xetzolaj c'a pa rech-ulef Israel. ");
INSERT INTO cakNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero raja' roma xuc'oxaj chi ja ri Arquelao ri ralc'ual can ri rey Herodes, ri nibano gobernar pa Judea, xuxi'j-ri' chi yec'ue-ka chiri' pa Judea. Pero xk'alajix che ri José pa jun achic' anchique nu'on, y romari' raja' c'a pa Galilea xuc'uaj-wi ri ac'ual y ri te'j. ");
INSERT INTO cakNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Y xe'apon c'a pa tenemit rubinan Nazaret y chiri' xec'ue-wi-ka, chi quiri' can nibanataj anche'l ri tz'iban can coma ri je rusamajel ri Dios ri xec'ue' ojer can. Ri je rusamajel ri Dios quitz'iban can chi ri Jesús can ni'ix na-wi nazareno che. ");
INSERT INTO cakNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Chupa ri tiempo cuando ri Juan Bautista xuk'alajij-ka rutzij ri Dios chiquiwech ri winak, chiri' pa tz'iran rech-ulef richi ri Judea c'o-wi; ");
INSERT INTO cakNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","raja' nu'ij chique: Tiya' can ri imac y tibana' ri nrojo' ri Dios, roma nakaj chic c'o-wi-pe ri ru-gobierno raja', nicha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Can ja chirij ri Juan Bautista xch'o'n-wi can ri Isaías, ri jun ri xuk'alajij rutzij ri Dios ojer can. Raja' quiere' rutz'iban can: C'o jun achi ri xtic'ue' pa tz'iran rech-ulef, y ja raja' ri xtitzijon rutzij ri Dios chiquiwech ri winak ri xquie'apon riq'uin. Y xtu'ij chique: Tichojmisaj ri ic'aslen, roma nakaj chic c'o-wi-pe ri Ajaf. Quiri' tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Rutziak ri Juan Bautista banon che rusmal camello, y jun tz'um rucusan chi ruximbel-rupa. Y ri ruway ri Juan ja ri sac' y chuka' ri cab ri niquiya' ri chicop pa tak k'ayis. ");
INSERT INTO cakNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Y ri winak ri ye'apon riq'uin ri Juan Bautista, can yalan je q'uiy. Jec'o aj-Jerusalem, ri c'o pa Judea. Y jec'o chuka' je-petenak pa ch'aka chic tenemit chi ri Judea. Y chuka' jec'o ri je-petenak chunakaj ri rakan-ya' Jordán. Can conojel ri winak re' ye'apon riq'uin, ");
INSERT INTO cakNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","y ye'an-e bautizar roma raja' chiri' pa rakan-ya' Jordán. Y can yequik'alajij quimac chech ri Juan Bautista. ");
INSERT INTO cakNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Y cuando raja' xutzu' chi je q'uiy chique ri achi'a' fariseos y chuka' chique ri achi'a' saduceos ye'apon riq'uin roma niquijo' ye'an bautizar, xu'ij chique: Jix anche'l itzel tak cumetz, roma ninojij chi xe riq'uin ri bautismo jixcolotaj chech ri castigo ri xtutak-pe ri Dios chakawech apo. ¿Ancu'x (Anchique) x-in chiwe chi quiere' niben? ");
INSERT INTO cakNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Rix nic'atzin nic'ut chi can ketzij niya' can ri imac y niben ri nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Man ti'ij rix chi can xe roma jix ru-familia can ri Abraham, romari' jixcolotaj, man quiri' ta. Roma xa ta ri Dios nrojo' yeru'on ru-familia ri Abraham chique ri abaj ri ye'itzu' we', nitiquier nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ri castigo ri nuya' ri Dios nipe yan. Raja' xtu'on anche'l nu'on jun achi ri c'o chic ri iquiaj pa ruk'a' chi yerukasaj ri che' ri man utz ta quiwech niquiya'. Y conojel ri che' ri xquierukasaj, xquieruya' pa k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ren, ya' nincusaj chi jixinben bautizar cuando niya' can imac y niben ri nrojo' ri Dios. Pero c'o Jun ri xtipe chuij ren ri man anche'l ta oc ren. Romari' can man nuc'ul ta chi ja ren ri yic'uan-apo ruxajab chi ninya' chirakan, roma raja' can nim ruk'ij y nim ruchuk'a', y raja' xquixru'on bautizar riq'uin ri Espíritu Santo y che k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Raja' can xtu'on anche'l nu'on jun achi cuando nujosk'ij ru-trigo anchi' nuch'ey-wi. Raja' nic'atzin jun ruche' ri c'o ca'i-oxi' rutza'n, chi nuq'uiak chech quiek'ik' ri trigo ch'ayon chic. Ri trigo nic'ue' can, pero ri ruk'ayisal nuc'uaj-e quiek'ik'. Ri trigo nuyec, y ri ruk'ayisal nuporoj. Can quiri' xtu'on ri Jun ri xtipe, raja' can c'o chic uchuk'a' pa ruk'a' chi yeru'on juzgar ri winak. Ri yeniman, xquieruc'uaj chicaj. Pero ri man yeniman ta, xquierutak chupa ri k'ak' ri manak xtichup. ");
INSERT INTO cakNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Y jun k'ij ri Jesús xapon riq'uin ri Juan chiri' chuchi' ri rakan-ya' Jordán. Pa Galilea petenak-wi chi ni'an-e bautizar roma ri Juan Bautista. ");
INSERT INTO cakNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Na'ey ri Juan man xrojo' ta xu'on bautizar ri Jesús, y nu'ij che: Ja' ta ren nic'atzin chi yi'an bautizar awoma ret, y cami xa can ja ret xatoka wiq'uin ren, chi jatin-en-e bautizar, xcha' ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Pero ri Jesús xu'ij che: Roj can nic'atzin naka'an ronojel ri nu'ij ri Dios chake, romari' cami quinabana' bautizar. C'ajari' ri Juan Bautista xu'on bautizar ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Y cuando ri Jesús banon chic bautizar, xbe'el-pe pa ya'. Y ja' xutzu' chi ri rocaj xjakataj y xutzu' chuka' chi ri ru-Espíritu ri Dios nika-pe anche'l jun paloma; y can choj pa ruwi' raja' xoka-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Y ri Dios xch'o'n-pe chicaj y xu'ij: Jare' ri Walc'ual; can yalan ninjo' y can niquicot wánima riq'uin, xcha-pe ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Y ri Jesús x-an che roma ri Espíritu Santo chi xbe pa tz'iran rech-ulef, chi nitojtobex roma ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús cuarenta k'ij y cuarenta ak'a' man xwa' ta; y cuando xek'ax yan ri k'ij ri', c'ajari' xnum-pe rupa. ");
INSERT INTO cakNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Y ja c'o-apo ri itzel chi nutojtobej ri Jesús, y xu'ij che: Xa can ketzij chi ret jat Ralc'ual ri Dios, tabana' chique ri abaj re' chi quie'oc pan. ");
INSERT INTO cakNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Pero ri Jesús xu'ij che: Tz'iban can chupa rutzij ri Dios, chi ri achi nril chuka' ruc'aslen riq'uin rutzij ri Dios y man xe ta riq'uin ri pan. ");
INSERT INTO cakNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Y ri itzel xuc'uaj ri Jesús c'a chupa ri lok'olaj tenemit Jerusalem, y ja ri c'a chicaj e che ri rocho ri Dios xberuya-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Y chiri' ri itzel xu'ij che ri Jesús: Tatorij-ka-awi', ret ri ja'in chi jat Ralc'ual ri Dios. Roma chupa rutzij ri Dios ri tz'iban can, nu'ij: Ri Dios xquierutak-pe ru-ángeles chi jatquichajij, y xcatquili'ej pa quik'a', chi quiri' man xtacajij ta awakan chech abaj. ");
INSERT INTO cakNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Pero ri Jesús xu'ij che ri itzel: Ren man nin-en ta ri narayij ret, chi nintojtobej ri Dios. Roma chupa rutzij ri Dios tz'iban chuka': Man utz ta nakatojtobej ri Kajaf Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Y ri itzel xuc'uaj chic e ri Jesús, y xberuya' parui' jun nimalaj juyu' y xuc'ut chech ronojel ri naciones chi ri rech-ulef. Nimalaj tak naciones y can nim quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Y ri itzel xu'ij che ri Jesús: Ronojel re' ninya' chawe, xa ret jaxuquie' chinuech chi naya' nuk'ij, xcha' ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Pero ri Jesús xu'ij che: Quinaya' can ret Satanás. Ren can man nin-en ta ri na'ij-pe ret chue. Roma chupa rutzij ri Dios ri tz'iban can, nu'ij: Xe ri Kajaf Dios kaya' ruk'ij, y xe chuka' raja' kabana' rusamaj, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Y ja' cuando ri itzel xuya' can ri Jesús. Y ri Jesús xeloka ángeles riq'uin chi xquilij. ");
INSERT INTO cakNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Y cuando Jesús xuc'oxaj chi ri Juan Bautista xyo'x pa cárcel, xtzolaj chic pe pa Galilea. ");
INSERT INTO cakNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Y xbe'apon pa tenemit Nazaret, c'ajari' xbe pa jun tenemit rubinan Capernaum y chiri' xc'ue-wi-ka. Ri Capernaum c'o chuchi' ri choy (ya') rubinan Galilea y chuka' chiquicojol ri rech-ulef quibinan Zabulón y Neftalí. ");
INSERT INTO cakNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ri Jesús xapon chiri', chi quiri' nibanataj anche'l tz'iban can roma jun rusamajel ri Dios, ri xubinaj Isaías. Raja' rutz'iban can: ");
INSERT INTO cakNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ri winak ri jec'o pa Zabulón y Neftalí, ri jec'o chuchi' ri jun choy (ya'), ri c'o-apo juc'an ruchi' rakan-ya' Jordán. Galilea, anchi' jec'o-wi chuka' winak ri man je israelitas ta. ");
INSERT INTO cakNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ri winak ri can k'eku'm rubanon quic'aslen, xquitzu' jun Nimalaj Sakil. Y ri xec'ue' pa rumujal ri camic, jun nimalaj Sakil xerusakrisaj. Quiri' tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Y cuando ri Jesús xapon pa tenemit Capernaum, xutzijoj-ka rutzij ri Dios y nu'ij chique ri winak: Tiya' can imac y tibana' ri nrojo' ri Dios, roma nakaj chic c'o-wi-pe ri ru-gobierno raja', xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Y jun k'ij cuando ri Jesús benak chuchi' ri choy (ya') rubinan Galilea, xerutzu' ca'i' achi'a' quichak'-quinimal qui'. Ri ca'i' achi'a' ri', ja ri Simón ri ni'ix chuka' Pedro che, y ri rach'alal Andrés; quisamaj ri achi'a' ri', ja ri yequilesaj quer pa ya', y yequiq'uiak quiya'l pa ya' chi yequilesaj quer. ");
INSERT INTO cakNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ri Jesús xch'o'n-apo chique ri ca'i' achi'a' ri' y xu'ij chique: Quinitzeklebej, y xtinc'ut chiwech anchique modo ye'ich'ec winak riq'uin ri nutzij chi jinquitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ri ca'i' achi'a' ri', can ja' xquiya' can quisamaj y xquitzeklebej-e ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Y juba' xebin, cuando ri Jesús xerutzu' chic ca'i' achi'a' cach'alal qui' chuka', ja ri Jacobo y ri Juan, reje' je ralc'ual jun achi rubinan Zebedeo. Ri ca'i' achi'a' ri' pa canoa yesamaj riq'uin quitata' y yequic'ojoj quiya'l ri anchok che yequilesaj quer pa ya'. Y ri Jesús xeroyoj chi niquitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y reje' can ja' xquiya' can quitata' riq'uin ri canoa y ja xebe riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Y ri Jesús pa ronojel tenemit chi ri Galilea xapon-wi, y yerutijoj ri winak pa tak sinagogas, ri jay anchi' niquimol-wi-qui' ri winak ri' chi niquic'oxaj rutzij ri Dios, chuka' nutzijoj chique ri utzilaj rutzij ri Dios ri nich'o'n chirij ri ru-gobierno ri Dios, y chuka' yec'achoj can q'uiy winak ri jalajoj rech yabil ntoc chique. ");
INSERT INTO cakNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xapon rutzijol ri Jesús pa conojel tenemit chi ri Siria. Y xec'amer-pe q'uiy yawa'i' chech, ri jalajoj rech yabil ntoc chique. Jec'o ri yalan ruquiy (nik'axon) quich'acul. Jec'o ri xa itzel tak espíritus jec'o quiq'uin. Jec'o ri je ch'u'j y chuka' jec'o ri siquirinak quich'acul. Y can conojel ri yawa'i' re' xec'achoj can roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Y ri Jesús xtzeklebes coma q'uiy winak aj-chiri' pa tak tenemit chi ri Galilea, y chuka' coma winak chi ri tenemit ri jec'o pa Decápolis, y chuka' coma winak chi Jerusalem y ch'aka chic tenemit chi ri Judea. Y quiri' chuka' coma q'uiy winak ri xepe juc'an chic ruchi' ri rakan-ya' Jordán. ");
INSERT INTO cakNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Y cuando ri Jesús xerutzu' chi je q'uiy winak quimolon-qui', raja' xbe-e parui' ri juyu', y xch'oquie-ka. Y ri ru-discípulos xquimol-qui' riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Y ri Jesús yerutijoj ri winak, y nu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Can quiequicot ri niquina' chi c'o necesidad pa cánima chech ri Dios, roma can quichi-wi reje' ri ru-gobierno raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Can quiequicot ri ntok' cánima chech ri Dios, roma ri Dios can xtujal ri cok'ej y xtu'on chique chi yequicot. ");
INSERT INTO cakNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Can quiequicot ri can manak oc quik'ij niquina' pa cánima, roma can c'o ri xtiyo'x chique chupa ri rech-ulef ri can richi-wi ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Can quiequicot ri can ninum y nichake'j ruchi' cánima chi niquic'uaj jun chojmilaj c'aslen chech ri Dios, roma ri Dios can xtuya' ronojel chique chi quiri' manak chic xtinum ni xtichake'j ruchi' cánima. ");
INSERT INTO cakNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Can quiequicot ri can niquijoyowaj quiwech ch'aka chic winak, roma ri Dios can xtujoyowaj chuka' quiwech reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Can quiequicot ri winak ch'ajch'oj cánima, roma reje' can xtiquitzu-wi rech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Can quiequicot ri man niquiya' ta lugar chi c'o ayowal yebanataj, roma reje' xti'ix chique chi je ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Can quiequicot ri quic'uan jun chojmilaj c'aslen y romari' niquik'axaj sufrimiento pa quik'a' ch'aka chic; can quiequicot roma quichi chic reje' ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Y can quixquicot rix ri itzel jixtz'et y ni'ix itzel tak tzij chiwe, y chuka' can nitz'uc tzij chiwij roma nubi' ren. ");
INSERT INTO cakNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Romari' siempre quixquicot pa iwánima y quixquicot yalan, roma nim ri ruq'uiexel ri xtiyo'x chiwe chicaj. Roma can anche'l ri sufrimiento nik'axaj rix cami, can quiri' chuka' xquik'axaj ri achi'a' ri xek'alajin rutzij ri Dios ojer can, ri achi'a' ri xec'ue' na'ey que chiwech rix. ");
INSERT INTO cakNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ja rix ri anche'l atz'am chi quic'aslen ri winak ri jec'o chech-ulef. Y xa ri atz'am re' niq'uis ri ratz'amil, ¿anchique ta chic xtaka'an che chi nitzolaj chic pe ri ratz'amil? Xa can man nic'atzin ta chic, romari' nitorix-e chi niquixak' can ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Rix can jix sakil chi quic'aslen ri winak ri jec'o chech-ulef y jabel jixk'alajin, anche'l nik'alajin-pe jun tenemit ri c'o parui' jun juyu' y manak modo nrewaj-ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Rix nitzaj jun luz, pero man niya' ta chuxe' jun cajón; cuando nitzaj jun luz, nicanoj jun lugar chicaj anchi' niya-wi chi nuya' sakil chique conojel ri jec'o pa jay. ");
INSERT INTO cakNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Quiri' chuka' tibana' rix chiquiwech ri winak; can tiya' sakil anche'l jun luz chi quiri' cuando ri winak niquitzu' chi rix xe ri utz ye'iben, can xtiquiya' ruk'ij ri Itata' c'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Man tinojij chi ren xipe chi nin-en anche'l man jun rakalen ri ley chi ri Moisés, y chuka' man tinojij chi ren xipe chi quiri' mismo nin-en chique ri tz'iban can coma ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can; man roma ta ri' xipe. Ren xipe chi can nin-en-wi ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Roma can ketzij nin-ij chiwe chi ronojel ri tz'iban chupa ri ley, can xquiebanataj-wi. Ri rech-ulef y ri rocaj can xquieq'uis. Pero ri je-tz'iban chupa ri ley can xquiebanataj-wi; can man jun ri xe choj quiri' xtic'ue' ta can. ");
INSERT INTO cakNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Xabachique (Xama'anchique) winak ri man nrojo' ta nu'on ri nu'ij chupa ri ley, más que jun tzij ri xa anche'l can man jun rakalen, y chuka' nu'ij chique ch'aka chic winak chi can man tiqui'en ri nu'ij ri tzij ri', ri nibano quiri', man jun ruk'ij xtic'ue' chiquicojol ri ye'an gobernar roma ri Dios. Pero ri nibano ronojel ri nu'ij chupa ri ley y chuka' nu'ij chique ri ch'aka chic winak chi tiquibana' ri nu'ij ri ley, can xtic'ue' ruk'ij chiquicojol ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Y xa rix nijo' chi can ja ri Dios nibano gobernar iwichi, nic'atzin chi can más choj ta ic'aslen, chech quic'aslen ri maestros chi ri ley y ri achi'a' fariseos. Roma reje' niquinojij chi can choj quic'aslen, y xa man quiri' ta. ");
INSERT INTO cakNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Y rix can ic'oxan ri x-ix chique ri winak ojer can, que man tiquicamisaj jun winak; roma xabachique (xama'anchique) winak ri nicamisan, can ti'an juzgar. ");
INSERT INTO cakNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero ren nin-ij: Más que xe ta ruyowal nipe chirij jun winak, can mac-wi ri nu'on, y can ti'an juzgar. Chuka' ri nu'ij che jun chic: ¡Anchi' jac'atzin-wi ret!; ri ni'in quiri', can tic'uax chiquiwech ri autoridades chi ri tenemit chi ti'an juzgar. Y chuka' ri nu'ij nacanic che jun winak, ri nibano quiri' can yoben chic roma ri k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Romari' xa ret can jatc'o chic apo chech ri altar, roma c'o anchique najo' naya' che ri Dios y ja noka pa awi' chi ret c'o jun ex itzel abanon che jun winak; ");
INSERT INTO cakNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","taya' can ri ac'uan chiri' pa altar y tacanoj ri jun ri', y tabana' arreglar awi' riq'uin chi quiri' manak ayowal chi'icojol. Y c'ajari' catzolaj y tajacha' che ri Dios ri najo' naya' can che. ");
INSERT INTO cakNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Y cuando c'o jun ri jatrusujuj y jatruc'uaj pa juzgado, can tabana' arreglar awi' riq'uin cuando c'a man jani quixapon pa juzgado. Roma xa man na'an ta quiri', ri jun ri jatrusujuj xcatruya' pa ruk'a' ri juez, y raja' xcatrujach-e pa ruk'a' ri achi ri nuchajij ri cárcel chi jatrutz'apij can chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Y can ketzij nin-ij, chi jun ri nuc'ulumaj quiri', manak xtel-pe pa cárcel, c'a tutojo' na hasta ri ruq'uisbel centavo che ri jun anchok riq'uin rubanon-wi ruc'as. ");
INSERT INTO cakNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Chuka' ic'oxan ri tzij ri x-ix ojer can. Ri tzij ri' nu'ij: Jun achi c'ulan, man tuc'uaj-ri' riq'uin jun chic ixok. Y chuka' ri ixok man tuc'uaj-ri' riq'uin jun chic achi. ");
INSERT INTO cakNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero ren nin-ij chi ri achi ri nutzu' jun ixok y nurayij rech; xe romari' can xu'on yan mac riq'uin ri ixok pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Romari' xa ja ri awech ri c'o pa derecha nibano chawe chi na'an mac, más ta utz nalesaj y natorij-e. Roma más utz chi xe jun awech nalesaj-e y mani chi can ronojel ach'acul nibe chupa ri k'ak' chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Chuka' xa ja ri ak'a' derecha nibano chawe chi na'an mac, más ta utz chi nakupij y natorij-e. Roma más utz chi xe jun chique ri ak'a' nalesaj-e y mani chi can ronojel ach'acul nibe pa k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Y chuka' keta'n chi ojer can, x-ix: Ri achi ri man nrojo' ta chic raxayil y nujach-ri' riq'uin, tu'ona' jun carta ri nu'ij chi can nujach-ri' riq'uin, y tuya' che ri raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero ren nin-ij chiwe: Ri achi ri nujach-ri' riq'uin ri raxayil pero man roma ta ri ixok ruc'uan-ri' riq'uin jun chic achi; ri achi ri' can nu'on che ri raxayil chi nu'on mac xa nibe riq'uin jun chic achi, y ri achi chuka' mac ri nu'on, y quiri' chuka' ri achi ri nic'ule' riq'uin ri ixok, can nu'on mac chuka', roma ri ixok ri' c'a c'o ri na'ey rachijil. ");
INSERT INTO cakNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Y chuka' ic'oxan ri x-ix chique ri kawinak ojer can; man tiquijal quitzij, xa can tiquibana' ri xqui'ij roma can chech ri Ajaf Dios xqui'en-wi jurar chi can niqui'en-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero ren nin-ij chiwe: Man jun mej (bey) tiben jurar; man tisiq'uij ri rocaj chi niben jurar, roma ja chicaj c'o-wi ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Chuka' man tisiq'uij ri rech-ulef chi niben jurar, roma chiri' nuya-wi rakan ri Dios. Man tisiq'uij chuka' rubi' ri tenemit Jerusalem, roma ri tenemit ri' chi ri Nimalaj Rey. ");
INSERT INTO cakNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Y chuka' man tisiq'uij ri ijolon chi niben jurar; roma xe ri Dios nitiquier nujal rusmal-iwi', roma nu'on xak o sak che, y rix man jixtiquier ta niben ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Can man tiben jurar. Ronojel ri ni'ij, xe ti'ij ja' o ti'ij ni; roma xa niben jurar, man utz ta, roma ronojel ri' xa riq'uin ri itzel nipe-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Y rix can ic'oxan ri x-ix chique ri kawinak ojer can, chi xa c'o jun nulesaj ruwech jun chic winak, quiri' chuka' ti'an che raja'. Y ri nuk'aj rey jun winak, can quiri' chuka' ti'an che ri xbano quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero ren nin-ij chiwe: Man titzolej ruq'uiexel che ri nibano jun ex itzel chiwe. Xa c'o jun jixruch'ey, man tiya' ruq'uiexel che, xa tiya' chic iwi' pa ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Y xa c'o jun ri jixruc'uaj pa juzgado roma nrojo' numaj jun itziak, can tiya' lugar che chi nuc'uaj, y can tiya' can chuka' ri tziak ri ik'u'n-e che. ");
INSERT INTO cakNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","O xa c'o jun naj nibe-wi y nu'on chiwe chi nic'uaj reka'n (raka'n) c'a pa jun kilómetro, xa can tic'uaj ri eka'n (aka'n) jun chic kilómetro más. ");
INSERT INTO cakNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Y xa c'o jun chiwe rix ri c'o nic'utux che roma jun winak, can tuya-e che ri nic'utux che. Y xa c'o jun ri nuc'utuj jun ex pa kajic chiwe, man tiq'uieq'uiej che. ");
INSERT INTO cakNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Chuka' rix can ic'oxan ri x-ix ojer can. Ri tzij ri' nu'ij: Can quie'ajo' ri jatquijo' ret. Pero ri itzel jatquitzu', can itzel quie'atzu' chuka'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero ren nin-ij chiwe: Can quie'ijo' ri itzel yetz'eto iwichi; quie'ibana' bendecir ri winak ri jixqui'en maldecir; can utz tibana' quiq'uin ri man jixquijo' ta; tibana' orar che ri Dios pa quiwi' ri xe itzel tak ex niqui'en chiwe y xe itzel tak tzij niqui'ij chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Chi quiri' k'alaj chi jix ralc'ual ri Dios ri c'o chicaj. Roma raja' can utz quiq'uin conojel. Raja' nuya-pe rusakil ri k'ij pa quiwi' utzilaj tak winak y pa quiwi' ri winak itzel quic'aslen, y chuka' nuya-pe ri job pa quiwi' chojmilaj tak winak, y pa quiwi' ri man choj ta quic'aslen chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Roma xa rix xe ri winak ri jixquijo', xe reje' ye'ijo', man jun ruq'uiexel xtiwil romari'. Roma hasta ri winak ri itzel quic'aslen niqui'en quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Y xa rix xe quiq'uin ri iwach'alal jabel niben saludar-iwi', ¿anchique ta niben? Man jun. Roma hasta ri winak ri man quieta'n ta rech ri Dios niqui'en quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Rix, can choj ic'aslen tibana' riq'uin ronojel ri niben, anche'l ri Itata' c'o chicaj; roma raja' can choj-wi ruc'aslen riq'uin ronojel ri nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Can jabel tibana' cuenta iwi', man tiben ri utzilaj tak ex chiquiwech ri winak, xe chi jixquitzu' chi rix can niben ri nrojo' ri Dios. Y xa quiri' xtiben, ri Itata' ri c'o chicaj can man jun ruq'uiexel xtuya' chiwe romari'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cuando rix nito' jun ri manak rubeyomal, man tiya' rutzijol anche'l cuando nik'ajan jun trompeta chi quiri' conojel winak niquic'oxaj. Man tiben anche'l niqui'en ri winak ca'i' quipalaj, roma reje' niquitzijoj pa tak sinagogas y pa tak bey, chi quiri' conojel tiquic'oxaj chi reje' niqui'en ri utz y can utz quiech'o'n chiquij. Can ketzij-wi nin-ij chiwe chi ri winak ri yebano quiri', roma xyo'x quik'ij coma ri winak, riq'uin ri' xyo'x yan chique ruq'uiexel che ronojel ri xqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Y cuando rix nito' jun, man tiben chiquiwech winak chi quiri' can man jun nina'en ri niben rix. ");
INSERT INTO cakNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Pero ri Itata' ri c'o chicaj can nutzu' ri niben pa awel, raja' can reta'n-wi ri', romari' can xtuya' ruq'uiexel chiwe. Y can chiquiwech ri winak xtu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Cuando rix niben orar, man tiben anche'l niqui'en ri winak ca'i' quipalaj. Ri winak ri' yalan nika chiquiwech yepa'e' pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios y pa tak esquinas cuando niqui'en orar; xe chi quietz'et coma ri winak. Can ketzij nin-ij chiwe, chi ri winak ri yebano quiri', roma xyo'x quik'ij coma ri winak, riq'uin ri' xyo'x yan ruq'uiexel chique che ronojel ri xqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Y cuando jun chiwe rix nu'on orar, utz ntoc pa jay y tutz'apij-ri' y tu'ona' orar. Y más que ruyon oc c'o y pa awel nu'on orar, ri Rutata' ri c'o chicaj can nuc'oxaj y nutzu' ri nu'on pa awel, y xtuya' ruq'uiexel che, y can chiquiwech ri winak xtu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Cuando rix niben orar, man quie'ibij q'uiy mej (paj) ri tzij ri xe'ibij yan anche'l niqui'en ri winak ri man quieta'n ta rech ri Dios. Roma reje' niquinojij chi ri Dios yeruc'oxaj roma niqui'en nimalaj tak oraciones y q'uiy tzij yequicusaj. ");
INSERT INTO cakNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cuando niben orar, man tiben anche'l niqui'en ri winak ri man quieta'n ta rech ri Dios. Roma ri Itata' ri c'o chicaj can reta'n chic ri anchique nic'atzin chiwe, cuando c'a man jani tic'utuj rix che. ");
INSERT INTO cakNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Cuando rix xtiben orar, tibana' jun oración anche'l re': Katata' Dios jatc'o chila' chicaj, can conojel ta ri winak xtiquiya' ta ak'ij, y nim ta xtiqui'en che ri lok'olaj abi'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Y xtoka yan ta ri k'ij cuando ja ret xcabano gobernar. Y ja' ta ri najo' ret, can jari' ta ri xtibanataj we' chech-ulef, anche'l niqui'en ri jec'o awiq'uin chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Y taya' chuka' kaway ri nic'atzin chake k'ij-k'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Y can anche'l yekacoch' (yekacuy) ri winak ri c'o quitzelal niqui'en chake, quiri' ta xta'an ret kaq'uin roj, xtacoch' (xtacuy) ta kamac ri naka'an chawech. ");
INSERT INTO cakNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y man taya' lugar chi ri itzel nu'on chake chi jojtzak pa mac. Can kojacolo' chech. Quiri' ri nakac'utuj, roma xe ret ri jatc'o pa kawi', c'o awuchuk'a', y c'o nimalaj ak'ij chi ronojel tiempo. Amén. ");
INSERT INTO cakNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Xa rix ye'icoch' (ye'icuy) ri winak ri c'o anchique quibanon chiwe, ri lok'olaj Itata' ri c'o chicaj can xtucoch' (xtucuy) chuka' ri mac ri ye'iben rix chech. ");
INSERT INTO cakNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Pero xa man ye'icoch' (ye'icuy) ta ri winak ri c'o anchique quibanon chiwe, chuka' ri lok'olaj Itata' ri c'o chicaj manak xquixrucoch' (xquixrucuy) riq'uin ri mac ri ye'iben chech. ");
INSERT INTO cakNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Cuando rix niben ayunar, man tiben anche'l niqui'en ri winak ca'i' quipalaj; roma reje' nibison quipalaj yetzu'n, y quiri' niqui'en chi tina'ex coma ri winak chi reje' niqui'en ayunar. Can ketzij nin-ij chiwe, chi ri yebano quiri', roma xyo'x quik'ij coma ri winak; riq'uin ri' xyo'x yan chique ruq'uiexel ri niqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero cuando rix niben ayunar, man tik'alajij chi can jari' niben, xa can tich'aja' utz ipalaj, y chuka' jabel tijica' rusmal-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chi quiri', man k'alaj ta chiquiwech ri winak chi niben ayunar. Y xe ta ri Itata' ri c'o chicaj reta'n y c'o iwiq'uin cuando iyon jixc'o. Raja' can nutzu' ri man yetiquier ta niquitzu' ri winak, y raja' xtuya' ruq'uiexel chiwe. Y can chiquiwech ri winak xtu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Man quie'imol beyomel we' chech-ulef, roma ronojel ri' nichicopir y chuka' nipusir-ka y niq'uis. Chuka' jec'o elek'oma' ri niquilek'aj-e. ");
INSERT INTO cakNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Timolo' ibeyomal anchi' man jun ex nichicopir y chuka' manak nipusir, y chuka' man jun elek'om c'o. Can timolo' ibeyomal chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Roma ri iwánima can nic'ue' anchi' c'o-wi ri ibeyomal, roma jari' ri nitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ri iwech can yec'atzin chiwe anche'l jun luz. Y xa ri iwech je utz, rix jixc'o pa jun sakil. ");
INSERT INTO cakNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Pero xa ri iwech man je utz ta, can pa k'eku'm jixc'o-wi. Romari' xa nijalataj ri sakil ri ruyo'n ri Dios pa iwánima, can k'alaj chi pa jun nimalaj k'eku'm jixc'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Man jun samajel ri yec'ue' ca'i' ru-patrón, roma man nitiquier ta nisamaj quiq'uin ri je ca'i' pa jun tiempo. Roma xa nrojo' jun patrón, itzel nutzu' ri jun chic. Y xa can nunimaj rutzij ri jun, man nitiquier ta nu'on quiri' riq'uin ri jun chic. Y quiri' chuka', manak modo chi c'o ta jun ri benak ránima chirij ri beyomel, y nrojo' chuka' nu'on ri nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Romari' ren nin-ij chiwe: Man tich'ujrisaj-iwi' roma ri anchique nic'atzin chiwe k'ij-k'ij, anchi' xtiwil-wi iway-iwuq'uia' o anchi' xtiwil-wi itziak ri xticusaj. Y xa ja ri Dios ri xuya-pe ic'aslen chech-ulef, ¿ninojij como rix chi raja' man nitiquier ta chuka' nuya-pe ri iway o ri itziak? ");
INSERT INTO cakNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Quie'itzu' ri chicop ri c'o quixic' ri yebe chicaj, reje' man yetico'n ta, y romari' manak qui-cosecha juna-juna' chi niquiyec. Pero reje' yewa', roma ja ri Itata' c'o chicaj nitzuku quichi. Y rix más nim iwakalen que ri chicop ri'; romari' man tinojij más ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿C'o como jun chiwe rix ri nitiquier nu'on chi niq'uiy ta juba' más rakan, y romari' can ch'u'j nu'on? Man jun. ");
INSERT INTO cakNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Y anchique roma rix nich'ujrisaj-iwi' roma nijo' itziak? Quie'itzu' ri cotz'i'j quibinan lirio ri jec'o pa k'ayis, quie'itzu' cuando yeq'uiy. Reje' man yesamaj ta, ni man yebatz'in ta, chi quiri' niqui'en quitziak jabel oc. ");
INSERT INTO cakNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Y ojer can, xc'ue' jun rey xubinaj Salomón. Raja' ruyon jabel tak tziak xerucusaj, pero man jun mej (bey) xc'ue' ta jun rutziak anche'l titzu'n jun cotz'i'j. ");
INSERT INTO cakNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Roma ri cotz'i'j, jari' ri tziak ri nuya' ri Dios chique ri k'ayis ri'. Y más que ri k'ayis man yelayoj ta, roma jun k'ij jabel quibanon, y jun chic k'ij yechaki'j-ka y yeq'uiak pa k'ak', pero ri Dios can yeruwak jabel. Y xa ri Dios yeruwak jabel ri k'ayis, ¿anchique roma rix man iyo'n ta iwánima riq'uin chi raja' nuya' ronojel chiwe? ");
INSERT INTO cakNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Romari' man tich'ujrisaj-iwi' nicanoj iway-iwuq'uia' o itziak. ");
INSERT INTO cakNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Roma conojel winak quiri' niqui'en. Pero rix c'o jun Itata' ri c'o chicaj ri can reta'n chic anchique ri nic'atzin chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Romari' can ticanoj na'ey ri Dios y tibana' ri nrojo' y titija' ik'ij nic'uaj jun chojmilaj c'aslen chech, y ronojel ri nic'atzin chiwe, ja raja' xtiyo'n. ");
INSERT INTO cakNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Rix man tinojij yan anchique ruc'amon-pe ri chua'k. Ri chua'k can c'o-wi anchique ruc'amon-pe. Xe ri k'ij cami tinojij, roma k'ij-k'ij can c'o-wi sufrimientos yequic'om-pe chake. Y xa ninojij anchique xtaka'an chua'k, can ja' yan cami nimol-apo chiwij ri xtuc'om-pe ri chua'k. ");
INSERT INTO cakNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Man quie'iben juzgar ri winak, chi quiri' ri Dios manak xquixru'on juzgar chuka' anche'l niben rix. ");
INSERT INTO cakNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Roma xa rix ye'iben juzgar ri winak, quiri' chuka' xti'an chiwe rix. Can anche'l niben rix chique ri winak, quiri' chuka' xti'an chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Y ¿anchique roma ja la alaj k'ayis ri c'o pa rech ri awach'alal ri natzu' ch'anin, y man nana' ta chi ret xa jun nimalaj che' k'atel pa awech? ");
INSERT INTO cakNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Man ta'ij chuka' che ri awach'alal: Taya' lugar chue chi ninlesaj ri alaj k'ayis k'atel pa awech, y man nana' ta chi ret xa jun nimalaj che' k'atel pa awech. ");
INSERT INTO cakNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ret xa ca'i' apalaj; talesaj na'ey ri nimalaj che' pa awech ret, chi quiri' can k'alaj xcatzu'n y jatiquier nalesaj ri c'o pa ruwech ri awach'alal. ");
INSERT INTO cakNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ronojel ri can richi ri Dios, man taya' chique ri winak ri je anche'l tz'i'; y chuka' ri abaj ri ni'ix perla che, man taya' chiquiwech ri je anche'l ak. Roma ri chicop ri', más que jun ex yalan rakalen, choj quiri' yek'ax parui' y c'o jantak yetzolaj chirij ri xyo'n ri' chique, y niquic'ux (niquipurij). ");
INSERT INTO cakNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tic'utuj che ri Dios ri nic'atzin chiwe y raja' can xtuya-pe chiwe. Ticanoj y xtiwil ri nijo'. Tic'ojc'a-apo ri ruchi-jay y jixc'oxex-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Romari', xa can riq'uin ronojel iwánima nic'utuj che ri Dios, raja' can xtuya-wi-pe chiwe ri nic'utuj. Xa rix can nicanoj, can xtiwil-wi ri nicanoj. Y xa rix xtic'ojc'a-apo ri ruchi-jay, can xtijak-wi chiwech. ");
INSERT INTO cakNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿C'o como jun achi nuya' jun abaj pa ruk'a' ri ralc'ual, cuando ri ac'ual xa jun ruway nuc'utuj che? ");
INSERT INTO cakNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O nuya' como jun cumetz pa ruk'a', cuando ri ac'ual xa jun quer nrojo'? ");
INSERT INTO cakNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Rix man niben ta quiri' chique ri iwalc'ual. Más que rix itzel ino'j (ina'oj), pero man jun mej (bey) niya' jun itzel ex chique. Rix ja ri utzilaj tak ex niya'. Más chech ri' nu'on ri Itata' ri c'o chicaj. Raja' can nuya-pe chiwe ri nic'utuj che. Y ronojel ri nuya-pe, can je utz-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Quiri' chuka' rix, xe utzilaj ino'j (ina'oj) tibana' quiq'uin ri winak; roma rix man nika ta chiwech chi ri winak itzel quino'j (quina'oj) niqui'en iwiq'uin. Quiri' tz'iban can chupa ri ley ri xuya' ri Dios che ri Moisés. Quiri' chuka' qui'in can ri xek'alajin rutzij ri Dios ojer can. ");
INSERT INTO cakNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Quixoc chupa ri ruchi-jay ri can co'l oc rech. Roma xa can nim rech ri ruchi-jay y ri bey, ri nic'uan pa camic, y can je q'uiy winak ri ye'oc chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Pero can co'l oc rech ruchi-jay y co'l oc chuka' rech ri bey richi ri c'aslen, y man je q'uiy ta ri ye'ilo richi. ");
INSERT INTO cakNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Romari' tibana' cuenta iwi' chiquiwech ri je tz'ucuy-tzij ri ye'apon iwiq'uin y niqui'ij chi niquik'alajij ri ni'ix chique roma ri Dios. Roma cuando ye'apon iwiq'uin, can jabel quic'aslen, anche'l je ovejas, roma can man jun itzel nitz'etetaj chiquij. Pero cuando ne'k'alajin-pe ri itzel tak ex ri c'o pa cánima, xa anche'l je utif roma yalan je itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Can xtitemaj quiwech, can anche'l nitemaj rech jun che', roma xe riq'uin ri rech ri nuya' jun che', nina'ex xa utz o man utz ta. Ri k'ayis ri yalan quiq'uixal, can manak xtiquiya' uva ni higo. ");
INSERT INTO cakNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quiri' chuka' iweta'n chi jun utzilaj che' nuya' utzilaj tak rech, pero jun che' ri man utz ta, can man utz ta chuka' rech ri nuya'. ");
INSERT INTO cakNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Man jun utzilaj che' xtuya' ta itzel tak rech, y chuka' jun che' ri man utz ta, manak xtuya' utzilaj tak rech. ");
INSERT INTO cakNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Y conojel che' ri man utz ta quiwech niquiya', yekases y yeyo'x pa k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Romari' rix xtitemaj quiwech ri winak roma ri niqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Can je q'uiy winak ri ¡Ajaf! ¡Ajaf! yecha' chue, pero man conojel ta xquie'oc quiq'uin ri ye'an gobernar roma ri Dios. Roma ri xquie'oc chiri', xe ri can riq'uin ronojel cánima niqui'en ri nrojo' ri Nata' Dios ri c'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Y chupa ri k'ij cuando ren xquienben juzgar ri winak, je q'uiy ri xtiqui'ij chue: ¡Ajaf! ¡Ajaf! roj pa abi' ret xkatzijoj rutzij ri Dios, chuka' pa abi' ret xekacol q'uiy winak ri c'o itzel tak espíritus quiq'uin y pa abi' ret xeka'an q'uiy milagros, xquiecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero ren xtin-ij chique: Ren can man jun mej (bey) xintemaj iwech. Romari' man utz ta jixc'ue-pe wiq'uin, rix ri xe itzel tak ex ri xe'iben, xquicha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Y xabachique (xama'anchique) winak ri nuc'oxaj nutzij y nu'on ri nin-ij ren, can junan riq'uin ri jun achi ri yalan runo'j (runa'oj); raja' xu'on jun rocho parui' abaj. ");
INSERT INTO cakNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xpe c'a ri job, xepe rakan tak ya' y quiek'ik' chirij ri jun jay ri', pero man xtzak ta. Roma ri ru-cimiento ri jay ri' can parui' abaj xtic-wi-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Y xabachique (xama'anchique) winak ri xe nuc'oxaj ri nin-ij ren, pero man nu'on ta ri nin-ij che, can junan riq'uin jun achi nacanic ri xupoba' rocho pa sanayi'l. ");
INSERT INTO cakNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xpe ri job, xepe rakan tak ya' y quiek'ik' chirij ri jun jay ri' y ja' xtzak; y xq'uis jumul. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Y cuando ri Jesús xtane-ka nich'o'n, ri winak ri yec'oxan-apo richi xsatz quino'j (xsach quic'u'x) cuando xquic'oxaj ri tzij ri xeru'ij chique chi yerutijoj. ");
INSERT INTO cakNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Roma cuando yerutijoj, can k'alaj chi can c'o uchuk'a' pa ruk'a' y man anche'l ta oc ri maestros chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Y cuando ri Jesús xka yan pe parui' ri juyu', ri winak ri je-benak chirij can je q'uiy. ");
INSERT INTO cakNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Y c'o jun achi yawa' riq'uin ri jun yabil rubinan lepra, xbe'apon chech ri Jesús, xxuquie-ka chech y xu'ij che: Ajaf, ren weta'n chi jatiquier nalesaj nuyabil, pero man weta'n ta anchique nanojij pa nuwi', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Y ri Jesús can ja' xutz'om-apo ri achi y xu'ij che: Ninjo' chi jac'achoj. Tiq'uis-e ayabil, xcha' che. Y can xe xu'ij quiere' ri Jesús, ri yabil xq'uis-e chirij ri achi y ch'ajch'oj xu'on-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Y ri Jesús xu'ij che ri achi ri': Man tatzijoj chique ri winak ri xbanataj awiq'uin, xe ac'utu-awi' chech ri sacerdote pa rocho ri Dios, y taya' ronojel ri nu'ij chupa ri ru-ley ri Moisés. Chiri' nu'ij ri anchique nic'atzin naya' che ri Dios, chi quiri' k'alaj chiquiwech conojel chi jat ch'ajch'oj chic, xcha-e che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Y cuando ri Jesús c'o chic pa tenemit Capernaum, xapon jun achi riq'uin. Ri achi ri' jun capitán y xuc'utuj jun favor che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Quiere' xu'ij ri capitán: Ajaf, ri achi nusamajel c'o chiwocho, cotz'ol chech ruch'at roma siquirinak ruch'acul. Y yalan nu'on sufrir romari'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Y ri Jesús xu'ij che ri capitán: Jo' y ri achi asamajel nic'achoj can woma ren, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Y ri achi capitán xu'ij chic apo che ri Jesús: Ajaf, ren xa jin jun achi ri yalan numac, romari' man nuc'ul ta jatoc chiwocho; xe ta'ij chi tic'achoj y ja xtiq'uis-e ruyabil ri nusamajel. ");
INSERT INTO cakNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ren can weta'n chi quiri' xtibanataj, roma ren can ninnimaj quitzij ri c'o más quik'ij chinuech. Y chuka' jec'o soldados ri niquinimaj nutzij ren. Y cuando nin-ij che jun chi tibe, ja nibe; y cuando nin-ij che jun chic chi tipe, ja nipe. Y chuka' cuando nin-ij che nusamajel chi tu'ona' jun samaj, can nu'on, xcha' ri capitán. ");
INSERT INTO cakNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Y ri Jesús can anchique la xuna' cuando xuc'oxaj ri xu'ij ri capitán, y xerutzu' ri winak ri je-benak chirij y xu'ij chique: Can ketzij nin-ij chiwe chi ri jun achi re' can yalan-wi ruyo'n ránima wiq'uin. Y can man jun nuwinak israelita ri wilon ri can ruyo'n ta ránima wiq'uin, anche'l ri jun achi re'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Can nin-ij-wi chiwe chi can q'uiy winak ri xquiepe anchi' ntel-pe ri k'ij y chuka' anchi' nika-wi-ka ri k'ij, y conojel winak ri can jinquiniman. Reje' xquiebech'oquie' riq'uin ri Abraham, ri Isaac, ri Jacob y ri ch'aka chic ri jec'o pa ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Pero ri winak ri can je richi-wi chi ye'oc pa ru-gobierno ri Dios, man xquie'oc ta chic, xa xquie'leses-e y xquieq'uiak chupa ri k'eku'm, roma xa can man xinquinimaj ta. Y c'a chiri' xquie'ok' y xtiquijach'ach'ej quey. ");
INSERT INTO cakNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","C'ajari' ri Jesús xu'ij-e che ri capitán: Catzolaj chi'awocho. Roma xanimaj chi woma ren nic'achoj ri asamajel, can tibanataj anche'l najo', xcha-e che. Y ri achi rusamajel ri capitán ri', can ja' xk'ax ruyabil. ");
INSERT INTO cakNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Y cuando ri Jesús xapon pa rocho ri jun ru-discípulo ri rubinan Pedro, xutzu' chi ri rujite' ri Pedro li'an chech ruch'at roma c'o jun nimalaj c'aten chirij. ");
INSERT INTO cakNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Xpe raja' xutz'om ruk'a' ri yawa' y can ja' xq'uis-e ri nimalaj c'aten chirij. Rujite' ri Pedro xcataj-pe y xerutzuk ri Jesús y ri je-benak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Cuando xk'okumer-ka ri k'ij ri', je q'uiy winak ri c'o itzel tak espíritus quiq'uin xec'uax-apo chech ri Jesús, chi yerulesaj-e ri itzel tak espíritus quiq'uin. Y raja', riq'uin ri rutzij xerulesaj-e ri itzel tak espíritus, y chuka' can conojel ri yawa'i' xec'achoj-e roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Chi quiri' can nibanataj ri ru'in can ri Isaías, ri jun achi ri xuk'alajij rutzij ri Dios ojer can. Quiere' ru'in can ri Isaías chirij ri Jesús: Xerulesaj-e kayabil konojel, y xuc'uaj ronojel kaquiy (kak'axomal). Quiri' ru'in can. ");
INSERT INTO cakNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Cuando ri Jesús xutzu' chi can q'uiy winak niquimol-apo-qui' riq'uin, ja xu'ij chique ri ru-discípulos chi tiquic'ama-pe jun canoa chi yebe juc'an chic ruchi-choy (ruchi-ya'). ");
INSERT INTO cakNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Y c'o c'a jun achi maestro chi ri ley xapon riq'uin ri Jesús y xu'ij che: Ret can jat Maestro-wi, y ren ninjo' jatintzeklebej xabachi' (xama'anchi') xcatapon-wi, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Y ri Jesús xu'ij che: Ri utif can c'o-wi quijul anchi' yec'ue-wi; y quiri' chuka' ri chicop ri c'o quixic' ri yebe chicaj, can c'o chuka' quisoc. Pero ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can man jun wocho anchi' yinuxlan-wi juba', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Y ja chuka' c'o jun chic ri can rutzekleben ri Jesús, xu'ij-apo che: Ajaf, ren can ninjo-wi jatintzeklebej. Pero taya' lugar chue chi na'ey ninmuk na e ri nata', y c'ajari' yibe chawij, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Xpe ri Jesús xu'ij che: Ret quinatzeklebej. Xa taya' lugar chi ri caminak yemuk coma ri je caminak chupa ri quimac, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Y ri Jesús xoc-e pa jun canoa; y ri can quitzekleben-wi xebe chuka' chirij. ");
INSERT INTO cakNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Y c'aja' xquina', yalan xbesilon-pe ri ya', y cuando nicataj chicaj, can anche'l nibe chuxe' ya' ri canoa, roma can niq'uis-ka jumul chucojol ya'. Y ri Jesús niwer benak. ");
INSERT INTO cakNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Y xepe ri discípulos xbequic'asoj ri Jesús y xqui'ij che: ¡Ajaf! ¡Ajaf, kojato'! Cami jojcom, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Pero ri Jesús xu'ij chique: Can man iyo'n ta utz iwánima wiq'uin; romari' ixi'n-iwi', xcha'. Y raja' xcataj-pe y xu'ij chi tiq'uis-e ri ruchuk'a' ri quiek'ik' y titane-ka ri ya'. Y quiri' xbanataj. Ri quiek'ik' xq'uis-e ruchuk'a', y xtane-ka chuka' ri ya'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Y ri discípulos xsatz quino'j (xsach quic'u'x) cuando xquitzu' ri xu'on ri Jesús y niqui'ij: ¿Anchique c'a achi re'? Roma ri quiek'ik' y ri ya' can yeniman che chuka'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Y cuando ri Jesús y ri ru-discípulos jec'o juc'an chic ruchi-choy (ruchi-ya'), chiri' pa jun lugar rubinan Gadara, jec'o ca'i' achi'a' xe'apon riq'uin ri Jesús; y ri ca'i' achi'a' re' c'o itzel tak espíritus quiq'uin y ja ri cementerio ri c'o chupa ri lugar ri' ri oconak cocho. Y roma yalan je itzel, man jun chic winak nibin chupa ri bey ri nik'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ri ca'i' achi'a' ri', riq'uin quichuk'a' xech'o'n-apo che ri Jesús, y xqui'ij: Ret Jesús ri Ralc'ual ri Dios, ¿anchique najo' chake? ¿Anchique roma jojach'ujrisaj yan cami, cuando man jani napon ri k'ij? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Y roma chunakaj apo juba' che ri lugar ri', can je q'uiy ak yewa'; ");
INSERT INTO cakNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ri itzel tak espíritus ri jec'o quiq'uin ri ca'i' achi'a' xquic'utuj favor che ri Jesús, y xqui'ij che: Xa jojalesaj-e, taya' lugar chake chi jojoc quiq'uin ri ak la jec'o chila', xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ri Jesús xu'ij chique: Jix (Quixbin) c'a. Y ri itzel tak espíritus can ja' xe'el-e y xebe'oc quiq'uin ri ak. Y conojel ri ak ri' can junanin xebexule-pe chech jun juyu' can pa'l rech, y c'a pa ya' xebeka-wi; y chiri' xejik'-wi conojel ri ak ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Y ri yechajin quichi ri ak, can xe xquitzu' ri xbanataj, xelumaj (xenimaj), xebe pa tenemit y xbequitzijoj can ri xbanataj quiq'uin la ak y chuka' ri xbanataj quiq'uin ri ca'i' achi'a' ri c'o itzel tak espíritus quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Conojel winak chi ri tenemit ri' xepe riq'uin ri Jesús chi xoquitzu', y xquic'utuj favor che chi tel-e chiri' chupa quitenemit. ");
INSERT INTO cakNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ri Jesús y ri ru-discípulos xe'oc-e pa jun canoa y xebe c'a juc'an chic ruchi-ya', y xe'apon pa rutenemit ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Y c'o jun achi ri can siquirinak ruch'acul, li'an-e chech jun ch'at, ri xc'uax-apo chech ri Jesús. Y cuando ri Jesús xerutzu' chi can quiyo'n-wi cánima riq'uin, ja xu'ij che ri achi siquirinak ruch'acul: Walc'ual, xcha' che. Tiquicot c'a awánima; ronojel ri amac xecoch'otaj (xecuyutaj). ");
INSERT INTO cakNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Y jec'o jujun chique ri maestros chi ri ley ri jec'o-apo chiri', xqui'ij-ka pa cánima chirij ri Jesús: Ri itzel achi re' can nu'on chi ja raja' ri Dios, roma nu'ij chi nucoch' (nucuy) mac. ");
INSERT INTO cakNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Pero ri Jesús can reta'n ri niquinojij pa cánima ri maestros ri', y ja' xu'ij chique: ¿Anchique roma ja ri itzel tak ex ri xinojij ch'anin? ");
INSERT INTO cakNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Roma xa ren yitiquier nin-en che ri jun achi re' chi nibin-e, ¿yitiquier como nin-ij che chuka' chi nincoch' (nincuy) rumac? ¿Anchique ni'ij rix? ");
INSERT INTO cakNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Cami c'a, chi rix nitemaj chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can c'o uchuk'a' wiq'uin chi nincoch' (nincuy) mac, titzu' c'a, xcha' raja'. Y ja' cuando ri Jesús xu'ij che ri achi siquirinak ruch'acul: Nin-ij chawe: Cacataj, tac'uaj la ach'at y jat (cabin) chi'awocho, xuche'x roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Y ri achi can ja' xcataj-e y xbe chirocho. ");
INSERT INTO cakNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Y cuando ri winak ri quimolon-apo-qui' chiri' xquitzu' chi ri achi xpa'e' y xbe, xquixi'j-qui', roma man jun mej (bey) quitz'eton chi nibanataj ta quiri'. Y chuka' xquiya' ruk'ij ri Dios, roma ruyo'n-pe ri jun nimalaj uchuk'a' chiquicojol ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Y cuando Jesús benak, xutzu' jun achi rubinan Mateo. Ri achi ri' ch'ocol chiri' y numol ri impuestos ri yetoj can. Ri Jesús xu'ij che: Quinatzeklebej. Y raja' xcataj-pe ri anchi' ch'ocol-wi y xutzeklebej ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Y cuando ri Jesús ch'ocol chuchi' mesa chiri' pa jay, je q'uiy chique ri moloy-impuestos y ch'aka chic winak ri ni'ix aj-mac chique, xech'oquie-apo chuchi' mesa, junan riq'uin ri Jesús y ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Y ri achi'a' fariseos yequitzu-apo, xqui'ij chique ri ru-discípulos ri Jesús: ¿Anchique roma ri i-Maestro niwa' quiq'uin moloy tak impuestos y quiq'uin winak aj-mac? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Pero cuando ri Jesús xuc'oxaj ri tzij ri niqui'ij ri achi'a' fariseos, xu'ij chique: Jun ri nik'oman man ja' ta ri je utz ri yeruk'omaj. Raja' yeruk'omaj ri yeyawaj. ");
INSERT INTO cakNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Y quiri' ren, roma ren man xipe ta chiquicanoxic winak ri choj rubanon quic'aslen chech ri Dios. Ren xipe chiquicanoxic ri can c'o quimac, chi niquiya' can quimac y niqui'en ri nrojo' ri Dios. Romari' man xe ta choj quiri' ti'ij-pe ri tzij; xa itemaj anchique ntel chi tzij ri nu'ij ri Dios: Ren más nika chinuech chi rix nijoyowaj quiwech ri winak, que chech ri chicop ri ye'isuj chinuech. ");
INSERT INTO cakNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Y ri ru-discípulos ri Juan Bautista xeloka riq'uin ri Jesús y xqui'ij che: Roj can kacha'on k'ij chi naka'an ayunar. Y quiri' chuka' niqui'en ri achi'a' fariseos. ¿Y anchique roma ri a-discípulos ret man quiri' ta niqui'en? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Y ri Jesús xu'ij chique: ¿Anchique ni'ij rix? ¿Utz como yebison ri je-banon invitar pa jun c'ulubic y niquimalij ri wa'in, y xa c'a c'o ri ala' ri xc'ule' chiquicojol? Man utz ta. Pero xtapon ri k'ij cuando ri ala' re' xtileses-e chiquicojol, c'ajari' xtiqui'en ayunar. ");
INSERT INTO cakNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Man jun winak nuretz-ka jun tziak c'ac'ac' chi nuc'ojoj (nut'is) jun tziak ri xa can tzia'k' chic. Roma ri tziak c'ac'ac' nuc'ol-ri' y nujic' ri tziak ri xa tzia'k' chic y más nuretz. ");
INSERT INTO cakNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Y quiri' chuka' man jun nuya-ka c'ac'ac' vino chupa jun tz'um yacbel-ya' ri xa ucusan chic. Roma xa quiri' ni'an, man utz ta; roma ri tz'um xa man nuyuk ta chic ri', ri tz'um nibojbo' (nichiquitaj) y niq'uis-e ri vino chupa. Y ri tz'um chuka' man jun chic xtic'atzin-wi. Pero chupa jun c'ac'ac' yacbel-ya' utz niyaquie' c'ac'ac' vino, roma ri tz'um ri' c'a nuyuk-ri' jabel y man nibojbo' (nichiquitaj) ta. Ri vino can utz niyaquie' chupa. Quiere' ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Y cuando ri Jesús nutzijoj ronojel ri', c'o jun achi ri yalan ruk'ij chiquicojol ri israelitas xbexuquie' chech y xu'ij: Ri numi'al c'aja' oc nicom, pero xa ret ne'aya' ak'a' pa ruwi', can nic'ase' chic pe, xcha' ri achi. ");
INSERT INTO cakNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ri Jesús ja xcataj-e y junan quiq'uin ri ru-discípulos xquitzeklebej-e ri achi. ");
INSERT INTO cakNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Y c'o c'a jun ixok yawa' ri c'o yan cablajuj juna' nibin ruquiq'uiel y man nitane' ta. Raja' xunim-apo-ri' chirij ri Jesús, y xutz'om-apo juba' ruchi-rutziak ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Roma ri ixok ri' can runojin-pe pa ránima: Xe ta riq'uin nintz'om-apo juba' ruchi-rutziak, nitane-ka nuyabil, ru'in pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús can xuna' y xtzu'n chirij y xu'ij che ri ixok ri': Numi'al, xacolotaj roma can xaya' awánima wiq'uin. Man chic cabison, xuche'x. Y ri ixok ri' can ja' xtane' ruyabil. ");
INSERT INTO cakNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Y cuando ri Jesús ntoc-apo pa rocho ri achi ri c'o ruk'ij, xutzu' chi yech'ujlan y jec'o yan ri yek'ojman flautas. ");
INSERT INTO cakNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xpe raja' xu'ij: Quixel-e, kojiya' can kayon, roma ri xten re' man caminak ta, xe niwer, xcha' chique ri winak. Pero reje' xa xetze'n chirij ri Jesús, roma can quieta'n chi can caminak-wi ri xten. ");
INSERT INTO cakNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Y cuando ri winak je-elenak chic pe, ri Jesús xoc-apo pa jay anchi' c'o-wi ri xten caminak. Y xutz'om ruk'a' y ri xten xc'astaj chic pe. ");
INSERT INTO cakNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ri xbanataj chiri', xbe rutzijol pa tak tenemit chupa ri rech-ulef ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Y cuando ri Jesús xel-pe chiri', jec'o ca'i' moy xquitzeklebej-e y riq'uin quichuk'a' niqui'ij che: ¡Tajoyowaj kawech ret ri jat ru-familia can ri rey David! yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Cuando ri Jesús xapon pa jay, ri ca'i' moy xe'apon chuka' riq'uin. Y ri Jesús xuc'utuj chique: ¿Can ninimaj rix chi ren yitiquier nin-en chiwe chi c'o modo jixtzu'n? xcha' chique. Y ri ca'i' moy ri' xqui'ij: Ja' Ajaf, nakanimaj, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Xpe ri Jesús xuya' ruk'a' chuchi' tak quiwech chi je ca'i' y xu'ij chique: Roma rix ninimaj chi ren yitiquier nin-en chiwe chi jixtzu'n, can tibanataj c'a ri anche'l nirayij, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Y reje' can ja' xetzu'n. Pero ri Jesús yalan xuchelebej-e chique y xu'ij: Man titzijoj ri xbanataj iwiq'uin, chi quiri' man tiquic'oxaj ri ch'aka chic winak, xcha-e chique. ");
INSERT INTO cakNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Pero reje' can xe xe'el chiri' can ja' xquitzijoj-ka pa ronojel rech-ulef ri', ri xu'on ri Jesús quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Y cuando xe'el-pe ri je ca'i' achi'a' ri', jec'o xe'oc can riq'uin ri Jesús, quic'uan-apo jun achi mem; ri achi re' quiere' rubanon roma c'o jun itzel espíritu riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Y cuando ri Jesús xulesaj-e ri itzel espíritu riq'uin ri achi, can ja' xch'o'n-pe ri achi. Y ri winak ri xquitzu' ri', xsatz quino'j (xsach quic'u'x) y xqui'ij: Man jun mej (bey) katz'eton chi quiere' yebanataj we' pa rech-ulef Israel, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Pero ri achi'a' fariseos niqui'ij chirij ri Jesús: Ja ri quijawal ri itzel tak espíritus ri niyo'n uchuk'a' che, romari' nitiquier yerulesaj itzel tak espíritus, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Y ri Jesús can pa ronojel nimalaj y cocoj tak tenemit napon-wi, y yerutijoj ri winak pa tak sinagogas, ri jay anchi' niquimol-wi-qui' ri winak ri' chi niquic'oxaj rutzij ri Dios, y chuka' nutzijoj chique ri utzilaj rutzij ri Dios ri nich'o'n chirij ri ru-gobierno ri Dios. Y chuka' yec'achoj can q'uiy winak ri jalajoj rech yabil ntoc chique. ");
INSERT INTO cakNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Y cuando yalan winak xerutzu', xujoyowaj quiwech, roma can quiyon jec'o y quitalun-qui'; can anche'l niqui'en ri ovejas cuando man jun ri nichajin quichi. ");
INSERT INTO cakNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Y ri Jesús xu'ij chique ri ru-discípulos: Can ketzij-wi chi ri samaj richi nitzijos rutzij ri Dios, can q'uiy, pero ri samajel xa man je q'uiy ta. ");
INSERT INTO cakNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Romari' tic'utuj che ri Rajaf ri samaj, chi quierutaka-pe más samajel chiquicojol ri winak ri nic'atzin chi niquic'oxaj rutzij. ");
INSERT INTO cakNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Y ri Jesús xeroyoj ri cablajuj ru-discípulos y xuya' quichuk'a' chi yetiquier yequilesaj itzel tak espíritus y chuka' chi yec'achoj can q'uiy winak ri jalajoj rech yabil ntoc chique. ");
INSERT INTO cakNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jare' quibi' chiquijunal ri cablajuj achi'a' ri yetak-e chi niqui'en ri samaj: Ri na'ey ja ri Simón ri ni'ix chuka' Pedro che, y ri Andrés ri rach'alal ri Simón. Ri Jacobo y ri Juan je ralc'ual jun achi rubinan Zebedeo. ");
INSERT INTO cakNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Ri Felipe, ri Bartolomé, ri Tomás, ri Mateo ri moloy-impuestos, ri Jacobo ralc'ual jun achi rubinan Alfeo, ri Lebeo ri ni'ix chuka' Tadeo che. ");
INSERT INTO cakNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ri Simón ri c'o quiq'uin ri achi'a' ri ni'ix cananista chique, y ri Judas Iscariote ri xc'ayin richi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Y ja ri cablajuj achi'a' ri' xerutak-e ri Jesús, y chi xerupaxabaj-e, quiere' xu'ij chique: Man quixapon quiq'uin ri winak ri man je israelitas ta. Chuka' man quixapon pa tak tenemit chi ri rech-ulef Samaria. ");
INSERT INTO cakNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xe quiq'uin ri kawinak israelitas ri man jec'o ta apo riq'uin ri Dios quixapon-wi. Roma reje' quibanon can anche'l niqui'en ri ovejas cuando quisatzon (quisachon) can qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Y cuando itz'amon bey jix-benak, can titzijoj rutzij ri Dios; can ti'ij chique ri winak chi ri ru-gobierno ri Dios nakaj chic c'o-wi-pe, quixcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Quie'ic'achojrisaj can yawa'i', y ri c'o ri yabil lepra chiquij, can tibana' chique chi can ch'ajch'oj nu'on can ri quich'acul. Quie'ic'asoj caminaki', quie'ilesaj chuka' itzel tak espíritus. Y roma ronojel ri uchuk'a' re' xa sipan chiwe, quiri' chuka' tibana' can rix, can man jun iwajil tic'utuj cuando nicusaj ri uchuk'a' ri', xa tisipaj can. ");
INSERT INTO cakNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Can man jun rech mero tic'uaj-e. Man tic'uaj ri banon riq'uin oro ni plata, ni chuka' ri banon riq'uin cobre. ");
INSERT INTO cakNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Man tic'uaj ichim. Chuka' man tic'uaj-e jun chic itziak; can xe ri icusan-e. Man tic'uaj jun chic par ixajab, ni man tic'uaj chuka' ich'ami'y. Can man jun ex tic'uaj. Roma jun samajel ri xabachi' (xama'anchi') napon-wi, can nic'atzin chi nitzuk. ");
INSERT INTO cakNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Y cuando jixapon pa jun tenemit nim o pa jun tenemit co'l, ticanoj jun winak ri can utz runo'j (runa'oj) nu'on iwiq'uin, y pa rocho raja' quixc'ue-wi-ka, y c'a quixel na pe chupa ri tenemit ri', utz niya' can ri jay anchi' xixc'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Y cuando jixoc-apo chupa ri jay ri', quie'ibana' saludar ri jec'o chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tirayij ri ruxlanen ri Dios pa quiwi'. Y xa nuc'ul chi jixc'ue-ka chupa ri jay ri', roma can utz xc'ul iwech; ri ruxlanen ri Dios ri nirayij pa quiwi', can xtika-wi pa quiwi'. Pero xa man nuc'ul ta jixc'ue-ka chupa ri jay ri', roma man nic'ul ta iwech; ri ruxlanen ri Dios ri nirayij pa quiwi', can man xtika ta pa quiwi'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Y xa can man utz ta niquic'ul iwech y man niquijo' ta chuka' niquic'oxaj rutzij ri Dios ri nitzijoj rix chique, quixel-pe chupa ri jay ri' o chupa quitenemit. Y titota' can ri pokolaj ri c'o pa tak iwakan chiquiwech ri winak, chi quiri' tiquina'ej chi can man utz ta ri xqui'en chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Roma ren can nin-ij chiwe, chi chupa ri k'ij cuando ri winak xquie'an juzgar roma ri Dios, ri winak chi ri tenemit anchi' man utz ta xc'ul iwech, can más nim ri castigo ri xtika pa quiwi' que chiquiwech ri winak ri xec'ue' pa tenemit Sodoma y Gomorra. ");
INSERT INTO cakNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Cami jixintak-e, y rix iweta'n chi xa jix anche'l ovejas ri jixapon chiquicojol winak je anche'l utif. Pero can tibana' anche'l nu'on ri cumetz; raja' ch'anin nuna' cuando c'o jun petenak. Pero can tibana' chuka' anche'l nu'on jun paloma, roma raja' man jun etzelal nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Can tibana' cuenta iwi', chi quiri' man xe ta choj ne'iya-iwi' pa quik'a' ri winak ri man utz ta jixquitzu'. Roma reje' xquixquijach pa quik'a' ri autoridades quichi ri tenemit y chuka' xquixch'ay pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Chuka' ri winak can xquixquic'uaj chiquiwech gobernadores y chiquiwech reyes woma ren. Pero roma quiri' xti'an chiwe woma ren, rix xquixtiquier xquinik'alajij chiquiwech reje' y chiquiwech chuka' ri winak man je israelitas ta. ");
INSERT INTO cakNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Cuando ri winak xquixquijach pa quik'a' ri autoridades, man tichajij pena roma ri xti'ij chique y anchique tzij xticusaj chi jixch'o'n chiquiwech. Roma chupa ri misma hora ri', ri Dios xtuya-pe chiwe ri tzij ri xti'ij-apo. ");
INSERT INTO cakNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Roma can ja ri ru-Espíritu Santo ri Itata' Dios ri xtiyo'n chiwe anchique tzij utz ni'ij-apo. Y man ja' ta rix ri xquixch'o'n. ");
INSERT INTO cakNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Y xtibanataj chi xa jec'o je ca'i' achi'a' cach'alal qui', jun chique reje' xtujach ri rach'alal chi nicamises. Chuka' can jec'o tata'j ri xquiequijach calc'ual chi yecamises. Y jec'o chuka' ri quiri' xtiqui'en chique quite-quitata'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Can conojel winak itzel xquixquitzu' roma iyo'n iwánima wiq'uin ren. Pero ri can man xtitzolaj ta chirij y xtucoch' c'a pa ruq'uisbel che ronojel, can xticolotaj-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Y cuando ri winak chupa jun tenemit jixquiya' pa sufrimiento, quixlumaj (quixnimaj) pa jun chic tenemit y chiri' quixc'ue-wi. Roma can ketzij nin-ij chiwe chi c'a man jani quixapon pa ronojel tenemit ri jec'o pa Israel, cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, yipe yan. ");
INSERT INTO cakNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Roma xa ren nink'axaj sufrimiento, rix chuka' c'o sufrimiento xtik'axaj. Roma man jun ri nitijox c'o más ruk'ij chech ru-maestro, chuka' man jun samajel c'o más ruk'ij chech ri rajaf samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jun ri nitijox, tiquicot xe ni'an anche'l ru-maestro che, y quiri' chuka' jun samajel tiquicot xe ni'an anche'l ru-patrón che. Roma xa ja ren ri Tata'j chi'icojol y ri winak niqui'ij Beelzebú chue, can más peor xti'ix chiwe rix. ");
INSERT INTO cakNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Pero man tixi'j-iwi' chiquiwech ri xquiebano quiri' chiwe, roma xa can nic'atzin chi rix nik'alajij ri man k'alajin ta utz. Can nic'atzin chi nina'ex ri tz'apel can rij. ");
INSERT INTO cakNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Roma ronojel ri nin-ij chiwe pa k'eku'm, can tilesaj rutzijol, y quiri' niya' pa sakil. Ri xin-ij chiwe pa alak'al, xa quixjote' parui' iwocho y chiri' quixsiq'uin tiya' rutzijol chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Man tixi'j-iwi' chiquiwech ri xe ri ich'acul ri yetiquier niquicamisaj y che ri iwánima man jun yetiquier niqui'en. Ri anchok chech nic'atzin-wi nixi'j-iwi', ja chech ri jun ri nitiquier nuya' iwánima y ri ich'acul pa k'ak' chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Can jabel iweta'n chi cuando ye'ilok' ca'i' chicop ri c'o quixic', xe jun centavo cajil. Pero man roma ta chi ri chicop ri' manak cajil, can man jun chique reje' xtitzak ta pa ulef xa ri Itata' Dios man nrojo' ta. ");
INSERT INTO cakNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Y rix hasta ri rusmal tak iwi' ajilan ronojel. ");
INSERT INTO cakNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ri Dios man jun mej (bey) jixrumestaj ta can. Ri Dios yalan jixrojo' rix. Más jixrojo' que chiquiwech ri chicop ri c'o quixic', y romari' man tixi'j-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Y xabachique (xama'anchique) winak ri nuk'alajij-ri' chi wichi ren, ren chuka' xtink'alajij chi raja' wichi chic ren. Y can chech ri Nata' Dios c'o chicaj xtin-ij-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Pero ri winak ri man nuk'alajij ta ri' chi wichi ren, chuka' ren can man xtink'alajij ta apo rubi' che ri Nata' Dios c'o chicaj, roma man wichi ta ren ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Man tinojij chi ren xipe chech-ulef chi nic'ue' uxlanen quiq'uin conojel. Man quiri' ta. Xa woma ren can jec'o xtiquijachala-ka-qui' roma ayowal. ");
INSERT INTO cakNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Woma ren, ri ala' xticataj chirij ri rutata'. Ri xten xticataj chirij ri rute'. Y can quiri' chuka' ri alibetz can xticataj chirij ri ralite'. ");
INSERT INTO cakNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ri can itzel xquietz'eto richi jun winak ri jinruniman ren, ja ri ru-familia raja' mismo. ");
INSERT INTO cakNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Xa c'o jun ri más yerojo' rute-rutata' y man nu'on ta ri nin-ij ren che, can man nuc'ul ta ntoc wichi. Ri te'j-tata'j ri más yequijo' calc'ual que chinuech ren, can man nuc'ul ta ye'oc wichi. ");
INSERT INTO cakNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun winak ri can nrojo' ntoc wichi ren, man tupokonaj nu'on sufrir woma ren, xa can tu'ona' anche'l xa can ruc'uan ru-cruz. Pero xa c'o jun ri nupokonaj nu'on sufrir woma ren y man nrojo' ta yirutzeklebej, man nuc'ul ta ntoc wichi ren. ");
INSERT INTO cakNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Roma xa ja ri c'aslen chi ri rech-ulef ri nrojo', can manak xtiril ri c'aslen richi ronojel tiempo. Pero ri winak ri man nupokonaj ta ruc'aslen woma ren, can xtiril-wi ri c'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jun ri can nuc'ul iwech rix, can ja chuka' ren ri yiruc'on-ka; y ri yiruc'on-ka ren, can nuc'on-ka chuka' ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Xa c'o jun winak ri can jabel nuc'oxaj rutzij ri Dios, y romari' nuc'on-ka rech ri jun ri nuk'alajij ri ni'ix che roma ri Dios; ri nibano quiri', can junan ruq'uiexel xtiyo'x che riq'uin ri nitzijon rutzij ri Dios. Y quiri' chuka' ri winak ri utz nutzu' jun ri can choj ruc'aslen chech ri Dios y romari' can niquicot nuc'ul rech; ri nibano quiri', can junan ruq'uiexel xtiyo'x che riq'uin ri can choj ruc'aslen chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Y ri winak ri utz yerutzu' ri manak oc quik'ij roma ja ren jinquitzeklebej, can ketzij nin-ij chiwe; más que xe ta oc juba' tef ya' nuya' chique, can c'o ruq'uiexel xtiyo'x che romari'. Quiri' ri tzij ri xeru'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Y cuando ri Jesús xuq'uis rubixic chique ri cablajuj ru-discípulos anchique samaj ri ne'quibana', xbe chuka' raja' pa ch'aka chic tenemit ri jec'o chiri' pa rech-ulef Israel, chi nuc'ut y nutzijoj rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri samaj ri nu'on ri Jesucristo xna'ex roma ri Juan Bautista cuando c'o chiri' pa cárcel, y raja' xerutak-e ca'i' ru-discípulos riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Ri Juan xu'ij-e chique ri ru-discípulos chi tiquic'utuj che Jesús: ¿Can ja ret ri Cristo ri can xtipe-wi? ¿O nakayobej na chic jun? xebecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Y ri Jesús xu'ij chique ri ca'i' ru-discípulos ri Juan: Quixtzolaj y titzijoj che ronojel ri xitzu' y ri xic'oxaj-e wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Itzijoj che chi ri moy yetiquier yetzu'n, ri winak ri yejetz'ma'y yebin, can yebin-e utz, y ri winak ri c'o ri itzel yabil lepra chiquij, yec'achoj. Titzijoj chuka' che chi ri winak ri man yec'oxan ta, cami yec'oxan yan; ri caminaki' yec'astaj, y ri winak ri c'o necesidad pa cánima chech ri Dios, nintzijoj ri utzilaj rutzij ri Dios chique. ");
INSERT INTO cakNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Can ti'ij chuka' che chi jun winak anche'l raja', ri can ruyo'n ránima wiq'uin y can manak yirumalij can, can tiquicot roma c'o xtuch'ec chirij chi quiri' rubanon. Quiri' x-ix-e chique ri ca'i' discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Y cuando reje' xebe, ri Jesús xeru'ij utzilaj tak tzij chirij ri Juan chiquiwech ri winak ri jec'o chiri'. Y quiere' xeru'ij ri Jesús chique: ¿Anchique ri xbe'itzu' rix chiri' pa tz'iran rech-ulef? ¿Xitzu' como rix jun achi chiri', ri anche'l aj, ri nibe quiela' nibe quiela' pa ruk'a' ri quiek'ik'? ");
INSERT INTO cakNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Anchique ri xbe'itzu' rix chiri'? ¿Xitzu' como rix jun achi ri jabel tak tziak jerucusan? Man quiri' ta. Ri achi'a' ri niquicusaj tziak quiri', pa tak cocho reyes yec'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Pero anchique ri xbe'itzu' rix chiri' pa tz'iran rech-ulef? ¿Xitzu' como jun achi ri nuk'alajij ri bin che roma ri Dios? Ja'. Ri achi ri xitzu' chiri' can ja-wi ri' rusamaj. Pero can c'o chuka' jun chic samaj ri yo'n che, y ri' más nim. ");
INSERT INTO cakNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Roma can chirij ri Juan nich'o'n-wi ri Dios chupa rutzij ri tz'iban can, cuando nu'ij: Ren xtintak jun achi na'ey, chi nunaba' ri bey anchi' xtapon-wi ri Cristo. Quiri' nu'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Y tic'oxaj utz ri xtin-ij chiwe cami: Je q'uiy achi'a' ri xquik'alajij rutzij ri Dios ri je-alaxinak chech-ulef, pero man jun ri c'o ta más ruk'ij chech ri Juan Bautista. Can nim-wi ruk'ij raja'. Pero cami, can conojel ri ye'an gobernar roma ri Dios, can más c'o quik'ij. Y ri más manak ruk'ij chique reje', más c'o ruk'ij chech ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Y desde que xutz'om-pe samaj ri Juan Bautista c'a cami, ri winak yalan niquijo' ye'oc quiq'uin ri ye'an gobernar roma ri Dios, can niquimajla-qui' chi ye'oc, y ja ri can niquitaj quik'ij y riq'uin ronojel cánima niquirayij ye'oc, jari' ri xquie'oc. ");
INSERT INTO cakNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Conojel ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can, can c'o xqui'ij can chirij ri ru-gobierno ri Dios. Y quiri' chuka' bin can chupa ri ru-ley ri Moisés. Y c'aja' cuando xpe ri Juan, xbanataj-wi ri bin can chirij ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Xa rix ninimaj o man ninimaj ta, pero ren nin-ij chiwe chi cuando rutzij ri Dios ri tz'iban can nu'ij chi nipe ri Elías, xa chirij ri Juan nich'o'n-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","¡Ri c'o ruxiquin, can tuc'oxaj ri xin-ij! ");
INSERT INTO cakNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Anchok quiq'uin je junan-wi ri winak richi ri tiempo re'? Ri winak re' can je junan quiq'uin ri ac'uala' ri yec'ue' pa tak bey y yesiq'uin yech'o'n chiquiwech cuando ye'tz'an. ");
INSERT INTO cakNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ri ac'uala' ri' niqui'ij: Xkak'ojmaj ka-flautas chiwech y man xixxajo ta. Xkabixaj bix richi bis chiwech y man xixok' ta. Quiri' niqui'ij ri ac'uala' chupa ri atz'anen. Y je quiri' ri winak chi ri tiempo re', man jun ri nika chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Roma cuando xoka ri Juan Bautista, raja' manak nutaj pan ni man nukum ta chuka' ruya'al-uva, y rix ni'ij chi raja' c'o itzel espíritu riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Y cami xinoka ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, nintaj pan y ninkum chuka' ruya'al-uva, y rix ni'ij chi xe wa'in ninjo', y ni'ij chuka' chi jin jun k'abarel, jin qui-amigo ri moloy tak impuestos y jin qui-amigo ri winak aj-mac. Pero ri runo'j (runa'oj) ri Dios can k'alaj pa quic'aslen ri winak ri yeniman richi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jec'o tenemit anchi' xe'an-wi más q'uiy milagros roma ri Jesús. Pero ri winak ri jec'o chupa ri tenemit ri' man xquijo' ta xquiya' can quimac y man xqui'en ta ri nrojo' ri Dios. Romari' ri Jesús q'uiy ex xu'ij chiquij. ");
INSERT INTO cakNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Raja' xu'ij: Juya' (Juyu') quiwech ri jec'o pa tenemit Corazín y chuka' juya' (juyu') quiwech ri jec'o pa tenemit Betsaida, roma can q'uiy milagros xe'an chiquiwech y man xquinimaj ta rutzij ri Dios. Roma xa ta ja pa tak tenemit Tiro y Sidón xe'an ta ri milagros re', ri winak chi ri ca'i' tenemit ri' xquiya' yan ta can quimac y niqui'en yan ta ri nrojo' ri Dios, quicusalo'n ta chic tziak chi bis, y quiyo'n ta chic chaj chiquij, chi quiri' nitz'et chi yebison roma can nim ri mac ri quibanon. ");
INSERT INTO cakNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Pero ren nin-ij chiwe chi cuando xtapon ri k'ij chi xti'an juzgar ri rech-ulef roma ri Dios, ri jec'o pa tenemit Corazín y ri jec'o pa Betsaida can más castigo xtika pa quiwi', que chiquiwech ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Y ri jec'o pa tenemit Capernaum can niquinojij chi yebe chicaj riq'uin ri Dios y can yalan quik'ij xtiyo'x, pero xa man quiri' ta. Xa xtikases quik'ij, roma xa c'a chupa ri lugar chi castigo xquiebeka-wi. Roma xa ta ronojel ri milagros ri x-an chiquiwech reje', jari' ta x-an chiquiwech ri aj-Sodoma, xquinimaj ta y man ta xeq'uis. Y ri tenemit ri' c'a c'o ta chupa ri k'ij re'. ");
INSERT INTO cakNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Pero cuando xtapon ri k'ij chi xti'an juzgar ri rech-ulef roma ri Dios, ren nin-ij chiwe chi ja ri jec'o pa tenemit Capernaum ri más castigo xtika pa quiwi', que chiquiwech ri aj-Sodoma. ");
INSERT INTO cakNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Y chupa ri tiempo ri' ri Jesús xu'ij: Matiox ninya' chawe Nata' Dios, ret ri jat Rajaf ri rocaj y ri rech-ulef, roma man xak'alajij ta ri utzilaj atzij chiquiwech ri winak ri can niquina' chi can q'uiy quieta'n. Xa ja chiquiwech ri winak manak más quieta'n xak'alajij ri utzilaj atzij. ");
INSERT INTO cakNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Can quiri' Nata' Dios, roma jari' ri najo' ret, xcha' ri Jesús pa ru-oración. ");
INSERT INTO cakNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Y c'ajari' xu'ij: Ri Nata' Dios, can ronojel ruyo'n-pe pa nuk'a'. Y man jun chic etamayon jin ancu'x (anchique) ren, xe ri Nata'. Y man jun chuka' etamayon ancu'x (anchique) ri Nata', xe ren ri Ralc'ual jin-etamayon, y ri winak anchok che xtinjo' xtink'alajij-wi ren, xtuna'ej ancu'x (anchique) ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quixampe wiq'uin chi'iwonojel rix ri yalan jix-cosinak roma can itijon ik'ij chi nicanoj ri Dios y man iwilon ta, y chuka' yalan al ri eka'n (aka'n) kajinak chiwij, roma ja ren xquibano chiwe chi jixuxlan chech ronojel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Y ja ri nu-yugo ren tic'uaj, roma can más fácil chi nic'uax, y ri eka'n (aka'n) ri xtinya' ren chiwij man al ta. Titzu' ri c'aslen ri nuc'uan ren, can utz oc nuno'j (nuna'oj) quiq'uin conojel y co'l oc nuk'ij nubanon-ka. Y can quiri' tibana' rix. Can tic'uaj ri nu-yugo y quiri' ri iwánima can xtiril uxlanen, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chuka' chupa ri tiempo ri', pa jun k'ij chi uxlanen, ri Jesús y ri ru-discípulos je-benak pa jun ulef ri ticon trigo chech. Y ri discípulos c'o rech ri trigo yequich'up-e y niquitaj, roma ninum quipa. ");
INSERT INTO cakNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Y xetz'et-pe coma ri achi'a' fariseos, y ja xqui'ij che ri Jesús: Quie'atzu' la a-discípulos roma man utz ta ri niqui'en. Can man utz ta chi yesamaj chupa jun k'ij chi uxlanen, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Pero ri Jesús xu'ij chique: ¿Manak como itz'eton ri tz'iban can chirij ri xu'on ri David y ri je raxbil, chupa ri ojer can tiempo, cuando xnum quipa y manak quiway? ");
INSERT INTO cakNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ri David xberucanoj wey pa rocho ri Dios, y can ja ri lok'olaj tak pan ri xbeyo'x-pe che. Raja' xutaj ri pan y chuka' xuya' chique ri je-benak riq'uin; pero man mac ta ri xqui'en, más que ri pan ri' xe ri sacerdotes c'o modo yetijo. ");
INSERT INTO cakNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿O manak como itz'eton ri nu'ij chupa ri ley ri xuya' ri Dios che ri Moisés? Chiri' nu'ij chi ri sacerdotes can yesamaj-wi pa rocho ri Dios ri k'ij chi uxlanen y reje' man mac ta niqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Y ri' roma ri rocho ri Dios can c'o-wi ruk'ij. Pero cami, rix nitzu' Jun ri c'o más ruk'ij chech ri rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Y rix man ta xi'ij chi mac ri xqui'en ri nu-discípulos, xa ta iweta'n anchique ntel chi tzij rutzij ri Dios cuando nu'ij: Ren más nika chinuech chi nijoyowaj quiwech ri winak, que chech ri chicop ri ye'isuj chinuech. Quiri' nu'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Can ja ren ri jin-kajinak-pe chicaj y xinalex chi'icojol jin Rajaf ri k'ij chi uxlanen, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Y cuando ri Jesús y ri ru-discípulos xetzolaj-pe, xebe pa sinagoga, ri jay anchi' niquimol-wi-qui' ri winak chi niquic'oxaj rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Y chiquicojol ri winak ri quimolon-qui', c'o jun achi chaki'j jun ruk'a'. Y ri winak ri niquijo' niquisujuj ri Jesús roma ri tzij ri yeru'ij, xquic'utuj che: ¿Utz como chi nic'achojrises jun yawa' pa jun k'ij chi uxlanen? ");
INSERT INTO cakNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Pero ri Jesús xu'ij chique: C'o ta jun chiwe rix ri c'o ta jun ru-oveja ri nitzak ta pa jun jul chupa jun k'ij chi uxlanen, ¿nuya' como lugar chi nic'ue' can chiri'? Manak nu'on quiri'. Xa can nulesaj-pe ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Pero jun winak can más nim rakalen chech jun oveja, romari' can nuc'ul ni'an ri utz che jun winak pa jun k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","C'ajari' ri Jesús xu'ij che ri achi ri chaki'j jun ruk'a': Tayuku' la ak'a'. Y ri achi can xe xuyuk ri ruk'a', can ja' utz xu'on-ka, y can anche'l ri jun chic ruk'a', can quiri' xu'on can. ");
INSERT INTO cakNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Y ri achi'a' fariseos can xe xquitzu' can ri', xebe y xbequimolo-qui' chi niquinojij anchique niqui'en, roma niquijo' niquicamisaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Cuando ri Jesús xuna'ej ri niquinojij chirij, xel-e chiri'. Y can je q'uiy winak ri xetzekleben richi, y conojel yawa'i' yec'achoj can roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Y can yalan nuchelebej chique conojel reje' chi can man tiquitzijoj chi raja' xc'achojrisan quichi. ");
INSERT INTO cakNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Chi quiri' can nibanataj ri xuk'alajij ri Dios che ri Isaías, ri jun rusamajel ri xc'ue' ojer can. Ri tz'iban can, nu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Jare' ri Nusamajel ri nucha'on. Ren yalan ninjo' raja'; can niquicot-wi wánima riq'uin. Can xtinya-pe chuka' nu-Espíritu pa ruwi', y raja' xtuk'alajij chiquiwech ri man quieta'n ta nuech anchique roma nic'atzin jun c'aslen choj. ");
INSERT INTO cakNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Manak xtu'on ayowal, manak xtisiq'uin chi nich'o'n roma ayowal, ni man xtuya' ta ka rutzijol raja' mismo chiquiwech winak pa tak bey. ");
INSERT INTO cakNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Y más que ri ruc'aslen jun winak anche'l ta chic jun aj ri k'ajinak chic juba', raja' man xtu'on ta che chi nik'aj jumul. Chuka' xa ri ruc'aslen jun winak anche'l ta jun luz ri xe chic sib nuya', raja' manak xtuchup. Y quiri' xtu'on-apo, c'a xtapon ri k'ij chi raja' xtich'acon y pa ruchojmil xtu'on gobernar. ");
INSERT INTO cakNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Y ri winak ri man jani quieta'n nuech, riq'uin raja' xtiquiya-wi cánima chi yerucol. ");
INSERT INTO cakNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Y c'o jun achi moy y man nitiquier ta nich'o'n xc'uax-apo chech ri Jesús, y ri achi ri' quiri' rubanon roma c'o jun itzel espíritu riq'uin. Y ri Jesús xulesaj ri itzel espíritu ri', y xu'on che ri achi chi xtiquier xtzu'n y xch'o'n. ");
INSERT INTO cakNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Y cuando ri winak xquitzu' ri xbanataj, can xsatz quino'j (xsach quic'u'x) y niqui'ij chiquiwech: ¿Man ja' ta como re' ri Cristo ri ru-familia can ri David ri kayoben? ");
INSERT INTO cakNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Pero cuando ri achi'a' fariseos xquic'oxaj ri niqui'ij ri winak chirij ri Jesús, ja xqui'ij: Ri Jesús yerulesaj itzel tak espíritus pero xa roma c'o ri ruchuk'a' ri Beelzebú riq'uin, ri quijawal ri itzel tak espíritus, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Y ri Jesús can reta'n-wi ri niquinojij ri achi'a' fariseos, romari' xu'ij chique: Xa ta ri winak chi jun rech-ulef man junan ta yenojin y ca'i' quiwech niqui'en-ka, nipe ayowal chiquicojol; re' man utz ta, roma man xquielayoj ta xquiec'ue' junan chech-ulef. Y quiri' chuka' jun tenemit o pa jun jay, xa jalajoj quiwech niqui'en-ka y niquijach-ka-qui', can manak chic xquiec'ue' junan chech-ulef, xa xquieq'uis. ");
INSERT INTO cakNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Y quiri' chuka' ri Satanás, xa yerulesaj ri can je rusamajel-wi raja', ri' ntel chi tzij chi xa ruyon raja' nukotaj-e-ri' y chirij raja' mismo nu'on-wi ayowal. Y xa quiri' nu'on, ruyon nic'ue' can y ch'anin nitzak. ");
INSERT INTO cakNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Rix ni'ij chi ren pa rubi' ri Beelzebú yenlesaj ri itzel tak espíritus, y xa quiri' ¿anchique ni'ij chiquij ri yetzekleben iwichi? ¿Ancu'x (Anchique) xyo'n uchuk'a' chique reje' chi yetiquier yequilesaj itzel tak espíritus chuka'? Romari', can ja' ri niqui'en reje' nuk'alajij chi rix man ja' ta ri ye'ibij. ");
INSERT INTO cakNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ren yitiquier yenlesaj ri itzel tak espíritus roma can ja ru-Espíritu ri Dios c'o wiq'uin. Romari' titemaj chi ri ru-gobierno ri Dios c'o yan chi'icojol cami. ");
INSERT INTO cakNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Y ri nrojo' nu'on elak' pa rocho jun achi ri can yalan ruchuk'a'; na'ey tuxima', c'ajari' c'o modo nucanoj-e ronojel ri nrojo' yeruc'uaj. ");
INSERT INTO cakNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jun ri man wiq'uin ta ren nisamaj-wi, xa chuij ren nisamaj-wi. Y jun ri man nito'n ta wichi, xa jari' ri niyuju ronojel ri yenben ren. ");
INSERT INTO cakNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Y romari' ren nin-ij chiwe chi ri mac y ri itzel tak tzij ri yequi'ij ri winak chirij ri Dios, can yecoch'otaj-wi (yecuyutaj-wi). Pero jun ri nu'ij itzel tzij chirij ri Espíritu Santo, can manak chic xquiecoch'otaj (xquiecuyutaj) rumac. ");
INSERT INTO cakNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Y xabachique (xama'anchique) winak ri can c'o itzel tzij yeru'ij chuij ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can nicoch'otaj (nicuyutaj) rumac. Pero ri yeru'ij itzel tak tzij chirij ri Espíritu Santo, can manak-wi xticoch'otaj (xticuyutaj) rumac, ni cami ni ri chakawech apo. ");
INSERT INTO cakNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Roma ri rech ri nuya' jun che', nina'ex xa utz o man utz ta. Jun che' ri can utz, can nuya' utzilaj tak rech, y jun che' ri xa man utz ta, chuka' ri rech ri yeruya' man je utz ta. ");
INSERT INTO cakNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Romari' rix ri jix anche'l itzel tak cumetz, ¿can jixtiquier como rix ni'ij ri utz, cuando xe ri itzel tak ex c'o pa iwánima? Roma jun winak can ja' ri c'o pa ránima ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun utzilaj winak can xe utzilaj ex ri xquieru'ij, roma xe utzilaj tak ex jec'o pa ránima. Pero jun winak ri man utz ta, can xe itzel tak ex ri xquieru'ij, roma xe itzel tak ex ri c'o pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y ren nin-ij chiwe chi chupa ri k'ij cuando xti'an juzgar ri rech-ulef roma ri Dios, conojel ri winak can xquie'an juzgar roma ronojel ri tzij manak quikalen ri xequi'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ri Dios xquieru'on juzgar ri winak roma ri tzij ri yequi'ij, y quiri' xtik'alajin xa je utz o man je utz ta chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Y jec'o chique ri maestros chi ri ley y chuka' achi'a' fariseos xech'o'n-apo che ri Jesús, y xqui'ij: Ret ri can jat Maestro, tabana' jun milagro chakawech, chi nakatzu' xa can ja-wi ri Dios takayon-pe awichi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Pero ri Jesús xu'ij chique: Ri winak chi ri tiempo re' yalan je itzel y man niquinimaj ta ri Dios, romari' niquijo' chi nin-en jun milagro chiquiwech chi jinquinimaj. Pero man ja' ta ri niquijo' reje' ri xtin-en. Xa can xe ri xbanataj riq'uin ri Jonás, ri jun achi ri xuk'alajij ri x-ix che roma ri Dios ojer can, xe ri' ri retal ri c'o can chique reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Roma anche'l ri Jonás xc'ue' oxi' k'ij y oxi' ak'a' chupa jun nimalaj quer, quiri' chuka' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xquic'ue' chuxe-ulef oxi' k'ij y oxi' ak'a'. ");
INSERT INTO cakNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Y cuando xtapon ri k'ij chi ye'an juzgar ri winak chi ri tiempo re', xquiec'astaj-pe ri winak aj-Nínive y xtiqui'ij chi can man utz ta xqui'en ri winak ri jec'o cami, roma man xquinimaj ta. Ri winak ri xec'ue' pa tenemit Nínive xe xquic'oxaj rutzij ri Dios ri xutzijoj ri Jonás chique, ja xquiya' can ri mac y xqui'en ri nrojo' ri Dios. Y cami jinc'o ren ri c'o más nuk'ij chech ri Jonás, y xa man jinquinimaj ta ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Y cuando xtapon chuka' ri k'ij chi ye'an juzgar ri winak chi ri tiempo re', xtic'astaj-pe ri jun reina ri aj-Sabá. Ri reina ri' xtu'ij chi can man utz ta xqui'en ri winak ri jec'o cami, roma man xquinimaj ta. Roma cuando xc'ase' ri jun reina ri', yalan naj xpe-wi chi xoruc'oxaj runo'j (runa'oj) ri Salomón, ri rey chi ri Israel. Y cami jinc'o ren ri c'o más nuk'ij chech ri rey Salomón ri xc'ue' ojer can, y xa man jinquinimaj ta ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Cuando c'o jun itzel espíritu ntel-e pa ránima jun winak, nucanoj anchi' nuxlan-wi pa tak lugar tz'iran y can chaki'j. Pero ri itzel espíritu ri' man nril ta ri uxlanen ri nucanoj. ");
INSERT INTO cakNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Romari' nunojij: Más utz yitzolaj chic pa ránima ri winak anchi' xinel-wi-pe, nicha'. Y cuando nitzolaj chic pe pa ránima ri winak anchi' elenak-wi-e, nril anche'l jun jay ri man jun c'o chupa, meson y banon can utz ru'onic. ");
INSERT INTO cakNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Y ri itzel espíritu re' yeruc'om-pe wuku' chic itzel tak espíritus ri más je itzel, y conojel ye'oc pa ránima ri winak. Y ri winak anchok riq'uin yebec'ue-wi ri itzel tak espíritus re', más peor nu'on ruc'aslen chech ri rubanon-pe na'ey. Quiri' chuka' xtibanataj quiq'uin ri winak ri man utz ta quic'aslen, ri jec'o cami. ");
INSERT INTO cakNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Y ri Jesús c'a nich'o'n quiq'uin ri winak cuando xapon ri rute' y ri je rach'alal. Reje' niquijo' yech'o'n riq'uin, pero man xe'apon ta apo c'a riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Y c'o jun ri xu'ij-apo che ri Jesús: Ri ate' y ri awach'alal jatquiyoben chojay; niquijo' yech'o'n awiq'uin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Pero ri Jesús xu'ij che ri x-in-apo quiri' che: ¿Ancu'x (Anchique) ri nte' y ri je wach'alal na'ij ret? ");
INSERT INTO cakNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Y ri Jesús xeruc'ut-apo ri ru-discípulos y xu'ij: Ja reje' ri je nte' y wach'alal. ");
INSERT INTO cakNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Roma can conojel ri yebano ri nrojo' ri Nata' Dios c'o chicaj, ja reje' ri nte', wana' y wach'alal, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupa ri k'ij ri' ri Jesús y ri ru-discípulos xe'el-e pa jay y ri Jesús xbech'oquie' chuchi-ya'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y can q'uiy winak xquimol-apo-qui' riq'uin. Romari' raja' xoc-apo pa jun canoa y xch'oquie-ka chupa y nutzijoj-pe rutzij ri Dios chique; y reje' xec'ue' can chuchi-ya' niquic'oxaj-apo ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Raja' q'uiy ex nuc'ut chiquiwech riq'uin ejemplos. Y quiere' nu'ij chique: C'o jun achi ri xbetico. ");
INSERT INTO cakNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Y cuando ri achi nutic ri ija'tz', juba' che ri ija'tz' pa bey xeka-wi. Y xepe ri chicop ri c'o quixic' ri yebe chicaj, xquitaj-e ri ija'tz' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Juba' chic che ri ija'tz' chiquicojol abaj xeka-wi y chiri' xa man q'uiy ta ri ulef c'o, romari' can ch'anin xe'el-pe roma man pim ta ri ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Pero cuando xpe ruchuk'a' ri k'ij, xemayamo'. Y roma xa man naj ta benak-ka quic'amal (quixe'), xechaki'j-ka jumul. ");
INSERT INTO cakNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Y juba' chic ija'tz' chiquicojol k'ayis ri c'o quiq'uixal xeka-wi. Y cuando xe'el-pe, xejik' chiquicojol ri q'uix, roma ri q'uix ch'anin xeq'uiy. ");
INSERT INTO cakNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Pero ri ch'aka chic ija'tz' xeka pa jun utzilaj ulef, y ri tico'n jabel xeq'uiy y jabel xewachin. Roma jec'o ri xquiya' a treinta quiwech, jec'o xquiya' a sesenta y jec'o ri xquiya' a cien quiwech. ");
INSERT INTO cakNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ri c'o ruxiquin, can tuc'oxaj ri xin-ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Y ri discípulos xebe-apo riq'uin ri Jesús y xqui'ij che: ¿Anchique roma riq'uin ejemplos xach'o'n-wi chiquiwech ri winak? ");
INSERT INTO cakNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Y ri Jesús xu'ij chique: Man jun mej (bey) can ta k'alajin utz anchique modo nu'on gobernar ri Dios, pero chiwe rix can yo'n-wi lugar chi nina'ej ronojel ri'. Pero ri winak ri man jinquinimaj ta, riq'uin ejemplos yich'o'n-wi chique, roma chiquiwech reje' can manak-wi xtik'alajix. ");
INSERT INTO cakNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Roma ri can c'o ruyacon pa ránima, can xtiyo'x más che y can q'uiy xtic'ue' riq'uin. Pero ri xa man q'uiy ta c'o riq'uin, can xtimaj che ri juba' oc ri c'o riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Romari' ren yencusaj ejemplos cuando yich'o'n chique. Roma can man niquijo' ta niqui'en entender, más que can niquitzu' y niquic'oxaj. ");
INSERT INTO cakNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Quiere' nibanataj ri tz'iban can roma ri Isaías, ri jun achi ri xuk'alajij rutzij ri Dios ojer can. Y quiere' rutz'iban can raja': Rix, xe quiri' xtic'oxaj y manak xtiben entender ri xtic'oxaj. Rix xe xquixtzu'n y manak xtitzu' utz ri nitzu'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Roma ri cánima ri winak re' xa can cof rubanon, y can man ntoc ta pa quixiquin ri ni'ix chique. Reje' can anche'l je moy niqui'en roma man niquijo' ta yetzu'n. Can man jun anchique niquijo', can man niquijo' ta niquic'oxaj ri ni'ix chique; can cof quibanon che cánima y man niquijo' ta niqui'en entender. Can man niquijo' ta niquiya' can ri mac y niqui'en ri ninjo' ren chi ninjal quic'aslen. Quiri' nu'ij ri Dios, rutz'iban can ri Isaías. ");
INSERT INTO cakNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Pero rix nu-discípulos, can jabel quixquicot, roma rix can jixtiquier jixtzu'n jabel. Chuka' can jixc'oxan-wi jabel. ");
INSERT INTO cakNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Roma can nin-ij chiwe, chi je q'uiy achi'a' ri xquik'alajij rutzij ri Dios y utzilaj tak winak xec'ue' ojer can, ri yalan xquirayij xquitzu' ri nitzu' rix cami, pero manak xquitzu'. Y chuka' yalan xquijo' xquic'oxaj ri nic'oxaj rix cami, pero man xquic'oxaj ta. ");
INSERT INTO cakNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Y ri Jesús xu'ij chique: Tic'oxaj anchique nu'ij ri ejemplo ri nich'o'n chirij ri xberutica' ija'tz'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ri ija'tz' ri xeka can pa bey, jari' rutzij ri Dios ri nic'oxex coma ri winak y nich'o'n chirij ri ru-gobierno ri Dios. Pero ri winak ri' man niquijo' ta niquic'on-ka ri tzij ri' pa cánima. Romari' ri itzel noka y norulesaj ri tzij ri xtic-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ri ija'tz' ri xeka can chiquicojol tak abaj, jari' ri rutzij ri Dios ri nic'oxex coma ri winak. Ri winak ri' can yalan yequicot cuando niquic'on-ka rutzij ri Dios pa cánima. ");
INSERT INTO cakNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero roma can man naj ta nika-ka ruc'amal (ruxe') rutzij ri Dios pa cánima, can man yelayoj ta yequicot riq'uin, xa jun jani' oc k'ij utz yec'ue' riq'uin ri Dios. Pero cuando yepe sufrimientos y itzel yetz'et roma quiniman rutzij ri Dios, yetzak ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Y ri ija'tz' ri xeka chiquicojol k'ayis ri c'o quiq'uixal, can nich'o'n-wi chirij rutzij ri Dios ri nic'oxex coma ri winak. Pero ri winak ri' xa ja ri nic'atzin chique k'ij-k'ij chech-ulef, xe ri' niquinataj; jec'o ch'aka chic ye'an engañar roma ri beyomel. Romari' rutzij ri Dios nijik' pa cánima. Ri winak ri' can manak xtiwachin utz rutzij ri Dios pa quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Pero ri ija'tz' ri xeka pa utzilaj ulef, can nich'o'n-wi chirij rutzij ri Dios ri nic'oxex coma ri winak. Ri winak ri' can niquic'on-wi-ka rutzij ri Dios y quic'aslen can niwachin-wi jabel, anche'l niqui'en ri tico'n. Roma c'o ija'tz' niquiya' a treinta quiwech, jec'o niquiya' a sesenta quiwech y jec'o can a cien quiwech niquiya'. Can quiri' nu'on quic'aslen ri winak ri niquic'on-ka rutzij ri Dios pa cánima, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Y ri Jesús xutzijoj jun chic ejemplo chiquiwech, y xu'ij: Ri ru-gobierno ri Dios can junan riq'uin ri xbanataj riq'uin jun achi ri xutic jun utzilaj ija'tz' pa rulef. ");
INSERT INTO cakNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Pero chak'a' cuando conojel winak yewer, xoka ru-enemigo ri rajaf ulef, xberutica' can rija'tz' jun k'ayis rubinan cizaña parui' ri trigo ri xtic yan can. Y xe xberu'ona' can ri', xbe. ");
INSERT INTO cakNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Pero cuando xebeq'uiy-pe ri tico'n y xuya-pe rech, c'ajari' xk'alajin-pe ri cizaña. ");
INSERT INTO cakNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Y ri rusamajel ri rajaf ri ulef xe'apon riq'uin y xbequi'ij che: Ri ija'tz' ri xatic pa awulef can ja ri utz. Pero cami c'o cizaña chucojol. ¿Anchi' c'a xpe-wi ri ija'tz' chi ri cizaña? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Y ri achi xu'ij chique ri rusamajel: Ri xbano quiere' chue, jun ri can itzel nitz'eto wichi. Y ri rusamajel xqui'ij che: ¿Najo' chi ne'kac'uku' ri cizaña? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Pero ri achi xu'ij chique ri rusamajel: Ni, manak modo nic'uk ri cizaña, roma man ninjo' ta chi yec'ukutaj chuka' ri trigo. ");
INSERT INTO cakNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tiya' na lugar che ri cizaña chi junan niq'uiy-pe riq'uin ri trigo, c'a xtapon na ri k'ij chi nic'ol ri trigo, roma cuando xtapon ri k'ij ri', ren xtin-ij chique ri samajel chi tiquimolo' na'ey ri cizaña y chi tak manojo tiquibana' che chi yeporox; c'ajari' tiquik'ata' ri trigo y tiquiyaca', xcha' ri achi. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Y ri Jesús xutzijoj jun chic ejemplo chiquiwech, y xu'ij: Ri ru-gobierno ri Dios can junan riq'uin ri ija'tz' chi mostaza ri nerutica' jun achi pa rulef. ");
INSERT INTO cakNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Roma más que ja ri ija'tz' chi ri mostaza ri más co'l oc, pero cuando niq'uiy, jari' ri más nim ntel chiquiwech ri ch'aka chic tico'n. Ri mostaza xa can anche'l jun che' titzu'n cuando niq'uiy. Romari' ri chicop ri c'o quixic' ri yebe chicaj ye'apon chiri' y niqui'en quisoc chuk'a', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xutzijoj jun chic ejemplo chiquiwech, y xu'ij chique: Ri ru-gobierno ri Dios can junan riq'uin ri levadura ri neruc'ama-pe jun ixok y nuya' chupa oxi' paj harina y ri levadura nuquiraj-ri' chupa ronojel, y quiri' chuka' xtu'on rutzij ri Dios, can xtuquiraj-ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Y jare' ri xu'ij ri Jesús chique ri winak xe quiq'uin ejemplos. Can ronojel ri xuc'ut chiquiwech ri winak ri', xe riq'uin ejemplos. ");
INSERT INTO cakNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Chi quiri' can nibanataj ri ru'in can jun achi ri xutzijoj rutzij ri Dios ojer can. Ri rusamajel ri Dios can quiere' rutz'iban can: Cuando ren xquich'o'n, xquiencusaj ejemplos. Q'uiy ex ri man je-k'alajin ta utz desde pa ruticribel pe ri rech-ulef, ri xquienk'alajij ren. Quiri' nu'ij ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Y cuando ri Jesús xeru'on-e despedir ri winak, raja' xtzolaj pa jay y ri ru-discípulos xebe-apo riq'uin y xqui'ij che: Roj nakajo' chi ret nak'alajij chakawech anchique ntel chi tzij ri ejemplo chirij ri trigo y ri cizaña. ");
INSERT INTO cakNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Y ri Jesús xuk'alajij ri ejemplo chiquiwech y xu'ij: Ri achi ri nutic ri utzilaj ija'tz', ja ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ri ulef anchi' xtic ri ija'tz', ja ri rech-ulef. Ri utzilaj ija'tz', ja ri je-banon gobernar roma ri Dios. Y ri cizaña, ja ri can je richi-wi ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Y ri jun ri xberutica' ri cizaña roma itzel nitz'eto, ja ri itzel. Ri k'ij cuando xtik'at ri trigo, jari' ri ruq'uisbel chi ri tiempo re', y ri yek'ato ri trigo ja ri ángeles. ");
INSERT INTO cakNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Y can anche'l ni'an riq'uin ri cizaña ye'leses-e y yeyo'x pa k'ak' chi yeporox, can quiri' chuka' xtibanataj pa ruq'uisbel chi ri tiempo re'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xquientak ri nu-ángeles chi yequimol conojel ri yebano itzel tak ex y ri niqui'en chique ch'aka chic chi yetzak pa mac. Roma ren man yenjo' ta ri winak ri' chiquicojol ri jec'o pa nu-gobierno. ");
INSERT INTO cakNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Y conojel ri xquiemol-e, xquiebeq'uiak can chupa ri nimalaj k'ak'; y c'a chiri' xquie'ok' y xtiquijach'ach'ej quey. ");
INSERT INTO cakNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Y ri winak ri can choj-wi rubanon quic'aslen chech ri Dios, can yalan quisakil xtiqui'en; can anche'l ri k'ij. Can xtik'alajin chi pa ru-gobierno ri Quitata' Dios jec'o-wi. Ri c'o ruxiquin can tuc'oxaj ri xin-ij. ");
INSERT INTO cakNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ri ru-gobierno ri Dios can junan riq'uin jun beyomel ri mukun can pa jun ulef, y xbewil-pe roma jun achi. Ri achi ri' xumuk chic can y yalan niquicot xtzolaj chirocho, xuc'ayij ronojel ex ri c'o riq'uin, c'ajari' xulok' ri ulef ri anchi' mukun-wi can ri beyomel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ri ru-gobierno ri Dios can junan riq'uin ri nu'on jun achi ri yerulok' y yeruc'ayij abaj ri ni'ix perlas chique. ");
INSERT INTO cakNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Cuando ri achi ri' nril jun perla ri yalan rajil ri nic'ayix, ch'anin nitzolaj chirocho y nuc'ayij ronojel ex ri c'o riq'uin, c'ajari' nibe y nulok' ri perla ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ri ru-gobierno ri Dios can junan riq'uin jun ya'l ri niyo'x-ka chupa ri mar y yerulesaj-pe ronojel quiwech quer. ");
INSERT INTO cakNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Y cuando ri ya'l nojinak chic quiq'uin ri quer, ja niquic'uaj chuchi-ya', y yech'oquie-ka chi yequicha'. Ri quer je utz yequic'on can pa tak chaquech, pero ri man je utz ta xa yetorix-e. ");
INSERT INTO cakNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Quiri' ri xtibanataj pa ruq'uisbel che ri tiempo anchi' jojc'o-wi cami. Xquiepe ri ángeles y xquiequicha' ri winak ri man utz ta rubanon quic'aslen chiquicojol ri can choj rubanon quic'aslen chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Y ri winak ri man utz ta quic'aslen xquieq'uiak chupa ri nimalaj k'ak' coma ri ángeles y c'a chiri' xquie'ok' y xtiquijach'ach'ej quey. ");
INSERT INTO cakNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","C'ajari' ri Jesús xu'ij chique ri ru-discípulos: ¿Xiben entender re'? xcha' chique. Y ri discípulos xqui'ij: Ja' Ajaf, xka'an entender, xecha-apo reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Y raja' xu'ij chique: Yalan utz chi cami xiben entender, roma rix can c'o yan iweta'n chirij ri ru-gobierno ri Dios, y chuka' iweta'n ri je-tz'iban can chupa rutzij ri Dios. Romari' rix can jix junan riq'uin jun rajaf-jay ri yeberulesaj-pe rubeyomal, ri can c'o yan tiempo je-yaquel y chuka' ri c'a juba' tiempo jec'o riq'uin, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Y cuando ri Jesús xu'ij yan ri ejemplos re', xuya' can ri lugar ri' y junan xbe quiq'uin ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Y xapon chupa ri tenemit anchi' xq'uiy-wi-pe raja' y xuc'ut rutzij ri Dios chiri' pa sinagoga, ri jay anchi' niquimol-wi-qui' ri winak ri aj-chiri', chi niquic'oxaj rutzij ri Dios. Y roma ri tzij ri yeru'ij, ri winak ri' can xsatz quino'j (xsach quic'u'x) y xqui'ij: ¿Anchique roma ri achi re' yalan runo'j (runa'oj), y nitiquier yeru'on milagros? ");
INSERT INTO cakNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","La' xa ja ralc'ual ri jun achi carpintero, y ri rute' xa ja ri jun ixok rubinan María, y ri rach'alal ja ri Jacobo, ri José, ri Simón y ri Judas. ");
INSERT INTO cakNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Y ri rana' chikacojol roj jec'o-wi. ¿Anchi' c'a xulesaj ronojel re'? yecha-ka chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Y romari' ri winak can man xquinimaj ta ri Jesús. Pero raja' xu'ij chique: Jun ri nuk'alajij ri ni'ix che roma ri Dios, xe ri winak pa rutenemit y ri jec'o pa rocho ri can man jun ruk'ij niqui'en che, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ri Jesús man q'uiy ta milagros xeru'on pa rutenemit, roma ri ruwinak xa man xquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupa ri tiempo ri', ri rey Herodes xuc'oxaj chi ri Jesús yalan rutzijol chiquicojol ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Y ri Herodes xu'ij chique ri rusamajel: Ri Jesús ri' xa ja ri Juan Bautista ri xc'astaj-pe chiquicojol ri caminaki'. Romari' can c'o ruchuk'a' chi q'uiy ri nitiquier yeru'on, xcha' ri Herodes chique. ");
INSERT INTO cakNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Roma ri rey Herodes quic'amon-ka-qui' riq'uin ri Herodías, y ri ixok ri' xa raxayil ri Felipe ri rach'alal ri Herodes. Y romari' ri Herodes xu'ij chi titz'om ri Juan, tiyo'x pa cárcel y tixime' che cadena. ");
INSERT INTO cakNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Quiri' xu'on ri Herodes che ri Juan, roma ri Juan xu'ij che: Man utz ta chi abanon-ka awaxayil che ri Herodías. ");
INSERT INTO cakNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Romari' ri Herodes can c'o ta nrojo' nucamisaj ri Juan, pero nuxi'j-ri' chiquiwech ri winak, roma reje' can quieta'n chi ri Juan Bautista can jun achi ri nuk'alajij ri nu'ij ri Dios che. ");
INSERT INTO cakNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Y chupa ri k'ij cuando ri Herodes xtzakon jun chic rujuna', raja' xu'on jun nimak'ej, y chupa ri nimak'ej ri' ri xten ral ri Herodías xxajo chiquiwech ri winak y chech ri Herodes, y ri Herodes can yalan xka chech. ");
INSERT INTO cakNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Y romari' ri Herodes xu'on jurar che ri ral ri Herodías chi xabachique (xama'anchique) ri nrojo', can xtuya-wi che. ");
INSERT INTO cakNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Pero ri xten xa xyo'x runo'j (runa'oj) roma ri rute', c'ajari' xu'ij che ri Herodes: Ren ninjo' chi ret naya' chue pa jun plato, ri rujolon ri Juan Bautista, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Y ri rey Herodes xbison-ka ránima romari', pero roma can rubanon yan jurar che ri xten chi can xtuya-wi che ri anchique nrojo' y roma chuka' xa can chiquiwech ri jec'o riq'uin chuchi' mesa xu'ij-wi, romari' raja' xu'ij chi tic'amer-pe rujolon ri Juan Bautista che ri xten ral ri Herodías. ");
INSERT INTO cakNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xutak rukupixic rukul ri Juan Bautista chiri' pa cárcel. ");
INSERT INTO cakNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Y ri rujolon xc'amer-pe pa jun plato y xyo'x che ri xten, y ri xten xberujacha' che ri rute'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Y ri ru-discípulos ri Juan xbequic'ama-pe ri ruch'acul chi xbequimuku'. Y chuka' xbequitzijoj che ri Jesús ronojel ri xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Y ri Jesús can xe xuc'oxaj ri xbanataj, xbe, y xoc-e pa jun canoa junan quiq'uin ri ru-discípulos y xk'ax juc'an chic ruchi-ya'; can naj xbe-wi, pa jun lugar anchi' manak winak. Pero ri winak xquina'ej anchi' xbe-wi, y xe'el-pe pa tak tenemit y chicakan xe'apon-wi chupa ri lugar anchi' napon-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Y cuando ri Jesús ja ntel-pe chupa ri canoa chiri' juc'an ruchi-ya', xutzu' chi xa can je q'uiy yan chic winak ri quiyoben, y raja' yalan xujoyowaj quiwech. Y ri yawa'i' ri jec'o chiquicojol ri winak ri', xec'achoj can roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Y cuando ya nika-ka ri k'ij, ri ru-discípulos xebe-apo riq'uin ri Jesús y xqui'ij che: Chupa ri lugar re' man jun winak jec'o y tarde chic; ta'ij chique ri winak chi quiebe pa tak cocoj tenemit ri jec'o-pe nakaj chi niquilok' quiway chiri', xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Pero ri Jesús xu'ij chique ru-discípulos: Man nic'atzin ta yebe chi ne'quicanoj ri xtiquitaj, tiya' quiway rix, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Y ri discípulos xqui'ij-apo: Roj xe wo'o' wey y ca'i' quer c'o kaq'uin, y re' man nu'on ta, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Pero ri Jesús xu'ij chique: Tic'ama-pe we'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Y chuka' xu'ij chique ri winak chi quiech'oquie-ka conojel parui' ri rex k'ayis. Y raja' xeruli'ej pa ruk'a' ri wo'o' wey y ri ca'i' quer, xtzu'n chicaj y xuya' matiox che ri Dios. Raja' xeruper y xuya' chique ri ru-discípulos, y reje' xquijach chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Can conojel xewa' utz y can utz xnoj quipa. Y c'a jec'o cablajuj chaquech ri xenoj riq'uin ri wey y quer ri xemol can. ");
INSERT INTO cakNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Conojel ri winak ri xetzuk jec'o la'k wo'o' mil xe ri achi'a', y jec'o-apo chuka' ixoki' y ac'uala' ri man xe'ajilex ta. ");
INSERT INTO cakNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Y ri Jesús can ja' xu'ij chique ri ru-discípulos chi quie'oc chupa ri canoa y quiena'ey-e c'a juc'an chic ruchi-ya'; roma raja' c'a nic'ue' can chi yeru'on despedir ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Y cuando xebe yan conojel ri winak, raja' xjote-e parui' jun juyu' chi nu'on orar. Y can ruyon c'o chiri' cuando xk'okumer-ka chech. ");
INSERT INTO cakNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Y ri canoa anchi' je-benak-wi ri discípulos pa nic'aj ya' benak yan, pero ri ruchuk'a' ri ya' man nuya' ta lugar chi nibin. Can yalan nu'on ri quiek'ik', romari' man nuya' ta chic lugar che ri canoa chi choj nibin chech. ");
INSERT INTO cakNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Y cuando ya nisakar-ka, ri Jesús benak chirakan parui' ri ya', chi napon yan quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Pero cuando ri discípulos xquitzu' chi c'o jun benak parui-ya', xsatz quino'j (xsach quic'u'x), romari' xqui'ij: ¡Titzu'! ¡Jun xibinel! xecha'. Y can riq'uin quichuk'a' xqui'ij quiri' roma yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Pero ri Jesús can ja' xch'o'n chique, y xu'ij: Man tixi'j-iwi'; tiya' iwánima wiq'uin. Ja ren ri Jesús, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Y ri Pedro can ja' xch'o'n-apo y xu'ij che ri Ajaf: Xa can ketzij ja ret, tabana' chue chi yitiquier yibin chuka' chiwakan parui' ri ya' y yibe-apo awiq'uin, xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Y ri Ajaf xu'ij-pe che: Catampe c'a. Y ri Pedro can ja' xka-ka pa ya' y nibin parui' ri ya' chi neruc'ulu-apo ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero cuando xutzu' chi can nim ruchuk'a' ri quiek'ik', xuxi'j-ri', y c'aja' xuna' xa ja nibe-ka chuxe' ya', romari' riq'uin ruchuk'a' xu'ij: ¡Ajaf, quinacolo'! ");
INSERT INTO cakNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Y ri Jesús can ch'anin xutz'om ri Pedro y xu'ij che: ¿Anchique roma man xaya' ta ronojel awánima wiq'uin? xuche'x ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cuando reje' xejote' yan apo chupa ri canoa, xtane-ka ruchuk'a' ri quiek'ik'. ");
INSERT INTO cakNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Y conojel ri je-benak chupa ri canoa xquiya' ruk'ij ri Jesús y xqui'ij che: Cami xkatzu' chi can ketzij ja ret ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Y reje' xek'ax parui' ri choy (ya') ri' y xe'apon pa Genesaret. ");
INSERT INTO cakNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Y cuando ri achi'a' chi ri lugar ri' xquitemaj rech chi ja ri Jesús xoka, reje' can ch'anin xquitak rutzijol pa ronojel lugar ri jec'o-pe chunakaj ri Genesaret, y ri winak xequic'amala-pe conojel ri yawa'i' ri jec'o quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Y ri yawa'i' re' can niquic'utuj favor che ri Jesús chi tuya' lugar chique chi niquitz'om más que xe ruchi-rutziak chi quiri' yec'achoj. Y conojel ri xquitz'om ruchi-rutziak ri Jesús xec'achoj riq'uin ri quiyabil. ");
INSERT INTO cakNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Y jec'o jujun achi'a' fariseos y jujun maestros chi ri ley je aj-Jerusalem xe'apon riq'uin ri Jesús y xqui'ij che: ");
INSERT INTO cakNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","¿Anchique roma ri a-discípulos man niqui'en ta chic anche'l bin can coma ri ojer tak winak? Roma ri a-discípulos ret manak niquich'aj quik'a' cuando yewa'. Can man niqui'en ta anche'l naka'an roj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Y ri Jesús chuka' xuc'utuj chique reje': Y rix chuka' ¿anchique roma xe ri qui'in can ri ojer tak winak ri niben, romari' man nijo' ta jixniman che ri Dios roma man niben ta ru-mandamiento? ");
INSERT INTO cakNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ri Dios nu'ij: Quie'abana' respetar ate-atata'. Y jun ri itzel yerutzu' rute-rutata', ticamises; can man tijoyowex rech. Quiri' ru'in can ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero rix xa man quiri' ta nic'ut. Rix xa ye'itijoj ri winak chi quiri' man yequito' ta ri quite-quitata'. Roma niqui'ij chique ri quite-quitata': Ren manak modo jixinto' roma ronojel ri c'o wiq'uin xa nusujun chic che ri Dios. Y roma quiri' niqui'ij, man yequito' ta ri quite-quitata', jari' ri nic'ut rix. ");
INSERT INTO cakNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Y roma quiri' ri nic'ut rix chiquiwech ri winak, can ja' ni'ij chique chi can man quiequi'en respetar quite-quitata'. Y roma rix xe ri quic'utun can ri ojer tak winak ri niben, romari' can man jun ruk'ij ibanon che ri ru-mandamiento ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Rix xa ca'i' ipalaj. Xa can utz rubixic rubanon can chiwij ri jun achi ri xuk'alajij rutzij ri Dios ri xubinaj Isaías. Raja' xutz'ibaj can ri xu'ij ri Dios che y quiere' nu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ri winak re' xe riq'uin ri quichi' niquiya' nuk'ij, pero pa cánima xa man quiri' ta, roma xa can naj c'o-wi cánima chi niquiya' nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Xa man jun nic'atzin-wi ri niqui'en cuando niquiya' nuk'ij, ronojel ri yequi'ij cuando yequitijoj ri winak, xa quino'j (quina'oj) achi'a' y niqui'ij chi can jari' ti'an. Quiri' rutz'iban can ri Isaías, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","C'ajari' ri Jesús xch'o'n-apo chique ri winak ri quimolon-apo-qui' chiri' y xu'ij chique: Tic'oxaj utz ri xtin-ij cami y tibana' entender. ");
INSERT INTO cakNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri nutz'iluj ránima jun winak man ja' ta ri ex ri yerutaj-ka. Ri nutz'iluj ránima jun winak ja ri itzel tak ex ri yeru'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Y ri discípulos xebe-apo riq'uin ri Jesús, y xqui'ij che: Ri achi'a' fariseos xcataj quiyowal roma ri xa'ij, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Pero raja' xu'ij chique ri ru-discípulos: Ri quitico'n reje' man xtic'ue' ta can, xa xtileses-e jumul. Roma xa man ja' ta ri Nata' c'o chicaj tiquiyon. ");
INSERT INTO cakNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Quie'iya' can. Reje' can moy quibanon riq'uin ri quieta'n, y yequic'uaj ch'aka chic moy. Y xa ri yeruc'uaj ri moy, xa moy chuka', junan xquiebetzak pa tak jul, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Y ri Pedro xu'ij che ri Jesús: Tak'alajij chakawech anchique ntel chi tzij ri xatzijoj chake. ");
INSERT INTO cakNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Y ri Jesús xu'ij: ¿Chuka' rix man xiben ta entender ri xin-ij? ");
INSERT INTO cakNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Man niben ta entender chi can man ja' ta ri nutaj-ka jun winak ri nutz'iluj ránima? Roma ronojel ri nutaj-ka xa chupa nika-wi-ka y c'ajari' nibe pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ri nutz'iluj ránima jun winak ja ri itzel tak ex ri yeru'ij, roma ronojel ri' xa pa ránima nalex-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Pa cánima ri winak yepe-wi ri itzel tak ex ri niquinojij. Chiri' nipe-wi ri banoj-camic. Chiri' nipe-wi chuka' cuando ri winak ri je-c'ulan y ri man je-c'ulan ta niquicanola-qui' chi niqui'en mac. Pa cánima chuka' nipe-wi cuando ye'elak', niquitz'ucula' tzij chiquij ch'aka chic, y itzel yech'o'n chiquij ch'aka chic. ");
INSERT INTO cakNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Y ronojel ri', jari' ri nitz'ilun ránima jun winak. Pero xa jun winak man nuch'aj ta ruk'a' y quiri' niwa-ka, can man jun anchique nu'on che; can manak nutz'iluj ránima. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Y ri Jesús junan quiq'uin ru-discípulos xel-e chiri', y xbe c'a pa jun lugar chiquinakaj ri tenemit quibinan Tiro Y Sidón. ");
INSERT INTO cakNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Y chiri' c'o jun ixok ru-familia can jun achi ri xubinaj Canaán. Ri ixok re' yalan nibison xoka riq'uin ri Jesús, y nuc'utuj favor che ri Jesús y can riq'uin ruchuk'a' nu'ij: Tajoyowaj nuech ret Ajaf, ru-familia can ri rey David. Quinato' roma ri wal-xten c'o jun itzel espíritu riq'uin, y can yalan nu'on sufrir pa ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero ri Jesús man xch'o'n ta apo che ri ixok. Y ri discípulos xebe-apo chunakaj ri Jesús y xqui'ij che: Tabana' che ri ixok re' chi tic'ue' can, roma can petenak chakij y can yalan nisiq'uin nich'o'n. ");
INSERT INTO cakNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Y ri Jesús xu'ij: Ren xitak-pe xe quichi ri winak israelitas ri man jec'o ta apo riq'uin ri Dios, roma quisatzon-qui' (quisachon-qui'), xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Can ja' xpe ri ixok y xoxuquie' chech ri Jesús, y xu'ij che: Ajaf, quinato', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Pero ri Jesús xu'ij che ri ixok: Ri ruyo'n-pe ri Dios man utz ta ninya' chique xabachique (xama'anchique). Anche'l quiway ri ac'uala' man utz ta nimaj chique chi niyo'x chique ri tz'i', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Pero ri ixok xu'ij: Ajaf, can ketzij-wi ri na'ij. Pero can jojtiquier chuka' nakasic'-apo juba' che ri ruyo'n-pe ri Dios, anche'l niqui'en ri tz'i', yequitijla' ri rupixc'al tak wey ri yequitzakla-ka ri cajaf cuando yewa' chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Y ri Jesús can ja' xu'ij che ri ixok: Can yalan ayo'n awánima wiq'uin. Can tibanataj c'a ri najo', xcha' ri Jesús. Y can chupa ri hora ri' ri itzel espíritu ri c'o riq'uin ri xten ral ri ixok ja xel-e. ");
INSERT INTO cakNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús y ri ru-discípulos xquiya' can ri lugar ri' y xe'apon chunakaj ri choy (ya') rubinan Galilea, xejote' parui' ri juyu' ri c'o chiri' y chiri' xbech'oquie-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Y can q'uiy winak xe'apon riq'uin, y jequic'uan-apo quiyawa'i'; jec'o ri yejetz'ma'y yebin, jec'o je moy, jec'o je mem, jec'o man utz ta quik'a' y jec'o ch'aka chic ri jun-wi chic rech yabil ntoc chique. Ri yawa'i' ri' xeyo'x-apo chech ri Jesús coma ri winak, y can conojel xec'achoj-e. ");
INSERT INTO cakNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Y roma ri xu'on ri Jesús quiq'uin ri yawa'i', ri winak can anchique la xquina', roma ri je mem, yech'o'n; ri man utz ta ri quik'a', xec'achoj; ri yejetz'ma'y yebin, can utz yebin; y ri moy yetzu'n. Romari' ri winak can xquiya' ruk'ij ri Dios chi ri Israel. ");
INSERT INTO cakNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Y ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: Yalan ninjoyowaj quiwech ri winak re', roma ja yan oxi' k'ij jec'o-pe wiq'uin y manak quiway. Y xa xquientak ta e chi tak cocho xe quiri' y man yewa' ta e, man utz ta; xa xquiebetzak pa tak bey roma manak je-waynak, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Y ri discípulos xqui'ij che ri Jesús: Chupa ri lugar re' manak winak. ¿C'o como anchi' ne'kila-wi-pe wey chi yekatzuk conojel ri winak re'? ");
INSERT INTO cakNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero ri Jesús xuc'utuj chique: ¿Jani' wey c'o iwiq'uin? xcha'. Y reje' xqui'ij: Xe wuku' wey y jujun oc quer, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Y ri Jesús xu'ij chique ri winak chi quiech'oquie-ka pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Y ja xeruli'ej ri wuku' wey y ri quer pa ruk'a' y xuya' matiox che ri Dios. C'ajari' xeruper y xuyala-e chique ri ru-discípulos y reje' xbequiya' chique conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Can conojel xewa' utz y can utz xnoj quipa. Y c'a c'o wuku' chaquech ri xenoj riq'uin ri wey y quer ri xemol can. ");
INSERT INTO cakNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Y ri winak ri xewa', xe ri achi'a' je quieji' mil, y jec'o chuka' ixoki' y ri ac'uala' ri xewa' man xe'ajilex ta. ");
INSERT INTO cakNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Y cuando ri Jesús xeru'on yan despedir ri winak, raja' junan quiq'uin ri ru-discípulos xe'oc-e pa canoa, xebe y xe'apon pa jun lugar rubinan Magdala. ");
INSERT INTO cakNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri achi'a' fariseos y ri achi'a' saduceos xe'apon riq'uin ri Jesús chi niquitojtobej y xqui'ij che chi tu'ona' jun milagro chicaj chi nuc'ut xa can ja-wi ri Dios takayon-pe richi. ");
INSERT INTO cakNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Pero ri Jesús xu'ij chique ri achi'a' ri': Cuando rix nitzu' chi can quiak quibanon ri ajawa' (mukul) chicaj, cuando c'aja' nika-ka ri k'ij, ni'ij chi utz k'ij neru'ona'. ");
INSERT INTO cakNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Y chuka' ri nimak'a' yan, cuando nitzu' chi ri rocaj mukul y quiak chuka' quibanon ri ajawa' (mukul), ni'ij: Cami nika job, jixcha-ka. Rix xa ca'i' ipalaj, roma can iweta'n anchique ri neru'ona-pe pa k'ij, cuando nitzu' ri rocaj. Pero man iweta'n ta nitzu' ri yebanataj y nu'ij anchique tiempo jojc'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri winak chi ri tiempo re' yalan je itzel y man niquinimaj ta ri Dios, romari' niquijo' chi nin-en jun milagro chiquiwech chi jinquinimaj. Pero man ja' ta ri niquijo' reje' ri xtibanataj. Xa can xe ri xbanataj riq'uin ri Jonás, ri jun achi ri xuk'alajij ri x-ix che roma ri Dios ojer can, xe ri' ri retal ri c'o can chique reje', xcha' ri Jesús, y ja xeruya' can ri achi'a' ri' y xbe junan quiq'uin ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Cuando ri Jesús y ri ru-discípulos xe'apon c'a juc'an ruchi-ya', c'ajari' ri discípulos xoka pa quiwi' chi manak wey quic'uan-e roma xa xquimestaj can. ");
INSERT INTO cakNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Y ri Jesús xu'ij chique ri ru-discípulos: Can tic'oxaj ri xtin-ij chiwe: Tibana' cuenta iwi' chech ri levadura quichi ri achi'a' fariseos y ri achi'a' saduceos, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Y roma quiri' xu'ij ri Jesús, ri ru-discípulos xqui'ij-ka chiquiwech: Raja' xu'ij quiri' chake roma manak xkac'om-pe kaway. ");
INSERT INTO cakNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero ri Jesús can reta'n-wi ri niquinojij ri ru-discípulos, xu'ij chique: ¿Anchique roma rix ninojij chi roma manak kaway xin-ij quiri'? Can man iyo'n ta utz iwánima wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿C'a man jani tiben entender ri xin-ij? ¿Man noka ta chic pa iwi' cuando xentzuk wo'o' mil achi'a' riq'uin ri wo'o' wey? ¿Can man noka ta chic pa iwi' jani' chaquech wey ri ximol can? ");
INSERT INTO cakNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Man noka ta chuka' pa iwi' cuando xentzuk ri quieji' mil achi'a' riq'uin ri wuku' wey y jani' chaquech wey ximol can? ");
INSERT INTO cakNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Anchique roma rix man xiben ta entender chi ren man xich'o'n ta chirij ri wey ri ximestaj can? Ri xin-ij ren chiwe, ja chi tibana' cuenta iwi' chech ri levadura quichi ri achi'a' fariseos y saduceos, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","C'ajari' ri discípulos xqui'en entender chi ri Jesús man ja' ta ri levadura ri nicuses riq'uin ri pan xunataj. Y xa ja' chi tiquibana' cuenta qui' chech ri niquic'ut ri achi'a' ri', roma xa man utz ta. ");
INSERT INTO cakNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Y ri Jesús junan quiq'uin ri ru-discípulos xapon pa jun lugar ri nakaj c'o che ri tenemit rubinan Cesarea chi ri Filipo; y xuc'utuj chique ri ru-discípulos: ¿Anchique niqui'ij ri winak chuij ren ri jin-kajinak-pe chicaj y xinalex chi'icojol; jin ancu'x (anchique) ren? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Y ri discípulos xqui'ij che ri Jesús: Jec'o ye'in chi ja ret ri Juan Bautista. Jec'o ch'aka chic niqui'ij chi ja ret ri Elías. Jec'o chuka' ri ye'in chi ja ret ri Jeremías o jun chic chique ri achi'a' ri xquik'alajij ri x-ix chique roma ri Dios ojer can, xecha' ri discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Y raja' xuc'utuj chique reje': Y rix ¿anchique ni'ij chuij? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Y ri Simón Pedro can ja' xu'ij che ri Jesús: Ja ret ri Cristo, Ralc'ual ri c'aslic Dios, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Y can xe xuc'oxaj quiri' ri Jesús, can ja' xu'ij: Ret Simón Pedro ralc'ual ri Jonás, can caquicot; roma ri c'aja' oc xa'ij, man winak ta x-in chawe, xa can ja ri Nata' Dios c'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Y ninjo' nin-ij chawe: Ret, Pedro abi'; y parui' ri abaj re' xtinpoba-wi nu-iglesia. Y ri iglesia can manak xtich'acataj roma ri camic y roma ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Can chawe ret xtinya-wi ri uchuk'a' chi najak ri puerta chiquiwech ri ye'oc quiq'uin ri ye'an gobernar roma ri Dios; romari' ronojel ri xtaxim o xtasol we' chech-ulef, can quiri' chuka' xti'an che chila' chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Y ri Jesús xu'ij chique ri ru-discípulos chi can man jun anchok che tiquitzijoj chi ja raja' ri Cristo ri takon-pe roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Desde ri tiempo ri' ri Jesús nuk'alajij chiquiwech ri ru-discípulos, chi can nibe na pa tenemit Jerusalem chi nuk'axaj q'uiy sufrimiento pa quik'a' ri rijilaj tak achi'a' ri c'o quik'ij, pa quik'a' ri nimalaj tak sacerdotes y chuka' pa quik'a' ri maestros chi ri ley; can xticamises, pero pa rox k'ij xtic'astaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Y cuando ri Pedro xuc'oxaj ri xu'ij ri Jesús, xuc'uaj juba' aparte y cof xch'o'n che ri Jesús y xu'ij: Man ta xtrojo' ri Dios chi xtac'ulumaj anche'l ri xa'ij-ka chawij ret Ajaf, xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pero cuando ri Jesús xuc'oxaj quiri', xutzalmayij-ri' y xu'ij che ri Pedro: Man cac'ue-pe wiq'uin ret Satanás, roma man utz ta ri nanojij. Ret jatoc jun ri xe nuk'at nubey. Roma ri nanojij ret xa can junan riq'uin ri niquinojij ri winak y man anche'l ta nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Y ri Jesús xch'o'n chique ri ch'aka chic ru-discípulos y xu'ij: Xa c'o jun nrojo' yirutzeklebej, can man tupokonaj-ri' nu'on sufrir, xa can tu'ona' anche'l can ruc'uan ru-cruz. Man tu'on ri nurayij raja'. Xa c'o jun nunojij nu'on quiri', can tipe wiq'uin y quirutzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Roma xa c'o jun ri yalan nrojo' ri ruc'aslen we' chech-ulef, man xtiril ta ruc'aslen ri manak xtiq'uis. Pero ri man nupokonaj ta ri', más que nicamises woma ren, can xtiril-wi ri c'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Roma, ¿anchique nuch'ec jun winak, xa nic'ue' ri beyomel richi ronojel ri rech-ulef riq'uin y xa man nicolotaj ta? Más que yalan ta beyomel c'o riq'uin ri winak, man nitiquier ta nulok' ri c'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Roma ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can xquipe chic jun mej (bey), y junan chic nuk'ij riq'uin ri Nata' y xquiepe chuka' ri nu-ángeles wiq'uin. Y ja xtinya' ruq'uiexel chique conojel, roma ronojel ri quibanon chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tic'oxaj na pe'; can ketzij ri nin-ij chiwe, chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, yipe riq'uin chic nuk'ij y c'o chic uchuk'a' pa nuk'a', y can jec'o jujun chiwe rix ri man xquiecom ta, c'a tiquitzu' na ri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Y cuando xk'ax yan waki' k'ij, ri Jesús xucha' ri Pedro, chuka' ri Jacobo y ri Juan ri cach'alal qui', chi quiri' xe ri je oxi' ri' xeruc'uaj c'a parui' jun juyu' nim. ");
INSERT INTO cakNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ri Jesús xjalataj rech chiquiwech ri je oxi' ru-discípulos. Ri rupalaj can xrapak'uj anche'l ri k'ij. Y chuka' ri rutziak can yalan sak xu'on, can anche'l luz. ");
INSERT INTO cakNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Y cuando ri je oxi' discípulos xquitzu', yetzijon yan chic riq'uin ri Jesús ri ca'i' achi'a' quibinan Moisés y Elías. Ri achi'a' ri' je rusamajel ri Dios ri xec'ue' ojer can tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Y ri Pedro xu'ij-apo che ri Jesús: Ajaf, we' utz kabanon. Xa ret najo', naka'an oxi' tak jay; jun awichi ret, jun richi ri Moisés y jun richi ri Elías. ");
INSERT INTO cakNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cuando ri Pedro c'a nitzijon-apo che ri Jesús, c'o jun ajawa' (mukul) can nich'ich'an xka-pe pa quiwi'. Y chupa ri ajawa' (mukul) ri', c'o Jun xch'o'n-pe y xu'ij: Jare' ri Walc'ual y yalan ninjo'; can niquicot wánima riq'uin. Can tic'oxaj ri nu'ij raja', xcha-pe ri Dios chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Y cuando ri je oxi' discípulos xquic'oxaj ri', xquikasaj-ka-qui' c'a chech-ulef. Y yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Y ri Jesús xbe-apo quiq'uin ri ru-discípulos, xerutz'om-ka y xu'ij chique: Quixcataj y man tixi'j-iwi', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Cuando ri discípulos xetzu'n chic apo, man jun chic xequitzu', xa can ruyon chic ri Jesús c'o can. ");
INSERT INTO cakNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Y cuando reje' je-xulan-pe chech ri juyu', ri Jesús xuchelebej chique ri ru-discípulos y xu'ij: Man jun anchok che titzijoj-wi ri xitzu'. Utz nitzijoj pero c'aja' cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xic'astaj yan pe chiquicojol ri caminaki', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ri discípulos can ja' xqui'ij che ri Jesús: Roj kabanon entender chi ja ret ri Cristo ri takon-pe roma ri Dios. ¿Pero anchique roma ri maestros chi ri ley niqui'ij chi ja ri Elías noka na'ey, c'ajari' noka ri Cristo? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Y ri Jesús xu'ij chique: Can ketzij-wi chi ri Elías nipe na'ey y noru'ona' ru'onic ronojel ri c'o. ");
INSERT INTO cakNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Pero ren can nin-ij chiwe chi ri Elías ri' xpe yan y man xquina'ej ta ancu'x (anchique) ri'. Xa yalan pokon xqui'en-e che. Can ronojel ri xquijo', can quiri' xqui'en che. Y can quiri' xtiqui'en chuka' chue ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xtin-en sufrir pa quik'a', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Y c'ajari' ri discípulos xqui'en entender chi ri Jesús chirij ri Juan Bautista xch'o'n-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Cuando ri Jesús y ri je oxi' ru-discípulos xe'apon-ka anchi' quimolon-qui' q'uiy winak, c'o jun achi xoka riq'uin ri Jesús y xoxuquie' chech. Ri achi xu'ij che ri Jesús: ");
INSERT INTO cakNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Ajaf, tajoyowaj rech ri walc'ual, roma raja' yalan nu'on sufrir pa ruk'a' ri ataque, ri yabil rubinan epilepsia, y can q'uiy mej (paj) tzakinak pa k'ak' y pa tak ya'. ");
INSERT INTO cakNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinc'om-pe chi xonya' chiquiwech ri a-discípulos, ninjo' chi nic'achoj ta coma, pero reje' man yetiquier ta niquilesaj-e ri yabil, xcha' ri achi. ");
INSERT INTO cakNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Y ri Jesús ja' xu'ij: Can man jun winak chupa ri tiempo re' ruyo'n ta juba' ránima riq'uin ri Dios. Xa conojel je-satzinak (je-sachinak). ¿Jani' tiempo ninojij rix chi xquic'ue' iwiq'uin? ¿Can jani' tiempo xquitiquier xquixincoch', ni'ij rix? Tic'ama-pe ri ala' we', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ri Jesús cof xch'o'n che ri itzel espíritu y xu'ij che chi tel-e riq'uin ri ala'. Y ri ala' can ja' xc'achoj. Xq'uis-e ri ruyabil ri hora ri', roma xel-e ri itzel espíritu. ");
INSERT INTO cakNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Y cuando ri Jesús y ri ru-discípulos quiyon chic jec'o, xepe reje' xquic'utuj che ri Jesús: ¿Anchique roma roj man xojtiquier ta xkalesaj-e ri itzel espíritu? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Y ri Jesús xu'ij chique: Man xixtiquier ta xilesaj roma can man iyo'n ta ronojel iwánima riq'uin ri Dios. Y can ketzij ri nin-ij chiwe: Xa niya' ta iwánima riq'uin ri Dios, más que xe juba' oc anche'l jun rija'tz' mostaza, ren nin-ij chi rix can jixtiquier ni'ij che ri jun juyu' re' chi tel-e we' y tik'ax pa jun chic lugar, y can xtik'ax-wi. Can ronojel-wi xquixtiquier xtiben, xa ta niya' juba' iwánima riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Pero ri jun rech espíritu re' ntel-e, xe riq'uin ayuno y oración, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Y cuando ri Jesús y ri ru-discípulos jec'o chic pa rech-ulef Galilea, xpe ri Jesús xu'ij chic chique ri ru-discípulos: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xquijach-wi pa quik'a' ri winak ri itzel yetz'eto wichi. ");
INSERT INTO cakNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Can xquicamises-wi; pero pa rox k'ij xquic'astaj-pe chiquicojol ri caminaki'. Y cuando ri discípulos xquic'oxaj ri xu'ij ri Jesús, can yalan xebison. ");
INSERT INTO cakNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Y cuando ri Jesús y ri ru-discípulos xe'apon pa tenemit Capernaum, ri yemolo mero chi nitoj ri impuesto chi ri rocho ri Dios, xe'apon chuka' riq'uin ri Pedro y xquic'utuj che: ¿Nutoj ri i-Maestro ri impuesto chi ri rocho ri Dios? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Y Pedro xu'ij: Ja', nutoj. Y cuando ri Pedro xapon pa jay, ja ri Jesús xbech'o'n-pe na'ey che y xu'ij: ¿Anchique nanojij ret Simón Pedro? ¿Ri reyes ri jec'o chech-ulef, anchok chique niquic'utuj-wi ri impuesto y contribuciones? ¿Chique ri quiwinak ka reje' o chique ri man je quiwinak ta? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Y ri Pedro xu'ij che ri Jesús: Ri reyes chique ri winak ri man je quiwinak ta niquic'utuj-wi, xcha'. Y ri Jesús can ja' xu'ij: Ja ri quiwinak ri manak niquitoj ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero xa man nakatoj ta, xa juba' yan chic man xtiqui'en ta entender anchique roma man nakatoj ta. Cami quie'abelesaj-pe quer pa ya'; y ri na'ey quer ri xtalesaj, tajaka' pa ruchi' y chiri' xtawil-wi ri mero chi natoj ri impuesto chi rocho ri Dios. Ri mero ri' nu'on chi natoj ri wichi ren y ri awichi ret, xcha' ri Jesús che ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Y ja' cuando ri discípulos xebe-apo riq'uin ri Jesús, y xquic'utuj che: Cuando xtoka ri k'ij chi ja ri Dios nibano gobernar, ¿ancu'x (anchique) ri más c'o ruk'ij xtic'ue' chake roj? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Y ri Jesús can ja' xroyoj jun ac'ual y xuya' pa quinic'ajal. ");
INSERT INTO cakNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Y raja' xu'ij chique ri ru-discípulos: Can ketzij ri nin-ij chiwe: Xa rix man nijal ta ri ino'j (ina'oj), xa man jixoc ta anche'l jun ac'ual, man xquixoc ta quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Xe ri co'l oc nuna-ka anche'l ri jun ac'ual re', jari' ri más nim ruk'ij xtic'ue' chiquicojol ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ri can jinruniman y can niquicot nuc'on-ka jun ac'ual anche'l re', man xe ta xtuc'on-ka ri ac'ual, xa can xquiruc'on-ka chuka' ren. ");
INSERT INTO cakNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Xa c'o ta jun co'l ri jinruniman y nipe ta jun chic winak y nu'on che ri jun ri' chi nika pa mac, man utz ta ri nu'on. Romari' ri winak ri nunojij nu'on quiri', más utz nu'on che xa ta nixim jun nim abaj chi quie'n chukul y ne'torix pa mar y tibe-ka c'a chuxe' ri ya'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Juya' (Juyu') quiwech ri winak ri jec'o chech-ulef, roma jec'o ri yebano chique chi niqui'en mac. Can c'o-wi ri quiri' niquic'ulumaj chech-ulef. Pero can juya' (juyu') rech ri winak ri nu'on che jun chic chi nu'on mac. ");
INSERT INTO cakNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Romari' xa jun ak'a' o jun awakan nibano chawe chi na'an mac, más utz nakupij y natorij-e. Roma más utz chi xe jun ak'a' o jun awakan c'o y jatoc chupa ri c'aslen ri man niq'uis ta, que chech ca'i' ak'a' y ca'i' awakan c'o y xa chi ronojel ach'acul jabetorix chupa ri castigo; chupa ri k'ak' ri man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Y chuka' xa jun chique ri awech nu'on chawe chi na'an mac, más utz nalesaj y natorij-e. Roma más utz chi xe jun awech c'o y jatoc chupa ri c'aslen ri man niq'uis ta, que chech ca'i' awech c'o y xa chi ronojel ach'acul jabetorix chupa ri castigo; chupa ri k'ak' ri man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Man tiben chique ri winak chi can man jun oc quik'ij, roma chiwech rix can je co'l oc. Roma ren nin-ij chiwe chi reje' jec'o ángeles ri yechajin quichi, y ri ángeles ri' can siempre jec'o-apo chicaj chech ri Nata' Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Y ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xipe chi yencanoj ri winak ri je-satzinak (je-sachinak) chupa ri mac chi yencol. ");
INSERT INTO cakNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Can tinojij utz ri xtin-ij chiwe. Xa jun achi jec'o ta cien ru-ovejas y nisatz (nisach) ta can jun, ¿man yeruya' ta can como juba' ri ch'aka chic ovejas y nibe pa tak k'ayis chucanoxic ri jun ri satzinak (sachinak) can? ");
INSERT INTO cakNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y más que ri achi ri' c'a jec'o na ri ch'aka chic ru-ovejas ri man xesatz (xesach) ta, can nin-ij chi raja' más niquicot ránima riq'uin ri jun ru-oveja xa nerila-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Can quiri' chuka' nibanataj riq'uin ri Itata' ri c'o chicaj, can man nurayij ta raja' chi nisatz (nisach) ta can jun winak chupa ri mac, más que can manak oc ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Xa c'o jun awach'alal c'o jun ex itzel ri nu'on chawe, ayon cabech'o'n che y ta'ij che ri xu'on chawe. Y xa ri awach'alal ri' nunimaj ri na'ij che, can k'alaj chi xach'ec, roma can utz nu'on ri ruc'aslen. ");
INSERT INTO cakNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Pero xa man jatrunimaj ta, quie'ac'uaj jun o je ca'i' chic awiq'uin, y chiquiwech reje' ta'ij che ri awach'alal que man utz ta ri xu'on chawe. Chi quiri' can je ca'i' o je oxi' ri jec'o-apo niquic'oxaj cuando nibanataj ronojel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Y xa ri awach'alal can man niniman ta, ta'ij chique conojel ri kach'alal ri niquimol-qui'. Y cuando bin chic che coma ri kach'alal y xa c'a man niniman ta, can man utz ta ri xu'on, y ti'ij che que man iwach'alal ta chic roma xa can anche'l jun winak ri man runiman ta ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Y can tinimaj ri nin-ij chiwe, ren ninya' can wuchuk'a' pa ik'a'. Y romari' ronojel ri xtixim o xtisol we' chech-ulef, can quiri' chuka' xti'an che chila' chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Chuka' nin-ij chiwe: Xa chech-ulef jec'o je ca'i' kach'alal ri can junan niquinojij chirij jun ex chi niquic'utuj che ri Dios pa oración, ri Nata' Dios ri c'o chicaj can xtuya-pe ri nic'utux che coma ri je ca'i' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Roma xabachi' (xama'anchi') quimolon-qui' je ca'i' o je oxi', xa can pa nubi' ren quimolon-wi-qui', can jinc'o ren pa quinic'ajal, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Y ri Pedro can ja' xbe-apo riq'uin ri Jesús y xu'ij che: Ajaf, xa jun wach'alal nu'on retzelal chue, ¿jani' mej (paj) utz nincoch' (nincuy) rumac? ¿Ja como ri wuku' mej (paj) utz nincoch' (nincuy) rumac? xcha' ri Pedro che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri Jesús xu'ij che ri Pedro: Ren man nin-ij ta chawe chi xe wuku' mej (paj) utz nacoch' (nacuy) rumac jun awach'alal ri nu'on retzelal chawe. Ren nin-ij chawe chi utz nacoch' (nacuy) setenta veces siete ri awach'alal. ");
INSERT INTO cakNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Roma riq'uin ri ru-gobierno ri Dios can nibanataj anche'l xbanataj riq'uin jun rey. Ri rey re' xrojo' xuna'ej jani' quic'as chiquijunal ri rusamajel. ");
INSERT INTO cakNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Y cuando ri rey ri' xtiquier-ka chi nuna'ej ri quic'as, c'o jun rusamajel xpobex chech y ri samajel re' c'o millones ruc'as. ");
INSERT INTO cakNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Y roma ri samajel ri' man nitiquier ta nutoj ruc'as, ri rey xu'ij chi tic'ayix ri samajel, junan quiec'ayix riq'uin ri raxayil y chuka' ri ralc'ual. Y chuka' can quiec'ayix ri ex richi, chi quiri' nitojtaj ri c'as. ");
INSERT INTO cakNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ri samajel can ja' xxuquie-ka pa ulef chech ri rey, y yalan nuc'utuj favor che. Ri samajel nu'ij che ri rey: Tabana' favor quinayobej juba' más. Ren can xtintoj chawe ronojel ri nuc'as, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Y ri rey ri ru-patrón ri samajel, can yalan xujoyowaj rech rusamajel ri yalan q'uiy ruc'as, romari' xucoch' (xucuy) riq'uin ruc'as y man jun anchique xu'on che. ");
INSERT INTO cakNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Pero cuando xel-pe ri samajel, xberuc'ulu-pe jun chic samajel ri c'o ruc'as rubanon riq'uin raja'. Ri c'as ri rubanon ri jun raxbil riq'uin, man anche'l ta ruc'as raja' riq'uin ri ru-patrón, ri jun achi re' xa juba' oc ruc'as rubanon, pero raja' xutz'om chukul ri raxbil y can ja' nujitz'aj rukul y nu'ij che: Tatojo-pe ri ac'as ri abanon wiq'uin, nicha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Y ri raxbil can ja' xxuquie-ka chech, y can nuc'utuj favor che, y nu'ij: Quinayobej chic juba' y ren xtintoj ronojel chawe, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Pero ri achi samajel ri c'o c'as banon riq'uin, man xka ta chech ri x-ix che y romari' xbesujun chirij chi nuya' pa cárcel, c'a tutojo' na ri c'as c'aja' xtel-pe pa cárcel. ");
INSERT INTO cakNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Y ri ch'aka chic samajel cuando xquitzu' ronojel ri xbanataj, can xbison-ka cánima. Y reje' xebe riq'uin ri rey ri qui-patrón y xbequitzijoj ronojel ri xu'on ri jun samajel riq'uin ri jun chic. ");
INSERT INTO cakNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Y ri rey xutak royoxic ri samajel ri man utz ta xu'on y xu'ij che: Ret, xa jat jun itzel nusamajel. Ren xincoch' (xincuy) ronojel ri nimalaj ac'as, roma can quiri' xac'utuj chue. ");
INSERT INTO cakNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Man ja' ta como ri' xc'atzin chuka' xa'an ta ret riq'uin ri awaxbil pa samaj, anche'l ri xin-en ren awiq'uin chi xinjoyowaj awech? ");
INSERT INTO cakNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y ri rey, ri qui-patrón ri samajel, roma xcataj ruyowal, xujach-e ri itzel rusamajel pa quik'a' ri achi'a' chi xquitz'apij pa cárcel, y chiri' xti'an castigar chi nu'on sufrir c'a titojtaj na can ronojel ruc'as. ");
INSERT INTO cakNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Can quiri' xtu'on ri Nata' Dios ri c'o chicaj iwiq'uin rix, xa man riq'uin ta ronojel iwánima nicoch' (nicuy) quimac ri iwach'alal cuando c'o itzel niqui'en chiwe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Y cuando ri Jesús xuq'uis rutzijoxic ri jun ejemplo, xbe y xuya' can ri lugar ri', ri rubinan Galilea. Raja' xbe c'a pa Judea, y xk'ax c'a juc'an chic ruchi' rakan-ya' Jordán. ");
INSERT INTO cakNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Raja' can yalan je q'uiy winak ri xetzekleben richi chiri', y jec'o chuka' ri xec'achoj roma. ");
INSERT INTO cakNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Y ja' jec'o jujun achi'a' fariseos ri xeloka riq'uin, chi niquitojtobej ri Jesús chi nitzak ta pa quik'a'. Y romari' xquic'utuj che: ¿Utz como chi jun achi nujach-ri' riq'uin ri raxayil roma xabachique (xama'anchique) ex? ");
INSERT INTO cakNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Pero ri Jesús xu'ij chique ri achi'a' ri': ¿Man itz'eton ta c'a chupa rutzij ri Dios ri nu'ij chi can pa ruticribel pe ri Dios je ca'i' xeru'on? Can man ruyon ta ri achi y chuka' man ruyon ta ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","¿Can manak como itz'eton chuka' ri tz'iban can? Ri nu'ij: Romari' ri achi xquieruya' can ri rute-rutata' y xtiquic'on-qui' riq'uin ri raxayil, y chi je ca'i' xe jun xtiqui'en. Quiri' nu'ij rutzij ri Dios ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Y romari' cuando quic'uan chic qui', man je ca'i' ta chic, xe jun chic quibanon. Romari', ri can xe jun chic quibanon roma ri Dios, man jun winak tijacho quichi', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Y ri achi'a' fariseos xquic'utuj che ri Jesús: Xa quiri', ¿anchique roma ri Moisés xu'ij chi xa jun achi nrojo' nujach-ri' riq'uin raxayil, tu'ona' jun carta ri nu'ij chi nujach-ri' riq'uin y tuya' che ri raxayil? ");
INSERT INTO cakNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Y ri Jesús xu'ij chique ri achi'a' ri': Can anche'l cowirinak ri iwánima rix cami, quiri' chuka' xbanataj ojer can pa ru-tiempo ri Moisés. Romari' raja' xu'ij chi jun achi c'o modo nujach-ri' riq'uin ri raxayil; pero pa ruticribel pe, man quiri' ta ri x-an. ");
INSERT INTO cakNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ren can nin-ij-wi chiwe chi xabachique (xama'anchique) achi ri nujach-ri' riq'uin ri raxayil y xa man roma ta ri ixok ruc'uan-ri' riq'uin jun chic achi, xa roma ri achi xucanoj jun chic ixok, ri achi ri' can nika pa mac chech ri Dios. Y xa c'o jun achi ri nuc'on ri ixok chi ntoc raxayil, roma ri ixok rujachon-ri' riq'uin ri rachijil, chuka' ri achi ri' can nika pa mac chech ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Y ri discípulos xqui'ij che ri Jesús: Xa jun achi can jumul ximil riq'uin ri raxayil, más ta utz che ri achi man ta nic'ue' raxayil, xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Y ri Jesús can ja' xu'ij chique ri ru-discípulos: Man conojel ta niqui'en entender ri tzij ri xin-ij-ka, roma man chique ta conojel yo'n-wi lugar chi manak ta nic'ue' quixaylal. ");
INSERT INTO cakNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Y can jec'o-wi achi'a', desde que xe'alex can ja' yan xek'alajin chi can man xtiquicanoj ta quixaylal. Jec'o chuka' achi'a' je quiri', pero xa roma xe'an operar. Y jec'o chuka' achi'a' je quiri', pero xa quiq'uin reje' xpe-wi que man xtiquicanoj ta quixaylal, chi quiri' niqui'en rusamaj ri Dios y yequito' ri ye'oc quiq'uin ri ye'an gobernar roma ri Dios. Ri jun ri can nuna' chi nitiquier nic'ue' ruyon y man nic'ue' ta raxayil, can quiri' tu'ona', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Y jec'o ac'uala' ri xec'uax-apo chech ri Jesús, chi tuya' ruk'a' pa quiwi' y tuc'utuj chuka' ru-bendición ri Dios pa quiwi'. Pero ri discípulos xa xqui'ij chique ri winak que man quiequic'uaj ri ac'uala' chech ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Pero ri Jesús xa xu'ij chique ri ru-discípulos: Tiya' lugar chi ri ac'uala' yepe wiq'uin ren, y man quie'ik'at. Roma ri ru-gobierno ri Dios, xe quichi ri je anche'l ac'uala'. ");
INSERT INTO cakNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Y cuando ri Jesús ruc'utun chic ru-bendición ri Dios y xuyala' yan can ruk'a' pa quiwi' ri ac'uala', raja' xuya' can ri lugar ri' y xbe. ");
INSERT INTO cakNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Y c'o jun c'ajol-ala' xapon riq'uin ri Jesús y xu'ij: Utzilaj Maestro, ta'ij chue: ¿Anchique ri utz ri nin-en ren chi quiri' ninwil nuc'aslen ri man niq'uis ta? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Y ri Jesús xu'ij che: ¿Anchique roma na'ij utz chue ren? Roma man jun winak ri utz ta, xa can xe Jun ri utz y ri' ja ri Dios. Xa ret can najo' jatapon chupa ri c'aslen ri man niq'uis ta, can tabana' ri nu'ij ri mandamientos, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Y xpe ri c'ajol-ala' xuc'utuj che ri Jesús: ¿Anchique ri mandamientos ri'? xcha'. Y ri Jesús xu'ij che: Ri mandamientos ri' ja ri man cacamisan, ri achi ri c'o raxayil man tucanoj jun chic ixok, man catelak', man tatz'uc tzij chirij jun chic winak. ");
INSERT INTO cakNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chuka' quie'abana' respetar ri ate-atata'. Y anche'l najo-ka-awi' ret, can quiri' chuka' quie'ajo' conojel ri winak. Jari' ri mandamientos, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Y ri c'ajol-ala' xu'ij che ri Jesús: C'a jin co'l cuando nubanon-pe ronojel ri'. ¿Anchique c'a ri ch'aka chic ri man nubanon ta? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Y ri Jesús xu'ij che: Xa najo' na'an ronojel, c'a c'o ri manak abanon. Man ajachon ta ri abeyomal chiquiwech ri winak ri manak quibeyomal. Tac'ayij ri c'o awiq'uin y ri rajil tajacha' chiquiwech ri winak ri manak quibeyomal, chi quiri' nic'ue' abeyomal chicaj. Y catampe wiq'uin y quinatzeklebej, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Cuando ri c'ajol-ala' xuc'oxaj ri tzij ri xu'ij ri Jesús, nibison ránima xtzolaj-e, roma yalan rubeyomal c'o y man nrojo' ta nusipaj. ");
INSERT INTO cakNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ja cuando ri Jesús xu'ij chique ri ru-discípulos: Can tinimaj ri nin-ij chiwe, chi yalan cuesta che jun beyom ntoc quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Xa más la'k nitiquier nik'ax jun camello pa jun ch'uti' rujulil jun acux, que chech jun beyom ntoc quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Y cuando ri ru-discípulos ri Jesús xquic'oxaj ri tzij ri', can xsatz quino'j (xsach quic'u'x), y niqui'ij chiquiwech: Xa can anche'l ri nu'ij, xa can quiri', can man jun xticolotaj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xerutzu-apo ri ru-discípulos y xu'ij chique: Man tinojij quiri'. Ri winak man yetiquier ta niquicol-qui', pero ri Dios ronojel nitiquier nu'on, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Y ja' cuando ri Pedro xu'ij che ri Jesús: Ret aweta'n chi roj kayo'n can ronojel ri c'o kaq'uin, roma jatkatzekleben. ¿Y anchique xtakach'ec roj romari'? ");
INSERT INTO cakNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xu'ij: Can ketzij ri nin-ij chiwe, chi cuando xtapon ri tiempo chi ronojel xquie'oc c'ac'ac', ren ri jin-kajinak-pe chicaj y xinalex chi'icojol c'o chic nuk'ij, can xquich'oquie' pa nu-trono chi nin-en gobernar. Y chuka' rix ri jinitzekleben, xquixch'oquie' pa cablajuj tronos chi niben gobernar pa quiwi' ri cablajuj quiwech familias ri je calc'ual can ri cablajuj ralc'ual can ri achi xubinaj Israel. ");
INSERT INTO cakNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Y xabachique (xama'anchique) winak ri woma ren ruyo'n can rocho, rach'alal, rute-rutata', raxayil, ralc'ual o rulef, q'uiy ri xtiyo'x che; can cien más ri ruq'uiexel xtiyo'x che. Y can xtiyo'x chuka' ruc'aslen ri manak xtiq'uis. ");
INSERT INTO cakNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Y je q'uiy ri yalan quik'ij cami, xtapon ri k'ij cuando manak chic quik'ij xtic'ue'. Y je q'uiy ri xa manak quik'ij ri cami, xtapon ri k'ij cuando xtic'ue' quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ri ru-gobierno ri Dios can junan riq'uin ri xu'on jun achi rajaf ulef ri xerucanoj samajel chi yesamaj riq'uin. Raja' can cumaj xcataj y ri samajel ri xeril xerutak pa rulef ri ruticon uva chech chi xquimol ri cosecha. ");
INSERT INTO cakNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cuando ri achi ri' xeril ri samajel y xu'ij chique chi can xtuya' jun denario chique chi quik'ij, ja xerutak pa rulef ri ruticon uva chech. ");
INSERT INTO cakNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","C'ajari' ri achi xel chic e c'o la'k a las nueve che ri nimak'a' ri', y xutzu' pa c'ayibel chi jec'o ri man quiwilon ta quisamaj. ");
INSERT INTO cakNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Raja' xapon quiq'uin y xch'o'n-apo chique y xu'ij: Quixbesamaj chuka' rix pa wulef ri nuticon uva chech, y ren xtinya' jun utz iwajil, xcha' chique. Y ri samajel ri' can xebe-wi pa samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ri rajaf ri ulef, can quiri' chuka' xu'on quiq'uin ri ch'aka chic samajel ri xeril cuando xel-e pa nic'aj-k'ij, y quiri' chuka' xu'on ri c'o la'k a las tres ri nak'ak'ij. Raja' xerutak ri samajel pa rusamaj, y xu'ij chique chi can xtuya' jun utz cajil. ");
INSERT INTO cakNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Y c'o la'k a las cinco ri nak'ak'ij, raja' xel chic e jun mej (bey) y xeberila-pe ch'aka chic, y xu'ij chique: ¿Anchique roma rix manak jixsamaj y chi jun k'ij ri jixc'o we'? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y ri samajel ri' xqui'ij che: Man jun xyo'n kasamaj, xecha'. Y ri rajaf ri ulef xu'ij chique: Quixbesamaj chuka' rix pa wulef ri nuticon uva chech, y xtinya' jun utz iwajil, xcha' chique. Y ri samajel ri' can xebe pa samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Cuando xka yan ka ri k'ij, xpe ri rajaf ulef, xu'ij che ri uc'uey quichi ri samajel: Quie'awoyoj-pe conojel ri samajel y quie'atojo-e. Na'ey quie'atojo' ri samajel ri xeloka después, y c'ajari' quie'atojo' ri xeloka na'ey, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Cuando ri samajel ri xe'oc pa samaj ri c'o la'k a las cinco ri nak'ak'ij, xe'apon chi yetoj; jun denario ri xtoj chique, roma quiri' xurayij ránima ri rajaf ulef nuya' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Y cuando xe'apon ri samajel ri xe'oc pa samaj na'ey chi yetoj; xquinojij que más q'uiy ri xtiyo'x chique, roma reje' can jun k'ij xesamaj. Pero cuando xtoj rajil ri quik'ij, xquitzu' chi reje' chuka' xa jun denario ri xyo'x chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Cuando xquitzu' chi junan ri xyo'x chique, xquich'ojij ri cajil che ri patrón. ");
INSERT INTO cakNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ri samajel ri' xqui'ij: Ri samajel ri xe'oc-pe pa samaj después, xa jun hora oc xesamaj, y can junan xa'an chique kaq'uin roj, y roj jun k'ij ri xojsamaj y xojc'ue' chuxe' ruk'ak'al-k'ij, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Y ri rajaf samaj xu'ij che jun: Xa junan xentoj ri ch'aka chic samajel, man jun itzel ex xin-en chawe ret. Roma quiri' xka'ij awiq'uin chi jun denario ninya' chawe. ¿Noka pa awi'? ");
INSERT INTO cakNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cami ret xe tac'uaj ri awajil y utz jabe. Y chique ri samajel ri xe'oc pa samaj después, can pa wánima ren xalex-wi chi xinya-e ri cajil anche'l ri awajil ret. ");
INSERT INTO cakNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Roma ronojel ri c'o wiq'uin ren, can pa nuk'a' ren c'o-wi chi nin-en anchique ri ninjo' nin-en che. ¿O itzel yinatzu' roma nin-en ri utz? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ri ejemplo re' nuk'alajij chakawech chi je q'uiy ri yalan quik'ij cami, xtapon jun k'ij cuando manak chic quik'ij xtic'ue'. Y je q'uiy ri xa manak quik'ij cami, xtapon jun k'ij cuando xtic'ue' quik'ij. Y más que je q'uiy ri yewoyox, man conojel ta yecho'x chi nic'ue' quik'ij. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ri Jesús y ri cablajuj ru-discípulos y ri ch'aka chic winak ri je-benak quiq'uin, quitz'amon-e bey pa tenemit Jerusalem. Y ja' cuando ri Jesús xeruc'uaj juba' aparte ri ru-discípulos roma c'o nrojo' nu'ij chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Raja' xu'ij: Rix iweta'n chi c'a pa tenemit Jerusalem jojapon-wi, y chiri' xquijach-wi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. Xquibejach pa quik'a' ri nimalaj tak sacerdotes y chuka' pa quik'a' ri maestros chi ri ley. Y reje' xtiqui'ij chi quicamises. ");
INSERT INTO cakNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Y chuka' xquibejach coma reje' pa quik'a' winak ri man je israelitas ta. Y ri winak man je israelitas ta xquietze'n chuij, xquinquich'ey y c'ajari' xquinquibajij chech cruz. Pero pa rox k'ij xquic'astaj-pe, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Y ri je ca'i' discípulos ri je ralc'ual ri achi rubinan Zebedeo, c'o ri quite' quiq'uin cuando junan xebe-apo riq'uin ri Jesús. Y ri quite' xxuquie-ka chech ri Jesús chi xuc'utuj jun favor che. ");
INSERT INTO cakNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xu'ij che ri te'j: ¿Anchique ri najo'? xcha' che. Y ri ixok xu'ij che ri Jesús: Ren ninjo' chi cuando na'an yan gobernar, ri ca'i' wal re' xquiech'oquie' ta apo awiq'uin; can ta quiri' xta'an chique, jun ta nic'ue' pa a-derecha y jun ta pa a-izquierda. Can tabana' chique chi xtic'ue' ta quik'ij, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Pero ri Jesús xu'ij: Rix man iweta'n ta anchique ri nic'utuj. Y romari' ren ninc'utuj chiwe cami: ¿Nicoch' como rix anche'l ri xti'an chue ren? ¿Y nicoch' como chuka' rix jun sufrimiento anche'l ri xtika pa nuwi' ren? Roma ronojel ri xtika pa nuwi' ren, xa anche'l jun ya' can q'uey, can anche'l jun bautismo, xcha' ri Jesús. Y ri ca'i' discípulos ri je ral ri ixok xqui'ij: Nakacoch', xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Y ri Jesús xu'ij chic chique: Can ja-wi; rix can xticoch'-wi ri anche'l xti'an chue ren. Chuka' can xticoch' jun sufrimiento ri anche'l xtika pa nuwi' ren; ri can anche'l jun ya' can q'uey, can anche'l jun bautismo. Pero ri nic'utuj rix, chi jun chiwe nich'oquie' pa nu-derecha y ri jun chic pa nu-izquierda, ri' man pa nuk'a' ta ren c'o-wi chi ninya' chiwe. Roma ri nic'utuj rix, can ja ri Nata' xnojin yan anchok chique xtuya-wi lugar chi yech'oquie' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Y cuando ri lajuj discípulos xquic'oxaj ri x-ix, xpe quiyowal chique ri je ca'i' discípulos ri cach'alal qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Pero ri Jesús xeroyoj ri ru-discípulos y xu'ij chique: Ren nin-ij chi rix jabel iweta'n chi we' chech-ulef ri niqui'en gobernar, can cajaf quibanon-ka chiquij ri winak ri jec'o pa quik'a'. Y quiri' chuka' ri ch'aka chic ri can c'o quik'ij, niquijo' chi quienimex y can ti'an ronojel ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero chi'icojol rix man quiri' ta. Roma xa c'o jun ri nrojo' chi nic'ue-ka ruk'ij, can tuna-ka chi can manak ruk'ij y co'l oc tu'ona-ka chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Xa jun chiwe rix can nrojo' chi ja raja' ri na'ey y c'o ta ruk'ij, can tuna-ka chi can manak ruk'ij y co'l oc tu'ona-ka chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Can tu'ona' anche'l nin-en ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. Ren man ninpokonaj ta wi' yisamaj coma ri ch'aka chic; can romari' xipe. Y man xipe ta chuka' xe chi jec'o ri yebano-pe ronojel ri nin-ij chique. Can ja ren ri yibano ri samaj, y can ninya' nuc'aslen chi quiri' je q'uiy ri yecolotaj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Cuando ri Jesús y ri ru-discípulos ja' niquiya' can ri tenemit rubinan Jericó, yalan je q'uiy winak ri xetzekleben richi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Jec'o ca'i' moy je-ch'ocol chuchi' ri bey xquic'oxaj chi ri Jesús jari' ri nik'ax-e chiri', y reje' riq'uin quichuk'a' xech'o'n y xqui'ij: Ajaf, ri jat ru-familia can ri rey David, tajoyowaj kawech roma ri kabanon, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Y ri winak xequich'olij chi quiri' man chic quiech'o'n-apo. Pero reje' xa riq'uin más quichuk'a' xech'o'n y xqui'ij-apo: Ajaf, ri jat ru-familia can ri rey David, tajoyowaj kawech roma ri kabanon, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Y ri Jesús xeruc'oxaj, romari' xpa'e-ka, xeroyoj y xu'ij chique: ¿Anchique nijo'? xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Reje' xqui'ij che ri Jesús: Ajaf, roj nakajo' jojtzu'n, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ri Jesús roma yalan xujoyowaj quiwech ri ca'i' moy, can ja' xuya' ruk'a' chuchi' tak quiwech. Y reje' can ja' xetzu'n, y xquitzeklebej-e ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Y cuando ri Jesús y ri ru-discípulos y ri ch'aka chic winak ri je-benak quiq'uin ye'apon yan pa tenemit Betfagé, ri c'o-apo chech ri juyu' rubinan Olivos; can nakaj chic jec'o-wi-apo che ri tenemit Jerusalem. Ri Jesús ja xerutak-e ca'i' ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Raja' xu'ij-e chique: Quixoc-apo chupa la co'l tenemit la' y chiri' xtiwil jun alaj burro ri c'o chiri' riq'uin ri rute'. Tisolo-pe ri te'j y quie'ic'ama-pe ri ca'i' chue. ");
INSERT INTO cakNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y xa c'o jun ri c'o anchique ri xtu'ij-pe chiwe, rix ti'ij che: Yec'atzin juba' che ri Ajaf, pero can ch'anin xquierutzolej-pe, quixcha' can che, xe'uche'x-e roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Riq'uin re' can nibanataj anche'l ri tz'iban can roma ri jun ri xk'alajin rutzij ri Dios ojer can. Ri rutz'iban can raja', nu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Tiya' rutzijol chique ri winak ri aj-tenemit Sión, chi ri qui-Rey ja' petenak. Ri qui-Rey can manak oc ruk'ij rubanon-pe, raja' ch'ocol-pe chirij jun alaj burro. Ri alaj burro ral jun chicop chi eka'n (aka'n). Quiri' ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Y ri ca'i' discípulos xebe, y xqui'en-wi ri xchelebex-e chique roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ri alaj burro y ri rute' xec'amer-pe che ri Jesús, c'ajari' ri discípulos xquiyala' jujun quitziak chiquij ri ca'i' chicop ri', y ri Jesús xch'oquie-e. ");
INSERT INTO cakNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Y ri je-benak chirij ri Jesús can yalan-wi je q'uiy y xquiriq'uila' quitziak pa rubey ri Jesús chi niquiya' ruk'ij. Y ch'aka chic winak roma niquijo' niquiya' chuka' ruk'ij ri Jesús, xebequic'ama-pe ruxak tak che' chi xquiric' pa rubey. ");
INSERT INTO cakNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Y ri winak ri je-benak chech ri Jesús y ri jec'o can chirij, can riq'uin ronojel quichuk'a' niqui'ij: ¡Matiox chi petenak ri Jun re', ri ru-familia can ri rey David! ¡Raja' yo'n-pe bendición pa ruwi' roma ri Ajaf Dios! ¡Petenak pa rubi' ri Ajaf Dios! ¡Matiox che ri Dios ri c'o chicaj! yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Y cuando ri Jesús ntoc-apo pa tenemit Jerusalem, xepe ri winak y xquimol-qui' ch'anin chi niquitzu' ri Jesús. Y ri winak ri' niqui'ij: ¿Anchique chi achi re'? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Y jec'o ri xe'in: Re' ja ri Jesús, ri nik'alajin ri ni'ix che roma ri Dios. Raja' aj-Nazaret, ri tenemit ri c'o pa Galilea, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Y ri Jesús xapon pa rocho ri Dios ri c'o pa tenemit Jerusalem. Y roma xutzu' chi anche'l c'ayibel quibanon ri winak che, xerokotaj-e conojel ri yec'ayin y ri yelok'on. Y chique ri niquijal rech mero, xerutacmayila' can ri qui-mesas. Y quiri' chuka' xu'on can chique ri quich'acat ri niquic'ayij palomas. ");
INSERT INTO cakNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ri Jesús xu'ij chique ri winak ri': Chupa rutzij ri Dios tz'iban can chi ri wocho, jay chi oración. Pero rix xa anche'l quijul elek'oma' ibanon che, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Y cuando ri Jesús c'o pa rocho ri Dios, jec'o winak je moy y jec'o chuka' ri yejetz'ma'y yebin ri xe'apon riq'uin chi yeruc'achojrisaj-e. Y raja' can quiri' xu'on chique. ");
INSERT INTO cakNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Pero ri nimalaj tak sacerdotes y ri maestros chi ri ley xpe quiyowal, roma ri Jesús q'uiy milagros ri yeru'on, y roma chuka' ri ac'uala' riq'uin quichuk'a' niqui'ij chiri' pa rocho ri Dios: ¡Matiox chi xoka ri Jun re', ri ru-familia can ri David! yecha'. Y jari' ri xbano chique chi xpe quiyowal. ");
INSERT INTO cakNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xepe ri nimalaj tak sacerdotes y ri achi'a' maestros, xqui'ij che ri Jesús: ¿Nac'oxaj ri niqui'ij ri ac'uala'? xecha'. Y xpe ri Jesús xu'ij chique ri achi'a' ri': Ja', ninc'oxaj. Y rix ¿man itz'eton ta c'a chupa rutzij ri Dios ri nu'ij: Ri can ketzij yeyo'n ruk'ij ri Dios ja ri ac'uala' y ri c'a yetz'uman (yeme')? xcha' ri Jesús chique ri achi'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Y ri Jesús xeruya' can chiri' ri achi'a'. Raja' xel-e pa tenemit Jerusalem y xbe pa tenemit Betania. Chiri' xbe-wi chi xuk'axaj ri ak'a' ri'. Y chuka' ri ru-discípulos xebe riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Y nimak'a' ruca'n k'ij, cuando quitz'amon bey chi yetzolaj pa tenemit Jerusalem, ri Jesús xnum-pe rupa. ");
INSERT INTO cakNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Y cuando je-benak, raja' xutzu' jun mata higo chunakaj ri bey. Xbe-apo chuxe' chi xucanoj rech, pero xa man jun rech c'o, xa ruyon ruxak. Y ri Jesús ja' xch'o'n che ri che' y xu'ij che: Man jun mej (bey) chic xtaya' awech. Y ri higo ri' can xchaki'j-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Cuando ri ru-discípulos ri Jesús xquitzu' chi xchaki'j-ka ri jun mata higo, xqui'ij: ¿Anche'l xu'on chi ch'anin xchaki'j-ka ri jun mata higo? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Xpe ri Jesús xu'ij chique: Can ketzij nin-ij chiwe: Xa can ninimaj chi nibanataj ri nijo' y can man nipe ta pa iwánima chi xa man nibanataj ta, can xquixtiquier niben quiere' che jun mata higo. Y c'o ta más nimalaj tak ex jixtiquier niben, que chech ri jun re'. Jixtiquier ta ni'ij che la juyu' la' chi tel-e chila' y tik'ax chupa ri mar, y can quiri' xtibanataj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Can ronojel ri xtic'utuj che ri Dios y can ninimaj chi raja' can xtu'on-wi ri nijo', can xtibanataj-wi ri nic'utuj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Y cuando ri Jesús c'o chic pa rocho ri Dios y nuc'ut chic rutzij ri Dios chiquiwech ri winak, ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij chiquicojol ri winak, xe'apon-apo riq'uin y xquic'utuj che ri Jesús: ¿Ancu'x (Anchique) yoyo'n uchuk'a' pa ak'a' chi xe'awokotaj-e ri winak yec'ayin pa rocho ri Dios? ¿Y ancu'x (anchique) chuka' yoyo'n lugar chawe chi ye'aben ronojel re' chiquicojol ri winak? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Xpe ri Jesús xu'ij chique ri achi'a' ri': Ren c'o chuka' jun ex ri ninjo' ninc'utuj chiwe, y xa xti'ij-pe chue, ren chuka' xtin-ij chiwe ancu'x (anchique) yoyo'n uchuk'a' pa nuk'a' chi yenben ronojel re'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Y ja' cuando ri Jesús xuc'utuj: ¿Ja ri Dios ri x-in che ri Juan chi quieru'ona' bautizar ri winak? ¿O xa winak xe'in che? xcha' ri Jesús. Y ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij xqui'ij-ka chiquiwech: ¿Anchique naka'ij che ri Jesús cami? xecha-ka. Roma xa naka'ij che chi ri Juan ja ri Dios ri takayon-pe richi, ri Jesús xtu'ij chake chi anchique roma man xkanimaj ta rutzij. ");
INSERT INTO cakNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Y xa naka'ij che chi ja ri winak xe'in che ri Juan chi tu'ona' quiri', can man utz ta, roma roj can nakaxi'j-ki' chiquiwech ri winak xa xquiecataj chakij. Roma conojel winak can quieta'n-wi chi ri Juan can xuk'alajij-wi ri x-ix che roma ri Dios, xecha-ka chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Y c'ajari' xqui'ij-apo che ri Jesús: Roj man keta'n ta, xecha-apo. Y ri Jesús can ja' xu'ij chique ri achi'a' ri': Roma rix man xixtiquier ta xi'ij chue, ren man xtin-ij ta chuka' chiwe ancu'x (anchique) yoyo'n uchuk'a' chue chi yenben quiere', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ri Jesús xu'ij chique ri achi'a' ri': Can tinojij utz ri xtin-ij chiwe. C'o jun achi xec'ue' ca'i' ralc'ual. Y ri tata'j re' xu'ij che jun ralc'ual na'ey: Cami, cabesamaj anchi' katicon-wi uva, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Pero raja' xu'ij che rutata': Cami man ninjo' ta yibesamaj, xcha'. Y c'ajari' xunojij pa ránima que man utz ta ri xu'ij y romari' xunojij chi can más utz ne'samaj, y can ja' xbesamaj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Y ri tata'j quiri' chuka' xu'ij che ri jun chic ralc'ual, chi te'samaj. Y ri ralc'ual ri' xu'ij che: Ja' tat, ja yibe, xcha'. Pero xa man xbe ta. ");
INSERT INTO cakNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ri Jesús xuc'utuj: ¿Ancu'x (Anchique) chique ri je ca'i' xbano ri xrojo' ri tata'j? xcha'. Y ri achi'a' ri' xqui'ij: Ja ri na'ey, xecha'. Y ri Jesús xu'ij chique: Can tinimaj ri nin-ij chiwe, chi ja ri moloy-impuestos y ri ixoki' itzel quic'aslen ri ni'ix rameras chique, ri xquie'oc na'ey chiwech rix quiq'uin ri ye'an gobernar roma ri Dios, roma reje' can xquinimaj ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Cuando ri Juan Bautista xpe, xuc'ut jun chojmilaj bey chiwech, xa ja rix man xinimaj ta. Xe ri moloy tak impuestos y ri ixoki' rameras ri xquinimaj. Pero rix, más que xitzu' ri' can man xiya' ta can ri imac y man xiben ta ri nrojo' ri Dios, y man xinimaj ta chuka'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Y tic'oxaj na pe' jun chic ejemplo, xcha' ri Jesús chique ri winak: Xc'ue' jun achi rajaf jun ulef; xpe raja' xutic uva pa rulef y xuya' co'c' chirij. Xu'on chuka' anche'l jun ch'uti' pila chupa ri ulef chi niyitz' ri uva, y chuka' jun torre, chi parui' ri' nic'ue-wi ri jun ri nuchajij ri ulef ri'. C'ajari' xuya' can pa kajic chique jujun achi'a', y raja' xbe naj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Y cuando xoka ri tiempo chi ri cosecha, ri rajaf ri ulef xutak jun rusamajel, y c'ajari' xutak jun chic, y quiri' je q'uiy ri xerutak chi niquic'utuj ri uva; roma riq'uin ri' nitoj-wi ri rukajic ri ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero ri achi'a' ri je-kajayon ri ulef, xa man xequic'ul ta jabel ri samajel ri je-takon-e roma ri rajaf ri ulef. Jun xquich'ey, jun xquiq'uiak che abaj y jun chic xquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Xpe ri rajaf ri ulef xerutak ch'aka chic rusamajel. Can más je q'uiy ri xerutak ri jun chic mej (paj) re'. Pero ri achi'a' ri' ja mismo xqui'en chique. ");
INSERT INTO cakNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Y pa ruq'uisbel, ri rajaf ulef xunojij y xu'ij: Ri achi'a' ri kajoy-ulef can xquieniman cuando xtiquitzu' chi can ja ri walc'ual ri xtapon, xcha-ka raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Pero ri achi'a' ri', can xe xquitzu' chi ja ri ralc'ual ri rajaf ulef xapon, xqui'ij-ka chiquiwech: Jare' ri ne'oc rajaf ronojel ri ulef ri kakajon cami. Cami kacamisaj, chi quiri' pa kak'a' roj nic'ue-wi can ri ulef, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Y can quiri-wi xqui'en. Xquitz'om y xquilesaj-e ri ralc'ual chiri' chupa ri rulef y xquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","C'ajari' ri Jesús xu'ij: Cuando xtipe ri rajaf ri ulef ri ticon uva chech, ¿anchique como xtu'on chique ri achi'a' ri', ninojij rix? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Y ri winak xqui'ij: Ri rajaf ulef man xtujoyowaj ta quiwech ri itzel tak achi'a' kajoy-ulef, can xquierucamisaj; y c'ajari' ri rulef xtuya' chic pa kajic chique ch'aka chic achi'a' ri can xtiquiya-wi ri kajbel richi, ri uva rajil ri ulef cuando napon ri tiempo, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ri Jesús xu'ij chique: ¿Can man jun mej (bey) c'a itz'eton ri jun tzij tz'iban can chupa rutzij ri Dios? Ri tzij ri' nu'ij: C'o jun Abaj ri man xka ta chiquiwech ri achi'a' ri je banoy-jay. Pero xa ja ri Abaj ri' ri xc'atzin, roma can jari' ri xcuses chi quiri' ri jay man nitzak ta. Can ja ri Ajaf xbano chi xcuses ri Abaj re', y roj can man jun mej (bey) katz'eton chi nibanataj quiere'. Quiri' nu'ij rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Y romari', rix manak chic xquixc'ue' pa ru-gobierno ri Dios. Ri xquiec'ue' pa ru-gobierno ri Dios, xa ja yan chic ri ch'aka chic winak ri can xtiwachin-wi ri quic'aslen chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Xabachique (Xama'anchique) winak ri xtitzak parui' ri Abaj ri xcuses che ri jay, can jumul xtimulumu'. Y xabachique (xama'anchique) winak ri xtika ri Abaj ri' chirij, can xtuquie'j jumul, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Y cuando ri nimalaj tak sacerdotes y ri achi'a' fariseos quic'oxan chic ka ri ejemplos ri xerutzijoj ri Jesús, can xqui'en entender chi xa chiquij reje' xch'o'n-wi-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Y ja' cuando reje' xquijo' xquitz'om yan e ri Jesús. Pero man xqui'en ta roma xa niquixi'j-qui' chiquiwech ri winak; roma chiquiwech ri winak, ja ri Jesús ri nik'alajin ri ni'ix che roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Y ri Jesús xch'o'n chic chique ri winak, y xerucusaj ch'aka chic ejemplos. Raja' xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","Ri ru-gobierno ri Dios can junan riq'uin jun nimak'ej ri xu'on jun rey cuando xc'ule' ri ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ri rey ri', can jec'o-wi chic ri jerubanon invitar chi ye'apon chupa ri jun c'ulubic ri', y romari' xerutak ri rusamajel chi xequiwoyoj ri winak. Pero ri je-banon invitar man xquijo' ta chic xe'apon. ");
INSERT INTO cakNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Y ri rey xerutak-e ch'aka chic rusamajel y xu'ij-e chique: Ti'ij chique conojel ri jenubanon yan invitar, chi quiepe chupa ri jun nimak'ej re'. Can ronojel c'o chic chi jojwa'. Ri achij tak nuwacx y ri ch'aka chic wawaj ri jenuwilin-pe utz, je ti'oj chic chi yec'atzin chupa ri k'ij re', x-an yan quibanic y jec'o chic chi yetej. Can ronojel c'o chic, can jo' pa c'ulubic, quixcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Pero ri je-banon invitar, man xeniman ta riq'uin ri xbe'ix chic jun mej (bey) chique. Jun xbe pa rusamaj pa juyu', y jun xa ja ri c'ayij ri c'o pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Y ri ch'aka chic winak ri je-banon chuka' invitar chi ri c'ulubic ri', xa xequitz'om ri samajel ri jerutakon-e ri rey, y xequicamisaj; roma chiquiwech reje' ri je samajel ri' xa man jun quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Cuando xapon rutzijol riq'uin ri rey ri xbanataj, xcataj ruyowal. Raja' can ja' xerutak ru-soldados chiquij chi xeruq'uis ri je camisanel, y chuka' chi tiporox ri quitenemit. ");
INSERT INTO cakNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","C'ajari' ri rey xch'o'n chic quiq'uin ri rusamajel jun mej (bey) y xu'ij chique: Can ketzij-wi chi ronojel c'o chic chi ni'an ri c'ulubic, pero ri xenben invitar man xeloka ta, y xa can utz xu'on man xepe ta, roma xa can man nuc'ul ta chique xa ta jec'o-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Cami, quie'iwoyoj-pe conojel ri winak ri xquie'iwil pa tak bey y ja ri bey ri ye'el-e chuchi' ri tenemit. Ti'ij chique chi quiepe chupa ri c'ulubic, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Y cuando ri samajel xebe pa tak bey ri jec'o chuchi' ri tenemit, xequiwoyoj-pe ronojel quiwech winak, ri utz y ri man utz ta quic'aslen. Y ri jay anchi' x-an-wi ri c'ulubic, xnoj. ");
INSERT INTO cakNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Y ri rey xoc-apo chi xerutzu' conojel ri xewoyox. Y raja' xutzu' chi c'o jun achi chiri' ri man rucusan ta ri tziak ri nicuses chupa ri jun c'ulubic ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ri rey xch'o'n che ri achi ri' ri c'o pa c'ulubic, y xuc'utuj che: Y ret ¿anchique xa'an chi xatiquier xatoc-pe we'? Cuando xa man ja' ta ri tziak ri nicuses chupa ri jun c'ulubic re' acusan, xcha' ri rey che. Y ri achi can man jun xch'o'n chech ri rey, roma man xtiquier ta xuk'alajij anchique roma man rucusan ta ri tziak. ");
INSERT INTO cakNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Y ri rey ja' xu'ij chique ri rusamajel: Tixima-e ruk'a-rakan ri jun achi ri man rucusan ta ri tziak chi ri c'ulubic, tilesaj-e y tiq'uiaka' pa k'eku'm. Chiri' xe ok'ej xtu'on y xtujach'ach'ej rey. ");
INSERT INTO cakNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Y más que can je q'uiy-wi ri yewoyox, can man conojel ta xquiecho'x chi ye'oc pa ru-gobierno ri Ajaf Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Y ri achi'a' fariseos xebe; xbequinojij chiquiwech chi anchique modo niqui'en che ri Jesús chi nitzak ta pa quik'a' riq'uin ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Romari' reje' xequitak qui-discípulos y jujun ruwinak ri rey Herodes. Xequitak-e riq'uin ri Jesús; y cuando reje' xe'apon riq'uin ri Jesús, xbequi'ij che: Ret ri jat jun Maestro, roj can keta'n chi xe-wi ri ketzij ri nika chawech y jari' ri natzijoj. Can nac'ut-wi ri rutzij ri Dios y can ja-wi rubixic na'an che. Roma ret man naxi'j ta awi' chech jun winak, más que can yalan ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Y cami nakajo' nakac'oxaj anchique ri xta'ij chake. Roma roj nakajo' nakana'ej: ¿Utz como nakatoj ri impuestos ri nu'ij ri rey César, o xa man utz ta? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Pero ri Jesús can reta'n-wi ri niquinojij chirij. Romari' raja' xu'ij chique: Rix xa ca'i' ipalaj. ¿Anchique roma rix nitaj ik'ij chi yinitojtobej? ");
INSERT INTO cakNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Tic'utu-pe ri mero ri nicuses chi nitoj ri impuestos, xcha' chique. Y reje' xquic'ut-apo ri mero chech; ri mero ri xquic'ut-apo ja ri niqui'ij denario che. ");
INSERT INTO cakNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Y ri Jesús ja' xuc'utuj chique: ¿Anchok rupalaj y anchok rubi' c'o chech la mero? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Y reje' xqui'ij che ri Jesús: Chi ri rey César, xecha'. Y ri Jesús xu'ij chique: Tiya' che ri César ri can richi-wi ri César; y tiya' che ri Dios ri can richi-wi ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Y cuando ri achi'a' ri' quic'oxan chic ri xu'ij ri Jesús, can anchique la xquina'. Y romari' reje' xquiya' can ri Jesús y xebe. ");
INSERT INTO cakNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Y ri k'ij ri' jec'o achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' re' man niquinimaj ta chi ri caminaki' xquiec'astaj chic pe. Reje' xe'apon riq'uin ri Jesús chi xquic'utuj ri' che. ");
INSERT INTO cakNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Reje' xqui'ij che ri Jesús: Ret ri jat jun Maestro, roj c'o nakajo' nakac'utuj chawe. Ri Moisés can rutz'iban-wi can chake: Xa c'o jun achi nuya' can ri raxayil roma nicom-e y man jun ralc'ual nic'ue' can, jun rach'alal ri caminak achi ri' tic'ule' riq'uin ri malca'n-ixok, chi quiri' yec'ue' ralc'ual riq'uin ri malca'n-ixok. Y xa can jec'o ralc'ual yec'ue' riq'uin ri ixok, ri na'ey ala' ri xtalex xtoc ralc'ual ri caminak chic e. ");
INSERT INTO cakNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Y reje' xqui'ij: Xec'ue' je wuku' achi'a' cach'alal qui'. Ri na'ey xc'ule', pero xcom-e y man jun ralc'ual xc'ue' can. Y roma xcom-e ri achi, ri raxayil xc'ue' can y xc'ule' chic riq'uin jun rach'alal ri achi ri xcom-e chech. ");
INSERT INTO cakNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ri ruca'n achi can quiri' chuka' xuc'ulumaj-e, raja' xcom-e y man jun ralc'ual xc'ue' can. Ri rox achi can ja' chuka' xuc'ulumaj-e anche'l ri je ca'i' na'ey rach'alal, y ri ixok c'a xc'ue' na can. Y chi wuku' achi'a' cach'alal qui' quiri' xquic'ulumaj-e. ");
INSERT INTO cakNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Y cuando xecom yan e ri wuku' achi'a' cach'alal qui' chech ri ixok ri', chuka' raja' xcom-e. ");
INSERT INTO cakNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Y ri achi'a' saduceos xqui'ij che ri Jesús: Ret na'ij chi xtapon jun k'ij cuando ri caminaki' xquiec'astaj-pe. Cuando xtapon ri k'ij ri', ¿anchok raxayil xtoc ri ixok ri'? Roma chi je wuku' achi'a' cach'alal qui' xec'ue' riq'uin, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús can ja' xu'ij chique ri achi'a' ri': Rix xa jix-satzinak (jix-sachinak) riq'uin ri xi'ij. Ri rutzij ri Dios jun-wi chic ri nu'ij. Y can man iweta'n ta chuka' chi ri ruchuk'a' ri Dios can nim. ");
INSERT INTO cakNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roma cuando xtapon ri k'ij chi ri caminaki' xquiec'astaj-e, man xquiec'ule' ta chic. Reje' xa xquie'oc anche'l ri ru-ángeles ri Dios ri jec'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Pero ri caminaki' can yec'astaj-wi. ¿Man itz'eton ta c'a rutzij ri Dios ri yo'n can pa ik'a'? Chiri' ri Dios can nu'ij-wi chiwe: ");
INSERT INTO cakNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ja ren jin qui-Dios ri Abraham, ri Isaac y ri Jacob. Quiri' xu'ij ri Dios ojer can. Y xa ta reje' je caminak ta chi ronojel tiempo, ri Dios man ta qui-Dios reje', roma xa man ta yec'astaj-e. Ri Dios can qui-Dios-wi ri c'o quic'aslen y man qui-Dios ta ri caminaki', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Y cuando ri winak quic'oxan chic ri tzij ri xeru'ij ri Jesús chi yerutijoj, can anchique la xquina', roma man jun mej (bey) quic'oxan tzij anche'l ri xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Y ri achi'a' fariseos can ch'anin xquimol-qui' chi niquinojij anchique ri xtiqui'en, roma xquic'oxaj chi ri Jesús can xutz'apij xequey ri achi'a' saduceos roma ri xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Xpe jun chique ri achi'a' fariseos, ri can maestro chi ri ley ri xuya' ri Dios che ri Moisés, xe chi nutojtobej ri Jesús, xuc'utuj che: ");
INSERT INTO cakNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","Ret ri can jat Maestro, ta'ij chue, ¿anchique chique ri mandamientos ri xuya' ri Dios che ri Moisés, ri c'o más rakalen? ");
INSERT INTO cakNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Y ri Jesús xu'ij che: Ri mandamiento ri' ja ri tajo' ri Dios ri Awajaf. Tajo' riq'uin ronojel awánima. Tajo' chupa ronojel ri ac'aslen, y riq'uin ri ano'j (ana'oj). ");
INSERT INTO cakNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Jare' ri na'ey y nimalaj mandamiento ri c'o chupa ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Y c'o chuka' jun ruca'n mandamiento ri yalan rakalen y xa can junan riq'uin ri na'ey. Y ri mandamiento ri' nu'ij: Can anche'l najo-ka-awi' ret, can quiri' chuka' quie'ajo' conojel winak. Quiri' nu'ij ri mandamiento ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ja ca'i' mandamientos re' je ruxe'l ronojel ri ley ri xuya' ri Dios che ri Moisés y ronojel ri qui'in can ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can. Ri ca'i' mandamientos re' yalan quikalen, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Y cuando c'a quimolon-qui' ri achi'a' fariseos, xpe ri Jesús can c'o ri xuc'utuj chique. ");
INSERT INTO cakNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Raja' xuc'utuj chique: ¿Anchique ninojij rix chirij ri Cristo? Cuando raja' xtipe, ¿anchok ru-familia raja'? Y ri achi'a' fariseos xqui'ij: Ru-familia ri rey David, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Y ri Jesús xu'ij chique: ¿Pero anchique roma ri rey David xu'ij Wajaf che ri Cristo? Roma xa can xk'alajix che roma ri Espíritu Santo, y romari' can xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Ajaf Dios xu'ij che ri Wajaf ri Cristo: Cach'oquie-pe pa nu-derecha, y xquienya' chuxe' awakan ri itzel yetz'eto awichi. Quiri' xu'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Y ri rey David, xa Wajaf nicha' che ri Cristo, ¿anchique roma ni'ix chi ri Cristo xa choj jun ru-familia can ri rey David? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y man jun xu'ij ta apo jun tzij che ri Jesús, chirij ri Cristo ri xuc'utuj chique. Can ja' k'ij ri' cuando man jun chic xbano cowil chi c'o ta anchique ri nuc'utuj-apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Y Jesús ja' xch'o'n chiquiwech ri winak y chuka' chiquiwech ru-discípulos, raja' xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Pa ruq'uiexel ri Moisés, jec'o can ri achi'a' maestros chi ri ley y ri achi'a' fariseos. ");
INSERT INTO cakNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Romari' rix can quixniman chique. Can ronojel ri niqui'ij chiwe, tibana'. Pero man tiben anche'l niqui'en reje'. Roma reje' xa man yetiquier ta niqui'en ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Reje' nimalaj tak eka'n (aka'n) niquiya' chiquij ri winak, ri can yalan calal y can cuesta yec'uax. Ri eka'n (aka'n) ri' xe chiquij ri winak niquiya-wi y reje' man niquisiloj ta jun rui-quik'a' chi niqui'en ta o niquic'uaj ri eka'n (aka'n). ");
INSERT INTO cakNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ronojel ri niqui'en reje' xe chi quietz'et y quiena'ex coma ri winak chi ja ri utz ri niqui'en. Y can nika chiquiwech nitz'ibes juba' rutzij ri Dios chech jun tz'um y niquiya' chupa jun chic tz'um, y can nim niqui'en che y ja' niquiya' nic'aj-quiwech, chuka' can c'o jun chic niquiya' chiquik'a' chi tiquitzu' ri winak. Y chuka' más chawen niqui'en che rutz'abal ruchi' tak quitziak. ");
INSERT INTO cakNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Can ja chuka' ri na'ey tak ch'aquet niquicanoj pa nima'k tak wa'in y chuka' pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios, chi quiri' ti'ix chiquij chi reje' yalan quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Can yalan nika chiquiwech chi ye'an saludar ri anchi' niquimol-wi-qui' q'uiy winak. Y chuka' can yalan nika chiquiwech chi ni'ix can chique coma ri winak: Maestro, maestro, ye'uche'x, roma can c'o quik'ij yequitzu'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Pero rix man tirayij ni'ix maestro chiwe, roma xa can xe Jun ri utz ni'ix Maestro che, y ri' ja ri Cristo. Pero rix iwach'alal iwi' chi'iwonojel. ");
INSERT INTO cakNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Chuka' man roma ta chi ri winak c'o ruk'ij, roma ta ri' utz ni'ij katata' che. Man tiben quiri'. Roma ri Katata' xe Jun c'o pa kawi' konojel, y ri' ja ri Katata' ri c'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Can man tirayij chi ri winak niqui'ij wajaf chiwe. Roma xa can xe Jun ri Ajaf c'o y ri' ja ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Roma ri c'o más ruk'ij chi'icojol, can tuna-ka chi can manak ruk'ij y co'l oc tu'ona-ka chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj. ");
INSERT INTO cakNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Roma ri winak ri niquina' chi can c'o quik'ij, xa xtikases quik'ij. Pero ri niquina' chi can manak oc quik'ij, nim quik'ij xti'an chique. ");
INSERT INTO cakNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma xa can ik'aton quibey ri winak chi quiri' man ye'oc ta quiq'uin ri ye'an gobernar roma ri Dios. Can man utz ta ri ibanon, roma man jixoc ta apo rix y chuka' man niya' ta lugar chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma rix can nimaj ronojel ex quichi ri malca'n tak ixoki'. Y xe chi tinimex chi jabel ic'aslen, can jixlayoj niben orar. Y romari' can más nim ri castigo xtika pa iwi', roma can q'uiy ri imac. ");
INSERT INTO cakNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma rix can jixbe chiquicanoxic ri winak, más que nik'axaj mar y chuka' can jixbin parui' ri rech-ulef chi ye'icanoj winak chi jixquitzeklebej, y niquinimaj ta ri ninimaj rix. Pero cuando je'iwilon chic ri yetzekleben iwichi, can man utz ta niben chique; roma ri nic'ut chiquiwech, can niben chique chi niquiya' can ri Dios, can niben chique chi je richi ri k'ak' más que chiwech rix. ");
INSERT INTO cakNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","¡Juya' (Juyu') iwech rix ri jix-in chi jix uc'uey-bey y xa jix moy! Rix ri jix-in: Xa c'o jun ri nusiq'uij ri rocho ri Dios chi nu'on jurar, más que can man nu'on ta ri ru'in, can man jun rumac xtrakalej. Pero ri nu'on jurar pa rubi' ri oro ri c'o pa rocho ri Dios, can tu'ona' ri ru'in; y xa manak xtu'on, can c'o-wi mac xtrakalej. ");
INSERT INTO cakNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Rix can nic'ut-wi chi jix nacanak y chuka' jix moy, roma ¿anchique ri más c'o ruk'ij? ¿Ja como ri oro ri c'o pa rocho ri Dios o ja ri rocho ri Dios ri nibano che chi can richi ri Dios ri oro ri c'o chiri'? ");
INSERT INTO cakNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Rix chuka' ni'ij: Ri nusiq'uij ri altar chi nu'on jurar, más que can man nu'on ta ri ru'in, can man jun rumac xtrakalej. Pero ri nu'on jurar pa rubi' ri sipan can parui' ri altar, can tu'ona' ri ru'in; y xa manak xtu'on, can c'o-wi mac xtrakalej. ");
INSERT INTO cakNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Can jix nacanak y can jix moy-wi, roma ¿anchique ri más c'o ruk'ij? ¿Ja como ri sipan can parui' ru-altar ri Dios o ja ri altar? Ja ri altar ri más c'o ruk'ij, roma jari' ri nibano che ri sipan can chi can richi-wi ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ri nusiq'uij ri altar chi nu'on jurar, can ronojel xunataj, can xunataj ri altar y chuka' ri sipan can parui' ri altar. ");
INSERT INTO cakNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ri can nusiq'uij ri rocho ri Dios chi nu'on jurar, can ronojel nunataj, can nunataj ri rocho ri Dios y chuka' ri Dios, roma raja' can chiri' c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Y ri nusiq'uij ri rocaj chi nu'on jurar, can nunataj anchi' ch'ocol-wi ri Dios y can nunataj chuka' ri Dios roma raja' ch'ocol chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma hasta ri jubulaj tak k'ayis, ri quibinan menta, ri anís y ri comino ye'ich'up, y chitak-ba' chitak-ba' ye'ilesaj can chique chi ntoc i-diezmo chi niya' che ri Dios. Ronojel ri' can utz, pero iyo'n can ri más nic'atzin ri nu'ij chupa ri ley, chi utz tibana' quiq'uin ri winak, tijoyowaj quiwech ri ch'aka chic y can tiya' iwánima riq'uin ri Dios. Jari' ri más nic'atzin niben na'ey, c'ajari' quie'ibana' ri ch'aka chic ex. ");
INSERT INTO cakNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Rix jix-in chi jix uc'uey-bey, pero xa jix moy, nin-ij chiwe, chi rix xe ri más tak cocoj mandamientos ri niben y ri más je nimalaj man je'ibanon ta. ");
INSERT INTO cakNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","¡Can juya' (juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma xa jix anche'l lak ri jabel ch'ajch'oj quij pero ri quipa xa can tz'il. Rix can nic'ut chiquiwech ri winak chi can utz ri niben, pero pa iwánima man quiri' ta, roma xa nojinak riq'uin elak', y nojinak riq'uin itzel tak ex ri nirayij, roma rix can nirayij chi ronojel ri c'o quiq'uin ri winak iwiq'uin ta c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Rix fariseos xa jix moy. Can tibana' che ri ic'aslen anche'l jun lak ri can ch'ajch'oj rij y chuka' rupa. Can quiri' tibana'; tich'ajch'ojij ri iwánima na'ey chech ri Dios, chi quiri' ri ic'aslen can ketzij ch'ajch'oj chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri xa ca'i' ipalaj! roma xa jix junan riq'uin ri anchi' yo'n-wi jun caminak, ri rij sak y ch'ajch'oj, pero ri rupa man quiri' ta; xa ruyon man utz ta c'o chupa, xa ruyon rubakil caminak. ");
INSERT INTO cakNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Can jix quiri-wi. Can anche'l choj ri ic'aslen chiquiwech ri winak, pero pa iwánima xa man quiri' ta chech ri Dios. Ri iwánima xa nojinak riq'uin itzel tak ex. Y chuka' can ca'i' ipalaj. ");
INSERT INTO cakNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","¡Juya' (Juyu') iwech rix maestros chi ri ley y rix fariseos ri ca'i' ipalaj! roma jabel ye'iben quibanic ri xan anchi' je-mukun ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can. Rix can jabel-wi ye'iwak anchi' je-mukun-wi ri chojmilaj tak ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Y rix ni'ij: Xa ta roj xojc'ue' pa qui-tiempo ri kati't-kamama', roj manak ta xekato' cuando xequicamisaj ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios, jixcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Pero can ja rix ri jixk'alajin-ka chiwij chi jix qui-familia can ri xecamisan quichi ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can. ");
INSERT INTO cakNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Can tiq'uisa' ru'onic ri xquiticriba' can ri iwati't-imama'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Rix, xa anche'l jix itzel tak cumetz. ¿Can anchique modo ni'ij chi jixtiquier nicol-iwi' y man jixbe ta pa k'ak' roma ri itzel tak ex ri niben? Manak modo. Rix can pa k'ak' xquixapon-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Romari' ren xquientak chi'icojol, achi'a' ri yek'alajin ri nu'ij ri Dios chique, achi'a' ri yalan quino'j (quina'oj) y achi'a' je maestros. Pero rix jec'o chique ri nusamajel xquie'ibajij chech cruz chi ye'icamisaj, y jec'o ri xe quiri' xquie'icamisaj. Jec'o xquie'ich'ey pa tak sinagogas, ri jay anchi' nimol-iwi' chi nic'oxaj ri rutzij ri Dios; y xabachique (xama'anchique) tenemit yebe-wi reje', rix chuka' xquixapon chiri' roma ye'ikotaj, roma can itzel ye'itzu'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Y roma quiri' niben, ja rix jixwakalen quicamic conojel ri chojmilaj tak winak ri je-camisan; ri xtiquier-pe riq'uin ri rucamic ri chojmilaj achi xubinaj Abel c'a riq'uin ri rucamic ri achi xubinaj Zacarías, ri ralc'ual ri achi xubinaj Berequías. Y nin-ij chiwe, chi ri Zacarías can ja rix chuka' xixcamisan richi, chucojol ri rocho ri Dios y ri altar ri c'o chech rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ri xin-ij-ka chiwe, can ketzij-wi chi quiri' xtibanataj. Can ronojel-wi ri camic ri' xtiquikalej ri winak ri jec'o chupa ri tiempo re'. ");
INSERT INTO cakNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ri Jesús xch'o'n chiquij ri winak ri jec'o Jerusalem. Raja' xu'ij: Rix winak aj-Jerusalem, ¿anchique roma ye'icamisaj ri achi'a' ri yek'alajin ri ni'ix chique roma ri Dios? ¿Anchique roma chuka' ye'icamisaj che abaj ri yerutak-pe ri Dios chi'icojol? Ren, can q'uiy mej (paj) xinjo' xixinmol ta wiq'uin, anche'l nu'on jun ec' chique ri ral, yerumol chuxe' ri ruxic'. Pero rix man xijo' ta. ");
INSERT INTO cakNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Cami, ri iwocho can anche'l jun tz'iran rech-ulef xtu'on can. ");
INSERT INTO cakNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quiri' nin-ij chiwe, roma can man xquinitzu' ta chic. Y cuando xquinitzu' chic jun mej (bey), ja' cuando xti'ij chue: ¡Matiox chi petenak ri Jun re'! ¡Raja' can yo'n-pe bendición pa ruwi' roma ri Ajaf Dios! ¡Y petenak pa rubi' ri Ajaf Dios! xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Y cuando Jesús xel-pe chiri' pa rocho ri Dios chi nibe, ri ru-discípulos xebin-apo riq'uin y c'o ri xqui'ij chirij rocho ri Dios y can che quik'a' xquic'ut chech ri anchique ru'onic banon che. ");
INSERT INTO cakNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Pero Jesús xu'ij chique: Rix can nitzu' ri jay re' can jabel ru'onic banon che; pero can tinimaj ri nin-ij chiwe, chi xtapon jun k'ij cuando ronojel re' xquiewulix. Conojel ri nimalaj tak abaj ri je-cusan che ri jay re', xquietorix-pe y man jun abaj xtic'ue' can, anche'l rubanon cami, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Y cuando ri Jesús ch'ocol chic parui' ri juyu' rubinan Olivos, ri ru-discípulos xebe-apo riq'uin y xquic'utuj che: Ta'ij chake, ¿jampe' xtibanataj ri xa'ij yan ka chirij rocho ri Dios? ¿Anchique retal chi quiri' nina'ex chi jatzolaj yan pe? ¿Y anchique chuka' retal chi quiri' nina'ex chi napon yan ri ruq'uisbel k'ij chi ri tiempo re'? xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Y Jesús xu'ij chique ri ru-discípulos: Tibana' cuenta iwi' chi quiri' man jix-an ta engañar. ");
INSERT INTO cakNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Roma je q'uiy xquiepe, y xtiqui'ij: Ja ren ri Cristo ri takon-pe roma ri Dios, xquiecha'. Y je q'uiy ri xquiequi'en engañar. ");
INSERT INTO cakNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Y xtic'oxaj chi jec'o naciones niqui'en guerra. Y xtic'oxaj chuka' chi c'o guerras ri xquiepe. Pero man tixi'j-iwi', roma ronojel ri' xa can xquiebanataj na-wi. Pero man ja' yan ta ri' ri ruq'uisbel tak k'ij chi ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jec'o naciones xquiecataj chi niqui'en guerra quiq'uin ch'aka chic naciones. Jec'o chuka' nimalaj tak rech-ulef xquiecataj chi niqui'en guerra quiq'uin ch'aka chic nimalaj tak rech-ulef. Xquiepe yabil, xquiepe nimalaj tak wayjal y chuka' xquiepe silonel (cab-rakan) xabachique (xama'anchique) lugar che ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Y ronojel re' xa c'aja' oc ruticribel che ronojel ri sufrimientos ri xquiepe. ");
INSERT INTO cakNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Y rix xquixyo'x chupa ri sufrimiento roma itzel xquixtz'et, y jec'o chiwe rix ri can xquiecamises. Xa can itzel xquixtz'et coma conojel winak ri jec'o chech-ulef, roma rix can iyo'n iwánima wiq'uin ren. ");
INSERT INTO cakNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Je q'uiy can xquietzak pa quic'aslen chech ri Dios, y chuka' xtiquisujuj-qui' y jec'o itzel xtiquitzu-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Y xquiek'alajin-pe je q'uiy ri niqui'ij chi niquik'alajij ri nu'ij ri Dios chique, y roma can quiri' niqui'ij, can je q'uiy winak ri xquieka pa quik'a', roma ye'an engañar. ");
INSERT INTO cakNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Chuka' chupa ri tiempo ri', roma can yalan itzel no'j (na'oj) quiq'uin ri winak, je q'uiy ri man xtiquijo' ta chic qui', xa itzel xtiquitzu-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero ri can man xtitzolaj ta chirij y xtucoch' c'a pa ruq'uisbel che ronojel, can xticolotaj-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Pero can xtitzijos na ri utzilaj rutzij ri Dios ri nich'o'n chirij ri ru-gobierno ri Dios, y can xtitzijos na pa ronojel rech-ulef, chi quiri' ri winak tiquina'ej. Y c'ajari' xtoka ri ruq'uisbel k'ij chi ri tiempo re'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Y chuka' can xtapon-wi ri k'ij cuando c'o ex ri can je itzel xquiebanataj chupa ri lok'olaj lugar. Y riq'uin ri', can jumul xtiq'uis can ri lugar ri'. Jari' ri tz'iban can roma ri Daniel, jun chique ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can. Xabachique (Xama'anchique) winak ri nitz'eto ri tz'iban can, can tu'ona' entender ri nutzu'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Y cuando xtitzu' chi can quiri' yan yebanataj, ri winak ri jec'o pa Judea can quielumaj (quienimaj) y tiquiwewaj-qui' chech tak juyu'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ri xa nuxlan parui' ri rocho cuando xtapon ri hora ri', man toc chic apo pa jay chi c'o neruc'ama-pe, xa choj quiri' tilumaj-e (tinimaj-e). ");
INSERT INTO cakNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ri nisamaj pa k'ayis, man titzolaj chic chirocho chi neruc'ama-pe ruk'u'. Xa choj chuka' quiri' tilumaj-e (tinimaj-e). ");
INSERT INTO cakNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Can juya' (juyu') quiwech ri ixoki' ri ya ne'c'ue' cal cuando xtapon ri k'ij ri', quiri' chuka' ri ixoki' ri jec'o cal ri xa c'a yetz'uman (yeme'), roma manak xquietiquier xquielumaj-e (xquienimaj-e) ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Romari' can tibana' orar che ri Dios chi quiri' man tibanataj ri' pa ru-tiempo job o pa jun k'ij chi uxlanen, chi quiri' man cuesta ta nu'on chiwe chi jixlumaj (jixnimaj). ");
INSERT INTO cakNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Roma xtoka jun nimalaj sufrimiento we' chech-ulef ri man jun mej (bey) tz'eton chech-ulef desde que banon-pe roma ri Dios, ni xtoka chic jun mej (bey) ri sufrimiento ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y xa ta ri Dios man ta nu'on co'l che ri tiempo ri', conojel ta yecom. Pero roma ri Dios can yalan yerojo' ri jerucha'on chic, can xtu'on co'l che ri tiempo chi ri sufrimiento. ");
INSERT INTO cakNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Chupa ri k'ij ri', xa jec'o ri xquie'in chiwe: Titzu', ja Cristo re' ri takon-pe roma ri Dios; o niqui'ij chiwe: Titzu', ja Cristo la' ri takon-pe roma ri Dios; rix man tinimaj ri anchique niqui'ij chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Roma can jec'o ri xquiepe y xtiqui'ij: Ja ren ri Cristo ri takon-pe roma ri Dios. Pero rix man quie'inimaj, roma xa man ketzij ta ri niqui'ij. Y chupa ri tiempo ri' jec'o chuka' ri xquiepe y xtiqui'ij: Ren nink'alajij ri nu'ij ri Dios chue, xquiecha'. Pero rix man quie'inimaj, roma xa man ketzij ta ri yequi'ij chuka'. Reje' xquiequi'en nimalaj tak milagros ri man jun mej (bey) je-tz'eton, y ri' xe chi yequi'en engañar ri winak. Y reje' c'o ta niquijo' yequi'en engañar hasta ri je-cha'on chic roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Can ja' yan xin-ij can chiwe ri xquiebanataj. ");
INSERT INTO cakNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Romari', xa ni'ix chiwe: Ri Cristo xpe yan y cami ja' c'o pa tz'iran rech-ulef, man te'itzu'. Y xa ni'ix chiwe chi ri Cristo c'o chic y cami c'o pa jun jay, man tinimaj ri ni'ix chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Roma cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xquipe chic jun mej (bey), can xquik'alajin-wi jabel. Xa can xtibanataj anche'l nibanataj riq'uin ri relámpago ri can niraparo' anchi' ntel-wi-pe ri k'ij y k'alaj c'a anchi' nika-wi ri k'ij; can conojel-wi yetz'eto. Quiri' xtin-en ren. ");
INSERT INTO cakNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Can xtibanataj anche'l nibanataj quiq'uin ri c'uch. Roma anchi' c'o-wi jun caminak, chiri' chuka' yeka-wi ri chicop ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Y cuando can xek'ax yan ronojel ri sufrimiento chi ri tiempo ri', ri k'ij xtik'okumer, y ri ic' chuka' man xtuya' ta chic rusakil. Ri ch'umil can xquietzak-pe anchi' jec'o-wi. Can ronojel ri nimalaj tak uchuk'a' ri jec'o chicaj xquiesilon roma ri ruchuk'a' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Can ja ri chicaj xtitz'et-wi ri wetal ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. Conojel winak ri jec'o chech-ulef, xquie'ok' roma xtoka pa quiwi' chi yalan mac quibanon. Can xquie'ok' cuando xquinquitzu' chi ja ren ri yika-pe pa ajawa' (mukul) ri chicaj, riq'uin chic nimalaj wuchuk'a' y chuka' nimalaj nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Y ri trompeta xtik'ajan riq'uin jun nimalaj uchuk'a', y ren xquientak nu-ángeles chi yequimol ri jenucha'on chic. Can pa ronojel rech-ulef xquiequimol-wi. Can xquiequimol-wi conojel ri je-cha'on chic; más que xabachique (xama'anchique) lugar chi ri rech-ulef jec'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Can tic'ama' ino'j (ina'oj) chirij ri nu'on jun mata higo. Cuando can yejotayin-pe ri ruk'a' y ye'el-pe ri ruxak, iweta'n chi ri ru-tiempo job ya ntoc-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Y quiri' chuka' cuando xtitzu' chi yebanataj yan ronojel ri xin-ij yan ka chiwe, iweta'n c'a chi noka yan ri k'ij ri'. Can nakaj chic c'o-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Y tic'oxaj utz ri xtin-ij chiwe cami: Ronojel re' xquiebanataj cuando ri winak chi ri tiempo re' c'a man jani quieq'uis chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ri rech-ulef y ri rocaj can yeq'uis-wi. Pero ri nutzij man xtiq'uis ta quiri', xa can xtibanataj-wi ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Pero ri k'ij y ri hora cuando ren xquipe, man jun etamayon. Ri ángeles ri jec'o chicaj man quieta'n ta jampe'. Xa can xe ri Nata' Dios etamayon ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Xa can anche'l xbanataj pa ru-tiempo ri Noé, can quiri' chuka' xtibanataj cuando xquipe chic ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Roma pa ru-tiempo ri Noé, cuando c'a man jani tika ri nimalaj job, ri x-ix diluvio che; ri winak xa benak cánima chirij ri anchique niquitijla' y anchique ri niquikumula', can xe c'ulubic yequinataj; can xe ri' niquinojij, c'a xapon ri k'ij cuando ri Noé y ri ru-familia xe'oc chupa ri nimalaj arca, ri anche'l jun barco. ");
INSERT INTO cakNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Y ri winak manak xqui'en entender, c'aja' cuando xka ri nimalaj job ri x-ix diluvio che, y ri ya' can xerumuk conojel. Y can quiri' chuka' xtibanataj cuando xtapon ri k'ij chi xquipe ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ri k'ij ri', xa jec'o je ca'i' achi'a' ri junan yesamaj pa k'ayis, jun jinruniman y ri jun chic manak, xe ri jun ri jinruniman xtic'uax-e y ri jun chic xtic'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Y xa jec'o je ca'i' ixoki' ri junan yequie'n, xe ri jun ri jinruniman xtic'uax-e y ri jun chic xtic'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Romari' man timestaj chi yipe, xa can quiniyobej-apo, roma can man iweta'n ta jampe' xquipe ren ri jin Iwajaf. ");
INSERT INTO cakNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Roma rix iweta'n, xa ta ri rajaf jun jay nuna'ej jampe' napon jun elek'om pa rocho, ri rajaf-jay ri' nic'ase' chi nuchajij ri rocho, y man nuya' ta lugar chi ri elek'om ntoc-apo chi nelak'-e. ");
INSERT INTO cakNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Romari' rix can siempre tinaba-iwi' jabel, y can quiri' ta ibanon cuando xquinoka-ka ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, roma ren xquipe cuando rix man ja' ta ri' ninataj. ");
INSERT INTO cakNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Chupa ri k'ij ri', can xtibanataj anche'l ri nibanataj riq'uin jun rajaf-jay, raja' nuya' can jun rusamajel pa quiwi' ri jec'o pa racho chi nuya' ronojel ri nic'atzin chique chi niquitaj cuando napon ri tiempo. Y xa ri samajel ri' can nu'on ri bin can che y utz nu'on che ronojel ri samaj, ¿anchique como nu'on? ");
INSERT INTO cakNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ri samajel ri' can tiquicot ránima cuando nolitaj-ka roma ri rajaf y can najin riq'uin ri samaj ri bin can che. ");
INSERT INTO cakNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Can tinimaj ri nin-ij chiwe, chi ri rajaf ri samajel ri', can xtuya' parui' ronojel ri c'o riq'uin, chi nu'on cuenta. ");
INSERT INTO cakNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero xa ri samajel ri' itzel ta, y nu'ij ta ka pa ránima: Ri wajaf ri' xa manak yan xtoka, nicha' ta; ");
INSERT INTO cakNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y ruyon ja' yeruch'ey ri ch'aka chic samajel y chuka' can xe wa'in y tijoj-ya' nu'on quiq'uin ri k'abarela', ");
INSERT INTO cakNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","y jari' yeru'on cuando ri rajaf xtoka chupa jun k'ij y jun hora cuando raja' man ja' ta ri' nunataj. ");
INSERT INTO cakNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ri rajaf can xtuya-wi jun nim castigo che ri samajel ri', y xtuya' quiq'uin ri ch'aka chic ri xa ca'i' quipalaj. Y chiri' xe ok'ej xtu'on y can xtujach'ach'ej rey roma ri ruquiy (k'axon). ");
INSERT INTO cakNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Chupa ri k'ij cuando xquipe chic jun mej (bey), ri ru-gobierno ri Dios xtu'on anche'l ri xbanataj quiq'uin je lajuj xtani' ri xquic'uaj-e qui-lámparas chi xbequiyobej ri ala' ri nic'ule' ri ak'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Je wo'o' xtani' can c'o-wi quino'j (quina'oj), y je wo'o' chic xa can je nacanak. ");
INSERT INTO cakNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ri wo'o' xtani' ri je nacanak, xbequiyobej ri ala' ri xtic'ule', pero xa man xquic'uaj ta más qui-aceite chi niquinojisaj ri qui-lámparas; can xe ri c'o-e chupa ri qui-lámparas, xe ri' quic'uan. ");
INSERT INTO cakNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Pero ri wo'o' chic xtani' ri can c'o quino'j (quina'oj), xquic'uaj ri qui-lámparas y xquic'uaj chuka' qui-botellas quinojisan riq'uin aceite. Y reje' xbequiyobej ri ala' ri xtic'ule'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Y roma ri ala' ri nic'ule' yalan xlayoj y man napon ta, ri je lajuj xtani' ri quiyoben xa xpe quiwaran. Na'ey xeyuxcu'r-ka y can xpe ruchuk'a' ri waran, romari' xa can xewer-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ja la'k ri pa nic'aj ak'a' ri', xc'oxex chi c'o ri nisiq'uin y nu'ij: ¡Ja petenak ri ala' ri xtic'ule'. Can to'ic'ulu'! nicha'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Y ri je lajuj xtani' ri', ri quiyoben ri ala' ri xtic'ule', can ch'anin xuna' quiwech y xqui'en ru'onic ri qui-lámparas. ");
INSERT INTO cakNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Pero ri wo'o' xtani' ri je nacanak xqui'ij chique ri wo'o' chic xtani' ri can c'o-wi quino'j (quina'oj): Ri ka-lámparas xa can yechup roma xa man q'uiy ta chic aceite quic'uan. Tiya' juba' ka-aceite, xecha' ri xtani' ri je nacanak. ");
INSERT INTO cakNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Pero ri wo'o' chic xtani' ri can c'o-wi quino'j (quina'oj), xqui'ij: Cami ri más nic'atzin niben ja chi ilok'o' i-aceite anchi' nic'ayix-wi, roma xa roj nakaya' ri ka-aceite chiwe, man xquixru'on ta rix ni man xkojru'on ta roj. Romari' más utz ilok'o' i-aceite, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Y cuando ri wo'o' xtani' ri' xbequilok'o' ri aceite, ja' xoka ri ala' ri xtic'ule'. Ri wo'o' xtani' ri can jec'o-apo quiyoben ri ala' ri xtic'ule', xe'oc riq'uin ri ala' anchi' ni'an ri c'ulubic. Y cuando je-oconak chic apo conojel ri je-benak, xtz'apis can ri puerta. ");
INSERT INTO cakNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Y c'ajari' cuando xe'apon ri wo'o' chic xtani' ri xbequilok'o' aceite chi ri qui-lámparas, y reje' xech'o'n-apo che ri rajaf ri c'ulubic ri' y xqui'ij: Tajaka' ri puerta chakawech, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Y raja' xu'ij-pe chique ri xtani' ri': ¿Jix ancu'x (anchique) c'a rix? Ren can ketzij ri nin-ij chiwe, man weta'n ta iwech, xcha-pe chique. ");
INSERT INTO cakNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Romari' ri Jesús xu'ij: Man timestaj chi yipe, xa can quiniyobej-apo, roma can man iweta'n ta anchique k'ij, anchique hora cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xquipe chic jun mej (bey), xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Romari' ri winak ri ye'oc pa ru-gobierno ri Dios, can junan riq'uin ri xu'on jun achi cuando xbe naj. Raja' xeroyoj ri rusamajel y xuya' can ri rubeyomal pa quik'a'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Pa ruk'a' jun rusamajel xuya' can wo'o' mil quetzales, pa ruk'a' jun chic xuya' can ca'i' mil, y pa ruk'a' ri jun chic xuya' can jun mil. Raja' jari' xuya' can chique, roma xutzu' chi jari' yetiquier niquisamajij chiquijunal. Y can xe xu'on can quiri', ja xbe. ");
INSERT INTO cakNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Y ri samajel ri xyo'x can wo'o' mil quetzales pa ruk'a' chi tusamajij, can xu'on na-wi ri anche'l bin can che. Raja' can xusamajij-wi ri mero y xuch'ec chic wo'o' mil más chirij. ");
INSERT INTO cakNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Y quiri' chuka' xu'on ri jun chic samajel ri xyo'x can ca'i' milquetzales pa ruk'a', raja' can xuch'ec ca'i' chic mil más chirij. ");
INSERT INTO cakNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Pero ri rox samajel ri xe jun mil ri xyo'x can che, xa xberuc'oto' jun jul pa ulef y chiri' xumuk-wi ri mero. ");
INSERT INTO cakNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Y k'axinak chic q'uiy k'ij, xtzolaj-pe ri achi ri qui-patrón ri samajel ri'. Y raja' xuc'utuj chique anchique xqui'en che ri mero ri xuya' can chique cuando xbe. ");
INSERT INTO cakNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Cuando xapon ri samajel ri xyo'x can ri wo'o' mil quetzales pa ruk'a', can man xe ta ri' ri ruc'uan-apo, xa can ruc'uan-apo wo'o' mil más y xu'ij che ri achi ru-patrón: Ret wo'o' mil quetzales xaya' can pa nuk'a'; ja c'o re', y ja chuka' c'o re' wo'o' mil más ri xinch'ec chirij, xcha' ri samajel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Y ri ru-patrón xu'ij che: Utz ri xa'an. Ret, jat jun utzilaj nusamajel, can na'an ri ni'ix chawe. Y roma can utz xa'an riq'uin ri juba' xinya' can pa ak'a' cuando xibe, cami xcatinya' parui' jun samaj más nim. Can catampe y caquicot chuka' wiq'uin, xuche'x ri samajel. ");
INSERT INTO cakNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Cuando xapon chuka' ri samajel ri xyo'x can ri ca'i' mil quetzales pa ruk'a', raja' xu'ij che ri achi ri ru-patrón: Ret ca'i' mil quetzales xaya' can pa nuk'a'; ja c'o re', y ja chuka' c'o re' ca'i' mil más ri xinch'ec chirij, xcha' ri samajel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ri ru-patrón xu'ij che: Utz ri xa'an. Ret, jat jun utzilaj nusamajel, can na'an ri ni'ix chawe. Y roma can utz xa'an riq'uin ri juba' xinya' can pa ak'a' cuando xibe, cami xcatinya' parui' jun samaj más nim. Can catampe y caquicot chuka' wiq'uin, xuche'x ri samajel. ");
INSERT INTO cakNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Pero cuando xapon chuka' ri samajel ri xyo'x can ri jun mil quetzales pa ruk'a', raja' xu'ij che ri ru-patrón: Ren can weta'n-wi ano'j (ana'oj), y romari' weta'n chi ret ronojel nach'ojij y ronojel najal chi ayowal. Ret najo' namol ri cosecha ri xa man ja ret ta ri jat-tiquiyon. Najo' nayec ri trigo ri xa man ja ret ta ri xach'eyo. ");
INSERT INTO cakNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Y romari' ren xinxi'j-wi' xinsamajij ri a-mero. Y can xe xajach can chue, ja' xinc'ot jun jul pa ulef y chiri' xinmuk-wi. Y ja a-mero c'o re', ja' ninjach chic chawe, xcha' ri samajel ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Y ri ru-patrón xu'ij: Man utz ta ri xa'an. Roma ret jat jun itzel samajel, y jat k'or, man na'an ta ri ni'ix chawe. Xa can aweta'n chi ren ninjo' ninmol ri cosecha ri man ja ren ta jin-tiquiyon y ninjo' ninyec ri trigo ri xa man ja ren ta xich'ayon; ");
INSERT INTO cakNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xa aweta'n chi jin quiri', xaya' ta ri nu-mero pa banco y cami ri xitzolaj-pe nenc'ama' ta pe ri nu-mero junan riq'uin ri interés ri ruch'acon. ");
INSERT INTO cakNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Cami timaja' can ri mero chuk'a' y tiya' che ri nusamajel ri c'o lajuj mil quetzales riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Roma ri can c'o-wi c'o riq'uin, xtiyo'x más che y can q'uiy xtu'on-ka riq'uin. Pero ri xe juba' c'o riq'uin, ri juba' oc ri c'o riq'uin can xtimaj can che. ");
INSERT INTO cakNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Y ri samajel ri xa can man jun nic'atzin-wi, iq'uiaka' pa k'eku'm, ri anchi' ruyon ok'ej xtu'on y chuka' xtujach'ach'ej rey. ");
INSERT INTO cakNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Y cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xquipe chic jun mej (bey), can c'o chic nuk'ij xquipe; y chuka' can conojel nu-ángeles xquiepe wiq'uin. Y ren xquich'oquie' pa nu-trono ri can c'o ruk'ij y xtin-en gobernar. ");
INSERT INTO cakNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Can xquiemol ri winak chinuech chi ronojel rech-ulef. Y ren can xquiencha' conojel, anche'l nu'on jun achi ri yeruchajij awaj; raja' juc'an yeruya-wi ri ovejas, y juc'an chic yeruya-wi ri cabras. ");
INSERT INTO cakNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ri winak ch'ajch'oj chic quic'aslen, jari' je anche'l ovejas, xquienya' pa nu-derecha. Pero ri winak ri man utz ta ri quic'aslen, jari' ri je anche'l cabras, xquienya' pa nu-izquierda. ");
INSERT INTO cakNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Y ja' xtu'ij ri Rey chique ri jec'o pa ru-derecha: Can quixampe rix, can c'o chic ri ru-bendición ri Nata' Dios pa iwi'. Can quixoc anchi' ja ri Dios nibano gobernar. Jare' ri lugar ri runaban raja' chiwe cuando c'a man jani c'o ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Roma cuando ren xnum nupa, rix can c'o xiya' chue chi xintaj. Cuando ren xchake'j nuchi', rix c'o xiya' chue chi xinkum. Xc'atzin nu-posada y rix xiya'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cuando xq'uis jumul nutziak chuij, rix can c'o xiya' chue. Cuando ren xiyawaj, xiniben visitar. Cuando xitz'ape' pa cárcel, xixapon wiq'uin, xticha' ri Rey. ");
INSERT INTO cakNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Y ri winak ch'ajch'oj chic quic'aslen xtiqui'ij: Ajaf, ¿jampe' ri c'o xkaya' chawe chi c'o xataj? Xa man xatkatzu' ta chi xnum apa. ¿Jampe' ri c'o xkaya' chawe chi xakum roma xchake'j achi'? ");
INSERT INTO cakNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Y jampe' xkaya' a-posada roma xc'atzin chawe? ¿Jampe' xkaya' atziak roma man jun nacusaj? ");
INSERT INTO cakNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampe' xojapon awiq'uin roma xayawaj? ¿Y jampe' chuka' xojapon awiq'uin roma jatc'o pa cárcel? xquiecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Y ri Rey xtu'ij: Can tinimaj ri nin-ij chiwe, roma quiri' xiben riq'uin ri wach'alal ri can manak oc ruk'ij ri can richi-wi chic ri Dios, xa can chue ren xiben-wi ri favor ri', xticha' ri Rey. ");
INSERT INTO cakNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Y ja' chuka' xtu'ij ri Rey chique ri jec'o pa ru-izquierda: Rix xe chic ri castigo ri iyoben chi nika pa iwi'. Quixel-e chinuech y jix (quixbin) c'a pa k'ak' ri can manak xtichup, y ri k'ak' ri' naban chic chi ri itzel y ri ru-ángeles. ");
INSERT INTO cakNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Roma ren xnum nupa y man jun ri xiya' chue chi xintaj. Can xchake'j nuchi' y rix man jun xiya' chue chi xinkum. ");
INSERT INTO cakNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Roma ren xinjo' nu-posada y rix xa man xiya' ta chue. Cuando jumul xq'uis nutziak chuij, rix man jun xiya' chue chi xincusaj. Cuando xiyawaj, man xixapon ta wiq'uin; y quiri' chuka' cuando xic'ue' pa cárcel, man xixapon ta wiq'uin, xticha' ri Rey chique. ");
INSERT INTO cakNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Y reje' chuka' xtiqui'ij: Ajaf, roj man jun mej (bey) xatkatzu' chi xacoch' ta apa o xchake'j ta achi', o xac'utuj ta a-posada, o man jun ta atziak, o xayawaj ta, o xac'ue' pa cárcel. Roj manak xatkatzu' chi quiri' ta xac'ulumaj, romari' can man jun-wi favor xka'an chawe, xquiecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Y ri Rey xtu'ij chique: Can ketzij-wi ri nin-ij chiwe chi roma man jun favor xiben chique ri wach'alal ri can manak oc quik'ij, ri jec'o-pe wiq'uin, xa can man jun chuka' favor xiben chue ren. ");
INSERT INTO cakNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Y ri winak ri' can xquiebe-wi chupa ri castigo ri manak xtiq'uis. Y ri winak ch'ajch'oj chic ri quic'aslen xtiyo'x jun c'aslen ri manak xtiq'uis chique. Quiri' ri xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Cuando ri Jesús ru'in chic ka ronojel ri', raja' xch'o'n chique ri ru-discípulos y xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Rix can iweta'n-wi chi pa ca'i' apo k'ij c'o ri kanimak'ej ri rubinan pascua. Chupa ri nimak'ej ri' cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can xquijach-wi-e chi yibajix chech cruz chi xquicom, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Y ja tiempo ri' ri nimalaj tak sacerdotes, ri maestros chi ri ley y chuka' ri rijilaj tak achi'a' ri yalan quik'ij chiquicojol ri winak, can quimolon-wi-qui' chojay, chirocho ri sacerdote ri más c'o ruk'ij ri rubinanCaifás. ");
INSERT INTO cakNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Reje' xquiya' chiquiwech anchique engaños xquiequicusaj chi nika ri Jesús pa quik'a', y niquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Pero chuka' can xqui'ij: Man takatz'om chupa ri nimak'ej re', chi quiri' manak xquiecataj-pe ri winak chakij. ");
INSERT INTO cakNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Y ri Jesús c'o pa tenemit rubinan Betania, pa rocho ri Simón ri xc'achoj riq'uin ri ruyabil rubinan lepra. ");
INSERT INTO cakNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Y ja' xapon jun ixok riq'uin ri Jesús, ruc'uan-apo jun frasco ri banon riq'uin jun abaj ri ni'ix alabastro che, y c'o-e jun jubulaj ak'om chupa; ri ak'om re' can yalan rajil; y jari' xuya' pa rujolon ri Jesús, cuando raja' niwa' ch'ocol chuchi' mesa pa rocho ri Simón. ");
INSERT INTO cakNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Cuando ri discípulos xquitzu' ri xu'on ri ixok riq'uin ri jubulaj ak'om chi xuya' pa rujolon ri Jesús, xpe quiyowal y xqui'ij: ¿Anchique roma xe choj quiri' xutix la jubulaj ak'om la'? ");
INSERT INTO cakNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Roma la jubulaj ak'om la' can yalan rajil, xc'ayix ta; y ri rajil xa xjach ta chique ri winak ri man jun quibeyomal, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Pero ri Jesús ch'anin xuc'oxaj ri niqui'ij ri ru-discípulos, romari' raja' xu'ij chique: ¿Anchique roma man jixtane' ta ka jixtzijon chirij ri ixok re'? Xa tiya' can. Raja' can utz xu'on wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri winak ri man jun quibeyomal xa can siempre jec'o iwiq'uin, chi quiri' xabachique (xama'anchique) k'ij niben favor chique. Pero ren man siempre ta xquic'ue' iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Roma ri ixok re' xuk'aj chuij ri jun jubulaj ak'om re', can xuc'ut chi can yalan yirojo'. Raja' xu'on yan chue anche'l ni'an chique ri caminaki' cuando yebemuk. ");
INSERT INTO cakNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Y tic'oxaj na pe' jabel ri xtin-ij chiwe, chi xabachique (xama'anchique) lugar anchi' xtitzijos-wi ri utzilaj rutzij ri Dios, chiri' chuka' xtitzijos-wi ri xu'on ri jun ixok re'. Can pa ronojel rech-ulef xtitzijos-wi, y man jun mej (bey) xtimestes, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Y jun chique ri cablajuj ru-discípulos ri Jesús, ri discípulo ri rubinan Judas Iscariote, xapon quiq'uin ri nimalaj tak sacerdotes. ");
INSERT INTO cakNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Raja' xberu'ij chique: ¿Anchique ri niya' chue, xa ren ninjach ri Jesús pa ik'a'? xcha' chique. Y ri nimalaj tak sacerdotes xqui'ij chi niquiya' treinta monedas de plata che. ");
INSERT INTO cakNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Y ja k'ij ri', ri Judas Iscariote xutz'om rucanoxic anchique modo nu'on chi nujach ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Y ja chupa ri na'ey k'ij chi ri nimak'ej ri', cuando nitej chuka' ri pan ri manak levadura riq'uin, ri discípulos xbequic'utuj che ri Jesús: ¿Anchi' najo' na'an-wi ri wa'in chupa ri jun pascua re', chi quiri' nakanaba' ronojel ri nic'atzin? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Y jec'o chique ri discípulos ri xetak-e roma ri Jesús c'a pa tenemit Jerusalem, pa rocho jun achi, y x-ix-e chique chi cuando xquie'apon, tiqui'ij che: Ri Maestro ru'in-pe chake: Ri nu-tiempo xa nakaj chic c'o-wi. Y ja pa awocho ret ninjo' nin-en-wi ri wa'in chi ri pascua re' junan quiq'uin ri nu-discípulos, quixcha' can che, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Y ri discípulos can xqui'en-wi anche'l ri bin-e chique roma ri Jesús. Reje' can xquinaba-wi ronojel ri nic'atzin chique chi ri pascua ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Cuando xcok'a-ka, ri Jesús y ri cablajuj ru-discípulos xebech'oquie' chuchi' mesa chi ri wa'in. ");
INSERT INTO cakNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Y cuando niqui'en ri wa'in, ri Jesús xu'ij: Can ketzij nin-ij chiwe, chi jun chiwe rix ri xtijacho wichi pa quik'a' ri winak ri man jinquijo' ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Y ri discípulos yalan xebison-ka cuando xquic'oxaj ri xu'ij ri Jesús chique, y chiquijunal xquic'utuj-apo che: Ajaf, ¿ja como ren ri xquibano quiri'? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Y ri Jesús ja' xu'ij chique ri ru-discípulos: Ri jun ri xtumuba-pe ru-pan wiq'uin pa plato, jari' ri xtijacho-e wichi pa quik'a' ri winak ri man jinquijo' ta. ");
INSERT INTO cakNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Can tic'oxaj chuka' ri xtin-ij chiwe, ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can xquicamises. Can xtibanataj-wi anche'l ri tz'iban can chupa rutzij ri Dios. Pero juya' (juyu') rech ri xtijacho wichi, ri achi ri xtijacho-e wichi más utz man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Y xch'o'n-apo ri Judas, ri xtijacho richi ri Jesús; y ri Judas xu'ij: Maestro, ¿ja como ren ri xquijacho awichi? xcha'. Y ri Jesús xu'ij: Ja', ja ret, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Y cuando c'a ye'ajin riq'uin ri wa'in, ri Jesús xuc'on-apo jun pan y xuya' matiox che ri Dios, xuper ri pan y xuya' chique ri ru-discípulos. Raja' xu'ij chique: Tic'ama' y titija' ri pan re'. Roma jare' ri nuch'acul ri xtapon pa camic. ");
INSERT INTO cakNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Y ri Jesús xuc'on-apo chuka' ri vaso ri c'o ruya'al-uva chupa, y xuya' matiox che ri Dios, c'ajari' xuya' ri vaso chique ri ru-discípulos y xu'ij chique: Tikumu' chi'iwonojel ri ruya'al-uva ri c'o chupa ri vaso re'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Roma jare' ri nuquiq'uiel ri xtibin cuando xquicamises. Can xtibin-wi ri nuquiq'uiel, chi quiri' je q'uiy ri nicoch'otaj (nicuyutaj) quimac. Riq'uin ri nuquiq'uiel, can ja' xtic'achoj ri c'ac'ac' trato ri rurayin-pe ri Dios chi nu'on quiq'uin ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Can nin-ij chiwe chi ja ruq'uisbel mej (paj) re' xinkum-e ri ruya'al-uva. Y c'aja' cuando jinc'o chic pa ru-gobierno ri Nata' Dios, c'ajari' xtinkum chic jun mej (bey) ri ruya'al-uva ri' junan iwiq'uin rix. Y chiri' xtakakum jun c'ac'ac' ruya'al-uva, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Y cuando quibixan chic ri bix chi niquiya' ruk'ij ri Dios, ri Jesús y ri ru-discípulos xe'el-e chiri' pa jay y xebe chech ri juyu' rubinan Olivos. ");
INSERT INTO cakNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Y cuando je-benak, ri Jesús xu'ij chique ri ru-discípulos: Chi'iwonojel rix xtitaluj-e-iwi' y xquiniya' can nuyon chupa ri nok'ok'a' re', cuando xtitzu' chi ren yijach-e pa quik'a' ri winak. Roma ri Dios can nu'ij-wi chupa ri tz'iban can: Cuando ren xtinya' lugar chi nicamises ri nichajin quichi ri ovejas, ri ovejas ri' xtiquitaluj-e-qui'. Quiri' ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Pero ren ri jin Quichajinel ri ovejas ri' man xquicom ta jumul, xa xquic'astaj-pe. Y can xquixinyobej chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Y ri Pedro can ja' xch'o'n-apo che ri Jesús y xu'ij: Xa ri ch'akachic jatquiya' can ayon cuando xtiquitzu' chi c'o ri nac'ulumaj, ja reje' ri', pero ren can man xcatinya' ta can, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Pero ri Jesús xu'ij che ri Pedro: Ren can ketzij nin-ij chawe, chi chupa ri ak'a' re', xa c'a man jani titzirin-pe (tisiq'uin-pe) ri gallo cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Y ri Pedro xu'ij che: Más que can yicom ta awiq'uin, can manak xtin-ij chi ren man weta'n ta awech, xcha' ri Pedro. Y can conojel ri ru-discípulos quiri' chuka' xqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ri Jesús y ri ru-discípulos xe'apon pa jun lugar rubinan Getsemaní. Y ri Jesús xu'ij chique ri ru-discípulos: Quixch'oquie' can juba' we', roma ren xa yibe-apo juba' chila' chi nenbana' orar, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Raja' xe ri Pedro y ri je ca'i' ralc'ual ri achi rubinan Zebedeo ri xeruc'uaj riq'uin, raja' can jun nimalaj bis xpe pa ránima roma nuna' yan ri xteruc'ulumaj. ");
INSERT INTO cakNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Romari' xu'ij chique ri je oxi' ru-discípulos: Ri wánima yalan nibison; can yirucamisaj ninna'. Quixc'ue-pe wiq'uin, quixc'ase' y man quixwer-ka, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Raja' xbin chic apo juba' y chiri' xxuquie-wi-ka, y can xukasaj-ka ri nic'aj-rech c'a chech-ulef chi xu'on orar; y quiere' xu'ij: Nata' Dios, xa c'o modo, can quinacolo' chech ri sufrimiento ri c'o chupa ri copa ri ayo'n chue; pero man ta'an ri ninrayij ren, roma ren can ninjo' chuka' nin-en ri narayij ret, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Y cuando raja' xc'achoj riq'uin ri oración, xoka quiq'uin ri je oxi' ru-discípulos, pero reje' xa yewer. Xpe raja' xu'ij che ri Pedro: ¿Can man xixtiquier ta xixc'ase' jun hora oc wiq'uin? ");
INSERT INTO cakNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Man quixwer-ka, xa tibana' orar y tic'utuj che ri Dios chi cuando jixtojtobex, man quixtzak pa mac. Ren can weta'n-wi chi ri iwánima can nurayij nu'on ri nrojo' ri Dios. Pero iyon rix can man jixtiquier ta, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Y ri Jesús xbe chic apo chi xberu'ona' orar ruca'n mej (paj), y nu'ij: Nata', xa manak modo yinacol chech ri sufrimiento, can tik'ax c'a pa nuwi'; ren can ninjo' nin-en ri narayij ret, quiri' nu'ij pa ru-oración. ");
INSERT INTO cakNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Y cuando raja' xpe chic jun mej (bey) quiq'uin ri je oxi' ru-discípulos, yewer chic jun mej (bey) ri xeril, roma ri discípulos ri' man niquicoch' ta chic quiwaran. ");
INSERT INTO cakNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ri Jesús xeruya' chic can jun mej (bey) y xbe chic chi xberu'ona' orar; ja rox mej (paj) ri xberu'ona' orar. Ri tzij ri xeru'ij, can ja ri jeru'in chic chupa ri oración. ");
INSERT INTO cakNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Y c'ajari' ri Jesús xpe quiq'uin ri je oxi' ru-discípulos, y xu'ij chique: Cami can quixwer y tiq'uisa' ri iwaran; ja' xoka ri hora chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can xquijach-e pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Quixcataj. Ja' petenak ri xtijacho wichi pa quik'a' ri itzel tak achi'a', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Y ri Jesús can c'a nich'o'n quiq'uin ri ru-discípulos, can ja' xokari Judas ri jun chique ri cablajuj ru-discípulos; raja' jeruc'uan-apo q'uiy winak ri jequic'ualo'n-apo che' y espadas. Conojel re' je-takon-e coma ri nimalaj tak sacerdotes y coma chuka' ri rijilaj tak achi'a' ri c'o quik'ij chiquicojol ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ri Judas ri nijacho-e richi ri Jesús can ru'in yan pe chique ri je-petenak riq'uin anchique retal xtu'on chi nuc'ut ri Jesús chiquiwech. Raja' can ru'in-pe chique: Ja ri jun ri xtintz'ubaj, jari' ri Jesús, titz'ama' y tic'uaj. ");
INSERT INTO cakNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Y ri Judas can ja' xbe-apo riq'uin ri Jesús y xu'ij: Xcok'a' (Chok'a') Maestro, xcha' che. Y xutz'ubaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Xpe ri Jesús xu'ij che ri Judas: ¿Anchique ri najo' na'an? xcha' che. Y ri winak can ja xebe riq'uin ri Jesús y xquitz'om. ");
INSERT INTO cakNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Y jun chique ri jec'o riq'uin ri Jesús chiri', can ja' xulesaj ri ru-espada y xusoc ri jun rusamajel ri sacerdote ri más c'o ruk'ij. Can ja ri ruxiquin ri xukupij. ");
INSERT INTO cakNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Y ri Jesús xu'ij che ri xbano quiri': Tayaca' la a-espada. Roma ancu'x (anchique) ri can riq'uin espada nicamisan, can riq'uin espada chuka' xticamises. ");
INSERT INTO cakNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Ret nanojij chi ren man jun nitz'eto-pe wichi? Xa ta ren ninc'utuj che ri Nata' Dios chi quiruto', raja' yerutak ta pe más setenta y dos mil ángeles chi jinquito'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","¿Pero anchique c'a modo nibanataj ri je-tz'iban can chupa rutzij ri Dios? Romari' man nic'atzin ta chi yepe ta ri ángeles chi jinquito', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Y chuka' chupa ri hora ri' ri Jesús xu'ij chique ri winak: ¿Anchique xinojij rix? ¿Xinojij chi jun elek'om nitz'om-e, romari' ic'amon-pe che' y espadas? Can k'ij-k'ij xich'oquie' iwiq'uin pa rocho ri Dios cuando xinc'ut rutzij ri Dios chiwech, y man xinitz'om ta. ");
INSERT INTO cakNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ronojel ri nibanataj cami, xe chi nibanataj ri tz'iban can chupa rutzij ri Dios coma ri achi'a' ri xek'alajin ri rutzij ojer can. Y ri discípulos can ja' xelumaj-e (xenimaj-e) y ruyon oc xquiya' can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xebetz'amo-pe ri Jesús pa Getsemaní, xquic'uaj c'a riq'uin ri Caifás ri sacerdote ri más c'o ruk'ij, anchi' quimolon-wi can qui' ri maestros chi ri ley y ri rijilaj tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Y ri Pedro c'a naj c'o-wi can, jerutzekleben-e, y xoc chuka' chirocho ri sacerdote ri más c'o ruk'ij y xc'ue-ka chojay. Cuando raja' c'o chic chiri', xch'oquie-apo chiquicojol ri samajel ri jec'o chiri', chi nutzu-apo anchique xtuc'ulumaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Y ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij y conojel ri achi'a' je autoridad quichi ri israelitas, can niquitaj quik'ij chi jec'o ta jujun winak yequiwil chi niquitz'uc tzij chirij ri Jesús, chi quiri' nicamises. ");
INSERT INTO cakNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Y más que can je q'uiy ri xe'apon ri xquitz'uc tzij chirij, xa can man jun ruchuk'a' ri tzij ri xqui'ij-apo. Xa c'a pa ruq'uisbel xe'apon je ca'i' chi niquitz'uc tzij y can junan ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ri je ca'i' ri' xqui'ij: Ri achi re' ru'in: Ren yitiquier ninwulij (ninwulaj) rocho ri Dios y pa oxi' k'ij ninpoba' chic jun mej (bey). Quiri' ru'in, xecha' ri je ca'i' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Y ri Caifás, ri sacerdote ri más c'o ruk'ij, xbepa'e-pe y xu'ij cheri Jesús: ¿Anchique na'ij cami? ¿Ketzij la xqui'ij-ka chawij? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Pero ri Jesús man jun tzij xu'ij. Y ja' cuando ri sacerdote ri más c'o ruk'ij xu'ij che: Can chech ri c'aslic Dios ta'ij chake xa ja ret ri Cristo ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Y ri Jesús xu'ij che: Ja', ja ren ri Cristo; y chuka' can nin-ij chiwe chi ri chakawech apo can xquinitzu' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, chi jin-ch'ocol pa ru-derecha ri Dios ri nitiquier nu'on ronojel. Y xquinitzu' cuando yika-pe pa ajawa' (mukul) ri chicaj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Xpe ri Caifás ri sacerdote ri más c'o ruk'ij, xuretz-ka ri rutziak chirij roma itzel xuc'oxaj, y xu'ij: Man nic'atzin ta chi noka jun chic chi noru'ij chake chi ri Jesús can c'o rumac. Rix xic'oxaj ri xu'ij, chi ja raja' ri Cristo ri takon-pe roma ri Dios. Ri' can itzel chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Y anchique naka'an cami ninojij rix? xcha' raja'. Y ri ch'aka chic ri quimolon-qui' chiri' xqui'ij: Can c'o rumac; romari' utz chi ticamises, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Y xquichubala' rupalaj ri Jesús y xquich'ey, y jec'o chuka' ri xquipak' rupalaj. ");
INSERT INTO cakNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Chuka' xqui'ij che ri Jesús cuando quitz'apin rech: Xa ja ret ri Cristo, ta'ij chake ancu'x (anchique) ri yech'ayo awichi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ri Pedro ch'ocol chojay. Y ja' c'o jun ixok raj-ic' ri sacerdote ri más c'o ruk'ij xapon-apo riq'uin y xu'ij che: Ret chuka' jat jun chique ri jec'o riq'uin ri Jesús ri aj-Galilea, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pero raja' xa can chiquiwech conojel xrewaj-wi, roma xu'ij: Man nin-en ta entender anchique roma quiri' na'ij chue, xcha' che ri aj-ic'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Y cuando raja' ya ntel-e chi puerta, c'o chic jun ixok aj-ic' ri xtz'eto richi y xu'ij chique ri jec'o-apo chiri': Ri jun achi re' can c'o-wi chuka' riq'uin ri Jesús ri aj-Nazaret, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pero ri Pedro xa xrewaj chic jun mej (bey). Raja' xu'ij: Chech Dios nin-ij chi ren man weta'n ta rech ri jun achi ri', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","C'a juba' chic ri', ja ri quimolon-qui' chiri' xebin-apo riq'uin ri Pedro y xqui'ij che: Can ketzij-wi chi ret jat jun chique ri jec'o riq'uin ri Jesús. Xe riq'uin ri jach'o'n, can k'alaj chi can quiri-wi, roma ri aj-Galilea can quiri-wi yech'o'n, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pero ri Pedro xu'ij: Ren man weta'n ta rech ri achi ri'. Can chech Dios nin-ij-wi chiwe chi ren man weta'n ta rech. Y xa man ketzij ta ri nin-ij, tika ri castigo ri xtuya' ri Dios pa nuwi', xcha'. Y ja' xtzirin-pe (xsiq'uin-pe) ri gallo. ");
INSERT INTO cakNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Y ri Pedro xeloka pa ruwi' ri tzij ri jeru'in can ri Jesús che, chi c'a man jani titzirin-pe (tisiq'uin-pe) ri gallo cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech. Y ri Pedro xel-e chiri' y xujik' ok'ej. ");
INSERT INTO cakNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Y cuando xsakar-pe, conojel ri nimalaj tak sacerdotes y ri rijilaj takachi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, xquimol-qui' chi niquinojij anchique niqui'en chi niquicamisaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Y ja xquixim-e y xbequijacha' pa ruk'a' ri Poncio Pilato, ri gobernador. ");
INSERT INTO cakNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Cuando ri Judas xutzu' chi ri Jesús xa xuc'uax chech ri Pilato chi nika ri camic pa ruwi', c'ajari' xpe ruquiy (xk'axon) ránima roma ja raja' ri xc'ayin richi ri Jesús; romari' xberutzolej can ri treinta monedas de plata chique ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ri Judas xu'ij chique ri achi'a' ri': Ren mac ri xin-en, roma xinc'ayij ri Jesús pa ik'a'; raja' manak rumac, xcha' chique. Pero ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij, xa xqui'ij che ri Judas: ¿Anchique keta'n roj chirij ri'? ¡Tatzu' ret anchique na'an! xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Xpe raja' xutorij can ri mero chiri' pa rocho ri Dios; y ja' xbe y xberujitz'aj-ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Y ri nimalaj tak sacerdotes xquimol ri mero y xqui'ij: Ri mero re' man utz ta chi nakaxol-ka riq'uin ri mero chi ri rocho ri Dios, roma ri mero re' xa rajil ri rucamic jun winak. ");
INSERT INTO cakNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Cuando xquiya' yan chiquiwech anchique niqui'en riq'uin ri mero ri', reje' xquilok' jun ulef; ri ulef ri rubinan Richi ri Banoy-Bojo'y; ri ulef ri' xtic'atzin chi yemuk ri winak ri man je israelitas ta. ");
INSERT INTO cakNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Romari' ri jun ulef ri' can c'a ni'ix Ulef richi Quic' che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Y roma ri x-an chiri', can xbanataj-wi ri ru'in can ri Jeremías, ri jun achi ri xuk'alajij ri x-ix che roma ri Dios ojer can. Raja' ru'in can: Ri je ru-familia can ri Israel xquic'on-e ri treinta monedas de plata. Jari' ri mero ri xquiya' roma xqui'ij chi jari' rajil ri rusamajel ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y riq'uin ri mero ri' xquilok' ri ulef ri rubinan Richi ri Banoy-Bojo'y, can anche'l ru'in ri Ajaf chue. Quiri' ri ru'in can ri Jeremías. ");
INSERT INTO cakNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Y cuando ri Jesús c'o chic apo chech ri Pilato, ri gobernador, ri Pilato xuc'utuj che ri Jesús: ¿Ja ret ri qui-Rey ri israelitas? xcha' che. Y ri Jesús xu'ij: Ja', can quiri-wi, anche'l ri xa'ij, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Y cuando ri Jesús yalan ni'ix-apo chirij chi nisujus coma ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij, raja' can man jun tzij ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Romari' ri Pilato xu'ij che ri Jesús: ¿Can manak como nac'oxaj ronojel ri ni'ix chawij chi jatquisujuj? ");
INSERT INTO cakNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús can man jun anchique xu'ij che ri Pilato. Romari' ri gobernador can xsatz-ka runo'j (xsach-ka ruc'u'x), roma man jun winak rutz'eton chi quiri' nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Y juna-juna' cuando napon ri pascua ri jun quinimak'ej ri israelitas, ri gobernador nusk'opij jun chique ri jec'o pa cárcel. Raja' nusk'opij-e ri niquijo' ri winak chi ntel-e. ");
INSERT INTO cakNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Y chupa ri tiempo ri', c'o pa cárcel ri Barrabás, jun achi ri canconojel quieta'n rech chi yalan itzel. ");
INSERT INTO cakNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Y ri Pilato xu'ij chique ri winak ri xbequimolo-qui' chiri': ¿Ancu'x (Anchique) chique ri ca'i' nijo' rix chi ninsk'opij-e? ¿Nijo' chi ninsk'opij-e ri Barrabás o ja ri Jesús ri ni'ix Cristo che? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ri Pilato quiri' xu'ij-pe, roma raja' can reta'n chi ri winak ri' quijachon ri Jesús pa ruk'a', roma itzel niquitzu' chi can je q'uiy ri yetzekleben richi. ");
INSERT INTO cakNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Y ri Pilato ch'ocol pa ru-lugar anchi' yeru'on juzgar ri winak, cuando c'o jun xapon riq'uin roma c'o anchique ru'in-e ri raxayil che. Ri raxayil rutakon-e rubixic che: Ri Jesús jun chojmilaj achi, romari' man taya' lugar chi nicamises. Roma ren ruyon itzel achic' xin-en chak'a' roma raja'. Quiri' rutakon-e rubixic ri raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Y ri nimalaj tak sacerdotes y ri rijilaj tak achi'a' ri c'o quik'ij, xquiya' quino'j (quina'oj) ri winak chi tiquic'utuj-apo chi ja ri Barrabás tisk'opis-e y ri Jesús ticamises. ");
INSERT INTO cakNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Y cuando ri gobernador xuc'utuj chic apo chique ri winak ri' chi ancu'x (anchique) chique ri ca'i' niquijo' reje' chi nulesaj-e, ri winak ri' xqui'ij: Ja ri Barrabás talesaj-e, xecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Y ri Pilato xuc'utuj chique ri winak: ¿Y anchique nijo' rix chi nin-en ta riq'uin ri Jesús, ri ni'ix chuka' Cristo che? xcha' raja'. Can conojel xech'o'n-apo y xqui'ij: ¡Ticamises chech cruz! xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Y raja' xuc'utuj chic chique: ¿Anchique rumac rubanon chiwech? Pero ri winak man yetane' ta ka. Xa riq'uin más quichuk'a' yech'o'n-apo y niqui'ij: ¡Ticamises chech cruz! yecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Y cuando ri Pilato xutzu' chi can man jun anchique nitiquier nu'on chi nucol ri Jesús y ri winak xa más peor niqui'en-apo, xuc'utuj juba' ruya' y ja' xuch'aj ruk'a' chiquiwech conojel ri winak ri', y xu'ij: Ren manak numac chirij ri rucamic ri jun chojmilaj achi re'. ¡Titzu' rix anchique niben che! ");
INSERT INTO cakNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Y conojel winak niqui'ij: Pa kawi' roj y pa quiwi' ri kalc'ual tika ri rucamic, xecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ri gobernador xusk'opij-e ri Barrabás y chuka' xu'ij chi tich'ay ri Jesús, c'ajari' xujach-e chi ticamises chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Y ri ru-soldados ri gobernador xquicusaj-apo ri Jesús chupa ri palacio. C'ajari' xequiwoyoj conojel ri ch'aka chic soldados y xquimol-qui' chirij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Y ri soldados ri' xquilesaj-e rutziak ri Jesús, y xquiya' jun tziak quiak chirij, anche'l ri yequicusaj ri reyes. ");
INSERT INTO cakNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Chuka' xquipach'uj jun k'ayis ri yalan ruq'uixal; y can anche'l jun corona xqui'en che, y xquiya' pa rujolon ri Jesús. Y xquiya' chuka' jun aj pa ruk'a' derecha y yexuquie' chech y yetze'n chirij cuando niqui'ij che: ¡Caquicot ret qui-Rey ri israelitas! yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Can niquichubaj ri Jesús y niquimaj chuka' ri aj ri c'o pa ruk'a' chi niquich'ey pa rujolon che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Y cuando reje' xetane-ka yetze'n chirij, xquilesaj-e ri tziak ri xquiya' reje' chirij, y xquiya-e ri can rutziak-wi raja', y xquic'uaj-e chi ne'bajix chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Y cuando ya ye'el-e pa tenemit, xquic'ul jun achi; y ri achi re' aj-tenemit Cirene y rubinan Simón, y ri soldados xqui'en-wi che ri achi ri' chi tuc'uaj-e ru-cruz ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Y quiri' xe'apon chupa ri jun lugar rubinan Gólgota, ri ni'ix chuka' Calavera che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Cuando jec'o chic chiri', xquiya' che ri Jesús jun ch'amilaj ruya'al-uva xolon riq'uin jun chic c'ayilaj ak'om. Pero cuando raja' xuna' anchique niquiya' che, man xrojo' ta. ");
INSERT INTO cakNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Y cuando ri soldados quibajin yan ri Jesús chech ri cruz, xquilesaj suerte chirij ri rutziak chi niquina'ej anchique tziak ri niquic'uaj-e chiquijunal. Y quiri' can nibanataj ri bin can roma ri jun ri xuk'alajij rutzij ri Dios ojer can. Ri samajel ri' rutz'iban can chirij ri Cristo: Xequijach nutziak y chuka' xquilesaj suerte chirij. Quiri' ri rutz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","C'ajari' xech'oquie-ka chiri' quichajin-apo ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Y chutza'n ri cruz, reje' xquiya' jun letrero anchi' nu'ij anchique roma nicamises ri Jesús. Ri letrero ri' nu'ij: Jare' ri Jesús qui-Rey ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Chuka' jec'o ca'i' elek'oma' ri xebajix chech cruz. Jun xyo'x-apo pa ru-derecha ri Jesús y ri jun chic pa ru-izquierda. ");
INSERT INTO cakNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ri winak ri yek'ax-e y ye'apon riq'uin ri Jesús, niquisiloj-apo quijolon chech, roma can man niquinimaj ta chi ja raja' ri Ralc'ual ri Dios. Y c'o chuka' itzel tzij ri yequi'ij can che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ri winak ri' niqui'ij che ri Jesús: Ret xa'ij chi nawulij (nawulaj) ri rocho ri Dios y pa oxi' k'ij napoba' chic jun mej (bey), tacolo-awi' ayon. Y xa ja ret ri Ralc'ual ri Dios, caka-pe chech la a-cruz, yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Y quiri' chuka' niqui'en ri nimalaj tak sacerdotes, ri maestros chi ri ley, ri achi'a' fariseos y ri rijilaj tak achi'a' ri can c'o quik'ij, reje' yalan yetze'n-apo chirij ri Jesús y niqui'ij chiquiwech: ");
INSERT INTO cakNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Raja' can je q'uiy xerucol, pero raja' cami man nitiquier ta nucol-ri' ruyon. Y xa can ketzij chi ja raja' qui-Rey ri israelitas, tika-pe chech la ru-cruz c'a y quiri' roj can xtakaya' kánima riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Raja' can xuya' ránima riq'uin ri Dios, y xa ri Dios can nrojo' ri Jesús, tucolo' c'a. Roma ri Jesús can ru'in-wi: Ren jin Ralc'ual ri Dios. Quiri' xqui'ij ri achi'a' ri' chirij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Y ri elek'oma' ri je-bajin chech qui-cruz riq'uin ri Jesús, can itzel chuka' yech'o'n-apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Y pa nic'aj-k'ij che ri k'ij ri' ronojel ri rech-ulef xk'okumer-ka. Y ri k'eku'm ri' xq'uis-e c'a nak'ak'ij a las tres. ");
INSERT INTO cakNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Y ja' la'k chupa ri hora ri' a las tres, ri Jesús xch'o'n riq'uin ronojel ruchuk'a' y xu'ij: Elí, Elí, ¿lama sabactani? xcha'. Y ri tzij ri' nu'ij: Nu-Dios, nu-Dios, ¿anchique roma xinamalij can? ");
INSERT INTO cakNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Y jec'o jujun ri jec'o-apo chiri' chunakaj ri Jesús, cuando xquic'oxaj ri xu'ij, ja xqui'ij: Raja' ja ri Elías ri nroyoj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y ja' c'o jun ri junanin xberuc'ama-pe jun esponja, xumuba' pa jun ch'amilaj ruya'al-uva, y xuya' ri esponja chutza'n jun aj, chi xuya' che ri Jesús chi nich'uch'u-ka juba' ránima. ");
INSERT INTO cakNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Pero ri ch'aka ri jec'o-apo chiri' riq'uin ri Jesús, xqui'ij: Man junanchique taya' che; kayobej, k'alaj ri' xa noka ri Elías chi nucol, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Pero ri Jesús ja' xch'o'n chic pe riq'uin ronojel ruchuk'a', xujach ri ránima y xcom-ka. ");
INSERT INTO cakNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Y cuando raja' xcom, ri tziak ri yo'n-apo chi nujach rupa rocho ri Dios, xk'ach'itaj pa jotol c'a pa xulan ka. Chuka' ri rech-ulef can xsilon y ri abaj can xerakaro' y xepax. ");
INSERT INTO cakNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ri jul ri anchi' je-mukun-wi ri caminaki' xejakataj. Y je q'uiy chique ri ralc'ual ri Dios ri je caminak chic e, xec'astaj. ");
INSERT INTO cakNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Y xebe'el-pe cuando ri Jesús c'astajinak chic chiquicojol ri caminaki', y xe'oc-apo pa tenemit Jerusalem ri can richi-wi ri Dios; y can je q'uiy winak xetz'eto quichi. ");
INSERT INTO cakNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Y cuando ri capitán y conojel ri jec'o riq'uin chi niquichajij-apo ri Jesús, xquitzu' ri xu'on ri silonel (cab-rakan) y ri ch'aka chic ex ri xebanataj, can yalan xquixi'j-qui' y xqui'ij: Can ketzij-wi chi ri jun achi re' xa Ralc'ual ri Dios, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Y je q'uiy ixoki' ri can quitzekleben-wi-pe ri Jesús cuando xel-pe pa Galilea y quilin-pe, reje' chinaj yetzu'n-apo. ");
INSERT INTO cakNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Y chiquicojol ri ixoki' ri' c'o ri María Magdalena, ri María quite' ri Jacobo y ri José, y chuka' ri raxayil ri achi rubinan Zebedeo, ri quite' ri Jacobo y ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cuando xkak'ij yan ka, c'o jun achi beyom xapon rubinan José; raja' can runiman chuka' ri Jesús, y aj-tenemit Arimatea. ");
INSERT INTO cakNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Raja' xbe riq'uin ri gobernador Pilato chi nuc'utuj ri ruch'acul ri Jesús chi numuk. Y ri Pilato xu'ij-e chi tijach-pe ri ruch'acul ri Jesús che ri José. ");
INSERT INTO cakNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Y ri José xupis ri ruch'acul ri Jesús pa jun tziak ri can ch'ajch'oj. ");
INSERT INTO cakNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ri José can richi ka raja' ruc'oton jun jul c'ac'ac', y chiri' xberuya-wi ruch'acul ri Jesús. Ri jul ri' can c'oton chech jun nimalaj abaj ri can anche'l jun juyu'. Raja' xutz'apij can ri ruchi' ri jul che jun nimalaj abaj, y xtzolaj-e. ");
INSERT INTO cakNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ri María Magdalena y ri jun chic ixok rubinan chuka' María, xech'oquie' can chiri' chech jul cuando xmuk can. ");
INSERT INTO cakNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ri k'ij cuando xmuk ri Jesús, ja k'ij ri' cuando ri winak niquinaba' yan ronojel ri xtic'atzin chique ri ruca'n k'ij, roma ri k'ij chi uxlanen xa nitiquier yan ka. Y chupa ri k'ij chi uxlanen, ri nimalaj tak sacerdotes y ri achi'a' fariseos xe'apon chech ri Pilato. ");
INSERT INTO cakNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Reje' xbequi'ij che: Roj xoka pa kawi' chi cuando ri Jesús c'a q'ues, xu'ij chi xtic'astaj-pe pa rox k'ij. Can quiri' ru'in can ri jun tz'ucuy-tzij ri'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Romari' quie'ataka' achi'a' chi niquichajij ri jul c'a titzakon ri rox k'ij, chi quiri' man quiepe ri ru-discípulos y xtiquilek'aj ri ruch'acul ri Jesús chak'a', c'ajari' xtiqui'ij chique ri winak: Ri Jesús can xc'astaj-wi-e chiquicojol ri caminaki', xquiecha'. Y xa man xtaka'an ta quiri' y nilak'ex-e ruch'acul, can más je q'uiy ri xquieniman chi can takon-wi-pe roma ri Dios; y xa man quiri' ta, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Y ri Pilato xu'ij chique ri achi'a' ri': Quie'ic'uaj-e la achi'a' la'y can jabel ru'onic ibana' can che, chi quiri' can utz nichajix can, xe'uche'x. ");
INSERT INTO cakNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ri achi'a' ri' can ja xebe anchi' mukun-wi can ri Jesús y xqui'en utz ru'onic ruchi' ri jul. Xquiya' chuka' retal ri abaj ri rutz'apin can ruchi' ri jul, chi quiri' man jun nitiquier nujak. Y can utz xchajix can ri jul coma ri achi'a' chajinel. ");
INSERT INTO cakNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Y cuando xk'ax yan ri k'ij chi uxlanen, c'a cumaj yan che ri domingo ri na'ey k'ij chi ri semana, ri María Magdalena y ri jun chic ixok rubinan chuka' María, xebe chuchi' ri jul anchi' mukun-wi can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","C'aja' xquina' yalan xbesilon-pe ri rech-ulef, roma xa jun ángel chi ri Ajaf chila' chicaj ri xka-pe chupa ri lugar anchi' mukun-wi can ri Jesús, xulesaj ri nimalaj abaj ri rutz'apin ruchi' ri jul y xch'oquie' parui'. ");
INSERT INTO cakNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri rusakil ri ángel ri ch'ocol parui' ri abaj, can junan riq'uin ri sakil nuya' jun relámpago. Y ri rusakil ri rutziak can junan riq'uin ri rusakil ri tef ri nika. ");
INSERT INTO cakNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Y roma ri achi'a' chajinel can yalan xquixi'j-qui' chech ri ángel, can xebarbot. Can anche'l xecom roma yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Y ri ángel xch'o'n-apo chique ri ca'i' ixoki' y xu'ij chique: Man tixi'j-iwi'. Roma ren can weta'n chi rix ja ri ruch'acul ri Jesús ri xcamises chech ri cruz nicanoj. ");
INSERT INTO cakNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Raja' man c'o ta chic we', roma xa xc'astaj yan e, anche'l ru'in can chiwe. Quixoc; titzu' anchi' xc'ue-wi ri ruch'acul. ");
INSERT INTO cakNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Quixtzolaj ch'anin, y ti'ij chique conojel ri ru-discípulos, chi raja' xc'astaj yan e chiquicojol ri caminaki'; y cami nina'ey chiwech c'a pa rech-ulef Galilea; chiri' xtitzu-wi, can anche'l nin-ij-e chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Y ri ca'i' ixoki' ri' can ja' xe'el-pe chiri' chupa ri jul. Y más que can quixi'n-qui', xa can yalan chuka' xequicot. Reje' can ch'anin xebe chi ne'quiya' rutzijol chique ru-discípulos ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Cuando c'aja' quitz'amon bey, ri Jesús xbe'el-pe chiquiwech y xeru'on saludar. Y ri ca'i' ixoki' ri' xexuquie-ka chech ri Jesús, xquik'etej rakan y can xquiya' ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Y ri Jesús xu'ij chique ri ixoki': Man tixi'j chic iwi'. Cami iya' rutzijol chique ri wach'alal, chi quiebe pa rech-ulef Galilea y chila' xquinquitzu', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Y cuando ri ixoki' quitz'amon bey, jec'o jujun chique ri soldados ri niquichajij ri jul xebe pa tenemit Jerusalem y xbequi'ij chique ri nimalaj tak sacerdotes ronojel ri xbanataj riq'uin ri jul anchi' xmuk-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ri nimalaj tak sacerdotes xquimol-qui' quiq'uin ri rijilaj tak achi'a' ri can c'o quik'ij y xquiya' chiquiwech chi niquiya' q'uiy mero chique ri soldados ri xechajin. ");
INSERT INTO cakNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Reje' xqui'ij chique: Cami xe ti'ij chi xixwer-ka ri chak'a', y cuando jixwer, xe'apon ri ru-discípulos ri Jesús y xquilek'aj-e ri ruch'acul. ");
INSERT INTO cakNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Y xa ri gobernador nuna'ej chi rix xa xixwer-ka y man xichajij ta anche'l ri x-ix chiwe, roj xkojbech'o'n riq'uin y keta'n chi can xkojrunimaj, y quiri' rix jixcolotaj pa ruk'a', xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados xquic'on ri mero, y can anche'l x-ix chique can quiri' xqui'en: Can xquitzijoj anche'l ri x-ix chique. Jare' ri xtzijos chique ri winak israelitas y c'a niquinimaj c'a chupa ri k'ij re'. ");
INSERT INTO cakNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ri julajuj ru-discípulos ri Jesús xebe pa rech-ulef Galilea. Y xejote' parui' ri juyu' anchi' bin can chique roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Y cuando reje' xquitzu' ri Jesús, can xquiya' ruk'ij. Y can c'a jec'o ri man jani tiquinimaj chi ja ri Jesús ri c'o-apo quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Pero raja' xoka c'a quiq'uin y xu'ij chique: Can ronojel uchuk'a' xjach pa nuk'a'; quiri' chicaj y quiri' chuka' we' chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Romari', cami nic'atzin chi jixbe pa ronojel rech-ulef, chi quiri' ri winak jinquitzeklebej; y ri can xquinquitzeklebej, quie'ibana' bautizar pa rubi' ri Katata' Dios, pa nubi' ren ri jin Ralc'ual ri Dios y pa rubi' ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Y tic'utu' chiquiwech chi can tiquibana' ronojel ri nu'in can. Y ren can k'ij-k'ij xquic'ue' iwiq'uin; can xquic'ue-wi iwiq'uin c'a xtapon ri ruq'uisbel k'ij chi ri rech-ulef. Amén.");
INSERT INTO cakNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quiere' xtiquier-ka ri utzilaj tzij chi ri Jesucristo ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ri Isaías, ri xuk'alajij rutzij ri Dios ojer can tiempo, rutz'iban can ri x-ix che roma ri Dios chirij ri Jesucristo. jare' ri xutz'ibaj can raja': Xtintak jun achi na'ey, chi nunaba' ri bey ri anchi' xtapon-wi ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ja ri achi re' xtic'ue' pa tz'iran rech-ulef. Raja' xtutzijoj rutzij ri Dios chiquiwech ri winak ri xquie'apon riq'uin, y xtu'ij chique: Tichojmisaj ri ic'aslen, roma nakaj chic c'o-wi-pe ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri achi ri xunataj ri Isaías chi xtipe na'ey, ja ri Juan Bautista. Y raja' c'o pa tz'iran rech-ulef y nu'ij chique ri winak ri ye'apon riq'uin, chi tiquiya' can quimac y tiquibana' ri nrojo' ri Dios y tiquibana' bautizar qui', chi quiri' nicoch'otaj (nicuyutaj) quimac roma ri Dios. Y je q'uiy ri yeru'on bautizar raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Y ri winak ri ye'apon riq'uin ri Juan Bautista, can yalan je q'uiy. Jec'o ri aj-Jerusalem, ri tenemit ri c'o pa Judea. Y jec'o chuka' ri je-petenak pa ch'aka chic tenemit chi ri Judea. Ri winak re' ye'an-e bautizar roma raja' chiri' pa rakan-ya' Jordán. Reje' can niquik'alajij-wi ri quimac chech ri Juan Bautista. ");
INSERT INTO cakNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ri rutziak ri Juan banon che rusmal camello, y jun tz'um rucusan chi ruximbel-rupa. Y ri ruway, ja ri sac' y ri cab ri niquiya' ri chicop pa tak k'ayis. ");
INSERT INTO cakNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ri Juan nuk'alajij chique ri winak: C'o Jun ri xtipe chuij ren ri man anche'l ta oc ren. Ri Jun ri' can nim-wi ruk'ij y nim chuka' ri ruchuk'a'; romari', más que ren yiluquie-ka chi ninsol ruximbel ruxajab, hasta ri' man nuc'ul ta chi ja ren yibano, roma raja' can nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Y ren, ya' ri nincusaj chi jixinben bautizar. Pero ri Jun ri xtipe, riq'uin ri Espíritu Santo xquixru'on bautizar. ");
INSERT INTO cakNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ja k'ij ri' cuando ri Jesús elenak-pe pa tenemit Nazaret chiri' pa Galilea y xoka riq'uin ri Juan. Y raja' x-an bautizar roma ri Juan pa rakan-ya' Jordán. ");
INSERT INTO cakNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Y cuando ri Jesús xel-pe pa ya', xutzu' chi ri chicaj xjakataj, y ri Espíritu Santo nika-pe pa ruwi' anche'l jun paloma. ");
INSERT INTO cakNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y ri Dios xch'o'n-pe chicaj y xu'ij: Ja ret jat Walc'ual, yalan jatinjo' y niquicot wánima awiq'uin, xcha' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Y ri Jesús x-an che roma ri Espíritu Santo chi xbe pa tz'iran rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Y chiri' pa tz'iran rech-ulef xc'ue-wi, anchi' xe itzel tak chicop jec'o. Chiri' xc'ue-wi cuarenta k'ij. Y cuando c'o chiri', ri Satanás nutaj ruk'ij chirij chi nika ta pa ruk'a', pero man xtiquier ta chirij. Y ri ángeles xquilij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","C'o chic ri Juan pa cárcel cuando ri Jesús xbe pa Galilea. Ri Jesús nutzijoj ri utzilaj rutzij ri Dios ri nich'o'n chirij ri ru-gobierno ri Dios, ");
INSERT INTO cakNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","y nu'ij: Cami jojc'o yan chupa ri tiempo ri ru'in ri Dios; ri ru-gobierno can nakaj chic c'o-wi-pe. Titzolaj-pe ri iwánima y tinimaj ri utzilaj tzij chi jixcolotaj, nicha' raja' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Y jun k'ij cuando ri Jesús benak chuchi' ri choy (ya') rubinan Galilea, xerutzu' je ca'i' achi'a' quichak'-quinimal qui'; jun rubinan Simón y ri jun chic Andrés. Ri quisamaj ri achi'a' ri' ja ri yequilesaj quer pa ya', romari' niquiq'uiak ri quiya'l pa ya' chi yequilesaj-pe quer. ");
INSERT INTO cakNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ri Jesús xch'o'n chique ri ca'i' achi'a' ri' y xu'ij chique: Quinitzeklebej, y xtinc'ut chiwech anchique modo ye'ich'ec winak riq'uin ri nutzij chi jinquitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ri ca'i' achi'a' ri', can ja' xquiya' can ri quisamaj y xquitzeklebej ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Y juba' oc xebin, cuando ri Jesús xpa'e'. Raja' xerutzu' ri Jacobo y ri Juan, ri je ralc'ual ri jun achi rubinan Zebedeo. Ri je ca'i' achi'a' re' pa canoa jec'o-wi, yesamaj. Reje' yequic'ojoj quiya'l ri anchok che yequilesaj quer pa ya'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Y xpe ri Jesús xeroyoj chi niquitzeklebej. Y ri Jacobo y ri Juan can xe xquic'oxaj, xebe chirij. Y xe chic ri quitata' xc'ue' can quiq'uin ri samajel pa canoa. ");
INSERT INTO cakNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ri Jesús y ri je-benak riq'uin xe'apon pa tenemit Capernaum. Y chupa ri k'ij chi uxlanen, ri Jesús xbe pa sinagoga, ri jay anchi' niquimol-wi-qui' ri winak chi niquic'oxaj rutzij ri Dios. Raja' chiri' nutzijoj-wi rutzij ri Dios chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xec'oxan-apo richi, xsatz quino'j (xsach quic'u'x) roma ri tzij ri xquic'oxaj. Roma cuando yerutijoj, can nik'alajin chi can c'o uchuk'a' pa ruk'a' y man anche'l ta oc ri maestros chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Y chiri' chupa ri sinagoga ri k'ij ri' c'o-apo jun achi ri c'o jun itzel espíritu riq'uin. Y ri itzel espíritu ri c'o riq'uin ri achi, can xsiq'uin xch'o'n, ");
INSERT INTO cakNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","y xu'ij che ri Jesús: ¿Anchique ri najo' chake, ret Jesús aj-Nazaret? ¿Xape chi jojaq'uis? Ren weta'n jat ancu'x (anchique) ret y romari' weta'n chi can ja ret ri lok'olaj Ralc'ual ri Dios y jat-petenak riq'uin raja', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Pero ri Jesús xu'ij che ri itzel espíritu: Cachojochi'. Catel-e. ");
INSERT INTO cakNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Y ri itzel espíritu nisiq'uin xel-e. Pero cuando xel-e, xupiq'uiq'uiej can ri ruch'acul ri achi. ");
INSERT INTO cakNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Y ri winak ri quimolon-qui' chiri', xsatz quino'j (xsach quic'u'x) cuando xquitzu' ri xu'on ri Jesús, y niqui'ij chiquiwech: ¿Anchique ri nrojo' nuc'ut ri achi re'? Roma ri nuc'ut raja' can man jun mej (bey) kac'oxan roj. Cuando nich'o'n, can nik'alajin chi can c'o uchuk'a' pa ruk'a'. Ri itzel tak espíritus can yeniman che, yecha' ri winak chiquiwech ka reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y ch'anin xbin rutzijol ri Jesús, y romari' ri winak ri jec'o pa tak tenemit chunakaj ri Galilea, ch'anin xquina'ej ri yeru'on ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Cuando ri Jesús, ri Jacobo y ri Juan xe'el-pe chiri' pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, reje' xebe chicocho ri Simón y Andrés. ");
INSERT INTO cakNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Pero cuando xe'apon, x-ix che ri Jesús chi ri rujite' ri Simón li'an chech ruch'at, roma jun nimalaj c'aten. ");
INSERT INTO cakNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Y ri Jesús can ja' xberutzu-pe ri yawa'. Raja' xutz'om ruk'a' y xuyec. Y can xe quiri' xu'on che, can ja' xq'uis-e ri c'aten chirij. Y ri ixok ri' can ja' xerutzuk ri Jesús y ri je-benak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Y ja' cuando xka yan ka ri k'ij y xcok'a' yan ka chupa ri k'ij ri', ja' cuando conojel ri winak ri c'o yawa'i' quiq'uin xequic'uaj-apo chech ri Jesús. Ri yawa'i' ri' jalajoj rech yabil ri ntoc chique y jec'o chuka' ri c'o itzel tak espíritus quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Can yalan je q'uiy ri winak ri xquimol-apo-qui' chiri', xa conojel ri winak ri jec'o chupa ri jun tenemit ri' ri xe'apon riq'uin ri jay anchi' c'o-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Y ri yawa'i' can xec'achoj-wi roma ri Jesús, más que can jalajoj rech yabil ntoc chique. Chuka' raja' xerulesaj-e ri itzel tak espíritus. Ri Jesús can man xuya' ta lugar chique ri itzel tak espíritus chi xech'o'n, roma reje' quieta'n ancu'x (anchique) raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Nimak'a' yan ruca'n k'ij, ri Jesús xcataj-e y xbe pa tz'iran rech-ulef chi xberu'ona' orar. ");
INSERT INTO cakNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Y ri Simón y ri ch'aka chic discípulos xebe chucanoxic ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Cuando xquiwil, ja' xqui'ij che: Jacanox coma conojel winak, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Y ri Jesús xu'ij chique: Jo' pa ch'aka chic tenemit ri jec'o-pe nakaj, chi nintzijoj chuka' rutzij ri Dios chiri', roma can richi-wi nin-en ri samaj re' xipe we' chech-ulef, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Y raja' xbe chi xutzijoj rutzij ri Dios pa ronojel ri Galilea. Ri pa tak tenemit anchi' napon-wi, raja' nutzijoj rutzij ri Dios pa tak sinagogas, ri jay anchi' niquimol-wi-qui' ri winak chi niquic'oxaj rutzij ri Dios. Y chuka' can xerulesaj-e ri itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","C'o jun achi ri c'o jun itzel yabil chirij, ri rubinan lepra. Ri achi ri' xapon riq'uin ri Jesús, xxuquie-ka chech y xu'ij che: Ren weta'n chi ret jatiquier nalesaj nuyabil, pero man weta'n ta anchique nanojij pa nuwi', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ri Jesús xujoyowaj rech ri achi ri'; romari' raja' can ja' xutz'om-apo y xu'ij che: Ninjo' chi jac'achoj. Tiq'uis-e ayabil, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Y can xe xu'ij quiere' ri Jesús, ri ru-lepra ri achi xq'uis-e y ch'ajch'oj xu'on can. ");
INSERT INTO cakNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Y ri Jesús can ja' xu'ij che ri achi chi tibe, pero can yalan xuchelebej che ri anchique nic'atzin chi nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Ri Jesús xu'ij che ri achi ri': Man taya' rutzijol ri xbanataj awiq'uin, xe ac'utu-awi' chech ri sacerdote pa rocho ri Dios. Y taya' ronojel ri nu'ij chupa ri ru-ley ri Moisés. Chiri' nu'ij anchique nic'atzin naya', chi quiri' nak'alajij chiquiwech chi jat ch'ajch'oj chic, xuche'x-e. ");
INSERT INTO cakNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Pero ri achi can xe xuya' can ri Jesús, xa xutz'om rutzijoxic chique ri winak ri anchique xbanataj riq'uin raja'. Y romari' ri Jesús ch'anin xel rutzijol, y man nitiquier ta chic ntoc-apo ri pa tak tenemit ri anchi' napon-wi, roma can je q'uiy winak ri yec'ulu-apo richi. Y roma chuka' ri' ri Jesús nic'ue' can pa tak k'ayis, ri lugar anchi' manak winak. Y ri winak ri ye'apon riq'uin can yalan je q'uiy, y chuka' q'uiy lugar yepe-wi ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xk'ax yan jun jani' k'ij, ri Jesús xtzolaj-pe pa tenemit Capernaum, y ri winak xquic'oxaj chi raja' c'o pa jun jay chiri' pa tenemit. ");
INSERT INTO cakNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ri winak can ch'anin xquimol-qui' anchi' c'o-wi ri Jesús. Ri jay can man yeru'on ta chic, ni ri ch'ijay can man jun chic nitiquier ntoc-apo. Y ri Jesús can nutzijoj rutzij ri Dios chique conojel ri xquimol-qui' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Y jari' najin cuando jec'o quieji' chic xe'apon; quic'uan jun achi ri can siquirinak ruch'acul, li'an-e chech jun ch'at. ");
INSERT INTO cakNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero reje' xa man xetiquier ta xe'oc-apo riq'uin ri Jesús, roma can je q'uiy winak quimolon-qui' chiri'. Y roma man xetiquier ta xek'ax chiquicojol ri winak, xquichobij rui' ri jay, can anchi' c'o-wi ri Jesús, y chiri' xquikasaj-wi-ka ri yawa', chech ri ch'at. ");
INSERT INTO cakNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Y cuando ri Jesús xerutzu' chi can quiyo'n cánima riq'uin raja', xu'ij che ri achi siquirinak ruch'acul: Walc'ual, xcha' che. Ronojel ri amac xecoch'otaj (xecuyutaj). ");
INSERT INTO cakNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Y chiri' chuka' je-ch'ocol-apo jujun maestros chi ri ley. Reje' xquinojij-ka pa cánima: ");
INSERT INTO cakNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Anchique roma ri Jesús nu'ij che la achi chi nucoch' (nucuy) rumac? Can nu'on chi ja raja' ri Dios. ¿Roma anchique ta winak nitiquier nucoch' (nucuy) mac? Man jun. Xe ri Dios nitiquier nu'on quiri', yecha' pa tak cánima ri maestros chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Pero ri Jesús can reta'n-wi ri niquinojij pa tak cánima ri achi'a' ri'. Y romari' xu'ij chique: ¿Anchique roma rix quiere' ninojij pa tak iwánima? ");
INSERT INTO cakNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Roma xa ren yitiquier nin-en che ri jun achi siquirinak chi nibin y nuc'uaj-e ruch'at, ¿yitiquier como chuka' nin-ij che chi nincoch' (nincuy) rumac? ¿Anchique ni'ij rix? ");
INSERT INTO cakNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Cami c'a, chi rix nitemaj chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can c'o uchuk'a' wiq'uin chi nincoch' (nincuy) mac, titzu' c'a. Y ri Jesús xu'ij che ri achi siquirinak ruch'acul: ");
INSERT INTO cakNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nin-ij chawe: Cacataj, tac'uaj-e la ach'at y jat (cabin) chi'awocho, xuche'x roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Y ri achi can ja' xpa'e', xuc'ol ruch'at, y xel-e chiquicojol ri quimolon-qui' chiri'. Y ri winak ri' xsatz quino'j (xsach quic'u'x), roma man jun mej (bey) quitz'eton chi quiri' nibanataj. Y xquiya' chuka' ruk'ij ri Dios y xqui'ij: Man jun mej (bey) katz'eton chi quiere' nibanataj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Y ri Jesús xbe chic chuchi' ri choy (ya') y yalan je q'uiy winak ri xe'apon riq'uin, y raja' yerutijoj riq'uin rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Y cuando raja' rutz'amon bey chi nitzolaj chij, xutzu' ri Leví, ri ralc'ual ri jun achi rubinan Alfeo. Ri Leví ch'ocol pa jun ch'aquet, chi numol ri impuesto ri niquitoj ri winak. Xpe ri Jesús xu'ij che: Quinatzeklebej. Y raja' xbecataj-pe ri anchi' ch'ocol-wi y xutzeklebej ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Y cuando ri Jesús ch'ocol chuchi' ri mesa ri chiri' pa jay, je q'uiy ri moloy-impuestos y ch'aka chic winak ri aj-mac ni'ix chique, je-ch'ocol chuchi' ri mesa, junan riq'uin ri Jesús y ri ru-discípulos. Can je q'uiy ri yetzekleben richi ri Jesús ri jec'o chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Y cuando ri maestros chi ri ley y ri achi'a' fariseos xquitzu' chi ri Jesús niwa' quiq'uin ri moloy tak impuestos y quiq'uin ri winak je aj-mac, xquic'utuj chique ri ru-discípulos: ¿Anchique roma raja' junan niwa' quiq'uin ri moloy tak impuestos y quiq'uin winak aj-mac? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Y cuando ri Jesús xuc'oxaj-pe ri tzij ri niqui'ij ri maestros chi ri ley y ri achi'a' fariseos, raja' xu'ij chique: Jun ri nik'oman man ja' ta ri je utz ri yeruk'omaj. Raja' yeruk'omaj ri yeyawaj. Ren man xipe ta chiquicanoxic winak ri choj rubanon quic'aslen chech ri Dios. Ren xipe chiquicanoxic ri can c'o quimac, ri nic'atzin chi niquiya' can ri quimac y niqui'en ri nrojo' ri Dios, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ri ru-discípulos ri Juan Bautista y ri qui-discípulos ri achi'a' fariseos, c'o k'ij quicha'on chi niqui'en ayunar. Y romari' xquic'utuj che ri Jesús: Roj ri joj ru-discípulos ri Juan y joj qui-discípulos ri fariseos can kacha'on k'ij chi naka'an ayunar. ¿Y anchique roma ri a-discípulos ret man quiri' ta niqui'en? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Y ri Jesús xu'ij chique: ¿Anchique ni'ij rix? ¿Utz como niquimalij ri wa'in ri je-banon invitar pa jun c'ulubic y c'o-apo ri ala' ri xc'ule' chiquicojol? Man utz ta niqui'en quiri', roma ri ala' c'a c'o quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero xtapon ri k'ij cuando ri ala' re' xtileses-e chiquicojol, c'ajari' xtiqui'en ayunar. ");
INSERT INTO cakNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Man jun winak nuretz-ka jun tziak c'ac'ac' chi nuc'ojoj (nut'is) jun tziak ri xa can tzia'k' chic. Roma ri tziak c'ac'ac' nuc'ol-ri' y nujic' ri tziak ri xa tzia'k' chic y más nuretz-ka. ");
INSERT INTO cakNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Y quiri' chuka' man jun niyo'n c'ac'ac' vino chupa jun tz'um yacbel-ya' ri xa ucusan chic. Roma xa quiri' ni'an, y ri tz'um xa man nuyuk ta chic ri', ri tz'um nibojbo' (nichiquitaj) y niq'uis-e ri vino chupa. Y chuka' ri tz'um man jun chic nic'atzin-wi. Pero chupa jun c'ac'ac' yacbel-ya' utz niyaquie' c'ac'ac' vino. Quiere' ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Pa jun k'ij chi uxlanen, ri Jesús y ri ru-discípulos yek'ax pa jun ulef ri ticon trigo chech. Y ri ru-discípulos c'o rech trigo ri niquich'up-e. ");
INSERT INTO cakNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Romari' ri achi'a' fariseos xqui'ij che ri Jesús: Quie'atzu' la a-discípulos, roma man utz ta ri niqui'en. ¿Anchique roma niquich'up trigo ri k'ij re'? Ri k'ij re' chi uxlanen y man utz ta ni'an samaj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Pero ri Jesús xu'ij chique: ¿Man itz'eton ta rix ri tz'iban can chirij ri xu'on ri David y ri je raxbil chupa ri ojer can tiempo, cuando xnum quipa y manak quiway? ");
INSERT INTO cakNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ri David xbe chucanoxic wey chiri' pa rocho ri Dios. Y ri sacerdote ri más c'o ruk'ij chupa ri tiempo ri' ja ri Abiatar. Y can ja ri lok'olaj tak pan ri xbeyo'x-pe che. Y ri pan ri' man xe ta ri David ri xtijo, xa can xuya' chuka' chique ri je-benak riq'uin. Pero man mac ta ri xqui'en, más que ri pan ri' xe ri sacerdotes c'o modo yetijo. ");
INSERT INTO cakNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y ri Jesús can xu'ij chuka' chique: Ri Dios coma ri winak xu'on can ri k'ij chi uxlanen; y man roma ta ri k'ij chi uxlanen xeru'on ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Romari' cami titemaj chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol jin Rajaf ri k'ij chi uxlanen. Pa nuk'a' ren c'o-wi chi nin-ij anchique utz ni'an chupa ri k'ij re', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Y ri Jesús y ri ru-discípulos xe'apon chic pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. Y chiquicojol ri winak ri quimolon-qui' chiri', c'o jun achi chaki'j jun ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Pero can jec'o ri xe niquitzu-apo ri Jesús y quiyoben xa raja' xtu'on jun milagro chi nic'achoj ri achi, chi quiri' niquisujuj chi ri Jesús xsamaj pa jun k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Pero ri Jesús xu'ij che ri achi chaki'j ri ruk'a': Cacataj y capa'e' pa nic'aj, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Y ri Jesús xu'ij chique ri winak ri jec'o chiri': Ren ninjo' ninc'utuj chiwe: ¿Anchique ri más nuc'ul ni'an pa jun k'ij chi uxlanen, ja ri utz o ri man utz ta? ¿Ri nicol jun winak chech ri camic o ri nicamises? ¿Anchique ni'ij rix? xcha' chique. Pero conojel man jun tzij ri xqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quiri' ri Jesús xerutzu' conojel ri quimolon-qui' chiri', y xerutzu' chi xa cowirinak ri cánima y man niquijo' ta niquinimaj. Romari' raja' yalan xbison, y xpe ruyowal. Quiri' raja' xu'ij che ri achi chaki'j ri ruk'a': Tayuku' la ak'a'. Y ri achi can xe xuyuk ri ruk'a', can ja' utz xu'on can ri ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Y ri achi'a' fariseos can xe xquitzu' ri', can ja' xbequimolo-qui' quiq'uin ri je ruwinak ri rey Herodes, chi niquinojij anchique niqui'en che ri Jesús, roma niquijo' niquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Y ri Jesús y ru-discípulos xebe chuchi' ri choy (ya'). Ri Jesús xtzeklebes coma je q'uiy winak aj-chiri' pa Galilea, y coma winak ri aj-Judea. ");
INSERT INTO cakNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Can xtzeklebes chuka' coma ri winak aj-Jerusalem, ri jun tenemit ri c'o chuka' pa Judea. Ri winak ri xetzekleben richi raja' jec'o ri xepe pa Idumea, jec'o chuka' xepe juc'an chic ruchi' ri rakan-ya' Jordán. Xtzeklebes chuka' coma ri winak ri xepe pa Tiro y Sidón y ri xepe chuka' chiquinakaj ri ca'i' tenemit ri'. Can conojel ri winak ri xeloka riq'uin ri Jesús, xepe roma quic'oxan ri milagros ri yeru'on ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Y roma je q'uiy ri winak yeloka riq'uin, ri Jesús xu'ij chique ri ru-discípulos chi tiquiya-pe jun canoa chunakaj, chi quiri' xa ri winak xtiquipitz', ntoc chupa ri canoa. ");
INSERT INTO cakNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Can je q'uiy-wi ri xec'achoj roma ri Jesús. Y roma can conojel ri winak yeyawaj niquijo' chuka' yec'achoj roma ri Jesús, romari' quimolon-qui' chirij, y niquitaj quik'ij chi niquitz'om-apo juba' ri rutziak chi yec'achoj riq'uin ri quiyabil. ");
INSERT INTO cakNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Y cuando ri itzel tak espíritus niquitzu' ri Jesús, niquixucuba-qui' chech y can riq'uin quichuk'a' yech'o'n y niqui'ij: Ja ret ri Ralc'ual ri Dios, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Pero ri Jesús nu'ij chique que man tiquik'alajij chi ja raja' ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ri Jesús xjote-e parui' jun juyu' y xeroyoj q'uiy achi'a'. Can ja raja' mismo xwoyon quichi y reje' can xebe-wi riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Je cablajuj ri xerucha' chi niquitzeklebej y chuka' chi yerutak-e chi ne'quitzijoj rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y quiri' chuka' can xuya' uchuk'a' chique chi yec'achoj yawa'i' coma y chi yequilesaj itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ri je cablajuj ri xerucha' ri Jesús, ja ri Simón ri xu'ij chuka' Pedro che. ");
INSERT INTO cakNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ri Jacobo y ri Juan, ri je ralc'ual ri Zebedeo, ri xu'ij chuka' Boanerges chique; ri bi'aj ri' pa kach'abel nu'ij: Je anche'l rayos ri yek'ajan. ");
INSERT INTO cakNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ri ch'aka chic ja ri Andrés, ri Felipe, ri Bartolomé, ri Mateo, ri Tomás, ri Jacobo ri ralc'ual ri Alfeo, ri Tadeo, ri Simón ri c'o quiq'uin ri achi'a' ri ni'ix cananista chique, ");
INSERT INTO cakNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y ri Judas Iscariote ri xc'ayin richi ri Jesús. Ri Jesús y ri ru-discípulos xebe pa jun jay. ");
INSERT INTO cakNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Y roma yalan je q'uiy winak ri xquimol-qui' jun mej (bey) chic, ri Jesús y ri ru-discípulos man xetiquier ta xewa'. ");
INSERT INTO cakNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Y cuando ri rach'alal ri Jesús xquina'ej ronojel ri', ja xe'apon chi ne'quic'ama-pe, roma reje' xquinojij chi ri Jesús xch'ujir-ka. ");
INSERT INTO cakNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Y ri maestros chi ri ley ri je-petenak pa tenemit Jerusalem, jec'o-apo ri anchi' c'o-wi ri Jesús. Y niquitzijoj chiquiwech chi ri Jesús c'o ri Beelzebú riq'uin, ri cajaf ri itzel tak espíritus. Y ja ri Beelzebú ri niyo'n ruchuk'a' chi nitiquier yerulesaj ri itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Y romari' ri Jesús xeroyoj chi xtzijon quiq'uin; raja' xerucusaj ejemplos chiquiwech, y xu'ij chique: ¿Anchique modo chi ri Satanás ja raja' mismo yerulesaj-e ri rusamajel? ");
INSERT INTO cakNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Roma xa ri winak chi jun rech-ulef man junan ta niquinojij y ca'i' quiwech niqui'en-ka, nipe ayowal chiquicojol. Y ri' man utz ta, roma man xquielayoj ta yec'ue' junan chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Y quiri' chuka' pa jun jay, xa jalajoj quiwech niqui'en-ka y niquijach-ka-qui', manak chic xquiec'ue' junan chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Y romari' ri Satanás, man utz ta nu'on-ka ayowal quiq'uin ri je rusamajel. Man utz ta nicataj-ka chirij raja' mismo. Roma xa quiri' nu'on, ruyon nic'ue' can y ch'anin nitzak. ");
INSERT INTO cakNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Quiri' chuka' ri nrojo' nu'on elak' pa rocho jun achi ri yalan ruchuk'a', nic'atzin nuxim na'ey, c'ajari' c'o modo nucanoj-e ronojel ri nrojo' yeruc'uaj. ");
INSERT INTO cakNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","29","Y tic'oxaj jabel ri tzij ri xtin-ij chiwe cami. Ri ni'in itzel tak tzij chirij ri Espíritu Santo, can man xticoch'otaj (xticuyutaj) ta ri rumac, xa can xtrakalej jumul chech ri Dios. Y ri ch'aka chic mac ri yequi'en ri winak ri je-alaxinak chech-ulef can yecoch'otaj (yecuyutaj). Y chuka' ronojel ri itzel tak tzij ri yequi'ij chirij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ri Jesús quiri' xu'ij chique ri maestros chi ri ley, roma reje' xa niqui'ij chirij raja' chi c'o itzel espíritu riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Y ri rute' y ri je rach'alal ri Jesús xepe c'a anchi' c'o-wi raja'. Pero man xe'oc ta apo riq'uin. Xe xquitak rubixic che, chi niquijo' yech'o'n che. ");
INSERT INTO cakNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Y ri winak ri je-ch'ocol-apo riq'uin ri Jesús xqui'ij che: Ri ate' y ri awach'alal jatquiyoben chojay, y niquijo' yech'o'n awiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Pero ri Jesús xu'ij chique ri winak ri quimolon-qui' riq'uin: ¿Ancu'x (Anchique) ri nte' y ri je wach'alal ni'ij rix? ");
INSERT INTO cakNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Y ri Jesús xerutzu' conojel ri je-ch'ocol riq'uin y xu'ij chique: Jare' je nte' y je wach'alal. ");
INSERT INTO cakNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Conojel ri yebano ri nrojo' ri Dios, ja reje' ri ye'oc nte', wana' y wach'alal, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Y ri Jesús y ri ru-discípulos xebe chic chuchi-choy (chuchi-ya') y raja' yerutijoj ri winak riq'uin rutzij ri Dios. Y can yalan je q'uiy winak ri xquimol-apo-qui' chi niquic'oxaj. Romari' ri Jesús xoc-apo pa jun canoa chiri' parui' ya', y xch'oquie-ka chupa. Y chiri' pa ulef chuchi' ri ya', jec'o ri winak niquic'oxaj-apo ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ri Jesús q'uiy ex xuc'ut chiquiwech riq'uin ejemplos chi yerutijoj. Raja' xu'ij chique: ");
INSERT INTO cakNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Tic'oxaj jabel ri xtin-ij chiwe: C'o jun achi ri xbetico. ");
INSERT INTO cakNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cuando ri achi nutic ri ija'tz', juba' ri ija'tz' pa bey xeka-wi. Y xepe ri chicop ri c'o quixic' ri yebe chicaj, xquitaj-e ri ija'tz'. ");
INSERT INTO cakNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Juba' chic ri ija'tz' chiquicojol abaj xeka-wi y chiri' xa man q'uiy ta ri ulef c'o. Y ch'anin xe'el-pe roma xa man pim ta ri ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Pero cuando xpe ruchuk'a' ri k'ij, xemayamo'. Y roma xa man naj ta benak-ka ri quic'amal (quixe'), xechaki'j-ka jumul. ");
INSERT INTO cakNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Y juba' chic ija'tz' xeka chiquicojol k'ayis ri c'o quiq'uixal. Y cuando xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix yalan xeq'uiy, ri tico'n xejik' chiquicojol y man xquiya' ta quiwech. ");
INSERT INTO cakNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Y ri ch'aka chic ija'tz' xeka pa jun utzilaj ulef, xe'el-pe ri tico'n y xeq'uiy jabel. Y jujun xquiya' a treinta quiwech, c'o xquiya' a sesenta y c'o ri xquiya' a cien quiwech. ");
INSERT INTO cakNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ri Jesús xu'ij chuka': Ri c'o ruxiquin, can tuc'oxaj ri xin-ij, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Y cuando ri Jesús y ri cablajuj ru-discípulos quiyon xec'ue' can quiq'uin ca'i-oxi' winak, ja' xquic'utuj che anchique ri nrojo' nu'ij chique riq'uin ri ejemplo ri xutzijoj chique. ");
INSERT INTO cakNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Y raja' xu'ij chique: Man jun mej (bey) can ta k'alajin utz anchique modo nu'on gobernar ri Dios, pero chiwe rix yo'n lugar chi nina'ej. Pero ri winak ri man jinquinimaj ta, che ejemplos yich'o'n-wi chique. ");
INSERT INTO cakNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Chi quiri' xe xtiquitzu', pero manak xtiquitzu' utz ri niquitzu', y xe xtiquic'oxaj y manak xtiqui'en entender ri niquic'oxaj, chi quiri' man niquiya' ta can ri mac, y ri Dios can manak-wi xquierucoch' (xquierucuy). ");
INSERT INTO cakNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Y ri Jesús xu'ij chuka' chique: Xa man xiben ta entender ri ejemplo ri xintzijoj chiwe, ¿anchique modo xtiben entender ri ch'aka chic ejemplos? ");
INSERT INTO cakNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ri jun ejemplo re' nuc'ut chi ri achi ticonel ri xberutica' ija'tz', jari' ri samajel ri nutzijoj rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ri juba' ija'tz' ri xeka pa bey, anche'l ri winak ri niquic'oxaj rutzij ri Dios, y ri Satanás ch'anin napon quiq'uin y nulesaj-e ri tzij ri' pa cánima. ");
INSERT INTO cakNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ri ija'tz' ri xeka chiquicojol tak abaj, can nich'o'n chirij rutzij ri Dios ri nic'oxex coma ri winak. Ri winak ri' can yalan yequicot cuando niquic'on-ka rutzij ri Dios pa cánima. ");
INSERT INTO cakNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero roma man nika ta ka ri ruc'amal (ruxe') rutzij ri Dios pa cánima, romari' man yelayoj ta ri yequicot, xa jun jani' oc k'ij ri utz jec'o riq'uin ri Dios. Pero cuando yepe sufrimientos y itzel yetz'et roma quiniman rutzij ri Dios, yetzak ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Y ri ija'tz' ri xeka can chiquicojol k'ayis ri c'o quiq'uixal, can nich'o'n-wi chirij rutzij ri Dios ri nic'oxex coma ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero ri winak ri' xa ja ri nic'atzin chique k'ij-k'ij chech-ulef, xe ri' niquinataj; jec'o ch'aka chic ye'an engañar roma ri beyomel. Romari' rutzij ri Dios nijik' pa cánima. Y q'uiy chuka' ri niquirayij, romari' ri winak ri' can manak xtiwachin utz rutzij ri Dios pa quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Pero ri ija'tz' ri xeka pa utzilaj ulef, can nich'o'n-wi chirij rutzij ri Dios ri nic'oxex coma ri winak, y ri winak ri' can niquic'on-wi-ka rutzij ri Dios y ri quic'aslen niwachin jabel, can anche'l niqui'en ri tico'n. Roma jec'o jujun niquiya' a treinta quiwech, jec'o niquiya' a sesenta y jec'o can a cien quiwech niquiya'. Can quiri' nu'on quic'aslen ri winak ri niquic'on-ka rutzij ri Dios pa tak cánima. ");
INSERT INTO cakNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Y ri Jesús xu'ij chuka' chique: Cuando nic'amer-pe jun luz chi nuya' sakil pa jay, ¿chuxe' como jun cajón o chuxe' como jun ch'at nic'ue-wi? Man quiri' ta. Ri luz chicaj niyo'x-wi, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Quiri' chuka' man jun ex ri ewan can, ri man ta xte'k'alajin-pe. Y chuka' can man jun ri tz'apin can rij, ri man ta xte'k'alajin-pe chech sakil. ");
INSERT INTO cakNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ri c'o ruxiquin, can tuc'oxaj ri xin-ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Y ri Jesús xu'ij chuka' chique ri winak: Rix ri nic'oxaj rutzij ri Dios, tic'oxaj utz y tibana' ri nu'ij. Roma can anche'l ri nic'oxaj, can quiri' chuka' ino'j (ina'oj) ri xtuya' ri Dios; y man xe ta ri', roma ri Dios xa can xtuya' juba' más rui' ri ino'j (ina'oj). ");
INSERT INTO cakNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Roma ri can c'o ruyacon pa ránima, can xtiyo'x más che. Pero ri nic'oxan rutzij ri Dios y xa man nuyec ta pa ránima, ri juba' oc c'o riq'uin, hasta ri' xtimaj che. ");
INSERT INTO cakNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Y ri Jesús xu'ij chuka': Riq'uin ri ru-gobierno ri Dios, can nibanataj anche'l nibanataj riq'uin jun ija'tz' ri nitic can roma jun achi ri pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Y cuando ri ija'tz' c'o chic pa ulef, ri achi man jun chic anchique nu'on. Raja' niwer ri chak'a' y nicataj-pe k'ij-k'ij. Y cuando napon ri k'ij chi ri ija'tz' nibos, ja nibos-pe y niq'uiy. Pero ri achi ri tiquiyon can, man reta'n ta anchique nu'on ri ija'tz' chi nibos-pe y anchique nu'on chi niq'uiy. ");
INSERT INTO cakNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ri achi can man jun anchique nu'on che ri tico'n chi niq'uiy, roma ri tico'n xa ruyon niq'uiy-pe, y ri ulef q'uiy ri nuya-pe. Pero na'ey ja ri alaj trigo niq'uiy-pe. Y cuando nim chic, niq'uiy-pe ri rui'. Y c'ajari' ninoj-pe riq'uin ri rech. ");
INSERT INTO cakNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Y cuando k'an chic, ri rajaf yerutak ri rusamajel chupa, chi niquik'at, roma ja tiempo ri' chi ri cosecha. ");
INSERT INTO cakNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Y ri Jesús xu'ij chuka': ¿Anchique xtaka'ij chirij ri ru-gobierno ri Dios? ¿Anchok riq'uin xtakajunumaj-wi? ¿Y anchique ta como ejemplo ri nik'alajin richi? ");
INSERT INTO cakNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ri ru-gobierno ri Dios can junan riq'uin ri ija'tz' chi ri mostaza ri nitic-ka pa ulef. Y jari' ri ija'tz' ri más co'l c'o chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero jari' ri más nim ntel chiquiwech conojel tico'n, y yec'ue' nima'k tak ruk'a'. Romari' ri chicop ri c'o quixic' ri yebe chicaj niqui'en quisoc chuk'a', roma chiri' jabel yemujan. ");
INSERT INTO cakNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Cuando ri Jesús xutzijoj rutzij ri Dios chique ri winak, xerucusaj ejemplos roma reta'n chi quiri' can c'o ri xtiquitemaj. ");
INSERT INTO cakNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Raja' ruyon ejemplos xerucusaj chi xch'o'n chique ri winak. Pero cuando quiyon jec'o can, raja' can nu'ij chique ri ru-discípulos anchique ntel chi tzij. ");
INSERT INTO cakNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Y cuando xcok'a-ka chupa ri k'ij ri', ri Jesús xu'ij chique ri ru-discípulos: Jo' juc'an chic ruchi-choy (ruchi-ya'), xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Y raja' xe xch'o'n can chique ri winak, ja xeruya' can. Y roma can ch'ocol-wi chupa ri canoa, can ja' xebe parui' ri ya'. Y jec'o chuka' ch'aka chic canoas ri junan xe'el-e quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Y cuando je-benak parui' ri ya', xpe jun quiek'ik' yalan nim chiri' parui' ri ya'. Y romari' ri canoa anchi' je-benak-wi, can xoc ya' chupa. Y romari' juba' ta chic yebe chuxe' ya'. ");
INSERT INTO cakNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Pero ri Jesús xa niwer benak chupa ri canoa cuando najin ri quiek'ik' parui' ri ya'. Raja' chirij can ri canoa rucanon-wi jun ruch'acat-ruwi', y chiri' niwer benak. Y xepe c'a ri discípulos xquic'asoj y xqui'ij che: ¡Ajaf! ¡Ajaf! Roj ya jojcom y ret xa jawer, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Y ri Jesús xcataj-pe y xu'ij: Tiq'uis-e ri ruchuk'a' ri quiek'ik' y titane-ka ri ya'. Y quiri' xbanataj. Ri quiek'ik' xq'uis-e ri ruchuk'a' y xtane-ka chuka' ri ya'. ");
INSERT INTO cakNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ri Jesús xu'ij chique: ¿Anchique roma xixi'j-iwi'? ¿Can man iyo'n ta iwánima wiq'uin ren? ");
INSERT INTO cakNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Pero ri discípulos yalan quixi'n-qui' y niquic'utula' chiquiwech chirij ri Jesús: ¿Anchique c'a achi re'? Roma ri quiek'ik' y ri ya' can yeniman chuka' che. ");
INSERT INTO cakNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Y ri Jesús y ri ru-discípulos xe'apon ri juc'an chic ruchi-choy (ruchi-ya'), chiri' pa jun lugar rubinan Gadara. ");
INSERT INTO cakNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Y ri Jesús can xe xel-pe chupa ri canoa, can ja' xapon jun achi riq'uin. Jun achi ri pa cementerio elenak-wi-pe, roma ri achi ri' xa c'o itzel espíritu riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ri achi re' ja ri cementerio ri oconak rocho, y raja' hasta riq'uin cadena man je-tiquirinak ta riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Roma q'uiy mej (paj) quiximon ri ruk'a-rakan che ri cadena y ch'aka chic ch'ich', pero jerukupin y jeruk'ajon can. Can man jun tiquirinak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Raja' can niplakin pa tak juyu' y pa cementerio, nurak ruchi' nisiq'uin y nusocola-ri' che abaj. Can pak'ij chi chak'a' ri nu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Y cuando raja' xutzu-pe ri Jesús chinaj, can junanin xpe y xoxuquie' chech. ");
INSERT INTO cakNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y can riq'uin ruchuk'a' xch'o'n che ri Jesús y xu'ij: Ret Jesús ri Ralc'ual ri nimalaj Dios, ¿anchique najo' chue? Pa rubi' ri Dios ninc'utuj chawe, man quinach'ujrisaj, xcha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ri achi xu'ij quiri' roma ri Jesús ru'in chic che ri itzel espíritu ri c'o riq'uin ri achi chi tel-e. ");
INSERT INTO cakNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Y ri Jesús xuc'utuj che: ¿Anchique abi'? Y raja' xu'ij-pe: Legión ri nubi'; roma man nuyon ta, xa can je q'uiy chuka' ri jec'o wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Y can yalan xuc'utuj che ri Jesús chi tu'ona' favor man quierulesaj-e chupa ri lugar ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Y chunakaj apo ri lugar ri', parui' jun juyu', yalan je q'uiy ak yewa'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Y xepe conojel ri itzel tak espíritus ri jec'o riq'uin ri achi, xquic'utuj favor che ri Jesús. Y xqui'ij che: Taya' lugar chake chi jojoc quiq'uin ri ak la jec'o la'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ri Jesús xu'ij chique chi utz. Y ri itzel tak espíritus can ja' xe'el-e y xebe'oc quiq'uin ri ak. Ri ak ri' can yalan je q'uiy. Jec'o jun ca'i' mil. Y conojel ri ak ri' junanin xebexule-pe chech jun juyu' can pa'l-rech, y c'a pa ya' xebeka-wi. Can conojel ri ak ri' xejik' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Y ri yechajin ri ak, xe xquitzu' ri xbanataj, xelumaj (xenimaj) y xbequiya' rutzijol pa tenemit y pa tak juyu'. Romari' ri winak xepe chi xoquitzu' ri xbe'ix chique. ");
INSERT INTO cakNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Y cuando ri winak ri' xeloka riq'uin ri Jesús, xquitzu' chi ri achi ri xec'ue' itzel tak espíritus riq'uin, ch'ocol, rucusan rutziak y man nu'on ta chic ri anche'l rubanon-pe. Romari' ri winak xa xquixi'j-qui' roma ri xquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ri winak ri xquitzu' ri xbanataj riq'uin ri achi ri xe'leses-e ri itzel tak espíritus riq'uin y ri xbanataj quiq'uin ri ak, xquitzijoj-ka chique ri winak ri je-petenak chutz'etic ri xbanataj chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Romari' ri winak xquic'utuj favor che ri Jesús chi tel-e chupa ri lugar ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Cuando ntoc-e ri Jesús pa canoa, ri achi ri xec'ue' itzel tak espíritus riq'uin, xuc'utuj favor che ri Jesús chi tuya' lugar che chi nibe riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero ri Jesús man xrojo' ta. Xa xu'ij che: Catzolaj chi'awocho, y atzijoj chique ri awach'alal chi xe'leses ri itzel tak espíritus awiq'uin, roma xjoyowex awech roma ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Y ri achi xbe y xutz'om rutzijoxic ri xu'on ri Jesús riq'uin. Raja' xutzijoj chique ri winak ri jec'o chupa ri lugar rubinan Decápolis. Y ri winak can yalan xsatz quino'j (xsach quic'u'x) roma ri jun achi ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Y ri Jesús y ri ru-discípulos xe'oc chic pa canoa chi xek'ax chic juc'an ruchi-ya'. Y cuando xe'apon yan ri juc'an chic ruchi-ya', yalan je q'uiy winak ri xquimol-qui' riq'uin. Raja' chunakaj ri choy (ya') xc'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Y chiri' xapon-wi chuka' jun achi rubinan Jairo. Ri achi re' c'o jun rusamaj chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. Ja raja' ri encargado chiri'. Y cuando ri Jairo xutzu-apo ri Jesús, can ja' xbexuquie' chech. ");
INSERT INTO cakNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y raja' xu'ij che ri Jesús: Ri numi'al niyawaj y ya nicom. Tabana' favor aya' ri ak'a' pa ruwi' chi nicolotaj chech ri camic y can xtic'ase', xcha' ri achi. Y ri achi ri' can yalan xuc'utuj favor che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Y ri Jesús can xbe-wi riq'uin ri achi, y je q'uiy chuka' winak xquitzeklebej-e, romari' man utz ta chic yebin, xa can niquipitz' ri Jesús je-benak. ");
INSERT INTO cakNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Y chiquicojol ri winak ri' benak chuka' jun ixok ri c'o jun ruyabil. Ri ixok ri' c'o yan cablajuj juna' ri nibin ruquiq'uiel y man nitane' ta. ");
INSERT INTO cakNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Raja' yalan rubanon-pe sufrir roma benak yan quiq'uin q'uiy winak ri yek'oman, xuq'uis yan chuka' ronojel ri ru-mero y man jun utz rilon, xa más niyori-ka benak. ");
INSERT INTO cakNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ri ixok ri' c'o ruc'oxan-pe chirij ri Jesús. Raja' benak chuka' chiquicojol ri winak ri je-benak chirij ri Jesús, y raja' xunim-apo-ri' chirij ri Jesús y xutz'om-apo juba' ri rutziak. ");
INSERT INTO cakNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Roma ri ixok ri' can ru'in-ka pa ránima: Xa riq'uin ta nintz'om-apo juba' ri rutziak ri Jesús, nitane-ka nuyabil, ru'in-ka raja' pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y can ja' xtane' ri nibin ri ruquiq'uiel. Raja' can xuna' chi xc'achoj riq'uin ri ruyabil. ");
INSERT INTO cakNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ri Jesús can ch'anin xuna' chi c'o jun xc'achoj roma ri uchuk'a' ri c'o riq'uin; romari' xtzu'n can chirij, y xu'ij chique ri winak: ¿Ancu'x (Anchique) xtz'amo ri nutziak? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Pero ri ru-discípulos xqui'ij che: Ret nac'utuj ancu'x (anchique) ri xtz'amo awichi, pero we' manak xtana'ej, roma can je q'uiy ri winak jatquipitz', xecha' ri discípulos che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús yerutzu' ri winak, nucanoj ri ancu'x (anchique) xtz'amo ri rutziak. ");
INSERT INTO cakNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Y ri ixok ruxi'n-ri' y nibarbot c'a, roma xa ja raja' ri xtz'amo ri rutziak ri Jesús, y can xk'ax-wi ri ruyabil; romari' raja' xoxuquie' chech ri Jesús y xu'ij ronojel ri xu'on. ");
INSERT INTO cakNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Y ri Jesús xu'ij che ri ixok: Numi'al, xacolotaj roma xaya' awánima wiq'uin. Cami catzolaj chawij; ri awánima xril yan uxlanen. Ri ayabil manak chic xtitzolaj-pe, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Y c'a nitzijon ri Jesús riq'uin ri ixok, cuando jec'o ri xeloka riq'uin je-petenak chirocho ri Jairo, ri achi encargado pa sinagoga. Ri achi'a' ri xeloka xoqui'ij che ri Jairo: Ri ami'al xcom yan, cami manak chic nic'atzin chi nac'uaj ri Maestro, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero ri Jesús can xuc'oxaj, y ch'anin xu'ij che ri achi ri encargado pa sinagoga: Man tuxi'j-ri' ri awánima roma ri xo'ix chawe, taya' ri awánima wiq'uin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Y ri Jesús xe ri Pedro, ri Jacobo y ri Juan ri rach'alal ri Jacobo, ri xeruc'uaj-e. ");
INSERT INTO cakNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Y cuando xe'apon chirocho ri achi encargado pa sinagoga, ri Jesús xerutzu' chi ri winak yech'ujlan pa jay y can yalan ye'ok'. ");
INSERT INTO cakNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ri Jesús oconak chic apo, xu'ij chique ri winak: ¿Anchique roma jixok' y jixch'ujlan? Ri ac'ual xa man caminak ta, raja' xe niwer, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Pero reje' xa xetze'n chirij ri Jesús, roma quieta'n chi ri ac'ual can caminak chic. Pero ri Jesús xu'ij chique ri winak chi quie'el-pe. Raja' xerucusaj-apo ri rute-rutata' ri xten y ri je oxi' chic ri je-benak chirij, chupa ri jay anchi' c'o-wi ri ruch'acul ri xten. ");
INSERT INTO cakNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Raja' xutz'om ruk'a' ri caminak y xu'ij: Talita, cumi, xcha'. Ri tzij re' nu'ij: Nóya, chawe ret nin-ij: Cacataj. ");
INSERT INTO cakNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Can xe xu'ij quiri' ri Jesús, can ja xcataj-pe ri xten y xbin, roma cablajuj yan rujuna'. Y ri jec'o riq'uin, xsatz quino'j (xsach quic'u'x) cuando xquitzu' chi xc'ase' chic pe. ");
INSERT INTO cakNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero ri Jesús yalan xuchelebej chique chi can man tiquitzijoj ri xbanataj, y chuka' xu'ij chi tiyo'x ruway ri xten. ");
INSERT INTO cakNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Y ri Jesús y ri ru-discípulos xe'el-e chiri' y xebe pa Nazaret ri tenemit anchi' xq'uiy-pe raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Y cuando xapon ri k'ij chi uxlanen, raja' xuc'ut rutzij ri Dios pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. Y roma ri tzij ri yeru'ij, ri winak ri quimolon-qui' chiri' can xsatz quino'j (xsach quic'u'x) y xqui'ij: ¿Anchique roma ri achi re' yalan runo'j (runa'oj) y nitiquier yeru'on milagros? ¿Anche'l ri nitiquier nu'on ronojel re'? ");
INSERT INTO cakNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ri achi re', xa jare' ri carpintero, ri ral ri María, cach'alal ri Jacobo, ri José, ri Judas y ri Simón. Y ri je rana' xa chikacojol roj jec'o-wi, xecha'. Romari' ri winak can man xquinimaj ta ri Jesús, roma raja' xa aj-chiri' chuka'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Y ri Jesús xu'ij chique ri winak ri': Jun ri nuk'alajij ri ni'ix che roma ri Dios, xe ri winak pa rutenemit, ri rach'alal y ri jec'o pa rocho ri can man jun ruk'ij niqui'en che, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Y chupa ri rutenemit, ri Jesús man q'uiy ta milagros xu'on. Xe jujun oc yawa'i' xuya' ruk'a' pa quiwi' chi xec'achoj. ");
INSERT INTO cakNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Y raja' can anchique la xuna' roma xerutzu' chi ri winak ri aj-chiri' pa rutenemit, xa can man xquiya' ta cánima riq'uin. Raja' xbe pa cocoj tak tenemit ri jec'o-pe chunakaj ri rutenemit. Raja' xuc'ut rutzij ri Dios chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Después ri Jesús xeroyoj ri cablajuj discípulos. Y chi caca' chi caca' xerutak-e chi ne'quibana' ri samaj, y xuya-e uchuk'a' chique chi yetiquier yequilesaj ri itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Y raja' xu'ij chuka' chique chi xe quich'ami'y tiquic'uaj-e y man jun chic anchique tiquic'uaj. Man tiquic'uaj quichim, man tiquic'uaj wey y chuka' can man tiquic'uaj qui-mero pa tak ruximbel-quipa; xa can man jun mero ri xtic'atzin chique. ");
INSERT INTO cakNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Man tiquic'uaj-e ca'i' quitziak. Pero utz chi niquicusaj-e quixajab. ");
INSERT INTO cakNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y ri Jesús xu'ij chuka' chique ri ru-discípulos: Ri tenemit anchi' jixapon-wi; cuando jixoc pa jun jay, chiri' quixc'ue-wi-ka. Xa c'aja' ri jixel-pe chiri', ja' xtiya' can ri jay ri anchi' xixc'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Y xa ri anchi' jixapon-wi, ri winak man utz ta niquic'ul iwech y man niquijo' ta chuka' niquic'oxaj rutzij ri Dios ri nitzijoj rix chique, can ja' quixel-pe chiri'. Y titota' can ri pokolaj ri c'o pa tak iwakan chiquiwech ri winak ri', chi tiquina'ej chi can man utz ta ri xqui'en. Roma ren can nin-ij chiwe, chi chupa ri k'ij cuando ri winak xquie'an juzgar roma ri Dios, ri winak chi ri tenemit anchi' man utz ta xc'ul iwech, can más nim ri castigo ri xtika pa quiwi', que chech ri castigo ri xtika pa quiwi' ri winak ri xec'ue' pa tenemit Sodoma y Gomorra, xcha-e chique. ");
INSERT INTO cakNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Y ri discípulos xebe. Reje' xqui'ij chique ri winak chi tiquiya' can ri quimac y tiquibana' ri nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ri discípulos q'uiy itzel tak espíritus ri xequilesaj. Y chuka' xquiyala' aceite olivo pa quiwi' je q'uiy yawa'i' y xequic'achojrisaj can. ");
INSERT INTO cakNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Y ri rey Herodes can xuc'oxaj chi ri Jesús yalan rutzijol chiquicojol ri winak. Pero ri Herodes xu'ij-ka pa ránima chi ri Jesús, xa ja ri Juan Bautista ri xc'astaj-pe chiquicojol ri caminaki', y romari' c'o ri uchuk'a' pa ruk'a' chi q'uiy ri nitiquier yeru'on, xcha-ka raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Pero jec'o winak xqui'ij chi ri Jesús xa ja ri Elías. Y jec'o ch'aka chic xqui'ij chi raja' jun achi ri nik'alajin ri ni'ix che roma ri Dios, y chuka' xqui'ij chi raja' jun chique ri achi'a' ri xek'alajin rutzij ri Dios chupa ri ojer can tiempo. ");
INSERT INTO cakNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Pero cuando ri rey Herodes xuc'oxaj ri niqui'ij ri winak, xu'ij: Ri Jesús xa ja ri Juan Bautista ri xintak rukupixic rukul, y cami xc'astaj-pe chiquicojol ri caminaki', nicha'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ri rey Herodes quic'amon-ka-qui' riq'uin ri Herodías, y ri ixok ri' xa raxayil ri Felipe ri rach'alal ri Herodes. Y romari' ri Herodes xu'ij chi titz'om ri Juan, tiyo'x pa cárcel y tixime' che cadena. ");
INSERT INTO cakNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Quiri' xu'on ri Herodes che ri Juan, roma ri Juan xu'ij che: Man utz ta chi abanon-ka awaxayil che ri Herodías, roma raja' xa raxayil ri awach'alal Felipe. ");
INSERT INTO cakNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Romari' ri Herodías can rurayin chi rucamisan yan ta ri Juan roma can itzel nutzu', pero man pa ruk'a' ta raja' c'o-wi, romari' man tiquirinak ta riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ri rey Herodes can reta'n-wi chi ri Juan jun chojmilaj y lok'olaj achi chech ri Dios, y can nuxi'j-ri' chech. Can ruchajin chi quiri' man jun anchique tuc'ulumaj pa ruk'a' ri Herodías. Raja' can jabel nuc'oxaj cuando ri Juan nutzijoj rutzij ri Dios che. Pero can man nril ta anchique nu'on. ");
INSERT INTO cakNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Y ri k'ij ri yoben roma ri Herodías chi nika ri Juan pa ruk'a', xapon chupa ri k'ij cuando ri rey Herodes xtzakon jun chic rujuna'. Raja' xuya' jun wa'in y xeru'on invitar ri achi'a' ri c'o quik'ij ri yesamaj pa ru-gobierno, xeroyoj ri qui-jefes ri soldados y xeroyoj chuka' ri achi'a' ri c'o yalan quik'ij chiquicojol ri aj-Galilea. ");
INSERT INTO cakNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Y ri anchi' quimolon-wi-qui' reje', xoc-apo jun xten ral ri Herodías; y raja' xxajo chiquiwech. Y ri xajoj ri xu'on ri xten, yalan xka chech ri rey Herodes y chiquiwech conojel ri jec'o riq'uin. Y ri rey Herodes xu'ij che ri xten: Tac'utuj ri anchique najo' y ninya' chawe. ");
INSERT INTO cakNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Can nin-en jurar chawech, chi xabachique (xama'anchique) ri xtac'utuj chue, xtinya' chawe, hasta nic'aj che ri rech-ulef c'o pa nuk'a', xcha' ri rey Herodes che ri ral ri Herodías. ");
INSERT INTO cakNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Pero ri xten, xe xuc'oxaj ri xu'ij ri rey Herodes, xel-e y xberu'ij che ri rute': ¿Anchique ta ninc'utuj che ri rey Herodes? Roma raja' xu'ij chue chi anchique ri xtinjo', can xtuya' chue, xcha' ri xten che ri rute'. Xpe ri te'j xu'ij che ri ral: Tac'utuj chi ticamises ri Juan Bautista y ri rujolon tiyo'x chawe. ");
INSERT INTO cakNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Y ri xten can ja' xtzolaj-apo riq'uin ri rey Herodes y xberu'ij che: Ren ninjo' chi cami yan naya' chue pa jun plato, ri rujolon ri Juan Bautista, xcha' che ri rey Herodes. ");
INSERT INTO cakNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Y ri rey Herodes yalan xbison-ka ránima romari', pero roma can rubanon yan jurar che ri xten chi can xtuya-wi che ri anchique nrojo' y roma chuka' xa can chiquiwech ri jec'o riq'uin chuchi' mesa xu'ij-wi, romari' can nic'atzin-wi nu'on ri xu'ij; y xa man xtuya' ta, q'uix chirij raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Y ri rey can ja' xutak-e jun soldado chi teruc'ama-pe ri rujolon ri Juan Bautista. ");
INSERT INTO cakNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Y ri soldado ja xbe chi xberukupij rukul ri Juan Bautista chiri' pa cárcel. Y ri rujolon xuc'om-pe che ri xten pa jun plato y ri xten xberuya' che ri rute'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Cuando ri ru-discípulos ri Juan xquic'oxaj chi xcamises, xbequic'ama' ruch'acul y xbequimuku'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ri je ru-apóstoles ri Jesús ja' xetzolaj-pe banoy rusamaj ri Dios y xquimol chic qui' riq'uin ri Jesús. Reje' xquitzijoj che ronojel ri xqui'en y ri xquic'ut chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Y ri Jesús xu'ij chique: Jo' pa jun lugar anchi' manak winak chi jixuxlan juba'. Y quiri' xu'ij chique roma can je yalan winak ri ye'el-ye'oc quiq'uin y romari' hasta man jani' ta chic yewa'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Y ri Jesús y ri ru-discípulos xe'oc pa jun canoa chi yek'ax juc'an ruchi-ya', pa jun lugar anchi' manak winak. ");
INSERT INTO cakNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero cuando reje' xe'el-e, je q'uiy winak ri xetz'eto quichi y xquitemaj-e quiwech. Romari' ri winak junanin xebe chicakan, xquimol-e-qui' ri pa bey; ri pa tak tenemit ri xek'ax-wi. Y xa ja yan chic reje' ri xe'apon na'ey. Y cuando ri Jesús y ri ru-discípulos xe'apon, ri winak xquimol-ka-qui' chiquij. ");
INSERT INTO cakNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Y cuando ri Jesús xel-pe chupa ri canoa, xutzu' chi yalan je q'uiy ri winak ri quiyoben-apo chiri'. Raja' xujoyowaj quiwech, roma ri quibanon, can anche'l ovejas cuando man jun nichajin quichi. Xuc'ut chiquiwech, chi q'uiy nic'atzin niquitemaj chirij rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Pero cuando xkak'ij yan ka, ri ru-discípulos ri Jesús xebe-apo riq'uin y xqui'ij che: Chupa ri lugar re' man jun winak jec'o y yalan xkak'ij yan ka. ");
INSERT INTO cakNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ta'ij chique ri winak chi quiebe pa tak cocoj tenemit y pa ch'aka chic lugar ri jec'o-pe chunakaj, chi tiquilok'o' quiway, roma xa man jun quiway chi niquitaj, xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Pero ri Jesús xu'ij chique: Tiya' quiway rix, xcha' chique. Y reje' xqui'ij che: ¿Ret na'ij chi ne'kalok'o' doscientos denarios wey chi yewa' reje'? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Y raja' xuc'utuj chique: ¿Jani' wey c'o iwiq'uin? Itz'eta' na c'a. Y cuando reje' quitz'eton chic, xqui'ij: C'o wo'o' wey y ca'i' quer, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Raja' xu'ij chi tiqui'ij chique ri winak chi quiech'oquie' conojel parui' ri rex k'ayis, y chi grupo quiech'oquie' ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Y ri winak ri' can xech'oquie' parui' ri k'ayis, y xquic'uaj-qui' chi ciento y nic'aj tak ciento. ");
INSERT INTO cakNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Y ri Jesús xeruli'ej pa ruk'a' ri wo'o' wey y ri ca'i' quer, xtzu'n chicaj y xuya' matiox che ri Dios. Raja' xeruper ri wey, y xuya' chique ri ru-discípulos chi niquiya' chique ri winak. Y quiri' chuka' xu'on riq'uin ri quer. Xujach chique conojel. ");
INSERT INTO cakNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Can conojel xewa' utz y can utz xnoj quipa. ");
INSERT INTO cakNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Y c'o cablajuj chaquech wey y quer ri xmolotaj, ri man xq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Can yalan-wi je q'uiy winak ri xewa'; xe ri achi'a' jec'o wo'o' mil. ");
INSERT INTO cakNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Y ri Jesús can ja' xu'ij chique ri ru-discípulos chi quie'oc chupa ri canoa, y quiena'ey-e chech; chi yebe pa Betsaida, ri tenemit ri c'o juc'an ruchi-ya'. Y raja' xc'ue' can chi xeru'on despedir ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Y cuando xebe yan conojel ri winak, raja' xjote-e parui' jun juyu' chi nu'on orar. ");
INSERT INTO cakNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ri Jesús xc'ue' can pa ulef, pero ri discípulos je-benak pa canoa y naj yan quiebin parui' ri ya'. Pa runic'ajal chic ri ya' jec'o-wi cuando xk'okumer-ka. ");
INSERT INTO cakNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Y ri Jesús xutzu' chi ri ru-discípulos man choj ta nibin ri canoa chiquiwech, roma ri quiek'ik' nurok rech ri canoa y nuc'uaj chirij. Y ja' yan nisakar-ka, nik'ax yan ri ak'a' ri', ri Jesús nibin chirakan parui' ri ya' benak-apo, y nrojo' nik'ax chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero cuando ri discípulos xquitzu' chi c'o jun petenak parui-ya', xesiq'uin-ka conojel. Roma reje' xquinojij chi ri petenak parui' ri ya' xa jun xibinel. ");
INSERT INTO cakNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Y roma can conojel xetz'eto richi, xquixi'j-qui'. Y romari' ri Jesús can ja' xch'o'n chique y xu'ij: Man tixi'j-iwi'; tiya' iwánima wiq'uin. Ja ren ri Jesús, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Y raja' xoc quiq'uin pa canoa. Y can ja' xtane-ka ri ruchuk'a' ri quiek'ik'. Y ri discípulos yalan xsatz quino'j (xsach quic'u'x). ");
INSERT INTO cakNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Y man jani tiquinimaj ri Jesús riq'uin ri milagro xu'on riq'uin ri wey. Chiquiwech reje' can man nitiquier ta nu'on xabachique (xama'anchique) milagros. Y reje' xa cowirinak ri cánima. ");
INSERT INTO cakNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Y reje' xek'ax parui' ri choy (ya') ri' y xe'apon chuchi-ya' pa Genesaret. ");
INSERT INTO cakNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Y xe xe'el-pe pa canoa, ri winak ri jec'o chiri' chuchi' ri ya', ch'anin xquitemaj rech chi ja ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Romari' xquiya' rutzijol pa ronojel lugar ri jec'o-pe chunakaj, chi ri Jesús c'o chiri'. Y ri winak yequic'amala-pe ri quiyawa'i'. Can ronojel lugar xec'amer-pe ri yawa'i' chech ri quich'at, y yequic'uaj c'a anchi' xquic'oxaj chi c'o-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y xabachique (xama'anchique) lugar xapon-wi, pa tak nima'k tenemit, pa tak cocoj tenemit y pa tak juyu' chuka', ri winak xequiyala' ri yawa'i' pa tak bey ri anchi' nik'ax-wi raja'. Yalan favor niquic'utuj che: Can xe taya' lugar chake chi nakatz'om ruchi-atziak chi jojc'achoj, xecha' che. Y conojel ri xetz'amo ruchi-rutziak ri Jesús, xec'achoj riq'uin ri quiyabil. ");
INSERT INTO cakNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Y chirij ri Jesús xquimol-qui' ri achi'a' fariseos, y chuka' jujun maestros chi ri ley ri je-petenak pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Y ri achi'a' ri' xequitzu' chi jec'o chique ri ru-discípulos ri Jesús ri man niquich'aj ta quik'a' cuando yewa', man xka ta chiquiwech. Roma chiquiwech reje' can man ch'ajch'oj ta quik'a'. Y romari' q'uiy ri xqui'ij chiquij, roma man niqui'en ta anche'l niqui'en reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Roma ri achi'a' fariseos y conojel ri ch'aka chic winak israelitas, xa ja ri bin can coma ri ojer tak winak, xa jari' ri yequi'en. Roma xa man niquich'aj ta quik'a' q'uiy mej (paj), ja man yewa' ta. ");
INSERT INTO cakNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y cuando yetzolaj-pe pa c'ayibel, xa man niquijosk'ij ta qui' anche'l ri bin can, can man yewa' ta. Y jec'o ch'aka chic ex ri niqui'en chuka'; anche'l ri quijosk'ixic niqui'en che anchok chupa ye'uq'uia', ri xára, ri ch'ich' tak lak y chuka' ri rujosk'ixic ri niqui'en che ri quich'at. Quiri' ri yequi'en reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Romari' xepe ri achi'a' fariseos y ri maestros chi ri ley, xquic'utuj che ri Jesús: ¿Anchique roma ri a-discípulos man niqui'en ta anche'l ri bin can coma ri ojer tak winak? Reje' yewa' y man niquich'aj ta utz quik'a'. Man niqui'en ta anche'l naka'an roj, xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Pero ri Jesús xu'ij chique ri achi'a' ri': Rix xa ca'i' ipalaj. Xa can utz rubixic rubanon can ri Isaías chiwij. Ri xu'ij ri Dios che chi xutz'ibaj can, nu'ij: Ri winak re' xe riq'uin ri quichi' niquiya' nuk'ij, pero pa cánima xa man quiri' ta, roma xa can naj c'o-wi cánima chi niquiya' nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Xa man jun nic'atzin-wi ri niqui'en cuando niquiya' nuk'ij, ronojel ri yequi'ij cuando yequitijoj ri winak, xa quino'j (quina'oj) achi'a' y niqui'ij chi can jari' ti'an. Quiri' ri rutz'iban can ri Isaías. ");
INSERT INTO cakNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Y rix jari' ri niben. Xa iyo'n can ri ru'in ri Dios chi niben. Rix can man niben ta ri nrojo' ri Dios, xa ja ri niqui'ij ri winak, xa jari' ri ye'iben. Anche'l ni'ij rix chirij ri anchique modo nijosk'ij ri xára y ri anchok chupa jixuq'uia'. Y jec'o ch'aka chic ex anche'l ri', ri ye'iben. ");
INSERT INTO cakNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Y ri Jesús xu'ij chuka' chique: Rix, roma niben ri qui'in can ri ojer tak winak, romari' imalin can jumul ri ru'in can ri Dios chi niben. ");
INSERT INTO cakNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Roma ri tzij ri jerutz'iban can ri Moisés, nu'ij: Quie'abana' respetar ri ate-atata'. Y jun ri itzel yerutzu' rute-rutata', ticamises; can man tijoyowex rech. Quiri' ri tz'iban can chupa rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero rix xa man quiri' ta ri niben y nic'ut. Xa man niben ta anche'l ri ru'in can ri Dios. Rix xa ye'itijoj ri winakchi quiri' man yequito' ta ri quite-quitata'. Roma niqui'ij chique ri quite-quitata': Ren man yitiquier ta jixinto', roma ri c'o wiq'uin xa Corbán. Ri tzij re' nu'ij: Nusujun chic che ri Dios. Y roma niqui'ij quiere', manak chic yequito' ri quite-quitata', jari' ri nic'ut rix. ");
INSERT INTO cakNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y riq'uin ri ni'ij, can k'alaj chi rix niben chique ri winak chi can man jun chic anchique tiquiya' chique ri quite-quitata'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Riq'uin ri', rix can man jun ruk'ij ibanon che ri ru'in can ri Dios. Roma xe ri qui'in can ri ojer tak winak, xe ri' nijo' niben. Y jec'o chuka' ch'aka chic ex anche'l re' ri ye'iben. Quiri' xu'ij ri Jesús chique ri achi'a' fariseos y ri maestros chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Y ri Jesús xch'o'n chic jun mej (bey) quiq'uin ri winak ri quimolon-apo-qui' chiri' y xu'ij chique: Tic'oxaj chi'iwonojel ri xtin-ij chiwe y tibana' entender. ");
INSERT INTO cakNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ri nutz'iluj ránima jun winak man ja' ta ri ex ri yerutaj-ka. Ri nutz'iluj ránima jun winak xa ja ri itzel ex ri yepe pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ri c'o ruxiquin, can tuc'oxaj ri xin-ij. Quiri' xu'ij ri Jesús chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Y raja' ja' xeruya' can ri winak, y xbe pa jun jay. Y ri discípulos xquic'utuj che chirij ri nutz'iluj ránima jun winak. ");
INSERT INTO cakNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Y ri Jesús xu'ij chique: ¿Can junan ibanon rix quiq'uin ri ch'aka chic winak roma man niben ta entender ri nin-ij? ¿Can man niben ta entender chi xa man ja' ta ri nutaj-ka jun winak ri nutz'iluj ránima? ");
INSERT INTO cakNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ronojel ri nutaj-ka jun winak, xa man pa ránima ta nibe-wi. Xa chupa nika-wi-ka, y c'ajari' nibe pa ulef. Y roma ri quiri' xu'ij ri Jesús, xuk'alajij chi ronojel ri yetej, can je utz-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Y ri Jesús xu'ij chuka' chi ja ri itzel tak ex ri yepe pa ránima jun winak, jari' ri nitz'ilun richi. ");
INSERT INTO cakNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Roma xa pa cánima ri winak yepe-wi ri itzel tak no'j (na'oj). Chiri' nipe-wi ri no'j (na'oj) cuando ri winak ri je-c'ulan y ri man je-c'ulan ta niquicanola-qui' chi niqui'en mac. Y chiri' nipe-wi chuka' ri banoj-camic. ");
INSERT INTO cakNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Pa cánima ri winak nipe-wi ri jalajoj tak no'j (na'oj), cuando ye'elak', cuando niquirayij chi ronojel ri c'o chech-ulef c'o ta quiq'uin reje', itzel quino'j (quina'oj), niqui'en engaño, ri achi'a' y ri ixoki' niqui'en mac ri yalan yeq'uixbisan, itzel niquitzu' jun winak ri utz c'o, yequi'ij itzel tak tzij chiquij ri ch'aka chic, niquina' chi can yalan quik'ij, can anche'l je ch'u'j. ");
INSERT INTO cakNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronojel ri itzel tak ex ri', pa cánima ri winak yepe-wi, y jari' ri nitz'ilun quichi. Quiri' xu'ij ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ri Jesús y ri ru-discípulos xe'el-pe chiri' y xebe c'a pa jun lugar chiquinakaj ri tenemit quibinan Tiro y Sidón. Y xec'ue' pa jun jay. Ri Jesús man nrojo' ta chi nina'ex chi c'o chiri'. Pero man xtiquier ta xrewaj-ri'; ");
INSERT INTO cakNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","xa can ch'anin xna'ex-pe roma jun ixok ri c'o jun ral-xten, ri c'o jun itzel espíritu riq'uin. Ri ixok ri' can xe xuc'oxaj chi ri Jesús c'o chiri', can ja' xpe riq'uin. Raja' xoxuquie' chech. ");
INSERT INTO cakNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ri jun ixok ri' man israelita ta. Raja' jun aj-sirofenicia. Pero xoxuquie' chech ri Jesús chi xuc'utuj favor che chi tulesaj-e ri itzel espíritu riq'uin ri ral. ");
INSERT INTO cakNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero ri Jesús xu'ij che ri ixok: Ri ruyo'n-pe ri Dios man utz ta chi chique xabachique (xama'anchique) ninya-wi. Ja ri nuwinak israelitas yento' na'ey. Roma man utz ta chi nimaj quiway ri ac'uala' y xa chique tz'i' niyo'x-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Pero ri ixok xu'ij che ri Jesús: Ajaf, can ketzij-wi ri na'ij. Pero can jojtiquier chuka' nakasic'-apo juba' che ri ruyo'n-pe ri Dios, anche'l niqui'en ri tz'i' chuxe' mesa, yequitijla' ri rupixc'al tak wey ri niquitzakla-ka ri ac'uala'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Y ri Jesús can ja' xu'ij che ri ixok: Ri xa'ij can quiri-wi. Cami catzolaj chawij, roma ri itzel espíritu xel yan e riq'uin ri awal, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Y ri ixok xtzolaj chirocho. Y xberila' ri ral cotz'ol chech ch'at. Y ch'anin chuka' xutzu' chi ri itzel espíritu manak chic riq'uin ri ral. ");
INSERT INTO cakNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ri Jesús y ri ru-discípulos xe'el-pe chupa ri lugar ri chunakaj ri tenemit Tiro y xebek'ax-pe pa Sidón. Y xebek'ax-pe chuka' chupa ri lugar rubinan Decápolis, y quiri' xeloka chuchi' ri choy (ya') rubinan Galilea. ");
INSERT INTO cakNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiri' jec'o-wi cuando xc'amer-pe jun achi chech ri Jesús, jun achi ri man nic'oxan ta y man nitiquier ta nich'o'n utz. Y ri je-c'amayon-pe richi, xquic'utuj favor che ri Jesús chi tuya' ruk'a' pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Y ri Jesús xuc'uaj juba' aparte ri achi ri'. Xuju' rui-ruk'a' pa tak ruxiquin, xchuban, y quiri' xutz'om ri rak'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Y ri Jesús xtzu'n chicaj, xjik'ijo' y xu'ij: Efata. Ri tzij re' nu'ij: Tijakataj. ");
INSERT INTO cakNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Y ri achi can ja' xc'oxan y xtiquier xch'o'n utz. ");
INSERT INTO cakNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Y ri Jesús xuc'om-pe ri achi y xu'ij chique ri winak chi can man tiquitzijoj ri xbanataj. Pero más que ri Jesús yalan xuchelebej chique chi can man tiquitzijoj, xa jari' ri más xqui'en reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ri winak ri' can xsatz quino'j (xsach quic'u'x) cuando xquitzu' ri xbanataj, y niqui'ij: Can jabel ri yeru'on. Nu'on chique ri man yec'oxan ta chi yec'oxan; y nu'on chuka' chique ri man yech'o'n ta chi yech'o'n, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupa ri tiempo ri' can je q'uiy winak ri xquimol-apo-qui' riq'uin ri Jesús. Pero ri winak re' manak quiway, romari' ri Jesús xeroyoj ri ru-discípulos y xu'ijchique: ");
INSERT INTO cakNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Yalan ninjoyowaj quiwech ri winak re', roma ja yan oxi' k'ij jec'o-pe wiq'uin y manak quiway. ");
INSERT INTO cakNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Y xa xquientak ta chi tak cocho xe quiri', man utz ta, roma can jec'o ri can naj je-petenak-wi; xa xquiebetzak pa tak bey roma man je-waynak ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Y ri ru-discípulos xqui'ij che: Chupa ri lugar re' manak winak. ¿C'o como anchi' ne'kila-wi-pe wey chi yewa' conojel ri winak re'? xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Pero ri Jesús xuc'utuj chique ri ru-discípulos: ¿Jani' wey c'o iwiq'uin? xcha' chique. Y reje' xqui'ij: C'o wuku', xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Y Jesús xu'ij chique ri winak chi quiech'oquie-ka chech-ulef. Y xeruli'ej pa ruk'a' ri wuku' wey y xuya' matiox che ri Dios. Y ja xeruper y xuya' chique ri ru-discípulos chi niquiya' chique ri winak. Y ri ru-discípulos xquijach chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Y c'o chuka' jujun quer quiq'uin; y ri Jesús xuya' matiox che ri Dios coma ri quer ri', y ja xu'ij chi tijach chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ri winak can xewa' utz y can utz xnoj quipa; y c'a c'o wuku' chaquech wey y quer ri xmol can, ri man xq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xqui'en wa'in chupa ri k'ij ri', c'o la'k jun quieji' mil winak. C'ajari' ri Jesús xeru'on despedir ri winak, ");
INSERT INTO cakNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","y ja xoc-e pa canoa quiq'uin ri ru-discípulos, y xebe c'a pa jun lugar rubinan Dalmanuta. ");
INSERT INTO cakNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Y jec'o chique ri achi'a' fariseos ri xeloka riq'uin ri Jesús, y xquitz'amala-ka-qui' riq'uin tzij. Y chi niquitojtobej ri Jesús xqui'ij che chi tu'ona' jun milagro chicaj, chi tuc'utu-ri', xa can ja-wi ri Dios ri takayon-pe richi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Pero ri Jesús xjik'ijo'. Y xpe bis pa ránima, y ja' xu'ij: ¿Anchique roma ri winak chi ri tiempo re' niquijo' chi nin-en jun milagro chiquiwech? Pero can ketzij nin-ij chiwe que man ja' ta ri niquijo' reje' xtin-en, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Y ri Jesús xeruya' can ri achi'a' fariseos, y xoc-e pa canoa quiq'uin ri ru-discípulos, chi yek'ax c'a juc'an chic ruchi-ya'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Y ri discípulos xquimestaj quiway, y chiri' pa canoa xe jun wey c'o can. ");
INSERT INTO cakNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Y ri Jesús xu'ij chique ri ru-discípulos: Tic'oxaj ri xtin-ij chiwe, can tibana' cuenta iwi' chech ri levadura quichi ri achi'a' fariseos y richi ri Herodes, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Pero ri discípulos xa xqui'ij-ka chiquiwech: Raja' xu'ij quiri' roma manak xkac'om-pe kaway, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Pero ri Jesús can reta'n ri niquinojij ri ru-discípulos, romari' xu'ij chique: ¿Anchique roma rix ninojij chi roma manak kaway xin-ij quiri'? ¿Can man niben ta entender ri xin-ij? ¿Xa can cowirinak ri iwánima, romari' man niben ta entender? ");
INSERT INTO cakNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Rix c'o ri iwech, pero xa man jixtzu'n ta. C'o ixiquin, pero xa man jixc'oxan ta. ¿Can man jun chic noka pa iwi'? ");
INSERT INTO cakNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","¿Can man noka ta c'a pa iwi' cuando xentzuk ri wo'o' mil winak riq'uin ri wo'o' wey ri xenper chiquiwech? ¿Jani' chaquech ri xe'inojisaj riq'uin ri wey ri ximol can? xcha' chique. Y ri discípulos xqui'ij che ri Jesús: Cablajuj chaquech, xecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","¿Can man noka ta chic chuka' pa iwi' cuando xentzuk ri quieji' mil winak riq'uin ri wuku' wey ri xenper chiquiwech? ¿Jani' chuka' chaquech ri xe'inojisaj riq'uin ri wey ri ximol can? xcha' chique. Y ri discípulos xqui'ij che ri Jesús: Wuku' chaquech, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Y ri Jesús xu'ij chique: ¿Anchique roma man jani tiben entender ronojel ri'? ");
INSERT INTO cakNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ri Jesús y ri ru-discípulos xe'apon c'a pa Betsaida. Y xc'amer-pe jun achi moy chech. Y ri je-c'amayon-pe ri moy xquic'utuj favor che chi tuya' ruk'a' pa ruwi' chi quiri' ri achi moy nitiquier nitzu'n. ");
INSERT INTO cakNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Xpe ri Jesús xutz'om ruk'a' ri achi moy y xuc'uaj-e c'a chuchi' ri tenemit. Ri Jesús xuya' ruchub chi tak rech ri moy. Y xuya' ruk'a' pa ruwi' chuka'. Xuc'utuj che xa c'o nutzu'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Y cuando ri moy xerujak ri rech, xu'ij: Ja'. Yentzu' ri achi'a'. Yentzu' chi je anche'l che', pero xa yebin, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Y ri Jesús xuya' chic jun mej (bey) ruk'a' chi tak rech ri achi. Can xu'on che ri achi chi xtzu'n. Y ri achi xtzu'n jabel. Can jabel yerutzu' ronojel; chi naj y chunakaj. ");
INSERT INTO cakNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Y ri Jesús xutak ri achi chi tibe chirocho. Raja' xu'ij che: Man catoc-apo pa tenemit, y man jun anchok che tatzijoj-wi re'. Xa choj jat (cabin) chi'awocho, xcha-e ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Y ri Jesús y ri ru-discípulos xebe pa tak cocoj tenemit ri jec'o chiri' pa Cesarea chi ri Filipo. Y pa bey ri Jesús xuc'utuj chique ri ru-discípulos: ¿Jin ancu'x (anchique) ren, niqui'ij ri winak? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Y reje' xqui'ij che: Jec'o ye'in chi ja ret ri Juan Bautista. Jec'o ch'aka chic niqui'ij chi ja ret ri Elías, ri jun ri xk'alajin ri x-ix che roma ri Dios ojer can tiempo. Y jec'ochuka' ri ye'in chi ret jat jun chic chique ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios chupa ri ojer can tiempo, xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Y raja' xuc'utuj chique ri ru-discípulos: ¿Y rix anchique ni'ij? xcha' chique. Y ri Pedro can ja' xu'ij che ri Jesús: Ja ret ri Cristo, ri takon-pe roma ri Dios, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Y ri Jesús xu'ij chique chi can man tiquitzijoj ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Y ri Jesús xutz'om quitijoxic ri ru-discípulos y xu'ij: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, nink'axaj na q'uiy sufrimiento. Itzel xquitz'et coma ri rijilaj tak achi'a' ri c'o quik'ij. Itzel xquitz'et chuka' coma ri nimalaj tak sacerdotes. Chuka' itzel xquitz'et coma ri maestros chi ri ley. Y can xquicamises, pero pa rox k'ij xquic'astaj-pe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Y cuando ri Jesús xu'ij ri tzij re' chique ri ru-discípulos, can k'alaj-wi rubixic xu'on che. Pero ri Pedro man xka ta chech ri xu'ij ri Jesús, romari' xuc'uaj-e juba' aparte, y cof xch'o'n che. ");
INSERT INTO cakNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Pero cuando ri Jesús xuc'oxaj quiri', xutzalmayij-ri', xerutzu' ri ch'aka chic ru-discípulos y xu'ij che ri Pedro: Man cac'ue-pe wiq'uin ret Satanás, roma man utz ta ri nanojij. Roma ri nanojij ret xa can junan riq'uin ri niquinojij ri winak y man anche'l ta nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Y ri Jesús xeroyoj ri winak y ri ch'aka chic ru-discípulos. Y raja' xu'ij chique: Xa c'o jun nrojo' yirutzeklebej, can man tupokonaj-ri' nu'on sufrir, xa can tu'ona' anche'l can ruc'uan ru-cruz. Man tu'on ri nurayij raja'. Xa c'o jun nunojij nu'on quiri', can tipe wiq'uin y quirutzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Roma xa c'o jun ri yalan nrojo' ri ruc'aslen we' chech-ulef, man xtiril ta ruc'aslen ri manak xtiq'uis. Pero ri man nupokonaj ta ri', más que nicamises woma ren y roma ri utzilaj rutzij ri Dios, xticolotaj y can xtiril ruc'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Roma, ¿anchique ta nuch'ec jun winak xa nic'ue' ta ronojel ri beyomel ri c'o chech-ulef riq'uin y xa man nicolotaj ta? ");
INSERT INTO cakNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Y más que yalan ta q'uiy ri beyomel c'o riq'uin ri jun winak, can man xtitiquier ta xtulok' ri c'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Man jun tiq'uix nuk'alajij chi can jinruniman ren y ri nutzij. Man tiq'uix nuk'alajij-ri' chiquiwech ri winak chi ri tiempo re' ri can je aj-mac y can man niquijo' ta niquinimaj ri Dios. Xa c'o jun niq'uix nuk'alajij-ri' chiquiwech reje' chi jinruniman ren ri xika-pe chicaj y xinalex chi'icojol, ren chuka' xquiq'uix xtin-ij chi ri jun winak ri' can wichi ren. Quiri' xtin-en cuando xquitzolaj chic pe jun mej (bey) junan quiq'uin ri lok'olaj tak ángeles y can junan chic nuk'ij riq'uin ri Nata' Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Y ri Jesús xu'ij chuka' chique ri jec'o riq'uin: Tic'oxaj na pe'; can ketzij ri nin-ij chiwe, chi ri Dios can xtoc'ue' pa kawi' y xkojru'on gobernar; y can xtik'alajin ri ruchuk'a'. Y jec'o jujun chiwe rix ri man xquiecom ta, c'a tiquitzu' na ri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Y cuando xk'ax yan waki' k'ij, ri Jesús xerucha' ri Pedro, ri Jacobo y ri Juan, chi quiri' xe ri je oxi' ri' xeruc'uaj c'a parui' jun juyu' nim. Y ri Jesús xjalataj rech chiquiwech ri je oxi' ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Y chuka' ri rutziak can xjalataj rech. Can yalan rusakil xu'on, can anche'l ri tef ri nika, y hasta nich'ich'an. Y man jun winak ri nich'ajo tziak nitiquier nu'on sak che jun tziak anche'l ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Y cuando xquitzu', jec'o yan chic ri Elías y Moisés, yetzijon riq'uin ri Jesús. Ri achi'a' ri' je rusamajel ri Dios ri xec'ue' ojer can. ");
INSERT INTO cakNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Y ri Pedro xu'ij-apo che ri Jesús: Maestro, xcha' che. We' utz kabanon. Kabana' oxi' tak jay. Naka'an jun awichi ret, jun richi ri Moisés y jun richi ri Elías, xcha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro quiri' xu'ij-apo y man reta'n ta ri anchique yeru'ij-apo, xe nu'ij ri anchique noka pa ruwi' y man yerunojij ta utz. Ri oxi' discípulos yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Y ja' cuando c'o jun ajawa' (mukul) ri xka-pe pa quiwi'. Y chupa ri ajawa' (mukul) ri' c'o Jun ri xch'o'n-pe y xu'ij: Jare' ri Walc'ual y yalan ninjo'. Can tic'oxaj ri nu'ij raja', xcha-pe ri Dios chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Pero cuando ri discípulos xetzu'n chic apo, xquitzu' chi xa man jun chic c'o riq'uin ri Jesús. Xa ruyon chic c'o can. ");
INSERT INTO cakNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Y cuando reje' je-xulan-pe chech ri juyu', ri Jesús xuchelebej chique ri ru-discípulos: Man titzijoj ri xitzu'. Rix utz nitzijoj pero cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xic'astaj yan pe chiquicojol ri caminaki'; c'ajari' utz chi nitzijoj, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Y reje' can man xquitzijoj ta ri anchique xquitzu', pero niquic'utuj chiquiwech anchique ri xrojo' xu'ij ri Jesús riq'uin ri tzij; chi xtic'astaj chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Y c'ajari' ri oxi' discípulos xqui'ij che ri Jesús: Roj kabanon entender chi can ja ret ri Cristo ri takon-pe roma ri Dios. ¿Pero anchique roma ri maestros chi ri ley niqui'ij chi ja ri Elías noka na'ey, c'ajari' noka ri Cristo? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Y ri Jesús xu'ij chique: Can ketzij-wi chi ri Elías nipe na'ey y raja' noru'ona' ru'onic ronojel. Can anche'l ri bin can chirij. ¿Y anchique ni'ij rix? ¿Man ja' ta como xtibanataj cami chuka' ri tz'iban can chupa rutzij ri Dios chuij ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, chi can nink'axaj naq'uiy sufrimiento, y can man jun nuk'ij xti'an chue? ");
INSERT INTO cakNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Pero ren nin-ij chiwe chi ri Elías ri' xpe yan. Y yalan pokon xqui'en-e che. Can ronojel ri xquijo' xqui'en che. Can anche'l ri tz'iban can chupa rutzij ri Dios, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Cuando Jesús y ri oxi' ru-discípulos xe'apon quiq'uin ri ch'aka chic discípulos, raja' xutzu' chi yalan je q'uiy winak ri quimolon-qui' chiquij, chuka' jujun maestros chi ri ley quitz'amon-qui' riq'uin tzij quiq'uin ri discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Conojel, can xe xquitzu' chi petenak ri Jesús, xsatz quino'j (xsach quic'u'x), y junanin xbequic'ulu' y xqui'en saludar. ");
INSERT INTO cakNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Y ri Jesús xuc'utuj chique: ¿Anchok chij itz'amon-wi-iwi' quiq'uin reje'? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Pero jun chique ri winak xu'ij che ri Jesús: Maestro, xcha' che. Ren nuc'amon-pe ri walc'ual awiq'uin, roma c'o jun itzel espíritu riq'uin. Y ri itzel espíritu re' can mem rubanon che. ");
INSERT INTO cakNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Y cuando más nuya' ruchuk'a' che, xabachi' (xama'anchi') c'o-wi nutorij pa ulef, niwokok pa ruchi', y nujach'ach'ej rey. Yalan chuka' rucajman chic roma ri quiri' rubanon. Y romari' xinc'utuj chique ri a-discípulos chi tiquilesaj-e ri jun itzel espíritu re' riq'uin ri walc'ual, pero man yetiquier ta, xcha' ri achi. ");
INSERT INTO cakNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Y ri Jesús ja' xu'ij chique: Can man jun winak chupa ri tiempo re' ruyo'n ta juba' ránima riq'uin ri Dios. ¿Jani' tiempo ninojij rix chi xquic'ue' iwiq'uin? ¿Can jani' tiempo xquitiquier xquixincoch', ni'ij rix? Tic'ama-pe we' ri ala', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Y xc'amer-pe ri ala' c'a chech ri Jesús. Pero cuando ri itzel espíritu xutzu' ri Jesús, riq'uin ruchuk'a' xupiq'uiq'uiej ri ala' y xutorij pa ulef. Y ri ala' nubolkotila-ri' y niwokok chuka' pa ruchi'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Y ri Jesús xuc'utuj che ri rutata' ri ala': ¿Jani' yan tiempo rubanon-pe quiere' ri ala'? xcha' ri Jesús. Y ri tata'j xu'ij: Can c'a co'l quiere' rubanon-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ri itzel espíritu can q'uiy mej (paj) rutorin pa k'ak', pa tak ya', chi nucamisaj. Pero xa ret jatiquier nato', tajoyowaj rech raja', tajoyowaj nuech ren y kojato', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Pero ri Jesús xu'ij che: Xa ret jatiquier nanimaj chi yitiquier ninto' ri awalc'ual, can xtibanataj-wi ri anchique narayij ret. Pero ri' awiq'uin ret c'o-wi, roma xa can nanimaj, cuando nac'utuj; can nibanataj ri anchique ri najo', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Y ri rutata' ri ala' can ja' xu'ij: Ninnimaj. Y chuka' can quinato' chi quiri' más ninnimaj. Y cuando ri tata'j xu'ij ri tzij ri', riq'uin ruchuk'a' xu'ij, roma yalan nibison ránima. ");
INSERT INTO cakNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Cuando ri Jesús xutzu' chi ri winak más niquimol-ka-qui', cof xch'o'n che ri itzel espíritu. Raja' xu'ijche: Ret ri abanon che ri ala' re' chi can man nic'oxan ta y can mem abanon che, catel-e, y man catzolaj chic pe riq'uin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Y ri itzel espíritu nisiq'uin, xel-e riq'uin ri ala'. Pero cuando xel-e, can riq'uin ruchuk'a' xupiq'uiq'uiej can ri ala'. Y ri ala' xc'ue' can pa ulef, anche'l jun caminak. Y romari' je q'uiy winak xqui'ij chi ri ala' xcom. ");
INSERT INTO cakNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xutz'om ruk'a' ri ala' chi xuyec. Y ri ala' can ja' xbecataj-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Y cuando quiyon chic xec'ue' can pa jay riq'uin ri Jesús, ri ru-discípulos xquic'utuj che: ¿Anchique roma roj man xojtiquier ta xkalesaj-e ri itzel espíritu? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Y ri Jesús xu'ij chique: Ri jun rech espíritu re' ntel-e, pero xa rix niben ayuno y oración, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Y cuando reje' je-elenak chic pe chiri', xek'ax pa Galilea. Pero ri Jesús man xrojo' ta nina'ex chi raja' nik'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Roma raja' nrojo' chi c'o niquitemaj can ri ru-discípulos, romari' can nu'ij jun mej (bey) chic chique: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xquijach na pa quik'a' ri winak ri itzel yetz'eto wichi y xquinquicamisaj. Pero cuando jin caminak chic, pa rox k'ij xquic'astaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Pero ri discípulos xa man xqui'en ta entender ri x-ix chique roma ri Jesús. Y niquixi'j-qui' niquic'utuj che ri anchique ri xu'ij chique riq'uin ri tzij ri xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Y ri Jesús y ri ru-discípulos xe'apon pa tenemit Capernaum. Y cuando jec'o chic pa jay, raja' xuc'utuj chique ri ru-discípulos: Y rix ¿anchique ri nich'ojij chiwech cuando joj-petenak pa bey? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Pero ri discípulos man xech'o'n ta apo che ri Jesús, roma cuando je-petenak, xa niquich'ojij chiquiwech ancu'x (anchique) ri más c'o ruk'ij chique reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Y ri Jesús xch'oquie-ka. C'ajari' xeroyoj-apo riq'uin ri cablajuj discípulos y xu'ij chique: Xa c'o jun ri nrojo' chi ja raja' ri na'ey y c'o ta ruk'ij, can tuna-ka chi can manak ruk'ij y más co'l tu'ona-ka chiquiwech conojel chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj quichi conojel. ");
INSERT INTO cakNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Y ri Jesús xberuc'ama-pe jun ac'ual y xuya' pa quinic'ajal. Ja' xuk'etej y raja' xu'ij chique ri ru-discípulos: ");
INSERT INTO cakNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Xa c'o jun ri jinruniman pa ránima y niquicot nuc'on-ka jun ac'ual ri anche'l re', man xe ta xtuc'on-ka ri ac'ual, xa can xquiruc'on-ka chuka' ren. Y ri yiruc'on-ka ren, man xe ta ren ri xquiruc'on-ka, xa can xtuc'on-ka chuka' ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Y ri Juan xu'ij che ri Jesús: Maestro, xcha' che. C'o jun achi xkatzu' can, y ri achi re' pa abi' ret yerulesaj itzel tak espíritus. Pero roma xa man kaxbil ta, xka'ij che que man chic tu'on quiri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Y ri Jesús xu'ij: Man chic ti'ij quiri' che. Roma xa pa nubi' ren yeru'on milagros, can manak xtujal runo'j (runa'oj) ch'anin, y quiri' can manak xtitiquier xtu'ij itzel tak tzij chuij. ");
INSERT INTO cakNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Roma ri man ruyowal ta chakij roj, can kaq'uin roj c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Y ri winak ri utz jixrutzu' roma wiq'uin ren ri Cristo jixc'o-wi, más que xa juba' iya' ri nuya', can ketzij ri nin-ij chiwe chi can c'o ruq'uiexel xtiyo'x che romari'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Xa c'o ta jun co'l oc ri jinruniman y nipe ta jun winak y nu'on che ri jun ri' chi nika pa mac, man utz ta ri nu'on. Romari' ri winak ri nunojij nu'on quiri', más utz nu'on che xa ta nixim jun nimalaj abaj chi quie'n chukul y ne'torix chupa ri mar. ");
INSERT INTO cakNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Romari' xa jun ak'a' ri nibano chawe chi na'an mac, más ta utz nakupij-e. Roma más utz chi xe jun ak'a' c'o y jatoc chupa ri c'aslen ri man niq'uis ta, que chech ca'i' ta ak'a' jec'o y xa ronojel ach'acul jabe chupa ri castigo; chupa ri k'ak' ri man nichup-ta. ");
INSERT INTO cakNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ri lugar anchi' jec'o jut quichi ri jec'o chiri' ri can man yecom ta, y chuka' c'o ri k'ak' ri can man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Y xa jun awakan ri nibano chawe chi na'an mac, más ta utz chi nalesaj-e. Roma más utz chi xe jun awakan c'o y jatoc chupa ri c'aslen ri man niq'uis ta, que chech ca'i' ta awakan jec'o y xa ronojel ach'acul jabetorix can chupa ri castigo; chupa ri k'ak' ri man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ri lugar anchi' jec'o jut quichi ri jec'o chiri' ri can man yecom ta, y chuka' c'o ri k'ak' ri can man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Y xa jun awech ri nibano chawe chi na'an mac, más ta utz nalesaj-e. Roma más utz chi xe jun awech c'o y jatapon chila' riq'uin ri Dios, anchi' ja raja' nibano gobernar, que chech ca'i' ta awech jec'o y xa ronojel ach'acul jabetorix can chupa ri castigo, ri pa k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ri lugar anchi' jec'o jut quichi ri jec'o chiri' ri can man yecom ta, y chuka' c'o ri k'ak' ri can man nichup ta. ");
INSERT INTO cakNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Can conojel-wi ri chicop ri je-camisan je-yo'n che ri Dios, yo'n atz'am chiquij. Quiri' chuka' xti'an chique conojel ri winak, pero man riq'uin ta chic atz'am, xa riq'uin k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ri atz'am can utz-wi. Y xa ri atz'am ri' niq'uis ta e ri ratz'amil, ¿anchique ta chic xtiben chi quiri' nitzolaj ta chic pe ri ratz'amil? Romari' rix tichajij ic'aslen, chi quiri' man quixoc anche'l ri atz'am ri man nitz'amin ta chic, y chuka' man jun ta ayowal chi'icojol. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ri Jesús xel-e chiri' y xbe c'a pa Judea. Y xk'ax chuka' juc'an rakan-ya' Jordán. Chiri', yalan chuka' q'uiy winak xquimol-qui' riq'uin. Y raja' yerutijoj riq'uin rutzij ri Dios, can anche'l rubanon-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Y ja' jec'o jujun achi'a' fariseos ri xe'apon riq'uin, chi niquitojtobej ri Jesús chi nitzak ta pa quik'a'. Reje' xquic'utuj che xa utz chi jun achi nujach-ri' riq'uin ri raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Y ri Jesús xu'ij chique ri achi'a' ri': ¿Anchique ri ru'in can ri Moisés chiwe chi niben? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Y reje' xqui'ij: Ri Moisés can ruyo'n can lugar che ri achi chi nu'on jun carta ri nu'ij chi nujach-ri' y nuya' can ri raxayil, xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Romari' ri Jesús xu'ij chique: Can anche'l cowirinak ri iwánima rix cami, quiri' chuka' xbanataj ojer can pa ru-tiempo ri Moisés. Xa romari' xu'ij chi ti'an quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero cuando xtz'ucutaj-pe ri rech-ulef, man quiri' ta. Can chi je ca'i' xeru'on ri Dios. Can man ruyon ta ri achi y chuka' man ruyon ta ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Romari' ri achi xquieruya' can ri rute-rutata' y xtiquic'on-qui' riq'uin ri raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Y chi je ca'i' xe jun xtiqui'en. Roma cuando quic'uan chic qui', man je ca'i' ta chic, xe jun chic quibanon. ");
INSERT INTO cakNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Romari', ri xe jun chic quibanon roma ri Dios, man jun winak tijacho quichi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Cuando ri Jesús y ri ru-discípulos jec'o chic pa jay, ri discípulos xquic'utuj che anchique ri xrojo' xu'ij riq'uin ri tzij ri xeru'ij chique ri achi'a' fariseos. ");
INSERT INTO cakNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Y ri Jesús xu'ij chique: Xabachique (Xama'anchique) achi ri nujach-ri' riq'uin ri raxayil y neruc'ama-pe jun chic ixok, ri achi re' can mac-wi nu'on chech ri raxayil. ");
INSERT INTO cakNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Y quiri' chuka' ri ixok ri nujach-ri' riq'uin ri rachijil y nibe riq'uin chic jun achi, ri ixok re' can mac chuka' ri nu'on, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Y ri winak yequic'om-pe ac'uala' riq'uin ri Jesús, chi nuya' ruk'a' pa quiwi' chi yeru'on bendecir. Pero ri discípulos xa xqui'ij chique ri winak que man tiqui'en quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Y cuando ri Jesús xutzu' ri niqui'en ri ru-discípulos, xpe ruyowal, roma man utz ta xutzu' ri niqui'en, y xu'ij chique: Tiya' lugar chique ri ac'uala' chi yepe wiq'uin, y man quie'ik'at. Roma ri ru-gobierno ri Dios, xe quichi ri je anche'l ac'uala'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Y can ketzij ri nin-ij chiwe: Ri man niqui'en ta anche'l ri ac'uala' chi niquijach-qui' chuxe' ri ru-gobierno ri Dios, can man xquietiquier ta xquie'oc quiq'uin ri ye'an gobernar roma raja', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Y raja' xeruk'etela' y xuyala' ri ruk'a' pa quiwi' ri ac'uala' chi xeru'on bendecir. ");
INSERT INTO cakNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Y cuando ri Jesús y ri ru-discípulos xquitz'om chic e quibey, c'o jun achi junanin xoka riq'uin, xoxuquie' chech, y xu'ij che: Utzilaj Maestro, ¿anchique utz ri nin-en ren chi ninwil ri c'aslen ri man niq'uis ta? xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Y ri Jesús xu'ij che: ¿Anchique roma na'ij utz chue ren? Roma man jun winak ri utz, xa can xe ri Dios ri utz. ");
INSERT INTO cakNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Y ren nin-ij chi ret can aweta'n ri lajuj mandamientos ri xuya' ri Dios che ri Moisés ri ojer can, ri nu'ij: Ret ri c'o awaxayil man tacanoj jun chic ixok, man cacamisan, man catelak', man tatz'uc tzij chirij jun chic winak, man ta'an engaño che jun winak roma c'o anchique najo' nalek'aj chuk'a', quie'abana' respetar ate-atata', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Y ri achi can ja' xu'ij che ri Jesús: Maestro, xcha' che. C'a jin co'l oc nubanon-pe ronojel ri', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Cuando ri achi xu'ij quiri', ri Jesús xutzu' rech y yalan xrojo'. Y c'ajari' xu'ij che: C'a c'o jun ex ri man abanon ta. Man ayo'n ta ri abeyomal chique ri winak ri manak quibeyomal. Tac'ayij ronojel ri c'o awiq'uin y ri rajil taya' chique ri winak ri manak quibeyomal, y xtic'ue' abeyomal chicaj. Y catampe wiq'uin, quinatzeklebej, y man tapokonaj na'an sufrir woma ren, anche'l can jat-benak chuxe' jun cruz, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Pero cuando ri achi xuc'oxaj ri tzij ri xu'ij ri Jesús che, xa can xubolkotij-ri' ri ránima xuna' raja' roma yalan rubeyomal c'o. Y nibison ránima xtzolaj-e, roma man nrojo' ta nusipaj rubeyomal. ");
INSERT INTO cakNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Y ri Jesús xerutzu' ri ru-discípulos, y xu'ij chique: Ri winak ri c'o q'uiy quibeyomal, can cuesta chi ye'oc quiq'uin ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Y ri ru-discípulos ri Jesús can xsatz quino'j (xsach quic'u'x) roma ri tzij ri xu'ij ri Jesús. Pero raja' xu'ij chic jun mej (bey) chique: Walc'ual, xcha' chique. Ri can niquijach cánima riq'uin ri quibeyomal, can yalan cuesta chi ye'oc quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Xa más la'k nitiquier nik'ax jun camello pa jun ch'uti' rujulil jun acux que chech jun beyom ntoc quiq'uin ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Pero cuando ri discípulos xquic'oxaj chic jun mej (bey) ri tzij ri xu'ij ri Jesús, xsatz quino'j (xsach quic'u'x) y xqui'ij chiquiwech: Xa can anche'l ri nu'ij, quiri', man jun xticolotaj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Y ri Jesús xerutzu' ri ru-discípulos jun mej (bey) chic y xu'ij chique: Ri winak man yetiquier ta niquicol-qui', pero ri Dios can nitiquier-wi yerucol, roma raja' ronojel nitiquier yeru'on, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Y ja' cuando ri Pedro xu'ij che: Ret aweta'n chi roj kayo'n can ronojel ri c'o kaq'uin, roma jatkatzekleben, xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Pero ri Jesús can ja' xu'ij: Can ketzij ri nin-ij chiwe; xabachique (xama'anchique) winak ri jeruyo'n can rocho, rach'alal, rute-rutata', raxayil, ralc'ual o rulef woma ren y ri utzilaj rutzij ri Dios; ");
INSERT INTO cakNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","can q'uiy ri xtiyo'x che xa quiri' xtu'on. Can cien más ri ruq'uiexel xtiyo'x che chupa ri tiempo re'. Xtiyo'x rocho, rach'alal, rute', ralc'ual o rulef. Chuka' can xtu'on sufrir pa quik'a' ri winak roma ja ren jinrutzekleben, pero chupa apo ri jun chic tiempo chakawech apo, can xtiyo'x ruc'aslen ri manak xtiq'uis. ");
INSERT INTO cakNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Y je q'uiy ri yalan quik'ij cami, xtapon ri k'ij cuando manak chic quik'ij xtic'ue'. Y je q'uiy ri manak quik'ij ri cami, xtapon ri k'ij cuando xtic'ue' quik'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ri Jesús, ri ru-discípulos y ri ch'aka chic winak, quitz'amon-e bey pa tenemit Jerusalem. Y can ja ri Jesús ri benak-e chiquiwech, y romari' ri ru-discípulos y ri winak can satzinak quino'j (sachinak quic'u'x) y quixi'n-qui' chuka' je-benak-e chirij. C'ajari' ri Jesús xeruc'uaj juba' aparte ri cablajuj ru-discípulos y xu'ij chic chique ri anchique sufrimiento ri xtuk'axaj. ");
INSERT INTO cakNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Raja' xu'ij chique: Rix iweta'n chi c'a pa tenemit Jerusalem jojapon-wi, y chiri' xquijach-wi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. Xquibejach pa quik'a' ri nimalaj tak sacerdotes y pa quik'a' ri maestros chi ri ley. Y reje' xtiqui'ij chi quicamises. Y chuka' xquibejach coma reje' pa quik'a' winak man je israelitas ta. ");
INSERT INTO cakNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Y ri winak ri' xquietze'n chuij, xquinquichubaj, xquinquich'ey y c'ajari' xquinquicamisaj. Pero pa rox k'ij xquic'astaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Y ri Jacobo y ri Juan, ri je ralc'ual ri achi rubinan Zebedeo, xebe-apo riq'uin ri Jesús, y xqui'ij che: Maestro, xecha' che. Roj nakajo' nakac'utuj jun favor chawe. Pero can na'an ta chake ri favor ri xtakac'utuj chawe, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Y raja' xu'ij chique: ¿Anchique ri nijo'? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Y reje' xqui'ij: Roj nakajo' chi cuando c'o chic ak'ij ret, na'an ta chuka' chake roj chi nic'ue' kak'ij, naya' ta lugar chake chi jojch'oquie' ta apo awiq'uin; jun ta ri nic'ue' pa a-derecha y jun ta ri pa a-izquierda. ");
INSERT INTO cakNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Pero ri Jesús xu'ij chique: Rix man iweta'n ta anchique ri nic'utuj. Y romari' ren ninc'utuj chiwe: ¿Nicoch' como rix ri xti'an chue ren? ¿Y nicoch' como chuka' ri jun sufrimiento anche'l ri xtika pa nuwi' ren? Roma ronojel ri xtika pa nuwi' ren, xa anche'l jun ya' can q'uey, can anche'l jun bautismo, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Y reje' xqui'ij: Nakacoch', xecha'. Y ri Jesús xu'ij chic chique: Can ketzij-wi chi rix xticoch'-wi anche'l ri xti'an chue ren. Chuka' can xticoch' jun sufrimiento anche'l ri xtika pa nuwi' ren; ri can anche'l jun ya' can q'uey, can anche'l jun bautismo. ");
INSERT INTO cakNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero ri nic'utuj chue chi jun chiwe rix nich'oquie' pa nu-derecha y ri jun chic pa nu-izquierda, ri' man pa nuk'a' ta ren c'o-wi chi ninya' chiwe. Roma ri nic'utuj rix, can ja ri Dios xnojin yan anchok chique xtuya-wi lugar chi yech'oquie' chiri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Y cuando ri lajuj chic discípulos xquic'oxaj ri x-ix, xpe quiyowal chique ri Jacobo y ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Pero Jesús xeroyoj ri ru-discípulos y xu'ij chique: Ren nin-ij chi rix jabel iweta'n chi we' chech-ulef ja ri yebano gobernar jec'o pa quiwi' ri winak; romari' can cajaf quibanon-ka chiquij ri winak. Y quiri' chuka' ri ch'aka chic ri can c'o quik'ij, niquijo' chi quienimex y can ti'an ronojel ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero chi'icojol rix man quiri' ta. Roma xa c'o jun ri nrojo' chi nic'ue-ka ruk'ij, can tuna-ka chi can manak ruk'ij y co'l oc tu'ona-ka chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj. ");
INSERT INTO cakNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Xa c'o jun chiwe rix can nrojo' chi ja raja' ri na'ey y c'o ta ruk'ij, can tuna-ka chi can manak ruk'ij y co'l oc tu'ona-ka chi nusuj-ri' chi nu'on xabachique (xama'anchique) samaj quichi conojel. ");
INSERT INTO cakNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Y quiri' nubanon ren; ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, man ninpokonaj ta wi' yisamaj coma ri ch'aka chic. Can romari' xipe. Y man xipe ta chuka' xe chi jec'o ri yebano-pe ronojel ri nin-ij chique. Can ja ren ri yibano ri samaj, y can ninya' nuc'aslen chi quiri' je q'uiy ri yecolotaj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","C'ajari' ri Jesús y ri ru-discípulos xe'apon pa tenemit Jericó. Y cuando reje' niquiya' can ri tenemit, yalan je q'uiy winak ri quitzekleben-e. Y chiri' chuchi' bey c'o jun moy rubinan Bartimeo, ralc'ual jun achi rubinan Timeo. Raja' ch'ocol chiri', nuc'utuj ru-limosna chique ri winak ri yek'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Y cuando raja' xuc'oxaj chi ri nik'ax chiri', ja ri Jesús aj-Nazaret, raja' riq'uin ruchuk'a' xch'o'n y xu'ij: Jesús, ri jat ru-familia can ri rey David, tajoyowaj nuech, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Y je q'uiy winak ri xquich'olij chi quiri' man chic tich'o'n-apo. Pero raja' xa riq'uin más ruchuk'a' xch'o'n y xu'ij: Ret ri jat ru-familia can ri rey David, tajoyowaj nuech roma quiere' nubanon, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Y ri Jesús xuc'oxaj ri achi, romari' xpa'e-ka y xu'ij chi tic'amer-pe. Y ja' xbequic'ama-pe ri achi moy y xqui'ij che: Capa'e', man taxi'j-awi'; ri Jesús jatroyoj, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Y ri achi can xe xuc'oxaj quiri', can ja' xpa'e-pe. Xuya' can ri ruk'u' chiri' y xbe-apo riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Y ri Jesús xuc'utuj che: ¿Anchique ri najo'? Y ri achi moy xu'ij che: Maestro, xcha' raja'. Ren ninjo' yitzu'n, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Y ri Jesús can ja' xu'ij che: Catzolaj chawij roma jatzu'n chic. Xacolotaj roma xaya' awánima wiq'uin, romari' cami man jat moy ta chic. Y ri moy can ja' xtzu'n y xutzeklebej-e ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Y cuando chunakaj chic jec'o-wi chique ri tenemit quibinan Betfagé y Betania, xa juba' chic nrojo' chi ye'apon pa tenemit Jerusalem, roma can chuxe' chic apo ri juyu' rubinan Olivos jec'o-wi. Y ri Jesús ja xerutak-e je ca'i' chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Raja' xu'ij-e chique: Quixoc-apo chupa la co'l tenemit la', y xe xquixoc, ja' xtiwil jun alaj burro ximil can chiri'. Y ri chicop ri' c'a man jun ch'ocolbeyon richi. Tisolo' y tic'ama-pe chue. ");
INSERT INTO cakNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Y xa c'o jun xti'in-pe chiwe chi anchique roma nisol-pe ri chicop, ti'ij che chi nic'atzin juba' che ri Ajaf, pero ch'anin xterutzolej, quixcha' can che, xe'uche'x-e roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Y ri ca'i' discípulos xebe, y cuando xe'apon, xquiwil-wi ri alaj burro, ximon can chiri' pa bey, ri anchi' ye'oc-apo ri winak. Y reje' xquisol-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Pero cuando reje' niquisol-pe ri alaj burro, xetz'et-pe coma jun ca'i' ri jec'o chiri' y xqui'ij chique ri je ca'i' discípulos: ¿Anchique niben rix chiri'? ¿Anchique roma nisol ri alaj burro? xecha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Y ri discípulos xqui'ij ri ru'in ri Jesús chique. Y ri xetz'eto-pe quichi xquiya' lugar chique chi xquic'uaj-e ri alaj burro ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Y ri discípulos ri' xquic'om-pe ri alaj burro che ri Jesús. C'ajari' xquiyala' jujun quitziak chirij ri chicop ri', y ri Jesús xch'oquie-e chirij. ");
INSERT INTO cakNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Y je q'uiy chique ri winak chi niquiya' ruk'ij ri Jesús, xquiriq'uila' jujun quitziak pa rubey. Y ch'aka chic winak chi niquiya' chuka' ruk'ij ri Jesús, xebequic'ama-pe ruxak tak che' chi xquiric' pa rubey. ");
INSERT INTO cakNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Y ri winak ri je-benak chech ri Jesús y ri jec'o can chirij, can riq'uin ronojel quichuk'a' niqui'ij: ¡Matiox chi petenak ri Jun re'! ¡Raja' yo'n-pe bendición pa ruwi' roma ri Ajaf Dios! ¡Raja' petenak pa rubi' ri Ajaf Dios! ");
INSERT INTO cakNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Matiox chi nitzolaj yan pe ri ru-gobierno ri David ri Katata' ri xc'ue' ojer can! ¡Matiox che ri Dios ri c'o chicaj! xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Y ri Jesús xoc-apo pa tenemit Jerusalem y xbek'ax-pe pa rocho ri Dios y xerutzu' can ri jec'o chiri'. Y cuando xk'okumer-pe, raja' y ri cablajuj ru-discípulos xebe pa tenemit Betania. ");
INSERT INTO cakNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pa ruca'n k'ij cuando quitz'amon bey chi yetzolaj-pe pa Betania y yebe pa Jerusalem, ri Jesús xnum-pe rupa. ");
INSERT INTO cakNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y raja' chinaj xutzu' chi c'o jun mata higo, y yalan jabel ri ruxak. Xbe-apo riq'uin, chi nerucanoj-pe jun rech. Pero cuando xapon-apo riq'uin, xa man jun rech c'o, xa ruyon ruxak. Roma man ja' ta ru-tiempo chi nuya' rech. ");
INSERT INTO cakNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Y ri Jesús ja' xch'o'n che ri che' y xu'ij che: Man jun chic winak xtitijo awech, roma can manak chic xcawachin, xcha'. Y ri ru-discípulos can xquic'oxaj ri xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Y xe'apon chic pa tenemit Jerusalem. Y ri Jesús xbe pa rocho ri Dios. Pero cuando raja' c'o chic chiri', xerokotala-e ri c'ayinel y ri yelok'on ri jec'o chiri'. Y chique ri niquijal rech mero xerutacmayila' can ri qui-mesas. Y quiri' chuka' xu'on can chique ri quich'acat ri niquic'ayij palomas. ");
INSERT INTO cakNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y raja' man xrojo' ta chi ri winak ri quic'uan eka'n (aka'n), yek'ax chiri' pa rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","C'ajari' raja' c'o ri xuc'ut chiquiwech ri winak riq'uin rutzij ri Dios. Raja' xu'ij chique: ¿Man tz'iban ta como chupa rutzij ri Dios chi ri wocho, jay chi niqui'en orar conojel winak ri jec'o chech-ulef? Pero rix xa man richi ta ri' icusan-wi, xa ibanon quijul elek'oma' che, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Y ri' xc'oxex coma ri nimalaj tak sacerdotes y ri maestros chi ri ley. Reje' niquitzu' chi ri winak can nisatz quino'j (nisach quic'u'x) roma ri tzij ri nu'ij ri Jesús chique chi yerutijoj. Romari' ri nimalaj tak sacerdotes y ri maestros chi ri ley niquixi'j-qui' chech ri Jesús y niquicanola' anchique niqui'en chi niquicamisaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Cuando xk'okumer-pe, ri Jesús y ri ru-discípulos xebe; can man xec'ue' ta ka ri chiri' pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Nimak'a' ruca'n k'ij, cuando quitz'amon bey pa Jerusalem, xquitzu' chi chaki'j chic ri mata higo ri xch'o'n can ri Jesús che, chi can man jun chic rech xtuya'. ");
INSERT INTO cakNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Y ri Pedro ch'anin xoka pa ruwi', y xu'ij che ri Jesús: Maestro, tatzu' la mata higo, can xchaki'j-ka anche'l ri xa'ij, xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Y ri Jesús xu'ij chique conojel ri discípulos: Rix chuka' nic'atzin chi niya' iwánima riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Romari', can ketzij nin-ij chiwe chi xabachique (xama'anchique) ri ni'in che ri juyu' re' chi ntel-e we' y tik'ax chupa ri mar, can quiri' xtibanataj. Xa can ketzij nunimaj chi nibanataj y man nipe ta pa ránima chi xa man xtibanataj ta. ");
INSERT INTO cakNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Romari', ren can nin-ij chiwe chi ronojel ri nic'utuj che ri Dios cuando rix niben orar, y can ninimaj chi raja' can xtu'on-wi ri nijo', can xtibanataj-wi ri nic'utuj. ");
INSERT INTO cakNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Y cuando niben orar, xa c'o jun ri c'o anchique rubanon chiwe, ticoch'o' (ticuyu') rumac jumul. Chi quiri' ri lok'olaj Itata' ri c'o chicaj xtucoch' (xtucuy) chuka' imac rix. ");
INSERT INTO cakNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Roma, xa rix man nicoch' (nicuy) ta rumac jun ri c'o rubanon chiwe, chuka' ri lok'olaj Itata' ri c'o chicaj man xtucoch' (xtucuy) ta ri imac ri ye'iben chech. ");
INSERT INTO cakNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ri Jesús y ri ru-discípulos xe'apon chic pa tenemit Jerusalem. Y chiri' pa rocho ri Dios c'o-wi raja' cuando xe'apon ri nimalaj tak sacerdotes riq'uin, y chuka' ri maestros chi ri ley y ri rijilaj tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Y xquic'utuj che: ¿Ancu'x (Anchique) yoyo'n uchuk'a' pa ak'a' chi xe'awokotaj-e ri winak yec'ayin we' pa rocho ri Dios? ¿Ancu'x (Anchique) x-in chawe chi quie'abana' quiela'? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Xpe ri Jesús xu'ij chique ri achi'a' ri': Ren c'o chuka' ri ninjo' ninc'utuj chiwe. Y xa rix xti'ij chue, ren chuka' xtin-ij chiwe ancu'x (anchique) yoyo'n uchuk'a' chue chi yenben ronojel re'. ");
INSERT INTO cakNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Tic'oxaj jabel ri xtinc'utuj chiwe. ¿Ja ri Dios ri x-in che ri Juan chi quieru'ona' bautizar ri winak? ¿O xa winak xe'in che? Ti'ij chue ri anchique ri ni'ij rix, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Y ri nimalaj tak sacerdotes, ri maestros chi ri ley y chuka' ri rijilaj tak achi'a' ri c'o quik'ij, xqui'ij-ka chiquiwech: ¿Anchique naka'ij che ri Jesús cami? xecha-ka. Roma xa naka'ij che chi ri Juan ja ri Dios takayon-pe richi, ri Jesús xtu'ij chake chi anchique roma man xkanimaj ta rutzij. ");
INSERT INTO cakNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Y xa naka'ij che chi ja ri winak xe'in che ri Juan chi tu'ona' quiri', can man utz ta chake roj. Reje' xqui'ij-ka quiri', roma quixi'n-qui' chiquiwech ri winak. Roma conojel ri winak can quieta'n chi ri Juan jun rusamajel ri Dios ri can xuk'alajij ri x-ix che roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Y c'ajari' reje' xqui'ij-apo che ri Jesús: Roj man keta'n ta, xecha'. Y ri Jesús can ja' xu'ij chique: Roma rix xa man xixtiquier ta xi'ij chue, ren man xtin-ij ta chuka' chiwe ancu'x (anchique) yoyo'n uchuk'a' chue chi yenben quiere', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Y ri Jesús riq'uin ejemplos xch'o'n quiq'uin. Raja' quiere' xu'ij chique: Xc'ue' jun achi ri xutic uva pa rulef, xuya' co'c' chirij y xu'on chuka' anche'l jun ch'uti' pila chupa ri ulef chi niyitz' ri uva. Xu'on chuka' jun torre, chi parui' ri' nic'ue-wi ri jun ri nuchajij ri ulef ri'. C'ajari' xuya' can pa kajic chique jujun achi'a', y raja' xbe naj. ");
INSERT INTO cakNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Y cuando xoka ri tiempo chi ri cosecha, ri rajaf ri ulef xutak jun rusamajel quiq'uin ri achi'a' ri je-kajayon ri ulef chi neruc'utuj-pe ri uva, roma riq'uin ri' nitoj-wi ri rukajic ri ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero cuando xapon ri rusamajel quiq'uin ri achi'a' ri je-kajayon ri ulef, ri achi'a' re' xquitz'om ri rusamajel y xquich'ey, y man jun uva xquiya-e che. ");
INSERT INTO cakNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Y ri rajaf ri ulef xutak jun chic rusamajel quiq'uin ri achi'a' chi neruc'ama' ri uva ri nuc'utuj raja' chique chi ri ulef. Pero reje' xa che abaj xquic'ul-apo y xquisocola-e rujolon. Can pokon xqui'en y xqui'ij-e che. ");
INSERT INTO cakNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Pero ri rajaf ri ulef xutak jun chic rusamajel. Y ri samajel re' xcamises coma ri je-kajayon ri ulef. Y je q'uiy chic rusamajel xerutak, pero conojel c'o anchique x-an-e chique. Jec'o xech'ay, y jec'o xecamises. ");
INSERT INTO cakNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Y pa ruq'uisbel, ri rajaf ri ulef xe chic ri ralc'ual xc'ue' can riq'uin y raja' yalan nrojo' ri ralc'ual. Pero ri rajaf ri ulef can xutak na ri ralc'ual quiq'uin ri achi'a' ri je-kajayon ri ulef ri', roma raja' xunojij-ka: Ri achi'a' ri' can xquieniman cuando xtiquitzu' chi can ja ri walc'ual xtapon, xcha-ka pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Pero cuando ri achi'a' xquitzu' chi ja ri ralc'ual ri rajaf ri ulef ri xapon, xqui'ij-ka chiquiwech: Jare' ri ne'oc rajaf ronojel ri ulef ri kakajon cami. Cami kacamisaj, chi quiri' pa kak'a' roj nic'ue-wi can ri ulef, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Y can quiri' xqui'en. Xquitz'om ri ralc'ual, xquicamisaj, xquilesaj-e pa rulef. Y xbequitorij juc'an chic ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","C'ajari' ri Jesús xu'ij: ¿Anchique como xtu'on ri rajaf ri ulef chique ri achi'a' ri'? Ri rajaf ri ulef xtipe y xquierucamisaj ri achi'a' ri' y ri ulef xtuya' chic pa kajic chique ch'aka chic. ");
INSERT INTO cakNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Y can man jun mej (bey) como chuka' itz'eton ri jun tzij ri tz'iban can chupa ri rutzij ri Dios? Ri tzij ri nu'ij: C'o jun Abaj ri man xka ta chiquiwech ri achi'a' ri je banoy-jay. Pero xa ja ri Abaj ri' ri xc'atzin, roma can jari' ri xcuses chi quiri' ri jay man nitzak ta. ");
INSERT INTO cakNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Can ja ri Ajaf xbano chi xcuses ri Abaj re', y roj can man jun mej (bey) katz'eton chi nibanataj quiere'. Quiri' nu'ij ri rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Y ri achi'a' anchok quiq'uin xch'o'n-wi ri Jesús c'o ta xquijo' xquitz'om yan ta, roma xquina'ej chi ri achi'a' je-kajayon ri ulef ri xerunataj chupa ri ejemplo, xa chiquij reje' xch'o'n-wi. Pero man xquitz'om ta e, roma niquixi'j-qui' chiquiwech ri winak ri jec'o riq'uin. Reje' xquiya' can ri Jesús y xebe. ");
INSERT INTO cakNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Y ri achi'a' ri' jec'o ch'aka chic ri xequitak-pe. Xequitak-pe jujun achi'a' fariseos y chuka' jujun ruwinak ri rey Herodes, chi niquitojtobej ri Jesús y nitzak ta pa quik'a' riq'uin ri tzij ri yeru'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","C'ajari' reje' xepe y xqui'ij che ri Jesús: Ret ri jat jun Maestro, roj can keta'n chi xe-wi ri ketzij ri nika chawech y jari' ri natzijoj; can nac'ut ri rutzij ri Dios y can ja-wi rubixic na'an che, roma ret man naxi'j ta awi' chech jun winak, más que can yalan ruk'ij. ¿Anchique na'ij chake? ¿Utz como nakatoj ri impuestos ri nu'ij ri rey César, o xa man utz ta? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pero ri Jesús can reta'n-wi chi riq'uin ca'i' quipalaj niquic'utuj quiri'. Romari' raja' xu'ij chique: ¿Anchique roma rix nitaj ik'ij chi yinitojtobej? Tic'ama-pe ri mero chi nintzu' rech, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Y reje' xbequic'ama-pe ri mero chi niquic'ut chech. Y c'ajari' raja' xuc'utuj chique: ¿Anchok rupalaj y anchok rubi' c'o chech la mero? xcha' raja'. Y reje' xqui'ij: Chi ri rey César, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Y ri Jesús xu'ij chique: Tiya' che ri César ri can richi-wi ri César, y tiya' che ri Dios ri can richi-wi ri Dios, xcha' ri Jesús chique. Y reje' can anchique la xquina' cuando xquic'oxaj ri xu'ij ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Y jec'o achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' re' man niquinimaj ta chi ri caminaki' can xquiec'astaj chic pe. Y romari' reje' xqui'ij che ri Jesús: ");
INSERT INTO cakNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Ret ri jat jun Maestro, roj chuka' c'o ri nakajo' nakac'utuj chawe. Ri Moisés rutz'iban can chake, chi cuando jun achi nuya' can ri raxayil roma nicom-e y man jun ralc'ual nic'ue' can; jun rach'alal ri caminak achi ri' tic'ule' riq'uin ri malca'n-ixok, chi quiri' yec'ue' ralc'ual riq'uin ri malca'n-ixok. Y xa can jec'o ralc'ual yec'ue' riq'uin ri ixok, ri na'ey ala' ntoc ralc'ual ri achi ri caminak chic e. ");
INSERT INTO cakNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Y reje' xqui'ij: Xec'ue' je wuku' achi'a' cach'alal qui'. Ri na'ey xc'ule'. Pero xcom-e, y man jun ralc'ual xc'ue'. ");
INSERT INTO cakNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Xpe ri ruca'n achi, ri rach'alal can ri achi ri xcom-e, xc'ule' riq'uin ri malca'n-ixok. Pero chuka' ri achi re' xcom-e y man jun ralc'ual xc'ue'. Ri rox achi can ja' chuka' xuc'ulumaj anche'l ri ca'i' na'ey rach'alal, y ri ixok c'a xc'ue' na can. ");
INSERT INTO cakNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Can chi je wuku' achi'a' cach'alal qui' quiere' xquic'ulumaj-e. Y man jun chique ri wuku' achi'a' re' xc'ue' ta can ralc'ual. Y pa ruq'uisbel xcom-e chuka' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Y ri achi'a' saduceos xqui'ij che ri Jesús: Ret na'ij chi xtapon jun k'ij cuando ri caminaki' xquiec'astaj-pe. Cuando xtapon ri k'ij ri', ¿anchok raxayil xte'oc ri ixok ri'? Roma ri je wuku' achi'a' cach'alal qui' xec'ue' riq'uin, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Y ri Jesús ja xu'ij chique ri achi'a' ri': ¿Manak como jix-satzinak (jix-sachinak) riq'uin ri xi'ij, roma man ibanon ta entender ri nu'ij chupa rutzij ri Dios? ¿Man iweta'n ta c'a chi ri ruchuk'a' ri Dios yalan nim? ");
INSERT INTO cakNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roma cuando ri caminaki' xquiec'astaj-pe, man xquiec'ule' ta chic. Xa xquie'oc anche'l ri ángeles ri jec'o chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Y ri caminaki' can xquiec'astaj-wi, y ren nin-ij chi rix jabel iweta'n ri anchique ri tz'iban can roma ri Moisés, cuando raja' xutzu' ri zarza, ri jun k'ayis c'o ruq'uixal, nic'at, y chiri' xbech'o'n-pe ri Dios che y xu'ij: Ja ren ri ru-Dios ri Abraham, ru-Dios ri Isaac y ru-Dios ri Jacob, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Y xa ta reje' je caminak ta chi ronojel tiempo y xa man ta yec'astaj chic pe jun mej (bey), ri Dios man ta qui-Dios reje', roma ri Dios can qui-Dios-wi ri c'o quic'aslen y man quichi ta ri caminaki'. Romari' ren nin-ij chi rix can jix-satzinak (jix-sachinak) riq'uin ri ni'ij, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Y ja xbe-apo riq'uin ri Jesús jun maestro chi ri ley. Ri maestro ri' xuc'oxaj ri xqui'ij ri achi'a' saduceos che ri Jesús, y xuc'oxaj chuka' ri xu'ij ri Jesús chique ri achi'a' ri'. Y chech raja' can k'alaj-wi chi utz ri xu'ij ri Jesús y c'ajari' xuc'utuj: ¿Anchique chique ri mandamientos ri xuya' ri Dios che ri Moisés, ri más c'o rakalen? xcha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Y ri Jesús xu'ij che: Ri mandamiento ri c'o más rakalen ja ri nu'ij: Tic'oxaj rix aj-Israel, ri Kajaf xe jun, y ri' ja ri Kajaf Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Can tijo' ri Dios ri Iwajaf. Tijo' riq'uin ronojel iwánima. Tijo' chupa ronojel ri ic'aslen, riq'uin ri ino'j (ina'oj) y chuka' riq'uin ronojel ri iwuchuk'a'. Jare' ri mandamiento ri c'o más rakalen. ");
INSERT INTO cakNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Y c'o chuka' jun ruca'n mandamiento ri yalan rakalen y xa can junan riq'uin ri na'ey. Y ri mandamiento re' nu'ij: Can anche'l najo-ka-awi' ret, can quiri' chuka' quie'ajo' conojel winak. Y ja ca'i' mandamientos re' ri c'o más quikalen, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Y ri maestro chi ri ley xu'ij che ri Jesús: Maestro, xcha' che. Can quiri-wi. Can ketzij ri xa'ij chi xe jun Dios c'o, y man jun chic. ");
INSERT INTO cakNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nic'atzin chi nakajo' riq'uin ronojel kánima. Nic'atzin chi nakajo' riq'uin ri kano'j (kana'oj), riq'uin ronojel ri kac'aslen y riq'uin chuka' ronojel ri kachuk'a'. Y anche'l chuka' nakajo-ki' roj, can quiri' chuka' quiekajo' conojel winak; y xa can quiri' xtaka'an, ri' c'o más rakalen que chech ri chicop o jun chic ex ri yesuj che ri Dios, xcha' ri maestro chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Y cuando ri Jesús xuc'oxaj chi can jabel-wi xu'on entender ri jun maestro ri', ri Jesús xu'ij che: Ret can man naj ta chic jatc'o-wi chi jatoc quiq'uin ri ye'an gobernar roma ri Dios, xcha' che. Y ja cuando man jun chic xbano cowil chi c'o ta anchique xuc'utuj-apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Y ri Jesús chi yerutijoj ri winak ri quimolon-qui' riq'uin chiri' pa rocho ri Dios, xu'ij chique: ¿Anchique roma ri maestros chi ri ley niqui'ij chi ri Cristo xa choj jun ru-familia can ri rey David? ");
INSERT INTO cakNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Cuando xa can ja ri rey David x-in ri xk'alajix che roma ri Espíritu Santo. Ri David can xu'ij: Ri Ajaf Dios xu'ij che ri Wajaf ri Cristo: Cach'oquie-pe pa nu-derecha, y xquienya' chuxe' awakan ri itzel yetz'eto awichi. Quiri' xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Y xa ri rey David cuando xc'ase' chech-ulef can xu'ij Wajaf che ri Cristo, ¿anchique roma ri maestros chi ri ley niqui'ij chi ri Cristo xa choj jun ru-familia can ri rey David? xcha' ri Jesús. Y can je q'uiy chique ri winak ri can riq'uin-wi ronojel cánima xquic'oxaj ri xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Y ri Jesús xu'ij chuka' chique ri winak cuando yerutijoj: Man tiben anche'l niqui'en ri achi'a' je maestros chi ri ley. Roma reje' yalan nika chiquiwech niquicusaj tukutic tak tziak, chi quiri' yetz'et chi yalan quik'ij. Yalan chuka' nika chiquiwech chi ye'an saludar ri anchi' niquimol-wi-qui' q'uiy winak. ");
INSERT INTO cakNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Y pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios, can ja ri na'ey tak ch'aquet yequicanola', chi quiri' ti'ix chiquij chi yalan quik'ij. Y quiri' chuka' ri yequi'en pa nima'k tak wa'in. ");
INSERT INTO cakNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Y ri achi'a' re' chuka' niquimaj ronojel ex ri xa quichi ri malca'n tak ixoki', y xe chi quienimex chi reje' je utzilaj tak winak, yelayoj cuando niqui'en orar. Pero reje' can xtika-wi más ri castigo pa quiwi', roma ri quimac can q'uiy, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Y ri Jesús ch'ocol chiri' chech apo ri anchi' niyo'x-wi can ri mero chiri' pa rocho ri Dios. Raja' nutzu' chi ri winak niquiya' can mero chiri'. Xerutzu' je q'uiy beyoma' ri yalan mero niquiyala' can. ");
INSERT INTO cakNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero xapon chuka' jun malca'n-ixok ri can k'alaj chi can man beyom ta. Raja' xuya' can ca'i' tak fichas ri man q'uiy ta oc cajil. ");
INSERT INTO cakNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Y cuando ri Jesús xutzu' ri ixok ri', xuc'ut chiquiwech ri ru-discípulos y xu'ij chique: Can ketzij nin-ij chiwe chi ja ri xuya' can la pobre malca'n-ixok la' ri c'o más rakalen, chech ri mero ri xquiya' can conojel ri ch'aka chic chi ri rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Roma raja' más que man q'uiy ta oc xuya' can, raja' xuya' can ronojel ri c'o riq'uin. Pero ri ch'aka chic, más que can q'uiy mero niquiya' can, xa ja ri nu'on sobrar quiq'uin, xa jari' niquiya', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Y cuando ri Jesús ntel-pe chiri' pa rocho ri Dios, jun chique ri ru-discípulos xu'ij che ri Jesús: Maestro, xcha' che. Tatzu' ri ru'onic ri rocho ri Dios, can jabel banon che, y chuka' ri abaj ri je-cusan, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Y ri Jesús xu'ij che ri ru-discípulo: Ret can ye'atzu' chi ri jay re' yalan je jabel y je nima'k, pero xtapon jun k'ij cuando ronojel re' xquiewulix. Conojel ri nimalaj tak abaj ri je-cusan chique ri jay re' can xquietorix-pe. Can man jun abaj ri xtic'ue' can, anche'l rubanon cami. ");
INSERT INTO cakNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Y cuando ri Jesús ch'ocol chic parui' ri juyu' rubinan Olivos, ri anchi' k'alaj niquitzu-pe ri rocho ri Dios; ri Pedro, ri Jacobo, ri Juan y ri Andrés xebe-apo riq'uin ri Jesús y xquic'utuj che: ");
INSERT INTO cakNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ta'ij chake: ¿Jampe' xtibanataj ri xa'ij yan ka chirij ri rocho ri Dios? ¿Y anchique retal chi quiri' nina'ex chi nibanataj yan? xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Y xpe ri Jesús quiere' xu'ij chique: Tibana' cuenta iwi' chi quiri' man jix-an ta engañar. ");
INSERT INTO cakNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Roma je q'uiy ri xquiepe y xtiqui'ij: Ja ren ri Cristo ri takon-pe roma ri Dios, xquiecha'. Y je q'uiy ri xquiequi'en engañar. ");
INSERT INTO cakNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Y cuando xtic'oxaj chi jec'o naciones ri najin guerra chiquicojol, y xtic'oxaj chuka' chi c'o guerras ri xquiepe, man tixi'j-iwi', roma ronojel ri' can xquiebanataj na-wi. Pero man ja' yan ta ri' ri ruq'uisbel tak k'ij chi ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jec'o naciones xquiecataj chi niqui'en guerra quiq'uin ch'aka chic naciones. Jec'o chuka' nimalaj tak rech-ulef xquiecataj chi niqui'en guerra quiq'uin ch'aka chic nimalaj tak rech-ulef. Xquiepe silonel (cab-rakan) q'uiy lugar, chuka' xquiepe nimalaj tak wayjal y q'uiy chuka' quiwech ayowal xquiepe chiquicojol ri winak pa tak tenemit. Y ronojel re' xa c'aja' oc ruticribel che ronojel ri sufrimientos ri xquiepe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Pero rix can tibana' cuenta iwi'. Roma xa can jec'o ri xquiejacho iwichi pa quik'a' ri autoridades quichi ri tenemit. Y chuka' xquixch'ay pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios. Y chuka' xquixuc'uax chiquiwech gobernadores y reyes. Ronojel ri' xtic'ulumaj woma ren, y quiri' can xquixtiquier xquinik'alajij chiquiwech reje'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Y can nic'atzin chi ri utzilaj rutzij ri Dios nitzijos pa ronojel rech-ulef, c'ajari' xtoka ri ruq'uisbel k'ij richi ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Y cuando xquixuc'uax chi jixbejach pa quik'a' ri autoridades, man tichajij pena roma ri tzij ri xti'ij. Rix xe ti'ij ri anchique tzij ri xtuya' ri Dios chiwe, roma can man ja' ta rix ri xquixch'o'n chupa ri hora ri', xa can ja ri Espíritu Santo ri xtich'o'n. ");
INSERT INTO cakNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Roma can xtibanataj chi xa jec'o je ca'i' achi'a' cach'alal qui', jun chique reje' xtujach ri rach'alal chi nicamises. Chuka' can jec'o tata'j ri xquiequijach calc'ual chi yecamises. Y jec'o chuka' ri quiri' xtiqui'en chique quite-quitata'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Xa can itzel xquixtz'et coma conojel winak, roma iyo'n iwánima wiq'uin ren. Pero ri can man xtitzolaj ta chirij y xtucoch' c'a pa ruq'uisbel che ronojel, can xticolotaj-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Y chuka' can xtapon-wi ri k'ij cuando c'o ex ri can je itzel xquiebanataj chupa ri lok'olaj lugar. Y riq'uin ri' can jumul xtiq'uis can ri lugar ri'. Jari' ri tz'iban can roma ri Daniel, jun chique ri achi'a' ri xquik'alajij ri x-ix chique roma ri Dios ojer can. Xabachique (Xama'anchique) winak ri nitz'eto ri tz'iban can, can tu'ona' entender ri nutzu'. Y cuando xtitzu' chi can quiri' yan yebanataj, ri winak ri jec'o pa Judea xa can quielumaj (quienimaj) y tiquiewaj-qui' chech tak juyu'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ri xa nuxlan parui' ri rocho cuando xtapon ri hora ri', choj quiri' tilumaj-e (tinimaj-e). Man ntoc chic apo pa jay chi c'o ri neruc'ama-pe. Man tu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ri nisamaj pa k'ayis, man titzolaj chic chirocho chi neruc'ama-pe ruk'u'. Xa choj chuka' quiri' tilumaj-e (tinimaj-e). ");
INSERT INTO cakNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Can juya' (juyu') quiwech ri ixoki' ri ya ne'c'ue' cal cuando xtapon ri k'ij ri', quiri' chuka' ri ixoki' ri c'a jec'o cal ri xa c'a yetz'uman (yeme'), roma manak xquietiquier xquielumaj (xquienimaj) ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Romari' tibana' orar che ri Dios chi cuando xquiebanataj ronojel re' man quiebanataj pa ru-tiempo job, chi quiri' man cuesta ta nu'on chiwe chi jixlumaj (jixnimaj). ");
INSERT INTO cakNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Roma cuando xtapon ri k'ij ri', can yalan nim ri sufrimiento ri xtipe. Jun sufrimiento ri man jun mej (bey) tz'eton chech-ulef desde que banon-pe roma ri Dios. Y chuka' ri sufrimiento ri' man jun mej (bey) chic xtoka. ");
INSERT INTO cakNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y xa ta ri Ajaf Dios man ta nu'on co'l che ri tiempo chi ri sufrimiento ri', conojel ta yecom. Pero roma ri Dios can yalan yerojo' ri jerucha'on chic, can xtu'on co'l che ri tiempo ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Chupa ri k'ij ri', xa jec'o ri xquie'in chiwe: Titzu', jare' ri Cristo ri takon-pe roma ri Dios, o xa niqui'ij chiwe: Titzu', ja Cristo la' ri takon-pe roma ri Dios, rix man tinimaj ri anchique niqui'ij chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Roma can jec'o ri xquiepe y xtiqui'ij: Ja ren ri Cristo ri takon-pe roma ri Dios. Pero rix man quie'inimaj, roma xa man ketzij ta ri niqui'ij. Y chupa ri tiempo ri' jec'o chuka' ri xquiepe y xtiqui'ij: Ren nink'alajij ri nu'ij ri Dios chue, xquiecha'. Pero rix man quie'inimaj, roma xa man ketzij ta ri yequi'ij chuka'. Reje' xquiequi'en milagros ri man jun mej (bey) je-tz'eton, xe chi yequi'en engañar ri winak. Y reje' can c'o ta niquijo' hasta ri je-cha'on chic roma ri Dios yequi'en ta engañar. ");
INSERT INTO cakNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Pero rix can tibana' cuenta iwi', chi quiri' man jixka ta pa quik'a', roma can ja' yan xin-ij can chiwe ronojel ri xquiebanataj. ");
INSERT INTO cakNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Chupa ri k'ij cuando xek'ax yan ronojel ri sufrimiento ri', xtibanataj chi ri k'ij xtik'okumer y ri ic' chuka' man xtuya' ta chic rusakil. ");
INSERT INTO cakNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri ch'umil can xquietzak-pe anchi' jec'o-wi. Can ronojel ri nimalaj tak uchuk'a' ri jec'o chicaj xquiesilon roma ri ruchuk'a' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Y ja cuando ri winak xquinquitzu' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, chi yika-pe chupa ri ajawa' (mukul), riq'uin chic nimalaj uchuk'a' y c'o chic chuka' nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Y ren xquientak ri nu-ángeles chi yequimol ri jenucha'on chic. Can pa ronojel rech-ulef xquiequimol-wi. Can xquiequimol-wi conojel ri je-cha'on chic; más que xabachique (xama'anchique) lugar chi ri rech-ulef jec'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Can tic'ama' ino'j (ina'oj) chirij ri nu'on jun mata higo. Cuando can yejotayin-pe ri ruk'a' y ye'el-pe ri ruxak, iweta'n chi ri ru-tiempo job ya ntoc-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Y quiri' chuka' cuando xtitzu' chi yebanataj yan ronojel ri xin-ij yan ka chiwe, iweta'n c'a chi noka yan ri k'ij ri'. Can nakaj chic c'o-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Y tic'oxaj utz ri xtin-ij chiwe cami: Ronojel ri' xtibanataj, cuando ri winak chi ri tiempo re' c'a man jani quieq'uis chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ri rech-ulef y ri rocaj can yeq'uis na-wi. Pero ri nutzij man xtiq'uis ta quiri', xa can xtibanataj-wi ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Pero ri k'ij y ri hora cuando ren xquipe man jun etamayon. Ri ángeles ri jec'o chila' chicaj man quieta'n ta jampe'. Quiri' chuka' ren ri jin Ralc'ual ri Dios man weta'n ta. Xa can xe ri Nata' Dios etamayon ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Romari' rix man quixwer, xa can tibana' cuenta utz iwi' chupa ri ic'aslen y tibana' chuka' orar, roma can man iweta'n ta jampe' xtapon ri k'ij chi xquipe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Anche'l jun achi ri nuya' can ri rocho y nibe naj pa jun chic rech-ulef. Raja' nuchelebej can ri rusamaj chique rusamajel, y chijujun nuya' can quisamaj. Che ri nuchajij ri jay can nu'ij chi can listo tic'ue' tuyobej-apo. ");
INSERT INTO cakNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Can quiri' tibana' rix, can siempre quiniyobej-apo. Anche'l ri achi nuchajij jay, roma man reta'n ta jampe' xtoka ri rajaf-jay, raja' nic'atzin nuyobej-apo. Roma ri rajaf-jay riq'uin juba' noka cuando ntoc-pe ri ak'a', o ja ri pa nic'aj-ak'a', cuando xquietzirin-pe (xquiesiq'uin-pe) ri gallo nimak'a' yan, o ja cuando nipe yan ri sakil. Romari' rix can siempre quiniyobej-apo. ");
INSERT INTO cakNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Roma ren can ninjo' chi quiniyobej-apo y man quixwer, roma can man xtinya' ta rutzijol cuando xquipe. ");
INSERT INTO cakNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Y can anche'l ri nin-ij chiwe rix chi quiniyobej-apo, can quiri' chuka' nin-ij chique conojel, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xe chic ca'i' k'ij nrojo' chi napon ri ca'i' quinimak'ej ri israelitas. Ri quinimak'ej ri rubinan pascua. Y ri jun chic ja cuando niquitaj ri pan ri manak levadura riq'uin. Y ja' cuando ri nimalaj tak sacerdotes y ri maestros chi ri ley niquinojila' anchique ta engaño niquicusaj chi nika ri Jesús pa quik'a' y niquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Reje' niqui'ij chiquiwech: Man takatz'om chupa ri nimak'ej re', chi quiri' manak yecataj ri winak chakij, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Y ri Jesús c'o chic pa tenemit rubinan Betania, chiri' pa rocho ri Simón ri xc'achoj riq'uin ri yabil lepra. Ri Jesús ch'ocol y niwa' chiri' chuchi' mesa, y ja' cuando c'o jun ixok xoc-apo y ruc'uan-apo jun frasco ri banon che jun abaj ri ni'ix alabastro che y c'o-e nardo chupa; jun jubulaj ak'om ri can q'uiy ri rajil. Y ri ixok xulesaj-e rukul ri frasco y xuya' ri jubulaj ak'om pa rujolon ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Y jec'o ri xpe quiyowal cuando xquitzu' chi quiri' xu'on ri ixok riq'uin ri jubulaj ak'om y yequi'ij: ¿Anchique roma la ixok la' xu'on quiere', xe choj quiri' xutix la jubulaj ak'om la'? ");
INSERT INTO cakNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Roma xa ta xc'ayix, xyo'x ta más trescientos denarios, y ri mero ri' xjach ta chique ri winak ri manak quibeyomal, xecha'. Y yalan ri niqui'ij-apo chirij ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Pero ri Jesús xu'ij chique: ¿Anchique roma jixch'o'n chirij y man jixtane' ta ka? Xa tiya' can. Raja' can utz-wi ri xu'on chue. ");
INSERT INTO cakNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri winak ri manak quibeyomal can siempre jec'o iwiq'uin, y xabachique (xama'anchique) k'ij ri nijo' ye'ito', can quie'ito'. Pero ren man siempre ta xquic'ue' iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Raja' xu'on ri anchique nitiquier nu'on chue. Can xuc'ut chi yalan yirojo'. Raja' xuya' yan jubulaj ak'om chuij chi cuando xquibemuk can. ");
INSERT INTO cakNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Y tic'oxaj na pe' jabel ri xtin-ij chiwe, chi xabachique (xama'anchique) lugar xtitzijos-wi ri utzilaj rutzij ri Dios, chiri' chuka' xtitzijos-wi ri xu'on ri jun ixok re'. Can pa ronojel rech-ulef xtitzijos-wi, y can man xtiquimestaj ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Y ri Judas Iscariote, jun chique ri je cablajuj ru-discípulos ri Jesús, xapon quiq'uin ri nimalaj tak sacerdotes, chi xusuj-ri', xa niquijo' chi nujach ri Jesús pa quik'a'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Y cuando reje' xquic'oxaj quiri', yalan xequicot. Y xquisuj mero che romari'. Y raja' ja xutz'om rucanoxic anchique modo nu'on chi nujach ri Jesús pa quik'a' ri achi'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xapon ri na'ey k'ij chi ri nimak'ej cuando nitej ri pan ri manak levadura riq'uin. Ja chuka' k'ij ri' cuando yecamises ri alaj tak ral ovejas chi ri pascua. Ja' cuando ri discípulos xquic'utuj che ri Jesús: ¿Anchi' najo' na'an-wi ri wa'in chupa ri jun pascua re', chi jojbe y nakanaba' ronojel ri nic'atzin? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Y ri Jesús can xerutak-e ca'i' chique ri ru-discípulos, y xu'ij-e chique: Cami jixbe pa tenemit Jerusalem, y chiri' xtic'ul jun achi samajel ruc'uan ruya' pa jun cucu' (tinaja). Titzeklebej; ");
INSERT INTO cakNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","y ri jay ri anchi' xtoc-wi raja', chiri' chuka' quixoc-wi rix y quixch'o'n riq'uin ri rajaf-jay y ti'ij che: Ri Maestro ru'in-pe chake: ¿Anchique jay we' chi'awocho ri utz chi nin-en ri wa'in richi ri pascua junan quiq'uin ri nu-discípulos? quixcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Y ri rajaf-jay xquixruc'uaj pa ruca'n piso che ri jay. Y chiri' c'o jun jay nim rupa y banon chic ru'onic; chiri' tinaba-wi ri anchique ri xtakataj chi ri pascua, xe'uche'x-e. ");
INSERT INTO cakNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Y ri ca'i' ru-discípulos xebe pa tenemit Jerusalem. Y cuando xe'apon, can xbanataj na-wi anche'l ri ru'in-pe ri Jesús chique. Y reje' can xquinaba-wi ronojel ri nic'atzin chique chi ri pascua ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Y cuando xcok'a-ka, ri Jesús y ri cablajuj ru-discípulos xe'apon chiri' pa jay. ");
INSERT INTO cakNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Y cuando je-ch'ocol chic apo chuchi' mesa yewa', ri Jesús xu'ij chique ri ru-discípulos: Can ketzij nin-ij chiwe, chi jun chiwe rix ri niwa-pe wiq'uin ri xtijacho wichi pa quik'a' ri winak ri man jinquijo' ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Reje' can ja xebison-ka, y niquic'utula-apo che ri Jesús: ¿Man ja' ta como ren ri xquibano quiri'? yecha' chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Y ri Jesús ja' xu'ij chique: Ri xtibano quiri' ja ri jun chiwe rix jix cablajuj, ri numuba-pe ru-pan wiq'uin chupa ri plato. ");
INSERT INTO cakNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Can tic'oxaj ri xtin-ij chiwe, ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can xquicamises. Can xtibanataj-wi anche'l ri tz'iban can chupa rutzij ri Dios. Pero juya' (juyu') rech ri xtijacho wichi, ri achi ri xtijacho-e wichi más utz man ta xalex, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Y cuando c'a ye'ajin riq'uin ri wa'in, ri Jesús xuc'on-apo jun pan y xuya' matiox che ri Dios. C'ajari' xuper ri pan y xuya' chique ri ru-discípulos. Raja' xu'ij chique ri ru-discípulos: Tic'ama' ri pan re'; roma jare' ri nuch'acul ri xtapon pa camic. ");
INSERT INTO cakNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Y ri Jesús xuc'on-apo ri vaso ri c'o ruya'al-uva chupa, y xuya' matiox che ri Dios; c'ajari' xuya' ri vaso chique, y conojel xquikum ri ruya'al-uva. ");
INSERT INTO cakNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Y raja' xu'ij chique ri ru-discípulos: Jare' ri nuquiq'uiel ri xtibin cuando xquicamises. Riq'uin ri nuquiq'uiel, can ja' xtic'achoj ri c'ac'ac' trato ri rurayin-pe ri Dios chi nu'on quiq'uin ri winak. Ri nuquiq'uiel can xtibin, chi quiri' je q'uiy winak yecolotaj. ");
INSERT INTO cakNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tic'oxaj ri xtin-ij chiwe: Ja ruq'uisbel mej (paj) re' xinkum-e ruya'al-uva. Y c'aja' cuando jinc'o chic pa ru-gobierno ri Dios, c'ajari' xtinkum chic jun mej (bey). Y ri ruya'al-uva ri xtinkum chiri', jun c'ac'ac' ruya'al-uva, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Y cuando quibixan chic ri bix richi niquiya' ruk'ij ri Dios, ri Jesús y ri ru-discípulos xe'el-e ri chiri' pa jay y xebe chech ri juyu' rubinan Olivos. ");
INSERT INTO cakNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Y cuando je-benak, ri Jesús xu'ij chique ri ru-discípulos: Chi'iwonojel rix xtitaluj-e-iwi' y nuyon xquic'ue' can chupa ri nok'ok'a' re', cuando xtitzu' chi ren xquijach pa quik'a' ri winak. Roma ri Dios can nu'ij-wi chupa ri tz'iban can: Cuando ren xtinya' lugar chi nicamises ri nichajin quichi ri ovejas, conojel ri ovejas ri' xtiquitaluj-e-qui'. Quiri' ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Pero ren ri jin Quichajinel ri ovejas ri' man xquicom ta jumul, xa xquic'astaj-pe. Y can xquixinyobej chila' pa Galilea, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Y ri Pedro xu'ij che: Xa ri ch'aka chic jatquiya' can ayon, ren man xtin-en ta quiri', xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Pero ri Jesús xu'ij che ri Pedro: Ren can ketzij nin-ij chawe, chi cami chupa ri jun ak'a' re', xa c'a man jani titzirin-pe (tisiq'uin-pe) ri gallo ca'i' mej (paj) cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pero más que ri Jesús xu'ij quiri', ri Pedro xu'ij chic apo che: Xa ta can nic'atzin chi junan yicom awiq'uin ret, can quiri' tibanataj, pero can manak-wi xtin-ij chi ren man weta'n ta awech. Y chuka' ri ch'aka chic discípulos can quiri' chuka' xqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ri Jesús y ri ru-discípulos xe'apon chupa ri lugar rubinan Getsemaní. Y ri Jesús xu'ij chique ri ru-discípulos: Quixch'oquie' juba' we', y ren nenbana' orar. ");
INSERT INTO cakNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Raja' xe ri Pedro, ri Jacobo y ri Juan ri xeruc'uaj riq'uin. Raja' can jun nimalaj bis xpe pa ránima, roma nuna' yan ronojel ri xteruc'ulumaj. ");
INSERT INTO cakNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Y xu'ij chique ri oxi' ru-discípulos: Ri wánima yalan nibison; can yirucamisaj ninna'. Quixc'ue' can we', quixc'ase' y man quixwer-ka, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Raja' xbin chic apo juba' y c'ajari' xxuquie-ka y xukasaj-ka ri nic'aj-rech c'a chech-ulef y xu'on orar. Raja' xuc'utuj xa can c'o ta modo, utz ta nik'ax-e ri hora ri', chi quiri' man ta nik'ax pa ruwi' ri sufrimiento. ");
INSERT INTO cakNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Y quiere' ri tzij ri xeru'ij pa ru-oración: Nata', ren weta'n chi ret jatiquier na'an ronojel. Quinacolo' chi quiri' man nik'ax ta pa nuwi' ri jun sufrimiento re'. Pero man ta'an ri ninrayij ren. Roma ren can ninjo' chuka' nin-en ri anchique narayij ret. ");
INSERT INTO cakNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Y cuando raja' xc'achoj riq'uin ri oración, xoka quiq'uin ri oxi' ru-discípulos, pero reje' xa yewer. Xpe raja' xu'ij che ri Pedro: Simón, ¿xa xawer-ka? ¿Can man xatiquier ta xac'ase' jun hora oc wiq'uin? ");
INSERT INTO cakNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Man quixwer-ka, xa tibana' orar y tic'utuj che ri Dios chi cuando jixtojtobex, man quixtzak pa mac. Ren can weta'n chi ri iwánima can nurayij nu'on ri nrojo' ri Dios. Pero iyon rix can man jixtiquier ta, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Y ri Jesús xbe chic jun mej (bey) chi xberu'ona' orar. Raja' xu'ij jun mej (bey) chic ri tzij ri xeru'ij chupa ri na'ey oración. ");
INSERT INTO cakNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Y cuando xtzolaj chic pe jun mej (bey) quiq'uin ri oxi' ru-discípulos, xa yewer jun mej (bey) chic xeril, roma reje' man niquicoch' ta chic quiwaran. Y reje' man niquiwil ta anchique niqui'ij, roma xe'litaj chic jun mej (bey) quitz'amon waran. ");
INSERT INTO cakNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Y ri Jesús xbe chic y xberu'ona' orar jun mej (bey) chic. Pero cuando xtzolaj chic pe pa rox mej (paj), raja' xu'ij chique ri oxi' ru-discípulos: Cami can quixwer y tiq'uisa' ri iwaran. Pero manak chic modo. Roma ren ri jin-kajinak-pe chicaj y xinalex chi'icojol can ja' xoka ri nu-hora, can xquijach-e pa quik'a' ri itzel tak achi'a'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Quixcataj. Ja' petenak ri xtijacho wichi pa quik'a' ri itzel tak achi'a', xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Y ri Jesús can c'a nich'o'n quiq'uin ri ru-discípulos, cuando ja xoka ri Judas ri jun chique ri cablajuj ru-discípulos; raja' jeruc'uan-apo q'uiy winak ri jequic'ualo'n-apo che' y espadas. Conojel re' je-takon-e coma ri nimalaj tak sacerdotes, coma ri maestros chi ri ley y coma chuka' ri rijilaj tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ri Judas ri nijacho-e richi ri Jesús, can ru'in yan pe chique ri je-petenak riq'uin anchique retal xtu'on chi nuc'ut ri Jesús chiquiwech. Raja' ru'in-pe chique: Ja ri jun ri xtintz'ubaj, jari' ri Jesús. Titz'ama', y man tilumaj (tinimaj) chiwech. ");
INSERT INTO cakNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Y cuando ri Judas xapon, can ja' xbe-apo riq'uin ri Jesús y xu'ij che: Maestro, Maestro, xcha' che y ja' xutz'ubaj. ");
INSERT INTO cakNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Y ri winak ri je-petenak chi niquitz'om ri Jesús, can ja' xquitz'om. ");
INSERT INTO cakNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Y jun chique ri jec'o riq'uin ri Jesús chiri', xulesaj ri ru-espada, xuya' che ri jun rusamajel ri sacerdote ri más c'o ruk'ij, y ja ri ruxiquin ri xulesaj-e riq'uin ri espada. ");
INSERT INTO cakNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Y c'ajari' xpe ri Jesús xu'ij chique ri winak ri noquitz'ama': ¿Anchique xinojij rix? ¿Xinojij chi jun elek'om nitz'om-e romari' ic'amon-pe che' y espadas? ");
INSERT INTO cakNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ren can k'ij-k'ij xic'ue' iwiq'uin chiri' pa rocho ri Dios, cuando xinc'ut rutzij ri Dios chiwech, y man xinitz'om ta. Roma can quiere' na-wi nibanataj, can anche'l ri tz'iban can chupa rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Y ri discípulos can ja' xelumaj-e (xenimaj-e) y ruyon oc xquiya' can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Pero c'o jun ala' ri rutzekleben-e ri Jesús y xe choj jun tziak nim ruk'un-e. Y ri je-tz'amayon-e ri Jesús, xquitz'om chuka' ri ala' ri'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero raja' xa xel-e chupa ri tziak ri', y xe quiri' man jun rutziak chirij xlumaj-e (xnimaj-e) chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Y ri winak ri quitz'amon-e ri Jesús xquic'uaj-e c'a pa rocho ri sacerdote ri más c'o ruk'ij. Y chiri' chuka' xquimol-wi-qui' ri nimalaj tak sacerdotes, y ri rijilaj tak achi'a' ri c'o quik'ij, chuka' ri maestros chi ri ley. ");
INSERT INTO cakNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Y ri Pedro c'a naj c'o-wi can, pero rutzekleben-e ri Jesús. Y cuando ri Jesús xcuses-apo pa rocho ri sacerdote ri más c'o ruk'ij, chuka' ri Pedro xoc-apo chiri' chojay. Y xch'oquie-ka chiquicojol ri samajel ri jec'o-apo chiri', niquimak'-qui' chi-k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Y ri nimalaj tak sacerdotes y conojel ri achi'a' je autoridad quichi ri israelitas, can niquitaj quik'ij chi jec'o ta jujun winak yequiwil chi niquitz'uc tzij chirij ri Jesús, chi quiri' nicamises, pero xa man jun xquiwil chirij. ");
INSERT INTO cakNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Can je q'uiy ri xe'apon y xquitz'uc tzij chirij, pero xa man junan ta ri niqui'ij-apo; y romari' xa can man jun ruchuk'a' ri tzij ri xqui'ij-apo. ");
INSERT INTO cakNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Y jec'o ch'aka chic ri xebepa'e-pe y quiere' xqui'ij chirij ri Jesús: ");
INSERT INTO cakNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Roj can kac'oxan chi raja' ru'in: Ren xtinwulij (xtinwulaj) rocho ri Dios banon coma achi'a', y pa oxi' k'ij xtin-en chic jun, y man achi'a' ta xquiebano. ");
INSERT INTO cakNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Y ni riq'uin ri', man junan ta chuka' ri xqui'ij-apo. ");
INSERT INTO cakNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Y ri Caifás, ri sacerdote ri más c'o ruk'ij, xbepa'e-pe ri pa quinic'ajal y xuc'utuj che ri Jesús: ¿Anchique na'ij cami? ¿Ketzij la xqui'ij-ka chawij? xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús man xch'o'n ta. Can man jun tzij ri xu'ij. Romari' xpe ri sacerdote ri más c'o ruk'ij, xuc'utuj chic che. Raja' xuc'utuj che: ¿Ja ret ri Cristo ri Ralc'ual ri Dios ri nakaya' ruk'ij? xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Y ri Jesús xu'ij: Ja', ja ren. Y xquinitzu' chuka' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol chi jin-ch'ocol pa ru-derecha ri Dios ri nitiquier yeru'on ronojel. Y xquinitzu' cuando ren yika-pe chupa ri ajawa' (mukul) ri chicaj. ");
INSERT INTO cakNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Cuando ri sacerdote ri más c'o ruk'ij xuc'oxaj ri', xuretz-ka rutziak chirij roma itzel xuc'oxaj y xu'ij: Man nic'atzin ta chi noka jun chic chi noru'ij chake chi ri Jesús can c'o rumac. ");
INSERT INTO cakNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Rix xic'oxaj ri xu'ij chi ja raja' ri Cristo ri takon-pe roma ri Dios. Ri' can itzel chech ri Dios. ¿Anchique ni'ij cami? xcha' raja'. Y conojel xqui'ij chi utz chi ticamises. ");
INSERT INTO cakNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y jec'o ri xquitz'ucula-ka niqui'en q'uiy quitzelal che ri Jesús. Xquichubaj, xquitz'apij rech, xquich'ey y niquic'utula' che: ¿Ancu'x (Anchique) ri xch'eyo awichi? Ta'ij chake, yecha' che. Y ri samajel ri jec'o chiri', xquipak'ala' rupalaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Y cuando ri Pedro c'a c'o-ka chojay, c'o jun ixok raj-ic' ri sacerdote ri más c'o ruk'ij ri xapon chuka' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ri Pedro rumak'on-ri' chi-k'ak'. Y cuando xapon ri ixok ri', xe xutzu-xutzu' rech ri Pedro y xu'ij che: Ret chuka' jat jun chique ri jec'o riq'uin ri Jesús ri aj-Nazaret, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pero ri Pedro xa xrewaj, roma xu'ij: Ren man weta'n ta rech ri Jesús. Man nin-en ta entender chuka' anchique roma quiri' na'ij chue, xcha' che ri ixok. Y ri Pedro xel-e chi-bey. Y ja cuando ri gallo xtzirin-pe (xsiq'uin-pe). ");
INSERT INTO cakNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Y cuando ri ixok aj-ic' xutzu' chic jun mej (bey) ri Pedro, xu'ij chique ri jec'o chiri': La achi la' jun chique ri jec'o riq'uin ri Jesús, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pero ri Pedro xa xrewaj chic. Y c'a juba' ri' ja yan chic ri quimolon-qui' chiri' xqui'ij chic che: Can ketzij-wi chi ret jat jun chique ri jec'o riq'uin ri Jesús. Roma ret pa Galilea jat-petenak-wi, y can junan jach'o'n quiq'uin, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pero ri Pedro xu'ij: Ren man weta'n ta rech ri achi ri ni'ij rix. Can chech Dios nin-ij chiwe chi ren man weta'n ta rech. Y xa man ketzij ta ri nin-ij, tika ri castigo ri xtuya' ri Dios pa nuwi', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Y ri gallo xbetzirin-pe (xbesiq'uin-pe) ruca'n mej (paj). Y ri Pedro xoka pa ruwi' ri tzij ri ru'in can ri Jesús che, chi can man jani titzirin-pe (tisiq'uin-pe) ri gallo ruca'n mej (paj) ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech. Y raja' xujik' ok'ej cuando xel-e ri chiri', roma noka pa ruwi' ronojel ri tzij ri xu'ij ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Y cuando xsakar-pe ri k'ij ri', ri nimalaj tak sacerdotes xquimol-qui' quiq'uin ri rijilaj tak achi'a' ri c'o quik'ij y ri maestros chi ri ley. Can conojel-wi ri achi'a' ri je autoridad quichi ri israelitas xquimol-qui'. Reje' niquinojij anchique niqui'en riq'uin ri Jesús, y ja xquixim-e y xbequijacha' pa ruk'a' ri Pilato, ri gobernador. ");
INSERT INTO cakNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Y ri Pilato xuc'utuj che ri Jesús: ¿Ja ret ri qui-Rey ri israelitas? xcha' che. Y ri Jesús xu'ij: Ja', can quiri-wi, anche'l ri xa'ij, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Y ri nimalaj tak sacerdotes, q'uiy ri niqui'ij-apo che ri Pilato, chi niquisujuj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Y ri Pilato xch'o'n chic apo che ri Jesús y xu'ij che: Reje' can yalan niqui'ij-pe chawij chi jatquisujuj, y ret ¿man jun tzij na'ij chi nato-awi'? xcha' ri Pilato che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pero ri Jesús can man jun tzij ri xu'ij. Y ri Pilato can xsatz-ka runo'j (xsach-ka ruc'u'x) roma man jun mej (bey) rutz'eton jun winak ri nu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Y juna-juna' cuando napon ri quinimak'ej ri israelitas, ri ni'ix pascua che, ri gobernador nusk'opij jun chique ri jec'o pa cárcel, ri jun ri niquijo' ri winak chi ntel-e. ");
INSERT INTO cakNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Y chupa ri tiempo ri', c'o pa cárcel jun achi rubinan Barrabás. Junan je-tz'apel quiq'uin ch'aka chic raxbil roma xecataj chirij ri gobierno y xqui'en camic. ");
INSERT INTO cakNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ri winak can quieta'n chi ri gobernador can nusk'opij-wi jun chique ri jec'o pa cárcel, romari' reje' xe'apon riq'uin y xquic'utuj che chi tusk'opij-e jun chique ri je-tz'apel. ");
INSERT INTO cakNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Y ri Pilato can ja xuc'utuj chique: ¿Nijo' rix chi ninsk'opij-e ri i-Rey rix israelitas? ");
INSERT INTO cakNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ri Pilato quiri' xu'ij roma raja' can reta'n-wi chi ri nimalaj tak sacerdotes quijachon ri Jesús pa ruk'a', roma itzel niquitzu' chi can je q'uiy winak ri yetzekleben richi. ");
INSERT INTO cakNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Y ri nimalaj tak sacerdotes xquiya' quino'j (quina'oj) ri winak, chi tiqui'ij-apo che ri Pilato chi ja ri Barrabás tusk'opij-e. Y ri winak can quiri' xqui'en. ");
INSERT INTO cakNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Y ri Pilato xch'o'n chic pe jun mej (bey) y xuc'utuj chique: ¿Anchique ri nijo' rix chi nin-en ren riq'uin ri achi ri ni'ij chi i-Rey rix israelitas? xcha' raja' chique. ");
INSERT INTO cakNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Y ri winak riq'uin ronojel quichuk'a' xqui'ij: ¡Ticamises chech cruz! xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Romari' ri Pilato xuc'utuj chique: ¿Anchique rumac rubanon chiwech? Pero reje' man yetane' ta ka. Xa riq'uin más quichuk'a' xqui'ij-apo: ¡Ticamises chech cruz! xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Y ri Pilato xusk'opij-e ri Barrabás, chi quiri' utz nitz'et coma ri winak; y xutak ruch'ayic ri Jesús y xujach-e chi ticamises chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Xepe ri soldados xquicusaj-apo ri Jesús chojay chi ri palacio; c'ajari' xequiwoyoj conojel ri ch'aka chic soldados, y xquimol-apo-qui' chirij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Y ri soldados re' xquiya' jun tziak morado chirij ri Jesús, can anche'l ri yequicusaj ri reyes. Y xquipach'uj chuka' jun k'ayis ri yalan ruq'uixal. Can anche'l jun corona xqui'en che, y c'ajari' xquiya' pa rujolon ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xepe chuka' ri soldados can niqui'en chi c'o ruk'ij ri Jesús y niqui'ij che: Caquicot ret qui-Rey ri israelitas, yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Y niquich'eyala' pa rujolon riq'uin jun aj y niquichubaj. Chuka' can yexuquie' chech, anche'l can niquiya' ruk'ij niqui'en, pero xa yetze'n chirij. ");
INSERT INTO cakNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Y cuando reje' xetane-ka yetze'n chirij, xquilesaj-e ri tziak morado ri quiyo'n chirij. C'ajari' xquiya' ri can rutziak-wi raja', y xquic'uaj-e chi niquibajij chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cuando quitz'amon-e bey, xquic'ul jun achi aj-Cirene, ri petenak pa k'ayis. Ri achi re', quitata' ri Alejandro y Rufo. Y raja' rubinan Simón. Y ri soldados xqui'en che ri achi ri' chi tuc'uaj-e ri ru-cruz ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y ri soldados xquic'uaj ri Jesús chupa ri lugar rubinan Gólgota. Ri lugar ri' ni'ix chuka' Calavera che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Y cuando jec'o chic chiri', xquiya' che ri Jesús vino xolon riq'uin mirra. Pero raja' man xrojo' ta. ");
INSERT INTO cakNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Y cuando ri soldados xquibajij yan ri Jesús chech cruz, xquilesaj suerte chirij ri rutziak, chi niquina'ej anchique tziak niquic'uaj-e chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","A las nueve ri nimak'a' cuando xquibajij ri Jesús chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Y chutza'n ri ru-cruz, xquiya' jun letrero ri nu'ij anchique roma nicamises ri Jesús. Chech ri letrero ri' nu'ij: Jare' ri qui-Rey ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Y ri soldados jec'o chuka' je ca'i' chic ri xequibajij. Ri ca'i' achi'a' ri' je elek'oma'. Jun xyo'x pa ru-derecha ri Jesús y ri jun chic pa ru-izquierda. ");
INSERT INTO cakNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Y riq'uin ri' can nibanataj anche'l ri tz'iban can chupa ri rutzij ri Dios, ri nu'ij: Raja' can anche'l jun aj-mac x-an che. Quiri' ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri winak ri yek'ax-e y ye'apon riq'uin ri Jesús, niquisiloj-apo quijolon chech, roma can man niquinimaj ta chi ja raja' ri Ralc'ual ri Dios. Y c'o chuka' itzel tzij ri yequi'ij can che. Ri winak ri' niqui'ij che ri Jesús: Ret xa'ij chi can nawulij (nawulaj) ri rocho ri Dios y pa oxi' k'ij napoba' chic jun mej (bey). ");
INSERT INTO cakNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Tacolo-awi' ayon y caka-pe chiri' chech ri cruz, yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Y quiri' chuka' niqui'en ri nimalaj tak sacerdotes y ri maestros chi ri ley, reje' yalan yetze'n-apo chirij ri Jesús y niqui'ij chiquiwech: Raja' can je q'uiy xerucol, pero raja' cami man nitiquier ta nucol-ri' ruyon. ");
INSERT INTO cakNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Xa can ketzij chi ja raja' ri Cristo, ri ka-Rey roj israelitas, can tika-pe chech la ru-cruz c'a, chi quiri' nakatzu' y nakanimaj, yecha' chiquiwech. Y ri elek'oma' ri je-bajin chech qui-cruz riq'uin ri Jesús, can itzel chuka' yech'o'n-apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Y pa nic'aj-k'ij, ronojel ri rech-ulef xk'okumer-ka. Y ri k'eku'm ri' xq'uis-e c'a nak'ak'ij a las tres. ");
INSERT INTO cakNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Y ja chupa ri hora ri' a las tres, ri Jesús can riq'uin ronojel ruchuk'a' xch'o'n y xu'ij: Eloi, Eloi, ¿lama sabactani? xcha'. Y ri tzij ri xeru'ij raja', quiere' ri nu'ij: Nu-Dios, nu-Dios, ¿anchique roma xinamalij can? ");
INSERT INTO cakNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Y jec'o chique ri jec'o-apo chiri' chunakaj ri Jesús, cuando xquic'oxaj ri xu'ij, ja xqui'ij: ¿Xic'oxaj? Raja' ja ri Elías ri nroyoj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Y ja' c'o jun ri junanin xberumuba-pe jun esponja chupa jun ch'amilaj ruya'al-uva, xuya' chutza'n jun aj y xuya' che ri Jesús chi nich'uch'u-ka juba' ri ránima, y xu'ij: Kayobej na c'a, k'alaj ri' xa noka ri Elías chi norukasaj, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Y ja cuando ri Jesús riq'uin ronojel ruchuk'a' xch'o'n y xcom-ka. ");
INSERT INTO cakNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Y ri tziak ri yo'n-apo chi nujach ri rupa ri rocho ri Dios, xk'ach'itaj ri pa jotol c'a pa xulan ka. ");
INSERT INTO cakNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Y chech pe ri cruz anchi' c'o-wi ri Jesús, pa'l qui-capitán ri soldados. Raja' xuc'oxaj cuando ri Jesús riq'uin ronojel ruchuk'a' xch'o'n y xcom-ka. Romari' xu'ij: Can ketzij-wi chi ri achi re' can Ralc'ual-wi ri Dios, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Y jec'o chuka' ixoki' ri chinaj yetzu'n-apo. Chiquicojol ri ixoki', c'o c'a ri María Magdalena, c'o ri María ri quite' ri José y ri Jacobo ri co'l y c'o chuka' ri jun ixok rubinan Salomé. ");
INSERT INTO cakNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Cuando ri Jesús c'a c'o pa Galilea, ri ixoki' ri' can quitzekleben y quilin-pe. Y chuka' can jec'o ch'aka chic ixoki' ri quitzekleben-apo ri Jesús pa Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ri nak'ak'ij cuando xcom ri Jesús, ri k'ij chi uxlanen nitiquier yan ka. Romari' ri winak niquinaba' yan ronojel ri xtic'atzin chique chupa ri k'ij chi uxlanen. Ja yan nika-ka ri k'ij chupa ri k'ij ri', ");
INSERT INTO cakNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","cuando xapon jun achi rubinan José aj-tenemit Arimatea. Raja' jun chique ri achi'a' ri je autoridad chiquicojol ri quiwinak y can c'o ruk'ij chiquicojol reje'. Raja' can ruyoben chuka' cuando ri Dios xtu'on gobernar. Y raja' xapon riq'uin ri Pilato chupa ri hora ri', y can man jun chic xibinri'l chech xberuc'utuj ruch'acul ri Jesús chi numuk. ");
INSERT INTO cakNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pero ri Pilato can xsatz runo'j (xsach ruc'u'x) chi ch'anin yan xcom ri Jesús. Romari' raja' xroyoj ri capitán, y xuc'utuj che xa ketzij xcom yan ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Y cuando ri Pilato reta'n chic roma ri xu'ij ri capitán, c'ajari' xuya' lugar che ri José chi terumuku' can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Y ri José xulok' jun tziak nim. Y cuando rukasan chic pe ri ruch'acul ri Jesús chech ri cruz, xupis chupa ri tziak ri'. Y c'ajari' xberumuku' can pa jun jul ri c'oton chech jun nimalaj abaj can anche'l jun juyu'. Raja' xutz'apij can ruchi' ri jul riq'uin jun abaj. ");
INSERT INTO cakNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Y ri María Magdalena y ri María ri quite' ri José y ri Jacobo, xquitzu' jabel anchi' xmuk-wi can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Y cuando xk'ax yan ri k'ij chi uxlanen, ri María Magdalena, ri María ri quite' ri José y ri Jacobo, y chuka' ri ixok rubinan Salomé, xequilok' jubulaj tak ak'om chi ne'quiya' can chirij ruch'acul ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","C'a cumaj yan chupa ri na'ey k'ij chi ri semana, xebe c'a chuchi' ri jul. Y ja xel-pe ri k'ij cuando xe'apon. ");
INSERT INTO cakNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Y reje' niqui'ij chiquiwech: ¿Ancu'x (Anchique) xtijako ri jul chakawech? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cuando xquitzu' ri jul, xquitzu' chi xa jakal yan. Ri nimalaj abaj chi nitz'ape' ruchi' ri jul, xa xleses yan e. ");
INSERT INTO cakNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Y cuando reje' jec'o chic apo chupa ri jul, xquitzu' chi c'o jun anche'l ala' ch'ocol chiri' pa ru-derecha, ri can sak rutziak y can c'a chirakan napon-wi-ka. Y cuando ri ixoki' xquitzu' ri', xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Pero raja' xu'ij chique: Man tixi'j-iwi'. Roma ren can weta'n chi rix nicanoj ri ruch'acul ri Jesús aj-Nazaret, ri xcamises chech cruz. Raja' xc'astaj yan e, man c'o ta chic we'. Titzu' la anchi' xc'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Cami c'a, ibij che ri Pedro y chique ri ch'aka chic ru-discípulos ri Jesús, chi ri Jesús xtina'ey-e chiwech c'a pa rech-ulef Galilea; chiri' xtitzu-wi, can anche'l ri ru'in can chiwe. ");
INSERT INTO cakNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Y ri ixoki' xe'el-pe chiri' chupa ri jul. Reje' yebarbot xelumaj-e (xenimaj-e) roma can yalan quixi'n-qui'. Y romari' can man jun anchok che xquitzijoj-wi. ");
INSERT INTO cakNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Cuando ri Jesús xc'astaj chupa ri nimak'a' domingo, ri na'ey k'ij chi ri semana, na'ey xuc'ut-ri' chech ri María Magdalena; ri ixok ri anchok riq'uin xerulesaj-e wuku' itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Y ri María Magdalena can ja' xberu'ij chique conojel ri xquitzeklebej ri Jesús. Reje' yalan yebison y ye'ok'. ");
INSERT INTO cakNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Pero cuando reje' xquic'oxaj chi ri Jesús xc'astaj yan pe y ri María Magdalena xutzu' yan can, xa man xquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","C'ajari' ri Jesús xuc'ut-ri' chiquiwech je ca'i' achi'a' ri quitz'amon-e bey chi ye'apon pa jun chic lugar. Pero roma ri Jesús jun-wi chic nitzu'n cuando xuc'ut-ri' chiquiwech, man ch'anin ta xquitemaj rech. ");
INSERT INTO cakNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ri ca'i' achi'a' re' xbequi'ij chuka' chique ri ch'aka chic ri xquitzeklebej ri Jesús, pero reje' chuka' man xenimex ta. ");
INSERT INTO cakNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","C'ajari' ri Jesús xuc'ut-ri' chiquiwech ri julajuj ru-discípulos cuando yewa'. Raja' xu'ij chique: ¿Anchique roma rix man xinimaj ta y cof xiben che iwánima? xcha' chique. Quiri' xu'ij chique roma ri discípulos can man xquinimaj ta quitzij ri xetz'eto ri Jesús chi xc'astaj yan pe chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Y xu'ij chuka' chique: Can quixbin chech ronojel ri rech-ulef y titzijoj ri utzilaj rutzij ri Dios chique conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ri winak ri xtiquinimaj ri utzilaj rutzij ri Dios y chuka' xtiqui'en bautizar qui', xquiecolotaj. Pero ri winak ri man xtiquinimaj ta, xtika ri castigo pa quiwi'. ");
INSERT INTO cakNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Y ri winak ri xtiquinimaj nubi', can q'uiy ex xquietiquier xtiqui'en chi nik'alajin chi can jinc'o quiq'uin: Can pa nubi' ren xquiequilesaj itzel tak espíritus y xquiech'o'n pa ch'aka chic ch'abel ri xtuya' ri Espíritu Santo chique. ");
INSERT INTO cakNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Chuka' xa xquiequitz'om itzel tak cumetz y xa xtiquikum veneno, man jun anchique xtiquic'ulumaj. Xtiquiyala' chuka' quik'a' pa quiwi' yawa'i' y xquiec'achoj can coma, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Cuando ri Ajaf Jesús xtzijon yan can chique ri ru-discípulos, raja' xuc'uax-e chila' chicaj riq'uin ri Dios y xch'oquie-apo pa ru-derecha. ");
INSERT INTO cakNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Y ri discípulos can naj y nakaj xebe-wi chi xquitzijoj ri rutzij ri Dios. Y ri Ajaf can benak quiq'uin chi yeruto', y chuka' can xu'on chique chi q'uiy milagros ri xetiquier xequi'en chi tik'alajin chi can ja ri ketzij ri niquitzijoj. Amén.");
INSERT INTO cakNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Je q'uiy quitijon yan quik'ij chi niquinuc' ruchi' niquitz'ibaj ri xebanataj pa ka-tiempo roj. ");
INSERT INTO cakNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Y can anche'l ri xtzijos chake coma ri xetz'eto-pe pa ruticribel, can quiri' xtz'ibes. Y ri xetz'eto ri xebanataj, can xquitzijoj chuka' rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Y cami, ren chuka' ninjo' nintz'ibaj ri xebanataj. Can xintaj nuk'ij xenmol ruchi' ronojel ri xebanataj. Y jari' ri ninjo' nintzijoj chawe ret nimalaj Teófilo. Can chijujun-chijujun nintz'ibaj ri xebanataj desde pa ruticribel c'a pa ruq'uisbel, ");
INSERT INTO cakNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chi quiri' can nana'ej utz chi can ketzij-wi ri c'utun chawech chirij ri Jesucristo. ");
INSERT INTO cakNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Chiri' pa Judea xc'ue' jun sacerdote Zacarías rubi', y raja' xc'ue' quiq'uin ri sacerdotes ri je richi ri Abías x-ix chique. Pa ru-tiempo ri Zacarías ja ri Herodes ri rey pa Judea. Ri raxayil ri Zacarías Elisabet rubi'. Ri Elisabet re' jun ru-familia can ri nimalaj sacerdote Aarón. ");
INSERT INTO cakNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri Zacarías y ri Elisabet can choj quic'aslen chech ri Ajaf Dios. Reje' can niqui'en-wi ri nu'ij ri ru-mandamientos y ri ru-leyes ri Ajaf. Y man jun winak nitiquier ni'in anchique tzij chiquij, roma reje' can choj-wi quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Reje' man jun calc'ual, roma ri Elisabet can manak-wi yec'ue' ral. Y chi je ca'i' je ri'j chic chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Y jun k'ij cuando ri Zacarías y ri ch'aka chic sacerdotes ri je richi ri Abías x-ix chique, jec'o pa rocho ri Dios roma ja' xapon qui-turno chi yesamaj chiri', quiere' xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chiquijunal ri sacerdotes ri' can jalajoj rech samaj ri niqui'en, y ri k'ij ri' pa ruwi' ri Zacarías xka-wi chi ja raja' ntoc-apo pa rocho ri Dios chi nuporoj ri incienso. ");
INSERT INTO cakNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Y cuando nuporoj ri incienso, conojel winak ri quimolon-apo-qui' chech ri rocho ri Dios, niqui'en orar. ");
INSERT INTO cakNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Y cuando ri Zacarías c'o chiri' chi nuporoj ri incienso, ja' xuc'ut-ri' jun ángel chech, jun ángel richi ri Ajaf Dios. Y ri ángel re' xpa'e' chunakaj ri altar anchi' niporox-wi ri incienso. Pa ru-derecha ri altar xpa'e-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cuando ri Zacarías xutzu' ri ángel re', xsatz runo'j (xsach ruc'u'x) y xuxi'j-ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero ri ángel xu'ij che ri Zacarías: Man taxi'j-awi'. Ri Dios xuc'oxaj ri a-oración. Ri Elisabet ri awaxayil ne'c'ue' jun ral, y ri ne'y re', Juan rubi' xta'an che. ");
INSERT INTO cakNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Roma ri ne'y re' can xcaquicot y q'uiy winak chuka' xquiequicot roma. ");
INSERT INTO cakNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Roma ri awalc'ual re' xtoc nimalaj samajel chech ri Dios. Manak xtukum vino ni xtutaj ya', roma desde que xtalex, nojinak yan pe ránima riq'uin ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y roma raja', je q'uiy awinak israelitas xtiquinimaj ri Ajaf Dios y xtijalataj quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ja ri Juan ri awalc'ual ri can xtunaba' cánima ri winak anchi' xtoka-wi ri Ajaf. Raja' can xtic'ue' ri Espíritu Santo riq'uin y xtic'ue' chuka' ruchuk'a', can anche'l xc'ue' riq'uin ri Elías, ri jun ri xuk'alajij rutzij ri Dios ojer can. Y chuka' roma ri Juan, ri te'j-tata'j can xquiequijo' ri calc'ual, y chuka' ri man yeniman ta, xtiquic'uaj jun chojmilaj c'aslen anche'l quic'uan ri winak ri can choj-wi quic'aslen chech ri Dios. Quiri' xtu'on ri Juan chique ri winak, chi quiri' ri winak re' can niquiyobej-apo jampe' xtoka ri Ajaf, xcha' ri ángel che ri Zacarías. ");
INSERT INTO cakNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Y ri Zacarías xuc'utuj che ri ángel: ¿Anche'l xtinna'ej ren chi can ketzij ri na'ij? Roma ren y ri waxayil xa joj ri'j chic, y man yec'ue' ta chic kalc'ual, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Y ri ángel xu'ij che: Ja ren ri nubinan Gabriel, y ri Dios yirutak chi nin-en ri nrojo'. Romari' xirutak-pe cami chi nonbij-ka ri utzilaj tzij re' chawe. ");
INSERT INTO cakNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Y roma man xanimaj ta ri xin-ij chawe, man xcach'o'n ta chic; c'a xtalex na ri awalc'ual, c'ajari' xcach'o'n chic jun mej (bey). Ronojel re' can xtibanataj na-wi, pero c'a xtapon na ri k'ij, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Cuando ri Zacarías nitzijon riq'uin ri ángel, ri winak ri quiyoben-apo chech ri rocho ri Dios niqui'ij: ¿Anchique roma man ntel ta pe chupa ri rocho ri Dios? Xa xlayoj yan ka. ");
INSERT INTO cakNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Y cuando ri Zacarías xbe'el-pe, man nitiquier ta nich'o'n y romari' man xch'o'n ta chique, y ri quiyoben-apo xquina'ej chi c'o ri xk'alajix-pe chech chupa ri rocho ri Dios. Ri Zacarías xe che ruk'a' nu'on-wi señas chique, roma xa man nitiquier ta chic nich'o'n. ");
INSERT INTO cakNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Y cuando raja' xuq'uis ru-turno chi xsamaj chiri' pa rocho ri Dios, xbe chirocho. ");
INSERT INTO cakNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Y jun jani' k'ij tuc'ulumaj quiri' ri Zacarías pa rocho ri Dios, ri Elisabet ri raxayil xuna'ej chi ne'c'ue' jun ral, y romari' man xel ta pa bey wo'o' ic'. Y ri Elisabet nu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Cami ri Wajaf Dios nuya' ri ac'ual re' chue, chi quiri' manak chic xquiq'uix chiquiwech ri winak ri niquikasaj nuk'ij roma man jun wal. ");
INSERT INTO cakNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Y cuando ri Elisabet ruc'uan waki' ric' chi ne'c'ue' ral, ja' cuando ri Dios xutak ri ángel Gabriel pa jun tenemit ri c'o pa Galilea, rubinan Nazaret. ");
INSERT INTO cakNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ri ángel Gabriel xtak riq'uin jun xten María rubi'. Ri xten re', c'utun chic chi nic'ule' riq'uin jun ala' José rubi'. Y ri José re' ru-familia can ri rey David. ");
INSERT INTO cakNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ri ángel can xapon riq'uin ri xten, y xu'ij che: ¡Tiquicot awánima, roma ri Dios pa awi' ret xuya-wi ru-bendición! Ri Ajaf can c'o awiq'uin. Y chiquiwech conojel ixoki' ja ret ri más bendición xawil. ");
INSERT INTO cakNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Y cuando ri María xutzu' ri ángel y xuc'oxaj ri xu'ij che, can xsatz runo'j (xsach ruc'u'x) y xunojij-ka pa ránima anchique roma quiere' x-an saludar. ");
INSERT INTO cakNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Y ri ángel xu'ij che ri María: Man taxi'j-awi', roma ri Dios xatrucha' chi nuya' ru-bendición chawe. ");
INSERT INTO cakNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Cami nin-ij can chawe chi xcayawaj-ka roma xtalex jun awal, y cuando xtalex ri ne'y re', ala' y Jesús rubi' xta'an che. ");
INSERT INTO cakNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Raja' can c'o ruk'ij xtic'ue', y xtubinaj chuka' Ralc'ual ri nimalaj Dios. Ri Jesús jun ru-familia can ri rey David, y ri Ajaf Dios xtuch'ocoba' can ri Jesús pa ru-lugar ri rey David ri xc'ue' ojer can, ");
INSERT INTO cakNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","chi quiri' can xtu'on gobernar chi ronojel tiempo pa iwi' rix ri jix ru-familia can ri Jacob. Y ri ru-gobierno raja' can manak xtiq'uis, xcha' ri ángel che ri María. ");
INSERT INTO cakNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Y cuando ri María ruc'oxan chic ka ronojel re', xuc'utuj che ri ángel: ¿Anche'l c'a xtic'ue-ka wal? Roma ren xa c'a man jani jinc'o riq'uin ri xtoc wachijil, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Y ri ángel xu'ij che ri María: Ja ri Espíritu Santo riq'uin ri ruchuk'a' ri nimalaj Dios ri xtika-pe pa awi'. Romari' ri ac'ual ri xtalex awiq'uin, can jari' ri lok'olaj Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y tana'ej re': Ri Elisabet ri i-familia iwi' riq'uin ne'c'ue' jun ral, más que raja' can manak-wi yec'ue' ral, y chuka' xa can ri'j chic. Raja' ja yan waki' ric' benak chi ne'c'ue' ral. ");
INSERT INTO cakNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Roma ri Dios man jun anchique cuesta nu'on chech. ");
INSERT INTO cakNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Y ri María can ja' xu'ij: Jinc'o pa ruk'a' ri Ajaf. Can tibanataj c'a anche'l ri xa'ij chue, xcha' ri María che ri ángel. Y ri ángel xel-e chiri' riq'uin ri María, y xbe. ");
INSERT INTO cakNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jun jani' k'ij después, ri María xu'on-e ru'onic y ch'anin xbe pa jun tenemit ri c'o pa rui-juyu' chi ri Judea. ");
INSERT INTO cakNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Y cuando xapon chiri' pa tenemit, raja' xbe pa cocho ri Zacarías y ri Elisabet. Raja' xu'on saludar ri Elisabet. ");
INSERT INTO cakNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Cuando ri Elisabet xuc'oxaj ru-saludo ri María, can xsilon ri ral xuna' raja'. Y ri Elisabet can ja' xnoj ránima riq'uin ri Espíritu Santo, ");
INSERT INTO cakNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","romari' can riq'uin ruchuk'a' xch'o'n, y xu'ij: Chikacojol roj ixoki', ja ret ri más bendición xyo'x chawe, y quiri' chuka' ri bendición c'o pa ruwi' ri ne'y ri xtalex awiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Man nin-en ta entender, ¿jin anchique c'a ren, chi yinaben saludar ret ri jat rute' ri Wajaf? ");
INSERT INTO cakNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Y can xe xinc'oxaj chi xinaben saludar, ri wal can xsilon roma xquicot, xinna' ren. ");
INSERT INTO cakNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Can caquicot roma can xanimaj ri xu'ij ri Ajaf chawe; roma ri ac'ual ri xu'ij chawe chi xtalex awiq'uin, can xtalex na-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Y ri María xu'ij: Ren riq'uin ronojel wánima ninya' ruk'ij ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ri wánima niquicot riq'uin ri Dios ri yirucol. ");
INSERT INTO cakNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Roma ri Dios can xirucha' y ren can man jun wakalen, xe jin jun ralic rusamajel. Y desde cami, ri winak xtiqui'ij chi c'o ru-bendición ri Dios wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Roma q'uiy nimalaj tak ex ri rubanon-pe raja' chue, raja' ri can nitiquier-wi nu'on ronojel. Y ri rubi' raja' can lok'olaj-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Raja' can siempre nujoyowaj quiwech conojel winak ri yek'ax-e chech-ulef, ri yeniman che y chuka' can niquiya' ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Can q'uiy nimalaj tak ex jerubanon riq'uin ruchuk'a'. Raja' rukasan quik'ij ri niqui'ij pa tak cánima chi can c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Jerukasan nima'k tak gobernadores, y jerunimrisan ri xa juba' oc quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ri man jun quiway, can ruyo'n ronojel ri nic'atzin chique; pero ri beyoma' xe quiri' xetak-e. Can man jun xuya-e chique. ");
INSERT INTO cakNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Raja' jojruto'n roj israelitas ri can jojrucha'on-wi chi naka'an ri rusamaj. Man jojrumestan ta can y rujoyowan kawech. ");
INSERT INTO cakNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Can rujoyowan-wi kawech, anche'l ri ru'in can chique ri kati't-kamama' ojer can, ri ru'in can che ri Abraham y chake roj ri joj ru-familia can raja'. Ri Dios can man jun mej (bey) xtumestaj ri ru'in can. Quiri' xu'ij ri María. ");
INSERT INTO cakNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María xc'ue-ka jun la'k oxi' ic' riq'uin ri Elisabet, y c'ajari' xtzolaj chirocho. ");
INSERT INTO cakNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cuando xapon ri tiempo chi nalex ri ac'ual riq'uin ri Elisabet, ja xc'ue' jun ral ala'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y ri winak je ru-vecinos ri Elisabet y chuka' ri qui-familia qui' riq'uin, xquic'oxaj chi jun nimalaj favor ri xu'on ri Ajaf riq'uin roma xc'ue' jun ral. Y ri winak re' xe'apon riq'uin chi xqui'en visitar, y can xequicot riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Y reje' xe'apon chic riq'uin ri Elisabet cuando xtzakon wakxaki' k'ij talex ri ne'y, ri k'ij ri ni'an ri circuncisión che, anche'l nu'ij chupa ru-ley ri Moisés. Y ja chuka' k'ij ri' niyo'x rubi'. Y ri winak ri' xquijo' xqui'en ta che rubi' ri ne'y anche'l rubi' ri tata'j, y xubinaj ta chuka' Zacarías. ");
INSERT INTO cakNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero ri te'j xu'ij: Raja' manak xtuc'uaj rubi' ri rutata'; ri ne'y re' xtubinaj Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Y ri jec'o quiq'uin ri Elisabet xqui'ij che: ¿Anchique roma Juan najo' na'an che rubi'? Roma chupa ri a-familia man jun quiri' rubi'. ");
INSERT INTO cakNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Y che señas xquic'utuj che ri Zacarías, rutata' ri ne'y, chi anchique bi'aj nrojo' nuya' che ri ne'y. ");
INSERT INTO cakNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ri rutata' ri ne'y xuc'utuj jun ch'uti' tabla y xutz'ibaj chech: Ri ne'y Juan rubi'. Y conojel ri quimolon-apo-qui' xsatz quino'j (xsach quic'u'x), roma can anche'l ri bi'aj ri xu'ij ri te'j, can quiri' chuka' xutz'ibaj ri Zacarías chech ri tabla. ");
INSERT INTO cakNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Y can ja xtiquier xch'o'n chic pe jun mej (bey) ri Zacarías. Y raja' can xe xch'o'n, can ja' xuya' ruk'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y ri vecinos xquixi'j-qui' roma ri xbanataj chiri'. Y ri xbanataj, can nitzijos ri lugar ri', pa tak juyu' chi ri Judea. ");
INSERT INTO cakNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Y conojel winak ri yec'oxan ri xbanataj quiq'uin ri Zacarías y ri Elisabet, niquiyec-ka pa cánima ri nitzijos chique, y niqui'ij: ¿Anchique como xteru'ona' ri ac'ual re'? yecha'. Roma k'alaj chi can c'o-wi ri Ajaf Dios riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Y ri Zacarías, ri rutata' ri ne'y, nojinak ránima riq'uin ri Espíritu Santo xuk'alajij y xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Can xtiyo'x ruk'ij ri Ajaf Dios kachi roj ri aj-Israel, roma jojrunataj-pe roj ri joj rutenemit, y jojrucol. ");
INSERT INTO cakNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ri Dios nuya-pe chake Jun ri can c'o nimalaj ruchuk'a' chi jojrucol. Y re' jun ru-familia can ri David, ri jun ka-rey y rusamajel ri Dios xc'ue' ojer can. ");
INSERT INTO cakNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ri Dios x-in chique ri lok'olaj tak achi'a' ri xek'alajin rutzij ojer can, chi tiqui'ij chi xtuya' Jun ri xticolo kachi. ");
INSERT INTO cakNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Can ru'in-wi-pe chi xkojrucol chiquiwech ri itzel yetz'eto kachi, y xkojrucol pa quik'a' ri man jojquijo' ta, ");
INSERT INTO cakNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","y xtujoyowaj chuka' quiwech ri kati't-kamama' xec'ue' ojer can, can nu'on-wi ri xu'ij, cuando xu'on ri trato ri can c'o rakalen. ");
INSERT INTO cakNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Can xu'on-wi jurar che ri kamama' Abraham ");
INSERT INTO cakNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","chi can xkojrucol pa quik'a' ri itzel yetz'eto kachi, y quiri' can man xtakaxi'j ta ki' naka'an servir raja', ");
INSERT INTO cakNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","y riq'uin jun chojmilaj y utzilaj c'aslen chech raja', ronojel k'ij ri jojc'o we' chech-ulef, quiri' xtaka'an. ");
INSERT INTO cakNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Y ret ch'uti' walc'ual, xcha' ri Zacarías, can jat k'alajiy ri rutzij ri nimalaj Dios xcatuche'x, roma ja ret ri xca'in chique ri winak chi tiquichojmisaj ri quic'aslen, roma nakaj chic c'o-wi-pe ri Ajaf, ");
INSERT INTO cakNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","y ja ret ri xca'in chi ri Dios nucoch' (nucuy) quimac ri can je rutenemit, chi yecolotaj. ");
INSERT INTO cakNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Y ri', xe roma ri ka-Dios nujoyowaj kawech, riq'uin ronojel ránima jojrojo'. Romari' nutak-pe ri Jun ri noruya' sakil chake, ri can anche'l k'ij xtu'on chikacojol cuando xtika-pe chicaj. ");
INSERT INTO cakNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ri Jun ri noruya' sakil, xtuya' sakil chique ri jec'o pa k'eku'm y jec'o pa rumujal ri camic, y xkojruc'uaj chupa ri bey chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y ri ac'ual ri xalex quiq'uin ri Elisabet y ri Zacarías, xq'uiy-ka y quiri' chuka' pa ruc'aslen chech ri Dios. Y ja pa tz'iran rech-ulef xc'ue-wi, c'a xapon na ri k'ij chi xutzijoj rutzij ri Dios chiquiwech ri aj-Israel ri ruwinak. ");
INSERT INTO cakNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Y chupa ri k'ij ri', pa ru-tiempo ri Augusto César ri jun nimalaj achi nu'on gobernar, ja' cuando xtak rubixic chique conojel winak chi tiquitz'ibaj quibi'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Man jun mej (bey) banon quiri'. Pero cuando x-an quiri', ja gobernador ri jun achi rubinan Cirenio, chiri' pa rech-ulef Siria. ");
INSERT INTO cakNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Y ri winak jec'o pa Israel yebe na chi ne'quitz'ibaj quibi' pa tak quitenemit ri cati't-quimama'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Y chiri' pa Galilea c'o jun tenemit rubinan Nazaret. Y chiri' pa Nazaret c'o jun achi José rubi'. Y ri José re' xberutz'ibaj rubi' c'a Belén, ri jun tenemit c'o pa Judea, roma je aj-chiri' ri rati't-rumama'. Chiri' pa Belén xalex-wi ri rey David, y ri José, can ru-familia can ri rey David. ");
INSERT INTO cakNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ri José y María, ri xten ri ruc'utun, je ca'i' reje' xebe c'a Belén chi xbequitz'ibaj quibi'. Y ri María xa ya nalex ri ral. ");
INSERT INTO cakNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Y c'a chiri' pa tenemit Belén jec'o-wi cuando ri María xtzakon ruk'ij chi nic'ue' ral. ");
INSERT INTO cakNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Raja' xc'ue' jun ral ala'. Ri María can utz xubolkotij ri ne'y pa tziak, y xuliba' pa jun quiwaybal awaj. Pa cocho awaj xalex-wi ri na'ey ral ri María, roma nojinak chic ri posada. ");
INSERT INTO cakNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chunakaj ri Belén ri ak'a' ri', jec'o achi'a' ri yequichajij qui-ovejas pa k'ayis. ");
INSERT INTO cakNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","C'aja' xquitzu' xuc'ut-ri' jun ángel chiquiwech, ri ángel re' petenak chicaj riq'uin ri Ajaf. Y reje' yalan xquixi'j-qui' roma ri ángel, y roma chuka' ri rusakil ri Ajaf ri xsakrisan quichi. ");
INSERT INTO cakNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xu'ij chique: Man tixi'j-iwi', roma ren jec'o utzilaj tak tzij jenuc'amon-pe chiwe, y roma ri utzilaj tak tzij ri' can conojel winak ri jec'o chech-ulef xquiequicot. ");
INSERT INTO cakNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Tic'oxaj ri xtin-ij chiwe: Chiri' pa Belén, ri rutenemit can ri rey David, cami xalex ri Jun ri nicolo quichi ri winak, y ri' ja ri Cristo, ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri retal ri ne'y ri xtiwil, xtitzu' chi bolkotin pa tziak y cotz'oban pa jun quiwaybal awaj, xcha' ri ángel. ");
INSERT INTO cakNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Can ja' xeloka ch'aka chic ángeles ri je-petenak chicaj. Can je q'uiy. Y reje' niquiya' ruk'ij ri Dios, y niqui'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","¡Cami, chicaj can niyo'x ruk'ij ri Dios! ¡Y we' chech-ulef xoka yan ri uxlanen. Xoka yan chiquicojol ri winak, roma ri Dios yalan yerojo'! ");
INSERT INTO cakNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Y xe xqui'ij can quiri' ri ángeles, ja xebe chicaj. Y can xe xebe ri ángeles ri', ri achi'a' ri quichajin qui-ovejas can ja' xqui'ij-ka chiquiwech: Jo' ch'anin pa tenemit Belén. Jo', kabetz'eta' ri ac'ual ri xalex chiri'. Roma ri Ajaf can xutak-pe ri rutzijol chake. ");
INSERT INTO cakNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Y junanin xebe pa tenemit chi xbequitzu', y can xebequila' ri María, ri José y ri ac'ual cotz'oban pa jun quiwaybal awaj. ");
INSERT INTO cakNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ri achi'a' ri', can xe xquitzu' ri ac'ual, ja xquitzijoj-ka ri x-ix chique roma ri ángel, chirij ri jun ac'ual re'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y conojel ri yec'oxan, can xsatz quino'j (xsach quic'u'x) roma ri utzilaj tak tzij ri niquitzijoj. ");
INSERT INTO cakNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Y María can yeruyec pa ránima ronojel ri tzij ri', y nunojij chuka' chirij ri tzij ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Y ri achi'a' ri yechajin ovejas xetzolaj chic e. Pero reje' niquiya' ruk'ij ri Dios roma ronojel ri xquitzu' y xquic'oxaj. Can xbanataj-wi anche'l ri xu'ij can ri ángel. ");
INSERT INTO cakNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Can c'a man jani rutzijol chi nic'ue' ral ri María, cuando jun ángel xu'ij chi ri ac'ual ri xtralaj xtubinaj Jesús. Y can quiri' xubinaj can ri ne'y cuando c'aja' oc wakxaki' k'ij talex. Y ja k'ij ri' cuando x-an ri circuncisión che, anche'l ri nu'ij rutzij ri Dios chi ni'an na-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Y cuando xtzakon ri k'ij anche'l nu'ij ru-ley ri Moisés, chi ri ixoki' ri nic'ue' cal tiquijosk'ij-qui', ri María can quiri-wi xu'on. Y pa rocho ri Dios ri c'o pa Jerusalem xebe-wi. Ri José y María can xquic'uaj chuka' ri Jesús chi ne'quic'utu' pa rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Quiri' xqui'en roma ru-ley ri Ajaf Dios nu'ij: Ri na'ey ala' ri xtalex pa jun jay, ri' can richi ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ri José y María can xqui'en-wi anche'l nu'ij chupa ru-ley ri Ajaf Dios. Reje' xquiya' chech ri Dios ca'i' palomas, roma ri ley can nu'ij-wi: Ca'i' palomas je nim o ca'i' tak cocoj. ");
INSERT INTO cakNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Y chiri' pa tenemit Jerusalem ri tiempo ri' c'o jun achi rubinan Simeón. Ri jun achi re' can choj ruc'aslen y can nuya' ruk'ij ri Dios. Ri Simeón can c'o-wi ri Espíritu Santo riq'uin y ruyoben chuka' cuando xtipe ri Cristo chi nicolotaj raja' y chi yecolotaj ri ch'aka chic israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Y ri Espíritu Santo ruk'alajin chic che ri Simeón chi manak xticom, xa manak xtutzu' can rech ri Cristo, ri xtutak-pe ri Ajaf Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Y chupa ri k'ij cuando ri te'j-tata'j xquic'uaj ri ne'y pa rocho ri Dios chi niqui'en anche'l ri nu'ij ri ley, can ja k'ij ri' xapon ri Simeón pa rocho ri Dios, roma quiri' xrojo' ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ri Simeón xuk'etej ri ne'y, y chi xuya' ruk'ij ri Dios xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ajaf, cami xa can utz chic chi yicom-e, xa can c'o chic uxlanen pa wánima, roma can anche'l ri a'in chue, can quiri' xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ri nuech xquitzu' yan can ri nicolo kachi, ri petenak awiq'uin ret, ");
INSERT INTO cakNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri xatak-pe ret quichi conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ja raja' chuka' ri Sakil quichi ri winak ri man je israelitas ta, roma ja raja' ri xtik'alajin ri abey ret chiquiwech. Y roj ri atenemit Israel can xtic'ue' kak'ij, roma can chikacojol xalex-wi ri nicolo quichi ri winak, xcha' ri Simeón. ");
INSERT INTO cakNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ri José y María ri te'j, can anchique la c'a xquic'oxaj ri xu'ij ri Simeón chirij ri ne'y. ");
INSERT INTO cakNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Y c'ajari' ri Simeón xu'on jun oración pa quiwi' ri José y ri María, chi quiri' ja' ta ri Dios ri xtibano bendecir quichi. Cuando rubanon chic ka orar ri Simeón, xu'ij che ri María, ri rute' ri ne'y: Tac'oxaj na pe', ri ne'y re' nim ri samaj yo'n-pe che roma ri Dios. Y roma raja', je q'uiy chique ri kawinak israelitas xquiecolotaj. Y je q'uiy chuka' ri xquietzak, roma can itzel xtiquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Can roma raja' xte'k'alajin-pe ronojel ri jec'o pa tak cánima ri winak, ri utz y ri man je utz ta. Y ri Simeón xu'ij chuka' che ri María: Roma ri xti'an che ri Jesús, c'o ruquiy (k'axon) xtana' ret; can anche'l jun espada ri xtusoc ri awánima, xcha' ri Simeón. ");
INSERT INTO cakNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiri' pa rocho ri Dios c'o chuka' jun ixok rubinan Ana. Raja' can nuk'alajij ri ni'ix che roma ri Dios. Raja' rumi'al can jun achi rubinan Fanuel, y ru-familia can ri Aser, ri jun achi xc'ue' ojer can. Ri Ana re' can ri'j chic. Raja' c'a co'l cuando xc'ule'. Y xe wuku' juna' xquic'uaj-qui' riq'uin ri rachijil, roma xa ch'anin xcom-e ri achi chech. ");
INSERT INTO cakNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Y raja' man xc'ule' ta chic jun mej (bey). C'o yan ochenta y cuatro rujuna', y can c'o pa rocho ri Dios k'ij-k'ij. Raja' can nu'on ayuno y oración chi nuya' ruk'ij ri Dios, quiri' nu'on pak'ij chi chak'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Cuando ri Ana xutzu' ri ne'y, xbe-apo riq'uin. Y can xuya' matiox che ri Dios roma ri ne'y ri'. Y xutz'om rutzijoxic chique ri winak aj-Jerusalem ri can quiyoben chi yecol, chi ja xoka ri Jun ri xticolo quichi. ");
INSERT INTO cakNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ri José y María xqui'en ronojel ri nu'ij ri Ajaf Dios chupa ri ru-ley, ri can nic'atzin niqui'en cuando c'o yan jun jani' k'ij talex jun ac'ual. C'ajari' xetzolaj pa cocho pa Nazaret. Ri tenemit re' c'a pa Galilea c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ac'ual niq'uiy y nic'ue-ka ruchuk'a' benak. Raja' can niq'uiyer runo'j (runa'oj), y c'o ru-bendición ri Dios pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ri María y José, rute-rutata' ri Jesús, can juna-juna' yebe pa tenemit Jerusalem cuando napon ri k'ij chi ri nimak'ej ri ni'ix pascua che. ");
INSERT INTO cakNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Quiri' chuka' xqui'en cuando ri Jesús cablajuj rujuna' y xapon chic jun mej (bey) ri nimak'ej ri'. Reje' xebe c'a pa tenemit Jerusalem roma can quiri-wi niqui'en ri quiwinak israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Y cuando xk'ax yan ri nimak'ej pascua, María y José xetzolaj chicocho. Pero reje' man quieta'n ta chi ri Jesús xa xc'ue' can chiri' pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ri José y María can xquinojij chi ri ac'ual can benak-wi chiquicojol ri winak, y quiri' xebin jun k'ij. Pero cuando xquina'ej chi xa man benak ta, ja xquic'utula' chique ri qui-familiares y chuka' chique ri quieta'n quiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Y roma man xquiwil ta, ri José y María xetzolaj chi niquicanoj ri ac'ual c'a pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","C'o yan oxi' k'ij tisatz (tisach) ri ac'ual, c'ajari' xquiwil. Reje' xquiwil ri ac'ual pa rocho ri Dios ri c'o pa Jerusalem. Ri ac'ual ch'ocol-apo quiq'uin ri achi'a' maestros chi ri ley, nuc'oxaj ri niqui'ij y c'o chuka' ri nuc'utuj-apo raja' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y conojel ri niquic'oxaj ri nu'ij ri ac'ual nisatz quino'j (nisach quic'u'x), roma ri nic'utux che coma ri maestros, ri ac'ual can nitiquier-wi nu'ij-apo chique. Can k'alaj-wi chi raja' ronojel nu'on entender y can c'o runo'j (runa'oj). ");
INSERT INTO cakNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Chiri' pa rocho ri Dios c'o-wi ri Jesús cuando ri María y José xbequila'. Reje' can anchique la xquina'. Y ri te'j xu'ij che ri ral: ¿Anchique xa'an? ¿Anchique roma xac'ue' can y man xa'ij ta chake? Tatzu'; la atata' y ren can jatkacanoj. Y can jojbison yan roma manak jatkawil. ");
INSERT INTO cakNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Y raja' xu'ij chique: ¿Anchique roma yinicanoj? ¿Man iweta'n ta c'a chi ren ja ri nrojo' ri Nata' Dios jari' ri nin-en? ");
INSERT INTO cakNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Y ri tzij ri xu'ij ri ac'ual chique ri José y María man xqui'en ta entender. ");
INSERT INTO cakNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","C'ajari' ri ac'ual junan xtzolaj quiq'uin c'a chicocho, pa tenemit Nazaret. Ri ac'ual can nunimaj quitzij. Y ronojel ri xbanataj pa Jerusalem riq'uin ri ac'ual, ri María xeruyec pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y ri Jesús niq'uiy benak y can quiri' chuka' ri runo'j (runa'oj). Raja' can nika chech ri Dios, y can nika chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","C'o yan quince juna' toc-pe rey ri achi rubinan Tiberio César. Y pa ruk'a' raja' xec'ue-wi ri quieji' gobernadores. Jun ja ri Poncio Pilato, y raja' nu'on gobernar pa Judea. Ri jun chic, ja ri Herodes y raja' nu'on gobernar pa Galilea. Ri rox, ja ri Felipe ri rach'alal ri Herodes, y raja' nu'on gobernar pa Iturea y Traconite. Y ri rucaj ja ri Lisanias, y raja' nu'on gobernar pa Abilinia. ");
INSERT INTO cakNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Y can ja chuka' chupa ri tiempo ri' cuando ri Anás y ri Caifás je nimalaj tak sacerdotes ri más c'o quik'ij, chiri' pa Israel. Ronojel re' nunataj chake cuando ri Dios xch'o'n che ri Juan ri ralc'ual ri Zacarías. Y pa tz'iran rech-ulef xch'o'n-wi ri Dios che ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Y ri Juan xe chuchi' ri rakan-ya' Jordán xutz'om-e bey, y xbe. Raja' nu'ij chique ri winak ri ye'apon riq'uin chi tiquiya' can quimac y tiquibana' ri nrojo' ri Dios y tiquibana' bautizar qui', chi quiri' ri Dios nucoch' (nucuy) quimac. ");
INSERT INTO cakNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Y can riq'uin ri Juan xbanataj-wi ri ru'in can ri Dios che ri jun rusamajel ri xc'ue' ojer can. Ri samajel re' Isaías rubi'. Ri rutz'iban can raja' nu'ij: C'o jun achi ri xtic'ue' pa tz'iran rech-ulef, y ja raja' ri xtitzijon rutzij ri Dios chiquiwech ri winak ri xquie'apon riq'uin. Y xtu'ij chique: Tichojmisaj ri ic'aslen, roma nakaj chic c'o-wi-pe ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Can nic'atzin chi yenojises ri siwan. Y chuka' yewulix ri juyu'. Ri xotoxak tak bey, can choj ti'an chique. Y ri cujquic tak bey, lik' chuka' ti'an chique. ");
INSERT INTO cakNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conojel winak xtiquitzu' ri nu'on ri Dios chi jojrucol, nicha' chupa ri rutz'iban can ri Isaías. ");
INSERT INTO cakNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Y cuando ye'apon ri winak riq'uin ri Juan chi ye'an-e bautizar, raja' nu'ij chique: Jix anche'l itzel tak cumetz, roma ninojij chi xe riq'uin ri bautismo jixcolotaj chech ri castigo ri xtutak-pe ri Dios chakawech apo. ¿Ancu'x (Anchique) x-in chiwe chi quiere' niben? ");
INSERT INTO cakNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Rix nic'atzin nic'ut chi can ketzij niya' can ri imac y niben ri nrojo' ri Dios. Y man ti'ij rix chi can xe roma jix ru-familia can ri Abraham, can romari' jixcolotaj, man quiri' ta. Roma xa ta ri Dios nrojo' yeru'on ru-familia ri Abraham chique ri abaj ri ye'itzu' we', nitiquier nu'on. ");
INSERT INTO cakNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ri castigo ri nuya' ri Dios nipe yan. Raja' xtu'on anche'l nu'on jun achi ri c'o chic ri iquiaj pa ruk'a' chi yerukasaj ri che' ri xa man utz ta quiwech niquiya'. Y conojel ri che' ri xquierukasaj, xquieruya' pa k'ak', xcha' ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Y ri winak xquic'utuj che ri Juan: ¿Anchique nic'atzin naka'an cami? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y Juan xu'ij chique ri xec'utun-apo: Xa c'o jun chiwe rix c'o ca'i' rutziak, tuya' jun che ri manak rutziak. Y xabachique (xama'anchique) chuka' chiwe rix c'o ruway, tuya' chuka' che ri man jun ruway, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Y chiri' riq'uin ri Juan, jec'o-apo chuka' jujun achi'a' ri je moloy-impuesto. Ri achi'a' re' xe'apon chi ye'an bautizar. Y chuka' ri achi'a' re' xquic'utuj che ri Juan: Maestro, xecha' che. Y roj ¿anchique nic'atzin naka'an? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y Juan xu'ij chique: Xe ri impuesto ri ru'in ri gobierno, can xe ri' tic'utuj chique ri winak. Man tic'utuj más. ");
INSERT INTO cakNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Y chuka' jujun soldados xquic'utuj-apo che: Y roj ¿anchique nic'atzin naka'an? xecha'. Ri Juan xu'ij chique: Man timaj ri ex quichi ri winak, xe roma c'o uchuk'a' pa ik'a'. Man jun anchique quie'ik'abaj chiquij winak. Y can quixquicot riq'uin ri nich'ec, xcha' ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Y ri winak ri jec'o-apo riq'uin ri Juan, can quiyoben chi raja' c'o ta anchique ri nu'ij, roma reje' niqui'ij pa tak cánima chi ja ri Juan jari' ri Cristo ri takon-pe roma ri Dios, pero xa man ja' ta raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Romari' ri Juan xu'ij chique ri winak ri jec'o-apo riq'uin: Rix nitzu' chi ren jixinben bautizar che ya'. Pero c'o c'a Jun ri xtipe chuij ren, ri xquixru'on bautizar riq'uin ri Espíritu Santo y che k'ak'. Ri Jun ri xtipe, yalan nim ruk'ij y nim ruchuk'a'. Can man anche'l ta oc ren. Romari' can man nuc'ul ta chi ja ren yisolo ri ruximbel ruxajab, roma raja' nim ruk'ij y nim ruchuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Raja' can xtu'on anche'l nu'on jun achi cuando nujosk'ij ru-trigo anchi' nuch'ey-wi. Raja' nic'atzin jun ruche' ri c'o ca'i-oxi' rutza'n, chi quiri' nuq'uiak chech quiek'ik' ri trigo ri ch'ayon chic. Ri trigo nic'ue' can, pero ri ruk'ayisal nuc'uaj-e quiek'ik'. Y ja ri trigo, jari' ri nuyec, y ri ruk'ayisal nuporoj. Can quiri' xtu'on ri Jun ri xtipe, raja' c'o chic uchuk'a' pa ruk'a' chi yeru'on juzgar ri winak. Ri yeniman, xquieruc'uaj chicaj. Pero ri man yeniman ta, xquierutak chupa ri k'ak' ri manak xtichup. ");
INSERT INTO cakNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Q'uiy tzij anche'l re' xerucusaj ri Juan chi xutzijoj ri utzilaj rutzij ri Dios chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ri Juan xuch'olij ri rey Herodes, roma man utz ta ri rubanon, chi quic'uan-qui' riq'uin ri Herodías; y ri ixok ri' xa raxayil ri Felipe rach'alal ri Herodes. Jari' ri xu'ij ri Juan che ri Herodes, y xerunataj chuka' ch'aka chic rumac ri jerubanon. ");
INSERT INTO cakNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Y ri Herodes man xka ta chech ri x-ix che, can xnimer-ka más rumac, roma xutz'apij ri Juan pa cárcel. ");
INSERT INTO cakNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Y cuando najin ri bautismo chique ri winak, x-an chuka' bautizar ri Jesús. Y cuando ri Jesús nu'on orar, ja' xjakataj ri rocaj. ");
INSERT INTO cakNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Y ri Espíritu Santo can xtz'et chi xka-pe pa ruwi' ri Jesús, can anche'l jun paloma. Y ri Dios xch'o'n-pe chicaj y xu'ij: Ja ret jat Walc'ual, yalan jatinjo', y niquicot wánima awiq'uin, xcha-pe ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Cuando ri Jesús xutz'om ri rusamaj, c'o la'k jun treinta rujuna'. Y chiquiwech ri winak, ri Jesús ralc'ual ri José. Ri José ralc'ual can ri Elí. ");
INSERT INTO cakNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Y ri Elí re', ralc'ual can ri Matat, y ri Matat ralc'ual can ri Leví, y ri Leví ralc'ual can ri Melqui, y ri Melqui ralc'ual can ri Jana, y ri Jana ralc'ual can jun chic achi ri José chuka' rubi'. ");
INSERT INTO cakNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Y ri José re', ralc'ual can ri Matatías, y ri Matatías ralc'ual can ri Amós, y ri Amós ralc'ual can ri Nahum, y ri Nahum ralc'ual can ri Esli, y ri Esli ralc'ual can ri Nagai. ");
INSERT INTO cakNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Y ri Nagai re', ralc'ual can ri Maat, y ri Maat ralc'ual can ri Matatías, y ri Matatías re', ralc'ual can ri Semei, y ri Semei ralc'ual can ri José, y ri José re', ralc'ual can ri Judá. ");
INSERT INTO cakNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Y ri Judá re', ralc'ual can ri Joana, y ri Joana ralc'ual can ri Resa, y ri Resa ralc'ual can ri Zorobabel, y ri Zorobabel ralc'ual can ri Salatiel, y ri Salatiel ralc'ual can ri Neri. ");
INSERT INTO cakNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Y ri Neri re', ralc'ual can ri Melqui, y ri Melqui ralc'ual can ri Adi, y ri Adi ralc'ual can ri Cosam, y ri Cosam ralc'ual can ri Elmodam, y ri Elmodam ralc'ual can ri Er. ");
INSERT INTO cakNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Y ri Er re', ralc'ual can ri Josué, y ri Josué ralc'ual can ri Eliezer, y ri Eliezer ralc'ual can ri Jorim, y ri Jorim ralc'ual can ri Matat. ");
INSERT INTO cakNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Y ri Matat re', ralc'ual can ri Leví, y ri Leví ralc'ual can ri Simeón, y ri Simeón ralc'ual can ri Judá, y ri Judá ralc'ual can ri José, y ri José ralc'ual can ri Jonán, y ri Jonán ralc'ual can ri Eliaquim. ");
INSERT INTO cakNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Y ri Eliaquim re', ralc'ual can ri Melea, y ri Melea ralc'ual can ri Mainán, y ri Mainán ralc'ual can ri Matata, y ri Matata ralc'ual can ri Natán. ");
INSERT INTO cakNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Y ri Natán re', ralc'ual can ri David, y ri David ralc'ual can ri Isaí, y ri Isaí ralc'ual can ri Obed, y ri Obed ralc'ual can ri Booz, y ri Booz ralc'ual can ri Salmón, y ri Salmón ralc'ual can ri Naasón. ");
INSERT INTO cakNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Y ri Naasón re', ralc'ual can ri Aminadab, y ri Aminadab ralc'ual can ri Aram, y ri Aram ralc'ual can ri Esrom, y ri Esrom ralc'ual can ri Fares, y ri Fares ralc'ual can ri Judá. ");
INSERT INTO cakNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Y ri Judá re', ralc'ual can ri Jacob, y ri Jacob ralc'ual can ri Isaac, y ri Isaac ralc'ual can ri Abraham, y ri Abraham ralc'ual can ri Taré, y ri Taré ralc'ual can ri Nacor. ");
INSERT INTO cakNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Y ri Nacor re', ralc'ual can ri Serug, y ri Serug ralc'ual can ri Ragau, y ri Ragau ralc'ual can ri Peleg, y ri Peleg ralc'ual can ri Heber, y ri Heber ralc'ual can ri Sala. ");
INSERT INTO cakNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Y ri Sala re', ralc'ual can ri Cainán, y ri Cainán ralc'ual can ri Arfaxad, y ri Arfaxad ralc'ual can ri Sem, y ri Sem ralc'ual can ri Noé, y ri Noé ralc'ual can ri Lamec. ");
INSERT INTO cakNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Y ri Lamec re', ralc'ual can ri Matusalén, y ri Matusalén ralc'ual can ri Enoc, y ri Enoc ralc'ual can ri Jared, y ri Jared ralc'ual can ri Mahalaleel, y ri Mahalaleel ralc'ual can ri Cainán. ");
INSERT INTO cakNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Y ri Cainán re', ralc'ual can ri Enós, y ri Enós ralc'ual can ri Set, y ri Set ralc'ual can ri Adán, y ri Adán ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ri k'ij cuando x-an bautizar ri Jesús, raja' nojinak ránima riq'uin ri Espíritu Santo xtzolaj-pe pa rakan-ya' Jordán. Y ri Espíritu Santo xu'on che ri Jesús chi xbe pa tz'iran rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Y chiri' xc'ue-wi cuarenta k'ij. Y ri itzel can nutaj ruk'ij chirij chi nika pa ruk'a'. Y chupa ri jani' k'ij ri xc'ue' ri Jesús chupa ri lugar ri', manak xwa', y cuando xek'ax ri k'ij ri' xnum-pe rupa. ");
INSERT INTO cakNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Y can ja' c'o-apo ri itzel y xu'ij che ri Jesús: Xa can ketzij chi ret jat Ralc'ual ri Dios, tabana' chique ri abaj re' chi quie'oc pan. ");
INSERT INTO cakNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Pero ri Jesús xu'ij che: Tz'iban can chupa rutzij ri Dios, chi ri achi nril chuka' ruc'aslen riq'uin rutzij ri Dios y man xe ta riq'uin ri pan. ");
INSERT INTO cakNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Y ri itzel can ja' xuc'uaj ri Jesús parui' jun nimalaj juyu', y xuc'ut ronojel naciones richi ri rech-ulef chech ri Jesús, pa jun rato. ");
INSERT INTO cakNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Y c'ajari' ri itzel xu'ij che ri Jesús: Ren ninjach pa ak'a' conojel ri tenemit re', ri yalan c'o quik'ij, chi na'an gobernar pa quiwi', roma pa nuk'a' ren je-jachon-wi can, y ren yitiquier ninya' ronojel re' che ri anchok che ninjo' ninya-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Y xa ret jaxuquie' chinuech y naya' nuk'ij, ronojel re' xtoc awichi, xcha' ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Pero ri Jesús xu'ij che: Quinaya' can, y man quinanak chic ret Satanás. Roma chupa rutzij ri Dios ri tz'iban can, nu'ij: Xe ri Kajaf Dios kaya' ruk'ij, y xe chuka' raja' kabana' rusamaj, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Y ri itzel can ja' xuc'uaj chuka' ri Jesús pa Jerusalem, y can ja ri c'a chicaj e che ri rocho ri Dios xberuya-wi. Y cuando jec'o chic chiri', ri itzel xu'ij che ri Jesús: Tatorij-ka-awi' we', ret ri ja'in chi jat Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Roma chupa rutzij ri Dios tz'iban can, nu'ij: Ri Dios xquierutak ri ru-ángeles, chi jatquichajij. ");
INSERT INTO cakNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Y xcatquili'ej pa quik'a', chi quiri' man xtacajij ta awakan chech abaj. ");
INSERT INTO cakNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Pero ri Jesús xu'ij che ri itzel: Ren can man nin-en ta ri narayij ret y nintojtobej ta ri Dios. Roma rutzij ri Dios nu'ij chi can man utz ta nakatojtobej ri Kajaf Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Y ri itzel man xril ta chic anchique nu'on che ri Jesús, chi nu'on ta rumac, xuya' can jun jani' k'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Y Jesús xtzolaj pa rech-ulef Galilea, y nojinak ránima riq'uin ri ruchuk'a' ri Espíritu Santo. Y pa conojel tenemit ri jec'o-pe chunakaj ri Galilea, xapon-wi rutzijol ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Y raja' nuc'ut rutzij ri Dios pa tak sinagogas, ri jay anchi' niquimol-wi-qui' ri winak chi niquic'oxaj rutzij ri Dios, pa tak tenemit anchi' napon-wi. Y ri winak ri yec'oxan ri nu'ij, can niquiya' ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ri Jesús xbe pa Nazaret, ri tenemit anchi' xq'uiy-wi. Y chupa ri k'ij chi uxlanen, raja' xbe chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, can anche'l-wi tu'on. Y cuando c'o chic chiri', raja' xpa'e' chi xu'on leer rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y ja ri libro ri rutz'iban can ri Isaías, ri jun ri xk'alajin rutzij ri Dios ojer can, jari' ri xyo'x pa ruk'a' ri Jesús chi xu'on leer chiquiwech ri winak ri quimolon-qui' chiri'. Y cuando ri Jesús xujak ri libro ri', xril ri anchi' nu'ij-wi: ");
INSERT INTO cakNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ru-Espíritu ri Ajaf Dios c'o wiq'uin ren, roma can xirucha-wi-pe chi nin-ij ri utzilaj rutzij ri Dios chique ri c'o necesidad pa cánima chech ri Dios. Xirutak-pe chuka' chi yenk'omaj winak ri c'o ruquiy (nik'axon) cánima pa ruk'a' ri mac. Xirutak-pe ri Dios chi nin-ij chique ri winak ri je-tz'apel pa ruk'a' ri mac, chi yetiquier yecolotaj pa ruk'a'. Xitak-pe chuka' chi nin-en chique ri winak je anche'l moy, chi yetzu'n. Y ri Dios xirutak-pe chuka' chi yencol ri winak ri niqui'en sufrir. ");
INSERT INTO cakNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Y xirutak-pe chuka' chi nin-ij chique ri winak chi ja tiempo re' cuando ri Ajaf Dios nuya-pe ru-bendición roma yerucol ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Y ri Jesús xutz'apij ri libro ri xu'on leer chiquiwech ri winak ri jec'o chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. C'ajari' xuya' can che jun ri nisamaj chiri', y xbech'oquie-pe chi nich'o'n. Y ri winak xe niquitzu' rech. ");
INSERT INTO cakNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Y raja' xch'o'n y xu'ij: Chiwech rix cami, nibanataj-wi ri ru'in can ri Dios chupa ri libro ri tz'iban can chake, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Y conojel ri winak ri quimolon-qui' chiri', can xka chiquiwech ri Jesús. Y ri utzilaj tak tzij ri xeru'ij ri Jesús chique, can anchique la xquic'oxaj, roma man jun mej (bey) jequic'oxan ta tzij anche'l ri xeru'ij raja' chique. Y ri winak ri' niqui'ij chuka' chiquiwech: ¿Man ja' ta como re' ralc'ual ri José? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xu'ij chique: Ren can weta'n ri ninojij chuij: Xa ri Jesús re' can nitiquier-wi yeru'on milagros, man quieru'on xe pa Capernaum, quieru'ona' chuka' we' pa rutenemit. ");
INSERT INTO cakNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xu'ij chuka' chique ri quimolon-qui' chiri': Jun ri nuk'alajij ri ni'ix che roma ri Dios, man ninimex ta cuando napon pa rutenemit. ");
INSERT INTO cakNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Y ren nin-ij chi rix iweta'n ri xbanataj cuando man xu'on ta job oxi' juna' y nic'aj, pa ru-tiempo ri jun achi ri xuk'alajij rutzij ri Dios ojer can, ri xubinaj Elías. Can ketzij-wi chi can je q'uiy ixoki' je malca'n we' pa Israel ri tiempo ri', cuando ri winak pa ka-nación xquik'axaj jun nim wayjal. ");
INSERT INTO cakNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero ri Dios man xutak ta ri Elías chi xuto' jun malca'n-ixok we' pa Israel. Raja' xutak-e ri Elías riq'uin jun malca'n-ixok c'a pa jun tenemit rubinan Sarepta. Y ri tenemit Sarepta re', c'a chunakaj ri tenemit Sidón c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Y can quiri' chuka' xbanataj quiq'uin ri yawa'i' pa ru-tiempo ri Eliseo, ri xk'alajin rutzij ri Dios ojer can. Pa ru-tiempo ri Eliseo, chiri' pa Israel can je q'uiy ri je yawa'i' riq'uin ri jun yabil rubinan lepra. Pero ri Dios man xrojo' ta chuka' chi c'o ta chic jun xc'achojrises chique roma ri yabil ri', xe ri Naamán ri xrojo' chi xc'achojrises, y raja' jun achi aj-Siria. ");
INSERT INTO cakNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Y cuando ri winak ri quimolon-qui' chiri' pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, xquic'oxaj ri xu'ij ri Jesús chique, xcataj quiyowal roma ri xeto'x xa man je israelitas ta. ");
INSERT INTO cakNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Y xebecataj-pe, chi xquilesaj-e chuchi' ri tenemit. Ri jun tenemit re' chech jun juyu' c'o-wi. Romari' ri winak xquic'uaj ri Jesús c'a parui' ri juyu' chi ne'quitorij-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero ri Jesús choj xk'ax-pe chiquicojol ri winak y xbe. ");
INSERT INTO cakNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","C'ajari' ri Jesús xbe pa tenemit Capernaum, ri jun chic tenemit ri c'o pa Galilea. Y chiri' c'o-wi cuando xoka ri k'ij chi uxlanen. Y romari' raja' nutzijoj rutzij ri Dios chique ri winak ri quimolon-qui' chiri' pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y conojel ri winak ri quimolon-qui', can xsatz quino'j (xsach quic'u'x) cuando xquic'oxaj ri tzij ri xeru'ij ri Jesús chique chi yerutijoj; roma cuando yerutijoj, can nik'alajin chi can c'o uchuk'a' pa ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Y chiri' pa sinagoga, chiquicojol ri winak c'o-apo jun achi ri c'o jun itzel espíritu riq'uin. Y ri itzel espíritu ri c'o riq'uin ri achi, can xsiq'uin xch'o'n. ");
INSERT INTO cakNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Ri espíritu ri' xu'ij che ri Jesús: ¿Anchique najo' chake roj, Jesús aj-Nazaret? ¿Xape chi jojaq'uis? Ren weta'n jat ancu'x (anchique) ret y romari' weta'n chi can ja ret ri lok'olaj Ralc'ual ri Dios y jat-petenak riq'uin raja', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Pero ri Jesús xu'ij che ri itzel espíritu: Cachojochi'. Catel-e. Y ri itzel espíritu ri' xutzak ri achi pa ulef chiri' chiquicojol ri winak ri quimolon-qui'. Y ri itzel espíritu xel-e riq'uin ri achi, y man jun chic más anchique xu'on can che. ");
INSERT INTO cakNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y ri winak ri quimolon-qui' chiri', xsatz quino'j (xsach quic'u'x) cuando xquitzu' ri xu'on ri Jesús, y niqui'ij chiquiwech: ¡Jani' ruchuk'a' rutzij ri achi re'! Roma can c'o ruchuk'a' ri rutzij, y can c'o uchuk'a' pa ruk'a'. Ri itzel tak espíritus can yeniman che y ye'el, yecha' ri winak chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Y ch'anin xbin rutzijol ri Jesús, y romari' ri winak ri jec'o pa tak tenemit chunakaj ri Capernaum, xquic'oxaj chuka' ri yeru'on ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Y chupa ri mismo k'ij ri', ri Jesús xel-pe chiri' pa sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, y xbe pa rocho ri Simón. Y chupa ri k'ij ri' ri rujite' ri Simón niyawaj riq'uin jun nimalaj c'aten. Y ri jec'o chiri' pa jay xquic'utuj favor che ri Jesús pa ruwi' ri yawa'. ");
INSERT INTO cakNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Y raja' xluquie-ka riq'uin ri yawa' y xu'ij chi tiq'uis-e ri c'aten chirij. Y can xe xu'ij quiri' ri Jesús, can ja' xq'uis-e ri c'aten chirij. Ri ixok ri' can ja' xcataj y xerutzuk ri Jesús y ri je-benak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Cuando xka yan ka ri k'ij chupa ri jun k'ij ri', conojel ri winak chi ri tenemit, ri jec'o yawa'i' quiq'uin, xequic'uaj-apo chech ri Jesús. Ri yawa'i' ri', jalajoj rech yabil ntoc chique. Y ri Jesús xuya' ruk'a' pa quiwi' chiquijunal ri yawa'i' y xec'achoj roma. ");
INSERT INTO cakNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Je q'uiy chique ri yawa'i' re' xa man ralic ta yabil ntoc chique. Xa itzel tak espíritus jec'o quiq'uin. Pero ri Jesús xerulesaj-e chuka'. Y cuando ri itzel tak espíritus ye'el-e quiq'uin ri yawa'i' re', can yesiq'uin yech'o'n y niqui'ij: Ja ret ri Ralc'ual ri Dios. Y ri Jesús yeruk'at riq'uin rutzij y man nuya' ta lugar chique chi yech'o'n más. Roma ri itzel tak espíritus re' can quieta'n chi ri Jesús jari' ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Y cuando xsakar-pe ruca'n k'ij, ri Jesús xel-e juba' pa tenemit. Raja' xbe pa tz'iran rech-ulef. Pero ri winak xbequicanoj ri Jesús, y xbequila-pe. Ri winak re' man niquijo' ta chi nibe ri Jesús, reje' can niquik'at chi nic'ue-ka quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero ri Jesús xu'ij chique: Ren yibe na pa ch'aka chic tenemit, chi nentzijoj ri utzilaj rutzij ri Dios ri nich'o'n chirij ru-gobierno ri Dios, can romari' xitak-pe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Y can quiri' xu'on pa Galilea, raja' can nutzijoj rutzij ri Dios pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Y jun k'ij, cuando ri Jesús c'o chiri' chuchi' ri choy (ya') rubinan Genesaret, q'uiy winak xe'apon riq'uin, roma niquijo' niquic'oxaj rutzij ri Dios. Y ri winak re' can je q'uiy-wi, romari' niquipitz' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Pero raja' ch'anin xerutzu-apo ca'i' canoas jec'o can chuchi-ya', y man jun winak jec'o chupa ri canoas ri', roma ri cajaf ri canoas je elesey-quer pa ya', y ri hora ri' niquich'aj quiya'l anchok che yequilesaj quer pa ya'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Y jun chique ri canoas re' richi ri Simón. Y chupa ri ru-canoa ri Simón xoc-wi ri Jesús. Y raja' xu'ij che ri Simón chi quie'oc-apo juba' parui' ri ya'. Y raja' xch'oquie-ka chiri' pa canoa, y ja' xerutijoj-pe ri winak riq'uin ri rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cuando ri Jesús xtane' nich'o'n chique ri winak re', raja' xu'ij che ri Simón: Jo-apo anchi' nim rupa ri ya', y tiya-ka ri iya'l anchok che ye'ilesaj-wi quer pa ya'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Pero ri Simón xu'ij che ri Jesús: Maestro, xcha' che. Roj jun ak'a' xojc'ase' chi xekacanoj quer, y man jun xkawil. Pero roma ja ret ja'in chi kaya-ka ri ya'l pa ya', nakaya-ka c'a. ");
INSERT INTO cakNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Y cuando xquiq'uiak ri ya'l chi yequilesaj quer pa ya', can jec'o ri xquiya-qui'. Can q'uiy quer xe'oc chupa ri ya'l, y romari' ri ya'l can ja' nik'ach'itaj benak roma calal ri quer. ");
INSERT INTO cakNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Romari' ri achi'a' re' xqui'en-apo señas chique ri caxbil ri jec'o pa jun chic canoa, chi quie'oto'n. Y ri ch'aka chic can xepe-wi chi xeto'n. Y ri ca'i' canoas xequinojisaj riq'uin ri quer. Romari' ri canoas can ya yebe chuxe' ya' roma calal ri quer. ");
INSERT INTO cakNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Y cuando ri Simón ri ni'ix chuka' Pedro che, xutzu' chi jun milagro ri xbanataj quiq'uin ri quer, raja' xbexuquie' chech ri Jesús, y xu'ij che: Ajaf, ren xa jin jun achi aj-mac, man utz ta chi jac'ue-pe wiq'uin, roma ret can nim-wi ak'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Quiere' xu'ij ri Simón roma raja' man jun mej (bey) rutz'eton chi quiere' nibanataj. Y can quiri' chuka' xquina' conojel ri je-benak riq'uin. Reje' can anchique la xquina' cuando xquitzu' chi can q'uiy quer xquiya-pe-qui' ri k'ij ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Y chuka' ri Jacobo y ri Juan, ri jec'o riq'uin ri Simón, ri je ralc'ual ri jun achi rubinan Zebedeo, can anchique la xquina' cuando xquitzu' ri xbanataj. Romari' ri Jesús xu'ij che ri Simón: Man tisatz ano'j (tisach ac'u'x) roma ri xatzu'. Ri rubanon-pe jat jun achi elesey-quer pa ya', pero ri tiempo chakawech apo, xtatemaj chuka' anchique modo ye'ach'ec winak riq'uin ri nutzij, chi quiri' jinquitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Y ri achi'a' re' xequic'om-pe qui-canoas c'a chuchi-ya'. Y reje' xquiya' can ri quisamaj y xquitzeklebej-e ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Y cuando ri Jesús xapon pa jun tenemit, xapon jun achi riq'uin, ri achi ri' niyawaj riq'uin ri jun yabil rubinan lepra. Ri achi, can xe xutzu' ri Jesús, xbexuquie' chech y xulucuba-ka ri rujolon c'a pa ulef y xu'ij che: Ajaf, ren weta'n chi jatiquier nalesaj nuyabil, pero man weta'n ta anchique nanojij pa nuwi', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Y ri Jesús can ja' xutz'om-apo ri achi y xu'ij che: Ninjo' chi jac'achoj. Tiq'uis-e ayabil, xcha' che. Y can xe xu'ij quiri' ri Jesús, can ja' xq'uis-e ri ru-lepra ri achi. ");
INSERT INTO cakNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ri Jesús xuchelebej che ri achi re' que man tutzijoj chique ri winak ri xbanataj riq'uin. Y xu'ij chuka' che: Cami xe ac'utu-awi' chech ri sacerdote pa rocho ri Dios. Y can taya' ronojel ri nu'ij chupa ri ru-ley ri Moisés. Chiri' nu'ij anchique nic'atzin naya', chi nak'alajij-awi' chi jat ch'ajch'oj chic, xcha-e che. ");
INSERT INTO cakNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Pero ri Jesús más xel-ka rutzijol roma ri milagro ri', y q'uiy winak niquimol-qui' riq'uin. Jec'o winak yepe riq'uin roma niquijo' niquic'oxaj rutzij ri Dios. Y jec'o ch'aka chic niquijo' yec'achojrises-e roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Y raja' pa tak tz'iran rech-ulef nibe-wi, chi nu'on orar. ");
INSERT INTO cakNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Y jun k'ij cuando ri Jesús nuc'ut rutzij ri Dios, jec'o jujun achi'a' fariseos y jujun maestros chi ri ley. Jec'o chique reje' ri je-petenak pa tak tenemit ri jec'o pa rech-ulef Galilea. Jec'o je-petenak pa tenemit Jerusalem y pa ch'aka chic tenemit ri jec'o pa Judea. Reje' je-ch'ocol-apo chiquicojol ri winak ri niquic'oxaj-apo rutzij ri Dios ri nuc'ut ri Jesús chiquiwech. Y ri Jesús can c'o ruchuk'a' ri Ajaf Dios riq'uin, chi yec'achoj ri yawa'i' roma. ");
INSERT INTO cakNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y jec'o jujun achi'a' quic'uan-apo jun achi ri can siquirinak ruch'acul, li'an-e chech jun ch'at. Y reje' xquijo' xe'oc-apo pa jay c'a riq'uin ri Jesús, chi niquiya' ri quiyawa' chech. ");
INSERT INTO cakNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero ri achi'a' re' man xetiquier ta xe'oc-apo, roma can je q'uiy winak quimolon-qui' chiri'. Romari' reje' xquinojij xejote' parui' ri jay, y xquic'on-e juba' ri rui'. Y c'ajari' xquikasaj-ka ri achi li'an chech ri ch'at. Ri yawa' re' can c'a chech ri Jesús xbeka-wi-ka, chiri' chiquicojol ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Y cuando ri Jesús xutzu' chi ri achi'a' ri je-uc'uayon-apo ri achi yawa', can quiyo'n-wi cánima riq'uin raja', xu'ij che ri achi yawa': Ri amac xecoch'otaj (xecuyutaj). ");
INSERT INTO cakNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Can xe xquic'oxaj ri tzij re' ri maestros chi ri ley y ri achi'a' fariseos, can ja' xquinojij-ka: ¿Anchique c'a achi re'? ¿Y anchique roma nu'on chi ja raja' ri Dios? ¿Roma anchique ta winak nitiquier nucoch' (nucuy) mac? Man jun. Xe ri Dios nitiquier nu'on quiri', yecha' pa tak cánima. ");
INSERT INTO cakNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Pero ri Jesús reta'n utz ri niquinojij ri maestros chi ri ley, y reta'n chuka' ri niquinojij ri achi'a' fariseos. Romari' raja' xu'ij chique: ¿Anchique roma rix ninojij quiere'? ");
INSERT INTO cakNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Roma xa ren yitiquier nin-en che ri jun achi re' chi nibin-e, ¿yitiquier como nin-ij chuka' che chi nincoch' (nincuy) rumac? ¿Anchique ni'ij rix? ");
INSERT INTO cakNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Cami c'a, chi rix nitemaj chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can c'o uchuk'a' wiq'uin chi nincoch' (nincuy) mac, titzu' c'a, xcha' raja'. Y ja' xu'ij che ri achi siquirinak ruch'acul: Nin-ij chawe: Cacataj, tac'uaj-e la ach'at y jat (cabin) chi'awocho, xuche'x roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Y ri achi, can ja' xpa'e' chiquiwech conojel winak ri quimolon-qui' chiri', xuc'ol-e ri ch'at ri anchi' xcotz'e-wi-pe, y xbe. Y raja' can nuya' ruk'ij ri Dios cuando xtzolaj-e chirocho. ");
INSERT INTO cakNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Y conojel ri winak ri quimolon-qui' chiri', xsatz quino'j (xsach quic'u'x), roma man jun mej (bey) quitz'eton ta chi quiri' nibanataj. Ri winak re' can xquiya' ruk'ij ri Dios, y quixi'n-qui' niqui'ij: Chupa ri jun k'ij re' xekatzu' milagros ri man jun mej (bey) je-tz'eton. ");
INSERT INTO cakNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ri Jesús xel-pe chiri', y xutzu' jun achi moloy-impuesto. Ri achi re' Leví rubi', y ch'ocol pa jun ch'aquet, numol ri impuesto ri nitoj can. Y ri Jesús xu'ij che: Quinatzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Y ja' xbecataj-pe ri anchi' ch'ocol-wi, xuya' can ronojel ri c'o chiri', y xutzeklebej ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Y ri achi ri' xu'on jun nimak'ej pa rocho roma ri Jesús. Chuka' xeroyoj q'uiy moloy tak impuestos y ch'aka chic winak. Y conojel je-ch'ocol chuchi' mesa riq'uin ri Jesús y quiq'uin ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Y jec'o maestros chi ri ley y jec'o chuka' achi'a' fariseos ri jec'o-apo chiri'. Y ri maestros y ri fariseos re', q'uiy tzij yequi'ij-apo chiquij ri ru-discípulos ri Jesús. Yequi'ij-apo chique: ¿Anchique roma rix jixwa-jixuq'uia' quiq'uin ri moloy-impuestos y ri ch'aka chic winak ri xa je aj-mac? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Pero ri Jesús xu'ij chique ri achi'a' fariseos y ri je maestros chi ri ley: Jun ri nik'oman man ja' ta ri je utz ri yeruk'omaj. Raja' yeruk'omaj ri yeyawaj. ");
INSERT INTO cakNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Y quiri' chuka' ren man xipe ta chiquicanoxic winak ri choj rubanon quic'aslen chech ri Dios. Ren xipe chiquicanoxic ri can c'o quimac, chi niquiya' can quimac y niqui'en ri nrojo' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Y ri achi'a' fariseos y ri maestros chi ri ley xquic'utuj che ri Jesús: ¿Anchique roma ri ru-discípulos ri Juan can quicha'on k'ij chi niqui'en ayuno y oración? Y can quiri' chuka' niqui'en ri qui-discípulos ri achi'a' fariseos, pero ri a-discípulos ret man quiri' ta niqui'en, xa yewa-ye'uq'uia', xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y ri Jesús xu'ij chique: ¿Jixtiquier como niben chique ri je-banon invitar pa jun c'ulubic chi niquimalij ri wa'in, cuando xa c'a c'o chiquicojol ri ala' ri xc'ule'? Man utz ta. ");
INSERT INTO cakNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero xtapon ri k'ij cuando ri ala' re' xtileses-e chiquicojol, y c'ajari' xtiqui'en ayunar. ");
INSERT INTO cakNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chuka' ri Jesús xucusaj ri jun ejemplo re' chiquiwech: Man jun winak nuretz-ka jun tziak c'ac'ac' chi nuc'ojoj (nut'is) jun tziak ri xa can tzia'k' chic; roma xa nu'on quiri', man utz ta nu'on che ri tziak c'ac'ac' roma nuretz. Y chuka' jun tziak c'ac'ac' man nuc'uaj ta ri' riq'uin jun ri xa tzia'k' chic. ");
INSERT INTO cakNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Y quiri' chuka' man jun niyo'n c'ac'ac' vino chupa jun tz'um yacbel-ya' ri xa ucusan chic. Roma xa quiri' nu'on, man utz ta; roma ri tz'um ucusan chic man nuyuk ta chic ri'; ri tz'um nibojbo' (nichiquitaj) y ri vino xtiq'uis-e chupa. Y ri tz'um chuka' man jun chic xtic'atzin-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero chupa jun c'ac'ac' yacbel-ya', utz niyaquie' c'ac'ac' vino, roma c'a nuyuk-ri' jabel y man nibojbo' (nichiquitaj) ta. Ri vino can niyaquie' jabel chupa. ");
INSERT INTO cakNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Y man jun ri nukum vino ri c'o yan tiempo yaquel, y xturayij ta nukum c'ac'ac' vino. Man quiri' ta. Xa xtu'ij: Ri vino ri c'o yan tiempo yaquel jari' ri más utz, xticha'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Pa jun k'ij chi uxlanen, ri Jesús y ri ru-discípulos yek'ax pa jun ulef ticon trigo chech. Y ri discípulos c'o rech trigo yequich'up-e, y yequibil pa quik'a', y yequitaj. ");
INSERT INTO cakNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Romari' jujun achi'a' fariseos xqui'ij chique ri ru-discípulos ri Jesús: ¿Anchique roma rix ye'ibil ri trigo pa ik'a' ri k'ij re'? Ri k'ij re', chi uxlanen y man utz ta chi ni'an samaj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Pero ri Jesús xch'o'n-apo chique, y xu'ij: ¿Can man jun mej (bey) como itz'eton rix ri jun tzij ri tz'iban can chirij ri xu'on ri David y ri je raxbil, chupa ri ojer can tiempo, cuando xnum quipa y manak quiway? ");
INSERT INTO cakNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ri David xbe chucanoxic wey chiri' pa rocho ri Dios, y can ja ri lok'olaj tak pan ri xbeyo'x-pe che. Raja' xutaj ri pan ri', y xuya' chuka' chique ri je-benak riq'uin. Pero man mac ta ri xqui'en, más que ri pan ri' xe ri sacerdotes c'o modo yetijo, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y ri Jesús xu'ij chuka' chique ri achi'a' fariseos: Ri Rajaf ri k'ij chi uxlanen ja ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Pa jun chic k'ij chi uxlanen, ri Jesús y ri ru-discípulos xebe pa jun sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, y xutz'om quitijoxic ri quimolon-qui' chiri'. Y chiquicojol ri winak chiri', c'o-apo jun achi chaki'j ri ruk'a' derecha. ");
INSERT INTO cakNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Romari' jec'o-apo maestros chi ri ley y achi'a' fariseos xe niquitzu-apo ri Jesús xa xtic'achoj ri achi chaki'j ruk'a', chi quiri' niquisujuj chi ri Jesús xsamaj chupa ri jun k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero ri Jesús can reta'n-wi ri niquinojij ri maestros chi ri ley y ri achi'a' fariseos. Y ri Jesús xu'ij che ri achi chaki'j ri ruk'a': Cacataj y capa'e' pa nic'aj. Y ri achi can ja' xcataj-pe anchi' ch'ocol-wi, y xbepa'e' anchi' ri x-ix-wi che roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Xpe ri Jesús xu'ij chique ri winak ri jec'o chiri': Cami ninjo' ninc'utuj chiwe: ¿Más como nuc'ul ni'an ri utz pa jun k'ij chi uxlanen o ri man utz ta? ¿Ri nicol jun winak chech ri camic o nicamises? ¿Anchique ninojij rix? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Y Jesús xerutzu' conojel ri quimolon-qui' chiri'. Xch'o'n che ri achi ri yawa' ruk'a', y xu'ij: Tayuku' la ak'a'. Y ri achi can xe xuyuk ri ruk'a' anche'l ri x-ix che roma ri Jesús, can ja' utz xu'on can ri ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Pero ri maestros chi ri ley y ri achi'a' fariseos ri jec'o-apo chiri', xcataj quiyowal. Y can ja' xquic'utula-ka chiquiwech anchique niqui'en che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Y jun k'ij, ri Jesús xbe parui' jun juyu' chi xberu'ona' orar. Y jun ak'a' xc'ase' chi xch'o'n riq'uin ri Dios pa oración. ");
INSERT INTO cakNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Y chupa ri nimak'a' ruca'n k'ij, raja' xeroyoj ri achi'a' ri can yetzekleben-wi richi. Chiquicojol ri achi'a' re', xerucha' je cablajuj y xu'ij apóstoles chique. ");
INSERT INTO cakNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ri je cablajuj ri xerucha' ri Jesús, ja ri Simón ri xu'ij chuka' Pedro che, ri Andrés ri rach'alal ri Simón, ri Jacobo, ri Juan, ri Felipe, ri Bartolomé, ");
INSERT INTO cakNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ri Mateo, ri Tomás, ri Jacobo ri ralc'ual jun achi rubinan Alfeo, ri Simón ri c'o quiq'uin ri achi'a' ri ni'ix celadores chique, ");
INSERT INTO cakNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ri Judas ri rach'alal ri Jacobo, y ri Judas Iscariote ri xc'ayin richi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Cuando ri Jesús y ri je ru-apóstoles xeka-pe parui' ri juyu', y xebec'ue-ka quiq'uin ri ch'aka chic discípulos pa jun li'an ulef, chiri' chuka' je q'uiy winak quimolon-qui'. Jec'o winak je-petenak pa tenemit Jerusalem y pa ch'aka chic tenemit ri jec'o pa Judea, y jec'o chuka' je-petenak c'a chuchi' ri mar, ri pa Tiro y Sidón. Jec'o chique ri winak re' je-petenak chi niquic'oxaj rutzij ri Dios ri nutzijoj ri Jesús, y jec'o je-petenak chi yec'achojrises riq'uin quiyabil roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Y jec'o chuka' winak ri yalan niqui'en sufrir pa quik'a' itzel tak espíritus. Romari' xe'leses ri itzel tak espíritus roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Y conojel ri winak ri yeyawaj niquijo' niquitz'om-apo ri rutziak ri Jesús, roma raja' c'o uchuk'a' riq'uin chi nulesaj-e ronojel rech yabil. ");
INSERT INTO cakNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Y ri Jesús xerutzu' ri ru-discípulos y xu'ij chique: Can quixquicot rix ri nina' chi c'o necesidad pa iwánima chech ri Dios, roma can iwichi-wi rix ri ru-gobierno raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Can quixquicot rix ri ninum ri iwánima chech ri Dios, roma raja' xtuya' ronojel chiwe chi quiri' man chic xtinum-pe ri iwánima. Can quixquicot rix ri ntok' ri iwánima chech ri Dios, roma ri Dios xtujal ri iwok'ej riq'uin tze'n. ");
INSERT INTO cakNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Can quixquicot chuka' rix ri itzel jixtz'et coma ri winak, rix ri jixkotex-pe chiquicojol, rix ri ni'ix itzel tak tzij chiwe, rix ri itzel jixtz'et roma ja nubi' ren ri iniman, y rix ri can ronojel rech etzelal ri ni'an chiwe woma ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Y cuando xtic'ulumaj ronojel re', can quixquicot, y can quixropin chuka', roma can nim ri ruq'uiexel xtiyo'x chiwe chicaj. Roma xa can quiri' ri sufrimiento ri xquina' pa quic'aslen ri achi'a' ri xek'alajin rutzij ri Dios ojer can. Reje' xquina' ri sufrimiento pa quik'a' ri cati't-quimama' ri winak ri itzel jixquitzu' cami. ");
INSERT INTO cakNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Y rix beyoma', juya' (juyu') iwech, roma xixquicot yan riq'uin jun c'aslen yalan utz chech-ulef. Pero ri k'ij ri je-petenak chiwij man je quiri' ta chic. ");
INSERT INTO cakNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Rix chuka' ri jixwa' jabel, juya' (juyu') iwech, roma xtapon ri k'ij cuando yalan xtinum ipa y man jun ex xtiwil chi xtitaj. Rix ri jabel jixtze'n cami, juya' (juyu') iwech, roma xtapon ri k'ij cuando xquixok' roma bis. ");
INSERT INTO cakNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Y juya' (juyu') iwech cuando ri winak utz yech'o'n chiwij y ri winak ri' xa man je richi ta ri Dios. Roma ri quite-quitata' reje' utz xech'o'n chiquij ri winak ri xe'in chi niquik'alajij rutzij ri Dios y xa man quiri' ta. ");
INSERT INTO cakNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Pero rix ri jixc'o we' wiq'uin cami, ri yinic'oxaj-pe, tic'oxaj ri xtin-ij chiwe: Can quie'ijo' ri itzel yetz'eto iwichi, y can utz tibana' quiq'uin ri man jixquijo' ta. ");
INSERT INTO cakNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tic'utuj che ri Dios chi quieru'ona' bendecir ri winak ri yerayin itzel pa iwi', y chuka' man quie'imestaj pa i-oración ri niquitz'uc tzij chiwij. ");
INSERT INTO cakNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y xa c'o jun jixruch'ey, man titzolej ruq'uiexel che. Utz chi niya' chic iwi' pa ruk'a' jun mej (bey). Y xa c'o chuka' jun winak numaj-e ri jun itziak ri ik'u'n, can tiya' lugar che chi nuc'uaj jun chic itziak. ");
INSERT INTO cakNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Xabachique (Xama'anchique) winak ri c'o nuc'utuj chiwe, tiya' che ri nrojo'. Y xa c'o jun winak ri c'o numaj-e chiwe, man chic tich'ojij che. ");
INSERT INTO cakNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Y rix utz tibana' quiq'uin ri winak, roma rix man nika ta chiwech ri winak itzel quino'j (quina'oj) iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Y xa rix xe ri winak ri jixquijo' xe ri' ye'ijo', man cuesta ta. Roma xabachique (xama'anchique) winak nitiquier nu'on quiri'. Xa can quiri' chuka' niqui'en ri winak yalan je itzel. ");
INSERT INTO cakNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xa rix, xe ri winak ri yebano favor chiwe, xe chique reje' niben-wi favor chuka', ri' man cuesta ta. Roma xa quiri' chuka' niqui'en ri winak yalan je itzel. ");
INSERT INTO cakNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xa rix niya' jun ex che jun winak pa kajic, roma raja' nitiquier nuya' ruq'uiexel chiwe, ri' man cuesta ta. Roma ri winak ri yalan je itzel yequiya' chuka' pa kajic ri ex ri can quichi reje' chiquiwech ka reje', chi quiri' c'o niquich'ec can chirij. ");
INSERT INTO cakNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero rix man tiben quiri'. Xa quie'ijo' ri itzel yetz'eto iwichi. Quie'ito'. Y cuando rix niya' pa kajic jun ex iwichi, man tiyobej chi c'o nich'ec chirij; chi quiri' nim ri ruq'uiexel ri xtiyo'x chiwe. Y xa quiri' xtiben rix, can xtik'alajin chi jix ralc'ual chic ri nimalaj Dios ri c'o chicaj. Raja' utz runo'j (runa'oj) quiq'uin ri winak yalan je itzel, y utz chuka' runo'j (runa'oj) quiq'uin ri winak ri man jun mej (bey) niquiya' matiox che. ");
INSERT INTO cakNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Tijoyowaj quiwech ri winak, can anche'l nujoyowaj kawech roj ri Katata' Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Man quie'iben juzgar ri winak, chi quiri' ri Dios manak xquixru'on juzgar rix chuka'. Man tirayij chiquij ri winak chi niquitoj ri itzel tak ex ri quibanon chech ri Dios, chi quiri' ri Dios manak xtutoj chiwe anche'l ri itzel tak ex ri ibanon rix chech raja'. Ticoch'o' (Ticuyu') quimac ri winak, y ri Dios quiri' chuka' xtu'on chiwe rix. ");
INSERT INTO cakNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xa rix riq'uin ronojel iwánima ye'ito' ri winak riq'uin ri nic'atzin chique, ri Dios xtuya' chuka' ruq'uiexel chiwe. Ri ruq'uiexel xtuya' chiwe ri Dios, can q'uiy. Can xtunojisaj, can xtupitz', y can xtipulin xtuya' ri Dios chiwe. Y can anche'l ri niben rix quiq'uin ri winak, can quiri' chuka' xtu'on ri Dios iwiq'uin rix. ");
INSERT INTO cakNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y ri Jesús xu'ij chuka' jun ejemplo chique. Raja' xu'ij: ¿C'o como jun moy ri nitiquier nuc'uaj jun chic moy, y man yetzak ta pa tak jul? ");
INSERT INTO cakNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Y quiri' chuka' man jun ri nitijox c'o más ruk'ij chech ri ru-maestro. Más que xtutemaj ronojel ri nic'ut chech, y xtutemaj ronojel can anche'l reta'n ri ru-maestro, can manak-wi xtic'ue' más ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","¿Y anchique roma ret ja ri alaj k'ayis c'o pa rech ri awach'alal ri natzu' ch'anin y man nana' ta chi ret xa jun nimalaj che' k'atel pa awech? ");
INSERT INTO cakNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y man ta'ij chuka' che ri awach'alal: Taya' lugar chue chi ninlesaj-e ri alaj k'ayis k'atel pa awech, y man nana' ta chi ret xa jun nimalaj che' k'atel pa awech. Ret xa ca'i' apalaj, talesaj na'ey ri nimalaj che' pa awech ret, chi quiri' can k'alaj xcatzu'n y jatiquier nalesaj ri c'o pa ruwech ri awach'alal. ");
INSERT INTO cakNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Man jun che' ri can utz, xtuya' ta itzel tak rech. Man jun chuka' che' ri man utz ta, xtuya' ta utzilaj tak rech. ");
INSERT INTO cakNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Roma ri rech ri nuya' jun che', nina'ex xa utz o man utz ta. Roma jun k'ayis ri yalan ruq'uixal, man xtuya' ta higo ni uva. ");
INSERT INTO cakNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Y can quiri' jun winak. Jun winak utz, ja ri utz ri nu'on y nu'ij, roma can ja ri utz c'o pa ránima. Pero jun winak itzel, ja ri itzel tak ex nu'on y nu'ij, roma can jari' jec'o pa ránima. Roma jun winak can ja' ri c'o pa ránima ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","¿Y anchique roma rix ni'ij: Ajaf, Ajaf, jixcha' chue, y xa man niben ta ri nin-ij chiwe? ");
INSERT INTO cakNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nin-ij chiwe cami anchok riq'uin ninjunumaj-wi ri jun ri nipe wiq'uin ren y nuc'oxaj ri nutzij y nu'on ri nin-ij che. ");
INSERT INTO cakNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ri jun ri', can junan riq'uin ri jun achi ri xupoba' jun rocho. Na'ey, xu'on-ka ri jul chi ri ru-cimiento ri jay, y can parui' abaj xuc'ot-wi-ka ri jul re'. C'ajari' xuya' ri ru-cimiento ri jay, y xutz'om samaj. Y cuando c'achojinak yan ri jay, xq'uiy-pe ri rakan-ya'. Y ri rakan-ya' re' xberila' ri jay. Pero ri jay man xsilon ta, más que ri rakan-ya' yalan xnimer-pe, y yalan ruchuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ri winak ri nipe wiq'uin chi nuc'oxaj ri nutzij, y man nu'on ta ri nin-ij che, junan riq'uin ri jun achi ri xupoba' jun rocho y xa man xuya' ta ru-cimiento. Y cuando ri rakan-ya' xnimer, xberila-pe ri jay. Ri jay ri' xtzak y xq'uis chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Cuando ri Jesús xtane' riq'uin ri tzij chiquiwech ri winak, raja' xbe pa tenemit Capernaum. ");
INSERT INTO cakNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Y chiri' pa tenemit c'o jun achi capitán. Y ri achi re' c'o jun rusamajel y yalan nrojo', pero niyawaj, y can ya nicom. ");
INSERT INTO cakNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Y roma ri capitán can ruc'oxan utzilaj tak ex chirij ri Jesús, raja' xerutak rijilaj tak achi'a' israelitas ri c'o quik'ij, chi quiri' niquic'utuj favor che ri Jesús chi tipe juba' riq'uin chi quiri' nic'achoj can ri rusamajel roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Y cuando ri rijilaj tak achi'a' xe'apon riq'uin ri Jesús, can xquic'utuj favor che. Y xqui'ij che: Can rakalen na'an jun favor che ri capitán. ");
INSERT INTO cakNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Roma raja' yalan jojrojo' roj israelitas, y xu'on jun sinagoga anchi' nakamol-wi-ki' chi nakac'oxaj rutzij ri Dios, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Y ri Jesús xbe chiquij ri rijilaj tak achi'a' ri je-takon-pe roma ri capitán. Y cuando ri Jesús y ri je-benak riq'uin ye'apon yan chirocho ri capitán, raja' xerutak ca'i-oxi' ru-amigos chi ne'quic'ulu' ri Jesús. Y ri achi'a' ri' xbequi'ij che ri Jesús: Ajaf, ri achi capitán ri takayon-pe kachi, quiere' ru'in-pe chake chi naka'ij chawe: Ajaf, man casamaj más woma, roma ren xa jin jun aj-mac y romari' man nuc'ul ta jatoc pa wocho. ");
INSERT INTO cakNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Y romari' man xinjo' ta chi ja ren xibecanon awichi. Ret xe ta'ij chi tic'achoj ri nusamajel, y xtic'achoj can awoma. ");
INSERT INTO cakNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Y can weta'n-wi chi quiri' xtibanataj. Roma ren ninnimaj quitzij ri c'o más quik'ij chinuech, y chuka' jec'o soldados niquinimaj nutzij ren. Y cuando nin-ij che jun chi tibe, ja nibe; y cuando nin-ij che jun chic chi tipe, ja nipe. Y chuka' cuando nin-ij che nusamajel chi tu'ona' jun samaj, ja nu'on, xecha' ri achi'a' che. ");
INSERT INTO cakNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Y ri Jesús can anchique la xuna' cuando xuc'oxaj ri rutakon-e rubixic ri capitán. Y ri Jesús can ja' xerutzu' ri winak ri je-benak chirij, y xu'ij chique: Can ketzij nin-ij chiwe, chi ri achi ri takayon-pe rubixic ri tzij re', can yalan-wi ruyo'n ránima wiq'uin. Y man jun nuwinak israelita ri wilon ri can ruyo'n ta ránima wiq'uin, anche'l ri jun achi re'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Y cuando xetzolaj ri winak ri je-takon-pe roma ri capitán, xquitzu' chi ri achi samajel can man jun chic ruyabil c'o. ");
INSERT INTO cakNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jun chic k'ij, ri Jesús xbe pa jun tenemit rubinan Naín, y je-benak chuka' ri ru-discípulos riq'uin. Y yalan winak chuka' je-benak chiquij. ");
INSERT INTO cakNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Cuando ri Jesús y ri je-benak riq'uin ye'oc yan apo pa tenemit Naín, xquitzu' chi c'amon-pe jun caminak chi ne'muk. Ri caminak re' jun c'ajol-ala', ral jun malca'n-ixok. Ri malca'n-ixok re', can xe ri' ri ral c'o, y jari' ri benak chumukic. Y yalan winak ri je-benak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Y cuando ri Ajaf Jesús xutzu' rech ri ixok ri xcom-e ri ral, xujoyowaj rech, y xu'ij che: Man chic catok'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Y ri Jesús xutz'om-apo ri caja anchi' yo'n-wi-e ri caminak, y ri je-uc'uayon-e richi ri caminak xepa'e-ka chiri'. Y raja' xu'ij che ri caminak: Chawe ret yich'o'n-wi, cacataj. ");
INSERT INTO cakNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Y cuando ri Jesús xu'ij quiri', ri caminak xcataj, y xbetzijon-pe. Y ri Jesús xujach-e ri c'ajol-ala' che rute'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Cuando ri winak xquitzu' ri xbanataj, yalan xquixi'j-qui'. Y xquiya' ruk'ij ri Dios, y niqui'ij: Cami xoka jun nimalaj achi chikacojol, ri nuk'alajij rutzij ri Dios. Cami ri Dios xutak-pe jun ri nuya' ru-bendición chikacojol roj ri rutenemit, xecha' ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Y ri xu'on ri Jesús chupa ri k'ij ri', xna'ex chiri' pa Judea, y xna'ex chuka' pa tak tenemit ri jec'o-pe chunakaj ri Judea. ");
INSERT INTO cakNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Y ri Juan Bautista xuc'oxaj ronojel, roma ja ri ru-discípulos ri xebetzijon che. Romari' raja' xeroyoj je ca'i' chique ri ru-discípulos, ");
INSERT INTO cakNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y xerutak-e riq'uin ri Jesús chi ne'quic'utuj che: ¿Can ja ret ri Cristo ri can xtipe-wi? ¿O nakayobej na chic jun? Quiri' xu'ij-e chique. ");
INSERT INTO cakNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Y ri jerutakon-e ri Juan, xe'apon c'a riq'uin ri Jesús. Y reje' xqui'ij che: Ri Juan Bautista jojrutakon-pe awiq'uin, chi nokac'utuj chawe: ¿Ja ret ri Cristo ri can xtipe-wi? ¿O xa nakayobej na chic jun? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Y cuando ri ru-discípulos ri Juan xe'apon, ri hora ri' q'uiy winak ri yeyawaj yec'achoj roma ri Jesús. Y can jec'o winak, más que xabachique (xama'anchique) itzel yabil ntoc chique, raja' yeruc'achojrisaj chuka'. Chuka' jec'o winak ri yerulesaj itzel tak espíritus quiq'uin y nu'on chuka' chique ri je moy chi yetzu'n. ");
INSERT INTO cakNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Y c'ajari' ri Jesús xu'ij chique ri je ca'i' ru-discípulos ri Juan: Cami quixtzolaj, y titzijoj che ri xitzu' can y ri xic'oxaj-e we'. Itzijoj che chi ri moy yetiquier yetzu'n, ri winak ri yejetz'ma'y yebin, can yebin-e utz, y ri winak ri c'o ri itzel yabil lepra chiquij, yec'achoj. Titzijoj chuka' che chi ri winak ri man yec'oxan ta, cami yec'oxan yan, ri caminaki' yec'astaj, y ri winak ri c'o necesidad pa cánima chech ri Dios, nintzijoj ri utzilaj rutzij ri Dios chique. ");
INSERT INTO cakNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Y ti'ij chuka' che chi jun winak anche'l raja', ri can ruyo'n ránima wiq'uin y can manak yirumalij can, can tiquicot roma c'o xtuch'ec chirij roma quiri' rubanon. ");
INSERT INTO cakNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Y cuando ri je ca'i' achi'a' ri jerutakon-pe ri Juan xetzolaj, ri Jesús xeru'ij utzilaj tak tzij chirij ri Juan chiquiwech ri winak ri jec'o chiri'. Y quiere' ri nu'ij ri Jesús chique ri winak: ¿Anchique ri xbe'itzu' rix chiri' pa tz'iran rech-ulef? ¿Xitzu' como rix jun achi chiri', ri anche'l aj, ri nibe quiela' nibe quiela' pa ruk'a' ri quiek'ik'? ");
INSERT INTO cakNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Anchique ri xbe'itzu' rix chiri'? ¿Xitzu' como rix jun achi ri jabel tak tziak jerucusan? Man quiri' ta. Ri achi'a' jequicusalo'n tziak quiri', can utz quibanon ri anchi' jec'o-wi. Reje' yec'ue' pa tak cocho ri reyes. ");
INSERT INTO cakNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Pero anchique ri xbe'itzu' rix chiri' pa tz'iran rech-ulef? ¿Jun achi ri nik'alajin ri bin che roma ri Dios ri xitzu' chiri'? Ja'. Ri achi ri xitzu' chiri' can ja-wi ri' rusamaj. Pero can c'o chuka' jun chic samaj ri yo'n che, y ri' más nim. ");
INSERT INTO cakNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Y chirij ri Juan nich'o'n-wi ri Dios chupa rutzij ri tz'iban can, cuando nu'ij: Xtintak jun achi na'ey, chi nunaba' ri bey anchi' xtapon-wi ri Cristo. Quiri' nu'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Y titemaj c'a, je q'uiy achi'a' ri quik'alajin rutzij ri Dios ri je-alaxinak chech-ulef, pero man jun ri c'o ta más ruk'ij chech ri Juan Bautista. Can nim-wi ruk'ij raja'. Pero cami, can conojel ri ye'an gobernar roma ri Dios, can más c'o quik'ij. Y ri más manak ruk'ij chique reje', más c'o ruk'ij chech ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Y chiri' jec'o q'uiy winak y moloy tak impuestos ri je-banon yan bautizar roma ri Juan. Y cuando reje' xquic'oxaj ri xu'ij ri Jesús, xqui'ij chi ri Dios can choj-wi riq'uin ri runo'j (runa'oj). ");
INSERT INTO cakNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero ri achi'a' fariseos y ri maestros chi ri ley, man xka ta chiquiwech ri xrojo' ta xu'on ri Dios quiq'uin. Reje' man xquijo' ta xe'an bautizar roma ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Y ri Ajaf Jesús xu'ij: ¿Anchique como nin-ij chiquij ri winak chi ri tiempo re'? ¿Y anchok quiq'uin je junan-wi? ");
INSERT INTO cakNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ri winak re' xa je junan riq'uin ri jun atz'anen ri niqui'en ri ac'uala' pa tak bey. Ri ac'uala' re' yesiq'uin yech'o'n chiquiwech, y niqui'ij chupa ri atz'anen: Xkak'ojmaj ka-flautas chiwech y man xixxajo ta. Xkabixaj bix richi bis chiwech y man xixok' ta, yecha' ri ac'uala' chupa ri atz'anen. Y je quiri' ri winak re', man jun nika chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Roma cuando xoka ri Juan Bautista, raja' man xutaj ta pan, man xukum ta chuka' ruya'al-uva. Y rix xi'ij chi raja' c'o itzel espíritu riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Y cami xinoka ren, ri jin-kajinak-pe chicaj y xinalex chi'icojol, nintaj pan y ninkum chuka' ruya'al-uva, y rix ni'ij chi xe wa'in ninjo', y ni'ij chuka' chi jin jun k'abarel, chi jin qui-amigo ri je moloy-impuestos, y jin qui-amigo ri winak aj-mac. ");
INSERT INTO cakNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero ri runo'j (runa'oj) ri Dios can k'alaj pa quic'aslen ri winak ri yeniman richi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Y c'o jun achi fariseo ri xbano invitar richi ri Jesús chi ne'wa' pa rocho. Y cuando ri Jesús xapon pa rocho ri achi, xch'oquie-apo chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Y chupa ri tenemit ri', c'o jun ixok aj-mac; ri ixok re' xuna'ej chi ri Jesús c'o pa rocho ri jun achi fariseo. Romari' raja' xapon chiri' ruc'uan-apo jun frasco banon che jun abaj ri ni'ix alabastro che, y c'o jun jubulaj ak'om chupa. ");
INSERT INTO cakNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Y ri ixok re' xapon riq'uin ri Jesús, raja' yalan ntok'. Y ri ruya'al tak rech ri ixok re' yeka-ka chirij rakan ri Jesús. Raja' yerusu' rakan ri Jesús riq'uin ri rusmal tak ruwi'. Ri ixok re' yerutz'ubaj chuka' rakan ri Jesús, y xuya' chuka' ri jubulaj ak'om chirij ri rakan. ");
INSERT INTO cakNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Y cuando ri achi fariseo ri xbano invitar richi ri Jesús, xutzu' ri xu'on ri ixok, xunojij-ka: Xa ta ketzij chi ri Jesús can nuk'alajij rutzij ri Dios, nuna'ej ta ancu'x (anchique) nitz'amo la rakan, y anchique chi ixok la'. Roma la jun ixok la' xa aj-mac, xcha-ka pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Y ri Jesús xu'ij che ri achi fariseo: Simón, ren c'o ri ninjo' nin-ij chawe. Ri Simón xu'ij che: Ajaf, ¿anchique ri najo' na'ij chue? ");
INSERT INTO cakNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Y ri Jesús xu'ij che: Jun mej (bey), ca'i' achi'a' quibanon quic'as riq'uin jun achi ri niyo'n mero pa kajic. Jun chique ri achi'a' re', quinientos denarios ruc'as, y ri jun chic, cincuenta denarios ruc'as. ");
INSERT INTO cakNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Pero roma ri achi'a' re' man yetiquier ta niquitoj quic'as, ri achi ri yoyo'n qui-mero xu'ij chique: Tiq'uis quiri' ri ic'as, man chic titoj chue, xcha' chique. Y ri Jesús xu'ij chuka' che ri Simón, ri fariseo: Cami ta'ij chue, ¿ancu'x (anchique) chique ri je ca'i' achi'a' re' ri más xojo'n richi ri achi ri niyo'n mero pa kajic? ");
INSERT INTO cakNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xu'ij: Ren nin-ij ja ri más q'uiy ruc'as xu'on riq'uin. Ja', quiri', xcha' ri Jesús che ri Simón. ");
INSERT INTO cakNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Y ri Jesús xutzu-apo ri ixok cuando xu'ij che ri Simón, ri fariseo: ¿Natzu' ri ixok re'? Cuando ren xinoc-pe we' pa awocho, man xaya' ta nuya' chi xch'aj wakan. Pero ri ixok re' xeruch'aj ri wakan riq'uin ri ruya'al tak rech, y xeruchakrisaj riq'uin ri rusmal tak ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Chuka' cuando xinoc-pe, man xinatz'ubaj ta chi xinaben saludar. Pero ri ixok re', ja ri wakan ri jerutz'uban ri jampe' jinc'o-ka we' pa awocho. ");
INSERT INTO cakNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ret chuka' man xak'aj ta aceite pa nuwi' cuando xinoc-pe. Pero ri ixok re', can ja' ri jubulaj ak'om ri xuya' chirij ri wakan. ");
INSERT INTO cakNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Romari' nin-ij chawe ret Simón, chi ri ixok re' yalan nrojo' ri xcoch'o (xcuyun) rumac. Roma can q'uiy-wi rumac jerubanon, y can xecoch'otaj (xecuyutaj) yan ronojel. Y ri man q'uiy ta rumac ri xcoch'otaj (xcuyutaj), xa manak más nrojo' ri xcoch'o (xcuyun) rumac. ");
INSERT INTO cakNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Y ri Jesús xu'ij che ri ixok: Ri amac xecoch'otaj (xecuyutaj) yan. ");
INSERT INTO cakNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Y ri winak ri junan jec'o riq'uin ri Jesús chuchi' mesa, niqui'ij chiquiwech: ¿Anchique chi achi re'? Roma can yerucoch' (yerucuy) chuka' mac, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Y ri Jesús xu'ij che ri ixok: Xacolotaj roma xaya' awánima wiq'uin. Cami c'a, catzolaj; ri awánima xril yan uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jun jani' k'ij después che ronojel re', ri Jesús xbe pa tak nim y cocoj tak tenemit, y ri cablajuj discípulos je-benak riq'uin. Y raja' nutzijoj ri utzilaj rutzij ri Dios ri nich'o'n chirij ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Y jec'o chuka' jujun ixoki' ri je-benak chirij. Ri ixoki' re', jari' ri xe'leses-e itzel tak espíritus quiq'uin y ch'aka chic rech yabil roma ri Jesús. Chiquicojol ri ixoki' re' benak ri María, ri ni'ix chuka' Magdalena che. Y riq'uin ri ixok re' xe'leses-e wuku' itzel tak espíritus, roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Chiquicojol ri ixoki' ri je-benak chirij ri Jesús, benak ri Juana, raxayil ri jun achi rubinan Chuza. Y ri achi re' jun rusamajel ri Herodes. Chuka' benak ri Susana. Y jec'o chuka' ch'aka chic ixoki' ri je-benak ri can yeto'n richi ri Jesús. Ri ixoki' re' xequilij ri Jesús y ri ru-discípulos riq'uin ri quibeyomal. ");
INSERT INTO cakNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Je q'uiy winak xquimol-qui' riq'uin ri Jesús. Ri winak ri' pa ronojel tenemit je-petenak-wi. Romari' can je q'uiy winak xquimol-ka-qui' chiri'. Ri Jesús xutzijoj jun ejemplo chique y xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","C'o jun achi ri xbetico. Y cuando ri achi nutic ri ija'tz', juba' ri ija'tz' xeka pa bey, romari' ri winak yek'ax parui'. Y xepe ri chicop ri c'o quixic' ri yebe chicaj, xquitaj-e ri ija'tz'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Y ch'aka chic ija'tz' xeka chiquicojol abaj. Ri ija'tz' re' xebos-pe, pero cuando xpe ruchuk'a' ri k'ij, xechaki'j-ka, roma man rex ta ri ulef ri anchi' xka-wi ri ija'tz'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Y juba' chic ija'tz' xeka chiquicojol k'ayis ri c'o quiq'uixal. Y cuando xe'el-pe, junan xeq'uiy quiq'uin ri q'uix. Pero roma ri q'uix yalan xeq'uiy, ri tico'n xejik' chiquicojol. ");
INSERT INTO cakNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Y ri ch'aka chic ija'tz' xeka pa jun utzilaj ulef, y jabel xeq'uiy y xquiya' a cien quiwech, xcha'. Y cuando ri Jesús xu'ij yan ronojel re', can riq'uin ruchuk'a' xch'o'n, y xu'ij: Ri c'o ruxiquin, can tuc'oxaj ri xin-ij, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Y ri discípulos xquic'utuj che ri Jesús anchique ri xrojo' xu'ij chique riq'uin ri jun ejemplo. ");
INSERT INTO cakNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Y ri Jesús xu'ij chique: Man jun mej (bey) can ta k'alajin utz anchique modo nu'on gobernar ri Dios, pero chiwe rix yo'n lugar chi nina'ej. Pero ri winak ri man jinquinimaj ta, riq'uin ejemplos yich'o'n-wi chique, chi quiri' xe niquitzu' y man niquitzu' ta utz ri niquitzu', y xe niquic'oxaj y man niqui'en ta entender ri niquic'oxaj. ");
INSERT INTO cakNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Y quiere' nu'ij ri ejemplo: Ri ija'tz' junan nu'on riq'uin rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ri juba' ija'tz' ri xeka pa bey, junan riq'uin rutzij ri Dios ri nic'oxex coma ri winak. Ri itzel junanin nipe, y nulesaj-e ri rutzij ri Dios pa tak cánima ri winak, chi quiri' ri winak man niquinimaj ta ri Dios, y man yecolotaj ta chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Y ri ija'tz' ri xeka can chiquicojol tak abaj, junan riq'uin rutzij ri Dios ri nic'oxex coma ri winak. Ri winak ri' can yalan yequicot cuando niquic'on-ka rutzij ri Dios pa cánima. Pero roma man nika ta ka ri ruc'amal (ruxe') ri rutzij ri Dios pa cánima, can man yelayoj ta yequicot, xe jun jani' oc k'ij utz niquiya' cánima riq'uin ri Dios. Y cuando yetojtobex, can ch'anin yetzak y niquiya' can ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ri ija'tz' ri xeka chiquicojol k'ayis ri c'o quiq'uixal, can junan riq'uin rutzij ri Dios ri nic'oxex coma ri winak. Pero ri winak ri' xa yejik' roma ja ri nic'atzin chique k'ij-k'ij xe ri' niquinataj, chuka' jec'o yejik' roma quibeyomal y jec'o yejik' roma ri yequirayij, y man niwachin ta utz ri quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Y ri ija'tz' ri yeka pa utzilaj ulef, can junan riq'uin rutzij ri Dios ri nic'oxex coma ri winak. Reje' riq'uin ronojel cánima niquic'oxaj y niqui'en ri nu'ij. Y can siempre quiri' niqui'en, quiyo'n cánima riq'uin ri Dios, y niwachin jabel ri quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Y chuka' man jun winak ri nutzaj jun luz y nutz'apij o nuya' ta apo chuxe' ruch'at. Man quiri' ta nu'on. Ri luz ri' nic'atzin chi niyo'x chicaj chi quiri' sakil nu'on rupa ri jay y ri ye'oc-apo k'alaj niquitzu' rupa ri jay. ");
INSERT INTO cakNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Y chuka' man jun ex ri ewan can, ri man ta xte'k'alajin-pe. Y chuka' man jun ri tz'apin can rij, ri manak ta xtik'alajin-pe y man xtel ta pe chech sakil. ");
INSERT INTO cakNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Y quiri', xa rix nic'oxaj rutzij ri Dios, tiyaca-ka pa iwánima. Roma ri can c'o ruyacon pa ránima, can xtiyo'x más che. Pero ri nic'oxan rutzij ri Dios y xa man nuyec ta ka pa ránima, ri jani' oc nunojij raja' chi c'o riq'uin, hasta ri' xtimaj che, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Y ri rute' y ri je rach'alal ri Jesús xepe c'a anchi' c'o-wi raja'. Pero man xetiquier ta xe'apon-apo c'a riq'uin, roma je q'uiy winak quimolon-qui' riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Y x-ix-apo che ri Jesús: Ri ate' y ri awach'alal jatquiyoben chojay, je-petenak chi jatoquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Pero raja' xu'ij: Ri winak ri yec'oxan y niqui'en ri nu'ij rutzij ri Dios, jari' ri je nte' y je wach'alal, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Y jun k'ij ri Jesús y ri ru-discípulos xe'oc-e pa jun canoa. Y c'ajari' xu'ij chique: Jo' juc'an chic ruchi-choy (ruchi-ya'). Y xebe. ");
INSERT INTO cakNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Y ri Jesús xwer-ka cuando xebe parui' ri ya'. Y cuando ja' je-benak, xpe jun nimalaj quiek'ik' chiri' parui' ri ya'. Romari' ri canoa anchi' je-benak-wi, xoc ya' chupa y juba' ta chic nibe chuxe' ya'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Xepe ri discípulos xquic'asoj ri Jesús y xqui'ij che: ¡Ajaf! ¡Ajaf! Cami jojcom, xecha' che. Y ri Jesús xcataj-pe y xu'ij: Tiq'uis-e ruchuk'a' ri quiek'ik' y titane-ka ri ya'. Y quiri' xbanataj. Ri quiek'ik' xq'uis-e ruchuk'a' y xtane-ka chuka' ri ya'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Y ri Jesús xu'ij chique ri ru-discípulos: ¿Anchique roma man xiya' ta iwánima wiq'uin? Pero ri discípulos quixi'n-qui'. Can anchique la xquitzu' ri xbanataj, y can niquic'utula' chiquiwech: ¿Anchique c'a achi re'? Roma can nich'o'n chique ri quiek'ik' y ri ya', y can yeniman che. ");
INSERT INTO cakNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Y ri Jesús y ri ru-discípulos xe'apon juc'an chic ruchi-choy (ruchi-ya'), chiri' pa jun lugar rubinan Gadara, ri c'o-apo chech ri Galilea. ");
INSERT INTO cakNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Y cuando ri Jesús xel-pe chupa ri canoa, xapon jun achi aj-chiri' pa tenemit riq'uin. Y ri achi re' q'uiy yan tiempo ri jec'o-pe itzel tak espíritus riq'uin. Romari' man jun rutziak nucusaj, ni man nic'ue' ta chirocho. Xa ja ri cementerio richi ri tenemit ri', ri oconak rocho. ");
INSERT INTO cakNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Y ri achi re', can xe xutzu' ri Jesús, can ja' xbexuquie' chech. Y can nisiq'uin nich'o'n-apo che ri Jesús, y nu'ij: Ret Jesús ri Ralc'ual ri nimalaj Dios, ¿anchique najo' chue? Tabana' jun favor man quinach'ujrisaj. ");
INSERT INTO cakNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ri achi xu'ij quiere' che roma ri Jesús xu'ij yan che ri itzel espíritu chi tel-e riq'uin ri achi. Roma q'uiy yan tiempo tic'ue' riq'uin. Y can q'uiy mej (paj) ri winak quiximon ruk'a-rakan ri achi re' riq'uin ch'ich' y cadenas, pero man je-tiquirinak ta riq'uin. Roma ri achi re' yerukupij ri cadenas ri anchok che ximon-wi, y ri itzel espíritu ri c'o riq'uin nu'on che chi nibe pa tz'iran rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Y ri Jesús xuc'utuj che ri achi: ¿Anchique abi'? Y ri achi xu'ij: Legión nubi', xcha'. Quiri' xu'ij ri achi roma can je q'uiy ri itzel tak espíritus ri jec'o riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Y ri itzel tak espíritus re' can xquic'utuj favor che ri Jesús, chi xa yerulesaj-e riq'uin ri achi, man quierutak chupa ri nimalaj jul k'eku'm, qui-lugar ri itzel tak espíritus, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Y chunakaj apo ri lugar ri', parui' jun juyu', can je q'uiy ak yewa', romari' ri itzel tak espíritus xquic'utuj favor che ri Jesús chi tuya' lugar chique chi ye'oc quiq'uin ri ak ri'. Y ri Jesús xu'ij chique chi utz. ");
INSERT INTO cakNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Y ri itzel tak espíritus can ja' xe'el-e riq'uin ri achi, y xebe'oc quiq'uin ri ak. Conojel ri ak ri' junanin xebexule-pe chech jun juyu' can pa'l-rech y c'a pa ya' xebeka-wi. Y chiri' xejik'-wi conojel. ");
INSERT INTO cakNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Y cuando ri yechajin quichi ri ak, xquitzu' ri xbanataj, xelumaj (xenimaj); y reje' xbequiya' can rutzijol pa tenemit y pa tak juyu'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Y ri winak ri xec'oxan ri xbanataj, xepe chi xoquitzu'. Y cuando xeloka riq'uin ri Jesús, xquitzu' chi ri achi ri xe'leses-e ri itzel tak espíritus riq'uin, ch'ocol-apo riq'uin ri Jesús, rucusan rutziak, y man nu'on ta chic ri anche'l rubanon-pe. Pero ri winak ri' xa xquixi'j-qui' cuando xquitzu' ri achi re'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y xtzijos chuka' chique ri xbanataj. Ronojel re' xtzijos chique coma ri winak ri can jec'o-apo ri xquitzu' cuando xe'leses ri itzel tak espíritus riq'uin ri achi, roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Riq'uin ronojel ri xbanataj, ri winak aj-chiri' pa Gadara xquic'utuj favor che ri Jesús chi tel-e chiri' pa Gadara. Ri winak ri' xqui'ij quiri' roma yalan quixi'n-qui'. Romari' ri Jesús y ri ru-discípulos xe'oc-e pa canoa, y ja' xebe. ");
INSERT INTO cakNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Y ri achi ri xe'leses-e ri itzel tak espíritus riq'uin, nuc'utuj favor che ri Jesús chi tuya' lugar che chi nibe riq'uin. Pero ri Jesús xu'ij che chi tic'ue' can: ");
INSERT INTO cakNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Catzolaj chi'awocho, y atzijoj ri xu'on ri Dios awiq'uin, xuche'x. Y ri achi can xberutzijoj-wi chirocho, y chique conojel winak pa rutenemit xutzijoj ri xu'on ri Jesús riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Y cuando ri Jesús y ri ru-discípulos xetzolaj c'a juc'an chic ruchi-choy (ruchi-ya'), ri winak jec'o chiri' can yequicot xequic'ul-apo, roma ri winak ri' can ja ri Jesús quiyoben. ");
INSERT INTO cakNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Xapon chuka' jun achi rubinan Jairo. Ri achi re' c'o jun rusamaj chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios y ja raja' ri encargado chiri'. Ri Jairo xbexuquie' chech ri Jesús, y xuc'utuj favor che chi tibe riq'uin chirocho, ");
INSERT INTO cakNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","roma can xe jun oc rumi'al c'o, ri c'o la'k jun cablajuj rujuna' y ya nicom. Y cuando ri Jesús y ri je-benak riq'uin xquitz'om-e bey chi yebe chirocho ri Jairo, can je q'uiy winak xquitzeklebej-e. Y roma can je q'uiy winak je-benak, man utz ta chic yebin, xa can niquipitz' ri Jesús je-benak. ");
INSERT INTO cakNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquicojol ri winak, benak jun ixok yawa'. Ri ixok re' c'o yan cablajuj juna' nibin ruquiq'uiel, y man nitane' ta. Xuq'uis yan ronojel ru-mero, roma benak yan quiq'uin q'uiy winak ri yek'oman, y man jun chique reje' tiquirinak ta ruk'oman ri ruyabil. ");
INSERT INTO cakNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ri ixok ri' xunim-apo-ri' chirij ri Jesús, y xutz'om-apo juba' ri ruchi-rutziak ri Jesús. Y can ja' xtane' ruquiq'uiel ri nibin. ");
INSERT INTO cakNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Y ri Jesús xuc'utuj: ¿Ancu'x (Anchique) xtz'amo-pe wichi? Conojel niqui'ij chi reje' man xquitz'om ta, romari' ri Pedro y ri ch'aka chic discípulos xqui'ij che ri Jesús: Ajaf, ret najo' nana'ej ancu'x (anchique) xatrutz'om. Pero we' cuesta nana'ej, roma je q'uiy winak niquipitz'-qui' y niquinimila-qui' chawij, y ret nac'utuj: ¿Ancu'x (Anchique) xtz'amo-pe wichi? ");
INSERT INTO cakNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Pero ri Jesús xu'ij: C'o jun ri xirutz'om-pe, roma can xinna' chi c'o jun ri xinc'achojrisaj riq'uin ri uchuk'a' c'o wiq'uin, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Y cuando ri ixok xutzu' chi xna'ex, nibarbot xoxuquie' chech ri Jesús. Y chiquiwech conojel ri winak xu'ij-apo che ri Jesús anchique roma xutz'om ruchi-rutziak. Y xu'ij chuka' chi can xe xutz'om ruchi-rutziak ri Jesús, can ja' xtane-ka ruyabil. ");
INSERT INTO cakNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ri Jesús xu'ij che: Numi'al, xacolotaj roma xaya' awánima wiq'uin. Cami c'a, catzolaj; ri awánima xril yan uxlanen, xuche'x. ");
INSERT INTO cakNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Y c'a nitzijon ri Jesús riq'uin ri ixok, cuando c'o jun xoka ri petenak chirocho ri Jairo, ri achi encargado chiri' pa sinagoga. Ri jun ri' xoru'ij che ri Jairo: Man tac'uaj chic ri Maestro, ri Jesús, roma ri ami'al xa xcom yan. ");
INSERT INTO cakNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Pero ri Jesús xuc'oxaj, y xu'ij che ri Jairo: Man tuxi'j-ri' awánima roma ri xo'ix chawe. Taya' awánima wiq'uin, y ri ami'al xtic'astaj, xuche'x. ");
INSERT INTO cakNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Y cuando xe'apon chirocho ri Jairo, ri Jesús xe chique ri Pedro, ri Jacobo y ri Juan ri je ru-discípulos, y chique ri rute-rutata' ri ac'ual caminak xuya' lugar chi xe'oc-apo riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conojel yalan niquibisoj y nicok'ej ri xten ri'. Pero ri Jesús xu'ij chique: Man chic tiwok'ej ri xten, roma raja' xa man caminak ta, raja' xe niwer, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero reje' xa xetze'n chirij ri Jesús, roma quieta'n chi can caminak-wi ri xten. ");
INSERT INTO cakNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Y ri Jesús xutz'om ruk'a' ri xten caminak y xu'ij: Nóya, cacataj. ");
INSERT INTO cakNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Y ri xten can xtzolaj-pe ri ránima riq'uin, y can ja' xcataj-pe. Y ri Jesús xu'ij chi tiyo'x ruway. ");
INSERT INTO cakNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Y ri te'j-tata'j can anchique la xquina' cuando xquitzu' ri xbanataj riq'uin ri calc'ual. Y ri Jesús xu'ij chi can man tiquitzijoj ri xbanataj chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xeroyoj ri cablajuj ru-discípulos, y xuya' uchuk'a' chique chi yequilesaj ronojel quiwech itzel tak espíritus, y chuka' chi yequic'achojrisaj yawa'i'. Y man xe ta chuka' xuya' uchuk'a' chique, xa can xuya' chuka' lugar chique chi niquicusaj ri uchuk'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Y xerutak-e chi xbequitzijoj ri ru-gobierno ri Dios, y chi chuka' yequic'achojrisaj yawa'i'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Y ri Jesús xu'ij chique chuka': Cuando xquixbe, can man jun anchique tic'uaj. Man tic'uaj ich'ami'y, man tic'uaj ichim, ni wey, ni mero. Y man tic'uaj jun chic itziak, xa can xe ri icusan-e. ");
INSERT INTO cakNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Y ri jay anchi' xquixapon-wi pa jun tenemit, chiri' quixc'ue-wi-ka. C'a jixel-pe chupa ri tenemit, c'ajari' xtiya' can ri jay anchi' xixc'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Y xa chupa jun tenemit man utz ta nic'ul iwech coma ri winak, tiya' can y titota' can ri pokolaj ri c'o pa tak iwakan chiquiwech ri winak, chi quiri' tiquina'ej chi can man utz ta ri xqui'en, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Y ri discípulos can xebe-wi. Xebe pa tak cocoj tenemit chi xbequitzijoj ri utzilaj rutzij ri Dios. Y xequic'achojrisaj chuka' yawa'i' ronojel lugar anchi' xek'ax-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Y ri Herodes ri gobernador can yeruc'oxaj ronojel ri yeru'on ri Jesús. Pero man nril ta anchique nunimaj, roma jec'o ye'in chi ri nibano ri' ja ri Juan Bautista c'astajinak chic pe. Ri Juan can caminak chic ri tiempo ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Jec'o chuka' ye'in chi ri Jesús ja ri Elías ri xtzolaj-pe. Y ch'aka chic winak niqui'ij chi ri Jesús jun chique ri achi'a' ri xek'alajin rutzij ri Dios ojer can, ri xbec'astaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Y ri Herodes nu'ij: ¿Anchique como achi ri Jesús re'? Roma q'uiy yenc'oxaj chirij. Pero man ja' ta ri Juan Bautista, roma ri Juan ja ren xitako chi xkupix rukul, xcha'. Y ri Herodes xucanola' modo chi xutzu' ta ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Y cuando ri ru-apóstoles ri Jesús xetzolaj-pe chi xbequibana' rusamaj ri Dios, xquitzijoj che ri Jesús ri xqui'en. Y ri Jesús xeruc'uaj-e y xebe pa jun tz'iran rech-ulef. Y ri lugar re' chi ri tenemit rubinan Betsaida. ");
INSERT INTO cakNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Y cuando ri winak xquina'ej ri Jesús y ri ru-apóstoles, xebe chuka' reje'. Y cuando ri winak re' xe'apon riq'uin ri Jesús, raja' can utz xuc'ul quiwech y xtzijon chuka' chique chirij ri ru-gobierno ri Dios. Y chuka' xeruc'achojrisaj yawa'i'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Y cuando ya nika-ka ri k'ij, ri cablajuj discípulos xebe-apo riq'uin ri Jesús y xqui'ij che: Ta'ij chique ri winak re' chi quiebe y te'quicanoj anchi' yebewer-wi, y chuka' te'quicanoj quiway pa tak cocoj tenemit y pa ch'aka chic lugar ri jec'o-pe nakaj. Roma anchi' jojc'o-wi cami, xa man jun winak jec'o, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero ri Jesús xu'ij chique ri ru-discípulos: Tiya' quiway rix. Y reje' xqui'ij che ri Jesús: We' man q'uiy ta wey c'o chi nakaya' chique, xe wo'o' wey y ca'i' quer. Ri winak re' yewa', pero xa ne'kalok'o' wey, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Roma ri winak can je q'uiy. Y xe achi'a' jec'o la'k wo'o' mil. Y ri Jesús xu'ij chique ri ru-discípulos: Ti'ij chique ri winak re' chi quiech'oquie' chi nic'aj tak ciento, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Y can quiri' xqui'en, y ri winak can xech'oquie' conojel. ");
INSERT INTO cakNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Y ri Jesús xeruli'ej pa ruk'a' ri wo'o' wey y ca'i' quer, xtzu'n chicaj y xuya' matiox che ri Dios. Y ri Jesús xeruper ri wey y ri quer, xuya-e chique ri ru-discípulos chi niquiya' chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Can conojel xewa' utz, y can utz xnoj quipa. Y c'a c'o cablajuj chaquech wey y quer xmol can. ");
INSERT INTO cakNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Y jun k'ij ri Jesús c'o aparte roma nu'on orar, y ri ru-discípulos can jec'o chuka' riq'uin. Y c'ajari' ri Jesús xuc'utuj chique ri ru-discípulos: ¿Jin ancu'x (anchique) ren niqui'ij ri winak? ");
INSERT INTO cakNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Y reje' xqui'ij che: Jec'o ye'in chi ja ret ri Juan Bautista. Jec'o ch'aka chic niqui'ij chi jat Elías, ri jun achi ri xuk'alajij ri x-ix che roma ri Dios ojer can. Y jec'o chuka' ri ye'in chi ret jat jun chic chique ri achi'a' ri xek'alajin ri x-ix chique roma ri Dios ojer can, y cami xac'astaj-pe chiquicojol ri caminaki', xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Y raja' xuc'utuj chique ri ru-discípulos: Y rix ¿anchique ni'ij? xcha' chique. Y ri Pedro can ja' xu'ij che ri Jesús: Ja ret ri Cristo, ri jat-takon-pe roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús can xuchelebej chique ri ru-discípulos chi can man tiquitzijoj chi ja raja' ri Cristo ri takon-pe roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Y xu'ij chuka' chique: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, nink'axaj na q'uiy sufrimiento. Can itzel xquitz'et coma ri rijilaj tak achi'a' ri c'o quik'ij, coma ri nimalaj tak sacerdotes y chuka' coma ri maestros chi ri ley. Y xquicamises, pero pa rox k'ij xquic'astaj-pe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Y c'ajari', chique conojel xu'ij-wi: Xa c'o jun nrojo' yirutzeklebej, man tupokonaj-ri' nu'on sufrir, xa can tu'ona' anche'l can ruc'uan ru-cruz. Man tu'on ri nurayij raja'. Xa c'o jun nunojij chi nitiquier nu'on quiri' k'ij-k'ij, can tipe wiq'uin y quirutzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Roma xa c'o jun ri yalan nrojo' ri ruc'aslen we' chech-ulef, man xtiril ta ruc'aslen ri manak xtiq'uis. Pero ri man nupokonaj ta ri', más que nicamises woma ren, can xticolotaj y xtiril ruc'aslen ri manak xtiq'uis. ");
INSERT INTO cakNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Y ¿anchique nuch'ec jun winak xa nic'ue' ta ronojel ri beyomel ri c'o chech-ulef riq'uin y xa man nicolotaj ta? Xa ruyon nuya-ka-ri' chupa ri camic y xtiq'uis jumul. ");
INSERT INTO cakNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Y xa c'o chuka' jun chiwe rix niq'uix nuk'alajij chi jinruniman ren y runiman ri nutzij, ren chuka' ri jin-kajinak-pe chicaj y xinalex chi'icojol, xquiq'uix nin-ij chi ri jun winak ri' wichi ren. Quiri' xtin-en cuando xquipe chic jun mej (bey), cuando xtik'alajin chi can jin Rey-wi, y junan chic nuk'ij riq'uin ri Nata' y je-petenak wiq'uin ri lok'olaj tak ángeles. ");
INSERT INTO cakNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Y can ketzij ri nin-ij chiwe, chi ri Dios can xtoc'ue' pa kawi' y xkojru'on gobernar. Y jec'o chiwe rix ri man xquiecom ta, c'a tiquitzu' na ri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Y c'o yan la'k jun semana ri' cuando ri Jesús tich'o'n chiquiwech ri winak, raja' xerucha' ri Pedro, ri Juan y ri Jacobo chi junan xbe quiq'uin parui' jun juyu' chi xberu'ona' orar. ");
INSERT INTO cakNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Y cuando ri Jesús nu'on orar, xjalataj rech y chuka' ri rutziak yalan rusakil xu'on y nich'ich'an. ");
INSERT INTO cakNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y cuando ri je oxi' ri je-benak riq'uin xquitzu', yetzijon yan chic riq'uin ri Jesús ca'i' achi'a'; jun ja ri Moisés y ri jun chic ja ri Elías. Reje' je rusamajel ri Dios ri xec'ue' ojer can tiempo. ");
INSERT INTO cakNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ri je ca'i' re' jec'o pa jun nimalaj sakil, y yetzijon chirij ri camic ri xtuc'uaj ri Jesús pa Jerusalem; roma ja samaj ri' ri yo'n-pe che roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Y ri Pedro y ri je ca'i' chic, más que c'o quiwaran, xquicoch', y xquitzu' ri nimalaj rusakil ri Jesús, y xequitzu' chuka' ri je ca'i' chic achi'a' ri jec'o riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Y cuando ri ca'i' achi'a' ri' ja niquiya' can ri Jesús chi yebe, ri Pedro xu'ij che ri Jesús: Ajaf, we' utz kabanon. Kabana' oxi' tak jay, jun awichi ret, jun chi ri Moisés y ri jun chic chi ri Elías. Ri Pedro quiri' xu'ij-apo y man reta'n ta anchique roma xch'o'n-apo. Xa man reta'n ta anchique yeru'ij-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Y c'a nitzijon-apo raja' che ri Jesús cuando c'o jun ajawa' (mukul) ri xka-pe pa quiwi'. Y xquixi'j-qui' cuando xquina' chi jec'o chic chupa ri ajawa' (mukul) ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Y chupa ri ajawa' (mukul) c'o Jun ri xch'o'n-pe y xu'ij: Jare' ri Walc'ual, y yalan ninjo'. Can tic'oxaj ri nu'ij raja', xcha-pe ri Dios chicaj. ");
INSERT INTO cakNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Y cuando quic'oxan chic ronojel ri', xquitzu' chi ri Jesús xa ruyon chic c'o. Y reje' q'uiy tiempo xk'ax y man jun anchok che xquitzijoj-wi ri xquitzu' chiri' parui' ri juyu'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Y pa ruca'n k'ij, cuando ri Jesús y ri je oxi' ru-discípulos xeka-pe parui' ri juyu', can je q'uiy winak ri xec'ulu-apo quichi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Y jun achi ri c'o chiquicojol ri winak, xch'o'n-apo che ri Jesús: Maestro, xcha-apo che. Ren xe jun walc'ual c'o. Tabana' favor tatzu' juba', ");
INSERT INTO cakNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","roma c'o jun itzel espíritu nitz'amo richi. Y cuando nutz'om, can nu'on che chi yalan nisiq'uin, y can nupiq'uiq'uiej ruch'acul, y chuka' nu'on che chi niwokok-pe pa ruchi'. Ri itzel espíritu re' yalan ch'a'oj nu'on che ri walc'ual, y c'aronaj nuya' can. ");
INSERT INTO cakNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Romari' xonc'utuj yan favor chique ri a-discípulos chi tiquilesaj ri itzel espíritu re' riq'uin ri walc'ual, pero xa man yetiquier ta, xcha' ri achi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Y ri Jesús ja' xu'ij: Can man jun winak chupa ri tiempo re' ruyo'n ta juba' ránima riq'uin ri Dios. Xa conojel je-satzinak (je-sachinak). ¿Jani' tiempo ninojij rix chi xquic'ue' iwiq'uin? ¿Can jani' tiempo xquitiquier xquixincoch', ni'ij rix? Tac'ama-pe we' ri awalc'ual, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Y cuando ri ala' xapon-apo riq'uin ri Jesús, ri itzel espíritu riq'uin ruchuk'a' xupiq'uiq'uiej ri ala' y xutorij pa ulef. Ri Jesús cof xch'o'n che ri itzel espíritu, y xu'ij che chi tel-e riq'uin ri ala'. Y ri Jesús xucol ri ala' ri' chech ri itzel espíritu, y xujach-e che ri rutata'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y conojel ri winak xsatz quino'j (xsach quic'u'x) cuando xquitzu' chi ri Dios can yalan-wi nim. Y cuando ri winak yetzijon chiquiwech roma xsatz quino'j (xsach quic'u'x) chirij ri ala' ri xc'achoj roma ri Jesús, ri Jesús xu'ij chique ri ru-discípulos: ");
INSERT INTO cakNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tic'oxaj jabel ri tzij re', y man timestaj: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xquijach pa quik'a' ri winak ri itzel yetz'eto wichi, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Y ja tzij re' man xqui'en ta entender ri discípulos, roma ewan chiquiwech. Y niquixi'j-qui' niquic'utuj che ri Jesús anchique ri xu'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Y ri ru-discípulos ri Jesús xquich'ojij chiquiwech ancu'x (anchique) chique reje' ri más c'o ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero ri Jesús can reta'n anchique niquinojij pa tak cánima ri ru-discípulos. Romari' raja' xberuc'ama-pe jun ac'ual y xupoba' riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Y xu'ij chique ri ru-discípulos: Xa c'o jun ri jinruniman y can niquicot nuc'on-ka jun ac'ual ri anche'l re', man xe ta nuc'on-ka ri ac'ual, xa can xquiruc'on-ka chuka' ren. Y ri yiruc'on-ka ren, can nuc'on-ka ri takayon-pe wichi. Y xa chiwech rix c'o jun ri manak ruk'ij, xa jari' ri más c'o ruk'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Y xpe ri Juan xu'ij che ri Jesús: Maestro, xcha' che. Roj xkatzu' jun achi ri pa abi' ret yerulesaj itzel tak espíritus. Pero roma xa man kaq'uin ta roj c'o-wi, xka'ij che que man chic tu'on quiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Y ri Jesús xu'ij che ri Juan: Man chic ti'ij quiri' che. Roma ri man ruyowal ta chakij roj, can kaq'uin roj c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Y cuando xa noka yan k'ij chi ri Jesús nitzolaj-e chicaj, raja' can xunojij chi nibe pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Y jec'o chuka' ri xerutak-e na'ey. Y ri xetak-e, xebe pa jun co'l tenemit ri c'o pa Samaria, chi xbequicanoj jun jay anchi' xte'uxlan-wi ri Jesús y ri je-benak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri winak aj-chiri' pa tenemit man xquijo' ta chi xc'ue-ka ri Jesús quiq'uin, roma xquina'ej chi xa pa Jerusalem benak-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Cuando ri discípulos quibinan Jacobo y Juan xquina'ej chi ri winak man niquijo' ta ri Jesús, xqui'ij che ri Jesús: Ajaf, ¿najo' nakac'utuj chi tika-pe k'ak' chicaj pa quiwi' ri winak re' chi yeruq'uis, anche'l xu'on ri Elías, ri jun achi ri xk'alajin rutzij ri Dios ojer can? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Y ri Jesús xerutzu' y xeruch'olij. Y xu'ij chique: Rix ni man iweta'n ta anchique espíritu c'o iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Roma ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, man xipe ta we' chech-ulef chi yenq'uis winak, ren xa xipe chi yencol, xcha'. Y ri Jesús y ri ru-discípulos xebe chic pa jun tenemit co'l oc. ");
INSERT INTO cakNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Y cuando reje' ja je-benak, c'o jun achi xch'o'n-apo che ri Jesús y xu'ij: Ajaf, ren ninjo' jatintzeklebej ri xabachi' (xama'anchi') xcatapon-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero ri Jesús xu'ij che ri achi: Ri utif, can c'o-wi quijul anchi' yec'ue-wi; y quiri' chuka' ri chicop ri c'o quixic' ri yebe chicaj, can c'o chuka' quisoc. Pero ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can man jun wocho anchi' yinuxlan-wi, xcha' ri Jesús che ri achi ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Y ri Jesús xu'ij che jun chic achi: Quinatzeklebej. Pero ri achi re' xu'ij: Ajaf, ren can ninjo-wi jatintzeklebej, pero taya' lugar chue chi ninmuk na e ri nata', c'ajari' xquibe chawij. ");
INSERT INTO cakNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero ri Jesús xu'ij che ri achi re': Ri je caminak quiemuk coma ri je caminaki' chupa ri quimac. Pero ret, atzijoj ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Y c'o chic jun ri x-in che ri Jesús: Ajaf, ren ninjo' jatintzeklebej. Pero na'ey, taya' lugar chue chi yibech'o'n can chique ri nte-nata' y chique ri je wach'alal, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Pero ri Jesús xu'ij che: Ri achi ri nic'uan ri arado, chi nusamajij jun ulef, man utz ta nitzu'n can chirij, roma man utz ta ntel ri rusamaj. Y quiri' chuka' ri winak ri nunimaj ri Dios, man utz ta chi nutzu' ri yebanataj can chirij. Roma xa quiri' xtu'on, can man utz ta chi nisamaj pa rusamaj ri Dios chi nutzijoj ri ru-gobierno ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Y cuando xebanataj yan ronojel re', ri Ajaf Jesús xerucha' ch'aka chic achi'a' chi yesamaj riq'uin. Raja' xerucha' setenta achi'a', chi xerutak-e chi caca'. Xerutak pa tak tenemit y pa ch'aka chic lugar anchi' xtapon-wi raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Y ri Jesús xu'ij chique ri achi'a' ri xerucha': Can ketzij-wi chi ri samaj chi nitzijos rutzij ri Dios, can q'uiy; pero ri samajel xa man je q'uiy ta. Romari' tic'utuj che ri Rajaf ri samaj, chi quierutaka-pe más samajel chiquicojol ri winak ri nic'atzin chi niquic'oxaj rutzij. ");
INSERT INTO cakNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Y cami can jixintak-e. Y tina-iwi', rix xa jix anche'l alaj tak ral oveja ri jixapon chiquicojol winak je anche'l utif. ");
INSERT INTO cakNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Y man tic'uaj ichim, ni man tic'uaj mero, y man tic'uaj chuka' jun chic par ixajab. Y chuka' can man quixpa'e-ka chi ye'iben saludar ri winak pa tak bey. ");
INSERT INTO cakNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Y cuando jixapon pa jun jay, ri na'ey niben, ja ri ye'iben saludar. Y ni'ij chique: Ja' ta ri uxlanen chi ri Dios ri xtic'ue' iwiq'uin chupa ri jay re'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Y xa chupa ri jay ri' ri winak xquiequicot iwiq'uin chi niquic'oxaj rutzij ri Dios, ri uxlanen chi ri Dios can xtic'ue-wi quiq'uin. Pero ri winak ri man utz ta niquic'oxaj rutzij ri Dios, ri uxlanen man xtic'ue' ta can quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Y cuando xquixapon pa jun tenemit, can quixc'ue-ka chupa ri jay ri anchi' utz nic'ul iwech, titija' y tikumu' ri xtisipes chiwe; roma jun samajel can nic'atzin nitoj roma ri samaj ri nu'on. Y man tijal ri jay anchi' xixoc-wi na'ey. Xa can chiri' quixc'ue-wi ri jani' tiempo xquixc'ue' chupa ri tenemit. ");
INSERT INTO cakNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Y quiri' chuka' tibana' cuando jixapon xabachique (xama'anchique) tenemit anchi' utz nic'ul iwech. Can titija' ronojel ri nisipes chiwe. ");
INSERT INTO cakNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Quie'ic'achojrisaj chuka' ri yeyawaj ri jec'o chiri', y ti'ij chique: Ri ru-gobierno ri Dios, nakaj chic c'o-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero xa jixapon pa jun tenemit anchi' man utz ta nic'ul iwech, quixel-pe pa tak bey chi ri tenemit y ti'ij chique ri winak: ");
INSERT INTO cakNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Ri pokolaj chi ri tenemit re' ri c'o chikakan, nakatota' can chiwech, chi nitemaj chi can man utz ta ri xiben roma man xic'ul ta jabel kawech. Y titemaj chuka' chi ri ru-gobierno ri Dios, nakaj chic c'o-wi, y rix can xsuj chiwe, quixcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Y ri Jesús xu'ij-e chuka' chique: Chupa ri k'ij cuando ri winak xquie'an juzgar roma ri Dios, ri winak chi ri tenemit anchi' man utz ta xc'ul iwech, can más nim ri castigo ri xtika pa quiwi', que chech ri castigo ri xtiyo'x pa quiwi' ri aj-Sodoma. ");
INSERT INTO cakNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Romari' juya' (juyu') quiwech ri jec'o pa tenemit Corazín, y chuka' juya' (juyu') quiwech ri jec'o pa tenemit Betsaida, roma can q'uiy milagros xe'an chiquiwech y man xquinimaj ta rutzij ri Dios. Roma xa ta pa tenemit Tiro y Sidón xe'an-wi ri milagros re', ri winak chi ri ca'i' tenemit ri' xquiya' yan ta can ri quimac y niqui'en yan ta ri nrojo' ri Dios, quicusalo'n ta chic quitziak richi bis, y quiyalo'n ta chaj chiquij, chi quiri' k'alaj chi yebison roma yalan ri quimac ri jequibanon. ");
INSERT INTO cakNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Pero chupa ri k'ij cuando xti'an juzgar ri rech-ulef, ri jec'o pa Corazín y ri jec'o pa Betsaida can más-wi castigo xtika pa quiwi', que chiquiwech ri aj-Tiro y aj-Sidón. ");
INSERT INTO cakNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Y ri jec'o pa tenemit Capernaum can niquinojij chi yebe chicaj riq'uin ri Dios y can yalan quik'ij xtiyo'x. Pero xa man quiri' ta. Xa xtikases quik'ij, roma xa c'a chupa ri lugar chi castigo xquiebeka-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Y anchique winak ri xquixruc'on-ka jabel chi nuc'oxaj rutzij ri Dios, can ja ren ri yiruc'oxaj. Y ri jun ri man nrojo' ta jixruc'oxaj roma rutzij ri Dios, can ja chuka' ren ri man yiruc'oxaj ta; y ri man yiruc'oxaj ta ren, can quiri' chuka' nu'on che ri Dios ri takayon-pe wichi, xcha-e ri Jesús chique ri setenta achi'a' ri xerucha'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Y cuando xetzolaj-pe ri setenta achi'a' roma xbequibana' ri samaj ri bin-e chique y xeloka riq'uin ri Jesús, yalan yequicot, y xqui'ij che: Ajaf, ri itzel tak espíritus can xquinimaj katzij cuando pa abi' ret xojch'o'n-wi chique. ");
INSERT INTO cakNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Y ri Jesús xu'ij chique: Ja', can ketzij ri ni'ij. Roma ren can xintzu' chi ri Satanás xuna' yan chi xch'acataj, roma can anche'l nu'on ri rayo chicaj, quiri' xu'on raja' cuando xtzak-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ren can nuyo'n-wi uchuk'a' chiwe chi nich'ec ruchuk'a' ri itzel, y chuka' más que jixpa'e' pa quiwi' cumetz y alacrán ri yeruya' pa ibey, can man jun anchique xtic'ulumaj pa ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero rix man quixquicot xe roma ri itzel tak espíritus jixquinimaj. Más quixquicot pa tak iwánima roma can tz'iban ri ibi' chicaj riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Y chupa ri misma hora ri', ri Espíritu Santo can xu'on che ri Jesús chi yalan xquicot pa ránima; y ri Jesús xu'ij: Matiox ninya' chawe Nata' Dios, ret ri jat Rajaf ri rocaj y ri rech-ulef, roma man xak'alajij ta ri utzilaj atzij chiquiwech ri winak ri can niquina' chi yalan q'uiy quieta'n. Xa ja chiquiwech ri winak ri manak más quieta'n xak'alajij-wi ri utzilaj atzij. Can quiri-wi Nata' Dios, roma jari' ri najo' ret, xcha' ri Jesús pa ru-oración. ");
INSERT INTO cakNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Y c'ajari' raja' xu'ij: Ri Nata' Dios can ronojel ruyo'n-pe pa nuk'a'. Y man jun chic etamayon jin ancu'x (anchique) ren, xe ri Nata' ri etamayon. Y man jun chuka' etamayon ancu'x (anchique) ri Nata', xe ren ri Ralc'ual, y ri winak anchok che xtinjo' xtink'alajij-wi ren, xtuna'ej ancu'x (anchique) ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Y ri Jesús xerutzu' ri ru-discípulos y xe chique reje' xu'ij-wi: Jabel quixquicot rix, roma can nitzu' riq'uin ri iwech. Y chuka' can jabel quiequicot ri ch'aka chic winak ri niquitzu' ronojel re'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Y can nin-ij chiwe, chi je q'uiy ri achi'a' ri xek'alajin ri tzij ri x-ix chique roma ri Dios y ri reyes ri xec'ue' ojer can, reje' can c'o ta xquijo' xquitzu' ri nitzu' rix cami, y man xquitzu' ta. Xquijo' ta chuka' xquic'oxaj ri nic'oxaj rix cami, y man xquic'oxaj ta chuka', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Y c'o jun maestro chi ri ley xcataj-pe y xch'o'n-apo che ri Jesús, roma nrojo' nutojtobej ri Jesús. Maestro, xcha' che. ¿Anchique utz nin-en ren chi quiri' ninwil ri c'aslen ri man niq'uis ta? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xu'ij che: ¿Anchique nu'ij ru-ley ri Moisés? ¿Y anchique na'an entender ret? ");
INSERT INTO cakNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y ri maestro xu'ij che ri Jesús: Ri ley nu'ij chi tajo' ri Dios ri Awajaf. Tajo' riq'uin ronojel awánima. Tajo' chupa ronojel ri ac'aslen, riq'uin ronojel awuchuk'a', y riq'uin chuka' ri ano'j (ana'oj). Y can anche'l najo-ka-awi' ret, can quiri' chuka' quie'ajo' conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y ja cuando ri Jesús xu'ij che ri maestro: Can ketzij ri xa'ij. Cami c'a, xa xta'an ronojel re', xtawil ri c'aslen ri man niq'uis ta, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ri maestro can xrojo' xuto' ri rutzij, romari' xuc'utuj chic apo che ri Jesús y xu'ij: ¿Ancu'x (Anchique) ri winak ri utz yenjo' anche'l ninjo-ka-wi' ren? ");
INSERT INTO cakNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Y ri Jesús c'ajari' xutzijoj jun ejemplo che ri maestro: C'o jun achi ri elenak-pe pa tenemit Jerusalem y xulan-ka chi napon c'a pa tenemit Jericó. Pero ri achi re' xebe'el-pe elek'oma' chirij pa bey, y ri elek'oma' ri' ronojel xquimaj che. Hasta ri rutziak ri rucusan xquimaj-e che. Ri elek'oma' xebe, pero na'ey yalan xquich'ey can. Ri achi xpoq'uie' can chiri' pa bey anche'l jun caminak. ");
INSERT INTO cakNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Y c'o jun sacerdote ri petenak chuka' chupa ri bey ri'. Y cuando ri sacerdote re' xutzu' chi poc'ol ri achi chiri' pa bey, ja chic ri jun ruchi-bey xk'ax-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Y quiri' chuka' jun achi levita, ri yeto'n quichi ri sacerdotes pa rocho ri Dios, petenak chuka' chupa ri bey ri'. Y cuando ri levita re' xapon chupa ri lugar ri', xutzu' chuka' ri achi, y can anche'l xu'on ri sacerdote, can quiri' chuka' xu'on raja'. Xe xutzu' ri achi poc'ol pa bey, xa ja chuka' ri jun chic ruchi-bey xk'ax-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero c'o jun achi aj-Samaria ri petenak chuka' chupa ri bey ri', y can nik'ax na riq'uin ri achi ri poc'ol can pa bey, ri achi ch'ayon can coma elek'oma'. Y cuando ri aj-Samaria xutzu' ri achi poc'ol pa bey, can xujoyowaj rech roma ri rubanon. ");
INSERT INTO cakNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Romari' xbe-apo riq'uin, xutzu' anchique rubanon, xeruk'omaj che aceite olivo y vino ri anchi' socotajnak-wi, y xerupisla' chuka' che tziak. C'ajari' ri achi aj-Samaria xuya-e chirij ruquiej y xuc'uaj c'a pa jun posada. Y xuchajij ri jun ak'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ruca'n k'ij cuando ri aj-Samaria nibe yan, ja xulesaj ru-mero y xuya' can ca'i' denarios che ri rajaf ri posada, y xu'ij che: Tabana' cuenta ri jun achi re'. Y xa man xcatru'on ta ri mero re', cuando ren xquitzolaj-pe xtintoj chawe ronojel. ");
INSERT INTO cakNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","C'ajari' ri Jesús xuc'utuj che ri maestro: Chawech ret ¿ancu'x (anchique) chique ri je oxi' achi'a' ri can anche'l nrojo-ka-ri' raja', can quiri' chuka' xrojo' ri achi ri xka pa quik'a' elek'oma'? xcha' ri Jesús che ri maestro. ");
INSERT INTO cakNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Y ri maestro xu'ij: Ja ri achi ri xjoyowan rech, xcha'. Y ri Jesús xu'ij che ri maestro: Cami abana' ret chuka' anche'l xu'on ri achi aj-Samaria. ");
INSERT INTO cakNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Y Jesús xutz'om chic rubey y xapon pa jun ch'uti' tenemit. Y chiri' chupa ri ch'uti' tenemit ri' c'o ri ixok rubinan Marta, y ja raja' xuc'ul rech ri Jesús pa rocho. ");
INSERT INTO cakNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ri ixok re' c'o jun rach'alal rubinan María. Y ri María re' xch'oquie' chirakan ka ri Jesús, chi quiri' nuc'oxaj rutzij ri Dios ri nutzijoj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ri Marta xa man quiri' ta xu'on. Raja' xa rutz'amon ch'u'j riq'uin rusamaj. Romari' ri Marta xapon riq'uin ri Jesús y xu'ij che: Ajaf, ¿man natzu' ta como chi ri María nuyon ren jinruyo'n can chech ri samaj? Ta'ij che chi quiruto' juba', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Pero ri Ajaf Jesús xu'ij che: Marta, Marta, ret q'uiy ri nanojij, y satzinak awánima (sachinak ac'u'x) roma q'uiy ex ri najo' na'an. ");
INSERT INTO cakNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Pero xe jun ri más nic'atzin y más utz, y jari' ri xucha' ri María. Y ri xucha' raja', man jun xtimajo che. ");
INSERT INTO cakNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Y jun mej (bey) chic, ri Jesús c'o pa jun lugar, y nu'on orar. Y cuando xtane-ka riq'uin ri oración, jun chique ri ru-discípulos xu'ij che: Ajaf, kojatijoj chi naka'an orar, anche'l ri Juan Bautista xerutijoj ri ru-discípulos chi niqui'en orar, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y ja cuando ri Jesús xu'ij chique ri ru-discípulos: Cuando xtiben orar, tibana' jun oración anche'l re': Katata' Dios jatc'o chila' chicaj, can conojel ta ri winak xtiquiya' ta ak'ij, y nim ta xtiqui'en che ri lok'olaj abi'. Y xtoka yan ta ri k'ij cuando ja ret ri xcabano gobernar. Y ja' ta ri najo' ret can jari' ta ri xtibanataj we' chech-ulef, anche'l niqui'en ri jec'o awiq'uin chicaj. ");
INSERT INTO cakNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Y taya' chuka' ri kaway ri nic'atzin chake k'ij-k'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Y can anche'l yekacoch' (yekacuy) conojel ri winak ri c'o quitzelal niqui'en chake, quiri' ta xta'an kaq'uin roj, xtacoch' (xtacuy) ta ri kamac ri naka'an chawech. Y man taya' lugar chi ri itzel nu'on chake chi jojtzak pa mac. Can kojacolo' chech, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Y Jesús xu'ij chuka' chique ru-discípulos: Xa jun chiwe rix napon pa nic'aj-ak'a' riq'uin jun ru-amigo y nu'ij ta che: Tabana' favor chue, ninjal oxi' away. ");
INSERT INTO cakNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Roma c'o jun nu-amigo naj petenak-wi y xoka wiq'uin, y ren xa man jun wey c'o wiq'uin chi ninya-apo che. Romari' tabana' favor chue, xcacha-apo che. ");
INSERT INTO cakNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Y ri anchok che nac'utuj-wi-apo ri wey, c'a chech ruch'at xtich'o'n-pe chawe y xtu'ij: Tabana' favor man quinanak, roma ri ruchi-jay xa xintz'apij yan y ri ac'uala' xa wiq'uin ren yewer-wi. Romari' manak modo yicataj chi ninya-e chawe ri najo'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Y ri Jesús xu'ij chique ri ru-discípulos: Can ketzij-wi nin-ij chiwe, chi ri jun ri nic'utux-apo ri wey che, ne'cataj-pe, pero man roma ta je amigo riq'uin ri nic'utun-apo ri wey che; man roma ta ri' xte'cataj-pe. Raja' ne'cataj-pe y neruya-pe ronojel ri nic'atzin che, chi quiri' titane-ka ri jun ri nic'utun-apo ri wey che. ");
INSERT INTO cakNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Y ren nin-ij chiwe rix, xcha' ri Jesús. Tibana' anche'l ri xu'on ri achi ri xbec'utun wey. Tic'utuj che ri Dios ri nic'atzin chiwe y raja' xtuya-pe chiwe. Ticanoj y xtiwil ri nijo'. Tic'ojc'a-apo ri ruchi-jay y jixc'oxex-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Romari', xa can riq'uin ronojel iwánima nic'utuj che ri Dios, raja' can xtuya-wi-pe chiwe ri nic'utuj. Xa rix can nicanoj, can xtiwil-wi ri nicanoj. Y xa rix xtic'ojc'a' ri ruchi-jay, can xquixc'oxex-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Y rix ri jix tata'j chic, ¿jixtiquier como niya' jun abaj pa ruk'a' jun iwalc'ual, cuando nuc'utuj jun ruway chiwe? ¿O niya' ta jun cumetz pa ruk'a', cuando ri ac'ual xa jun quer nrojo'? ");
INSERT INTO cakNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O niya' ta chuka' jun alacrán pa ruk'a', cuando ri ac'ual xa jun sakmolo' ri nuc'utuj chiwe? ");
INSERT INTO cakNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Rix man jixtiquier ta niben quiri' chique ri iwalc'ual. Más que rix itzel ino'j (ina'oj), pero man jun mej (bey) niya' jun itzel ex chique. Rix ja ri utz tak ex ri niya'. Más chech ri' nu'on ri Itata' ri c'o chicaj. Raja' can nuya-wi ri Espíritu Santo chique ri can niquic'utuj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jun k'ij c'o-apo chech ri Jesús jun achi mem, raja' quiri' rubanon roma c'o jun itzel espíritu riq'uin. Y cuando ri Jesús xu'ij che ri itzel espíritu chi tel-e riq'uin ri achi ri', ri itzel espíritu can xel-wi-e, y ri achi ri man nich'o'n ta, xch'o'n chic jun mej (bey). Y ri winak ri xquitzu' ri xbanataj, can xsatz quino'j (xsatz quic'u'x). ");
INSERT INTO cakNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero jec'o chuka' jujun xqui'ij: Ri Jesús c'o ri Beelzebú riq'uin, ri cajaf ri itzel tak espíritus. Y ja ri Beelzebú ri niyo'n ruchuk'a' chi quiri' nitiquier yerulesaj ri itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y jec'o ch'aka chic, xe chi niquitojtobej ri Jesús xqui'ij che chi tu'ona' jun milagro chicaj, chi tuc'utu' xa can ja-wi ri Dios ri takayon-pe richi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús reta'n ri niquinojij ri achi'a' ri', romari' xu'ij chique: Xa ta ri winak chi jun rech-ulef man junan ta yenojin y ca'i' quiwech niqui'en-ka, nipe ayowal chiquicojol. Y re' man utz ta, roma man xquielayoj ta xquiec'ue' junan chech-ulef. Y quiri' chuka' pa jun jay, xa jalajoj quiwech niqui'en-ka y niquijach-ka-qui', manak chic xquiec'ue' junan chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Y quiri' chuka' ri Satanás, man utz ta nu'on-ka ayowal quiq'uin ri rusamajel, roma xa quiri' nu'on, man utz ta xa chirij raja' mismo nicataj-ka. Roma xa quiri' nu'on, ruyon nic'ue' can y ch'anin nitzak. Y ren quiere' nin-ij chiwe, roma rix ni'ij chi ren c'o ri Beelzebú wiq'uin y romari' yitiquier yenlesaj ri itzel tak espíritus. ");
INSERT INTO cakNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Rix quiri' ninojij chuij ren, chi c'o ri Beelzebú wiq'uin romari' yitiquier yenlesaj ri itzel tak espíritus, ¿pero anchique ninojij rix chiquij ri yetzekleben iwichi? ¿Ancu'x (Anchique) yoyo'n uchuk'a' chique reje' chi yetiquier yequilesaj itzel tak espíritus chuka'? Romari' can ja' ri niqui'en reje' nuk'alajij chi rix man ja' ta ri ye'ibij. ");
INSERT INTO cakNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ren yitiquier yenlesaj ri itzel tak espíritus, roma can ja ri ruchuk'a' ri Dios c'o wiq'uin. Romari' titemaj chi ri ru-gobierno ri Dios c'o yan chi'icojol cami. ");
INSERT INTO cakNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ri Satanás anche'l jun achi ri can yalan ruchuk'a', y c'o ronojel ch'ich' riq'uin chi nuto-ri' roma nuchajij ri rocho. Ri achi re' can jabel-wi nuchajij ri rocho, y man jun nitiquier nimajo che ri c'o riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero cuando noka jun ri c'o más ruchuk'a' chech raja', ja nich'acataj, y nimaj che ronojel ri c'o riq'uin chi nuto-ri' y can ruyo'n ránima riq'uin. Y ri jun ri c'o más ruchuk'a', yerujachala' ronojel ri xerulesaj-e che ri achi ri xuch'ec can. ");
INSERT INTO cakNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Y romari', ri man wiq'uin ta ren nisamaj-wi, xa chuij ren nisamaj-wi. Y ri man nito'n ta wichi, xa jari' ri niyuju ronojel ri yenben ren, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Cuando c'o jun itzel espíritu ntel-e pa ránima jun winak, ri itzel espíritu re' nucanoj anchi' nuxlan-wi pa tak lugar tz'iran y can chaki'j. Y cuando ri jun itzel espíritu re' nuna' chi can man jun uxlanen nril, nunojij-ka: Más utz yitzolaj chic pa ránima ri winak anchi' xinel-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Y cuando nitzolaj chic pe pa ránima ri winak anchi' elenak-wi-e, nril anche'l jun jay meson y banon can utz ru'onic. ");
INSERT INTO cakNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Y ri itzel espíritu re' yeruc'om-pe je wuku' chic itzel tak espíritus ri más je itzel, y conojel ye'oc pa ránima ri winak. Y ri winak anchok riq'uin yebec'ue-wi ri itzel tak espíritus re', más peor nu'on ruc'aslen chech ri rubanon-pe na'ey. ");
INSERT INTO cakNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Y cuando ri Jesús nutzijoj ri tzij re' chiquiwech q'uiy winak ri quimolon-qui' riq'uin, ja' cuando c'o jun ixok chiri' chiquicojol, riq'uin ruchuk'a' xbech'o'n-pe y xu'ij: Ri te'j ri xalan awichi chech-ulef y xatruq'uiytisaj riq'uin rutz'um (rume'), can tiquicot pa ruc'aslen, xcha' ri ixok che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Y ri Jesús xu'ij: Más quiequicot pa quic'aslen ri yec'oxan rutzij ri Dios y niqui'en ronojel ri nu'ij ri rutzij raja', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Y cuando q'uiy winak ri niquimol-apo-qui' chirij ri Jesús, xpe raja' xu'ij chique ri winak ri': Ri winak chi ri tiempo re' yalan je itzel y man jinquinimaj ta. Romari' niquijo' chi ren nin-en jun milagro chiquiwech chi jinquinimaj. Pero man ja' ta ri niquijo' reje' ri xtin-en. Xa can xe ri xbanataj riq'uin ri Jonás, ri jun achi ri xk'alajin ri x-ix che roma ri Dios ojer can, xe ri' ri retal ri c'o can chique reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ri xuc'ulumaj ri Jonás, xuc'ut chiquiwech ri winak ri xec'ue' ojer can chupa ri tenemit Nínive, chi can ja ri Dios takayon-pe richi. Y quiri' chuka' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, ri xtinc'ulumaj ren xticuses chi jun retal chiquiwech ri winak cami. ");
INSERT INTO cakNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Y cuando xtapon ri k'ij chi ye'an juzgar conojel ri winak chi ri tiempo re', xticataj-pe ri jun reina ri aj-Sabá y xtu'ij chi can man utz ta xqui'en ri winak ri jec'o cami, roma man xquinimaj ta. Roma cuando xc'ase' ri jun reina ri', yalan naj xpe-wi chi xoruc'oxaj runo'j (runa'oj) ri Salomón, ri rey chi ri Israel. Y cami jinc'o ren ri c'o más nuk'ij chech ri rey Salomón ri xc'ue' ojer can, y xa man jinquinimaj ta ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Y cuando xtapon chuka' ri k'ij chi ye'an juzgar ri winak chi ri tiempo re', xquiec'astaj-pe ri winak aj-Nínive. Ri winak ri' xtiqui'ij chi can man utz ta xqui'en ri winak ri jec'o cami, roma man xinquinimaj ta. Y ri winak ri xec'ue' pa tenemit Nínive ri ojer can, can xe xquic'oxaj rutzij ri Dios ri xutzijoj ri Jonás chique, can ja' xquiya' can quimac y xqui'en ri nrojo' ri Dios. Y cami jinc'o ren ri c'o más nuk'ij chech ri Jonás, y xa man jinquinimaj ta ri winak, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Y man jun winak nutzaj jun luz y nuya' anchi' man k'alaj ta, o nuya' ta chuxe' jun cajón. Man jun nibano quiri'. Jun ri nutzaj jun luz, chicaj nuya-wi chi quiri' yerusakrisaj ri ye'oc-apo pa jay. ");
INSERT INTO cakNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ri wechaj chuka' je anche'l jun luz. Roma xa ri iwech je utz, can jixc'o pa jun sakil. Pero xa ri iwech man je utz ta, can pa k'eku'm jixc'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Romari' tibana' cuenta iwi', chi quiri' ri sakil ri ruyo'n ri Dios pa iwánima man xtijalataj ta y xtu'on jun k'eku'm. ");
INSERT INTO cakNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Roma xa can jixc'o pa jun sakil, can manak-wi k'eku'm iwiq'uin, y quiri' can jixtzu'n-wi jabel. Re' can junan-wi riq'uin cuando tzajon jun luz chi nu'on sakil y jabel sakil nuya' chiwe. ");
INSERT INTO cakNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Y cuando Jesús xtane-ka nitzijon chiquiwech ri winak, c'o jun chique ri achi'a' fariseos xu'ij che ri Jesús chi tu'ona' favor nibe ta juba' chirocho, chi nu'on jun wa'in. Y ri Jesús can xbe-wi. Raja' xapon y xch'oquie' chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Y ri achi fariseo, can anchique la xutzu' ri Jesús, roma xch'oquie-apo chuchi' mesa y man xuch'aj ta ruk'a' anche'l niqui'en conojel israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Y ri Ajaf Jesús xutzu' ri nunojij ri fariseo, y romari' xu'ij che: Rix fariseos xa jix anche'l ri lak ri jabel ch'ajch'oj quij pero ri quipa xa tz'il-tz'il. Rix can nic'ut chiquiwech ri winak chi utz ri niben, pero pa tak iwánima man quiri' ta, roma xa nojinak riq'uin elak', y nojinak riq'uin itzel tak ex. ");
INSERT INTO cakNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Can jix nacanak. ¿Can man iweta'n ta c'a chi ri xbano ri kach'acul, xu'on chuka' jun kánima? ");
INSERT INTO cakNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Romari' rix utz chi ja ri iwánima tich'ajch'ojij, chi quiri' cuando ch'ajch'oj chic ri iwánima, xtalex-pe iwiq'uin chi ye'ito' chuka' ri winak ri manak quibeyomal, y quiri' xquixch'ajch'ojir. ");
INSERT INTO cakNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Juya' (Juyu') iwech rix fariseos! roma hasta ri jubulaj tak k'ayis, ri ruda y ronojel quiwech ichaj ye'ich'up, y chitak-ba' chitak-ba' ye'ilesaj can chique chi ntoc i-diezmo chi niya' che ri Dios. Ronojel ri' can utz, pero imestan chi na'ey can nic'atzin chi utz niben quiq'uin ri winak y chi ye'ijo' anche'l nrojo' ri Dios. Can utz tibana' quiq'uin ri winak y can quie'ijo' anche'l nrojo' ri Dios, roma can jari' ri más nic'atzin; y c'ajari' quie'ibana' ri ch'aka chic ex. ");
INSERT INTO cakNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Juya' (Juyu') iwech rix fariseos! roma can ja ri na'ey tak ch'aquet ye'icanoj pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios, chi quiri' ni'ix chiwij chi yalan ik'ij. Y can yalan chuka' nika chiwech jix-an saludar anchi' niquimol-wi-qui' q'uiy winak. ");
INSERT INTO cakNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Juya' (Juyu') chuka' iwech rix maestros chi ri ley y rix fariseos roma can ca'i' ipalaj! Rix can jix anche'l ri jul anchi' je-mukun can caminaki'; roma cuando man ni'an ta chic ru'onic rui', man k'alaj ta chic xa c'o je-mukun chiri', romari' ri winak yek'ax pa ruwi'. Roma man quieta'n ta chi xa pa ruwi' jun caminak yek'ax-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Pero jun chique ri maestros chi ri ley xu'ij che ri Jesús: Maestro, xcha' raja'. Cuando ret na'ij quiri', man xe ta chic chique ri fariseos jach'o'n-wi, xa chuka' chake roj jach'o'n-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Y ri Jesús xu'ij che ri maestro: ¡Juya' (Juyu') iwech rix chuka' ri maestros chi ri ley! roma cuando ye'itijoj ri winak, niya' nimalaj tak eka'n (aka'n) chiquij, ri yalan cuesta yec'uax. Ri eka'n (aka'n) ri' xe chiquij ri winak niya-wi y rix man nisiloj ta che jun rui-ik'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Juya' (Juyu') iwech rix maestros! roma rix niben ru'onic ri xan ri quichi ri panteón anchi' je-mukun-wi ri achi'a' ri xek'alajin rutzij ri Dios ojer can, y reje' xa ja ri iwati't-imama' ri xecamisan quichi. ");
INSERT INTO cakNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Cami k'alaj chi rix can nika chiwech ri itzel tak ex ri xequi'en ri iwati't-imama' ri ojer can, roma ja reje' xecamisan ri rusamajel ri Dios, y rix niben ru'onic anchi' je-mukun-wi can. ");
INSERT INTO cakNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Y romari' ri Dios reta'n xu'ij: Xquientak achi'a' quiq'uin ri nuwinak; achi'a' ri xquiek'alajin ri nutzij ri nin-ij chique, y xquientak chuka' apóstoles chiquicojol. Pero ri winak jec'o xquiequicamisaj, y jec'o ri xtiqui'en chique chi niqui'en sufrir, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Romari' xu'ij ri Jesús, ri winak ri jec'o cami, ja reje' ri xtiquikalej ri quicamic ri achi'a' ri xecamises ojer can roma xquik'alajij rutzij ri Dios. Pa quiwi' reje' xtika-wi quicamic ri achi'a' ri', ri nitiquier-pe c'a pa ruticribel pe ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Nitiquier-pe riq'uin ri rucamic ri Abel c'a riq'uin ri rucamic ri Zacarías. Y jare' ri xcamises chucojol ri rocho ri Dios y ri altar ri c'o chech rocho ri Dios. Romari' nin-ij chiwe, chi ja ri winak ri jec'o cami, ja reje' ri xquiewakalen ri quicamic ri achi'a' je rusamajel ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Juya' (Juyu') iwech rix maestros chi ri ley! roma pa ik'a' rix c'o-wi ri no'j (na'oj), roma can iweta'n anchique modo jun winak ntoc richi ri Dios, pero rix xa man jix-oconak ta richi ri Dios y man nijo' ta chi ri winak ye'oc richi ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Cuando ri Jesús xu'ij ronojel re', ri maestros chi ri ley y ri achi'a' fariseos yalan xcataj quiyowal. Y romari' reje' ronojel niquic'utuj-apo che ri Jesús xe chi niquinak. ");
INSERT INTO cakNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ri maestros chi ri ley y ri achi'a' fariseos, can man niquiya' ta can juba' ri Jesús, c'o ta niquijo' niquic'oxaj chi raja' c'o jun tzij ri man utz ta ri nu'ij y nika ta pa quik'a', chi niquisujuj. Pero ri Jesús can ronojel utz yeru'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Y ri winak can je miles xquimol-apo-qui' chiri'. Romari' can niquichocomila-qui' y niquixak'ala' rui-cakan. Y ri Jesús xtzijon-ka na'ey xe quiq'uin ri ru-discípulos y xu'ij chique: Tibana' cuenta iwi' chech ri quino'j (quina'oj) ri achi'a' fariseos. Ri quino'j (quina'oj) reje' can anche'l ri levadura, roma can ca'i' quipalaj. ");
INSERT INTO cakNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Roma ronojel ri man k'alaj ta c'o, xtik'alajin-pe. Y ronojel ri tz'apel can rij, xtel-pe pa sakil, y ronojel xtina'ex. ");
INSERT INTO cakNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Romari' rix, ronojel ri ibin pa alak'al can xte'k'alajin-pe. Y ronojel ri ibin pa tak ixiquin pa jay, xtina'ex na coma ri winak y can xquiesiq'uin xtiquitzijoj pa quiwi' ri jay. ");
INSERT INTO cakNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Y romari' chuka' nin-ij chiwe rix ri can jix nu-amigos: Man tixi'j-iwi' chiquiwech ri xe ri ich'acul ri yetiquier niquicamisaj, y cuando quicamisan yan ri ich'acul man jun chic anchique xquietiquier xtiqui'en. ");
INSERT INTO cakNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nin-ij chiwe anchok chech nic'atzin-wi nixi'j-iwi': Tixi'j-iwi' chech ri jun ri can nitiquier nucamisaj ri ich'acul y jixrutak pa k'ak'. Can tixi'j-iwi' chech ri nibano quiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Y rix chuka' can iweta'n chi cuando ye'ilok' wo'o' chicop c'o quixic', xe ca'i' centavos cajil. Pero man roma ta chi ri chicop ri' man jun oc cajil, ri Dios man jun mej (bey) yerumestaj can. ");
INSERT INTO cakNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Rix can ajilan ri rusmal tak iwi'. Ri Dios man jun mej (bey) jixrumestaj can. Ri Dios can yalan jixrojo'. Más jixrojo' rix que chiquiwech ri chicop c'o quixic'. Romari' man tixi'j-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Chuka' nin-ij chiwe, chi xabachique (xama'anchique) winak ri nuk'alajij-ri' chi wichi ren, quiri' chuka' xtin-en ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xtink'alajij chi ri jun ri' wichi chic ren. Y ri tzij re' can chiquiwech ri ru-ángeles ri Dios xtin-ij-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Pero ri winak ri man nuk'alajij ta ri' chi wichi chic ren, chuka' ren man xtink'alajij ta ri rubi' chiquiwech ri ru-ángeles ri Dios, roma man wichi ta ren ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Y xabachique (xama'anchique) winak ri itzel nich'o'n chuij ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can nicoch'otaj (nicuyutaj) ri rumac. Pero ri can itzel nich'o'n chirij ri Espíritu Santo, manak xticoch'otaj (xticuyutaj) rumac. ");
INSERT INTO cakNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Y roma ja ren yininimaj, romari' xquixuc'uax pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios, y chuka' xquixuc'uax chiquiwech ch'aka chic autoridades, pero man tichajij pena roma ri tzij ri xti'ij chique y anchique tzij xticusaj chi jixch'o'n chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Roma cuando xtapon ri hora chi jixch'o'n-apo, can ja ri Espíritu Santo ri xtiyo'n tzij chiwe chi ni'ij-apo, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Y chiri' chiquicojol ri winak quimolon-apo-qui', c'o jun ri xch'o'n-apo y xu'ij che ri Jesús: Maestro, xcha' che. Tabana' favor cach'o'n riq'uin ri wach'alal y ta'ij che chi tuya' ri nu-herencia, roma ronojel xe richi raja' rubanon-ka che. ");
INSERT INTO cakNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero ri Jesús xu'ij che ri achi: ¿Ancu'x (Anchique) xbano chue chi ren jin juez y jin jun jachoy-herencia chi'icojol? ");
INSERT INTO cakNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Y Jesús xch'o'n chic chique ri winak y xu'ij: Can titzu-ka-iwi' utz chi niben cuenta iwi', man tirayij pa iwánima chi ronojel ex nic'ue' iwiq'uin. Roma más que q'uiy rubeyomal jun winak, man ja' ta ri' ri xtiyo'n ruc'aslen. ");
INSERT INTO cakNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Y ja' cuando ri Jesús xutzijoj jun ejemplo, y xu'ij: C'o jun achi beyom, q'uiy rulef c'o. Y jun mej (bey), q'uiy ri cosecha xumol. ");
INSERT INTO cakNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Romari' ri beyom ri' xunojij-ka pa ránima: ¿Anchique ta xtin-en chi quiri' ninyec ronojel nu-cosecha? Roma manak chic anchi' ninya-wi ronojel ri ch'aka chic. ");
INSERT INTO cakNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Y xunojij y xu'ij: Más utz yenyuj ronojel ri anchi' ninyec nu-cosecha y yenben ch'aka chic más je nim. Y chupa ri' xquienyec-wi ri c'o wiq'uin y ronojel ri nu-cosecha chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y xtin-ij che ri wánima: Wánima, cami q'uiy ex ri ayacon, y chi q'uiy juna' c'o awiq'uin. Caquicot c'a, catuxlan, cawa' y catuq'uia', xcha' ri beyom che ri ránima. ");
INSERT INTO cakNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero ri Dios xu'ij che ri beyom ri': Nacanic achi, chupa ri ak'a' re' xtinwoyoj ri awánima, ¿y ronojel ri abeyomal ri ayacon, anchok che xtic'ue-wi can? ");
INSERT INTO cakNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Quiri' nibanataj quiq'uin ri winak ri niquimol beyomel chi ri rech-ulef, y xa man c'o ta ri rubeyomal ri Dios quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Y ri Jesús xu'ij chique ri ru-discípulos: Nin-ij chiwe, man tich'ujrisaj-iwi' roma ri anchique nic'atzin chiwe k'ij-k'ij, anchi' xtiwil-wi iway y anchi' xtiwil-wi ri itziak ri xticusaj. ");
INSERT INTO cakNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Roma ri Dios can xuya-pe ic'aslen chech-ulef, can nuya-pe chuka' ri iway y ri itziak chi xticusaj. ");
INSERT INTO cakNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Quie'itzu' ri chicop c'o quixic' quibinan cuervos. Ri chicop ri' manak yetico'n, y romari' manak qui-cosecha juna-juna', ni manak chuka' qui-troje anchi' niquiyec-wi quijal. Pero reje' can yewa', roma can ja ri Dios nitzuku quichi. Y rix c'o más iwakalen que ri chicop ri'; romari' man tinojij más ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿C'o como jun chiwe rix ri nitiquier nu'on chi niq'uiy ta juba' más rakan y romari' can ch'u'j nu'on? Man jun. ");
INSERT INTO cakNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Y xa jun samaj ri yalan co'l anche'l re' man jixtiquier ta niben, ¿anchique roma can nich'ujrisaj-iwi' chi niwil iway, itziak y ri ch'aka chic ri yec'atzin chiwe? ");
INSERT INTO cakNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Quie'itzu' ri cotz'i'j quibinan lirio. Quie'itzu' cuando yeq'uiy. Reje' man yesamaj ta, ni man yebatz'in ta, chi niqui'en ta quitziak jabel oc. Y c'o jun rey chi ri Israel xc'ue' ojer can ri xubinaj Salomón. Raja' ruyon jabel tak tziak ri xerucusaj, pero man jun mej (bey) xc'ue' ta jun rutziak anche'l titzu'n jun cotz'i'j. ");
INSERT INTO cakNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Roma ri cotz'i'j, jari' ri tziak ri nuya' ri Dios chique ri k'ayis ri'. Y más que ri k'ayis man más ta nilayoj, roma jun k'ij jabel rubanon, jun chic k'ij nichaki'j-ka y c'ajari' niq'uiak pa k'ak', pero ri Dios can nuwak jabel. Y xa ri Dios can nuwak jabel ri k'ayis, ¿anchique roma rix man iyo'n ta iwánima riq'uin chi nuya' ronojel chiwe? ");
INSERT INTO cakNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Romari' rix man tich'ujrisaj-iwi' nicanola' ri iway y ri iwuq'uia'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Roma conojel winak quiere' niqui'en. Pero rix c'o jun Itata' ri can reta'n chic anchique nic'atzin chiwe. ");
INSERT INTO cakNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Romari' can ticanoj na'ey ri Dios y tibana' ri nrojo', y ronojel ri nic'atzin chiwe, ja raja' ri xtiyo'n. ");
INSERT INTO cakNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Romari' man tixi'j-iwi' rix ri jix-tzeklebeyon wichi, más que xa jix ca'i-oxi' oc, can nurayij-wi ri Itata' chi jixc'ue' pa ru-gobierno raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Tic'ayila' ri c'o iwiq'uin y tiya' chique ri winak ri manak quibeyomal. Xa quiri' niben, xtic'ue' jun iyacbal chila' chicaj ri can manak xtik'ey, y xtic'ue' chuka' ibeyomal ri manak xtiq'uis. Chila' chicaj anchi' man jun elek'om c'o, ni man jun ex chuka' xtichicopir. ");
INSERT INTO cakNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Roma ri iwánima can nic'ue' anchi' c'o-wi ri ibeyomal, roma jari' ri nitzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tinaba-iwi', y man tichup i-luz. ");
INSERT INTO cakNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Tibana' anche'l niqui'en ri samajel pa jun jay. Ri samajel quiyoben jampe' xtitzolaj-pe ri cajaf benak pa jun c'ulubic, chi quiri' cuando noka y niwoyon-apo can ja' niquijak ri ruchi-jay chech. ");
INSERT INTO cakNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Y can xquiequicot ri samajel ri je q'ues cuando xtoka ri cajaf. Y ketzij nin-ij chiwe, chi ri cajaf xtu'ij chique chi quiech'oquie-apo chuchi' mesa. Raja' can xtu'on ru'onic chi yerilij-apo utz, roma yalan niquicot chi quiyoben-apo ri hora ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Y más que ri cajaf ri samajel ri' noka pa nic'aj-ak'a' o ja cuando nisakar yan pe, ri samajel ri' jabel yequicot roma c'a je q'ues quiyoben-apo ri cajaf ri hora ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Y rix iweta'n, xa ta jun rajaf-jay nuna'ej jampe' napon jun elek'om pa rocho, ri rajaf-jay ri' nic'ase' chi nuchajij ri rocho, y man nuya' ta lugar chi ri elek'om ntoc-apo chi nelak'-e. ");
INSERT INTO cakNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Romari' rix can siempre tinaba-iwi' jabel, y can quiri' ta ibanon cuando xquinoka-ka ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, roma ren xquipe cuando rex man ja' ta ri' ninataj. ");
INSERT INTO cakNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Y ri Pedro xu'ij che ri Jesús: Ajaf, ¿ret xatzijoj ri ejemplo re' xe chake roj a-discípulos, o xatzijoj chuka' chique conojel winak? ");
INSERT INTO cakNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Y ri Ajaf Jesús xu'ij: Ren yich'o'n chique conojel ri je anche'l ri samajel pa jun jay, ri ni'an che roma ri rajaf chi nic'ue' pa quiwi' ri jec'o pa rocho, chi nuya' ronojel ri nic'atzin chique chi niquitaj cuando napon ri tiempo. Y xa ri samajel ri' can nu'on-wi ri bin can che y utz nu'on che ronojel ri samaj, ¿anchique como nu'on? ");
INSERT INTO cakNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ri samajel ri' can tiquicot ránima cuando nolitaj-ka roma ri rajaf y can najin-wi riq'uin ri samaj ri bin can che. ");
INSERT INTO cakNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Can ketzij nin-ij chiwe chi ri rajaf ri samajel ri' xtuya' parui' ronojel ri c'o riq'uin, chi nu'on cuenta. ");
INSERT INTO cakNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero xa ri samajel ri' nu'ij-ka pa ránima: Ri wajaf ri' xa manak yan xtoka, nicha' ta; y ruyon ja' yeruch'ey ri ch'aka chic samajel, achi'a' chi ixoki', y xe ta wa'in nu'on, y nutz'om-ka tijoj-ya' y xe nik'aber, y man jun chic samaj nu'on, ");
INSERT INTO cakNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","y jari' yeru'on cuando ri rajaf xtoka chupa jun k'ij y jun hora cuando raja' man ja' ta ri' nunataj. Ri rajaf can xtuya-wi jun nim castigo che ri samajel ri' y xtuya' quiq'uin ri ch'aka chic samajel ri man yeniman ta. ");
INSERT INTO cakNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Ri samajel ri reta'n anchique nrojo' ri rajaf, pero xa man xunaba' ta ri', ni man xu'on ta ri nrojo' ri rajaf, ri samajel ri' xtika jun nim castigo pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ri samajel ri man reta'n ta anchique nrojo' ri rajaf, y c'o ex man utz ta yeru'on-apo, más que ri samajel re' utz chi ni'an castigar, xe jun co'l castigo xtiyo'x che. Roma ri can q'uiy yo'n che, chuka' can q'uiy xtic'utux che. Chuka' ri can q'uiy ri jachon can pa ruk'a', can q'uiy chuka' ri xtic'utux che, chi quiri' nina'ex anchique rubanon riq'uin ri yo'n can pa ruk'a', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Ren chi ninya' k'ak' chi'icojol xipe we' chech-ulef. ¿Y anchique chic más ninrayij, xa ri k'ak' ri' can nic'at yan? ");
INSERT INTO cakNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pero na'ey yitojtobex na roma jun bautismo, ri bautismo ri' ja ri sufrimiento xtink'axaj, romari' c'o ruquiy (nik'axon) wánima woyoben-apo, y can ninrayij chi xk'ax yan ta. ");
INSERT INTO cakNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Rix ninojij chi ren xipe chi ninya' uxlanen chi jixquicot chech-ulef? Man quiri' ta. Xa woma ren can jec'o ri xtiquijachala-ka-qui'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Romari' desde cami, xa pa jun jay jec'o je wo'o' winak, je oxi' xa xquiecataj chiquij ri je ca'i' chic, o ja ri je ca'i' ri xquiecataj chiquij ri je oxi'. ");
INSERT INTO cakNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ri tata'j man xtika ta chech ri nu'ij ri ralc'ual che. Ni ri c'ajol man xtika ta chech ri nu'ij ri tata'j che. Ni ri te'j man xtika ta chech ri nu'ij ri ral-xten che. Y quiri' chuka' ri xten, man xtika ta chech ri nu'ij ri te'j che. Y can quiri' chuka' ri alite', man xtiquijo' ta qui' quiq'uin ri cali' roma man junan ta yenojin; y can quiri' chuka' ri alibatzi', man xtiquijo' ta qui' quiq'uin ri calite' roma man junan ta yenojin. ");
INSERT INTO cakNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Y ri Jesús xu'ij chuka' chique ri winak: Rix iweta'n anchique ajawa' (mukul) ri ruc'amon-pe job. Y cuando nitzu' ri ajawa' (mukul), ch'anin ni'ij chi nipe job. Y can nipe-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y cuando nutz'om ri quiek'ik', ja retal re' iyo'n chi nitiquier-ka ri sak'ij. Y can quiri' nibanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Rix xa ca'i' ipalaj, roma jabel iweta'n anchique neru'ona' cuando nitzu' chi jec'o ajawa' (mukul) chicaj y cuando nutz'om ri quiek'ik'. Y xa iweta'n nitzu' ri ex chi ri rech-ulef, ¿anchique roma man iweta'n ta chuka' anchique tiempo ri xojoka cami roma ri samaj ri nu'on ri Dios chi'icojol? ");
INSERT INTO cakNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","¿Y anchique roma man iyon ta rix nina'ej y nitemaj ri utz, y ja' ta ri' ri niben? ");
INSERT INTO cakNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Roma xa c'o jun chiwe ri nisujus pa juzgado roma c'o ruc'as riq'uin jun winak, tutija' ruk'ij nu'on arreglar ri' riq'uin ri sujuyun richi cuando c'a man jani quie'apon pa juzgado. Roma xa man nu'on ta arreglar ri' riq'uin, can xtic'uax chech ri juez y ri juez xtujach pa ruk'a' ri achi ri nichajin ri cárcel, y ri achi xtutz'apij pa cárcel. ");
INSERT INTO cakNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Y can ketzij nin-ij, chi jun ri ntoc pa cárcel roma ruc'as, man xtel ta pe chiri' xa man xtutoj ta can ronojel ruc'as. ");
INSERT INTO cakNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Y chupa ri tiempo ri' jec'o jujun winak ri xe'apon riq'uin ri Jesús, y reje' xquitzijoj che ri xquic'ulumaj jujun achi'a' aj-Galilea. Ri achi'a' ri' jec'o pa rocho ri Dios, y jequic'uan-apo chicop chi yequisuj chech ri Dios. Y cuando ja' niquisuj ri chicop chech ri Dios, xebecamises-pe. Can k'alaj chi ri xbano quiri' chique ri achi'a' ri', ja ri Pilato ri gobernador. Ri quiquiq'uiel ri chicop y ri quiquiq'uiel ri achi'a' ri', xuxol-ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Pero ri Jesús xu'ij chique: ¿Rix ninojij chi ri achi'a' aj-Galilea ri', quiri' xquic'ulumaj roma reje' c'o más quimac que chiquiwech ri ch'aka chic quiwinak aj-Galilea? ");
INSERT INTO cakNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man quiri' ta. Pero xa rix man niya' ta can ri mac y man niben ta ri nrojo' ri Dios, xa can xquixapon chuka' chupa ri castigo anchi' xe'apon-wi reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O rix ninojij chuka' chi ri dieciocho ri xecom chiri' anchi' c'o-wi jun estanque ri ni'ix Siloé che, cuando xtzak ri torre chiquij, más c'o quimac reje' que chiquiwech conojel ri ch'aka chic winak ri jec'o chiri' pa tenemit Jerusalem? ");
INSERT INTO cakNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man quiri' ta. Pero rix xa man niya' ta can ri mac y man niben ta ri nrojo' ri Dios, xa can xquixapon chuka' chupa ri castigo anchi' xe'apon-wi reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Y ri Jesús xutzijoj jun ejemplo chiquiwech, y xu'ij: C'o jun achi ruticon jun mata higo pa rulef, y xapon chuxe' ri che' chi nutzu' xa c'o rech o xa manak. Y ri jun mata higo ri' xa man jun rech. ");
INSERT INTO cakNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Romari' ri rajaf ri ulef xu'ij che ri achi ri nusamajij rulef: Oxi' yan juna' ri can juna-juna' nontzu' ri che' re', y man jun mej (bey) nutz'eton chi ruyo'n ta jun rech. Romari' más utz nalesaj-e, roma xa manak rech nuya'. ¿Anchique xtic'atzin-wi la'? La' xe nuq'uis ruchuk'a' ri ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ri achi ri nusamajij ri ulef xu'ij che ri rajaf: Taya' can xe chic ri juna' re', chi quiri' nenbana' ru'onic ri ulef ri anchi' c'o-wi y tinya' na abono chuxe'. ");
INSERT INTO cakNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xa nuya' rech, utz. Y xa manak xtuya' rech, c'ajari' talesaj-e, xcha' ri nisamajin ri ulef. Quiere' ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Y pa jun k'ij chi uxlanen, ri Jesús yerutijoj ri winak riq'uin rutzij ri Dios, pa jun sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Y chiquicojol ri winak ri quimolon-qui' chiri', c'o jun ixok ri c'o yan dieciocho juna' tiyawaj-pe. Ri ixok re' luculic rij, y can man nitiquier ta nipa'e' juba' choj. Ri ixok quiere' rubanon roma jun itzel espíritu. ");
INSERT INTO cakNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Pero cuando ri Jesús xutzu' ri ixok ri', xroyoj y xu'ij che: Cami xacolotaj yan chech ri ayabil. ");
INSERT INTO cakNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya' ruk'a' pa ruwi' ri ixok. Y can ja' xchojmir, y utz xpa'e'. Y ri ixok can ja' xuya' ruk'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero ri achi ri más c'o ruk'ij chupa ri sinagoga ri', xcataj ruyowal roma ri Jesús xu'on chi xc'achoj ri ixok pa jun k'ij chi uxlanen; romari' ri achi ri más c'o ruk'ij xu'ij chique ri winak ri quimolon-qui' chiri': Ri semana ruc'uan waki' k'ij chi jojsamaj. Y chupa ri waki' k'ij ri' quixpe riq'uin ri Jesús chi jixc'achoj-e, y man quixoka ri k'ij re', roma k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Pero ri Ajaf Jesús can ja' xu'ij che: Rix xa ca'i' ipalaj. ¿Manak como ye'isol ri iwacx o iquiej pa jun k'ij chi uxlanen, chi ne'iya' juba' quiya'? ");
INSERT INTO cakNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Y ri ixok re', ru-familia can ri Abraham. Ri Satanás c'o yan dieciocho juna' ruximon-pe riq'uin ri yabil. ¿Man utz ta como chi raja' nic'achoj chupa jun k'ij chi uxlanen? ");
INSERT INTO cakNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Cuando ri Jesús xu'ij quiri', conojel ri itzel yetz'eto richi, xeq'uix-ka. Pero ri ch'aka chic winak niquicot cánima, roma ri Jesús can nim rusamaj ri Dios ri nu'on. ");
INSERT INTO cakNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Y Jesús xu'ij: ¿Anchique ta modo xtin-ij chirij ri ru-gobierno ri Dios? ¿Anchok riq'uin junan-wi? ");
INSERT INTO cakNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ren nin-ij chi junan riq'uin ri ija'tz' chi mostaza ri nutic can jun achi pa rulef. Cuando niq'uiy, can anche'l jun nim che' nitzu'n. Romari' ri chicop ri c'o quixic' ri yebe chicaj, ye'apon chuk'a' chi niqui'en quisoc. ");
INSERT INTO cakNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y Jesús xu'ij chuka': ¿Anchok riq'uin xtinjunumaj-wi ri ru-gobierno ri Dios? ");
INSERT INTO cakNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ri ru-gobierno ri Dios can junan riq'uin ri levadura ri neruc'ama-pe jun ixok y nuya' chupa oxi' paj harina y nuquiraj-ri' chupa ronojel, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Y Jesús xutz'om chic bey chi napon pa tenemit Jerusalem. Y nutzijoj rutzij ri Dios pa tak nima'k y cocoj tak tenemit anchi' nik'ax-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y c'o jun ri xc'utun che ri Jesús, y xu'ij che: Ajaf, ¿je q'uiy como ri xquiecolotaj? Pero ri Jesús xa chique conojel xch'o'n-wi, y xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Can titija' ik'ij tinimaj rutzij ri Dios. Ronojel ri niben rix, can pa ruchojmil tibana-wi chech ri Dios. Roma ri ruchi-jay ri anchi' jixk'ax-wi, yalan co'l oc rech. Y can je q'uiy ri winak xtiquijo' xquie'oc pa ruchi-jay ri', pero man je q'uiy ta xquietiquier xquie'oc. ");
INSERT INTO cakNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Roma cuando ri Ajaf xticataj-pe y xtorutz'apij can ri ruchi-jay, rix ri man jani quixoc-apo riq'uin, xtic'ojc'a-apo ruchi-jay y xti'ij: Ajaf, Ajaf, tajaka' ri ruchi-jay chakawech chi jojoc-apo. Pero raja' xtu'ij-pe chiwe: Man weta'n ta anchi' quixpe-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Y rix xti'ij-apo che: Ja roj ri xojwa-xojuq'uia' awiq'uin. Y ja pa tak bey chi ri katenemit, chiri' xa'ij-wi rutzij ri Dios chake. ");
INSERT INTO cakNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero raja' xtu'ij-pe chiwe: Xin-ij yan chiwe chi ren man weta'n ta anchi' quixpe-wi. Man utz ta chi jixc'ue' wiq'uin, rix ri jix banoy itzel tak ex, xticha' ri Ajaf. ");
INSERT INTO cakNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Y cuando xquie'itzu' ri achi'a' ri quibinan Abraham, Isaac, Jacob y conojel ri achi'a' ri xek'alajin rutzij ri Dios ojer can, chi jec'o pa ru-gobierno ri Dios; c'ajari' xquixok' roma ri bis, xtijach'ach'ej iwey roma xquixleses-e. ");
INSERT INTO cakNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Y xquiepe winak pa norte y pa sur, anchi' ntel-pe ri k'ij y anchi' nika-wi-ka ri k'ij, ri winak ri jinquiniman. Y ri winak re' can xquiec'ue' pa ru-gobierno ri Dios. Reje' xquiech'oquie' chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Y jec'o ri can manak oc quik'ij cami, chiri' can xtic'ue-wi quik'ij, y jec'o ri can yalan quik'ij cami, manak oc quik'ij xtic'ue', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Y chupa chuka' ri k'ij ri', jec'o achi'a' fariseos ri xe'apon riq'uin ri Jesús, y xqui'ij che: Ri Herodes, ri gobernador, nrojo' jatrucamisaj. Catel-e we' ch'anin, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Pero ri Jesús xu'ij chique ri achi'a' ri': Ibij che ri jun gobernador ri', ri can jabel reta'n nu'on engaño, chi ren c'a xquienlesaj na itzel tak espíritus y chuka' c'a xtin-en chique ri yeyawaj chi quiec'achoj. Quiri' xtin-en cami, chua'k y cabij, y c'ajari' xtinq'uis can ru'onic ri samaj re'. ");
INSERT INTO cakNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ren can nutz'amon yan nubey. Quiri' cami, chua'k y cabij. Can nic'atzin chi yinapon pa tenemit Jerusalem, roma ri niquik'alajij rutzij ri Dios, man jun mej (bey) xquiecamises pa jun chic tenemit. ");
INSERT INTO cakNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Y c'ajari' ri Jesús xch'o'n chiquij ri winak ri jec'o pa Jerusalem. Raja' xu'ij: Rix winak aj-Jerusalem, ¿anchique roma ye'icamisaj ri achi'a' ri yek'alajin ri ni'ix chique roma ri Dios? ¿Anchique roma chuka' ye'icamisaj che abaj ri yerutak-pe ri Dios chi'icojol? Ren, can q'uiy mej (paj) xinjo' xixinmol ta wiq'uin, anche'l nu'on jun ec' chique ri ral, yerumol chuxe' ri ruxic'. Pero rix man xijo' ta. ");
INSERT INTO cakNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Cami, ri iwocho can anche'l jun tz'iran rech-ulef xtu'on can. Y can ketzij chuka' nin-ij chiwe chi can man xquinitzu' ta chic, c'a xtapon ri k'ij cuando xti'ij chue: ¡Matiox chi petenak ri Jun re'! ¡Raja' can yo'n-wi-pe bendición pa ruwi' roma ri Ajaf Dios! ¡Y petenak chuka' pa rubi' ri Ajaf Dios! xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Y pa jun k'ij chi uxlanen, ri Jesús xbe pa rocho jun achi ri más c'o ruk'ij chiquiwech ri achi'a' fariseos. Ri Jesús banon invitar roma ri achi ri' chi niwa' quiq'uin. Y ri jec'o chiri' niquitzu-apo ri Jesús, ");
INSERT INTO cakNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","roma chiri' c'o-apo jun achi sipojinak. ");
INSERT INTO cakNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Y ri Jesús xu'ij chique ri maestros chi ri ley y chuka' chique ri achi'a' fariseos ri jec'o chiri': ¿Xajan (Xajam) como chi nic'achoj jun yawa' pa jun k'ij chi uxlanen? ¿Anchique ni'ij rix? ");
INSERT INTO cakNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero ri maestros y ri fariseos man jun anchique xqui'ij. Romari' ri Jesús xutz'om-apo ri achi sipojinak y xu'on che chi xc'achoj y xu'ij che chi tibe. ");
INSERT INTO cakNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Y chique ri maestros y ri fariseos, ri Jesús xu'ij: Xa c'o jun chiwe rix nitzak jun ruquiej o jun ruwacx pa jun jul, ¿man nibe ta como junanin chi nerulesaj-pe, más que pa jun k'ij chi uxlanen? ");
INSERT INTO cakNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Y ri maestros y ri fariseos man xquiwil ta anchique xqui'ij-apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Y xpe ri Jesús xutz'om rubixic jun ejemplo chique ri je-banon invitar chi ri wa'in, roma xutzu' chi ri winak ri je-banon invitar yequicha' quich'acat chi yech'oquie' chiri' chuchi' mesa. Romari' xu'ij chique: ");
INSERT INTO cakNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Cuando c'o jun ri nibano invitar iwichi pa jun c'ulubic, man quie'icanoj ri na'ey tak ch'aquet. Roma xa juba' (paka) jix-ch'ocol chic chiri' cuando napon jun winak ri más c'o ruk'ij que chiwech rix, ");
INSERT INTO cakNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","y nipe ri rajaf-jay, nu'ij chiwe: Tabana' favor taya' can ri ach'acat che ri jun chic re'. Y rix jixq'uix-ka roma jixleses-e y jixbech'oquie' pa ch'aquet ri jec'o pa ruq'uisbel. ");
INSERT INTO cakNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Romari' cuando c'o jun ri nibano invitar iwichi pa jun c'ulubic, quixch'oquie' pa quiwi' ri ch'aquet ri jec'o pa ruq'uisbel, chi quiri' cuando jixrutzu-pe ri xbano invitar iwichi, xtoka iwiq'uin y xtu'ij chiwe: Tabana' favor cak'ax-pe we'. Y cuando quiri' xti'an chiwe, conojel ri yech'oquie' iwiq'uin chuchi' mesa chi ri wa'in xtiquitzu' chi can c'o-wi ik'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Romari', ri winak ri can niquina' chi c'o quik'ij, xa xtikases quik'ij. Pero ri niquina' chi can manak oc quik'ij, nim quik'ij xti'an chique, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Y ri Jesús xu'ij chuka' che ri xbano invitar richi: Cuando najo' chi jec'o yepe awiq'uin chi jun wa'in, man quie'aben invitar xe ri aweta'n quiwech, ri ate-atata', conojel ri je awach'alal, y ri a-vecinos ri je beyom, roma reje' can yetiquier chuka' jatqui'en invitar ret, y riq'uin ri' niyo'x yan chawe ruq'uiexel che ri ayo'n ret. ");
INSERT INTO cakNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Pero ret, cuando c'o jun nimak'ej pa awocho, quie'abana' invitar winak ri man jun quibeyomal, ri man utz ta ri quik'a' o cakan, o quie'abana' invitar ri yejetz'ma'y yebin y ri man yetzu'n ta. ");
INSERT INTO cakNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Xa quiri' xta'an, can caquicot, roma ri winak ri' man yetiquier ta niquiya' chawe ruq'uiexel, pero ret xtiyo'x ruq'uiexel chawe cuando junan xcac'astaj-e quiq'uin ri chojmilaj tak winak, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Y c'o jun ri ch'ocol chuchi' mesa, cuando xuc'oxaj ri tzij ri xu'ij ri Jesús, xu'ij-apo che: Can quiequicot ri xquiec'ue' pa ru-gobierno ri Dios y can xquiewa' chiri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Y ri Jesús can ja' xu'ij: Jun mej (bey) jun achi nrojo' nu'on jun nimak'ej pa rocho y nuya' jun wa'in. Romari' raja' can je q'uiy winak ri xeru'on invitar chi yebewa' chirocho ri k'ij ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Romari', cuando xapon ri k'ij chi ni'an ri wa'in, ri achi xutak jun rusamajel chi yeroyoj conojel ri winak ri'. Y ri samajel xberu'ij chique: Ronojel c'o chic, cami jo' pa wa'in. ");
INSERT INTO cakNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Pero conojel can junan ri xqui'ij-pe, chi can man yetiquier ta ye'apon. Ri na'ey xu'ij-pe: Tabana' favor ta'ij che ri awajaf chi tucuyu' numac roma man yitiquier ta yinapon, roma xa c'aja' tinlok' jun wulef, y cami jari' ri nentzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ri jun chic xu'ij: Tabana' favor ta'ij che ri awajaf chi ren man yitiquier ta yinapon, roma jec'o wo'o' pares nuwacx xenlok' chi yensamajij, y cami jari' ri yebentojtobej. Romari' tucuyu' numac, man yinapon ta. ");
INSERT INTO cakNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Y ri jun chic xu'ij: Ta'ij che chi tucuyu' numac roma manak modo yinapon roma xa c'aja' yic'ule'. ");
INSERT INTO cakNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Y cuando ri samajel ri takon-e xtzolaj-apo riq'uin ri rajaf, xutzijoj che ronojel ri x-ix-e che. Romari' ri rajaf xcataj ruyowal, y xu'ij che ri rusamajel chi tibe pa tak bey ri jec'o pa tenemit y quierumolo-pe ri man utz ta ri quik'a' o ri cakan, ri yejetz'ma'y yebin, ri man yetzu'n ta, y chuka' ri manak quibeyomal. ");
INSERT INTO cakNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Y cuando ri samajel xtzolaj, xu'ij che ri rajaf: Xenc'on yan pe ri winak ri xa'ij-e chue, pero c'a q'uiy lugar c'o. ");
INSERT INTO cakNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Y ri rajaf xu'ij chic che chi tibe pa tak bey chi ri tenemit y ri bey ri yebe chuchi' ri tenemit, y can quieru'ona' obligar ri winak ri jec'o chiri' chi quiepe chi quiri' ninoj ri rocho. ");
INSERT INTO cakNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Y xu'ij chuka' che: Ren can ketzij-wi nin-ij chiwe, que man jun chic chique ri xenben invitar na'ey, ri xtoru'ona' ri wa'in re' wiq'uin, xcha'. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Y can q'uiy winak ri quitzekleben ri Jesús. Y cuando raja' xtzu'n can chirij y xerutzu' ri winak ri', xpa'e', y xu'ij chique: ");
INSERT INTO cakNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","Xa c'o jun ri nrojo' ntoc nu-discípulo, can nic'atzin chi ja ren ri más quirojo'. Roma xa más yerojo' ri rute-rutata' que chinuech ren, man utz ta. Ni man utz ta chuka' chi ja' ta ri raxayil ri más nrojo', o ri je ralc'ual, ri rach'alal o raja' mismo ri más nrojo-ka-ri'. Can ja ren ri más quirojo' chiquiwech reje'. Roma xa man quiri' ta nu'on, man nitiquier ta ntoc nu-discípulo. ");
INSERT INTO cakNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ri winak ri can nrojo-wi ntoc nu-discípulo, man tupokonaj nuk'axaj sufrimientos woma ren, tu'ona' anche'l xa can ruc'uan ru-cruz. Pero ri winak ri xa man nrojo' ta nuk'axaj sufrimientos woma ren y man nrojo' ta yirutzeklebej, man nitiquier ta ntoc nu-discípulo. ");
INSERT INTO cakNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Roma cuando c'o jun chiwe rix ri nrojo' nu'on jun jay nim, ¿man nich'oquie' ta como juba' chi nunojij jani' mero xtic'atzin che, y xa can c'o ronojel riq'uin chi nuq'uis ru'onic o xa man nitiquier ta? ");
INSERT INTO cakNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Roma xa xtutz'uc-ka ri samaj y xe ru-cimiento ri jay nitiquier nuya-ka y quiri' nupoba' can ri samaj, xquiepe ri winak y xquietze'n chirij, ");
INSERT INTO cakNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y xtiqui'ij chirij: La jun achi la' xrojo' xupoba' jun jay, y xa man xtiquier ta, xquiecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O xa jun rey neru'ona' guerra riq'uin jun chic rey, ¿man nich'oquie' ta como juba' chi nunojij, xa riq'uin diez mil soldados nitiquier nu'on guerra riq'uin ri jun chic rey ri jeruc'amon-pe veinte mil soldados? ");
INSERT INTO cakNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y xa nunojij chi xa man nitiquier ta, raja' yerutak achi'a' chi ne'quic'ulu' ri rey, cuando c'a man jani toka. Y ri achi'a' ri' yebe chi ne'quic'ulu' y ne'qui'ij che: Roj manak nakajo' ayowal. ");
INSERT INTO cakNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Romari', xa jun chiwe rix nrojo' ntoc nu-discípulo, can tunojij utz na'ey chi nuya' can ronojel ri c'o riq'uin. Xa man nu'on ta quiri', man nitiquier ta ntoc nu-discípulo. ");
INSERT INTO cakNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Ri atz'am can utz-wi. Y xa ta ri atz'am re' niq'uis-e ri ratz'amil, ¿anchique ta chic xtaka'an che chi nitzolaj chic pe ratz'amil? ");
INSERT INTO cakNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ri atz'am ri', man utz ta chic nicuses chi niyo'x pa ulef, ni man utz ta chuka' nixol riq'uin abono chi niyo'x pa ulef. Xe quiri' nitorix-e, roma man jun chic nic'atzin-wi. Conojel ri c'o quixiquin, can tiquic'oxaj ri xin-ij-ka, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Y conojel ri achi'a' je moloy-impuestos y ri ch'aka chic winak ri ni'ix chi je aj-mac, ye'apon-apo riq'uin ri Jesús. Ri winak re' ye'apon riq'uin chi niquic'oxaj rutzij ri Dios ri nutzijoj. ");
INSERT INTO cakNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Y roma ja winak re' ri ye'apon riq'uin ri Jesús, ri achi'a' fariseos y ri maestros chi ri ley yetzijon chirij ri Jesús y niqui'ij: Ri Jesús man utz ta ri nu'on roma nuc'ul quiwech ri winak aj-mac y can nibe chuka' chi tak cocho chi ne'wa' quiq'uin, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Romari' ri Jesús xutzijoj jun ejemplo chiquiwech y xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Xa ta jun chiwe rix jec'o ta je cien ru-ovejas y nisatz (nisach) ta can jun cuando jeruc'uan, yeruya' can juba' ri ch'aka chic ovejas chiri' pa k'ayis, chi nerucanoj-pe ri jun satzinak (sachinak). ");
INSERT INTO cakNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Y cuando nerila-pe ri ru-oveja, can niquicot nuya-pe parui' rutele'n. ");
INSERT INTO cakNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y cuando napon chirocho, yeroyoj ri winak can reta'n quiwech, y yeroyoj chuka' ri ru-vecinos, y nu'ij chique: Cami quixquicot wiq'uin, roma ri jun nu-oveja re' satzinak (sachinak) can, cami xinwil-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Y can ketzij nin-ij chiwe, chi can yequicot ri jec'o chila' chicaj cuando jec'o noventa y nueve winak ri choj quic'aslen, ri xquiya' yan can quimac y niqui'en ri nrojo' ri Dios. Pero más yequicot ri jec'o chila' chicaj, cuando c'o jun aj-mac ri nuya' can ri mac y nu'on ri nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","O xa c'o ta jun ixok ri c'o lajuj monedas riq'uin, y jun chique ri monedas re' nutzak ta jun chiri' pa rocho, ¿man nutzaj ta como jun luz ri ixok ri', chi nucanoj ri mero ri'? ¿Y man numes ta como rupa ri rocho chi nucanoj ri mero? Quiri' nu'on. ");
INSERT INTO cakNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y cuando nril, yeroyoj ri winak ri reta'n quiwech, y yeroyoj chuka' ri ru-vecinos, y nu'ij chique: Quixquicot wiq'uin, roma ri nu-mero ri satzinak (sachinak), xinwil yan. ");
INSERT INTO cakNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Y can ketzij nin-ij chiwe, chi cuando c'o jun ri nu'on mac y nuya' can ri mac y nu'on ri nrojo' ri Dios, ri ángeles ri jec'o riq'uin ri Dios yalan yequicot, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Y Jesús xu'ij chuka' chique: C'o jun achi ri xec'ue' je ca'i' ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Y jun k'ij ri chak'laxel xu'ij che ri tata'j: Tat, taya' yan ri nu-herencia ri can anojin naya' chue, xcha'. Y ri tata'j can xujach qui-herencia chique je ca'i'. ");
INSERT INTO cakNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ca'i-oxi' k'ij ri tijach ri qui-herencia, ri chak'laxel xuc'ayij can ronojel ri ru-herencia. Can q'uiy ri mero xumol, y riq'uin ri mero ri' xbe naj pa jun chic rech-ulef. Y cuando c'o chic chiri', xuc'uaj jun itzel c'aslen y quiri' xu'on xuq'uis ru-mero. ");
INSERT INTO cakNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cuando ruq'uison chic ronojel ru-mero, xpe jun tiempo chi wayjal chupa ri rech-ulef anchi' c'o-wi raja'. Y ri ala' ri' man jun chic ex nitiquier nulok' roma manak chic ru-mero, y xa yalan ninum rupa. ");
INSERT INTO cakNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Romari' xberuc'utuj rusamaj che jun achi aj-chiri'. Y ri achi ri' xutak-e pa rulef chi yeberuchajij ak. ");
INSERT INTO cakNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Y ri ala' can yalan nurayij nutaj chuka' raja' ri niquitaj la ak. Pero can man jun winak niyo'n ruway. ");
INSERT INTO cakNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Y c'ajari' ri ala' xoka pa ruwi', y xu'ij-ka: Ri rusamajel ri nata', utz yewa'; y ren we' yicom yan ka roma wayjal. ");
INSERT INTO cakNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Cami yicataj y yibe riq'uin ri nata' y nenbij che: Tat, q'uiy numac xin-en chech ri Dios y chuka' chawech ret. ");
INSERT INTO cakNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Cami man utz ta chic chi na'ij awalc'ual chue. Más utz xa na'an ta chue anche'l jun asamajel, xcha-ka raja' pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y can ja' xutz'om bey, xbe chirocho riq'uin ri rutata'. Y c'a man jani tapon chirocho; can c'a naj c'o-wi cuando ja' xtz'et-pe roma ri rutata'. Y ri rutata' can xujoyowaj rech; romari' junanin xberuc'ulu', xuk'etej y xutz'ubaj. ");
INSERT INTO cakNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Y ri ala' can ja' xu'ij che ri rutata': Tat, q'uiy numac xin-en chech ri Dios y chuka' chawech ret. Cami man utz ta chic na'ij awalc'ual chue. ");
INSERT INTO cakNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero ri tata'j xu'ij chique ri rusamajel: Tilesaj-pe ri tziak ri más utz y tijala' ri rutziak. Tiya' anillo chuk'a' y tiya' xajab chirakan. ");
INSERT INTO cakNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ic'ama-pe chuka' ri wacx ti'oj y ticamisaj; kabana' jun nimak'ej y kojwa'. ");
INSERT INTO cakNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Roma ri jun walc'ual re' anche'l caminak rubanon-e chinuech, pero cami xbec'astaj chic pe. Rusatzon-e-ri' (Rusachon-e-ri') jumul chinuech, y cami xbetzolaj chic pe, xcha' ri tata'j. Y can ja' xtiquier-ka ri nimak'ej. ");
INSERT INTO cakNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Y cuando xbanataj ronojel ri', ri nimalaxel xa nisamaj pa k'ayis. Y cuando raja' xtzolaj-pe y napon yan chirocho, xuc'oxaj chi c'o nimak'ej najin. ");
INSERT INTO cakNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Romari' xroyoj jun chique ri samajel y xuc'utuj che: ¿Anchique xbanataj? ¿Y anchique roma c'o nimak'ej? ");
INSERT INTO cakNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Y ri samajel xu'ij che: Roma xtzolaj-pe ri achak', y utz rech xtzolaj-pe. Romari' ri atata' xu'ij chi ticamises ri wacx ti'oj. ");
INSERT INTO cakNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Cuando xuc'oxaj quiri', xpe ruyowal, y man nrojo' ta ntoc-apo pa jay. Xbe'el-pe ri rutata', y nubochi'j, chi quiri' ntoc ta apo. ");
INSERT INTO cakNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero raja' man xrojo' ta. Xa xu'ij che ri rutata': Ren siempre yisamaj awiq'uin y siempre chuka' ninnimaj atzij. Pero man jun mej (bey) ayo'n jun cabrito chue chi nin-en jun nimak'ej quiq'uin ri nu-amigos. ");
INSERT INTO cakNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Y cami ret xacamisaj-ka ri wacx ti'oj, xe roma xtzolaj-pe ri jun awalc'ual ri xberuq'uisa' ronojel ri abeyomal quiq'uin ixoki' itzel quic'aslen ri ni'ix rameras chique, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Y ri tata'j xu'ij: Walc'ual, xcha' che. Ret, can jatc'o-wi wiq'uin. Romari' ronojel ri c'o, can je awichi ret. ");
INSERT INTO cakNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero ri achak' can caminak-wi rubanon-e chinuech, y cami anche'l xc'astaj chic pe xu'on. Rusatzon-e-ri' (Rusachon-e-ri'), y cami xoka chic kaq'uin. Y roma raja' xtzolaj-pe, can nic'atzin chi cami jojquicot y naka'an nimak'ej. Quiri' xu'ij ri tata'j ri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ri Jesús xu'ij chuka' chique ri ru-discípulos: Xc'ue' jun achi beyom. Y ri achi re' c'o jun rusamajel ri ruyo'n parui' ronojel rubeyomal. Y che ri achi beyom xbe'ix chi ri rusamajel ri ruyo'n parui' rubeyomal, nuq'uis ri beyomel benak. ");
INSERT INTO cakNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Y ri patrón xutak royoxic ri samajel ri'. Y cuando xoka ri samajel, ri patrón xu'ij che: ¿Anchique na'ij chue chirij ri xo'ix chawij? Cami ninjo' nintzu' anchique rubanon ronojel ri beyomel pa ak'a', roma cami manak chic xcasamaj wiq'uin, xcha' ri patrón che. ");
INSERT INTO cakNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Y ri samajel xunojij: ¿Anchique xtin-en cami? Roma ri nu-patrón numaj nusamaj. Y xa ta ninsamajij ri ulef, ri' nrojo' q'uiy wuchuk'a', y man yitiquier ta chic. Y xa ta ninc'utuj nu-limosna pa tak bey, yiq'uix. ");
INSERT INTO cakNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Y cuando xunojij yan, xu'ij: Cami can weta'n chic anchique xtin-en, chi quiri' jec'o ri yec'ulu nuech pa tak cocho, cuando xquileses-e we' pa nusamaj. ");
INSERT INTO cakNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ri samajel re' xeroyoj chijujun conojel ri c'o quic'as riq'uin ri ru-patrón, y xuc'utuj che ri na'ey: ¿Jani' ac'as riq'uin ri nu-patrón? ");
INSERT INTO cakNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Y ri achi ri c'o ruc'as xu'ij: Ren cien barriles aceite de olivo nuc'as riq'uin, xcha'. Y ri rusamajel ri achi beyom xu'ij che: Ja ruwuj ri ac'as re'. Cami cach'oquie' y tabana' jun chic ch'anin. Y xe chic cincuenta barriles aceite ac'as tabana-ka chupa. ");
INSERT INTO cakNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Y cuando xapon jun chic ri c'o ruc'as, ri samajel xuc'utuj che: Y ret ¿jani' ac'as? Ri achi xu'ij: Ren cien medidas trigo nuc'as, xcha'. Y ri samajel xu'ij che: Ja ruwuj ri ac'as re', cami tabana' chic jun. Y xe chic ochenta medidas trigo ac'as tabana-ka chupa, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Y cuando ri ru-patrón xuc'oxaj ri nu'on ri jun itzel samajel ri', xu'ij: C'o runo'j (runa'oj), xcha'. Y ri Jesús chuka' xu'ij: Can quiri' niqui'en ri winak ri man quiniman ta ri Dios. Can c'o quino'j (quina'oj) chiquiwech ka reje'; can más c'o quino'j (quina'oj) que chiquiwech ri quiniman ri Dios y je richi chic ri sakil. ");
INSERT INTO cakNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Y ren nin-ij chiwe, xcha' ri Jesús. Q'uiy mej (paj) ri beyomel chi ri rech-ulef, man utz ta rucusaxic ni'an coma ri winak. Pero xa rix ri jix ralc'ual ri Dios jix beyom, can ticusaj ri ibeyomal chi ye'ito' ri can nic'atzin chi yeto'x. Chi quiri' cuando ri ibeyomal xtiq'uis, xtic'ul iwech chicaj, chupa ri jay ri manak xquieq'uis. ");
INSERT INTO cakNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun ri can utz nu'on riq'uin jun ex ri xa manak más rakalen, can utz chuka' xtu'on riq'uin ri can q'uiy rakalen. Pero ri man utz ta nu'on riq'uin jun ex ri xa manak más rakalen, xa quiri' chuka' xtu'on riq'uin ri can c'o-wi rakalen. ");
INSERT INTO cakNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Y xa riq'uin ri beyomel chi ri rech-ulef, rix man utz ta niben, ¿xtujach como ri Dios ri ketzij beyomel pa ik'a'? ");
INSERT INTO cakNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Roma xa man utz ta niben riq'uin ri beyomel chi ri rech-ulef ri xa xok'nen pa ik'a', quiri' chuka' xtiben riq'uin ri ketzij beyomel, xa ta nujach ri Dios chiwe ri beyomel ri can iwichi-wi rix. ");
INSERT INTO cakNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Y man jun samajel ri yec'ue' ca'i' ru-patrón, roma man nitiquier ta nisamaj quiq'uin ri je ca'i' pa jun tiempo. Roma xa nrojo' jun patrón, itzel nutzu' ri jun chic. Y xa can nunimaj rutzij ri jun, man nitiquier ta nu'on quiri' riq'uin ri jun chic. Y quiri' chuka', manak modo chi c'o ta jun ri benak ránima chirij ri beyomel, y nrojo' chuka' nu'on ri nrojo' ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Y cuando ri achi'a' fariseos xquic'oxaj ri xu'ij ri Jesús xetze'n-ka chirij, roma reje' can benak cánima chirij ri beyomel. ");
INSERT INTO cakNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Y ri Jesús xu'ij chique: Rix can niben chiquiwech ri winak anche'l can choj ri ic'aslen. Pero ri Dios reta'n anchique ri c'o pa iwánima, y man utz ta jixrutzu'. Y más que can utz jixtz'et y chuka' can nim banon chiwe coma ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Y cuando ri Juan Bautista man jani tutz'om rutzijoxic rutzij ri Dios, ja ri ru-ley ri Moisés y ri tz'iban can coma ri achi'a' ri xek'alajin rutzij ri Dios ojer can, jari' ri xecuses. Pero desde que xoka ri Juan, can ja' xtzijos-pe ri utzilaj tzij ri nich'o'n chirij ri ru-gobierno ri Dios. Y je q'uiy winak ri yalan quitijon-pe quik'ij roma can niquijo' chi ja' ta ri Dios nibano gobernar quichi. ");
INSERT INTO cakNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Y chuka' nin-ij chiwe chi can más fácil chi ri rech-ulef y ri rocaj yeq'uis, pero ri nu'ij chupa ri ley can man jun tzij ri xe quiri' xtic'ue' can, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Y ri Jesús xu'ij chuka': Xa c'o jun achi ri nujach-ri' riq'uin ri raxayil y nuc'om-pe jun chic ixok, ri achi re' nu'on mac chech ri Dios. Y xa c'o jun achi ri nuc'uan-e ri ixok ri rujachon-ri' riq'uin ri rachijil, chuka' ri achi ri' nu'on mac chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Y ri Jesús xu'ij chuka': Xc'ue' jun achi yalan beyom. Ri achi re' ruyon jabel tak tziak ri yalan cajil ri yerucusaj, y k'ij-k'ij yeru'on nimalaj tak nimak'ej. ");
INSERT INTO cakNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Xc'ue' chuka' jun achi ri nuc'utuj limosna y nojinak ruch'acul riq'uin ch'ac. Raja' rubinan Lázaro, y can chuchi-rocho ri beyom nic'ue-wi-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ri Lázaro yalan nurayij nutaj ruchi' tak wey ri yetzak chuxe' ru-mesa ri beyom. Y ri tz'i' ye'apon riq'uin chi niquirak' ri ch'ac c'o chirij. ");
INSERT INTO cakNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Y jun k'ij ri achi re' xcom-e, y xuc'uax-e coma ri ángeles chi xapon riq'uin ri Abraham. Y chuka' ri achi beyom xcom, y xmuk. ");
INSERT INTO cakNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Y cuando raja' nu'on chic sufrir chupa ri lugar ri can richi-wi sufrimiento, c'a naj xtzu'n-e, y xutzu' ri Abraham, chuka' xutzu' ri Lázaro rak'el-apo riq'uin ri Abraham. ");
INSERT INTO cakNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Y ri achi beyom riq'uin ruchuk'a' xch'o'n, y xu'ij che ri Abraham: Nata' Abraham, tajoyowaj nuech. Tabana' favor ta'ij che ri Lázaro, chi tuxak'aba' rui-ruk'a', y tataka-pe we', chi noruya-ka chutza'n wak'. Roma can yalan nin-en sufrir chupa ri k'ak' re', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero ri Abraham xu'ij che: Ret walc'ual, toka pa awi', chi cuando xac'ase' chech-ulef, can utz ac'aslen xac'uaj, roma can q'uiy abeyomal xc'ue'. Y ri Lázaro can yalan xu'on sufrir roma can man jun rubeyomal xc'ue', pero cami, raja' c'o utzilaj ruc'aslen ri xorila' we', y ret xa jun c'aslen chi sufrimiento ri xawil. ");
INSERT INTO cakNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y chuka' manak modo, roma c'o jun nimalaj siwan chikacojol. Romari', xa c'o jun chake roj nrojo' napon iwiq'uin, man nitiquier ta. Y xa ta jun chiwe rix nrojo' nipe we' kaq'uin roj, man nitiquier ta chuka', xcha' ri Abraham. ");
INSERT INTO cakNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Y ri achi beyom xu'ij: Xa quiri', ninjo' ninc'utuj favor chawe ret nata' Abraham. Tataka' juba' ri Lázaro chech-ulef pa rocho ri nata'. ");
INSERT INTO cakNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Roma jec'o wo'o' wach'alal, y ninjo' chi ne'ch'o'n ta chique chi quiri' man yepe ta we' chupa ri jun lugar chi sufrimiento, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Y ri Abraham xu'ij che: Reje' c'o rutzij ri Dios ri rutz'iban can ri Moisés quiq'uin. Chuka' rutzij ri Dios tz'iban can coma ri achi'a' ri xek'alajin rutzij ri Dios ojer can. Jari' tiquinimaj, xcha' ri Abraham. ");
INSERT INTO cakNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Y ri achi beyom xu'ij: Can quiri', nata' Abraham. Pero xa c'o jun caminak ri nic'astaj-e y napon quiq'uin ri wach'alal, can xtiquiya' can ri quimac y xtiqui'en ri nrojo' ri Dios, xcha' ri beyom. ");
INSERT INTO cakNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero ri Abraham xu'ij che: Xa man niquinimaj ta rutzij ri Dios ri rutz'iban can ri Moisés, ni man niquinimaj ta chuka' ri quitz'iban can ri achi'a' ri xek'alajin ri rutzij ri Dios ojer can, can man xtiquinimaj ta chuka' jun ri nic'astaj-e chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Y ri Jesús xu'ij chique ri ru-discípulos: Can siempre c'o ri xquiebano chique ri winak chi niqui'en mac. Pero ri nibano che jun chic winak chi nika pa mac, can nimalaj castigo ri xtika pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Jun ri nu'on che jun chic chi nika pa mac, más utz nu'on che xa ta nixim jun nimalaj abaj chi quie'n chukul y niq'uiak chupa ri mar, que chech nu'on che jun co'l oc chi nika pa mac. ");
INSERT INTO cakNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Romari' rix tibana' cuenta iwi'. Y xa c'o jun awach'alal nu'on jun retzelal chawe, tach'olij y ta'ij che chi can itzel ri xu'on chawe. Y xa ri xbano quiri' chawe nujal runo'j (runa'oj) y noru'ij chawe chi tacoch'o' (tacuyu') rumac, can tacoch'o' (tacuyu'). ");
INSERT INTO cakNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Y xa pa jun k'ij wuku' mej (paj) nu'on retzelal chawe y wuku' mej (paj) chuka' nitzolaj ta pe awiq'uin y noru'ij chawe: Tacoch'o' (Tacuyu') numac; can tacoch'o' (tacuyu') rumac, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Y ri apóstoles xqui'ij che ri Ajaf Jesús: Tabana' chake chi nakaya' más kánima riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Pero ri Ajaf Jesús xu'ij chique: Xa ta rix iyo'n iwánima riq'uin ri Dios, más que xe ta juba' oc anche'l jun rija'tz' mostaza, y ni'ij ta che ri che' sicómoro re' chi tel-e we' y tik'ax chupa ri mar chi nerutica-ri' chiri', ri che' ri' can xquixrunimaj-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Y xa ta jun chiwe rix c'o ta jun rusamajel, y rutakon-e pa k'ayis chi xberu'ona arar ri ulef o chi xeberuchajij awaj, ¿xe como nitzolaj-pe ja' nu'ij che: Catoc-pe, cach'oquie' chuchi' mesa y cawa'? Manak. ");
INSERT INTO cakNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Pa ruq'uiexel ri' nu'ij che: Tabana' ru'onic ri nu-cena, y tabana' abanic chi yinawilij-pe chi yiwa', y c'a xquicolaj na ren, c'ajari' xcawa' ret. ");
INSERT INTO cakNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Y nuya' como matiox che ri samajel roma xu'on ri xu'ij che? Man jun. ");
INSERT INTO cakNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Y can anche'l ri samajel ri', quiri' chuka' rix. Cuando ibanon chic ri samaj ri nu'ij ri Dios chiwe, ti'ij: Roj joj samajel ri man jun jojc'atzin-wi. Roma can xe ri bin chake, xe ri' ri xka'an, quixcha', xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Y cuando ri Jesús y ri ru-discípulos xquitz'om chic e bey pa Jerusalem, xek'ax chiquicojol ri lugar quibinan Samaria y Galilea. ");
INSERT INTO cakNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Y cuando xe'apon pa jun co'l tenemit, jec'o je lajuj achi'a' ri c'o ri yabil lepra chiquij. Ri achi'a' ri' xebe'el-pe chech ri Jesús y can c'a naj xepa'e-wi-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Y cuando xech'o'n, can riq'uin quichuk'a' xech'o'n-apo che ri Jesús y xqui'ij: Ajaf, tajoyowaj kawech roma ri kabanon, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Y ri Jesús can xerutzu' y xu'ij chique: Ic'utu-iwi' chiquiwech ri sacerdotes, xcha-e ri Jesús chique. Y cuando je-benak, ri quiyabil xq'uis-e y can ch'ajch'oj xqui'en-ka. ");
INSERT INTO cakNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Y jun chique ri lajuj achi'a', cuando xutzu' chi can xc'achoj-wi riq'uin ri ruyabil, xtzolaj-pe. Y can nuya' ruk'ij ri Dios, y can riq'uin ruchuk'a' nich'o'n cuando nuya' ruk'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Y cuando xapon riq'uin ri Jesús, xxuquie' chech y xulucuba-ka-ri' chech, y yalan nuya' matiox che. Ri achi re' aj-Samaria. ");
INSERT INTO cakNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Y ri Jesús xu'ij: ¿Man je lajuj ta c'a ri can ch'ajch'oj xqui'en-e riq'uin ri quiyabil? ¿Y ri beleje' chic? ");
INSERT INTO cakNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Can man jun chic ri xtzolaj-pe chi noruya' ruk'ij ri Dios? ¿Xe ri jun ri man israelita ta ri xtzolaj-pe chi noruya' ruk'ij ri Dios? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Y ri Jesús xu'ij chuka' che ri achi aj-Samaria: Cacataj y jat (cabin). Xac'achoj roma can xaya' awánima wiq'uin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Y ri achi'a' fariseos xquic'utuj che ri Jesús chi jampe' xteru'ona' gobernar ri Dios. Y ri Jesús xu'ij chique: Ri' man jun xtina'en jampe' xtoka, roma ri ru-gobierno ri Dios man nitz'etetaj ta. ");
INSERT INTO cakNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Y man jun xti'in chi ja' c'o we', o ja' c'o chila', roma ri ru-gobierno ri Dios c'o chic iwiq'uin, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Y raja' xch'o'n chique ri ru-discípulos, y xu'ij: Xquiepe k'ij cuando rix xtirayij chi yic'ue' ta iwiq'uin más que xe jun k'ij, ren ri jin-kajinak-pe chicaj y xinalex chi'icojol; pero can manak xquinitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Y can jec'o ri xquie'in chiwe: Ja' c'o we' o ja' c'o chila'. Pero rix man quixbe quiq'uin, ni man quie'itzeklebej chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Roma cuando xtapon ri k'ij chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol yipe chic jun mej (bey), xquinoka anche'l jun relámpago ri can k'alaj roma sakil nu'on che ronojel ri rocaj. ");
INSERT INTO cakNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero na'ey che ri' ren xtink'axaj na q'uiy sufrimiento, y chuka' can itzel xquitz'et coma ri winak chi ri tiempo re'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Y ri k'ij cuando xquipe ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xtibanataj chuka' anche'l ri xbanataj chupa ri tiempo cuando xc'ue' ri Noé. ");
INSERT INTO cakNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chupa ri ru-tiempo ri Noé, ri winak xe ri quiway y cuq'uia' xe ri' niquinojij, y chuka' xe c'ulubic yequinataj; can xe ri' niquinojij, c'aja' cuando xapon ri k'ij chi ri Noé y ri ru-familia xe'oc chupa ri nimalaj arca, ri anche'l jun barco, y xtiquier ri nimalaj job ri x-ix diluvio che, y conojel ri manak xe'oc chupa ri arca xecom. ");
INSERT INTO cakNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Y can quiri' chuka' xbanataj pa ru-tiempo ri achi ri xubinaj Lot. Ri winak xe benak cánima chirij ri anchique niquitijla' y anchique niquikumula', chirij quilok'oj y quic'ayij, quiticoj y ri banoj-cocho. ");
INSERT INTO cakNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Y ri k'ij cuando ri Lot y ri ru-familia xquiya' can ri tenemit Sodoma, ja' xka k'ak' y azufre parui' ri tenemit. Can anche'l job xu'on cuando xka-pe chicaj, y can conojel ri winak ri jec'o chiri' xeq'uis roma ri k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Y quiri' xtibanataj ri k'ij cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xquinok'alajin-ka we' chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Ri xa nuxlan parui' ri rocho cuando xtapon ri k'ij ri', choj quiri' tilumaj-e (tinimaj-e). Man toc chic apo pa jay chi c'o ri neruc'ama-pe. Y xa c'o chuka' jun ri nisamaj pa k'ayis chupa ri k'ij ri', man chic titzolaj chirocho. ");
INSERT INTO cakNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Roma toka pa iwi' ri xuc'ulumaj ri raxayil ri Lot, cuando ri Dios xuporoj ri tenemit Sodoma. ");
INSERT INTO cakNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ri can nupokonaj ri ruc'aslen we' chech-ulef, man xtiril ta ruc'aslen ri manak xtiq'uis. Pero ri man nupokonaj ta ri ruc'aslen we', ri ruc'aslen can man xtiq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Y cuando ren xquipe chic jun mej (bey), xa jec'o ca'i' yewer pa jun ch'at, jun jinruniman y ri jun chic manak, xe ri jun ri jinruniman xtic'uax-e y ri jun chic xtic'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Y xa jec'o ca'i' ixoki' ri junan yequie'n, xe ri jun ri jinruniman xtic'uax-e y ri jun chic xtic'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Y xa jec'o je ca'i' achi'a' ri junan chuka' yesamaj pa k'ayis, xe chuka' ri jun ri jinruniman xtic'uax-e y ri jun chic xtic'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Y cuando ri discípulos quic'oxan chic ri xu'ij ri Jesús, xquic'utuj che: Ajaf, ¿anchi' xtibanataj-wi re'? Y ri Jesús xu'ij chique: Ri k'ij ri' can xtibanataj anche'l niqui'en ri c'uch. Roma anchi' c'o-wi jun caminak, chiri' yeka-wi reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Y ri Jesús xutzijoj jun ejemplo chique ri ru-discípulos chi nuc'ut chiquiwech chi can nic'atzin-wi chi siempre niqui'en ta orar y man tiquimalij. ");
INSERT INTO cakNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Raja' xu'ij chique: Pa jun tenemit xc'ue' jun juez ri can man nuxi'j ta ri' chech ri Dios, y chuka' chech raja' man jun quikalen ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Y chuka' chupa ri tenemit ri', c'o jun ixok-malca'n. Y ri ixok re' ntel-ntoc riq'uin ri jun juez ri', chi nuc'utuj favor che chi tuto' chirij ri jun ri banayon etzelal che. ");
INSERT INTO cakNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Y q'uiy tiempo xk'ax, y ri juez re' man nrojo' ta nuto' ri ixok-malca'n. Pero jun k'ij ri juez re' xunojij-ka pa ránima: Más que man ninxi'j ta wi' chech ri Dios, chuka' chinuech ren man jun quikalen ri winak, ");
INSERT INTO cakNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","pero roma ri ixok re' ntel-ntoc wiq'uin, más utz ninto-e. Roma xa man ninto' ta, xtik'ax nuc'u'x riq'uin, roma siempre xtoka. Quiri' nu'ij ri ejemplo ri xutzijoj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Y c'ajari' ri Ajaf Jesús xu'ij: Ren weta'n chi rix xic'oxaj ri xeru'ij ri juez re', más que raja' man utz ta runo'j (runa'oj). ");
INSERT INTO cakNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Quiri' chuka' ri Dios can xquieruto' ri winak ri jerucha'on chic, ri pak'ij chi chak'a' niqui'en orar. ¿O ri Dios xtu'on como chique chi tiquiyobej q'uiy tiempo y c'ajari' xquieruto'? ");
INSERT INTO cakNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ren can nin-ij chiwe chi ch'anin xquieruto-pe. Y cuando ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xquipe chic jun mej (bey) we' chech-ulef, ¿c'a jec'o como winak ri c'a quiyo'n cánima riq'uin ri Dios? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Y ri Jesús xutzijoj jun chic ejemplo chiquiwech ri winak, roma jec'o chique reje' ri niquinojij chi can je chojmilaj tak winak, y xa itzel yequitzu' ri ch'aka chic. Romari' ri Jesús xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Jec'o je ca'i' achi'a' ri xe'apon pa rocho ri Dios chi niqui'en orar. Jun fariseo, y jun achi moloy-impuesto. ");
INSERT INTO cakNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ri fariseo pa'l nu'on orar, y nu'ij pa ru-oración: Dios, matiox ninya' chawe roma ren man jin junan ta quiq'uin ri ch'aka chic. Roma ri ch'aka chic winak je elek'oma', y chuka' yequicanoj ch'aka chic ixoki' más que je-c'ulan, y man quic'uan ta jun chojmilaj c'aslen. Ni man jin junan ta chuka' riq'uin ri jun achi moloy-impuesto la c'o-apo la'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Roma ren, can ca'i' k'ij pa jun semana ri nin-en ayunar. Y ronojel ri ninch'ec, lajuj partes nin-en che, y jun chique ri lajuj partes ri' ninya' chawe ret, xcha' ri fariseo pa ru-oración. ");
INSERT INTO cakNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero ri achi moloy-impuesto c'a naj xpa'e-wi can chi nu'on orar. Raja' xulucuba' rujolon; quiri' xu'on, roma chech raja' can man utz ta ni xe nitzu'n chicaj, roma nuna' chi can q'uiy rumac; romari' nutin ruc'u'x che ruk'a' y nu'ij: Dios, tajoyowaj nuech, roma ren jin jun achi ri q'uiy mac jenubanon-pe chawech. ");
INSERT INTO cakNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Y ri Jesús xu'ij chuka': Can ketzij nin-ij chiwe chi ri achi moloy-impuesto xtzolaj-e chirocho, y man jun chic rumac xrakalej chech ri Dios. Pero ri fariseo man quiri' ta xu'on chech ri Dios. Roma xabachique (xama'anchique) winak ri nuna' chi c'o ruk'ij, can xtikases ruk'ij. Pero ri nuna' chi manak oc ruk'ij, can nim ruk'ij xti'an che, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Y ri winak yequic'om-pe ac'uala' riq'uin ri Jesús, chi nuya' ruk'a' pa quiwi' y yeru'on ta bendecir. Y ri ru-discípulos xquitzu', y xqui'ij chique ri winak que man tiqui'en quiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero ri Jesús xeroyoj ri ac'uala' y xu'ij: Tiya' lugar chique ri ac'uala' chi yepe wiq'uin, y man quie'ik'at. Roma ri ru-gobierno ri Dios, xe quichi ri je anche'l ac'uala'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Y can ketzij ri nin-ij chiwe, ri man niqui'en ta anche'l ri ac'uala' chi niquijach-qui' chuxe' ri ru-gobierno ri Dios, can man xquietiquier ta xquie'oc quiq'uin ri ye'an gobernar roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Y c'o jun achi ri yalan ruk'ij, xu'ij che ri Jesús: Utzilaj Maestro, ¿anchique ri utz nin-en ren chi ninwil ri c'aslen ri man niq'uis ta? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Y ri Jesús xu'ij che: ¿Anchique roma na'ij utz chue ren? Roma man jun winak utz, xe ri Dios utz. ");
INSERT INTO cakNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Y ren nin-ij chi ret can aweta'n ri lajuj mandamientos ri xuya' ri Dios che ri Moisés ojer can, ri nu'ij: Ret ri c'o awaxayil man tacanoj jun chic ixok, man cacamisan, man catelak', man tatz'uc tzij chirij jun chic winak, quie'abana' respetar ate-atata', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Y ri achi xu'ij che ri Jesús: C'a jin co'l cuando nubanon-pe ronojel ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Cuando ri Jesús xuc'oxaj re', xu'ij: C'a c'o jun ex man abanon ta. Man ayo'n ta abeyomal chique ri winak ri manak quibeyomal. Tac'ayij ronojel ri c'o awiq'uin y ri rajil tajacha' chique ri winak ri manak quibeyomal, y xtic'ue' abeyomal chicaj. Y catampe wiq'uin y quinatzeklebej, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Y cuando ri achi xuc'oxaj ri xu'ij ri Jesús, yalan xbison-ka ránima, roma can q'uiy ri rubeyomal c'o y man nrojo' ta nusipaj. ");
INSERT INTO cakNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Y cuando ri Jesús xutzu' chi xbison-ka ránima ri achi, xu'ij: Ri winak ri c'o q'uiy quibeyomal, can cuesta chi ye'oc quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Xa más la'k nitiquier nik'ax jun camello pa jun ch'uti' rujulil jun acux, que chech jun beyom ntoc quiq'uin ri ye'an gobernar roma ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ri xec'oxan ri xu'ij ri Jesús, xqui'ij: Xa can quiri-wi anche'l ri nu'ij, man jun xticolotaj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Y ri Jesús xu'ij chique: Ri winak man ronojel ta yetiquier niqui'en. Pero ri Dios can ronojel nitiquier nu'on, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Y ja cuando xpe ri Pedro xu'ij: Ret aweta'n chi roj kayo'n can ri c'o kaq'uin, roma jatkatzekleben. ");
INSERT INTO cakNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Y ri Jesús xu'ij chique: Can ketzij ri nin-ij chiwe, chi xabachique (xama'anchique) winak ri jeruyo'n can rocho, rute-rutata', rach'alal, raxayil o ralc'ual, chi nu'on rusamaj ri Dios y yeruto' ri ye'oc quiq'uin ri ye'an gobernar roma ri Dios; ");
INSERT INTO cakNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","can q'uiy yan ri niyo'x che chupa ri tiempo re'. Y chupa apo ri jun chic tiempo chakawech apo, can xtiyo'x ruc'aslen ri manak xtiq'uis. ");
INSERT INTO cakNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Y ri Jesús xeroyoj juba' juc'an ri cablajuj ru-discípulos chi nich'o'n quiq'uin, y xu'ij: Rix iweta'n chi c'a pa tenemit Jerusalem jojapon-wi, y chiri' q'uiy ri xti'an chue ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. Roma chiri' xtibanataj-wi ronojel ri tz'iban can chuij coma ri achi'a' ri xek'alajin rutzij ri Dios ojer can. ");
INSERT INTO cakNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Xquijach pa quik'a' winak ri man je israelitas ta. Y ri winak ri' xquietze'n chuij, xtiquibila' cowilaj tak tzij chue y xquinquichubaj. ");
INSERT INTO cakNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Xquinquich'ey, y c'ajari' xquinquicamisaj. Pero pa rox k'ij xquic'astaj-pe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ri ru-discípulos man xqui'en ta entender ri xu'ij. Ri tzij ri' xa ewan chiquiwech, romari' xe xquic'oxaj y man quieta'n ta anchique xrojo' xu'ij chique. ");
INSERT INTO cakNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Cuando ri Jesús ntoc yan apo pa tenemit rubinan Jericó, chiri' chuchi-bey ch'ocol jun achi moy, y nuc'utula' limosna chique ri winak ri yek'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Y cuando ri moy re' xuc'oxaj chi q'uiy winak yek'ax, xuc'utuj chi anchique xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y xqui'ij che chi ja ri Jesús aj-Nazaret ri nik'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Y ri achi moy riq'uin ruchuk'a' xch'o'n, y xu'ij: Jesús, ri jat ru-familia can ri rey David, tajoyowaj nuech, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Y ri winak ri na'ey je-benak chech ri Jesús, xquich'olij ri achi chi quiri' man chic tich'o'n-apo. Pero raja' xa riq'uin más ruchuk'a' xch'o'n, y xu'ij: Ret ri jat ru-familia can ri rey David, tajoyowaj nuech roma ri nubanon, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Y ri Jesús xuc'oxaj ri achi, romari' xpa'e-ka y xu'ij chi tiquic'ama-pe. Y cuando c'o chic ri achi chech ri Jesús, xuc'utuj che: ");
INSERT INTO cakNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Anchique ri najo'? Y ri achi moy xu'ij: Ajaf, ren ninjo' yitzu'n, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Y ri Jesús xu'ij che: Catzu'n c'a. Roma xaya' awánima wiq'uin, xac'achoj. ");
INSERT INTO cakNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Y ri achi moy can ja' xtzu'n y can xutzeklebej-e ri Jesús, y can xuya' ruk'ij ri Dios. Y conojel ri winak ri xquitzu' chi ri moy xtzu'n, can xquiya' chuka' ruk'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Y ri Jesús y ri ru-discípulos xe'oc-apo pa tenemit Jericó, y nik'ax chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Y chupa ri tenemit ri' c'o jun achi beyom rubinan Zaqueo. Ri achi re', jare' ri más c'o ruk'ij chiquiwech ri juley chic ri niquimol impuestos. ");
INSERT INTO cakNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Y raja' can nutaj ruk'ij chi nutzu' ri Jesús, pero roma can je q'uiy winak jec'o y raja' xa co'l oc rakan, romari' man nitiquier ta nutzu-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Romari' raja' junanin xna'ey-e y xbejote' chuk'a' jun che' ri ni'ix sicómoro che, chi quiri' nitiquier nutzu' ri Jesús, roma chiri' nik'ax na-wi raja'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Y cuando ri Jesús nik'ax chiri', xtzu'n-e chicaj chuk'a' ri che', y xu'ij che ri Zaqueo: Zaqueo, ch'anin caka-pe, roma cami nic'atzin chi yinapon chi'awocho, chi yinuxlan juba' chiri', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo can xe xuc'oxaj ja ch'anin xka-pe, y can niquicot xuc'ul-apo rech ri Jesús pa rocho. ");
INSERT INTO cakNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Cuando ri winak quiri' xquitzu', xqui'ij-ka chi ri Jesús xa pa rocho jun achi aj-mac xbec'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Y ri Zaqueo xpa'e' y xu'ij che ri Ajaf Jesús: Ajaf, cami nic'aj che ri nubeyomal ninya' chique ri winak ri manak quibeyomal. Y xa jec'o ri can c'o nulek'an chiquik'a', can quieji' chic más ruq'uiexel xtintzolej chique. ");
INSERT INTO cakNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Y ri Jesús xu'ij che: Cami ja xapon ri k'ij chi ri jec'o chupa ri jay re' yecolotaj, roma ret can xaya' awánima riq'uin ri Dios, y chuka' can jat jun chique ri ru-familia can ri Abraham. ");
INSERT INTO cakNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Roma ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xipe-wi chi yencanoj y chi yencol ri jec'o pa mac, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Y cuando ri Jesús ru'in chic ronojel re' chique ri winak, xutzijoj jun ejemplo chique. Quiri' xu'on roma nakaj chic jec'o-wi che ri Jerusalem y roma chuka' ri winak ri yec'oxan richi, niquinojij chi cuando raja' xtoc-apo pa tenemit, can ja' xte'k'alajin ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Y raja' xu'ij: Xc'ue' jun achi ri can c'o ruk'ij. Ri achi re' xbe naj pa jun chic rech-ulef, chi ni'an-pe rey che. Y c'ajari' nitzolaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero cuando c'a man jani tibe, xeroyoj je lajuj rusamajel y xuya' can q'uiy mero chique chiquijunal, y xu'ij chique: Tic'uaj ri mero ri xinya' can chiwe chi quiri' c'o nich'ec chirij, c'a cuando xquitzolaj-pe ren, xcha' can chique, y xbe. ");
INSERT INTO cakNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Y cuando c'o chic chupa ri rech-ulef anchi' ni'an-pe rey che, jec'o achi'a' ri xetak-e pa quibi' conojel ri ruwinak y xe'apon c'a anchi' c'o-wi raja'. Y ri achi'a' re' xbequi'ij: Roj manak nakajo' chi ri achi re' ntoc-pe rey pa kawi', xecha'. Ri je-takayon-e ri achi'a' ri', can itzel niquitzu' ri achi ri ni'an-pe rey che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero ri jun achi ri' x-an na-wi rey che, y xtzolaj-pe. Y cuando c'o chic pa ru-nación, xutak coyoxic ri rusamajel ri xuya' can mero chique cuando raja' man jani tibe, roma nrojo' nuna'ej jani' mero quich'acon chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Cuando xapon ri na'ey samajel, xu'ij: Ajaf, ri mero ri xaya' can chue chi quiri' c'o ninch'ec chirij, can xinch'ec na-wi lajuj más parui', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Y ri achi, rey chic ri tiempo ri', xu'ij che ri rusamajel: Can utz ri xa'an. Jat jun utzilaj samajel. Y roma can utz xa'an riq'uin ri juba' ri xinya' can chawe, cami ninya' lajuj tenemit pa ak'a' chi ye'aben gobernar, xcha' ri rey. ");
INSERT INTO cakNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Y cuando xapon jun chic samajel, xu'ij: Ajaf, ri mero ri xaya' can chue cuando xabe, xinch'ec wo'o' más parui', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Y ri rey xu'ij chuka' che ri jun samajel re': Roma utz ri xa'an riq'uin ri juba' ri xinya' can chawe, cami ninya' wo'o' tenemit pa ak'a' chi ye'aben gobernar, xcha' ri rey che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Pero ri jun chic samajel xapon, y xu'ij che: Ajaf, ja a-mero re' nonya' can chawe. Ri mero re' xinpis pa jun pañuelo y xinyec. ");
INSERT INTO cakNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Roma ren ninxi'j-wi' chawech. Roma ret can ronojel nach'ojij y ronojel najal chi ayowal. Can jat junan riq'uin jun achi ri nerulesaj mero pa banco y xa man jun ru-mero ruyo'n chiri'. Y chuka' najo' namol cosecha anchi' man ja' ta ret jat-tiquiyon-ka, xcha' ri samajel che ri rey. ");
INSERT INTO cakNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Y ri rey xu'ij che ri samajel ri': Ret man jat utzilaj ta samajel. Ri tzij ri xa'ij-ka jari' ri xtincusaj chi jatin-en juzgar. Roma xa can aweta'n chi ren can cof wánima, chi ren can nenlesaj-pe mero anchi' man jun nuyo'n can, y chuka' can ninmol cosecha ri ntel pa jun ticoj ri man ja' ta ren jin-tiquiyon; ");
INSERT INTO cakNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","xa quiri' na'ij ret, ¿anchique roma man xaya' ta ri nu-mero pa banco? Chi quiri' cami ri xitzolaj-pe nenc'ama' ta pe ri nu-mero y ri interés ri xuch'ec, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Y ri rey xu'ij chique ri jec'o chiri': Timaja' can ri mero chuk'a', y tiya' che ri jun ri xuch'ec lajuj más parui' ri xinya' can che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Y ri jec'o chiri' xqui'ij: Ajaf, pero raja' c'o yan q'uiy mero pa ruk'a', xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Pero raja' xu'ij chique: Ren nin-ij chiwe, chi ri can c'o q'uiy riq'uin, xtiyo'x más che. Pero ri xe juba' c'o riq'uin, ri jani' oc ri c'o riq'uin can xtimaj che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Cami c'a, ninjo' yich'o'n chiquij ri itzel yetz'eto wichi y ri man xquijo' ta chi ren xinoc can rey: Quie'ic'ama-pe, y quiecamises chinuech, xcha' ri rey. Quiri' xu'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Y cuando ri Jesús xu'ij yan re' chique, xutz'om chic bey chiquiwech ri ru-discípulos chi ye'apon pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Y cuando ye'apon yan pa tenemit Betfagé y Betania ri jec'o chech ri juyu' rubinan Olivos, ri Jesús xerutak-e ca'i' ru-discípulos, ");
INSERT INTO cakNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","y xu'ij-e chique: Quixoc-apo chupa la co'l tenemit la', y can xe xquixoc, ja' xtiwil jun alaj burro ximil can chiri', ri c'a man jun ch'ocolbeyon richi. Tisolo' y tic'ama-pe chue. ");
INSERT INTO cakNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Y xa c'o xti'in chiwe chi anchique roma nisol-pe ri alaj burro, ti'ij can che chi nic'atzin juba' che ri Ajaf, xcha-e chique. ");
INSERT INTO cakNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ri ca'i' discípulos ri xetak-e, xebe, y can xquiwil-wi ri burro, can anche'l ri bin-e chique roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Y cuando ja' niquisol, ri rajaf xqui'ij-pe chique: ¿Anchique roma nisol-e ri burro? xecha-pe chique. ");
INSERT INTO cakNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y ri ru-discípulos ri Jesús xqui'ij can chique: Xa nic'atzin che ri Ajaf, xecha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Y xquic'om-pe che ri Jesús. Y reje' xquiyala' chuka' jujun quitziak chirij ri burro, y xquich'ocoba-e ri Jesús chirij. ");
INSERT INTO cakNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Y cuando benak ri Jesús, ri winak niquiriq'uila' jujun quitziak pa rubey chi niquiya' ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y cuando ya yexule-ka chiri' parui' ri juyu' Olivos, conojel ri quitzekleben ri Jesús je-benak, roma niquicot cánima, riq'uin ronojel quichuk'a' niquiya' ruk'ij ri Dios. Quiri' niqui'en roma ri milagros ri jequitz'eton riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Reje' niqui'ij: ¡Ri Rey re' yo'n-pe bendición pa ruwi' roma ri Ajaf Dios! ¡Can pa rubi-wi ri Ajaf Dios petenak-wi! ¡Yequicot ri jec'o chicaj! ¡Q'uiy ruk'ij ri Dios niyo'x chila' chicaj! yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Y chiri' chiquicojol ri winak je-benak jujun achi'a' fariseos. Y reje' xqui'ij che ri Jesús: Maestro, ta'ij chique ri yetzekleben awichi, chi quietane-ka, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero ri Jesús xu'ij chique: Can ketzij nin-ij chiwe, xa yetane-ka reje', ja ri abaj xquiebech'o'n-pe chi niquiya' nuk'ij, xcha' chique ri fariseos. ");
INSERT INTO cakNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y ri Jesús xutzu' ri tenemit Jerusalem, cuando más nakaj chic jec'o-apo. Raja' xrok'ej ri tenemit ri', ");
INSERT INTO cakNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","y xu'ij: Rix ri jixc'o pa Jerusalem, más que c'aja' ta cami niben ta entender rix chuka' ri ancu'x (anchique) niyo'n uxlanen pa tak iwánima. Pero roma can ewan can chiwech, romari' man jixtiquier ta nitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Roma xquie'apon k'ij cuando jumul xti'an chiwe, roma q'uiy soldados xquiebecataj-pe chiwij, y xtiquisururej ri itenemit che jun chic xan, y xquixquiya' pa sufrimiento, roma pa quinic'ajal xquixc'ue-wi can. ");
INSERT INTO cakNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Xtiquikasaj pa ulef ri itenemit y chuka' rix. Y pa itenemit man jun jay xtipa'e' can. Can conojel xquiewulix. Roma can man nitzu' ta chi ri Dios xoka yan iwiq'uin, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cuando ri Jesús xapon, xoc-apo pa rocho ri Dios ri c'o chiri' pa Jerusalem, y ja xerokotaj-pe ri c'ayinel y ri yelok'on chiri' pa rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y xu'ij chuka' chique: Chupa rutzij ri Dios tz'iban can chi ri wocho, jay chi oración; pero rix xa anche'l quijul elek'oma' ibanon che, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y ri Jesús k'ij-k'ij xerutijoj ri winak riq'uin rutzij ri Dios, chiri' chupa ri rocho ri Dios. Pero ri nimalaj tak sacerdotes y ri maestros chi ri ley y ri achi'a' ri can c'o-wi quik'ij chupa ri tenemit, niquicanoj anchique niqui'en chi niquicamisaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Y man niquiwil ta anchique niqui'en, roma ri winak can jabel quic'oxan ri nu'ij ri Jesús chique. Can niquiya' quixiquin chi niquic'oxaj ri anchique nuk'alajij ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Y jun k'ij, cuando ri Jesús c'o pa rocho ri Dios nuc'ut y chuka' nutzijoj ri utzilaj rutzij ri Dios chique ri winak, ja xeloka riq'uin, ri nimalaj tak sacerdotes, ri maestros chi ri ley y chuka' ri rijilaj tak achi'a' ri c'o quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Y ri achi'a' re' xqui'ij che ri Jesús: Ta'ij chake: ¿Ancu'x (Anchique) yoyo'n uchuk'a' pa ak'a' chi xe'awokotaj-e ri winak yec'ayin we' pa rocho ri Dios? ¿Y ancu'x (anchique) yoyo'n lugar chawe chi ye'aben ronojel ex re' chiquicojol ri winak? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xu'ij chique: Ren c'o chuka' ninjo' ninc'utuj chiwe. Ti'ij chue: ");
INSERT INTO cakNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ja ri Dios ri x-in che ri Juan chi quieru'ona' bautizar ri winak? ¿O xa winak xe'in che? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Pero ri nimalaj tak sacerdotes, ri maestros y ri rijilaj tak achi'a' ri c'o quik'ij, xqui'ij-ka chiquiwech: ¿Anchique naka'ij che ri Jesús cami? xecha-ka. Roma xa naka'ij che chi ri Juan ja ri Dios takayon-pe richi, ri Jesús xtu'ij chake chi anchique roma man xkanimaj ta rutzij. ");
INSERT INTO cakNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Y xa naka'ij che chi ja ri winak xe'in che ri Juan chi tu'ona' quiri', xquiepe conojel winak y xkojquicamisaj che abaj. Roma ri winak can quieta'n chi ri Juan can xuk'alajij-wi ri x-ix che roma ri Dios, xecha-ka chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Y c'ajari' xqui'ij-apo che ri Jesús chi reje' man quieta'n ta ancu'x (anchique) x-in che ri Juan chi quieru'ona' bautizar ri winak, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Y ri Jesús xu'ij chique ri achi'a' ri': Roma rix man xixtiquier ta xi'ij chue, ren man xtin-ij ta chuka' chiwe ancu'x (anchique) yoyo'n uchuk'a' chue chi yenben quiere', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Y ri Jesús xch'o'n chiquiwech ri winak, y xutzijoj jun ejemplo chique y xu'ij: Xc'ue' jun achi ri xutic uva pa rulef. Y xuya' can pa kajic chique jujun achi'a'. Y raja' xbe q'uiy tiempo. ");
INSERT INTO cakNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Y cuando xoka ri tiempo chi ri cosecha, ri rajaf ri ulef xutak-pe jun rusamajel quiq'uin ri achi'a' ri quikajon ri ulef chi neruc'utuj-pe ri uva, roma riq'uin ri' nitoj-wi ri rukajic ri ulef. Pero cuando xapon ri samajel quiq'uin ri achi'a' ri', xquitz'om ri samajel y xquich'ey, y man jun uva xquiya-e che. ");
INSERT INTO cakNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Y ri rajaf ri ulef xutak jun chic rusamajel chi neruc'ama' juba' uva richi ri ulef. Pero ri achi'a' ri' xquitz'om chuka' ri samajel ri' y xquich'ey. Can pokon xqui'en y xqui'ij-e che, y chuka' man jun uva richi ri ulef xquiya-e che. ");
INSERT INTO cakNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ri rajaf ri ulef xutak jun rox samajel chi neruc'ama' juba' uva richi ri ulef, pero can quiri' chuka' xuc'ulumaj. Xquisocola-e, y xquikotaj-e. ");
INSERT INTO cakNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Y pa ruq'uisbel, ri rajaf ri ulef xu'ij-ka: ¿Anchique xtin-en cami? xcha'. Y raja' c'o jun ralc'ual ri yalan nrojo', y jari' ri xutak-e chi neruc'ama' ri uva richi ri ulef. Roma raja' xunojij-ka chi ri achi'a' ri quikajon ri ulef, xquieniman cuando xtiquitzu' chi ja ri ralc'ual ri napon. ");
INSERT INTO cakNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero ri achi'a' ri quikajon ri ulef, can xe xquitzu' ri ralc'ual ri rajaf ri ulef, xqui'ij chiquiwech: Jare' ri ne'oc rajaf ronojel ri ulef ri kakajon cami. Cami kacamisaj, chi quiri' pa kak'a' roj nic'ue' can ri ulef, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Y can quiri' xqui'en. Xquilesaj-e ri ralc'ual chiri' chupa ri rulef y xquicamisaj. Y ri Jesús xu'ij: ¿Anchique como xtu'on ri rajaf ri ulef chique ri achi'a' ri'? ");
INSERT INTO cakNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ri rajaf ri ulef xtipe y xquierucamisaj, y ri ulef xtuya' chic pa kajic chique ch'aka chic, xcha' ri Jesús. Cuando ri winak quic'oxan chic ronojel re', xqui'ij: Can man ta quiri' xtibanataj kaq'uin roj, xecha-ka. ");
INSERT INTO cakNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Y ri Jesús xerutzu' ri winak, y xu'ij: ¿Anchique como nrojo' nu'ij chupa rutzij ri Dios ri tz'iban can? ri nu'ij: C'o jun Abaj ri man xka ta chiquiwech ri achi'a' ri je banoy-jay. Pero xa ja ri Abaj ri' ri xc'atzin, roma can jari' ri xcuses chi quiri' ri jay man nitzak ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Y xabachique (xama'anchique) winak ri xtitzak parui' ri jun Abaj re', can jumul xtimulumu'. Y xabachique (xama'anchique) winak ri xtika ri Abaj re' chirij, can xtuquie'j jumul, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Y ri nimalaj tak sacerdotes y ri maestros chi ri ley, can ja' yan xquijo' niquitz'om-e ri Jesús, roma xquina'ej chi ri achi'a' kajoy-ulef ri xerunataj chupa ri ejemplo, xa chiquij reje' xch'o'n-wi. Pero man xquitz'om ta, roma niquixi'j-qui' chiquiwech ri winak ri jec'o riq'uin. Y quiri' xebe. ");
INSERT INTO cakNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Y ri nimalaj tak sacerdotes y ri maestros ri' xequitak-pe ch'aka chic achi'a' ri can anche'l chojmilaj tak winak yetzu'n, pero xa man quiri' ta. Reje' xa c'o niquijo' niquic'utuj che ri Jesús, chi quiri' nitzak ta pa quik'a' roma ri tzij ri yeru'ij. Y xa nika ri Jesús pa quik'a', niquijach pa ruk'a' ri gobernador. ");
INSERT INTO cakNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Y chi niqui'en quiri' che ri Jesús, ri achi'a' ri' xquic'utuj che: Ret ri jat jun Maestro, roj can keta'n chi can ketzij ri natzijoj. Man naxi'j ta awi' chech jun winak, más que can yalan ruk'ij. Y can nac'ut-wi rutzij ri Dios y can ja-wi rubixic na'an che. ");
INSERT INTO cakNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ta'ij chake: ¿Utz como nakatoj ri impuestos ri nu'ij ri rey César, o xa man utz ta? xecha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Pero ri Jesús can reta'n-wi ri niquinojij chirij, romari' raja' xu'ij chique: ¿Anchique roma rix nitaj ik'ij chi yinitojtobej? ");
INSERT INTO cakNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Tic'utu' ri mero chinuech, xcha'. Y ri Jesús xuc'utuj: ¿Anchok rupalaj y anchok rubi' ri c'o chech la mero? Y reje' xqui'ij che: Chi ri rey César, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Y ri Jesús xu'ij chique: Tiya' che ri César ri can richi-wi ri César, y tiya' che ri Dios ri can richi-wi ri Dios, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Y ri achi'a' ri xec'utun ri' che ri Jesús, man xetiquier ta chirij, roma ri Jesús ronojel tzij can pa rubeyal-wi yeru'ij chique, chiquiwech ri winak. Y can anchique la xquina' cuando xquic'oxaj ri xu'ij ri Jesús chique. Romari' man chic xech'o'n ta apo che. ");
INSERT INTO cakNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Y jec'o jujun chique ri achi'a' saduceos xe'apon riq'uin ri Jesús. Ri achi'a' re' man niquinimaj ta chi ri caminaki' can xquiec'astaj chic pe. Y romari' reje' xqui'ij che ri Jesús: ");
INSERT INTO cakNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Ret ri jat jun Maestro, roj chuka' c'o nakajo' nakac'utuj chawe. Ri Moisés can rutz'iban-wi can chake chi cuando jun achi nuya' can ri raxayil roma nicom-e, y xa man jun ralc'ual nic'ue' can, jun rach'alal ri caminak achi ri' tic'ule' riq'uin ri malca'n-ixok, chi quiri' yec'ue' ralc'ual riq'uin ri malca'n-ixok. Y xa can jec'o ralc'ual yec'ue' riq'uin ri ixok, ri na'ey ala' ntoc ralc'ual ri achi ri caminak chic e. ");
INSERT INTO cakNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Y reje' xqui'ij: Xec'ue' je wuku' achi'a' cach'alal qui'. Ri na'ey xc'ule'. Pero xcom-e, y man jun ralc'ual xc'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Xpe ri ruca'n achi, ri rach'alal ri caminak, xc'ule' riq'uin ri malca'n-ixok. Pero raja' chuka' xcom-e, y man jun ralc'ual xc'ue'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ri rox achi xc'ule' chuka' riq'uin ri ixok ri', pero xa anche'l xquic'ulumaj ri ca'i' na'ey chech raja', quiri' chuka' xuc'ulumaj-e raja'. Y ri wuku' achi'a' cach'alal qui' quiere' xqui'en-e. Y man jun chique ri wuku' achi'a' re' xec'ue' ta can ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Y pa ruq'uisbel xcom-e chuka' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Y ri achi'a' saduceos xqui'ij che ri Jesús: Ret na'ij chi xtapon jun k'ij cuando ri caminaki' xquiec'astaj-pe. Cuando xtapon ri k'ij ri', ¿anchok raxayil xtoc ri ixok re'? Roma ri je wuku' achi'a' cach'alal qui' xec'ue' riq'uin, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús can ja' xu'ij chique: We' chech-ulef, ri achi'a' y ri ixoki' yec'ule'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero riq'uin ri camic niq'uis ronojel ri'. Romari' ri caminaki' ri xquiec'astaj-pe y can nuc'ul yebe chicaj, man xquiec'ule' ta chic chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Roma reje' xquiec'astaj-pe chiquicojol ri caminaki' y xtek'alajin chi can je ralc'ual-wi ri Dios, y man xquiecom ta chic roma xquie'oc anche'l ri ángeles. ");
INSERT INTO cakNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Y ri caminaki' can yec'astaj-wi. Roma ri Moisés rutz'iban can chupa rutzij ri Dios, cuando raja' xutzu' ri jun k'ayis c'o ruq'uixal ri rubinan zarza ri nic'at, y xuc'oxaj cuando ri Dios xu'ij: Ja ren ru-Dios ri Abraham, ru-Dios ri Isaac, y ru-Dios ri Jacob, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Y xa ta reje' je caminak ta chi ronojel tiempo, y xa reje' man yec'astaj ta chic pe jun mej (bey), ri Dios man ta qui-Dios reje', roma ri Dios can qui-Dios-wi ri c'o quic'aslen y man quichi ta ri caminaki'. Roma chech ri Dios reje' can je q'ues-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Y jec'o chique ri maestros chi ri ley xqui'ij-apo che ri Jesús: Maestro, can ketzij-wi ri xa'ij, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y man xqui'en ta chic cowil chi c'o ta anchique xquic'utuj ta apo che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Y ri Jesús xu'ij chique: ¿Anchique roma ni'ix chi ri Cristo xa choj jun ru-familia can ri rey David? ");
INSERT INTO cakNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Cuando xa can ja ri rey David biyon can chupa ri libro ri ni'ix Salmos che: Ri Ajaf Dios xu'ij che ri Wajaf ri Cristo: Cach'oquie-pe pa nu-derecha, ");
INSERT INTO cakNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","y xquienya' chuxe' awakan ri itzel yetz'eto awichi. Quiri' nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Y can k'alaj-wi chi ri rey David cuando xc'ase' we' chech-ulef, xu'ij Wajaf che ri Cristo. ¿Y anchique roma ni'ix chi ri Cristo xa choj jun ru-familia can ri rey David? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Y conojel ri winak ri quimolon-qui' chiri' niquic'oxaj-apo ri Jesús; y raja' xu'ij chique ri ru-discípulos: ");
INSERT INTO cakNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Tibana' cuenta iwi', man tiben anche'l niqui'en ri maestros chi ri ley. Roma reje' yalan nika chiquiwech niquicusaj tukutic tak tziak, chi quiri' quietz'et chi can c'o-wi quik'ij. Yalan nika chuka' chiquiwech ye'an can saludar anchi' niquimol-qui' q'uiy winak. Y pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios, can ja ri na'ey tak ch'aquet yequicanola', chi ni'ix chiquij chi can c'o quik'ij. Y quiri' chuka' yequi'en pa nima'k tak wa'in. ");
INSERT INTO cakNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Y ri achi'a' re' chuka' niquimaj ronojel ex quichi ri malca'n tak ixoki'. Y xe chi quienimex chi reje' je utzilaj tak winak, yelayoj cuando niqui'en orar. Pero reje' can xtika-wi más ru-castigo ri Dios pa quiwi', roma yalan q'uiy quimac, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Chiri' pa rocho ri Dios, ri Jesús xutzu' chi ri winak beyoma' niquiyala' can mero chiri' anchi' niyo'x-wi can ri mero pa rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y quiri' chuka' xutzu' jun malca'n-ixok ri can k'alaj chi can man beyom ta, xuya' can ca'i' tak fichas ri man q'uiy ta oc cajil. ");
INSERT INTO cakNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Y cuando ri Jesús xutzu' ri malca'n-ixok re', xu'ij chique ri ru-discípulos: Can ketzij nin-ij chiwe chi ja ri xuya' can la pobre malca'n-ixok la' ri c'o más rakalen chech ri xquiya' can ri ch'aka chic winak. ");
INSERT INTO cakNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Roma raja' más que man q'uiy ta ru-mero c'o, can xuya' can ronojel ri c'o riq'uin, y xuya' can chupa ri anchi' c'o-wi ri mero ri sipan can che ri Dios. Pero ri beyoma', más que can q'uiy mero niquiya' can, xa ja ri nu'on sobrar quiq'uin, xa jari' niquiya', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Y jec'o ri quitz'amon tzij chirij ri rocho ri Dios. Y niqui'ij chi yalan jabel ru'onic y xe jabel tak abaj ri je-cusan, y chi ronojel ri anchok che wakon-wi, ronojel ri' ja ri winak je-sipayon, yecha'. Y ri Jesús xu'ij chique: ");
INSERT INTO cakNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Xquie'apon k'ij cuando ronojel ri nitzu' we' xquiewulix. Conojel ri nimalaj tak abaj ri je-cusan che ri jay re' can xquietorix-pe. Man jun abaj ri xtic'ue' can, anche'l la rubanon cami, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Y ri discípulos xquic'utuj che ri Jesús: Maestro, xecha', ¿jampe' xtibanataj ri xa'ij chake chirij ri rocho ri Dios? ¿Y anchique retal chi quiri' nina'ex chi nibanataj yan ri'? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Y ri Jesús xu'ij chique: Tibana' cuenta iwi' chi quiri' man jix-an ta engañar. Roma je q'uiy xquiepe y xtiqui'ij: Ja ren ri Cristo ri takon-pe roma ri Dios. Ja tiempo re' xoka, xquiecha'. Pero rix man quie'inimaj, ni man quie'itzeklebej chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y cuando xtic'oxaj chuka' chi jec'o naciones ri niqui'en guerra o winak pa tak tenemit yequi'en ayowal chiquiwech, man tixi'j-iwi', roma ronojel ri' can xquiebanataj na-wi na'ey, pero man ja' yan ta ri' ri ruq'uisbel tak k'ij chi ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Y ri Jesús xu'ij chuka': Jec'o naciones xquiecataj chi niqui'en guerra quiq'uin ch'aka chic naciones. Jec'o chuka' nimalaj tak rech-ulef xquiecataj chi niqui'en guerra quiq'uin ch'aka chic nimalaj tak rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xquiepe nimalaj tak silonel (cab-rakan), chuka' xquiepe nimalaj tak wayjal y chuka' xquiepe yabil xabachique (xama'anchique) lugar che ri rech-ulef. Xtuya' jun nimalaj xibinri'l ri xquiebanataj y xquietz'etetaj chupa ri rocaj, xquiebanataj ex ri man jun mej (bey) je-tz'eton. ");
INSERT INTO cakNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Y cuando man jani quiebanataj ronojel re', rix xquixtz'om y xti'an chiwe chi niben sufrir, roma rutzij ri Dios. Xquixuc'uax chiquiwech ri achi'a' je principales pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios. Xquixtz'apis pa cárcel. Xquixuc'uax chiquiwech reyes y chiquiwech gobernadores. Ronojel re' xtic'ulumaj roma rix ic'uan nubi' ren. ");
INSERT INTO cakNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Y cuando quiere' xti'an chiwe coma ri winak, rix can xquixtiquier xquinik'alajij chiquiwech reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Y can toka pa iwi', man tinojij ri anchique ri ne'ibij chi nito-iwi', ");
INSERT INTO cakNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","roma can ja ren xquiyo'n chiwe ri tzij ri ne'ibij. Y xtinya' chuka' ino'j (ina'oj) chi quiri', riq'uin ri no'j (na'oj) ri' xtitz'apij xequey ri itzel yetz'eto iwichi. ");
INSERT INTO cakNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Y xquixjach pa quik'a' ri itzel yetz'eto iwichi. Y xa juba' (paka) ri ite-itata', ri iwach'alal o ri je iwaxbil ri xquiejacho iwichi. Y jec'o chiwe rix ri can xquiecamises. ");
INSERT INTO cakNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Can itzel xquixtz'et coma conojel winak, roma iyo'n iwánima wiq'uin ren. ");
INSERT INTO cakNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero man tixi'j-iwi', roma ri Dios can jixruchajij, y chech raja' man jun rusmal-iwi' ri xe quiri' xtitzak. ");
INSERT INTO cakNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Y xa nicoch' ronojel, xtiwil c'a ri utzilaj c'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Y cuando xtitzu' chi ri tenemit Jerusalem sururen rij coma soldados, titemaj c'a chi xa juba' chic tiempo nrojo' chi ri tenemit xtiwulix. ");
INSERT INTO cakNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Romari', iwonojel rix ri jixc'o pa Judea, quixlumaj (quixnimaj) y tiwewaj-iwi' chech tak juyu'. Xa jixc'o pa tenemit Jerusalem, quixel-pe chupa. Y xa man pa tenemit ta jixc'o-wi, man chic quixoc-apo pa tenemit chi nito-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Roma cuando xtapon ri k'ij chi ri sufrimiento, ja cuando ri tenemit ri' xtiyo'x ruq'uiexel che roma ronojel ri jerubanon, y can xtibanataj ronojel ri tz'iban can chupa rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Y chupa ri k'ij ri' can xtik'ax rui' ri sufrimiento xtipe parui' ri rech-ulef. Can xtika ri castigo ri xtuya' ri Dios parui' ri tenemit re'. Y roma ri sufrimiento ri', can juya' (juyu') quiwech ri ixoki' ri ya nic'ue' cal cuando xtapon ri k'ij ri', quiri' chuka' ri ixoki' ri c'a jec'o cal ri c'a yetz'uman (yeme'). Roma manak xquietiquier xquielumaj (xquienimaj) ch'anin. ");
INSERT INTO cakNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Can q'uiy winak xquiecom pa quik'a' ri soldados. Y ri ch'aka chic winak xquiec'uax pa ch'aka chic naciones coma ri soldados. Y ri tenemit Jerusalem xtixak' can coma winak ri xa man je israelitas ta. Pero man chi ta jumul quiri' xtiqui'en, roma ri k'ij ri yo'n chique xa xtik'ax. ");
INSERT INTO cakNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Y q'uiy ex ri man jun mej (bey) je-banatajnak y man jun mej (bey) je-tz'eton xquiebanataj riq'uin ri k'ij, ri ic' y ri ch'umil. Y ri winak ri jec'o chech-ulef man xtiquiwil ta anchique xtiqui'en, xa xtisatz quino'j (xtisach quic'u'x) roma ri nimalaj mar can xtik'ax rui' xtik'ajan, roma yalan ruchuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Y ri winak, roma can quieta'n chic anchique xtibanataj chech-ulef, xtipe quicamic roma ri quixibinri'l. Roma hasta ronojel ri nimalaj tak uchuk'a' ri jec'o chicaj xquiesilon roma ri ruchuk'a' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Y ja' cuando ri winak xquinquitzu' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, chi yika-pe pa jun ajawa' (mukul), riq'uin chic nimalaj wuchuk'a' y chuka' nimalaj nuk'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Y rix, xcha' ri Jesús chique ri ru-discípulos, cuando xtitzu' chi ronojel re' yebanataj yan, quixquicot y tic'ue' más ruchuk'a' iwánima, roma can napon yan ri k'ij chi jixcolotaj chech ronojel ri sufrimiento chi ri rech-ulef, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chuka' xuya' jun ejemplo chique. Raja' xu'ij: Quie'itzu' na pe' ri che', titzu' anchique nu'on jun mata higo o xabachique (xama'anchique) che'. ");
INSERT INTO cakNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Cuando ya ye'el-pe quixak, iweta'n chi ri ru-tiempo job ya ntoc-pe. ");
INSERT INTO cakNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Y quiri' chuka' cuando xtitzu' chi yebanataj yan ronojel ri xin-ij yan ka chiwe, iweta'n c'a chi noka yan ri k'ij chi ja ri Dios xtibano gobernar. ");
INSERT INTO cakNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Y tic'oxaj utz ri xtin-ij chiwe cami: Ronojel re' xtibanataj, cuando ri winak chi ri tiempo re' c'a man jani quieq'uis chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ri rech-ulef y ri rocaj can yeq'uis na-wi. Pero ri nutzij man xtiq'uis ta quiri', xa can xtibanataj-wi ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tibana' cuenta iwi'. Man tibe iwánima chirij ri wa'in, man quixk'aber, y chuka' man xe ta ri nic'atzin chiwe chech-ulef ri ninojij, y c'aja' xtina' xa ja' xoka ri k'ij chi ren yinoka-ka. ");
INSERT INTO cakNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Y xtibanataj anche'l nu'on jun trampa cuando nika jun chicop chupa. Quiri' xtibanataj cuando xtoka ri k'ij ri' pa quiwi' conojel ri winak ri jec'o chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Romari' can tibana' cuenta iwi' y siempre chuka' tibana' orar, chi jixcolotaj chech ronojel ri sufrimiento ri xtipe parui' ri rech-ulef, y chuka' chi quiri' can utz ta ic'aslen jixapon c'a chinuech ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Pak'ij, ri Jesús nic'ue' pa rocho ri Dios, yerutijoj ri winak riq'uin rutzij ri Dios. Y chak'a' nibe chech ri juyu' rubinan Olivos, y chiri' nic'ue-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y roma ri Jesús nutzijoj rutzij ri Dios chiri' pa rocho ri Dios, can je q'uiy winak ri ye'apon nimak'a' yan chi niquic'oxaj ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ca'i-oxi' oc k'ij nrojo' chi napon ri quinimak'ej ri israelitas, jun nimak'ej rubinan pascua, cuando niquitaj ri pan ri manak levadura riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ja' cuando ri nimalaj tak sacerdotes y ri maestros chi ri ley niquinojila' anchique ta niqui'en chi niquicamisaj ri Jesús. Pero xa niquixi'j-qui' chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Y ri Judas jun chique ri cablajuj ru-discípulos ri Jesús, ri discípulo ri x-ix chuka' Iscariote che, can nisamaj yan ri Satanás pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Romari' xapon quiq'uin ri nimalaj tak sacerdotes y quiq'uin chuka' ri jefes quichi ri yechajin pa rocho ri Dios, y xbetzijon quiq'uin chirij anchique xtu'on chi nujach ri Jesús pa quik'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Y reje' yalan xequicot cuando xquic'oxaj ri', y xquisuj mero che. ");
INSERT INTO cakNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Y chuka' ri Judas can utz xu'on chech ri xqui'ij reje'. Y ja' xutz'om rucanoxic anchique modo xtu'on chi nujach ri Jesús pa quik'a' cuando manak quimolon-qui' winak riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xoka ri na'ey k'ij chi ri nimak'ej cuando nitej ri pan ri manak levadura riq'uin. Chupa ri k'ij ri' ja yecamises chuka' ri alaj tak ral ovejas chi ri pascua ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ri Jesús ja xerutak ri Pedro y ri Juan, y xu'ij-e chique: Inaba' yan ri xte'katija' chupa ri pascua re'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y ri ca'i' discípulos xquic'utuj che: ¿Anchi' najo-wi chi naka'an ronojel ri'? ");
INSERT INTO cakNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xu'ij chique: Cuando xquixapon pa tenemit Jerusalem, xtic'ul jun achi samajel ri ruc'uan ruya' pa jun cucu' (tinaja). Titzeklebej ri achi re' c'a anchique na jay xtoc-wi. ");
INSERT INTO cakNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Y ti'ij che ri rajaf ri jay ri': Ri Maestro ru'in-pe chake: ¿Anchique jay we' chi'awocho utz chi nin-en ri wa'in chi ri pascua junan quiq'uin ri nu-discípulos? quixcha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Y ri rajaf-jay xquixruc'uaj pa ruca'n piso che ri jay. Y chiri' c'o jun jay nim rupa y banon chic ru'onic; chiri' tinaba-wi ronojel ri xte'katija' chi ri pascua, xe'uche'x-e. ");
INSERT INTO cakNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Y ri ca'i' discípulos xebe. Y can anche'l ru'in-e ri Jesús chique, can quiri' xbanataj. Y reje' can xquinaba-wi ronojel ri nic'atzin chique chi ri pascua ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Y cuando xapon ri hora, ri Jesús y ri cablajuj apóstoles xech'oquie-apo chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y Jesús xu'ij chique: Yalan nurayin-pe chi antes chi yicom, junan naka'an can ri jun wa'in chi ri jun pascua re'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Roma nin-ij chiwe chi can manak chic xtin-en ri wa'in re' iwiq'uin; c'aja' cuando xbanataj yan ri anchique ntel chi tzij ri pascua re', y ri Dios nu'on yan gobernar, c'ajari' xtin-en chic jun mej (bey) ri wa'in re'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Y ri Jesús xuc'on-apo jun vaso ri c'o ruya'al-uva chupa, xuya' matiox che ri Dios y xu'ij: Chi'iwonojel tikumu' re'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Roma nin-ij chiwe, chi c'aja' cuando xtic'ue' ru-gobierno ri Dios, c'ajari' xtinkum chic jun mej (bey) ruya'al-uva. ");
INSERT INTO cakNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Y quiri' chuka' xuc'on-apo jun pan, xuya' matiox che ri Dios, c'ajari' xuper ri pan y xuya' chique ri ru-discípulos y xu'ij chique: Titija' ri pan re', jare' ri nuch'acul; roma ren can xquijach y xquicamises pa iq'uiexel rix. Can titija' ri pan re' y siempre quininataj. ");
INSERT INTO cakNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Y cuando je-waynak chic, ri Jesús xuc'on-apo chuka' ri vaso ri c'o ruya'al-uva chupa, y xu'ij: Ri ruya'al-uva re', jare' ri nuquiq'uiel ri xtibin cuando xquicamises. Riq'uin ri nuquiq'uiel ri xtibin, can ja' xtic'achoj ri c'ac'ac' trato ri rurayin-pe ri Dios chi nu'on quiq'uin ri winak. Ri nuquiq'uiel ri', xtibin chi quiri' rix jixcolotaj. ");
INSERT INTO cakNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Y cami, ri achi ri xtijacho wichi pa quik'a' ri winak ri man jinquijo' ta, can c'o-pe wiq'uin chuchi' mesa. ");
INSERT INTO cakNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Can tic'oxaj ri nin-ij chiwe, chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can xquicamises, roma can jare' ri runojin-pe ri Dios pa nuwi'. Pero juya' (juyu') rech ri xtijacho wichi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Y ri ru-discípulos ri Jesús can ja xquibila-ka chiquiwech chi ancu'x (anchique) como ri xtijacho richi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Y ri discípulos xqui'ij-ka chiquiwech ancu'x (anchique) chique reje' ri c'o más ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero ri Jesús xu'ij chique: Ri reyes chi ri rech-ulef, roma can jec'o ri winak pa quik'a', romari' can niquina' chi ja reje' ri je cajaf ri winak. Y ri achi'a' can jec'o pa quiwi' ri winak, can je utzilaj tak achi'a' ni'ix chique. ");
INSERT INTO cakNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero chi'icojol rix nu-discípulos, man quiri' ta. Roma ri c'o más ruk'ij chi'icojol, can tuna-ka chi can manak oc ruk'ij chiquiwech ri juley chic. Y ri jun chiwe ri nic'ue' más ruk'ij pa iwi' rix, can tuna-ka chi can manak oc ruk'ij y co'l tu'ona-ka, chi quiri' nusuj-ri' chi neru'ona' xabachique (xama'anchique) samaj. ");
INSERT INTO cakNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Romari', ¿ja como ri nilix-apo chuchi' mesa ri c'o más ruk'ij, o ja ri nilin-apo? ¿Man ja' ta como ri nilix-apo chuchi' mesa ri más c'o ruk'ij? Pero chinuech ren man quiri' ta, roma ren jin anche'l jun ri nilin-apo chuchi' mesa ri jinc'o chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Rix can jixc'o-pe wiq'uin chupa ronojel ri sufrimientos ri yetojtoben wichi. ");
INSERT INTO cakNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Romari', ren xtinya' uchuk'a' pa ik'a' rix chi niben gobernar, can anche'l ri rubanon ri Nata' Dios wiq'uin ren, ");
INSERT INTO cakNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","chi quiri' xquixwa' y xquixuq'uia' pa jun misma mesa wiq'uin ren, cuando ren nin-en yan gobernar. Y rix xquixoc gobernadores pa quiwi' ri cablajuj quiwech familias ri je calc'ual can ri cablajuj ralc'ual can ri achi xubinaj Israel. ");
INSERT INTO cakNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Y ri Ajaf Jesús xu'ij chuka' che jun chique ri ru-discípulos: Simón, Simón, nin-ij chawe chi ri Satanás xixruc'utuj yan che ri Dios chi jixrutojtobej. Can nrojo' jixrusiloj anche'l ni'an che ri trigo. ");
INSERT INTO cakNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero ren can xin-en yan orar awoma, chi quiri' ret can naya' awánima wiq'uin. Can xcatojtobex-wi roma ri Satanás. Pero cuando xtitzolaj-pe awánima wiq'uin, xquie'ato' ri ch'aka chic nu-discípulos chi quiri' can tiquiya' ruchuk'a' cánima wiq'uin, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xu'ij: Ajaf, xa ret xcatuc'uax pa cárcel, ren chuka' yibe awiq'uin. Y xa xcacamises, ren chuka' yicom awiq'uin, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Pero ri Jesús xu'ij che: Pedro, ren nin-ij chawe, chi chupa ri ak'a' re', man jani titzirin-pe (tisiq'uin-pe) ri gallo cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech, xcha' ri Jesús che ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y Jesús xuc'utuj chique ri ru-discípulos: Cuando ri jun mej (bey) xixintak y man xinya' ta lugar chiwe chi xic'uaj ta ichim, ni i-mero, ni jun chic par ixajab, ¿c'o como ri xu'on falta chiwe? xcha'. Y reje' xqui'ij chi can man jun. ");
INSERT INTO cakNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Y ri Jesús xu'ij chique: Pero cami man quiri' ta chic. Roma cami ri c'o ruchim, tuc'uaj. Ri c'o ru-mero, tuc'uaj chuka'. Y xa c'o jun ri manak ru-espada, tuc'ayij jun rutziak y tulok'o' jun. ");
INSERT INTO cakNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Y cami quiere' nin-ij chiwe, roma can xtibanataj na-wi anche'l ri nu'ij chupa rutzij ri Dios ri tz'iban can. Chiri' nu'ij: Anche'l jun aj-mac x-an che. Quiri' ri tz'iban can. Y re' can xtibanataj na-wi wiq'uin ren. Ronojel ri je-tz'iban can chuij ren chupa rutzij ri Dios, can xquiebanataj na-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Y ri discípulos, roma man xqui'en ta entender ri xu'ij ri Jesús, xqui'ij che: Ajaf, we' c'o ca'i' espadas. Pero ri Jesús xu'ij chique: Man chic tinataj ri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Cuando Jesús elenak chic e chiri', xbe ri anchi' can tibe-wi. Raja' xbe chech ri juyu' rubinan Olivos. Y ri ru-discípulos can je-benak chirij. ");
INSERT INTO cakNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Y cuando xe'apon, xu'ij chique: Tibana' orar y tic'utuj che ri Dios chi quiri' cuando jixtojtobex, man quixtzak pa mac. ");
INSERT INTO cakNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Y ri Jesús xbin chic apo juba' y xxuquie-ka chi nu'on orar. ");
INSERT INTO cakNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Y nu'ij pa ru-oración: Nata' Dios, xa ret najo', quinacolo' chech ri sufrimiento ri c'o chupa ri copa ri ayo'n chue. Pero man ta'an ri ninrayij ren. Roma ren can ninjo' chuka' nin-en ri narayij ret, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Y c'o jun ángel ri petenak chicaj xuc'ut-ri' chech, chi noruya-ka ruchuk'a' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y can yalan ruquiy (nik'axon) ránima raja'. Romari' can riq'uin ronojel ránima nu'on orar. Y roma chuka' ri ruquiy (k'axon), ri wo'l ri ntel chirij man choj ta ya'. Xa anche'l nima'k tak tz'uj quic' ri yeka pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cuando ri Jesús xbecataj-pe anchi' xucul-wi nu'on orar, xoka quiq'uin ri je oxi' ru-discípulos, pero reje' xa yewer, roma yalan yebison y chuka' je-cosinak. ");
INSERT INTO cakNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Y ri Jesús xu'ij chique ri ru-discípulos ri': ¿Anchique roma jixwer? Quixcataj, tibana' orar y tic'utuj che ri Dios chi cuando jixtojtobex, man quixtzak pa mac, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Y can c'a nich'o'n ri Jesús quiq'uin ri ru-discípulos, c'aja' xquina' xe'apon q'uiy winak quiq'uin. Y ja ri jun chique ri cablajuj ru-discípulos ri rubinan Judas ri uc'uayon-apo quichi ri winak ri'. Y ri Judas ja' xbe-apo riq'uin ri Jesús y xutz'ubaj. ");
INSERT INTO cakNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Pero ri Jesús xu'ij che ri Judas: ¿Xinatz'ubaj ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xe chi yinajach pa quik'a' ri itzel yetz'eto wichi? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Y cuando ri discípulos xquitzu' ri najin, xquina'ej ri anchique ri xtibanataj. Romari' xqui'ij che: Ajaf, ¿naka'an ayowal quiq'uin che espada? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y c'o jun chique ri discípulos ri xusoc jun rusamajel ri sacerdote ri más c'o ruk'ij. Y can ja' ruxiquin ri xulesaj-e. Y ri ruxiquin ri xulesaj-e ja ri c'o pa ru-derecha. ");
INSERT INTO cakNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Y ri Jesús xu'ij chique ri ru-discípulos: Man jun chic anchique tiben. Y xpe raja' xutz'om ri ruxiquin y can ja' xc'achoj. ");
INSERT INTO cakNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Y can ja' ri nimalaj tak sacerdotes, y ri jefes quichi ri achi'a' chajinel pa rocho ri Dios, y ri rijilaj tak achi'a' ri c'o quik'ij, jari' ri je-benak chi niquic'uaj ri Jesús. Y raja' xu'ij chique: ¿Anchique xinojij rix? ¿Xinojij chi jun elek'om nitz'om-e, romari' ic'amon-pe che' y espadas? ");
INSERT INTO cakNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ren can k'ij-k'ij xic'ue' iwiq'uin chiri' pa rocho ri Dios, y man jun anchique xiben chue. Pero ja hora re' ri yo'n chiwe rix, cuando can ja ri k'eku'm ri nich'acon, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquitz'om-e ri Jesús, y xquic'uaj pa rocho ri sacerdote ri más c'o ruk'ij. Y ri Pedro chinaj rutzekleben-e. ");
INSERT INTO cakNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Y chiri' pa nic'aj rojay, ri rusamajel ri sacerdote ri más c'o ruk'ij xquibox k'ak', y xech'oquie-apo conojel chi-k'ak'. Y chuka' ri Pedro xch'oquie-apo chiquicojol. ");
INSERT INTO cakNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Y cuando jun ixok raj-ic' ri sacerdote ri más c'o ruk'ij, xutzu' ri Pedro ch'ocol chiri' rumak'on-ri', xutzu-xutzu' y xu'ij: Ri jun achi re' raxbil chuka' ri Jesús, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pero ri Pedro xa xrewaj chech ri ixok, y xu'ij: Ren man weta'n ta rech la achi la', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Y c'aja' oc juba' tiempo tik'ax, cuando c'o chic jun ri xutzu' chic pe ri Pedro, y xu'ij che: Ret jat jun chique ri jec'o riq'uin ri Jesús, xcha' che. Y ri Pedro xu'ij: Ri' man jin ta ren, xcha-apo ri Pedro che. ");
INSERT INTO cakNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Xk'ax la'k jun hora chi tibanataj ri', cuando c'o chic jun ri x-in chirij ri Pedro: Ri achi re', can ketzij-wi chi xc'ue' riq'uin ri Jesús, roma can aj-Galilea chuka', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pero ri Pedro xu'ij che ri achi: Man nin-en ta entender anchique roma na'ij quiri' chuij, xcha' ri Pedro. Y can c'a nich'o'n ri Pedro, cuando ri gallo xtzirin-pe (xsiq'uin-pe). ");
INSERT INTO cakNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Y ri Ajaf Jesús xtzu'n chirij y xutzu-pe ri Pedro. Y ri Pedro xoka pa ruwi' ri ru'in can ri Ajaf che, chi c'a man jani titzirin-pe (tisiq'uin-pe) ri gallo cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe, chi can man aweta'n ta nuech. ");
INSERT INTO cakNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Y ri Pedro xel-e chiri' y xujik' ok'ej. ");
INSERT INTO cakNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Y ri achi'a' ri quichajin-apo ri Jesús, yetze'n chirij y niquich'ey chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Y xquitz'apij rech y xquipak'ala' rupalaj y niqui'ij che: Ta'ij chake: ¿Ancu'x (Anchique) ri xch'eyo awichi? yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Y q'uiy itzel tak tzij ri niqui'ij-apo che roma can itzel niquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Cuando xsakar-ka, xquimol-qui' ri rijilaj tak achi'a' ri c'o quik'ij, ri nimalaj tak sacerdotes, y ri maestros chi ri ley; roma ja reje' ri autoridad quichi ri israelitas. Ri Jesús xc'uax chiquiwech reje', y xquic'utuj che: ");
INSERT INTO cakNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Ta'ij chake: ¿Ja ret ri Cristo ri takon-pe roma ri Dios? xecha'. Pero ri Jesús xu'ij chique: Xa ta nin-ij chiwe chi can ja ren, man ninimaj ta ri nin-ij. ");
INSERT INTO cakNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Chuka' xa ta c'o ri ninc'utuj-apo chiwe, rix manak xtijo' xti'ij chue ri ninc'utuj, y man xquinisk'opij ta e chuka'. ");
INSERT INTO cakNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero cuando xtik'ax can ri jun sufrimiento re', ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xquibech'oquie' pa ru-derecha ri Dios ri nitiquier nu'on ronojel, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Y conojel can ja' xquic'utuj-apo che ri Jesús: ¿Entonces ret can jat Ralc'ual-wi ri Dios? xecha'. Ja', can ja ren, anche'l ri c'aja' oc ni'ij-ka rix, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Y reje' xqui'ij: Man jun chic tzij nic'atzin chake chi nakatemaj chi ri Jesús can c'o-wi rumac. Roma konojel xkac'oxaj ri c'aja' oc xu'ij, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Y c'ajari', conojel ri jec'o chiri' xecataj, y xquic'uaj ri Jesús chi niquijach pa ruk'a' ri Pilato, ri gobernador. ");
INSERT INTO cakNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y chiri' chech raja', niquisujuj-apo y niqui'ij: Roj keta'n chi ri Jesús can q'uiy rumac. Raja' nuya' quino'j (quina'oj) ri winak. Raja' nu'ij chuka' chique ri winak chi can man tiquitoj ri impuestos che ri rey César. Y chuka' nu'ij chi ja raja' ri Cristo ri takon-pe roma ri Dios, y re' nrojo' nu'ij chi ja raja' ri Rey, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Y ri Pilato xuc'utuj che ri Jesús: ¿Ja ret ri qui-Rey ri israelitas? xcha' che. Y ri Jesús xu'ij che: Ja', can quiri-wi, anche'l ri xa'ij, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Y ri Pilato xu'ij chique ri nimalaj tak sacerdotes y chique ri winak chuka': Ren man jun ch'a'oj ninwil chirij ri jun achi re', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero reje' man yetane' ta ka. Xa niquitaj quik'ij chi niqui'ij-apo: Xa nuya' quino'j (quina'oj) ri winak pa ronojel tenemit chi ri Judea. Chila' pa Galilea rutz'amon-pe ru'onic. Y quiri' nu'on petenak, y c'aja' xkana' c'o chic we' pa tenemit Jerusalem, xecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Y cuando Pilato xuc'oxaj ri niqui'ij, xuc'utuj xa aj-Galilea ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y cuando x-ix che chi can aj-Galilea-wi, raja' xutak-e ri Jesús che ri Herodes, ri gobernador pa Galilea. Y can jabel xu'on chique roma ri Herodes c'o chiri' pa tenemit Jerusalem ri k'ij ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Y cuando ri Herodes xutzu' ri Jesús, yalan xquicot ránima, roma can q'uiy yan k'ij rurayin nutzu'. Y q'uiy ri ruc'oxan chirij. Romari' yalan nurayij nutzu' jun mej (bey) cuando nu'on jun milagro. ");
INSERT INTO cakNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y ri Herodes q'uiy ex xuc'utuj che ri Jesús, pero ri Jesús man jun tzij xu'ij che. ");
INSERT INTO cakNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Y can jec'o-apo chuka' ri nimalaj tak sacerdotes y ri maestros chi ri ley, chi niquisujuj ri Jesús. Reje' can niquitaj quik'ij chi yesujun-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Y ri Herodes y ri ru-soldados, can man jun rakalen xqui'en che ri Jesús y chuka' xetze'n chirij. Xquiya' jun tziak chirij, can anche'l ri yequicusaj ri reyes. Roma chiquiwech reje' xa man jun rakalen ri Jesús. Y c'ajari' ri Herodes xutzolej chic ri Jesús che ri Pilato. ");
INSERT INTO cakNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ri Herodes y ri Pilato c'o ayowal chiquiwech. Pero ri k'ij ri' xa xk'ax ri ayowal chiquiwech y xquijo-ka-qui'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Y c'ajari' ri Pilato xeroyoj ri nimalaj tak sacerdotes y ri je autoridad quichi ri israelitas. Y chuka' xeroyoj ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Y xu'ij chique: Rix xo'iya' ri Jesús pa nuk'a', y ni'ij chi nuya' quino'j (quina'oj) ri winak. Pero can chiwech rix xinc'utuj che, y ren nintzu' chi can manak jerubanon ronojel ri ni'ij rix chirij. ");
INSERT INTO cakNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y chuka' ri Herodes man jun anchique xril chirij ruc'aslen, cuando xixintak-e riq'uin, y romari' xutzolej chic pe chue. Xe riq'uin ri' nakatemaj chi raja' man jun anchique rubanon chi nicamises ta. ");
INSERT INTO cakNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Cami xtintak ruch'ayic, y c'ajari' ninsk'opij-e, xcha' ri Pilato. ");
INSERT INTO cakNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ri Pilato can nusk'opij-wi jun chique ri jec'o pa cárcel, roma can quiri-wi ni'an juna-juna' cuando napon ri pascua, ri jun quinimak'ej ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Romari' conojel xech'o'n-apo riq'uin ronojel quichuk'a', y xqui'ij: ¡Ja ri Barrabás task'opij-e y ri Jesús ticamises! xecha-apo. ");
INSERT INTO cakNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Y ri Barrabás c'o pa cárcel roma xcataj chirij ri gobierno chiri' pa tenemit y chuka' rubanon camic. ");
INSERT INTO cakNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Roma ri Pilato can nrojo-wi nusk'opij-e ri Jesús, romari' xch'o'n chic jun mej (bey) chique ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero ri winak xech'o'n-apo riq'uin ronojel quichuk'a', y xqui'ij: ¡Ticamises chech cruz! ¡Ticamises chech cruz! ");
INSERT INTO cakNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Y pa rox mej (paj) ri Pilato xuc'utuj chique: ¿Anchique mac rubanon chiwech ri jun achi re'? Ren man jun ch'a'oj ninwil chirij chi quiri' nicamises. Xtintak ruch'ayic, y después ninsk'opij-e, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ri winak y ri nimalaj tak sacerdotes, can riq'uin ronojel quichuk'a' niquic'utuj-apo chi ticamises ri Jesús chech jun cruz, y ja ri niqui'ij reje' ri xch'acon. ");
INSERT INTO cakNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Y ja cuando Pilato xu'ij chi ti'an anche'l niquic'utuj-apo reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Y xusk'opij-e ri achi ri xquic'utuj-apo reje' che. Ri achi ri' c'o pa cárcel roma xcataj chirij ri gobierno y chuka' xu'on camic. Pero ri Jesús xujach-e chi ticamises chech cruz, roma can jari' xquijo' ri winak. ");
INSERT INTO cakNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Y cuando ri soldados quic'uan-e ri Jesús chi ne'quibajij chech cruz, xquic'ul jun achi aj-Cirene ri rubinan Simón; raja' petenak pa k'ayis, y ri soldados chirij raja' xquiya-wi-e ru-cruz ri Jesús. Y ja raja' xuc'uan-e ri cruz, y benak-e chirij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y can je q'uiy winak ri je-benak chirij. Y je q'uiy ixoki' chuka' can yalan ye'ok' roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Pero ri Jesús xtzu'n can chirij, y xu'ij chique: Rix ixoki' aj-Jerusalem, man quiniwok'ej ren. Xa ja rix tiwok'ej-ka-iwi', y tiwok'ej chuka' quiwech ri ac'uala' ri jec'o iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Roma can xquiepe k'ij chi yalan sufrimiento. Romari' xti'ix chi jabel quibanon ri ixoki' ri can manak-wi yec'ue' cal y chuka' ri man jun mej (bey) xquiyobej ta jun ac'ual, y ri man jun mej (bey) xquiya' ta rutz'um (rume') jun ne'y. ");
INSERT INTO cakNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Y roma ri sufrimiento ri', ri winak can xquiech'o'n chique ri nima'k tak juyu' y xtiqui'ij: Quixtzak-pe chakij. Chuka' chique ri cocoj tak juyu' xtiqui'ij: Kojiwewaj, xquiecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Roma xa ren jin anche'l jun che' ri can rex y ni'an chue chi nink'axaj sufrimiento, ¿anchique como xti'an chique ri xa je anche'l jun che' ri je chaki'j chic? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Y jec'o chuka' ca'i' elek'oma' ri je-uc'uan-e, chi yecamises junan riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Y cuando xe'apon anchi' c'o-wi ri lugar rubinan Calavera, xquibajij ri Jesús chech ri ru-cruz, y quiri' chuka' ri ca'i' elek'oma'. Jun xpobex pa ru-derecha y ri jun chic pa ru-izquierda. ");
INSERT INTO cakNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Y ri Jesús xu'ij: Nata' Dios, tacoch'o' (tacuyu') quimac, roma man quieta'n ta anchique ri niqui'en, xcha'. Y ri soldados xquilesaj suerte chirij ri rutziak ri Jesús chi niquina'ej anchique tziak niquic'uaj-e chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ri Jesús nitz'et-apo coma q'uiy winak y chuka' coma autoridades chiquicojol ri israelitas. Y conojel ri winak re' yetze'n-apo chirij y niqui'ij: Raja' can je q'uiy xerucol. Cami tucolo-ri' raja', xa can ketzij chi ja raja' ri Cristo ri cha'on roma ri Dios, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Y can quiri' chuka' niqui'en ri soldados. Yetze'n-apo chirij ri Jesús, yebe-apo (yejel-apo) riq'uin y niquisuj-e jun ch'amilaj ruya'al-uva che. ");
INSERT INTO cakNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Y niqui'ij che chuka': Xa can ja ret qui-Rey ri israelitas, tacolo-awi' ayon, yecha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Y chutza'n ri cruz c'o jun letrero tz'iban-e pa oxi' ch'abel. Tz'iban pa ch'abel griego, pa latín y pa hebreo. Y ri tzij re' nu'ij: Jare' qui-Rey ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun chique ri je ca'i' elek'oma' ri jec'o chuka' chech qui-cruz, itzel xch'o'n-apo che ri Jesús y xu'ij: Xa can ketzij chi ja ret ri Cristo, tacolo-awi' ret, y kojacolo' roj chuka', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero ri jun chic xuch'olij ri x-in quiri' che ri Jesús y xu'ij-apo che: ¿Can man naxi'j ta awi' chech ri Dios chupa ri castigo anchi' jojc'o-wi riq'uin? ");
INSERT INTO cakNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Roj c'o roma quiere' banon chake, roma riq'uin re' nakatoj ri itzel ri jekabanon. Pero raja' man jun mac rubanon. ");
INSERT INTO cakNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Y ri elek'om ri' xu'ij-apo che ri Jesús: Quinanataj juba', cuando xcape y ja ret na'an yan gobernar, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xu'ij che: Can ketzij nin-ij chawe, chi can ja' yan cami xcabec'ue' wiq'uin anchi' c'o ri lugar chi jojquicot chi jumul, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Y pa nic'aj-k'ij la'k ri' ronojel ri rech-ulef xk'okumer-ka. Y ri k'eku'm ri' xq'uis-e c'a nak'ak'ij a las tres. ");
INSERT INTO cakNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ri k'ij man xuya' ta chic rusakil, y ja' cuando xk'ach'itaj ri tziak ri yo'n-apo chi nujach rupa ri rocho ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Can ja' cuando ri Jesús riq'uin ronojel ruchuk'a' xu'ij: Nata' Dios, pa ak'a' ninjach ri wánima, xcha'. Y can xe xu'ij quiere', ja' xcom-ka. ");
INSERT INTO cakNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Cuando ri capitán quichi ri soldados xutzu' ri xbanataj, xuya' ruk'ij ri Dios, y xu'ij: Can ketzij-wi chi ri jun achi re' man jun rumac, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Y conojel ri winak ri jec'o-apo y xquitzu' ri xbanataj, niquitin quic'u'x xetzolaj roma ruquiy (nik'axon) cánima. ");
INSERT INTO cakNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Y ri quieta'n rech ri Jesús, y ri ixoki' ri can pa Galilea quitzekleben-pe, c'a naj jec'o-wi niquitzu-apo ri xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Y c'o jun achi José rubi', raja' aj-tenemit Arimatea ri c'o pa Judea. Ri jun utzilaj y chojmilaj achi re' caxbil ri achi'a' ri je autoridad chiquicojol ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Y ri José ruyoben cuando ri Dios xtu'on gobernar, y romari' raja' man xka ta chech ri xqui'en ri raxbil che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Y raja' xbe c'a riq'uin ri gobernador Pilato chi nuc'utuj ri ruch'acul ri Jesús, chi numuk. ");
INSERT INTO cakNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Y cuando rukasan chic pe ri ruch'acul ri Jesús chech ri cruz, xupis pa jun tziak. Y c'ajari' xberumuku' can pa jun jul ri c'oton chech jun nimalaj abaj ri can anche'l jun juyu'. Y man jun ucusayon ri jul ri'. ");
INSERT INTO cakNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Pero ri k'ij ri', ri winak niquinaba' yan ronojel ri xtec'atzin chique roma ri k'ij chi uxlanen nitiquier yan ka. Y can ja' cuando nika ri k'ij, ja nitiquier-ka. ");
INSERT INTO cakNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Y ri ixoki' ri c'a pa Galilea je-petenak chirij ri Jesús, xebe cuando xbemuk can; y romari' can quieta'n utz anchi' xmuk-wi can, y chuka' xquitzu' can anchique ru'onic x-an can che ri ruch'acul. ");
INSERT INTO cakNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Y cuando xetzolaj pa tak cocho ri ixoki' ri', xequi'en ru'onic jubulaj tak ak'om roma jari' ne'quiya' can chirij ruch'acul ri Jesús. Y xe'uxlan chupa ri jun k'ij chi uxlanen ri', can anche'l nu'ij chupa ru-ley ri Moisés. ");
INSERT INTO cakNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cumaj nimak'a' yan ri domingo ri na'ey k'ij chi ri semana, ri ixoki' xebe chuchi' ri jul, y jequic'uan-e jubulaj tak ak'om ri jequibanon. Y jec'o chuka' ch'aka chic ixoki' ri je-benak quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Y cuando xe'apon chuchi' ri jul, xquitzu' chi ri abaj anchok che tz'apin-wi ri ruchi' ri jul, xa xleses yan e. ");
INSERT INTO cakNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Reje' xe'oc-apo chupa ri jul, y xquitzu' chi ri ruch'acul ri Ajaf Jesús xa man c'o ta chic chiri'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Romari' xsatz quino'j (xsach quic'u'x). Y can ja' xequitzu' je ca'i' anche'l achi'a' je-pa'l-apo quiq'uin, y nich'ich'an quitziak. ");
INSERT INTO cakNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Y roma quixibinri'l, ri ixoki' xquilucuba-ka-qui'. Y ja' cuando ri anche'l achi'a' xqui'ij chique: ¿Anchique roma rix chiquicojol caminaki' nicanoj-wi ri xa q'ues? ");
INSERT INTO cakNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ri ruch'acul man c'o ta chic we'. Raja' xc'astaj yan e. Toka pa iwi' ri xu'ij chiwe cuando raja' c'a c'o chila' Galilea. ");
INSERT INTO cakNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Raja' xu'ij chiwe: Ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, can nic'atzin chi yijach pa quik'a' winak ri c'o quimac. Xquicamises chech cruz, y pa rox k'ij xquic'astaj-pe, xecha' ri je ca'i' anche'l achi'a'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Y ri ixoki' can xoka pa quiwi' ri tzij ri ru'in can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Y cuando xetzolaj yan pe chuchi' ri jul, xquitzijoj chique ri julajuj apóstoles y ri quimolon-qui' quiq'uin, ronojel ri xquitzu' can. ");
INSERT INTO cakNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ri ixoki' ri xebeyo'n rutzijol chique ri apóstoles ja ri María Magdalena, ri Juana, ri María rute' ri Jacobo, y chuka' ch'aka chic ixoki'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Pero ri apóstoles xquinojij chi ri ixoki' ri' xa anchique la xequitzu', y romari' man xquinimaj ta ri x-ix chique coma ri ixoki'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Y Pedro can ja' xcataj-e, y junanin xbe c'a chuchi-jul. Y cuando xtzu'n-apo chupa ri jul, xutzu' chi ri tziak jec'o can chiri'. Raja' xtzolaj-e, pero yalan satzinak runo'j (sachinak ruc'u'x) roma ronojel ri xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Y chuka' chupa ri k'ij ri', jec'o ca'i' achi'a' quitz'amon bey je-benak pa Emaús, jun ch'uti' tenemit ri c'o pa jun la'k oxi' leguas che ri tenemit Jerusalem. Ri achi'a' re' je ca'i' chique ri xquitzeklebej ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Y yetzijon je-benak. Niquitzijoj ri xebanataj pa ca'i-oxi' k'ij can. ");
INSERT INTO cakNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Y cuando benak quic'u'x riq'uin ri niquitzijoj je-benak, y c'o xabachique (xama'anchique) niquic'utula' chiquiwech; cuando ri Jesús c'astajinak chic pe, xeberila' y junan xbe quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ri ca'i' achi'a' re' niquitzu-wi ri benak quiq'uin, pero c'o ri banayon chique chi reje' man niquitemaj ta rech. ");
INSERT INTO cakNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Y ri Jesús xuc'utuj chique: ¿Anchique nitzijoj ri jix-petenak? ¿Y anchique roma jixbison chuka'? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Y jun chique reje', ri rubinan Cleofas, xch'o'n-apo che y xu'ij: Can man jun winak ri c'o chiri' pa tenemit Jerusalem ri man ta xuna'ej ri c'a juba' tibanataj. Y ret chiri' jat-petenak-wi y man aweta'n ta anchique xebanataj chiri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Y ri Jesús xuc'utuj chique: ¿Anchique xbanataj? Y reje' xqui'ij: Ri xuc'ulumaj ri Jesús aj-Nazaret, jun achi ri can xuk'alajij ri x-ix che roma ri Dios. Y chuka' can xuc'ut chi c'o ruchuk'a', roma ri nima'k tak milagros ri xeru'on y chuka' roma ri rutzij. Quiri' xk'alajin chiquiwech ri winak y chuka' chech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ri nimalaj tak sacerdotes y ri ka-autoridades, jari' ri xebano chi xcamises chech cruz. ");
INSERT INTO cakNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Y roj can xkanojij chi ja raja' ri petenak chi jojrucol konojel roj israelitas. Pero cami man jun chic anchique xtaka'an, roma ja yan re' ri rox k'ij ticom. ");
INSERT INTO cakNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Pero jec'o kaxbil ixoki' ri nimak'a' yan xebe chuchi' ri jul, y xojquixibij juba'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Roma niqui'ij chi ri ruch'acul ri Jesús man c'o ta pa jul. Y niqui'ij chuka' chi c'o ángeles xquic'ut-qui' chiquiwech, y xqui'ij-pe chique chi ri Jesús xc'astaj yan e. ");
INSERT INTO cakNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Y c'o jujun chake roj xebe chuchi-jul chi xbequitzu'. Y anche'l ri xbequi'ij ri ixoki' chake, quiri' xbequitzu' reje', pero ri Jesús manak xquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Y roma ja ri Jesús benak quiq'uin, xu'ij chique: Rix jix nacanak, roma man oconak ta pa iwánima ri qui'in can ri xek'alajin rutzij ri Dios ojer can. ");
INSERT INTO cakNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Man qui'in ta como reje' chi ri Cristo can nuk'axaj na sufrimiento, c'ajari' nibe chila' chicaj chi ne'c'ue' ruk'ij? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Y ri Jesús xuk'alajij-ka chiquiwech ronojel ri je-tz'iban can chirij raja', chupa rutzij ri Dios. Xutz'om-pe riq'uin ri jerutz'iban can ri Moisés, c'a riq'uin ri quitz'iban can ri ch'aka chic achi'a' ri xek'alajin rutzij ri Dios ojer can. ");
INSERT INTO cakNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Y cuando xe'apon anchi' c'o-wi ri ch'uti' tenemit ri rubinan Emaús, ri Jesús xu'on anche'l xa choj nik'ax-e. ");
INSERT INTO cakNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Y ri ca'i' achi'a' can xqui'en che chi tic'ue-ka quiq'uin y xqui'ij che: Cac'ue' can kaq'uin, roma xkak'ij yan ka, y can tarde chic, xecha' che. Y ri Jesús xoc quiq'uin, chi nic'ue-ka quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Y cuando je-ch'ocol chic apo chuchi' mesa, ri Jesús xuc'on-apo ri pan, xuya' matiox che ri Dios, xuper ri pan y xuya' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","C'ajari' anche'l xjakataj chi tak quiwech, y c'ajari' xquitemaj rech chi xa ja ri Jesús ri c'o quiq'uin. Pero xa ja' man xquitzu' ta chic. ");
INSERT INTO cakNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Y ri ca'i' achi'a' ri' niqui'ij chiquiwech: Can ketzij-wi chi can nuna' chic ri kánima cuando jojtzijon joj-petenak, cuando raja' xuk'alajij rutzij ri Dios chake, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ri ca'i' achi'a' ri' can ja' xecataj-e chiri' chuchi' mesa, y xquitz'om bey chi yetzolaj pa Jerusalem. Y xebequila' ri julajuj discípulos y ri juley chic ri can xquitzeklebej-wi ri Jesús, quimolon-qui'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y ri discípulos y ri juley chic niqui'ij: Ri Ajaf Jesús can ketzij chi xc'astaj yan, y xuc'ut yan ri' chech ri Simón. ");
INSERT INTO cakNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Y ri ca'i' achi'a' niquitzijoj ri xquic'ulumaj cuando quitz'amon bey pa Emaús, y xquitemaj rech chi ja-wi ri Jesús cuando xuper ri pan. ");
INSERT INTO cakNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Y conojel ri quimolon-qui', c'a yetzijon chirij ri Jesús, c'aja' xquitzu' c'o chic chiri' chiquicojol, y xu'ij chique: Ja' ta ri uxlanen ri xtic'ue' pa tak iwánima chi'iwonojel, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero reje' xquinojij chi ri niquitzu' ja ri ru-espíritu ri Jesús, romari' can yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Pero ri Jesús xu'ij chique: ¿Anchique roma nisatz ino'j (nisach ic'u'x) roma yinitzu' y man ninimaj ta chi can ja-wi ren? ");
INSERT INTO cakNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Quie'itzu' nuk'a' y wakan. Quinitz'ama-pe, y titzu' chi can ja-wi ren. Roma xa ta jin jun espíritu anche'l ninojij rix, manak ta c'o nuch'acul. Y rix nitzu' chi ren c'o ronojel wiq'uin, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y cuando ri Jesús ru'in chic quiri' chique, xeruc'ut ri ruk'a-rakan chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Pero reje' man niquinimaj ta. Xa satzinak quino'j (sachinak quic'u'x) roma ri niquitzu' y roma yalan yequicot. Y chi niquinimaj, ri Jesús xuc'utuj chique: ¿C'o juba' anchique nitej iwiq'uin chi nisipaj ta juba' chue? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Y reje' xbequiya-pe che juba' sa'on quer y juba' cab ri c'a c'o pa cera. ");
INSERT INTO cakNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Y raja' xuc'on y xutaj chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Y xu'ij chique: Cuando c'a jinc'o iwiq'uin, xin-ij chiwe chi can nic'atzin yenc'ulumaj ronojel ri je-tz'iban can chuij chupa rutzij ri Dios: Ri je-tz'iban can roma ri Moisés, ri je-tz'iban can coma ri achi'a' ri xek'alajin rutzij ri Dios ojer can, y ri je-tz'iban can chupa ri libro ri ni'ix Salmos che. ");
INSERT INTO cakNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","C'ajari' raja' xu'on chique chi tiquibana' entender rutzij ri Dios ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Y xu'ij chique: Can quiri-wi tz'iban can chupa rutzij ri Dios, chi ren ri Cristo xtink'axaj sufrimiento, y can yicom-wi, y pa rox k'ij yic'astaj-pe, ");
INSERT INTO cakNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y jec'o ri xquiebe pa nubi' ren chi ne'quitzijoj rutzij ri Dios chique ri winak chech-ulef, y xtiqui'ij chique chi tiquiya' can ri mac y tiquibana' ri nrojo' ri Dios, chi quiri' nicoch'otaj (nicuyutaj) quimac. Y ronojel ri' xtitiquier pa Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Y rix ri can xitzu', tik'alajij ronojel ri xitzu'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Y can tic'oxaj utz ri nin-ij can chiwe, xcha' ri Jesús. Can xtintak-pe chiwe ri ru'in ri Nata' Dios chi nuya-pe chiwe; y ri ru'in raja' chi nuya' chiwe, ja ri Espíritu Santo. Y jari' ri xtiyo'n iwuchuk'a'. Y quixc'ue-ka we' pa tenemit Jerusalem c'a ri k'ij cuando xtika-pe ri Espíritu Santo, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Y ri Jesús xeruc'uaj-e ri ru-discípulos c'a pa tenemit Betania. Y chiri', raja' xerutzekej ri ruk'a' chicaj, y xuc'utuj ru-bendición ri Dios pa quiwi' reje'. ");
INSERT INTO cakNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Y Jesús jari' ri nu'on cuando can ja' xbe-e chiquiwech. Xcataj-e pa quiek'ik' y xuc'uax-e chicaj riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Y ri discípulos can xquiya' ruk'ij ri Jesús chiri'. C'ajari' xetzolaj pa tenemit Jerusalem. Reje' yalan yequicot pa cánima. ");
INSERT INTO cakNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y can k'ij-k'ij jec'o pa rocho ri Dios chi niquiya' ruk'ij ri Dios y nim niqui'en che rubi'. Amén.");
INSERT INTO cakNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Cuando xtiquier-pe ronojel; ri Cristo, ri Rutzij ri Dios, can c'o-wi-pe. Raja' can c'o-wi riq'uin ri Dios, y raja' chuka' can Dios-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Raja' can c'o-wi-pe riq'uin ri Dios cuando x-an ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Y roma raja' c'o ronojel. Roma ri Dios, can pa ruk'a' ri Cristo xuya-wi chi xu'on ronojel ex. ");
INSERT INTO cakNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Riq'uin raja' c'o-wi ri c'aslen. Y ri c'aslen re', jari' ri nisakrisan quichi ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Y ri jun Sakil re', can nisakrisan-wi pa quic'aslen ri winak ri can jec'o pa k'eku'm. Y can man jun mej (bey) chuputajnak pa ruk'a' ri k'eku'm. ");
INSERT INTO cakNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Y xc'ue' jun achi ri cha'on-pe roma ri Dios, jun achi ri xubinaj Juan. ");
INSERT INTO cakNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri Juan re' xpe chi xoruk'alajij ri Sakil, chi quiri' can conojel ri winak tiquinimaj. Can tiquinimaj ri nutzijoj raja' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Y man ja' ta raja' ri Sakil. Raja' xe xoruk'alajij ri Sakil ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Y can ja xoka ri Sakil chech-ulef. Jari' ri ketzij Sakil, ri nisakrisan quichi ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Can xoka-wi chech ri rech-ulef ri banon roma raja', pero ri jec'o chech-ulef man xquitemaj ta rech cuando xoka. ");
INSERT INTO cakNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Can chupa-wi ri rech-ulef ri richi raja' xoka-wi, pero ri winak ri je richi raja' xa man xquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Y ri xec'amo-ka richi cuando xoka chech-ulef, y can xquinimaj-wi, raja' can xu'on chique chi xe'oc ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ri winak ri xe'oc ralc'ual ri Dios, can xe'alex-wi chic jun mej (bey), pero man junan ta chic riq'uin cuando xe'alex na'ey quiq'uin quite-quitata', cuando can ja ri te'j-tata'j xquijo' chi xe'alex. Cami xe'alex chic jun mej (bey) roma can ja quiri' xrojo' ri Dios, y man roma ta quiri' xquijo' ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Y ri Cristo, ri Tzij, xoka chech-ulef y can xoc chuka' winak anche'l roj. Y can xkatzu' chi can xe-wi raja' ri Ralc'ual ri Dios, roma can xkatzu' ri nimalaj ruk'ij. Y raja' can nojinak riq'uin ri ketzij y can yalan yerojo' conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Y ri Juan Bautista, can c'o ri xuk'alajij chirij ri Cristo. Can riq'uin-wi ruchuk'a' xu'ij: Jare' ri nutzijon chiwe, cuando xin-ij chiwe chi ri xtoka chuij ren, jari' ri nimalaxel chinuech. Y can c'o-wi na'ey cuando ren c'a man jani quinoka we' chech-ulef, xcha' ri Juan Bautista. ");
INSERT INTO cakNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Can konojel roj kawilon ri ru-bendición ri Cristo. Y man xe ta jun bendición ri ruyo'n-pe pa kawi', xa can quitzeklebelo'n-qui' ri bendición ri yeruya-pe pa kawi'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Dios ja ri Moisés ri xucusaj chi xuya-pe ri ley. Y ja ri Jesucristo xucusaj chi xkatemaj ri ketzij y chuka' chi xuc'ut chakawech chi yalan jojrojo'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Can man jun winak ri tz'eteyon richi ri Dios, xa can xe ri Ralc'ual ri tz'eteyon richi. Ri Dios can xe jun Ralc'ual c'o y can nrojo'. Y jari' ri xok'alajin-ka ri Dios chakawech we' chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Y ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas chiri' pa tenemit Jerusalem, jec'o ri xequitak-e riq'uin ri Juan Bautista. Xequitak achi'a' sacerdotes y achi'a' ri ni'ix levitas chique, chi xbequic'utuj che ri Juan chi tu'ij xa ja raja' ri Cristo. Y raja' can xuk'alajij chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ri Juan can ja-wi ri ketzij ri xuk'alajij, roma xu'ij chique: Man ja' ta ren ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Y ri achi'a' ri je-takon-e xquic'utuj chic che: ¿Jat ancu'x (anchique) c'a? ¿O xa ja ret ri Elías, ri achi ri xk'alajin ri rutzij ri Dios ojer can? xecha' che. Pero ri Juan xu'ij chique: Man ja' ta ren ri Elías. C'ajari' ri achi'a' ri' xquic'utuj chic jun mej (bey) che ri Juan: ¿Ja ret ri xcak'alajin rutzij ri Dios ri can xtipe-wi? xecha' che. Pero raja' xu'ij chique: Ni, man ja' ta ren. ");
INSERT INTO cakNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Y ri achi'a' ri' can xquic'utuj chic che: ¿Jat ancu'x (anchique) c'a? Roma roj can nic'atzin chake chi nakana'ej-e jat ancu'x (anchique) ret, y jari' ri ne'ka'ij chique ri je-takayon-pe kachi. Tak'alajij-awi' chakawech, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y raja' xu'ij chique ri achi'a' ri': Ja ren ri jun ri anchok chirij c'o rutz'iban can ri Isaías, ri jun ri xuk'alajij rutzij ri Dios ojer can. Y jare' ri xutz'ibaj can raja': C'o jun achi xtic'ue' pa tz'iran rech-ulef, y ja raja' ri xtitzijon rutzij ri Dios chiquiwech ri winak ri xquie'apon riq'uin. Y xtu'ij chique: Tichojmisaj ri ic'aslen, roma nakaj chic petenak ri Ajaf, xcha' ri Juan chique. ");
INSERT INTO cakNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri achi'a' ri xe'apon riq'uin ri Juan, ja ri je-takon-e coma ri fariseos. ");
INSERT INTO cakNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Y ri achi'a' ri' xquic'utuj chic che ri Juan: ¿Anchique roma ret ye'aben bautizar ri winak? Y xa man ja' ta ret ri Cristo, ni man ja' ta ret chuka' ri Elías, ni man ja' ta ret ri xcak'alajin rutzij ri Dios ri can xtipe-wi, xecha' ri achi'a' ri' che ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Y ri Juan xu'ij chique: Ren riq'uin ya' yenben-wi bautizar ri winak, pero chi'icojol rix c'o Jun ri man iweta'n ta rech, ");
INSERT INTO cakNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","y raja' can chuij ren xtoka-wi, pero raja' can c'o-pe na'ey chinuech ren. Y can man nuc'ul ta chi ja ren yisolo ruximbel ruxajab, roma raja' can nim ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Y ronojel re', ja chiri' pa Betábara xbanataj-wi, ri lugar ri c'o-apo juc'an ruchi' ri rakan-ya' Jordán, chiri' nu'on-wi bautizar ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ruca'n k'ij cuando ri Juan Bautista xutzu' chi ri Jesús can choj riq'uin raja' petenak-wi, xu'ij: Jala' ri anche'l Alaj Ral Oveja ri takon-pe roma ri Dios, chi nulesaj quimac ri winak ri jec'o chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Y jare' ri nutzijon chiwe, cuando xin-ij chi chuij ren xtoka jun achi ri can nimalaxel-wi chinuech ren, y can c'o-wi na'ey, cuando ren man jani quinoka-ka chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Y ren man weta'n ta anchique achi raja'. Pero chi nik'alajix chique ri winak israelitas, romari' xipe ren chi nin-en bautizar riq'uin ya'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Y ri Juan can xuk'alajij chuka' y xu'ij: Ren can xintzu' ri Espíritu Santo ri xka-pe chicaj anche'l jun paloma y xoc'ue-ka pa ruwi' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Y ren chiri' c'a man jani weta'n ancu'x (anchique) ri Jun ri'. Pero ri Dios ri yoyo'n-pe ri jun samaj re' chue can ru'in-wi chic chue, chi cuando xtintzu' chi nika-pe ri Espíritu Santo y noc'ue-ka pa ruwi' jun achi, jari' ri nibano bautizar riq'uin ri Espíritu Santo y man riq'uin ta ya'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Cami can xintzu' yan, y romari' nink'alajij chi ja raja' ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Y ruca'n k'ij, ri Juan y je ca'i' chique ri ru-discípulos jec'o chic chiri' jun mej (bey). ");
INSERT INTO cakNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Y cuando raja' xutzu' chi ri Jesús nik'ax-e chiri', xu'ij: Titzu', ja Jesucristo la', ri anche'l Alaj Ral Oveja ri takon-pe roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Y cuando ri ca'i' ru-discípulos ri Juan xquic'oxaj quiri', ja xquitzeklebej-e ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Y cuando ri Jesús xtzu'n can chirij y xutzu' chi ri ca'i' ru-discípulos ri Juan quitzekleben-e, raja' xu'ij chique: ¿Anchique nicanoj? xcha' chique. Y reje' xqui'ij che ri Jesús: Rabí, roj nakajo' nakatemaj anchi' c'o-wi ri awocho, xecha' che. Ri israelitas Rabí yecha' che jun maestro. ");
INSERT INTO cakNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Y ri Jesús xu'ij chique: Jo', y titzu'. Y reje' can xebe y xquitzu' ri rocho. Y xec'ue-ka riq'uin ri Jesús ri jun nak'ak'ij ri', roma xa can las cuatro chic. ");
INSERT INTO cakNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri jun chique ri je ca'i' discípulos ri xuc'oxaj ri xu'ij ri Juan y xquitzeklebej-e ri Jesús, ja ri Andrés ri rach'alal ri Simón Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ri Andrés, na'ey xberucanoj ri Simón ri rach'alal y xberu'ij che: Keta'n chic ancu'x (anchique) ri Mesías. Quiri' niqui'ij ri israelitas che ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Y ri Andrés xuc'uaj ri Simón riq'uin ri Jesús. Y cuando ri Jesús xutzu', xu'ij che: Ja ret ri Simón ri ralc'ual ri Jonás. Cami xti'ix chuka' Cefas chawe. Y quiri' niqui'ij ri israelitas che jun winak rubinan Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Y pa ruca'n k'ij, ri Jesús can xunojij nibe c'a Galilea. Y chupa ri k'ij ri' ri Jesús xberuc'ulu-pe ri jun achi Felipe rubi' y xu'ij che: Quinatzeklebej. ");
INSERT INTO cakNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Y ri Felipe aj-tenemit Betsaida, ri tenemit anchi' c'o-wi cocho ri Andrés y ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ri Felipe xberuc'ulu-pe ri jun achi rubinan Natanael, y xu'ij che: C'o chic ri Jun ri runatan can ri Moisés chupa ri ley y ri quinatan chuka' ri achi'a' ri xek'alajin rutzij ri Dios ojer can, chupa ri jequitz'iban can. Roj xkatemaj rech cami. Raja', ja ri Jesús ri ralc'ual ri José aj-Nazaret. ");
INSERT INTO cakNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Y ri Natanael xu'ij: ¿Xtel-pe como jun utzilaj achi chiri' pa tenemit Nazaret? xcha' raja'. Pero ri Felipe xu'ij che: Xa man nanimaj ta, jo' y katzu'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Y cuando ri Jesús xutzu' chi petenak ri Natanael y napon yan riq'uin, xu'ij: Titzu' ri jun achi re'. Raja' can richi-wi ri rutenemit ri Dios; raja' jun ketzij israelita, roma quiri' nuc'ut ri ruc'aslen. Can man jun engaño riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","C'ajari' ri Natanael xuc'utuj che ri Jesús: ¿Anchi' xatemaj-wi nuech? Y ri Jesús xu'ij che: Ren xatintzu' cuando c'a jatc'o chuxe' ri mata higo cuando c'a man jani caruc'ul ri Felipe, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ri Natanael can ja' xu'ij: Maestro, xcha' che. Can ja-wi ret ri Ralc'ual ri Dios. Y can ja ret ri Rey richi ri tenemit Israel, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Y ri Jesús xu'ij che ri Natanael: Ret can xanimaj chi ja ren ri Ralc'ual ri Dios, roma xin-ij chawe chi chuxe' ri mata higo jatc'o-wi cuando c'a man jani caruc'ul ri Felipe. Can q'uiy na ri xtatzu' chi quiri' nanimaj más. ");
INSERT INTO cakNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y ri Jesús xu'ij chuka': Can tinimaj ri nin-ij chiwe: Rix can xtitzu' chi ri chicaj xtijakataj, y ri ángeles richi ri Dios xquiexule-xquiejote' wiq'uin chi yinquito' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Y pa rox k'ij, chiri' pa tenemit rubinan Caná ri c'o pa Galilea, c'o jun c'ulubic x-an. Y ri María ri rute' ri Jesús, can c'o-apo chuka' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Y ri Jesús y ri ru-discípulos, xe'an chuka' invitar chupa ri c'ulubic ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Y ri ruya'al-uva xa xq'uis ch'anin chupa ri c'ulubic ri'. Y ri María ri rute' ri Jesús, xapon-apo riq'uin ri Jesús y xberu'ij che: Manak chic ruya'al-uva quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Pero ri Jesús xu'ij che: ¿Anchique najo' chue? Roma ri nu-hora c'a man jani tapon, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Y ri rute' ri Jesús xu'ij chique ri yebano servir: Xa c'o anchique xtu'ij ri Jesús chiwe, can tibana' ronojel, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Y chiri' jec'o waki' nima'k tak cucu' (tinajas) je-banon che abaj, roma chupa ri cucu' (tinajas) ri' niquiya-wi ri ya' ri nic'atzin chique chi niquich'ajch'ojij-qui', anche'l nu'ij ri ley chi tiquibana' ri israelitas. Y ri cucu' (tinajas) ri', quieji' ciento vasos ya' quipa. ");
INSERT INTO cakNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Y ri Jesús xu'ij chique ri yebano servir: Quie'ibalij riq'uin ya' ri cucu' (tinajas) re', xcha' chique. Y reje' can quiri' xqui'en. Can xequibalij utz ri nima'k tak cucu' (tinajas) ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","C'ajari' ri Jesús xu'ij chique: Cami tipaja-e juba' y tic'uaj che ri achi ri pa'l chech ri nimak'ej re', chi tutojtobej ruqui'l. Y ri yebano servir can xqui'en-wi ri xu'ij ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Y cuando ri achi ri pa'l chech ri nimak'ej ri' xutojtobej ruqui'l y xuna' chi can utz ri ruya'al-uva, xroyoj ri ala' ri xc'ule'. Ri achi ri pa'l chech ri nimak'ej ri' man reta'n ta anchi' petenak-wi ri ruya'al-uva. Xa can xe ri xepajo-e ri je-etamayon. ");
INSERT INTO cakNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Y cuando ri ala' ri xc'ule' xapon riq'uin ri achi ri pa'l chech ri nimak'ej, ri achi ri' xu'ij che: Cuando c'o jun nimak'ej quiere', conojel winak ja ri ruya'al-uva ri más utz niquiya' na'ey, y cuando ri jec'o pa nimak'ej q'uiy yan quitijon, niquiya' jun ruya'al-uva ri man can ta utz. Pero ret xa man quiri' ta xa'an. Ret xa c'aja' xalesaj-pe ri ruya'al-uva ri más utz, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ri xu'on ri Jesús chupa ri c'ulubic pa Caná chiri' pa Galilea, jari' ri na'ey milagro ri xu'on. Y ri jun milagro re', can xuc'ut chi raja' can c'o-wi ruk'ij. Y ri je ru-discípulos can xquiya' cánima riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Cuando xq'uis ri nimak'ej chi ri c'ulubic, ri Jesús y ri rute', ri je rach'alal y ri ru-discípulos xebe pa tenemit Capernaum. Y xec'ue' jun jani' oc k'ij chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Y can noka yan ri k'ij richi ri quinimak'ej ri israelitas ri rubinan pascua, ja k'ij ri' yecamises ri ovejas. Romari' ri Jesús xbe c'a pa tenemit Jerusalem chi ri nimak'ej ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Y chiri' pa rocho ri Dios ri c'o pa Jerusalem, ri Jesús xeberila' winak ri yequic'ayila' wacx, ovejas y palomas. Y xeberila' chuka' ri winak ri niquijalala' rech mero je-ch'ocol chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ri Jesús, can xe xerutzu', xu'on jun ruch'aybal che colo' y xerokotaj-pe conojel. Xerokotaj-pe quiq'uin ri qui-ovejas y quiwacx chiri' pa rocho ri Dios. Y chique ri niquijalala' rech mero, xuq'uiakala' can ri qui-mero chiquiwech y xerutacmayila' can ri qui-mesas. ");
INSERT INTO cakNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Y chique ri yequic'ayij palomas xu'ij: Quie'ilesaj-e re' we'. Y man tiben che ri rocho ri Nata' Dios, jun c'ayibel, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Romari' ri ru-discípulos can ch'anin xoka pa quiwi' ri jun tzij tz'iban can chupa rutzij ri Dios. Ri tzij ri' nu'ij: Nik'axon wánima roma ri niqui'en ri winak chupa ri awocho, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Y ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, xqui'ij che ri Jesús: ¿Anchique jatiquier na'an chakawech chi nakatzu' xa can c'o uchuk'a' pa ak'a' chi xe'awokotaj-e ri winak we'? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Y ri Jesús xu'ij chique: Tikasaj pa ulef ri jun jay re', ri can richi ri Dios, y ren pa oxi' k'ij xtinyec chic jun mej (bey), xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","C'ajari' ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas xqui'ij che ri Jesús: Ri jun jay re', cuarenta y seis juna' xqui'en ri kate-katata' chirij chi xquipoba'. ¿Jatiquier cami ret napoba' pa oxi' k'ij? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri jay ri xu'ij ri Jesús chique ri winak ri', ja ri ruch'acul raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y romari', cuando ri Jesús xcamises chech ri cruz y pa rox k'ij xbec'astaj-pe, ri ru-discípulos xoka pa quiwi' ri jun tzij ri xu'ij chique ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas. Y xquinimaj rutzij ri Dios ri tz'iban can y ri tzij ri jeru'in can ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Y chupa ri k'ij cuando ri Jesús c'o pa tenemit Jerusalem roma ri nimak'ej pascua, can je q'uiy-wi winak ri xeniman richi roma xequitzu' ri milagros ri xeru'on. ");
INSERT INTO cakNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero ri Jesús man xuya' ta ránima quiq'uin ri winak ri' chi can ketzij xquinimaj, roma raja' can reta'n-wi ri c'o pa tak cánima conojel winak. ");
INSERT INTO cakNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Can man nic'atzin ta che chi c'o ta jun ri ni'in anchique rubanon ri quic'aslen chiquijunal ri winak, roma raja' can reta'n-wi anchique ri c'o pa tak cánima. ");
INSERT INTO cakNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Y c'o jun achi chiquicojol ri fariseos ri rubinan Nicodemo, y ri achi re' can c'o-wi ruk'ij chiquiwech ri winak israelitas. ");
INSERT INTO cakNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Raja' xapon riq'uin ri Jesús jun nok'ok'a' y xu'ij che: Can keta'n-wi chi jat jun Maestro ri takon-pe roma ri Dios; roma ri milagros ri ye'aben, xe jun ri c'o Dios riq'uin nitiquier nibano quiere', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Y ri Jesús xu'ij che ri Nicodemo: Can ketzij ri nin-ij chawe: Ri winak ri man xtalex ta chic jun mej (bey), man xtitiquier ta xtoc quiq'uin ri ye'an gobernar roma ri Dios, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Pero ri Nicodemo xu'ij che ri Jesús: ¿Can nitiquier como nalex chic jun mej (bey) jun achi ri'j chic? ¿Y can nitiquier como ri rute' nralaj chic jun mej (bey)? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xu'ij: Can ketzij ri nin-ij chawe: Ri c'ac'ac' alaxnic ri xinnataj, jari' ri ni'an roma ri Espíritu Santo y ya'. Y ri man xquie'alex ta chic jun mej (bey), can man xquie'oc ta quiq'uin ri ye'an gobernar roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ri winak ri ye'alex chech-ulef, can aj-rech-ulef-wi. Pero ri winak ri ye'alex chic jun mej (bey) roma ri Espíritu Santo, can je richi-wi ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Y man tisatz ano'j (tisach ac'u'x) roma ri xin-ij chawe, roma can quiri-wi: Can nic'atzin chi conojel ye'alex chic jun mej (bey). ");
INSERT INTO cakNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ri ye'alex chic jun mej (bey) roma ri Espíritu Santo, nijalataj ri quic'aslen. Ri Espíritu Santo man nitz'et ta, xa can anche'l ri quiek'ik' ri xabachi' (xama'anchi') nipe-wi; xe nac'oxaj, pero man aweta'n ta anchi' petenak-wi y man aweta'n ta chuka' anchi' nibe-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Y ri Nicodemo xuc'utuj che ri Jesús: ¿Anchique c'a modo ri'? ");
INSERT INTO cakNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xu'ij che: ¿Man aweta'n ta anchique modo re', y can jat jun maestro chiquicojol ri israelitas? ");
INSERT INTO cakNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ren nintzijoj ri weta'n y ri nutz'eton, pero ret y ri winak man nijo' ta ninimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Rix man ninimaj ta ri nin-ij chiwe, y ren xa chiquij ex ri yebanataj we' chech-ulef yich'o'n-wi, y xa ta yich'o'n chiquij ri yebanataj chicaj chiwe, can manak-wi xquininimaj, roma xa chi chila' chicaj. ");
INSERT INTO cakNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Y chicaj man jun aponinak, xa can xe ri Jun ri kajinak-pe chicaj. Can xe raja' ri aponinak. Xa can xe ri Jun ri xalex chi'icojol y chicaj riq'uin ri Dios c'o-wi rocho. ");
INSERT INTO cakNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Y ojer can ri', cuando ri Moisés xc'ue' pa tz'iran rech-ulef, raja' xutic jun che' nim rakan y xuya' jun ruwachibel cumetz parui'. Y anche'l x-an che ri ruwachibel ri cumetz chutza'n ri che' ri', can quiri' chuka' nic'atzin chi ni'an che ri Jun ri kajinak-pe chicaj y xalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Chi quiri' anchique winak ri xtiniman richi, man xticom ta chi ronojel tiempo, xa can xtic'ue' ruc'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ri Dios can yalan-wi yerojo' ri winak ri jec'o chech-ulef, romari' xutak-pe ri Ralc'ual we' chech-ulef. Más que raja' can xe ri' ri Ralc'ual c'o, can xutak-pe, chi quiri' xabachique (xama'anchique) winak ri xtiniman richi, man xticom ta chi ronojel tiempo, xa can xtic'ue' ruc'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ri Dios man xutak ta pe ri Ralc'ual we' chech-ulef chi yeru'on juzgar ri winak y yeru'on castigar. Ri Dios xutak-pe ri Ralc'ual chi jojrucolo-ka chech kamac. ");
INSERT INTO cakNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ri winak ri xquieniman richi, man xtika ta ri castigo pa quiwi'. Pero ri winak ri man xquieniman ta richi, ri castigo ri nuya' ri Dios can c'o chic pa quiwi', roma man xquijo' ta xquinimaj ri Ralc'ual ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Can conojel-wi ri man yeniman ta richi, c'o chic ri castigo pa quiwi'; roma ri Sakil can xoka-wi chech-ulef, pero reje' xa más xquijo' ri k'eku'm chech ri Sakil, roma reje' can xe ri itzel tak ex ri niquijo' niqui'en. ");
INSERT INTO cakNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Y conojel ri yebano ri itzel tak no'j (na'oj), ri Sakil can man nika ta chiquiwech, can man niquijo' ta ye'apon-apo chupa, roma ri Sakil nu'on chi yebek'alajin-pe ronojel ri itzel tak no'j (na'oj) ri yequi'en. ");
INSERT INTO cakNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero ri winak ri can yequi'en-wi ri ketzij, can ye'apon-apo chupa ri Sakil chi nik'alajin chi niqui'en anche'l nrojo' ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","C'ajari' ri Jesús y ri ru-discípulos xebe pa Judea, y chiri' xebec'ue-wi. Y xe'apon ri winak chiri' chi xe'an bautizar. ");
INSERT INTO cakNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Chupa chuka' ri tiempo ri', ri Juan Bautista c'o chiri' pa Enón, ri c'o-apo chunakaj ri tenemit rubinan Salim. Raja' chiri' yeru'on-wi bautizar ri winak, roma chupa ri lugar ri' q'uiy ya' c'o. Ri winak ye'apon riq'uin chi ye'an-e bautizar. ");
INSERT INTO cakNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chupa ri tiempo ri' ri Juan c'a man jani titz'apis pa cárcel. ");
INSERT INTO cakNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Y jec'o israelitas ri xquitz'om-qui' riq'uin tzij quiq'uin ri ru-discípulos ri Juan chirij ri anchique ri bautismo ri más utz. ");
INSERT INTO cakNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xepe ri discípulos ri' xebe-apo riq'uin ri Juan y xbequi'ij che: Maestro, xecha'. Ri Jun ri xapon awiq'uin ri juc'an chic ruchi-ya' Jordán, ri xa'ij chi ja raja' ri nak'alajij, xa can conojel chic ri winak ye'apon riq'uin chi yeru'on bautizar. ");
INSERT INTO cakNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Y ri Juan xu'ij chique ri ru-discípulos: Ja ri Dios xti'in ancu'x (anchique) xtic'ue' más ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Y rix mismo jixtiquier jix-in ri nu'in ren, que man ja' ta ren ri Cristo. Ren xe nu'in chi xitak-pe chi ninchojmirisaj ri anchi' xtoka-wi raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ren can yalan niquicot ri wánima cami, roma ri xinc'oxaj chi je q'uiy winak ye'apon riq'uin ri Jesucristo. Nin-en anche'l nu'on ri jun ala', ri ala' ri' c'o jun ru-amigo xc'ule' y niquicot roma yeruc'oxaj ri ala' y ri xten junan yetzijon y quic'uan chic qui'. Can reta'n chi ri xten c'o chic apo riq'uin ri rachijil, quiri' yiquicot ren riq'uin ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Can xe ri Jesucristo ri nic'atzin chi k'ij-k'ij ninimer más ruk'ij, pero ren utz chi k'ij-k'ij más co'l nin-en-ka, xcha' ri Juan. ");
INSERT INTO cakNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ri Jun ri petenak chicaj, jari' ri más c'o ruk'ij que konojel roj winak. Roma kano'j (kana'oj) roj winak, can xe we' chech-ulef niq'uis-wi-ka. Can xe ri c'o chech-ulef ri jojtiquier nakatzijoj. Pero ri Jun ri kajinak-pe chicaj, man anche'l ta oc roj, roma raja' can c'o parui' ronojel. ");
INSERT INTO cakNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ri Jun ri petenak chicaj, can ja ri ruc'oxan-pe y rutz'eton-pe, jari' ri noruk'alajij-ka chake. Pero ri winak man niquijo' ta niquinimaj ri nuk'alajij raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Pero ri winak ri can niquinimaj ri nuk'alajij ri Jun ri petenak chicaj, can niquik'alajij chi ri Dios can ketzij-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Roma ri Jun ri xtak-pe roma ri Dios chech-ulef, can ja-wi rutzij ri Dios ri nutzijoj. Y ri Dios can ruyo'n-pe ri Espíritu Santo che, y can man xretaj ta xuya-pe che. ");
INSERT INTO cakNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Y ri Ajaf Dios yalan nrojo-wi ri Ralc'ual, y pa ruk'a' raja' xujach-wi ronojel. ");
INSERT INTO cakNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ri winak ri xtiquinimaj ri Ralc'ual, can xtic'ue' quic'aslen ri man xtiq'uis ta. Pero ri winak ri man niquijo' ta niquinimaj ri Ralc'ual ri Dios, man xtic'ue' ta quic'aslen; roma ri winak ri man xtiquiya' ta cánima riq'uin, can je richi chic chi nika ri castigo ri xtuya' ri Dios pa quiwi'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri achi'a' fariseos quic'oxan chi ri Jesús yeru'on bautizar más winak y más je q'uiy ri yetzekleben richi, que chiquiwech ri winak ri ye'an bautizar y ri yetzekleben richi ri Juan Bautista. Y ri Ajaf Jesús xuna'ej ronojel re'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero man ja' ta ri Jesús nibano bautizar quichi ri winak; xa ja ri ru-discípulos ri yebano bautizar. ");
INSERT INTO cakNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Y ri Jesús xel-e chiri' pa Judea y xtzolaj chic jun mej (bey) pa Galilea y je-benak ri ru-discípulos riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Y chi ye'apon c'a pa Galilea, yek'ax na pa Samaria. ");
INSERT INTO cakNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ri Jesús y ri ru-discípulos xe'apon pa Sicar. Ri Sicar jun tenemit chi ri Samaria. Ri Sicar c'o-apo chunakaj ri ulef ri xuya' ri Jacob che ri José ri ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Y chiri' c'o-wi ri pozo ri ni'ix Chi ri Jacob che. Chiri' xch'oquie-wi ri Jesús, roma raja' yalan cosinak-pe roma ri binen ri quibanon-pe. Pa nic'aj-k'ij la'k ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Y cuando je-benak ri ru-discípulos pa tenemit chulok'ic wey, riq'uin ri pozo ri' xapon jun ixok aj-Samaria, chi nulesaj ruya'. Y ri Jesús xu'ij che ri ixok ri': Tasipaj juba' nuya' chi ninkum, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Pero ri ixok aj-Samaria xu'ij che ri Jesús: Ret jat jun israelita, ¿anchique roma nac'utuj aya' chue ren? ¿Utz como chi jun aj-Samaria nuya' ruya' jun israelita? xcha' ri ixok. Raja' xu'ij quiri' roma ri israelitas y ri aj-Samaria xa man niquijo' ta qui'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","C'ajari' ri Jesús xu'ij che ri ixok ri': Xa ta ret aweta'n anchique ri ruyo'n-pe ri Dios, y aweta'n ta chuka' ancu'x (anchique) nuc'utuj juba' ruya' chawe; ja' ta ret ri nac'utuj ta aya' che, y raja' nuya' ta Aya' ri can niyo'n c'aslen, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Y ri ixok xu'ij che ri Jesús: Ri pozo naj kajinak-wi-ka rupa, y ret man jun anchique c'o awiq'uin chi nalesaj-ka ri ya'. ¿Anchi' nalesaj-wi ri Ya' ri niyo'n c'aslen ri nasuj? ");
INSERT INTO cakNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Roma can chupa ri jun pozo re' xleses-wi ruya' ri kamama' Jacob, ri ralc'ual y chuka' quichi ri cawaj. ¿Anchi' c'a xtalesaj-wi ri Ya' ri nasuj? ¿O más c'o ak'ij ret que chech ri kamama' Jacob chi quiri' man we' ta nalesaj-wi ri Ya' ri na'ij chi nuya' c'aslen? xcha' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Y ri Jesús xu'ij che ri ixok: Ri yekumu ri ya' ri ntel chupa ri jun pozo re', man niq'uis ta e ri quichake'j-chi'. Xa can nic'atzin chi niquikum más ya' chi nich'uch'u-ka juba' ri quichake'j-chi'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero ri yekumu ri Ya' ri niyo'n c'aslen ri ninya' ren chique, xtu'on che ri cánima chi can manak chic xtichake'j ruchi'. Xa can xtu'on chique chi quiq'uin reje' nalex-wi ri Ya' ri', y can xtitoxlin-pe (xtichoxin-pe) chi nic'ue' quic'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Y ri ixok can ja' xu'ij che ri Jesús: Taya' ri Ya' ri' chue ren, chi quiri' can manak-wi chic xtichake'j nuchi' y manak chic chuka' xquipe we' chuchi' pozo chi ninlesaj, xcha' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xu'ij che ri ixok: Awoyoj-pe ri awachijil, xuche'x roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ri ixok xu'ij: Ren manak wachijil, xcha'. Y ri Jesús xu'ij che: Can ketzij-wi ri na'ij chi manak awachijil. ");
INSERT INTO cakNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Roma can je wo'o' yan achi'a' ri quiec'ule' awiq'uin; y ri achi ri c'o awiq'uin cami, man awachijil ta roma man jat-c'ulan ta riq'uin. Can ketzij ri xa'ij chi manak awachijil, xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Y ri ixok can ja' xu'ij che ri Jesús: Ren ninnojij chi ret jat jun ri nik'alajin ri nu'ij ri Dios che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","¿Anchique lugar utz chi nakaya-wi ruk'ij ri Dios? Roma ri kate-katata' ri xec'ue' ojer can, parui' ri jun juyu' re' xqui'en-wi ri jay chi xquiya' ruk'ij ri Dios. Pero rix ri israelitas ni'ij chi conojel winak, pa Jerusalem tiquiya-wi ruk'ij ri Dios, xcha' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Y ri Jesús xu'ij che ri ixok ri': Tanimaj ri xtin-ij chawe. Can xtoka-wi jun k'ij cuando conojel winak man parui' ta chic ri juyu' re', ni man pa Jerusalem ta chuka' xtiquiya-wi ruk'ij ri Katata' Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Rix aj-Samaria q'uiy ri man iweta'n ta chirij anchique modo niya' ruk'ij ri Dios. Pero roj israelitas can keta'n-wi ri ancu'x (anchique) ri nakaya' ruk'ij; roma can ja kaq'uin roj petenak-wi chi ri winak yecolotaj chupa ri quimac. ");
INSERT INTO cakNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ri jun k'ij ri xin-ij chawe chi can nipe-wi, xoka yan, chi conojel winak man chic niquiya' ta ruk'ij ri Katata' Dios parui' ri juyu' re', ni chuka' pa Jerusalem. Ri can ketzij xtiquiya' ruk'ij ri Katata' Dios, ja ri c'o ri Espíritu Santo quiq'uin, y chuka' can riq'uin ronojel cánima xtiquiya' ruk'ij. Y ri Dios can ja ri winak ri yebano quiri' ri yerojo'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ri Dios can Espíritu-wi. Romari' ri winak ri yeyo'n ruk'ij, can nic'atzin chi c'o ri Espíritu Santo quiq'uin y riq'uin ronojel cánima tiquiya' ruk'ij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Y ri ixok xu'ij che ri Jesús: Ren weta'n chi c'o na jun k'ij ri Mesías ri ni'ix chuka' Cristo che, xtoka chech-ulef. Y ri k'ij cuando xtoka raja', ronojel xtuk'alajij chakawech, xcha' ri ixok. ");
INSERT INTO cakNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xu'ij che: Ri Mesías ri ni'ix chuka' Cristo che, ja ren ri yitzijon awiq'uin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Y ja' cuando xe'apon ri ru-discípulos; reje' xsatz quino'j (xsach quic'u'x) roma nitzijon riq'uin jun ixok aj-Samaria, pero ri discípulos man jun anchique xqui'ij che ri Jesús: ¿Anchique nac'utuj che? o ¿Anchique ri natzijoj riq'uin? Can man jun-wi ri xquic'utuj che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Y ri ixok ri' xuya' can ri rucucu' (ru-tinaja) chiri' y xbe pa tenemit. Y xberu'ij chique ri winak: ");
INSERT INTO cakNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","C'o jun achi xch'o'n wiq'uin y xu'ij chue ronojel ri jenubanon. ¿Man ja' ta como re' ri Cristo ri takon-pe roma ri Dios? Jo', y titzu', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Y conojel ri winak ri xquic'oxaj ri', xquiya' can ri tenemit y xebe c'a anchi' c'o-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Y cuando c'a man jani quie'apon ri winak, ri discípulos xqui'ij che ri Jesús: Maestro, cawa', xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero raja' xu'ij chique: Rix man iweta'n ta anchique ri nintaj ren, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","¿C'o como jun ri xc'amo-pe ruway ri Jesús? xecha-ka ri discípulos chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Y ri Jesús xu'ij chique: Ri nuway ren ja ri nin-en ri nurayij ri takayon-pe wichi y ninq'uis can ru'onic ronojel ri rusamaj ri rucheleben-pe chue. ");
INSERT INTO cakNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Rix ni'ij chi c'a c'o quieji' ic' nrojo' chi nic'ol ronojel quiwech tico'n. Pero ren nin-ij chiwe: Quixtzu'n chila' y quie'itzu' la winak. Reje' je anche'l jun tico'n ri k'an chic. Quiyoben chic chi nitzijos rutzij ri Dios chique, chi niquinimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri xquiebano cosechar ri cosecha re', can c'o ruq'uiexel xtiquiwil; roma ri winak ri xtiquinimaj rutzij ri Dios, xtiquiwil quic'aslen ri man niq'uis ta. Y romari' ri je-tiquiyon can rutzij ri Dios, can xtiquicot cánima junan quiq'uin ri xquiec'olo ri cosecha re'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","We' can ketzij-wi ntel ri tzij ri nu'ij: Jun nibano ri ticoj y jun-wi chic ri nibano cosechar. ");
INSERT INTO cakNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ren xixintak chi quiri' rix xe chic nic'ol ri cosecha ri man ja' ta rix ri xixcos chi xitic. Roma rutzij ri Dios can ch'aka chic samajel je-tiquiyon can pa tak cánima ri winak, y rix xe chic juba' samaj ri ne'ibana' chi niquinimaj rutzij ri Dios, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Y chupa ri k'ij ri', can je q'uiy winak xquinimaj ri Jesús chiri' pa tenemit Sicar, ri c'o pa Samaria. Reje' xquinimaj roma ri ixok xberu'ij chique: Ri Jesús can xu'ij chue ronojel ri jenubanon-pe, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Y cuando ri winak xe'apon, xquic'utuj che ri Jesús chi tic'ue-ka quiq'uin. Y raja' xc'ue-ka ca'i' k'ij quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Y jec'o ch'aka chic winak ri aj-chiri' ri xquinimaj, c'a cuando xquic'oxaj ri tzij ri xu'ij ri Jesús. Can je q'uiy-wi ri xquinimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ri winak re' niqui'ij che ri ixok ri xberuya' rutzijol chique: Cami can keta'n chic y nakanimaj chuka', man xe ta roma ri xa'ij ret chake, xa can nakanimaj chuka' roma ri xkac'oxaj roj mismo. Xkatemaj chi can ketzij-wi chi ja raja' ri Cristo, ri nicolo quichi conojel winak ri jec'o chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Cuando xek'ax yan ri ca'i' k'ij, ri Jesús xuya' can ri tenemit Sicar ri c'o chiri' pa Samaria y xutz'om chic rubey chi nibe c'a Galilea. ");
INSERT INTO cakNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Roma ja raja' mismo x-in: Jun ri nik'alajin rutzij ri Dios pa rutenemit, man jun ruk'ij xti'an che coma ri ruwinak. ");
INSERT INTO cakNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Pero cuando ri Jesús xapon pa Galilea, ri winak aj-chiri' can utz xquic'on-ka ri Jesús; roma ri winak re' xec'ue' yan pa Jerusalem chi ri nimak'ej y xquitzu' ri milagros ri xeru'on ri Jesús chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","C'ajari' ri Jesús xbe chic jun mej (bey) pa tenemit Caná ri c'o chiri' pa Galilea, anchi' xu'on che ri ya' chi xoc ruya'al-uva. Y chiri' pa Galilea, pa jun chic tenemit rubinan Capernaum, c'o jun nimalaj achi rusamajel ri rey, ri achi re' niyawaj jun ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Y cuando raja' xuc'oxaj chi ri Jesús petenak c'a pa Judea y cami c'o pa Galilea, raja' xapon riq'uin y xberuc'utuj favor che chi tucolo' ri ralc'ual chech ri camic, roma ri ala' ri' xa ya nicom. ");
INSERT INTO cakNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ri Jesús xu'ij che ri rusamajel ri rey: Xa manak ta nitzu' ri milagros ri nin-en ren, manak ta yininimaj. Xa man ta nitzu' riq'uin ri milagros chi can ja ri Dios ri takayon-pe wichi, man ta yininimaj chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero ri achi ri rusamajel ri rey xu'ij che ri Jesús: Ajaf, tabana' favor chi jabe-ka pa tenemit Capernaum, roma ri walc'ual can ya nicom. ");
INSERT INTO cakNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Y ri Jesús xu'ij che: Catzolaj. Ri awalc'ual xtic'ase', xuche'x-e. Y ri achi ri' can xunimaj-wi ri xu'ij ri Jesús, y xbe. ");
INSERT INTO cakNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Cuando ri achi ri rusamajel ri rey xtzolaj chirij, jec'o ri je rusamajel raja' xoquic'ulu' y xqui'ij che: Ri awalc'ual q'ues. Man xcom ta, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Y raja' xuc'utuj chique ri je rusamajel anchique hora xquitzu' chi xc'achoj ri ralc'ual. Y ri rusamajel xqui'ij: Nak'ak'ij iwir a la una, cuando xq'uis-e ri c'aten chirij, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ri rutata' ri ala' xoka pa ruwi' chi ja hora ri' cuando ri Jesús xu'ij che chi ri ralc'ual man xticom ta. Y romari' raja' y ri je ru-familia xquinimaj ri Jesús, y xquiya' cánima riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Y jare' ri ruca'n milagro ri xu'on ri Jesús chiri' pa Galilea; ri nuk'alajij chi can ja-wi ri Dios takayon-pe richi. Y jare' ri milagro ri xu'on cuando petenak c'a pa Judea. ");
INSERT INTO cakNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Y cuando xbanataj yan ronojel ri', ja' noka yan jun quinimak'ej ri israelitas, y romari' ri Jesús xbe-e pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Y chiri' pa tenemit Jerusalem, chunakaj apo ri puerta ri ni'ix Quichi Ovejas che, c'o jun estanque chi atinen. Y chiri' chuchi' ri ya' jec'o wo'o' galeras. Y ri winak israelitas, Betesda yecha' che ri ya' ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiri' pa tak galeras je q'uiy yawa'i' je-cotz'ol chech-ulef. Jec'o moy, jec'o ri yejetz'ma'y yebin, y jec'o ri siquirinak quich'acul. Y jec'o ri jun-wi chic rech ri yabil ntoc chique. Y conojel ri yawa'i' ri', can quiyoben chi nisilon-pe ri ya'. ");
INSERT INTO cakNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Roma ri ya' ri' c'o jantak nosilos-ka roma jun ángel ri nika-pe chicaj riq'uin ri Dios. Y ri yawa' ri nika-ka na'ey chupa ri ya', jari' ri nic'achoj; más que xabachique (xama'anchique) yabil ntoc che. ");
INSERT INTO cakNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Y chiri' chuchi' ri ya' c'o jun achi ri can treinta y ocho juna' tiyawaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Y jun k'ij cuando ri Jesús nik'ax chiri', xutzu' ri achi cotz'ol chiri'. Y can reta'n-wi chi ri achi ri' can q'uiy yan juna' ri quiri' rubanon-pe. Y raja' xuc'utuj che ri achi ri': ¿Najo' jac'achoj? ");
INSERT INTO cakNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Y ri yawa' re' xu'ij che ri Jesús: Cuando nisilon la ya', man jun nibano favor chue chi yiruto' chi yinapon-apo c'a chupa ri ya'. Romari', más que nintaj nuk'ij chi yibe-apo, pero c'a man jani quinapon ren ja napon chic jun chinuech, xcha' che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Y ri Jesús xu'ij che ri achi: Cacataj, tac'uaj-e la ach'at y cabin, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Can xe xu'ij quiri' ri Jesús che ri yawa', can ja' xc'achoj riq'uin ri ruyabil. Xuc'ol-e ruch'at y nibin xbe. Ri k'ij ri', k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Y ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, xqui'ij che ri achi ri xc'achoj-e riq'uin ri ruyabil: Cami k'ij chi uxlanen, man utz ta chi ac'uan la ach'at, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Pero raja' xu'ij chique ri achi'a' ri': Ri xc'achojrisan wichi xu'ij: Tac'olo-e la ach'at y cabin, xcha' chue. ");
INSERT INTO cakNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Y ri achi'a' ri' xquic'utuj che ri achi: ¿Ancu'x (Anchique) x-in chawe chi tac'olo' ri ach'at y cabin? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ri achi man reta'n ta ancu'x (anchique) xc'achojrisan richi, roma ri Jesús xa man xc'ue' ta ka chiri' chiquicojol ri winak. Raja' xa xbe. ");
INSERT INTO cakNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Y c'aja' oc ri' ri Jesús xberila' ri achi pa rocho ri Dios, y xu'ij che: Cami xa can jat utz chic. Man chic ta'an amac, chi quiri' man xtipe ta chic jun ex más itzel chawij, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Y ri achi xtzolaj-e, y xapon quiq'uin ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, y xu'ij chique: Ri xc'achojrisan wichi, ja ri Jesús, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Romari' ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, can xecataj chirij ri Jesús, y niquinojij anchique niqui'en chi niquicamisaj, roma ri Jesús c'o milagros yeru'on chupa ri k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Pero ri Jesús xu'ij chique: Ri Nata' Dios c'a nisamaj ri k'ij re', y quiri' chuka' nin-en ren, yisamaj. ");
INSERT INTO cakNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Y ja' cuando ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, más xquinojij chirij chi anchique niqui'en chi niquicamisaj ri Jesús; roma chiquiwech reje', xajan (xajam) ri yeru'on chupa ri k'ij chi uxlanen. Y man xe ta romari', xa roma chuka' ri Jesús nu'ij Nata' che ri Dios. Y chiquiwech reje', can itzel chi ri Jesús nujunumaj-ri' riq'uin ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Y ri Jesús xu'ij: Can tinimaj ri nin-ij chiwe, chi ren ri Ralc'ual ri Dios can man yisamaj ta chi nin-en ri ninjo' ren; xa can nic'atzin chi ninyobej na ri nu'ij ri Nata'. Roma ja ri samaj ri nrojo' raja', jari' ri nin-en ren ri Ralc'ual. ");
INSERT INTO cakNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Y roma ri Nata' Dios yalan yirojo' ren ri Ralc'ual, romari' raja' nuc'ut chinuech ronojel ri rusamaj. Y chakawech apo c'o samaj más je nim ri xtuc'ut chinuech. Y cuando xtin-en ri samaj ri', rix can xtisatz ino'j (xtisach ic'u'x). ");
INSERT INTO cakNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Y can anche'l nu'on ri Nata' Dios cuando yeruyec-pe ri caminaki' y nuya' quic'aslen, can quiri' chuka' nin-en ren. Ren can ninya' chuka' quic'aslen ri yenjo'. ");
INSERT INTO cakNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ri Nata' Dios, can ja ren ri Ralc'ual jinruyo'n chi yenben juzgar ri winak y man ja' ta raja' xtibano. ");
INSERT INTO cakNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Chi quiri', ren niyo'x chuka' nuk'ij anche'l ri niyo'x che ri Nata'. Roma anchique winak ri man xtiyo'n ta nuk'ij ren ri jin Ralc'ual ri Dios, man nuya' ta chuka' ruk'ij ri Nata' Dios, ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Roma can ketzij-wi ri nin-ij chiwe, chi ri yec'oxan ri nutzij y niquinimaj ri takayon-pe wichi, niquiwil quic'aslen ri man xtiq'uis ta. Can man xquie'apon ta chupa ri lugar ri anchi' c'o q'uiy sufrimiento, roma can xecolotaj yan chech ri camic, y xek'ax-apo chupa ri c'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Y can ketzij nin-ij chiwe, chi c'o jun k'ij ri yoben y ja xoka yan, chi ri anche'l je caminak xtiquic'oxaj ri nutzij ren ri Ralc'ual ri Dios. Y ri can xquinquic'oxaj-wi, xtiquiwil quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Roma ri Dios ruyo'n lugar chue chi ninya' c'aslen, anche'l nu'on raja'. Ri Nata' Dios can nuya-wi c'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Y chuka' ruyo'n autoridad chue chi yenben juzgar ri winak, roma ri Nata' Dios yirucusaj chi nin-en juzgar; roma ja ren ri jin-kajinak-pe chicaj y xinalex chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Man tinojij chi xe ri xin-ij yan ka chiwe, xe ri' ri yitiquier nin-en, man quiri' ta, roma can xtapon ri k'ij chi conojel caminaki' xtiquic'oxaj ri nutzij. ");
INSERT INTO cakNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Y ri utz quic'aslen xquic'uaj chech ri Dios, xquiebec'astaj-pe y xtic'ue' quic'aslen ri man niq'uis ta. Pero ri man utz ta quic'aslen xquic'uaj chech ri Dios, xquiebec'astaj-pe chi xquiebeka chupa ri castigo. ");
INSERT INTO cakNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ren can man jun samaj xtin-en-ka nuyon; roma ren yenben juzgar ri winak, pero xe can anche'l ri ni'ix chue. Y cuando ren nin-en juzgar, can pa ruchojmil nin-en-wi; roma can man ja' ta ri ninrayij ren ri nin-en, xa can ja ri nurayij ri Nata' Dios ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Xa ta nuyon ren nink'alajij-ka-wi', utz ta chi ni'ix-ka chuij chi can man ketzij ta ri nin-ij. ");
INSERT INTO cakNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero can c'o-wi Jun ri nik'alajin wichi. Y ri nu'ij raja' chuij ren, can ketzij-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Y rix can xitak ruc'utuxic che ri Juan Bautista chirij ri Cristo, y raja' can ja-wi ri ketzij xuk'alajij-pe chiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Re' ninnataj-apo chiwe, chi quiri' jixcolotaj. Roma can c'o chic Jun ri más nim ri nik'alajin wichi, que chech ri Juan Bautista o jun chic winak. ");
INSERT INTO cakNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Y ri Juan Bautista can xuya-wi ri sakil chiwe. Can xu'on anche'l nu'on jun luz cuando nic'at y nu'on sakil. Y rix xirayij y xixquicot riq'uin ri sakil ri', jun jani' k'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Y roma ri xuk'alajij ri Juan chuij ren, can utz chi yininimaj. Pero más nic'atzin chi yininimaj, roma ri samaj ri yenben chiwech. Ja samaj re' ri can niquik'alajij chi ja ri Nata' Dios ri takayon-pe wichi. Y can ja raja' ri biyon-pe chue chi nin-en ri samaj re'. ");
INSERT INTO cakNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Y can ja ri Nata' Dios ri xtako-pe wichi ri yiruk'alajij chuka', pero rix man jun mej (bey) ic'oxan ta anchique rukul, ni man jun mej (bey) chuka' itz'eton ta rech. ");
INSERT INTO cakNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ri rutzij raja' can man ntoc ta pa tak iwánima, roma rix man yininimaj ta ren ri xitak-pe chi'icojol. ");
INSERT INTO cakNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Rix can ninic'oj utz rutzij ri Dios ri tz'iban can, roma can iweta'n chi chupa ri' niwil-wi c'aslen ri man niq'uis ta. Chupa rutzij ri Dios can ja ren ri yiruk'alajij. ");
INSERT INTO cakNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Pero más que quiri', rix man nijo' ta niya' iwánima wiq'uin, chi quiri' niwil ta ri ic'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Y ronojel ri xin-ij yan chiwe, man roma ta ninjo' chi rix niya' nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ren xa can weta'n utz iwech, romari' weta'n chi can man nijo' ta ri Dios pa iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Roma ren can pa rubi' ri Nata' Dios jin-petenak-wi y xa man yininimaj ta. Pero xa ta jec'o ri yepe pa quibi' reje' mismo, jari' can ch'anin ye'inimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Rix man nicanoj ta ik'ij riq'uin ri ketzij Dios; rix nijo' chi ja' ta ri winak yeyo'n ik'ij, romari' can man niya' ta iwánima wiq'uin ren. ");
INSERT INTO cakNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Y man tinojij pa tak iwánima chi ja ren ri xquisujun-apo iwichi chech ri Nata' Dios. Ri xtisujun iwichi chech ri Dios roma man ja' ta ri niben, ja ri Moisés; ri anchok riq'uin ni'ij-wi rix chi iyo'n iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Roma xa ta rix can ketzij ninimaj ri jerutz'iban can ri Moisés, can yininimaj ta chuka' ren, roma ri jerutz'iban can raja' can chuij-wi ren yech'o'n-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Y xa man ninimaj ta ri je-tz'iban can roma ri Moisés, manak chuka' xtinimaj ri tzij ri nuc'amon-pe ren chiwe, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Y cuando xbanataj yan ronojel ri', Jesús y ri ru-discípulos xebe ri juc'an chic ruchi-ya' Galilea; ri ni'ix chuka' Tiberias che. ");
INSERT INTO cakNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Can je q'uiy winak ri xetzekleben-e richi, roma ri winak ri' quitz'eton chic ri milagros ri yeru'on quiq'uin ri yawa'i'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ri Jesús y ri ru-discípulos xejote-e parui' jun juyu'; y raja' chiri' xch'oquie-ka chiquicojol ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ri k'ij ri', xa can noka yan ri pascua, ri jun chique ri quinimak'ej ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Y cuando ri Jesús xutzu' chi can je q'uiy winak ri ye'apon-apo riq'uin, raja' xu'ij che ri Felipe ri jun ru-discípulo: ¿Anchi' c'a xte'kac'ama-pe wey chi yekatzuk conojel ri winak re'? ");
INSERT INTO cakNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jari' ri xuc'utuj ri Jesús che ri Felipe, chi quiri' nuna'ej anchique nunojij ri jun discípulo ri'; xa noka pa ruwi' chi ri Jesús ronojel nitiquier nu'on. Pero ri Jesús xa can reta'n chic anchique nu'on chi yerutzuk ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Y ri Felipe xu'ij che ri Jesús: Más que xtakalok' doscientos denarios wey, can manak xquieru'on, más que xe juba' ta oc ri nakaya' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Y jun chique ri ru-discípulos, ri rubinan Andrés ri rach'alal ri Simón Pedro, xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","We' c'o jun ala' c'o wo'o' wey banon che cebada y ca'i' quer ruc'amon-pe, pero ¿anchique xquieru'on re'? Xe ta oc re' ri xtakaya-apo chiquiwech conojel ri winak, man yeru'on ta, xcha' ri Andrés. ");
INSERT INTO cakNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","C'ajari' ri Jesús xu'ij: Ti'ij chique ri winak chi quiech'oquie', xcha'. Y chupa ri lugar ri' can rex rubanon ri k'ayis, y conojel ri winak quimolon-qui' xech'oquie'. Jec'o jun je wo'o' mil xe ri achi'a'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ri Jesús xeruli'ej ri wo'o' wey ri' y xuya' matiox che ri Dios. Y c'ajari' xujachala' chique ri ru-discípulos, y ri discípulos xbequijachala' chique ri winak ri je-ch'ocol. Y ri Jesús quiri' chuka' xu'on riq'uin ri ca'i' quer. Ri winak can xquiwil ronojel ri wey y quer ri xquijo'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Y cuando utz chic je-waynak ri winak ri', ri Jesús xu'ij chique ri ru-discípulos: Timolo-pe ronojel wey y quer ri man xq'uis ta, roma man ninjo' ta chi quiri' niq'uis can, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ri discípulos can xbequimolo-pe y xquinojisaj cablajuj chaquech riq'uin ri man xq'uis ta rutijic. Jari' ri xmolotaj can che ri wo'o' wey banon che cebada. ");
INSERT INTO cakNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Y cuando ri winak ri' quitz'eton chic ri milagro ri xu'on ri Jesús, ri nuk'alajij chi ja ri Dios takayon-pe richi, reje' xqui'ij: Can ketzij-wi chi ja achi re' ri nik'alajin rutzij ri Dios ri q'uiy yan tiempo yoben chi can nipe chech-ulef, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ri Jesús can ruyon-wi xtzolaj parui' ri juyu', roma can xuna'ej chi ri winak niquijo' niqui'en qui-rey che, más que raja' man nrojo' ta. ");
INSERT INTO cakNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Y ri ru-discípulos ri Jesús xetzolaj-ka chuchi-ya', cuando xcok'a-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Reje' xe'oc-e pa jun canoa y xquitz'om-e bey chi xebe c'a pa tenemit Capernaum, ri c'o c'a juc'an chic ruchi-ya'. Yalan k'eku'm chic y ri Jesús xa man jani tapon quiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Y ja' xbetiquier-pe jun nimalaj quiek'ik' ri yalan ruchuk'a' parui' ri ya'; y romari' ri ya' yalan xberu'ona-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Cuando je-benak yan jun wo'o' o waki' kilómetros parui' ri ya', ri discípulos xquitzu' ri Jesús nibin parui-ya' y chunakaj chic ri canoa c'o-wi-apo, romari' reje' yalan xquixi'j-qui'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero ri Jesús xu'ij chique: Man tixi'j-iwi'. Xa ja ren ri Jesús, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Y cuando ri discípulos xquic'oxaj chi can ja-wi raja', xequicot riq'uin y xquicusaj-apo chupa ri canoa. Y can ja' xe'apon chuchi' ri ya', ri lugar ri anchi' ye'apon-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ruca'n k'ij ri winak ri xec'ue' can ri juc'an chic ruchi-ya' ri jun nak'ak'ij, c'a quimolon-qui'. Reje' can quieta'n-wi chi xe ri ru-discípulos ri Jesús ri xetzolaj chupa ri jun oc canoa ri c'o chiri'. Y ri Jesús xa xc'ue' can. ");
INSERT INTO cakNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ri k'ij ri', jec'o canoas ri je-petenak pa tenemit Tiberias y xe'apon chunakaj ri anchi' xquitaj-wi quiway ri winak ri jun k'ij can; ri wey ri xuya' ri Ajaf Jesús chique, cuando xuya' matiox che ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Y ri winak ri', roma xquitzu' chi ri Jesús xa man c'o ta chic chiri' y ri ru-discípulos xa xetzolaj yan, reje' chuka' xe'oc-e chupa ri canoas ri' y xebe pa Capernaum chucanoxic ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cuando ri winak re' xbequila' ri Jesús ri juc'an chic ruchi-ya', xqui'ij che: ¿Jampe' xatoka we'? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Pero ri Jesús xu'ij chique ri winak ri': Ketzij nin-ij chiwe, chi rix yinicanoj xe roma xixintzuk y can utz xinojisaj ipa, y man roma ta xitzu' ri milagros ri yek'alajin chi ren can ja-wi ri Dios ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Can quixsamaj, pero man richi ta nich'ec ri iway ri xa niq'uis. Xa can quixsamaj chi nich'ec ri Iway ri nuya' c'aslen chi ronojel tiempo. Y ri Wey ri' ja ren ri xquiyo'n chiwe, ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, roma ja ren xirutak-pe ri Nata' Dios, chi nin-en ri samaj re', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Y ri winak ri' xqui'ij che ri Jesús: ¿Anchique ri nika chech ri Dios chi naka'an? ");
INSERT INTO cakNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Y ri Jesús xu'ij chique: Ri nika chech ri Dios chi rix niben, ja ri quininimaj ren ri xitak-pe roma raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Y ri winak xqui'ij che ri Jesús: ¿Anchique ri jatiquier na'an? Tabana' c'a jun milagro, chi quiri' nakatzu' y jatkanimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Roma cuando ri ojer tak kati't-kamama' xec'ue' chupa ri tz'iran rech-ulef, ja ri wey xubinaj maná ri xuya' ri Moisés chique chi xquitaj. Can anche'l-wi ri nu'ij rutzij ri Dios ri tz'iban can: Wey ri petenak chicaj ri xuya' chique chi xquitaj. ¿Y xcatiquier cami ret na'an anche'l xu'on ri Moisés? ");
INSERT INTO cakNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Y ri Jesús xu'ij chique: Tic'oxaj utz ri xtin-ij chiwe: Ri wey ri xpe chila' chicaj, man ja' ta ri Moisés ri xyo'n. Ja ri Nata' Dios ri xyo'n chique y cami ja nuya' ri ketzij Wey chiwe ri petenak chila' chicaj. ");
INSERT INTO cakNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Roma ri Wey ri can richi ri Dios, ja ri Jun ri petenak chicaj. Y jari' ri c'amayon-pe c'aslen chique ri winak, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Cuando xquic'oxaj quiri' ri winak, xqui'ij che ri Jesús: Can siempre taya' ri Wey ri' chake, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Y ri Jesús xu'ij chique: Ja ren ri Wey ri niyo'n c'aslen. Ri nipe wiq'uin, man xtinum ta chic ri ránima; roma ja ren ri xquinoc Ruway chi quiri' manak chic xtinum ránima. Y chuka' ri xtuya' ránima wiq'uin, man xtichake'j ta chic ruchi' ri ránima; roma ja ren ri xquinoc Ruya' chi quiri' manak chic xtichake'j ruchi' ránima. ");
INSERT INTO cakNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero can anche'l ri nu'in chiwe, más que rix can xitzu' y xic'oxaj ri samaj xin-en iwiq'uin, man xquininimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel ri xquiepe chinucanoxic, ren can xtinc'ul quiwech y man jun mej (bey) xquienxutuj-e. Roma jari' ri jeruyo'n ri Nata' Dios chue. ");
INSERT INTO cakNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Roma ren ri xika-pe chila' chicaj, man ja' ta ri ninjo' ren nonbana-ka. Ren xika-pe chila' chicaj chi nonbana-ka ri nrojo' ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ri Nata' Dios ri takayon-pe wichi, nrojo' chi conojel ri jeruyo'n chue, can man jun chique reje' nisatz (nisach), y pa ruq'uisbel k'ij yenc'asoj-e chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ri nrojo' chuka' ri Nata' ri takayon-pe wichi, ja chi conojel ri yetz'eto ri nusamaj y niquiya' cánima wiq'uin, xtic'ue' quic'aslen chi ronojel tiempo, y yenc'asoj-e chiquicojol ri caminaki' ri pa ruq'uisbel k'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Pero ri winak israelitas ri' xejasloj chirij ri Jesús, roma raja' xu'ij: Ja ren ri Wey ri kajinak-pe chicaj. ");
INSERT INTO cakNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Y niqui'ij: ¿Man ja' ta re' ri Jesús ri ralc'ual ri José c'a? Xa keta'n quiwech ri rute-rutata'. Y chake roj nu'ij-wi chi raja' kajinak-pe chicaj riq'uin ri Dios, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero ri Jesús xu'ij chique: Man quixtzijon-pe chuij ren. ");
INSERT INTO cakNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Roma ri xquieniman wichi, can ja ri Nata' Dios ri takayon-pe wichi xsamaj yan pa tak cánima. Y ren can xquienc'asoj chiquicojol ri caminaki' pa ruq'uisbel k'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ri achi'a' ri xek'alajin ri rutzij ri Dios ojer can, xquitz'ibaj: Conojel, can c'o ri xtic'ut chiquiwech roma ri Dios. Quiri' ri tz'iban can. Y ri yec'oxan ri nu'ij ri Nata' Dios y niquitemaj, can xquiepe chinucanoxic. ");
INSERT INTO cakNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Pero ren man nin-ij ta chi c'o ta jun winak ri tz'eteyon richi ri Dios, man quiri' ta. Xe ren ri jin-petenak chicaj riq'uin raja' ri jin-tz'eteyon rech ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tic'oxaj na pe' utz ri xtin-ij chiwe: Ri niniman wichi, can c'o ruc'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ri Wey ri can niyo'n-wi c'aslen, ja ren. ");
INSERT INTO cakNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ri wey ri ni'ix maná che, ri xquitaj ri ojer iwati't-imama' pa tz'iran rech-ulef, man xtiquier ta xuya' quic'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero ri ketzij Wey ri kajinak-pe chicaj, can nitiquier nu'on chique ri yetijo richi chi can manak xquiecom chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja ren ri Wey ri can c'o ruc'aslen, ri xka-pe chicaj. Ri xquietijo ri Wey re', xquiec'ase' chi ronojel tiempo. Ri Wey ri xtinya' ren chique, can ja ri nuch'acul ri xtapon pa camic chi nuc'om-pe c'aslen chique ri winak ri jec'o chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Y cuando ri winak israelitas re' xquic'oxaj ri xu'ij ri Jesús, xquic'utuj-ka chiquiwech: ¿Anchique modo ri' chi raja' nuya' ri ruch'acul chake chi nakataj? yecha'. Y can xquitz'om-ka-qui' roma man junan ta niquinojij. ");
INSERT INTO cakNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Y ri Jesús xu'ij chique: Can ketzij-wi nin-ij chiwe, xa man nitaj ta ri nuch'acul y man nikum ta chuka' ri nuquiq'uiel ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, manak xtic'ue' ic'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ri can xtiquitaj ri nuch'acul y xtiquikum chuka' ri nuquiq'uiel, can c'o-wi ri quic'aslen chi jumul. Y ren can xtin-en chique chi yec'astaj-e chiquicojol ri caminaki' pa ruq'uisbel k'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Roma ri nuch'acul ren jari' ri ketzij Wey y ri nuquiq'uiel jari' ri ketzij Ya'; ri can niquiya' c'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ri can niquitaj ri nuch'acul y niquikum chuka' ri nuquiq'uiel, xe jun xtaka'an quiq'uin. Reje' xquiec'ue' wiq'uin ren y ren quiq'uin reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Roma can ja ri Nata' ri takayon-pe wichi y raja' can c'o-wi ri c'aslen riq'uin, ren chuka' c'o ri c'aslen ri' wiq'uin. Y quiri' chuka' ri xquiruc'on-ka ren, can xtic'ase-wi woma ren. ");
INSERT INTO cakNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ri can ketzij Wey, ri kajinak-pe chicaj, can man junan ta riq'uin ri wey ri ni'ix maná che ri xquitaj ri ojer iwati't-imama', roma ri wey ri xquitaj reje' man xtiquier ta xu'on chique chi xc'ue' ta quic'aslen chi ronojel tiempo. Pero ri niquitaj ri ketzij Wey ri kajinak-pe chicaj, xtic'ue' quic'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jare' ri xu'ij ri Jesús chique ri winak israelitas ri quimolon-qui' chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios, chiri' pa tenemit Capernaum. ");
INSERT INTO cakNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Y cuando ri je-tzeklebeyon ri Jesús xquic'oxaj ri xu'ij, je q'uiy chique reje' xqui'ij: Yalan cuesta ri xu'ij. Man k'alaj ta xa jec'o ri xquieniman. ");
INSERT INTO cakNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Y roma ri Jesús xutzu' ri niquinojij pa tak cánima ri je-tzeklebeyon richi, xu'ij chique: ¿Anchique roma rix man xka ta chiwech ri xin-ij? ");
INSERT INTO cakNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Y anchique xti'ij xa ta yinitzu' ren ri jin-kajinak-pe chicaj y xinalex chi'icojol chi yitzolaj-e chila' riq'uin ri Dios ri anchi' jin-petenak-wi? ");
INSERT INTO cakNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ja ri espíritu niyo'n ruc'aslen ri ich'acul, ri ich'acul xa can manak rakalen. Y ri Espíritu ri niyo'n ri ketzij ic'aslen, ja ri tzij ri jenu'in chic chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero je q'uiy chiwe ri man niquijo' ta jinquinimaj, xcha' ri Jesús. Raja' quiri' xu'ij roma can reta'n-wi-pe anchique winak ri man xtiquinimaj ta, y ri ancu'x (anchique) xtic'ayin-e richi. ");
INSERT INTO cakNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Y ri Jesús xu'ij: Jec'o chiwe rix ri man niquijo' ta jinquinimaj, romari' ren nu'in chiwe chi ja ri winak ri je-cha'on roma ri Nata' Dios, jari' ri xquiepe wiq'uin chi jinquicanoj, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Roma quiri' xu'ij ri Jesús, je q'uiy chique ri can je-tzeklebeyon-wi, manak chic xquitzeklebej. Xa xetzolaj can chiquij. ");
INSERT INTO cakNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Y ri Jesús xu'ij chique ri cablajuj discípulos: ¿Rix chuka' nijo' jixbe? ");
INSERT INTO cakNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Y ri Simón Pedro xu'ij che ri Jesús: Ajaf, man jun chic anche'l ret, chi quiri' nakatzeklebej ta; roma ri atzij ret can nuya' c'aslen ri man niq'uis ta. ");
INSERT INTO cakNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Roj can kayo'n kánima awiq'uin y keta'n chi ja ret ri Cristo, ri Ralc'ual ri c'aslic Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Y ri Jesús xu'ij: Ja ren ri xicha'on iwichi rix ri cablajuj, pero jun chiwe rix oconak rusamajel ri itzel. ");
INSERT INTO cakNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Cuando ri Jesús xu'ij quiri', chirij ri Judas Iscariote xch'o'n-wi; ri Judas ri ralc'ual ri jun achi ri ni'ix Simón che. Ri Jesús xunataj ri', roma jari' ri xtic'ayin richi ri Jesús. Y raja' can jun chique ri cablajuj discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cuando xebanataj yan ronojel re', ri Jesús xbe pa tak tenemit ri jec'o pa Galilea. Man xrojo' ta chic xutzijoj rutzij ri Dios pa Judea, roma ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas niquicanola' anchique niqui'en chi niquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ri k'ij ri', xa can noka yan ri quinimak'ej ri israelitas chi niquinataj ri tiempo ri xquik'axaj ri cati't-quimama' chupa ri tz'iran rech-ulef. Y chi niquinataj ri', reje' yec'ue' chupa cocoj tak jay ri ye'an che ruk'a' tak che'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Y ri je rach'alal ri Jesús xqui'ij che raja': Taya' can juba' ri Galilea chi jabe pa Judea, chi quiri' ri winak ri can yetzekleben awichi ri jec'o chila', tiquitzu' ri milagros ri ye'aben. ");
INSERT INTO cakNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Roma jun ri nrojo' nuk'alajij-ri' chiquiwech ri winak, man utz ta nrewaj-ri'. Can nic'atzin chi nuc'ut-ri' chi can c'o-wi ri nitiquier nu'on, xecha' ri rach'alal che. ");
INSERT INTO cakNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Más que ri Jesús can cach'alal-wi, reje' can man niquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Y ri Jesús xu'ij chique ri rach'alal: Rix xabachique (xama'anchique) k'ij utz jixapon chupa ri nimak'ej. Pero ren manak modo yinapon yan. ");
INSERT INTO cakNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Rix man itzel ta jixtz'et coma ri winak ri man quiniman ta ri Dios. Pero ren can itzel-wi yitz'et, roma ren can nink'alajij ri itzel tak no'j (na'oj) ri yequi'en. ");
INSERT INTO cakNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Rix c'o modo jixbe; ren c'a man jani quibe-e chupa ri nimak'ej ri'. Ri hora chi nink'alajij-wi', c'a man jani toka, xcha' ri Jesús chique. ");
INSERT INTO cakNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Y cuando ri Jesús ru'in chic ronojel ri' chique ri rach'alal, raja' xc'ue' can chiri' pa Galilea. ");
INSERT INTO cakNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Y cuando je-benak chic ri rach'alal chupa ri nimak'ej ri', c'ajari' xbe raja'. Anche'l xa pa alak'al xbe, roma man xtz'etetaj ta e. ");
INSERT INTO cakNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Y chupa ri nimak'ej ri', ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, ri itzel niquitzu' ri Jesús, yexule-yejote' niquicanoj y niquic'utuj: ¿Man itz'eton ta ri jun achi ri'? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Y chiquicojol ri winak chupa ri nimak'ej ri', q'uiy anchique niqui'ij chirij ri Jesús. Jec'o ye'in chi ri Jesús jun utzilaj achi. Jec'o ye'in chi ri Jesús man utz ta, roma yeru'on engañar ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero man jun chique ri winak ri ye'in quiri' nrojo' nuk'alajij-ri', roma niquixi'j-qui' chiquiwech ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas. ");
INSERT INTO cakNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Y cuando xnic'ajer yan ri nimak'ej ri', ri Jesús xapon pa rocho ri Dios. Raja' can nuc'ut ri rutzij ri Dios chiquiwech ri winak ri quimolon-qui' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas niqui'ij chirij ri Jesús: ¿Anchique roma ri achi re' can q'uiy reta'n chirij ri rutzij ri Dios y xa man jun mej (bey) xkatzu' chi c'o ta anchi' xberutemaj-wi-pe? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Pero ri Jesús xu'ij: Ri ninc'ut ren, ja ri tzij ri bin-pe chue roma ri takayon-pe wichi. Re' can man wichi ta ren. ");
INSERT INTO cakNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Y ri winak ri can niquirayij niqui'en ri nrojo' ri Dios, can xtiquina'ej xa ri ninc'ut ren can riq'uin ri Dios petenak-wi o xa nuyon nutz'ucun-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jun winak ri ruyon raja' nuk'alajij-ri', can nrojo' chi can niyo'x ruk'ij coma ri winak. Pero ren ninjo' chi rix can niya' ruk'ij ri Dios ri takayon-pe wichi. Y romari' nik'alajin chi ren can ja ri ketzij nin-en y man jun mej (bey) nin-en ri man utz ta. ");
INSERT INTO cakNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Rix can nicanoj anchique niben chi yinicamisaj. Xa can man niben ta ri anchique nu'ij ru-ley ri Moisés, y ri ley re' xa can pa ik'a' c'o-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Y ri winak xqui'ij: La' jat ch'u'j. ¿Ancu'x (Anchique) nrojo' nicamisan awichi? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Pero ri Jesús xu'ij chique: Rix can xsatz ino'j (xsach ic'u'x) cuando xitzu' chi ren pa jun k'ij chi uxlanen xinc'achojrisaj ri jun achi. ");
INSERT INTO cakNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero chupa ru-ley ri Moisés nu'ij chi ti'an ri circuncisión che ri ala'. Ri circuncisión man ja' ta ri Moisés ri xtz'ucu-pe, xa ja ri ojer kati't-kamama' ri xetz'ucu-pe. Y romari' rix cami, cuando nitzakon wakxaki' k'ij chi talex jun ne'y ala', más que pa jun k'ij chi uxlanen, can niben-wi ri circuncisión che. ");
INSERT INTO cakNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Rix nijo' niben ri nu'ij ri ley ri ruyo'n can ri Moisés, y romari' más que pa jun k'ij chi uxlanen rix can niben-wi ri circuncisión. ¿Y anchique roma xpe iwoyowal chue ren roma xinc'achojrisaj jun achi chupa jun k'ij chi uxlanen? ");
INSERT INTO cakNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Man ti'ij que man utz ta ri xin-en, xe roma quiri' ninojij rix. Rix can titzu' utz ri xin-en, c'ajari' ti'ij xa utz o man utz ta, chi quiri' man jixsatz (jixsach) ta, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Y jec'o chique ri winak aj-chiri' pa tenemit Jerusalem ri niqui'ij: ¿Man ja' ta como re' ri Jesús ri nicanox chi nicamises? ");
INSERT INTO cakNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xa man rewan ta ri'. ¡Titzu'! Ja' nich'o'n chiquiwech la winak y man jun anchique ni'ix che. ¿O xa xquinimaj yan ri achi'a' ri can c'o-wi quik'ij chikacojol chi can ja-wi raja' ri Cristo ri takon-pe roma ri Dios? ");
INSERT INTO cakNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero can k'alaj chi xa man ja' ta raja', roma xa can keta'n anchi' tipe-wi. Y cuando xtoka ri ketzij Cristo, man jun xtina'en anchi' xtipe-wi, yecha' ri winak aj-Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Y ri Jesús nich'o'n chiquiwech ri winak ri chiri' pa rocho ri Dios. Y cuando xuc'oxaj ri niqui'ij, riq'uin ruchuk'a' xch'o'n y xu'ij: Rix can iweta'n-wi nuech y iweta'n chuka' anchi' quipe-wi. Pero ri takayon-pe wichi man iweta'n ta rech, y raja' can ketzij. Man nuyon ta ren xin-en chi xipe chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ren can weta'n-wi rech ri man iweta'n ta rech rix, roma can riq'uin raja' jin-petenak-wi; y can ja' chuka' raja' ri takayon-pe wichi, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Y jec'o ri c'o ta xquijo' xquitz'om ri Jesús, pero man xquitz'om ta roma ri ru-hora man jani tapon. ");
INSERT INTO cakNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Je q'uiy chique ri winak ri xquinimaj ri Jesús chupa ri k'ij ri'. Ri winak ri' niqui'ij chi ja raja' ri Cristo ri takon-pe roma ri Dios, roma ri milagros man jun chic nibano. Xa can xe-wi ri Cristo ri nitiquier nu'on quiere', xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Y ri achi'a' fariseos xquic'oxaj chi quiri' ri yequi'ij ri winak chirij ri Jesús. Romari' ri achi'a' fariseos ri' y ri nimalaj tak sacerdotes, xequitak-e achi'a' ri yechajin ri rocho ri Dios chi niquitz'om-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","C'ajari' ri Jesús xu'ij: C'a c'o na juba' tiempo ri yic'ue' iwiq'uin. C'ajari' xquitzolaj riq'uin ri Jun ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Rix xquinicanoj, y man xquiniwil ta chic; roma ri lugar anchi' xquibec'ue-wi ren, man xquixtiquier ta xquixapon chinucanoxic, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Y ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, niqui'ij chiquiwech: ¿Anchi' como xtibe-wi ri Jesús? Roma nu'ij chi chiri' man xtakawil ta. ¿Nibe como pa ch'aka chic rech-ulef chi nerutzijoj ri rutzij chique ri ch'aka chic israelitas y chique ri man je israelitas ta? ");
INSERT INTO cakNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Can man keta'n ta anchi' xtibe-wi, roma man keta'n ta anchique ntel-wi chi tzij ri xu'ij: Xquinicanoj y man xquiniwil ta. Ri lugar ri anchi' xquibec'ue-wi ren, rix man xquixtiquier ta xquixapon, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Chupa ri ruq'uisbel y nimalaj k'ij chi ri jun nimak'ej ri', ri Jesús xpa'e' y riq'uin ruchuk'a' xu'ij: Xa c'o jun ri nichake'j ruchi' ri ránima, tipe wiq'uin ren, chi nich'uch'u-e ránima riq'uin ri Ya' ri xtinya-e ren che. ");
INSERT INTO cakNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ri can xtipe wiq'uin ren chi yirunimaj, can xtic'ue' ri Ya' richi c'aslen pa ránima, y ri Ya' ri' can anche'l nu'on ri ya' anchi' nalex-wi, quiri' xtu'on pa ruc'aslen. Quiri' ri nu'ij chupa ri rutzij ri Dios ri tz'iban can, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ri Ya' ri xunataj ri Jesús, ja ri Espíritu Santo; roma can jari' ri xtiyo'x chique ri winak ri yeniman richi ri Jesús. Y ri k'ij ri' c'a man jani tika-pe ri Espíritu Santo, roma c'a man jani chuka' titzolaj-e ri Jesús chicaj anchi' c'o-wi ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Y jec'o chique ri winak, cuando xquic'oxaj ri tzij ri xeru'ij ri Jesús, xqui'ij: Can ketzij-wi chi ri Jesús jare' ri Jun ri nuk'alajij rutzij ri Dios ri q'uiy yan tiempo yoben-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Y jec'o chuka' niqui'ij: Ja ri Jesús jari' ri Cristo ri takon-pe roma ri Dios. Pero ch'aka chic niqui'ij: Ri Cristo man pa Galilea ta nipe-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Roma ri rutzij ri Dios ri tz'iban can, nu'ij chi ri Cristo ru-familia can ri rey David. Y chiri' pa Belén ri tenemit anchi' xalex-wi ri David, chiri' nipe-wi ri Cristo, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Can man junan ta niquinojij chirij ri Cristo; roma jun-wi nu'ij jun, y jun-wi chic nu'ij jun. ");
INSERT INTO cakNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Y jec'o ch'aka chic chique ri winak, can xquijo' xquitz'om ta e ri Jesús, pero xa man xqui'en ta quiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Cuando ri achi'a' ri yechajin ri rocho ri Dios, ri je-takon-e coma ri nimalaj tak sacerdotes y coma ri achi'a' fariseos, xetzolaj-pe; x-ix chique: ¿Anchique roma man xitz'om ta pe ri Jesús? xe'uche'x. ");
INSERT INTO cakNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Pero ri achi'a' xqui'ij: Roj man xkatz'om ta pe, roma ri tzij ri yeru'ij man jun chic achi ni'in. Can utz-wi ri yeru'ij, xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","C'ajari' ri achi'a' fariseos xqui'ij chique ri achi'a' chajinel: ¿Rix chuka' xix-an engañar? ");
INSERT INTO cakNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Man jun chique ri autoridades ni man jun chique ri fariseos quiniman ri nu'ij ri Jesús. ¿O ni'ij rix chi c'o? ");
INSERT INTO cakNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Xa ja ri winak ri man quieta'n ta ru-ley ri Moisés, xa jari' ri niquinimaj ri Jesús. Can xtika-wi ri castigo pa quiwi' ri winak re'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Pero ri Nicodemo, jun chique ri achi'a' fariseos, ri xapon chak'a' riq'uin ri Jesús, xu'ij chique ri ch'aka chic achi'a': ");
INSERT INTO cakNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","¿Utz como chech ri ka-ley chi ni'ix chi jun achi c'o rumac, y xa man jun etamayon, ni man jun ac'axayon xa ketzij chi c'o mac rubanon o manak? ");
INSERT INTO cakNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Y reje' xqui'ij che ri Nicodemo: Ret ni man jat aj-Galilea ta, chi quiri' nato' ri Jesús. Tanic'oj utz ri rutzij ri Dios ri tz'iban can. Chiri' can k'alaj-wi chi pa Galilea man nipe ta jun achi ri nik'alajin ri ni'ix che roma ri Dios, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ri achi'a' ri quimolon-qui', xquiquiraj-e-qui' y xebe chi tak cocho, ");
INSERT INTO cakNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","y ri Jesús xbe-e parui' ri juyu' rubinan Olivos. ");
INSERT INTO cakNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Y cuando xsakar-pe, raja' xapon chic pa rocho ri Dios. Ri winak xe'apon riq'uin. Y raja' ch'ocol nutzijoj rutzij ri Dios chique ri winak ri quimolon-apo-qui' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Y ri achi'a' fariseos y ri maestros chi ri ley xe'apon riq'uin ri Jesús; quic'uan-apo jun ixok ri nu'on mac riq'uin jun achi ri xbe'litaj-pe. Xbequipoba' chech ri Jesús, pa quinic'ajal ri jec'o chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ri fariseos y ri maestros chi ri ley xqui'ij che ri Jesús: Maestro, xecha' reje'. Ri jun ixok re' kac'amon-pe chawech roma nu'on rumac riq'uin jun achi ri xbe'litaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Y chupa ri ley ri ruyo'n can ri Moisés, nu'ij chi ri yebano quiere' quiecamises che abaj. ¿Anchique na'ij ret chake? ¿Utz nakacamisaj ri jun ixok re' che abaj o man utz ta? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ri achi'a' ri' quiri' xqui'ij xe chi niquitojtobej ri Jesús; chi quiri' yetiquier niquisujuj. Pero ri Jesús xa xluquie-ka, y xtz'iban-ka chech-ulef che rui-ruk'a'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Y roma ri achi'a' ri' man yetane' ta juba' niquic'utuj-apo che ri Jesús xa nicamises ri ixok o manak, romari' raja' xpa'e' y xu'ij chique: Xa c'o jun chiwe rix ri man jun rumac rubanon, tuq'uiaka-pe ri na'ey abaj chirij ri ixok re', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Y xluquie-ka y xtz'iban chic ka che ri rui-ruk'a' chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Y cuando ri achi'a' ri niquisujuj ri ixok xquic'oxaj ri xu'ij ri Jesús, xquina-ka-qui' chi reje' chuka' c'o quimac, romari' chijujun-chijujun xebe; na'ey xebe ri más c'o quijuna', y c'ajari' xebe ri ch'aka chic. Can xe chic ri ixok xpa'e' can chiri' chech ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Y cuando ri Jesús xpa'e' chic pe, xutzu' chi xe chic ri ixok pa'l can chiri'. Y raja' xuc'utuj che: ¿Y ri winak ri je-c'amayon-pe awichi? ¿Man jun xc'ue' can chi jatrucamisaj? xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Y ri ixok xu'ij: Ajaf, man jun chic. Y ri Jesús xu'ij che: Ren chuka' man jun anchique nin-ij chawe chi jacamises. Cami jat (cabin) y man ta'an chic amac. ");
INSERT INTO cakNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Cuando ri Jesús xch'o'n chic apo chiquiwech ri winak, xu'ij: Ja ren ri yiyo'n sakil che ronojel ri rech-ulef. Ri nitzekleben wichi, can xtinsakrisaj ri ruc'aslen y xtiril ruc'aslen wiq'uin. Y raja' man chic xtibin ta pa k'eku'm. ");
INSERT INTO cakNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","C'ajari' ri achi'a' fariseos ri jec'o chiri', xqui'ij-apo che ri Jesús: Roj man nakanimaj ta chi ketzij ri na'ij chawij, roma xa ayon ret ja'in-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ri Jesús xu'ij chique ri achi'a' fariseos: Más que ja ren ri nink'alajij-ka-wi', can ketzij-wi ri nink'alajij-ka chuij. Roma chinuech ren k'alaj ri anchi' jin-petenak-wi, y can chiri' chuka' xquitzolaj-wi. Rix man iweta'n ta anchi' quipe-wi, ni man iweta'n ta chuka' anchi' xquibe-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Rix can niben juzgar riq'uin ri no'j (na'oj) chi ri rech-ulef. Pero ren man quiri' ta nin-en. ");
INSERT INTO cakNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Y xa ren nin-en juzgar, can pa ruchojmil nin-en-wi; roma can man nuyon ta jinc'o, roma can junan naka'an juzgar riq'uin ri Nata' ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupa ri ley ri can iwichi rix, nu'ij chi cuando jec'o je ca'i' ri can junan ri niqui'ij, can k'alaj chi ketzij ri niqui'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Y ren y ri Nata' ri takayon-pe wichi, junan ri naka'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ri achi'a' fariseos xqui'ij che ri Jesús: ¿Anchi' c'o-wi ri Atata'? xecha' che. Y raja' xu'ij: Rix man iweta'n ta rech ri Nata', roma man iweta'n ta nuech ren. Xa ta iweta'n nuech ren, can iweta'n ta chuka' rech ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Y ja tzij re' ri xeru'ij ri Jesús chique ri winak ri quimolon-qui' ri anchi' niyo'x-wi can mero coma ri winak chiri' pa rocho ri Dios. Pero más que quiri' xu'ij, man jun xpe chi xutz'om ta, roma ri ru-hora man jani tapon. ");
INSERT INTO cakNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Y jun mej (bey) chic, ri Jesús xu'ij chique: Ren can xquitzolaj chic e, y rix xquinicanoj, pero man xquiniwil ta. Xa can chupa ri imac xquixcom-wi. Y ri anchi' yibe-wi ren, rix man jixtiquier ta jixapon, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Y ja cuando ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, xqui'ij-ka chiquiwech: ¿Xtucamisaj como ri' ri Jesús? Roma xu'ij: Ri anchi' xquibe-wi ren, rix man jixtiquier ta jixapon, xcha', yecha' ri achi'a' ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Pero ri Jesús xu'ij chique: Rix can jix aj-wowe'l y ren jin aj-chila' chicaj. Rix can jix richi-wi ri rech-ulef y ren man jin richi ta ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Y romari' xin-ij chiwe chi chupa ri imac xquixcom-wi. Y xa man ninimaj ta jin ancu'x (anchique) ren, can xquixcom-wi chupa ri imac, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","C'ajari' ri achi'a' ri' xqui'ij chic che ri Jesús: ¿Y jat ancu'x (anchique) ret c'a? Y ri Jesús xu'ij chique: Ren, desde que nutz'amon-pe tzij iwiq'uin, can nu'in-pe chiwe jin ancu'x (anchique) ren. ");
INSERT INTO cakNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ren can q'uiy ex ri nic'atzin nin-ij chiwij, roma ronojel ri niben, can itzel. Pero ri nin-ij chiwe rix y chique conojel ri winak ri jec'o chech-ulef, xe ri nuc'oxan-pe riq'uin ri takayon-pe wichi, jari' ri nin-ij, y raja' can ketzij-wi, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero reje' man xqui'en ta entender chi ri Jesús xa chirij ri Rutata' xch'o'n-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ri Jesús xu'ij chic: Ri k'ij cuando xquinijotoba' chech ri cruz, ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, c'ajari' xtina'ej jin ancu'x (anchique) ren. Y xtina'ej chuka' chi ronojel ri nin-en ren, xa man nuyon ta nin-en, xa can anche'l ri ru'in-pe ri Nata' chue ren, can quiri' chuka' nin-ij ren chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ri Nata' ri takayon-pe wichi, can c'o wiq'uin. Man yiruya' ta can nuyon, roma ren can nin-en-wi ri nika chech raja', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Y roma ri tzij ri xeru'ij ri Jesús chiquiwech ri winak, je q'uiy ri xeniman richi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","C'ajari' ri Jesús xu'ij chique ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas ri xeniman richi: Xa rix can utz nic'uaj ri nutzij pa iwánima, can xquixoc ketzij nu-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Xtitemaj chuka' anchique ri ketzij, y ri ketzij xtu'on libre chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Y ri winak ri' xqui'ij: Roj can joj ru-familia can ri Abraham, y romari' man xojc'ue' ta chuxe' quitzij ch'aka chic chi xojoc esclavos. ¿Anchique roma na'ij chake chi xkojel libres? ");
INSERT INTO cakNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Pero ri Jesús xu'ij chique: Tic'oxaj na pe' utz ri xtin-ij chiwe cami: Conojel winak ri niqui'en mac, can k'alaj chi chuxe' ri mac jec'o-wi y jari' ri uc'uayon quichi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Y xa jun winak chuxe' ri mac c'o-wi, man xtic'ue' ta riq'uin ri Dios. Pero ri jun ri can ralc'ual ri Dios, can xtic'ue-wi riq'uin chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Romari', xa ren ri jin Ralc'ual ri Dios nin-en chiwe chi jix libre, can ketzij-wi jix libre chic. ");
INSERT INTO cakNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Can ketzij ri ni'ij, chi rix jix ru-familia can ri Abraham, can quiri-wi, pero roma ronojel ri ye'iben man nuc'ut ta chi quiri'; roma rix xa nicanola' anchique niben chi yinicamisaj. Re' nuc'ut chi rix man iyo'n ta lugar che ri nutzij chi oconak ta pa iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ronojel ri nintzijoj ren, can ja ri Nata' c'utuyun-pe chinuech. Quiri' chuka' rix, ronojel ri niben, can riq'uin ri itata' ic'oxan-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Y reje' xqui'ij che ri Jesús: Ja ri Abraham ri katata' roj, xecha'. Y ri Jesús xu'ij chique: Xa ta jix ru-familia can ri Abraham, k'alaj ta, roma can utz ta ri ye'iben, anche'l xu'on raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ren can nutzijon chiwe ri ketzij ri nuc'oxan-pe riq'uin ri Nata' Dios; y más que quiri' nubanon-pe, rix can nicanoj anchique niben chi yinicamisaj. Ri Abraham man jun mej (bey) xu'on ta anche'l ri niben rix cami, y rix ni'ij chi jix ru-familia can raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Rix xa ja ri nu'on ri itata', xa jari' ri niben, xcha' ri Jesús chique. Y reje' xqui'ij che: Roj can keta'n rech ri katata'. Y chuka' xe Jun ri Katata', y ri' ja ri Dios, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","C'ajari' ri Jesús xu'ij chique ri winak ri': Xa ta ja ri Dios ri Itata', k'alaj ta, roma can yinijo' ta; roma ren can riq'uin ri Dios jin-petenak-wi. Can ja raja-wi ri takayon-pe wichi y man nuyon ta ren xipe chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Anchique roma rix man nijo' ta niben entender ri nin-ij chiwe? Roma man nijo' ta nic'oxaj ri nutzij. ");
INSERT INTO cakNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri itata' rix ja ri Satanás y can jix richi raja'; y ja ri nika chech raja', jari' ri nijo' niben. Ri Satanás can pa ruticribel pe nicamisan. Man xc'ue' ta chic chupa ri ketzij, roma xa can man jun ketzij ri c'o riq'uin. Xa can jun tz'ucuy-tzij. Can quitata' conojel ri je tz'ucuy tak tzij. ");
INSERT INTO cakNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Y ri nutzij ren man nijo' ta ninimaj, roma ja ri ketzij ri nin-ij chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿C'o como jun ri ni'in-pe chue anchique mac jenubanon? Y xa can k'alaj chi can man jun mac pa nuc'aslen y xe ketzij ri nin-ij, ¿anchique roma man yininimaj ta? ");
INSERT INTO cakNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Roma ri can je richi ri Dios, can ja ri nu'ij ri rutzij ri Dios, jari' ri niqui'en. Pero rix man quiri' ta niben, roma man jix richi ta ri Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Y ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, xqui'ij che ri Jesús: Can ketzij-wi ri ka'in chawij, chi ret xa jat jun winak ri jat aj-Samaria y c'o itzel espíritu awiq'uin, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Pero ri Jesús xu'ij chique ri achi'a' ri': Ren man jun itzel espíritu ri c'o wiq'uin. Ren can ja ri Nata' ri ninya' ruk'ij, y rix xa man quiri' ta chiwech. Rix xa niben chue chi jin itzel. ");
INSERT INTO cakNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ren man nincanoj ta chi rix niya' ta nuk'ij, pero can c'o Jun ri nrojo' chi conojel ta winak niquiya' nuk'ij. Y ja raja' chuka' ri xquieru'on juzgar ri man xtiqui'en ta quiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Can tic'oxaj na pe' utz ri xtin-ij chiwe: Ri winak ri can nunimaj-wi ri nutzij, manak xticom chi ronojel tiempo, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Y ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas xqui'ij che ri Jesús: Cami can keta'n chic chi can ketzij c'o itzel espíritu awiq'uin; roma na'ij chi anchique ri yeniman ri atzij, man xquiecom ta. Tatzu' na pe', ri katata' Abraham y ri xek'alajin ri rutzij ri Dios ojer can, xecom. ");
INSERT INTO cakNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿O c'o más ak'ij ret chech ri katata' Abraham? Raja' xcom; quiri' chuka' ri xek'alajin ri rutzij ri Dios ojer can, xecom. ¿Jat ancu'x (anchique) ret? Roma na'ij chi ri yeniman ri atzij man xquiecom ta. ");
INSERT INTO cakNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Y ri Jesús xu'ij: Xa nuyon ren ninya-ka nuk'ij, man jun nic'atzin-wi. Pero ri nuk'ij ren, can ja ri Nata' niyo'n. Ri Nata' jari' ri ni'ij i-Dios che. ");
INSERT INTO cakNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Y más que rix quiri' ni'ij che, man iweta'n ta rech. Pero ren can weta'n-wi rech. Y ren yinoc ta jun tz'ucuy-tzij anche'l rix, xa ta nin-ij chi ren man weta'n ta rech ri Dios, y xa can weta'n. Ren can nin-en-wi ri nu'ij ri rutzij raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham can xquicot ránima, roma can reta'n-wi chi can xtutzu-wi ri tiempo cuando ren xquipe chech-ulef. Y raja' can xutzu-wi, y xquicot ránima romari', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ja' cuando ri achi'a' ri c'o quik'ij chiquicojol ri israelitas xqui'ij che ri Jesús: Ret ni man jani cincuenta ajuna' y na'ij chi atz'eton ri katata' Abraham. ");
INSERT INTO cakNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Pero ri Jesús xu'ij chique ri achi'a' ri': Can ketzij nin-ij chiwe chi ren can jinc'o-wi-pe, antes chech ri Abraham, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Y ri achi'a' ri' can xbequisiq'uila-pe abaj chi niquiq'uiak chirij. Pero ri Jesús xrewaj-ri' chiquiwech, chiquicojol ri winak xk'ax-wi y xel-pe pa rocho ri Dios, y xbe. ");
INSERT INTO cakNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Y cuando Jesús nik'ax, ja xutzu' jun achi moy; ri achi ri' can moy desde cuando xalex. ");
INSERT INTO cakNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Y ri ru-discípulos xquic'utuj che ri Jesús: Ajaf, ¿ancu'x (anchique) xbano ri mac chi quiere' xalex ri achi re'? ¿Rute-rutata' o ja raja'? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Pero ri Jesús xu'ij: Man jun chique reje' c'o rumac. Ni raja' ni rute-rutata'. Raja' can quiela-wi xalex, chi quiri' tik'alajin ri rusamaj ri Dios riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Pak'ij, can utz-wi chi ni'an samaj. Pero cuando ntoc-pe ri ak'a', conojel man utz ta chic yesamaj. Y can quiri' chuka' ren, cami nic'atzin nin-en ri samaj ri rucheleben-pe chue ri takayon-pe wichi; roma cuando man xquic'ue' ta chic, manak chic xquitiquier xtin-en ri samaj re'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Pero cami mientras ren jinc'o chech-ulef, ja ren ri yiyo'n sakil che ronojel ri rech-ulef, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Cuando ri Jesús ru'in chic ri tzij re', xchuban pa ulef. Y riq'uin ri ruchub ri xka pa ulef, xu'on juba' ch'abak. C'ajari' ri ch'abak ri' xubil chi tak rech ri achi moy. ");
INSERT INTO cakNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Y xu'ij che: Cami ach'aja' ri chi tak awech chuchi' ri estanque chi atinen ri ni'ix Siloé che. Ri bi'aj re' pa jun chic ch'abel, Takon-e ni'ix che. Ri achi ri' can xbe y xuch'aj ri chi tak rech, y cuando xtzolaj-pe, nitzu'n chic. ");
INSERT INTO cakNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Y ri winak ri je ru-vecinos ri achi re' y ri ch'aka chic winak ri can quitz'eton chi can moy-wi, niqui'ij: ¿Man ja' ta como la' ri achi ri c'utuy-limosna ri katz'eton ri nich'oquie' nuc'utuj ru-limosna? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jec'o jujun niqui'ij: Ja', ja raja'. Y ch'aka chic niqui'ij: Junan titzu'n riq'uin ri achi ri'. Pero raja' can nu'ij: Ja', ja ren ri yich'oquie' y ninc'utuj nu-limosna chique ri winak, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y ri winak niquic'utuj che ri achi ri': Ri k'ij can, xa man jatzu'n ta. ¿Anchique x-an chawe chi jatzu'n cami? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ri achi xu'ij chique: Jun achi rubinan Jesús xu'on juba' ch'abak y jari' ri xubil chi tak nuech, c'ajari' xu'ij chue: Ach'aja' ri chi tak awech pa estanque chi atinen ri ni'ix Siloé che. Y ja' xibe, xinch'aj chi tak nuech y ja' xitzu'n. ");
INSERT INTO cakNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Pero ri winak xquic'utuj che: ¿Anchi' c'o-wi ri Jesús cami? xecha'. Y raja' xu'ij: Man weta'n ta, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Y ri winak xquic'uaj-e ri achi ri nitzu'n chic, c'a chiquiwech ri achi'a' fariseos. ");
INSERT INTO cakNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ri k'ij cuando ri Jesús xu'on ri juba' ch'abak y xu'on che ri achi moy chi xtzu'n, ri' pa jun k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Cuando ri achi c'o chic apo chiquiwech ri achi'a' fariseos, xquic'utuj chic che: ¿Anchique x-an chawe chi cami jatzu'n chic? Y raja' xu'ij: Ri xbano chue chi yitzu'n chic, xubil juba' ch'abak chi tak nuech, xinch'aj, y romari' cami yitzu'n chic, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Y jec'o achi'a' fariseos ri xqui'ij: Ri achi ri rubinan Jesús man riq'uin ta ri Dios petenak-wi, roma can man nuchajij ta juba' ri k'ij chi uxlanen, yecha'. Pero jec'o juley chic fariseos ri xqui'ij: ¿Can nitiquier como yeru'on milagros jun achi ri c'o rumac, anche'l xu'on ri Jesús riq'uin ri achi moy? Ri achi'a' fariseos ri' man junan ta ri niquinojij chirij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","C'ajari' ri achi'a' fariseos xquic'utuj che ri achi moy ri nitzu'n chic: ¿Anchique chi achi ri Jesús nanojij ret, ri xu'on chawe chi cami jatzu'n chic? Y ri achi ri' xu'ij: Ren nin-ij chi ri Jesús jun achi ri nuk'alajij ri ni'ix che roma ri Dios, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, man niquinimaj ta chi ri achi ri' can moy-wi cuando xalex, y can man niquinimaj ta chuka' chi jun milagro ri xbano chi cami nitzu'n. Romari' xequiwoyoj ri rute-rutata' ri achi ri nitzu'n chic. ");
INSERT INTO cakNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Y ri achi'a' ri' xquic'utuj chique ri rute-rutata' ri achi: ¿Ja' iwalc'ual re', ri ni'ij chi can moy desde cuando xalex? ¿Anchique xu'on chi nitzu'n cami? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Y ri rute-rutata' ri achi xqui'ij chique: Ja', ja kalc'ual re' y can moy-wi desde cuando xalex. ");
INSERT INTO cakNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero man keta'n ta roj anchique xu'on chi cami nitzu'n. Y man keta'n ta chuka' ancu'x (anchique) xbano che chi nitzu'n chic cami. Tic'utuj che raja'; raja' man co'l ta chic, y can nitiquier nu'ij chiwe ri anchique xbanataj, xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Quiri' xqui'ij ri rute-rutata' ri achi chique ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, roma quixi'n-qui' chiquiwech. Ri achi'a' ri c'o quik'ij can quilesan chic rutzijol, chi xabachique (xama'anchique) ri xti'in chi ri Jesús jari' ri Cristo, can nikotex-pe chupa ri sinagoga, ri jay anchi' nitzijos-wi rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Romari' ri rute-rutata' ri achi xe xqui'ij chi tiquic'utuj che raja', roma raja' man co'l ta chic. ");
INSERT INTO cakNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Y ri achi'a' ri' xquiwoyoj chic jun mej (bey) ri achi ri nitzu'n chic, y xqui'ij che: Ja ri Dios taya' ruk'ij. Roj keta'n chi ri achi rubinan Jesús can c'o rumac, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Y ri achi xu'ij chique: Ren man weta'n ta xa ri Jesús c'o rumac o manak. Ri weta'n ren chirij raja', ja chi ri k'ij can, man yitzu'n ta y cami yitzu'n chic, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Y ri achi'a' ri' xquic'utuj chic che ri achi: ¿Anchique ri xeru'on chawe chi quiri' jatiquier jatzu'n? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Raja' xu'ij chique: Pero ri' xintzijoj yan chiwe y xa man xinic'oxaj ta. ¿Anchique roma cami rix nijo' chi ren nin-ij chic jun mej (bey) chiwe? ¿Nijo' nitzeklebej ri Jesús rix chuka'? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Pero ri achi'a' ri' xcataj quiyowal y xqui'ij: Ret jat jun chique ri yetzekleben ri Jesús; roj manak, roj can katzekleben ri Moisés. ");
INSERT INTO cakNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Roj can keta'n-wi chi ri Moisés can xch'o'n-wi ri Dios riq'uin, pero ri Jesús man keta'n ta anchi' tipe-wi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Y ri achi xch'o'n-apo chique y xu'ij: Jare' ri nibano chue chi yalan ninnojij chirij, roma rix can man iweta'n ta anchi' tipe-wi, pero xu'on chue chi cami yitzu'n chic. ");
INSERT INTO cakNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Can k'alaj chi ri Jesús manak rumac, roma keta'n chi ri Dios man nu'on ta ri anchique niquic'utuj ri winak ri c'o quimac. Pero ri jun ri can nuya-wi ruk'ij ri Dios y can nu'on chuka' ri nrojo' ri Dios, can nic'oxex-wi roma ri Dios, y nibanataj ri nuc'utuj. ");
INSERT INTO cakNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Can man jun mej (bey) tz'eton o c'oxan ta chi c'o ta jun nibano che jun ri can moy-wi desde cuando xalex chi nitzu'n ta. ");
INSERT INTO cakNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Y xa ta ri Jesús man ta riq'uin ri Dios petenak-wi, man ta xtiquier xu'on ri milagro wiq'uin ren, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Pero ri achi'a' ri' xqui'ij che ri achi ri nitzu'n chic: Ret can xatalex chupa ronojel ri amac, ¿y cami najo' jojatijoj-pe roj? xecha'. Y xquikotaj-pe ri achi ri' chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ri Jesús xuc'oxaj chi ri achi ri' xkotex-pe, romari' xberucanoj. Y cuando xril, xu'ij che: ¿Naya' como awánima riq'uin ri Ralc'ual ri Dios? xcha' ri Jesús che. ");
INSERT INTO cakNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Y ri achi ri nitzu'n chic, xu'ij che ri Jesús: Ren ninjo' ninya' wánima riq'uin ri Ralc'ual ri Dios, xa ja ri man weta'n ta ancu'x (anchique) ri'. Ta'ij chue, xcha' ri achi. ");
INSERT INTO cakNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Y ri Jesús xu'ij che: Ret can atz'eton chic ri Ralc'ual ri Dios. Ja ren ri Ralc'ual ri Dios. Ja ren ri yich'o'n awiq'uin, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ri achi can ja' xu'ij: Ajaf, ren jatinnimaj. Y ri achi can xuya' ruk'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Y ri Jesús xu'ij: Ren xipe chech-ulef chi yentzu' ri winak anchique quibanon, xa utz o man utz ta. Y nin-en chique ri winak ri man yetzu'n ta chi yetzu'n. Pero ri niquina' chi yetzu'n, xa xquiemoyir. ");
INSERT INTO cakNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Y jec'o achi'a' fariseos ri jec'o-apo chiri' anchi' c'o-wi ri Jesús, cuando xquic'oxaj ri', xqui'ij: ¿Joj moy c'a chuka' roj? ");
INSERT INTO cakNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Y ri Jesús xu'ij chique: Xa ta jix moy, utz ta, roma man jun ta imac niwakalej. Pero xa roma rix ni'ij chi can man jix moy ta, romari' ri imac can c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Tic'oxaj na pe' utz ri xtin-ij chiwe: Ri qui-corral ri ovejas can c'o jun ruchi'. Y ri man nucusaj ta ri ruchi' ri corral chi ntoc-apo y xa nijote' chirij chi ntoc-apo; ri nibano quiri' xa jun elek'om. ");
INSERT INTO cakNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero ri nucusaj ruchi' ri corral chi ntoc-apo, jari' ri quichajinel ri ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Y ri achi ri nichajin ruchi' ri corral, nujak-pe ruchi' ri corral chech ri achi ri nichajin quichi ri ovejas, y ri ovejas can quieta'n chic rukul ri nichajin quichi. Raja' yeroyoj chiquijunal riq'uin ri quibi' y yerulesaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Cuando ri chajinel jerulesan conojel ri ru-ovejas, nina'ey chiquiwech, y ri ovejas yetzake-e chirij. Ri ovejas can quiri' niqui'en, roma can quieta'n anchique ri rukul ri nichajin quichi. ");
INSERT INTO cakNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Pero ri man quieta'n ta rech, man niquitzeklebej ta; xa yelumaj (yenimaj) chech, roma man quieta'n ta ri rukul, roma man jun mej (bey) quic'oxan. ");
INSERT INTO cakNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xa jun ejemplo ri xu'ij chique ri achi'a' fariseos, pero reje' man xqui'en ta entender anchique ri xu'ij chique. ");
INSERT INTO cakNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","C'ajari' ri Jesús xch'o'n chic jun mej (bey) y xu'ij chique ri achi'a' fariseos: Tic'oxaj utz ri xtin-ij chiwe: Ja ren ri jin Ruchi' ri corral ri anchi' ye'oc-apo ri ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Y je q'uiy ri xec'ue' yan na'ey chinuech ren y xqui'ij chi je-takon-pe roma ri Dios, pero xa man quiri' ta, xa je junan quiq'uin ri elek'oma'. Pero ri ovejas man xequitzeklebej ta reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja ren ri jin Ruchi' ri corral. Ri xtoc wiq'uin ren, can xticolotaj y xtiril ronojel ri nic'atzin che. ");
INSERT INTO cakNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Cuando napon jun elek'om, can xe chi neru'ona-pe elak' y nicamisan. Can ronojel ri nu'on, man utz ta. Pero ren, nicha' ri Jesús, xipe chi ninya' jun utzilaj y c'ac'ac' c'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Y ja ren ri utzilaj Quichajinel ri ovejas. Ri utzilaj Chajinel, can nuya' ruc'aslen coma ri ru-ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero xa ri nichajin quichi ri ovejas yeruchajij xe roma nitoj, cuando nutzu' chi nipe ri utif, xa ja raja' ri nilumaj-e (ninimaj-e) y yerumalij can ri ovejas. Raja' quiri' nu'on roma raja' man rajaf ta ri ovejas, ni man ja' ta raja' ri ketzij chajinel. Y ri utif yeruc'uaj ri ovejas, y ri ch'aka chic niquitaluj can qui' roma xemalix can. ");
INSERT INTO cakNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Jun ri nitoj chi yeruchajij ovejas, nilumaj-e (ninimaj-e). Quiri' nu'on, roma man ja' ta raja' ri rajaf ri ovejas. Raja' man jun anchique nuna' xa c'o anchique ri niquic'ulumaj ri ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Pero ja ren ri utzilaj Chajinel, y weta'n quiwech ri nu-ovejas, y reje' chuka' quieta'n nuech ren. ");
INSERT INTO cakNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Quiri' chuka' nubanon riq'uin ri Nata'. Raja' reta'n nuech ren, y ren weta'n rech raja'. Ren ninya' nuc'aslen coma ri nu-ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Y ren man xe ta re' nu-ovejas jec'o, xa can jec'o chuka' ch'aka chic ri man jec'o ta we' chupa ri jun corral re'. Can nic'atzin chi yenc'om-pe, y reje' xtiqui'en ri xtin-ij chique. Can xtic'ue-wi jun ketzij Chajinel quichi, y xe jun chuka' xtin-en chique conojel ri ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ri Nata' Dios can yirojo-wi. Can nika chech chi ren ninya' ri nuc'aslen coma ri nu-ovejas, y chuka' roma nic'ue' chic jun mej (bey) ri nuc'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ri nuc'aslen, can man jun xtimajo chue, roma ri nuc'aslen xa ja ren ri yiyo'n. Pa nuk'a' ren c'o-wi chi ninya' y pa nuk'a' chuka' ren c'o-wi chi nic'ue' chic nuc'aslen. Quiri' ri ru'in-pe ri Nata' chue, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Y jun mej (bey) chic ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas man junan ta xquinojij, roma ri tzij ri xeru'ij ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Je q'uiy chique reje' xqui'ij chirij ri Jesús: La' xa ch'u'j. Xa itzel espíritu ri c'o riq'uin, y rix can ninimaj-ka ri nu'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Y ri ch'aka chic xqui'ij: Jun ri c'o itzel espíritu riq'uin, man nitiquier ta nu'ij utzilaj tak tzij anche'l ri xeru'ij-ka ri Jesús. ¿Nitiquier como jun ri c'o itzel espíritu riq'uin nu'on che jun moy chi nitzu'n? yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Pa ru-tiempo job nik'ax ri nimak'ej rubinan Dedicación, chi niquinataj ri k'ij cuando x-an chic ru'onic ri rocho ri Dios ri c'o pa tenemit Jerusalem. ");
INSERT INTO cakNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ri Jesús c'o-apo chupa ri rocho ri Dios, pa jun corredor ri rubinan Richi ri Salomón. ");
INSERT INTO cakNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas xe'apon riq'uin ri Jesús, xquimol-qui' chirij y c'ajari' xqui'ij che: ¿Anchique roma man najo' ta nak'alajij-awi' chakawech? Xa can ja ret-wi ri Cristo ri takon-pe roma ri Dios, ta'ij chake. ");
INSERT INTO cakNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Y ri Jesús xu'ij chique ri achi'a' ri': Nu'in yan chiwe y man iniman ta. Ronojel ri samaj ri yenben, pa rubi' ri Nata' Dios yenben-wi. Y ri samaj ri' niquik'alajij-wi ri jin anchique ren. ");
INSERT INTO cakNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Pero rix can man yininimaj ta, roma rix man jix ta nu-ovejas; can anche'l-wi xin-ij yan chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ri nu-ovejas can quieta'n nukul y niquic'oxaj, y can jinquitzeklebej chuka'. Ren weta'n chuka' quiwech reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ren ninya' quic'aslen chi ronojel tiempo y can man jun chique xtisatz (xtisach) ta can. Y man jun xtitiquier xquierulesaj-e pa nuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Y chuka' can pa ruk'a' ri Nata' Dios jec'o-wi, roma ja raja' ri xcha'on quichi. Y ja raja' ri más nim ruk'ij chiquiwech conojel. Can man jun xtitiquier xquierulesaj pa ruk'a' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ren y ri Nata', can xe jun kabanon riq'uin, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Y ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, xbequisic'a' chic pe abaj chirij ri Jesús chi niquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero ri Jesús xu'ij chique ri achi'a' ri': Can q'uiy utzilaj tak samaj ri jenubanon chiwech, roma ri uchuk'a' ri ruyo'n-pe ri Nata' chue. ¿Anchique chique ri utzilaj tak samaj ri nubanon ri man nika ta chiwech, y romari' nijo' yinicamisaj che abaj? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Y ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas xqui'ij che ri Jesús: Roj man roma ta jun utzilaj samaj jatkaq'uiak che abaj. Roj jatkaq'uiak roma na'ij chi jat Dios. Roma jun achi ri ni'in quiri', xa itzel chech ri Dios, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Pero ri Jesús xu'ij chique: Chupa ri i-ley, ri Dios nu'ij: Ren nu'in chi rix can jix dioses. ");
INSERT INTO cakNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Can keta'n-wi chi roj manak modo naka'ij chi ri nu'ij rutzij ri Dios man ketzij ta. Raja' can xu'ij dioses chique ri anchok che xuya-wi ri rutzij. ");
INSERT INTO cakNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Xa quiri' xu'ij ri Dios, ¿anchique roma rix ni'ij chi ren itzel xin-ij chech ri Dios, roma xin-ij chi ja ren ri Ralc'ual ri Dios? Y ren can xirucha' ri Dios chi xirutak-pe chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Y xa man nin-en ta ri ru'in-pe ri Nata' Dios chue, man quininimaj c'a. ");
INSERT INTO cakNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero xa can nin-en ri ru'in-pe ri Dios chue, quininimaj. Y más que man yininimaj ta roma ri nu'in chiwe, tinimaj ronojel ri yenben, chi quiri' nina'ej chi ri Nata' Dios can c'o-wi wiq'uin y ren chuka' jinc'o riq'uin raja', xcha' ri Jesús chique ri achi'a' ri can c'o-wi quik'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Reje' c'o ta xquijo' xquitz'om ta ri Jesús, pero xa man xetiquier ta chic jun mej (bey), roma xa xbe chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y ri Jesús xk'ax chic apo juc'an ruchi' rakan-ya' Jordán, ri lugar anchi' ri Juan Bautista xeru'on bautizar ri winak na'ey; y chiri' xc'ue-wi-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Y can je q'uiy winak xe'apon riq'uin ri Jesús chiri'. Y ri winak ri' niqui'ij: Can ketzij-wi chi ri Juan Bautista man jun milagro xu'on, pero ronojel ri tzij ri xeru'ij can chirij ri achi re', can ketzij-wi xe'el, yecha' ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y je q'uiy winak ri xquinimaj ri Jesús chupa ri jun lugar ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Chupa ri tenemit co'l oc rubinan Betania, c'o jun achi yawa' rubinan Lázaro; raja' jec'o je ca'i' rana' quibinan Marta y María, ri je oxi' re' je aj-Betania. ");
INSERT INTO cakNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Jare' ri María ri xyo'n jubulaj ak'om chirij ri rakan ri Ajaf Jesús y xerusu' riq'uin ri rusmal-ruwi'. Ruxibal raja' ri niyawaj. ");
INSERT INTO cakNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","María y ri Marta, ri je rana' ri Lázaro, xquitak rubixic che ri Jesús: Ajaf, naka'ij-e chawe chi ri kaxibal Lázaro, ri can najo', cami niyawaj. ");
INSERT INTO cakNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Y cuando ri Jesús xuc'oxaj chi takon-e rubixic che, raja' xu'ij: Ri Lázaro niyawaj, roma nic'atzin chi nik'alajin ruchuk'a' ri Dios riq'uin. Ri yabil ri ntoc che, man richi ta camic, xa can chi xtik'alajin ri ruchuk'a' ri Dios, chi quiri' ren ri Ralc'ual ri Dios niyo'x nuk'ij, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ri Jesús yalan yerojo' ri Marta, ri María y ri quixibal Lázaro. Can chi je oxi' yalan yerojo'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Y cuando raja' xuc'oxaj chi ri Lázaro niyawaj, c'a pa rox k'ij xberutzu', roma xc'ue' na chic ca'i' k'ij chupa ri lugar ri anchi' c'o-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","C'ajari' ri Jesús xu'ij chique ri ru-discípulos: Cami kojtzolaj pa Judea, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Y ri ru-discípulos xqui'ij che: Maestro, xecha' che. Xa c'aja' oc jun jani' k'ij tik'ax cuando ri achi'a' ri can c'o-wi quik'ij chiquicojol ri kawinak israelitas xquijo' ta xatquicamisaj che abaj, ¿y cami najo' jatzolaj chic chila'? xecha' ri discípulos che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Pero ri Jesús xu'ij chique: Ri k'ij ruc'uan cablajuj horas. Ri niplakin pak'ij, manak nutopij rakan, roma can c'o ri nisakrisan richi ri rech-ulef. Can ronojel-wi nutzu' roma ri sakil ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero ri niplakin pa k'eku'm, can nutopij-wi ri rakan, roma xa manak ri sakil pa ruwi'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Y cuando ri Jesús ru'in chic ronojel re', xch'o'n chic jun mej (bey) chique ri ru-discípulos y xu'ij: Ri Lázaro ri keta'n rech, niwer. Pero ja' yibe y nenc'asoj, xcha' chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Y ri ru-discípulos xqui'ij che: Ajaf, pero xa ri Lázaro niwer, can xtic'achoj-wi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Pero ri Jesús xa chirij ri rucamic ri Lázaro xch'o'n-wi, cuando xu'ij chi niwer, pero ri ru-discípulos xqui'en entender chi can niwer-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","C'ajari' ri Jesús can k'alaj xu'ij chique: Ri Lázaro xcom. ");
INSERT INTO cakNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Y can yiquicot roma man jinc'o ta apo pa tenemit Betania cuando xcom ri Lázaro, chi quiri' rix más niya' iwánima wiq'uin. Cami jo' pa Betania, anchi' c'o-wi ri Lázaro, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Pero ri jun discípulo ri rubinan Tomás, y ni'ix chuka' Dídimo che, xu'ij chique ri ch'aka chic discípulos: Jo' riq'uin ri Jesús, chi quiri' junan jojcamises riq'uin, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cuando Jesús y ri ru-discípulos xe'apon pa Betania, quieji' yan k'ij tic'ue' ri caminak pa jul. ");
INSERT INTO cakNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ri tenemit Betania man naj ta c'o-wi che ri tenemit Jerusalem. Ri quicojol xa jun ca'i' kilómetros y nic'aj. ");
INSERT INTO cakNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Y je q'uiy achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas ri xe'apon chi xequi'en consolar ri Marta y María, roma ri rucamic ri quixibal Lázaro. ");
INSERT INTO cakNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Cuando ri Marta xuna'ej chi petenak ri Jesús, junanin xberuc'ulu'. Y ri María man xuna'ej ta, romari' xc'ue' can chiri' pa jay. ");
INSERT INTO cakNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Y cuando ri Marta xapon riq'uin ri Jesús, raja' xu'ij che: Ajaf, ri nuxibal xcom. Xa ta jatc'o we', c'a q'ues ta cami. ");
INSERT INTO cakNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero ren weta'n chi ri xtac'utuj che ri Dios cami, ri Dios can xtuya' chawe, xcha' ri Marta che ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xu'ij che ri Marta: Ri axibal Lázaro xtic'astaj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Y ri Marta xu'ij: Ja', ren can weta'n-wi chi xtic'astaj; roma cuando xtapon ri ruq'uisbel k'ij, conojel ri caminaki' xquiec'astaj-pe, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xu'ij che ri Marta: Ren can yitiquier yenc'asoj ri caminaki', y can yitiquier chuka' ninya' c'aslen. Romari' ri niniman wichi, más que xticom, can xtic'ase' chic. ");
INSERT INTO cakNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xabachique (Xama'anchique) winak ri c'o ruc'aslen chech-ulef y yirunimaj ren, man xtapon ta chupa ri camic ri can richi ronojel tiempo. ¿Nanimaj re'? xcha' ri Jesús che ri Marta. ");
INSERT INTO cakNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Y Marta xu'ij che ri Jesús: Ja' Ajaf, can ninnimaj ronojel ri na'ij; roma can weta'n chi ja ret ri Cristo ri Ralc'ual ri Dios, ri can nipe-wi chech-ulef, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cuando ri Marta ru'in chic ri tzij re' che ri Jesús, xbe chi xberoyoj ri María ri rach'alal. Y cuando xapon, ri Marta xu'ij pa ruxiquin ri María: Ri Ajaf xoka y cami jatroyoj, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ri María, can xe xuc'oxaj quiri', can ja' xcataj ri anchi' ch'ocol-wi y junanin xbe c'a anchi' c'o-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús c'a man jani toc-apo chupa ri tenemit Betania, xa c'a c'o chupa ri lugar anchi' xbec'ul-wi roma ri Marta. ");
INSERT INTO cakNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Y cuando ri winak israelitas ri je-aponinak chirocho ri María chi niqui'en consolar, xquitzu' chi junanin xcataj-e y xbe; reje' chuka' xquitzeklebej-e, roma xquinojij chi ri María chuchi' ri jul xbe-wi chi nrok'ej ri ruxibal. ");
INSERT INTO cakNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Y cuando ri María xapon anchi' c'o-wi ri Jesús y xutzu', xxuquie-ka chirakan y xu'ij che: Ajaf, ri nuxibal xcom. Xa ta jatc'o we', manak ta xcom, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Y cuando ri Jesús xutzu' chi ri María ntok' y chuka' ye'ok' conojel ri winak israelitas, ri xe'apon chi niqui'en consolar ri María, ri ránima ri Jesús jun-wi xu'on xuna' y xbison-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Y ja xuc'utuj: ¿Anchi' ximuk-wi ri Lázaro? xcha'. Y reje' xqui'ij: Ajaf, jo' y ne'kac'utu' chawech anchi' xkamuk-wi, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Y ri Jesús xok'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ja' cuando ri winak israelitas ri xepe chi yequi'en consolar ri Marta y María, xqui'ij: Titzu' ri Jesús, nrok'ej ri Lázaro. K'alaj chi yalan xrojo', xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Pero jec'o chique ri winak ri' xqui'ij chirij ri Jesús: Raja' can xtiquier xu'on che ri moy chi xtzu'n. ¿Anchique roma xuya' lugar chi xcom ri Lázaro y man jun xtiquier xu'on? xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Cuando ri Jesús xapon chuchi' ri jul, xtzolaj chic pe ri bis pa ránima. Ri jul anchi' yo'n-wi can ri Lázaro, jun jul ri c'oton chech jun xak, y tz'apel can ruchi' che jun abaj. ");
INSERT INTO cakNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Y ri Jesús xu'ij: Tilesaj-e la abaj ri rutz'apin ruchi' ri jul, xcha' raja'. Pero ri Marta, rana' ri caminak, xu'ij che ri Jesús: Ajaf, chuj chic, roma c'o yan quieji' k'ij ticom, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ri Jesús xu'ij che ri Marta: Ren can nu'in chic chawe chi xa xtanimaj, can xtatzu' ri nu'on ri ruchuk'a' ri Dios, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Y ja xquilesaj-e ri abaj ri rutz'apin ruchi' ri jul anchi' c'o-wi ri caminak. Y ri Jesús xtzu'n chicaj y xu'ij: Nata', matiox ninya' chawe roma can xinac'oxaj-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ren weta'n chi can siempre yinac'oxaj. Pero ronojel re', can nin-ij coma ri winak ri quimolon-pe-qui' wiq'uin cami, chi tiquinimaj chi can ja ret ri xatako-pe wichi chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cuando ri Jesús ru'in chic ri tzij re', can riq'uin ronojel ruchuk'a' xch'o'n y xu'ij: Lázaro, cacataj y catel-pe, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Y ri Lázaro xbe'el-pe. Y ri ruk'a-rakan can bolkotin pa tziak, y ri rech tz'apel riq'uin jun tziak xax. C'ajari' ri Jesús xu'ij: Quie'isolo' ri tziak chirij, chi quiri' utz nibin y nitiquier nitzolaj-e, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Y je q'uiy winak israelitas ri xepe chi niqui'en consolar ri María, xquinimaj ri Jesús cuando xquitzu' ri xu'on, chi xuc'asoj ri caminak. ");
INSERT INTO cakNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero jec'o ch'aka ri xebe quiq'uin ri achi'a' fariseos y xbequitzijoj chique ri xu'on ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Y ri nimalaj tak sacerdotes y ri achi'a' fariseos xquimol-qui' y xequiwoyoj chuka' ri ch'aka chic achi'a' je autoridad quichi ri israelitas y xqui'ij chique: ¿Anchique naka'an? Roma ri achi rubinan Jesús q'uiy milagros ri yeru'on chiquiwech ri winak chi tiquinimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Y xa can xtakaya' lugar che, can conojel ri winak xquieniman richi. Y cuando xtiquina'ej-pe ri winak romanos, xtoquiwulij (xtoquiwulaj) ri jay ri anchi' nakaya-wi ruk'ij ri Dios y xkojquiq'uis can chuka' roj ri jojc'o chupa ri rech-ulef re', xecha' reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","C'ajari' c'o jun ri xch'o'n. Y ri xch'o'n ja ri Caifás ri sacerdote ri más c'o ruk'ij chupa ri tiempo ri'. Raja' c'o chiri', roma raja' jun chique ri can c'o-wi quik'ij. Y cuando raja' xch'o'n, xu'ij: Rix xa man jun iweta'n. ");
INSERT INTO cakNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Can man ninojij ta juba' chi xa más utz chake roj chi xe jun nicom pa kaq'uiexel konojel y mani chi konojel jojcom xe roma ri jun ri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Cuando ri Caifás xu'ij quiri', man can ta ja runo'j (runa'oj) raja' xucusaj. Ri tzij ri xeru'ij raja', can ja ri Dios ri xyo'n-pe che. Roma can ja raja' ri sacerdote más c'o ruk'ij ri tiempo ri', romari' ri Dios xuya' lugar che chi xu'ij chi ja ri Jesús xticom pa quiq'uiexel ri winak chi ri rech-ulef ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Pero ri Jesús can man xe ta pa quiq'uiexel ri winak chi ri rech-ulef ri' xticom, xa can xticom chuka' chi yerumol conojel ri winak ri can je ralc'ual-wi ri Dios ri quiquiran-qui' chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Y can ja ri k'ij ri', ri achi'a' ri can c'o quik'ij xqui'ij chiquiwech chi xtiquicamisaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Romari', ri Jesús manak chic xtz'et coma ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas. Raja' xa xbe pa jun chic tenemit. Xbe pa jun tenemit rubinan Efraín, y ri tenemit ri' chunakaj apo ri tz'iran rech-ulef c'o-wi. Y xc'ue-ka chiri' quiq'uin ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Y ja' noka yan ri k'ij chi ri pascua, ri jun quinimak'ej ri israelitas. Romari' can je q'uiy winak ri xe'el-pe pa tak quitenemit, chi xebe pa tenemit Jerusalem. Can xebe chi niquijosk'ij-qui' chech ri Dios, antes chech ri nimak'ej. ");
INSERT INTO cakNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Y ri winak niquicanola' ri Jesús, y pa rocho ri Dios niquic'utula' chiquiwech: ¿Anchique ninojij rix? ¿Noka como chupa ri nimak'ej re'? yecha' ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ri nimalaj tak sacerdotes y ri achi'a' fariseos can quilesan chic rutzijol, chi xabachique (xama'anchique) winak ri xtina'en anchi' c'o-wi ri Jesús, tu'ij chique reje', chi niquitz'om. ");
INSERT INTO cakNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Xe chic waki' k'ij nrojo' chi napon ri k'ij chi ri nimak'ej ri ni'ix pascua che, ri Jesús xbe pa tenemit Betania, ri rutenemit ri jun achi rubinan Lázaro, ri xcom-e y xc'asos roma ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Y chiri' x-an jun wa'in, roma xapon ri Jesús. Y ja ri Marta yerilij-apo ri jec'o chuchi' mesa. Ri Lázaro jun chique ri je-ch'ocol-apo chuchi' mesa riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Xpe ri María ri rach'alal ri Marta y rana' ri Lázaro, xberuc'ama-pe nic'aj litro che jun jubulaj ak'om ri ni'ix nardo che ri yalan rajil. Y can ronojel ri' xuya' chirij rakan ri Jesús y xerusu' riq'uin ri rusmal-ruwi'. Y ri jay ri' can xnoj riq'uin ri ruxla' ri ak'om ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Y c'o jun chique ri discípulos ri man xka ta chech chi quiri' x-an che ri jubulaj ak'om, y ri' ja ri Judas Iscariote ri ralc'ual ri jun achi rubinan Simón; ri discípulo re' ja ri xtic'ayin richi ri Jesús. Raja' xu'ij: ");
INSERT INTO cakNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","¿Anchique roma man xc'ayix ta ri jubulaj ak'om re'? Xa ta xc'ayix, xyo'x ta trescientos denarios; y ri mero ri' xjach ta chique ri winak ri manak quibeyomal, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Raja' xu'ij quiri', pero man roma ta yalan yerojo' ri winak ri manak quibeyomal, y nrojo' ta yeruto'. Raja' quiri' xu'ij roma ja raja' uc'uayon ri mero y c'o ri nulek'aj-e. Raja' xa can elek'om-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Y ri Jesús xu'ij che ri Judas: Man jun anchique ta'ij che, xa taya' lugar che chi tu'ona' ri nrojo'. Más que man jani quicom, raja' can wichi-wi ren ruyacon-pe ri ak'om re' chi ri k'ij cuando xquimuk. ");
INSERT INTO cakNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Roma ri winak ri manak quibeyomal, can siempre jec'o iwiq'uin, chi quiri' xabachique (xama'anchique) k'ij niben favor chique. Pero ren man siempre ta xquic'ue' iwiq'uin, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cuando ri winak israelitas xquina'ej chi ri Jesús c'o pa Betania, can je q'uiy ri xepe chi niquitzu' ri Jesús y chuka' chi niquitzu' ri Lázaro, ri xc'asos roma ri Jesús chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Romari' ri nimalaj tak sacerdotes xquiya' chiquiwech chi chuka' ri Lázaro xtiquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Roma chirij ri Lázaro xquik'abaj-wi chi je q'uiy quiwinak israelitas ri yequiya' can y niquinimaj ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ruca'n k'ij, chiri' pa tenemit Jerusalem, can je q'uiy winak jec'o roma ri nimak'ej. Y cuando xquic'oxaj chi benak-apo ri Jesús, ");
INSERT INTO cakNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","xquic'uaj ruxak tak palmas y xbequic'ulu' y niqui'ij: ¡Matiox chi petenak ri Jun re'! ¡Jare' ri ka-Rey roj israelitas! ¡Can yo'n-pe bendición pa ruwi' roma ri Ajaf Dios, y pa rubi' ri Ajaf Dios petenak-wi! yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Y ri Jesús can c'o jun alaj burro ri xril, chi xuch'ocolbej. Can anche'l-wi ri nu'ij chupa rutzij ri Dios ri tz'iban can: ");
INSERT INTO cakNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Man tixi'j-iwi' rix ri jix aj-tenemit Sión; roma ri i-Rey ja' petenak, ch'ocol-pe chirij jun alaj burro. Quiri' ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na'ey ri ru-discípulos man xqui'en ta entender ronojel re'. C'aja' cuando ri Jesús c'astajinak chic pe chiquicojol ri caminaki' y c'o yan nimalaj ruk'ij, c'ajari' xoka pa quiwi' chi ronojel re' can tz'iban can chupa rutzij ri Dios, y can quiri-wi xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Y ri winak ri xquitzu' ri Jesús cuando xroyoj ri Lázaro ri caminak chic y xuc'asoj-pe chiquicojol ri caminaki', can niquitzijola' chique ri ch'aka chic winak. ");
INSERT INTO cakNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Y romari', cuando ri Jesús chunakaj chic c'o-wi che ri tenemit Jerusalem, can xepe chi noquic'ulu'. Ri winak ri' can quic'oxan chic ri milagro ri xu'on riq'uin ri Lázaro. ");
INSERT INTO cakNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Pero ri achi'a' fariseos niqui'ij chiquiwech: Titzu', conojel ri winak je-benak chirij. Man niquinimaj ta ri katzij roj, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Y chiquicojol conojel ri winak ri je-aponinak pa tenemit Jerusalem chupa ri k'ij ri', chi niquiya' ruk'ij ri Dios chupa ri nimak'ej ri', jec'o chuka' jujun winak griegos. ");
INSERT INTO cakNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ri winak re' xe'apon-apo riq'uin ri Felipe ri aj-Betsaida ri c'o pa Galilea, chi niquic'utuj favor che; roma raja' jun ru-discípulo ri Jesús. Ri winak ri' xqui'ij che: Roj nakajo' jojch'o'n juba' riq'uin ri Jesús, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xbe y xberu'ij che ri Andrés ri jun discípulo chuka'. C'ajari' ri je ca'i' xebe-apo riq'uin ri Jesús y xqui'ij che: Jec'o jujun winak griegos ri niquijo' yech'o'n awiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Y ri Jesús can ja xu'ij chique ri ca'i' discípulos: Ja k'ij re' xoka, chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol xtic'ue' nuk'ij y xquitzolaj-e chicaj. ");
INSERT INTO cakNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Y tic'oxaj ri xtin-ij chiwe y can tinimaj: Xa manak nitic jun rech trigo pa ulef, choj quiri' xtic'ue'. Pero xa can nitic-ka, más que nic'ue' can chuxe' ulef ri rech trigo ri', xtel-pe y xtuya' rech. ");
INSERT INTO cakNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Romari' ri winak ri yalan niquipokonaj quic'aslen we' chech-ulef, man xtiquiwil ta quic'aslen ri manak xtiq'uis. Pero ri man niquipokonaj ta ri quic'aslen woma ren, niquiyec-apo quic'aslen chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Y xa c'o jun nrojo' nu'on ri nusamaj, tipe wiq'uin. Y anchi' xquic'ue-wi ren, can chiri' chuka' xtic'ue-wi raja'. Ri can xtibano ri nusamaj, can xtinimrises ruk'ij roma ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ren yalan ruquiy (nik'axon) ri wánima cami. ¿Pero xtin-ij como che ri Nata': Quinacolo' chech ri sufrimiento re'? Manak modo, roma ren can romari' xipe. ");
INSERT INTO cakNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","C'ajari' raja' xu'ij: Nata', can tabana' chi nik'alajin ak'ij, xcha'. Y ja' cuando ri Dios xch'o'n-pe chicaj y xu'ij: Can nubanon chic quiri'. Y xtin-en chic jun mej (bey), chi can nik'alajin-wi nuk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Y can je q'uiy chique ri winak ri jec'o chiri' ri xe'in chi jun rayo ri xquic'oxaj cuando xch'o'n-pe ri Dios chicaj. Y ri ch'aka chic niqui'ij: Jun ángel ri xch'o'n-pe che, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Y ri Jesús xu'ij chique: Ri Jun ri xic'oxaj chi xch'o'n-pe chicaj, xch'o'n-pe iwoma rix y man woma ta ren. ");
INSERT INTO cakNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Cami xoka yan ri k'ij chi ri Dios nu'on juzgar ri rech-ulef, y ri Satanás ri rajawal ri rech-ulef, can xtileses-e. ");
INSERT INTO cakNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Y cuando ren xquijotobex chech ri cruz, ri winak xquiepe wiq'uin ren, roma can xquisamaj pa cánima, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ri Jesús xu'ij quiri', chi xuk'alajij ri anchique modo xticamises. ");
INSERT INTO cakNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Y ri winak xqui'ij: Ret na'ij chi ja ret ri jat-kajinak-pe chicaj y xatalex chikacojol, pero xa na'ij chuka' chi xcajotobex chech ri cruz. Can man naka'an ta entender anchique roma na'ij quiri'. Roma roj keta'n ri nu'ij chupa rutzij ri Dios chi cuando ri Cristo xtipe, can xtic'ase' chi ronojel tiempo. Tak'alajij c'a chakawech anchok chij jach'o'n-wi cuando nanataj ri jun ri xalex chikacojol, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ja cuando ri Jesús xu'ij chique: Ri Sakil xe chic juba' c'o iwiq'uin. Romari', ya que cami c'a c'o ri Sakil, quixbin chupa ri Sakil. Y xa man xtiben ta quiri', c'aja' xtina' pa k'eku'm chic jixc'o-wi; y ri pa k'eku'm nibin-wi, man reta'n ta anchi' benak-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Y roma ri Sakil c'a c'o iwiq'uin, tinimaj ri Sakil chi jixoc ralc'ual ri Sakil ri'. Quiri' xeru'ij ri Jesús chique ri winak. C'ajari' xeruya' can, y man jun xna'en anchi' xbe-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ri Jesús can q'uiy milagros xeru'on chiquiwech ri winak. Pero más que quiri' xu'on, reje' man xquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Y quiere' ri xbanataj, roma can nibanataj-wi ri je-tz'iban can. Anche'l ri rutz'iban can ri Isaías, ri jun ri xuk'alajij ri rutzij ri Dios ojer can. Raja' rutz'iban can: Ajaf, ¿ri atzij ri xkatzijoj, can c'o como jun ri xniman? ¿C'o como jun winak ri xutzu' ri awuchuk'a'? Quiri' nu'ij ri rutz'iban can ri Isaías. ");
INSERT INTO cakNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ri winak re' can man niquinimaj ta, roma chupa ri rutz'iban can ri Isaías nu'ij chuka': ");
INSERT INTO cakNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Can banon chique reje' roma ri Dios que man yetzu'n ta y cowirinak cánima; romari' man niquitzu' ta ri nic'ut chiquiwech, man niqui'en ta entender, man niquiya' ta can ri quimac y niqui'en ta ri ninjo' ren chi ninjal ri quic'aslen, nicha' ri Ajaf. Quiri' rutz'iban can ri Isaías. ");
INSERT INTO cakNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri Isaías, ri achi ri xuk'alajij rutzij ri Dios ojer can, xu'ij quiere' cuando xutzu' yan ruk'ij ri Ajaf Jesús, y chirij raja' ch'o'inak-wi can. ");
INSERT INTO cakNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Y más que quiri' tz'iban can, je q'uiy chiquicojol ri autoridades quichi ri israelitas xquinimaj chuka' ri Jesús. Pero man xquik'alajij ta qui', roma niquixi'j-qui' chiquiwech ri achi'a' fariseos chi ye'kotex-pe chupa ri sinagoga, ri jay anchi' niquimol-wi-qui' chi niquic'oxaj rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Reje' más nika chiquiwech chi niyo'x quik'ij coma ri winak, que chech niyo'x ta quik'ij roma ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Y ri Jesús riq'uin ruchuk'a' xch'o'n y xu'ij: Ri yirunimaj ren, man xe ta ren ri xquirunimaj, xa can xtunimaj chuka' ri Dios ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ri yirutzu' ren, can nutzu' chuka' ri Dios ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Roma ja ren ri Sakil ri xipe chech-ulef, chi quiri' xa c'o jun ri xtiniman wichi, ri ruc'aslen manak chic xtic'ue' pa k'eku'm. ");
INSERT INTO cakNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Pero ri winak ri nuc'oxaj ri nutzij y man nu'on ta ri nuc'oxaj, man ja' ta ren ri xquibano juzgar richi. Roma ren man xipe ta chech-ulef chi yenben juzgar ri winak. Man tinojij quiri'. Ren xipe chi yencol ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ri man yirojo' ta ren y man nrojo' ta chuka' ri nutzij, can c'o ri xtibano juzgar richi; can ja ri tzij ri xenbij, jari' ri xquiebano juzgar richi pa ruq'uisbel k'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Roma ri tzij ri xenk'alajij chiwech, can ja ri Nata' yoyo'n-pe chue. Can ja raja' ri takayon-pe wichi y ru'in-pe chue anchique tzij ri nonbij y nonk'alajij-ka chiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Y can weta'n chi ri ru'in-pe ri Nata' Dios chue, can nuya-wi c'aslen ri man niq'uis ta. Romari' ri tzij ri nonbij chiwe, can anche'l ri ru'in-pe ri Nata' chue ren, quiri' ri nonbij-ka chiwech rix. ");
INSERT INTO cakNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Y cuando noka yan ri k'ij chi ri nimak'ej rubinan pascua, ri Jesús reta'n chic chi noka yan ri hora chi raja' ntel-e we' chech-ulef y nitzolaj-e chicaj riq'uin ri Rutata'. Ri Jesús, can anche'l xerojo-pe conojel ri can je richi-wi raja' ri jec'o we' chech-ulef, can quiri' chuka' xu'on c'a pa ruq'uisbel k'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ri Jesús y ri discípulos ye'ajin riq'uin ri wa'in. Ri Satanás nisamaj yan pa ránima ri Judas Iscariote, ralc'ual ri jun achi rubinan Simón. Y ja ri Satanás nibano che chi tujacha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ri Jesús can reta'n-wi chi ronojel jachon pa ruk'a' roma ri Dios ri Rutata', can reta'n-wi chuka' chi chiri' riq'uin ri Dios petenak-wi y chiri' chuka' nitzolaj chic e. ");
INSERT INTO cakNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Y ri Jesús xutanaba' can ri ruwa'in, xcataj y xulesaj can ri jun tziak ri ruk'u'n, xberuc'ama-pe jun toalla, y xuxim xe-rupa. ");
INSERT INTO cakNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Y xuya' chuka' ya' chupa jun palangana y xutz'om ruch'ajic ri cakan chijujun ri ru-discípulos, y nusula' ri cakan riq'uin ri toalla ri ruximon xe-rupa. ");
INSERT INTO cakNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Y cuando xapon riq'uin ri Simón Pedro chi nuch'aj ri rakan, ri Pedro xu'ij che ri Jesús: Ajaf, ¿can nach'aj chuka' wakan ren? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Y ri Jesús xu'ij che ri Pedro: Ri yinajin ren manak xta'an entender cami, pero chua'k-cabij can xta'an-wi entender. ");
INSERT INTO cakNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pero ri Pedro xu'ij: Ren man jun mej (bey) xtinya' ta lugar chawe chi xtach'aj ri wakan, xcha'. Y ri Jesús xu'ij che: Xa man naya' ta lugar chue, man xcac'ue' ta wiq'uin, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Romari' ri Simón Pedro xu'ij che ri Jesús: Ajaf, xa quiri', can tach'aja' chuka' ri nuk'a' y ri nujolon, y man xe ta ri wakan, xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Pero ri Jesús xu'ij che: Jun ri xatin yan, xe chic ri rakan tuch'aja' roma ri pokolaj; roma raja' can rujosk'in yan ri'. Rix can ch'ajch'oj chic ri ic'aslen, más que man chi'iwonojel ta, pero can ijosk'in chic iwi', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Raja' xu'ij quiri', roma can reta'n-wi ancu'x (anchique) ri xtic'ayin richi. Y romari' xu'ij: Man iwonojel ta ri ijosk'in-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Y cuando ri Jesús ruch'ajon chic cakan ri ru-discípulos, xberuc'ama' chic pe ri tziak ri ruch'ilon can chirij, xbech'oquie' chuchi' mesa y xu'ij: ¿Xiben entender anchique roma xinch'aj ri iwakan? ");
INSERT INTO cakNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Rix, ka-Maestro y Kajaf jixcha' chue. Can utz-wi, roma can quiri-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ren can jin i-Maestro y jin Iwajaf, y xinch'aj ri iwakan. Can quiri' chuka' tibana' rix, tich'ajla' iwakan chiwech ka rix. ");
INSERT INTO cakNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ren can xinc'ut yan can chiwech. Y can anche'l xin-en ren iwiq'uin, can quiri' chuka' tibana' rix quiq'uin ri ch'aka chic. ");
INSERT INTO cakNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ren can c'o-wi nuk'ij y xin-en ri samaj re'. Can quiri' chuka' tibana' rix, man tipokonaj niben ri samaj re'. Roma chech-ulef, man ja' ta ri samajel ri más c'o ruk'ij chech ri rajaf samaj; y jun ri nitak, man ja' ta ri' chuka' ri más c'o ruk'ij chech ri takayon-e richi. ");
INSERT INTO cakNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xa rix xitemaj can ronojel re' y can niben ri xitemaj, can quixquicot. ");
INSERT INTO cakNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Pero ren nin-ij chiwe, man jix nojel ta quiri' xtiben, roma ren can weta'n iwech rix ri xixincha'. Pero xixincha' roma nic'atzin chi nibanataj ri tz'iban can chupa rutzij ri Dios ri nu'ij: Ri jun ri can xwa' wiq'uin, xcataj chuij. Quiri' nu'ij chupa ri rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Re' nin-ij yan chiwe, chi quiri' cuando xtapon ri k'ij, xtinimaj chi can ja ren ri Cristo. ");
INSERT INTO cakNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Can ketzij-wi nin-ij chiwe, chi ri xtuc'on-ka rech ri nintak-e ren, can ja ren ri xquiruc'on-ka. Y ri xtuc'on-ka nuech ren, xa can xtuc'on-ka chuka' rech ri takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Y cuando ri Jesús xu'ij yan ronojel re', ri ránima can anchique la xuna' roma ri bis. Raja' can xuk'alajij ri anchique roma xpe bis pa ránima y xu'ij: Can ketzij nin-ij chiwe, chi jun chiwe rix nu-discípulos ri xtijacho wichi pa quik'a' ri winak ri man jinquijo' ta, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Y ri discípulos xquitzula-qui', y man niquiwil ta anchique niqui'ij; roma man quieta'n ta anchok chij xch'o'n-wi ri Jesús. Can man quieta'n ta ancu'x (anchique) ri xtic'ayin richi. ");
INSERT INTO cakNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Y ri jun chique ri discípulos, ri yalan nojo'x roma ri Jesús, rak'el-apo riq'uin ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Y che ri jun discípulo ri', xu'on-apo retal ri Simón Pedro. Raja' xu'ij-apo che chi tuc'utuj-apo che ri Jesús chi ancu'x (anchique) ri jun ri xtic'ayin richi, ri c'aja' oc nu'ij-ka chique. ");
INSERT INTO cakNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri discípulo ri' xrak'e-apo más chuc'u'x ri Jesús, y xuc'utuj che: Ajaf, ¿ancu'x (anchique) ri jun ri xtijacho awichi? xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Y ri Jesús can ja' xu'ij che ri discípulo ri': Ri anchok che xtinya-wi jun pedazo pan muban, jari' ri xtijacho wichi. Y raja' xumuba' ri jun pedazo pan y xuya' che ri Judas Iscariote ri ralc'ual ri achi rubinan Simón. ");
INSERT INTO cakNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Y cuando ri Judas Iscariote xutaj-ka ri pan ri', ja xoc ri Satanás pa ránima. Y ri Jesús xu'ij che: Ri anojin chic na'an, ch'anin tabana', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pero ri discípulos ri jec'o-apo chuchi' mesa riq'uin, man xqui'en ta entender anchique roma xu'ij-e quiri' che ri Judas. ");
INSERT INTO cakNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Jec'o xquinojij-ka chi xtak-e roma ri Jesús chulok'ic ronojel ri xtic'atzin chique chupa ri nimak'ej. Y jec'o ch'aka chic discípulos xquinojij chi xtak-e chi c'o ex nerusipaj can chique ri winak ri manak quibeyomal, roma reje' can quieta'n-wi chi ja ri Judas ri uc'uayon ri mero. ");
INSERT INTO cakNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ri Judas, can xe xuq'uis-e ri jun pedazo pan, can ja xel-e. Cuando xel-e raja', can chak'a' chic. ");
INSERT INTO cakNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Y cuando ri Judas elenak chic e, ri Jesús xu'ij: Ja' xoka ri k'ij chi ren ri jin-kajinak-pe chicaj y xinalex chi'icojol, xtik'alajin chi can c'o-wi nuk'ij. Y can quiri' chuka' ri Dios, can xtik'alajin ri ruk'ij woma ren. ");
INSERT INTO cakNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y roma ri Dios can xtik'alajin ri ruk'ij woma ren, raja' can xtu'on chi nik'alajin ri nuk'ij ren. Y ri' xa can ja yan nibanataj. ");
INSERT INTO cakNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Xe juba' chic tiempo ri xquic'ue' iwiq'uin rix ri can jix walc'ual. Rix can xquinicanoj-wi; pero cami can nin-ij can chiwe, anche'l ri nu'in chique ch'aka chic israelitas, chi ri anchi' xquibec'ue-wi ren, rix man xquixtiquier ta xquixapon chinucanoxic. ");
INSERT INTO cakNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cami ninya' jun c'ac'ac' mandamiento chiwe: Can anche'l jixinjo' ren, can quiri' chuka' tibana' rix. Can tijo-iwi' chi'iwonojel. Jare' ri c'ac'ac' mandamiento ri ninya' can chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Y xa xtijo-iwi' chi'iwonojel, ri winak can xtiquitemaj chi jix nu-discípulos ren, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Y ri Simón Pedro xu'ij che ri Jesús: Ajaf, ¿anchi' c'a jabe-wi? xcha'. Y ri Jesús xu'ij che: Cami man jatiquier ta chic yinatzeklebej ri anchi' xquibe-wi ren. Pero después can xcatiquier xquinatzeklebej-wi, xcha' che ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Y ri Pedro xu'ij che: Ajaf, ¿anchique roma man yitiquier ta jatintzeklebej cami? Roma xa nic'atzin chi can ninya' ri nuc'aslen awoma ret, can xtinya-wi, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Y ri Jesús xu'ij che: ¿Naya' como ri ac'aslen woma ren? Ren can ketzij-wi nin-ij chawe, chi c'a man jani titzirin-pe (tisiq'uin-pe) ri gallo, cuando ret oxi' yan mej (paj) ta'ij chique ri yec'utun chawe chi ret man aweta'n ta nuech, xcha' ri Jesús che ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Man tuch'ujrisaj-ri' ri iwánima, xcha' ri Jesús chique ri ru-discípulos. Ren can weta'n chi iyo'n iwánima riq'uin ri Dios. Can quiri' chuka' tibana' wiq'uin ren. Can tiya' chuka' iwánima wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Pa rocho ri Nata' Dios q'uiy lugar c'o. Y xa man ta quiri', xin-ij yan ta chiwe. Cami yibe chi nenbana' ru'onic ri i-lugar chicaj riq'uin ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Jari' nenbana', y can xquipe chic y xquixinc'uaj wiq'uin; chi quiri', anchi' xquic'ue-wi ren, chiri' chuka' xquixc'ue-wi rix. ");
INSERT INTO cakNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Rix can iweta'n anchi' yibe-wi ren, y chuka' can iweta'n ri bey, xcha' ri Jesús chique ri ru-discípulos. ");
INSERT INTO cakNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Y ri discípulo ri rubinan Tomás xu'ij che ri Jesús: Ajaf, roj man keta'n ta anchi' jabe-wi ret. ¿Anche'l c'a xtakatemaj anchique bey xtakac'uaj? ");
INSERT INTO cakNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Y ri Jesús xu'ij: Ja ren ri bey, ja ren ri ketzij, y ja ren chuka' ri c'aslen. Man jun xtitiquier xtapon riq'uin ri Nata' xa manak jinruniman. ");
INSERT INTO cakNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Y xa rix xitemaj nuech ren, can xitemaj chuka' rech ri Nata'. Y cami can itz'eton chic, y chuka' iweta'n rech, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Y chuka' jun chic chique ri discípulos, ri rubinan Felipe xu'ij che ri Jesús: Ajaf, tac'utu' ri Atata' Dios chakawech, y xe riq'uin ri' más xtakanimaj, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Y ri Jesús xu'ij che: C'o yan q'uiy tiempo ri jinc'o-pe iwiq'uin ¿y man aweta'n ta nuech, ret Felipe? Ri tz'eteyon wichi, rutz'eton chuka' ri Nata'. ¿Anchique roma ret na'ij chi tinc'utu' ri Nata' chiwech? ");
INSERT INTO cakNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Man nanimaj ta ret chi ri Nata' c'o wiq'uin ren y ren jinc'o riq'uin raja'? Ri tzij ri xenk'alajij chiwech, can riq'uin ri Nata' petenak-wi, roma can wiq'uin ren c'o-wi. Can ja raja' ri nibano ri samaj re'. ");
INSERT INTO cakNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Can tinimaj ri nin-ij, chi ren jinc'o riq'uin ri Nata' y raja' c'o wiq'uin ren. Y xa man yininimaj ta roma ri nin-ij chiwe, titzu' c'a ri nusamaj y quininimaj. ");
INSERT INTO cakNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Can ketzij ri nin-ij chiwe: Ri can nuya' ránima wiq'uin, can xquieru'on chuka' ri samaj ri xin-en ren; can más nimalaj tak samaj xquieru'on, roma yibe chi yibec'ue' chila' chicaj riq'uin ri Nata', ");
INSERT INTO cakNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","y ronojel ri xtic'utuj pa nubi' ren, can xtinya-wi. Chi quiri' nik'alajin ri ruk'ij ri Nata' woma ren. ");
INSERT INTO cakNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Xa c'o ri xtic'utuj pa nubi' ren, can xtinya-wi-pe chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Xa can yinijo', can tibana' ronojel nu-mandamientos. ");
INSERT INTO cakNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Y ren xtinc'utuj che ri Nata', y raja' can xtutak-pe jun chic ri can xtito'n iwichi. Jun ri can xtic'ue-wi iwiq'uin chi ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Y ri' ja ri Espíritu Santo ri jixrutijoj riq'uin ri ketzij. Y raja' manak modo chi nic'on-ka coma ri winak ri man quiniman ta ri Dios. Roma ri Espíritu Santo xa man nitz'etetaj ta, ni man quieta'n ta chuka' rech. Pero rix ri can iniman chic, can iweta'n chic rech, roma raja' can c'o chi'icojol y can xtic'ue' pa tak iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Ren yibe, pero man xquixinya' ta can iyon anche'l jun meba', roma xa can yipe chic iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ri winak ri man quiniman ta ri Dios xe chic juba' xquinquitzu', pero rix can xquinitzu' chic. Y roma ren can c'o nuc'aslen, rix chuka' xtic'ue' ic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Y chupa ri k'ij ri' xtik'alajin utz chiwech chi ren can jinc'o-wi riq'uin ri Nata', rix jixc'o wiq'uin ren y ren iwiq'uin rix. ");
INSERT INTO cakNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ri can c'o ri nutzij pa ránima y can yeru'on ronojel ri mandamientos ri yenbij, can yirojo-wi. Y ri can yirojo' ren, can xtojo'x roma ri Nata', y ren chuka' can xtinjo' y xtink'alajij-wi' chech, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Y ri Judas ri jun chique ri ru-discípulos, pero man ja' ta ri Iscariote, xuc'utuj che ri Jesús: Ajaf, ¿anchique roma xe chakawech roj nak'alajij-awi'? ¿Y man nak'alajij ta awi' chiquiwech ri winak ri man quiniman ta ri Dios? ");
INSERT INTO cakNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Y ri Jesús xu'ij che: Ri can yirojo', can nu'on ri nu'ij ri nutzij che. Ri jun ri xtibano quiri', can xtojo'x roma ri Nata' chuka'. C'ajari' ri Nata' y ren can xkojpe riq'uin y xtaka'an kocho pa ránima. ");
INSERT INTO cakNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ri man yirojo' ta, man nu'on ta ri nu'ij ri nutzij che. Y ri tzij ri ic'oxan wiq'uin ren, man wichi ta ren; can ja ri Nata' ri takayon-pe wichi, ja raja' ri yoyo'n-pe ri tzij re' chue. ");
INSERT INTO cakNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Y ronojel ri tzij re', can jenuk'alajin-pe chiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Y cuando ren manak chic xquic'ue' iwiq'uin, ri Nata' xtutak-pe ri Espíritu Santo chi jixruto'. Y ja raja' ri xtic'ue' iwiq'uin pa nuq'uiexel. Y raja' chuka' xquixrutijoj y xtunataj chiwe ronojel ri tzij ri jenu'in can ren chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ri uxlanen ri c'o wiq'uin ren, ninya' can chiwe. Ri uxlanen ri ninya' can ren pa tak iwánima, man anche'l ta oc ri uxlanen ri niquisuj ri winak ri man quiniman ta ri Dios. Can man tuch'ujrisaj-ri' ri iwánima, y man tixi'j-iwi' chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Xic'oxaj ri xin-ij yan chiwe: Ren can xquibe-wi, pero yitzolaj chic pe iwiq'uin. Y xa ta yinijo', niquicot ta iwánima, roma ren can riq'uin ri Nata' yitzolaj-wi-e. Raja' c'o más ruk'ij chinuech ren. ");
INSERT INTO cakNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Re' ninya' yan can rutzijol chiwe, chi quiri' cuando xtapon ri k'ij ri', xtinimaj-wi ri nu'in can chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Y cami xa man q'uiy ta chic ri tzij ri xtin-ij can chiwe, roma ri tiempo xa man q'uiy ta chic. Ri Satanás ri rajawal ri rech-ulef xa nuk'alajij yan pe ri'. Raja' man jun ruk'a' chuij. ");
INSERT INTO cakNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Pero ren can nin-en ri nrojo' ri Nata', chi quiri' ri winak chech-ulef tiquitzu' chi ren can ninjo' ri Nata'. Quixcataj y kojel-e we', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","C'ajari' ri Jesús xu'ij: Ja ren ri ketzij mata uva, y ri Nata' jari' ri nisamajin richi ri uva re'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Cuando jun mata uva jec'o ruk'a' ri man niquiya' ta quiwech, ye'leses-e. Y ri ruk'a' ri can niquiya' quiwech, yejosk'is utz, chi quiri' niquiya' más quiwech. Can quiri' chuka' ren. Ri Nata' yerutzu' conojel ri jec'o wiq'uin y yerulesaj-e ri man niwachin ta quic'aslen. Y ri niwachin ri quic'aslen, yerujosk'ij más chi quiri' niwachin más quic'aslen. ");
INSERT INTO cakNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Rix ri can nuk'alajin ri tzij chiwech, can jix ch'ajch'oj chic roma ri tzij re'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Can siempre quixc'ue' wiq'uin, chi quiri' ren can yic'ue' chuka' iwiq'uin. Roma ri ruk'a' ri uva man nuya' ta rech, xa man c'o ta chirij ri rakan. Xa can nic'atzin chi ri ruk'a' ri uva nic'ue' chirij ri rakan, chi quiri' nuya' rech. Can quiri' chuka' rix, can nic'atzin chi siempre quixc'ue' wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Ja ren ri mata uva, y ja rix ri ruk'a'. Ri can siempre c'o wiq'uin y ren riq'uin raja', ri ruc'aslen can xtiwachin. Roma ri man c'o ta wiq'uin, man jun ri xtitiquier xtu'on. ");
INSERT INTO cakNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ri man nic'ue' ta wiq'uin, xtu'on anche'l ri ruk'a' uva ri man niquiya' ta quiwech. Ye'leses-e, y cuando je chaki'j chic, yebemol-pe, yeq'uiak pa k'ak', y chiri' yec'at-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Pero xa rix can xquixc'ue' wiq'uin, y xtiben ri nin-ij chiwe; can tic'utuj che ri Dios ri nurayij ri iwánima, y can xtibanataj. Ri Dios can xtuya-pe chiwe ri nic'utuj. ");
INSERT INTO cakNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Xa niwachin utz ri ic'aslen, can k'alaj-wi chi can ketzij jix nu-discípulos. Y romari' ri xquietz'eto iwichi, can xtiquiya' ruk'ij ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Can anche'l yirojo' ri Nata' Dios, can quiri' chuka' jixinjo' ren. Can siempre quixc'ue' wiq'uin chi quiri' can xquixinjo' ronojel tiempo. ");
INSERT INTO cakNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Y xa rix niben ri nin-ij chiwe, xquixc'ue' wiq'uin roma can siempre xquixinjo'. Anche'l ri nubanon ren riq'uin ri Nata', ren can nin-en ri nu'ij raja', romari' yalan yirojo'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Y ronojel ri nu'in chic chiwe, xenbij chi quiri' niquicot ri iwánima, can anche'l yiquicot ren. Y can ta riq'uin ronojel iwánima xquixquicot c'a. ");
INSERT INTO cakNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Y ren ninchelebej chiwe chi can tijo-iwi', can anche'l jixinjo' ren. ");
INSERT INTO cakNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Roma ri jun ri can nuya' ri ruc'aslen pa quiq'uiexel ri je ru-amigos, k'alaj chi can yerojo' riq'uin ronojel ránima; y can man jun chic winak c'o ri yerojo' más que chech ri jun ri nu'on quiere'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y rix can jix nu-amigos, xa niben ronojel ri nin-ij ren chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Roma ren can jix nu-amigos nubanon yan chiwe, roma can ronojel ri ruk'alajin ri Nata' chue, ren can xink'alajij chuka' chiwe rix. Man jix nusamajel ta chic. Roma jun samajel man reta'n ta anchique nunojij ri ru-patrón. Ren man quiri' ta chic nubanon chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ri xcha'on iwichi rix, ja ren, y man ja' ta rix ri xixcha'on wichi ren. Y ren xixincha' chi jixintak chi niben ri nusamaj y chuka' chi niwachin utz ri ic'aslen, y re' can chi ronojel tiempo; chi quiri' ri anchique xtic'utuj che ri Nata' pa nubi', raja' can xtuya-pe chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Can ninchelebej c'a chiwe, chi can tijo-iwi'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Y xa itzel jixtz'et coma ri winak ri man quiniman ta ri Dios, toka pa iwi' chi can man xe ta chiwe rix quiri' ni'an, xa can quiri' chuka' quibanon-pe chue ren. ");
INSERT INTO cakNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xa ta rix jix junan quiq'uin ri winak ri man quiniman ta ri Dios, can jixquijo' ta. Pero cami itzel jixquitzu', roma man jix junan ta chic quiq'uin, y roma ja ren xicha'on-pe iwichi chiquicojol reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Can toka pa iwi' chi we' chech-ulef man ja' ta ri samajel ri más c'o ruk'ij chech ri rajaf ri samaj. Y xa ren ri jin Iwajaf, itzel yitz'et coma ri winak y man utz ta ri niqui'en chue, rix chuka' can quiri' xti'an chiwe. Y xa can quibanon-pe ri nu'ij ri nutzij, can xtiqui'en chuka' ri ni'ij rix chique. ");
INSERT INTO cakNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero ronojel re' can xtiqui'en chiwe roma man quieta'n ta rech ri Dios ri takayon-pe wichi. Can itzel jixquitzu', roma wiq'uin ren iyo'n iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Y xa man ta xipe ren chech-ulef chi xonk'alajij-ka ri nutzij, manak ta k'alaj chi can c'o quimac. Pero cami, roma ren can xipe chech-ulef, reje' can manak xquietiquier xtiqui'ij chi can man jun quimac. ");
INSERT INTO cakNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ri can itzel yetz'eto wichi, can man xe ta ren ri itzel jinquitzu', xa can quiri' chuka' niqui'en che ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ren jenubanon nimalaj tak samaj ri man jun banayon chiquiwech. Y reje' xquitzu' ri samaj re', pero man jinquiniman ta. Xa itzel jinquitzu' y chuka' itzel niquitzu' ri Nata'. Y romari' man jun xti'in chi manak rumac. ");
INSERT INTO cakNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ronojel re' can nibanataj, roma can quiri' ri tz'iban can chupa ri rutzij ri Dios ri yo'n chique. Chupa ri rutzij ri Dios, can nu'ij: Itzel xinquitzu', más que man jun numac. Quiri' nu'ij chupa ri rutzij ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Pero cuando ren xquitzolaj chic chila' riq'uin ri Nata', xtintak-pe ri Espíritu Santo ri xtito'n iwichi, y raja' can xquiruk'alajij, y chuka' xquixrutijoj riq'uin ri ketzij. Y raja' riq'uin ri Nata' xtipe-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Y rix can xquinik'alajij chuka', roma can pa ruticribel-pe jixc'o-pe wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Y ronojel re' xin-ij chiwe, chi quiri' man jun chiwe rix ri xtitzak. ");
INSERT INTO cakNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Roma can xquixkotex-pe pa tak sinagogas, ri jay anchi' nitzijos-wi rutzij ri Dios. Y can xtapon-wi chuka' ri k'ij cuando ri winak xtiquinojij chi rusamaj ri Dios niqui'en roma jixquicamisaj. ");
INSERT INTO cakNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Quiere' xtiqui'en ri winak, roma can man quieta'n ta rech ri Nata' y man quieta'n ta chuka' nuech ren. ");
INSERT INTO cakNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Can ronojel re' nin-ij can chiwe, chi quiri' cuando xtapon ri k'ij, man xti'ij ta chi ren man xinya' ta rutzijol chiwe. Y xtoka pa iwi' chi can ketzij-wi ri xin-ij can chiwe. Ronojel re' man jenu'in ta chiwe antes, roma can jinc'o-pe iwiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Pero cami, can ja' yibe riq'uin ri takayon-pe wichi. Y man jun chiwe rix nic'utun-pe chue: ¿C'a anchi' c'a xcatapon-wi? ");
INSERT INTO cakNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Pero rix man jun nic'utuj chue, xa nojinak ri iwánima riq'uin bis, roma ri xin-ij chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero ren can ketzij ri nin-ij chiwe: Can utz nu'on chiwe chi yibe yan; roma xa manak xquibe, manak xtoka ri Espíritu Santo ri nito'n iwichi. Pero xa yibe yan, can ja' nintak-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Y cuando xtoka ri Espíritu Santo, can xtuk'alajij chiquiwech ri winak ri man quiniman ta ri Dios chi can c'o-wi quimac, chi can c'o jun chojmilaj bey chi c'aslen, y chi ri Dios can xquieru'on juzgar ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Raja' xtuk'alajij chiquiwech ri winak chi can c'o quimac, roma man jinquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Can ja ri chojmilaj bey chi c'aslen ri xtuk'alajij chiquiwech, roma ren riq'uin ri Nata' yinapon-wi. Y rix man xquinitzu' ta chic. ");
INSERT INTO cakNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Y chuka' raja' can xtuk'alajij chi ri Dios can xquieru'on juzgar ri winak, roma cami ri Satanás, ri rajawal ri rech-ulef x-an yan juzgar. ");
INSERT INTO cakNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Can c'a q'uiy ri man nin-ij ta can chiwe, roma cami can man jixtiquier ta niben entender. ");
INSERT INTO cakNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Pero cuando xtipe ri Espíritu Santo, can xquixrutijoj y xquixruc'uaj chupa ri ketzij. Raja' can man ruyon ta xtisamaj; roma ri tzij ri xtu'ij chiwe, can ja ri je-bin-pe che chicaj. Y romari' raja' xquieruk'alajij chiwe ri xquiebanataj chupa ri tiempo ri c'o chiwech apo. ");
INSERT INTO cakNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Y raja' can xtuya' nuk'ij ren; roma ronojel ri xtuk'alajij chiwech, can chuij ren y chirij ri nusamaj. ");
INSERT INTO cakNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Can ronojel ri c'o riq'uin ri Nata', can wichi ren chuka', y romari' ren xin-ij yan chi ronojel ri xtuk'alajij ri Espíritu Santo chiwech, can chuij ren y chirij ri nusamaj. ");
INSERT INTO cakNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Cami xe chic juba' tiempo xquinitzu', roma yibe; pero xtik'ax chic juba' tiempo, y ja xquinitzu' chic jun mej (bey); c'ajari' xquitzolaj chic chila' riq'uin ri Nata' Dios, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Y jujun chique ri ru-discípulos xquic'utula' chiquiwech: ¿Anchique c'a ri xrojo' xu'ij chake riq'uin ri tzij ri xeru'ij? Cami xe chic juba' tiempo xquinitzu', roma yibe; pero xtik'ax chic juba' tiempo, y ja xquinitzu' chic jun mej (bey); c'ajari' yitzolaj chic chila' riq'uin ri Nata' Dios, xecha' ri discípulos chiquiwech. ");
INSERT INTO cakNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ri discípulos niqui'ij chuka' chiquiwech: ¿Anchique c'a nrojo' nu'ij ri rutzij, xe chic juba' tiempo? Xa man yeka'an ta entender ri rutzij, yecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Y ri Jesús can ch'anin xuna'ej chi ri ru-discípulos c'o ri niquijo' niquic'utuj che, romari' raja' xu'ij: Rix nijo' nina'ej anchique ri xin-ij, chi cami xe chic juba' tiempo xquinitzu', roma yibe; pero xtik'ax chic juba' tiempo, y ja xquinitzu' chic jun mej (bey). ");
INSERT INTO cakNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Can ketzij nin-ij chiwe: Rix can xquixok' y xquixbison roma ronojel ri xti'an chue ren. Pero ri winak ri man quiniman ta ri Dios xquiequicot romari'. Pero más que rix nim ri bis ri c'o pa tak iwánima, ri bis xa xtijalataj, y pa ruq'uiexel ri bis xa xquixquicot. ");
INSERT INTO cakNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ri bis ri' junan riq'uin ri ruquiy ri nuna' jun ixok cuando napon ri k'ij chi nic'ue' ral. Cuando ri ac'ual xalex yan, ri te'j ri' man noka ta chic pa ruwi' anchique sufrimiento ri xuk'axaj, xa yalan niquicot yan chic roma xalex jun chic ac'ual chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Quiri' chuka' rix, cami c'o bis pa tak iwánima, pero xa can yipe chic jun mej (bey) iwiq'uin chi jixontzu-ka. Y cuando xquipe iwiq'uin, ja' xtiquicot chic jun mej (bey) ri iwánima, y ri' can man jun xtitiquier xtilesan pa tak iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Y chupa ri k'ij ri', man chue ta ren xtic'utuj-wi ronojel ri nirayij. Pero can ketzij nin-ij chiwe, chi ronojel ri xtic'utuj che ri Nata' pa nubi' ren, raja' can xtuya-wi-pe chiwe. ");
INSERT INTO cakNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Y c'a cami can man jun ex ic'utun che ri Nata' pa nubi'. Can tic'utuj c'a, y xtiyo'x chiwe ri nic'utuj. Chi quiri' can utz xtiquicot ri iwánima. ");
INSERT INTO cakNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Ronojel ri nu'in chic chiwe, can cuesta chi niben entender, pero xtoka ri k'ij cuando man quiri' ta chic xquich'o'n iwiq'uin. Xa can k'alaj chic ri rubixic xtin-en chiwe chirij ri Nata' Dios. ");
INSERT INTO cakNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Y chupa ri k'ij ri', can pa nubi' ren xtic'utuj che ri Nata', y raja' can xtuya-pe chiwe ri nic'utuj che. Y can man ja' ta chic ren xquic'utun pa iq'uiexel che ri Nata'. ");
INSERT INTO cakNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Roma ri Nata' can xtuya' chiwe ri nic'utuj che, roma yalan jixrojo'. Y raja' yalan jixrojo', roma rix yinijo' ren y ninimaj chi ren riq'uin raja' jin-petenak-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Can riq'uin ri Nata' Dios jin-petenak-wi, chi xinoka chech-ulef. Y cami can riq'uin raja' yitzolaj-wi, y ninya' can ri rech-ulef, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Y ri ru-discípulos xqui'ij che: Can ketzij-wi chi cami man cuesta ta chic naka'an entender ri xa'ij, cami xa can k'alaj ronojel ri xa'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Cami naka'an entender chi ret can ronojel natzu' y ronojel chuka' aweta'n. Man nic'atzin ta chi c'o anchique nakac'utuj chawe, roma can aweta'n ri nakanojij. Y romari' roj can nakanimaj-wi chi riq'uin ri Dios jat-petenak-wi, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Y ri Jesús xu'ij chique ri discípulos: ¿Can ninimaj cami? ");
INSERT INTO cakNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Roma can ketzij nin-ij chiwe chi ri jun k'ij ri' can nipe-wi, y can hora chic, chi rix xtitaluj-e-iwi' y xa xquiniya' can nuyon ren. Pero can man nuyon ta chuka' xquic'ue' can, roma ri Nata' can c'o-wi wiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Y ronojel re', can xink'alajij yan can chiwe, chi can c'o ta ri uxlanen pa tak iwánima. Y ri uxlanen ri' xtic'ue' pa tak iwánima, xa can iyo'n iwánima wiq'uin. Y nin-ij can chuka' chiwe, chi can xtiwil-wi sufrimiento pa ic'aslen. Pero roma ren xich'acon yan chirij ri Satanás ri rajawal ri rech-ulef, romari' can tic'ue' iwuchuk'a'. ");
INSERT INTO cakNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Y cuando ri Jesús ru'in chic ronojel re', xtzu'n chicaj chi xu'on orar, y xu'ij: Nata' Dios, ri nu-hora can ja' xapon. Cami can tabana' chue ren ri Awalc'ual chi nik'alajin ri nuk'ij; chi quiri', ren ri Awalc'ual can ja' chuka' xtin-en awiq'uin ret, chi can xtik'alajin ri ak'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Roma can ajachon-pe uchuk'a' pa nuk'a' chi can yic'ue' pa quiwi' conojel winak y chi ninya' ri c'aslen ri man niq'uis ta chique ri winak ri can je'ayo'n chic chue. ");
INSERT INTO cakNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Y ri c'aslen ri man niq'uis ta, ja ri niquitemaj awech ret Nata' Dios y chuka' niquitemaj nuech ren. Roma ja ret ri ketzij Dios y man jun chic Dios c'o, y ja ren ri Jesucristo ri xinatak-pe chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Roma ri samaj ri xin-en we' chech-ulef, xk'alajin ri ak'ij. Y xinq'uis yan chuka' ronojel ri samaj ri acheleben-pe chue. ");
INSERT INTO cakNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cami c'a, Nata' Dios, can tabana' chi nic'ue' chic jun mej (bey) ri nuk'ij awiq'uin, chicaj. Can anche'l ri nuk'ij ri xc'ue' na'ey cuando xic'ue' awiq'uin cuando c'a man jani c'o ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Roma ri achi'a' ri can je'acha'on chic pe ret chiquicojol ri quiyo'n cánima riq'uin ri rech-ulef, chue ren xe'aya-wi cami, y ren can xatink'alajij chiquiwech. Ri achi'a' re', can je awichi ret, romari' xe'aya' chue ren. Y reje' can quichajin ri atzij. ");
INSERT INTO cakNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ri achi'a' re', chuka' can quieta'n chic chi ronojel ri ayo'n-pe chue, can ja ret ri xayo'n-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Roma can ja ri tzij ri ayo'n-pe chue chi nink'alajij, can jari' ri xink'alajij chiquiwech ri achi'a' re'. Y reje' can xquic'on-wi ri atzij pa tak cánima, y can xquitemaj-wi chi ketzij chi awiq'uin ret Nata' Dios jin-petenak-wi. Can xquinimaj chi ja ret ri jat-takayon-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Can ninc'utuj chawe pa quiwi' reje' cami, y man pa quiwi' ta ri winak ri man jatquiniman ta. Can pa quiwi' ri achi'a' ri xe'aya' chue ninc'utuj chawe, roma can je awichi ret chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Y conojel ri can je wichi ren, can je awichi ret chuka', y ri je awichi ret, can je wichi ren chuka'. Y ren can xk'alajin yan ri nuk'ij, coma ri achi'a' ri xe'aya' chue. ");
INSERT INTO cakNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Lok'olaj Nata' Dios, pa ak'a' yenjach-wi can ri achi'a' ri xe'aya' chue. Quie'achajij, chi quiri' can junan ta cánima y xe jun ta niqui'en. Can niqui'en ta anche'l kabanon roj, roma roj can xe jun kabanon. Can quie'achajij c'a, roma reje' c'a yec'ue' can chech-ulef, y ren xa can yitzolaj yan e awiq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Y ren, can jenuchajin-pe ri achi'a' ri xe'aya' chue. Ri tiempo ri xic'ue-pe quiq'uin chech-ulef, can xenchajij riq'uin ri awuchuk'a'. Y can man jun ri xsatz (xsach) can chique, can xe ri jun ri can itzel xu'on y ja ri camic xucha'; chi nibanataj anche'l ri tz'iban can chupa ri atzij. ");
INSERT INTO cakNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ren, can ja' yitzolaj awiq'uin, Nata' Dios, pero roma c'a yic'ue' na juba' chech-ulef, ninc'utuj chawe pa quiwi', roma ninjo' chi utz niquicot can ri cánima. Can anche'l yiquicot ren. ");
INSERT INTO cakNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ri achi'a' ri xe'aya' chue, can nuyo'n-wi ri atzij chique. Romari' ri winak ri man jatquiniman ta, can itzel xequitzu'; roma ri achi'a' ri xe'aya' chue, man je richi ta chic ri rech-ulef. Reje' can je anche'l chic ren, roma ren man jin richi ta ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Man ninc'utuj ta chawe chi quie'alesaj-e chech-ulef. Ri ninc'utuj chawe, xe chi quie'ato' chech ri Satanás y man taya' lugar chi yeruch'ec. ");
INSERT INTO cakNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ri achi'a' ri xe'aya' chue, can man je richi ta ri rech-ulef. Can je anche'l ren. Ren man jin ta richi ri rech-ulef chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Can tabana' chique chi niquijach-qui' más chupa ri atzij. Ri atzij jari' ri ketzij. ");
INSERT INTO cakNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Y can anche'l ri xa'an-pe chue ren chi xinatak-pe chi nin-en ri asamaj chech-ulef, can quiri' chuka' nin-en ren chique ri achi'a' ri xe'aya' chue. Can jenutakon-wi chi niqui'en ri asamaj chech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Coma reje', ren can ninjach-wi' pa ak'a', chi quiri' jari' niqui'en reje' chuka'. Can tiquijacha-qui' pa ak'a' chi yec'ue' chupa ri ketzij. ");
INSERT INTO cakNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Nata' Dios, ren man xe ta pa quiwi' ri achi'a' xe'aya' chue ninc'utuj chawe, xa can quiri' chuka' ninc'utuj chawe pa quiwi' conojel ri xquieniman wichi; ri can xquinquinimaj roma ri tzij ri xtitzijos chique; ");
INSERT INTO cakNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","chi conojel can junan ta cánima. Can xe ta jun xtiqui'en, can anche'l kabanon roj. Roma ret Nata' Dios can jatc'o wiq'uin, y ren can jinc'o awiq'uin ret. Quiri' ninjo' chi niqui'en ta reje' kaq'uin roj. Y quiri' can ta nik'alajin chiquiwech ri winak ri man jatquiniman ta, chi ren, can ja ret ri xatako-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ren can xinya' yan chique ri ayo'n-pe ret chue. Reje' c'o chic quik'ij chuka', anche'l ri abanon-pe chue ren; chi quiri' can xe ta jun xtiqui'en, anche'l kabanon roj; roma roj xe jun kabanon. ");
INSERT INTO cakNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Can xquic'ue-wi quiq'uin reje' y ret wiq'uin ren, chi quiri' reje' can xe jun xtiqui'en. Y coma reje' ri winak ri man jatquiniman ta, xtiquitemaj chi ren can ja ret Nata' Dios ri xatako-pe wichi. Y romari' chuka' xtiquitemaj ri winak chi can ye'ajo-wi, anche'l yinajo' ren. ");
INSERT INTO cakNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Nata' Dios, ren can ninjo' chi conojel ri je'ayo'n chue xquiebec'ue' ta wiq'uin chicaj, chi niquitzu' ta ri nuk'ij ri ayo'n, roma xinajo' yan cuando c'a man jani c'o ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nata' Dios, ret ri jat choj riq'uin ronojel, ri winak ri man jatquiniman ta man quieta'n ta awech. Pero ren, can weta'n awech, y ri achi'a' ri xe'aya' chue, can xquitemaj chuka' chi ja ret ri xatako-pe wichi. ");
INSERT INTO cakNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Can xatink'alajij chiquiwech, y can xcatink'alajij más; chi quiri' can anche'l yinajo' ren, can quiri' chuka' xquie'ajo' reje', y chuka' ren can xquic'ue' ta quiq'uin reje'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Y cuando ri Jesús ru'in chic ronojel re', raja' y ri ru-discípulos xe'el-pe, y xquik'axaj ri rakan-ya' co'l oc ri ni'ix Cedrón che, y xe'oc-apo pa jun ulef ri c'o chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri Judas ri nijacho richi ri Jesús, can reta'n anchi' c'o-wi ri ulef ri anchi' xe'apon-wi ri Jesús y ri ru-discípulos, roma ri Jesús q'uiy mej (paj) jeruc'uan ri ru-discípulos chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Romari' ri Judas chupa ri lugar ri' xeruc'uaj-wi q'uiy soldados y jujun chique ri chajinel ri xequiya-e ri nimalaj tak sacerdotes y ri achi'a' fariseos. Ri soldados y ri chajinel can quic'ualo'n antorchas chi niquitzu' quibey y chuka' jequic'ualo'n ronojel ri yec'atzin chi ayowal. ");
INSERT INTO cakNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Y ri Jesús can reta'n-wi anchique ri xtibanataj riq'uin. Romari' can xeberuc'ulu' ri je-petenak y xuc'utuj chique: ¿Ancu'x (Anchique) nicanoj? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Reje' xqui'ij: Ri Jesús aj-Nazaret, xecha'. Y Jesús xu'ij chique: Ja ren ri', xcha'. Y ri Judas ri nijacho ri Jesús, can c'o-apo chuka' chiquicojol ri winak ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Y cuando ri Jesús xu'ij chique: Ja ren; ri winak xquijic'-qui' chiquij, y xetzak pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Y ri Jesús xuc'utuj chic jun mej (bey) chique: ¿Ancu'x (Anchique) ri nicanoj? xcha'. Y ri winak ri' xqui'ij chic: Ri Jesús aj-Nazaret, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Y ri Jesús xu'ij chique: Can xic'oxaj yan ri xin-ij chiwe chi ja ren. Y xa ja ren ri yinicanoj, tiya' lugar chique ri jec'o wiq'uin chi quiebe, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Quiri' xu'ij ri Jesús, chi quiri' nibanataj anche'l ri ru'in can. Raja' ru'in: Chique ri achi'a' ri xe'aya' chue, man jun xsatz can (xsach can) chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Pero ri Simón Pedro ruc'uan ru-espada, y xulesaj chi xuya' che ri jun rusamajel ri sacerdote ri más c'o ruk'ij. Ri Simón Pedro xulesaj ruxiquin derecha ri achi rubinan Malco. ");
INSERT INTO cakNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pero ri Jesús xu'ij che ri Simón Pedro: Tayaca' la espada; ¿ret nanojij chi roma la xa'an, ren can yicolotaj chech ri sufrimiento ri c'o chupa ri copa ri ruyo'n ri Nata' chue? xuche'x. ");
INSERT INTO cakNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Y can ja' xepe q'uiy soldados y ri qui-jefe, y ri chajinel ri jequiyo'n-pe ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, xquitz'om ri Jesús y xquixim-e. ");
INSERT INTO cakNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Na'ey xquic'uaj-e ri Jesús chech ri jun achi ri rubinan Anás, roma ri Anás rujinan ri Caifás. Y ri tiempo ri' ri Caifás jari' ri sacerdote ri más c'o ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Y can ja ri Caifás ri' ri biyon chique ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, más utz chi xe jun ri nicom pa quiq'uiexel conojel ri quiwinak. ");
INSERT INTO cakNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro y jun chic discípulo can jequitzekleben-e ri winak ri quic'uan ri Jesús, roma ja ri Jesús quitzekleben-e. Ri jun chic discípulo can etaman rech roma ri sacerdote ri más c'o ruk'ij, romari' choj xoc-apo chojay chi ri rocho ri sacerdote ri más c'o ruk'ij. ");
INSERT INTO cakNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pero ri Pedro man xoc ta apo, xa xc'ue' can chiri' chi-puerta. Y ri discípulo ri etaman rech roma ri sacerdote ri más c'o ruk'ij, xbe'el-pe y xch'o'n riq'uin ri ixok ri nuchajij ri puerta y xucusaj-apo ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Y ri ixok ri' xu'ij che ri Pedro: ¿Man ja' ta ret chuka' jun discípulo chi ri achi ri c'amon-pe? xcha' che. Pero raja' xu'ij: Ren man jin ta discípulo chi ri achi ri', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ri samajel ri jec'o chupa ri jay ri' y ri je chajinel ri xquic'om-pe ri Jesús, quiboxon jun k'ak' y je-pa'l-apo chech chi niquimak'-qui' roma ri tef. Y chuka' ri Pedro pa'l-apo chiquicojol, rumak'on-apo-ri' chuchi' ri k'ak'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri Anás ri sacerdote ri más c'o ruk'ij, c'o ri xuc'utuj-apo che ri Jesús, raja' xuc'utuj che chirij ri yetzekleben richi y chuka' xuc'utuj che chirij ri yeruc'ut chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Xpe ri Jesús xu'ij: Man weta'n ta anchique roma man ac'oxan ta, roma ren can k'alaj jin-ch'o'inak-wi chique conojel winak. Jin-ch'o'inak chiquiwech pa rocho ri Dios y pa tak sinagogas, ri jay anchi' niquimol-wi-qui' conojel ri kawinak israelitas chi niquic'oxaj ri rutzij ri Dios. Can k'alaj jin-ch'o'inak-wi chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Anchique roma ret xa chue ren nac'utuj-wi? Tac'utuj chique ri xec'oxan wichi. Tac'utuj chique anchique ri jenu'in. Y tatzu' na pe', reje' can quieta'n anchique ri nu'in ren chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Y cuando ri Jesús ru'in chic ka ri', jun chique ri chajinel ri c'o-apo chiri' chunakaj xupak' rupalaj ri Jesús y xu'ij che: ¿Anchique roma quiela' na'ij-apo che la sacerdote ri más c'o ruk'ij? ");
INSERT INTO cakNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Pero ri Jesús xu'ij che ri chajinel ri': Xa c'o jun tzij ri man ja' ta rubixic xin-en-apo che, tak'alajij anchique ri man utz ta ri xin-ij-apo. Y xa ronojel ri xin-ij-apo utz, ¿anchique roma xinach'ey? xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Y ri Jesús ximon xtak-e roma ri Anás c'a chech ri Caifás ri sacerdote ri más c'o ruk'ij chupa ri tiempo ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Y ri Pedro pa'l-apo chuchi' ri k'ak' numak'-ri'. Y jec'o ri xec'utun che: ¿Man jat ta jun ru-discípulo ri achi la'? xecha' che. Y raja' xa xrewaj, roma xu'ij: Ren man jin ta ru-discípulo la jun achi la', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Y jun chique ri rusamajel ri sacerdote ri más c'o ruk'ij, rach'alal juba' ri achi ri xleses ri ruxiquin roma ri Pedro, xuc'utuj che ri Pedro y xu'ij: ¿Man ja' ta ret ri xatintzu' ri jatc'o riq'uin ri Jesús chiri' anchi' xbekac'ama-pe? xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pero ri Pedro xrewaj chic jun mej (bey) chi raja' jun discípulo chi ri Jesús. Y ja' xbetzirin-pe (xbesiq'uin-pe) ri gallo. ");
INSERT INTO cakNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Y chiri' pa rocho ri Caifás c'o-wi ri Jesús chi ni'an juzgar. Raja' can poban-apo chech ri Caifás. Y chiri' xel-wi-e chi ne'jach pa ruk'a' ri Pilato ri gobernador, ri c'o pa ru-palacio. Y c'a cumaj yan cuando xbanataj ri'. Ri je-uc'uayon-apo ri Jesús man xe'oc ta apo ri pa palacio, chi quiri' man niquitz'iluj ta ri quic'aslen. Y chuka' chi quiri' reje' yetiquier niquitaj ri nitej chupa ri quinimak'ej ri ni'ix pascua che. ");
INSERT INTO cakNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Y ri Pilato xbe'el-pe y xuc'utuj chique ri je-uc'uayon-apo ri Jesús: ¿Anchique ri sujunic ri ic'amon-pe chirij ri jun achi re'? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Y ri winak ri je-uc'uayon-apo ri Jesús xqui'ij che: Xa ta ri achi re' manak ta rumac, man ta xokaya' chawech chi na'an juzgar, xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Y ri Pilato xu'ij chique: Tic'uaj chic e ri achi re' y tibana' juzgar rix anche'l ri nu'ij ri i-ley, xcha' raja'. Pero ri achi'a' ri can c'o quik'ij chiquicojol ri israelitas, xqui'ij che: Roj jojtiquier naka'an, pero man jun nic'atzin ri naka'ij chi ticamises chech cruz jun winak. ");
INSERT INTO cakNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Y can quiri' nibanataj anche'l ri ru'in chic ri Jesús, chi anchique modo xticamises. ");
INSERT INTO cakNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Y ri Pilato xoc chic apo ri pa ru-palacio. Y xroyoj ri Jesús y xuc'utuj che: ¿Ja ret ri qui-Rey ri israelitas? xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pero ri Jesús xu'ij che ri Pilato: ¿Ri nac'utuj chue, awiq'uin ret petenak-wi, o xa ch'aka chic winak ri xe'in chawe? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Y ja' cuando ri Pilato xu'ij che ri Jesús: Ren man jin israelita ta, romari' man jun anchique nu'on chue xa jat qui-rey o manak. Ja ri awinak y ri nimalaj tak sacerdotes ri xejacho awichi pa nuk'a'. ¿Anchique ch'a'oj abanon? ");
INSERT INTO cakNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Y ri Jesús xu'ij che ri Pilato: Ren man jin ta rey chi ri rech-ulef. Roma xa ta jin rey chi ri rech-ulef, ri winak ri yetzekleben wichi niqui'en ta ayowal, chi quiri' man yijach ta e pa quik'a' ri achi'a' ri c'o quik'ij chiquicojol ri nuwinak israelitas. Ren can man jin rey ta chi ri rech-ulef. ");
INSERT INTO cakNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Y ri Pilato xuc'utuj che ri Jesús: ¿Entonces ret can jat Rey-wi? xcha'. Y ri Jesús xu'ij che: Ja', can quiri-wi; ren can jin Rey-wi anche'l ri xa'ij. Can romari' xinalex chech-ulef y chi nink'alajij ri ketzij chiquiwech ri winak. Y conojel ri can yeniman ri ketzij, niqui'en-wi ri nin-ij ren chique, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Y ri Pilato xuc'utuj chic che ri Jesús: ¿Anchique ri' ri ketzij? Y cuando ru'in chic can quiri' che ri Jesús, raja' xel chic e chiri' pa palacio chi xbech'o'n chique ri winak israelitas y xu'ij chique: Ren man jun ch'a'oj ninwil chi rubanon ta ri jun achi re'. ");
INSERT INTO cakNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Pero juna-juna' chupa ri k'ij chi ri pascua, rix nic'utuj chue chi tinsk'opij-e jun chique ri jec'o pa cárcel. ¿Y cami anchique nijo'? ¿Nijo' chi ninsk'opij-e ri i-Rey rix israelitas? xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Pero ri winak ri', can riq'uin ronojel quichuk'a' xech'o'n chic apo che ri Pilato y xqui'ij: La achi la' manak nakajo' roj, ja ri Barrabás task'opij-e, xecha'. Y ri Barrabás xa jun achi elek'om. ");
INSERT INTO cakNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Y romari' ri Pilato, ri gobernador, xu'ij chi tich'ay ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Y ri soldados xquipach'uj jun k'ayis ri yalan ruq'uixal. Anche'l jun corona xqui'en che, y xquiya' pa rujolon ri Jesús. Y xquiya' chuka' jun tziak morado chirij ri Jesús, anche'l ri yequicusaj ri reyes. ");
INSERT INTO cakNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","C'ajari' ri soldados xqui'ij-apo che ri Jesús: ¡Can caquicot, ret qui-Rey ri israelitas! yecha' che. Y can xquipak'ala' rupalaj. ");
INSERT INTO cakNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri Pilato xel chic pe jun mej (bey) pa ru-palacio chi xoch'o'n chiquiwech ri winak, y raja' xu'ij chique: Titzu', ja' achi re' ninlesaj-pe chiwech, chi tina'ej chi raja' man jun ruch'a'oj ninwil, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Y cuando ri Jesús xbe'el-pe, rucusan ri anche'l corona ri banon che ri k'ayis ri q'uiy ruq'uixal, y ri tziak morado. Y ja' cuando ri Pilato xu'ij: Jare' ri achi, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Can xe xquitzu' ri Jesús, ri nimalaj tak sacerdotes y ri chajinel, can riq'uin ronojel quichuk'a' xech'o'n y xqui'ij: ¡Ticamises chech cruz! ¡Ticamises chech cruz! xecha'. Ja' cuando ri Pilato xu'ij chique: Ren man jun ch'a'oj ninwil chirij, chi nintak rucamisaxic chech cruz. Y xa jixtiquier niben juzgar rix chi nitak rucamisaxic chech cruz, to'ic'ama' c'a, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pero ri achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas, xqui'ij-apo che ri gobernador: Raja' nu'ij chi Ralc'ual ri Dios, romari' utz chi nicamises, roma can quiri' nu'ij ri ka-ley, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ri Pilato can ruxi'n yan ri', y cuando xuc'oxaj ri xqui'ij ri winak chi ri Jesús nu'ij chi Ralc'ual ri Dios, xuxi'j-ka más ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Romari' xoc chic apo pa ru-palacio y xuc'utuj che ri Jesús: ¿Anchi' cape-wi ret? xcha' che. Y ri Jesús man jun tzij xu'ij che. ");
INSERT INTO cakNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Romari' ri Pilato xu'ij che ri Jesús: ¿Anchique roma man jun anchique na'ij-pe chue? Ren, c'o ri xinc'utuj chawe. ¿Man aweta'n ta chi ren yitiquier jatin-en juzgar chi jacamises chech cruz y chi jatincol chuka'? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Y ri Jesús xu'ij: Man ta roma ri Dios ri c'o chicaj, manak ta jatiquier yinaben juzgar, y roma raja' xuya' lugar chawe, romari' can jatiquier yinaben juzgar. Y xa xquinatak pa camic, can c'o amac nawakalej, pero más nim rumac ri xjacho wichi pa ak'a', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Romari' ri Pilato, ri gobernador xutaj ruk'ij chi nucol ri Jesús. Pero ri winak israelitas xech'o'n riq'uin ronojel quichuk'a', y xqui'ij: Xa xtacol-e, jat ru-enemigo ri César. Roma xabachique (xama'anchique) ri ni'in chi raja' jun rey, can itzel nutzu' ri César, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Cuando ri Pilato xuc'oxaj ri tzij ri xqui'ij ri winak che, xuxi'j-ka-ri'. Y c'ajari' xu'ij chi tileses-pe ri Jesús. Y ri Pilato xbech'oquie-pe ri anchi' nu'on-wi juzgar; ri lugar ni'ix Empedrado che, y pa ch'abel hebreo ni'ix Gabata che. ");
INSERT INTO cakNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ri k'ij ri', ja' nitiquier-ka ri jun quinimak'ej ri israelitas, ri ni'ix pascua che, y romari' conojel winak niquinaba' yan ri xtic'atzin chique. Y pa nic'aj-k'ij la'k che ri k'ij ri' cuando ri Pilato xu'ij chique ri winak ri je-aponinak chiri': Ja' i-Rey re', xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pero ri winak ri quimolon-qui', riq'uin quichuk'a' xech'o'n-apo y xqui'ij: ¡Ticamises! ¡Ticamises chech cruz! xecha-apo. Y ri Pilato xu'ij chique: ¿Ja ri i-Rey ri nijo' chi nintak rucamisaxic chech cruz? Pero ri nimalaj tak sacerdotes xa xqui'ij-apo: Xe ri César ri ka-rey roj, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Romari' ri Pilato can xu'on ri xquic'utuj ri winak che. Xujach-e ri Jesús pa quik'a' ri xquiecamisan richi chech cruz, y reje' xquic'uaj-e. ");
INSERT INTO cakNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Y ri Jesús can rutelen-e ru-cruz, rutz'amon-e bey chi ne'camises chupa ri jun lugar rubinan Calavera. Pa ch'abel hebreo, Gólgota ni'ix che ri lugar ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Cuando xe'apon-e chiri' parui' ri juyu', xquibajij ri Jesús chech ri cruz. Y quiri' chuka' x-an chique je ca'i' chic achi'a'. Y pa quinic'ajal ri je ca'i' achi'a' ri' xc'ue-wi ri cruz ri anchi' xbajix-wi ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Y ri Pilato ri gobernador, c'o jun letrero xutz'ibaj-e, y xyo'x chutza'n ri ru-cruz ri Jesús. Ri letrero ri' nu'ij: Jesús aj-Nazaret, qui-Rey ri israelitas, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ri tzij ri', can je q'uiy winak yetz'eto can, roma ri lugar ri anchi' xbajix-wi ri Jesús chech ri cruz, xa can chunakaj ri tenemit Jerusalem c'o-wi. Y ri tzij ri', can pa oxi' ch'abel tz'iban-wi: Pa hebreo, pa griego y pa latín. ");
INSERT INTO cakNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Romari' ri nimalaj tak sacerdotes chiquicojol ri israelitas xbequich'ojij che ri Pilato: Man ta xatz'ibaj ri tzij nu'ij: Qui-Rey ri israelitas; roma xa man quiri' ta. Xa ja raja' ri x-in. Romari' tajala' y tatz'ibaj: Ja ren yi'in chi jin qui-Rey ri israelitas, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero ri Pilato xu'ij chique ri nimalaj tak sacerdotes ri': Ri xintz'ibaj yan, can nutz'iban chic. Man nic'atzin ta chi ninjal rubixic, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cuando ri soldados xquibajij yan ri Jesús chech ri cruz, xbequic'ama-pe ri rutziak ri Jesús y xquijach chiquiwech reje'. Quieji' xqui'en che, roma je quieji' reje'. Xe ri jun tziak ri ni'ix túnica che manak t'iso'n; xa quiemon y xe jun rech banon che. ");
INSERT INTO cakNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Romari' reje' xqui'ij chiquiwech: Man takaretz ri jun tziak re'. Xa kalesaj suerte chirij, chi quiri' xe jun ri nuc'uan-e, xecha' reje'. Ri xbanataj riq'uin ri rutziak ri Jesús, can tz'iban-wi can chupa rutzij ri Dios. Roma chupa ri rutzij ri Dios, nu'ij: Xequijachala' ri nutziak chiquiwech y chuka' xquilesaj suerte chirij. Y can quiri-wi xqui'en ri soldados. Can xbanataj-wi anche'l ri tz'iban can. ");
INSERT INTO cakNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chiri' chuxe' ri cruz ri anchi' bajin-wi ri Jesús, c'o-apo ri María ri rute' y jun chic ixok rach'alal ri rute'. Ri María raxayil ri achi rubinan Cleofas y ri María Magdalena jec'o-apo chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Y cuando ri Jesús xutzu-pe ri rute' y ri ru-discípulo ri can nrojo', xu'ij che ri rute': Ja awal la', xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","C'ajari' xu'ij chuka' che ri ru-discípulo: Ja ate' la', xcha' che. Y ri discípulo can xunimaj-wi, roma can ja' xc'ue-ka ri María pa rocho. ");
INSERT INTO cakNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Y ri Jesús can reta'n chic chi ronojel xc'achoj yan y can ja' nibanataj anche'l tz'iban can chupa ri rutzij ri Dios, romari' xu'ij: Nichake'j nuchi', xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Y chiri', can c'o-apo jun yacbel-ya' nojinak riq'uin jun ch'amilaj ruya'al-uva. Y ri soldados chupa ri' xquimuba-wi jun esponja, xquiya' chutza'n jun che' ni'ix hisopo che, y c'ajari' xquiya-e pa ruchi'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Y cuando ri Jesús xukum yan ka ri ch'amilaj ruya'al-uva, raja' xu'ij: Xc'achoj yan ronojel, xcha'. Xulucuba-pe ri rujolon. Y can ja' xujach ri ránima, y xcom-ka. ");
INSERT INTO cakNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ri k'ij ri', conojel winak israelitas niquinaba' yan ronojel ri nic'atzin chique, roma nitiquier yan ka ri jun nimalaj k'ij. Y romari' ri achi'a' ri can c'o quik'ij xebe riq'uin ri Pilato y xbequic'utuj favor che chi tu'ij chi tik'aj cakan ri jec'o chech ri cruz, chi quiri' ye'leses-e chiri'. Roma man utz ta chi ri achi'a' ri' yec'ue' chiri' chech ri qui-cruz chupa ri nimalaj k'ij, roma can pascua-wi y k'ij chi uxlanen. ");
INSERT INTO cakNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Y ri soldados can xe'apon quiq'uin ri jec'o chech qui-cruz, xquik'aj rakan ri na'ey y can quiri' chuka' xqui'en che ri jun chic. ");
INSERT INTO cakNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero cuando xe'apon riq'uin ri Jesús, man xquik'aj ta ri rakan, roma xquitzu' chi can caminak chic. ");
INSERT INTO cakNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Y más que xquitzu' chi ri Jesús xcom yan, jun chique ri soldados xuju' ri rutza'n ri ru-lanza pa ruc'alc'a'x ri Jesús, y can ja xbe'el-pe quic' y ya'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Y ri xtz'eto chi quiri' xbanataj, can nuk'alajij, y ri nuk'alajij raja' can ketzij-wi. Ri can rutz'eton y reta'n, can ketzij-wi ri nutzijoj chupa ri libro re', chi quiri' can chi'iwonojel ta rix ninimaj chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Roma ri xbanataj, can xbanataj chi quiri' ketzij ntel-wi ri nu'ij chupa ri rutzij ri Dios. Roma ri tz'iban can, nu'ij: Can man jun rubakil raja' ri xtiquik'aj. ");
INSERT INTO cakNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Y chuka' nu'ij: Can xtiquitzu-wi ri Jun ri xquisoc che lanza, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","C'ajari' c'o jun achi José rubi' ri aj-tenemit Arimatea. Raja' man ruk'alajin ta ri' chi runiman ri Jesús, coma ri ch'aka chic achi'a' ri can c'o-wi quik'ij chiquicojol ri israelitas. Y ja raja' xapon riq'uin ri Pilato ri gobernador, chi xberuc'utuj favor che chi tuya' ri ruch'acul ri Jesús che chi numuk. Y ri Pilato xuya' lugar che. Xpe ri José, xberukasaj-pe ri ruch'acul ri Jesús y xuc'uaj-e. ");
INSERT INTO cakNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Y chuka' ri Nicodemo, ri achi ri xapon riq'uin ri Jesús pa jun ak'a', xapon chupa ri hora ri', ruc'uan-apo mirra xolon riq'uin ch'aka chic quiwech jubulaj tak ak'om. Y xe chic juba' nrojo' chi nu'on jun quintal ronojel ri jubulaj tak ak'om ri jeruc'uan-apo. ");
INSERT INTO cakNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Ri José y ri Nicodemo xquibor (xquibotz) ri ruch'acul ri Jesús pa tziak ri can c'o jubulaj tak ak'om chirij. Reje' can quiri' xqui'en che ri ruch'acul ri Jesús, roma ri winak israelitas can quiri-wi niqui'en chique ri quicaminaki'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chupa ri lugar anchi' xbajix-wi ri Jesús chech ri cruz c'o jun ulef ticon rech. Y chiri' c'o jun jul ri man ucusan ta. Can man jun caminak ri yo'n chupa ri jul ri'. ");
INSERT INTO cakNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Y chiri' chupa ri jul ri' xquiya-wi ri ruch'acul ri Jesús, roma xkak'ij yan ka chiquiwech y ri jul ri' xa nakaj c'o-wi, y ri quinimak'ej ri israelitas, ri nimalaj k'ij, nitiquier yan ka; romari' ri winak niquinaba' yan ri xtic'atzin chique. ");
INSERT INTO cakNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Y chupa ri na'ey k'ij chi ri semana, ri domingo; ri María Magdalena xbe chuchi' ri jul. Can nimak'a' yan ri xbe. C'a k'eku'm cuando xbe. Y ja' xutzu' chi ri abaj ri anchok che tz'apin-wi can ri jul, xleses yan e. ");
INSERT INTO cakNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Raja' junanin xtzolaj y xbe riq'uin ri Simón Pedro y riq'uin chuka' ri jun chic discípulo ri yalan xojo'x roma ri Jesús. Ri María Magdalena xuya' rutzijol chique y xu'ij: Jec'o xe'lesan-e ri ruch'acul ri Ajaf Jesús pa jul, y cami man keta'n ta anchi' xbequiya-wi, xcha' raja'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ri Pedro y ri jun chic discípulo, can xe xquic'oxaj ri xu'ij ri María Magdalena chique, can ja' xe'el-e y xebe chuchi' ri jul. ");
INSERT INTO cakNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Junanin xebe ri je ca'i'. Y ri jun discípulo más anin xbin, romari' xuya' can ri Pedro, y jari' ri xapon na'ey chuchi' ri jul. ");
INSERT INTO cakNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ri discípulo ri' xluquie-ka chi ninachan-apo pa jul; y raja' xerutzu' ri tziak jec'o can chiri', pero man xoc ta apo pa jul. ");
INSERT INTO cakNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Y cuando ri Simón Pedro xapon, roma can tzakal-apo chirij ri discípulo ri xapon na'ey, ri Simón Pedro can choj xoc-apo pa jul, y xutzu' ri tziak ri jec'o can chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Pero ri tziak ri anchok che xxim can ri rujolon ri Jesús, juc'an chic c'o-wi banon can ru'onic. Can man junan ta c'o can quiq'uin ri ch'aka chic tziak. ");
INSERT INTO cakNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","C'ajari' xoc-apo chuka' ri jun chic discípulo, ri xapon na'ey chuchi' ri jul. Y cuando raja' oconak chic apo, xutzu' ronojel y xunimaj chi xc'astaj-wi-e. ");
INSERT INTO cakNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ri discípulos c'a xquitzu' na, c'ajari' xquinimaj; y man xqui'en ta entender ri nu'ij chupa ri rutzij ri Dios ri tz'iban can chirij ri Jesús, chi can nic'astaj na-wi chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Y ri ca'i' discípulos xetzolaj-e chi tak cocho. ");
INSERT INTO cakNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ri María Magdalena ntok' xc'ue' can chuchi' ri jul. Y cuando yalan ntok', xluquie-ka chi xnachan-apo chupa ri jul. ");
INSERT INTO cakNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Y xerutzu' ca'i' ángeles ri can sak quitziak. Jun ch'ocol ri anchi' xli'e-wi ri rujolon ri Jesús y ri jun chic ri anchi' xec'ue-wi ri rakan. ");
INSERT INTO cakNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Y ri ca'i' ángeles ri' xquic'utuj-pe che ri María Magdalena: ¿Anchique roma jatok'? xecha' che. Y raja' xu'ij chique: Ren yinok', roma xc'uax-e ruch'acul ri Wajaf Jesús y man weta'n ta anchi' xbeyo'x-wi, xcha' chique. ");
INSERT INTO cakNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Y cuando raja' ru'in chic ri tzij ri', xtzu'n chirij. Raja' can xutzu-wi chi c'o jun ri pa'l-apo chiri', pero man xutemaj ta rech chi ja ri Jesús ri c'o-apo chiri'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ja' cuando ri Jesús xuc'utuj che ri María Magdalena: ¿Ancu'x (Anchique) ri nacanoj y anchique roma chuka' yalan jatok'? xcha' che. Y ri María Magdalena xunojij chi ri nich'o'n-apo riq'uin ja ri nichajin ri ulef ri', romari' raja' xu'ij che: Xa ja ret ri xatuc'uan-e ri ruch'acul ri Wajaf Jesús, ta'ij chue anchi' xaya-wi, y ren xtincanoj anchi' xtinya-wi, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Pero ri Jesús xch'o'n chic che y xu'ij: María, xcha'. Y ri María Magdalena c'ajari' xuna'ej chi ja ri Jesús, romari' xutzalmayij-ri' y xu'ij che: Raboni, xcha'. Roma ri israelitas quiri' niqui'ij che jun maestro. ");
INSERT INTO cakNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Y ri Jesús xu'ij che ri María Magdalena: Man quinatz'om. Roma ren c'a man jani quibe riq'uin ri Nata' chila' chicaj. Pero abij chique ri wach'alal, chi ren can yibe riq'uin ri Nata', ri can Itata' chuka' rix. Can yibe riq'uin ri nu-Dios, ri i-Dios chuka' rix, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Y ri María Magdalena can xbe y xberu'ij chique ri discípulos chi xutzu' ri Ajaf Jesús, y chuka' xberu'ij chique ri bin-e che. ");
INSERT INTO cakNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Y cuando xcok'a-ka chupa ri k'ij ri', ri domingo ri na'ey k'ij che ri semana, ri discípulos quimolon-qui', y jequitz'apin ruchi' ri jay ri anchi' jec'o-wi; roma reje' can quixi'n-qui' chiquiwech ri israelitas, ri je quiwinak. Y cuando quitz'apin-qui' pa jay, c'aja' xquitzu' c'o chic ri Jesús pa quinic'ajal y xu'ij chique: Ja' ta ri uxlanen xtic'ue' pa tak iwánima chi'iwonojel, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Cuando raja' ru'in chic ri tzij ri' chique ri quimolon-qui' chiri', can xuc'ut chiquiwech ri ruk'a' y ri ruc'alc'a'x ri anchi' xsocotaj-wi. Y ri discípulos can xequicot-wi, roma xquitzu' chi can ja-wi ri Ajaf Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","C'ajari' ri Jesús can xu'ij chic jun mej (bey) chique ri ru-discípulos: Ja' ta ri uxlanen xtic'ue' pa tak iwánima chi'iwonojel. Cami can jixintak-e, anche'l xirutak-pe ren ri Nata', chi xin-en ri rusamaj. ");
INSERT INTO cakNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Y cuando ru'in chic ri tzij ri', raja' xeruxupuj y xu'ij chique: Can tic'ama' ri Espíritu Santo. ");
INSERT INTO cakNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Y xa rix can nicoch' (nicuy) rumac jun winak, can xticoch'otaj-wi (xticuyutaj-wi) rumac chuka' chech ri Dios. Y ri man xticoch' (xticuy) ta rix rumac, ri Dios chuka' man xtucoch' (xtucuy) ta rumac ri winak ri', xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Y ri Tomás, ri jun chique ri cablajuj ru-discípulos ri Jesús, ri ni'ix chuka' Dídimo che, xa man c'o ta quiq'uin ri ch'aka chic cuando ri Jesús xoka chiquicojol. ");
INSERT INTO cakNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Y romari' ri ch'aka chic discípulos xqui'ij che ri Tomás: Roj xkatzu' ri Ajaf Jesús, xecha' che. Pero raja' xa man xunimaj ta, xa xu'ij chique: Ren c'a tintzu' na ri anchi' xe'oc-wi ri clavos pa ruk'a', c'ajari' xtinnimaj. C'a tinju' na ri rui-nuk'a' pa tak qui-lugar ri clavos y chuka' pa ruc'alc'a'x anchi' xoc-wi ri lanza, c'ajari' xtinnimaj chi ja raja', xcha' ri Tomás. ");
INSERT INTO cakNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wakxaki' yan k'ij cuando ri discípulos xquitzu' ri Jesús. Reje' can quimolon chic qui' jun mej (bey), quitz'apin-qui' pa jay y c'o ri Tomás quiq'uin. Y ja' cuando xapon chic jun mej (bey), y ri ruchi-jay can je-tz'apel. Ri Jesús xapon c'a pa quinic'ajal y xu'ij chique: Ja' ta ri uxlanen xtic'ue' pa tak iwánima chi'iwonojel, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Y can ja' xu'ij che ri Tomás: Taju-pe ri rui-ak'a' we' y quie'atzu' ri nuk'a' je-socotajnak. Taya-pe la ak'a' pa nuc'alc'a'x y taju' anchi' xoc-wi ri lanza. Can tanimaj c'a, y man ta'an anche'l niqui'en ri ch'aka chic winak, ri man niquinimaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Y ri Tomás xu'ij che ri Jesús: Can ja ret ri nu-Dios y Wajaf, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Pero ri Jesús xu'ij che ri Tomás: C'a xinatzu' na, c'ajari' xanimaj. Can quiequicot ri man jinquitz'eton ta y jinquinimaj, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús can q'uiy milagros xeru'on, ri yek'alajin chi can ja-wi ri Dios takayon-pe richi, pero man ronojel ta tz'iban can chupa ri libro re'. Y ronojel re', can chiquiwech ri ru-discípulos xeru'on-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Y ri je-tz'iban can chupa ri libro re', can je-tz'iban can chi quiri' rix tinimaj chi ri Jesús jari' ri Cristo Ralc'ual ri Dios. Y cuando xtinimaj, can xtiwil ri ic'aslen ri man xtiq'uis ta, roma can xtiya' iwánima riq'uin. ");
INSERT INTO cakNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Después, ri Jesús xuc'ut chic ri' jun mej (bey) chiquiwech ri ru-discípulos. Raja' can ja' chuchi' ri choy (ya') rubinan Tiberias, chiri' xuc'ut-wi-ri' chiquiwech. Y quiere' xu'on cuando xuc'ut-ri' chiquiwech ri chuchi-ya': ");
INSERT INTO cakNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ri Simón Pedro, ri Tomás ri ni'ix chuka' Dídimo che, ri Natanael ri aj pa tenemit Caná ri c'o pa Galilea, ri je ca'i' ralc'ual ri Zebedeo y je ca'i' chic discípulos, can quic'uan-qui'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Y ri Simón Pedro xu'ij chique ri ch'aka chic discípulos: Ren yebenlesaj-pe quer pa ya', xcha'. Y ri ch'aka chic xqui'ij: Roj chuka' jojbe awiq'uin. Y can conojel xebe y xe'oc-e pa jun canoa; y más que jun ak'a' xec'ase', man jun quer xquilesaj. ");
INSERT INTO cakNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Y cuando xsakar-pe, ri Jesús xapon y xbepa'e-pe chuchi-ya'. Pero ri discípulos man xquitemaj ta rech ancu'x (anchique) ri pa'l chuchi-ya'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Y raja' xuc'utuj-apo chique: ¿C'o quer iwiq'uin chi niya' chue? xcha' raja'. Y ri discípulos xqui'ij-pe che: Man jun quer c'o kaq'uin, xecha'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xpe ri Jesús xu'ij-apo chique: Tiya-ka la ya'l ri anchok che ye'ilesaj quer pa ya', pa ru-derecha ri canoa, y can jec'o quer xquie'ilesaj, xcha'. Y ri discípulos can ja' xquiya-ka ri ya'l pa ya'. Y xa man yetiquier ta chic niquilesaj-pe ri ya'l pa ya', roma can q'uiy quer ri xquiya-qui'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Y ri jun discípulo ri can xojo'x roma ri Jesús, xu'ij che ri Pedro: Ja ri Ajaf Jesús ri nich'o'n-pe, xcha'. Y ri Simón Pedro, can xe xuc'oxaj quiri', can ja' xucusaj ri jun chic rutziak ri rulesan-e chirij y xuq'uiak-pe-ri' pa ya' chi ntel-pe. ");
INSERT INTO cakNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Pero ri ch'aka chic discípulos can pa canoa xe'el-wi-pe, y quichiriren-pe ri ya'l nojinak riq'uin quer. Man naj ta jec'o-apo parui' ri ya', xa jun cien metros. ");
INSERT INTO cakNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Y cuando reje' xeloka chuchi' ri ya' y xe'el-pe chupa ri canoa, xquitzu' chi c'o jun k'ak' boxon y kajinak chic utz ri rachak-k'ak', y parui' c'o jun quer sa'on-ka, y c'o wey chuka'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ri Jesús xu'ij chique: Tic'ama-pe jujun quer ri c'aja' oc ye'ilesaj, xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro xbe y xjote-apo chupa ri canoa, y xberuquira-pe ri ya'l nojinak riq'uin quer y xujic'-pe c'a chuchi-ya'. Can q'uiy-wi ri nima'k tak quer ri jec'o chupa ri ya'l. Ciento cincuenta y tres quer ri xquiya-pe-qui'. Can q'uiy, pero ri ya'l man xk'ach'itaj ta. ");
INSERT INTO cakNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Y ri Jesús xu'ij chique ri ru-discípulos: Quixampe y quixwa', xcha'. Y can conojel ri discípulos ri jec'o chiri', xquina'ej chi ja raja' ri Ajaf Jesús. Romari' man jun chique reje' nibano ta cowil nuc'utuj che: ¿Jat ancu'x (anchique) ret? ");
INSERT INTO cakNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Y ri Jesús can ja' xbin-apo quiq'uin y ja xujach-ka ri wey y ri quer chiquiwech chi quiewa'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Y jare' ri rox mej (paj) chi ri Jesús xuk'alajij-ri' chiquiwech ri ru-discípulos, cuando c'astajinak chic pe chiquicojol ri caminaki'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Y cuando xecolaj yan conojel, ri Jesús xuc'utuj che ri Simón Pedro: Ret Simón ri ralc'ual ri Jonás, ¿yinajo' como más que chiquiwech ronojel re'? xcha' che. Y ri Simón Pedro xu'ij: Ajaf, can quiri-wi. Ret aweta'n chi jatinjo'. Y ri Jesús xu'ij che: Xa can yinajo', can quie'ayuk'uj y quie'achajij ri yinquitzeklebej, roma reje' je anche'l alaj tak ral ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Y ri Jesús xuc'utuj chic che jun mej (bey): Ret Simón ri ralc'ual ri Jonás, ¿can yinajo-wi? xcha' che. Y ri Pedro xu'ij: Ajaf, can quiri-wi. Ret aweta'n chi jatinjo', xcha'. Y ri Jesús xu'ij: Xa can yinajo', quie'ayuk'uj y quie'ac'uaj ri nu-ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Y pa rox mej (paj), ri Jesús xu'ij che: Ret Simón ralc'ual ri Jonás, ¿can yinajo-wi? xcha'. Y Pedro can ja xbison-ka ránima, roma ja rox mej (paj) re' ri xc'utux che roma ri Jesús: ¿Can yinajo'? C'ajari' ri Pedro xu'ij: Ajaf, ret can ronojel aweta'n. Can aweta'n chi jatinjo'. Y ri Jesús xu'ij chic che: Can quie'ayuk'uj y quie'achajij ri nu-ovejas. ");
INSERT INTO cakNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Can ketzij ri nin-ij chawe: Cuando c'a jat c'ajol-achi y man jani más ajuna', can ayon ret naxim apa y anchi' najo' jabe, can jabe-wi. Pero cuando xcarijix, xquie'aric' ri ak'a' chech jun ri man jatrojo' ta, y raja' xcatruxim chi jatruc'uaj anchi' man nika ta chawech, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri xu'ij ri Jesús, can chi nuk'alajij anchique camic ri xti'an che ri Pedro chi nuya' ruk'ij ri Dios. Y cuando ri Jesús ru'in chic ronojel ri', xu'ij chuka' che ri Pedro: Quinatzeklebej, xcha' che. ");
INSERT INTO cakNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Ri Jesús y ri Pedro je-benak, ri Pedro xtzu'n can chirij y xutzu' chi c'o jun chic discípulo ri benak chiquij. Y ja discípulo ri' ri can xojo'x roma ri Jesús y ja raja' chuka' ri xrak'e-apo chuc'u'x ri Jesús cuando xqui'en ri jun lok'olaj wa'in, y ri xc'utun che ri Jesús: Ajaf, ¿ancu'x (anchique) ri xtijacho awichi? ");
INSERT INTO cakNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Cuando ri Pedro xutzu' ri discípulo ri', xuc'utuj che ri Jesús: Ajaf, y raja' ¿anchique xtu'on can? xcha'. ");
INSERT INTO cakNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Y ri Jesús xu'ij che ri Pedro: Xa ren ninjo' chi raja' c'a q'ues cuando xquipe chic jun mej (bey), man jun nic'atzin-wi chi jari' ri nanojij. Ret xa quinatzeklebej, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ri jun tzij ri xu'ij ri Jesús, can xbin-ka rutzijol quiq'uin ri kach'alal. Romari' ri kach'alal can xquinojij-ka chi ri jun discípulo ri' can manak-wi xticom. Pero ri xu'ij ri Jesús xa man quiri' ta ntel chi tzij, roma raja' xe xu'ij: Xa ren ninjo' chi raja' c'a q'ues na cuando xquipe chic jun mej (bey), man jun nic'atzin-wi chi jari' ri nanojij. ");
INSERT INTO cakNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ri discípulo ri ninatex-ka, can ja raja' ri tz'ibayon can ronojel ri c'o chupa ri jun libro re'. Can keta'n c'a chi ketzij ronojel ri nuk'alajij, roma raja' can xutzu-wi. ");
INSERT INTO cakNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Y c'a c'o q'uiy samaj xeru'on ri Ajaf Jesús ri man je-tz'iban ta can chupa ri libro re'. Roma xa ta chijujun ri samaj xeru'on ri Jesús yetz'ibes ta, nin-ij chi ri rech-ulef man nu'on ta chi yeyec ronojel ri libros ri anchi' yetz'ibes-wi ri samaj ri', roma can q'uiy ta ri libros ntel. Amén.");
INSERT INTO cakNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Nimalaj Teófilo, chupa ri jun libro ri xintak-e chawe na'ey, nutz'iban-e ri samaj ri xutz'om can ru'onic ri Jesús, y xuc'utula' can chuka' chiquiwech ri winak. ");
INSERT INTO cakNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Y xutanaba' can chupa ri k'ij cuando raja' xbe chila' chicaj. Pero cuando raja' c'a man jani tibe chila' chicaj, riq'uin ri ruchuk'a' ri Espíritu Santo xu'ij chique ri ru-apóstoles ri jerucha'on, ri anchique nic'atzin niqui'en can, cuando raja' xtibe. ");
INSERT INTO cakNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Y raja' xu'on sufrir y xcamises. Pero cuando c'astajinak chic pe, xuc'ut-ri' chiquiwech. Cuarenta k'ij ri quiri' xu'on. Y c'o ch'aka chic ex ri xeru'on chi quiri' tinimex chi can q'ues-wi. Y c'o chuka' ri xutzijoj chique chirij ri ru-gobierno ri Dios. ");
INSERT INTO cakNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Y jun mej (bey) cuando ri Jesús y ri ru-apóstoles quimolon-qui', ri Jesús xu'ij chique: We' pa tenemit Jerusalem quixc'ue-wi y tiyobej c'a xtoka na ri ru'in ri Dios chi nuya-pe chiwe. Ren can xintzijoj yan chiwe, y cami jari' tiyobej. ");
INSERT INTO cakNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Roma rix iweta'n chi ri Juan riq'uin ya' xeru'on-wi bautizar ri winak; pero rix, pa jun jani' k'ij apo, riq'uin ri Espíritu Santo xquix-an-wi bautizar, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Y ri quimolon-qui' xquic'utuj che ri Jesús: Ajaf, ¿ja como ri tiempo re' ri jojacol roj israelitas y ja chic jun kawinak nibano gobernar kachi? xecha' che. ");
INSERT INTO cakNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Pero ri Jesús xu'ij chique: C'a ja na ri Dios xti'in jampe' xtibanataj ri', y man nic'atzin ta chi nitemaj rix. ");
INSERT INTO cakNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero rix can xtic'ue' iwuchuk'a' cuando ri Espíritu Santo xtika-pe pa iwi', y can xquinik'alajij chiquiwech ri winak pa tenemit Jerusalem, y chiquiwech ri winak ri jec'o pa ch'aka chic tenemit we' pa Judea y ri pa Samaria, y chuka' chiquiwech conojel winak pa ronojel rech-ulef, xcha' ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Y can xe ri tzij ri' ri xu'ij can. Y ri jec'o riq'uin chiri', can xquitzu' cuando xbe chicaj y xoc-e pa jun ajawa' (mukul) y manak chic xquitzu'. ");
INSERT INTO cakNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Y ri apóstoles c'a yetzu'n-e chicaj cuando ri Jesús xbe-e, c'aja' xquina' jec'o yan ca'i' achi'a' quiq'uin, ri quicusalo'n sak tak tziak. ");
INSERT INTO cakNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Y ri ca'i' achi'a' ri' xqui'ij chique ri je ru-apóstoles ri Jesús: Achi'a' ri jix aj-Galilea, ¿anchique roma rix jixtzu'n chicaj? Ri Jesús ri xitzu' chi xbe chicaj cami, can quila' xtu'on xtipe chic jun mej (bey). Y can anche'l xu'on xbe-e, can quiri' chuka' xtu'on pa ruca'n mej (bey) cuando xtika-pe chila' chicaj, xecha' chique. ");
INSERT INTO cakNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Y ri apóstoles xe'el-pe chiri' parui' ri juyu' rubinan Olivos, y xetzolaj pa tenemit Jerusalem. Ri Olivos man naj ta c'o-wi che ri Jerusalem, xe la'k jun kilómetro. ");
INSERT INTO cakNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Y cuando xe'apon, xejote-e pa ruca'n piso chi ri jay ri anchi' can jec'o-wi: Ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo ri ralc'ual ri jun achi rubinan Alfeo, ri Simón ri c'o quiq'uin ri achi'a' ri ni'ix celadores chique, y ri Judas ri rach'alal ri Jacobo. ");
INSERT INTO cakNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Y conojel reje' can siempre niqui'en orar, junan cánima conojel. Jec'o chuka' ixoki', y chuka' ri María ri rute' ri Jesús, y ri je rach'alal ri Jesús. ");
INSERT INTO cakNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Y jun k'ij cuando quimolon-qui' jun je ciento veinte kach'alal, ri Pedro xbepa'e-pe chiquiwech y xu'ij chique: ");
INSERT INTO cakNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Wach'alal, ri jun ka-rey ri xc'ue' ojer can ri xubinaj David, raja' rutz'iban can ri tzij ri xeruya' ri Espíritu Santo pa ránima. Chupa ri xutz'ibaj can raja', c'o ri nu'ij chirij ri Judas ri xuc'uan quibey ri winak ri xbequitz'ama-pe ri Jesús. Romari' can quiri' na-wi ri xbanataj. ");
INSERT INTO cakNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Y ri Judas ri' can xc'ue' kaq'uin, y c'o samaj ri xu'on kaq'uin chuka'. ");
INSERT INTO cakNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Y riq'uin ri mero ri xyo'x che roma xujach-e ri Jesús, xlok' jun ulef. Ri Judas xucamisaj-ri'. Raja' xchiquicho' rupa, y ronojel ri rupa c'a quiela' xeka-wi cuando xka pa ulef. ");
INSERT INTO cakNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Y cuando xbanataj ri', conojel ri winak aj-Jerusalem xquina'ej, y romari' Acéldama x-ix che ri ulef ri'. Y jari' ri bi'aj ri niquiya' reje' che jun ulef richi quic'. ");
INSERT INTO cakNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Quiere' xbanataj, roma chupa ri libro rubinan Salmos bin can: Can timalix can ri rocho y man jun winak tic'ue' chupa. Y chuka' nu'ij: Y jun chic toc pa ruq'uiexel chi nipa'e' can chech ri rusamaj, nicha'. ");
INSERT INTO cakNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Romari' can nic'atzin chi nakacanoj jun ruq'uiexel, pero can ja chiquicojol ri achi'a' ri can ronojel tiempo jec'o-pe kaq'uin, y can je-benak-wi kaq'uin cuando xc'ue' ri Ajaf Jesús. ");
INSERT INTO cakNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jun chique ri can jec'o-pe kaq'uin cuando x-an bautizar ri Jesús roma ri Juan, c'a cuando xbe chila' chicaj, y xel-e chikacojol. Can nic'atzin chi nuk'alajij junan kaq'uin roj chi ri Jesús xc'astaj-pe chiquicojol ri caminaki', xcha' ri Pedro. ");
INSERT INTO cakNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Y xquiya-apo quibi' je ca'i' achi'a': Jun, ja ri José ri rubinan Barsabás y niqui'ij chuka' Justo che, y ri jun chic, ja ri Matías. ");
INSERT INTO cakNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","C'ajari' xqui'en orar, y quiere' xqui'ij: Ajaf, ret ri natzu' ri cánima conojel, tac'utu' chakawech ancu'x (anchique) chique ri ca'i' achi'a' re' ri xacha' yan, ");
INSERT INTO cakNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","chi ntoc can apóstol pa ruq'uiexel ri Judas, y nipa'e' chech ri samaj. Roma ri Judas xa xuya' can ri samaj, roma ri etzelal ri xeru'on. Y cami raja' xapon yan chupa ri lugar ri anchi' utz chi napon raja', xecha'. ");
INSERT INTO cakNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Y ri achi ri xc'ue' can pa ruq'uiexel ri Judas chi ntoc quiq'uin ri julajuj apóstoles, ja ri Matías, roma pa ruwi' raja' xka-wi ri suerte chi ri samaj ri'. ");
INSERT INTO cakNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Y cuando xoka ri k'ij chi ri quinimak'ej ri israelitas rubinan Pentecostés, ri quiniman ri Ajaf Jesús quimolon-qui' pa jun jay. Can junan cánima quibanon conojel. ");
INSERT INTO cakNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Y c'aja' xquic'oxaj, c'o ri xk'ajan-pe chicaj, y can anche'l jun nimalaj quiek'ik' ri nik'ajan petenak. Y re' xunojisaj ri jay anchi' je-ch'ocol-wi. ");
INSERT INTO cakNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Y ri jec'o chiri', xquitzu' chi anche'l ruxak tak k'ak' xujachala-ri' y jujun xc'ue' pa quiwi' chiquijunal. ");
INSERT INTO cakNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Y xech'o'n-ka pa ch'aka chic ch'abel. Quiri' xbanataj roma ri Espíritu Santo xunojisaj ri cánima, y jari' ri xbano chique chi xech'o'n-ka pa ch'aka chic ch'abel. ");
INSERT INTO cakNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Y ri chiri' pa tenemit Jerusalem ri k'ij ri', je q'uiy israelitas ri niquiya' ruk'ij ri Dios ri quimolon-qui'. Je q'uiy chique ri jec'o chiri', pa ch'aka chic rech-ulef ri je-petenak-wi. ");
INSERT INTO cakNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Pero roma ri xk'ajan, ri winak xquimol-apo-qui'. Ri winak re' man junan ta quich'abel, roma man junan ta tenemit je-petenak-wi. Pero cuando ri quitzekleben ri Jesús xebech'o'n-pe, can xqui'en-wi entender, roma can pa jalajoj rech tak ch'abel xech'o'n-wi-pe. Ri winak xsatz quino'j (xsach quic'u'x) cuando xquic'oxaj re'. ");
INSERT INTO cakNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Can xsatz-wi quino'j (xsach-wi quic'u'x) roma ri xquic'oxaj, y niqui'ij chiquiwech: ¿Man je aj-Galilea ta c'a conojel ri winak ri yech'o'n re' c'a? ");
INSERT INTO cakNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Anchique roma roj can nakac'oxaj ri niqui'ij y xa man junan ta kach'abel chikajunal? yecha'. ");
INSERT I